﻿USE sofia;
DROP TABLE IF EXISTS sofia.wnu_vpl;
CREATE TABLE wnu_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES wnu_vpl WRITE;
INSERT INTO wnu_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yisas munon inubersiau tari eng wonou urimagrari nomgur qanam ir yarer eng unum eng ete: Yisas wo Debit wonou tumbigi end unor baurei. Ne Debit wo Abraham tumbigi. ");
INSERT INTO wnu_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ne Abraham wonou wau eng Aisak; ne Aisak Yekop wonou ur, ne Yekop Yuda ne umomori ne umuragrari big wurinou ur. ");
INSERT INTO wnu_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ne Yuda wo Peres Sela nob wurinou ur, ne wurinou unor eng Tamar. Ne Peres wo Hesron wonou ur, ne Hesron wo Ram wonou ur. ");
INSERT INTO wnu_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram wo Aminadap wonou ur, ne Aminadap wo Nason wonou ur. Ne Nason wo Salmon wonou ur. ");
INSERT INTO wnu_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ne Salmon wo Boas wonou ur ne wonou unor eng Rahap. Boas wo Obet wonou ur, ne wonou unor Rut. Ne Obet wo Yesi wonou ur. ");
INSERT INTO wnu_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ne Yesi wo Munon baraitari Debit wonou ur. Ne Debit wo Solomon wonou ur, ne wonou unor eng qoan Uraia bauor eng. ");
INSERT INTO wnu_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon wo Rehoboam wonou ur, ne Rehoboam Abiya wonou ur, ne Abiya Asa wonou ur. ");
INSERT INTO wnu_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa Yehosapat wonou ur, ne Yehosapat Yoram wonou ur. Ne Yoram Usia wonou ur. ");
INSERT INTO wnu_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ne Usia wo Yotam wonou ur, ne Yotam Ahas wonou ur, ne Ahas Hesekia wonou ur. ");
INSERT INTO wnu_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekia wo Manase wonou ur, ne Manase Emon wonou ur, ne Emon Yosaia wonou ur. ");
INSERT INTO wnu_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosaia wo Yehoiakin umuragrari big wurinou ur. Qen end Isrel munon yamangar Babilon ite ir uyort igour eng. ");
INSERT INTO wnu_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Uyort ir igour qen end Yehoiakin wo Sealtiel wonou ur. Ne Sealtiel Serubabel wonou ur. ");
INSERT INTO wnu_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ne Serubabel Abiut wonou ur, ne Abiut Eliakim wonou ur, ne Eliakim wo Asor wonou ur. ");
INSERT INTO wnu_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asor wo Sadok wonou ur, ne Sadok wo Akim wonou ur, ne Akim wo Eliut wonou ur. ");
INSERT INTO wnu_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ne Eliut Eleasar wonou ur, ne Eleasar Matan wonou ur. Ne Matan wo Yekop wonou ur. ");
INSERT INTO wnu_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ne Yekop wo Yosep wonou ur. Ne Yosep wonou ubeni eng Maria. Munon inubersiau tari Yisas wonou unor eng. ");
INSERT INTO wnu_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","End ne Abraham yurau eng isi yarab Debit qangang eng 14-ende. Ne bo Debit qangang end isi yarab munon Yuda Babilon end irab uyort igour eng gor yurau qangang 14-ende. Ne gor uyort igour qangang eng isi yarab Munon inubersiau tari Yisas unor bauor eng gor 14-ende. ");
INSERT INTO wnu_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Munon inubersiau tari wo unor bauor eng werei ende. Wonou unor Maria Yosep bainer qamb wot maribigumirei. Qen end ombur me qibaiau igama Qenu wonou Igomurur qau eng Maria seara qugurau igoai. ");
INSERT INTO wnu_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Qen end Maria wo Yosep bai qamb maribigumir end ne Maria wo qugurau igama gab ne Yosep wo munon qomon qoregen qas ebet igo. End ne diban Maria wogub quine qinininginer qamb qi wegib at igoai. ");
INSERT INTO wnu_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Wo misir ende igub igama ne Qenu wonou munon enger ger darab qob ger dibes nob qamara inig garei. Inig gea nob qamar: “Yosep, Debit tumbigi, ne Maria baib qamb me qinining. Wo qugurau igo eng Igomurur qau seara qugurau igo. ");
INSERT INTO wnu_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","End wo wau ger baia gab unum Yisas bigiban. Eng wo wonou munon yurau qomon borut igour eng wurit birogonima sarog igorubour.” ");
INSERT INTO wnu_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Qob eng dibentar eng Qenu wonou qoan qamara munon miteri qamb gumatemir ete igoar eng dibentarei: ");
INSERT INTO wnu_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Yamangar yorou qoregen ger wonou ar igo qugurau igoriba. Igo wau ger baub unum biginer eng Emanuel.” Unum eng qanam eng, Qenu inopuri ten igo. ");
INSERT INTO wnu_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ende qamara Yosep bo der bugab Munon Aib enger nob qamara igor end bo me qininingau, Maria baurei. ");
INSERT INTO wnu_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Se baub me nob qiroau igama Maria wau wonou ar baurei. Baia Yosep unum bigor eng Yisas. ");
INSERT INTO wnu_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yisas unor munai ginam aib Betlehem end baurei. Yuda wurinou ai end. Qen end munon baraitari Herot ai eng qoat igoai. Ende igama ne qen geret munon yurau qei worom diat wes end igo tapai wanunger igour eng Yerusalem end diab qamamir: ");
INSERT INTO wnu_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Wau ger unor se baiar eng igoi baraiburab Yuda wurinou munon baraitari igoribar eng eret igo? In wonou tapai worom diat wes end igo gab wot mismisirub qamb yoroun.” ");
INSERT INTO wnu_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Munon baraitari Herot ende igub borusi qiet ne oau biriberi norei. Ende aba ne Yerusalem munon gugum gab borusi qiet ne yariamirei. ");
INSERT INTO wnu_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ende at ne Herot der Pris munon baraitari ne qomon imbigau munon eng gagar wurit qamara yar qiumunimari wuri qebi qamar: “Munon inubersiau tari eng wo ginam eret unor baiba?” ");
INSERT INTO wnu_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ende qamara wuri taui qamamir: “Yuda wurinou ginam aib Betlehem end. Mi eng abar eng qoan qob gigit qamarau munon Qenu qamara gumatemir eng ete: ");
INSERT INTO wnu_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","An munon Betlehem Yuda wurinou ait igoumon eng, an munon unum diban igoumon end Munon Aib ger aninou yurau end dari ne Isrel munon oroar igama an unum diban igoruboumon.” ");
INSERT INTO wnu_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ne Herot munon worom diat wes eng diamir eng wuriba qiumuni qi wurinob tapai qen mait gamirei qi eng wurinob qemerib qamb wuriba qiumunimorei. ");
INSERT INTO wnu_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Qiumuni qob qamarari igub wogub wuriimurimb qamb qamar: “An isub mom asi qibi gab qas wogub diab ye bo sir mom yiimbig qamarari isub gibam.” ");
INSERT INTO wnu_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Qob eng ende qamara igub wogub mom ende oboub qamb isumirei. Isub gamin eng tapai worom diat wes end igo gamir eng bo wuri isub etemirt wes end isa toat isub igurei. Tapai eng isub munai mor wau unor nob igour eng maribig erer end igoai. ");
INSERT INTO wnu_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Wuri tapai eng gab borusi mismisir isub igurei. ");
INSERT INTO wnu_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Isi yarab wau unor Maria nob igour munai mor end isub ibagamirei. Ibag gamaur wat bugab mismisiramirei. Ende at ne abau dagot mi qenenginob ne uyan qogom nob ne welya qogomnob uyabriamir eng dagot banam ar utemirei. ");
INSERT INTO wnu_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ende at wogub inemirei igo bo yonam irab Herot imbigunor qamb itum end inig Qenu geari wuritaisi qamara igub ai tap ger toat wurinou ginamt iramirei. ");
INSERT INTO wnu_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Iroari wogub qen geret Yosep bo inerei igo inig Munon Aib enger gea nob qamar: “Wau unor nob oromar iua Isip umo isar. Is end igamari bo diarar qamb qob anit bigine igub diarar. Herot wau eng waramb qamb yogorau munon wuriimurima gub qamb asi qib igorubour.” ");
INSERT INTO wnu_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ende qamara igub itum end Yosep der wau unor nob oramar ai Isip umo isumirei. ");
INSERT INTO wnu_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Is end igamari qen geret Herot uma wogub diorub qamb qoat igurei. Mi eng ebeter eng Qenu qob qoan ete qamara munon miteri qamb gumatemir eng irimaniamorei: Yonou wau Isip end igama wot qemerine dieriba. ");
INSERT INTO wnu_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Qen end Herot mom imbigorei, “Qo, munon worom diat wes eng apand yimirimot qamamirei” qamb oau biriberi norei. Ende at wogub munon qei wuriimurima Betlehem end ne ginam qani-qani end isub munonbor wau unor se wuriba igama ibag ne togun ombur me wab igamari ibag eng igaramb ugaiar qamb qamara ende ebetemirei. Eng ebeter eng munon worom dearaut eng diab song ar nob qamarari igor end ebeterei. ");
INSERT INTO wnu_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Mi eng ebeter eng Qenu qob ger qamara munon Yeremaia qoan ir gumater eng irimaniamorei. ");
INSERT INTO wnu_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ete qamarei: Toau ger Rama end igumirei, toau eng borusi toubet eab ende at igurei. Resel wonou wau wurit eab igoai, ende ea ne munon qei oau meinsiorun qamb etemir eng ue, wonou wau mom umb uburemir end. ");
INSERT INTO wnu_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Qen geret Herot mom uma wogub, Munon Aib enger ger der Isip end isub Yosep nob qamara inig gea qamar: ");
INSERT INTO wnu_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Ne munon wau waramb at igour eng qo umumirei, der wau unor nob oramar Isrel ai end bo irar.” ");
INSERT INTO wnu_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ende qamara Yosep der wau unor nob oramar Isrel ai end bo diamirei. ");
INSERT INTO wnu_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Diorub qamb igumir eng Herot wonou wau Arkelaus ur uput qamb munon baraitari igo Yuda oroar igo. Ende qamarari igub Yosep borusi yariamorei. Ende aba Qenu bo inig gea nob qamara igub ai Galili end iramirei. ");
INSERT INTO wnu_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Irab is munai ginam Nasaret eng mom baurei. Wuri munai ginam Nasaret mom baumir eng munon miteri qamb gumatemirei igoar eng irimaniamorei: Munon eng wot Nasaret munon ende wot qomorubour. ");
INSERT INTO wnu_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Qen end Yon munon ya obotar wurimaragansi igoar eng Yuda wurinou seger ait end igo munon qob wurinob qamb igoai. ");
INSERT INTO wnu_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Qob wurinob qamb qamar: “Qenu wonou bibis biginer eng piara. End an qomon boru mogirt wab wagar,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yon wo sarau eng ebeiner end qoan ir qob gigit qamarau munon Aisaia ete qamb gumaterei: Munon ger seger ait end igo ete qamb atag ab igoriba: Munon Aib tap imotet musitet igama wo der eng isiba. ");
INSERT INTO wnu_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yon wo wai kamel im end mi goan barsi qumani ne wai goan ger ba tuen barsi mi goan uiebig qumani igoai. Wo mi nub igoar eng qubusemsai qapi nob nub igoai. ");
INSERT INTO wnu_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Munon Yon qob qamara igub qamb yariamir eng ginam eng gagar: Yerusalem, ne Yuda ne ginam ya Yordan qani-qani igour eng. ");
INSERT INTO wnu_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ende yarab wurinou qomon boru dibes qamarari ya Yordan end wurimaragansiarei. ");
INSERT INTO wnu_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Qen end Parisi Sadyusi nob Yon munon ya obotar wurimaragansi igoar eng igub gub qamb isumirei. Isari Yon ibag qamar: “An mani quterag gas ende. Qenu aningarambar eng your aninob qamara igub qoaub at igoumon? ");
INSERT INTO wnu_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","An qomon boru mogirt wab wogub igo eng aninou qomon end ba dibesiarar. ");
INSERT INTO wnu_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Aninou uyes der ete qamb igoumon, in Abraham tumbigi end Qenu maigas me iningareminerei, qamb igoumon eng Qenu wo qeemben nomon e wurinob qamara Abraham tumbigi dari an uput qamb igorubour. ");
INSERT INTO wnu_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Bei ger nam qur musub me biga gab suoub qamb qo arsi igo. Nam qur musub me biginer eng tari ten wabur mutet ariramari oeiba. ");
INSERT INTO wnu_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ye yat anmaragansiaum eng an oau apand buroumon eng imbigar qamb. Ego munon ger ye qanamt yariner eng qeretutnob igoriba. Ye wonou goten yau ba utin eng pi isub gab ba me utinei. Munon eng Igomurur qau ba mutet ten anmaragansieriba. ");
INSERT INTO wnu_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Wo sobor baub ten qib igo. Wit qur sair ten ombosairmari unab ibibima qur dara ne sair moon gusit bis wes qiumunima mut nat oab igo end guma oeiba.” ");
INSERT INTO wnu_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Qen end Yisas Galili wogub yar ya Yordan end isorei. Isub is Yon yat yemaragansi qamb isorei. ");
INSERT INTO wnu_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Isa Yon qes wara nob qamar: “Ne ye yat nemaragansierin qamb yaran ne? Ye me nemaragansierinei. Ne ye yemaragansierinen eng uber.” ");
INSERT INTO wnu_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ende qamara Yisas taui nob qamar: “Ue, see ye nonob quraum gas ende eb. Ne ende ebeinen eng Qenu wonou qenunga gas ende ebeiban.” Ende qamara Yon qob toat ende ebeterei. ");
INSERT INTO wnu_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yon ende ya obota wogub ne Yisas ya qurt naget igoar eng wogub ya gabut deara ne tat qitend miroau gas ende ebeterei. Aba geari Qenu wonou Igomurur qau morogan wamariau gas ende at dererei, darab wot begentarei. ");
INSERT INTO wnu_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ende aba qob toau ger tat et qitend igumir eng ete at qamarei: “Wau eng yonou wau ten, sig borusi mom qenunget igoum,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ende aba wogub ne Igomurur qau Yisas mot ai qengerenget end isorei, isa Satan warigesi qamb. ");
INSERT INTO wnu_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Is end igo mani me niau, ar igama igoi worom 40 ne itum 40-ende ar igoi wogub borusi minemb igoai. ");
INSERT INTO wnu_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ende igama Satan diab nob qamar: “Ne Qenu wau igo gab eng nomon e gagar nob qamara mani qibi waria nub igoar.” ");
INSERT INTO wnu_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ende qamara Yisas nob qamar: “Munangit mani nub qas igomot me igour, Qenu wonou qob maigas qamb igo qi eng munon ger igub mom oabig igo eng mani niau gas ende nonogursia igomot igo.” ");
INSERT INTO wnu_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","6","Ende qamara ne Satan Yisas bo mot ginam qau aib end irarei. Irab qamara Yisas inorou munai aib qirer sig erer qitend naga nob qamar: “Ne Qenu wau igo gab eng, ende naget igo orubor ag qumo is. Isa Qenu wonou qob igo end wonou enger imurima darab nebeari mesenau isub mi waramb me uminenei.” ");
INSERT INTO wnu_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ne Yisas taui qamar: “Eng gor Qenu qob ete igo: nonou Munon Aib Qenu eng me wariges qem.” ");
INSERT INTO wnu_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ende qamara wogub Satan Yisas bo mot ai qaur sig erer qitend irarei. Irab munon yurau ai qent gugum wurinou mi uber-uber sirbiga gea nob qamar: ");
INSERT INTO wnu_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","“Mi uber-uber e gagar gugum gab qoaguruiman eng yonou. Munon ger mi uber-uber e gugum ba wonosierib eng yet gamaur wat bugab yet simot ea eng utibam. End ne, ne baib qamb eng ende yesiara eng mi eng gagar nenet wegibam.” ");
INSERT INTO wnu_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ne Yisas taui qamar: “Satan, qand yewogub iua. Qob ger ete gumatemirei igo: Munon Aib Qenu eng qas wot igub igoarar.” ");
INSERT INTO wnu_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Qen end Satan seret Yisas wogub qoa ne enger darab Yisas nonogursiamirei. ");
INSERT INTO wnu_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yisas igor eng Yon baab uyort bigumirei igama qamarari igorei. Igub wogub bo ai Galili end isorei. ");
INSERT INTO wnu_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Wonou ginam qenen Nasaret eng wogub bo is Kaperneam end igoai. Munai ginam Kaperneam eng Galili ya tai eng gabut igoai. Munai ginam eng ai aib Sebulon Naptali nob end igoai. ");
INSERT INTO wnu_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Wo mi eng ebeter eng qoan Aisaia ete miteri qamb gumater eng irimaniamorei: ");
INSERT INTO wnu_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Sebulon Naptali ai nob igama ai tap ya tai Galili gabut end yar ya Yordan wes end isorei. Ai Galili eng munon yurau ar wurinou. ");
INSERT INTO wnu_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Munon qomon boru ten igorunor eng begen aib gubour. Munon ai itum end igo umub at igour eng begen wurit begeneriba. ");
INSERT INTO wnu_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Qen end Yisas qanambig wonou qob dibes wurinob qamar: “Aninou qomon boru mogirt wab wagar. Qenu wonou ginamt bibis biginer eng qo piet igo,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ende qamb wogub ya tai Galili gab eng toat isub gar eng munon ombur igurei. Ger eng Saimon unum ger Pita, ne ger eng wonou umour eng unum Andru. Ombur dob ya tai end arir yag wai ba igurei. ");
INSERT INTO wnu_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ombur ende ibag wurinob qamar: “An sarau eng wogub ye yenob qiroari munon bo yagwai baub igoumon gas ende bo munon maigas ende at wuribaunon eng werei animbigibam.” ");
INSERT INTO wnu_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ende qamara qob gari igub wurinou dob eng gagar bogubogi wogub nob isumirei. ");
INSERT INTO wnu_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Isub-isub ne ibagamir eng munon ombur bo ibagamirei. Munon ombur eng Yems Yon nob, wurinou ur unum Sebedi. Wuri gor wurinou ur nob tabint igo dob musub igamari is ibagamirei. ");
INSERT INTO wnu_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ibag wurinob qamara wurinou dob eng urt wogub nob isumirei. ");
INSERT INTO wnu_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Isub munon ginam-ginam ai Galili igo eng gugum isub wurinou Qenut igub igour munai mor end isub Qenu wonou bibis qob uber eng wuriimbig wurinob qamb, ne munon ai bigau igaramor eng ne toar ar qei igara igour eng wurimusub ende at qib igoai. ");
INSERT INTO wnu_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ende at qiroa qob toau ai Siria eng gugum isa igumirei. Igub munon toar wes-wes igara igour eng ne git goan uter igara igour eng, ne aibigau igarama igour eng, ne uben goten gurumot uburerei igama igour eng gagar oramar yarari wurimusub igoai. ");
INSERT INTO wnu_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ende aba gab Galili munon ne Dekapolis, ne Yerusalem ne Yuda munon ne ya Yordan wes eng gugum toat qib igurei. ");
INSERT INTO wnu_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yisas munon yurau aib eng ende toari ibag wonou ai qaurent ir bugab igoai. ");
INSERT INTO wnu_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Igama wonou imbigau yurau eng yar qouimari wuriimbig qamar: ");
INSERT INTO wnu_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Munon qei Qenu magqurt, in munon uber ue qamb igour eng Qenu wonou bibis end igo mismisir igorubour. ");
INSERT INTO wnu_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Munon qei wurinomi toubet eab igorunor eng Qenu wuri oau meinsera uberetorubour. ");
INSERT INTO wnu_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Munon qei wurinomi bumai wogub qib igorunor eng mismisirunor. Qenu ai qen e wurit waga qoat igorubour. ");
INSERT INTO wnu_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Munon qei qomon qoregen end igorub qamb minemb qiyo yat abau nami ende ebet igour eng mismisirunor, Qenu wuriseara bo qur di igorubour. ");
INSERT INTO wnu_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Munon qei igo qei musub mom wuri qenungar igorunor eng Qenu gor wurimusub qenungariba. Ende aba mismisir igorubour. ");
INSERT INTO wnu_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Munon misir boru ger ue, ar uber igoriner eng Qenu gab mismisiriba. ");
INSERT INTO wnu_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Munon qei igo qei yogorari oau mein big wuriombopur igo eng Qenu yonou wau wot qamara mismisiriba. ");
INSERT INTO wnu_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Munon qei qomon qoregen toat qib igamari qei der ar wurisumungasiorunor eng mismisirunor, Qenu wonou bibis wonou ginamt igo eng wurinou. ");
INSERT INTO wnu_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ne an ye yetoat qib igamari animbag qob isi anit qamb a qob song-song anmurimar qamb a ende ansiarari ibag an mismisirar. ");
INSERT INTO wnu_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Wuri ende ansiarari ibag eng, an sig-sig mom wurimusiarar. Qomon ende obounon eng, Qenu mi sig uber eng wonou ginamt end anit iyeter eng bauboumon. Qoan qob gigit qamarau munon wurisiamir gas ende ansiorubour.” ");
INSERT INTO wnu_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ende qamb qamar: “An tomon qer uber gas ende. End tomon suumi biginenei igama namani iriget qer iim burinerei igama ne bo maigas aba bo qer uber buriba? Ende gab song arir wogub munon napi qib igour. ");
INSERT INTO wnu_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ne gor an ai gugum wurinou urut begen gas ende. Munai ginam aib ger ai deberit igoriner eng urut qarub waber me igorinerei. ");
INSERT INTO wnu_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ne gor, munon ger munai mor itum gab urut uruguni begesierib qamb mai uruguni egi erobon bigiba? Ende ue, wo diban biga begeneriba. ");
INSERT INTO wnu_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Eng gas ende gari, an qomon uber qo qob uber eng mom imbigoumon eng munon qei abari gab Tain aib wonou ginamt igo eng wot mismisir igub igorubour.” ");
INSERT INTO wnu_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ende qamb qamar: “An ete misir me igar. Ye ag e derem eng Moses qomon gumater eng nob munon miteri qamb gumatemir eng nob biisiteib qamb deremei qamb misir me igar, ue. Ye wuri qob qamamir eng ebine irimaniom qamb deremei. ");
INSERT INTO wnu_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","An eng igar: Tat ai nob eng apand uburubour. Ego qob gumatemir eng nob qomon qob eng nob anir ger bais me qoinerei. Wonou ende igama mi gugum dibent uburiba. ");
INSERT INTO wnu_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","End ne munon ger qomon qob qomourt ger gab eng mi ue qamb munon qei me wuriimbiginer eng, Qenu wonou bibis end munon eng wo gor unum diban me igorinerei. Ego munon ger qomon gugum qeemben qamb munon wuriimbiginer eng wo Qenu wonou ginam end irab wonou bibis end unum diban igoriba. ");
INSERT INTO wnu_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","End aninob quraum: An qomon imbigau munon nob Parisi nob wuri qomon uber toat igour eng an wuritanami me obounon eng an Qenu wonou ginamt bibis end me igorunanei.” ");
INSERT INTO wnu_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“End qoan tonoanb ete aninob qamarari igumon eng, igeig me yamar, munon ger igeig yab munon waraminer eng qereimau munon barai wo giba. ");
INSERT INTO wnu_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ego see ye ete aninob qemerini: munon ger munon qei wurit misiringetara eng baab ba uyort bigubour. Ne gor, wonou umomt qiyo umourt qob isi wot qemeriner eng mot kaunsel wurit isubour. Ne munon ger, geret, ‘ne misir ue tagug ar,’ ende wot qemeriner eng munai ginam boru end isiba. ");
INSERT INTO wnu_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Ne Qenut mian yemb qamb mi ba mian yab big igour nam qab qani end isub ne bo munon qei nenet mindigar qob qamb qiyo, a ieri negab qiyo ende at igamari misir igub gab eng, mi ba isinen eng mian yab bigau nam qab qani end big wogub bo igeser irab wuri qomon eng nesi igour eng wurinob qamb wair wogub bo yarab mian yom. ");
INSERT INTO wnu_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ne munon ger uyort ne bigib qamb nomot isa gab ne an ombur qataben isub igo ombur qob qamb qoregensiarar. Ende me ebeinen eng munon qob qereiminer end nomot isa wo bo niimurima burtuum wurit isa wuri naba uyort nebigubour. ");
INSERT INTO wnu_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ende abari uyor munait igoriban. End aninob quraum, uyor munait end igo qomon eng me taui ugeinen eng uyor munai eng wogub me qoeinenei.” ");
INSERT INTO wnu_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Ne an qoan ete qamarari igumanei: yamangar ba me omboagir wagar. ");
INSERT INTO wnu_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","End ne ye ete aninob qemerini: munon ger yamangar ar mugen gab baib qamb oau nageiner eng, munon eng wo qo wonou ubeni eng mom wagau gas ende. ");
INSERT INTO wnu_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","End nonou magqur uberegent wes eng qomon boru ende aba gab eng gumoteneri arirom. Gugum igama eng nonou git goan aib eng ten ar isi munai ginam borut isinen qamb. ");
INSERT INTO wnu_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ne gor nonou uberegen eng qomon boru ger aba gab eng, soopur arirom. Ten igama eng nonou git goan aib eng ar isi boruburiner qamb.” ");
INSERT INTO wnu_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Qoan ete gor qamb igurei: munon ger wonou ubeni mom omboagir wegib qamb eng, namanimun ger gumat meimi qomon biisiteiner eng musub imbig qemeriner. ");
INSERT INTO wnu_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ego see ye ete aninob qemerini: yamangar wo ar uber umami nob igama ne umani wonou uyes ubeni weginer eng, umami wo qibaiau qomon eng biisitet igo. Munon eng wo yamangar eng wogub bo yamangar ger qoan umami omboagir wager eng bainer eng wo qibaiau qomon eng biisiteiba.” ");
INSERT INTO wnu_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Ne qob ger tonoanb ete qamarari igub igumanei: qob gag ger qamb gab eng, apand mom quraum eng me qamarar. Ende at qamb gab eng munon aib magqurt mi apand ar ende abar. ");
INSERT INTO wnu_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","End see aninob quraum: qob ar-ar qamb ne Qenu wonou ginam eng magqurt apand mom unumot qamb me nausiarar. Qenu munai ginam igo eng sig qau. ");
INSERT INTO wnu_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ne gor qob qamb quyai imbini ai qen me napiarar. Ai eng Qenu wo umi igo. Ne gor qob ar qamb munai ginam aib Yerusalem me qamarar, Munon Baraitari wonou ginam qau. ");
INSERT INTO wnu_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ne gor aninou tari end me qamarar. Tari im eng aninou maigas abari tari im qurun di qiyo oan diab end me ebinerei. ");
INSERT INTO wnu_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","An qob qomorub eng qob ete gari qamarar: Io, qo ue, ende gari qamarar. Qob nonogursiorub qamb mi unumir qomorunon eng qomon boru wonou qanam.” ");
INSERT INTO wnu_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Ne qob ger qoan ete qamarari igumanei: munon ger ne mag ig omboipima gab eng ne gor wo mag ig omboipiom. Ne nan ger omboaia gab eng ne gor wo nan ger omboai. ");
INSERT INTO wnu_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ego see ye ete aninob qemeribam: an munon ger aningarama gab an bo taui me waramar. Munon ger nan qanamt nanama gab eng bo igeser nan qanam ig bo waga waraminer. ");
INSERT INTO wnu_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ne gor, munon ger nonou mi goan ger baib qamb ne qut bigiba gab eng song bo mi goan ger ut. ");
INSERT INTO wnu_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Munon ger mi qugurau ba natab ete qamara gab: baisab bis end ye wog qamb ibitria gab ne iet me wog. Ne ar benau batet bisub wo ai maribiginer eng ne qubei wogub nonou bo imusi wo maribiginer gas ende bo maribig bis end wog. ");
INSERT INTO wnu_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Munon ger mi yeis qamb qibirat qamara gab eng me du, benau ut. Ne ger, mi net baiba gab eng gor me du, benau waga bainer.” ");
INSERT INTO wnu_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Ne gor, qomon ete eng an imbig igoumon: nonou munon banam ten eng musub ne munon qarau eng ba sumungasi. ");
INSERT INTO wnu_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ego see ye ete aninob qemerine igar: aninou munon banam qenunget igoumon gas ende aninou munon qarau eng ende wuri qenungar ne Qenut qebi qamarari munon aningaramb igorunor eng wurimeinsieriba. ");
INSERT INTO wnu_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ende obounon eng aninou tain wonou ginamt igo eng iitari igoruboumon. Ne wo worom aba munon wot igub igour eng ne me wot igub igour eng gugum wurit asi igo. Ne gor ya weima munon qomon uber ebet igour eng ne qomon boru ebet igour eng qeemben wurit dara uber igour. ");
INSERT INTO wnu_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","End munon an ubersiari gab an bo taui wuri ubersiorunon eng, Qenu bo maigas mi taui andariba? Munon gabmant qur baub igour eng wuri qomon eng ebet igour. ");
INSERT INTO wnu_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ne aninou munon banam qas ibag qob musub wurinob qamb wogub munon ar qei maigas at wurimusioruboumon? Eng misue. End munon Qenu me imbig igour eng gor ende at igour. ");
INSERT INTO wnu_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Aninou Tain Qenu wonou ginamt qoregen mom igo gas ende, an gor qoregen ende mom igoarar.” ");
INSERT INTO wnu_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“An qomon ete obounon eng an qoyamet igoarar: qomon uber-uber ebet munon qen inimbagaiar qamb me abar. An ende obounon eng aninou Tain wonou munai ginamt end taui qamb mi uber ger me gunanei. ");
INSERT INTO wnu_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ne gor an munon mi ue eng werisub qamb munon gim ibegeari yar qiumunimari mi me werisar. Munon misir ue wuri ende oboub qamb inorou munai mor end qiyo, a tap togot end ubune munon inimbagaiar qamb ende ebet igour. End ye aninob quraum, wuri eng ebet igour eng mi uber qo ag e mom baub igour, bo sabar Qenu ginamt mi uber me baunorei. ");
INSERT INTO wnu_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","An munon boru eng mi werisub qamb aninou munon banam qani igorunor eng mag batar qi mi werisar. ");
INSERT INTO wnu_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Mi qi ende wurisab igorunon eng aninou Tain magqurt end an diban igoumon, end mi uber bauboumon.” ");
INSERT INTO wnu_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“End Qenu nob qomorub eng gor ende, munon gab Qenu nob quraun qamb ebet igour gas ende me abar. Wuri ete ebet qib igour: inorou munai mor end igo der munon magqurt diban naget qamb qiyo, a ai tap munon qenen qib igour diban end iua Qenut qamb ende at igour. End qoyamet igoarar, wuri eng ebet igour eng mi taui qamb mom baub igour. ");
INSERT INTO wnu_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ego an ende me abar. An Qenut qomorub eng aninou qi munai tumbig end isub mondir ubet taisi wogub nob qamb igoarar. Ende abari aninou Tain wo mi gugum waber igo eng diban gab igo end animbag taui anmusieriba.” ");
INSERT INTO wnu_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“An Qenu nob qamb eng qob degen aib me qamb bisub igoarar. Munon Qenu me imbig igour eng wuri Qenu nob qomorub eng qob degen aib suab bisub igour. ");
INSERT INTO wnu_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","An wuri gas ende me abar. Aninou Tain wo an me nob qomorunon qen end wo qo imbig ugab igo. ");
INSERT INTO wnu_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","An Tain qebi qomorub eng ete at qamarar: Ininou Tain nonou ginamt igoan. Nonou unum qau igoriner. ");
INSERT INTO wnu_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nonou bibis eng init waga deriner. Ne munon nonou ginamt qite qob qamara igetet toat igour gas ende in ag e gor ende oboun. ");
INSERT INTO wnu_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Qen see in mani nioun eng ne indaran. ");
INSERT INTO wnu_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","In qomon boru ebet igoun eng init biruet arirama ne munon qei init qomon boru ebet igour eng in wurit biruet ariramboun. ");
INSERT INTO wnu_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ne inwarigesi me inquguragsi. Mi boru ger inquguragsieriba gab init biruet arirom. Ende at qamarar. ");
INSERT INTO wnu_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“An munon qei ansumungasiari gab eng an wurimusub wuri banamsiarar. Ende obounon eng aninou tain wonou ginamt igo eng taui qamb aninou qomon boru eng biruotariba. ");
INSERT INTO wnu_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ego munon qei qomon boru abari an wurit igub wurinou qomon boru eng me wurimusitarunon eng, aninou Tain wonou ginamt igo eng gor taui qamb me anmusierinerei.” ");
INSERT INTO wnu_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“An mi niau qei gitab gab eng, munon qei gag mi gitoroun qamb menman boruburab igour gas ende me abar. Wuri mi gitoroun qamb munon inimbagaiar qamb gag menman boruburab ende at igour. End ye aninob quraum, wuri eng ebet igour eng taui qamb mi mom ag e baub igour. ");
INSERT INTO wnu_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","An Qenut igub mi niau gitab igamari munon qei mi nub qamb isari an wurinob isub gab eng an ya ubet tari meni menman sarog big isar. ");
INSERT INTO wnu_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ende abari wuri an mi gitab igoumon eng me animbigunor eng uber. Aninou Tain an me gab igoumon eng wo qo animbig igo. An munon magqurt mi waber obounon eng wo mi taui qamb diban andariba.” ");
INSERT INTO wnu_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“An mi uber-uber ag et ba qiumuni big saumbinat igorub qamb misir me igar. Mi ag et ba qiumuni big saumbinat igorub misir igoumon eng, mi eng gagar pinai nub igo, ne uyan nub igo, ne munon qei mi urim baub igour. ");
INSERT INTO wnu_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","A an mi uber-uber qenenginob Qenu wonou ginamt irab mi baiau eng qas qiumuni big saumbinat igorub qamb misir igar. Mi eng gagar pinai me wurinerei, uyan me ninerei, ne munon urim me baunorei, qenen gab mismisir igoruboumon. ");
INSERT INTO wnu_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Munon ger wonou mi sig uber ger eret igoriner eng baib qamb misir end qas igub igo gas ende.” ");
INSERT INTO wnu_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Aninou mag eng git goan gugum begen igamau gas ende. Mag uber igoriner eng git goan begent igoriba. ");
INSERT INTO wnu_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","A mag tuumteriner eng git goan itumoramba. End begen anit igo eng wagari ende igoriner. Bo qomon boru toat oau naget abari itum aib anmuaseremba.” ");
INSERT INTO wnu_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Munon gari qas munon barai ombur sarau me batarinerei. Ende ebeiner eng ger siningot ne ger qenunget ende ebet igoriba. Ne ger qob qamara toat ne ger qob qamara omboarir ende at igoriba. End ne in igeragart Qenu qenunget ne igeragart nomon qur qenunget ende me oboun.” ");
INSERT INTO wnu_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Qanam end ne aninob quraum eng: See igom igoun end mi goan qamb nomon qurt ne mani qamb end misir qebebi me igar. Igom igoun eng mai, mani ya qamb eng qas nub igoun qiyo? A mingoan qas qumani igoun qiyo? ");
INSERT INTO wnu_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Morogan ibagaiar: wuri man suab mi ubub qirinau ba mor big nub me igour. Aninou Tain wonou ginamt igo morogan eng oroar igo. End ne an mai morogan wuritanamimoumon qiyo? ");
INSERT INTO wnu_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","End ne an gor see qas umib at wogub bo mai me uminei qamb togun ger bo maribig igo qiyo? Sig ue ar. ");
INSERT INTO wnu_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ne mi goan qumanimau end meimet misir qebebi igub at igoumon? Nam isar qamb puriani amug-amug eng wuri mi goan me barsi igour, ego wuri misir qebebi me igub igour. ");
INSERT INTO wnu_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Qoan munon barai Solomon wo mind irou igo ne git baab igoar eng nam isar ger me wotanamimau. ");
INSERT INTO wnu_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","An munon yamangar mani qamb mi goan qamb end misir qebebi igunon eng an oau apand ue. Mi e musub gaiar. Nam ar amug igama Qenu siara se isarima munon ar soopur arir igour. End ne an nam qamb puriani qamb eng gagar wuritanamimoumon. End ne Qenu anoar ne sig mom anubersi igo. End ne an meimet qamb misir qebebi igo? ");
INSERT INTO wnu_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","End at ne misir qebebi igub, mani eret gab nuboun? Ya eret gab nuboun? Mi goan eret ba qumanimboun? ende misir me igar. ");
INSERT INTO wnu_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Munon Qenu me imbig igour eng wuri misir qebebi ende igub igour. An aninou Tain wonou ginamt igo eng an imbig igoumon eng wo gor animbig ne mi gugum baub qamb misir igoumon eng qeemben ende andariba. ");
INSERT INTO wnu_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","An gigit wonou bibis eng nob qomon qoregen eng nob end igorub wot asi ebet igorunon eng, mi eng gagar wonou ar anit igima darab isub igoriba. ");
INSERT INTO wnu_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","End ne qen see igo barim mi ger oboumon end misir qebebi me igar, qen barim eng wonou uninim. End ne in qen geret quguraget gab eng qen end qas uburiner. Bo ten igama ne barim quguraget urigom quguraget ende at me isub igoarar.” ");
INSERT INTO wnu_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“An munon qei wurinou qomon abari ibag mindigar qob me wurit qamarar. Ende obounon eng Qenu gor anit mindigar qob qemeriba. ");
INSERT INTO wnu_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","An munon qei wurinou qomon qereimunon gas ende Qenu wo gor aninou qomon eng qeemben ende qereimba. Wurinou qomon qerei ne mi mai-mai indarar qamb qomorunon eng Qenu wo gor ende qamara utuboumon. ");
INSERT INTO wnu_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","End ne nonou magqurt nam sau aib net isar eng ten igo ne nonou ima magt mi qanganing wot isar end qamb igoan? ");
INSERT INTO wnu_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nonou magqurt nam sau aib net isiner eng ten igama ima mi qanganing wot isiner eng gab, “ima ete aba, mi qanganing magt eng gumotenerimeteibam,” ende qemeriban? ");
INSERT INTO wnu_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Eng misue, maigas ende me ebinenei. Wo gigit nonou nam sau net isiner eng mom at gumoteneri musub mi gab ne nonou ima mi qanganing eng gumotenerimatat. ");
INSERT INTO wnu_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Mi qau gab iau me werisar, ende obounon eng wuri igeser anongoarubour. Ne mi uber qenenginob eng bur qib igour werei end bigunon eng wuri napi borusiorubour.” ");
INSERT INTO wnu_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Ne bo qamar: “Qebi qamarari andariba, a gub qamb asi qib igamari eng ansirbiga guboumon. Ne qeirtoau bigari igub eng igeser animbegeiba. ");
INSERT INTO wnu_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Munon gugum qebimari eng werisiba, a gub qamb asi eng gubour, a qeirtoau bigari eng igeser ibegeiba. ");
INSERT INTO wnu_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Aninou wau ger mani qibit qamara mai, ur der bo nomon utab igo qiyo? Ende ue. ");
INSERT INTO wnu_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ne ger, wau der yag wai nib qamb urt qamara eng mai, ur der mi boru ger utab igo qiyo? Ue e. ");
INSERT INTO wnu_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","End ne an munon uber ue eng aninou wau eng sig-sig mom wuri qenungar mi uber wurisab igoumon eng. Eng gas ende aninou Tain an antanamimar eng wonou ginamt igo eng wo munon mi uberet qebi qomorunor eng ar ende werisiba. ");
INSERT INTO wnu_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Munon qei an anmusiari an wurit mismisir igoumon gas ende gari an gor munon qei ende wurimusiarar. Qomon eng Moses gumater eng nob munon miteri qamb gumatemir eng qamb gumatemir eng ende igo.” ");
INSERT INTO wnu_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“End ne an tend qomourt end mor isar, tend wauimau end isub eng tap sarog eng toat isub eng munai ginam boru end isub umuboumon. Munon irou tap eng toat isub igour. ");
INSERT INTO wnu_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Tend qomour ne tap mongomongau boru eng igomot igamau, ginam end isub igo.” ");
INSERT INTO wnu_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“An munon qei qob gigit anmurimar qomorunor eng an imbig igoarar. Wuri wai sipsip goan gas ende at diorubour. Ego wurinou misir erobon eng oau uter eng igoriba. ");
INSERT INTO wnu_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Wuri qob aninob qamb menman ion abari ibag imbiguboumon. Eng ete gas, wain qor end uyor qur boru ger me imbi igo. Ne ain uben end qiser me di igo. ");
INSERT INTO wnu_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Nam qaar boru eng qur eng qeemben ende big igo. A nam uber qur nub igoun eng wonou uben end qeemben di igo. ");
INSERT INTO wnu_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Nam qur uber nub igoun eng bo nam boru uter uben end me dierinerei. Ne nam qur boru uter eng nam qur uber nub igoun end me di igo. ");
INSERT INTO wnu_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Nam uber nub igoun eng bo qur musub me biga eng suab mutet gumoubour. ");
INSERT INTO wnu_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","End ne munon qob gigit anmurimar qamb eng menman ne qomon eng ion abari ibag wuriimbigar.” ");
INSERT INTO wnu_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Munon gugum yet, Barai, Barai yet qamb igour eng gugum ende Qenu wonou ginam bibis end me irunorei. Munon gari-gari Qenu wonou mi abar qamb qamara toat ebet igour eng gari irubour. ");
INSERT INTO wnu_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Qen ger dibenara gab munon irou yet ‘Barai, Barai, ne negab-negab Qenu qob dibes qamb qib igunei. Ne neunumot ai munon igaramor eng wuri musub ne nonou qiribiten eng in ubune gamirei.’ ");
INSERT INTO wnu_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ende yet qamarari ye ete wurinob qemeribam: ‘Ye an qoyam ue, an munon qomon soagen abau tari. Qand wogub der iuarimar,’ ende qemeribam.” ");
INSERT INTO wnu_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Munon gugum qob eng igub misirt igub toat igorunor eng munon ger qoyam imbi-imbi igo mon nomon erer tumun goanet yab mindater gas ende oboubour. ");
INSERT INTO wnu_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Mon mindaterei igama ya aib der yaum isuor eng, ne moon sani-sani aib di munai baar eng qoren mom nomon erobon qumo yamor end munai du qamb igoai. ");
INSERT INTO wnu_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ego munon gugum qob igub end misir me igub toat ebet igorunor eng munon misir ue mon orosout mindater gas ende. ");
INSERT INTO wnu_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Mindaterei igama ya aib der yaum yar orosou nerub isa sani-sani aib di mon eng boaburma uburab isorei, mon eng sig borusi uburab isorei.” ");
INSERT INTO wnu_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yisas qob eng ende qamb ugea wogub munon yurau aib eng wonou qob uber eng igub borusi qoaguruiamirei. ");
INSERT INTO wnu_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Wo qob qamara igumir eng qob qiribiten, munon Moses qomon toat qamarari igub igour gas ende ue. ");
INSERT INTO wnu_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yisas ai qaur eng wogub dara ne munon yurau irou toat qib igurei. ");
INSERT INTO wnu_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ne munon ger tumau gab igoar eng yar menmant end gamaur wat bugab simot eab qamar: “Munon Barai, ye iam e gab nonob quraum, gusimiseib eng gusimiseis.” ");
INSERT INTO wnu_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ende qamara Yisas uben arir baab qamar: “Ye gusimeteibam, ne mom uberburiban.” Ende qamara iam tumau eng qand wout uburerei. ");
INSERT INTO wnu_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ende aba Yisas munon eng nob qamar: “Ne eng aban end munon ar song-song wurinob me qem, ar deget munon Qenut mian yab igour end qas ire. Iroa negab Moses qomon qoan qamb gumater igo eng toat nemaragansiorunor. Ende abari munon gugum ne iam mom woumrirar eng imbigar qamb.” ");
INSERT INTO wnu_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yisas ende at wogub Kaperneam end isa ne Rom wurinou munon baraitari eng yar Yisas gab simot eab qamar: ");
INSERT INTO wnu_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Barai, yonou munon sarau besab igo eng toar borusi wara mor umo inab igo. Git goan gurumot uburab ne borusi aruab igo.” ");
INSERT INTO wnu_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ende qamara Yisas taui qamar: “Io, ye isub musieribam.” ");
INSERT INTO wnu_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ende qamara munon barai eng qamar: “Barai, eng ende ue. Ye ne sesimot mor umo yar qamb me qemerinei, nonou qas et igo qob qas qamara uberburiner qamb eng gor uber. ");
INSERT INTO wnu_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ye gor munon barai qei igama wuri ii ete igoum. Ne gor ye yonou yogorau munon yurau ye igimine yii igour. End ne ye ger nob, ‘is’ qemerine eng qob igisab isub igo. Ne bo ger nob, ‘yar’ qemerine eng yar igo. Ne yonou sarau munon eng nob, ‘mi eng eb’ ende nob qemerine eng mi ebet igo.” ");
INSERT INTO wnu_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Munon barai eng Yisas qob ende nob qamara igub qiet ne munon toat qib igour eng wurinob qamar: “Apand aninob quraum. Isrel munon yurau end ger oau apand ende ger qoan me geau. ");
INSERT INTO wnu_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Mi end misir igar, munon irou worom diat end ne worom isat end yar Abraham Aisak ne Yekop nob Qenu wonou ginamt bibis end qiumuni mi nubour. ");
INSERT INTO wnu_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ego munon bibist igorunor eng Qenu wurisogar ag arirama ai itum end is igo migeri ur igara igorubour.” ");
INSERT INTO wnu_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ende qamb ne munon barai eng nob qamar: “Nonou oau apand buran end ne mor isub mi ende eb qamb misir igan eng ende aba uberburiban.” Ende nob qamara qen end qas wonou sarau betet igoar eng uberburerei. ");
INSERT INTO wnu_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yisas ende qamb wogub ne Pita wonou munai mor end isorei. Isub gar eng Pita wonou ayi eng toar wara inab igoai. ");
INSERT INTO wnu_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ende gab ubent end bea toar mom dierama ne bugab mi arsitet igoai. ");
INSERT INTO wnu_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ai gab-gab munon irou munon qei aibigau igaramor eng oromar diarari aibigau eng orotoar arir ne toar ar qei igab igoar eng wurimusub ende at igoai. ");
INSERT INTO wnu_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Wo mi eng ebetri igoar eng munon miteri qamb gumater eng Aisaia ete qamar eng toat ebet igoai: wonou uyes ininou toar eng musub ba iua ugarei. ");
INSERT INTO wnu_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yisas ibagar eng munon yurau aib wot qiumunimari ibag ne wonou imbigau yurau eng wurinob qamb ya tai ig eng wogub bo iget wes irond isun qamb misir igorei. ");
INSERT INTO wnu_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ende at igamari qomon qerei imbigau munon ger Yisast yar qamar: “Imbigau munon tari, ye mom ne notoat ten mom qib igorib qamb girinet tug mom igoum e.” ");
INSERT INTO wnu_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ende qamara Yisas taui qamar: “Iau qaar wuri irut igour, ne morogan wuri mon ubet igour. A munangit wau wo wonou ar deget qib igo, wo umiminer munai eng ger ue.” ");
INSERT INTO wnu_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ne bo wonou imbigau yurau end ger bo yar nob qamar: “Munon Barai, yiimurima isub tain umar eng tumuni wogub diab notoat qib igoribam.” ");
INSERT INTO wnu_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ende qamara Yisas nob qamar: “Eng wog, wogub ye yetoa ombur qib igorun. Munon mumun eng munon mumun qei eng der qitumuni igorunor.” ");
INSERT INTO wnu_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ende qamb wogub wonou imbigau yurau eng oromar tabin ba isumirei. ");
INSERT INTO wnu_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Isub igamari sani-sani aib uyer ya wobon end dari ne uyer ya buresi tabin umimb aterei. Ego Yisas qoan naat inerei. ");
INSERT INTO wnu_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ne wonou imbigau yurau eng isub meni qamamir: “Ne inmusub ge, in umub pisi igoun e me ga a?” ");
INSERT INTO wnu_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ende qamarari Yisas der bugab wurinob qamar: “An Qenu qenen anoar igo eng wot me igub igoumon end yarimoumon eng.” Ende qamb der bugab moon aib di ya bures arir igoar eng omboopurama wagerei. ");
INSERT INTO wnu_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Wonou imbigau yurau eng der ende gab qamamir: “Wa, eng meimi munon ende igo sani-sani aib di ya bures arir igemerei eng omboopurama waga a?” ende qamamirei. ");
INSERT INTO wnu_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Moon ende omboopurama waga ne isi munon Gadara wurinou ai end isumirei. Isari munon ombur aibigau igaramor eng munon teteret end igo Yisast yaremirei. Munon ombur eng munon teteret end igamari munon ar munon teteret wes end bais me qib igamau, borusi yari wogub igurei. ");
INSERT INTO wnu_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Yisas ende isa gab qugiab qamb amir: “Qenu wonou wau, mai insierib qamb? Qen uit ar insumungasierib qamb yaran ne?” ende qamamirei. ");
INSERT INTO wnu_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Mi eng ebeter ai igeragart wes end bur yurau aib end oroar igurei. ");
INSERT INTO wnu_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","End ne aibigau munon ombur wuriboopuri igour eng der Yisas nob qamamir: “Ne intoar ariramb qamb eng intoar bur yurau aib end inimurima isuboun.” ");
INSERT INTO wnu_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ende qamarari Yisas wuriimurima der bur yurau aib eng wurit isari bur yurau aib eng qanganget uyab-uyab yaru aib eng der ya tai isub ya nub umb uburemirei. ");
INSERT INTO wnu_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ende abari munon bur oroar igour eng ende gab iua ginam aib umo isub ne bur eng ebetemir eng wurinob qamb ne munon aibigau igarama igour eng maigas ebetemirei qi eng gugum wurinob qamb ugamirei. ");
INSERT INTO wnu_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ende qamarari igub munon gugum ginam aib eng wogub Yisas gub qamb iramirei. Irab gab ne wurinou ai eng wogub iua qamb qamat qamamirei. ");
INSERT INTO wnu_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Qamarari wogub bo tabin ba yonam wonou ginam qenen end diarei. ");
INSERT INTO wnu_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Diab end igama munon ger git goan gurumot uburer eng gart big ba diamirei. Diarari munon eng wurinou oau apand eng ibag ne toar munon eng nob qamar: “Io, oau mein burab igoar, nonou qomon boru eng ye net biruet ariramoum.” ");
INSERT INTO wnu_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ende qamara qomon qerei imbigau munon eng ende igub wurinou qob-qob qamamir: “Wa, munon eng Qenut sai qob qamb igo.” ");
INSERT INTO wnu_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ende qamb abari wurinou misir eng ibag wurinob qamar: “An misir soagen eng meimet ende igub igoumon? ");
INSERT INTO wnu_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Maigas at nob qemerin eng mai sarog, ete at nob qemerin eng, ‘nonou qomon boru eng ye net biruoum’ ende qemerin eng qiyo, a ‘der naget is’ qemerin eng mai sarog qi? ");
INSERT INTO wnu_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ye ete aninob qemerine igub ne, Munangit wau wo qiribiten ag e igo, qomon boru eng ar biruet ariramba.” Ende qamb toar munon eng nob qamar: “Der naget gar baub mor umo is.” ");
INSERT INTO wnu_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ende qamara munon eng der naget mor isorei. ");
INSERT INTO wnu_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Munon yurau aib eng ende gab yari wogub Qenut mismisiramirei. Wo Yisas boopuri ten igama mi qiribiten eng aba gab. ");
INSERT INTO wnu_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ne Yisas bo tap toat isub gar eng munon ger gabmant qur ba qib igo eng wonou sarau munai end igama garei. Unum eng Matyu, gab nob qamar: “Yarab yetoa ombur qib igorun.” Ende qamara Matyu der nob isorei. ");
INSERT INTO wnu_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yisas nob isib qamb ne mi arsi nob bugab mi niba ne qur baiau munon ne munon qomon boru at qib igour eng ne wonou imbigau yurau eng nob bugab igurei. ");
INSERT INTO wnu_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ne Parisi ende ibag ne wonou imbigau yurau eng wurinob qamamir: “Aninou imbigau munon qoregen aib eng meimet qamb qur baiau munon ne qomon boru abau qoat eng oromar mi nub igo?” ");
INSERT INTO wnu_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ende igub Yisas taui wurinob qamar: “Munon gugum toar igara eng sir inmusiarar qamb wuri simoar eari wurimusub igour. A munon qugurebi igour eng ue. ");
INSERT INTO wnu_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Isub qob qoan igoar eng maigas qi eng qoot gaiar. Ye wai mian yab big igour eng ye oau me yemeinsia. Ue, munon qomon uber ebet igo eng oau yemeinsi igo. Ye derem eng munon in qoregen qamb igour end me darau, ue, munon gogorau igour eng wurit deremei.” ");
INSERT INTO wnu_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ende qamb igama Yon munon ya obotar igoar eng wonou imbigau yurau eng wot diab qamamir: “Meimet qamb in Parisi wurinob mi gitab igumune nonou yurau eng mi me gitab igour eng maigas?” ");
INSERT INTO wnu_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ne Yisas taui qamar: “Munon ger yamangar set baub ne banamori wurinob igama eng mai wuri oau quguraget igorubour qiyo? Ende me ubunorei, igoi wogub qen munon yamangar bainer eng mot qoari ne qen end mi gitarubour. ");
INSERT INTO wnu_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ne gor, munon ger mi goan tau temen ger ba mi goan qoan quburiner end big me mai igo. Ende ebeiner eng mi goan tau temen eng gigibiot isub mi goan qoan eng ubumima bo imusi aib quburab isiba. ");
INSERT INTO wnu_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ne gor munon ger wai goan qoan mai wain ya unab qib igour eng bo wain ya temen ba end me waari igo. Ende ebeiner eng wain ya temen end iriget yar ombombanet ag der wain ya isi isiba. End ne wain ya temen eng wai goan temen end wonou uninim waari biga uber igorubour.” ");
INSERT INTO wnu_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yisas qob eng ende wurinob qamb igama Yuda wurinou munon baraitari ger yar menmant end gamaur wat bugab qamar: “Yonou yamangar wau ger mom uma wogub diaum, ego ne yarab bea bo igomot der bugeminer.” ");
INSERT INTO wnu_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ende qamara Yisas nob isa Yisas wonou yurau eng nob isumirei. ");
INSERT INTO wnu_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Qen end yamangar ger qenen amug isub qib igama togun 12-ende umorei. End ne Yisas isa-isa qanam isub Yisas mi goan tau end barei. ");
INSERT INTO wnu_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Wonou misir ete igub, “qo, ye mi goan tau end qas baab eng uberburibam” ende misir igub barei. ");
INSERT INTO wnu_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ne Yisas igeser yamangar eng gab nob qamar: “Io, see oau mein burab igoar, yet oabigan eng gab.” Ende qamara qen end qas amug isub igoar eng boopur wagerei. ");
INSERT INTO wnu_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ende aba wogub Yisas munon barai eng wonou munai mor end isorei. Isub gar eng munon ain mer gusit toau big igamari ibagarei. ");
INSERT INTO wnu_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ibag qamar: “An gugum iuar, yamangar wau me umau, naat inai igo.” Ende qamara wuri qanambig wot igerig ber qob wot qamb ende ebetemirei. ");
INSERT INTO wnu_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ende oramar qamara ag isari Yisas yamangar wau mumun inab igoar munai tumbigi end isub ubent bea der bugamorei. ");
INSERT INTO wnu_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ende aba qob toau isa munon ai end igour eng gugum igumirei. ");
INSERT INTO wnu_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yisas ginam eng wogub isa munon mag tuum ombur toat isub igo amir: “Debit wonou wau, initoubar.” ");
INSERT INTO wnu_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ende arari Yisas mor isa ne munon ombur eng wot isari Yisas der wuri qebi qamar: “An ye mi eng eb qamb mom yet oabigoumon qiyo?” Ne wuri qamamir: “Io, in qenungoun.” ");
INSERT INTO wnu_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ne Yisas mag end wuribaab qamar: “An oabigoumon eng gab mi eng ende init eb qamb qenungoumon eng ende anit ebeiba.” ");
INSERT INTO wnu_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ende qamara mag musub asiamari wuri imurimb qamb qamar: “An qob ar song qamb qib igamari qob toau isa munon qei at igunor qoyamet igoarar.” ");
INSERT INTO wnu_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ende qamara ombur wuri irab Yisas qob qamar eng me toau, wuri qob suab qiroari munon ai end igour eng gugum igub ugamirei. ");
INSERT INTO wnu_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Munon ombur eng qoari ne Yisas bo tumbigi isubari ne munon ger aibigau waramorei igama qob me qamb igamau eng ba diamirei. ");
INSERT INTO wnu_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Diarari Yisas munon eng musia qob musub qamarei. Qamara munon gugum gab qoagurui qamamir: “Qoan Isrel munon end ger mi ende aba me geau.” ");
INSERT INTO wnu_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ende qamarari Parisi der qamamir: “Aibigau baraitari aib eng wo nonogursia ne munon eng musiar eng,” ende qamamirei. ");
INSERT INTO wnu_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yisas eng ende at wogub is ginam aib-aib qamaaman end qib igoai. Qib igo wurinou inorou munai mor end isub Qenu wonou bibis big igo qob uber eng wurinob qamb qib igoai. Igo munon git goan boru-boru ne toar qamb eng gagar wurimusub qib igoai. ");
INSERT INTO wnu_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","37","Ende at qib igo ne munon yurau aib ibag borusi wuritoubarerei. Wuri wai sipsip munon ger wurioroar igamau eng ue, wurinou ar borumesis burab qib igamari ibag ne wonou imbigau yurau eng wurinob qamar: “Mani man aib ubumir eng arit igo ego munon gari duor ete goanet qiumuni igour. ");
INSERT INTO wnu_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","End ne an munon man ur eng nob qamarari sarau munon bo wuri qereima isub mani gonetet ba di mor bigotounor,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yisas wonou imbigau munon 12-ende eng wurit qamara yarari ne wurinonogursine ne wuri qib munon aibigau igaramor eng wurimusub ne git goan boru eng ne toar qei igab igo eng wurimusiarar qamb wurinonogursiarei. ");
INSERT INTO wnu_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Munon 12-ende wuriimuriamor eng wuri unum eng ete: qamar Saimon, unum ger Pita, ne wonou umour eng Andru, ne ger Yems umour Yon, Sebedi wonou wau ombur. ");
INSERT INTO wnu_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ne Pilip Bartolomyu nob, ne Tomas Matyu nob. Matyu wo nomon qur ba qib igoar eng, ne Yems ger Alpius wonou wau eng, ne ger Tadius. ");
INSERT INTO wnu_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Ne Saimon Selot, ne Yudas, Iskariot wonou wau, wo Yisas duiamor eng ende. ");
INSERT INTO wnu_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yisas munon eng ende wuriqerei wogub wuriimurimb qamb wuriirunwab qamar: “An isub qib eng munon Qenu me imbig igour yurau eng wurinou ai eng me isar, ne Samaria wurinou ginam aib ger me isar. ");
INSERT INTO wnu_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Isrel munon yurau wai sipsip gas ende qaar domb at igour eng wurit isar. ");
INSERT INTO wnu_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Isub wurinob ete qamarar: ‘Qenu wonou ginamt bibis eng piara.’ ");
INSERT INTO wnu_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ende qamb ne toar munon wurimusub ne munon umari wurimenub ne tumau gab igour eng gusimatarari wouet, ne ai igaramor eng wurimusub ende abar. An mi eng baioumon eng taui me baioumon, ar baioumon. End ne an bo ar werisar, taui mi me baiar. ");
INSERT INTO wnu_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ne an isub qamb nomon qur qiyo mi qomourt ger abau end uyab me ba isar. ");
INSERT INTO wnu_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ne gor qib igo abau qiyo mi goan it qiyo umo ombur ger me baiar, ne tugotau ger me baiar. Munon sarau baab eng mi git gab baiba. ");
INSERT INTO wnu_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","An ende qibi munai ginam aib qiyo qomourt ger weib isub qiyo diab gab eng munon ger anbanamsia gab eng end qas nob igoi wogub bo tumbigi isar. ");
INSERT INTO wnu_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Munai mor ger isub gab eng ete qamarar, ‘oau uberet igoarar,’ ende qamarar. ");
INSERT INTO wnu_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ne munon munai mor eng animbag sarog bigari ibag eng qob uber eng wurinob qamarar. A ende me abari eng qob uber eng wagari aninou igotariner. ");
INSERT INTO wnu_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ne mon qei qo ginam aib qei munon animbag me sarog big qiyo qob qamarari me igatar abari ibag eng wurinou ai nogounon erumban eng porongot end arir wagar. ");
INSERT INTO wnu_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Eng wuri ende obounor eng munon wuriqereimau qen end Sodom Gomora nob uru iramir eng wuritanami wogub wuri sig-sig mom uru irubour.” ");
INSERT INTO wnu_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“End ne an igar, ye animurimoum eng an wai sipsip gas ende iau qaar irut animurimau gas ende oboum. End an mani qomon eng toat mom imbig mi oboub eng abar. Ne morogan wamariau qomon eng toat qomon boru ger me abar. ");
INSERT INTO wnu_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","An mi eng imbigar, wuri anbaab uyort anbigub qamb bisub wurinou inorou munai mor end pisirami aningarambour. ");
INSERT INTO wnu_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ye yesiningot wogub anamar gabman ne king magqurt anamar isubour. Ende ansiarari an qob uber eng dibes wurinob qamb ne munon yurau ar eng gor wurinob qamarar. ");
INSERT INTO wnu_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Uyort anbigub anamar isari gab eng an misir qebebi igub daragab qob maigas qomoruboun, qo maigas taui qomoruboun, misir ende me igar. Qen end qas Qenu wonou qob qomorunon eng animbiga qomoruboumon. ");
INSERT INTO wnu_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","An qob qomorunon eng aninou qob ue, Tain wonou Igomurur qau eng wonou anit di qemeriba. ");
INSERT INTO wnu_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ende abari munon qei wurinou wau der ur unor gabman wurit qut bigari gabman der igaramari umubour. Ne umom der umour duima gabman waramari umiba. Ne ur unor der wurinou wagrari gabman wurit duimari igaramari umubour. ");
INSERT INTO wnu_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","An ye iitari burab qib igamari ieri animbag igorubour. Ende abari ne munon ger wonou mom nonoguret igoriner eng qen sindomund end Qenu wonou mot iroa igomot igoriba. ");
INSERT INTO wnu_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","End ginam aib geret isari ansiningoar abari ibag iua yar ginam aib geret isar. An sarau oboumon eng Isrel ginam aib eng gugum me at ugunanei, igama Munangit wau deriba. ");
INSERT INTO wnu_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Mi eng imbigar, sugur wau wuri wurinou imbigau munon eng wurinou baraitari me igour. Ne gor, wau gogor ger munon barai ger ba nob igoriner eng wau gogor eng wo baraitari me igorinerei. ");
INSERT INTO wnu_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Sugur wau ger wonou imbigau munon gas ende ebet eng uber. Ne gor, wau gogor eng wonou munon qoat igo gas ende ebet eng gor uber. End munai ur end unum bigour eng, Belsebul, ‘aibigau wurinou baraitari’ wot quraur eng. End ne an gor ye yetoat yonou sarau ebet qirunon eng, unum eng anit big anba sumungasiorubour.” ");
INSERT INTO wnu_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ende qamb qamar: “An munon wurit me yarimar. Mi ger suumi bigunor eng bo sagar igoriba a qob ger qi igoriner eng bo diban iguboumon. ");
INSERT INTO wnu_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ne ye qob itum aninob qemerin eng an bo sabar dibes woromt wurinob qamarar. A qob qi qamarari aninou qas igub wogunon eng bo dibes munon gugum wurinob qamarar. ");
INSERT INTO wnu_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Munon aningaramb eng gugur qo moui nob me aningaramunorei, end me yarimar. Munon moui gitgoan nob waramb animurima ginam borut isunon eng Qenu, wot gari yarimar. ");
INSERT INTO wnu_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","An morogan qomourt ombur-ombur gari eng nomon qur qomourt miannob eng ombur arir taui ba igoumon. Ego aninou Tain wo mi eng gab iet waga ar isi ag me isinerei. ");
INSERT INTO wnu_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Aninou tari im eng wo qoan wanunger ugab wagerei igo. ");
INSERT INTO wnu_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","End an me yarimar, an morogan qamaaman irou wurinou qur qangang eng wuritanamimoumon.” ");
INSERT INTO wnu_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Munon ger ye yedibes qamb qiriner eng ye gor munon eng wo dibes Tain wonou ginamt igo eng nob qemeribam. ");
INSERT INTO wnu_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ne munon ger ye unum dibes munon wurinob qemerib qamb qinining mogirisab weginer eng ye gor munon eng Tain magqurt mogirt wab wegibam.” ");
INSERT INTO wnu_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ende qamb qamar: “Ye ag e derem eng munon gugum wurimbanamsierib deremei qamb misir igunon, ue. Ye munon wurimbanamsierib me darau, ye yogurib yuraut deremei. ");
INSERT INTO wnu_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ye derem eng munon wurinou yurau qi qarausi igoarar qamb. Wau der ur nob agunub, ne waibou der unor nob agunub, ne umagom der ayi nob agunub. ");
INSERT INTO wnu_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ne munon ger der wonou yurau erogori eng wuriqarausi ende at igorubour. ");
INSERT INTO wnu_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Munon ger wonou ur qiyo unor sig-sig mom qenunget ne ye yenasi weginer eng, munon eng ye wo gor me qenunginei. Ne gor munon ger wonou munonbor wau qiyo yamangar wau qas wuriqenungar ne ye yenasi weginer eng ye gor munon eng nasi wegibam. ");
INSERT INTO wnu_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ne munon ger ye quguragetam gas ende me ebein qamb yari weginer eng wo yonou munon banam ue. ");
INSERT INTO wnu_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Munon ger wonou see igom igamau end misir igub wonomi me duieminer eng qen geret igomot me igorinerei. A munon ger yet igub yetoat qib igama waramari uminer eng qenen yenob bebereg igoriba.” ");
INSERT INTO wnu_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Qamb qamar: “Munon ger animbag sarog big anqubeiminer eng ye yebanamsiau gas ende gari. Ne munon ger ye yebanamsieriner eng munon ye yiimurima derem eng banamsi igo. ");
INSERT INTO wnu_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Munon ger igo Qenu qob qamarau munon yara gab eng ete misir igub: “Qo, wo Qenu sarau munon,” ende qamb misir igub wo munon eng musieriner eng, Qenu bo sarau munon eng taui mi utiner gas ende munon eng qeemben ende utiba. A, munon ger igo munon qoregen ger yara gab eng wo munon qoregen qamb musieriner eng gor Qenu bo munon qoregen musieriner gas ende munon eng musieriba. ");
INSERT INTO wnu_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","End ne mi eng igar, Munon ger munon boru ger gab ne Yisas wonou yurau qamb ya uta niner eng apand munon eng mi uber taui baiba.” ");
INSERT INTO wnu_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yisas qob eng wonou imbigau munon 12 eng ende wuriirunwab qamb wogub ginam eng wogub bo ginam qani-qani eng qob wurinob qamb wuriimbig qib igorib qamb isorei. ");
INSERT INTO wnu_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ende is qib igama Yon munon wurimaragansi igoar eng uyort igo Yisas wonou sarau eng qob toau isa igorei. Igub wonou imbigau yurau eng qei wuriimurima Yisast iramirei. ");
INSERT INTO wnu_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Irab Yisas qebi qamamir: “Ne munon eng Yon nenet deriban qamb qamara igub qoat igoun eng qiyo? A munon ger qoat igoruboun?” ");
INSERT INTO wnu_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ende qamarari Yisas taui qamar: “An bo igeser isub mi gaumon eng ne igoumon eng gugum Yon nob qamarari iginer. ");
INSERT INTO wnu_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Munon mag tuum bo asi mi gab igour, ne goten gurumtar eng bo qib igour, ne tumau gab igour eng bo woumriroa uber igour, ne iruges quum eng bo qob igub igour, ne munon umb bo der bugab igour. Ne munon qob uber qoan me igau eng bo igub igour. ");
INSERT INTO wnu_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ne munon ger ye ebetri igoum eng gab siningot ye mogirt wab me igoriner eng Qenu wo musia ubereteriba.” ");
INSERT INTO wnu_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Yon munon wuriimuriamor eng bo isari wogub Yisas munon yurau aib eng wurinob qamar: “An Yon ai qengerenget end igama wot isumon eng meimi gub qamb isomanei? Qo moon namanimun bea uya gub qamb isomanei ne? ");
INSERT INTO wnu_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Isumon eng meimi gamanei? Munon ger mi goan qenenginob wes at qumani igama gub qamb isomanei ne? Munon mi goan uber ende at qumani eng munon baraitari wurinou munai end igorubour. ");
INSERT INTO wnu_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Yenob qamarari igini, isub meimi gamanei? Qob gigit qamarau munon ger qiyo? Io, ye ete aninob qemerine igar, an isub qob gigit qamarau munon qei wuritanamimar eng gub qamb isomanei. ");
INSERT INTO wnu_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yon wot qoan qob ete qamb gumatemir eng: Ye munon ger ne der isinen end imbig nob qemerine wo gigit gim isub wuriimbigiba. ");
INSERT INTO wnu_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Qob eng igoar end ne ye ete aninob qemerine igar, Yon munon wurimaragansi igoar eng wo munon gugum unor wuribaub igour eng wuritanamima. Ego munon boru ger Qenu wonou bibis end igoriner eng wo Yon wotanamima. ");
INSERT INTO wnu_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Qoan Yon munon wurimaragansi igoar eng isi yarab qen see eng munon uter qei der wurinou uyes yogub Qenu wonou bibis end igorub qamb at igurei. ");
INSERT INTO wnu_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ne qoan munon qob gigit qamb igour eng ne Moses qomon qob gumater eng isi yarab Yon qangang eng, Qenu wonou bibis end qamb igurei. ");
INSERT INTO wnu_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","End an wurinou qob eng igub oabigub qamb eng, Yon wo Elaiya, munon eng deriba qamb igour eng. ");
INSERT INTO wnu_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","End an iruges nob igo eng igar.” ");
INSERT INTO wnu_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ende qamb qamar: “See munon wurinou qomon ebet igour eng ye meimet maribig qemeribam? Wuri wau munai ginamt igo yurau ger der qiumuni igo yurau ger wurit ete orunor gas ende. ");
INSERT INTO wnu_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","In munon yamangar nob qibaiari mismisir uru uyoun eng an nob me uyau. Ne uru qabar uber woroun eng an me toubau. Wuri eng at igour gas ende. ");
INSERT INTO wnu_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Qen end Yon wo yar ya mani nob gitara gab me wuritrama qamamir, ‘Aibigau waramai igama aba’ ende qamamirei. ");
INSERT INTO wnu_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","A munangit wau wo yar mani ya qamb sorobig nia gab bo me wuritrama gugum ete qamamirei: ‘Munon eng wo mai bur iriam bigorei igo mi ende at nub igo? Eng wo munon qur baiau ne munon qomon boru ten igour eng wurinou yurau end at qib igo.’ Ende qamb igoumon eng Qenu wonou sarau eng animbiga gaumon eng mi apand ar.” ");
INSERT INTO wnu_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yisas ginam aib qei end wonomi wes-wes aba gamir eng me wot oabigari ibag bo wuri irunwab qamb igoai. ");
INSERT INTO wnu_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Qamb qamar: “An munon Gorasin Betsaida nob, an borumesis. Qoan munon ger ye qomon wes see ebine an gaumon gas ende wo ginam ombur Tair Saidon nob end ende ebeterei ende qi eng wuri qoan mingoan qeer boru-boru eng qumani mut wambin qibesi bugab qoam mag igeser igo wot oabig wugumirei qi, ego an sig ue ar. ");
INSERT INTO wnu_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","End aninob quraum, Qenu munon wuriqereiminer qen end Tair Saidon nob wuri wuriquguragsieriner eng iosi ete. An anquguragsieriner eng sig-sig mom. ");
INSERT INTO wnu_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ne an munon Kaperneam, an aninomi bereri Qenu ginamt irub at igoumon? An ende at wogub aninomi ba Satan wonou ginam end ariramb at igoumon. Ego ginam Sodom eng munon ger qomon wes e gaumon gas ende aba gamirei ende qi eng qoan oabigari Qenu me igaramau qi, see ende igour qi. ");
INSERT INTO wnu_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ego Qenu see anborusieriner eng Sodom wuriborusier eng wuritanami anborusieriba.” ");
INSERT INTO wnu_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ende qamb wogub ur nob qamar: “Io Tain, Ne sig Aib erer qite ne ag e nonou torsianei igoan. End ne qomon wes eng aban eng, munon qoyam aib eng wuriimbiga geau eng bo wuri mag ibag-ibag munon boru tagug igour eng wuriimbiga gab ye sig nenet mismisiraum. ");
INSERT INTO wnu_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Io Tain, mi eng aban eng nonou qerei qenunget aban.” ");
INSERT INTO wnu_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ende qamb qamar: “Yonou Tain mi gugum yet wagerei. End munon ger wau eng me imbig igo, Ur wonou gari imbig igo. Ne ur eng gor munon ger me imbig igo, wonou wau eng gari ur imbig igo. Wau wonou uyes Ur imbigar qamb wuriimbig igo eng gari Tain imbig igour. ");
INSERT INTO wnu_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","End an nam quran togor qib nanaui gab eng, yet yarari umimar qemerine umimboumon. ");
INSERT INTO wnu_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ye nam quran togor igoum eng an bo yet ba togor yiimbiguboumon. Ye munon mein yonomit misir me igub igoum, end yet yarab umimboumon. ");
INSERT INTO wnu_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ye nam quran andarib quraum eng uber, qugurau ue, sigen,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Yisas qob eng ende qamb qen gurumnami ende umi ne qen geret inorou qent wit man qobot qib igoai. Qib igama wonou imbigau yurau eng nob qib igo borusi minemb ne wit qur ba nub qib igurei. ");
INSERT INTO wnu_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ende at qib igamari munon Parisi eng der ibag Yisas nob qamamir: “Nonou yurau at qib igour eng ibagan? Wuri gitarau qomon igo eng biisitet inorou qent eng obour eng uber ue.” ");
INSERT INTO wnu_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ende qamarari Yisas taui qamar: “Qoan Debit wonou munon yurau wurinob minemb maigas atemirei igama wanunger gab igoumon? ");
INSERT INTO wnu_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Wo Qenu wot igau munai mor end isub wonou yurau oramar Qenut mian yab big igour eng, munon Pris qas nub igour eng wuri bo qomon biisitet numir eng an qoyam ue e? ");
INSERT INTO wnu_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ne gor, Moses qomon qoan gumater eng wanunger igoumon. Munon Pris yurau eng gari inorou munai mor end sarau baab igo qomon eng biisitet Qenut mian yab big igour eng wuri nub igour eng qomon ger me biisitet igamau qiyo? ");
INSERT INTO wnu_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","End ne ye ete aninob qemerini, munon see igo eng inorou munai wotanami igo. ");
INSERT INTO wnu_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","End Qenu qob ete igo, “Ye wai mian yab big igour eng me qenunget igoum, qomon uber eng qenunget igoum.” Qob ende igo eng an mom musub imbig eng an munon qei qomon boru obour qamb me wurit mindigar qob qamb qirunanei. ");
INSERT INTO wnu_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Munangit wau wo Sabat qen eng wonou baraitari igo.” ");
INSERT INTO wnu_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yisas ginam eng wogub bo wurinou inorou munai ger isorei. ");
INSERT INTO wnu_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ginam end munon ger uben gurumot uburer eng end igoai. Igama Yisas inorou qen songi musia gab baab uyort bigub qamb yar qebi qamamir: “Ininou qomon igo eng mai songi inorou qent munon e musioruboun qiyo?” ");
INSERT INTO wnu_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yisas taui qamar: “Aninou munon end ger wai sipsip gari qas igama ne inorou qent tumun erobon isa mai gab wegiba qiyo, ba bigiba? ");
INSERT INTO wnu_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Munangit eng wai wuritanamimour, end ininou qomon eng song songi munon ger borubura gab musiorun.” ");
INSERT INTO wnu_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ende qamb munon uben umor eng nob qamar: “Uben deges arir ge!” Ende qamara munon eng uben deges arirama uben ig uber eng gas ende ebeterei. ");
INSERT INTO wnu_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ende aba gab Parisi der qob musub qamb imbig Yisas waramb qamb wogub isumirei. ");
INSERT INTO wnu_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ende abari qob igub ginam eng wogub qoa munon yurau irou toat isumirei. Isari munon toar nob irou wurimusub igoai. ");
INSERT INTO wnu_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ende at ne munon qei wurinob qomorunor qamb wuritaisiarei. ");
INSERT INTO wnu_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Mi eng ebeter eng munon miteri qamb gumater eng Aisaia qob ete qamb gumater eng irimaniom qamb: ");
INSERT INTO wnu_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Munon e yonou sarau munon, yonou oau uri eng anit maribigomei. Wo ye sig qenunget igoum. Yonou Igomurur qau eng wot igoriba. Igo ye munon qen geret wuriqereiemin eng wurinob qamb igoriba. ");
INSERT INTO wnu_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Wo qob qemeriner eng wurisiningoar oromar me qemerinerei. Ne gor wonou qen big yagaiar qamb munon menmant qiyo tap togot end iua qob diban me qemerinerei. ");
INSERT INTO wnu_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ne qagab ger inumor isub igama gab eng bo ba togosia musub naget igoriba. Urut qarub umib at igama eng wo bo me gusi opursierinerei, musub igama igoi bo qarub aib qoregen dieriba. ");
INSERT INTO wnu_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ne munon gugum wurinou qenungau eng wot gari igorubour. ");
INSERT INTO wnu_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ne munon qei munon ger ai bigau warama mag tuumot ne qob gor me qamb igamau eng ba Yisast diamirei. Diarari Yisas musia mag asi qob musub qamarei. ");
INSERT INTO wnu_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ende aba gab munon gugum qiet ne qamamir: “Munon eng mai, Debit wonou wau tumbig qiyo?” ");
INSERT INTO wnu_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ende qamarari munon Parisi yurau eng igub der qamamir: “Munon eng aibigau orotoar ariramar eng, wo aibigau wurinou baraitari aib eng unum Belsebul wo boopuri igo end wo nonogursia munon ai igaramb igo eng orotoar arir wurimusub qib igo eng.” ");
INSERT INTO wnu_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ende qamb abari Yisas wuriimbig ne qamar: “Munon ai garit erogori igour eng bo der purab tau-tau isub wurinou bo yogurunor eng bo qibanamsi me igorunorei. Ne gor, munai ginam garit igour eng qiyo a wurinou qanam erogori eng der purab tau-tau isub yogurunor eng gor bo qibanamsi me igorunorei. ");
INSERT INTO wnu_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ne Satan wonou yurau eng der wonou yurau tau eng nob yogub eng purab tau-tau isubour. ");
INSERT INTO wnu_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","End yet quraumon eng, Belsebul ye yenogursia aibigau orotoar arirama qamb quraumon eng. Mai your aninou munon eng wurinonogursia aibigau orotoar arir igour? End aninou yurau eng der soagen anit qomorubour. ");
INSERT INTO wnu_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ego Qenu Igomurur qau ye yenogursia aibigau orotoar ariramine gab eng Qenu wonou bibis end igoarar qamb maribagatarer eng qo anit yarerei.” ");
INSERT INTO wnu_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Qamb qamar: “Munon uter ger wonou munai mor end igama ne munon ger mor isub wonomi eng urim baib qamb eng mai ebesam wab is baiba? Ue, gigit munon eng mi big-big mor isub ne baab touri wogub ne wonomi eng baiba.” ");
INSERT INTO wnu_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ende qamb qamar: “Munon ger ye yemerimisab igo eng yonou munon qarau. Ne munon ger ye nob mi qiumuni me big igo eng wo mi ba song-song arir igo. ");
INSERT INTO wnu_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","32","Qanam end ne aninob quraum eng: Munon ger qomon boru ebet qiyo a qob boru ger qamb ebeiner eng Qenu wot birogonimba. Ego Qenu wonou Igomurur qau end qob isi wot qamb qiyo mi eng gagar ebeiner eng Igomurur qau mom-mom mogirt wab wegiba. See ne qen geret eng mom ende igoriba.” ");
INSERT INTO wnu_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Ne gor, nam qur nub igoun eng nam qen eng gor uber igo. A nam qur boru eng nam qen eng gor boru igo. Munon nam qur eng gab ne imbig ne, ‘qo nam e uber nam e boru’ ende qamb igour. ");
INSERT INTO wnu_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","An munon boru, an mani guterag gas ende. End an misir uber ger eret igub qomoruboumon? Aninou misir end qomon boru yab di qoa ne qabarit dibes qamb igoumon. ");
INSERT INTO wnu_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Munon uber wuri misir uber igo end qomon uber ba dibes ebet igo. A munon boru wo misir boru igo end qomon boru ba dibesia gab igoun. ");
INSERT INTO wnu_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","End aninob quraum, munon wuriqereimau qen end munon qob boru qamb igour end wuriqereimba. ");
INSERT INTO wnu_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ne qob uber qamb igorinen eng Qenu nenet munon qoregen qemeriba. A qob boru qamb igorinen eng nenet munon mindigar qob qoat ende nenet qemeriba.” ");
INSERT INTO wnu_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ende qamara qomon imbig igour eng ne Parisi munon qei der nob qamamir: “Imbigau Munon, ne qomon wes ger aba gub qamb qenungoun?” ");
INSERT INTO wnu_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ende qamarari wo bo taui wurinob qamar: “Munon qarig ir ne mindigar qob qoat eng wuri qomon wes end ebine gub qamb quraur eng qe? Ego ye qomon wes ger me ebine gunorei. Qoan qob gigit qamarau munon Yona qomon wes ebeter eng qas wuriimbigine gubour. ");
INSERT INTO wnu_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Eng gas, yag wai aib ger Yona mua wogub is iriam erobon end qen ombur gari ne itum ombur gari igoar gas ende Munangit Wau gor qen ombur gari ne itum ombur gari ende tumun erobon end igoriba. ");
INSERT INTO wnu_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Qenu munon wuriqereiminer qen end munon ginam Ninibe wuri der an munon see igoumon eng aninou qomon eng anit dibes qomorubour. Qanam eng qoan Ninibe munon Yona qob qamara oau igeseramir end. Ego munon see anamar igo eng wo Yona wotanamima. ");
INSERT INTO wnu_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ne gor Qenu munon wuriqereiminer qen end yamangar baraitari ger der naget munon see qomon ebet igour eng dibes aninob qamb ugeiba. Yamangar eng wo ai pa igo Solomon qob qamara igib qamb dier eng. Ego end ete aninob qemerini: Munon see e igo eng Solomon wotanamima, wo sig aib.” ");
INSERT INTO wnu_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","44","Ende qamb bo qamar: “Aibigau ger munon wot isub igoi wogub der qoaiba. Iua seger ait end qib munai ger gab umiemini qamb asi qib-qibei seret wogub wonou misirt ete qamar: “Qo, wonou munai qoan wogub iuam sambur end bo irini.” Ende qamb irab wonou munai sambur eng gar eng munon ger me igamau. Munai wab arir musub wugumirei igama garei. ");
INSERT INTO wnu_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Gab bo isub aibigau bo 7-ende oramar diarei. Aibigau 7-eng wurinou qomon eng sib boru aib. Erogori diab munai end igurei. Igamari munon eng qoan aruab igoar eng ios ende, ne see bo sig borusi mom aruab igo. Qomon eng gas ende Qenu munon wurinou qomon qereiminer eng ende gas oboubour.” ");
INSERT INTO wnu_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yisas qob eng ende wurinob qamb isub igama wonou unor umomori big gub qamb diamirei. Diab ag naget igo Yisas nob qamarari ag deriner qamb qamamirei. ");
INSERT INTO wnu_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ne munon ger end igo Yisas nob qamar: “Nonou nani imaori big diab qob nonob qomorub qamb ag naget igour. Iro ibeg.” ");
INSERT INTO wnu_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ende qamara Yisas taui qamar: “Your eng yonou nani? Ne your eng yonou ima?” ");
INSERT INTO wnu_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ende qamb ne wonou imbigau yurau eng wurigumar qamar: “Yonou nani ne yonou imaori e gagar igour eng ibagaiar. ");
INSERT INTO wnu_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Munon yonou Tain wonou ginamt igo mi abar qamb qamara igetet mi ebet igour eng yonou ima, imemi, ne yonou nani,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Qen end gari Yisas ginam eng wogub bo ya gabut wes iro isub end igo qob wurinob qemerib qamb. ");
INSERT INTO wnu_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ende isa munon yurau irou yar Yisas qouiamirei. Ende abari Yisas qob maigas at me wurinob qemerinerei eng gab tabint isub mugenderi end igama munon yurau aib eng ya gabut end igamari qob wurinob qamb igoai. ");
INSERT INTO wnu_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Qob eng mit big ete at wurinob qamar: “Munon ger nanasingir qur bis wonou man end goanib qamb isorei. ");
INSERT INTO wnu_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Isub nanasingir qur boogibi bunumban ariramorei. Arirama qur qei is ai tap qenen qib igour end diban igama morogan numirei. ");
INSERT INTO wnu_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","6","Ne qei is ai nomon qer diban end is igo qaur qand diamir eng ai um ue end worom asi gea qand gegeret uburemirei. ");
INSERT INTO wnu_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ne qur qei is tub nob morogot diamir end tub wuriirebiga git musub me barirau. ");
INSERT INTO wnu_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ne qur qei is ai qurun uber end deremir eng qaur uber di git uber baratemir eng irou, qei 100-ende, ne qei 60-ende, ne qei 30-ende.” ");
INSERT INTO wnu_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ende qamb qamar: “Ye qob e at quraum eng munon ger wonou iruges big igib qamb eng iginer,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Yisas mit big ende wurinob qamara ne wonou imbigau yurau eng der Yisas qebi nob qamamir: “Ne meimet qamb mit big qob ende at wurinob quran?” ");
INSERT INTO wnu_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ende qamarari Yisas taui wurinob qamar: “Qenu wonou ginamt wonou bibis end qob waber igoar eng an qo qoyametamanei, munon yurau e wuri ue. ");
INSERT INTO wnu_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Munon ger mi irou igoriner eng Qenu bo mi irou uta wo bo mi sig irou igoriba. Ne munon ger mi ios nami ete igoriner eng Qenu bo wot baia wo bo mi sig ue igoriba. ");
INSERT INTO wnu_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Qanam end ne ye mit big wurinob quraum eng ete: wuri mi gub qamb asiomunor eng me gunorei, ne qob igunor eng bo qanam sir me imbigunorei. ");
INSERT INTO wnu_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","End munon miteri qamb gumater eng Aisaia ete qamb gumater eng munon yamangar wurit dibenteriba: An qob tandari igunon eng qanam sir me imbigunanei. Gub qamb asiomunon eng bais me gunanei. ");
INSERT INTO wnu_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Wurinou misir eng mom qanganget wogubour. Ne qob igau end iet iruges warubet wogubour. Ne mag asi mi gun qamb mauri igorubour. Irugest qob igub misirt imbigubour. Ende at wuri igeser yar yet Qenu qamarari wurimusieribam. ");
INSERT INTO wnu_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","End an magqurt mi gab igoumon ne irugest qob igub igoumon end mismisir igoarar. ");
INSERT INTO wnu_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Mi e musub igar, qoan munon miteri qamb gumatemir eng irou ne Qenu wonou munon qoregen irou igour eng an mi see gab a igub igoumon eng wuri gab a igub qamb mismisir igour eng bais me gab ne igau, ue ar.” ");
INSERT INTO wnu_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“See ye mit big munon ger nanasingir qur wonou man end bunumban ariramorei quraum eng bo qanam dibes qemerine igar. ");
INSERT INTO wnu_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Munon Qenu wonou bibis qob eng igub ne me imbig igour eng, munon nanasingir qur arirama is tapet diban igama morogan nia gas ende. Satan yar Qenu qob igunor eng bo aba nasi igour eng. ");
INSERT INTO wnu_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ne nanasingir qur qei is ai nomon qer diban end igo qaur qand dia gas eng, munon qob igub qand imbig mismisir igour eng. ");
INSERT INTO wnu_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ego qob wurinou misirt qenen me reminer eng, qen dirigor me igorinerei. Munon qei Qenu qob siningot igour eng yar nob agunub qiyo, a quguragsi abari qob iginer eng mogirt wab wegiba. ");
INSERT INTO wnu_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ne qur qei is igo tub nob morogot di igour eng, munon git qob igub imbig igoriner ego, mind irou baib qamb, ne nomon qur baib qamb misir qebebi igub ende ebet Qenu qob eng bumai igo. Ende aba ne Qenu qob ne qomon uber eng wot me dibent igo. ");
INSERT INTO wnu_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ne qur qei is ai qurun uber end der qaur di git irou baret igo. Git qei 100, ne qei 60, ne qei 30-ende eng munon qob igub imbig ne toat wot oabig igo eng.” ");
INSERT INTO wnu_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ende qamb bo qob ger mit big qamar: “Qenu wonou ginamt bibis big igo eng ete gas: munon ger wit qur bisub wonou man end bunumban arir wogub diab munon gugum inemirei. ");
INSERT INTO wnu_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Itum end munon wit qur bisub ariramor eng wonou munon qarau eng, itum end maran qur qei ba yar morogot arir wogub qorei. ");
INSERT INTO wnu_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Igama wit qur qaur di isarima gamir eng maran nob morogot isariamorei. ");
INSERT INTO wnu_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ende gab munon eng wonou sarau munon eng is gab diab wurinou munon barai eng nob qamamir: “Barai, ne wit qur qas bisub nonou man end ariramonei qamb is gaun eng maran qur nob yesir qaur di isari igour eng, maran qur eng eret igo di isari igour?” ");
INSERT INTO wnu_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ende qamarari wo der wurinob qamar: “yonou munon qarau mi eng ebetemirei ne?” Ende qamarari wuri qamamir: “Ne mai misir igan? In isub maran eng benerumi ariromun qiyo?” ");
INSERT INTO wnu_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ne wo qamar: “Ue, an maran benerumi munon eng wit qei ten nerer dieriba. ");
INSERT INTO wnu_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Eng gab wagari song yesir ende di igorunor. Qen geret wit arira gab munon wit suounor eng wurinob qemerine isub maran eng sopumi qungai mutet ariramari oa wit qur qas ba qiumuni mi ibiau munai end bigar,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ne bo mi geret big qamar: “Qenu wonou ginamt bibis igo eng nam mastet qamb igour eng wonou qur gas ende. Munon ger nam qur eng bisub wonou man end goaneterei. ");
INSERT INTO wnu_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Nam qur eng sig qamaaman qabu qur gas ende, qaur di aibtar eng nam gugum wuritanami wo sig aib. Ende aib burab orom wab aba morogan yar mon ubet inau big igour.” ");
INSERT INTO wnu_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ende qamb bo mi geret big qamar: “Qenu wonou bibis wonou ginamt inimbig igo eng ete gas, yamangar ger mani parau iseib qamb yis eng baiste ba mani parau eng egit ten igama yis baist eng arir i wogub isia yis baist eng mani parau aib eng aba ten qarib diarei,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yisas munon yurau aib qob wurinob qamb igoar eng dibes ger me wurinob qamarau, mit big qas wurinob qamb igoai. ");
INSERT INTO wnu_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Wo mi eng ebeter eng wonou misirt me abau. Qoan qob gigit qamarau munon ger ete qamb gumater eng toat ebet igoai: Ye qob wurinob qemerib eng mit big qas wurinob qamb igoribam. Ye qoan ai big-big mi qi igoar eng isi yarab mi see igo end big wurinob qamb igoribam. ");
INSERT INTO wnu_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yisas munon yurau aib eng qob ende wurinob qamb wogub mor isa wonou imbigau yurau eng yar nob qamamir: “Ne mit big girabur asin wit nob yisir di igour quran eng qanam musub qamara igun.” ");
INSERT INTO wnu_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ende qamarari Yisas taui qamar: “Munon mi niau qur bisub wonou man end goaneter eng Munangit Wau. ");
INSERT INTO wnu_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ne man quraum eng ai qen e gugum, ne wit qur quraum eng munon Qenu wonou bibist igour eng. Ne misugan qur asin quraum eng munon Satan wonou yuraut igour eng. Mani arirau qen quraum eng qen sindomund mi gugum uburiner qen eng. Ne munon mani arira goanet igour quraum eng Qenu wonou munon yurau enger wuri. ");
INSERT INTO wnu_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Munon qarau misugan qur bisub ariramorei quraum eng Satan. ");
INSERT INTO wnu_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ne misugan ar eng sopumi qungai bisub mutet gumoubour quraum eng qen sindomund end munon Satan wonou yurau eng mutet isunor end. ");
INSERT INTO wnu_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","42","Qen end Munangit Wau wonou enger wuriimurima isub munon yurau Qenu bibis end igorubari wuriquguragsiari qomon boru ebet igour eng ne qomon boru qei ebet igour eng, gugum wurisogar mut qenen oab igo end wuriariramari end igo migeri ur igara nan qingimgot igorubour. ");
INSERT INTO wnu_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ne Qenu wonou munon yurau eng wuri worom begen gas ende igo wurinou Ur bibis end igorubour. An iruges nob igo gab eng qob e igub imbigar.” ");
INSERT INTO wnu_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Yisas qob eng ende wurinob qamb wogub bo mi geret big qamar: “Qenu wonou ginamt bibis eng ete gas, munon nomon qur qirinau bigari qoat igour eng ger nomon qur abau ger bisub man end goanet tumuniamorei. Ne bo munon ger qib gab ne wo bo qon biineri biua ai taut tumuniamorei. Tumuni wogub sig borusi mismisir wogub ai eng ten baib qamb wonomi eng gugum munon qei wurisab taui qur baub ne isub ai eng ten baurei.” ");
INSERT INTO wnu_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ende qamb bo mi geret big qamar: “Qenu wonou ginamt bibis igo eng ete gas, munon nomon qur nob eng wo gorur qenenginob eng nomon qur aibt taui baib qamb asi qib igo. ");
INSERT INTO wnu_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Qibei gorur uber ger gab baib qamb isub wonou mind qei eng munon qei wurisab nomon qur taui ba diab gorur eng baub igo.” ");
INSERT INTO wnu_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ende qamb bo mi geret big qamar: “Qenu ginamt bibis eng yag wai baub qamb dob ya tait ariramari isa yag wai wes-wes yar erobon isub igo gas ende. ");
INSERT INTO wnu_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Isub diara ne munon dob arir igo eng ubumot ten ba daan diab bugab igo ne yag wai qerei igo. Qerei uber-uber eng ba abaut uyab ne boru-boru eng arir igo. ");
INSERT INTO wnu_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","50","Eng gas ende qen sindomund end munon yamangar ende wurisieriba. Enger der munon boru munon qoregen nob yesir igour eng, wuriwanungar wuriimurima mut aib qenen oab igo end isubour. Isub end igo eab nanqur qingim got igorubour.” ");
INSERT INTO wnu_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ende qamb ne wuri qebi qamar: “An ye qob e quraum eng qanam musub mom imbigoumon qiyo?” Ende qamara wuri qamamir: “Io.” ");
INSERT INTO wnu_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Qamarari wo bo taui qamar: “Qomon imbigau munon wuri qomon qoan imbig ne Qenu wonou bibis eng gor qo imbigumir end wuri munon ger wonou mi uber-uber qoan eng ba mi bubun ba sori big wogub mismisiriba.” ");
INSERT INTO wnu_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","54","Yisas qob eng ende wurinob qamb ugab wogub ginam end wogub wonou ginam qenen end isorei. Isub wurinou inorou munai mor end isub qob wurinob qamara igub qiet qamamir: “Wa, munon eng qoyam eng eret baurei? Ne gor qomon wes eng eret imbigorei igo ebet igo-o? ");
INSERT INTO wnu_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Wonou ur munon mon mindau qoyam eng, ne wonou unor Maria, ne wonou umuragrari eng Yems, ne Yosep, ne Saimon ne Yudas? ");
INSERT INTO wnu_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ne gor wonou umemdagar eng gagar in e wurinob igoun? Ego munon eng wo qoyam eng eret imbigorei?” ");
INSERT INTO wnu_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ende qamb merimotet ebetemirei. Ende abari Yisas wo der wurinob qamar: “Munon miteri qamb igo eng ger der wonou ginam qenent qiyo a wonou yurau oramar sarau baab a qob qamb ebeiner eng bumaimbour.” ");
INSERT INTO wnu_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ego Yisas wo qomon wes ger qebebi ginam qenen end me abau. Wurinou ar wot me oabig igo at igurei. ");
INSERT INTO wnu_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Qen end Herot wo munon barai igo ai Galili qoat igoai. Igo Yisas eng at qiroa qob toau isa igorei. ");
INSERT INTO wnu_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Igub wonou burtuum qoat igour eng wurinob qamar: “apand Yon munon yat wurimaragansi igoar eng bo igomot der bugab at qib igo. Wonou sarau qeretutnob qoan at igoar eng bo at qib igo eng,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Herot wo eng qamar eng, wo Yon baab touri uyort bigor end wo eng ebeter eng qanam eng, Herot wonou umour Pilip ubeni Herodias wo bo omboagir baia gab ne Yon wo der Herot nob qamar: “Nonou ima irub eng ne bo baian eng boru.” ");
INSERT INTO wnu_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ende qamara Herot oau biriberi nub wogub Yon mom waramb qamb ater ego, Yuda munon qei Yont “qob gigit qamarau munon ger igoriba” qamb wot qamb igour eng yari wagerei. ");
INSERT INTO wnu_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Qen end Herot unor bauor qen eng gab mi at nub qiumuni igamari Herodias waibou diab munon gugum magqurt uru uyerei. ");
INSERT INTO wnu_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Uya Herot gab oau naget ne qob gagam nausi nob qamar: “Sig apand mom nonob quraum, ne mi ger qenunget qamara eng neteibam.” ");
INSERT INTO wnu_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ende qamara yamangar eng unor eng der waibou nob qamara isub Herot nob qamar: “See qas isub Yon munon yat wurimaragansi igoar eng quman soopur qamamitabin end big ba diab et yeis.” ");
INSERT INTO wnu_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ende qamara Herot borusi toubeter, ego wo qob qoan munon yurau aib magqurt qob gagam mom nausier eng gab qamar: “Mi eng qurar eng ba di utar,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","11","Qamb bur tuum ger imurima uyor munait end isub Yon quman soopur qamami tabin end big ba diab yamangar yorou eng utari bisub unor sirbigorei. ");
INSERT INTO wnu_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ende abari Yon wonou imbigau yurau eng yar gitgoan bisub tumuni wogub isub Yisas nob qamamirei. ");
INSERT INTO wnu_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yisas qob eng ende igub wogub ginam eng wogub wonomai tabin ba bo ig munon uet wes end isorei. Isa munon ginam aib eng qob igub toat ag isumirei. ");
INSERT INTO wnu_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yisas tabin wogub ag der munon yurau aib eng ende ibag borusi wuritoubar ne munon qei toar nob eng wurimusub igoai. ");
INSERT INTO wnu_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Mi gugum end wonou imbigau yurau eng yar nob qamamir: “Qen mom ubura, ne gor ar ait e gab ne munon yurau ai e qand wuriimurima iua wurinou ginamt mani gab taui ba nunor.” ");
INSERT INTO wnu_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ende qamarari Yisas taui qamar: “Ue, me inwogub qoounor, aninou mani gab wurisari nunor.” ");
INSERT INTO wnu_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Qamara wuri qamamir: “In mani parau ten 5 ne yag wai ombur-ombur gari igo.” ");
INSERT INTO wnu_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ne Yisas taui qamar: “Mi eng gagar ba yar yesari.” ");
INSERT INTO wnu_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ende qamara ba yar utari ne munon eng wurinob qamara misugant end bugoramirei. Ne wo mani parau ten 5-ende eng ba yagwai ombur eng nob ba qiter qite asi Qenut uber qamb mani parau wai eng nob boroumi wonou imbigau yurau eng wuriserei. Wurisa wuri ba munon yurau aib eng wurisemirei. ");
INSERT INTO wnu_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Gugum nub mom qur diamirei. Ende abari wonou imbigau yurau eng tugar 12-ende baub mi nub tatau wagomir eng tugarimari dieramorei. ");
INSERT INTO wnu_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Munon yurau aib eng mani numir eng qangang 5,000-ende. Ne yamangar qamb wau qamb eng me wuriwanungermau. ");
INSERT INTO wnu_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Mani ende wurisari niari wogub Yisas wonou imbigau yurau eng wurinob qamara wuri tabin ba gigit ya tai eng purab ig iro isumirei. Isari wonomai munon yurau eng wuriimurima qoamirei. ");
INSERT INTO wnu_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Qoari ne wonomai Qenut qebi qemerib qamb ai qaur eng irarei. Ai gab-gab Yisas wonomai end igoai. ");
INSERT INTO wnu_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Qen end wonou imbigau yurau wuriimuriamor eng tabin ba ya tai wubunobun irend isub igurei. Qen end moon aib di ya bures arir ende aba pondogub isub igurei. ");
INSERT INTO wnu_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ende isub igamari ai uter tubub diara yonam asi gamir eng Yisas ya erer isub igoai. Isub igama geari-geari is iseii wuri qani isa uriger uburerei. ");
INSERT INTO wnu_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ende gab borusi yari qamamir: “Wa, aibigau qiyo, moui ger yar igo qi-i?” Ende qamb borusi eab aimot uburemirei. ");
INSERT INTO wnu_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ende abari Yisas qand wurinob qamar: “An nonoguret igoarar, e ye gari, me yarimar.” ");
INSERT INTO wnu_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ende qamara Pita der qamb ar: “Munon aib, eng ne apand gab eng yonob qamara ye gor ya erer ne qani yaribam.” ");
INSERT INTO wnu_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Qamara Yisas taui qamar: “Yar.” Qamara Pita tabin erer igo ya erer qumo orubor ya erer naget-naget Yisas igama qanambig isorei. ");
INSERT INTO wnu_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Isub ya aib qarib di yara gab oau uburab isub wogub ya erobon qumo isib at ne Yisast simot qamb ar: “Barai yeba ereriom.” ");
INSERT INTO wnu_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ende qamara Yisas qand uben arir bea diara nob qamar: “Ne oau apand burab igoan quraum eng ue ne? Meimet qamb misir qebebi igub igoan?” ");
INSERT INTO wnu_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ende nob qamb wogub ombur tabin erer iroari moon aib eng purerei. ");
INSERT INTO wnu_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Pura wonou imbigau yurau eng der Yisas unum bereri qamamir: “Sig apand ar, ne Qenu wau ten,” ende qamb amirei. ");
INSERT INTO wnu_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ende at wogub isi ginam Genesaret end deremirei. ");
INSERT INTO wnu_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Isari munon ginam eng ibag qob bigari ginam qani-qani eng isa igub munon toar nob igour eng oromar Yisast yaremirei. ");
INSERT INTO wnu_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Yarab Yisas nob qamarari toar munon eng mi goan gabut qas baab uberburar qamb qamarari Yisas “Io” qamara toar munon eng gagar mi goant qas baab uberetri igurei. ");
INSERT INTO wnu_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Yisas end igama ne Parisi ne qomon imbigau munon qei Yerusalem wogub Yisast yar qebi qamamir: ");
INSERT INTO wnu_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Meimet qamb nonou imbigau munon yurau eng ininou tonoanb qomon inimbigumir eng biisitet igour? Wuri mani nub qamb uben me birogoni igour eng?” ");
INSERT INTO wnu_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ende qamarari Yisas taui qamar: “Ne an gor meimet qamb Qenu qomon eng biisitet igoumon? ");
INSERT INTO wnu_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Qenu qomon ete igo eng, “nani taineb qob qamarari igatar,” ne “munon ger nani qiyo, a tain qob isi wurit qamara gab eng mom umb qas weginer.” ");
INSERT INTO wnu_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ego an bo ete at qamb igoumon, Munon ger nomon qur qiyo a mi qei gab unor ur wurisiner eng qeemben, ego an bo der wurimurimar, mi eng gagar andaribam ego Qenut bigib qamb maribigom end me andarinei. ");
INSERT INTO wnu_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Tain nanib wuriqenungar wurimusiau eng mi aib ue.” An ende qamb ne aninou misirt qomon bubun ende toat igoumon eng aninou mi bereri ne Qenu qomon apand eng biisitet igoumon. ");
INSERT INTO wnu_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","An munon qetopur qob qamarau tari. Qomon eng obounon end munon miteri qamb gumater eng Aisaia ete qamb gumaterei. ");
INSERT INTO wnu_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Munon yurau eng ye unum bererimoun qamb qabarit qas qamb igorubour. Wurinou misir eng yet me igunorei. ");
INSERT INTO wnu_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Munangit wurinou qob eng qas qob suab eng Qenu wonou qob ende qamb munon wurimurimar igorubour. Ende at yet ar mismisiraun qamb ebet igorubour. ");
INSERT INTO wnu_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ende qamb wogub munon yurau aib eng wurit qamara yar qiumunimari wurinob qamar: “An qob eng igub ne musub imbigar. ");
INSERT INTO wnu_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Munon ger qabarit mi nia iriam erobon isub igo eng me ununsi igo, ue. Mi iriam erobon igama qabarit dibes qamb igo eng munon ununsi igo.” ");
INSERT INTO wnu_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ende qamara wonou imbigau yurau eng yar nob qamamir: “Ne qob eng at qamara Parisi munon oau boruburour eng me ibagan?” ");
INSERT INTO wnu_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ne Yisas taui qamar: “Yonou Tain wonou ginamt igo eng wonou man end mi ger wonou ubent ubub me giner eng beneri ariramba. ");
INSERT INTO wnu_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","End an wuri eng abari misir qebebi me igar. Wuri mag tuum end qei mag tuum eng wuriimbigub ebet igour. Ego munon mag tuum igo munon ger mag tuum tap imbig me qib igo. Ende ebet eng ombur yaru isub umubour.” ");
INSERT INTO wnu_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ende qamara Pita der qamar: “Ne qob eng mit big quran eng qanam dibes qamara igun.” ");
INSERT INTO wnu_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ende qamara Yisas taui qamar: “An gor qanganget igoumon ne? ");
INSERT INTO wnu_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","An qoyam ue, mi gugum munon nub igo eng iriamt isub ibi waria bo ibiat arir igo. ");
INSERT INTO wnu_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","A munon mi misirt igama ne bo qabarit dibes qamb igo eng munon aba ununburab igo. ");
INSERT INTO wnu_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Eng mi eng gagar: munon geret oau boruburab duimb qamb misir igub qiyo, a yamangar omboagir qiyo, a qininingau qomon ebet qiyo, a urim ba qiyo, qetopur qamb qiyo, a munon qei wurit ar mindigar qob qamarau eng. ");
INSERT INTO wnu_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Mi eng gagar ebetri igour eng munon ununsi igo. Ego uben unun ten mi baab niau eng, an uben unun ten mi baab nioumon qamb anit quraur eng munon me ununsi igo,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yisas ginam eng wogub ginam aib Tair Saidon nob qani end is qib igoai. ");
INSERT INTO wnu_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Qib igama ne Kenan yamangar ger ginam end igoar eng Yisast yarab simot eab qamar: “Barai, Debit wonou wau, yonou yamangar wau ger aibigau waramorei igama sig borusi aruab igo. Ende igama ye borusi wo toubet quguraget qib igoum. Yetoubet gab eng musia ye oau meinburibam.” ");
INSERT INTO wnu_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ende qamara Yisas qob ger me nob qamarau. Ne wonou imbigau yurau eng yar Yisas nob qamamir: “Yamangar e intoar-intoar eab qib igama in ietroun, toat arirama qoeiner.” ");
INSERT INTO wnu_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ne Yisas taui qamar: “Qenu ye yiimuriamor eng wai sipsip Isrel yurau end qaar rab igour eng gari wurimusi qamb.” ");
INSERT INTO wnu_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ne yamangar eng yar Yisas gotennamt end gamaur wat bugab qamar: “Barai, yemusi.” ");
INSERT INTO wnu_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ende qamara Yisas taui qamar: “Wau wurinou mani tau ba iau wurit ariramatarun eng uber ue.” ");
INSERT INTO wnu_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ne yamangar eng qamar: “Barai, eng apand, ego iau wuri inab igo wurinou ur mi niari tub isa nub igour.” ");
INSERT INTO wnu_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ende qamara Yisas taui qamar: “Ne yamangar oau apand aib igo, end ne mi qenunget quran eng ende aba giban.” Ende nob qamara qen end qas waibou uberetarei. ");
INSERT INTO wnu_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yisas ginam eng wogub bo ya tai Galili qani end isub ir ai qaur ger ir bugab igoai. ");
INSERT INTO wnu_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Igama munon yurau irou munon goten gurumtriamir eng ne, mag tuumtriamir eng ne, qer amamiriamir eng ne, iruges tuumtamir eng ne, toar ar qei irou igab igoar eng oromar yar Yisas gotennamt end wuribigari wurimusub igoai. ");
INSERT INTO wnu_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ende wurimusia munon qob me qamb igamau eng bo qob qamb qiyo, a qer amamiramir eng bo tog burab qiyo, a qoan me qib igamau eng bo qib qiyo, a mag tuum eng bo asi mi gab qiyo, eng abari munon ibag qiet ne Isrel wurinou Qenu eng unum bereriamirei. ");
INSERT INTO wnu_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yisas munon yurau aib eng ibag wonou imbigau yurau eng wurinob qamar: “Ye munon yurau e borusi wuritouboroum. Wuri qen ombur gari ende mi me niau, ar inamar igamari isi yarab see. End ar tor ete wuriimuriomun eng iua qataben umb nerer isubour, eng gab in mi gab wurisune nub nonoguretarari wuriimuriomun.” ");
INSERT INTO wnu_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ende qamara imbigau yurau eng der qebi qamamir: “Seger ait e, mani eret gab ba munon yurau aib e wurisune qeemben nubour?” ");
INSERT INTO wnu_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","End qamarari Yisas wuriqebi qamar: “An mani parau mai-mai igo?” Ne wuri qamamir: “Mani parau 7, ne yag wai qamaaman qei igo.” ");
INSERT INTO wnu_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","36","Ende qamarari Yisas munon yurau aib eng wurinob qamara ag bugoramirei ne mani parau 7 ne yag wai qei eng nob ba Qenut uber qamb ne boroumi wonou imbigau yurau eng wuriserei. Wurisa wuri ba munon yurau aib eng wurisemirei. ");
INSERT INTO wnu_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Wurisari mom nub tatau wagari imbigau yurau eng mani tatau eng usisi ba tugar 7-ende tugarimari diarei. ");
INSERT INTO wnu_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Munon yurau aib eng mani numir eng qangang 4,000-ende, yamangar wau qamb eng me wuriwanungeramau. ");
INSERT INTO wnu_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ende at wogub munon eng wuriimurimari qoari wogub wuri bo tabin ba ai Magadan wes end isumirei. ");
INSERT INTO wnu_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Isari munon Parisi ne Sadyusi yar Yisas wariges qebi qomurune Qenu wonou qomon wes eng aba gub qamb qebi qamamirei. ");
INSERT INTO wnu_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Qamarari Yisas taui wurinob qamar: “Worom uber is neri mian arirama gab, “qo qen mom uber” ende qamb igoumon. ");
INSERT INTO wnu_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ne itumut worom diab ai quruburima mian bura gab, “qo ya deriba” ende qamb igoumon. Git apand ai end aba gab qeemben qerei igoumon. Ego qen see eng qen boru irou dibent isub igo ego an musub me imbigoumon. ");
INSERT INTO wnu_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","An munon yamangar boru misir ue see igoumon eng, ye mi wes ebine gub qamb quraumon. Ego ye mi wes ger me ebinei, qomon wes ger abau eng uput qamb qoan Yona ebeter eng igar.” Ende qamb wogub wuriwogub qorei. ");
INSERT INTO wnu_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Qen end Yisas wonou imbigau yurau eng ya tai eng wogub ig iro isumirei. Qen end wuri mani qibi baioun qamb nasi wogub isumirei. ");
INSERT INTO wnu_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ende gab Yisas der wurinob qamar: “An Parisi Sadyusi nob wurinou yis end qoyamet igoarar.” ");
INSERT INTO wnu_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ende qamara wuri der wurinou qob-qob qamamir: “Mai, in mani qibi nasi wogub yoroun end mai qura qiyo?” ");
INSERT INTO wnu_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ende qamb abari Yisas wuriimbig ne wurinob qamar: “An meimet qamb mani qibi me ba yarau end misir qebebi igub qobub igoumon? Aninou oau apand eng aib ue qiyo? ");
INSERT INTO wnu_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","An mi eng nasi wogomanei qiyo? Qoan mani parau 5-ende boroumi munon yurau 5,000-end wurisune nub tatau wagari usis tugar mai-mai tugarimari diarei? ");
INSERT INTO wnu_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ne gor, mani parau 7-ende eng munon yurau 4,000-ende wurisune nub tatau wagari tugar mai-mai tugarimari diarei. ");
INSERT INTO wnu_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","End ne ye meimet qamb mani qibi baiar qamb me aninob qamarau? An Parisi Sadyusi nob wurinou yis boru end qoyamet igoarar.” ");
INSERT INTO wnu_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ende qamara wuri mom imbig ne qamamir: “Qo, wo eng at qurar eng yis mani paraut big iset igour end me qura, ue. Wo Parisi Sadyusi wurinou qob boru end qura,” ende qamamirei. ");
INSERT INTO wnu_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ende at wogub ne bo ai Sisaria Pilipai nob end isub Yisas der wonou imbigau yurau eng wuri qebi qamar: “Munon yamangar Munangit Wau eng wot mai qamarari igub igoumon?” ");
INSERT INTO wnu_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ne wuri qamamir: “Qei nenet, Yon munon yat wurimaragansi igoar eng. Ne qei nenet, Elaiya, ne qei nenet, Yeremaia, ne qei nenet munon miteri qamb igo ger, ende nenet qamb igour.” ");
INSERT INTO wnu_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ende qamarari wurinou sir wuriqebi qamar: “Ende eng an yet your qamb igoumon?” ");
INSERT INTO wnu_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ende qamara Saimon Pita der taui qamar: “Ne Munon inubersiau tari, Qenu qenen igomot igo eng wonou Wau ten.” ");
INSERT INTO wnu_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ende qamara Yisas taui qamar: “Ne Yon wonou wau, sig uber qeemben ar quran. Ne oau apand eng igama quran eng munangit ger nonob qamarari igub me quran, ue. Yonou Tain wonou ginamt igo eng oau nemenima quran. ");
INSERT INTO wnu_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","End ne ye ete nonob quraum: Ne unum eng Pita, qanam eng nomon. Nomon eng erer end yonou munon yurau eng nenet erer end wuribigine naget nonoguretorubour. Ende igo bo sabar me umunorei. ");
INSERT INTO wnu_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Qenu wonou ginamt bibis big igo tend eng nenet wugine qoat igoriban. End ne ne mi ag et tourieminen eng Qenu wonou ginamt end tourimba. a ag et beasieminen eng Qenu wonou ginamt end gor beasimba.” ");
INSERT INTO wnu_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ende qamb wogub wonou imbigau yurau eng at munon inubersiau tari eng dibes qomorunor qamb qoronob wuritaisiarei. ");
INSERT INTO wnu_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Qen end gari wonou uminer end wonou imbigau yurau eng musub wurinob qamar: “Ye Yerusalem qumo isine munon baraitari eng ne Pris wurinou gigit eng ne qomon qerei imbig igour eng der yanamari umine yetumunimunorei igama qen ombur gari uma bo igomot der bugembam.” ");
INSERT INTO wnu_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ende qamara Pita der Yisas nob wes opur ete isub qamat qamar: “Barai, Qenu ne mom nequbei igo end bais ende me nesiorunorei.” ");
INSERT INTO wnu_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ende qamara Yisas igeser Pita nob qamar: “Satan, qand yewogub iua, ye werei opurama wog. Ne misir eng igub quran eng Qenu wonou misir ue, misir eng munangit wurinou.” ");
INSERT INTO wnu_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ende qamb imbigau yurau gugum wurinob qamar: “An ger ye yenob qib igorib eng wonomit misir me iginer, wonomi qugurau eng togor ye toat yariner. ");
INSERT INTO wnu_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Your ger see igom igamau end misir qebebi igub eng mom umiba. A yet igub wonou git goan eng duieminer eng igomot igoriba. ");
INSERT INTO wnu_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Munon ger wonou git goan musiau end qas misir igub mind irou ba qiumuni big igoriner eng isi yarab uma eng, mind eng der maigas at musieriba? Wonou igomot igorib qamb meimi eng ba taui igomot igoriba? Sig ue ar. ");
INSERT INTO wnu_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Munangit wau wonou Ur qenenginob eng wot isub waga ten deriba, dara wonou enger eng nob dorubour. Qen end munon wurinou qomon ebet igorunor eng taui qamb ende wurisieriba. ");
INSERT INTO wnu_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Mi eng apand aninob quraum, munon qei see igorunor eng qei me umunorei igo Munangit Wau munon baraitari burab dara gubour.” ");
INSERT INTO wnu_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Qob eng ende qamb wogub igamari qen 6-ende ubura ne Yisas der Pita ne Yems, ne wonou umour Yon ende oramar ai qaur aib erer qitend iramirei. ");
INSERT INTO wnu_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Irab gamir eng Yisas igeseramorei. Igeser wonou menman eng worom mag gas ende ebet ne wonou mi goan eng gugum begent uburerei. ");
INSERT INTO wnu_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ende aba wonou imbigau munon ombur gari eng, der gamir eng Moses Elaiya nob der Yisas nob naget qobub igurei. ");
INSERT INTO wnu_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ende ibag Pita der atag ab Yisas nob qamar: “Barai, in ginam et igorun eng sig uber. Ne qamara eng mat ombur gari ende et ubouboun. Ger nonou, ger Moses wonou ne ger Elaiya wonou, ende.” ");
INSERT INTO wnu_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita qob eng ende qamb igama waber oannob ger der wuriqubeima geari ne qob ger waber erobon end igumir eng ete at qamarei: “Wau eng yonou Wau ten, eng yonou oau uri eng, qob qamara igatatar.” ");
INSERT INTO wnu_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Wonou imbigau munon ombur gari eng qob toau eng ende igub borusi yari ai qent qumo qurer inab igurei. ");
INSERT INTO wnu_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ende inab igamari Yisas yar wuribaab qamar: “Der bugamar, me yarimar.” ");
INSERT INTO wnu_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ende qamara matarub asi gamir eng munon ger me geau, Yisas wonou gari igoai. ");
INSERT INTO wnu_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ne ai qaur eng wogub qumo darab munon ombur gari eng mi gamir end munon qei wurinob qomorunor qamb qoronob wuritaisi qamar: “An mi eng aba gaumon end munon ger nob me qamarar. Isi yarab Munangit wau umb bo igomot der bogoma ne.” ");
INSERT INTO wnu_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ende qamara wonou imbigau munon eng der Yisas nob qamamir: “Meimet qamb qomon imbigau munon eng wuri Elaiya wo gigit deriba, qamb igour?” ");
INSERT INTO wnu_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ne Yisas taui qamar: “Io, Elaiya wo gigit der mi gugum arsia ne Munon inubersiau tari qanamt deriba. ");
INSERT INTO wnu_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ego ye mi eng ete aninob qemerine igar: Elaiya wo qo dererei igo, ego munon wuri me imbig ne wurinou misir eng toat ne wo ba sumungasi igour. Eng gas ende gari Munangit wau ende siorubour.” ");
INSERT INTO wnu_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Yisas ende qamara wonou imbigau yurau eng Yon munon yat wurimaragansi igoar end qura qamb imbig wugumirei. ");
INSERT INTO wnu_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ende qamb wogub munon yurau aib igour end bo isari munon ger yar Yisas menmant end gamaur wat bugab qamar: ");
INSERT INTO wnu_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Barai, yonou munonbor wau ger borusi qanganget ne qenen mutet isub qiyo, a yag isub ende at git goan borusi igo. End ne toubet gab eng musi qamb nonob quraum. ");
INSERT INTO wnu_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nonou imbigau yurau eng musiorunor qamb ba wurit diaum ego wuri qeemben ue gab nonob quraum.” ");
INSERT INTO wnu_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ne Yisas taui qamar: “An munon yurau eng oau apand ue ne misir qebebi igau tari. Ye qen mai-mai anamar igo, ne qen mai-mai anmusub igoribam? Qand wau eng ba yarari gine?” ");
INSERT INTO wnu_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ende qamara nob yarari aibigau wau eng opuri igoar eng qamat qamara aibigau wogub qoa wau eng qen end qas uberetarei. ");
INSERT INTO wnu_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ende aba wonou imbigau yurau eng qi yar Yisas qebi qamamir: “Aibigau eng in maigas at orotoar ariramboun?” ");
INSERT INTO wnu_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ende qamarari Yisas wurinob qamar: “Qanam eng, an oau apand eng sig aib ue end. Mi eng gaiar, an oau apand eng nam mastet qur sig qomourt eng gas ende igama eng ai qaur ger nob ete qomoruboumon, ‘ne eng wogub nerer bo is iret nag,’ ende qomorunon eng ende ebeiba. Ne mi qei-qei obounon eng an qob toat ende ebetrimba. ");
INSERT INTO wnu_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ego tap geret aibigau eng orotoar me ariramunanei. Qenut qebi qamb ne mani qei gitab ne mi eng gagar abari ebeiba,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Qen geret wuri Galili end yar qiumuni ne Yisas wonou imbigau yurau eng wurinob qamar: “Munangit wau dui munon qei wurit dibesiorubour. ");
INSERT INTO wnu_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ende ebet munon eng waramari uminerei igo qen ombur gari ubura bo igomot der bugemba.” Ende qamara wonou imbigau yurau eng borusi toubetemirei. ");
INSERT INTO wnu_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ende at wogub Kaperneam end yarari munon inorou munai aib end qur ba igour eng yar Pita nob qamamir: “Aninou imbigau munon wo gor inorou munai end qur big igour eng wo gor big igo qiyo?” ");
INSERT INTO wnu_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ne Pita taui qamar: “Io, wo gor big igo.” Ende qamb wogub wo mor ito isa Yisas Pita nob qamar: “Saimon, ne misir maigas igan? Munon baraitari ag e wurinou qomon eng toat nomon qur big igour eng yourt big igour? Ne gor wuri qur munon wurit ba igour eng, munon ginam qenen wurit qiyo, a munon yogur isub igour eng wurit?” ");
INSERT INTO wnu_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ne Pita taui qamar: “Munon yogur isub igour eng wurit ba igour.” Ne Yisas taui qamar: “End ne wurinou ginam qenen eng nomon qur bais me big igour. ");
INSERT INTO wnu_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ego in bo qumurune ininob agununor qamb. Ne isub dob ba bisub ya tai end arir ge. arir yag wai qamar ubumot gab eng qabari boagir ginen eng nomon qur garit yag wai qabarit end gab eng nomon qur eng ba yar inorou munait qur big igour end big, nomon qur eng biginen eng ininou ombur gari.” ");
INSERT INTO wnu_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Qen end gari wonou imbigau yurau eng yar Yisas qebi qamamir: “Qenu wonou ginamt bibis end your sig aib igo?” ");
INSERT INTO wnu_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ende qamarari Yisas wau ger ba wuri wubunobun et nagasi ne wurinob qamar: ");
INSERT INTO wnu_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","“An e gaiar, an bo igeser ne wau qamaaman gas ende me obounon eng Qenu wonou ginamt bibis end me irunanei. ");
INSERT INTO wnu_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Munon ger wonomi bumai wogub wau e gas at qiriner eng wo Qenu wonou ginamt bibis end munon barai aib igoriba. ");
INSERT INTO wnu_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ne munon ger yet igub ne wau qomourt e musieriner eng ye gor yemusub igo.” ");
INSERT INTO wnu_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ende qamb qamar: “Wau qomourt e yet oabig igoriner eng munon ger wo aba qomon boru aba gab eng, nomon aib ger ba munon eng ibiari wogub ya tumun ombomai ariramari ya nub uminer. ");
INSERT INTO wnu_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Munon ag e qei qomon boru ebet igour eng wuri igo munon uber qei abari qomon boru ebet igour. Eng git wuri qomon boru obounor eng, qanam eng munon qomon boru eb qamb wot qamara ebeiner eng wo borumesis.” ");
INSERT INTO wnu_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ne bo qamar: “Aninou uben qiyo goten abari qomon boru ebet gab eng, uben qiyo goten ig soopur ariramar. Ende at ne uben qiyo goten iget gari igo bebereg igoruboumon. Uben qiyo goten ig nob igama at ten mut qenen oab igo end isunon qamb. ");
INSERT INTO wnu_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ne gor magt mi gab oau uburab isub qomon boru ebeib misir igub gab eng mag ig gomoteneri arirom. Mag ig-ig igama at ten munai ginam qenen boru igamau end isunon qamb. Ende at ne ig gari igama qenen bebereg igoruboumon.” ");
INSERT INTO wnu_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Qamb qamar: “Munon yurau qomourt eng wuri unum diban ue qamb wuribumaimunon. Ue, wurinou enger yurau eng yonou Tain wonou ginamt igo eng qenen menman gab nob qamb imbig igour. ");
INSERT INTO wnu_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Munangit wau munon unum ue boru igour eng wurimusierib dererei. ");
INSERT INTO wnu_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","End an misir maigas igoumon? Munon ger wai sipsip 100-ende igama ne gari qas me gab eng mai ebeiba? Wo ete ebeiba, sipsip 99-eng wuri biua ai siret wuriwaga igamari wo gari qas qooiner end asi qib igoriba. ");
INSERT INTO wnu_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Qibei-i gab wogub mot diab 99-eng nob sori wogub borusi mismisiriba. ");
INSERT INTO wnu_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Eng gas ende gari aninou tain wonou ginamt igo eng munon ger wonou yurau end wogub me iua qamb mismisir igo.” ");
INSERT INTO wnu_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ende qamb qamar: “Aninou ima qiyo bain ger ansiningoar qo merimotar aba gab eng wo qani isub wonou qomon boru eng imbigar. Ego ende oboub qamb eng qi waber aninou ombur gari igo ende abar. Ende aba ne qob igetet aba gab eng qen end ombur bo banamsi igoarar. ");
INSERT INTO wnu_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ego nesiningot aba gab eng munon gari qiyo ombur oramar wot isub ne an ombur qiyo ombur gari ende qob eng qanam qamb gaiar. Qenu wonou qob igo eng toat ende abar. ");
INSERT INTO wnu_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Wuri ende obounor eng qob me igatarib aba gab eng mot Sios munon gugum wuri menmant end mot isar. Eng isunon eng mom ende sig aba gab eng, “qo wo munon in yurau ue, ne gor wo munon qur baiau tari” ende wot qamb mom mogirt wab wagar.” ");
INSERT INTO wnu_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ende qamb qamar: “Ne ye gugum aninob quraum: an mi gugum ag et touriomunon eng Qenu wonou ginamt end gor tourimba. A mi gugum ag et beasimunon eng Qenu wonou ginamt end gor beasimba. ");
INSERT INTO wnu_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ne bo ete aninob qemerini: An munon ombur ag et mi ger qenunget gab eng yonou Tain wonou ginamt igo eng simot qamarari mi andariba. ");
INSERT INTO wnu_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ne munon ombur qiyo ombur gari yet igub ginam garit qiumuni igorunor eng ye end wurinob igoribam.” ");
INSERT INTO wnu_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ende qamara Pita yar Yisas qebi qamar: “Barai, yonou bain yesumungasia qen mai-mai wot isub bo banamsieribam? Mai, qen 7-ende qiyo?” ");
INSERT INTO wnu_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ne Yisas taui qamar: “Ye qen 7-ende gari eb qamb me nonob qamarau, qen 70 ne qen 7-ende. ");
INSERT INTO wnu_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","End ne Qenu wonou bibis wonou ginamt igo eng munon baraitari aib ger gas ende munon barai eng wonou sarau munon mi ar baumir eng oramar musitarib at igo. ");
INSERT INTO wnu_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ende at igama ne munon ger mi ar bauor eng nomon qur qangang (K10,000,000) sig irou, eng mot yaremirei. ");
INSERT INTO wnu_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Yarari munon eng nomon qur ger ende igama tauiminer eng qeemben ue. Ende gab wonou munon baraitari eng munon eng wonou ubeni wonou wagrari ne mi qei-qei qamb eng gugum wurisab nomon qur taui ba wo mi ar bauor eng tauimar qamb qamarei. ");
INSERT INTO wnu_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Qamara munon eng yar wonou munon barait gamaur wat bugab nob qamar, “ye toubet gab eng yoat igama, ye mi gugum taui ugeibam.” ");
INSERT INTO wnu_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ende qamara wonou munon barai eng toubet ne wo git wogub ne wonou mi ar bauor eng gor wot wagerei. ");
INSERT INTO wnu_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ende aba ne munon eng ag der gar eng wonou sarau erogori baab igour eng wo mi ar bauor eng qur qangang K100-ende igoai. Wo ende gab quman qer baab nob qamar, “ne mi ar bauon eng qand taui uge.” ");
INSERT INTO wnu_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ende qamara munon eng goten qanamt end gamaur wat bugab qamar, “yetoubet gab eng qi igama, ye nomon qur eng nenet tauimbam.” ");
INSERT INTO wnu_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ende qamar ego munon eng wo iet wogub munon eng baab bisub uyort big igimine nomon qur mom taui ugea wugine qooiner qamb bigorei. ");
INSERT INTO wnu_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ende aba gab ne wonou sarau erogori baab igour eng qei der oau boruburab wogub isub wurinou munon barai end mi gugum nob qamb ugamirei. ");
INSERT INTO wnu_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ende abari munon barai eng der wonou sarau munon ger igo ger sumungasier eng nob qamar: “Ne sarau munon boru, ne gigit nomon qur qangang aib eng gab di yonob qamara ye ar wugine qonei. ");
INSERT INTO wnu_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Eng gas ende ne bo aninou sarau erogori baab igoumon eng wo quguraget nonob qurar eng ne wo toubau ue, meimet qamb ba sumungasianei?” ");
INSERT INTO wnu_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ende qamb borusi misiringet wonou sarau munon gigit qur qangang aib gab toubeter eng bo ba uyort bigorei, igoi wo nomon qur eng mom taui uge qamb.” ");
INSERT INTO wnu_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yisas qob sindomund qamar: “An gugum aninou munon banam qomon boru abari me wuritoubarunon eng yonou Tain ende gas ansieriba.” ");
INSERT INTO wnu_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yisas qob eng mom ende qamb ugab wogub ai Galili eng wogub Yuda wurinou ai eng yar ya Yordan wes end isorei. ");
INSERT INTO wnu_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Isa munon yurau aib taut isari toar munon qei end wurimusub igoai. ");
INSERT INTO wnu_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ende at igama Parisi munon qei yar gag qebi qomorub qamb yar qamamir: “Mai, ininou qomon eng, munon ger ubeni wonou uyes wegib qamb ar weginer eng uber qiyo?” ");
INSERT INTO wnu_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ne Yisas taui qamar: “Qob ete igo eng mai wanunger imbig igoumon qiyo? Qoan ir qanam big Qenu mi gugum qamagat barsi unor barsi ende ebeterei. ");
INSERT INTO wnu_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ende at qamar: “End ne munon yamangar bainer eng ur unor mom wogub wonou ubeni eng nob git goan gari qas burubour. ");
INSERT INTO wnu_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","End ne bo munon yamangar nob ombur ue, git goan gari mom burour. End Qenu mi nausi igo eng munangit maigas me birueinerei.” ");
INSERT INTO wnu_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ende qamara Parisi bo qebi qamamir: “End ne Moses qomon gumater eng, munon ger ubeni mom wegib qamb eng yamangar omboagirmau qob eng qamb nausi ne namanimunt gumat utab mom imurima qoeiner, qob ende igo eng mai?” ");
INSERT INTO wnu_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ne Yisas taui qamar: “Moses wo an yamangar omboagir wagar qamar eng, ar me qamarau, ue. Aninou gag bur iruges big wogub yamangar omboagir igamari gab qamarei. Qenu ai tat nob barsier eng, munon yamangar ba qi omboagirmau qomon eng wo me wotrab igo. ");
INSERT INTO wnu_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Apand aninob quraum, munon ger ubeni uber igama umami wonou uyes omboagir wogub bo yamangar ger bainer eng, munon eng wo qomon biisitet igo.” ");
INSERT INTO wnu_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ende qamara wonou imbigau yurau eng der qamamir: “Munon yamangar nob qibaub me qi omboagir eb qamb eng wuri qi baunor, ar eng me qibaunor eng uber.” ");
INSERT INTO wnu_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ne Yisas taui qamar: “Qob eng quraumon eng sig apand. Ego qob eng munon yamangar gugum me wuritrama. Munon gari-gari qomon eng obounor qamb Qenu werei opurama wuritrama toat igour. ");
INSERT INTO wnu_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","An igar, munon wurinou gari-gari qomon wes-wes igo end toat yamangar me baub igour. Munon qei wurinou unor ende wuribauor end yamangar nob igamau misir eng ue. A munon qei wuriborusiari yamangar baub wau me baunorei. Ne munon qei Qenu wonou bibis end igo wonou sarau ebet igorub qamb yamangar baiau end gitab igour. Munon ger wonou qob e igib qamb eng iginer,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ende qamb igama munon qei wau qamaaman oramar yarari Yisas uben erer wuribig ne Qenut qebi qem qamb. Ende yarari wonou imbigau yurau eng der wau urimagrari oramar qamamirei. ");
INSERT INTO wnu_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ende abari Yisas der qamar: “Wagari wau qamaaman oramar yarunor, an me oramar qamarar. Qenu wonou bibis ginamt igo eng munon barari wau qamaaman eng gas ende eng wurinou.” ");
INSERT INTO wnu_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ende qamb wogub uben erer wuribig wogub ginam eng wogub qorei. ");
INSERT INTO wnu_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Qoa munon ger Yisast yar qebi qamar: “Imbigau munon, ye meimi uber ger ebet taui qamb igomot qenen bebereg igoribam?” ");
INSERT INTO wnu_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ende qamara Yisas taui qamar: “Meimet qamb mi uberet ye qebi quran? Mi gari qas uber eng ete: ne qomon gugum toat eng taui qamb bebereg igoriban.” ");
INSERT INTO wnu_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ende qamara munon eng taui qamar: “Meimi qomon eng gagar?” Ne Yisas qamar: “Qomon e gagar: igeig me yom, yamangar ba bo me wog, mi urim me bai. Ne qob qetopur me qem, ");
INSERT INTO wnu_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","a tain nanib qob qamarari igatar mi eb, ne munon qei nonou git goan qenunget igoan gas ende wuriqenungar.” ");
INSERT INTO wnu_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ende qamara munon eng taui qamar: “Qomon eng gagar quran eng gugum ye toat igoum, ego bo meimi ger ebeibam?” ");
INSERT INTO wnu_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ende qamara Yisas taui qamar: “Ne mom uberburib qamb eng ne mind irou eng munon qei wurisa nomon qur taui natari ba munon mind ue eng werisu. Ende ebeinen eng Qenu ginamt ne mind irou nob igoriban. End see ye yetoa ombur qib igorun.” ");
INSERT INTO wnu_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Munon moi eng mind irou end Yisas qob eng qamara igub wonou mind duet wogub qorei. ");
INSERT INTO wnu_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ende qoa ne Yisas wonou imbigau yurau eng wurinob qamar: “apand aninob quraum, munon mind nob eng Qenu wonou bibis end irunor eng misue. ");
INSERT INTO wnu_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ne mi ger aninob qemeribam eng, wai kamel aib-aib gaumon eng wuri mi goan mai igour nil iru sig qomourt eng wuri ar ururau isubour. A munon mind nob eng Qenu bibis end irib eng wonomi pondogub wegiba.” ");
INSERT INTO wnu_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ende qamara wonou imbigau yurau eng igub borusi qiet misuet qamamir: “Ende gab your ger igomot igoriba a?” ");
INSERT INTO wnu_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ende qamarari Yisas maganasi ibag bis arir wurinob qamar: “Mi eng munangit ende obounor eng misue, ego Qenu wo mi eng ar ende ebeiba.” ");
INSERT INTO wnu_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ende qamara Pita der taui qamar: “End ne in mi gugum wogub ne nonob qib igoun eng in mai obouboun?” ");
INSERT INTO wnu_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ne Yisas der gugum wurinob qamar: “End ne ete qemerine igar: mi gugum bo bubun diorunor qen eng gab Munangit wau wo unum qiribiten burab Munon aib wonou nam qab end bugemba. Qen end an munon yurau 12 eng ye yetoat qib igoumon eng an der Isrel munon yurau qanam 12 eng wuriqereimboumon. ");
INSERT INTO wnu_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ende abari munon yet igub wurinou munai ginam qiyo a wurinou umomori, umamandimagar qiyo, a ur unor qiyo, a wagrari qiyo, a ai mom wogub ye yenob qirunor eng bo mi eng gagar qoan wuri igoar eng wotanami bo sig irou baubour. Ende abari yonou wurisierine qenen igomot igorubour. ");
INSERT INTO wnu_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","End ne munon qei see in aib gigit igoun qamb qen big qib igour eng wuri bo Qenu ginamt end unum uma isiba. Ne see munon unum diban ue, ne mind goten gor ue eng qen geret Qenu unum wuri ba dibesia wonou ginamt end munon aib unum diban igoriba.” ");
INSERT INTO wnu_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Yisas qob eng ende qamb wogub mi geret big qamar: “Qenu wonou ginamt bibis big igo eng ete gas: munon ger itum der wonou wain man eng sarau beseiser qamb munon qei wuriqereimb qamb isorei. ");
INSERT INTO wnu_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Isub wuriqereima uber qamarari qen end wonou uyes nomon qur irunob eng gugum wurisab wogub wuriimurima sarau botoub qamb isumirei. ");
INSERT INTO wnu_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Isari wogub man ur eng wo igoi wogub worom erer diara sarau baab igour qamb ibegeib qamb isorei. Isub ibagar eng munon qei ar aib qamb qiumuni igamari wurinob ai ibeibi naget igurei. ");
INSERT INTO wnu_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Igamari wurinob qamar, “An gor isub man sarau beari nomon qur qeemben andaribam.” ");
INSERT INTO wnu_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ende qamara isumirei. Isari wogub wo igoi wogub worom ginam tog yara bo is ibagar eng ende sig. Ne bo worom qumat dara is ibagar eng gor ende sig. ");
INSERT INTO wnu_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ne bo mom sarau wagau qen eng gab is ibagar eng gor, munon qei bo di ar end naget igamari ibag wuriqebi qamar: “An qen e sarau bais me beau, ar igamari worom nerima ne?” ");
INSERT INTO wnu_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ne wuri qamamir, “Munon ger sarau me inimbiga gab in sarau me beau.” Ende qamarari wo bo uber qamb wogub wuriimurima wain man eng isumirei. ");
INSERT INTO wnu_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Worom mom nerima ne man ur wonou munon barai eng nob qamar: “Sarau munon eng wurit ara diarari nomon qur taui werisu. Qanam big munon qanam saraut isar eng gigit utab ne bo wobont isar eng ut. Ende at bir-birii mom sasam munon qamart isar eng ut.” ");
INSERT INTO wnu_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ende qamara ne gigit munon sarau qen ubura wuriimurima isub sarau baist baamir eng gugum K1.00, K1.00 wuriserei. ");
INSERT INTO wnu_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Wurisa gab munon gigit isumir eng, in aib bauboun qamb misir igumir eng ue, wuri gor qeemben K1.00 baumirei. ");
INSERT INTO wnu_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ende baub gab oau biriberi nub wogub man ur nob agunub qamamir. ");
INSERT INTO wnu_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Munon qei ar igamari sarau qen ubura nonou ibag wuriimurima darab sarau baun qamb burindir wogub diaur eng nomon qur eng wurisan eng uber. Ego in borumesis, worom init nerimar eng nomon qur e indaran eng uber ue.” ");
INSERT INTO wnu_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ne man ur der munon ger nob qamar: “Ne igu, ye me neborusiaum, itumut qen e gari sarau qanambig baub qamb nomon qur qangang ende baub qamb in ombur qob qamb nausiunei. ");
INSERT INTO wnu_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","End ne sarau taui nomon qur notoum eng ba ginamt iroa ye bo munon qanamt is sarau baur eng ne nomon qur notoum gas ende qeemben werisibam. ");
INSERT INTO wnu_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Eng yonomi, end nomon qur ende at andoroum eng qob ue. Ne meimet qamb mi eng qenunget ye merimisab igoan?” ");
INSERT INTO wnu_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yisas qob eng ende qamb ne sasam qamar: “Munon unum diban ue igorunor eng wuri bo munon aib diban igorubour. A munon aib unum diban igo qen big qiriner eng bo umo isiba.” ");
INSERT INTO wnu_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Qen end Yisas Yerusalem qite irib qamb ne wonou imbigau yurau 12 eng qas oromar qataben irab wurinob qi qamar: ");
INSERT INTO wnu_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“An igar, in Yerusalem qite irune Pris munon baraitari eng ne qomon imbigau munon yurau eng der Munangit wau baab qob qamb nausi waramb qamb oboubour. ");
INSERT INTO wnu_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ende at ne ba imurimari munon igeig wurit isa wuri ba ber qob wot qamb pisirami waramb ne ba nam tenori big waramb erer urimbour. Ende abari uma ne ba tumunimunorei igama qen ombur gari isa bo igomot der bugemba.” ");
INSERT INTO wnu_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Qen end Sebedi wonou wau ombur, wurinou unor eng iroari nob ir igoar end Yisas qob eng at qamara igub yar menmant end inumor mi qei nob qamarei. ");
INSERT INTO wnu_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yamangar eng Yisas qani ende yara ne Yisas qebi qamar: “Meimi?” ende qamara yamangar eng nob qamar: “Qen geret ne munon baraitari aib burab gab eng yonou wau ombur eng wuriba qubei ne wuriwaga nonou qipisen ig-ig end igorunor.” ");
INSERT INTO wnu_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ende qamara Yisas taui wurinob qamar: “Ye mi eng quraum eng an qoyam ue end eng at quraumon. An mai ye git goan sarog big yonomi duimine yanambour eng an gor ende obounon eng qeemben qiyo?” Ne wuri taui qamamir: “In qeemben ar, ende obouboun.” ");
INSERT INTO wnu_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ende qamarari Yisas taui qamar: “Git eng apand ende obouboumon. Ego an ombur ye qipisen ig-ig et igorub quraumon eng, ye an igorunon munai up eng me maribiginei. Munai up igorunon eng Tain wonou qo munon gugum maribagatarerei igo.” ");
INSERT INTO wnu_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Munon ombur eng der Yisas nob ende qamarari wonou imbigau munon 10 eng der ombur wurit borusi misiringetamirei. ");
INSERT INTO wnu_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ende abari Yisas gugum wuriba qiumuni wurinob qamar: “Ai gugum munon baraitari wes-wes igo qomon biga wonou yurau eng toat igour. Ne gor ginam gari-gari wurinou munon barai qob qamara igetet igour. ");
INSERT INTO wnu_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","An eng gas ende me abar. An end ger baraitari igo qei oroar igorib eng wo bo wau unebi igoriba. ");
INSERT INTO wnu_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","A ger ye gigit igoum qamb ebeiner eng wo an qei ar sarau batar igoriba. ");
INSERT INTO wnu_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Munangit wau wo gor ende gas ende, wo munon ag e yemusiarar qamb me darau, ue. Wo munon ag e wurimusierib qamb dererei. Wurit igub wonomi dui umb wurimaragansierine igomot igoarar qamb.” ");
INSERT INTO wnu_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ende qamb wogub munai ginam Yeriko wogub bo tumbigi iroari munon yurau aib orotoar iramirei. ");
INSERT INTO wnu_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Iroari munon ombur mag tuum tapet end igour eng Yisas dia qamarari igub atag qamb amir: “Imbigau munon, ne Debit wau, in initoubar musi.” ");
INSERT INTO wnu_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ende qamb arari munon yurau aib eng der wuritaisi oramar qamamir ego munon ombur eng bo sig-sig mom qamb amir: “Debit wau inmusi.” ");
INSERT INTO wnu_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ne Yisas naget wuri qebi qamar: “An ye mai insi qamb ab igoumon?” ");
INSERT INTO wnu_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ne wuri taui qamamir: “Barai, ne mag inmusia asiomun qamb igo ab igoun.” ");
INSERT INTO wnu_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ende qamarari Yisas ibag borusi wuritoubar ne magt wuribea musub asi ne Yisas toat iramirei. ");
INSERT INTO wnu_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yisas iramir eng iri munai ginam ger unum Betpage end weib iramirei. Munai ginam eng nam Olib man aib ai qaurent igo eng qani end igoai. ");
INSERT INTO wnu_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","End irab imbigau munon ombur eng wuriimurimb qamb wurinob qamar: “An irab munai ginam ger qani end gunon eng wai dongi ger wannob tesimunorei igama guboumon. Gab neri baisab diarar. ");
INSERT INTO wnu_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Neri igamari munon ger animbag qob ger aninob qamara gab eng ete nob qamarar, “Ininou Munon Barai sarau utib qamara yar nob irub at igoun” ende qamarari waga qand wurineri ba diarar.” ");
INSERT INTO wnu_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Mi eng ebetemir eng qob ger qoan munon miteri ende qamb gumater eng irimaniamorei. ");
INSERT INTO wnu_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Eng ete qamb gumaterei: Munon munai ginam aib Yerusalem eng ete wurinob qamarar: see aninou munon baraitari eng anit dia. Wo munon mein wai dongi erer bugab dia. Wo wai dongi unor wan yeim nob erer end bugab dia. ");
INSERT INTO wnu_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ende qamb ombur wuriimurima irab Yisas wurinob qamar gas ende qeemben ende gamirei. ");
INSERT INTO wnu_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Gab dongi eng neri wan nob oramar irab ombur wurinou mi goan norumi dongi erer oromari Yisas erer ir bugamorei. ");
INSERT INTO wnu_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ende abari munon yurau irou wurinou mi goan norumi tapet oromari ne munon qei nam mun soopumi oramet ende ebetemirei. ");
INSERT INTO wnu_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Abari Yisas dongi erer bugamor eng isa ne munon yurau aib qei gigi isumir ne qei qanam ende at isub igo ne mismisir ete qamb ab-ab isub igurei. Debit wonou wau end mismisirun. Ininou munon aib Qenu maragansia yara. Qenu unum bereriomon. ");
INSERT INTO wnu_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ende qamb ab-ab ginam aib weib isari munon ginam aib igour eng gugum der gab qiet ne qamamir: “Wa, eng meimi munon ende e?” Ende qamb wuri qebi qamarari ne munon yurau aib Yisas nob iramir eng wurinob qamamir: ");
INSERT INTO wnu_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","“Munon eng munon miteri qamb igo eng Yisas. Wo Galili wonou ginam qenen eng Nasaret,” ende qamamirei. ");
INSERT INTO wnu_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yisas ginam aib end isub ne inorou munai aib Tempel eng mor isub gar eng munon mi qei bisub mor end taui ba igurei. Ende gab ne nomon qur nam qabt big biiges taui ba igour eng ten ba biigima isa ne bo morogan qamb nam qabt big taui ba igour eng ten biigimatar ne wurinob qamar: ");
INSERT INTO wnu_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","“Qoan Qenu qob qamara gumatemir eng ete; “yonou munai eng qebi qamarau munai gari.” Ego an bo munai ar gas ba sumungasi igoumon.” ");
INSERT INTO wnu_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ende at igama munon qei mag tuum ne qei goten boru eng wot yarari wurimusub igoai. ");
INSERT INTO wnu_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ende ebet igama ne Parisi munon baraitari ne qomon qereimau munon qei Yisas mi uber eng aba gab wot borusi misiringetamirei. Ende abari wau qamaaman der mor end mismisir toau big amir: “Debit wonou wau end mismisirun.” ");
INSERT INTO wnu_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ende qamb ab toau big abari munon qei der misiringet Yisas nob qamamir: “Ne wau eng qamb ab obour eng ne igan qiyo?” Ne Yisas taui wurinob qamar: “Io, ye ende igoum ego qob qoan igoar eng an wanunger imbig igoumon ete: Ne wau qamaaman ne wau inaut igour eng oau wurimenima nonou unum bereri toau bigunor.” ");
INSERT INTO wnu_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Yisas eng ende at wogub ginam aib eng wogub bo Betani end is inerei. ");
INSERT INTO wnu_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","End inerei igo urigerma bo yonam Yerusalem isib qamb irab qataben borusi minamorei. ");
INSERT INTO wnu_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ende at wogub aragas ger tap goant et gab qur ger bigorei igo miminet igo qamb isub gar eng qur ger ue, im qas. Ende gab borusi misiringet wogub aragas eng qamat qamar: “Ne bo qur me biginenei.” Ende qamara qen end qas gegeret uburerei. ");
INSERT INTO wnu_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ende aba wonou imbigau yurau eng ende gab qiet ne Yisas qebi qamamir: “Maigas at aragas qand gegeret ubura a?” ");
INSERT INTO wnu_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ne Yisas taui qamar: “An oau apand nob ende qi eng ende me ye qebi quraumon qi. Oau apand nob igo eng ye nam aragas eng qamat qemerine aba gas ende obouboumon. Nam gari ue, ai qaur ger nob ete qomoruboumon, ‘Nonou nerer bo tomon ya end is nag,’ ende qomorunon eng ende ebeiba. ");
INSERT INTO wnu_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ne gor oau apand igo eng mi qei baub qamb qebi qomorunon eng qeemben ende bauboumon.” ");
INSERT INTO wnu_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ende qamb wogub irab bo inorou munai Tempel mor end isub qob wuriimbig igoai. Igama Pris munon barai gigit eng ne Yuda munon baraitari eng wot yar qebi qamamir: “Ne mai, sarau eng ebeib qamb unum iranei igo ebet igoan? Ne gor your ne sarau eng eb qamb nemaribigorei igama ebet igoan?” ");
INSERT INTO wnu_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ende qebi qamarari Yisas taui wurinob qamar: “Ye mi geret qebi aninob qemerine an bo qeemben taui ende yonob qamarari ne ye sarau eng ebet igoum eng aninob qemeribam. ");
INSERT INTO wnu_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yon munon yat wurimaragansi igoar eng, mai, qomon eng Qenu wonou ginamt qiyo, a munon ag e wurinou qomon?” Ende qamara wurinou qob-qob qamamir: “In mai qomoruboun? Ete qomorun eng, ‘Qenu wonou’, qomorun eng wo ete qemeriba: ‘ende gab eng an meimet qamb Yont me oabigoumon?’ ende qemeriba. ");
INSERT INTO wnu_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","A, ete gor qomorun eng, ‘Munangit wurinou,’ qomorun eng, in gor munon qei wurit yarimboun. Qanam eng munon gugum Yont, ‘munon miteri qamb igo eng’ wot qamb igour end.” ");
INSERT INTO wnu_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ende at qamb wogub Yisas qob qamar eng taui qamamir: “In qoyam ue.” Ende qamarari Yisas taui qamar: “Ende gab eng ye gor qoyam ue. Your sarau eng yiimbiga ebet igoum qi eng me aninob qemerinei.” ");
INSERT INTO wnu_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Qamb qamar: “See an mai misir igoumon? Munon ger wau ombur igoai. End ne ur wau qamar end wot isub nob qamar, ‘see ne isub wain man end sarau be.’ ");
INSERT INTO wnu_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ende qamara wau qamar der, ‘ye ietroum’. Ende qamb wogub bo misir igub wogub isub sarau barei. ");
INSERT INTO wnu_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ne ur bo isub wau yab nob ende gari qamara wau yab der, ‘Io, ye isibam,’ ende qamb wogub wo is sarau me beau, ar igoai. ");
INSERT INTO wnu_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Wau ombur eng, your eng der ur qob toat sarau barei?” Ende qamara wuri taui qamamir: “Wau qamar eng.” Ne wo bo taui qamar: “End ne ye ete aninob qemerine igar. Munon qur ba igour eng nob yamangar qarig ir qib igour eng nob wuri gigit Qenu wonou bibis end igour. ");
INSERT INTO wnu_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Yon munon yat wurimaragansi igoar eng wo an werei uber eng an imbig isar qamb ebeter eng an wot me oabigau. Ego munon qur ba igour eng nob yamangar qarig ir qib igou eng wot oabigumirei. An wo gaman ego wo me imbig ne wot me oabigau.” ");
INSERT INTO wnu_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ende qamb qamar: “Bo mi geret big qemeribam eng igar: munon ger wonou ai aib igoai. End wain man suab wogub ubub wogub youn big opuramorei. Ende at wogub wain miminara ba big napine ya isiner qamb wain man end tumun aib goaneterei. Ne munon man eng qoat inab igorunor qamb mon aib ger mindaterei. Ende at wogub munon qei wurit waga sarau baab nomon qur taui baub igoarar qamb wuriimbigorei. ");
INSERT INTO wnu_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Wain imor eng miminara gab ne wonou sarau munon wuriimurima isub wain git baiar qamb wuriimuriamorei. ");
INSERT INTO wnu_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Wuriimurima isari ne munon wain man qoat igour eng der ibag ne ger baab ar waramb wagomirei. Ne ger waramari umorei, ne ger nomont waramb ende ebetemirei. ");
INSERT INTO wnu_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ende abari sarau munon eng me iroari ibag ne bo wuriimuriamor eng sig irou. Ende isari ibag ne munon eng bo der ende gari wurisiamirei. ");
INSERT INTO wnu_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ende abari me iroari ibag ne misir igor, ‘Qo munon ar eng wuriimurimine igaramb igour qiyo. Eng gab yonou wau ten e bo imuri gine,’ ende qamb ne wonou wau ten eng bo imurima isorei. ");
INSERT INTO wnu_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Wonou wau ten eng imurima isa gab ne qamamir, ‘Wonou wau ten eng igo ur uma ur mind goten eng wo baiba, end waramune uma mind goten e ininou siorun.’ ");
INSERT INTO wnu_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ende qamb baab ba ag ariramari dara der waramari umorei.” ");
INSERT INTO wnu_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ende qamb wuri qebi qamar: “Munon wain man qoat igour eng ende abari ne wain man ur eng yar ibag munon eng mai wurisieriba?” ");
INSERT INTO wnu_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ne wuri qamamir: “Ende yar ibag borusi misiringet munon boru-boru eng igaramb orotoar arir wogub wain man eng bo munon yurau bubun wurit waga qoatet igorubour. Igoi wain arira gab git ba wonou ur qeemben utubour.” ");
INSERT INTO wnu_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ende qamarari Yisas wurinob qamar: “An qob qoan igoar eng wanunger imbig gab igoumon qiyo?’ Ete igoai, Munon mon mindau eng nomon ger boru qamb at ariramir eng see bo nomon eng sig uber gab ba qoren unotari yomour. Mi eng Munon Aib wonou aba in gaun eng sig uber ar.” ");
INSERT INTO wnu_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ende qamb bo imusi qamar: “End aninob quraum, an Qenu wonou bibis end igoumon eng an qomon boru-boru ebet igorunon eng bo an agi wogub munon yurau ar qei Qenu wonou bibis end igorub qamb misir igub igour eng wurimorima end igorubour. ");
INSERT INTO wnu_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Munon ger nomon eng erer end naget nugusurupesi yarisieriner eng qer omboroumi uburiba. Ne nomon eng der munon ger wareminer eng munon eng sair tub iriba.” ");
INSERT INTO wnu_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Yisas mit big qob eng ende at wurinob qamb igama Pris munon gigit eng ne Parisi qob eng wurit big qamb igoar eng imbigumirei. ");
INSERT INTO wnu_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Imbig ne baab waramb qamb misir igumir ego munon yurau qei Yisast, “munon qob gigit qamarau” qamb wot oabig igour end wurit yari wugumirei. ");
INSERT INTO wnu_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yisas qob eng ende wurinob qamb wogub bo mi geret maribig qamar: ");
INSERT INTO wnu_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Qenu wonou bibis big igo eng munon baraitari ger wonou wau end yamangar bateib qamb mi arsi nob nib at igo gas ende. ");
INSERT INTO wnu_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Mi arsi wogub wonou sarau munon imurima iua munon wurinob qamara mi at nibar end diorunor qamb qob gim bigor eng wuri me diarau. ");
INSERT INTO wnu_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ende gab sarau munon bo qei wuriimuri wurinob qamar: ‘An isub ye munon wurimaribigoum eng ete wurinob qamarar: ye mi gugum mom arsi ugaum. Yonou bur qarig qamagat aib ne wai aib-aib qei gor igaramb ugab mom arsi igoum. Isub wurinob qamara diab nunor.’ ");
INSERT INTO wnu_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ende qamb wuriimurima isub wurinob qamamir ego munon eng tari qer igub wogub der iua uburemirei. Ger der wonou man sarau end isuor, a ger der wonou qur sarau end isorei. ");
INSERT INTO wnu_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","A qei der munon barai wonou sarau munon gim biga ba isumir igaramb wurimumusiari umb uburemirei. ");
INSERT INTO wnu_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ende abari munon barai eng oau biriberi nub wogub yogorau munon wuriimurima isub munon ginam eng sarau munon igaramir eng ginam di igaramb ugab mon mutet wab ugamirei. ");
INSERT INTO wnu_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ne munon aib eng bo der wonou sarau munon qei wurinob qamar: ‘Mani mom arsiaum ereteri igo ego munon diab niar qamb wurit gim bigoum eng ue eng. ");
INSERT INTO wnu_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","End see an bo tap tog end ne tap tog sorai end isub munon irou ibag eng wurinob qamarari yonou wau yamangar baiba mi arsiaum e diab nunor.’ ");
INSERT INTO wnu_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ende qamb wuriimurima isub munon boru-boru uber-uber ibagamir eng gugum wurisogar ba diab ariramari munai eng yab di qorei. ");
INSERT INTO wnu_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ende igamari munon barai eng mor diab ibagar eng munon gari qas, munon yamangar baiba mi aib at nub mi goan qumani igour eng me qumanimau. Ende gab qebi qamar: ");
INSERT INTO wnu_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","‘Ne meimet qamb mi goan eng qumani mor e me diarau?’ ende qamara munon eng qob ger me qamarau. ");
INSERT INTO wnu_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ende gab munon barai sarau munon wurinob qamar: ‘Baab uben touri goten touri wogub ba ag ai itum end ariramari igoriner. Igo eab nan suab igoriner.’ “ ");
INSERT INTO wnu_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yisas qob ende qamb sasam mom qamar: “Qenu munon gugum wonou yurau igoarar qamb wuriqubei igo. Ego munon gari-gari wonou yurau apand igorub qamb abari eng gari wuriqubei igo.” ");
INSERT INTO wnu_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ende qamara Parisi wurinou qiumuni qamamir: “In qob maigas qamb nausi ne Yisas baab tourimboun?” ");
INSERT INTO wnu_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ende qamb Parisi wurinou imbigau yurau eng ne Herot wonou munon yurau eng ende wuriqereimari Yisast isumirei. Isub Yisas nob qamamir: “Imbigau munon, ne qob inimbig quran eng qob apand ar. Ne Qenu wonou qob ne qomon apand eng qas munon yamangar wuriimbig igoan. Ne qob qamb igoan eng munon gari gumat me qamb igoan, munon gugum wurigumar qamb igoan. ");
INSERT INTO wnu_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","End ne ne mai misir igan? In Rom munon barai oroar igo end nomon qur bigun eng mai ininou qomon eng biisitouboun qiyo ue?” ");
INSERT INTO wnu_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ende qamarari Yisas wurinou misir soagen end eng at qebimari diban ibag wogub wurinob qamar: “An munon qob qetopur qamarau tari, meimet qamb ye yewarigesi qamb igoumon? ");
INSERT INTO wnu_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Nomon qur bigub quraumon eng ete abari gine?” Ende qamara nomon qur eng ba utari gab ");
INSERT INTO wnu_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","wuri qebi qamar: “Your wonou qugur unum nob nomon qur et igama gab igoumon?” ");
INSERT INTO wnu_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ne wuri taui qamamir: “Rom gabman munon barai oroar igo eng.” Ne Yisas qamar: “End ne munon barai eng wonomi eng gab wonou sarau end bagatatar. A Qenu wonomi eng gab Qenu wonou begetet, ende abar.” ");
INSERT INTO wnu_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ende qamara igub borumisir igub wogub Yisas end wogub qoamirei. ");
INSERT INTO wnu_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Qoari wogub qen end gari munon yurau Sadyusi qamb igour eng wuri bo Yisast yaremirei. Munon yurau eng wuri munon umb bo igomot me der bugomunorei qamb igour eng. ");
INSERT INTO wnu_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Yarab qebi qamamir: “Imbigau munon, Moses qob ete qamb gumaterei igama gab igoun: ‘Munon ger wonou ubeni wau ue igama umami uma ne bo umour der ubeni qindou eng wo bo baia ne wau giner eng, wau eng umami qamart eng wonou.’ ");
INSERT INTO wnu_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","End ne munon ger wonou wau 7-ende e igour. Wau qamar wonou ubeni eng wau ue igama umorei. Uma ubeni qindou eng wau yab baurei. ");
INSERT INTO wnu_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Eng gor wau ue igama umorei, ne wau qag eng gor ende sig. Ende at-at isii yarab wau 7 eng gugum yamangar eng gari ba wogub umb uburemirei. ");
INSERT INTO wnu_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Mom sasam wurinou yamangar qindou eng umorei. ");
INSERT INTO wnu_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","End ne munon yamangar bo igomot der bugomunor qen end yamangar eng your wonou bo baiba? Gugum bo baubour qiyo?” ");
INSERT INTO wnu_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yisas taui qamar: “Qenu wonou qob igo eng ne wonou qeretutnob eng an musub me imbig ne qob soagen ur eng at qamb igoumon eng. ");
INSERT INTO wnu_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Munon igomot der bugomunor eng gugum Qenu wonou munon qau enger nob garisi wonou ginamt end igorubour. Igo qi baiau qomon eng me igorinerei. ");
INSERT INTO wnu_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Munon igomot der bugomunor end Qenu aninob qamar eng an me imbig igoumon? Ete qamarei: ");
INSERT INTO wnu_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ye Abraham Aisak ne Yekop wurinou Qenu.’ Qob eng qanam eng, bebereg qenen igamau eng wonou Qenu.” ");
INSERT INTO wnu_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ende qamara munon yurau aib eng wonou qob eng igub qoaguruiamirei. ");
INSERT INTO wnu_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Yisas qob qeretutnob ende qamara Sadyusi igub qob ger me qamarau. Ende abari Parisi wuri igub gugum yar Yisast qiumuniamirei. ");
INSERT INTO wnu_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Qiumuni ne wurinou imbigau munon ger der Yisas bo warigesierib qamb qebi qamar: ");
INSERT INTO wnu_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Imbigau munon, qomon irou igo ego, meimi qomon eng qomon qei wuritanamima?” ");
INSERT INTO wnu_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yisas taui qamar: “Ne Munon aib Qenu end yonou oau uri qamb ne nonou misir eng ne igom igoan eng gugum wonou wot dui wog. ");
INSERT INTO wnu_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Qomon eng sig aib ne uber. ");
INSERT INTO wnu_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ne qomon eng igama ii igo eng ete: Nonou git goan qenunget igoan gas end munon qei wuriqenungar. ");
INSERT INTO wnu_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Moses qomon irou gumater eng ne munon miteri qamb gumatemir eng qomon qob qambri igour eng, qanam eng qomon ombur gari see nonob quraum eng,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Parisi yar qiumuniamir eng ende igamari Yisas der wuri qebi qamar: ");
INSERT INTO wnu_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“An munon wuriubersiau tari end an mai misir igoumon? Wo your tumbigi end dariamorei?” Ne wuri taui qamamir: “Debit tumbigi end dariamorei.” ");
INSERT INTO wnu_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ende qamarari wo qamar: “Ende gab eng Igomurur qau Debit mai gas oau menima ‘yonou munon aib’ qamarei? ");
INSERT INTO wnu_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Ete qamarei, Yonou munon aib eng yonou munon barai nob ete qamarei: yonou uberegent wes et bugom. Qen geret nonou munon qarau eng wurimaribigine yar nonou goten qanamt end igorubour. ");
INSERT INTO wnu_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","End Debit wonou uyes ‘yonou munon barai’ qamar eng, bo meimet qamb Debit tumbigi?” ");
INSERT INTO wnu_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ende qamara munon ger wo qob eng taui qemeriner eng misue gab wugumirei. Qen end qanambig wot yari wagomir end bo sabar me qebimau. ");
INSERT INTO wnu_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Yisas munon yurau aib eng ne wonou imbigau yurau eng nob garisi wurinob qamar: ");
INSERT INTO wnu_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Munon qomon qerei imbig igour eng nob Parisi nob wuri Moses qomon eng qas animbig igour. ");
INSERT INTO wnu_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Eng uber, wuri qob qamarari igatar toat mi abar qamb qamarari eng gugum abar. Ego qomon boru qei ebet igour eng an ibag me tauar, qob irou qamb ne wurinou me toat igour. ");
INSERT INTO wnu_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Wuri mi qugurau aib ger ba munon wurisari togor quguraget qiroari wuri bo mag gari ibag wagau gas ende at igour. ");
INSERT INTO wnu_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Wuri mi ebet igour eng munon qen inimbagaiar qamb qas at igour. Ende at ne Qenu qob tau gumatriamir eng qoimber yab erobon big igour eng ten ba tarit, a ubent touri wogub mi goan qenenginob eng degen-degen qumani qib igour. ");
INSERT INTO wnu_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Mi aib at nub qamb qiyo a inorou munai mor end is bugomb qamb eng nam qab deberit end qas bugab igour. ");
INSERT INTO wnu_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ne munon mag diban end wuri dibes qamarari igub qamb qiyo a munon qei ibag ‘imbigau munon’, ende wurit qamarari igub qamb mi big-big qib igour. ");
INSERT INTO wnu_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","An gor, ger der geret, ‘imbigau munon’ end me qit qamarar. An erogori qibanamsi igo ne imbigau munon gari qas igo qob qamara toat igoarar. ");
INSERT INTO wnu_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ne gor aninou taineb ag e wurit, ‘tain aib’ ende gor me wurit qamarar. Aninou Tain aib gari wonou ginamt end igo. ");
INSERT INTO wnu_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ne aninou geret, ‘munon barai’ end gor me wot qamarar. Aninou munon barai gari qas igo eng munon in ubersiau tari wo gari. ");
INSERT INTO wnu_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Aninou munon ger baraitari igo gab eng wo ar sarau batar igoriner. ");
INSERT INTO wnu_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Munon ger wonomi qen big qib igoriner eng wo bo umo isiba. A munon ger wonomi bumai qiriner eng wo bo munon baraitari diban igoriba.” ");
INSERT INTO wnu_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Qamb qamar: “An qomon imbigau munon ne Parisi nob, an qoyamet igoarar. An qob irou munon oramar qamb wogub Qenu wonou bibist igamau werei eng munon animbag igamari magqurt mondir obotarau nami ende at igoumon. Ubet wogub aninou gor mor me isub igoumon. Munon mor isun qamb ebet igour, ego aninou werei opur igoumon. ");
INSERT INTO wnu_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","An qomon imbigau munon ne Parisi, an qoyamet igoarar. An yamangar qindou wurinou munai wurit baub qamb wurimurimausi baub wogub Qenu qebi quraun qamb qob degen aib qamb aninou qomon boru eng nonogursiorub at igoumon. ");
INSERT INTO wnu_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","An qomon imbigau munon ne Parisi, an qoyamet igoarar. An qob ombur big qamb ne tomon ya erer qib ne gotent ai gugum qib ne munon wuriqerei ne aninou yurau igorunor qamb at igoumon. Wuri qoan munon ger wonou yurau igour, ego an bo uyes ubumot aninou yurau end igoar qamb at igoumon eng wo ginam boru end isiba, aninou gas ende. An ende abari wuri qomon boru ebet igour eng an antanami ebet igour. ");
INSERT INTO wnu_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","An qoyametarar, an munon mag tuumtaman eng meimet qamb munon tap wuriimbigub at igoumon? An ete qamb igoumon: Munon ger, qob qamb inorou munai aib end unumir, ‘sig apand’ qemeriner eng ue. Ego inorou munait mi qenenginobt mindat igour eng unumir sig apand qamb gab eng mi ebeib qemeriner eng ebet qas weginer. ");
INSERT INTO wnu_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","An munon mag tuum ne qangang ur. An eng qamb igoumon eng, meimi eng sig qau, inorou munai eng qiyo, a inorou munait mi qenenginob igo eng aba qau? ");
INSERT INTO wnu_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ne ete gor wurinob qamb igoumon, Munon ger Qenut mian yab big igour nam qab eng unumir ‘apand’ qemeriner eng sig qau ue. Ego mi git yab nam qab erer bigunor eng unumot ‘apand’ qemeriner eng sig qau. ");
INSERT INTO wnu_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","An munon mag tuum, mani yab nam qab erer big igour eng qau qiyo, a nam qab eng mani aba qau burab igo? ");
INSERT INTO wnu_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","End ne munon ger nam qab eng unumot apand qemeriner eng, mani yab erer bigunor eng ten wonou qob nonogursierib qamb toat qamara bininger igo. ");
INSERT INTO wnu_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","End munon ger qob qamb inorou munai unumot apand qamb wonou qob nonogursierib at igo eng, Qenu gor toat qamb igo Qenu wo inorou munai mor end igo. ");
INSERT INTO wnu_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ne munon ger qob qamb Qenu wonou ginam unumot qamb wonou qob nonogursierib ebeiner eng Qenu wonou bugab igo eng nob wo git eng nob nag bigiba. ");
INSERT INTO wnu_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","An qomon imbigau munon ne Parisi nob an munon misir ombur end an qoyamet igoarar. An mi niau qamaaman eng bubur 10-ende big wogub bubur gari qas Qenut maribig igoumon. Ego qomon qob aib eng an biisitet igoumon. Mi bubur gari qas Qenut maribig igoumon qomon eng git uber. Me wagar. Ende ebet igo bo imusi qomon aib uber toat igoarar. Munon qomon qoregen qereimau eng ne, munon wurimusiau eng ne, oau apand qomon eng. ");
INSERT INTO wnu_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","An munon mag tuum gas ende, end munon qei tap wuriimbiguboun qamb at igoumon? An eng ebet igoumon eng ete gas: Mani yoor uber eng mi qanining qomourt isub igama gab yoor aib eng ten unab arir igoumon. Ego wai kamel aib mi sig mag diban eng, an ten mugimari isub anquguragsi igo. ");
INSERT INTO wnu_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","An qomon imbigau munon ne Parisi nob, an munon misir ombur big qamarau tari, an qoyamet igoarar. Qogum, tabin nob ag musub birogoni igoumon. Ego erobon eng mi urim baiau eng ne aninomit gari misir igau qomon eng anit yab di iua igo. ");
INSERT INTO wnu_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","An Parisi mag tuum. Qogum erobon unun igo eng gigit birogoni wogub ne ag eng gor birogonimari oan buriner. ");
INSERT INTO wnu_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","An qomon imbigau munon ne Parisi nob, an munon qob ombur qamarau tari, an qoyamet igoarar. Munon wuri tumuni wogub tumun qabar qipiot igour eng sig uber gab igoun, ne tumun erobon eng munon biet qer nerer isub igo. ");
INSERT INTO wnu_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","An eng gas ende. Git goan ag eng musub git baab munon inimbagaiar qamb qenu big qib igoumon. A aninou misir eng qob qetopur qamarau eng ne qomon boru qei yab di iua igo. ");
INSERT INTO wnu_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","An qomon imbigau munon ne Parisi nob, an munon qob ombur qamarau tari, end qoyamet igoarar. Munon qob gigit qamarau ne munon qoregen qoan umbriamir wurinou tumun eng mat obotar ne git batar ");
INSERT INTO wnu_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ne ete at qamb igoumon. Qoan in tonoanb igour gas ende igunei ende qi eng munon munon miteri qamb gumatemir eng eng igaramb abari in nob me ebet igamau qi. ");
INSERT INTO wnu_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ende qamb igoumon end ne an munon qoan qob gigit qamarau munon igaramb igour eng wurinou wau tumbigi eng an gari. ");
INSERT INTO wnu_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","End ne see bo aninou tonoanb qomon eng song toat ebet igoarar. ");
INSERT INTO wnu_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","An mani boru wurinou wagrari wurinob. Qenu aninou qomon boru end anamar qemeriba an maigas at wo menmant waberemboumon? ");
INSERT INTO wnu_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","End aninob ete qemerini: ye munon miteri qamb gumatemir eng ne munon misir nob ne imbigau munon wuriimurimine isari an der qei igaramari umubour, ne qei wuribaab nam tenori big igaramboumon, ne qei oromar aninou inorou munait end isub pisirami igaramb ne wurinou qob eng qerei gub qamb ebet orotoar ariramari ginam aib ger end isari bo end orotoar ginam aib ger end arir, ende abari qirubour. ");
INSERT INTO wnu_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","End ne munon qoregen ag e igamari igaramari umumir eng aninou wurit imiamanei. Munon qoregen eng wuri Abel tumbigi end isi yarab Sekaraia qangang end igaramari umumirei. Sekaraia wo Berekia wonou wau aninou duimari baab inorou munai qau igama ne nam qab mian iset big igour igama wobon end waramari umorei. ");
INSERT INTO wnu_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","End apand aninob quraum, qoan eng ebet igour end taui qamb munon yurau see igour eng an nob garisi mom uru iruboumon. ");
INSERT INTO wnu_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","An Yerusalem munon, an munon miteri qamb gumatemir eng igaramb ne Qenu wonou qob eng aninob qamarar qamb munon wuriimurima isub igour eng nob nomont igaramb gorubi igoumon. Ye qenen aninou munon yurau uben umai wuri big igoum. Teteri unor qaman wurimuaser igo gas ende wurisi igoum. Ego aninou yesiningot wogub igoumon. ");
INSERT INTO wnu_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","End ne an igar, aninou munai ginam miwan der iriba. ");
INSERT INTO wnu_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","End an ye bo me yegunanei, isi yarab an ete yet qamb ne imbiguboumon: Qenu munon eng nonogursia munon aib unumot yara.” ");
INSERT INTO wnu_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yisas end qamb wogub inorou munai eng wogub qoa wonou imbigau yurau eng wot yar inorou munai eng mindatemir eng sirbigub qamb yaremirei. ");
INSERT INTO wnu_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yarari wurinob qamar: “An inorou munai aib e ende gaumon? apand aninob quraum, nomon aib-aib wonomi tenori gas gaumon eng bais ger wagari erer et me igorinerei, gugum mom gumotoburmari ag der uburiba.” ");
INSERT INTO wnu_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ende qamb wogub ir ai qaur Olib man aib end igama wonou imbigau yurau bo end qi wot yarab qebi qamamir: “Ne mi eng gagar ebeiba quran eng qen mait mi eng ende ebeiba? Ne gor in mai gas mirorub gab imbig ne bo dara mi gugum uburiner eng imbiguboun?” ");
INSERT INTO wnu_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ne Yisas taui qamar: “Munon qei anmurimar qomorunor eng qoyamet igoarar. ");
INSERT INTO wnu_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Munon irou yar yeunumot, ‘ye munon anubersiau tari eng yoroum,’ ende qamb munon irou wurimurimarubour. ");
INSERT INTO wnu_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ne gor aib qamb yogorari toau iguboumon ne ai qei der ai qei nob yogorari qob toau qas isa iguboumon. Ego an eng igub qiet me abar. Mi eng gagar apand ende ebeiner eng qen sindomund eng weretet end me yarinerei. ");
INSERT INTO wnu_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Munon yurau wurinou-wurinou tau purab tau nob yogurubour. Ne munon baraitari ger wonou yurau eng der ger wonou yurau eng nob yogurubour. Ne ai qei munon qunumber qen gagam igorubour, ne ai qei ai aib qamb uyeiba. ");
INSERT INTO wnu_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Mi eng gagar ebeiner eng yamangar wau baib qamb mogis qeret aruab igo gas ende munon gugum ende igubour. ");
INSERT INTO wnu_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Qen end an yonou yurau igamari ion animbag borusi ansumungasiorubour. Ende at qei aningaramari umuboumon. Ne munon irou ansiningoarubour. ");
INSERT INTO wnu_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ende abari an irou der yet oau apand igorunon eng bo ye woguboumon. Wogub aninou qanam erogori eng qei der qi dui, ne aninou gor der bain qiyo ima duima umb ende at igoruboumon. ");
INSERT INTO wnu_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ne qei miteri quraun qamb munon irou wurimurimarubour. ");
INSERT INTO wnu_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ende ebet ne qomon boru eng sig aib burab wogub munon qi toubet igamau eng uma isiba. ");
INSERT INTO wnu_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ego munon ger wonou ibitiri mom nonoguret igoriner eng isi yarab qen sindomund qangang end yar Qenu wonou qubeima igomot igoriba. ");
INSERT INTO wnu_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","End Qenu wonou bibis big igo qob uber eng munon ginam-ginam isa igub igamari qanamt qen sasam eng yariner.” ");
INSERT INTO wnu_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Qamb qamar: “Qen end mi boru aib ger mi gugum borusi igo eng deara guboumon. End qoan qob gigit qamarau munon Daniel qamar gas ende, diab munai qau end naget igoriba. (Munon qob eng qanam dibes imbigib eng mom musub qerei ne misir iginer). ");
INSERT INTO wnu_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ende aba ne munon Yudia igour eng iua ai qaurent irubour. ");
INSERT INTO wnu_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ne munon ag igorunor eng qen eng yara gab gegir bo qand mor isub wurinou mind eng qand me baunorei. ");
INSERT INTO wnu_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ne munon ger man igoriner eng bo qand irab wonou mi goan me bainerei. ");
INSERT INTO wnu_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ne yamangar qugurau igour eng nob wau se ba inau wurisab igour eng boru mesis. ");
INSERT INTO wnu_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mi boru aib ger yariner eng wot yari qoaun qamb Qenu simot arari wo aba mi boru eng ya tatabrima qiyo inorou qent me yariner. ");
INSERT INTO wnu_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Qoan ai big-big qugurau ger ende me gab igamau isi yarab qen see igoun eng. Ne qugurau see yariner eng sig-sig mom boru aib. Eng ubura ne qugurau bo bais ende qen geret me gunei. ");
INSERT INTO wnu_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Munon gugum mom umb uburunor qamb Qenu wonou uyes qen eng pitensieriba. Qenu wonou munon wurimaribigor end oromar irib qamb wonou uyes qen pitensieriba. ");
INSERT INTO wnu_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Qen eng yara gab munon qei der anmurimar, ‘Munon inubersiau tari eng e qo ire,’ ende qamarari an wurit me oabigar. ");
INSERT INTO wnu_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Munon qetopur wuri yar Munon ubersiau tari qiyo munon miteri qamb igour wurit big qomorubour. Qamb qomon wes-wes eng Qenu wonou munon wurimaribigor eng wuri oabigar qamb ende oboubour. ");
INSERT INTO wnu_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ende obounor end ye gigit aninob qamam eng an igub nonoguret igoarar.” ");
INSERT INTO wnu_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ne qamar: “Munon Qenu maribigor eng wo der seger ait umond igo, ende qamb qiyo a ‘wo yar waber e igo,’ ende qamb abari an me wurit oabigar. ");
INSERT INTO wnu_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Munangit wau wo deriner eng sig qand. Ai itet qebisi qand ai gugum begent uburab igo gas ende at deriba. ");
INSERT INTO wnu_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Munon teteret end morogan piou yar qiumuni igour.” ");
INSERT INTO wnu_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ende qamb qamar: “Mi eng ende ubura ne woromt ai iturama ne inaun mag bo me gunanei, ne tapai norumor dorubour. Ende abari ne mi gugum tatet igo eng uyab uburiba. ");
INSERT INTO wnu_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ende aba gab igamari Munangit wau derib qamb mari tatet end aba guboumon. Gab munon ag e eab igo gunor eng Munangit wau waber ten ne wonou qiribiten eng begent deriba. ");
INSERT INTO wnu_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ende at ne ain mer gusimari toau aib isiba. Isa wonou munon yurau enger wuriimurima ai gugum isub Qenu wonou munon yurau wurimaribigor eng wuriba qiumunimbour. ");
INSERT INTO wnu_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","An qen maribigub qamb eng nam togun end imbiguboumon. Togun wara gab eng qo worom qen piara ende qamb igoumon. ");
INSERT INTO wnu_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Eng gas ende gari mi eng gagar quraum eng ende mirorub gab eng qo qen eng piara ende qomoruboumon. ");
INSERT INTO wnu_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Eng igar, mi eng ebeiner eng munon see igom igour eng umb uburubour. ");
INSERT INTO wnu_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ne tat ai nob mom uburiba, ego yonou qob eng anir qomourt ger me uburinerei.” ");
INSERT INTO wnu_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Qen eng quraum eng munon ag et qomourt ger qoyam ue, ne enger ger qoyam ue ne wonou wau ten eng gor qoyam ue. Tain wonou gari qas-qas qen eng qi maribigor end imbig igo. ");
INSERT INTO wnu_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Munangit wau wo bo deribeiner qen eng gab qoan Noa ebeter gas ende ebeiba. ");
INSERT INTO wnu_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ya qoan qarib diab igaraminer wuri qoyam ue end wuri ya uter nub mani ubub nub munon yamangar qi baub mismisir igamari Noa tabin erobon isorei. ");
INSERT INTO wnu_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Wuri song ar igo ende ebet igamari ya qoan diab wurimuara umb uburemirei. Eng gas ende gari Munangit wau deriner qen eng munon yamangar ende at igamari deriba. ");
INSERT INTO wnu_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Qen end munon ombur man sarau baab igorunor eng ger Qenu mot irab ger wegiba. ");
INSERT INTO wnu_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ne yamangar ombur mani yab igorunor eng ger mot irab ger wegiba. ");
INSERT INTO wnu_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","End ne qen mait aninou munon barai deriner qi eng an qenen girinet tug igoarar. ");
INSERT INTO wnu_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Qomon ete eng imbig igoumon: munon ger wonou munai eng munon ger diab mon iru isub wonomi eng urim bainer qen eng imbiginer eng wo mai ebesam wara diab mi wot baiba? Ue. ");
INSERT INTO wnu_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Qanam end ne an qenen ar tug igoarar. Munangit wau me deriner qamb ar song igamari deriner qamb quraum.” ");
INSERT INTO wnu_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ende qamb qamar: “Sarau munon ar ger sarau musub qob toat sarau ebet igoriner eng wonou munon barai eng maribiga sarau munon qei eng oroar igama sarau baab igour. Ende at igamari mi git eng qen eng yara werisiba. ");
INSERT INTO wnu_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Sarau munon eng wonou munon barai qemeriner gas ende sarau musub ebet igama yar gea sarau munon eng mismisiriba. ");
INSERT INTO wnu_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","apand aninob quraum, munon eng ende uberara wonou munon barai eng maribiga wonomi gugum qoatet igoriba. ");
INSERT INTO wnu_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","49","Ne sarau munon boru tagug eng wo ete qamb igo, ‘Yonou munon barai eng sobor yariba gab,’ qamb wo der wonou sarau erogori baab igorunor eng igaramb, a ya uter nub qanganget mismisir ende at igoriba. ");
INSERT INTO wnu_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","At igama wonou munon barai qen geret yar giner eng wo song ar igo ende at igama eng qen geret wo nasi wegiba. ");
INSERT INTO wnu_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Wogub ba sumungasi imurima munon boru eng oramar igoriba. Igo eab nan nob yogub igorubour.” ");
INSERT INTO wnu_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ne mi geret big qamar: “Qen end Qenu wonou ginamt bibis igo eng yamangar yorou 10-ende munon ger irub se baub wogub yara qataben is gab mot yarub qamb urut uruguni baub isub igour gas ende. ");
INSERT INTO wnu_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ne yamangar 10 eng 5-ende wuri tagug, ne bo 5-ende eng wuri misirnob. ");
INSERT INTO wnu_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Yamangar 5 tagug eng wuri urut gari-gari mor end uruguni qas ba isumirei, ui ar ger me baiau. ");
INSERT INTO wnu_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ne yamangar 5 misirnob eng wuri urut uruguni ba ne ui ar gor ba isumirei. ");
INSERT INTO wnu_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Isub munon eng sobor me diara qoat-qoat igoi wogub mungam igara inemirei. ");
INSERT INTO wnu_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Itum wobon end igumir eng ete qamb amirei: ‘munon yamangar se baiar eng di igo. Isub gab mot diarar.’ ");
INSERT INTO wnu_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","8","Ende igub gugum der bugab urut uruguniamirei. Ne yamangar 5 tagug eng der qei misirnob eng wurinob qamamir: ‘An urut qei indarar, in urut araret uburai.’ ");
INSERT INTO wnu_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ende qamarari misirnob eng der tagug eng wurinob qamamir, ‘in urut ininou qeemben gari, ui ger igama gab me andarunei. End ne aninou bo isub urut wes gab suab urugunimar.’ ");
INSERT INTO wnu_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ende qamarari wuri bo urut umau suoub qamb isari munon eng diara yamangar 5 misirnob tug igour eng mot mor isub mondir nausi ubet wogub bugab mi nub igurei. ");
INSERT INTO wnu_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","12","Ne yamangar 5 urut baub qamb isumir eng bo qanamt yar ag irot igo qamamir, ‘barai, in gor mondir weimatara diorub,’ qamamir e munon eng taui qamar: ‘apand aninob quraum, ye an sir ue end mondir me weimatarinei.’ ");
INSERT INTO wnu_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Qob eng igub ne an mom qoyametarar. Qen eng yariner eng an sir ue end.” ");
INSERT INTO wnu_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ne bo qamar: “Munon aib ger ai pa qoaib qamb ne wonou sarau munon wurit qamara yarari wonomi eng qerei gari-gari qoat igoarar qamb wogub qorei. ");
INSERT INTO wnu_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Wonou sarau munon wurinou misir ne qomon ne qer gagam eng imbig ne mi qeemben ende wurit wogub qorei. Geret nomon qur qangang K5,000-ende uterei, ne ger K2,000-ende ne ger K1,000-ende wurit qerei wogub isorei. ");
INSERT INTO wnu_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Isa wogub munon K5,000 bauor eng qand isub nomon qur end sarau ebet bo ui ar K5,000-ende baurei. ");
INSERT INTO wnu_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ne bo munon K2,000 bauor eng gor nomon qur end sarau ebet bo ui ar K2,000-ende baurei. ");
INSERT INTO wnu_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ne munon nomon qur K1,000 bauor eng bisub tumun goanet wogub wonou munon barai nomon qur eng tumunimetet wagerei. ");
INSERT INTO wnu_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Togun irou uma wogub wurinou munon barai eng yarerei. Yarab nomon qur wurisab wogub isuor eng mai ebetemirei qi eng gib qamb wuriqiumuniamorei. ");
INSERT INTO wnu_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ne munon K5,000 utab wogub isuor eng sarau ebet wogub bo imusi K5,000 bauor eng ba yarab sirbig qamar: ‘Barai, ne K5,000 yasab wogub iuan eng ye bo nomon qur end sarau ebet imusi bo K5,000 baum e ge.’ ");
INSERT INTO wnu_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ende qamara wonou munon barai taui qamar: ‘Sig uber ebetenei, ne sarau munon qangiri uber. End ne mi ye nemaribigine mi irou qoat igoriban. End ne ne yara yenob uberet igorun.’ ");
INSERT INTO wnu_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ne bo munon K2,000 bauor eng bo sarau ebet imusi bo K2,000 bauor eng ba diab wonou munon barai sirbig qamar, ‘E ge, ne K2,000 yeisen eng ye bo sarau ebet bo ui ar K2,000 baum eng e.’ ");
INSERT INTO wnu_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Qamara wonou munon barai qamar: ‘Ne sarau munon uber end mi qomourt eng bo nonou aba aib burer end ne nemaribigine mi irou qoat igoriban. End yara yenob mismisir igorun.’ ");
INSERT INTO wnu_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ne bo sasam munon K1,000 wot wager eng diab qamar: ‘Barai, ne munon qand mirinet ne munon mani ubari arira ne wurit baub ne munon mi gonari qaur di arira wurit baub igama negab igoum. ");
INSERT INTO wnu_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","End nenet yari wogub nonou nomon qur eng ye tumuni wagom eng e igo e.’ ");
INSERT INTO wnu_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ende qamara wonou munon barai taui qamar: ‘Ne sarau munon boru irigau qoat. Ye eret munon wurinou mani qamb nanasingir qamb baine yegab igoanei? ");
INSERT INTO wnu_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ende gab ne meimet qamb yonou nomon qur bisub nomon qur qirinau big igour munai end big igama ye ete yarab nomon qur ui qei baiau ue? ");
INSERT INTO wnu_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ende ne munon eng nomon qur K1,000-end wot ba munon nomon qur K10,000 igo eng utari sorieminer. ");
INSERT INTO wnu_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","End ne munon ger mi irou igoriner eng ye bo sembigi utibam. A munon ger mi ios ete igoriner eng ye bo wot baine ar igoriba. ");
INSERT INTO wnu_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Sarau munon boru tagug eng an toat ariramari is ag irond igo eab nan suab igoriner.” ");
INSERT INTO wnu_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Qen end Munangit wau bo igeser deriner eng munon barai aib deriba. Dara wonou munon yurau enger nob darab wo nam qab qenenginob end bugemba. ");
INSERT INTO wnu_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Bugab igama munon ag e gugum wo menmant end yar nagari wuriboopur yurau ombur ariramba. Munon wai sipsip meme nob oroar igo bubur qerei sipsip wes wuri ariri a gout wes wuri arir igo gas ende ebeiba. ");
INSERT INTO wnu_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Wai sipsip uberegent wes end bigiba a meme uben qagit wes end bigiba. ");
INSERT INTO wnu_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ende at Munon aib munon yurau uberegent wes eng wurinob qemeriba: ‘An munon yurau eng yonou Tain annonogursi igoar end e yarar. Yarab qoan ai big-big bibis et igoarar qamb anit iyeter end igoarar. ");
INSERT INTO wnu_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ye minemb igimine mani yasari nub igumei. Yat ebet igimine yasab igumonei. Ne ye munon bubun animbegeib isine munai yiimbigari inab igumei. ");
INSERT INTO wnu_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Mi goan ue gab qoot ebine mi goan yasab igumanei. Toar yenara yemusub igumanei, a uyort igimine yar yegab igumanei.’ ");
INSERT INTO wnu_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ende qamara munon qoregen eng taui qomorubour: ‘Barai, qen mait ne minemb igama mi neteminei? qo yat ebet igama neteminei? ");
INSERT INTO wnu_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Qo munon bubun yara negab munai neteminei? qo ararau igama mi goan neteminei? ");
INSERT INTO wnu_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Qo qen mait toar qiyo uyort igama is negab igunei?’ ");
INSERT INTO wnu_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ende qamarari Munon barai taui wurinob qamar: ‘Apand aninob quraum, munon boru ag e ende wuri musub igoumon eng ye yemusub igumanei.’ ");
INSERT INTO wnu_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ne bo munon uben qagit igorunor eng wurinob qemeriba: ‘An munon boru Qenut qob isi wot qamb igoumon eng ye qani me igoarar. Mut qenen oab igo eng yonou Tain Qenu Satan wonou munon yurau enger wurit arsiarerei. ");
INSERT INTO wnu_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","An ye minemb igimine mani me yesau, yat ebet igimine ya me yesari niau. ");
INSERT INTO wnu_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Qunan animbegeib isum eng munai ger yiimbigari me inau. Ne ararau igimine mi goan me yasau, ne gor, toar qiyo uyort igimine an me yemusub igamau.’ ");
INSERT INTO wnu_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ende qamara wuri der taui qomorubour: ‘Barai, qen mait ne minemb qiyo, a yat ebet qiyo, a qunan inimbegeib qiyo, a ararau igama qiyo, a toar qiyo uyort igama me nemusub igamau?’ ");
INSERT INTO wnu_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ne Munon aib taui wurinob qemeriba: ‘Apand aninob quraum, munon boru ger ye mi eng gagar quraum eng an mag gari ibag wogub igoumon eng ye mag gari yegab wogub igumanei. ");
INSERT INTO wnu_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","End ne munon yurau eng qenen migeri igab igoriba. A munon qoregen wuri qenen bebereg igorubour.” ");
INSERT INTO wnu_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yisas qob eng gugum ende wurinob qamb wogub wonou imbigau yurau eng wurinob qamar: ");
INSERT INTO wnu_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Qen ombur ubura ne qoan Qenu munon yurau qei wuriomboasi wager end misir igub mi aib at nub igour eng yariba. Yara Munangit wau baab erer uri nam tenori big warambour,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ne Pris munon baraitari nob Yuda munon baraitari eng nob Pris munon gigit unum Kaiapas munai end qiumuniamirei. ");
INSERT INTO wnu_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ende at ne qob qetopur qei qi Yisast big qamb waramari um qamb. ");
INSERT INTO wnu_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Qiumuni qamamir: “Mi niau qen qau aib end mi eng me oboun, ende oboun eng munon ininob yogurubour,” ende qamamirei. ");
INSERT INTO wnu_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Qen end Yisas Betani end munon ger Saimon qoan iam qarat ir igoar eng nob igoai. ");
INSERT INTO wnu_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Igama yamangar ger wer ya sig maieng garant igoar eng ba yarab Yisas mi nub igama wei tarit wot igiamorei. ");
INSERT INTO wnu_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ende aba wonou imbigau yurau eng der gab borusi misiringet qamamir: “Meimet qamb yamangar eng wer ya sig uber eng isi ende biigi igo-o? ");
INSERT INTO wnu_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Waga in eng ba munon wurisab taui qur aib ba qerei munon mi ue eng wurisau ue-e?” ");
INSERT INTO wnu_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Wuri qob eng ende qamb at igamari Yisas ibag wurinob qamar: “An meimet qamb yamangar eng quguragsi igoumon? Wo werei sig maieng eng yet aba. ");
INSERT INTO wnu_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Munon mi ue eng qenen aninou wurinob igoumon ne wurinob igoruboumon. Ego ye qenen me aninob igorinei. ");
INSERT INTO wnu_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Yamangar wer ya yet igimar eng ye yetumunimari obounor eng mirorisab abar eng. ");
INSERT INTO wnu_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","See an igar, qob uber e munon ginam gugum wurit qob suari igubour. Ne gor yamangar qomon uber e abar end wot unum ir igorubour.” ");
INSERT INTO wnu_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Qen end wonou imbigau yurau end ger unum Yudas Iskariot, wo Yisas duimb qamb der Pris munon baraitari end wurit isorei. ");
INSERT INTO wnu_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Isub wurinob qamar: “An meimi ger yesari ye Yisas anit duimine waramboumon?” Ende qamara wuri nomon qur K300 qangang ende qerei utemirei. ");
INSERT INTO wnu_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ende abari Yudas qen ger maribigine Yisas waramar qamb misir igorei. ");
INSERT INTO wnu_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Inorou qen qamar end mani parau yis nob ue eng nub etemir end wonou imbigau yurau eng Yisast isub nob qamamir: “In munai eret arsiune mani parau yis nob ue eng niban?” ");
INSERT INTO wnu_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ne wo der wurinob qamar: “An munai ginam aib end isub munon ger gab ete nob qamarar: “ye umibam qen eng pi gab yonou yurau oramar nonou munai end mi wurinob nibam ende qurai” ende qamarar.” ");
INSERT INTO wnu_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ende wurinob qamb wuriimurima isub Yisas wurinob qamar gas ende ebetemirei. ");
INSERT INTO wnu_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ai gab-gab Yisas wonou yurau oramar bugab mi numirei. ");
INSERT INTO wnu_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Bugab nub igo ne wonou imbigau yurau eng oramar qamar: “An yurau et ger ye yeduimba.” ");
INSERT INTO wnu_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ende qamara imbigau yurau eng boru misir igub gari-gari der Yisas qebi qamamir: “Munon aib, ye ende ebeibine quran qiyo?” ");
INSERT INTO wnu_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ne Yisas der taui wurinob qamar: “Munon ye nob ombur mi tabint ba nub igoun eng yeduimba. ");
INSERT INTO wnu_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Munangit wau uminer end qob wonou qoan gumatemir igo eng wonou toat ende ebeiba. Ego munon Munangit wau duieminer eng boru mesis. Set unor me baurei ende qi eng uber qi.” ");
INSERT INTO wnu_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ende qamara munon Yisas duieminer eng, Yudas der Yisas nob qamar: “Imbigau munon, ye qi-i?” Ne Yisas qamar: “Wo mai, nonou gari quran eng.” ");
INSERT INTO wnu_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ende qamb mi nub igo ne Yisas mani parau ba Qenut qebi qamb boroumi wonou imbigau yurau wurisab qamar: “E yonou min, an ba niar.” ");
INSERT INTO wnu_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ende qamb ne bo wain ya qogum ten ba Qenut qebi qamb wurisab qamar: ");
INSERT INTO wnu_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","“An gugum niar, e yonou qeru, Qenu anit iyeter end. Aninou qomon boru eng yonou qeru eng anit iger anbirogonima wirab isi qamb. ");
INSERT INTO wnu_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Apand aninob quraum, ye bo sabar wain ya anamar me ninei. Iisi yarab qen geret wain ya bubun Tain wonou bibis end erogori bo nuboun.” ");
INSERT INTO wnu_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ende qamb uru wab wogub ai qaur Olib man end iramirei. ");
INSERT INTO wnu_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Irab Yisas der wurinob qamar: “See itum et an gugum yewogub qoouboumon. Qenu wonou qob qoan ete gumatemir igo gas ende, ye wai sipsip oroar igoriner eng waramine wogub sipsip git eng bunumban iua uburubour. ");
INSERT INTO wnu_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Qen geret ye bo igomot der bugab an igamari ye gigi Galili end isibam.” ");
INSERT INTO wnu_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ende qamara Pita der naget taui qamar: “Ye bais me newogub quinei, qei ende at newogub qoounor qiyo?” ");
INSERT INTO wnu_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ne Yisas taui qamar: “Git apand quran, ego teteri qarig se me erinerei igama ne yet, “munon eng ye sir ue” ende yet qemeriban.” ");
INSERT INTO wnu_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ne bo Pita taui qamar: “Bais ende me net qemerinei, ar ombur iningaramb qas wogubour.” Ende qamara imbigau yurau qei eng der gugum gari end qamb ugamirei. ");
INSERT INTO wnu_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ende qamb wogub Yisas wonou imbigau yurau eng oramar ai unum Getsemani end iramirei. Irab wurinob qamar: “An et igamari, ye bais qirat isub Qenut qebi qemeribam.” ");
INSERT INTO wnu_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ende qamb irib qamb Pita ne Sebedi wonou wau ombur eng ende oramar irab qen end borusi yari ne oau quguragetarei. ");
INSERT INTO wnu_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ende at ne wurinob qamar: “Ye borusi oau quguraget umib misir igoum, an et igo ye yenogursi igoarar.” ");
INSERT INTO wnu_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ende qamb wogub wuri ete wuriwogub wo bais ir-ir qitand irab wonomi ai qent qumond arir tari mauet qamar: “Tain a, ne yeduet gab eng ye ba wabiom, ego ye ar nonob quraum, nonou qas.” ");
INSERT INTO wnu_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ende at wogub yonam yar imbigau munon ombur gari eng ibagar eng wuri qoan naat inemirei igamari ibag Pita nob qamar: “An munon ombur gari mai gas oboumon? An bais gurum yoat ig-ig inau ue e? ");
INSERT INTO wnu_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ende obounon eng mi ger an warigesia wot uburab me isunanei. Git apand, misir qenungar ego git goan sig yarima.” ");
INSERT INTO wnu_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ende qamb wogub bo qen omburt irab qebi qamar: “Tain a, ya uyeriri boru qogumt e nonou qas, ni qamara gab eng nini?” ");
INSERT INTO wnu_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ende qamb wogub bo isub munon ombur gari eng ibagar eng bais me der bogomau, inab qas igurei. ");
INSERT INTO wnu_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","45","Ende at igamari ibag wogub bo wuriwogub irab qen omburt irab ur nob qamar gas ende bo nob qamb wogub yar ibagar eng ende sig inab igamari ibag qamar: “An mom ar inab sig misir igoumon eng, der bogomari isun, Munangit wau baab munon boru wurit imurimunor qen eng see. ");
INSERT INTO wnu_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Der bogomari isun, munon ye munon qarau wurit imbiginer eng pi di igo.” ");
INSERT INTO wnu_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yisas qob eng ende qamb igama wonou munon yurau 12-end ger unum Yudas eng munon yurau wuri nerima Pris munon baraitari eng nob Yuda munon baraitari eng nob der munon yurau wuri qereimari bui qauri ba qombuni ba diamirei. ");
INSERT INTO wnu_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Diorub qamb Yudas der munon yurau wurinob qamar: “Irab ne munon bounon eng ye qani irab nob qobub ende ebine gab ne munon eng qamb baaiar.” ");
INSERT INTO wnu_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ende wuriimbig qamb wogub ir weib irab Yisas qani ir naget qamar: “Io, munon qoyam imbi-imbi, igoan eng.” ");
INSERT INTO wnu_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ende qamara Yisas taui qamar: “Ne mi ebeib qamb dian eng qand eb.” Qamara munon yurau eng Yisas imbig di baab touriamirei. ");
INSERT INTO wnu_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ende abari Yisas wonou yurau end ger der bui qauri eng beneri Pris munon baraitari wonou sarau betet igo eng iruges ig soabur ariramorei. ");
INSERT INTO wnu_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ende aba Yisas der nob qamar: “Bui qauri bo ogumuniom, munon bui qaurit yogurunor eng bui qaurit mom umb uburubour. ");
INSERT INTO wnu_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ye munon yurau e wurinob yogurib ende qi eng Tain qebi qemerine enger yurau in tain qanam gari 12-eng initanami wuriimurima darab innonogursi munon yurau e wurinob yogorour qi. ");
INSERT INTO wnu_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ego ye ende ebein eng Qenu qob qoan igoar eng mai gas irimanimba? Eng gab ne qob igo end toat wonomi ende irimaniminer.” ");
INSERT INTO wnu_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ende qamb ne munon yurau aib eng wurinob qamar: “An see at diaumon eng wonou wes ar. Bui qauri ba qombuni ba munon ger mi urim baia gab waramb at igour gas ende at diaumon. Qenen inorou munai aib end erogori bugab qob animbig igoum eng an ger der yanamb ende me abau? ");
INSERT INTO wnu_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","“Ego an eng oboumon eng Qenu qob qoan qamara munon miteri qamb gumatemir eng gab oboumon.” Ende qamara wonou imbigau yurau eng qen end wogub iua uburemirei. ");
INSERT INTO wnu_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Munon yurau Yisas baamir eng mot munon Pris baraitari gigit unum Kaiapas wonou munai mor end isumirei. Qen end qomon qerei imbig igour eng ne munon baraitari qei erogori end qiumuni igurei. ");
INSERT INTO wnu_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pita qanam mugenderi ibag-ibag isub igoar eng is Kaiapas wonou munai igama youn man qob musub igour end is bur tuum wurinob bugab igoai. Igo Yisas mai siarari gin qamb asi gab igoai. ");
INSERT INTO wnu_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Pris munon baraitari eng ne kaunsel gugum qiumuni munon qei wurimaribigari Yisast gag qob wot big qamarari igub waramune uminer qamb at igurei. ");
INSERT INTO wnu_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Munon irou diab ego munon ger me geau. Munon irou diab qob gag-gag wot big qamamir eng gor qanam ger me geau. Ende at igamari munon ombur diab naget qamamir: ");
INSERT INTO wnu_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Munon eng ete at qamarei, ‘ye inorou munai aib e bapami qen ombur garit mindat ugeibam’ ende qamarei,” qamamir. ");
INSERT INTO wnu_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Pris wurinou munon aib gigit eng der naget Yisas qebi qamar: “Qob irou nenet big ne qebi quraur eng ne ger taui wurinob me qemerinenei ii?” ");
INSERT INTO wnu_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ende qamar ego Yisas qob ger me qamarau. Ende igama ne Pris wurinou gigit eng bo der nob qamar: “Qenu qenen bebereg igo eng wo unumot nonob quraum. Ne mom apand Qenu wonou wau munon wuriubersiau tari igo gab eng see nonob quraum eng taui qem.” ");
INSERT INTO wnu_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ende qamara Yisas taui qamar: “Nonou gari quran gas ende. Ego ye ete aninob qemerini, qen geret igo gunon eng Munangit wau Qenu qiribiten wonou ginamt igo eng uberegent wes end bugab dara guboumon.” ");
INSERT INTO wnu_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ende qamara Pris munon aib eng igub wonou mi goan boobur arir qamar: “Munon e Qenut mom qob isi qamara gugum mom diban igub ugaun eng gab bo sabar munon qei me wurit qumurunei. ");
INSERT INTO wnu_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Eng gab an mai misir igoumon?” Ende wuri qebi qamara wuri qamamir: “Wo mom qomon biisitet qurar eng gab mom uminer.” ");
INSERT INTO wnu_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ende qamara menmant mu wot mendir a qei ar waramb a qei mataisi waramb ende ebet ne qebi qamamir: ");
INSERT INTO wnu_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Ne munon wuriubersiau tari end your nanamai qi eng qeemben maribiga nogoun?” Ende qamb igurei. ");
INSERT INTO wnu_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ne Pita isub qut big igour youn man end igoar eng ende igama ne Pris munon barai ger wonou sarau yamangar ger yar gab nob qamar: “Ne gor Galili munon Yisas eng nob igama negunei.” ");
INSERT INTO wnu_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ende qamarari wo der munon irou wurimurimar qamar: “An qob eng at quraumon eng ye musub me imbigoum.” ");
INSERT INTO wnu_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ende qamb bo iua isub-isub naget igama bo sarau yamangar ger bo yar gab munon qani eng igour eng wurinob qamar: “Wo gor Nasaret munon Yisas eng nob igama gunei.” ");
INSERT INTO wnu_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ende qamara Pita bo der wurimurimar qamar: “Apand quraum, munon eng wot quraumon eng ye sir ue,” qamar. ");
INSERT INTO wnu_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Umi-umi ende at ne munon yurau eng igour eng Pita wot yar qamamir: “Apand, ne gor munon eng wonou yurau. Ne qob qamara mindiram goten igoun end ne mom niimbigoun.” ");
INSERT INTO wnu_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ne Pita qob ger nausi qamar: “Qenu magqurt anmurimar me qemerinei. Sig apand munon eng quraumon eng ye sir ue.” Ende qamara teteri qamar arei. ");
INSERT INTO wnu_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ara Pita Yisas qob qoan ete nob qamar end misir igorei: Teteri me erinerei igama ne qen ombur gari ende, ‘munon eng ye sir ue’ ende yet qamara teteri qamar eriba. Qob eng igub wogub ag isub borusi eab igoai. ");
INSERT INTO wnu_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Itum der ne Pris munon baraitari eng ne munon baraitari qei nob qiumuni qib qei Yisast big qamb nausi waramune uminer qamb ebetemirei. ");
INSERT INTO wnu_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ende at touri wogub imurimari Pailat Rom gabman end isorei. ");
INSERT INTO wnu_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ne Yudas, munon Yisas duiamor eng igo Yisas gar eng ende ba bumai waramb sumungasi ende ebet igamari gab borusi toubet wogub nomon qur qangang 30-ende bauor eng bo ba isub Pris munon baraitari eng nob munon barai qei nob wurisab qamar: ");
INSERT INTO wnu_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Ye munon qomon boru ten eng munon qoregen eng duiam end waramari umibar eng.” Ende qamara wuri taui qamamir: “In qob ger ue, nonou borusianei.” ");
INSERT INTO wnu_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Qamarari nomon qur eng inorou munai mor end arir wogub isub wonomi ibiari umorei. ");
INSERT INTO wnu_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Pris munon barai eng nomon qur eng ba qamar: “Nomon qur e munon wuribirerimau nomon qur eng gab inorou nomon qur e nob sori me bigun.” ");
INSERT INTO wnu_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ende qamara nomon qur end qob qamb nausi wogub ne nomon qur end munon egi baab igour ai eng taui wurisab ne ai eng bo munon mug is ginam end igour eng umari wuritumuni igorun qamb wugumirei. ");
INSERT INTO wnu_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Qanam end ne see ai eng unum ‘qeru’ end qamb igour. ");
INSERT INTO wnu_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Qob eng miteri qamarau munon Yeremaia qoan qamar eng irimanima. Ete qamarei, “Isrel munon, wuri nomon qur 30-ende munon eng taui qamb maribigumirei. ");
INSERT INTO wnu_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Nomon qur eng bo egi baab igour ai eng tau baumirei. Munon aib wonou qamar gas ende.” ");
INSERT INTO wnu_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yisas is Rom gabman menmant end nagasiari der qebi qamar: “Ne Yuda wurinou munon baraitari igoan qiyo?” Ne Yisas taui qamar: “Nonou gari mom quran eng.” ");
INSERT INTO wnu_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ende qamara Pris munon baraitari eng ne munon barai ar eng der qob qei nob qamamir eng wo qob taui ger me wurinob qamarau. ");
INSERT INTO wnu_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ende igama Pailat bo nob qamar: “Qob irou nonob quraur eng ne ger taui me wurinob qemerinenei ii?” ");
INSERT INTO wnu_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ende qamar ego Yisas qob ger bais me nob qamara igu gabman baraitari aib eng misir qebebi igub igoai. ");
INSERT INTO wnu_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Togun gugum qen qau aib end Rom gabman munon uyort igour eng gari qas ar wuri waga qenen iua igour. End munon yurau aib eng munon uyort igour eng ger ar wurit waga isiner qamb Pailat qebi amirei. ");
INSERT INTO wnu_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Qen end munon igeig qoat ger uyort igoai, unum eng Yisas Barabas. ");
INSERT INTO wnu_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Munon yurau aib qiumuni igamari Pailat wuri qebi qamar: “Your ar wugine anit isi qamb misir igoumon? Yisas Barabas eng qiyo a Yisas munon inubersiau tari qamb igour eng?” ");
INSERT INTO wnu_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pailat wo Yuda munon musub mom wuriimbigorei. Wuri Yisas mom siningot wogub waramb ebetemir end. ");
INSERT INTO wnu_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pailat qut bigau nam qab end bugab igama ubeni qob wot big qamar: “Ne munon qoregen eng meimi ger me wot eb. Itum inab inigi wo gaum end oau quguraget igoum,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ne Pris munon ne munon barai ar qei der munon yurau wurinob qamarari Pailat nob qamarari Barabas wurit waga yara Yisas waramari um qamb qamamirei. ");
INSERT INTO wnu_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Qamarari Pailat bo der munon wuriqebi qamar: “Munon ombur e, your eng ar wugine anit isiner qamb qenungoumon?” Ne wuri qamamir: “Barabas.” ");
INSERT INTO wnu_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ne Pailat bo wuriqebi qamar: “Ende gab Yisas Munon inubersiau tari qamb igour eng ye mai sieribam?” Wuri qamamir: “Nam tenori big warama uminer,” qamamir. ");
INSERT INTO wnu_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ne Pailat bo qamar: “Wo meimi qomon boru ger ebeterei igama waramboumon?” Ne wuri misiringet qugiab qamb amir: “Nam tenoribig waramb qas wagar.” ");
INSERT INTO wnu_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ende abari Pailat bo sabar qamb igama eng nob yogurubari gab ne ya ba munon magqurt wonou uben birogoni wogub wurinob qamar: “Munon e uminer eng ye mindigar qob ger yet me igorinerei, aninou qas.” ");
INSERT INTO wnu_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ne munon yurau aib eng taui qamamir: “Munon eng uminer eng qarabab eng ininou init yar imusi ininou wau eng wurit isiner eng qob ue.” ");
INSERT INTO wnu_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ende qamarari Pailat Barabas ar wurit imurima isa ne Yisas ba waramb wogub ba erer urimar qamb imurima wurit isorei. ");
INSERT INTO wnu_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ne Pailat wonou yogorau munon yurau eng Yisas mot gabman munai end isari munon yurau aib yar qouiamirei. ");
INSERT INTO wnu_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ende at wonou mi goan eng beasimetet ne bo mi goan mian nob ger qumanimetetemirei. ");
INSERT INTO wnu_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ne uyor qer nob ger ba mebir barsi ne tarit end bugamsitet ne gotau ba uberegent end utari baurei. Baia ne menmant end gamaur wot bugab ber qob nob qamamir: “Ne Yuda wurinou munon barai qenen igomot igamau eng ne e?” ");
INSERT INTO wnu_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ende qamb wot mui a gotau baub igoar eng wot ba tari qer omboipi, ");
INSERT INTO wnu_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","ende at wot igerig wogub mi goan mian qumanimetetemir eng boair ne wonou mi goan eng bo qumanimetet. Ende at wogub big waramb qamb nob isumirei. ");
INSERT INTO wnu_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Nob isub igo ne qataben gamir eng Sairini munon ger unum Saimon, wo gab Yisas nam togor isub igoar eng wo bo bai qamb qamarari baurei. ");
INSERT INTO wnu_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Baia is ai Golgota qamb igour end isumirei. (Unum Golgota qanam eng, ‘ai qaur munon tari gas ende’). ");
INSERT INTO wnu_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Isub ya ger ya uter nob biiges utari nub git uter meinsi qamb utemirei. Ego Yisas wo imbig bo me niau. ");
INSERT INTO wnu_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ende aba erer big waramb wogub wonou mi goan eng qerei baub qamb sauamirei. ");
INSERT INTO wnu_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ende at ne qoat naget igurei. ");
INSERT INTO wnu_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Yisas big waramirt tarit erer end mindigar qob wot qamb waramir qanam eng ete qamb gumat bigumirei: MUNON E YISAS YUDA WURINOU MUNON AIB ende qamb gumatemirei. ");
INSERT INTO wnu_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Yisas wobon big waramir eng igama uberegent wes end munon mindigar qob ten eng ger big waramirei ne ger qagit end big waramb ende ebetemirei. ");
INSERT INTO wnu_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ende igama munon yamangar tap eng isub di ende at qib igo Yisas gab tari misimat ete qamb-qamb qib igurei: ");
INSERT INTO wnu_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Munon eng inorou munai aib Tempel eng bapami qen ombur garit mindat ugeibam qamb igoan end. Ne apand Qenu wau igo gab eng nam tenori big nanamour eng norumi ag der.” ");
INSERT INTO wnu_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ende qamarari Pris munon barai ne qomon qerei imbig igour eng ne munon baraitari qei der qob eng gari nob qamamir: ");
INSERT INTO wnu_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Wo apand Isrel wurinou munon baraitari igo gab eng ag deriner. Wo munon ar wurimusub igoar end wonomi ende bo musia eng in apand wot oabiguboun. ");
INSERT INTO wnu_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Wonou Qenut oabig ne qamar end, ‘ye Qenu wonou wau ten’ qamar end Qenu wot apand oabig qamb igama eng wagari qi gab igumune nerima dara gun.” ");
INSERT INTO wnu_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ende qamarari ne munon boru ig-ig big igaramir eng gor der ber qob ende gari wot qamamirei. ");
INSERT INTO wnu_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Yisas uriamir eng ende igama worom ginam tog yara ne ai gugum ituramorei. ");
INSERT INTO wnu_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Itumoramor eng ende igama igoi worom qumat dara ne bo begenerib pisia ne Yisas qugiab qamb ar: “Eli, Eli lema sabaktani.” Qob eng qanam eng ete: ‘Yonou Qenu, meimet qamb ye wogan,’ ende. ");
INSERT INTO wnu_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ende ara ne munon qei qani naget igour eng ende igub qamamir: “Wo Elaiya wot ara.” ");
INSERT INTO wnu_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ende qamb ger der uyab-uyab isub uyer ya ger ba ya ger nob yisir waari wogub qagab gotaut touri wogub Yisas wariges ni qamb uterei. ");
INSERT INTO wnu_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ende aba qei der qamamir: “Qi wagari gun, Elaiya wot arar eng der musia guboun.” ");
INSERT INTO wnu_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ende qamb igamari Yisas bo sasam qugiab ende qamb ab wogub umorei. ");
INSERT INTO wnu_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ende aba mi goan aib tempel mor uriamir eng metut qitet quburab is durum qumot waser ig-ig isorei. Ne ai aib uyab nomon aib-aib quburabriamorei. ");
INSERT INTO wnu_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ende aba munon teter eng undounder ubura munon qoan Qenut oabig umbriamir eng igomot der isumirei. ");
INSERT INTO wnu_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ende igamari ne Yisas igomot der bogoma ne wuri ginam aib end isari munon gugum ibagamirei. ");
INSERT INTO wnu_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ne yogorau munon baraitari wonou yurau oromar Yisas qoat igour eng ai uyab mi gugum undounder ubura gab borusi yari wogub qamamir: “Sig apand mom, e Qenu wonou wau apand.” ");
INSERT INTO wnu_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ne Galili yamangar yurau wurinou ginam wogub Yisas toat nob yaremir eng wuri gor mugenderi ete naget igurei. ");
INSERT INTO wnu_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Yamangar yurau eng igour eng erobon end ger eng Makdala Maria eng ne ger eng Yems Yosep nob unor Maria eng, ne ger eng Sebedi wonou wau ombur eng wurinou unor eng ende oramar end igurei. ");
INSERT INTO wnu_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ende igamari worom nerimba ne Arimatea munon aib ger unum Yosep, wo gor Yisas wonou imbigau yurau ger. ");
INSERT INTO wnu_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Wo yar Pailat nob Yisas mumun end nob qamarei. Qamara Pailat yogorau munon wurinob qamara Yisas mumun Yosept wugumirei. ");
INSERT INTO wnu_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Wagari Yosep Yisas mumun nam erer igoar eng beneri ba ago big ba mi goan temen oannob ger ba mumun waat wogub, ");
INSERT INTO wnu_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ba bisub wonou tumun ger nomon irut barsi wager end bisub tumuni wogub nomon aib ger gingoai ba yar tumun qabar qipiot wogub isorei. ");
INSERT INTO wnu_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ende aba ne Makdala Maria eng nob Maria ger eng nob tumun qani end bugab musub gab igurei. ");
INSERT INTO wnu_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Barim eng inorou qen aib end ne Pris munon barai eng ne Parisi ende isub Pailat nob qiumuniamirei. ");
INSERT INTO wnu_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Qiumuni ne qamamir: “Barai, munon qetopur qamarau tari eng wo igom igo ete at qamar eng in misir igoun, ‘ye umb qen ombur gari ubura ne bo igomot der bugembam.’ ");
INSERT INTO wnu_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ende qamar end ne ne yogorau munon musub wurinob qamara tumun musub qoat igamari qen ombur gari ubura ne wogunor. Wonou imbigau yurau at mumun urim ba iua wabi wogub munon wurimurimar, ‘Yisas igomot der bogomai’ qomorunor qamb. Qob see qetopur qomorunor eng sig boru aib qoan qetopur qamamir wotanamimba.” ");
INSERT INTO wnu_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ende qamarari Pailat wurinob qamar: “Yogorau munon qei ibag oramar isub aninou ebet igoumon gas ende tumun mom nausi opuramar.” ");
INSERT INTO wnu_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ende qamara isub tumun mom nausi opur wogub ne qani me isar qamb biru big wogub bur tuum wuri qereimari tumun qoat igurei. ");
INSERT INTO wnu_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Inorou qen ubura wogub ne Sande itum der ai uter tubub deara Makdala Maria eng nob Maria ger eng nob tumun gub qamb iramirei. ");
INSERT INTO wnu_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ir igamari qand ai aib uya igumir e Munon aib enger ger Qenu ginamt der nomon aib tumun qabar qipiotemir eng ba aisi wogub nomon erer end bugab igoai. ");
INSERT INTO wnu_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Wonou menman eng ai qebisima gaun gas ende ne mi goan eng worom begen gas ende. ");
INSERT INTO wnu_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ende aba bur tuum tumun qoat igour eng gab borusi yari wogub umb nerer isub igurei. ");
INSERT INTO wnu_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ende abari enger der yamangar ombur eng wurinob qamar: “An me yarimar, ye an imbigoum, an munon Yisas eng erer uriamir eng gub qamb asi qib igoumon. ");
INSERT INTO wnu_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Wo e me igo. Qoan qamar gas ende igomot der bogomai. Yarab wo inab igomerei eng munai up qas gaiar. ");
INSERT INTO wnu_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Gab see qas qand isub wonou imbigau yurau eng wurinob qamarar. Wo e me igo der bogomar end wo gigit Galili end isiba. Gub qamb eng end isub igo gaiar. Ye qob e quraum eng an igub-igub isub qamarar.” ");
INSERT INTO wnu_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ende qamara igub yari ne borusi mom mismisir tumun eng qand wogub wonou imbigau yurau eng wurinob qomorub qamb imiemet isumirei. ");
INSERT INTO wnu_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Isub igamari Yisas wobon et di ibag qamar: “Oau mein big qib igoarar.” Ende qamara ombur qani goten namt isub baab wot mismisiramirei. ");
INSERT INTO wnu_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ende abari Yisas der ombur wurinob qamar: “An me yarimar, isub yonou bainori imaori wurinob qamarari isub Galili end igo yogounor.” ");
INSERT INTO wnu_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ende qamara yamangar eng isari wogub bo burtuum tumun qoat igour eng yonam ginam aib end isub Pris munon baraitari end mi gugum aba gamir end qob suari igumirei. ");
INSERT INTO wnu_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Igub Pris munon baraitari eng der munon barai qei wurinob qiumuni ne qob qamb nausi wogub nomon qur irou burtuum wurisemirei. ");
INSERT INTO wnu_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Wurisab qamamir: “An munon end ete qamarar, “munon eng wonou imbigau yurau eng itum wobon in naat inunei igama yar urim ba qurei. ");
INSERT INTO wnu_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ende qamarari gabman baraitari igub mai ansierib qamara eng in qob qei mirimot nob qumurune me an quguragsierinerei.” ");
INSERT INTO wnu_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ende qamb nomon qur burtuum wurisari ba irab wurinob qamamir gas ende ebetemirei. Abari qob toau Yuda ginam gugum isa igumir eng imusi-imusi isior eng isi yarab see. ");
INSERT INTO wnu_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Yisas wonou imbigau yurau eng Yisas wonou qob qamar gas ende Galili ai qaur end isumirei. ");
INSERT INTO wnu_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Is igamari Yisas isa gab borusi mismisir uber qamamirei. Ende abari yurau qei der Yisas ue qamb misir qebebi igub igurei. ");
INSERT INTO wnu_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ne Yisas wuri qani isub naget qamar: “Qenu wonou ginamt ne ag e ye gigi munon aib igoar qamb ye maribiga. ");
INSERT INTO wnu_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","End ye animurimoum, an munon ginam-ginam isub wuriimbigari wuri gor yonou munon yurau burunor. Ende abari Tain unumot ne wonou wau unumot ne Igomurur qau unumot wurimaragansiarar. ");
INSERT INTO wnu_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ende at ne ye qob animbigoum eng an bo imusi ende abari igunor. Eng gaiar, qen end an gari ue, ye nob igumune isi yarab qen sindomund end mom.” ");
INSERT INTO wnu_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Eng Qenu qoan munon init imurimb qamar eng se wonou wau Yisas imuriamor eng qob uber eng qemeribam eng. ");
INSERT INTO wnu_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","3","Qoan munon Aisaia Qenu qob gigit qamara gumater eng ete: Ye munon ger imurimine yonou qob ba munon yamangar wurinob qamb qiriner tap eng musiteiba. Munon eng yonou qob qemeriner eng ai qengerenget end igo ete qamb ab igoriba: Aninou ai tap musub imot igamari ne munon aib der toat isiba. ");
INSERT INTO wnu_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Qob eng gumater eng qen geret munon ger unum Yon eng ar ai qengereng end is igama munon qei gor end dearari qob qanam musub ete wurinob qamarei: “An qomon boru-boru eng mogirt wab wagar. Wogub yarari ne Qenu diban animbag aninou qomon boru eng anit wab arirama ne ye ya obotar anmaragansieribam.” ");
INSERT INTO wnu_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ende qamb igama ne Yudia munon yamangar ne wurinou munai ginam aib Yerusalem igour eng gugum qob igub munai ginam wogub Yon qob qamara igub qamb ya Yordan wes end isumirei. End isari ne Yon qob wurinob qamara ne munon qei igub ne wurinou qomon boru song-song eng Yon nob dibes qamarari ne wo ya obotar wurimaragansi igoai. ");
INSERT INTO wnu_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yon wo mi goan qumani igoar eng wai kamel qamb igour eng goan qumani ne wai goan ger ba tuen barsi uibig qumani igoai. A wo mi nub igoar eng qubusemusai qamba qapi inau ya eng gagar nubri igoai. ");
INSERT INTO wnu_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ne wurinob qamar: “Munon ger qen geret yar ye sarau oboum gas ende ebeiner eng wo sarau ebeiner eng ye yetanami wonou wes ar ebeiba. Wo munon baraitari aib, end gab ye wonou sarau botoum eng mein oboum. Ye wo goten yau maigas me nerimitinei,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ne ete gor qamar: “Ye ya asint obotaroum, munon eng qen geret yar Qenu Igomurur qau ten obotariba,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Qen end Yisas wonou ginam qenen Nasaret eng wogub ya Yordan end isa Yon ya ubeteterei. ");
INSERT INTO wnu_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ya ende obota wogub Yisas wo der naget gar eng tat miroau gas ende ebet Qenu wonou Igomurur eng dara gar eng morogan wamariau gas ende at dererei. ");
INSERT INTO wnu_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ende dara gab ebeter eng Qenu qob gor nob qamar: “Ne yonou wau sig uber ar, borusi mom neqenungoum. Nonou qomon uber eng aba gab ye net mismisir igoum,” ende wot qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ende qamara wogub ne qen end Qenu Igomurur Yisas imurima ar seger ait end isorei. ");
INSERT INTO wnu_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Is end igama igoi qen irou 40-ende ubura ne Satan warigesiarei. Yisas wo bur qaar wai wurinob ai qengereng end igama Qenu wonou enger der Yisas nonogursiamirei. ");
INSERT INTO wnu_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Qen end Herot wo Yon uyort bigorei igama ne Yisas wo is ai Galili end isub Qenu qob uber wurinob qamb qib igoai. ");
INSERT INTO wnu_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Qob wurinob qamb qamar: “Qenu wo anoar igo ne qomon animbig igoriner eng qen eng piara. An qob uber e iruges big igub, io qamb ne qomon boru eng gagar mogirt wab wogub qob aninob quraum eng misirt igub igoarar,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ne Yisas wo ya tai Galili gab-gab eng toat isi yarab Saimon umour Andru nob ibagar eng wuri yagwai ba wurisab mi taui ba igurei. ");
INSERT INTO wnu_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Qen end wuri ombur dob arir yagwai baub qamb at igamari ibag ne ombur wurit qamar: “An yar ye yetoari erogori qib igorun. Qib ne ye an yagwai ba qiumuni big igoumon gas ende ye bo animbig igimine munon yamangar gor ende wuriba qiumunimboumon.” ");
INSERT INTO wnu_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ende qamara ne ombur sarau eng ten wogub Yisas nob isumirei. ");
INSERT INTO wnu_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Erogori isub ne Sebedi wonou wau ombur ibagamirei. Wau ombur unum eng Yems Yon nob ombur dob arir qib igamari puror eng tabin erer end igo mai igurei. ");
INSERT INTO wnu_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Eng gor is ibag wurit ara dob eng ur munon qei nob wurit wogub Yisas nob isumirei. ");
INSERT INTO wnu_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Erogori end isi yarab ne ginam aib Kaperneam end weib isumirei. Isub igo ne Yuda wurinou inorou qen Sabat qamb igour eng gab ne Yisas inorou munai mor isub qob wuriimbig igoai. ");
INSERT INTO wnu_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Yisas qob qiribiten wurinob qamara igub borusi mom qietemirei. Qoan munon aib-aib Moses qomon eng toat qamarari igub igour eng wuritanami qamara igumirei. Wo qob qamara igumir eng wonou wes qob qiribiten igumirei. ");
INSERT INTO wnu_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Qob ende qamb igama ne munon ger ai warama at qib igoar eng di Yisas mor igama isub gab qugiab qamb ar: ");
INSERT INTO wnu_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Nasaret munon Yisas ne mai insierib qamb yaranei? Ne inborusierib qamb yaranei qi-i? Ye niimbigoum, ne Qenu wonou wau uber.” ");
INSERT INTO wnu_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ende qamara ne Yisas aibigau opuri igoar eng nob qamar: “Ne qobiau wogub munon eng wogub iua.” ");
INSERT INTO wnu_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ende nob qamara ne aibigau munon eng wegib qamb munon eng ba ai qenen arir atag ab wogub munon eng wogub qorei. ");
INSERT INTO wnu_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ende at qoa munon yamangar ende gab wogub borusi mom qiet ne qamamir: “Wa, meimi ende gaun? Qomon bubun ger inimbiga. Wo qer gagam eng toar, aibigau mi eng gagar gugum wuritanamima. End aibigau eng wurimar qamara igub qoour eng,” ende qamamirei. ");
INSERT INTO wnu_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Yisas mi eng ebeter eng qamarari Galili munon gugum igub ugamirei. ");
INSERT INTO wnu_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","30","Ne Yisas munai eng wogub ag der ne Yems Yon nob yar Saimon Andru nob wonou ayi eng toar aib wara git goan uyab ende at saberit inab igama ne qand Yisas nob qamamirei. ");
INSERT INTO wnu_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Qamarari ne Yisas yamangar inab igoar end isub ubent baab bemeniamorei. Ende aba ne toar eng qand waga ne mi arsitar igoai. ");
INSERT INTO wnu_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","33","Ai itumoramba ne munon ginam eng ai igaramor eng ne toar qei igara igour eng wuriba ne munon ar eng gugum diab Yisas mor igama mon qoui igurei. ");
INSERT INTO wnu_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ende naget igamari munon toar ar igab igoar eng wurimusub ne aibigau igaramor ten igour eng aibigau eng orotoar arir ne maurem wuribaab ir igoar eng miteri yedibesi qomorunor qamb wuritaisi ende at igoai. ");
INSERT INTO wnu_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ende at wogub inerei igo ai se uter tubub diara ne wonou gari qi der Qenu nob qemerib qamb ar ai end is igo nob qamb igoai. ");
INSERT INTO wnu_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ne Saimon munon qei wurinob gub qamb isumirei. ");
INSERT INTO wnu_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Is gab nob qamamir: “Munon yamangar irou nogoub qamb asi qib igour.” ");
INSERT INTO wnu_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ende qamarari ne Yisas taui wurinob qamar: “Qi worogari ende qib igorunor. Ye munon ginam qei gor qob e wuriimbigibam. Qenu ye sarau eng eb qamb yiimurima deremei,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ende qamb wogub ne Galili wes end isub munai ginam qamaaman eng gagar isub wurinou inorou munai mor isub qob wurinob qamb ne toar boru-boru eng gagar wurimusub ende at qib igoai. ");
INSERT INTO wnu_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ende at igama ne munon ger iam tumau ir igoar eng diab Yisast gamaur wat bugab ne qebi qamar: “Barai, song nonob qemeribam eng, qenunget gab eng ye yemusia uberburini qiyo?” ");
INSERT INTO wnu_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ende qamara ne Yisas gab toubet ne uben wot big ne qamar: “Ye qenungoum, ne iam wout uburiba.” ");
INSERT INTO wnu_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ende nob qamb igama ne iam qarat eng wout uburerei. ");
INSERT INTO wnu_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Ende aba imurimb qamb nob qamar: “Ye e nemusine uberetaran eng gab isub munon ar song-song me wurinob qamb qib igoar. Ne ar saranang munon Qenu wot mian iset igour eng deg end isa negeari ne mi ger ba Qenut maribiga ne wuri ba nemaragansiari bo ginamt igoriban,” ende nob qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ende nob qamar ego munon eng wo isub munon ar song-song wurinob qamb qib igoai. Ende aba ne munon gugum qob eng igub yarab Yisas taisiari ginam qei me isau. Ne munon ginam eng gagar Yisas gub qamb diamirei. ");
INSERT INTO wnu_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Qen qei ubura ne Yisas bo igeser Kaperneam ginam end diarei. Di igama ne munon qebebi igub qiumuni munai igoar eng gumat opuramirei. ");
INSERT INTO wnu_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Opur wogub igamari ne Yisas Qenu qob wurinob qamara igub igurei. ");
INSERT INTO wnu_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ende igub igamari ne munon 4-ende munon ger git gurumtar eng ba diamirei. Ba di gamir eng munon qebebi Yisas opur wogub igamari ne wuri munon eng ba Yisast isub qamb gamir eng tap ue. ");
INSERT INTO wnu_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ende gab ne mon erer qitet irab irunguni omboneri wogub saberi uyort tesi wogub saberi ten beari-beari Yisas qani end isorei. ");
INSERT INTO wnu_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Isa ne Yisas munon eng wot mom imbig abari ibag ne munon goten gurumtar eng nob qamar: “Ne qomon boru ebet igoan end ye namat me qemerinei, ye nemusieribam.” ");
INSERT INTO wnu_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Qamara munon qomon imbig igoar eng qei igo qob engu igub misirt qas ete qamamir: ");
INSERT INTO wnu_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Meimet qamb munon eng Qenut ber qob ende at wot qura? Munon ar ger munon qomon boru ebet igo eng musia maigas me uber burinerei. Qenu wonou gari qas mi eng gagar ebeiner eng qeemben.” ");
INSERT INTO wnu_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ende qamb abari wogub Yisas wuriimbig ne wurinob qamar: “Ye qob maigas qemerine igub ye merimesab igoumon. ");
INSERT INTO wnu_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Mai qiyo, ye munon qomon boru ebet igoa eng musine uber buriner eng an maigas me imbigunanei. End ne munon git gurumtar eng nob qemerine uberburiner eng an magqurt gab ne imbiguboumon.” Ende qamb wogub qamar: ");
INSERT INTO wnu_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","“Ye Munangit wau ag e qib igoum, ego munon qomon boru ebet igour eng ye wurimusiau eng ye ar ebeibam. End ne an imbigar qamb munon gurumtar e musieribam.” Ende qamb wogub ne munon toar nob eng nob qamar: ");
INSERT INTO wnu_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Der bugab naget gar ba mor umo is,” ende qamara wogub ne wo der naget gar ba isorei. ");
INSERT INTO wnu_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ba isub igama munon yurau gugum gab qiet ne Qenu wot mismisiramirei. Mismisir ne qamamir: “Wa, tonoan mi ger qoan ende aba me gab igamarau, mi e wonou wes ar,” ende qamamirei. ");
INSERT INTO wnu_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ende at wogub munai ginam eng wogub ne Yisas bo Galili ya tai end isorei. Ende is qib igamari ne munon yurau aib bo end yarari wurinob qamb ne mi qei-qei wurisirbig igoai. ");
INSERT INTO wnu_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Wuri gugum isub qamb qataben yarab Yisas gar ego munon ger wonou sarau munai mor end igama garei. Munon eng Alpius wonou wau unum Libai. Wonou sarau eng gabmant nomon qur baub qiumuni big igoai. Yisas munon eng gab nob qamar: “Yetaut yar” ende nob qamara ne Libai nob isib qamb misir igub ne mi aib qamb at norei. ");
INSERT INTO wnu_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Yisas wonou munon yurau wurinob, ne Libai wonou erogori sarau baab igour eng ne munon qomon me taut igour eng wurinob bugab mi numirei. ");
INSERT INTO wnu_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ende bugab mi nub igamari ne Parisi qomon imbigau munon eng ende gab der Yisas wonou imbigau yurau wurinob qamamir: “Meimet qamb munon boru-boru eng wuri nob bugab mi nub igo?” ");
INSERT INTO wnu_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ende qamarari wogub Yisas wonou igub ne taui qamar: “Munon ger toar wara gab eng munon ger yemusi qamb simot ea ne munon eng is mi sumi wotet arir igo. A munon uber eng munon ger yemusi qamb simot me eab igo. Ende gas ende ye gor munon qomon boru ebet igour eng ye wurimusierib qamb deremei. Munon uber ar igo eng ye bo meimet gab sabar me musierinei,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ende qamb wogub igama igoi qen geret munon yurau Yon wonou yurau nob, Parisi wurinou eng nob mani gitab igurei. Ende at igamari munon qei ibag ne Yisast yarab qamamir: “Munon yurau ombur eng wuri mani gitab igour, ego nonou munon yurau ende me ebet igour eng meimet qamb?” ");
INSERT INTO wnu_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ende qamarari ne Yisas wurinob qamar: “Ininou qomon maigas igo? Munon ger irub baib qamb ne wonou ur unor nob wonou munon banam end qob wurit biga isub qiumuni mi nub qamb mai gitab igour qiyo? Ende ue, wuri munon irub bainer eng nob igo ne mani soro ar nub igour. ");
INSERT INTO wnu_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ende igo end ne ye ete aninob qemerine igar: Qen geret munon qei munon irub bainer eng qoa ne qen end wuri mani bo gitab igorubour.” ");
INSERT INTO wnu_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ende qamb ne ger ete qamarei: “Munon ger mingoan qoan ger qubura gab eng bo mingoan tau temen ger me gigibiotrau eng ba big maiminer eng mingoan tau temen eng bo gigibiot qoan eng ubumima imusi quburab isiba.” Ende qamb ne ete gor qamar: ");
INSERT INTO wnu_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","“Ininou qomon maigas igo? Munon ger wain qur baub ya bea isub uter bur qamb wai goan end bea isub igo. Mai qiyo, munon eng wain ya temen eng ba wai goan qoan end wariminer eng igoi qen geret uter burab iriget weib yariba. Ende ebet wonou wain ya isi isub uburiba. Wai goan gor mom boru buriba. End ne wain ya temen ba wai goan tement wonou uninim warimun eng qen geret uter burab eng me iriget yarinerei,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Qen geret inorou qen end Yisas wonou wuriimbigau munon yurau eng nob wit man ger end is qobot qib igo ne wonou yurau eng der wit git ba ninirmari anir qoa git nub igurei. Ende nub qib igamari Parisi munon qei der ibag wuri sarau baab igour ende qamb misiringet ne Yisas qamat qamamir: ");
INSERT INTO wnu_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","“Qoan Qenu qomon indarer eng inorou qen end in gitab igoun eng nonou munon yurau meimet qamb me gitorour?” ");
INSERT INTO wnu_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ende qamarari ne Yisas der qamar: “Qob ger qoan Debit wonou munon yurau eng nob mi niau ue gab mi numir eng qob eng an wanunger gab igoumon qiyo? ");
INSERT INTO wnu_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Qoan mani parau Qenut qamb mor big igour eng munon ar song-song me nub igamau, munon yurau Qenu munai qoat igour eng gari nub igurei. Qen end munon unum Abiatar eng wo baraitari igo munon Qenu munai qoat igour eng oroar igoai. Qen end Debit wo Qenu munai mor isub mani parau eng ba nub wonou munon yurau eng wurisa numir eng an me igub igoumon a? Debit ende tonoan wurinou qomon nugutumuget igama Qenu apand siara me umau,” ende wurinob qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ne qob eng qamar eng qanam dibesi qamar: “Qenu munon barsi ne wo umiom qamb inorou qen bigorei, ar ai qorut me bigau.” ");
INSERT INTO wnu_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ende qamb ne wonomit qamar: “Munangit wau wo igo end ne inorou qen eng igo. End ne ye yonou yurau qemerine wuri inorou qent song wit qur ba niour,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yisas qob eng ende qamb wogub bo igeser inorou munai mor eng isorei. Munai mor end munon ger uben amamirer eng end igoai. ");
INSERT INTO wnu_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Yisas end isa gab ne munon qei Yisas qomon ger songi inorou qent munon ger musia gun qamb mom maganasi gab igurei. ");
INSERT INTO wnu_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Gab igamari ne Yisas erer qitet irab naget munon uben amamirer eng nob qamar: “Menmant erer et die.” ");
INSERT INTO wnu_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ende qamara ne munon eng ir naga ne Yisas munon yurau eng wurinob qamar: “Ininou qomon eng inorou qen eng maigas at igoun, yonou bain qiyo munon banam inorou qent borubura gab mai, magqurt gab woguboun qiyo, musioruboun?” Ende qamara ne wuri qinining wogub qob ger taui nob me qamarau. ");
INSERT INTO wnu_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Wo ende wurinob qamb misiringet ibag bisi yarab ne wuri munangit ger me wuritoubar igour eng ibag qomon eng uber ue eng gab bo wuritoubarerei. Ne bo munon uben amamirer eng nob qamar: “Uben degesi arir ge,” ende qamara munon eng uben degesi arirama uben bo uber burerei. ");
INSERT INTO wnu_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Munon inorou qen gitab igour eng unum Parisi wuri Yisas ende aba gab ne inorou munai mor eng wogub qand der iua Herot wonou yurau eng ibag wurinob qamb erogori qob qamb imbig Yisas waramb qamb ebetemirei. ");
INSERT INTO wnu_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ende abari ne Yisas wonou munon yurau wuriimbig qib igoar eng wurinob bo Galili ya tai end isumirei. Isari munon yurau aib taut isumirei. Munon yurau eng yaremir eng ai Galili ");
INSERT INTO wnu_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ne ginam aib Yerusalem, ne ai Yudia ginam qamaaman igour eng, ne ai Idumea ne, ig munon ginam-ginam ya Yordan wes eng ne munon yurau itet wes igour eng ginam ombur eng Tair Saidon nob eng gor deremirei. Munon ginam eng gagar yaremir eng Yisas qomon eng aba qob toau isa igub bo gub qamb yaremirei. ");
INSERT INTO wnu_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Munon yurau sig irou yar Yisas mom opurmbour eng gab wonou munon yurau wurinob qib igoar eng wurinob qamara tabin ger arsi igamari erer end irab mugenderi igo qob wuriimbigib qamb qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Eng qen gigit ende munon irou wurimusub igama ne qei wurinou uyes yar baab uberet qiyo ende at opurmari ibagar end bo ende yesiorunor qamb bo sarog ende igo qob wurinob qemerib qamb qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ne munon qei ai igaramb aba umb nerer isub igour eng ten diab Yisas gab menmant wes end isub sauget amir: “Ne Qenu wonou wau.” ");
INSERT INTO wnu_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ende qamb arari Yisas der aibigau eng munon eng wurit igoar eng at munon qei wurinob qomorunor qamb wuritaisiarei. ");
INSERT INTO wnu_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ende at wogub wonou munon qei wurimaribigib qamb ai qaur end irarei. ");
INSERT INTO wnu_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","End irab wurit qamara yarari wurimaribigor eng 12-ende. Munon yurau eng wurimaribigor eng wurinob qamar: “An anmaribigoum eng yonou yonob qib igoarar qamb, ne gor ye animurimine munon ginam-ginam iua yonou qob wuriimbig ne munon qei ai igaramb igo eng ne qerismindou wuriboopur igo wurisi igo eng, ye annonogursierine an qiribiten igo ne mi eng gagar worotoar arir igoruboumon,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Munon 12-ende wurimaribigor eng unum eng ete: Saimon, ne Yems, ne Yon, Andru, Pilip, Bartolomyu, Matyu, Tomas, Yems, Tadius, Saimon, ne Yudas. Ne Saimon unum ger bigor eng Pita. ");
INSERT INTO wnu_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Ne Yems umour Yon nob wurinou ur Sebedi. Yisas munon ombur eng unum bigor eng Boanerges. Qanam eng ete: ai aib qamb toaima gas ende. ");
INSERT INTO wnu_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ne Yems ger Alpius wonou wau eng, ne Saimon ger munon yurau qei wurinob Rom gabman sarau wagar qamb ebet igoar eng, ");
INSERT INTO wnu_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ne Yudas Iskariot qamb igour eng, wo qen geret Yisas munon qarau wurit duima waramunor eng ende wurimaribigorei. ");
INSERT INTO wnu_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yisas munon eng ende wurimaribig wogub ne mor isorei. Mor isari ne munon yurau aib bo mor end diab ibagamirei. Ende abari ne Yisas wonou munon yurau wurimaribigor eng nob munon yurau aib ende wurit qumundigir wuri mani ger me niau. ");
INSERT INTO wnu_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ende at igamari ne Yisas unor umuragrari big Yisas eng at qib mom qangangetra ende qamb qamarari igub mot isub qamb irubet igurei. ");
INSERT INTO wnu_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ne Yerusalem munon baraitari qomon qoat igour eng yarab Yisast qamamir: “Ai bigau baraitari aib eng unum Belsebul wo opuri igo end wo nonogursia munon ai igaramb igo eng worotoar arir wurimusub at qib igo eng.” Ende at wot qamarari ");
INSERT INTO wnu_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yisas der mit big wurinob qamar: “Satan wonou yurau maigas der wonou yurau bo worotoar ariramba?” ");
INSERT INTO wnu_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ne gor qamar: “Munon yurau erogori der purab tau der tau nob yogorunor eng bo sabar qiribiten me igorunorei. ");
INSERT INTO wnu_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ne gor munon banam tau-tau der wurinou bo yogorunor eng gor ende sig. ");
INSERT INTO wnu_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ne Satan wonou yurau erogori der purab tau der tau bo sabar qiribiten me igorunorei, mom mein burab wogubour. End ne ye Satan wonou yurau worotoar ariramoum eng gab meimet qamb munon eng yenonogursia at igoum qamb yet qamb igoumon?” ");
INSERT INTO wnu_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ende qamb ne ete gor qamarei: “Munon uter ger wonou munai mor end igama ne munon ger wonou munai mor isub mind me deminerei. Gigit munon eng baab uyort touri wogub ne is mind demba,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ende qamb ne qamar: “An eng igar, munon yamangar qomon boru ebet ne Qenu wot qob isi qamb igour eng bo qomon boru eng mogirt wab waga wo ba qubeimba. ");
INSERT INTO wnu_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","A munon ger Qenu wonou Igomurur end wot qob isi qamb a mindigar qob qemeriner eng Qenu munon eng bo me wot iginerei, mom ba agi wegiba. Misir boru eng wonou ten ende waga qenen igoriba,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yisas qob eng qamar eng munon qei der: “Wo, mai, qerismindou opurima igo ebet igo,” ende qamarari ne wo der qob eng qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","32","Yisas end igama ne unor umuragrari big diamirei. Diab ag eirot naget igamari ne munon yurau aib Yisas qoui bugab opur igamari ne wot qob bigari ne qei der Yisas nob qamamir: “Nanib diab ag eiro igo nenet der qamb qamb igour.” ");
INSERT INTO wnu_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ende qamarari ne Yisas der qamar: “Ye nani qamb imaori qamb eng your?” ");
INSERT INTO wnu_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ende qamb ne igeser asi munon yurau aib wo qoui bugab igour eng wurit qamar: “An e gagar ibagaiar, munon e bugab ye qob qemerine igub igour eng yonou ima yonou imemi ne yonou nanib gas ende. ");
INSERT INTO wnu_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Munon qiyo yamangar ger Qenu qob igub toat ebeiner eng wuri yonou ima, a yonou imemi ne yonou nani gas ende.” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","2","Yisas qob eng mom ende qamb ugab ne bo ya tai Galili end is qanam big munon qob wurinob qamb igama munon yurau sig irou yar wo mom opurmari ne wo bo tabint is mugenderi ende igoai. Igama ne munon yurau eng ya gabut end igamari wo qob mit big wurinob qamb igoai. Ende wurinob qamb isi yarab ne qob ger wurinob qamar: ");
INSERT INTO wnu_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Munon ger wit qur bis wonou man end bunumban ariramb qamb isorei. ");
INSERT INTO wnu_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Bis arirama ne wit qur qei munon tap qenen qib igourt end is diban igamari ne morogan der nubriamirei. ");
INSERT INTO wnu_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ne qei ai nomon qer diban end is igo qaur diamir eng ai gor gurum ue end diab qaratariamirei. ");
INSERT INTO wnu_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Qaratari igamari worom asi ibegea durun um me isau end gegeretriamirei. ");
INSERT INTO wnu_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ne qei is misugan asin qurnob igo morogot diamir eng misugan wuriiribiga musub me isari git abau. ");
INSERT INTO wnu_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ne qur qei arirama is ai uberet dereriamor eng mom musub diab ne git baab ne aritamirei. Aritamir eng git qei 30-ende ne qei 60 qei bo 100-ende.” ");
INSERT INTO wnu_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ende qamb wogub ne qamar: “An iruges nob qob quraum eng mom musub igar,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ende qamara wogub ne munon yurau aib qoari ne munon 12-eng nob munon ar qei nob igo ne Yisas mit big qamar eng bo dibesi qamara igun qamb qebiamirei. ");
INSERT INTO wnu_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ende qebi qamarari Yisas taui qamar: “Qenu qoan wonou bibis biginer end qob qi igoar eng qo animbiga gaumon eng. A munon yurau ar song-song wuri mit big qob qas qemerine igubour. ");
INSERT INTO wnu_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Eng mit big qemerin eng munon Aisaia qoan Qenu qob qamara gumater eng gas ende gari: wuri git igub asiomunor eng mi git ger me gunorei. Ne gor qob igunor eng qanam sir me imbigunorei. Ende ebet wuri Qenu bibis bigib qamar end me wot oabigari Qenu wonou wurisiara qomon boru ten igour.” ");
INSERT INTO wnu_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Qamb qamar: “An mit big quraum eng me imbigoumon ne? Ende at ye mit big irou qamb igoum eng maigas imbiguboumon? ");
INSERT INTO wnu_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Munon wit qur ariramor eng Qenu wonou qob eng. ");
INSERT INTO wnu_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Wit qur qei is ai tap qenent igo eng munon qob igari ne bo Satan wurit isub qob eng ba ousia ne siningot wogub igour eng. ");
INSERT INTO wnu_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ne wit qur qei ai nomon qer diban end isub qaur di igo eng, munon qob igub qand ba misirt big mismisir igour. ");
INSERT INTO wnu_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Qaur ende di durun der ai baab isiner eng ue end gegereteriba. Ende gas ende munon qob igub misirt igub igoriner eng bo munon qei Qenu qob me wuritrab igoriner eng yar qob qei nob qamarari igub wo bo qand qob siningot wegiba. ");
INSERT INTO wnu_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Ne munon qei misir, wit qur is misugan asin qur nob igo morogot qaur di igo gas ende eng munon qob igub misirt igoriner eng, mai, wonou see igoriner end sig misir igub a mi qebebi baib qamb igub ebet igo eng wit qaur dia ne mi irbiga git ubersi me arit igo gas ende. ");
INSERT INTO wnu_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","A munon Qenu qob igub misirt big taut igour eng wit qur qei is ai uberet der qaur di git baret ne arit igo gas ende. Git eng qei 30 ne qei 60 ne bo qei 100-ende.” ");
INSERT INTO wnu_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yisas qob eng mom imusi qamb isub igo ne qamar: “Munon qei ai itum gab abari munon ger urut uruguni begesitarib qamb mai uruguni ba di wabi igoriba qiyo? Ue, ende me ebinerei, wo munon gugum begen gab diarar qamb ai deberit naget bemenimba.” ");
INSERT INTO wnu_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ende qamb ne qamar: “Munon qomon uber qiyo boru ebetri igour eng gagar see waber igour eng qen geret mi eng gagar dibenterimbour. Ne qob gor waber igour eng see me imbigoumon eng gor dibentra guboumon.” ");
INSERT INTO wnu_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ende qamb ne qamar: “An iruges nob qob quraum eng mom musub igar,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ne bo wurinob qamar: “Qob aninob qemerine igoumon eng mom igub igoarar. An qob igub qei siningot wogunon eng Qenu animbag ne taui ende ansieriba. An qob musub igub taut igorunon eng gor taui ne bo ui ar tauimba. ");
INSERT INTO wnu_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Munon ger Qenu qob igub taut qoyamet igo eng wonou misir bubun imusia mi qenen imbig igoriba, a munon qob eng siningot wogub me qoyameterin qamb gab ieriner eng misir qoan eng Qenu wonou aba mom nasi wegiba,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yisas mit big qamar eng mom imusi qamb igoai. Ne bo ger qamar: “Qenu wonou bibis eng ete gas: Munon ger mi qur ger bis wonou man end bunumban ariramorei. ");
INSERT INTO wnu_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","28","Arir wogub wo di inab ne woromt ar qib ende at igoai. Ende at qib igama igoi nam qur wonou qaur di aib burab isari ende at igoar eng qanam eng sir ue. ");
INSERT INTO wnu_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ai man goan uber end ariramor end uber di isari ne git qarib yar ebeter eng igoi mom arira gab ne isub baurei,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yisas bo wuri qebi qamar: “Qenu wonou bibis biginer eng in meimit big qomorune is qeemben buriba?” ");
INSERT INTO wnu_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ende qamb ne wo nam qur ger ‘mastet’ qamb igour ende big qamar: “Nam qur eng sig qamaaman, nam qur gugum ibag igoun eng wuritanamima, wo sig qamagast. Nam qur eng munon ger ba goaneterei. ");
INSERT INTO wnu_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Goaneterei igama qaur diab ir aib burer eng nam gugum wuritanamima. Qoag war eng uben aib-aib, ende aba ne morogoan wuri eng gab qenen yar end bugab ne mon ubet ne inau neri igour,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","34","Yisas mit big qamar eng wonou misirt ger me qamarau. Munon misir igoar eng taut ne mit big end qas wurinob qamb qib igoai, dibes ger me wurinob qamarau. Wonou munon yurau wuriimbig qib igoar eng mit big qamb eng qanam qi wuriimbig wurinob qib igoai. ");
INSERT INTO wnu_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","36","Eng ende dibes wurinob qamb wogub worom nerima ne bo wurinob qamar: “Wagari ya tai e purab ig iro isun,” ende wurinob qamb wogub munon yurau qei eng end wuriwogub tabin ger Yisas is igoar end wonou wuriimbig qib igoar eng wurinob isumirei. Isari ne tabin qei gor wurinob isub igurei. ");
INSERT INTO wnu_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ende isub igamari ne moon sig aib diab ya orogot mor arir ne tabin ba biigisimb qamb ebeterei. ");
INSERT INTO wnu_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Qen end Yisas wo tabin sui umot naat inerei igama ne wonou yurau eng is meni qamamir: “Ei, moon aib di tabin biigisimb ebet igo e, meimet qamb mom naat inan? Init misir me igan?” ");
INSERT INTO wnu_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ende qamarari Yisas der bugab moon aib eng omboopur qamar: “Qi wog”, ende qamara ne moon wogub ya orogot mor arir igoar eng gor wagerei. ");
INSERT INTO wnu_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ende at wogub munon eng wurinob qamar: “An meimet qamb yarimoumon? An ye mom yiimbigoumon quraum eng bo sabar yari igoumon?” ");
INSERT INTO wnu_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ende wurinob qamara ne wuri der moon aib di ya bures arir ende at igoar eng taisi qamara waga gab borusi qesi igara wurinou qob-qob qamamir: “Munon eng maigas igo sani-sani di ya bures arir igemerei eng taisia waga a?” ende qamamirei. ");
INSERT INTO wnu_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Sani-sani aib di ya bures arir igoar eng ende taisia waga ne bo Galili ya tai eng purab bo Gerasa wurinou ai end isumirei. ");
INSERT INTO wnu_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","End isub qamb ne tabin ya tai end wogub daan irab gamir eng munon ger ai bigau misir ba songesia qenen munon teteret end igoar eng Yisas end iroa gab dererei. ");
INSERT INTO wnu_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Munon eng ai bigau ba songesia ne qer gagam boru, munon ger maigas pi is me baab bunomt touri igamau. ");
INSERT INTO wnu_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Qen qei-qei baab touri igour eng wo qenen bunom eng ombopur ne ain quran aib-aib eng gor ar nogotoat igoai. Ende aba ne munon ger pi isub me baab igamau. ");
INSERT INTO wnu_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Itum woromt eng wo qenen munon teteret ai qaur end qas igo ne nomon ba wonomi waramb aimot ab eab ende at igoai. ");
INSERT INTO wnu_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Qenen ende at igama ne qen end Yisas end is igama ne munon eng wo mugen asi gab ne uyab-uyab Yisas menmant wes end yar gamaur wat bugab ne aimot simot eab qamar: ");
INSERT INTO wnu_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","“Yisas ne Qenu mi gugum wuritanamimar eng wonou wau eng ne. End ne ye mai yesieriban? Ye Qenu unumot net quraum, ne ye me yesumungasi,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Munon eng qamar eng Yisas wo ai bigau misir ba songesiamir eng wurit qamar: “An munon e wogub der iuar,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Qamara ne Yisas wo der munon eng nob qamar: “Ne unum your?” Ende qamara ne munon eng der qamar: “Ai bigau irou yoopuri igour end ne ye unum eng Ami.” ");
INSERT INTO wnu_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ende qamara ne ai bigau munon end miteri qamb igour eng Yisast simot ab qamamir: “Ininou toar arirama munon e wogub ar ai qorut et me isunei. ");
INSERT INTO wnu_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","12","Ne inimurima in bur yurau aib ger iro igour end wurit isun eng uber qiyo,” ende qamarari ne ");
INSERT INTO wnu_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yisas “Io” qamb ne ai bigau eng wuriimurima bur yurau aib eng wurit isari ne bur qanganget iua ai yaru aib eng der isi ya tumun aib erobon isub ya nub umb uburemirei. Buru yurau aib eng gugum 2,000-ende. ");
INSERT INTO wnu_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Bur eng ende yag isub ya nub umb uburari ne munon bur oroar igour eng ende gab ne iua is munon ginam aibt igour eng ne ginam qei qani-qani eng wurinob qamarari mi eng ebeter eng gub qamb yaremirei. ");
INSERT INTO wnu_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Yarab munon qoan qanganget ab toaubig igama igub igour eng di gamir eng bo misir igub mingoan qumani wogub qi Yisas nob igama di gamirei. Gab borusi mom yariamirei. ");
INSERT INTO wnu_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ne munon qei Yisas mi eng aba gamir eng qei wurinob qamarari imbigumirei. ");
INSERT INTO wnu_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Imbig ne der Yisas inwogub iua qamb qebiamirei. ");
INSERT INTO wnu_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ende qebi qamarari ne wo qoaib qamb tabint isa ne munon musuor eng nob isib qamb qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Qamara Yisas nob qamar: “Me yenob isinenei, ne nonou ginamt isub munon aib netoubet nemusia git uput yaran eng gab bainori tainmagrori wurinob qamara igunor,” ende qamb wogub isumirei. ");
INSERT INTO wnu_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ne munon eng der wonou ginamt me iroau, wo der munai ginam 10-end isub Yisas musuor end wurinob qamara igub qiet mismisiramirei. ");
INSERT INTO wnu_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yisas munon eng ende musub wogub bo sarau qei ebeib ater eng imurimari wogub bo tabint isub yonam di ig isorei. Isari munon yurau aib bo end qiumuniamirei. ");
INSERT INTO wnu_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","23","Ende qiumuni igamari ne munon baraitari ger unum Yairus. Yairus wo inorou munai qoat igoai. Wo diab Yisas gab menmant end wonomi ariramau gas ende at inab simot eab qamar: “Yonou yamangar wau sig mom mumun gab diab quraum. Barai, mai yarab uben benerimata toar mai diereminer qamb ar quraum.” ");
INSERT INTO wnu_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ende qamara Yisas nob isorei. Isa munon yurau aib nob isub wo mom opur wagomirei. ");
INSERT INTO wnu_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ne qataben isub igo yamangar ger qenen amug isub qib igama togun 12-ende warei. ");
INSERT INTO wnu_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ende igama ne toar munon wuri musub igour eng qei der amug isub igoar eng boopur weginer qamb qenen musub igurei. Toar puriani eng ende nub uter gab qiyo munon qei ar musiari end nomon qur taui wurisab ende ebet borusi qumundigir quguraget wegib qamb misir igor eng wonou git goan end misir igub qigimiet at qib igoai. Ende at qib igoar eng amug isub igoar eng me boopur wagau, wonou ar ten ende igoai. ");
INSERT INTO wnu_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","29","Qenen ende at qib outet igoar end Yisas mi eng gagar at qib igoar eng qob toau igub diab ete misir igor: “Ye mingoan gabut end qas bine toar eng weginer.” Ende qamb ne munon yurau aib wuribar isub Yisas mingoan gabut end baab gar eng amug isub igoar eng boopur wagerei. ");
INSERT INTO wnu_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yamangar eng mingoant bea ne Yisas wo qiribiten sarau baab igoar eng bo meinet bibinat igub ne igeser munon yurau aib eng wurinob qamar: “Your ye mingoan qotarai?” ");
INSERT INTO wnu_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ende qamara ne wonou munon yurau wuriimbig qib igoar eng der nob qamamir: “Maia, nonou gari et qib igo qobia? Munon yurau aib noopur igo noatrour, meimet qamb your yoatra qamb igoan?” ");
INSERT INTO wnu_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ende qamarari ne Yisas me wagau, munon qotar eng mom gab wegib qamb asi qib igoai. ");
INSERT INTO wnu_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ende at qib igama ne yamangar eng qesi wara wogub diab Yisas menmant end gamaur wat bugab ne wo mi ebeter eng gugum Yisast mom dibes qamb ugarei. ");
INSERT INTO wnu_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ende qamara Yisas igub wogub ne yamangar eng nob qamar: “Ne yet oau apand burab yebea toar ne wagar eng gab ne isub oau uberet qib igoar,” ende nob qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yisas yamangar eng nob ende qamb igama ne munon qei Yairus nob igour eng diab nob qamamir: “Ne wau qoan umai, meimet qamb bo sabar imbigau munon mot isib qamb at igoan?” ");
INSERT INTO wnu_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ende qamarari ne Yisas wuri qob qamamir eng me igau. Wo der Yairus nob qamar: “Nonou wau umar end sig me toubei, oau gari apand burab igoar,” ende nob qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ende qamb wogub nob isib qamb ne munon qebebi me oromar isau. Pita Yems ne Yems wonou umour Yon ende gari oromar nob isumirei. ");
INSERT INTO wnu_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Isi yarab Yairus wonou munait end is igumir e munon yamangar eab toau big igurei. ");
INSERT INTO wnu_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ende at igamari ne Yisas mor isub wurinob qamar: “Meimet qamb toau big yeiser igoumon? Wau e segagam me umau, ar naat inai igo.” ");
INSERT INTO wnu_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ende qamara wogub ne munon eng gagar der borusi tai-tai igerig igurei. Ende abari ne wo der munon gugum wuriimurima ag isub uburari ne wau umor wonou ur unor ne wonou imbigau munon omburgari ende oromar mon tumbigi end isumirei. ");
INSERT INTO wnu_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Isub ne Yisas wau umor uben end baab ne qamar: “Talita Kum” Qob eng qanam eng ete: yamangar wau nemeni igoum. Der bugom.” ");
INSERT INTO wnu_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ende qamara ne wau eng qand der bugab naget-naget isorei. Yamangar wau eng togun 12-ende. Isa gab qiet ne qesi igara gab igurei. ");
INSERT INTO wnu_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ende aba ne Yisas der qoronob wuritaisi qamar: “An ye mi e oboum eng an qob ar-ar me qamb qib igoarar.” Ende qamb ne yamangar wau end qamar: “Mi utari niner,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yisas bo ginam eng wogub wonou munon yurau wuriimbig qib igo eng wurinob bo wonou ginam qenen Nasaret end isumirei. ");
INSERT INTO wnu_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Is end igo ne inorou qent inorou munai mor isub qob wuriimbig igoai. Qob qamara igub munon irou qiet ne qamamir: “Munon eng qoyam eret baurei? ne qob eng eret baub qamb igo a? Wonomi wes-wes aba diar eng gor your sirbigorei?” ende qamb qanganget igurei. ");
INSERT INTO wnu_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ne ete gor qamamir: “Munon eng mon mindau qiyo mi qei-qei eng barsia gab igoun. Ne gor Maria wonou wau maigas mi eng gagar ebet igo? Umuragrari Yems Yosep qamb, Yudas ne Saimon qamb ne umemragar qamb eng gagar in e wurinob igoun. Meimet qamb yonou mi wes eng oboum qamb ebet qib igo?” ende qamb wot merimotemirei. ");
INSERT INTO wnu_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ende qamb abari menman ibag ne wurinob qamar: “Eng segagam, Qenu qob qamarau munon wonou ginam qenen end der qob wurinob qamb mi abar qamb qemeriner eng qob ombarirambour, a ginam taut end is mi eng gagar ebeiner eng munon qob igotoubour.” ");
INSERT INTO wnu_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ende qamb ne mi bubun ger bo ginam qenen end me abau, toar munon gari-gari wurimusiarei. ");
INSERT INTO wnu_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Wo wonou ginam qenent eng wot me igub qomon eng abari gab iet wogub bo iua ginam qani-qani eng gagar qob wuriimbig qib igoai. ");
INSERT INTO wnu_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","8","Ende at qib wogub ne wonou wuriimbig qib igo munon yurau eng wuriba qiumuni wogub wuriimurima ombur-ombur sig munon ginam-ginam qoamirei. Wuriimurimb qamb ete wurinob qamar: “An munon ginam-ginam isari ye annonogursi igimine ai munon igaramor eng qerismindou munon wuribopuri igo eng gagar qiribiten wurimusiari uberburubour,” ende qamb ne bo qamar: “An isub qamb mind ger me baiar, a mi niau ger me baiar, ne norogum abau qiyo nomon qur ger ue ar qib igoarar. Aninou tugotau eng gari qas ba maut-maut qib igoarar. ");
INSERT INTO wnu_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Goten yau eng nagar, ne mingoan bubun ger bo me baiar.” ");
INSERT INTO wnu_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ende wurinob qamb ne qamar: “An ginam aib geret weib isari munon ger anamar mor isa gab eng mor end qas igo wogub bo der tumbigi isar. ");
INSERT INTO wnu_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Isi yarab ginam isunon eng me animbag qiyo qob qamarari me igub abari gab eng an bo ginam end me gugurt me abar. Ar wurimerimotar wogub irumban nogounon eng bai arir wogub saranang isar. Ende abari ne wurinou ansiorunor end misir igubour,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ne wuriimurima ginam-ginam isub wurinob qamamir: “An qomon boru-boru ebet igoumon eng gagar see aninob quraun end qinining ne mom wagar,” ");
INSERT INTO wnu_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ende qamb ne munon qei toar boru-boru igab ne ai igaramor eng gagar wurimusub ende at qib igurei. ");
INSERT INTO wnu_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ende at qib igamari igoi ne Yuda munon baraitari aib unum Herot wo igor eng Yisas unum mom aibt munon ginam-ginam isorei. Ne munon qei der qamamir: “Wa, Yon munon ya obotar qib igoar eng bo igomot der wonou sarau baab qib igoar eng bo aba eng.” ");
INSERT INTO wnu_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ne qei der qamamir: “Mi eng mai gas ende e? Ue, Elaiya wo qoan Qenu qob qamara gumat igoar munon eng qi-i,” ne qei: “Ue, wo Qenu qob qamarau munon ger. Qoan tonoanb munon Qenu qob gigit qamb qib igour gas ende.” Qanganget ende at qambri igurei. ");
INSERT INTO wnu_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ne Herot der qamar: “Ue, Yon munon ya obotar qib igama ye quman sopuram eng gari bo igomot der at qib igo eng,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","20","Eng qoan Herot wo umour Pilip wonou ubeni unum Herodias wo bo baia ne, Yon der qamar: “Nonou ima irub wot baian eng uber ue.” Ende qamara ne Herodias wo Yont borusi mom misiringet wogub mom waramine uminer qamb ebeter ego Herot wo munon qei wuriimurima is Yon baab uyort bigumirei. Yon uyort igama Herot wo Yon munon uber ne munon qau eng gab wot yari ne musub qoat igoai. Qen qei Herot wo Yon qob qamara wo misir qebebi igub ebeter ego wo Yon gor qenunget igoar end bo qamara qenunget igub igoai. ");
INSERT INTO wnu_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","22","Ne qen geret Herot unor baur qen eng gab mi aib qamb at munon baraitari wo nob sarau baab igour eng ne yogorau munon oroar igo eng ne Galili munon baraitari eng mi wurinob nub igama Herodias wonou waibo diab mor isub ur uyab igoai. Ende uyab igama ne munon baraitari Herot nob bugab mi nub igour eng gab qenungetemirei. Qenunget ne Herot der yamangar yorou eng nob qamar: “Ne meimi baib qamb qenungan? Mi ger baib qamb eng qamara neteibam,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ne Herot qob apand mom nob ete qamar: “Ye mi ger yeisi qamb qamara eng neteini, a yonou munon ginam oroar igoum eng ne gor oroar igorib qamara eng gor net qereimine net isunor,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ende nob qamara igub wogub ne yamangar yorou eng ag isub unor Herodias nob qamar: “Eng yonob qurar eng ye meimi yeisi qamb nob qemeribam?” Ne unor der qamar: “Yon ya obotar igo eng waramb tari soopur yesirbiga gini ende nob qem.” ");
INSERT INTO wnu_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ende qamara ne waibo bo qand Herot isub nob qamar: “See qas Yon waramb quman soopur tari ba di yeisar.” ");
INSERT INTO wnu_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ende qamara ne Herot borumisir igub oau quguraget toubet igoai. Ende ebet wegini qamb ebeter eng gigit qebi qamara: “apand ende ebeibam,” qamb munon baraitari bugab mi nub igour eng gugum igumir end yari ne yamangar qob eng taut ebeterei. ");
INSERT INTO wnu_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","28","Ne yogorau munon eng gari qas imurima isub Yon uyort igoar eng mor isub waramb quman soopur ne tari ba di yamangar yorou eng uta unor sirbiga garei. ");
INSERT INTO wnu_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ende abari ne Yon wonou yurau wuriimbig qib igoar eng ende igub yarab tau ba tumuniamirei. Ende tumuni wogub igamari igoi qen geret Yisas wo bo Yon sarau baab igoa gas ende ebet qib igama ne Herot wo qob igub ete misir igorei: “Wa, Yon bo igomot der bugab wonou sarau qoan eng at qib igo qii,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ne Yisas munon yurau eng munon ginam-ginam isub, qob wuriimbig ne munon qei wurimusub ende at qibi wogub yonam diab mi gugum ebetemir eng Yisas nob qamamirei. ");
INSERT INTO wnu_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","32","Ende qamb igamari ne munon yurau irou Yisast yarab isub ende abari ne wuri bugab mi musub me niau. Ende at wogub ne wonou yurau eng wurinob qamar: “Wagari ininou gari wesopur iua ar ait bais umiomun,” ende qamb ne wurinou gari tabint isub ar ai end isumirei. ");
INSERT INTO wnu_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ende isari ibag ne munon ginam-ginam wuri qand der tap isub Yisas is ag dorunort end igurei. ");
INSERT INTO wnu_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ne wuri is ag der ibagamir e munon yurau eng gigit is igurei. Ende ibagar eng munon yurau eng wau gogor gas ende at qib igamari ne bo qob qamb mi qebebi bo end wuriimbigorei. ");
INSERT INTO wnu_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ende at igama ne worom nerimba gab ne wonou yurau wurinob qib igoar eng wot yarab qamamir: ");
INSERT INTO wnu_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","“Ar ait e munon yurau wuriimurima ginamt iua mani gab ba nub-nub qoounor.” ");
INSERT INTO wnu_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ende qamarari ne Yisas wurinob qamar: “Ende ue, an mi wurisari nunor.” Ende qamara wuri qamamir: “In nomon qur qebebi ue. K40 gari igo eng mani parau taui ba munon yurau ete wurisau eng qeemben ue”. ");
INSERT INTO wnu_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","39","Ende qamarari ne Yisas wuri qebi qamar: “An mani parau mai-mai ba yurumanei igo?” Ende qamara ne is gab imbig wogub diab qamamir: “Mani parau 5-ende yagwai ombur-ombur gari,” ende qamarari ne Yisas munon yurau eng wurinob qamara misugoant et qarangart bugoramirei. ");
INSERT INTO wnu_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Munon qarangart bugoramir eng qei 100-ende ne qei 50-ende. ");
INSERT INTO wnu_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ende bugormari ne Yisas mani parau eng yagwai nob baub ne qiter tat qite gab Qenu nob qamb ne mani eng boroumi munon wuriimbig qib igo eng wurisa baub munon bugoramir eng wurisabriamirei. ");
INSERT INTO wnu_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Wurisari munon yurau aib eng mani eng qeemben numirei. ");
INSERT INTO wnu_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Nub mani tatau wagomir eng Yisas wuriimbig qib igoar munon yurau eng tugar 12-ende tugarimari diarei. ");
INSERT INTO wnu_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Munon yurau aib eng qangang 5,000-ende. ");
INSERT INTO wnu_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Eng ende at wogub ne Yisas wonomai munon yurau eng wuriimurimb qamb wonou wuriimbig qib igo yurau eng gigit wuriimurima tabin ba ya tai eng bo purab munon ginam Betsaida wes end isumirei. ");
INSERT INTO wnu_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ne wonou gari munon eng wuriimurima isari ne wo Qenu nob qemerib qamb ai qaurt irarei. ");
INSERT INTO wnu_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Munon yurau tabin ba isumir eng is wubunobun irend isumir eng Yisas bo der daan irend igoai. ");
INSERT INTO wnu_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Igo ibagar ego sani-sani aib diab ya ba bures igaramb a wuriba gumutumoiemb aba pondogub qib igurei. Ende at qib igamari ai uter tubub dera ne Yisas ya erer naget-naget isi yarab wuriqubei isib at igama gamirei. ");
INSERT INTO wnu_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Isib at igama igoi wonou yurau tabint eng igoi gab: “ai bigau qii,” qamb borusi qiet atag amirei. ");
INSERT INTO wnu_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Gugum mom gab yariamir ego Yisas qand der wurinonogursi qamar: “An me yarimar, ye gari yoroum.” ");
INSERT INTO wnu_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ende wurinob qamb wogub ne wuri qani tabint iroa ne sani-sani aib di igoar eng wagerei. Ende aba gab ne wuri misir qebebi igub igurei. ");
INSERT INTO wnu_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Gigit mani parau gari duort boaia qebebi bura munon yurau qebebi numir eng wuri misir me igau, nasi wugumirei. ");
INSERT INTO wnu_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","54","Ne isi yar Genesaret end weib isub tabin end touri wogub iroari ne munon ginam eng Yisas gab qo imbigumirei. ");
INSERT INTO wnu_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Imbig ne qob bigari munon ginam-ginam isa munon toar nob eng saberit wuribig ba diarari Yisas wurimusub igoai. ");
INSERT INTO wnu_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ne Yisas munai ginam aib-aib qamaaman eng isa munon ginam eng gagar toar munon wuriba diab inesi Yisas qebi qamamir: “Ne waga munon toar nob e gagar ne mi goan tau end qas baab uberetriomunor.” Ende qamarari ne Yisas waga munon toar nob eng gagar mi goan gabut end qas baab uberetriamirei. ");
INSERT INTO wnu_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Eng Yuda munon wurinou qomon gitab igour eng ete: Uben me birogosi eng mani baab me nub igamau. ");
INSERT INTO wnu_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ne gor munon qei wurinob oai qigab qi qotub qibi diab eng uben birogosi qiyo ya mom gugum ubet wogub mi baab nub igurei. ");
INSERT INTO wnu_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ne qomon qei gor qogum qamb, tabin egi ne mi eng gagar mom musub birogoni igurei. ");
INSERT INTO wnu_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ende ebet igour end ne qen end Yisas wonou munon yurau eng qomon eng me toau, wuri ar uben me birogonimau igo mani baab nub igurei. ");
INSERT INTO wnu_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ende at igamari munon Parisi ne Yerusalem munon qomon qerei imbig igour eng diab ibag Yisas nob qamamir: “Ininou tonoan qomon eng inorou qamb gitab igour eng meimet qamb nonou yurau songi mi nub igour?” ");
INSERT INTO wnu_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ende qamarari ne Yisas taui qamar: “Qoan munon Aisaia Qenu qob gigit qamara gumater eng an qob eng quraumon eng irimanima.” Eng ete qamarei: Munon yurau eng qabarit qas yet ‘wo aib’ ende yet qamb igour, apand yet oabig me qomurunorei. ");
INSERT INTO wnu_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ne wurinou ur qoan qomon eng toat yonou qob gas ende at igo yet ‘wo aib’ yet qamb igour eng ye me igetarinei, ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ne Yisas qob eng bo imusi qamar: “An qomon uber qoregen Qenu in sirbigor eng mom wogub aninou tonoan qomon ansirbigumir eng gari toat igoumon. ");
INSERT INTO wnu_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","An Qenu wonou qob siningot wogub aninou qoyam imbi-imbi eng taut oboumon eng mesenau ende abari-abari,” ende qamb ne qamar: ");
INSERT INTO wnu_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","“Qenu qob qamara Moses gumater eng an gaiar, eng ete qamarei: “Tain nanib mi ue gab eng an mi werisar. Ne qob qamarari igub toat mi ebet wurit igar. A mun ger ur unort qob usai wurit qamara gab eng waramari uminer,” ende qamb ne bo qamar: ");
INSERT INTO wnu_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","“An munon yamangar qob wes wurinob ete qamb igoumon, ‘munon ger mi qei ur unor werisib qamb wogub bo ba is Qenut bigib qamb maribigoum end ne me andarinei,’ ");
INSERT INTO wnu_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ende qamb ne me wurisab igo. Eng ende abari ur unor your wurimusieriba? ");
INSERT INTO wnu_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","An munon yamangar ende wurinob qamb igoumon eng aninou misirt qamb ne Qenu qob eng ba songesi igoumon, ne qomon qei-qei gor ende at igoumon,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ende qamb ne munon yurau aib eng bo wurit qamara yarari ne qamar: “An eng wogub ye bo qemerine iruges big musub igar. ");
INSERT INTO wnu_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Munon mani nub mugi igo eng iriam qanam ende isub me ununsi igo, a misir boru-boru iriam qanamt igama ne dibesi qamb qiyo ebet igo eng munon eng wonou iriam qanam borusi igo.” Ende qamb ne qamar: “Qob eng aninob quraum eng misirt big igub igorub qamb eng ende abar,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ende qamb wogub ne munon yurau eng wuriwogub mor isa ne wuriimbig qib igoar munon yurau eng der mit big eng wurinob qamar eng bo qanam dibesi qamara igun qamb qebiamirei. ");
INSERT INTO wnu_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Qebi qamarari ne wo der qamar: “An gor qangangetroumon ne? Mani nub igoun eng is iriamt et igo gab me inununsi igorinerei. ");
INSERT INTO wnu_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Mi nub igoun eng isub ibi waria bo ibiat arir igoun.” Eng qamar eng Yuda munon wuri mani gitab igour end ne ende at wurinob qamar eng, mi niau gugum aren tor, mi gitarau ger ue. ");
INSERT INTO wnu_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ne bo mi geret big qamar: “Munon iriam qanamt mi igo di iger ag der igo eng munon ununsi igo, ");
INSERT INTO wnu_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Mi git eng, misir boru, yamangar munon nob song-song qib igour eng, mi urim baiau, a igeig yamau, ");
INSERT INTO wnu_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","23","munon yamangar nob qibaub wogub bo yamangar ger nob qib igo eng ne munon ger mi ger mom sig qenunget mom baib qamb misir igub igo eng, qomon boru-boru qei, munon ger munon ger mirimot qamarau eng, a munon misir ue gas qomon boru ebet igo eng, mindigar qob munon ger wot qamb, a munon ger qenu big qib igo yegaiar qamb ebet qib igo eng gagar gugum munon ununsi igo.” ");
INSERT INTO wnu_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ende qamb wogub munai ginam eng wogub bo ginam aib Tair wes end isorei. Isub is mon mor geret is waber igoai, munon yiimbigunor qamb, ende ebeter eng maigas me wabermau. ");
INSERT INTO wnu_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ende igama ne yamangar ger wonou yamangar wau ger ai waramorei igoai. End ne wo Yisas is igoar eng qob igub qand wot diab simot eab qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Yamangar eng Yuda yurau ue, Grik yamangar wonou ginam qenen eng Ponisia. Eng wo Yisast diab ai yamangar wau waramor eng wot musi qamb qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Di qamara ne Yisas mit big nob qamar: “In wau wurinou mani eng iau gigit wurisune niari tau ba wau me werisun.” ");
INSERT INTO wnu_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ende qamara yamangar eng Yisast oabig qamar: “Io barai, segagam quran, ego iau wuri mut wambint inab igo wau mi niari tub isa wuri nub igour.” ");
INSERT INTO wnu_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ende qamara ne Yisas bo qamar: “Io, eng quran end ne ai bigau wau wogub qoai uberet igo, is ge.” ");
INSERT INTO wnu_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ende qamara ne wo bo mor isub gar eng wau uberet wogub saberit inab igoai. ");
INSERT INTO wnu_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ne Yisas ai Tair eng wogub bo Saidon wes end yarab ne bo tumbigi Dikapolis end yarab Galili ya tai end isorei. ");
INSERT INTO wnu_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Isa ne munon quum ger qob musub me qamb igo eng Yisas musi qamb mot diamirei. ");
INSERT INTO wnu_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Diarari ne wo munon eng mot wes opur isub ne ubenqaur munon eng irugest end bigorei. ");
INSERT INTO wnu_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ende ebet ne wo qiter asi nanaui ne munon eng nob qamar: “Epata”. Qob eng qanam eng ete: “Iruges miroa qob iginer”. ");
INSERT INTO wnu_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ne iruges miroa qob igub ne qob me qamb igamau eng bo qen end qob wurinob qamb ende ebeterei. ");
INSERT INTO wnu_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Munon eng ende aba ne Yisas der munon qei wurinob qomorunor qamb qoronob mom wuritaisiarei. Wuritaisier eng maigas me wagau, qob aibsi qib igurei. ");
INSERT INTO wnu_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ende qamb qib igamari munon ginam gugum igub qamamir: “Wa, munon eng qi wagari ende igo munon quum qob me qamb igour eng, ne goten gurumtamir, mag tuum igour eng gagar wurimusub igoriner eng uber,” ende qamamirei. ");
INSERT INTO wnu_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Qen geret Yisas wonou yurau wurinob igama ne munon yurau bubun bo wot yaremirei. Yar end qen degen igamari ne mi niau uburerei. Yisas ende ibag ne wonou imbigau yurau eng wurinob qamar: ");
INSERT INTO wnu_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ye munon yurau e borusi mom wuritouboroum, qen duorgari end mi me niau end. ");
INSERT INTO wnu_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ar ende igamari ye wuriimuriemin eng qataben irab borusi minemb umubour, munon yurau qei pioui.” ");
INSERT INTO wnu_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ende qamara ne wonou yurau eng der qamamir: “Ai qengerenget igoun e, mani eret gab ba werisuboun? sig ue.” ");
INSERT INTO wnu_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ende qamarari Yisas wuri qebi qamar: “An mani parau mai-mai ba yurumanei igo?” Ne wuri qamamir: “Uben ig ue ig ombur,” ende qamamirei. ");
INSERT INTO wnu_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Qamarari ne Yisas munon yurau aib eng wurinob qamara misugoant end bugoramirei. Bugormari ne mani parau 7-ende igoar eng ba ne Qenut uber qamb ne boroumi wonou imbigau yurau eng wurisa ba wuri munon yurau bugab igour eng wurisemirei. ");
INSERT INTO wnu_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ne munon ger yagwai qei ba Yisas uta mani parau ebeter gas ende ebet ne wurisa ba eng gor munon yurau eng wurisemirei. ");
INSERT INTO wnu_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Mani eng numir eng qeemben ar. Munon mani numir qangang 4,000-ende. ");
INSERT INTO wnu_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Mani eng mom nub tatau wagomir eng usisi ba tugar 7-ende tugarimari diarei. Ende ebet wogub ne wuriimurima ginamt qoamirei. ");
INSERT INTO wnu_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Qoari ne Yisas wonou imbigau yurau eng nob bo qand tabint isub munon Dalmanuta wurinou ai end isumirei. ");
INSERT INTO wnu_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Isari ne Parisi wuri qob igub Yisas nob agunub qamb yaremirei. Yarab nob qamamir: “In igoun eng ne qomon wesi ger aba igub ne maigas Qenu noopurima igo aban ende qamb warigesi nogoub qamb diaun.” ");
INSERT INTO wnu_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ende qamarari Yisas qob eng igub borusi mom quguraget ne nanaui qamar: “Wa, munon yurau eng meimet qamb qomon wes ger gub qamb obour? Wuri ye me yiimbigour, ende gab eng ye qomon wes ger bo wuri magqurt me ebeinei,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","14","Ne bo Parisi wuriwogub tabin ba ig iro isub qamb isumirei, qen end mi qibi ger me baiau, mani parau gari qas ten baumirei. ");
INSERT INTO wnu_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Tabint isub igo ne Yisas wonou yurau eng wurinob qamar: “An Parisi Herot nob wurinou mi wes end qoyametarar. Mi eng mani parau erobon big igour gas ende.” ");
INSERT INTO wnu_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ende qamara ne wonou yurau eng sir me imbig qamamir: “Maia, in mani parau nasi wogub yoroun end qura qiyo.” ");
INSERT INTO wnu_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ende qamb wuri misir qebebi igub ende qamb igamari ne Yisas wurinob qamar: “An meimet qamb mi niaut misir qebebi igub igoumon? An ye sig me yiimbigoumon ne? An yet se qanganget igoumon ne? ");
INSERT INTO wnu_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ende qamb ne qamar: “Io, qoan Qenu wonou qob qamara gumatemir eng an mag nob ego mi musub me gaumon, a iruges nob ego qob musub me igoumon.” Ende qamb ne qamar: “An mi qoan ebetemir eng bo igar. ");
INSERT INTO wnu_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Munon yurau aib 5,000-ende eng an mani parau 5-ende ne yagwai ombur-ombur gari wurisari nub tatau wagari an usisi tugar mai-mai tugarimari diarei qi eng bo igar.” Ende qamara ne wuri qamamir: “In tugar 12-ende tugariaminei.” ");
INSERT INTO wnu_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ende qamarari ne bo wurinob qamar: “Ne bo mani parau 7-ende eng ye bo boroumi andarine an bo tumbigi munon yurau 4,000-ende wurisari nub tatau wagari an tugar mai-mai tugariamanei?” Ne wuri qamamir: “Tugar 7-ende tugariaminei.” ");
INSERT INTO wnu_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ende qamarari ne Yisas qamar: “An eng gab yet sig ar qanganget wogoumon ne?” ");
INSERT INTO wnu_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ende wurinob qamb wogub ne erogori isi Betsaida end weib isumirei. End isari ne munon mag tuum ger Yisas musi qamb ba diamirei. ");
INSERT INTO wnu_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yisas gab ne munon eng ubent baab munai ginam wogub qonut isumirei. Isub ne Yisas munon eng magqurt mu wot mendir ne uben magqurt big qamar: “Ne mi qei gan qiyo?” ");
INSERT INTO wnu_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ende qamara munon mag tuum eng igeser-igeser asi qamar: “Io, ye asi munon qei ibagaum eng wuri nam qib igamau gas ende.” ");
INSERT INTO wnu_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ende qamara ne Yisas uben bo magqurt ende biga ne mom mi gugum ubersi garei. ");
INSERT INTO wnu_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ende at wogub ne Yisas munon eng nob qamar: “Ne isub munai ginam song-song me qib igoar, nonou munait qoregen isi.” ");
INSERT INTO wnu_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ende qamara isa wogub ne Yisas wonou munon wurinob qib igo eng wurimar ai Galili wogub ginam Sisaria Pilipai end irab qib igurei. Qataben ir igo ne Yisas wonou yurau eng wurinob qamar: “Munon qei yet mai qamarari igub igoumon?” Ne wuri der qamamir: ");
INSERT INTO wnu_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","“Munon qei der nenet Yon munon yat wurimarangansi igo umor eng bo der bugamorei, a qei Elaiya Qenu wonou qob gigit qamb igoar eng tat erer irer eng bo dererei, ne qei der: “ue, Qenu wonou qob gigit qamb qib igo umbriamir eng ger der bugab qib igo,” ende net qamb igour,” ende qamamirei. ");
INSERT INTO wnu_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Qamarari ne wo bo der qamar: “Ende eng an yet mai qamb igoumon?” Ne Pita taui qamar: “Ne munon Qenu qoan init imurimb qamb qamar eng ne gari.” ");
INSERT INTO wnu_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ende qamara ne wo der munon qei wurinob qomorunor qamb qoronob wuritaisiarei. ");
INSERT INTO wnu_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ende wuritaisi wogub ne qanam big wonou git goan borusiorunor end wuriimbig qamarei. Qamb wonomit qamara: “Munangit wau borusi qugurageteriba. Ne munon baraitari, ne Qenu munai qoat igour munon eng, ne qomon qoat igour eng wuri der siningot mogirt wab wogub waramari uma tumunimbour. Tumunimunorei igama qen duor gari ende uma bo der bugemba,” ende dibes wurinob qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yisas mi eng gagar musub ende wurinob qamara igub wogub ne Pita Yisas mot qonut ete isub Yisas qob eng qamar end qamat qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ende qamara ne Yisas der ununub ne igeser Pita wonou yurau erogori eng ibag bis arir wogub Pita wonou sir qamat qamar: “Ne qob eng at quran eng Satan wonou qob, ne aisi iua, ne munon misir eng qas quran. Qenu wonou sarau eng ne me imbigan,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ende qamb wogub igoi qen geret Yisas munon yurau irou wurit ara yarari ne wonou imbigau yurau eng nob wuriqiumuni qob wurinob qamar: “An ger ete ye gas ende ebeib qamb eng ye mi ebeibam eng gari toat ebeiner, wonou qenungau eng weginer. Ende ebeiner eng ye yesumungasiorubour gas ende, erer urimunor qiyo ar waramunor eng me yariminerei. A munon qiyo yamangar ger ende ebeib qenunget gab eng ye yewapet mi oboum eng gugum ebeiner,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Qamb ne qamar: “Munon ger ye eng quraum end yari gab eng wonou moui ten mom-mom umiba, a ger ye quraum gas ende sumungasiorunor eng umb wogub bo igom der bugab bebereg igoriba. ");
INSERT INTO wnu_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ne munon ger wonomit qas misir igub git goan ubersi igoriner eng umb eng wonou moui qo qugur eng gor umiba,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ne qamar: “End ne munon moui eng mi sig uber, end moui bo umiba gab ne bo mi uber ger ba tap uber eng tauima me irinerei, sig ue. ");
INSERT INTO wnu_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Qen see munon ginam gugum qomon boru wes-wes Qenu magqurt ebet igour. End munon ger ye yedibesi qiyo qob quraum eng munon yurau boru eng wurinob qemerib qamb yari qiyo qinininginer eng ye munangit wau erer qite irin eng qen geret bo derin eng Qenu wonou enger yurau eng ne wonou begen qenengi nob eng ten darab munon eng ende ebet igoriner eng ye gor me wot iginei,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yisas qob eng ende qamb imusi bo qamar: “Apand aninob quraum, an e igoumon eng qei me umunanei igama Qenu wonou bibis bigor eng wonou qiribiten eng end dibenara guboumon,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ne qen 6-ende ubura ne Yisas Pita Yems ne Yon ende wurimar ai qaur aib end irarei. ");
INSERT INTO wnu_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Irab ne munon ombur gari eng der Yisas gamir eng wonou mi goan git goan nob bo igeser oan qenengi nob bura gamirei. Mi goan see ger oannob ende me gab igoun. ");
INSERT INTO wnu_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ende gab ebetemir eng munon ombur-ombur, Elaiya Moses nob der Yisas nob naget qobub igurei. ");
INSERT INTO wnu_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Ende ibag ne munon ombur gari eng borusi mom yari ne qob ubersi me qamarau. Ende igoi wogub ne Pita der gegir qamar: “Barai, in e diaun eng sig mismisiraun end in mat ombur gari et ubouboun, ger net, ger Mosest ne ger Elaiya wonou.” ");
INSERT INTO wnu_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ende qamb igo gamir eng waber aib der wuriumiamorei. Ende aba igumir eng Qenu waber erobon end qamar: “Munon eng gaumon eng yonou wau ten sig mom wot igub igoum, wo qob qamara an toat igoarar.” ");
INSERT INTO wnu_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ende qamara igub Moses Elaiya nob ibogoub qamb asiamir eng munon ger ue, Yisas gari wurinob igoai. ");
INSERT INTO wnu_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ne ai qaur eng wogub bo qumo darab munon ombur gari mi eng gamir end qob song-song qomorunor qamb Yisas qoronob wuritaisi qamar: “An mi qite gaumon end se me qamb qirar. Qen geret munangit wau umb der bugama qen end mi eng gaumon end dibesi qamarar.” ");
INSERT INTO wnu_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ende qamara ne munon ombur gari eng wurinou qob-qob qamamir: “Umb wogub bo der bogomau qurar eng qob qanam eng maigas?” ");
INSERT INTO wnu_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ende qamb ne Yisas qebi qamamir: “Munon qomon imbig igour eng munon yamangar ete wurinob qamb igour, Elaiya Qenu wonou qob gigit qamb igo eng wo gigit ag e deriba, dara ne Qenu wonou munon aib eng Isrel wurit imurimba ende qamb igour.” ");
INSERT INTO wnu_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Ende qamarari ne Yisas wo Elaiya unum eng igub ne wo Yon ya obotar igoar eng wo gigit der sarau baab igama waramari umor end qamar: “Segagam Qenu wonou qob gigit qamb igoar munon eng Elaiya gas eng wo qo darab sarau baab tap gigit musuorei. Ne see ye musub aninob qemeribam eng: Elaiya qo dererei, darab sarau bea munon wurinou misir boru-boru end ba borusiamirei. Eng qoan Qenu wonou qamara munon qei gigit gumatemir eng gor ende, munangit wau darab sarau bea wurinou qenungau end ba sumungasiorubour.” Ende qamb ne ete wuriqebi qamar: “Maigas gab Qenu qoan qamara wonou munon gigit gumatemir eng ete: Qenu wonou munon ten eng wo mom mogirt wab wogub waramari uminer qob eng qamamir eng maigas gab qanganget igoumon?” Ende qamara wuri qob taui ger me qamarau. ");
INSERT INTO wnu_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yisas munon ombur gari eng ende wurinob qamb wogub isi wuriimbig qib igoa yurau tau wuriwogub iramir eng is ibagamir eng munon yurau aib diab wurinob agunub igamari is ibagamirei. ");
INSERT INTO wnu_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ne munon yurau eng Yisas ende isub igama gab borusi qiet ne wot iramirei. ");
INSERT INTO wnu_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Iroari ne Yisas wuriqebi qamar: “An meimet qamb agunub igoumon?” ");
INSERT INTO wnu_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ende qamara ne munon ger erobon end igo taui qamar: “Barai, yonou wau ger ai waramorei igama qob me qamb igo. ");
INSERT INTO wnu_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Toar qen eng gab umb isub nanabar gagamt ne mu ba di waramb ende at igo. End mot diab nonou imbigau munon wurisirbigour eng wuri maigas me musiorunorei eng gab diab nonob quraum.” ");
INSERT INTO wnu_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ende qamara Yisas igub ne wurinob qamar: “Ye qen dirigor aninob igoum eng an yet me oabigoumon ne? Ye qenen aninob me igorinei. Ye qen mai-mai anamar igimine an yet oabiguboumon?” Ende qamb ne qamar: “Wau eng mot diara gine,” ");
INSERT INTO wnu_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ende qamara wau ba derari Yisas gab ne ai waramor eng wau wegib qamb ba ai qent qumo arir aba borusi aruarei, aruab nan mom qingim got mon gagamt mu ba di waramb ende ebeterei. ");
INSERT INTO wnu_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ende aba ne Yisas der wau eng ur nob qamar: “Wau e mai, qoan qas ende ebet igoai qiyo?” Ne ur qamar: “Io, qoan qomourt igoar eng wonou ende ebet igoai. ");
INSERT INTO wnu_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Qenen ai waramor eng wonou qen eng yara ba mutet arir qiyo ba yag arir ende ebet igoai. End ne nonou qenungau musierib qamb eng wau eng nonogursi.” ");
INSERT INTO wnu_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","24","Ende qamara ne Yisas der qamar: “Ne meimet qamb yet, ne mom gab eng wau e musi quran? Munon ger ye mom yiimbig qemeriner eng wonou ar uberburiba,” ende qamara ne ur der qamar: “Ye net mom oabig quraum qiyo, yonou sir me imbigoum. Eng gab ne ne yenonogursi,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yisas ibagar eng munon irou qouimari ibag ne aibigau wau waramor end qamar: “Aibigau, ne wau e waramon end iruges quumet a qob me qamb igo e, wogub der iua. Iua bo wot me is.” ");
INSERT INTO wnu_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ende qamara ne aibigau eng qoaib qamb wau eng ba ai qenen arir ne wau eng aba eab ab aruab ende at inab igama munon gab qamamir: “Io, uma.” ");
INSERT INTO wnu_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ende qamb igamari ne Yisas ubent baab bemenima der bugab mom uberetarei. ");
INSERT INTO wnu_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ende at wogub ne wonou wuriimbigau munon eng wurinob is mon geret igo ne Yisas qebi qamamir: “Wau aibigau waramor eng in musiorun qamb oboun eng me uberburau, eng maigas obouboun?” ");
INSERT INTO wnu_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ne Yisas qamar: “An ye mom yiimbig ne yesimot ab obounon eng musioruboumon. Tap geret ue,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Yisas ende wurinob qamb wogub ne ginam eng wogub munon qei inimbigunor qamb wurinou qi Galili end isumirei. Wurinou wes end is igo Yisas wonou wuriimbigau munon eng qi wuriimbig igorib qamb isumirei. Ende igo ne wonomit wurinob qamar: “Munangit wau wurinou qob ue-ue end at ne dui narau bigari yar ba waramari umiba. Uma ne tumunimunorei igama qen ombur gari end bo igom der bugemba.” ");
INSERT INTO wnu_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ende qamara ne wuri qanam barsi me imbig ne qebimau end yari wugumirei. ");
INSERT INTO wnu_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ende wurinob qamb wogub bo Kaperneam end isub munai mor ger isub igurei. End igo ne wonou imbigau munon eng wurinob qamar: “An qataben yar igo meimi qob qamb qomongori yar igomoroumanei?” ");
INSERT INTO wnu_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ende qamara ne wuri qubig wagomirei. Wuri qob qamb isub igour eng wurinomit mai qiyo your baraitari igoriner qi end qamb-qamb isub igurei. ");
INSERT INTO wnu_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","36","Ne Yisas wonou wuriimbigau munon 12-end wurit qamara qani yarari ne qob qataben qamb isub igour end wurinob qamar: “Munon ger wonou baraitari igorib qamb eng wau gogor gas ende igo munon qei sarau batar igoriner eng qen geret baraitari igoriba.” Ende qamb ne wau qomourt ger ba wubunobun et nagasi ne wurinob qamar: ");
INSERT INTO wnu_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Munon ger wau e gab mismisir eng wau et gari me mismisirinerei. Yet gor mismisir ne yonou tain yiimurima derem end gor wot mismisiriba.” ");
INSERT INTO wnu_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ende qamara Yon der qamar: “Barai, munon ger ne unumut toar boru-boru wurimusub igo eng ininob me yarau eng gab in giteturunei.” ");
INSERT INTO wnu_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ne Yisas nob qamar: “An meimet qamb gitetet wugumanei? Munon ger ye unumut qomon wes ger ebet eng mindigar qob yet me qemerinerei. ");
INSERT INTO wnu_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","41","A your in me inqarausi igo eng ininou munon banam.” Ende qamb bo qamar: “An qib igamari ne munon ger qataben nini animbag Krais munon yurau qamb ya qiyo mi qei andariner eng munon eng ar me igorinerei. Qenu taui ubersieriba. ");
INSERT INTO wnu_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","A, see munon ger wau e ye yiimbigar eng bo wonou misir boru end ba songesieriner eng munon eng nomon aib ger ba quman end touri wogub ten uyer yat ariramari misir iginer. End sumungasiorunor eng qen geret Qenu wo bo sig-sig mom tauimba,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Ne qamar: “Ne uben end qomon boru ebeib qamb misir igub gab eng qand uben ig sopur arirom. Arir igo ne uben igt qas igoriner eng qen geret bebereg igoriban, a mut naat oab igo end isib qamb eng uben ig-ig igoriner. ");
INSERT INTO wnu_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Ne goten eng gor ende qas. Ne qomon boru ebeib qamb isub gab eng misir eng wogub goten ig sopurminenei igo igt qas igoriner eng qen geret bebereg igoriban, a ende me ebeib qamb weginen eng mut naat oab igo end is sig-sig mom boru igoriban,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ne mag end gor ende qas qamarei: “Magqurt mi gab misir boru igub gab eng mag ig gumot neri arirom, arir igo ne igt qas igama Qenu wonou bibis end isiban, a ar ig-ig igama eng, ");
INSERT INTO wnu_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ne ginam boru end isa mumundir negininget mut naat oab igo eng ne nonogsi ende abari ne qenen migeri nanab igoriba.” ");
INSERT INTO wnu_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ende qamb ne mit big qamar: “Munon wai bieriner qamb tomont si bigari qen dirigor uber igo. Eng gas ende Qenu munon uber igoarar qamb wuriquguragsi igo. Wuriquguragsi igo eng mut wuriora uyeriri igab igo gas ende. End ne munon wurinou uber igorub qamb eng wurinomi quguragsiorunor. ");
INSERT INTO wnu_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Tomon eng mi iriga niau eng uber. Tomon qer uburinerei igama ne bo ba warigesi qebist werinen eng qer ue gab bo maigas aba uter buriba? Eng gab ne an munon yamangar gugum wurinou tomon qer uber gas ende igo qibanamsi erogori qomon uber end igoarar,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ne Yisas Kaperneam eng wogub bo Yudia eng yar ne ya Yordan wes end isorei. End isa ne munon yurau aib bo yar end qiumunimari ne Qenu qob qenen wurinob qamb igo gas ende bo qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Qob wurinob qamb igama ne munon yurau ger, Parisi qamb igour eng yar Yisas woboni wogub qob qei gag warigesi qebi qamamir: “Maigas, munon ger ubeni mom weginer eng uber qiyo?” ");
INSERT INTO wnu_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ende qamarari ne Yisas bo wuriqebi qamar: “Qoan munon ger yamangar mom wagau end Moses maigas gumaterei igama wanunger igub igoumon?” ");
INSERT INTO wnu_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ende qamara ne wuri qamamir: “Moses ete gumaterei: “Munon ger yamangar eng mom wegib qamb eng qob ger qamb nausi ne yamangar eng mom wogoum qamb gumat ne mom weginer,” Moses ende qamb gumaterei igo.” ");
INSERT INTO wnu_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ende qamarari Yisas taui qamar: “Moses eng ar me qamb gumau, aninou qomon eng ebet igamari ne wo gumater eng. ");
INSERT INTO wnu_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","A qoan Qenu mi gugum barsi ne munon yamangar nob barsiarei. ");
INSERT INTO wnu_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","8","End munon yamangar nob qibaub eng unorimagrari mom wuriwogub munon qiyo yamangar eng wuri ombur igamau gas ende ue, ombur bo git goan gari qas burab igour. ");
INSERT INTO wnu_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Mi eng Qenu wonou mom nausi igo eng munon ger me biisiteinerei.” ");
INSERT INTO wnu_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ende qamb wogub ne Yisas wonou wuriimbigau munon eng wurinob munait diab ne wuri der Yisas qob eng qamar end qebiamirei. ");
INSERT INTO wnu_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Qebimari ne Yisas qamar: “Munon ger ubeni gigit eng wogub bo bubun ger bainer eng yamangar baiau qomon eng biisieriba. ");
INSERT INTO wnu_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ne eng gas ende gari yamangar gor ende sig,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ende qamb igama ne munon qei wau oromar Yisast diune wurinonogursi qamb wurinob diamirei. Ende derari ne wonou wuriimbigau munon eng der wau orotoar ariramirei. ");
INSERT INTO wnu_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ende abari Yisas der wurimar qamar: “Wau qamaaman me orotoar arimar, wagari ye qani diorunor. Qenu wo munon gugum wuriqenugar igo eng wau wuri misir gas ende eng wo wuriqenungar igo. ");
INSERT INTO wnu_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Segagam aninob quraum, munon barai ger wau qomon qi igo gas ende me igoriner eng Qenu wonou yurau end me igorinerei.” ");
INSERT INTO wnu_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ende qamb ne wau eng wuriba qubei ne uben tarit end big wurinonogursiarei. ");
INSERT INTO wnu_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ende at wogub tap isub igamari ne munon ger qataben end uyab-uyab diab gamaur wat bugab ne Yisas qebi qamar: “Barai ne uber, ye maigas ebet qen geret bebereg igoribam?” ");
INSERT INTO wnu_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ne Yisas nob qamar: “Meimet qamb yet uber quran? Munon ger uber ue, Qenu gari uber. ");
INSERT INTO wnu_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","End ne Qenu wonou qomon eng nonou gari qoyam eng. Ne me igeig yom, yamangar ba wogub bo ger me bai. A mi urim me bai, munon ger mirimot me qem. Ne mi geret munon ger mirimot yonomi qamb wabi wogub qi me bai. Ne ar nani tain nob wuriqenungar ne wuri qob qamarari igub toat mi ebet igoar.” ");
INSERT INTO wnu_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ende nob qamara ne munon eng Yisas nob qamar: “Barai, qomon eng gagar qambariman eng ye wau qomourt igo toat igoum eng isi yarab see.” ");
INSERT INTO wnu_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ende qamara ne Yisas qenunget nan gab ne qamar: “Git eng uber quran, ego qomon gari qas me toat igoan, eng ete: nonomi eng gugum munon wurisa ne nomon qur taui natari ne nomon qur eng ba bis munon boru mi ue eng qerei wurisabriom. Ende ebeinen eng qen geret Qenu mi qebebi neteiba, end ne ne ye yetoa ombur qib igorun.” ");
INSERT INTO wnu_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ende qamara munon eng mind duet wogub Yisas merimot wogub qorei. ");
INSERT INTO wnu_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Qoa ne Yisas der wonou wuriimbigau munon eng wurinob qamar: “Munon e at wogub qoa gas ende munon gugum ende obounor eng Qenu munai ginam end irub qamb pondogub igorubour,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ende qamara ne wonou imbigau yurau eng igub borumisir igumirei. Ende abari ne Yisas der bo wurinob qamar: “Wau, Qenut iroau eng tap sarog ue, pondogiban. ");
INSERT INTO wnu_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ete gas, maiben mingoan maimau nil iru eng isiner eng qeemben ue. Ende gas ende munon mind aib nob igo eng Qenut irib qamb eng sig-sig mom pondogub igoriba.” ");
INSERT INTO wnu_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ende qamara ne wonou wuriimbigau munon yurau eng igub borumisir igub wurinou qob-qob qamamir: “Wa, segagam ende gab eng munangit gugum qen geret bebereg me igorunorei. ");
INSERT INTO wnu_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ende qamarari Yisas nan ibag wogub qamar: “Qenu wonou ende wuriseara bebereg igorubour. ");
INSERT INTO wnu_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ende qamara Pita der qamar: “Maigas, in mi gugum wogub ne nonob qib igoun eng, maigas obouboun?” ");
INSERT INTO wnu_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Ende qamara Yisas erogori wurinob qamar: “Ye apand aninob quraum, munon ger ye yetoat qib qiyo ye qob imbigoum eng bo imusi qemerib qamb eng munai ginam wogub a umomori umuragrari, ne ur unor a wagrari ne mi man qamb eng gugum mom mogirt wab wogub yarunor eng bo mi eng gagar ue gab me wot qoot me ubunerei. Mi eng gugum bo Qenu tauimba. Eng mon bo qebebi ne umom umour ne umemi a ur unor ne mimun man gor qoan igoar eng bo wotanami utiba. Mi qebebi ende baunon eng munon qei ye yesiorunor eng an bo ende ansiorubour eng an end misir me igar. Qen geret an bo bebereg uber igoruboumon.” ");
INSERT INTO wnu_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ende qamb ne qamar: “See in aib qamb obour eng qen geret bo wau gogor gas ende igorubour, a see an wau gogor gas ende igorunon eng bo aib igoruboumon,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ende wurinob qamb wogub ne wonou imbigau yurau eng wurinob Yerusalem aitap eng toat isumirei. Yisas wo gigit isa ne wonou imbigau yurau eng qanam isau end misir qebebi igub at qib igurei. Ne munon yurau aib worotoar isumir eng gor yariamirei. Isi yarab qataben Yisas wonou yurau 12-ende wurimar qonut isub ne Yerusalem weib isari maigas wo siorunor eng gugum qamara igumirei. ");
INSERT INTO wnu_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","34","Wonomit ete wurinob qamar: “An musub igar, in isi Yerusalem umo isune munon aib-aib qomon imbig igour eng ne imbigau munon aib-aib eng qob musub wogub Munangit wau ba munon qarau ende wurit duimari isa wot tumi a qob isi wot qamb ne pisirami waramb ende ebet wogub ne mom waramari umiba. Uma tumunimunorei igama qen ombur gari ubura bo igomot der bugemba,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ne Sebedi wonou wau ombur Yems Yon nob Yisast diab qamamir: “Barai, in ombur ne mi ger inimbig qamara igub.” ");
INSERT INTO wnu_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ne Yisas der wurinob qamar: “An ombur ye mai ansieribine quraumon?” ");
INSERT INTO wnu_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ende qamara ne ombur der qamamir: “Ne inmusia in ombur munon baraitari aib igo ne nonob qani bugab qib igumune nonou qen munon oroar munai ginam qoat ebeiban qen eng yariner.” ");
INSERT INTO wnu_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ne Yisas der ombur wurinob qamar: “Git uber yenob quraumon, ego an mi eng sir me imbigoumon. Maigas, ye qugurau eng an baub quraumon qiyo? Ne gor ye munon qarau ye yanambour eng an gor iningaramar qamb qenungoumon qiyo?” ");
INSERT INTO wnu_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ne wuri qamamir: “In gor eng qenungoun.” Ne Yisas qamar: “Segagam ye qugurau eng an bauboumon, end ne an mom nonoguret igoarar. ");
INSERT INTO wnu_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","A, an ye anmaribigine baraitari ye qani igorub quraumon eng ye me ebeinei. Sarau eng yonou tain Qenu eng wonou qo munon sarau eng abar qamb wurimaribigorei,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Yems Yon nob der Yisas ende qebi qamarari ne wonou imbigau munon 10-ende eng der ombur wurit misiringetamirei. ");
INSERT INTO wnu_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ende abari ne Yisas wurinou misir imbig ne wurit qamara yarari ne wurinob qamar: “Gabman munon baraitari qiyo munon baraitari wuri munai ginam qoat ne munon wurinob qamarari qob toat igour. Igamari wuri der wurinonogursi igour. ");
INSERT INTO wnu_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","44","An eng oboumon eng bo ende me abar. Munon ger baraitari igorib qamb ebeiner eng bo baraitari me igorinerei, a ger ende misir me igub wau gogor gas ende sarau batar igoriner eng wo baraitari igoriba.” ");
INSERT INTO wnu_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ende qamb ne qamar: “Ye gor ye Munangit wau, ye baraitari igimine munon yet sarau baab igoarar qamb me darau, ye munon irou qenen bebereg igorunor qamb end wurit igub taui yonomi dui ne umib qamb deremei,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ne wuri isi Yeriko weib isub ne bo tumbigi isubari ne Yisas wonou munon wuriimbigau eng nob munon yurau ar nob isumirei. Qen end munon ger unum Bartimeus ur unum Timeus wo mag tuum end qenen tap tog goant end bugab igo munon is qiroari mani yeisar qamb qiyo nomon qurt wurinob qamb igoai. Eng ende igama ne Yisasb isumirei. ");
INSERT INTO wnu_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ne wo igor eng Yisas Nasaret munon yara ende qamarari igub wot atag qamb ar: “Yisas, ne Debit wonou wau tumbig, ye yetoubet ge.” ");
INSERT INTO wnu_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ende qamb ara munon qei der taisi qamamir: “Qi wog,” ende taisi qamamir eng wo me wagau. Sabar-sabar ab igoai. ");
INSERT INTO wnu_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ende ara Yisas igub naget qamar: “Munon eng nob qamarari yariner.” Ende qamara wuri irab qamamir: “Yisas ne musierib qamb net qamb igo, mismisir der isi.” ");
INSERT INTO wnu_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ende qamarari munon eng qand der naget mingoan it neri arir wogub Yisas qani isorei. ");
INSERT INTO wnu_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Isa Yisas gab qamar: “Ne ye mai yesi qamb misir igan?” ende qamara munon eng taui qamar: “Barai, ye mag, mai aba musub asiemin qiyo?” ");
INSERT INTO wnu_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ne Yisas wonob qamar: “Ne yet oabig yaran end mag bo asiemban,” ende qamara qen end qas musub asi tap gab Yisas nob Yerusalem umo isumirei. ");
INSERT INTO wnu_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ne is-isi Yerusalem qani munai ginam ombur unum Betpage ne Betani end isumirei. Munai ginam qani end ai qaur nam Olib man aib igo end isub qamb Yisas wonou wuriimbigau munon ombur wuriimurima gigit isumirei. ");
INSERT INTO wnu_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Isubari qamar: “An isub munai ginam end bur dongi yeim ger tesimunorei igama gab qand neri ba diarar. Bur eng munon ger erer me bugab qib igamau. ");
INSERT INTO wnu_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ba diorub at igamari munon ger animbag anqebi qamara gab eng ete nob qamarar: “Munon aib sarau utab wogub qand bo imurima yariba ende qamarari ne waga qand nob diarar.” ");
INSERT INTO wnu_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ende qamara ombur isub gamir eng bur dongi yeim eng tap goant et ibiariamirei igama gab neri ba diorub at igamari munon qei ibag qamamir: “Meimet bur eng nerimb at igoumon?” ");
INSERT INTO wnu_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","6","Ne ombur Yisas qob qamar eng taut wurinob qamarari ne wuri qamamir: “Uber batet irauar.” ");
INSERT INTO wnu_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ende qamarari ombur ba Yisast irab ne wurinou mi goan norumi wai dongi erer end bigari Yisas ir erer bugamorei. ");
INSERT INTO wnu_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Yisas wai erer bugab isub igama munon qebebi mi goan norumi tapet oramet qiyo nam uben boroumi oramet ende abari erer isub igoai. ");
INSERT INTO wnu_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Isa munon yurau aib qei gigit isari qei qanam ende at ba woboni isub igo mismisir qamb amir: Sig uber Qenu ininou munon baraitari ubersitara. Ininou Munon aib maragansia yara. ");
INSERT INTO wnu_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Qoan Qenu Debit nonogursia in inoar igoa gas ende wo bo ende insi igoriba. Munon aib wot sig-sig mom mismisirar. Ende ab toaubig mugurt nob isub igurei. ");
INSERT INTO wnu_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ende at isi Yerusalem umo weib yarab ne Yisas Yuda wurinou inorou munai aib eng mor isorei. Isub ne mi gugum mor igo eng gagt gab qibei wogub ai gab-gab ago der wonou wuriimbigau munon yurau 12-eng wuri nob bo yonam irab munai ginam Betani end inemirei. ");
INSERT INTO wnu_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","13","End inemirei igo urigerma bo Yerusalem isub qamb isi qataben Yisas minemb ne nam ger mugen qonut et igama gab ne qur ger miminet igo qi qamb is qanamt qiter gin qamb asi qib-qibei qur ger me gab (qur bigau qen ue) borusi mom misiringet ne ");
INSERT INTO wnu_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","nam eng nob qamar: “Ne qur me bigau eng gab ne bo mom-mom qur me biginenei.” Ende qamara wonou wuriimbigau munon qob eng igumirei. ");
INSERT INTO wnu_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ende at wogub ne isi Yerusalem umo isumirei. Isi yarab munai aib mor isumir eng bo is gamir eng munon ginam qei wurinou nomon qur eng bear Yuda wurisab ne Yuda wurinou eng taui ba ende at igamari ibagarei. Ne morogan qamb bear taui mi baub qamb nam qab erer bigeriamir eng ten-ten biigimatar ne, ");
INSERT INTO wnu_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","munai mor end sabar mi bear taui baunor qamb wurigitatarerei. ");
INSERT INTO wnu_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Wuri gitatar ne wuriimbig qamar: “Qenu wonou qob eng ete qura: “Ye munai eng wagari wonou qau igama munon qei mor end isub wuri yet simot yet igub igorubour. Ego an bo munai ar gas ba sumungasi igoumon,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ne munon baraitari aib mon eng qoat igour eng ne Moses qomon imbig igour eng nob der Yisas eng qamara igub tap ger gab imbig Yisas waramune uminer qamb ebetemir eng Yisas wonou munon banam gor wonou qob qamara igub toat igour eng gor aib mom igamari gab ende ubune wot isub aib qamb yogorun qamb wagomirei. ");
INSERT INTO wnu_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ende at wogub ne Yisas wonou imbigau yurau eng oromar Yerusalem wogub bo yaremirei. ");
INSERT INTO wnu_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Yarab qataben inemirei igo itum der iri nam pik qur me big qamb Yisas taisi qamar eng di gamir eng umerib qamb im gegeret isi durun qumo mom gegeret uburab igama gamirei. ");
INSERT INTO wnu_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ende di gab barim qas Yisas taisi qamara igumir end Pita der qamar: “Barai, barim qas nam pik e qur bo me big qamb taisi qaman end gegeret igo e.” ");
INSERT INTO wnu_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","23","Ende qamara Yisas taui qamar: “Ye apand aninob quraum, an Qenu wot oabig ne an gor ai qaur ger nob ete qomorunon eng, ‘nerer isub uyer yat end nag’ ende qomorunon eng ende ebeiba. ");
INSERT INTO wnu_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","End ne ye ete aninob quraum eng. An Qenut mom oabig mi geret qebi qomorunon eng, ar quraumon gas ende andariba,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ne qamar: “An Qenut simot qamb igo ne an misir eng munon ger qomon boru anit ebinerei igama an bo wot qamarar: “Ne qomon boru yet aban eng ye nasi wogoum,” ende abari ne aninou qomon boru eng gor tain Qenu tat erer igo eng wo biruet ariramba. ");
INSERT INTO wnu_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","A an munon ger qomon boru anit ebeiner eng me nasi wogunon eng aninou Tain qite igo eng wo bo aninou qomon boru maigas me biruet ariraminerei,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ende qamb ne bo isi Yerusalem umo isub ne isi inorou mon aib eng mor isumirei. Isari ne munon baraitari aib-aib Moses qomon ne qomon qei-qei imbig igour eng Yisast yaremirei. ");
INSERT INTO wnu_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Yarab qamamir: “Ne your nonob qamara qomon eng ebet ne barim qas munon mi taui baub igamari orotoar ariramonei?” ");
INSERT INTO wnu_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ende qamarari ne Yisas qamar: “An ye yeqebi quraumon eng ye dibes me qemerinei. Ye qob eng qi igoriba. An ger ye qob eng taui ye nob qamarari igub eng ye qob dibes aninob qemeribam. A ye qob qeemben taui me qomorunon eng ye dibes me aninob qemerinei.” ");
INSERT INTO wnu_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ende qamb ne qamar: “An Yon ya obotar igoar eng wo sarau baab qomon ebet igoar eng your nonogursia ebet igoai? Ye eng quraum eng taui qamarari igub?” ");
INSERT INTO wnu_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ende qamara ne wurinou qob-qob qamamir: “In ete qomorun eng, ‘Qenu Yon nonogursia ebet igoai,’ ende qomorun eng wo ete qemeriba: ‘An meimet qamb eng nasiamanei?’ ende qemeriba,” ");
INSERT INTO wnu_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","A ete qomorun eng ‘Yon wonou misirt sarau barei,’ qomorun eng, munon qei der Yont Qenu wonou qob munon qamb wot igub igour eng der ininob yogurubour.” Wurinou qob-qob ende qamb igurei. ");
INSERT INTO wnu_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ende qamb wogub ne Yisas nob dibes qamamir: “In qanam sir me imbigoun, your Yon ya obotar igoar eng imurima sarau ende at baab igoai qi?” ende qamarari ne Yisas bo qamar: “An eng me qamarari gab ne ye gor your yiimurima sarau ende at baab igoum qi eng gor dibes me aninob qemerinei,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ende qamb wogub qob ger mit big wurinob qamar: “Munon ger wain man suab youn big wogub uborei. Ubub ne man end tumun ger goaneterei, wain qur arira ba end gumat igorin qamb. Ne mon qomourt ger end igo man qoat igorin qamb mindaterei. Ende at wogub ne munon qei qoat igo ne qur biga baub wurisab mi taui baub igoarar qamb wuriimbig wogub wo ginam pa iua igoai. ");
INSERT INTO wnu_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ende igama ne qen geret wain qur miminetra ne qob igub munon ger imurima wain qur baib qamb munon wonou man qoat igour end isorei. ");
INSERT INTO wnu_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Isa eng munon man qoat igour eng der baab ba waramb wogub imurimari wain qur me baiau, ar irarei. ");
INSERT INTO wnu_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ende iroa gab ne man ur eng munon ger bo wain qur bai qamb imuriamorei. Eng gor baab waramb tari omboipi wagari ar irarei. ");
INSERT INTO wnu_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ende gab ne bo munon ger imuriamorei. Eng mom waramb mumusiari me iroa gab ne bo irou wuriimurima isumirei. Isumir eng gor ende, qei igaramari umumirei, qei gogorau wuriwagomirei. ");
INSERT INTO wnu_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ende abari ne man ur eng sarau batau munon ger ue, wonou wau ten gari qas nob igo qenunget igoai. Eng bo imurimb qamb qamar: ‘Yonou wau ten e imurimine isa gab mai ende me siorunor qiyo,’ qamb imurima isorei. ");
INSERT INTO wnu_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Isi weib isa gab wurinou qi qamamir: “Wa, munon eng igoi qen geret ur uma ai e wo baiba. Wagari waramune uma ai e ininou baun.” ");
INSERT INTO wnu_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ende qamb ne baab waramari umorei. Uma ne mumun ba younam ag ariramirei. ");
INSERT INTO wnu_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ne qamar: “Wau eng ende abari wau ur mai misir igiba? Wo ende igub is munon eng wurinob yogub igaramba. Igaramb ne wonou man eng munon qei wurit wegiba.” ");
INSERT INTO wnu_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ende qamb qamar: An Qenu qob wepep goant igo eng aninou qoyam eng. ‘Sarau munon mon mindaub qamb nomon bigunor eng gab uber ue qamb at ariramirei igama Qenu giner eng uber gab ba qoren unatari gas ende nagsia mon eng mom nonogureteriba. ");
INSERT INTO wnu_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Munon Aib sarau eng aba dibenara in gaun eng sig uber, wonou wes ar,’ ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yerusalem munon baraitari aib-aib eng Yisas qob eng qamar eng wurinomi qomon ebet igour eng wurit big qamara igub wugumirei. Qen end Yisas baab tourimb ebetemir eng munon yurau qei Yisas qob qamara igub qenunget toat igour eng wuri der yogurubari gab wogub qoamirei. ");
INSERT INTO wnu_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ende iua ne qen geret Herot wonou munon yurau qei nob Parisi munon qei nob wuriimurimari Yisast yar qob qei warigesi qebimune wo Rom gabman a Yuda qomon wurit qob isi qamara igub qamb diamirei. ");
INSERT INTO wnu_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Diab qamamir: “Barai, in gugum niimbigoun. Ne qob apand qas qamb igoan. End ne ne misir ger igama gab eng qem. Ne munon Qenu qob wurinob qamarau tari end qob wabi ger me qem, qob tog gari qem. In Rom gabman end nomon qur arir igoun eng bo maigas obouboun? Qomon eng toat ende obouboun qiyo, woguboun?” (Eng ete: Yisas nomon qur bigau eng song wagar ende qemeriner eng Rom gabman wot misiringet ba tourimbour, a nomon qur bigau eng song ende abar ende qemeriner eng Yuda munon wot misiringet ba sumungasiorubour.) ");
INSERT INTO wnu_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ende qamarari ne Yisas warigesi mirimot qamb igour eng qo wuriimbig ne qamar: “An ye yewarigesi igoumon ne? Ende gab eng nomon qur ger ba yarari gine.” ");
INSERT INTO wnu_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ende qamara ne nomon qur ger utari ne ba wuri sirbig qamar: “Nomon qur e your wonou unum qugur nob et igo?” Ne wuri qamamir: “Rom munon aib Sisar eng wonou unum qugur nob igo.” ");
INSERT INTO wnu_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ne Yisas der qamar: “Ende gab eng gabman wonou eng wonou sir utar, a Qenu wonou eng gab wonou sir utab ende abar.” Ende qamara igub borumisir igumirei. ");
INSERT INTO wnu_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ne munon yurau qei Sadyusi qamb igour eng wuri der, ‘munon ger uminer eng bo me der bugeminerei qugur nob mom umb igo,’ ende qamb igour. ");
INSERT INTO wnu_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Munon yurau eng wuri diab Yisas nob qamamir: “Barai, Moses init qomon ete gumaterei. Munon ger wonou ubeni wau ger me baiau igama wo uma gab eng umour qiyo umom yamangar qindou eng baia ne wot wau misinam der isiner eng munon gigit uminer eng wonou wau.” Ende qamb ne qamamir: ");
INSERT INTO wnu_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","“Ende gas ende munon ger wau 7-ende igurei. Ne wonou wau qamar eng irub bauor eng wau ger ue igo umorei. ");
INSERT INTO wnu_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Uma ne umour bo irub qindou eng baurei, bauor eng wo gor qen piten nob igo wogub umorei. Uma ne wau qag wo bo baurei, eng gor umorei. ");
INSERT INTO wnu_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ende at is-isi wau isar eng gor bauor eng wo gor umorei, wau ger ue. Munon eng mom ende umb uburari ne yamangar eng gor umorei. ");
INSERT INTO wnu_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","End ne mai qiyo, qen geret munon eng bo der bugomunor eng yamangar eng your bo baiba? Ne misir maigas?” ");
INSERT INTO wnu_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ende qamarari ne Yisas qamar: “An Qenu wonou qob a wonou gagam eng an qoyam ue igo qob soagensi ende qamb igoumon a? ");
INSERT INTO wnu_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Munon gugum der bugomunor eng qibaiau qomon eng bo bais me igorinerei. Wuri moi yorou ar enger gas ende erogori igorubour,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ende qamb ne ete gor qamar: “Sadyusi an munon bo der bugomunor end misir qebebi igub igo qamb igoumon. Moses qoan amug qib igo nam ger mut qarub di igama gar eng qob suari me igub igoumon? Qen end Moses mi eng gea ne Qenu ete nob qamarei: ‘Ye Abraham a Aisak ne Yekop wurinou Qenu eng ye igoum,’ ");
INSERT INTO wnu_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ende qamb qamar: “Qenu munon qoan ombur gari wuri unumar qamar eng qanam eng ete: munon umburiamir eng ne igom igour eng Qenu wo oroar ne qenen igoriba, end wurit misir igub qamar eng an misir soageni igub igoumon,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Sadyusi qob eng qamarari ne Yisas taui wurinob qamara imbigau munon ger igor eng wotrama igub ne diab Yisas nob qamar: “Qenu wonou qob erobon end qomon irou igo eng meimi qomon eng wuritanamima?” ");
INSERT INTO wnu_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ne Yisas taui qamar: “An Isrel munon iruges big igar. Qenu eng gari qas ininou munon aib. ");
INSERT INTO wnu_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","31","End ne an wot oabig qenunget igoarar. Qomon eng quraum eng qamart igama ne bo ger eng ete: nonou gitgoan qenunget igoan gas ende gari qas munon qei wuriqenungar. Qomon qei qomon ombur eng quraum eng me wuritanamiminerei.” ");
INSERT INTO wnu_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ne imbigau munon eng Yisast qamar: “Barai, segagam quran, in Qenu gari qas igo eng ne quran eng, ger ue.” ");
INSERT INTO wnu_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","End ne Yisas qob qamar eng wo bo toat qamar: “Io, in gugum wot oabig qenunget ne ininou gitgoan qenunget igoun gas ende munon qei wuriqenungarun. Ininou qomon wes-wes, wai waramb ininou qomon boru birogonimoun qamb mutet wab qiyo atri igoun eng gor mi aib, ego ne qomon see quran eng qomon eng gagar atri igoun eng wuritanamima.” ");
INSERT INTO wnu_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Munon eng mom ende qamara Yisas igor eng uber gab ne wo der munon eng nob qamar: “Ne Qenu wonou yurau end igorib qamb at igoan.” Yisas qob qei ende qamara munon qei igub bo qebi gub etemir eng yari wugumirei. ");
INSERT INTO wnu_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yisas inorou munai aib end igo ne munon yurau aib eng wuriqebi qamar: “Qoan qob ger igama imbigau munon inimbigumir eng ete: Qenu qoan munon aib init imurimb qamar eng Debit tumbigi end darimba. Ego werei maigas Debit tumbigi end darimba? ");
INSERT INTO wnu_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Eng Qenu wonou Igomurur uber eng qoan Debit imbiga ete qamb gumaterei: Munon aib Qenu eng wo yonou munon aib wonob ete qamarei: Ne uberegent bugab igama igoi qen geret ye nonou munon qarau wurisierine wuri gugum nonou qeretutnob eng gab net yari uma isubour. ");
INSERT INTO wnu_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Eng Debit munon Isrel oroar igoriba qamar eng yonou munon aib. Eng wo munon aib qamar eng bo maigas wau qomour gas wariba?” Yisas qob eng gagar ende wurinob qamara munon yurau aib eng igub oau uber buremirei. ");
INSERT INTO wnu_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Qob eng ende wurinob qamb wogub bo qamar: “An imbigau munon qei wuri ete at qirunor end imbig igoarar. Munon qei inimbagaiar qamb mi goan degen-degen qumani munon qiumuni igamari magqurt end qib igorubour. ");
INSERT INTO wnu_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","40","Ne qei inorou munait end is nam qab uber-uber wurinosi bugombour. Ne mi aib at nub igamari wuri is munon magqurt end bugab, ne qei yamangar qindou end Qenu qebi qamb qob degen ubumot bisub igorubour. Eng wuri gag inimbagaiar qamb ende ebet qib igorubour. Eng wuri gag ende ebet ne munai qamb nomon qur mom baub ugeari wuri ar igorubour. Eng ebet igour end Qenu ibag taui qamb sig mom wuriquguragsieriba.” ");
INSERT INTO wnu_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yisas ende qamb wogub ne inorou munai mor nomon qur big igour qani end bugab igo ibagar eng munon yamangar nomon qur aib-aib Qenu wonou sarau end ba yar ariramari ibag igoai. ");
INSERT INTO wnu_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ibag igama ne yamangar qindou ger nomon qur mian nob qomourt eng ombur-ombur gari ba di arirama garei. ");
INSERT INTO wnu_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Gab wonou wuriimbigau munon yurau end wurit qamar: “Segagam aninob quraum, munon nomon qur qebebi ariramour eng tau wurinou wogour, igama mi taui ba nubour. ");
INSERT INTO wnu_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","A yamangar qindou e ende ue, gari igemerei eng mom moan wasit ariramar eng. Bo ger igama mi ba me ninerei, end ne munon nomon qur qebebi ariramoun quraur eng wo wuritanamima,” ende wurinob qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yisas inorou munai aib eng wogub qoa ne wonou wuriimbig igoar munon eng ger der Yisas nob qamar: “Barai, mon aib e ge, nomon aib-aib e maigas bemeni big mindatemirei, sig uber ar.” ");
INSERT INTO wnu_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ende qamara Yisas nob qamar: “Mon aib nausi mindatemir eng gab qoaguruiman? Eng qen geret ar bapamimari nomon qamb eng gagar der ag oum inumetri igoriba.” ");
INSERT INTO wnu_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ende qamb wogub ne iri ai qaur nam Olib man nob end iramirei. Irab Yisas bugab igo Yerusalem inorou mon aib eng asi gab igoai. Ende igama ne wonou wuriimbigau munon 4-ende, unum Pita Yems ne Yon ne Andru ende wot yarab qebi qamamir: ");
INSERT INTO wnu_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Qen mait mon aib eng ombombanetorubour? Ne gor munai eng ende ebeiba Qenu mi maigas insirbiga in imbig igumune mi eng dibenara guboun?” ");
INSERT INTO wnu_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ende qamarari ne Yisas wurinob qamar: “Munon qei anmurimarubour, an qoyamet igoarar. ");
INSERT INTO wnu_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Qen geret munon ar irou diab ete qomorubour, ye, ye gari munon eng qamarari igub igoumon eng Qenu yiimurima anamar irib qamb doroum. Ende qamb munon yamangar irou anmurimarubour. ");
INSERT INTO wnu_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ne gor igunon eng munon ginam-ginam aib qamb yogurubour. Ende abari an qob toau igub qiet me yarimar, qen sindomund eng se qiren igoriba. ");
INSERT INTO wnu_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ne gor ai aib qamb uyab ne ginam qei qunumber qent igo aib qamb minemb umb ende ebet igorubour. Mi eng gagar dieriner eng yamangar qugurau igo qoaib qamb mogisqeret aruab igo gas ende oboubour,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ende qamb qamar: “Aninou gor imbig igoarar, Qenu wonou sarau baab qib igamari anba sarau qenen andab a wonou unum qamb qib igamari qen end mor isub aningaramb mi qob eng ansiorubour. Ansi ne anba bis gabman qiyo kaunsel munai mor end bisub sarau qenen andarubour. Eng obounor eng yonou munon qarau eng ende ansiourbour. Ende ansiarari gab eng an qob imbig munon aib eng wurinob qamarar.” Ende qamb ne qamar: ");
INSERT INTO wnu_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","“Yonou qob uber eng qomorunon eng is munon ginam gugum igub ugeari ne qen sindomund yariba.” ");
INSERT INTO wnu_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ne gor qamar: “Ende ansi ne an ye mom yiimbig igoumon end anba gabmant anamar isub qob musitarubari gab an daragab me abar, qob musub imbig wurinob qamarar. Qen end Qenu ne wonou Igomurur eng animbiga qomorunon eng wuri qob song-song qomorunor eng an misirt me igorinerei. ");
INSERT INTO wnu_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Qen boru eng yariner eng munon ger wonou umour qiyo umomt me iginerei, ar mot gabmant isub duimari ne sarau qenen utab ne waramari umiba. Ne wau ur ger waut me iginerei, ne munon wau ger wonou ur unor wurit me iginerei. ");
INSERT INTO wnu_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ne munon qei animbogounor eng yonou yuraut igamari animbag eng anqarausiorubour. Mi eng gagar gugum ende yara ne munon qei mi end me wot uburab isunor, yet mom igub igorunor eng Qenu wuriqubeima bebereg igorubour,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Ete gor qamar: “Mi boru aib ger inorou munai mor end deara gab an ai Yudia eng wogub iua yar ai qaur end irab igoarar. Meimi munon qob e wanunger gab eng qanam musub imbiginer. ");
INSERT INTO wnu_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","16","Mor isub igo gab qiyo ar ag bugab igo gab eng bo mor isub qiyo irab mi baub qamb misir me igar. Qand wogub iuar. ");
INSERT INTO wnu_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ne yamangar qurag igo qiyo wau se ba inau utab igamari qen eng yariner eng wuri borumisir igubour. ");
INSERT INTO wnu_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ende gab eng an Qenu wot qebi qamarari qugurau eng ya deriner qen eng anit me yarinerei. ");
INSERT INTO wnu_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Qen end munon irou quguragetorubour. Qugurau a qomon boru qoan gab igoun eng ne see gab igoun eng nob mi aib ue. Qen end qugurau eng yarab mom ubura ne bo sabar qugurau ger eng gas ende me anit yarinerei.” Ende qamb ne qamar: ");
INSERT INTO wnu_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","“Qen eng Qenu me pitensieriner eng munon ag gugum mom umb uburubour. Eng gab ne wonou munon yurau wurimaribigor eng wurit igub qen eng pitensieriba.” ");
INSERT INTO wnu_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ne bo qamar: “Munon qei der anit ete qomorubour: Qenu munon anit maribigor eng anubersierib qamb darab end igo.” Ende qamarari gab an igatar wagar. ");
INSERT INTO wnu_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","23","Qen end munon qebebi der in qoyam munon qiyo anubersiau munon qamb dibent anwarigesi sarau wes-wes baab abari an ibag eng segagam qi qamb Qenut igub igoumon eng wogunon eng qoyamet igoarar. Eng ende obounor eng Qenu wonou yurau eng gor misir qebebi igunor eng yonou qob mom musub wot oabig igorunor eng wuri uburab me isunorei. Qen boru eng yariner qamb an mom qoyamet igoarar qamb animbigoum eng.” ");
INSERT INTO wnu_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ende qamb ne qamar: “Qen boru eng yariner eng uburib pisia worom me asieminerei, inaun gor me gunanei, ");
INSERT INTO wnu_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ne tapai qamb eng nerer deriba, a tat ai qamb eng gugum uyab undounder uburiba. ");
INSERT INTO wnu_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Mi eng gagar ende aba gab igamari Munangit wau eng waber ten dara begen qiribiten guboumon. ");
INSERT INTO wnu_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ende aba gunon eng enger wuriimurima munon ginam-ginam isub yonou munon yurau eng sir-sir oromar diorubour.” ");
INSERT INTO wnu_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Ende qamb qamar: “Namt big qemerine igar, an togun wara gab eng ai sigenimba ende qamb igo gunon eng qeemben ende di igo. ");
INSERT INTO wnu_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Eng gas ende, qen pi bura eng qugurau eng gab igamari qen eng dieriba. ");
INSERT INTO wnu_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Munon yamangar se igom igour eng qei me umb uburunorei igama qen eng dieriba. ");
INSERT INTO wnu_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ende ebet ne ai tat nob bo me igorunorei, mom uburubour, a yonou qob tau ger bais me uburinerei,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Qob eng ende qamb wogub ne qamar: “Mi eng gagar diorunor qen eng munon ger qoyam ue. Qenu wonou munon yurau wo qani igour eng enger eng wuri qoyam ue, ne ye Qenu wonou wau ten gor ye qoyam ue, tain wonou gari qas mi gugum gumutumaieminer eng imbig igo. ");
INSERT INTO wnu_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","In gugum qoyam ue end ne an qenen qoat qoyamet igoarar.” ");
INSERT INTO wnu_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ende qamb qamar: “Qob ger mit big qemerine igar: Munon ger ai pa qoaib qamb sarau qerei wonou sarau munon gari-gari wuriimbig wogub qorei. Qoaib qamb ger nob qamara tend mom qoat igama bo yar gin qamb qamarei. Ende at wogub isorei. ");
INSERT INTO wnu_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Eng gas ende an mom imbig pisi igoarar. Mai qiyo, ai gab-gab qiyo itum wobon derini qiyo, mai ai uter tubub deara qiyo a uriger ubura qiyo. ");
INSERT INTO wnu_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","End ne an song ar igamari ye qand derine an gegirunon qamb ende qemerine imbig igoarar qamb quraum. ");
INSERT INTO wnu_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ye aninob quraum eng munon ginam-ginam gor igub imbig pisi igorunor,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Qen end munon baraitari Qenu munai qoat igour eng nob Moses qomon wuriimbig igour eng nob qiumuni qamb tap ger gab Yisas baab waramb qamb ebetemirei. Munon soro ar igunor qamb wabi ebetemirei. Wuri mi bingen qamb Yerusalem end at nub ebetemir eng qen ombur-ombur gari igoai. Munon gugum is end qiumunimunor end, Yuda wuri mi bingen eng at nub igour eng ete qamb igour: “Qenu wonou yurau enger eng tain qoanb me igaramau end mismisirun,” ende qamb igour. Mi eng nub igour eng mani parau yis ue ar tor nub igour. ");
INSERT INTO wnu_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Munon baraitari aib eng qiumuni ete qamamir: “Mi niau qent munon aib qamb qiumunimunor qen end Yisas baab waramb qamb oboun eng munon qei ininob yogurubour,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Qen end Yisas wo git Betani ite munon qoan iam qarat nob igoar eng unum Saimon eng nob igoai. Ende igo mi nub igamari ne yamangar ger welya buturt igoar eng qogom sig uter maieng (nomon qur aibt baub igour) eng ba yar-yar it omboat Yisas tarit wot igiamorei. ");
INSERT INTO wnu_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ende aba gab ne munon qei misiringet wurinou qob-qob qamamir: “Welya eng nomon qur aib, eng ar meimet isi biigi igo. ");
INSERT INTO wnu_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Waga munon wurisab nomon qur K300-ende taui ba in bo mani gab ba munon minemb igour eng wurisau ue?” Yamangar ende mindigar qob wot qamb wogub dibes qamat qamamirei. ");
INSERT INTO wnu_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ne Yisas wurinob qamar: “Wagari, yamangar eng yet igub yeubersi abar eng. Meimet qamb qamat qamb igoumon? ");
INSERT INTO wnu_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Aninou misirt munon boru wuriubersiorub qamb eng ende abar, ego ye bo qenen me aninob igorinei. ");
INSERT INTO wnu_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Yamangar e ye umibam end ne wonou welya end yemirorisab aba. ");
INSERT INTO wnu_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","End ne segagam aninob quraum: Qob uber e animbigoum eng munon ginam-ginam isub wurinob qamarari yamangar yet qomon uber abar eng gor munon yamangar gugum musub igunor,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","11","Qamara wogub ne Yisas wonou imbigau yurau munon 12-eng ger unum Yudas Iskariot eng der munon baraitari Qenu qomon qoat igour end wurit isub Yisas dui qamara igub borusi mom mismisiramirei. Ende at wogub wo nomon qur uber bainer eng maribigumirei. Ende abari ne Yudas tap sarog gab Yisas mirimausi imurimine waramar qamb qanam bigorei. ");
INSERT INTO wnu_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ne qen qamart Pasova end mi aib qamb at nunor end wai sipsip waramb arsi igurei. Ne Yisas wonou imbigau yurau eng yar Yisas qebi qamamir: “In is munai eret mi arsioruboun?” ");
INSERT INTO wnu_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ende qamarari ne wonou yurau end munon ombur wuriimurimb qamb qamar: “An ombur ginam aib end weib isub gunon eng munon ger ya garan togor isub igama gab eng nob isar. ");
INSERT INTO wnu_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Isi yarab wonou munai mor isiba gab eng an ete nob qamarar: Ininou imbigau munon eng init ete qurai: munon ger gab nob qamarari munai animbiga mi end arsi igo wonou wuriimbig qib igo yurau eng nob mi end niba. ");
INSERT INTO wnu_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ende nob qamarari ne wo anamar mor isub munai tumbigi ger erer eng ansirbiga ne an mi end arsiarar. Munai tumbigi eng sarog munon qebebi bugab mi niau uber igo.” ");
INSERT INTO wnu_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ende qamb ne ombur wuriimurima gigi Yerusalem umo isumirei. Isub gamir eng Yisas qob qamar gas ende gab bo me abau, ar end mi arsi igurei. ");
INSERT INTO wnu_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Arsi igamari ne worom nerima Yisas wonou yurau tau eng wuri nob isub ombur mi arsi igour end isumirei. ");
INSERT INTO wnu_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Isub erogori Yisas nob bugab mi numirei. Mi nub igo ne Yisas der qamar: “Erogori e bugab mi nub igoun eng erobon ete ger der isub munon qarau wurinerub dieriba.” ");
INSERT INTO wnu_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ende qamara ne wuri borumisir igumirei. Igub gari-gari der Yisas nob qamamir: “Your, ye qiyo?” ");
INSERT INTO wnu_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ende qamb bisari Yisas der qamar: “Munon eng ye nob ombur mi nuboun eng.” ");
INSERT INTO wnu_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ende qamb ne wonomit qamar: “Qenu munon qei wurinob qamara qob qoan gumatemir eng Munangit wau toat ende siorubour. Eng ye Munangit wau end munon ger munon qarau wuriimbiga yanambour. Ende yesi igamari qen geret Qenu taui munon eng sig borusi quguragsieriba. End ne munon eng unor set baia umb igo ende qi eng qugurau eng me ga qi,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ende bugab mi nub igamari ne Yisas mani parau ger ba Qenu qamb ne boroumi wurisab qamar: “An ba niar. E yonou min.” ");
INSERT INTO wnu_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","24","Ende qamb ne bo wain ya ger qogumt wari Qenu qamb wogub wurisab qamar: “Ya e yonou qeru, an ba niar. Qeru e yet isar eng munon gugum wuriubersieriba. Ye qeru e isar eng Qenu qoan qamb nausier eng mom irimanima. ");
INSERT INTO wnu_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ye ete aninob qemerin: wain ya e ye bo sabar me ninei, igoi qen geret Qenu wonou bibis biga ne wain ya bubun bo nibam.” ");
INSERT INTO wnu_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ende wurinob qamb wogub ne uru wab wogub ai qaur nam Olib man aib igo end iramirei. ");
INSERT INTO wnu_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","End irab ne Yisas wurinob qamar: Itumorama an gugum yet misir me igunanei, yewogub qoauboumon. Qoan Qenu munon Sekaraia nob qamara gumater gas ende. Ete qamarei: Wai sipsip oroar igo eng waramine ne wai git eng yari bunumban iua uburubour. ");
INSERT INTO wnu_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ende qamb ne bo qamar: “Ye umine tain bo yemenima igom der bugab gigit ya tai Galili end isub igimine an qanam yaruboumon.” ");
INSERT INTO wnu_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ende qamara Pita der qamar: “Eng ende aba qei apand newogub yari qoounor qiyo? Ye eng segagam me newogub qoainei. ");
INSERT INTO wnu_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ende qamara Yisas bo der nob qamar: “Git eng ende quran ego qen ombur gari ende ne yet ete qemeriban: munon eng ye sir ue, ende qamb iginen eng teteri qarig qen omburt eriba.” ");
INSERT INTO wnu_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ende qamara Pita bo der gagam ar qamar: “Apand nonob quraum, in ombur ar umuboun, me nowabi qemerinei, sig ue.” Ende qamara ne yurau qei eng der Pita qamar gas ende gari nob qamamirei. ");
INSERT INTO wnu_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Eng ende qamb wogub ai Getsemani end isumirei. Isub ne Yisas wonou wuriimbigau yurau eng wurinob qamar: “An ete igamari ye qirat isub Qenu simot qamb gab.” ");
INSERT INTO wnu_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ende qamb isib qamb Pita ne Yems Yon ende wurimar isorei. Is qataben oau mom borumisir igub wogub munon ombur gari eng wurinob qamar: ");
INSERT INTO wnu_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","“Ye mom borumisir igub ne mom yari umib misir igoum. An ete igo qoyamet igoarar. ");
INSERT INTO wnu_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ende qamb ne ete wuriwogub wesopur qitat end irab oau uiebig inab ur simot qemerine tap gab yewabiom qamb. ");
INSERT INTO wnu_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ende irab ur nob qamb qamar: “Tain, ye mom borumisir igoum, oau yemeinsi. Ya uyeriri boru qogumt e ni qamara gab eng nini. Eng ye ar neqebi quraum. Nonou qenungau qas.” ");
INSERT INTO wnu_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ende qamb wogub yar ibagar ego munon ombur gari eng qoan naat inemirei igurei. Ende ibag Pita nob qamar: “Saimon, ne meimet inab igoan? Bais ig-ig inau ue?” ");
INSERT INTO wnu_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Pita wonou sir ende qamat qamb wogub, bo soroi qamar: “An qoyamet igo ye Qenu simot ab qib igoum eng an gor ende abar, inab igo qomon ger yara mai obouboumon? Git eng aninou misir eng ye yetaut ebeini qamb abar eng aninou git goan eng anquguragsia ebet igoumon. ");
INSERT INTO wnu_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ende wurinob qamb wogub bo isub ur simot arei. Qob gigi qamar gas ende bo nob qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Eng ende qamb wogub bo yar ibagar eng wuri bo naat inab uburemirei, mungam sig borusi igara inab igurei. Ende yar ibegea qob ger me nob qamarau. ");
INSERT INTO wnu_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ende ibag wogub bo is Qenu simot ab wogub yar ibagar eng gor ende sig at igurei. Ne wurinob qamar: “An mungam mom inoumon eng qen boru qamb igoum eng munangit wau booub qamb diaur quma. Munon yimirimot yebanamsiaum qamb at qiriner eng ye yebaab munon boru wurit yiimurimb qamb dia. ");
INSERT INTO wnu_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Der bogomari isub gun,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ne munon baraitari Qenu munai qoat igour eng ne Moses qomon wuriimbig igour eng ne munon barai-barai qei der munon yurau wuriimurimari qauri qemi ne qombuni ba diamirei. Eng Yisas wonou wuriimbig qib igoar eng munon ger isuor eng unum Yudas. Wo munon yurau wurineri ba diarei. ");
INSERT INTO wnu_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Dierib qamb wurinob qamar: “An ye qas yegab igoarar. Irab wo qani isub ubent baab ebine gab ne eng qamb diab baab nob yarun,” ende qamb wurinob diarei. ");
INSERT INTO wnu_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yisas wonou wuriimbigau munon eng ende wurinob qobub igama Yudas diab qamar: “Barai,” ende qamb ubent barei. ");
INSERT INTO wnu_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Bea gab munon yurau aib eng yar Yisas bamirei. ");
INSERT INTO wnu_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ende beari gab wonou wuriimbigau munon ger der qasuri beneri munon aib ger wonou sarau betet igo munon eng iruges ig soaburamorei. ");
INSERT INTO wnu_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ende aba ne Yisas munon qarau eng wurinob qamar: “Mai, ye mi urim anit nub igumei igama yanamb yourimb qamb qombuni ba diaumon? ");
INSERT INTO wnu_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ye qenen Qenu mon aib end erogori igo munon qei wuriimbig igoum ego ende yesiau ue, mai at igumanei? Qob qoan gumatemir eng see mi git gaun eng.” ");
INSERT INTO wnu_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ende qamara wonou wuriimbig qib igoar eng wogub qoamirei. ");
INSERT INTO wnu_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","52","Ne Yisas mot isari wau moi gari qas mi goan qumani wogub wurinob isub igoai. Isub igama gab baab birupesimari qoa wogub mi goan qas wot beasi baiari wo git itum end ararau qi qorei. ");
INSERT INTO wnu_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Yisas bis munon baraitari Qenu munai qoat igo eng wonou munai end isumirei. End isa ne munon uru wab qomon qerei igour eng nob qomon imbig igour eng nob yar qiumuniamirei. ");
INSERT INTO wnu_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Qen end Yisas nob isari Pita gor worotoar isuor eng wo mugenderi igoai. Igo ne bo qi isi Yisas nob igour munai eng qani end munon qei tend qoat igour eng wurinob mut qoariget igoai. ");
INSERT INTO wnu_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ne munon aib-aib eng Yisas qob ger mai qamara igub igurei qi eng bo ende qamb musub waramb qamb wurinou qob suab igurei. ");
INSERT INTO wnu_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ende qamarari ne munon qei der naget wurinou misirt gag-gag qamamir eng wurinou qob qamamir eng qeemben ger me qamarau. ");
INSERT INTO wnu_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ne qei der misirt qetopur wot big qamamir: ");
INSERT INTO wnu_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“In igumin eng ete qamarei: ‘Inorou munai aib eng munon ubent mindatemir eng ye bo bapami qen ombur gari ende mindat boopurambam. Qenu munai mindain eng wonou wes, munon ger ende me mindainerei.’ Ende qamar eng mai qiyo?” ");
INSERT INTO wnu_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Munon qei der Yisas qob eng metes wot qamamir eng qei der ende ue qamb qob ger metes wot qamamirei. ");
INSERT INTO wnu_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ende qamb at igamari munon aib eng wobont der naget Yisas qamat qamar: “Munon qebebi ne qebi quraur eng ne ger taui me wurinob qemerinenei ii? Ne qob ue e?” ");
INSERT INTO wnu_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ende qamar eng Yisas qob ger me nob qamarau, urisinub igama ne bo qebi qamar: “Maigas, ne munon Qenu in Yuda boru igumune init niimurima der inubersieriba qamb nemaribigor eng, end ne ne Qenu wonou wau ten qiyo?” ");
INSERT INTO wnu_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ende qamara Yisas qamar: “Eng gari nonou quran eng. Qen geret Munangit wau gunon eng Qenu uberegent bugab igo ne Qenu wonou gagam eng yet isa ten derine guboumon.” ");
INSERT INTO wnu_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ende qamara munon aib Qenu munai qoat igo eng igub borusi mom outet wogub mi goan nob boobur arir wogub ete qamb ar: “Munon ger bo sabar qob ger me qemeriner. ");
INSERT INTO wnu_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Qenu qob soagensi qamara mom diban gugum igoun e. End ne qob qamb wot mai sioruboumon?” Ende qamara ne gugum uben bemeni qamamir: “Munon eng Qenu qob isi qurar eng gab mom umb qas weginer.” ");
INSERT INTO wnu_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ne der nogumor wot tumiamir, a qei der mag taisi mi goant touri wogub ne waramb wogub bo beasimetet qamamir: “Ne qoyam end your nanamai qi eng sir gumat qamara gun e?” Ne munon eng oroar igour eng der mataisi waramb gab qiyo ende-ende atri igurei. ");
INSERT INTO wnu_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Ende ebet igamari ne Pita wo ag end naget mut qoariget igoai. Igama ne Qenu munai qoat igo munon aib eng wonou sarau yamangar eng Pita qani yarab nan gab qamar: “Ne gor Nasaret munon Yisas eng wonou yurau qii?” ");
INSERT INTO wnu_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ende qamara ne Pita der qamar: “Ne qob quran eng ye me imbigoum.” Ende qamb ne iua is qonut iret naget igama ne teteri qamar arei. ");
INSERT INTO wnu_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ne yamangar eng munon qei wurinob qamar: “Wa, munon qira Yisas wonou munon ger yarai igo qii?” ");
INSERT INTO wnu_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ende qamara munon eng gab ebetemir e Pita bo qamar: “Apand quraum.” Ende qamara wuri der qamamir: “Git ende, ego ne qob qamara mindiram goten igoun eng ne Galili munon mindiram goten gas ende igoun.” ");
INSERT INTO wnu_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Tandari ende qebi igamari Pita misiringet qob isi qamb wurinob qamar: “Segagam, munon eng quraumon eng ye sir ue.” ");
INSERT INTO wnu_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ende qamara teteri bo arei. Ara ne Pita Yisas qob qoan ete nob qamar eng misir igorei. “Ai urigeremb pisia teteri qen omburt ara ne ne der qen ombur gari ende yete, ‘munon eng ye qoyam ue’ ende qemeriban.” Yisas qob eng Pita nob qamar eng qen end misir igub wogub borusi eab igoai. ");
INSERT INTO wnu_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ende at igamari igoi urigeremb pisia ne munon baraitari Qenu munai qoat igour eng ne munon qomon qoat igour eng ne Yuda munon aib-aib eng ende Yisast qob qamb nausi wogub uyort uben touri wogub imurimari Pailat wot isorei. ");
INSERT INTO wnu_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","End isa ne Pailat Yisas qebi qamar: “Ne Yuda munon yamangar gugum wurinou baraitari gigit igoan eng ne qiyo?” Ne Yisas qamar: “Wo mai, nonou gari quran eng, ye munon eng gari,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Qen end munon Qenu munai qoat igour eng Yisas qob meten wot qamamirei. ");
INSERT INTO wnu_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ende qamb abari ne Pailat Yisas bo qebi qamar: “Maigas, qob qebebi neborusiorub qamb nenet meten qamb igour eng ne ger taui me wurinob qemerinenei i?” ");
INSERT INTO wnu_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ende qamara ne Yisas qob ger bo me nob qamarau. Yisas ende aba gab Pailat misir qebebi igorei. ");
INSERT INTO wnu_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Togun gugum Yuda wuri qen aib Pasova end mi nub abari Pailat wuri mismisirar qamb munon ger uyort igama qen end wuriimurima isub igour. ");
INSERT INTO wnu_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ne bo qen end munon ger unum Barabas wo uyort igoai. Eng wo munon qei wurinob gabman sarau end sai qob qamb ne munon qei igarama umari wogub ne wo ba uyort bigumirei. ");
INSERT INTO wnu_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ne munon irou yar qomon eng ebet igour gas ende ebet Pailat nob qomurune munon uyort igour eng ger wuriwog qamb ebetemirei. ");
INSERT INTO wnu_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ende abari ne Pailat wuriqebi qamar: “An ye Yuda wurinou munon baraitari gigit igoar eng wugine anit isiner qamb misir igoumon qiyo?” ");
INSERT INTO wnu_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Eng munon aib-aib qomon qoat igour eng Yisast misiringet waramb ebetemir eng wo gag qebi qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ende qamara ne munon baraitari wuri munon yurau wurinob qamamir: “Arari Pailat Barabas init waga yariner,” ende qamamirei. ");
INSERT INTO wnu_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ende arari ne Pailat qamar: “Git eng ende igoum eng munon an Yuda wurinou munon baraitari wot qamb igoumon eng ye mai sieribam?” ");
INSERT INTO wnu_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ne wuri qamamir: “Nam tenori big waramari uminer.” ");
INSERT INTO wnu_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ende arari ne Pailat qamar: “Wo meimi qomon boru ger ebeterei?” Ne wuri qugiab amir: “Mom nam tenori big waramari umb qas weginer.” ");
INSERT INTO wnu_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ende arari ne Pailat munon misir wuripomaimsi Barabas wurit waga isa ne Yisas yogorau munon yurau end imurimine isa pisirami waramb sumungasi wogub bisi yarab mom nam tenori big waramari uminer qamb imuriamorei. ");
INSERT INTO wnu_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ende wurit imurima ne yogorau munon Yisas mot gabman wurinou munait end isub yurau qei wurit orune yar gaiar qamb amirei. ");
INSERT INTO wnu_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ende at wogub ne mi goan mian nob ger ba Yisas qumanimetet ne uyor qer nob ger ba munon baraitari wurinou mebir gas ende barsitet tarit end bugamsitemirei. ");
INSERT INTO wnu_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ende at wogub ne ber qob nob qamamir: “Ie, ne Yuda wurinou munon baraitari gigit igoan qiyo?” ");
INSERT INTO wnu_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ende qamb qombuni ba yar tari qer omboipi, a wot tumi gab, a ne aib qamb gag wot gamaur wat bugab, ende ebet igurei. ");
INSERT INTO wnu_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Eng wot igerig ende at wogub bo mi goan mian nob qumanimetetemir eng beasi wogub bo wonou mi goan eng qumanimetetemirei. Ende at wogub nam tenori big waramb qamb mot isumirei. ");
INSERT INTO wnu_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Isi qataben gamir eng Sairini munon ger unum Saimon, wo Aleksander Rupus nob wurinou ur. Wo Yerusalem umo isib qamb di igoai. Ende gab ne Yisas nam togoramor eng bai qamb sesimot igamari baurei. ");
INSERT INTO wnu_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Baia ne ai qaur unum Golgota end isumirei. (Unum Golgota qanam eng ete: Munon tari qer) ");
INSERT INTO wnu_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","End bisub ne nam qen tenori big waramune uter weriner qamb wain ya mi ger ‘mir’ qamb igour eng nob biiges utemir eng Yisas me niau. ");
INSERT INTO wnu_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ende aba wogub baab nam qen tenori erer big waramirei. Ne yogorau munon Yisas wonou mi eng gagar baub qamb saub your ger wotanami eng bainer qamb ebetemirei. ");
INSERT INTO wnu_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Yisas big waramir eng itumut worom erer eitet diarei. ");
INSERT INTO wnu_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ende igama ne nam ii ger ba Yisas wo qanam at waramir eng ete qamb gumatemirei: YURA WURINOU MUNON AIB ende qamb gumat wogub tarit erer end big waramirei. ");
INSERT INTO wnu_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Yisas big waramir eng wobon et igama munon ombur yogub qiyo mi urim ba at qib igamari igaramir eng ig-ig et wurinagasiamirei. ");
INSERT INTO wnu_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Qenu qoan ir qamara munon ger gumater eng ete: Munon eng munon boru-boru eng wurinob umiba, ende qamar eng see irimanima gaun eng. ");
INSERT INTO wnu_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Yisas ende igama ne munon tap tog isi umo iri ite qib gab ber qob nob ete qamb-qamb qib igurei: “Wa, munon eit Qenu munai aib qen irout mindatemir eng wobo bapami qen ombur garit mindaib qamara igumine mai ebet igo? ");
INSERT INTO wnu_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ne munon gagam ende gab eng nam tenori big nanamour eng nonou beneri ag dara gune e?” ende qamb-qamb qib igurei. ");
INSERT INTO wnu_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ne munon baraitari aib-aib Qenut mian yab igour eng ne qomon imbig igour eng gagar der wuri gor ber qob wot qamamir: “Munon eng der in inubersieriba qamarari igub igoun eng, ende gab see wonomi ubersi in gor inubersieriner. ");
INSERT INTO wnu_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Qi wagari, Qenu munon inubersi qamb imurima darab ininou munon baraitari igoar eng eita a? Qand beneri ag dara gab in ‘io’ qomorun.” Ende qamarari ne munon boru ombur ig-ig wuri uriamir eng gor der Yisast ber qob qamb ende ebet igurei. ");
INSERT INTO wnu_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Yisas ende igama igoi worom ginam tog yarab ne ai gugum ituramorei. Itumor ende igama worom isi qumat darab ne bo urigeramorei. ");
INSERT INTO wnu_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Urigeremb pisia igumir eng Yisas qugiab ete qamb arei: “Eloi Eloi, lama sabaktani.” Qob eng qanam eng ete: “Qenu, meimet qamb yewagan qiyo?” ende. ");
INSERT INTO wnu_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ende igub ne qei der qamamir: “Wagari igun, Qenu wonou qob gigit qamarau munon Elaiya wot ara qii.” ");
INSERT INTO wnu_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ne munon ger uyab-uyab isub mi goan ger ba ya uyeriri boru ger yaninget wogub ya ten ba yar gotaut yosi erer qite utune sisigot ni qamb utab qamar: “Wagari qi gab igorun, Elaiya wot arar end darab nerimeteiner qi?” ");
INSERT INTO wnu_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Gab igamari bo qugiab ab wogub umorei. ");
INSERT INTO wnu_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Uma wogub mi goan gurum aib inorou munai tumbigi ger sig qau eng opur uriamir eng met qitet quburab isi qumot waseramorei. ");
INSERT INTO wnu_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ne Rom yogorau munon aib ger Yisas big waramari qoat naget igoar eng Yisas uma mi eng gagar ende aba gab qamar: “Apand, munon e Qenu wonou wau ten,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Qen end Maria Makdala yamangar eng ne Maria ger Yems Yosep nob unor eng ne yamangar ger Salome ne yamangar qei erogori wuri Yisas qoat mugenderi naget gab igurei. ");
INSERT INTO wnu_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Yamangar yurau eng Yisas Galili end sarau baab qiroa ubersi nob qib igour eng ne Yerusalem yamangar yaremir eng erogori igurei. ");
INSERT INTO wnu_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ne Arimatea munon ger unum Yosep, wo gor end igoai. Munon eng wo Yuda munon qomon qerei qob qerei igour eng wurinou erogori, ego wo misir uber igoai. Igo Qenu munon Isrel wuriubersi qamb imurima deriner end misir igub qoat igoai. ");
INSERT INTO wnu_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Munon eng Yisas ende uma gab ne barim eng Yuda wurinou inorou qen end munon mumun ag igoriner eng boru end ne wo ai gab-gab Pailat nob qemerib qamb isorei. Isib qamb Pailat wot yariamor ego qigimiet isorei. Isub qamar: “Mai, ye isub Yisas umar e mumun bis tumuniemini qiyo?” ");
INSERT INTO wnu_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ende is qamara Pailat qiet qamar: “Ie, Yisas qand umai i?” Ende qamb ne yogorau munon gigit eng wot ara yara nob qamar: “Segagam Yisas umai?” ");
INSERT INTO wnu_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ende qamara yogorau munon eng musub mom qamara igub wogub Yosep Yisas mumun bis tumuniom qamb qamara isorei. ");
INSERT INTO wnu_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ne Yosep isub mi goan oan nob ger nomon qurt taui ba isub Yisas mumun nam erer igoar eng beneri ba ag big mi goan end suumi bis tumun erobon big wogub ne nomon aib ger ba yar tumun qabar qipiot wagerei. ");
INSERT INTO wnu_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Eng ende abari ne yamangar eng, Makdala Maria eng nob Maria ger Yosep Yems nob unor eng, ombur Yisas tumunimari musub mom gab imbig igurei. ");
INSERT INTO wnu_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Maria Makdala nob Maria Yems Yosep nob unor eng Yisas ende tumunimari musub gab imbig wogub isub inemirei. Sarere itumorama inorou qen eng pura ne yamangar ger Salome eng nob ombur gari ende mind munait isub welya qogom sig uber eng baub igo Sande itum der irab Yisas bieriner qamb wot igimb qamb welya eng ba arsi igurei. ");
INSERT INTO wnu_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ende arsi wugumirei igo Sande itum qire der munon teteret iramirei. ");
INSERT INTO wnu_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Qataben ir igo wurinou qob-qob qamamir: “Wa, irune your nomon qugurau aib tumun qabar qipiotemir eng weimatara gitgoan ubersioruboun?” ");
INSERT INTO wnu_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ende qamb ir-iri qani diab gamir eng nomon qipiotemir eng wei wogub ba qiesi bigumirei igama gamirei. ");
INSERT INTO wnu_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Gab ne tumun erobon isub gamir e munon moi ger mi goan oan nob qumaniamorei ig uberegent end bugab igama gab borusi qiet yariamirei. ");
INSERT INTO wnu_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ende gab yarimari ne wo der wurinob qamar: “An me yarimar, Ye animbagaum eng an Nasaret munon Yisas waramari uma e tumuniamir eng et igo qamb gub qamb diumanei. Wo e me igo, der bugab qoai. Up qas igo e gaiar.” ");
INSERT INTO wnu_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ende gab ne qob e aninob quraum eng bis Pita nob qamb ne yurau qei eng gugum wurinob ete qamarar: “Yisas qoan me umaut igo wurinob qamar eng wo gigit is Galili yatai end igama gubour.” ");
INSERT INTO wnu_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ende qamara ne borusi yari wogub munon ger qob nob me qamarau. Nogom wurigomotopurama wogub ar saaneri uyab-uyab isumirei. ");
INSERT INTO wnu_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yisas Sande itum der ende dari ne qen qamar opur Maria Makdala qoan aibigau 7-ende wot isorei igama Yisas musuor eng wot dibentarei. ");
INSERT INTO wnu_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ne Maria isi Yisas wonou munon yurau wuriimbig qib igoar eng is ibagar eng wuri Yisast oau boruburab toubet ende ebet igurei. ");
INSERT INTO wnu_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ende at igamari ibag wurinob qamar: “Wa, Yisas qoan der bugab qib igama gab wogub yoroum.” Ende qamara ne wuri der apand me qamarau. ");
INSERT INTO wnu_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Qen end qas munon ombur-ombur ginam eng wogub tap isub igamari Yisas wonou wes at diab wurit dibentarei. ");
INSERT INTO wnu_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ne bo munon ombur eng bo isub Yisas wonou yurau wurinob qib igoar eng Yisas gaun qamamir eng gor apand me qamarau. ");
INSERT INTO wnu_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Sande itumorama ne wonou yurau wurinob qib igoar 11-ende erogori bugab mi nub igamari wobont weib diarei. Diab oromar qamar: “An ye igom der bugab munon yamangar qei wurit dibenerine yegab yar aninob qamarari meimet qamb yet me oabigau?” ");
INSERT INTO wnu_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ende qamb ne bo qamar: “See qas an gugum dari ne munon ginam-ginam isub yonou qob uber e animbigoum e wurinob qamarari igunor. ");
INSERT INTO wnu_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Igub yet oabigari eng yonou unumut ya obotar wurimaragansiarar ende at igamari wuri bebereg igorubour, a yet me oabigunor eng Qenu wuriqerei mutet wuriariramba,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","18","Qamb ne ete gor qamar: “Ne gor munon yet oabigunor eng munon ger mi wot isinerei igama eng ar qamarari uberburiba, a qob bubun eng ar qomorubour, a mani uter orogora eng me umunorei, a ya boru munon nub umb igour eng gor nub me umunorei, ne munon toar nob gab uben benerimari uber burubour. Munon yet oabigunor eng mi eng gagar abari ibag imbigubour,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Munon aib Yisas ende qamb waga ne Qenu wonou bo mot erer qite irab uberegent wes end big nonogursiarei. ");
INSERT INTO wnu_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ende iroa wogub ne Yisas wonou munon yurau wuriimbig qib igoar eng munon ginam-ginam iua Yisas qomon qiyo qob uber wuriimbigor eng wurinob qamb qib igurei. Ende abari ne munon aib wurinonogursia ne mi wes-wes aba wogub munon qei imbigar qamb ende ebet igoai. ");
INSERT INTO wnu_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Io Tiopilus in munon qei Yisas nob qib mi irou ebetri igoar end munon yamangar imbigar qamb warigesi gumatemirei. Eng munon qei magqurt mi gamir eng qibi munai ginam-ginam qob uber qabarit wurinob qamb igour eng gari. ");
INSERT INTO wnu_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","End ne ye gor qob qamarari igub ne bo mi gugum musub imbigib qamb munon qei wuriqebi gamei. Qebimine Qenu mi qanam big ebeteriamor eng isi yarab see ebet igo eng yenob dibes qamarari igub qeemben gab ne mi gugum taut gumotoum eng. ");
INSERT INTO wnu_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ye eng nonob quraum eng qob gigit nonob qamarari igon eng apand ar. ");
INSERT INTO wnu_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Qen end munon ger unum Herot wo Yuda yurau oroar igoai. Igama munon Pris ger igoar eng unum Sekaraia. Munon pris wurit qamb igour eng Qenu munai qoat mian iset bigetet igour. Sekaraia wonou ur namungur unum eng Abiya, wonou ubeni unum Elisabet, wo gor pris wurinou yurau tumbigi end gari. ");
INSERT INTO wnu_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ombur qoregen ende igo Qenut qas igub wonou qomon toat ende at igurei. ");
INSERT INTO wnu_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Qen end wuri wau ger ue, ar igoi wogub isigi buremirei. ");
INSERT INTO wnu_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Qen geret Sekaraia wonou yurau Qenu sarau betet igamari wo gor sarau eng ebet igoai. ");
INSERT INTO wnu_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ende at igama wo mom pris sarau eng apand eb qamb maribigari is munai tumbigi qau end isub Qenut mi qogom uber mutet wara iroa ig qamb. Ende abari wo der Munon aib munai Tempel end isorei. ");
INSERT INTO wnu_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Qen eng mi qogom uber isiau qen, end ne munon irou yar ag end igo Qenut qebi qamb igurei. ");
INSERT INTO wnu_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Igamari Sekaraia wo mor igo mi qogom iset igama Munon aib wonou enger ger der mi isia oab igoart ig uberegent wes end naget igoai. ");
INSERT INTO wnu_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Igama Sekaraia wo gab qiet yariamorei. ");
INSERT INTO wnu_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Yarima enger der Sekaraia nob qamar: “Sekaraia, ne me yariom, ne Qenut qebi qamb igoan eng igub igo. End ne nabeni Elisabet wau ger baiba, baia unum Yon ende qem. ");
INSERT INTO wnu_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ne wau eng gab borusi mom oau uberet mismisiroa munon ar gor wot mismisirubour. ");
INSERT INTO wnu_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Wo Munon aib wonou munon baraitari igoar qamb maribigiba. Maribiga igo wain ya qiyo ya uter me ninerei. Unor qurag igama ne Igomurur qau wot igoriba. ");
INSERT INTO wnu_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Wo Isrel munon yamangar irou oromar qamara igub wurinou qomon boru mogirt wab wogub Munon aib Qenu toat igorubour. ");
INSERT INTO wnu_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Wo qoan Qenu Igomurur qau wonou qob gigit qamarau munon Elaiya wot isa nonoguret end mi sigub igoa gas ende Yon gor ende at Munon aib tap gigit imotet isiba. Wo qob qemeriner qen end Yuda munon qoan wurinou qanam erogori me qit igub igamau eng bo qanam musub imbig bo qibanamsi igorubour. A munon qei suai qob qamb igorunor eng wurinob qamara igub munon qoregen wurinou qomon taut igorubour. Ende at ne Munon aib deriner end wot igub girinet tug igorubour.” ");
INSERT INTO wnu_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ende qamara Sekaraia der enger nob qamar: “Qob eng ye maigas at imbig apand qemeribam? Ye mom isigi ne yabeni gor isigi end quraum.” ");
INSERT INTO wnu_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ende qamara enger der qamar: “Ye unum Gabriel, ye Qenu menmant end igoum end yiimurima qob uber eng nonob qemerib qamb durumei. ");
INSERT INTO wnu_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ne ye qob apand mi ende net dieriba eng der nonob qemerine ne me oabigan. End ne, ne qob bo me qemerinenei, mindiram tuumot igama igoi ye qob eng gagar nonob quraum qen eng yara giban.” ");
INSERT INTO wnu_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Munon ag igour eng Sekaraia mor isuor eng qand me dara gab, “eng meimi ebet igo” ende qamb igurei. ");
INSERT INTO wnu_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ende qamb igamari darab qob ininob qamara igun qamb gamir eng ue. Ubent qas mi wuriimbig ende aba gab eng mom inig mi boru ger gab wogub der aba qamb wugumirei. ");
INSERT INTO wnu_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ende at wogub Sekaraia wonou sarau tatau tempel eng igoar eng mom at ugab wogub ginamt isorei. ");
INSERT INTO wnu_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Is igama qen qei ubura ubeni Elisabet qugurau igo bo ag der me qib igamau. Mor sir igama inaun 5-ende umorei. ");
INSERT INTO wnu_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ende aba Elisabet qamar: “Ye qenen ar igo qinining qib igimine see qas Munon Aib yet igub yesia qurag igoum end song qib igoribam,” ende qamarei. (Eng Yuda wurinou qomon eng yamangar wau me baia gab eng yamangar eng boru wot qamb igour end qamarei.) ");
INSERT INTO wnu_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabet qugurau igama inaun bo gari uma ne qoan 5-ende umor eng nob 6-ende bura ne Qenu enger Gabriel eng bo imurima ai Galili end ginam ger Nasaret end isorei. ");
INSERT INTO wnu_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Yamangar yorou ger munon Yosep bai qamb wot maribigumirei igoai. Yamangar eng ur qoan irgeren eng Debit wonou tumbigi, unum eng Maria. ");
INSERT INTO wnu_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Enger wot der qamar: “Io, ne oau uberet igoar. Munon aib net igub ne nonogursi igo.” ");
INSERT INTO wnu_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ende qamara Maria enger qob eng igub oau quguraget wonou misirt, “qob eng qanam maigas ana?” ende qamb igoai. ");
INSERT INTO wnu_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ende at igama enger bo nob qamar: “Maria ne misir qebebi igub oau me quguraget igoar. Qenu nenet uberet igo. ");
INSERT INTO wnu_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","End ne, ne qugurau igo wau ger baiban. Baub unum Yisas ende qem. ");
INSERT INTO wnu_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Wo gari munon gugum wot Qenu wau ten ende wot qamb igorubour. Munon Aib Qenu wonou musia wonou ur qoan Debit king igoa gas ende munon gugum oroar igoriba. ");
INSERT INTO wnu_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Igo wo Yekop wonou yurau eng oroar qomon uber wuriimbig ende at wurinou king qenen mom igoriba, me weginerei.” ");
INSERT INTO wnu_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ende nob qamara Maria enger nob qamar: “Ye yorou igoum, maigas mi eng quran eng yet dieriba?” ");
INSERT INTO wnu_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ne enger taui qamar: “Munon Aib Igomurur qau nesieriba. Nesiera Qenu wonou ne nonogursieriba. Nonogursia ne wau qigin nob bainen eng Qenu wonou wau ten ende wot qomorubour. ");
INSERT INTO wnu_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ne eng quran eng bainemendi Elisabet ge. Wo gor sig isigi wau me bainerei ende wot qamb igurei. qamb igour eng see wo qurag igama inaun 6-ende uma. ");
INSERT INTO wnu_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","End ne in Qenut mi soageni ger ende me ebeiner qi ende qamb bais ger me qomorunei, sig ue ar.” ");
INSERT INTO wnu_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ende qamara Maria qamar: “Ye Qenu wonou sarau yamangar end ne qob quran eng Qenu ende yesieriba.” Ende qamara enger Maria wogub qoorei. ");
INSERT INTO wnu_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Qoa wogub Maria qand girinet wogub Yudia wurinou ginam ger ai qaurent igoar end irarei. ");
INSERT INTO wnu_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Irab is Sekaraia munai mor end isub Elisabet garei. ");
INSERT INTO wnu_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Gab aba qurag igoar end wau aruara igorei. Qen end Igomurur qau Elisabet wot isorei. ");
INSERT INTO wnu_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ende aba Elisabet der Maria qugiab nob qamar: “Qenu ne yamangar qei wuritanami ne nonogursi ne nonou wau bainen eng gor nonogursieriba.” ");
INSERT INTO wnu_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Qamb qamar: “Wa, yamangar eng wau bainer eng yonou Munon Aib igoriba. End ne maigas ye yamangar ar igimine yegeib qamb yara a? ");
INSERT INTO wnu_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ne igan, ne qob ye nob qamb igama igoum eng wau qur erobon e mismisir aruara igoum. ");
INSERT INTO wnu_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ne Munon aib nesierib qamb qamar eng wot oabig eng uber igoriban,” Elisabet ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","47","Ne Maria qamar: Ye apand Munon Aib wot oabig wot mismisiraum. ");
INSERT INTO wnu_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","49","Wo, ye ar wonou sarau yamangar ego wonou uyes yet igub wonomi wes eng yet aba end munon ginam-ginam eng igub yet qomorubour: “yamangar eng Qenu wo siera uber igoai,” ende yet qomorubour. Munon Aib wonou unum sig uber wes ar. ");
INSERT INTO wnu_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","End munon wot igunor eng wuriubersi ne wurinou wau misinam der isunor tumbigi eng gor ende wurisieriba. ");
INSERT INTO wnu_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Wo sarau borusi beiner eng munon wurinou gab gerenunor eng wuritoar arirama wes-wes qoaubour. ");
INSERT INTO wnu_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Wo ende ebet munon uter boru ag e igour eng wuribumaimba. Ende at munon boru munon ue gas igour eng wuriubersieriba. ");
INSERT INTO wnu_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ende at ne munon qunumber qent igorunor eng mani irou werisiba. Ne munon mind irou igorunor eng wurisiara mind ue ar igorubour. ");
INSERT INTO wnu_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Wonou qob qoan qamb nausier end ininou tonoan wuriubersi igoar eng isi yarab see wonou sarau munon yurau Isrel wuriubersiar eng. ");
INSERT INTO wnu_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Eng igar, qoan Abraham ubersi igoar eng wonou wau tumbigi-tumbigi eng qenen ende, Maria qob ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria Elisabet nob end igama inaun omburgari uma wogub wonou ginamt isorei. ");
INSERT INTO wnu_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Isa wogub Elisabet wonou wau baiau qen eng gab munonbor wau baurei. ");
INSERT INTO wnu_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Baia qob toau isa banamori ne munon gugum igub Munon Aib mi wes eng aba gab wot borusi mismisiramirei. ");
INSERT INTO wnu_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","60","Wau ende ba nob igama inorou gari uma ur goan soopurmeteib qamb aba nob yaremirei. Yarab ne wonou ur unum eng Sekaraia qenimb qamb abari unor der qamar: “Me, unum Yon qomoruboun.” ");
INSERT INTO wnu_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ende qamara wurinob qamamir: “Nonou tainori, bainori unum ger ende me igour.” ");
INSERT INTO wnu_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ende at-at wogub is ur quum qamb ubent qas maribig qebiamir: “Ne wau unum eng maisi bigun qamb qenungan?” ");
INSERT INTO wnu_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ende abari gab imbig ne wo wepep goan ger yeisar qamb aba gab ba yar utari, “wau unum eng Yon”, ende qamb guma gab misir qebebi igub igurei. ");
INSERT INTO wnu_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Qen end Sekaraia mindiram tuumtar eng bo miroa qob musub qamb ne Qenu wot mismisir unumut igoai. ");
INSERT INTO wnu_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ende aba qob toau banamori igub yarimari ne tumbigi is Yudia ai qaurent igour ginam eng igub ugamirei. ");
INSERT INTO wnu_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Munon qob toau isa igumir eng der: “Wa, wau eng barait munon maigas igoriba mi ende aba-a? Munon Aib iitari igoriba abar eng,” ende qamamirei. ");
INSERT INTO wnu_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ne qen end Qenu Igomurur qau wau ur Sekaraia wot isa Qenu qob qamar: ");
INSERT INTO wnu_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Wagari in Isrel ininou Munon aib Qenu unumut igorun. Wo inubersierib darar end. ");
INSERT INTO wnu_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Wonou sarau munon Debit tumbigi end bo munon aib qeretut nob ger maribiga inubersieriba. ");
INSERT INTO wnu_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Wo mi eng ebeiner end qoan wonou qob gigit qamarau munon wurinob qamara gumatemir eng. ");
INSERT INTO wnu_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","In munon qarau ininob yogub qiyo munon boru-boru ininob agunub igamari innonogursierib qob nausier eng. ");
INSERT INTO wnu_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Wo ininou tonoanb wuriubersierib qamar eng. Ende at wonou qi init iyet wager eng. ");
INSERT INTO wnu_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Wonou qoan Abrahamt qob gagam mom qamb nausier eng igama toat insierib abar eng. ");
INSERT INTO wnu_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","In munon qaraut yari igumune wo ende inseara bo sarog big igoarar qamb aba. ");
INSERT INTO wnu_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","In igom igoun et qen gugum qomon boru-boru eng mom wot gitab wogub qomon uber eng mom songi sarau booun qamb aba.” ");
INSERT INTO wnu_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Sekaraia ende qamb wogub wonou waut qamar: “Ne yonou wau, nenet Qenu wonou qob gigit qamarau iitari ende net qomorubour. Ne Munon Aib wo der isiner eng tap gigit imoteiban. ");
INSERT INTO wnu_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ne gigit isub wo der isiner end wonou munon qomon boru-boru ebet igour eng mogirt wab wagar qamb wuriimbigiban. ");
INSERT INTO wnu_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Wo munon wuriubersiau tari ne wo munon mein. End wonou begen eng init imurima deriba. ");
INSERT INTO wnu_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","In munon gugum umun qamb yari igoun eng itum igamau gas ende. End ne wo inimbag tap susu isunor qamb wonou begen eng init begenara tap sarog big igamau end igoruboun, ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Wau eng barai burab ne wonou misirt mi ebeiner eng qeemben gab, ne gor Qenu mom imbig taut igoai. Ende mom nonoguret wogub seger ai qengereng end is igoai. Igoi qen geret Isrel munon yamangar wurit dibentarei. ");
INSERT INTO wnu_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Qen end Rom gabman munon aib wurinou gigit igoar eng unum Sisar Ogastus. Wo munon ginam gugum isub unum bigar qamb qob biga ginam-ginam isorei. ");
INSERT INTO wnu_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","3","Qen qamart munon gugum isub unum bigar qamb ebetemir eng Kwirinius wo Siria provins wurinou gabman igoai. Kwirinius wo ende igama munon gugum ginam qenen wogub iua ginam taut igour end bo wurinou ginam qenen end isub unum bigar qamb. ");
INSERT INTO wnu_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ende isub igamari ne Yosep wo ai Galili ginam Nasaret end igoar eng wogub wo Debit tumbigi end ai Yudia end isub is ginam qoan Debit unor bauor end isorei, ginam eng unum Betlehem. ");
INSERT INTO wnu_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","7","Wo gor unum gumaib isiba ne Maria wo bai qamb maribigumir end nob isorei. Qen end Maria wo qurag igoai. Wuri Betlehem end isari Maria wau baib ebeter eng wuri munai inau ue. Ende gab ne wai wurinou munai end inemirei. Inemirei igo itum end Maria wau qamar baurei. Baub wogub mingoant ouri wogub bur qarig mi nub igour tabin end biga inab igoai. ");
INSERT INTO wnu_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Qen end munon qei wai sipsip itum oroar ai end gari igeragart end igurei. ");
INSERT INTO wnu_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Igamari Munon Aib wonou enger dara begen qiribiten qenenginob wurit arirama gab borusi qiet yariamirei. ");
INSERT INTO wnu_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ne enger der wurinob qamar: “Me yarimar, ye qob uber aninob qemerib doroum. Qob eng munon gugum igub mismisirubour. ");
INSERT INTO wnu_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Itum et qas Debit wonou ginam end munon anubersieriba eng unor baiai, eng Munon aib. Qenu qoan ir inubersi qamb maribigor eng, unum Krais, eng Munon inubersiau tari. ");
INSERT INTO wnu_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Eng ye qob apand aninob quraum. An is gunon eng wau mingoant ouri wogub bur qarig tabin end inisiurei igama guboumon.” ");
INSERT INTO wnu_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ende wurinob qamb igama qand enger yurau aib der eng nob erogori Qenut mismisir uru wab qamamir: ");
INSERT INTO wnu_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Qenu unum abari tubub aib iriner. Iroa munon ag oau mein burab igamari Qenu wurit igub igoriner. ");
INSERT INTO wnu_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ende qamb wogub erer qite iroari wogub munon wai qoat igour eng der wurinou qob-qob qamamir: “Wagari qand Betlehem umo isub mi eng aba Munon aib ininob qura eng gun.” ");
INSERT INTO wnu_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ende qamb qand isub Maria Yosep nob ibag wau mingoant ouri wogub bur qarig tabin end bigumirei igama gamirei. ");
INSERT INTO wnu_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Gab enger qob wurinob qamar eng gugum wuri nob qamamirei. ");
INSERT INTO wnu_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Qamarari wuri qob eng igub uberetemirei. ");
INSERT INTO wnu_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maria qob eng gugum igub wogub mom misirt big qenen igub igoai. ");
INSERT INTO wnu_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ne munon wai sipsip qoat igour eng bo isub enger qob qamara igumir eng ne mi gabriamir end Qenut uru wab mismisir igurei, enger wurinob qamar gas ende at igurei. ");
INSERT INTO wnu_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ne inorou gari uma ne (wurinou qomon eng toat) wau git goan sirigum nob igoar qamb suab ne unum qoan unor qurag igama enger nob qamar eng, “Yisas” qamamirei. ");
INSERT INTO wnu_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ende qamb wogub igoi inorou qei-qei uma ne Moses qomon qoan gumater eng gab unor wau bauor end Qenut mian isiari Pris munon inmaragansiar qamb Yerusalem qite iramirei. End irab wau qamar eng gor Qenu sirbigub qamb ebetemirei. ");
INSERT INTO wnu_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Eng Munon aib wonou qomon ete gumatemirei igo: “Munonbor wau qamar unor wuri baiari ibag eng Munon aib wonomi tetemi.” ");
INSERT INTO wnu_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ombur iramir eng gor wau eng gab-gab mian iset Munon aibt qomon qura gas ende oboub qamb. Qomon eng ete igoai: “Morogan wamariau ombur qiyo qabturin yeim ombur ende mutet warar,” ende igoai. ");
INSERT INTO wnu_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Qen end munon ger Yerusalem end igoai, unum eng Simeon. Wo munon qoregen igo Qenut oabig qenen uru wab igoai. Wo munon ger Isrel wuriubersierib deriner end qoat igama Igomurur qau opurima ten igoai. ");
INSERT INTO wnu_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Eng wo Igomurur qau qo nob ete qamarei: “Me uminenei igo Munon aib wonou munon wuriubersieriner eng imurima dara gab wogub umiban,” qamar end qoat igoai. ");
INSERT INTO wnu_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Qen end Igomurur qau Simeon oau menima Qenu wonou munai Tempel eng mor isorei. Isub ibagar eng wau ur unor nob qomon igo eng taut wau Qenu sirbigub at igurei. ");
INSERT INTO wnu_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ende gab wau ur ba igama ubent wot ba Qenu nob qamar: ");
INSERT INTO wnu_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Io Munon Aib, see nonou qob yet nausien eng mi irimanima gaum eng gab ye oau mom meinburoum. Umin eng qob ue. ");
INSERT INTO wnu_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ye munon inubersieriner eng ge qamb yedua igoum eng qo yesirbiga gaum e. ");
INSERT INTO wnu_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","End ne munon magqurt tap wurit arsia gunor. ");
INSERT INTO wnu_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Wo nonou urut begen gas ende. Munon yurau ar eng geari ne nonou munon yurau tetemi Isrel eng wuri unum deberi igoriba. ");
INSERT INTO wnu_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simeon wau eng ba qob ende at qamara wau ur unor nob borusi qiet misir igub igurei. ");
INSERT INTO wnu_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ende at igamari wuri gor wurinonogursi Maria nob qamar: “Wau e Qenu wonou maribigorei. End Isrel munon irou merimotoubar ne qei qob qamara igotoubour. Qenu wonou mi wes eng wau eng wo ba dibesia munon irou gab simbiri wab wogub wurinou misir boru dibesiorubour. ");
INSERT INTO wnu_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ende at isi yarab wurinou misir qi igoriner eng wot abari gab ne borusi toubet eab-eab oau uri gegereteriban,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Yamangar ger Qenu qob wo nob qamara miteri qamb igoai, unum eng Ana. Ur unum eng Panuel, wo Aser tumbigi. Ana wo munon bauor eng togun 7-ende wara umami uma wogub wonou ar qindou igoi wogub sig isigi burerei. ");
INSERT INTO wnu_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Qindou igama togun bo 84-ende war eng wo Qenu bais me wagau, woromt itum qenen Qenu munai Tempel mor end isub wot simot eab ne qen qei-qei Munon aibt igib qamb mani gitab ende at igoai. ");
INSERT INTO wnu_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Wo gor qen end gari qeemben diab Qenut uber qamb ne wau end munon qei Qenu Yerusalem ubersierib qamara qoat igoar end wurinob qamarei. ");
INSERT INTO wnu_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Qomon qoan igoar end mom toat sarau ende at ugab wogub bo Galili der wurinou ginam qenen Nasaret end isumirei. ");
INSERT INTO wnu_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Is end igamari wau baraiburab nonoguret ne qoyam gor aibtarei. Ende aba Qenu musub igoai. ");
INSERT INTO wnu_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","End igo Yisas ur unor nob togun gugum qen aib, “Qenu tonoanb me igaramau” qamb mi at nub igour end ginam aib Yerusalem ite ir igurei. ");
INSERT INTO wnu_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yisas igama igoi togun 12-ende wara ne bo ur unor nob togunt qenen ir igour gas ende bo Yisas mot iramirei. ");
INSERT INTO wnu_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Qen aib eng ubura ne ur unor bo ginamt isari Yisas Yerusalem qite igoar eng ur unor qoyam ue. ");
INSERT INTO wnu_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Wo, mai, gigi munon qei isour eng wurinob isai ende qamb ar isumirei. Isub wonou yurau banamori wurinob isai qamb gamir eng ue. Ende gab wot asi qib igamari qen gari uburerei. ");
INSERT INTO wnu_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Sig me gab wogub ne bo wot asi yonam Yerusalem qite iramirei. ");
INSERT INTO wnu_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Irab wot asi qib igamari qen ombur gari ubura is munai aib mor end gamir eng Yuda imbigau munon aib-aib qob qamarari igub wo bo wuri qebi qamb ende at igama gamirei. ");
INSERT INTO wnu_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Munon barai-barai wo qob qamara igub a wuri qebimari wo musub taui wurinob qamara wo qoyam aib eng gab qietemirei. ");
INSERT INTO wnu_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ur unor nob ende gab qiet ne unor der nob qamar: “Ne meimet qamb qi ende iua igama in tain nob net asi qibi seretoroun.” ");
INSERT INTO wnu_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ende qamara wo taui qamar: “An meimet qamb yet asi qib igoumon? Ye yonou tain munait igoum eng an qoyam ue e?” ");
INSERT INTO wnu_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ende wurinob qamara wuri qob qanam sir me imbigau. ");
INSERT INTO wnu_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ende oromar qamb wogub wurinob Nasaret qumo isub qob qamarari toat mi ebet igoai. Unor Yisas qob eng qamar eng igub ten igoai. ");
INSERT INTO wnu_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yisas ende at igo ne git goan qoyam nob aib burerei. Ende aba munon gab qenungari Qenu gor gab qenungeterei. ");
INSERT INTO wnu_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Qen end munon ger unum Sisar Taiberius wo Rom wurinou gabman baraitari igoai. Igama togun 15-ende wara ne wo Rom ende igama Pontius Pailat eng wo Yudia Provins munon ginam gugum wurinou gabman gigit igoai. Igama Herot wo Galili Provins wurinou gigit igama ne umour Pilip wo ai Ituria Trakonitis nob qoat igoai. Ne Lisanias wo ai Abilene wurinou gigit, ende igurei. ");
INSERT INTO wnu_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ne Anas Kaiapas nob wuri Qenut mian iset bigau eng wurinou gigit igoai qo igurei. Qen end Sekaraia wau Yon eng wo seger ai end igama Qenu qob nob qamarei. ");
INSERT INTO wnu_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Qamara igub ya Yordan wes eng gugum qib Qenu qob munon yamangar wurinob qamar: “An qomon boru a mindigar qob eng gagar mogirt wab wagari anmaragansi ya obotaribam. Ende obounon eng Qenu anit igub aninou qomon boru taui me anquguragsierinerei,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Qob eng qoan ir Qenu wonou munon Aisaia wot di qamara ete mit big qamb gumater eng see irimanima gaun eng: Seger ai end munon ger wonou ar igo atag ete qamb ab igoriba: Munon Aib tap imotet a ai tap ingong bigau eng musub tog imot, ");
INSERT INTO wnu_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","ne ai boru toponi-toponi eng wat ariramari diab qoregen buriner. Ne ai qauren-qauren eng gor suab musub, ne ai nomon qurgar nob eng boobumi arir ende aterimar. ");
INSERT INTO wnu_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ende abari munon gugum Qenu mai insierib abar eng in siara gun. ");
INSERT INTO wnu_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Yon qob eng igoar eng ende qamb waga munon irou inmaragansi ya obotar qamb yarari wurinob mit big qamar: “An mani uter gas ende, your aninob Qenu qen geret iningaramba eng qamara igub wot iua qib igoumon? ");
INSERT INTO wnu_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","An oa igeser mi eng ebet eng an qomon boru mogirt wab wogunon eng diban guboumon. An ar igo qabarit qas, “Abraham ininou tonoan, Abraham ininou tonoan,” qamb bisoumon eng an ue ar. Ye ete qemerine igar, nomon e gagar gaumon eng Qenu ar nob qamara Abraham wau tumbigi der isib eng ar ende ebeiba. ");
INSERT INTO wnu_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Bei aib ger nam qanam umai end bigumirei igo. Eng nam qur musub me biga gab eng Qenu bei eng ba tari ten wabur mutet arirama oeiba.” ");
INSERT INTO wnu_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ende qamara munon eng der qebi qamamir: “Eng in maigas obouboun?” ");
INSERT INTO wnu_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ende qebi qamarari wo qamar: “Munon ger mingoan ombur igama gab eng munon ger ue gab eng ger wo utiner. A munon ger mi niau irou igama gab eng qei qerei wurisiner,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Qen end munon gabmant nomon qur ba qib igour eng gor in ya obotar inmaragansi qamb yarab qebi qamamir: “In gor mai obouboun?” ");
INSERT INTO wnu_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Qamarari wo qamar: “An nomon qur gabman qangang baiar qamb qangang qura eng qeemben wurit baiar, aninou ui ar ger me baiar.” ");
INSERT INTO wnu_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ende qamara wogub ne bo yogorau munon yar qebi qamamir: “In gor meimi obouboun?” Ne wo der wurinob qamar: “An gor, munon meten wurit me qamarar. A wurit misiringet wurimurimar gag wurinob nomon qur qangang aib qamarari me andarunor. An aninou sarau baumon qur taui eng gari baiar.” ");
INSERT INTO wnu_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Munon irou Yon qebimari taui ende wurinob qamb aba gab misir wes-wes igub ete qamamirei: “Wa, munon e mai Qenu qoan munon ger inubersi qamb imurimb qamb qamar eng ne?” ");
INSERT INTO wnu_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ende qamarari Yon taui qamar: “Ye ar ya asint obotar anmaragansiaum, ne munon ger qanamt yar igo eng wo ye yetanamima, wo wonou wes ar. Ye wo pi isub goten yau negeiner eng maigas me nerimitinei. Wo anmaragansieriner eng Igomurur qau mut qabasanar ten anmaragansieriba. ");
INSERT INTO wnu_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Wonou sobor eng baub wit goaneter eng misugan meni ne arir qur ba mor big sasau eng mut nat oab igo end gumeiba.” ");
INSERT INTO wnu_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yon qob qei-qei ende wurinob qamara iruges big igub igamari ne qob uber qei irun wab wurinob qamarei. ");
INSERT INTO wnu_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ende at igama ne wurinou gabman munon aib Herot wo umour ubeni Herodias wot baub ne qomon boru qei-qei ebet igoai. Ende ebet igama Yon wot dibes qamarei. ");
INSERT INTO wnu_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Eng ende aba mai Yon yet qura qamb bo qomon boru eng imusi bo Yon uyort bigorei. ");
INSERT INTO wnu_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Herot wo Yon uyort me bigau igama wo munon gugum wurimaragansi ya obotar ugab ne Yisas gor ya obota ne Qenut qebi qamb igama tat miroau gas ende ebeterei. ");
INSERT INTO wnu_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ende aba gab igama Igomurur qau morogan wamariau gas ende at wot dererei. Dara ne qob ger igumir eng ete at qamar: “Ne yonou wau ten, ye borusi net igub ten igoum,” ende qamara igumirei. ");
INSERT INTO wnu_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yisas togun 30-ende wara ne sarau qanam big bea munon gugum Yosep wonou wau qamb igurei. ");
INSERT INTO wnu_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Yosep wo ur Heli, ne Heli wonou ur Matat, ne Matat ur Libai, Libai ur Melki, ne Melki ur Yanai, ne Yanai ur Yosep. ");
INSERT INTO wnu_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Ne Yosep ur Matatias, ne wo ur Amos, Amos ur Nahum, ne Nahum ur Esli, ne Esli ur Nagai, Nagai ur Mat, ");
INSERT INTO wnu_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Mat ur Matatias, ne wo ur Semen, ne Semen wo ur Yosek, Yosek ur Yoda. ");
INSERT INTO wnu_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda ur Yoanan, ne Yoanan ur Resa, Resa wo ur Serubabel, Serubabel wo ur Sialtiel, Sialtiel wo ur Neri, ");
INSERT INTO wnu_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri ur Melki, Melki ur Adi, ne Adi wo ur Kosam. Ne Kosam ur Elmadam, ne Elmadam ur Er, ");
INSERT INTO wnu_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ne Er ur Yosua, Yosua ur Elieser, ne wo ur Yorim, Yorim ur Matat, Matat ur Libai, ");
INSERT INTO wnu_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Libai ur Simeon, Simeon ur Yuda, ne Yuda ur Yosep, Yosep ur Yonam, Yonam ur Eliakim, ");
INSERT INTO wnu_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ne Eliakim ur Melea, Melea ur Mena, Mena ur Matata, ne Matata ur Natan, Natan ur Debit, ");
INSERT INTO wnu_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Debit ur Yesi, Yesi ur Obet, ne Obet ur Boas, ne Boas ur Salmon ne Salmon ur Nason, ");
INSERT INTO wnu_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ne Nason ur Aminadap, Aminadap ur Atmin, Atmin ur Arni, Arni ur Hesron, ne Hesron wo ur Peres, Peres ur Yuda, ");
INSERT INTO wnu_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Ne Yuda ur Yekop, Yekop ur Aisak, ne Aisak ur Abraham, Abraham ur Tera, ne Tera ur Nahor, ");
INSERT INTO wnu_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor wo ur Seruk, Seruk ur Reu, Reu wo ur Pelek, Pelek ur Eber, Eber ur Sela. ");
INSERT INTO wnu_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Ne Sela ur Kainan, ne Kainan ur Arpaksat, ne Arpaksat ur Siem, Siem ur Noa, Noa wo ur Lamek, ");
INSERT INTO wnu_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek ur Metusela, ne Metusela wo ur Enok, ne Enok wo ur Yaret, Yaret wo ur Mahalalel, Mahalalel ur Kenan, ");
INSERT INTO wnu_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Ne Kenan ur Enos, Enos ur Set, ne Set ur Adam, ne Adam ur Qenu, ende. ");
INSERT INTO wnu_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yon Yisas ende ya obota wogub Igomurur qau wot isub nonogursia bo ya Yordan eng wogub yonam iroa Igomurur qau mot seger ai end isorei. ");
INSERT INTO wnu_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","3","Seger ai end is igo qen 40-ende mi me niau, wo ende igama Satan wot diab ur qob wog qamb warigesi nob qamb igoai. Ende ibitiri igama igoi mom borusi minema gab ne Satan Yisas nob qamar: “Ne apand Qenu wau ten igo gab eng nomon e nob qamara mani parau waria nub igoar.” ");
INSERT INTO wnu_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ende qamara Yisas nob qamar: “Qob ger ete gumatemirei igo, munon mani qas nub igom me igour.” ");
INSERT INTO wnu_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ende qamara Satan bo mot ai qaurent irab mi uber-uber gugum imbig qamar: ");
INSERT INTO wnu_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","“Mi maieng-maieng e gagar gan eng yonou, net wogeteibam, eng ne io qamara gab. A munon ger baib yenob qemeriner eng ye ar wot wegibam. ");
INSERT INTO wnu_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","End ne, ne baib qamb eng yet gamaur wat bugab yet simot ea gab eng mi e gagar gugum nonou mom net wegibam.” ");
INSERT INTO wnu_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ende qamara Yisas bo nob qamar: “Qob ger ete gumatemirei igo, Munon aib Qenut qas wot igub sarau baab igoarar.” ");
INSERT INTO wnu_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","11","Ende qamara Satan bo mot Yerusalem Qenu wonou munai Tempel eng qirer sig erer qau qitend bir nagsi ne qamar: Io, Qenu qob gumatemirei igo quran end see ne et naget igo oruber isa qob igo end Qenu enger imurima der ne beari-beari mesenau isub dibogoten me ombopurminenei. ");
INSERT INTO wnu_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ende qamara Yisas nob qamar: “Qob ete qura, “Qenu ininou Munon aib me warigesiorun,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Satan mi gugum Yisas warigesi nob qamara qob ombarir igama wogub qen geret bo warigesierib qamb wogub qoorei. ");
INSERT INTO wnu_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ende aba wogub Igomurur qau Yisas nonogursia ten bo yonam Galili end isorei. Isa qob toau ginam gugum isa igumirei. ");
INSERT INTO wnu_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Wo end is qib Qenu qobt igau munai end isub qob imbig wurinob qamara munon yamangar wot mismisiramirei. ");
INSERT INTO wnu_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","17","Qen geret inorou qen “Sabat” qamb igour eng gab wonou ginam qenen Nasaret end irab inorou munai mor end isub qob ger wanungeremb qamara ne qoan Qenu qob gigit Aisaiat di qamara gumater eng utari boair ne qob ger ete gab wanungeramorei: ");
INSERT INTO wnu_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","19","Munon Aib Igomurur qau yoopuri ten igo. Ye wonou qob uber eng munon boru qangang eng wurinob qem qamb yemaribigorei. Ne munon uyort igorunor eng wuriubersi qamb yiimurima deremei. Darab munon mag tuum eng asi mi gab ende abar qamb wuriubersieribam. Ne munon qei wau gogor gas ende sarau abari wurisumungasi igour eng wuriubersierine uber igorunor qamb deremei. Darab ne Munon aib munon wurit igub wuriubersieriba qen eng wuriimbigibam. ");
INSERT INTO wnu_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yisas buk eng ende wanunger wogub munon buk qoat igo eng utab wogub bogoma munon mor igour eng wo gari mag nasi gab igurei. ");
INSERT INTO wnu_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ende abari wo qanambig wurinob qamar: “Qob e qoan gumatemir eng mi git eng see aninou magqurt ye wanungermine gaumon eng.” ");
INSERT INTO wnu_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Qob gugum ende qamara igub qamamir: “Wo maigas ende quraa? Wo Yosep wonou wau qenen gab igoun.” ");
INSERT INTO wnu_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ende qamb abari wo qamar: “An yet apand ete yet qomoruboumon, ne toar munon wurimusub igoan end see nonomi musi. Qoan Kaperneam ire igo aba qob toau igumin gas ende bo nonou ginam qenent et bo ende aba gun.” ");
INSERT INTO wnu_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ende qamb bo qamar: “Ye ete qemerine igar, qob gigit qamarau munon wonou ginam qenen end qob wurinob qamara iruges big qob me igetet igour. ");
INSERT INTO wnu_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ye qob eng quraum eng iruges big igub igamari. Qoan Elaiya igoa qen end Isrel yamangar qindou irou igurei. Qen end togun ombur gari ne bo inaun 6-ende ya me darau. Ende igama qunumber qen aib ai eng gugum yarerei. ");
INSERT INTO wnu_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Yara Qenu Elaiya imurima Isrel yamangar munon nob end me isau. Wo imurima ai Saidon end isub is ginam Sarepat end yamangar qindou ger nob igama mani utab igoai. ");
INSERT INTO wnu_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Eng gas ende bo qob gigit qamarau munon Elisa eng bo gun. Wo gor, is Isrel munon tumau gab igour eng wurinob igoar eng munon irou wuri musia me uber burau. Siria munon Naman eng gari qas-qas musia uberetarei.” ");
INSERT INTO wnu_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Yisas ende wurinob qamara igub munon gugum inorou munai mor igour eng borusi misiringetamirei. ");
INSERT INTO wnu_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","30","Ende at munai ginam aib eng ai qaurent igoar end Yisas mot ginam aib eng wogub qonut ete yar baab yaru ariramb qamb mot isari wo wobont uburerei. ");
INSERT INTO wnu_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yisas ende iua di Galili ginam aib Kaperneam end isorei. Isub Sabat qent munon qob wurinob qamb igoai. ");
INSERT INTO wnu_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Qob qamara igumir eng qiribiten, ende igub borusi qietemirei. ");
INSERT INTO wnu_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Inorou munai mor end munon ger ai bigau waramorei igama Yisas is qob qamara igub atag ar: ");
INSERT INTO wnu_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“O, Nasaret munon Yisas, ne mai insierib yaranei? In bumaimb yaranei qii? Ye imbigoum ne eng Qenu wonou munon qau.” ");
INSERT INTO wnu_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ende qamb ara Yisas aibigau taisi qamar: “Qi wogub munon eng wogub ag der iua.” Ende qamara ai bigau munon eng wogub qoaib qamb munon eng ba ai qenen qumo arirama munon qei magqurt mumun inab igama qoorei. Qoa wogub munon eng der nageterei. ");
INSERT INTO wnu_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Munon qei mi bubun ende gab qiet wurinou qob-qob qamamir: “Qob eng maigas qeretut nob ende igama ai bigau munon eng wot isuor eng nob qamara di qoa, a?” ");
INSERT INTO wnu_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ende qamb Yisas mi eng ebeter end qob bigari ginam qani-qani eng igumirei. ");
INSERT INTO wnu_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yisas inorou munai eng wogub ag der Saimon munai end irarei. Saimon wonou ayi eng toar aib wara igama wot arari irarei. ");
INSERT INTO wnu_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Irab yamangar eng inab igama saberi qani et naget mi sier eng nob qamara qoorei. Qoa yamangar eng mom uberet ne mani yamatar igoai. ");
INSERT INTO wnu_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ende ebet igama ai gab-gab munon irou wurinou munon banam qei toar igara igour eng wuriba diarari Yisas wurimusub igoai. ");
INSERT INTO wnu_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ende aba ai bigau qamb toar qei wurit isub igoar eng der isub ete qamb amirei: “Ne Qenu wau ten.” Ende qamb arari Yisas der wuritaisi igoai. Eng wuri munon inubersierib derer eng imbig ab igurei. ");
INSERT INTO wnu_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ai uter tubub diara Yisas ginam eng wogub ai munon uet end isorei. Isa munon yamangar me inwogub iua qamb gub qamb asi qib igurei. ");
INSERT INTO wnu_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Qib geari wurinob qamar: “Qenu ye yiimurima derem eng wonou bibis bigor eng ginam qei eng gor. End ye qob uber eng wuri gor wurinob qemeribam.” ");
INSERT INTO wnu_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ende qamb Yuda wurinou ginam-ginam inorou munai mor end isub qob wurinob qamb igoai. ");
INSERT INTO wnu_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Qen geret Yisas ya tai Genesaret gabut end naget igama munon yurau irou Qenu qob qamara igub qamb yar opuramirei. ");
INSERT INTO wnu_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Wo end igo gar eng tabin ombur-ombur ya gabut orosout end igama garei. Tabin urimagrari eng wuri tabin ende wogub wuri iua dob birogoni igurei. ");
INSERT INTO wnu_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ne Yisas Saimon wonou tabin end is bugab nob qamara bo bais isub-isub is naga mugenderi nami ende igo munon yurau aib eng qob wurinob qamb igoai. ");
INSERT INTO wnu_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Qob wurinob qamb wogub ne Saimon nob qamar: “Tabin bo bea ten ya tumunt iret isub dob bo arir yag wai gab baiar.” ");
INSERT INTO wnu_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ende qamara Saimon der qamar: “Barai, git uber quran ego see itum in sarau aib ebet qib igumurune urigerama e, wai ger bais me baiau. Eng nonou quran end bo warigesi arir gune.” ");
INSERT INTO wnu_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ende qamb dob ariramari isorei. Isa yag wai nob yar erobon isorei, isa dob aib eng purib pisiarei. ");
INSERT INTO wnu_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ende aba gab wurinou yurau qei tabin geret igour eng wurit arari yar erogori ubumimari diarei. Diara yag wai eng qerei tabin ombur end arir igamari quguraget ten ya mai isub etemirei. ");
INSERT INTO wnu_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Saimon Pita mi aib eng ende aba gab wogub Yisas menmant end gamaur wat bugab nob qamar: “Barai ye yewogub iua, ye munon qomon boru yet yab di qoa ten igoum.” ");
INSERT INTO wnu_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Wo wai aib-aib eng gab qesi wara ende qamara ne wonou yurau erogori eng gor qesi igarerei. ");
INSERT INTO wnu_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ne Sebedi wonou wau ombur eng, Yems Yon nob, wuri Saimon wonou munon banam, wuri gor qesi igara ne Yisas der Saimon nob qamar: “Ne me yariom, wai e baian gas ende munon yamangar ende wuribaiban.” ");
INSERT INTO wnu_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ende qamb wogub tabin ba di qonut bigari igama ne mi gugum wogub Yisas arapot qib igurei. ");
INSERT INTO wnu_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Qen geret Yisas is ginam ger end igama munon ger iam tumau gab igoar eng wot diab menmant end wonomi arir inab Yisas simot qamar: “Barai, mai sarau ger ue gab eng ye iam e gusimisa woueriner qiyo?” ");
INSERT INTO wnu_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ende qamara Yisas miregesi munon eng qotub qamar: “Io gusimeteibam,” ende qamb qabarit qas nob qamar: “Iam wouteriba.” Ende qamara qen end qas iam gagamet bebereg di uburerei. ");
INSERT INTO wnu_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Iam wout ubura Yisas taisi qamar: “Ne munon qei wurisirbig me qem, ar saranang irab munon pris eng wurisirbiga wuri nenet qoan Moses qomon gumater gas ende mian iset bigatari mom uberburiban. Ne ende aba munon gugum negab imbigar qamb.” ");
INSERT INTO wnu_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ende qamara wogub ne Yisas mi eng ebeter eng qob toau qo munon ginam-ginam isa igub qob igotoub qamb yarari toar nob eng wurimusub igoai. ");
INSERT INTO wnu_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ende abari wo qenen ai misuuet end is igo Qenu nob qamb igoai. ");
INSERT INTO wnu_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Qen geret munon ginam Yudia ne Galili a Yerusalem igour eng gagar yarari Yisas qob wurinob qamb igoai. Munon yurau end munon Parisi ne qei qomon wuriimbig igour eng gor igurei. Qen end Qenu Yisas nonogursia toar munon wurimusub igoai. ");
INSERT INTO wnu_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ende igamari munon qei munon ger gurumot igoar eng gart big ba diab Yisast bigub qamb. ");
INSERT INTO wnu_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Diab gamir eng munon yurau irou Yisas opur wugumirei igama maigas me isunorei eng gab mon erer qitend irab irunguni gagam big waramir eng qei womboneri wogub munon eng gar sui-sui tesi wogub uyort beari-beari Yisas igoart end isorei. ");
INSERT INTO wnu_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Isa gab ne munon eng ba diamir eng wot oabig ba diamir eng ibag ne toar munon eng nob qamar: “Nonou qomon boru song wab arirambam.” ");
INSERT INTO wnu_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ende qamara Parisi munon ne qomon wuriimbig igour eng der wurinou qob-qob qamamir: “Wa, meimi munon ende Qenut sai qob ende at wot qura a? Munon ar ger munon qomon boru ebet ig eng maigas me ba at ariraminerei. Qenu wonou gari mi eng apand ende ebeiba.” ");
INSERT INTO wnu_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ende qamb abari wurinou misir ibag ne wurinob qamar: “An meimet qamb misir eng igoumon? ");
INSERT INTO wnu_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Mai ete nob qemerini eng, nonou qomon boru ebet igoan eng ye musiaum; ende qemerin eng an maigas me imbigunanei. End ne munon git gurumtar eng nob qemerine uberburiner eng an magqurt gab ne yiimbig ne ete qomoruboumon: “Wo qeemben,” ende qomoruboumon. ");
INSERT INTO wnu_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","End ne an eng imbigar, ye Munangit wau qiribiten ag et igo qomon boru eng ar wab arirambam.” Ende qamb munon gurumtar eng nob qamar: “Der naget saberi ba togor nonou munait isi.” ");
INSERT INTO wnu_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ende qamara munon qiumuni igour eng magqurt put der naget gar big ba diamir eng togor Qenut mismisir isorei. ");
INSERT INTO wnu_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ende at isa gab borusi qesi igara wogub Qenut wot mismisir qamamir: “Wa, see qas mi bubun ger ne gaun,” ende qamamirei. ");
INSERT INTO wnu_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Eng ubura ne Yisas isub gar eng munon ger unum Libai. Wo munon gabman nomon qur ba yar sarau munai end igo qerei igama is garei. Gab nob qamar: “Ne yemoromsia ombur qib igorun.” ");
INSERT INTO wnu_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ende qamara Libai mi gugum wogub Yisas nob isorei. ");
INSERT INTO wnu_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Libai wo Yisas nob isib qamb mi aib qamb at Yisas nob nib qamb aba ne Libai wonou sarau erogori nomon qur qerei igour eng ne munon ar qei erogori end igurei. ");
INSERT INTO wnu_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Igo mi nub igamari ne Parisi ne qomon imbig igour eng, wurinou yurau end gari eng wuri der Yisas wonou imbigau yurau eng wurinob qamamir: “An meimet qamb munon nomon qur ba qerei igour eng ne munon mindigar qob ten igour eng wuri songi nob bugab mi nub igoumon?” ");
INSERT INTO wnu_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ende qamarari Yisas taui qamar: “Munon toar igara eng munon wurimusub igour end wurit isari wurimusub igour. Munon ar ger meimet qamb yemusiar qamb me isinerei. ");
INSERT INTO wnu_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ye ende gas ende, ye munon mindigar qob ue eng wurit me darau, ye munon qomon boru mindigar qob ten igour eng wurimusierib deremei.” ");
INSERT INTO wnu_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ende qamara munon qei Yisas nob qamamir: “Yon wuriimbig qib igoa yurau eng nob Parisi wurinou eng nob qenen Qenu wot simot qomorub qamb mani gitab igour. A nonou yurau eng wuri meimet qamb ar mani nub ya nub igour?” ");
INSERT INTO wnu_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ende qamarari ne Yisas taui wurinob mit big qamar: “An eng gaiar, munon ger irub baib qamb mi aib at nib qamb banamori wurit qamara yarari an wurit gitatar igoumon qiyo? sig ue ar. ");
INSERT INTO wnu_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Wo mi nub ugab igama munon qarau yarab mot qoari qen end wo me gab bo mi gitab igorubour.” ");
INSERT INTO wnu_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yisas ende qamb ne bo mi geret big qamar: “Munon ger mingoan nai qubura gab bo mingoan temen tau ger me big mai igo. Ende ebeiner eng mingoan temen eng gigibiot yar bo mingoan nai eng bo imusi quburab uburiba. ");
INSERT INTO wnu_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ne ger, munon ger wain qur baub ya bea isub uter bur qamb wai goan end bea isub igo. Mai qiyo, munon eng wain ya temen eng ba wai goan nai end waariminer eng igoi qen geret uter burab iriget weib yariba. Ende ebet wonou wain ya ar isi isub uburiba. ");
INSERT INTO wnu_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","End ne wain ya temen ba wai goan tement wonou uninim waariminer eng qen geret uter burab eng me iriget yarinerei. ");
INSERT INTO wnu_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ne ger ete, wain ya qo waari bigunor eng qer uber eng gab gigit nub wogub bo temen qanamt nunor eng qer ii gab wain ya qoan eng uber qamb igour. Eng gas ende an munon qei gor qomon qoan toat ebet eng mi bubun gab qand me toounonei,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Qen geret Yisas Sabat inorou qent wit man qobot qib igama wonou wuriimbig igoa yurau eng wit qur qei ba ubent ninirmari sair isa qur nub qib igurei. ");
INSERT INTO wnu_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ende at qib igamari Parisi munon qei der ibag qamamir: “Meimet qamb ininou qomon eng songi inorou qent ende at qib igoumon?” ");
INSERT INTO wnu_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ne Yisas der taui qamar: “Qoan Debit wonou yurau wurinob minemb etemir eng an maigas wanunger igoumon? ");
INSERT INTO wnu_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Wo Qenu wonou munai mor isub mani parau mian iset bigari munon sarau eng baab igour eng qas nub igour eng wo bo isub ba nub wonou yurau qei wurisa numir eng an me igub igoumon?” ");
INSERT INTO wnu_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ende qamb bo wonomit qamar: “Munangit wau Sabat inorou qen eng wonou aib igo,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Inorou qen geret Yisas inorou munai mor end isub qob wurinob qamb igoai. Qen end munon ger uberegen gurumtar eng end igoai. ");
INSERT INTO wnu_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Igoar end qomon imbigau munon eng ne Parisi yurau qei wuri Yisas qenen inorou qen me gitara gab igour end bo munon eng musieriner qamb mag nasi gab igurei. ");
INSERT INTO wnu_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Igamari Yisas wurinou misir eng ibag ne munon uben gurumtar eng nob qamar: “Der naget menmant et yar.” Ende qamara munon eng put der naget is menmant end nageterei. ");
INSERT INTO wnu_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ne Yisas wuri qebi qamar: “Ininou qomon eng inorou qen end maigas abar qamb gumatemirei igama gab igoun? Munon quguraget igama musiorune igom igoriner qiyo, ba sumungasi igumune uminer?” ");
INSERT INTO wnu_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ende qamb igeser ibag bis arir wogub munon eng nob qamar: “Uben degesi arir ge” Ende qamara deges arirama uben gurumot igoar eng wagerei. ");
INSERT INTO wnu_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ende aba gab oau biriberi nub wogub tap ger gab waramb qamb qob nub igurei. ");
INSERT INTO wnu_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Qen geret Yisas Qenu nob qemerib qamb ai qaurt irab itum end qamb igamai urigeramorei. ");
INSERT INTO wnu_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Urigerma ne wonou wuriimbig qib igoar eng 12-ende wurit qamara yarari unum “aposel” wurit qamarei. ");
INSERT INTO wnu_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","qamb ne unum gari-gari wuribigor eng, Saimon wot Pita qamarei. Ne Pita umour Andru ne Yems Yon nob ne Pilip, ne Bartolomyu. ");
INSERT INTO wnu_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matyu, Tomas, ne Yems ger ur unum Alpius eng, ne Saimon unum ger Selot qamb igour eng. ");
INSERT INTO wnu_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Ne Yudas Yems ger wonou wau eng ne Yudas ger ur unum Iskariot qamb igour eng wo Yisas waramar qamb wuri bireberiamor eng ende. ");
INSERT INTO wnu_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Unum ende wuribig wogub ne bo wurinob qurumut qumo darab wonou yurau aib eng nob naget igurei. Igamari munon ai Yudia end igour eng ne Yerusalem munon qei ne ginam aib Tair Saidon nob tomon ye gabut igour eng ende. ");
INSERT INTO wnu_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Wuri Yisas qob qamara igub qamb ne qei toar asin igab igoar eng ne qei aibigau igaramor eng ende wurinob derari wurimusub igoai. ");
INSERT INTO wnu_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Qei ende diab Yisas git goan qas beari wonou meriri eng aba toar wogubriamirei. ");
INSERT INTO wnu_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ne Yisas wonou imbigau yurau eng ibag bis arir wogub wurinob qamar: An munon mi ue igo gab eng an mismisir igoarar. Qenu mi bibis bigor eng aninou. ");
INSERT INTO wnu_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ne an minemb gab eng gor mismisir igoarar bo qur di igoruboumon. Ne qugurau ger gab toubet eab gab eng gor mismisirar, bo uberet igoruboumon. ");
INSERT INTO wnu_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ne an Munangit wau toat igamari animbag eng me anqenungunorei. Ende at anqarausi, an mogirt wab wogub ne animbogounor eng mi boru gas ende animbag mindigar qob anit qomorubour. ");
INSERT INTO wnu_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ende ansiarari gab eng an mismisir uru uyab ende abar. Obounon eng qen geret taui qamb mi uber erer qite igo eng an bauboumon. Eng an gari see me ansiorunorei, urimagrari qoan qob gigit qamarau munon wurisiamir gas ende bo an sabum ansiorubour. ");
INSERT INTO wnu_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","End ne munon ye sau binat qamb gab eng qoyamet igoriner. Eng wo mi uber-uber ag e mom baub igo, end bo sabar mi uber me bainerei. ");
INSERT INTO wnu_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Munon mi nub qurt igour eng qoyamet igorunor. Qen geret bo qunumber qen gagamt igorubour. Ne see uberet igerig igo gab eng qoyamet igoarar. Qen geret bo toubet eab qugurau mom buruboumon. ");
INSERT INTO wnu_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ne see munon gugum an qob qamarari igub anit ubererari gab eng an aninomi qerei imbigar. Mai, an qob apand qamarari igub mismisirour qiyo, eng qerei imbigar. Qoan ir urimagrari munon miteri qetopur qamarari ende wurit uber qamb igurei, eng gas ende ansiorubour. ");
INSERT INTO wnu_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","End ne see ye aninob quraum eng igar. Aninou munon qarau wuriqenungar ne munon qei ansumungasiari gab an wuri ba qubeimar. ");
INSERT INTO wnu_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Aninob agunub sai qob anit qamarari gab wuri nonogursi qob uber wurinob qamarar. Ne munon ansumungasiari gab wurit igub Qenut qebi qamarar. ");
INSERT INTO wnu_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ne munon ger nananamt aningarama gab eng bo nananam ig bigatari waraminer. Munon ger mingoan net baia gab eng wot me misiringeter, wogub bo ger ut. ");
INSERT INTO wnu_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Munon ger mit qibirat qamara gab eng me du, benau ut. Ne ger, mi urim net baia gab eng ne bo taui mi yeis qamb me wot qem. ");
INSERT INTO wnu_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ete gas, an munon qei ende inubersiar qamb igub igoumon gas ende an munon qei ende wuriubersiarar. ");
INSERT INTO wnu_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ende qamb ne qamar: “Ne munon ger ne qenunga ne, ne bo taui qenunget eng maigas nonogureteriban? Munon qomon boru ten igour eng gor ende at igour. ");
INSERT INTO wnu_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ne gor, munon ger ne musia ne gor wo musub eng gor maigas nonogureteriban? Eng gor munon qomon boru ten igour eng wurinou taui-taui mi qiwurisab ba igour. ");
INSERT INTO wnu_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ne gor, munon ger mi yeis qamb aninob qamara gab eng utune bo taui indarar qamb misir igub igorunon eng an maigas nonoguretoruboumon? Munon qomon boru ten igour eng wurinou-wurinou mi qiwurisab taui qeemben ende ba igour. ");
INSERT INTO wnu_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ende me abar, an munon qarau wurit igub wuriubersiarar. Mi wurisab eng bo taui indarunor qamb me igar. Ende obounon eng an qen geret Qenu sig uber eng wonou wau iitari igo mi uber taui qamb bauboumon. Wo munon wot me igub igour eng ne munon boru soro ar eng wurimusub igo. ");
INSERT INTO wnu_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Qenu inmusub igo gas ende an gor munon qei wurimusiarar.” ");
INSERT INTO wnu_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ende qamb qamar: “An munon wurit qamb qomon me qereimar. Ende obounon eng Qenu gor aninou qomon me qereiminerei. A munon qei wuri me quguragsiorunon eng wo gor me anquguragsierinerei. Ne munon qei qomon boru abari wuri me sinungar obounon eng wo gor an me sinungarinerei. ");
INSERT INTO wnu_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Munon qei mi wurisunon eng Qenu gor andariba. An munon qomon wurisi igoumon gas ende Qenu bo taui ende gas ansieriner eng sig erer aib.” ");
INSERT INTO wnu_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yisas qob eng ende wurinob qamb bisi yarab bo mit big ete qamar: “Munon ger mag tuum igama ger gor mag tuum igama tap sirbig me isinerei. Ende ebet eng ombur yaru isub umubour. ");
INSERT INTO wnu_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ne ger skur wau igo wonou imbigau munon me imbiginerei. Wo igoi skur aibt isub mi gugum qoyamet ne imbigau munon gas ende burab ne wo bo wonou imbigau munon eng uput igoriba. ");
INSERT INTO wnu_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","End ne, ne mai nam sau aib mag net isuor eng ten igama nonou bain mi qanganing wot isar eng gusi arirameteib at igoan? ");
INSERT INTO wnu_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ende at maigas wot qemeriban? Mai ete wot qemeriban qiyo? Bain, ete aba mi qanganing mag net isar eng gusi arirameteibam. Ende qemerinen eng nam sau aib nonou magqurt end isai igo. Eng gab ne ende ebeiner eng misuue, end ne gigit nonou nam sau aib net isar eng gumotenerub mi musub gab uber misir igub ne bain mi qanganing wot isar eng gusi ariramatat.” ");
INSERT INTO wnu_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ende qamb ne bo qamar: “Nam qur uber biga nub igoun eng bo nam qur uter me big igo. Ne nam qur uter eng bo qur uber me big igo. ");
INSERT INTO wnu_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Munon nam gugum imbig igour. Nam qur qei niau uber, a qei boru ende imbig igour. Mai, an qiser nub qamb eng nogam ubent igama opurmboumon qiyo? Ne wain qur imbi igo eng nam qaar uben end me di igo. Wo wain qor end qeemben imbi igo. ");
INSERT INTO wnu_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ende gas ende munon misir uber eng wo qomon uber sig ebet qib igo. A munon misir boru eng wo qomon boru qas ebet qib igo. Misir boru eng wot igo eng bo qabarit dibes qamb igo. ");
INSERT INTO wnu_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","End ne an meimet qamb ar yet “Barai, barai” qamb wogub mi abar qamb anit qemerine me ebet igoumon? ");
INSERT INTO wnu_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Munon yet yarari qob wurinob qemerine iruges big igub toounor eng ye wuri qomon eng an imbigibam. ");
INSERT INTO wnu_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Eng ete gas, munon ger mon qoren yemb qamb nomon erer tumun goanet bis qum qumond wogub qoren yab mon mindaterei igama ya aib der yuum yar mon eng bar eng bais me uyau. Munon eng mon mindau mom qoyam end mom nausier end. ");
INSERT INTO wnu_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","A, munon ger ye qob qemerine iruges big igub me toat igo eng ete, Munon ger mon qoren yemb qamb ar orosout tumun goanet wogub mon mindaterei igama ya aib der yuum yar orosou eng goanet ba isub ugea mon uburab isub munon eng warama umorei.” ");
INSERT INTO wnu_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yisas qob eng mom ende wurinob qamb wogub bo Kaperneam isorei. ");
INSERT INTO wnu_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Isa Rom yogorau munon yurau ger oroar igoar eng wonou sarau betet igoar eng toar aib wara umib pisi igoai. ");
INSERT INTO wnu_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Yisas ende isa qob toau igub wonou sarau betet igoar eng borusi qenunget igoar end iren uminer qamb Yuda munon baraitari qei wuriimurima irab Yisas nob qamarari et darab musi qamb wuriimurima iramirei. ");
INSERT INTO wnu_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Irab Yisas qand nob qamamir: “Munon eng ne musierinen eng uber. ");
INSERT INTO wnu_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Wonou munon baraitari eng in Yuda munon inqenungar ne inorou munai aib eng mindatarerei.” ");
INSERT INTO wnu_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ende qamarari Yisas wurinob isorei. Isi pisiari ne bo munon qei wuriimurima irab Yisas gab nob qamamir: “O Munon barai, dibogoten wab qib igoan eng. Ne ye munai mor yarinen eng qeemben ue. Ne gor ye ne menmant irini eng gor uber ue. ");
INSERT INTO wnu_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Eng gab mugenderi ende igo qobt qas qamara yonou sarau munon uberburiner. ");
INSERT INTO wnu_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ye gor munon barai qei, sarau eb yet qamarari ebet igoum. Ne yonou yogorau munon eng wuri ye qob qemerine ye toat igour. Ye igo ger nob ete qemerin eng, “Isi” qemerine eng isub igo. A bo ger nob, “yar” qemerine eng yar igo. Ne yonou sarau besab igo eng nob, “Mi eng eb” ende qemerine ebet igo.” ");
INSERT INTO wnu_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yisas munon eng qob ende biga ir qamarari igub qiet ne wot mismisir ne igeser munon yurau toat isub igour eng wurinob qamar: “Ye qoan Isrel munon yurau end munon ger oau apand ende ger me geau.” ");
INSERT INTO wnu_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ende qamara wogub munon eng munon wuriimuriamor eng bo mor isub gamir eng wonou sarau munon eng uberetarei igama gamirei. ");
INSERT INTO wnu_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Yisas eng ende at wogub ne bo bais umi-umi ende at wogub wonou yurau wuriimbig qib igoar eng ne munon yurau ar qei toat qib igour eng nob bo munai ginam Nain eng isumirei. ");
INSERT INTO wnu_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Isi munai ginam qani isub gamir eng munon mumun ger tumunimb qamb ba diamirei. Munon eng yamangar ger umami qoan umorei igama wonou wau gari qas eng nob igoar eng uma wogub munon ginam aib eng nob ba di igurei. ");
INSERT INTO wnu_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Munon aib yamangar eng wonou wau end borusi mom toubet di igama gab nob qamar: “Me yei.” ");
INSERT INTO wnu_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ende qamb ne munon mumun gar eng qani is bea ne munon togor igour eng nagari munon mumun eng nob qamar: “Wau moi, ye ne meni igoum, der bugom.” ");
INSERT INTO wnu_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ende nob qamara munon mumun eng der bugab qanambig qob qamara imurima unort isorei. ");
INSERT INTO wnu_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Munon gugum ende gab qesi igara Qenut igub qamamir: “Qob gigit qamarau Munon aib ger qo init darar eng. Qenu wonou munon yurau eng wurimusierib qamb dara.” ");
INSERT INTO wnu_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ende qamb qob bigari munon ginam Yudia ne ginam gugum isa igumirei. ");
INSERT INTO wnu_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","19","Ne Yon wonou wuriimbig igoar yurau eng mi end gugum nob qamarari igub wogub ne ombur-ombur wurit qamara yarari wuriimurimb qamar: “An irab Munon aib ete qebi gaiar: Ne munon eng gari deriba Yon inimbig qamb igoar eng qiyo, in munon ger bo qoat igoruboun? ");
INSERT INTO wnu_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ende qamb ne wuriimurima Yisast irab qamamir: “Yon inimurima diab ne mai munon eng deriba Yon inimbig qamb igoar eng qiyo, in munon ger bo qoat igoruboun?” ");
INSERT INTO wnu_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Qen end Yisas munon yamangar irou toar ar igab igoar eng qiyo aibigau igaramor eng wurimusub a mag tuum buremir eng wurimusia bo asi qiyo ende-ende atri igoai. ");
INSERT INTO wnu_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ende at igama Yon qob eng end ir qamarari taui qamar: “An mi e gagar gab ne qemerine igoumon eng isub Yon nob qamarar: munon mag tuum bo asi mi gaur, ne goten gurumtar eng bo qib igour, a tumau gab igour eng bo woumriroa ar igour, ne munon quum eng bo qob igub igour. Ne munon umour eng bo wurimenima igomot der bugomour, a munon boru-boru eng qob uber igub ende at igour. ");
INSERT INTO wnu_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ne munon ger ye ebetri igoum eng gab siningot ye mogirt wab me igoriner eng Qenu wo musia ubereteriba.” ");
INSERT INTO wnu_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Yon munon ombur eng qoari ne Yisas munon yurau aib eng Yon wot qanam wuriimbig qamar: “Qoan Yon seger ait igama is qoat igamari meimi aba gamanei? Ar moon di qagab bea gub qamb isomanei qiyo? ");
INSERT INTO wnu_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ue, aninou ar isomanei ne? A, munon ger mingoan uber qumani igama gub qamb isomanei ne? Munon uber mingoan ende at qumani eng munai uberet igoriba. ");
INSERT INTO wnu_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ye nob qamarari igini, meimi gub qamb isomanei? Munon qob gigit qamb igoar eng gub isomanei qiyo? Io, ye ete aninob qemerine igar, munon qob gigit qamb igour eng gugum wuritanamimar eng gub isomanei. ");
INSERT INTO wnu_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Yon wot Qenu qamara ete gumatemirei, Munon e yonou qob ba gigit tap imotet isiba. ");
INSERT INTO wnu_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Qob ende igoar end aninob quraum.” Ende qamb bo qamar: “Yon wo munon qei unor wuri baub igour eng wuritanamima. Ne munon ger, Qenu wonou bibis end igoriner eng wo Yon wotanamima.” ");
INSERT INTO wnu_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ne munon ar ne gabmant qur ba igour eng, Yon qob qamara igub: “Qo, Qenu wonou qob apand qamara igub igoun,” ende qamarari ne wurimaragansi ya obotarerei. ");
INSERT INTO wnu_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","A, Parisi ne qomon imbigau yurau eng Yon qob qamara igub Qenu wuriubersierib qamb ebeter eng nugutumugetemir end Yon wuri ya me obotarau. ");
INSERT INTO wnu_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ne Yisas qamar: “See ye meimit big munon wurinob qemerini qiyo? Wuri maigas? ");
INSERT INTO wnu_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Wuri wau qamaaman gas, qei ginamt qiumuni bugab igo qei wurit ete orunor gas, in sibemi woroun eng an uru me uyau. A ur umbisau woroun eng an toubet me eau. ");
INSERT INTO wnu_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Eng gas ende Yon munon ya obotarer eng wo diab mi gitab mani wain ya qamb me nia gab, “ai bigau waramai” ende wot qamb igoumon. ");
INSERT INTO wnu_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","A, bo see munangit wau mi nub a ya nub aba an bo der ete qamb igoumon: “Wa munon eng gaiar, wo mani qamb ya qamb niau tari.” Ne gor wo munon Rom gabmant qur ba igour eng nob munon mindigar qoat eng wurimbanamsi qib igo.” Ende qamb igoumon. ");
INSERT INTO wnu_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","A munon Qenu qob igub wot oabig toat obounor eng wuri misir uber igub Qenu qob end apand qomorubour,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Parisi munon ger Yisas nob mi nib qamb wot qamara wonou munai mor end isub bugab mi nub igoai. ");
INSERT INTO wnu_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Igama ne yamangar qarig ir qib igoar eng, ger ginam end igo Yisas Parisi munai end mi nub igo ende qamarari igub yarib qamb maurem ya qogom sig maieng eng garant igoar eng ten ba yarerei. ");
INSERT INTO wnu_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Yarab Yisas mogirt end naget igo ea mag ya der Yisas gotent isa wogub ne wonou tari im end baimetet ne ambuget wogub maurem ya ba yarer end wot igimeteterei. ");
INSERT INTO wnu_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Munon Parisi Yisas wot ara isuor eng, yamangar eng ende aba gab wonou misirt qas qamar: “Wa, munon eng apand qob gigit qamarau igo ende qi eng yamangar wonou qomon boru qarig ir qib igoar eng diban gab imbiga qi.” ");
INSERT INTO wnu_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ende qamb igama Yisas der wonou misir eng gab nob qamar: “Saimon, ye mi ger nonob qemerine igu.” Ende qamara Saimon der qamar: “Io, yonob qamara igini.” ");
INSERT INTO wnu_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Qamara Yisas der qamar: “Munon ombur-ombur, munon geret mi ar baumir eng ger nomon qur qangang K500 ne ger K50 gari. ");
INSERT INTO wnu_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ne ombur maigas me tauimunorei eng gab ne wuritaisia wagomirei. Wogub your munon eng sig-sig mom qenungeiba? ");
INSERT INTO wnu_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ne Saimon qamar: “Munon nomon qur qangang aib mi bauor eng ombur ende wuritaisia munon nomon qur qangang aib bauor eng wo uberetarei.” Qamara Yisas taui qamar: “Nonou gari qeemben quran eng.” ");
INSERT INTO wnu_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ende qamb wogub yamangar eng igeser gab Saimon nob qamar: “Ye set nonou munai mor e yoroum eng ne ye goten me birogonimisau. yamangar e abar eng ne ge. Wo yarab yet ea wogub mag yat ye goten birogoni wogub tari imt baimisar eng ende ge. ");
INSERT INTO wnu_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ne ger ye mor diaum eng ne ye me yeambugau, isi yarab see qas yamangar e yesiar eng. ");
INSERT INTO wnu_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ne gor maurem yat ye tari im me qosisau, eng yamangar wo maurem ya qogom uber end ye gotent isi qosisar eng ge. ");
INSERT INTO wnu_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","End ne ye nonob quraum, yamangar e wo sig-sig mom ye qenungar eng gab an imbigar: Qenu wo yamangar eng wonou qomon boru irou wot igo end merimotet me weginerei. Wo yamangar eng mom ubersiar end yeqenunget eng abar eng. A munon ger qomon boru gari-gari wot igo end Qenu ubersieriner eng bais-bais yeqenungeiba.” ");
INSERT INTO wnu_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ende qamb wogub yamangar eng nob qamar: “Nonou qomon boru end ye namat me qemerinei, ye nemusiaum.” ");
INSERT INTO wnu_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ende qamara munon nam qabt bugab igour eng wurinou qob-qob qamamir: “Munon eng your igo qomon boru eng musia?” ");
INSERT INTO wnu_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ende qamb igamari Yisas yamangar eng nob qamar: “Nonou oau apand end qomon boru net ubura, sarog big is qib igoar,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Qen bais dirigor nami ende ubura ne Yisas wonou wuriimbig qib igoar eng nob bo ginam aib ne ginam qamaaman end isub qib qob uber Qenu wonou bibis bigor qanam eng wurinob qamb qib igurei. ");
INSERT INTO wnu_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ende qib igamari yamangar qei qoan toar igara musuor eng nob qib igurei. yamangar ger unum Maria Makdala qoan aibigau 7- ende wot isorei igama musuor eng. ");
INSERT INTO wnu_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ne ger Yoana, Kusa wonou ubeni, Kusa wo King Herot wonou munai qoat igoar eng, ne ger Susana ne yamangar qei gor Yisas wonou imbigau yurau eng wurinob mi wurit ba qib mani yamatar igurei. ");
INSERT INTO wnu_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Qib igamari munon ginam aib-aib eng irou yar Yisast qiumunimari Yisas mit big ete wurinob qamar: ");
INSERT INTO wnu_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Munon ger wit qur bunumban ariramb qamb man isorei. Isub arirama qur qei is ai tap qenen qib igourt end dara napi qiroari diban igama morogan numirei. ");
INSERT INTO wnu_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ne qei ai nomon qer diban end der igo qaur diamir eng ai um ue end worom yara qand gegeret uburemirei. ");
INSERT INTO wnu_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ne qei arirama is maran mont deremir eng git qaur diamir eng maran mom wuri iribiga git musub me ombomai yarau. ");
INSERT INTO wnu_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ne qei is ai uberet end deremir eng qaur mom musub di git ombomai yaremir eng qanam gari end git 100-ende sisinam.” Ende qamb ne qamar: “Munon wonou gari-gari, iruges big qob e quraum eng igib qamb eng wonou qas.” ");
INSERT INTO wnu_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ende qamara wonou imbigau yurau eng der me imbig qebi qamarari wo der qamar: ");
INSERT INTO wnu_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","“Qenu wonou bibis qob eng qi igoar eng animbiga qo gamanei. Ne munon yurau qei wuri ye mit big quraum eng qas igub gub qamb asimour eng mi git me gaur. Ne qob git igour eng qanam sir me imbigour.” ");
INSERT INTO wnu_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ende qamb mit big qamar eng qanam wurinob qamar: “Qenu wonou qob eng wit qur gas ende. ");
INSERT INTO wnu_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Wit qur is ai tap qenen qib igour igama morogan niar eng, munon qob igunor eng Satan wo bo qob igub wot oabigunor qamb bo wurit ousi igo. ");
INSERT INTO wnu_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ne wit qur is ai nomon qer dibant igo di bo qand gegeretar eng munon qob igub oabig bais gurum nami ende igama bo mi qei warigesia qob eng bo qand siningot wogub igo. ");
INSERT INTO wnu_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ne qur is maran qur nob igo morogot qaur di git ubersi me ombomai yarau eng, munon qob igub oabig wogub is qib ne bo mi uber-uber gab a nomon qur gab a mind irou gab end mismisir ne qob igub oabiginer eng git bais-bais igoriner ego mind end qas misir aib mom igub wogub eng bumai igo. ");
INSERT INTO wnu_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ne ger, wit qur is ai uberet der igo qaur di isari git irou ombomai yar igo gas eng, munon qob mom iruges big igub wot oabig igamari mi uber-uber gab, qiyo munon qei qinan qob wurit qamb qiyo, a mi qei warigesieriner end wot uburab me isub igour. Qob end mom gari oabig ne taut abari Qenu wurisiera qomon qoregen ba dibes igorubour. ");
INSERT INTO wnu_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yisas ende qamb ne bo mi geret big qamar: “Munon ger urut uruguni begestarib qamb uruguni egi erobon qiyo, saberi erobon me big igo. Wo uruguni ba ai deberit naget begestara begen gab di igour. ");
INSERT INTO wnu_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Eng gas ende, see mi wabi qiyo, mi suumt bugamanimour ten igo eng gugum qen geret Qenu ba dibesia munon gugum diban gubour. ");
INSERT INTO wnu_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Munon ger Qenu qob igub taut qoyamet ig eng wonou misir bubun imusia mi qenen imbig igoriba, a munon qob eng siningot wogub me qoyameterin qamb gab ieriner eng misir qoan eng Qenu wonou aba mom nasi wegiba,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Qen end Yisas wonou unor umuragrari gub qamb diamir ego munon yurau irou opurmari pi is me geau. ");
INSERT INTO wnu_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ende igamari munon qei is Yisas nob qamamir: “Nani imaori big nogoub qamb diab ag eiro igour.” ");
INSERT INTO wnu_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ende qamarari Yisas taui gugum wurinob qamar: “Munon yamangar ye Qenu qob qemerine igisab toour eng yonou nani yonou imaori.” ");
INSERT INTO wnu_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ende qamb igoi wogub qen geret wonou imbigau yurau eng nob tabint isub wurinob qamar: “Wagari ya tai e wogub ig irot isun.” Ende qamb tabin baab ten isumirei. ");
INSERT INTO wnu_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Isub qataben Yisas inib qamb tabin suit is inerei. Ina wurinou qas tabin baab isub igamari sani-sani sig aib ya tai end diarei. Diab ya bures ba mor arir wurisumungasia pondogub isub igurei. ");
INSERT INTO wnu_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ne qand isub Yisas menub qamamir: “Barai, umub pisi igoun e me ga aa?” Ende qamarari Yisas qand der bugab sani-sani di ya bures arir igoar eng wuritaisi qamara wagomirei. ");
INSERT INTO wnu_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ne wonou imbigau yurau eng wurinob qamar: “An meimet qamb ye yenasi wogub igo at igoumon?” Ende wurinob qamara wuri yari wurinou qob-qob qamamir: “Wa, eng meimi munon ende igo sani-sani di ya bures arir igemerei eng taisi qamara waga, aa?” ende qamamirei. ");
INSERT INTO wnu_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ende at wogub Galili ya tai eng wogub isi Gerasa end weib isumirei. ");
INSERT INTO wnu_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Isub Yisas tabin wogub ir daan igama ginam end munon ger aibigau qoan bumaima ginamt me igamau. Qen irou munon ar qei munon eng qoat bunomt uben gotent touri igour eng aibigau waramor end bunon eng ombopur ai munon uet end iua igoai. Mingoan gor me qumani igamau, qenen wonou munon teteret end qas inab igoai. Qen end Yisas munon eng yara gab wo aibigau munon eng wogub iua qamb nob qamara munon eng Yisas qani end inab atag ar: “Yisas, ne Qenu sig aib eng wonou wau, ye mai yesieriban? Ye me yesumungasi qamb nonob quraum.” ");
INSERT INTO wnu_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Munon eng ende qamara Yisas nob qamar: “Ne unum your?” Ende qamara wo qamar: “Ye unum eng yurau irou,” ende qamarei. (Yurau irou qamar eng qanam eng aibigau irou wo opuri igour end qamarei). ");
INSERT INTO wnu_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Aibigau eng Yisast qamamir: “Ne in imurimb eng ar ai qorut et me in imuriom,” ende qamamirei. ");
INSERT INTO wnu_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Munon eng igoart ai qaur ig end bur yurau aib ger qoat mi wurisab igurei. End ne aibigau inimurima bur yurau end isun qamb qamarari end wuriimurima isumirei. ");
INSERT INTO wnu_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Aibigau munon eng wogub isub bur yurau aib eng wurit isari bur eng uyab-uyab der ai yar aib eng isub ya tumun isub ya nub umb uburemirei. ");
INSERT INTO wnu_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Munon bur qoat igour eng ende gab iua qob suari munai ginam aib-aib eng ne munon yurau qei bur oroar igour eng gugum igub ugamirei. ");
INSERT INTO wnu_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Qob ende igub mi eng ebeter eng gub qamb iramirei. Irab Yisas gab ne munon eng qanganget igoar eng gamir eng bo uberet misir uber igub mingoan qumani Yisas goten qanamt bugab igama ir gab yariamirei. ");
INSERT INTO wnu_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ende abari munon qei Yisas munon eng musia gamir eng qanam musub qob suari igumirei. ");
INSERT INTO wnu_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ne munon ginam Gerasa eng gugum borusi yari wogub Yisas inwogub iua qamb qebi qamamirei. Qamarari tabin ba wuri wogub qoamirei. ");
INSERT INTO wnu_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Yisas ende isubari ne munon musuor eng der Yisas nob isib qamb eab qamar: “Waga, ye nonob isini,” qamar ego Yisas imuri qamar: ");
INSERT INTO wnu_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Nonou ginamt irab Qenu nemusiar end wurinob qem.” Ende qamb imurima wo ginamt irab munon yamangar gugum Yisas musuor end qob sua igumirei. ");
INSERT INTO wnu_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yisas ende isari wogub munon yurau irou is ya tai igeragart wes end is qoat igamari wuri qibi bo end diarari ibag borusi mismisiramirei. ");
INSERT INTO wnu_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ne munon ger unum Yairus, wo inorou munai qoat igoai. Wo Yisast diab goten qanamt et inab Yisas mot wonou munai mor isib qamb qamarei. ");
INSERT INTO wnu_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Eng wonou yamangar wau gari qas togun 12-ende nob igoar eng umib at igama di qamarei. Qamara Yisas isib qamb isa munon yurau irou toat toaubig isub igurei. ");
INSERT INTO wnu_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Qen end yamangar ger amug isub qib igama togun 12-ende warei, bais me boopur wagau. Ende igo qenen ye musiar qamb qiroa musiari taui mi wurisab qibi seret wogub igoai, ger me musiau. ");
INSERT INTO wnu_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ende at igoar end qen end munon yurau aib Yisas nob isub igamari wo mogirt itot yar Yisas mingoan gabut qas is qotara qen end qas amug isub igoar eng boopur wagerei. ");
INSERT INTO wnu_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ende aba Yisas git goan bibinat igub qamar: “Your yeqotarai?” Ende qamara gugum der, “ye ue, ye ue” qamb bisari Pita der qamar: “Barai, mai, nonou gari et isub igo “your yeqotara” quran, munon irou neqoui isub igo neqotorour.” ");
INSERT INTO wnu_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ende qamara Yisas qamar: “Ue, munon ger mom yeqotara ye git goan bibinat igub quraum.” ");
INSERT INTO wnu_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ende qamara yamangar eng igor eng maigas me wabereminerei eng gab ne qes wara diab Yisas goten qanamt end wonomi arir inab ne munon irou magqurt Yisas qotara ne amug isub igoar eng boopur wager eng gugum Yisas nob qamarei. ");
INSERT INTO wnu_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Qamara Yisas nob qamar: “Io, nonou yet oabig ebet uberburan eng gab isub sarog big qib igoar,” ende nob qamarei. ");
INSERT INTO wnu_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yisas ende at igama ne yamangar wau eng uma wogub munon ger diab ur nob qamar: “Ne wau oau waga wogub diaun. Imbigau munon barai aib e bo sabar dibogoten wab me isiner.” ");
INSERT INTO wnu_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ende nob qamb igama Yisas toat igub Yairus nob qamar: “Ne me toubei, yet oabig, nonou wau bo uberburiba.” ");
INSERT INTO wnu_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ende qamb wogub nob isumirei. Isi yarab Yisas mor isib qamb munon qei wuriwogub Pita ne Yems Yon ne wau ur unor ende oromar isumirei. ");
INSERT INTO wnu_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Isari munon yamangar irou borusi toubet eab ousiari Yisas wurinob qamar: “Me eaiar, wau e me umau, mungam naat inai igo.” ");
INSERT INTO wnu_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ende qamara qei der wot igerigumirei. ");
INSERT INTO wnu_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ne Yisas wau uben bemeni nob qamar: “Wau, nemeni igoum, der bugom.” ");
INSERT INTO wnu_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ende qamara wau eng qand der bogoma mi utari niner qamb qamarei. ");
INSERT INTO wnu_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Wau ur unor nob ende gab qesi igarei. Ende ebet qob suari munon ginam gugum igunor qamb qoronob wuritaisiarei. ");
INSERT INTO wnu_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ende at wogub Yisas wonou imbigau yurau eng wuriba qiumuni wogub munon toar nob wurimusub ne munon ai igaramor eng qib igoarar qamb wurinonogursiarei. ");
INSERT INTO wnu_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ende at wogub wuriimurima iua Qenu mi bibis bigor eng wurinob qamb ne toar nob wurimusub qib igoarar qamb ");
INSERT INTO wnu_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Wuriimurimb qamb wurinob qamar: “An isub qamb mi ger me baiar, tugotau qiyo, abau boru ger qiyo, a mani qiyo nomon qur qiyo ne mingoan uput nagun qamb me baiar. ");
INSERT INTO wnu_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","An qibi munai mor ger isunon end qas igoi wogub bo der ginam eng wogub tumbigi isar. ");
INSERT INTO wnu_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ginam ger isunon eng munon ginam eng an merimotar abari ibag irumban gotent eng bai ariramar. An ende abari munon ginam eng an sinungarunor end qininingubour.” ");
INSERT INTO wnu_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ende wuri irun wab waga wogub wuri der munai ginam-ginam isub qob uber wurinob qamb a toar nob wurimusub qib igurei. ");
INSERT INTO wnu_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ende at qib igamari munon qei der king Herot Galili ai qoat igoar eng nob qamamir: “Yon bo igomot der bugab at qib igo,” ende qamarari Herot mingong irarei. ");
INSERT INTO wnu_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ende aba qei der qamamir: “Elaiya bo der ebet qib igo” qamamir, a qei qamamir: “Munon qob gigit qamb igour qoan umburiamir eng ger bo igomot der at qib igo.” ");
INSERT INTO wnu_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ende qamb abari Herot der qamar: “Ye Yon quman soopurmine umor eng bo eng your ende at qiroa qob toau igoum?” Ende qamb Yisas gib qamb at qib igoai. ");
INSERT INTO wnu_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Qen end Yisas wonou imbigau yurau wuriimuriamor eng qibi diab mi gugum ebet qib igour eng nob qamarari igub wogub bo oromar wurinou gari ginam aib ger Betsaida end isumirei. ");
INSERT INTO wnu_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Isari munon yurau aib qob toau igub wuritoar isumirei. Isub geari mismisir ne Qenu wonou bibis end igour end wuriimbig ne toar munon yaremir eng wurimusub ende at igoai. ");
INSERT INTO wnu_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ende at igama igoi ituramba gab wonou imbigau yurau eng yar Yisas nob qamamir: “Seger ai e gab munon yurau eng wuriimurima qoounor. Iua wurinou ginamt mi gab nunor.” ");
INSERT INTO wnu_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ende qamarari Yisas der wurinob qamar: “Ende ue, aninou mi wurisari nunor.” Ne wuri qamamir: “In mani parau 5-ende ne yagwai ombur-ombur gari igo, eng munon yurau ete eng qeemben ue. End ne, ne qamara in bo is mani bo taui badi e nob sori werisun eng bais qeemben nami ende.” ");
INSERT INTO wnu_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Munon yurau eng igour eng 5,000-ende. Ne Yisas wonou imbigau yurau eng wuri nob qamar: “Munon wurinob qamarari qarangaret 50, 50-ende bugomunor.” ");
INSERT INTO wnu_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Qamara ne ende abari bugeramirei. ");
INSERT INTO wnu_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ne Yisas mani parau 5-eng ba ne yagwai ombur eng ba matar asi Qenut qebi qamb ne boroumi wonou imbigau yurau eng wurisa baub munon yamangar wurisemirei. ");
INSERT INTO wnu_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Wurisari mom nub mani tatau wagari imbigau yurau eng mani tatau usisi tugar 7-ende tugarimari diarei. ");
INSERT INTO wnu_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ende at wogub qen geret Yisas wonomai Qenut qamb igama wonou imbigau yurau eng wot yarari qamar: “Munon yurau aib eng yet mai qamarari igub igoumon?” ");
INSERT INTO wnu_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ende qamara wuri qamamir: “Qei nenet Yon munon ya obotar qib igoar eng, ne qei nenet Elaiya, ne qei munon Qenu qamara miteri qamb igour qoan umburiamir eng ger igomot der bugab at qib igo ende net qamb igour.” ");
INSERT INTO wnu_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ende qamarari ne wurinou sir bo wuriqebi qamar: “Ende eng an yet your qamb igoumon?” Ende qamara Pita der qamar: “Ne Qenu wonou munon yurau wuriubersiau tari eng ne.” ");
INSERT INTO wnu_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ende qamara Pita at munon qei wurinob qemeriner qamb qoronob nob taisi wogub bo imusi qamar: ");
INSERT INTO wnu_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","“Munangit Wau sig borusi qugurageteriba. Ende aba munon baraitari ne munon mian yamau gigit eng ne qomon imbigau eng der mogirt wab wogub waramari uminerei igo qen ombur gari uma bo igomot der bugemba.” ");
INSERT INTO wnu_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Pita gari ende nob qamb wogub bo gugum wurinob qamar: “Munon ger ye yenob qib igorib eng wonomit misir me iginer. Quguraget gab eng end misir igub me weginer. Qenen ye yewapet ye toat qiriner. ");
INSERT INTO wnu_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Munon ger wonomit igub wonou git goan me duieminer eng, mom umiba. A munon ger yet igub wonomi duieminer eng qenen bebereg igoriba. ");
INSERT INTO wnu_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ne munon ger mi uber-uber ba ye mom sau binat qamb igoriner eng bo wonou qau borusieriner eng mi eng gagar der bo maigas nonogursieriba? sig ue. ");
INSERT INTO wnu_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ne munon ger yet qinining qiyo, yonou qob munon wurinob qemerib qinininginer eng Munangit wau gor qen geret wonou qiribiten ne ur ne enger wurinou qiribi eng ten darab wo gor gab qininingiba. ");
INSERT INTO wnu_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","End ne ete qemerine igar. An e igoumon eng qei igom igo Qenu wonou bibis eng aba gab wogub umuboumon.” ");
INSERT INTO wnu_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yisas wo mi eng ende wurinob qamb wogub igamari inorou gari uma ne Pita ne Yon ne Yems ende oromar Qenut qebi qomorub qamb ai qaur geret iramirei. ");
INSERT INTO wnu_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Irab qebi qamb igo Yisas menman wes bura geari ne wonou mingoan gor sig oan qenengi nob burerei. ");
INSERT INTO wnu_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ende aba gab igamari munon ombur-ombur diab Yisas nob qobub igurei. Munon eng ger Moses ne ger Elaiya. ");
INSERT INTO wnu_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ombur qiribiten der Qenu Yisast mi Yerusalem end ebeiner qamb qamar end nob qamb igurei. ");
INSERT INTO wnu_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pita munon ombur eng nob mungam igara inub at igamari Yisas mi wes eng aba munon ombur der nob qobub igamari ibag bo asi ibag igurei. ");
INSERT INTO wnu_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ibag igamari Moses Elaiya nob qoaubari ibag Pita der Yisas nob qamar: “Barai, in mon ombur gari ginam et mindaun eng uber. Ger nenet ne ger Mosest ne ger Elaiya wonou.” (Pita eng qamar eng misir igub me qamarau, song ar qamb igoai). ");
INSERT INTO wnu_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pita qob eng ende qamb igama waber ger der wuriumima gab borusi yariamirei. ");
INSERT INTO wnu_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ende aba qob toau ger waber erobon end ete qamara igumirei: “Munon eng yonou wau ten, wo ye anit maribigataremei, wo qob qamara igetet igoarar.” ");
INSERT INTO wnu_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Qob toau eng ende qamb waga gamir eng munon ger me igamau, Yisas wonamai igama gamirei. Gab tumbet wogub qob ger me qamarau, ne gor munon ger bais me nob qamarau. ");
INSERT INTO wnu_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Urigerma ai qaur eng wogub qumo darari munon yurau aib Yisas gub qamb diamirei. ");
INSERT INTO wnu_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","39","Dearari munon ger erobon end der atag qamb ar: “Barai, munon e yonou wau ten gari qas e gab nonob quraum. Aibigau waramor eng ten igo nob yogora qenen qob isi qamb ab ne waramb arir igo. Ende aba qenen mu badi qabarit waramb aba qand me uberet igo. ");
INSERT INTO wnu_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","End ne nonou wuri imbigau yurau e wurinob qemerine musiorun qamb obour eng maigas me uberburinerei eng gab wugurei.” ");
INSERT INTO wnu_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ende qamara Yisas taui qamar: “An munon oau apand ue, soageni abau sisinam. Ye qen mai-mai aninob igo quguraget qib igoribam?” Ende qamb wau ur nob qamara wau mot isorei. ");
INSERT INTO wnu_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Isub igama aibigau ten igoar end ba ai qenen qumo arirama borusi aruarei. Ende aba Yisas aibigau taisi qamara wau wogub qoa wau musub wogub urt imuriamorei. ");
INSERT INTO wnu_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ende aba munon yamangar Qenu wonou gagam eng gab qiet ne mi gugum ebeteriamor end misir qebebi igub isub igamari Yisas der wonou imbigau yurau eng wurinob qamar: ");
INSERT INTO wnu_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ye qob e aninob qemeribam eng an me nasiarar. Umi-umi Munangit Wau wonou ur eng duima munon qarau waramari umiba. ");
INSERT INTO wnu_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Eng qamar eng qanam meimet qamb qamar eng wuri sir me imbig qebi qamarau end qubig igurei. ");
INSERT INTO wnu_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ne wonou imbigau yurau eng der your wurinou baraitari gigit igoriner qi ende qamb agunub igurei. ");
INSERT INTO wnu_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Wurinou misir eng Yisas imbig wogub wau ger ba qubei nagasi ne wurinob qamar: ");
INSERT INTO wnu_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","“Munon ger yet igub wau e musieriner eng ye yemusub igo. Ne imusi ye yemusub igo eng tain ye yiimurima derem eng gor musub igo. Munon ger wau qomourt e gas ende igoriner eng baraitari gigit igoriba.” ");
INSERT INTO wnu_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ende qamara Yon qamar: “Barai, in munon ger gaun eng neunumot aibigau munon ger waramor eng musia uberbura gab in yurau et me ininob qib igo, eng wo gituturunei.” ");
INSERT INTO wnu_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ende qamara Yisas taui qamar: “An me gitatatar, munon ger an me qarausi igo eng aninou munon banam,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ne Qenu Yisas bo iriner qamb qen mari bigeteter eng pi bura gab Yerusalem isib eterei. ");
INSERT INTO wnu_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","End ne gim biga gigit isorei. Munon eng gim isumir eng is Samaria wurinou ginam geret isub mi arsiorub isumirei. ");
INSERT INTO wnu_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Isari munon ginam eng Yisas Yerusalem isib ater end munai me wuriimbigau. ");
INSERT INTO wnu_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ende abari wonou imbigau munon ombur eng, Yems Yon nob der Yisas nob qamamir: “Barai, ne mai misir igan? Munon ginam eng obour eng in Qenu nob qomurune mut aba der wuri oa umb uburunor qiyo?” ");
INSERT INTO wnu_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","56","Ende qamarari Yisas wuritaisi wogub ginam eng wogub ginam taut isumirei. ");
INSERT INTO wnu_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Qataben isub igamari munon ger diab Yisas nob qamar: “Ye ne nob ten qib igoribam.” ");
INSERT INTO wnu_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ende qamara Yisas nob qamar: “Iau qaar wuri irut igour a morogan wuri nam erer mon ubet igour. Ne munangit wau wo bugab umieminer eng munai ger ue.” ");
INSERT INTO wnu_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ende qamb ne bo munon ger nob qamar: “Ne ye nob qib igorun.” Ende qamara munon eng nob qamar: “Ue, yiimurima isub tain umar eng tumuni wogub nonob qib igoribam.” ");
INSERT INTO wnu_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ende qamara Yisas nob qamar: “Eng wog, munon umour eng qei igom igour eng yet me oabigour eng wurinou qi tumuni igorunor. Ne isub munon yamangar ete wurinob qem: “An Munon aib wot oabigari anubersia wonou bibis end igoruboumon,” ende wurinob qamara igunor,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ne bo munon ger di qamar: “Ye mom nonob qib igoribam end yiimurima isub yonou wau yamangar qamb eng wuriimbig wogub diab nonob qib igoribam.” ");
INSERT INTO wnu_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ende qamara Yisas nob qamar: “Munon ger Qenu wonou bibis eng igorib qamb ebet ne bo igeser mogirt asi eng Qenu bibis eng me ginerei,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Yisas qob eng ende qamb wogub wonou ginam is qiriner end bo munon 72-ende wuri qerei wogub ne ombur-ombur sig wurimaribiga ginam aib-aib qamaaman end isub qib igurei. ");
INSERT INTO wnu_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Gigit wuriimurimb qamb ne wurinob mit big qamar: “Mani irou arit igo ego munangit gonau eng ue. End ne an man ur nob qamarari munon qei wuriimurima isub mani goanet qiumuni bigunor. ");
INSERT INTO wnu_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ye an sipsip wan yeim gas ende iau qaar wurit imurimau gas ende ansiaum. ");
INSERT INTO wnu_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Isub qamb eng abau qeer ger me baiar ne goten yau naget bo ger uput qamb me baiar. Ne qataben isub munon ibag wurinob qobub misir me igar. Mag gari ibag wurimboasit isar. ");
INSERT INTO wnu_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Isub munai mor ger isub gab eng ete nob qamarar: “Oau meint igoarar.” ");
INSERT INTO wnu_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ende qomorunor eng munon oau mein ger end igo eng an musub wogub qoari wo bo munon qei wurimeinsieriner. A ue gab eng oau mein eng aninou igotariner. ");
INSERT INTO wnu_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ne an mon ger isub gab eng end sir mom igoarar, mon ar-ar me isar, sir igamari mani ya qamb andarari gab eng nub igoarar. Eng mi andarunor eng an sarau obounon eng taui qamb andarubour. ");
INSERT INTO wnu_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ginam aib ger isari animbig anamar mor isub mi andarari gab, eng nub igoarar. ");
INSERT INTO wnu_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ginam end munon toar nob wuri musub gab eng wuri nob qamarar, “Qenu wonou bibis eng gib qamb yarib piet igo.” ");
INSERT INTO wnu_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","A ginam aib ger isunon eng an merimotarari gab eng an tap sorai end qas naget ete qamarar: ");
INSERT INTO wnu_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Aninou ginamt ai nogoun erumban e bo porongot aninou ginamt e ariramoun an. End ne an igar, Qenu wonou bibis eng gib qamb anit yarib pisi igo.” ");
INSERT INTO wnu_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","End ne ye aninob quraum, qen sindomund end munon Sodom uru iramir eng wotanami an sig-sig mom uru iruboumon.” ");
INSERT INTO wnu_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ende qamb qamar: “An Gorasin munon nob Betsaida nob borumesis. Munon ger ye mi wes e ebine aba an qaum gaumon nami ende Tair Saidon nob end munon ger qoan mi aba ende ebeterei ende qi eng. Tair Saidon nob wuri qoan erumban qiyo mut wambin ba git goan qosine mom toubet ne qomon boru mogirt wab ig oa bigumirei qi. ");
INSERT INTO wnu_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Qenu an qereiminer eng Tair Saidon nob quguraget igour eng mi aib ue. An wuritanami quguragetoruboumon. ");
INSERT INTO wnu_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","An Kaperneam munon, an in Qenu ginam uber erer iruboun qamb misir igub at igoumon? Ende ue, aninomi dui qorasi ginamt isub at igoumon.” ");
INSERT INTO wnu_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ende qamb wogub wonou imbigau yurau eng wuri nob qamar: “An qob wurinob qamarari iruges big igatarunor eng ye gor igisoubour. A, an mogirt wab wogunor eng ye gor mogirisab wogubour.” ");
INSERT INTO wnu_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ende qamb wogub munon 72 wuri imuriamor eng qibi diab mismisir ne qamamir: “Barai, munon aibigau igaramor eng ibag neunumot qomorune igub munon eng wuriwugumirei.” ");
INSERT INTO wnu_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Qamarari Yisas taui qamar: “Ye Satan gaum eng ai qebisimau gas ende at dererei. ");
INSERT INTO wnu_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ye annonogursiem end mani guter qag qiyo dorom aningora me umunanei. Ne munon qarau me aningaramunorei. Mi aningareminer eng gugum nugutumugouboumon. ");
INSERT INTO wnu_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Eng an mismisirunon eng an aibigau qamb moui qamb eng gagar qamarari qoamir end qer me uyar. A Qenu anit igub anubersia wo nob igoruboumon end mom mismisirar,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Qen end gari Qenu qau Yisas wot isa mismisir qamar: “Io tain, ne erer qite ne ag e wurinou baraitari igoan. Nonou qenungau eng nonou qomon wes eng munon qoyam end wurit wabi ne munon qoyam aib ue eng nonou wau eng wurit dibes qaman end ye net mismisiraum.” ");
INSERT INTO wnu_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ende qamb ne munon yurau aib wurinob qamar: “Yonou tain mi gugum yeserei. Munon ger Qenu wonou wau me imbig igo, wonou Ur eng gari wonou eng wau imbig igo. Ne gor Tain aib eng munon ger qoyam ue. Wau eng gari Ur qoyam. Ne gor Wau eng wo wonou Ur qomon eng munon ger sir biga ne qoyamet igoriba.” ");
INSERT INTO wnu_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Qob eng ende wurinob qamb wogub wonou imbigau yurau eng gari qanam dibes qi wurinob qamar: “Munon qei an mi gaumon eng wuri gor gaur eng wurinou uberet igorunor. ");
INSERT INTO wnu_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Qoan Qenu qob miteri qamarau munon ne gabman munon baraitari an mi see gaumon eng wuri gub qamb ebetemir eng me geau. Ne gor qob see an igoumon eng wuri igub qamb ebetemir eng gor me igau,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ne qomon imbigau munon ger di Yisas wariges nob qamar: “Ye maigas ebet qen dirigor bebereg igoribam?” ");
INSERT INTO wnu_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ende qamara wo taui nob qamar: “Qenu qob maigas igama wanunger gab igoan?” ");
INSERT INTO wnu_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ne wo taui qamar: “Ye Qenu yonou munon Baraitari end qenen wot igub, yonou oau uri wot qamb ne qer gagam big wo qob qamara igub taut ne sig mom wo qenungein. Ende at ne yonou munon banam yonou git goan qenunget igoum gas ende wuri sierini. Qenu qob ende qamara gumatemir eng wanunger igoum.” ");
INSERT INTO wnu_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ende qamara Yisas qamar: “Nonou gari qeemben taui quran eng. Ende at qenen bebereg igoriban.” ");
INSERT INTO wnu_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ende qamara munon eng qesi wara wonomi nonogursierib qamb bo imusi qebi qamar: “Yonou munon banam eng your?” ");
INSERT INTO wnu_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ne Yisas taui qamar: “Munon ger Yerusalem wogub Yeriko isib qamb isorei. Isa qataben munon igeig yar waramb ba sumungasiari umiba gab wogub wonomi gugum urim ba qoari umib at inab igoai. ");
INSERT INTO wnu_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Igama munon Qenut mian iset bigetet igoar eng bo tap eng gari isorei. Isub munon eng gogorau ende gab tap goan-goan der qorei. ");
INSERT INTO wnu_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ne bo Qenu munai sarau betet igour yurau eng munon ger bo tap eng qas isorei. Isub ende gab wo gor qon-qon der isorei. ");
INSERT INTO wnu_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Isa ne Samaria munon ger wo bo tap eng isub gar eng munon eng ende umib at igama gab, borusi toubeterei. (Samaria munon ne Yuda munon wuri me qibanamsi igamau. Wuri yurau wes-wes igurei.) ");
INSERT INTO wnu_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Qen end qas munon eng gab toubet qani isub maurem ya wain ya nob ba waramb ombopumiamir end wot igi tourimeteterei. Ende at wogub bemeni wonou bur dongi erer end big musub qoat nob isub munai ar geret ombur inemirei. ");
INSERT INTO wnu_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Inemirei igo urigerma wogub qoaib qamb munon munai ar qoat igoar eng nob qamar: “Ne munon e musub gab igoar,” ende qamb ne nomon qur im K5.00-ende utab qamar: “Ne munon e musub qoat igama ye bo et yarine gab ne, ne nomon qur mai-mai munon e utab uganei qi eng ye nob qamara bo taui qeemben ende neteibam.” ");
INSERT INTO wnu_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yisas ende qamb ne sindomund wuri qebi qamar: “Munon ombur gari eng quraum eng, your munon umib at igoar eng musiarei?” ");
INSERT INTO wnu_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ne qomon imbigau munon eng nob qamar: “Munon ger sindomund isub munon eng musier eng.” Ne Yisas taui qamar: “Ne gor is qib munon eng ebeter gas ende eb.” ");
INSERT INTO wnu_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ende qamb wogub Yisas wonou wuri imbigau yurau eng nob ginam ger end isumirei. Isari ginam end yamangar ger, unum Marta, eng wuri isari uberet ne oromar wonou munai mor isorei. ");
INSERT INTO wnu_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta wo umemi ger igoai, unum eng Maria. Maria wo yara Yisas qob qamara goten namt bugab igub igoai. ");
INSERT INTO wnu_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ne Marta wonou gari mi arsi qib-qibi seret wogub isub Yisas nob qamar: “Barai, yonou imemi yar ar e igama yonou gari qas mi arsi qib ietoroum. Imurima yar ye nob ebet mi qand arsiorun.” ");
INSERT INTO wnu_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ende qamara Yisas taui qamar: “Marta, ne mi end misir qebebi igub me eb. ");
INSERT INTO wnu_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Git mi eng uber aban ego, mi gari qas net me igo eng. Maria wo eng igub igo. End ne in uyes me nob qomurunei. Wo yet igub oabig abar eng qen geret munon ger aba maigas me weginerei,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Qen geret Yisas ai geret Qenut qebi qamb wogub igama wonou imbigau munon ger di nob qamar: “Barai, Qenu qebi qamarau qomon eng inimbig. Qoan Yon wonou imbigau yurau wuriimbigor gas ende in bo ende in si.” ");
INSERT INTO wnu_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Qamara Yisas wurinob qamar: “Ete at qamarar: Tain ne unum sig qau gagam igoriner. In nonou bibis end qas igorun. ");
INSERT INTO wnu_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Qen gugum mani indab igoar. ");
INSERT INTO wnu_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ininou qomon boru ba at arirom. Ende aba in munon qei init merimotarari gab in wurit bo me tauiomun. Ne in me in warigesi.” ");
INSERT INTO wnu_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","8","Ende wurinob qamb wogub mit big qamar: “Mai qiyo, itum wobon an naat inunanei igama aninou munon banam ger qibei minemb wogub yara gab an mi qibi ue gab an mai obouboumon? An bo isub aninou munon banam ger wagrari wurinob mondir ubet wogub inunorei igama is wurimeni ete wurinob qamarar: “Ininou munon banam ger inimbegeib qamb yara gab in mi qibi ue gab net quraun. Mani parau ombur gari ende indar.” Ende nob qamarari munon eng igub mai qemeriba? Mai ete qemeriba qiyo: “Meimet qamb yar yemeni igoumon? Ye mondir nausi ubet wogub wau wurinob inumei, eng gab sabar der bugab mi me andarunei.” Wo ende qemeriba qiyo? Ende me qemerinerei. Wo an qibanamsi igoumon end igub der mi qibi andariba. A wonou munon banam mi ger me utiner eng qiningin qamb uyes der bugab mani parau eng ne mani qei uiar qeemben andariba. ");
INSERT INTO wnu_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","End ne ete qemerine igar: An mi geret qebi qamarari eng andariba. A, mi ger gub qamb asi eng guboumon. Ne toaubigari igub eng mondir weimatariba. ");
INSERT INTO wnu_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Munon gugum Qenu qebi qamarari eng mi wurisab igo. A, mi gub qamb asiamari eng mi wurisirbig igo. Ne munon ger ag yar toaubiginer eng mondir weimeteiba. ");
INSERT INTO wnu_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Qoan an wayit igo minemb manit qamarari tain ibi ba andab igoai? ");
INSERT INTO wnu_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ne gor wau ger morogan inau gab qamara ur mi boru ger ba utiba? Ende ue. ");
INSERT INTO wnu_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","An munon boru eng aninou wau wuriubersi igoumon eng. Eng gas ende munangit ger ende ebeiner eng Qenu wotanami ende ebeiba. Ende gas ende Qenu munon ger Igomurur qau qenunget wot qemeriner eng wot imurima wot deriba.” ");
INSERT INTO wnu_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yisas ende qamb wogub ne munon ger aibigau waramorei igama munon eng qob me qamb igamau. Eng musia munon eng qob qamara gab misir qebebi igumirei. ");
INSERT INTO wnu_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ende gab ne qei der qamamir: “Munon e aibigau wurinou baraitari Belsebul eng nonogursia munon e musiar eng.” ");
INSERT INTO wnu_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ende qamarari qei der warigesiorub qamb Qenu wonomi wes ger aba dara gub qamb nob qomorub misir igumirei. ");
INSERT INTO wnu_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ende abari Yisas menbur ibag wurinob qamar: “Munon ai garit igo qi banamsi igour eng der tau purab bo tau nob yogurunor eng wurinou mi bibis eng boruburiba. Ende gas, ne gor munon wurinou qanam gari bo tau purab tau nob qi agunub obounor eng gor qi banamsi me igorunorei. ");
INSERT INTO wnu_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ende gas, Satan wonou yurau tau purab tau nob yogub eng wurinou bibis eng maigas uber igoriba? Sig ue. End ne an ete quraumon eng: “Ye aibigau wurinou baraitari Belsebul yenogursia munon e musia” qamb quraumon end quraum. ");
INSERT INTO wnu_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ende igama eng munon qei aninou qob toat igour eng your wurinonogursia munon aibigau igaramor eng wurimusub igour? Eng yenob qamarari igub. Wuri aibigau orotoar ariramour qomon eng gab ne an imbiguboumon. An misir eng igoumon end soagen aib. ");
INSERT INTO wnu_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ye Qenu yenogursia aibigau e toat ariramumei. End ne an gor Qenu wonou bibis end igoarar qamb qo an maribigorei.” ");
INSERT INTO wnu_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ende qamb qamar: “Munon uter ger wonou burig qamb yomi, qauri eng gagar mi gagam ba wonou munai mom musub qoat igoriner eng wonomi gugum uber igoriba. ");
INSERT INTO wnu_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ende igama ne munon ger uter qer nob eng diab munon eng nob yogub ne munon eng toat arir wogub wonomi gagam uber eng ba qerei munon qei werisiba. ");
INSERT INTO wnu_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Munon ger ye yeqarausieriner eng ye munon eng wonou banam ue. ");
INSERT INTO wnu_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ne ete gor qamar: “Aibigau munon ger waraminerei igo wogub ar ai qorut is qib igo ne ete qemeriba; ye ai ger gab igamau ue eng gab yonou bo munai sambur end irab igorini.” ");
INSERT INTO wnu_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ende qamb irab giner eng munai wab musub wugunerei igama gab ");
INSERT INTO wnu_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","bo isub aibigau 7-ende bo oromar diab end igurei. Aibigau 7-eng wuri sig boru aib end diab munon eng wot isari wo qoan arub igoar eng wotanami bo sig-sig mom arub igoai.” ");
INSERT INTO wnu_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yisas qob eng ende qamb igama ne yamangar ger munon yurau aib erobon end igo qamb ar: “Nonou nani eng wo qas mismisir igoriner qiyo?” ");
INSERT INTO wnu_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ne Yisas taui qamar: “Ue, yamangar Qenu qob igub wot oabig igour eng gari wuri mismisirubour,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ne munon yurau aib Yisas qoui igour eng ende igamari Yisas qob imusi wurinob qamar: “Munon qen see igour eng munon boru sisinam. End ye mi wes ger wuriimbigine gub qamb quraur, eng ye mi wes abau eng uput eng qoan Yona gari ebeter eng bo wuri imbig qemeribam. ");
INSERT INTO wnu_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ye mi wes ger ebeine gub qamb quraumon eng qob gigit qamarau munon Yona eng ginam aib Ninibe end isub munon eng wuri imbiga gamir gas ende bo Munangit wau gor ende aba munon see gubour. ");
INSERT INTO wnu_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Qoan ir yamangar barai tari ger Seba munon oroar igoai. Qen end Yuda munon barai tari unum Solomon wo qoyam aib end qomon qerei munon wuriimbig igoai. Ende at igama yamangar ar eng Yuda yurau ue eng ginam Seba end igo Solomon eng ebet igama qob toau isa igub ai pa ego song qob qamara igeteib qamb yarerei. Ego, see ye Solomon qoyam eng wotanamimoum. Ne gor an Qenu wonou yurau. Ego ye qob qemerine me igisab igoumon. End ne Qenu munon gugum wuriqereiminer qen end yamangar qomon eng nob aninou qomon eng nob qerei sig-sig mom anquguragsieriba. ");
INSERT INTO wnu_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Eng gas ende gari, munon munai ginam aib Ninibe igour eng wuri gor Yuda munon yurau ue, ego Qenu qob gigit qamarau munon Yona eng isub qob uber wuri irun wab qamara Qenut oabigumirei. An ende ue, an Qenu wonou yurau. Eng ye Yona wotanamimoum, ego ye qob qemerine me igisab igoumon. End ne qen sindomund end Qenu munon gugum wuriqereiminer end Ninibe wurinou qomon eng nob aninou eng nob qerei an sig-sig mom anquguragsieriba. ");
INSERT INTO wnu_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ende qamb qamar: “Munon ger urut gumet munon begen gab diarar qamb uruguni me ba wabi igo. Wo uruguni ba ir ai deberit naget begestara ai tap gab di igour. ");
INSERT INTO wnu_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ne gor, ininou mag qur eng urut begen gas ende. Magt asi git goan uber igama qib igoun. A mag boruburiner eng git goan gor itum igamau gas ende. ");
INSERT INTO wnu_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","End ne begen anit igo eng bo abari itureminer eng qoyamet igoarar. ");
INSERT INTO wnu_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","End ne mai woromt qiyo itum urut uruguni begesierinen eng git goan begent mai git goan igeragar mai itum igama gab igoumon? Ende ue. ");
INSERT INTO wnu_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yisas qob eng mom ende qamb waga ne Parisi yurau end munon ger mi nob nib qamb mot isa is bugamorei. ");
INSERT INTO wnu_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Yisas ende bugab mi nub igoai. Qen end wo mi nib qamb uben me birogonimau. Ar song baab nub igama Parisi munon eng der gab qieterei. ");
INSERT INTO wnu_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ende at igama Yisas der nob qamar: “An Parisi munon, an tabin egi qamb aninou git goan qenen birogoni igoumon. Ego aninou misir boru-boru igub mi uber qei qenen duet munon qei me wurisab igoumon eng an unun ten igamau gas ende. ");
INSERT INTO wnu_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","An meimet qamb qanganget igoumon? Qenu aninou git goan barsier eng oau qiyo misir gor me barsiau qiyo? ");
INSERT INTO wnu_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","End ne an mi egit yab tabint imi big munon mi ue eng wurisari nunor. An ende obounon eng misir boru qiyo qomon boru ger anit me igorinerei. ");
INSERT INTO wnu_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","An Parisi munon, borumesis. An qenen Qenu qomon qoan gumatemir eng taut marandi qiyo qoari im qiyo bubur 10-ende big ne bubur gari qas Qenut big igoumon. Git uber ebet igoumon ego an Qenu qob ger an munon ar wuriqenungar wurimusiar qamb qamar eng siningot wogub igoumon. ");
INSERT INTO wnu_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ne bo qamar: “An Parisi munon, borumesis. An qenen inorou munait end isub munon magqurt end qas bugumune inimbagaiar qamb at ne ar munon oai ibag igour eng isub inimbagaiar qamb qenu big qib igoumon. ");
INSERT INTO wnu_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","An munon tumuni igamari erobon maigas igo qi eng munon qoyam ue ar erer napi qib igamau gas ende.” ");
INSERT INTO wnu_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ende qamara qomon imbigau munon ger Yisas nob qamar: “Imbigau munon, ne qob eng at wurit quran eng init gor qinan qob quran.” ");
INSERT INTO wnu_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ende qamara Yisas taui qamar: “An qomon imbigau munon, an gor qoyametarar: An mi qugurau ger bemeni munon togormatarau gas ende abari ba pondogub qiroari an mag gari ibag igoumon. ");
INSERT INTO wnu_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ne gor, an tonoan nomongur qob gigit qamarau munon igaramb tumuniamir teter eng an git betet igoumon. ");
INSERT INTO wnu_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Aninou tonoan nomongur ebetemir eng gab uber qamb oropar igoumon. ");
INSERT INTO wnu_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","End ne Qenu qoyam aib end qoan ete qamarei: “Ye qob gigit qamarau munon ne imbigau yurau qei wuriimurimine isari orotoar wurisumungasi ne qei igarambour.” ");
INSERT INTO wnu_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Qoan ir aninou tonoan nogobi Kein wo der wonou umour Abel warama umorei. Ne aninou tonoan qei bo imusi Qenu qob gigit qamarau munon igaramari umb uburemirei. Ende at isi yarab munon Sekaraia wo munai qau end igama waramari umorei. Aninou tonoan munon qoregen irou igaramb igour eng isi yarab see wuri anit imi igurei. End ne aninou qomon boru see ebet igoumon end imusi Qenu taui qamb ansieriba. ");
INSERT INTO wnu_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","An qomon imbigau munon, borumesis. An Qenu wonou qob ba songesi abari munon qei imbigun qamb obour eng gor mingongir igour. An ende abari Qenu taui anquguragsieriba.” ");
INSERT INTO wnu_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yisas qob eng qamb wogub ag isa qomon imbigau munon ne Parisi munon eng nob oau biriberi nub wogub Yisas borusi warigesi qebiamirei. ");
INSERT INTO wnu_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ende ebet ne wo qob ger soagensi qamara igub end big waramun qamb mom iruges nan big igub igurei. ");
INSERT INTO wnu_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Qen end munon yurau sig irou qiumuni qit wouri igamari Yisas der wonou imbigau yurau eng wurinob qamar: “An Parisi wuri qani me isar. Isari wuri anmurimarunor end qoyamet igoarar qamb quraum. ");
INSERT INTO wnu_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Mi waber igo eng gugum bo dibent uburiba. Ne qob qi igo eng bo diban igub ugoubour. ");
INSERT INTO wnu_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ne qob itum qomorunon eng bo woromt igubour. A mor igo qob saragau munon ger iruges irut qob qi qemerinen eng munon ag end igo diban igubour.” ");
INSERT INTO wnu_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ende qamb qamar: “An git goan e aningaramari umunon end me yarimar. Wagari song aningaramunor ego aninou moui maigas bo sabar me igaramunorei. ");
INSERT INTO wnu_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ne munon ger wot yarimar qamb an imbig qemeribam eng. Munon eng Qenu, wo aningaramb ne qen geret animurima Satan ginam end isuboumon. Wo munon qeretut nob igo, end wot yarimar.” ");
INSERT INTO wnu_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ne bo qamar: “Morogan qamaaman uben ig ue ende munon nomon qur 2 toea ende arir taui ba igour eng an qoyam ue? Qenu mi qomourt ende ger bais me nasi igo. ");
INSERT INTO wnu_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Eng an morogan qamaaman irou qur qangang eng an wotanamimoumon. Mai, aninou tari im eng wo qo wanunger ugarei igo, end an me yarimar. Qenu an bais me annasi weginerei. ");
INSERT INTO wnu_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ete qemerine igar: your yeunumot munon qebebi magqurt wuri nob qemeriner eng Munangit Wau gor munon eng unumot Qenu enger wurinob qemeriba. ");
INSERT INTO wnu_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","A, munon eng ye unumot me qemerini qamb munon magqurt mogirisab weginer eng Munangit Wau gor Qenu wonou enger mag qurt mogirt wab wegiba. ");
INSERT INTO wnu_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ne munon ger Munangit Waut qob soagensi qemeriner eng qen geret Qenu wot igub ubersiau werei igo. A Igomurur qau qob isi wot qemeriner eng Qenu bo wot igub maigas me ubersierinerei, mom mogirt wab wegiba. ");
INSERT INTO wnu_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ne gor an yet oabigunon end munon qarau anamar inorou munait qiyo gabman magqurt qiyo munon barai tari qei mag qur anamar isub qob musitarubari gab, an dara gab qob maigas qomoruboun? Maigas qomoruboun? ende me abar. ");
INSERT INTO wnu_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Qen end qas Igomurur qau an qer gagamsiara qob igub qomoruboumon.” ");
INSERT INTO wnu_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ende qamara munon ger munon yurau aib erobon end igo qamb ar: “Barai, yonou bain nob qamara ininou tain mind init wager eng qerei tau yeseiner.” ");
INSERT INTO wnu_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ende qamara Yisas taui qamar: “Meimi munon ye munon wuri qerei qiyo aninou ombur mind eng qereiom qamb ye maribigorei?” ");
INSERT INTO wnu_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ende qamb ne imusi munon gugum wuri nob qamar: “An mi end qoyamet igoarar. Munon ger sau binat igama gab an bo wo gas ende burun qamb misir me igar. Munon sau binat igoriner eng mi eng nonogursia qenen bebereg me igorinerei.” ");
INSERT INTO wnu_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ende qamb ne mi geret big qamar: “Munon mi qur nob wonou man eng mani irou igoai. ");
INSERT INTO wnu_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ende gab wonou misir ete igorei, ye mani qirinau irou gaum e eret biua bigibam? munai ger ue e. ");
INSERT INTO wnu_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ende qamb misir igub ete ebein eng uber, qamar: “Mi ibiau mon wes-wes eng ye ombombanet wogub sori aib gari mindat wogub mani qirinau a wit qur qamb ne mi uber-uber qei gugum mom end ariramine igoriner.” ");
INSERT INTO wnu_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Igama ye mom qamb wogub end misinam yoosi igorini. Igo togun irou mi eng qas nub mismisir igorini, qoan sarau aib ebet igoum eng mom wegini.” ");
INSERT INTO wnu_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ende qamara Qenu munon eng nob qamar: “Qanganget ende at qamb igoan? Itum et qas umiban, uma ne mind aib your baiba?” ");
INSERT INTO wnu_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ende qamb sindomund qamar: “Munon gugum munon eng gas ende, in mom sau binat qamb obounor eng Qenu magqurt munon eng mi ue.” ");
INSERT INTO wnu_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yisas ende qamb wogub ne wonou imbigau yurau eng wuri nob qamar: “Mi end ne aninob quraum eng. Mi nub igom igamau end, ne mingoan qumanimau end misir qebebi me igar. ");
INSERT INTO wnu_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Igom igamau eng mi niau end gari ue, ne mingoan qumani uber igamau ue, ");
INSERT INTO wnu_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","End ne morogan ibagaiar, wuri mi ger me ubub qirinau big nub igour. Ne munai ger mindat mor me igour, ego Qenu oroar igo. Ne an munangit morogan wuritanamimoumon. ");
INSERT INTO wnu_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","End ne munon ger mai umib at wogub ne bo me uminei ende qamb wonou togun ger bo maribigiba? Ende me ebinerei. ");
INSERT INTO wnu_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Eng gab ne aninou mi eng gagar maigas me maribigunanei. End ne an meimet qamb mi qei-qeit misir qebebi igub igoumon? ");
INSERT INTO wnu_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","An nam isar eng ibagaiar, wuri mingoan ger me barsi igour. Qoan Solomon wo mingoan barsi igoar eng sig uber ego nam isar wuri me wuritanamimau. ");
INSERT INTO wnu_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","An munon yamangar mani qamb mingoan qamb misir qebebi igunon eng an oau apand ue. Mi e musub gaiar. Nam ar amug igama Qenu siara se isarima munon ar soopur arir igour. End ne an nam qamb puriani qamb eng gagar wuritanamimoumon. End ne Qenu anoar ne sig mom anubersi igo. ");
INSERT INTO wnu_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","End ne an misir qebebi igub, “mi nub qamb meimi nuboun? meimi nuboun,” ende me qamarar. ");
INSERT INTO wnu_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Munon ar ai qent e gugum Qenu me imbig eng wuri misir qebebi ende igub igour. Ego Qenu ininou tain mi eng gugum indab igo. ");
INSERT INTO wnu_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","End ne an Qenu wonou bibis end qas igorub qamb igub obounon eng mi eng gagar gugum ar andariba.” ");
INSERT INTO wnu_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ende qamb qamar: “An munon yurau aib ue, end misir qebebi me igar. Aninou tain wonou bibis end igoarar qamb anmaribigorei. ");
INSERT INTO wnu_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","End ne aninou mind eng munon qei wurisab taui qur ba munon mi ue eng werisar. Ende at aninou mi uber-uber ba qiumuni bigunon eng Qenu wonou ginamt bigari me uburinerei. An ende obounon eng nomon qur bigau abau me gurent igo eng gas ende. Eng Qenu wonou ginamt mi urim me baunorei a pinai mi ger me ninerei, sig ue ar. ");
INSERT INTO wnu_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Eng munon ger wonou mi sig uberar eng eret igama gab eng wonou misir end qas igub igo. ");
INSERT INTO wnu_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","An mi ger yaribar end mingoan musub uiebig qumani ne urut uruguni girinet tug igoarar. ");
INSERT INTO wnu_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","An ende obounon eng sarau munon uber wonou qomon gas ende. Eng ete: Munon barai ger wonou sarau munon wuriwogub mi aib at nib qamb qorei igama wuri munon barai bo yariner end girinet tug igurei. Igamari wo yar qeir toau biga igub qand isub mondir wei gubour. ");
INSERT INTO wnu_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Wuri mungam me inau, girinet igour end yara gab uberetorubour. End ye segagam aninob quraum: Ende abari wonou wurinob qamara yar bugab igamari munon barai wonou git baab wogub mi arsi wurisa nubour. ");
INSERT INTO wnu_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Munon baraitari eng itum wobon qiyo urigeremb pisia yarab ibegeiner eng wuri me inunor end wuri uberorubour. ");
INSERT INTO wnu_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Yisas ende qamb wogub bo mi geret big qamar: “Munai ur munon mi urim baib qamb yariner qen eng imbig eng wo ebesam wara mai diab mi bainer? ");
INSERT INTO wnu_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Eng gas ende, an gor qoyamet girinet igoarar. Munangit wau bo se me deriner qamb song ar igorunon qen end wo deriba.” ");
INSERT INTO wnu_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ende qamara Pita der qamar: “Barai, ne qob eng mit big quran eng mai init gari igar qamb quran qiyo, a munon gugum igar qamb quran? ");
INSERT INTO wnu_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ne munon barai taui qamar: “Munon ger qoyam uber igoriner eng wonou sarau munon eng musub qoat igo. Wo gari qoyam end wonou sarau munon eng ger sarau ubersi bea gab eng wo maribiga wo der sarau munon qei orora sarau baab igamari qen eng gab sarau taui mi qeemben ende werisiba. ");
INSERT INTO wnu_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Munon barai eng qooinerei igo yarab wonou sarau munon eng giner eng wonou nob qamb wogub qiuar gas ende ebet igama gea munon eng mismisiriba. ");
INSERT INTO wnu_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Apand aninob quraum, munon barai eng mi gugum wonou sarau munon eng wot waga qoat igoriba. ");
INSERT INTO wnu_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ne sarau munon eng ete misir igub: “qo, munon barai eng qand me yarinerei” ende qamb sarau munon yamangar qei igaramb wuri ba sumungasi ne wo ar uberet igo mi nub a ya uter nub qanganget ende at igoriba. ");
INSERT INTO wnu_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ende at ne wonou munon barai yariner eng wo qoyam ue. Wo song ar igo ende at igama yar gab wonomi gugum ba borusi ne wo git imurima is munon yurau qei mi me musub igorunor eng oromar igoriba. ");
INSERT INTO wnu_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Eng gas ende, sarau munon ger wonou munon barai yarib qamar eng imbiginer eng wo gag wo sarau qamar eng me ebet ar igoriner eng wo yar gab borusi misiringet borusi mom waramba. ");
INSERT INTO wnu_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","A sarau munon ger wonou munon barai sarau me imbiginer eng wo yar gab ar qamat qamb baist waramb wegiba. Qenu munon ger mi irou wot waga qoat igoriner eng qen geret bo irou taui yeis qamb nob qemeriba. A munon ger mi sig irou wot weginer eng qen geret wo bo taui sig irou ende yeis qamb nob qemeriba. ");
INSERT INTO wnu_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ende qamb qamar: ye mut ag et gumeib qamb derem eng qo gumotemei oab igo. ");
INSERT INTO wnu_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ye ag e derem eng munon ya obesab yemaragansiau gas ende yesumungasiari qugurageterib qamb deremei. Yesumungasiorunor eng qoat misir qebebi igub igoi mom yesiari oau mein buriba. ");
INSERT INTO wnu_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","An mai ye munon ag e gugum wuriba qiumunimb qamb deremei qamb igoumon? Ende ue, ye munon wuri bubur qereimb deremei. ");
INSERT INTO wnu_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","See ye ag e darab igimine munon qanam gari 5-ende wurinou bubur qereimbour. Qerei ne duor gari der ombur wuri qarausiorubour, ne ombur der duor gari wuri qarausi ende ebet igorubour. ");
INSERT INTO wnu_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ur der wau nob agunia wau der ur nob agunub. A unor der waib nob agunia waib der unor nob agunub, a umagam der ayi nob agunia ayi der umagam nob agunub, ende oboubour,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Qamb qamar: ya derib qamb qurburima gab eng: “qo ya deriba,” ende qamb igamari ya apand der igo. ");
INSERT INTO wnu_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","A sigepurau yara gab eng ‘sigenimba’ ende qamb gab igoumon eng qeemben ende sigeni igo. ");
INSERT INTO wnu_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","An git qen qeemben ende qerei igoumon ego meimet qamb qen see gor qeemben ende me maribigoumon?” ");
INSERT INTO wnu_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Ende qamb qamar: “Ende at ne aninou qomon eng musub qerei imbig ne qomon qoregen qas taut igoarar. ");
INSERT INTO wnu_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Munon ger ne qomon boru aba uyort is qamb nomot munon qob qereimau magqurt isa gab eng an ombur qataben isub igo qen end qas aninou ombur bo qob eng musiarar. Ende me ebeinen eng isub munon qob qereimau eng negab bur tuumt ne imurima bur tuum neba uyort ne bigubour. ");
INSERT INTO wnu_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Uyort ne biga qand ne wagari der me qooinenei. Igoi nomon qur mom taui wurisab ugab wogub qoaiban,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Qen end Galili munon qei Qenut wai waramb mian yab big igamari Rom gab man baraitari Pailat wonou yogorau munon nob yarab igaramb qeru ba mian yab big igour eng nob yesiriamirei. Pailat ende aba gab munon qei der Yisas nob qamamirei. ");
INSERT INTO wnu_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ende qamarari igub Yisas taui wurinob qamar: “Aninou misir maigas, munon igaramir eng wurinou qomon boru ebet munon qei wuritanamimour end igaramirei qiyo? ");
INSERT INTO wnu_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ende ue. Ye aninob qemerine igar: An aninou qomon boru mogirt wab me wogunon eng an gor ende ansiari umuboumon. ");
INSERT INTO wnu_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ende ne an mai misir igoumon? Qoan ginam Siloam end munai degen aib uburab isub munon 18-ende igarama umumir eng wuri qomon boru ebet Yerusalem munon gugum wuritanami igour end umumirei qamb misir igoumon? ");
INSERT INTO wnu_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Eng gor ende ue. An gor aninou qomon boru me wogunon eng an gor ende umuboumon.” ");
INSERT INTO wnu_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ende qamb ne mit big ete wurinob qamarei: “Munon ger nam pig gari qas wain man end uborei igo togun ombur gari uma ne qur big arit igo qamb is gar eng ue. ");
INSERT INTO wnu_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ende gab ne munon man qoat igour eng nob qamar: “Qoan nam eng ubomei igama togun ombur gari uma ne see yar gaum eng ue eng gab wo ar igo mi qei irbiginer qamb song suab arirom.” ");
INSERT INTO wnu_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ende qamara munon man qoat igoar eng nob qamar: “Ue, waga ar igoriner, igama togun gari e gin eng ende sig igama gab eng ye qanam qoui qubir qobot wogub mut wambin qanam qoui big gin. ");
INSERT INTO wnu_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ende at togun geret gin eng qur biga gab eng sig uber, a ende sig gab eng song suab arirambam,” ende qamarei,” qamar. ");
INSERT INTO wnu_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","11","Inorou qen geret Yisas inorou munai end is wuriimbig igama yamangar ger ai bigau waramorei ten igama togun 18-ende warei. Ende igama git goan mom umb uburerei, me mi deges igamau. ");
INSERT INTO wnu_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yisas ende gab nob qamar: “Ne musiaum, uberburiban.” ");
INSERT INTO wnu_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ende qamb bea qen end qas git goan gurumot uburer eng bo git uput yar der naget mi degesi Qenut igub mismisir uber wot qamarei. ");
INSERT INTO wnu_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ende aba gab munon barai aib inorou munai qoat igoar eng Yisas inorou qent yamangar eng musia uberbura gab misiringet ne munon yamangar wurinob qamar: “Misegiau qen eng 6-ende igo. An toar nob igo gab eng inmusiarar qamb eng qen wobon end gab diermar! Inorou qen e an qoyam ue igo inmusiar qamb di igoumon?” ");
INSERT INTO wnu_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ende qamara Yisas taui nob qamar: “Ne qetopur quran, an qei inorou qent bur yount end isub bur qarig a dongi qamagat qamb eng wurinerub oromar isub ya wurisab igoumon. ");
INSERT INTO wnu_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","End ne yamangar e Abraham tumbigi, end Satan mom wot isuor eng ten igama togun 18-ende wara eng gab. Igo mom mumusieriba eng gab ye inorou qent song musiaum.” ");
INSERT INTO wnu_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ende qamara Yisas wonou munon qarau eng inorou qent ende ebet igour end Yisas qeemben wurinob qamara igub qininingari munon yamangar ar qei mi qomon uber eng aba gab sig mismisiramirei. ");
INSERT INTO wnu_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yisas qob ger bo qamar: “Qenu wonou bibis big igo eng ye meimit maribig qemerine qeemben buriba? ");
INSERT INTO wnu_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Eng ete gas, nam mastet qur ger, munon ger ba bis wonou man end goaneterei igama qaut di ir nam aib burerei. Ende ebeterei igama morogan yar nam uben end mon ubet inau big igurei.” ");
INSERT INTO wnu_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ende qamb bo wuri qebi qamar: “Qenu bibis big igo eng meimit maribig qemerine is qeemben buriba? ");
INSERT INTO wnu_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Eng ete gas, yamangar ger yis baiste ba mani parau aib iset igour eng egit igama ten arirama oab qarib diarei,” qamar. ");
INSERT INTO wnu_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ende qamb wogub ne Yerusalem irib qamb qataben irab ginam aib ne ginam qamaaman end irab-irab qob wuriimbig-imbig ir igoai. ");
INSERT INTO wnu_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ende at qib igama munon ger qebi qamar: “Barai, mai Qenu munon gari duor ete wurisiara uberetorubour qiyo?” Ende qamara Yisas taui qamar: ");
INSERT INTO wnu_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“An Qenu bibis bigor eng isub qamb eng mom qeretut nob wogub mi iru qomourt eng qeemben isuboumon. Munon irou isun qamb obour ego mai gas me isunorei.” ");
INSERT INTO wnu_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ende qamb qamar: “Munai ur mor igo mondir mom nausi obotariba. Ende aba ne an is ag igo qeir toau big ne ete nob qomoruboumon, “Barai mondir weimatar.” Ende qamarari wo mor itoi igo ete aninob qemeriba, “ye an qoyam ue, an munon ginam eret yoroumon?” ");
INSERT INTO wnu_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ende qamara an taui qomoruboumon, “In erogori, ininou ginamt mi nub igo ne qob inimbig igoan eng diaun.” ");
INSERT INTO wnu_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ende nob qamarari wo bo taui aninob qemeriba: An munon qomon soagen abau tari Ye an qoyam ue, qand wogub der iuarimar.” ");
INSERT INTO wnu_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ende qamara an is ag igo eab nan suab igo gunon eng, Abraham, Aisak, ne Yekop ne Qenu qob gigit qamarau munon yurau eng, Qenu wonou bibis end igo mismisir igamari ibogouboumon. ");
INSERT INTO wnu_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ende abari ne munon worom diat worom isat ne tog qite qumo igour eng di Qenu wonou bibis end qas qiumuni igorubour. ");
INSERT INTO wnu_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ende abari munon see ye gigit igoum qemeriner eng bo qanamt igoriba, a “ye qanamt igoum” qemeriner eng bo baraitari gigit igoriba.” ");
INSERT INTO wnu_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ende qamb igama qen end qas Parisi munon qei yar Yisas nob qamamir: “Ne see qas inwogub taut is. Herot nanamb at igo.” ");
INSERT INTO wnu_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ende qamarari Yisas taui qamar. “An isub iau qoar boru eng nob ete qamarar, ye see ne barim ende ye ginam qei-qei irab-irab munon ai igaramor eng ne toau asin igab igo eng wurimusub-musub ir igoribam. A barim urigom eng ye sarau mom igeibam,” ende nob qamarar.” ");
INSERT INTO wnu_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ende qamb ne bo qamar: “Io, ye see ne barim ue barim urigom eng ye sarau mom ugeibam. Ugab ne Yerusalem weib iribam. End ne Qenu qob gigit qamarau munon eng ginam geret me waramunerei, Yerusalem end qas waramari umiba.” ");
INSERT INTO wnu_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ende qamb qamar: “Io, an Yerusalem munon, an qoan Qenu qob gigit qamarau munon eng igaramb ne wonou sarau munon eng anit imurima isari nomont igaramb igumunei isi yarab ne see. Qenen ye aninou munon yurau eng, teteri unor qaman wuriigusub igo gas ende anba qiumunimbine ne ye qarausi igoumon. ");
INSERT INTO wnu_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","End ne Qenu aninou ginam eng mom waga. An ye qand bo me yegunanei. Isi yarab qen geret ete yet qomoruboumon, Munon Baraitari eng Qenu wonou nonogursi musia qeretut nob yara.” ende qomoruboumon.” Ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Inorou qen geret Yisas isub Parisi munon baraitari ger munait mi nia qoat nan gab igurei. ");
INSERT INTO wnu_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ende at igamari munon ger goten uben nob qarimorei igama Yisast yarerei. ");
INSERT INTO wnu_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yara Yisas gab Parisi ne qomon imbigau munon eng wuri qebi qamar: “Ininou qomon munon inorou qent wurimusiau eng ende igo qiyo?” ");
INSERT INTO wnu_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ende qamara wuri qob ger me qamarari gab Yisas munon eng musub wogub imurima qorei. ");
INSERT INTO wnu_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Imurima isa wogub wurinob qamar: “Aninou wau qiyo bur qarig ger inorou qent tumun erobon isa an mai gitab igoruboumon qiyo? song biinerimboumon?” ");
INSERT INTO wnu_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ende qamara wuri taui qomorunor eng misue gab wugumirei. ");
INSERT INTO wnu_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yisas ende igama munon qei mi nub qamb yarab nam qob uber diban end sir bugomb qamb taut baab abari Yisas der mi geret big qamar: ");
INSERT INTO wnu_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Munon ger mi aib at nib qamb anit qamara isub gab nam qab uber end me bugamar. Bugab igamari eng bo qanamt munon unum diban-diban eng wuri qamara isari ibag, ");
INSERT INTO wnu_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ne anit bo qemeriba, “Nam qab uber eng munon barai e wagari bugomunor.” Ende qamara an bo der is mogirt umot is bugab borusi qinininguboumon. ");
INSERT INTO wnu_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","End ne munon ger anit ara isub gab eng, song is mogirt umond bugab igamari. Munon anit eriner eng wonou yar animbag ne qemeriba, “Irab nam qab uber metut itet bugom,” ende qamara ir munon magqurt bugab ne uber misir igiban. ");
INSERT INTO wnu_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Munon ger wonou qen big qib igoriner eng bo uma isiba. A ger wonomi bumai qib igoriner eng bo baraitari aib igoriba.” ");
INSERT INTO wnu_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yisas ende qamb wonou munon wot qamara mi nib yarer eng nob qamar: “Ne mi nib ger at nib qamb mai qiyo, nonou munon banam qiyo, bain qiyo, nonou qanam gari qiyo. Qo, nonou munon banam qur nob gab wurit ara yarari mani wurisab igoan. Ende ebeinen eng wuri bo taui net arari isa mi uber netoubour. ");
INSERT INTO wnu_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","End ne an ende me abar. An mi at nub qamb munon boru ger, qo uben tuum, qo goten tuum, mag tuum. ");
INSERT INTO wnu_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Munon eng gas eng gagar wurit arari yarari mani werisar. An ende obounon eng Qenu an ubersieriba. Munon boru wurit arari yarunor eng bo taui maigas me andarunorei. Qen geret Qenu wonou munon qoregen umbriamir eng iigomot der bugomunor qen end an taui ubersieriba.” ");
INSERT INTO wnu_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ende qamara munon ger nam qabt bugab igoar eng taui qamar: “Munon ger Qenu nob wonou bibis end bugab mi nub igo eng mismisiriba.” ");
INSERT INTO wnu_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ende qamara Yisas taui mit big qamar: “Munon ger mi sig aib at nib qamb munon yurau irou gim ibagarei. ");
INSERT INTO wnu_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Gim ibagarei igo mi mom eretersi ugab ne wonou sarau munon ger imurima isub wurinob qamar: “Mi mom arsi ue, yarari isun.” ");
INSERT INTO wnu_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ende qamara munon yurau eng gugum iet ne ger der sarau munon eng nob qamar: “Man girabur aib gab is gibam eng gab me isinei.” ");
INSERT INTO wnu_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ne bo ger der nob qamar: “Ye bur qarig 10-ende ai waiseisar qamb taui baioum end oromar isub wuri warigesieribam end me isinei.” ");
INSERT INTO wnu_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ne bo ger der nob qamar: “Ye yamangar se qas baioum end me isinei.” ");
INSERT INTO wnu_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Gugum mom ende qamb bis ugeari sarau munon wogub isub wonou munon barai eng mi eng gagar qamamir eng gugum nob qamarei. Qamara wo borusi mom oau biriberi nub wogub sarau munon eng nob qamar: “Ende gab bo qand tap togt ne tap qamaaman eng toat ginam aib end isub munon boru mi ue eng ne munon goten boru ibag ne mag tuum, ne munon me qib igour eng ibag oromar di.” ");
INSERT INTO wnu_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ende qamara sarau munon eng igub igoii wogub tuan end qamar, “Barai, ne qamara ye ende oromar di munai tumbigi wuri imbigine isour eng munai tumbigi qei ar ui igo.” ");
INSERT INTO wnu_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ende qamara munon barai eng bo nob qamar: “Ende gab eng ai taut iua tap tog eng toat ne man ai tap eng gagar toat isub ibag oromar diab mor wuri arirama munai tumbigi eng mom puriner. ");
INSERT INTO wnu_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Munon qoan ye wurit am eng wuri iet wagomir eng ye nob bo mani me nunorei,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Qen end munon yurau aib Yisas nob isub igamari Yisas igeser wurinob qamar: ");
INSERT INTO wnu_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Munon ger yonou qomon eng wuri imbigib qamb eng wonou ur unor ne wonou ubeni ne wonou wagrari, ne wonou umomori umemragar ne wonomi git eng mom dui ne yarab eng yonou imbigau munon igoriba. ");
INSERT INTO wnu_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Munon ger qugurau end yari eng yonou imbigau munon me igorinerei. ");
INSERT INTO wnu_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Eng ete, an ger mon mindaub qamb eng song ar me mindat igoumon. Se qamart bugab nomon qur qerei musub gab ne mon mindainer eng qeemben gab ne mon qanam big mindainer eng is yarab mon eng qand mindat ugeiba. ");
INSERT INTO wnu_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","A, mi ebet mon ar gigit qanam big qoren yeminer eng isi yarab nomon qur ubura wogub bo waga ar igama gab eng munon qei der wot igerigari qininingiba. ");
INSERT INTO wnu_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ete qomorubour, “munon eng yonou qur nob qamb ebeter e ar weibi waga” ende qomorubour. ");
INSERT INTO wnu_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ete gor, king munon uter aib ger wonou yogorau munon yurau 10,000-ende oromar isub king munon uter aib ger wonou yurau 20,000-ende wurinob yogurib qamb eng wo mom musub qerei gab ne isub wurinob yogub eng wuritanamimba. ");
INSERT INTO wnu_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","A, wo munon yurau qeemben ue gab eng yogorau qen eng se qiren igama ne omboat qob gin biga king ger munon yurau irou end wot isa igub wogub igour.” ");
INSERT INTO wnu_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ende qamb ne qamar: “Munon ger mi qei-qei end qas igub eng yonou imbigau munon bais me igorinerei.” ");
INSERT INTO wnu_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ende qamb qamar: “Tomon suumi biginenei igama namanimun iriget qer uburinerei igama bo mamat mi anumbine ne mi me irigeinerei. Eng bo mai gas aba uter buriba? ");
INSERT INTO wnu_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Tomon boru ende gab eng ar arir wogun. Ye qob e quraum eng munon ger wonou iruges big igib qamb eng wonou iginer,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Qen geret munon gabmant qur baiau eng ne munon mindigar qob ten igour eng Yisas qob igotoub qamb diamirei. ");
INSERT INTO wnu_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Diab qob igub igamari Parisi ne qomon imbigau munon yurau eng der Yisast mindigar qob qamamir: “Munon eng munon qomon boru-boru ten igour eng wurinob bugab mi nub qib igo eng ge?” ");
INSERT INTO wnu_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ende qamarari Yisas mi geret big qamar: ");
INSERT INTO wnu_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“An ger wai sipsip 100-ende igama gari qas magir qoa me gab mai gas ebet igo? Wo 99-ende oromar biua ai sirt wuri wogub gari qas qooiner end mom asi qibi mom gab wogub igo. ");
INSERT INTO wnu_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Gab eng ba igusub borusi mom mismisir igo. ");
INSERT INTO wnu_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ende at ne ba mor irab wonou banamori eng ne munon banam eng oromar qamara yarari, “ye wai sipsip ger me gab asi qib igoum eng gab wogub yarari mismisirun” ende qamb igo. ");
INSERT INTO wnu_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Eng gas ende, munon 99-ende wot oabigunor eng wurinob igama ne bo gari qas qomon boru eng at qibi wogub misir uber igub oabig Qenu ginamt end iroa eng borusi mom mismisiriba.” ");
INSERT INTO wnu_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ende qamb bo ger qamar: “yamangar ger nomon qur 10-ende (K1.00) igama bo gari qas isa wogub me gab eng mai gas ebet igo? Wo me gab eng urut uruguni wogub wonou munai eng gugum mom wab arir qibi gab baub qas wogub igo. ");
INSERT INTO wnu_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Baub ne wonou banamori ne munon banam oromar, “ye nomon qur isa me gab asi qib igoum eng gab baioum, yarari mismisirun” ende qemeriba. ");
INSERT INTO wnu_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Eng gas ende munon yurau aib erobon end gari qas Qenut oabiginer eng enger mot irab mismisirubour.” ");
INSERT INTO wnu_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ende qamb imusi qamar: “Munon ger wau ombur igoai. ");
INSERT INTO wnu_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ne wau yab eng der ur nob qamar, “Tain, ne mind bubur qerei yeis.” Ende qamara mind wonou wau ombur end wurit qereiamorei. ");
INSERT INTO wnu_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Qereima wau yab mind tau eng ne qur nob ba qen qei ubura ai pat gar qoorei. Iua end igo wonou yonou mai qamb qomon boru-boru end qur arir ugurei. ");
INSERT INTO wnu_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ende at ne mind qei-qei eng gugum mom wurisab ugea ne qunumber qen aib ai end yara wo mi ger gab niau ue. ");
INSERT INTO wnu_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ende gab ne wo qibi munon ger ai end gea ne imurima isub wonou bur youn aib eng qoat mi wurisab igoai. ");
INSERT INTO wnu_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ende aba ne munon ger mi uta me niau. Borusi minemb wogub bur mi wurisa niari gongan eng ba nub igoai. ");
INSERT INTO wnu_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ende at igoi wogub bugab misir igub qamar, “Yonou tainb mi ubub taui mi mian gab nub igour. Ye e meimet qamb minemb umb qib igoum? ");
INSERT INTO wnu_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","End ne see qas ginam e wogub tain qani isub ete nob qemerin; tain ye Qenu ne nob magqurt qomon boru ebet qibi wogub yoroum. ");
INSERT INTO wnu_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","End ne see bo yet “yonou wau” ende me yet qem. Qomon boru eng ebetem end ar sarau yet biga taui qamb ar sarau betet igoribam.” ");
INSERT INTO wnu_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ende qamb ai eng wogub ur qani isib qamb der isorei. Isi yarab ginam isib bais mugenderi ende isub igama wonou ur asi gab borusi toubet wogub uyab-uyab isub bumani ambugeterei. ");
INSERT INTO wnu_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ende aba wau der ur nob qamar: “Tain, ye Qenu ne nob ombur magqurt qomon boru ebet qibi wogub yoroum, end ne ne yonou wau qamb misir me igu.” ");
INSERT INTO wnu_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ende qamara wonou sarau munon eng wurinob qamar: “Qand irab yonou mi goan degen eng ba yarab nagetet ne bunom tau eng ba yarab uben dirigar end ogumunimetet ne goten yau eng nagetet ende abar. ");
INSERT INTO wnu_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","At ne bur qarig youn man end isub bur yeim uber eng gab waramb ba dearari yab nob nuboun. ");
INSERT INTO wnu_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Yonou wau e mom umorei bo me gunei qamb igoum e bo e yara gab borusi mismisir mi at nob nuboun.” Ende qamb ne mi arsiamirei. ");
INSERT INTO wnu_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Mi arsi nub sibem wab uru uyab toaubig igamari wau qamar man iuar eng qibi ginam pi diab toau igorei. ");
INSERT INTO wnu_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Igub mugenderi igo sarau munon ger wot ara isa qebi qamar, “Eng meimi ebet toaubig igour?” ");
INSERT INTO wnu_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ende qamara sarau munon eng taui qamar, “Nonou ima mom iua umorei qamamin e bo yara gab mismisir toaubig igour.” ");
INSERT INTO wnu_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Wau qamar ende igub borusi oau biriberi nub wogub ur merimot wogub mor me iroau. Ende aba ur der wau qamar mor di qamb wot arei. ");
INSERT INTO wnu_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ara diab ur nob agunub qamar, “Ne ge, togun qen e gugum ye ar sarau betet igumei. Ne mi geret qamara ye ger me nombarir igamau. Ende at igoum eng ne mi ger me yesau, ne wai meme yeim ger yesa ye arsi yonou sarau erogori baab igoun eng me wurinob nub igamau, sig ue ar. ");
INSERT INTO wnu_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Wein yab eng wo nonou mind biuar eng qarig ir qib wogub mi qorate biuar eng arir ugab wogub yara bo meimet qamb bur qarig waramb nob nub mismisir igoan?” ");
INSERT INTO wnu_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ende qamara ur der wau qamar nob qamar, “Ne ye nob ginamt igoan. Eng yonomi eng nonou gor. ");
INSERT INTO wnu_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","End ne nonou ima e segagam mom umorei qamamin eng bo init igub yara gab mismisir at igoun,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yisas qob eng ende wurinob qamb wogub ne wonou wuri imbigau yurau eng wurinob qamar: “Munon ger mind irou igoai. Ne wonou sarau munon ger igoai. Ende igama ne munon qei yar wonou sarau munon eng nomon qur ar isi arir ugab igo qamb nob qamamirei. ");
INSERT INTO wnu_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Qamarari ne wonou munon baraitari eng der wonou sarau munon eng nob qamar, “Ne mai aba net qamarari igoum? Ne see qas isub yonomi gugum ne qoat igoan qangang eng gum. Gumot ne ne bo yonou sarau munon me igorinenei.” ");
INSERT INTO wnu_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ende qamara sarau munon eng wonou misirt ete igor, Wa, munon eng yonou sarau mom wog qamb qurar eng, mai ebeini? Yonomai sarau ger ebein eng qeemben ue ne gor mit asi qib igamau end qininingoum.” ");
INSERT INTO wnu_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ende qamb ne qamar, “Io, yonou munon barai saraut ye qarausia gab eng munon qei munai mor eng isine yebanamsiorunor.” ");
INSERT INTO wnu_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ende qamb ne wonou munon barai mi munon qei ar weriser eng gari-gari, wurit arei. Ara qamar yara wot qamar, “Ne yonou munon barai mi mai-mai wot baunei igo taui utiban?” ");
INSERT INTO wnu_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Qamara wo qamar, “nam olib qur welya eng egi wo ende baumei.” Ende qamara wo taui qamar, “ende gab eng ne namani mun e ba isub bugab qangang 50-ende qand gum,” qamar. ");
INSERT INTO wnu_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ne bo geret qamar, “Ne mi ar mai-mai baunei?” qamara wo qamar, “Ye wit abau 1,000-ende baumei.” qamara sarau munon eng qamar, “Ende gab eng nomon qur qangang namanimunt e igo eng bisub bo qand qangang 800-ende gum.” ");
INSERT INTO wnu_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Mom wuri imbiga ende ebetemirei igama sarau munon wonou munon barai yar wonou misir nob end mi qeemben ebeterei igama gab wot uber qamarei. Ende qamb qamar: “munon ag e munon begent igour eng wurinou qoyam imbi-imbi wuritanami sarau musub ebet igour.” ");
INSERT INTO wnu_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yisas ende qamb bo imusi qamar: “Mind boru song-song ai qent et munon wuri banam siarar. Ende obounon eng qen geret mi eng ubura anamar mor isari uber igoruboumon. ");
INSERT INTO wnu_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Munon ger mi qomourt musub qoat igoriner eng mi aib eng gor ende qoaiba. A mi qomourt musub me qoainer eng mi aib eng gor musub me qoainerei. ");
INSERT INTO wnu_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","End ne an mind ag e musub me qoat igorunon eng, bo mi uber apand eng your andariba? ");
INSERT INTO wnu_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","An munon ger wonou mi musub me qoat igorunon eng, bo aninomi tetemi qamb eng your andariba?” ");
INSERT INTO wnu_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ende qamb qamar: “Sarau munon ger munon baraitari ombur sarau me batar igo. Ende ebeiner eng ger wotumet waga ger qas sarau beteiba. Eng gas ende, an Qenut igub sarau botoub qamb eng mind qiyo nomon qur baub qamb end me misir igar.” ");
INSERT INTO wnu_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Yisas qob eng ende qamara Parisi wuri nomon qur qenunget igour end wot ber qob qamamirei. ");
INSERT INTO wnu_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ende abari Yisas wurinob qamar: “An mai end ubune munon inimbag qoaguruimar qamb at igoumon. Munon inimbagaiar qamb ebet igoumon eng Qenu animbagar eng an mi ue gas ende.” ");
INSERT INTO wnu_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Qamb qamar: “Moses qomon eng ne munon qob gigit qamarau eng qob gumatemir eng isi yarab Yon munon ya obotar igoar qen end uburerei. A qob uber see Qenu wonou bibis end qura eng munon gugum isub qamb ibitiri igour eng. ");
INSERT INTO wnu_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","An mai qomon qob gumatemir eng tau piten ger uburiner qamb misir igoumon? Ende ue. Mai qiyo, Qenu ginam ne ai e nob uburiba ende qi eng wonou qomon qob eng gor uburiba qi. ");
INSERT INTO wnu_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","End qamb qamar: “Munon ger yamangar mom baub wogub omboagir bo ger bainer eng uber ue. Ne munon ger yamangar baub omboagir weginerei qindou igama bo munon ger bainer eng qibaiau qomon eng biiseteriba.” ");
INSERT INTO wnu_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ne bo qamar: “Qoan munon baraitari aib ger igoai. Igo mingoan uber-uber qenenginob eng sig naget ne mi uber-uber eng sig nub igoai. ");
INSERT INTO wnu_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Qen end munon boru ger igoai, unum Lasarus. Wo git goan gugum iam, end ne wonou munon banam baub diab munon eng wonou tend gabut end bigumirei. ");
INSERT INTO wnu_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Bigari igo munon aib eng mi nia tub isa ba nib qamb misir igorei. Wo ende igama iau yar iam qesi qamb eng gagar qebist wab ende abari migeri ur wab igoai. ");
INSERT INTO wnu_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ende at igoi wogub Lasarus uma wogub Qenu yurau enger eng der mot irab Abraham qani wagari igo mi uber-uber nub igoai. Ne qen geret bo munon mind nob eng gor uma tumuniamirei. ");
INSERT INTO wnu_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ende abari wo is igo migeri ur wab git goan uter wab ende aba igo mugenderi asi Lasarus gar eng Abraham nob mismisir igoai. ");
INSERT INTO wnu_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ende gab ne atag ar, “Abraham, barai yat oboum, Lasarus imurima isub ya bais baab diab qebist et bais bea gugum baab igini. Mut aib qani e igo sig maragen ur yenera.” ");
INSERT INTO wnu_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ende qamara Abraham taui qamar: “Barai, uber quran ego ye ete qemerine igu: ne igom igoan end mi uber-uber nub igoanei, a Lasarus ende ue, wo quguraget igoar end see wo bo uber igama ne uput qamb quguraget igoan eng. ");
INSERT INTO wnu_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","End ne ai qubir aib wubunobun e igo. End ne an ig ir igoumon eng qubir eng nipat e diorunon eng qeemben ue. A in ig e igoun eng nipat ig ireng yorun eng gor qeemben ue.” ");
INSERT INTO wnu_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","Ende qamara munon eng qamar: “Ende gab eng Lasarus qas imurima ag qumo isub yonou tain munai mor end isub nob qamara yonou bain 5-ende igour eng. At ye igoum e diorunor, wuri irun wab qamara e bais mi diorunor.” ");
INSERT INTO wnu_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ne Abraham qamar: “Bainori Moses qomon gumater eng ne munon qob gigit qamarau qob gumatemir eng nob igub igour. Wurinou me igun qamb at eng gari.” ");
INSERT INTO wnu_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ende qamara munon mind nob eng qamar: “Maigas, munon ger umb wogub bo der bugab is wurinob qamara eng qand wot oabigubour.” ");
INSERT INTO wnu_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ne Abraham qamar: “Eng wuri Moses qob eng nob munon qob gigit qamb gumatemir eng nob wanunger me wot oabigunor eng gor, munon umb der bugab isari me wurit oabigunorei,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yisas ende qamb ne wonou wuri imbigau yurau eng wurinob qamar: “Mi boru-boru irou munon wuri warigesia qomon boru abar qamb dieriba. Eng munon ger mi boru aba munon qei qomon boru eng gab wuritarama taut obounor eng borumesis. ");
INSERT INTO wnu_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Munon ger igo munon qei Qenut oabigour eng wuriba qomon boru wurisirbiga obounor eng munon eng sig mom qugurageteriba. Munon qei nomon aib ger ba tesi wogub munon eng ibiari wogub ten bisub uyer yat ariramari ten isub ya nub umorei ende qi eng wo munon qei qomon boru me wurisirbigau qi. End ne an bo imusi munon qei qomon boru wurisirbigunon qamb qoyamet igoarar. ");
INSERT INTO wnu_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Qomon ger ete ne igoriner: “Nonou bain qiyo ima ger qomon boru ger aba gab eng irun wab qem. Qamara misir iga gab eng ne wo musi. ");
INSERT INTO wnu_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ende ebeinen eng wo worom gari end qen 7-ende qomon boru nesi ne bo oau mein burab bo qen 7-ende yar nemeinsia gab eng ne wo qomon boru nesieriner end bo tauimb misir me igu.” ");
INSERT INTO wnu_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ende qamara wuri der Munon Barai nob qamamir: “Se quran eng in toaun eng misue eng gab ininou oau apand eng nonogursi.” ");
INSERT INTO wnu_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ende qamarari Munon Barai wurinob qamar: “An oau apand baiste mastet qur qamaaman gas ende igo gab eng nam ger nob qamarar, “Ne nonou ar durun ten nerer isub bo tomon yat end nag” ende qomorunon eng an qob toat ende ebeiba.” ");
INSERT INTO wnu_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ende qamb qamar: “An yurau end ger wonou sarau munon ger nob qamara is man isiau wotet a wai sipsip qoat ende at qib igama an mai mi yemetet wogub is arari yar mi niba? ");
INSERT INTO wnu_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ende ue, wo an igo wo wot arari yar mi yab, ya unab andara an gigit niari wo qanamt niba. ");
INSERT INTO wnu_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Sarau munon eng ende aba wonou munon barai eng der uber wot qemeriba? Ende wot me qemerinerei. ");
INSERT INTO wnu_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Eng gas ende an gor Qenu mi abar qamb aninob qamara ebet ugab gab eng an der ete qamarar, “Eng in ar sarau munon end ar sarau botoun,” ende qamarar.” Ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yisas Yerusalem tap eng toat isub ne ai Samaria Galili nob wobon end qib igoai. ");
INSERT INTO wnu_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","13","Isi yarab ginam ger end isa ne munon iam qarab nob igour eng 10-ende wot yarab mugenderi ete naget igo amir: “Yisas, Barai in mai intoubarinen qiyo?” ");
INSERT INTO wnu_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Arari Yisas ibag wurinob qamar: “An Qenut mian yab igour munon yurau end isari animbogounor.” Ende qamara qataben isub gamir eng iam wout uburerei. ");
INSERT INTO wnu_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","16","Ende gab gari qas Qenut igub mismisir wot uber qamb bo igeser diab Yisas menmant end wonou git goan arir inab Yisast ‘uber’ qamb atag arei. Munon eng git Samaria munon. ");
INSERT INTO wnu_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ende aba Yisas der qamar: “Ye an munon yurau gugum ende mom uberburab uburumanei quraum eng qei eret igamari ne gari dian? ");
INSERT INTO wnu_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Munon e Isrel munon ue ego wonou gari Qenut oabig wot ab aba. Meimet qamb Isrel munon qei musine uberetorour eng ende me obour?” ");
INSERT INTO wnu_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ende qamb munon eng nob qamar: “Nonou oau apand end ne uberaran, end der naget isi,” ende nob qamarei. ");
INSERT INTO wnu_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ne Parisi munon qei der Yisas qebi qamamir: “Qenu wonou bibis eng qen mait deriba?” Qamarari Yisas taui qamar: “Qenu wonou bibis eng dara munon magqurt maigas me gunerei. ");
INSERT INTO wnu_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Munon ger der, “ge, e darar e, qo ire dara ire” ende me qomurunorei. Qenu wonou bibis ansirbig ig eng qenen qomon uber animbig ne anoar igo.” ");
INSERT INTO wnu_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ende qamb wonou imbigau yurau eng wurinob qamar: “Qen geret Munangit wau wonou qen eng yara an gub qamb qenungouboumon. Ego an maigas me gunanei. ");
INSERT INTO wnu_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ende abari munon qei der anmurimar ete qomorubour, “Ire dara ire gaiar, qo mere darar e gaiar,” Ende qamarari igub an apand qamb is gub qamb me asi qib igoarar. ");
INSERT INTO wnu_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ai qebisi ne ai gugum umo ite begent ubura gaumon nami ende Munangit wau wonou qen eng gor ende gas ebeiba. ");
INSERT INTO wnu_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ego se qamart wo git goan borusi uter wab ende aba munon qen see igour eng mogirt wab wogubour. ");
INSERT INTO wnu_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Wugunerei igama Munangit wau wonou qen eng yara qoan Noa wonou qen gas ende dieriba. ");
INSERT INTO wnu_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noa wonou qen eng ete ebetemirei, Mi uber-uber nub a ya nub a munon yamangar qi baub ende at igamari Noa tabin erobon isa ya qoan weib di igaramorei. ");
INSERT INTO wnu_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ne Lot wonou qen end gor ende. Mi nub a mi wurisab taui mi ba. A mi ubub mon mindat, ende at igurei. ");
INSERT INTO wnu_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ende at igamari Lot Sodom wogub qoa mut nomon qoamin gagam-gagam ya darau gas ende der igaramb ugarei. ");
INSERT INTO wnu_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Eng gas ende Munangit wau wonou qen eng mi eng gar ebeteriamor gas ende dibeneriba.” ");
INSERT INTO wnu_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ende qamb qamar: “Munon ger ag bugab woromt qoariget igo qen eng yara gab bo qand der mor isub mind qamb eng me bainerei. Ne gor munon ger wonou man end mi ubub igama qen eng yara gab bo qand mor me irinerei. ");
INSERT INTO wnu_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lot ubeni ebeter eng gaiar. ");
INSERT INTO wnu_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Munon ger wonomit igub ebeiner eng mom umiba. A munon ger wonomit igub me ebeiner eng iigomot igoriba. ");
INSERT INTO wnu_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Itum end munon ombur gar garit inunor eng Qenu ger mot irab ger wegiba. ");
INSERT INTO wnu_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ne yamangar ombur mani yab igorunor eng Qenu ger mot irab ger wegiba. ");
INSERT INTO wnu_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ne munon ombur mi ubub igorunor eng ger Qenu mot irab ger wegiba.” ");
INSERT INTO wnu_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ende qamb waga wonou imbigau yurau eng der qebi qamamir: “Barai mi eng gagar quran eng eret dieriba?” Ende qamarari Yisas taui mit big qamar: “Man suab gumunorei igama morogan sanou murib baub qamb qiumunimbour,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yisas Qenut qenen qebi qamb a me ietarar qamb wuriimbig mi geret big wurinob qamarei. ");
INSERT INTO wnu_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Qamar: “Ginam geret munon ger munon qob musitar igoai. Munon eng wo Qenu yari qiyo ne Munangit wurit me igub igamau. ");
INSERT INTO wnu_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ginam end gari yamangar qindou ger igoai. Wo qenen munon end diab simot ab ete nob qamb igoai, “Yonou munon qarau eng ye borusieriba, yonou qob yet wairmeseis.” ");
INSERT INTO wnu_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ende qamara munon eng qoan munon qei me wuri musub igamau. Qen end wonou ete misir igorei, “Qo, ye Qenut me igub a munon wurit gor me igub at igoum. ");
INSERT INTO wnu_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","End ne yamangar qindou e yet diar eng qob wot me wairemin eng qenen ende yet di igama ieteribam.” ");
INSERT INTO wnu_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Munon Barai Yisas qob eng ende qamb imusi qamar: “An eng gaiar, munon qob qereimau eng uber ue. ");
INSERT INTO wnu_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Qenu wonou munon wuriqenungar eng inmusi qamb woromt a itum qenen wot simot arari mai me wurimusinerei qiyo? Mai tandari wot eab igamari iet ne wurimusieriba? Ende ue, ");
INSERT INTO wnu_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Wo qob gari igub qand qoregensitariba. Ego Munangit wau wo qen geret deriner end munon wot oabigour qiyo, me wot oabigour eng wuriqerei ibegeiba.” ");
INSERT INTO wnu_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ende qamb ne bo munon qei wurinou mit gari igub ne munon qei me wurit igub igour end bo mi geret big wurinob qamar: ");
INSERT INTO wnu_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Munon ombur Qenut qebi qomorub qamb inorou munait iramirei. Eng ger Parisi ne ger qur baiau munon. ");
INSERT INTO wnu_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Parisi eng irab mugenderi ete naget qamar, “Qenu, ye net uber quraum. Ye munon qei mi urim ba qetopur qamb a yamangar wurit qarig ir qib igour gas ende ue. Ne munon nonou qur ba qib igo qira maget igo gas ende gor ue, ye munon qoregen uber. ");
INSERT INTO wnu_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ye qenen inorou gugum qen erobon end qen ombur qenen nenet igub mi gitab igoum. Ende at ne ye mi gugum ba qiumuni bubur 10-ende bugamsi ne bubur gari qas nenet big igoum. ");
INSERT INTO wnu_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ende qamara ne bo qur baiau munon eng bo qi der naget wonomi toubet qumor mesenau Qenu nob qamar, “Io, Qenu, ye munon uber ue, ye munon mindigar qob qoat end yet igub yemusi” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yisas ende qamb qamar: “Ye eng aninob quraum eng, Qenu munon end wot munon uber ende wot qamara wonou munai mor isorei. End ne munon ger yonou aib uber qamb ebeiner eng Qenu bumaimba. A munon ger wonomi toubet ebeiner eng Qenu wo musieriba.” Ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Qamb igama ne munon qei wurinou wau oromar diune Yisas wuri nonogursi qamb oromar diamirei. Dearari wonou imbigau yurau eng der oromar qamamirei. ");
INSERT INTO wnu_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ende abari Yisas qamara wau ba yaremirei. Yarari wo der wonou yurau wurinob qamar: “Wagari oromar yarunor. Qenu wonou bibist igorunor eng munon gugum wau qamaaman eng gas ende burunor qamb wo qenunget igo. ");
INSERT INTO wnu_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Eng igar, munon ger Qenu bibis eng wau qomour e qenunga gas ende me ebeiner eng bibis end me igorinerei.” ");
INSERT INTO wnu_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ende qamara Yuda munon baraitari ger Yisas qebi qamar: “Ne munon imbigau tari, ne munon uber, ye maigas ebet iigomot qenen igoribam?” ");
INSERT INTO wnu_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Qamara Yisas taui nob qamar: “Meimet qamb uber yet quran? Munon ger uber ue, Qenu gari qas uber. ");
INSERT INTO wnu_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Qomon eng gari nonou qoyam eng me eb: yamangar munon ger bauor eng bo me bai, me igeig yom, mi urim me bai, a wurimurimar me qem, nani tain qob qamarari iruges big igu.” ");
INSERT INTO wnu_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ende qamara munon eng taui qamar: “Ye wau qomourt igo qomon eng gagar quran eng toat igoum eng isi yarab see ten isigi burem e.” ");
INSERT INTO wnu_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yisas qob eng igub nob qamar: “Uber quran ego mi gari qas eng se ebet igoriban eng ete; ne mind eng munon qei wurisab ne qur taui ba munon mi ue eng werisiban. Ende ebeinen eng Qenu ginamt ne bo sau binat igoriban. End ne see yarab ye yetoa qib igorun.” ");
INSERT INTO wnu_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Munon eng sau binat end Yisas ye toat qib igoar qamara igub igeser qungon degen burab qorei. ");
INSERT INTO wnu_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ende ebet qoa Yisas gab toubet qamar: “Munon gugum mind irou igorunor eng Qenu bibis end irunor eng qob qinan. ");
INSERT INTO wnu_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Munon mind nob eng Qenu wonou bibis end irub qamb eng sig-sig mom qob qinan. A maiben aib gaun eng mingoan mi qer mingoan mai igoun iru qomourt eng ar qasai isiba.” ");
INSERT INTO wnu_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Munon qei qob eng igub qebi qamamir: “Ende gab eng your uber igoriba?” ");
INSERT INTO wnu_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Qamarari Yisas qamar: “Munangit mi maigas me ubunerei, misue eng Qenu ar ebeiba.” ");
INSERT INTO wnu_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ende qamara Pita der nob qamar: “In munai ginam a mi gugum wogub ne netoat qib igoun eng maigas obouboun?” ");
INSERT INTO wnu_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ne Yisas taui qamar: “Io, munon ger Qenu wonou bibis end igorib qenunget eng ginam qiyo, ubeni qiyo, umom umour wogub qiyo unor ur qo wagrari wuriwogub qib igo eng sig uber. ");
INSERT INTO wnu_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Ende obounon eng Qenu an mi see igo eng wotanami mi sig irou andariba. Andab igama qen geret ansiara qenen bebereg igoruboumon.” ");
INSERT INTO wnu_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ende qamb wogub wonou imbigau yurau 12-ende oromar wes opur ete isub wurinob qamar: “Ete qemerine igar. In Yerusalem qite irune qob gigit qamarau munon Munangit Waut qamb gumatemir eng irimanimba. ");
INSERT INTO wnu_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Baab ba imurimari munon yurau art wurit isiba. Isa ba sumungasi wot tumi mogirt wab wogubour. ");
INSERT INTO wnu_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Wogub pisirami waramb wogub mom waramari uma tumunimunorei igama qen duor gari ende ubura bo iigomot der bugemba.” ");
INSERT INTO wnu_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ende qamara wonou imbigau yurau eng qob eng me imbigau. Qob qanam wurit waberamorei. Ende aba Yisas qob meimit qamb igoar eng me imbigau. ");
INSERT INTO wnu_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ende at wogub be Yeriko qani end diab gamir eng munon mag tuum ger tap goant et bugab igo mi yeisar qamb ibirat ab igoai. ");
INSERT INTO wnu_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Qen end munon yurau aib yar isub abari igub qamar: “Eng meimi obour?” ");
INSERT INTO wnu_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Qamara munon qei nob qamamir: “Nasaret munon Yisas eng yar ebet igo.” ");
INSERT INTO wnu_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ende qamarari Yisas simot eab ar: “Yisas ne Debit wonou wau tumbigi, yet igu.” ");
INSERT INTO wnu_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ende ara munon gigit isumir eng wog qamb qoronob qamat qamamir. Ego wo sig-sig mom ab qamar: “Debit wau tumbigi, yet igu.” ");
INSERT INTO wnu_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ne Yisas naget wurinob qamara munon eng mot qani yarari munon eng nob qamar: ");
INSERT INTO wnu_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ye ne mai yesi qamb misir igan?” Qamara munon eng qamar: “Ye bo asiemb qamb misir igoum.” ");
INSERT INTO wnu_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ende qamara Yisas nob qamar: “Eng ge, nonou oau apand end bo asiemban.” ");
INSERT INTO wnu_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ende qamara qand asi mi gab Qenut uber qamb Yisas toat isorei. Isa munon irou gab wuri gor Qenut mismisiramirei. ");
INSERT INTO wnu_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yisas Yeriko weib isub bo tumbigi isib qamb isorei. ");
INSERT INTO wnu_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ginam end munon qur ba qib igour eng wurinou munon barai tari ger igoai unum Sakius. Wo nomon qur irou igoai. ");
INSERT INTO wnu_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Qen end wo Yisas eng your ende qamb gib qamb ater ego wo munon qomourt piten end munon yurau irou end opuramirei. ");
INSERT INTO wnu_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ende abari ne wo gigit isub nam ger irab erer igo Yisas tap eng isa gib qamb isorei. ");
INSERT INTO wnu_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yisas isi yarab Sakius igoar end is naget qiter asi gab qamar: “Qand ag dara see ye nob nonou munai mor isuboun.” ");
INSERT INTO wnu_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ende qamara Sakius qand darab gab io qamb borusi mismisirarei. ");
INSERT INTO wnu_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Munon yamangar ende aba gab mindigar qob wot qamb qamamir: “Wa, munon eng bo is munon mindigar qoat nob munait isar eng gaum, a.” ");
INSERT INTO wnu_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Mor isub Sakius der naget Yisas nob qamar: “Barai, yonomi gugum qiumuni big wogub wubunobun omboopur munon mi ue eng werisibam. Ne ye munon ger mirimot wonomi eng wot baub igo gab eng ye bo mi qen 4-ende taui utibam.” ");
INSERT INTO wnu_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ende qamara Yisas taui qamar: “See qas Qenu munon munai mor e igour eng oromar igo. Munon eng wo gor Abraham wonou tumbigi. ");
INSERT INTO wnu_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Munangit wau munon yamangar qomon borut igamari wuriubersierib qamb dererei.” ");
INSERT INTO wnu_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ende qamara igari ne wo gor Yerusalem isib pisier end bo mi geret big gor wurinob qamara igumirei. Wuri see qas Qenu wonou bibis eng deriba qamb misir igumirei. ");
INSERT INTO wnu_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ende abari wurinob qamar: “Munon barai tari ger ginam pa isine king yemaribigar qamb isorei. End igoi wogub qen geret bo yariba. ");
INSERT INTO wnu_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Qen end wo isib qamb wonou sarau munon 10-ende wurit ara yarari qur wurisab qamar: “An qur e ba sarau ebet ne qur eng imusi bo ui ar baub igamari ye bo yarine qur yeisuboumon.” ");
INSERT INTO wnu_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ende qamb wogub isa munon eng wonou ginam eng wuri munon eng king igamau end wuri iet wogub ne bo munon qei wuriimurimari isub qamamir: “In munon eng king igamau end ietoroun.” ");
INSERT INTO wnu_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ende qamamir ego, song king maribigari igoi wogub yarerei. Yarab ne wonou sarau munon qur wurisab wogub isuor eng mai sarau ebet bo qur ar ui baub igour qi eng gib qamb ");
INSERT INTO wnu_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ne munon qamar wot yar qamar: “Io, barai, ye qur K20-ende yeisen end sarau ebet bo ui ar K200-ende baumei.” ");
INSERT INTO wnu_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ende qamara munon eng qamar: “Ne sarau munon uber. End ne mi garit eng musub qoat ne ba aibsiau eng gab ne ye nemaribigine munai ginam 10-ende qoat igoribam.” ");
INSERT INTO wnu_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ne bo ger yar nob qamar: “Barai, ne K20 yeisen end ye bo tumbigi sarau ebet K100-ende baumei. ");
INSERT INTO wnu_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ende qamara king nob qamar: “Ne ginam 5-ende qoat igoriban. ");
INSERT INTO wnu_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ne bo ger yar qamar: “Barai, ne K20 yeisen eng ye suumi wogub wabi wagom oum igo. ");
INSERT INTO wnu_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ye ne munon qand-qand mirintra negab igoum end. Munon qei mi bigari ne wurit ba qiyo, mani wurit gonat aba negab igoum end.” ");
INSERT INTO wnu_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ne wonob qamar: “Ne sarau munon uber ue. Ne qob quran eng ye musub igibam. Apand ye munon qand mirinet igoum qiyo. A, mind wurinou ye baub igoum qiyo. Ne mani wurinou ye gonat nub igoum qi eng gibam. ");
INSERT INTO wnu_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Eng ne meimet qamb ye nomon qur netem eng bis qur baiau munai end bigesab igama ye bo ete yarab qur imusi nob baiau ue. ");
INSERT INTO wnu_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ende qamb ne munon qani nogumor igour eng wurinob qamar: “Munon eng K20 utem eng wot ba bo munon qamar K200 bauor eng utor.” ");
INSERT INTO wnu_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ende qamara wuri qamamir: “Wo mom K200-ende baurei.” ");
INSERT INTO wnu_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ende qamarari wo qamar: “Munon mi irou baub qamb obour eng bo sembigi werisibam. A munon mi irou me bainei qamb abar eng mi garit baub igoriner eng ye wot ba munon mi irou baib qamb ebeiner eng utibam. ");
INSERT INTO wnu_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Yonou munon qarau ye wurinou king igoribine wogour eng oromar yar ye menmant et igaramar.” ");
INSERT INTO wnu_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yisas mit big ende qamb wogub ne wo gigit Yerusalem ite irib qamb irarei. ");
INSERT INTO wnu_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Iri munai ginam Betpage Betani nob ai qaur ger nam Olib man aib igo end irab. Wonou imbigau munon ombur wuriimurima gigit isumirei. ");
INSERT INTO wnu_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Wuriimuri qamar: “An gigi isub munai ginam geret isub gunon eng wai dongi yeim ger tesi igamari guboumon. Dongi eng qoan munon ger irer me bugab qib igamau. Eng gab neri ba diarar. ");
INSERT INTO wnu_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","An neri igamari munon ger animbag, “Meimet neri igoumon?” Ende qamara gab an nob qamarar, “Munon barai sarau nob gab qamara ba irub qamb neri igoun,” ende qamarar.” ");
INSERT INTO wnu_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ende qamb wuriimurima isub mi gugum Yisas wurinob qamar gas ende eretersi ugamirei igama gamirei. ");
INSERT INTO wnu_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Isub dongi eng gab simarur nerub igamari ibag qamamir: “Meimet neri igoumon?” ");
INSERT INTO wnu_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Qamarari wuri qamamir: “Munon barai qoru nob diarar ende qamara yar nob irub at igoun.” ");
INSERT INTO wnu_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ende qamarari wagari nerub ba irab mingoan norumi wai erer oromari Yisas erer ir bugamorei. ");
INSERT INTO wnu_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Bugab isa mingoan norumi tapet oromari erer isorei. ");
INSERT INTO wnu_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Isi Yerusalem qani ai tap ai qaur nam olib man aib igo end isub igour sorai end isa munon yurau aib toat qib igour eng end qanam big Qenut mi uber inimbiga gaminei qamb wot uber qamb mismisir ab qamamir: ");
INSERT INTO wnu_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Qenu ininou king ininou munon Barai unumut nonogursia yara. Oau mein Qenut ne wonou ginam end igoriner. ");
INSERT INTO wnu_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ende qamb ab abari Parisi qei erobon end der Yisas nob qamamir: “Imbigau munon, nonou yurau e wuritaisia wogunor.” ");
INSERT INTO wnu_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ende qamarari Yisas wurinob qamar: “Ye wuritaisine wagari mai nomon e gagar wuri uput qamb toaubigubari ende qi eng ende oboum qi.” ");
INSERT INTO wnu_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Isi Yerusalem pisi ne asi ginam aib gab wot eerei. ");
INSERT INTO wnu_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Eab qamar: “O Yerusalem munon, an see qas Qenu nob qibanamsiau werei eng imbig ende qi eng uber qi. Werei eng anit waber igo end me gunanei. ");
INSERT INTO wnu_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Qen ger gab eng aninou munon qarau yar anqoui ugoubour. ");
INSERT INTO wnu_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ende at ne aninou yurau wurinob igoumon eng wuri gumutumai ugoubour. Ende at ne see nomon ger, ger erer igo eng wagari me igorinerei. Qenu wo an ubersieriner eng an qoyam ue end ende ansiorubour.” ");
INSERT INTO wnu_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","46","Ende qamb wogub inorou munai mor isub munon oai qi gab mi qi wurisab taui baub igamari orotoar arir wurinob qamar: “Qenu qamara ete gumatemirei, “yonou munai mor eng munon end is igo yesimot ab igoarar qamb gari. An bo ba sumungasi abari munon mi urim baiau munai gas ebet igoumon.” Ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yisas inorou munai end qenen qob wuriimbig igoai. Ende at igama munon Qenut mian yab igour barai tari eng ne qomon imbigau eng ne munon qei wurinou barai tari eng gagar Yisas waramb at igurei. ");
INSERT INTO wnu_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ende ebetemir ego maigas me waramau. Munon gugum wo qob qamara musub mom iruges big igub igour end. ");
INSERT INTO wnu_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Qen geret Yisas inorou munai mor end igo Qenu qob wurinob qamb wuriimbig ende at igama ne munon Qenut mian yab igour barai tari eng ne qomon imbigau eng ne barai tari qei ende qiumuni diamirei. ");
INSERT INTO wnu_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Diab Yisas nob qamamir: “Ne mai gas igo sarau eng gagar ebet qib igoa, eng ininob qamara igun? Your sarau eng eb qamb qamara ebet igoan?” ");
INSERT INTO wnu_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","4","Qamarari Yisas taui qamar: “An eng qamarari ye bo ete an qebi qemerini: Yon munon yat wurinonogursi igoar eng mai Qenu io qamara ebet igoai qiyo, munangit?” ");
INSERT INTO wnu_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ende qamara wurinou der agunub qamamir: “Wa, eng qura eng in mai qomoruboun? In ete qomorun eng, Qenu qomorun eng, wo ete qemeriba, “eng gab an meimet qamb Yont me oa bigoumon?” ende qemeriba. ");
INSERT INTO wnu_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","A, ‘munangit et’ qomorun eng munon yurau aib e Yon qob miteri qamarau munon end wot oabig igour end nomont iningarambour.” ");
INSERT INTO wnu_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ende qamb wogub ne taui qamamir: “In sir qoyam ue eret dererei qi.” ");
INSERT INTO wnu_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ende qamarari Yisas wurinob qamar: “End ne ye your yiimbiga mi eng ebet igoum qi eng me aninob qemerinei.” ");
INSERT INTO wnu_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ende qamb ne mi geret big wurinob qamar: “Munon ger man suab wogub wain ubub wogub munon qei qoat sarau baab wurisab mi taui baub igoarar qamb wogub wo ginam pa iua gurum igoai. ");
INSERT INTO wnu_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Wain ubub wogub iuar eng qen yara ne wonou sarau munon ger imurimine isa munon wain man qoat igour eng wain git qei ba utor qamb imuriamorei. Imurima isa munon man qoat igour eng der munon eng borusi waramb sumungasi wogub mi ger me utau, ar imurimari isorei. ");
INSERT INTO wnu_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ende abari isa gab bo ger imuriamor eng gor waramb sumungasi wogub mi ger me utau, ar imurimari isorei. ");
INSERT INTO wnu_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ende gab ne bo ger imuriamor eng mom waramb mumusi wogub mumun ba ag ariramari isorei. ");
INSERT INTO wnu_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ende gab wain man ur eng der, “mai ebeibam” qamb ne qamar: “Ende gab eng yonou wau ten ait imuriemin eng tuan ende me ne siorunor.” ");
INSERT INTO wnu_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ende qamb wonou wau ten imurima isa gab wurinou qob-qob qamamir: “Wonou wau ten eng igo tuan ur uma wain man e wo baiba, wagari waramb arir wain man e ininou baun. ");
INSERT INTO wnu_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ende qamb baab ba ag ariramari isa waramb mumusiamirei.” Yisas ende qamb wuri qebi qamar: “Munon eng ende abari wain man ur eng der munon eng mai wurisieriba?” ende qamb qamar: ");
INSERT INTO wnu_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","“Wo yar munon eng igaramb ugab wogub wain man eng bo munon qei wurit wegiba.” Ende qamara munon qei igub qamamir: “Sig ue ar. Eng ende me ebeiner.” ");
INSERT INTO wnu_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ende qamarari Yisas ibag bis arir wuri qebi qamar: “Meimet qamb Qenu qob eng ende at qura? Mon mindau munon nomon ger boru qamb arir wagomirei igama bo munon ger nomon eng uber gab qoren unatari yamorei. ");
INSERT INTO wnu_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Munon qei erer end qib yarisiorunor eng mom umubour. Ne nomon eng uburab isub igaraminer eng mom sairir uburubour.” ");
INSERT INTO wnu_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ende qamara qomon imbigau munon ne Qenut mian iset big igour munon gigit igour eng igumir eng Yisas qob eng qamar eng wurit mi big qamara igub baab waramb ebetemirei. Ego munon qei wurit yari wugumirei. ");
INSERT INTO wnu_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ende at ne musub qoat igurei. Igo munon qei wurinomit in munon qoregen qamb igour eng wuriqereimari yar toat nan gab igurei. Igo qob maigas qamara igub mot gabman baraitari aib end isub qob misitoub qamb. ");
INSERT INTO wnu_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ne munon Yisas qob soageni qamara igub qamb toat gab igour eng yar Yisas nob qamamir: “Imbigau munon, in mom imbigoun ne qob qamb inimbigan eng sig uber. Munon barai tari im ibag me qamb igoan. Ne Qenu wonou misir apand eng qas wuri nob qamb igoan. ");
INSERT INTO wnu_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","End ne ne misir maigas igan, ininou qomon eng toat nomon qur Rom gabman utun eng uber qiyo?” ");
INSERT INTO wnu_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ende qamarari Yisas mirimot qamamir eng diban ibag wogub wurinob qamar: ");
INSERT INTO wnu_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Nomon qur eng yesirbigari gine. Your wonou qugur nonou qurt end igo?” Qamara wuri qamamir: “Rom gabman baraitari Sisar qugur igo.” ");
INSERT INTO wnu_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ende qamarari Yisas qamar: “Uber, ende gab eng Sisar wonomi eng sir utar, a Qenu wonomi gab eng wonou sir utab ende abar.” ");
INSERT INTO wnu_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ende qamara igumir eng Yisas mi soagen ger qamara igub uyort bigun qamb ebetemir eng qob soagen ger me qamara igub qitet mitembur maget igurei. ");
INSERT INTO wnu_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ne munon Sadyusi yurau qei munon umb bo me der bugomunorei qamb igour eng yar Yisas qebiamir: ");
INSERT INTO wnu_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Imbigau munon, Moses qomon ger init ete qamb gumatarerei: Munon ger yamangar baub wogub ubeni wau me bainenei igama wo uma ne bo umour yamangar qindou eng baia ne wot wau bainer eng wau eng umami qamar uminer eng wonou wau. Moses qob ende init gumaterei. ");
INSERT INTO wnu_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","End ne, mai qiyo, munon ger wau 7-ende. Wau qamar yamangar bauor eng wau me baiau igama umorei. ");
INSERT INTO wnu_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Uma wau yab bo umom yamangar qindou eng baurei. ");
INSERT INTO wnu_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Eng gor ende sig, ubeni wau me baiau igama umorei. Ne bo wau qag baurei. Mom ende at is-isi wau isar mom sindomun bauor eng gor wau ue igo umorei. ");
INSERT INTO wnu_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Munon mom gugum ende umb uburari ne sindomund wurinou yamangar qindou eng gor umorei. ");
INSERT INTO wnu_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","End ne, mai qiyo, qen geret munon gugum bo der bogomari ne yamangar eng der bogoma your wonou bo baiba, mai wau 7-ende baumir eng wurinou bo baubour qiyo?” ");
INSERT INTO wnu_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ende qamarari ne Yisas taui qamar: “Munon yamangar qen see qibaub igour. ");
INSERT INTO wnu_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","A munon yamangar umb wogub bo der bugomunor eng wuri bo sabar me qibaunorei. ");
INSERT INTO wnu_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Wuri gugum enger gas ende gari burab wogub bo sabar me umunorei. Umb der bugomunor end Qenu wau sisinam. ");
INSERT INTO wnu_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","End ne Moses munon umb der bugomunor end qamarei. Qoan Moses nam ger oab igama gea Munon aib qob ger nob qamar eng “Ye Abraham, Aisak ne Yekop wurinou munon Baraitari.” ");
INSERT INTO wnu_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Eng qamar eng qanam eng Qenu wo me umb igo, qenen bebereg igo, end munon gugum wot bebereg igorubour.” ");
INSERT INTO wnu_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ende qamara qomon imbigau munon qei qamb amir: “Imbigau munon, ne qob eng taui quran eng sig uber.” ");
INSERT INTO wnu_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ende qamb bo qebi qamarau end qubig wogomirei. ");
INSERT INTO wnu_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ende abari Yisas bo wurinob qamar: “Maigas igama gab munon Qenu inubersierib maribigor eng wo Debit tubig wot qamb igour? ");
INSERT INTO wnu_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Debit wonou qoan buk Sam end ete qamb gumaterei: Munon Aib igo yonou Munon aibt ete qamarei: yonou uberegent wes et bugab igama nonou munon qarau ye wuriimurimine nonou goten yau erobon end igamau gas end igorubour. ");
INSERT INTO wnu_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","End ne bo maigas gab Debit wonou tumbigi eng bo der “Krais yonou Munon Baraitari” wot qamb igo?” ");
INSERT INTO wnu_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ende qamara munon gugum igub igamari ne wonou wuriimibigau yurau eng bo sir wurinob qamar: ");
INSERT INTO wnu_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“An qomon imbigau munon yurau end wurit qoyamet igoarar. Wuri ete ne obounor. Wuri mingoan degen naget wogub munon qen inimbagaiar qamb munon qiumuni igamari magqurt end naget, a inorou munait end isub mag qur end bugab a mi bingen at nub eng nam qab deberit end bugumune inimbagaiar qamb ende oboubour. ");
INSERT INTO wnu_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ne gor yamangar qindou wurimurimar qamarari apand qamb munai wurit wagari end igorubour. Ne Qenut qebi qomorub eng qob degen aib qamb bisub igorubour. Ende ebet igorunor eng qob musiau qen end wuri dorogorubour,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","2","Yisas inorou munai aib mor end naget ibag igama munon mind nob eng nomon qur irou bis Qenut bigari, ne yamangar qindou ger nomon qur qomourt ombur-ombur qas bis arirama garei. ");
INSERT INTO wnu_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Gab wurinob qamar: “Apand aninob quraum, yamangar qindou e qur bigar eng an gugum qur bigoumon eng antanamima. ");
INSERT INTO wnu_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Qanam eng an qur irou igo end tau big tau igama aninou mi ba nuboumon. A, wo ende ue, gari igemerei eng mani ba nibam qamb me wagau. Gugum mom arir ue gar end antanamima,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Munon qei inorou munai aib nomon aib-aib qenenginobt mindatemir eng gab a Qenut nomon qur big eng abari gab qoagurui qamarari Yisas wurinob qamar: ");
INSERT INTO wnu_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Mi eng gugum gab qoaguruimoumon eng, qen geret bapami nomon qei wagari erer me igorinerei, gugum mom ago oum der inumutri igoriba.” ");
INSERT INTO wnu_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ende qamara wuri qebi qamamir: “Imbigau munon, qen mait mi eng gagar quran eng aba guboun? Ne gor mi eng gagar ebeib qamb meimemit in mirorub gab imbig igoruboun?” ");
INSERT INTO wnu_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ne wo taui qamar: “An ete mirorub gab eng qoyamet igoarar, qen quraum eng yariba eng munon irou yar anmurimar ete qomorubour, munon yariba qamarari igub igoumon eng gari ye yoroum e. Ende qamarari an igatar wagar. ");
INSERT INTO wnu_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ne gor munon ginam-ginam aib qamb yogorari qob toau igub gor me yarimar. Mi eng gagar ebeteriomunor eng qen sindomund eng se qiren igoriba.” ");
INSERT INTO wnu_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ende qamb imusi qamar: “Munon ai aib geret igour eng der geret igour eng wurinob yogub a king ger yurau eng der king ger yurau eng wurinob yogub ende ebeterimbour. ");
INSERT INTO wnu_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ne ai aib qamb uyab ai qaur duret munon wuri uiebig a ginam qei qunumber qen aib yar a toar aib qamb igab ne gor tatet qitend gunon eng yarimar qamb mi mirortar ende ebeterimba. ");
INSERT INTO wnu_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Mi eng gagar quraum eng me yarinerei igama gigit an ansumungasiorubour. An ye qob igub ye yetoat ende at igamari munon qarau yar anbaab anamar inorou munai qoat igour munon eng wurit isub anwagari aningarambour, ne gor uyort anbigubour. Ende at ne anamar gabman munon baraitari a qob musitarau munon wurit isubour. ");
INSERT INTO wnu_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Wuri ende anamar isari qen end yonou qob uber eng sabar-sabar wurinob qamarar. ");
INSERT INTO wnu_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Wuri ende ansiarari qob maigas wurinob qomorun qamb misir me igar. ");
INSERT INTO wnu_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","An wuri magqurt naget igamari yonou gari ansierine misir uber igub qob qeretut nob qamarari aninou munon qarau igub me ombarir ne me anbumaimunorei. ");
INSERT INTO wnu_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ne aninou tain nanib ne munon banam wurinou anduimari munon qarau an qei aningarambour. ");
INSERT INTO wnu_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ende at ne an yet mom igub abari animbag ye yesiningot ne ansumungasiorubour. ");
INSERT INTO wnu_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ende ansiorunor eng Qenu anoar igoriba. ");
INSERT INTO wnu_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ende aba ne an munon qarau wurit yari ne qer gimiet yonou qob uber qomorunon eng isi yarab bo igomot igoruboumon.” ");
INSERT INTO wnu_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ende qamb qamar: “An igo qen geret gunon eng yogorau munon yar ginam aib Yerusalem qon ariramari gab eng, ‘qo munai ginam borusiorubour qen eng piara,’ ende qomoruboumon,” qamar. ");
INSERT INTO wnu_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","“Ende abari munon Yuda wuri iua ai qaurent irubour. Ne munon ginamt igorunor eng iua amug isubour. A munon ai geret igorunor eng bo qen end di ginam aib end me isunorei. ");
INSERT INTO wnu_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Qen eng yariner eng Qenu wau waramir end taui qamb ne gor qob qoan gumatemir eng irimaniom qamb ");
INSERT INTO wnu_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Qen end yamangar qurag igour eng nob wau se ba inau wurisab igour eng nob wuri borumesis. Qenu wo misiringeteriner eng munon ag e qomon eng ebetemir eng wurit qoot-qoot isiba. ");
INSERT INTO wnu_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Bui qaurit wurigumar, ne qei uyort wuribig oromar munon ginam qei magqurt wuri nagasi igorubour. Ne munon ar Yuda ue eng wuri yar Yerusalem di igamari wurinou qen ubura ne wogubour.” ");
INSERT INTO wnu_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ende qamb qamar: “Qen eng yariba, worom, inaun, tapai qamb eng gagar mirarubour. Ne ago e uyer ya iger yar toaima igub munon yamangar gugum borusi mom yarimbour. ");
INSERT INTO wnu_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ag e mi gugum undounder uburab a tapai erer qite norumor dara gab yari mag uburab uburiba. ");
INSERT INTO wnu_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Mi eng gagar gabri ende ebet igamari Munangit Wau waberet qenengi nob ne wonou qiribiten deriba. ");
INSERT INTO wnu_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Mi eng gagar qanam big ende mirorub gab eng an matarub qitermar. Qenu anamar iribeiner eng mi ende guboumon,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yisas qob eng ende wurinob qamb wogub mi geret big qamar: “An nam togun nob nam ar qei nob ibagaiar. ");
INSERT INTO wnu_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Nam eng gagar warari eng ‘qo worom qen pi’ ende qamb igoumon. ");
INSERT INTO wnu_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ende gas ende gari, mi eng gagar miroriari ibag “qo Qenu inamar iribar eng piara” ende qamarar. ");
INSERT INTO wnu_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Eng apand aninob quraum, munon see igour eng qei me umunorei igama mi eng yariba. ");
INSERT INTO wnu_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Qen eng yara ai tat nob mom uburiner ego, yonou qob piten ger bais me uburinerei. ");
INSERT INTO wnu_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","End ne an musub qoyamet igoarar. An ya uter nub qanganget qiyo, a git goant igub mi niau qamb mingoant asi igamari qen eng yara gab gegirunon qamb. Aninou git goant qas igunon eng, Qenu wonou qen eng yariner eng munon ger toar nob qib igama ubuemi toar qogom igub wot ibig yar goa gas ende sieriba. ");
INSERT INTO wnu_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Qen eng yariner eng munon ai gugum mom yariba. ");
INSERT INTO wnu_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","End ne qen gugum song ar me igoarar, qoyamet qenen Qenu simot eari annonogursi igoriner. Ende at igorunon eng qen eng yar an qubeima Munangit Wau menmant iruboumon.” ");
INSERT INTO wnu_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Qen end Yisas wo ai qaur nam Olib man igo end inab igo ne oru yar inorou munai end qob wurinob qamb igoai. ");
INSERT INTO wnu_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Munon yamangar gugum itum der qob qamara igub qamb isub igurei. ");
INSERT INTO wnu_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Qoan ir Qenu wonou enger tain qoanb wuri qubei wagerei qamb misir igub mi aib qamb at nub igour qen eng pi burerei. ");
INSERT INTO wnu_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ende gab ne munon baraitari Qenu munai qoat igour eng ne qomon qerei imbig igour eng nob Yisas qand waramb etemir end munon yurau qei Yisast oabig igour end wurit yariamirei. ");
INSERT INTO wnu_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ende abari ne Yisas wonou imbigau yurau end ger unum Yudas Iskariot qamb igour eng Satan wot diarei. ");
INSERT INTO wnu_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Diara wo Yisas duimb qamb isub munon Qenut mian yab igour gigit eng ne Qenut igau munai qoat igour eng wurit isub Yisas waramau end qob musierib isorei. ");
INSERT INTO wnu_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Is qamara wuri mismisir nomon qur taui utub qamb qamamirei. ");
INSERT INTO wnu_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Qamarari wo io qamb wogub isub wo qen ger munon yurau aib Yisas nob me igamari qen end duimb qamb qoat igoai. ");
INSERT INTO wnu_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ende at qib igama qen qau, ‘Qenu enger tonoanb me igaramau’ qamb mismisir mani parau yis ue tor nub igour eng yarerei. Qen end wai sipsip wan baab warambour. ");
INSERT INTO wnu_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ne Yisas Pita Yon nob wuriimurimb qamar: “An ombur isub qen qau end mi nun eng arsiarar.” ");
INSERT INTO wnu_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Qamara wuri qamamir: “In ombur eret isub mi arsiorun?” ");
INSERT INTO wnu_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Qamarari wo qamar: “An isub isi ginam aib end weib isub gunon eng munon ger ya egit unab ba isub igo animbegeiba. Animbag isa gab eng wo toat isi wo mor isa gab eng an nob isar. ");
INSERT INTO wnu_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Isub munai ur eng nob qamarar: “Imbigau munon nenet ete qurai munai tumbigi eret in mi arsi igo qen qau end yonou imbigau yurau eng wurinob mi nibam?” ");
INSERT INTO wnu_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ende qamarari wo munai tumbigi aib ger erer qitend nam qab bogomau eng ne mi big niau eng ereteri ar igo eng ansirbiga mi end arsi igamari nuboun.” ");
INSERT INTO wnu_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ende wurinob qamara wuri isub gamir eng Yisas wurinob qamar gas ende gab mi end arsiamirei. ");
INSERT INTO wnu_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Qen eng yara Yisas wonou wuri imbigau yurau eng nob end bugab mi numirei. ");
INSERT INTO wnu_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Mi nub igo wurinob qamar: “Ye e bugab mi aninob nib qamb qenungoum, mi nub wogub git goan uter yeneriba. ");
INSERT INTO wnu_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Bo ete qemerine igar, ye bo sabar mi me aninob ninei, isi yarab qen Qenu wonou bibis biginer qen end mi git dibenara guboumon.” ");
INSERT INTO wnu_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ende qamb Yisas qogum ger ba wain ya wari wogub Qenut uber qamb wogub wurisab qamar: “An ya e ba bais-bais niar. ");
INSERT INTO wnu_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","See ne qen geret gor wain ya me aninob ninei. Isi yarab Qenu wonou bibis biginer eng yara gab.” ");
INSERT INTO wnu_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ende qamb mani parau ba Qenut qamb boroumi wurisab qamar: “E yonou git goan, an ba niar, nub yet misir igub igoarar qamb. ");
INSERT INTO wnu_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Eng ende at ne bo wain ya qogum ten ba bo eng gas ende ebeterei. Ende at wurisab qamar: “Ya e yonou qeru isiner end maribig andoroum. Qenu wo anit igub yonou qeru aba anit igerama eng gab qoan tonoan wurit qob nausier eng boair wogub bo bubun anubersierib qamb anit iyeterei igo. ");
INSERT INTO wnu_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","End ne an gaiar, munon ye yeduimbar eng ye nob nam qab garit bugab igoun eng. ");
INSERT INTO wnu_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Qenu wonou Munangit Wau uminer qamb duiamor end. Ego munon ye yeduima yanamunor eng, munon eng borumesis.” ");
INSERT INTO wnu_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ende qamara qei der qamamir: “Wa, your qomon eng wot sieriba?” ende at qebi-qebi igurei. ");
INSERT INTO wnu_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ne Yisas wonou yurau eng der wurinomit, your ger baraitari igoriner end qamb agunub igurei. ");
INSERT INTO wnu_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ende at igamari Yisas der wurinob qamar: “Munon ai qent igour eng wurinou baraitari igama sarau borusi betet igour. Wo qob qamara taut qas ende ebet igour. Munon baraitari igama wonou yurau der wot ‘munon inubersiau tari’ ende wot qamb igour. ");
INSERT INTO wnu_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Eng an qomon ende ue. An ete abar. Munon ger baraitari gigit igo munon qei oroar igorib ebeiner eng wonou bumai wogub wau gogor gas ende burab munon qei sarau batar igoriba. ");
INSERT INTO wnu_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Your baraitari? Munon bugab mi nub igo eng qiyo a munon mani imi bear utab igo eng baraitari? Ue, munon bugab mi nub igo eng wo baraitari. Eng gas ende, see ye aninob igoum eng baraitari me igoum, an mi sigetar igoum. ");
INSERT INTO wnu_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Qoan ye ye mi warigesier eng an ye me yewogub qoau. ");
INSERT INTO wnu_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Qoan Tain wonou bibis eng ye yiimbig munon oroar igoar qamb yemaribigor gas ende ye bo bibis eng animbig an munon oroar igoarar qamb anmaribigoum. ");
INSERT INTO wnu_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Eng an yonou bibis end igo mani ya qamb nuboumon. Ende at ne an segagam baraitari igo Isrel munon yurau 12 eng qob musitar igoruboumon. ");
INSERT INTO wnu_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ende qamb Saimont qamar: “Ne igu, an yurau eng gugum Satan anqubei anwarigesi anqereimb qamb qamarei igo. ");
INSERT INTO wnu_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ego ye qo Qenu ne nonogursi qamb qebi qamamei. End ne ne Qenut mom oabig igoriban. Igoi bo igeser yar banamori wuri nonogursieriban.” ");
INSERT INTO wnu_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ende qamara Pita taui qamar: “Barai, ye ne nonob uyort isub ombur umun qamb ar erer igoum e.” ");
INSERT INTO wnu_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ne Yisas nob qamar: “Pita, git uber ye nob quran, ego teteri se me erinerei igama qen ombur gari yet ‘munon eng ye sir ue’ ende qamara teteri qamar eriba.” ");
INSERT INTO wnu_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yisas Pita sir ende nob qamb wogub ne garisi wuri nob qamar: “Qoan ye saraut munon ginam-ginam iuar qamb animuriam eng an nomon qur ger me baiau ne abau ger ue, ne goten yau ue. Ne mi gugum ue ar qib igoumon qen end mi ue gab qoot asi abatamanei?” Ende qamara wuri qamamir: “Ue.” ");
INSERT INTO wnu_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ende qamarari Yisas qamar: “End ne see munon nomon qur igama gab qiyo abau igama gab eng bainer. Ne munon ger bui qauri ue gab eng wonou mingoan eng wurisab taui qur ba bui qauri ger bainer. ");
INSERT INTO wnu_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Qanam eng, Qenu qob gumatemirei igo ‘munon boru wurinob garisi warambour.’ Ende igo end ne qeemben ende yesiorubour. Qenu qob gugum ye yesiorunor end qamb gumatemir eng ye me ye bisinerei.” ");
INSERT INTO wnu_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ende qamara wonou imbigau yurau eng qamamir: “Barai, e ge in bui qauri ombur-ombur igo e.” Ne wo qamar: “Eng mom quraun eng.” ");
INSERT INTO wnu_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ende qamb wogub qenen at igo gas ende, der isa wonou yurau qanam toat isi ai qaur nam Olib man aib igo end isumirei. ");
INSERT INTO wnu_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ginamt weib isub wurinob qamar: “Qenu nob qamb igorunon eng an mi warigesia wot me uburab isunanei.” ");
INSERT INTO wnu_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ende wurinob qamb wogub wuri igamari wonou wes opur isub gamaur wat bugab Qenu nob qamar: ");
INSERT INTO wnu_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Tain a, yet igub gab eng qugurau e yet yaribar eng toat arirom. Eng ye ar net quraum, nonou qas.” ");
INSERT INTO wnu_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ende qamara Qenu ginamt enger ger der nonogursiarei. ");
INSERT INTO wnu_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yisas sig-sig mom quguraget wogub Qenu sabar-sabar nob qamb igama git goan gugum qoaru qeru di darau nami ende ebeterei. ");
INSERT INTO wnu_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ne der naget wonou yurau isub ibagar eng wuri git goan bibinat wogub qoan naat inemirei. ");
INSERT INTO wnu_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ende ibag wurinob qamar: “An der bugab Qenu nob qamb me ubunanei i-i? Mi anwarigesiau ger anit dieriner qamb quraum.” ");
INSERT INTO wnu_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ende qamb igama munon yurau aib diamirei. Yisas wonou imbigau yurau end ger unum Yudas wo iuar eng isub munon yurau wurinerub ba diarei. Diab Yisas qani irab baab wuriimbigib ebeterei. ");
INSERT INTO wnu_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Aba Yisas nob qamar: “Yudas, ne Munangit Wau munon qarau wurit imbigib aban ne?” ");
INSERT INTO wnu_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ende qamara wonou yurau nob igour eng der Yisas waramb diamir eng imbig ne nob qamamir: “Barai, in bui qaurit wuri gumarun qiyo.” ");
INSERT INTO wnu_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ende qamb ne munon ger bui qauri beneri Qenut mian yab igour wurinou baraitari wonou sarau munon ger iruges uberegent wes eng soabur ariramorei. ");
INSERT INTO wnu_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ende aba Yisas gab qamar: “An qomon eng wagar,” qamb munon iruges soabur ariramir eng ba bo big bea qoan wonou igoa gas ende uberetarei. ");
INSERT INTO wnu_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ende at ne Qenu mian iset bigetet igour wurinou baraitari eng ne inorou munai qoat igour eng ne munon baraitari qei Yisas booub qamb diamir eng wurinob qamar: “An bui qauri ba qombuni ba mai munon igeig nob yogurub ende at diaumon? ");
INSERT INTO wnu_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ye qenen inorou munait erogori igoun eng an ger yanamb ende abari me animbegeau. Itum qen eng munon qomon boru oboub qamb eng me qubigunorei. End ne see qen eng yara gab yanamb diaumon.” ");
INSERT INTO wnu_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ende qamb waga baab mot Qenut mian yab igour wurinou gigit wonou munai end isumirei. Isari Pita qanam mugenderi toat ibag-ibag isub igoai. ");
INSERT INTO wnu_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Qob musub igour munai mor igama youn man end mut gumet qoariget igamari Pita isub ibag wurinob mut qoariget igurei. ");
INSERT INTO wnu_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Pita ende bugab igama sarau yamangar ger qib garei. Gab bo nan gab nob qamar: “Wa, munon qira munon e nob yorour eng qoat igo qii?” ");
INSERT INTO wnu_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ende qamara Pita qand der mirimot qamar: “Munon eng ye sir ue.” ");
INSERT INTO wnu_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ende qamb igo bais umi-umi ende at bo munon ger qib gab nob qamar: “Ne gor munon e nob yorour eng wonou yurau.” Ende qamara Pita qamar: “Ue e.” ");
INSERT INTO wnu_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ende qamb wogub igamari qen dirigor bais ete umi wogub munon ger gab gagam mom qamat qamar: “Segagam eng Galili munon Yisas nob igama gaun eng gari.” ");
INSERT INTO wnu_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ende qamara Pita nogom gumotopurma qamar: “Wa, ne qob eng at quran eng ye sir me imbigoum.” Ende qamara teteri qamar arei. ");
INSERT INTO wnu_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Qen end Yisas mor ito igo igeser asi Pita sir garei. Gea Pita wo gab misir igorei. Qoan Yisas ete nob qamar end: “Teteri me erinerei igama ne qen ombur gari ende yet ‘munon eng wot quraumon eng ye sir ue,’ ende yet qamara teteri qamar eriba.” ");
INSERT INTO wnu_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ende nob qamar end, qen end Pita misir igub igeser ag isub borusi eerei. ");
INSERT INTO wnu_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Munon Yisas mot yaremir eng Yisas ber qob wot qamb wot igerig igurei. ");
INSERT INTO wnu_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ne qei der mingoant mag taisi touri wogub waramb wogub bo beasimetet nob qamamir: “Your nanamai qi eng sir gumat qamara gun.” ");
INSERT INTO wnu_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ende qamb qiyo, ne qomon boru-boru qei wot ebet sumungasi ende at igurei. ");
INSERT INTO wnu_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","67","At igamari uriger worom diara ne Yuda munon baraitari eng ne, Qenut mian yab igour wurinou gigit eng ne qomon qerei igour eng qiumuni Yisas mot isub wurinou baraitari qob musitoub qamb qiumuni igour wobon end bis nagsiari qebi qamamir: “Ne mai, munon wurimusiau tari qiyo?” Qamarari wo qamar: “Ye aninob qemerine yet me oabigunanei. ");
INSERT INTO wnu_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ne ye an qebi qemerine gor musub taui me ye nob qomurunanei. ");
INSERT INTO wnu_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Eng gab see ne qen gugum Munangit Wau Qenu uberegent end bugab mom du qamb wegiba.” ");
INSERT INTO wnu_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ende qamara gugum der qamamir: “Ie, ne apand Qenu wau?” Ne wo taui qamar: “An see quraumon eng, ye eng gari.” ");
INSERT INTO wnu_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ende qamara wuri qamamir: “Mai munon geret igub ebein, wonou qabarit qamara in gugum mom diban igoun eng.” Ende qamamirei. ");
INSERT INTO wnu_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ende qamara ne gugum der Yisas mot Rom gabman munon tarinob Pailat wot isumirei. ");
INSERT INTO wnu_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Isub qanambig qamamir: “Munon e in mot yoroun eng qanam eng ete, in munon yamangar gugum wuri ba songesi ete qamb igo: “An Sisar nomon qur utab igoumon eng wagar qamb qiyo a wonomit Qenu munon wuriubersierib qamb imurima derer eng ye gari, ye baraitari” ende at qamb igo end nob yoroun.” ");
INSERT INTO wnu_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ende qamarari Pailat Yisas qebi qamar: “Ie, ne Yuda wurinou baraitari gigit qiyo?” Ne Yisas taui qamar: “Nonou gari quran eng”. ");
INSERT INTO wnu_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ende qamara Pailat der Qenut mian yab igour wurinou baraitari eng nob munon yurau wurinob garisi qamar: “Munon e ye gaum eng qomon boru ger me abau.” ");
INSERT INTO wnu_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ende qamara wuri der nob agunub qamamir: “Ende mai, qoan Galili munon wurinob qamb a Yuda munon wurinob qamb is isi yar e bo yar qurar eng meimi?” ");
INSERT INTO wnu_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ende at qamarari igub Pailat wuri qebi qamar: “Munon e mai Galili munon qiyo?” ");
INSERT INTO wnu_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ende qamara qamarari igub wogub mom imbigorei. “Io munon eng Herot wonou yurau” ende qamb imurima Herot isorei. Qen end Herot wo Yerusalem eng igoar end. ");
INSERT INTO wnu_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herot Yisas isa gab borusi uberetarei. Yisast qob suari igub gib qamb at igoar end. Ne bo Yisas mi wes ger aba gib qamb ");
INSERT INTO wnu_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","End ne Herot mi irou Yisas qebiamorei. Ego Yisas qob ger taui me qamarau. ");
INSERT INTO wnu_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ende aba gab Qenut mian yab igour baraitari eng ne qomon imbig igour eng bo ir-ir naget Yisas qomon boru-boru ebet qib igo qamb meten wot qamamirei. ");
INSERT INTO wnu_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ende at ne Herot wonou yogorau yurau eng nob der qob song-song wot qamb ber qob wot qamamirei. Qamb ne bo mingoan qenenginob sig uber ger ba qumanimetet wogub bo imurimari Pailat qani isorei. ");
INSERT INTO wnu_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Qoan Herot Pailat nob qarau igurei isi yarab qen end qas qibanamsiamirei. ");
INSERT INTO wnu_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ende at ne Pailat munon Qenut mian yamau baraitari eng ne munon baraitari qei ne munon yamangar ar ende wurit qamara yarari wurinob qamar: ");
INSERT INTO wnu_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","“An munon e mot yet yarab quraumon eng: Munon e qomon soagensi munon wurinob qamb qib igo qamb qob musitoub quraumon eng. Ye aninou magqurt qebi nob quraum eng, wo qomon boru ger ebet igo qamara me igoum. ");
INSERT INTO wnu_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herot qebimar eng ue gab bo init imurima yarar eng gor. End ne in ar waramun eng uber ue eng gab quraum. ");
INSERT INTO wnu_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","End ne ye ar pisirami qas waramb wogub anit imurimine isiba,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Togun gugum Qenu enger tain qoanb wuri qubei wagerei qamb mi at nub ne Pailat munon uyort igour eng ger wurit imurima isub igo. ");
INSERT INTO wnu_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pailat ende qamara munon yurau eng gugum der amir: “Waramari uma ne in Barabas qas init imurimari yariner.” ");
INSERT INTO wnu_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabas wo uyort bigumir eng wo gabman nob agunub a munon qei igarama umari gab ba bigumirei. ");
INSERT INTO wnu_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ende qamarari Pailat Yisas ar wogub imurimine wurit isiner qamb bo sabar wurinob qamarei. ");
INSERT INTO wnu_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Qamar ego wuri der nob agunub amir: “Nam erer qas big waramar, nam erer qas big waramar.” ");
INSERT INTO wnu_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ende qamarari Pailat bo qen ombur garit wurinob qamar: “Meimet qamb munon e qomon boru ger ebeterei? Ye gaum eng waramau werei ende ger me gaum. Ende ne aninou waramb qamb ibitiriaumon end ye ar pisiramit qas waramb wogub ar anit imurimine isiba.” ");
INSERT INTO wnu_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ende qamara wuri mom warama umb qas weginer qamb ibitiriamirei. Ende at Pailat qob ba songesi wagari wagerei. ");
INSERT INTO wnu_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Wogub wurinou qob qamamir eng toat wurit wagerei. ");
INSERT INTO wnu_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Wogub ne munon ger gabman nob agunub a munon igaramb at qib igama uyort bigumir eng bo ar wurit waga isorei. Ne Yisas um qamb mom ibitiriari ibag imurima yogorau munon wurit isorei. ");
INSERT INTO wnu_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Yisas wurit isa mot isub qataben gamir eng Sairini munon ger unum Saimon. Wo diab ginam aib eng isib at igoai. Ende gab ne Yisas nam togoramor eng nob bai qamb end qamat qamarari wo bo ba Yisas toat isorei. ");
INSERT INTO wnu_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Isari munon yamangar irou toat isub igo yamangar irou eab-eab uru wab ende at qanam isub igurei. ");
INSERT INTO wnu_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ende at isub igamari Yisas igeser wurinob qamar: “An Yerusalem yamangar, an yet me eaiar. An aninomit eab ne aninou wau end wurit eaiar. ");
INSERT INTO wnu_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Qen ger gab anit ete qomorubour: yamangar wau me baunerei, a wau me baiau, ne wau inau me wurisinerei, yamangar eng wuri mismisirubour. ");
INSERT INTO wnu_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Qen end munon qei der ai qaur aib-aib end wurit qomorubour: ‘duret in umimar.’ Ne gor ai qaur qamaaman end wurit qomorubour: ‘duret iningaramar.’ ");
INSERT INTO wnu_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Eng gaiar, wuri ye nam igom gas ende igimine yesiaur eng Yuda munon wuri nam umau gas ende igamari sig mom wuriquguragsiorubour.” Yisas ende wurinob qamarei. ");
INSERT INTO wnu_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Qen end munon ombur qomon boru at qib igour eng nob isub Yisas nob igaramb qamb. ");
INSERT INTO wnu_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ende oromar isub isi ai qauren ger ‘tari qer’ qamb igour end isub ne Yisas nam tenori big waramb ne munon ombur eng, ger uberegent wes end big waramb ne ger uben qagit end big waramb ende ebetemirei. ");
INSERT INTO wnu_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yisas nam erer end igo qamar: “Tain, munon e yesiaur eng wuri qanam sir me imbig ne yesiaur, ne taui me wuri sumungasi.” Ende qamara wuri der Yisas mingoan wot baub qamb ne sauab your wotanami mingoan eng bainer qamb ebetemirei. ");
INSERT INTO wnu_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ende abari munon qei qoat naget igo ne Yuda munon baraitari eng der Yisas ber qob wot qamamir: “Munon qei wuri musub qib igoar eng wagari wonomi musia gune. ‘Ye Krais, Qenu munon gugum wurimusi qamb yemaribigorei’ qamb qib igoar end.” ");
INSERT INTO wnu_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ende qamarari yogorau munon wuri gor der ber qob wot qamamir: ");
INSERT INTO wnu_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“Ne Yuda wurinou baraitari igo gab eng nonomi musub der ge?” Ende wot qamb igurei. ");
INSERT INTO wnu_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Yisas big waramirt erer end qob ger ete qamb gumat bigumirei: MUNON E YUDA WURINOU BARAITARI, ende qamb gumatemirei. ");
INSERT INTO wnu_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Munon boru ombur wuri big waramir eng ger igo Yisast ber qob wot qamar: “Ne munon wuri musiau tari, end ne nonomi ubersi ne in ombur in musi.” ");
INSERT INTO wnu_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","41","Ende qamara munon ger igo qamat qamar: “Ne Qenut misir me igan? In gugum ininou qomon boru ebet igoun end taui qamb qeemben inquguragsiaur. Ego wo ende ue wonou ar meten siaur end uber ue.” ");
INSERT INTO wnu_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ende qamb Yisas nob qamar: “Yisas, ne mom baraitari burab nonou bibis end isub gab eng yet misir igu.” ");
INSERT INTO wnu_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ende qamara Yisas der taui qamar: “Apand nonob quraum, see qas in ombur ginam uberar end igoruboun.” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Qen end worom ginam tog yarab ne ai gugum iturama worom mag bo me geau. Ende igama igoi isii worom bo qumat dara ne mingoan gurum aib inorou munai tend opur uriamir eng metut qitend quburab isii waseramorei. ");
INSERT INTO wnu_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ende aba gab igamari Yisas qugiab qamb ar: “Tain, yonou moui uber ne bai.” Ende qamb ab wogub umorei. ");
INSERT INTO wnu_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Yogorau munon baraitari eng mi eng ende aba gab wogub Qenut oabig qamar: “Segagam, munon e munon qoregen uber,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Munon gugum qoui naget qoat igour eng mi eng ende aba gab qumor-qumor isumirei. ");
INSERT INTO wnu_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ne Yisas wonou munon banam ne yamangar qei Yisas mot yarari ginam Galili wogub yaremir eng mugenderi nami ende naget igo mi eng aba gab igurei. ");
INSERT INTO wnu_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Qen end Yuda munon ger unum Yosep. Wonou ginam qenen eng Arimatea. Wo munon qoregen uber. Ne gor, wo Yuda munon baraitari qob musitarub qamb qiumuni igour eng wurinou erogori. ");
INSERT INTO wnu_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Wo igo baraitari qei Yisast qob qamb nausi ebetemir eng wo io me qamarau. Wo qoan Qenu wonou bibis bigor eng ba dibesierib qamar eng qoat igoai. ");
INSERT INTO wnu_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Munon eng wo Yisas uma wogub mumun bis tumunimb qamb is Pailat qebi garei. ");
INSERT INTO wnu_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Qebi gea io qamara isub mumun erer igoar eng bo ag big ne mingoan oan nob end ouri wogub bisub tumuniamorei. Tumun eng qoan nomon erobon goanetemirei. Munon ger me tumunimau, bubun igoai. ");
INSERT INTO wnu_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Qen eng Fraide, barim eng inorou qen end gitab ibeibi igorub etemir eng pisiarei. ");
INSERT INTO wnu_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Galili yamangar Yisas nob yarari toat yaremir eng Yosep Yisas mumun bis tumunimb isa nob isumirei. Isub maigas at tumunieminer eng musub gab imbigub qamb. ");
INSERT INTO wnu_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ende gab wogub ginamt irab maurem ya qamb mi eng gagar arsi igo Yisas git goan bieriner qamb qositoub qamb. Ne inorou qen eng wurinou qomon igo end gitab ar ibeibi igurei. ");
INSERT INTO wnu_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Inemirei igo itum der inorou qen pura ne yamangar welya qamb barim urigom arsi bigumir eng ba munon teteret end isamirei. ");
INSERT INTO wnu_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Isab gamir eng nomon aib ger ba yar tumun qipiatemir eng bo ende me igamau. Tumun unat igama gamirei. ");
INSERT INTO wnu_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Gab isab erobon isub gamir eng Munon barai Yisas git goan me igamau. ");
INSERT INTO wnu_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ende gab qanganget wogub naget igamari qand munon ombur mingoan oan qenengi nob nagetemirei igo wuri qani end naget igurei. ");
INSERT INTO wnu_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ende ibag yari wogub qumoramirei. Qumoramari munon ombur eng wuri nob qamamir: “An meimet qamb munon igomot der bogomar e gub qamb munon teteret e asi qib igoumon? ");
INSERT INTO wnu_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Wo e me igo, der bogomai. Qoan Galili ite igo aninob qamar eng misir igar. ");
INSERT INTO wnu_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Wo ete qamarei: “Munangit wau munon boru wurit duimari ba nam tenori big waramari umiba. Uma ba tumunimunorei igama qem ombur gari ubura bo der bugemba.” ");
INSERT INTO wnu_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","9","Ende qamarari yamangar eng qob eng misir igub wogub bo igeser tumun wogub isub mi eng gabriamir eng Yisas wonou imbigau yurau 11-ende igour eng wurinob qamb ne munon ar qei gor wurinob qamarari igumirei. ");
INSERT INTO wnu_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Yamangar eng isub qamamir eng Maria Makdala ne Yoana ne Maria ger Yems unor eng ne yamangar qei wurinob igo qob eng Yisas wonou yurau eng wurinob qamamirei. ");
INSERT INTO wnu_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Qamarari Yisas yurau eng der yamangar eng ar wob mugenderi igub qamb qib igour qamb qob me igatarau. ");
INSERT INTO wnu_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ende abari Pita der uyab-uyab munon teteret ite bo irarei. Irab inumor tumun erobon asi mingoan qas garei, mi ger me geau. Ende gab bo igeser isub misir qebebi igub igoai. ");
INSERT INTO wnu_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Qen end gari Yisas yurau eng ombur der munai ginam Emeus eng isub qamb tap toat isub igurei. Ginam eng ginam aib Yerusalem wogub isau eng pi. ");
INSERT INTO wnu_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ombur isub igo mi eng gagar ebeter end qamb isub igurei. ");
INSERT INTO wnu_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ende qamb isub igamari Yisas wonou yar wobon end naget wurinob isub igoai. ");
INSERT INTO wnu_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Isub igama gamir eng wuri mi mag opuramau gas ende aba Yisas wo sir me imbigau. ");
INSERT INTO wnu_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ne Yisas der wurinob qamar: “An ombur meimet qamb qobub isub igoumon?” Ende qamara ombur mi toubet qi naget igurei. ");
INSERT INTO wnu_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ende at igo ne ger unum Kliopas der qebi qamar: “Munon irou Yerusalem igour eng mi barim urigom ebeter eng gugum qoyam. Ne gari qoyam ue igo qamb qib igoan?” ");
INSERT INTO wnu_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ende qamara Yisas qebi qamar: “Mi maigas abai?” Ne wo bo qamar: “Nasaret munon Yisas tumuniamir eng abar end qamb igoun. Wo Qenu wonou qob gigit qamarau munon. Wo Qenu sarau qeretut nob baab ne qob qeretut nob munon yamangar wuri nob qamb qib igoai. ");
INSERT INTO wnu_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ende at qib igama ininou munon barai tari Qenut mian yab igour eng ne qomon qoat igour eng wuri der gabmant duiamirei. Duimari wuri qob qamb nausi ne uminer qamb nam tenori big waramari umorei. ");
INSERT INTO wnu_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Eng wo Isrel munon wuriubersierib qamb dererei ende qamb misir iguminei. Ne mi eng gagar abar eng qen ombur gari uburerei. ");
INSERT INTO wnu_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ne gor ininou yamangar qei itumut inqeisiau gas ende uburei. ");
INSERT INTO wnu_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Wuri munon teteret irab tumun erobon isub gaur eng wo git goan igama me geau. Ende gab abari enger der wuri nob qurar eng, igomot der bogomai qurar eng gugum qamarari igunei. ");
INSERT INTO wnu_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Igub ininou munon bo mi eng gub qamb irab gaur eng yamangar ininob quraur gas ende, Yisas git goan me geau.” ");
INSERT INTO wnu_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ende qamarari Yisas wurinob qamar: “An qoan Qenu qob gigit qamara munon gumatemir eng misir ue igo oau segagam me buroumon? ");
INSERT INTO wnu_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Munon wuriubersiau tari eng wo umb wogub bo igomot der bugama Qenu wonou aba baraitari igoriba.” ");
INSERT INTO wnu_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ende qamb ne qoan qanambig Moses qob gumater end qanambig qob suab bisii Qenu qamara munon gumatemir end bis beneriamorei. ");
INSERT INTO wnu_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","29","Ne wuri isi munai ginam isub qamb isumir eng pisiari ne Yisas wo wuriwogub tumbigi isib qamb ater ego wuri duet qamamir: “Worom mom isar eng ai itumoramba. In nob et iniban.” Ende qamarari wurinob mor isorei. ");
INSERT INTO wnu_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Isub nam qabt erogori bugab mani parau ba Qenut qamb nonogursi boat wuriserei. ");
INSERT INTO wnu_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Qen end Yisas mom gab imbig ebetemir ego wuri magqurt umanger qi qorei. ");
INSERT INTO wnu_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Qoa me gab wurinou qob-qob qamamir: “Qataben yar igo qob eng ininob qamara igoun eng igub in oau mom ipirai.” ende qamamirei. ");
INSERT INTO wnu_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ende me gab wogub bo qand yonam Yerusalem qite wonou imbigau yurau 11-ende igour end irab ibagamir eng banamori qei wurinob qiumuni igurei. ");
INSERT INTO wnu_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ende ibegeari der ombur wurinob qamamir: “Munon Barai segagam igomot der bugab qib igama Saimon garei.” ");
INSERT INTO wnu_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ende qamarari ombur wuri gor der qataben isub igo qob wuri nob qamb isub igoar eng ne, mor isub mani parau boat wurisa qen end gab imbigari iuar eng gugum qamamirei. ");
INSERT INTO wnu_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Qob eng ende suab igamari Yisas wonou diab wuri wobon et igo wurinob qamar: “Oau mein burab igoarar.” ");
INSERT INTO wnu_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ende qamara wuri mai moui qiyo aibigau qamb borusi yariamirei. ");
INSERT INTO wnu_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ende abari wurinob qamar: “An meimet qamb qiet misir qebebi igub igoumon? ");
INSERT INTO wnu_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","An ye uben qamb nebit qamb gaiar. Ye yonou gari. An yebaab gaiar, moui mai min qer nob ende igo?” ");
INSERT INTO wnu_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ende qamb ne uben goten nob wurisirbigorei. ");
INSERT INTO wnu_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ende aba wuri mismisiramir ego sig oau apand me burau. Ende at igamari wurinob qamar: “An mi niau ger et igo?” ");
INSERT INTO wnu_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ende qamara yag wai qibi ger utemirei. ");
INSERT INTO wnu_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Utari boroumi wuri magqurt norei. ");
INSERT INTO wnu_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ende at ne wurinob qamar: “Qoan aninob qib igo ne qob aninob qamam eng see mom gaumon eng. Qoan ir Moses qomon yet qamb gumater eng ne Qenu qob qamara gumatemir eng ne Sam qob yet qamb gumatemir eng gugum irimani ubura gaumon eng. ");
INSERT INTO wnu_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Yisas ende qamb ne wo wurisiara misir uber igub qob qoan gumatemir eng mom musub imbigumirei. ");
INSERT INTO wnu_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ende abari wurinob qamar: “Qob ete qamb gumatemir eng: Munon wurimusiau tari eng wo git goan uter weriba. Ende ebet wo uma tumunimunorei igama qen ombur gari ubura bo iigomot der bugemba. ");
INSERT INTO wnu_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ende aba qanambig Yerusalem end wo unumot qamb qiroari munon ai qent gugum wot oabig ne wurinou qomon boru mogirt warari Qenu wuriubersia wonou yurau igorubour. ");
INSERT INTO wnu_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","An ye yegaman end gigit qob suouboumon. ");
INSERT INTO wnu_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ende abari Tain qoan anit mi iyeter eng ye anit imurimbam. End ne an mom ginam aib end mom qoat igamari mi eng anit der an nonogursieriba.” ");
INSERT INTO wnu_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ende qamb ne ginam aib eng wogub oromar isi Betani end isumirei. Isub uben bemeni wuri nonogursiarei. ");
INSERT INTO wnu_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ende wuri nonogursi wogub iser Qenu mot erer irarei. ");
INSERT INTO wnu_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Iroa wogub uru wab wot mismisir bo yonam Yerusalem yaremirei. ");
INSERT INTO wnu_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Yar end igo qenen inorou munai aib end isub Qenut igub igurei. ");
INSERT INTO wnu_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Qoan ir qob igoai. Qob eng Qenu nob igoai. Qob eng wo gor Qenu gas ende. ");
INSERT INTO wnu_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Qoan ir Qenu mi ger me barsiau qen end qob eng Qenu nob igoai. ");
INSERT INTO wnu_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Qobt Qenu mi gugum barsiarei. Mi gugum ai qorut me derau. ");
INSERT INTO wnu_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Igom igamau eng wot igoai. Igom eng begent munon wurit isorei. ");
INSERT INTO wnu_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Begen eng itum omboarir igo, ne itum wo begen eng me muasereminerei. ");
INSERT INTO wnu_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Qenu qob biga munon ger gim isub bo qen eng yariner end munon yamangar wurinob qem qamb imuriamor eng unum Yon. Ende imurimine isub munon wuri nob qamara igub begen end oabigar qamb. ");
INSERT INTO wnu_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yon, wo begen eng ue. Wo ar begen eng deriner end qob suab wuri imbig qib igoai. ");
INSERT INTO wnu_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Begen eng apand begent munon gugum wurit arir igo, eng ag e dara. ");
INSERT INTO wnu_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Qob eng ag e der igoai. Igama Qenu ai wot barsier eng munon gugum wuri wo qoyam ue. ");
INSERT INTO wnu_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Wo wonou ginam qenen isuor eng wonou yurau magqurt gab wugumirei. ");
INSERT INTO wnu_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ende abari munon qei wot oabig ba moriamir eng Qenu wonou wagrari buror qamb wurimaribigorei. ");
INSERT INTO wnu_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Wuri Qenu yonou wau wurit qurar eng ur unor tumbigi end ue, ne wurinou qenungau end gor ue. Qenu wonou gari wurinonogursi igo end wonou wau tetemi. ");
INSERT INTO wnu_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Qob eng munangit warub inamar igoai. In wonou oau mein eng wonou wes ar eng wot igama gaminei. Wonomi wes ar eng Tain wonou wau gari qas imurima derer end oau mein ne qomon apand eng wot yab di igoai. ");
INSERT INTO wnu_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ne Yon wot qamb qamar: “Ye munon end wot qamb ete qamam eng: ‘wo qanamt yariner eng ye sarau oboum eng yetanamimba eng wo ye ue igimine wo igoar eng.’ “ ");
INSERT INTO wnu_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","17","In wonomi uber eng init yab di qoa ne wo in gugum inubersi igo. Eng Qenu qoan qomon init bigor eng Moses imbiga gumaterei. A oau qiutab ne qomon apand eng munon inubersiau tari Yisas eng ba darab inimbigorei. ");
INSERT INTO wnu_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Munon ger Qenu bais me geau. Wonou wau gari qas, wo qenen ur nob igo end wo ag e darab in Qenu inimbigorei. ");
INSERT INTO wnu_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Qanam end Yon munon wurimaragansi ya obotar ende at qib igama ne Yuda munon baraitari ginam aib Yerusalem igour eng wuri der Qenut mian iset big igour munon qei ne Libai yurau qei (Libai wurinou sarau eng munon inorou munai aib eng qoat igour eng wurit sarau baab igour) wuriimurimari Yont yar qamamir: “Ne your?” ");
INSERT INTO wnu_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ende qamarari Yon me wabimau, dibes wuri nob qamar: “Ye munon an ubersiau tari eng ue.” ");
INSERT INTO wnu_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ende qamara wuri qebi qamamir: “End ne ne your? Ne mai Elaiya qiyo?” Qamarari wo qamar: “Ye eng ue.” Qamara wuri qamamir: “Ende gab eng ne mai munon Qenu qob gigit qamarau munon eng ne?” End qamarari wo qamar: “Eng gor ue,” qamar. ");
INSERT INTO wnu_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Qamara wuri qamamir: “Ende gab eng dibes ininob qem. Qamara in musub mom niimbig wogub irab munon inimuriamir eng wuri nob qumurune igubour.” ");
INSERT INTO wnu_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ende qamarari Yon qamar: Ye munon ger seger ait igo ab igoar eng ye. Munon Baraitari der isiba, ai tap ingong-ingong eng ne ai qauren-qauren eng wot musitat. Qoan Qenu wonou qob gigit qamarau munon Aisaia qamb gumater gas ende. ");
INSERT INTO wnu_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","Ende qamara wogub ne munon qei Parisi yurau wuriimurimari yaremir eng bo der Yon nob qamamir: “Ende gab eng ne, mai munon inubersiau tari eng qiyo, a Elaiya qiyo, a Qenu qob gigit qamarau munon eng qiyo, ne eng ue gab eng ne meimet qamb munon ya obotar wurimaragansi qib igoan?” ");
INSERT INTO wnu_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ende qamarari Yon taui qamar: “Ye ar ya asint wurimaragansi qib igoum; a munon ger dererei aninob igama an wo me imbigoumon eng. ");
INSERT INTO wnu_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Wo ye qanam yar igo, eng ye wonou goten yau eng maigas me nerimitinei, ye qob qinan,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Mi eng ebetemir eng ya Yordan wes end munai ginam Betani end. Ginam end Yon munon yat wurimaragansi igoai. ");
INSERT INTO wnu_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Barim ende der Yisas Yont isub igama gab qamar: “Gaiar, Qenu wonou sipsip wan yeim yar igo ite. Wo munon gugum ai qent e qomon borut igour eng wab ariramatariba. ");
INSERT INTO wnu_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Munon end ye wot qamb igoum eng. Ete qamam eng: munon ger ye qanamt yariner eng wo yetanamimba. Ye ue igimine wo qoan ir igoai. ");
INSERT INTO wnu_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ye wo sir ue, ego ye munon ende yat wurimaragansi ne munon eng Isrel munon wuriimbigine gaiar qamb.” ");
INSERT INTO wnu_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ende qamb qamar: “Ye Qenu wonou Igomurur qau gam eng morogan gas ende Qenu ginam end igo der wo tarit end igoai. ");
INSERT INTO wnu_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Qen end gor ye wo me imbigau. Ende ebet igimine Qenu munon yat wurimaragansi qamb yiimuriamor eng yiimbig qamar: ‘Munon ger yat maragansi igama Igomurur qau der wot igama gab eng qem, qo, munon e munon ya Igomurur qau ten wuri maragansieriba.’ “ ");
INSERT INTO wnu_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Qamb qamar: “End ne ye qo gab wogub wot Qenu wonou wau ten ende aninob qamam eng,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ne barim ende der Yon wonou imbigau munon ombur wuri nob end igoai. ");
INSERT INTO wnu_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ende igamari Yisas wurit isub igoai. Isub igama gab qamar: “Gaiar, Qenu wonou sipsip wan yeim yar igo qita.” ");
INSERT INTO wnu_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ende qamara munon ombur eng igub Yon wogub Yisas nob isumirei. ");
INSERT INTO wnu_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ende toat isub igamari igeser ibag wuri qebi qamar: “An meimi gub qamb asi qib igoumon?” Ende qamara ombur qamamir: “Barai, ne eret igoan?” ");
INSERT INTO wnu_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Qamarari wo qamar: “Yarab gaiar.” Ende qamara wo nob isub munai igoar eng gab nob end igurei. Qen end worom nerimb pisier end. ");
INSERT INTO wnu_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Munon ombur eng Yon qamara igub Yisas nob isumir eng ger unum Andru wo Saimon Pita wonou umour. ");
INSERT INTO wnu_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Qen end qas Andru umom Saimon gab nob qamar: “In munon inubersiau tari eng gunei.” ");
INSERT INTO wnu_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ende qamb Saimon mot Yisast isorei. Isa Yisas Saimon gab qamar: “Ne Saimon, Yon wonou wau. Ne unum bo Sipas ende bigoum.” (Unum Sipas eng Yuda wurinou qob, Grik qobt Pita, unum ombur qanam eng nomon). ");
INSERT INTO wnu_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ne bo barim ende der Yisas ai Galili isib at igo munon ger unum Pilip gab nob qamar: “Yara ye nob qib igorun.” ");
INSERT INTO wnu_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilip wonou ginam qenen eng Betsaida. Andru Pita nob wurinou ginam erogori. ");
INSERT INTO wnu_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pilip bo isub Nataniel gab qamar: “In munon qoan deriba qamarari Moses qoan qomon qob qamb gumater eng. Ne gor Qenu qob gigit qamarau munon wot qamb gumatemir eng gaun. Wo Nasaret munon Yosep eng wonou wau.” ");
INSERT INTO wnu_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ende qamara Nataniel qamar: “Mai, meimi uber ger Nasaret end dieriba?” Ende qamara Pilip qamar: “Ende yar ge?” qamar. ");
INSERT INTO wnu_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Nataniel Yisast yara gab wot qamar: “Gaiar, munon e Isrel munon apand, qob qetopur qamarau eng wot me igo.” ");
INSERT INTO wnu_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ende qamara Nataniel qebi qamar: “Ne maigas yiimbigan?” Ende qamara Yisas taui qamar: “Pilip net me arau igama nam qanamt end bugab igama negumei.” ");
INSERT INTO wnu_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ne Nataniel taui qamar: “Ne apand Qenu wau, ne gor ne Isrel wurinou baraitari gari.” ");
INSERT INTO wnu_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ende qamara Yisas qamar: “Eng ar ye nam qaragas erobon end naget igama negumei qemerine yet oabig quran. End ne qen geret mi sig aib ne se e gan eng wotanami giban.” ");
INSERT INTO wnu_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ende nob qamb wogub gugum wuri nob qamar: “Segagam aninob quraum, qen geret Qenu ginam end asi gunon eng miroau gas ende aba Qenu enger eng Munangit wau end darab ir darab ir ende at igamari ibogouboumon,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Qen ombur ubura ne ai Galili ginam Kana end munon ger yamangar nob qi baub qamb etemirei. Qen end Yisas unor end igoai. ");
INSERT INTO wnu_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","End ne Yisas wonou imbigau yurau eng nob isar qamb gim ibegeari isumirei. ");
INSERT INTO wnu_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Qen end mi aib at nub wain ya gor nub igamari uburerei. Ende gab Yisas unor der nob qamar: “Wain ya mom nub ugaur.” ");
INSERT INTO wnu_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ende qamara Yisas taui qamar: “Ye meimi ebeibine ye nob quran? Ye qen se.” ");
INSERT INTO wnu_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ende nob qamara unor wogub sarau eng baab igour eng wuri nob qamar: “An et igorunon eng mi ger abar qamb anit qamara gab eng qob toat mi qurar eng abar,” qamar. ");
INSERT INTO wnu_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Qen end Yuda wurinou qomon eng toat ya unab ba di big igo mor isub qamb goten uben birogoni isub igour eng. Egi aib-aib 6-ende igoai. Egi end ya garan aib degen-degent unab igoun gas end igoai. ");
INSERT INTO wnu_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","End ne Yisas sarau munon eng wuri nob qamara: “Egi end ya unar,” ende qamara unari dieramorei. ");
INSERT INTO wnu_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Dierama ba diarari wuri nob qamar: “Ya qei waari bis munon mani qoat igo eng utar.” Ende qamara waari bis utemirei. ");
INSERT INTO wnu_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Bisub utari warigesi nub gar eng qer uber, wain ya warorei. Ende gab wain ya eng eret baumirei qi eng wo sir ue. Munon ya asin waari bis utemir eng wuri sir. Ende gab munon yamangar se bauor eng wot ara yara, ");
INSERT INTO wnu_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","nob qamar: “Munon gugum mi aib at nub eng wain ya qer uber ete eng gigit qerei wurisari nub ugeari ne qer ii ete eng bo qanamt qerei igour. Ne bo uber eng duet igo see qas imurima yara,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yisas qen qamart wonomi wes eng ebeter eng. Eng ginam Kana ai Galili end. Ende aba wonou imbigau yurau eng gab wot oabigumirei. ");
INSERT INTO wnu_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Qen eng ubura ne Yisas unor ne umuragrari ne wonou wuri imbigau yurau eng ende oromar Kaperneam end isub qen gurum nami end igurei. ");
INSERT INTO wnu_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","End igamari Yuda wurinou qen aib Qenu wonou ensel tonoanb me igaramau qamb mi aib at nub igour eng piara gab Yisas Yerusalem qite irarei. ");
INSERT INTO wnu_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Irab inorou munai aib mor isub gar eng munon irou bur qarig ne sipsip morogan ne eng nomon qur eng gagar bisub nor end mi taui baub igamari ibagarei. ");
INSERT INTO wnu_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ende ibag ne bunom tau ger ba qungausi ne munon mor igour eng orotoar arir, ne bur qarig sipsip qamb eng gugum orotoar arir, ne wurinou nomon qur nam qabt bigumir eng ten biigiamorei. ");
INSERT INTO wnu_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ende at ne munon morogan taui ba igour eng wuri nob qamar: “An mi e ba iuar, Tain munai bo ba sumungasi mind munai gas ende me abar.” ");
INSERT INTO wnu_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ende aba wonou imbigau yurau eng der qob qoan gumatemir ete igoar end misir igumirei: “Ye nonou munai sig mom qenungoum. Munon ger munai eng sumungasia gab ye oau biriberi nibam,” ende igoai. ");
INSERT INTO wnu_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ne Yuda munon baraitari bo igeser yar qebi qamamir: “Ne qomon wes ger aba gab in qomorun, qo munon eng Qenu boopurima igo end abar eng, ende qomoruboun.” ");
INSERT INTO wnu_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ende qamarari Yisas taui qamar: “Qenu munai e bapamimari ne ye bo qen ombur garit mindaibam.” ");
INSERT INTO wnu_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ende qamara wuri qamamir: “Ii, munai e bapamimari qen ombur garit mindaibam quran? Munon munai e mindat igamari togun 46-ende wara boopuramirei,” ende qamamirei. ");
INSERT INTO wnu_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Eng Yisas Qenu munait qamar eng wonou git goan end qamb igoai. ");
INSERT INTO wnu_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","End ne wo uma tumunimari bo igomot der bogoma ne wonou imbigau yurau eng misir igub qamamir: “Qo, qob qoan igoar eng mi git abar eng.” Ende qamb wot oa bigumirei. ");
INSERT INTO wnu_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yuda wurinou mi niau qen (Pasova qamb igour) eng gab Yisas Yerusalem end ir igo mi wes-wes aba dibenara gab munon irou wot oabigumirei. ");
INSERT INTO wnu_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ende abari Yisas wo munon gugum wurinou misir mom imbig wogub wonomi ba me dibesiau. ");
INSERT INTO wnu_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Munon ger igo ger wonou qomon eng Yisas imbig me nob qamarau. Yisas wonou, munon gugum misir eng imbig igoai. ");
INSERT INTO wnu_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Qen end munon ger igoai unum eng Nikodemus. Wo Yuda wurinou baraitari, wo git Parisi wurinou yurau. ");
INSERT INTO wnu_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Qen geret wo itum Yisast diab nob qamar: “Imbigau munon, in ne mom niimbigoun Qenu niimurima derenei. Munon ar ger Qenu wo me maribiginer eng qomon wes-wes ne ebet igoan eng maigas me ebeinerei.” ");
INSERT INTO wnu_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ende qamara Yisas taui nob qamar: “Sig apand nonob quraum, munon ger wau qomourt gas ende me ebeiner eng Qenu wonou bibis eng me ginerei.” ");
INSERT INTO wnu_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ne Nikodemus qamar: “Munon mom isigi burab wogub bo sabar wau qomourt buriba? Mai, bo unor qur erobon isa bo sabar baiba qiyo?” ");
INSERT INTO wnu_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ende qamara Yisas qamar: “Apand quraum, munon ger ya asin Igomurur qau ten obotet maragansiari bo munon bubun gas me ebeiner eng, Qenu wonou bibis end me isinerei. ");
INSERT INTO wnu_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","End ne tain nanib anbaub igour eng aninou munangit qomon end, a Qenu Igomurur qau ansiara dariamunon eng Igomurur qau wonou. ");
INSERT INTO wnu_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ye qob eng at aninob qemerine an me qiar. Wogub bo nani se anbaiau gas ende burar. ");
INSERT INTO wnu_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Moon umo di ite ir qiyo ite yar umo isub ende aba in toau qas igub igoun, git eng eret isub igo eng in sir ue. Eng gas ende munon Igomurur qau wurisera bo munon bubun gas ende burunor eng ende gas gari.” ");
INSERT INTO wnu_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ende qamara Nikodemus qamar: “Eng maigas ende ebeiba?” ");
INSERT INTO wnu_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Qamara Yisas taui qamar: “Ne Isrel wurinou munon baraitari igo qomon wuriimbig igoan eng meimet qamb mi eng qangangetaran? ");
INSERT INTO wnu_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Segagam nonob quraun, in mi magqurt gab imbig aninob quraun. Eng an bo bur iruges big qenen qob aninob qumurune mogirt wab wogub igoumon. ");
INSERT INTO wnu_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ne ye mi ag e nonou gab mom imbig igoan end mit big quraum eng ne me imbigan. Eng bo Qenu ginamt end bo qemerine ne maigas imbigiban? ");
INSERT INTO wnu_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Munon ger Qenu ginamt end irab mi gab wogub me darau. Munangit wau wonou gari Qenu ginam eng wogub dererei.” ");
INSERT INTO wnu_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Qamb qamar: “Qoan seger ait Moses mani qugur barsi qorent uriamor gas ende bo Munangit wau ende siorubour. ");
INSERT INTO wnu_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ende siarari munon gugum wot oabig eng gugum bebereg igorubour. ");
INSERT INTO wnu_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Qenu munon gugum ai qent e sig-sig mom wuriqenungar ne wonou wau ten eng imurima dererei. End ne munon gugum wot oabig eng me umunorei, qenen bebereg igorubour. ");
INSERT INTO wnu_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Qenu wo wau imuriamor eng munon wuriqerei quguragsi qamb me imurimau. Wo munon wurimusub wuriqubeiom qamb. ");
INSERT INTO wnu_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Munon ger wot oabiginer eng wot qob musiteib qamb me ebeinerei. A, munon wot me oabiginer eng wo qo boruburerei igo. Eng wo Qenu wau gari qas wot me oabigau end. ");
INSERT INTO wnu_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Uyor sarau beau qanam eng ete: begen qo ag e der begentar ego munon yamangar wurinou qomon boru-boru eng ebet begen eng wogub itum igorub at igour. ");
INSERT INTO wnu_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Eng munon qei qomon boru ebet igour eng begen end yari igour. ");
INSERT INTO wnu_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","A munon qei qomon apand ebet igour eng wuri begen end igorub qamb qenunget igour. Wuri sarau obounor eng Qenu wurisiara abari munon gugum diban gubour. ");
INSERT INTO wnu_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ende qamb wogub ne Yisas wonou imbigau yurau eng oromar ai Yudia wes end isumirei. Isub qen qei end igo munon wurimaragansi ya obotar igoai. ");
INSERT INTO wnu_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yon wo gor munon wurimaragansi ya obotar igoai. Wo ginam Ainon Salim nob qani end igama munon yamangar wot isari wurimaragansi igoai. Ginam end ya aib igoar end. ");
INSERT INTO wnu_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Qen end Herot Yon uyort me bigau igama. ");
INSERT INTO wnu_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ne Yon wonou imbigau yurau eng der Yuda munon ger ya ubau qomon end at wogub nob agunumirei. ");
INSERT INTO wnu_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ende at wogub Yont isub nob qamamir: “Barai, ne qoan ya Yordan ig iro igo munon ger net isa ya ubetet wot dibes qamara igumin eng, wo gor munon wurimaragansi ya obotar igo. Igama munon gugum wot isub qob qamara igub igour.” ");
INSERT INTO wnu_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ende qamarari Yon taui qamar: “Qenu munon ger mi me imbiginer eng wonou maigas mi ger me ebeinerei. ");
INSERT INTO wnu_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Qob qoan aninob qamam eng an mom qoyam. End qoan aninob ete qemerine igumon eng, ‘Ye munon anmusiau tari eng ue, ye wonou qob gim big yiimurima gigit yoroum’ qamam eng. ");
INSERT INTO wnu_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Munon ger yamangar bainer eng yamangar eng munon eng wonou qoregen. Munon yamangar bainer eng wonou munon banam eng yar qani naget igo wonou banam yamangar bainer eng qob qamara toau isa igub mismisir igoriba. Eng gas ende ye gor ende mismisir igoum. ");
INSERT INTO wnu_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","End ne wo unum diban igama ne ye ii igoriner eng uber.” ");
INSERT INTO wnu_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ende qamb qamar: “Munon erer qite derer eng wo mi gugum imbig igo. Ne munon ai qent et dari eng wo mi ag et gari qob suab igo. Munon Qenu ginamt igo deriner eng, mi erer qite ne mi ag e gugum imbig igo, wo munon gugum wuritanamima. ");
INSERT INTO wnu_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Wo mi gab ne igub igo end wuri nob qamb igo ego munon wo qob me igotoun qamb at igour. ");
INSERT INTO wnu_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Munon ger wonou qob igetet eng Qenu apand qurar eng munon qei wuriimbigiba. ");
INSERT INTO wnu_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Munon eng Qenu imurima derer eng wonou Igomurur qau qeretutnob opur igama wonou qob eng gor qeretutnob qamb qib igo. ");
INSERT INTO wnu_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Wonou ur eng borusi mom qenunget ne mi gugum wonou ubent big nonogursiarei. ");
INSERT INTO wnu_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Munon qei wau end wot oabig eng igomot igorubour. A munon wo qob qamara bagau wagir qib igorunor eng umubour. Qenu wurit misiringeteriner eng ten ende igoriba. ");
INSERT INTO wnu_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Qen end Parisi igumir eng “Yisas wo munon yurau irou wot isari ya obotar wurimaragansi ne Yon wotanami igo,” ende qamarari igumirei. ");
INSERT INTO wnu_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Qen end Yisas wo git munon me wurimaragansiau. Wonou imbigau yurau eng apand wurimaragansi igurei. ");
INSERT INTO wnu_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Qob eng mom aib bura Parisi igub ugaur qamb Yisas igeser bo Galili irarei. ");
INSERT INTO wnu_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Wo tap eng toat Samaria wurinou ai isib qamb ir igoai. ");
INSERT INTO wnu_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Irab iri Samaria wurinou ginam aib ger unum Sikar end weib irarei. Ginam eng qoan Yekop ai ger wonou wau Yosep uter eng qani end igoai. ");
INSERT INTO wnu_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ne gor Yekop ya tumun goaneter eng ginam end igoai. Igama ne Yisas ir igama worom ginam tog yara wogub git goan quguraget wogub is ya tumun qani end bugab igoai. ");
INSERT INTO wnu_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ende igama Samaria yamangar ger ya unib qamb yarerei. Yara Yisas nob qamar: “Yat oboum, unab yesa nib.” ");
INSERT INTO wnu_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Qen end wonou imbigau yurau eng mani taui baub qamb ginam aib ite iramirei. ");
INSERT INTO wnu_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ende qamara yamangar eng taui qamar: “Ne Yuda munon ne ye Samaria yamangar meimet qamb ya unab neteibine quran?” Qanam eng Yuda Samaria nob me qibanamsi igour end. ");
INSERT INTO wnu_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ende qamara Yisas taui qamar: “Ende gab eng Qenu mi ar natab ig eng imbig ne munon e ‘ya yesa nini’ qurar eng ya unab utiner eng ne bo yat at qemerinen eng wo ya nub bebereg igamau eng neteiba.” ");
INSERT INTO wnu_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ende qamara yamangar taui qamar: “Barai, ya e sig tumun qumqumo, ne gor ne yangaran ue. Eng ya nub igomot igamau eng eret igama uniban? ");
INSERT INTO wnu_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ininou tonoan namungur Yekop wonou ya tumun e. Qoan wonou wagrari big a bur qarig ne sipsip ende nub igour eng init wagerei. End ne ne mai Yekop aib igoar eng ne wotanamiman qiyo?” ");
INSERT INTO wnu_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ende qamara Yisas taui qamar: “Munon gugum ya e nub eng yat bo ebet sabar-sabar nub igorubour. ");
INSERT INTO wnu_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","A ye ya neteib qamb quraum eng munon ger utine niner eng bo sabar oau saragairoa yat me ebeinerei. Ya tumun e wonou qenen igo qas ende igama igoriba. Igo ne ya eng qenen aba iigomot igoriba.” ");
INSERT INTO wnu_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ende qamara yamangar taui qamar: “Barai, ye ya qenen yat yar ebet ya tumun qumo e ego arir unab ubumot iyetroum, ya ne quran eng qand yesa nub bo sabar yat me qirinei.” ");
INSERT INTO wnu_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ende qamara Yisas taui nob qamar: “Ne qand irab namamit ab nob yarar.” ");
INSERT INTO wnu_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Qamara yamangar bo qamar: “Ye munon ger ue.” Ne Yisas taui qamar: “Ye see nonob qemerine, ‘ye munon ue’ quran eng git segagam. ");
INSERT INTO wnu_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ego, ye negaum eng ne qoan munon uben ig ue ende baunei. Ne ne munon see nob igoan eng nonou munon apand ue.” ");
INSERT INTO wnu_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ne yamangar qamar: “Barai, segagam ne niimbigoum, ne munon mi qen geret diorunor eng imbigau tari. End ne ye mi ger qemerine ne qamara igub. ");
INSERT INTO wnu_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ininou tonoanb ai qaur et qiumuni Qenut qenen igub mismisir igurei. Ne see an Yuda munon, bo Qenut igub qamb eng bo qenen ginam aib Yerusalem qite ir igoarar quraumon.” ");
INSERT INTO wnu_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ne Yisas yamangar nob qamar: “Ne ye qob quraum eng iruges big igu, qen ger igeserma gab eng an ai qaur et qiyo Yerusalem end sir qiumuni Tain aib wot me igub igurunanei. ");
INSERT INTO wnu_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","End ne an Samaria, munon an yourt oabig qiumuni wot igub at igoumon qi eng an sir me imbigoumon. In Yuda at igoun eng in sir imbigoun. Qanam eng Qenu munon gugum wuriubersierib qamb werei ebeter eng in Yuda yurau erobon end. ");
INSERT INTO wnu_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Qen ger yarib eng see qo yarar eng. End ne munon Taint apand wot oabig Igomurur qau ten simot orunor eng, munon yurau eng Tain wuriqenungariba. ");
INSERT INTO wnu_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Qenu wo munangit gas ende ue. End munon Wot mismisirub qamb qomon apand end wurinou igomurur ten wot mismisirunor.” ");
INSERT INTO wnu_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Yisas ende qamara yamangar eng der qamar: “Eng ye qoyam, ‘munon wuriubersiau tari eng unum Krais qamb igour eng darab mi gugum dibes ininob qamb ugeiba,’ ende qamarari igub igumei.” ");
INSERT INTO wnu_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yisas taui qamar: “Munon eng qamarari igub igoan eng Ye gari, see nonob qobub igoum eng.” ");
INSERT INTO wnu_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ende qamb waga wonou imbigau yurau mani baub iramir eng yaremirei. Yarab Yisas yamangar eng nob qobub igama gab borusi qietemirei. Qiet ne ger der yamangar end ne “meim baib e yaranei?” Qo, ger der Yisas nob “meimet qamb yamangar e nob qobub igoan?” Ende ger Yisas yamangar eng wuri nob me qamarau. ");
INSERT INTO wnu_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ne yamangar eng yangaran end wogub bo igeser ginamt irab munon gugum wuri nob qamarei. ");
INSERT INTO wnu_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Qamar: “Qand isub munon ger ye qomon qi ebet qib igoum eng dibes ye nob qamb ugai. Munon wuriubersiau tari deriba qamb igour eng wo gari.” ");
INSERT INTO wnu_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ende qamara munon gugum Yisas gub qamb ginam wogub isumirei. ");
INSERT INTO wnu_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Qen end Yisas wonou yurau mani bisub Yisas utab qamamir: “Barai, ne mi ger nub ge.” ");
INSERT INTO wnu_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ne Yisas wuri nob qamar: “Ye mani qei igo, mani eng an qoyam ue eng.” ");
INSERT INTO wnu_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ende qamara imbigau munon yurau eng der wurinou-wurinou qi qebi qamamir: “Munon qei mi ba yar uturei igama qura nee?” ");
INSERT INTO wnu_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ende qamb igamari Yisas der qamar: “Ye mani eng munon ye sarau eb qamb yiimurima derem eng wonou sarau eng ye ebet ugeibam. ");
INSERT INTO wnu_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","An ete qamb igoumon: Inaun 4-ende uma mani arirau qen yariba, qamb igoumon eng. Ye qemerine igar: Mani qo arit igo eng an musub me gaumon, gonau qen eng qo yar igo. ");
INSERT INTO wnu_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Munon mani gonau eng qo goanet git ba qenen bebereg igamau end big igo. End ne munon mani ubau eng nob mani goanet igo eng nob ombur mismisir igour. ");
INSERT INTO wnu_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Qob eng apand, munon ger mani uba arira ger gonat igo. ");
INSERT INTO wnu_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","End ne ye animurimine mani eng arit igo eng qoan an me goanet geau, eng qaum is gonauboumon. Git eng munon qei wurinou mani ubumirei igama arira goanet igour eng an ar isub wuri nob goanar,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Samaria munon ginam aib eng, yamangar eng isub wonou qomon qi at qib igoar eng Yisas dibes nob qamb ugea is qamara igub Yisast oabigumirei. ");
INSERT INTO wnu_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ne wuri Yisast yarab wuri nob igoar qamb duet qamarari qen ombur wuri nob igurei. ");
INSERT INTO wnu_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","End igo wonou bo qob qamara igub irou wot oabigumirei. ");
INSERT INTO wnu_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ende at ne yamangar eng nob qamamir: “Ne gari qob eng qamara igub wot oa me bigoun. Wonou gor qanam mom musub qamara igub wot oabigoun. Segagam munon eng gari munon ai qent gugum inubersieriba qamb igour eng,” ende qamamirei. ");
INSERT INTO wnu_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Yisas qen ombur ende wuri nob igoi wogub bo Galili irarei. ");
INSERT INTO wnu_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Irib qamb wonomit qamar: “Qob gigit qamarau munon ger wonou ginam qenen end unum nob me igo.” ");
INSERT INTO wnu_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ende qamb wogub ir Galili weib iroa munon eng wo gab mismisiramirei. Qanam eng qen aib ‘Pasova’ qamb mi bingen nub igour qen end wurinou Yerusalem qite irab Yisas mi gugum aba gamir end. ");
INSERT INTO wnu_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yisas ginam eng wogub bo sabar ai Galili ginam ger Kana end isorei. Qoan ya asin aba wain ya burer ginam end isorei. Isa ne ginam ger Kaperneam end gabman baraitari wonou sarau munon ger igoar eng wonou munonbor wau ger toar wab igoai. ");
INSERT INTO wnu_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Qen end igor eng: ‘Yisas ai Yudia wogub Galili end yara’ ende qamarari igorei. Igub isub Yisas nob qemerine isub wonou wau eng musi qamb. Wau eng toar wara umib pisi igoai. ");
INSERT INTO wnu_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Is qebi qamara Yisas nob qamar: “An qomon sig maieng wes-wes me gab qi eng yet me oabigunanei. ");
INSERT INTO wnu_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Qamara munon eng taui qamar: “Barai, igama yonou wau umiba, qand nob isun.” ");
INSERT INTO wnu_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Qamara Yisas bo nob qamar: “Ne is, nonou wau uber buriba.” Ende qamara munon eng qob end oabig isorei. ");
INSERT INTO wnu_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Qataben isa-isa wonou sarau munon qei diab gab qamamir: “Nonou wau uberet igo.” ");
INSERT INTO wnu_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ende qamarari wuri qebi qen mait wonou wau uberetar eng qamara wuri qamamir: “Barim worom wo bures ig biga nonou wau toar wagerei.” ");
INSERT INTO wnu_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ende qamarari wau ur barim qen endet Yisas nob qamar: “Nonou wau uber buriba.” Qamar end misir igub ginamt isub wonou wagrari big wot oabig igurei. ");
INSERT INTO wnu_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yisas Yudia wogub Galili irab sarau wes eng ebeter eng qen omburt. Qen qamart ya asin aba wain ya warurei, ne bo wau toar qamara qas wager eng. ");
INSERT INTO wnu_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Qen end Yuda wurinou qen aib qamb mi bingen nub igour eng yara gab Yisas Yerusalem qite irarei. ");
INSERT INTO wnu_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Yerusalem youn aib nomont bigumir eng tend ger wai sipsip wurinou tend qamb igour. Wai sipsip tend qani end ya tai ger igoai. Hibru qobt ‘Betesda’ qamb igour. Ya tai gabut end munai ar bugab igamau 5-ende igoai. ");
INSERT INTO wnu_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Munai end toar munon irou igurei. Qei mag tuum, qei goten boru ne qei qer gugum gurumot uburer eng end igurei. (Wuri end igo ya tai eng qorogot dera gun qamb qenen qoat igurei. ");
INSERT INTO wnu_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Qen qei Qenu munon enger der ya weib isa ya qorogot deara gab munon ger wonou gigit isub ya weib isiner eng toar waga iua igurei). ");
INSERT INTO wnu_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Qen end munon ger toar wara togun 38-ende igoai. ");
INSERT INTO wnu_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Igama qen end Yisas is gab mom imbigorei, munon eng unor set baia toar warei. Ende gab nob qamar: “Ne uberburib qenungan qiyo?” ");
INSERT INTO wnu_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ne toar munon eng Yisas nob qamar: “Io, qenen ya qoroga ye is weib isub uber burin qamb ebet igoum ego munon qei bais uber-uber eng qand yetanami isub ubet uberet iua igour. Ye munon ger ye ba gigit isa uber-uber burin eng munon ger ue. End ar e inab igoum e.” ");
INSERT INTO wnu_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ne Yisas nob qamar: “Der naget nonou qug oramet inab igoan eng ba is.” ");
INSERT INTO wnu_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ende qamara munon eng uberet put der naget qug inab igoar eng menub ba isorei. Qen eng ebeter eng inorou qent. ");
INSERT INTO wnu_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Munon eng uberet qib igama Yuda der gab qamamir: “See inorou qen in gitab igoun eng ne meimet qamb inorou songi qug bemenumi ba qib igoan?” ");
INSERT INTO wnu_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ne munon eng der qamar: “Munon ye yemusiar eng, ‘qug ba is’ ende yet qamara ye ba qib igoum.” ");
INSERT INTO wnu_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ende qamara wuri qebi qamamir: “Munon eng your ende qamara at qib igoan?” ende qamamirei. ");
INSERT INTO wnu_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Qen end munon yurau irou end Yisas munon eng ende musub wogub wuri qob ar qoa wogub munon eng Yisas sir gab Yuda me wuri imbigau. ");
INSERT INTO wnu_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ai gab-gab end munon uberetar eng inorou munai end qib igama Yisas qib gab nob qamar: “See ne mom uber buran, bo qomon boru ger me eb. Bo ebeinen eng qoan quguraget igoan eng wotanami bo sig-sig mom qugurageteriban.” ");
INSERT INTO wnu_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ende qamara munon eng Yisas mom imbig wogub isub Yuda wuri nob qamarei. ");
INSERT INTO wnu_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Qen end inorou qent Yisas munon eng musuor qanam end ne Yuda qanambig qarausiamirei. ");
INSERT INTO wnu_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ende abari Yisas wuri nob qamar: “Yonou Tain qenen sarau baab igo end ye gor sarau baaum,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Yisas Qenut ‘yonou Tain’ end ye gor Qenu qamar end Yuda munon wuri imusi borusi misiringet Yisas mom waramb qas wogub at igurei. (Qanam eng Yisas wo Qenu wau ue wo munon ar wau qamb igour end at igurei.) ");
INSERT INTO wnu_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ende abari Yisas wuri nob qamar: “Segagam aninob quraum, wau wonou misirt mi ger me ebet igo, ur mi aba gab parangaub ebet igo. ");
INSERT INTO wnu_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ur wau sig qenunget ne mi gugum wonou ebet igo eng wau imbig igo. Isi yarab mi eng mom imbig ugea ne bo sarau aib-aib eng imbiga ebet mi eng gagar ebeiner eng wotanamimba. Ende aba gab an misir qebebi iguboumon. ");
INSERT INTO wnu_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Tain munon umari bo wurimenima igomot der bugab igour. Eng gas ende wonou wau gor munon ger wonou igomot igorib qenunga eng wau gor munon eng menima igomot igoriba. ");
INSERT INTO wnu_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ur munon me wuri qereiminerei. Munon qereimau qomon eng waut wagerei. ");
INSERT INTO wnu_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","End ne ur wot igub qenunget gab eng wau gor ende gas ende gari. Munon ger wau me qenunget gab eng ur gor wonou wau imurima derer eng me qenunginerei.” ");
INSERT INTO wnu_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ende qamb qamar: “Segagam aninob quraum, munon ger ye qob e quraum eng iruges big igub your yiimurima derem qi eng wot oabiginer eng igom qenen igoriba. Qenu munon eng bo qerei me quguragsierinerei. Wo qo umb wogub bebereg igo. ");
INSERT INTO wnu_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Eng segagam aninob quraum. Qen eng qo yarerei igo. Munon umburiamir eng Qenu wau ara qob toau igotounor eng wuri igom igorubour. ");
INSERT INTO wnu_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Qenen bebereg igamau eng ur wonou qanam end ne wonou wau gor bebereg igamau eng qanam. ");
INSERT INTO wnu_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Wo munangit wau end ne munon qomon qereimau qomon eng wot wagerei. ");
INSERT INTO wnu_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","29","End ne an mi eng bubun gaun qamb me qiar. Qen ger gab munon umburiamir tumunt igour eng wurit ara toau igub tumun wogub der bugombour. Bugab munon qomon uber ebet igoriner eng igom igoriba. A qomon boru ebet igorunor eng Qenu wuri qerei ne wurisogar ginam boru end wuriimurima isubour.” ");
INSERT INTO wnu_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ende qamb qamar: “Ye mi eng gar ebeteri igoum eng yonou misirt mi ger me ebet igoum. Tain wonou munon qomon wurit qereiom ende yet qamara ebet igoum, ebine qoregen isub igo. ‘Yonou wariges mi ger ebeini’ ende qamb me ebet igoum, wonou yiimurima derem eng gari qob igetet ebet igoum. ");
INSERT INTO wnu_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ye gari yonomit dibes qemerin eng an apand qamb me igesounanei. ");
INSERT INTO wnu_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","A munon ger ye yegab imbig ne yet dibes qamb igo eng apand. ");
INSERT INTO wnu_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Qoan aninou munon qei Yont imurimari isub wo qob qamara igub diab aninob qamarari iguman eng wo qob apand qas qamarei. ");
INSERT INTO wnu_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ye eng quraum eng munangit yet dibes qamarar qamb me quraum. Ye quraum eng an igomot qenen bebereg igamau werei eng qamb igoum. ");
INSERT INTO wnu_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yon wo urut begen gas ende begent munon wurit ariramorei. Ende aba an begen eng gab qen pitente mismisiramanei. ");
INSERT INTO wnu_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","End ne ye mi e quraum eng munon ger ye nob qamara igub quraum. Yon qoan qamara igumon eng wotanamima. Sarau ye ebet igoum eng yonou tain eb qamara ebet igoum. Sarau eng ebine ne sarau eng wonou ye tain yiimurima derem eng animbiga. ");
INSERT INTO wnu_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ne tain yiimurima derem eng wo gor yet dibes qamb igo. Ego an wo qob bais me igetet igoumon. Ne gor wo menman bais me gab igoumon. ");
INSERT INTO wnu_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Wo munon imurima derer eng an gab, munon ger qamb me wot oabigun qamb mag gari gab wogoumon end wonou qob eng anit me rama. ");
INSERT INTO wnu_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","An bebereg igorub qamb qenen Qenu qob qoan gumatemir eng wanunger gab igoumon eng. Mai yourt qamamirei? Yet gari qamb gumatemirei. ");
INSERT INTO wnu_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","End ne an yet yarab bebereg me igorun qamba at igoumon eng.” ");
INSERT INTO wnu_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Ende qamb qamar: “Ye Munangit ye unum bererimar qamb me darau. ");
INSERT INTO wnu_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ye animbigoum, Qenu gor oau apand big me qenungoumon. ");
INSERT INTO wnu_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ye tain wonomi wes eng ten derem ego an ye me yemusiaumon. Mai qiyo, munon bubun ger bo wonomi wes eng ten yar qob qamara igub igotounon qiyo, ye sir ue. ");
INSERT INTO wnu_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Aninou munon banam wurit qas mismisirub eng uter oboumon. A Qenu munon imurima derer eng wot mismisirau eng ue. Eng ebet wot maigas oabiguboumon? ");
INSERT INTO wnu_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Eng gab an ye aninou qomon eng taint dibes qemeriner qamb me yarimar. Munon aninou qomon dibes qemeriner eng Moses aninou qenunget igoumon eng. ");
INSERT INTO wnu_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","An Moses qob eng apand mom oabigumanei ende qi eng qo yet oabigoumon qi. Moses wo qob qamb gumater eng yourt ue, yet qamb gumaterei. ");
INSERT INTO wnu_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","End ne wo qob maigas at gumater eng an musub me oabig eng ye qob gor maigas imbig oabiguboumon,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Bais umi-umi wogub qen geret Yisas wo bo Yerusalem wogub ai Galili end diab ginam Taiberius end isorei. Isub tabin ba ya tai Galili purab ig iro isorei. ");
INSERT INTO wnu_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Yisas toar munon irou wurimusia uberet ne wonou sarau wes-wes eng aba gab wo eng isa munon yurau irou toat isumirei. ");
INSERT INTO wnu_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yisas wo isuor eng is is wonou imbigau yurau eng wuri nob ai qaur ger ir end bugab igurei. ");
INSERT INTO wnu_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Qen end Yuda wurinou inorou qen aib gab mi aib at nub igour eng pi burab igoai. ");
INSERT INTO wnu_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yisas ende bugab igo ne igeser munon yurau aib eng ibag ne wonou imbigau munon ger unum Pilip nob qamar: “Wa, munon yurau aib e mani eret gab taui ba wurisune nubour?” ");
INSERT INTO wnu_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Yisas wo mi ebeiner eng qoan imbigor ego Pilip gag wariges nob qamarei). ");
INSERT INTO wnu_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ende qamara Pilip taui qamar: “Wa, eng mai obouboun? In nomon qur qangang K200-ende ba mani parau taui ba werisun eng gor qeemben ue.” ");
INSERT INTO wnu_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ende qamara wonou imbigau munon ger, unum Andru, wo Saimon Pita wonou umour, wo der Yisas nob qamar: ");
INSERT INTO wnu_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Io, wau moi e wo mani parau 5-ende ne yagwai ombur-ombur ende igo. Ego munon yurau aib ete eng qeemben ue.” ");
INSERT INTO wnu_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ende qamara Yisas der wonou imbigau yurau gugum wurinob qamar: “Munon yurau qamarari bugamunor.” Ende qamara qamarari misugan irou igoar end bugoramirei. Munon yurau aib eng gugum qangang 5,000-ende. ");
INSERT INTO wnu_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ne Yisas mani parau eng ba Qenut uber qamb ne qerei munon bugoramir eng wuriserei. Ende at ne yagwai eng gor ba ende gari ebet wuriserei. ");
INSERT INTO wnu_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Wurisa mani yagwai eng nob qeemben niari qur uter igarerei. Ende at ne mani tatau wagari igama Yisas gab wonou wuri imbigau yurau eng wurinob qamar: “Mani tatau me isiorun, usisi baiar.” ");
INSERT INTO wnu_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ende qamara usisi ba tugar 12-ende tugarimari diarei. Mani parau uben ig ue gari eng, bo nub tatau wagari tugariamir eng bo tugar 12-ende eng. ");
INSERT INTO wnu_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Munon yurau aib eng Yisas mani gari eng aba bo irou bura gab qamamir: “Io, munon mi qen geret yariner end qamb igo eng wo gari ag e dererei.” ");
INSERT INTO wnu_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ende qamb duet nob igo wurinou baraitari maribigub qamb misir igari ion ibag ne end wuriwogub wonomai ai qaur end bo irarei. ");
INSERT INTO wnu_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","17","Worom nerimb pisia ne wonou imbigau yurau eng ya tai end isub tabin ba Kaperneam end isub qamb isub igurei. Qataben isari-isari ituramorei. Qen end Yisas me wuri nob isau. ");
INSERT INTO wnu_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Isub igamari ne sanisani aib di ya bures ariramorei. ");
INSERT INTO wnu_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ende aba is ya tai wobunobun isub gamir eng Yisas ya erer yar igoai. Gab igamari is tabin qani isa gab borusi yariamirei. ");
INSERT INTO wnu_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ende abari Yisas der wuri nob qamar: “An me yarimar, ye gari yoroum.” ");
INSERT INTO wnu_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ende qamar wuri ba mor bigub qamb abari tabin qand is ya gabut inerei. ");
INSERT INTO wnu_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Munon yurau aib eng wuriwogub isumir eng end inemirei. Mani wurisab igour qen end tabin gari qas igoar eng Yisas wonou imbigau yurau eng wurinou gari ba isumirei. Qen end Yisas wurinob isa me geau. ");
INSERT INTO wnu_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Urigerma ne Taiberius wurinou tabin ger Yisas mani Qenut qamb boat wurisab igoart end diab inerei. ");
INSERT INTO wnu_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Qen end Yisas wonou imbigau yurau wuri nob me igamari ibag, wuri bo tabin end isub qanam Yisas gub qamb Kaperneam end isumirei. ");
INSERT INTO wnu_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ende is gamir eng Yisas igama gab nob qamamir: “Barai, ne qen mait e yarenei?” ");
INSERT INTO wnu_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ende qamarari wo taui qamar: “Segagam aninob quraum, an ar mani eng nub gab ‘bo ar ende igumune bo ende aba nub igorun’ qamb ye toat qib igoumon. A yonou sarau eng ne ye your qi eng an imbigub qamb me yetoat yoroumon. ");
INSERT INTO wnu_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","An mani apand nub gaumon end me asi qib igoarar, mani eng nub bo qand minemb igoumon. Mani nub qenen igomot igamau end asi gunon eng uber. Mani eng quraum eng Munangit wau andariba. Wonou Ur Qenu wot maribigorei.” ");
INSERT INTO wnu_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ende qamara wuri qamamir: “In maigas at Qenu sarau eng obouboun?” ");
INSERT INTO wnu_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ne Yisas qamar: “Qenu an sarau abar qamb qenungar eng ete: Wo munon imuriamor end mom wot oabigar qamb an qenungar igo. Ende obounon eng wonou sarau apand abari ende animbag an qenungariba.” ");
INSERT INTO wnu_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ende qamara wuri bo taui qamamir: Ende gab eng ne mi wes ger maigas aba dibenara in gab net oabiguboun? Ne meimi sarau ebeiban? ");
INSERT INTO wnu_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Qoan ir ininou tonoanb seger ai end qib igo ne mana numirei. Eng Munon aib qob ete qamb gumatemirei igama wanunger igoun: “Qenu wonou ginamt end mani parau biga dara numirei.” ");
INSERT INTO wnu_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","33","Ende qamarari Yisas taui qamar: “Segagam aninob quraum, mani parau eng Moses weriser eng Qenu ginamt end me darau, ue. A mani parau tain wonou ginamt imurima anit der igo eng mani parau apand. An nub qenen igomot igoruboumon.” ");
INSERT INTO wnu_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ende qamara wuri qamamir: “Barai, mani eng qenen indara in nub igorub.” ");
INSERT INTO wnu_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ne Yisas qamar: “Mani parau nub igomot igamau eng Ye gari. Munon ger yet oabig yariner eng me minemb ne gor yat me ebeinerei. ");
INSERT INTO wnu_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","An ye qo yegaman end yet oabigomanei qamb animbagaum eng ue eng. ");
INSERT INTO wnu_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Tain munon yamangar yet qereiamor eng yet yarubour. Yarari ye wuri me qarausinei. ");
INSERT INTO wnu_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ye Qenu ginam wogub derem eng munon wonou yiimurima derem eng wonou misir eng qas toat ebeibam, yonou misir end me ebeinei. ");
INSERT INTO wnu_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Munon ye yiimuriamor eng wo ye mi eb qamb qenunget igo eng ete: Wonou munon yurau yet imuriamor eng ye wuri me qarausinei, ue. Qen sindomund end bo wurimenimba. ");
INSERT INTO wnu_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ger ete: Munon gugum wau eng gab wot oabigunor eng bebereg igamari qen sindomund end ye wurimenimbam,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Yisas qob eng qamar eng: “Mani parau Qenu ginam wogub derer eng Ye gari.” Eng qamara ne Yuda wuri misiringet nob agunub qamb etemirei. ");
INSERT INTO wnu_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ende at ne wuri der qamamir: “Munon eng Yosep wonou wau. In gugum wonou ur Yosep ne unor Maria eng in qoyam. Ego wo bo der: ‘Ye Qenu ginamt igo deremei’, qura a?” ");
INSERT INTO wnu_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ende qamb abari wo bo der taui qamar: “Meimet qamb aninou-aninou bo agunub igoumon? ");
INSERT INTO wnu_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Munon ger wonou uyes yet me yarinerei. Tain yiimurima derem eng wonou munon yet imurima yara ne ye qen sindomund end menimine igomot der bugemba. ");
INSERT INTO wnu_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Qenu qob gigit qamara munon gumatemir eng ete: ‘Qenu munon gugum wuriimbigiba’. Ende aba munon gugum wot qoyam imbig ne yet yar igour. ");
INSERT INTO wnu_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Qob eng qanam eng ete: Munangit ger Tain me geau, munon Qenu nob igo derer eng gari wonou Ur qoyam.” ");
INSERT INTO wnu_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ende qamb qamar: “Segagam aninob quraum, an yet oabig eng qenen bebereg igoruboumon. ");
INSERT INTO wnu_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Munon bebereg igorub qamb mani nub igour eng ye gari. ");
INSERT INTO wnu_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Aninou tonoanb mani parau (mana) seger ai end qib nub qib igour eng umb uburemirei. ");
INSERT INTO wnu_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ego mani parau see Qenu ginamt derer eng munon nub eng ger me uminerei. ");
INSERT INTO wnu_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Mani nub igomot igamau eng ye gari, Qenu ginam wogub deremei. Munon ger mani eng niner eng bebereg igoriba. Mani ye see werisibam eng yonou min. Ye ende wurisine nub eng munon ai qent gugum igomot igorubour.” ");
INSERT INTO wnu_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ende qamara Yuda munon misiringet wurinou agunub qamamir: “Wa, munon eng maigas at wonou min eng indara in nuboun?” ");
INSERT INTO wnu_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ne Yisas bo wurinob qamar: “Segagam aninob quraum, an yonou min nob yonou qeru nob me nub eng an igom me igurunanei. ");
INSERT INTO wnu_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Your yonou min qeru nob niner eng igomot igama qen sindomund end ye bo menimine der bugemba. ");
INSERT INTO wnu_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Yonou min eng mani apand ne yonou qeru eng ya apand. ");
INSERT INTO wnu_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Munon ger yonou min ne qeru nob nub eng wo ye yenob igama ne ye gor wo nob igoribam. ");
INSERT INTO wnu_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Tain igom igo eng yiimurima derem end ye wot bebereg igoum. End ne munon ger ye min eng nub eng yet wo bebereg igoriba. ");
INSERT INTO wnu_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","End ne mani parau Qenu ginamt derer eng mani parau qoan dara tonoanb nub qib igour gas ende ue. Wuri mani parau eng numir eng ger bebereg et igamari me ibagaun, ue. A munon ger ye mani parau see quraum eng nub eng qenen igomot igoriba.” ");
INSERT INTO wnu_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yisas qob eng wurinob qamb igoar eng Kaperneam inorou munai mor end. ");
INSERT INTO wnu_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Yisas qob eng ende wurinob qamara wonou munon yurau wo qob igub taut qib igour eng irou der wurinou misirt qamamir: “Ne qob eng at quran eng qob soagen ur, your ger qob eng igub io me qemerinerei.” ");
INSERT INTO wnu_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ende misir igub abari Yisas wuriimbig ne wuri nob qamar: “Qob e quraum end an yesiningot wogub qamb misir igoumon? ");
INSERT INTO wnu_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ende gab Munangit wau wonou qoan igoi wogub derer munai sambur end bo iroa an mai obouboumon? ");
INSERT INTO wnu_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Qenu Igomurur qau munon opuri igama wo git igom igo. Munangit wonou qer gagam big igom igorib qamb ebeiner eng misue. End ne qob e ye aninob quraum eng igub oabig eng Igomurur qau anit isa apand igom igoruboumon. ");
INSERT INTO wnu_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","End ne an yurau erogori end an qei yet oa me bigoumon.” Eng qoan Yisas qanambig sarau bea munon qei wot oa me bigau eng imbigorei. Ne gor wurinou yurau erogori end munon ger qen geret Yisas munon qarau wurit duima waramunor eng gor qo imbigorei. ");
INSERT INTO wnu_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ne Yisas qob eng qamb wogub bo qamar: “Eng gab ne aninob quraum, Tain munon ger me nonogursieriner eng munon eng ye me yetoainerei,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Yisas qob eng ende wurinob qamara wogub wonou yurau qei se-se yarari imbig wurinob qib igoar eng irou wogub bo me nob qib igamau. ");
INSERT INTO wnu_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ende wogub qoari ne wonou yurau qeemben 12-ende eng gari wurinob qamar: “An gor ye yewogub qoaub misir igoumon?” ");
INSERT INTO wnu_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ende qamara Saimon Pita der taui qamar: “Barai, in ne newogub in your nob qib igoruboun? In niimbigoun, ne qob eng in bebereg igamau werei eng. ");
INSERT INTO wnu_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","In mom niimbigoun, ne Qenu wonou munon sig uber ar.” ");
INSERT INTO wnu_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ende qamara Yisas taui wuri nob qamar: “Mai gas, an munon yurau 12-eng ye anmaribigomei qiyo? An yonou anmaribigom ego an yurau end gari qas aibigau opurimorei ten igo.” ");
INSERT INTO wnu_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yisas wo eng qamar eng Yudas Saimon Iskariot wonou wau end qamarei. Yudas Iskariot wo Yisas wonou munon yurau 12-ende erogori wuri qereiamor eng bo qen geret munon qarau wurit duima waramunor eng qo imbig ne wurinob qamb igoai. ");
INSERT INTO wnu_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Eng ende wurinob qamb wogub bo ai Galili end is qib igoai. Qen end Yuda munon baraitari mom waramb abari ibag bo ai Yudia end me is qib igamau. ");
INSERT INTO wnu_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Wo ai Galili end is qib igama Yuda wurinou inorou qen aib ger gab mot ubet mi aib at nub igour eng pi burerei. ");
INSERT INTO wnu_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ende aba Yisas wonou umuragrori der nob qamamir: “Ne ginam e wogub bo Yudia itet iroa nonou wuri imbigau yurau eng ne sarau maigas at baab qib igoan qi eng negab imbigunor. ");
INSERT INTO wnu_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Munon ger sarau ende ebet munon gugum imbigar qamb ebet eng wonou qi waber me ebet igo. End ne ne sarau eng aban eng itet irab aba munon gugum diban nogounor.” ");
INSERT INTO wnu_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Umuragrori wuri Yisas wot me oabig ne ende at qamamirei. ");
INSERT INTO wnu_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Qamarari Yisas der wuri nob qamar: “Yonou qen qeemben ger yara me gaum, see aninou qen eng yara gab quraumon. ");
INSERT INTO wnu_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Munon yamangar ag e an me an qarausiunorei. Ye wurinou qomon boru qi ebetri igour eng dibes wuri nob qemerine ye qarausi igour. ");
INSERT INTO wnu_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","End ne an mi at nubour end irar. Ye yonou qen qeemben eng me yarau end me irinei.” ");
INSERT INTO wnu_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ende qamara umuragrori iroari wo Galili umo igoai. ");
INSERT INTO wnu_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Yisas ende igama umuragrori iroari wogub wo bo qanam, diban me iroau, waber irarei. ");
INSERT INTO wnu_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Yuda munon der Yisas nob iramirei qamb gun qamb asi gamir e ue gab wuri qebi qamamir: “Yisas eret igo?” ");
INSERT INTO wnu_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","13","Ende qamb munon yurau aib erobon-erobon eng wo gun qamb wot asi qob qi-qi irou qamb qib igo qei der wot qamamir: “Wo munon sig uber.” qamamir. Ne qei der: “Ue aib, wo munon irou wurisesimar qib igo,” ende qamb wot asi qib igurei. ");
INSERT INTO wnu_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Gitarau qen aib eng se me uburau igama Yisas qi irab inorou munai mor end isub munon qob wuri nob qamb igoai. ");
INSERT INTO wnu_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ende at igama Yuda qibi gab tumbet wogub qamamir: “Wa, munon eng maigas at buk wanunger igo? Wo skurt me isau?” ");
INSERT INTO wnu_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ende qamarari Yisas taui qamar: “Ye qob aninob quraum eng yonou qob ue, Qenu wonou yiimurima derem eng wonou qob. ");
INSERT INTO wnu_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Munon ger mom Qenu mi qenungar igo eng mom toat igoum qamb gab eng ye qob quraum eng qerei imbiginer. Imbig ne mai, yonou misirt qob qamb igoum qiyo, Qenu wonou qob eng ye qamb igoum qi eng qerei giner. ");
INSERT INTO wnu_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Munon ger wonou misirt qob ger ende at qamb eng qen yegaiar qamb ebeiba. A, munon ger wo imurima derer eng wo igo munon imurieminer eng wonou qomon uber end qob sueiner eng qeemben, wo qetopur me qemerinerei. Qob apand qas qemeriba.” ");
INSERT INTO wnu_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ende qamb qamar: “Qoan Moses an qomon ger toat igoarar qamb gumaterei qiyo, ue? Qomon eng an bais me toat igoumon eng ye meimet qamb yanamb ebet igoumon?” ");
INSERT INTO wnu_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ende qamara munon yurau aib eng taui qamamir: “Ne maurem noopuri igama eng at quran eng, mai your sir ger nanamb at igama gab quran?” ");
INSERT INTO wnu_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yisas taui qamar: “Eng ye sarau aib ger ebine an misir soagen igub igoumon. ");
INSERT INTO wnu_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Eng Moses wo aninou munonbor wau eng goan soopurmatarari sirigum nob igoarar qamb. Ego qomon eng Moses me qanam bigau, aninou tonoanb qanam bigumirei. An see eng goan soopurmatau qomon eng inorou qen eng biistet munonbor wau git goan soopurmatar igoumon. ");
INSERT INTO wnu_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","An git apand Moses qomon tooun qamb munangit wau inorou qent goan soopurmatar igoumon eng uber. Ego ye bo inorou qent munon wurimusine yegab meimet qamb yet misiringet igoumon? ");
INSERT INTO wnu_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Eng gab ne an mi mugenderi gab ne mom gaun qamb me qereimar. Qomon apand igo end mi qereimunon eng qeemben buriba,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ne Yerusalem munon qei der qamamir: “Munon eng dara warambour qamb igour eng qiyo? ");
INSERT INTO wnu_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ende gab eng wo munon mag diban qob qamb igemerei eng munon ger mindigar qob me wot qamarau. Mai, munon baraitari gaur eng wo mai apand ‘munon inubersieriba tari’ wot qamb igour eng ion gab wogour qiyo? ");
INSERT INTO wnu_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","End ne munon wurimusiau tari eng wo deriner end ete wot qamb igurei: ‘munon eng wo deriner eng wo munai ginam qenen eng munon gugum me imbigunorei,’ ende qamb igurei. Ego, munon eng wonou ginam qenen eng in gugum qoyam, ego wo meimet qamb ende qamb igo?” ");
INSERT INTO wnu_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ende qamarari Yisas inorou munai aib mor end igo atag qamb ab wurinob qamar: “An mai ye mom yiimbig ne yonou ginam qenen eng gor mom musub imbig igoun qamb quraumon ne? Eng ye yonou misirt me darau. Munon ye yiimurima derem eng wonou qomon eng apand. Wo git eng an gugum qoyam ue. ");
INSERT INTO wnu_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ye gari wonou yiimurima derem end musub mom imbig igoum.” ");
INSERT INTO wnu_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ende qamara warigesi baab tourimb qamb ebetemir eng wonou qen eng se qiren nami igoar end me beau. (Yisas wo qen qiren igoar eng wonou imbigorei. Munon eng wuri booub qamb at wagomir eng wuri sir me imbigau, ar wogoun qamb wagomirei.) ");
INSERT INTO wnu_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Munon yurau aib eng Yisas booub qamb ende abari ne qei der Yisast oabigumir eng qamamir: “Io, Munon inubersiau tari eng wo darab ‘sarau wes-wes ebeiba’ ende qamarari igub igoun eng. See wen mom der sarau wes-wes abar eng,” ende qamamirei. ");
INSERT INTO wnu_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ne Parisi munon der munon yurau aib eng qei der Yisast oabig ende at qamb qib igamari igub Parisi ne Qenut mian iset big igour wurinou gigit eng nob erogori wurinou burtuum wuriimurimari yar Yisas baab tourimar qamb. ");
INSERT INTO wnu_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ende abari Yisas der wurinob qamar: “Ye aninob qen piten igoribam. Igoi wogub bo munon yiimurima derem end iribam. ");
INSERT INTO wnu_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Irine an yegoub qamb asiomunon eng me yegunanei. Ye irab eret igorini qi eng gor an me irunanei.” ");
INSERT INTO wnu_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ende qamara Yuda munon der wurinou-wurinou qamamir: “Wa, munon eng eret qoa in maigas me gunei igama ende at qura-a? Mai wo ininou munon Yuda isub Grik munon wurinob sori igour eng wurit isub Grik munon qob wuriimbigib qura qiyo?” ");
INSERT INTO wnu_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Wo qurar eng, in wo gub qamb asiomun eng me ginei. Ne gor, wo irab eret igorini qi eng gor in me irunei. Qob ende at qurar eng qanam git maigas?” ende wurinou-wurinou ende at qamb igurei. ");
INSERT INTO wnu_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ne inorou qen mi at nub igour eng is uburib pisia ne qen sindomund end sig-sig mi aib qamb at nub igour. Qen end Yisas der naget wurinob qamar: “Munon ger yat ebet gab eng yet yarab ya eng niner. ");
INSERT INTO wnu_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Qenu qob qoan gumatemir eng ete igo end, ‘Munon ger yet oabiginer eng ya uber munon nub bebereg igoriner eng wot igo ya poug gas ende tubub diara igoriba.’ ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yisas yat mit big qamar eng qen geret wo umb wogub bo der bugab qite irab munon wot oabigunor eng Qenu wonou Igomurur qau wurit imurima deriner end qamarei. Qen end Yisas Qenu ginam uber me iroau end ne Igomurur qau se me darau. ");
INSERT INTO wnu_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Munon yurau aib eng igour eng Yisas qob ende at qamara qei der qamamir: “Munon eng apand Qenu qob gigit qamarau munon tari.” ");
INSERT INTO wnu_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ne qei der: “Munon inubersieribar eng.” Ende qamarari ne qei der: “Ue, munon inubersieribar eng wo, mai ai Galili end deriba qiyo? ");
INSERT INTO wnu_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Qob qoan ete qamb gumatemirei: ‘Munon inubersieriner eng wo Debit tumbigi end deriba. Qoan Debit wonou ginam igoa Betlehem end unor baiba.’ ");
INSERT INTO wnu_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Qen end munon yamangar wurinou Yisast ende at qamb wogub bo yurau purab tau-tau isumirei. ");
INSERT INTO wnu_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ende at ne qei Yisast me oabigumir eng der Yisas baab tourimb etemir ego wonou qen se qiren igo end wugumirei. ");
INSERT INTO wnu_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ende at ne bur tuum bo munon mian iset big igour yurau eng nob Parisi eng nob wurit isari wurinob qamamir: “Meimet qamb munon eng me mot diaumon?” ");
INSERT INTO wnu_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ende qamarari wuri der wurinob qamamir: “Qoan munon ger munon eng qob at qura nami ende ger at me qamb igamau, wo wonou wes ar at qurai.” ");
INSERT INTO wnu_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ende qamarari Parisi der qamamir: “An gor qob qei anmurimar qurai? ");
INSERT INTO wnu_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Mai, qob ende at qamara ininou munon baraitari ne Parisi qei wo qob end wot oabig abari menman ibigumanei qiyo? ");
INSERT INTO wnu_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Munon yurau aib eng wuri Moses qomon gumater eng wuri sir me imbig obour eng wuri Qenu menmant qo boruburemirei.” ");
INSERT INTO wnu_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ende qamarari ne munon ger unum Nikodemus, wo qoan itum wobon Yisast irer eng, wo der qamar: ");
INSERT INTO wnu_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Ininou qomon eng, munon ger song ar ba uyort big ende me at igoun, ue. Wo nob qumurune wonou meimi qomon boru ger ebeiner eng qamara musub imbig ne uyort big igoun.” ");
INSERT INTO wnu_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","53","Ende qamara wuri taui qamamir: “Ende gab eng ne gor Galili munon qiyo? Ne qomon qob gumatemir eng musub wanunger imbig ginen eng, ‘qob gigit qamarau munon ger Galili end me derinerei’ ende qamb gumatemirei igo.” ende qamamirei. ");
INSERT INTO wnu_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Eng ende at wogub ne munon yurau aib eng wurinou munai mor iua uburari ne Yisas wonou gari ai qaur nam Olib irou igo end irarei. ");
INSERT INTO wnu_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","End ir inerei igo urigerama itumut bo yonam inorou munai aib end isa munon yurau aib bo yarari end bugab qanambig qob wurinob qamb igoai. ");
INSERT INTO wnu_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ende at igama qomon qereimau munon eng ne Parisi der yamangar ger munon nob qib igoar eng mot yar wobunobun et nagasiamirei. Nagasi ne Yisas nob qamamir: ");
INSERT INTO wnu_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","“Imbigau Munon, yamangar e wonou umami wogub munon ger nob qib igama mag bubur gab igoun. ");
INSERT INTO wnu_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","End ne Moses qomon gumater eng ete: yamangar ger ende aba gab eng nomont waramari umb qas weginer. Ende igo end ne ne maigas misir igan?” ende qamamirei. ");
INSERT INTO wnu_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Wuri Yisas warigesi ende nob qumurune Yisas wo qob ger soagensi qamara baab uyort bigub qamb Ende qamarari wo qob ger me qamarau. Wo ar qumor igo uben qaurt ai qoamint ingong big igoai. ");
INSERT INTO wnu_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ende at igama qebi qamb igamari Yisas mi duruges der naget qamar: “Munon ger qomon boru ger me ebet igo gab eng wo qen qamart nomon ba yamangar e waraminer.” ");
INSERT INTO wnu_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ende qamb wogub bo qumor uben qaurt ai qent ingong big igoai. ");
INSERT INTO wnu_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Yisas ende wurinob qamara igub wogub gari-gari der naget ag isub igurei. Munon isig-isig gigit isari wau moi qanamt. Ende isub uburari Yisas gari mor end igo ne yamangar eng mot isub nagasiamir eng ende igama. ");
INSERT INTO wnu_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yisas mi degesi nob qamar: “Munon eng eret igour? Munon ger ne qob me musitour qiyo?” ");
INSERT INTO wnu_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ende qamara yamangar qamar: “Io, munon ger ue.” Ende qamara Yisas bo nob qamar: “Ye gor ne qob me musitoum, ego ne wogub isub qomon boru ger bo sabar me eb.” ");
INSERT INTO wnu_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yisas yamangar eng ende nob qamb wogub ne bo munon gugum wurinob qamar: “Ye ai e begent igoar qamb deremei. End ne munon ger ye yetoat qib igoriner eng begen end igo ne igomot igoriba.” ");
INSERT INTO wnu_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ende qamara Parisi munon yurau qei eng der nob qamamir: “See nonomit qas qob nausi quran eng in igoun eng qob ger segagam me igoun.” ");
INSERT INTO wnu_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ende qamarari Yisas bo taui qamar: “Segagam, git eng yonomit quraum. Ego, ye eret igo derem eng ne bo iribam eng yonou imbig igoum. A an ye ginam qenen igo derem eng ne bo iribam eng an qoyam ue. ");
INSERT INTO wnu_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","End ne an munangit qomon end munon qerei igoumon. Ye ende ue. ");
INSERT INTO wnu_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ye munangit qomon end munon ger qereimin eng qeemben buriba. End ne sarau eng abau eng yet gari me igo. Ye Tain wonou yiimurima derem eng ye yoopuri igo yonob ebeiba. ");
INSERT INTO wnu_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","End ne aninou qomon eng ete qamb gumatemirei igo: munon ombur qob geret qeemben qomorunor eng segagam qomorubour. ");
INSERT INTO wnu_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Eng gas ende ye yonomit qemerine ne Yonou Tain yiimurima derem eng gor yet qamb igo.” ");
INSERT INTO wnu_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ende qamara wuri der qebi qamamir: “Ne Tain eret igo?” Ende qamarari Yisas qamar: “An ye me yiimbigoumon eng yonou Tain gor an me imbigoumon. A ye yiimbig ende qi eng Tain gor imbigoumon qi,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yisas qob eng wurinob qamb igoar eng inorou munai mor end Qenut nomon qur big igour qani end. Qob ende qamb igama wonou umau qen pi me yarau end munon ger baab waramb misir me igau. ");
INSERT INTO wnu_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yisas qob eng bo sabar wurinob qamar: “Ye qoaibam qen eng piara. Quine yegoub asi qibi wogub aninou uyes qomon boru ten umuboumon. Ye eret qoaini qi eng an sir me imbigunanei.” ");
INSERT INTO wnu_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ende qamara Yuda qamamir: “Munon eng ete qurar eng, ‘ye qoaibam munai ginam eng an sir ue’ qurar eng. Mai wonomi waramb umib ende at qura qiyo?” ");
INSERT INTO wnu_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ne Yisas taui qamar: “An munon ag e, ye munon erer. An munon ai qent e, ye munon ai qent et igo gab me. ");
INSERT INTO wnu_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Qanam end ne aninob quraum eng. Ye your qi eng an ye me yiimbigoumon end qomon boru ten umuboumon.” ");
INSERT INTO wnu_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ende qamara wuri qamamir: “Ende eng ne ne git your?” Ne Yisas taui qamar: “Ye qanambig qob maigas aninob qemerine igomanei? ");
INSERT INTO wnu_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ye qob irou aninou qomon end qereimb qamb misir igoum eng me aninob qemerinei. End ne munon ye yiimurima derem eng wonou qomon eng segagam qas. Ye meimi qob aninob qamb igoum eng wonou ye nob qamara igub qamb igoum.” ");
INSERT INTO wnu_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ende qamara wuri Yisas urt qamb igoar eng qanam sir me imbigau. ");
INSERT INTO wnu_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ende abari Yisas der qamar: “Munangit wau baab erer uri waramari uminer qen end ye your qi eng an yiimbiguboumon. Ende at ne ye mi see ebeteri igoum eng gor imbiguboumon. Yonou misir mi ger me oboum, ue ar. Tain wonou mi yonob qamara igub qamb igoum. ");
INSERT INTO wnu_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","End ne munon ye yiimuriamor eng ye opuri ten igo, bais ye wogub mugenderi me isub igo. Mi gugum ye ebet igoum eng wonou ye eb qamb yet qura eng gari ebet igoum.” ");
INSERT INTO wnu_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yisas qob ende at qamara munon irou igub wot oabigumirei. ");
INSERT INTO wnu_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ende abari ibag Yuda munon yurau qei wot oa bigumir eng wurinob qamar: “An munon yet oa big gab eng ye qob animbig quraum eng gor toat eng an yonou yurau tetemi. ");
INSERT INTO wnu_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ende ebet ne qob apand eng imbigari qob eng ansiara an uber igoruboumon.” ");
INSERT INTO wnu_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ende qamara wuri qamamir: “In Abraham wonou tumbigi, end ne in munon ger ar wot me sarau betet igoun. End ne in bo sabar maigas ebet uber igorubune init quran?” ");
INSERT INTO wnu_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ne Yisas qamar: “Segagam aninob quraum, munon gugum qomon boru ebet ten igour end ne qomon boru eng munon ger wau ar mamin beau gas ende. ");
INSERT INTO wnu_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Munon ger wau ar mamin beiner eng qenen wonou munai mor end me igorinerei, munon eng wonou wau ten eng apand qenen ur munai mor end igoriba. ");
INSERT INTO wnu_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","A munon eng wonou wau ten eng at wau sarau betet igoriner eng mom banamsieriner eng wau ur eng der wau mamin beiner eng nob qamara qenen ar ibeibi mor eng igoriba. ");
INSERT INTO wnu_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","An Abraham tumbigi eng ye qoyam, ego ye qob animbig quraum eng an musub me imbig ne yanamb at igoumon. ");
INSERT INTO wnu_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ye mi qamb igoum eng yonou tain yonob qamara qamb igoum. A an mi ebet igoumon eng aninou tain aninob qamara igub ebet igoumon.” ");
INSERT INTO wnu_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ende qamara wuri taui qamamir: “In Abraham wau tumbigi.” Ne Yisas taui qamar: “An apand Abraham wau tumbigi gab eng Abraham wonou qomon ebet qiyo sarau ebet igoa qas ende abar. ");
INSERT INTO wnu_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ye qob aninob quraum eng segagam Qenu qamara igub aninob qamb igoum. Ego aninou bo yanamb at igoumon eng. Abraham qomon ger bais an oboumon qas ende me abau. ");
INSERT INTO wnu_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","An qomon ebet igoumon eng aninou tain qamara igub ebet igoumon.” Ne wuri qamamir: “In ar ai qorut ue, in tain gari eng Qenu.” ");
INSERT INTO wnu_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ende qamarari Yisas wurinob qamar: “Qenu apand aninou tain ende qi eng ye yeqenungoumon qi. Ye der e igoun eng wo nob igo deremei. Yonou misirt me darau, wonou yiimurima deremei. ");
INSERT INTO wnu_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","An ye qob quraum eng maigas igub at ibitiri igoumon? Qanam eng an ye qob imbigunon eng misuu. ");
INSERT INTO wnu_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","An Satan wau tumbigi end wo gari qenunget at igoumon. Qoan ir wo qanambig igeigt munon igaramb igoai. Qomon qiyo qob apand eng wo ger pi me yar igamau. Wurimurimar qamarau eng wo qeemben. Wo munon wurimurimarau datou. ");
INSERT INTO wnu_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ye qob apand aninob qamb igoum eng an yet me oabigoumon. ");
INSERT INTO wnu_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","End ne an ger end, ye qomon boru ger ebet igimine dibes ye nob qemeriba qiyo? Eng gab ye qob segagam aninob qemerine meimet qamb me yet oa bigoumon? ");
INSERT INTO wnu_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Munon ye Qenu wau qamb eng wonou qob qamara igetet igour. An eng oboumon eng an Qenu wau ue minam. End wonou qob me igotoun qamb ibitiri ten igoumon eng,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ne Yuda munon wuri bo Yisas taui qamamir: “In eret qob susu ger qamb igoun? Ne gari Samaria munon, ai bigau noopuri igama qanganget qob susu qamb qib igoan.” ");
INSERT INTO wnu_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ende qamarari Yisas qamar: “Ye mi geret di me quraum, yonou tain unum apand dibes qamb igimine an ye yenugutumuget igoumon. ");
INSERT INTO wnu_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ye yonou qen big me at qib igoum. Munon ger wo qomon gugum qereiminer eng wo apand ye unum bererimb qamb ebet igo. ");
INSERT INTO wnu_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Segagam aninob quraum, munon ger ye qob quraum eng iruges big igub toat eng bais me uminerei.” ");
INSERT INTO wnu_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ende qamara Yuda taui qamamir: “See ne mom niimbigoun, ne ai bigau noopurima ten igo qob soagen qamb qib igoan. Abraham ne Qenu qob gigit qamarau munon eng qoan umb uburemirei. End ne ne mai your igo, ‘munon ye qob igisab eng me umunorei’ quran? ");
INSERT INTO wnu_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ininou tonoan Abraham ne Qenu qob gigit qamarau munon eng ne ue igama umb uburemirei. Ne your igo bo sabar at qib igoan? ");
INSERT INTO wnu_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ne Yisas taui wurinob qamar: “Ye yonomi qen big yegaiar qamb ebein eng bo mi ar gas ende buriba. End ne munon ger ye qen yegab ye qenungar eng yonou Tain, wot an ‘ininou Qenu’ qamb igoumon eng. ");
INSERT INTO wnu_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Eng an wo sir ue, ye wo sir. End ne ye ete at qemerin eng: ‘Ye wo sir ue’ qemerin eng ye munon qetopur qamarau tari, an gas ende. Ye wo mom imbig igoum end wonou qob eng toat igoum. ");
INSERT INTO wnu_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Aninou tonoan Abraham wo ye yegeib qamb mismisir igoai. Igoi yegab wogub uberetarei.” ");
INSERT INTO wnu_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ende qamara Yuda qamamir: “Ne togun 50-ende me warau igama Abraham wo igoar eng mai ye gab igumei qamb qamb igoan?” ");
INSERT INTO wnu_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ende qamarari Yisas taui qamar: “Segagam aninob quraum, Abraham unor me baiau igama ye igoum eng see gor igoum.” ");
INSERT INTO wnu_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ende qamara igub Yuda munon wuri nomon ba waramb qamb abari wo inorou munai mor end igo umanger qi qorei. ");
INSERT INTO wnu_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ende iua ne tap isub igo gar eng munon ger mag tuum unor set ende baurei. ");
INSERT INTO wnu_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ende gab ne wonou imbigau yurau eng der nob qamamir: “Barai, munon e mag tuumtar eng, mai your qomon boru aba mi seara ebeterei? Mai wonou qiyo, ur unor abari mag tuumtarei?” ");
INSERT INTO wnu_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ne Yisas taui qamar: “Munon eng mag tuumtar eng wonou qomon boru aba qiyo ur unor qomon boru abari mi seara mag me tumarau. Qenu wonou sarau ne wonou qomon eng munon e musia bo sema munon gugum gab wo imbigar qamb wonou seara mag tuumtarei. ");
INSERT INTO wnu_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Woromt eng in munon ye yiimurima derem eng wonou mi segitouboun. Itumarama eng bo sabar mi me sigiunei. Munon ger itum mi me segub igo. ");
INSERT INTO wnu_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","See ye ag e igimine ai e begent igo.” ");
INSERT INTO wnu_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","7","Yisas ende qamb eru ger ba mu mendir bea biera ne munon eng mag end qosub ne nob qamar: “Ne isub Siloam ya tumun end menman birogoniom.” (Siloam qob eng qanam eng ete: Imurimine isa). Ende qamara munon eng isub menman birogonima mag uber asi bo yonam irarei. ");
INSERT INTO wnu_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Irab qib igama wonou ginam qenen eng ne munon ar qei munon mag tuum eng qenen bugab ig nomon qur yeisar qamb qibirat qamb igoar eng ion gab qamamir: “Wa, munon eng mai, munon mag tuum bugab ig mi yeisar qamb qenen qibirat qamb igo eng qi-i?” ");
INSERT INTO wnu_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ende qamarari qei der qamamir: “Eng wo gari.” Ne qei qamamir: “Eng wo ue, munon ger wo gas ende.” Ende qamb ebet igamari munon eng wonou der wurinob qamar: “Ye munon ger ue, ye gari.” ");
INSERT INTO wnu_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ende qamara wuri der qebi qamamir: “Maigas at asiamanei?” ");
INSERT INTO wnu_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ende qamarari wo qamar: “Munon ger unum Yisas wo irumban ba ye mag qur et qosisab ete yonob qurai: ‘Isub Siloam ya tumun end menman birogoniom.’ Ende qamara ye isub menman birogoni igimine qen end qas asi mi gumei.” ");
INSERT INTO wnu_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ende qamara wuri qebi qamamir: “Munon eng wo eret igo?” Ne wo taui qamar: “Ye qoyam ue.” ");
INSERT INTO wnu_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ende qamara munon eng mot Parisi wurit isumirei. ");
INSERT INTO wnu_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Yisas munon musuor eng inorou qent. ");
INSERT INTO wnu_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Munon Yisas musuor eng ende mot isari Parisi der munon eng qebi qamarari wo wurinob qamar: “Wo irumban ba ye magt qosisa ne ye isub birogoni wogub bo musub asimumei.” ");
INSERT INTO wnu_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ende qamara Parisi munon qei der qamamir: “Munon eng Qenu bo me imurima darau aib. End inorou qen me gitara.” Ende qamarari qei der qamamir: “Munon qomon boru ten igoriner eng maigas sarau wonou wes eng ende ebeiba?” Ende qamb yurau purab tau-tau isumirei. ");
INSERT INTO wnu_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Eng ende at wogub ne Parisi bo sabar munon eng qebi qamamir: “Munon eng wo ne mag musia ubersi asiaman end wot maigas misir igan?” Ende qamarari wo qamar: “Munon eng wo apand mi qen geret dieriner eng wo qoyam imbi-imbi.” ");
INSERT INTO wnu_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ende qamara ne Parisi munon eng mag tuum ende unor baurei qamarari igub igour end mai apand qiyo qetopur qi ende qamb bo mom birisi igub qamb munon eng ur unor nob wurit qamarari yarari ");
INSERT INTO wnu_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","wuri qebi qamamir: “Munon e unor mag tuum end bauor eng see bo asi igo. Eng mai segagam aninou wau ten qiyo? Munon ger unor mag tuum baub igama bo is munon aib burab wogub bo sabar asieminer eng misuu.” ");
INSERT INTO wnu_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ende qamarari ur unor nob der qamamir: “Segagam e ininou wau ten unor mag tuum ende baurei. ");
INSERT INTO wnu_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ego wo mag bo asi qib igo eng in sir me imbigoun. Your mag weimatai qi eng wonou mom barai, qebi qamarari aninob qamara igar,” ende qamamirei. ");
INSERT INTO wnu_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Munon eng ur unor eng at qamamir eng munon Yuda wurit yari. Munon ger mai Yisast oabig wo apand Qenu imurima munon wuriubersieriba ende qamarari gab eng Qenu munai mor end me igoarar qamb wurisogar arirambour. ");
INSERT INTO wnu_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","End ne yari qamamir: ‘Wonou barai uber qebi qamarari aninob qamara igar,’ qamamir eng. ");
INSERT INTO wnu_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Qen yabt munon mag asiamor eng wot qamarari yara nob qamamir: “In qob gagam nausi nonob quraun. Ne Qenu wot oabig, munon ne nemusia mag asiaman eng in qoyam, wo munon uber ue. ");
INSERT INTO wnu_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ende qamarari wo taui qamar: “Ye sir ue, munon eng mai boru qiyo uber qi eng ye qoyam ue. Ego ye mag tuumtar eng bo yemusia asiomoum eng ye mom qoyam.” ");
INSERT INTO wnu_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ende qamara bo sabar qebi qamamir: “Eng wo maigas ne si ne mag nemusia asiamanei?” ");
INSERT INTO wnu_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ende qebi qamarari wo qamar: “Ye qoan aninob qemerine igoumon eng an me imbigoumon? Meimet qamb bo sabar-sabar ye qebi quraumon? An gor wonou imbigau munon yurau igorub quraumon qiyo?” ");
INSERT INTO wnu_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ende qamara wuri der qamat nob qamamir: “Nonou gari wonou imbigau munon igoar. In Moses wonou imbigau munon yurau igoun. ");
INSERT INTO wnu_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Qenu Moses nob qamara gumater eng gari toat igoun. Ne munon eng ne wot quran eng wo eret dererei qi eng in sir ue.” ");
INSERT INTO wnu_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ende qamarari munon mag asiamor eng bo taui qamar: “An munon eng in qoyam ue quraumon eng. Ye munon ger qomon wes ende me obounor eng ye mag musia bo asiam end imbigoum. ");
INSERT INTO wnu_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","In gugum mom imbig igoun eng, Qenu wo munon mindigar qob ten igo wot qemeriner eng wo qob me igitinerei. A munon wot oabig ne wo mi ebeib qamb nob qemeriner eng segagam wo nonogursi igo. ");
INSERT INTO wnu_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Qoan ir munon ger unor mag tuum baia isi barai burab igama bo munon ger mag musia asiamorei ende me igub igoun, ue ar, see qas. ");
INSERT INTO wnu_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","End ne munon ger Qenu me imurieminer eng mi wes eng ende me ebeinerei.” ");
INSERT INTO wnu_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ende qamara wuri bo taui qamamir: “Nani qarig ir qibi wogub nebauor end ne qomon boru ten igo in inimbigib qamb quran?” Ende qamb wogub inorou munai mor end toat ag ariramirei. ");
INSERT INTO wnu_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Munon eng ende toat ag ariramari der qib igama Yisas gab nob qamar: “Ne Munangit wau end wot oabigan qiyo?” ");
INSERT INTO wnu_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ne munon eng nob qamar: “Barai, Munangit wau eng your? eng musub yonob qamara igub wot oabigibam.” ");
INSERT INTO wnu_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ende qamara Yisas nob qamar: “Ne qoan gab imbigon eng bo see nonob qobub igo eng.” ");
INSERT INTO wnu_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ende qamara munon eng qamar: “Barai, ye apand net oabigoum.” Ende qamb Yisas menmant end gamaur wat bugamorei. ");
INSERT INTO wnu_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ende aba Yisas nob qamar: “Ye munon ag e wuri qereimb qamb deremei. End munon mag tuumt igour eng bo asi mi gubour. A munon asi igour eng bo mag tuumtorubour. ");
INSERT INTO wnu_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ende qamara Parisi munon qei nob igour eng igub der qebi qamamir: “Mai in gugum bo mag tuumtorubune quran qiyo?” ");
INSERT INTO wnu_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ne Yisas taui qamar: “An mag tuum ende qi eng an qomon boru ger ue qi. ‘In mag nob mi gugum gab imbig igoun’ qamb igoumon end an qomon boru ten igoumon,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Qamb wurinob qamar: “Segagam aninob quraum, munon sipsip urim baub qamb eng sipsip wurinou tend end sir me isunorei. Wuri ar youn di orubor isub wai sipsip wuriba sumungasi igour. ");
INSERT INTO wnu_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","A munon sipsip wurinou ur eng wo tend end sir isub igo. ");
INSERT INTO wnu_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Wo isiba gab tend qoat igamau munon eng weimata isa sipsip qeir toau ion igub igamari wuri unungara mindiram goten igub yar igour. ");
INSERT INTO wnu_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ende at oromar ag der wuri unungar-unungar isa sipsip wuri mindiram goten igub qanam toat isub igour. ");
INSERT INTO wnu_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Munon ar ger isub wuri unungar oromar qoaib ebeiner eng bubu qogom igub qoaubour.” ");
INSERT INTO wnu_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yisas mit big ende wurinob qamara wuri qob qanam maigas qi eng sir me imbigau. ");
INSERT INTO wnu_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ende abari (Yisas) bo sabar wurinob qamar: “Segagam aninob quraum. Ye gari sipsip wurinou tend qanam. ");
INSERT INTO wnu_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Munon qei gigit yaremir eng wuri mi urim baiau tari. End ne yar qamarari igub sipsip iua uburemirei. ");
INSERT INTO wnu_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ye gari tend. Munon ger yet mor di eng igomot igoriba. Igo mor di ag der ende at mismisir igoriba. ");
INSERT INTO wnu_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Munon ar eng wo di sipsip igaramb bo sumungasi urim baub ende ebeiba. A ye diaum eng wuribaub musine qenen ya-ya burab igomot igorubour.” ");
INSERT INTO wnu_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ende qamb bo qamar: “Ye sipsip musub mom oroar igoum. Munon sipsip musub oroar eng wonou git goan end misir me iginerei. Ar sipsip end qas wurit igub wonomi waramb umiba. ");
INSERT INTO wnu_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","A munon ar ger qur qas baib qamb wai sipsip musub me oroar igoriner eng mai qiyo iau uter sipsip orogarib yara gab yari qoaiba. Qoa iau uter yar sipsip orogar niba. ");
INSERT INTO wnu_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Munon eng wo sipsip wurit me igub igo, wo qurt qas sarau baab igo end qoaiba. ");
INSERT INTO wnu_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Ye sipsip musub oroar imbig igimine wuri gor ye musub yiimbig igour. ");
INSERT INTO wnu_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Eng gas ende Tain yiimbig igama ye gor Tain imbig igoum. End ne yonomit misir me iginei, ar yonomi waramb wurit umibam. ");
INSERT INTO wnu_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","End ne sipsip ar qei youn mor et me igour eng gor yonou. End ne ye wuri unungarine youn mor end yarab igo yonou mindiram goten imbigar qamb. Ende ebet ne see sipsip yurau ombur igour. Eng gab ende ebine yarab youn mor igour eng nob sori igamari ne munon oroar igamau eng gor gari qas igo oroar igoriner.” ");
INSERT INTO wnu_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ende qamb qamar: “Yonou git goan end misir me igub igoum. Ye ar yonomi waramb umb wogub bo der bugab iribam end Tain borusi ye qenunget igo. ");
INSERT INTO wnu_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","End ne munon ger ye yanama me uminei. Ye yonomi waramb umb wogub bo igomot der bugemin eng gor ye qeemben. Qob eng yonou Tain yonob qamara igub quraum,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Yisas qob eng at qamara Yuda igub wogub bo purab tau-tau isumirei. ");
INSERT INTO wnu_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ende at irou der qamamir: “Ai bigau opurima ten igo qanganget qob eng at qamb igo eng meimet qamb igetet igoumon?” ");
INSERT INTO wnu_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ende qamarari qei der qamamir: ‘Munon mi boru opuri igoriner eng qob ende at me qemerinerei. Ne gor munon mag tuum musia me uberburinerei,’ ende qamamirei. ");
INSERT INTO wnu_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Qen end Yerusalem inorou munai mondir qoan weiamir qen eng bo gab ne mi aib at nub qamb ne ir qiumuni igurei. Qen end ya tatabri igoar end qen gugum. ");
INSERT INTO wnu_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ende qiumuni igo ne Yisas inorou munai mor tumbigi ger sarog ar igoar eng Solomon wonou qamb igour end is qib igoai. ");
INSERT INTO wnu_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Qib igama Yuda munon yar qoui nob qamamir: “Ne qen mait qob eng at qamb igoan eng bo waga in Yuda yurau purab tau-tau isub igoun eng bo qiumuni qibanamsi igoruboun? Segagam ne munon Qenu inubersi qamb init imurima der igo gab eng see qas dibes ininob qamara igun.” ");
INSERT INTO wnu_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ende qamarari Yisas taui ete at wurinob qamar: “Ye qoan aninob qamam eng an yet me oabigoumon. Ye sarau ebet igoum eng Tain wonou qiribi ten end ebet igoum. Ye Tain itari igoum. ");
INSERT INTO wnu_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","An yonou sipsip ue end yet me oabigoumon. ");
INSERT INTO wnu_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Munon qei yonou wai sipsip apand gas eng yonou mindiram goten igub yetoat yorour. ");
INSERT INTO wnu_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Yarari ye wuri sierine qenen bebereg igorubour. Igo me umunorei, igamari munon ger bo yar yet me wuribainerei. ");
INSERT INTO wnu_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Tain ye mi yasab igo eng mi gugum wuritanami igo. Wo mi qoat igo eng munon ger wot ba bo wonou me sierinerei. ");
INSERT INTO wnu_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","In Tain nob ombur in qeemben gari,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ende qamara qen end Yuda bo nomon ba waramb ebetemirei. ");
INSERT INTO wnu_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ende abari Yisas der wurinob qamar: “Ye Tain wonou sarau sig uber eng at animbig igoum. Ego an ye meimi sarau bo soagen ger ebine gab yanamb at igoumon?” ");
INSERT INTO wnu_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ende qamara Yuda der qamamir: “In ne negaun eng sarau uber bea eng me nanamunei. Ne Qenu wot sai qob qamb a ne munon ar wau ego bo der nonomit ‘ye Qenu wau ten’ eng qamb bisa nanamb at igoun.” ");
INSERT INTO wnu_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ende qamarari Yisas taui qamar: “Aninou qomon tetemi gumataremir end Qenu ete qura: ‘An gor Qenu gas ende.’ ");
INSERT INTO wnu_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","In imbigoun eng, qoan qob gumatemir eng apand qenen igo eng an imbig igoumon end Qenu anit gor Qenu gas ende munon eng wurit qob eng qamarei igo. ");
INSERT INTO wnu_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Tain ye ag e yiimurimb qamb ye maribigor end yiimurima ag e deremei. End ne ye wonou sarau qoregen eng ebine an bo meimet qamb ‘Qenu suai qob wot qamb igo’ qamb yet qamb igoumon? ");
INSERT INTO wnu_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ende gab eng yet me oabigari gab eng yonou Tain sarau eng me ebeinei. ");
INSERT INTO wnu_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","End ne ye wonou sarau eng ebet igoum. End an ye qob quraum end me oabigub qamb eng, yonou sarau oboum end oabigar. Ende ebet ne an musub qerei imbig ne ete misir igar: “Tain yet igama, ne ye gor Taint igoum.” ");
INSERT INTO wnu_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ende qamara bo der baab uyort bigub qamb baab birupusimari der qorei. ");
INSERT INTO wnu_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yisas ende der iua bo yonam ya Yordan purab isub qoan Yon munon yat wurimaragansi igoar ginam end is igoai. ");
INSERT INTO wnu_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","End igama munon irou wot yar qamamir: “Yon wo sarau wes ar ger ende me abau. Wo munon eng der sarau ebeiner end ar qob suab qamar eng qeemben wot irimani igo.” ");
INSERT INTO wnu_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ende wot qamb munon irou wot oabigumirei. ");
INSERT INTO wnu_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Qen end munon ger unum Lasarus eng munai ginam Betani end igoai. Qen end wo toar aib wara inab igoai. Munai ginam Betani eng Maria umemi Marta nob wurinou ginam qenen. ");
INSERT INTO wnu_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maria eng wo qen geret Yisast isub welya qogom sig uber eng Yisas gotent igimetet wonou tari imt baimeteiner eng. Wonou umour Lasarus toar wara igoai. ");
INSERT INTO wnu_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ende igama umemi Marta der Yisast qob big qamar: “Barai, nonou munon banam sig-sig qenunget igoan eng toar wara igo.” ");
INSERT INTO wnu_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ende qamb qob biga Yisas igub qamar: “Lasarus wo toar wara eng me uminerei. Qenu wonou qiribiten eng wot aba munon gugum gab Qenu imbig ne wonou wau eng gor imbig ne wonou unum eng abari qiribiten igoar qamb. ");
INSERT INTO wnu_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yisas Maria Marta ne wurinou umour Lasarus ende wuriqenungar igoai. ");
INSERT INTO wnu_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Maria Lasarus toar wab igoar end Yisast qob biga igub qand me iroau. Igub wogub qen ombur ende bo ginam igoar end igoai. ");
INSERT INTO wnu_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Igo ne wonou imbigau yurau eng wuri nob qamar: “Bo girinari bo yonam Yudia irun.” ");
INSERT INTO wnu_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ende qamara wonou yurau eng der taui nob qamamir: “Barai, barim qas end qib igama Yuda munon nomont nanamb ebetemir eng me gab bo irib quran?” ");
INSERT INTO wnu_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ende qamarari Yisas qamar: “Mai, woromt eng mai qen dirigor qib igoun qiyo? Munon ger woromt qib eng uyor qiyo nam qabtai me qoimir yarisinerei, ai tap musub gab gib igo. ");
INSERT INTO wnu_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","A, itum urut begen ue eng qib eng apand uyor qiyo nam qabtai qoimir yarisieriba.” ");
INSERT INTO wnu_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yisas qob eng ende qamb bo imusi qamar: “Ininou munon banam Lasarus mungam naat inai. End ye irab menimbam.” ");
INSERT INTO wnu_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ende qamara wonou imbigau yurau eng der qamamir: “Eng wo ar inab igama ne meimet ir menimban? Wonou der bugemba?” ende qamamirei. ");
INSERT INTO wnu_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yisas Lasarus uma gab qamar eng wonou imbigau yurau eng wuri segagam inab igama gab qura qamb qamamirei. ");
INSERT INTO wnu_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Qamarari Yisas musub wuriimbig wurinob qamar: “Lasarus mom umorei. ");
INSERT INTO wnu_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ego ye anit igub mismisiraum. Eng ye wo nob me igimine umor end uber ue, ego an oabigar. Der nagari wo mumun ir gun.” ");
INSERT INTO wnu_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ende qamara Tomas, unum ger Didimas eng, wo der qei wurinob qamar: “Io, in gugum Yisas nob irab wo nob umun.” ");
INSERT INTO wnu_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ende qamb wogub Yisas nob irab gamir eng Lasarus qoan tumuniamirei igama qen 4-ende uburerei. ");
INSERT INTO wnu_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Munai ginam Betani eng sig pa ue, Yerusalem pi igoai. ");
INSERT INTO wnu_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","End Yuda munon irou yar Maria Marta nob umour umor end toubet abari yar wurinonogursi igurei. ");
INSERT INTO wnu_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ende igamari Yisas iroa gab qamarari Marta igub gib qamb ag der isorei. Isa Maria mor igoai. ");
INSERT INTO wnu_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta isub Yisas qataben gab nob qamar: “Barai, ne et igama ende qi eng yonou bain me umau qi. ");
INSERT INTO wnu_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ego see ye imbigoum ne mi geret qamb Qenu simot nob qamara eng neteiba.” ");
INSERT INTO wnu_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ende qamara Yisas nob qamar: “Ima bo igomot der bugemba.” ");
INSERT INTO wnu_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ende qamara Marta Yisas nob qamar: “Git eng ye imbigoum, qen sindomund end der bugemba.” ");
INSERT INTO wnu_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ende qamara Yisas taui qamar: “Umb bo igomot der bogomau eng ye qanam. End ne munon ger yet oabiginer eng song umiba, ego yet oabiginer end bo igomot der bugemba. ");
INSERT INTO wnu_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","End ne munon see igom igo yet oabigour eng qen geret me umunorei. Ne ye qob eng quraum end oabigan qiyo?” ");
INSERT INTO wnu_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ende qamara Marta qamar: “Io, see ye imbigoum. Ne Qenu wonou wau. Qoan inubersierib qamb qamar eng ne gari niimurima derenei.” ");
INSERT INTO wnu_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marta qob ende at qamb wogub bo irab umemi Maria qi nob qamar: “Imbigau munon quma di igo nenet qamb igo.” ");
INSERT INTO wnu_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ende qamara Maria qand der Yisas gib qamb isorei. ");
INSERT INTO wnu_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","(Qen end Yisas ginamt weib me iroau. Qoan igama Marta is gar up end igama Maria bo is garei.) ");
INSERT INTO wnu_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Qen end Maria qand der naget isa Yuda munon qei qoan umom uma is nob igour eng, ende gab mai umom tumunt end isub yeyeib qamb isa qi ende qamb toat isumirei. ");
INSERT INTO wnu_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maria ende isub Yisas gab menmant end wonomi arir inab nob qamar: “Barai, ne et igama ende qi eng yonou ima me umau qi.” ");
INSERT INTO wnu_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ende qamb ea gab munon Yuda Maria toat isumir eng gor eari ibag Yisas borusi wuritoubar wo gor yeib aterei. ");
INSERT INTO wnu_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ende abari ibag Lasarus tumuniamir end wurinob qamar: “Eret tumunimanei?” Ende qamara wuri qamamir: “Yara niimbiguboun.” ");
INSERT INTO wnu_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ende qamarari Yisas eerei. ");
INSERT INTO wnu_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ea gab Yuda qei der qamamir: “Wo Lasarus sig borusi qenunget igo end wot ear eng.” ");
INSERT INTO wnu_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ende qamarari qei der qamamir: “Munon eng wo munon qei mag tuumra bo wurimusia asi igour. Ego bo Lasarus musia ende qi eng me umau qi.” ");
INSERT INTO wnu_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ende qamarari Yisas bo sig-sig mom toubet wogub munon teteret isorei. Tumun eng nomon erobon goanet wogub tumun qabar eng nomon ger ba qipiotemirei. ");
INSERT INTO wnu_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yisas isub tumun qani end naget qamar: “Tumun qabar ba aisiarar.” Ende qamara munon umor eng wonou umemi eng Marta der qamar: “Barai, qo uma tumuniamin end tumun qabar weimune qogom sig boru dieriba.” ");
INSERT INTO wnu_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ende qamara Yisas (Maria) nob qamar: “Ye qo nonob qurumei, ne ye qob end oabig eng Qenu wonou qiribiten eng gab imbigiban.” ");
INSERT INTO wnu_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ende nob qamara wogub nomon tumun qabar qipiotemir eng ba aisiari Yisas mataramb asi qamar: “Io, Tain, nenet uber quraum. Ye qob quraum eng igu. ");
INSERT INTO wnu_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Git eng ye mi geret ne qebi qemerine me yombarir igoan. Ego munon see e igour eng mi e ebine gab ne ye yiimuriamon eng imbigar qamb. ");
INSERT INTO wnu_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Eng ende qamb ugab wogub qugiab qamb ar: “Lasarus, der bugab ag der.” ");
INSERT INTO wnu_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ende qamara Lasarus mumun mingoant ouri wogub ten tumuniamir eng ten der bugab ag dererei. Dara Yisas wuri nob qamara mingoan moniamir eng beasimetet wagari isorei. ");
INSERT INTO wnu_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Yisas qomon wes eng ende aba gab Yuda munon yar Maria nob igour eng qei wot oabigumirei. ");
INSERT INTO wnu_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ne qei misir qebebi igub wogub bo irab Yisas mi ebeter eng gugum Parisi yurau wurinob qamamirei. ");
INSERT INTO wnu_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Qamarari Parisi ne Qenut mian iset big igour eng end der kaunsel wurinob qiumuni qamamir: “Munon eng sarau sig uber wes ebet qib igo eng in mai sioruboun? ");
INSERT INTO wnu_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","In wugune qomon eng at qib igama eng munon gugum wot oabigubour. Ende abari Rom gab munon baraitari wuri diab in inorou munai borusi ne in munon yurau gari igoun eng gor abari purab wes-wes igoruboun.” ");
INSERT INTO wnu_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ende qamarari Qenut mian iset big igour wurinou baraitari aib eng wo togun end barai igoai, unum Kaiapas. Wo der wurinob qamar: “An mi eng bais me imbigoumon. ");
INSERT INTO wnu_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Munon gari qas in uput qamb umb wogub ne munon gugum inmusieriba. In ende me ebet igorun eng in gugum umb uburuboun,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Segagam Kaiapas wo qob eng at qamar eng wonou misirt me qamarau. Wo togun end Qenu mian iset big igour eng wurinou baraitari igoar end Igomurur qau wot diara Yisas qen geret munon Yuda yurau eng wurit uminer end qamarei. ");
INSERT INTO wnu_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Eng munon Yuda wurit gari ue, munon ai qent gugum wes-wes igour eng wurit umb ne wuri seara git goan gari gas ende burab Qenu wonou yurau gari igorubour end qamarei. ");
INSERT INTO wnu_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Qen end Yuda Yisas mom waramb qamb qob nausi qamamirei. ");
INSERT INTO wnu_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ende abari qen end Yisas bo Yuda wurit diban me qib igamau. Ginam igoar eng wogub bo seger ai qani end munai ginam aib ger igoar end wonou imbigau yurau eng wurinob is end igurei. Ginam aib eng unum Epraim. ");
INSERT INTO wnu_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Qen end Yuda wurinou Qenu tain qoanb wuri me igaramau qamb misir igub mi aib qamb at nub igour qen eng pi burerei. Ende aba ne munon ginam irou Yerusalem end irab qiumuni wurinou misir boru-boru eng qamb dibes wogub mi nub qamb iramirei. ");
INSERT INTO wnu_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ende irab qiumuni ne inorou munai aib mor end isub Yisas gub qamb asi qib igurei. Ende at qib igo wurinou qob-qob qamamir: “An qei mai misir igoumon? Munon eng mai, mi niau qen aib et wo gor dieriba qiyo?” ende qamb igurei. ");
INSERT INTO wnu_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Qen end Qenut mian iset big igour wurinou barai-barai eng ne Parisi yurau eng der, Munon ger Yisas eret igama gab imbig igour qi eng dibes qamarari igub baab uyort bigub qamb wuri nob qamb qib igurei. ");
INSERT INTO wnu_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Qen mi aib qamb at nub qamb etemir eng qen eng 6-ende igama ne Yisas Betani isorei. Ginam eng Lasarus wonou qoan uma Yisas meniamor eng wonou ginam. ");
INSERT INTO wnu_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Yisas end isa ne mi arsi nob nub qamb at igurei. Igamari Yisas Lasarus nob nam qabt bugab igamari Marta mani imi ba yar wurisa nub igurei. ");
INSERT INTO wnu_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Qen end Maria welya botolt igoar eng qogom sig uter maieng eng nomon qur aibt taui ba yarerei. Yarab it omboat Yisas gotent igi wogub wonou tari im end baimeteterei. Ende aba welya qogom eng munai mor eng yab igeramorei. ");
INSERT INTO wnu_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","5","Ende aba Yisas wonou imbigau yurau end ger, unum Yudas Iskariot (munon eng wo qen geret Yisas duiamor eng) eng wo der qamar: “Meimet qamb yamangar eng welya isi aba isub igo? Waga welya eng ba in munon qei wurisab nomon qur taui K300 ende baub qerei munon mi ue igour eng wurisau ue-e?” ");
INSERT INTO wnu_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Wo eng at qamar eng wo munon mi ue eng qerei werisun qamb me qamarau, wo mi urim baub igoar end yamangar eng nomon qur ende ba yar biga urim baib qamb qamarei. ");
INSERT INTO wnu_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ende qamara Yisas taui qamar: “Ne bo wobon end omboopur me qem. Wonomi abar eng wagari ende ebeiner. Qen geret ye yetumunimari yesieriner end wapet aba. ");
INSERT INTO wnu_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Munon mi ue eng qenen wuri nob igoruboumon, ego ye qenen me aninob igorinei,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Yisas ginam end igama ne Yuda qob igub yar wo gab ne Lasarus Yisas meniamor eng gor gub qamb yaremirei. ");
INSERT INTO wnu_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Qen end Qenut mian iset big igour munon barai-barai eng der Lasarus bo waramune uminer qamb qob nausiamirei. ");
INSERT INTO wnu_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Qen end Yisas Lasarus menima ne munon yurau irou Yisast oabig ne munon Pris yurau eng wuri wagari ibag etemirei. ");
INSERT INTO wnu_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Barim ende der bo inorou qen mi aib at nub etemir end munon yurau aib qiumuniamirei. Ende qiumuni igumir eng Yisas urigom end Yerusalem end dieriba ende qamarari igumirei. ");
INSERT INTO wnu_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Igub nam mun qamb qogum im qamb qug im qamb soroumi ba isub qataben gub qamb Isub gamir eng di igama gab wot mismisir qamb amir: Qenut mismisirun, Qenu wo munon eng opurima ten qib igo end in wo unum ba dibesiorun. Qenu munon eng Isrel wurinou Baraitari wurit maribigatarerei, ende qamamirei. ");
INSERT INTO wnu_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Qen end Yisas wai dongi ger erer bugab irarei. Qenu qob qoan ete qamara gumatemirei igoai: Io, Saion munon an me yarimar. See aninou baraitari eng wo bur dongi yeim erer bugab anit dieriba. Qob ende igoar eng toat ebeterei. ");
INSERT INTO wnu_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","16","Yisas wonou wuri imbigau yurau eng mi eng qen end ebeter eng wuri me imbigau. Igoi wogub qen geret Yisas umb wogub wonou wes at der bugab Qenu ginamt iroa ne wuri qob eng igoar eng imbig ne Yisas siamir eng gugum imbigumirei. ");
INSERT INTO wnu_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Qoan Yisas Lasarus tumunt igama wot qamara der bugamor qen end munon yurau irou igo Yisas mi eng aba gamir end qob suab qiroari munon irou igub ugamirei. ");
INSERT INTO wnu_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","End ne wo di igo qamarari igub wonou mi wes ebeter end nob gub qamb isumirei. ");
INSERT INTO wnu_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ende abari Parisi munon wurinou der qamamir: “Wa, in mi ger me ubunei. Munon gugum wo qob igub toat isubri igour,” ende qamamirei. ");
INSERT INTO wnu_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Munon inorou qen aib Yerusalem ite irab qiumuni Qenut uru wab mismisirub qamb iramir eng Grik munon qei morogot nob iramirei. ");
INSERT INTO wnu_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Grik munon eng iramir eng irab Pilip gamirei. Pilip wo Betsaida munon, ai aib Galili end igo, eng gab nob qamamir: “Io, barai in Yisas gub qamb yar nonob quraun.” ");
INSERT INTO wnu_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ende qamarari Pilip isub Andru gab nob qamb ombur isub Yisas nob ete qamamirei: “Grik munon nogoub qamb at qib igour.” ");
INSERT INTO wnu_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ende qamarari Yisas taui wurinob qamar: “Munangit wau sig-sig mom qiribiten buriner qen eng see. ");
INSERT INTO wnu_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Apand aninob quraum, wit qur eng umot ag der eng qaur di git irou baret igo. A umot ar boru geren qamb erer igoriner eng bo maigas der qaur di git irou me barierinerei. ");
INSERT INTO wnu_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Eng gas ende, munon ger wonou git goan me borusierini qamb ebeiner eng mom umiba. A Qenut igub wonomi duima waramunor eng qenen bebereg igoriba. ");
INSERT INTO wnu_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Munon ger yet ar sarau besab igo gab eng, ye yetaut qiriner. Ende ebeiner eng yonou ginam igoum end yonob igoriba. Igama Tain munon eng yenob sarau ebet igoriner end wot mismisiriba,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ende qamb qamar: “See ye yari ne oau uburab isa. Eng gab ne qob maigas at qemeribam? ete at qemerini eng uber qiyo? ‘Tain ye yanambour qen pi eng gab ye ba wabiom,’ ende qemerini qiyo? Ende ue, ye yonomi dui umib qamb deremei.” ");
INSERT INTO wnu_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ende qamb qamar: “Tain, nonou unum aba wonou wes dibenteriner.” Yisas ende qamara Qenu taui ete at qamara toau igumirei: “Yonou unum qo ebine dibentar end ne see bo sabar ebeine sig-sig mom dibent isiba.” ");
INSERT INTO wnu_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Munon yurau aib nogumor igour eng ende igub qei der qamamir: “Wa, eng mai ai qura a-a? ende qamarari qei qamamir: “Ue, Qenu enger ger nob qura.” ");
INSERT INTO wnu_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ende qamb abari Yisas der wurinob qamar: “Qob toau eng qamara igoumon eng ye yenonogursierib qamb me qura, an nonoguretarar qamb qura. ");
INSERT INTO wnu_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","End ne Qenu munon ag e wurinou qomon eng qereiminer qen eng see. Qerei ne munon baraitari see igo munon ai qent gugum oroar igo eng sogot ariramba. ");
INSERT INTO wnu_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ye erer big yanamari umine bo Tain ye mot erer qite iroa igorin qen end munon yamangar gugum wurit erine dearari yonou oromar igoribam,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","(Yisas wo qob eng at qamar eng wonou maigas at waramari uminer qi eng werei wuriimbig qamb igoai). ");
INSERT INTO wnu_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ende qamara munon yurau aib eng taui qamamir: “Ininou qomon qob end ete qamb gumatemirei igama igub igoun: ‘Munon inubersiau tari eng wo gari qenen bebereg igoriba,’ ende qamb gumatemirei, igo. Ego maigas ne bo ‘Munangit wau erer urimbour’ quran? Munangit wau eng your?” ");
INSERT INTO wnu_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ende qamarari Yisas taui wonomit qamar: “Begen eng aninob igoar eng isi yarab see anwegib piarar eng. Eng gab anwaga me gab eng an begen end qas qib igoarar. A mamirunon eng itum eng yar anmuaseremba. Munon yurau itum qib igour eng wuri begen eng eret qooiner eng wuri sir me imbigunorei. ");
INSERT INTO wnu_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Begen eng see aninob igo end wot oabig igorunon eng me gab eng an mom nonoguret begen eng wonou munon yurau igoruboumon,” ende qamarei. Yisas qob eng ende qamb ugab wogub isub wurit waber der qorei. ");
INSERT INTO wnu_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yisas sarau a qomon wes-wes baab ebeter eng munon yamangar bais ger me wot oabigau. ");
INSERT INTO wnu_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Eng ebetemir eng qoan Qenu qob gigit qamarau munon Aisaia ete qamb gumater eng irimaniamorei: Barai, your in qob quraun eng igub oabigiba? Ne gor, Munon Barai sarau wes ebeiner eng your imbig qamb ebeiba? ");
INSERT INTO wnu_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Eng ebet me oabig obounor end ne Aisaia bo ete qamarei: ");
INSERT INTO wnu_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Qenu mag wuri taisi ne misir ba sumungasiarei. End ne wuri mi musub me gab ne misir gor uber igub mi me imbigunorei. Ende ebet yet oabigari gab me wuri musierinei. ");
INSERT INTO wnu_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaia qob eng at qamar eng Yisas ag e darab sarau qeretut nob ebeiner eng qo imbig qamarei. ");
INSERT INTO wnu_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Yisas sarau ende aba Yuda munon baraitari irou wot oabigumir ego Parisi wurit yari dibes me qamarau. Qamarari inorou munait wuri ba agiomunor qamb. ");
INSERT INTO wnu_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Wuri ebetemir eng Qenu ibag mismisir qamb me abau, munangit qen inimbagaiar qamb at igurei. ");
INSERT INTO wnu_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ende abari Yisas qugiab wurinob qamar: “Munon ger yet oabig eng yet gari me oabiginerei. Munon ye yiimurima derem eng gor wot oabigiba. ");
INSERT INTO wnu_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ne ye yegab eng gor ende sig. Tain yiimurima derem eng gor gab igo. ");
INSERT INTO wnu_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ye ag e derem eng begen ten deremei. End ne munon gugum yet oabig eng itum end me igorunorei. ");
INSERT INTO wnu_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Your ger ye qob qemerine iruges big me iginer eng ye wonou qomon eng me qereiminei. Ye ag e derem eng munon wurinou qomon eng qereimb me darau. Ue, ye munon gugum wurimusierib deremei. ");
INSERT INTO wnu_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","End ne munon ger ye yombarir ye qob qemerine me iginer eng ye me qereiminei, munon ger qereimba. Qen sindomund end ye qob e quraum eng igoi munon eng qereimba. ");
INSERT INTO wnu_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ye qob e gagar aninob qamb qib igoum eng yonou misirt ger me qamb igoum, sig ue. Yonou Tain yiimurima derem eng wonou gari ye qem qamara qamb qib igoum. ");
INSERT INTO wnu_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Tain wo qob eng munon igub qenen bebereg igorubour, ye eng imbig ne Tain wonou ‘qem’ ende yonob qamara qamb qib igoum,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Yuda wurinou inorou qen aib gab mi at nub igour eng se igoai. Igama Yisas ur qani irib ater eng qen pibura gab wonou munon yurau wuri qenungar igoar eng bo borusi wuritoubar wogub umib aterei. ");
INSERT INTO wnu_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Qen end ai gab-gab Yisas wonou wuriimbigau yurau eng oromar bugab mi nub igama ne Satan qo Saimon Iskariot wonou wau Yudas eng oau menima ne Yisas munon qarau wurit duimine waramar qamb misir igorei. ");
INSERT INTO wnu_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yisas qo imbigorei, Ur sarau gugum wot wagerei. Ne gor Qenu imurima derer eng bo qani irib ater eng gugum imbig igoai. ");
INSERT INTO wnu_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Yisas ende bugab mi wurinob nub igo ne put der naget ne mingoan beasi big ya ubet baimau mingoan eng qumaniamorei. ");
INSERT INTO wnu_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ende at ya ba qamami tabin aib end waari ne wonou wuriimbigau yurau eng goten birogonimatar ne mingoan qumaniamor end baimatarerei. ");
INSERT INTO wnu_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ende at isi yarab Saimon Pita goten birogonimeteiba wo der nob qamar: “Barai, ye goten gor birogonimiseiban ne?” ");
INSERT INTO wnu_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ende qamara Yisas nob qamar: “Wo mai, see ye mi e oboum eng ne qanam sir me imbiginenei, qen geret imbigiban.” ");
INSERT INTO wnu_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ende qamara Pita qamar: “Ye goten bais me birogonimiseis, sig ue ar.” Ende qamara Yisas nob qamar: “Ye ne goten me birogoniemin eng ne ye nob me igorinenei.” ");
INSERT INTO wnu_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ende qamara Pita qamar: “Ende gab eng ye goten qas me birogoni wog, ye uben tarinob gugum birogonimiseis.” ");
INSERT INTO wnu_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ne Yisas qamar: “Munon gugum ya se qas git goan gugum ubet eng bo sabar gugum me ubet igour, goten qas ende birogoni igour. End ne an qei git goan uber igoumon ego gugum ue.” ");
INSERT INTO wnu_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","(Yisas qamar eng, “An gugum uber ue” qamar eng wonou imbigau yurau end gari qas wo munon qarau wurit duima waramunor end qamarei.) ");
INSERT INTO wnu_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yisas goten ende birogonimatar bis ugab wogub wonou mi goan bo naget wogub munai up end is bugab wurinob qamar: “An gugum ye mi see qas e oboum eng an imbigoumon qiyo?” ");
INSERT INTO wnu_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ende wuri qebi qamb qamar: “An yet qenen Imbigau munon Barai” yet qamb igoumon eng uber. Ye eng gari. ");
INSERT INTO wnu_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ye aninou Imbigau munon Barai, ego ye aninou goten biroginimotoroum. Eng gas ende aninou bo der ger goten birogonimetet ende at bisar. ");
INSERT INTO wnu_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ye ansiaum eng an imbigar qamb. Eng gas ende an bo munon qei ende wurisiarar. ");
INSERT INTO wnu_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Apand aninob quraum, wau gogor ger munon barai ger ba nob igoriner eng wonou gigit me igorinerei. Ne gor munon barai ger wau ger sarau eb qamb imurieminer eng wau eng isub munon imurieminer eng wonou baraitari me igorinerei. ");
INSERT INTO wnu_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","An ye mi eng aninob quraum eng ende ebet eng uberetoruboumon.” ");
INSERT INTO wnu_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Ende qamb bo wurinob qamar: “Ye qob eng aninob quraum eng an gugum ende me ubunanei yono anqereiam eng gari ende obouboumon. End ne Qenu qob ete gumatemir igo eng irimanimba: “Munon ger ne nob tabin garit mi nub igorunon eng ne duima umiban.” ");
INSERT INTO wnu_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Qob eng se me irimanimau igo. Igoi qen geret irimanima gab an yet oabig “io”, qamb “munon eng wo gari” ende yet qomoruboumon. ");
INSERT INTO wnu_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Segagam aninob quraum, munon ger yonou sarau munon imurimine isiner eng wo musieriner eng ye yemusiau gas ende gari. Ne ye yemusieriner eng Tain yiimurima derem eng musub igo.” ");
INSERT INTO wnu_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yisas qob eng ende qamb ugab wogub boru misir igub dibes wurinob qamar: “Segagam aninob quraum, erogori e bugab mi nub igoun end ger ye yeduima yanambour,” qamar. ");
INSERT INTO wnu_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ende qamara wonou imbigau yurau eng me imbig yourt qura qamb der wurinou qigab bis ariramirei. ");
INSERT INTO wnu_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Qen end wurinou yurau erogori end ger Yisas sig-sig mom qenunget igoar eng Yisas bogama qani end bugab igoai. ");
INSERT INTO wnu_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ende igama Saimon Pita magqurt qas munon eng nob qamar: “Ne qani bugab igoan end qebi ge, yourt qura qi?” ");
INSERT INTO wnu_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ende qamara munon eng inumor isub Yisas iruges irut qebi qamar, “Barai, ne yourt quran?” ");
INSERT INTO wnu_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ende qamara Yisas taui qamar: “An yegab igamari, ye mani tau ger ba yorut yaninget munon eng utine gab eng mom imbigar, munon eng ye mom yeduimba.” Ende qamara gab igamari mani tau ger ba yaninget Saimon Iskariot wonou wau Yudas eng uterei. ");
INSERT INTO wnu_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yudas mani eng ende ba nia Satan Yudas misir bumaima Yisas duimb qamb misir igorei. Igub aba Yisas nob qamar: “Ne mi ebeib qamb eng qand eb,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Yisas qob eng at Yudas Iskariot nob qamar eng munon nam qabt bugab igour eng ger me imbigau. ");
INSERT INTO wnu_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ne qei der ete misir igumirei: “Mai Yudas Iskariot wo nomon qur qoat igo end mai ende nob qamara nomon qur qei qerei bisub mi aib at nub etemir end mani taui ba di qamb nob qura qiyo,” qamamir. A qei der, “mai munon mi ue eng mi qei qerei weris qamb nob qura qi,” ende qamb qanganget igurei. ");
INSERT INTO wnu_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Qen end itum, end Yisas mani tau Yudas uta baub nub wogub qi der Yisas duimb qamb qorei. ");
INSERT INTO wnu_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yudas ende der qoa wogub Yisas der wonou wuriimbigau yurau qei eng wurinob qamar: “Ne munangit wau wonou qiribiten eng dibeneribar eng. Ende aba Qenu wonomi wes eng wonou wau end ebet wonomi ba dibesieribar eng. ");
INSERT INTO wnu_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Wonou wau eng ur ende ba dibesia ne ur wo der wonou wau sig-sig mom unum bererimba. Ende at qand unum aba dibeneriba. ");
INSERT INTO wnu_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Io, ininou erogori qib igoun end ete aninob qemeribam: “Ye bo me aninob igorin eng qen pibura. End ne qoan Yuda wuri nob qamam eng an bo aninob quraum. Ye eret qoaini qi eng an bo ye me yegunanei. ");
INSERT INTO wnu_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","End ne qomon bubun ger aninob qemeribam eng: Ye anqenungar igoum gas ende aninou ende qiqenungaiar. ");
INSERT INTO wnu_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ende qiqenungari munon ar animbag eng ete qomorubour: “Qo, yurau eng Yisas wonou wuriimuriamorei.” ende anit qomorubour.” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Yisas ende qamb bis ugeab Saimon Pita der qebi qamar: “Barai, ne eret qoaiban?” Ende qamara Yisas taui qamar: “See ye eret qoaibam qi eng ne me yenob qooinenei. Qen geret yenob qiriban.” ");
INSERT INTO wnu_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ende qamara Pita bo der qamar: “Barai, meimet qamb me nonob qiribine quran? Ne uput qamb umib at igoum.” ");
INSERT INTO wnu_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ende qamara Yisas bo der taui qamar: “Ne segagam ye uput qamb umib at igoan? Sig ue ar, ne eng quran end ye ete nonob qemerine igu: ne munon yanamunor qamb wurit yari ne teteri me erinerei igama qen ombur gari ende ye yewabi, “munon eng ye sir ue,” ende yet qamb iginen eng teteri qarig eriba,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yisas ende qamb ne wonou imbigau yurau eng gugum wurinob qamar: “An misir qebebi igub me abar, an Qenut oabig gab eng yet gor oabigar. ");
INSERT INTO wnu_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Tain munai mor eng munai tumbigi irou igo. Ue ende qi eng qo aninob qamamei qi. End ye gigit irab munai tumbigi qei musitarib qamb iribam. ");
INSERT INTO wnu_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","End ne ye gigit irab munai tumbigi musitar wogub bo igeser darab anamar irine ne an ye igoum eng imbig ne yonob igoruboumon. ");
INSERT INTO wnu_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ye munai ginam iribam eng an gor maigas at irunon eng see an imbigine igoumon eng.” ");
INSERT INTO wnu_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ende qamara wonou imbigau yurau end ger unum Tomas, eng der Yisas nob qamar: “Barai, ne eret iriner qi eng in sir ue. In bo maigas at ne irinen werei eng imbig dioruboun?” ");
INSERT INTO wnu_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ende qamara Yisas taui qamar: “An diorunon werei eng ye gari. Ne qob apand eng ne igomot igamau qanam eng gor ye gari. End ne munon ger Tain qani irib qamb eng werei eng ye gari. ");
INSERT INTO wnu_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","See ye mom yiimbig gab eng Tain gor mom imbigoumon, ye mom yiimbigoumon end Tain gor ende imbig gab eng mom geau gas ende oboumon.” ");
INSERT INTO wnu_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ende qamara wonou yurau end ger unum Pilip der nob qamar: “Barai, Tain, quran eng in musub inimbiga in mom musub qoyametoruboun.” ");
INSERT INTO wnu_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ende qamara Yisas qamar: “Pilip, ye qenen aninob igoum end qo yiimbigonei quraum eng bo sabar me yiimbig quran ne? Munon ger ye yegab igo eng Tain geau gas ende gari. Eng ne bo sabar meimet qamb “Tain inimbiga gun” quran? ");
INSERT INTO wnu_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Pilip, ne yet me oabigan qiyo? Ye Taint igimine Tain wo yet igo.” Ende qamb gugum wuri nob qamar: “Ye qob aninob qamb igoum eng yonou misirt ue, Tain yiimbiga wonou sarau eng ye ebet igoum. ");
INSERT INTO wnu_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Tain yet igama ye Taint igoum end yet oabigar. Ue gab eng Tain ye yenogursia sarau qeretutnob oboum eng qas gab oabigar. ");
INSERT INTO wnu_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Apand aninob quraum, ye Tain qani irinei igama munon ger yet oabig sarau ebeiner eng ye sarau ebine aba gas ende ebeiner eng ye bais yetanami ebeiba. ");
INSERT INTO wnu_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ende ebet ne an mi geret quguraget gab eng ye yegab-yegab qebi qamarari annonogursieribam. Ende ebine Tain wo yet unum qiribiten eng diban igoriba. ");
INSERT INTO wnu_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","End ne quraum eng, ye yegab mi geret qomorunon eng anit ebeibam.” ");
INSERT INTO wnu_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ende qamb qamar: “An ye yeqenunget gab eng yonou qomon eng toat igoarar. ");
INSERT INTO wnu_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ende ebet igorunon eng ye anit igub Tain nob qemerine Munon annonogursieriner eng Qenu wonou Igomurur qau qob apand animbiginer eng anit imurima darab annonogursi qenen anamar igoriba. ");
INSERT INTO wnu_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Munon ai qent e wuri imbig gab me baunorei. An gari imbigumon end anopuri ten igoriba.” ");
INSERT INTO wnu_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ende qamb qamar: “Ye mom me an wogub quinei, ye bo anit deribam. ");
INSERT INTO wnu_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Bais umi-umi ende at munon ar gugum bo me yegunorei. Ego an yet oabig igoumon end yegouboumon. Ye igomot der bugumine an yegab yet oabig yetoat igoumon end an gor igomot igoruboumon. ");
INSERT INTO wnu_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Qen eng gab ye Tain nob igorin eng an yiimbiguboumon. Yiimbig ne an yenob igorunon eng imbig ne ye aninob igorin eng imbig ende obouboumon,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ne bo qamar: “Munon ger ye qomon quraum eng toa gab eng, ‘qo, munon eng ye mom yeqenunga’ ende qemeribam. Munon ger ye yeqenungeiner eng Tain wo gor munon eng qenungeiba. Ende aba yonou gor munon eng qenunget ne yonomi dibesierine yiimbigiba.” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ne Yudas ger, Yudas Iskariot ue, eng der Yisas nob qamar: “Barai, nonomi maigas at init dibesi ne munon ar gugum wuriwegiban?” ");
INSERT INTO wnu_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ende qamara Yisas taui qamar: “Munon ger sig-sig mom yeqenunget eng yonou qob eng mom toat igoriba. End Tain munon eng qenungeiba. Ende aba in Tain nob ombur qenen der munon eng nob igoruboun. ");
INSERT INTO wnu_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","A munon ger ye me yeqenunget eng ye qob eng me tooinerei. Ye qob qemerine igub igoumon eng yonou misirt me qamb igoum, yonou Tain yiimbiga qamb igoum end.” ");
INSERT INTO wnu_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ende qamb qamar: “Ye aninob igoum end qob eng gagar aninob qamb igoum. ");
INSERT INTO wnu_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ye me yegab eng munon ger annonogursi igoriner eng Igomurur qau. Tain ye yegab-yegab Igomurur qau anit imurima deriner eng wo mi gugum animbigiba. Ye mi see aninob qemerine nasi wogunon eng bo anseara bo misirt igub qamb igoruboumon.” ");
INSERT INTO wnu_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ende qamb qamar: “Yonou oau mein eng anit igoriba. Yonou oau mein eng munon ai qent wurinou oau mein eng gas ende ue, yonou anit isiner eng qenen igoriba. An ende igo ne misir tumbet ne yari ende me abar. ");
INSERT INTO wnu_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","End ne qo aninob quraum eng, anwogub irin eng qitet me igorinei, bo an qani deribam. Qoan ye yeqenunget igoumon end irine an yet mismisiruboumon. Tain wo sig aib ye yetanamima. ");
INSERT INTO wnu_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Mi eng gagar aninob quraum eng qen geret ende yariba, end ye gigit aninob quraum. Qen geret mi quraum eng irimanima gab an io qomoruboumon. ");
INSERT INTO wnu_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ye qob degen bo me aninob qemerinei. Munon ai qent wurinou baraitari eng di igo. Wo diab ye me yebumaiminerei. ");
INSERT INTO wnu_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","End ne munon ag e gugum ye Tain sig mom qenungoum eng imbigar qamb End ne Tain wo mi gugum eb qamb yonob qamb igo eng ye mom toat ebet irimanimbam.” Ende qamb qamar: “Der naget mi bayar isun,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yisas wonomit qamar: “Ye wain qor qanam eng, ne wain man eng Tain wonou. ");
INSERT INTO wnu_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Wain uben eng yet gumat igo ne git iimbi igour. End ne Tain wo wain uben qei ima gagt giner eng wain uben qei me ima gab eng uben eng sir-sir wain qen tenori end soagir ariramba. A, uben qei musub mom ima gab igoriner eng mugen-mugen soopur ariramine bo quburub git irou im qamb soopumimba.” ");
INSERT INTO wnu_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ende qamb wurinob qamar: “See ye qob e aninob qemerine sigen misir igoumon. ");
INSERT INTO wnu_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","End an ye yonob igamari ye gor aninob igoribam. End ne an gaiar, wain uben wain qen irend me gumat dieriner eng musub me iminerei. Eng gas ende an gor, ye musub me yet oabigunon eng wain musub me imbi igo gas ende igoruboumon.” ");
INSERT INTO wnu_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ende qamb bo qamar: “Wain qen eng ye, ne an wain uben eng. Your ger ye nob qenen igoriner eng ye gor wo nob igimine wain imbi igo gas ende imbi igoriba. An ye yewogunon eng an mi ger me ubunanei. ");
INSERT INTO wnu_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Munon ger yonob me igoriner eng wain uben musub me ima gab soagir ariramari gegeret igo gas ende aba ne ba qiumuni big mutet gumoubour. ");
INSERT INTO wnu_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","An ye nob igorunon eng yonou qob eng anit igoriba. Igama an mi geret qamb ye qebi qomorunon eng mi eng qeemben ende andaribam. ");
INSERT INTO wnu_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","An wain qur irou imbi igo gas ende obounon eng Tain wonou qiribiten eng end guboumon. Werei end ne an yonou imbigau munon igoruboumon. ");
INSERT INTO wnu_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Tain ye yeqenunget igo gas ende ye an gor anqenungar igoum. End ne an ye mom yegot ten ete igoarar. ");
INSERT INTO wnu_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","An ye qomon quraum eng toat eng ye tenori mom igoruboumon. Eng gas ende Tain qomon qamara ye toat wo tenori mom igoum gas ende an gor ende ebet ye tenori mom igoruboumon.” ");
INSERT INTO wnu_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ende qamb bo qamar: “Ye eng at aninob qamb borusi mismisiraum. Eng gas ende an gor ende mismisir igoarar qamb quraum. ");
INSERT INTO wnu_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Eng yonou qomon animbigoum: Ye anqenungoroum gas ende an munon qei ende wuri qenungaiar. ");
INSERT INTO wnu_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ete gas ende: Munon ger wonou munon banam sig qenunget igo eng musierib eng qand musieriba, wonomit misir me iginerei. ");
INSERT INTO wnu_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","End ne an ye qomon quraum eng toat eng an yonou munon banam ten. ");
INSERT INTO wnu_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Eng gas ende, munon barai ger wonou wau gogor ger nob igoriner eng wonou munon barai mi ebeiner eng gugum me imbiginerei. Eng gas ende, an bo sabar yonou wau gogor gas ende ue. Tain qob gugum yonob qamb igo eng ye bo imusi aninob qemerine mom imbig ugamanei. End an bo wau gogor gas ende ue, end ye anit yonou munon banam anit quraum.” ");
INSERT INTO wnu_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ende qamb qamar: “An ye me ye qereimau, ue, yonou anqereiamei. Qerei ne anit nam qur irou big aritarar qamb anmaribigomei. Nam qur irou biga gab wagari igoriner. Ende at an mi geret qamb ye yegab-yegab Tain qebi qomorunon eng andariba. ");
INSERT INTO wnu_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","End ne qomon aninob quraum eng: An munon qei wuriqenungaiar. ");
INSERT INTO wnu_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Munon ai qent qei me anbanamsiari ibag eng an bubun qamb me oau uburab isar. Ye qo yesiamir gas ende ansiorubour. ");
INSERT INTO wnu_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Munon ai qent wuri ye me yeqenunget eng an ye yewapet at qib igamari animbag anqarausiorubour. Ende abari ibag eng wuri yonou yurau ue. Yonou anmaribigoum end an munon ag e ue, end ne munon ag e anqarausiorubour. An munon ai qent e qomon abari ibag anitarama obounon eng wuri anbanamsiorubour. ");
INSERT INTO wnu_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","End ne qo aninob qamam eng: “Wau gogor wo wonou munon barai eng gigit me igorinerei.” Eng gas ende, ye yetoat ariramour gas ende an gor antoar arirambour. Ye qob quraum eng igisab ende qi eng an gor qamarari igotorour qi. ");
INSERT INTO wnu_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","An yonou yurau end ne mi eng gagar quraum eng gugum ende ansiorubour. Wuri ye your yiimurima ag e derem eng wuri sir ue end. ");
INSERT INTO wnu_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Git apand, ye me darab qob wurinob qamamei ende qi eng wuri qomon boru ger ue qi. Ego see wuri qomon boru ger wabiomunor eng werei ger ue. ");
INSERT INTO wnu_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Your ye yeqarausi igo eng yonou Tain gor qarausi igo. ");
INSERT INTO wnu_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Munon ger wurit sarau me abau, ye wurit sarau wes ar ebine yet iet ne wuri qomon boru ebet igour. Ye sarau eng me ebetemei ende qi eng wuri qomon boru ue qi. Ye sarau eng ebine yegab ye yeqarausi Tain gor qarausi igour. ");
INSERT INTO wnu_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Wuri ye qarausi igour eng wurinou wurit qomon ger gumatemir ete igo eng irimani igo: “Ye meimi ger ebine me yeqarausiunorei, ar yeqarausi igorubour. Ende igo eng irimani igo.” ");
INSERT INTO wnu_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ende qamb qamar: “Ye irab Igomurur qau Tain nob igo eng imurimine darab annonogursieriba. Igomurur qau wo qob apand qas animbiga iguboumon. Wo darab ye yedibes qemeriba. ");
INSERT INTO wnu_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Qamara an gor ye yedibes qamarar. Ye set ag e darab sarau qanambig ebine an yonob igoumon eng isi yarab see end.” ");
INSERT INTO wnu_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Ende qamb isi yarab bo qamar: “Ye qob e aninob quraum eng an yet oabigumon eng at bo wogunon qamb annonogursi quraum. ");
INSERT INTO wnu_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Wuri wurinou inorou munai mor end is igamari antoar arirambour. Ne wurinou, “in Qenu sarau uber oboun,” qamb qen eng yara gab qei aningaramari umuboumon. ");
INSERT INTO wnu_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Wuri eng ansiorunor eng wuri Tain qiyo ye in ombur bais me inimbigunorei. ");
INSERT INTO wnu_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Qen yara gab ende ansiarari gab ye qob e aninob quraum end misir igar. Qoan aninob igoum eng mi eng gagar me animbig qamarau. ");
INSERT INTO wnu_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","End ne see munon yiimurima derem end bo irib qamb quraum. Ego an ger der yet: “eret qoaiban?” ende at me ye qebi quraumon. ");
INSERT INTO wnu_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ue, an ar ye eng at qemerine nogom qas angomotopur igo. ");
INSERT INTO wnu_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","End apand aninob quraum, ye me anwogub qoain eng munon annonogursieriner eng me derinerei. End ye anwogub irab wo imurimine anit deriba. ");
INSERT INTO wnu_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Darab munon ag gugum wurit isub qomon boru soagen ebet igour eng wuriimbigiba. Ende at ne qomon qoregen eng imbig ne Qenu wuri qob musitariner qereiminer eng gor imbigubour. ");
INSERT INTO wnu_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Wuri qomon boru soagen ebet igour eng wuri yet me oabig ebet igour. ");
INSERT INTO wnu_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","A, werei qoregen imbigunor eng ye Tain qani irine an bo menman me yegounon qen end. ");
INSERT INTO wnu_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ne gor qob musitarau qomon eng munon ai qent wurinou baraitari wo qob musuorei igo.” ");
INSERT INTO wnu_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ende qamb qamar: “See ye mi irou aninob qemerib misir igoum ego, an qanganget mi git me ubunanei eng gab. ");
INSERT INTO wnu_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","End ne ye irab Igomurur qau imurimine darab qob apand eng qanam gugum animbigiba. Wo wonou misirt mi ger me aninob qemerinerei. Ue, wo Qenu qob qamara iginer eng qas qamara igub igamari mi ende diara guboumon. ");
INSERT INTO wnu_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Wo yonou qob eng qas qamara iguboumon. Wo eng ebeiner end yonou unum dibent isiba. ");
INSERT INTO wnu_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Mi gugum ininou Tain nob ombur gari. End ne Igomurur qau wo yonou qob igisab ne eng gari aninob qemeriba.” ");
INSERT INTO wnu_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Ne bo qamar: “Ye bo me yegounon qen eng pi burab igo eng. Isi yarab bo qen piten ubura ne bo yegouboumon.” ");
INSERT INTO wnu_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ende qamara wonou imbigau yurau eng qei der qei wurinob qamamir: “Qob eng at qurar eng, “qen piten ete me yegunanei isi yarab bo qen piten ubura bo yegouboumon” qura eng qanam maigas?” Ne ete gor at qurar eng: “Ye Tain qani irine me yegunanei.” ");
INSERT INTO wnu_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Qob eng, ‘qen pitente’ qob eng qanam maigas qiyo, in sir me imbigoun,” ende at qamb isub igurei. ");
INSERT INTO wnu_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Atei wogub qebi qomorub pisiari ibag wurinob qamar: “Ye qob eng aninob quraum eng, qen piten ubura me yegunanei, isi yarab bo qen piten ubura bo yegouboumon. Eng aninob qemerine an qanganget aninou qi qebi qamb igoumon? ");
INSERT INTO wnu_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Apand aninob quraum, an borusi toubet eab igamari munon qei mismisir igorubour. An mitembur igoruboumon. Isi yarab qen ger gab bo an borusi mismisiruboumon. ");
INSERT INTO wnu_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ete gas, yamangar ger qurag igo qoaib qamb mogisqeret borusi aruab igo. Isi yarab wau mom menub wogub bo qugurageteriner end misir me iginerei, wau eng gab borusi mismisiriba. ");
INSERT INTO wnu_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Eng gas ende gari, see an quguraget toubet igoumon. Qen piten ubura bo menman yegab sig-sig mom mismisiruboumon. Ende abari munon ger bo sabar abari me toubet iyunanei, ue ar.” ");
INSERT INTO wnu_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ende qamb qamar: “Qen eng gab an bo ye qebi qomorub misir me igunanei. Apand aninob quraum. An ye yegab-yegab Tain qebi qamarari wo an meimit qebi nob qomorunon eng andariba. ");
INSERT INTO wnu_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Qoan igoumon eng isi yarab see eng an ye yegab-yegab mi geret qebi me qamarau. Umi eng mi geret qebi qamb eng ar bauboumon. Ende ebet ne borusi mismisiruboumon,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Qamb qamar: “See ye mit big aninob quraum. Qen geret qen eng yara gab bo mi geret big me aninob qemerinei, ue. Tain wonou qob qoregen aninob qemeribam. ");
INSERT INTO wnu_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","27","Qen eng gab ye bo anit igub Tain nob qemerine me anmusinerei. Aninou qoregen ye yegab-yegab Taint qamarari mi andariba. Wo ye yiimurima derem eng an ye yeqenunget yet oabigari animbag wo anqenungarar end qebi qamarari mi andariba. ");
INSERT INTO wnu_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ye Tain nob igo ag e derem end bo ai e wogub Tain qani iribam.” ");
INSERT INTO wnu_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ende qamara wonou imbigau yurau eng der nob qamamir: “See ne mit big me quran, mom dibes qamara in mom musub imbigoun. ");
INSERT INTO wnu_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ne mi gugum mom imbigan, end munon ger mi geret ne qebi qamara nob qemerib qamb me qoat igoan. Ne in misirt mi ende qomorun qamb igub igoun eng mom dibes mom ininob qamb ugea gab in nenet mom oabigoun. Ne Qenu nob igo derenei.” ");
INSERT INTO wnu_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ende qamarari Yisas taui qamar: “An see qas yet oabigoumon ne? ");
INSERT INTO wnu_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Qen eng yarib pisi igo, yara an gari-gari antoar ariramari bunumban wes-wes iua aninou ginamt igoruboumon, ye gari yewagari yonomai igimine Tain yonob igoriba. ");
INSERT INTO wnu_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ye qob eng at aninob quraum eng an ye yewagar qamb me quraum, erogori igorun qamb quraum. Munon ag e anquguragsiorubour, ego an end wurit uburab me isar. Ye ai e qomon end mom nonoguretoroum end animbig quraum.” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yisas qob eng ende qamb ugab wogub qiter asi ur nob qamar: “Tain, ne qen maribigeseisen eng yara, ye yaba qiribiten burab ne bo ye ne nedibesine munon ne negab qoaguruimbour. ");
INSERT INTO wnu_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ne ye munon ag gugum wurinou baraitari igoar qamb wurit unum ba dibesianei. End ne munon qei yonou yurau qamb yet maribigataren eng ye wurisierine qenen bebereg igorubour. ");
INSERT INTO wnu_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Igomot igamau qanam eng ete: Munon ne niimbig apand Qenu net qamb a ye Yisas munon gugum wuriubersiau tari eng ne imurima derem eng yet oabig obounor eng. ");
INSERT INTO wnu_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nonou sarau gugum eb qamb yiimbigon eng ye gugum ebet ugab ne gor nonou qomon qiribiten eng yet dibenara munon gugum gaur. ");
INSERT INTO wnu_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Io Tain, qoan mi gugum barsien qen end ye gor qiribiten igumei. Eng gas ende see gor ende yesi.” ");
INSERT INTO wnu_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ende qamb qamar: “Ne munon yurau ag e yet maribigon eng ye ne wuriimbigine niimbigour. Munon yurau eng nonou tetemi yet wagen end nonou qob eng ye wurinob qemerine toat igour. ");
INSERT INTO wnu_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","End ne mi gugum ye oboum eng nonomi eng ye ebet igoum eng wuri ende niimbigour. ");
INSERT INTO wnu_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Nonou qob yiimbigon eng ye wurinob qemerine igisab igour. Igisab ne ne yiimurima derem eng niimbig ne nenet mom oabig igour.” ");
INSERT INTO wnu_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ende qamb bo qamar: “Tain, ye nonob quraum eng munon gugum ag e wurit ue. Nonou munon yurau tetemi yet maribigon eng wurit nonob quraum. ");
INSERT INTO wnu_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Munon yurau ye wurinob igoum eng nonou, ne gor ne wurinob igoan eng yonou. End ne ye qiribiten eng wuri gab yet mismisir igour.” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Qamb qamar: “See ye bo ag e me igorinei, nenet dieribam. Ego munon yurau e wuri ag e igorubour end wurit igub quraum. Io, Tain, ne unum end yet mi qeiramon musub oroar igama ne in ombur gari igoun gas ende wuri gor gari ende igorunor. ");
INSERT INTO wnu_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ye ag e wurinob igoum eng mom musub oroar igimine nenet mom igurei. Ye wuri igusiau nami ende ebine ger me umau. A munon yar isorei igo. Eng Qenu qob qoan gumatemir eng irimautom qamb. ");
INSERT INTO wnu_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Ye nenet dieribam end qob e ag e ende qemerine igari yonou mismisiroau wurit yabri igoar qamb.” ");
INSERT INTO wnu_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ende qamb qamar: “Ye nonou qob eng e wurinob qemerine ne wuri munon ag e gugum wurinob qamarari igub wuriqarausiaur. Eng ye munon ag e ue gas ende wuri gor ai qent e ue igamari ibag wurisiaur. ");
INSERT INTO wnu_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ye ne qebi quraum eng munon yurau eng qand wuribaub agiom wurisi qamb me quraum. Ne musub oroar igama ne munon boru eng me wurimuasereminer qamb nonob quraum. ");
INSERT INTO wnu_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ye munon ag e ue end ne wuri gor yet oabigour eng wuri gor munon ag e ue. ");
INSERT INTO wnu_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Nonou qob apand end ne munon yurau eng wurisiara wuri nonou munon yurau utari igorunor. ");
INSERT INTO wnu_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Qoan ne yiimurima ag e darab wurinob igoum gas ende ye bo munon yurau e wuriimurimine iua munon ginam-ginam oromar igorubour. ");
INSERT INTO wnu_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Wuri uput qamb ye umb ne wuriubersieribam. Ende ebine wuri gor nonou yurau apand burubour,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Ne bo qamar: “Yonou imbigau yurau end gari me nonob quraum, munon qei wuri qob qamarari yet oabigour end gor nonob quraum. ");
INSERT INTO wnu_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ende nonob qemerine wuriseara yurau gari qas igoarar qamb. Io Tain, wuri ende ebet ne in ombur gari qas igoun gas ende wuri gor ende igoarar qamb. Munon ai qent gugum oabig ne, ne ye yiimuriamon eng qanam musub mom inimbigubour. ");
INSERT INTO wnu_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ne ye yenonogursi igoan gas ende ye gor ende wurisierine wuri in ombur gari igoun gas ende wuri gor yurau gari igoarar qamb. ");
INSERT INTO wnu_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ye wurit igimine ne yet igoar. Ende ubune wuri ininou munon yurau tumbigi gari igo ne, ne yiimurima derem eng qanam musub mom imbigubour. Ende abari ne, ye yeqenunget igoan gas ende gari wuri gor wuriqenungara wuri mom imbigubour. ");
INSERT INTO wnu_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Io Tain, munon yurau eng nonou yet maribigonei. End wurisiara ye eret igimine eng wuri gor end yonob qas igorunor. Ende igo ne qoan qanambig mi gugum barsi nonou qiribiten eng yet maribigon eng wuri gaiar qamb sig qenungoum. ");
INSERT INTO wnu_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tain, ne munon qoregen uber. Munon ag e gugum ne me niimbig igour. Ye gari niimbig igoum end munon yurau ye wuriimbig igoum eng gari ne yiimurima derem eng wuri qoyam. ");
INSERT INTO wnu_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ye neunumot qemerine-qemerine niimbig igour. End bo imusi qamb isibam. Ende ebine wuri gor der munon yurau qei wurinou munon banam ue eng wuriqenungar qamb. Ende ebine ne yonob igama ye gor wurinob igoribam.” Yisas ur nob ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yisas ur ende qebi qamb wogub ne wonou imbigau yurau eng wurinob bo ya Kidron eng purab ne ai ger ig end igoar end isumirei. ");
INSERT INTO wnu_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Is end igamari Yisas wonou yurau end ger, Yisas duimb qamb iuar eng, unum Yudas. Wo qoan Yisas wonou wuriimbigau yurau end igoar end ne qenen Yisas nob ai eng is qib igour end wo ai eng qoyam. ");
INSERT INTO wnu_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","End ne wo munon yurau wurineriamor eng, yogorau munon ne Qenut mian iset big igour wurinou bur tuum eng ne Parisi ende. Ende oromar itum dieriba ne wuri qombuni urut uruguni ba Yisas ai eng igama diamirei. ");
INSERT INTO wnu_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Diab Yisas siorunor eng gugum imbig wogub ne bo baist isub-isub wuri menmant end naget gag wuriqebi qamar: “An your gub qamb asi qib igoumon?” ");
INSERT INTO wnu_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ende qamara wuri qamamir: “In Nasaret munon Yisas eng gub asi qib igoun.” Qen end Yudas wurinob naget igoai. Wuri ende qamarari Yisas taui qamar: “Eng ye eng e.” ");
INSERT INTO wnu_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ende qamara yari ibitumt isub qurer inumutari uburemirei. ");
INSERT INTO wnu_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ende abari bo sabar wuriqebi qamar: “An your gub qamb asi qib igoumon?” Ende qamara wuri bo qamamir: “Nasaret munon Yisas eng gub qamb asi qib igoun,” qamamir. ");
INSERT INTO wnu_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Qamarari wo qamar: “Eng ye qoan aninob qurumei, ye gari e igoum. An ye mai yesiorub qamb eng yesiarar. Yesi munon yurau qei e wurinob igoum eng wuri wagar,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Yisas qob eng at qamar eng qob qoan ete at qamar eng irimaniom qamb “Tain munon yurau e yet maribigon eng ger me uminerei.” Qob eng at qamar eng me biisitein qamb. ");
INSERT INTO wnu_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Yisas ende at qamb igama Saimon Pita bui qauri ger beneri Qenut mian iset big igour wurinou gigit eng wonou sarau betet igo eng unum Malkus iruges ig soabur ariramorei. ");
INSERT INTO wnu_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ende aba Yisas qand der Pita qamat qamar. “Pita, nonou bui qand bo uput end big. Mai yonou Tain ye me yanamar qamb yeduimau qiyo?” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Qamara yogorau munon baraitari eng wonou yurau eng ne Yuda wurinou bur tuum eng ende erogori der Yisas baab simarurt touriamirei. ");
INSERT INTO wnu_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Touri wogub gigit munon ger unum Anas munai end mot isumirei. Anas wo Kaiapas wonou uga. Kaiapas wo togun end Qenut mian iset big igour eng wurinou gigit igoai. ");
INSERT INTO wnu_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaiapas wo qoan Yuda munon ete wurinob qamarei: “Munon gugum umunor qamb munon gari qas wuri uput qamb waramune uminer,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Yisas mot Anas munai mor isari Saimon Pita ne munon ger nob toat isumirei. Isub ne munon ger eng wo munon baraitari eng wonou munai eng qoyam end Yisas mot isari wo yar nob mor isorei. ");
INSERT INTO wnu_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pita wo sir ue end yar ag naget igoai. Igama munon ger qoyam eng mor isuor eng bo ag darab yamangar ger tend qoat igoar eng nob qamara Pita mot mor isumirei. ");
INSERT INTO wnu_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Mor isub yamangar eng Pita gab nob qamar: “Ne munon e mot yorour eng wonou imbigau munon ger qii?” Ende qamara Pita taui qamar: “Ue, ye munon eng wonou yurau ue,” qamar. ");
INSERT INTO wnu_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Itum end borusi wining wogub sarau eng baab igour eng nob burtuum nob mut aib gumet qoui bugab qoariget igurei. Igamari Pita wo gor is wurinob mut qoariget igoai. ");
INSERT INTO wnu_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Qen end mian iset big igour baraitari eng der Yisas wonou imbigau yurau end qebi qamb a munon qob wurinob qamb qib igoar end qebi ende at igoai. ");
INSERT INTO wnu_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Qebima Yisas taui qamar: “Ye qob wurinob qamb qib igoum eng ger yonou wabi me qamb igamau. Ye qenen inorou munai end qob qemeribine Yuda gugum yar qiumuni igub igamari wurinob qamb igumei. ");
INSERT INTO wnu_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","End ne ne ye meimet ye qebi quran? Munon ar qei wuri qebi qamara wuri ye qob maigas qemerine igumir eng nonob qamarari igiban.” ");
INSERT INTO wnu_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yisas qob ende at qamara bur tuum ger igub mataisi waramb nob qamar: “Ne meimet qamb munon qau barai aib e qob ende at nob quran?” ");
INSERT INTO wnu_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ende qamara Yisas nob qamar: “Ye qob soagensi munon barai e nob qemerine gab eng bo musub yonob qamara igini. A qob ubersi qemerine gab eng bo meimet qamb yanaman?” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ne Anas Yisas touriamir eng ten igama bo imurima Kaiapas qani isorei. ");
INSERT INTO wnu_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Qen end Pita wo se mut qoariget naget igoai. Igama ne bo munon qei gab qamamir: “Ne gor munon e nob yorour eng wonou imbigau munon qii?” Ende qamarari Pita bo wurimurimar qamar: “Sig ue ar.” ");
INSERT INTO wnu_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ende qamara munon aib eng wonou sarau betet igour eng, ger Yisas booub qamb ite iroari Pita iruges ig soaburamor eng wonou qanam erogori. Eng der Pita gab qamar: “Ue, see qas ne, ne munon eng nob ite igama negumei. ");
INSERT INTO wnu_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ende qamara Pita bo der qamar: “Sig ue ar, eng ye ue,” ende qamara qen end qas teteri qamar arei. ");
INSERT INTO wnu_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ende at igamari ai uteret ubub diara ne Yisas bo mot gabman wurinou gigit munai end isumirei. Isub Yuda wurinou mi aib qamb at nub etemir end mor isub inorou songiomun qamb gitab ag igurei. ");
INSERT INTO wnu_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Igamari Pailat ag der wurinob qamar: “An munon e qob maigas gab musitoub nob yurumanei?” ");
INSERT INTO wnu_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Qamara wuri taui qamamir: “Munon eng qomon boru ger me aba eng in meimet gab mot ne qani me yurunei.” ");
INSERT INTO wnu_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ende qamarari Pailat qamar: “Ende gab eng aninou mot iua aninou qomon eng toat qebi gaiar.” Qamara wuri taui qamamir: “In munon ger waramune uminer eng sig qau,” ende qamamirei. ");
INSERT INTO wnu_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Eng etemir eng qoan Yisas umau end qamar end wonou ende uma qob qamar eng irimaniom qamb. ");
INSERT INTO wnu_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Qamarari Pailat bo mor ito isub Yisas qebi qamar: “Ne apand Yuda wurinou baraitari qiyo?” ");
INSERT INTO wnu_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ende qamara Yisas taui qamar: “Ne eng at ye qebi quran eng mai nonou misirt quran qiyo, a munon ger yet qamarari igonei igo quran?” ");
INSERT INTO wnu_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ende qamara Pailat taui qamar: “Mai ye Yuda igimine quran? Aninou Yuda yurau gari eng munon mian iset bigau baraitari eng nob ne meimi ebetenei igama nomot ye qani yururei qi?” ");
INSERT INTO wnu_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ende qamara Yisas nob qamar: “Yonou bibis eng big munon oroar igorin eng ag et me igo, yonou bibis ag et igama ende qi eng yonou munon yurau ye toat qib igour eng der wurinob yogorari Yuda ye me yabaab mot yarau qi. Yonou bibis eng ag e ue end yanamb qamb yomot yururei.” ");
INSERT INTO wnu_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ende qamara Pailat qebi qamar: “End ne, ne mai baraitari aib qiyo?” Yisas taui qamar: “Eng ne gari quran eng ye baraitari aib. Nani ye ag e yebauor end mi gari qas ebeib qamb ag e deremei. Eng ete: ye qob apand eng gari qamb qib igoum. Your ger qob apand igib qamb eng ye qob qoregen igisab toat igoriner.” ");
INSERT INTO wnu_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ende qamara Pailat qebi qamar: “Qob qoregen eng meimi?” Ende qamb bo ag iro isub Yuda wurinob qamar: “Munon e ye gaum eng qomon boru ger ebeterei igama uyort bigau ende ue. ");
INSERT INTO wnu_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","End ne aninou qomon ger ete igo: Mi aib at niau qen eng gab ye qenen munon ger uyort igama ye ar imurimine anit isub igo. Eng gas ende bo see mai munon e ar ende imurimine anit isiner qiyo?” ");
INSERT INTO wnu_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ende qamara wuri misiringet sauget qamb amir: “Munon eng ar init waga me yarinerei. In Barabas ar init waga yariba,” ende qamb amirei. (Barabas eng wo munon igaramb qiyo mi urim wurit ba qib igama uyort bigumirei.) ");
INSERT INTO wnu_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ende arari Pailat qamara Yisas ar ba pisirami waramb wogumirei. ");
INSERT INTO wnu_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Waramb wogub yogorau munon wurinou uyor qerenob qungausi ne Yisas tarit bugamsitet ne mingoan mian nob ger ba qumanimetetemirei. ");
INSERT INTO wnu_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ende at ne wot yar gag qob nob qamamir: “Io, ne Yuda wurinou oroar igamau munon,” ende qamb mataisi waramirei. ");
INSERT INTO wnu_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ende abari Pailat bo ag isub munon yurau aib eng wurinob qamar: “An igar, munon eng ye gaum eng wo mindigar qob ger ue eng gab ende mot ag e derine an imbigar qamb mot ag deribam.” ");
INSERT INTO wnu_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ende qamb mor ito isub mot dererei. Uyor qerenob ba qungausi bugamsitemir eng ne mingoan mian nob qumamimetetemir eng ten ag dererei. Darab Pailat wurinob qamar: “Munon eng e”. ");
INSERT INTO wnu_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ende qamara munon mian iset big igour gigit eng ne bur tuum gab misiringet Pailat sauget amir: “Nam tenori big waramari umb qas weginer, nam tenori big waramari umb qas weginer.” Ende qamb arari Pailat wurinob qamar: “Ende gab eng aninou biua nam qen tenori big waramari uminer. Ye wo mindigar qob ger me gab wogoum,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ne bo Yuda taui qamamir: “In qomon ger ete igo: Munon ger ‘ye Qenu wau’ qamb gab eng umb qas weginer. Ende igo end ne wo ‘ye Qenu wau’ qamb qib igoar end see umb qas wegiba.” ");
INSERT INTO wnu_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Wuri ende at qamarari Pailat igub borusi yariamorei. ");
INSERT INTO wnu_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Yari bo mor ito isub Yisas bo qebi qamar: “Ne munon ginam eret?” Ende qamara Yisas qob ger taui me nob qamarau. ");
INSERT INTO wnu_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ende aba ne Pailat bo nob qamar: “Ne ye qob quraum eng ger taui me yonob qemerinenei ii? Ye munon qeretut nob igoum, ar niimurimine qoaib eng ar qoaiban. A nam tenori big nanamb eng ar ende nesieribam.” ");
INSERT INTO wnu_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ende qamara Yisas taui qamar: “Qenu ne me nonogursia, nonou qas ende qi eng ne ye me yebumaiman qi. End ne munon ye yeduima ye mot nenet yorour munon eng wonou qomon boru eng ne netanamima, wo sig boru.” ");
INSERT INTO wnu_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ende qamara Pailat igub werei ger gab ar wugine iua qamb ebeterei. Aba Yuda qamamir: “Ne munon eng ar waga qooiner eng ne munon baraitari Sisar eng wonou munon banam bo me igorinenei. Munon ger, ye Yuda oroar igoum qemeriner eng Sisar qarausi igo.” ");
INSERT INTO wnu_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ende qamarari Pailat igub mor ito isub Yisas mot ag der is munon qob qereimb qamb nomon qab bugab igour end is bugamorei. (Nomon qab eng ‘bogomau nomon qab’ qamb igour. Yuda wurinou qobt, ‘Gabata’ qamb igour.) ");
INSERT INTO wnu_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Qen end worom ginam tog yarerei. Yuda wurinou mi aib at nub qamb mi arsi igour qen eng gab Pailat Yisas ba nagasi Yuda wuri sirbig qamar: “Aninou munon anoar igo eng e.” ");
INSERT INTO wnu_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ende qamara wuri sauget amir: “Waramari umb qas weginer. Nam qen tenori big waramari umb qas weginer.” Ende qamarari Pailat wuri qebi qamara Qenut mian iset bigau wurinou gigit eng der Pailat nob qamamir: “In munon ar ger me inoar igo, Sisar wonou gari inoar igo.” ");
INSERT INTO wnu_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ende qamarari Pailat Yisas wurinou ba nam tenori big waramar qamb imurima isorei. ");
INSERT INTO wnu_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Imurima isa wurinou ba mori wogub nam manasi big waramir end wonou big waramunor eng togormatari ba ginam aib eng wogub ai ger, ‘Tari qer’ qamb igour end isumirei. (Yuda wurinou qobt ‘Golgota’ qamb igour.) ");
INSERT INTO wnu_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ginam end isub Yisas nam tenori big waramirei. Waramb ne munon ombur-ombur gor, ger uberegent wes end ne ger qagit wes end ende igaramirei. ");
INSERT INTO wnu_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ne Pailat qob ger nam ii ba ete qamb gumater Yisas tarit itoi end big waramorei: NASARET MUNON YISAS ENG E, WO YUDA WURINOU MUNON OROAR IGAMAU, ende qamb gumaterei. ");
INSERT INTO wnu_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Pailat qob eng qamb gumater eng qob ombur gari endet qamb gumaterei, Yuda wurinou qob, Hibru, Laten ne Grik ende. Yisas big waramir eng munai ginam aib eng qani igoar end Yuda munon irou qob eng wanunger qibi wogub outet ne ");
INSERT INTO wnu_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Yuda wurinou mian iset bigau gigit eng isub Pailat nob qamamir: “Ne meimet qamb munon e Yuda wurinou oroar igamau munon qamb gumanei? Ete qamb gumau ue, munon e wonou uyes ye Yuda wurinou oroar igamau munon ende qamb qib igoai. Ende qamb gumanei ende qi eng uber qi.” ");
INSERT INTO wnu_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ende qamarari Pailat qamar: “Ye qob gumaum eng bo sabar me ousinei, mom end igoriba,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Yogorau munon yurau Yisas ende big waramb wogub ne Yisas wonou mingoan eng qerei bubur ombur bo ombur ende big wogub yogorau munon gari-gari baumirei. Ende at isi yarab Yisas wonou mingoan itoi ogumuni igoar eng gor baumirei. Mingoan itoi eng wobon soopur me maimau, ar saranang degen aib. ");
INSERT INTO wnu_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","End ne yogorau munon yurau eng qamamir: “Wagari ar me boobur baun, sauarau ger ebet your wotanami eng mingoan eng bainer,” ende qamamirei. Mi eng etemir eng qob qoan igoar eng irimaniom qamb Qob ete qamb gumatemirei: Yonou mingoan eng qerei baubour. Isi yarab mi goan it nagau end saub ne your wotanami eng baiba. Ende igoar end yogorau munon eng ende atemirei. ");
INSERT INTO wnu_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ne Yisas wonou unor Maria eng ne Yisas wonou unor qanam Maria eng wonou umami unum Klopas, eng ne Makdala Maria eng ende Yisas big waramir nam qanamt end nogumor igurei. ");
INSERT INTO wnu_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Igamari Yisas asi unor nob wonou wuriimbigau munon ger borusi qenunget igoar eng nob naget igamari ibag qamar: “Nani, munon eng nonou wau.” ");
INSERT INTO wnu_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ende qamb bo munon eng nob qamar: “Eng nonou nani.” Ende qamara qen end qas munon eng Yisas unor mot wonou munai mor end irab musub qoat nob igoai. ");
INSERT INTO wnu_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Qen end Yisas sarau mom ubura gab ne qob qoan igoar eng irimaniom qamb qamar: “Yat oboum.” ");
INSERT INTO wnu_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ende qamara ya garan ger ya uyerieri boru ger ten igoar eng ba yar wain ya nob sori waari wogub ni qamb gotau ger ba yoosi utemirei. ");
INSERT INTO wnu_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ende utari nub wogub qamar: “Ne mi gugum mom ubura.” Ende qamb wogub quman gerer wogub umorei. ");
INSERT INTO wnu_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ende aba wogub Yuda wurinou inorou qen aib gab mi at nub igour eng pi eng gab ne munon mumun nam erer igoriner eng boru. Eng gab qand wuritumunimb qamb isub Pailat nob qamarari io qamara isub munon nam erer big igaramir eng goten wuri omboroumimari umari bisub wuritumunimb qamb ");
INSERT INTO wnu_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ne yogorau munon isub munon ombur Yisas nob namt big igaramir eng qer wuri omboroumiamirei. ");
INSERT INTO wnu_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ende at wogub isub Yisas qer omboaun qamb gamir eng wo qo umorei igama gab goten me omboaiau. ");
INSERT INTO wnu_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Yogorau munon ger qauri ba dagar qeret end gumatomaima iiyer di dererei. ");
INSERT INTO wnu_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Munon ger mi apand eng ebeter eng dibes qemeriner eng apand qemeriba. Qamara in eng igub wot oabigun. Ye mi eng apand ebeter eng gab an oabigar qamb aninob quraum. Ye eng qamb gumaum eng qetopur me quraum. ");
INSERT INTO wnu_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ende ebetemir eng qob qoan ete igoar eng irimaniamorei: ‘Wo qer ger bais me omboaunorei,’ ende igoai. ");
INSERT INTO wnu_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Qob ger bo ete qamb gumatemirei igoai: ‘Wuri munon eng gumatemir eng bo gubour.’ qob ende qoan gumatemir igoar eng gor irimaniamorei. ");
INSERT INTO wnu_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ende at wogub munon ger unum Yosep, wo Arimatea munon. Wo isub Pailat nob qemerine io qamara Yisas bisub tumunimb qamb isorei. Yosep wo Yisas wonou qob qamara igetet oabig igoar eng. End ne Yuda wurit yari wonomi me dibesierin qamb waber at qib igoai. Wo isub Pailat nob qamara io qamara isub Yisas mumun ba isib at igoai. ");
INSERT INTO wnu_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Igama munon ger itum wobon Yisast dier eng, unum Nikodemus. Wo gor dierib qamb nam ombur-ombur qesi ba soriamir eng sig borusi qugurau, ne qogom sig uter qer nob, eng ba diarei. ");
INSERT INTO wnu_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Diab ombur Yisas mumun ba ag big ne maurem ya qogom nob eng wot igi mingoant waat wogub Yuda wurinou munon wuri tumunimb at igour gas ende at wogub ba isumirei. ");
INSERT INTO wnu_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Yisas big waramir qani end puriani man ger igoai. Igama tumun ereteri ger man end igoai, munon wuri me tumuni igamau. ");
INSERT INTO wnu_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Qen end Yuda wurinou inorou qen aib end gitab igorunor eng barim ende. End ne wuri mi arsiau qen eng gab ne munon ombur eng imiemet Yisas mumun bisub tumun end tumuniamirei. ");
INSERT INTO wnu_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Sande end ai se purab deara ne Makdala Maria eng munon teteret isub Yisas tumuni nomon aib ger tumun qabar qipiotemir eng ba aisiamirei igama garei. ");
INSERT INTO wnu_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ende gab bo igeser isub Yisas wonou wuriimbigau yurau eng, Saimon Pita ne ger Yisas wonou qenunget igoar eng wurinob qamar: “Ininou munon barai aib eng bo ineri ba qurei igama me gab wogub yoroum, eret wes biua bigurei qiyo?” ");
INSERT INTO wnu_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ende qamara Pita munon ger eng nob ombur wuri bo gub qamb tumunt iramirei. ");
INSERT INTO wnu_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","5","Ombur uyab-uyab iramir ego munon ger eng Pita wotanami wogub wo gigit irab tumun qabar end gerer darab irebig asi gar eng Yisas git goan igama me geau. Wonou mingoan waat tumuniamir eng gari igama garei. Gar eng wo git erobon isub me geau. ");
INSERT INTO wnu_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","7","Ne bo Pita qanam irab tumun erobon isub garei. Isub gar eng mingoan ar qei git goan ouriamir eng soro ar et igama garei. A mingoan ger Yisas tarit waat tumuniamir eng gar eng wonou wes opur et boat musub bigumirei igama garei. ");
INSERT INTO wnu_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ne bo munon ger gigit dier eng bo tumun erobon isub gab oabigorei. ");
INSERT INTO wnu_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Qen end ombur gab qob qoan gumatemir eng ‘Yisas wo bo igomot der bugemba’ ende igoar eng ombur me imbigau. ");
INSERT INTO wnu_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ende at wogub ombur ginamt isumirei. ");
INSERT INTO wnu_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ne bo Maria diab tumun gabut et naget eab igo ne mag ya ten bo gerer der irebig asiamorei. ");
INSERT INTO wnu_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Asi gar eng Qenu wonou enger ombur mingoan oan nob qumaniamirei igo der Yisas bigumir uput end ger tarit itet ne ger gotent umot bugab igurei. ");
INSERT INTO wnu_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ende ibegea ne ombur nob qamamir: “Meimet qamb eab qib igoan?” Ende qamarari Maria qamar: “Yonou munon barai mumun eng biruet ba iua eret bigurei qi eng me gab eab qib igoum.” ");
INSERT INTO wnu_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ende wurinob qamb wogub igeser asi Yisas naget igama garei. Gab eng munon ger qamb wagerei. ");
INSERT INTO wnu_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ne Yisas der Maria qebi qamar: “Ne yourt asi eab qib igoan?” Ende qamara Maria wo munon man eng wonou ur eng qib igo qamb nob qamar: “Io, barai, yonou munon barai eng ne wabi big igo gab eng yiimbiga baab gibam.” ");
INSERT INTO wnu_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ende qamara Yisas Maria unumot qas nob qamar: “Maria,” qamara Maria igeser Yisas imbig nob qamar: “Rabonai” (Yuda wurinou qob eng qanam eng ‘Imbigau munon.’) ende qamb is beeiba Yisas taisi qamar: ");
INSERT INTO wnu_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","“Ne me yar yebe, ye tain qani me iroau. End ne ne isub yonou munon banam eng ne yegan end wurinob qamara igunor. Ye yonou Tain, an gor Tain, ne gor yonou Qenu an gor Qenu eng wo wan iribam.” ");
INSERT INTO wnu_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ende qamara Makdala Maria eng isub Yisas wonou imbigau yurau eng wurinob Yisas gar eng ne qob nob qamar eng gugum wurinob qamarei. ");
INSERT INTO wnu_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Sande end worom isa wogub wonou imbigau yurau eng Yuda munon wurit yari ne erogori munai garit isub mondir ubet taisi wogub igamari Yisas diab wobon et naget igama geari wurinob qamar: “Io, oau mein big igoarar.” ");
INSERT INTO wnu_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ende qamb ubent waramir sirigum eng ne dagar qeret gumatemir sirigum eng gugum wurisiribiga gamirei. Gab ininou munon barai gaun qamb borusi mismisiramirei. ");
INSERT INTO wnu_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ende abari Yisas bo der wurinob qamar: “Oau mein burab igamari Tain yiimuriamor gas ende ye an animurimoum.” ");
INSERT INTO wnu_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ende qamb qebman wurit arir qamar: “Igomurur qau anit isa. ");
INSERT INTO wnu_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","End ne an munon qei qomon boru abari end me misir igunon eng mom uburiba. A qomon boru abari ibag me wurimusiorunon eng mom ende igoriba,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Qen end imbigau yurau mondir ubet taisi igamari Yisas wurit dier eng munon gari qas me wurinob igamau eng Tomas, unum ger Didimas. ");
INSERT INTO wnu_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Yisas ende geari qoa wogub ne Tomas deara nob qamamir: “In munon barai gunei.” Qamarari Tomas wurinob qamar: “Yonou magqurt ain qer ubent big waramir eng ne qauri dagar qeret gumatemir sirigum eng gagar gab ne apand qemeribam, ar eng ue,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ne bo Sande ger ende der Tomas ne yurau qei eng erogori bo mondir ubet taisi wogub mor igurei. Igamari Yisas wobunobun et diab naget qamar. Oau meinburab igoarar.” ");
INSERT INTO wnu_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ende qamb ne Tomas wonou sir nob qamar: “Tomas, see qas der naget yonou uben e gab ne dagar qeret et uben big ge. Gab ne yet oabig wog.” ");
INSERT INTO wnu_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ende qamara Tomas qamar: “Yonou Munon Barai ne gor yonou Qenu.” ");
INSERT INTO wnu_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ende qamara Yisas nob qamar: “Apand quran ego ye yegab apand quran. A munon qei yonou qob toau qas igub yet oabig mismisiraur eng ne ye yegab mismisiran eng netanamimour,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yisas qomon qiribiten wes-wes irou ebet wonou imbigau yurau wuriimbigor eng ye gugum buk et me gumaum. ");
INSERT INTO wnu_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Qob qei gumaum eng wanunger ne Yisas wo munon inubersiau tari end wot oabigor. Wo Qenu wau ten. Wot oabigunon eng wo gab-gab ne Qenu anseara qenen bebereg igoruboumon. ");
INSERT INTO wnu_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","2","Qen geret Yisas wonou imbigau yurau eng is ya tai Taiberius qani end igamari bo wurit dibentarei. Wuri igamari dibentar eng ete: Saimon Pita ne Tomas unum ger Didimas. Ne Nataniel wo ai Galili ginam Kana eng ne Sebedi wonou wau ombur eng ne Yisas wonou wuriimbigau munon ombur ger, ende erogori igurei. ");
INSERT INTO wnu_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Igoi wogub Saimon Pita der yurau qei wurinob qamar: “Wa, ye yagwait dob bir arir qib igorib qamb iribam.” Qamara qei qamamir: “In nob iruboun,” qamb erogori tabin geret isub iramirei. Irab itum end dob ariramir eng wai ger yar erobon me isau. ");
INSERT INTO wnu_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ende at qib igamari worom weib deara ya gabut end asi gamir eng Yisas naget igama gamirei. Gab Yisas wonou imbigau yurau eng Yisas wo sir me imbigau. ");
INSERT INTO wnu_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ende geari wurinob qamar: “Wau, an mi ger baiumanei, qiyo?” Ende qamara wuri qamamir: “In mi ger me baioun.” ");
INSERT INTO wnu_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ende qamarari bo wurinob qamar: “Ende gab eng irab dob uberegent wes end bo arir yagwai qei bauboumon.” Ende qamara bo uberegent wes end ariramari yagwai irou yar erobon isorei. Isa maigas me ubumot dearau. ");
INSERT INTO wnu_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ende gab Yisas wonou imbigau yurau end munon ger Yisas wonou sig qenunget igo eng der Pita nob qamar: “Munon eng Munon Barai gari wen.” Ende qamara Saimon Pita imbig ne wonou mingoan it sarau beeib qamb neri bigor eng bo naget ne yag qumo orubor isorei. ");
INSERT INTO wnu_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Isa yurau qei yagwai ubumimari tabint deara baab ten ya gabut yaremirei, ya gab sig pa ue end. ");
INSERT INTO wnu_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ende yarab tabin wogub ag darab gamir eng mut ger gumet yag wai isetemir eng ne mani parau nob mutet end igama gamirei. ");
INSERT INTO wnu_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ne Yisas wurinob qamar: “Yagwai se baioumon eng qei ba yarari.” ");
INSERT INTO wnu_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ende qamara Saimon Pita tabin mor ito isub yagwai dob ten ubumimari ag qumo dererei. Dara yagwai aib-aib erobon isuor eng wanungeramir eng 153-ende. Yagwai irou erobon isuor eng dob bais ger me purau. ");
INSERT INTO wnu_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ne Yisas wurinob qamar: “Yarab mi niar.” Ende qamara wonou wuriimbigau eng der qebi qomorub misir me igau, gugum Yisas imbig wugumirei. ");
INSERT INTO wnu_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Wuri isari mani parau mutet igoar eng ba wurisab ne yag wai eng gor wuriserei. ");
INSERT INTO wnu_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yisas umb der bugab qib wonou imbigau yurau wurit dibentar eng see qen ombur gari ende wurit dibentar eng. ");
INSERT INTO wnu_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Mani ende wurisa niari wogub der Saimon Pita nob qamar: “Ne Saimon Pita, ne Yon wonou wau mai munon qei e ye yeqenungour eng wuritanami mom yeqenungan qiyo?” Ende qamara Saimon Pita qamar: “Io Barai, ye nonou munon banam eng nonou mom yiimbigan eng.” Ne Yisas bo nob qamar: “Ende gab eng yonou wai sipsip yeim eng gagar musub oroar igoar.” ");
INSERT INTO wnu_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ende qamb ne bo qen omburt qebi qamar: “Saimon ne Yon wonou wau, ne mom ye qenungan qiyo?” Ende qamara wo qamar: “Io, ye nonou munon banam eng ne mom yiimbigan eng,” ende qamara Yisas bo sabar qamar: “Yonou wai sipsip eng musub oroar igoar,” qamar. ");
INSERT INTO wnu_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ne bo sabar qen ombur garit qamar: “Saimon Yon wonou wau, ne yonou munon banam qiyo?” Ende qamara Yisas Pita qen ombur garit eng qebi qamara oau quguraget igoi wogub nob qamar: “Io Barai, ne mi gugum imbig igoan. Ne ye gor mom yiimbigan eng, ye nonou munon banam.” Ende qamara Yisas nob qamar: “Yonou wai sipsip yurau eng musub oroar igoar. ");
INSERT INTO wnu_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ye apand nonob quraum, see ne moit end nonou numungoan big tuen nonou qumani ne ginam eret qoaib eng ar iua igoan. A isi yarab qen geret ne isigi burab ne uben bemeni igama munon qei numungoan begetet tuen qumanimetet ne nebaub ginam ne me isib ierinen end nomot isubour.” ");
INSERT INTO wnu_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yisas qob eng Pita nob qamar eng qen geret Pita werei maigas at umb ne Qenu unum ba dibesieriner end nob qamarei. Ende nob qamb wogub qamar: “Ye qob nenob quraum eng toat ende ebet qib igoar,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Qamara Pita igeser mogirt asi gar eng Yisas wonou munon qenunget igoar eng igama garei. Munon eng qoan erogori mani bugab nub igo der Yisas ete qebi qamar eng: “Barai, your ne duima nanambour?” ");
INSERT INTO wnu_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Qamar eng naget igama Pita igeser gab Yisas nob qamar: “Barai, munon e mai?” ");
INSERT INTO wnu_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Qamara Yisas taui qamar: “Mai, munon eng igama ne ye bo darab gibam ende qemerin eng mai ne mi nob end? Ne ar ye toat qib igoar.” ");
INSERT INTO wnu_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ende qamara qob toau wonou imbigau yurau qei eng igub, “mai munon eng me uminerei,” ende misir igumirei. Ende misir igumir ego Yisas qob eng qamar eng munon eng me uminerei qamb me qamarau. Ue, wo qamar eng ete: “Munon e igama ye bo der gibam qemerin eng mai ne mi nob end gab quran?” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Yisas wonou imbigau munon wot ende qamar eng ye gari. Ye see qob eng gagar qamb gumaum eng apand ar. ");
INSERT INTO wnu_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yisas qomon qiyo sarau gugum ebeter end qob suab wes-wes gumaunor eng in munon ai qent e ininou buk gugum uburiba, qob ar ui igoriba. ");
INSERT INTO wnu_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Io Tiopilus, qob gigit gumat nenob qamam eng bo sabar nonob qemerine ig. Qen end qob gumat nonob qamam eng mi gugum Yisas ago ete ebetri qib igama ur Qenu mot qite irer eng nonob qamamei. ");
INSERT INTO wnu_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","End ne wo qite me iroau igama ne Qenu wonou Igomurur qau eng wonou imbiga ne wonou munon yurau wuriimbig qib igoar eng wuriba sarau obounor eng wuriimbigor eng. ");
INSERT INTO wnu_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ne Yisas wo waramari uma tumuniamirei igama bo der bugab qen 40-ende bo ago e qib igoai. Qen end qenen wonou wuriimbigau munon yurau eng wuri eret igamari eng qenen wurit dibent igoai. Eng wonou imbigau yurau eng Yisas mom umorei qomorunor qamb wurit dibent igo ne, Qenu qomon qamb wo munon oroar igo eng gagar wuriimbig igoai. ");
INSERT INTO wnu_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","5","Ne qen geret Yisas wonou yurau nob qiumuni mi nub igo ne wo der wurinob qamar: “An Yerusalem qand wogub ai taut me iuar, an et igo qoan yonou Tain Igomurur qau imurima der annonogursieriner qamb qamar eng, wo der annonogursia ne Yerusalem wogub iuar. Eng Qenu Igomurur qau imurima deriner end gigit aninob qamam end se bo ete aninob qemerin: Qoan Yon ya asint munon obotar wurimaragansiarei. A Ye Igomurur qau ten anobotar anmaragansierin qen engu pi bura,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ne qen geret Yisas wonou wuriimbigau munon yurau eng nob bo ai qaur nam Olib mon aib igo end iramirei. End irab qiumuni igo Yisas qebi qamamir: “Barai, qoan Isrel wuri munon tarinob King eng oroar igama yurau aib qeretutnob igour eng gas ende see bo ne inoar igama uber igorun qiyo?” ");
INSERT INTO wnu_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ende qebi qamarari ne wo bo der taui qamar: “Mi eng maia an sarau ger nob ende gab ig qamb igoumon? Tain wonomi qen ger gab mi eng ebeib qamb eng ar ebeiba. ");
INSERT INTO wnu_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","End ne an ar qoat igamari wonou Igomurur qau eng imurima der anit isub annonogursieriba. Ende aba ne an der isub yedibesi qamb a yonou sarau baum eng munon ginam Yerusalem a Yudia, Samaria ne munon ginam gugum isub yet qob suari igubour,” ende wurinob qamarei. ");
INSERT INTO wnu_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Yisas qob eng ende wurinob qamb bis ugab ne Qenu mot iroa qiter geari-geari ir igoai. Ir iri-i waber erobon isa me gab wogomirei. ");
INSERT INTO wnu_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","11","Qen end Yisas waber erobon isa me gab ebetemir e munon ombur-ombur mingoan oan qenengi nob qumaniamirei igo diab wurinob naget igo ne qamamir: “An Galili munon, an meimet qamb Yisas erer qite iroa gub qamb asi igoumon? Qenu wonou mot ira. Qen geret eng iroa gaumon gas ende bo igeser deriba.” ");
INSERT INTO wnu_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ende wurinob qamarari wogub Yisas wonou wuriimbigau munon eng ai qaur eng wogub ginam aib Yerusalem qumo isumirei. Sig pa ue, pi. ");
INSERT INTO wnu_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ne munon yurau eng ginam aib Yerusalem qumo isub isi wurinou munai igoi wogub iramir end isub iri munai tumbigi erer qitend ir igurei. Ne munon yurau eng Yisas nob qib igour eng wuri unum eng Pita, Yon ne Yems Andru nob ne Pilip Tomas nob ne Bartolomyu Matyu nob, ne Yems ger ur unum Alpius, ne Saimon ger munon yurau qei wurinob Rom gabman sarau eng wagar qamb ebet igoar eng ne Yudas ger ur unum Yems. ");
INSERT INTO wnu_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Munon yurau engu ne yamangar qei, ne Yisas wonou unor Maria ne Yisas wonou umuragrari eng gagar gugum qiumuni igo ne Qenut qenen igub igurei. ");
INSERT INTO wnu_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ne munon yurau eng Yisas toat igour eng wuri gugum 120-ende. Qen geret qiumuni Qenut qebi qomorub at igurei. Ende qiumuni igo ne Pita wo wubunobun end der naget wurinob qamar: ");
INSERT INTO wnu_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Io, ye qob ger munon Yudas Iskariot wo tap maigas gab Yisas mirimausi mot nob isine munon qarau mot isub uyort bigar qamb ebeter eng. ");
INSERT INTO wnu_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","In gun, qoan Yisas wo in erogori inamar qomon inimbig qib igoai. ");
INSERT INTO wnu_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Isi yarab qen geret wo misir boru igub ne Yisas ende ba sumungasi wogub ne wo nomon qur bis ai ger taui baurei. Baub wogub ne ai end bo yarsi qur omboipima iriam gugum ag dererei. ");
INSERT INTO wnu_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ende ebet uma qamarari igub Yerusalem munon der ai eng unum qamamir eng Akeldama, qanam eng ete: “Qeru ai end isorei,” ende qamb igour. ");
INSERT INTO wnu_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Pita ende qamb ne qamar: ‘Qoan Qenu wonou Igomurur qau ininou tonoan king Debit nob qamara ne gumater eng qob tau ger Yudas wo eng ebeiner end igoai. Eng igoar end ne wonou qob eng toat ende irimanima. Ne Debit wo uru qei gumaterei. Uru eng ger ete qamb wab igour: Munon eng wonou ai eng munon ger end me igorinerei. Ar seger ai igoriba. Ne uru ger gumater eng tau ger ete wab igour: Munon eng sarau qoan ebet igoar eng bo munon ger uput qamb maribigune ebeiner.’ ");
INSERT INTO wnu_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Ne see qas munon ger maribigune ininou munon barai Yisas der bugamor eng qob eng dibesi qamb ininob sarau baab qib igoriner. ");
INSERT INTO wnu_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Ininou yurau et gari; qen qoan Yon ya Yordan end munon obotarer qen end igoun eng ne isi yarab ne Yisas nob qib igoun eng isi yarab ne qen see Qenu Yisas mot erer irar eng.” ");
INSERT INTO wnu_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pita ende qamb waga ne munon ombur-ombur wurimaribigumirei. Munon ger maribigumir eng unum Yosep Barsabas qamb igour eng, ne wonou unum ger qamb igour eng Yastus. Ne munon ger maribigumir eng unum Matias. ");
INSERT INTO wnu_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Eng ende wurimaribig wogub Qenu qebi ete qamamirei: “Ininou munon aib, ne munon gugum misir ne oau imbig igoan end ne see munon ombur e wurimaribigour e your eng nonou qob qamarau munon igoriner qamb eng inimbig. Inimbiga ne Yudas qomon boru at qibi wogub sarau wogub umb wonou ai wot maribigour end isuor eng uput qamb wo bo eng ebeiner.” ");
INSERT INTO wnu_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ende nob qamb wogub ne munon ombur wurimaribigumir eng unum nomon omburt gumatemirei. Nomon eng qogumt big ba songesi wogub bis ariramari Matias unum nob eng ag dererei. Ag dera Matias unum gab wo sarau baab igoriner qamb maribigumirei. ");
INSERT INTO wnu_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Yisas wonou ur Qenu mot iroa wogub ne qen bais gurum nami ende uma ne Yisas wonou wuriimbig qib igoar eng munai garit qiumuni igurei. Qen eng Yuda wurinou qiumunimau qen aib. Qen eng “Pentikos” qamb igour. (Pentikos qanam eng ete: qen aib Pasova uma wogub bo qen 50-ende uma ne qen aib eng Pentikos qamb igour.) ");
INSERT INTO wnu_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ende qiumuni igo igumir eng mi toau ger moon urundu aib di toaima gas ende tat erer qitet igumirei. Ende igub ebetemir e toau eng isi der munai mor igour eng yab di qorei. ");
INSERT INTO wnu_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ne mi eng mut qarub derau gas ende ebeterei. Mut qarub qei gamir eng munon qebis gas ende wes-wes purab is Yisas nob qib igour yurau eng wurit isubriamorei. ");
INSERT INTO wnu_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Qen end Qenu wonou Igomurur qau eng wurit isub wurinonogursia der qob wes-wes qamb igurei. Qob eng qoan me igub igamau. Qen end qas Qenu Igomurur qau wuriimbiga qamamirei. ");
INSERT INTO wnu_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Qen end Yuda munon wurinou qob wes-wes qamb igour eng diab ginam aib Yerusalem end qiumuni qen aib eng maribigub qamb ebet igurei. ");
INSERT INTO wnu_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ende qiumuni igamari ne mi toau aib ende igub isub gab qiet uburemirei. Qietemir eng Yisas wonou yurau wurinob qib igoar eng wurinou qob gari-gari end qamarari igub ebetemirei. ");
INSERT INTO wnu_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","9","Ende ebet ne qamamir: “Munon e Galili munon sisinam, ego maigas in qob gari-garit Qenu wonou mi wes uberar ebetri igoar eng qamarari igoun? Wa, in munon yurau irou, mai, in qei Partia munon ne qei Midia ne qei Elam ne qei Mesopotemia qei Yudia qei Kapadosia, ne qei Pontus, qei Esia. ");
INSERT INTO wnu_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","11","Ne qei Prigia qei Pampilia a qei Isip munon, a qei Libia munon wurinou ginam aib Sairini qani-qani igour eng ne in qei Yuda munon Rom end igour eng ne qei Rom munon igo ne Yuda wurinou qomon taut igour eng nob Yerusalem end yaremirei.Ne qei tomon ya nipat ai qaur Krit end yaremirei. Ne qei Arebia munon. In munon ginam wes-wes end der qamarari musub igoun.” ");
INSERT INTO wnu_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ende qamb wogub qi nogumer igub igurei. Igoi wogub qei qamamir: “Wa, mi qanam eng maigas ende e?” ");
INSERT INTO wnu_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ne qei der Yisas wonou imbigau yurau end wurit qinan qob qamamir: “Ue, ar ya uter nub qanganget qabri igour.” ");
INSERT INTO wnu_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ende wurit qamarari ne Pita der naget qugiab wurinob qamar: “Yonou yurau erogori eng ne an munon ginam taut isari erogori Yerusalem e igo ne mi e gab qanganget misir qebebi igoumon eng qanam dibesi qemerine igar.” ");
INSERT INTO wnu_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ende qamb ne qamar: “An qei in ya uter nub qangangetorour qamb misir igoumon eng, ende ue. Se worom mom gagamarar e ya niau qen ue. ");
INSERT INTO wnu_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Mi eng gaumon eng qoan Qenu wonou munon ger Yoel nob qamara gumater eng irimanima see gaumon eng.” ");
INSERT INTO wnu_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Eng ete nob qamarei: Qen sindomund pi bura ne yonou Igomurur qau imurimine der munon gugum wurit isiba. Wurit isa ne wau moi der inigau gas ende ebet gubour. Ne munon baraitari eng gor ende sig. ");
INSERT INTO wnu_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ne yonou sarau munon yamangar eng gugum qebenau qau wurit isiba. Isa ne yonou qob uber qanam dibesi qomorubour. ");
INSERT INTO wnu_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","20","Ende abari ne ye qomon wes eng tatet qitend ebeibam eng ete, worom mag waber ne ai ituramba ne inaun mag qeru gas ende buriba. Ne ag end qeru qamb mut aib ooiba. Ne iap aib di worom mag umimba. Mi eng gagar ende mirorub gab igamari ne qen sindomund end aninou munon aib eng yonou qer gagam eng ansirbigiba. ");
INSERT INTO wnu_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Qen end your yet oabig igo eng ye mot diab musine me uminerei, mom qenen bebereg igoriba. Qob tau eng qoan Qenu wonou qob gigit qamarau munon eng Yoel nob qamara ende gumaterei. ");
INSERT INTO wnu_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Pita ende wurinob qamb ne bo imusi qamar: “An Isrel munon, ye qob ger qemerine musub igar. Nasaret munon Yisas eng Qenu imurima dara ne wonou nonogursia sarau gagam wes ebet, toar munon wurimusub ebet qib igoar eng. Wo sarau eng aba an gab igoumon eng.” ");
INSERT INTO wnu_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ende qamb qamar: “Qoan Qenu wonou Yisas anit imurimb qamb misir igorei. Eng imurima dara ne an bo munon qarau wurit imurimari isa nam qent big waramari umor eng. ");
INSERT INTO wnu_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Eng waramari uma tumuniamir eng Qenu bo menima der bugamor eng. Der bugab ne wo git goan uter wab qiyo mi qei-qei borumisir igub qib igoar eng gugum tumunt end wagerei, Yisas wonou wesi ar. ");
INSERT INTO wnu_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Eng king Debit Yisas mi eng gagar wot dieriner eng qoan qamb ugarei. Ete qamarei: Ye gaum e Munon Aib qenen yoat igo ne ye tenori mom igo eng gab ye me yariminei. ");
INSERT INTO wnu_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ye nanabart uru wab uberet ne mi uber dieriba eng gab qoat igoribam. ");
INSERT INTO wnu_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ende at igimine ne ne qorasi ginam end ye me yenausierinenei, ne gor nonou sarau munon uber eng waga tumunt end me bierinerei. ");
INSERT INTO wnu_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Igom der bugab qenen bebereg igamau tap eng yiimbigonei, ne gor qenen yenob igama ye mismisir igoribam. ");
INSERT INTO wnu_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Pita qob eng ende qamb ugab wogub bo qamar: “Ininou tonoan king Debit qob eng qamar eng ye bo musub qemerine igar. Eng wo qamar eng wonomit me qamarau, wo qoan uma wogub tumunimari biet isuor tumun qas qoat igoun e. ");
INSERT INTO wnu_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Debit wo git Qenu wonou qob munon igoar end ete nob qamar: “Nonou wau misinam der isunor tumbigi end munon ger ne king gas ende darimba.” Ende qamar end qamarei. ");
INSERT INTO wnu_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Pita ende qamb ne qamar: “Debit wo Qenu mi qen ger ebeiner eng wo qoyam imbi-imbi end ne Qenu wo munon ger init imurima der bo inamar iriner qamb qamar eng wo der umb bo igom der bugemba. End ne wo qamar eng: Qenu waga mom umb me bierinerei. ");
INSERT INTO wnu_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Munon eng wot qamar eng Yisas der uma wogub Qenu bo menima der bogoma in gaminei, end in qob suab qib igoun e. ");
INSERT INTO wnu_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Wo der bogoma ne wonou bo mot irer eng see Munon Aib uberegent bugab igo. Ne Ur wonou qebenau qau utib qamb qoan qamar eng see mi eng gagar in ubune gaumon eng, Yisas wo init imurima dara. ");
INSERT INTO wnu_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","End ne in gun Debit wo qob eng at qamar eng wo git erer qite irab gab wogub der me qamarau. Wo ar ende qamar: Qenu yonou Munon Aib eng nob ete qamar: Ne diab ye yenob igoar. Ne ye nob igama ye ebine ne nonou munon qarau eng ne orotanami igoriban. ");
INSERT INTO wnu_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Debit eng qamar end an Isrel munon mom imbigar: munon Yisas eng qoan an io qamarari munon qarau ba nam qent erer big waramir eng. Waramir ego Qenu wonou bo aba wogub munon aib igo, munon eng Qenu init ininob igoar qamb maribigorei. ");
INSERT INTO wnu_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Pita ende qamara wogub munon eng igub borusi oau quguragetemirei. Ne qei der Pita ne Yisas wonou yurau qei wurinob qamamir: “Ende gab eng in maigas obouboun?” ");
INSERT INTO wnu_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ende qamarari ne Pita bo der qamar: “An gugum qomon boru-boru eng mogirt wab wagar. Wagari ne in Yisas uput qamb igoun end ne ya obotar anmaragansiune ne Qenu an qomon boru eng anit wab ariramba. Ende ebet ne wonou Igomurur qau eng imurima anit isub annonogursieriba. ");
INSERT INTO wnu_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Eng wo qoan qebenau qau eng anit imurimine annonogursieriner qamb qamar eng aninou wau misinam der isunor end gor. Ne gor munon yamangar ai gugum ininou Qenu Aib eng wurit ara wot oabigunor eng gor wonou Igomurur qau eng wurit imurimine woromar igoar qamb qamar eng irimanimba,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pita qob qebebi ende wurinob qamb wogub ne bo qugiab wurinob qamar: “An ye qob quraum eng an igub wogub qomon boru eng imusi at igorunon eng munon qei qomon at igour eng nob garisi boruburuboumon,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Pita munon yurau aib eng ende wurinob qamb igama igoi munon 3,000-ende Yisast oabigari wogub wurimaragansi ya obotaremirei. Ende abari ne Yisas wonou yurau gigit igour eng nob soriamirei. ");
INSERT INTO wnu_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ende ebet wogub Yisas wonou wuriimbigau munon yurau eng qob wuriimbigari igub qamb wuri qenungar ne qenen erogori bugab mi nub mismisir, ne erogori Qenut simot ab ende ebet qib igurei. ");
INSERT INTO wnu_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ne Yisas wonou wuriimbig igoa yurau eng Qenu wurisia qomon wes-wes abari mi git dibenara gab qesi igara igurei. ");
INSERT INTO wnu_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Munon yurau eng wuri ende gab apand mom Yisast oabig ne misir gari big wurinomi gari-gari eng wurinomi tetemi me qamarau, ininomi erogori gari ende qamb igurei. ");
INSERT INTO wnu_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ende at ne qei der ai qiyo mi wurinou gari-gari eng munon qei wurisab nomon qur taui ba ne nomon qur end bo mani taui ba munon mi ue eng wurisab ende at igurei. ");
INSERT INTO wnu_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ende at qen gugum Yerusalem munai aib Tempel qamb igour end qiumuni Qenut simot ab ende at igurei. Ne munon yamangar Yisast oabig igour yurau eng tau purab munai ger mor end isub, tau purab munai ger end isub erogori mi nub a mi qob eng ebet borusi mom mismisir ne Yisas qen aibt qomon ebetri igoar eng toat ebet ende at igurei. ");
INSERT INTO wnu_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Munon yurau eng Qenut igub erogori mismisir ende at qib igamari Yerusalem munon qenen eng ibagamir eng sig uber gab abari ne Qenu wuri oau menima wuri gor diab Yisas wonou yurau eng imusiamirei. ");
INSERT INTO wnu_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Qen geret ai gab-gab Pita Yon nob Qenu wonou munai aib Tempel eng mor isub bo wot qomorub qamb isumirei. ");
INSERT INTO wnu_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Munai end tend aib ger igoai unum eng ‘Sig maieng’ ende qamb igurei. Tend aib eng gabut end munon ger set unor baia goten gurumtar eng ten ende igoai. Qib qiyo sarau ger baab ende me at igamau. Qenen mor eng yarub qamb baub qas bear tend gabut end bugamsiari munon mor isub qamb yarari nomon qur yesari mi taui ba nin qamb uben wurit big ende at igoai. ");
INSERT INTO wnu_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ende igama ne Pita Yon nob mor eng isub qamb isumirei. Wuri tend eng isub qamb ebetemir e munon eng ibag nomon qur yeisar qamb uben bigorei. ");
INSERT INTO wnu_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Uben biga ombur ende gab naget igurei. Naget igo ne Pita der nob qamar: “In nan inimbeg.” ");
INSERT INTO wnu_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ende qamarari ne wo nomon qur yeisub quraur qamb mi big-big ibagarei. ");
INSERT INTO wnu_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ende ibegea ne Pita der nob qamar: “Borumesis, ye nomon qur ger igama me netinei. Eng gab ne ye ete nonob qemeribam, Nasaret munon Yisas Krais wo in uput igoarar qamb innonogursi igo end nonob quraum: “Ne der naget is.” ");
INSERT INTO wnu_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ende qamb ne Pita uben arir munon eng banagsia ne goten gurumtar eng wogub bo qand uber ar der nageterei. ");
INSERT INTO wnu_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Naget ne Pita Yon nob mor isari wo nob isub mor oruber-oruber Qenu wot mismisir at qib igoai. ");
INSERT INTO wnu_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ende at qib igama munon yurau aib mor igour eng gamirei. ");
INSERT INTO wnu_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Gab me qangangetarau, munon goten gurumtar eng tend gabut qenen bugab igo nomon qur yeisar qamb qibirat qamb igo eng gari. Ende qamb ne qiet ne gesi igara igurei. ");
INSERT INTO wnu_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Munon uberetar eng Pita Yon nob mom ubent wuribaab ten mor eng qib igurei. Qibi isi yarab ne munai tumbigi ger ‘Solomon wonou munai tumbigi” qamb igour end isi naget igamari munon yurau qebebi ombur ibogoub yaremirei. ");
INSERT INTO wnu_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Yarari Pita der qamar: “Yonou munon banam Isrel an meimet qamb mi aib eng gab qioumon? An ete misir igunon. In ombur qer gagam end mi aib eng obour qamb igunon ende ue. ");
INSERT INTO wnu_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Mi eng gaumon eng Qenu wonou gari. Qenu eng ininou, ne ininou tonoan namungur Abraham Aisak ne Yekop wuri Qenu wot igub igour eng. Ne see eng Qenu wo Yisast wonou qer gagam eng init ba dibesia. Qoan Yisas eng aninou munon baraitari wurit duimanei. Duimari Pailat wegib qamb ater eng an wo im gab me wagau. ");
INSERT INTO wnu_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","An munon boru mindigar qoat wurisearau gas ende munon qoregen eng ende abatamanei. Ebet ne munon mindigar ne igeig qoat eng bo wog qamb qamamanei. ");
INSERT INTO wnu_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ne aninou munon inubersi igo eng duimari waramb tumuniamirei. Ne bo Qenu wonou bo menima der bugab qib igama in ombur gamin end in qob suab qib igoun. ");
INSERT INTO wnu_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","End ne in Yisas wot oabig igoun end wonou gagam end munon e uber bura gaumon e. ");
INSERT INTO wnu_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","End ne ye ete aninob qemerini: Yisas eng munon ar ende qamb an munon baraitari wurinob sir ue end ne ba sumungasiamanei. ");
INSERT INTO wnu_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ego Qenu wonou qob qoan munon qei wurinob qamara gumatemir eng ete: Munon eng Qenu init maribigor eng darab git goan uter wab boruburiba, ende gumatemirei. ");
INSERT INTO wnu_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","End ne see bo an misir ete igar: “Io Qenu Yisas init imurimb qamb qamar eng se. Ende qamb aninou qomon boru at igoumon eng wagari Qenu aninou qomon boru eng anit ba at ariramba. ");
INSERT INTO wnu_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ende aba qen uber yara ne an musub igoruboumon. Igamari qen geret Qenu qoan munon ger init imurima inubersieriner qamb qamar end bo Yisas imurima darab anamar iriba. ");
INSERT INTO wnu_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Wo git eng qand me derinerei se igama igoi Qenu mi gugum ubersieriner qen eng yara ne deriba. Eng qoan Qenu wonou mi qen geret dieriner eng munon qei wurinob qamara gumatemir eng. ");
INSERT INTO wnu_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","In gun, qoan ir Moses ete qamarei: “Ininou Qenu mi qob sogotarer eng wonou qob qamarari munon ger imurima anit deriba aninou tumbig end gari. Ye yemaribigor gas ende gari. Munon eng wo der qob animbig qamara gab eng an tarit mom igar. ");
INSERT INTO wnu_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Munon ger wo qob qamara me igin qamb bagau wagir der qoeiner eng wo Qenu wonou munon yurau end soroi me wurinob igorinerei, wo ar uburab wegiba.” ");
INSERT INTO wnu_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Qoan Moses qob eng ende wurinob qamara ne wuri Qenu qob dibes qamb qib igour eng Samuel ne munon qei gor. Eng in mi see ubune gaumon eng qoan Qenu wurinob qamara gumatemir igo end in qob eng toat mi ubune abar eng. ");
INSERT INTO wnu_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Qoan Qenu mi uber yariner end wonou qob qamarau munon eng qamara gumatemir eng. Ne gor aninou tonoan wurinob qamar eng see anit yariba. Qoan Qenu Abraham nob ete qamar eng: “Munon ginam-ginam nonou wau misinam der isunor tumbigi end ye wurimusieribam,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","End ne Qenu wonou sarau munon maribig imuriamor eng gigit anit dererei. An qomon boru ebetri igoumon eng wogub bo qibanamsi igoarar qamb Pita wo qob qamar eng isi ende. ");
INSERT INTO wnu_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pita Yon nob mor end wurinob igo ne qob wurinob bo qamb igurei. ");
INSERT INTO wnu_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Wurinob qamb qamamir: “Yisas waramari uma tumuniamirei igama bo igom der bugamor end in gor umb der bugomboun,” ende qamarari igub munon baraitari inorou munai qoat igour eng ne munon yurau qei ‘Sadyusi’ qamb igour eng qob eng ende igub wurit borusi mom misiringetamirei. ");
INSERT INTO wnu_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ende at igamari ituramba gaumi diab ombur wuribaab touri mor wuri big ig barim ende der qob wurit ubersiorub qamb ebetemirei. ");
INSERT INTO wnu_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Eng qen end Pita qob qamara igub Yisast oabigumir eng 5,000-ende. ");
INSERT INTO wnu_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Eng ende inemirei igama urigerma ne Yuda munon baraitari eng ne Qenu qomon qoat igour eng ne qomon qerei imbig igour eng gugum erogori Yerusalem umo isumirei. ");
INSERT INTO wnu_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Qen end munon unum Anas wo munon Qenu qomon qoat igour eng wo gigit igoai. Ne Kaiapas, Yon ne Aleksander ne Anas wonou yurau gugum eng end yaremirei. ");
INSERT INTO wnu_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Munon baraitari aib-aib eng ende isub qiumuni Pita Yon nob wuriba woboni wogub wuri qebi qamamir: “An your aninob qamb annonogursia munon eng musiari uberburai?” ");
INSERT INTO wnu_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","9","Ende qamarari ne Qenu Igomurur qau Pita wot isa misir uber igub ne wuri qob qamamir eng taui qamar: “Munon barai-barai ye qob qemerine an igar: in ombur munon qoan goten boruburerei igama musiune uberburer eng. ");
INSERT INTO wnu_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ye ete qemerine an Isrel munon yamangar gugum mi eng imbigar: munon goten gurumtar e bo qib igama gaumon eng in ombur gagam end ue. Nasaret munon Yisas Qenu in boru igumune inubersi qamb imurima dara aninou duimari waramari uma ne Qenu wonou bo meniamor eng wonou gagam end in ubersiune qib igama gaumon eng.” ");
INSERT INTO wnu_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ende qamb ne bo qamar: “Qenu wonou qob ger mit big ete qamarei: Munon nomont mon mindat igour eng wuri nomon uber ger boru qamb siningot at ariramirei. Ariramirei igama munon qei gab bo ba big mon nomon erer end mindatemirei. Nomon eng Yisas. ");
INSERT INTO wnu_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Munon ai qent et ger inubersi qamb Qenu init me maribigau.” Pita ende wuri nob qamarei. ");
INSERT INTO wnu_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Pita Yon nob skurt ger isub qoyam me baiau. Qen end munon kaunsel baraitari igamari qob qomorub qamb qubig daragab me abau. Ar sarog big qob musub ende qamarari ibag qietemirei. Munon ombur eng Yisas nob qib ig qoyam baumir eng imbigumirei. ");
INSERT INTO wnu_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Munon goten musiamir eng ar musub wuri qani naget igama gab ne Pita qob qamar eng me omboariramau. ");
INSERT INTO wnu_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ende gab ne Pita Yon nob bo oromar kaunsel wurinou munai tumbigi end wuri ariramirei. End igamari wurinou bo qebi ibagaiar qamb. ");
INSERT INTO wnu_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ende wuriimuri wogub wurinou qob-qob qamamir: “Munon ombur eng mai wurisioruboun? Munon ginam aib Yerusalem gugum igub ete misir igour: Qenu wurinonogursia obour munon wurinou qas ende me ubunorei. End bo in qetopur me qomorunei. ");
INSERT INTO wnu_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ego qob eng bo tumbigi bigari munon ginam-ginam Yisas unum igunor qamb qoronob wuritaisioruboun,” ende qamamirei. ");
INSERT INTO wnu_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Wurinou qob ende qamb nausi wogub Pita Yon nob wuri bear nagsi wuri qoronob taisi qamamir: “An ombur Yisas unum bo sabar munon ger gab me qamarar. Ne munon ginam-ginam me wuriimbigar, see qas mom wagar.” ");
INSERT INTO wnu_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ende qamarari ombur der taui qamamir: “Aninou imbig gaiar, in an qob quraumon eng toaun qiyo Qenu qurar eng toaun? ");
INSERT INTO wnu_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","In ombur Yisas wonou qomon qob ne wonou sarau aib ebet inimbigor end in maigas me wugunei eng ininou sarau.” ende qamamirei. ");
INSERT INTO wnu_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","Ende qamarari ne wuri der munon ombur maigas me uyort bigunei qamb ne bo qoronob wuritaisiamirei. Eng munon yamangar gugum Pita Yon nob munon goten gurumtar eng ende igama igoi togun 40 qiyo ende umor end ne bo ubersiari uber qib igama gab ne Qenut mismisir igour end kaunsel ininob agununor qamb misir igub ne munon ombur ar wuriimurimari qoamirei. ");
INSERT INTO wnu_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ende wuriimurimari qand wurinou yurau end isub ne kaunsel munon baraitari qob qamamir eng gugum wurinou yurau eng wurinob qamamirei. ");
INSERT INTO wnu_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ende qamarari igub erogori der Qenu nob ete qamamirei: Ne gari munon barai ai tat uyer ya ne mi gugum barsianei igama igour. ");
INSERT INTO wnu_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Qoan ininou tonoan namungur Debit nonou sarau munon eng, nonou Igomurur qau wot diab ete qamarei. Munon boru Isrel yurau ue eng meimet qamb Qenut misiringet nob yogurub qamb at igurei? wuri misuu. ");
INSERT INTO wnu_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ne king ag e ne wurinou yurau eng nob erogori Qenu ne King erer ger init maribigor eng nob yogub igurei. ");
INSERT INTO wnu_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Debit qob eng ende igoar eng irimaniamorei. Herot Pontius Pailat nob munon ar ne Isrel munon baraitari eng wuriba Yerusalem end qiumuni Yisas qarausiamirei. Munon eng Qenu wonou sarau munon uber init maribigorei. ");
INSERT INTO wnu_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Wuri qiumuni mi gugum nonou qamb nausien eng mi gugum nonou gari tari igoan. ");
INSERT INTO wnu_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","End ne ininou munon aib in nonou sarau munon end ne munon qei ne nowogub ininob agunub inamar quraur. End ne ne innonogursia nonou qob qamarau end me qubig me yariomun. ");
INSERT INTO wnu_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ne gor nonou qenungau end munon toar nob eng wuri ubersi ne qomon wes-wes Yisas gab-gab init aba dibeneriner.” ");
INSERT INTO wnu_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Qenu nob ende qamb wagari ne ginam qiumuni igour eng iua igumir eng bo yarimau misir me igau, Qenu Igomurur qau wurit isub wurinonogursia sarog big qob qamb qib igurei. ");
INSERT INTO wnu_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Munon yamangar gugum Yisas qob igub wogub wot oabig ne misir gari big ne wurinomi gari-gari end ininou gari me qamarau, ininou gugum gari qamb mi eng bear erogori qerei baub igurei. ");
INSERT INTO wnu_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ende at ne Yisas wonou wuriimbigau munon eng der Munon Aib Yisas der bugamor qob eng qamarari munon yamangar igumir eng qeretutnob. Ende abari ne Qenu Yisas imbigau yurau eng wurinonogursia ne erogori uber igurei. ");
INSERT INTO wnu_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Ende igo ne munon ger mani qiyo munai nomon qurt qoot me abau. Munon ger mi eng gar ue gab qamara eng munon qei der wurinou munai qiyo ai qamb eng munon ginam qei wurisab nomon qur qiyo mani taui ba munon mi ue end wurit qerei ba erogori uber igurei. ");
INSERT INTO wnu_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Qen end Saiprus munon ger unum Yosep unum ger bigumir eng Barabas, unum eng qanam eng ete: munon oau wurinonogursiau tari. Wo munon Qenu munai qoat igour eng wurinou yurau. ");
INSERT INTO wnu_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Munon eng wo ai ger igoar eng munon qei wuri imbiga baub nomon qur taui utari ba Yisas imbigau yurau eng wurisa baub munon yamangar gugum wurit qereiamirei. ");
INSERT INTO wnu_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Munon eng ebeter gas ende munon ger ubeni nob igurei. Munon unum Ananaias ne ubeni unum Sapaira. Wuri gor wurinou ai ger munon qei wurisab nomon qur end taui baumirei. ");
INSERT INTO wnu_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Baumir eng nomon qur eng gugum bisub Yisas wuriimbigau yurau eng me wurisau tau aib ubeni nob wurinou wabi wogub tau iosi ete bis wurisab wurimurimar qamamir. Nomon qur ait baioun eng ende gari,” ende qamamirei. ");
INSERT INTO wnu_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ende abari ne Pita der Ananaias nob qamar: “Satan ne misir ba songesia ne ne diab yemirimot: ‘Ait nomon qur taui baioun eng ende gari,’ qamb Qenu Igomurur qau mirimanei. ");
INSERT INTO wnu_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Eng ai end, qoan ai eng nonou tetemi igoar end taui nomon qur baub qi engu aninou qi. Bo qiumuni ete maribig wogub nomon qur taui ba gugum bigibam qaman end bo ba tau aninou wabimoumon, end in me inmurimoroumon, Qenu mirimoumon,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","6","Pita ende nob qamara Ananaias uburab isub umorei. Ende uma ne wau moi qei yar mumun bis tumunimari munon yamangar end gab yariamirei. ");
INSERT INTO wnu_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Bais umi-umi ende at ne ubeni bo diarei. Dier eng umami uma bis tumuni qib igour eng wo sir ue. ");
INSERT INTO wnu_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ende dera ne Pita der nob qamar: “Ie, an namami nob ait nomon qur baioumon eng gari ye ba di yosoumon ne?” Ne ubeni qamar: “Aqa, nomon qur ait baioun eng gugum gari ba di notoun eng.” ");
INSERT INTO wnu_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ende qamara Pita qamar: “An namami nob meimet qamb Munon Aib Igomurur qau warigesi ebet igoumon? Ne ge, munon tendet quma yar nogour eng namami bir tumuni wogub yar naget igour ne gor see qas ne bir netumunimbour.” ");
INSERT INTO wnu_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ende qamara ne wo gor Pita gotent end umb isorei. Ende uma gab ne wau moi umami bir tumuni wogub yaremir eng bo ubeni bir umami qani end tumuniamirei. ");
INSERT INTO wnu_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Eng ende abari ne Yisas wonou yurau buremir eng ne munon ginam ar qei qob eng toau isa igub borusi yariamirei. ");
INSERT INTO wnu_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Qen end Yisas yurau Qenu sarau qeretutnob beari wogub munon yamangar gugum Yisas qenunget ne qenen is Qenu munai aib end isub ne munai tumbigi ger: ‘Solomon wonou munai tumbigi’ qamb igour end is qiumuni igurei. ");
INSERT INTO wnu_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Qenen ende at igamari munon Yisas yurau ue eng der ende ebet igamari ibag qamamir: “Munon yurau eng uber ebet igour,” ende qamb qen end me wurisorimau. ");
INSERT INTO wnu_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ende ebet igamari igoi mesenau-mesenau munon yurau qei Yisast mom oabig yarab wurisoriamirei. ");
INSERT INTO wnu_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Yisas yurau sarau ende baab abari munon qei ibag ne toar munon qei saberit wuribig bear tap goant wuriinesiune Pita isub wuribea toar wagar qamb. Ne qei ende igamari Pita yar isa qenein erer wurit isa uberburer qamb ende ebetri igurei. ");
INSERT INTO wnu_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ne gor munon qei Yerusalem qani-qani igour eng wurinou munon toar asin igab igoar eng ne qei ai bigau igaramor eng woromar Yisas imbigau yurau end diarari wurimusub ende at igurei. ");
INSERT INTO wnu_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","18","Ende abari munon gugum orotoar abari ibag ne munon qomon qoat igour baraitari aib eng Sadyusi qamb igour yurau eng outet wogub diab Yisas imbigau yurau eng wuribaab uyort wuribigumirei. ");
INSERT INTO wnu_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","20","Ende wuri bigumirei igamari itum end Munon Aib wonou enger der wuri beasi mondir weimatar oromar ago der qamar: “An Yisast oabig igoumon end anubersiar end Qenu mon aib end isub qob gagam wurinob qamarari igunor,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ne wuri enger qob toat munai eng wogub Qenu munai aib mor isub qob qamb igurei. Ende igamari ne munon qomon qoat igour baraitari aib eng ne Yuda munon baraitari eng nob bo mom qiumuni qamb qob mai qi gab sarau qenen werisub qamb Yuda baraitari eng wurinou burtuum wuriimurimari isub woromar diarar qamb wuriimurimari isub gamir eng munon eng mor end me igamau. ");
INSERT INTO wnu_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","23","Ende gab ne burtuum bo diab qiumuni igour eng wurinob qamamir: “In isub gaun eng munon oroar igour eng ende naget igomorourei ne mondir nausi ubetemin eng gor ende igama ininou wei mor isub gaun eng munon eng me igamarau.” ");
INSERT INTO wnu_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ende di qamarari ne burtuum wurinou baraitari eng ne qomon qerei igour wurinou gigit eng der qamamir: “Wa, Yisas wonou imbigau yurau eng mai uburei ii?” ");
INSERT INTO wnu_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ende qamb igamari ne munon ger yar qamar: “Munon uyort wuri bigumon eng irab munai aibt ite munon qob wurinob qamb igour.” ");
INSERT INTO wnu_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ende qamarari ne burtuum baraitari eng nob burtuum ar qei wurinob irab munon eng oromar yaremirei. Wurinob yarab oromar me qamarau, ende ubune munon qei der nomont iningarimunor qamb ar wurinob isumirei. ");
INSERT INTO wnu_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Isi yarab kaunsel ne qomon qerei igour eng qiumuni igamari bis wubunobun end wuri nagsiamirei. ");
INSERT INTO wnu_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Ende naget igamari ne wurinob qamamir: “An Yisas qob eng qamb qib igamari mom wagar qamb uyort an bigumin eng bo sabar meimet qamb ir wurinob qamb igomoroumanei? See ir qamarari Yerusalem munon yamangar gugum Yisas imbig ugaur. Mai, Yisas umor end init mai qamarar qamb. ");
INSERT INTO wnu_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ne Pita wonou yurau erogori eng der taui qamamir: “In Qenu qob maigas qurar eng in toat ebet qib igoun. Munangit quraur eng in me tunei. ");
INSERT INTO wnu_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","An Yisas duimari munon qarau ba nam erer big waramari umor eng bo ininou Munon Aib Qenu eng bo meniamorei. ");
INSERT INTO wnu_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ende ebine yonou gas ende igoar qamb Qenu Isrel munon boru igamari ne Yisas imuriamor end ne wuriubersier end bo sabar qomon boru end misir me iginerei. ");
INSERT INTO wnu_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","In munon qob eng qamb qib igoun eng Yisas qoan inimbigar end ende ubune Qenu Igomurur qau eng in munon yamangar wot oabigoun end mi eng gar aba gaumon eng,” ende qamamirei. ");
INSERT INTO wnu_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ne munon baraitari qomon qoat igour eng qob eng ende igub mom igaramb qamb misir igumirei. ");
INSERT INTO wnu_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Qen end Parisi wurinou munon baraitari aib ger unum Gamaliel. Wo igo munon qei qomon wuriimbig igoai. Gamaliel wo der naget qamar: “Yisas imbigau yurau eng wuriimurimari munai tumbigi geret is igorunor.” ");
INSERT INTO wnu_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ende qamara wuri ag isari ne wo der kaunsel wurinob qamar: “An Isrel munon yurau eng wurit meimi ger me abar, wurinou wagari qi igorunor. ");
INSERT INTO wnu_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","An eng me igub igoumon, munon Teudas ‘yonou uter’ qamb gabman sarau eng wogub munon 400-ende wuriba wurinob yogurib at wogub waramari uma wonou yurau qoamir eng. ");
INSERT INTO wnu_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ne ende gas, Galili munon ger ‘Yudas’ qamb igour eng wo gor munon yurau wuriba Rom gabman sarau eng wogub ‘yonou uter’ qamb at igama waramari uma wonou sarau wagau igoar eng gagar me igubri bo eng at igoumon? ");
INSERT INTO wnu_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","39","End ne ye aninob quraum eng bo munon yurau e sarau obour eng worowagari wurinou qi at qib igorunor. Wurinou misirt sarau eng obounor eng, eng gor sarau eng wagau igama gaiar, a Qenu wurinonogursia ebet qirunor eng an bo mai gas Qenu me bumaimunanei?” ");
INSERT INTO wnu_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Gamaliel ende qamara ne kaunsel burtuum wurinob qamarari Yisas imbigau yurau eng woromar mor diab pisirami igaramb wogub ne qoronob wuritaisi qamamir: “An bo sabar Yisas unum ne wonou qob me qamb qib igoarar, mom et wogub ar qib igoarar,” ende wuri irun wab wogub wuriimurimari qoamirei. ");
INSERT INTO wnu_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Yisas imbigau yurau eng ende igaramb wogub wuriimurimari qoaub qamb borusi mom Qenut mismisir wogub qamamir: “Yisas unumut in git goan uter iningara,” ende qamb wogub qoamirei. ");
INSERT INTO wnu_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ende isub ne qenen munon ginam-ginam iua Yisas qob wurinob qamb ne Qenu mon aib end isub qob qamb qamamir: “Qenu Yisas init maribigor end in uber igoruboun,” ende qamamirei. ");
INSERT INTO wnu_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Qen end Yisas yurau eng bo irou burab wogub ne purab tau ombur buremirei. Yurau qei Grik qob qamb ne qei Hibru qob qamb ende at igurei. Ne Grik qob qamb igour eng der qamamir: “In erogori mi niau qiumuni igoun eng an mani qerei igoumon eng in yamangar qindou qenen mani qeemben me wurisab igoumon.” ");
INSERT INTO wnu_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ende qiamat qamb abari ne Yisas wonou yurau 12-eng der yurau bubun eng wuriba qiumuni ne qamamir: “An in mani qereimar qamb quraumon eng uber ue. In Qenu wonou qob uber qamarau eng ininou sarau. ");
INSERT INTO wnu_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ende gab eng, aninou munon 7-ende wurimaribigari yamangar mani wurisau sarau eng wuri uninim ebet igorunor. Igamari Qenu Igomurur qau wurisia misir uber igub igorunor. ");
INSERT INTO wnu_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ende abari in ininou sarau tetemi Qenu qebi qamb ne wonou qob dibes qamb ende ebet qib igorun.” ");
INSERT INTO wnu_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ende qamarari ne munon yurau eng wurimaribigumirei. Munon eng wuri unum ete: Stiben, wo Qenu apand mom imbiga ne wonou Igomurur qau Stiben boopurima ten igoai. Ne ger Pilip, ger Prokorus, ne ger Nikanor, ger Timon, ger Parmenas, ne Nikolas. Nikolas wo Antiok munon wo Isrel qomon eng toat ne Yisast oabig igoai. ");
INSERT INTO wnu_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Munon eng ende wurimaribigari wogub Yisas yurau 12-eng der wuribaab Qenu qebi qamb wurinonogursiamirei. ");
INSERT INTO wnu_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ende at wogub ne Qenu qob qamarari Yerusalem munon irou ne qomon qoau yurau eng irou qob igub Yisast oabig wurit isub yurau qoan imusimari sig munon yurau irou burerei. ");
INSERT INTO wnu_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ne Stiben wo Qenu Igomurur qau mom boopurima ne sarau qeretutnob baab a toar munon wot derari wurimusub ende at igoai. ");
INSERT INTO wnu_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Stiben sarau qeretutnob ende aba gab ne Yuda wurinou munai ger munon ar song-song qiumuni igoarar qamb mindatemir eng. Munon yurau eng wuri qoan ar is munai ginam aib-aib Aleksandria ne Sairini end igurei. Ne yurau qei Silisia ne ai aib Esia end wuri erogori Stiben wo sarau eng at bea qob toau isa igub nob agunub qamb ebetemirei. ");
INSERT INTO wnu_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ende ebetemir eng wuri qobut maigas me wotanamimau. Qenu Igomurur qau wot diara wogub wo qob uber sig qamarei. ");
INSERT INTO wnu_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ende at sig ue gab wogub munon qei mi wurisab taui wurinob yurune gag qob Stibent big qamarar qamb abari yaremirei. Yarab qamamir: “Ininou tonoan namungur Moses Qenu nob wurit qob isi qamb qib igama igub igoun.” ");
INSERT INTO wnu_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ende qamarari munon yamangar qob eng igub borusi mom misiringetamirei. Ne munon baraitari eng ne munon Moses qomon qerei igour eng gor ende at wogub diab Stiben baab mot kaunsel qiumuni igour end isumirei. ");
INSERT INTO wnu_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Mot isub qamb munon gag qob munon baraitari wurinob qomorunor eng nob isub qamamir: “Munon e qenen ininou qiumunimau mon aib end isub qob isi qamb a Moses qob ba songesi at igo e e. ");
INSERT INTO wnu_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","In igub igumune ete at qamarei: Nasaret munon Yisas eng wo qiumunimau munai aib eng bapami temen mindat ne Moses qomon qei qerei wogub bo qei bubun bigiba ende qamb igoai.” ");
INSERT INTO wnu_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ende qamarari kaunsel qiumuni igour eng der Stiben nan gab igamari wo menman igeser enger menman gas ende eterei. ");
INSERT INTO wnu_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ende aba gab ne munon Qenut mian yab begetet igour wurinou gigit eng der Stiben nob qamar: “Ne qob ger apand ende qamanei igama quraur ii?” ");
INSERT INTO wnu_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","3","Ende qamara ne Stiben wo der qamar: “An eng ye qebi quraumon end ne ye qemerine igar,” qamar. “Qoan Qenu ininou tonoan namungur Abraham wonou ginam qenen Mesopotemia wogub Haran me isau igama Qenu wot di qamar: ‘Ne ginam qenen e wogub ai pa geret isa ye nesirbigine end igoriban.’ ");
INSERT INTO wnu_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ende qamara Abraham wonou ai qenen Kaldia eng wogub ai pa end isib qamb is qataben ginam aib ger Haran qamb igour end weib isorei. End is igama ne Abraham ur uma wogub Qenu Abraham bo ginam end is qamb qamara is igoar eng see in Isrel igoun eng.” ");
INSERT INTO wnu_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ende qamb qamar: “Abraham git ai end igoar eng ai tau ger Qenu sirbig ai tau e nonou tetemi ende me nob qamarau. Wo qob nonogursi qamar: “Ai e qen geret nonou wau misinam der isub ai e baubour. Qenu qob qamar qen end Abraham ubeni wau me baiau.” ");
INSERT INTO wnu_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ende qamb ne qamar: “Qenu qob ger Abraham ete nob qamarei qamar: ‘Nonou wau misinam eng der isub qebebiet ne is ginam geret igo ne munon ginam eng sarau qenen batar igorubour. Sarau eng baab taui mi ger me baunorei. Munon eng der oroar wuriquguragsi ende ebet igamari igoi togun 400-ende weriba, ende qamarei qamar. ");
INSERT INTO wnu_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","End igamari ne ye munon ginam eng wuriquguragsieribam. Ende wuriquguragsine ne wuri der nonou yurau eng wuriwagari bo ginam et diab yet igubour’ ende qamarei,” qamar. ");
INSERT INTO wnu_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ende qamb ne ete qamar: “Qenu Abrahamt qomon bubun ger ebeiner qamarei. Abraham wo munbor wau gab eng goan sopur igama sirigum igama ne qen geret sirigum eng gab ne Qenu qob qoan Abrahamt nausier eng qamb misir igub igorunor,” qamar. Ne qen geret Abraham ubeni wau baia unum Aisak qamb ne qen 8-ende ubura ne Qenu qamar gas ende goan sopuramorei. Ne Aisak barai burab munon tari big irub baurei. Wonou wau Yekop eng ende goan sopuramorei. Ne Yekop wo bo munon tari big irub baub wonou wau 12-ende eng gor goan ende sopumimatarerei. Wau 12-eng wuri in Isrel munon yamangar ininou tonoan namungur,” Stiben ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Stiben qob degesi ende qamb qamar: “Ininou tonoan namungur eng wuri der wurinou ima Yosep wot misiringet wogub munon qob ger qamarau wurisab mi taui baiari wuri mot Isip umo isumirei. Isari wo is sarau ar batar mi taui me baiau, ende ebet igoar eng, Qenu wo me wagau, ");
INSERT INTO wnu_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","musub qoat igama ne qugurau qei wot dier eng Qenu wot biruet igoai. Ne Parao menmant ir qob musierib ater eng Qenu misir weimata qob musub nob qamarei. Ende aba gab Parao Yosep ba gabman sarau aib Isip eng ne wonou sarau qei eng ba Yosep wot waga wo Parao uput qamb mi gugum qoat igoai. ");
INSERT INTO wnu_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ne qen geret qunumber qen aib ai Isip end yar ne iri Kenan end irarei. Ende aba ne ininou tonoan wuri mi ger gab me niau qamar. ");
INSERT INTO wnu_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ne qamar: Yekop igor ego Isip umo mani igo ende qamarari igub wonou wagrari mani taui ba diarar qamb qen qamart wuriimuriamorei. ");
INSERT INTO wnu_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ne qen omburt wuriimurima isari Yosep umomori wurit dibent qamarei, ‘ye aninou ima’ ende wurinob qamara ne Parao wo gor qen end Yosep umomori wuriimbigorei. ");
INSERT INTO wnu_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Eng ende wurit dibent wogub wurinob qamar, An irab tain Yekop nob qamb an nob yarari Isip et erogori igorun ende qamara iramirei. ");
INSERT INTO wnu_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ne wuri irab Yekop mot Isip umo isumir eng gugum 75-ende. Wuri is end igoi isig burab umb uburemirei. ");
INSERT INTO wnu_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ende umari mumun birab Abraham wonou ai Sekem ite Hamor munon wurit tauiamor end bir wuritumuni igurei. ");
INSERT INTO wnu_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Stiben qob eng ende imusi qamb isub igoai. qamb qamar, In munon yurau Isrel eng ende is igo sig irou buremirei. Ende abari ne qoan Qenu Abraham nob qamar eng, munai ginam eng wogubour qamar eng pi burab igo. ");
INSERT INTO wnu_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Qen end munon qoan-qoan umb uburab wogub ne King bubun ger dari ne Yosep wo sarau a qomon uber ebet igoar eng wo sir ue. ");
INSERT INTO wnu_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ne munon aib bubun eng wo der Isrel wuriba sarau qenen wurisab a wurimurimar wuriba sumungasi ne qamar: ‘Isrel yamangar gugum munonbor wau ba gab biua ai qorut wuribigari minemb umb uburunor qamarei,’ qamar. ");
INSERT INTO wnu_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ende at igamari ne qen end Moses unor baub gar eng menman sig maieng gab wonou qi mor wabi ig inau utab igama igoi inaun ombur gari umorei. ");
INSERT INTO wnu_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Moses unor bis ai qorut bigorei igama ne Parao wonou waibo qibi nini gab baub ba di wonou wau ten gas ende qoat igama barai burerei. ");
INSERT INTO wnu_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Barait ne wo Isip munon aib-aib qoyam imbig igour eng gugum wo imbig ne sarau aib-aib baab igoar eng ne qob wurinob qamar eng qeretutnob igumirei. ");
INSERT INTO wnu_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Moses ende at qib igama igoi togun 40-end wara wogub ne wo wonou yurau Isrel eng ibegeib qamb misir gagam igorei. ");
INSERT INTO wnu_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ne qen geret qibi ibagar ego Isip munon ger Isrel munon ger waramb igoai. Ende ibag ne Isrel munon eng wot isub Isip munon eng warama umorei. ");
INSERT INTO wnu_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moses wo ende ebine wonou yurau eng Qenu init maribigorei, inamar irib qamb abar eng ende misir me igau. ");
INSERT INTO wnu_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ne bo barim ende bo qib ibagar ego Isrel munon wurinou ombur bo yogub igamari ibag wuriombopur qamar: “Aninou ombur meimet qamb yogub igoumon?” ");
INSERT INTO wnu_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ende qamara munon eng ger der Moses qob omboarir qamar: “Ne your igo in qomon e ubune yar inoar igorib qamb quran? ");
INSERT INTO wnu_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ne ende at barim qas Isip munon ger warama umor gas ende bo ye yanamb qamb yar qamb igoan?” ");
INSERT INTO wnu_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Moses qob eng igub munon gugum qob eng tubua igub uburari Parao gor igub yanaminer qamb iua ai pa geret is igoai. Ai unum Midian end is qen dirigor igo yamangar ger baia wau ombur igoai. ");
INSERT INTO wnu_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Stiben qob eng ende qamb imusi qamar. Moses is end igama togun bo 40-ende uma Qenu munon enger Moses wonou gari is ai qaur unum Sainai end igo gar ego nam ger mut qarub di igama gar eng mut eng nam uben mun ger me oau. ");
INSERT INTO wnu_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ende gab is ta gib qamb ebeter eng maigas me geau. Ende aba mut qarub erobon end Munon Aib nob qamar: ");
INSERT INTO wnu_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Ye nonou tonoan namungur wurinou Qenu Abraham Aisak ne Yekop wuri yet mismisir igour eng ye. Moses ende igub borusi qiet yari wogub bo qani me isau. ");
INSERT INTO wnu_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ne Munon Aib bo qamar: “Ne ai naget igoan eng ai qau. Goten yau nagan eng qand neriom,” qamar. ");
INSERT INTO wnu_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Qamb qamar: Isip wuri yonou munon Isrel wuriba sumungasiari quguraget eab igamari ibagaum end ne wurinou qugurau eng biruetaribam. Ne dara ne niimurimine Isip ite iriban,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Qoan Isrel munon ombur yogub igamari Moses isa omboariramir eng wo Qenu Isrel munon yamangar oromar iua qamb Qenu maribigorei. End ne enger mut qarub ten namt di nob qamar eng. ");
INSERT INTO wnu_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ne Moses Isip ite irab qomon wes-wes ebet ne oromar is uyer ya mian nob qamb igour eng purab ne ai seger munon ue end qib igamari togun bo 40-ende umorei. ");
INSERT INTO wnu_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Stiben ende qamb qamar: “Moses eng gari Isrel munon wurinob qamar: Qenu wonou qob munon aninou yurau end ger ye yiimuriamor gas ende. ");
INSERT INTO wnu_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ne qamb qamar: Qoan Moses munon yamangar wurinob ai seger igour eng. Ne ininou tonoan wurinob igoai ne ai qaur Sainai end enger nob qobub Qenu qob baub igoar eng, qob eng gugum Qenu wonou qomon ne wonou qob uber eng sisinam inimbigar eng. ");
INSERT INTO wnu_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Moses ende ebeter ego ininou tonoan wurinou Moses qob omboarir ba mogirt wab wogub bo yonam Isip ite diorub at igurei. ");
INSERT INTO wnu_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ne Moses oromar bis ai qaur Sainai qani end wuriwogub wo ai qaurt irab Qenu qob qamara igib qamb irarei. Ende iroa wurinou gari igo ne Moses umom Aront diab qamamir. “Moses inamar bear ininesi wogub qoar engu bo me dieriner qi eng gab ne ne mi ger barsitara ininou Qenu gas ende gab wot mismisir igumune wo ininob qib igoriner.” ");
INSERT INTO wnu_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ende qamarari Aron mi qei ba bur qarig wan qugur ger barsitarerei. Qugur eng gab mismisir ne wai qei waramb end mian yab begetet nub qugur end mismisir igurei. ");
INSERT INTO wnu_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ende abari ne Qenu wuri mogirt wab waga wogub ne wurinou woromt qiyo inaunt qiyo tapait mi eng gagar ininou Qenu qamb wot mismisir igurei. Mi eng gagar ebet igour eng Qenu qamara ende gumatemir eng. Eng ete qamb gumatemirei igo: An Isrel munon yamangar an ai seger end qib igamari togun 40-ende wara ne wai waramb yet me mian yamau, aninou Qenu asin end ebet wurit mismisir igumanei. ");
INSERT INTO wnu_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Aninou ubent qugur barsiaman end qas ebet igumanei. Ende at ne seri mon qomourt ba qib igoumon eng qenu gag Molek eng wonou. Ne qenu gag ger Repan qamb igour eng wonou tapai end qugur barsi ne wot mismisir igumanei. Ende at qib igamari ye animurimine Babilon ite iruboumon, ende qamb gumatemirei. ");
INSERT INTO wnu_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Stiben ende qamb qamar: “Ininou tonoan ai seger ende qib mon qomourt ger ba qib igour eng Qenu apand eng wonou ba qib igurei. Qenu wonou Moses nob qamb imbiga barsiarei. ");
INSERT INTO wnu_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ne ininou tonoan tumbigi eng bo der mon qomourt eng baub Yosua nob irab ne munon ginam di orotoar arir ginam eng baumirei. Baub ne end igamari igoi-i qen geret King Debit dariamorei. ");
INSERT INTO wnu_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Ende qamb qamar: Qen end Qenu Debit musia uber igo ne inorou munai apand ger mindaib qamb Qenu qebi qamar: Ne yonou tonoan Yekop wonou Munon Aib mai nenet igub igamau munai ger mindaini qiyo qamar ego Qenu io me qamara gab wagerei. ");
INSERT INTO wnu_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Wagerei igama Debit wonou wau King Solomon eng wo Qenu wot igau mom eng mindaterei. ");
INSERT INTO wnu_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","End ne an gaiar, Qenu mi gugum qanam end in wonou munai ger mindutune mor end me igorinerei. End ne Qenu qob munon ger ete qamb gumaterei: ");
INSERT INTO wnu_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","50","Erer qite igo ne mi gugum qoat igoum. Ai aib e gaumon eng ye igimine igo. End ne an ye mi ger barsi qiyo mon ger mindisari end me igorinei, mi gugum ye gari barsiamei, ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Stiben qamar: “An misir boru sisinam igub ne munon yurau Qenu qob me igub igour gas ende at Qenu wonou Igomurur qau qenen bir big igoumon. Ininou tonoan Qenu qob qamara bur iruges big igour gas ende an gor ende ebet igoumon. ");
INSERT INTO wnu_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Qoan Qenu qob qamarau munon qei der qamamir: Qen geret Qenu wo munon qoregen init imurima darab inubersieriba,” ende qamamir eng ininou tonoan wurit misiringet gugum igaramari umb uburemirei. Eng ebetemir gas ende see gor an Munon qoregen Qenu init imurima derer eng duimari waramari umorei. ");
INSERT INTO wnu_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Eng an Qenu wonou qomon eng an imbigar qamb wonou yurau enger eng aninob qamarari bagau wagir iua igoumon. ");
INSERT INTO wnu_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Stiben qob eng ende munon baraitari aib-aib wurinob qamara wuri borusi mom misiringet topor igurei. ");
INSERT INTO wnu_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ende abari ne Qenu Igomurur qau Stiben wot isa qiter asi Qenu igama wonou mi begen qenengi nob eng gab ne Yisas Qenu uberegent wes end naget igama garei. ");
INSERT INTO wnu_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Gab wurinob qamar: “Ye gaum e Munangit wau Qenu uberegent wes end naget igama gaum.” ");
INSERT INTO wnu_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ende qamara ne wuri qob eng me igun qamb iruges ba taisi yarab bamirei. ");
INSERT INTO wnu_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Baab ne ubumot bisi munai ginam aib qonut end bisub nomon ba waramb igurei. Ende at igo ne munon qei ar mindigar qob wot qiumuni qob qamb wurinob qamb igour eng wuri mingoan norumi bigari ne wau moi ger unum Sol qoat igoai. ");
INSERT INTO wnu_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ne Stiben nomont waramari-waramari Yisas simot ar: “Yisas yonou baraitari: yonou igomurur mot ir e.” ");
INSERT INTO wnu_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ende qamb gamaur wat bugab Qenut qamb ar: “Barai, qomon boru e yesiaur end tauimb qamb misir me igu,” ende qamb ab wogub umorei. ");
INSERT INTO wnu_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Stiben ende waramari uma munon Sol eng wo gor uber qamarei. Ne munon qomon uberet igour eng Stiben mumun bis tumuni wogub borusi toubet eab igurei. Qen end qas munon Yisast oabig igour eng ginam aib Yerusalem igour eng wuriba sumungasiari qei iua Yudia Samaria wurinou ai end isumirei. Ne Yisas wonou imbigau yurau eng ger me qoau, gugum Yerusalem eng igurei. ");
INSERT INTO wnu_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ne munon Sol eng wo der munon yurau Yisas toat igour eng wurinou munai gari-gari end isub wuriba sumungasi ne wuribaab uyort wuribig ende at igoai. ");
INSERT INTO wnu_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ende aba ne munon Yisas qenunget igour eng der ginam-ginam iua Yisas qob wurinob qamb qib igurei. ");
INSERT INTO wnu_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ende abari ne munon ger Pilip wo der ginam aib Samaria end isub ne Qenu Yisas init maribiga der inubersier eng wurinob qamb igoai. ");
INSERT INTO wnu_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Pilip ende wurinob qamb ne wurinou toar munon qei wurimusia ne munon yamangar gugum wot yar qob igub igurei. ");
INSERT INTO wnu_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ende abari ne munon qei ai bigau igaramor eng wuriwegib qamb atag ab wogub iua qiyo goten amamir a goten iam nob qiyo toar wes-wes eng gagar wuriwaga uberetriamirei. ");
INSERT INTO wnu_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ende at ginam Samaria eng borusi mismisir igurei. ");
INSERT INTO wnu_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ginam aib end munon ger unum Saimon eng end igoai. Wo munon wuri dumi qiyo qomon wes-wes eng gar ebet igoai. Ende aba ne Samaria munon wot yari igurei. Wo igo ete qamb igoai: ‘ye gari aib” ende qamb igoai. ");
INSERT INTO wnu_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Saimon wo qomon eng aba ne munon baraitari qiyo munon ar qei der wo qob qamara borusi qenunget ne mingongir qamamir: “Wa, munon e Qenu gagam eng wot igama igo ebet igo,” ende qamamirei. ");
INSERT INTO wnu_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Qamb ne apand qamb wo qob qamara igub igurei. ");
INSERT INTO wnu_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Saimon eng ende aba ne munon misir ubura ne wuri song igamari ne Pilip diab Qenu Yisas inubersi qamb imuriamor eng qanam musub qamara igub wogub ne Pilip toat abari wo der wurimaragansi ya obotarerei. ");
INSERT INTO wnu_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ende abari ne Saimon wo gor Pilip qob qamara igub aba ne wo gor yat maragansiarei. Ende aba wogub Saimon Pilip wogub mug me qoau, nob ten qib igoai. Nob qib ne Pilip qomon wes-wes aba gab borumisir igorei. ");
INSERT INTO wnu_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ende abari ne Yisas wonou imbigau yurau Yerusalem umo igour eng Samaria munon Qenu qob igub uberet igour qamarari igub Pita Yon nob wuriimuriamirei. ");
INSERT INTO wnu_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","17","Pita Yon nob isi weib yarab Samaria munon Yisast oabig igour eng ibagamirei. Ibag ne Qenu Igomurur qau der wurit isi qamb Qenu qebi qamamirei. Eng qoan Samaria munon qomon boru mogirt wagari Pilip Yisas unumt qas wurimaragansi ya obotarerei. Qen end Igomurur qau se me wurit isau. Ende gab ne Pita Yon nob is ubent wuribeari ne Igomurur qau der wurit isub nonogursiarei. ");
INSERT INTO wnu_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","19","Munon Saimon eng wo Pita Yon nob is munon wuribeari Igomurur qau der wurinonogursia abari ibag ne wo nomon qur bis wurisab qamar: “An qer gagam eng oboumon eng ye bo yesari ye bo munon qei ye wuribine Igomurur qau wurit isa nonoguretorunor.” ");
INSERT INTO wnu_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ende qamara Pita der taui qamar: “Qenu Igomurur qau ne nomon qurt taui baib quran? Ne ende ebet eng nomon qur nob mom umb isiban. ");
INSERT INTO wnu_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ne gor ende ebet eng ne ininob me qirinenei Qenu nonou misir soageni eng qo gab imbigai. Ne qomon boru noopurima outet qib igoan. ");
INSERT INTO wnu_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","23","Eng gab ne ne misir boru eng bo mogirt wab wogub ne Qenut misir gari big wot qamara ne neubersieriba.” ");
INSERT INTO wnu_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ende qamarari Saimon wo der Pita Yon nob wurinob qamar: “An ombur yet Munon Aib nob qamarari mi eng quraumon eng yet wab ariraminer.” ");
INSERT INTO wnu_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ende qamara ombur der nomon qur wonou bo utab wogub qamamir: “In mi e oboun eng Munon Aib Yisast baub ebet igoun.” Ende qamb wogub bo Yerusalem umo isub qamb isub munai ginam qamaaman Samaria qani-qani igo eng Qenu qob wurinob qamb isub igurei. ");
INSERT INTO wnu_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ende isari wogub Munon Aib wonou enger der Pilip nob qamar: “Ne is Yerusalem wogub tap eng toat isi munai ginam Gasa end isi. (Ai tap eng qo wogomirei.) ");
INSERT INTO wnu_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Ende qamara ne Pilip girinet der isorei. Is qataben gar ego Itiopia munon ger isub igama is garei. Munon eng Itiopia wurinou yamangar baraitari Kandasi wonou sarau munon nomon qur qoat igour eng wurinou gigit igoai. Wo Yerusalem qite diab Qenu munai end isub wot simot eab wogub bo wonou munait isib qamb qart bugab igama wai aib ger ubumot isub igoai. Ende bugab isub igo ne Qenu wonou qob qoan Aisaia nob qamara gumater eng wanunger-wanunger isub igama garei. ");
INSERT INTO wnu_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","30","Ende gea ne Qenu Igomurur qau Pilip nob qamar: “Ne qar isub igo eng qani isub ge.” Ende qamara Pilip qand munon eng qani isub igor eng wo qob qoan Aisaia gumater eng wanunger isub igama igub nob qamar: “Barai, qob eng wanungerman eng qanam bais imbigan qiyo?” ");
INSERT INTO wnu_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ne munon eng nob qamar: “Munon ger qanam birisi me yiimbigour. Yonou ar wanunger qas gab qanam sir me iotoroum. Ne diab qanam bais yiimbiginen qiyo?” ");
INSERT INTO wnu_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ne Pilip munon eng bugab igoar eng nob ir bugama ne munon eng Aisaia qob ete gumater eng wanunger isub igoai: Munon eng waramb qamb mot isumir eng bur sipsip waramb qamb ba isari qi igo gas ende igoai. Ne sipsip yeim im sopurmb qamb abari me eab igo gas ende igoai, a qob ger me qamarau. ");
INSERT INTO wnu_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Munon eng ba sumungasi waramb a burind qob wot big qamb qiyo ende atri wogub waramari umb wogub bo ago et me igamau. ");
INSERT INTO wnu_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Munon eng qob eng ende wanunger wogub ne Pilip nob qamar: “Munon eng qob eng at qamar eng mai wonomit qamarei qiyo yourt qamarei?” ");
INSERT INTO wnu_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ne Pilip taui nob qamar: “Qob e Yisast qamb gumaterei.” Ende qamb ne qanambig Yisas qob Aisaia gumater eng qanam musub nob qamara iga-iga isub igurei. ");
INSERT INTO wnu_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Isi yarab ya qubirt ger isub ne munon eng Pilip nob qamar: “Yag e doroun e, mai ya ba ye yemaragansieriban qiyo?” ");
INSERT INTO wnu_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Ende qamara Pilip nob qamar: “Git uber quran ego, nonou qas misir qerei igu. Ne mom Yisast oabig qamara gab eng nemaragansieribam.” Ne munon eng qamar: “Io, ye Yisast mom oabigoum, wo Qenu wonou wau ten.” ");
INSERT INTO wnu_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ende qamb ne wai aib eng wurinob qamara qar ubumot isub igour eng nagari ne ombur ag der yag et is naget Pilip munon aib eng ya ubetet maragansiarei. ");
INSERT INTO wnu_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ende at wogub ne ombur daan diab ne Qenu Igomurur qau Pilip aba umangerma me gab wogub wo mismisir wonou ginamt isorei. ");
INSERT INTO wnu_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Pilip bo qand munai ginam Asdot end weib isorei. Isub ne tumbigi tap eng toat isub munon ginam-ginam eng qob uber wurinob qamb is-isi ginam Sisaria end weib isorei. ");
INSERT INTO wnu_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Qen end munon Sol eng wo munon yurau Yisast oabig igour eng oromar qamb ne mom igaramine umor qamb Qenu munai qoat igour eng baraitari qob igeteib qamb wot isorei. ");
INSERT INTO wnu_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Isub nob qemerine namani gumat munon Qenu wot igau munai aib Yuda wurinou Damaskus igo eng isa gaiar qamb Sol wo munon yurau Yisast oabig ne Yisas wonou ebet qib igoa gas abari Sol wo qomon eng wagar qamb ebet qib igo, ende qamb gumatemirei. ");
INSERT INTO wnu_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ne Sol der namani eng ba isorei. Is-isi Damaskus isib pisier ego mi begen aib ger (ai qebisimau gas ende) wot der qouiamorei. ");
INSERT INTO wnu_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ende gab ne ai qent qumo qurer inab ne qob ger igor eng ete: “Sol, meimet qamb ye yurau wuriborusierib qib igoan?” ");
INSERT INTO wnu_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ende igub Sol qamar: “Ne your?” Ne munon qob eng qamar eng bo qamar: “Ye Yisas, ne ye yeborusierib qib igoan eng. ");
INSERT INTO wnu_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","See qas qand der naget Damaskus umo isa munon ger ne meimi ebeinen eng nonob qamara igu.” ");
INSERT INTO wnu_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Yisas Sol nob ende qamara munon yurau Sol nob isumir eng qob qas igumirei. Munon git me geau. End ne wuri borusi qiet ar ta nub naget igurei. ");
INSERT INTO wnu_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ne Sol der naget asi gar engu mi ger me geau. Ende aba ne munon nob isumir eng ubumot nob Damaskus umo isumirei. ");
INSERT INTO wnu_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Eng ebeter eng qen ombur gari ende mag me semau, mani ya qamb me niau, ar tor igoai. ");
INSERT INTO wnu_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damaskus end munon ger igoar eng unum Ananaias, wo Yisast oabig igoai. Qen geret inig gea Munon Aib nob qamar: “Ananaias,” ne wo qamar: “Barai, ye e igoum,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Qamara Munon Aib qamar: “See girinet tap tog-tog eng isi yarab munon ger unum Yudas wonou munai end isub Tarsus munon ger Sol qamb igour eng yar wo munai end igo ne yet qamb igo. Ne is qebi ge,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ne Ananaias wo ir Sol ende sieriner end ne Sol wo gor inig wap-wapi Ananaias gar eng diab asiom qamb tarit baab end at igama garei. ");
INSERT INTO wnu_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ne Ananaias wo Munon Aib ende qamara igub ne qamar: “Barai, munon irou Sol wo nonou munon yurau Yerusalem ite igour eng qenen wuriba sumungasi qib igo ende qamarari igub igoum,” qamar. ");
INSERT INTO wnu_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","“Eng see Damaskus e darar eng qomon eng ebeib qamb darar eng.” ");
INSERT INTO wnu_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ende qamara Munon Aib qamar: “Eng ende igoum ego ye munon eng bemeinsi yonou sarau beis qamb maribigumei. Ne irab gea ne wo munon yurau asin, Isrel yurau ue eng wurit isub yonou qob wurinob qamb ne wurinou king eng ne gor yonou yurau tetemi Isrel eng qob wurinob qem qamb maribigumei. ");
INSERT INTO wnu_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ende qamb qib igama ne wo qoan yonou yurau wuriquguragsi qib igoar gas ende wo bo yonou sarau bea siorunor eng imbigibam.” ");
INSERT INTO wnu_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ende qamara ne Ananaias der mon qamar end ir gar eng Sol igama gab ubent baab qamar: “Io, Yisas yiimurima negeib qamb diaum. Munon eng gari qataben ite ne sier eng wo gari yiimurima diab nemusine mag bo asiom qamb Asiama Qenu Igomurur qau noopurima nonogureteriban.” ");
INSERT INTO wnu_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ananaias ende nob qamb wogub bea mi magt yagwai ninir gas is mag opur igoar eng nener dererei. Dara bo mi musub gea wogub ne Ananaias Sol maragansi ya ubeteterei. ");
INSERT INTO wnu_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Sol mag end asi ne bo mi nub gitgoan uput yar wogub qen bais gurum nami ende Yisas wonou yurau wurinob Damaskus eng igoai. ");
INSERT INTO wnu_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Igoi wogub ne dari Qenu wot igau munai Yuda wurinou end isub qamar: “Segagam Yisas Qenu wonou wau ten.” ");
INSERT INTO wnu_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ende qamara munon gugum der qiet qamamir: “Wa, munon eng munon yurau Yerusalem qite Yisas qob qamarari wurinob yogub a wuriba uyort wuribig at qib igoar eng wo bo der qob eng qura eng ga? Munon yurau eng qas e igour eng uyort wuribig nob Yerusalem qite irib qamb derer eng bo maigas aba-a?” ");
INSERT INTO wnu_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ende qamb ebetemir ego Qenu Sol mom nonogursia wogub qob qamar eng qeretutnob igumirei. Sol qamb qamar: “Qenu munon Yuda init imurima der inubersieriba qamar eng Yisas imuriamor eng.” Sol qob eng Yuda Damaskus umo igour eng ende wurinob qamb igoai. Qamara wuri borumisir igub qob ger me qamarau. ");
INSERT INTO wnu_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Sol qob eng mom ende qamb qib igama igoi qen qei uma ne Yuda munon baraitari aib-aib eng der qiumuni qob qamb Sol waramb qamb ebetemirei. ");
INSERT INTO wnu_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ende at ne bo ginam taut qoaib qamb dara waramb qamb munai ginam aib eng qoan youn big opur tend watemir eng qenen woromt itum uyat qoat igurei. Ende ebet igamari Sol qabar utari igorei. ");
INSERT INTO wnu_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ende ebet igamari ne Sol wonou munon banam der itum wobon end Sol mot youn suit yar Sol tugart bogoma wogub uyor degen aibt touri wogub erer qitet irab beari-beari ag iro isub der qoorei. ");
INSERT INTO wnu_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sol ende ba ag bigari Yerusalem ite irab Yisas wonou yurau eng wurinob erogori Yisas sarau oboun qamb ebeter ego wuri qomon qoan at qib igoar eng ende igo inmurimausi at iningaramb aba qamb wot yariamirei. ");
INSERT INTO wnu_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ende abari ne munon ger Barnabas wo der Sol nob naget ne mot Yisas wonou yurau end isub ne Sol qataben isa Munon Aib wot ebeter eng ne wo git maigas-maigas ebeter eng ne wo is Damaskus umo igo Munon Aib qob wurinob qamb igoar eng gugum qamara igumirei. ");
INSERT INTO wnu_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ende qamar mom igub io qamb wogub ne Sol banamsi mot wo nob Yerusalem ginam aib eng gugum isub Munon Aib qob wurinob dibes qamb qib igurei. ");
INSERT INTO wnu_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Sol wo qob ende qamb ne Yuda qei Grik qob igub igour end bigisi wurinob qamar ego qei der waramb qamb ebetemirei. ");
INSERT INTO wnu_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ende abari ibag ne wonou erogori sarau baab qib igour eng Sol mot Sisaria umo isub imurimari tabin ba wonou ginam qenen Tarsus ire isorei. ");
INSERT INTO wnu_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ne qen end Yisas wot oabig igour yurau Yudia ne Galili a Samaria eng bo munon ger inborusieriner qi qamb me yarimau, Qenu Igomurur qau wurinonogursi ne munon bubun qei wuri oau menima wuri gor diab Yisas wonou yurau eng imusiari ne wuri gugum Munon Aib qas toat igorub qamb misir igumirei. ");
INSERT INTO wnu_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Ende abari ne Pita der munon ginam gugum is qob qamb qib igoai. Ende at qibi wogub qen geret Qenu yurau Lida igour eng ibegeib qamb isorei. ");
INSERT INTO wnu_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ginam end isub munon ger unum Ainias garei. Ainias togun 8-ende toar wara goten uben qamb gagamari uburab wagerei, saberit qas inab igoai. ");
INSERT INTO wnu_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pita ende is gab nob qamar: “Yisas wo ye uput igoar qamb yenonogursi igo end ye nemusiaum. Der bugab saberi musi.” Ende qamara Ainias qand der bugamorei. ");
INSERT INTO wnu_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Munon ginam Lida ne ginam ger Saron eng ende gab ne gugum Munon aibt oabigumirei. ");
INSERT INTO wnu_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ende abari wogub ne ginam Yopa end yamangar ger unum Tabita. (Grik qobt Dorkas qamb igour.) Yamangar eng Yisast oabig ne qenen munon qei mani ue gab qiyo mi qei ugeari qenen mi wurisab igoai. ");
INSERT INTO wnu_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Qen geret yamangar eng toar wara uma wogub yamangar qei der mumun birogoni wogub bir munai tumbigi ger erer qitet bigumirei. ");
INSERT INTO wnu_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Munai ginam aib Yopa eng ginam Lida eng pi. End ne Pita Lida end igama ne munon Yisast oabig igour eng Pita Lida end igo qamarari igub munon ombur wuriimurimari isub qamamir: “Ne qand in nob irun.” ");
INSERT INTO wnu_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ende qamarari igub qand girinet ombur wurinob irarei. Ende iroa ne mot mon tumbigi erer end iramirei. Iroa ne yamangar qindou eng gagar Pita qani yarab eab a yamangar umor eng igom igo mingoan mai wurisabriamor eng bear sirbig ende ebetemirei. ");
INSERT INTO wnu_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ende abari ne Pita der yamangar eng wuriimurima ag isub uburari ne wo Qenu qebi qamb wogub igeser yamangar mumun gab qamar: “Tabita der bugom,” ende qamara yamangar asi Pita gab der bugamorei. ");
INSERT INTO wnu_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Bogoma Pita ubent bea der nageterei. Naga Pita yamangar qindou ne munon qei Yisast igub igour end bis wurit waga uber igoai. ");
INSERT INTO wnu_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Pita ende aba qob toau ginam aib Yopa qani-qani eng isa igub munon ar qei Munon aibt oabigumirei. ");
INSERT INTO wnu_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pita ende at wogub Yopa end qen dirigor munon ger wai goant mingoan wes-wes barsi igo eng nob igoai, munon eng unum Saimon. ");
INSERT INTO wnu_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ginam aib ger unum Sisaria qamb igour end munon ger unum Kornilius wo Rom yogorau munon 100-ende oroar igoai. Yogorau munon 100-eng Itali yurau qamb igurei. ");
INSERT INTO wnu_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Kornilius wo wonou qanam erogori eng qas Qenut oabig igurei. Ende at ne Yuda munon qei mani ue gab qiyo mi qei ue gab eng wo mi wurisab ne Qenut qenen qamb igoai. ");
INSERT INTO wnu_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Qen geret ai gab-gab worom erer qumand igama ne wo inigau gas ende ebet Qenu wonou enger gar ego wo unumot qamar: “Kornilius.” ");
INSERT INTO wnu_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ende qamara ne wo enger eng gab yari igo ne qamar: “Maia?” Ne enger der qamar: “Ne qomon uber munon qei mi ue gab wurisab qiyo Qenut oabig qenen wot qamb igoan end Qenu net igub neubersieriba. ");
INSERT INTO wnu_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","End ne see ne munon qei wuriimurima ginam Yopa umo isub munon ger Saimon Pita nob diorunor. ");
INSERT INTO wnu_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Munon eng wo munon ger Saimon wai goan ba mi wes-wes barsi igo eng nob igo. Wonou munai eng tomon ya gabut irond igo.” ");
INSERT INTO wnu_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Enger ende qamb wogub qoa Kornilius der munon ombur wonou sarau betet igour eng ne yogorau munon ger Qenut oabig igo eng nob wuri qereiamorei. ");
INSERT INTO wnu_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Qerei wuriimurimb qamb ne enger qob nob qamar eng munon ombur gari eng wurinob qamb wogub wuriimurima Yopa umo isumirei. ");
INSERT INTO wnu_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Barim ende der is-isi munai ginam Yopa qani end isumirei. Isari ne Pita wo mon qirer erer qitet irab Qenu nob qobub igoai. (Munon eng wurinou mon qirer soro ar end). ");
INSERT INTO wnu_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","11","Worom ginam tog yara ne munon qei mi mor arsi igamari Pita minemb wogub mon erer end inab igo inig wap-wapi gar engu tat miroau gas ende aba abau tarugau aib end mi uyab wugumirei ten dererei. ");
INSERT INTO wnu_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Abau erobon end wai qamba, mani qamba, a morogan qamb mi wes-wes end uyemirei igama ten dererei. Mi eng gagar qei Yuda gitab igour eng. ");
INSERT INTO wnu_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ende dara ne Qenu nob ete qamarei: “Pita, ne der bugab wai e gagar waramb yab ni.” ");
INSERT INTO wnu_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ne Pita der qamar: “Barai, in Yuda wai e gagar gitab igoun end me ninei.” ");
INSERT INTO wnu_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ende qamara ne Qenu bo nob qamar: “Ye mi notoum eng qau ger ue, mi gugum aren sig,” qamar. ");
INSERT INTO wnu_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Mi eng ebeter eng qen ombur gari ende aba gea wogub ne bo ba erer qite irarei. ");
INSERT INTO wnu_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pita der bugab mi eng gar end misir qebebi igub ende at igama ne Kornilius munon Pita nob diarar qamb wuriimuriamor eng isub munon qei Saimon munai eng wuriimbigari ne wuri is tendet end naget igurei. ");
INSERT INTO wnu_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ende is naget ne wuri qebi qamamir: “Munon qunan ger unum Saimon Pita qamb igour eng et igo qiyo. ");
INSERT INTO wnu_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Qen end Pita wo se mon erer qite igo inig mi gar end se misir igub igama ne Munon Aib Igomurur qau nob qamar: “Pita, munon ombur gari yarab nogoub qamb net qamb igour. ");
INSERT INTO wnu_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Der naget is ibag wurinob is. Me iet wog, yonou wuriimurimine nonob irub qamb dururei.” ");
INSERT INTO wnu_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ende qamara Pita ag qumo der munon eng wurinob qamar: “An yet asi qib igoumon qi-i?” ");
INSERT INTO wnu_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ende qamara wuri der qamamir: “Ininou yogorau munon baraitari eng unum Kornilius eng inimurima nonob irub qamb durunei. Munon eng wo Qenut qenen oabig a munon qei wuri ubersia Yuda munon wuri qenunget igour. Eng wo enger ger der nenet qob ger qamara igu ende nob qamar end wo inimurima nenob irub qamb durunei. ");
INSERT INTO wnu_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ende qamarari Pita munon ombur gari eng oromar mor isub itum end inemirei igo urigerma itum der munon ginam qenen eng qei wurinob bo ite iramirei. ");
INSERT INTO wnu_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Iri qataben inemirei igo urigerma isi Sisaria weib iramirei. Qataben iroari-iroari ne Kornilius wonou munon banam a wonou yurau eng oromar qamb Pita qoat-qoat qiumuni igurei. ");
INSERT INTO wnu_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pita iri Kornilius munai mor isiba ne (wurinou qomon eng) wo der gamaur wat bugab Pita menmant inumoramorei. (Qomon eng munon aib ger yara ende ebet igour.) ");
INSERT INTO wnu_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ende aba ne Pita qand bea der naga nob qamar: “Ende me yesi, ye ne gas ende gari.” ");
INSERT INTO wnu_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ende qamb nob mor isub ibagar ego munon yurau irou mor end qiumuni igurei. ");
INSERT INTO wnu_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ende ibag ne wurinob qamar: “An gugum qoyam eng in Yuda ininou qomon eng. In munon ar Yuda ue eng wurinob bugab qiyo mi nub a wurinob qobub ende me ebet igoun. Eng gitab igoun ego see Qenu wonou yiimbiga ne qomon eng uber ue eng gab see an ginam e diaum e. ");
INSERT INTO wnu_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","End ne ye e yaru qamb qob yet bigari isa igub ye me wagau, ar igub diaum e. End ne an meimet qamb yet qob bigoumon eng an qebi gibam.” ");
INSERT INTO wnu_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ende qamara Kornilius der qamar: “Barim urigom bo urigom end ai gab-gab yonou munai mor end igo Qenut qamb igimine munon ger mingoan oan qenengi nob eng ye menmant et naget igoai. ");
INSERT INTO wnu_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Igama gine ye unumut qas qamar: “Kornilius ne qomon uber munon qei wurisi igo ne Qenut qebi quran eng wo qo igai,” ende yet qamar. ");
INSERT INTO wnu_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Qamb qamar: “Ne munon qei wuriimurima Yopa umo isub mun ger unum Saimon Pita qamb igour eng yar mun ginam qenen ger wai goant mingoan wes-wes mai igo eng unum Saimon wo nob igo wo munai eng tomon ya gabut end igo.” ");
INSERT INTO wnu_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ende yenob qamara igom end nenet qob bigine ne me iet wagau, uber yaran end ne see Qenu ininob igo end ne Munon Aib qob maigas nonob qamara igub igoan eng bo ininob qamara igun,” Kornilius ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Qamara Pita bo qamar: “Apand, see ye imbigoum. Qenu munon yurau gari qas me wurit igub igo. ");
INSERT INTO wnu_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Wo munon yurau gugum qob wes-wes qamarau eng wot oabig qomon uber qas ebet igour eng wuriqenungar igo. ");
INSERT INTO wnu_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","End ne Qenu wonou qob eng in Yuda init imurima derer eng. Qob eng in munon gugum qibanamsi igamau eng Yisas Krais ininou Munon Aib eng insirbigorei. ");
INSERT INTO wnu_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Eng gaiar, Yon Yuda munon irou qob wurinob qamara Qenu wot oabigari wurimaragansi ya obotarer eng. Ende at igama ne qanamt Munon Aib Yuda wurinou wurit maribigorei. ");
INSERT INTO wnu_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ne gor igub igoumon eng, Qenu Nasaret munon Yisas wo nonoguret naget sarau be qamb wonou Igomurur qau end nonogursier eng. Ende siara wogub munon irou iam toar nob a umari wurimeni at qib igoar eng wo Qenu nob igoai. ");
INSERT INTO wnu_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","End ne in munon Yuda ginam gugum ne Yerusalem ginam aib end at qib igama gaminei. Wo ende at qib igama igoi baab namt uri waramari umor eng.” ");
INSERT INTO wnu_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Pita ende qamb ne qamar: “Tumuniamirei igama qen ombur gari ubura bo Qenu menima der bugamorei, ende ebine munon qei gaiar qamb. ");
INSERT INTO wnu_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Eng menima der qib igama munon gugum me geau, munon qei Qenu wonou gaiar qamb inmaribigor eng gari gune ininob qib bugab mi nub igoai. ");
INSERT INTO wnu_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Gune ne wo qob uber munon gugum wurinob qamarar qamar end in qamb qib igoun. Ne gor Qenu wonou Yisas aib igo ne munon qoan umumir eng ne se igour eng wurinou qomon at igour end wuriqereiom qamb maribigorei. ");
INSERT INTO wnu_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Yisas wo qomon eng ebeiner end Qenu qoan wonou qob munon wurinob qamara ete gumatemirei: “Munon gugum Yisast mom oabigunor eng Qenu wurinou qomon boru ebet igour eng wab arirama oau uber burubour,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pita qob ende wurinob qamb igama ne Qenu Igomurur qau der munon bugab qob igub igour eng wurit isorei. ");
INSERT INTO wnu_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Igomurur qau munon ar Yuda ue eng wurit isa Qenu qob munon ginam qei wurinou qob qoan me qamb igamau, qen end qas qamb Qenu wot mismisiramirei. ");
INSERT INTO wnu_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Ende abari ne Yuda qei Yopa umo Pita nob diamir eng der ende gab ne qiet misir qebebi igub ete qamamir: “Wa, munon eng Yuda ue eng maigas Qenu Igomurur qau wurit gor isa?” ende qamarari ne Pita der munon yurau wurinob yarer eng wurinob qamar: ");
INSERT INTO wnu_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Qoan in Igomurur qau init derer gas ende see bo wurit darar eng. Wurimaragansi ya obotarunor eng in maigas me taisiunei.” ");
INSERT INTO wnu_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ende wurinob qamara wuri der Kornilius wonou yurau maragansiorub qamb Yisas unumut qamb ne ya obotaremirei. Ende abari wogub ne wuri der ‘qen bais gurumnami end igo wogub isar,’ qamarari Pita end ebeterei. ");
INSERT INTO wnu_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Qen end Yisas wonou imbigau yurau eng ne munon Yisast oabigumir eng nob Yudia ginam end gagar igo ne igumir e munon yurau ar qei Yuda yurau ue eng Qenu qob igub Yisast oabigumirei. ");
INSERT INTO wnu_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","3","Ende abari ne Pita Yerusalem ite iroa ne Yuda munon qei der qamat qamamir: “Ne munon Yuda ue eng wurinou git goan me sopurmau ar igour eng wurinou munai mor isub wurinob bugab mi nub igoan qi-i?” ");
INSERT INTO wnu_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","5","Qamat qamarari Pita taui mi gugum dibes wurinob qamar: “Qoan ye Yopa end Qenu wonob qamb igo ne inig wap-wapi gam engu tat miroau gas ende aba abau tarugau aib yet dererei. ");
INSERT INTO wnu_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Dara ye qani is gam eng wai morogan qamb gugum in gitab igoun eng abaut igama gamei. ");
INSERT INTO wnu_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Mi eng ende gine munon ger der ete qamar: “Pita der bugab wai e gagar qei waramb yab ni.” ");
INSERT INTO wnu_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ende qamara ye der ete qamam: “Barai, wai eng gagar in Yuda gitab igoun eng gaba mom wogoum, me ninei.” ");
INSERT INTO wnu_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ye ende qemerine munon eng bo qamar: ‘Qenu mi natar eng aren sisinam, mi gitarau ger ue.’ ");
INSERT INTO wnu_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Mi eng inig ende gine ne qob gor qen ombur garit ende yenob qamara igine wogub bo mi eng abau ten erer qite irarei.” ");
INSERT INTO wnu_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ende qamb qamar: “Ye ende at igimine qen end Sisaria munon ger e munon ombur gari wuriimurima ye yenob irub qamb yar mon ye inab igoumt ago eirot naget igurei. ");
INSERT INTO wnu_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ende igamari Qenu Igomurur qau yenob qamar: “Ne munon e dorour eng wurinob ir. Aninou Yuda qomon end igub me qubig, ar sarog big wurinob ir. Ende qamara Yopa munon Yisast oabigumir eng 6-ende wurinob munon yaremir eng enamar Sisaria ite Kornilius munait end iraminei. ");
INSERT INTO wnu_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","14","Irab wonou munai mor end isub bugumune ete ininob qamar: “Barim urigom bo urigom end enger ete yenob qamarei, qamar: Ne munon qei wuriimurima Yopa umo isub munon unum Saimon Pita qamb igour eng nob diarari wo nonou yurau eng qob aninob qamara ne an oau uberetoruboumon.” ");
INSERT INTO wnu_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Munon eng ye yenob ende qamara ye qob wurinob qamb igimine Qenu Igomurur qau qoan init derer gas ende wurit bo dererei. ");
INSERT INTO wnu_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Igomurur qau eng ende aba gab Munon Aib qob qoan ete qamar eng misir igomei, ‘Yon ya asint anmaragansiarei. Qen geret Qenu Igomurur qau nob anmaragansieriba’ qob eng misir igomei.” Pita ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Qamb qamar: “Qenu wonou qenungau end Igomurur qau in gigit ininou Munon Aib Yisast oabigune imuriamor gas ende bo munon yurau e Yuda ue eng wurit imuriamorei. End ne in bo maigas Qenu me taisiunei.” ");
INSERT INTO wnu_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Pita ende wurinob qamara wuri bo oau quguraget me abau. Ne Qenut mismisir qamamir: “Io, Qenu munon Yuda yurau ue munon ar eng gor ende wurisierine erogori qomon boru mogirt wab bebereg igoarar qamb abar eng,” ende qamamirei. ");
INSERT INTO wnu_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Munon yurau qoan Stiben waramari umor eng bo munon Yisast oabig igour eng bo wuriba sumungasi ende at igurei. Igamari ne munon yurau Yisast oabig igour yurau eng ginam aib Yerusalem eng wogub iua ginam wes-wes igour eng qei der ai pa Ponisia end isumirei. Ne qei tabin ba ai qaur Saiprus end, ne qei ginam aib Antiok end gagar isubri munon Yuda yurau munon ginam eng gagar is igour eng sir qob wurinob qamb qib igurei. ");
INSERT INTO wnu_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ende abari ne Saiprus ne Sairini munon qei Yisast oabigumir eng wuri der ginam aib Antiok end isub munon Yuda yurau ue eng song Munon Aib Yisas qob wurinob qamb igurei. ");
INSERT INTO wnu_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ende abari ne Qenu der wurinonogursia ne wot oabigumir eng munon yurau irou buremirei. ");
INSERT INTO wnu_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ne Yisast oabigumir Yerusalem igour eng qob ende igub munon ger Barnabas imurimari Antiok umo isorei. ");
INSERT INTO wnu_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Barnabas end is Qenu wuriubersia munon yurau irou wot igub mismisir igamari ibag wurit mismisir qamar: “An Munon Aib wot igoumon eng mom qenen ende ebet igoarar,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabas wo munon uber end ne Qenu Igomurur qau wot isub nonogursia sarau aba munon irou Munon aibt oabigumirei. ");
INSERT INTO wnu_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Barnabas wo ende at qibi wogub Sol Tarsus end igo qamarari igub gib qamb Antiok eng wogub isorei. ");
INSERT INTO wnu_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Isub Sol gab nob Antiok ite diamirei. Diab togun gari end ombur munon Yisast oabigumir eng wurinob igo Qenu wonou qob wuri sirbig ende at igurei. Ende at igamari munon ar qei der Yisas wonou yurau eng se qen qamart Kristen wurit qamamirei. ");
INSERT INTO wnu_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Qen end Qenu qob gigit qamarau munon Yerusalem igour eng qei ibogoub qamb Antiok umo isumirei. ");
INSERT INTO wnu_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ende isub munon ger unum Agabus nob igamari ne Igomurur qau wot isub nonogursia ne wobon end der naget qamar: “Qunumber qen aib yariba, yara munon ginam-ginam minumubour,” ende qamarei. (Qob qamar eng irimanima Rom wurinou munon baraitari unum Klodius oroar igoai). ");
INSERT INTO wnu_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ende qamara ne munon Yisast oabig igour Antiok igour eng der nomon qur sarau baab qur ba qiumuni big igo qunumber qen eng yara yurau qei ai Yudia igour eng wurisab igorun qamb misir igumirei. ");
INSERT INTO wnu_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ende ebetemirei igo qunumber qen eng yara nomon qur qiumuniamir eng Barnabas Sol nob ba munon yurau ginam aibt Yerusalem igour eng ba di wurisab igurei. ");
INSERT INTO wnu_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Qen end King Herot qanambig Yisas yurau igaramb qei wuriba uyort wuri bigorei. ");
INSERT INTO wnu_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ende at ne qen qamart yogorau munon ger imurima isub bui qaurit Yon umom Yems guma umorei. ");
INSERT INTO wnu_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","4","Herot Yems ende warama uma Yuda mismisirari ibag ne bo Pita ba uyort bigib qamb aba yogorau munon imurima isub ba uyort bigumirei. (Qen end Yuda mi aib qamb at nub igour eng qoan wurinou ur qoan ai Isip end igamari Qenu enger ger der wuri me igaramau, worowagerei ende qamb misir igub mani parau yis nob ue eng nub igurei.) Pita ende ba uyort big wogub ne yogorau munon 16-ende wuriqereimari 4-ende itumut qoat, ne 4-ende ai gab-gab qoat, ne bo 4-ende itum qoat, bo 4-ende urigerma qoat, ende at igamari Yuda wurinou mi aib qamb at nub igour inorou qen eng ubura Herot Pita qob qamara qereimb qamb qamara ende at igurei. ");
INSERT INTO wnu_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Pita uyort bigumir eng ende igama ne Yisas wonou yurau eng der Qenu nonogursi igoar qamb qebi qamb igurei. ");
INSERT INTO wnu_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Barim ende der Herot Pita bis qob musub waramune uminer qamb itum end yogorau munon ombur Pita ubent tourimari ina wogub yogorau munon ombur ger ig et naga ger ig et naget ende at igamari yurau aib ag tend uyat qoat igurei. ");
INSERT INTO wnu_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ende qoat igamari itum end Munon Aib enger ger wobon end dara munai mor eng begent uburerei. Ne enger eng Pita meni qamar: “Qand der bugom.” Ende qamara uyort touri nausiamir eng wonou yaaser uburerei. ");
INSERT INTO wnu_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ende aba enger nob qamar: “Mingoan naget goten yau naget ende aba ye nob isun,” ende qamara Pita ende ebeterei. ");
INSERT INTO wnu_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ende ebet ne enger eng toat isorei. Pita wo inigoum qamb misir igor ego wo me inigau, apand ende ebet igoai. ");
INSERT INTO wnu_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ombur ende isi yarab yogorau munon yurau ger igour eng worowogub ne isi yarab yurau ger igour eng worowogub ne isi tend tog aib mom nausi obotemirt end isari ne tend eng wonou ar weima ne ag isumirei. Yogorau munon qataben-qataben worowogub yaremir eng wuri ombur bais me ibegeau. Ag ende der ne Yerusalem ir igour tap eng toat irab ne enger Pita end wogub qi qoorei. ");
INSERT INTO wnu_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ende wogub qoa ne Pita misir igub qamar: “Wa, io, me inigau, apand Herot wonou yurau eng nob qomon eng yesiorubari gab Qenu enger imurima der yemot ba di yewagar e.” ");
INSERT INTO wnu_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ende qamb ne mom misir igub wogub ne tap toat is-isi diab Mak unor Maria munai mor end isorei. Is ibagar eng Yisast oabig igour yurau eng end qiumuni Qenut qebi qamb igurei. ");
INSERT INTO wnu_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","14","Pita ende irab tend tog mondir warama ne sarau batar igo yamangar ger unum Roda eng isub your mondir warama qamb isub mondir me weimau, ar igor ego Pita qamara mindiram goten igub mismisir wogub bo uyab-uyab isub wurinob qamar: “Wa, Pita diab ago eiro naget igo.” ");
INSERT INTO wnu_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ende qamara wuri der qamamir: “Ne qanganget qob eng at quran?” Ne wo der qamar: “Qangangetarau ue, apand di ago eiro naget igo.” Ende qamara wuri der qamamir: “Ue qi, umb wogub moui di naget igo qi?” ");
INSERT INTO wnu_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ende qamb at igamari Pita der mondir waramb ten igoai. Igama der mondir wei gab qietemirei. ");
INSERT INTO wnu_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ende der gab qobub abari ne Pita wurinob qamar: “Qi wagari, Munon Aib ye maigas ye mot der ag yewaga diaumi qi eng qemerine igar,” qamar. Qamb ne mi gugum wot ebeter eng qamb ugab wogub qamar: “Ye mi eng aninob quraum eng Yems ne ininou yurau erogori qei eng ende wurinob qamarari igunor.” Ende qamb wogub ai geret qoorei. ");
INSERT INTO wnu_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Itum end enger Pita nob ende mot der qoorei igama urigerma ne yogorau munon eng der Pita gamir e me igama gab wurinou der qiet qanganget igurei. ");
INSERT INTO wnu_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ende at igamari ne Herot qob igub munon qei wuriimurima Pita gub qamb asiamir e me gab, ne munon Pita qoat igour eng wuri qebiamor eng gor ue gab ne munon qei wuriimurimine yogorau munon Pita qoat igour eng igaramar qamb wogub wo Yuda wogub Sisaria isorei. ");
INSERT INTO wnu_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Qen end Herot wo munon ginam ombur Tair Saidon nob wurit misiringet igama wuri der erogori Herot oau meinsiorub qamb yaremirei. Eng Tair Saidon munon ginam ombur eng wuri Herot wonou yurau wurit mani qamb taui ba igour ende. Yarub qamb ne gigit munon aib ger unum Blastus wo munon Herot sarau betet igour eng oroar igo eng banamsiari wogub qen geret qob musiorunor eng Herot maribigorei. ");
INSERT INTO wnu_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Qen end wo git baab wogub is wonou nam qab end bugab igo ne munon end wurit qob qamb igoai. ");
INSERT INTO wnu_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ende qob qamb igama is gab qiet atag ab qamamir: “Wa, qira munon ue qi-i, wo Qenu gas ende qamb igo,” ende qamamirei. ");
INSERT INTO wnu_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ende qamarari Herot uber yet quraur ende qamb me wuritaisiau. Ende aba Qenu enger ger imurima der Herot sia toar wara umorei. ");
INSERT INTO wnu_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Qen end Qenu qob bais me wagau, sabar-sabar qamb qiroari munon bubun-bubun bo Yisast oabig isub igurei. ");
INSERT INTO wnu_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Qen end Barnabas Sol nob mi ebet igour eng ugab wogub wau ger unum Yon Mak mot Yerusalem wogub bo Antiok umo isumirei. ");
INSERT INTO wnu_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ginam Antiok end Yisast oabig igour eng qei Qenu qob gigi wurinob qamara dibes qamb ne qei Yisas yurau eng wuriimbig ende at igurei. Munon eng at igour eng unum ger Barnabas, ne goan qurun ger unum Simeon, ne Sairini munon ger Lusius, ne Manain, wo wayit igama Herot ur unor qoat igour eng ne ger Sol ende. ");
INSERT INTO wnu_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Qen end mi niau gitab ne Qenu wot qamb igamari Qenu Igomurur qau wurinob qamar: “An Barnabas Sol nob wagari ye sarau ger abar qamb wurit maribigom eng obounor,” qamarei. ");
INSERT INTO wnu_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ende at ne bo mi gitab Qenu qob qamb igo ne wuriimurimune sarau end isar qamb wuri nonogursi uben wuri tari erer end big wogub wuriimurimari Barnabas Sol nob ombur qoamirei. ");
INSERT INTO wnu_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Isubari Igomurur qau wonou sarau wurit maribigor end isub qamb ne Yon Mak mot nob isi Selusia qumo der tabin ba ai qaur Saiprus end iramirei. ");
INSERT INTO wnu_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Irab isi ginam aib Salamis end isub Yuda munon qei end igour wurinou Qenut igub igour munai mor end isub Qenu qob wurinob qamb igurei. ");
INSERT INTO wnu_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Ai qaur end ir igo ne ginam gugum isub qib qob qamb isi yarab ne ginam aib ger Papos end is gamir eng Yuda munon ger unum Baryisas, munon eng munon wuridumimau tari, wo der munon qei wurimurimar ete wurinob qamb igoai: “Qenu qob apand yenob qamara quraum,” ende qamb igoai. ");
INSERT INTO wnu_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Munon eng wonou munon banam ger unum Sergius Paulus, wo munon ai qaurt eng igour eng ibag igoai. Wo qoyam aib end Barnabas Sol nob Qenu qob qamarari igib qamb wurit arei. ");
INSERT INTO wnu_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ende wurit ara ne Baryisas Grik qobut Elimas qamb igour eng wo der wonou munon banam Sergius Paulus eng wo Yisas qob nob qamarari oabiginer qamb wo taisiarei. (Baryisas eng wo Yisas qob me qenunget igamau end.) ");
INSERT INTO wnu_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ende aba ne Sol unum ger qeniamir eng Pol, wo Qenu Igomurur qau wot isa ne Elimas nan gab nob qamar: ");
INSERT INTO wnu_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Ne aibigau misir neba songesiamir end qomon uber ba songesi qobub igoan. Ne munon wuriimurimarau tari, Qenu qob apand eng igama ne qoas-qoas qamb qib igoan. ");
INSERT INTO wnu_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Eng at qib igoan end ne see qas Qenu nesiera mag tuumburiba, qen mai-mai qiyo isa bo asiemban.” Ende nob qamara qen end qas mag waber-waber bura gab ebeter ego mom tuum bura munon wuribeib qamb uben arir qib igoai. ");
INSERT INTO wnu_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Gabman munon aib eng Pol Barnabas nob ende abari ibag qesi wara igo ne Munon Aib qob igub Yisast mom oau apand burerei. ");
INSERT INTO wnu_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Ende aba wogub Pol munon ombur eng Barnabas, Yon Mak wurinob ginam Papos eng wogub tabin ba bo ai ger Pampilia end isub ne isi ginam aib Perga end isub ne Mak end wuriwogub Yerusalem qite diarei. ");
INSERT INTO wnu_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Mak wuriwogub iroa Pol Barnabas nob ginam eng wogub bo ai Pisidia end diab is ginam aib Antiok ger end igo ne Yuda wurinou qen gitab igour eng Sabat qamb igour eng gab ne Pol Barnabas nob Qenu wot igau munai mor end isub wurinob bugab igurei. ");
INSERT INTO wnu_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","End is bogomari ne munon qei der Qenu qomon Moses nob qamara gumater eng wanunger ne Qenu wonou qob gigit qamara munon gumatemir eng wanunger ende abari igub igurei. Qob eng ende wanungermari wogub munon baraitari munai eng qoat igour eng der munon ombur eng wurinob qamamir: “Ne an ombur bo qob ger igama gab eng qamarari in bo igub,” ende qamamirei. ");
INSERT INTO wnu_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Qamarari Pol der qamar: “An Yuda munon nob munon ar qei nob Qenut igub igoumon eng ye qemerine igar,” qamar. ");
INSERT INTO wnu_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","“In Yuda ininou Qenu eng tonoan wurimaribiga toat igurei. End ne qoan ai Isip umo igamari wonou aba munon yurau aib der isumirei. Ende aba ne munon ginam qenen der wuriborusi sumungasi igamari Qenu wonou oromar igoai. ");
INSERT INTO wnu_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ne wuri ai Isip mom wogub ai munon ue ar end qib igamari togun 40-ende umor eng Qenu oromar qib igoai. ");
INSERT INTO wnu_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ende qib-qibi diab ai aib ger baumir eng Kenan. Ginam end munon yurau 7-ende end igamari. Qenu wonou munon yurau wurinonogursia ginam di ne munon yurau eng orotoar arir wogub munai eng baumirei. ");
INSERT INTO wnu_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Baub end igamari togun 450-ende wara wogub ne Qenu wonou munon qei wurimaribiga wuri der gigit oroar igurei. Ende at isi yarab mom sindomund maribigor eng unum Samuel. ");
INSERT INTO wnu_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Samuel ende igama ne Yuda wuri der Qenu King ger bo wurit maribiginer qamb at igamari ne Benyamin yurau end ger maribigatarer eng unum Sol ur unum Kis. Eng bo togun 40-ende bo oroar igoai. ");
INSERT INTO wnu_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Sol ende igama ne Qenu wo wogub bo Debit maribig ne wot qamar: “Yesi wonou wau Debit eng wo yonou oau uri eng gab ne King igoar qamb mari bigetroum eng. Munon eng wo ye mi eb qamb nob qemerin eng qob igub ende ebeiba,” qamar. ");
INSERT INTO wnu_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ende qamb qamar: “Debit wau misinam der isiner tumbigi qir end munon baraitari aib darimba. Dari ne Isrel munon yamangar wuri musieriba qamar eng unum eng Yisas,” qamar. ");
INSERT INTO wnu_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ne bo qamar: “Qoan Yisas deriner end Yon munon wurimaragansiau eng Isrel wurinob ende qamara wuri oabigari wurimaragansi igoar eng. ");
INSERT INTO wnu_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ende at ne Yon wonou sarau eng ugeib qamb birisi wurinob qamar: “An yet mai yet quroumon? Ye munon qoan deriba qamarari an qenen qoat igoumon eng ye eng ue, qamar. Wo eng se qanam yariba. Yariner eng ye sarau ebine gaumon gas ende ue, wo yetanami wonou wesi ar ebeibaba.” ");
INSERT INTO wnu_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Pol ende qamb qamar: “An munon yurau ar qei eng nob in Abraham yurau tumbigi nob erogori Qenu qob ininob qamara igub igoun e. End ne in gugum erogori Yisas inubersi qamb init imurimb qamar eng. ");
INSERT INTO wnu_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","28","Eng imurima dara ne in munon yurau aib Yerusalem igour eng qob qoan gumatemir eng qas inorou qent wanunger igour eng Yisas sir me imbigau. Qob qoan gumatemir eng gor munon eng dara sumungasiorubour end taut ebetemir eng wuri me imbigau. Yisas mindigar qob ger wot igo qamb gunor ego ue gab Pailat uyes waramari uminer qamamirei. ");
INSERT INTO wnu_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Qob eng qoan ende igoar end ne Yisas nam tenori big waramari uma wogub munon ombur-ombur bo beneri ba (wurinou qomon eng) nomon iru ger qoan igoar end tumuniamirei. ");
INSERT INTO wnu_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Tumuniamirei igama Qenu bo meniamorei. ");
INSERT INTO wnu_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Menima der bugab ne wonou imbigau yurau eng qenen wurit dibentra gab ne yurau eng wuri der Galili qamb, ne Yerusalem qamb eng isub qob suab qib igour eng. ");
INSERT INTO wnu_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Eng imusi isi yarab ne in gor mi nasim eng ebeter eng aninob quraun eng. Qob eng qoan Qenu ininou tonoan wurinob qamara gumatemir eng git bais misuu nami ende igoai, igoar eng see mom diban ibirigeserma gaun eng, end ne Yisas der bugamor eng. Qoan Isrel wurinou uru warau wepep goan (“Sam” qamb igour) qen yabt gumatemir eng ete igoai: Ne yonou wau ten, ye nonou tain ende igoai. Eng Qenu qoan munon ger nob qamara gumater eng ete: Qoan Ye Debit nob qamam end anubersi annonogursi ne an me anweginei. ");
INSERT INTO wnu_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","End ne Qenu Yisas menima der bugamor eng me bierau. ");
INSERT INTO wnu_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ne Debit uru wab igour ger gumater eng ete: Nonou munon oau uri eng gab boru bur qamb me weginenei. ende. ");
INSERT INTO wnu_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Ininou tonoan Debit wo Qenu sarau betet ende at igoi uma ininou tonoan qei wuri tumuniamirt end tumunimari biet isorei. ");
INSERT INTO wnu_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ne Qenu wo Yisas meniamor eng bo sabar umb me bierinerei. ");
INSERT INTO wnu_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Eng gab ne see aninob quraum eng: In Yuda qomon qoan Moses gumater eng apand qamb toat igorunon eng aninou qomon boru-boru mogirt wab me wugunanei. A Yisast oabigunon eng aninou qomon boru-boru mogirt wab wagari wo anmusia uberet ne qenen bebereg igoruboumon.” ");
INSERT INTO wnu_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","41","Pol ende qamb qamar: “Qenu qob ger qoan qamara gumatemir eng ete. Ye anit mi wes uber ar oboum eng munon qei animbigari an maigas me oabigunanei. Eng an yonou qob omboarir igamari ansieri ne borusi qiet ne mom umb uburuboumon. Qob eng anit irimaniminer qamb an gugum Yisast oabig igoarar,” ende wuri irun wab qamarei. ");
INSERT INTO wnu_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","43","Pol Barnabas nob qob eng ende wurinob qamb wogub inorou munai aib eng wogub qoaubari wuri der wurinob qamamir: “An qibi qen geret init igub gab eng bo yar qob quraumon eng bo qamarari igun.” Ende qamb wogub qei bunumban qoari wogub ne munon Yuda yurau eng ne munon yurau ar qei der Pol Barnabas nob orotoar qiroari ombur ete wurinob qamb qib igurei: “An Qenu mi aib init siar e gaumon end ne mom qenen end mom misir igub igoarar,” qamamir. ");
INSERT INTO wnu_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Inorou qen ger end munon ginam qenen gugum yar qiumuni Qenu qob igub qamb yaremirei. ");
INSERT INTO wnu_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Munon irou Pol qob igotoub qamb yarari ne munon baraitari qei der Pol merimotet ne mindigar qob wot qamb igurei. ");
INSERT INTO wnu_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ende abari igub Pol Barnabas nob ombur der qamamir: “Qenu qob e an Yuda qobtari igari ne munon yurau ar qanamt igunor qamb Qenu ebeter ego aninou der merimot me igun qamb ebet qenen bebereg igamau qob eng siningot igoumon eng. Ende abari animbag in irigai iningara gab in see anwogub munon ginam ar qei end isuboun,” qamar. ");
INSERT INTO wnu_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Qamb qamar: Qenu wonou qob ger Yisast qamar eng ete: Ye ne munon Yuda yurau ue eng wurinou urut begen gas ende nemaribigom end munon ai qent gugum bebereg igamau ai tap eng imbigubour, ende qamar end in anwogub munon Yuda ue eng wurit isub qob uber eng wurinob qomoruboun. ");
INSERT INTO wnu_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ende qamarari munon ar eng der qob eng igub borusi mom mismisir qamamir: “Munon Aib qob eng qamar eng sig uber.” Ende qamb wogub munon qei Qenu bebereg igoarar qamb maribigor eng Yisast oabigumirei. ");
INSERT INTO wnu_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ende at ne munon ginam pi-pi eng Qenu qob iruges big igub igurei. ");
INSERT INTO wnu_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","51","Ne Yuda munon qei der ginam qenen munon baraitari qei ne yamangar aib qei Yuda qomon toat igour eng wurinob qamarari Pol Barnabas nob orotoar ariramari ne ginam eng wogub Aikoniam end isumirei. Isub qamb ombur irumban gotent igoar eng porongot ariramirei. Eng etemir eng ete qamb wuri qob uber siningot igour eng Pol Barnabas nob wuri qob ger ue, munon wurinou qas, ende qamb. ");
INSERT INTO wnu_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ne munon ginam Antiok igour eng Yisast oabig mismisir igamari ne Qenu Igomurur qau wurit isub wurinonogursia igurei. ");
INSERT INTO wnu_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pol Barnabas nob ginam qei-qei qob qamarari munon yamangar Yisast oabigumir gas ende bo ginam Aikoniam ende is Yuda wurinou Qenu qob igau mor end isub qob qamarari Yuda ne munon ar irou Yisast oabigumirei. ");
INSERT INTO wnu_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ende abari ne Yuda qei qob me igun qamb ebetemir eng der munon ar qei wurinob qamb ne erogori big der munon yurau Yisast oabigumir eng wurit merimotar ende ebet igurei. ");
INSERT INTO wnu_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ende ebetemir ego Pol Barnabas nob qinining me qoau, wuri qen dirigor ginam end igurei. Igo ne Munon Aib qob eng me wagau, mom qeretut nob qamb igamari ne Yisas mom wurinonogursia ne qomon wes-wes abari gab igurei. Munon Aib wonou qob eng apand qamarar qamb. ");
INSERT INTO wnu_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ginam aib end yurau ombur igurei, Yuda ne munon ar qei der Pol Barnabas nob qob qamarari wurit isumirei a qei Yuda wurinou yurau end igurei, ende. ");
INSERT INTO wnu_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ende igo ne yurau Pol Barnabas nob qob me igatarun qamb ebetemir eng wurinou baraitari eng der ombur nomont igaramune umunor qamb ebetemirei. ");
INSERT INTO wnu_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","7","Ende abari ombur wuriimbig ne iua ginam ombur Listra Derbe nob ai aib Likonia igo end isub qib Munon Aib qob wurinob qamb qib igurei. ");
INSERT INTO wnu_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ginam Listra end munon ger goten gurumtarei unor wonou set ende baurei, me qib igamau. ");
INSERT INTO wnu_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Qen end Pol is qob qamara igub igama ne wo der garei. Gar eng munon eng Yisast oabig igo end nob qamara uber buriba eng ion gab ne bo nan garei. ");
INSERT INTO wnu_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Ende gab ne qugiab nob qamar: “Qand der nag,” ende qamara munon eng put der naget isorei. ");
INSERT INTO wnu_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Qen end munon Likonia ai eng gugum yar qiumuni Pol qob qamara igub igour end mi eng ende aba gab qamamir: “Wa, munon ombur e munon apand ue, Qenu qei munangit warub diaurei igo mi eng obour qi-i?” ");
INSERT INTO wnu_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ende qamb ne Barnabas unum bubun bigumir eng ‘Sus’ wurinou ai bigau baraitari wot qamb igour eng bo Barnabas unum bigumirei. A Pol qob qamarau munon eng gab ‘Hermes’ qamamirei. Eng wurinou Qenu ger qob wurinob qamb igo end ende etemirei. ");
INSERT INTO wnu_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Eng wurinou Qenu Sus qamb igour eng wonou mon mindatetemir eng ginam aib qani end igoai. Qen end munon mon eng qoat igoar eng der bur qarig qamagat qei ba yar a puriani isar uber-uber eng baub ne bur qarig eng ba di ginam aib tendet end waramb qamb arsi igoai. Eng munon qiumunimari bur eng waramb munon ombur eng wurit mian yamatar bigetarib qamb. ");
INSERT INTO wnu_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ende at igamari Pol Barnabas nob qob igub wogub uyab-uyab munon yurau aib eng wuri qibi isub ende me abar qamb wurinou mingoan bobumi wogub qugiab oromar qamamir: ");
INSERT INTO wnu_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“An mi eng init me abar in munangit an gas ende gari. In ombur Qenu qob uber eng aninob qomorune igar qamb. Igub ne an Qenu apand ue end wot oabig a mi qei-qei ebetri igoumon eng mogirt wab wogub ne Qenu apand gagam ai barsi, a tat barsi, a uyer ya barsi ne mi qei-qei eng ebeter eng qas wot oabig igoarar. ");
INSERT INTO wnu_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Git apand, qoan munon qei der mi eng gagar abari Qenu ibag waga wurinou eng at igurei. ");
INSERT INTO wnu_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ende abari Qenu wo der me taui igamau, wo yet igar qamb ya weima der igo, a worom aba asi igo. Eng ebet igo end mani ubune uber yaya burab irab git arira nub mismisir igoun,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ende wurinob qamb wogub ne mi aib at wurinob nunor qamb wuritaisi igamari igoi wagomirei. ");
INSERT INTO wnu_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Pol ende at igamari ne Yuda munon qei ginam ombur igour eng Antiok Aikoniam nob yarab Listra wurinob nomon ba Pol waramari umbonerer isa wogub mom uma qamb ubumot bis munai ginam eng wogub qonut bis inesi wogub qoamirei. ");
INSERT INTO wnu_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ende inesi wogub qoari Yisast oabig igour eng yar Pol gab qoui naget igamari bo der bogoma mot ginamt iramirei. Ne bo barim ende der Barnabas nob ombur bo ginam Derbe end isumirei. ");
INSERT INTO wnu_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Ombur end is Qenu qob uber wurinob qamb igamari munon irou Yisast oabigumirei. Ne ombur bo ginam eng wogub bo Listra isumirei, end igoi wogub bo tumbigi Aikoniam end is igoi wogub ne bo yonam Antiok ai aib Pisidia ite igo end isumirei. ");
INSERT INTO wnu_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Pol Barnabas nob eng ende qib munon yamangar qoan Yisast oabigumir eng wurinonogursi wurinob qamamir: “An Yisast oabigoumon eng me wagar. In qen geret Qenu wonou munai init musitarer end irub qamb eng see Yisast oabig wo maribig oboun eng ende quguragetoruboun,” ende wurinob qamamirei. ");
INSERT INTO wnu_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Eng munon ginam-ginam isub qib igour eng munon Qenut misir erogori big igamari ibag eng qei wurimaribig ende at qib igurei. Eng ende wurimaribig igamari munon yamangar wuri uput qamb oroar qob wurinob qamb igoarar qamb. ");
INSERT INTO wnu_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ombur isi yarab ginam aib Pampilia ai Pisidia end igo end isumirei. ");
INSERT INTO wnu_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Isub ne is munai ginam Perga end qob wurinob qamb wogub bo tumbigi ginam aib Atalia weib isumirei. ");
INSERT INTO wnu_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ombur Atalia wogub tabin ba deget bo tumbig Antiok iramirei. Iroari ne ginam eng wurinou qoan sarau abari Yisast oabigumir end wuri der Qenut mismisir oroar igama qibi yorour qamb wot qamamirei. ");
INSERT INTO wnu_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ne ombur der Yisast oabig igour yurau eng gugum wuriba qiumuni wogub ombur sarau baab qiroari Qenu oroar aba munon Yuda ue eng gor Yisast oabigumir eng gugum qob suari igumirei. ");
INSERT INTO wnu_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ende at wogub bo qen dirigor Yisas yurau eng wurinob igurei. ");
INSERT INTO wnu_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Qen end Yisast oabig igour munon yurau Yudia igour eng qei Antiok end diamirei. Diab Yisas yurau qei Antiok igour eng wurinob qamamir: “An Moses qoan Yuda wurit qomon gumater igo eng gari toat ne igoarar, goan sopurmari sirigum nob igama eng Qenu anit igub anubersi igoriba, a ende me obounon eng ue,” ende qamamirei. ");
INSERT INTO wnu_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Ende qamarari Pol Barnabas nob eng igub me qenunget ne wurinob agunumirei. Ende at ne munon qei der Pol Barnabas ne munon baraitari qei wurimaribigune qob eng birab Yerusalem end qamb musiar qamb wurimaribigumirei. ");
INSERT INTO wnu_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ne wuri Yerusalem irub qamb dari ginam Ponisia eng yar ne isi ginam Samaria eng gagar qib Yisas yurau eng ibag wurinob qamamir: “In iua munon ginam-ginam Yuda yurau ue eng Qenu qob wurinob qomorune wuri gor qomon boru-boru mogirt wab wot oabigumirei,” ende wurinob qamarari borusi mismisiramirei. ");
INSERT INTO wnu_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ende abari ombur worowogub Yerusalem ite iramirei. Yerusalem ite weib irab Yisas yurau eng ne munon yurau Yisas qob qamarar qamb wurimaribigor eng ne wurinou baraitari oroar igour eng ende iroari ibag oau uberetamirei. Ende abari wuri der sarau baab qib igamari Qenu mai wurisier eng qob suari igumirei. ");
INSERT INTO wnu_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ne Yuda yurau qei Parisi qamb igour eng, Yisast oabig igour eng der munon ar qei Yuda yurau ue Yisast oabig igour eng wurit qamamir: “An munon Yuda yurau ue ar eng wurinob qamarari gitgoan sopur ne in Yuda qomon Qenu Moses nob qamara gumater toat igoun eng wuri gor toounor.” ");
INSERT INTO wnu_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Ende qamarari ne munon yurau Yisas wurimaribigor eng ne baraitari eng gagar der qiumuni qob eng musiorub etemirei. ");
INSERT INTO wnu_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Qob eng ende qamb isub igamari ne Pita der naget qamar: “Eng qoan Qenu ye yemaribigor eng an yiimbig igoumon. Eng qob ger qemerine igar: Ye Yisas wonou qob eng munon ar eng wurinob qemerine igub Yisast oabig igoarar qamb yemaribigor end ye qamb qib igoun e. ");
INSERT INTO wnu_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Qenu in misir gugum mom imbig igo end munon Yuda ue eng gor yet oabig igoarar qamb wonou Igomurur qau init imuriamor gas ende wuri gor wurit imuriamorei,” ende qamb qamar: “Munon yurau ar eng Qenut oau apand burarine wuriubersiarei. ");
INSERT INTO wnu_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","10","Wuri ininob yurau gari ende qamb ebeter end ne an wuriquguragsi in Yuda qomon e tauar ende me wurinob qamb igoarar. Ininou tonoan ne see gor in qomon eng musub me toat igoun. Qenen ende wurisi igorunon eng Qenu anit maigas ebeiba?” ");
INSERT INTO wnu_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Pita ende qamb qamar: “Qenu init igub ininou munon baraitari Yisas imurima derer eng in wot oabig a wo maribig sarau oboun eng wo inubersiar eng.” ");
INSERT INTO wnu_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Pita ende qamb waga ne Pol Barnabas nob wuri der munon Yuda ue munon ginam qei-qei eng gagar qib qob wurinob qamb qib igamari munon yurau ar eng Qenu mai wurisier eng gugum qamb ariramari igumirei. ");
INSERT INTO wnu_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","14","Ombur qamb wagari Yems bo der naget qamar: “An iruges big ye qemerine igar,” qamar. Saimon Pita qob qurar eng se qamart Qenu munon ar wuriubersier eng wurimaribigorei. ");
INSERT INTO wnu_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","“Qoan Qenu wonou qob gigit munon wurinob qamara gumatemir eng ende gas ende,” qamar. ");
INSERT INTO wnu_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Qob eng ete: Qen geret ye bo igeser darab ne King Debit wonou yurau bubun bo wurimaribigibam. Eng ete gas, mon qoan ger irunguni mom biet uburab igama ne ye bo irunguni bubun wab ibot bigine bo temen gas ende buriba. ");
INSERT INTO wnu_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Munon Yuda ue yurau ar eng qoan ye wurimaribigum eng ye yegab yet yarari yonou oromar igoribam. ");
INSERT INTO wnu_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Qenu qob eng qoan dibes qamar eng see bo qurar eng, ");
INSERT INTO wnu_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Yems ende qamb ne imusi qamar: “Ye ende misir igoum. In Yuda, munon yurau ar Qenut oabig igour eng in me wuriquguragsi igorun.” ");
INSERT INTO wnu_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ende qamb qamar: “Ende gab eng in namani gumutrune gab, mai qiyo mani mian yomb qamb big igamari gab me niar, a wai waramb qeru ten me niar, a yamangar bo wogub ger me baiar, a yamangar munon nob song-song qib mi eng gagar obounor eng wurinob qomorune gitab igorunor,” qamar. ");
INSERT INTO wnu_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ne gor qamar: “Qomon end Moses qoan gumater igo end qenen inorou qent Qenut igau munai mor isub wanunger qamarari igub igoun eng. Ginam aib-aib gugum eng qamarari igub igour.” ");
INSERT INTO wnu_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ende qamara wogub ne Yisast oabig igour yurau eng munon baraitari eng erogori big munon ombur wurimaribigumirei, Yudas, unum ger Barsabas ne munon ger Sailas. Ende wurimaribigari Pol Barnabas wurinob Antiok umo isumirei. ");
INSERT INTO wnu_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Munon ombur eng wurimaribig ne namani ba isar qamb ete gumatemirei: In aninou bain ima gas ende Yerusalem e igo Yisas toat igoun. End qob e gumaun e an munon ai Siria igoumon eng ne ginam aib Antiok igoumon eng ne ai Silisia igoumon eng in Yuda yurau erogori ue ego anit mismisir ne anit igub igoun. ");
INSERT INTO wnu_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Ne gor in qob toau igoun ego in yurau et isub qob song-song aninob qamb a ende abari igub animbig quraun. Munon yurau eng in me wuriimurimau. ");
INSERT INTO wnu_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Eng gab ne ininou e qiumuni wogub munon ombur wurimaribigune Pol Barnabas in erogori wuriqenungar igoun eng wurinob isubour eng. ");
INSERT INTO wnu_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Pol Barnabas nob ininou Munon Aib Yisas wapet sarau beau end me yarimour. ");
INSERT INTO wnu_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","End ne Yudas Sailas nob wurimaribigoun eng. Namani gumaun e bisari geari ne bo wurinou qabarit musub qamarari igar. ");
INSERT INTO wnu_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Qenu wonou Igomurur qau insiera misir igub quraun. Eng in Yuda qomon eng mom gugum tauar qamb me anquguragsiunei. ");
INSERT INTO wnu_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Eng gab ne qob e gumaun eng gari gitab igoarar. Eng ete: Sogoin wurit mian yab qiyo, inaunt mani ber opur bigari gab me niar. A wai qiyo buru qeru ten gab me niar. Ne ger yamangar ba wogub bo ger ba qiyo yamangar munon nob soro qib qiyo eng gagar wagar. Qob eng quraun eng gugum toat eng uber igoruboumon in qob gari ende. ");
INSERT INTO wnu_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Ende qamb gumat wogub wuriimurimari isi Antiok umo isub munon yurau Yisast oabig igour eng wuriba qiumuni namani eng wurisemirei. ");
INSERT INTO wnu_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Qiumuni namani eng wanunger gab sig mismisiramirei. ");
INSERT INTO wnu_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Munon ombur wuriimuriamir eng Yudas Sailas nob ombur wuri Qenu qob gigit wurinob qamara munon yurau Yisast oabigumir eng bo wurinonogursi qen dirigor igurei. ");
INSERT INTO wnu_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Mom ende wurinob igoi wogub ne bo worowagari Yerusalem ite irubari wurinob qamamir: “Io, uber animurimari der ininob igo innonogursi wogub iruboumon eng o, irab gab qit eng ende wurinob qamarari igunor o-o.” ");
INSERT INTO wnu_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Ende abari Sailas wo mom end igorib misir igorei. ");
INSERT INTO wnu_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pol Barnabas ne munon qei wurinob Antiok eng igo Munon Aib qob mom wuriimbig igurei. ");
INSERT INTO wnu_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ende at igo ne qen geret Pol der Barnabas nob qamar: “Qen geret waga ombur qoan sarau baab munon ginam-ginam qib qob wuriimbig qib igoun eng maigas igour qi eng iua ibag qib igorun.” ");
INSERT INTO wnu_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","38","Ende qamara Barnabas wo Mak mot nob qib igorun ende qamb misir igub qamar ego Pol wo gigit Mak nob Pampilia umo nob qib igamari wo qi worowogub dier end bo nob qirune ende ebeiner qamb wagerei. ");
INSERT INTO wnu_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ende at qimerimesab wogub Barnabas Mak mot tabin ba Saiprus isumirei. ");
INSERT INTO wnu_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Isari wogub Pol der Sailas mot isib qamb qamara Qenut qebi qamarari inopuri qib igoriner ende qamb wogub Sailas mot isorei. ");
INSERT INTO wnu_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Isi ai aib Siria yar munon yurau eng wurinonogursi wogub bo ai Silisia end isub munon wurinonogursi ende at qib igoai. ");
INSERT INTO wnu_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Ne Pol ginam eng gagar wogub ne bo is ginam aib ger Derbe end isub ne is Listra end isorei. Ginam end munon ger unum Timoti, wo Yisast oabig igoai. Wonou ur Yuda ue, wo Grik munon, wonou unor Yuda wo gor Yisast oabig igoai. ");
INSERT INTO wnu_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Munon ginam ombur eng Listra Aikoniam nob wuri Yisast oabig igour eng Timoti qenunget igurei. ");
INSERT INTO wnu_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","End ne Pol Timoti nob qib igorib qamb misir igor ego Timoti ur eng Yuda ue, wo Grik end ne Timoti goan sirigum ue end munon ginam ombur eng wot agununor qamb Pol wonou der goan sopurmeteterei. ");
INSERT INTO wnu_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Ende at wogub Sailas Timoti nob oromar ginam qei-qei qib igoai. Ende qib munon yurau Yisast oabig igour eng ibag qob qoan Yerusalem ite qamamir eng bo qumurune mom igub igoarar qamb wurinob qamb qib igurei. ");
INSERT INTO wnu_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ende abari munon Yisast oabigumir eng der munon bubun bo oromar Yisas yurau end qenen erogori igurei. ");
INSERT INTO wnu_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Ne Pol wurinob qib igoar eng oromar Esia ire isib ater ego Qenu Igomurur qau taisia me isau. Wogub ne ai Prigia ne ai Galesia end qob wurinob qamb qib igurei. ");
INSERT INTO wnu_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Eng isi yarab ai Misia qangang end isumirei. Isub ne yar deget ai Bitinia isub qamb ebetemir ego Yisas Igomurur qau bo end wuritaisiarei. ");
INSERT INTO wnu_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Ende aba eng wogub ai Misia eng yar deget isi ginam Troas weib isumirei. ");
INSERT INTO wnu_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ginam end inemirei igo itum Pol inig gar ego Masedonia munon ger di qamar: “Ne uyer ya e nipat yar in qob inimbig.” ");
INSERT INTO wnu_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pol mi eng inig gar eng ininob qamara misir igub wogub qamamin: “Io, Qenu wonou qob end is Masedonia munon wurinob ");
INSERT INTO wnu_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Ende qamb wogub isub tabin ger taui ba ai qaur Samotres. End is ineminei igo urigerma der ginam Masedonia end ginam aib ger Neapolis end isumirei. ");
INSERT INTO wnu_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ne bo Neapolis eng wogub bo tumbigi isi Masedonia distrik wurinou ginam ger Pilipai. Ginam eng Rom wurinou. ");
INSERT INTO wnu_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","In end igo ne qen geret Yuda wurinou inorou qen ger gab ne in ginam eng wogub tap toat isi ya ger gabut isuminei. Isub igumine qamamir: “Yuda munon qei Qenut qebi qomorub at igour,” ende igub is gamin eng yamangar yurau qei end darari qob wurinob qamb igunei. ");
INSERT INTO wnu_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ende qamb igumune yamangar ger unum Lidia. Yamangar eng wonou ginam Taiataira. Wo mingoan sig uber-uber mai ne munon aib qei wurisab mi taui ba ende at igoai. Ne wo qenen Qenut igub igoar end se Pol qob qamara iruges big igub igama Qenu wonou sia mom imbig wot oabigorei. ");
INSERT INTO wnu_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ende aba wogub wonou yurau nob ya obotar wurimaragansiune ne inuruar ete qamar: “An init misir igub gab eng, Yisast mom apand oabigour, ende qamb gab eng yarab ininob et bais inab wogub iuar,” ende init qamara wurinob igunei. ");
INSERT INTO wnu_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","End igo qen geret bo wuri Qenu nob qamb qiumuni igour end isuminei. Isub ne sarau batar igo yamangar wau ger maurem opuriamorei igo ne mi qen geret mai ebeiner eng miteri qamb igoai. Ende igama ne munon yamangar qei qen geret maigas obounor eng wurit qamara igub qamb nomon qur utab igurei. Utari ne wonou munon baraitari eng wurisab igoai. ");
INSERT INTO wnu_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Qen end yamangar eng intoar qib ete qamb ab qib igoai: “Munon yurau eng Qenu mi gugum qanam eng wonou yurau. End ne in mai ubune Qenu inubersieriner eng inimbigub yorour eng.” ");
INSERT INTO wnu_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Yamangar eng qenen ende at intoar qib igama Pol iet wogub igeser maurem opuri igoar eng qamat qamar: “Yisas Krais eng unumut nonob quraum. Yamangar e wogub der iua.” Ende qamara maurem eng wogub qoorei. ");
INSERT INTO wnu_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Yamangar eng Pol musia uberbura ne munon mi qen geret mi mai wurisieriner eng qamara igub igour end ne gor munon qei yamangar eng qoat musub igamari nomon qur ba wurisab igo eng der bo mi eng gar me ubunerei eng gab Pol Sailas nob wurit misiringet wogub qob wurit musub maigas gab uyort wuribigub qamb oromar isumirei. ");
INSERT INTO wnu_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Isi Rom gabman eng wurinob qamamir: “Yuda munon ombur e in ginam aibt e yar igo qomon boru song-song ebet qib igour. ");
INSERT INTO wnu_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","22","In Rom qomon end mom gitab igoun eng ombur ebet qib igour,” ende qamarari munon yurau eng gor der ombur igaramb qamb ebetemirei. Ende abari gabman wurinou mingoan nob boburmatar arir wogub ne burtuum wurinob qamarari pisirami igaramirei. ");
INSERT INTO wnu_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ende borusi igaramb wogub oromar uyort wuribig igour munai eng isumirei. Isub munon munai eng qoat igo eng nob qamarari mondir nausi mom ubotar musub mom oroar igoriner qamamirei. ");
INSERT INTO wnu_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Ende qamarari ne qob igub wuriba uyort igour munai aib eng tumbigi qomourt ger end ombur wuriarir wogub nam ii ombur ba wurinou goten eng gugus big mom nausi touriamirei. ");
INSERT INTO wnu_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Itum wobon Pol Sailas nob Qenut uru wab a wot simot ab ende ebet igurei. Igamari erogori uyort igour eng der igub igurei. ");
INSERT INTO wnu_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Ende at igamari ne ai aib uyab mon aib eng ururasi ne mondir nausi obotemir eng wonou wei a nam ii gugus big wuritouriamir eng ururat uburerei. ");
INSERT INTO wnu_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Burtuum munai eng qoat igoar eng der mondir unat ende gab munon gugum iua ubururei qamb qasuri ba wonomi gumat umib qamb ebeterei. ");
INSERT INTO wnu_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ende aba Pol gab qamat ar: “In ger me qoau, gugum igoun nonou quman me sopurom,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Ende qamara wogub urut qamara ba yarari mor ito isub Pol Sailas nob wuribaab eerei. ");
INSERT INTO wnu_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ende at oromar ago der qamar: “Wa, ye mai ansierine ye yeubersioruboumon?” ");
INSERT INTO wnu_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ende qamara wuri nob qamamir: “Ne Yisast oabiga ne nonou qanam gari eng Qenu anubersieriba,” ende qamamirei. ");
INSERT INTO wnu_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ende qamb Munon Aib qob wonou qanam erogori eng wurinob qamb igurei. ");
INSERT INTO wnu_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ende abari ne burtuum eng der Pol Sailas nob bunomt igaramb igour iam eng iam purianit tourimatarerei. Ende aba wogub Pol Sailas nob der burtuum eng wonou qanam erogori eng ya obotar wurimaragansiamirei. ");
INSERT INTO wnu_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ende wurimaragansiari wogub wo der Pol Sailas nob oromar wonou munai mor irab mi yab wurinob nub wogub ne wo wonou qanam erogori eng der wo Qenut oabigor eng gab mismisiramirei. ");
INSERT INTO wnu_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Urigerma ne gabman munon baraitari eng burtuum qei wuriimuri qamamir: “Irab munon uyort igour oroar igo eng nob qamarari munon ombur eng worowaga qoounor,” qamarei. ");
INSERT INTO wnu_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ende qamarari wuri diab Pol Sailas nob wuriimurimb qamamir: “An qob ue, ar qi der iuar.” ");
INSERT INTO wnu_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ende qamarari Pol der burtuum qob ba diamir eng wurinob qamar: “Ende ue, in ar qi me quunei. Qoan Rom gabman in ombur Rom munon buror qamb inmaribigor ego barim in qomon boru obour qamb qob qanam musub me igatarau. Ar munon magqurt pisirami iningaramb uyort inbigomanei. End ne see qas qand is aninou munon baraitari eng wurinob qamarari diab qob musitar wogub inimurimari qoauboun.” ");
INSERT INTO wnu_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Ende qamarari burtuum eng bo qand isub wurinob qamarari borusi yariamirei. ");
INSERT INTO wnu_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Yari ne qand Pol Sailas nob igour end irab qamamir: “Io, in qomon boru ansiaminei, end ne an ginam e wogub aninou taut iuar.” Ende qamb wuriimuriamirei. ");
INSERT INTO wnu_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Ne Pol Sailas nob uyort igamau munai eng wogub bo Lidia wonou munai mor end isub Yisas yurau qei end igour eng oromar qiumuni wurinonogursi wogub qoamirei. ");
INSERT INTO wnu_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Eng qoamir eng isi ginam aib Ampipolis end yar ne bo tumbigi isi Apolonia. Ginam eng wogub isi ginam Tesalonaika end isumirei. Ginam end Yuda wurinou Qenut igau mon aib end igoai. ");
INSERT INTO wnu_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","End ne Pol wonou qomon eng ginam gugum qib Yuda wurinou mon mor end isub qib igoar end bo ginam end gor end isub oromar qiumuni igoai. Oromar qiumuni ne Qenu qob bukt igoar eng wurinob inorou qen duor gari end qamb igoai. ");
INSERT INTO wnu_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Qamb qamar: “Qenu munon init imurima inubersierib derer eng waramari umb wogub bo der bugamorei. Ye end qanam animbig quraum eng, munon eng Yisas gari wo munon ginam gugum wuriubersiau tari.” ");
INSERT INTO wnu_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ende qamara Yuda munon qei qob igub iot ne Pol Sailas nob orotoaremirei. Ne Grik munon irou Yuda qomon toat igour eng ne ginam end yamangar qei baraitari igour eng wuri gor qob igub Yisast oabigumirei. ");
INSERT INTO wnu_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ende abari ne Yuda yurau qei der Pol Sailas nob qob qamarari munon yamangar irou qob igub oabig abari ibag ne wuri der irigau munon qei misir uber ue ar song-song qib igour eng oromar qiumuniamirei. Qiumuni mindigar qob wurit qamb Pol Sailas nob wuriba uyort wuribigub qamb Ende qamb isub Yeson wonou munai qouiamirei. ");
INSERT INTO wnu_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ende at gamir eng ombur me igamari ibag ne Yeson baab ne munon qei Pol yuraut igour eng nob oromar munon Kaunsel baraitari ginam aib end isumirei. Isub oromar qamamir: “Pol Sailas nob wuri qomon wes ebet munon ginam irou abari musub erogori me igour,” qamamir. ");
INSERT INTO wnu_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Qamb qamamir: “Ombur ininou king Sisar Rom qob qamb igo eng biistet ne wuri ete qamb igour: in gugum king ger Yisas eng qob igotoun, ende qamb igour,” qamamir. “Ende qamb qib ginam e yarari Yeson wo wuriba mor big wurinob igo.” ");
INSERT INTO wnu_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ende qamarari munon ar ne kaunsel munon baraitari eng der oau boruburemirei. ");
INSERT INTO wnu_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Ende at ne kaunsel munon baraitari eng der Yeson wonou yurau eng wuri nob qamarari uyort igamau eng wogub uput qamb nomon qur taui wurisemirei. Wurisari qamamir: An qomon eng bo obounon eng nomon qur e bo me baunanei.” Ende qamb wuriimurimari isumirei. ");
INSERT INTO wnu_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Isub igamari itumorama ne Pol Sailas nob wuriimurimari ginam Beria end isumirei. End isub ombur Yuda wurinou Qenut igau munai end isumirei. ");
INSERT INTO wnu_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Ginam end isub qob qamamir eng munon qob igau. End Pol qob qamara wuri iruges big igub ne qob qoan bukt gumatemir igo eng boair qob eng qeemben qi eng gub qamb. ");
INSERT INTO wnu_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ende ebet ne Yuda ne Grik yamangar baraitari ne Grik munon qei qob end oabigumirei. ");
INSERT INTO wnu_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Pol Beria end is qob ende wurinob qamb igama Yuda Tesalonaika igour eng qob igumirei. Igub Beria end isub munon boru qarigtari ir qib igour eng oromar qiumuni Pol qob soopurmb qamb ebetemirei. ");
INSERT INTO wnu_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Ende abari Pol wot isub igour eng qand imurimari uyer ya gabut isorei. Isa ne Sailas Timoti nob eng igurei. ");
INSERT INTO wnu_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Igamari Pol wonou yurau qei wurinob isi ginam Atens end igo ne Pol Sailas Timoti nob Beria igour end qob biga ba iramirei. Irab ombur wurinob qamamir: “Pol an ombur wo qani isar qamb qob biga ba diaun,” qamamirei. ");
INSERT INTO wnu_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Pol qob big wogub ombur oroar igo ne ginam Atens eng gar wurinou ai bigau irou qerismindou mi eng gagar qugur barsi wogub Qenu qamb wurit igub igamari ibagarei. ");
INSERT INTO wnu_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Eng gab ne Yuda Qenut igau munai mor end isub Yuda ne Grik munon qei Yuda qomon taut igour eng nob qamb ne maket ginam end is munon ar end igour eng wurinob qamb ende at igoai. ");
INSERT INTO wnu_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Pol qamb qamar: “In Yisast oabig eng umb Yisas der bugamor gas ende der bugomboun.” Ende qamara Grik wurinou qoyam munon yurau qei Epikurian ne Stoik qamb igour eng der wonob agunumirei. Ne qei qamamir: “Munon e qindeindir qob song-song qamb wonou qen big qib igo,” qamarari ne qei: “Aibigau song-song igour eng qob qamarari toat igorun qamb qura qiyo,” ende qamb igurei. Eng qamamir eng Pol wo qob uber Yisas wo umb der bugamor gas ende in gor umb der bugomboun ende qamar end qamamir eng. ");
INSERT INTO wnu_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","20","Ende qamb wogub Pol mot ai qaur ger Areopagus qamb igour end irune kaunsel unumiramir eng Atens igour eng qob qamara qerei igar qamb. Irab Pol nob qamamir: “Qob bubun munon ginam-ginam wurinob qamb qib igoan eng bo qamara igun. In igoun eng bubun, gab bo igub,” ende qamamirei. ");
INSERT INTO wnu_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Ende qamarari ne Atens munon ne munon ginam qei yar ginam end qenen igour eng wuri qomon eng mi bubun ger gab qob suab qib igour. End bo Pol qob eng qamara bubun igub bo igub ebetemirei. ");
INSERT INTO wnu_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Munon gugum ai qaur Areopagus end qiumuni igamari Pol wubunobun end der naget qamar: “Ye qob qamara igun qamb quraumon end qemeribam eng. ");
INSERT INTO wnu_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ye yar ginam et qib gaum eng an sogoin qamb aibigau munai irou wuri mindatar mian yematar Qenu apand qamb wurit misir aib igub igoumon eng diban animbagaum. Nam qab ger mian yomb qamb nagsiaman eng erer end gaum eng an qob ger ete qamb gumatemanei: Qenu in qoyam ue eng wonou mani bigotoun, qamaman eng ye see wonou unum qomon eng quraum eng. ");
INSERT INTO wnu_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Qenu ai tat nob barsi mi gugum bigor eng wonou qoat igo. End ne munon ger wo mon mindetet qamara di end me igorinerei. ");
INSERT INTO wnu_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ne gor wo mi ger ue gab aba in me utunei, sig ue. Wo gari in munangit inoar a mi qei-qei gabri igoun eng gugum inoar igama igom qib igoun,” qamar. ");
INSERT INTO wnu_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Ne qamar: “Qenu wo munon gari qas barsi wogub aba wonou wau misinam qebebi darab tau purab isari tau purab isub ende at isi ai qent gugum opur ne qob wes-wes qamb igour. Eng Qenu wurinou ginam maribigetar ne wurinou igom igamau qen maribigorei. ");
INSERT INTO wnu_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ende ebine munon gugum ye yiimbig musub igoarar qamb. Wo ende at mugenderi me igo, pi igo, munon ger wot igib qamb aba musierib qamb. ");
INSERT INTO wnu_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Wonou gari in munon gugum ininou qanam end ne in qib uber igoun. End ne aninou munon qei imbig qob ete gumatemir eng: ‘In Qenu wonou wagrari’ qamb gumatemir eng. ");
INSERT INTO wnu_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Pol ende qamb qamar: “In Qenu wonou wagrari qamb eng, in bo Qenu eng ‘mai nomon aib ger gas ende qe, mai munon qei nam tau barsi igour gas ende qe,’ ende me qomorun. ");
INSERT INTO wnu_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Segagam qoan munon qei Qenu sir ue end qugur barsiari wo me wurisi igamau. Ne see eng wonou qob gim mom diban biga munon ginam-ginam isuor eng bo sabar ai bigaut oabig obounon eng ansieriba. ");
INSERT INTO wnu_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ende at ne wo qen geret munon gugum wurinou qomon at igour eng qerei insieriner eng maribigorei igo. Wo Yisas imurima der bebereg igamau qomon eng insirbigorei, wo umb der bugamor end.” ");
INSERT INTO wnu_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Pol qob eng qamb isi yarab munon ger umb der bugamorei eng qamara igub munon qei der ber qob wot qamamir. Ne qei qamamir: “Qob eng quran eng bo sabar qamara igun.” ");
INSERT INTO wnu_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ende qamarari Pol wogub qoorei. ");
INSERT INTO wnu_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Qoa ne munon qei qob bo igub qamb Pol toat isub Yisast oabigumirei. Ne munon ger unum Dionisius wo munon wuriba ai Areopagus end wuri qiumuni igo eng, ne yamangar ger unum Damaris, ne munon qei-qei gor Yisast oabig isumirei. ");
INSERT INTO wnu_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Ne Pol ginam Atens eng wogub bo Korin isorei. ");
INSERT INTO wnu_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Korin end Yuda munon ger ubeni nob igurei. Munon unum Akwila, qoan unor baur eng ai Pontus end. Wo aib burab yamangar unum Prisila baub ne ai Itali end isub ginam Rom end igurei. Qen end Rom king unum Klodius wo Yuda munon Rom ginam aib end yar igour eng gugum orotoar arirama wes-wes iua uburari munon eng ubeni nob yar Korin eng igurei. ");
INSERT INTO wnu_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Pol is ombur ibagar eng wonou sarau wai goan mai biga qur utab taui ba seri mon mindat igour. Sarau eng ombur gor ebet igamari ibag wurinob sarau eng ebet igoai. ");
INSERT INTO wnu_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Igo ne inorou qen end Yuda wurinou Qenut igau mor end isub Yuda ne munon yurau Grik qei soroi qob wurinob qamb igoai. ");
INSERT INTO wnu_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Ende at igama Sailas Timoti nob Masedonia wogub yarari ne Pol sarau ger ebet igoar eng wogub ne Yuda yurau eng qenen wurinob qamb igoai. Qamb qamar: “Qenu munon init imurima inubersierib qamb derer eng Yisas gari.” ");
INSERT INTO wnu_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Pol ende qamara qob me igotoun qamb der qob isi wot qamb abari wo der wurinob qamar: “An qob eng siningot oboumon end qen geret boruburab gab eng yet misir me igar, aninou qas. Ye se qas an Yuda anwogub munon Yuda ue ar eng wurinob qamb qib igoribam.” ");
INSERT INTO wnu_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Ende qamb wogub der is munon ar ger unum Titius Yastus wonou munai end isorei. Wo Qenut oabig igoai. Wonou munai Yuda wurinou Qenut igau munai qonut igoai. ");
INSERT INTO wnu_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Ne munon baraitari aib ger unum Krispus wo Yuda wurinou Qenu qob igau munai eng qoat igoai. Wo wonou wagrari ne Korin munon qei nob Pol Yisas qob wurinob qamara qob igetet oabig abari yat wurimaragansiarei. ");
INSERT INTO wnu_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Qen geret itum Pol inerei igo inig wap-wapi gar ego Munon Aib nob qamar: “Ne wurit yari qob bo me wurinob qemerinei qamb me eb, ");
INSERT INTO wnu_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","ye noat igoum end munon ger me nanaminerei. Munon irou ginam et yonou qob igub yonou yurau igoarar qamb wurimaribigomei igour ar degen qamb igoar,” ende qamarei. ");
INSERT INTO wnu_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Ende nob qamara Pol nonoguret ne togun gari ne bo inaun 6-ende Korin eng igo Qenu qob wurinob qamb igoai. ");
INSERT INTO wnu_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Ende igama ne munon ger unum Galio. Wo Rom gabman end yarab ne wo gor sarau ende ebet ne Grik munon eng igour eng oroar igoai. Qen end Yuda munon yar Pol mot qob musub uyort bigub qamb gabman munai end isumirei. ");
INSERT INTO wnu_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Isub munon baraitari eng nob qamamir: “Munon e in Qenut igub qomon ebet igoun eng wo bo qomon eng nugutumuget ebet munon yamangar wuriimbiga in qomon eng wogub igour,” qamamir. ");
INSERT INTO wnu_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Ende qamarari Pol bo qemerini qamb ebeter ego munon eng Galio der qob woretet Yuda wurinob qamar: “Munon e gabman qomon nugutumuget ebeterei qi eng ar qamarari soageni ebet qib igo eng ye imbigoum. Ar qamarari ye musitarib qamb eng ar musitoroum qi. ");
INSERT INTO wnu_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","End ne an naget aninou mi qeir igoumon eng qamb a aninou qomon eng qamb bisari ye wogoum. Ye aninou mi eng gar ye sir ue end qob me musitarinei.” ");
INSERT INTO wnu_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ende qamb Yuda mor igour eng orogar ag ariramorei. ");
INSERT INTO wnu_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Isub wurinou munon baraitari aib Qenu qob igau mon qoat igo eng unum Sostenes wo baab bis qob musiau munai igama qonut end bis waramb igurei. Ende at igamari gab Galio qob ger me qamarau. ");
INSERT INTO wnu_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Ne Pol Korin end Yisast oabigumir eng wurinob qen qei igoi wogub ne end worowogub wo bo Prisila Akwila wurinob bo ginam aib Senkria end isumirei. End isub Pol wo Yuda wurinou qomon eng toat Qenu nob qamb qen maribig tari im me sopur igamau. Ginam end isub tari im sopur wogub bo tumbigi tabin ba ai Siria end isub qamb isumirei. ");
INSERT INTO wnu_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Tabint isumir eng isi yarab Epesus end weib isumirei. Isub munon yamangar eng nob end worowogub wo Yuda wurinou qob igau munai end isub qob wurinob qamb igoai. ");
INSERT INTO wnu_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ende qamara igub munon ginam eng der duet qamamir ego wo der wuri nob qamar: “See me aninob igorinei. Qen geret Qenu wonou bo anit yar qamb yiimurima eng bo yaribam.” ");
INSERT INTO wnu_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ende qamb wogub Akwila Prisila nob Epesus end worowogub wo tabin ba isi ginam aib Sisaria end isorei. ");
INSERT INTO wnu_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Isub ne bo gotent tumbigi isi, Yerusalem umo weib isub ne Yisast oabig igour yurau eng ibagarei. Ibag bo ginam aib Antiok eng irarei. ");
INSERT INTO wnu_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Irab qen gurum nami eng igoi wogub ne bo ai Galesia ne ai Prigia wurinou ginam gugum is qib munon yamangar Yisast oabig igour eng wurinonogursi qib igoai. ");
INSERT INTO wnu_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Qen end munon ger ginam Epesus wes end igo wurit diarei, unum eng Apolos. Wonou ginam qenen eng Aleksandria. Ginam eng ai Isip end igo. Munon eng wo munon sarog, ne gor Qenu qob gigit gumatemir eng wo musub mom imbig igoai. ");
INSERT INTO wnu_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","End ne Yisas qob eng wo qo imbig ne wonou qomon eng ne qob eng qoyam big wurinob qamb igoai. Ne qob gari qas eng wo qanam sir me iotarau. Yon yat wurimaragansi igoar eng wo sir. Ego Yisas wonou eng wo sir ue. ");
INSERT INTO wnu_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Qen end Yuda wurinou qob igau munai end isub qob dibes wurinob qamb igama Prisila Akwila nob igub wogub yar mot wurinou munai end isub ombur bo Qenu mi ebeter eng nob qamb igurei. ");
INSERT INTO wnu_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Nob igamari Apolos bo Grik isiba ne Epesus munon Yisast oabig igour eng der Grik igour end namanimun gumutrunei igama Apolos bisa gab ba mor big musub nob igamari Qenu wonou wurisera wot oabigumir eng Apolos wo bo wurinonogursi igoar qamb. ");
INSERT INTO wnu_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Apolos end is igo ne qob irou Yuda wurinob qamara wuri bo maigas me nob qamarau. Qanam mom dibes end wurinob qamara wuri der qamamir: “Io, qob gigit gumatemir eng Qenu Munon Aib Yisas in Yuda nob munon ginam-ginam init imurimb qamar eng ar qeemben,” ende qamamirei. ");
INSERT INTO wnu_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","2","Apolos is Korin end igama ne Pol ginam qani-qani eng qibei-qibei is Epesus end weib diab munon qei Yisas wo maribig igour eng end ibag wuri qebi qamar: “An Qenu Igomurur qau anit isorei?” Ende qamara wuri qamamir: “In Qenu Igomurur qau munon wot isiner eng qob eng ininob qamarari musub me igau.” ");
INSERT INTO wnu_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Qamarari Pol qamar: “End ne an maigas ya obotar anmaragansiamirei?” Qamara wuri qamamir: “In Yon qoan wurimaragansi igoar gas ende at obotaremirei,” qamamir. ");
INSERT INTO wnu_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Ne Pol qamar: “Yon wo wurimaragansi igoar eng munon qomon boru-boru eng dibes qamarari ne wo munon ger wo qanam yar igoar eng unum Yisas eng wot oabigari wurimaragansi igoai.” ");
INSERT INTO wnu_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Ende qamara igub Yisast oabigari Munon Aib Yisas unumut wurimaragansiarei. ");
INSERT INTO wnu_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Ne Pol uben erer wurit biga ne Igomurur qau der gari-gari wurit isa qob bubun me qamb igour eng qamb Qenu qob qanam dibes qamamirei. ");
INSERT INTO wnu_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Qen end Igomurur qau wurit isuor eng 12-ende. ");
INSERT INTO wnu_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pol ende at ne wurinou qob igau munai mor end isub inaun duorgari ende.” Erogori qibanamsi igamau eng Qenu wonou anoar igoriba qamb ne qob qei-qei eng bo sabar qamb wurinonogursiarei. ");
INSERT INTO wnu_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ende aba qei der qob eng me wot oabig ne. Munon aibt qob isi qamb ende ebetemirei. Abari Pol der Yisast oabig igour eng qas worowanunget ba bis munon ger unum Tiranus imbigau munai end bis wuriqiumuni qob wurinob qamb igoai. ");
INSERT INTO wnu_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Pol sarau eng ebet igama togun ombur warei. Ende aba ne Esia munon yurau eng qei Yuda ne qei munon ar ende Munon Aib qob musub igub igurei. ");
INSERT INTO wnu_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Qen end Pol Qenu qomon wes-wes aba gab igurei. ");
INSERT INTO wnu_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Ende gab ne qei Pol wonou mingoan neri biga ba munon toar nob eng wurigigibanir ariramari toar worowagerei. Ne qei ai bigau igaramor eng abari uberet ende ebetemirei. ");
INSERT INTO wnu_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","14","Ne Yuda munon baraitari ger wo munon Qenut mian yab begetet igour eng wo gigit igoai, unum Seba. Wonou munonbor wau 7-ende, wuri qib Pol Yisas unumot sarau baab igo gas ende ar munon ger ai bigau waramorei igama ai bigau eng nob qamamir: “In Pol Yisas unumut ai bigau wurit wab arir igo eng in gor ne nob quraun. Munon e wogub iua.” ");
INSERT INTO wnu_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ende qamarari ai bigau munon opuriamor eng wot di qamar: “Yisas Pol nob ye qoyam ego an your?” ");
INSERT INTO wnu_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ende qamb ne der munon 7-ende eng borusi mom igaramb ne mingoan nob ombopumi arir ugab wogub qei ararau munon eng wonou munai eng wogub ag der qoamirei. ");
INSERT INTO wnu_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ende abari Yuda ne munon ar qei Epesus igour eng qob toau isa igub borusi yari ne Yisast mom oabigumirei. ");
INSERT INTO wnu_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ne munon qei Yisast se oabigumir eng der munon yurau wurimaragansiamir eng wurit qomon boru ebetemir eng dibes wurinob qamarari Qenu wurimusiarei. ");
INSERT INTO wnu_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Ende ebet wogub ne wurinou buk ger gab-gab munon wuridumi igour eng gugum ba qiumuni mutet wamirei. Buk eng irou, munon taui baub qamb qur wurisunor eng qangang eng K50,000-ende yariba. ");
INSERT INTO wnu_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ende abari ne Munon Aib qob imusi-imusi isub ne munon yurau aib Yisast oabig nonoguret uburemirei. ");
INSERT INTO wnu_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Ende abari Pol bo Masedonia yar Grik di ne Yerusalem irini qamar. Irab end igoi wogub bo Rom isini,” qamarei. ");
INSERT INTO wnu_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ende qamb ne wonou erogori sarau baab qib igour eng Timoti Erastus nob gigit wuriimurima Masedonia isari wonou Esia ai end qib igoai. ");
INSERT INTO wnu_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Qen end Epesus munon qei der Yisast oabigari wurimaragansiamir eng end me igoarar qamb wuri nob agunumirei. ");
INSERT INTO wnu_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Munon eng qanambig wurinob agunuor eng unum Demitrius. Munon eng wo ai bigau unum Artemis munai mindatetemir eng qugur wapet barsi igoai. Ende at munon wurisab taui qur baub igoai. ");
INSERT INTO wnu_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Ne Demitrius wo munon qei erogori sarau eng ebet igour eng wuriqiumuni wurinob qamar: “In sarau e ebet igoun end nomon qur aib yar igo end in uber igoun.” ");
INSERT INTO wnu_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","End ne Pol wo qob qamb igo eng aninou igub igoumon eng wo ete qamb igo: “Munon wurinou qugur ubent barsi wogub Qenut big qamb igour eng uber ue ende qamb igo,” qamar. Ende aba ne munon Epesus ginam aib e ne Esia munon gugum wo igetet ne oabig wot isub igour eng. ");
INSERT INTO wnu_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Eng gab ye wo tumet igoum. Ati in sarau e weibi wugune qinan qob init qamb ne ininou ai bigau yamangar munon Esia ne munon ginam gugum wot igub igour munai eng ba meinsiorubour eng, qamar. ");
INSERT INTO wnu_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Demitrius ende qamara igub Polt borusi misiringet ne ai bigau Artemis end amir: “Ne in munon ginam aib Epesus e inmusub igoan.” ");
INSERT INTO wnu_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Ende qamb ab is Masedonia munon ombur Pol nob erogori sarau baab qib igour eng is wuribamirei. Wuri unum eng Gaius Aristarkus nob wuribaab ubumot qiumuni igour end isumirei. ");
INSERT INTO wnu_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Ende oromar isari Pol is wurinob qemerib isib ater ego wonou yurau qei der duetemirei. ");
INSERT INTO wnu_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Duari ne gabman munon baraitari ginam eng gor der Polt qiumunimau end me isiner qamb taisi qob gim wot bigumirei. ");
INSERT INTO wnu_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Eng qiumuniamir eng qob ger togsi me qamarau, ger der qob qamar eng wonou wes, ne ger der qamar eng wonou wes, ende at qob qamb ousi igurei. ");
INSERT INTO wnu_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ende at igamari Yuda der munon ger unum Aleksander qob qem qamb qamarari der nageterei. Naga munon qei der wo qiumunimau e qanam bigar eng qob qemeriner qamb igub igurei. ");
INSERT INTO wnu_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Igamari wo qob musub qemerib ebeter ego wuri der Yuda ion gab wogub qamb amir: “Artemis gari ininou Epesus munon gugum baraitari inoar igo.” ");
INSERT INTO wnu_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Qob eng qen dirigor ab isub igurei. Ende qamb ab isub igamari gabman munon nomon qur qoat igo eng der wuritaisia wagari ne qamar: An munon ginam qenen, munon ginam gugum inimbig igour. In yamangar ai bigau Artemis wonou munai mindetet ne wonou ai bigau nomon tatet qite derer eng qas wot oabig igoun. ");
INSERT INTO wnu_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","End ne munon ger qob e me omboariraminerei. Ende ebet qand mirinet wogub munon song-song igaramunon eng qomon uber ue. ");
INSERT INTO wnu_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","An munon ombur e oromar yoroumon eng wuri ininou mi uber ger ai bigau munai mor end urim me baiau. Ne gor ininou yamangar ai bigau qob isi me wot qamarau.” ");
INSERT INTO wnu_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Qamb qamar: “Ende gab eng Demitrius wonou erogori qur baub qamb sarau ebet igour eng wuri munon geret misiringet gab eng qob musitarunor. Eng munon qob qerei igau eng mom musub iginer.” ");
INSERT INTO wnu_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Qamb qamar: “An qob ger igama qomorub gab eng qiumunimau et qamarari munon baraitari qob musub qerei igunor. ");
INSERT INTO wnu_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","End ne qiumunimau see woguboun e. Qob tog ger me quraun, ar ber qob gari qamb ousi igoun e, qiumunimoun e qob qanam ger ue. Gabman munon baraitari qob ar song-song quraun e igub qamarari in mai qomoruboun. Sig ue.” ");
INSERT INTO wnu_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Munon qur qoat igo eng ende qamb wogub wuriimurima mor qoamirei. ");
INSERT INTO wnu_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ende qoari wogub ne qen end bais uber erogori igoi wogub Pol munon Yisast oabig igour yurau eng wuriba qiumuni qobut wurinonogursiarei. Ende at wogub uber igoarar qamb wogub wo ai Masedonia end isorei. ");
INSERT INTO wnu_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Isub-isub Masedonia ginam qei isub qob wurinob qamb isi-i ai Grik end isorei. ");
INSERT INTO wnu_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","End isi igama inaun ombur gari ende uma wogub bo girinet tabin ba ai Siria end isib misir igorei. Ende ebeter ego Yuda munon qei qob igub yuraut opuri igour qamarari igub bo igeser Masedonia wes eng irab bo tumbigi ai Siria isib qamb irarei. ");
INSERT INTO wnu_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Iriba ne munon qei nob iramir eng unum eng ete Sopater ur eng Pirus, wonou ginam qenen eng Beria. Ne Aristarkus Sekundus nob wurinou ginam aib eng Tesalonaika. Ne ger Gaius wonou ginam Derbe. Ne munon ombur gari Timoti, Tikikus ne Tropimus wuri ai Esia. Munon yurau eng Pol nob iramirei. ");
INSERT INTO wnu_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","6","Pol qamar: “Munon yurau eng gigit isub Troas end inoar igamari in ombur Pilipai end igumu ne qen aib Qenu enger ininou tonoan wuri me igaramau qamb mi at nub igour eng niari ibag igumu ne qen 5-ende ubura in ombur tabin ba isi Troas end igamari ibag erogori end igumu ne inorou gari umorei. ");
INSERT INTO wnu_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Ne Sande qen end ai gab-gab in gugum ginam qenen eng wurinob erogori bugab mani qibi boat numinei. Nub igo Pol barim worowogub qoaun ende qamb qob wurinob qamb igama igoi itum wobon isorei. ");
INSERT INTO wnu_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Eng munai tumbigi erer qitend qiumuni yorumut gumet uri ende at igunei. ");
INSERT INTO wnu_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Pol qob ende qamb isub igama igoi itum qir isa wogub wau qen ger unum Yutikus. Wo monir end bugab qugi igoi wogub uburab yarsi ago qumo dererei. Dara is bemeni gamir e umorei. ");
INSERT INTO wnu_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Ende gab qamarari Pol qand isub baab gab qamar: “An misir me igar, bo igomot der bugemba.” ");
INSERT INTO wnu_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","12","Ende wurinob qamb wogub bo erer qite irab mani parau nub wogub bo qob imusi qamb isub igama igoi uriger worom weib dera, wau moi umor eng bo igomot der bogoma mismisir nob mor isari, Pol ginam Asos end isorei. ");
INSERT INTO wnu_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","14","Isib qamb Pol in gigit isub ginam Asos end yoat igoarar qamb inimurima in tabin ba isune wo ag gotent dererei. Darab isi end inimbigea wo nob bo tabin ba isi ai qaur Mitilini end isuminei. ");
INSERT INTO wnu_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","End ineminei igo urigerma bo isi ai qaur ginam Kios, end ineminei igo urigerma bo tumbigi isi ai qaur Samos end isub bo deget Miletus end isuminei. ");
INSERT INTO wnu_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pol end tabin ba bo Epesus end isib ater ego ai Esia end qas qib igimine qen uburiner qamb ne gor Igomurur qau wurit isuor qen ‘Pentikos’ qamb igour eng gor piara gab qand Yerusalem qite irib qamb. ");
INSERT INTO wnu_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Ende at ne wo Miletus end igo munon Yisast oabig igour Epesus igour eng yar yegaiar qamb qob bigorei. ");
INSERT INTO wnu_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Qob biga yarari ne wurinob qamar: Se qamart ye Esia umo anit yar aninob igo qomon ebine yiimbigomanei. ");
INSERT INTO wnu_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Sarau bam eng ger mein ger me beau. Yuda der ye sarau ebine yequguragsi qas. Ende ebetemir ego ye yonomit misir me igau. Yisas Munon Aib sarau betine obour eng ende qamb igumei. ");
INSERT INTO wnu_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","End ne qenen aninou munai gari-gari end ye qob animbig ne qiumunimari qob aninob qamb ne ye qob ger me wabi igamau. ");
INSERT INTO wnu_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Yuda yurau eng ne munon ar garisi ye qob ete an irun wab qamb igumei: “Aninou qomon boru-boru eng mogirt wab wogub Qenu wot igub ininou Munon Aib Yisas toat igoarar,” ende qamb igumei. ");
INSERT INTO wnu_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","End ne see Qenu wonou Igomurur qau eng ye ginam aib Yerusalem qite ir qamb ye sesima isibam. Eng maigas yesiorunor qiyo eng ye sir ue. ");
INSERT INTO wnu_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Eng ye ginam gugum qib igimine Igomurur qau ye irun wab ete qamb igoai: ‘Ne git irinen eng nebaab nanamb nequguragsi ne uyort nebigubour end me yariom,’ ende yenob qamara ne yonou git goan end misir me igoum. ");
INSERT INTO wnu_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Yisas wonou ye sarau yet maribigor eng mom at ugeini qamb yonou sarau eng Qenu munon gugum wurit igub igo end ende ebine Yisast oabig igoarar qamb ");
INSERT INTO wnu_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","End ne erogori igamau qomon eng Qenu wonou qoat igo eng ye animbig qib igoum eng. Ne se ye bo menman me yegunanei. ");
INSERT INTO wnu_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","27","End ne Qenu ansi igo eng qenen aninob qamb igoum eng. Eng ye ber begetet me aninob qamb igamau. Munon ger wonou qob eng me igini qamb ebet eng, wonou qas. ");
INSERT INTO wnu_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Ye bo me yegab eng aninou mom nonoguretaman eng. Qei der qei nonogursi ende at igoarar. Ende abari qebenau qau ansiara uber qi qoat-qoat igoruboumon. ");
INSERT INTO wnu_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Git ye anwogub quine munon qei iau qaar wai sipsip got nub igo gas ende at diorubour. End ne an mom nonoguret igoarar. ");
INSERT INTO wnu_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ne qei aninou erogori end der qetopur qamarari an qei wurit igub orotoar igoruboumon eng gor imbig igoarar. ");
INSERT INTO wnu_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Eng ye anmurimar me quraum. Togun ombur gari ende ye aninob igo anitoubar qenen itum woromt annonogursi igumei. ");
INSERT INTO wnu_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","End ne see Qenu anit wogoum eng wonou gari anoar animbag igoriba. Igama an wot nonoguret qomon uber qas abar. Ebet wonou munon yurau eng qoat-qoat igoarar. ");
INSERT INTO wnu_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Qoan ye aninob igoum eng aninou nomon qur qiyo mingoan ger yeisar qamb qibirat me aninob qamb igamau, ue. ");
INSERT INTO wnu_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Ye yonou sarau baab mi ba ne yonou munon yurau qei mi wurisab ebine yegab igoumon eng. ");
INSERT INTO wnu_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ye eng ebet qirine yegab igoumon gas ende an ger ende ebet munon banam qei mi ue ar igour eng mi werisar. Qomon eng qoan Yisas ebet ininob qamar eng ete: “Munon ger ne mi ue eng gab mi ger neteiner eng uber. A ne munon ger mi ue gab utab eng sig-sig mismisir, ende qamarei,” qamar. ");
INSERT INTO wnu_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Pol qob degen aib eng mom ende wurinob qamb ugab wogub (Yuda wurinou qomon eng) gamaur wat bugab Yisast qamarei. ");
INSERT INTO wnu_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","38","Ende ebet wogub isiba qoan bo menman me yegunanei qamar end borusi mom toubet eab-eab ubent baab mot bis tabint wagari isorei. ");
INSERT INTO wnu_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","End bis inogari in munon Epesus eng worowogub tabin ba isi ai qaur Kos end ineminei. Urigerma bo tabin ba isi ai qaur Rodes end darab isi ginam aib Patara end igunei. ");
INSERT INTO wnu_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","End is igo igumin eng tabin ger ai Ponisia end isib at igo qamarari igub in bo tabin end isub bo Ponisia isuminei. ");
INSERT INTO wnu_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","4","Tabin erer isub igo ne asi ai qaur Saiprus asi gab-gab isi ai Siria end isub wurinou mind ginam Tair end big igamari ne in ginam end isub munon Yisast oabig igour eng ibag wurinob inorou gari end igunei. Igumune Qenu Igomurur qau Yisas yurau qei wuriimbig ete qamar: “Pol Yerusalem ite iroa wuri der wobaab waramb uyort big ende siorubour,” ende wurinob qamara wuri der Pol Yerusalem ite iriner qamb taisiamirei. ");
INSERT INTO wnu_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Ende abari worowogub isubune munon yamangar wau ten nob isi ya gabut end is qiumuni orosout end bugab Qenu nob qamaminei. ");
INSERT INTO wnu_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Qamb wogub tabint isub qamb uber igoarar qamb wogub isune wuri bo iramirei. ");
INSERT INTO wnu_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Tabin eng in bisi ginam Tolemes end inwaga Yisast oabig igour yurau eng bo qen gari end wurinob igunei. ");
INSERT INTO wnu_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Urigom der bo isi Sisaria end isuminei. Ginam end isub Qenu qob qamarau munon ger Pilip munai end isub igunei. Pilip wo qoan Yerusalem qite munon 7-ende wuriqereiamir eng ger eng wo is ginam end igoai. ");
INSERT INTO wnu_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Pilip wo yamangar wau 4-ende munon me baiau. Ar igo Qenu qob qamb igurei. ");
INSERT INTO wnu_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Qen dirigor nami ende igumune munon ger Qenu qob qamara qamb igo munon unum Agabus. Wo Yudia end igo yarerei. ");
INSERT INTO wnu_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Yarab Pol wonou bur goan touri igoar eng nerub wonou gotent touri ubent touri ne ininob qamar. “Ye e oboum eng Igomurur qau yesia mirorub oboum. Eng gas ende bur goan e wonou ur eng baab uben goten Yerusalem qite iroa Yuda munon der wobaab uben goten touri wogub munon ar wurit imurimari isa ba waramb a sumungasi ende oboubour,” qamar. ");
INSERT INTO wnu_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Ende ininob qamara igub in ne ginam qenen eng der Pol Yerusalem qite me ir qamb dueteminei. ");
INSERT INTO wnu_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Duet qomorune Pol der ininob qamar: “An eng at eab abari ye quguragetroum. Ye Yerusalem ite irine uyort yebig yesumungasi, a yanamari umin eng gor qob ue. Eng ye Yisas wo munon baraitari aib yeubersi igo end wurinou ende yesiorunor. End ne an bo ye me yequguragsiunanei.” ");
INSERT INTO wnu_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","In nob ende qomorune wo ende ininob qamara in bo maigas me taisiunei eng gab wogub Qenut qamamin: “Nonou gari mi eng gagar wot eb,” ende qamaminei. ");
INSERT INTO wnu_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","16","Ende qamb igoi wogub Yerusalem qite irub qamb girinetei wogub irubune Sisaria munon qei ininob iramirei. Irab inamar isi Saiprus munon ger yar end igoar eng unum Nason wonou munai end isuminei. Nason wo Yisast qoan oabig igoai. ");
INSERT INTO wnu_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Qen end Yerusalem weib irune Yisas yurau eng inimbag borusi mom mismisiramirei. ");
INSERT INTO wnu_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Ineminei igo urigerma der Pol nob Yems ne banamori big ibogoub qamb isuminei. ");
INSERT INTO wnu_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Isub ibag mismisir uben wuribaab ne Pol der munon ginam ar qei-qei sarau bea Qenu wuri si igoar eng gugum wurinob qamb igoai. ");
INSERT INTO wnu_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Qob qamara mom igub wogub Qenut mismisir wogub Pol nob qamamir: “Nonou gari imbigan eng Yuda munon irou Yisast oabigumir eng wuri der Yuda qomon end mom nonogursi igour. ");
INSERT INTO wnu_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","End ne ne ginam ar mug-mug eng iua sarau baab Yuda qomon goan sirigum nob igoar qamb git goan sopur igour eng wagar qamb qiroa qamb Yuda munon yogur isub ginam eng gagar igour eng qob eng ende meten qob bigari e diara igub nenet outet igour. ");
INSERT INTO wnu_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","End ne ne e dian eng qob igub ne mai nesiorub qamb abari in mai obouboun? ");
INSERT INTO wnu_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","In ar ete qomorune igu, in e munon 4-ende wurinou gitab igamau end Qenut nob nausiamirei. ");
INSERT INTO wnu_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","End ne ne qand munon eng wurinob inorou munai aib end isub wuri nob Qenu qomon eng gitoroum qamb Yuda wurinou at igour gas ende aba negounor. Negab ne, ‘qo, qob mugenderi ar iguminei, wo qob eng ende me qamb qib igo,’ ende net qomorubour. ");
INSERT INTO wnu_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Eng in namanimun qo gumat munon Yuda ue yurau ar Yisast igub igour eng wuriimbig ete qamaminei.” An sogoin wurit mian iset bigari gab qiyo wai waramb yamari gab qiyo buru qeru girt ebet numbari gab eng me niar. Ne gor yamangar ba omboagir wogub ar qarig ir me qib igoarar. Moses qomon Yuda toat igour eng an nob tauar. Ende qamb wuriimbiguminei,” qamamir. ");
INSERT INTO wnu_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Inemirei igo urigerma Pol der munon 4-ende eng oromar inorou munai aib eng mor isub Qenut gitarau qomon eng ebetemirei. Ebet ne munon aib-aib inorou mon eng qoat igour eng wuri gim qob qen mai-mai ubura munon 4-eng gitab igour eng wogubour qi eng wurinob qamarei. A qen mait wai gari-gari wurit berari Qenut mutet worunor qi eng qoyoam qob wurinob qamarei. ");
INSERT INTO wnu_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Pol Yerusalem end igama ne qen 7-ende maribigumir eng uburib pisia ne Yuda ginam Esia igour eng yar gab bamirei. ");
INSERT INTO wnu_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Baab qamamir: Isrel munon yarari munon e gune wo gari munon ginam-ginam isub Moses qomon gumater eng nob inorou munai eng nob sai qob qamb qib igo. Ende at ne munon yurau ar qei wurinob di gitarau qomon eng songi qib igour,” qamamir. ");
INSERT INTO wnu_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Eng at qamamir eng Epesus munon ger unum Tropimus Pol nob dier eng bo nob qib ginam eng qib igama gab ne eng mom mot mor eng is gitab igour eng songi qib igo qamb qamamirei. ");
INSERT INTO wnu_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Ne qand qob bigari ginam aib eng isa ne munon yurau yar Pol baab ubumot bis ag arir wogub munai mondir qand ubet ugamirei. ");
INSERT INTO wnu_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","32","Ende at Pol waramb mumusiorub at ne aib qamb yogub igamari yogorau munon yurau Yerusalem ginam aib eng oroar igo eng igub wonou yurau eng oromar yara gab ne wogumirei. ");
INSERT INTO wnu_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Ende yarab ne yogorau munon baraitari eng Pol baab wonou yurau wurinob qamar: “Bunom ombur ba munon e ubent tourimar.” Ende qamb ne bo wuri qebi qamar: “Munon e youro? Ne wo qomon boru maigas at qib igo?” ");
INSERT INTO wnu_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Ende qamara munon yurau aib eng der qob song-song qamamirei. Ende abari yogorau munon barai eng sir me imbig ne wonou yurau eng wurinob qamara Pol mot wurinou munai gagam end isumirei. ");
INSERT INTO wnu_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","36","Mot isi yarab wurinou munai semb-semb naget irubari munon yurau ar qei qanam isumir eng qamb amir: “Munon eng mom waramb mumusiarar,” ende qamb amirei. ");
INSERT INTO wnu_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Mom mot mor isari Pol der munon baraitari eng Grik qobut nob qamara munon eng qiet qamar: “Ne Grik qob qoyam ne? ");
INSERT INTO wnu_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Ye ne Isip munon qoan wonou yurau 4,000-ende oromar ininou Rom gabman nob agunub ne wonou yurau oromar is ai segert igour eng ne qamb.” ");
INSERT INTO wnu_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Ende qamara Pol qamar: “Ye munon eng ue, ye Yuda munon, nani ginam Tarsus end yebaurei. Yonou ai aib eng Silisia. Yonou unum eng ginam aib end igo. End ne waga munon e wurinob qob qei qemerini qiyo?” ");
INSERT INTO wnu_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Ende qamara munon baraitari io qamara ne wo der naget qamara qob wogub qi igamari ne Yuda wurinou qobut qamara igub igurei. ");
INSERT INTO wnu_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Pol ete wurinob qamarei: “Taineb, ye ete qemerine igar. Ye qomon boru ger me abau, eng qemerine musub igar.” ");
INSERT INTO wnu_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Ende qamb Yuda wurinou qobut qamara qi bugab iruges big igub igurei. ");
INSERT INTO wnu_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","Wo ete qamarei: “Ye Yuda munon, yonou ai aib eng Silisia. Ginam aib Tarsus end nani yebaurei. Ye wayi igimine Yerusalem e ye nob diarari aninou munon baraitari Gamaliel eng qoyam yiimbig igama igoi ye baraitari buremei. Wo ininou tonoan qomon eng musub yiimbigor end ye Qenu qob an toat igoumon gas ende ebet igoum. ");
INSERT INTO wnu_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Qoan ye munon yamangar Yisast igub igour eng qei igarami ne umari ne qei wuribaab touri uyort wuribig igumei. ");
INSERT INTO wnu_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Ye eng quraum eng qetopur ue, aninou munon baraitari eng qamarari iguboumon. Wuri namani gumat yesari gab is Damaskus umo munon yurau Yisast igub igour eng oromar Yerusalem di ne Yuda bunom taut igaramar qamb. ");
INSERT INTO wnu_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Ende qamarari ye Damaskus isib qamb isub igimine worom ginam tog igama mi begen aib ger ai qebisimau gas ende yet begentarei. ");
INSERT INTO wnu_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Ende aba ye gab ai qent qumo qurer inab ig igum ego munon ger ete ye nob qamarei: ‘Sol, meimet qamb ye yeborusi qib igoan?’ ");
INSERT INTO wnu_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Ende qamara ye bo qamam: ‘Barai, ne youro?’ Ne wo yenob qamar: ‘Ye Yisas Nasaret munon eng ye yeborusi qib igoan eng.’ ");
INSERT INTO wnu_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Ende yenob qamara munon yenob isumir eng begen qas gamirei, qob yenob qamar eng wuri me igau. ");
INSERT INTO wnu_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Ne ye bo qebi qamam: “Barai ye mai ebeibam”. Ende qemerine wo bo qamar: ‘Der bugab Damaskus umo isa Qenu ne mi ebeinen eng munon ger nob qamara arsi igama is ebeiban.’ ");
INSERT INTO wnu_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Ende qamara ye der naget isib atem ego begen eng aba ye mag tuumtar end tap musub me gine yebaab nob Damaskus umo isuminei. ");
INSERT INTO wnu_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Ginam end munon ger unum Ananaias end igoai. Wo munon Yisast igub ne wo ininou qomon eng mom toat igama Yuda munon wot munon uber qamb igurei. ");
INSERT INTO wnu_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ye end isine ne wo di ye qani et naget ye unumot qas qamar: ‘Sol, warigesi asi ge.’ Ende ye nob qamara ar ubersi asi wogomei. ");
INSERT INTO wnu_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Gine wo qamar: “Ininou tonoan Qenu wot igub igour eng ne wo mi gugum ebine imbig qamb abai. Ne gor wonou munon qoregen eng ne ge qamb maribigeteter end wo net ara igan eng. ");
INSERT INTO wnu_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","End ne ne wo mi aba gan eng ne igan eng gugum munon qei wurinob qamb qiriban. ");
INSERT INTO wnu_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","End ne meimet qoat igorine, qand der naga nemaragansine ne ininou Munon baraitari eng wot ara nonou qomon boru eng net wab arimba,” ende ye nob qamarei. ");
INSERT INTO wnu_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Ende ye nob qamara wogub bo Yerusalem e diab is munai aib end Qenut qebi qamb igo inigau gas ende ebetemei. ");
INSERT INTO wnu_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Ebet Munon Aib gine yenob qamar: ‘Ne yonou qob Yerusalem munon yamangar wurinob qamara me igutunorei. Ende gab ne see qas qand ginam e wogub iua.’ ");
INSERT INTO wnu_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Ende qamara ye qamam, “Barai, ye Yuda wurinou nonou qob igau munai mor end isub munon yamangar net igub igour eng ye igaramb uyort wuribig ende ebet qirine musub yiimbig igour. ");
INSERT INTO wnu_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Eng qoan munon Stiben eng nonou qob qamb qib igama nomont waramari uma ye gor end oau pomaimot munon waramb igour eng wurinou mingoan qoat igumei. ");
INSERT INTO wnu_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Ende qemerine Munon Aib ye nob qamar: Der isa ye niimurimine munon Yuda ue munon ar ginam end isiban.” ");
INSERT INTO wnu_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Pol qob ende qamara igub isi yarab wo der munon Yuda ue munon ar eng qob uber wurinob qamb qib igumoi ende qamara igub wuri der wot misiringet qob weretet qamamir: “Munon eng mom umb weginer igo eng at qiribar eng.” ");
INSERT INTO wnu_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ende qamb wurinou misiringet ebet igour eng mingoan norumi bobumi arir a qoamin ubuet arir ende ebetemirei. ");
INSERT INTO wnu_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Abari yogorau munon wurinou gigit eng der wonou yurau wurinob qamar: “An munon eng mot ininou munait isar. Isub bunom taut qas waramb wogub qebi gaiar. Geari wo meimi qomon boru ger aba Yuda mom gumotoab waramb ebet igour qi.” ");
INSERT INTO wnu_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Ende qamara wonou yurau eng Pol touri wogub is nob igo waramb at igurei. Ne Pol wo yogorau munon yurau ger wurinou gigit igo eng nob-nob et naget igo qand nob qamar: “Qomon ete igo, munon ger unum Rom gabman buk end igama wo qomon boru ger aba gab eng qob gigit wot musub mai apand ende ebeterei qi eng gab war