﻿USE sofia;
DROP TABLE IF EXISTS sofia.wnc_vpl;
CREATE TABLE wnc_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES wnc_vpl WRITE;
INSERT INTO wnc_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","Aminu wai aminde wamu dua gwaamuke, gatu waaminda kepi tawake tasikaing kaknga dua tasike, gatu Anutue masa wam yake tasikaing aminkat dua yukengu, waapata asiknga bakngawik. ");
INSERT INTO wnc_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","Aminu waapata Anututane mama wamde asiknga bakngake, gatu mama wamu waakngae zikaane gatu gunzit tapane ba tapduknga wena asinggan natanggamatake tasinggak. ");
INSERT INTO wnc_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","Aminu waapa katapdaka binga yangga kwaimune kwaiwan tapdukngane buya aawan tatakngita dua kupiakaing binga sanga kuupbam aminu waapata tasinggau take siknga buya asaakgak. ");
INSERT INTO wnc_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","Sike waiaknga tawake tasikaing aminu unza dua. Tambam tapunde ooi gotda puyapakunggak binga dakngake buyana dua aawik. ");
INSERT INTO wnc_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","Dakngake wai aminu waakwakga Anutue kaine wamu yawan take dua siwik. Siwan waaminda amin nomande banakan katang gatake yutnanga dua. ");
INSERT INTO wnc_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","Dasingge? Anututa aminu kepi noman tawake tasikaing aminde asiknga bakngake kakuya tasinggak. Siwan ngana aminu waiaknga tawake tasikaingu sanga kuupbam tasiwik ba puya takngatu tasiwanu take sinanga dua. ");
INSERT INTO wnc_vpl VALUES ("PS2_1","020_2_1","PSA","2","1","1","Dasingge katum aminu dongu kuupbamdane nanata sanga yamandet taknga tasinangge natake yandekaing? Dasingge aminu waakwakga sanga sanga tasinangge natake wamu moo yandekaing? ");
INSERT INTO wnc_vpl VALUES ("PS2_2","020_2_2","PSA","2","2","2","Kingu kepna kepna yuaingga amak tasinangge tandakngakaing. Tandakngake waaminda natdetdeu takngatukan natake Buyambam tapatane umana tasiwan maiwikge kepie tawakaing. Gatu aminu tapatu Anututa tasiwan ita aminu kuupbam kakuya tasiwik kapa dakngakuu, King yuaingga aminu waapatane umana kuut tasiwan maiwikge kepi tawakaing. ");
INSERT INTO wnc_vpl VALUES ("PS2_3","020_2_3","PSA","2","3","3","Tawake waaminda anzing yakaing, “Ita ninu panggaganuwawa yuamangge nindane katakngin unekan wambuu waitdetna. Gatu ita nau takngatuta kepinin unekan wapbuu sandetna,” ngang yakaing. ");
INSERT INTO wnc_vpl VALUES ("PS2_4","020_2_4","PSA","2","4","4","Unzing yawan kake Anutu yekaune Kingu kopsa yuak kapata ayanimike sapdut wam yaninggak. ");
INSERT INTO wnc_vpl VALUES ("PS2_5","020_2_5","PSA","2","5","5","Yanike ita musiaatang toknga siknga natayamuke wamu kekeknga siknga aknga yaninggak. Yanike itane kaanga akngata tasiwan asiknga gwaukaing. ");
INSERT INTO wnc_vpl VALUES ("PS2_6","020_2_6","PSA","2","6","6","Ngan, ita wamu kekeknga siknga waaknga anzing yanikut, “Nata aminu tapatu King dakngawikge aapa gwa yawa yuak. Nata nina tewa Saion kep komune yuak. Ninane tawan takwan daka unin.” ");
INSERT INTO wnc_vpl VALUES ("PS2_7","020_2_7","PSA","2","7","7","Siwan Kingu waapata anzing yakut, “Apmanu nata wamu Buyambam tapata nanikuunin yakapit. Ita na King dakngawitde natake anzing nanikut, ‘Ga natane waaknga. Nata gatane nangga dakngake yuat. ");
INSERT INTO wnc_vpl VALUES ("PS2_8","020_2_8","PSA","2","8","8","Gata na nanikwaiwinu katum aminu kuupbam keu kaukaut nana aminu gae gamit. Gama gata aminu kepna kepna nana kuupbam kakuya tasiya. ");
INSERT INTO wnc_vpl VALUES ("PS2_9","020_2_9","PSA","2","9","9","Kakuya tasike gata musipbaatangu waaminde butaya natake katakga kekeknga sikngaapata kayuya. Kayuke gata waaminu pake matekmateknga zipbuya. Unzing aminda gapma kwatan gwen zipbukaing binga,’ ngang nanikut.” ");
INSERT INTO wnc_vpl VALUES ("PS2_10","020_2_10","PSA","2","10","10","Siwan wamu waaknga natake ginu King aminda maak gwaang pake yuyukza tapan nomatayok. Ngan, ginu kepna kepna yuainggane tupan amin, ginda wamu aaknga natake, Yako, ngang natake akgwautnong. ");
INSERT INTO wnc_vpl VALUES ("PS2_11","020_2_11","PSA","2","11","11","Ginda Anutuekan akgwauke ie gepbiatang koyutnong. Koyuke ie asatnake ngana ie gatu apbaknganong. ");
INSERT INTO wnc_vpl VALUES ("PS2_12","020_2_12","PSA","2","12","12","Ginda itane waakngae asinimbaknganong. Ita musiptok ginde natapsak. Dasingge, ita musiptou zaat natandaman ginda akumning. Siwan ngana aminu Anutue gepbiatang koyukengu, waakwakga apbaknganing. ");
INSERT INTO wnc_vpl VALUES ("PS3_1","020_3_1","PSA","3","1","1","Buyambam tapa, natane iwana kwaapzang singgak. Ngan. Aminu kwaapzangga na tasiwa maiwitde tasikaing. ");
INSERT INTO wnc_vpl VALUES ("PS3_2","020_3_2","PSA","3","2","2","Tasike waaminda nae anzing nanikaing, “Asikaya Anututa ga gatangamik,” ngang yakaing. ");
INSERT INTO wnc_vpl VALUES ("PS3_3","020_3_3","PSA","3","3","3","Siwan ngana, Anutu, ga tiunggu amakgane dakata binga dakngake na takusopunggayak. Gata na takusopuke tasiwi natane umana buyambam siwawan nata akekekake yuat. ");
INSERT INTO wnc_vpl VALUES ("PS3_4","020_3_4","PSA","3","4","4","Siwan Anututa na gatangamikge ayatawanggat. Ita enane siknga tawanu inane dakane yuke nata wamu yanggau atnatangamunggak. Natangamuke na take gatangamunggak. ");
INSERT INTO wnc_vpl VALUES ("PS3_5","020_3_5","PSA","3","5","5","Siwan zikaane na dapuna peke apepbotanggat. Pesika gatuna enake na take yuat. Dasingge, Anututa na kakuya katak siknga nanduyuak. ");
INSERT INTO wnc_vpl VALUES ("PS3_6","020_3_6","PSA","3","6","6","Natane iwana 10,000-nu kepna kepna nanata umutnawakaing. Umutnawawa ngana nata ie dua gwaukgat. ");
INSERT INTO wnc_vpl VALUES ("PS3_7","020_3_7","PSA","3","7","7","Buyambam tapana, ga natane Anutuna. Gata apuke na gatangamuyo. Gatangamuke natane iwana atzipso. Ngan, itane gena zipmanziya. ");
INSERT INTO wnc_vpl VALUES ("PS3_8","020_3_8","PSA","3","8","8","Buyambam tapata ninu sandeke papan meya takngatu dua kanim. Buyambam tapa, ninu gikane amindabamde kakuya take pasiwi takekan yutnim. ");
INSERT INTO wnc_vpl VALUES ("PS4_1","020_4_1","PSA","4","1","1","Anutu, gata natane Anutu noman sikngaapanin. Nata musipmaatang meya siknga nataat. Sike nata ga gatangamiyakge natake gae ganiwa gata nae wam natake gatangamuyo. Gatangamuke gata na musipmane meya nataat taknga sandekngamuyo. Sandekngamuke gata nae musip kwikwik natangamuke tumuk wamae maak papso. ");
INSERT INTO wnc_vpl VALUES ("PS4_2","020_4_2","PSA","4","2","2","Ginu kuupbam! Tapduu datdasing binga ginda natane umana yaitapaakusiwan natane umana kopsa akngata wena siwik? Tapduu datdasing binga sanga kem taknga akngae natanggamataning? Tapduu datdasing binga ginda kem taknga inata inata tawake tasining? ");
INSERT INTO wnc_vpl VALUES ("PS4_3","020_4_3","PSA","4","3","3","Ginda wamu aaknga katak siknga natapnong. Aminu Buyambam tapae gepbiatang koyuaingu, waaminu inae yawan yuaing. Siwan nata ie ininggamatawawa, ita nata yanggau atnatapik. ");
INSERT INTO wnc_vpl VALUES ("PS4_4","020_4_4","PSA","4","4","4","Ginda musip tok natapning kopatangu ginda wai tasinanga aknga apbitanong. Tapduu dapunza petnangge tasikaing komune ginda natdetdetza ba musipzaatang nataingu katak natake genza asuumutnong. ");
INSERT INTO wnc_vpl VALUES ("PS4_5","020_4_5","PSA","4","5","5","Ginda sanga inata inata Buyambam tapata take nataak takngakan take imunong. Imuke ie banip siknga sinong. ");
INSERT INTO wnc_vpl VALUES ("PS4_6","020_4_6","PSA","4","6","6","Siwan aminbamda yakwaik wamu yumdekan anzing yakaing, “Mamin tapataka ninu take gatanimik?” Buyambam tapa, gata ninde musip kwikwik natanimuke gatanimuyo. ");
INSERT INTO wnc_vpl VALUES ("PS4_7","020_4_7","PSA","4","7","7","Siakan. Tapduu nanamu wit gatu wain ngang yanikaingga puyane buyana kwaapzang aawanu aminbamda kake apbakngakaing. Siwan ngana baknga baknga aknga nae musipatang tekuyakga itane bakngananga akngana ayapbikut. ");
INSERT INTO wnc_vpl VALUES ("PS4_8","020_4_8","PSA","4","8","8","Buyambam tapa, gatakan nanduyuwawi na take yuke sanga tapatue dua gwaumbit. Dua gwauke tapduu nata dapun pekgat komune zaat pepbotanggat. ");
INSERT INTO wnc_vpl VALUES ("PS5_1","020_5_1","PSA","5","1","1","Buyambam tapa, natane tumuk wamae maak pangamuyo. Natane natdetdetnane yangapuke natanggamatanggat takngae natapso. ");
INSERT INTO wnc_vpl VALUES ("PS5_2","020_5_2","PSA","5","2","2","Ga natane kinga, siwan natane Anutuna. Tapduu na gata gatamiakge natake tumuk wam ganinggat komune maak gwaang panggamuyo. ");
INSERT INTO wnc_vpl VALUES ("PS5_3","020_5_3","PSA","5","3","3","Buyambam tapa, tembana bamu asinggan nata tumuk wamu gae ganinggat. Ganiwawa kuku gunzitda akonggak. Ge gata yapii yake naniwiakge maak pake yuat. ");
INSERT INTO wnc_vpl VALUES ("PS5_4","020_5_4","PSA","5","4","4","Anutu, ga sanga waiakngae take dua nataayak. Aminu waiaknga tasikaing amikat gaat gatake yutnanga dua. ");
INSERT INTO wnc_vpl VALUES ("PS5_5","020_5_5","PSA","5","5","5","Gata yamandet tasikaing aminu kapewi gae nomune yutnanga dua. Wena siknga. Siwan gata waiaknga tasikaing aminde semna siknga nataayak. ");
INSERT INTO wnc_vpl VALUES ("PS5_6","020_5_6","PSA","5","6","6","Gata kem wam yakaingu kuupbam apasiwi maikaing. Siwan amin zipmake kem wam yakaing aminde toknga siknga nataayak. ");
INSERT INTO wnc_vpl VALUES ("PS5_7","020_5_7","PSA","5","7","7","Siwan ngana gata nae musip kwikwik siknga natangamunggayak. Unzingge nata yotdane take akopit. Yot takwan gwende kanggamatake munu puke ganimbakngawit. ");
INSERT INTO wnc_vpl VALUES ("PS5_8","020_5_8","PSA","5","8","8","Anutu, iwanata nutnangge tasikaing. Ge gata kepina tanomanuwi gatane yuyukga noman taknga tawambit. Tawamba noman taknga gata take nataak kakngane gata tupan kuke nanitake kuyo. ");
INSERT INTO wnc_vpl VALUES ("PS5_9","020_5_9","PSA","5","9","9","Sike iwana waakwakga siakan wamu takngatusimu dua siknga genane yakaing. Dua yake aminu kundu pasiwa maining gekan nataaing. Siwan kem wamu atdopan yuke yakaing. Yake tanzit wam yanike tasiwa maikaing. ");
INSERT INTO wnc_vpl VALUES ("PS5_10","020_5_10","PSA","5","10","10","Sike Anutu, gata yake waaminde wamna natake toknga take yamuyo. Yamuke tasiwi waaminda natdetdeu gutonga nataaing kakngata pasiwan sopunong. Waaminda gae yamandet tasike waiaknga buyambam tasikaing, gae nomune dua yutningge yanikwasiwi maa siknga kunong. ");
INSERT INTO wnc_vpl VALUES ("PS5_11","020_5_11","PSA","5","11","11","Siwan ngana aminu kuupbamu gae gepbiatang koke yuaing aminu take nataaingu waaminda apbakngake kap gwaang taike yutning. Gata take siknga kakuya tasinggayakge aminu kuupbamda gae asiknga bakngake gatane umanda yatangenakaing. ");
INSERT INTO wnc_vpl VALUES ("PS5_12","020_5_12","PSA","5","12","12","Buyambam tapa, gata aminu gae wam natake tasikaing aminde take natayamuke sanga takekan tasiyamunggayak. Gata tuyunggu amin kotnanggak san binga dakngake pakotnanggayak. Katak siknga pakotnawi take yuaing. ");
INSERT INTO wnc_vpl VALUES ("PS6_1","020_6_1","PSA","6","1","1","Buyambam tapa, gata nae kaanga natangamunggayak ngana na kaanga ma naniwim. Ga nae musiptok nataayak ngana gata na ma tasiwi maiwam. ");
INSERT INTO wnc_vpl VALUES ("PS6_2","020_6_2","PSA","6","2","2","Buyambam tapa, na kekekngana wena singgak. Unzingge gata nae butaya natapso. Natane gupma tuyuknga siknga singgak. Ge gata na tasiwi take gatu yuwit. ");
INSERT INTO wnc_vpl VALUES ("PS6_3","020_6_3","PSA","6","3","3","Natane musipmaatangu meya buyambam siknga. Siwan ngana Buyambam tapa, ga dasing? Tapduu datdasing nandutewi musipmaatang meya buyak yuwit? ");
INSERT INTO wnc_vpl VALUES ("PS6_4","020_6_4","PSA","6","4","4","Buyambam tapa, gata gatuka na tapi na dua kupit. Gata nae musip kwikwiu asinggan asinggan natangamuke gatangami nata take yuwit. ");
INSERT INTO wnc_vpl VALUES ("PS6_5","020_6_5","PSA","6","5","5","Aminu gwa kumbingga gae musiaatangu natdetnanga dua. Akungwake paku keu yuaing komunetanu gae umanda kopsa akngae dua yatangenakaing. ");
INSERT INTO wnc_vpl VALUES ("PS6_6","020_6_6","PSA","6","6","6","Nata gae yake yake yuwawa natane kekekngana wena singgak. Siwan zikaambamu asinggan kumzang kwanamu siwawa apekgat komu kai yangganata tasiwan bukatanggak. Ngan, natane buka gwena yanggakan singgak. ");
INSERT INTO wnc_vpl VALUES ("PS6_7","020_6_7","PSA","6","7","7","Natane iwana kwaapzang siknga. Unzingge na musipmaatang meya siknga natake kwanamu sike sike yuat. Kwanama siwa kainata zukngawan nata sanga tapatu katak kananga dua singgak. ");
INSERT INTO wnc_vpl VALUES ("PS6_8","020_6_8","PSA","6","8","8","Nata Buyambam tapae sitawamba gwa natangamuk. Ge ginu sanga waiaknga tasikaing aminu, napmake kukanong. ");
INSERT INTO wnc_vpl VALUES ("PS6_9","020_6_9","PSA","6","9","9","Nata Buyambam tapae yatawamba ita na gatangamikge gwa natangamuk. Ngan, ita tumuk wama gwa natak. ");
INSERT INTO wnc_vpl VALUES ("PS6_10","020_6_10","PSA","6","10","10","Natane iwanata meya buyak yuke nangaakan natapning ngangu nata atnataat. Nangaakan natake maaknga siknga natapning. Maaknga natake zeetgaman na napmake kuke datdaptake sukuning. ");
INSERT INTO wnc_vpl VALUES ("PS7_1","020_7_1","PSA","7","1","1","Anutu, Buyambam tapana, nata gae apuke iwanata nandupnang ngang natake kusopunggat. Kusopuwa gata gatangami aminu atnawaningga dua nutapan kupit. Ngan, gata na tapi nata meya dua papit. ");
INSERT INTO wnc_vpl VALUES ("PS7_2","020_7_2","PSA","7","2","2","Gata na dua tapinu iwanata kaap zongu laion ngang yanikaing binga dakngake amin gup yatdakngakaing binga na tasiwa maiwit. Ngan, waaminda kaitake keu komdune takuuwan aminu tapatuta na dua nanduke tapik. ");
INSERT INTO wnc_vpl VALUES ("PS7_3","020_7_3","PSA","7","3","3","Anutu, Buyambam tapana, sike na sanga wai takngatu apba tasikum, ba dasing? Ie na dua nataat. ");
INSERT INTO wnc_vpl VALUES ("PS7_4","020_7_4","PSA","7","4","4","Ba nata notna tapatue tanzit ba tasikum. Tasike kem wamu unin ba inikum. Siwan gatu nata iwana moo siknga ba tasiwa maikut. ");
INSERT INTO wnc_vpl VALUES ("PS7_5","020_7_5","PSA","7","5","5","Ayok, gata iwana kapewi na nawake tanggaganutnong. Na take nainggamuke natane gupma yainggamutake tasiwan kepdakane moo peke maiwik. ");
INSERT INTO wnc_vpl VALUES ("PS7_6","020_7_6","PSA","7","6","6","Anutu, natane iwanata musiptou amau nae tasinangge yakaing. Siwan gata waaminde musiptou natayamuke na gatangami meya dua kawit. Anutuna, ga nomana akngaekan nataayak. Unzingge gata enake waamindane amak wamna katak usanziyo. Usanzike kepi noman takngakan tawake na gatangamuyo. ");
INSERT INTO wnc_vpl VALUES ("PS7_7","020_7_7","PSA","7","7","7","Aminu apu unekan yuaingu gae wesim apuke takumbasinong. Siwan gata enane siknga yuke waaminu kayuyo. ");
INSERT INTO wnc_vpl VALUES ("PS7_8","020_7_8","PSA","7","8","8","Buyambam tapa, gata aminu dongu kuupbam usanzikgayak. Buyambam tapa, ga umanda kopsa siknga apanin. Gata na usanzike nandupi nata kepi noman takngaat gatu take siknga akngaat nganggan tasinggat taknga kake na usanzike take ngang naniyo. ");
INSERT INTO wnc_vpl VALUES ("PS7_9","020_7_9","PSA","7","9","9","Anutu, ga nomana sikngaapa. Gata aminbamda natdetdetnane gatu musiane nataaing kaknga usanzikgayak. Unzingge gata wai amindane musiptok natake wai tasikaing taknganane apasiwi wena sinong. Siwan gata noman aminu gatayami waaminu kekeknga yutnong. ");
INSERT INTO wnc_vpl VALUES ("PS7_10","020_7_10","PSA","7","10","10","Siwan natane tuyunggu Anutu unin. Ita nae kuyana tasinggak kapanin. Ita aminu ie wam natake tawakaingu papan takekan yutnong. ");
INSERT INTO wnc_vpl VALUES ("PS7_11","020_7_11","PSA","7","11","11","Anututa wamu noman gan usanzike wamu noman gan yanggak kapanin. Siwan gunzit bam asinggan ita waiaknga tasiya aminde musia toknga siknga natake yaipakepunggak. ");
INSERT INTO wnc_vpl VALUES ("PS7_12","020_7_12","PSA","7","12","12","Sike wai aminda musia dua tapan tekwambanu Anututa bainatna yasiwan tokngaaning. Siwan gatu kweemna mitake amak tasinangge tandakngawik. ");
INSERT INTO wnc_vpl VALUES ("PS7_13","020_7_13","PSA","7","13","13","Ita sanga amak tasike amin yapan kumningge gwa pandakngakut. Itane sakuu katapna kaya kaikgauni. Ita sakuu waapa apa wai amin yapan kumningge gwa pandakngakut. ");
INSERT INTO wnc_vpl VALUES ("PS7_14","020_7_14","PSA","7","14","14","Dasingge, wai aminda waiakngakan tasinangge natake natdetdetna gwa natapan yuaing. Ita sanga wai takngatu takngatu tasinangge tandakngake tasiwawa buyana asaawik. Buyana asaawan waaminda wai siknga meya buyak yutning. ");
INSERT INTO wnc_vpl VALUES ("PS7_15","020_7_15","PSA","7","15","15","Siakan. Aminu gapma buyambamu dakatu kwaiwa aminu kundu undang pukuwa papikge kwaikuu gapma wandakaatangu ina pimake pukuwik. ");
INSERT INTO wnc_vpl VALUES ("PS7_16","020_7_16","PSA","7","16","16","Ngan, gutonga ina tasinggak kakngata ina usukwatapik. Siwan amak wamu aminu kundue tasinangge yawik kakngata tapan tekwamban ina tasiwan maiwik. ");
INSERT INTO wnc_vpl VALUES ("PS7_17","020_7_17","PSA","7","17","17","Ngan, natapnong! Anutu waapa nomana sikngaapa. Unzingge nata ie gaak wamu ininggat. Nata Anutu enane siknga yuak kapae kau taike umana yatangenawit. ");
INSERT INTO wnc_vpl VALUES ("PS8_1","020_8_1","PSA","8","1","1","Anutu, ga nindane Buyambam tapanin. Gatane umanda aknga kopsa siknga yuak ngangu keu kuupbam kokomune anggaman singgak. Siwan gatane umanda buyambam taknga ena kakaa komune kuut tapan sopunggak. ");
INSERT INTO wnc_vpl VALUES ("PS8_2","020_8_2","PSA","8","2","2","Siwan gata natake waatdakaat engangkat kuutda gatane umanda yatangenatningge yawi kekekakut. Yawi kekekawan damanu kekeknga siknga gatane iwandaat gatu gae wam sapdukaing aminkatde kepi wamake umuyamunggayak. ");
INSERT INTO wnc_vpl VALUES ("PS8_3","020_8_3","PSA","8","3","3","Sike gata ena kakaa komu tasike tekuyakat gatu yekap gwen gatu yekapdaak ngangu pasike enane pewi yuaingu nata kake anzing nataat. ");
INSERT INTO wnc_vpl VALUES ("PS8_4","020_8_4","PSA","8","4","4","“Ninu aminu dasing binga ge gata ninde natanggamatanggayak? Ninu sanga yumdekan binga. Dasingge gata ninde kakuya tasinggayak?” ");
INSERT INTO wnc_vpl VALUES ("PS8_5","020_8_5","PSA","8","5","5","Gata ninu tumuke ninu umanin yapangenake pasiwi umaninu kaya dakngakamang. Siwan ngana angelatane umana akngata nindane umanin ayapbikaing. ");
INSERT INTO wnc_vpl VALUES ("PS8_6","020_8_6","PSA","8","6","6","Siwan gata ninu sanga bamu gika pasike pekuyau kakuya ninda pasinimde nipmambi yuamang. Siwan sanga kuupbamu pekuyau ninu aminde gepbiatang koke yuaing. ");
INSERT INTO wnc_vpl VALUES ("PS8_7","020_8_7","PSA","8","7","7","Ngan. Sipsip gatu ikwawa gaman gatu kaap zongu zongaatang yuaing. ");
INSERT INTO wnc_vpl VALUES ("PS8_8","020_8_8","PSA","8","8","8","Siwan gatu kwaiu engatangan bepmakaing. Gatu nambis gwene nana pis, gatu sanga bamu yangga gwekatang sukukaingu, wa kuupbamda ninde gepbiatang yuaing. ");
INSERT INTO wnc_vpl VALUES ("PS8_9","020_8_9","PSA","8","9","9","Anutu, ga nindane Buyambam tapanin. Gatane umanda aknga kopsa siknga yuak ngangu keu kuupbam kokomune anggaman singgak. ");
INSERT INTO wnc_vpl VALUES ("PS9_1","020_9_1","PSA","9","1","1","Anutu, natane musipmaatangu gae gaak wam ganinangge take siknga nataat. Nata aminu kuupbam gata puya kekeknga aknga aknga pasikuyakge yaninangge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS9_2","020_9_2","PSA","9","2","2","Nata gae natake nata kau apbakngananga aknga tainggat. Anutu kopsa sikngaapa, nata umanda kopsa siknga akngae kau taike umanda yatangenawit. ");
INSERT INTO wnc_vpl VALUES ("PS9_3","020_9_3","PSA","9","3","3","Dasingge, natane iwanata ga ganduke waakwakga atdatakukaing. Datakuke kaikane pimake waakwau kuupbam kungwakaing. ");
INSERT INTO wnc_vpl VALUES ("PS9_4","020_9_4","PSA","9","4","4","Gata wamu noman gan usanziwi waaminda kungwakaing. Gata natane yuyuknga usanziwi wamu yawiu natane wamu noman gan siwik. ");
INSERT INTO wnc_vpl VALUES ("PS9_5","020_9_5","PSA","9","5","5","Ngan, gata katum aminde kaanga wam yanikuyak. Yanike gata wai aminu gwa pasiwi maiking. Siakan, gata waamindane umana aknga gatukande dotdonguwi aminu tapatuta waamindane umana dua siknga natapik. ");
INSERT INTO wnc_vpl VALUES ("PS9_6","020_9_6","PSA","9","6","6","Gata iwanu gwa pasiwi maikingu ina unzing asinggan asinggan yutning. Anutu, gata waamindane yotbam gapma gapma gwa pasiwi maikingge aminu kuupbamda waaminde apbotake gatu natapnanga dua. ");
INSERT INTO wnc_vpl VALUES ("PS9_7","020_9_7","PSA","9","7","7","Siwan Buyambamtapa Kingu asinggan asinggan yuwik. Yuke ita wam usanzitnangge natake gwa tandakngake yuak. ");
INSERT INTO wnc_vpl VALUES ("PS9_8","020_9_8","PSA","9","8","8","Ita aminu kuupbam noman siknga kayuak. Ngan, inane noman takngane aminu yuaingu kuupbam yuyuknga saak usanziwik. ");
INSERT INTO wnc_vpl VALUES ("PS9_9","020_9_9","PSA","9","9","9","Buyambamtapa you kekeknga gwenduta binga yuak. Aminu kundu iwanata meya yamukaingu, waaminu ie kuke iatang koke kusopuke take yutning. ");
INSERT INTO wnc_vpl VALUES ("PS9_10","020_9_10","PSA","9","10","10","Buyambam tapa, gata aminu gae apukaingu masa dua yamunggayak. Unzingge aminu gatane yapiie atnataaing ganu gae gepbiatang koyutning. ");
INSERT INTO wnc_vpl VALUES ("PS9_11","020_9_11","PSA","9","11","11","Buyambam tapata King siknga Saion yotbam gapmane yuakge ginu kuupbamda ie kau taike umana aknga yatangenatnong. Yatangenake dongu kuupbamde puya buyambamu ita pasikutde yanikapnong. ");
INSERT INTO wnc_vpl VALUES ("PS9_12","020_9_12","PSA","9","12","12","Buyambam tapa, aminu amin zipa kungwakaing aminde yake toknga yamunggak kapata atnatanggamatanggak. Sike kwanamu ie sikainggengu maaknga dua umukusinggak. Dua umukusiwan aminu aminda toknga aknga yamukaing aminde yake toknga yamunggak. ");
INSERT INTO wnc_vpl VALUES ("PS9_13","020_9_13","PSA","9","13","13","Siwan Buyambam tapa, iwanata meya nae namukaingge kayo. Na akupitde dapaknga gwa siwan ngana gata nae musip kwikwik natangamuke na tapi take yuwit. ");
INSERT INTO wnc_vpl VALUES ("PS9_14","020_9_14","PSA","9","14","14","Unzingge nata sanga kuupbam gata tasikuyakge yanitakuke gatane umanda yatangenawit. Yatangenake nata Saion yotbam gapmane gwambok gwaune yuke gata na takuyakge apbakngake yanikapit. ");
INSERT INTO wnc_vpl VALUES ("PS9_15","020_9_15","PSA","9","15","15","Sike katum aminda kepdakaatang gapma nin panggaganuwikge kwaiking ngana waaminda ina pimaking. Siakan. Waaminda yapapna nin panangge kaiwan dandakaking. Kaiwan dandakawan ngana yapapnata ina pakut. ");
INSERT INTO wnc_vpl VALUES ("PS9_16","020_9_16","PSA","9","16","16","Anututa inane yuyuknga waaminde tapduu wam yakaing komune yeuyamunggak. Unzingge wai aminda aminu kundu pasiwan mainingge pasikaing ngana Anututa tasiwan sanga wanda tapan tekwamban ina pasiwan maikaing. ");
INSERT INTO wnc_vpl VALUES ("PS9_17","020_9_17","PSA","9","17","17","Wai aminu kuupbamda gwa kumbing aminda yuaing komune paku yutning. Ngan, aminu Anutue masa imukaingu wa kuupbam waomunekan paku yutning. ");
INSERT INTO wnc_vpl VALUES ("PS9_18","020_9_18","PSA","9","18","18","Siwan ngana asingganu Anututa aminu sangaapana wenae dua botawik. Ngan, aminu wa meyambam pake yuaingga Anutue banip siwan ita gatayamikge kayutning. Kayuwawan ita moo dua kapewan yutning. ");
INSERT INTO wnc_vpl VALUES ("PS9_19","020_9_19","PSA","9","19","19","Siwan Anutu, ga apso. Gata aminu dua kapewi gae yamandet tasining. Gata katum aminu pasiwi wam yananga komune yuwawa gata waamindane yuyuknga usanziyo. ");
INSERT INTO wnc_vpl VALUES ("PS9_20","020_9_20","PSA","9","20","20","Buyambam tapa, gata pasiwi waaminu asiknga gwautnong. Gata pasiwi aminu kuupbam anzing natapnong, “Ninu amindakan sanga moo binga yuamang.” ");
INSERT INTO wnc_vpl VALUES ("PS10_1","020_10_1","PSA","10","1","1","Buyambam tapa, ga dasingge napmake paku maa yuayak? Ga dasingge tapduu nata meya kaat komune na napmake paku kusopunggayak? ");
INSERT INTO wnc_vpl VALUES ("PS10_2","020_10_2","PSA","10","2","2","Wai aminda yamandet sike kekekngana wena aminu apasiwan mainingge yawakaing. Yawake aminu wa kekekngana wena aminu panggaganutnangge natake gapma kwaiwan undang pukuning. ");
INSERT INTO wnc_vpl VALUES ("PS10_3","020_10_3","PSA","10","3","3","Wai aminda yamandet sike sanga wai musiaatang nataak kaknga tawake tasinggak. Tawake tasike aminu sangabamde geengukgak kapa apbaknganggak. Apbakngake ita Buyambamtapa inisapduke ie masa imunggak. ");
INSERT INTO wnc_vpl VALUES ("PS10_4","020_10_4","PSA","10","4","4","Masa imuke na kopsaapa yuat ngang musiane moo siknga nataak. Natake Buyambam tapae dua natapan singgak. Aho. Natdetdetnaatangu Anutue dua siknga nataak. ");
INSERT INTO wnc_vpl VALUES ("PS10_5","020_10_5","PSA","10","5","5","Sike sangabamu ita pasinggau takekan singgak. Buyambam tapa, ita gae natdetdetde mateknga sipaa dua nataak. Siwan ita sapdut wamu iwanae ayanggak. ");
INSERT INTO wnc_vpl VALUES ("PS10_6","020_10_6","PSA","10","6","6","Itanu anzing nataak, “Na kekeknga yuat. Sanga tapatuta dua siknga kwasiwik,” ngang nataak. Siwan, “Nata meya dua kawit. Aho, asinggan asinggan musipma tatanga natake yuwit,” ngang yanggak. ");
INSERT INTO wnc_vpl VALUES ("PS10_7","020_10_7","PSA","10","7","7","Ita wamu wai yake aminu kundue asinggan yanisapdukgak. Yanisapduke ita kem wam gatu gwaut wamu aminu kundue yanikapmanggak. Siakan, ita wamu waiaknga aknga yake gutonga kwaapzang pasinangge yanggak. ");
INSERT INTO wnc_vpl VALUES ("PS10_8","020_10_8","PSA","10","8","8","Gatu itakan yotgapma kwaimune kusopuke yuwawan aminu noman amin tapata apan tanguwan kupikge natake yuak. Siakan, ita akusopuke kayuwawan aminu tapatu tapatuta apa kake zipan kumningge kayuak. ");
INSERT INTO wnc_vpl VALUES ("PS10_9","020_10_9","PSA","10","9","9","Unzing kaap zongu laion ngang yanikaingga ganangiatang kusopuke kayuaing binga kayuak. Siwan akusopuke kekekngana wena amin panggaganutnangge kayuak. Ita yapapnaatang panggagunuke kaipake kunggak. ");
INSERT INTO wnc_vpl VALUES ("PS10_10","020_10_10","PSA","10","10","10","Ita ayaitapakusike yuwawan aminu kekekngana wena aminu zaatgaman maikaing. Siakan, wai aminu waapatane kekeknganata ayapbikgak. ");
INSERT INTO wnc_vpl VALUES ("PS10_11","020_10_11","PSA","10","11","11","Ayapbike ita anzing nataak, “Anututa gutonga nata pasinggatdenu nangaakan dua nataak. Ita na dua nanduyuak. Kai gwa dopusangakutde nandupnanga dua.” ");
INSERT INTO wnc_vpl VALUES ("PS10_12","020_10_12","PSA","10","12","12","Buyambam tapa, ga apso. Anutu, apuke gata wai aminu waakwau atasiwi mainong. Sike gata aminu meya pakaing aminde dua botawim. ");
INSERT INTO wnc_vpl VALUES ("PS10_13","020_10_13","PSA","10","13","13","Siwan wai aminu waapata gae masa gamuke musiaatangu anzing nataak, “Nata gutonga tasinggatde Anututa meya yake dua namik.” Dasingge, aminu waapa gae dua ba gwauke yuak? ");
INSERT INTO wnc_vpl VALUES ("PS10_14","020_10_14","PSA","10","14","14","Siwan ngana wai aminu waapata wai takngatu takngatu pasiwan aminu kunduta meya pake maike yuwawan gata katak akaayak. Akake gata toknga ba meya aminu kunduta kaaingu gata kake waaminu gatayamunangge atandaknganggayak. Ngan, ga sangana wena aminu gae gepbiatang koke yuwawanu gata asinggan gatayamunggayak. Siakan, aminu nana gwa kumbuu kekekngana wena apaya gata gatangamunggayak. ");
INSERT INTO wnc_vpl VALUES ("PS10_15","020_10_15","PSA","10","15","15","Gata wai amindane kataknga puke kekekngana pasiwi sopunong. Pasiwi sopuwan kotim tasike waiaknga waaminda tasikaingu gatu dua tasiwan kaya. ");
INSERT INTO wnc_vpl VALUES ("PS10_16","020_10_16","PSA","10","16","16","Buyambamtapa Kingu asinggan asinggan yuwik. Yuke ita katum aminu inane kep komune yuke ie masa imukaingu yanikwasiwan kuke gatukande wena sining. ");
INSERT INTO wnc_vpl VALUES ("PS10_17","020_10_17","PSA","10","17","17","Buyambam tapa, gata aminu meya takngatu takngatu pake yuainggane tumuk wamnae atnataayak. Wamna natake gata musia papi kekekanong. ");
INSERT INTO wnc_vpl VALUES ("PS10_18","020_10_18","PSA","10","18","18","Siwan wai aminda meya takngatu takngatu toitoitde yaman musiane meya nataaingu gata akgatayamunggayak. Gatayami aminu kepdakane nanata gatu waaminu dua pasiwan gwautning. ");
INSERT INTO wnc_vpl VALUES ("PS11_1","020_11_1","PSA","11","1","1","Na Buyambam tapae gepbiatang koyuwawa ita na akgatangamik. Asikaya ga apbotake ba unzingu naninggayak? “Ga tawandakane datakunggayo. Unzing kwaiu gwenduta akgwauke datakunggak bingan.” ");
INSERT INTO wnc_vpl VALUES ("PS11_2","020_11_2","PSA","11","2","2","Dasingge? Wai aminda kweemna mitake sakutna pake aminu noman yuaingu zikaane akusopuke yamnangge tasikaing. ");
INSERT INTO wnc_vpl VALUES ("PS11_3","020_11_3","PSA","11","3","3","Tasike aminu kuupbamda kepi noman taknga gatu dua tasiwanu aminu kepi noman tawake tasinggak kapata dasing siwik? ");
INSERT INTO wnc_vpl VALUES ("PS11_4","020_11_4","PSA","11","4","4","Buyambamtapa yekaune king kapa yuak. Ngan, king kapa yuke aminu kuupbamu kainata akaak. Kake sanga kuupbam tasikaingu usanzikgak. ");
INSERT INTO wnc_vpl VALUES ("PS11_5","020_11_5","PSA","11","5","5","Buyambam tapata aminu noman usanzikgak. Siwan ngana ita inane mama wam sandeke amak tasinangge take siknga nataing aminde asiknga bitanggak. ");
INSERT INTO wnc_vpl VALUES ("PS11_6","020_11_6","PSA","11","6","6","Siwan ita katau toknga siknga aknga wai aminde tukngwayapbimban yasiwik. Sike waiaknga tasikainggane buyana unin. ");
INSERT INTO wnc_vpl VALUES ("PS11_7","020_11_7","PSA","11","7","7","Dasingge? Anututa ina kepi noman takngakan tasinggaunin. Siwan ita kepi noman tawake katak siknga usanzikgak kakngae take siknga nataak. Ge aminu ie wam tawake tasikaingu itane nomna akaning. ");
INSERT INTO wnc_vpl VALUES ("PS12_1","020_12_1","PSA","12","1","1","Buyambam tapa, gata na gatangamuyo. Dasingge, aminu gae gen gwaamukgau tapatu dua yuak. Gatu aminu gae banip singgau tapatu tawamba maik. Siwan gata na dua nandutewi banip dua sikaing aminkat gatake yutnim. ");
INSERT INTO wnc_vpl VALUES ("PS12_2","020_12_2","PSA","12","2","2","Siakan. Aminbamda notna notna kem yanikaing. Ita waaminu kaa wam yanike tanzit pasikaing. ");
INSERT INTO wnc_vpl VALUES ("PS12_3","020_12_3","PSA","12","3","3","Buyambam tapa, gata kaa wam yakainggu, gena umumso. Gatu yamandet aminu kuut gena umumso. ");
INSERT INTO wnc_vpl VALUES ("PS12_4","020_12_4","PSA","12","4","4","Waaminda anzing yakaing, “Ninda wam yake sanga inanatap tasike aminbam yapbitnim. Aminu tapatuta ninu ninindakngananga dua. Wena. Ninu maminda kakuya tasinggak?” ");
INSERT INTO wnc_vpl VALUES ("PS12_5","020_12_5","PSA","12","5","5","Siwan waaminda aminu kekekngana wena amin gatu sangana wena amin yaipakepukaing. Yaipakepuke yanisapduwawa meya pake yuaing. Siwan ngana Buyambam tapata anzing yanggak, “Nata enake aminu meya unzing pakaingu takekan yutningge nata kakuya tasiwit,” ngang yanggak. ");
INSERT INTO wnc_vpl VALUES ("PS12_6","020_12_6","PSA","12","6","6","Buyambam tapatane wamu kuupbam siakan gan. Itane wamu take siknga, unzing suu gwendu silwa ngang yanikaingu katap gwene tapduu katau kuutmusa gatu kautdu gweyaa ngang sawan dopna wena siknga singgak binga. ");
INSERT INTO wnc_vpl VALUES ("PS12_7","020_12_7","PSA","12","7","7","Buyambam tapa, ninu kakuya katak pasiyo. Ninu kakuya asinggan katak pasiyo. Asinggan asinggan gata pasiwawi wai aminda ninu dua pasiwan mainim. ");
INSERT INTO wnc_vpl VALUES ("PS12_8","020_12_8","PSA","12","8","8","Dasingge, tapduu aminu kuupbamda sanga waiakngae natapan takekan siwanu wai aminda tendeknga wena yamandet sike kepi kepi sukuke tawamban sandekgak. ");
INSERT INTO wnc_vpl VALUES ("PS13_1","020_13_1","PSA","13","1","1","Buyambam tapa, zaapduknga gata nae gatuka natapsa? Asikaya gata nae asinggan asinggan apbotanggayak, ba dasing? Tapduu zagwene na nandutewi gatane nomba takusopunggayau gatu gandupit? ");
INSERT INTO wnc_vpl VALUES ("PS13_2","020_13_2","PSA","13","2","2","Tapduu zagwene gata meya nata musipmaatangu gwaamukgat taknga sandekngamuya? Kwakngaom ba zikaa datdasing siwana musipmaatang meya nataau yuwik? Tapduu zagwene gata gatangami na iwande gepbiatang yuwau teke gatu dua yuwit? ");
INSERT INTO wnc_vpl VALUES ("PS13_3","020_13_3","PSA","13","3","3","Buyambam tapa, ga natane Anutuna. Ga nae asiknga natanggamatake natane tumuk wamae natapso. Natake gata gatangami nata dua kupit. ");
INSERT INTO wnc_vpl VALUES ("PS13_4","020_13_4","PSA","13","4","4","Gatangami dua kupa kake iwanata anzingu dua yaning, “Ninda i gwa yapbikamang,” ngangu dua yaning. Aho, iwanata dua yake nata pimambitde dua baknganing. ");
INSERT INTO wnc_vpl VALUES ("PS13_5","020_13_5","PSA","13","5","5","Siwan ngana gata musip kwikwiu nae asinggan natangamuya ngangu atnataat. Siwan gata na gatuka tapi take yuatde apbaknganggat. ");
INSERT INTO wnc_vpl VALUES ("PS13_6","020_13_6","PSA","13","6","6","Ngan, nata kau Buyambam tapatane umana yatangenatnanggengu ataiwit. Dasingge, ita nae take siknga tasingamukut. ");
INSERT INTO wnc_vpl VALUES ("PS14_1","020_14_1","PSA","14","1","1","Katum aminu natdetdetna wena aminda inae anzing yakaing, “Anutu dua yuak,” ngang yakaing. Aminu waakwau wai amin siknga. Waaminda sanga wai siknga takngakan tasikaing. Waaminkat nana tapatuta sanga nomanu takngatu dua tasinggak. ");
INSERT INTO wnc_vpl VALUES ("PS14_2","020_14_2","PSA","14","2","2","Buyambam tapata yekaune yuke aminu kuupbamde pakepusang ninduak. Ninduke aminu natdetdeu noman pake Anutue tawakaing aminde yawanggak. ");
INSERT INTO wnc_vpl VALUES ("PS14_3","020_14_3","PSA","14","3","3","Siwan ita waaminde yawanggak ngana wena kaak. Kuupbamda kepi noman taknga gwa teking. Aminu wai siknga. Aminu tapatuta sanga nomanu takngatu dua tasinggak. Wena siknga. ");
INSERT INTO wnc_vpl VALUES ("PS14_4","020_14_4","PSA","14","4","4","Aminu wa waiaknga tasikaingu sanga nomana akngae dua ba natdetning? Waaminda poyak napan puyukgak binga natane aminabamu zipa puyukgak. Siwan Buyambam tapata gatayaman waiaknga teningge tumuk wampaa dua inikaing. ");
INSERT INTO wnc_vpl VALUES ("PS14_5","020_14_5","PSA","14","5","5","Tumuk wamu dua inikengu waaminu asiknga gwautning. Dasingge, Anutu inane wam natake tawakaing aminkat gatake yuak. ");
INSERT INTO wnc_vpl VALUES ("PS14_6","020_14_6","PSA","14","6","6","Sike ginu wai aminda sangana wena amindane kepi umukusike tasiwan meya buyak yuaing. Siwan ngana Buyambam tapata sangana wena. Waaminu kakuya tasinggak. ");
INSERT INTO wnc_vpl VALUES ("PS14_7","020_14_7","PSA","14","7","7","Siwan Anututa Saion nana aminu tapatu initewan apu Isrel nana gatu papan takekan yutningge take siknga nataat. Tapduu Buyambam tapata aminabam gatayaman take yutning komune aminu Jakopdane dongune nana apbaknganong. Ngan, Isrel nanata musipgwaang siknga natake yutnong. ");
INSERT INTO wnc_vpl VALUES ("PS15_1","020_15_1","PSA","15","1","1","Buyambam tapa, mamin amin tapata gae yotda buyambam gwene koke yuwik? Ngan, mamin amin tapata gikane tawanu Saion dakane pakuyuwik? ");
INSERT INTO wnc_vpl VALUES ("PS15_2","020_15_2","PSA","15","2","2","Aminu tapatuta kepi nomana aknga asinggan tasiwik. Tasike gatu siakan wamu asinggan yake tasinggak kapata gae yotdane yuwik. ");
INSERT INTO wnc_vpl VALUES ("PS15_3","020_15_3","PSA","15","3","3","Siwan ita aminu kundutane umana takeaknga dua yaipapaakusinggak. Ita notnae wai takngatu dua tasiyamunggak. Siwan ita sapdut wam yawan natakge dua yanggak. ");
INSERT INTO wnc_vpl VALUES ("PS15_4","020_15_4","PSA","15","4","4","Sike waapata aminu Anututa masa yamukut aminde apbitanggak. Bitake ita aminu Anututane wamna natake tawakaing kaknga yakapan apbaknganing. Siwan ita wamu ina yanggak kaknga atasinggak. Tasiyuuk meya ie apan kakengu ita nangaakan dua natapik. ");
INSERT INTO wnc_vpl VALUES ("PS15_5","020_15_5","PSA","15","5","5","Siwan ita kapewan aminu kunduta apu sanga moo yamikge iniwanu ayamunggak. Ge yake pakapu imanu sikopnae dua yaniwan imukaing. Siwan aminu tapatuta aminu gutongana wena apae kot yakut. Yawan aminu wa yake pakapu imanu sikopnae dua yanikut tapata moning pake gutongana wena apa kautde moo tewikge inindatdauwan mainggak. Siwan aminu tapatuta kepi waaknga tawambiu dua pimapik. ");
INSERT INTO wnc_vpl VALUES ("PS16_1","020_16_1","PSA","16","1","1","Anutu, gata na nanduyuwawi nata take yuwit. Dasingge, iwanata na dua nuwan maiwitde nata gatane gepbiatang koke yuat. ");
INSERT INTO wnc_vpl VALUES ("PS16_2","020_16_2","PSA","16","2","2","Nata Buyambam tapae anzing inikum, “Ga natane Buyambam tapana. Sanga nomana nata pake yuwau kuupbam gae kataunetakan apukaing,” ngang inikum. ");
INSERT INTO wnc_vpl VALUES ("PS16_3","020_16_3","PSA","16","3","3","Sike aminu Anututanen, kuupbam take siknga. Na waaminde asiknga baknganggat. ");
INSERT INTO wnc_vpl VALUES ("PS16_4","020_16_4","PSA","16","4","4","Sike aminu anutu pupuknga apaapae tumuk yaninangge natake isapmake kukaingu meya kwaapzang gwaamutning. Gatu na iat dua gatake yuke amindane daknga anutu pupukngae yamunim. Aho, waamindane anutu pupuknganae umana dua yake tumuk wamu nata ie dua yaniwit. ");
INSERT INTO wnc_vpl VALUES ("PS16_5","020_16_5","PSA","16","5","5","Buyambam tapa, gata sanga take siknga takngatu takngatu nae gwa namukuyak. Nami pake nata take yuat taknga gae kataune yuaunin. ");
INSERT INTO wnc_vpl VALUES ("PS16_6","020_16_6","PSA","16","6","6","Nata sanga nomanomana kuupbamu gae kataunekan panggat. Siakan siknga. Sanga wa kuupbamde iaknga siknga natake ie apbaknganggat. ");
INSERT INTO wnc_vpl VALUES ("PS16_7","020_16_7","PSA","16","7","7","Nata Buyambam tapatane umana yatangenawit. Dasingge, ita na nanindamuke tanomanukgaunin. Ngan, zikaane natdetdet panggat takngata atnanindamukgak. ");
INSERT INTO wnc_vpl VALUES ("PS16_8","020_16_8","PSA","16","8","8","Asingganu Buyambam tapata nae wesim yuak ngang nataat. Ita wesim yuke nae kekeknga atnamunggak. Unzingge na aminu tapatuta dua tasiwan gwauke dandana yamutning. ");
INSERT INTO wnc_vpl VALUES ("PS16_9","020_16_9","PSA","16","9","9","Unzingge musipmane natapa take siknga singgak. Siwan natane waung ngaaya asiknga baknganggak. Unzing na mateknga simpaa sanga tapatue dua gwaumbit. ");
INSERT INTO wnc_vpl VALUES ("PS16_10","020_16_10","PSA","16","10","10","Dasingge, gata na dua nandutewi aminu gwa kupsa amindane kep komune paku yuwit. Aho, gata dua nandutewi na aminu gikane matmaune yuke kapanga siwit. ");
INSERT INTO wnc_vpl VALUES ("PS16_11","020_16_11","PSA","16","11","11","Gata gika kepi kayuk take yutnanga aknga nae yeikngamukuyak. Gata nae wesim yuwi na kumzang siknga bakngawit. Gata wesim yuke gatangami natane musipmaatangu asinggan asinggan bakngawit. ");
INSERT INTO wnc_vpl VALUES ("PS17_1","020_17_1","PSA","17","1","1","Buyambam tapa, nata gae yanggawanggatde natapso. Nata aminu gutonga aknga tawake temapa naniwan maiwikge ganinggat. Tumuk wamu nata kemu dua ganinggat. Unzingge gata maak pangamiyakge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS17_2","020_17_2","PSA","17","2","2","Gata gatangami nata wamyak gwene wamu yawiu ayapbimbit. Dasingge, gata yuyuu noman takngaenu katak siknga atnataayak. ");
INSERT INTO wnc_vpl VALUES ("PS17_3","020_17_3","PSA","17","3","3","Gata natane musipmaatang nataat taknga atnataayak. Natake gata zikaane apu nata natdetdetnane nataat taknga usanzike tasinggayak. Tasiwi siwan sanga wai takngatu kawi maiwik. Dasingge, natdetdeu gutonga takngatu musipmaatangu dua natake yuat. ");
INSERT INTO wnc_vpl VALUES ("PS17_4","020_17_4","PSA","17","4","4","Nata wamu wai takngatu aminu kunduta yakaing binga genaneta dua yanggat. Wena siknga. Nata gatane wamu kekeknga take wamu wai takngatu dua siknga yanggawanggat. Siwan aminu amin kundu zipa kumningge nataaing amindane kepie masa yamunggat. ");
INSERT INTO wnc_vpl VALUES ("PS17_5","020_17_5","PSA","17","5","5","Asingganu nata gatane kepi aknganekan sukunggat. Sukuke natane kepina kepi gwatdu kunangge songu dua yaikum. ");
INSERT INTO wnc_vpl VALUES ("PS17_6","020_17_6","PSA","17","6","6","Anutu, gata natane tumuk wama yanggatde natake akgatangamuyo. Unzingge nata tumuu gae yanggat. Gata maak pake natane tumuk wammae natapso. ");
INSERT INTO wnc_vpl VALUES ("PS17_7","020_17_7","PSA","17","7","7","Anutu, ga nindane gatakgatak kapanin, gikane musip kwikwiu buyambam takngaka ninde yeutnimuyo. Gata aminu gae wesim yuke iwanae akusopukaingu, gatuka papi take yutning. ");
INSERT INTO wnc_vpl VALUES ("PS17_8","020_17_8","PSA","17","8","8","Na gikane kaikata kakuya noman siknga tasinggak binga nakaya unzakan tasiyo. Na taakga mateknga piatang kopa usikwatapmanggak binga takusopuyo. ");
INSERT INTO wnc_vpl VALUES ("PS17_9","020_17_9","PSA","17","9","9","Takusopuwawi wai aminda nae iwana siknga dakngake na nuwa kupitde natake na umupbasitnawawa kake gata na usikwatapi waaminda na dua tasiwa maiwit. ");
INSERT INTO wnc_vpl VALUES ("PS17_10","020_17_10","PSA","17","10","10","Waamindane musipna zikaa siwan aminu kundue take dua natayamukaing. Dua natayamuke nindane umaninu kopsa ngang natake yamandet wam yakaing. ");
INSERT INTO wnc_vpl VALUES ("PS17_11","020_17_11","PSA","17","11","11","Waaminda natane kepi tanga kake na nawake nanduke umupbasitnawakaing. Umupbasitnawake na kumzang nanduyake na tanggaganuke kepdakane yaitakepukaing. ");
INSERT INTO wnc_vpl VALUES ("PS17_12","020_17_12","PSA","17","12","12","Waaminu kaap zongu laionda tomna natake kaapna zipnangge tasinggak binga. Ngan, waaminu laionda muna puke kusopuke kayuak binga. ");
INSERT INTO wnc_vpl VALUES ("PS17_13","020_17_13","PSA","17","13","13","Buyambam tapa, gata apu natane iwanaat amake waaminu yaipakepso. Gata amakgane bainatda take waaminkat amake na wai amindane kataune sandeke tapso. ");
INSERT INTO wnc_vpl VALUES ("PS17_14","020_17_14","PSA","17","14","14","Siakan, Buyambam tapa, gata na gikane kekekngakaneta gatangamuyo. Siwan na waaminda dua tasiwan maiwit. Sike waaminda sanga kepdakane nanakan papan dopan yuaing. Waamindane kekeknganane sandeke tapso. Siwan aminu gata musip gwaang natayamunggayak aminu tomna natapning, ngana gata gatayami tomna wena siwik. Tomna wena siwan waamindane waatdakanata sangae dua dapmake yutning. Dua dapmake yuke waakwakgane bapuna masan aatning aminu sangae dua dapmake yutning. ");
INSERT INTO wnc_vpl VALUES ("PS17_15","020_17_15","PSA","17","15","15","Siwan gata na katak usanzike nandupi noman siwik. Noman siwan, nata gatane nomba masande asiknga gandupit. Ngan, tapduknga nata kungwake dapuna binga pesika gatuna enawit komune nata natapa ga naat gatake yuamak ngang natake na apbakngawit. ");
INSERT INTO wnc_vpl VALUES ("PS18_1","020_18_1","PSA","18","1","1","Anutu, na gae banip gwaang siknga nataat. Gata na atapi kekekanggat. ");
INSERT INTO wnc_vpl VALUES ("PS18_2","020_18_2","PSA","18","2","2","Buyambam tapana damanu kekeknga gwenu unin. Sike i suu gwenduta binga, na takusopunggak. Sike ita na iwanae katune sandeke tanggak kapanin. Sike natane Anutuna suu kekeknga gwendu binga, nata ie kuke iwanae akusopunggat. Buyambam tapana tiunggu daka binga, ita na iwanae atakusopunggak. Siwan na inane kekeknga akngane sandeke tapan na kekeknga yuat. Sike i natane damanu kekeknga gwena unin. ");
INSERT INTO wnc_vpl VALUES ("PS18_3","020_18_3","PSA","18","3","3","Buyambam tapatane umana kopsa aknga unin. Nata ie tumuk wam iniwa gatangaman natane iwanata dua tasiwan maiwit. ");
INSERT INTO wnc_vpl VALUES ("PS18_4","020_18_4","PSA","18","4","4","Na akupitde wesimu asikum. Sike wa nau takngatuta binga kekeknga wamanggaganuwan yukum. Siwan wai aminda na nuwa maiwitde kumzang tasikaing. Gatu wa tasikaingu yanggabam gwendane sambuyata binga enake na usukwatapik. ");
INSERT INTO wnc_vpl VALUES ("PS18_5","020_18_5","PSA","18","5","5","Ngan, nau takngatuta binga kekeknga wamanggaganuwan nata kupitde wesim sikum. Ngan, bungep pasike kaap zong pakaing binga na nuwan kupitde dapaknga siwan datakunanga dua sikum. ");
INSERT INTO wnc_vpl VALUES ("PS18_6","020_18_6","PSA","18","6","6","Na meya waakwak natake Buyambam tapae sitawakum. Na Anutunata akgatangamikge natake nata ie tumuk wam inikum. Ita inane yotna buyambam gwene yuke natane tumuk wama natapbut. Ngan, ita natane tumuk wama maakngata natapbut. ");
INSERT INTO wnc_vpl VALUES ("PS18_7","020_18_7","PSA","18","7","7","Siwan, Buyambam tapata musia toknga natane iwanae natapbut. Natapan miamunu buyambam siawan, tawan dakandaka ama yapiatangu ayamuke yuking. ");
INSERT INTO wnc_vpl VALUES ("PS18_8","020_18_8","PSA","18","8","8","Ngan, musia toknga natapan kupan taknga Buyambam tapatane nomna ganang epuwawan gatu katau genaatangga akoke sangabamu kwaapzang yasiking. Ngan, ita musia toknga natake tasiwan katapaimu mumuyang buyak genaneta epu kuking. ");
INSERT INTO wnc_vpl VALUES ("PS18_9","020_18_9","PSA","18","9","9","Ita minga musa kwasiwan kuwan yekau teke epuke minga zikaa musa tasiwan inane kepinae gepbiatang yukut. ");
INSERT INTO wnc_vpl VALUES ("PS18_10","020_18_10","PSA","18","10","10","Unzing angela tapatuta binga gwaamuke bepmake apbut. Sike wa apunggau got taknga kwaitdane pia kaamangga binga Anutu masene teke zeetgaman bepmake takapbut. ");
INSERT INTO wnc_vpl VALUES ("PS18_11","020_18_11","PSA","18","11","11","Ita tasiwan zikaandaka sel you gwendu binga dakngawan undang kusopukut. Ngan, sopatane minga zikaa kaamang bingata takusopukut. ");
INSERT INTO wnc_vpl VALUES ("PS18_12","020_18_12","PSA","18","12","12","Siwana undangga kakaa siknga aknga sikut. Siwan minga musaatangga kakaa aknga uneta epbing. Epuwawa yapasikga asiwawan gatu zambum mupewan epbing. ");
INSERT INTO wnc_vpl VALUES ("PS18_13","020_18_13","PSA","18","13","13","Buyambamtapa yekaune yuke gakngatda binga kaapmapa kumzang yakut. Ngan, waapa kopsa siknga apata kaapmapa wamna yakapan aminu kepna kepna nana kuupbamda atnatapbing. ");
INSERT INTO wnc_vpl VALUES ("PS18_14","020_18_14","PSA","18","14","14","Ita sakutda yamawawan iwana gwatdu gwatdu datakuking. Ngan, ita tasiwan yapasiu kekeknga siknga sakutna dakngawan iwana yamnangge pasiwan gwatdu gwatdu datakuking. ");
INSERT INTO wnc_vpl VALUES ("PS18_15","020_18_15","PSA","18","15","15","Buyambam tapa, gata iwandae kaanga yanike nombata tasiwi gou kekeknga puyawawan yanggabam gwenu ikopewan pimaking. Ikopewan pimapan keu yanggabam amunane kutakngi yuak kaknga anggaman sikut. Sike yanggabam gwenu gatukande zakngakut. Zakngawan sanga kundu kepdaka tapan kekekanggau kakaa siking. ");
INSERT INTO wnc_vpl VALUES ("PS18_16","020_18_16","PSA","18","16","16","Ita yekaune yuke kataknga tewan epan na gatuna takut. Na yanggabam gwenda asusukwatapan ngana ita na akaiwan akopbum. ");
INSERT INTO wnc_vpl VALUES ("PS18_17","020_18_17","PSA","18","17","17","Natane iwana kekeknga siknga. Ge nata yapbitnanga dua. Siwan ngana Buyambam tapata na iwanae kataune sandeke takut. ");
INSERT INTO wnc_vpl VALUES ("PS18_18","020_18_18","PSA","18","18","18","Ngan, nata tapduu wai yukum komune iwanata nae apu amak tasiking. Siwan ngana Buyambam tapata na akgatangamukut. ");
INSERT INTO wnc_vpl VALUES ("PS18_19","020_18_19","PSA","18","19","19","Ita gatangamuke nanitakuwan nata keu aanggaman komune take yukum. Sanga gwautnanga aknga wena sikut. Dasingge, ita nae musip gwaang natangamuke na gatuna takut. ");
INSERT INTO wnc_vpl VALUES ("PS18_20","020_18_20","PSA","18","20","20","Nata gutonga takngatu dua tasiwa nanduke Anututa naenu take tasikut. Ngan, nata kepi noman taknga tawamba nanduke Buyambam tapata sanga gwaamu kwaapzang namukut. ");
INSERT INTO wnc_vpl VALUES ("PS18_21","020_18_21","PSA","18","21","21","Nata Buyambam tapatane mama wamu take tawakum. Nata Anutunae masa dua imukum. Aho, wai waaknga dua tasikum. ");
INSERT INTO wnc_vpl VALUES ("PS18_22","020_18_22","PSA","18","22","22","Ngan, nata asinggan itane mama wamdekan natanggamatakum. Siwan nata itane wamu take akngae yamandeu dua sikum. ");
INSERT INTO wnc_vpl VALUES ("PS18_23","020_18_23","PSA","18","23","23","Unzingge ita atnataak. Na ie gutonga takngatu wena. Nata kepi sukukumu katak siknga tanggwaukum. Gutonga takngatu tasiat nganggen. ");
INSERT INTO wnc_vpl VALUES ("PS18_24","020_18_24","PSA","18","24","24","Buyambam tapata natane noman taknganae natayukut. Natangamuke yake yuyuu take aknga namukut. Minae, nata ie kaine dundumna yukum. ");
INSERT INTO wnc_vpl VALUES ("PS18_25","020_18_25","PSA","18","25","25","Buyambam tapa, aminu tapatuta masa gae dua gamanu gakaa yake gata masa dua imiyak. Sike aminu tapatuta noman takngakan tawake tasike gutonga takngatu dua tasiwanu, gataaya yake ie noman takngakan tasingamunggayak. ");
INSERT INTO wnc_vpl VALUES ("PS18_26","020_18_26","PSA","18","26","26","Sike aminu tapatuta noman akngaekan ba tawambanu, gata noman taknga yake tasinggamuya. Siwan ngana aminu tapatuta gutonga aknga tawake tasiwanu, gata kepi waakngae yapii katak siknga kake yake meya aknga asiimunggayak. ");
INSERT INTO wnc_vpl VALUES ("PS18_27","020_18_27","PSA","18","27","27","Gata aminu ninu kopsa amin dua dakngake yuamang ngang yakaing aminu apanggayak. Sike kundu ninu kopsa amin dakngake yuamang ngang yake umana yapangenakaing aminu, gata umana ayaipakepunggayak. ");
INSERT INTO wnc_vpl VALUES ("PS18_28","020_18_28","PSA","18","28","28","Buyambam tapa, gata kakaa aknga namunggayak. Ngan, Anututa zikaa naatang yuak kaknga atawamban kunggak. ");
INSERT INTO wnc_vpl VALUES ("PS18_29","020_18_29","PSA","18","29","29","Anutu, gata akgatangaminu nata amak tasike iwana ayaipakepu pewit. Ngan, Anututa kekeknga namanu nata damanu yot gapma takumbasikuu ayatupit. ");
INSERT INTO wnc_vpl VALUES ("PS18_30","020_18_30","PSA","18","30","30","Anututane yuyuknga aknga take siknga siwan noman gan. Sike ita sanga takngatu tasinangge yanggau, siakan gan siknga yanggak. Gatu Buyambamtapa tiunggu amak tasiya daka binga. Ita aminu ie kukaingu akgatayamuke iwanata dua kaningge apakusopunggak. ");
INSERT INTO wnc_vpl VALUES ("PS18_31","020_18_31","PSA","18","31","31","Buyambam tapakan i Anutu siknga. Asikaya Anutu tapatuat ba dasing? Ita ninu suu buyambam gwenduta binga wamambasinggak. ");
INSERT INTO wnc_vpl VALUES ("PS18_32","020_18_32","PSA","18","32","32","Anututakan tasiwan na kekeknga yuat. Gatu ita kepi sukunggau kuut gatangamuke nanduyuawan kepi noman akngane sukunggat. ");
INSERT INTO wnc_vpl VALUES ("PS18_33","020_18_33","PSA","18","33","33","Ita katak siknga nanduyuwawan na dua pimanggat. Unzing kaap zongga tawan dakandakaatang sukuke kepi katak kake sukuaing binga. ");
INSERT INTO wnc_vpl VALUES ("PS18_34","020_18_34","PSA","18","34","34","Gatu ita amak tasinanga akngae nanindamukgak. Unzing tasiwan kataknga kekeknga siwana kweemu kekeknga siknga kaiwa dandakawik. ");
INSERT INTO wnc_vpl VALUES ("PS18_35","020_18_35","PSA","18","35","35","Buyambam tapa, gata na gatangami nata tiunggu take iwana ayapbimbit. Unzing gata iwanda ayapbikgayak. Gata katakga siaapane tapi kekeknga yuat. Siakan, gata na gatangami aminu kuupbamde kaine umana kaapa dakngake yuat. ");
INSERT INTO wnc_vpl VALUES ("PS18_36","020_18_36","PSA","18","36","36","Gata kepi nata sukunggat tapa tanomanuwi kepi waapane kuke saweknga dua nuwan pimanggat. ");
INSERT INTO wnc_vpl VALUES ("PS18_37","020_18_37","PSA","18","37","37","Siwan nata iwana zipnangge yawake panggagunukum. Sike iwana waakwau atzipa kumbing. Nata kuutgan zipa puyuwan iwana tapatu wena kakenga teke yotna kukum. ");
INSERT INTO wnc_vpl VALUES ("PS18_38","020_18_38","PSA","18","38","38","Ngan, nata kuutgan zipa kepinae gepbiatang pimake kuupbam dua enaking. ");
INSERT INTO wnc_vpl VALUES ("PS18_39","020_18_39","PSA","18","39","39","Gata kekeknga amak tasiwitde namukuyak. Sike gata iwana nae kataune pewi nata waaminu ayapbikum. ");
INSERT INTO wnc_vpl VALUES ("PS18_40","020_18_40","PSA","18","40","40","Gata pasiwi natane iwana mase nae namuking. Siwan ngana nae kaanga nataaingge apasiwa maiking. ");
INSERT INTO wnc_vpl VALUES ("PS18_41","020_18_41","PSA","18","41","41","Waakwakga notnae yawa apu gatayamuningge yawan ngana aminu tapatu undang dua yukut. Ita Buyambam tapae yawa apu gatayamikge yawan ngana ie dua natapbut. ");
INSERT INTO wnc_vpl VALUES ("PS18_42","020_18_42","PSA","18","42","42","Nata pasiwa gatukande muyuu gotda apu puyapan kukaing binga dakngaking. Nata yanikwasiwa iwana ngwaik kanzangu mupewa kukaing binga dakngake moo yuking. ");
INSERT INTO wnc_vpl VALUES ("PS18_43","020_18_43","PSA","18","43","43","Siwan ngana tapduu aminu kundu natane dongune nanata nutnangge tasiking komune gata gatangami na dua tasiwa maikum. Gata nandutewi yamandet aminu dongu takngatutane tupan amintapa dakngake aminu kayuat. Sike aminu kundu nata dua nataau, apmanu nae gepbiatang koyuaing. ");
INSERT INTO wnc_vpl VALUES ("PS18_44","020_18_44","PSA","18","44","44","Aminu kunduta kepna kepna nana aminda natane umana kopsa akngae natake natane wama gwaamuke nae gwauke munu kuut nae pukaing. ");
INSERT INTO wnc_vpl VALUES ("PS18_45","020_18_45","PSA","18","45","45","Puke kekekngana wena siwan ita yotbamdane damanu kekeknga siknga gwen gwen peke yamuyamuiike nae apukaing. ");
INSERT INTO wnc_vpl VALUES ("PS18_46","020_18_46","PSA","18","46","46","Buyambamtapa asinggan yuwawik. Ita suu buyambam gwenduta binga na wamambasiwik. Wamambasike na tapan take yuwit. Unzingge ninda itane umana yatangenatnim. ");
INSERT INTO wnc_vpl VALUES ("PS18_47","020_18_47","PSA","18","47","47","Anututa waiaknga nae tasikaingu iwanae yake meya yamukut. Siwan ita aminu dongu kepna kepna nana nae gepbiatang yutningge pewan yuking. ");
INSERT INTO wnc_vpl VALUES ("PS18_48","020_18_48","PSA","18","48","48","Siwan ita na iwande kataune sandeke takut. Siakan siknga Buyambam tapa, gata nae umana kopsa aknga iwanatane kaine namukuyak. Gata gatangami aminu amak tasikaingga na dua nuwan kumbum. ");
INSERT INTO wnc_vpl VALUES ("PS18_49","020_18_49","PSA","18","49","49","Unzingge Buyambam tapa, nata gatane umanda aminu takngatu takngatue banakan yuke yatangenawit. Siwan nata kau takngatui kuut taike umanda yatangenawit. ");
INSERT INTO wnc_vpl VALUES ("PS18_50","020_18_50","PSA","18","50","50","Buyambam tapata na, Devit, King kapa dakngawitde yakut. Unzingge asingganu ita tasiwan iwana asiknga yapbikgat. Ita tendeknga wena musip gwaang nae natangamunggak. Ita natane dongu masan aatningu ina unzakan musip gwaang natake gatayamik. ");
INSERT INTO wnc_vpl VALUES ("PS19_1","020_19_1","PSA","19","1","1","Ena kakaa komune nana sangabamu kaamangga Anutu tupan sikngaapa ngang yeutnimukaing. Sanga kuupbamu ena kakaa komune yuaingga puya noman taknga ita tasikut ngang yeutnimukaing. ");
INSERT INTO wnc_vpl VALUES ("PS19_2","020_19_2","PSA","19","2","2","Siwan tapduk bamu sanga waakwakga ie atninikapmakaing. Siwan gatu zikaane kuut natdetdeu kekeknga yeutnimukaing. ");
INSERT INTO wnc_vpl VALUES ("PS19_3","020_19_3","PSA","19","3","3","Sike aminu kepna kepna nana aminda wamu inata inata yakaing ngana sanga waakngatane wamu aminu kuupbamda atnataaing. ");
INSERT INTO wnc_vpl VALUES ("PS19_4","020_19_4","PSA","19","4","4","Siwan sanga waakngaatdane wamu yotna yotna kuupbam tawamban sandekgak. Ngan, wamna waakngata kepna kepna kuupbam tawamban sandekgak. Sike ena kakaa komune Anututa sel you gwendu gunzitde mitapbut. ");
INSERT INTO wnc_vpl VALUES ("PS19_5","020_19_5","PSA","19","5","5","Gunzitda kepmanu aminda maatna tanangge apbakngake yotna teke epu kunggak binga epu kunggak. Epuke inane kepinane kunggak. Unzing aminu asisapnangge tandakngake apbaknganggak binga. ");
INSERT INTO wnc_vpl VALUES ("PS19_6","020_19_6","PSA","19","6","6","Gunzitda ena kakaa komu kwaimune kuke uneta kautdu saak kunggak. Siwan sanga tapatuta itane tokngana akngae kusopunanga dua. ");
INSERT INTO wnc_vpl VALUES ("PS19_7","020_19_7","PSA","19","7","7","Mama wamu Buyambam tapatane taknga noman siknga. Siwan Buyambam tapatane wamda ninde banip tangenakgak. Siwan ninu mama wamu Buyambam tapatane takngae banip siknga sikamang. Sike ita natdetdeu nomanu aminu natdetdetna matekngae ayamunggak. ");
INSERT INTO wnc_vpl VALUES ("PS19_8","020_19_8","PSA","19","8","8","Buyambam tapatane mama wamu nomana siknga. Siwan wamu waakngata nindane musipmin pangenawan apbakngakamang. Siwan Buyambam tapatane mama wamu kakaa aknga binga. Ita gataniman katak kaamang. ");
INSERT INTO wnc_vpl VALUES ("PS19_9","020_19_9","PSA","19","9","9","Siwan aminu tapatuta ie munu puke ininggau ita kepi noman takngakan tasinggak. Tasiwawan kepi nomanu waaknga asinggan asinggan yuwik. Ngan. Ita mama wamu kuupbam tasinimde nininggau wamu waaknga siakan siwan noman siknga. ");
INSERT INTO wnc_vpl VALUES ("PS19_10","020_19_10","PSA","19","10","10","Siwan golmanitane buyana buyambam siknga. Siwan ngana Buyambam tapatane mama wamda golmani ayapbikgak. Siwan hani kaaya siknga. Siwan ngana itane mama wamda hani ayapbikgak. ");
INSERT INTO wnc_vpl VALUES ("PS19_11","020_19_11","PSA","19","11","11","Mama wamu gatane akngata na gikane puya amindae gwaut wam naninggak. Naniwan natake nata gatane mama wamba tawanggatde gata natane yuyuknga tasiwi take siknga singgak. ");
INSERT INTO wnc_vpl VALUES ("PS19_12","020_19_12","PSA","19","12","12","Siwan ngana maminda inane gutonganae kuupbam nataak? Na gutonga kundu tasikumde apbotake na ie dua nataat. Unzingge gata natane gutonga waakngana sandeke tasiwi na gae kaikane dundumna siwit. ");
INSERT INTO wnc_vpl VALUES ("PS19_13","020_19_13","PSA","19","13","13","Na gatane puya aminda. Ge gata na kakuya katak siknga nanduyuwi nata waiaknga dua tasiwit. Gata waiaknga dua katewi na nanduyuwik. Unzingge nata noman yuke gutonga buyambamu takngatu dua tasiwit. ");
INSERT INTO wnc_vpl VALUES ("PS19_14","020_19_14","PSA","19","14","14","Natane wama gatu natane natdetdetna gae kaikane take siwik ngang nataat. Buyambam tapa, natane keu akusopunanga komu ga siwan akgatangamunggayak kapa ga. ");
INSERT INTO wnc_vpl VALUES ("PS20_1","020_20_1","PSA","20","1","1","Tapduu gwendune ga King kapata musipbaatang meya natapinu, Buyambam tapata akgatanggamikge nataamang. Jekopdane Anutunata apme ganduyuwik. ");
INSERT INTO wnc_vpl VALUES ("PS20_2","020_20_2","PSA","20","2","2","Sike ita yot takwana Saion yuak gapmaneta ga gatanggamuke kekekanggamikge nataamang. ");
INSERT INTO wnc_vpl VALUES ("PS20_3","020_20_3","PSA","20","3","3","Ninda sanga take siknga ita ie imuking kakngae take natapikge nataamang. Ngan, sanga ginda ie imunangge natake katap gwene sayae take natapikge nataamang. ");
INSERT INTO wnc_vpl VALUES ("PS20_4","020_20_4","PSA","20","4","4","Sike Anututa sangabamu gata nataau, akgamikge take nataamang. Ngan, nata puyambamu gata tasinangge natapiyau ita gatanggaman tasiwiyakge nataamang. ");
INSERT INTO wnc_vpl VALUES ("PS20_5","020_20_5","PSA","20","5","5","Unzingge gata amak tasike gwa yapbimbinu, ninda wa yapbimbiakgengu ninda apbaknganim. Apbakngake Anututane umana aknga enane siknga yatangenatnim. Siwan ninda take Buyambam tapata gatane tumuk wambae kuupbam natake unzing gatanggamikge nataamang. ");
INSERT INTO wnc_vpl VALUES ("PS20_6","020_20_6","PSA","20","6","6","Apmanu na gwa nataat. Buyambam tapata aminu Kingu ina yawan yukut tapa gatuna gatangaman take yuak. Ita yot takwana yekap komune yuke tumuk wamu King kapata ininggau atnataak. Natake itane kekeknga akngane gatangaman amau tasike yapbikgak. ");
INSERT INTO wnc_vpl VALUES ("PS20_7","020_20_7","PSA","20","7","7","Aminu kundu amak amnangge natake sanga pake amak kekeknga siknga amakaingu umana karis ngang yanikaingge banip takaing. Siwan kundu amak kumzang siknga amnangge natake hos gwegwen pake amakaingge banip takaing. Siwan ngana ninu Anutu, Buyambam tapanindane umana aknganae banip takamang. ");
INSERT INTO wnc_vpl VALUES ("PS20_8","020_20_8","PSA","20","8","8","Sike aminu waakwau apimake wena siknga sining. Siwan ngana ninu asenake kekeknga yutnim. ");
INSERT INTO wnc_vpl VALUES ("PS20_9","020_20_9","PSA","20","9","9","Buyambam tapa, gata nindane King kapaninu gatangami iwana yapbunzok. Ninda tumuk wamu gae yananu gata akgatanimuyo. ");
INSERT INTO wnc_vpl VALUES ("PS21_1","020_21_1","PSA","21","1","1","Buyambam tapa, King kapa gata kekeknga imukuyakge gae apbaknganggak. Ita amak tasiwan gata gatangami iwana ayapbikgakge gae asiknga baknganggak. ");
INSERT INTO wnc_vpl VALUES ("PS21_2","020_21_2","PSA","21","2","2","Sanga ita musiaatang take nataau gata gwa imukuyak. Ngan, sangae ganikuu dua kotnake gwa imukuyak. ");
INSERT INTO wnc_vpl VALUES ("PS21_3","020_21_3","PSA","21","3","3","Ita gae apan gata gaak wam inike sanga take siknga aknga imukuyak. Sanga imuke ita King dakngawikge natake gata Kinggane kupna gwaam siknga golmonita tasiya gwapakngane gwapungamukuyak. ");
INSERT INTO wnc_vpl VALUES ("PS21_4","020_21_4","PSA","21","4","4","Ita kayuk yutnanga akngae ganiwan gata asiimukuyak. Siwan kayuk yutnanga waaknga tasiwi mamaya siknga asinggan yuwik. ");
INSERT INTO wnc_vpl VALUES ("PS21_5","020_21_5","PSA","21","5","5","Gata gatangami ita iwana kuupbam yapbike umana enane siknga kopsa apa dakngake yuak. Ngan, gata umana kopsa takngaat gatu kekeknga akngaat gata gika imukuyak. ");
INSERT INTO wnc_vpl VALUES ("PS21_6","020_21_6","PSA","21","6","6","Gata ie take siknga tasingamunggayak. Siwan siakan siknga, gata unzingu asinggan asinggan tasinggayak. Ga iat gatake wesim yuwawi musia tatanga siknga singgak. ");
INSERT INTO wnc_vpl VALUES ("PS21_7","020_21_7","PSA","21","7","7","Siwan kingu waapata Buyambam tapae banip tanggak. Anutu enane siknga apata, King kapae musip kwikwiu asinggan natangamuke tasiwan ita kekeknga yuwik. ");
INSERT INTO wnc_vpl VALUES ("PS21_8","020_21_8","PSA","21","8","8","Ngan, ga king kapata iwanda kuupbam panggaganuwiyak. Panggaganuke aminu gae apbitakaing aminu kauutde peya. ");
INSERT INTO wnc_vpl VALUES ("PS21_9","020_21_9","PSA","21","9","9","Gatu ga kakaa komune apukengu gata iwanda pasiwi sopuning. Unzing katapda sangabam yasiwan kungwakaing binga. Siakan, Buyambam tapata musia toknga natayamuke waaminu yaipapaakusike katapda kuupbam sapewan yasining. Unzing aminu tapatuta sanga ngok guyangukgak binga. ");
INSERT INTO wnc_vpl VALUES ("PS21_10","020_21_10","PSA","21","10","10","Siwan ga king kapa, iwandatane waatdakana kuupbam zipi kumning. Ngan, gata wenagom pasiwi waatdaka waakwau keu andakane wena sining. ");
INSERT INTO wnc_vpl VALUES ("PS21_11","020_21_11","PSA","21","11","11","Waaminda natdeu pake gatu wamu yandeke gae wai tasinangge yaning. Siwan ngana waaminda ga gapbitnanga dua siwik. ");
INSERT INTO wnc_vpl VALUES ("PS21_12","020_21_12","PSA","21","12","12","Dasingge, gata sakutdata yamake pasiwi kake atdatakuning. ");
INSERT INTO wnc_vpl VALUES ("PS21_13","020_21_13","PSA","21","13","13","Buyambam tapa, gata kekeknga buyak api umanda buyambam siknga siyok. Siwana ninda kau taike gatane kekeknga akngakae yatangenatnim. ");
INSERT INTO wnc_vpl VALUES ("PS22_1","020_22_1","PSA","22","1","1","Anutuna! Natane Anutuna! Dasingge na napmanggayak? Dasingge gata na dua siknga gatangamunggayak? Dasingge gata kwanamu nata gae sikgat takngae maau dua siknga panggayak? ");
INSERT INTO wnc_vpl VALUES ("PS22_2","020_22_2","PSA","22","2","2","Anutu, nata gae gunzit tapane yanggawanggat. Siwan gatu zikaane kuut yanggawake na dua yuwa takanggak. Siwan ngana gata yake nae wamu dua natanggamunggayak. ");
INSERT INTO wnc_vpl VALUES ("PS22_3","020_22_3","PSA","22","3","3","Siwan ngana, ga dundumna siknga apaunin. Siwan gata tupan siknga apa, enane siknga yuwayaunin. Ge Isrel nana aminda gatane umanda yatangenakaing. ");
INSERT INTO wnc_vpl VALUES ("PS22_4","020_22_4","PSA","22","4","4","Tupa siknga nindane bapuninda gae banip siking. Waaminda gae banip siwa gata papi take yuking. ");
INSERT INTO wnc_vpl VALUES ("PS22_5","020_22_5","PSA","22","5","5","Siwan waaminda gae yanggawawa gata iwande kataune sandeke pakuyak. Waaminda gae banip siknga siking. Siwan gae musiane meya dua natapbing. ");
INSERT INTO wnc_vpl VALUES ("PS22_6","020_22_6","PSA","22","6","6","Siwan ngana na sanga yumdekanu kundu binga yuat. Unzing na gomou mateknga kep ganangkatang yuaing binga yuat. Siwan aminbamda sapdut wam nanike nae masa namukaing. ");
INSERT INTO wnc_vpl VALUES ("PS22_7","020_22_7","PSA","22","7","7","Aminu kuupbamda na nanduke, “Gataaa,” ngang nanimikaing. Waaminda nae yembi tengamuke nanisapduke gwapaknga makaikaing. ");
INSERT INTO wnc_vpl VALUES ("PS22_8","020_22_8","PSA","22","8","8","Siwan waaminda anzing yakaing, “Ita Buyambam tapae baniu asinggakge asikaya Buyambam tapata gatuna tapik? Buyambam tapata ie take nataakge ita apba sandekngaman take siwik,” ngang yakaing. ");
INSERT INTO wnc_vpl VALUES ("PS22_9","020_22_9","PSA","22","9","9","Unzing yakaing ngana, Anutu, gata gika siknga na mingae musip ganang katang tapi aake take apbum. Apa gatangami ngwamu nakum komune kakuya tasikuyak. ");
INSERT INTO wnc_vpl VALUES ("PS22_10","020_22_10","PSA","22","10","10","Na mingata tangaiwan baniu gae sikumuneta apu apman apunggak. Mingata kayuk siknga takuune ga natane Anutuna yukuyak. ");
INSERT INTO wnc_vpl VALUES ("PS22_11","020_22_11","PSA","22","11","11","Sike gata na ma napmambim. Dasingge, meya apmanu nae apukaing. Na aminu gatangamunanga tapatu wena. ");
INSERT INTO wnc_vpl VALUES ("PS22_12","020_22_12","PSA","22","12","12","Sike unzing. Ikwawa gamanu wawi gwengwenda binga na nandusatnake umupbasikaing. Ngan, ikwawa gamanu wawi kekekngana kaya, siwan wa gwengwenu keu Basan komune nanata na umutnawakaing. ");
INSERT INTO wnc_vpl VALUES ("PS22_13","020_22_13","PSA","22","13","13","Sike wa unzing, laion gwengwenda ainggamatake kumzang yayuk kaana wetzukuke na nasinangge natake gena akngakaing. ");
INSERT INTO wnc_vpl VALUES ("PS22_14","020_22_14","PSA","22","14","14","Sike natane kekekngana kuupbam gwa isangepunggak. Unzing yangga moo tukngwamba kuke zakngakaing binga. Siwan kwatanatane ngwaknga ngwakngana kuupbam gwa ziwa yuking. Unzingge natane musipma tuyuknga siknga siwan kekekananga dua. Unzing kaanata puke dauyapmakaing binga. ");
INSERT INTO wnc_vpl VALUES ("PS22_15","020_22_15","PSA","22","15","15","Sike natane kekeknga akngana gwa isangepunggak. Unzing dopangu pupuknga sike pukaing binga. Sike natane guyaknga kupia siknga gwa singgak. Siwan yembina kuut genane gwa gatanggak. Gata na tasiwi nata paa siknga gatukande kungwanggat. ");
INSERT INTO wnc_vpl VALUES ("PS22_16","020_22_16","PSA","22","16","16","Siwan wai aminu waakwakga na keu kuupbam nawake umupbasikaing. Unzing kamunda kaap zong umuyawakaing binga. Sike natane kataknga gatu kepina ngangu genata namukaing. ");
INSERT INTO wnc_vpl VALUES ("PS22_17","020_22_17","PSA","22","17","17","Siwan natane gupma kwatanakan singgak. Siwan waaminda kumzang nanduyuke nata wai siwitde apbakngakaing. ");
INSERT INTO wnc_vpl VALUES ("PS22_18","020_22_18","PSA","22","18","18","Sike waaminda natane taukngae kas binga tasike usanzike natane tauknga, “Mamindaka tapik,” ngang natake tasike sandu sandu inandek inandek pakaing. ");
INSERT INTO wnc_vpl VALUES ("PS22_19","020_22_19","PSA","22","19","19","Siwan ngana, Buyambam tapa, maa yuke na ma nandutewim. Gata na kekekangamunggayak kapanin. Gata zet apu gatangamuyo. ");
INSERT INTO wnc_vpl VALUES ("PS22_20","020_22_20","PSA","22","20","20","Siwan na gata katak tapi waaminda na bainatda dua nuwa kupit. Gata na tapi aminu kamun binga waakwakga na dua nasiwa kupit. ");
INSERT INTO wnc_vpl VALUES ("PS22_21","020_22_21","PSA","22","21","21","Gata na tapi waaminda na laionda kaap zong nakaing binga nutnangge tasiwa maiwik. Sike waaminu ikwawa gamanu zong dakngake yuaingga binga kom nata namnangge tasikaing. Siwan ngana gata waakwakge kataune sandeke gatuka na tapso. ");
INSERT INTO wnc_vpl VALUES ("PS22_22","020_22_22","PSA","22","22","22","Gata unzing tasiwinu nata notnabamde gatane umanda buyambamu yanikapit. Sike tapduu miti kanangge unekan yutningune na banakan kuke gae siknga inata kundu natapit. ");
INSERT INTO wnc_vpl VALUES ("PS22_23","020_22_23","PSA","22","23","23","Ginu Anututane donga, ginda ie gwangat natapnong. Ngan, ginu Jekopdane donga, ginda itane umana yatangenatnong. Ngan, ginu Isrel aminde donga, ginda ie akgwautnong. ");
INSERT INTO wnc_vpl VALUES ("PS22_24","020_22_24","PSA","22","24","24","Dasingge? Ita meya buyak yuaing aminde masa dua yamunggak. Gatu waaminda meya pakaingge ita natapan sanga moo binga dua singgak. Ita waaminu peke paku maa dua yuak. Aho. Ita waamindane tumuk wamna natake akgatayamunggak. ");
INSERT INTO wnc_vpl VALUES ("PS22_25","020_22_25","PSA","22","25","25","Sike miti kanangge unekan yutning gwene nata gatane umandakan yatangenawit. Sike wamu sangabamu nata pasiwitde yawa kekekakut taknga aminu gae akgwaukaing aminde kaine atasiwit. ");
INSERT INTO wnc_vpl VALUES ("PS22_26","020_22_26","PSA","22","26","26","Siwan sangana wena aminu nanamu napa musia gitnaning. Sike aminu Anutue yatawakaingu itane umana ayatangenatning. Na Anututa tasiwan waaminu take asinggan asinggan yutningge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS22_27","020_22_27","PSA","22","27","27","Sike aminu keune nana kuupbamu musia papatekngwamban Anutue natanggamataning. Natake gatu ie apning. Ngan, aminu kuupbamda munu puke inimbaknganing. ");
INSERT INTO wnc_vpl VALUES ("PS22_28","020_22_28","PSA","22","28","28","Dasingge? Buyambamtapa King kapa yuke ita aminu kuupbam kakuya pasinggak. ");
INSERT INTO wnc_vpl VALUES ("PS22_29","020_22_29","PSA","22","29","29","Siwan sangaapana kaya aminu kuupbamu kuutda munu puke inimbaknganing. Sike aminu akumnangge dapaknga sikaingu kayuu yutnanga dua. Waaminu kuupbamda munu puke Anutue inimbaknganing. ");
INSERT INTO wnc_vpl VALUES ("PS22_30","020_22_30","PSA","22","30","30","Sike aminu masan aatning aminda itane puya tasingamuning. Siwan waaminda Anututane umana aknga aminu masan aatningge yanikapning. ");
INSERT INTO wnc_vpl VALUES ("PS22_31","020_22_31","PSA","22","31","31","Yanikapmake aminu wa tupa dua aakingu gwa aawanu yanike Anutu nomana siknga apa unin ngang yanining. ");
INSERT INTO wnc_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","Buyambam tapa, gata kakuya na nanduyuayak kapanin. Unzingge nata sanga tapatue dapnanga dua. ");
INSERT INTO wnc_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","Ita na tasiwan zongazonga kaya noman komune pekgat. Siwan ita na yangga mateknga kuma zipmakaingune nanitakuwan nata tangoke yuwa takanggak. ");
INSERT INTO wnc_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","Sike ita nae kekeknga kayuk namunggak. Namuke ita na kepi noman tapaapane nanitake kunggak. Unzing ita tupa tasinangge yakut taknga tawake tasinggak. ");
INSERT INTO wnc_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","Anutu, nata damene zikaa dakaatang kuke ngana gata gatangami akumnanga akngae nata dua gwaumbit. Dasingge? Ga naat gatake yuamak. Nata ga gandupa gusou sipsipde kakuya tasikaingga pakaing kapaapa apanggayak. Unzing kake natane musipma kwikwikngata yuwit. Nata wai sinanga dua. ");
INSERT INTO wnc_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","Gata natane nanama take siknga keu aanggaman komune pandaknganggayak. Siwan natane iwanata moo nanduke sanga takngatu tasinanga dua. Ge, gata naat nasimde apbakngake naninggayak. Gata nanamu nae kwaapzang siknga pewi dopan namunggayak. ");
INSERT INTO wnc_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","Gata nae banip gwaang natake sanga take akngakan tasingamunggayakge tapduk bamu nata kayuk yuwawa gata nae musip kwikwiu asinggan natangamuya. Unzingge nata yotdane asinggan asinggan yuwit. ");
INSERT INTO wnc_vpl VALUES ("PS24_1","020_24_1","PSA","24","1","1","Keu andakaat gatu sangabamu ane yuaingu wa kuupbam Buyambam tapatanekan. Kepna kepna gatu aminu yotna yotna yuaingu wa kuut itanekan. ");
INSERT INTO wnc_vpl VALUES ("PS24_2","020_24_2","PSA","24","2","2","Ita keu andaka tasikuu yangga amaakatang yuwawan engatangan tasike tekut. Ngan, keu andaka tasikutdane yapii gwenu yanggabam gwende banakan tasikut. ");
INSERT INTO wnc_vpl VALUES ("PS24_3","020_24_3","PSA","24","3","3","Mamin amin tapata tawanu Anututa yuak dakane take kopik? Wena. Sike mamin amin tapata Anututane you takwan buyambam gwenu yuaune take koke yuwik? Wena siknga. ");
INSERT INTO wnc_vpl VALUES ("PS24_4","020_24_4","PSA","24","4","4","Aminu tapatuta waiaknga dua tasike musiaatangu gutongana wena, gatu anutu pupukngae munu dua puwik, siwan kem wamde enandang ngangu notnaapa dua yaninggak. ");
INSERT INTO wnc_vpl VALUES ("PS24_5","020_24_5","PSA","24","5","5","Aminu waapae Buyambam tapata take tasingamik. Ngan, Anututa aminu waapa meyana sandekgak. Siwan ita anzing iniwik, “Ga amin noman,” ngang iniwan iwanata wamu yananga dua. ");
INSERT INTO wnc_vpl VALUES ("PS24_6","020_24_6","PSA","24","6","6","Aminu unzing kapatanu Anutue musiane natanggamatakaing. Unzing aminda Anutu Jekopda banip sikut tapae wesimu akukaing. ");
INSERT INTO wnc_vpl VALUES ("PS24_7","020_24_7","PSA","24","7","7","Ginu gwambok gwakgwau ginu zitnong. Ginu gwambou tupa siknga nana, ginu gatukande zitnong. Kingu tupan tapa undang kopikge zikngamunong. ");
INSERT INTO wnc_vpl VALUES ("PS24_8","020_24_8","PSA","24","8","8","Sike Kingu tupan tapa mamin? Tupan tapa Anutu awiapa unin. Waapa kekekngana buyambam siknga. Siwan amak tasikengu ita iwana ayapbikgak. ");
INSERT INTO wnc_vpl VALUES ("PS24_9","020_24_9","PSA","24","9","9","Ginu gwambok gwakgwau ginu zitnong. Ginu gwambou tupa siknga nana, ginu gatukande zitnong. Kingu tupan tapa undang kopikge zikngamunong. ");
INSERT INTO wnc_vpl VALUES ("PS24_10","020_24_10","PSA","24","10","10","Sike Kingu tupan tapa mamin? Tupan tapa Anutu kekeknga siknga apa unin. Wa awiapa Kingu tupan tapa unin. ");
INSERT INTO wnc_vpl VALUES ("PS25_1","020_25_1","PSA","25","1","1","Buyambam tapa, nata apmanu gae tumuk wamu ganinggat. ");
INSERT INTO wnc_vpl VALUES ("PS25_2","020_25_2","PSA","25","2","2","Ga natane Anutuna. Nata gaekan baniu singgat. Gata gatangamuke iwana dua kapewi na napbimban maakawit. Gata iwana dua kapewi na yaitakepuke waaminda baknganing. ");
INSERT INTO wnc_vpl VALUES ("PS25_3","020_25_3","PSA","25","3","3","Sike aminu gae banip sikaingu gata iwana dua kapewi yapbimban maakaning. Wena. Aminu kem yake tanziu yumdekan tasikaingu waamindakan waiaknga tasikaingge natake apmaakaning. ");
INSERT INTO wnc_vpl VALUES ("PS25_4","020_25_4","PSA","25","4","4","Buyambam tapa, gata kepi gikane take akngaka yeikngami kawit. Ngan, gata gikane kepi noman taknga nanindamumso. ");
INSERT INTO wnc_vpl VALUES ("PS25_5","020_25_5","PSA","25","5","5","Gata siakan wamu gikane aknga tawambitde nanindamumso. Dasingge, ga natane Anutuna. Gata na tapi iwanata dua napbitning. Sike tapdukbam asinggan asinggan gata gatangamiyakge gae ganduyuat. ");
INSERT INTO wnc_vpl VALUES ("PS25_6","020_25_6","PSA","25","6","6","Buyambam tapa, gikane natdetdetdaatangu musip kwikwikat gatu butaya akngaatde natapso. Gata waaknga tupata tasitakakopbuyaknga gatu apman kaa atasinggayak. ");
INSERT INTO wnc_vpl VALUES ("PS25_7","020_25_7","PSA","25","7","7","Anutu, gata waiakngaat gatu yamandet takngaat waatdakane yuke tasikumde ma natapim. Ga Anutu butaya akngatane toiknga apa. Siwan ga, Buyambam tapa, gata take siknga asinggan yuke nae natake musip kwikwiu natangamunggayak. ");
INSERT INTO wnc_vpl VALUES ("PS25_8","020_25_8","PSA","25","8","8","Buyambamtapa take siwan noman sikngaapa. Ge ita waiaknga tasikaing aminu yanimbitake iekan tawaningge yanindamukgak. ");
INSERT INTO wnc_vpl VALUES ("PS25_9","020_25_9","PSA","25","9","9","Ita noman takngane ie gepbiatang yuke inane umana dua yatangenakaingu yanipake kunggak. Kuke itakan kepi noman takngakan tawaningge yanindamukgak. ");
INSERT INTO wnc_vpl VALUES ("PS25_10","020_25_10","PSA","25","10","10","Aminu Anututa wamu yawan kekekakut taknga gatu mama wamna ngang tawakaing aminde Anututa musia kwikwiknga akngana dua sandeke asinggan asinggan natayamik. ");
INSERT INTO wnc_vpl VALUES ("PS25_11","020_25_11","PSA","25","11","11","Anutu, gikane wamba yawi kekekakut taknga tawake nata meya kwaapzangu tasikumu sandekngamuyo. Siwan sandekngamuke tasiwi gatane umanda kopsa siwik. ");
INSERT INTO wnc_vpl VALUES ("PS25_12","020_25_12","PSA","25","12","12","Mamin aminda Buyambam tapae gwaukaing? Aminu wa Buyambam tapae gwauke Buyambam tapatane wamna tawambanu, Anututa kepi nomantapa yeuyamik. Yeuyaman waapane kuninggen. ");
INSERT INTO wnc_vpl VALUES ("PS25_13","020_25_13","PSA","25","13","13","Unzing aminu sanga sanga kwaapzang pake take siknga yutning. Take yuke waamindane waatdakana masande keu andakane take yutning. ");
INSERT INTO wnc_vpl VALUES ("PS25_14","020_25_14","PSA","25","14","14","Anututa notna ngangu aminu ie gepbiatang koyuaingge nataak. Siwan ita kepi noman takngna tawaningge yanindamukgak. ");
INSERT INTO wnc_vpl VALUES ("PS25_15","020_25_15","PSA","25","15","15","Tapdukbamu Anututa gatangamikge kayuat. Sike na yapap gwekatang binga yuwa sanga kunduta tasiwan maiyak ngang natake na gatuna tanggak. ");
INSERT INTO wnc_vpl VALUES ("PS25_16","020_25_16","PSA","25","16","16","Anutu, gata nae gatuka apuke musip kwikwiu natangamuyo. Dasingge, na ninatakan yuke meya takngatu takngatu akaat. ");
INSERT INTO wnc_vpl VALUES ("PS25_17","020_25_17","PSA","25","17","17","Nata musipmaatang meya nataat taknga gata sandekngamuyo. Sandekngami musipma kwikwiknga yuwik. Gata gatangami meyata na dua tasiwan maiwit. ");
INSERT INTO wnc_vpl VALUES ("PS25_18","020_25_18","PSA","25","18","18","Sike natetdet naatangu nata meya takngatu takngatu natake yuatde natapso. Natake waina kuupbam sandekngamuyo. ");
INSERT INTO wnc_vpl VALUES ("PS25_19","020_25_19","PSA","25","19","19","Gata natane iwana kwaapzang siknga singgakge kayo. Nae kundusim paa take dua nataaing. Wena siknga. ");
INSERT INTO wnc_vpl VALUES ("PS25_20","020_25_20","PSA","25","20","20","Gata na gatuka take na kakuya katak tasiyo. Siwan iwanata na dua tasiwa maakawit. Gata katak nanduyuwayakge nata gae apunggat. ");
INSERT INTO wnc_vpl VALUES ("PS25_21","020_25_21","PSA","25","21","21","Nata gae banip singgat. Unzingge nata sanga take tasinggat takngana gatu noman tasinggat takngana ngang papi kekekawa waakngaatda gatangaman asinggan yuwit. ");
INSERT INTO wnc_vpl VALUES ("PS25_22","020_25_22","PSA","25","22","22","Anutu, gata ninu Isrel nana kuupbam papso. Siwan meya takngatu takngatuta ninu dua pasiwan mainim. ");
INSERT INTO wnc_vpl VALUES ("PS26_1","020_26_1","PSA","26","1","1","Buyambam tapa, nata noman takngakan tasinggat. Tasike baniu kuupbam gaekan singgat. Unzingge gata tasiwi iwanata nandupa take siwan na yumdakan temapa naninanga dua siwik. ");
INSERT INTO wnc_vpl VALUES ("PS26_2","020_26_2","PSA","26","2","2","Anutu, gata kakapmake na tasiwi siyok. Gata natane musipma gatu natdetdetna ngang usanziyo. ");
INSERT INTO wnc_vpl VALUES ("PS26_3","020_26_3","PSA","26","3","3","Minae? Gata asinggan musip gwaang natangamunggayak kakngae natanggamatake nata gatane wamu noman takngakan asinggan tawanggat. ");
INSERT INTO wnc_vpl VALUES ("PS26_4","020_26_4","PSA","26","4","4","Na aminu wai aminkat dua sukukamang. Gatu kem wam yakaing aminkat kaya dua sukukamang. ");
INSERT INTO wnc_vpl VALUES ("PS26_5","020_26_5","PSA","26","5","5","Na wai aminu unekan gatake yuaing ngang kakengu une kunangge apbitanggat. Sike wai aminkau naat dua gatake yuamang. ");
INSERT INTO wnc_vpl VALUES ("PS26_6","020_26_6","PSA","26","6","6","Buyambam tapa, na gutongana wena ngang natake kataknga ga yeikgamunangge saiukgat. Saiuke nata gatane alta dakane kumbasike munu pukgat. ");
INSERT INTO wnc_vpl VALUES ("PS26_7","020_26_7","PSA","26","7","7","Munu puke nata kap takngatu taike gae gaak ganiwit. Ganike nata aminu kuupbam puya gata noman taknga tasinggayakge yanikapit. ");
INSERT INTO wnc_vpl VALUES ("PS26_8","020_26_8","PSA","26","8","8","Buyambam tapa, nata gatane yot gwendae take siknga nataat. You gatane wagwene umanda kopsa aknga undang yuak. ");
INSERT INTO wnc_vpl VALUES ("PS26_9","020_26_9","PSA","26","9","9","Tapduu gata wai aminu gatukande pasiwi maining komune natane kayuk yuat takngana ma tasiwi sopuwan. Gata na ma nuwi kupam, notnaapa zipan kungwakaing aminkaun. ");
INSERT INTO wnc_vpl VALUES ("PS26_10","020_26_10","PSA","26","10","10","Waaminu waiaknga asinggan tasikaing. Tasike moningu kundu aminu wam usanzikaingge asinggan yamukaing. Yamuke kaa wam yanindatdaiwan waiakngae yake meya takngatu dua yamuning. ");
INSERT INTO wnc_vpl VALUES ("PS26_11","020_26_11","PSA","26","11","11","Siwan ngana na noman takngakan tasinggat. Gata nae musip kwikwik natangamuke na gatuka tapso. ");
INSERT INTO wnc_vpl VALUES ("PS26_12","020_26_12","PSA","26","12","12","Na keu noman komune dandamake kekeknga yuat. Nata aminu unekan yutning komune banakan yuke Anututane umana yatangenawit. ");
INSERT INTO wnc_vpl VALUES ("PS27_1","020_27_1","PSA","27","1","1","Buyambamtapa natane kakaana siwan ita na gatangamunggak kapanin. Buyambam tapatakan na nanduyuke kekekangamunggak. Unzingge na sanga tapatue dua gwaukgat. ");
INSERT INTO wnc_vpl VALUES ("PS27_2","020_27_2","PSA","27","2","2","Sike wai aminda wesim apuke na nanisapdutnangge ba nataaing. Natake na nutnangge ba tasining. Tapduu unzing tasining komune waamindane kepina sanga kunduta yapan waakwakga apimaning. ");
INSERT INTO wnc_vpl VALUES ("PS27_3","020_27_3","PSA","27","3","3","Siwan amak aminu buyambamda apu na nutnangge yupbasiwanu nata dua gwaumbit. Ngan, iwanata apan naat amakengu na Anutue banip singgat takngae natapa kekekawik. ");
INSERT INTO wnc_vpl VALUES ("PS27_4","020_27_4","PSA","27","4","4","Nata Buyambamtapa sanga tapatuekan ininggamatanggat. Inike nata take siknga ita unzing tasiwikge nataat. Nata inikwaike nata itane you buyambam gwene yusika kupit. Sike na ita nae take tasinggakge nata ie apbakngawit. Siwan nata iniwa ita kepi noman taknga yeikngamik. ");
INSERT INTO wnc_vpl VALUES ("PS27_5","020_27_5","PSA","27","5","5","Sike sanga wai takngatu nae apanu ita na inane yotnaatang takusopuwik. Ita gwambok yapuke take siknga takusopuwik. Takusopuke ita na suu buyambam siknga gwendune engatangan napmamban iwanata nutnanga dua siwik. ");
INSERT INTO wnc_vpl VALUES ("PS27_6","020_27_6","PSA","27","6","6","Unzingge na iwanata na umupbasining ngana ayapbimbit. Siwan nata apbakngake kumzang yanggamatake sanga imukaing binga Anutue yotnane tasiwit. Tasike nata kap taike umana yatangenawit. ");
INSERT INTO wnc_vpl VALUES ("PS27_7","020_27_7","PSA","27","7","7","Buyambam tapa, tapduu nata ga ganiwit komune gata nae musip kwikwik natangamuyo. Gata natane tumuk wama natake gatangamuyo. ");
INSERT INTO wnc_vpl VALUES ("PS27_8","020_27_8","PSA","27","8","8","Sike nata musipmaatangu gae anzing nataat, “Nata gae asaapit.” Unzingge Buyambam tapa, nata gae asaapit. ");
INSERT INTO wnc_vpl VALUES ("PS27_9","020_27_9","PSA","27","9","9","Sike gata nae ma kusopuwim. Gata nae masaka ma namim. Na gatane puya aminda. Nae kaanga natake ma nanikwasiwim. Anutu, ga natane gatak gatak kapana. Ge gata na ma napmambim. ");
INSERT INTO wnc_vpl VALUES ("PS27_10","020_27_10","PSA","27","10","10","Siwan mingananata nae masa apba namusan, ngana Buyambam tapata na take apme nanduyuwik. ");
INSERT INTO wnc_vpl VALUES ("PS27_11","020_27_11","PSA","27","11","11","Buyambam tapa, gata sanga nata tasiwitde take nataayak kaknga nanindamumbi tasiwit. Na iwana kwaapzang siknga yuaingge kepi noman tapane nanitake kuyo. ");
INSERT INTO wnc_vpl VALUES ("PS27_12","020_27_12","PSA","27","12","12","Sike gata dua kapewi iwanata na taning. Sike waaminda kem wam yake na atnutnangge yakaing. ");
INSERT INTO wnc_vpl VALUES ("PS27_13","020_27_13","PSA","27","13","13","Siwan nata anzing natapa kekekanggak. Masande Anututa aminu inane take siknga toimban nata kayuk yuke kawit. ");
INSERT INTO wnc_vpl VALUES ("PS27_14","020_27_14","PSA","27","14","14","Siwan gata Buyambam tapae banip sike kekeknga yuyo. Yuke musipbaatang natapi kekekayok. Kekekawan Buyambam tapata gatanggamikge natayuyo. ");
INSERT INTO wnc_vpl VALUES ("PS28_1","020_28_1","PSA","28","1","1","Buyambam tapa, ga natane gatak gatak kapana. Nata gae yanggawake sikgawaawa maak pake natangamuyo. Sike gata natane tumuk wama natake sanga takngatu dua tasiwinu, na akupsa amin binga dakngawit. ");
INSERT INTO wnc_vpl VALUES ("PS28_2","020_28_2","PSA","28","2","2","Siwan nata tapduu akgatangamiyakge yawanu, gata natane tumuk wamae natapso. Sike nata tumuk wamu yayuk kataknga tangenake yotdae katapmiyuk tumuk wamu yanggau natapso. ");
INSERT INTO wnc_vpl VALUES ("PS28_3","020_28_3","PSA","28","3","3","Sike aminu kunduta notnaapae kaaya wam yanikaing, ngana natdetdeu wai musiane doke yuaing. Siwan gata naat gatu wai aminu waakwakat ma kaipakapapuke nisipim. ");
INSERT INTO wnc_vpl VALUES ("PS28_4","020_28_4","PSA","28","4","4","Gata waaminu waiaknga tasikaingu pandambanuyo. Waiaknganae buyana inandek inandek asiknga yamuyo. Ngan, waaminde toknga siknga yamuke asiknga pandambanuke pasiwi mainong. ");
INSERT INTO wnc_vpl VALUES ("PS28_5","020_28_5","PSA","28","5","5","Sike waaminu puya buyambamu Buyambam tapata tasikutde dua natapasikaing. Unzingge ita waaminu pandambanuke gatukande pasiwan sopuning. Siwan ita waaminu gatuna dua gatayamik. ");
INSERT INTO wnc_vpl VALUES ("PS28_6","020_28_6","PSA","28","6","6","Siwan nata Buyambam tapatane umana yatangenakgat. Dasingge, nae musip kwikwik natangamikge natake ie tumuk wam yatawaawa gwa natapbut. ");
INSERT INTO wnc_vpl VALUES ("PS28_7","020_28_7","PSA","28","7","7","Anututa ina siknga na kekekngamuke kakuya tasike wamanapmanggak. Nata ie banip siwa Buyambam tapata na akgatangamunggak. Ge nata ie asiknga baknganggat. Bakngake nata kap taike umana yatangenakgat. ");
INSERT INTO wnc_vpl VALUES ("PS28_8","020_28_8","PSA","28","8","8","Buyambam tapata inane aminu kuupbam kekekayamunggak. Siwan ita aminu tapatu yawan king dakngakut tapa akgatangamuke gatuna tanggak. Buyambamtapa damanu kekeknga siknga gwen binga unin. ");
INSERT INTO wnc_vpl VALUES ("PS28_9","020_28_9","PSA","28","9","9","Anutu, gikane aminda meya akngana sandeyamuyo. Sandeyamuke waaminde sanga take aknga tasiyamuyo. Sike gata waamindane kuyana dakngake katak siknga kakuya asinggan asinggan kayuyo. ");
INSERT INTO wnc_vpl VALUES ("PS29_1","020_29_1","PSA","29","1","1","Siwan ginu angela kekekngasa kaya amin, ginda Buyambam tapatane umana yatangenatnong. Yatangenake itane umana kopsa gatu kekekngana ngangge apbaknganong. ");
INSERT INTO wnc_vpl VALUES ("PS29_2","020_29_2","PSA","29","2","2","Buyambam tapatane umana kopsa aknganae yatangenatnong. Sike ita takwan siknga inata siknga yuakge natake ginda munu puke inimbaknganong. ");
INSERT INTO wnc_vpl VALUES ("PS29_3","020_29_3","PSA","29","3","3","Buyambam tapata wamu yawan aminu yanggabam gwenu kwaimune yupbasikaingu kuupbamda natapning. Anutu umana kopsaapa ge ita wamu kekeknga ena kakaa komune gakngatda binga kaapmapa yawan yanggabam gwenu tawamban sandekgak. ");
INSERT INTO wnc_vpl VALUES ("PS29_4","020_29_4","PSA","29","4","4","Buyambam tapata yanggamatanggak kaknga kekekngana buyambam siknga. Aminu kuupbamda nataawa Anutu kopsa siknga apata yawanu waaminu ie akgwautning. ");
INSERT INTO wnc_vpl VALUES ("PS29_5","020_29_5","PSA","29","5","5","Buyambam tapata yanggamatawanu katau buyambam siknga dakandaka apuke pimakaing. Sike Anututa katau buyambam wa dakandaka Lebanon nana pasiwan pukaing. ");
INSERT INTO wnc_vpl VALUES ("PS29_6","020_29_6","PSA","29","6","6","Sike ita tasiwan tawanu Lebanon nana dakandaka miamunda tasiwan pukapmake dekaing. Siwan tawanu Hermon ngang inikaing daka miamunda tasiwan pukapmake dekgak. ");
INSERT INTO wnc_vpl VALUES ("PS29_7","020_29_7","PSA","29","7","7","Buyambam tapata yawan yapasik siwan mingata kakaa singgak. ");
INSERT INTO wnc_vpl VALUES ("PS29_8","020_29_8","PSA","29","8","8","Siwan ita yanggamatawanu itane guyakngi natake keu zongana wena komu ayamukgak. Ngan, ita keu zongana wena komu Kedes ngang inikaingu tasiwan miyamunu buyambam siknga singgak. ");
INSERT INTO wnc_vpl VALUES ("PS29_9","020_29_9","PSA","29","9","9","Buyambam tapata yawan katau kekeknga siknga dakandaka apmakwapmimban wai sikaing. Siwan katau kuupbamdane tatakngi tapduu gwendunekan kuupbam pimapa katap dakandaka tapetakan yuking. Siwan Buyambam tapae yotnane yuaingu kuupbamda anzing yanggamataking, “Anutu umana kopsaapa,” ngang yaking. ");
INSERT INTO wnc_vpl VALUES ("PS29_10","020_29_10","PSA","29","10","10","Buyambam tapata King kapa yuke yanggabam gwenu kuupbam kuyana kayuak. Ita King kapa asinggan asinggan yuwawik. ");
INSERT INTO wnc_vpl VALUES ("PS29_11","020_29_11","PSA","29","11","11","Buyambam tapata inane aminabamu kekekayamunggak. Ita inane aminabam gatayaman musip kwikwik natayutning. ");
INSERT INTO wnc_vpl VALUES ("PS30_1","020_30_1","PSA","30","1","1","Buyambam tapa, gata na gwa take iwana dua kapewi na tasiwa maiwa nanduke bakngaking. Unzingge nata gatane umanda kumzang yatangenawit. ");
INSERT INTO wnc_vpl VALUES ("PS30_2","020_30_2","PSA","30","2","2","Buyambam tapa, ga natane Anutuna. Nata wamu gata akgatangamiakge yanggawa gata na tasiwi maitna wena sikut. ");
INSERT INTO wnc_vpl VALUES ("PS30_3","020_30_3","PSA","30","3","3","Buyambam tapa, na paa kumbum siwan ngana gata matmat komuneta na gatuka takuyak. Ngan, nata akupsa aminda yuaing komune dua pukuwitde natake gata na gatuka takuyak. ");
INSERT INTO wnc_vpl VALUES ("PS30_4","020_30_4","PSA","30","4","4","Ginu aminu Anututane aminabam, ginda kau itane umana yatangenake tainong. ");
INSERT INTO wnc_vpl VALUES ("PS30_5","020_30_5","PSA","30","5","5","Sike ita kaanga tapduu dapaknga siknga natanimunggak. Natake ngana ita ninde musia kwikwiknga tapduu ninda kayuk yuamang komune natanimunggak. Kai yangganinu zikaane apimakaing. Siwan ngana tembana ninu gatu apbaknganim. ");
INSERT INTO wnc_vpl VALUES ("PS30_6","020_30_6","PSA","30","6","6","Tupa nata ninane kekeknganane yuke meya takngatu nae dua apik, ngang natake anzing yakum, “Sanga tapatuta na ikomban pimananga dua,” ngang yakum. ");
INSERT INTO wnc_vpl VALUES ("PS30_7","020_30_7","PSA","30","7","7","Siwan ngana, Buyambam tapa, tapduu ga nae take siknga natangamukuyak komune gata na tasiwi kekekake yukum. Unzing, daman gwenda tawan dakane kekeknga yuak binga. Siwan ngana tapduu gata na napmake akusopukuyak komune na gwaut takngata na asiknga tanggaganukut. ");
INSERT INTO wnc_vpl VALUES ("PS30_8","020_30_8","PSA","30","8","8","Buyambam tapa, nata gae yanggawakum. Ngan, Buyambam tapata nae butaya natapikge natake nata kekeknga siknga yanggawakum. ");
INSERT INTO wnc_vpl VALUES ("PS30_9","020_30_9","PSA","30","9","9","Sike nata akupanu sanga nomanu dasing bingata aawik? Sike nata akungwake matmaune kuwanu sanga waakngata mamin gatangamik? Aminu gwa kumbingga gatane umanda apme yatangenatning ba dasing? Asikaya waaminda asingganu gata waaminde take tasiyamukuyak kakngae yakapning ba dasing? Wena. Dua yakapning. ");
INSERT INTO wnc_vpl VALUES ("PS30_10","020_30_10","PSA","30","10","10","Buyambam tapa, gata nae natapso. Natake nae musip kwikwik natangamuyo. Buyambam tapa, gata na gatangamuyo. ");
INSERT INTO wnc_vpl VALUES ("PS30_11","020_30_11","PSA","30","11","11","Gatangamuke gata musipma kwanam siknggat taknga gwa sandekngamuke tasiwi nata kau apbakngake tainggat. Tupa na meya siknga natayukum ngana nata kwanam sikum takngae yake tasiwi natane musipmaatang asiknga baknganggat. ");
INSERT INTO wnc_vpl VALUES ("PS30_12","020_30_12","PSA","30","12","12","Unzingge nata gena dua umumbit. Aho, nata musipmaatangu kau umanda yatangenatnangge ataiwit. Buyambam tapa, ga natane Anutuna. Nata gae gaak wamu asinggan asinggan ganimbakngawit. ");
INSERT INTO wnc_vpl VALUES ("PS31_1","020_31_1","PSA","31","1","1","Buyambam tapa, nata gatane gepbiatang koke kusopuwawa gata iwana dua kapewi na tasiwa maike maakawit. Ga dundumna siknga apa, gata na gatuka tapi nata wai dua siwit. ");
INSERT INTO wnc_vpl VALUES ("PS31_2","020_31_2","PSA","31","2","2","Gata nae wam natake na zeetgaman gatuka tapso. Ga tawanu buyambamu supna kaya daka binga yuayakge nata undang kusopuwit. Siwan gata na katak siknga wamanapmambi take yuwawa iwanata na dua tasiwa maiwit. ");
INSERT INTO wnc_vpl VALUES ("PS31_3","020_31_3","PSA","31","3","3","Ga unzing nata akusopunanga tapa binga siwan gata na kakuya tasinggayak. Gata tupan kuke na nanitake kepi noman takngane nanitakuyo. Unzing gika tupa gwa yakuyak kaknga tawake tasinggayak. ");
INSERT INTO wnc_vpl VALUES ("PS31_4","020_31_4","PSA","31","4","4","Sike iwanata yapapna tewa nata undang pukuwa na tanangge tasikaing. Gata na asiknga kakuya tasiwi nata meya waaknga dua papit. Dasingge, ga nata akusopunggat tapa gakan. ");
INSERT INTO wnc_vpl VALUES ("PS31_5","020_31_5","PSA","31","5","5","Nata ninane waunga gatane katakgane teat. Buyambam tapa, ga Anutu sanga noman takngakan tasinggayaunin, gata na gatuka tapso. ");
INSERT INTO wnc_vpl VALUES ("PS31_6","020_31_6","PSA","31","6","6","Sike nata aminu anutu pupukngae yanindatakaingge apbitanggat. Siwan ngana na Buyambam tapae banip singgat. ");
INSERT INTO wnc_vpl VALUES ("PS31_7","020_31_7","PSA","31","7","7","Sike gata nae butaya asinggan natangamunggayak. Unzingge nata gae apbaknganggat. Dasingge, gata meya natapbum taknga akakuyak. Ngan, gata natane musipmaatang meya takngatu takngatu natapbumu atnatapbuyak. ");
INSERT INTO wnc_vpl VALUES ("PS31_8","020_31_8","PSA","31","8","8","Gata iwana dua kapewi waaminda na kaautde dua taking. Gata na gatangami na keu kakaa komune take yuat. ");
INSERT INTO wnc_vpl VALUES ("PS31_9","020_31_9","PSA","31","9","9","Buyambam tapa, na meya buyambamu kaya. Unzingge nata kwanamu kumzang sikgawa kainata atzukngaing. Siwan kwatana tuyuknga singgakge gata nae musip kwikwik natangamuyo. ");
INSERT INTO wnc_vpl VALUES ("PS31_10","020_31_10","PSA","31","10","10","Siwan musipmane meya nataat takngata na kayuk yutnanga aknga atzipmandaknganggak. Na kwanamu asinggan sike na tapduu mamaya yutnanga dua singgak. Na meya buyambam siknga. Unzingge natane kekekngana wena singgak. Siwan natane kwatana kuupbam atuyukakaing. ");
INSERT INTO wnc_vpl VALUES ("PS31_11","020_31_11","PSA","31","11","11","Sike iwanata na atnanisapdukaing. Siwan notna take yuamangga nae masa namukaing. Sike nata kepiapane kuwawa na nandupnangge bitake kusopukaing. ");
INSERT INTO wnc_vpl VALUES ("PS31_12","020_31_12","PSA","31","12","12","Sike aminu kuupbamda nae gwa botaking. Unzing na aminu akupa kwaike botakaing binga yukum. Na unzing gapma gwegwenda atapan mukaing binga sikum. ");
INSERT INTO wnc_vpl VALUES ("PS31_13","020_31_13","PSA","31","13","13","Dasingge, nata nataawa iwana kwaapzangga nae sapdut wam nanikaing. Siwan gatu kaut kaut yuke na tasiwa gwaumbitde kumzang tasikaing. Sike gatu unekan yuke wamu yawan kekekawan na tasiwa maiwitde yakaing. Waaminda atnuwa kupitde yakaing. ");
INSERT INTO wnc_vpl VALUES ("PS31_14","020_31_14","PSA","31","14","14","Siwan ngana undanga. Buyambam tapa, nata gae banip singgat. Sike, “Ga natane Anutuna,” ngang yanggat. ");
INSERT INTO wnc_vpl VALUES ("PS31_15","020_31_15","PSA","31","15","15","Sike asingganu nata gae kataune yuat. Gata na iwanae kataune gatu aminu na nawakaingge kataune sandeke tapso. Waaminda na tasiwa maiyat. ");
INSERT INTO wnc_vpl VALUES ("PS31_16","020_31_16","PSA","31","16","16","Na gatane puya aminda. Unzingge gata nanduyuke musip kwikwik natangamuyo. Gata nae musip kwikwik asinggan asinggan natangamuke na iwanatane kataune sandeke tapso. ");
INSERT INTO wnc_vpl VALUES ("PS31_17","020_31_17","PSA","31","17","17","Buyambam tapa, nata gae yangawawa gata gatangamuyo. Gatangamuke iwana ma kapewi waaminda na napbimbam. Sike gata kapewi wai aminda apmaakaning. Maakake waaminda gena kusiwan yusika matmat gwene pukuning. ");
INSERT INTO wnc_vpl VALUES ("PS31_18","020_31_18","PSA","31","18","18","Sike waaminu yamandet sike sapdut wam yakaing. Siwan wamu waiaknga amin nomande yanikaing. Waaminu kem wamban yakaing. Unzing tasikaingge natake gata waaminu pasiwi maiwa waamindane gena tupakande pasiwi kusinong. ");
INSERT INTO wnc_vpl VALUES ("PS31_19","020_31_19","PSA","31","19","19","Sike gata puya take siknga aknga tasike gae gepbiatang yuaing aminu akgatayamunggayak. Ngan, puya aaknga aminde kaine aminu gae gepbiatang yuaingge tasiyamuya. ");
INSERT INTO wnc_vpl VALUES ("PS31_20","020_31_20","PSA","31","20","20","Gata waaminu gika yuayak komune inengan pakusopunggayak. Pakusopuwawi aminda wam yawan kekekawan zipnangge tasiwa maiwik. Gata aminu gae gepbiatang yuaing aminu katak siknga pakusopunggayak. Siwan iwanata wamu waiaknga yaningga waaminu dua pasiwan maining. ");
INSERT INTO wnc_vpl VALUES ("PS31_21","020_31_21","PSA","31","21","21","Tupanu iwanata na nutnangge nawake natane yotgapma yupbasiking. Yupbasiwawa ngana ita nae musip gwaang siknga natangamuke inane kekekngata gatangaman nata take yuat. Unzingge Buyambam tapatane umana yatangenatnong. ");
INSERT INTO wnc_vpl VALUES ("PS31_22","020_31_22","PSA","31","22","22","Buyambam tapa, tupa na iwana waakwau asiknga kagwauke anzing yakum, “Na apba nanikwasiwa na gae wesimu dua ba yuat,” ngang yakum. Siwan ngana gata natane wam natake gata na akgatangamukuyak. ");
INSERT INTO wnc_vpl VALUES ("PS31_23","020_31_23","PSA","31","23","23","Siwan aminu Anututane aminabam, ginda ie take siknga natapnong. Dasingge, ita aminu ie wam natake tawakaingu akgatayamunggak. Sike ngana aminu yamandet sikaingge yake toknga kapzang ayamunggak. ");
INSERT INTO wnc_vpl VALUES ("PS31_24","020_31_24","PSA","31","24","24","Ginu aminu kuupbamu Buyambam tapae banip sikaingu ginda kekeknga yutnong. Yuke musipzane asinggan natapa kekekayok. ");
INSERT INTO wnc_vpl VALUES ("PS32_1","020_32_1","PSA","32","1","1","Sike aminu tapatu Anututa gutongana kake wai waakngana sandekngamanu aminu waapata apbakngayok. Ngan, Anututa waiaknga waakwau pasiwan sopuwan dua siknga natapikge apbakngayok ");
INSERT INTO wnc_vpl VALUES ("PS32_2","020_32_2","PSA","32","2","2","Siwan aminu tapatu waiaknga tasinggau Buyambam tapata yawan aminu waapatane gutongana apmanu wena siwanu aminu waapata apbakngayok. Musiaatangu kem taknga aknga dua natake tawanggak kapanin. ");
INSERT INTO wnc_vpl VALUES ("PS32_3","020_32_3","PSA","32","3","3","Nata wamu takngatusimu dua yayuuk zikaane gatu gunzit tapane ngangu kwanamu kumzang sikum. Unzing siwawa natane gupma apatdekut. ");
INSERT INTO wnc_vpl VALUES ("PS32_4","020_32_4","PSA","32","4","4","Dasingge, gunzit tapane gatu zikaane gata meya takngatu takngatu namuwawi natane kekekngana kuupbam wena sikut. Unzing gunzitda kepdaka isiwan wawaakgak binga sikum. ");
INSERT INTO wnc_vpl VALUES ("PS32_5","020_32_5","PSA","32","5","5","Masande nata waiakngana gae yakapbum. Nata waiakngana dua takusopukum. Sike nata anzing yakum, “Nata waiakangana kuupbam Buyambam tapae yakapit,” ngang yake nata yakapa gata waiakngana kuupbam asandekngamukuyak. ");
INSERT INTO wnc_vpl VALUES ("PS32_6","020_32_6","PSA","32","6","6","Unzingge aminu kuupbamu ga gawakaingu apmanu waaminda tumuk wam ganinong. Sike meya aknga buyambam ba siwik, unzing yanggata buyambam paptake amin kaitake kunggak binga siwanu, meya akngata waaminu dua pasiwan maining. Wena Siknga! ");
INSERT INTO wnc_vpl VALUES ("PS32_7","020_32_7","PSA","32","7","7","Ga natane akusopunggat tapana siknga. Nata undang kusopuwa gata na kakuya tasiwi meya akngata na dua tasiwan pimapit. Gata na meya akngane pimambanu gata na atanggayak. Anzing tasinggayakge nata apbakngake kau kumzang tainggat. ");
INSERT INTO wnc_vpl VALUES ("PS32_8","020_32_8","PSA","32","8","8","Buyambam tapata anzing yanggak, “Nata ga katak siknga ganindamuke nata kepiapa yeikgama waapane asiknga kuyo. Siwan nata ganindamuke natdetdetda tapa kakaawan nata ga kakuya tasiwit. ");
INSERT INTO wnc_vpl VALUES ("PS32_9","020_32_9","PSA","32","9","9","Gata ikwawa gamanu hos ba dongki binga dua dakngawim. Sike ikwawa wa gweayau natdetdetna wena. Unzingge gata ainu napna mamaya dakau genane peyo. Peke nap takngaat peke panomanuwawi wanggwak kuson. Sike gata unzing dua tasiwinu gata natapiak kaknga dua tawasan.” ");
INSERT INTO wnc_vpl VALUES ("PS32_10","020_32_10","PSA","32","10","10","Siwan meya takngatu takngatu wai aminde asaapik. Siwan ngana aminu Buyambam tapae banip siknga sikaing aminde kakuya noman tasinggak. ");
INSERT INTO wnc_vpl VALUES ("PS32_11","020_32_11","PSA","32","11","11","Ginu aminu noman yuaing amin, ginda Buyambam tapae musip gwaang natangamuke sanga kuupbamu noman ita tasinggak kakngae inimbaknganong. Ginu aminu kuupbam Anutue kaine noman gan natake yuaingga, apbakngake umana yatangenatnong. ");
INSERT INTO wnc_vpl VALUES ("PS33_1","020_33_1","PSA","33","1","1","Ginu aminu noman taknga tawake tasikaingu ginda sangabamu Buyambam tapata tasinggakge apbaknganong. Siwan ginu Anututane wamna natake tawakaing aminu ginda Anututane umana yatangenatnong. Sanga waaknga aminu nomana aknga tawakaingga tasikaing. ");
INSERT INTO wnc_vpl VALUES ("PS33_2","020_33_2","PSA","33","2","2","Kau noman nomana kulele tanguke taike Anututane umana yatangenatnong. Ngan, ginu kulele napna katau kuut musaatna kaya daka tanguke kau noman nomana tainong. ");
INSERT INTO wnc_vpl VALUES ("PS33_3","020_33_3","PSA","33","3","3","Taike kau kayuk takngatu ie tainong. Taike gita tanguke kau noman nomana siknga taiyuuk ie apbakngake kumzang siknga tainong. ");
INSERT INTO wnc_vpl VALUES ("PS33_4","020_33_4","PSA","33","4","4","Buyambam tapatane wamu kuupbam siakan siknga. Ita puya takngatu takngatu tasinggak kaknga kuupbamu kepi nomana takngakan tawake tasinggak. ");
INSERT INTO wnc_vpl VALUES ("PS33_5","020_33_5","PSA","33","5","5","Buyambam tapata aminu sanga nomana aknga tasikaing kakngae apbaknganggak. Ngan, aminu wam usanziwan noman singgak kakngae apbaknganggak. Sike asingganu Buyambam tapata aminde take natake akgatayamunggak kakngata kepna kepna tawanban sandekgak. ");
INSERT INTO wnc_vpl VALUES ("PS33_6","020_33_6","PSA","33","6","6","Siwan Anututa wamban yawan, gunzit gwen gatu yekap gwen gatu yekapdaak ngangu ena kakaa komune aake yuking. Siwan gatu ita wamban yawan sanga kuupbam ena kakaa komune aaking. ");
INSERT INTO wnc_vpl VALUES ("PS33_7","020_33_7","PSA","33","7","7","Ita yanggabam gwenu iniwan paku ina saak yukut. Unzing aminda yangga sospenu gwendunekan zikaing binga. Sike ita tasiwan yanggabam gwenu kutakngi kaya amunandang siknga siwan ina saak une yuak. ");
INSERT INTO wnc_vpl VALUES ("PS33_8","020_33_8","PSA","33","8","8","Sike aminu kepdakane nana kuupbamda Buyambam tapae akgwautnong. Ngan, aminu kuupbam kepna kepna nana aminda akgwauke ie gepbiatang koyutnong. ");
INSERT INTO wnc_vpl VALUES ("PS33_9","020_33_9","PSA","33","9","9","Dasingge, ita wamban yawan keu andaka yukut. Siwan ita wamu yawan sanga kuupbamu aake yuking. ");
INSERT INTO wnc_vpl VALUES ("PS33_10","020_33_10","PSA","33","10","10","Buyambam tapata natdetdeu kepna kepna nana amindane pasiwan sopukaing. Sike aminda sanga takngatu tasinangge yandekaingu ita kepi asumuyaman waaminda tasiwa mainggak. ");
INSERT INTO wnc_vpl VALUES ("PS33_11","020_33_11","PSA","33","11","11","Siwan ngana Buyambam tapata sanga takngatu tasinangge yawan buyana asaake kekeknga asinggan yuak. Ita natetdeu sanga takngatu takngatu tasinangge natdekgau natdetdeu waaknga kekeknga asinggan asinggan yuak. ");
INSERT INTO wnc_vpl VALUES ("PS33_12","020_33_12","PSA","33","12","12","Siwan Anututa dongu inae yawan yuaing aminda apbaknganong. Dasingge, dongu waakwau Buyambam tapata inae yawan yuaingge, waaminda apbaknganong. ");
INSERT INTO wnc_vpl VALUES ("PS33_13","020_33_13","PSA","33","13","13","Anutu yekaune yuke enaneta amunane kaak. Ita aminu kuupbam kaak. ");
INSERT INTO wnc_vpl VALUES ("PS33_14","020_33_14","PSA","33","14","14","Ita King kapa yotnane yuke enaneta keune nana aminu kuupbamde kaak. ");
INSERT INTO wnc_vpl VALUES ("PS33_15","020_33_15","PSA","33","15","15","Sike ita ina siknga aminu kuupbamdane natdetdetna papan kakaakgak. Siwan sanga kuupbamu waaminda tasikaingu kuut siknga akaak. ");
INSERT INTO wnc_vpl VALUES ("PS33_16","020_33_16","PSA","33","16","16","Kingu tapatuta amau tasike iwana yawamban kukaingu kekeknga amak aminu buyambamde kekekngane dua yapbikgak. Amak aminda iwana inane kekekngane dua yapbikgak. ");
INSERT INTO wnc_vpl VALUES ("PS33_17","020_33_17","PSA","33","17","17","Siwan ikwawa gamanu hos ngang yanikaing gwegwenda amak amin gatayaman amake yapbitnanga dua. Amak aminu amak tasike tuyukawanu hosdane kekeknganata gatayamunanga dua. ");
INSERT INTO wnc_vpl VALUES ("PS33_18","020_33_18","PSA","33","18","18","Siwan ngana natapnong. Buyambam tapata aminu ie gepbiatang yuaingu kakuya apasinggak. Ngan, aminu Buyambam tapata musip kwikwiu asinggan asinggan natayamikge banip sikaing aminu ita asinggan kakuya apasinggak. ");
INSERT INTO wnc_vpl VALUES ("PS33_19","020_33_19","PSA","33","19","19","Ita kakuya tasiwanu, waaminda dua kumning. Siwan tom tapduk gwegwene ita nanam yaman nake dua kumning. ");
INSERT INTO wnc_vpl VALUES ("PS33_20","020_33_20","PSA","33","20","20","Ninda yuwatna Buyambam tapata gatanimik. Buyambam tapatakan ninu akgatanimunggak. Ita tuyunggu amakgane daka binga yuak ngang natake ninda undang kusopunim. ");
INSERT INTO wnc_vpl VALUES ("PS33_21","020_33_21","PSA","33","21","21","Ninda umana noman siknga akngae banip siknga sikamang. Unzingge ninda ie apbakngakamang. ");
INSERT INTO wnc_vpl VALUES ("PS33_22","020_33_22","PSA","33","22","22","Buyambam tapa, ninda banip sike gata gatanimiakge yuamang. Gata ninde musip kwikwiu asinggan asinggan natanimuyo. ");
INSERT INTO wnc_vpl VALUES ("PS34_1","020_34_1","PSA","34","1","1","Siwan nata Anutue asinggan inimbakngawit. Asinggan nata itane umana yatangenawit. ");
INSERT INTO wnc_vpl VALUES ("PS34_2","020_34_2","PSA","34","2","2","Nata Anututa gatangamukutde ie apbakngawit. Sike aminu meya pakaingga wamu nata apbakngake yawit takngae natake musip gwaang siknga natapnong. ");
INSERT INTO wnc_vpl VALUES ("PS34_3","020_34_3","PSA","34","3","3","Ninda Anututane umana buyambam takngae yakapna. Ninda itane umana yatangenatna. ");
INSERT INTO wnc_vpl VALUES ("PS34_4","020_34_4","PSA","34","4","4","Nata tumuk wamu Buyambamtapa iniwa ita akgatangamuke tumuk wama atnatapbut. Ita gwaut taknga nata nataau kuupbam asandekngamukut. Unzingge nata musip kwikwik natake yuat. ");
INSERT INTO wnc_vpl VALUES ("PS34_5","020_34_5","PSA","34","5","5","Aminu kuupbam meyana kaya siwan ngana waaminda Buyambam tapae banip sike apbakngakaing. Unzingge waamindane banip sikaing kakngana wai dua siwik. ");
INSERT INTO wnc_vpl VALUES ("PS34_6","020_34_6","PSA","34","6","6","Aminu sangana wena apaapa Buyambam tapae tumuk wam iniwa ita natake meya wa kaking kaknga aknga kuupbam sandeyamukut. ");
INSERT INTO wnc_vpl VALUES ("PS34_7","020_34_7","PSA","34","7","7","Angela Buyambam tapatane tapata aminu Buyambam tapae gepbiatang yuaing aminde inengan yuak. Yuke ita gatayamuwawan meya takngatuta dua pasiwan maining. ");
INSERT INTO wnc_vpl VALUES ("PS34_8","020_34_8","PSA","34","8","8","Buyambam tapata ninde take siknga tasinggak. Ginda tasiwa siwan kake Buyambam tapae take siknga natapning. Siwan aminu tapatuta Buyambam tapae gepbiaatang koke kusopuke take yuwik. ");
INSERT INTO wnc_vpl VALUES ("PS34_9","020_34_9","PSA","34","9","9","Ginu aminu Buyambam tapatane, ginu kuupbam ie akgwauke yutnong. Dasingge? Aminu Buyambam tapae akgwauke ie gepbiatang yuaing aminu sanga tapatue dua dapmakaing. ");
INSERT INTO wnc_vpl VALUES ("PS34_10","020_34_10","PSA","34","10","10","Sike kaap zongu laion gwengwenu kaapnae yawamba maiwanu tomnata yuke atuyukaning. Siwan ngana waaminda Buyambam tapae tawakaingu, ita sanga take akngae dua dapmakaing. ");
INSERT INTO wnc_vpl VALUES ("PS34_11","020_34_11","PSA","34","11","11","Waatdakana, ginda nae siknga apuke maak gwaang pake wamu nata yawiu natapnong. Apa nata ginu danindamumba Anutue akgwauke itane gepbiatang asinggan koyutnong. ");
INSERT INTO wnc_vpl VALUES ("PS34_12","020_34_12","PSA","34","12","12","Siwan gata kayuk yutnanga takngaka take siwikge nataayak? Siwan gata kayuu mamaya siknga yuya. Yuke gatu gata take yuke apbakngnaya? ");
INSERT INTO wnc_vpl VALUES ("PS34_13","020_34_13","PSA","34","13","13","Sike gata unzing yutnangge natakengu, ayok. Gata wamu waiaknga dua yawim. Siwan gatuka kem wamu dua yawim. ");
INSERT INTO wnc_vpl VALUES ("PS34_14","020_34_14","PSA","34","14","14","Gata waiaknga masa imuke noman takngakan tawamso. Sike aminu kunduat musipza gwendukan teke noman takngae akekekake tawamso. ");
INSERT INTO wnc_vpl VALUES ("PS34_15","020_34_15","PSA","34","15","15","Buyambam tapata aminu noman yuaingu ita akayuke tumuk wamnae maak panggak. ");
INSERT INTO wnc_vpl VALUES ("PS34_16","020_34_16","PSA","34","16","16","Sike wai aminde Buyambam tapata asiknga bitanggak. Apbitake ita atzipan kupa aminda waaminde apbotaning. ");
INSERT INTO wnc_vpl VALUES ("PS34_17","020_34_17","PSA","34","17","17","Siwan aminu noman yuaingga Buyambam tapae tumuk wam iniwanu ita atnataak. Natake ita gatayaman waaminu meyata dua yapbikgak. ");
INSERT INTO wnc_vpl VALUES ("PS34_18","020_34_18","PSA","34","18","18","Anututa aminu musiaatang meya nataaing aminde inengan yuak. Ngan, ita banip sikaing aminu meya papanu, ita akgatayamunggak. ");
INSERT INTO wnc_vpl VALUES ("PS34_19","020_34_19","PSA","34","19","19","Meya kwaapzangga amin nomande apba apning, ngana Buyambam tapata gatayaman meya waakwakga pasiwan dua pimaning. ");
INSERT INTO wnc_vpl VALUES ("PS34_20","020_34_20","PSA","34","20","20","Siakan. Ita dua pimamban Buyambam tapata take siknga kayuak. Kayuwawan waapatane kwatai tapatu dua puwik. ");
INSERT INTO wnc_vpl VALUES ("PS34_21","020_34_21","PSA","34","21","21","Sanga wai kunduta wai aminu atzipa kumning. Siwan ngana Buyambam tapata amin nomande iwana dakngakaing aminu apasiwan maining. ");
INSERT INTO wnc_vpl VALUES ("PS34_22","020_34_22","PSA","34","22","22","Buyambam tapata puya aminakan papan kayuk yutning. Siwan aminu kuupbamda ie gepbiatang koyuaingu dua ginikaning. Wena siknga. ");
INSERT INTO wnc_vpl VALUES ("PS35_1","020_35_1","PSA","35","1","1","Buyambam tapa, gata aminu naat amakamang aminu gaat amnong. Gata aminu nutnangge tasikaingge yake gata atzipso. ");
INSERT INTO wnc_vpl VALUES ("PS35_2","020_35_2","PSA","35","2","2","Gata amak taukgaat gatu tiunggukaat ngang pake apu gatangamuyo. ");
INSERT INTO wnc_vpl VALUES ("PS35_3","020_35_3","PSA","35","3","3","Gatu sakutdaat sandundaat pake aminu na nawakaing aminkat amnong. Gata anzing naniyo, “Na ga gatanggamunggat tapanin,” ngang naniyo. ");
INSERT INTO wnc_vpl VALUES ("PS35_4","020_35_4","PSA","35","4","4","Waaminda na atnutapan kupitde tasikaing. Siwan nata nataau gata amak gwekatang ayapbike pasiwi pimake maakanong. Waaminda na tasiwan maiwikge yandekaing. Gata yawake waaminu pasiwi asiknga datdaptanong. ");
INSERT INTO wnc_vpl VALUES ("PS35_5","020_35_5","PSA","35","5","5","Buyambam tapa, gatane angelakata wai aminu yanikwasiwan andatakunong. Unzing got takngata zongatane dapandapa puyapan kukaing binga. ");
INSERT INTO wnc_vpl VALUES ("PS35_6","020_35_6","PSA","35","6","6","Gatane angelakata ayawamban kunong. Yawamban kuwawa itane kepiapana tasiwan zikaa siwan saweknga siyok. ");
INSERT INTO wnc_vpl VALUES ("PS35_7","020_35_7","PSA","35","7","7","Nata gutonga takngatu iatang dua tasikum. Siwan ngana ita yapapna na tasiwan maiwitde takusopukaing. Siwan gapma dakatu nata pimake pukuwitde kwaiking. ");
INSERT INTO wnc_vpl VALUES ("PS35_8","020_35_8","PSA","35","8","8","Siwan tapduu gwendune dua nataawa apasiwan mainanga akngata papsok. Siwan yapapna na tapikge teking gwenu gata tasiwi ina papsok. Gatu gapma kwaiking dakaatang kaa ina pimake pukunong. ");
INSERT INTO wnc_vpl VALUES ("PS35_9","020_35_9","PSA","35","9","9","Buyambam tapata unzing gatangaman kakengu musipmaatangu apbakngawit. Ngan, ita na tapan take yuat takngae natake nata musip gwaang natangamit. ");
INSERT INTO wnc_vpl VALUES ("PS35_10","020_35_10","PSA","35","10","10","Natangamuke banip gwaang wamu anzing yawit, “Buyambam tapa, ga binga tapatu dua yuak. Siwan gata kekekngana wena aminu take siknga gatayamunggayak. Unzing tasiwi aminu kekekngana kayata waaminu dua pasiwan maining.” ");
INSERT INTO wnc_vpl VALUES ("PS35_11","020_35_11","PSA","35","11","11","Sike kem aminda nae wai takngatu dua tasikum ngana kumzang temanggaganupa nanikaing. ");
INSERT INTO wnc_vpl VALUES ("PS35_12","020_35_12","PSA","35","12","12","Sike natanu waaminde takeakngakan tasiyamunggat. Siwan ngana yake itanu waiaknga nae tasikaing. Unzing tasiwan kake musipmaatangu meya siknga nataat. ");
INSERT INTO wnc_vpl VALUES ("PS35_13","020_35_13","PSA","35","13","13","Siwan ngana nata yake waaminde unzing dua tasinggat. Wena siknga. Tapduu gwenduine waaminu mait siwawa kake butaya siknga asinggan nataat. Natake butaya tauksan tamaggat. Butaya natake nanam tomda yuwa waakngata meya namunggak. Siwan nata tumuk wam yawa ngana gata dua gatayamukuyak. ");
INSERT INTO wnc_vpl VALUES ("PS35_14","020_35_14","PSA","35","14","14","Dua gatayami kake nata waaminde butaya notnaapae ba paana ba uyapnae nataaing binga natayamunggat. Sike nata kepi sukuke aminu tapatuta mingae akupan butaya natake kwanam sikgak binga nataat. Nata musipmane meya siknga natake kwanam sikgak binga natayuat. ");
INSERT INTO wnc_vpl VALUES ("PS35_15","020_35_15","PSA","35","15","15","Siwan ngana nata meya pakum tapduk gwekatangu waaminu unekan yuke apbakngaking. Na dua natawa waaminda unekan yuke nae uman yaitakepnangge yaking. Aminu kundu nata dua kaatda nae wamu atemapa yake yuatakaknga wena naniking. ");
INSERT INTO wnc_vpl VALUES ("PS35_16","020_35_16","PSA","35","16","16","Sike waaminda masa wamu kumzang nanike nae meya namuking. Ngan, waaminda masa wam siknga nanike nae apbitake nomna zipbutnanga siking. ");
INSERT INTO wnc_vpl VALUES ("PS35_17","020_35_17","PSA","35","17","17","Buyambam tapa, unzing tasiwa tapduu datdasing kapeya? Gata na tapi waaminda na dua tasiwan maiwit. Waaminu kaap zongu laionda kaapna yasiwan kupan nanggak binga tasike na nutapan kupitde tasikaing. Unzingge na gata ie kataune sandeke tapso. ");
INSERT INTO wnc_vpl VALUES ("PS35_18","020_35_18","PSA","35","18","18","Gata unzing tasiwinu nata gae gaak kaknga dongu inata inata apu unekan yutningune yawit. Siakande siknga. Nata gatane umanda aknga aminbamde banakan yuke yatangenawit. ");
INSERT INTO wnc_vpl VALUES ("PS35_19","020_35_19","PSA","35","19","19","Sike aminu kunduta nae iwana yumdekan sikaing. Gata ma kapewi bakngake na naitakepning. Nae musip maiu yumdekan natangamukaing. Unzingge gata dua kapewi meya nata papitde baknganing. ");
INSERT INTO wnc_vpl VALUES ("PS35_20","020_35_20","PSA","35","20","20","Sike gatu wamu kundusim paa nomanu takngatu notnaapaat katak yutnangge dua yakaing. Pout tasike wamu kundu yakaingu aminu nomanu kem wam yanike pasiwan mainingge yakaing. ");
INSERT INTO wnc_vpl VALUES ("PS35_21","020_35_21","PSA","35","21","21","Gatu waamindakan wamu akaapmapa anzing temapa nanikaing, “Siakande siknga. Ninda akganduatna waiaknga tasikuyak,” ngang nanikaing. ");
INSERT INTO wnc_vpl VALUES ("PS35_22","020_35_22","PSA","35","22","22","Siwan ngana Buyambam tapa, gata waaminu gwa kaak. Unzingge genda ma umukusike yuwim. Buyambam tapa, gata na ma napmake keu maa komdune kuke yuwim. ");
INSERT INTO wnc_vpl VALUES ("PS35_23","020_35_23","PSA","35","23","23","Ga Anutu siwan natane Buyambam tapana. Gata enake apu na gatangamuyo. Enake wamu nata yanggau yakapmake papi kekekanong. ");
INSERT INTO wnc_vpl VALUES ("PS35_24","020_35_24","PSA","35","24","24","Anutu, Buyambam tapana, gata noman takngakan tasinggayak. Gata gatangami iwanata aminu waapa noman takngakan tawanggaunin ngang natdetning. Gata dua kapewi nata maiwa nanduke baknganing. ");
INSERT INTO wnc_vpl VALUES ("PS35_25","020_35_25","PSA","35","25","25","Gata dua kapewi wamu inae anzingu yaning, “Take siknga, sanga ninda tasinangge natamangu gwa tasina buya unin asaakgak,” ngangun. Gata dua kapewi anzingu yaning, “Ninda waapa gwa tasina mainggak,” ngangun. ");
INSERT INTO wnc_vpl VALUES ("PS35_26","020_35_26","PSA","35","26","26","Sike aminu wa meya nata kaatdenu apbakngakaing aminde gata pasiwi apmaakawa natdetdetna panggutokayo. Sike waaminda inane umana aknga yapangenakaingu wa na tasiwan maiwikge. Unzingge gata pasiwi umana wena akwak dakngake apmaakanong. ");
INSERT INTO wnc_vpl VALUES ("PS35_27","020_35_27","PSA","35","27","27","Sike ngana aminu kunduta nae amin noman ngang natapningu, gata pasiwi apbakngake musip gwaang natake kapzang yanggamatanong. Asingganu waaminda anzing yanong, “Buyambamtapa wa tupan amintapa, ita puya amina noman yuwan kake apbaknganggak.” ");
INSERT INTO wnc_vpl VALUES ("PS35_28","020_35_28","PSA","35","28","28","Unzingge gatane noman takngaka yakapmake umanda aknga kwakngaom gatu zikaane ngang asinggan yatangenawit. ");
INSERT INTO wnc_vpl VALUES ("PS36_1","020_36_1","PSA","36","1","1","Nata wamu takngatu wai aminda tasikaing kakngae musipmaatang nataat. Aminu unzing kapata Anutue kundusim paa dua gwaukgak. Wena siknga. Ita Anutue masa imunggak. ");
INSERT INTO wnc_vpl VALUES ("PS36_2","020_36_2","PSA","36","2","2","Siwan aminu wa binga inae natapan kopsa siwan anzing nataak: Na aminu nomana siknga. Anututa waiaknga tasinggau dua kakapmake wam yawitde dua yawik. ");
INSERT INTO wnc_vpl VALUES ("PS36_3","020_36_3","PSA","36","3","3","Asinggan siknga aminu waapa waiaknga tasinangge yayuuk aminu kundu kem wam yaninggak. Itane natdetdet naatangu noman taknga tasinanggengu wena. ");
INSERT INTO wnc_vpl VALUES ("PS36_4","020_36_4","PSA","36","4","4","Sike tapdu apekgak komune waapa waiaknga tasinangge kepie natdekgak. Waapa kepi waiapakan tawanangge natanggamatanggak. Natanggamatake waiakngaenu masa dua imunggak. ");
INSERT INTO wnc_vpl VALUES ("PS36_5","020_36_5","PSA","36","5","5","Buyambam tapa, gata butaya natanimunggayak kaknga mateknga dua. Waaknga buyambam siknga. Ngan, gata nin gatanimunangge yawi kekekakut taknga sandetnanga dua. ");
INSERT INTO wnc_vpl VALUES ("PS36_6","020_36_6","PSA","36","6","6","Gata sanga noman nomana tasinggayak kaknga buyambam siknga. Waaknga enane siknga. Anututane tawan dakandaka binga. Sike ninda masande wam yanimde gata noman taknga tawambiakgane yapii ninda natdetnanga dua. Wa amandang siknga. Unzing yanggabam gwenu amandang siknga yuak binga. Buyambam tapa, gata aminkat gatu kaap zongkat ngang kakuya pasiwi take yuamang. ");
INSERT INTO wnc_vpl VALUES ("PS36_7","020_36_7","PSA","36","7","7","Anutu, gata ninde musip gwaangu asinggan asinggan natanimuggayak. Ninda ie natapna take siknga singgak. Siwan aminu umana kaya apaat gatu umana wenaat ngang gae apuke gae gepbiatang koyuke sopukaing. ");
INSERT INTO wnc_vpl VALUES ("PS36_8","020_36_8","PSA","36","8","8","Sike gatane yotda atangu nanamu kwaapzang siknga. Unzingge aminbamu undang koke nanamde dua dapmakaing. Gatane sanga take siknga wa kwaapzang yuaing. Unzing yangga buyambamu tapatu binga. Siwan gata atangopningge yamunggayak. ");
INSERT INTO wnc_vpl VALUES ("PS36_9","020_36_9","PSA","36","9","9","Ga sangabamda kayuk yuainggane yapii gika. Siwan gatu kakaatane yapii gika. Ninda kakaa waaknga ga anganggan takamang. Siwan take yuamang. ");
INSERT INTO wnc_vpl VALUES ("PS36_10","020_36_10","PSA","36","10","10","Asingganu gata aminu gae atnataaing aminde take siknga natayamuyo. Ngan, gata kepi noman takngane tawake aminu kepi noman tawakaingu asiknga gatayami take yutning. ");
INSERT INTO wnc_vpl VALUES ("PS36_11","020_36_11","PSA","36","11","11","Nata nataau gata yamandet aminu dua kapewi na nainggamutningge nataat. Siwan gata wai aminu dua kapewi na nanikwasining. ");
INSERT INTO wnc_vpl VALUES ("PS36_12","020_36_12","PSA","36","12","12","Kanong. Wai aminu kepdakane pimake yuaing. Waakwau gatu enatnanga dua. ");
INSERT INTO wnc_vpl VALUES ("PS37_1","020_37_1","PSA","37","1","1","Gata nangaakanu sanga wai aminda tasikaingge ma natapim. Gatu gata waiaknga tasikaing amindane sangaapanae musipmaiu ma natapim. ");
INSERT INTO wnc_vpl VALUES ("PS37_2","020_37_2","PSA","37","2","2","Dasingge? Tapduu matekngasim yukengu wai aminu zongazongata kupiakaing binga sining, ba katau dakatutane tatakngita kupiakaing binga kungwake pimaning. ");
INSERT INTO wnc_vpl VALUES ("PS37_3","020_37_3","PSA","37","3","3","Gata Anutuekan banip siknga siyo. Sike noman takngakan tasiyo. Unzing tasikengu gata take asinggan kepbane yuya. Siwan sanga tapatuta ga dua tasiwan maiya. ");
INSERT INTO wnc_vpl VALUES ("PS37_4","020_37_4","PSA","37","4","4","Gata Buyambam tapaekan bakngayo. Bakngawi sanga gata nataau ita asiknga gamik. ");
INSERT INTO wnc_vpl VALUES ("PS37_5","020_37_5","PSA","37","5","5","Gata kayuk yutnanga akngaka Buyambam tapae kataune teyo. Baniu ie kekeknga siwi ita akgatanggamik. ");
INSERT INTO wnc_vpl VALUES ("PS37_6","020_37_6","PSA","37","6","6","Gatanggaman gatane takeakngaka gunzitdane waenga aknga binga anggaman yuwik. Ngan, gatane noman takngaka itakan tasiwan aanggaman siknga aminbamde kaine siwik. Unzing gunzitda banakan pakapu yuwan kakaa siknga singgak binga. ");
INSERT INTO wnc_vpl VALUES ("PS37_7","020_37_7","PSA","37","7","7","Gata Buyambam tapae wesim kuke wepda yuyo. Gatu musip kwikwik yuke kayuwi ita apme gatanggamik. Gata aminu waiaknga takngatu takngatu tasiwawa buyana aawan sanga noman nomana kwaapzang pakaing aminde ma geenguwim. Siakan siknga, gatane natdetdetda atangu sanga waaminda wa pakaingge nangaakanu ma natake unzingu ma tasiwim. ");
INSERT INTO wnc_vpl VALUES ("PS37_8","020_37_8","PSA","37","8","8","Gata kaanga dua natake gata musiptok nataayak taknga ateyo. Gata sangabamde nangaakanu dua natake gatu ma satnawim. Sanga waakngata ga waiakngaatangu ganitakuwan atasia. ");
INSERT INTO wnc_vpl VALUES ("PS37_9","020_37_9","PSA","37","9","9","Unzingge wai aminu gatukande wai asining. Siwan ngana aminu Buyambam tapae banip sike waaminu kepna teyamukut komune take yutning. ");
INSERT INTO wnc_vpl VALUES ("PS37_10","020_37_10","PSA","37","10","10","Tupae dua, zeetgaman wai aminu gatukande wena siknga sining. Gata ayuaing komune kuke ngana aminu waakwakge yawambi maining. ");
INSERT INTO wnc_vpl VALUES ("PS37_11","020_37_11","PSA","37","11","11","Siwan ngana aminu inane umana yatangenatningge take dua nataaing aminde keu kuupbam ayamik. Ayaman amau wena siwa take siknga yutning. ");
INSERT INTO wnc_vpl VALUES ("PS37_12","020_37_12","PSA","37","12","12","Wai aminda natdetdet naatangu amin noman tapa tasiwa maiwikge kaanga natangamunggak. Natangamuke gena sambuke yuak. ");
INSERT INTO wnc_vpl VALUES ("PS37_13","020_37_13","PSA","37","13","13","Siwan ngana Buyambamtapa atnataak. Tapduu gwenduta apik. Apan tapduu wagwene wai aminu gatukande wena asining. Unzingge Buyambam tapata waaminu ayanimikgak. ");
INSERT INTO wnc_vpl VALUES ("PS37_14","020_37_14","PSA","37","14","14","Gatu wai aminda bainatna kaiwan akopan gatu kweemna kaiwan dandakawan sangaapana wena gatu sangaapae dapmakaing amin yamnangge tasikaing. Ngan, waaminda aminu noman taknga tawakaingunin zipa kumningge tasikaing. ");
INSERT INTO wnc_vpl VALUES ("PS37_15","020_37_15","PSA","37","15","15","Siwan ngana bainatnata inane musipna yamning. Siwan kweemna aputning. ");
INSERT INTO wnc_vpl VALUES ("PS37_16","020_37_16","PSA","37","16","16","Sanga mateknga noman amin tapata peyuakganu sanga wai aminda kwaapzang pake yuaingu ayapbikgak. ");
INSERT INTO wnc_vpl VALUES ("PS37_17","020_37_17","PSA","37","17","17","Dasingge? Buyambam tapata wai amindane kekekngana pasiwan sopukaing. Siawan noman aminu kakuya katak kayuak. ");
INSERT INTO wnc_vpl VALUES ("PS37_18","020_37_18","PSA","37","18","18","Buyambam tapata aminu ie wam gwaamuke tawakaingu katak kayuak. Unzingge sanga Anututa yamunggau asinggan pake yutning. ");
INSERT INTO wnc_vpl VALUES ("PS37_19","020_37_19","PSA","37","19","19","Tapduu wai opatangu meya takngatu dua kaning. Sike tapduu gwendu tom tapduk. Siwan ngana noman aminu nanamna kwaapzang. Waaminu dua dapning. ");
INSERT INTO wnc_vpl VALUES ("PS37_20","020_37_20","PSA","37","20","20","Siwan ngana wai aminu kuupbam gatukande wena asining. Buyambam tapatane iwana wena asining. Unzing zongazongatane tapuyata pimake butakaing binga. Siakan siknga, waaminu kupan takngata matekngasim yuke zeetgaman kuwan wena singgak binga sining. ");
INSERT INTO wnc_vpl VALUES ("PS37_21","020_37_21","PSA","37","21","21","Wai aminda sanga kundu moo pakaing ngana yake dua yamukaing. Siwan ngana noman amintapa takeakngakan tasike notnaapae sangabamu moo aminu kundue yamunggak. ");
INSERT INTO wnc_vpl VALUES ("PS37_22","020_37_22","PSA","37","22","22","Sike Buyambam tapata wamu takeaknga yaniwan nataaing amindakan kepdakane take yutning. Siwan ngana aminu Buyambam tapata meya paningge yanggau ayanikwasiwik. ");
INSERT INTO wnc_vpl VALUES ("PS37_23","020_37_23","PSA","37","23","23","Sike Buyambam tapata aminu tapatutane yuyukngae take natakengu ita akekekangaman kepi noman kunggak. ");
INSERT INTO wnc_vpl VALUES ("PS37_24","020_37_24","PSA","37","24","24","Aminu waapa apimake ngana meya dua kawik. Aho, Buyambam tapata katakngine take tangenawan kekeknga gatu yuwik. ");
INSERT INTO wnc_vpl VALUES ("PS37_25","020_37_25","PSA","37","25","25","Tupa na wawi matek ngana apmanu aminuake gwasit. Siwan ngana nata kawanu Anututa amin nomanu tapatue masa dua imunggak. Gatu amin nomanu tapatutane waatdakanata nanamu yamuningge dua yawan kaat. Wena siknga. ");
INSERT INTO wnc_vpl VALUES ("PS37_26","020_37_26","PSA","37","26","26","Asingganu aminu nomana apata musip kwikwik natayamuke sanga kwaapzang aminu kundue yamunggak. Yaman kake itane waakngata minga nana pasiwan apbakngakaing. ");
INSERT INTO wnc_vpl VALUES ("PS37_27","020_37_27","PSA","37","27","27","Gata waiaknga kuupbamde masa yamuyo. Yamuke noman takngakan tasiyo. Unzing tasikengu keu andakane take asinggan yuya. ");
INSERT INTO wnc_vpl VALUES ("PS37_28","020_37_28","PSA","37","28","28","Dasingge, Buyambam tapata aminu noman taknga tasikaing aminde take nataak. Sike aminu ie banip singgau sopuningge dua nataak. Aho, ita asingganu waaminu kakuya tasiwawan kepi noman takngane kukaing. Siwan ngana ita tasiwan wai amindane waatdakana apmea aatningu wai siknga asining. ");
INSERT INTO wnc_vpl VALUES ("PS37_29","020_37_29","PSA","37","29","29","Sike noman aminu keu Anututa yaman paking komune asinggan yutning. ");
INSERT INTO wnc_vpl VALUES ("PS37_30","020_37_30","PSA","37","30","30","Noman amin tapa natdetdetna take siwan wamu take akngakan yakapmanggak Wamu noman takngaekan yanggak. ");
INSERT INTO wnc_vpl VALUES ("PS37_31","020_37_31","PSA","37","31","31","Anututane mama wamu itane musiaatang yuak. Yuwawan ita Anutue wam tawake dua tewik. Siakan, ita sukuke kepi saweknga apane dua pimapik. ");
INSERT INTO wnc_vpl VALUES ("PS37_32","020_37_32","PSA","37","32","32","Sike wai aminda akusopuke noman amin tapa apae wamayuaing. Wamayuke kepi atzipa kumningge yawakaing. ");
INSERT INTO wnc_vpl VALUES ("PS37_33","020_37_33","PSA","37","33","33","Siwan ngana Buyambam tapata amin nomanu dua kapewan wai aminda zipa kumning. Wena siknga. Sike wai aminda wam yak gwene takoke temapa ba yaning ngana Buyambam tapata noman aminu inaekan dua kapewik. ");
INSERT INTO wnc_vpl VALUES ("PS37_34","020_37_34","PSA","37","34","34","Gata Buyambam tapae banip sike natanggamatake tumuk wam inike itane kepi noman takngakan tawamso. Gata unzing tasiwinu umanda kopsa aknga akgamik. Siwan keu ita yakut komu atake yuya. Yuke kaawi ita wai aminu apasiwan maining. ");
INSERT INTO wnc_vpl VALUES ("PS37_35","020_37_35","PSA","37","35","35","Nata wai aminu tapatu musiptok asinggan natake kekekngana bamban tapa kakum. Siwan ita aminu ayapbikgak. Unzing katau dakatu baka binga buyambam takake katap notna yapbike yuaing binga. ");
INSERT INTO wnc_vpl VALUES ("PS37_36","020_37_36","PSA","37","36","36","Siwan ngana masande nata wagwak saak kukum. Siwan ngana aminu waapa undang dua yukut. Aminu waapae atawamba maikut. Siwan dua kakum. Wena siknga. ");
INSERT INTO wnc_vpl VALUES ("PS37_37","020_37_37","PSA","37","37","37","Gata aminu gutonga takngatue dua nataaing aminde natapso. Natake amin noman tapatane yuyuknga kake natdeyo. Aminu tapatu kumanggaman yuwiu, take asinggan yuwik. ");
INSERT INTO wnc_vpl VALUES ("PS37_38","020_37_38","PSA","37","38","38","Sike ngana Buyambam tapata waiaknga tasikaing aminu asiknga pasiwan maining. Gatu itane bapuna kuupbam masande apasiwan sopuning. ");
INSERT INTO wnc_vpl VALUES ("PS37_39","020_37_39","PSA","37","39","39","Buyambam tapata amin nomanu apake akgatayamik. Tapduu meya kaaing gwene waaminda ie isapmake kuwa ita kakuya pasinggak. ");
INSERT INTO wnc_vpl VALUES ("PS37_40","020_37_40","PSA","37","40","40","Waaminda ie baniu asikaing. Unzingge ita waaminu akgatayamunggak. Gatayamuke wai aminde kataune yuaingu asandeke inae papan take yuaing. ");
INSERT INTO wnc_vpl VALUES ("PS38_1","020_38_1","PSA","38","1","1","Buyambam tapa, gata musiptou nae natayak kakngane nae kaanga ma natapim. Ga musiptou nae natayak kakngane na ma tasiwi maiwan. ");
INSERT INTO wnc_vpl VALUES ("PS38_2","020_38_2","PSA","38","2","2","Gata na sakutdata siakande siknga nambuyuak. Siwan katakgata kekeknga nutewi pimakum. ");
INSERT INTO wnc_vpl VALUES ("PS38_3","020_38_3","PSA","38","3","3","Gata nae kaanga natapi na maiu waiaknga singgat. Sike nata waiaknga tasiwawa natane gupmaapa kekekngana wena singgak. ");
INSERT INTO wnc_vpl VALUES ("PS38_4","020_38_4","PSA","38","4","4","Gutonga tasikum takngae na meya siknga nataat. Siwan meya waakngata na gwa usikwatanapmakut. Sike gutongana waaknga sanga sanga gwaamumba meya siknga sikaing binga. Nata gutonga wa dambu siknga tasikum. ");
INSERT INTO wnc_vpl VALUES ("PS38_5","020_38_5","PSA","38","5","5","Sike wata natane gupmaatang nana kwaapzang siwan kapanga siknga sikaing. Nata gutonga siknga tasikum. Unzing sanga waaknga nae apbut. ");
INSERT INTO wnc_vpl VALUES ("PS38_6","020_38_6","PSA","38","6","6","Sike musip maatangu meya buyambam siknga yuak. Siwan na apmainggat. Siwan tapdukbam butaya natake kwanam asinggan sikgat. ");
INSERT INTO wnc_vpl VALUES ("PS38_7","020_38_7","PSA","38","7","7","Natane gupma toknga siknga katapda binga nasinggak. Siwan na maiu buyambam siknga mainggat. ");
INSERT INTO wnc_vpl VALUES ("PS38_8","020_38_8","PSA","38","8","8","Nata asiknga tuyukake wai siknga yuat. Unzing sanga tapatuta na kekeknga siknga nutapaakusinggak binga. Siwan musipmaatang natapa wai siknga siwan nata tokngabam pake yanggamatanggat. ");
INSERT INTO wnc_vpl VALUES ("PS38_9","020_38_9","PSA","38","9","9","Buyambam tapa, nata musip maatang kekeknga nataat taknga ga atnataayak. Natane musipma kwanamu kumzang sikgak. Sike wa sikgau gae kaikane kusopuknga dua. ");
INSERT INTO wnc_vpl VALUES ("PS38_10","020_38_10","PSA","38","10","10","Sike natane wam nanang puya kekeknga siknga pasinggak. Siwan natane kekekngana kuupbam wena siknga singgak. Siwan natane kaina atzikaawan katak kananga dua singgak. ");
INSERT INTO wnc_vpl VALUES ("PS38_11","020_38_11","PSA","38","11","11","Siwan aminu notnabam nae wesim apnangge apbitakaing. Natane watana kanangge apbitakaing. Siwan natane dongaaya maa yuaing. ");
INSERT INTO wnc_vpl VALUES ("PS38_12","020_38_12","PSA","38","12","12","Siwan aminu atnutapan kupitde nataaing aminda yapapna ba bungepna ngangu na tanggaganuwikge pandakngake peaing. Peke waaminda na tasiwan maiwitde wamu wai yakaing. Siwan asinggan nae waiaknga tasingamuningge nataaing. ");
INSERT INTO wnc_vpl VALUES ("PS38_13","020_38_13","PSA","38","13","13","Sike na katum amin gena kusia apa binga yuke wam yakaingu dua nataat. Sike wam yananga dua singgak. ");
INSERT INTO wnc_vpl VALUES ("PS38_14","020_38_14","PSA","38","14","14","Sike na aminu tapatu wamu dua yanggaak binga. Unzingge wamu yake dua yaninggat. ");
INSERT INTO wnc_vpl VALUES ("PS38_15","020_38_15","PSA","38","15","15","Siwan ngana Buyambam tapa, na gae banip singgat. Buyambam tapa, ga natane Anutuna, tumuk wamu nata ganinggau gata natake gatangamuyo. ");
INSERT INTO wnc_vpl VALUES ("PS38_16","020_38_16","PSA","38","16","16","Na tumuk wamu gae anzing ganikum. Gata natane wama dua kapewi wa tasining takngae baknganing. Ita mateknga pimamba gata waaminu dua kapewi yamandeu sike baknganing. ");
INSERT INTO wnc_vpl VALUES ("PS38_17","020_38_17","PSA","38","17","17","Dasingge, na paa siknga pimanggat. Siwan na musipmaatangu toknga asinggan nataat. ");
INSERT INTO wnc_vpl VALUES ("PS38_18","020_38_18","PSA","38","18","18","Nata gae gutongana yakapmanggat. Siwan nata waiaknga gwa tasikumde butaya nataat. ");
INSERT INTO wnc_vpl VALUES ("PS38_19","020_38_19","PSA","38","19","19","Natane iwana kekekngana kaya aminu buyambam. Aminbamda nae musiptou yumdekan natangamukaing. ");
INSERT INTO wnc_vpl VALUES ("PS38_20","020_38_20","PSA","38","20","20","Sike natanu ie takeakngakan tasiyamunggat. Siwan ngana ita nae yake waiaknga tasikaing. Siwan na takeakngakan tasike tawamba natake ita nanisapdukaing. ");
INSERT INTO wnc_vpl VALUES ("PS38_21","020_38_21","PSA","38","21","21","Buyambam tapa, na ma napmambim. Natane Anutuna, na napmake maa ma yuwim. ");
INSERT INTO wnc_vpl VALUES ("PS38_22","020_38_22","PSA","38","22","22","Buyambam tapa, ga aminu na gatangamunggayak kapanin. Gata na zaat gatangamuyo. ");
INSERT INTO wnc_vpl VALUES ("PS39_1","020_39_1","PSA","39","1","1","Na nina anzingu gwa yakum. Na sanga kuupbam tasiwitdenu katak kayuwit. Ninane genaneta gutonga wamu dua yawit. Ngan, wai aminu nae wesim yuwanu na wamu takngatu dua yawit. ");
INSERT INTO wnc_vpl VALUES ("PS39_2","020_39_2","PSA","39","2","2","Unzingge na gena asumukum. Umuke wamu takngatu dua yakum. Siwan nata wamu sanga takeakngae kuut dua yakum. Siwan ngana musip maatangu meya aknga buyambam siknga sikut. ");
INSERT INTO wnc_vpl VALUES ("PS39_3","020_39_3","PSA","39","3","3","Siwan musip maatang nangayakan natapbum. Nina atnataawakan musip maatang wai siknga sikut. Unzing siwan na gena umutnanga dua. Aho, wamu kundu ayakum. ");
INSERT INTO wnc_vpl VALUES ("PS39_4","020_39_4","PSA","39","4","4","Nata Anutu anzing inikwaikum, Buyambam tapa, na kayuk yuwitdane nakanu datdasing yuaing? Na zaapduknga kupit? Asikaya natane kayuk yutnanga akngana dapaknga ba? Gata naniwi natapit, ngang inikum. ");
INSERT INTO wnc_vpl VALUES ("PS39_5","020_39_5","PSA","39","5","5","Gata tasiwi nata tapduu dapaknga siknga yuke akupit. Sike tapduu nata kayuk yuwit taknga gae kaine sanga moo binga singgak. Aminu kuupbam kayuk yuaing kaknga kawi got taknga binga singgak. Unzing, aminu tapatuta waunga genaneta puyapan kuke wena singgak binga. ");
INSERT INTO wnc_vpl VALUES ("PS39_6","020_39_6","PSA","39","6","6","Aminu kuupbam gunzit siwan katapdane wee kepdakane kaamang binga. Sike waaminu puyambam pasike sanga kwaapzang pakaing. Siwan ngana puyambamu pasikaingu buyana wena singgak. Sike aminbamda sangabam pandakngake unekan peaing. Siwan ngana akupanu sanga wa maminda papik? ");
INSERT INTO wnc_vpl VALUES ("PS39_7","020_39_7","PSA","39","7","7","Siwan ngana Buyambam tapa, na apmanu sanga mina bingae kayuat? Wena. Na baniu gae sike gata gatangamiakgekan yuat. ");
INSERT INTO wnc_vpl VALUES ("PS39_8","020_39_8","PSA","39","8","8","Gata na gatuka take waiakngana kuupbam sandekngamuyo. Sike gata yamandotdong tasikaing aminu dua kapewi na sapdut wamu naniwam. ");
INSERT INTO wnc_vpl VALUES ("PS39_9","020_39_9","PSA","39","9","9","Siwan ngana na wamu dua yawit. Na gena asiknga umumbit. Dasingge, gika siknga meya aknga nae namukyak. ");
INSERT INTO wnc_vpl VALUES ("PS39_10","020_39_10","PSA","39","10","10","Sike na gatuka ma tasiwi maiwam. Gata meya unzing nami na paa kumbum. ");
INSERT INTO wnc_vpl VALUES ("PS39_11","020_39_11","PSA","39","11","11","Aminu wai tasikaingge gata kaanga yanike meya yake ayamunggayak. Siwan gata sangasanga kwaapzangge take nataaingu gata apasiwi sopukaing. Unzing gwakgwakga tauk san napan wai singgak binga. Siakan siknga. Aminu kuupbamu waung kaknga genaneta puyapan akokunggak binga sikaing. ");
INSERT INTO wnc_vpl VALUES ("PS39_12","020_39_12","PSA","39","12","12","Buyambam tapa, natane tumuk wamae natapso. Na gata gatangamiyakge natake gae ganiwa maak gwaang pangamuyo. Sike nata gae ganiwawa maakga ma umumbim. Ga atnataayak. Na keu andakane gaat tapduu opak siknga yuamak ngana na aminu maa tapatu binga yuke kungapunggat. Sike na bapunata yuking binga. Iaya keu andakane tapduu dapaknga sikngakan yuking. ");
INSERT INTO wnc_vpl VALUES ("PS39_13","020_39_13","PSA","39","13","13","Nae meya kumzang ma namim. Gata na atnandutewi musip gwaangu gatu natapit. Siwana na gatukande masande kungwake keu andaka gatukande tewit. ");
INSERT INTO wnc_vpl VALUES ("PS40_1","020_40_1","PSA","40","1","1","Nata Buyambam tapata gatangamikge natayukum. Siwan ita musip kwikwik natangamuke tumuk wamae natapbut. ");
INSERT INTO wnc_vpl VALUES ("PS40_2","020_40_2","PSA","40","2","2","Na unzing aminu tapatu gapma mamaya siknga dakaatang pukuke akumnanga yuak binga yukum. Siwan ngana Buyambam tapata kaiwan akopbum. Na ngwayuk kanzang gwekatang asiknga tanggaganuwan yukum. Siwan ngana ita kaiwan akopa keu supna kaya komune napmamban kekeknga gatu kukum. ");
INSERT INTO wnc_vpl VALUES ("PS40_3","020_40_3","PSA","40","3","3","Siwan gatu ita kau kayuu takngatu taiwitde nanikut. Kau waaknga Anutu ninda banip sikamang kapae umana yatangenatnanga. Siwan nata kau waaknga taiwa aminbamda na nanduke akgwauke Anutue banip sining. ");
INSERT INTO wnc_vpl VALUES ("PS40_4","020_40_4","PSA","40","4","4","Aminu Anutue banip singgak kapa apbakngayok. Aminu unzing kapa yamandet aminkat dua gatake sukukaing. Siwan ita Buyambamtapa dua teke anutu pupukngae munu dua pukgak. Wena siknga. ");
INSERT INTO wnc_vpl VALUES ("PS40_5","020_40_5","PSA","40","5","5","Anutu, Buyambam tapana, gata puya nomanu kwaapzang nin gatanimunangge tasikuyak. Aminu ga binga tapatu wena. Gata asiknga yapbikuyak. Sike nata gae wamu amin yanike puya gata tasinggayakge gatu natdetdet takngakaatde yaniwiu mateknga dua. Mate! Sanga wa kwaapzang siknga. Gata sangabamu nin gatanimunangge pekuyau kendetnanga dua. ");
INSERT INTO wnc_vpl VALUES ("PS40_6","020_40_6","PSA","40","6","6","Siwan gata kaau kuupbam atzipmake katap sawa yasisopuwa waiaknganin sandewiyakge tasikaking kakngae ga apbitakuyak. Siwan ngana gata nae banip tangenawi maak gwaknga kwapan gae wam tawake tasinggat. ");
INSERT INTO wnc_vpl VALUES ("PS40_7","020_40_7","PSA","40","7","7","Tasike anzing yakum, “Ayok. Anutu, na gae gwa aput.” Dasingge, tupa nata apitde wamu buk gomune matakut takngae natake yakum. ");
INSERT INTO wnc_vpl VALUES ("PS40_8","020_40_8","PSA","40","8","8","Anutuna, na gatane mama wamba banipmaatang natapa kekekawan gae banip tawanangge take siknga nataat. ");
INSERT INTO wnc_vpl VALUES ("PS40_9","020_40_9","PSA","40","9","9","Buyambam tapa, nata gatane wamu takeaknga aminbamde ayanikapmanggat. Yanikapmake, Buyambam tapata ninu gatuna apanggak ngang yaninggat. Sike Buyambam tapana, gata wamu wa yanikapmanggatde atnataayak. Nata wamu waaknga asinggan yakapitde nata gena dua umuke yuwit. ");
INSERT INTO wnc_vpl VALUES ("PS40_10","020_40_10","PSA","40","10","10","Nata sanga gata noman nomana tasinggayak kaknga musipmaatangu dua takusopunggat. Aho. Gata wamu yawi kekekakut saak tawake na gatu takuyakge ayanikapmanggat. Siwan gata aminbamde musip gwaang natake gata kepi noman taknga siknga tawake tawanggayakge nata wamu waaknga aminu mitie unekan yuaingune dua takusopunggat. Wena. Nata ayaninggat. ");
INSERT INTO wnc_vpl VALUES ("PS40_11","020_40_11","PSA","40","11","11","Buyambam tapa, na atnataat. Musip kwikwiu gatane aknga nae natangamunangge ma kotnawim. Wena! Gata nae butaya asinggan nataayak. Gata nae take natangamuke gata wam noman takngaka tawanggayak. Waaknga tawake gata na kakuya asinggan tasinggayak. ");
INSERT INTO wnc_vpl VALUES ("PS40_12","020_40_12","PSA","40","12","12","Meya kwaapzang siknga nae apan nata natdetnanga dua singgak. Gutonga aknga nata tasinggat takngata na atnutapan pimake kawa sananga dua singgak. Gutonga aknga kwaapzang sikngata natane gwapak danggama ayapbikgak. Siwan natane musipma tuyuknga siwan na kekekananga dua singgak. ");
INSERT INTO wnc_vpl VALUES ("PS40_13","020_40_13","PSA","40","13","13","Buyambam tapa, gata na gatuka tapso. Gata zet apu gatangamuyo. ");
INSERT INTO wnc_vpl VALUES ("PS40_14","020_40_14","PSA","40","14","14","Aminu kunduta na nuwan kupitde tasikaing. Ge gata aminu wa na nutnangge tasikaingu yaipapaakusike pasiwi datdaptake asiknga maakaning. Siwan waaminu na tasiwa maiwitde apbakngakaingu yanikwasiwi kuwa umana kopsa yuaingu gata asandepakepso. ");
INSERT INTO wnc_vpl VALUES ("PS40_15","020_40_15","PSA","40","15","15","Sandepakepuke waaminu masa wamu nae yakaingu gata pasiwi kepi gutonga tasikaingge apmaakake asiknga satnanong. ");
INSERT INTO wnc_vpl VALUES ("PS40_16","020_40_16","PSA","40","16","16","Siwan aminu gae apukaingga musip gwaang natake gae apbakngake yutnong. Sike aminbamu gata pakuyakge asiknga bakngake yutnong. Bakngake yuke waaminda anzing yaning, “Buyambamtapa tupan sikngaapa,” ngang yaning. ");
INSERT INTO wnc_vpl VALUES ("PS40_17","020_40_17","PSA","40","17","17","Siwan ngana na kekekngana wena. Ge nata nina gatangamunanga dua. Siwan ngana ga Buyambam tapa, gata nae atnatapso. Anutuna, gika siknga gatangamuke tanawawi yuwit. Yuwawa na zet gatangamuke mooka ma nandutewim. ");
INSERT INTO wnc_vpl VALUES ("PS41_1","020_41_1","PSA","41","1","1","Aminu tapatuta umana wena aminde natake gatayamiu, waapa apbakngayok. Buyambam tapata meya ie asapan ngana ita akgatangamik. ");
INSERT INTO wnc_vpl VALUES ("PS41_2","020_41_2","PSA","41","2","2","Buyambam tapata kakuya tasike tapan kekeknga sike kayuk takekan yuwik. Yuke Buyambam tapata tasiwan kepnane takekan yuwik. Yuwan Buyambam tapata iwana dua kapewan apu waapa tasiwan maiwik. ");
INSERT INTO wnc_vpl VALUES ("PS41_3","020_41_3","PSA","41","3","3","Sike aminu waapa mait ba siwanu, Buyambam tapata akayuwik. Ita maitna sandekngaman maitna wena siwan kekeknga gatu yuwik. ");
INSERT INTO wnc_vpl VALUES ("PS41_4","020_41_4","PSA","41","4","4","Siwan na nina anzing yakum, “Buyambam tapa, nata waiaknga gae tasikum. Siwan ngana gata nae musip kwikwik natangamuyo. Natake maitna sandekngamuyo,” ngang yakum. ");
INSERT INTO wnc_vpl VALUES ("PS41_5","020_41_5","PSA","41","5","5","Sike natane iwanata musip maik natangamuke anzing yakaing, “Asikaya mait sike akupik gamu take siwan umana sopuwan ninda ie apbotanim,” ngang yakaing. ");
INSERT INTO wnc_vpl VALUES ("PS41_6","020_41_6","PSA","41","6","6","Iwana waakwakga apu nandukengu kem tanzit wam nanikaing. Waakwakga nae sapdut wam yakaing. Siwan waaminda kepman epu kukenga sapdut wamu waaknga kepna kepna yanitakukaing. ");
INSERT INTO wnc_vpl VALUES ("PS41_7","020_41_7","PSA","41","7","7","Sike iwanambamu nae asiknga bitakaingu natane maitnae kusopuknga wam yakaing. Waaminda nataaingu sanga wai sikngata tasiwan mainanggenggak ngang nataaing. ");
INSERT INTO wnc_vpl VALUES ("PS41_8","020_41_8","PSA","41","8","8","Waaminda anzing yakaing, “Sanga wai siknga tasiwan wai waapa gwa tapan maiu buyambam sikut. Waapa gatu dua enawik. Wena. Waapa akupik,” ngang yakaing. ");
INSERT INTO wnc_vpl VALUES ("PS41_9","020_41_9","PSA","41","9","9","Sike na notna tapatu kaya. Waapaa natane notna siknga. Siwan waapa nanamu naat nakamak. Siwan ngana waapaaya kepina tangenake na nainggamunangge tasinggak. ");
INSERT INTO wnc_vpl VALUES ("PS41_10","020_41_10","PSA","41","10","10","Siwan ngana Buyambam tapa, gata nae musip kwikwik natangamuke maitna sandekngamuyo. Sandekngamina nata yake waaminda ina tasikaing kaknga tasiwit. ");
INSERT INTO wnc_vpl VALUES ("PS41_11","020_41_11","PSA","41","11","11","Sike natane iwanata dua naitakepu napmakaing. Dua naitakepuke napmamban kake na gata nae take siknga natangamunggayak ngangu atnataat. ");
INSERT INTO wnc_vpl VALUES ("PS41_12","020_41_12","PSA","41","12","12","Na kepi noman gan sukuwa nanduke gata na kakuya tasinggayak. Siwan na gae wesim yukgawambitde na katakga asinggan yutzimde takuyak. ");
INSERT INTO wnc_vpl VALUES ("PS41_13","020_41_13","PSA","41","13","13","Buyambam tapatane umana ninda initangenatnim. Sike waapa Isrel nanatane Anutuna. Siwan dongu masan aatningu waamin kaya ina unzakan tasining. ");
INSERT INTO wnc_vpl VALUES ("PS42_1","020_42_1","PSA","42","1","1","Kaap zongu guyaknga kupiawan yanggae isapmake kuke yangga matekngane tangokaing. Ina unzakan, Anutu, na isapmake kuke gae wesim siknga yuwitde take siknga nataat. ");
INSERT INTO wnc_vpl VALUES ("PS42_2","020_42_2","PSA","42","2","2","Anutu, ga kayuk asinggan yuak kapanin. Na gae take siknga nataat. Unzing aminu tapatu guyaknga kupiawan yangga tangopnangge nataak binga. Siwan zaapduk nata gae kuke nata gae munu puwit? ");
INSERT INTO wnc_vpl VALUES ("PS42_3","020_42_3","PSA","42","3","3","Asingganu aminbamda anzing nanikaing, “Gatane Anutuka zendang yuak?” Unzing naniwa na kwanamu asinggan sikgat. Siwan kwakngaom gatu zikaane ngangu nanam asinggan nanggat. Unzing binga, kai yanggana gunzit tapane gatu zikaane ngang epukaing. ");
INSERT INTO wnc_vpl VALUES ("PS42_4","020_42_4","PSA","42","4","4","Na tapduu tupa take yukum komde nataat. Natapa musipmaatang meya singgak. Tupa na aminbampat unekan sukukumang. Siwan na tupan kuke yanipake Anutue yot gwene pake kukum. Ninu unzing kuyuuk ataibakngake kap taiyuuk Anutue gaak inikumang. Inike ninu unekan yuke tapdukngane munu puke inimbakngakumang. ");
INSERT INTO wnc_vpl VALUES ("PS42_5","020_42_5","PSA","42","5","5","Dasingge na meya musipmaatang asingganu nataat? Dasingge na musipmaatang apbinga kasatnanggat? Nata Anutue banip sike kayuwawa ita gatangamik. Sike i Anutuna ge ita akgatangamunggaunin. Unzingge na itane umana gatu yatangenawit. ");
INSERT INTO wnc_vpl VALUES ("PS42_6","020_42_6","PSA","42","6","6","Anutu, nata musipmaatangu meya siknga nataat. Sike na yangga Jordan tapatane kautdu saak yuat. Gatu tawanu Hermon gatu Miza ngang komune yuke gae natanggamatanggat. ");
INSERT INTO wnc_vpl VALUES ("PS42_7","020_42_7","PSA","42","7","7","Gata tasiwi yanggabam gwenu gapma amunandang siknga yuakga gatu uneta amunane siknga yuak gwenda yanggamatanggak. Siwan yangga suptangan zipmake guyakngi muke amundang pukunggak. Pukuke yangga waanga gakngae buyambam yanggak. Gata tasiwi yanggabam gwenu sambui enake kunggak. Kuke kepdaka yanggabam gwenda usukwatapmanggak. Ina unzakan, meya naangan peyaakga na usukwatapmanggak. ");
INSERT INTO wnc_vpl VALUES ("PS42_8","020_42_8","PSA","42","8","8","Siwan ngana Buyambam tapata nae musip kwikwiu gunzit tapane natangamikge nataat. Natake zikaane nata musip gwaang natake kap taike gaak wam iniwit. Inike nata Anutue kayuk yutnanga aknga namunggakge tumuk wam iniwit. ");
INSERT INTO wnc_vpl VALUES ("PS42_9","020_42_9","PSA","42","9","9","Anututa kekeknga nae atnamunggaunin. Siwan ngana nata anzing ininggat, “Dasingge gata nae botanggayak? Dasingge gata natane iwana kapewi na naitakepu tewan na musipmaatang meyambamu panggat?” ");
INSERT INTO wnc_vpl VALUES ("PS42_10","020_42_10","PSA","42","10","10","Asingganu iwanata wamu wai nae anzing yakaing, “Gatane Anutuka apmanu zendang yuak?” Wamu waaknga yakaingu sakutda gupmaapaatang binga napan kumnanga nataat. ");
INSERT INTO wnc_vpl VALUES ("PS42_11","020_42_11","PSA","42","11","11","Dasingge na musipmaatang meyambamu asinggan panggat? Dasingge musipma apbinga kasatnanggak? Na Anutuekan banip sike yuwawa ita akgatangamik. Sike i Anutuna ge ita akgatangamunggaunin. Unzingge nata itane umana apmea yatangenawit. ");
INSERT INTO wnc_vpl VALUES ("PS43_1","020_43_1","PSA","43","1","1","Anutu, aminu gae masa gamukaingga na naitakepu tenangge tasikaing. Gata na asiknga gatangamuke aminu dongu waomune nanatane wamna waiaknga atzipbuyamuyo. Unzing tasiwi nata puya noma nomana tasinggat taknga waaminde yeuyamuyo. Sike kem wam yake tanzit asinggan tasikaing aminu yuyuknga take dua. Gata na gatangamuke waaminde kataune na sandeke tapso. ");
INSERT INTO wnc_vpl VALUES ("PS43_2","020_43_2","PSA","43","2","2","Sike ga natane kekekatna ge nata gae apukenga meya dua kawit. Siwan ngana dasingge ga nae masa namunggayak? Dasingge gata kapewi iwanata na naitakepu tewa meyambamu musipmaatang na pake sukunggat? ");
INSERT INTO wnc_vpl VALUES ("PS43_3","020_43_3","PSA","43","3","3","Gata wamu siakan taknga kakaa binga pewi apu kepi yeikngamuyok. Yeikngaman kepi katak kake na Saionde noman kuwit. Wa tawanu gikane dakanin. Siwana nata you gika yuwaak gwene kuwit. ");
INSERT INTO wnc_vpl VALUES ("PS43_4","020_43_4","PSA","43","4","4","Unzingge Anutu, na gatane alta dakane wesim kuwit. Dasingge? Gata tasiwi na musip gwaang natake apbaknganggat. Sike ga natane Anutuna, nata gwameming daka take tanguwa gakngae noman yawik. Siwana nata kap taike gatane umanda akngae yatangenawit. ");
INSERT INTO wnc_vpl VALUES ("PS43_5","020_43_5","PSA","43","5","5","Siwan dasingge na musipmaatang meyambamu asinggan panggat? Dasingge musipma apbinga kasatnanggak? Na Anutuekan banip sike yuwawa ita akgatangamik. Sike i Anutuna, ge ita na akgatangamunggaunin. Unzingge nata itane umana gatu yatangenawit. ");
INSERT INTO wnc_vpl VALUES ("PS44_1","020_44_1","PSA","44","1","1","Anutu, nindane bapuninda puya kekeknga gata tupa siknga pasikuyakge niniking, kepdakane yuking komune. Niniwan nisa siknga wamu waaknga gwa natapbumang. ");
INSERT INTO wnc_vpl VALUES ("PS44_2","020_44_2","PSA","44","2","2","Gata gika siknga kekekngakata dongu takngatui yanikwasiwi kuwawan kepna pake nindane bapuninde yamukuyak. Siwan une kekeknga yuking. Ngan, gata dongu waakngata waiaknga tasikingge yake meya yamukuyak. Siwan ngana nindane bapunin gatayami take siknga yuking. ");
INSERT INTO wnc_vpl VALUES ("PS44_3","020_44_3","PSA","44","3","3","Siwana bapuninda asaambing. Siwan ngana keu waomu amak tasike dua taking. Asikaya inane kekeknganata gatayaman amau tasike yapbiking? Wena. Gata waaminde take siknga natapbuyak. Unzingge ga waaminkat gatake yuke kakaa yamukuyak. Yamuke gikane kekeknga aknganeta iwana yapbikuyak. ");
INSERT INTO wnc_vpl VALUES ("PS44_4","020_44_4","PSA","44","4","4","Ga kingkapa, siwan natane Anutuna. Gata yawi Jekopdane dongata amau tasike iwana yapbitning. ");
INSERT INTO wnc_vpl VALUES ("PS44_5","020_44_5","PSA","44","5","5","Gatane kekeknga aknganeta iwaninu yawapena kukaing. Gata ninkatang yuwawi aminu ninkat amakamangu yaipapaakusikamang. ");
INSERT INTO wnc_vpl VALUES ("PS44_6","020_44_6","PSA","44","6","6","Na kweem ba sakutna kaya ngana na baniu sanga wanda gatangaman amau apme tasiwit ngangu dua nataat. Na gwauya kuut kaya siwan ngana nata amau tasiwawa ita dua gatangamik. ");
INSERT INTO wnc_vpl VALUES ("PS44_7","020_44_7","PSA","44","7","7","Wena. Gata siknga gatanimi amau tasike iwaninda ninu dua nipbiking. Wena. Gaat gatu iat ngang amake gata ayapbikuyak. ");
INSERT INTO wnc_vpl VALUES ("PS44_8","020_44_8","PSA","44","8","8","Anutu, gata take siknga gatanimiyakge natake ganimbakngakamang. Ganimbakngake asingganu ninda gatane umanda yatangenakamang. ");
INSERT INTO wnc_vpl VALUES ("PS44_9","020_44_9","PSA","44","9","9","Siwan ngana apmanu dasing? Gata ninu masa gwa nimuke ninu iwaninde kaine tasiwi upeekamang. Siwan apmau ga nindane amak aminkat gatuka amakge dua gatake kukaing. ");
INSERT INTO wnc_vpl VALUES ("PS44_10","020_44_10","PSA","44","10","10","Gata unzing tasiwi ninu iwanin kagwauke datakukumang. Datakuwatna ita apu nindane sangaapanin paking. ");
INSERT INTO wnc_vpl VALUES ("PS44_11","020_44_11","PSA","44","11","11","Gata ninu sipsip gwengwen yasikaing binga nisipan kumnimde nindupekuyak. Nindupewawi kepmine yuatna ngana ninikwasikuyak. Ninikwasiwi ninu unda undang kuke paku dongu kundue banakan yuamang. ");
INSERT INTO wnc_vpl VALUES ("PS44_12","020_44_12","PSA","44","12","12","Gata ninu gikane amindabamu nindupewi dongu kundutane puya amina moo dakngakamang. Siwan ita ga buyana matekngata usiking. Gata supzainu buyambam dua pakuyak. ");
INSERT INTO wnc_vpl VALUES ("PS44_13","020_44_13","PSA","44","13","13","Gata ninu unzing pasiwi dongu kundu ninde wesim yuaingga sapdut wam ninikaing. Ngan, aminu kunduta atninimike maaknga wam ninikaing. ");
INSERT INTO wnc_vpl VALUES ("PS44_14","020_44_14","PSA","44","14","14","Gata pasiwi enake ie ninu dongu kunduta maaknga umaninu yakaing. Sanga kundu ninkatang aawan kakengu kumzang siknga ninimikaing. ");
INSERT INTO wnc_vpl VALUES ("PS44_15","020_44_15","PSA","44","15","15","Nina natapa wai asinggan siwan na maaknga siknga nataat. ");
INSERT INTO wnc_vpl VALUES ("PS44_16","020_44_16","PSA","44","16","16","Dasingge? Aminu kunduta sapdut wam nanike wamu waiaknga nanikaing. Sike kaawanu iwanaat gatu aminu kunduatda waiaknga yake nae tasinangge nataaing. ");
INSERT INTO wnc_vpl VALUES ("PS44_17","020_44_17","PSA","44","17","17","Anutu, ninu gae dua botakumang. Aho! Gatane pasap wamba ninu dua yamasandemang. Siwan ngana sanga wa ninkatang apbut. ");
INSERT INTO wnc_vpl VALUES ("PS44_18","020_44_18","PSA","44","18","18","Ninu gae masa dua gamuke gatu gatane kepiakngaka dua tekumang. ");
INSERT INTO wnc_vpl VALUES ("PS44_19","020_44_19","PSA","44","19","19","Siwan ngana gata ninu amina wena, kaap zonggakan yuaing komune pasiwi maikumang. Siwan ninu zikaa siknga dakata usikwatanimukuyak. ");
INSERT INTO wnc_vpl VALUES ("PS44_20","020_44_20","PSA","44","20","20","Ninda Anutue gwamba botakumang? Botake tumuk wamu anutu pupukngae ba yanim? ");
INSERT INTO wnc_vpl VALUES ("PS44_21","020_44_21","PSA","44","21","21","Gatanu atnatapiak. Anututa natdetdeu ninde musipatang kusopuke yuaingu atnataak. ");
INSERT INTO wnc_vpl VALUES ("PS44_22","020_44_22","PSA","44","22","22","Anutu, ninu gatane amindabamda yuamang. Unzingge ninu tapdukbam asinggan nisipa kungwakamang. Iwaninda ninu nindupanu sipsip binga atnisipan kumnimdekan. ");
INSERT INTO wnc_vpl VALUES ("PS44_23","020_44_23","PSA","44","23","23","Buyambam tapa, ga enayo. Dasingge ga dapunu pekgayak? Ga enayo. Gata masa asingganu ninde ma nimim. ");
INSERT INTO wnc_vpl VALUES ("PS44_24","020_44_24","PSA","44","24","24","Dasingge ga ninde kusopunggayak? Aminda ninde wai pasiwa ninu meyambam pake yuamang. Ninda meya wa pakamangge dua botawim. ");
INSERT INTO wnc_vpl VALUES ("PS44_25","020_44_25","PSA","44","25","25","Ninu kepatang pimakamang. Siwan gupminu gwa kupsa amindane gupnata binga pekaing. ");
INSERT INTO wnc_vpl VALUES ("PS44_26","020_44_26","PSA","44","26","26","Anutu, gata enake apu gatanimuyo. Ga butaya natanimunggayakapanin ge gata gatuka papi ninu dua kumnim. ");
INSERT INTO wnc_vpl VALUES ("PS45_1","020_45_1","PSA","45","1","1","Natane natdetdetna atangu wamu takeaknga aknga kwaapzang yuaing. Kau takngatu natake getangan king kapae iniwitde nataat. Natane gena penu aminu pepa matanggau take apata matanggak binga. ");
INSERT INTO wnc_vpl VALUES ("PS45_2","020_45_2","PSA","45","2","2","Ga aminu sikngaapa. Aminu tapatu ga binga dua yuak. Gata wamu yanggau Anututa gatanggaman takeakngakan yanggayak. Dasingge, ita ga asinggan asinggan take tasinggamik. ");
INSERT INTO wnc_vpl VALUES ("PS45_3","020_45_3","PSA","45","3","3","Ga kingu kekeknga sikngaapa. Siwan umanda kopsa aknga enane siknga yuak. Unzing ga taau gwaam gwaamu kwaapzang take wamanggayak binga. Siwan gata gwauyaka pandakngake amak tasinangge tandakngayo. ");
INSERT INTO wnc_vpl VALUES ("PS45_4","020_45_4","PSA","45","4","4","Ga Kingu tupan tapa, umanda kayaapa yuayak. Gata ikwawa gamanu hos gwene pukwike kuku amak tasike yapbikgaunin. Gata kuku amau tasinggaau wa noman amin gatayamunangge tasiyo. Tasiwi kepi noman tapa tawaningge. Ngan, inane umana dua yatangenatningge. Gata amau kekeknga siknga tasiwi wai aminda ganduke gwauya siknga natapnong. ");
INSERT INTO wnc_vpl VALUES ("PS45_5","020_45_5","PSA","45","5","5","Gatane sakutda paanga siknga, siwan ita iwanda siakande yamningge tasiyo. Gata amak tasike yapbimbi gae gepbiatang koyutnong. ");
INSERT INTO wnc_vpl VALUES ("PS45_6","020_45_6","PSA","45","6","6","Anutu, ga king kapa dakngake asinggan asinggan yuayak. Gata amindabamu kepi noman taknganekan kayuayak. ");
INSERT INTO wnc_vpl VALUES ("PS45_7","020_45_7","PSA","45","7","7","Ga sanga noman takngaekan gwaam siknga natake waiakngae ga asiknga bitanggayak. Unzingge gikane Anutukata yangga wel taknga gwapakgane tukngwanggamuke tasiwan umanda kaapa dakngakuyak. Siwan ita tasiwan gata notda yapbike umanda kopsa apa dakngake apbakngakuyak. ");
INSERT INTO wnc_vpl VALUES ("PS45_8","020_45_8","PSA","45","8","8","Sike gatane taukga aknga sanga kapanga kaa tasiwi taukga kapanga kaa siknga singgak. Siwan king kapatane yotna sanga kwaknga siknga dundumna siknga tasigwaanguke kap taikaing. Siwan kau waaknga taiwawa gata baknganggayak. ");
INSERT INTO wnc_vpl VALUES ("PS45_9","020_45_9","PSA","45","9","9","Sike king kapa apatane yapanaat gatu maya kundu gata tasiwi umana kaya dakngakingkat yuaing. Sike katakga kwanaapane maya gata maatdae takuyak kapata dandamake yuak. Ita tauknga sanga golmani ngang yanikaingu you gapmandu Ofir gapmane nanata pasikingunin pasikut. ");
INSERT INTO wnc_vpl VALUES ("PS45_10","020_45_10","PSA","45","10","10","Ga maya mateu king kapa apbae tanangge nataau, gata nae wam gwaamuke anzing natapso. Gata aminu yotda yuaingge apbotayo. Gatu gikandak notda sikngae kuut botayo. ");
INSERT INTO wnc_vpl VALUES ("PS45_11","020_45_11","PSA","45","11","11","Gata unzing tasiwi king kapata ganduke maya aapa take siknga ngang natanggamunggak. Waapa gatane buyambam tapaka, unzingge gata itane wam gwaamumso. ");
INSERT INTO wnc_vpl VALUES ("PS45_12","020_45_12","PSA","45","12","12","Sike aminu Tair yotbam gapmane nanata sanga kundu gae gamunangge pakapning. Ngan, sanganambambanu waakwakge gata musip gwaang natayamiyakge sanga sanga gae gamuning. ");
INSERT INTO wnc_vpl VALUES ("PS45_13","020_45_13","PSA","45","13","13","Maya mateu kinggane waapa yotna inatakan pekgak gwekatang yuwan kana gwaam siknga singgak. Sike tauknga sanga tretgol ngang yanikaingga pasikaingunin pasike yuak. ");
INSERT INTO wnc_vpl VALUES ("PS45_14","020_45_14","PSA","45","14","14","Sike tauknga waaknga kunzi inata inata pasiking. Siwana kuupbamda maya waapa kingge takuuning. Siwan gatu maat matek notna apa apa iat gatake masene tawamba kuning. ");
INSERT INTO wnc_vpl VALUES ("PS45_15","020_45_15","PSA","45","15","15","Waakwakga apbakngake musip gwaangu kuutnata natake king kapatane yotna buyambam gwekatangu kopning. ");
INSERT INTO wnc_vpl VALUES ("PS45_16","020_45_16","PSA","45","16","16","Sike ga king kapa, masande gatane waakga kwaapzang siwik. Siwana itaa gatane bapuka tupa aaking ge tangge yutning. Waakga waakwau umana kaa siwan waakwakga aminu kepna kepna yuaingunin kayutning. ");
INSERT INTO wnc_vpl VALUES ("PS45_17","020_45_17","PSA","45","17","17","Nata gatane umanda kopsa aknga yakapa aminu apmea aatningga masande gae asinggan natayutning. Unzing tasike aminu kepna kepna yuaingga gae umanu asinggan asinggan yatangenatning. ");
INSERT INTO wnc_vpl VALUES ("PS46_1","020_46_1","PSA","46","1","1","Anutu ninda akusopunanga apa unin. Sike ita ninu asinggan papan kekekakamang. Ita kaawan ninu meya takngatuta ba papan kakengu inengan yutniwake gatanimunangge atandakngake yuak. ");
INSERT INTO wnc_vpl VALUES ("PS46_2","020_46_2","PSA","46","2","2","Unzingge sanga takngatuta aawan kanimdenu dua gwautnim. Keu andaka miamunda tasiwan take dewik ba take pukapik. Siawan tawan dakandaka puke yanggabam gwende banakan katang pimapan kakengu ninda ie dua gwautnim. ");
INSERT INTO wnc_vpl VALUES ("PS46_3","020_46_3","PSA","46","3","3","Siwan yanggabam gwenda pongza siknga tapmake unda undang kuwawan aapban gwen siwik. Siwan yanggabam gwenda gatu saasaa sike tawanu kuupbam pamakaiwik. Siwan ngana undanga. Ninda dua gwautnim. ");
INSERT INTO wnc_vpl VALUES ("PS46_4","020_46_4","PSA","46","4","4","Anututane yotna gapma wa Anutu enane siknga yuak kapata inae gwa yawan yuak. Yangga buyambamu tapatu wa gapmae banakan zipmanggak. Siwan aminu banip siata yangga waapane apbakngake yuaing. ");
INSERT INTO wnc_vpl VALUES ("PS46_5","020_46_5","PSA","46","5","5","Anutu yotbamu wanggapmane yuak. Unzingge itane yotbam gapma wai sinanga dua. Keu dua kwakaawan Anututa akgatangamik. ");
INSERT INTO wnc_vpl VALUES ("PS46_6","020_46_6","PSA","46","6","6","Siwan aminu kepna kepna nanata asatnake ina amning. Siwan aminu waakwakat gatu king kapanaat apimaning. Siwana Anututa akaapmapa yawan keu andaka aknguyukake sopuwik. ");
INSERT INTO wnc_vpl VALUES ("PS46_7","020_46_7","PSA","46","7","7","Buyambamtapa kekekngana bamban tapa nikat yuamang. Jekopdane Anutunae ninda kuke undang kusopunim. ");
INSERT INTO wnc_vpl VALUES ("PS46_8","020_46_8","PSA","46","8","8","Ayok! Ginda Buyambam tapata puya pasinggak kaknga kanong. Ginda musipzane Buyambam tapata sanga takngatu takngatu kepdakane tasinggaunin kaning. ");
INSERT INTO wnc_vpl VALUES ("PS46_9","020_46_9","PSA","46","9","9","Sike amau kepna kepna tasikaingu ita tasiwan amak kaknga akupan wena siknga singgak. Ita kweemna gatu sakutna ngang aputdakngake tiungguna kuut kuupbam katap patang sapewan yasikaing. ");
INSERT INTO wnc_vpl VALUES ("PS46_10","020_46_10","PSA","46","10","10","Ita anzing yanggak, “Ginu amau gatusa ma tasiwam. Ginda nae anzing siknga natapnong. Na Anutu siknga. Na enane siknga yuwa aminbamu nae gepbiatang koyutning. Sike kepna kepna yutake kukaing amindane na tupan siknga apa yuat,” ngang yanggak. ");
INSERT INTO wnc_vpl VALUES ("PS46_11","020_46_11","PSA","46","11","11","Buyambamtapa kekekngana bamban tapa nikat yuamang. Ninda Jekopdane Anutunae kuke undang kusopunim. ");
INSERT INTO wnc_vpl VALUES ("PS47_1","020_47_1","PSA","47","1","1","Ginu aminu kuupbam apbakngake katakza wesinong. Bakngake ginda asainggamatake kaau pangenawan kuwan taike Anututane umana aknga yatangenatnong. ");
INSERT INTO wnc_vpl VALUES ("PS47_2","020_47_2","PSA","47","2","2","Dasingge, ninda Buyambam tapae asiknga gwautnim. Buyambamtapa waapa enane siknga yuak. Ita kingu tupantapa yuke aminbamu kepna kepna yuaingu kakuya tasinggak. ");
INSERT INTO wnc_vpl VALUES ("PS47_3","020_47_3","PSA","47","3","3","Ita dongu kundutane umana kuupbam sandepakepuke pasiwan ninu enane yuamang. Ngan, ita tasiwan dongu kundu ninde gepbiatang koyuaing. ");
INSERT INTO wnc_vpl VALUES ("PS47_4","020_47_4","PSA","47","4","4","Anututa keu komdu yawan yuwan ninde gwa nimukut. Ninu Jekopdane donga, Anututa musip gwaangu ninde natanimunggak. Siwan keu waomde apbakngake yuamang. ");
INSERT INTO wnc_vpl VALUES ("PS47_5","020_47_5","PSA","47","5","5","Anutu yotna yekaune gwa kopbut. Sike tapduu Buyambam tapata wa kopbut gwene aminu apbakngake kumzang ainggamatake pumu kuut puyapbing. ");
INSERT INTO wnc_vpl VALUES ("PS47_6","020_47_6","PSA","47","6","6","Ayok, ninda kau pangenake taike Buyambam tapatane umana yatangenatnim. Ninda nisane kingu waapae apbakngake kau tainim. ");
INSERT INTO wnc_vpl VALUES ("PS47_7","020_47_7","PSA","47","7","7","Dasingge, Anutu king siknga yuke kepna kepna kuupbam kayuak. Ninda unzingge kau taike umana aknga ayatangenatnim. ");
INSERT INTO wnc_vpl VALUES ("PS47_8","020_47_8","PSA","47","8","8","Anutu king siknga yuke dongu aminu kuupbam kayuak. Ita king kapa ge inane sia king dakanane pukwike yuak. ");
INSERT INTO wnc_vpl VALUES ("PS47_9","020_47_9","PSA","47","9","9","Sike amindane tupan amin tapaapa aminu Abrahamdane Anutuna tawakaingkat unekan gatake yuaing. Dasingge, kingu kepna kepna nana kuupbamu aminu Anututanekan. Ita king tupan tapa enane siknga yuak kapanin. ");
INSERT INTO wnc_vpl VALUES ("PS48_1","020_48_1","PSA","48","1","1","Buyambamtapa umana kopsa apa yuak. Ninda tawanu Anututane dakane kopna. Koke itane yotbam gapmaatang kopna. Koke ninda itane umana kumzang yatangenatnim. ");
INSERT INTO wnc_vpl VALUES ("PS48_2","020_48_2","PSA","48","2","2","Sike Anututane tawanu wandaka enane siknga yuwan kana take siknga singgak. Siwan aminu kepna kepna yuaingga tawanu Saion wandakae take siknga nataaing. Tawanu wandakane Anutu kopsa apatane umana yuak. Siwan yotbamu wanggapma kingu tupan tapatane. ");
INSERT INTO wnc_vpl VALUES ("PS48_3","020_48_3","PSA","48","3","3","Sike Anutu yot gapmabamu damanu kekeknga siknga gwegwende yuke aminu amak tapduk kopatangu akgatayamunggak. Unzing gatayaman you kekeknga gwegwende banakan katang take yuaing. ");
INSERT INTO wnc_vpl VALUES ("PS48_4","020_48_4","PSA","48","4","4","Tupa king takwakga Saionde amnangge tasiking. Waakwakga unekan yuke yotbamu wanggapmane inengan apbing. ");
INSERT INTO wnc_vpl VALUES ("PS48_5","020_48_5","PSA","48","5","5","Waaminu kuku yotbam wanggapma kake zeetgaman akasatnaking. Kasatnake asiknga gwauke waakwau atdatakuking. ");
INSERT INTO wnc_vpl VALUES ("PS48_6","020_48_6","PSA","48","6","6","Datakuke dandai kumzang yamuking. Dandai yamumban atdatakukingu wa unzing mayata engang bokngitnangge toknga nataaing binga sikut. ");
INSERT INTO wnc_vpl VALUES ("PS48_7","020_48_7","PSA","48","7","7","Anutu, gata tasiwi gou buyambamu gunzitda akonggak kopatangga apbut. Apuke yotbamu Tarsis nanatane sipna buyambam gwegwenu apasiwan maiking. ");
INSERT INTO wnc_vpl VALUES ("PS48_8","020_48_8","PSA","48","8","8","Ninu sanga wa Anututa tupa siknga tasikutdane wamu yawan atnatapbumang. Gatu apmaat kaa tasiwan gatunin kakumang. Ninu Buyambam tapatane yotbam gapmane yukumang. Anutu nindane apan, wa Anutu kekekngana kuupbam kayakan. Sike nindeaan sanga waaknga tasikut. Anututa yotbam gapma gwa tapan kekekakutde yotna gapma asinggan yuwik. ");
INSERT INTO wnc_vpl VALUES ("PS48_9","020_48_9","PSA","48","9","9","Anutu, ninu gatane miti yot buyambam gwekatang yuamang. Yuke ninu ga ninde butaya asinggan natanimunggayak kakngae natanggamatakamang. ");
INSERT INTO wnc_vpl VALUES ("PS48_10","020_48_10","PSA","48","10","10","Sike kepna kepna yuaingu aminu kuupbamda gatane umanda ayatangenakaing. Gatu aminu zendang zendangga yuaingu gatane umanda akngae apbakngakaing. Gata aminu kuupbam noman taknganekan kayuak. ");
INSERT INTO wnc_vpl VALUES ("PS48_11","020_48_11","PSA","48","11","11","Unzingge aminu tawanu Saion dakane yuaingu kuupbam apbaknganing. Gata aminu kuupbam noman taknganekan usanzikgaak. Unzingge aminu yotbamu Juda komune nanata asiknga baknganing. ");
INSERT INTO wnc_vpl VALUES ("PS48_12","020_48_12","PSA","48","12","12","Ginda kepi kepi tawanu Saion dakane sukunong. Gatu damanu yot wanggapma takumbasikuune kuyuuk you kundu mamaya gwegwenu you wa gapma tasiwan kekeknga singgau kendetnong. ");
INSERT INTO wnc_vpl VALUES ("PS48_13","020_48_13","PSA","48","13","13","Ginda Saiondane damanu kekeknga siknga gwegwende katak siknga natapnong. You kekeknga gwegwende kuut katak kanong. Kakenga aminu masan aatningu ginda yanikapnong. ");
INSERT INTO wnc_vpl VALUES ("PS48_14","020_48_14","PSA","48","14","14","Ginda anzingu take yanining, Anutu waapata kakuya ninu tasike asinggan asinggan ninduyuak kapanin. Ge asinggan asingganu ita tupan kuke kepi ninde yeutnimunggak. ");
INSERT INTO wnc_vpl VALUES ("PS49_1","020_49_1","PSA","49","1","1","Ginu aminu kuupbam, natapnong. Ginu aminu kuupbam kepna kepna yuaingga maak gwaang pake natane wamde natapnong. ");
INSERT INTO wnc_vpl VALUES ("PS49_2","020_49_2","PSA","49","2","2","Ginu umanza kaya aminkat umanza wena aminkat gatu sangabamna kayaat sangana wenaat ginu wamu aaknga katak natapnong. ");
INSERT INTO wnc_vpl VALUES ("PS49_3","020_49_3","PSA","49","3","3","Natane genanetanu wamu musip kwikwikganekan yanggat. Unzingge nata wamu take akngakan daniwawa natdetdet damikgen. ");
INSERT INTO wnc_vpl VALUES ("PS49_4","020_49_4","PSA","49","4","4","Na tuwang wamu kundu gambok daniwit. Gatu gwameming daka tanguyuuk tuwang wamdane yapii daniwit. ");
INSERT INTO wnc_vpl VALUES ("PS49_5","020_49_5","PSA","49","5","5","Aminu kunduta na takumbasike tasiwa maiwitde tasikaing. Siwan ngana nata waaminde dua gwaumbit. ");
INSERT INTO wnc_vpl VALUES ("PS49_6","020_49_6","PSA","49","6","6","Sike waaminda ninu moninginbam bande apme kekekanimik ngang nataaing. Natake ninu sanganin bamban ngang wamu kaapmapa yakaing. ");
INSERT INTO wnc_vpl VALUES ("PS49_7","020_49_7","PSA","49","7","7","Ninu atnataamang. Aminu tapatuta notna dua kupikge natake inane moningata usinanga dua. Aho. Ita Anutue kayuk asinggan asinggan yutnanga akngana moningga usinanga dua. Wena siknga. ");
INSERT INTO wnc_vpl VALUES ("PS49_8","020_49_8","PSA","49","8","8","Dasingge? Amin usinanga aknga buyana enane siknga. Sanga wa usinanga dua. ");
INSERT INTO wnc_vpl VALUES ("PS49_9","020_49_9","PSA","49","9","9","Aminda Anutu dua usiwan kayuk yutnanga aknga iman kayuu asinggan yuke dua kupik. ");
INSERT INTO wnc_vpl VALUES ("PS49_10","020_49_10","PSA","49","10","10","Ninu kuupbamda akaamang. Ngan, natdetdet aminu akungwakaing. Sike yamandotdong aminkat gatu katum aminkau akungwakaing. Waaminu kungwake moninga ba sangana ngang pewa aminu kunduta paning. ");
INSERT INTO wnc_vpl VALUES ("PS49_11","020_49_11","PSA","49","11","11","Tupa aminu waakwau kepna kake aminu kuupbamda keu waamindane ngang natapbing. Siwan ngana apmanu aminda kupan kwaiya gapma yotna binga dakngawan une asinggan asinggan yutning. ");
INSERT INTO wnc_vpl VALUES ("PS49_12","020_49_12","PSA","49","12","12","Aminu umana kaya akwau kungwak kakngata yapbitnanga dua. Siwan waaminu kaap zongga kungwakaing binga kumning. ");
INSERT INTO wnc_vpl VALUES ("PS49_13","020_49_13","PSA","49","13","13","Sanga unzing kaknga aminu baniu ineakan sike sanga panggaganukaing gekan apik. Siwan aminu kunduta waamindane wamna take natake tawaning. Sike aminu waakwakge sanga unzing kaknga asapik. ");
INSERT INTO wnc_vpl VALUES ("PS49_14","020_49_14","PSA","49","14","14","Anututa waakwau sipsipda binga kungwake paku gwakumbingga yuaing komune yutningge yawan yuaing. Siwan kungwak kakngata kuyana ita kayuwik. Tembana aminu noman nomana aminda aminu waakwau kayutning. Sike ngana yotna take siknga apekaing gwegwen peke epanu gupna gatukande bukana sikaing. Siwanu wa gwa kupsa aminda yuaing komune yuaing. ");
INSERT INTO wnc_vpl VALUES ("PS49_15","020_49_15","PSA","49","15","15","Siwan ngana Anututa na atapik. Atapan gwa kupsa aminda yuaing komune nana kekeknga akngata na tanggaganutnanga dua. Aho. Ita na tapan naat iat gatake asinggan asinggan yutzim. ");
INSERT INTO wnc_vpl VALUES ("PS49_16","020_49_16","PSA","49","16","16","Sike aminu tapatu moninga kwaapzang ba siwik. Siwan yotna buyambam gwendu mitapik. Mitake sangabamu paku undang pewik. Undanga. Ga ie nangaakan ma natapim. ");
INSERT INTO wnc_vpl VALUES ("PS49_17","020_49_17","PSA","49","17","17","Ga atnataayak. Masande waapa akupik. Siwan sanga tapatu dua take inaat kusan. Sangana kuupbam dua pake akupsa aminda yuaing komune kuwik. ");
INSERT INTO wnc_vpl VALUES ("PS49_18","020_49_18","PSA","49","18","18","Sike tapduu kayuk yukut komunenu sangana waakwakge apbakngakut. Ita puya kekeknga pasike sangabam pakut. Siwan aminda yake aapa take siknga, ngang yaking. ");
INSERT INTO wnc_vpl VALUES ("PS49_19","020_49_19","PSA","49","19","19","Siwan ngana undanga. Waapa akungwakengu paku bapunaat gunzitdane kakaa gatuna dua kaaing komune yutning. ");
INSERT INTO wnc_vpl VALUES ("PS49_20","020_49_20","PSA","49","20","20","Aminu umana kaya akwau kungwak kakngata yapbitnanga dua. Siwan waaminu kaap zongga kungwakaing binga kumning. ");
INSERT INTO wnc_vpl VALUES ("PS50_1","020_50_1","PSA","50","1","1","Anutu kekekngana bamban tapa. Waapa nindane Buyambam tapanin. Ita apmanu aminu kuupbamde yayawanggak. Tupanu keu gunzitda akonggak komuneta kuku gunzitda pukunggak komune ita aminu kepna kepna yuaingunin yayawanggak. ");
INSERT INTO wnc_vpl VALUES ("PS50_2","020_50_2","PSA","50","2","2","Anutu you Saion gapmane yuak. Yotbamu wanggapma take siknga siwan dundumna siknga. Siwan Anututane kakaa aknga anggaman yuak. ");
INSERT INTO wnc_vpl VALUES ("PS50_3","020_50_3","PSA","50","3","3","Anututa ninde asapik. Sike waapa dua wikake yuke apik. Wena siknga. Katap gwenu sangabam yasiwan kumnanga tupan kuwik. Sike gotkat sopaat kumzang siknga unin takumbasiuuk apik. ");
INSERT INTO wnc_vpl VALUES ("PS50_4","020_50_4","PSA","50","4","4","Ita aminu yekapat gatu kepdakane nana yayawaawan apa waamindane yuyuknga katak siknga usanziwik. ");
INSERT INTO wnc_vpl VALUES ("PS50_5","020_50_5","PSA","50","5","5","Anututa anzing yanggak, “Natane aminabam, nae apan unekan yutnim. Gikat gatu naat pasap taknga tasinangge natake ginda kaau nae pasap waaknga tapan kekekawikge namuking,” ngang yanggak. ");
INSERT INTO wnc_vpl VALUES ("PS50_6","020_50_6","PSA","50","6","6","Siwan sanga yekapatang yuaingga yeutniman kake ninda Anutu noman sikngaapa ngang nataamang. Dasingge, Anutu ina amin usanzikgak kapanin. ");
INSERT INTO wnc_vpl VALUES ("PS50_7","020_50_7","PSA","50","7","7","Siwan Anututa yanggak, “Ginu natane aminabam, natapnong. Na ginde wamu kaa. Ginu Isrel amin, nata ginu kotde pakuwa yaningge nataat. Nakan, na Anutu siknga. Na gindane Anutusa. ");
INSERT INTO wnc_vpl VALUES ("PS50_8","020_50_8","PSA","50","8","8","Ginda sanga nae namukainggenu kaanga dua daninggat. Wena. Asingganu nata danduwawa sanga nae namunangge natakengu katapatang sake namuwawa kake take nataat. ");
INSERT INTO wnc_vpl VALUES ("PS50_9","020_50_9","PSA","50","9","9","Sike ngana natanu kao wawigwen ba meme wawi gwenu damanzane panangge dua nataat. Ie nata dua dapmanggat. Wena. ");
INSERT INTO wnc_vpl VALUES ("PS50_10","020_50_10","PSA","50","10","10","Kaap zongu zongaatang yuaingkat gatu kao tawan dakandakaatang yuaingu, wa kuupbam natanekan. ");
INSERT INTO wnc_vpl VALUES ("PS50_11","020_50_11","PSA","50","11","11","Kwait gwegwen, kaapzong gatu gwakgwau sakganang tangaatang sukukaingu, wa kuupbam natanekan. ");
INSERT INTO wnc_vpl VALUES ("PS50_12","020_50_12","PSA","50","12","12","Sike na tomma natakengu nata dua danikapa natapning. Wena. Kepdakaat gatu sanga une yuaingu, wa kuupbam natanekan. ");
INSERT INTO wnc_vpl VALUES ("PS50_13","020_50_13","PSA","50","13","13","Asikaya na kao wawi gwendane gamanggamai apba nanggat? Asikaya na meme wawi gwendane daknga apba tangokgat, ba? Wena! ");
INSERT INTO wnc_vpl VALUES ("PS50_14","020_50_14","PSA","50","14","14","Ateke ginda na Anutue gaak gwaang naninong. Wa sanga unzing kaknga ginda nae namunangge gwa yakingu na Anutu enane siknga yuat tapae ginda wa atnamunong. ");
INSERT INTO wnc_vpl VALUES ("PS50_15","020_50_15","PSA","50","15","15","Ginda unzing tasiwawa meya takngatuta apan kakengu ginda nae take yaning. Yawa nata ginu asiknga gatandamit. Gatandama ginda natane umana yatangenatnong.” ");
INSERT INTO wnc_vpl VALUES ("PS50_16","020_50_16","PSA","50","16","16","Siwan ngana wai aminde Anututa anzing yaninggak, “Ginda dasingge natane mama wama kuupbamde yakaing? Gatu, minae natane pasap wama yakaing,” ngang yaninggak. ");
INSERT INTO wnc_vpl VALUES ("PS50_17","020_50_17","PSA","50","17","17","“Nata gin panomanuwitde dua nataaing. Asingganu ginda nae wam yamasandekaing. ");
INSERT INTO wnc_vpl VALUES ("PS50_18","020_50_18","PSA","50","18","18","Ginda kukwa amin kake notza dakngawan yuaing. Gatu ginu mayata apna sandekgak ba wawita maatna sandeke yasewa yumdekan tasikaing aminkat sukukaing. ");
INSERT INTO wnc_vpl VALUES ("PS50_19","020_50_19","PSA","50","19","19","Ginu genza dakaneta wamu waiaknga ba kem wamu asinggan yakaing. ");
INSERT INTO wnc_vpl VALUES ("PS50_20","020_50_20","PSA","50","20","20","Gatu ginda notzaapa kot yaningge pakukaing. Pakuke waaminde ginda masa wam yanikaing. Sike ginda sapdut wamu minggatane waakngae inisapdukaing. ");
INSERT INTO wnc_vpl VALUES ("PS50_21","020_50_21","PSA","50","21","21","Ginda unzing tasiwa danduke ngana na wamu takngatu dua yakum. Unzingge ginda naenu ninkat unzakan yuamang ngang nataaing. Siwan ngana wena siknga. Nata apmanu kaanga danike pasiwa kotde wamu aanggaman yaning. ");
INSERT INTO wnc_vpl VALUES ("PS50_22","020_50_22","PSA","50","22","22","Ginu aminu nae masa namukaingu ginu natapnong. Ginu ina unzakan yuwan kakengu nata ginu apasiwa maining. Siwan aminu tapatuta ginu gatu pananga dua. ");
INSERT INTO wnc_vpl VALUES ("PS50_23","020_50_23","PSA","50","23","23","Aminu tapatuta nae gaak nanike sanga kundu binga namiu, waapata natane umana ayatangenakgak. Sike natanu aminu nae wam tawakaingu, nata waaminu gatuna apapit.” ");
INSERT INTO wnc_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","Anutu, ga butaya akngatane yapii. Siwan gata nae musip kwikwik natangamuyo. Ga musip kwikwikga buyambamu kayaapa. Unzingge gata waiakngana kuupbam sandekngamuyo. ");
INSERT INTO wnc_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","Gata tasiwi natane waiakngana kaikane sandewi wena siyok. Unzing nata yangga sauwa wasapma wena singgak binga. Ngan. Gata natane waiakngana kuupbam sandekngami nata amin nomanda yuwit. ");
INSERT INTO wnc_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","Na atnataat. Nata gutonga aknga aknga asinggan pasinggat. Unzingge waakwau pasinggatde botananga dua singgak. ");
INSERT INTO wnc_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","Nata waiaknga wa pasikumu gaekan pasikum. Ngan. Nata wai takngatu takngatu wa tasikumu gae kaikane tasikum. Unzingge gata kepi noman takngakan tawake na usanzike kaanga wam naniwinu siakan siwik. ");
INSERT INTO wnc_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","Ga atnatayak, tapduu mingata na tangaikut gwene na aminu waiaknga tasiya amin dakngakum. Sike musipganang yukum patangu na waiaknga tasiya amin dakngake yukum. ");
INSERT INTO wnc_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","Siwan ngana ga nata wamu siakan takngakan asiknga tawambitde natayak. Unzingge na gata natdetdetda noman taknganin nanindamumbiyakge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","Gata natane waiakngana sandekngami nata dundumna amin dakngake yuwit. Gata yanggata binga saukngami aminu wasapna wena siknga binga dakngake yuwit. Dakngake yuwawa natane waiakngana gatane kaikane wena siknga siwik. ");
INSERT INTO wnc_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","Gata musipma tasiwi apbakngayok. Siakan siknga! Gata nae waiaknganae meya namukuyak. Namuke natane kwatana zipmanggamumbi apuking ngana gata na tasiwi kwatana waapa apata gatuna take siwanu nata apbakngawit. ");
INSERT INTO wnc_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","Gata waiaknga tasikumde undang gatuka ma kawim. Siwan gata natane gutongana kuupbam asandekngamuyo. ");
INSERT INTO wnc_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","Anutu, gata natane musipma tangenawi na musipma kayuk ba dundumna siwikge nataat. Gata natane waunga tangenake na waungu kayukapa naatang tengami nata gaekan natanggamatawa kekekayok. ");
INSERT INTO wnc_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","Siwan gata na ma nanikwasiwi kuwam. Waungu takwan gataneapa naatang yuau gata ma kaiwi kuwan. ");
INSERT INTO wnc_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","Tupa gata na takuyakge apbakngakum. Ge apman kaya gata na gatuka tapi nata gatuna apbakngawit. Gata gatuka tasike natane musipma tangenawi nata gae wam tawamba kekekawan tasiwitden. ");
INSERT INTO wnc_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","Nata gae wam tawake aminu waiaknga tasikaingu yanindamumba waaminda gatane kepi noman takngaka kakapmake gae gatuna apning. ");
INSERT INTO wnc_vpl VALUES ("PS51_14","020_51_14","PSA","51","14","14","Anutu, ga Anutu na takuyak tapanin, gata musip kwikwik natangamuke ma nuwi kupam. Unzing tasingami nata gae kap taike gata nae nomana aknga tasikuyak takngae natake kap taiwit. ");
INSERT INTO wnc_vpl VALUES ("PS51_15","020_51_15","PSA","51","15","15","Buyambam tapa, gata na gatangami nata wam takngatu yakapmake gatane umanda aknga yatangenawit. ");
INSERT INTO wnc_vpl VALUES ("PS51_16","020_51_16","PSA","51","16","16","Nata kaau gwendu takapuke gae yamuyamuk binga tasiwitde take natapinu nata asiknga takapuke akgamit ngana gata ie take dua nataayak. Siakan. Nata kaau gwendu tanguke yamuyamuk binga tasiwa katapda isisopubanu gata dua bakngawiyak. ");
INSERT INTO wnc_vpl VALUES ("PS51_17","020_51_17","PSA","51","17","17","Ayok, Anutu! Nata ninae natapa epan nata gae gepbiatang koyuwit. Sike wa natane yamuyamuk takngana binga. Na atnataat. Gata aminu tapatuta inane waiaknganae meya natake umana inane aknga natapan epik. Natapan epan kake gata wa apae masa dua siknga imiyak. ");
INSERT INTO wnc_vpl VALUES ("PS51_18","020_51_18","PSA","51","18","18","Siwan gata gika nataak kakngane aminu gatayami Saion yot gapmane takekan yutnong. Gata gatuka damanu Jerusalem yot gapmane gwenu gatuka tangenayo. ");
INSERT INTO wnc_vpl VALUES ("PS51_19","020_51_19","PSA","51","19","19","Unzingge tapduu aomune amindabamu kepi noman taknga tawake gae ofa takekan gamuning. Gamuke aminu waakwakgane ofa inata inata katapda kuutgan yasikaing. Ngan, ikwawa gamanu wawi gwengwenu akgamunangge natake gatane alta dakane sawan yasiwan gamukaing. ");
INSERT INTO wnc_vpl VALUES ("PS52_1","020_52_1","PSA","52","1","1","Ga kekeknga sikngaapa, ga minae ainggamatake waiaknga Anututane aminabamde tasikuyakge baknganggaak? Asingganu Anututa waaminde musip kwikwik natayamunggak. ");
INSERT INTO wnc_vpl VALUES ("PS52_2","020_52_2","PSA","52","2","2","Ga kem amin, gatane genda daka resa toknga siknga daka binga. Tapdukbamu gata aminu kundu tanzit pasiwi mainingge nataayak. ");
INSERT INTO wnc_vpl VALUES ("PS52_3","020_52_3","PSA","52","3","3","Ga takeakngae dua nataayak. Aho. Ga waiakngaekan nataayak. Ga siakan wamgan yanangge dua nataayak. Ga kem wamgan yanangge nataayak. ");
INSERT INTO wnc_vpl VALUES ("PS52_4","020_52_4","PSA","52","4","4","Ga kem amintapa. Ga wamu aminu kundu pasiwan maikaing takngaekan nataayak. ");
INSERT INTO wnc_vpl VALUES ("PS52_5","020_52_5","PSA","52","5","5","Siwan ngana natapso. Anututa ga asiknga tasiwan maiwiyak. Ita ga tanggaganuke ganikwasiwan yotda teke kuya. Siwana ita tasiwan ga gatukande sopuke keu andakane gatuka dua yuya. ");
INSERT INTO wnc_vpl VALUES ("PS52_6","020_52_6","PSA","52","6","6","Sike noman aminda sanga waakngakan aawan kakengu akgwautning. Siwan waaminda akganimike gae anzing yaning, ");
INSERT INTO wnc_vpl VALUES ("PS52_7","020_52_7","PSA","52","7","7","Kanong! Aminu aapa Anututa gatangamuke tapan kekekawikge dua natapbut. Ita baniu kekeknga siknga sangaapana buyambamdekan natapbut. Gatu, waiaknga nata tasike take apme yuwit, ngang natapbut. ");
INSERT INTO wnc_vpl VALUES ("PS52_8","020_52_8","PSA","52","8","8","Siwan ngana na unzing dua. Na Anututane you buyambam gwene katau dakatu oliv ngang yanikaingu nakanu buyambam siknga kayuk yuakga binga yuat. Na baniu Anututa musip kwikwiu asinggan asinggan natangamunggak gekan asinggan asinggan natake yuwit. ");
INSERT INTO wnc_vpl VALUES ("PS52_9","020_52_9","PSA","52","9","9","Anutu, gata na gatangamukuyakge nata gae umanda kopsa akngae asinggan ganimbakngawit. Siwan gikane amindabamdane kaine nata umanda yatangenake anzing yawit, “Anututa sanga take siknga aknga nae tasingamunggak,” ngang yawit. ");
INSERT INTO wnc_vpl VALUES ("PS53_1","020_53_1","PSA","53","1","1","Katum aminda inae anzing yakaing, Anutu wena. Dua yuak ngang yakaing. Aminu waakwau wa wai siknga. Ita tasikaingu waiakngakan tasikaing. Iat nana tapatuta take takngatu dua tasinggak. ");
INSERT INTO wnc_vpl VALUES ("PS53_2","020_53_2","PSA","53","2","2","Anutu yekaune yuke pakepusa amin ninduyuak. Ita wa tasinggau aminu kundu natdeu noman taknga tawake Anutue natdet paningge tasinggak. ");
INSERT INTO wnc_vpl VALUES ("PS53_3","020_53_3","PSA","53","3","3","Siwan ngana wena. Aminu kuupbam kepi noman taknga gwa teking. Kuupbam ina unzakan, aminu wai siknga akwak. Iat nana tapatuta nomanu takngatu dua tasinggak. Wena siknga. ");
INSERT INTO wnc_vpl VALUES ("PS53_4","020_53_4","PSA","53","4","4","Anututa anzing yanggak, “Aminu waiaknga tasikaingu asikaya natdetdetna wena ba? Waaminda natane aminabamu poyak binga napan puyukaing. Tasike nae tumuk wamu dua nanikaing. ");
INSERT INTO wnc_vpl VALUES ("PS53_5","020_53_5","PSA","53","5","5","Siwan ngana waaminda kumzang siknga gwauking. Sike tupa unzingu dua gwauking. Wena siknga. Siwan ngana gautnanga tapatu wena.” Dasingge, Anututa waaminde natapan wai siknga sikut. Siwan ita gindane iwanza waakwau kuupbam siknga zipan puyuwan kwate awesike kaukaut mupewan kuking. Ita wai aminu gwa usanzikutde waaminu asiknga pasiwan maiking. ");
INSERT INTO wnc_vpl VALUES ("PS53_6","020_53_6","PSA","53","6","6","Sike nata take siknga nataau, Anututa Saion nana tapatu iniwan apu ninu Isrel nana gatu papikge nataat. Sike tapduknga Anututa gatayaman take yutning gwene Jakopdane donga apbaknganong. Ngan, Isrel nana aminda musip gwaang natapnong. ");
INSERT INTO wnc_vpl VALUES ("PS54_1","020_54_1","PSA","54","1","1","Anutu, gikane kekeknga aknganeta na wai amindane katakngine sandeke gatuka tapso. Gikane kekekngaka buyambam taknganeta tasiwi iwanata nandupa take siyok. ");
INSERT INTO wnc_vpl VALUES ("PS54_2","020_54_2","PSA","54","2","2","Anutu, gata natane tumuk wamna natapiakge nataat. Nata wamu yawitde maak gwaang papso. ");
INSERT INTO wnc_vpl VALUES ("PS54_3","020_54_3","PSA","54","3","3","Aminu yamandet sikaingga apu na nutnangge tasikaing. Aminu waakwakga nuwa kupitde tasikaing. Aminu waakwakga kawanu Anutu sanga yumdekanu tapatu binga singgak. ");
INSERT INTO wnc_vpl VALUES ("PS54_4","020_54_4","PSA","54","4","4","Siwan ngana Anututa ina siknga na gatangamunggak. Siakande siknga. Na Buyambam tapata kakuya tasiwawan na take yuat. ");
INSERT INTO wnc_vpl VALUES ("PS54_5","020_54_5","PSA","54","5","5","Nata take aminu waakwau nanisapdukaingga kaawa sanga waiaknga tasiking kakngata panggaganuwikge nataat. Anutu, gata na dua napmake iwana gata wenagom pasiyo. ");
INSERT INTO wnc_vpl VALUES ("PS54_6","020_54_6","PSA","54","6","6","Buyambam tapa, nata sanga ofa ngang yaya gae gamunangge siknga nataat. Gatane umanda take siknga. Unzingge nata umanda yatangenawit. ");
INSERT INTO wnc_vpl VALUES ("PS54_7","020_54_7","PSA","54","7","7","Ita na gatangamuke meya nae apbingga na dua tasiwan maikum. Sike nata kawawa natane iwana yapbiban kakum. ");
INSERT INTO wnc_vpl VALUES ("PS55_1","020_55_1","PSA","55","1","1","Anutu, gata natane tumuk wamae natapso. Nata gae sikgawamba maakga nae ma umukngamim. ");
INSERT INTO wnc_vpl VALUES ("PS55_2","020_55_2","PSA","55","2","2","Asiknga gata tumuk wama natangamuyo. Natangamuke yake naniyo. ");
INSERT INTO wnc_vpl VALUES ("PS55_3","020_55_3","PSA","55","3","3","Natane iwanata na tasiwan maiwitde wamu kekeknga yakaing. Yake waaminda kumzang nanduyake dua tewan nanduyuaing. Unzingge musipmaatangu natapa take dua singgak. Na musipmaiu atnataat. Dasingge, waaminda musiptou nae kwaapzang natangamuke kaanga nanikaing. Meya akngata na tasiwan gatukande mainanggenggat. ");
INSERT INTO wnc_vpl VALUES ("PS55_4","020_55_4","PSA","55","4","4","Na meya wesim akupitde waakwakge asiknga gwaukgat. Siwan waakngata tasiwan musipmaatangu meya nataat. ");
INSERT INTO wnc_vpl VALUES ("PS55_5","020_55_5","PSA","55","5","5","Ngan, na asiknga gwaumba gupmaapa kumzang tepan yamukgak. Gwaut takngata na atnaitakepunggak. ");
INSERT INTO wnc_vpl VALUES ("PS55_6","020_55_6","PSA","55","6","6","Ayok! Nata anzing yakum, “Butaya, na piana kwaitdane binga kaa gamun. Manggamu bepmake kuke paku keu komdune yuwa takawan. ");
INSERT INTO wnc_vpl VALUES ("PS55_7","020_55_7","PSA","55","7","7","Nata bepmake maa siknga paku amina wena komune gatukande yuwam. ");
INSERT INTO wnc_vpl VALUES ("PS55_8","020_55_8","PSA","55","8","8","Nata zaatgaman bepmake kuke gotde gatu sopaatde ngang gwauke kusopuwan.” ");
INSERT INTO wnc_vpl VALUES ("PS55_9","020_55_9","PSA","55","9","9","Nata kaawa aminu yumdekan yot gapmaatang amakaing. Unzingge Buyambam tapa, gata wamu yaningu pasiwi buyami siwan pasiwi sopunong. ");
INSERT INTO wnc_vpl VALUES ("PS55_10","020_55_10","PSA","55","10","10","Sike kwakngaom ba zikaane supda temake tasibasiking gapmane engatangan sukukaing. Gatu you wanggapmane nanata gutonga ba waiaknga tasikaingunin. ");
INSERT INTO wnc_vpl VALUES ("PS55_11","020_55_11","PSA","55","11","11","Sike you wanggapma atangganu aminu kunduta kuku aminkat gatu sangaapanaat ngang yumdekan pasiwan maikaing. Sike gatu kepi banakan yuaingune ba paut tasikaing komune waamindakan notnaapa yanisapduke sanga wai tasiyamunangge natake yakaing. ");
INSERT INTO wnc_vpl VALUES ("PS55_12","020_55_12","PSA","55","12","12","Sike iwanata wamu waiaknga apba naniwik. Undanga, na meya take gwaamumbit. Sike iwanata enake na apba tasiwan maiwitde yawik. Undanga, na kusopuwa meya waaknga nae dua apik. ");
INSERT INTO wnc_vpl VALUES ("PS55_13","020_55_13","PSA","55","13","13","Siwan ngana iwana wena. Gakan. Nata gandupa notna siknga singgak. Siwan ngana tapitekngwamban iwana dakngake wai waaknga tasingamunggayak. ");
INSERT INTO wnc_vpl VALUES ("PS55_14","020_55_14","PSA","55","14","14","Tupa niu unekan sukuke wamu yanggatake sukukumak. Sukuyuuk aminu kunduat Anutue yot gwenu kwaimune sukukumak. ");
INSERT INTO wnc_vpl VALUES ("PS55_15","020_55_15","PSA","55","15","15","Gata katewi kungwak kakngae dua nataaing ngana waakngata iwana apu papsok. Papan ninu kayuk take yuamang ngang yakaing ngana nata nataau gapmaatang gwa kupsa aminda yuaing katang pukuningge nataat. Dasingge, aminu waakwakga yotnaatang yuke waiaknga kundu pasikaing. ");
INSERT INTO wnc_vpl VALUES ("PS55_16","020_55_16","PSA","55","16","16","Sike na Anutu yatawamba ita gatangamunggak. Siwana ita na gatu tanggak. ");
INSERT INTO wnc_vpl VALUES ("PS55_17","020_55_17","PSA","55","17","17","Sike tembana gatu kepmaom gatu zikaane kuut, meyata tasiwan mainggatde sitawanggat. Siwan ita nae tumuu atnataak. ");
INSERT INTO wnc_vpl VALUES ("PS55_18","020_55_18","PSA","55","18","18","Aminbamda nae amak tasikaing. Siwan ngana na meya dua kaat. Dasingge, Anututa nanduyuke na gatuna nanitakapunggak. ");
INSERT INTO wnc_vpl VALUES ("PS55_19","020_55_19","PSA","55","19","19","Anutu tupa siknga king kapa binga yukut. Ge apman kaya ina unzakan king kapa ayuak. Sike ita nae tumuk wama natake ita gakngau iwanata amak gwekatang tasikaing kaknga natake ayapbimbik. Waakwau ie dua gwaukaing. Dua gwauke musia dua tapatekngamban kepi wai tawakaingu dua siknga tening. ");
INSERT INTO wnc_vpl VALUES ("PS55_20","020_55_20","PSA","55","20","20","Natane notna siknga amau inane notna akwakat amakaing. Sike wamu minaka tasinangge tupa waakwakat yawan kekekakuu, ina gwa zipbukut. ");
INSERT INTO wnc_vpl VALUES ("PS55_21","020_55_21","PSA","55","21","21","Sike genanetanu wamu kaa siknga yanggak. Siwan ngana baniatangu amak tasinangge nataak. Wamu yanggakga tasiwan ninu musip kwikwik yuamang. Siwan ngana wamna toknga siknga bainat dakatane genaaknga binga, ninu ita nisipmanggak. ");
INSERT INTO wnc_vpl VALUES ("PS55_22","020_55_22","PSA","55","22","22","Siwan ngana gata meya gwaamumbiyau, wa gata Buyambam tapatane katakngine peyo. Pewi ita gwaamuke ga tapan kekekaya. Sike ita dua kapewan sanga takngatuta noman aminu pasiwan maining. ");
INSERT INTO wnc_vpl VALUES ("PS55_23","020_55_23","PSA","55","23","23","Siwan ngana Anutu, ga amin wai tasikaing aminu kaipakepi gapma gupna bukataning gapmane pukunong. Aminu amin zipnangge tasikaing amikat gatu aminu tanzit tasikaing amikatda tapduknga wena dua siawan ngana waakwau akumning. Siwan ngana ninan, gae baniu kekeknga asinggan siwit. ");
INSERT INTO wnc_vpl VALUES ("PS56_1","020_56_1","PSA","56","1","1","Anutu, aminda na nawake nutnangge tasikaing. Asingganu iwanata nainggamukaing. Sanga wa tasingamukaingu kake gata musip kwikwik natangamuyo. ");
INSERT INTO wnc_vpl VALUES ("PS56_2","020_56_2","PSA","56","2","2","Sike tembanata kuku bangae siknga, iwanata sapdut wam nanisapduke nawakaing. Aminbamu inae umana yatangenake nutnangge tasikaing. ");
INSERT INTO wnc_vpl VALUES ("PS56_3","020_56_3","PSA","56","3","3","Siwan ngana Anutu enane siknga yuak kapa, tapduu gwendune nata sanga tapatue gwaukengu gae baniu kekeknga siwit. ");
INSERT INTO wnc_vpl VALUES ("PS56_4","020_56_4","PSA","56","4","4","Na Anutue banip singgat. Ie banip sike itane siakan wam takngae take siknga natake natanggamatanggat. Na Anutue banip singgatde aminda nae mina binga takngatu tasiwa maiwit takngae dua gwaumbit. ");
INSERT INTO wnc_vpl VALUES ("PS56_5","020_56_5","PSA","56","5","5","Sangabamu nata atasinangge yawa natake iwanata wamu waaknga tapatekngwamban inata siknga singgak. Asingganu kepi zaaknga tawake tasina maiwik, ngang nataaing. ");
INSERT INTO wnc_vpl VALUES ("PS56_6","020_56_6","PSA","56","6","6","Natake waaminu unekan yuke akusopuke yuaing. Kepi nata sukunggau katak siknga kakenga na nutapan kupitde tasikaing. ");
INSERT INTO wnc_vpl VALUES ("PS56_7","020_56_7","PSA","56","7","7","Anutu, nae waiaknga tasikaingge gata yake meya buyambam yamuyo. Gata musiptok natayamuke waaminu ayapbike yaipakepso. ");
INSERT INTO wnc_vpl VALUES ("PS56_8","020_56_8","PSA","56","8","8","Meya gwaamuke nata musipmaik nataau, ga atnatapinaa kwanamu sike yuat. Unzingge gata waakngae atnatanggamatayuuk, gikane buk gopatangu gwa matakuyak. ");
INSERT INTO wnc_vpl VALUES ("PS56_9","020_56_9","PSA","56","9","9","Anutu, nata gae tumuk wam yawanu gata tasiwi iwanata masa namuke datakuning. Datakuwa kake gata gatangamunangge tasinggaak ngang natapit. ");
INSERT INTO wnc_vpl VALUES ("PS56_10","020_56_10","PSA","56","10","10","Na Anututane wamna asiknga baknganggat. Ngan, Buyambam tapatane wamna yatangenanggat. ");
INSERT INTO wnc_vpl VALUES ("PS56_11","020_56_11","PSA","56","11","11","Na Anutue banip sike ita wamu yawan kekekakut takngae natanggamatanggat. Unzingge sanga tapatue dua gwaumbit. Dua gwaumba aminda nae mina binga takngatu tasiwa maiwit? Wena. ");
INSERT INTO wnc_vpl VALUES ("PS56_12","020_56_12","PSA","56","12","12","Anutu, nata sanga tupa tasinangge yawa kekekakut taknga nata atasiwit. Unzingge nata gae gaak siknga ganike ofa takngatu gaak wamma saak natake tasiwit. ");
INSERT INTO wnc_vpl VALUES ("PS56_13","020_56_13","PSA","56","13","13","Anutu, gata na gwa takuyakge na dua kumbum. Gata gatangami iwanata dua naitakepbing. Unzing Anutu, nata gaat asinggan gatake sukukamak. Siwan kakaa akngakata gatangaman kayuk yutnanga akngane sukuwit. ");
INSERT INTO wnc_vpl VALUES ("PS57_1","020_57_1","PSA","57","1","1","Anutu, gata musip kwikwik natangamuyo. Nata gae kuwa gata na nanduyuwiakge nataat. Na gaat yuke na take yuwit. Unzing taak matekga mingatane piatang kusopuke amaakatang take yuaing binga. Na unzing binga sike yuwawa sanga na tasiwan mainanga wena sining. ");
INSERT INTO wnc_vpl VALUES ("PS57_2","020_57_2","PSA","57","2","2","Na Anutu enane siknga yuak kapae yatawamba gatangamikge yanggat. Ita musiaatang nae natake tasingamik kaknga atasiwik kapanin. ");
INSERT INTO wnc_vpl VALUES ("PS57_3","020_57_3","PSA","57","3","3","Ita yekaune yuke natane tumuk wamma natake na gatuna tapik. Siwan ita na tasiwan maiwitde nawakainingu ita kaanga siknga yaniwik. Anututa na take siknga natangamuke asinggan na dua napmanggak. Wena siknga. ");
INSERT INTO wnc_vpl VALUES ("PS57_4","020_57_4","PSA","57","4","4","Na aminu kundu kaap zongu laion ngang yanikaingge banakan binga pekgat. Sike waaminda amin yasinangge tandakngakaing. Sike waaminda gena paanga siknga, unzing gwawaya ba sakut binga. Sike yembina bainatdane gena toknga aknga kaamang binga. ");
INSERT INTO wnc_vpl VALUES ("PS57_5","020_57_5","PSA","57","5","5","Anutu, nata take aminu gatane umanda kopsa siknga aknga asiknga yatangenatningge nataat. Gatane kekekngaka kepna kepna yuaingge aanggaman yeuyami gae natapa ga tupantapa siwan enane siknga yuak ngang natapning. ");
INSERT INTO wnc_vpl VALUES ("PS57_6","020_57_6","PSA","57","6","6","Sike iwanata na tanggaganuwikge yapapna peking. Unzingge meya buyambamda na asiknga tasiwan maikum. Nata kepi kunggaune gapma kwaiking, nata undang pukuke kupitde. Siwan ngana na dua pukukum. Aho. Gapma wa daka dakaatangu ina pukuke kumbing. ");
INSERT INTO wnc_vpl VALUES ("PS57_7","020_57_7","PSA","57","7","7","Anutu, natane musipmaatangu gae baniu nata kekeknga singgat. Ngan, nata baniu kuupbam gaekan singgat. Siwan nata gae kap taike umanda yatangenawit. ");
INSERT INTO wnc_vpl VALUES ("PS57_8","020_57_8","PSA","57","8","8","Na dapunu pekgau ateke enawit. Enake nata gwamemingu gitaat gatu kuleleat zipit. Gakngau waaknga tasiwawa kawakawik. ");
INSERT INTO wnc_vpl VALUES ("PS57_9","020_57_9","PSA","57","9","9","Buyambam tapa, nata gaak wamu ganiwiu dongu kundue banakan yuke ganiwit. Nata aminu kuupbamu kepna kepna yuaingge kuke umanda yatangenawit. ");
INSERT INTO wnc_vpl VALUES ("PS57_10","020_57_10","PSA","57","10","10","Sike gata nindenu take siknga nataayak kaknga buyambam siknga. Ninde musip kwikwik wa nataayak kaknga tuwanguke kananu mamayana yekaunekan siwik. Asingganu gata wamba takeakngakan tawanggaak. Sike ninde tapdukbamu takeaknga tasinggaakge kendetnanu mamayana minga musa ena kakaa komune yuaunekan siwik. ");
INSERT INTO wnc_vpl VALUES ("PS57_11","020_57_11","PSA","57","11","11","Anutu, nata take gatane umanda aminbamda enane siknga yatangenatningge nataat. Gatu gatane kekeknga akngaka kuut aminu kepna kepna yuaingge aanggaman yeuyamuyo. Yeuyami gatane umanda akngaenu natapan kopsa siwik. ");
INSERT INTO wnc_vpl VALUES ("PS58_1","020_58_1","PSA","58","1","1","Ginu gwapakngi amin, ginu wam yak gwene wamu noman takngakan yakaingunin ba? Asikaya ginu aminbamdane wamu katak siknga usanzikaing? Wena siknga. ");
INSERT INTO wnc_vpl VALUES ("PS58_2","020_58_2","PSA","58","2","2","Natdetdet zaatangu waiakngakan tasinangge natapan kekekanggak. Siwan ginda aminu kepna kepna yuaing amin kuupbam zipa maikaing. ");
INSERT INTO wnc_vpl VALUES ("PS58_3","020_58_3","PSA","58","3","3","Sike wai aminda kepi sukukaingu kuupbam kepi take aknga ateke sukukaing. Sike tapduu engangu kayuk aakaing komuneta apu apmanu kweknga sike yuaingu, waiaknga tasike kem wamban yakaing. ");
INSERT INTO wnc_vpl VALUES ("PS58_4","020_58_4","PSA","58","4","4","Wamu yakaingu unzing gomokgane genaatang marasinu waiaknga yuak binga. Sike waakwakga maakngi atzaangukaing. Unzing gomokga maakngi kusiwan wamu dua nataaing binga. ");
INSERT INTO wnc_vpl VALUES ("PS58_5","020_58_5","PSA","58","5","5","Gomou waaknga natdetdeu toikngatane wamu dua nataak. Unzing gakngat taknga tasiwan gomou kunduta natake enake taiwikgen. Sike natdetdet amin tapata benggo noman siknga apuyapan ngana, gomou waapa wamna dua natapik. ");
INSERT INTO wnc_vpl VALUES ("PS58_6","020_58_6","PSA","58","6","6","Anutu, gata wai aminu waakwau pasiwi mainong. Buyambam tapa, waaminda kaap zongu laionda amak tasikaing binga tasikaing. Unzingge gena zipmanzike kuupbam gatukande ukgwiyamuyo. ");
INSERT INTO wnc_vpl VALUES ("PS58_7","020_58_7","PSA","58","7","7","Waaminu yanggata zipmake kusika kep ganang pukuke sopunggak binga sopunong. Waaminu kweemna katakga pake sakut kaike mutningu sakutna tundunga siyok. ");
INSERT INTO wnc_vpl VALUES ("PS58_8","020_58_8","PSA","58","8","8","Sike gatu waaminu gapanda kepdakane kungwake kapanga sike sopukaing binga kuut sinong. Gatu engangga mingae musiaatang kungwakaing binga kuut sinong. Masande mingata tangaiwanu gunzit gwenu dua kawik. ");
INSERT INTO wnc_vpl VALUES ("PS58_9","020_58_9","PSA","58","9","9","Zaatgaman Anututa waaminu apasiwan maining. Unzing aminda katap matek dakandaka pasiwan pimakaing binga. Waaminu kayuk yuwawan Anututa musiptok natake sambasamba binga mumba kuning. ");
INSERT INTO wnc_vpl VALUES ("PS58_10","020_58_10","PSA","58","10","10","Sike amin nomanda wai aminu Anututa pasiwan maiwan kakengu apbaknganing. Siwana noman aminda wai amindane dak kakngane kepina sautning. ");
INSERT INTO wnc_vpl VALUES ("PS58_11","020_58_11","PSA","58","11","11","Siwana aminu kunduta gatu anzing yaning, Siakande siknga, Anututa take aminde buyana nomana siknga yamunggak. Siakan siknga, Anutu ayuak. Sike ita aminbamu wam yaning komune asusanzikgak ngang yaning. ");
INSERT INTO wnc_vpl VALUES ("PS59_1","020_59_1","PSA","59","1","1","Natane Anutuna, gata na iwanae kataune sandeke gatuka tapso. Gata na kakuya tasiwi waaminda na dua tasiwan maiwit. ");
INSERT INTO wnc_vpl VALUES ("PS59_2","020_59_2","PSA","59","2","2","Gata na waiaknga tasikaing amindane katakngane sandeyo. Sandeke tapi nutnangge nataaing aminda dua nuwan kupit. ");
INSERT INTO wnc_vpl VALUES ("PS59_3","020_59_3","PSA","59","3","3","Buyambam tapa, kayo. Waakwakga na nuwan kupitde kusopukaing. Nata sanga takngatu waaminde dua siknga tasikum. Siwan ngana wai aminu kitatoknga waakwau amak tasike nutnangge unekan yuaing. ");
INSERT INTO wnc_vpl VALUES ("PS59_4","020_59_4","PSA","59","4","4","Buyambam tapa, na gutonga takngatu dua tasiyamukum. Siwan ngana waaminu zeetgaman kuke na nutnangge tandakngakaing. Nutnangge tandakngawa kake gata enake gatangamuyo. ");
INSERT INTO wnc_vpl VALUES ("PS59_5","020_59_5","PSA","59","5","5","Buyambam tapa, ga Anutu kekekngaka bamban. Ga Isrel amindane Anutuna. Gata aminu gae masa gamukaingu zeetgaman apuke meya aminu dongu wa kuupbamde yake yamuyo. Yamuke waaminde butaya ma natayamim. ");
INSERT INTO wnc_vpl VALUES ("PS59_6","020_59_6","PSA","59","6","6","Sike zikaane waaminda yotbam gapmane apuke daman gwen kumbasiyuuk, kamunda binga ainggamatakaing. ");
INSERT INTO wnc_vpl VALUES ("PS59_7","020_59_7","PSA","59","7","7","Natapso. Waamindane wamna wai siknga siwan genaneta suyapbikaing. Unzing bainat taknga gena toknga aknga suyapbikaing binga. Siwan ngana anzing yakaing, “Maminda ninda yanimu natapning?” ");
INSERT INTO wnc_vpl VALUES ("PS59_8","020_59_8","PSA","59","8","8","Siwan ngana Buyambam tapa, gata waaminde asiknga ayanimikgayak. Gata sapdut wamu aminu wa kuupbam kepna kepna yuaingunin yaninggaak. ");
INSERT INTO wnc_vpl VALUES ("PS59_9","020_59_9","PSA","59","9","9","Gatakan na tapi kekekaawan kakuya gatu tasinggaak kapanin. Anutu, nata iwanae gwauke gae apuke gatane gepbiatang koke yukgamuke kusopuwit. ");
INSERT INTO wnc_vpl VALUES ("PS59_10","020_59_10","PSA","59","10","10","Sike gata nae take siknga nataayak kapanin. Anututa nae tupan kuwawan nata apmea kuwawa ita gatangamik. Gatangaman na aminu nanisapdukaingu ayapbimbit. ");
INSERT INTO wnc_vpl VALUES ("PS59_11","020_59_11","PSA","59","11","11","Buyambam tapa, ga nin ninduyuayak kapanin. Gata waamin ma zipi kumnong. Dasingge? Zipi kupanu natane aminabamda sanga waakngae botaning. Gikane kekeknga aknganetakan iwaninu yanikwasiwi unda undang kuwa pasiwi mainong. ");
INSERT INTO wnc_vpl VALUES ("PS59_12","020_59_12","PSA","59","12","12","Asingganu genata wamu wai yake waiaknga tasinangge yakaingunin. Undanga, kapewi yamandeu sike gatane umandaenu asapduke kemu asinggan yakaingge meya panong. ");
INSERT INTO wnc_vpl VALUES ("PS59_13","020_59_13","PSA","59","13","13","Unzingge gata musiptok natake atzipso. Gata wai aminu waakwau pasiwi wena siknga sinong. Gata unzing tasiwi Anutu Jekopdane donga kayuak kapanin ngang aminu kepna kepna yuaingga natapning. ");
INSERT INTO wnc_vpl VALUES ("PS59_14","020_59_14","PSA","59","14","14","Sike zikaanen, waaminda yotbam gapmane asaapuke kamunda binga aiyuuk kumbasikaing. ");
INSERT INTO wnc_vpl VALUES ("PS59_15","020_59_15","PSA","59","15","15","Sike wa kungapuke tasikaingu nanamde yawakaing. Yawake musipna dua gitnawanu kumzang siknga ainggamatakaing. ");
INSERT INTO wnc_vpl VALUES ("PS59_16","020_59_16","PSA","59","16","16","Siwan ngana natanu gatane kekeknga akngakae kau taiwit. Ngan, tembana tapduu kuupbam nata kau kapzang taike nae asinggan natanggamatanggayakge natake taiwit. Dasingge, tupa meya takngatu takngatu nae apbing. Siwan ngana gata kakuya katak siknga tasike gata nae damangwen binga dakngawi yuat. ");
INSERT INTO wnc_vpl VALUES ("PS59_17","020_59_17","PSA","59","17","17","Anutu, gakan, ga natane kekekngaapana. Nata kap takngatu taike umanda yatangenawitde nataat. Anutu, gata nae take siknga nataayak. Sike ga natane damanu kekeknga gwenu unin. ");
INSERT INTO wnc_vpl VALUES ("PS60_1","020_60_1","PSA","60","1","1","Anutu, gata ninu atnipmakuyak. Nipmambi ninda amau tasike dua yapbikumang. Gata ninde kaanga kaa siwan unzingu tasikuyak. Siwan ngana apmanu gatuka apuke ninu gatanimi take yutnim. ");
INSERT INTO wnc_vpl VALUES ("PS60_2","020_60_2","PSA","60","2","2","Gata tasiwi nindane keu andaka miamun sikut. Siwan kepda puwan ganangi buyambam sikut. Apmanu keu anggwenu wai kuupbam asinangge saasaa singgak. Unzingge gatuka tapi nomatayok. ");
INSERT INTO wnc_vpl VALUES ("PS60_3","020_60_3","PSA","60","3","3","Gata gikane amindabamde meya kwaapzangu gwa nimukuyak. Unzing gata wain yangga aknga binga nimuke tasiwi tangopbumang. Tangopna puyuwana ninu katum siknga dakngakumang. ");
INSERT INTO wnc_vpl VALUES ("PS60_4","020_60_4","PSA","60","4","4","Siwan ngana gata tauu plek sandu tangenayo. Siwan aminu gae gepbiatang yuaingga iwana kagwauke datakuke tauu wasane kuke take yutning. ");
INSERT INTO wnc_vpl VALUES ("PS60_5","020_60_5","PSA","60","5","5","Gatanu ninde take siknga nataayak. Natake gikane kekeknga buyambam taknganeta gatanimuke ninu gatuka papso. Siwana ninu take yutnim. ");
INSERT INTO wnc_vpl VALUES ("PS60_6","020_60_6","PSA","60","6","6","Sike Anututa yotnane yuke anzing yakut, “Nata amak tasike gwa yapbikum. Unzingge nata apbakngake Sekem kep kopat gatu Sukot kep kopat ngang inikaing komu amunane yuak kopat usanzike aminabamde yamit,” ngang yakut. ");
INSERT INTO wnc_vpl VALUES ("PS60_7","020_60_7","PSA","60","7","7","“Gileat kep kopat gatu Manase kep kopat wa natane, sike Efraim kep komde natapa natane kapa kupma binga singgak. Siwan Juda kep komu kinggane gusoknga binga ngang nataat. ");
INSERT INTO wnc_vpl VALUES ("PS60_8","020_60_8","PSA","60","8","8","Sike Moap kep komu nata dopangbamu yanggane saukgat gwen binga ngang nataat. Siwan Idom kep komu natane kep kom dakngawikge natake kepi tauknga keu waomune mumba kunggak. Siwana nata amak tasike Filistia aminu yapbimbit. Yapbike keu waomde apbakngake asainggamatawit.” ");
INSERT INTO wnc_vpl VALUES ("PS60_9","020_60_9","PSA","60","9","9","Anutu, na maminda you kekeknga damanda tasibasia gapmane nanitake kuwik? Ngan, maminda Idom kep waomune nanitake kuwik? ");
INSERT INTO wnc_vpl VALUES ("PS60_10","020_60_10","PSA","60","10","10","Anutu, gata ninde masa gwa nimukuyak ba dasing? Gata nindane amak aminu dua gatayamuya ba dasing? ");
INSERT INTO wnc_vpl VALUES ("PS60_11","020_60_11","PSA","60","11","11","Ngan, gata nin gatanimi ninda iwaninde amnim. Dasingge, aminda gatak gatak tasining kaknga wa sanga moo. ");
INSERT INTO wnc_vpl VALUES ("PS60_12","020_60_12","PSA","60","12","12","Sike Anututa akgatanimanu amak tasike iwaninu ninda ayapbitnim. Ita ina nindane iwaninu ayaipakepik. ");
INSERT INTO wnc_vpl VALUES ("PS61_1","020_61_1","PSA","61","1","1","Anutu, nata gae yanggawamba natapso. Natane tumuk wamae maak gwaang papso. ");
INSERT INTO wnc_vpl VALUES ("PS61_2","020_61_2","PSA","61","2","2","Na yotna teke maa siknga kuyuke gata gatangamiakge yanggawanggat. Yanggawa musipmaatangu meya siknga nataat. Unzingge gata nanitake sup buyambam siknga kusopuknga komdune napmambi iwanata na dua tasiwan maiwit. ");
INSERT INTO wnc_vpl VALUES ("PS61_3","020_61_3","PSA","61","3","3","Dasingge, ga natane damanu kekeknga gwenunin. Unzingge iwanata na dua tasiwan maiwit. ");
INSERT INTO wnc_vpl VALUES ("PS61_4","020_61_4","PSA","61","4","4","Na gatane yotda gwene yusika kupitde take siknga nataat. Ngan, nata gae gepbiatang kusopunangge nataat. Unzing taakgane matekngata mingatane pia amaakatang koke take siknga yuaing binga. ");
INSERT INTO wnc_vpl VALUES ("PS61_5","020_61_5","PSA","61","5","5","Anutu, nata sanga kuupbamde gae kaikane yawa kekekakingu wa gata gwa natapbuyak. Sanga gata aminu gae gwaukaing aminde yamunangge natake yawi kekekakut kaknga nae gwa namukuyak. ");
INSERT INTO wnc_vpl VALUES ("PS61_6","020_61_6","PSA","61","6","6","Gata na king kapa nandutewi nakanu kwaapzang kayuu yuwit. Gika nandutewi keu andakane mamaya yuwit. ");
INSERT INTO wnc_vpl VALUES ("PS61_7","020_61_7","PSA","61","7","7","Anutu, gatu na nandutewi na king kapa kaikane mamaya asinggan yuwit. Gata ne take siknga natangamunggayak. Unzingge asinggan katak nanduyuyo. ");
INSERT INTO wnc_vpl VALUES ("PS61_8","020_61_8","PSA","61","8","8","Sike gata unzing tasiwinu tapdukbamu nata tupa wamu kundu yawa kekekakingu atawambit. Atawake nata kap taike umanda asinggan asinggan yatangenawit. ");
INSERT INTO wnc_vpl VALUES ("PS62_1","020_62_1","PSA","62","1","1","Na baniu kekeknga Anutu waapaekan singgat. Sike waapatakan na gatuna tapan na kayuu yuat. ");
INSERT INTO wnc_vpl VALUES ("PS62_2","020_62_2","PSA","62","2","2","Waapatakan na kuyana yuke gatangamunggak. Ngan, ita natane damanu kekeknga gwenu unin. Unzingge na amau tasike ngana dua pimambit. Wena siknga. ");
INSERT INTO wnc_vpl VALUES ("PS62_3","020_62_3","PSA","62","3","3","Tapduu datdasing binga amau gikat naat amake tasiwan maiwit? Sike ginda nataaingu na damanu gwenduta binga puke pimake gatukande waitdotdongukgak binga siwit. ");
INSERT INTO wnc_vpl VALUES ("PS62_4","020_62_4","PSA","62","4","4","Na umana kopsaapa, siwan ngana natane umana kopsa waaknga atasiwan maiwikge tasikaing. Ginu kem wamde take siknga nataaing. Ginda wamu geyangga yake takeaknga Anututa nae take tasiwikge yakapmakaing. Siwan ngana musip zaatangu ginda anzing yakaing, “Ninda nataamangu Anututa asiknga tasiwan maiwik,” ngang yakaing. ");
INSERT INTO wnc_vpl VALUES ("PS62_5","020_62_5","PSA","62","5","5","Na Anutu awiapaekan baniu kekeknga singgat. Gatu itakan gatangamikge kayuat. ");
INSERT INTO wnc_vpl VALUES ("PS62_6","020_62_6","PSA","62","6","6","Sike waapatakan na kuyana yuke gatangamunggak. Ngan, waapa natane damanu kekekngaapa unin. Unzingge na amau atasike ngana dua pimapit. Wena siknga. ");
INSERT INTO wnc_vpl VALUES ("PS62_7","020_62_7","PSA","62","7","7","Gatu Anutu waapatakan na gatuna take umana kopsa aknga namunggak. Natane kuyana kekeknga sikngaapa unin. Sike Anutu natane damanu kekeknga gwenu unin, ge iwanata na dua tasiwan maiwit. ");
INSERT INTO wnc_vpl VALUES ("PS62_8","020_62_8","PSA","62","8","8","Ginu natane donga, Anutue baniu asinggan sinong. Ginda meya kuupbam musipzaatang pakaing ba natdetdetzaatang nataaingu iekan yakapnong. Dasingge, ninda iekan kuke take yutnim. ");
INSERT INTO wnc_vpl VALUES ("PS62_9","020_62_9","PSA","62","9","9","Sike aminu moo amin genaneta waung kaknga moo siknga puyapna kunggak binga. Gatu aminu kundu umana kaya ngana sanga moo yuaing binga. Sike waakwau sanga meyana wena apa binga. Siwan ngana geninde waung kaknga meyana kaya. ");
INSERT INTO wnc_vpl VALUES ("PS62_10","020_62_10","PSA","62","10","10","Ginda anzingu ma natapam. Tanziu tasike amindane sanga papsa gatu sanga kukae papsa akngaat take ngang natake ninu sanganin bamban, ngangu natapnanga dua. Sike moning zaat gatu sangasaat kwaapzang siwanu, musipzaatangu sanga nindane kekeknganinu unin ngangu ma natapam. ");
INSERT INTO wnc_vpl VALUES ("PS62_11","020_62_11","PSA","62","11","11","Asingganu nata nataawa Anututa wamu takngatu yakut. Ngan. Wamu takngaya anzing yawan natapbum. “Na Anutu, na kekekngana bamban tapa,” ngang yakut. ");
INSERT INTO wnc_vpl VALUES ("PS62_12","020_62_12","PSA","62","12","12","Gatu anzing yakut, “Asingganu nata aminu kuupbamde take siknga nataat.” Unzingge, Buyambam tapa, gata buya ninu amindabamde nimunggau yuyuk yuamang kaknga kake nimunggayak. ");
INSERT INTO wnc_vpl VALUES ("PS63_1","020_63_1","PSA","63","1","1","Anutu, ga natane Anutuna. Nata ga gandupnangge kekeknga tasike gawanggat. Siwan naat gaat yutzimnde take siknga nataat. Ngan, naat gaat unekan gatake yutnangge natapa kekeknga siknga singgak. Sike wa unzing aminu keu wawaa yanggana wena komune yuke ita guyaknga kupiakgak binga. ");
INSERT INTO wnc_vpl VALUES ("PS63_2","020_63_2","PSA","63","2","2","Nata ga yotdane koke gandupa gata kekekngaka buyambam takngakayat gatu umanda kopsa yuayak kaknga ngang yeikngami kakum. ");
INSERT INTO wnc_vpl VALUES ("PS63_3","020_63_3","PSA","63","3","3","Kepdakane kayuk yutnanga aknga take ngana gatane musip kwikwik kakngaka gwaam siknga. Unzingge nata gatane umanda yatangenawit. ");
INSERT INTO wnc_vpl VALUES ("PS63_4","020_63_4","PSA","63","4","4","Siwan nata ga ganimbakngake gatane umanda yatangenake yusika nata akupit. Sike nata ninane kataknga tangenake gae ganimbakngake tumuk wamu ganiwit. ");
INSERT INTO wnc_vpl VALUES ("PS63_5","020_63_5","PSA","63","5","5","Siwan nata natapa take siknga siwik. Unzing aminda nanamu take siknga napik binga. Siwan ita napan atgitnawik. Sike nata apbakngake gatane umanda yatangenake kap taiwit. ");
INSERT INTO wnc_vpl VALUES ("PS63_6","020_63_6","PSA","63","6","6","Siwan tapduu nata dapuna pekgat komune gae atnatanggamatanggat. Sike zikaane kuut gaekan natanggamatanggat. ");
INSERT INTO wnc_vpl VALUES ("PS63_7","020_63_7","PSA","63","7","7","Dasingge, gata na asinggan gatangamunggayak. Na gae wesim yuwau wa unzing, taak matekga mingae piyaatang kopa usikwatanggak binga. Siwan nata gae gepbiatang yuke kau apbakngananga tainggat. ");
INSERT INTO wnc_vpl VALUES ("PS63_8","020_63_8","PSA","63","8","8","Na gaat unekan gatake unekan sukukamak. Ngan, na gaat sukuke gatane kekeknga akngakata na kakuya take siknga tasinggayak. ");
INSERT INTO wnc_vpl VALUES ("PS63_9","020_63_9","PSA","63","9","9","Siwan aminda na nutapa kupitde tasikaingu pimake apmaining. Ge waaminda akupsa aminde kep komune kuning. ");
INSERT INTO wnc_vpl VALUES ("PS63_10","020_63_10","PSA","63","10","10","Sike waaminu amak tasike akumning. Siwan kamun zongga gupna apu atnaning. ");
INSERT INTO wnc_vpl VALUES ("PS63_11","020_63_11","PSA","63","11","11","Sike na king kapa. Nata Anutue apbakngawit. Siwan aminu Anututane umande yawan kekekawan ie tawanangge nataaingu waaminda asiknga inimbaknganing. Siwan ngana Anututa aminu kem wam yakainggane gena asumumban kumakan yutning. ");
INSERT INTO wnc_vpl VALUES ("PS64_1","020_64_1","PSA","64","1","1","Anutu, na meyana buyambam. Gata natane tumuk wamae maak papso. Na iwanae akgwaukgat. Gata gatangami iwanata na dua nuwan kupit. ");
INSERT INTO wnc_vpl VALUES ("PS64_2","020_64_2","PSA","64","2","2","Wai aminda na tasiwan maiwitde kepie tawakaing. Tawake unekan yuke nutnangge natake wamu yakaing. Unzingge gata kakuya tasiwi wai aminda na dua tasiwan maiwit. ");
INSERT INTO wnc_vpl VALUES ("PS64_3","020_64_3","PSA","64","3","3","Waamindane gena bainatdane gena toknga siknga dakata binga nukgak. Siwan wamu waiaknga yakaingu nae temanggaganukaing. Unzing kweemna kaike gatu sakutna amin yamnangge kaikaing binga. ");
INSERT INTO wnc_vpl VALUES ("PS64_4","020_64_4","PSA","64","4","4","Waakwau undang kusopuke sakutna noman amindekan mukaing. Sike waakwau dua gwauke zeetgaman mukaing. ");
INSERT INTO wnc_vpl VALUES ("PS64_5","020_64_5","PSA","64","5","5","Sike wai aminu waakwau inae natapa kekekawan wai waaknga atasinangge nataaing. Sike wamu yakaingu keu komduatang yapapna pewan aminu kundu panggaganutningge nataaing. Siwan gatu anzing nataaing, Yapapminu kusopuknga siknga. Aminu tapatuta yapapminu kananga dua, ngang nataaing. ");
INSERT INTO wnc_vpl VALUES ("PS64_6","020_64_6","PSA","64","6","6","Siwan gatu waaminu waiaknga kunduat tasinangge wamu yandekaing. Yandeke anzing yakaing, “Ninu sanga takngatu tasinangge kepi takeakanga gwa natapna kekekakut,” ngang yakaing. Sike, “Sanga wa tasinangge natapbumangu aminu tapatuta dua kakapik,” ngang yakaing. Siakan siknga, aminde natdetdetnane ba musiane yuwik kaknga kakapnanga dua. Siwan waaminda waiaknga tasiningge kepi aknga aknga katak siknga nataaing. ");
INSERT INTO wnc_vpl VALUES ("PS64_7","020_64_7","PSA","64","7","7","Siwan ngana Anututanu, sakutnata yapik. Yapan zeetgaman mait sike kumning. ");
INSERT INTO wnc_vpl VALUES ("PS64_8","020_64_8","PSA","64","8","8","Gatu aminu tapatu tasiwan maiwikge yawan natakengu Anututa yake tasiwan wamu wa yakaing kakngata waamin yapan maining. Siwan aminda kake kumzang yanimike gwapaknga makaitning. ");
INSERT INTO wnc_vpl VALUES ("PS64_9","020_64_9","PSA","64","9","9","Sike aminbamda kake Anutue akgwautning. Siwana Anututa sanga wa tasikutde natdetdetnane asinggan natayuke yanikapning. ");
INSERT INTO wnc_vpl VALUES ("PS64_10","020_64_10","PSA","64","10","10","Sike noman aminu kuupbamda Buyambam tapae apbaknganong. Bakngake ie kuke waiakngae iatang koke kusopunong. Iat yuke noman aminu Buyambam tapatane umana yatangenatnong. ");
INSERT INTO wnc_vpl VALUES ("PS65_1","020_65_1","PSA","65","1","1","Anutu, ninu Saion yot gapmane yuke umanda ninda yatangenatnim. Siwana ninda sanga tupa yana kekekakuu kuupbam tasinim. ");
INSERT INTO wnc_vpl VALUES ("PS65_2","020_65_2","PSA","65","2","2","Gata nindane tumuk wamin atnataayak kapanin, ninu aminu kuupbam gae asiknga kunim. ");
INSERT INTO wnc_vpl VALUES ("PS65_3","020_65_3","PSA","65","3","3","Gutonga ninda tasikamangu kumzang siknga niipakepbing. Siwan ngana gata gutonga nindane asandetnimuya. ");
INSERT INTO wnc_vpl VALUES ("PS65_4","020_65_4","PSA","65","4","4","Sike aminu gika yawi yuwan yotdane pake konggayau, waaminu apbaknganing. Gikane yotda wagwekatangu sanga nomana kwaapzang yuaing. Sanga kwaapzangu kake ie musip gwaang siknga natake yuamang. ");
INSERT INTO wnc_vpl VALUES ("PS65_5","020_65_5","PSA","65","5","5","Anutu, gata gika siknga ninu gatu papi ninu take siknga yuamang. Gata tumuk waminde maak panggayak. Natake puya nin panangge tasikuyak kakngae natake asatnakamang. Sike aminu maa maa kepna kepna yuaingu, gae baniu kekeknga sikaing. Sike yanggabamu kaukaut yuaingga gae baniu kekeknga sikaing. ");
INSERT INTO wnc_vpl VALUES ("PS65_6","020_65_6","PSA","65","6","6","Gikane kekeknga aknganeta tasiwi tawan dakandaka enake tangine yuking. Gatane kekekngaka buyambam siknga. ");
INSERT INTO wnc_vpl VALUES ("PS65_7","020_65_7","PSA","65","7","7","Gatu gatakan yanggabam gwenu tasiwi kuma yuak. Ngan, sambui enake tanguwan tapmanggau tasiwi kuma yuak. Ngan, aminda amak ba tasikaing kaya tasiwi wena asinggak. ");
INSERT INTO wnc_vpl VALUES ("PS65_8","020_65_8","PSA","65","8","8","Gata sanga waakwak tasiwi kake aminbamu maa maa yuaing aminda gae akgwaukaing. Sike gunzitda akonggauneta kuku gunzitda pukunggaune yuaingga sanga kuupbamu gata tasinggayaunin kake yanggamatake gae apbakngakaing. ");
INSERT INTO wnc_vpl VALUES ("PS65_9","020_65_9","PSA","65","9","9","Gata kepdaka daka katak siknga kayuke sopa kepi waakngane pewi epukaing. Siwan kepdaka tasiwi kayana kwaapzang siwan nanam zakga take siknga enakaing. Anutu, gata yangga kuupbam kepna kepna pekuyau dua zakngakaing. Yangga wanda pasiwan nanamu kwaapzang aawan aminbamda pake nakaing. Sike puya waaknga gata gika tasikuyaunin. ");
INSERT INTO wnc_vpl VALUES ("PS65_10","020_65_10","PSA","65","10","10","Gata sopa nindane puyanine kwaapzang pewi pimakaing. Pimake kepatang pukukaing. Sopa yanggata kepdaka tanguwan wikawan nanamu take enakaing. ");
INSERT INTO wnc_vpl VALUES ("PS65_11","020_65_11","PSA","65","11","11","Gata ninde take tasinimuke tasiwi nanamu kwaapzang aakaing. Gata keu komduine kukengu waomune nanamu kwaapzang aakainga kaya. ");
INSERT INTO wnc_vpl VALUES ("PS65_12","020_65_12","PSA","65","12","12","Sike keu komdu kepban sangana wena, moo siknga yukut. Siwan ngana apmanu ikwawa gaman ba sipsip gwegwenu zongazonga keu waomune kwaapzang akokaing kom kake undang doke yuaing. Sike gatu puya kwaapzangu tawan dakandakaatang yuaingu kake apbakngakaing. ");
INSERT INTO wnc_vpl VALUES ("PS65_13","020_65_13","PSA","65","13","13","Sike sipsiu kwaapzang sikngata zongazonga kwaapzang ngang kaya komune doke yuaing. Sike gatu wit ngang yanikaingu gapmene ba tawan dakandakae banakan katang akoke doke yuaing. Siwan sanga wa kuupbamda apbakngakaing. ");
INSERT INTO wnc_vpl VALUES ("PS66_1","020_66_1","PSA","66","1","1","Ginu kuupbam kepna kepna yuaingga apbakngake apaa siknga yake Anututane umana yatangenatnong. ");
INSERT INTO wnc_vpl VALUES ("PS66_2","020_66_2","PSA","66","2","2","Sike kap taike itane umana kopsa akngae yakapnong. Itane umana kopsa aknga enane siknga yatangenatnong. ");
INSERT INTO wnc_vpl VALUES ("PS66_3","020_66_3","PSA","66","3","3","Anutu anzing ininong, “Sanga kuupbam gata pasinggaunin kake ie kumzang gwaukamang. Gatane kekekngaka buyambam siknga. Unzingge gatane iwanda asiknga gwauke gae kaikane munu pukaing. ");
INSERT INTO wnc_vpl VALUES ("PS66_4","020_66_4","PSA","66","4","4","Aminu kepna kepna yuaingga gae munu pukaing. Puke gae kap taike gatane umanda yatangenakaing.” ");
INSERT INTO wnc_vpl VALUES ("PS66_5","020_66_5","PSA","66","5","5","Ginda apuke sanga Anututa pasikuu kanong. Apuke sanga buyambam taknga aknga aminde tasiyamukuu kana inata siknga singgak. ");
INSERT INTO wnc_vpl VALUES ("PS66_6","020_66_6","PSA","66","6","6","Ita tasiwan yanggabam gwenu atzakngawan kep dakakan sikut. Siwan nindane bapuninu yangga ganzik binga waapane kuking. Unzingge ninda sanga wa tasikut takngae natake baknganim. ");
INSERT INTO wnc_vpl VALUES ("PS66_7","020_66_7","PSA","66","7","7","Sike i kekekngana buyambam, siwan ita king kapa siwan aminbamu asinggan asinggan kayuak. Unzing aminu kunduta Anutue yamandet sinang ngangge. ");
INSERT INTO wnc_vpl VALUES ("PS66_8","020_66_8","PSA","66","8","8","Ginu dongu kuupbam, ginu Anutunindane umana asiknga yatangenatnong. Ginda Anututane umana yatangenawan aminbamda natapnong. ");
INSERT INTO wnc_vpl VALUES ("PS66_9","020_66_9","PSA","66","9","9","Dasingge, ita ninduyuwawan ninu kayuu yukumang. Yuwatna ita dua nindupewan kepi saweknga apane pimakumang. ");
INSERT INTO wnc_vpl VALUES ("PS66_10","020_66_10","PSA","66","10","10","Anutu, gata ninu gwa panziwi sikumang. Unzing aminda silwa ngang yanikaingu katap gwene sawa dapandapana wena siwan kwakwaknga inatakan yuwik binga. ");
INSERT INTO wnc_vpl VALUES ("PS66_11","020_66_11","PSA","66","11","11","Gata nindupewi aminda ninu yapapnane gwa panggaganuking. Panggaganuwa gata meya ninde buyambam gwa penimukuyak. ");
INSERT INTO wnc_vpl VALUES ("PS66_12","020_66_12","PSA","66","12","12","Siwan gata nindane iwanin kapewi ita ninu ayainggamuking. Siwan unzing ninu katapatang yaike gatu yangga paptawan ngana yangga waapane yaikumang binga. Siwan ngana apmanu gata nin keu take noman komune gwa pakapbuyak. ");
INSERT INTO wnc_vpl VALUES ("PS66_13","020_66_13","PSA","66","13","13","Sanga wa nata gae apakapit. Ngan, nata kaau kuut yotdane pakapuke gae katapatang kuutgan sawit. ");
INSERT INTO wnc_vpl VALUES ("PS66_14","020_66_14","PSA","66","14","14","Dasingge? Meya nae apan sanga katapatang kuutgan sawa kapanga kaya aknga singgau gae ganimbakngawitde natake gamunangge yawa kekekakut. ");
INSERT INTO wnc_vpl VALUES ("PS66_15","020_66_15","PSA","66","15","15","Sike kaau siuknga buyambam gwegwenu alta dakane sake gae gamit. Siwan gatu sipsiu wawi gwegwen sawa itane kapangana takeaknga gae apan natapsa. Gatu ikwawa gamanu wawi gwegwenkat memeat kuut pake gae gamunangge asawit. ");
INSERT INTO wnc_vpl VALUES ("PS66_16","020_66_16","PSA","66","16","16","Ginu aminu Anutue gwaukaing aminda apuke natane wamu natapnong. Nata sangabamu Anututa pasike akgatangamukutdane wamu daniwa natapnong. ");
INSERT INTO wnc_vpl VALUES ("PS66_17","020_66_17","PSA","66","17","17","Tupa nata ita gatangamukutde yatawakum. Yatawake ie tandakngake kap taike umana yatangenakum. ");
INSERT INTO wnc_vpl VALUES ("PS66_18","020_66_18","PSA","66","18","18","Sike nata waiakngae musipmaatangu sanga moo ngang take siknga natapbum gamu Buyambam tapata natane tumuk wama dua natapan. ");
INSERT INTO wnc_vpl VALUES ("PS66_19","020_66_19","PSA","66","19","19","Siwan ngana Anututa natane wama gwa natapbut. Siakan siknga, ita natane tumuk wama gwa natapbut. ");
INSERT INTO wnc_vpl VALUES ("PS66_20","020_66_20","PSA","66","20","20","Nata Anututane umana yatangenawit. Dasingge, ita tumuk wamae masa dua namukut. Siwan butaya aknga nae natangamukuu dua sandekut. ");
INSERT INTO wnc_vpl VALUES ("PS67_1","020_67_1","PSA","67","1","1","Nata nataau Anututa butaya natanimuke ninde take pasiikge nataat. Ngan, nata nataau pakapu ninduke nin gatanimikge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS67_2","020_67_2","PSA","67","2","2","Unzingge gatane noman takngaka kepna kepna yuaing aminda akakapning. Unzing tasiwi kuupbamda gandukapmake ninu ita apme papik ngang natapning. ");
INSERT INTO wnc_vpl VALUES ("PS67_3","020_67_3","PSA","67","3","3","Anutu, nata nataau aminbamda gae apbakngake umanda yatangenatningge nataat. Ngan, nata nataau aminu kuupbam kepna kepna nana umanda yatangenatningge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS67_4","020_67_4","PSA","67","4","4","Gata aminbamu wam yaning komune noman takngane kuupbam usanzia, sike aminu kepna kepna yuke kepi sukukaingu gata kepi noman takngane panomanukgayak. Unzingge nata nataau aminbamda musip gwaang natake apbakngananga kap tainingge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS67_5","020_67_5","PSA","67","5","5","Anutu, nata nataau aminbamda gae apbakngake umanda yatangenatningge nataat. Ngan, nata nataau aminu kuupbam kepna kepna nana umanda yatangenatningge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS67_6","020_67_6","PSA","67","6","6","Dasingge, nanamu nindane kepmine kwaapzang aawan kakumang. Siwan Anutu, wa nisane Anutunin, ita ninu take pasikut. ");
INSERT INTO wnc_vpl VALUES ("PS67_7","020_67_7","PSA","67","7","7","Siakan siknga, Anututa ninu take pasikut. Take pasiwawan kake aminu kepna kepna yuaingu ie gepbiatang koyutnong. ");
INSERT INTO wnc_vpl VALUES ("PS68_1","020_68_1","PSA","68","1","1","Nata nataau Anututa zaat enake apuke inane iwana yanikwasiwan kuningge nataat. Ngan, nata nataau aminu Anutue iwana dakngakaingu asiknga teke datakunong. ");
INSERT INTO wnc_vpl VALUES ("PS68_2","020_68_2","PSA","68","2","2","Sike nata nataau got takngata apu kupan taknga puyapan kunggak binga Anututa ina unzakan iwana yanikwasiwan kuningge nataat. Gatu kandel ngang yanikaing gomu katapda isiwan akngwikake yangga daknganggak. Ina unzakan, nata nataau wai aminu Anutue kaine ngwiknga unzing siningge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS68_3","020_68_3","PSA","68","3","3","Siwan ngana nata nataau amin nomanu apbakngake Anutue kaine musip gwaang natake yutningge nataat. Natake waaminda asiknga bakngake yutningge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS68_4","020_68_4","PSA","68","4","4","Nin Anutue kap taike umana aknga yatangenatna. Sike i minga musaatang pukwike aminbamu kayuak kapata apikge kepiapana tana nomatawik. Itane umana Buyambam tapa, ge ginda ie kaine apbaknganong. ");
INSERT INTO wnc_vpl VALUES ("PS68_5","020_68_5","PSA","68","5","5","Anutu inane yotna gapmane yuak. Yuke waatdaka nana gwa kupsatane kayuak. Unzing, waamindane nana binga. Gatu itakan maya apna gwa kupsa kuut kayuke gatayamunggak kapanin. ");
INSERT INTO wnc_vpl VALUES ("PS68_6","020_68_6","PSA","68","6","6","Sike gatu aminu inatakan yuaingge donga yaman undang take yutning. Siwan itakan kautde yuaing aminu sandepewan yotna paku take yutning. Siwan ngana yamandet sikaing aminu yaniwan paku keu gunzit toknga siknga yasinggak komune yutning. ");
INSERT INTO wnc_vpl VALUES ("PS68_7","020_68_7","PSA","68","7","7","Anutu, tupa ga tupan kuke gikane amindabamu yanipakapuke keu amina wena komune gaat waaminkat ngang payawawi sukuking. ");
INSERT INTO wnc_vpl VALUES ("PS68_8","020_68_8","PSA","68","8","8","Sike tapduu waomune Sainai tawandakane miamun sikut. Siwan sopabam takut. Dasingge, Anutu, ga gwa apuyak. Siakan siknga, Isrel nanatane Anutuna, ga gwa api sopa wa tawan miamunu wa sikut. ");
INSERT INTO wnc_vpl VALUES ("PS68_9","020_68_9","PSA","68","9","9","Anutu, gata sopa take siknga gikane kepdakakae tasiwi takut. Tasiwi sopa tawan keu wai daka ngana gatu take sikut. ");
INSERT INTO wnc_vpl VALUES ("PS68_10","020_68_10","PSA","68","10","10","Gikane amindabamda yot gapma gapma keu andakane mitapbing. Ga take sikngaapa. Siwan gata nanamu sangana wena aminde yamukuyak. ");
INSERT INTO wnc_vpl VALUES ("PS68_11","020_68_11","PSA","68","11","11","Buyambam tapata aminabamde wamna yaman aminu kwaapzangga wamu waaknga taku yakapbing. ");
INSERT INTO wnc_vpl VALUES ("PS68_12","020_68_12","PSA","68","12","12","Sike wamu waaknga anzing, “King kapaapaat gatu amak aminaat kuupbam gwa datakuking. Siwan maya yotna yukingga sanga wawita amak gwene pakingu usanzike paking. ");
INSERT INTO wnc_vpl VALUES ("PS68_13","020_68_13","PSA","68","13","13","Ginda amak tasinangge natake keu komdu kuke zikaane katap sake undang dapuna petning. Siwan mayata tauknga gitza siknga silwa gatu gol ngang yaniata pasia pasike kawa take siknga kwait danggam binga sikut. Gupnaapa waenga silwa binga siwan pia sayau waenga goldane kaamang binga gupnaapa unzing sikut.” ");
INSERT INTO wnc_vpl VALUES ("PS68_14","020_68_14","PSA","68","14","14","Sike Anutu kekekngana bamban tapata tawanu Solmon ngang inikaing dakane king tapatu tapatu yanikwasiwan kaut kaut datakuking. Unzing sopa zambam ngang yanikaingu tawanu wandakane kaut kaut tasiwan takut. ");
INSERT INTO wnc_vpl VALUES ("PS68_15","020_68_15","PSA","68","15","15","Tawanu Basan kep komune yuaing dakandaka buyambam siknga. Siwan wandakandakane tawa tawanu buyambam siknga. ");
INSERT INTO wnc_vpl VALUES ("PS68_16","020_68_16","PSA","68","16","16","Ginu tawanu Basan kep komune dakandaka tawa tawanu buyambam siknga, ginu dasingge tawanu dakatu Anututa yutnangge yawan yukut dakae sanga moo binga ngangu kake nataaing? Sike Buyambam tapata tawanu wandakane asinggan asinggan yuwik. ");
INSERT INTO wnc_vpl VALUES ("PS68_17","020_68_17","PSA","68","17","17","Buyambam tapata tawanu Sinai daka teke apu inane yotna buyambam gwekatang kopbut. Sike wa apiu amak amina kwaapzang siknga tekwanziu karis ngang yanikaingu kekeknga amakgane gwegwene yuwa yanipakapuke iat gatake kopbing. ");
INSERT INTO wnc_vpl VALUES ("PS68_18","020_68_18","PSA","68","18","18","Anutu, tapduu gata tawanu enane siknga dakane kopbuyak komune gata kaaut aminu dongu buyambam siknga papi iat gatake kuking. Siwan gata yamandet aminu sangana gae moo gamukingu payamukuyak. Pake ga Anutu, Buyambamtapa yuayak kapaninu tawanu waandakane yutnangge natake tasikuyak. ");
INSERT INTO wnc_vpl VALUES ("PS68_19","020_68_19","PSA","68","19","19","Ninda Buyambam tapatane umana yatangenatnim. Tapdukbamu yuamangu ita nindane meyaninu pakotnake panggak. Ngan, Anututa ninu gatuna papan take yutnim. ");
INSERT INTO wnc_vpl VALUES ("PS68_20","020_68_20","PSA","68","20","20","Nisane Anutuninu waapata gatanimuwawan ninu take yuamang. Anutu, Buyambam tapaninu nindane toiknginda, unzing gatanimuke nin papan ninda dua kumnim. ");
INSERT INTO wnc_vpl VALUES ("PS68_21","020_68_21","PSA","68","21","21","Siakan siknga, Anututa iwana gatukande pasiwan maining. Dasingge, waaminu waiaknga asinggan tawake tasikaing. ");
INSERT INTO wnc_vpl VALUES ("PS68_22","020_68_22","PSA","68","22","22","Sike Buyambam tapata anzing yanggak, “Gindane iwanza Basan kep komune pakapu yuaingu unenana dua. Sike apmea gindane iwanza yanipakapit. Sike yanggabam gwekatang ama kutakngine siknga ba yuaingu, wa unzing, keu maa siknga komune datakuke yuaing binga, wa nata apme pakapit. ");
INSERT INTO wnc_vpl VALUES ("PS68_23","020_68_23","PSA","68","23","23","Siwan ginda iwanza kumzang siknga zipmake kepisata daknga yaiyuk kamunzata iwanzatane daknga takekan ingwamuke naning.” ");
INSERT INTO wnc_vpl VALUES ("PS68_24","020_68_24","PSA","68","24","24","Anutu siwan king kapana, gata amau wagwenu tasike yapbike apbakngawi aminbamda kaut kaut yuke ganduwawan gaat amindabampat gatake apukaing. Aminu kunduta ganduwawan gaat amindabampat apu yotdabam patang kokaing. ");
INSERT INTO wnc_vpl VALUES ("PS68_25","020_68_25","PSA","68","25","25","Sike aminu gaat gatake apukaingu kunduta kap taikaingu gae tupan kukaing. Siwan gwamemingu kundumaman pakaingu masan apukaing. Sike gatu maya matekga wakumu mateknga dakandakasimu yamayuuk apukaing. ");
INSERT INTO wnc_vpl VALUES ("PS68_26","020_68_26","PSA","68","26","26","Sike kap taknga anzing taikaing, Ninu Anututane aminabam, ninu unekan gwa yuamangge Anututane umana yatangenatna. Ninu Isrel nana amin, ninda Buyambam tapanindane umana yatangenatna. ");
INSERT INTO wnc_vpl VALUES ("PS68_27","020_68_27","PSA","68","27","27","Sike Benjamindane donga mateknga apaatzimu tupan kukaing. Siwan Judatane tupan amin gatu aminu Juda nana kuut Benjamindane donga pake yawakaing. Siwan tupan aminu Sebulun gatu Naptali tane ngangu masan yawakaing. ");
INSERT INTO wnc_vpl VALUES ("PS68_28","020_68_28","PSA","68","28","28","Anutu, gata kekekngaka ninde yeutnimuyo. Tupa kekeknga waakngakaneta gatanimukuyak. ");
INSERT INTO wnc_vpl VALUES ("PS68_29","020_68_29","PSA","68","29","29","Sike kingga wamu kundu gatane yotdabamu Jerusalem nana gwende natake ga ganimbakngangge sangaapa kundu moo pakapu gamuning. ");
INSERT INTO wnc_vpl VALUES ("PS68_30","020_68_30","PSA","68","30","30","Gata kaap zong gwenu pitam gatang yangga napnapna kaya komune yuak gwenu kaanga iniyo. Ngan, gata aminu wa kau wawi gwegwen ba mateknga gwegwenda binga tasikaing aminu kaanga yaniyo. Kaanga yaniwawina munu gae puke silwa ngang yanikaingu inane pake gamuning. Sike aminu wa amak tangenake tasinangge take siknga nataaing aminu ayanikwasiwi datakunong. ");
INSERT INTO wnc_vpl VALUES ("PS68_31","020_68_31","PSA","68","31","31","Siwan kingu Isip kep komune nanaapata wam yak amin yaniwan Jerusalem kuke gata puya ita tasiwik kakngae natapningge kuning. Siawan Itiopia nanata gae kataknga tangenake tumuk wam ganining. ");
INSERT INTO wnc_vpl VALUES ("PS68_32","020_68_32","PSA","68","32","32","Ginu aminu dongu kundu kundu yuaingu, ginda Anutue kap taike umana yatangenatnong. Ngan, Buyambam tapae umana yatangenake kap tainong. ");
INSERT INTO wnc_vpl VALUES ("PS68_33","020_68_33","PSA","68","33","33","Sike i ena yekaune kepi sukunggak. Yekau wagwenu tupa siknga yukut. Natapnong. Anututa wamu kekeknga yatewan apunggak. ");
INSERT INTO wnc_vpl VALUES ("PS68_34","020_68_34","PSA","68","34","34","Unzingge ginu aminu kepna kepna yuaingga itane kekekngana buyambam takngae yakapnong. Sike i Isrel amindane king tapana. Nindanu itane kekekngana ena yekap gwene tasinggak kaknga ninda akanim. ");
INSERT INTO wnc_vpl VALUES ("PS68_35","020_68_35","PSA","68","35","35","Isrel nanatane Anutuna yotnabamnane yuaunin, ge ninda ie asiknga gwaukamang. Ita aminabamde kekeknga buyambam yamunggak. Anututane umana yatangenatnong. ");
INSERT INTO wnc_vpl VALUES ("PS69_1","020_69_1","PSA","69","1","1","Anutu, na gatangamuyo. Yangga guyaknganekan gwa akok. ");
INSERT INTO wnc_vpl VALUES ("PS69_2","020_69_2","PSA","69","2","2","Na ngwayuk kanzang buyambam gwekatang pukunggat. Sike keu kekeknga wena ge une yaiwa maik. Na yangga gapmaapaatang pukuwa apaptake apu na usikwatapnangge tasinggak. ");
INSERT INTO wnc_vpl VALUES ("PS69_3","020_69_3","PSA","69","3","3","Anutu, nata ganike ganike yuwawa kekekngana wena singgak. Siwan guyakngata akupiawan kaina toknga. Dasingge, nata gatangamiyakge tupa yawa ngana dua gatangami yuwa mainggak. ");
INSERT INTO wnc_vpl VALUES ("PS69_4","020_69_4","PSA","69","4","4","Sike aminda nae yumdekan iwana dakngakaing. Waakwau kwaapzang siknga. Natane gwapak danggama ita gwa yapbiking. Sike iwanata kem yake yapiina wena nutapan kupitde akekekakaing. Na itane sanga tapatu kukae dua pakum, ngana kemu kwaapzang siknga yake temanggaganuke nanikaing. Kem taknga yawan ninane sanga kundu yamukum. ");
INSERT INTO wnc_vpl VALUES ("PS69_5","020_69_5","PSA","69","5","5","Anutu, ga nae gwa natapbuyak. Na gutongaapa. Natane waina gae kaikane kusopuknga dua yuaing. ");
INSERT INTO wnc_vpl VALUES ("PS69_6","020_69_6","PSA","69","6","6","Buyambam tapa, ga Anutu kekekngaka bamban tapa, gata dua nandutewi nata wai kundu tasiwa gae banip sikaingga maaknga natapning. Ninu Isrel nana amindane Anutunin, gata dua nandutewi sanga kundu pasiwa munu gae pukaing aminde kunduta yanisapdutning. ");
INSERT INTO wnc_vpl VALUES ("PS69_7","020_69_7","PSA","69","7","7","Nata ga gawamba aminu kunduta na sapdut wam naniwawan na apmaakanggat. ");
INSERT INTO wnc_vpl VALUES ("PS69_8","020_69_8","PSA","69","8","8","Gatu ninane notnata nandupanu na dongu takngatune nana singgak. Sike ninane dongata nandupanu na aminu you maa siknga gapmandune nana singgak. ");
INSERT INTO wnc_vpl VALUES ("PS69_9","020_69_9","PSA","69","9","9","Dasingge? Nata yotdae take siknga nataat. Unzingge nata puya kekeknga tasiwa yotda wagwenu take yuwikge tasinggat. Siwan aminda gae ganisapduwa sapdut wamu waaknga naanganu apimanggak. ");
INSERT INTO wnc_vpl VALUES ("PS69_10","020_69_10","PSA","69","10","10","Na kwanam sike nina nanam nananggengu ayandaknganggat. Sike wa tasinggau gae kaikane isangepsa amin dakngake yuwitde tasinggat. Siwan ngana na aminbamda nanisapdukaing. ");
INSERT INTO wnc_vpl VALUES ("PS69_11","020_69_11","PSA","69","11","11","Na butaya tauknga atapa ngana aminda wamu waiaknga nanike sapdut wamu kuut nanikaing. ");
INSERT INTO wnc_vpl VALUES ("PS69_12","020_69_12","PSA","69","12","12","Siwan tupan aminu kundu unekan yukengu nae wamu ayakaing. Sike aminda yangga wainu toknga aknga tangoke atdatdaptakengu kau kundu taikingu atnanisapduyuuk taiking. ");
INSERT INTO wnc_vpl VALUES ("PS69_13","020_69_13","PSA","69","13","13","Siwan ngana undanga, natanu ga Buyambam tapaekan, tumuu ganiwit. Anutu, gata na musip gwaang natangamunggayakge ganinggat. Unzingu gata wa tasinggau nae take siknga natangamuke tanangge gwa yawi kekekakut. ");
INSERT INTO wnc_vpl VALUES ("PS69_14","020_69_14","PSA","69","14","14","Gata na ngwayuk kanzang gwekatang yuwa nanduke apu tapi na wagwekatang dua pukusopuwit. Gata kakuya na tasiwawi iwanata na dua tasiwan maiwit. Unzing, yangga paptake na dua usukwatapik binga gatangamuyo. ");
INSERT INTO wnc_vpl VALUES ("PS69_15","020_69_15","PSA","69","15","15","Gata na dua nandutewi yanggata paptake apu tapik. Gatu dua nandutewi yangga gapma gwekatang pukuwa, kupsa akngata tangganguwan, kupsa aminda yuaing komune pukuwit. ");
INSERT INTO wnc_vpl VALUES ("PS69_16","020_69_16","PSA","69","16","16","Buyambam tapa, asingganu gata nae take siknga natangamunggaak kaknga wa take siknga. Unzingge tumuk wamu ganinggau natake gatangamuyo. Sike gatu nae musip kwikwiu buyambam siknga natangamunggaakge apmanu apuke na gatangamuyo. ");
INSERT INTO wnc_vpl VALUES ("PS69_17","020_69_17","PSA","69","17","17","Sike na gikane puya aminda, unzingge ga nae ma kusopuwim. Na meya buyambamu kaya. Unzingge tumuk wamu ganinggau natake zaat apu yake gatangamuyo. ");
INSERT INTO wnc_vpl VALUES ("PS69_18","020_69_18","PSA","69","18","18","Gatu nae inengan apuke gata na tapso. Gata na iwanatane katakngane sandeke tapso. ");
INSERT INTO wnc_vpl VALUES ("PS69_19","020_69_19","PSA","69","19","19","Sike aminu na nanisapdukaingu gata atnataayak. Gatu itakan umana takepan maakawanu ga atnataayak. ");
INSERT INTO wnc_vpl VALUES ("PS69_20","020_69_20","PSA","69","20","20","Wamu wai wa nanikaingga natdetdetna atasiwan mainggak. Siwan musipmaatangu meyambam natake na kekekngana wena singgak. Na aminu kunduta butaya apme ba natangamuning ngang natapbum ngana tapatuta dua gatangamukut. Gatu aminu kunduta musipma tapan kekekawikge wamu take takngatu apme ba nanining ngang natapbum ngana wena. ");
INSERT INTO wnc_vpl VALUES ("PS69_21","020_69_21","PSA","69","21","21","Na tomma natapbum ngana marasinu gawaknga nanamde tukngwake unin namuking. Gatu guyaknga kupiawan ngana yangga wainu toknga guyaknga nasinanga aknga tangopitde namuking. ");
INSERT INTO wnc_vpl VALUES ("PS69_22","020_69_22","PSA","69","22","22","Sike nata nataau aminu waakwakga nanambam peke unekan yuke nanangge baknganing, ngana tapduu wagwenu sanga wa tasiking kakngata yake bungepda binga papikge nataat. Unzing yapapbam gwenda kaap zongu gwendu tanggak ba gapma dakaatang pukunggak binga. ");
INSERT INTO wnc_vpl VALUES ("PS69_23","020_69_23","PSA","69","23","23","Nata nataau kaina atzikaawan gatuna dua kaningge nataat. Gatu mase gutokake sukuke noman dua dandamake sukuningge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS69_24","020_69_24","PSA","69","24","24","Gata kaanga kekeknga natayamuke meya yamuyo. Gikane musiptok takngata unin asiknga papan gatukande wena sinong. ");
INSERT INTO wnc_vpl VALUES ("PS69_25","020_69_25","PSA","69","25","25","Sike nata nataau yotna gapma yuaingu yotnagomu moo yuwikge nataat. Gatu aminu tapatu sel yotna gwekatangu dua yuwikge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS69_26","020_69_26","PSA","69","26","26","Dasingge, aminu waiaknga tasiwan yake meya tupa yamukuyau wai aminda waakwau gatuna pasiwan maikaing. Sike kundu gupnaapatang toknga yamukuyau, wai aminda sapdut wam yanike meya unekan yamukaing. ");
INSERT INTO wnc_vpl VALUES ("PS69_27","020_69_27","PSA","69","27","27","Sike wai aminu waakwakgane waiaknganae ma botawim. Siwan dua kapewi gatane dongga atang apan unekanu yuwam. ");
INSERT INTO wnc_vpl VALUES ("PS69_28","020_69_28","PSA","69","28","28","Ngan, gata itane umana kayuk yutnanga buk gopatangu atdotdonguyo. Sike itane umanaat gatu noman amindane umanaat unekanu ma matawim. ");
INSERT INTO wnc_vpl VALUES ("PS69_29","020_69_29","PSA","69","29","29","Sike na meya pake toknga buyambam panggat. Anutu, nata nataau gata na gatuka take na noman siknga kayuwiakge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS69_30","020_69_30","PSA","69","30","30","Sike nata kap taike Anututane umana yatangenawit. Gatu gaak inike umana kopsa akngae kuut yakapit. ");
INSERT INTO wnc_vpl VALUES ("PS69_31","020_69_31","PSA","69","31","31","Siwan nata sanga wa tasiwa kake Buyambam tapata take aknga natangamik. Siwan ngana nata kau wawi gwenu ie imunangge natake katap patang sawa kapangana take siknga siwik ngana ita take siknga dua natapik. Ngan, kau wagwenu kepinaat komnaat ngang imanu ita take siknga dua natapik. ");
INSERT INTO wnc_vpl VALUES ("PS69_32","020_69_32","PSA","69","32","32","Sike meya pakaing aminda sanga wa kake waaminda apbaknganing. Sike nata nataau aminu Anutue mun puke gaak inikaingu musia tatanga natake kekeknga gatu paningge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS69_33","020_69_33","PSA","69","33","33","Buyambam tapatanu sanga kundue dapmake iniwanu akgatayamunggak. Ngan, itane amina kundu kauutde ba pewan yuainggeat dua botanggak. ");
INSERT INTO wnc_vpl VALUES ("PS69_34","020_69_34","PSA","69","34","34","Aminu yekap gwene ba kepna kepna yuaingkat gatu yanggabam gwen ba pis undang yuaingkat, ginu kuupbamda Anututane umana yatangenatnong. ");
INSERT INTO wnc_vpl VALUES ("PS69_35","020_69_35","PSA","69","35","35","Dasingge, Anututa Saion nana gatuna iwanae kataune sandeke pake Judatane yotbam gapmanggapma gatu mitapik. Ita unzing tasiwana Anututane aminabamda you wanggapma gapmana pake yuke keu wandaka inae gatukande taning. ");
INSERT INTO wnc_vpl VALUES ("PS69_36","020_69_36","PSA","69","36","36","Anututane puya aminatane bapunata keu wandaka ataning. Atake Anutue gwaam siknga nataaingga keu waomune gatukande asinggan yutning. ");
INSERT INTO wnc_vpl VALUES ("PS70_1","020_70_1","PSA","70","1","1","Anutu, na gatuka asiknga tapso. Buyambam tapa, ga zaat apuke na gatangamuyo. ");
INSERT INTO wnc_vpl VALUES ("PS70_2","020_70_2","PSA","70","2","2","Aminu kunduta na nutapan kupitde tasikaing. Siwan nata nataau gata natdetdetda pakepuke pasiwi botake apmaakaningge nataat. Sike aminu kunduta meya nata panggatdenu apbakngakaing. Gata asiknga yanikwasiwi kuwa gatu yaipakepi umana wena amin daknganingge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS70_3","020_70_3","PSA","70","3","3","Aminu na nanisapduke, “Apa! Gataaa,” ngang nanikaing. Siwan nata nataau waaminda kumzang siknga maakake dasingga yuyuknga yuaingu kake kasatnaningge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS70_4","020_70_4","PSA","70","4","4","Siwan ngana nata nataau aminu gae kukaingu waaminda musip gwaang natanggamuke gae apbaknganingge nataat. Sike aminu kuupbam gata gwa pakuyakga puya aknga tasiyamukuyakge natanggamatake asingganu gae anzing yaning, “Anutu tupan tapa unin,” ngang yaningge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS70_5","020_70_5","PSA","70","5","5","Anutu, na kekekngana wena. Sike na sangaapae dapmake nina gatangamunanga dua. Unzingge gata nae zaatgaman apso. Buyambam tapa, na gika siknga gatangamuke gatuka takuyak. Unzingge ga paiunga ma siwim. Na zaatgaman gata gatangamuyo. ");
INSERT INTO wnc_vpl VALUES ("PS71_1","020_71_1","PSA","71","1","1","Buyambam tapa, nata gae gepbiatang yuwawa gata gatangami iwanata na dua tasiwan maiwit. Gata dua kapewi na napbitning. ");
INSERT INTO wnc_vpl VALUES ("PS71_2","020_71_2","PSA","71","2","2","Ga noman siknga apa. Unzingge gata na gatangamuke na iwanae kataune sandeke gika gatu tapso. Gata tumuk wamae maak pake na gatuka tapso. ");
INSERT INTO wnc_vpl VALUES ("PS71_3","020_71_3","PSA","71","3","3","Ga natane suu buyambam kekeknga gwendu binga dakngake yuyo. Yuwawi na gae gepbiatang akopa gata na kakuya tasiyo. Dasingge, na gaekan apuke na kusopuwit. Gata siknga gatangami na take yuwit. ");
INSERT INTO wnc_vpl VALUES ("PS71_4","020_71_4","PSA","71","4","4","Natane Anutuna, na wai aminde kataune sandeke tapso. Sike waakwau kekeknga siknga siwan yuyuknga wai siknga. ");
INSERT INTO wnc_vpl VALUES ("PS71_5","020_71_5","PSA","71","5","5","Dasingge? Buyambam tapa, na gaekan baniu singgat. Sike na waatdaka yukum komuneta gae baniu sikum. Siwan baniu wa sikumu apmaat kaa baniu asike yuat. ");
INSERT INTO wnc_vpl VALUES ("PS71_6","020_71_6","PSA","71","6","6","Asingganu na gae kataune yuke kepi sukunggat. Mingata tangaikut komuneta kakuya tasinggawi apu apman apunggak. Unzingge nata gatane umanda asinggan yatangenawit. ");
INSERT INTO wnc_vpl VALUES ("PS71_7","020_71_7","PSA","71","7","7","Sike aminbamda meya takngatu takngatu nata kakumu akaaingunin. Kake sanga unzing siknga ninde ba apik, ngang atnataaing. Siwan ngana gatakan na kekeknga siknga kakuya tasinggaak. ");
INSERT INTO wnc_vpl VALUES ("PS71_8","020_71_8","PSA","71","8","8","Tapduk bamu nata gae umanda yatangenake gatane umanda kopsa aknga aminbamde yanikapmanggat. ");
INSERT INTO wnc_vpl VALUES ("PS71_9","020_71_9","PSA","71","9","9","Tapduknga na aminuake siwa kekekngana asisangepanu gata na masa ma namuke napmambim. ");
INSERT INTO wnc_vpl VALUES ("PS71_10","020_71_10","PSA","71","10","10","Dasingge, iwanata nutapan kupitde unekan yuke na tasiwan maiwitde wamu yandeking. ");
INSERT INTO wnc_vpl VALUES ("PS71_11","020_71_11","PSA","71","11","11","Waaminda anzing yaking, “Anututa masa gwa imuke kukutde kake ninda tawake tanggaganutna. Aminu tapatu andangu dua yuuknga gatangamik,” ngang yaking. ");
INSERT INTO wnc_vpl VALUES ("PS71_12","020_71_12","PSA","71","12","12","Ayok, Anutu, gata nae maa ma yuwim. Anutuna, gata zaat siknga apuke gatangamuyo. ");
INSERT INTO wnc_vpl VALUES ("PS71_13","020_71_13","PSA","71","13","13","Nata nataau aminu nae temanggaganupa nanikaingu gata yaipakepuke pasiwi sopuningge nataat. Ngan, waaminda na tasiwan maiwitde tasikaing. Unzingge nata nataau gata natdetdetna pasiwi botake maaknga siknga natapningge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS71_14","020_71_14","PSA","71","14","14","Siwan ngana na gae banip sike asingganu gata gatangamiakgekan ganduyuwit. Sike natanu gatane umanda buyambam siknga yatangenawit. ");
INSERT INTO wnc_vpl VALUES ("PS71_15","020_71_15","PSA","71","15","15","Sike natane genanetanu gata noman taknga tasinggaakge aminbam yanikapit. Gatu gata sangabamu pasikuyak kakngae nangaakan nataat. Siwan ngana undanga. Tapdukbamu gata na takuyakge yaniwit. ");
INSERT INTO wnc_vpl VALUES ("PS71_16","020_71_16","PSA","71","16","16","Anutu, Buyambam tapa, natanu gatane kekekngaka buyambam takngae natake nata umanda ayatangenawit. Sike natanu anzing yakapit, Buyambam tapakan noman tapa unin, ngang yakapit. ");
INSERT INTO wnc_vpl VALUES ("PS71_17","020_71_17","PSA","71","17","17","Anutu, gata tupa na waatdakane nanindamukuyau apu apman kaa unzakan, ge apmanu gata sanga nomanomana tasikuyakge yanikapmanggat. ");
INSERT INTO wnc_vpl VALUES ("PS71_18","020_71_18","PSA","71","18","18","Sike na apmanu aminuake gwa siwa gwapak danggama kwakngakan gwen singgak. Siwan ngana Anutu, gata na ma napmambim. Gaat naat unekan yuke nata gatane kekekngaka buyambam takngae aminu masan aatning aminde yanikapit. ");
INSERT INTO wnc_vpl VALUES ("PS71_19","020_71_19","PSA","71","19","19","Anutu, gatane noman takngaka buyambam siknga enane siknga konggak. Kopan apmanu waaknga aminbamde kaine aanggaman siknga yuak. Sike gata puya buyambam siknga tasikuyak kapanin. Keu andakane nana tapatu ga binga dua yuak. Wena. Gata kuupbam yapbikuyak. ");
INSERT INTO wnc_vpl VALUES ("PS71_20","020_71_20","PSA","71","20","20","Gata tasiwi na meya wai siknga takngatu takngatu apa kakum. Siwan ngana na atnataat, gatanu na gatu tapi kekekawit. Unzing na gapma kupsa aminda yuaing katangga binga yuwawa na gatuka tangenawiyak. ");
INSERT INTO wnc_vpl VALUES ("PS71_21","020_71_21","PSA","71","21","21","Siwan gata tasiwi natane umana aknga buyambam siknga siwik. Siawan natane musipma tasiwi kwikwiknga gatu siyok. ");
INSERT INTO wnc_vpl VALUES ("PS71_22","020_71_22","PSA","71","22","22","Sike nata gita daka tanguyuk gatane umanda yatangenawit. Natane Anutuna, gata wamu tupa yawi kekekakut taknga tawake tasinggayak. Unzingge nata gatane umanda yatangenawit. Isrel nanatane Anutuna, nata gita tanguyuuk kap taike umanda yatangenawit. ");
INSERT INTO wnc_vpl VALUES ("PS71_23","020_71_23","PSA","71","23","23","Yatangenake kapza taiyuuk apbakngawit. Kaau wa taiwiu gae taiwit. Dasingge, gata na gwa takuyak. ");
INSERT INTO wnc_vpl VALUES ("PS71_24","020_71_24","PSA","71","24","24","Unzingge gata noman taknga tasinggaakge aminbamu genaneta tapduu gwendu tembanata kuku bangee yanikapit. Dasingge, aminda na tasiwan maiwitde tasiking, ngana gata waaminu yaipakepuke pasiwi apmaakaking. ");
INSERT INTO wnc_vpl VALUES ("PS72_1","020_72_1","PSA","72","1","1","Anutu, gata King kapa gikane nomana akngaka katak siknga inindamumso. Siwana aminu wam yanangge apningu katak siknga usanziwik. Ga wamu nomana akngakan yanggayaunin. Unzingge gata kingu waapa gatangami ita wamu noman gan usanziwik. ");
INSERT INTO wnc_vpl VALUES ("PS72_2","020_72_2","PSA","72","2","2","Siwan ita gikane amindabamu meya akaing aminu noman taknganekan kakuya tasiwik. ");
INSERT INTO wnc_vpl VALUES ("PS72_3","020_72_3","PSA","72","3","3","Gata tasiwi puya ita pasining katangu sanga kwaapzangga takekan aatning. Ngan, gata tasiwi waaminda noman taknga asinggan tawake tasining. ");
INSERT INTO wnc_vpl VALUES ("PS72_4","020_72_4","PSA","72","4","4","Sike King kapata meya pakaing amindane meyana katak panomanuwik. Panomanuke ita aminu sangaapae dapmakainggane waatdakana akgatayamik. Gatayamuke ita aminu notnaapa pasiwan mainingge tasining aminu yake ayaipakepu pewik. ");
INSERT INTO wnc_vpl VALUES ("PS72_5","020_72_5","PSA","72","5","5","Sike tapduu gunzit ba yekap ngang kakaa asisiyuwawat, gikane amindabamda umandaaknga yatengatnake tasitakuningge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS72_6","020_72_6","PSA","72","6","6","Ngan, gata tasiwi Kingu waapa aminu gwaam tapa dakngawik. Siwan itane nomanaaknga sopata puyaatang pimake pasiwan nanamda takekan akokaing binga siwik. ");
INSERT INTO wnc_vpl VALUES ("PS72_7","020_72_7","PSA","72","7","7","Sike tapduu ita kayuk yuwik kopatangu aminbamda itane noman taknganakan tawaning. Gatu yekau kakaa asisiyuwawan sanga kwaapzangga take aatning. ");
INSERT INTO wnc_vpl VALUES ("PS72_8","020_72_8","PSA","72","8","8","Siwan ita King kapa yuke aminbamu yanggabam gwene wesim yuaingkat gatu yanggabam gwene maa siknga yuaingkat kakuya tasiwik. Siwan itane kepna yangga Yufretis tapaneta tuwanguke kuku kepna kepna kuwan sandewik. ");
INSERT INTO wnc_vpl VALUES ("PS72_9","020_72_9","PSA","72","9","9","Sike aminu zongana wena kepbanu saibumbumna kaya komune yuaingu Kingu waapatane gepbiatanggan koyutning. Koyuwawan itane iwana kepdakaatang pimake yutning. ");
INSERT INTO wnc_vpl VALUES ("PS72_10","020_72_10","PSA","72","10","10","Siwan Kingu Spen nanaapaat gatu Kingu yanggabamda ngwapbasiwan keu mateknga banakan yuaingune nanaatda musip gwaangge sanga kundu ie imuning. Siwan Kingu Arebia nanaapaat gatu Kingu Seba nanaapaatda ie takis pakapu imusan. ");
INSERT INTO wnc_vpl VALUES ("PS72_11","020_72_11","PSA","72","11","11","Kingu kuupbamda waapae munu puke inimbaknganing. Siwan aminu kepna kepna yuaingu kuupbamda itane puya pasingamuning. ");
INSERT INTO wnc_vpl VALUES ("PS72_12","020_72_12","PSA","72","12","12","Dasingge, Kingu waapa sangana wenata iniwanu ita akgatayamik. Ngan, aminu wa sangaapae atdapmakaing aminu kunduta dua gatayamanu, ita ina akgatayamik. ");
INSERT INTO wnc_vpl VALUES ("PS72_13","020_72_13","PSA","72","13","13","Ita aminu kekekngana wena siwan sangaapae dapmake yuwan kake butaya atnatayamunggaunin. Sike aminu sangana wena aminu dua kumningge ita gatuna apapik. ");
INSERT INTO wnc_vpl VALUES ("PS72_14","020_72_14","PSA","72","14","14","Sike wai aminda yaipapaakusike waaminu pandambanutnangge tasiwanu ita waaminu gatu apapik. Ita waaminde take siknga natayamuke unzingu tasiyamik. ");
INSERT INTO wnc_vpl VALUES ("PS72_15","020_72_15","PSA","72","15","15","Nata nataau Kingu waapa tapduu mamaya yuwikge nataat. Yuwawan Arebia nana aminda gol moni ie moo imuningge nataat. Siwan aminbamda Anutue tumuk wam iniwawan ita Kingu waapa asinggan gatangamikge nataat. Siwan tumuk wamu waaknga Anututa tasiwan King kapa take yuwikge ininingge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS72_16","020_72_16","PSA","72","16","16","Sike nata nataau rais gatu wit ngangu kwaapzangga aminbamdane puya naatangu take akopningge nataat. Pakap dakakane takekan aatningge nataat. Unzing Lebanon kep komune akokaing binga. Siwan buyana kwaapzang aake keu kuupbam daka dakane doke yutningge nataat. Unzing zonga zonga kwaapzangga kepna kepna akoke tapan sopunggak binga. ");
INSERT INTO wnc_vpl VALUES ("PS72_17","020_72_17","PSA","72","17","17","Siwan nata nataau aminbamda Kingu waapatane umanae dua botaningge nataat. Dua botake tapdukbamu gunzit gwenda asinggan ena yekaune akowawan waaminda kingu waapae umana yatangenatningge nataat. Siwan aminu dongu kuupbamu Kingu waapata take siknga gatayamik. Siwan waaminda yake waapae wamu take siknga aknga aknga asinining. ");
INSERT INTO wnc_vpl VALUES ("PS72_18","020_72_18","PSA","72","18","18","Anutu, Isrel amindane Buyambam tapanatane umana yatangenatnong. Anutu waapata inatakan sanga takekan pasinggak. ");
INSERT INTO wnc_vpl VALUES ("PS72_19","020_72_19","PSA","72","19","19","Itane umana takeaknga asinggan asinggan yatangenatnong. Siwan nata nataau itane umana kopsa aknga kepna kepna kuupbam tawamban sandewikge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS72_20","020_72_20","PSA","72","20","20","Tumuk wamu Devit, Jesitane waakngata, yakuu anin puyukgak. ");
INSERT INTO wnc_vpl VALUES ("PS73_1","020_73_1","PSA","73","1","1","Anututa Isrel nana aminde take siknga pasinggak. Ngan, Anututa amin musip patang kawan noman gan siwanu ita take pasinggak. ");
INSERT INTO wnc_vpl VALUES ("PS73_2","020_73_2","PSA","73","2","2","Siwan ngana na waiakngaatang paa siknga pimakum. Wa unzing kepi naatang saweknga binga siwan pimake banip singgat takngana tenanga singgak. ");
INSERT INTO wnc_vpl VALUES ("PS73_3","020_73_3","PSA","73","3","3","Dasingge, nata kawanu wai aminu sangana bamban takwak siwan na yamandet aminu waakwakgane sangaapanae geengukum. ");
INSERT INTO wnc_vpl VALUES ("PS73_4","020_73_4","PSA","73","4","4","Sike waaminu meya takngatu dua kaaing. Aho, waaminu gupnaatangu toknga dua pake gupna kekeknga, siwan takekan yuaing. ");
INSERT INTO wnc_vpl VALUES ("PS73_5","020_73_5","PSA","73","5","5","Waaminu meya aminu kunduta pakaing binga dua kaaing. Sike aminu kundu meya takngatu takngatu pakaing, siwan ngana meya wa ninu kuupbamda kaamangu wa dua apukaing. ");
INSERT INTO wnc_vpl VALUES ("PS73_6","020_73_6","PSA","73","6","6","Unzingge waaminda inane umana aknga yapangenakaing. Unzing gupnaapa moo pasibakngake inae apbakngake yuaing. Bakngake yuke aminu kundu yumdekan zipmake pasiwa maikaing. ");
INSERT INTO wnc_vpl VALUES ("PS73_7","020_73_7","PSA","73","7","7","Sike musipnaatangu sanga yamandet taknga tasinangge nataaingunin tasikaing. Ngan, natetdetnaatangu sanga waiaknga tasinangge nataaingunin tasiwa buyambam siknga singgak. ");
INSERT INTO wnc_vpl VALUES ("PS73_8","020_73_8","PSA","73","8","8","Gatu waamindakan kundu sapdut wam yanike waiaknga pasiyamunangge yakaingunin. Sike waakwau yamandet siknga siwan kepi takngatu kake aminu kundu pasiwan mainingge yakaingunin. ");
INSERT INTO wnc_vpl VALUES ("PS73_9","020_73_9","PSA","73","9","9","Waakwakgakan Anutu yekaune yuak kapaaya asinisapdukaing. Sike waakwakgakan inane umana aknga yapangenake aminbamda waakwakga nataaing kaknga tawaningge akekekakaing. ");
INSERT INTO wnc_vpl VALUES ("PS73_10","020_73_10","PSA","73","10","10","Unzingge Anututane aminabamda yamandet sikaing amindane wamna tawaningge yanikaing. ");
INSERT INTO wnc_vpl VALUES ("PS73_11","020_73_11","PSA","73","11","11","Sike wai amindanu anzing yakaing, “Sanga ninda tasinim taknga Anututa natapnanga dua. Anutu enane siknga yuak kapatanu sanga ninda tasinim taknga kakapikge kepi wena,” ngang yakaing. ");
INSERT INTO wnc_vpl VALUES ("PS73_12","020_73_12","PSA","73","12","12","Siwan wai aminda tasikaingu anzing. Waaminu meya takngatu dua kaaing. Dua kake sanga buyambam pakaing, siwan ngana sangana kunduat panangge tasikaing. ");
INSERT INTO wnc_vpl VALUES ("PS73_13","020_73_13","PSA","73","13","13","Na ninae akgwaumba musipma noman gan yukut. Siwan wai takngatui dua tasikum. Asikaya wa buyana dua aakut ba dasing? ");
INSERT INTO wnc_vpl VALUES ("PS73_14","020_73_14","PSA","73","14","14","Dasingge, Anutu, gata nae toknga kwakngaom gatu zikaane ngang namukuyak. Sike tembana tapduu kuut toknga gatane namukuyak. ");
INSERT INTO wnc_vpl VALUES ("PS73_15","020_73_15","PSA","73","15","15","Sike nata wamu takngatu takngatu wai aminda yakaing kaknga yakum gamu, manggamu nata amindabamu ayuaing aminde kem yanike tanzit tasiwam. ");
INSERT INTO wnc_vpl VALUES ("PS73_16","020_73_16","PSA","73","16","16","Siwan nata nangaakan natake wai aminda tasikaing takngae yapii kanangge tasiwa maiwan meya natapbum. ");
INSERT INTO wnc_vpl VALUES ("PS73_17","020_73_17","PSA","73","17","17","Nata tasitakuusika nata Anututane yotnane kopbum. Koke yuwawa natane natdetdetna kakaa sikut. Siwan waomunea sanga wai aminde aawik takngaenu natapbum. ");
INSERT INTO wnc_vpl VALUES ("PS73_18","020_73_18","PSA","73","18","18","Gata pasiwi waaminu kepi saweknga sikngaapane kukaing. Kuwawa gata pasiwi pimake gatukande maining. ");
INSERT INTO wnc_vpl VALUES ("PS73_19","020_73_19","PSA","73","19","19","Zeetgaman siknga waakwau maiking. Sike kungwau waaknga wai siknga kundu. ");
INSERT INTO wnc_vpl VALUES ("PS73_20","020_73_20","PSA","73","20","20","Buyambam tapa, wa mainingu aminu tapatuta mia kaaknga tembana enawan mia waaknga wena zet siknga singgak binga. Ngan, gata aminu waakwau natapi sanga mia kawa wena singgak binga siwik. ");
INSERT INTO wnc_vpl VALUES ("PS73_21","020_73_21","PSA","73","21","21","Sike nata musip maik natake musipmaatangu wai siknga natapbum. ");
INSERT INTO wnc_vpl VALUES ("PS73_22","020_73_22","PSA","73","22","22","Wai natake natane natdetdetna upeet sikut, siwan gatane yuyuk kakngakae dua natapbum. Nata sanga kaikane yumdekan tasinggau, unzing kaap zongga dua natdekaing binga tasinggat. ");
INSERT INTO wnc_vpl VALUES ("PS73_23","020_73_23","PSA","73","23","23","Siwan ngana na gaat asinggan yuamak. Yuke gata katakngane tanggayaunin. ");
INSERT INTO wnc_vpl VALUES ("PS73_24","020_73_24","PSA","73","24","24","Gata wamu take aknga yuyuknga tanomanuwitde atnaninggayak. Ge masande gata na tapi yekaune yutzim. ");
INSERT INTO wnc_vpl VALUES ("PS73_25","020_73_25","PSA","73","25","25","Sike yekapatangu mamin tapatu yuaknga na kakuya tasiwik? Aminu tapatu wena. Gakan siknga gandupa yuayak. Ayok, Anutu, na gae siknga nataat. Na sanga kepdakanenanae nataau wa unzing gae siknga nataat binga dua. ");
INSERT INTO wnc_vpl VALUES ("PS73_26","020_73_26","PSA","73","26","26","Sike gupma ba natdetdetna kekekngana wena siwanu, ayok, Anutu, ga natane kekekngaapana unin. Ga naat yuke gae natapa take siknga siwan asinggan asinggan yuwik. ");
INSERT INTO wnc_vpl VALUES ("PS73_27","020_73_27","PSA","73","27","27","Siakan siknga. Aminbamu gae masa gamukengu wena gatukande sining. Sike aminu kundu tupa gawaking ngana apmanu akgapmaking aminu gata wa pasiwi mainingunin. ");
INSERT INTO wnc_vpl VALUES ("PS73_28","020_73_28","PSA","73","28","28","Siwan ngana na, na gae wesim yuke kawa take singgak. Anutu, Buyambam tapa, ga natane daman gwen siknga dakngake yuayak. Ge nata sanga gata tasinggaakge kuupbam yakapit. ");
INSERT INTO wnc_vpl VALUES ("PS74_1","020_74_1","PSA","74","1","1","Anutu, dasingge gata masa ninde nimukuyak? Ninu amindabamu gatane sipsip gwengwen binga ninduyak ngana gata kaanga asinggan natanimuya? ");
INSERT INTO wnc_vpl VALUES ("PS74_2","020_74_2","PSA","74","2","2","Gata ninu amindabamde gatuka natanimuyo. Tupa siknga nindane bapuninu amindabamu gikae papi yuking. Gika dongu waakngane nana aminu gatayamuke iwande katakngane papi gikane dongga dakngake yuking. Sike dongu waakwakga tawanu Saion dakane yukingu tupa yukuyakge natapso. ");
INSERT INTO wnc_vpl VALUES ("PS74_3","020_74_3","PSA","74","3","3","Sike nindane iwaninda apuke sangabamu you gatane buyambam gwene yuaingu gwa pasiwan maiking. Unzingge gika apu sanga wa maike yuaingge kayo. ");
INSERT INTO wnc_vpl VALUES ("PS74_4","020_74_4","PSA","74","4","4","Gatane iwandata apu yotda gwa take yanggamatake tandotdonguke tasiking. Sike gatane sanga waaminda pake tangie inane sanga tuwanga kaya peking. ");
INSERT INTO wnc_vpl VALUES ("PS74_5","020_74_5","PSA","74","5","5","Gatu katap sanu gikane yotda gwekatang yuaingu sandun pake kuku katap yapundu pasikaing binga unzing pasiking. ");
INSERT INTO wnc_vpl VALUES ("PS74_6","020_74_6","PSA","74","6","6","Sike katap sanu tuwanga gatu kunzi kunzina kaya pasike peya waaminda apuke sandunda mateknga gatu hama buyambamu sanga kekeknga zipmapukaing gwegwenda ngangga zipmakapbing. ");
INSERT INTO wnc_vpl VALUES ("PS74_7","020_74_7","PSA","74","7","7","Zipmakapmakenga gatane yotda gwekaa katapda satewan isikut. Katapda satewan isiwawa you take siknga gikae yutnangge yawi yukut gwen tasiwan wai siknga maikut. ");
INSERT INTO wnc_vpl VALUES ("PS74_8","020_74_8","PSA","74","8","8","Sike waaminda musiaatangu ninu asiknga yaipakepnangge natapbing. Unzingge miti you kuupbamu ninde keune yuaingu sapewan yasiking. ");
INSERT INTO wnc_vpl VALUES ("PS74_9","020_74_9","PSA","74","9","9","Sike tuwangu gata tupa ninde yeutnimukuyak ngana apmanu dua yeutnimi tuwangu wa binga dua kaamang. Siwan apmanu yakapsa aminu tapatu nikat dua yuamang. Unzingge nikat nana tapatuta meya wa kaamanggane tapduknga wena siwikgane dua nataak. ");
INSERT INTO wnc_vpl VALUES ("PS74_10","020_74_10","PSA","74","10","10","Anutu, tapdukbamu yutnimu iwaninda sapdut wamu unzing ganikaning? Siwan wamu wai gae umandae asingganu unzing yakaning? ");
INSERT INTO wnc_vpl VALUES ("PS74_11","020_74_11","PSA","74","11","11","Dasingge gata gatanimunanga dua? Dasingge ga moo siknga yuke waaminu yake dua pasiwi maining? ");
INSERT INTO wnc_vpl VALUES ("PS74_12","020_74_12","PSA","74","12","12","Siwan ngana Anutu, tupa siknga ga nindane King kapanin dakngake yukuyak. Siwan apman kaa ga nindane king kapa yuayak. Unzingge gata asinggan gatanimuke nin gatuka papi amak gwekatang meya dua pakamang. ");
INSERT INTO wnc_vpl VALUES ("PS74_13","020_74_13","PSA","74","13","13","Sike gikane kekeknga akngane yanggabam gwenu wesiwi kaukaut paku yukumayak. Siwana gata Isip nana aminbamu pasiwi maiking. Pasiwi maikingu wa unzing pis buyambam siknga gwendu yanggabam gwene nana binga pasiwi maiking. ");
INSERT INTO wnc_vpl VALUES ("PS74_14","020_74_14","PSA","74","14","14","Ngan, gata pukpuu buyambamu tapatane gwapaknga wesikuyak. Siwan gata itane gupnaapa kaap zongu saibumbum kwaimune yuaingge yami naking. ");
INSERT INTO wnc_vpl VALUES ("PS74_15","020_74_15","PSA","74","15","15","Sike gata tasiwi yangga kepbanang katangga akoke zipmake kuking. Siwan yangga buyambam tapaapa gika pasiwi kuupbam atzakngaking. ");
INSERT INTO wnc_vpl VALUES ("PS74_16","020_74_16","PSA","74","16","16","Gata kakaa akngaat gatu zikaa dakaat pasikuyak. Siwan gunzitkat gatu yekapat ngangu enane pekuyak. ");
INSERT INTO wnc_vpl VALUES ("PS74_17","020_74_17","PSA","74","17","17","Siwan tuwangu yanggabamdane kwaimtapa takngai binga gwa tekuyak. Sike gunzit tapduk gatu sopa tapduk ngang nakanu gwendu gwenduatang siwikge gwa tekuyak. ");
INSERT INTO wnc_vpl VALUES ("PS74_18","020_74_18","PSA","74","18","18","Buyambam tapa, ga ma siknga botawim. Iwandata gae sapdut wamu asinggan yakaing. Waaminu katum binga, ge gae natapanu sanga moo binga singgak. ");
INSERT INTO wnc_vpl VALUES ("PS74_19","020_74_19","PSA","74","19","19","Sike gikane aminda kekekngana wena. Unzingge gata dua nindupewi iwaninu waakwakga ninu pasiwan mainim. Ninu gikane amindabamu iwaninda asiknga pasiwa maikamang. Ge gata ninde ma siknga botawim. ");
INSERT INTO wnc_vpl VALUES ("PS74_20","020_74_20","PSA","74","20","20","Sike keu kuupbam ninda yuamang kokopatangu, amak kaknga yumdekan tasikaing. Unzingge wamu gata ninu amindabamde yawi kekekakut takngae ma botawim. ");
INSERT INTO wnc_vpl VALUES ("PS74_21","020_74_21","PSA","74","21","21","Gata dua kapewi wai aminda aminu kundu yainggamuke pasiwa datakuke maakaning. Sike nata nataau gata sangaapae dapmakaingunin gatayami gatane umanda ayatangenatningge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS74_22","020_74_22","PSA","74","22","22","Anutu, gata apuke wamu kekeknga aknga iwandae yaniyo. Sike tapdukbamu gae sapdut wamu yamandet aminda yakaingu atnatayuyo. ");
INSERT INTO wnc_vpl VALUES ("PS74_23","020_74_23","PSA","74","23","23","Sike iwandatanu asainggamatake ga akganisapdukaing. Ita kapzang siknga asinggan ainggamatakaing kaknga natake moo ma yuwim. Anutu, gata gakngat buyambam iwanda waakwakga tasikaing kaknganae ma botawim. ");
INSERT INTO wnc_vpl VALUES ("PS75_1","020_75_1","PSA","75","1","1","Anutu, ninda gae gaak kaknga akganikamang. Akganike umanda asinggan yatangenakamang. Yatangenake gatane umanda kopsa akngae yakapmakamang. Aminbamda sanga inata inata take siknga gata pasikuyakge yakaing. ");
INSERT INTO wnc_vpl VALUES ("PS75_2","020_75_2","PSA","75","2","2","Anututa anzing yakut, “Nata wam yaningge tapduk gwenu gwa yawa yukut. Sike nata wa usanziwiu noman gan. Gutonga dua siwik,” ngang yakut. ");
INSERT INTO wnc_vpl VALUES ("PS75_3","020_75_3","PSA","75","3","3","Siwan anzing yakut, “Kepdakata saasitakuwan aminu une yuaingga tanggaganuwa kekeknga yuwik. ");
INSERT INTO wnc_vpl VALUES ("PS75_4","020_75_4","PSA","75","4","4","Nata yamandotdong aminu anzing yaninggat, ‘Ginu yamandeu ma siwam.’ Sike gatu wai aminu anzing yaninggat, ‘Ginda gisane umanza ma yapangenawam. ");
INSERT INTO wnc_vpl VALUES ("PS75_5","020_75_5","PSA","75","5","5","Ginu gisane kekeknga akngasae ma bakngawam. Siwan ma yanggamatake na sapdut wamu ma naniwam.’” ");
INSERT INTO wnc_vpl VALUES ("PS75_6","020_75_6","PSA","75","6","6","Sike aminu tapatutane umana takekopnanga aminu tapatu gunzitda akonggak katang ba gunzitda pukunggak katang ba amunggwak ba aigwak ngangu wena. ");
INSERT INTO wnc_vpl VALUES ("PS75_7","020_75_7","PSA","75","7","7","Anutu awiapatakan nindane yuyuknginu usanzikgak. Itanu aminu tapatutane umana atakepuke tapatutane umana atakekonggak. ");
INSERT INTO wnc_vpl VALUES ("PS75_8","020_75_8","PSA","75","8","8","Sike Buyambam tapata kau gomdu wainu toknga aknga tukngwamban dopan takut. Ita yangga waaknga wai aminu kuupbamde tukngwayaman tangopa puyuwik. Ina unzakan wai aminu Anutue kaine siknga wamu yaning ngana, gatukande siknga wena sining. ");
INSERT INTO wnc_vpl VALUES ("PS75_9","020_75_9","PSA","75","9","9","Siwan ngana nata Jekopdane Anutunae umana asinggan yakapit. Yakapmake nata kau kumzang taike umana buyambam siknga yatangenawit. ");
INSERT INTO wnc_vpl VALUES ("PS75_10","020_75_10","PSA","75","10","10","Sike Anututanu wai amindane kekekngana apasiwan sopuning. Siwan ngana noman amindenu kekeknga buyambam siknga yamik. ");
INSERT INTO wnc_vpl VALUES ("PS76_1","020_76_1","PSA","76","1","1","Sike Juda amindanu Anutue atnataaing. Ngan, Isrel amindanu umana kopsa akngae natake yatangenakaing. ");
INSERT INTO wnc_vpl VALUES ("PS76_2","020_76_2","PSA","76","2","2","Sike itane yotna gwenu Jerusalem yot gapmane yuak. Ita tawanu Saion dakane asinggan yuak. ");
INSERT INTO wnc_vpl VALUES ("PS76_3","020_76_3","PSA","76","3","3","Ita waomune yuke iwanatane sakut ba tiunggu gatu gwauyana ngang zipbukut. Ngan, Anututa sanga amakgane kuut siknga gwa pasiwan maiking. ");
INSERT INTO wnc_vpl VALUES ("PS76_4","020_76_4","PSA","76","4","4","Anutu, gatane umanda kopsa siknga siwan ga kakaa akngane yuwaak. Tawanu buyambam dakandaka enane yuaing. Siwan ngana gatane umanda kopsa siknga akngata ayapbikgak. Tawanu wa dakandakane kaap zong gwengwenu buyambam siknga yuaing. ");
INSERT INTO wnc_vpl VALUES ("PS76_5","020_76_5","PSA","76","5","5","Sike aminu kunduta amak aminu kekeknga akwakgane sangana gwa sandeking. Sike amak aminu waakwau gwa kumbing. Unzingge aminu tapatu amak aminu waakwakge dongune nanata kataknga tangenatnanga dua. ");
INSERT INTO wnc_vpl VALUES ("PS76_6","020_76_6","PSA","76","6","6","Siwan Jekopdane Anutuna, gata kaanga yaniwi hos gwegwekat aminu hos tangan pukwikingkat kuupbam gwa kungwake kepdakane kuma yuaing. ");
INSERT INTO wnc_vpl VALUES ("PS76_7","020_76_7","PSA","76","7","7","Siwan ngana Anutu, aminu gae asiknga gwaukaing. Unzingge gata kaanga yaniwinu mamin amin tapata gae kaikane dandamake yuwik? Aminu tapatuta yutnanga dua. ");
INSERT INTO wnc_vpl VALUES ("PS76_8","020_76_8","PSA","76","8","8","Ga yekaune yuke gata wam yaningge natapi kekekawan waaminbamdane wamna gwa usanzikuyak. Usanziwi aminu kuupbamda asiknga gwauke wamu dua yaking. ");
INSERT INTO wnc_vpl VALUES ("PS76_9","020_76_9","PSA","76","9","9","Sike tapduu waomune gata amindane wam usanzitnangge enakuyak. Enake gata aminu meya kaaingu kuupbam gatuka panangge tasikuyak. ");
INSERT INTO wnc_vpl VALUES ("PS76_10","020_76_10","PSA","76","10","10","Gata aminu kundue musiptok nataayak, siwan ngana musiptou waakngata tasiwan aminu kunduta gatane umanda ayatangenatning. Sike aminu musiptou gatane akngata dua pasiwan maikingu gae munu apuke ganining. ");
INSERT INTO wnc_vpl VALUES ("PS76_11","020_76_11","PSA","76","11","11","Sike ga wamu takngatu Anutu, Buyambam tapakae yawi kekekawiu waaknga atawamso. Nata nataau aminu kuupbamda Buyambam tapae akgwauke sanga ie apakapuke imuningge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS76_12","020_76_12","PSA","76","12","12","Sike gwapaknga amin yamandet sikaingu ayaipakepunggak. Kingu kepna kepna yuaingga ie asiknga gwaukaing. ");
INSERT INTO wnc_vpl VALUES ("PS77_1","020_77_1","PSA","77","1","1","Nata Anutue kapzang siknga yatawakum. Ngan, ita natane tumuk wamma natapikge yatawakum. ");
INSERT INTO wnc_vpl VALUES ("PS77_2","020_77_2","PSA","77","2","2","Sike meya tapduk siwan nata tumuk wamu Buyambam tapae yakum. Yake nata zikaa kuupbam tumuk wamu asinikum. Siwan ngana musip kwikwik taknga dua takum. ");
INSERT INTO wnc_vpl VALUES ("PS77_3","020_77_3","PSA","77","3","3","Na Anutue natanggamataawanu musipmaatangu kwanam sikut. Atnatayuwawa gan musipmaatangu meya sikut. ");
INSERT INTO wnc_vpl VALUES ("PS77_4","020_77_4","PSA","77","4","4","Anutu, gata dua nandutewi dapuna pekum. Natapanu natane musipmaatangu meya siknga sikut. Unzingge na wamu yananga dua. ");
INSERT INTO wnc_vpl VALUES ("PS77_5","020_77_5","PSA","77","5","5","Sike natdetnaatangu tapduu tupa siknga nanae natapbum. Siakan siknga, na nakan bamu apu napbikingge gatuna natapbum. ");
INSERT INTO wnc_vpl VALUES ("PS77_6","020_77_6","PSA","77","6","6","Sike zikaane nata natdetdetbam pake yukum. Yuke tupa kap taisika tasikum takngae asinggan natayukum. Natayuke natdetdetbam pake ninae anzing yakwaikum. ");
INSERT INTO wnc_vpl VALUES ("PS77_7","020_77_7","PSA","77","7","7","Asikaya Buyambam tapata masa asinggan ba namik? Ba asikaya nae apmea take dua ba natangamik? ");
INSERT INTO wnc_vpl VALUES ("PS77_8","020_77_8","PSA","77","8","8","Gatu nae butaya tupa natangamukut taknga apmanu dua ba natangamik? Wamu yawan kekekakut taknga gwamba pimakut, ba dasing? ");
INSERT INTO wnc_vpl VALUES ("PS77_9","020_77_9","PSA","77","9","9","Asikaya Anutu ninde gwa ba botakutde musip kwikwiu dua natanimik? Ba kaanga akngata ba musip kwikwik kaknga umukut? ");
INSERT INTO wnc_vpl VALUES ("PS77_10","020_77_10","PSA","77","10","10","Sike meya waakngae natake nata anzing natapbum, Asikaya Anutu enane siknga yuak kapata natapan siwan apba napmakut. Unzingge na sanga waakngae natake iniwit. ");
INSERT INTO wnc_vpl VALUES ("PS77_11","020_77_11","PSA","77","11","11","Apmanu Anututa puya buyambam taknga aknga pasikutde gatu natapit. Ngan, nata sanga buyambam inata inata tupa pasikuyakge gatuna natatakuuwit. ");
INSERT INTO wnc_vpl VALUES ("PS77_12","020_77_12","PSA","77","12","12","Nata sangabamu pasikuyakge natapasiwit. Gata puya kekeknga pasikuyak, ge nata iatdeat kuut natapit. ");
INSERT INTO wnc_vpl VALUES ("PS77_13","020_77_13","PSA","77","13","13","Anutu, gatane yuyukga take siwan noman gan siknga. Sike anutu pupuknga tapatuat gaat ina unzakan dua. Gata anutu pupuknga waakwau asiknga yapbikuyak. ");
INSERT INTO wnc_vpl VALUES ("PS77_14","020_77_14","PSA","77","14","14","Anutu, ga awia apatakan, sanga duya takngatu takngatu pasinggayak. Sike gata kekekngaka buyambam taknga aminu kepna kepna yukingu kuupbamde yeuyamunggayak. ");
INSERT INTO wnc_vpl VALUES ("PS77_15","020_77_15","PSA","77","15","15","Gikane kekeknga waakngane amindabamu gatuka pakuyak. Sike wa pakuyau Jekopat gatu Josepatdane bapuna masan aakingunin pakuyak. ");
INSERT INTO wnc_vpl VALUES ("PS77_16","020_77_16","PSA","77","16","16","Anutu, tupa yangga anga anga ganduke akgwauking. Gwauke yanggabam gwenu miamun sitakukut. Ngan, keu yanggabam amakatangu kutakngi komune yuaingu saasitakukut. ");
INSERT INTO wnc_vpl VALUES ("PS77_17","020_77_17","PSA","77","17","17","Sike sopa enandangga buyambam siknga taawan gakngat gwekaa buyambam siknga kaapmapa yakut. Yaawan yapasik kaa kuwan apan kuupbam sikut. ");
INSERT INTO wnc_vpl VALUES ("PS77_18","020_77_18","PSA","77","18","18","Gata tasiwi gakngat gwenu got taknga pinggu yemi dakngakutde banakan katang yakut. Sike yapasikga siwan kepna kepna kuupbam kakaa sikut. Siwan kepdaka ayamuyamu yuuk yukut. ");
INSERT INTO wnc_vpl VALUES ("PS77_19","020_77_19","PSA","77","19","19","Gata yanggabam gwene banakan kukuyak. Ngan, gatane kepiapaka yanggabam gwende banakan yuak. Siwan ngana kepi tangga aminu tapatuta kananga dua singgak. ");
INSERT INTO wnc_vpl VALUES ("PS77_20","020_77_20","PSA","77","20","20","Siwan ga tupan kayuke kuwawi gatane amindabamda masan gawaking. Gata puya waaknga Moses kat gatu Aron katde yamukuyak, siwan waapaatda kakuya pasikumayak. ");
INSERT INTO wnc_vpl VALUES ("PS78_1","020_78_1","PSA","78","1","1","Ginu natane aminabam, nata wamu danindamutnangge natat taknga daniwa katak natapnong. Ginu maak pake wamu nata yananggenggatde natapnong. ");
INSERT INTO wnc_vpl VALUES ("PS78_2","020_78_2","PSA","78","2","2","Nata tuwang wamu gin daninangge nataat. Nata sanga inata inata tupata apu apman kusopuknga yuaingge daniwa natapnong. ");
INSERT INTO wnc_vpl VALUES ("PS78_3","020_78_3","PSA","78","3","3","Tupa bapuninda sanga wande gwa niniwa natapbumang. Siwan ninu gwa natake atnatayuamang. ");
INSERT INTO wnc_vpl VALUES ("PS78_4","020_78_4","PSA","78","4","4","Nindane waatdakaninda natapningge wamu waaknga dua takusopunim. Aho. Ninda engangu kayuu aatning kaa ayaninim. Ninda Anututane kekeknganae puya kekeknga pasike duya takngatu takngatu pasikutde ngang yaninim. ");
INSERT INTO wnc_vpl VALUES ("PS78_5","020_78_5","PSA","78","5","5","Anututa mama wamu aminu Isrel nanae yamukut. Ngan, wamu wa dongu Jekopdane bapunae yanikut, waaminda atawaningge. Ita bapuninu tupa anzing yanikut, “Ginda waatdakasa katak siknga natane mama wama kuupbam yanindamutnong.” ");
INSERT INTO wnc_vpl VALUES ("PS78_6","020_78_6","PSA","78","6","6","Siwan waatdaka masan aatning kaa atnatapning. Natake waaminda gatu inane waaknga aatningunin yanining. ");
INSERT INTO wnc_vpl VALUES ("PS78_7","020_78_7","PSA","78","7","7","Sike unzing tasiwanu dongu waakwakaa Anutue baniu asining. Banip sike sanga wa pasikutde dua botaning. Siwana itane mama wamu kuutgan tawaning. ");
INSERT INTO wnc_vpl VALUES ("PS78_8","020_78_8","PSA","78","8","8","Asikaya waaminu bapunata tasiking takngakan tasinang. Sike waakwakgane bapuna yamandet sike Anututane wamu ayamasandeking. Siwan ie baniu kekeknga dua siking. Gatu itane wam takngaaya asinggan dua tawaking. ");
INSERT INTO wnc_vpl VALUES ("PS78_9","020_78_9","PSA","78","9","9","Tupa Efraim nana kweem gatu sakut ngang pake amnangge tandakngaking. Ngana tapduu waomune amak kaknga buyambam siwan kake atdatakuking. ");
INSERT INTO wnc_vpl VALUES ("PS78_10","020_78_10","PSA","78","10","10","Aminu waakwau Anututane pasap wam taknga dua tawaking. Siwan mama wam takngaaya dua tawaking. ");
INSERT INTO wnc_vpl VALUES ("PS78_11","020_78_11","PSA","78","11","11","Sike sanga ita pasikutde apbotaking. Siwan duya takngatui waaminde kaine yeuyamukut kaa kuut abotaking. ");
INSERT INTO wnc_vpl VALUES ("PS78_12","020_78_12","PSA","78","12","12","Siwan bapunatane kaine Anututa duya takngatu keu Soan yot gapma Isip kep komu yuwaune tasikut. ");
INSERT INTO wnc_vpl VALUES ("PS78_13","020_78_13","PSA","78","13","13","Ita yanggabam gwenu wesiwan kaukaut kuwan daman binga dakngawan Isrel nana banakan tapane yanipakapbut. ");
INSERT INTO wnc_vpl VALUES ("PS78_14","020_78_14","PSA","78","14","14","Sike gunzit tapane i minga musiaatang yuke ita waaminde tupan kukut. Gatu zikaane katap gwendane kakaa akngaatang yuke tupanu ita kukut. ");
INSERT INTO wnc_vpl VALUES ("PS78_15","020_78_15","PSA","78","15","15","Gatu ita sanga wena kepban komune kuke sup gwegwen zipan yangga buyambam siknga apaapata undangga akopbut. Akopan waakwakga tangopan take sikut. ");
INSERT INTO wnc_vpl VALUES ("PS78_16","020_78_16","PSA","78","16","16","Ita tasiwan yangga sup ganang katangga akoke yangga buyambamu mekngan katangga akoke zipmakaing binga zipbut. ");
INSERT INTO wnc_vpl VALUES ("PS78_17","020_78_17","PSA","78","17","17","Siwan ngana waaminda waiaknga Anutu enane siknga yuak kapae tasiking. Sike wa tasikingu sangana wena kepban komune yuke yamandeu tasiking. ");
INSERT INTO wnc_vpl VALUES ("PS78_18","020_78_18","PSA","78","18","18","Waaminda Anutu tanzike anzing tasiking. Sike waaminda nanamu napan take siknga singgak kapa Anututa yamikge kumzang yanggamataking. ");
INSERT INTO wnc_vpl VALUES ("PS78_19","020_78_19","PSA","78","19","19","Waaminda Anutue sapdut wamu anzing yaking, “Asikaya Anututa ninde nanamu kepban kopatang kwaapzang siknga apme nimik ba dasing,” ngang yaking. ");
INSERT INTO wnc_vpl VALUES ("PS78_20","020_78_20","PSA","78","20","20","Siakan, ita sup gwen tanguwan yangga buyambamu undangga akopbing. Siwan ngana dasingge? Ita ninu aminabamde poyak kat gatu kaap kat apme ba nimik, ba dasing? ");
INSERT INTO wnc_vpl VALUES ("PS78_21","020_78_21","PSA","78","21","21","Ayok. Buyambam tapata waamindane wamna natake kaanga siknga natapbut. Kaanga natake ita katau enandangga Jekopdane dongge tewan epbut. Sike Isrel nana aminde kaanga natapbut taknga kuku buyambam siknga sikut. ");
INSERT INTO wnc_vpl VALUES ("PS78_22","020_78_22","PSA","78","22","22","Dasingge, waakwau Anutue baniu dua siking. Siwan anzing natapbing, “Apmea ba gataniman take yutnim, ba dasing?” ");
INSERT INTO wnc_vpl VALUES ("PS78_23","020_78_23","PSA","78","23","23","Siwan ngana undanga, ita enandangge yawan yekap gwenu gwambok binga zikut. ");
INSERT INTO wnc_vpl VALUES ("PS78_24","020_78_24","PSA","78","24","24","Ziwan nanamu Mana ngang yania pewan kepdakane pimapa pake naking. Sike wa nakingu nanamu yekaune nana yaman naking. ");
INSERT INTO wnc_vpl VALUES ("PS78_25","020_78_25","PSA","78","25","25","Sike nanamu wa angelatane nanam yamukut. Anututa nanamu kwaapzang yaman napa takekan sikut. ");
INSERT INTO wnc_vpl VALUES ("PS78_26","020_78_26","PSA","78","26","26","Siwana masande ita tasiwan got taknga gunzitda akonggak katangga puyapbut. Siwan inane kekeknga aknganekan tasiwan got taknga amunzingga puyapbut. ");
INSERT INTO wnc_vpl VALUES ("PS78_27","020_78_27","PSA","78","27","27","Puyawawa itakan tasiwan kwait gwegwenu kwaapzang siknga waaminde banakan kepdane kupopong binga ba saisai yanggabam gwende kwaimune kaamang bingata pimaking. ");
INSERT INTO wnc_vpl VALUES ("PS78_28","020_78_28","PSA","78","28","28","Anututa kwaiu yot gapma banakan pewan epbing. Epuke sel yotna ayuking gwegwene yupbasiking. ");
INSERT INTO wnc_vpl VALUES ("PS78_29","020_78_29","PSA","78","29","29","Unzing kwaapzang siknga ge napan musia akgitnaking. Sike sanga wa Anutue sitawanggawan yamukut. ");
INSERT INTO wnc_vpl VALUES ("PS78_30","020_78_30","PSA","78","30","30","Sike waakwau undang atnayuking. Waaminda dua napan puyuwan ");
INSERT INTO wnc_vpl VALUES ("PS78_31","020_78_31","PSA","78","31","31","Anututa musiptok natake aminu kekekngana kaya atzipan kumbing. Sike wa kumbingu wawi mateu Isrel nana take siknga tapaapata kumbing. ");
INSERT INTO wnc_vpl VALUES ("PS78_32","020_78_32","PSA","78","32","32","Anututa duya takngatui waaminde apasiwan kake ngana waiaknga kumzang tasike Anutue baniu dua siking. ");
INSERT INTO wnc_vpl VALUES ("PS78_33","020_78_33","PSA","78","33","33","Unzingge ita waaminu pasiwan sanga pasiking kakngata buyana dua aawan yutake kusika akumbing. Ngan, ita aminu waakwakge pasiwan asiknga gwauke yutake kusika kumbing. ");
INSERT INTO wnc_vpl VALUES ("PS78_34","020_78_34","PSA","78","34","34","Sike Anututa aminu kundu atzipan kumbing. Kupa kake dua kumbing aminu musia kapzang tapatekwamban ie apuke tumuk wamu kekeknga iniking. ");
INSERT INTO wnc_vpl VALUES ("PS78_35","020_78_35","PSA","78","35","35","Inike gatu anzing natdeking, Anutu nin ninduyuak kapanin. Anutu enane siknga yuak kapa nin gatanimunggaunin ngang natapbing. ");
INSERT INTO wnc_vpl VALUES ("PS78_36","020_78_36","PSA","78","36","36","Siwan ngana masande kem yake gatu geyangga ie yumdekan yaking. ");
INSERT INTO wnc_vpl VALUES ("PS78_37","020_78_37","PSA","78","37","37","Sike waaminda ie wamu dua gwaamuking. Dua tawake pasap wamu iat tasiking kaknga atzipbuking. ");
INSERT INTO wnc_vpl VALUES ("PS78_38","020_78_38","PSA","78","38","38","Siwan ngana Anututa musip kwikwik natayamuke waiakngana asandeyamukut. Sandeyamuke dua pasiwan maiking. Ita asinggan gatu gatu kaanga natapbut taknga ateke musiptok kaknga dua natayaman buyambam siknga dua sikut. ");
INSERT INTO wnc_vpl VALUES ("PS78_39","020_78_39","PSA","78","39","39","Itanu waaminde anzing natayamukut. Waakwau aminu gupnakan yuke akumnanga unin. Ngan, waakwau got takngata apuke kunggak binga. ");
INSERT INTO wnc_vpl VALUES ("PS78_40","020_78_40","PSA","78","40","40","Sike tapdukbamu sangana wena kepban komune yukingu yamandet tasike ie wamu gatu gatu ayamasandeking. Ayamasandeke tapduk bamu tasiwawa kake Anututa musiaatangu meyambam natapbut. ");
INSERT INTO wnc_vpl VALUES ("PS78_41","020_78_41","PSA","78","41","41","Sike Isrel nana aminda tanzit taknga Anutue tasikingu dua teking. Anutu waapa kepi dundumna takngakan tawake tasinggak kapanin. Waaminda tanzit taknga ie tasiwawa musiaatangu meya natapbut. ");
INSERT INTO wnc_vpl VALUES ("PS78_42","020_78_42","PSA","78","42","42","Waaminda kekeknga buyambamu Anututa tasikut takngae dua natdeking. Tupa siknga tapduu ita iwanae kataune sandeke pakutde dua natapbing. ");
INSERT INTO wnc_vpl VALUES ("PS78_43","020_78_43","PSA","78","43","43","Sike tapduu waomune ita duya takngatu takngatu Soan kep komu, Isip kep komu yuwaune tasikut. ");
INSERT INTO wnc_vpl VALUES ("PS78_44","020_78_44","PSA","78","44","44","Anututa yangga tapan tekwamban tasiwan dak siwa Isipnana aminda tangopnanga dua sikut. ");
INSERT INTO wnc_vpl VALUES ("PS78_45","020_78_45","PSA","78","45","45","Gatu itakan ingut kat gwapbam pat kwaapzang siknga pewan waaminde kuking. Kuke ingutda ayasiwawan gwapbamda sanga puya naatang nana kwaapzang pasiwa maiking. ");
INSERT INTO wnc_vpl VALUES ("PS78_46","020_78_46","PSA","78","46","46","Siwan Anututa gatu gwakgwak kat apmak kat pewan apu sanga puyanaatang akopbingunin nayamuking. ");
INSERT INTO wnc_vpl VALUES ("PS78_47","020_78_47","PSA","78","47","47","Ita sopa zambum pewan epu wainu tapunu apasiwan maiking. Siwan aisda katau baap dakandaka pasiwan maiking. ");
INSERT INTO wnc_vpl VALUES ("PS78_48","020_78_48","PSA","78","48","48","Sike sopa zambumu buyambamda epuwawa yapasik sike ikwawa gamankat sipsipnaat atzipan kungwayamuking. ");
INSERT INTO wnc_vpl VALUES ("PS78_49","020_78_49","PSA","78","49","49","Ngan, ita kaanga kumzang siknga natayamuke waaminde meyambam yamukut. Yamuke angelana yanipewan kuku pasiwa meya buyambam paking. ");
INSERT INTO wnc_vpl VALUES ("PS78_50","020_78_50","PSA","78","50","50","Ita musiaatang toknga natayamuke waaminu dua kapekut. Aho. Ita maiu buyambam takngatu tewan apu zipan yumdekan kungwa takuking. ");
INSERT INTO wnc_vpl VALUES ("PS78_51","020_78_51","PSA","78","51","51","Sike dongu Isip nanatane waaknga tupan tapaapa kuutgan zipan kumbing. Ngan, dongu Hamdane waaknga zipan kumbing. ");
INSERT INTO wnc_vpl VALUES ("PS78_52","020_78_52","PSA","78","52","52","Siwan ngana ita unzing sipsip kayuya apa dakngake tupan kuke aminabamu yanipake kuke kayukut. Sike keu sangana wena komune kukingu kepi ita yeuyamukut. ");
INSERT INTO wnc_vpl VALUES ("PS78_53","020_78_53","PSA","78","53","53","Waaminu yanipake kuwan take yuke dua gwauking. Siwan ngana yanggabam gwenu kaukaut yukutda apu iwana asusikwatapbut. ");
INSERT INTO wnc_vpl VALUES ("PS78_54","020_78_54","PSA","78","54","54","Ngan, ita yanipake pakapu keu inane komune pakapbut. Sike keu waomu ita kataknga kekeknga siakan tapata keu kekeknga akngananeta takut komune gatu apbing. ");
INSERT INTO wnc_vpl VALUES ("PS78_55","020_78_55","PSA","78","55","55","Keu waomune apuke dongu kundune nana ita yanikwasipewa kuwawa inane dongata pakapu yuking. Pakapu yuwana ita keu usanzike dongu Isrel nanae yamutakukut. Siwana yotna mitake une take yuking. ");
INSERT INTO wnc_vpl VALUES ("PS78_56","020_78_56","PSA","78","56","56","Siwan ngana masande Isrel nana aminda apmea aakingga Anutu enane siknga apae tanziyuuk ie yamandet tasike itane mama wamna dua tawaking. ");
INSERT INTO wnc_vpl VALUES ("PS78_57","020_78_57","PSA","78","57","57","Sike waakwakga yamandet siyuuk ie wamu sandeking. Unzing bapunata tupa tasiking taknga binga tasiking. Waakwau unzing kweem dakata gutonga siwan sakut daka song mumsa binga. ");
INSERT INTO wnc_vpl VALUES ("PS78_58","020_78_58","PSA","78","58","58","Waaminda alta gwenu anutu pupukngae kundu pasiwawa kake Anututa musiptok waaminde natayamukut. Ngan, anutu pupukngatane tuwanga pasiwawa kake Anutu musiaatangu wai natapbut. ");
INSERT INTO wnc_vpl VALUES ("PS78_59","020_78_59","PSA","78","59","59","Anututa waaminda tasikingunin kake musiane toknga siknga natayamukut. Natake ita Isrel nana aminde masa siknga yamukut. ");
INSERT INTO wnc_vpl VALUES ("PS78_60","020_78_60","PSA","78","60","60","Siwan yotna gwenu tupa yaniwan amin banakan mitapbing. Siwan sel yot takwana Silo kep komune mitapbing wagwenu masa imuke atekut. ");
INSERT INTO wnc_vpl VALUES ("PS78_61","020_78_61","PSA","78","61","61","Sike Anututa kapewan itane pukit takwan pasap wamna kaa wagwenu iwanata apu taking. Sike pukit takwanu wagwen kake Isrel nana aminda natake Anututane kekekngana gatu kakaa buyambamu nomnane yuak kaknga anggwene yuak ngang natapbing. ");
INSERT INTO wnc_vpl VALUES ("PS78_62","020_78_62","PSA","78","62","62","Ita inane aminabamde kaanga natayamuke kapewan iwanata asinggan apu zipa kumbing. ");
INSERT INTO wnc_vpl VALUES ("PS78_63","020_78_63","PSA","78","63","63","Sike wawi matek takwau amak gwene katapda yasiwan kungwakaing binga kumbing. Siwan maya mateu wawi apna pananga wena sikut. ");
INSERT INTO wnc_vpl VALUES ("PS78_64","020_78_64","PSA","78","64","64","Gatu iwanata apu aminu yot takwande puya pasiking aminu atzipan kumbing. Atzipa kupa maatnata butaya siknga natake ngana kwanamu sitnanga dua sikut. ");
INSERT INTO wnc_vpl VALUES ("PS78_65","020_78_65","PSA","78","65","65","Siwana Buyambamtapa asenakut. Unzing aminu apekgauneta enakgak binga. Gatu unzing aminu kekeknga apata yangga toknga aknga kwaapzang tangoke datdaptake dapuna peke zet enakgak binga. ");
INSERT INTO wnc_vpl VALUES ("PS78_66","020_78_66","PSA","78","66","66","Siwan ita iwanaat amake yawapewan kuking. Ita asiknga yapbimban maaknga siknga natapbing. Natake gatu amnangge dua tasiking. ");
INSERT INTO wnc_vpl VALUES ("PS78_67","020_78_67","PSA","78","67","67","Siwana ita Josepdane dongatane bapunae masa yamukut. Siwan Efraimdane dongae kuut panangge dua yakut. ");
INSERT INTO wnc_vpl VALUES ("PS78_68","020_78_68","PSA","78","68","68","Siwan ngana ita dongu Judatane dongaat gatu tawanu Saion dakaat yawan yuking, sike tawanu wa dakae take siknga nataak. ");
INSERT INTO wnc_vpl VALUES ("PS78_69","020_78_69","PSA","78","69","69","Sike inane yot takwan gwenu mitapan you kekeknga siknga sikut. Unzing tawan dakatu binga. Siwan ita tasiwan yotna gwenu kekeknga asinggan asinggan yuak. Unzing kepdaka tasiwan kekeknga siknga yuak binga. ");
INSERT INTO wnc_vpl VALUES ("PS78_70","020_78_70","PSA","78","70","70","Siwana Anututa Deviu puya aminae takut. Sike Daviu waapata sipsiu buyambam gatu mateknga ngang kayukut. ");
INSERT INTO wnc_vpl VALUES ("PS78_71","020_78_71","PSA","78","71","71","Siwana Anututa Isrel nana amindane king kapana dakngawikge tekut. Tewana Anututane aminabamu kakuya ita pasikut. ");
INSERT INTO wnc_vpl VALUES ("PS78_72","020_78_72","PSA","78","72","72","Devitda puyana waakngaekan natanggamatake aminbamu kepi noman gan tawake kakuya take pasikut. Sike ita tupan amintapa dakngake take siknga kayukut. ");
INSERT INTO wnc_vpl VALUES ("PS79_1","020_79_1","PSA","79","1","1","Anutu, aminu dongu kundune nana amake keu gata ninu amindabamde nimukuyak kopatang gwa apbing. Apuke yot takwan gwenu gikae yawi yukuu gwa tasiwa maikut. Siwan Jerusalem yot gapma tasiwa wai siknga sikut. Tasiwa maiwan you wagwegwenu waitdeking. ");
INSERT INTO wnc_vpl VALUES ("PS79_2","020_79_2","PSA","79","2","2","Sike katewa gikane puya amin zipa kumbinggane gupna apaapa kwaitkat gatu kaap zong ngangga apu naking. ");
INSERT INTO wnc_vpl VALUES ("PS79_3","020_79_3","PSA","79","3","3","Waaminda gikane aminda zipa kupa daknga tukngwake Jerusalem yot gapmaatang yanggata binga zipbut. Sike aminu tapatu dua yukutna itane gupna pake kwaiwik. ");
INSERT INTO wnc_vpl VALUES ("PS79_4","020_79_4","PSA","79","4","4","Sike ninde aminu wesim yukingga sapdut wam ninike apmiyuuk gatu atninisapduking. ");
INSERT INTO wnc_vpl VALUES ("PS79_5","020_79_5","PSA","79","5","5","Buyambam tapa, gata ninde kaanga nataau mamayasim yuya ba dasing? Asikaya gata kaanga nataau katapda binga isikoke dua kupik, ba dasing? ");
INSERT INTO wnc_vpl VALUES ("PS79_6","020_79_6","PSA","79","6","6","Asikaya gata kaanga aminu munu dua puke ganikaingge natayamuyo. Ngan, aminu kepna kepna wa yuaingu gae masa gamukaingunin. ");
INSERT INTO wnc_vpl VALUES ("PS79_7","020_79_7","PSA","79","7","7","Dasingge, dongu waakwakga ninu Jekopdane donga notninu kundu atzipa kumbing. Kupan nindane kepmin kaa asiknga pasiwan maiking. ");
INSERT INTO wnc_vpl VALUES ("PS79_8","020_79_8","PSA","79","8","8","Nindane bapuninda waiaknga tasikingge ie toknga ma nimim. Apmanu gata ninde musip kwikwik natanimuyo. Dasingge, ninda meya buyak yuke kumnangge dapaknga singgak. ");
INSERT INTO wnc_vpl VALUES ("PS79_9","020_79_9","PSA","79","9","9","Anutu, ga Anutu, nin pakuyak kapanin. Gikane umanda kopsa akngae natake ninu gatanimuyo. Ninu gika gatuka pake waininu kuupbam sandetnimuyo. ");
INSERT INTO wnc_vpl VALUES ("PS79_10","020_79_10","PSA","79","10","10","Dasingge aminu kepna kepna yuaingga ninu anzingu ninikwaikaing, “Gindane Anutusa zandang yuak,” ngangun. Aminda nisipa notninu kundu daknga tukngwakingge gata yake toknga dongu waakwakge yami kanimde nataamang. Dasingge, wai aminda gatane puya aminda zipa kumbing. ");
INSERT INTO wnc_vpl VALUES ("PS79_11","020_79_11","PSA","79","11","11","Gata kaut aminda kwanamu gae sitningge natapso. Sike gikane kekekngaka buyambam taknganeta aminu iwanata atzipan kumningge yakingu gatuka papso. ");
INSERT INTO wnc_vpl VALUES ("PS79_12","020_79_12","PSA","79","12","12","Sike iwanu waakwakga ga akganisapduking. Unzingge Buyambam tapa, gata yake waiaknga tasikingge meya katau kuutmusa gatu kautdu takngayat ngang yamuyo. ");
INSERT INTO wnc_vpl VALUES ("PS79_13","020_79_13","PSA","79","13","13","Gata unzing tasiwina ninu gikane amindabamda unzing sipsipbata binga gae gaak wamu asinggan asinggan ganinim. Siwan nindane bapuninu masan aatningga, gae unzakan umanda ayatangenatning. ");
INSERT INTO wnc_vpl VALUES ("PS80_1","020_80_1","PSA","80","1","1","Ninu Isrel aminu ninukuya tasinggayak kapa, gata ninu Josepdane dongune nana kepi noman tapane panomanuwawi yuamang. Unzing gatane sipsip matekga kayuayak binga. Ge ninda gae yanggawaatna maak panimuyo. Gata king kapa yot takwan siknga gwekatang angela kekeknga apaapa yuaingune banakan yuayak. Yuke kakaa akngakata ninde apsok. ");
INSERT INTO wnc_vpl VALUES ("PS80_2","020_80_2","PSA","80","2","2","Apan ninu Efraimde dongaat gatu Benjaminde dongaat gatu Manase nganggane dongae kakaa waaknga aanggaman tasiwi kanim. Ngan, kekeknga buyambamu waakngaka ninde yeutnimuke apu gatanimi ninda take yutnim. ");
INSERT INTO wnc_vpl VALUES ("PS80_3","020_80_3","PSA","80","3","3","Anutu, gata ninde butaya natanimuke ninu gatuka gikae ninipakapso. Pakapuke ninu ninduyuke gatanimi ninda wena dua sinim. ");
INSERT INTO wnc_vpl VALUES ("PS80_4","020_80_4","PSA","80","4","4","Anutu, ga kekekngakabamban tapa. Tapduu datdasing gatane amindabamu gae tumuk wamu ganiwawa ngana gata kaanga natayamuya? ");
INSERT INTO wnc_vpl VALUES ("PS80_5","020_80_5","PSA","80","5","5","Gata tasiwi ninu kwanambam sike kai yangga ninu nanam gatu yangga ngang binga nake ba tangoke yuamang. ");
INSERT INTO wnc_vpl VALUES ("PS80_6","020_80_6","PSA","80","6","6","Gata aminu dongu kundu kundune nana kapewi ninde wesim yuke amak wam yake nindane kep tanangge yakaing. Yake iwaninu waakwakga masa wam ninike atninimikaing. ");
INSERT INTO wnc_vpl VALUES ("PS80_7","020_80_7","PSA","80","7","7","Anutu, ga kekekngaka bamban tapa, gata ninu dua nindupeke gatane kekeknga akngakata paniwambi ninda dua upeeke wena dua sinim. ");
INSERT INTO wnc_vpl VALUES ("PS80_8","020_80_8","PSA","80","8","8","Siwan tupa gata wain nap taknga Isip kep komune take takapbuyak. Takapuke gata aminu dongu kundune nana keu waomune ayanikwasiwi kuwana gata wain nap taknga waamindane kep komune kwaikuyak. ");
INSERT INTO wnc_vpl VALUES ("PS80_9","020_80_9","PSA","80","9","9","Kwainangge natake gata keu wandaka tapi kakaawan gwa kwaikuyak. Kwaiwi takake waapatane muyakngita puku taawan wa apa buyambam siknga takake keu kuupbam gepa tasikut. ");
INSERT INTO wnc_vpl VALUES ("PS80_10","020_80_10","PSA","80","10","10","Siwan wain nap waapatane kaingata tawanu kuupbam gatu katau buyambamu kundu kuut usikwatapbut. ");
INSERT INTO wnc_vpl VALUES ("PS80_11","020_80_11","PSA","80","11","11","Sike nau waapatane kaingata kuke nambis buyambamu Mediterenian gatu yangga buyambam tapatu Yufretis ngang yanikainggane kwaimune kuking. ");
INSERT INTO wnc_vpl VALUES ("PS80_12","020_80_12","PSA","80","12","12","Siwan ngana dasingge gata damanu wain puyae wamambasikingu gwenu waitdekuyak? Ge aminu kepiapane kuyuk kake buya kukwae pakaing. ");
INSERT INTO wnc_vpl VALUES ("PS80_13","020_80_13","PSA","80","13","13","Siwan ikwawa zongga apu ayainggamuwawa gatu kaap zongga atnakaing. ");
INSERT INTO wnc_vpl VALUES ("PS80_14","020_80_14","PSA","80","14","14","Anutu, ga kekekngaka bamban tapa, gata ninde gatuka natapso. Ga yekaune yuayakge enaneta ninde nindupso. Ninduke epu gatanimuke ninduyuyo. Dasingge, ninu gatane wain nap takngata binga yuamang. ");
INSERT INTO wnc_vpl VALUES ("PS80_15","020_80_15","PSA","80","15","15","Gata gikane kekekngane ninu nanam zak binga kwaikuyak. Ge epu gatanimuyo. Ninu wain gumbang gaka binga gika pasiwi kekekakumang. ");
INSERT INTO wnc_vpl VALUES ("PS80_16","020_80_16","PSA","80","16","16","Siwan ngana nindane iwaninda nau waaknga pasike katap patang gwa saking. Ngan, gata kaanga ninu amindabamde natake pasiwi mainim. ");
INSERT INTO wnc_vpl VALUES ("PS80_17","020_80_17","PSA","80","17","17","Siwan ngana nata nataau aminu umana kopsa amin katau siapanekane yuaingu katakgata papi kekekaningge nataat. Aminu waakwau gata gwa papi waakga binga dakngaking. ");
INSERT INTO wnc_vpl VALUES ("PS80_18","020_80_18","PSA","80","18","18","Siwan gata unzing tasiwinu, ninda ga dua gapmake kunim. Aho, gata gatanimi ninu take yutnim. Siwan ninda tumuk wam ganinim. ");
INSERT INTO wnc_vpl VALUES ("PS80_19","020_80_19","PSA","80","19","19","Anutu, ga kekekngaka bamban tapa, gata ninu dua nindupeke gatane kekeknga akngakata paniwambi ninda dua upeeke wena dua sinim. ");
INSERT INTO wnc_vpl VALUES ("PS81_1","020_81_1","PSA","81","1","1","Anutu nin gatanimunggak kapae apbakngake yatawanong. Kap taike Anutu wa ninu Jekopde dongatane Anutuninde yatawake umana yatangenatnong. ");
INSERT INTO wnc_vpl VALUES ("PS81_2","020_81_2","PSA","81","2","2","Gita ba kulele zipa gakngae noman yawan kap taknga tainong. ");
INSERT INTO wnc_vpl VALUES ("PS81_3","020_81_3","PSA","81","3","3","Sike tapduu buyambam gwene yekau yeik gwenda akoke kuku yapii gwen singgak komune pum puyapnong. ");
INSERT INTO wnc_vpl VALUES ("PS81_4","020_81_4","PSA","81","4","4","Waaknga ninu Isrel nana amindane mama wam taknga unin. Anutu Jekopdane apata mama wamu waaknga ninde nimukut. ");
INSERT INTO wnc_vpl VALUES ("PS81_5","020_81_5","PSA","81","5","5","Sike tupa Anutu amak tasinangge Isip kukut komune mama wamu waaknga ninu Isrel nana amindane bapuninde yamukut. Sike keu waomune nana aminda wamu yawawa natake ninda guyaknga dua natapbumang. ");
INSERT INTO wnc_vpl VALUES ("PS81_6","020_81_6","PSA","81","6","6","Siwan ita anzing yakut, “Nata sanga meya kuupbam gwaamnane yukingu gwa sandekum. Siwan nata yandupewa puyatane basket gwegwena kepdakane sandepeking. ");
INSERT INTO wnc_vpl VALUES ("PS81_7","020_81_7","PSA","81","7","7","Sike tapduu ginu meya buyambam paking komune nae yanawaking. Yanawamban nata gatandama ginda take yuking. Na ena kakaa gakngatda yanggakge banakan kusopuke yuat komuneta tumuk wamu yakingu natake gatandamukum. Siwan ginda yangga gapma Meriba ngang iniking komune yuwawa nata tanziu pasikum. ");
INSERT INTO wnc_vpl VALUES ("PS81_8","020_81_8","PSA","81","8","8","Natane aminabam, daniwa natapnong! Nata wamu kekeknga aknga ginde gwaut wam daniwit. Ginu Isrel amin, natane wamu ginda natapningge take siknga nataat. ");
INSERT INTO wnc_vpl VALUES ("PS81_9","020_81_9","PSA","81","9","9","Ginu dongu kundutane anutu pupukngana ma yawambam. Siwan ginu anutu pupuknga tapatue munu ma puwam. Ginda munu awia apaekan putnong. ");
INSERT INTO wnc_vpl VALUES ("PS81_10","020_81_10","PSA","81","10","10","Nakan na Buyambam tapasa, na gindane Anutusa. Natakan ginu Isip kep komune pake danipakapbum. Ginu genza akngawa nata nanamu genzeetang pewit. ");
INSERT INTO wnc_vpl VALUES ("PS81_11","020_81_11","PSA","81","11","11","Siwan ngana natane aminabamu natane wamu natapnangge apbitaking. Siakande siknga, Isrel nanata natane wamu tawanangge dua tasiking. ");
INSERT INTO wnc_vpl VALUES ("PS81_12","020_81_12","PSA","81","12","12","Unzingge nata kapewa yamandet takngana tawake tasiking. Tasike sanga ina natapbing kakngakan tawake tasiking. ");
INSERT INTO wnc_vpl VALUES ("PS81_13","020_81_13","PSA","81","13","13","Sike ninane aminabamu natane wam natapningge take siknga nataat. Siwan nata Isrel nana aminda na baniu asinggan tawaningge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS81_14","020_81_14","PSA","81","14","14","Sike unzing tasiwanu, nata zeetgaman iwana ayaipapakusiwit. Yaipapaakusike waaminkat amake nata asiknga yapbimbit. ");
INSERT INTO wnc_vpl VALUES ("PS81_15","020_81_15","PSA","81","15","15","Yapbimba aminu na Buyambamtapa yuatde apbitakaingu nae asiknga gwauke munu nae putning. Siwan asingganu nata meya yamuwawa kaning. ");
INSERT INTO wnc_vpl VALUES ("PS81_16","020_81_16","PSA","81","16","16","Siwan ngana nata ginu nanamu wit ngang yanikaingunin damunangge nataat. Nata iningok dama napan musipza atdopikge nataat.” ");
INSERT INTO wnc_vpl VALUES ("PS82_1","020_82_1","PSA","82","1","1","Anututa yekaune pout buyambam gwekatang tupan tapa dakngake yuak. Sike aminu buyambamu wam usanzikaing aminda wamna usanzitnangge apuke unekan yuwawa Anututa aminu kuupbamdane wamna usanzikgaak. ");
INSERT INTO wnc_vpl VALUES ("PS82_2","020_82_2","PSA","82","2","2","Ita anzing yanggak, “Ginu wam yak gwene koke kem wam yake wamu dua yawan nomatakaing. Asikaya wai aminu ginda kaa wam yanikaingunin. ");
INSERT INTO wnc_vpl VALUES ("PS82_3","020_82_3","PSA","82","3","3","Ginda waatdaka kundu nana gwa kupsa aminu gatayamunong. Waaminda sangana wena yuaingu gatayamunong. Siwan aminu kundu meya gwaamuke take dua yuaing aminu kuut take pasiyamunong. ");
INSERT INTO wnc_vpl VALUES ("PS82_4","020_82_4","PSA","82","4","4","Sike aminu kundu wai yuke sangae dapmakaingu ginda waaminu wai aminde kataune sandeke panong. ");
INSERT INTO wnc_vpl VALUES ("PS82_5","020_82_5","PSA","82","5","5","Natdetdetna wena, siwan katum siknga. Kepi zikaa dakaatang sukukaingunin. Unzingge sangabamdane yapii aanggaman dua kake nangaakan natake aminu kuupbamda noman taknga dua tawakaing. Unzing miamunda buyambam siknga singgak binga. ");
INSERT INTO wnc_vpl VALUES ("PS82_6","020_82_6","PSA","82","6","6","Nata anzing yanikum, Ginu aminu tupan siknga apa apa anutu binga yuaing. ‘Ginu Anutu enane siknga yuak kapatane waaknga.’ ");
INSERT INTO wnc_vpl VALUES ("PS82_7","020_82_7","PSA","82","7","7","Siwan ngana ginda aminda akungwakaing binga kumning. Siwan gindane kayuk yutnanga akngasa wena asiwik. Unzing king tapa apatane kayuk yutnanga aknganata wena sining binga.” ");
INSERT INTO wnc_vpl VALUES ("PS82_8","020_82_8","PSA","82","8","8","Anutu, gata enake apu aminu kepna kepna yuaingu kayuke usanziyo. Unzing waaminu kuupbam gikanekan. ");
INSERT INTO wnc_vpl VALUES ("PS83_1","020_83_1","PSA","83","1","1","Anutu, ga genda dua umuke kuma yuwim. Ga moo ma pukuyuke yuwim. Ga moo ma yuwim. ");
INSERT INTO wnc_vpl VALUES ("PS83_2","020_83_2","PSA","83","2","2","Kayo. Gatane iwandata amak kaknga tangenakainggen. Aminu gae apbitakaingga gae yamandet sikaing. ");
INSERT INTO wnc_vpl VALUES ("PS83_3","020_83_3","PSA","83","3","3","Sike waakwau akusopuke gatane aminda pasiwan mainingge yandekaing. Gata aminu waakwau kakuya katak pasinggaayak ngana iwanata unekan yuke pasiwan mainingge yakaing. ");
INSERT INTO wnc_vpl VALUES ("PS83_4","020_83_4","PSA","83","4","4","Waaminda anzing yakaing, “Ayom! Ninda Isrel nana wena aknga pasinim. Siwan aminu kunduta waaminde umanae gatu dua natapning.” ");
INSERT INTO wnc_vpl VALUES ("PS83_5","020_83_5","PSA","83","5","5","Sike waaknga tasinangge wamu takngatukan yakaing. Siwan waakwau notna notna dakngake ga ayaitakepnangge tasikaing. ");
INSERT INTO wnc_vpl VALUES ("PS83_6","020_83_6","PSA","83","6","6","Aminu wamu waaknga yakaingu wa Idom kep komune nana gatu Ismael kem komune nana gatu Moap kep komune nana gatu Itakri kep komune nana gatu ");
INSERT INTO wnc_vpl VALUES ("PS83_7","020_83_7","PSA","83","7","7","Gebal kep komune nana gatu Amon kep komune nana gatu Amelek kep komune nana gatu Filistia kep komune nana gatu you gapmandu Tair yot gapmane yuaingu ngangga notna notna dakngake gae masa gamunangge natake pasap taknga tasikaing. ");
INSERT INTO wnc_vpl VALUES ("PS83_8","020_83_8","PSA","83","8","8","Sike dongu kekeknga Siria kep komune nana kuut unekan iat gatake yuke Lotdane bapuna waakwau gatayamukaing. ");
INSERT INTO wnc_vpl VALUES ("PS83_9","020_83_9","PSA","83","9","9","Siwan gata tupa aminu keu Midian komune nana aminde tasikuyak takngakan waakwakgea tasiyo. Ngan, gata aminu Sisera gatu Jambin yangga buyambamu Kison tapane yukumayakge tasikuyak takngakan tasiyo. ");
INSERT INTO wnc_vpl VALUES ("PS83_10","020_83_10","PSA","83","10","10","Tapduu waomune gata waaminu Endor yotbam gapmane pasiwi maiwan gupna kepdakane yumdekan yuke apbukataking. ");
INSERT INTO wnc_vpl VALUES ("PS83_11","020_83_11","PSA","83","11","11","Gata amak amindane tupan tapaapa meya tupa Orep nana gatu Sep nana ngangge yamukuyak binga yamuyo. Gata tupan gwapaknga amin pasiwi umana wena Sebaat gatu Salmunaat sikumaak binga sinong. ");
INSERT INTO wnc_vpl VALUES ("PS83_12","020_83_12","PSA","83","12","12","Sike waakwakga anzing yaking, “Ninda Anututane kepna atana nisane dakngawik,” ngang yaking. ");
INSERT INTO wnc_vpl VALUES ("PS83_13","020_83_13","PSA","83","13","13","Natane Anutuna, gata kupopongga enakaing binga yanikwasiwi unda unda kunong. Gata ooi akwau got takngata puyapamapan kukaing binga unzing yanikwasiyo. ");
INSERT INTO wnc_vpl VALUES ("PS83_14","020_83_14","PSA","83","14","14","Sike katap gwenu sak kangaatang itzikgak. Siwan tawanu saknga kayaatangu katau buyambam isinggak. ");
INSERT INTO wnc_vpl VALUES ("PS83_15","020_83_15","PSA","83","15","15","Ina unzakan, gata sopa buyambam tewi epu take waakwau yawamban atdatakuning. Siwan gata got taknga tasiwi kekeknga siknga puyake pasiwan akgwautnong. ");
INSERT INTO wnc_vpl VALUES ("PS83_16","020_83_16","PSA","83","16","16","Buyambamtapa, gata aminu waakwau yaipakepi apmaakanong. Siwan ga gawananggengu atnatapning. ");
INSERT INTO wnc_vpl VALUES ("PS83_17","020_83_17","PSA","83","17","17","Nata nataau gata ayapbimbi waakwakga gae asinggan gwautning. Gata pasiwi maakawana waakwau zipi kumnong. ");
INSERT INTO wnc_vpl VALUES ("PS83_18","020_83_18","PSA","83","18","18","Nata nataau gata waaminde unzing tasiwina waaminda apme natdetning. Ga gika siknga, ga Buyambam tapa, siwan ga Anutu enane siknga yuak. Yuke kepna kepna kuupbam kakuya tasinggak ngangu natapning. ");
INSERT INTO wnc_vpl VALUES ("PS84_1","020_84_1","PSA","84","1","1","Buyambamtapa, kekekngaka bamban tapa, gatane yotdae take siknga nataat. ");
INSERT INTO wnc_vpl VALUES ("PS84_2","020_84_2","PSA","84","2","2","Nata une siknga yuwitde musip gwaang siknga nataat. Nata natdetdetnaatang gae yotdane asiknga yutnangge nataat. Siwan gupma san gatu natdetdetna kuupbam ngangga gae apbakngake kap tainggat. Anutu kayuk yuwaak kapae. ");
INSERT INTO wnc_vpl VALUES ("PS84_3","020_84_3","PSA","84","3","3","Buyambam tapa, ga kekekngaka bamban tapa, ga natane King siwan ga natane Anutuna. Sike kwaiu mateknga gwegwensimu gatane altakane yotna wesim mitake musia peaing. ");
INSERT INTO wnc_vpl VALUES ("PS84_4","020_84_4","PSA","84","4","4","Sike aminu gatane yotdane yuaingu, waaminu musip gwaang siknga nataaing. Ngan, waaminda asinggan kap taike umanda yatangenakaing. ");
INSERT INTO wnc_vpl VALUES ("PS84_5","020_84_5","PSA","84","5","5","Mamin amindaka gatane kekeknga akngaka take tawanu Saion dakane siknga kopnangge take siknga nataaingu, waaminda asinggan baknganing. ");
INSERT INTO wnc_vpl VALUES ("PS84_6","020_84_6","PSA","84","6","6","Undang kopnangge kosika ama keu sangana wena gapmekan komune kukaing kopatangu, yangga gapma kwaapzang. Ge sopa tembana tawanu yangga gapma wa daka daka atdotakakokaing. ");
INSERT INTO wnc_vpl VALUES ("PS84_7","020_84_7","PSA","84","7","7","Sike waakwau kepi akuyuk kekeknga pakaing. Kekeknga pake Saion kunangge kuku aminu kuupbamdane Anutuna une yuwawan kaning. ");
INSERT INTO wnc_vpl VALUES ("PS84_8","020_84_8","PSA","84","8","8","Anutu, Buyambam tapa, ga Anutu kekekngaka bamban tapa, natane tumuk wamae natapso. Ga Jekopdane Anutuna, maak gwaang pake natane wamu natapso. ");
INSERT INTO wnc_vpl VALUES ("PS84_9","020_84_9","PSA","84","9","9","Buyambam tapa, gata tewi king kapa dakngawan gata ie take siknga tasingamuyo. Kingu waapata ninu pakotnake kakuya katak siknga pasinggak. Unzing tiunggu sasanda amak aminu amak tapduk pakotnakaing binga. Gata ie take tasingamuyo. ");
INSERT INTO wnc_vpl VALUES ("PS84_10","020_84_10","PSA","84","10","10","Sike nata tapduu gwendukan siknga yotdane yuwiu, wa you gapmandune yutnanga aknga tapduu 1,000-nu asiknga yapbimbik. Na Anutunatane yotna gwendane gwambok gwaune yutnangge nataat. Sike wai amindane yotnane yutnanggengu apbitanggat. ");
INSERT INTO wnc_vpl VALUES ("PS84_11","020_84_11","PSA","84","11","11","Dasingge, Buyambamtapa ninde nindukuya tasike kakaa nimunggak kapanin. Ita musip kwikwik natanimuke umaninu kopsa nimunggak. Sike sanga take kundu aminu noman sukukaing amindenu Buyambam tapata yamunangge dua kotnanggak. ");
INSERT INTO wnc_vpl VALUES ("PS84_12","020_84_12","PSA","84","12","12","Anutu, kekekngaka bamban tapa, aminu gae banip sikaingu waaminu asinggan baknganing. ");
INSERT INTO wnc_vpl VALUES ("PS85_1","020_85_1","PSA","85","1","1","Buyambam tapa, gata aminu gikane kepba komune yukingge musipba kwikwiknga natayamukuyak. Ngan, ninu Jakopdane donga gata gatu gatanimi take yukumang. ");
INSERT INTO wnc_vpl VALUES ("PS85_2","020_85_2","PSA","85","2","2","Gata gikane amindabamu yuainggane waiakngana sandeyamukuyak. Ngan, gata gutonga tasikingu sandeyamukuyak. ");
INSERT INTO wnc_vpl VALUES ("PS85_3","020_85_3","PSA","85","3","3","Gata gatane musiptou tekuyak. Siakan, gata musiptou atnatayamukuyak ngana apmanu wena. ");
INSERT INTO wnc_vpl VALUES ("PS85_4","020_85_4","PSA","85","4","4","Anutu, ga nin pakuyak kapanin. Apmanu ninu gikae ninipakapso. Gata kaanga ma natanimim. ");
INSERT INTO wnc_vpl VALUES ("PS85_5","020_85_5","PSA","85","5","5","Gata kaanga ninde asinggan natanimuya? Kaanga ninde natanimunggaak kaknga wena dua siwik, ba? ");
INSERT INTO wnc_vpl VALUES ("PS85_6","020_85_6","PSA","85","6","6","Gata nindane kayuk yutnanga aknga gatuka tapi kekekayok. Siwana ninu gikane amindabamda apbakngake umanda yatangenatnim. ");
INSERT INTO wnc_vpl VALUES ("PS85_7","020_85_7","PSA","85","7","7","Buyambam tapa, gata ninde take asinggan natanimunggayak kakngaka yeutnimi kanim. Yeutnimi kana gata ninu papi take yutnim. ");
INSERT INTO wnc_vpl VALUES ("PS85_8","020_85_8","PSA","85","8","8","Nata maaknga tewa kuwan Anutu Buyambam tapata wamu dasingga yawikge maak papit. Ita musip kwikwik niman ninu itane aminda take yutnimde yanggak. Unzing waiaknga tupa tasikumang katang gatu dua kunanun. ");
INSERT INTO wnc_vpl VALUES ("PS85_9","020_85_9","PSA","85","9","9","Siakan siknga, ita amin ie mun puke gatu ie banip tawakaingu apanangge gwa tandaknganggak. Tandakngake tasike papan kuupbamda kawa nindane kep komune itane umana buyambam siwik. ");
INSERT INTO wnc_vpl VALUES ("PS85_10","020_85_10","PSA","85","10","10","Tapduu waomunea aminda notnaapae take natayamuke ie take akngakan pasiyamuning. Siwana musip kwikwik takngane unekan noman gan yutning. ");
INSERT INTO wnc_vpl VALUES ("PS85_11","020_85_11","PSA","85","11","11","Keu andakane yuyuuk kepi noman taknga tawanimu, kepi noman tawanggak kapa yekaune yuak kapata pakepusa nindupik. ");
INSERT INTO wnc_vpl VALUES ("PS85_12","020_85_12","PSA","85","12","12","Sike Buyambam tapata gatanimuwawan yutnim kopatangu sanga ninda tasinimu takekan siwik. Siwan kepminu nanamu kwaapzang aatning. ");
INSERT INTO wnc_vpl VALUES ("PS85_13","020_85_13","PSA","85","13","13","Buyambam tapata amin pasiwan kepi noman taknga tawaningu wa kepi ita apnanga taknga tandakngangamuning. ");
INSERT INTO wnc_vpl VALUES ("PS86_1","020_86_1","PSA","86","1","1","Buyambam tapa, na kekekngana wena, ge nata nina gatangamunanga dua. Unzingge gata natane tumuk wamu take natangamuke gatangamuyo. ");
INSERT INTO wnc_vpl VALUES ("PS86_2","020_86_2","PSA","86","2","2","Sike na gatuka tapi na dua kupit. Dasingge? Nata gatane puya aminda yuke gae baniu asinggat. Sike nata ga akgawanggat. ");
INSERT INTO wnc_vpl VALUES ("PS86_3","020_86_3","PSA","86","3","3","Anutu, ga natane Anutuna. Nata tapdukbamu kwakngaom gatu zikaane ngangu nata gae tumuk wamu ganinggat. Ganiwawa gata musip kwikwiu nae natangamuyo. ");
INSERT INTO wnc_vpl VALUES ("PS86_4","020_86_4","PSA","86","4","4","Buyambam tapa, na gikane puya amindae musipma tasiwi apbakngayok. Dasingge? Na tumuk wamu gaekan yanggat. ");
INSERT INTO wnc_vpl VALUES ("PS86_5","020_86_5","PSA","86","5","5","Buyambam tapa, ga amindatdat binga yuayak, ge gata nindane waiaknganinu asandekgaak kapanin. Sike gata aminu gae tumuk wam ganikaingge asiknga baknganggayak. ");
INSERT INTO wnc_vpl VALUES ("PS86_6","020_86_6","PSA","86","6","6","Buyambam tapa, nata gae tumuk wam ganiwa gata maak gwaang pake natane tumuk wamu natapso. Gata na akgatangamiyakge natake yanggatde tumuk wama natapso. ");
INSERT INTO wnc_vpl VALUES ("PS86_7","020_86_7","PSA","86","7","7","Tapduu nata gae yanggat komune gata akgatangamunggayak. Unzingge, tapdukbamu nata meya pakengu nata gae tumuk wamu ayanggat. ");
INSERT INTO wnc_vpl VALUES ("PS86_8","020_86_8","PSA","86","8","8","Buyambam tapa, anutu ga binga tapatu dua yuak. Gata anutu kuupbam ayapbikgayak. Siwan aminu tapatuta puya gata tasinggayak binga dua tasiwik. ");
INSERT INTO wnc_vpl VALUES ("PS86_9","020_86_9","PSA","86","9","9","Sike aminu dongu kuupbamu gata pasikuyau waaminda kuke gae munu puke gatane umanda yatangenatning. Yatangenawawa umandaa kopsa siknga siwik. ");
INSERT INTO wnc_vpl VALUES ("PS86_10","020_86_10","PSA","86","10","10","Dasingge? Ga kekekngaka bamban tapa. Siwan gata gikatakan duya takngatu takngatu gwaam gwaamu tasinggayak. Ga Anutu siknga awia tapatukan. ");
INSERT INTO wnc_vpl VALUES ("PS86_11","020_86_11","PSA","86","11","11","Buyambam tapa, gata sanga nata tasiwitde take nataayak kaknga na katak siknga nanindamumso. Nanindamuwawi nata asingganu gae banip takngakan tawambit. Gata natane musipma tangenawi natdetdeu takngaaya dua siknga natapit. Dua natake nata gae natanggamatake gatane puya aknga asinggan tasiwit. ");
INSERT INTO wnc_vpl VALUES ("PS86_12","020_86_12","PSA","86","12","12","Anutu, natane Buyambam tapana, nata musip gwaangu buyambam siknga natanggamunggat. Natake nata gatane umanda kopsa yuak kaknga asinggan asinggan yatangenawit. ");
INSERT INTO wnc_vpl VALUES ("PS86_13","020_86_13","PSA","86","13","13","Dasingge? Asingganu gata nae take siknga natangamunggayak. Natangamuke gata akumnanga akngane sandeke tapi nata aminu gwa kumbingga yuaing komune dua pukuwit. ");
INSERT INTO wnc_vpl VALUES ("PS86_14","020_86_14","PSA","86","14","14","Anutu, apmanu yamandet aminu kunduta apu na nutnangge tasikaing. Sike wai aminu waakwau musip kwikwiu dua natake poot tasike na nuwa kupitde yakaing. Sike waaminu gatane wamu dua tawake gae wamu asandekaing. ");
INSERT INTO wnc_vpl VALUES ("PS86_15","020_86_15","PSA","86","15","15","Siwan ngana Buyambamtapa, butaya buyambam siknga gata natangamunggayak. Unzingge gata kaanga zet dua naninggayak. Sike gata nae gwaam siknga natangamunggayak. Natake gikane wamu takngatu takngatu yanggau atawanggayak. ");
INSERT INTO wnc_vpl VALUES ("PS86_16","020_86_16","PSA","86","16","16","Gata nae apuke butaya natangamuyo. Ngan, na puya aminda unzing mingata puya aminda tasikut binga tasinggatde kekekangamuke gatuka tapso. ");
INSERT INTO wnc_vpl VALUES ("PS86_17","020_86_17","PSA","86","17","17","Buyambam tapa, nata sanga gata musipbaatangu butaya natangamunggayak kakngatane tuwang yeikngamuyo. Yeikngami natane iwanata kake gata gatangamuke tapi kekekanggat ngang natapning. Natake waaminda inane waiaknganae asiknga maakaning. ");
INSERT INTO wnc_vpl VALUES ("PS87_1","020_87_1","PSA","87","1","1","Anututa yotna inane gapma tawanu inane dakane tasike tekut. ");
INSERT INTO wnc_vpl VALUES ("PS87_2","020_87_2","PSA","87","2","2","Buyambam tapata you gapmandu gapmandu Jakopde donga une yuaingge take nataak ngana Jerusalemdenu take siknga nataak. ");
INSERT INTO wnc_vpl VALUES ("PS87_3","020_87_3","PSA","87","3","3","Sike Anututane yotbam gapmane aminu yuaingu, ginda anzing natapnong. Anututa puya noma nomana gikatang pasinggakgen. ");
INSERT INTO wnc_vpl VALUES ("PS87_4","020_87_4","PSA","87","4","4","Siwan Anututa anzing yakut, “Nata aminu nae wam tawakaingunin matawit tapduk kopatangu, nata Isip nanaat gatu Bambilon nanaatdane umana matawit. Siwana nata Filistia nanaat gatu Tair nanaat gatu Itiopia nanaat ngangge umana matawit. Siwan anzing yawit, ‘Iyaaya Zaionkat nana,’” ngang yawit. ");
INSERT INTO wnc_vpl VALUES ("PS87_5","020_87_5","PSA","87","5","5","Siakan. Nata Sionde anzing yawit, “Aminu tapatu kake aapa komdune nana pakapuyuke ane nana dakngakut. Sike aminu tapatu kake, ‘Aapa kuut wanggapmane nana,’ ngang yawit. Siwana Anutu enane sikngaapata, you wanggapma gatu ina tangenake tasiwan kekenga siwik.” ");
INSERT INTO wnc_vpl VALUES ("PS87_6","020_87_6","PSA","87","6","6","Buyambam tapata dongu kundu kundune nana amindane umana matawik. Matake, “Aminu aapa Jerusalem nanaunin,” ngang matawik. ");
INSERT INTO wnc_vpl VALUES ("PS87_7","020_87_7","PSA","87","7","7","Sike amin Jerusalem yuaingga kap taike apbaknganing. Bakngake anzing yaning, “Jerusalem, ga sanga noma nomana ninda peyuamanggane yapii ga,” ngang yake taining. ");
INSERT INTO wnc_vpl VALUES ("PS88_1","020_88_1","PSA","88","1","1","Anutu, Buyambamtapa, ga na gatangamunggayak kapanin. Nata kwakngaom gatu zikaane kuut gata gatangamiakge yanggawanggat. ");
INSERT INTO wnc_vpl VALUES ("PS88_2","020_88_2","PSA","88","2","2","Natane tumuk wamae natapso. Na gatangamiakge yawitde maak papso. ");
INSERT INTO wnc_vpl VALUES ("PS88_3","020_88_3","PSA","88","3","3","Dasingge? Nae meya kwaapzang apan yapii waakngae kupitde wesim singgak. ");
INSERT INTO wnc_vpl VALUES ("PS88_4","020_88_4","PSA","88","4","4","Na aminu kuupbamda kumnangge dapaknga sikaing bingakan. Natane kekekngana wena. Na tuyuknga gwasit. ");
INSERT INTO wnc_vpl VALUES ("PS88_5","020_88_5","PSA","88","5","5","Sike na gwa napmambi na gwa kumbing aminkat yuamang. Na unzing aminu tapatuta aminu tapatu tanguwan kumbutna gapmaatang yuak binga. Na unzing aminu kundue asiknga botakuyak binga. Botake gatu dua gatayamunggayak binga yuat. ");
INSERT INTO wnc_vpl VALUES ("PS88_6","020_88_6","PSA","88","6","6","Gata na gapma daka amunane siknga kwaitakepu teya komune gwa mumbi pukukum. Siwan na amunane gatukande zikaa siknga kopatang yuat. ");
INSERT INTO wnc_vpl VALUES ("PS88_7","020_88_7","PSA","88","7","7","Gatane musiptok kakngata na asiknga naitakepu napmanggak. Unzing yanggabamdane sambuita binga enake usukwatapan yuat. ");
INSERT INTO wnc_vpl VALUES ("PS88_8","020_88_8","PSA","88","8","8","Siwan gata tasiwi ninane yanggatak notnata nae masa gwa namuking. Gata na sanga gawaknga tapatu binga tasiwi aminda nae asiknga bitakaing. Siwan waakngata na kaautde binga tanggaganuwan kunanga dua. ");
INSERT INTO wnc_vpl VALUES ("PS88_9","020_88_9","PSA","88","9","9","Nata meya gwaamumba kainata maiwat nata katak kananga dua singgak. Unzingge tapdukbamu gae tumuk wamu akgatangamiakge ganinggat. Ngan, nata tumuk wam yayuu kataknga tangenake ganinggat. ");
INSERT INTO wnc_vpl VALUES ("PS88_10","020_88_10","PSA","88","10","10","Gata duya takngatu gwa kumbing amin gatayamikge tasinggaak, ba? Asikaya gwa kumbing aminda enake gatane umanda ayatangenakaing? ");
INSERT INTO wnc_vpl VALUES ("PS88_11","020_88_11","PSA","88","11","11","Sike asikaya aminu gapmaatang pekaingga gae take siknga natanimunggaunin ngangu ayakaing? Sike keu wai sinanga komune yuke gata katak kayukuyak komde ayakaing, ba wena? ");
INSERT INTO wnc_vpl VALUES ("PS88_12","020_88_12","PSA","88","12","12","Sike asikaya aminu keu zikaa komune yuaingga duya takngatui pasiwawi akaaing? Siwan aminu wai sinanga komune yuaingga gatane noman takngaka akaaing, ba wena? ");
INSERT INTO wnc_vpl VALUES ("PS88_13","020_88_13","PSA","88","13","13","Buyambam tapa, nata gae akgatangamiakge ayanggawanggat. Sike tembana kuupbam tumuk wamu gae asinggan yanggat. ");
INSERT INTO wnc_vpl VALUES ("PS88_14","020_88_14","PSA","88","14","14","Siwan ngana Buyambam tapa, dasingge gata masa nae namunggayak? Dasingge siknga gata nae kusopunggayak? ");
INSERT INTO wnc_vpl VALUES ("PS88_15","020_88_15","PSA","88","15","15","Sike tupa waatdaka yukumuneta apu apmanu na toknga gwaamuke akupitde dapaknga singgak. Gata nae meya nami waaknga tasiwan kwatana tuyuknga siwan na meya buyak siknga yuat. ");
INSERT INTO wnc_vpl VALUES ("PS88_16","020_88_16","PSA","88","16","16","Buyambam tapa, gatane musiptok kakngata na gwa usukwatapbut. Gata na atnuke gatukande siknga tasiwi maikum. ");
INSERT INTO wnc_vpl VALUES ("PS88_17","020_88_17","PSA","88","17","17","Gata unzingu kwakngaom gatu zikaane ngang tasiwawi meya asinggan kaat. Siwan meya waakwau na umupbasikaingu wa unzing, yanggata paptake keu kuupbam usikwatanggak binga singgak. ");
INSERT INTO wnc_vpl VALUES ("PS88_18","020_88_18","PSA","88","18","18","Sike gata tasiwi natane dongaat gatu notna siknga apaapa ngangga gwa napmake kuking. Unzingge apmanu zikaa dakata yanggatak notna binga dakngawan yuat. ");
INSERT INTO wnc_vpl VALUES ("PS89_1","020_89_1","PSA","89","1","1","Buyambamtapa, nata kau asinggan gatane butaya wamde yanggak kaknga asinggan taiwit. Siwan asingganu nata wamu yanggaak kaknga teke gatu takngatu dua yanggayakge yakapit. Yanikapa bapuna masa masa aatningga atnatapning. ");
INSERT INTO wnc_vpl VALUES ("PS89_2","020_89_2","PSA","89","2","2","Nata yanikapmake gata ninde musip gwaangu asinggan asinggan natanimunggayakge yaniwit. Sike gatane siakan wam taknga tapatekwan binga dua singgakge yaniwit. Ngan, wamu waaknga ena kakaa komda kekeknga yuak binga yuak. ");
INSERT INTO wnc_vpl VALUES ("PS89_3","020_89_3","PSA","89","3","3","Gata anzing yakuyak, “Nata aminu tapatu gwa yawa yukut. Siwan pasap wam taknga iat yata kekekakut. Ngan, nata wamu takngatu puya amina Devitde gwa yawa kekekakut.” ");
INSERT INTO wnc_vpl VALUES ("PS89_4","020_89_4","PSA","89","4","4","Siwan nata anzing inikum, “Masande aminu gatane dongune nana aatningu kuut kingu dakngake yutning. Sike asingganu gatane dongune nana tapatu tasiwa king dakngake yuwik.” ");
INSERT INTO wnc_vpl VALUES ("PS89_5","020_89_5","PSA","89","5","5","Buyambam tapa, angela yekaune yuaingga noma nomana tasikuyakge kau taikaing. Taike ita gatane umanda yatangenakaing. Sike waakwakga kap taknga taikaingu gata siakan wam takngakan tawanggayakge taikaing. ");
INSERT INTO wnc_vpl VALUES ("PS89_6","020_89_6","PSA","89","6","6","Dasingge, Buyambam tapa, aminu yekaune tapatu ga binga tapatu wena. Siwan angela kuut unzakan, ga binga tapatu wena. ");
INSERT INTO wnc_vpl VALUES ("PS89_7","020_89_7","PSA","89","7","7","Sike angelata paut tasikengu gae akgwaukaing. Siwan angela wa kuupbamda ga takumbasike gae akgwaukaing. ");
INSERT INTO wnc_vpl VALUES ("PS89_8","020_89_8","PSA","89","8","8","Buyambam tapa, ga Anutu kekekngaka bamban tapa, aminu tapatu kekeknga buyambamu gata pake yuayak binga wena. Sike ga wamu ayanggayak takngakan asinggan tawanggayak. Ga tapatekwana kaya dua daknganggayak. ");
INSERT INTO wnc_vpl VALUES ("PS89_9","020_89_9","PSA","89","9","9","Siwan gata yanggabamu kekekngana kaya gwenu kayuak. Sike sambuita enawanu gata yawi kuma siknga yuak. ");
INSERT INTO wnc_vpl VALUES ("PS89_10","020_89_10","PSA","89","10","10","Gata Isip nana amindane kekekngana kuupbam gwa zipbuke pasiwi maiking. Siwan gikane kekeknga aknganeta iwanda gwa yapbike yanikwasiwi datakuking. ");
INSERT INTO wnc_vpl VALUES ("PS89_11","020_89_11","PSA","89","11","11","Sike yekapat gatu kepdakaat ngangu gikanekan. Gata kepdaka tasike sangabamu undang yuaing kaya pasike pekuyak. ");
INSERT INTO wnc_vpl VALUES ("PS89_12","020_89_12","PSA","89","12","12","Siwan gatakan keu kuupbam pasike tekuyak. Tawanu Tabor dakaat gatu Hermon dakaat ngang aminda taikaing binga umandae apbakngake gae kap taikamayak. ");
INSERT INTO wnc_vpl VALUES ("PS89_13","020_89_13","PSA","89","13","13","Gatane kekekngaka buyambam siknga. Kekekngaka inata siknga kundu yuak. ");
INSERT INTO wnc_vpl VALUES ("PS89_14","020_89_14","PSA","89","14","14","Gata king kapa yuke aminu kuupbam noman takngane kayuwayak. Sike aminu wam yot gwene usanzikgayak kaya noman gan tasinggayak. Gata amin kuupbamde take natayamuke wamu ayanggayak takngakan asinggan tawake ga tapatekwan ba dua singgayak. ");
INSERT INTO wnc_vpl VALUES ("PS89_15","020_89_15","PSA","89","15","15","Sike aminbamda umanda yatangenakaingu apbaknganing. Aminbamda gae wesim kuke sukukaingu wa unzing kakaa akngane sukukaing. Siwan waaminda apbaknganing. ");
INSERT INTO wnc_vpl VALUES ("PS89_16","020_89_16","PSA","89","16","16","Sike waaminu umanda kopsa akngae kwakngaom gatu zikaane ngangu apbakngake yatangenakaing. Ngan, gata puya noman nomana akngakan ie tasinggayakge kan natanggamatake apbakngakaing. ");
INSERT INTO wnc_vpl VALUES ("PS89_17","020_89_17","PSA","89","17","17","Dasingge, gata ninu kekekanimi umaninda kopsa aknga siwan ninda asiknga bakngakamang. Ngan, gata musip kwikwik natanimuke gatanimuwawi ninda kekekake amak kaknga yapikamang. ");
INSERT INTO wnc_vpl VALUES ("PS89_18","020_89_18","PSA","89","18","18","Siakan. Gata gika nindane kuyanin yuak kapa yawi yuak. Ngan, ga ninu Isrel amindane Anutunin, gata king kapa ninde nimunangge yawi yuak. ");
INSERT INTO wnc_vpl VALUES ("PS89_19","020_89_19","PSA","89","19","19","Tupa siknga gata mia takngatu puya aminda sikngae yamukuyak. Yamuke anzing yanikuyak, “Nata amak aminu tupan sikngaapa gwa yawa yukut. Siwan nata kinggane kupna gwapakngine gwapungamukum. Nata aminbamde banakan take waapa tewa king kapa yuak. ");
INSERT INTO wnc_vpl VALUES ("PS89_20","020_89_20","PSA","89","20","20","Ngan, nata Deviu king kapa dakngawikge wel gwapakngane tukwamba gindane king kapasa dakngakut. Natane puya amin tapanan. ");
INSERT INTO wnc_vpl VALUES ("PS89_21","020_89_21","PSA","89","21","21","Unzingge natane kekekngana iat gatake asinggan yuwik. Sike nata kekekangama kekeknga yuwik. ");
INSERT INTO wnc_vpl VALUES ("PS89_22","020_89_22","PSA","89","22","22","Sike iwanata amak tasike i yapbitnanga dua. Aho, wai aminda dua tasiwa maiwik. ");
INSERT INTO wnc_vpl VALUES ("PS89_23","020_89_23","PSA","89","23","23","Siwan nata itane iwana yainggamumbit. Ngan, aminu waakwau ie apbitaningu atzipa kumning. ");
INSERT INTO wnc_vpl VALUES ("PS89_24","020_89_24","PSA","89","24","24","Sike ie nata take natangamuke iat gatake asinggan yutzim. Sike kaawa iat iwanaat amak tasiwan kakengu nata tasiwa iwana ayapbimbik. ");
INSERT INTO wnc_vpl VALUES ("PS89_25","020_89_25","PSA","89","25","25","Siwan kepna imiu yanggabamu Mediterenian gweneta kuku yangga buyambam tapatu Yufretis ngang inikaingune sandewik. ");
INSERT INTO wnc_vpl VALUES ("PS89_26","020_89_26","PSA","89","26","26","Sike ita nae naninggamatake anzing yawik, ‘Ga natane nana. Siwan natane Buyambam tapana. Gata nae kakuya tasike asinggan gatangamunggayak,’ ngang yawik. ");
INSERT INTO wnc_vpl VALUES ("PS89_27","020_89_27","PSA","89","27","27","Siwana nata yawa waaknga tupan tapa dakngake kingu kepna kepna yuaingu kuupbam yapbimbik. ");
INSERT INTO wnc_vpl VALUES ("PS89_28","020_89_28","PSA","89","28","28","Sike nata ie take siknga asinggan natangamit. Siwana nata pasap wamu takngatu ie tasiwa pasap taknga nit katang asinggan asinggan yuwik. ");
INSERT INTO wnc_vpl VALUES ("PS89_29","020_89_29","PSA","89","29","29","Ngan, aminu itane dongane nana tapatuta kingu asinggan dakngawik. Siwan itane dongane nana kingu waapata Isrel nana aminu asinggan kayuwik. Unzing sanga ena kakaa komune yuaingu asinggan yuaing binga. ");
INSERT INTO wnc_vpl VALUES ("PS89_30","020_89_30","PSA","89","30","30","Siwan ngana itane bapuna masan aatningga natane mama wama ayama sandeke, ");
INSERT INTO wnc_vpl VALUES ("PS89_31","020_89_31","PSA","89","31","31","natane noman taknga dua ba tawaning, ba natane wamae masa imuke mama wama dua ba tawaning. ");
INSERT INTO wnc_vpl VALUES ("PS89_32","020_89_32","PSA","89","32","32","Ayok! Nata wai aknganae natapa kuwan nata meya yake yamit. Siwan nata gutongana tasikaingge natake atzipmake toknga yamit. ");
INSERT INTO wnc_vpl VALUES ("PS89_33","020_89_33","PSA","89","33","33","Siwan ngana tapduu waomune Devitde dongge take siknga natangamit, tendeknga wena. Sike natanu i dua teke, wamu ie yawa kekekakut taknga dua tewit. ");
INSERT INTO wnc_vpl VALUES ("PS89_34","020_89_34","PSA","89","34","34","Sike nata pasap wam taknga iat tasikumau dua zipbuwit. Siwan tapatekwan wamu takngatu wamaatangu genaneta dua yawit. ");
INSERT INTO wnc_vpl VALUES ("PS89_35","020_89_35","PSA","89","35","35","Na Anutu noman takngakan tasinggat tapanin. Na waakngae natapa siwan wamu waaknga yawa kekekakut. Nata sipdukan yawa wamu waaknga asinggan asinggan yuwik. Wamu kekeknga waaknga anzing, nata Deviu kemu dua iniwit. ");
INSERT INTO wnc_vpl VALUES ("PS89_36","020_89_36","PSA","89","36","36","Sike wamu inikumu itane bapuna wena dua sining. Waakwau asinggan yutning. Siwan gunzitda yuak binga itane dongata aminbamdane tupan tapaapa dakngake komdubam siknga unzing kayutning. ");
INSERT INTO wnc_vpl VALUES ("PS89_37","020_89_37","PSA","89","37","37","Sike waakwaau asinggan yutning. Unzing yakau kakaa nimunggakga aminbam yeuyaman natane wama siakan gan siwikgen siking.” ");
INSERT INTO wnc_vpl VALUES ("PS89_38","020_89_38","PSA","89","38","38","Siwan ngana apmanu kingu gika yawi yukut tapae kaanga natangamunggayak. Kaanga natangamuke gata i gwa teke masa imunggayak. ");
INSERT INTO wnc_vpl VALUES ("PS89_39","020_89_39","PSA","89","39","39","Sike wamu takngatu puya amindaat yawat kekekakut taknga gwa sandekgayak. Sandeke kinggane kup daka gwapungamukuyau gwa sandeke kepdakane mumbi wasap sikut. ");
INSERT INTO wnc_vpl VALUES ("PS89_40","020_89_40","PSA","89","40","40","Gata itane damanu yotbam gapmae tasibasikuu gwa zipbuke yotna kekeknga gwegwenu apasiwi maiking. ");
INSERT INTO wnc_vpl VALUES ("PS89_41","020_89_41","PSA","89","41","41","Sike aminbamde wagwak saak kuke sangana kakengu kukwae apakaingunin. Kukwae pake notna iat wesim yuaingga sapdut wamu inikaing. ");
INSERT INTO wnc_vpl VALUES ("PS89_42","020_89_42","PSA","89","42","42","Ngan, gata itane iwana akapewi amak tasike ayapbiking. Siwan gata pasiwi musip gwaang natapbing. ");
INSERT INTO wnc_vpl VALUES ("PS89_43","020_89_43","PSA","89","43","43","Gata tasiwi itane amak amina dua kekekake ambing. Siwan amak tasikaing ngana gata dua gatangami tiuukake apimakut. ");
INSERT INTO wnc_vpl VALUES ("PS89_44","020_89_44","PSA","89","44","44","Gata umana kopsa king ngang iniking kaknga sandewi umana waaknga gatu dua yuak. Dua yuke aminu gatu dua kayuak. ");
INSERT INTO wnc_vpl VALUES ("PS89_45","020_89_45","PSA","89","45","45","Gata tasiwi aminuake zet siknga siwan maaknga buyambam takngata usukwatapbut. ");
INSERT INTO wnc_vpl VALUES ("PS89_46","020_89_46","PSA","89","46","46","Buyambam tapa, ga ninde tape mamayasim kusopuya? Ba asinggan? Gatane musiptok taknga katap gwen binga tokngaake tapduknga dasing yuwik? ");
INSERT INTO wnc_vpl VALUES ("PS89_47","020_89_47","PSA","89","47","47","Buyambam tapa, butaya gata ninu tapduu dapaknga yuamang aminde natapso. Gata ninu tumukuyak. Siwan ngana ninu kuupbam akungwake asopunim. ");
INSERT INTO wnc_vpl VALUES ("PS89_48","020_89_48","PSA","89","48","48","Maminda asinggan asinggan yuke dua kupik? Maminda kekeknga yuke aminda kupan kwaipeaing komune dua kuwik? Unzing binga aminu tapatu wena. Wena siknga. ");
INSERT INTO wnc_vpl VALUES ("PS89_49","020_89_49","PSA","89","49","49","Buyambam tapa, sike dasing? Apmanu ninde take dua nataayak ba? Sike wamu kundu na Devitde musipba kwikwiknga asinggan natangamiyakge yawi kekekakuu dasing? ");
INSERT INTO wnc_vpl VALUES ("PS89_50","020_89_50","PSA","89","50","50","Buyambam tapa, gata na puya amin tapakae natanggamatayo. Aminda nae sapdut wam nanikaing. Sike na waiaknga aknga katum aminu kunduta nanikaingunin gwaamuke yuat. ");
INSERT INTO wnc_vpl VALUES ("PS89_51","020_89_51","PSA","89","51","51","Buyambam tapa, gata na king kapa dakngake yuwitde napmakuyak. Siwan ngana natane iwanata nae wamu waiaknga aknga nanikaing. Sike keu kuupbam nata kunggat komune wamu waiaknga aknga atnanikaing. ");
INSERT INTO wnc_vpl VALUES ("PS89_52","020_89_52","PSA","89","52","52","Ninda Buyambam tapatane umana asinggan asinggan yatangenatnim. ");
INSERT INTO wnc_vpl VALUES ("PS90_1","020_90_1","PSA","90","1","1","Buyambamtapa, ga nindane yotnin siknga binga yuayak. Ge tupa nindane bapunin kaya gaat gatake yuking. Ge apmanu nikaya unzakan yuamang. ");
INSERT INTO wnc_vpl VALUES ("PS90_2","020_90_2","PSA","90","2","2","Siwan Anutu, ga asinggan asinggan yuayak. Tupa yukuyak ngang masan kaa ayuya. Sike tapduu tawanu kuupbam wena siwan gata sangabamu kepdakane nana dua yawi yuking komune ga ayukuyak. ");
INSERT INTO wnc_vpl VALUES ("PS90_3","020_90_3","PSA","90","3","3","Gata amin pasiwi akungwake gatu keek dakngakaing. Siwan gata anzing yakuyak, “Ginu aminu keune nana akungwake gatusa keek daknganong,” ngang yakuyak. ");
INSERT INTO wnc_vpl VALUES ("PS90_4","020_90_4","PSA","90","4","4","Sike nindane natdetdetdanine nataamangu, nakanu 1,000-nu kwaapzang siknga ngana gata kawi tapduu gwendukan binga singgak. Siwan tapduu wa zeetgaman akuwan wena singgak. Unzing kwep kwakake gwanzokut binga siwan gatu amak aminda iwanae gwauke zikaane tapduu dapaknga wamayuke kuwawan notna tapatuta ie tangge apunggak binga singgak. ");
INSERT INTO wnc_vpl VALUES ("PS90_5","020_90_5","PSA","90","5","5","Gata tasiwi aminu kuupbamda kungwakaing. Kungwake wena sikaing. ");
INSERT INTO wnc_vpl VALUES ("PS90_6","020_90_6","PSA","90","6","6","Wa unzing, zongazonga tembana kana kayuk siknga siwan tapuya kana zitziknga siknga sikaing binga singgak. Siwan ngana bangee kananu akupiakaing. ");
INSERT INTO wnc_vpl VALUES ("PS90_7","020_90_7","PSA","90","7","7","Gata ninde kaanga natanimunggayakge ninu pasiwi maikamang. Gata ninde musipba toknga natanimunggayakge ninu gae asiknga gwaukamang. ");
INSERT INTO wnc_vpl VALUES ("PS90_8","020_90_8","PSA","90","8","8","Gata nindane waiaknganinu kuupbam akaayak. Ngan, waiaknga ninda akusopuke tasikamangu wa gata aanggaman peke akakapmanggayak. ");
INSERT INTO wnc_vpl VALUES ("PS90_9","020_90_9","PSA","90","9","9","Kaanga gata nataayak kaknga tapduu ninda keune yutnanga komu atzipmandaknganggayak. Siakan siknga, nindane tapduu zeetgaman wena sikaing. Siwan ninda meya buyak yuke waung kaknga sipdukan yana konggak binga. ");
INSERT INTO wnc_vpl VALUES ("PS90_10","020_90_10","PSA","90","10","10","Sike ninda nakanu 70 ngang gan kayuk yutnanga. Sike ninda kekeknganinu kaya gamu nakanu 80 ayutnam. Siwan ngana nakanu kuupbamu wa yuamangu ninda puya tokngabam tasike meyakan kaamang. Kaatna nakanu wa kuupbam zeetgaman wena siwa nikaya kuut akumna wena singgak. ");
INSERT INTO wnc_vpl VALUES ("PS90_11","020_90_11","PSA","90","11","11","Siwan mamin amin tapata gata musiptok siknga natake sanga kekeknga tasinggayakge natapan kakaa siwik? Wena. Dasingge? Gatane musiptou toknga siknga singgak. Siwan aminda gae asiknga gwautnanga aknga buyambam siknga siwik. ");
INSERT INTO wnc_vpl VALUES ("PS90_12","020_90_12","PSA","90","12","12","Gata ninu katak ninindamumbinu ninda tapduu kepdakane mamaya yutnanga dua ngangu apme natapnim. Unzing siwanu ninda sanga waakngae natapna kakaa siwik. ");
INSERT INTO wnc_vpl VALUES ("PS90_13","020_90_13","PSA","90","13","13","Buyambam tapa, tapduu datdasing gatane musiptok kakngaka yuwik? Gata musiptok kakngaka teke ninu gikane puya amindae butaya natanimuyo. ");
INSERT INTO wnc_vpl VALUES ("PS90_14","020_90_14","PSA","90","14","14","Gata ninde butaya siknga asinggan nataayak. Siwan ninu gata butaya wa natanimunggayak kakngata tembana bamu banimuwawan yutnim. Unzingge asinggan ninu kayuk yuamangge ninda apbakngake musip gwaang natapnim. ");
INSERT INTO wnc_vpl VALUES ("PS90_15","020_90_15","PSA","90","15","15","Tupa gata tapdukbamu meya ninde atnimukuyak. Unzingge gata apmanu apbakngananga aknga nimuyo. Unzing nakanu kwaapzangu wai yukumangge tangge. ");
INSERT INTO wnc_vpl VALUES ("PS90_16","020_90_16","PSA","90","16","16","Gata gikane puya pasinggayak kaknga ninu gikane puya amindae yeitnimuyo. Gatane kekeknga noman akngaka nindane bapuninde yeuyamuyo. ");
INSERT INTO wnc_vpl VALUES ("PS90_17","020_90_17","PSA","90","17","17","Buyambamtapa, ga nindane Anutunin. Gata ninde musip kwikwik natanimuke ninde take pasiyo. Siwan sanga kuupbamu ninda tasinimu takekan siwik. Siakan siknga. Gata sangabamu ninda tasinimu tapi kekekawan takekan yutning. ");
INSERT INTO wnc_vpl VALUES ("PS91_1","020_91_1","PSA","91","1","1","Aminu tapatuta Anutu enane siknga yuak kapae kuwan, Anututa kakuya tasiwikge. Siwan Anutu kekekngana bamban tapae inengan siknga yuwawan Anututa usikwatapik. ");
INSERT INTO wnc_vpl VALUES ("PS91_2","020_91_2","PSA","91","2","2","Siwan aminu waapata Buyambamtapa anzing iniwik, “Gata na takotnake na gata katak nanduyuwayak. Ga natane Anutuna. Nata gae baniu asinggat.” ");
INSERT INTO wnc_vpl VALUES ("PS91_3","020_91_3","PSA","91","3","3","Siakan siknga, Anututa ga katak ganduyuwanu aminu kunduta gutnangge natake bungep pasining ngana ga dua tasiwan maiya. Siwan ga atakotnawanu maiu wai akwakga ga dua taning. ");
INSERT INTO wnc_vpl VALUES ("PS91_4","020_91_4","PSA","91","4","4","Ita ga katak usikwatapik. Unzing taau minga gwenda mateknga piata usikwatapmanggak binga. Ngan, ina unzakan ga Buyambam tapatane pia sayatde gepbiatang kusopuwi ita ga ganduyuwik. Sike i akganduyutnanga akngae kemu dua yanggak. Unzingge ga Buyambam tapaat yutzon. Unzing aminda amakgane tiunggu sande maseatang kusopunggak binga. ");
INSERT INTO wnc_vpl VALUES ("PS91_5","020_91_5","PSA","91","5","5","Sike zikaanen, sanga wai tapatue dua gwaumza. Siwan kwakngaomun, sanga takngatuta zeetgaman apu ga tasiwan maiwiakge dua gwaumza. ");
INSERT INTO wnc_vpl VALUES ("PS91_6","020_91_6","PSA","91","6","6","Sike gatu zikaane maiu buyambamu takngatuta apan kakengu dua gwaumza. Ina unzakan, sanga wai takngatuta gunzitbam tapane gata maiwiakge apan kakengu dua gwaumza. ");
INSERT INTO wnc_vpl VALUES ("PS91_7","020_91_7","PSA","91","7","7","Sike amak aminda aminu 1,000-nu zipa gae wesim kumning. Siwan 10,000-da katakga siapa saak kumning. Kupanu undanga. Sanga kumnanga aknga gaenganu dua apik. ");
INSERT INTO wnc_vpl VALUES ("PS91_8","020_91_8","PSA","91","8","8","Unzingge dua gwauke gika kaawinu Anututa waiaknga wai aminda tasikingge yake meya ayamik. ");
INSERT INTO wnc_vpl VALUES ("PS91_9","020_91_9","PSA","91","9","9","Ga Anutue kuke sanga waiakngae akusopunggayaunin, siwan Anutu enane sikngaapata ga ganduyuak kapanin. ");
INSERT INTO wnc_vpl VALUES ("PS91_10","020_91_10","PSA","91","10","10","Ngan, ita ga tapan takekan yuwi sanga waita gae apnanga dua. Siwan maiu buyambamu takngatu gae yotdane wesimu kunanga dua. ");
INSERT INTO wnc_vpl VALUES ("PS91_11","020_91_11","PSA","91","11","11","Dasingge, Buyambam tapata puya angelanae yaman kepi kuupbamu sukuwiyau ita gandutning. ");
INSERT INTO wnc_vpl VALUES ("PS91_12","020_91_12","PSA","91","12","12","Siwan angelata katakngata ga tapa kenzomba sup gwene dua tepsa. ");
INSERT INTO wnc_vpl VALUES ("PS91_13","020_91_13","PSA","91","13","13","Siwana gata kaap zongu laion gatu gomok waiaknga ngang yainggamumza. Ngan, kaap zongu gumbanga laion gwekat gomou buyambamu waiakngaat yaipapaakusiwi dua gasisan. ");
INSERT INTO wnc_vpl VALUES ("PS91_14","020_91_14","PSA","91","14","14","Anututa anzing yanggak, “Nata aminu nae siknga nataaingu apapit. Ngan, aminu nae katak siknga nataaingu nata katak siknga kayuwit. ");
INSERT INTO wnc_vpl VALUES ("PS91_15","020_91_15","PSA","91","15","15","Sike tapduu aminda nae tumuk wam yaningu nata atnatayamit. Sike meya takngatu waaminde apanu na iat yutnim. Iat gatake yuke waaminu apake umana kopsa yamit. ");
INSERT INTO wnc_vpl VALUES ("PS91_16","020_91_16","PSA","91","16","16","Siwana nata kayuk yutnanga aknga yamuke isapakopa tapduu mamaya yutning. Yuwawa nata gatuna papa naat gatake yutnim.” ");
INSERT INTO wnc_vpl VALUES ("PS92_1","020_92_1","PSA","92","1","1","Buyambamtapa, ga Anutu enane sikngaapa. Nata kap taike umanda yatangenawitde natapa take siknga singgak. ");
INSERT INTO wnc_vpl VALUES ("PS92_2","020_92_2","PSA","92","2","2","Sike tembana tapduu kuupbam gata nae siknga nataayakge natake umanda yatangenawitde natapa take singgak. Siwan zikaane kuupbamu asinggan nanduyuwayak kakngae yakapitde natapa take singgak. ");
INSERT INTO wnc_vpl VALUES ("PS92_3","020_92_3","PSA","92","3","3","Nata gita daka tanguwa gakngae take yawan ");
INSERT INTO wnc_vpl VALUES ("PS92_4","020_92_4","PSA","92","4","4","Dasingge? Gata nae puya kekeknga tasikuyakge natapa kuwan nata musip gwaang siknga natakengu nata apbakngake kap gae tainggamunggat. ");
INSERT INTO wnc_vpl VALUES ("PS92_5","020_92_5","PSA","92","5","5","Buyambamtapa, gata puya buyambam siknga pasinggayak. Gatane natdetdetda buyambam siknga. ");
INSERT INTO wnc_vpl VALUES ("PS92_6","020_92_6","PSA","92","6","6","Sike aminu natdetdetna wena amindanu wai aminu zonga zonga taketa akopning binga ngangu natdetnanga dua. ");
INSERT INTO wnc_vpl VALUES ("PS92_7","020_92_7","PSA","92","7","7","Ngan, waiaknga tasikaing aminu sangabam pake take yutning. Siwan ngana gata waaminu gatukande pasiwi maining. ");
INSERT INTO wnc_vpl VALUES ("PS92_8","020_92_8","PSA","92","8","8","Dasingge, Buyambamtapa, gika siknga king kapa asinggan asinggan yuayak. ");
INSERT INTO wnc_vpl VALUES ("PS92_9","020_92_9","PSA","92","9","9","Ninu atnataamang. Aminu gatane iwanda dakngakaingu waakwau akumning. Ngan, waiaknga tasikaing aminu kuupbamu gata ayaipakepu peya. ");
INSERT INTO wnc_vpl VALUES ("PS92_10","020_92_10","PSA","92","10","10","Siwan ngana gata nae kekeknga buyambam namukuyak. Unzing kekeknga ikwawa gamanu wawi gwendane binga. Gata nae take tasikuyakge na asiknga baknganggat. ");
INSERT INTO wnc_vpl VALUES ("PS92_11","020_92_11","PSA","92","11","11","Sike natane iwana pasiwi maiwanu kainata gwa kakum. Siwan gata iwana yapbimbi datakuke kwanamu sikingu maakngata atnatapbum. ");
INSERT INTO wnc_vpl VALUES ("PS92_12","020_92_12","PSA","92","12","12","Siwan ngana amin noman aminu take siknga, zanggwa dakandakata buya buyambam aakaing binga yutning. Unzing katau buyambam sida ngang yanikaingu tawanu Lebanon komune nana dakandakata buyambam siknga takakaing binga. ");
INSERT INTO wnc_vpl VALUES ("PS92_13","020_92_13","PSA","92","13","13","Noman aminu waakwau Buyambam tapatane yot gwekatang katau gwa kwaiwan yuking binga yutning. Katau wa dakandaka Anutunindane yotnaatangu take siknga akokaing. ");
INSERT INTO wnc_vpl VALUES ("PS92_14","020_92_14","PSA","92","14","14","Sike katau wa dakandaka damana gwa sike ngana tapuya awasike yuaing. Katau waakwau kekeknga yuke dua kupiakaing. Itane tatakngi gwegwenga asinggan yuke buyana aatning. Unzing, aminu noman aminu aminuake sining ngana kekekake yutning. ");
INSERT INTO wnc_vpl VALUES ("PS92_15","020_92_15","PSA","92","15","15","Kekekake yuke kepi waakngata aminu anzing yeuyamuning, “Buyambamtapa noman siknga. Na gatangamunangge akekekangamunggak. Itane gutongana wena. Wena siknga.” ");
INSERT INTO wnc_vpl VALUES ("PS93_1","020_93_1","PSA","93","1","1","Buyambamtapata king kapa yuak. Aminu kuupbam kayuak. Itane umana kopsa siknga aknga tauk ina usikwatanggak binga. Ngan, kekekngana buyambam siknga. Ita keu andaka tasiwan kekeknga siknga tangine yuak. ");
INSERT INTO wnc_vpl VALUES ("PS93_2","020_93_2","PSA","93","2","2","Buyambamtapa, tapduu sangabamu dua aake yuking komune ga ayukuyak. Ga asinggan asinggan yuayak. Yuke King kapa asinggan asinggan yuayak. ");
INSERT INTO wnc_vpl VALUES ("PS93_3","020_93_3","PSA","93","3","3","Buyambamtapa, yanggabam gwenu amunandang siknga gakngau kumzang gakngau yanggak. Kekeknga siknga yanggak. ");
INSERT INTO wnc_vpl VALUES ("PS93_4","020_93_4","PSA","93","4","4","Yanggabam gwenda gakngau yanggau wa mateknga dua. Siwan yanggabam gwendane sambuya enake gakngae kekeknga taku tangukgak. Siwan ngana gatane kekekngaka buyambam siknga. ");
INSERT INTO wnc_vpl VALUES ("PS93_5","020_93_5","PSA","93","5","5","Sike gatane mama wamba kuupbam asinggan asinggan yuaing. Siakan siknga. Buyambamtapa, gatane yotda siknga asinggan asinggan yuak. ");
INSERT INTO wnc_vpl VALUES ("PS94_1","020_94_1","PSA","94","1","1","Buyambamtapa, ga Anutu, gae waiaknga tasikaing aminu meya yake ayamunggayak. Sike apmanu gata kaanga nataayak kakngaka waaminde yeuyamuyo. ");
INSERT INTO wnc_vpl VALUES ("PS94_2","020_94_2","PSA","94","2","2","Gata tasiwi amin kuupbamda gatane kaikane wam yaning. Gata apman apuke yamandet aminda waiaknga tasikaingge yake meya yamuyo. ");
INSERT INTO wnc_vpl VALUES ("PS94_3","020_94_3","PSA","94","3","3","Tapduu mamaya yuak ge wai aminu yuyukngae bakngake yutning? Buyambamtapa, tapduknga mamaya yuak, ba? Tapduu datdasing binga yuakge yamandet aminu waiaknga tasikaingge baknganing? ");
INSERT INTO wnc_vpl VALUES ("PS94_4","020_94_4","PSA","94","4","4","Tapduu datdasing binga yuakge wai aminda waiaknga tasiningge yamandet dakngake bakaning? ");
INSERT INTO wnc_vpl VALUES ("PS94_5","020_94_5","PSA","94","5","5","Buyambamtapa, gatane amindabamu waaminda apasiwan maiwan meya buyambam yamukaingunin. ");
INSERT INTO wnc_vpl VALUES ("PS94_6","020_94_6","PSA","94","6","6","Sike waaminda maya apna gwa kumbingunin zipan kungwakaing. Zipan kupan waatdaka minganana gwa kumbingu kuut zipan kungwakaing. Zipan kupan aminu maa nana ngana pakapu inengan yuaingu iat kuut zipan kungwaikaing. ");
INSERT INTO wnc_vpl VALUES ("PS94_7","020_94_7","PSA","94","7","7","Siwan anzing yakaing, “Buyambam tapata ninu dua ninduak. Anutu Isrel amindane apata sanga ninda tasikamang kaknga kake ngana undanga ngang nataak,” ngang yakaing. ");
INSERT INTO wnc_vpl VALUES ("PS94_8","020_94_8","PSA","94","8","8","Ginu natane aminabam, dasingge ginda kepi yumdekan taknga unzingu tasikaing? Ginu katum amin, zaapduk ngaya natdetning? ");
INSERT INTO wnc_vpl VALUES ("PS94_9","020_94_9","PSA","94","9","9","Anututa nindane maaknginu pasikut. Unzingge asikaya ita dua natapik, ba? Siwan Anututa nindane kaininu pasikut. Asikaya ina dua kaak, ba? ");
INSERT INTO wnc_vpl VALUES ("PS94_10","020_94_10","PSA","94","10","10","Ita amin kuupbam kayuak. Ayok! Asikaya ita waakwau dua papanomataning, ba? Siwan waapa aminu kuupbamdane yanindamumsa apa. Asikaya i natdetdetna wena ba? ");
INSERT INTO wnc_vpl VALUES ("PS94_11","020_94_11","PSA","94","11","11","Buyambam tapatanu aminu kuupbamdane natdetdetna atnataak. Sanga kuupbam ita tasinangge natapningu buya dua aawik ngang atnataak. ");
INSERT INTO wnc_vpl VALUES ("PS94_12","020_94_12","PSA","94","12","12","Buyambamtapa, gata aminu tapatu gikane mama wamba inindamumbinu aminu waapata apbakngayok. ");
INSERT INTO wnc_vpl VALUES ("PS94_13","020_94_13","PSA","94","13","13","Gata unzingu wa tasinggaau wa ie yuwatakak imunggak. Imi waapa meya kundu dua kawik. Siwawan wai aminu kungwake kupsa aminda yuaing komune kuning. ");
INSERT INTO wnc_vpl VALUES ("PS94_14","020_94_14","PSA","94","14","14","Dasingge, Buyambam tapata inane aminabamu dua kapewik. Siakande siknga, ita aminabamu masa dua yamik. ");
INSERT INTO wnc_vpl VALUES ("PS94_15","020_94_15","PSA","94","15","15","Sike masande noman aminda wam yaning kopatangu yawan kuku noman gan siwik. Siwan noman aminda take ngang natake wamu nomanu waaknga tawaning. ");
INSERT INTO wnc_vpl VALUES ("PS94_16","020_94_16","PSA","94","16","16","Maminda enake na gatangamuke wai aminu yaipakepu pewik? Maminda enake na gatangaman gutonga tasia aminda nutnangge natake tasiwa maiwik? ");
INSERT INTO wnc_vpl VALUES ("PS94_17","020_94_17","PSA","94","17","17","Sike Anututa dua gatangamukut gamu, asikaya kupsa aminda keu yuaing kopatang na zaatgaman gwa pewam. ");
INSERT INTO wnc_vpl VALUES ("PS94_18","020_94_18","PSA","94","18","18","Na anzing yakum, “Kepina saweknga. Na gwa pimananggenggat,” ngang yakum. Siwan ngana wena. Buyambam tapa, gata butaya siknga natangamuke na tapi nata waiakngaatang dua pimakum. ");
INSERT INTO wnc_vpl VALUES ("PS94_19","020_94_19","PSA","94","19","19","Sike na musipmaatang meya natake sangabamde natanggamatanggat kopatangu gata tasiwi musipma kwikwiknga yuwan apbaknganggat. ");
INSERT INTO wnc_vpl VALUES ("PS94_20","020_94_20","PSA","94","20","20","Ga gwapaknga aminu kawi wai siwanu puya iat dua gatake pasikaing. Waakwakga mama wamu ina peke yawan kekekawan aminu waiaknga tasiningge yanikaing. ");
INSERT INTO wnc_vpl VALUES ("PS94_21","020_94_21","PSA","94","21","21","Sike waakwau unekan yuke noman amin pasiwan mainingge yandekaing. Siwan gutonga dua tasikaing ngana temapa yanikaing. Yanike zipa kumninggen. ");
INSERT INTO wnc_vpl VALUES ("PS94_22","020_94_22","PSA","94","22","22","Siwan ngana Buyambamtapa, na gatangamunangge asiknga kekekanggaunin. Ngan, Anutunata na kakuya take tasiwawan ie kuke kusopuke yuat. ");
INSERT INTO wnc_vpl VALUES ("PS94_23","020_94_23","PSA","94","23","23","Siwan nana waakwau waiaknga kwaapzang tasiking. Unzingge yake gutonganae meya apme yamik. Ita waiaknganae natapan kuwan ita apme zipan kumning. Unin, Anutu, Buyambam tapaninda, gatukande siknga pasiwan maining. ");
INSERT INTO wnc_vpl VALUES ("PS95_1","020_95_1","PSA","95","1","1","Ginu apnong! Ninda apbakngake kau Buyambam tapatane umana yatangenatnangge taina. Ninda Anutu kekeknga siknga apata ninu gatu pakutde natake ninda kap taike ie ainggamatake apbaknganim. ");
INSERT INTO wnc_vpl VALUES ("PS95_2","020_95_2","PSA","95","2","2","Ninda ie inengan kuke musip gwaang kaknga inina. Ninda kau kundu taike bakngake itane umana yatangenatna. ");
INSERT INTO wnc_vpl VALUES ("PS95_3","020_95_3","PSA","95","3","3","Dasingge? Buyambamtapa i Anutu kekeknga siknga apa. Ita Kingu kekekngaapa yuke ita anutu pupuknga kuupbam ayapbike enane siknga yuak. ");
INSERT INTO wnc_vpl VALUES ("PS95_4","020_95_4","PSA","95","4","4","Ita kepna kepna kuupbam kayuak. Amunandang siknga gapmene yuainguneta kuku gatu tawanune enane siknga yuaingu kuut kayuak. ");
INSERT INTO wnc_vpl VALUES ("PS95_5","020_95_5","PSA","95","5","5","Ita ina siknga kepdakaat gatu yanggabam gwekat pasike pekut. Unzingge ina kayuak. ");
INSERT INTO wnc_vpl VALUES ("PS95_6","020_95_6","PSA","95","6","6","Ginu apnong. Ninda gwapaknginu gwetake inimbakngana, Buyambam tapata ninu pasikutde. Ayok, inimbakngake ninda ie wesim kuke munu putna. ");
INSERT INTO wnc_vpl VALUES ("PS95_7","020_95_7","PSA","95","7","7","Dasingge? Anutu i ninu kuupbamdane apa. Ita ina ninu kakuya tasike ninu sipsip binga ninduyuak. Ninduyuke ita ninde sanga kuupbam atnimunggak. Unzingge ginda ie wam natapnong. ");
INSERT INTO wnc_vpl VALUES ("PS95_8","020_95_8","PSA","95","8","8","Buyambam tapata anzing yakut, “Ginda musipza kekeknga ma wamakusiwam. Unzing tupa bapusaat Moseskat keu komdu umana Meriba gatu Masa ngang inikaing komu sanga wena kepban komune tasiking bingan. ");
INSERT INTO wnc_vpl VALUES ("PS95_9","020_95_9","PSA","95","9","9","Waaminda keu waomune yuke puya nata kekeknga pasikumu kakapbing ngana na tanzit tasiwa sikut. ");
INSERT INTO wnc_vpl VALUES ("PS95_10","020_95_10","PSA","95","10","10","Tanzit tasiwawa nata musipmaiu waaminde natayuwawa kuku nakanu 40 sikut. Unzingge nata anzing yakum, ‘Musipnaatangu nae dua nataing. Asingganu kepi nata teyamukum tapa ateaing.’ ");
INSERT INTO wnc_vpl VALUES ("PS95_11","020_95_11","PSA","95","11","11","Unzingge nata musiptok natake waaminu nata anzing yanikum, ‘Ginda you ayuwan takananga komu ginde damunangge natat ngana dua dama koke yuwatakawik,’ ngang yakum.” ");
INSERT INTO wnc_vpl VALUES ("PS96_1","020_96_1","PSA","96","1","1","Ginda kau kayuk kaknga aknga Buyambam tapae tainong. Ginu kepna kepna nana aminu kuupbam sikngata Buyambam tapae kau tainong. ");
INSERT INTO wnc_vpl VALUES ("PS96_2","020_96_2","PSA","96","2","2","Kau Buyambam tapae tainong. Taike itane umana yatangenatnong! Tapduk tapduk ginda aminbamu anzing yanikapnong. Buyambam tapata inane aminu panggakge yanikapnong. ");
INSERT INTO wnc_vpl VALUES ("PS96_3","020_96_3","PSA","96","3","3","Ginda itane umana kopsa akngae aminu kepna kepna nana dongu kuupbamde yanikapnong. Yanikapmake puya gwaang gwangu buyambamu ita tasinggakge yanikapnong. ");
INSERT INTO wnc_vpl VALUES ("PS96_4","020_96_4","PSA","96","4","4","Dasingge? Buyambamtapa umana kopsaapa. Ge ninda umana kumzang siknga yatangenatnim. Sike anutu pupuknga wa Buyambamtapa binga dua. Unzingge ninda ie gepbiatang koyutnim. ");
INSERT INTO wnc_vpl VALUES ("PS96_5","020_96_5","PSA","96","5","5","Dasingge? Anutu pupuknga aminu dongu kundutane, wa Anutu siknga dua. Siwan ngana Buyambamtapa sangabamu ena kakaa komune nana pasike pekut tapa unin. ");
INSERT INTO wnc_vpl VALUES ("PS96_6","020_96_6","PSA","96","6","6","Buyambam tapata inane yotnane yuke umana kopsa siknga king kapa yuak. Siwan ita kekeknga akngatane toiknga. Siwan sanga gwaamgwaamde toiknga. ");
INSERT INTO wnc_vpl VALUES ("PS96_7","020_96_7","PSA","96","7","7","Ginu aminu kuupbamda itane umana kopsa akngaat gatu kekeknganaat ngangge apbakngake yatangenatnong. ");
INSERT INTO wnc_vpl VALUES ("PS96_8","020_96_8","PSA","96","8","8","Ginda Buyambam tapatane umana kopsa akngae yatangenatnong. Sanga kundu ie imunangge pake yotnane kopnong. ");
INSERT INTO wnc_vpl VALUES ("PS96_9","020_96_9","PSA","96","9","9","Ginu aminu kuupbamda Buyambamtapa takwan yuak kapae munu puke inimbaknganong. Inimbakngake ginda ie akgwauke dandansa yamutnong. ");
INSERT INTO wnc_vpl VALUES ("PS96_10","020_96_10","PSA","96","10","10","Sike ginda aminu keu komdu komdune nana kuupbamu anzing yaninong, “Buyambamtapa king kapa yuak.” Siwan ita kepdaka tapan kekekawan saa sinanga dua. Masande Buyambam tapata kepi noman takngane wam usanzike aminbamu yuyuknga yuaing kakngane usanziwik. ");
INSERT INTO wnc_vpl VALUES ("PS96_11","020_96_11","PSA","96","11","11","Sanga kakaa komune nanaat gatu aminu kepna kepna nanaat ngangu ginda apbaknganong. Yanggabam gwen gatu sangabamu gaatang yuaingu kuutda gakngatbam tasike ayanggamatanong. ");
INSERT INTO wnc_vpl VALUES ("PS96_12","020_96_12","PSA","96","12","12","Puya anga kuupbam gatu nanamu kuupbamu gaatang yuaingu ginu kuupbamda apbaknganong. Siwana katau zongaatang nana kuupbamda kau apbakngake tainong. ");
INSERT INTO wnc_vpl VALUES ("PS96_13","020_96_13","PSA","96","13","13","Dasingge, Buyambam tapata apuke aminu kepna kepna nana kuupbamdane wam usanzitnangge apik. Siwan ita aminu kuupbam kepi noman takngane usanzike tasiwik. Tasike siakan wam takngane usanziwik. ");
INSERT INTO wnc_vpl VALUES ("PS97_1","020_97_1","PSA","97","1","1","Buyambamtapa kingu tupan tapa. Kepdaka ga asiknga bakngayo. Sike ginu keu yangga banakan yuaing dakandakasimu musip gwaang natapnong. ");
INSERT INTO wnc_vpl VALUES ("PS97_2","020_97_2","PSA","97","2","2","Minga gatu zikaa aknga ngangga Anutu banakan yuwawan atakumbasikamayak. Atakumbasiwawat ita kepi noman takngane tawake aminu usanzike kayuak. ");
INSERT INTO wnc_vpl VALUES ("PS97_3","020_97_3","PSA","97","3","3","Iwanata takumbasiwawa ngana ita tasiwan katapda tupan isitakuke iwana yasipuyukgak. ");
INSERT INTO wnc_vpl VALUES ("PS97_4","020_97_4","PSA","97","4","4","Siwan ita tasiwan yapasik gatu siwawan kepdaka kakaa singgak. Siwan kepdakata waenga waaknga kake asatnakaing. ");
INSERT INTO wnc_vpl VALUES ("PS97_5","020_97_5","PSA","97","5","5","Anutu waapa aminu kepna kepna nana aminu kuupbamdane Buyambam tapa. Siwan Anututa apan kake tawanu dauyapmake yangga binga dakngakaing. ");
INSERT INTO wnc_vpl VALUES ("PS97_6","020_97_6","PSA","97","6","6","Siwan sanga ena kakaa komune yuaingga itane yuyuknga noman takngae yeuyaman kake aminu kuupbamda umana kayaapa ngang nataaing ");
INSERT INTO wnc_vpl VALUES ("PS97_7","020_97_7","PSA","97","7","7","Siwan aminu anutu pupukngae munu puke inike umana yapangenakaingu waaminu asiknga maakaning. Anutu pupuknga wa kuupbamda Anutue gwetake munu putning. ");
INSERT INTO wnc_vpl VALUES ("PS97_8","020_97_8","PSA","97","8","8","Munu puwan kake Saion nana aminu kuupbam gatu yotbamu Juda nana apbakngakaing. Ngan, aminu Juda kep komune yuaingu kuupbamda banip gwaangu gatane kot natake apbakngakaing. ");
INSERT INTO wnc_vpl VALUES ("PS97_9","020_97_9","PSA","97","9","9","Buyambam tapa, ga Anutu enane siknga apa, kekekngaka bamban tapa, gata keu kuupbam kakuya tasinggayak. Ga umanda kopsaapa siwan gata anutu pupuknga kuupbam ayapbikgayak. ");
INSERT INTO wnc_vpl VALUES ("PS97_10","020_97_10","PSA","97","10","10","Buyambam tapata aminu waiaknga tasinangge dua nataaing aminde take siknga natayamunggak. Ita kakuya inane noman aminabamu katak kayuke toknga amindane kataune sandepakapuke kayuak. ");
INSERT INTO wnc_vpl VALUES ("PS97_11","020_97_11","PSA","97","11","11","Sandepakapuke amin nomande Anututa kakaa aknga ayamuke pasiwan musip gwaang natake waaminu apbakngakaing. ");
INSERT INTO wnc_vpl VALUES ("PS97_12","020_97_12","PSA","97","12","12","Ginu amin noman, ginda Buyambam tapae apbaknganong. Bakngake ie gaak wam ininong. Takeaknga gatu noman siknga aknga ngangu Anutu waapatakan tasinggakge apbaknganong. ");
INSERT INTO wnc_vpl VALUES ("PS98_1","020_98_1","PSA","98","1","1","Ninda kau kayuu takngatu Buyambam tapae tainim. Dasingge, ita duya inata inata take siknga pasinggak. Pasike inane kekekngana buyambamu yuyuknga takwan takngane tasike ita amau ayapbikgak. ");
INSERT INTO wnc_vpl VALUES ("PS98_2","020_98_2","PSA","98","2","2","Buyambam tapata amak tasike yapbikutde gwa yakapbut. Yakapmake ita noman nomana tasike aminabamu gatuna sendeke pakut taknga yeuyaman aminu kepna kepna nana kuupbamda kaking. ");
INSERT INTO wnc_vpl VALUES ("PS98_3","020_98_3","PSA","98","3","3","Siakan, ita wamu ina yawan kekekakut takngae natake Isrel nana aminde butaya natayamuke dua kapekut. Dua kapewan aminu kepna kepna nana kuupbamda kawawa Anutuninda amau tasike yapbike ninu gatuna pakut. ");
INSERT INTO wnc_vpl VALUES ("PS98_4","020_98_4","PSA","98","4","4","Ginu aminu kepna kepna nanata kap taike Buyambam tapae apbaknganong! Siwan musip gwaang kap taike itane umana ayatangenatnong! ");
INSERT INTO wnc_vpl VALUES ("PS98_5","020_98_5","PSA","98","5","5","Yatangenake ginda gita tanguke kap taike Buyambam tapae umana aknga yatangenatnong. Yatangenake gita tanguwa gakngae take siknga siyok. ");
INSERT INTO wnc_vpl VALUES ("PS98_6","020_98_6","PSA","98","6","6","Siwan pum gatu benggo ngang puyake ayanggamatake Buyambamtapa king kapaninde apbaknganong. ");
INSERT INTO wnc_vpl VALUES ("PS98_7","020_98_7","PSA","98","7","7","Siwan nata nataau yanggabam gwenu gaat pis gatu sanga bamu gaatang yuaingu ginda kapzang yanggamataningge nataat. Siwan kepdaka, ga gatu sanga gaeatang yuaingu kuupbamda kap tainingge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS98_8","020_98_8","PSA","98","8","8","Siwan yangga atzipmakaing kapaapa ginda aminda kataknga wesikaing binga wesiningge nataat. Sike ginu tawanu kuupbamda, ginda Anutue kaine kap taike asiknga baknganingge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS98_9","020_98_9","PSA","98","9","9","Nata nataau Buyambam tapae kaine kap tainingge nataat. Dasingge? Ita apuke aminu kepna kepna nana kuupbam kot yake usanziwik. Usanzike aminu kuupbam noman takngane usanziwan siakan siknga siwik. ");
INSERT INTO wnc_vpl VALUES ("PS99_1","020_99_1","PSA","99","1","1","Buyambamtapa king kapa yuak. Yuakge aminbamda ie ayamuke gwautnong. Ita sia king dakane pukwiwan angela kautkaut yukumayak. Siwan kepdaka miamun siwikge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS99_2","020_99_2","PSA","99","2","2","Sike Buyambamtapa kekekngana buyambam siknga keu Saion komune yuak. Ita umana kopsa siknga akngane aminu kepna kepna nana kuupbam kayuak. ");
INSERT INTO wnc_vpl VALUES ("PS99_3","020_99_3","PSA","99","3","3","Siwana umana kopsa waakngae gwauke yatangenatnong. Anutu waapa noman takngakan tasinggaunin. Anutu waapa noman taknga gatu takeaknga ngang kuupbam tasinggaunin. ");
INSERT INTO wnc_vpl VALUES ("PS99_4","020_99_4","PSA","99","4","4","Kingu kekekngaapa, ga noman takngaekan take siknga nataayak. Ngan, gata ninu Isrel nana aminu sanga take gatu noman taknga ngang tasinimde nimukuyak. Nimi ninda atawakamang. ");
INSERT INTO wnc_vpl VALUES ("PS99_5","020_99_5","PSA","99","5","5","Ginda Buyambam tapatane umana asiknga yatangenatnong. Wa nisane Anutunin. Ginda ie wesim kuke munu putnong. Sike Anutu waapa noman takngakan tawanggak kapanin. ");
INSERT INTO wnc_vpl VALUES ("PS99_6","020_99_6","PSA","99","6","6","Sike Moses gatu Aron ngangu Buyambam tapatane pris tapaat dakngake yukumayak. Siwan Samuel kaya Anutue mun puke inikaing aminkat nana tapatu waaminda Buyambam tapae tumuk wam iniwawa tumuk wamna atnatapbut. ");
INSERT INTO wnc_vpl VALUES ("PS99_7","020_99_7","PSA","99","7","7","Natake ita minga buyambam musaatang yuke waaminde yanikut. Siwan waaminda mama wamu wa Anututa yamukuu kuupbam tawaking. ");
INSERT INTO wnc_vpl VALUES ("PS99_8","020_99_8","PSA","99","8","8","Anutu, nindane Buyambam tapanin, gata amindabamdane tumuk wamna atnatapbuyak. Sike waiaknganin sandetnimunggayakge atnataamang. Siwan ngana gutonga tasikingge yake meya ayamukuyak. ");
INSERT INTO wnc_vpl VALUES ("PS99_9","020_99_9","PSA","99","9","9","Anututane umana yatangenatnong. Buyambam tapaninden. Siwan munu inane tawandakane putnong. Anutu, Buyambam tapanin, wa Anutu noman takngakan tasinggak kapanin. ");
INSERT INTO wnc_vpl VALUES ("PS100_1","020_100_1","PSA","100","1","1","Ginu aminu kepna kepna yuaingu, ginda Anutue apbakngananga kap tainong. ");
INSERT INTO wnc_vpl VALUES ("PS100_2","020_100_2","PSA","100","2","2","Ginda Buyambam tapae musip gwaang natangamuke puya ie pasingamunong. Ginu kau apbakngananga taknga aknga taike ie wesim kunong. ");
INSERT INTO wnc_vpl VALUES ("PS100_3","020_100_3","PSA","100","3","3","Ginda Buyambam tapae natapa kekekayok. Ita Anutu siknga awiapa unin. Sike waapatakan ninu tumuke nipmakut. Unzingge ninu inane siknga. Ninu inane aminabam. Ngan, ninu itane sipsipna binga dakngake yuamang. ");
INSERT INTO wnc_vpl VALUES ("PS100_4","020_100_4","PSA","100","4","4","Ginda itane yotna gwene koke gaak inike umana yatangenatnong. Gaak inike tasiwa umana kopsa siwik. ");
INSERT INTO wnc_vpl VALUES ("PS100_5","020_100_5","PSA","100","5","5","Sike Buyambamtapa sanga take akngakan tasinggaunin. Asingganu ita ninde musip gwaang natanimunggak. Ita inane siakan wam takngana asinggan asinggan tawanggak. ");
INSERT INTO wnc_vpl VALUES ("PS101_1","020_101_1","PSA","101","1","1","Buyambamtapa, nata kau takngatu gae musip gwaangge natake taiwit. Siwan gata kepi noman tawake wam usanzikgayakge natake kau tainangge nataat. Buyambamtapa, nata gae natake kau waaknga tainanggenggat. ");
INSERT INTO wnc_vpl VALUES ("PS101_2","020_101_2","PSA","101","2","2","Nata noman takngakan tawambit. Buyambamtapa, zaapduknga gata apu na gatangamuya? Gatangamuwawi nata noman takngakan yotnane yuke sukuwit. ");
INSERT INTO wnc_vpl VALUES ("PS101_3","020_101_3","PSA","101","3","3","Sike nata sanga wai takngatue natapa take ngangu dua siwik. Wena siknga. Nata sanga aminu Anutue masa imuke tasikaing kakngae asiknga bitanggat. Sanga wai waaknga dua siknga tawambit. ");
INSERT INTO wnc_vpl VALUES ("PS101_4","020_101_4","PSA","101","4","4","Nata aminu musiaatang sanga waie nataingu teke ie maa siknga yuwit. Ngan, waiaknga aknga gatukande teke ie dua siknga natapit. ");
INSERT INTO wnc_vpl VALUES ("PS101_5","020_101_5","PSA","101","5","5","Nata aminu kusopuke notnaapae inisapdukgak kapa asiknga tasiwa maiwan wamu gatuna yananga dua siwik. Siwan yamandet aminu dua kapewa yutning. ");
INSERT INTO wnc_vpl VALUES ("PS101_6","020_101_6","PSA","101","6","6","Sike na Anutue natake tawakaing aminkat gatake yotnane yutnim. Siwan aminu take aknga asinggan tasikaingu, waamindakan natane puya pasining. ");
INSERT INTO wnc_vpl VALUES ("PS101_7","020_101_7","PSA","101","7","7","Sike kem aminu yotna buyambam gwekatang dua yutning. Kem aminu waakwau natane nomnane dua yutning. Wena siknga. ");
INSERT INTO wnc_vpl VALUES ("PS101_8","020_101_8","PSA","101","8","8","Siwan tapdukbamu nata wai aminu ninde kep kopatang yuaingu apasiwa gena umutning. Nata aminu waiaknga tasikaingu yanikwasiwa kuke waaminda Buyambam tapae yotbam gapmane gatu yutnanga dua. ");
INSERT INTO wnc_vpl VALUES ("PS102_1","020_102_1","PSA","102","1","1","Buyambam tapa, nata tumuk wamu gae yawa natapso. Gata gatangamiyakge natake gae yanggat taknga natangamuyo. ");
INSERT INTO wnc_vpl VALUES ("PS102_2","020_102_2","PSA","102","2","2","Siakan. Meya buyambamda nae apan kakengu ga nae ma kusopuwim. Sike nata tumuk wamu gae yawanu gata maak pake natane wama natake zet gatangamuyo. ");
INSERT INTO wnc_vpl VALUES ("PS102_3","020_102_3","PSA","102","3","3","Dasingge, natane kayuk yutnanga aknga katap sawa kupan takngata enake mateknga yuke asopukaing binga. Siwan natane gupma toknga katapaim binga. Katap yasiwan katapaimu toknga sikaingunin. ");
INSERT INTO wnc_vpl VALUES ("PS102_4","020_102_4","PSA","102","4","4","Siwan Anutu, ga nandutewi meya takngatu kakumu wa unzing, zongazongata akupiakaing binga sikum. Siwan natane musipmaatangu nanamu natapnanga dua sikut. ");
INSERT INTO wnc_vpl VALUES ("PS102_5","020_102_5","PSA","102","5","5","Na meya natake nata kumzang siknga yanggamatanggat. Siwan natane gupma suyuknga dua. Na kwatanakan tapata yuat. ");
INSERT INTO wnc_vpl VALUES ("PS102_6","020_102_6","PSA","102","6","6","Na wai siknga kwaiu taa gwenduta keu nanamna wena komune yuak binga nata yuat. Yuke kwaiu zikaane sukunggau gwenduta binga ninatakan yuat. ");
INSERT INTO wnc_vpl VALUES ("PS102_7","020_102_7","PSA","102","7","7","Siwan na apekgat komune pewa ngana kaina petnanga dua singgak. Butaya! Na ninatakan kwaiu gwenduta inatakan yot dum tangan yuak binga yuat. ");
INSERT INTO wnc_vpl VALUES ("PS102_8","020_102_8","PSA","102","8","8","Sike gunzit tapane gatu zikaane ngangu iwanata aminu kundu ayanisapdukaing. Siwan waaminda masa wam yanike natane umana aknga yake Anututa na tasiwan meya pakum taknga tawake tasiwa waaminu meya paningge yakaing. ");
INSERT INTO wnc_vpl VALUES ("PS102_9","020_102_9","PSA","102","9","9","Nata muyuu nanama binga nake kai yanggana puke kapmane yangga tangokgat gopatang pukuwa tangokgat. ");
INSERT INTO wnc_vpl VALUES ("PS102_10","020_102_10","PSA","102","10","10","Dasingge? Gata nae kaanga buyambam siknga natangamuke na take samba samba binga mutewi kunggat. ");
INSERT INTO wnc_vpl VALUES ("PS102_11","020_102_11","PSA","102","11","11","Na kayuu dapaknga siknga yuat. Unzing gunzitda bangee pukunggak binga. Siwan na zongazonga akupiakaingga binga yuat. ");
INSERT INTO wnc_vpl VALUES ("PS102_12","020_102_12","PSA","102","12","12","Siwan ngana, Buyambamtapa, ga king kapa asinggan yuayak. Sike aminbamu masan aatningga gaenu atnatapning. ");
INSERT INTO wnc_vpl VALUES ("PS102_13","020_102_13","PSA","102","13","13","Sike tapduknga gata butaya natapnanga gwa singgak. Ngan, apmanu butaya natapnanga tapduk. Apmanu gata apuke Saion yotbam gapmae musip kwikwik natangamuke gatangamuyo. ");
INSERT INTO wnc_vpl VALUES ("PS102_14","020_102_14","PSA","102","14","14","Saion yotbam gapma you bumi wai gwa sikut. Siwan ngana gatane puya amindata you wa gapmatane samba sambae take siknga nataaing. Apmanu wai gwa siwan ngana kupapongu ayuakge butaya siknga nataaing. ");
INSERT INTO wnc_vpl VALUES ("PS102_15","020_102_15","PSA","102","15","15","Aminu dongu kuupbamda Buyambam tapae akgwauke ie gepbiatang yutning. Ngan, Buyambamtapa, kingu kuupbamu kepna kepna nanata gatane umanda kopsa siknga akngakae akgwautning. ");
INSERT INTO wnc_vpl VALUES ("PS102_16","020_102_16","PSA","102","16","16","Masande Anututa Saion yotbam gapma gatu tangenakengu ita inane kekekngana aminu kuupbamde ayeuyamik. ");
INSERT INTO wnc_vpl VALUES ("PS102_17","020_102_17","PSA","102","17","17","Siwana inane aminabamda upeeke tumuk wamu iniwa ita maak papik. Tupa waaminu sandepewan moo yuking ngana gatu ita waamindane tumuk wamnae masa dua yamik. ");
INSERT INTO wnc_vpl VALUES ("PS102_18","020_102_18","PSA","102","18","18","Nata nataau wamu takngatu buk gomune apmataningge nataat. Ge bapuninu dongu masan aatningga wamu waakngae natake waaminda Buyambam tapatane umana ayatangenatningge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS102_19","020_102_19","PSA","102","19","19","Wamu anzing mataning, “Buyambamtapa enane yuke amunandang kakut. Ita yekaune yuke amuna kepdaka akakut. ");
INSERT INTO wnc_vpl VALUES ("PS102_20","020_102_20","PSA","102","20","20","Kake ita nataawan iwanata aminu kundu papa kaautde pewa yuke meya pakaingga kwanam siwa natapbut. Natake ita waaminu kotda akumningge gwa yawan kekekakut ngana sandeyaman kepman pukuke dua kumning.” ");
INSERT INTO wnc_vpl VALUES ("PS102_21","020_102_21","PSA","102","21","21","Zaion nana aminda Buyambam tapatane umana yakapning. Ngan, yakapmake Jerusalem nana waaminda gaak wamu ie inining. ");
INSERT INTO wnc_vpl VALUES ("PS102_22","020_102_22","PSA","102","22","22","Inike aminu kepna kepna nanaat gatu kingaat Jerusalem yot gapmane unekan yuke Buyambam tapae munu putning. ");
INSERT INTO wnc_vpl VALUES ("PS102_23","020_102_23","PSA","102","23","23","Nata waatdaka kekekngaapa kayuk yuwawa Buyambam tapata kekekngana atasiwan maikut. Unzingge nata kayuu mamaya yutnanga dua. Ita natane tapduknga dapaknga takepbut. ");
INSERT INTO wnc_vpl VALUES ("PS102_24","020_102_24","PSA","102","24","24","Dapaknga takepan kake nata anzing inikum, “Anutuna, ga asinggan asinggan yuayak. Gata apmanu na ma tapim. Na aminuake dua. Na kekekngaapa yuat. ");
INSERT INTO wnc_vpl VALUES ("PS102_25","020_102_25","PSA","102","25","25","Tupa siknga gata keu andaka tasike tekuyak. Siwan gikane katakga ena kakaa komune sanga bamu une yuaingu gika siknga pasike pekuyak. ");
INSERT INTO wnc_vpl VALUES ("PS102_26","020_102_26","PSA","102","26","26","Ena kakaa kopat kepat wena siknga asisan. Siwan ngana ga asinggan asinggan yuya. Sanga waapaau taukga bumi sikaing binga sisan. Siwan gata sanga waapaau kake aminda tauknga bumi siwa peke kayuk pasikaing binga gata sanga waapaau pasiwi gatukande sopuke gatu dua yutzan. ");
INSERT INTO wnc_vpl VALUES ("PS102_27","020_102_27","PSA","102","27","27","Sike ngana ga tendekga wena. Asinggan asinggan yuke gae tapduu wena dua siwik. ");
INSERT INTO wnc_vpl VALUES ("PS102_28","020_102_28","PSA","102","28","28","Unzingge gata nindane waatdakaninu kakuya pasiwawi take yutning. Yuke waakwakgane bapuna masan aatningu gata gatayami gaat waakwakat asinggan gatake yutning.” ");
INSERT INTO wnc_vpl VALUES ("PS103_1","020_103_1","PSA","103","1","1","Nata Buyambam tapatane umana asiknga yatangenawit. Ngan, nata gupmasan natdetdetnaatang gatu musipmaatang Buyambam tapatane umana take akngae asiknga yatangenawit. ");
INSERT INTO wnc_vpl VALUES ("PS103_2","020_103_2","PSA","103","2","2","Nata Buyambam tapatane umana asiknga yatangenawit. Yatangenake ita nae sanga takeaknga kwaapzang siknga tasingamukutde dua botawit. ");
INSERT INTO wnc_vpl VALUES ("PS103_3","020_103_3","PSA","103","3","3","Sike natane waina kuupbam ita gatu gatu asandekgaunin, gatu maitna kuupbam asinggan sandekngamunggak. ");
INSERT INTO wnc_vpl VALUES ("PS103_4","020_103_4","PSA","103","4","4","Nata sipdu sipdune kumnangge dapaknga sikum ngana Buyambam tapata na gatu tapan na dua kumbum. Ita musip kwikwik natangamuke nae butaya buyambam natangamunggaunin. ");
INSERT INTO wnc_vpl VALUES ("PS103_5","020_103_5","PSA","103","5","5","Na tapdukbamu keu andakane yuau, Buyambam tapata tendeknga wena sangabam nae naman takekan singgak. Ita unzing tasiwan na kekekngaapa gatuna dakngake yuat. Unzing tinggigi gwenda kekeknga yuak binga yuat. ");
INSERT INTO wnc_vpl VALUES ("PS103_6","020_103_6","PSA","103","6","6","Buyambam tapata noman taknga tawake aminu kunduta aminde meya aknga yaman pakingu akgatayamunggak. Gatayamuke gatu pangenawan take yuaing. ");
INSERT INTO wnc_vpl VALUES ("PS103_7","020_103_7","PSA","103","7","7","Sike tupa Anututa sanga kundu tasinangge natapbutde Moses inikut. Siwan ita puya kekeknga aknga aknga pasikuu Isrel nanae yeuyamukut. ");
INSERT INTO wnc_vpl VALUES ("PS103_8","020_103_8","PSA","103","8","8","Buyambam tapata butayambam natanimuke musip kwikwiu asinggan natanimunggak. Sike musiptou zaat dua natanimuke ninde musip gwaang natanimunggayak. ");
INSERT INTO wnc_vpl VALUES ("PS103_9","020_103_9","PSA","103","9","9","Gatu ita temapan ninike ninde asinggan dua natanimunggak. Aho, itane musiptok takngan mamayambam dua yuak. ");
INSERT INTO wnc_vpl VALUES ("PS103_10","020_103_10","PSA","103","10","10","Sike ninda waiaknga tasikamangge buyana wai apananga. Siwan ngana waiaknga tasikamanggane buyana wai wa dua nimunggak. Ninda waiaknga kwaapzang tasikumang. Siwan meya yake buyambam atnimunanga ngana unzingu dua tasinggak. ");
INSERT INTO wnc_vpl VALUES ("PS103_11","020_103_11","PSA","103","11","11","Sike aminu ie akgwaukaingu waaminde musip gwaang siknga natayamunggak. Ita musip kwikwiu wa natayamunggau, buyambam siknga. Ena yekap gweneta kepdakane binga. ");
INSERT INTO wnc_vpl VALUES ("PS103_12","020_103_12","PSA","103","12","12","Sike gunzitda akonggak kopat apukunggak kopat wesim dua. Wa maa siknga. Ina unzakan, Anututa waiaknganinu sandetniman waiaknganinu maa siknga yuak. ");
INSERT INTO wnc_vpl VALUES ("PS103_13","020_103_13","PSA","103","13","13","Nanata waatdakanae butaya natayamunggak. Ina unzakan, Buyambam tapata ie gwaukaing aminde butaya natayamunggak. ");
INSERT INTO wnc_vpl VALUES ("PS103_14","020_103_14","PSA","103","14","14","Ita ninu keek pake tumukut. Unzingge ita nindenu keek ngangu atnataak. ");
INSERT INTO wnc_vpl VALUES ("PS103_15","020_103_15","PSA","103","15","15","Sike ninu amindane kayuk yutnanga aknganinu dapaknga siknga zonga zongata yuaing binga. Ninu zonga zongatane palawa gwenduta binga dapaknga yuke akumnim. ");
INSERT INTO wnc_vpl VALUES ("PS103_16","020_103_16","PSA","103","16","16","Got takngata puyake saasaa tasiwan palawa gwenu apimapan aminda ayuak kopatangu wena kaaing. ");
INSERT INTO wnc_vpl VALUES ("PS103_17","020_103_17","PSA","103","17","17","Siwan ngana Buyambam tapata musip kwikwiu aminu ie gepbiatang koyuaingge asinggan asinggan natayamunggak. Siwan ita sanga noman taknga bapuna gatu bapunatane waaknga ngang masan aatningge kuut tasiyamik. ");
INSERT INTO wnc_vpl VALUES ("PS103_18","020_103_18","PSA","103","18","18","Sike waaminda Buyambam tapatane pasap wam gatu mama wamna kuutgan tawambanu, ayok, musip kwikwiu aminu waaminde asinggan asinggan natayamunggak. ");
INSERT INTO wnc_vpl VALUES ("PS103_19","020_103_19","PSA","103","19","19","Buyambam tapata king kapa yekaune yuak. Sike i sanga kuupbamdane toiknga unin. ");
INSERT INTO wnc_vpl VALUES ("PS103_20","020_103_20","PSA","103","20","20","Sike ginu Buyambam tapatane angelana kuupbam, ginu kekekngasa buyambam. Ginu itane wam tawakaingunin. Tawake itane wamde maak gwaang pakaing. Unzingge ginda Buyambam tapatane umana yatangenatnong. ");
INSERT INTO wnc_vpl VALUES ("PS103_21","020_103_21","PSA","103","21","21","Ginu Buyambam tapatane puya amina, ginu yekaune yuke ita nataak kaknga tawakaing. Ge ginda itane umana yatangenatnong. ");
INSERT INTO wnc_vpl VALUES ("PS103_22","020_103_22","PSA","103","22","22","Ginu sangabamu Buyambam tapata pasikuu, kepna kepna yuaing. Siwan ina siknga gindane King kapa yuak. Buyambam tapatane umana yatangenatnong. Siwan na kaya itane umana asiknga yatangenawit. ");
INSERT INTO wnc_vpl VALUES ("PS104_1","020_104_1","PSA","104","1","1","Nata Buyambam tapatane umana asiknga yatangenawit. Anutu, Buyambam tapana, ga enane siknga. Ga Kingu tupan tapa siwan umanda kopsa. ");
INSERT INTO wnc_vpl VALUES ("PS104_2","020_104_2","PSA","104","2","2","Gata gikane kakaa akngata usukwatapmanggayak. Unzing aminda gupnaapa taukga usukwatapmanggak binga. Gata yekap gwekat gatu yekap daau kuupbam ngang pewi yuaing. Unzing aminda sel yot gwenu mitake nau baklain takngata wapan yuak binga. ");
INSERT INTO wnc_vpl VALUES ("PS104_3","020_104_3","PSA","104","3","3","Sike gikane yotda yangga enandang yekaune yuak komune engatangan mitapbuyak gwene yuayak. Siwan minga musa gatane karisnda binga, got takngata apu ganitakuunggak. ");
INSERT INTO wnc_vpl VALUES ("PS104_4","020_104_4","PSA","104","4","4","Gata tasiwi got takngata gikane wam taknga takuunggak. Siwan gata tasiwi katap mumuyangga puya amina binga dakngakaing. ");
INSERT INTO wnc_vpl VALUES ("PS104_5","020_104_5","PSA","104","5","5","Sike gata keu andaka tangine tekuyak. Tewi kepdaka kekeknga siknga yuak. Ita kundusimu isakunanga dua. Wena siknga. ");
INSERT INTO wnc_vpl VALUES ("PS104_6","020_104_6","PSA","104","6","6","Gata yanggabam gwenu tewi yuke kepdaka tauk sandu bingata usukwatapbut. Siwan yanggata tawanu kuupbam usukwatapbut. ");
INSERT INTO wnc_vpl VALUES ("PS104_7","020_104_7","PSA","104","7","7","Siwan ngana masande gata yanggabam gwende wamu kekeknga aknga yawi atdatakukut. Yanggabam gwenda nataawan gata apaa siknga yawi gatukande datakukut. ");
INSERT INTO wnc_vpl VALUES ("PS104_8","020_104_8","PSA","104","8","8","Datakuke yanggabam gwenda tawanu engatangan kokenga teke gapme gwendune pukukut. Siwan yangga wagwenu gapme waomune yuwikge yakuyakge apmanu waomune unzing yuak. ");
INSERT INTO wnc_vpl VALUES ("PS104_9","020_104_9","PSA","104","9","9","Gata tuwangu gwa tekuyakgengu yangga gwenda tuwangu wa tekuyau yatupnanga dua. Unzingge yangga wagwenda tawanu kuupbam gatu usukwatapnanga dua. ");
INSERT INTO wnc_vpl VALUES ("PS104_10","020_104_10","PSA","104","10","10","Sike ita tasiwan yangga kep ganang akoke tawan katangga zipmake gapme gwene pukukaing. Sike wa pukukaingu tawan dakandakata kaukaut yuwawa yangga waapa apata banakan noman pukukaing. ");
INSERT INTO wnc_vpl VALUES ("PS104_11","020_104_11","PSA","104","11","11","Siwan kaap zongu yangga waangane atangokaing. Sike dongki zong dakngake yuaingga tangopa guyakngi gatu dua kupiakaing. ");
INSERT INTO wnc_vpl VALUES ("PS104_12","020_104_12","PSA","104","12","12","Sike kwaitda yotna katau yangga kwaimune akopsa dakandakane mitakaing. Mitake katap kaingune yuke wamna yakaing. ");
INSERT INTO wnc_vpl VALUES ("PS104_13","020_104_13","PSA","104","13","13","Ga yotda enane nana gapmane yuke sopa tawan katang pewi epukaing. Epuwawa gata tasiwi buyana asaakgak. ");
INSERT INTO wnc_vpl VALUES ("PS104_14","020_104_14","PSA","104","14","14","Gata zonga zonga tasiwi akopa kau gwegwenda une naningge. Siwan sanga inata inata ninu aminda kwaikamang kaya, gata pasiwi enake buya aawan une pake nakamang. ");
INSERT INTO wnc_vpl VALUES ("PS104_15","020_104_15","PSA","104","15","15","Siwan ninda nau wain taknga kwaike yangga toknga aknga tangopnangge tasinim. Tangoke musipmin katang apbaknganim. Sike katau oliv dakatane buyana yangga aknga pake nomine pasina waenga siwik. Gatu ninda wit tapun kwaike poyau uneta pasike nana gupmin tapa gatanimik. ");
INSERT INTO wnc_vpl VALUES ("PS104_16","020_104_16","PSA","104","16","16","Sike sopata epanu katau Lebanon nana dakandaka yangga buyambam pakaing. Katap dakandaka wa Buyambam tapata ina kwaikut. ");
INSERT INTO wnc_vpl VALUES ("PS104_17","020_104_17","PSA","104","17","17","Siwan katau wa dakandakane kwaitda yotna une mitakaing. Siwan kwaiu kang gwengwenda yotna katau baka dakandakane mitakaing. ");
INSERT INTO wnc_vpl VALUES ("PS104_18","020_104_18","PSA","104","18","18","Sike tawanu mamaya dakandaka wa meme zong gwegwenda sukukaingunin. Siwan ngwasanda ena tawanu buyambam dakandakatane sup ganang katang kusopukaingunin. ");
INSERT INTO wnc_vpl VALUES ("PS104_19","020_104_19","PSA","104","19","19","Anututa yekap gwen tasike tekuu wa kakaa nimuke puya tapduu inata inata yeutnimunggak. Sike gunziu apukunggakgane tapduknga ina nataak. ");
INSERT INTO wnc_vpl VALUES ("PS104_20","020_104_20","PSA","104","20","20","Gata tasiwi zikaa daka singgak. Siwan zikaane kaap zongu sukukaing. ");
INSERT INTO wnc_vpl VALUES ("PS104_21","020_104_21","PSA","104","21","21","Sike laiondane mateknga kaap zongge yawake kumzang ainggamatakaing. Ita wa yakaingu kaapna gata yamiakge yakaing. ");
INSERT INTO wnc_vpl VALUES ("PS104_22","020_104_22","PSA","104","22","22","Gunzitda gwa akopanu ganangine gatu kuke pekaing. ");
INSERT INTO wnc_vpl VALUES ("PS104_23","020_104_23","PSA","104","23","23","Siwan aminu enake kuku puyana pasiwawa gunziu une pukunggak. ");
INSERT INTO wnc_vpl VALUES ("PS104_24","020_104_24","PSA","104","24","24","Buyambamtapa, gata sangabam pasikuyak. Ga natdetdetda bambande sanga wa kuupbam pasikuyak. Sangabamu wa pasikuyau keu andakane asiknga doke yuaing. ");
INSERT INTO wnc_vpl VALUES ("PS104_25","020_104_25","PSA","104","25","25","Sike yanggabam gwenu buyambam siknga. Siwan pis buyambam dakandaka gatu mateknga dakandakasimpat sanga kunduat undang yuaing. Ninda natdeke kendetnanga dua. ");
INSERT INTO wnc_vpl VALUES ("PS104_26","020_104_26","PSA","104","26","26","Siwan sip gwegwenda yanggaangan kungapukaing. Sike pis buyambam siknga daka tupa tasikuyau, iaya yanggabam gwekatang kungapuke paakoke tasinggak. ");
INSERT INTO wnc_vpl VALUES ("PS104_27","020_104_27","PSA","104","27","27","Sike sanga kuupbamda tomna nataaing kopatangu, gata nanamna yamiakge ganduyuaing. ");
INSERT INTO wnc_vpl VALUES ("PS104_28","020_104_28","PSA","104","28","28","Siwana nanamna une yami nakaing. Gatakan siknga yami nake musia doke yuaing. ");
INSERT INTO wnc_vpl VALUES ("PS104_29","020_104_29","PSA","104","29","29","Sike gata masa yaminu waakwau akgwaukaing. Itane waunga kaiwi kuwanu, akungwake kep gatu dakngakaing. ");
INSERT INTO wnc_vpl VALUES ("PS104_30","020_104_30","PSA","104","30","30","Sike gata waungga yaminu waakwau kayuk yuaing. Gata sangabamu pasikuyau pasiwi kayuk dakngake keu andakane yuaing. ");
INSERT INTO wnc_vpl VALUES ("PS104_31","020_104_31","PSA","104","31","31","Unzingge nata nataau Buyambam tapatane umana kopsa aknga asinggan asinggan yuwikge nataat. Siwana Buyambam tapata sangabamu pasike pekutde apbakngawikge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS104_32","020_104_32","PSA","104","32","32","Ita kepdaka kawanu kepdaka ayamukgak. Ita katakngata tawan dakandakane wasiwanu kupan taknga undangga enakaing. ");
INSERT INTO wnc_vpl VALUES ("PS104_33","020_104_33","PSA","104","33","33","Sike na tapduu kayuk yuat komune nata kap taknga aknga Buyambam tapae taiwit. Nata kap taknga aknga Anutunae taike umana yatangenake yusika kupit. ");
INSERT INTO wnc_vpl VALUES ("PS104_34","020_104_34","PSA","104","34","34","Nata nataau Anututa sanga musipmaatang natanggamatake ie apbakngawit takngae natapan take siwikge nata kap taike apbakngawit. ");
INSERT INTO wnc_vpl VALUES ("PS104_35","020_104_35","PSA","104","35","35","Nata nataau wai aminu kuupbamu kepdakane wena siningge nataat. Ngan, aminu waiaknga tasikaingu wena siknga siningge nataat. Sike nata Buyambam tapatane umana asiknga yatangenawit. Buyambam tapatane umana yatangenatnong. ");
INSERT INTO wnc_vpl VALUES ("PS105_1","020_105_1","PSA","105","1","1","Ginda Buyambam tapatane umana yake yanggamatake gaak wam ininong. Siwan ginda puya buyambamu ita tasikutde kepna kepna nana aminu kuupbam yanikapnong. ");
INSERT INTO wnc_vpl VALUES ("PS105_2","020_105_2","PSA","105","2","2","Ginda kau takngatui apbakngake taike itane umana yatangenatnong. Siwan ginda sanga gwaam gwaamu pasikut takngae yanikapnong. ");
INSERT INTO wnc_vpl VALUES ("PS105_3","020_105_3","PSA","105","3","3","Ginda apbakngake umana yatangenawa umana kopsa siwik. Sike Buyambam tapatane aminabamda apbaknganong. ");
INSERT INTO wnc_vpl VALUES ("PS105_4","020_105_4","PSA","105","4","4","Asingganu ginda Buyambam tapae wesim kuke gin papan kekekawan gatandamikge inikwaitnong. ");
INSERT INTO wnc_vpl VALUES ("PS105_5","020_105_5","PSA","105","5","5","Ginda puya kekeknga Buyambam tapata tasikutde gatu duya takngatu takngatu tasikutde natdetnong. Ita aminu katak kayuke toiknggakge ginda kuut natdetnong. ");
INSERT INTO wnc_vpl VALUES ("PS105_6","020_105_6","PSA","105","6","6","Ngan. Ginu Abrahamdane bapuna. Waapa Buyambam tapatane puya amina. Ginu Jekopdane donga, ginu Buyambam tapata inae natake yawan yuaing. ");
INSERT INTO wnc_vpl VALUES ("PS105_7","020_105_7","PSA","105","7","7","Sike Buyambamtapa, wa nindane Anutunin. Waapata aminu keu andakane nana kuupbam katak siknga kayuak. ");
INSERT INTO wnc_vpl VALUES ("PS105_8","020_105_8","PSA","105","8","8","Ita pasap wamu takngatu nikatde yawan asinggan yuwikge yakut. Siwan pasap wamu waakngae asinggan natayuwik. ");
INSERT INTO wnc_vpl VALUES ("PS105_9","020_105_9","PSA","105","9","9","Pasap waaknga tupa Abrahampat yawat yukut. Siwan ita pasap wamu waakngakan Aisakge ina yawan kekekakut saak Anututa ina tawanangge yakut. ");
INSERT INTO wnc_vpl VALUES ("PS105_10","020_105_10","PSA","105","10","10","Gatu wamu waakngakan Jekopde iniwan kekekakut. Waapa Isrel amindane bapuna, siwan pasap wamu wa yawan yukut taknga asinggan yuwik. ");
INSERT INTO wnc_vpl VALUES ("PS105_11","020_105_11","PSA","105","11","11","Buyambam tapata pasap wamu waakngae anzing yakut, “Nata Kenan kep komu gae gamit. Siwan keu wandaka gaat gatu gikane donggaatde yuwik.” ");
INSERT INTO wnc_vpl VALUES ("PS105_12","020_105_12","PSA","105","12","12","Tupa Isrel nana aminu dongu mateknga siknga. Pakapuyut amin dakngake yuking. Siakan, waaminda Kenan kep komune pakapuyuke dongu mateknga siknga yuking. ");
INSERT INTO wnc_vpl VALUES ("PS105_13","020_105_13","PSA","105","13","13","Sike waakwau kepnane dua wikake yuking. Keu komduneta komdune kukaking. Kingu tapatutane kep komune matekngasim yuke enak teke gatu kingu tapatutane kep komune kukaking. ");
INSERT INTO wnc_vpl VALUES ("PS105_14","020_105_14","PSA","105","14","14","Siwan ngana Buyambam tapata dua kapewan aminu kunduta pasiwan maiking. Wena. Ita akgatayamuke kingu kaanga yanikutde dua pasiwan maiking. ");
INSERT INTO wnc_vpl VALUES ("PS105_15","020_105_15","PSA","105","15","15","Sike ita kingu waakwau anzing yanikut, “Nata waaminu natane puya pasingamuningge yawa yuking. Ginda waaminde wai takngatu ma tasiwam. Siwan ginda gatu natane yakapsa amina kuut ma pasiwa maiwan. Ma siknga tasiwam.” ");
INSERT INTO wnc_vpl VALUES ("PS105_16","020_105_16","PSA","105","16","16","Buyambam tapata tasiwan nanamu kuupbam sopuwan tomda yuking. ");
INSERT INTO wnc_vpl VALUES ("PS105_17","020_105_17","PSA","105","17","17","Siwan masande Josepdane notnata katewa aminda Josep usiwa waamindane puya aminu moo tapatu dakngakut. Siakan, Buyambam tapata Josep initewan tupan kuke Isip kep komune paku yukut. ");
INSERT INTO wnc_vpl VALUES ("PS105_18","020_105_18","PSA","105","18","18","Waaminda sen taknga akngata kepi kekeknga wapa toknga isiking. Siwan gatu ainu buyambamu guyakngane mapapukukaingu gwendu wambing. ");
INSERT INTO wnc_vpl VALUES ("PS105_19","020_105_19","PSA","105","19","19","Ita meya takngatu takngatu unzing pake yuwawan wamu Buyambam tapata Josepde tupa yakuu buya aakut. ");
INSERT INTO wnc_vpl VALUES ("PS105_20","020_105_20","PSA","105","20","20","Siwana Joseu kaautde tewan yukuu Isipdane king kapata aminu tapatu initewan kuku sandekut. Sike kingu waapa aminbamdane tupan siknga apa. Sike ita Joseu kaautde yukuu tewan epuukut. ");
INSERT INTO wnc_vpl VALUES ("PS105_21","020_105_21","PSA","105","21","21","Siwan king kapata Joseu inane puya aminu tupan tapa dakngawikge yawan yukut. Yawan Josepda sanga kuupbam Kinggane you buyambam siknga gwekatang yuking kaknga kakuya tasikut. ");
INSERT INTO wnc_vpl VALUES ("PS105_22","020_105_22","PSA","105","22","22","Puya unzing tasike ita inane natdetdetnane kinggane puya gwapak amin yanindamukut. Yanindamuke ita aminu kundu king kapae natdetdet imuya takwaunin yanindamukut. ");
INSERT INTO wnc_vpl VALUES ("PS105_23","020_105_23","PSA","105","23","23","Siwan masana Isreldane donga Jekou paku Isip yuking. Ngan, Jekopda apuke pakapuyut amin dakngake keu waomune yukut. ");
INSERT INTO wnc_vpl VALUES ("PS105_24","020_105_24","PSA","105","24","24","Siwan masande Buyambam tapata inane aminabam gatayaman waatdakana kwaapzang aaking. Aawan kake iwanata yapbitnanga dua sikut. ");
INSERT INTO wnc_vpl VALUES ("PS105_25","020_105_25","PSA","105","25","25","Siwan ita tasiwan Isip nanata itane aminabamde asiknga bitaking. Bitake Isip nanata itane puya amina waakwau pasiwan mainingge kepie tawaking. ");
INSERT INTO wnc_vpl VALUES ("PS105_26","020_105_26","PSA","105","26","26","Siwan masande Buyambam tapata Moses, inane puya amina, gatu Aron, inae yawan yukut tapaat ngang yanipewan Isip kep komune kukumayak. ");
INSERT INTO wnc_vpl VALUES ("PS105_27","020_105_27","PSA","105","27","27","Sike waapaatda Anututane puya pasikumayak. Pasike duya takngatui Isip nanata kaningge keu waomune tasikumayak. ");
INSERT INTO wnc_vpl VALUES ("PS105_28","020_105_28","PSA","105","28","28","Tasiwawat Anututa zikaa aknga tewan apu kepna usukwatapbut. Dasingge, Isip nanata itane wamu ayamasandeking. ");
INSERT INTO wnc_vpl VALUES ("PS105_29","020_105_29","PSA","105","29","29","Waamindane yanggana kuupbam ita papan tekwamba dak sike pis kuupbam atzipa kumbing. ");
INSERT INTO wnc_vpl VALUES ("PS105_30","020_105_30","PSA","105","30","30","Sike gwakbamda kwaapzang sike kepna itakan tapan sopukut. Gatu kinggane yotna buyambam gwekatang kuut koke yuking. ");
INSERT INTO wnc_vpl VALUES ("PS105_31","020_105_31","PSA","105","31","31","Anututa yawan ingut moo gatu atnisikaing ngangga kwaapzang sike kepna kuupbam gatu yotna ngang tapa sopukut. ");
INSERT INTO wnc_vpl VALUES ("PS105_32","020_105_32","PSA","105","32","32","Sike ita sopa siknga dua kepnaatangu tasiwan takut. Ita tasiwan sopa zambum gatu yapasik ngang epan kaking. ");
INSERT INTO wnc_vpl VALUES ("PS105_33","020_105_33","PSA","105","33","33","Ita nau wain taknga aknga gatu katau baap dakandaka apasiwan maiyamuking. Siwan ita katapna keu waomune yuaingu asukgwisaangukut. ");
INSERT INTO wnc_vpl VALUES ("PS105_34","020_105_34","PSA","105","34","34","Sike ita wamban yawan apmakga apbing. Datdasingga apbingu natdetnanga dua. Siwan aminda kendetnanga dua. ");
INSERT INTO wnc_vpl VALUES ("PS105_35","020_105_35","PSA","105","35","35","Apmau waakwakga sanga kuupbamdane tatakngi atnaking. Siwan nanamzau Isip nanata kwaikingu kuupbam atnaking. ");
INSERT INTO wnc_vpl VALUES ("PS105_36","020_105_36","PSA","105","36","36","Siwan Anututa Isip nanatane waaknga tupan tapaapa dongu inandek inandekgane atzipa kumbing. ");
INSERT INTO wnc_vpl VALUES ("PS105_37","020_105_37","PSA","105","37","37","Siwan masande ita Isrel nana yanipake kuwan Isip kep komu teke kuking. Waaminda sikasika keu waomune nanata silwa ba gol ngang pasikingunin yaman pake kuking. Kuke Isrel nana kuupbam takekan yuking. Aminu tapatu meya dua pake pimanggut. ");
INSERT INTO wnc_vpl VALUES ("PS105_38","020_105_38","PSA","105","38","38","Sike Isip nanatanu Isrel nana aminde akgwauking. Unzingge Isrel nana kaawan gwa kuwanu asiknga bakngaking. ");
INSERT INTO wnc_vpl VALUES ("PS105_39","020_105_39","PSA","105","39","39","Anututa Isrel nana amin kayutnangge natake minga musatu engatangan yawan yuke aminabam usukwatapbut. Siwan zikaane katau buyambam gwen tewan yuke isikakaa yamukut. ");
INSERT INTO wnc_vpl VALUES ("PS105_40","020_105_40","PSA","105","40","40","Siwan masande waaminda nanam yamikge iniwan ita kwait pewan apa naking. Gatu ita poyak yekaune nana ie yamukut. Yaman napa musia atdopbing. ");
INSERT INTO wnc_vpl VALUES ("PS105_41","020_105_41","PSA","105","41","41","Siwana ita tasiwan suu buyambam dakaatangga yangga epbut. Yangga buyambam waanga pimake zipmake sangana wena kepban komune kukut. Unzing yangga buyambamu tapatu zongangaatangga zipmake pukunggak binga. ");
INSERT INTO wnc_vpl VALUES ("PS105_42","020_105_42","PSA","105","42","42","Siakan. Ita wamu takngatu tupa puya amin tapana Abrahamde kekeknga yawan kekekakut takngae natanggamatake sanga wa kuupbam tasikut. ");
INSERT INTO wnc_vpl VALUES ("PS105_43","020_105_43","PSA","105","43","43","Ngan, aminabamu ita yanipake kukut. Kuke apbakngake taitake kuking. Sike waaminu inae gwa yawan yukingge asainggamatake apbakngayuuk kepi kuking. ");
INSERT INTO wnc_vpl VALUES ("PS105_44","020_105_44","PSA","105","44","44","Siwan ita dongu kundune nana amindane kepna waaminde yamukut. Yamuke ita kapewan puya anga angana kuut paking. ");
INSERT INTO wnc_vpl VALUES ("PS105_45","020_105_45","PSA","105","45","45","Sike ita Isrel nana aminde wa tasikuu, ita ie wamu kuupbam tawake mama wampaa kuupbam tawaningge natake tasikut. Unzingge Buyambam tapatane umana yatangenatnong. ");
INSERT INTO wnc_vpl VALUES ("PS106_1","020_106_1","PSA","106","1","1","Buyambam tapatane umana yatangenatnong. Buyambam tapata sanga takekan tasinggak kakngae natake ginda ie gaak wam inimbaknganong. Dasingge, ita ginde gwangau asinggan asinggan natandamunggak. ");
INSERT INTO wnc_vpl VALUES ("PS106_2","020_106_2","PSA","106","2","2","Mamin amin tapata sanga kekekngata pasikutde wamu yawik? Aminu tapatuta sanga waaknga kuupbamde yananga dua. Ngan, mamin amin tapata sanga kuupbamu ita takeaknga aknga pasinggak kaknga yanikapan natake umana yatangenawik? Sanga wa kuupbamde natdeke yananga dua. ");
INSERT INTO wnc_vpl VALUES ("PS106_3","020_106_3","PSA","106","3","3","Sike aminu itane wamu usanzike kepi noma nomana tawake asinggan asinggan noman takngakan tasiningu, waakwakga apbaknganong. ");
INSERT INTO wnc_vpl VALUES ("PS106_4","020_106_4","PSA","106","4","4","Buyambamtapa, gata amin gikane akgatayamunggayak tapduk gwekatangu naatdeat kuut natapso. Natake apapiak gwekatangu naat kuut papso. ");
INSERT INTO wnc_vpl VALUES ("PS106_5","020_106_5","PSA","106","5","5","Papi gatane amindabamu take siknga yutningge nataat. Yuke aminu waakwau sanga take akekan pawawa kake naat waaminkat baknganim. Natake naat aminu gatane dongga dakngake yuaingkat baknganim. ");
INSERT INTO wnc_vpl VALUES ("PS106_6","020_106_6","PSA","106","6","6","Sike ninda waiaknga gwa tasikumang. Unzing tupa bapuninda tasiking binga. Siakande siknga. Ninda wai tasikumang. ");
INSERT INTO wnc_vpl VALUES ("PS106_7","020_106_7","PSA","106","7","7","Nindane bapuninu Isip yuking kopatangu gata duya buyambamu pasikuyakge dua natdeking. Aho, gata tapdukbam gatayamuke waaminde musip gwaang siknga natayamukuyak kaknga atnatapbing. Ngana waakngae apbotaking. Apbotake yangga Ret Si gwende kwaimune kundoke gae yamandet siking. ");
INSERT INTO wnc_vpl VALUES ("PS106_8","020_106_8","PSA","106","8","8","Siwan ngana Buyambam tapata kekekngana buyambam taknga yeuyamunangge natapbut. Unzingge wamu ina yawan kekekakut takngae natake ita gatuna papan meya dua paking. ");
INSERT INTO wnc_vpl VALUES ("PS106_9","020_106_9","PSA","106","9","9","Ita wamu kekeknga yanggabamu Ret Si gwende iniwan apmatawan kaut kaut kuwat kepibam tapa dakngakut. Unzing siwan ita amin yanipake kuwan yangga zipbuke aminda akuyaapane binga kuking. ");
INSERT INTO wnc_vpl VALUES ("PS106_10","020_106_10","PSA","106","10","10","Yanipake kuke ita iwana aminde kataune sandeke pakut. Sandeke papan iwanata dua pasiwan maiking. ");
INSERT INTO wnc_vpl VALUES ("PS106_11","020_106_11","PSA","106","11","11","Siwan yangga gwenda iwana usukwatapan akumbing. Aminu tapatu kayuu dua yukut. ");
INSERT INTO wnc_vpl VALUES ("PS106_12","020_106_12","PSA","106","12","12","Buyambam tapata unzing tasiwan inane aminabamda pasap wamu yawan kekekakut takngae banip siking. Banip sike kap taike umana yatangenaking. ");
INSERT INTO wnc_vpl VALUES ("PS106_13","020_106_13","PSA","106","13","13","Siwan ngana zeetgaman waaminda sanga Buyambam tapata tasikutde apbotaking. Sike Anututane wam gamok dua take natdeking. Aho. Waaminda sanga inae natdetdeu nekan natake tasiking. ");
INSERT INTO wnc_vpl VALUES ("PS106_14","020_106_14","PSA","106","14","14","Sike keu sangana wena kopatangu musipnaatangu nanamu inata kundue kekeknga siknga natapbing. Natake Anutu tanziking. ");
INSERT INTO wnc_vpl VALUES ("PS106_15","020_106_15","PSA","106","15","15","Waaminda Anutu inikaiwa sanga waapa ayamukut. Siwan ngana maiu buyambam taknga kuut yamukut. ");
INSERT INTO wnc_vpl VALUES ("PS106_16","020_106_16","PSA","106","16","16","Sike keu sangana wena komune yuke aminu kunduta Moseskat Aronkatde musiane atemna natayamuking. Aminu waapaau Buyambam tapatane puya amina. ");
INSERT INTO wnc_vpl VALUES ("PS106_17","020_106_17","PSA","106","17","17","Siwana gapma buyambam daka kwamake pukuwan une Datan gatu Ambiram gatu itane donga ngang gapmaatang pukuwan apu bupmakusike waakwau usukwatapbut. ");
INSERT INTO wnc_vpl VALUES ("PS106_18","020_106_18","PSA","106","18","18","Siwan katau enandangga epuke wai aminu waakwau yawakingu ayasiwan kumbing. ");
INSERT INTO wnc_vpl VALUES ("PS106_19","020_106_19","PSA","106","19","19","Siwan waaminu tawanu Horeb dakane yuke ikwawa gamande wee gwendu golda tasiking. Tasike anutu pupukngana waapae munu puking. ");
INSERT INTO wnc_vpl VALUES ("PS106_20","020_106_20","PSA","106","20","20","Sike waakwakga wee wa ikwawa gamanu zonga zonga nanggakgane tasike ie munu puking. Waaknga tasike Anututane umana kopsa aknga yaitakepu teke ie munu dua puking. ");
INSERT INTO wnc_vpl VALUES ("PS106_21","020_106_21","PSA","106","21","21","Anututa puya kekeknga siknga Isip kep komune tasikut. Tasike ita Isrel nana aminu Isip nana aminde kataune sandeke pakut. ");
INSERT INTO wnc_vpl VALUES ("PS106_22","020_106_22","PSA","106","22","22","Ngan, Anututa puya buyambam siknga Isip komune pasikut. Ngan, ita duya takngatu takngatu dongu Ham nana amindane kep komune tasikut. Pasike yanggabamu Ret Si gwene sanga inata siknga tasikut. Tasiwan aminu kuupbamda kasatnaking. Siwan ngana Isrel nana aminda ie apbotaking. ");
INSERT INTO wnc_vpl VALUES ("PS106_23","020_106_23","PSA","106","23","23","Siwana Anututa inane aminabamu apasiwan mainingge yakut. Yawan ngana Moses, puya aminu Anututa ina yawan yukut tapata Anutue kaine yukut. Yuke Isrel nana gatayamuke Anututane musiptok kaknga asumukut. Siwan Anututa dua pasiwan maiking. ");
INSERT INTO wnc_vpl VALUES ("PS106_24","020_106_24","PSA","106","24","24","Sike keu take komu yamukutde apbitaking. Dasingge, Anututa wamu takngatu yawan kekekakutde siakan ngang dua natapbing. ");
INSERT INTO wnc_vpl VALUES ("PS106_25","020_106_25","PSA","106","25","25","Aminu waakwau sel yotnane yuyuk Anutue musiaatang kaanga natake wam yaking. Yake Buyambam tapatane wamu dua gwaamuking. ");
INSERT INTO wnc_vpl VALUES ("PS106_26","020_106_26","PSA","106","26","26","Siwana Anututa wamu kekeknga aknga yaniwan kekekakut. Yanike ita waaminu keu sangana wena supban komune kumningge yanikut. ");
INSERT INTO wnc_vpl VALUES ("PS106_27","020_106_27","PSA","106","27","27","Yake bapuna masan aatningu ayanikwasinangge yakut. Yanikwasiwan paku dongu takngatue banakan yutning. Yuke waomune aminde keune kumningge yawan kekekakut. ");
INSERT INTO wnc_vpl VALUES ("PS106_28","020_106_28","PSA","106","28","28","Masande waomune yuke Peor yot gapmane anutu pupuknga Bal ngang inia apae munu puking. Munu puke anutu pupuknga kayuk dua yutnangae ofa yamukingu atnaking. ");
INSERT INTO wnc_vpl VALUES ("PS106_29","020_106_29","PSA","106","29","29","Sanga waaknga tasiwa Buyambamtapa kaanga natapbut. Natake tasiwan maiu buyambam wai takngatu waaminde apbut. ");
INSERT INTO wnc_vpl VALUES ("PS106_30","020_106_30","PSA","106","30","30","Apan ngana Finiasda enake waiaknga tasiking aminu kaanga yaniwan maiu buyambam waaknga wena sikut. ");
INSERT INTO wnc_vpl VALUES ("PS106_31","020_106_31","PSA","106","31","31","Apmanu aomune ninda itane noman takngae natayuamang. Sike masan masan kaya, aminu kuupbamda atnatayutning. ");
INSERT INTO wnc_vpl VALUES ("PS106_32","020_106_32","PSA","106","32","32","Sike gatu Isrel nanata yangga Meriba apane yuke sanga wai tasiwan Anututa kake kaanga natapbut. Siwan gutonga wa tasiking kakngae Mosesda meya pakut. ");
INSERT INTO wnc_vpl VALUES ("PS106_33","020_106_33","PSA","106","33","33","Waaminda tasiwa kake Mosesda musiane wai siknga natake wamda dopan wamu noman dua yakut. ");
INSERT INTO wnc_vpl VALUES ("PS106_34","020_106_34","PSA","106","34","34","Sike waakwakga dongu komdu komdune nana katum aminu Buyambam tapata atzipan kumningge yakut ngana dua zipa kumbing. ");
INSERT INTO wnc_vpl VALUES ("PS106_35","020_106_35","PSA","106","35","35","Dua zipa kupa Isrel nanata waamindane maya kundu maatnae paking. Papa maya wa pakingga apna yanipakuwa waiakngana tawakaingunin tawaking. ");
INSERT INTO wnc_vpl VALUES ("PS106_36","020_106_36","PSA","106","36","36","Siwan waaminda gatu anutu pupuknganae mun puking. Siwan munu wa puking kakngata waaminu panggaganuwan wai siking. ");
INSERT INTO wnc_vpl VALUES ("PS106_37","020_106_37","PSA","106","37","37","Waakwakga waaknga gatu yapana ngang anutu pupuknganae ofa binga yamunangge natake zipa kumbing. ");
INSERT INTO wnc_vpl VALUES ("PS106_38","020_106_38","PSA","106","38","38","Sike wa tasikingu inane waaknga siknga ba yapana siknga zipbing. Sike waatdakana wa gutonga takngatu dua tasiking. Siwan ngana zipa kupan Kenandane anutu pupuknganae yamuking. Siwan itane dakngata tasiwan kepdaka Anutue kaine wai sikut. ");
INSERT INTO wnc_vpl VALUES ("PS106_39","020_106_39","PSA","106","39","39","Sike gutonga ina wa tasiking takngata tasiwan waakwau Anutue kaine wai siking. Sike Anutue masa imuke waaminda dua tawaking. ");
INSERT INTO wnc_vpl VALUES ("PS106_40","020_106_40","PSA","106","40","40","Siwan Buyambam tapata aminu inane waakwakge kaanga siknga natayamukut. Natayamuke inane amina ngana ie musia meya siknga natayamukut. ");
INSERT INTO wnc_vpl VALUES ("PS106_41","020_106_41","PSA","106","41","41","Meya natayamuke ita akapewan dongu kunduta yapbike kakuya pasiking. Unzingge iwanae gepbiatang koyuke ie kataune yuking. ");
INSERT INTO wnc_vpl VALUES ("PS106_42","020_106_42","PSA","106","42","42","Siwan iwanata meya waaminde kwaapzang yamuking. Yaman waaminde gepbiatang kekeknga siknga yuking. ");
INSERT INTO wnc_vpl VALUES ("PS106_43","020_106_43","PSA","106","43","43","Ngana tapduk gwendu gwendu Buyambam tapata inane aminabamu akgatayamukut. Siwan ngana inae banip tawake yamandet siyuuk ie wamu ayamasandeking. Waiaknga kwaapzang tasikingge take dua yuking. ");
INSERT INTO wnc_vpl VALUES ("PS106_44","020_106_44","PSA","106","44","44","Siwan ngana Buyambam tapae tumuk wam yawanu tumuk wamnae maau apakut. Maau pake meya buyambam pake yukingge butaya natayamukut. ");
INSERT INTO wnc_vpl VALUES ("PS106_45","020_106_45","PSA","106","45","45","Ita butaya siknga natayamuke pasap wamu tupa yaniwan kekekakutde gatuna natapan sikut. Siwan musia tapatekngwamban musip kwikwik natayamuke natdetdet naatangu meya wa asinggan paningge apbitakut. ");
INSERT INTO wnc_vpl VALUES ("PS106_46","020_106_46","PSA","106","46","46","Ita iwanatane natdetdetna pangenawan Isrel nana panggaganuwa yuking aminde butaya natayamuking. ");
INSERT INTO wnc_vpl VALUES ("PS106_47","020_106_47","PSA","106","47","47","Siwan Anutu, nindane Buyambam tapanin, gata ninu dongu kundue kataune yuamangge asiknga sandeke papso. Sandeke pake unekan nipmake nisane kepmine gatu ninipakapso. Unzing tasiwina ninda gatane umanda kopsa akngae natake gaak wam ganinim. Unzingge ninda apbakngake umanda yatangenatnim. ");
INSERT INTO wnc_vpl VALUES ("PS106_48","020_106_48","PSA","106","48","48","Ninda Anututane umana yatangenatna. Ninu Isrel amindane Buyambam tapanin, apman gatu masan kaya asinggan asinggan yuwik. Siwan aminu kuupbamda anzing yanong, “Un siakan.” Buyambam tapatane umana yatangenatnong. ");
INSERT INTO wnc_vpl VALUES ("PS107_1","020_107_1","PSA","107","1","1","Ninda Buyambam tapae gaau asiknga ininim. Dasingge, waapa take sikngaapa. Asinggan asinggan ninde butaya siknga natanimunggak. ");
INSERT INTO wnc_vpl VALUES ("PS107_2","020_107_2","PSA","107","2","2","Ginu aminu kuupbam, Buyambam tapata ginu iwanzae kataune sandeke pakut. Unzingge ginda Buyambam tapatane umana yatangenatnong. ");
INSERT INTO wnc_vpl VALUES ("PS107_3","020_107_3","PSA","107","3","3","Ita ginu iwanza keu komduine pakuu gunzitda akonggaune nana gatu gunzitda pukunggaune nana gatu enagwak saak nana gatu amunggwak nana ngangu waamindane kataune sandeke pakut. ");
INSERT INTO wnc_vpl VALUES ("PS107_4","020_107_4","PSA","107","4","4","Sike kundu sangana wena kepban komune yumdekan kuke kepie tawaking. Tawake ngana kepi tapatu yotbam gapmane kunanga dua kaking. ");
INSERT INTO wnc_vpl VALUES ("PS107_5","020_107_5","PSA","107","5","5","Waakwau tomna siknga natake guyakngi yanggae kupiawan akumningge dapaknga siking. ");
INSERT INTO wnc_vpl VALUES ("PS107_6","020_107_6","PSA","107","6","6","Sike waakwau upeeke unzing yuyuuk Buyambam tapae yatawaking. Yatawamba natake ita take siknga aknga tasike gatayamuke meya kakingu asandeyamukut. ");
INSERT INTO wnc_vpl VALUES ("PS107_7","020_107_7","PSA","107","7","7","Ita kepi noman takngane yanipake kuwawan yotbamu gapmandune kundoke wanggapmane yuking. ");
INSERT INTO wnc_vpl VALUES ("PS107_8","020_107_8","PSA","107","8","8","Unzingge nata natapa waaminda Buyambam tapae gaak ininingge nataat. Asingganu ita butaya natayamuke duya takngatu takngatu aminu kuupbamde tasike gatayamukutde gaak ininingge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS107_9","020_107_9","PSA","107","9","9","Dasingge, ita aminu guyakngi kupiakaingu yangga yaman tangopa take singgak. Siwan ita nanambamu tomna nataaingge yaman napa musia akgitnakaing. ");
INSERT INTO wnc_vpl VALUES ("PS107_10","020_107_10","PSA","107","10","10","Sike aminu kundu kaautde pekingu paku zikaa siknga komduatang peking. Aminda sen taknga akngata wamayamuke paku kaautde peke meya buyambam yamuking. ");
INSERT INTO wnc_vpl VALUES ("PS107_11","020_107_11","PSA","107","11","11","Dasingge, waakwau Anutu kekekngana bamban tapatane wam takngae yamandet siking. Ngan, enane siknga yuak kapatane wamna yamasandeking. ");
INSERT INTO wnc_vpl VALUES ("PS107_12","020_107_12","PSA","107","12","12","Yamasandewawa ita puya kekeknga siknga yamuwawan musiaatangu meyambam natapbing. Meyambamu wa natapbing kakngata zipan pimapa aminu gatayamunanga wena sikut. ");
INSERT INTO wnc_vpl VALUES ("PS107_13","020_107_13","PSA","107","13","13","Sike waakwau unzing upeeke yuyuuk Buyambam tapae yatawaking. Yatawamba natake ita take siknga aknga tasike gatayamuke meya kakingu sandeyamukut. ");
INSERT INTO wnc_vpl VALUES ("PS107_14","020_107_14","PSA","107","14","14","Sandeyamuke Buyambam tapata papan zikaa dakaatang yukingu ateke apbing. Siwan sen takngata wamayamukingu ita asandeyaman kaautde gatu dua yuking. ");
INSERT INTO wnc_vpl VALUES ("PS107_15","020_107_15","PSA","107","15","15","Unzingge nata natapa waaminda Buyambam tapae gaak ininingge nataat. Asingganu ita butaya natayamuke duya takngatu takngatu aminu kuupbamde tasike gatayamukutde gaak ininingge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS107_16","020_107_16","PSA","107","16","16","Dasingge, sanga kekeknga siknga bras ngang yania gwambok dakandaka aminda pasia, ita atzipbukut. Siwan damanu ainu kekeknga dakandakata pasia ngana awesiwan pukuking. ");
INSERT INTO wnc_vpl VALUES ("PS107_17","020_107_17","PSA","107","17","17","Siwan aminu kundu yamandet sike gena dua gwaamuke waiaknga tasikingge waakwau meya paking. ");
INSERT INTO wnc_vpl VALUES ("PS107_18","020_107_18","PSA","107","18","18","Pake nanam nananggengu apbitaking. Apbitake kumningge dapaknga sikut. ");
INSERT INTO wnc_vpl VALUES ("PS107_19","020_107_19","PSA","107","19","19","Sike waakwau unzing peeke yuyuuk Buyambam tapae yatawaking. Yatawamba natake ita take siknga aknga tasike gatayamuke meya kakingu sandeyamukut. ");
INSERT INTO wnc_vpl VALUES ("PS107_20","020_107_20","PSA","107","20","20","Sandeyamuke ita yake gupnaapa pasiwan take gatu siking. Unzing wa kupsa amin binga gatu pangenake pakut. ");
INSERT INTO wnc_vpl VALUES ("PS107_21","020_107_21","PSA","107","21","21","Unzingge nata natapa waaminda Buyambam tapae gaak ininingge nataat. Asingganu ita butaya natayamuke duya takngatu takngatu aminu kuupbamde tasike gatayamukutde gaak ininingge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS107_22","020_107_22","PSA","107","22","22","Siwan waaminda kau tainingu sanga Anutue imunanga aknga binga taike musip gwaangu puya buyambam pasikutde natake inimbaknganingge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS107_23","020_107_23","PSA","107","23","23","Siwan aminu kundu sipgwen tanggakgane kuyanae yuaingu yanggabam gwene kuke kepna kepna kuyuuk sanganambamban daknganangge aminbamde sanga paku yamuyuuk tasikaing. ");
INSERT INTO wnc_vpl VALUES ("PS107_24","020_107_24","PSA","107","24","24","Aminu waakwakga sanga Buyambam tapata tasikuu akaking. Waakwakga sanga inata kundu yanggabam gwene tasikuu akaking. ");
INSERT INTO wnc_vpl VALUES ("PS107_25","020_107_25","PSA","107","25","25","Dasingge, Buyambam tapata yawan gou buyambam puyapbut. Puyake tasiwan yanggabam gwenda sambui buyambam siknga enakut. ");
INSERT INTO wnc_vpl VALUES ("PS107_26","020_107_26","PSA","107","26","26","Unzing tasiwan sip gwegwenu enane siknga koke amunandang siknga pukuking. Unzing siwan sipdane kuyana yuaingu wai asinangge kamang ngang natake gwauya siknga natapbing. ");
INSERT INTO wnc_vpl VALUES ("PS107_27","020_107_27","PSA","107","27","27","Unzing natake sip tangan aminu yangga toknga aknga tangoke datdap takaingga binga datdap take sukuking. Sukuke sip gwenu gatangamunangge takngatu natapnanga dua sikut. ");
INSERT INTO wnc_vpl VALUES ("PS107_28","020_107_28","PSA","107","28","28","Sike waakwau unzing upeeke yuyuuk Buyambam tapae yatawaking. Yatawamba natake ita take siknga aknga tasike gatayamuke meya wa kakingu sandeyamukut. ");
INSERT INTO wnc_vpl VALUES ("PS107_29","020_107_29","PSA","107","29","29","Ita tasiwan got taknga atzakngawan, yangga gwenu kuma yukut. ");
INSERT INTO wnc_vpl VALUES ("PS107_30","020_107_30","PSA","107","30","30","Sike waaminda kawanu yangga gwenu kuma yuwan kake waakwau asiknga bakngaking. Siwan Buyambam tapata yot gapma yangga kwaimune kunangge natapbing gwene yanipake kukut. ");
INSERT INTO wnc_vpl VALUES ("PS107_31","020_107_31","PSA","107","31","31","Unzingge nata nataau waaminda Buyambam tapae gaak ininingge nataat. Asingganu ita butaya natayamuke ita duya takngatu takngatu aminu kuupbamde tasike gatayamukutde gaak ininingge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS107_32","020_107_32","PSA","107","32","32","Sike waaminda Anututane aminabampat unekan yukengu itane umana kopsa akngae ayakapningge nataat. Waaminkat gatu gwapakngi aminkat unekan yuke waaminda itane umana yatangenatningge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS107_33","020_107_33","PSA","107","33","33","Sike Buyambam tapatanu yangga buyambam tapaapa pasiwan atzakngaking. Siwan ita yawan yangga keu andakane yuaingu wena siking. ");
INSERT INTO wnc_vpl VALUES ("PS107_34","020_107_34","PSA","107","34","34","Ita tasiwan keu kaana kaya daka tapan tekwamban panga kaya daka sikut. Siwan sanga waomune dua akopning. Aminu keu waomune yuaingu waiaknga tasiwa Buyambam tapata meya waaknga waaminde yamukut. ");
INSERT INTO wnc_vpl VALUES ("PS107_35","020_107_35","PSA","107","35","35","Sike ita tasiwan yangga sanga wena kepban kopatangga akopbing. Akoke keu waomune zipmake kuking. ");
INSERT INTO wnc_vpl VALUES ("PS107_36","020_107_36","PSA","107","36","36","Siwana ita aminu nanamde atdapbing aminu yaniwan keu waomune yuke yotbam gapma mitake une yuking. ");
INSERT INTO wnc_vpl VALUES ("PS107_37","020_107_37","PSA","107","37","37","Waaminda keu waomune yuke nanam zak kwaike wain tapunu kuut kwaiking. Siwan uneta nanampat wainkat ngangu kwaapzang paking. ");
INSERT INTO wnc_vpl VALUES ("PS107_38","020_107_38","PSA","107","38","38","Buyambam tapata aminabamu take siknga pasiyamukut. Siwan ita tasiwan engangu kwaapzang aawawan ikwawa gamanu kwaapzang aaking. ");
INSERT INTO wnc_vpl VALUES ("PS107_39","020_107_39","PSA","107","39","39","Siwana aminu waakwau isapukuwan iwanata amak gwene yapbike asiknga yaipakepuke toknga yaman wai sike meya natayuke maakaking. ");
INSERT INTO wnc_vpl VALUES ("PS107_40","020_107_40","PSA","107","40","40","Sike Buyambam tapata tupan aminu pasiwan umana wena sikaing kapanin. Ita pasiwan waaminda keu kepina wena kopatang yumdekan sukuking. ");
INSERT INTO wnc_vpl VALUES ("PS107_41","020_107_41","PSA","107","41","41","Siwan ngana aminu sangana wena wai yuaingu, ita akgatayaman meyana wena siwan itane waatdakana kwaapzang sipsip binga siking. ");
INSERT INTO wnc_vpl VALUES ("PS107_42","020_107_42","PSA","107","42","42","Siwan noman aminda unzing kakengu musip gwaang nataaing. Siwan ngana wai aminda kakengu wamu takngatu dua yaning. Aho, waaminu gena asumutning. ");
INSERT INTO wnc_vpl VALUES ("PS107_43","020_107_43","PSA","107","43","43","Ayok, aminu tapatu natdetdeu noman pake yuak kapata katak siknga sanga wa kuupbamde natapsok. Natake Buyambam tapata take siknga asinggan tasinimunggak kakngae natake yuyok. ");
INSERT INTO wnc_vpl VALUES ("PS108_1","020_108_1","PSA","108","1","1","Anutu, natane musipmaatangu nata gae baniu kekeknga singgat. Siwan nata apmanu kau kumzang taike umanda yatangenawit. ");
INSERT INTO wnc_vpl VALUES ("PS108_2","020_108_2","PSA","108","2","2","Nata gita gatu kulele tanguwit. Tanguwawa kwakawik. ");
INSERT INTO wnc_vpl VALUES ("PS108_3","020_108_3","PSA","108","3","3","Buyambam tapa, nata dongu kundune nana banakan yuke gaak ganinangge nataat. Ngan, nata gae natake aminbamde banakan yuke kap taiwit. ");
INSERT INTO wnc_vpl VALUES ("PS108_4","020_108_4","PSA","108","4","4","Dasingge, gata ninde take siknga natanimunggayak. Sike ninda kana gata take natanimunggaau waaknga ena yekap gwenekan singgak. Asingganu ga takekan gatanimunggayak. Sike ninda tapdukbamu gata ninde take tasinimunggayau waaknga kendetna ena yekaunekan siwik. ");
INSERT INTO wnc_vpl VALUES ("PS108_5","020_108_5","PSA","108","5","5","Anutu, nata nataau gatane umanda enane siknga yatangenatningge nataat. Ngan, gatane kekeknga buyambam siknga akngaka aminu kepna kepna yuaingge aanggaman yeuyami gatane umanda kopsa akngae natapning. ");
INSERT INTO wnc_vpl VALUES ("PS108_6","020_108_6","PSA","108","6","6","Gata ninde take siknga nataayak. Siwan ninu kekeknga akngakata gatanimuke papi takekan yutnim. ");
INSERT INTO wnc_vpl VALUES ("PS108_7","020_108_7","PSA","108","7","7","Sike Anututa yotna buyambam gwene yuke anzing yakut, “Nata amak kaknga gwa yapbike apbaknganggat. Apbakngake nata Sekem kep komune nana amindane kepna gatu gapme Sukot kep komune yuak gwen ngangu ninane aminabamde usanzike yamit. ");
INSERT INTO wnc_vpl VALUES ("PS108_8","020_108_8","PSA","108","8","8","Keu Gileat kopkat gatu keu Manase kopkat wa natane. Sike keu Epraim komu amak amindane kupna kekeknga siknga binga nata gwapunggat. Siwan Juda kep komu kinggane gusoknga binga tanggat. ");
INSERT INTO wnc_vpl VALUES ("PS108_9","020_108_9","PSA","108","9","9","Siwan Moap kep komu dopangu nata yangga saikgat gwen binga singgak. Sike aminu tapatu keu komdu inae tanangge natake kepi tauknga waomune mumban kunggak kaknga tawake Idom kep komune nata kepi tauknga mumba kunggak. Sike nata Filistia kep komune amak tasike waakwak yapbike nata apbakngake aibakngawit.” ");
INSERT INTO wnc_vpl VALUES ("PS108_10","020_108_10","PSA","108","10","10","Anutu, mamin amin tapata yotbamu damanu kekeknga tasiya yot gapmaatang nanitake kuwik? Siwan mamin amin tapata Idomu nanitake kuwik? ");
INSERT INTO wnc_vpl VALUES ("PS108_11","020_108_11","PSA","108","11","11","Anutu, gata ninde masa gwa nimukuyak? Nimuke nindane amak amin ninu dua gatayamuya? Siwan ngana gata waomune nanitake kuya? ");
INSERT INTO wnc_vpl VALUES ("PS108_12","020_108_12","PSA","108","12","12","Gata nin gatanimi ninda iwaninkat amnim. Dasingge, amindane gatakgatak taknga sanga yumdekan siknga. ");
INSERT INTO wnc_vpl VALUES ("PS108_13","020_108_13","PSA","108","13","13","Sike Anututa akgatanimanu ninda amak tasike ayapbitnim. Ita ina siknga nindane iwaninu yaipakepik. ");
INSERT INTO wnc_vpl VALUES ("PS109_1","020_109_1","PSA","109","1","1","Anutu, nata gatane umanda ayatangenakgat. Gata kuma ma yuwim. ");
INSERT INTO wnc_vpl VALUES ("PS109_2","020_109_2","PSA","109","2","2","Dasingge, wai aminu kem yakaing aminda nae atsapdukaing. Sapduke nae iwana dakngake sapdut wam nanikaing. ");
INSERT INTO wnc_vpl VALUES ("PS109_3","020_109_3","PSA","109","3","3","Nae musiptok natake wamu wai siknga aknga moo yakaing. Wamu wa yakainggane yapiina wena. ");
INSERT INTO wnc_vpl VALUES ("PS109_4","020_109_4","PSA","109","4","4","Nata waaminde take natake gatayamiakge tumuk wam yanggat. Siwan ngana nae take dua nataaing. ");
INSERT INTO wnc_vpl VALUES ("PS109_5","020_109_5","PSA","109","5","5","Nata waaminde takeaknga tasiyama ngana yake waiaknga nae tasikaing. Nata waaminde take siknga natayamukum. Siwan ngana waaminda nae take dua nataaing. ");
INSERT INTO wnc_vpl VALUES ("PS109_6","020_109_6","PSA","109","6","6","Unzingge gata wai aminu tapatu katewi ita iwanatane wamu wam yot gwene usanziyok. Siwan inane iwana tapatuta wam yawikge takekuwik. ");
INSERT INTO wnc_vpl VALUES ("PS109_7","020_109_7","PSA","109","7","7","Sike wam yot gwene wam natapik kapata aminu waapa gutongana kaya ngang natake waapa initewan kaautde kuwik. Sike waapata tumuk wam yanggau waiaknga siwikge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS109_8","020_109_8","PSA","109","8","8","Siwan nata nataau tupan aminu waapa zeetgaman kupikge nataat. Kupan aminu tapatuta ie tangge tapikge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS109_9","020_109_9","PSA","109","9","9","Siwan aminu waapa akupan waaknga nana wena toitoit dakngawa mingata apna wena kombakombat dakngawikge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS109_10","020_109_10","PSA","109","10","10","Siwan waatdakana yotna bumi siwan datdai siknga yutningge nataat. Siwan aminda yanikwasiwa yotna wai wa gwenu yuaingu teke kuning. ");
INSERT INTO wnc_vpl VALUES ("PS109_11","020_109_11","PSA","109","11","11","Sike aminu waapa aminu tapatutane sanga kundu moo apba pakut. Pakutna kakengu aminu waaminde sangana moo imukut tapata apu kepnaat sangaapanaat kuupbam papikge nataat. Siwan aminu you gapmandune nana ita puya tasike sangabamu usike pekuu apu akaipakuningge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS109_12","020_109_12","PSA","109","12","12","Aminu tapatuta waapae musip kwikwiu dua natangamikge nataat. Itane waatdakana toitoit dakngakingge aminu tapatuta butaya natayamuningge dua nataat. ");
INSERT INTO wnc_vpl VALUES ("PS109_13","020_109_13","PSA","109","13","13","Nata waapatane waaknga asiknga kumningge nataat. Kupan aminu masan aatningga waapatane umanae dua natapning. ");
INSERT INTO wnc_vpl VALUES ("PS109_14","020_109_14","PSA","109","14","14","Buyambam tapata waiaknga itane bapunata tupa tasikingge natayuwikge nataat. Siwan ita mingatane waiakngana ma sandekngaman. ");
INSERT INTO wnc_vpl VALUES ("PS109_15","020_109_15","PSA","109","15","15","Buyambam tapata waakwakgane waiaknganae asinggan natayamik. Natayamuke tasiwan aminda itane dongae gatukande botaningge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS109_16","020_109_16","PSA","109","16","16","Dasingge, aminu waapata notnaapae musip kwikwiu dua natayamukut. Wena. Ita aminu sangana wena gatu sangaapae dapmakaing amin gatu meya pakaing aminde ngangu iwana dakngakut. Dakngake atzipan kumbing. ");
INSERT INTO wnc_vpl VALUES ("PS109_17","020_109_17","PSA","109","17","17","Ita tupa wamu waiaknga aminu kunduta meya paningge yakut. Siwan ngana ina meya papikge nataat. Sike ita Anutu inikwaiwan aminu kundu take gatayamikge dua natapbut. Unzingge, aminu waapa Anututane kwikwiknga aknga dua siknga papikge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS109_18","020_109_18","PSA","109","18","18","Tapdukbamu ita wamu yanggau aminu kunduta meya paningge yanggak. Siwan wamu waaknga tauknga pasinggak binga singgak. Siwan wamu waaknga inane gupna apaatang yanggata binga pukukut. Pukuke itane kwatai atang kaana akngata binga kukut. ");
INSERT INTO wnc_vpl VALUES ("PS109_19","020_109_19","PSA","109","19","19","Siwan wamu inane waakngata taukga usikwatanggak binga siwikge nataat. Siwan musipna simbu akngata wamanggak binga siwikge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS109_20","020_109_20","PSA","109","20","20","Unzingge Buyambam tapata aminu nae temapa nanikaingge meya yamikge nataat. Dasingge, wamu wai siknga waaknga nae nanikaing. ");
INSERT INTO wnc_vpl VALUES ("PS109_21","020_109_21","PSA","109","21","21","Siwan Anutu, Buyambam tapana, gata na gatangamiakge nataat. Unzing gika gwa yawi kekekakut saak. Gatane umanda takeaknga siwan gata nae butaya asinggan nataayak. Unzingge gata na asiknga tapso. ");
INSERT INTO wnc_vpl VALUES ("PS109_22","020_109_22","PSA","109","22","22","Dasingge, na sangana wena siknga yuke moo siknga yuat. Moo yuke natapa wai siknga singgak. ");
INSERT INTO wnc_vpl VALUES ("PS109_23","020_109_23","PSA","109","23","23","Na bangee gunzitda apukunangge siwawan weenata kunggak binga kunangge singgat. Na unzing gwakgwau got takngata apu puyatakunggak binga. ");
INSERT INTO wnc_vpl VALUES ("PS109_24","020_109_24","PSA","109","24","24","Sike nanam nanangge nina ayandakngawa muna kekekngana wena singgak. Na gupmaapa apatdewan kwatana gatukande atuyukaing. ");
INSERT INTO wnc_vpl VALUES ("PS109_25","020_109_25","PSA","109","25","25","Unzing siwa kake aminbamda nae atemapa nanikaing. Nanike waaminda gwapaknga makaiyuuk atnanimikaing. ");
INSERT INTO wnc_vpl VALUES ("PS109_26","020_109_26","PSA","109","26","26","Anutu, Buyambam tapana, gata nae butaya asinggan natangamunggayak. Natake gatangamuke gata na gatuka tapso. ");
INSERT INTO wnc_vpl VALUES ("PS109_27","020_109_27","PSA","109","27","27","Sike gata na take gatangaminu natane iwanata atnatdetningge yeuyamuyo. Yeuyami Anutu akgatangamunggak kapanin ngang natapning. ");
INSERT INTO wnc_vpl VALUES ("PS109_28","020_109_28","PSA","109","28","28","Waaminda “Anututa aminu waapa atasiwan maiyok,” ngangu apba yaning. Yawan ngana gata nae takekan tasiya. Gata aminu nae wai wa tasikaingu ayaipakepi maakanong. Siwan na gikane puya aminda, musip gwaang natapit. ");
INSERT INTO wnc_vpl VALUES ("PS109_29","020_109_29","PSA","109","29","29","Sike natane iwanata nae atemapa yakaingge maaknga buyambam paningge nataat. Maaknga waakngata aminu gatukande usikwatapik. Usikwatapan aminbamda maaknga waaknga natapningu aanggaman take kaning. ");
INSERT INTO wnc_vpl VALUES ("PS109_30","020_109_30","PSA","109","30","30","Siwan ngana nata asainggamatake Buyambamtapa gaak wam inimbakngawit. Sike aminbamu unekan yuke mun puke ininangge tasiwawa nakaya itane umana ayatangenawit. ");
INSERT INTO wnc_vpl VALUES ("PS109_31","020_109_31","PSA","109","31","31","Dasingge, ita sangana wena waamin gatayamuke kakuya pasinggak. Kakuya pasiwan aminda wam yot gwene yaningge dua yanipakoke akumningge wamu dua yaning. ");
INSERT INTO wnc_vpl VALUES ("PS110_1","020_110_1","PSA","110","1","1","Buyambam tapata natane tupan tapana anzing inikut, “Ga umanda kopsa apa, gata nae apu natane kataknga siaapane pukuyuwawi nata tasiwa gatane iwanda gae gepbiatang koyutning.” ");
INSERT INTO wnc_vpl VALUES ("PS110_2","020_110_2","PSA","110","2","2","Buyambam tapata tasiwan gata Saion yot gapmane yuke ga tasiwan yotgapma gapma kwaapzang kayuya. Siwan gata iwanda kuut kayuya. ");
INSERT INTO wnc_vpl VALUES ("PS110_3","020_110_3","PSA","110","3","3","Tapduu gata iwandaat amnangge natapinu, gikane aminda apuke gatanggamuke waaminda amakge masa wamu dua yaning. Siwan umana kopsa siknga akngane yuke waaminda kekeknga kayuk kaknga paning. Siwan kekeknga waaknga unzing, tapdukbamu gunzit dua akowawan sopa daiu yuak binga kekekngana gatu paning. Ina unzakan, gakaa kekeknga kayuu tapdukbamu asinggan papsa. ");
INSERT INTO wnc_vpl VALUES ("PS110_4","020_110_4","PSA","110","4","4","Buyambam tapata wamu takngatu gae anzing gwa yawan kekekakut, “Gata pris tapa asinggan asinggan yuya. Siwan ga Melkisedek binga apa dakngaya. Anututane puya pasikut tapa yukutna nataamang. Ge Buyambamtapa wamu siakan yake wamu ina yanggau dua sandekgak. Siwan wamna asinggan yuwik. ");
INSERT INTO wnc_vpl VALUES ("PS110_5","020_110_5","PSA","110","5","5","Buyambamtapa gaat yuke kekekanggamik. Tapduu ita musiptok natapik komune ita amau kingu komdu komdune nanaat amake ayapbike yaipapaakusike yainggamambik. ");
INSERT INTO wnc_vpl VALUES ("PS110_6","020_110_6","PSA","110","6","6","Ita kepna kepna nana aminu usanziwik. Usanzike gutonga aminda tasikingge yake meya yamik. Sike amak tasining komune aminu kwaapzang zipa kumning. Siwan ita gatu kingat kuut kepna kepna nana ayapbike yaipapaakusike yainggamambik. ");
INSERT INTO wnc_vpl VALUES ("PS110_7","020_110_7","PSA","110","7","7","Ita kepiapane kuke yangga wesim zipmanggak kapane tangopik. Tangoke ita kekeknga pake amau kekeknga tasike ayapbimbik.” ");
INSERT INTO wnc_vpl VALUES ("PS111_1","020_111_1","PSA","111","1","1","Buyambam tapatane umana yatangenatnong. Nata Buyambam tapae gwaam siknga natangamuke asiknga inimbakngawit. Ngan, aminu kepi noman takngane sukukaing aminu unekan gatake yutning komune yuke nata asinimbakngawit. ");
INSERT INTO wnc_vpl VALUES ("PS111_2","020_111_2","PSA","111","2","2","Buyambamtapa puyana take siknga pasinggak. Aminu puya Buyambam tapata pasinggakge take nataaing aminda puya wa ita pasinggak kakngae katak natake yutnong. ");
INSERT INTO wnc_vpl VALUES ("PS111_3","020_111_3","PSA","111","3","3","Siwan ita king kapa yuke sangabamu pasinggakga inane umana aknga yatangenawa take siknga singgak. Sike itane noman takngana asinggan asinggan yuwik. ");
INSERT INTO wnc_vpl VALUES ("PS111_4","020_111_4","PSA","111","4","4","Buyambam tapata amindane natdetdetna pangenawan waaminda noman taknga tasinggakge asinggan asinggan natayutning. Asinggan siknga Buyambam tapata ninde musip kwikwik natanimuke ninde butaya natayuak. ");
INSERT INTO wnc_vpl VALUES ("PS111_5","020_111_5","PSA","111","5","5","Natayuke ita nanamu asinggan aminu ie akgwaukaing aminde yamunggak. Ita wam taknga yaniwan kekekakut takngae asinggan asinggan natayuke ita dua siknga botanggak. ");
INSERT INTO wnc_vpl VALUES ("PS111_6","020_111_6","PSA","111","6","6","Ita aminu kundutane kepna inane aminde yamukut. Puya waaknga tasike inane kekeknga akngana waaminde yeuyamukut. ");
INSERT INTO wnc_vpl VALUES ("PS111_7","020_111_7","PSA","111","7","7","Ita sanga siakan gan tasike kepi noman gan tawake tasinggak. Tasike ita inane pasap wamda yanggak kaknga natake ninu ie banip sinanga. ");
INSERT INTO wnc_vpl VALUES ("PS111_8","020_111_8","PSA","111","8","8","Ita wamu wa yake tekuu noman siknga asinggan asinggan yuwik. Ngan, ita mama wamu wa yakut taknga asinggan yuwik. ");
INSERT INTO wnc_vpl VALUES ("PS111_9","020_111_9","PSA","111","9","9","Siwan ita aminu inae gwa pakuu akgatayamukut. Sike ita pasap wamu aminu waakwakge yaniwan kekekakut takngae natake yawan wamu waaknga asinggan asinggan yuwik. Unzingge itane umana kopsa akngae natake umana waaknga inata siknga ngang natake akgwauke ie gepbiatang koyuaing. ");
INSERT INTO wnc_vpl VALUES ("PS111_10","020_111_10","PSA","111","10","10","Sike aminu tapatuta natdetdet amin daknganangge natakengu waapata Buyambam tapae akgwaumsok. Sike wa akgwaukgak kakngata amindane musia pangenawan natdetdet amin dakngawik. Unzingge ninda itane umana asinggan asinggan yatangenatnim. ");
INSERT INTO wnc_vpl VALUES ("PS112_1","020_112_1","PSA","112","1","1","Buyambam tapatane umana yatangenatnong. Mamin aminu tapatuta Buyambam tapae akgwauke itane mama wam tawanangge take siknga natapiu Anututa take tasingamik. ");
INSERT INTO wnc_vpl VALUES ("PS112_2","020_112_2","PSA","112","2","2","Itane waatdakaa aminde kaine umana kaya dakngake yutning. Ngan, aminu waapa noman yuwiu Anututa waapatane donga take pasiyamik. ");
INSERT INTO wnc_vpl VALUES ("PS112_3","020_112_3","PSA","112","3","3","Siwan aminu waapatane dongu moni kwaapzang paning. Siwan aminu wa apatane kepi noman takngana asinggan asinggan yuwik. ");
INSERT INTO wnc_vpl VALUES ("PS112_4","020_112_4","PSA","112","4","4","Siwan aminu noman tapatanu aminde musip kwikwik gatu butaya ngang natayamuke kepi noman takngane sukunggak. Sukuke zikaa dakane ba kuwik. Kuwawan kakaa akngata apuke take aminu waapa akgatangamik. ");
INSERT INTO wnc_vpl VALUES ("PS112_5","020_112_5","PSA","112","5","5","Aminu tapatuta sangaapana dua kotnake aminu kundu kapewan itane sanga moo paning. Sike aminu waapae sanga take aknga ie asapik. Aminu kundutane wamna usanziwan noman siwik kapae. ");
INSERT INTO wnc_vpl VALUES ("PS112_6","020_112_6","PSA","112","6","6","Siwan amin nomanu waapa pimananga dua. Siwan aminda kake aminu waapae dua botaning. ");
INSERT INTO wnc_vpl VALUES ("PS112_7","020_112_7","PSA","112","7","7","Siwan ita meya takngatu zandangga aakgakge yawan natakengu dua gwaumbik. Aho, ita Buyambam tapae banip sike ie natapan kekekawik. ");
INSERT INTO wnc_vpl VALUES ("PS112_8","020_112_8","PSA","112","8","8","Natapan kekekawan ita musip kwikwik natayuke nangaakan dua natake gwauya dua natapik. Gwauya dua natake ita iwana yapbimban datakuwawa kawik. ");
INSERT INTO wnc_vpl VALUES ("PS112_9","020_112_9","PSA","112","9","9","Ita sangana wena aminde sanga kwaapzang yamunggak. Siwan noman takngana asinggan asinggan tasiwik. Tasiwan kake aminu kunduta umana kayaapa ngang natake umana yatangenatning. ");
INSERT INTO wnc_vpl VALUES ("PS112_10","020_112_10","PSA","112","10","10","Yatangenawawa ngana wai aminda kake musia meya natapning. Waaminda musipmaiu amin nomande nataaing, ngana ita masande atasingupeewik. Ngan, ita gen gakngat tasiwik. ");
INSERT INTO wnc_vpl VALUES ("PS113_1","020_113_1","PSA","113","1","1","Ginu Buyambam tapatane umana yatangenatnong. Ginu puya aminu Buyambam tapatane, itane umana yatangenatnong ");
INSERT INTO wnc_vpl VALUES ("PS113_2","020_113_2","PSA","113","2","2","Nata nataau Buyambam tapatane umanae apbaknganingge nataat. Apman gatu masande kuut natayutnong. ");
INSERT INTO wnc_vpl VALUES ("PS113_3","020_113_3","PSA","113","3","3","Gunzitda akonggauneta kuku gatu gunzitda pukunggaaune ginu aminu kuupbamda Buyambam tapatane umana asiknga yatangenatningge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS113_4","020_113_4","PSA","113","4","4","Buyambam tapata aminu kuupbam kakuya pasinggak. Umana kopsa akngnanata sanga yekaune yuaingu kuupbam ayapbikgak. ");
INSERT INTO wnc_vpl VALUES ("PS113_5","020_113_5","PSA","113","5","5","Aminu tapatu Anutu Buyambam tapanin binga wena. Waapa enane siknga yuke sanga kuupbam kayuak. ");
INSERT INTO wnc_vpl VALUES ("PS113_6","020_113_6","PSA","113","6","6","Sike enane siknga yuke ita yekap gatu kepat ngang unekan amunandang yuwawat pakepusang kaak. ");
INSERT INTO wnc_vpl VALUES ("PS113_7","020_113_7","PSA","113","7","7","Ita sangana wena amin gatayaman ita gatu dua tasingupeeke takekan yuaing. Ita sangae dapmakaing aminu waakwau katak gatayaman takekan pake yuaing. ");
INSERT INTO wnc_vpl VALUES ("PS113_8","020_113_8","PSA","113","8","8","Siwan ita waaminu pewan tupan tapae banakan yuke natapa umana kopsa siknga singgak. Siwan waamindane dongune tupan amin tapaapat yuaing. ");
INSERT INTO wnc_vpl VALUES ("PS113_9","020_113_9","PSA","113","9","9","Siwan ita maya waak songge yuaingu take pasinggak. Pasiwan maya waakwakga minga dakngake engangu kundu betake asiknga bakngakaing. Siakan. Buyambam tapatane umana yatangenatnong. ");
INSERT INTO wnc_vpl VALUES ("PS114_1","020_114_1","PSA","114","1","1","Tupa Isrel nana aminda Isip teke kuking. Ngan, Jekopdane dongga wamna inata yakinggane kep kom teke kuking. ");
INSERT INTO wnc_vpl VALUES ("PS114_2","020_114_2","PSA","114","2","2","Sike aminu Juda nana dongu Buyambam tapatane yot takwana binga dakngaking. Ngan, Isrel nana dongu Buyambam tapatane aminabam dakngawan Anututa kayukut. ");
INSERT INTO wnc_vpl VALUES ("PS114_3","020_114_3","PSA","114","3","3","Yangga Ret Si gwenu ita kawan asisakukut. Siwan yangga Jordan tapa kautdu kuma yuwan kautdu atzakngakut. ");
INSERT INTO wnc_vpl VALUES ("PS114_4","020_114_4","PSA","114","4","4","Sike Anututa natapan siwan tawanu buyambam dakandaka memeta binga paapaapbing. Siwan tawanu mateknga dakandakasimu sipsipda binga paapaapbing. ");
INSERT INTO wnc_vpl VALUES ("PS114_5","020_114_5","PSA","114","5","5","Ga yanggabam gwen, sanga minata aawan kake isakuyak? Sike yangga Jordan tapa, dasingge ga gatu dua zipbuyak? ");
INSERT INTO wnc_vpl VALUES ("PS114_6","020_114_6","PSA","114","6","6","Sike ginu tawanu buyambam dakandaka, dasingge ginu memeta binga paapbing? Siwan ginu mateknga dakandakasimu dasingge sipsipda binga paapbing? ");
INSERT INTO wnc_vpl VALUES ("PS114_7","020_114_7","PSA","114","7","7","Ga kepdaka, Buyambam tapata apanu ayamumso. Ngan, Jekopdane Anutunata gwa apanu ga ayamumso. ");
INSERT INTO wnc_vpl VALUES ("PS114_8","020_114_8","PSA","114","8","8","Sike ita tasiwan sup gwenu yangga gapan gwen dakngakut. Ngan, ita suu kekeknga siknga gwenu tasiwan yangga buyambam tanga zipbut. ");
INSERT INTO wnc_vpl VALUES ("PS115_1","020_115_1","PSA","115","1","1","Anutu, gata nindane umaninu ma yapangenawim. Gata ninde butaya siknga asinggan natanimuke gata ninu dua nipmanggayak. Unzingge ninda gatane umanda kopsa akngae natake gaekan yatangenatnim. ");
INSERT INTO wnc_vpl VALUES ("PS115_2","020_115_2","PSA","115","2","2","Dasingge dongu takngatuine nanata ninde anzingu ninikwaikaing, “Gindane Anutusa zandang yuak?” ");
INSERT INTO wnc_vpl VALUES ("PS115_3","020_115_3","PSA","115","3","3","Nisane Anutuninu yekaune yuak. Sike ita sanga takngatu tasinanggengu atasiwik gekan. ");
INSERT INTO wnc_vpl VALUES ("PS115_4","020_115_4","PSA","115","4","4","Sike ngana dongu waakngatane anutuna inata. Ngan, waamindane anutu pupukngana silwa gatu gol ngangga pasikaing. Waaminda katakngata pasikaing. ");
INSERT INTO wnc_vpl VALUES ("PS115_5","020_115_5","PSA","115","5","5","Waamindane anutu pupukngana gena kaya, siwan ngana wamu dua yakaing. Kaina kaya ngana dua kaaing. ");
INSERT INTO wnc_vpl VALUES ("PS115_6","020_115_6","PSA","115","6","6","Waakwau maaknga kaya ngana wamu dua nataaing. Gatu nomna kaya siwan ngana sanapuke kapanga natapnanga dua. ");
INSERT INTO wnc_vpl VALUES ("PS115_7","020_115_7","PSA","115","7","7","Gatu katakngi kaya siwan ngana sanga kundu pananga dua. Siwan kepi kuut kaya siwan ngana kepi kunanga dua. Siwan gatu wam gakngau guyakngaatang ba yake tasinanga dua. ");
INSERT INTO wnc_vpl VALUES ("PS115_8","020_115_8","PSA","115","8","8","Sike aminu anutu pupuknga wa pasikaing takwau anutu pupuknga ina pasikaing binga daknganing. Siwan aminu ie banip sikaingu wa bingakan daknganing. ");
INSERT INTO wnc_vpl VALUES ("PS115_9","020_115_9","PSA","115","9","9","Ginu Isrel nana amin, ginu baniu Buyambam tapaekan sinong. Ita ginu akgatandamuke danduyuak. ");
INSERT INTO wnc_vpl VALUES ("PS115_10","020_115_10","PSA","115","10","10","Ginu Arondane dongune yuaingu, ginu Buyambam tapaekan baniu sinong. Ita ginu akgatandamuke danduyuak. ");
INSERT INTO wnc_vpl VALUES ("PS115_11","020_115_11","PSA","115","11","11","Ginu aminu Buyambam tapaekan gwaukaingu, ginu ie banip sinong. Wa awiapatakan gatandamuke danduyuak. ");
INSERT INTO wnc_vpl VALUES ("PS115_12","020_115_12","PSA","115","12","12","Buyambam tapata ninde asinggan natayuak. Natayuke ninde take pasinimik. Ita Isreldane dongune nana take pasiwik. Ngan, Arondane dongune nana kuupbam take pasiwik. ");
INSERT INTO wnc_vpl VALUES ("PS115_13","020_115_13","PSA","115","13","13","Buyambam tapata aminu ie akgwaukaingu kuupbam take pasiwik. Unzing aminu umana kaya gatu umana wena kuutgan take pasiwik. ");
INSERT INTO wnc_vpl VALUES ("PS115_14","020_115_14","PSA","115","14","14","Sike nata nataau Buyambam tapata ginde gatu bapusa masan aatningge, waatdaka kwaapzang damikge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS115_15","020_115_15","PSA","115","15","15","Buyambamtapa yekapat kepkat pasikut tapa unin. Ita ginu take siknga pasiwikge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS115_16","020_115_16","PSA","115","16","16","Sike yekau enane siknga yuau wa Anututane kepna. Siwan ngana ita keu andaka ninu kepdakane nana aminde nimukut. ");
INSERT INTO wnc_vpl VALUES ("PS115_17","020_115_17","PSA","115","17","17","Sike aminu akungwakaingu wa yotnane kuke kuma siknga yutning. Siwan Buyambam tapatane umana dua yatangenatning. ");
INSERT INTO wnc_vpl VALUES ("PS115_18","020_115_18","PSA","115","18","18","Siwan ngana ninu ayuamangu, gaak kaknga Buyambam tapae apman gatu masan kaya asinggan asinggan inimbaknganim. Buyambam tapatane umana yatangenatnong. ");
INSERT INTO wnc_vpl VALUES ("PS116_1","020_116_1","PSA","116","1","1","Siakande siknga Buyambamtapa nata yanggat taknga atnatangamukut. Unzing tasinggakge nata ie take siknga nataat. Siakan siknga, nata tumuk wam yake ita butaya natangamikge iniwa ita atnatangamukut. ");
INSERT INTO wnc_vpl VALUES ("PS116_2","020_116_2","PSA","116","2","2","Ngan, natane tumuk wamu kuupbam ininggau atnatangamunggak. Unzingge nata kayuk yuwit komune asinggan ininggamatawit. ");
INSERT INTO wnc_vpl VALUES ("PS116_3","020_116_3","PSA","116","3","3","Sike tupa kungwak kakngata napda binga wamanapmanggut. Wamanapmamban natdetdetna tewa aminu gwa kumbingga yuaing komde kukut. Kuwan wa natapbum takngata tasiwan na kumzang siknga gwauke nangaakan natapbum. ");
INSERT INTO wnc_vpl VALUES ("PS116_4","020_116_4","PSA","116","4","4","Unzingge nata Buyambam tapae anzing inikum, “Buyambam tapa, nata gae yanggawanggatde gata na gatuka atapso. Na kupsat,” ngang inikum. ");
INSERT INTO wnc_vpl VALUES ("PS116_5","020_116_5","PSA","116","5","5","Buyambam tapata ninde musip kwikwik natake ninde take pasinggak. Anutuninu ninde butaya natanimunggak. ");
INSERT INTO wnc_vpl VALUES ("PS116_6","020_116_6","PSA","116","6","6","Buyambam tapata aminu kundu kekekake yutnanga dua aminu ita akgatayamunggak. Ina unzakan, tupa nata upeeke yuwawa na ita gatuna takut. ");
INSERT INTO wnc_vpl VALUES ("PS116_7","020_116_7","PSA","116","7","7","Ge apmanu nata musipma kwikwiknga natake yuwatakawikge nataat. Dasingge? Buyambam tapata na take siknga nanduyuak. ");
INSERT INTO wnc_vpl VALUES ("PS116_8","020_116_8","PSA","116","8","8","Dasingge? Buyambam tapa, gata na gatuka tapi nata dua kumbum. Ngan, gata natane kai yanggana pasiwi kuwa gata na nanduyuwi nata dua pimakum. ");
INSERT INTO wnc_vpl VALUES ("PS116_9","020_116_9","PSA","116","9","9","Unzingge nata aminu kayuk yuaingkat gatake sukunim. Siwan na Buyambam tapae kaine sukuwitde nanduyak. ");
INSERT INTO wnc_vpl VALUES ("PS116_10","020_116_10","PSA","116","10","10","Siwan nata banip sike anzing yakum, “Meya buyambam siknga akngata na usikwatapmanggak.” Unzing yakum ngana nata Anutue banip sikum. ");
INSERT INTO wnc_vpl VALUES ("PS116_11","020_116_11","PSA","116","11","11","Na usikwatapan akgwauke nata gatuna anzing yakum, Aminu kuupbamda kem wam asinggan yakaing. ");
INSERT INTO wnc_vpl VALUES ("PS116_12","020_116_12","PSA","116","12","12","Siwan Buyambam tapata nae take siknga tasinggak. Siwan ngana sanga nata yake ie mina binga imit? ");
INSERT INTO wnc_vpl VALUES ("PS116_13","020_116_13","PSA","116","13","13","Anututa na gwa takut takngae take siknga natake sanga waakngae yatangenawit. Buyambam tapata na gwa takutde gaak wam iniwit. ");
INSERT INTO wnc_vpl VALUES ("PS116_14","020_116_14","PSA","116","14","14","Sike tapduu itane aminabamda unekan pakapu yutning komune nata yawa kekekakut taknga atasining. ");
INSERT INTO wnc_vpl VALUES ("PS116_15","020_116_15","PSA","116","15","15","Siwan Anututane aminu tapatu akupan kakengu ita sanga mooi ngangu dua nataak. Aho. Ita inane aminde butaya siknga natayamunggak. ");
INSERT INTO wnc_vpl VALUES ("PS116_16","020_116_16","PSA","116","16","16","Buyambam tapa, siakande siknga na gatane puya aminda dakngake puya gatane akngaka apasinggat. Unzing tupa mingata pasikut binga. Gata nau na wambingu waikngami take yuat. ");
INSERT INTO wnc_vpl VALUES ("PS116_17","020_116_17","PSA","116","17","17","Siwan nata gae musip gwaang natanggamunggat taknga ofana binga gamunggat. Gamuke nata gae tumuk wam ganiwit. ");
INSERT INTO wnc_vpl VALUES ("PS116_18","020_116_18","PSA","116","18","18","Siwan nata wamu tupa gae yawa kekekakut taknga nata apmanu gatane amindabamde kaine sanga waaknga atasiwit. ");
INSERT INTO wnc_vpl VALUES ("PS116_19","020_116_19","PSA","116","19","19","Ngan, Anututane yotbam gwekatang yuke sanga waaknga atasiwit, you Jerusalem yuak gwekatangun. Siakan. Buyambam tapatane umana yatangenatnim. ");
INSERT INTO wnc_vpl VALUES ("PS117_1","020_117_1","PSA","117","1","1","Ginu kepna kepna nana aminu kuupbamda, Buyambam tapatane umana yatangenatnong. Ngan, ginu dongu takngatu takngatuine nana aminu kuupbamda, Buyambam tapatane umana yatangenatnong. ");
INSERT INTO wnc_vpl VALUES ("PS117_2","020_117_2","PSA","117","2","2","Ita ninde take siknga asinggan asinggan nataniman buyambam singgak. Sike ita wamu yanggak kaknga asinggan asinggan tawake tasinggak. Buyambam tapatane umana yatangenatnong. ");
INSERT INTO wnc_vpl VALUES ("PS118_1","020_118_1","PSA","118","1","1","Buyambam tapata ninde takeaknga tasinggakge gaak wam ininim. Asinggan asinggan ita ninde musip kwikwik siknga natanimunggakge natake inimbaknganim. ");
INSERT INTO wnc_vpl VALUES ("PS118_2","020_118_2","PSA","118","2","2","Nata nataau Isrel nanata anzing siknga yaning, “Ita ninde butaya siknga asinggan asinggan natanimunggak,” ngang yaningge nataat ");
INSERT INTO wnc_vpl VALUES ("PS118_3","020_118_3","PSA","118","3","3","Siwan aminu Arondane dongune nanata anzing yaning, “Ita ninde butaya siknga asinggan asinggan natanimunggak,” ngang yaningge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS118_4","020_118_4","PSA","118","4","4","Ngan, aminu kuupbam Buyambam tapae gwaukaingga anzing yaning, “Ita ninde butaya siknga asinggan asinggan natanimunggak,” ngang yaningge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS118_5","020_118_5","PSA","118","5","5","Na meya buyambamu takngatu kake Buyambam tapae tumuk wam inikum. Iniwa natake ita meya waaknga gatukande sandekngamukut. ");
INSERT INTO wnc_vpl VALUES ("PS118_6","020_118_6","PSA","118","6","6","Buyambamtapa naat gatake yuamakge aminda nae sanga wai takngatu dua tasining. Asikaya aminu tapatuta sanga wai takngatu nae ba tasiwik? Unzingge na dua gwaumbit. ");
INSERT INTO wnc_vpl VALUES ("PS118_7","020_118_7","PSA","118","7","7","Buyambamtapa naat gatake yuamak. Siwan ita na gatangamunggak kapanin. Unzingge nata iwana yaipakepu peke pasiwa maining. ");
INSERT INTO wnc_vpl VALUES ("PS118_8","020_118_8","PSA","118","8","8","Siwan Buyambam tapae ninda banip sinimu take siknga. Siwan ngana ninda aminde baniu sinimu take dua siwik. ");
INSERT INTO wnc_vpl VALUES ("PS118_9","020_118_9","PSA","118","9","9","Ninda baniu Buyambam tapae sinimu take siknga. Siwan ngana ninda baniu kingge sinimu take dua siwik. ");
INSERT INTO wnc_vpl VALUES ("PS118_10","020_118_10","PSA","118","10","10","Natane iwana kepna kepna nana aminu kwaapzangga na takumbasiking. Siwan ngana Buyambam tapatane kekeknga akngane nata atzipa puyukut. ");
INSERT INTO wnc_vpl VALUES ("PS118_11","020_118_11","PSA","118","11","11","Waaminda kaukaut takumbasiking. Siwan ngana Buyambam tapatane kekeknga akngane nata atzipa kumbing. ");
INSERT INTO wnc_vpl VALUES ("PS118_12","020_118_12","PSA","118","12","12","Ita na ingutbam kwaapzangga binga takumbasiking. Siwan ngana zaat siknga katap gwenu sak tangaatang isike kungwanggak binga kumbing. Buyambam tapatane umana akngane nata atzipa kumbing. ");
INSERT INTO wnc_vpl VALUES ("PS118_13","020_118_13","PSA","118","13","13","Iat amak kaknga kekeknga siknga naat ambumang. Siwan na paa pimakum. Siwan ngana Buyambam tapata akgatangamukut. ");
INSERT INTO wnc_vpl VALUES ("PS118_14","020_118_14","PSA","118","14","14","Buyambamtapa na kekekangamunggak kapanin. Siwan na ie bakngake kap taknga taingamunggat. Ita na ina siknga gatangamunggak. ");
INSERT INTO wnc_vpl VALUES ("PS118_15","020_118_15","PSA","118","15","15","Aminu kepi noma nomanae tawakaing aminu waakwakga yotnaatang yuke iwana ayapbikingge natake bakngake kap taikaing. Kau wa taikaingu anzing, Buyambam tapata kekekake sanga kekeknga aknga aknga tasikut. ");
INSERT INTO wnc_vpl VALUES ("PS118_16","020_118_16","PSA","118","16","16","Buyambamtapa kekekngana bamban. Buyambam tapata kekekake sanga kekeknga aknga aknga tasikut. ");
INSERT INTO wnc_vpl VALUES ("PS118_17","020_118_17","PSA","118","17","17","Na zet dua kupit. Aho. Nata kayuk yuke Buyambam tapata sanga pasikutde yakapit. ");
INSERT INTO wnc_vpl VALUES ("PS118_18","020_118_18","PSA","118","18","18","Buyambam tapata waiaknganae natake meya buyambam atnamukut. Siwan ngana dua nandutewan kumbum. ");
INSERT INTO wnc_vpl VALUES ("PS118_19","020_118_19","PSA","118","19","19","Sike gwambou aminu noma nomana tasikaingga take kopnanga gwau zitnong. Siwan nata undang koke Buyambam tapatane umana yatangenawit. ");
INSERT INTO wnc_vpl VALUES ("PS118_20","020_118_20","PSA","118","20","20","Gwambou anggwau Buyambam tapatane noman amindakan take kopning. ");
INSERT INTO wnc_vpl VALUES ("PS118_21","020_118_21","PSA","118","21","21","Buyambam tapa, gata tumuk wama natake gatangamuke na gatuka tapi take yuat. Unzingge nata umanda yatangenawit. ");
INSERT INTO wnc_vpl VALUES ("PS118_22","020_118_22","PSA","118","22","22","Siwan kamundata yot gwendu supda tasike suu gwendu natapan wai ngang siwan kwasikingu, apmanu suu wagwenu kawan suu tupan gwen siwan yotgwen tapan kekekanggak. ");
INSERT INTO wnc_vpl VALUES ("PS118_23","020_118_23","PSA","118","23","23","Buyambam tapata ina yawan sanga waapa aakut. Waapa aawan kake natapna take siknga singgak. ");
INSERT INTO wnc_vpl VALUES ("PS118_24","020_118_24","PSA","118","24","24","Siwan Buyambam tapata sanga waaknga aawikge tasikut. Unzingge ninda asiknga bakngake ie musip gwaang natapnim. ");
INSERT INTO wnc_vpl VALUES ("PS118_25","020_118_25","PSA","118","25","25","Buyambam tapa, ninu gatuka papso. Gata gatanimi sanga kuupbam ninda tasinimu takekan sining. ");
INSERT INTO wnc_vpl VALUES ("PS118_26","020_118_26","PSA","118","26","26","Siwan ga Buyambam tapae umande apinu Buyambam tapata gae apbakngawik. Siwan ninda Buyambam tapatane yotna gwene yuke inimbakngakanim. ");
INSERT INTO wnc_vpl VALUES ("PS118_27","020_118_27","PSA","118","27","27","Buyambamtapa awiapa Anutu siknga unin. Ita ninu kakuya take siknga pasiwan ninu itane kakaa akngane take yuamang. Siwan, ginda musip gwaang natake katap kaing pake alta dakane kuke takumbasinong. ");
INSERT INTO wnc_vpl VALUES ("PS118_28","020_118_28","PSA","118","28","28","Ga natane Anutuna, unzingge nata gaak wam yake ganimbakngawit. Ga natane Anutuna, unzingge nata gatane umanda yatangenawit. ");
INSERT INTO wnc_vpl VALUES ("PS118_29","020_118_29","PSA","118","29","29","Buyambam tapata sanga take akngakan tasinggakge gaak wam ininong. Ita ninde take siknga natanimunggak kaknga wena dua siwik. ");
INSERT INTO wnc_vpl VALUES ("PS119_1","020_119_1","PSA","119","1","1","Aminu kunduta noman gan sukuke gutonga takngatu dua tasikaingu Anututa sanga takeaknga pasiyamik. Ngan, Buyambam tapatane mama wamnakan tawakaingu Anututa sanga takeaknga pasiyamik. ");
INSERT INTO wnc_vpl VALUES ("PS119_2","020_119_2","PSA","119","2","2","Aminu Anututane mama wamu kuupbam asiknga tawakaingu take aknga pasiyamik. Waaminda Anutue kuke iat yutnangge take siknga nataaing. ");
INSERT INTO wnc_vpl VALUES ("PS119_3","020_119_3","PSA","119","3","3","Siakande siknga, aminu waakwau waiaknga dua tawakaing. Waakwau kepi Buyambam tapatane aknganekan sukukaing. ");
INSERT INTO wnc_vpl VALUES ("PS119_4","020_119_4","PSA","119","4","4","Gata mama wamba kuutgan ninde gwa nimukuyak. Nimuke gata natayau, ninu akgwauke mama wamu kuupbam katak siknga tawanimde natayak. ");
INSERT INTO wnc_vpl VALUES ("PS119_5","020_119_5","PSA","119","5","5","Nata nataau nata kekekake gatane mama wamba asinggan tawambitde nataat. ");
INSERT INTO wnc_vpl VALUES ("PS119_6","020_119_6","PSA","119","6","6","Unzingge na gatane mama wamba akngaekan siknga nataat. Natake maaknga kundusim ngakaya dua natapit. ");
INSERT INTO wnc_vpl VALUES ("PS119_7","020_119_7","PSA","119","7","7","Sike nata gatane mama wamba noman takngakae natatakuwa siwan gatane umanda aknga ayatangenawit. ");
INSERT INTO wnc_vpl VALUES ("PS119_8","020_119_8","PSA","119","8","8","Nata gatane mama wamba katak siknga tawambit. Unzingge gata na ma siknga napmambim. ");
INSERT INTO wnc_vpl VALUES ("PS119_9","020_119_9","PSA","119","9","9","Dasing siknga wawi matek tapata noman taknganekan sukuwik? Ita gatane wamba katak tawakengu nomangan sukuwik. ");
INSERT INTO wnc_vpl VALUES ("PS119_10","020_119_10","PSA","119","10","10","Na natdetdeu takngatukan tanggat. Siwan Anutue kuke iat yutnangge take siknga natat. Siwan gata gatangami nata gatane mama wamba dua tewit. ");
INSERT INTO wnc_vpl VALUES ("PS119_11","020_119_11","PSA","119","11","11","Sike nata waiaknga gae dua tasiwitde natake gatane wamba natdetdetnane kekeknga gwa natapa yukut. ");
INSERT INTO wnc_vpl VALUES ("PS119_12","020_119_12","PSA","119","12","12","Buyambam tapa, nata gatane umanda yatangenakgat. Sike gatane mama wamba noman takwau asiknga nanindamumso. ");
INSERT INTO wnc_vpl VALUES ("PS119_13","020_119_13","PSA","119","13","13","Nata aminu kuupbam gata mama wamu ninikapbuyau nata ayaninggat ");
INSERT INTO wnc_vpl VALUES ("PS119_14","020_119_14","PSA","119","14","14","Na gatane wam tawanangge asiknga baknganggat. Unzing aminda moningge ba sanga gwaam gwaamde bakngakaing binga. ");
INSERT INTO wnc_vpl VALUES ("PS119_15","020_119_15","PSA","119","15","15","Nata natdetdetnane sanga nata tasiwitde yakuyak kat, gatu wamu nimukuyak kat katak siknga natapnangge natake tasinggat. ");
INSERT INTO wnc_vpl VALUES ("PS119_16","020_119_16","PSA","119","16","16","Na gatane mama wamde iaknga siknga nataat. Nata wamu waakngae dua siknga botawit. ");
INSERT INTO wnc_vpl VALUES ("PS119_17","020_119_17","PSA","119","17","17","Gata nae take siknga tasiwi na gikane puya aminda kayuk yuyuuk gatane wamba tawambit. ");
INSERT INTO wnc_vpl VALUES ("PS119_18","020_119_18","PSA","119","18","18","Gata natane natdetdetna tapi kakaawan nata wamu take aknga aknga inata kundu mama wambaatang yuaingu natdewit. ");
INSERT INTO wnc_vpl VALUES ("PS119_19","020_119_19","PSA","119","19","19","Sike na pakapuyut amin tapa, keu andakane asinggan dua yuwit. Unzingge gata mama wamba nae ma takusopuwim. ");
INSERT INTO wnc_vpl VALUES ("PS119_20","020_119_20","PSA","119","20","20","Nata musipmaatangu gatane yuyuk noman takngae tapdukbamu asinggan tawanangge take siknga nataat. ");
INSERT INTO wnc_vpl VALUES ("PS119_21","020_119_21","PSA","119","21","21","Sike aminu kunduta gatane mama wambae masa imuke inae natdet tawakaing. Siwan gata yamandet aminu sanga take akngata ie dua apikge natake waakwau kaanga yaniyo. ");
INSERT INTO wnc_vpl VALUES ("PS119_22","020_119_22","PSA","119","22","22","Sike waaminda nae sapdut wam nanisapduwawa kake gata gatangami gatuna wamu waaknga yananga dua siwik. Dasingge, na gatane mama wamba atawanggat. Ge gata ma kapewi wamu unzaaknga nae ma yawam. ");
INSERT INTO wnc_vpl VALUES ("PS119_23","020_119_23","PSA","119","23","23","Sike tupan aminu nae sapdut wam yaningge unekan yuke wamu yakaing. Siwan ngana undanga, na gatane puya aminda, nata gatane mama wamba noman takngae asinggan natanggamatawit. ");
INSERT INTO wnc_vpl VALUES ("PS119_24","020_119_24","PSA","119","24","24","Na wamu kepi aknga asukunggat taknganin tapa nomatawikge nanikuyak kakngae take siknga nataat. Gatane wambata asinggan nanindamukgak. ");
INSERT INTO wnc_vpl VALUES ("PS119_25","020_119_25","PSA","119","25","25","Na aminda atnaitakepu tewa kepdakaatang wai siknga pekgat. Siwan ngana gata ayawi kekekakut saak tangenake na tapi kekekawit. ");
INSERT INTO wnc_vpl VALUES ("PS119_26","020_119_26","PSA","119","26","26","Sike na yuyuuk taknganae kuupbam gwa ganikum. Siwan gata yake gwa nanikuyak. Gata nae mama wamba kuupbam nanindamumso. ");
INSERT INTO wnc_vpl VALUES ("PS119_27","020_119_27","PSA","119","27","27","Gatane mama wamba natdewitde nanindamumso. Siwana nata duya takngatu takngatu gata tasikuyak kakngae natanggamatawit. ");
INSERT INTO wnc_vpl VALUES ("PS119_28","020_119_28","PSA","119","28","28","Sike na musipmaatangu meya siknga nataat. Gata ayawi kekekakut saak tapi kekekawit. ");
INSERT INTO wnc_vpl VALUES ("PS119_29","020_119_29","PSA","119","29","29","Gata nanduyuwi nata kem wam taknga ba tanzit taknga dua tasiwit. Gata mama wam takngaka tawake nae butaya natangamuyo. ");
INSERT INTO wnc_vpl VALUES ("PS119_30","020_119_30","PSA","119","30","30","Sike na gatane siakan wam tawambitde gwa yawa kekekakut. Asingganu gatane mama wambae atnatayuat. ");
INSERT INTO wnc_vpl VALUES ("PS119_31","020_119_31","PSA","119","31","31","Buyambam tapa, wamu gata nae namukuyak kaknga asinggan tawanggat. Unzingge gata sanga tapatu dua katewi aminu tapatuta tasiwan maakawit. ");
INSERT INTO wnc_vpl VALUES ("PS119_32","020_119_32","PSA","119","32","32","Nata zaatgaman gikane wamba tawambit. Dasingge, gata meya musipmaatang yukingu gwa sandekuyak. ");
INSERT INTO wnc_vpl VALUES ("PS119_33","020_119_33","PSA","119","33","33","Buyambam tapa, gata na mama wamba katak siknga tawambitde nanindamumso. Nanindamumbi nata asinggan tasitakuusika kupit. ");
INSERT INTO wnc_vpl VALUES ("PS119_34","020_119_34","PSA","119","34","34","Gata nae natdetdeu noman siknga naminu nata apme tawambit. Nata musipma tewa gatane mama wambae kuwan kuutgan tawambit. ");
INSERT INTO wnc_vpl VALUES ("PS119_35","020_119_35","PSA","119","35","35","Gata kepina tanomanuwi nata kepi mama wambata yanggak saak sukuwit. Dasingge, na mama wamu waakngae natapa take siknga singgak. ");
INSERT INTO wnc_vpl VALUES ("PS119_36","020_119_36","PSA","119","36","36","Gata musipma tangenawi nata wamba waaknga tawananggengu take natapit. Natake sanga kwaapzangbam papitde dua natapa kuwik. ");
INSERT INTO wnc_vpl VALUES ("PS119_37","020_119_37","PSA","119","37","37","Gata gatangami sanga yapiina wena, moo akngae masa yamit. Gika ayawi kekekakut taknga saak na katak toimso. ");
INSERT INTO wnc_vpl VALUES ("PS119_38","020_119_38","PSA","119","38","38","Na gikane puya amin tapaka gae akgwaukgatde wamu gika naniwi kekekakut taknga saak tasiyo. ");
INSERT INTO wnc_vpl VALUES ("PS119_39","020_119_39","PSA","119","39","39","Sike aminu kunduta nandupa aminu waiapa siwik kakngae apbitanggat. Siwan sanga waaknga sandekngami take siwik. Dasingge, gatane mama wambae natapa take siknga singgak. ");
INSERT INTO wnc_vpl VALUES ("PS119_40","020_119_40","PSA","119","40","40","Na gatane mama wamba kuutgan tawambitde take siknga nataat. Gatane yuyukga noman gan siknga. Unzingge kayuk yutnanga aknga gata namuyo. ");
INSERT INTO wnc_vpl VALUES ("PS119_41","020_119_41","PSA","119","41","41","Buyambam tapa, gata nae take siknga natangamunggayak kaknga yeikngamuyo. Yeikngamuke na gatuka tapso. Unzing tasinangge gwa yawi kekekakut. ");
INSERT INTO wnc_vpl VALUES ("PS119_42","020_119_42","PSA","119","42","42","Na gata unzing gatangami aminu atnanisapdutningu yake yaniwit. Dasingge, na gatane wam takngae banip singgat. ");
INSERT INTO wnc_vpl VALUES ("PS119_43","020_119_43","PSA","119","43","43","Gata gikane siakan wam takngaka genane ma sandewim. Dasingge, na gatane wamu noman takngae baniu asinggat. ");
INSERT INTO wnc_vpl VALUES ("PS119_44","020_119_44","PSA","119","44","44","Sike nata gatane mama wamba asinggan tawambit. Ngan, asinggan asinggan tawambit. ");
INSERT INTO wnc_vpl VALUES ("PS119_45","020_119_45","PSA","119","45","45","Na gatane wam taknga natdetnangge tawanggat. Unzingge waiakngata dua umukngaman na meya dua kake takekan sukuwit. ");
INSERT INTO wnc_vpl VALUES ("PS119_46","020_119_46","PSA","119","46","46","Siwan nata king takwau gatane wam takngae yanikapit. Na unzing tasiwa aminu kunduta na maakawitde tasiwa maiwik. ");
INSERT INTO wnc_vpl VALUES ("PS119_47","020_119_47","PSA","119","47","47","Dasingge, na gatane mama wamde natapa take siknga singgak. Siwan mama wamu waaknga tawanangge musip gwaang nataat. ");
INSERT INTO wnc_vpl VALUES ("PS119_48","020_119_48","PSA","119","48","48","Sike na gatane mama wam takngaka yatangenakgat. Gatane mama wambae natapa take siknga singgak. Siwan nata asingganu gatane mama wamu waakngae natanggamatanggat. ");
INSERT INTO wnc_vpl VALUES ("PS119_49","020_119_49","PSA","119","49","49","Gata gatuka wamu tupa nae yawi kekekakut takngae natapso. Na puya aminda. Wamu waakngata musipma tangenawan nata wamu yawi kekekakut takngae banip singgat. ");
INSERT INTO wnc_vpl VALUES ("PS119_50","020_119_50","PSA","119","50","50","Sike tapduu meya kaya sikut kopatangu na musip kwikwik takum. Dasingge, ayawi kekekakut takngata kayuk yutnanga aknga inata kundu namukut. ");
INSERT INTO wnc_vpl VALUES ("PS119_51","020_119_51","PSA","119","51","51","Sike yamandet aminda sapdut wamu wai siknga tendeknga wena nanikaing. Siwan ngana na gatane mama wamde masa dua imunggat. ");
INSERT INTO wnc_vpl VALUES ("PS119_52","020_119_52","PSA","119","52","52","Buyambam tapa, na mama wamu tupa siknga namukuyak takngae natayuat. Sike wamu waakngae natake musipmaatang kwikwiknga nataat. ");
INSERT INTO wnc_vpl VALUES ("PS119_53","020_119_53","PSA","119","53","53","Sike nata kaawanu yamandet aminda gatane mama wamba gwa peking. Pewa kake nata musipma toknga siknga nataat. ");
INSERT INTO wnc_vpl VALUES ("PS119_54","020_119_54","PSA","119","54","54","Sike keu andakane yukuuk gatane mama wamde natake kap taiwit. ");
INSERT INTO wnc_vpl VALUES ("PS119_55","020_119_55","PSA","119","55","55","Buyambam tapa, na zikaane gatane umandae atnatayuat. Natayuke gatane mama wamba tawanggat. ");
INSERT INTO wnc_vpl VALUES ("PS119_56","020_119_56","PSA","119","56","56","Gatane mama wamu nata kuutgan tawanggat. Ngan, gatane wamu waaknga asinggan asinggan apbakngake gwaamukgat. ");
INSERT INTO wnc_vpl VALUES ("PS119_57","020_119_57","PSA","119","57","57","Buyambam tapa, ga naat yuke gae natapa take siknga singgak. Nata gae anzing yawa kekekakut, “Nata itane mama wamu kuutgan tawambit,” ngang yakum. ");
INSERT INTO wnc_vpl VALUES ("PS119_58","020_119_58","PSA","119","58","58","Gata musip kwikwiu nae namiyakge kekeknga siknga ganikwaikgat. Dasingge, gika unzing tasinangge gwa yawi kekekakut. ");
INSERT INTO wnc_vpl VALUES ("PS119_59","020_119_59","PSA","119","59","59","Na kepi sukunggatde atnatapasinggat. Unzingge apmanu gae mama wam tawambitde gwa yawa kekekanggak. ");
INSERT INTO wnc_vpl VALUES ("PS119_60","020_119_60","PSA","119","60","60","Sike na moo dua yuwit. Gatane mama wamu zet tawambit. ");
INSERT INTO wnc_vpl VALUES ("PS119_61","020_119_61","PSA","119","61","61","Na wai aminda napda wamake inane waiakngaatang nanitake kunangge tasikaing. Siwan ngana na gatane mama wamde dua botawit. ");
INSERT INTO wnc_vpl VALUES ("PS119_62","020_119_62","PSA","119","62","62","Sike petakumat dakaatangu na asenake gatane mama wamu noman takngae natake ganimbaknganggat. ");
INSERT INTO wnc_vpl VALUES ("PS119_63","020_119_63","PSA","119","63","63","Na gae akgwauke mama wamba tawakaing aminkat naat notna notna yuamang. ");
INSERT INTO wnc_vpl VALUES ("PS119_64","020_119_64","PSA","119","64","64","Buyambam tapa, ga keu andakane yuaing aminu kuupbamde take siknga nataayak. Gikane mama wamu kuupbam siknga nanindamumso. ");
INSERT INTO wnc_vpl VALUES ("PS119_65","020_119_65","PSA","119","65","65","Buyambam tapa, gata nae takeaknga tasinggayak. Na puya amin tapakaen. Gika wamu ayawi kekekakut taknga saak tasingamunggayak. ");
INSERT INTO wnc_vpl VALUES ("PS119_66","020_119_66","PSA","119","66","66","Na gatane mama wamu kuupbamde banip siknga singgat. Unzingge gata nanindamumbi natdetdeu take aknga pake sanga kuupbam katak usanziwit. ");
INSERT INTO wnc_vpl VALUES ("PS119_67","020_119_67","PSA","119","67","67","Tupa gata nae kepi yeikngamukuyau atekum. Teke kuwa nanduke gata meya takngatu takngatu atnamukuyak. Nami kake apmau nata gatane wamu atawanggat. ");
INSERT INTO wnc_vpl VALUES ("PS119_68","020_119_68","PSA","119","68","68","Sike ga take siknga. Ge sanga gata tasinggayak kakngae natapa take singgak. Siwan gata mama wamba katak siknga nanindamumso. ");
INSERT INTO wnc_vpl VALUES ("PS119_69","020_119_69","PSA","119","69","69","Sike yamandet aminda kem wamu kwaapzang nanisapduking. Siwan ngana na natdetdeu takngatu wena. Na gatane mama wamba asiknga tawambit. ");
INSERT INTO wnc_vpl VALUES ("PS119_70","020_119_70","PSA","119","70","70","Aminu waakwau natdetdeu butaya aknga takngatusimu wena. Sike ngana na gatane mama wamde siknga nataat. ");
INSERT INTO wnc_vpl VALUES ("PS119_71","020_119_71","PSA","119","71","71","Gata meya aknga namukuyakge natapa take singgak. Dasingge? Meya waakngata gatangaman mama wambae take siknga natdekum. ");
INSERT INTO wnc_vpl VALUES ("PS119_72","020_119_72","PSA","119","72","72","Na moningu buyambam siknga panangge take dua nataat. Siwan ngana gatane mama wambae take siknga nataat. ");
INSERT INTO wnc_vpl VALUES ("PS119_73","020_119_73","PSA","119","73","73","Sike na gika siknga katakgata tumukuyak. Siwan gata natdetdet nami gikane mama wambae kuutgan natdewit. ");
INSERT INTO wnc_vpl VALUES ("PS119_74","020_119_74","PSA","119","74","74","Siwan nata natapa aminu gae akgwaukaingu na nanduke waakwau apbaknganingge nataat. Dasingge, na gika wamu yawi kekekakut takngae banip singgat. ");
INSERT INTO wnc_vpl VALUES ("PS119_75","020_119_75","PSA","119","75","75","Buyambam tapa, na atnataat. Gatane mama wamba noman gan siknga. Sike gata meya nae namukuyau gata asinggan gatangamunangge natake tasikuyak. ");
INSERT INTO wnc_vpl VALUES ("PS119_76","020_119_76","PSA","119","76","76","Sike nata nataau gata nae musip kwikwik natangamunggayak kakngata musipma tapan kekekanggakge nataat. Dasingge? Wamu gata na puya amin tapakae wa yakuyau atasinggayak. ");
INSERT INTO wnc_vpl VALUES ("PS119_77","020_119_77","PSA","119","77","77","Gata apmanu nae butaya natangamuyo. Natangami kayuk yutnanga akngana atapit. Dasingge, na gatane mama wamde natapa take siknga singgak. ");
INSERT INTO wnc_vpl VALUES ("PS119_78","020_119_78","PSA","119","78","78","Sike yamandet aminu kunduta yumdekan nae yawa maiwitde tasingamuking. Unzingge nata nataau aminu waakwau apmaakaningge nataat. Siwan ngana na, na gatane mama wamde asinggan natayuwit. ");
INSERT INTO wnc_vpl VALUES ("PS119_79","020_119_79","PSA","119","79","79","Aminu gae akgwaukaingkat gatu gatane mama wambae nataaing aminkat nae apa notna notna daknganimde nataat. ");
INSERT INTO wnc_vpl VALUES ("PS119_80","020_119_80","PSA","119","80","80","Gata gatangami gikane mama wamu siakande siknga tawambitde nataat. Tawamba nanduke aminu kunduta na maakawitde tasiwa maiwikge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS119_81","020_119_81","PSA","119","81","81","Sike na gata tapiakge ganduyuwawa kekekngana tuyuknga gwasik. Ngana na wamu gata yawi kekekakut taknga tawambiyakge banip siknga singgat. ");
INSERT INTO wnc_vpl VALUES ("PS119_82","020_119_82","PSA","119","82","82","Na wamu gika yawi kekekakut takngae natake ganduyuwawa kaina toknga nasikaing. Siwan anzing yanggat, “Zaapduknga natane musipma tasiwan wikawik,” ngang yanggat. ");
INSERT INTO wnc_vpl VALUES ("PS119_83","020_119_83","PSA","119","83","83","Sike na memetane gupna yangga zikaingu kupan takngata tasiwan bumi siwan mumba kuwa maikaing binga mainggat. Siwan ngana gatane mama wamde dua botanggat. ");
INSERT INTO wnc_vpl VALUES ("PS119_84","020_119_84","PSA","119","84","84","Tapduu datdasing ganduyuwawit? Siwan zaapduknga gata na puya amindae wai tasikaing aminde meya yake yamuya? ");
INSERT INTO wnc_vpl VALUES ("PS119_85","020_119_85","PSA","119","85","85","Sike yamandet aminu gatane mama wamba dua tawakaing. Dua tawake ita gapma kundu nata une pimapitde kusopuknga kwaikaing. ");
INSERT INTO wnc_vpl VALUES ("PS119_86","020_119_86","PSA","119","86","86","Gatane mama wamba kuupbam wa sanga ninda ie banip sinanga taknganin. Siwan ngana aminu kunduta nae kem wam moo siknga yake tasiwan mainggat. Unzingge gata gatangamuyo. ");
INSERT INTO wnc_vpl VALUES ("PS119_87","020_119_87","PSA","119","87","87","Sike na nutapan kupitde gwa dapakakut. Siwan ngana gatane mama wamba dua tekum. ");
INSERT INTO wnc_vpl VALUES ("PS119_88","020_119_88","PSA","119","88","88","Gata nae take siknga asinggan natangamunggayak. Siwan gata na katak nanduyuwi na zaat dua kupit. Dua kungwake nata gatane mama wamu kuutgan tawambit. ");
INSERT INTO wnc_vpl VALUES ("PS119_89","020_119_89","PSA","119","89","89","Buyambam tapa, gatane wamu asinggan asinggan yuwik. Wamu waaknga yekaune kekeknga yuak. ");
INSERT INTO wnc_vpl VALUES ("PS119_90","020_119_90","PSA","119","90","90","Gata wamu yawi kekekakut taknga asinggan asinggan tawanggayak. Gata kepdaka tangine tekuyak. Siwan waomune unzing yuke dua isakunggak. ");
INSERT INTO wnc_vpl VALUES ("PS119_91","020_119_91","PSA","119","91","91","Mama wamu gata tupa yakuyau apman kaya unzing yuak. Ngan, sanga kuupbamda gikae banip tawakaing. ");
INSERT INTO wnc_vpl VALUES ("PS119_92","020_119_92","PSA","119","92","92","Sike nata mama wamu gatane akngae take dua ba natapbum gamu, nata meya takngatu takngatu kakum gwekatangu gwa kupam. ");
INSERT INTO wnc_vpl VALUES ("PS119_93","020_119_93","PSA","119","93","93","Nata gatane mama wamba dua pewit. Dasingge, na unin tawamba gata tasiwi na kayuk yuat. ");
INSERT INTO wnc_vpl VALUES ("PS119_94","020_119_94","PSA","119","94","94","Sike na gikanekan. Unzingge gata na tapso. Gatane wamu asinggan tawanangge tasinggat. ");
INSERT INTO wnc_vpl VALUES ("PS119_95","020_119_95","PSA","119","95","95","Wai aminu na nutapan kupitde undang kusopuke yuaing. Siwan ngana na gatane mama wambae natapa kuwan nata ie nangaakan dua nataat. ");
INSERT INTO wnc_vpl VALUES ("PS119_96","020_119_96","PSA","119","96","96","Na apmanu gwa nataat. Sanga take tapatu wena. Siwan ngana gatane mama wamba take siknga. Take akngana kwaapzang siknga. Sangabamu ita gwa yapbikut. ");
INSERT INTO wnc_vpl VALUES ("PS119_97","020_119_97","PSA","119","97","97","Na gatane mama wamde take siknga nataat. Na ie kwakngaom gatu zikaane ngang ie natanggamatanggat. ");
INSERT INTO wnc_vpl VALUES ("PS119_98","020_119_98","PSA","119","98","98","Gatane mama wam takngakata tasiwan na natdetdetna bamban sikngaapa dakngake iwanatane natdetdetna ayapbike yuat. Dasingge, wamu waakngaat naat gatake yuamak. ");
INSERT INTO wnc_vpl VALUES ("PS119_99","020_119_99","PSA","119","99","99","Nata gatane mama wam taknga atawanggat. Siwan wamu wa tawanggat takngata tasiwan na natdetdetna bamban sikngaapa dakngake aminu nanindamukaing amindane natdetdetna ayapbike yuat. ");
INSERT INTO wnc_vpl VALUES ("PS119_100","020_119_100","PSA","119","100","100","Natane natdetdeu kwekngatane natdetdetna gwa yapbikut. Dasingge, na gatane mama wamu noman takngakan tawanggat. ");
INSERT INTO wnc_vpl VALUES ("PS119_101","020_119_101","PSA","119","101","101","Sike na kepi waiaknga tawanangge natapit gamu nata asisakuwam. Dasingge, na gatane wam takngakan tawambitde nataat. ");
INSERT INTO wnc_vpl VALUES ("PS119_102","020_119_102","PSA","119","102","102","Gikane wam taknga gika siknga nanindamukuyak. Unzingge wamu waaknga dua tekum. ");
INSERT INTO wnc_vpl VALUES ("PS119_103","020_119_103","PSA","119","103","103","Sike iningou genane napanu kaa singgak. Siwan ngana gatane wamu kaa siknga. ");
INSERT INTO wnc_vpl VALUES ("PS119_104","020_119_104","PSA","119","104","104","Gatane mama wambata natdetdeu take namunggak. Unzingge waiaknga kuupbamde asiknga bitanggat. ");
INSERT INTO wnc_vpl VALUES ("PS119_105","020_119_105","PSA","119","105","105","Sike gatane wam taknga lam gwenda binga gatangaman kepi noman sukuwit. Ita kakaa kepiapa yeikngaman kuwit. ");
INSERT INTO wnc_vpl VALUES ("PS119_106","020_119_106","PSA","119","106","106","Sike na gatane wamu noman taknga kuupbam tawambitde gwa yawa kekekakut. Unzingu apme tasiwit. ");
INSERT INTO wnc_vpl VALUES ("PS119_107","020_119_107","PSA","119","107","107","Buyambam tapa, natapso. Na meya buyambam takngata usukwatapbut. Unzingge gika gwa yawi kekekakut taknga tasiwi na kayuk yuwit. ");
INSERT INTO wnc_vpl VALUES ("PS119_108","020_119_108","PSA","119","108","108","Buyambam tapa, nata gae ganimbaknganggat takngae natapi take siyok. Siwan gata mama wamba nanindamumso. ");
INSERT INTO wnc_vpl VALUES ("PS119_109","020_119_109","PSA","119","109","109","Sike na asinggan kumnangge tandakngawa dapaknga singgak. Siwan ngana mama wambae dua botanggat. ");
INSERT INTO wnc_vpl VALUES ("PS119_110","020_119_110","PSA","119","110","110","Aminu wai akwau na tanggaganutnangge yapapna kaiwan dandakawan yuaing. Siwan ngana na gatane wam taknga dua tewit. ");
INSERT INTO wnc_vpl VALUES ("PS119_111","020_119_111","PSA","119","111","111","Na gatane wam taknga dumza siknga asinggan asinggan tanggaganukgat. Sike wamu waakngata tasiwan musip gwaang natake asiknga baknganggat. ");
INSERT INTO wnc_vpl VALUES ("PS119_112","020_119_112","PSA","119","112","112","Na gatane mama wamu kuupbam tawanangge gwa natapa kekekanggak. Mama wamba tawake yusika kupit. ");
INSERT INTO wnc_vpl VALUES ("PS119_113","020_119_113","PSA","119","113","113","Sike na musia gweaya nataing aminde take dua nataat. Ngana mama wambae take siknga nataat. ");
INSERT INTO wnc_vpl VALUES ("PS119_114","020_119_114","PSA","119","114","114","Ga natane kakuya tasinggayak kapana ga unin. Siwan natane damanu kekeknga gwena ga unin. Siwan na gika yawi kekekakut takngae banip singgat. ");
INSERT INTO wnc_vpl VALUES ("PS119_115","020_119_115","PSA","119","115","115","Ginu waiaknga tasiya amin, na napmanong. Na Anutunatane mama wamna tawanangge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS119_116","020_119_116","PSA","119","116","116","Sike gata kekekangami kayuk yuwitde gwa yawi kekekakut. Wa yawi kekekakutde gae banip singgat. Gatangami gae banip singgat taknganata pimamsak. ");
INSERT INTO wnc_vpl VALUES ("PS119_117","020_119_117","PSA","119","117","117","Gata katakngane tapinu na take apme yuwit. Siwana nata maak gwaangu gatane wam takngae tewa kuwan nata asinggan tawambit. ");
INSERT INTO wnc_vpl VALUES ("PS119_118","020_119_118","PSA","119","118","118","Sike aminu gatane mama wam taknga teaingu gata masa yamunggayak. Itane natdetdet gwaangu waiaknga tasinangge nataaingu moo siknga kuning. ");
INSERT INTO wnc_vpl VALUES ("PS119_119","020_119_119","PSA","119","119","119","Gata aminu wai tasikaing takwau kuupbamde natapinu wai sipisipi binga singgak. Siwan waaminu mupewi kuning. Unzingge na gatane wam takngae siknga nataat. ");
INSERT INTO wnc_vpl VALUES ("PS119_120","020_119_120","PSA","119","120","120","Sike na gae asiknga gwaumba gupma apa atepan yamukgak. Na gaat wam yananga komde natapa siwan ie akgwaukgat. ");
INSERT INTO wnc_vpl VALUES ("PS119_121","020_119_121","PSA","119","121","121","Nata take akngaat gatu noman takngaat ngang tasikum. Unzingge gata na dua napmambi iwanata tasiwan maiwit. ");
INSERT INTO wnc_vpl VALUES ("PS119_122","020_119_122","PSA","119","122","122","Gata na gatangamiakge yawi kekekawikge nataat. Na gikane puya aminda. Gata yamandet aminu dua kapewi meya nae namuning. ");
INSERT INTO wnc_vpl VALUES ("PS119_123","020_119_123","PSA","119","123","123","Na gata wai aminde kataune sandeke tapiakge natake kai take yuwa yuwa mainggak. Unzing tasinangge tupa gika gwa yawi kekekakut. ");
INSERT INTO wnc_vpl VALUES ("PS119_124","020_119_124","PSA","119","124","124","Gata nae butaya natangamuyo. Natangamuke gika siakan wam taknga katak siknga nanindamumso. ");
INSERT INTO wnc_vpl VALUES ("PS119_125","020_119_125","PSA","119","125","125","Sike na gikane puya aminda. Unzingge natdetdeu gata nami gikane wam takngae natdewit. ");
INSERT INTO wnc_vpl VALUES ("PS119_126","020_119_126","PSA","119","126","126","Buyambam tapa, aminbamda gatane mama wamu ayamasandekaing. Unzingge gata ie meya yamunangge tasiyo. ");
INSERT INTO wnc_vpl VALUES ("PS119_127","020_119_127","PSA","119","127","127","Na gatane mama wambae take siknga nataat. Sike na golmani ngang yanikaingge take dua nataat. Siakan. Gol kundu noman siknga ngana ie take siknga dua nataat. Aho. Na gatane wamba akngae siknga nataat. ");
INSERT INTO wnc_vpl VALUES ("PS119_128","020_119_128","PSA","119","128","128","Ngan, na gatane mama wamu kuupbamde natapa nomangan singgak. Unzingge na kepi gutonga aknga kuupbamde dua siknga nataat. ");
INSERT INTO wnc_vpl VALUES ("PS119_129","020_119_129","PSA","119","129","129","Gatane wamu take siknga. Unzingge nata kuupbam tawanggat. ");
INSERT INTO wnc_vpl VALUES ("PS119_130","020_119_130","PSA","119","130","130","Aminu tapatu gatane wamde natdetdetna buyambam duaapa inindamubanu waapata gatane wamdane yapii natapanu, kakaa aknga musiaatang atapik. Ngan, wamu waaknga natdetna wenaapa natdetdet imunggak. ");
INSERT INTO wnc_vpl VALUES ("PS119_131","020_119_131","PSA","119","131","131","Nata mama wamde take siknga nataat. Siwan musipmaatangu atawambitde siknga enakgak. ");
INSERT INTO wnc_vpl VALUES ("PS119_132","020_119_132","PSA","119","132","132","Gata nae apuke musip kwikwik natangamuyo. Sike aminu gae umandae take siknga nataaing aminde unzingu atasinggayak. ");
INSERT INTO wnc_vpl VALUES ("PS119_133","020_119_133","PSA","119","133","133","Gata na kakuya tasiwi na waiakngaatang dua pimambit. Unzing tupa gika tasinangge gwa yawi kekekakut. Gata waiaknga dua katewi napbimban. ");
INSERT INTO wnc_vpl VALUES ("PS119_134","020_119_134","PSA","119","134","134","Sike na gata gatuka tapso. Siwan aminu na naitakepu tenangge tasikingga na dua tasiwan maiwit. Siwana nata gatane wamban tawambit. ");
INSERT INTO wnc_vpl VALUES ("PS119_135","020_119_135","PSA","119","135","135","Gata nae wesim yuke mama wamde kuupbam nanindamumso. Siwan mama wamba kuutgan nanindamuke nanduyuyo. ");
INSERT INTO wnc_vpl VALUES ("PS119_136","020_119_136","PSA","119","136","136","Sike kai yanggana kwaapzang apukaing. Dasingge, aminbamda gatane mama wamu dua tawakaing. ");
INSERT INTO wnc_vpl VALUES ("PS119_137","020_119_137","PSA","119","137","137","Buyambam tapa, ga noman sikngaapa. Siwan gatane mama wambaaya kuupbam noman gan siknga. ");
INSERT INTO wnc_vpl VALUES ("PS119_138","020_119_138","PSA","119","138","138","Sike mama wamu ninde nimukuyau wa kuupbam noman siwan take siknga. ");
INSERT INTO wnc_vpl VALUES ("PS119_139","020_119_139","PSA","119","139","139","Natane iwana gatane wamba akngae dua nataaing. Unzingge natane musipmaatangu katap gwenda binga isikopan kwatan siknga singgak. ");
INSERT INTO wnc_vpl VALUES ("PS119_140","020_119_140","PSA","119","140","140","Gata wamba yawi kekekakuu siakan siknga. Siwan nata gwa tasiwa sikut. Unzingge na, puya amin tapakata, wamu waaknga yawi kekekakutde take siknga nataat. ");
INSERT INTO wnc_vpl VALUES ("PS119_141","020_119_141","PSA","119","141","141","Sike na aminu moo apa, ge aminbamda na sapdut wam nanikaing. Siwan ngana na gatane mama wambae dua botanggat. ");
INSERT INTO wnc_vpl VALUES ("PS119_142","020_119_142","PSA","119","142","142","Natane musipmaatangu gatane sanga noman nomana aknga asinggan asinggan yuwik. Sike gatane mama wamba kuupbam siakan siknga. ");
INSERT INTO wnc_vpl VALUES ("PS119_143","020_119_143","PSA","119","143","143","Sike meya nae kwaapzangga apukaing. Siwan ngana na gatane mama wambae apbaknganggat. ");
INSERT INTO wnc_vpl VALUES ("PS119_144","020_119_144","PSA","119","144","144","Gatane mama wamu asinggan asinggan noman yuak. Gata gatangami nata natdetdet wamu waakngae natdeke kayuu ayuwit. ");
INSERT INTO wnc_vpl VALUES ("PS119_145","020_119_145","PSA","119","145","145","Buyambam tapa, na musipma tewa gaekan kuwan tumuk wamu kekeknga siknga ganinggat. Natane tumuk wamae natapso. Siwan nata gatane wamu kuupbam tawambit. ");
INSERT INTO wnc_vpl VALUES ("PS119_146","020_119_146","PSA","119","146","146","Apmanu nata gae yanggamatanggat. Gata na tapi nata gatane mama wamba tawambit. ");
INSERT INTO wnc_vpl VALUES ("PS119_147","020_119_147","PSA","119","147","147","Katak dua kwakawawan gata gatangamiakge tumuk wamu ganinggat. Sike na gika yawi kekekakut takngae baniu kekeknga singgat. ");
INSERT INTO wnc_vpl VALUES ("PS119_148","020_119_148","PSA","119","148","148","Sike zikaane kaina kekeknga siwan dapuna katak dua pekgat. Asinggan siknga gata wamu nae yawi kekekakut takngae natanggamatanggat. ");
INSERT INTO wnc_vpl VALUES ("PS119_149","020_119_149","PSA","119","149","149","Buyambam tapa, gata nae asinggan take natangamuke tumuk wamae maau apanggayak. Ngan, gata mama wamu yakuyak saak na kakuya tasiwawi na kayuu yuwit. ");
INSERT INTO wnc_vpl VALUES ("PS119_150","020_119_150","PSA","119","150","150","Sike aminu natdetdeu wai pake na tasiwan maiwitde inenganu gwa apuing. Waaminu gatane mama wamu dua tawake maa siknga yuaing. ");
INSERT INTO wnc_vpl VALUES ("PS119_151","020_119_151","PSA","119","151","151","Siwan ngana, Buyambam tapa, ga nae wesim yuayak. Sike gatane mama wamu siakan gan siknga. ");
INSERT INTO wnc_vpl VALUES ("PS119_152","020_119_152","PSA","119","152","152","Na tupa siknga gatane wamu atnatapbum. Wamu waaknga yakuyau asinggan asinggan yuak ngang nataat. ");
INSERT INTO wnc_vpl VALUES ("PS119_153","020_119_153","PSA","119","153","153","Gata nandupi na meya takngatu kaya singgak. Unzingge gata meya waaknga sandekngamuyo. Dasingge, na gatane mama wamde dua botanggat. ");
INSERT INTO wnc_vpl VALUES ("PS119_154","020_119_154","PSA","119","154","154","Gata na wam yot gwene gata gatangamuke tapi take yuwit. Unzing tasinangge gika gwa yawi kekekakut. ");
INSERT INTO wnc_vpl VALUES ("PS119_155","020_119_155","PSA","119","155","155","Sike wai aminu gatane mama wamba noman taknga dua tawakaing. Unzingge waakwau gata dua papsa. ");
INSERT INTO wnc_vpl VALUES ("PS119_156","020_119_156","PSA","119","156","156","Buyambam tapa, gatane musip kwikwik takngaka buyambam siknga. Gata na tapiakge gwa yawi kekekakut. Unzingge gata waaknga atasiwiakge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS119_157","020_119_157","PSA","119","157","157","Sike aminbamda iwana dakngake tasiwa maiwitde nataaing. Siwan ngana na gatane siakan wam taknga dua teat. ");
INSERT INTO wnc_vpl VALUES ("PS119_158","020_119_158","PSA","119","158","158","Siwan aminu kundu kaawa banip sia aknga ayamasandewanu, nata waakwakge apbitake masa yamunggat. Dasingge, waakwau gatane wamu dua tawakaing. ");
INSERT INTO wnc_vpl VALUES ("PS119_159","020_119_159","PSA","119","159","159","Gata na nandupso. Na gatane mama wamde take siknga nataat. Gata nae take siknga nataayakge gata na asiknga tapso. ");
INSERT INTO wnc_vpl VALUES ("PS119_160","020_119_160","PSA","119","160","160","Gatane wambatane yapii aknga, wamu siakan taknga unin. Ngan, gatane mama wamba nomanu waaknga asinggan asinggan yuak. ");
INSERT INTO wnc_vpl VALUES ("PS119_161","020_119_161","PSA","119","161","161","Sike tupan aminda na wai tasikaingunin, siwan wa tasikainggane yapii wena. Siwan waaminde dua kagwaukgat. Siwan ngana gae wamdekan natanggamatanggat. ");
INSERT INTO wnc_vpl VALUES ("PS119_162","020_119_162","PSA","119","162","162","Na wamu gata yawi kekekakutde asiknga baknganggat. Unzing aminu tapatuta sanga kwaapzang pake baknganggak binga. ");
INSERT INTO wnc_vpl VALUES ("PS119_163","020_119_163","PSA","119","163","163","Na sanga kem taknga akngae apbitake musipmaatangu ie wai ngang nataat. Ngana gatane mama wambaekan take ngangu nataat. ");
INSERT INTO wnc_vpl VALUES ("PS119_164","020_119_164","PSA","119","164","164","Gunziu gwendune tapduu katau kuut musa siwan kautdu gweaya ngangu nata gatane mama wamu noman taknga yakuyakge gaak siknga ganinggaunin. ");
INSERT INTO wnc_vpl VALUES ("PS119_165","020_119_165","PSA","119","165","165","Sike aminu gatane mama wamde take siknga nataaingu, waakwau wikake take siknga yuaing. Unzingge sanga tapatuta dua pasiwan pimaning. ");
INSERT INTO wnc_vpl VALUES ("PS119_166","020_119_166","PSA","119","166","166","Buyambam tapa, na gata gatu tapiakge ganduyuat. Sike na gika yakuyak kaknga tasinggat. ");
INSERT INTO wnc_vpl VALUES ("PS119_167","020_119_167","PSA","119","167","167","Na gatane mama wamu kuupbam atawanggat. Dasingge, na mama wamu waakwakge take siknga nataat. ");
INSERT INTO wnc_vpl VALUES ("PS119_168","020_119_168","PSA","119","168","168","Sike na gatane mama wam gatu gatane pasap wam ngang kuupbam tawanggat. Dasingge, gata natane yuyukngae kuutgan akaayak. ");
INSERT INTO wnc_vpl VALUES ("PS119_169","020_119_169","PSA","119","169","169","Buyambam tapa, gata na gatangamiakge yawa natapso. Gata natdetdeu take namuya. Unzing tupa gika gwa naniwi kekekakut taknga. ");
INSERT INTO wnc_vpl VALUES ("PS119_170","020_119_170","PSA","119","170","170","Sike maakga tumuk wamma ganiwitde tewi apsok. Tewi apan na gika atanangge tupa gwa yakuyak saak gatu tapso. ");
INSERT INTO wnc_vpl VALUES ("PS119_171","020_119_171","PSA","119","171","171","Gata mama wamba kuut sikngae atnanindamukgayak. Unzingge nata umanda asinggan yatangenawit. ");
INSERT INTO wnc_vpl VALUES ("PS119_172","020_119_172","PSA","119","172","172","Nata kau takngatu mama wambae taiwit. Dasingge, gatane mama wamba noman gan siknga. ");
INSERT INTO wnc_vpl VALUES ("PS119_173","020_119_173","PSA","119","173","173","Na gatane mama wamu atawanggat. Unzingge gata gatangamunangge asinggan tandakngayo. ");
INSERT INTO wnc_vpl VALUES ("PS119_174","020_119_174","PSA","119","174","174","Buyambam tapa, natane musipmaatang gata na tapiakge kwanamu sikgak. Siwan na mama wambae natake apbaknganggat. ");
INSERT INTO wnc_vpl VALUES ("PS119_175","020_119_175","PSA","119","175","175","Gata kayuk yutnanga aknga atnamuyo. Namina nata gatane umanda yatangenawit. Sike na gatane wam takngata na kekekangamikge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS119_176","020_119_176","PSA","119","176","176","Sike na kepi noman taknga sipsip gwenda ginikakut binga tekum. Unzingge gata asiknga apu nae nawamso. Puya aminda tapakaen. Dasingge, na gikan mama wamba dua teat. ");
INSERT INTO wnc_vpl VALUES ("PS120_1","020_120_1","PSA","120","1","1","Meya takngatuta nae apanu na Buyambam tapae yatawanggat. Yatawamba ita tumuk wamma natake gatangamunggak. ");
INSERT INTO wnc_vpl VALUES ("PS120_2","020_120_2","PSA","120","2","2","Sike tumuk wamu anzing yanggat, “Buyambam tapa, gatangamuyo. Aminu kunduta kem wamu nae yake na tandambanutnang,” ngang yanggat. ");
INSERT INTO wnc_vpl VALUES ("PS120_3","020_120_3","PSA","120","3","3","Ginu kem amin, Anututa ginde mina binga tasiwik? Ita meya dasing binga damik? ");
INSERT INTO wnc_vpl VALUES ("PS120_4","020_120_4","PSA","120","4","4","Sike itanu amak amindane sakutnata dapik. Siwan katapaimu toknga siknga take dasipa maining. ");
INSERT INTO wnc_vpl VALUES ("PS120_5","020_120_5","PSA","120","5","5","Na gin banakan wai yuat. Sike wai wa yuwau keu komdu Mesek gatu Kedarde banakan binga yupmainggat. ");
INSERT INTO wnc_vpl VALUES ("PS120_6","020_120_6","PSA","120","6","6","Na tupata amin noman yutnangge dua sikaingkat yukumang. Siwan tapduu mamaya siknga siwan na meya nataat. ");
INSERT INTO wnc_vpl VALUES ("PS120_7","020_120_7","PSA","120","7","7","Sike nata nomangan yutnangge nataat. Siwan nata noman yutnimde yaniwa nataaing ngana waaminda amak tasinangge yakaing. ");
INSERT INTO wnc_vpl VALUES ("PS121_1","020_121_1","PSA","121","1","1","Nata tawan dakandakaatang katakunggat. Siwan ngana aminu na gatangamunanga apa zandangga apan kawit? ");
INSERT INTO wnc_vpl VALUES ("PS121_2","020_121_2","PSA","121","2","2","Buyambam tapata yekapat kepat pasike pekut tapanin. Ita ina siknga na gatangamunggak. ");
INSERT INTO wnc_vpl VALUES ("PS121_3","020_121_3","PSA","121","3","3","Sike ita ga dua gandutewan pimamsa. Waapa dapuna dua pekgak, ga atoikgak kapanin. ");
INSERT INTO wnc_vpl VALUES ("PS121_4","020_121_4","PSA","121","4","4","Siakan! Ita Isrel nana amin toike waapa dapunu dua pekgak. Wena siknga. ");
INSERT INTO wnc_vpl VALUES ("PS121_5","020_121_5","PSA","121","5","5","Buyambam tapata ga kakuya tasinggak. Ita gae wesim yuke gepa binga dakngake ganduyuak. Ita gepa binga gae wesim dakngake yuak. ");
INSERT INTO wnc_vpl VALUES ("PS121_6","020_121_6","PSA","121","6","6","Sike gunzitda ga toknga siknga dua gasiwik. Siwan zikaane yekapda akoke ga dua tasiwan maiya. ");
INSERT INTO wnc_vpl VALUES ("PS121_7","020_121_7","PSA","121","7","7","Buyambam tapata ga kakuya tasiwawan sanga waita ga dua tasiwan maiwiyak. Ngan, ita gae kakuya tasike ganduyuwik. ");
INSERT INTO wnc_vpl VALUES ("PS121_8","020_121_8","PSA","121","8","8","Sike gata yotda teke kuwinu Buyambam tapata ga kakuya atasiwik. Ge gatuka asapinu ita ga kakuya atasiwik. Apman gatu masan masanu asinggan ganduyuwik. ");
INSERT INTO wnc_vpl VALUES ("PS122_1","020_122_1","PSA","122","1","1","Naat aminu kundu Buyambam tapatane yotna buyambam gwene kuna ngang nanikingkat unekan gatake kuke musip gwaang siknga natapbumang. ");
INSERT INTO wnc_vpl VALUES ("PS122_2","020_122_2","PSA","122","2","2","Siwan Jerusalemu gwa kundoke itane daman gwen yapbike yoon saak yuamang. ");
INSERT INTO wnc_vpl VALUES ("PS122_3","020_122_3","PSA","122","3","3","Sike Jerusalem yot gapmane yot gwegwenu wesim wesim mitapbing. ");
INSERT INTO wnc_vpl VALUES ("PS122_4","020_122_4","PSA","122","4","4","Isreldane dongu Buyambam tapae gaak ininangge une kokaing. Tupa gata unzing tasiningge gwa yaniwi kekekakut. ");
INSERT INTO wnc_vpl VALUES ("PS122_5","020_122_5","PSA","122","5","5","Sike you wam yaya wagwekatangu kingu Devitdane dongune nanata undang yuke wamu natake papan nomatakaing. ");
INSERT INTO wnc_vpl VALUES ("PS122_6","020_122_6","PSA","122","6","6","Ginu tumuk wam yake Jerusalem nanata kwikwiknga yutningge yanong. Ginda anzing yanong, “Aminbamu Jerusalemde take siknga nataaingu take yutning,” ngang yanong. ");
INSERT INTO wnc_vpl VALUES ("PS122_7","020_122_7","PSA","122","7","7","Yake aminu damanda takumbasiwan Jerusalem patang banakan yutningu amaknga wena take yutningge tumuk wam yanong. Ngan, king kapaat gatu tupan aminu une nana ngangu take yutning. ");
INSERT INTO wnc_vpl VALUES ("PS122_8","020_122_8","PSA","122","8","8","Na notnaat gatu akgatangamukaing katde natake nata Jerusalemde anzing yawit, “Ga amaknga wena take yuyo,” ngang yawit. ");
INSERT INTO wnc_vpl VALUES ("PS122_9","020_122_9","PSA","122","9","9","Na Anutu, Buyambam tapanindane yotna buyambam gwende natanggamatake nata tumuk wam yawa you wanggapmatane sangabamu takekan yutning. ");
INSERT INTO wnc_vpl VALUES ("PS123_1","020_123_1","PSA","123","1","1","Buyambam tapa, gata king kapa yekaune yuwi nata ga ganduke banip singgat. ");
INSERT INTO wnc_vpl VALUES ("PS123_2","020_123_2","PSA","123","2","2","Puya aminu wawi tapaapata aminu puya gwapak yuakge kake banip siwawa, gatu maya apaapata aminu puya gwapak dakngake yuak kapae kake banip sikaing. Ina unzakan, nin kaya baniu Buyambam tapa, nindane Anutunin dekan, sikamang. Sike ita musip kwikwik natanimikge kai takamang. ");
INSERT INTO wnc_vpl VALUES ("PS123_3","020_123_3","PSA","123","3","3","Buyambam tapa, gata musip kwikwiu ninde natapso. Ngan, gata musip kwikwiu ninde asiknga natanimuyo. Dasingge, aminu kunduta ninde asinggan ninisapdukaking. ");
INSERT INTO wnc_vpl VALUES ("PS123_4","020_123_4","PSA","123","4","4","Sike sangana bambanda ninde sapdut wamu tupata ninitakakopbing. Siwawan yamandet aminda asinggan niipakepukaing. ");
INSERT INTO wnc_vpl VALUES ("PS124_1","020_124_1","PSA","124","1","1","Ginu Isrel nana amin, ginda wamu anzing yanong, “Buyambam tapata dua gatanimunggak gamu dasing siwan? ");
INSERT INTO wnc_vpl VALUES ("PS124_2","020_124_2","PSA","124","2","2","Sike Buyambam tapata dua gatanimukut gamu musiptok natapbing takngane ninu asiknga pasiwa mainam. ");
INSERT INTO wnc_vpl VALUES ("PS124_3","020_124_3","PSA","124","3","3","Ngan. Tupa, aminda musiptou ninde natanimuke amau ninkatang tasiking. ");
INSERT INTO wnc_vpl VALUES ("PS124_4","020_124_4","PSA","124","4","4","Sike manggamu yanggata binga paptake apu ninu pakuuwan, ba yanggata binga paku sopuwan. ");
INSERT INTO wnc_vpl VALUES ("PS124_5","020_124_5","PSA","124","5","5","Siwan apaptakuu kekeknga waakngata manggamu ninu kaipake kuwan gwa kumnam. Siwan ngana wena. ");
INSERT INTO wnc_vpl VALUES ("PS124_6","020_124_6","PSA","124","6","6","Unzingge ninda Buyambamtapa gaak kaknga asiknga inimbaknganim. Ita ninu dua nindupewan iwaninda nisipa kumbumang. ");
INSERT INTO wnc_vpl VALUES ("PS124_7","020_124_7","PSA","124","7","7","Ninu kwait gwenda bungeu yapundu aminu tapatuta tasike tekutna kake bepmake kukut binga peke kukumang. Sike yapau wagwenu gwa dakngakutde ninu undangga akoke kukumang. ");
INSERT INTO wnc_vpl VALUES ("PS124_8","020_124_8","PSA","124","8","8","Buyambam tapa, yekapat gatu kepat pasike pekut tapata, ninu ina gatanimunggak.” ");
INSERT INTO wnc_vpl VALUES ("PS125_1","020_125_1","PSA","125","1","1","Sike aminu Buyambam tapae banip sikaingu, waaminu tawanu Saion daka binga. Tawanu wandaka miyamunu dua siknga singgak. Kekeknga siknga yuak. ");
INSERT INTO wnc_vpl VALUES ("PS125_2","020_125_2","PSA","125","2","2","Sike tawanu Jerusalem takumbasike yuaing. Ina unzakan, apman gatu masande Buyambam tapata aminabamu unzakan pakubasike kakuya pasiwik. ");
INSERT INTO wnc_vpl VALUES ("PS125_3","020_125_3","PSA","125","3","3","Anututane aminabamdane kepna wai aminda asinggan dua kayutningunin. Sike unzing tasiwanu asikaya Anututane aminabamu puya waiaknga atasiningunin. ");
INSERT INTO wnc_vpl VALUES ("PS125_4","020_125_4","PSA","125","4","4","Buyambam tapa, gata takeakngaka take amindae atasiyamuyo. Waaminu gikane mama wamu atawakaing. ");
INSERT INTO wnc_vpl VALUES ("PS125_5","020_125_5","PSA","125","5","5","Siwan ngana aminu kundu kepi gutonga aknga aknga tawake gatane noman taknga ateaingu Buyambam tapata yanikwasiwan kuning. Waaminkat gatu aminu inane waiakngana tawakaingkat yanikwasiwan kuning. Isrel nana aminda musip kwikwik takngane yutnong. ");
INSERT INTO wnc_vpl VALUES ("PS126_1","020_126_1","PSA","126","1","1","Aminu kunduta kauutde pewan maikumang. Siwan ngana tapduu Buyambam tapata Saion gatu ninipakapbut kopatangu ninda anzing natapbumang. Mia moo ba kaamang ngang natapbumang. ");
INSERT INTO wnc_vpl VALUES ("PS126_2","020_126_2","PSA","126","2","2","Unzingge ninda minu kumzang mikumang. Mike kap taiyuuk kumzang bakngakumang. Siwan katum aminu kepna kepna nana aminda kake anzing yaking, “Buyambam tapata Isrel nana gatayamunangge puya buyambam siknga tasikut,” ngang yaking. ");
INSERT INTO wnc_vpl VALUES ("PS126_3","020_126_3","PSA","126","3","3","Siakande siknga. Buyambam tapata nin gatanimunangge puya buyambam siknga tasikut. Unzingge ninu musip gwaang siknga nataamang. ");
INSERT INTO wnc_vpl VALUES ("PS126_4","020_126_4","PSA","126","4","4","Buyambam tapa, gata ninu tupa yukumang binga apman kaya ina unzakan yutnimde gata gatanimuyo. Sike wa unzing gapma zongaatang nana wawaa siwan ngana keu waomune yangga apaapa akoke zipmake kukaing binga siyok. ");
INSERT INTO wnc_vpl VALUES ("PS126_5","020_126_5","PSA","126","5","5","Sike aminu kwanamna siyuuk nanam zak kwainingu, waakwau damana gwa siningu kuku apbakngake pakapuyuuk kap taining. ");
INSERT INTO wnc_vpl VALUES ("PS126_6","020_126_6","PSA","126","6","6","Siakande siknga. Aminu kwanamna siyuuk nanam zaknga utnake kwaiwiu, masande nanamu damana gwa siningu kuku utnake ataibakngayuuk pakapik. ");
INSERT INTO wnc_vpl VALUES ("PS127_1","020_127_1","PSA","127","1","1","Buyambam tapata you dua mitapanu kamundata apme mitapnangge tasiwan maiwik. Ina unzakan, Buyambam tapata you gapmandu kakuya dua tasiwanu, kakuya tasikaingga moo apme kayutning. ");
INSERT INTO wnc_vpl VALUES ("PS127_2","020_127_2","PSA","127","2","2","Siwan ninda tembana enake puya toknga tasikana kuku zikaa siwan moni gatu nanam ngang pakamang. Ngana asikaya ninda toknga bamu moo ba tasikamang? Dasingge? Anututa yuwatakau aminu ie take siknga nataaingge ayamunggak. ");
INSERT INTO wnc_vpl VALUES ("PS127_3","020_127_3","PSA","127","3","3","Anututa ninde take tasinimuke ninde waatdaka musip gwaangge moo nimunggak. Ngan, waatdaka wa nimunggau Anututa kwikwiknga take siknga akngana ninde natanimuke nimunggak. ");
INSERT INTO wnc_vpl VALUES ("PS127_4","020_127_4","PSA","127","4","4","Sike aminu tapatutane waaknga wawiapa wa unzing amak aminu tapatuta sakuu katakngata panggak binga. ");
INSERT INTO wnc_vpl VALUES ("PS127_5","020_127_5","PSA","127","5","5","Siwan aminu tapatu waaknga wawi kwaapzang siwanu, ita apbakngayok. Dasingge, waaknga waakwakga nanoknga iwanaat kot yakaing komune yawanu, apme gatangamuke yaning. Gatangama nanokngata kou yawiu wai dua siwik. ");
INSERT INTO wnc_vpl VALUES ("PS128_1","020_128_1","PSA","128","1","1","Aminu Buyambam tapae akgwauke ie wam tawakaingu waaminda apbaknganong. ");
INSERT INTO wnc_vpl VALUES ("PS128_2","020_128_2","PSA","128","2","2","Unzingge puya pasiwawi buyana une aawan kake nanam ba moni pake sanga dapmanggaau usiya. Siwan sanga gata tasiwiyau takekan siwan kake ga apbakngaya. ");
INSERT INTO wnc_vpl VALUES ("PS128_3","020_128_3","PSA","128","3","3","Gatane maatda yotdane yuyuuk ita nap takngatu tapuyana asinggan aakaing binga siwik. Siwan gatane waatdakaka olivdane zakngita binga tebol dakane pukwike nanam nakaing komune takumbasining. ");
INSERT INTO wnc_vpl VALUES ("PS128_4","020_128_4","PSA","128","4","4","Siakande siknga. Aminu Buyambam tapae wam gwaamuke tawambiu, sanga take siknga aknga unzing binga papik. ");
INSERT INTO wnc_vpl VALUES ("PS128_5","020_128_5","PSA","128","5","5","Buyambamtapa Saion yuak kapata ga take apme tasiwikge take nataat. Ga keu andakane yuwiak kopatangu sanga Jerusalem nana kawi take siknga siningge take nataat. ");
INSERT INTO wnc_vpl VALUES ("PS128_6","020_128_6","PSA","128","6","6","Sike ga tape mamayasim yuke bapuka masan aatningu akawiakge nataat. Isrel nana musip kwikwik kakngane take yutningge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS129_1","020_129_1","PSA","129","1","1","Nata natapanu ginu Isrel nana aminu inandek inandek anzing yaning, “Tupa waatdaka apa yukuuyauneta apu apman iwanata na atasiwan mainggat,” ngang yawiyakge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS129_2","020_129_2","PSA","129","2","2","Ngan, ga anzing yayo, “Tupa waatdaka yukumune iwanata na atasiwan maikum,” ngang apman kaya ina unzakan. Siwan ngana dua napbiking, ngang yawiyakge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS129_3","020_129_3","PSA","129","3","3","Sike nap takngata ngwipzang siknga ipmapa nuwan masanaatang gupma atdakngaking. Siwan wata mamaya aknga siwa puya ganzik binga sikaing. ");
INSERT INTO wnc_vpl VALUES ("PS129_4","020_129_4","PSA","129","4","4","Siwan ngana Buyambamtapa noman siknga. Ita na gatangamuke nau na tanggaganukut taknga apasiwaike wai aminde kataune gwa sandeke takut. ");
INSERT INTO wnc_vpl VALUES ("PS129_5","020_129_5","PSA","129","5","5","Sike nata aminu Saionde iwana dakngakaingunin yapbitnimde nataat. Yapbike yawapena apmaakake yotna datakuning. ");
INSERT INTO wnc_vpl VALUES ("PS129_6","020_129_6","PSA","129","6","6","Nata natapa waakwau zongazonga yot dum tapane akokaing binga siningge nataat. Zongazonga waakwau keu wena komune yuke zet siknga kupiakaing. ");
INSERT INTO wnc_vpl VALUES ("PS129_7","020_129_7","PSA","129","7","7","Aminu tapatuta zongazonga wa unekanu dua pakapu peak. Aho, unekanu dua wamake gwaamupake kuwik. ");
INSERT INTO wnc_vpl VALUES ("PS129_8","020_129_8","PSA","129","8","8","Sike aminu wai waakwau inengan kuke anzingu dua yawam, “Buyambam tapata ginde apme pasiwan take sining. Sike Buyambam tapae umande danina sanga takeakngatakan ginde apning,” ngang kayan ma yawam. ");
INSERT INTO wnc_vpl VALUES ("PS130_1","020_130_1","PSA","130","1","1","Buyambam tapa, na meyambam pake nata gae yanggamatanggat. ");
INSERT INTO wnc_vpl VALUES ("PS130_2","020_130_2","PSA","130","2","2","Buyambam tapa, nata gae kwanam sikgawanggatde natapso. Gata butaya natangamuke gatangamiakge yanggatde maak papso. ");
INSERT INTO wnc_vpl VALUES ("PS130_3","020_130_3","PSA","130","3","3","Sike gata nindane waiaknganin kendewiak kopatangu mamin amin tapata wam yananga tapduk gwene kekekake gapbimbik? Wena. ");
INSERT INTO wnc_vpl VALUES ("PS130_4","020_130_4","PSA","130","4","4","Siwan ngana gata nindane waiaknganinu asandekgayak. Unzingge ninda gae asiknga gwautnim. ");
INSERT INTO wnc_vpl VALUES ("PS130_5","020_130_5","PSA","130","5","5","Sike na Buyambam tapata siknga gatangamikge take siknga nataat. Unzingge na ie kayuat. Sike na itane wam takngae baniu asinggat. ");
INSERT INTO wnc_vpl VALUES ("PS130_6","020_130_6","PSA","130","6","6","Aminu kakuya zikaane tasikaing aminda tapduk gwenu zet kwakawikge natayuwawa semna singgak. Siwan na Buyambam tapaekan kayuat. Siwan ita gatangamikge siknga natayuwawa semna siknga singgak. ");
INSERT INTO wnc_vpl VALUES ("PS130_7","020_130_7","PSA","130","7","7","Ginu Isrel amin, ginda baniu Buyambam tapae asiknga sinong. Dasingge, ita ginde asingganu take siknga natandamunggak. Sike ita gatandamuwawan meya takngatuta asingganu dua pasiwan mainingge nataak. ");
INSERT INTO wnc_vpl VALUES ("PS130_8","020_130_8","PSA","130","8","8","Ita inane aminabamu apme papik. Wa ninu Isrel nana unin. Ita ninu pakenga waiaknganinu kuukgan sandetnimik. ");
INSERT INTO wnc_vpl VALUES ("PS131_1","020_131_1","PSA","131","1","1","Buyambam tapa, na yamandet taknga tasikumu gwa teke musipmaatangu umana nina dua yatangenakgat. Aho, na aminu kundue natapa moo aminu unin ngangu dua nataat. Siwan na natdetdet buyambam pakaing aminda nataaing kaknga binga na dua nataat. Dua natake sanga nangaakande dua nataatde kuut ina unzakan. ");
INSERT INTO wnc_vpl VALUES ("PS131_2","020_131_2","PSA","131","2","2","Siwan ngana na take yuke musip kwikwikgan pake yuat. Na unzing engangu mingae kataune kwikwiknga pekgak binga. Ngan, natane musipma kwikwiknga unzing yuak. ");
INSERT INTO wnc_vpl VALUES ("PS131_3","020_131_3","PSA","131","3","3","Ginu Isrel amin, ginu Buyambam tapae banip sinong. Apman gatu masan yutnim kaya ina unzakan. ");
INSERT INTO wnc_vpl VALUES ("PS132_1","020_132_1","PSA","132","1","1","Buyambam tapa, gata Devitde meya kuupbamu ita kakutde dua botawim. ");
INSERT INTO wnc_vpl VALUES ("PS132_2","020_132_2","PSA","132","2","2","Devitda wamu takngatu Anutue natake yawan kekekakut. Ngan, ita Isrel amindane kekeknga sikngaapae natake wamu waaknga yawan kekekakut. ");
INSERT INTO wnc_vpl VALUES ("PS132_3","020_132_3","PSA","132","3","3","Ita anzing yakut, “Na yotnane dua koke paku dua siknga pewit. ");
INSERT INTO wnc_vpl VALUES ("PS132_4","020_132_4","PSA","132","4","4","Aho, na dua yuwa takawan dapunu pewit. Wena siknga. ");
INSERT INTO wnc_vpl VALUES ("PS132_5","020_132_5","PSA","132","5","5","Tupanu you gwendu Buyambam tapata une yuwik gwende gambok tawake kawit. Anutu kekeknga Isrel nana apa paku undang yuwik. Siwan na masan yuwa takawik.” ");
INSERT INTO wnc_vpl VALUES ("PS132_6","020_132_6","PSA","132","6","6","Sike ninu Epratah yot gapmane yuke pukit takwanu buyambam tapatane gwende natapbumang. Sike ninda kawatna Jardane kep komune yuwawan kakumang komune yukut. ");
INSERT INTO wnc_vpl VALUES ("PS132_7","020_132_7","PSA","132","7","7","Ninda Buyambam tapatane you buyambam gwene kuna. Ninda wesim kuke ayuak komune munu puke gwetake gaau inina, ngang yawa natapbumang. ");
INSERT INTO wnc_vpl VALUES ("PS132_8","020_132_8","PSA","132","8","8","Buyambam tapa, ga enake apuke keu yuwi takananga komune pukuyuyo. Sike gatane pukit takwanu gikane kekekngaka undang yuau une yuke apso. ");
INSERT INTO wnc_vpl VALUES ("PS132_9","020_132_9","PSA","132","9","9","Nata natapa gata pris gikane apaapata tauknga pasike nomanu asinggan asinggan tasiningge nataat. Nomanu waaknga unzing, tauk take pasikaing binga. Sike gikane aminbamda yanggamatake baknganingge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS132_10","020_132_10","PSA","132","10","10","Buyambam tapa, gata Devit tapi tupan amin tapaka dakngakut. Siwan gikane puya amindae natake masa ma imim. ");
INSERT INTO wnc_vpl VALUES ("PS132_11","020_132_11","PSA","132","11","11","Buyambam tapata tupa wamu kekeknga takngatu Devitde yawan kekekakuu dua sandewik. Siwan wamu anzing yakut, “Nata tasiwa gatane dongune nana tapatuta king dakngawik. Kingu waapata gae tangge yuwik,” ngang yakut. ");
INSERT INTO wnc_vpl VALUES ("PS132_12","020_132_12","PSA","132","12","12","“Sike gatane waakga akwau nata yawa kekekakut taknga tawake gatu mama wamu nata yamukum taknga tawambanu, itane waaknga masan aatning kaya king daknganing. Ina unzakan masan kaya unzakan siwik,” ngang yawan kekekakut. ");
INSERT INTO wnc_vpl VALUES ("PS132_13","020_132_13","PSA","132","13","13","Dasingge, Buyambam tapata Saionu natane yotbam gapmana ngangu gwa yawan yukut. Unzingge ita waomune asinggan yutnangge nataak. ");
INSERT INTO wnc_vpl VALUES ("PS132_14","020_132_14","PSA","132","14","14","Ita anzing yakut, “Na yotbam anggapmane asinggan asinggan yuwit. Nata you anggapma king kapa yuwitde gwa yakum,” ngang yakut. ");
INSERT INTO wnc_vpl VALUES ("PS132_15","020_132_15","PSA","132","15","15","Sike nata sanga kwaapzang you Saion gapmane nanae yama waakwau sangae dua dapning. Ngan, nanamu kundu atdapmakaingge yama akgitnawan yutning. ");
INSERT INTO wnc_vpl VALUES ("PS132_16","020_132_16","PSA","132","16","16","Siwan nata pris Sion yuaing aminde puya yama aminbamu gatuna apanggat takngae aminbam yanikapning. Siwana natane aminabamu wanggapmane nana apbakngake kap taining. ");
INSERT INTO wnc_vpl VALUES ("PS132_17","020_132_17","PSA","132","17","17","Nata Devitdane dongune nana tapatu tapa ita kingu you wa gapmane dakngake yuak. Siwan itane dongu puya aakngae tangge songa dua siwik. ");
INSERT INTO wnc_vpl VALUES ("PS132_18","020_132_18","PSA","132","18","18","Siwan nata tasiwa itane iwana maaknga siknga natapning. Siwan ngana ita king kapa yuke kekekanggak kakngata buyambam siknga siwik. ");
INSERT INTO wnc_vpl VALUES ("PS133_1","020_133_1","PSA","133","1","1","Aminu notna notna dakngake aminda unekan take yuke musipna gwendukan teke notna siknga daknganingu, wa take siknga. ");
INSERT INTO wnc_vpl VALUES ("PS133_2","020_133_2","PSA","133","2","2","Sanga waaknga unzing, katau oliv dakane yangga waenga kaya aknga Arondane gwapakngane tukngwaking binga. Tukngwamban aamnane epuke gen danggamna mamaya aknganeta pimake tauknga nomna dakngane pukukut. ");
INSERT INTO wnc_vpl VALUES ("PS133_3","020_133_3","PSA","133","3","3","Sike sanga musipna gwendukan yutnanga aknga wa unzing, yekap piokga tawanu Hermon dakane gatu tawanu Saion dakane pimakaing binga. Dasingge, keu waomune Buyambam tapata musia gwendukan teke yuaingu take pasinggak. Pasike ita kayuk asinggan asinggan yutnanga akngana ayamunggak. ");
INSERT INTO wnc_vpl VALUES ("PS134_1","020_134_1","PSA","134","1","1","Ginu Buyambam tapatane puya amina kuupbam, itane you buyambam gwene zikaane puya pasikaingu, ginda itane umana asiknga initangenatnong. ");
INSERT INTO wnc_vpl VALUES ("PS134_2","020_134_2","PSA","134","2","2","Ginda itane you buyambam gwekatang yuke katakza tangenayuuk tumuk wamu kekeknga yake itane umana initangenatnong. ");
INSERT INTO wnc_vpl VALUES ("PS134_3","020_134_3","PSA","134","3","3","Buyambam tapata yekapat kepat pasikut. Nata natapa waapata Saion dakane yuke ginde take pasiwikge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS135_1","020_135_1","PSA","135","1","1","Buyambam tapatane umana yatangenatnong. Ginu Buyambam tapatane puya amina, ginda itane umana initangenatnong. ");
INSERT INTO wnc_vpl VALUES ("PS135_2","020_135_2","PSA","135","2","2","Ginu Buyambam tapatane you buyambam gwende yuke puyana pasikaingu, wa Anutunindane you buyambam gwene yuke umana initangenatnong. ");
INSERT INTO wnc_vpl VALUES ("PS135_3","020_135_3","PSA","135","3","3","Itane umana yatangenatnong. Dasingge, ita ninde take siknga pasinggak. Ita ninde musip kwikwik natanimunggak. Unzingge ninda kap taike itane umana yatangenatnim. ");
INSERT INTO wnc_vpl VALUES ("PS135_4","020_135_4","PSA","135","4","4","Sike Buyambam tapata Jekop inae yawan yukut. Ngan, Isrel nana aminu Anututane donga siknga. ");
INSERT INTO wnc_vpl VALUES ("PS135_5","020_135_5","PSA","135","5","5","Nata natapanu Buyambamtapa umana kopsa siknga. Sike ita anutu pupuknga ayapbike enane siknga yuak. ");
INSERT INTO wnc_vpl VALUES ("PS135_6","020_135_6","PSA","135","6","6","Buyambam tapata sanga minaka takngatu yekaune gatu keune gatu yanggabam gwene ba yanggabam gwende kutakngine tasinangge natakengu ita atasinggak. ");
INSERT INTO wnc_vpl VALUES ("PS135_7","020_135_7","PSA","135","7","7","Ita sopa tawikge minga kepna kepna kuupbam tasiwan aakgak. Siwan ita tasiwan yapasik siwawan sopa tanggak. Siwan gatu ita tasiwan got takngata gwatdu gwatdu puyatake kunggak. ");
INSERT INTO wnc_vpl VALUES ("PS135_8","020_135_8","PSA","135","8","8","Ngan, Isip kep komune ita Isip nanatane waaknga tupan tapaapa atzipa kumbing. Siwan gatu kaapdane ngang zipa kumbing. ");
INSERT INTO wnc_vpl VALUES ("PS135_9","020_135_9","PSA","135","9","9","Siwan Isip kep komune duya takngatu takngatu tasiwan king kapaat gatu tupan aminaatda kawawa kekekngana une yeuyamukut. ");
INSERT INTO wnc_vpl VALUES ("PS135_10","020_135_10","PSA","135","10","10","Siwana ita keu kundune nana pasiwan maiking. Ngan, kingu kekeknga apaapa atzipa kumbing. ");
INSERT INTO wnc_vpl VALUES ("PS135_11","020_135_11","PSA","135","11","11","Ngan, ita Sihon tanguwan kumbut. Kingu waapa Amor nana amindane. Gatu Ok, Basan nanatane king kapa, gatu Kenan kep komune nana kingu kuupbam zipa kumbing. ");
INSERT INTO wnc_vpl VALUES ("PS135_12","020_135_12","PSA","135","12","12","Siwan ita kingu waakwakgane kepna pake inane aminabamde yamukut. Wa Isrel nana unin. ");
INSERT INTO wnc_vpl VALUES ("PS135_13","020_135_13","PSA","135","13","13","Buyambam tapa, asingganu aminbamda gae natapanu Anutu siakan tapa unin ngang nataing. Siwan masan aatning kaya gae waakngakan natapning. ");
INSERT INTO wnc_vpl VALUES ("PS135_14","020_135_14","PSA","135","14","14","Dasingge, Buyambam tapata aminabam gatayaman kepi noman taknga tawake tasining. Tasiwawa kake aminu kundu iwana akwak ngana waakwakge natapa amin noman siwik. Unzingge ita inane puya aminae butaya natayamik. ");
INSERT INTO wnc_vpl VALUES ("PS135_15","020_135_15","PSA","135","15","15","Sike katum aminda anutu pupukngana silwaat gatu gol katda pasiking. Aminu waakwakga anutu pupukngana katakngita tumuke pasipeking. ");
INSERT INTO wnc_vpl VALUES ("PS135_16","020_135_16","PSA","135","16","16","Sike anutu pupuknga waakwau gena kaya, ngana wamu yananga dua. Siwan kaina kaya, siwan ngana sanga kananga dua. ");
INSERT INTO wnc_vpl VALUES ("PS135_17","020_135_17","PSA","135","17","17","Siwan waakwau maaknga kaya, siwan ngana sanga natapnanga dua. Siwan nomna ganang yawan kopnanga dua. ");
INSERT INTO wnc_vpl VALUES ("PS135_18","020_135_18","PSA","135","18","18","Aminu anutu pupuknga wa pasike peke baniu sanga wande sikaingu, anutu pupuknga waakwak binga daknganing. ");
INSERT INTO wnc_vpl VALUES ("PS135_19","020_135_19","PSA","135","19","19","Ginu aminu Isrel nana, Buyambam tapatane umana yatangenatnong. Ginu Buyambam tapatane prisnan, Buyambam tapatane umana yatangenatnong. ");
INSERT INTO wnc_vpl VALUES ("PS135_20","020_135_20","PSA","135","20","20","Ginu dongu Liwai tanen, Buyambam tapatane umana yatangenatnong. Ginu Buyambam tapae akgwaukaing aminun, itane umana yatangenatnong. ");
INSERT INTO wnc_vpl VALUES ("PS135_21","020_135_21","PSA","135","21","21","Ginu aminu Saion yuaingun, wa Jerusalem. Buyambamtapa you wanggapmane yuak kapanin. Itane umana yatangenatnong. ");
INSERT INTO wnc_vpl VALUES ("PS136_1","020_136_1","PSA","136","1","1","Ginda Buyambam tapae asiknga inimbaknganong. Dasingge? Ita take siknga tasinggak kapanin. Asinggan asinggan siknga ita ginde musip gwaang siknga natandamuke yuak. ");
INSERT INTO wnc_vpl VALUES ("PS136_2","020_136_2","PSA","136","2","2","Ginda Buyambam tapae asiknga inimbaknganong. Ita anutu pupuknga apaapa gwa yapbikut. Asinggan asinggan ita ginde musip gwaang siknga natandamuke yuak. ");
INSERT INTO wnc_vpl VALUES ("PS136_3","020_136_3","PSA","136","3","3","Ginda Buyambam tapae asiknga inimbaknganong. Waapa aminu tupan tapa apatane Buyambam tapana unin. Asinggan asinggan ita ninde musip gwaang siknga natanimuke yuak. ");
INSERT INTO wnc_vpl VALUES ("PS136_4","020_136_4","PSA","136","4","4","Wa awiaapatakan duya buyambam takngatu takngatu asinggan asinggan pasinggak kapanin. Asinggan asinggan ita ninde musip gwaang siknga natanimuke yuak. ");
INSERT INTO wnc_vpl VALUES ("PS136_5","020_136_5","PSA","136","5","5","Inane natdetdetnaneta ena yekap gwekat gatu sanga wagwene yuaingkat pasike pekut. Asinggan asinggan ita ninde musip gwaang siknga natanimuke yuak. ");
INSERT INTO wnc_vpl VALUES ("PS136_6","020_136_6","PSA","136","6","6","Ita kepdaka engatangan tasike teke gatu yangga amaakatang pasike pekutde natake inimbaknganong. Asinggan asinggan ita ninde musip gwaang siknga natanimuke yuak. ");
INSERT INTO wnc_vpl VALUES ("PS136_7","020_136_7","PSA","136","7","7","Ita gunzit gatu yekau zikaane kakaa nimunggak gwen ngang pasike pekut. Asinggan asinggan ita ninde musip gwaang siknga natanimuke yuak. ");
INSERT INTO wnc_vpl VALUES ("PS136_8","020_136_8","PSA","136","8","8","Ita gunzit tasiwan akwakanggak ge kuyana yuak. Asinggan asinggan ita ninde musip gwaang siknga natanimuke yuak. ");
INSERT INTO wnc_vpl VALUES ("PS136_9","020_136_9","PSA","136","9","9","Ita tasiwan yekap gatu yekapdaak ngang zikaa dakatane kakuya tasinggak. Asinggan asinggan ita ninde musip gwaang siknga natanimuke yuak. ");
INSERT INTO wnc_vpl VALUES ("PS136_10","020_136_10","PSA","136","10","10","Ita engangu waatdaka Isip kep komune nanatane tupan tapa apa zipa kumbing. Asinggan asinggan ita ninde musip gwaang siknga natanimuke yuak. ");
INSERT INTO wnc_vpl VALUES ("PS136_11","020_136_11","PSA","136","11","11","Ita Isrel nana aminbamu yanipakapan Isip kepkom teke apbing. Asinggan asinggan ita ninde musip gwaang siknga natanimuke yuak. ");
INSERT INTO wnc_vpl VALUES ("PS136_12","020_136_12","PSA","136","12","12","Ngan, inane kekeknga akngananeta waaminu yanipakapbut. Asinggan asinggan ita ninde musip gwaang siknga natanimuke yuak. ");
INSERT INTO wnc_vpl VALUES ("PS136_13","020_136_13","PSA","136","13","13","Ita tasiwan yanggabamu Ret Si gwenu kaukaut wesiwan kukut. Asinggan asinggan ita ninde musip gwaang siknga natanimuke yuak. ");
INSERT INTO wnc_vpl VALUES ("PS136_14","020_136_14","PSA","136","14","14","Ita tupan kuke aminabamu yanipakapan yanggabamu wagwende banakan kuking. Asinggan asinggan ita ninde musip gwaang siknga natanimuke yuak. ");
INSERT INTO wnc_vpl VALUES ("PS136_15","020_136_15","PSA","136","15","15","Ita tasiwan kingu Isip nana apa gatu itane amak amina ngang yangga tangoke kuupbam kumbing. Asinggan asinggan ita ninde musip gwaang siknga natanimuke yuak. ");
INSERT INTO wnc_vpl VALUES ("PS136_16","020_136_16","PSA","136","16","16","Ita tupan kuwawan inane amina keu sanga wena kepban komune tawaking. Asinggan asinggan ita ninde musip gwaang siknga natanimuke yuak. ");
INSERT INTO wnc_vpl VALUES ("PS136_17","020_136_17","PSA","136","17","17","Ita kingu kekeknga yukingu atzipa kumbing. Asinggan asinggan ita ninde musip gwaang siknga natanimuke yuak. ");
INSERT INTO wnc_vpl VALUES ("PS136_18","020_136_18","PSA","136","18","18","Ngan, ita kingu umana kaya apaapa atzipa kumbing. Asinggan asinggan ita ninde musip gwaang siknga natanimuke yuak. ");
INSERT INTO wnc_vpl VALUES ("PS136_19","020_136_19","PSA","136","19","19","Ita Kingu Sihon, Amor yot gapmane nana apa atanguwan kumbut. Asinggan asinggan ita ninde musip gwaang siknga natanimuke yuak. ");
INSERT INTO wnc_vpl VALUES ("PS136_20","020_136_20","PSA","136","20","20","Ita kingu Ok, Basan yot gapmane nana apa tanguwan kumbut. Asinggan asinggan ita ninde musip gwaang siknga natanimuke yuak. ");
INSERT INTO wnc_vpl VALUES ("PS136_21","020_136_21","PSA","136","21","21","Ita kingu waakwakgane kepna kaiwa kuwan inane aminabamde yamukut. Asinggan asinggan ita ninde musip gwaang siknga natanimuke yuak. ");
INSERT INTO wnc_vpl VALUES ("PS136_22","020_136_22","PSA","136","22","22","Ita keu wandaka kaiwan kuwan Isrel nana inane puya amin takwakge yamukut. Asinggan asinggan ita ninde musip gwaang siknga natanimuke yuak. ");
INSERT INTO wnc_vpl VALUES ("PS136_23","020_136_23","PSA","136","23","23","Sike tapduu ninu moo amin yukumang komune ita ninde dua botakut. Asinggan asinggan ita ninde musip gwaang siknga natanimuke yuak. ");
INSERT INTO wnc_vpl VALUES ("PS136_24","020_136_24","PSA","136","24","24","Ita iwaninde kataune kaiwa kuwan pakut. Asinggan asinggan ita ninde musip gwaang siknga natanimuke yuak. ");
INSERT INTO wnc_vpl VALUES ("PS136_25","020_136_25","PSA","136","25","25","Ita aminde gatu kaap zongge ngang kuutde yamunggak. Asinggan asinggan ita ninde musip gwaang siknga natanimuke yuak. ");
INSERT INTO wnc_vpl VALUES ("PS136_26","020_136_26","PSA","136","26","26","Ginda Anutu yekaune yuak kapae asiknga inimbaknganong. Asinggan asinggan ita ninde musip gwaang siknga natanimuke yuak. ");
INSERT INTO wnc_vpl VALUES ("PS137_1","020_137_1","PSA","137","1","1","Ninu keu Babilon komdane yangga kwaimune pukuyuke natdetdet ninu tena Saionde kuwan kwanam sikumang. ");
INSERT INTO wnc_vpl VALUES ("PS137_2","020_137_2","PSA","137","2","2","Sike gitaninu ninda katau wesim yuaing dakandakane mitapekumang. ");
INSERT INTO wnc_vpl VALUES ("PS137_3","020_137_3","PSA","137","3","3","Dasingge, aminu kaautde nipmakingga anzing yaking, “Ginda kap taike pasiwa ninda take natapnimde tainong,” ngang yaking. Ngan, aminu meya waaknga nimukingga anzing yaking, “Kau takngatu Saion nana tainong,” ngang yaking. ");
INSERT INTO wnc_vpl VALUES ("PS137_4","020_137_4","PSA","137","4","4","Siwan ngana Buyambam tapatane kapna dasingge ninda amindane kep komune yuke tainim? Dua siknga tainim. ");
INSERT INTO wnc_vpl VALUES ("PS137_5","020_137_5","PSA","137","5","5","Jerusalem, nata gae apbotanangge dua siknga nataat. Siwan ngana gae apbotawit gamu nata gita atanguwa wai siwik. ");
INSERT INTO wnc_vpl VALUES ("PS137_6","020_137_6","PSA","137","6","6","Jerusalem, nata gae dua ba natapanu, yembinata gatak gatak siwik. Ngan, nata gae musip gwaang siknga dua natapanu guyakngata akupiawan kau takngatu gatu tainanga dua siwik. ");
INSERT INTO wnc_vpl VALUES ("PS137_7","020_137_7","PSA","137","7","7","Buyambam tapa, tapduu iwanata Jerusalem nana yapbiking komune Idom nanata yaking kakngae natapso. Waaminda anzing yanggamataking, “Jerusalemdane yotna kuupbam waitdeke kuut siknga pasina maining,” ngang yaking. ");
INSERT INTO wnc_vpl VALUES ("PS137_8","020_137_8","PSA","137","8","8","Babilon nana aminu natapnong. Aminda ginu asiknga pasiwa maining. Ngan, aminu tapatuta waiaknga ginda ninde tasiking taknga yake waakngakan ginde tasiwiu, aminu waapa apbakngayok. ");
INSERT INTO wnc_vpl VALUES ("PS137_9","020_137_9","PSA","137","9","9","Ngan, aminu gatane engangga pake sup tangan mumba pimake wai siknga zipiu waapata apbakngayok. ");
INSERT INTO wnc_vpl VALUES ("PS138_1","020_138_1","PSA","138","1","1","Buyambam tapa, natane musipmaatang gae gaak wam ganiwitde asiknga kekekanggat. Sike aminu tupan tapaapa yekaune yuaingu kuupbamde kaine nata kau gatane umande yatangenatnangge taiwit. ");
INSERT INTO wnc_vpl VALUES ("PS138_2","020_138_2","PSA","138","2","2","Sike nata muna gatane you buyambam gwende nom saak puke gatane umanda yatangenawit. Dasingge, gata nae take siknga asinggan natangamuke gata sanga tasinangge yawi kekekakut takngakan asinggan tawanggayak. Ngan, gata tasiwi gikane umanda gatu gikane wam ngangu sanga tupan siking. ");
INSERT INTO wnc_vpl VALUES ("PS138_3","020_138_3","PSA","138","3","3","Siwan tapduu nata gae yakum komune gata natane tumuk wama atnatapbuyak. Natake gata gikane kekekngaka nae nami nata kekeknga siknga yuat. ");
INSERT INTO wnc_vpl VALUES ("PS138_4","020_138_4","PSA","138","4","4","Buyambam tapa, nata nataau kingu kepna kepna nana kuupbamda tapduu gatane wamba natapning komune gatane umanda ayatangenatningge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS138_5","020_138_5","PSA","138","5","5","Yatangenake waakwakga kau kepi gata tawake tasinggayakge natake kap tainong. Dasingge, ga umanda kopsa siknga apanin. ");
INSERT INTO wnc_vpl VALUES ("PS138_6","020_138_6","PSA","138","6","6","Buyambamtapa enane siknga apa, siwan ngana aminu yamandeu dua sikaingge gatayamunangge natayak. Siwan ngana ita yamandet aminu peke maa siknga yuke kaak. ");
INSERT INTO wnc_vpl VALUES ("PS138_7","020_138_7","PSA","138","7","7","Sike meya buyambam takngane sukuwanu gata na kakuya tasiwi nata take yuat. Sike iwana aminda nae musiptok nataing ngana gata waaminu atzipmanggayak. Zipmake gikane kekekngane na gatuka tanggayak. ");
INSERT INTO wnc_vpl VALUES ("PS138_8","020_138_8","PSA","138","8","8","Buyambam tapa, gata sanga kuupbamu nae tasinangge yawi kekekakuu gata atasiya ngang natapa kekekanggak. Siwan gata nae asinggan asinggan take siknga natangamunggayak. Sike puya gika pangenakuyau apasiwi dua pimaningge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS139_1","020_139_1","PSA","139","1","1","Buyambam tapa, gata natane musipma gwa usanzike nae asiknga nataayak. ");
INSERT INTO wnc_vpl VALUES ("PS139_2","020_139_2","PSA","139","2","2","Siakan. Sanga nata tasinggau kuupbamu gata atnataayak. Ngan, nata pukuyuwit ba dandam tangan yuwit siwan ngana gata keu komdune maa yukengu sanga tasinangge nataau atnataayak. ");
INSERT INTO wnc_vpl VALUES ("PS139_3","020_139_3","PSA","139","3","3","Ngan, nata epuke kuwit ba dapuna petnangge tasiwit, siwan ngana gata natane yuyuknga kuupbam atnataayak. ");
INSERT INTO wnc_vpl VALUES ("PS139_4","020_139_4","PSA","139","4","4","Buyambam tapa, nata wamu takngatu ba yanangge tasiwanu wamu waaknga gata gambok nataayak. ");
INSERT INTO wnc_vpl VALUES ("PS139_5","020_139_5","PSA","139","5","5","Natake gata na zaneka kuwawanu gata nandukakaike na gikane kekeknga akngane nanduyuwayak. ");
INSERT INTO wnc_vpl VALUES ("PS139_6","020_139_6","PSA","139","6","6","Siwan gatane natdetdetda unzing wa nataayak kaknga enane siknga. Siwan natane natdetdetna ayapbikgak. ");
INSERT INTO wnc_vpl VALUES ("PS139_7","020_139_7","PSA","139","7","7","Siwan nata zane kuke gatane waung kapaka yuwau tewit? Ngan, nata zane datakuke gae kusopuwit? ");
INSERT INTO wnc_vpl VALUES ("PS139_8","020_139_8","PSA","139","8","8","Sike nata yekaune akoke yuwiu, ga yekaune ayuayak. Gatu nata aminu gwa kumbingga yuaingune paku yuwiu gakaya waomune ayuayak. ");
INSERT INTO wnc_vpl VALUES ("PS139_9","020_139_9","PSA","139","9","9","Siwan nata tembana siknga enake kwaitda binga bepmake maa siknga yanggabam gwene kautdu saak komune ba kuwit, ba paku gunzitda akonggaune ba pukunggaune ba kuwit. Ga waomune kuut ayuayak. ");
INSERT INTO wnc_vpl VALUES ("PS139_10","020_139_10","PSA","139","10","10","Ga waomuneaya ayuke kepina tanomanuke gata na katakgata take akgatangamuya. ");
INSERT INTO wnc_vpl VALUES ("PS139_11","020_139_11","PSA","139","11","11","Sike nata gatu anzing ba yawit, “Zikaandakata na takusopuwik. Siwan kakaa gunzitdaneta na takumbasiwanu wa zikaandaka siwik,” ngang yawit. ");
INSERT INTO wnc_vpl VALUES ("PS139_12","020_139_12","PSA","139","12","12","Siwan ngana undanga, gata zikaa wandaka kawi zikaa daka kakaa gunzitda binga isinggak. Zikaandaka kawi kupakupan gunzitda tasinggak binga singgak. Dasingge, zikaandaka gatu kakaa aknga ngangu gae kaine ina unzakan. ");
INSERT INTO wnc_vpl VALUES ("PS139_13","020_139_13","PSA","139","13","13","Siwan gata sanga natane gupma apaatang yuaingu kuupbam gata pasikuyak. Sike gata na mingae musipnaatang yukum komune, natane gupmaat gatu kwatana ngang gata pasike peke tanomanukuyak. ");
INSERT INTO wnc_vpl VALUES ("PS139_14","020_139_14","PSA","139","14","14","Siakan. Duya kekeknga takngatu takngatu pasikuyak binga. Unzingge nata gatane umanda ayatangenakgat. Sangabamu gata pasikuyau inata siknga siwan gwaam siknga. Siwan nata sanga waakngae katak siknga atnataat. ");
INSERT INTO wnc_vpl VALUES ("PS139_15","020_139_15","PSA","139","15","15","Sike tapduu na mingae musipnaatang yukum komune natane gupma ba kwatana kuut gikane kaikane kusopuknga dua yukut. Ngan. Nata mingatane musiaatang kusopuke wepda wepda takakumu gata kaawi kwatana unekan apuke ngwakapan kakuyak. ");
INSERT INTO wnc_vpl VALUES ("PS139_16","020_139_16","PSA","139","16","16","Gata na mingata dua tangaiwawanu gata na atnandupbuyak. Nata keu andakane dua apuwawa nae buu gikane gopatangu nata keu andakane tapdukbamu yuwitde gwa matakuyak. ");
INSERT INTO wnc_vpl VALUES ("PS139_17","020_139_17","PSA","139","17","17","Anutu, gatane natdetdetdae natapa sanga gwaam siknga singgak. Gatane natdetdetda mateknga dua, siwan nata natdetdetdae kepi tawake natdetnanga dua. ");
INSERT INTO wnc_vpl VALUES ("PS139_18","020_139_18","PSA","139","18","18","Sike nata sanga gata nataaunin kendetnangge tasiwanu, saisai yanggabam gwende kwaimune yuaing binga siwik. Kendetnanga dua singgak. Siwan, tapduu nata dapun pesika enakgaunen, gaat naat kuut yuamak. ");
INSERT INTO wnc_vpl VALUES ("PS139_19","020_139_19","PSA","139","19","19","Anutu, nata wai aminu atzipi kumningge nataat. Ngan, ginu aminu amak tasike amin zipa kungwakaing aminu napmake kunong. ");
INSERT INTO wnc_vpl VALUES ("PS139_20","020_139_20","PSA","139","20","20","Aminu waakwakga gae wamu waiaknga yakaing. Ngan, gae umandae wamu wai aknga aknga yakaing. ");
INSERT INTO wnc_vpl VALUES ("PS139_21","020_139_21","PSA","139","21","21","Buyambam tapa, nata aminu gae apbitakaing aminde nakaya apbitanggat. Siwan aminda gae yamandet sikaingge nata musipmaik natayamunggat. ");
INSERT INTO wnc_vpl VALUES ("PS139_22","020_139_22","PSA","139","22","22","Siakande siknga, nata waaminde asiknga bitanggat. Nata waaminu kawa natane iwana singgak. ");
INSERT INTO wnc_vpl VALUES ("PS139_23","020_139_23","PSA","139","23","23","Anutu, gata na katak siknga natdetdetna gatu musipmaatang yuaingu usanzike kayo. Tanzit tasike nata nangaakan nataau kuupbam usanzike kayo. ");
INSERT INTO wnc_vpl VALUES ("PS139_24","020_139_24","PSA","139","24","24","Na katak siknga usanziyo, sanga tasiwa aminda nandupa wai siwik kaknga kundu natdetdet naatang yutnang. Kake gata na nanitakuwi kepi kayuu asinggan yutnanga akngane sukuwit. ");
INSERT INTO wnc_vpl VALUES ("PS140_1","020_140_1","PSA","140","1","1","Buyambam tapa, gata na akgatangami wai aminda dua tasiwan maiwit. Ngan, gata na kakuya katak tasike ma kapewi amak tasikaing aminda na nutning. ");
INSERT INTO wnc_vpl VALUES ("PS140_2","020_140_2","PSA","140","2","2","Asingganu waakwau musiaatangu sanga waiaknga tasinangge nataaing. Ngan, gunzitbamu waakwakga kaanga wamu aminu kunduta amningge yakaing. ");
INSERT INTO wnc_vpl VALUES ("PS140_3","020_140_3","PSA","140","3","3","Waamindane wamna gomokgane gena paanga siknga binga. Sike wamu amin pasiwan mainanga waamindane genaatang doke yuak. Unzing marasinu gomou waiakngatane genane yuak kaknga binga. ");
INSERT INTO wnc_vpl VALUES ("PS140_4","020_140_4","PSA","140","4","4","Buyambam tapa, gata na kakuya katak tasiwinu wai amindane kekeknganata na napbitnanga dua. Ngan, gata na wamanapmambi aminu amak tasikaingga na tasiwan pimapitde yakaingu, nae sanga takngatu dua tasining. ");
INSERT INTO wnc_vpl VALUES ("PS140_5","020_140_5","PSA","140","5","5","Sike yamandet aminu waakwakga na tanggaganutnangge natake yapapna pasike kusopuknga peaing. Ngan, yapapna wa ngwayoknga pasike yuaing. Siwan sanga bungep binga pasike kepiapane nae kaap zong binga umukusipa tasikaing. ");
INSERT INTO wnc_vpl VALUES ("PS140_6","020_140_6","PSA","140","6","6","Buyambam tapa, nata anzing ganinggat, “Ga natane Anutuna. Nata wam yanggat takngae natake gatangamuyo,” ngang ganinggat. ");
INSERT INTO wnc_vpl VALUES ("PS140_7","020_140_7","PSA","140","7","7","Buyambam tapa, natane Anutuna, gata na akekekake takuyak. Ngan, amak tapduk kopatangu gata na kakuya take siknga tasinggayak kapanin. Tasiwi gwapakngane nutnanga dua sikut. ");
INSERT INTO wnc_vpl VALUES ("PS140_8","020_140_8","PSA","140","8","8","Buyambam tapa, gata ma kapewi sanga wai aminda tasinangge nataaingu tasiwam. Ngan, ita waiaknga tasinangge yandekingu ma siknga kapewi tasiwam. Sanga waaknga yamandet amin dakngakaing. ");
INSERT INTO wnc_vpl VALUES ("PS140_9","020_140_9","PSA","140","9","9","Gata tasiwi aminu na nutnangge natake na umupbasikaingga wamu meya nae apik kakngae yakaingu inae apik. ");
INSERT INTO wnc_vpl VALUES ("PS140_10","020_140_10","PSA","140","10","10","Ngan, gata kapewi aminu kunduta katap paimu pewa iangan engatangan pimaning. Ngan, kapewi aminu kunduta waakwau pake mumba katapatang pukuning. Ngan, gapma buyambam dakaatang pukuke gatu dua akopning. ");
INSERT INTO wnc_vpl VALUES ("PS140_11","020_140_11","PSA","140","11","11","Sike gata dua kapewi sapdut wamu aminu kunduta yakaingu siakanu siwik. Ngan, kapewi sanga waita amak tasiya aminu tawamba kake pasiwa maining. ");
INSERT INTO wnc_vpl VALUES ("PS140_12","020_140_12","PSA","140","12","12","Buyambam tapata aminu sangana wena akgatayamuke tapduu wam yananga gwene tasiwan wamna noman siwik ngang nataat. Ngan, ita aminu sangae dapmakainggengu gatayaman aminu kunduta wamu yumdekan temapa yakingu take dua siwik. ");
INSERT INTO wnc_vpl VALUES ("PS140_13","020_140_13","PSA","140","13","13","Sike noman amindanu gatane umanda ayatangenatning. Ngan, waaminu gatane kaine take yutning. ");
INSERT INTO wnc_vpl VALUES ("PS141_1","020_141_1","PSA","141","1","1","Buyambam tapa, nata apmanu ga ganinggat. Ganiwa natake gata na apu gatangamuyo. Nata gae ganiwanu gata natane tumuk wama natapso. ");
INSERT INTO wnc_vpl VALUES ("PS141_2","020_141_2","PSA","141","2","2","Natane tumuk wamma anzing, sanga sawa kupana akopan kapanga gwaam takngata binga apan tapiakge nataat. Ngan, nata gae tumuk yake kataknga tangenakgat takngae natapi ofa zikaane tasikaing binga singgak. ");
INSERT INTO wnc_vpl VALUES ("PS141_3","020_141_3","PSA","141","3","3","Buyambam tapa, gata natane gena daka kakuya katak tasiyo. Ngan, nata wamu yawiu katak kayuyo. ");
INSERT INTO wnc_vpl VALUES ("PS141_4","020_141_4","PSA","141","4","4","Gata natane musipma gwenu dua nandutewi waiaknga tasinangge enawan na wai aminkat unekan napmambi waiaknga kundu tasinim. Ngan, dua nandutewi naat iat unekan yuke nanamu kaya siknga kuupbamde saningu kuutda nanim. ");
INSERT INTO wnc_vpl VALUES ("PS141_5","020_141_5","PSA","141","5","5","Sike aminu noman tapata waiaknga dua tasiwitde na nuwan kakengu nata ie natapa waapata sanga take tasingamunggak kapanin ngang natapit. Ngan, ita na kaanga naniwan natakengu sanga takekan tasinggak ngang natapit. Siwan unzing wel yangga gwapangane tukwamban puwawan umana tangenakgak binga. Ita kaanga naninangge ba nutnangge natapan kake ma tasiwim ngangu dua siknga iniwit. Siwan ngana nata Anutue aminu wai pasiwan mainingge tumuk wamu asinggan ininggat. Waiaknga tasikaingge meya yamikgen. ");
INSERT INTO wnc_vpl VALUES ("PS141_6","020_141_6","PSA","141","6","6","Meya wa yamiyau aminu waakwakgane tupan tapaapa pake damedakane mupewan pukuwanu, wai aminu waakwakga apme natdetning. Natane wamma siakan gan yakum ngangun. ");
INSERT INTO wnc_vpl VALUES ("PS141_7","020_141_7","PSA","141","7","7","Siwana waaminda anzing yaning, “Aminda nindane kwatanin paku amin kwaikaing gapmane mupewa kuning. Unzing aminda kep kwaik take kep daka wesiwan kaukaut mumba kukaing binga.” ");
INSERT INTO wnc_vpl VALUES ("PS141_8","020_141_8","PSA","141","8","8","Siwan ngana Buyambam tapa, awiapatakan aminbam kayuak kapanin, na kainata gae kasatnanggat. Kasatnawa gata na kakuya take tasike na dua nandutewi kupit. ");
INSERT INTO wnc_vpl VALUES ("PS141_9","020_141_9","PSA","141","9","9","Gata na tanawambi yapapna wai aminda pasike pakusopukaingga na dua tapik. Ngan, gata dua kapewi wai aminda bungep pasikaingga tapan. ");
INSERT INTO wnc_vpl VALUES ("PS141_10","020_141_10","PSA","141","10","10","Gata pasiwi inane bungepnata wai aminu waakwau panggaganuyok. Sike na wena. Na kepi takekan sukuwa sanga wai takngatuta dua tasiwan maiwit. ");
INSERT INTO wnc_vpl VALUES ("PS142_1","020_142_1","PSA","142","1","1","Na Buyambam tapata gatangamikge kumzang yanggamatanggat. Ngan, na ita butaya natake gatangamikge kekeknga ininggamatanggat. ");
INSERT INTO wnc_vpl VALUES ("PS142_2","020_142_2","PSA","142","2","2","Nata nangaakan nataat takngae gatu meya kuupbam nae apukaing ngangge ininggat. ");
INSERT INTO wnc_vpl VALUES ("PS142_3","020_142_3","PSA","142","3","3","Sike musipmaatang natapa meya siwan na apmainanggenggat ngang natakengu, Buyambam tapa, gata minaka tasiwitde atnataayak ngang nataat. Sike kepi nata kunanga gwakatangu bungeu gwa tasike takusopuking. ");
INSERT INTO wnc_vpl VALUES ("PS142_4","020_142_4","PSA","142","4","4","Nata ninae wesim kaat. Kawa ngana aminu tapatu dua yuuknga gatangamik. Aminu tapatu dua yuuknga kakuya nae tasiwik. Siwan aminu tapatu nae butaya natangamuke gatangamunangge nataau wena. ");
INSERT INTO wnc_vpl VALUES ("PS142_5","020_142_5","PSA","142","5","5","Unzingge, Buyambam tapa, nata gae yanggau gata akgatangamiakge yanggat. Gatakan na kakuya tasinggayak kapanin. Sike kayuk yuwit kopatangu gatakan siknga naat yutzimde nataat. ");
INSERT INTO wnc_vpl VALUES ("PS142_6","020_142_6","PSA","142","6","6","Gata gatangamiakge sikgatde natapso. Dasingge, natane musipmaatangu meya siknga. Aminu na tasiwan mainggat takwau kekeknga siknga. Nata waakwau yapbitnanga dua. Unzingge gata na ie kataune sandeke tapso. ");
INSERT INTO wnc_vpl VALUES ("PS142_7","020_142_7","PSA","142","7","7","Gata na meya waaknga kaaune sandeke tapi na take yuwit. Unzingge gatane amindabamu unekan gwa yuwan kakengu gatane umanda yatangenawit. Minae, gata nae take tasikuyak. ");
INSERT INTO wnc_vpl VALUES ("PS143_1","020_143_1","PSA","143","1","1","Buyambam tapa, natane tumuk wamma gata natapiakge nataat. Maakga tewi kwanamu nata singgatde apsok. Ga noman siknga siwan puya noman gan asinggan pasinggayak. Unzingge natane tumuk wamma asiknga natake gatangamuyo. ");
INSERT INTO wnc_vpl VALUES ("PS143_2","020_143_2","PSA","143","2","2","Gata na gikane puya aminu ma usanziwim. Wam yananga tapduk gwenen. Dasingge, aminu tapatu gutongana wena gae kaikane nomanganu yuwiu katasiwi maiwik. Wena. ");
INSERT INTO wnc_vpl VALUES ("PS143_3","020_143_3","PSA","143","3","3","Natane iwanata gwa nawake naitakepu teaing. Ita na kaautde keu zikaa siknga dakaatang napmanggak. Siwan na aminu tupa siknga kumbuu tapatuta binga yuat. ");
INSERT INTO wnc_vpl VALUES ("PS143_4","020_143_4","PSA","143","4","4","Unzingge natane natdetdetna apmaiwan meya bam siknga pake yuat. ");
INSERT INTO wnc_vpl VALUES ("PS143_5","020_143_5","PSA","143","5","5","Sike apmanu sanga tupa aakingge gatu nataat. Siwan nata sanga pasikuyakge gatu puya take siknga aknga ngang pasikuyakge nataat. ");
INSERT INTO wnc_vpl VALUES ("PS143_6","020_143_6","PSA","143","6","6","Nata gae tumuk wam yanggat. Yake musipmaatangu gae take siknga nataat. Unzing aminu tapatutane guyakngaatang kupia siwan yangga tangopnangge nataak binga. ");
INSERT INTO wnc_vpl VALUES ("PS143_7","020_143_7","PSA","143","7","7","Buyambam tapa, gata natane tumuk wamma apman natapso. Dasingge, natane banip singgat takngana dapaknga wai sinanggenggak. Gata naenu ma kusopuwim. Unzing tasinggawi na kungwake gwa kumbing aminda yuaing komune kuyat. ");
INSERT INTO wnc_vpl VALUES ("PS143_8","020_143_8","PSA","143","8","8","Sike na gae baniu asinggat. Unzingge tembana siknga gata tasiwi gatane butaya buyambam takngae gatuna natapit. Na gaekan tumuk wamu ganiawa natake gata kepi yeikngami nata ga gawambit. ");
INSERT INTO wnc_vpl VALUES ("PS143_9","020_143_9","PSA","143","9","9","Buyambam tapa, na gatane gepbiatang koke kusopukgat. Kusopuwawa na iwanatane katakngane sandeke tapso. ");
INSERT INTO wnc_vpl VALUES ("PS143_10","020_143_10","PSA","143","10","10","Sike ga natane Anutuna. Gata na nanindamumbi gika nataayak taknga tawambitde nataat. Gatane Waung kapata na tanomanuwan kepi noman tapa tawambitde nataat. ");
INSERT INTO wnc_vpl VALUES ("PS143_11","020_143_11","PSA","143","11","11","Buyambam tapa, gata na asiknga tapiakge gika gwa yawi kekekakut. Ga take sikngaapa. Unzingge meya nae kwaapzang napmamban kake meya waaknga sandeke na tapso. ");
INSERT INTO wnc_vpl VALUES ("PS143_12","020_143_12","PSA","143","12","12","Gata nae take siknga nataayak. Natake gata iwanaat gatu na tasiwan maikum kat zipi kumning. Minae, na gikane puya aminda. ");
INSERT INTO wnc_vpl VALUES ("PS144_1","020_144_1","PSA","144","1","1","Nata Anututane umana yatangenakgat. Na nanduyutnanggengu yatangenakgat. Ita gatangaman nata kataknga tandakngake iwanaat amnangge tasiwa take singgak. ");
INSERT INTO wnc_vpl VALUES ("PS144_2","020_144_2","PSA","144","2","2","Ita nae musia kwikwiknga natake kakuya tasinggak kapanin. Siwan na ita asinggan tanawanggak. Sike na iatang kusopuwa ita na tanggak. Ita na take tasiwan na take yuat. Siwan ita tasiwan aminu kundu nae gepbiatang koyuaing. ");
INSERT INTO wnc_vpl VALUES ("PS144_3","020_144_3","PSA","144","3","3","Buyambam tapa, ninu amin mina binga, ge gata ninde natanimunggayak? Ninu unzing sanga moo binga. Dasingge gata ninde nangaakan natanimunggayak? ");
INSERT INTO wnc_vpl VALUES ("PS144_4","020_144_4","PSA","144","4","4","Ninu unzing waungga genine awiasip akonggak binga. Ninu tapduu dapaknga yuamang. Unzing amindane wee gunzitda tasiwan matekngasim yuke sopunggak binga. ");
INSERT INTO wnc_vpl VALUES ("PS144_5","020_144_5","PSA","144","5","5","Buyambam tapa, gata yekap gwenu yawi zike kuwan epsok. Epuke gata katakgata tawan dakandakane wasiwi kupanu buyambam gwen enayok. ");
INSERT INTO wnc_vpl VALUES ("PS144_6","020_144_6","PSA","144","6","6","Siwan gata yapasik tasiwi kake natane iwana unda undang kunong. Ngan, gata sakutda muke pasiwi datakunong. ");
INSERT INTO wnc_vpl VALUES ("PS144_7","020_144_7","PSA","144","7","7","Gata katakga tewi epuke na kaiwi akopit. Siwana na yangga gapma buyambam gwekatang yuwau gata na tapi take yuwit. Sike na aminde kataune kekeknga yuwau gata sandeke na tapso. ");
INSERT INTO wnc_vpl VALUES ("PS144_8","020_144_8","PSA","144","8","8","Sike aminu waakwau wamu siakan gan dua yakaing. Waakwau kem gan yake asinggan tanzit taknga tasikaing. ");
INSERT INTO wnc_vpl VALUES ("PS144_9","020_144_9","PSA","144","9","9","Anutu, apman nata kau kayuu takngatu tangenake tainanggenggat. Kau wa taiwiu gita tanguke gae taiwit. ");
INSERT INTO wnc_vpl VALUES ("PS144_10","020_144_10","PSA","144","10","10","Sike gata king gatayaminu amak tasike iwana ayapbikaing. Siwan na Deviu gika napmambi iwanata paipda nutnangge tasiwan maiwik. Gikane puya amin tapakan. ");
INSERT INTO wnc_vpl VALUES ("PS144_11","020_144_11","PSA","144","11","11","Siwan iwanatane gena kem wamu atdokaing. Waakwau kem gan yake asinggan tanzit taknga tasikaing. Siwan ngana gata na ie kataaune sandeke tapso. ");
INSERT INTO wnc_vpl VALUES ("PS144_12","020_144_12","PSA","144","12","12","Sandeke tapi ninda natamangu nindane waatdaka wawi mateu katau dakatuta binga kekeknga takaning. Siwan nindane yapaninu take takake kunzi kunzi kinggane yotna gwaam siknga pasibasikaing binga takaning. ");
INSERT INTO wnc_vpl VALUES ("PS144_13","020_144_13","PSA","144","13","13","Gatu nindane puyaninkatangu nanamu kwaapzang siwan you nanam peamang gwegwen kaya akgitnaning. Siwan nindane sipsipmin kaya waakzau buyambam siknga sinimuning. ");
INSERT INTO wnc_vpl VALUES ("PS144_14","020_144_14","PSA","144","14","14","Siwan nindane ikwawa gamanin kaya waakzau buyambam sike gwendu wai dua sike gwendu dua kupik. Siwan aminu tapatuta you gwendune koke aminu kaiwan kuwan ganggatanguwik. Wena siknga. Ninu wawi ba maya tapatu meya ba toknga pakengu kepiapa atang kwanamu dua siwik. ");
INSERT INTO wnc_vpl VALUES ("PS144_15","020_144_15","PSA","144","15","15","Sike dongu takngatuta sanga gwaam gwaamu anzing pakengu apbaknganong. Siwan gatu Buyambam tapa Anutunin ngang kawan yuwan iaya apbaknganong. ");
INSERT INTO wnc_vpl VALUES ("PS145_1","020_145_1","PSA","145","1","1","Anutu, gata natane king kapana. Nata umanda kopsa akngae ayakapit. Siwan asinggan asinggan nata gatane umandae yatangenawit. ");
INSERT INTO wnc_vpl VALUES ("PS145_2","020_145_2","PSA","145","2","2","Nata kwep apman gae akganimbakngawit. Siwan asinggan asinggan nata gatane umandae yatangenawit. ");
INSERT INTO wnc_vpl VALUES ("PS145_3","020_145_3","PSA","145","3","3","Buyambam tapa umana akopsa ge ninda umana kopsa waakngae buyambam siknga yatangenatnim. Sike waapa enane siknga ge ninda umana kopsa waakngae kuupbam natdetnanga dua. Ninu natdetdetninu dapaknga. ");
INSERT INTO wnc_vpl VALUES ("PS145_4","020_145_4","PSA","145","4","4","Anutu, sike aminu apman yuaingga yakapmak kaknga dongu masan aatninguninde sanga gata pasikuyakge yaniwan ita gatane umanda yatangenatning. Siwan puya buyambamu tasikuyakge wamu yatake kuning. ");
INSERT INTO wnc_vpl VALUES ("PS145_5","020_145_5","PSA","145","5","5","Sike amindanu gatane kekekngaka akngaenu ayaning. Gata gae king kapa ngangun. Siwan ninanu gatane puya take aknga akngaekan natapasiwit. ");
INSERT INTO wnc_vpl VALUES ("PS145_6","020_145_6","PSA","145","6","6","Siwan aminbamda puya kekeknga taknga aknga pasikuyakge yatake kuning. Sike natanu gatane umanda kopsa akngae yakapit. ");
INSERT INTO wnc_vpl VALUES ("PS145_7","020_145_7","PSA","145","7","7","Ita gatane take akngakae yatake kuyuuk gatu musip kwikwik takngakae natake kap taning. ");
INSERT INTO wnc_vpl VALUES ("PS145_8","020_145_8","PSA","145","8","8","Buyambam tapata ninde butaya natanimuke itakan musip kwikwik natanimunggak. Sike ita kaanga zaat dua yake ita butaya ninde asinggan natanimunggak. ");
INSERT INTO wnc_vpl VALUES ("PS145_9","020_145_9","PSA","145","9","9","Ita take aknga aminbamde tasike musip kwikwiu sangabamu pasike pekutde nataak. ");
INSERT INTO wnc_vpl VALUES ("PS145_10","020_145_10","PSA","145","10","10","Buyambam tapa, gata sangabamu pasike pekuyakga gatane umanda ayatangenatning. Siwawan gikane amindabamda ganimbaknganing. ");
INSERT INTO wnc_vpl VALUES ("PS145_11","020_145_11","PSA","145","11","11","Sike ita umanda kopsa akngae kepna kepna kayuwayaune yaning. Yake gatane kekekngaka buyambam takngae yatake kuning. ");
INSERT INTO wnc_vpl VALUES ("PS145_12","020_145_12","PSA","145","12","12","Yatake kuwawa amin kuupbamda puya buyambam taknga tasikuyakge natapning. Siwan gatu gae kingu kekekngaapa yuak ngang kaya kuut natapning. Natake umandae natapan buyambam siknga siwik. ");
INSERT INTO wnc_vpl VALUES ("PS145_13","020_145_13","PSA","145","13","13","Sike ga king kapa yuke aminu kuupbam kakuya asinggan asinggan pasiya. Gata aminbam asinggan asinggan kayuya. I takngatu dua teak. I sanga tasike tekut takngae musia siwik. ");
INSERT INTO wnc_vpl VALUES ("PS145_14","020_145_14","PSA","145","14","14","Sike ita aminu meya pakaingu akgatayamuke gatu aminu kunduta yaipakepu peyaingu ita gatuna yapangenakgak. ");
INSERT INTO wnc_vpl VALUES ("PS145_15","020_145_15","PSA","145","15","15","Anutu, sanga kayuk yuaingu kai gaekan tapan tomna ba nataaingu nanamna tapdukngane yamunggayak. ");
INSERT INTO wnc_vpl VALUES ("PS145_16","020_145_16","PSA","145","16","16","Ita nanamu kuupbamde yami takekan yutningge. ");
INSERT INTO wnc_vpl VALUES ("PS145_17","020_145_17","PSA","145","17","17","Anutu waapa noman takngakan tawake sangabamu tasinggak katangu ninde musip kwikwik natanimunggak. ");
INSERT INTO wnc_vpl VALUES ("PS145_18","020_145_18","PSA","145","18","18","Sike mamin amindaka musia ie siknga tewa kuwan unin yatawakaingu ita pakapu iatang wesim yuak. ");
INSERT INTO wnc_vpl VALUES ("PS145_19","020_145_19","PSA","145","19","19","Siwan mamin amindaka ie akgwaubanu ita sanga wa aminde ayamunggak. Sike kwanamu ie sikaingu ita atnatake gatuna waakwau panggak. ");
INSERT INTO wnc_vpl VALUES ("PS145_20","020_145_20","PSA","145","20","20","Ita amin ie siknga nataaingu ita katak siknga kayuak. Siwan ngana ita aminu waiaknga tasikaingu apasiwan maining. ");
INSERT INTO wnc_vpl VALUES ("PS145_21","020_145_21","PSA","145","21","21","Sike na Buyambam tapatane umana asinggan yatangenawit. Siwan ginu sangabamu ita pasikuu, gikaa itane umana asinggan asinggan initangenatnong. ");
INSERT INTO wnc_vpl VALUES ("PS146_1","020_146_1","PSA","146","1","1","Anututane umana yatangenatnong. Nata ninaaya itane umana yatangenawit. ");
INSERT INTO wnc_vpl VALUES ("PS146_2","020_146_2","PSA","146","2","2","Tapduu asinggan kayuk yuwiu itane umana ayatangenawit. Ngan, nata kaau Anututane umana yatangenatnanga kan taisika kupit. ");
INSERT INTO wnc_vpl VALUES ("PS146_3","020_146_3","PSA","146","3","3","Tupan aminu akumnanga apa apa, sike wa aminda na dua gatangamuke taning. Unzingge gata ie baniu dua siwim. ");
INSERT INTO wnc_vpl VALUES ("PS146_4","020_146_4","PSA","146","4","4","Tapduu akumning kopatangu wa aminu kep ganang pukuning. Siwan tapduu wa amindane uyungata teke kuning komune gwa kumbingga wamu sanga kundu tasinangge yakingu buyana wena siwik. ");
INSERT INTO wnc_vpl VALUES ("PS146_5","020_146_5","PSA","146","5","5","Siwan Jekopda Anutue banip sikut. Siwan aminu tapatu Anutu waapae banip siwan ita gatangamukut tapata apbakngayok. Siwan gatu aminu waapa Anutu Buyambam tapae natapan kekekawik apata apbakngayok. ");
INSERT INTO wnc_vpl VALUES ("PS146_6","020_146_6","PSA","146","6","6","Siwan Anutu waapa sanga ena yekapgwen keu andaka gatu yanggabam gwen gatu sangabam undang yuaingu pasike pekut tapanin. Ngan, Anutu waapata wamu ayanggak saak asinggan asinggan tasinggak. ");
INSERT INTO wnc_vpl VALUES ("PS146_7","020_146_7","PSA","146","7","7","Ita amin iwande gepbiatang koyuke tasingupeekaingu akgatayamunggak. Gatayamuke ita aminu waakwau nanam tomde yuaingge ayamunggak. Sike Buyambam tapata kautde yuaingu sandepakepan kautde dua yuting. ");
INSERT INTO wnc_vpl VALUES ("PS146_8","020_146_8","PSA","146","8","8","Siwan gatu ita tasiwan kai akusia aminu gatuna akaaing. Siwan meya takngatu takngatuta apu pasiwan maikaingu asandeyamunggak. Buyambam tapata amin noman yuaing aminde apbaknganggak. ");
INSERT INTO wnc_vpl VALUES ("PS146_9","020_146_9","PSA","146","9","9","Sike ita aminu komduine nana nindane keunin yuaingu ita kakuya apasinggak. Siwan gatu ita maya apna gwa kumbingu kakuya tasike gatayamunggak. Siwan waatdaka nana gwa kumbingu kuut gatayamunggak. Siwan ngana ita wai amindane natdetdetna apasiwan maikaing. ");
INSERT INTO wnc_vpl VALUES ("PS146_10","020_146_10","PSA","146","10","10","Buyambam tapa king dakngake asinggan asinggan yuwik. Ginu amin Saion nana, gindane Anutusa king dakngake asinggan asinggan yuwik. Ginda Buyambam tapae apbaknganong. ");
INSERT INTO wnc_vpl VALUES ("PS147_1","020_147_1","PSA","147","1","1","Buyambam tapatane umana yatangenatnong. Ninda kap taike Anututane umana yatangenake apbakngakamang. Ninda itane umana kopsa akngae yatangenatnimu take siwan noman gan siwik. ");
INSERT INTO wnc_vpl VALUES ("PS147_2","020_147_2","PSA","147","2","2","Sike Buyambam tapata Jerusalemu gatu mitake inane aminabamu iwanata kaipake keu maa siknga yuak komune kuke pekingu gatu pakapunggak. ");
INSERT INTO wnc_vpl VALUES ("PS147_3","020_147_3","PSA","147","3","3","Ita aminbamu apasiwan nomatakaing. Unzing meyata natdetdetna pasiwan maikaingun. Gatu watana kuut wamayamunggak. ");
INSERT INTO wnc_vpl VALUES ("PS147_4","020_147_4","PSA","147","4","4","Sike ita yekap daau datdasingga ngangu gwa yawan yukut. Siwan ita yekap daau umana gwendu gwendu ayaninggak. ");
INSERT INTO wnc_vpl VALUES ("PS147_5","020_147_5","PSA","147","5","5","Buyambam tapaninu umana kopsa siwan kekeknga kuupbam kayakan. Ninda itane natdetdetna tuwangutnanga dua. ");
INSERT INTO wnc_vpl VALUES ("PS147_6","020_147_6","PSA","147","6","6","Sike ita aminu inane umana dua yapangenakaingu ita wa amindane umana ayapangenakgak. Siwan ngana wai aminu ita kapzang siknga yaipakepu peak. ");
INSERT INTO wnc_vpl VALUES ("PS147_7","020_147_7","PSA","147","7","7","Buyambam tapae kap taike umana yatangenatnong. Gita dakandaka zipna gakngae noman ayawan Anutuninde ininim. ");
INSERT INTO wnc_vpl VALUES ("PS147_8","020_147_8","PSA","147","8","8","Sike ita tasiwan minga aknga ena kakaa komune yuak. Yuwana sopa tewan epu zongazonga pasiwan tawan dakandakane akokaing. ");
INSERT INTO wnc_vpl VALUES ("PS147_9","020_147_9","PSA","147","9","9","Ita nanamu ikwawa gaman gwegwende kuut yamunggak. Sike gatu kombunananggane matekngata ba yawan kaya ie nanamu ayamunggak. ");
INSERT INTO wnc_vpl VALUES ("PS147_10","020_147_10","PSA","147","10","10","Sike Buyambam tapa hos kekeknga gwegwende gatu aminu kekeknga apapae dua baknganggak. Aho. ");
INSERT INTO wnc_vpl VALUES ("PS147_11","020_147_11","PSA","147","11","11","Aminu ie akgwaukaing amindekan baknganggak. Ita butaya asinggan natayamunggakge banip sikaing amindekan baknganggak. ");
INSERT INTO wnc_vpl VALUES ("PS147_12","020_147_12","PSA","147","12","12","Ginu Jerusalem nana amin, Buyambam tapatane umana initangenatnong. Ginu Saion nana amin, Anutusatane umana initangenatnong. ");
INSERT INTO wnc_vpl VALUES ("PS147_13","020_147_13","PSA","147","13","13","Dasingge, ita damandane gwambok gwakgwau apapan kekekakaing. Ga Jerusalemdanen. Siwan ita gatane amindabamu take gatayamunggak. ");
INSERT INTO wnc_vpl VALUES ("PS147_14","020_147_14","PSA","147","14","14","Ita gindane kepza kayuak. Kayuke gindane witza pasiwan puyasa atang take siknga akopa pake napa musipza dokaing. ");
INSERT INTO wnc_vpl VALUES ("PS147_15","020_147_15","PSA","147","15","15","Sike ita wamu takngatu ba yawanu, zaat gaman siknga wamu waaknga yekau tepuke keu andakane epunggak. ");
INSERT INTO wnc_vpl VALUES ("PS147_16","020_147_16","PSA","147","16","16","Ita sopa zambamu kwaapzang pewan epuke kepdaka usukwatapmanggak. ");
INSERT INTO wnc_vpl VALUES ("PS147_17","020_147_17","PSA","147","17","17","Sike itakan wa sopa zambamu kwaapzang siknga sup tapaunu yanggabam gwende kwaimune kaamang binga pewan epukaing. Ita tasiwana kep komu kwamana siknga siwan aminda kwaman taknga kung ngangu ininanga dua. ");
INSERT INTO wnc_vpl VALUES ("PS147_18","020_147_18","PSA","147","18","18","Siwana ita wamu gatu yawan sopa zambamu yangga daknganggak. Ita got taknga tangenawan got takngata yangga tasiwan zipmake kunggak. ");
INSERT INTO wnc_vpl VALUES ("PS147_19","020_147_19","PSA","147","19","19","Sike ita wamu Jekopde yanikapmanggak. Ngan, itane mama wam Isrel nanae yanikapmanggak. ");
INSERT INTO wnc_vpl VALUES ("PS147_20","020_147_20","PSA","147","20","20","Sike waaknga aminu kundue dua tasinggak. Aminu waakwau itane mama wamu dua nataaing. Ginda Buyambam tapatane umana yatangenatnong. ");
INSERT INTO wnc_vpl VALUES ("PS148_1","020_148_1","PSA","148","1","1","Buyambam tapatane umana yatangenatnong. Ginu kuupbamu yekaune enane yuaingga Buyambam tapatane umana yatangenatnong. ");
INSERT INTO wnc_vpl VALUES ("PS148_2","020_148_2","PSA","148","2","2","Ginu angela kuupbamda, itane umana yatangenatnong. Ngan, aminu yekaune nana kuupbamda ita umana yatenganatnong. ");
INSERT INTO wnc_vpl VALUES ("PS148_3","020_148_3","PSA","148","3","3","Siwan gunzitkat gatu yekap gwen ngangga itane umana yatangenake gatu yekapdaau yasikaing ngangga itane umana yatangenatnong. ");
INSERT INTO wnc_vpl VALUES ("PS148_4","020_148_4","PSA","148","4","4","Sike yekau enane sikngata itane umana yatangenatnong. Siwan yangga ena kaa komune yuaingga itane umana yatangenatnong. ");
INSERT INTO wnc_vpl VALUES ("PS148_5","020_148_5","PSA","148","5","5","Sanga wa kuupbamda Buyambam tapatane umana yatangenatnong. Dasingge? Ita ina yawan aake yuaing. ");
INSERT INTO wnc_vpl VALUES ("PS148_6","020_148_6","PSA","148","6","6","Ita yawan waakwau ina ayuaingune yutakuuke yuaing. Siwan wamu wa yakuu yawan kekekawan sandetnanga dua. ");
INSERT INTO wnc_vpl VALUES ("PS148_7","020_148_7","PSA","148","7","7","Buyambam tapatane wamu atawakaing ngangu ginda Buyambam tapatane umana yatangenatnong. Sike ginu pis buyambam gatu sanga yanggabam gwenu kutakngane amunandang siknga yuaing gatu yapasiu mingane kakaakgak. ");
INSERT INTO wnc_vpl VALUES ("PS148_8","020_148_8","PSA","148","8","8","Gatu yangga ais binga gatu minga kuut gatu gou kekeknga puyakaing. ");
INSERT INTO wnc_vpl VALUES ("PS148_9","020_148_9","PSA","148","9","9","Sike ginu tawanu buyambam gatu ginu tawanu mateknga, gatu katau buya asaaking, gatu katau zongaatang nana, gatu kaau kuupbamu aminda kayuaing, ");
INSERT INTO wnc_vpl VALUES ("PS148_10","020_148_10","PSA","148","10","10","gatu kaap zong, gatu kau mateknga, gatu kwait ngangu ginda Buyambam tapatane umana yatangenatnong. ");
INSERT INTO wnc_vpl VALUES ("PS148_11","020_148_11","PSA","148","11","11","Siwan ginu king gatu amin kepna kepna nana kuupbam, gatu kinggane waaknga tupan tapa apa kuupbam, ");
INSERT INTO wnc_vpl VALUES ("PS148_12","020_148_12","PSA","148","12","12","gatu tupan amin gatu wawi matek, gatu maya matek, gatu aminuake, gatu waatdaka ginu kuupbamda Buyambam tapatane umana yatangenatnong. ");
INSERT INTO wnc_vpl VALUES ("PS148_13","020_148_13","PSA","148","13","13","Siakande siknga. Kuupbamda Buyambam tapatane umana yatangenatnong. Dasingge? Umana kopsa itane akngata aminu kuupbam umana kaya ngana ita asiknga ayapbikut. Sike ninda yekapat kepat ngangu kana enane siknga sikaing ngana umana kopsa itane akngata ayapbikgak. ");
INSERT INTO wnc_vpl VALUES ("PS148_14","020_148_14","PSA","148","14","14","Sike ita Isrel aminde take siknga natayamunggak. Sike ita wa aminu inane papan kekekake yuaingunin. Unzingge wa aminda itane umana ayatangenakaing. Buyambam tapatane umana yatangenatnong. ");
INSERT INTO wnc_vpl VALUES ("PS149_1","020_149_1","PSA","149","1","1","Buyambam tapatane umana yatangenatnong. Ginda ie kau kayuk taknga aknga tainong. Taike amin asingganu unin tawakaing aminun, ginda itane umana gaak inikaing tapduk komune initangenatnong. ");
INSERT INTO wnc_vpl VALUES ("PS149_2","020_149_2","PSA","149","2","2","Ginu Isrel nana amin, ginu musip gwaangu Anututa gin pasikutde natangamunong. Ginu Saion nana amin, ginda king kapasae apbaknganong. ");
INSERT INTO wnc_vpl VALUES ("PS149_3","020_149_3","PSA","149","3","3","Ginda ataibakngake umana yatangenatnong. Ginda wakum gatu garamut gatu gita ngang zipmake itane umana yatangenatnong. ");
INSERT INTO wnc_vpl VALUES ("PS149_4","020_149_4","PSA","149","4","4","Dasingge, Buyambam tapata aminabamde take siknga nataak. Natake aminu inae natapan kopsa dua siwan yuaingu ita ayapangenakgak. Pangenawan ita amak ba tasikengu ita iwana ayapbikaing. ");
INSERT INTO wnc_vpl VALUES ("PS149_5","020_149_5","PSA","149","5","5","Anututane aminabamda gwa yapbikengu apbakngakaing. Unzingge dapuna petnangge natake gwa yukengu kau apbakngananga taknga aknga take taining. ");
INSERT INTO wnc_vpl VALUES ("PS149_6","020_149_6","PSA","149","6","6","Ita take ainggamatake Anutue inimbakngake gwauyana gena toknga akwau katakngata panggaganutning. ");
INSERT INTO wnc_vpl VALUES ("PS149_7","020_149_7","PSA","149","7","7","Panggaganuke dongu kunduat amau tasike gatukande pasiwan maining. ");
INSERT INTO wnc_vpl VALUES ("PS149_8","020_149_8","PSA","149","8","8","Pasiwan maiwan ita kingaat gatu tupan aminu panggaganuke senu ainda tasiyata wamapening. ");
INSERT INTO wnc_vpl VALUES ("PS149_9","020_149_9","PSA","149","9","9","Siwan ita aminu waakwau tokngabam yamuning. Unzing Anututa gwa yakut. Sike Anututane aminabamdanu iwana ina unzakan yapbitakakopning. Buyambam tapatane umana initangenatnong. ");
INSERT INTO wnc_vpl VALUES ("PS150_1","020_150_1","PSA","150","1","1","Ginda Buyambam tapa inimbaknganong. Ginu Anututane yotna gwekatang koyuke umana aknga yatangenatnong. Ginu yekaune enane yuaingga ie inimbaknganong. ");
INSERT INTO wnc_vpl VALUES ("PS150_2","020_150_2","PSA","150","2","2","Sike ita puya kekeknga akngata pasikut takngae natake itane umana yatangenatnong. Sike ginu ita tupan sikngaapa yuke umana kopsa sikngaapa ngang natake itane umana yatangenatnong. ");
INSERT INTO wnc_vpl VALUES ("PS150_3","020_150_3","PSA","150","3","3","Ginda pum puyake umana yatangenake gatu gita zipmake umana yatangenatnong. ");
INSERT INTO wnc_vpl VALUES ("PS150_4","020_150_4","PSA","150","4","4","Gatu wakum zipmayuuk kap taike umana yatangenake gatu gita zipmayuuk kekngagom puyake umana yatangenatnong. ");
INSERT INTO wnc_vpl VALUES ("PS150_5","020_150_5","PSA","150","5","5","Gatu dopangu bras ngang yanikainunin zipmaawa gakngae kuwawan Buyambam tapatane umana yatangenatnong. Ngan, dopangu bras gwenu tanguwa gakngae kapzang yaawan Buyambam tapatane umana yatangenatnong. ");
INSERT INTO wnc_vpl VALUES ("PS150_6","020_150_6","PSA","150","6","6","Ginu sanga kayuk yuaingu kuupbamda, Buyambam tapatane umana yatangenatnong. Buyambam tapae inimbaknganong. ");
INSERT INTO wnc_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Sike aminu aakwau Jesu Kraisdane bamnatane umana. Jesu Devit tupa siknga kumbut tapatane donga, siwan Devitda Ebraham tupa siknga kumbut tapatane zakngi. ");
INSERT INTO wnc_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ebrahamu Aisakgane nana. Sike Aisakga Jekopdane nana. Siwan Jekopda Judaat gatu itane uyapna bapatdane nana. ");
INSERT INTO wnc_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Sike Sudatane waaknga Pereskat Saraat. Sike waapaatdane minga Tema. Siwan Peresda Hesrondane nana. Sike Hesronda Ramdane nana. ");
INSERT INTO wnc_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Siwan Ramda Aminadapdane nana. Siwan Aminadapda Nasondane nana. Siwan Nasonda Salmondane nana. ");
INSERT INTO wnc_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Sike Salmonda Boasdane nana. Sike minga umana Repah. Siwan Boasda Obetdane nana, sike minga Rut. Siwan Obetda Jesitane nana. ");
INSERT INTO wnc_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Siwan Jesita Devitane nana. Siwan Devitda Solomondane nana. Sike itane minga tupa Yuriatane maatna dakngakut. ");
INSERT INTO wnc_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Siwan Solomonda Riaboamdane nana. Siwan Riaboamda Abaisatane nana. Siwan Abaisata Esatane nana. ");
INSERT INTO wnc_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Siwan Esata Jihosafatdane nana. Siwan Jihosafatda Joramdane nana. Siwan Joramda Usaiatane nana. ");
INSERT INTO wnc_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Siwan Usaiata Jotamdane nana. Siwan Jotamda Ehasdane nana. Siwan Ehasda Hesekaiatane nana. ");
INSERT INTO wnc_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Siwan Hesekaiata Manasatane nana. Siwan Manasata Emosdane nana. Siwan Emosda Josaiatane nana. ");
INSERT INTO wnc_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Siwan Josaiata Jekonaiaat uyapna bamdane nana. Sike tapduu waomune iwanata apu Isrel nana zipmake kaipake keu Bebilon komune kaipakuking. ");
INSERT INTO wnc_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Sike wa kaipakukingga aminu Bebilonu kaipakuwana Jekonaiatane engangu tapatu aawan umana Siatiel ngang iniking. Siwan Siatielda Serababeldane nana. ");
INSERT INTO wnc_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Siwan Serababelda Abaiatdane nana. Siwan Abaiatda Elaiakimdane nana. Siwan Elaiakimda Esotane nana. ");
INSERT INTO wnc_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Siwan Esota Sedokgane nana. Siwan Sedokga Ekimdane nana. Siwan Ekimda Elaiatdane nana. ");
INSERT INTO wnc_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Siwan Elaiatda Eliesatane nana. Siwan Eliesata Matandane nana. Siwan Matanda Jekopdane nana. Siwan Jekopda Josepdane nana. ");
INSERT INTO wnc_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Siwan Josepda Mariatane apna. Siwan Mariata Jesu tangaiwan umana Krais ngang inikaing. ");
INSERT INTO wnc_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Unzingge Ebrahamdane dongata waakzak sike sitakunggawan apu apu banakan katangu aminu buyambam siknga dakngawana masan siknga Devitda aakut. Siwan Devitdane dongata waakzak sike sitakunggawan apu apu banakan katangu ina unzakan aminu buyambam siknga dakngawana masan siknga Bebilon kep komune nana aminda apu kaipakuking. Kaipakuwa yuke wa aminda waakzak sitakunggawan apu apu banakan katangu ina unzakan aminu buyambam siknga dakngawana masan siknga aminu tapatu Anututa tapan akgatanimunangaapa dakngake aakut. Anututa waapa takutde natake umana Krais ngang inikamang. ");
INSERT INTO wnc_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Siwan Josepda Maria maatnae tapikge gwa yawan ngana dua takut. Tapduknga atapikge gwenu dapaknga siwan Anututane Waung Kapata tasiwan Mariata musiaapa siwan kaking. ");
INSERT INTO wnc_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Kawa ngana Josepda aminu nomanaapa yuke wepda inikwasiwa kuwik ngang natapbut. Mariata maaknga dua natapikge ngang natake ");
INSERT INTO wnc_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","dapun peke mia takngatu kakut. Kawawan Anututane angelata apu anzing inikut. Josep. Devitdane dongune aakuyak kapa. Maatdae tapiyakge nangaakan ma natapim. Take tapso ngang inikut. Inike Anututane Waung Kapata tasiwan musiaapa sikut. ");
INSERT INTO wnc_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Siwan apmea engangu wawiapatu tangaiwik ngang inikut. Tangaiwana umana Jesu ngang iniyo. Dasingge? Ita aminabamu waiakngae gepbiatang dua yutningge gatayamik ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Siwan tupa siknga Anututa wamu takngatu ayanikapsa aminu tapatu iniwan natake ita anzing yanikapbut, ");
INSERT INTO wnc_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Maya mateu tapatu wawi tapatue dua kukut tapata musiaapa siwik. Sike engangu wawi wa tangaiwik kapatane umana Emanyuel. Tana tekwamban, ‘Anutu nikat gatake yuamang,’ ngang inining.” Ngang wa yakapbut taknga buya unin siwikge natake angelata Josep unzing inikut. ");
INSERT INTO wnc_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Iniwan natake Josepda enake angelata wamu wa inikut taknga tasikut. ");
INSERT INTO wnc_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Maria takut ngana iat gatake dua peke yuwawat waaknga tangaiwan Josepda umana Jesu ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Siwan Herotda tupan tapa yukut gwekatang Jesuta Betlehem yot gapma Judia kep komune yuak gapmane aakut. Aawana natdetdetna kaya aminu gunzitde yapiiatangga Jerusalem apu anzing yaking. ");
INSERT INTO wnc_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Engangu kayukapa Judia amindane buyambam tapa dakngawik kapa zandang yuak? Ninu itane yekapdaak gwenu gunzitde yapiiatang yuke kake gwa aakut ngang natake apu ninu waapa inimbaknganangge apukamang ngang yaniking. ");
INSERT INTO wnc_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Siwan buyambam tapa Herotda natake asatnawan aminbamu Jerusalem nana kuupbam asatnaking. ");
INSERT INTO wnc_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Siwan Herotda Anutue yot takwan gwene pasiya amindane takeakwakat gatu mama wam yanindamumsa amikat yayawamban unekan apa anzing yanikwaikut, “Anututa tapan Krais dakngawik kapata zandang aawik,” ngang yanikwaikut. ");
INSERT INTO wnc_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Yanikwaiwan yake anzing iniking. “Betlehem yot gapma Judia kep komu yuaune aawik,” ngang iniking. “Dasingge, ayanikapsa aminda anzing mataking, ");
INSERT INTO wnc_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Ginu Betlehem nana Judia kep komdane yot gapmabamu ginu dua dapbitning. Wena siknga. Sike gikatnana tapatuta apuke natane amina Isrel nanae kuyana yuwik,’ ngang mataking,” ngang take aminu waakwakga Herotde unzing iniking. ");
INSERT INTO wnc_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Unzingge Herotda wepda siknga aminu gunzitde yapiiatang nana amin yayawamban apa anzing yanikwaikut. Yekapdaau wagwenu zaapduk apan kaking ngang yaniwan yake anggaman iniwa natapbut. ");
INSERT INTO wnc_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Natakenga kemu anzing yanikut. Ginu kuke engangu waapa kakengu ginda wamu nae takapa nakaya kuke inimbakngawit ngang yanipewan kuking. ");
INSERT INTO wnc_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Kuwawa yekapdaau wagwenu tupa gunzitde yapiiatang yuke kakingu ita tupan kuwawan tawatake kuwawa paku you engang kapata yukut gwene tuwanguke enane yukut. ");
INSERT INTO wnc_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Yekapdaakga yuwan kake musip gwaang natake ");
INSERT INTO wnc_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","yoakatang koke engakat minga Mariaat kake umana yatangenatnangge natake akgwetake inimbakngake yakngaatang zike sanga kundu ie imuking. Mani buyambam gatu sanga planggane inuknga binga wa manina buyambamda usiking. Siwan katau dakatutane inuknga kapanga take siknga singgak. Siwan manina buyambam sikngata usikingkat imuking. ");
INSERT INTO wnc_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Imukenga dapun peke mia kawawa Anututa anzing yanikut. Herotde gatusa ma kuwam ngang yaniwan natake enake kepi tapatu tawake gatuna yotna kuking. ");
INSERT INTO wnc_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Siwan aminu waakwakga gwa kuwana Josepda mia takngatu kawawan angelata anggaman singaawan kakut. Kaawan waapata anzing inikut. “Enat! Tupantapa Herotda engang waapa tangutenangge natake apmaatzim tawambik. Ge ga enake engakat mingaat papi Isip kep komune datakunong. Datakuke undang yuwawa apmea nata daniwa ginu gatu ane apnong,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Iniwan natake Josepda enake engakat mingaat papan zikaane Isip kuking. ");
INSERT INTO wnc_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Kuke undang yuwawa tupa siknga Anututane wamna yanikapbut tapata apmea aawikge wam taknga anzing yakut. “Waakngata Isip yuak. Yatawamba apik,” ngang yakut. Sike wa yakut taknga buya unin aakut. Siwan waakwakga Isip kuke yuwawa masande Herotda kumbut. ");
INSERT INTO wnc_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Siwan Josepda engakat mingaat pake Betlehem teke datakuwana Herotda kaawan natdetdetna kaya aminda kem tasiwa kake musiaatang toknga siknga natapbut. Natake natdetdetna kayata kuminamu wagwenu tupa kakingge tapduknga gwende gatu natapbut. Natake Betlehem nana amindane waatdaka nakanu gweaat gwenduat dua kaking aminu zipa puyuwikge amina yanipewan kuku zipa kumbing. ");
INSERT INTO wnc_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Zipa puyuwan wamu takngatu tupa siknga Jeremaiata Anututane wam take yanikapbut taknga siakande buya unin aakut. Sike ita wamu anzing yakapbut. ");
INSERT INTO wnc_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Rama yot gapmane nana aminda nataawa kwanam kumzang siknga siwan natapning. Reselta waakngae kwanam siwawan kake bitang ngang iniwa maikut. Dasingge? Waakngata wena gwa siking.” Jeremaiata wamu wa yakut taknga gunziu wagwene siakande buya unin aakut. ");
INSERT INTO wnc_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Siwan Herotda akupana Josepda Isip yusika mia takngatu kakut. Kawawan angelata anggaman apan kakut. Apan kaawan ita anzing inikut. ");
INSERT INTO wnc_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Enat. Waatdaka tangutenangge tasikut amin tapa gwa kumbutde waatdakaat mingaat pake Isrel kep komune kopso,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Iniwan Josepda natake enake waatdakaat mingaat pake Isrel kep komune kopbut. ");
INSERT INTO wnc_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Undang koke yuwawan aminu tapatuta anzing inikut. Akeleas Herotdane waakngata nanae tangge yuke Judia aminde tupantapa dakngake yuak ngang iniwan natapbut. Natake undang kopnangge gwauya natapbut. Gwauya natake yusika zikaa gwendune mia takngatu kaawan Anututa gwaut wam iniwan natapbut. Iniwan natake enake papan Galili kep komune kuking. ");
INSERT INTO wnc_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Kusika you gapmandu umana Nasaret ngang inikaing gapmane kuke yuwawa Nasaret nanaapa ngang Jesue yaking. Ge wamu takngatu tupa siknga Anututane wam yanikapbing aminda yaking kaknga siakande buya unin aakut. Wa aminda anzing yakapbing. Nasaret nanaapa ngang ie yaning ngang yakapbing. ");
INSERT INTO wnc_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Tapduu waomune Jonu yangga sauyamuya apata keu amina wena Judia kep kautdu saak komune yuke ita wamu tuwanguke yanikapbut. ");
INSERT INTO wnc_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ita asinggan anzing yakut, “Ginda musipza tapa tekwamsok. Tapduknga Anututane amin panangge tasinggak kakngata apnangge dapaknga gwa singgak,” ngang yakut. ");
INSERT INTO wnc_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jonu waapae Anututa yawan natake wamu ayanikapsa aminu Aisaiata anzing matakut, “Aminu tapatu keu amina wena komune yuke anzing yanggamatanggak. ‘Takeapatane kepina tandaknganong. Buyambam tapatane kepina tanomanutnong,’ ngang yanggamatanggak,” ngang Aisaiata matakut. ");
INSERT INTO wnc_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Siwan Jonda tauknga kaau gwendu kamel ngang inikainggane danggamita tasikingunin taukngae tasike simbuna tambut. Siwan ita nanamde apmakat iningokat nakut. ");
INSERT INTO wnc_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Sike tapduu waomune you Jerusalem gapmanenana gatu keu Judia komunenana kuupbam gatu aminu you Jodan yanggaapa kaukaut saak yuaing gapma gapmane nana kuupbamda Jonde kuking. ");
INSERT INTO wnc_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Kuke waiakngana yakapa Jonda yangga Jodanu waapane sauyamukut. ");
INSERT INTO wnc_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Siwan Judianana aminda miti wamu inata takngatu natake dongu takngaaya dakngake yukinggane dongu takngatu Ferisi amin ngang yaniking. Siwan dongu takngatu Sadyusi amin ngang yaniking. Siwan dongu wa takngaakatnana aminu buyambamda yangga sauyamikge apuwawa kake Jonda anzing yanikut, “Gomokga amin yasiwan kungwakaing binga ginda unzing pasikaing. Dasingge? Anututane musia toknga aknga yapbitnangge datakuke nata yangga sautdamitde apukaing? Aminu tapatuta toknga wa masan apik kakngae daniwan natake datakukaing ba dasing?” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","“Ginda Ebrahamdane dongune aake yuaing ngana sanga takngatuekan dapmakaing. Musipza tapa tekwamban waiakngasae masa yamuke yuaing kakngata anggaman siwan kanimde pasinong,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","“Suu ayuaing gwegwenu sanga moo binga ngana Anututa tasiwan supda Ebrahamdane donga dakngananga. Siwan ginda wamu anzingu ma yawam. ‘A! Ninu Ebrahamdane dongune aake yuamang. Yuwatna Anututa nindupan aminu noman aminda yuaing ngang ninduak,’ ngangu ma yawam. ‘Ninduakge dasingge musipminu tana tekwambik,’ ngangu ma yawam,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","“Sike katau yapii buyak patzitnangge natake sandunu katapdakae yapiine gwa tekut binga Anututa nin usanzitnangge natake gwa takakngake yuak. Buya take dua aawan kake sandunda patzike katapbapatang muban yasiwik,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Ginda musipza tapa tekwanggak kakngata siakan siwan kanimde yangga sautdamunggat. Sike apmanu nata gambok enake puya aaknga tasiwawa masande aminu tapatuta enake puya tasiwik. Sike aminu waapatane kekeknga aknganata na atnapbikut. Unzing siwan na aminu umana wenaapa yuatde ita apan kake nata inike, ‘Kepi taukga papa sanggamuut,’ ngang ininangge apmaakanggat. Sike ita Anututane Waung Kapa initewan apu musipza pangenake ginu katapda isindudumukgak binga tasindamik,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","“Sike kep kwaipuknga katakngine take nanam tapun kwaidotdonguke undang muban kopa ooya puyapakuwawan buyata gatu buka gwene pimamba pake pakapu nanam tapunde yotgwene peaing binga ginu usanzitdamik. Buya pekanga ooya kwaamuke katau dua kungwake asinggan isinggak gwekatang muban yasining,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Sike tapduu wagwene Jesuta Galili kep komu teke yangga Jodan tapane kuwan Jonda yangga saukngamikge kukut. ");
INSERT INTO wnc_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Siwan ngana Jonda isapimamsa wam yake anzing inikut, “Na gata yangga take siknga saukngamunanga ngana ga dasingge nata yangga saukgamitde nae apunggayak,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Iniwan ngana yake anzing inikut. “Undanga. Apmanu nata wa ganinggat taknga tasiyo. Sike nitda unzing tasikengu puya kuupbam nomanakan Anututa ninikut taknga tasisim,” ngang iniwan Jonda ie wam gwaamuke yangga saukngamukut. ");
INSERT INTO wnc_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yangga saukngamana Jesuta yanggaatangga akoke kawawan zetgaman enandangu kakaa siwan Anutue Waungga kwaiu kombunananga ngang yanikamang gwenda binga epuke Jesue apu tangene pakuyukut. ");
INSERT INTO wnc_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Pakuyuwawan enandangga wamu takngatu anzing yakut, “Aminu waapa natane waaknga. Na ie take siknga natangamuke ie musip gwaang natangamunggat,” ngang yakut. ");
INSERT INTO wnc_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Siwan Setdenda Jesu inindatdauwikge Waung Kapata keu amina wena komune initakukut. ");
INSERT INTO wnc_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Kuke nanamu dua nake yusika sande katau kuut musa kautdu musane gwenduat kake tomna natake yuwawan ninindatdaukgak kapata apbut. ");
INSERT INTO wnc_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Apuke Jesu anzing inikut, “Ga Anutue waak kakengu sup anggwegwen yaniwi poyak dakngawa napso,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Iniwan ngana yake anzing inikut. “Wamu takngatu Anututane wampatang anzing matakut, ‘Nanamdakan keunenana amin gatayaman kayuk yutnanga dua. Yusikangu akumning. Siwan ngana Anututa wamu takngatu takngatu yakut taknga gwaamukengu dua kumning,’ ngang matakut takngae natake sup gwegwenu dua yaniwit,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Iniwana Setenda Jesu take Jerusalem yot takwan gapmane koke Anututane yot takwan gwene engatangan koke dumtapane yukumayak. ");
INSERT INTO wnc_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Yusika Setenda Jesu anzing inikut, “Anututane wampatang anzing matakut. ‘Anututa angelana yaniwan katakngita ga tapa kenzomba supgwene dua tepsa,’ ngang matakut takngae natake aneta paapi unzing gatanggama kake ga Anututane waaknga siknga ngang natapa siakan siwik,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Iniwan ngana yake anzing inikut, “Anututane wampatang wamu takngatuat anzing matakut, ‘Gata Anutu Buyambam tapa ma tasiwi siwan,’ ngang matakut takngae natake dua paapit,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ngang iniwan Setenda Jesu tapan tawanu mamaya siknga dakatune enane siknga kopbumayak. Koke sangabam yeukngaman Jesuta kawawan take aminu kuupbam kepna kepna yutakuwawa kakut. Kawawan take waakwakge aminabamda wa aminde gepbiatang yutakuwawa umana asenawawa kakut. ");
INSERT INTO wnc_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Kawawan Setenda anzing inikut, “Gata nae gepbiatang koyuke nanimbakngawinu nata tasinggama akaayak kaknga kuupbamda gae gepbiatang koyutning,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Iniwan natake Jesuta yake anzing inikut, “Anututane wampatang wamu takngatu anzing matakut, ‘Anutu Buyambam tapae inimbakngake ie puyaekan natake tasingamuyo,’ ngang matakut takngae natake dua ganimbakngawit,” ngang inikut. Unzing inike “Seten! Ga napmake kungga,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ngang iniwan natake i teke kuwana angelata apu Jesu gatangamuking. ");
INSERT INTO wnc_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Siwan “Jonu tanggaganuke kaautde teking,” ngang yawa Jesuta natake Judia kep kom teke Galili kep komune kukut. ");
INSERT INTO wnc_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Kuke Nasaret yot gapma teke paku Kapeneam yot gapmane yukut. Sike Kapeneam yot gapma yangga gapan kwaimune Sebyulandane dongaat Naftalitane dongaatda tupa siknga yuking saak yuak. ");
INSERT INTO wnc_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Unzing Anutue wamu takngatu ayanikapsaapa Aisaiata yanikapmake anzing yakut, ");
INSERT INTO wnc_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Keu Sebyulan nanaat gatu Naftali nanaat kepi yanggagapande kuya Jodan kautdu saak aminu dongu kundune nana Anutue dua nataaing amin ngana Galili kep komune yuya aminu zikaandakatang yuaing. ");
INSERT INTO wnc_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Wa aminda kakaa buyambam taknga gwa kaaing. Sike aminbam zikaa akumnangaatang yukingge waenga sike kakaa yamukut,” ngang Aisaiata yakapbut taknga buya unin aakut. ");
INSERT INTO wnc_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Sike tapduu waomune Jesuta tuwanguke wam yake anzing yakapbut, “Ginu musipza tapa tekwamsok! Tapduknga Anututa amin panangge tasinggak kakngata apnangge dapaknga gwa singgak,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Siwan Jesuta yangga gapan Galili kwaimune kusika aminu tapaaya uyapnaat paanaat kakut. Tapatu Saimon Pita ngang inikaing kapaat uyapna Endruatda asinggan pis kaike mani ita pakakumayak. Siwan yapapna yangga gapan katang mukgawat kakut. ");
INSERT INTO wnc_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Kake Jesuta waapaau anzing yanikut, “Giu apu na nawambat nata danindamuba pis wa kaikamayak binga aminu papat natane pandetna daknganingge danindamumbit,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Yaniwan waapaau zetgaman yapapna peke kuku tawambat kuking. ");
INSERT INTO wnc_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Tawambat kusika gatu kawawan aminu inawaanda undang yuwawa kakut. Jems Sebeditane waaknga uyapna Jonkat kakut. Kaawan waapaatda dopangbam gwene nana Sebediatda unekan gatake yuke yapapna paibupmake yuwawa kakut. ");
INSERT INTO wnc_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Kake waakngaapaat yayawamban zetgaman dopangbapat nanaat peke kuku Jesu tawakumayak. ");
INSERT INTO wnc_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Siwan Jesuat itane pandetnaatda Galili keu kuupbam pasitakuke ita aminu kuupbam inane miti yotnane koke yanikut. Yanike wamu takeaknga ngang yake Anututa amin panangge tasinggak kakngae wam yake sangabamda gupnaapa aminbam pasiwan maikingu sandeyamukut. ");
INSERT INTO wnc_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Yanike sandeyamuwawan natake wam yatakuwawa Siria kep komune kuut tawamban sandewan aminbamu maitna inata inata sikingu ie pakapbing. Tokngabam paking amin gatu waung waita papan datdaptaking amin gatu aminu apimake kumzang yamukaing amin gatu aminu kwatai gatukande kupsa amin ngang ie pakapa pasiyaman take siking. ");
INSERT INTO wnc_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Siwan aminbamu Galili nanaat kautdu yot gapma katak kuut musaatda yuaing saak nanaat Jerusalem nanaat Judia kep komune nanaat Jodan yanggaapa kautdu saak nanaatda kuku Jesu tawaking. ");
INSERT INTO wnc_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Aminbamda tawawa kake Jesuta baku dakane koke pukwiwana pandetnata ie kuking. ");
INSERT INTO wnc_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ie kuwana anzing yanindamukut. ");
INSERT INTO wnc_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Mamin amindaka Anutue kuna gataniman ngang baniaatang natake kukaingu Anututa aminu waakwakat gatake yutning. Dasingge? Anututa amin panangge tasinggak kakngae gepbiatang yuaing. ");
INSERT INTO wnc_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Mamin amindaka waiaknganae kwanam sikaingu Anututa aminu waakwakat gatake yutning. Dasingge? Anututa sandeyaman nomana yutning. ");
INSERT INTO wnc_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Mamin amindaka inae umande buyambamtapa dua daknganingge natapningu Anututa aminu waakwakat gatake yutning. Aminu unzing natapning aminde sanga tupa yamunangge yakut taknga Anututa siakande yaman pake apbakngake yutning. ");
INSERT INTO wnc_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Mamin amindaka takeaknga tasinangge musiaatang toknga siknga nataaingu Anututa aminu waakwakat gatake yutning. Dasingge? Musiaatang takekan siwik. ");
INSERT INTO wnc_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Mamin amindaka musiaatang kwikwiknga nataaingu Anututa aminu waakwakat gatake yutning. Dasingge? Anututa wa aminde toknga dua yamik. ");
INSERT INTO wnc_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Mamin amindaka musiaatang wasap wena aminu Anututa aminu waakwakat gatake yutning. Dasingge? Wa amikat Anutuat unekan gatake yutning. ");
INSERT INTO wnc_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Mamin amindaka amakaknga yandakngakaingu Anututa aminu waakwakat gatake yutning. Dasingge? Anututa natane waaknga ngang yaniwik. ");
INSERT INTO wnc_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Anutue wamde banip siya aminde banip dua siya aminda toknga yama paningu Anututa aminu waakwakat gatake yutning. Toknga yama paning ngana aminu waakwakga Anututa amin panangge tasinggak kakngae gepbiatang koyuke apbaknganing. ");
INSERT INTO wnc_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Ginu pandetna yuwawa danduke kunduta sapdut wam danisapduke toknga aknga damuke wamu inata inata takngatu takngatu ginde kem yaning. ");
INSERT INTO wnc_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Tupa siknga Anututane wam yanikapsa aminde toknga unzakan yamukaking. Toknga unzing damuwawa ngana banipzaatang apbakngake yutnong. Dasingge? Anututa takeaknga enandangu ginde atdamik,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Siwan pangga pasiwan nanamu kaya singgak binga ginda aminbamu gikat gatake yutning amindane musia pangenawa wa aminda musia tapa tekwamban amin noman daknganing. Siwan ngana pangu sipna siwanu dasingga tasina kayana gatu siwik? Wena. Pangu kaayana wena sipna gwa singgakge muban kuwan aminda apu yainggamuning. ");
INSERT INTO wnc_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Siwan gunziu waengata kuwan kepna kepna nana aminda kakaa akngane yuaing. Sike gikaya ina unzakan. Ginda pasiwa keune nana aminda kakaa akngane yutning. ");
INSERT INTO wnc_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Siwan lam gwen gatake dopang gwenda dua usikwatakamang. Lam gwen gatapna isikakaawan itane tangine tena kakaa aknganata yot wagwen tawamban sandewik. ");
INSERT INTO wnc_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ina unzakan. Aminbamda ginda take tasikaing kakngasa kakaa aknga binga siwan danduke Nanza enandang yuak kapae inimbaknganing,” ngang Jesuta pandetna yaniwan natapbing. ");
INSERT INTO wnc_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Sike ginda anzing ma natapam. Nata apuke Mosesdane mama wam gatu ayanikapsa amikatde wam yandaknganangge dua apbum. Wena. Nata apuke tasiwa wamu wa yaking kaknga buya unin aawikge natake apbum,” ngang yakut. ");
INSERT INTO wnc_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","“Nata siakande siknga daninggat. Tapduknga yekapat kepat wena dua siwik gwekatangu Mosesdane mama wamu kautdu mateknga takngatusimu wena sinanga dua. Sike mama wamdane buyana aawana mama wamu waaknga tening,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","“Unzingge aminu tapatuta mama wamu takngatusim yandakngake aminda sandetningge yanindamubanu tapduknga Anututa aminbam usanziwik gwene ita Anutuat gatake yuwik ngana waapatane umana pimapan umana wenaapa binga dakngake yuwik. Sike aminda mama wam tawake aminbamde musia pangenawan tawambanu tapduknga Anututa aminbam usanziwik gwene waapata umana kaya dakngake yuwik,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","“Siakande daninggat. Ginda Mosesde mama wamu yanindamumsa amikat Ferisi amikatda Anutue kepi katak tawakaing kaknga dua yapbike katak siknga tasikengu Anututa amin panangge tasinggak kakngae gepbiatang kopnanga dua siwik,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Sike Anututa aminu tupa siknga yuking aminde anzing yanikut, ‘Aminu tapatuta amin tanguwan kupan takuwa wam yayok,’ ngang yanikut taknga ginda gwa natapbing. ");
INSERT INTO wnc_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ngana nata ginu daniwa natapnong. Aminu tapatuta notnae bania toknga natangamanu takuwa wam yayok. Gatu aminu tapatu notnae inisapduwik kapa takuwa wam yayok. Gatu aminu tapatu notnae bania toknga natake ga katum ngang iniwik kapa katapbapatang pukunangaapa dakngawik. ");
INSERT INTO wnc_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Siwan gikatnana tapatuta sangana Anutue imunangge natake yot takwan gwene pakopik. Pakoke sanga apbotakut taknga gatuna natapik. O! Nata notnae wai takngatu tasingamukum. Wai waaknga tasiwa nae wai nataak ngang natapik. ");
INSERT INTO wnc_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Unzing natakengu sangana Anutue imunangge pakopiu undang peke kuyok. Kuke notnae take tasingaman ie take siwana gatuna apuke sangana Anutue imuyok. ");
INSERT INTO wnc_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Siwan aminu tapatuta apu gikatnana tapatu wamna yawikge apu takuwanu waapaatda kepiapane kuyuk wam kwikwik iniwan baniaatang kwikwiknga aknga natangamuke wam yawikge dua takuwik. Sike unzing dua iniwanu waapata takuwan wamu ayawik. Ayawan wam usanziwikapata yawan taukdapakga kaaut yotde tewik. ");
INSERT INTO wnc_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Undang tewan yusika buya tupakande imukenga epu kuwik,” ngang Jesuta yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Sike ginu wamu aaknga tupa siknga bamsa yanikut taknga gwa natapbing, ‘Gata yasewa ma tasiwim.’ ");
INSERT INTO wnc_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Unzing yanikut ngana nata anzing daniwa natapnong. ‘Aminu tapatuta maya tapatu kake maya waapae musia enawanu ita musiaatangu yasewaapa gwa daknganggak,’ ngang natapnangge,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Sike kaika siya saak nana gwenda tasiwan ga waiakngaatang pimakengu akwagike mutewi kuyok. Sike gupba kautdu wena siwan waiakngaatang dua pimapi tokngabam pakaing kopatangu dua muba kuwi take siwik. Siwan kaika dua kwagiwi ita tasiwan pimapinu gupba kutapa muban kuwan wai siwik,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","“Sike katakga siyaapata tasiwan ga waiakngatang pimakengu gata apasindakngake mumso. Sike gupba kautdu wena siwan dua pimakengu tokngabam papsa kopatangu dua kuwi take siwik. Siwan ngana dua pasindakngake undang pimapinu gupba kutapa toknga wa papsa kopatang kuwan wai siwik,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Tupa siknga wamu takngatu anzing yaking, ‘Aminu tapatuta maatna sandetnangge natakengu pepa maya sandeke yawan kekekawan yamukaingu sandu imuyo.’ Unzing yaking ngana ");
INSERT INTO wnc_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","nata daniwa natapnong. Aminda maatna yasewa dua tasiwan moo sandewan kuwan wawi tapatuta maatnae tapik. Tapanu wa sandekut tapata tasiwan, ‘Maya waapata yasewaapa daknganggak,’ ngang natapnong. Siwan wawita maya wa inikwasikut tapa takengu, ‘Ita yasewaapa dakngake yuak,’ ngang natapnong,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Sike wamu takngatu bamin yaniwan ginda gwa natapbing kaknga anzing, ‘Ginda kem wamu takngatu yawa kekekawanu masande isapmamsa wamu ma yawam. Sike ginda sanga takngatu tasinangge natake siakande siknga yawa kekekawanu siakande siknga Buyambam tapae kaine atasinong.’ ");
INSERT INTO wnc_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Unzing yanikut ngana nata daniwa natapnong. Ginda wamu takngatu yawa kekekakut taknga dua sandetningge natake kekeknga wam takngatu ma yawa kekekawan. Wena siknga. Ginda Anututa enandang yuak ngang natayuke wamu takngatu yawa kekekawikge natake, ‘Siakan enandang,’ ngang ma yawam. ");
INSERT INTO wnc_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Siwan ginda kepdakae yake wamu takngatu ma yawa kekekawan. Wena. Kepdaka Anututa kunggaunin. Siwan Jerusalemu Buyambam tapatane yotbam gapma ngang natayuke ginda Jerusalemde umana yake wamu takngatu yawa kekekawikge ma yawam. Wena. ");
INSERT INTO wnc_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Siwan ginda gwapakzae ma katapmike wamu takngatu yawa kekekawan. Wena. Ginda gwapak danggamza tasiwa kwaknga ba zikaa sinanga dua. ");
INSERT INTO wnc_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Sike wamu takngatu kekekawikge natake mamaya ngwakngake yakainggane yapii Seten ngang natayuke ginda siakan ba aho nganggan yanong,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Ginda wamu tupa siknga ngang yakut taknga atnataaing. ‘Kaika tasiwan wai siwanu yake kaina tasiwi wai siyok. Sike genda zipmanziwanu yake gena zipmanziyo,’ ngang yakut. ");
INSERT INTO wnc_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ngana apmanu nata daniwa natapnong. Ginda aminu ginde wai tasindamanu waapa yake wai ma tasingamam. Wena. Sike aminu tapatuta aamba kautdu wesiwanu katewi aamba gatu kautduat wesiyok. ");
INSERT INTO wnc_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Sike gata aminu tapatutane sanga tasiwi maiwan kake siotda tapikge natake wam yawiyakge yawanu gatane got taukga kuut ie imuyo. ");
INSERT INTO wnc_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Sike amak aminu tapatuta yake yaknga gwaamumbi kusande asiknga kekekake you gapmandune kusande yawanu kusika you wanggapma kuyapbike you gapmandune kuson. ");
INSERT INTO wnc_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Sike aminu tapatuta gatane sanga tapatu tanangge yawanu gata banip gwaang natangamuke asimuyo. Sike aminu tapatuta sangaka nami pakuke gatu pakapuke apmea gama ngang ganiwanu gata asimuyo,” ngang yakut. ");
INSERT INTO wnc_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Ginda wamu tupa yaking kaknga gwa natapbing. ‘Gata aminu gae wesim yuwik kapae musip gwaang natangamuke iwandae musipba toknga natangamuyo,’ ngang yaking. ");
INSERT INTO wnc_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ngana nata daniwa natapnong. Ginda musip gwaangu iwanzae natayamunong. Siwan ginda tumuk wamu Anutu iniwa natake aminu ginde wai pasindamukaingge gatayamik,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","“Unzingge ginda Nanza enandang yuak kapata asinggan pasinggak kaknga pasike itane waaknga daknganing. Ita gunzitna tasiwan enane wai amikat gatu take amikatde akopan ita sopa tasiwan amin nomankat aminu waiatde kuut tanggak. ");
INSERT INTO wnc_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Sike ginda aminu musip gwaangu ginde natandamukaing amindekan ginda yake musip gwaang natayamukengu ginda buya mina binga paning? Wena. Kait pasiyuk takis papsa aminda unzingu atasikaing. ");
INSERT INTO wnc_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Siwan ginda notzaekan gaak wam yanikengu ginda aminu kundu sanga mina bingae yapbitning? Wena. Aminu Anutue dua nataaing amin kaya unzingu atasikaing. ");
INSERT INTO wnc_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Unzingge ginu Nanza enandang yuak kapata noman siknga yuak kaknga binga gikaya noman siknga yutnong,” ngang yakut. ");
INSERT INTO wnc_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Ginu gwautnong. Ginda sangaaknga takeakesa aminde kaine pasiwa kaningge ma pasiwam. Sike ginda unzing tasikengu buyasa Nanza enandang yuak kapae dua paning,” ngang yakut. ");
INSERT INTO wnc_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Sike gata sanga aminu sangaapana wenae gatayamunangge natakengu gata apaa ma yayawambim. Aminu pum yanggak kapa iniwi puyapan natake apu gandupning binga unzingu gena gwakngaana kaya aminda aminbamda umana pangenatningge natake miti yot katang ba kepiapane yuke yamuke pasikaing. Nata siakande siknga daninggat. Wa amindane umana pangenawawa gatayamukinggane buyana unin paking. Enandang yuak kapata sanga takngatuat yake dua yamik,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","4","“Sike gata sangaapana wena amin gatayamunanggengu puya gatane butaya waaknga akusopuke yuwan notda sikngaapata dua natapan masande Nanggata yake gae akgamik,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Sike tapduknga ginda tumuk wam yaning gwekatangu unzing kem aminda yakaing kaknga ma tasiwam. Wa aminu aminda kaningge miti yot katang ba kepinomdakane dandam tangan yuke tumuk wam yanangge asiknga bakngakaing. Nata siakande siknga daninggat. Wa aminu umana pangenawawa buyana unin gwa paking. ");
INSERT INTO wnc_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Sike tapduknga gata tumuk wam yananggengu gata yotdaatang koke gwabokga yapuke Nangga kusopuknga unzaatang yuak kapae tumuk wam iniwi sanga kusopukngaatang ininggayau atnatake akgamik,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Sike ginda tumuk wam yaning gwekatangu wamu takngatu takngatu yumdekanu katum aminda anutu pupuknga ngang yanikaing binga ma yawam. Wa aminda wamu nangaakan yana ita natapik ngang natake ");
INSERT INTO wnc_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","tasikaing kaknga ma tasiwam. Sike Anutu gindane Nanzata sanga kuupbam ginda dapmakaingu ie dua yakaing kopatangu atnataak. ");
INSERT INTO wnc_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Sike ginda tumuk wamu anzing yanong, ‘Nanin. Gata enandang yuayak. Gatane umanda yatangenatningge nataamang. ");
INSERT INTO wnc_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Gata amin panangge tasinggayak kakngata ninde asapsok. Asapan gatane banip enandang nana aminda tawakaing binga ninu kepdakane yuamang aminda unzakan tawanim. ");
INSERT INTO wnc_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Apmanu nanaminu tapduu anggwene dapmakamangu nimuyo. ");
INSERT INTO wnc_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Aminda ninde waiaknga pasinima sandeyamukamang binga gata waiaknganinu sandetnimuyo. ");
INSERT INTO wnc_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Siwan gata sanga nin pasiwan sinimde ma ninipakuwim. Sike gata nin gatanimi Setenda ninu dua pasiwa mainim.’ ");
INSERT INTO wnc_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Unzingge nata ginu daniwa natapnong. Ginda aminu kundutane waina sandeyamanu Nanza enandang yuak kapata gindane waiakngasa asandetdamik. ");
INSERT INTO wnc_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Siwan ginda aminu kundutane waiakngana dua sandeyamanu Nanzataaya gindane waiakngasa dua sandetdamik,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Sike ginda Anutuekan natayutnangge natake nanam teke dua nake yukengu aminu inane umanaaknga tangenawan buyambam siwikge pasiya aminda binga ma tasiwam. Wa aminda nanam dua nake yuke nomna maiwan aminbamda kake nanam dua nake yuaing ngang kake umana yatangenatningge tasikaing kaknga ma tasiwam. Nata ginu siakande siknga daninggat. Wa aminu kake yanimbakngake tasiwa buyana unin gwa paking. ");
INSERT INTO wnc_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ngana ginda Anutuekan natayutnangge natake nanam teke dua nake yukengu ginu asinggan tasike yuaing kakngakan tasinong. Wel yanggata gwapakzane pasike nomzane kuut pasike nomza iaknga siwa yutnong. ");
INSERT INTO wnc_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Unzingge aminda Anutuekan natayuke nanam teke yuaing ngangu dua dandupning. Nanza akusopuke yuak kapatakan ie atnataak. Atnatake Nanzata sanga akusopuke tasikaingu akake sanga take siknga atdamik,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Ginda sanga takeakesa keu andakane gisae ma tandakngawam. Keu andakane gwakgwakga nanggamuwawa sangaapa koknga kwake apasiwa maiwawa kuka aminda papa waiwa koke kukae pakaing. ");
INSERT INTO wnc_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Sike ginda sanga takesa enandang penong. Enandangu gwakgwakga nanggamunu dua sikaing. Sangaapa koknga kwake dua pasiwan maikaing. Kuka aminda dua papa waiwa koke kukae pakaing. Wena. ");
INSERT INTO wnc_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Keu gindane sangaapasa take sikngata yuaing komde ginda musipzaatang natanggamataning,” ngang yakut. ");
INSERT INTO wnc_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Kaikata gupbatane kakaa sike kaikata take yuwanu kakaa akngane yuke take kuya. ");
INSERT INTO wnc_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Sike kaikata wai siwanu zikaa dakaatang wasiyawake yuya. Unzingge kakaa akngaatangu yuwiyau waaknga apbinga zikaawanu zikaa waakngata zikaa siknga singgamik,” ngang yakut. ");
INSERT INTO wnc_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Siwan aminu tapatuta puya toiu tapaayae genu unekan bokngan gwaamutnanga dua. Unzing tasikengu ita tapatue take natake tapatue wai natangamik. Sike tapatue banip gwaang natangamuke tapatue semna natangamik. Ina unzakan ginda Anutue nataaing kakngaat sangaapa buyambam panangge nataaing kakngaat unekan bokngan pake pasiwa meya siwik,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Unzingge nata ginu daniwa natapnong. Ginda kayuk yutnangaakngasae nangaakan ma natapam. Ninu mina nake tangoke dua kumnim ngang nangaakan ma natapam. Dasingge? Kayuk yutnangaakngasa atdamukut tapata nanamza kuut atdamik. Siwan gupza atasikut tapata taukza kuut atdamik,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","“Ginda kwaiu atugwegwenu kanong. Nanam zak dua kwaike paku yotnaatangu dua peaing ngana Nanza enandang yuak kapata nanamu ayaman nakaing. Sike Anutue kaine ginda kwaiu gatukande yapbike yuaing. ");
INSERT INTO wnc_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Sike gikatnana tapatuta natagwaanguke apmea tapduknga dua kupik gwenu kundusipat dua isatakopik,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Siwan ginu dasingge taukge nangaakan natanggamatakaing? Zongazonga akoke tapuya aawan kana take siknga singgakge ginda natapa siyok. Zongazongata puya dua tasike tauknga dua bupmake tasikaing ngana zuyuknga kana take siknga singgak. ");
INSERT INTO wnc_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Siwan bapunindane buyambamtapa Solomon ngang inikamang kapatane umana buyambam siknga siwan sangaapana tuyuknga dua sikut. Ita gupna take siknga tasibakngakut takngae natapna take singgak. Siwan ngana tapuya aake awaiwan kana take siknga siwan Solomondane tauk gwaam yapbiban kaamang,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","“Siwan zongazonga puyaangaatang apman akoke yuaingu kwepna zike katapatang saning. Sike zongazongata mani dua pasikaing ngana Anututa tasiwan kana take singgak. Siwan ngana Anututa gataniman dua dapnim ngang ginda dua natapa kekekawan ");
INSERT INTO wnc_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","nangaakan natake anzing yakaing, ‘Ninu nanaminu zane nanim,’ ngang yake, ‘Yangganin ninu zane tangopnim? Tauknginu zane panim,’ ngang yakaing. ");
INSERT INTO wnc_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Sanga wa aminu dongu kundune nana Anutue dua nataingga asinggan asinggan panangge yakaingunin. Nanza enandang yuak kapata dandupan ginda aminu sanga wa apananga aminda yuaing ngang danduak. ");
INSERT INTO wnc_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Unzingge sanga wa kepdakane nanae nangaakan ma natapam. Anututa amin panangge tasinggak kakngae natanggamatake itane kepina katak tasinong. Ginda unzing tasiwanu Anututa sanga kepdakane nana atdamik,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","“Siwan kwep apik kakngae meya ma natapam. Siwan meya kwep kanim takngaat apman kaamang kakngaat unekan peke natapna meya singgak. Siwan kweu meya takngatu ba kanim ngangu ma natanggamatawam,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Ginda wamu katak dua natake aminu usanzike ma inisapduwam. Anututa yake gin usanzitdamuyak. ");
INSERT INTO wnc_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Sanga ginda aminde usanziyamukaing kakngasa kake Anututa ina unzakan yake gikaya usanziwik. Siwan sanga amindane usanziyamukaing binga ina unzakan Anututa usanzike yake damik. ");
INSERT INTO wnc_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","4","“Dasingge dapandapa mateknga notdae kaine yuwan kake nata kwagiwa akopan ngang inike ngana katap sanu gikane kaikane yuak sande dua nataayak binga tasinggayak? Tasike notdata waiaknga mateknga tasiwan kake ngana gikane waiaknga buyambam tasinggayak kaknga takusopunggayak. ");
INSERT INTO wnc_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ga kem amin. Tupanu katau buyambam sanu kaikane yuak sanu kwagiwi akopana masande gata katak siknga kake dapandapa notdae kaine yuau kwagikngamuyo,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Siwan ginda Anututane sanga takwanu Anutue masa gwa imuking aminde ma yamam. Yama tapa tekwamban kamunda binga gisa dasipnang. Siwan ginda sanga takeakesa wai pasiya aminde ma yamam. Yama kake ikwawata binga wa yamuningu yainggamunang,” ngang yakut. ");
INSERT INTO wnc_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Ginda Anutue tumuk wam iniwanu ita sanga ginda dapmakaingu ginde atdamik. Ginda sangae tawake dapmakaingu akaning. Ginda yot gwekatang kopnangge natake yawanu Anututa ginde gwabou atzitdamik,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","“Mamin amindaka Anutue tumuk wam inikaingu wa aminu sanga apaning. Siwan mamin amindaka sangae atawakengu wa aminda akaning. Sike mamin amindaka kepman yuke yoakatang kopnangge wam yakaingu wa aminde atziyamik,” ngang yakut. ");
INSERT INTO wnc_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Sike aminu gikatnana tapatutane waakngata nanae skon imikge yawanu nanata suu gwendu imik ba dasing? Wena. ");
INSERT INTO wnc_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Sike waakngata nana baambu imikge yawanu nanata gomou wai takngatu imik ba dasing? Iaya wena. ");
INSERT INTO wnc_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Unzingge ginu wai pasiya amin dakngake yuaing ngana waakzae sanga take siknga yamukaing. Siwan Nanin enandang yuak kapae inikaingu damunangge apmeptawik ba dasing? Wena,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Sanga kuupbam aminbamda ginde tasindamuning kakngae natake ginda gamok tupan tasiyamunong. Tasiwa wa Mosesdane mama wapat ayanikapsa aminde wapatda buya unin aawik,” ngang yakut. ");
INSERT INTO wnc_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Ginda gwabou mateknga gwatzipatang kopnong. Siwan kepi tapatu ngwayokngaapa. Sike aminbamda kepi ngwayoknga waapane kukaingu wena sining. ");
INSERT INTO wnc_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Sike gwabou kayuk yutnangae kopsa gwau gitna siwan kepi kayuk yutnangatane kwatan siknga. Siwan aminu tapatu tapatutakan kepi waapa akaaing,” ngang yakut. ");
INSERT INTO wnc_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Sike kem aminu kunduta apmea apuke kait wam daniwa ma natapam. Kait wam danike pasiwa mainingge apning. Apuke yawan ginda natake notnin ngang natapning ngana kamunda kaap yasikaing binga apu pasiwan unzing sining. ");
INSERT INTO wnc_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Danike aminu waakwakga puya takngatu takngatu pasiwa kake waakwakge kem amin ngang ginu anggaman natapning. Ginda atnataaing. Wain tapunda bombing kakngane dua aakainggen. Siwan katap tapunu gwendu umana pik ngang yakamang. Siwan zongazonga paanga kayata pik tapunu dua aakaing. ");
INSERT INTO wnc_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ina unzakan katau dakatuta buya take siknga aawan kake katau wandaka take siknga ngang yakamang. ");
INSERT INTO wnc_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Siwan katau dakatuta buya wai aawan kake katau wandaka take dua. Songandakae buyana aatnanga dua singgak. Siwan katau dakatu songandakata buyana take aatnanga dua singgak. ");
INSERT INTO wnc_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Siwan katau dakatuta buyana take dua aawan kake patzitning. Patzike katapatang saning. ");
INSERT INTO wnc_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Unzambinga gwa danit. Aminu waakwakga puya pasiwan buyana aawan kaning. Kake aminu wa take siwan aminu wa wai ngang ginda anggaman natapning,” ngang yakut. ");
INSERT INTO wnc_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Siwan kunduta, ‘Kuyanin! Kuyanin,’ ngang nanike ngana siakan siknga dua nataaing. Kautdu kem yakaing. Siwan Anututa gwaboknga unzing yaya aminde ziyamunanga dua. Siwan Nanin enandang yuak kapatane banip tawananu Anututa gwaboknga zitnimik. ");
INSERT INTO wnc_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Tapduknga Anututa amin usanziwik gwekatangu aminu buyambamda anzing nanining, ‘Kuyanin! Kuyanin! Gata ninipewi kuke gatane wam takeaknga ngang yanikapbumang. Ninipewi kuke waung waiakwak yanikwasike puya kekeknga takngatu takngatu buyambam pasikumang. Pasina dua nindupbuyak ba dasing,’ ngang nanining. ");
INSERT INTO wnc_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Naniwa ngana yake anzing yaniwit, ‘Ginu kukakut. Ginu natane amin dua dakngaking. Ginu aminu wai,’ ngang yaniwit,” ngang Jesuta yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Sike mamin amindaka nata wa daninggat taknga natake tasikengu ita anzing binga dakngawik. Aminu tapatu natdetdetna nomanaapa binga. Siwan ita yotna supda tepan kusiwan mitapbut. ");
INSERT INTO wnc_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Mitapan sopata tawan yangga apaptawawan gotda kekeknga puyapan ngana you wagwenu dua pimakut. Dasingge? You wagwendane simenu suu buyambam gwegwene kep ganang katang kekeknga siknga tapan kekekakut. ");
INSERT INTO wnc_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Sike aminda natane wamu waaknga natake dua tasikengu ita anzing binga dakngawik. Katum aminu tapatuta yotna saisai dakanekan mitapbut. ");
INSERT INTO wnc_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Siwan sopa ataawan yangga apaptawawan gotda kekeknga puyapan you wagwenu apimakut. Ngan, ita asiknga pimakut!” ");
INSERT INTO wnc_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jesuta wamu waaknga yawan puyuwana aminbamda natake asatnaking. ");
INSERT INTO wnc_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Dasingge? Ita mama wam yanindamumsa aminda binga dua yanindamukut. Wena. Ita kekekngana kayaapa yuakge ninindamukgak ngang natapbing. ");
INSERT INTO wnc_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Siwan Jesuta tawandaka teke pukuwawan aminbamda kuku tawaking. ");
INSERT INTO wnc_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Tawawa ngana aminu tapatu watana kekeknga sikut tapata inengan apuke muna puke gwetake inimbakngake anzing inikut. Buyambam tapana. Gata take natakengu na tasingami gupma dudumna siwa ngang iniwan ");
INSERT INTO wnc_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","natake katakngita wasiyuk anzing inikut, “Nata gatane gupba dudumna siwikge nataat,” ngang iniwan watana kekeknga wa zetgaman wena sikut. ");
INSERT INTO wnc_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Siwan Jesuta wamu kekeknga anzing inikut, “Gata katak siknga gwaumso. Gata kuke aminu tapatu sanga wa tasinggamunggatde ma iniwim. Ngana gata aminu Anutue yot takwan gwene pasiya aminde kuke gupba yeuyamuyo. Yeuyamuke gupba take singgakge sangaka Anutue imuyo. Unzing Mosesde mama wamda tupa yakut taknga sangaka imi ganduke wataka wena gwa sik ngang yawan aminbamda natapning,” ngang inike initewan kukut. ");
INSERT INTO wnc_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Siwan Jesuat ninu pandetnaatda Kapaneam yot gapmane kopna amak aminu 100-dane tupan tapata apuke anzing ininggamatakut, ");
INSERT INTO wnc_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Buyambamtapa. Natane puya amina mait sike yoakatang yuak. Itane kwatai gatukande kupan tokngabam natayuak,” ngang iniwan, ");
INSERT INTO wnc_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","“Nata kuke tasiwa take apme siwik,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Iniwan ngana yake anzing inikut, “Buyambamtapa. Na aminu nomanaapa dua ngang inike yotnaatangu dasingge akopsa? Gata wamban yawi natane puya aminata maitna wena siwan,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","“Dasingge? Na aminu natane buyambam tapatane gepbiatangu ayuat. Sike nakaya natane amak amina nae gepbiatang yuaikat nana tapatu initewa kuke puya tasiwikge iniwa ita akunggak. Sike amina tapatu, ‘Apso,’ ngang iniwanu ita asapunggak. Sike nata puya amina puya takngatu tasiwikge iniwanu ita atasinggak,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Iniwan natake Jesuta asatnakut. Asatnake aminbamu i tawaking aminde anzing yanikut, “Nata ginu daniwa natapnong. Isrel nana aminu tapatu baniu aminu aapata nae natangamunggak binga tapatu wena kaat,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","“Siakande daninggat. Aminbamu kaukaut yuaing amikat Ebrahapat Aisakat Jekopat ngang apuke uneken gatake yuke aminu Anututa papan itane aminabam dakngake yuaikat gatake yuke nanamu naning,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","“Sike aminu tupan Anututa panangge tasike yakut takwau Anututa yanikwasiwan kepman siknga zikaa dakatang kuning. Ugwak saak kuke musia toknga asinggan natanggamatake kwanam sike tokngabam pake kaakake yutning,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yaniwan puyawana amak amindane buyambamtapa anzing inikut, “Sanga tasinggamitde natapi kekekak kakngakan buya unzing singgamik. Ge kunggayo,” ngang iniwan kuwawan puya aminata take sikut. ");
INSERT INTO wnc_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Siwan Jesuta yoakatang koke kawan Pitata maatnatane minga mait natapan gupna toknga siwan pekgawan kakut. ");
INSERT INTO wnc_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Kake katakngita wasiwan mait taknga tewan kuwan enake Jesue nanam tandakngakut. ");
INSERT INTO wnc_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Siwan bangee aminu waung waita paking aminu pake Jesue pakapbing. Pakapa yake waung wai wa yanikwasiwan kuwa mait aminu kuupbam maitna sandeyamukut. ");
INSERT INTO wnc_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Unzingge wamu takngatu ayanikapsa Aisaiata anzing matakut, “Nindane maitninu takngatu takngatu kuupbam sandetnimukut,” ngang wa matakut taknga buya unin aakut. ");
INSERT INTO wnc_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Siwan Jesuta kawawan aminbamda yupbasiwa kake pandetna anzing yanikut, “Kuwa ninda yangga gapan gwenu kautdu saak kuna,” ngang yaniwan kunangge tasiwawa ");
INSERT INTO wnc_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","mama wam yanindamumsa aminu tapatuta wesim apu anzing inikut, “Yanindamumsaapa. You kuupbam gata kuwiyak gapma gapmane naat kuut kusim,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Iniwan yake anzing inikut, “Kaap zongu yotna kaya siwan kwaiu kuut yotna kaya. Siwan ngana na aminbamdane notnaapa dakngake yuat tapa yotna apetnanga gwendu wena,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Siwan pandetna tapatuta anzing inikut, “Aana. Gata nandutewi nata kuke nana gamok kwaiwit,” ngang iniwan ");
INSERT INTO wnc_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","yake anzing inikut, “Undanga. Kumnanga aminda kupsa amin notna apme kwaining. Sike ga apu na nawamso,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Siwan Jesuta dopangbam gwene kopan kake pandetna kuut undang kopbing. ");
INSERT INTO wnc_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Koke kuwawa gou buyambam puyapan yanggabam gwenu sambuya asenaawan yanggata dopangbam gwenu atdopnangge sikut. Siwan Jesu dapuna pewawan ");
INSERT INTO wnc_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","kuku tanguwa enawan anzing iniking, “Aanin. Gata ninu gatanimuyo. Kumnanggekamang,” ngang iniking. ");
INSERT INTO wnc_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Iniwa yake anzing yanikut, “Dasingge ginu gwaukaing? Nata sandewitde natapa dua kekekawan gwauke unzingu yakaing ba dasing,” ngang yanike enake gokat yangga sambuyaatde kanga yakut. Yawan gotda zakngawan yangga sambuya enakuu zetgaman kuma siknga yuwan ");
INSERT INTO wnc_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","kake pandetnata nangaakan natake anzing yaking, “Aminu aapa inata kundu. Ita yawan gokat yanggaatda zakngawat kaamang,” ngang yaking. ");
INSERT INTO wnc_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Siwan yangga gapan gwenu kautdu saak Gadaratane kep komune kuking. Undang kundopa aminu tapaaya waung waita musiaatang pukuke papa aminu waapaatda zong siknga dakngake matmat gapmane yuwawat aminu tapatuta keu waopatang kunanga dua sikut. Siwan aminu waapaatda matmau wanggapmaneta apuke Jesu kake ");
INSERT INTO wnc_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","apaa siknga anzing inikumayak, “Anututane waaknga! Gata ninde dasing tasinimuya? Apmanu tapduu dua siwawan ngana gata apuke ninde toknga nimunangge apunggayak ba dasing,” ngang inikumayak. ");
INSERT INTO wnc_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Iniwat ikwawa takwakgu maa sim yuke nanam nake ");
INSERT INTO wnc_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","yuwawa kake waung waiakwakga yanggamatake Jesu anzing iniking, “Gata ninu atninikwasikengu gata ninipewi ninu kuku ikwawa waakwakgane musiaatang pukuke panim,” ngang iniwa ");
INSERT INTO wnc_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","yanikwasike, “Ginu kukakut,” ngang yaniwan aminu waapaat peke kuku ikwawa waakwak pukuke paking. Pukuke papa ikwawa waakwau kekeknga siknga isapmake kuku dameatang pimake puku yangga gapanu wagwene pimake yangga tangoke akumbing. ");
INSERT INTO wnc_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Siwan ikwawa wa toikaingga kake atdatakuke kuku yot gapmane kuke wamu wa kuupbam sanga aminu waapau waung waita pakingu yanikwasiwan kuke tasiwa kaking kakngae yaniking. ");
INSERT INTO wnc_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Yaniwa natake you wanggapmane nana aminu kuupbamda apu Jesue tawake kake kepna teke komduatang kuwikge ininggamataking. ");
INSERT INTO wnc_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ininggamatawawa dopangbamu gwendu yangga gwene kwaimtapane yukut. Yuwan Jesuta une kopan taku kautdu kwaimtapane taku tekut. Teke yotna kukut. ");
INSERT INTO wnc_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Kuke yuwawan mait aminu tapatu kwatai gatukande gwa kumbing kapa notnata Jesue bek gwene teke gwaamutakuking. Gwaamutakuke Jesuta maitna apme sandekngamik ngang natapa kekekakut taknga kake Jesuta mait sikut tapa anzing inikut, “Waatdakana! Waiakngaka gwa sandekgamunggat. ");
INSERT INTO wnc_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","“Banipbaatang tatanga natapso,” ngang inikut. Iniwan natake aminu Mosesdane mama wam yanindamumsa aminu kunduta anzing yaking, “Waapata Anutue umana aknga tasiwan maiwikge yanggak,” ngang wepda yaking. ");
INSERT INTO wnc_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Wepda yawa ngana Jesuta wamu wa baniaatang natapbing kaknga anggaman natake anzing yanikwaikut, “Ginu minae banipzaatang wai nataaing? ");
INSERT INTO wnc_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","‘Waiakngana gwa sandekngamutde gatu maitna sandekngamuke ga enake kungga,’ ngang iniwa ginda kake dasing natapning? Puya zaaknga kwanga siknga tasinanga? ");
INSERT INTO wnc_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Siwan na aminbamde notnaapa dakngake keune epu yuke amindane waiakngana sandeyamitde nanitewan apbum taknga nata take tasiwa ginda kake natdetningge tasiwa kanong,” ngang yanikut. Yanike aminu kwatai kumbing kapa anzing inikut, “Enake bek gwenu gika gwaamutake yotda takungga,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Iniwan maitna wena siwan aminu waapata enake yotna ina gwaamutakukut. ");
INSERT INTO wnc_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Gwaamutakuwawan kake Anututa kekekngana aminu tapatue iman tasiwan kaamang ngang kuupbamda natake Anutue akgwauke inimbakngaking. ");
INSERT INTO wnc_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Siwan Jesuta uneta apu nanduwawan na aminu takis panggat tapa umana Matyu ngang nanikaing. Nata takis mani peainggane opis gwene pukwike pawawa nanduke anzing nanikut, “Ga pandetna dakngawiyakge apu nawamso,” ngang naniwan enake kuku tawakum. ");
INSERT INTO wnc_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Siwan masande nata Jesuat pandetnaat yayawamba yotnane akopa yuke nanam nawatna kait pasiyuk takis papsa amikat wai takngatu takngatu pasiya amikatda natane yotnane koke pukwike nikat gatake yuke nanam nakumang. ");
INSERT INTO wnc_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Nanam nawatna Judia aminu kundu Mosesde mama wam nangaakan gwaamumsa aminu Ferisi ngang yaniking. Iatnana kunduta ninduke ninu Jesutane pandetna anzing ninikwaiking, “Dasingge aanzaat takis kukae papsa amikat waiaknga pasiya amikatda unekan yuke nanamu nakaing?” ");
INSERT INTO wnc_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ngang ninikwaiwa Jesuta wamu waaknga natake tuwang wamu takngatu anzing yanikut, “Aminu maitna wenata doktae dua kukaing. Aho. Maitna kaya amindakan doktae kukaing,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","“Anututane wapatang anzing yakut, ‘Nata sanga upat binga namuningge bitanggat. Na musipza kwikwiknga notzae natayamuningge take nataat,’ ngang yakut. Sike ginu wa yakut takngae kuke natdetdet panong,” ngang yanikut. “Nata apuke amin noman yuamang ngang yakaing amin yayawamba musia tapa tekwambikge dua apbum. Aho. Nata waiakngana kaya amin yayawamba apuke musia papa tekwambikge natake apbum,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Tapduu waomune Jondane pandetnata Jesue apuke anzing iniking, “Dasingge nikat Ferisi amikatda tapduknga Anutuekan natanggamatake nanamu teke dua nake yuamang. Siwan ngana gatane pandetda nananu dua teke asinggan nakaing,” ngang inikwaiking. ");
INSERT INTO wnc_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Inikwaiwa ita tuwang wamu kundu anzing yanikut. “Aminu tapatuta maatna tanangge natake iat notnaat gatake yuke musia meya natapning ba dasing? Wena. Ngana masande aminu maya tapiu waapa takuwa notna wa amikat dua gatake yukengu tapduu waomune wa aminu notnae musia meya natake nanam teke dua nake tomda yutning,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Sike aminu tapatuta tauu kayuk sanzim take tauknga bumi awesikuu ganangi dua bupik. Wena. Unzing tasiwanu tauu ganangi bupiu wa sanda goopan gatu awesiwan ganangi buyambam siwik. ");
INSERT INTO wnc_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Siwan aminu tapatuta wain yangga kayuk kaknga toknga akngana kaya wa memenggane gupna yanggaumande dauke bupbingu bumi gopatang dua tukngwamban pukuwik. Wena. Unzing tasiwanu memenggane gupna wagomu atdakngawan wain yangga kepdakane tukngwapimapa memenggane gupna wagomu wai asiwik. Ngana wain yangga kayuk kaknga memenggane gupna kayuk gopatang tukngwamban pukuwan sanga wa kuutda take yutzan,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesuta wamu waaknga ayayuwawan take aminu tapatuta inengan apuke ie kataknga puke inimbakngake anzing inikut, “Natane yapana apmatzim siknga gwa kungwak. Ngana gata apuke katakga wasiwi gatu gweawan,” ngang ");
INSERT INTO wnc_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","iniwan natake Jesuta waapa tawamban kuwawat pandetna iat gatake kuking. ");
INSERT INTO wnc_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Kuwawa maya tapatu yekapna sike asinggan daknga pake yuwawan nakanu 12 gwa yapbikut. Maya waapata Jesutane masene inengan siknga kuke ina musiane anzing natapbut. Nata katakngatakan taukngane wasiwa maitna wena siwik ngang natake apu Jesutane tauknga nomna saasaaknga wanganekan wasikut. ");
INSERT INTO wnc_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Wasiwan ngana tapan tekwamban kake anzing inikut, “Yapana. Meya ma natapim. Nata gatanggamitde natapi siakan siwan tasiyak kakngata maitda tanguwan wena gwa singgak,” ngang yawan tapduu waomsimunekan gatu take sikut. ");
INSERT INTO wnc_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Siwan Jesuta take aminu waapatane yotnane kundoke kaawan aminda keknga gom puyaawa aminbamda gwa kumbut tapae natake kwanam kumzang siawa gakngatbam siwan kake ");
INSERT INTO wnc_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jesuta anzing yanikut, “Ginu teke kunong. Maya waapasimu gatukande dua kungwak. Dapuna pekgak,” ngang yawan natake ");
INSERT INTO wnc_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","kumzang inimiking. Miba kake yanikwasiwan kepman kuwana Jesuta yoakatang koke maya mateu waapasimdane katakngine tapan gatuna asenakut. ");
INSERT INTO wnc_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Siwan wamu waaknga ugwak saak yuaingge yatakuking. ");
INSERT INTO wnc_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Siwan Jesuta you wanggapma teke kuwawan aminu kai wai siya tapaata tawayuk anzing yanggamatakumayak, “Ga Devitdane dongane aakuyak kapa. Nitde butaya natanimuyo,” ngang inikumayak. ");
INSERT INTO wnc_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Inike tawawawat yoakatang kopan kai wai waapaau inengan apat Jesuta anzing yanikut, “Gitda sanga waaknga tasiniman kainitda take sining ngang nanduke nanikamayak ba dasing,” ngang yawan, “Buyambamtapa ngan,” ngang iniwat ");
INSERT INTO wnc_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","katakngita kaine wasike anzing yakut, “Tasiniman take sinimik ngang nanduke nanimayak kakngakan gitde sindamuyok,” ");
INSERT INTO wnc_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","ngang yaniwan kaina gatuna kakumayak. Kake yuwawat Jesuta kekeknga siknga yandakngake anzing yanikut, “Sanga sindamuk kakngae ma yaniwat. Aminu tapatuta natapsak,” ngang yaniwan ");
INSERT INTO wnc_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","natake ngana epu kepman kuke ie wamu aminu ugwak saaknanae keu kuupbam yakapbumayak. ");
INSERT INTO wnc_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Sike aminu waapaau akunangge siwawat aminu waung waita tapan gena kusiya tapatu takapa Jesue apbut. ");
INSERT INTO wnc_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Apan kake waung wai wa inikwasiwan kuwan gena kusikut tapata wamu ayawan kake aminbamda nangaakan natake anzing yaking, “Tupa anza binga kundu Isrel kep komune dua siwan kakumang,” ngang yawa ");
INSERT INTO wnc_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","ngana Ferisi aminda anzing yaking, “Ita waung wai kekeknga waung wai akwakgane tupan tapatane kekeknga aknganane yanikwasiwan kukaing,” ngang yaking. ");
INSERT INTO wnc_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Siwan Jesuta yotbam gapma gapma gatu yot matek gapma gapmane inandek inandek kuke miti yotnane koke yanindamukut. Wamu takeaknga Anututa amin panangge tasinggak kakngae wam yanikapmake mait aminu pasiyaman kuupbamda take siking. ");
INSERT INTO wnc_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Sike aminu buyambamda natdetdetna buyami siwan sipsip takwau toiknga wena dakngake yuaingga binga yumdekan siknga yuwawa kake butaya natayamukut. ");
INSERT INTO wnc_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Butaya natayamuke ita ninu pandetna tuwang wamu takngatu anzing ninikut, “Nanamu buyambam siknga puyaangatangu gwa yukaing ngana buya papsa aminu kwaapzang gua. ");
INSERT INTO wnc_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Unzingge ginda ayukawa buya papsa amindane toikngae iniwa natake puya aminu kundu yanipewan kuku nanamna pake pengamunong,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Siwan Jesuta pandetna katau kuut musaat kepianganu tapaaya ngang yaniwamban apna kekeknga aknga waung wai yanikwasitnimde nimukut. Nimuke mait aminu maitna sandeyamuke upeke yuya aminu tasiyamuna take siningge nimukut. ");
INSERT INTO wnc_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Puya aminatane umaninu anzing. Saimon umana takngatu Pita siwan uyapna Endru. Siwan Jemskat uyapna Jonkat Sebeditane waaknga. ");
INSERT INTO wnc_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Siwan Filip gatu Tomas gatu Matyu na takis panggakapanin. Siwan Jems Alfiasdane waaknga gatu Tadias ");
INSERT INTO wnc_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","siwan Saimon kekekngaapa ngang inikumang. Siwan Judas Iskeriot yot gapmane nanaapata Jesu iwanae yeuyamukut tapa. ");
INSERT INTO wnc_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Siwan Jesuta ninu aminu katau kuut musa kepianganu tapaaya ngangge anzing ninikut, “Ginu aminu dongu kundune nana Anutue dua nataaing aminde ma kuwam. Siwan ginda Samariae yotbam gapmane ma kopam. Wena! ");
INSERT INTO wnc_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ginu Isrel nana aminu toiknga teke datakuke upeke yuya amindekan kunong. ");
INSERT INTO wnc_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Tapduknga Anututa amin panangge tasinggak kakngata apnangge dapaknga gwa singgak ngang yaninong,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","“Ginda mait aminu maitna sandeyamuke akupsa aminu pangenatnong. Siwan wata kekeknga siya pasiwa dudumna siwa waung wai yanikwasitnong. Kekeknga aknga ginda pake yake buyata dua usiing. Unzingge ginda sanga wa pasiyamuke ginda yake buya nimunong ngang dua yanike ie mani ma papam,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Ginda manisa tatakngi san ba kwaknga san ba gamana san ba simbu yakzaatangu ma pake kuwam. ");
INSERT INTO wnc_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ginda yakza gatu taukza gomayana kaya ba kepi taukza gatu gusokza ma papam. Wena. Puya aminda sangae dapanu ayamunanga,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Sike ginda yotbamu gapmandune ba yot mateu gapmandune kukengu katak siknga kanong. Mamin amin tapataka you wanggapmane nana aminda ginu yotnane pakunangge yawan aminu nomana ngang katak siknga kakenga iat kopnong. Siwan gikat aminu waapaat yusika you wanggapma tenangge natakengu you wagwenu teke kunong. ");
INSERT INTO wnc_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Sike ginu you gwendune pakopan kokengu ginda you wagwene nana aminde gaak wam Anututane kwikwiknga aknganata ginde yutdamuyok ngang yaninong. ");
INSERT INTO wnc_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Yaniwa you wagwene nana aminda natapa take siwanu kwikwiknga aknga pake yutning. Sike ngana gaak wamu waaknga yaniwa natapa take dua siwanu musip kwikwiu wa gatusa pake yutnong,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","“Sike aminu tapatuta ginu yotnane pakunangge apbitake ginde wamu dua natapanu you wagwen ba yotbamu wanggapma teke kuke yemi kaikza zipa pimapa kunong. ");
INSERT INTO wnc_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nata siakande siknga ginu daninggat. Tapduknga aminbam usanziwik gwekatangu meya Sodom nana amikat Gomora nana amikatda paning binga dua yotbamu wanggapmane nana aminda paning,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Natapnong. Nata danipewa kuningu wa sipsipda kaap zongge banakan yuaing binga kuning. Kusika ginda gomokga aminda nisipnang ngang natake sukukaing binga natake kuke tasinong. Siwan kombunanangga kwikwiknga yuaing kaknga binga tasinong,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","“Ginda aminde katak siknga gwautnong. Ginu pake kaunsilnae pakuwa wam yaning. Siwan ginu miti yotnaatang ipmapa dasipning. ");
INSERT INTO wnc_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Sike wa aminu natane umana tanguwa pimapikge natake ginu panggaganuke aminu buyambam tapaapae pakuning. Pakuwa ginda nae wamu aminu wa buyambam takwakat dongu kundune nana Anutue dua nataaing aminde kainae yanikapning,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","“Sike ginu wam yaningge pakuwanu ginu nangaakan anzing ma natapam. Ninda wamu dasing yanim? Ninda wamu yake zaaknga ininim? Wena. Tapduu waomunekan Anututa wamu ginda yaningge aknga yeutdamik. ");
INSERT INTO wnc_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Gisatakan wamu dua yaning. Wena. Nanzatane Waungga ginde genzane yakapik,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Sike aminda uyapna wam yawikge takuwan tanguwa kupik. Siwan nanata waakngae unzakan tasiwik. Siwan waakngata minga nanae iwan dakngake pakuwan zipa kumning. ");
INSERT INTO wnc_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Sike ginda natane umana aknganae gepbiatang yuwawa danduke ginde musia zikaa siknga natandamuning. Natandamuke tasinggawa gikatnana mamin amin tapata kekekake yuwawan tanguwa kupiu kayuk yutnanga aknga pake asinggan yuwik. ");
INSERT INTO wnc_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Sike ginda zikaa natake you gapmandune wai tasindamanu ginu datang you gapmandune kunong. Nata ginu siakande siknga daninggat. Ginda Isreldane yot gapmane puya dua pasiwa puyuwawan na aminbamdane notnaapata asapit,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Sike waatdakata ayanindamukgak kapa yapbitnanga dua. Siwan puya aminda kuyanae yuak kapa yapbitnanga dua. ");
INSERT INTO wnc_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Sike waatdaka asinindamukgak kapa binga dakngawanu take siwik. Siwan puya aminda kuyanae yuak kapa binga dakngawanu iaya take siwik. Sike dongu takngatutane tupan tapae umana Bielsebul waung waiakwakgane tupan tapa ngang nanisapdukengu ginu naat nanatane umanza yake kumzang siknga danisapdutning,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Unzingge ginu aminde ma gwaubam. Sangabamu nata danindamukgat taknga akusopuke yuwan masande anggaman siwa kaning. ");
INSERT INTO wnc_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Wamu nata sisip tangan daninggau ginda yanggamatawa natapning. ");
INSERT INTO wnc_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ginu aminu gupzasan dasipa kupana kayuk asinggan yutnanga akngasata wena siwikge tasiwa maiwan tasindamuning aminde ma gwaubam. Wena. Sike ginu Anututa gupza zipan kupa uyungza yanipewan katapbapatang pukuwa unzingu gupzaat uyungzaat pasiwan maiwan tasindamik kapae gwautnong,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Aminda kwaiu gweayasimu mani gamana sandusimdakan usikaing. Ngana Nanzata dua katewanu kwaiu mateknga wa binga gwendusimu kungwake kepdakane pimananga dua. ");
INSERT INTO wnc_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ina unzakan ita dua dandupewanu ginu wai sinanga dua. Gwapakdanggamza kuut gwa kendeke ginu katak toimbikge natake ");
INSERT INTO wnc_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","ginu ma gwaubam. Ita dandupan ginda kwait mateu ayapbiba danduak,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Aminu tapatuta natane uman aminbamde kaine yakapiu nakaya aminu waapatane umana Nanae kaine enandangu ayakapit. ");
INSERT INTO wnc_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Sike aminu tapatuta nae masa aminbamde kaine namiu nakaya aminu waapae Nana enandang yuak kapae kaine masa asimit,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Nata apuke amau kepdakane kuupbam zipbutnangge apbum ngang ginda ma natapam. ");
INSERT INTO wnc_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Na apuke amak zipmandaknganangge dua apbum. Wena. Nata amak tasinangge apbum. Na apuke tasiwa iwan daknganing. Tasiwa waaknga apata nanae iwan dakngawan yapanata mingae iwan dakngawan ainata apekngae iwan dakngawan ");
INSERT INTO wnc_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","you gwendune nanakanda iwan iwan dakngake yutning. ");
INSERT INTO wnc_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Sike aminu tapatuta nana mingae take siknga natake nae takesim natakengu natane notna dakngake yutnanga dua. Sike nanata waaknga ba yapanae take siknga natake nae takesim natakengu natane notna dakngake yutnanga dua. ");
INSERT INTO wnc_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Siwan aminu tapatu iwanata meya takngatu takngatu ima amin saamdakane kupikge gwauke na dua nawakengu natane notna dakngake yutnanga dua. ");
INSERT INTO wnc_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Sike aminu tapatuta inane kayuk yutnanga akngae tawambanu itane kayuk yutnanga akngana wena singamik. Sike aminu tapatuta nae natake puyana tasingaman kake aminda tasiwa maiwanu ita kayuk yutnanga akngana atapik,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Sike aminu tapatuta ginu take siknga toikengu nakaya take siknga toikgak kapa unin. Siwan aminu tapatuta nae take siknga tasikengu Anutu atnanitewan apbum tapae kuut take siknga tasingamik kapa unin. ");
INSERT INTO wnc_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Sike aminu tapatuta ayanikapsa tapatuta apan kake take siknga toikengu buyana ayanikapsa aminda papik kakngakan papik. Sike aminu tapatuta kawawan aminu nomana tapatuta apan kake take siknga takengu buyana amin nomanu waapata papik kakngakan papik. ");
INSERT INTO wnc_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Sike aminu tapatuta natane aminaatnana aminu umana wenaapa gatangamuke yangga gokgoya kap gomune iman tangopiu waapatane buyana wena sinanga dua. Siakande buyana apapik,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Siwan Jesuta wamu waaknga ninu pandetna 12-de ninindamuban puyuwana you wanggapma teke you ugwak saak nanae kuke aminbam yanindamuke itane wamna yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Sike Jonda kaautde yuke natawawan Kraisda puya kuupbam pasinggak kakngae niwa natake pandetna kundu yanipewan Jesue kuking. ");
INSERT INTO wnc_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Kuke anzing inikwaiking, “Ga aminu Anututa initewan apikge yanikapsa aminda tupa siknga ngang yaking kapa ga unin? Ba ninu tapatue kayutnim ba dasing,” ngang iniking. ");
INSERT INTO wnc_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Iniwa yake anzing yanikut, “Ginda kuke Jonu sangabamu ginda natake kaaingge kuut ininong,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","“Kai wai siya aminu gatu kaaing. Siwan kepi wai siya aminu gatuna kepi akukaing. Siwan gupnane wata kekeknga siya aminu gupna dudumna gatu sikaing. Siwan maaknga kusiya aminu wamu gatu nataaing. Siwan kupsa aminu gatu enaawa Anututane wamu take aknga aminu sangana wena aminde yanikapa nataaing,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","“Siwan nata puya waaknga pasiwawa aminu tapatuta nae natapan kekekawiu waapata apbakngayok,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Yaniwan natake kuwana Jesuta aminbamu Jonde anzing yanikut, “Tupa ginu keu amina wena komune kuke ginda sanga mina binga kanangge kuking? Ba ginda kuke komamu tapatu gotda puyapan saa siwan sanga yumdekanu waaknga kanangge kuking ba dasing? Wena. ");
INSERT INTO wnc_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ginu kuke sanga mina binga kanangge kuking? Ginu kuke kawawa aminu tapatuta tauknga takeake pasiwan kanangge kuking ba dasing? Aminu tauknga takeake pasikaingu aminu buyambam tapaapae yotnane yuaing,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","“Ngana dasingge ginu kuking? Ginu kuke yanikapsa aminu tapatu kanangge kuking ba dasing? Ngan. Nata daniwa natapnong. Aminu waapa ayanikapsaapa. Siwan ita yanikapsa aminu kuupbam yapbikut tapa,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","“Aminu waapae Anututane wapatang anzing matakut, ‘Natapso. Nata nae wam yakapikge aminu tapatu initewa gae tupan kuke ita gatane kepika tanomanukgamik,’ ngang matakut. ");
INSERT INTO wnc_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Siwan nata siakande siknga daninggat. Jonu yangga sauyamukut tapata keunenana kuupbam yapbikut. Ngana aminu Anututa papan itane aminabam dakngake yuaikat nana tapatu umana mateknga sikngata Jonu ayapbikut. ");
INSERT INTO wnc_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Tapduknga Jonu yangga sauyamukut tapata yukuuneta apu apman aminda Anututa amin panangge tasinggak kakngae gepbiatang kopnangge natake gitnagitnauke kokaingga binga tasikaing. ");
INSERT INTO wnc_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Sike ayanikapsa amikat Moseskatda wamu tupa siknga yakapbing kakngata yutake apu Jonda puyana tangenakut gwene apbut. ");
INSERT INTO wnc_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Sike ginda wamu waaknga atnatapnanggengu atnatapnong. Jonda apu puyana tangenawan, ‘Ilaijata gatuna apik,’ ngang tupa siknga ngang yakapbing kakngata yutake apu buyana unin aakut. ");
INSERT INTO wnc_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Aminu maaknga kaya kakengu wamu waaknga natapsok,” ngang yakut. ");
INSERT INTO wnc_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Sike nata ginu tapduk ayuamang komunenana mina bingae tuwanguke yawit? Ginu waatdaka binga yot kekep tapane yuke waatdaka kundue anzing yanikaing, ");
INSERT INTO wnc_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Ninda kekngagom puyapna ngana ginu tainangge apbitakaing. Ninda butaya kap taina ngana ginu kwanam sitnangge apbitakaing,’ ngang yanikaing. ");
INSERT INTO wnc_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Sike Jonda apuke dua nake wain taknga dua tangopan kake ginda, ‘Waunga waiapata tapan pasikut,’ ngang yakaing. ");
INSERT INTO wnc_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Siwan na aminbamdane notnaapa dakngake apuke nanam nake tangoke tasiwa ginda nanduke anzing yakaing, ‘Kanong. Aminu aapa nanamu kumzang nake wain yanggaaya kumzang tangokgak. Siwan ita kait pasiyuk takis papsa amikat gatu wai takngatu takngatu pasiya amikatdane notna dakngake yuak,’ ngang ginda nae unzing yakaing. Ngana Anututane natdetdetnata buya take siknga aawan kana sanga nomana siknga singgak,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Sike yot gapma Jesuta duya takngatui pasikut gapma gapmane nanata musia dua tapa tekwanggutde natake Jesuta kaanga anzing yanikut, ");
INSERT INTO wnc_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Ginu Korasin nana! Tokngabam paning. Ginu Betsainda nana! Tokngabam paning. Aminu taptuta duya takngatu Taiaat Sodom yot gapmaaune nata yotza tasikum binga tasikut gamu tupa siknga Taiaat Sodom nanaatda musia tapa tekwamban meya siknga natake bek saau taukge binga wamake muyup gwene yuwam,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","“Sike nata daniwa natapnong. Tapduknga Anututa aminbam usanziwik gwekatangu meya Taiaat Saidon nanaatda paning binga dua unenana aminda paning,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Sike Kapaneam nana aminda inane umana yatangenawa enane siknga kopik ba dasing? Wena. Anututa you wanggapmane nana amin kaipakapan katap bapatang pukuning. Sike aminu tapatuta duya takngatu Sodom gapmane nata ginde yotzane tasikum binga tasikut gamu apmanu Sodom nana ayuwawam,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","“Ngana nata daninggat. Tapduknga amin usanziwik gwekatangu meya Sodom nanatane meya ginda kaning binga dua,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Siwan tapduk wagwene Jesuta tumuk wamu takngatu anzing inikut, “Nana. Sanga enandang yuak kakngaat keune yuak kakngaatdane toiknga, ga natdetdetda takusopuwi aminu natdetdeninu kaya ngang yakaing aminda dua natapbing ngana wamde gepbiatang yuke pasikaing aminde yeuyami natdetdetda akaaing. ");
INSERT INTO wnc_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ngan, Nana. Gata unzing yeuyamunangge take natapbuyakge ganimbaknganggat,” ngangu tumuk wamu waaknga ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Inikenga aminabam anzing ninikut, “Natane Nanata naniwan nata sanga kuupbamde toiknga dakngake yuat. Siwan naat gaat nana waaknga yuamak ngang nataamak. Natake yuwatda ngana keunenanata nindupa nana waaknga dakngake yuamayak ngang dua ninduaing. Nitdakan unzing nataamak. Natake ngana aminu kunduta Anutu anzing yuak ngang anggaman natapningge take natapit. Take natake yeuyama waakwakgakan atnatapning,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Siwan mama wam nangaakan pasike kwatan siknga natapsa aminu kuupbam natane gepbiatang akopnong. Akopa nata gatandama ginu yuwatakanong. ");
INSERT INTO wnc_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Na musipma kwikwikngata yuke puya meya dua damit. ");
INSERT INTO wnc_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Siwan natane gen gwaamuke yuwawa danindamuba ginu musipzaatang kwanga natayuwatning,” ngang Jesuta ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Siwan yuwatakak tapduk gwendune Jesuat ninu pandetnaatda puyaangane banakan kukumang. Kusika tomin natake poyakgane tapuya zukundakngake ooya pasina pimapa buya nake kukumang. ");
INSERT INTO wnc_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Nayuk kuwatna Ferisi aminu kunduta ninduke Jesu kaanga anzing iniking, “Natapso! Tapduk yuwatakak gwene puya dua tasinimde mama wamda ayandaknganggak ngana pandetdata sandeke pasiwawa dua kayak ba dasing,” ngang iniking. ");
INSERT INTO wnc_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Iniwa yake anzing yanikut, “Baminu Devitda tupa siknga tasikut takngae wamu ginda akendeking gamu unzingu dua yawam. Natawa yanggau iat aminaatda tomna natake ");
INSERT INTO wnc_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Devitda Anututane yot takwan gwene koke poyau Anutue nomune yuaingu pakut. Poyau wa pekingu moo aminda nananga dua ngana Anutue yot takwan gwene pasiya amindakan naning. Ngana Devitda pake atnake kundu inane aminae yaman naking ngang wa matakut takngae ginu apbotake yakaing ba dasing? ");
INSERT INTO wnc_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Gatuna Anutue yot takwan gwene pasiya aminu asinggan tapduk yuwatakak gwene Anutue yotgwene koke puyana apasiyuk yuwatakakgane mama wamu asandekaing ngana maaknga dua nataaing. Puya unzing pasiyuk maaknga dua natapningge wamu tupa matakut taknga ginu dua kendeke natapbing ba dasing? Siakan daninggat. ");
INSERT INTO wnc_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Anutue yot takwan gwende natapna take siknga singgak ngana andang yuau wagwenu ayapbikgak. ");
INSERT INTO wnc_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Anututa wamu yakut taknga buk gopatang anzing matakut. Sanga take sikngaaknga namuningge undang natayuk musipza kwikwiknga natapningge take siknga nataat ngang yawan matakut. Siwan ginu wa matakutde yapii atnatapbing gamu pandetnata maaknga wenaaknga pasiwawa kake wai tasikaing ngang dua yawam. ");
INSERT INTO wnc_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Na aminbamde notnaapa dakngake yuwatakak tapduk gwene tasikaing kakngae kuyana yuat,” ngang Jesuta yaniwan natapbing. ");
INSERT INTO wnc_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Siwan Jesuta puya waanga teke unenanatane miti yotnane kopbut. ");
INSERT INTO wnc_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Kopan aminu tapatu itane katakngi boopmiwanga akgoptawan apmatekakut tapata yukut. Sike Ferisi aminu kunduta Jesuta wam yawikge natake azing inikwaiking, “Ninda mait aminu yuwatakak tapduk gwene maitna sandeyamuke mama wam sandetnim ba dasing,” ngang iniking. ");
INSERT INTO wnc_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Iniwa azing yanikut, “Gikatnana tapatuta sipsipna kaya siwanu sipsipna gwenduta yuwatakak tapduk gwene gapmaatang pimapanu toikngata sipsipna wagwenu dua kaitakakopik ba dasing? ");
INSERT INTO wnc_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","“Siwan ngana aminda sipsip asiknga yapbikut. Unzingge yuwatakak tapduk gwene sanga take tasike wamu dua sandetnim,” ngang yanike ");
INSERT INTO wnc_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","aminu waapa anzing inikut, “Katakga tapi kwangawan,” ngang iniwan tapan kwangawan gatuna take kautduapa binga sikut. ");
INSERT INTO wnc_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Siwan ngana Ferisi aminda enake kepman pukuke paut tasike wamu atanguwa kupikge wam yaking. ");
INSERT INTO wnc_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yawa ngana Jesuta wamu waaknga natake you wanggapma teke kuwawan aminbamda kuku tawaking. Tawawawa mait aminu maitna kuupbam sandeyamuke ");
INSERT INTO wnc_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","kekeknga yandakngake inae anggaman dua yakapningge yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Unzingge wamu takngatu Aisaia ayanikapsaapata yakut taknga buya unin aakgak. Ita anzing yakut, ");
INSERT INTO wnc_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Anututa nanikut taknga ginde daniwa natapnong. ‘Aminu waapa nata gwa tapa natane puya amina dakngake yuak. Nata ie take siknga natake ie musip gwaang natangamunggat. Natane Waungata musipna tangenawan nata aminu noman usanziwit taknga dongu kundune nana Anutue dua nataaing aminde yanikapik. ");
INSERT INTO wnc_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ita dua yanganuke dua yanggamatawan ie wamu kepibam tapane dua natapning ngang yawa kakum. ");
INSERT INTO wnc_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Siwan aminu tapatuta pimanangge dapaknga siwan komam tapatu apaa siknga puwa yuak kapa binga kake gatukande dua putdakngawik. Sike lamdane wik kaknga kundusim isinggak kaknga binga kake gatukande dua tangutapan kupik. Ita unzing atasiyuke tasinggawan wamu noman siknga akngata enake ayapbimbik. ");
INSERT INTO wnc_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ayapbiban aminu dongu kundune nana Anutue dua nataaingga ie apbakngake kayutning ngang Anututa naniwan natapbum,’ ngang Aisaiata yakut,” ngang Jesuta yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Tapduu waomune aminu tapatu waung waiapata tapan kainaat genaatda gwan kusiking. Siwan ie takapa Jesuta tasiwan gatuna wam yake kaina gatu kakut. ");
INSERT INTO wnc_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Siwan aminbamda asatnake anzing yaking, “Aminu aapa baminu Devitde dongune aawik,” ngang yake, “Ie apbakngake kayuamang kapa anin ba dasing,” ngang yaking. ");
INSERT INTO wnc_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ngang yawa natake Ferisi aminu kunduta anzing yaking, “Ita wa yanikwasikgau waung wai Bielsebul waung wai tupan tapatane kekeknga akngane yanikwasikgak,” ngang yaking. ");
INSERT INTO wnc_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yawa natdetdetnaatang natapbing kaknga anggaman kake Jesuta anzing yanikut, “Aminu keu komdune nana buyambamu tapatue gepbiatang yuaingga enake dongu takngaaya yuke amning. Amapanu buyambam tapata kekeknga yutnanga aknganata wai siwik. Sike aminu yot gapmane nana ba you gwendunekan nanata enake dongu takngaaya yuke amapanu you wanggapmane nana ba you wagwene nana ba kekeknga yutnanga dua,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","“Sike Setendane amina dongu takngaaya yuke amake Seten inikwasiwanu kekeknga yutnanga aknganata wai siwik,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","“Siwan, ‘Bielsebulda gatanggaman waung wai yanikwasinggayak,’ ngang ginda nae yawa natake danikwaikgat. Maminda gikatnana gatayaman waung wai yanikwasikaing? Unzingge gikat nanata tasikaing kakngata gisae wam usanziwan gutonga siwik,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","“Sike Anututane Waung Kapata gatangaman waung wai yanikwasiwa kuwa ginda natdeke tapduknga Anututa amin panangge tasinggak kakngata ninde gwa apbut ngang natapnong! ");
INSERT INTO wnc_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Sike aminu tapatuta Setendane yotnaatang moo siknga koke aminbamu ita pakut takwau sandepewan kunanga dua. Wena. Ita Seten tanguke napda gamok wamakenga ita take sandepewan kuning,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Aminu dua gatangamuke tasiwiu natane iwana. Aminu naat unekan gatake dua yuke pasisim tapata tasiwan apasinggat takngata apmaiwik. ");
INSERT INTO wnc_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Unzingge nata ginu daniwa natapnong. Anututa waiakngana ba sapdut wamu yaningu asandeyamik. Ngana Waung Takwande sapdut wamu yaningu wai waakngana Anututa dua sandeyamik. ");
INSERT INTO wnc_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Siwan aminda na aminbamdane notnaapae wamu wai yawiu Anututa wai waakngana asandekngamik. Ngana aminda Anututane Waung Kapae sapdut wam yawiu Anututa wai waakngana dua sandekngamik. Tapduu ayuamang komune dua sandekngamik. Gatu masan kaya dua sandekngaman asinggan asinggan yuwik,” ngang yakut. ");
INSERT INTO wnc_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Sike katau dakatu buyana take aawan kake katau takedaka ngang kaamang. Sike buyana wai aawan kake katau take dua ngang yakamang. ");
INSERT INTO wnc_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ginu gomou waita genata yasiwa kumningga binga tasike genzata wamu wai yawa natake aminu take dua ngang danduamang. Siwan aminde genata wamu inata inata musiaatang doke yuwau yakaing. ");
INSERT INTO wnc_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Sike aminu noman tapae musiaatangu natdetdet nomana natayuau yawan sanga takekan anggaman siwa kaamang. Sike aminu waiapae musiaatangu natdetdet wai natayuau yawan sanga wai anggaman siwan kaamang,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Ngana nata ginu daniwa natapnong. Sapdut wamu kuupbamu yumdekan yakaingu Anututa tapduknga aminbam usanziwik gwenea wamu waaknga usanziwik,” ngang yakut. ");
INSERT INTO wnc_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","“Sike gikae wamde Anututa, ‘Ga amin noman,’ ngang ganiwik ba, ‘Ga aminu wai,’ ngang ganiwik,” ngang yakut. ");
INSERT INTO wnc_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Yawan natake mama wam yanindamumsa amikat Ferisi aminu kunduatda anzing iniking, “Yanindamumsaapa. Ninu gata duya takngatu tasiwi kake Anutuat gatake tasikamayak ngang gandupnim,” ngang iniking. ");
INSERT INTO wnc_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Iniwa ngana yake anzing yanikut, “Ginu tapduknga ayuamang komune nana aminda banipzaatang Anutue asinggan meya natake duya takngatu kanangge nanikaing ngana nata duya takngatu dua yeutdamit. Sike duya Jona ayanikapsa apata tupa siknga tasikut takngakan binga kaning,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","“Pis buyambam dakata Jona kake ngok tamuban musiaatangu gunziu gweaat gwenduat ngang yuwawana gatuna ngwatutekut. Ina unzakan na aminbamdane notnaapa dakngake yuat tapata kep ganang katangu gunziu gweaat gwenduat yuwit,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","“Sike Jonata kuke Nineva yot gapmanenana amin yaniwan natake musia tapa tekwanggut. Unzingge Anututa tapduk aminbam usanziwik gwekatangu Ninevanana aminda enake ginu apman ayuamang komunenana amindane waiakngasa yakapning. Ngana aminu ayuak kapata Jona ayapbike yuak,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","“Tapduknga Anututa aminbam usanziwik gwene maya tapatu amunzing nana aminde takeapa yuke wam yake ginu tapduk apman ayuamang komunenana amindane waiakngasa yakapik. Dasingge? Maya buyambamu waapata keu maa sikngata apuke nataawan Solomonda natdetdetna nomana siknga yawan natapnangge apbut. Ngana aminu ayuak kapata Solomonu ayapbike yuak,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Sike waung waiapata aminu tapatu takut tapa inikwasiwa aminu waapa teke kuke keu kupia kopatang kuke keu take komdu kake yuwatakanangge apmeptake waung wai waapata anzing yakut, ");
INSERT INTO wnc_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","‘Nata tupa yukum tapane gatuna kuwit,’ ngang yake gatuna kuke kaawan aminu waapa you gwendu dapandapa gwa kwaamuke tanomanuking binga kakut. ");
INSERT INTO wnc_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Kake kuku gatu waung wai kunduat katau kautdu musaat gatu kautdu tapaaya ngang papan waung wai waakwakga gawaknga aknga buyambam siknga tasikaingunin pakut. Papan iat apuke aminu waapa tapa tupa aminu waapa waisim yukut ngana apmanu wai siknga yuak. Sike sanga waakngatakan ginu wai aminu tapduk ayuamang komune nanae asapik,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesuta wamu waaknga ayayuwawan itane mingaat uyapnaatda apu kepman yuke ininangge yaking. ");
INSERT INTO wnc_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Yawa natake aminu tapatuta Jesu anzing inikut, “Natapso. Minggaat uyapbaatda kepman katang yuke gae yakaing,” ngang iniwan ");
INSERT INTO wnc_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jesuta yake anzing inikut, “Natane mingaat uyapmaat akaat taknga ngang ganiwa natapso,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Inike pandetna katakngata yeuyuk ninikut, “Minga gatu uyapma ngang yaninggat aminu anin,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","“Siwan aminda natane Nana enane yuak kapatane banip tawaningu natane minga ba uyapma ba samina ngang yaniwit,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Siwan tapduu wagwene Jesuta yotgwen teke epu kepman kuke paku yangga gapan gwene kwaimune pukwikut. ");
INSERT INTO wnc_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Pukwiwawan aminu buyambam sikngata apu yupbasike tasiwawa kake dopangbamu gwendune koke yanindamutnangge pukwikut. Pukwiwawan aminbamda yanggabam gwenu kwaimtapane yuwawa ");
INSERT INTO wnc_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","tuwang wamu takngatu takngatu yanike wamu buyambam anzing yanikut, “Natapnong! Aminu tapatuta nanam zak pake paku puyaangatang muban pimaking. ");
INSERT INTO wnc_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Muban zakngi kundu kepiapane pimapa apu kwaitda atnaking. ");
INSERT INTO wnc_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Sike zakngi kundu keu suu amaakatang yuwa kaiu engatangan mateknga siknga yuaing kopatang pimapa zuna zetgaman akopbing. ");
INSERT INTO wnc_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Akopa ngana gunzitda akoke yasiwan zuna wa muyakngi wena siwan kungwake akupiaking. ");
INSERT INTO wnc_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Siwan zakngi kundu muban babam yapiatang pimakingu babamda akoke zakngi wa asusikwatapbut. ");
INSERT INTO wnc_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Siwan ngana zakngi keu take komune pimakingu buyana buyambam mateknga ngang aaking. ");
INSERT INTO wnc_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Aminu maaknga kaya kakengu wamu waaknga natapsok,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Siwan ninu pandetnata Jesue kuke anzing inikumang, ");
INSERT INTO wnc_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","“Dasingge gata tuwang wamu yaninggayak,” ngang inina yake anzing ninikut, “Anututa amin panangge tasinggak kakngae yapii akusopuke yuau anggaman daniwitde Anututa nandutewan nata ginu daninggat. Siwan ngana aminu aakwau wena,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","“Sike aminu tapatuta natdetdet nomana papanu Anututa ie natdetdet kunduat asimusaanguwan buyambam siknga papik. Sike aminu tapatuta natdetdet nomana panangge bitakengu natdetdetna gwa pakuu akaiwan kuwik. ");
INSERT INTO wnc_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","‘Kainata akake ngana yapii dua kaaing. Siwan maakngata wamu atnatake ngana katak siknga dua natagwaangukaing.’ ");
INSERT INTO wnc_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Unzingge aminu waakwakga unzing tasiwa wamu takngatu Aisaia ayanikapsa apata yakuu buya unin aakut. Ita anzing yakut, ‘Ginda wamu atnatake ngana waakngatane yapii katak dua natapning. Sike ginda akatasike ngana sanga kundu dua kaning. ");
INSERT INTO wnc_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Aminu waakwakga maaknga kapanga ge itane wamu katak dua nataaing. Siwan kai gwa dopukusiking. Kainata sanga kake maakngata wam natake musiaatangu wamdane yapii katak natake tapa tekwamban nae apa nata pasiyama take siningge bitake unzing pasikaing,’ ngang Aisaiata yakut taknga buya unin aakut.” ");
INSERT INTO wnc_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Ngana ginu apbaknganong. Kaisata sanga gwa kake maakzata wamu atnataaing. ");
INSERT INTO wnc_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nata ginu siakande siknga daninggat. Tupa siknga ayanikapsa amikat aminu nomana amikatda take siknga sanga akanangge natapbing ngana dua kakingu ginda apmanu akaaing. Ginda wamu nataaing kaknga atnatapnangge take siknga natapbing ngana dua natapbing,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Ginda tuwang wamu aminu tapatuta nanam zau puyaangane mukutde yapii daniwa natapnong. ");
INSERT INTO wnc_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Aminbamda wamu Anututa amin panangge tasinggak kakngae wamu atnatake ngana ie katak dua nataaing. Setenda wa aminde apuke zetgaman wamu takeaknga Anututa musiaatang teyamunggak kaknga sandeyamunggak. Sike zakngi wa kepiapane pimakinggane yapii unin. ");
INSERT INTO wnc_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Sike zakngi kundu suptangan pimakingu wa anzing. Aminu tapatuta Anututane wam yaniwan wam natake zetgaman take natake zetgaman apbakngake takaing. ");
INSERT INTO wnc_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ngana muyakngi dua pukunggak. Wena. Ita tapduu mateknga siknga yuke masande aminu kunduta Anutue wam tanguwa pimapikge natake meya aminu waakwakge yamuke waiaknga tasiyama zetgaman pimakaing. ");
INSERT INTO wnc_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Siwan zakngi kundu babam yapiiatang pimakingu wa anzing. Aminda wamu take siknga natapbing ngana kepdakane nana meyaat gatu sangaapana buyambam siknga panangge nataaing kakngaatda Anutue wamu yaitapakusiwan buyana atnanga dua,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","“Sike tapuya keu take komune pimakingu wa anzing. Aminda wamu natake katak natagwaangukaing. Siwan wa aminda buyana buyambam mateknga ngang aakaing,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Siwan Jesuta tuwang wamu takngatuat yake anzing yakut, “Anututa amin panangge tasinggak kaknga anzing. Aminu tapatuta poyak tapunu take siknga pake puyanaatang muban kuking. ");
INSERT INTO wnc_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ngana dapuna peking gwekatangu iwanata apuke zongazonga waitane tapuya poyak tapunde banakan katang muban kuking. ");
INSERT INTO wnc_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Siwan masande poyau wa akoke buya aawan kawa ngana zongazonga waiat kuut undanggan yuwan kaking. ");
INSERT INTO wnc_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Kake puya aminda puya toikge kuke anzing iniking, ‘Buyambamtapa. Ninu gata poyak tapunu takekan ba puyakaatang mukuyak ngang natapbumang. Dasingge zongazonga wai buyak akokaing,’ ngang iniwa ");
INSERT INTO wnc_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","yake, ‘Iwana tapatuta tasikut,’ ngang yaniwan yake anzing iniking, ‘Kuke atzitnimde natayak ba,’ ngang iniwa, ");
INSERT INTO wnc_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","‘Aho. Ginda zongazonga wai zike poyakat kuut zitnang,’ ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","‘Ginda kapewa kuutda akowawat tapduknga buya detnanga komunea puya waaknga pasiya aminu anzing yaniwit, Ginda zongazonga wai gamok zike unekan wamandakngapenong. Katapatang saningge. Sike poyau natane nanam yot gwene paku penong,’ ngang yaniwit,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","32","Siwan Jesuta tuwang wamu takngatuat aminbamu anzing yanikut, “Anututa amin panangge tasinggak kaknga anzing. Nanam tapunu gwendu mateknga siknga yuak. Umana mastet ngang inikamang. Tapuya kundu mateknga siwan ngana wagwenzimu mateknga siknga. Siwan aminu tapatuta nanam tapunu wagwenzimu take puyanane yapuban zuna akoke buyambam sike kainga tapmake buyambam siwik. Siwan nanam tapunu kundutane zunandakata buyambam kokaing ngana wandakata buyambam siknga kopik. Kopana kwaitda apu kaingane yotna pasike yutning,” ngang Jesuta yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Siwan Jesuta tuwang wamu takngatuat anzing yanikut, “Anututa amin panangge tasinggak kaknga anzing. Poyakga paptawan sawikge sanga umana yis ngang inikamang. Siwan maya tapatuta poyak sanangge natake yis mateknga pake palaua banakan katang pamuban tawamban sandewan palaua kuupbamda paptawik ngang,” Jesuta yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Siwan aminbam yaninangge natake Jesuta asinggan asinggan tuwang wam takngatu takngatu yanikut. Sipdune tuwang wam teke anggaman dua yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Siwan tupa siknga Anutue wam yanikapsa tapatuta yakut takngata buyana aawikge natake Jesuta unzing yanikut, “Siwan yakapsa apata Anutue wam takngatu maakngita natake anzing tematekut, ‘Tapduknga kep dua tasike tekum gwekatang wamu takngatu banipmaatang takusopukumu yaniwit ngana tuwang wamban yaniwit ngang yawan kakum,’ ngang yakapsa aminda tematekut,” ngang Jesuta yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Siwan Jesuta wamu waaknga yawan puyuwan aminbam peke yoan koke yuwawan ninu pandetnata ie kuke anzing inikumang, “Tuwang wamu zongazonga waita puyaangatang akopbingge yapii ninu niniyo,” ngang inina ");
INSERT INTO wnc_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","yake anzing ninikut, “Aminda nanam zau take siknga puyaangatang mukuu wa na. Aminbamdane notnaapa. ");
INSERT INTO wnc_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Siwan puya wa keu kuupbam. Sike nanam zau take siknga wa aminu Anututa papan itane aminabam dakngake yuaingunin. Sike zongazonga wai wa Setendane donga. ");
INSERT INTO wnc_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Sike iwana zongazonga tapunu wai mukuu wa Seten. Sike tapduknga buya detnanga komu wa tapduknga ayuamang komda asandewik. ");
INSERT INTO wnc_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Sike zongazonga wai zike katapatang sakingu wa unzing, tapduknga sandewik gwekatang ina unzakan tasining. ");
INSERT INTO wnc_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Na aminbamdane notnaapa dakngake angelana yanipewa kuke aminu Anututa papan aminabam dakngake yuaikat nana pasiwan maikaingu apake gatu aminbamda waiaknga pasikaingu kuut paning. Pake Anutue kekeknga aknga gepbiatang dua yutningge ayanikwasiwa katap bapatang kuning. ");
INSERT INTO wnc_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Katau wagwene kuke kwanamna kumzang sike kaakake yutning. ");
INSERT INTO wnc_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Tapduu waomune aminu nomanata Nanatane kekeknga aknga gepbiatang yuke gunzitda binga waenga zike yutning. Aminu maaknga kaya kakengu wamu waaknga natapsok,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Anututa amin panangge tasinggak kaknga anzing. Aminu tapatuta keu komduatang kwaike sangaapa inata kundu take siknga kep ganang katang kakut. Kake baniaatang take siknga natake gatu usikwatake kukut. Kuke inane sangaapana aminde yaman manita usiwa puyuwan mani pake keu sanga wa usikwatapbut komu kuke manita usikut,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Siwan gatuna daniwit. Anututa amin panangge tasinggak kaknga anzing. Usiwam yot toiknga tapatuta sangaapana usinangge natake bimbinu take siknga yanggabam nana kanangge kukut. ");
INSERT INTO wnc_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Kuke tawake tawake bimbinu inata kundu manina buyambam sikngata usinanga gwendu kawan take siknga sikut. Siwan kuku sangaapana kuupbam aminde yaman usiwa puyuwan manina kwaapzang pake kuku bimbinu wagwenu usikut,” ngang Jesuta ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Gatuna enandang nanata amin panangge tasinggak kaknga anzing. Aminda pis panangge natake yapapna yanggagapan katang muba kuwan pis inata inata kaikaing binga. ");
INSERT INTO wnc_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Yapap gwenu gitnawana kwaimune kaitakakoke apukwike pis take dakandaka dopangu gwendune butupeke pis wai apmutning. ");
INSERT INTO wnc_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Sike tapduknga ayuamang komda asandewik gwene ina unzakan siwik. Angelata apuke waiaknga pasiya amikat amin nomakatda unekan gatake yuwawa kake usanzike wai aminu pake yanikwasiwa ");
INSERT INTO wnc_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","katap bapatang pukuning. Pukuke undang yuke kwanamu kumzang sike kaakake yutning,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Siwan Jesuta anzing ninikwaikut, “Ginda wamu wa kuupbamdane yapii atnataaing ba dasing,” ngang niniwan, “Ngan,” ngang yana ");
INSERT INTO wnc_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","yake anzing ninikut, “Unzingge mama wam yanindamumsa amikatnana tapututa natane pandetna dakngake Anututa amin panangge tasinggak kakngae gepbiatang yuwik kapata yot gwende toiknga binga yuwik. Yot toikga sangaapana peak gwene koke sangaapa kayuk sikngaat tupananaat pake pakepu yamik. Ina unzakan aminu waapata wamu tupan natapbut takngaat masan natapbut takngaat musiaatangga enawan yaniwik,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Siwan Jesuta tuwang wamu waaknga yawan puyuwana you wanggapma teke ");
INSERT INTO wnc_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","yotna siknga kukut. Undang kuke Anutue wamu miti yotnaatang koke yaniwan asatnake anzing yaking, “Natdetdetna buyambam pake yake duya takngatu pasinggak ngangu ita wa zane pakut? ");
INSERT INTO wnc_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Aminu waapa aminu katapsan usike sangabam pasinggak kapatane waaknga dua ba dasing? Sike Maria minga dua ba dasing? Sike Jems gatu Josep gatu Saimon gatu Judas ngangu itane uyapna dua ba dasing,” ngang yaking. ");
INSERT INTO wnc_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","“Siwan itane samina kuupbam nikat dua yuamang ba dasing? Sike sanga wa kuupbamu zane pakut?” ");
INSERT INTO wnc_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Unzing yake semna natangama ngana yake anzing yanikut, “Ayanikapsa aminde aminu umana kaya ngang yotna yotna nana aminda natayamukaing ngana wa aminda yotna siknga yuwa inaat nana aminda umana wena akwak ngang natayamukaing. Siwan gatu inapaanu yotna gwendunekan nana aminda kuut umana wena akwak ngang natayamukaing.” ");
INSERT INTO wnc_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Siwan you wanggapmane nana aminda ie banip meya natapa kake duya kwaapzang you wanggapmane dua tasikut. ");
INSERT INTO wnc_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Siwan tapduu waomune Herotda Gavmanu tupan tapa dakngake yuwawan Jesuta puya tasiwan natapbut. ");
INSERT INTO wnc_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Natake puya amina anzing yanikut, “Aminu wa Jonu yangga sauyamukut tapata gatuna matmat katangga enake puya kekeknga wa pasiwan kaamang,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","5","Sike tupa Herotda maya tapatu umana Herodias. Uyapna Filipdane maatna ngana kaiwan kuwan maatnae takut. Tapan natake Jonda Herot anzing inikut, “Gata maya aapa tapi take dua singgak,” ngang gatu gatu iniwan Herotda Jonu tanggaganuke napda wamake kaautde tekut. Teke atangutnangge natapan ngana aminbamda Jonde ayanikapsaapa ngang natapbingge akgwauke dua tanguwan kumbut. ");
INSERT INTO wnc_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Sike tapduu gwendune tapduknga mingata tangaikut gwende natake nanam sake nake iat aminu kunduatda unekan gatake yuwawa Herodiasdane yapanata apu wakumu wa aminda yukingu banakan inatakan taiwawan kake Herotda take siknga natapbut. ");
INSERT INTO wnc_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Natake siakan ngang yawan kekekawan maya waapa anzing inikut. Gata nae sangaapatu gamitde naniwinu nata akgamit ngang iniwan kekekawan natake ");
INSERT INTO wnc_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","maya waapatane mingata natdetdet iman pake anzing yakut, “Gata Jonu yangga sauyamukut tapatane gwapakngi dopangu gwendune teke ane nae namuyo,” ngang yawan ");
INSERT INTO wnc_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","buyambam tapatane musia meya sikut. Ngana aminu iat gatake yuke nakinggane kaine wamu siakan ngang yawan gwa kekekakutde natake ayanggak kaknga tasinong ngang yake ");
INSERT INTO wnc_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","amina yanipewan kaaut yot gwene kuke Jondane guyakngi mataking. ");
INSERT INTO wnc_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Matake gwapaknga dopangu gwendune teke takapu maya mateu waapae ima take mingae taku imukut. ");
INSERT INTO wnc_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Siwan Jondane pandetnata apu gupnasanu taku kwaikenga kuku Jesu iniking. ");
INSERT INTO wnc_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Siwan Jesuta you wanggapma teke dopangbamu gwendu take kautdu saak amina wena kopatang inatakan kukut. Kuwawan aminbamda undang kukut ngang natake yot gapma gapma peke kuku kwaimtapa tawatake kuking. ");
INSERT INTO wnc_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Tawatake kuwawa kwaimune kuke kaawan aminbamu asapa kakut. Kake butaya natake mait aminu maitna sandeyamukut. ");
INSERT INTO wnc_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Sike bangee ninu itane pandetnata ie kuku anzing inikumang, “Keu akomu aminu wena siwan gunzit kaya gwa pukunggak. Unzingge gata aminbamu yanipewi you gapmanduine kuku nanamna undang usiut,” ngang inina ");
INSERT INTO wnc_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","ngana yake anzing ninikut, “Dasingge kuningge yakaing? Gisa nanamu yamunong,” ngang niniwan ");
INSERT INTO wnc_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","yake inikumang, “Ninu andangu nanamu buyambamda dua yuaing. Poyau katau kautdu musaat pis dakaaya nganggakan yuaing,” ngang inina ");
INSERT INTO wnc_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","natake, “Nae ane pakapnong,” ngang ninike ");
INSERT INTO wnc_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","aminbamu wa yukingu yaniwan zongazongane pukwiking. Pukwiwawa poyau wa katau kautdu musa gatu pis wandakaat ngang pake enandang pakusang kake inimbakngakenga nanamu wa puke pandetnae niman pake yamuna naking. ");
INSERT INTO wnc_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Yamuna kuupbamda napa musia gitnawa kaiknga yukingu ninu pandetnata butuke sapat yau katau kuut musaat kepianganu gweayane pamuna dopbing. ");
INSERT INTO wnc_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Sike wawi nanam nakingu 5,000. Sike maya waatdaka ngangu dua kendeking. ");
INSERT INTO wnc_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Sike Jesuta pandetna nininggamatawan dopangbam gwene koke ninda gamok yangga gapan gwenu kautdu saak kunimde niniwan kuwatna ina aminbamu wa yanipewan kuking. ");
INSERT INTO wnc_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Yanipewan kuwana inatakan baku baku dakane tumuk wam yanangge kopbut. Koke bangee inatakan undang yuwawan ");
INSERT INTO wnc_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ninda dopangbam gwenu take yangga gapan gwene banakan gwa kukumang. Kuwatna gou buyambam siknga nomin katangga apuyawawan yangga sambuya asenawawan ");
INSERT INTO wnc_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","akwakanangge dapaknga siwan ngana zikaa ayuwawan Jesuta yangga gapan gwene engatangan yaitake apu ninde apan ");
INSERT INTO wnc_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","kake asatnake a kongu tapatu ngang yake akgwauke kumzang ainggamatakumang. ");
INSERT INTO wnc_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ainggamatana ngana zetgaman anzing ninikut, “Musipza gitnata yutnong. Nata nina siknga apunggat. Ginu ma gwaubam,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Siwan Pitata yake anzing inikut, “Aana. Siakande ga gandukengu gata na naniwi nata yanggaangan gae yaitake kuwa,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Iniwan Jesuta, “Asapin,” ngang iniwan dopangbam gwen teke yanggaangan yaitake Jesue kukut. ");
INSERT INTO wnc_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Kusika ngana gotda puyapan kake akgwauke yanggaatang pukunangge sike yanggamatake, “Aana. Gata gatangamuyo,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Iniwan zetgaman katakngita tanggaganuke anzing inikut, “Ganiwa natapi takesim sik ngana dasingge dua natapi kekekak,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Siwan dopangbam gwene kopat gotda atzakngawan ");
INSERT INTO wnc_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","kake ninu dopangbam gwene yukumangu ie inimbakngake, “Siakande siknga ga Anututane waaknga,” ngang inikumang. ");
INSERT INTO wnc_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Sike yangga gapan gwenu kwaimune gwa kukenga kuku Genesaret kep komune kundopbumang. ");
INSERT INTO wnc_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Kundopnana aminu ugwak saak nana aminda ie Jesu ngangu atnatake wamu you wesim yuaingge yatewa kuwan mait aminu kuupbam ie pakapbing. ");
INSERT INTO wnc_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Pakapuke ininggamatake ita kapewan mait aminda katakngita Jesutane tauknga nomna saasaakngi wangane wasiningge iniking. Iniwa kapewan katakngitakan taukngane wasiking aminu kuupbamda gatuna take siking. ");
INSERT INTO wnc_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Siwan tapduu waomune Ferisi aminu kunduat gatu mama wam yanindamumsa amikatda Jerusalem yot gapma teke Jesue apu anzing iniking, ");
INSERT INTO wnc_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Dasingge tapduknga nanam nanangge ngana pandetdata kataknga dua saukaing? Wamu bapuninda nimuking kaknga unin zipmandakngakaing,” ngang iniking. ");
INSERT INTO wnc_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Iniwa yake anzing yanikut, “Dasingge ginu sanga gisane taknga tawake Anututane mama wamu zipbukaing? ");
INSERT INTO wnc_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Anututa anzing yakut, ‘Gata nangga minggae gepbiatang yuyo. Sike aminda nana mingae sapdut wam yaniwanu atanguwa kupsok,’ ngang Anututa yakut. ");
INSERT INTO wnc_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ngana ginda anzing yakaing, ‘Aminu tapatuta nana minga gatayamunangge mani kundu kaya ngana mani wa Anutue imunangge gwa yakum ngang yawanu ");
INSERT INTO wnc_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","nana minga pasiwan take sisande undanga ngang yakaing. Sanga waaknga pasike Anutue mama wam zipbuke gisane sanga akngakan tangenakaing.’ ");
INSERT INTO wnc_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ginu kem amin! Ayanikapsaapa Aisaiata ginu noman siknga tuwanguke anzing yakut. ");
INSERT INTO wnc_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Aminu wa natane umana genatakan yatangenakaing. Sike musiaatangu nae maa siknga yuaing. ");
INSERT INTO wnc_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Wa aminu aminde mama wam yake Anututane wam ngang yakaing. Unzingge wa aminu nae moo siknga kem nanimbakngakaing,’ ngang Aisaiata yakut,” ngang Jesuta yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Siwan Jesuta yayawamban aminbamda apa anzing yanikut, “Ginu natake katak siknga natdetnong. ");
INSERT INTO wnc_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Sanga napa genaatang konggakga dua pasiwan aminu wai amin dakngakaing. Aho. Sanga genaatang yusika kepman epukaingga pasiwan aminu wai amin dakngakaing,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Yaniwan natake ninu pandetnata kuku anzing inikumang, “Wamu waaknga yawi natake Ferisi aminda gae musia toknga nataaing. Ga gwa natayak ba dasing,” ngang inina ");
INSERT INTO wnc_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","yake tuwang wamu takngatu anzing ninikut, “Natane Nana enandang yuke puyanaatang sangabamu ina dua kwaiwan ina akokaingu ita muyakngi buyak atziwik. ");
INSERT INTO wnc_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ginu kapewa yutnong. Aminu kai kusiya amin tapata kai kusiyae kepi yeukngamunangge tasiwanu kuut tapaatda gapmaatang pimatzan,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Niniwan natake Pitata yake anzing inikut, “Gata wamu yake aminu wai amin dakngakaing ngang niniyak kakngae yapii yawi ninda natapna,” ngang iniwan yake anzing yakut, ");
INSERT INTO wnc_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","“Nata asinggan ganiwa ngana natdetdetdaatang gitna dua pake yuayak ba dasing? ");
INSERT INTO wnc_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Sangabamu genaatang koke napayutnaatang pukuwan musiata kotdekatang muban pukukaing ngang dua nataaing ba dasing? ");
INSERT INTO wnc_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Sike sanga musiaatangga akoke genaatangga epukaingga pasiwan aminu wai amin dakngakaing. ");
INSERT INTO wnc_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Sanga musiaatang natdetdet gutonga takngatu takngatu natake amin zipmakaing ba yasewa pasikaing ba kukae pakaing ba wam yaningge kuku kem wam yakaing ba sapdut wam yakaing. ");
INSERT INTO wnc_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ngangu unzing tasikengu aminu wai amin dakngakaing. Sike aminu katakngi dua sauke nanam pake nakengu aminu wai amin dua dakngakaing,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Siwan Jesuta uneta enake keu komdune kukut. Keu wakomune you gapmaya yuamayau umana Taiaat Saidonkat ngang yanikaing. ");
INSERT INTO wnc_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Siwan Jesuta keu wakomune kundopan keu komdu umana Kenan ngang yakaing. Wakomune nana maya tapatuta apu anzing inikut, “Buyambamtapa. Bamin Devitdane dongane aakuyak kapa ga. Nae butaya natapso. Waung waita natane yapana tapan yapanata mainggak,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Iniwan ngana yake dua inikut. Dua iniwan kake Jesutane pandetnata apu kekeknga anzing inikumang, “Maya waapata asinggan niwayuk nininggakawan natapna meya singgak. Siwan initewi kuwan,” ngang inikumang. ");
INSERT INTO wnc_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Inina yake pandetna anzing ninikut, “Sipsip kunduta ina banipda siwa kuwawa toikngata yayawamban mainggak. Siwan Isrel nana aminda sipsip wa bingata yuaing. Unzing yuwawa Anututa nanitewan Isrel nana amindekan apbum,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Niniwan ngana maya waapasimda ie kuku butaya wam natake muna puke inimbakngake anzing inikut, “Kuyana. Gatangamuyo,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Iniwan ngana Jesuta, “Isrel nana asinggan gatayamunggat taknga aminu wambingae iwanae dua tasiwit ngang natake tuwang wamu takngatu anzing yakut, ‘Waatdakatane nanamu kamunde dua yamunangge,’ ngang yakut.” ");
INSERT INTO wnc_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Yawan maya waapasimda baniaatang anzing natapbut. Isrel nana aminda nandupa kamun binga singgat. Siwan ngana Jesuta Isrel nana aminde gatayamunggak kaknga unzambinga gatanggamikge take nataat ngang natake tuwang wamu takngatu anzing inikut, “Kuyana. Siakan yanggayak ngana waatdakata nawawa kaikngata pimawawa kamunda nakaing binga tasingami natapa siakan siwik,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Iniwan yake anzing inikut, “O maya apa. Ga nae natapi kekekak kakngata kekeknga siknga singgakge wa nataak kakngakan tasinggamunggat,” ngang inikut. Ngang iniwan maya waapasimdane yapanata tapduknga wa inikut komsimunekan zetgaman take sikut. ");
INSERT INTO wnc_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Siwan Jesuta you wanggapma teke yangga gapanu Galili kwaimune kusika baku dakane koke pukwiwawan ");
INSERT INTO wnc_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","aminbamda ie apbing. Apuke kepi wai siya amikat kai kusiya amikat kwatai gutokaya amikat gena kusiya amikat gatu mait aminu inata kunduat ngang pake ie apbing. Pakapu Jesuta yukut komune pewa kake sandeyamuke tasiyaman take siwa ");
INSERT INTO wnc_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","aminbamda kaking. Kawawa gena kusiya aminu wam yawawa kwatai gutonga siya aminu take siwawa kepi wai siya aminu akuwawa kai akusiya aminu gatuna kawawa ngang kake nangaakan natak. Anutu ninu Isrel nana amindane kuyaninde umana yatangenaking. ");
INSERT INTO wnc_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Siwan Jesuta pandetna yaniwamban apna anzing ninikut, “Aminbamu tapduu gweaat gwenduat naat gwa yutna sandewan ngana nanamna wena. Ie butaya natake tomda yusika kuningge apbitanggat. Kusika kainata dandambong siwa kepiapane pimanang,” ngang niniwan ");
INSERT INTO wnc_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","anzing inikumang, “Andangu aminu wena. Ninda nanamu zane pake aminbamu anzing takwakge yamunangge,” ngang inina ");
INSERT INTO wnc_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","ita yake anzing ninikut, “Ginu poyau datdasing paing,” ngang niniwan ninu, “Katau kautdu musa kautdu gomaat gatu pis dakaat nganggan pamang,” ngang inikumang. ");
INSERT INTO wnc_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Inina ita yaniwan aminu wa kepdakane pukwiking. ");
INSERT INTO wnc_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Pukwiwawa poyau wa katau kautdu musa gatu kautdu gomaya pis wa kuut pake Anutu inimbakngake puke niman pake usanzike aminu wa yukingge yamukumang. ");
INSERT INTO wnc_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Yamuna napa musia gitnawa kaiknga napa yukingu unekan peke sapat yau katau kautdu musa gatu kautdu musane gweaya ngang pamuna dopbing. ");
INSERT INTO wnc_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Siwan wawi nanam nakingu 4, 000. Sike maya waatdaka ngangu dua kendekumang. ");
INSERT INTO wnc_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Siwan Jesuta wa aminu yanipewan kuwana dopangbam gwene koke kautdu saak yot Manggandan gapmata yuak saak kukut. ");
INSERT INTO wnc_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Siwan Ferisi amikat Sadyusi amikatda apu Jesu tasiwa siwikge natake duya takngatu Anututa Jesu kawan take singgakge tuwangu tasiwan kanangge yaking. ");
INSERT INTO wnc_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yawa ngana yake anzing yanikut, “Bangee mingandakata gamana siwan kake ginda anzing yakaing, ‘Gamana siwan apmanu tapduu take sinanggenggak,’ ngang yakaing. ");
INSERT INTO wnc_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Sike gatu tembana gunzitda akopnangge siwan mingata gamana sike gatuna zikaa siwan kake ginda anzing yakaing, ‘Enandangu gamana siwan apmanu gotda apuyapan gatu sopa atawik,’ ngang yakaing. Ngan. Ginda tuwangu enandang nana kake ginda katak usanzikaing. Ngana ginda tapduu apman yuamang komdane tuwangu katak dua kake usanzikaing. ");
INSERT INTO wnc_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ginu wai siknga. Ginu Anutue gen dua gwaamukaingga duya kanangge yakaing. Ngana nata duya takngatu dua tasiwa kaning. Ginda duya ayanikapbut tapa Jona ngang iniking kapata tupa siknga tasikut bingakan kaning,” ngang yanike wa aminu apeke kukut. ");
INSERT INTO wnc_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Siwan Jesutane pandetnata yangga gapan gwenu gwa yatupmake kuke ngana poyakat pakapnangge apbotakumang. ");
INSERT INTO wnc_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Siwan Jesuta tuwang wamu takngatu anzing ninikut, “Ginu katak siknga gwautnong. Ginu sanga Ferisi amikat Sadyusi amikatda pake pasiwa poyakga paptakaing kakngae gwautnong,” ngang niniwan, ");
INSERT INTO wnc_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","“Ninu poyau dua pakapbumangge yanggak,” ngang nisa yakumang. ");
INSERT INTO wnc_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yana natake ita anzing ninikut, “Ginda nae banip dua natapa kekeknga siwan kaat. Dasingge ninu poyau wena ngang yakaing? ");
INSERT INTO wnc_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Asinggan daniwa ngana ginu natdetdetzaatang gitna dua pake yuaing ba dasing? Ginu poyau katau kautdu musakanu 5,000 aminda nakingge ginu gwa botakingge yakaing ba dasing? Sapat yau datdasing pamukingge apbotake yakaing? ");
INSERT INTO wnc_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Siwan ginu poyau katau kuut musa kautdu gomaya ngangu aminu 4,000-da nakingge ginu gwa botakingge yakaing? Sapat yau datdasing pamukingge apbotake yakaing? ");
INSERT INTO wnc_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Nata danike poyakge dua natake daniwa ngana dasingge poyakgekan nataaing? Ginda Ferisi amikat Sadyusi amikatda kaitaknga pasikaingge gwautnong,” ngang niniwan, ");
INSERT INTO wnc_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","“Ita sanga poyakat sawa paptakaingge dua ninik ngang natapbumang. Aho. Ferisi amikat Sadyusi amikatde wamde gwautnimde ninik,” ngang natapbumang. ");
INSERT INTO wnc_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Siwan Jesuta Filip gavmanu buyambam tapata tupa Sisaria yot gapma yukuune wesim kukut. Kuke pandetna anzing ninikwaikut, “Aminda na aminbamdane notnaapae dasing yakaing,” ngang ninikwaiwan ");
INSERT INTO wnc_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","anzing inikumang, “Aminu kunduta gae, ‘Jonu yangga sauyamukut tapa,’ ngang yakaing. Siwan kunduta, ‘Ilaija tupa siknga ngang yakapbut tapa,’ ngang yakaing. Siwan kunduta, ‘Yanikapsa aminu tupa siknga yukut tapatu Jeremaia ba ayanikapsa tapatu,’ ngang yakaing,” ngang inina ");
INSERT INTO wnc_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","anzing ninikut, “Sike gisa nae dasing yakaing,” ngang niniwan ");
INSERT INTO wnc_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Saimon Pitata yake anzing inikut, “Anututa ga tapan gata Krais gatanimik kapa dakngake Anutu kayuk asinggan yuak kapatane waaknga ga,” ngang iniwan ");
INSERT INTO wnc_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","yake anzing inikut, “Saimon, Jonatane waaknga. Aminu keunenana tapatuta dua wamu waaknga gae yeukgamuk. Aho. Nana enane siknga yuak kapata yeukgaman kake yanggayakge apbakngayo,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","“Siwan nata ganinggat. Ga umanda Pita. Unzing yapii gata kekeknga sup gwenda binga yuayak. Sike suu wagwene engatangan tasiwa natane amin takwakga kekeknga yuwawa katap bamdane kekeknga akngata dua yaitapaakusiwik,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","“Nata kekeknga aknga gwabokziu enandang kopnanga daka binga gae gamit. Gama pake sanga Anututa enandang yuke gwa ayandakngakut takngakan kepdakane yandakngayo. Sike sanga Anututa enandang kapewan tasikaing kakngakan kepdakane kapewi tasining,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Inikenga wamu kekeknga pandetna ninike aminu tapatu Anututa tapan Kraistapa dakngake yuak ngangu dua ininimde ninindakngakut. ");
INSERT INTO wnc_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Siwan tapduu wagwenuneta Jesuta pandetna tuwanguke Jerusalem gapmane asiknga kopikge anggaman ninikut. Undang kopan ninu Judia amindane take amikat gatu Anututane yot takwan gwene pasiya amindane take akwakat gatu mama wam yanindamumsa amikatda ie meya takngatu takngatu imuning. Imuke yawa tanguwa kungwake gatu tapduu gweaat gwenduat gwene gatu enawikge wamu anggaman ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Niniwan natake Pitata take kwaim saak taku tuwanguke kaanga anzing inikut, “Aana. Anututa musia kwikwiknga natanggamuke gatanggaman meya wa gae dua apan,” ngang iniwan ");
INSERT INTO wnc_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","ita tapan tekwamban yake anzing inikut, “Gata iwana dakngawi ganduke ganinggat. Na napbimbi ayanggat taknga tasingamuning,” ngang inikut. “Gata Anututane banip dua natdeyak. Wena. Gata aminde natdetdet natake kepina umukngamunggayak,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Inikenga pandetna anzing ninikut, “Aminu tapatuta na nawanangge natakengu inane banip tawanangge nataak kaknga undang teke iwanata amin saamdakane na nuwa kupit binga kumnangge dua gwauke meyana gwaamuke na nawamsok. ");
INSERT INTO wnc_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Sike aminu tapatuta nae natake tasiwawan aminu kunduta semna natangamuke tanguwa kupanu ita gatuna kayuk yuwik kakngana atake asinggan yuwik. ");
INSERT INTO wnc_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Sike aminu tapatuta sangaapana buyambam siknga papik. Pake ngana masande akupanu sanga wa pakut takwakga dasing gatangamik? Wena. Sike sanga dasitna bingata kayuk yutnanga akngana wena sikuu gatuna tanangge muke usiwik? Wena. ");
INSERT INTO wnc_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Na aminbamdane notnaapa dakngake yuat tapata Nanatane kakaa akngane yuke angelanaat naat kuut apnim gwene nata sanga yake aminbamde sanga atasiking kaknga yamit. ");
INSERT INTO wnc_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nata siakande siknga daninggat. Aminu ayuaingu kundu dua kumning gwekatangu na aminbamdane notnaapa buyambamtapa dakngake apa nandupning,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Siwan gunziu katak kuut musa gatu kautdu gwendukan kawa sandewana Jesuta Pitaat Jemskat uyapna Jonkat nganggan pake ita tawanu mamaya siknga dakatune yanipakoke aminu wena inatakan yuking. ");
INSERT INTO wnc_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Yusika kaawa Jesuta aminu inata kundu dakngawan kainata kaking. Kawawa nomnata gunzit binga waenga siwan taukngata kwaknga sike waenga siwan kananga dua siking. ");
INSERT INTO wnc_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Kaawa bamin akumbing katangga Moseskat Ilaijaatda anggaman siwat Jesuat iat unekan gatake yuke wam yaking. Yawawa Pitaat Jemskat Jonkatda kaking. ");
INSERT INTO wnc_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Kake Pitata Jesu anzing inikut, “Buyambam tapana. Ninu ane take siknga yumang. Siwan gata take natapinu nata gepa gweaat gwenduat ane pasiwit. Gwendu gae. Gwendu Mosesde. Gwendu Ilaijae ngang pasiwit,” ");
INSERT INTO wnc_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","ngang yayuwawan undang yuking aminu minga kwaknga dakatuta apu wamakusikut. Wamakusike yuwawan minga wandakaatangga wamu takngatu Anututa anzing yawan natapbing, “Waapa natane waaknga. Waapae na musipmaatang apbaknganggat. Na i kawa take siknga singgak. Siwan ginda itane gen gwaamutnong,” ngang yawan natapbing. ");
INSERT INTO wnc_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Siwan wamu waaknga natake pandetnata gwauya siknga natake kepatang pimaking. ");
INSERT INTO wnc_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Pimake yuwawa Jesuta apu katakngita wasike anzing yanikut, “Enatnong. Gwauya nataaing kaknga atenong,” ngang yanikut, ");
INSERT INTO wnc_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Yaniwan aminu waapaau akginikawat Jesutakan yuwan kaking. ");
INSERT INTO wnc_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Siwan apmea tawanu wandakaatangga epusika Jesuta pandetna waakwau anzing yanindakngakut, “Sanga apmaatzimu wa kaing kakngae aminu tapatu ma iniwam. Na aminbamde notnaapata apmea kungwake enawanaa sanga wa kaing kakngae yaninong,” ngang yanindakngakut. ");
INSERT INTO wnc_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Unzing yaniwan yake anzing inikwaiking, “Dasingge mama wam yanindamumsa aminda yake, ‘Ilaijata gamok apana aminu Anututa tapan Krais gatanimuyaapa dakngake apik,’ ngangu yaking,” ngang inikwaiwa ");
INSERT INTO wnc_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","yake anzing yanikut, “Ngan siakan. Ilaijata apuke sanga kuupbam tanomanuwik ngang noman yakaing. ");
INSERT INTO wnc_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ngana nata daniwa natapnong. Ilaijata gwa apan kake ngana ie dua natake inae banip tawake ie sanga inata inata gwa tasingamuke tanguwa kumbut. Ina unzakan na aminbamdane notnaapa nae tasingamuning,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jesuta unzing yaniwan ita Jonu yangga sauyamukut tapae yanggak ngang natdeking. ");
INSERT INTO wnc_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Siwan kusika aminbamda yukingune gatunin kundopna aminu tapatuta kuku ie muna puke ");
INSERT INTO wnc_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","anzing inikut, “Buyambamtapa. Gata natane waakngae butaya natangamuyo. Datdaptake kumnangge singgak kakngata tasiwan gupna wai siknga singgak. Sike tapduk tapduk katapatang gatu yanggaatang ngang pimanggak. ");
INSERT INTO wnc_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Siwan nata take pandetdae takuwa ngana tasiwa take dua sikut,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Iniwan yake anzing inikut, “Ginu Anutue natapa siakan dua siwan yamandet sikaing amin! Na gikat gatake yuke asinggan asinggan dandupewa ginda meyaaknga nama gwaamuba take dua siwik. Ginda waapa nae ane takapnong,” ngang yawan takapa ");
INSERT INTO wnc_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","waung waiapa kaanga iniwan waatdaka waapa teke kuwan zetgaman maitna wena sikut. ");
INSERT INTO wnc_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Siwan masande Jesuta inatakan yuwan pandetnata kuku anzing inikumang, “Dasingge ninda waung wai waapa inikwasitnangge tasina maikut,” ngang inina ");
INSERT INTO wnc_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","ita anzing ninikut, “Ginda Anututa gataniman inikwasitna kuwik ngang natapa kekeknga dua siwanu ginda take inikwasitnanga dua. Ngan. Nata siakande siknga daninggat. Anututa gataniman tasingamuna take siwik ngang ginda natapa kekekanggak kakngata sanga mateknga siknga katau mastetde tapun binga gamu tawanu andakata kautdu saak kuwikge yawanu ita undang akuwik. Ginda unzing natapa kekekngasim siwanu sangabam pasinanggengu apasiwa siakan siwik. ");
INSERT INTO wnc_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","(Siwan waung wai a binga yanikwasitnanga kepi takngatukan. Tumuk wam yake Anutuekan natayuke nanam teke dua nayuk yanikwasiwa kuwik. Kepi takngatuat wena,” ngang ninikut.) ");
INSERT INTO wnc_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Siwan keu Galili kopatang unekan gatake kusika Jesuta pandetna anzing ninikut, “Aminda na aminbamdane notnaapa aminde yaman ");
INSERT INTO wnc_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","take nuwan kungwake tapduu gweaat gwenduat gwene gatu enawit,” ngang niniwan musiminu meya siknga natapbumang. ");
INSERT INTO wnc_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Siwan masande you Kapaneam gapmane kundopna miti yotdane takis papsa aminda Pitae apu anzing iniking, “Gin danindamukgak kapata miti yotdane takis apmukgak ba dasing,” ngang inikwaiwa, ");
INSERT INTO wnc_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","“Ngan,” ngang yanike yoakatang kopan kake Jesuta wam gamok yake anzing inikwaikut, “Saimon, ga dasing nataayak? Aminu buyambam takwau kepdakanenana aminda takis mamindane pakaing? Inaatnana amindane ba pakaing ba dongu kundutane ba dasing,” ngang inikwaiwan, ");
INSERT INTO wnc_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","“Dongu kundutane,” ngang yakut. Yawan yake anzing inikut, “Unzingge inaatnana aminda takis mutnanga dua. ");
INSERT INTO wnc_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Niu Anutuat nana amin ngana ninda tasina musia toknga natanimunang. Ga yangga gapan gwene kuke pis kaitnangge huk mumbi kuwan pis tupan kaiwiyak gaka gena tapi akngawan mani sandu undang kawiyau take taku niu kuutde wasan yamuyo,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Siwan tapduu waomune pandetnata kuku Jesu anzing inikumang, “Maminda aminu kundu yapbike Anututa amin panangge tasinggak kakngae gepbiatang yuaing amindane buyambam tapa dakngake yuak,” ngang inina ");
INSERT INTO wnc_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","natake waatdaka tapatusim yatawamban apan banakan tekut. ");
INSERT INTO wnc_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Teke anzing yakut, “Nata siakande siknga daninggat. Ginda musipza tapa tekwamban buyambam tapa yutnanga akngae masa imuke waatdaka aapa binga dua dakngakengu ginda Anututa amin panangge tasinggak kakngae gepbiatang yutnanga akngane dua siknga kopning. ");
INSERT INTO wnc_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Sike aminu tapatuta inae umana wenaapa waatdaka aapasim binga dakngakengu aminu waapata aminu kundu Anututa amin panangge tasinggak kakngae gepbiatang yutningge yapbimbik. ");
INSERT INTO wnc_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Sike aminu tapatuta nae natanggamatake waatdaka umana wena tapatusimu aapasim binga gatangamiu waapata na kuut gatangamunggak kapa unin,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Siwan ngana aminu tapatuta tasiwan aminu umana wena tapatu nae natapan kekekanggau aakwakat nana tapatuta pimapanu aminu wa atasiwan pimapik kapata tokngabam papik. Siwan suu buyambamu gwendu guyakngane wamake yanggabam gwene muba pukuke kupik gamu wai waaknga dua tasike toknga buyambamu dua papan,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Aminda pasiwa aminu waiakngaatang pimakaingge tokngabamu apaning. Siakan. Wai waaknga asapik. Ngana aminu wai waaknga tangenake tasiningga tokngabamu apaning,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Sike gatane katakgata ba kepikata ba tasiwan ga waiakngaatang pimakengu gata patdakngake mumbi kuwan take siwik. Patdakngake wai waakngaatang dua pimake kayuk kaknga pake yuwiyak gamu wai siknga dua siwim. Siwan dua patdakngake katakga tapa ba kepika tapaayata tasiwat ga pimapi katau dua kungwanggak gwekatang muba kuwi wai siknga siwik. ");
INSERT INTO wnc_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Sike kaikata tasiwan ga waiakngaatang pimakengu akwagike mumso. Akwagike wai waakngaatang dua pimake ga kayuk kaknga pake asinggan yuwiyak gamu wai siknga dua siwim. Sike kaika gweaya siwan tasiwan gata pimapi katapbapatang muba kuwi wai siknga siwik,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Siwan ginu katak siknga gwautnong. Dasingge? Ginda waatdaka mateu a yumdekan ngang natapnang. Wena. Daniwa natapnong. Enandangu angela wa amin kayuaingu asinggan Nana enandang yuak kapaat unekan gatake yuaing. ");
INSERT INTO wnc_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","(Dasingge? Na aminbamdane notnaapa dakngake aminu waiakngaatang pimamsa amin gatayamunangge apbum.”) ");
INSERT INTO wnc_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Ginu dasing nataaing? Aminu tapatutane sipsipna 100-da yuaing, ngang sipsipna gwendu wena siwanu toikngata dua tawambik ba dasing? Wena. Ita 99-nu tawandakane peke kuku sipsipna wena wa sikut gwende tawambik. ");
INSERT INTO wnc_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nata siakande siknga daninggat. Tawake kakengu sipsipna wagwende take siknga natapik. Sike sipsipna 99-nu wena dua sikingge take siknga dua natapik. ");
INSERT INTO wnc_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ina unzakan, Nanza enandang yuak kapata waatdaka akwakzipat nana tapatuta pimake kayuk yutnanga aknga dua pake wena siwan kake take dua natapik,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Sike notdata gae wai tasinggamanu gata kuwi gisatakan yuke waiaknganae iniyo. Iniwi gae wam natapanu iwan dua dakngake yutzan. ");
INSERT INTO wnc_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Sike ita gae wamu dua natapanu gata aminu tapatu ba tapaaya papi ginu kuutda yuke wamu waaknga natapnong. Natawawa gitda yawat aminu tapaaya ba tapaat tapatuatda wamu waaknga natake tanomunuwa kekekawik. ");
INSERT INTO wnc_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Siwan ngana aminu waakwakge wamu dua natapanu gata miti yot gwendune gikaat kokaing aminde yaniyo. Sike ita aminu waakwakge wamu asandewanu gata aminu waapa dongu inatanana ba kait pasiyuk takis papsa amin binga daknganggak ngang kayo. ");
INSERT INTO wnc_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Nata siakande siknga daninggat. Anututa enandangu gwa yandakngakut takngakan ginda kepdakane yandaknganong. Sike sangabamu Anututa enandangu gwa kapewan pasikaing kakngakan ginda kepdakane kapewa pasinong. ");
INSERT INTO wnc_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Siwan nata gatu siakande siknga daninggat. Aminu gikatnana tapaayata musia takngatukan sanga tapatue natake waapaatda tumuk wamu sanga unin tanangge yasanu Nana enandang yuak kapata aminu waapaatde ayamik. ");
INSERT INTO wnc_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ngan. Sike aminu tapaaya ba tapaat tapatuatda natane umanae natake unekan gatake yutningu nata wa aminde banakan yuwit,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Unzing niniwana Pitata kuku Jesu anzing inikwaikut, “Aana. Notnata gatu gatu wai tasingamanu datdasing sandekngamit? Gatu gatu katak kuut musa kautdu sipmaat sandekngamit ba datdasing,” ngang inikwaikut. ");
INSERT INTO wnc_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Inikwaiwan Jesuta yake anzing inikut, “Gatu gatu katak kuut musa kautdu sipmaat sandekngamuyo ngang dua ganiwit. Anzing ganiwit. Aminu 25-dane katakngi kepi binga tapdukbam asinggan gatu gatu kosangayuk sandekngamuyo. ");
INSERT INTO wnc_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Siwan Anututa amin panangge tasinggak kaknga anzing. Take aminu tapatuta aminata sanga moo pakinggane tuwanga tapatakakut. ");
INSERT INTO wnc_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Tapatakanangge yawan tapatuta mani buyambam siknga (K10,000,000) yake imikge takapbing. ");
INSERT INTO wnc_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Takapa ngana waapata mani wena. Yake imunangge apmeptakut. Apmeptawan takeapanata anzing yakut, ‘Mamin tapataka aminu aapaat maatnaat waaknga yapanaat sangaapanaat manita usinangge natakengu mani naman papa siakan siwik,’ ngang yakut. ");
INSERT INTO wnc_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Ngang yawan natake aminu waapata muna puke inimbakngake anzing inindatapbut, ‘Toknga ma natangamim. Apmea yake gama sandewik,’ ngang inindatapbut. ");
INSERT INTO wnc_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Inindatapan butaya natangamuke sandekngamukut. ");
INSERT INTO wnc_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Sandekngamuke initewan kuke waapasimda notna tapatu puya takngatukan tasike yukumayak kapa kakut. Kake waapata mani mateknga ngang yake imikge inikut. Inike guyakngaatang panggamuyuk mani yake, ‘Nam! Nam,’ ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Guyakngaatang panggamuyuk iniwawan kepdakane pimake, ‘Toknga ma natangamim. Apmea gamit,’ ");
INSERT INTO wnc_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","ngang inikut. Iniwan ngana toknga natake kaaut yotde tewan yusika mani yake imukenga yotna kuwik ngang yawan kekekakut. ");
INSERT INTO wnc_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Yawan kekekawan kake notna kunduta baniaatang meya siknga natapbing. Natake kuku puya toiknga puya aminda waapa unzing tasiwan kakumang ngang iniking. ");
INSERT INTO wnc_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Iniwa natake puya toikga puya aminu waapa yatawamban apan anzing inikut, ‘Ga puya aminu wai sikngaapa. Gata nanindatapi buyambam siknga sandekgamukum. ");
INSERT INTO wnc_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nata gae butaya natanggamukum taknga tawakuyak gamu notdae butaya natangamim,’ ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Inikenga musia toknga natake aminu toknga imuningge tewan kuke yuke sangae yake kuupbam imana waitdetewan kuwik. ");
INSERT INTO wnc_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Sike meya dua natake ginu kuupbamda notzatane waiakngana siakande siknga inandek inandek dua sandeyamanu natane Nana enandang yuak kapata ina unzakan ginde yake tasindamik,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Siwan Jesuta wamu wa yawan puyawana Galili kep teke Judia keu Jodan yanggaapata wesiwan kautdu saak yuaing aminde kukut. ");
INSERT INTO wnc_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Undang kuwan aminbamu unenanata tawawawa maitna sandeyamukut. ");
INSERT INTO wnc_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Siwan Ferisi aminu kunduta ie apuke tasiwa siwikge apuke kunduta anzing inikwaiking, “Aminu tapatuta maatna inikwasiwan kuwanu Mosesde mama wamu asandewik ba dasing,” ngang inikwaiwa ");
INSERT INTO wnc_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","5","ita yake anzing yanikut, “Anutu tupa siknga amin tumukut tapata aminu wawiat mayaat ngang tumukut. Tumuke ita anzing yakut, ‘Unzingge wawita nana minga peke kuwan maatnaat gatake unekan yuke sanga tapatukan binga dakngake yutzan,’ ngang yakut taknga dua kendeking ba dasing? ");
INSERT INTO wnc_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Unzingge waapaatda tapaaya binga dua yutzan. Wena. Waapaatda sanga tapatukan binga dakngake yutzan. Unzingge sanga Anututa unekan gwa tapan gatapbuu aminda zipmandakngake sandetnanga dua,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Yaniwan yake anzing iniking, “Mosesda mama wamu takngatu ninde nimukut. Aminda maatna inikwasitnangge natakengu pepa maya zipmandakngake sandekaingu sandu ie imuke inikawasiwan kuwik ngangu dasingge nimukut,” ngang inikwaiking. ");
INSERT INTO wnc_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Inikwaiwa yake anzing yanikut, “Mosesda yamandet ngang bapusae natake ita kapewan maya yanikwasikaing. Ngana Anututa amin tumukut gwene sanga waaknga wena. ");
INSERT INTO wnc_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nata anzing daniwa natapnong. Aminu tapatutane maatnata yasewa dua tasiwan ngana apnata inikwasike maya kayuk tapanu wawi waapata yasewaapa daknganggak ngang natapnangge,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Siwan ninu pandetnata anzing inikumang, “Wawita maatna inikwasiwikge kepi unzing siwanu wawita maya dua tapan take siwik,” ngang inina ");
INSERT INTO wnc_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","ita yake anzing ninikut, “Aminu kuupbamda dua wamu ginda wa yaing kaknga taning. Wena. Anututa aminu kundue ayamik amindakan wamu waaknga taning. ");
INSERT INTO wnc_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Aminu inata inata aminu maya dua paning. Wawi kundu mingata bokngikinguneta maya panangge dua nataaing. Siwan wawi kundutane gupna matawan maya panangge dua natapning. Siwan aminu kundu Anututa amin panangge tasinggak kakngae puya pasinangge natake maya paningge ayandakngakaing. Aminda wamu aaknga natapnanggengu take natapsok,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Siwan aminu kunduta waatdaka pake ie pakapbing. Jesuta katakngita wasike wam kwikwik yaniwikge pakapa ngana pandetnata kaanga yanina ");
INSERT INTO wnc_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","natake Jesuta anzing ninikut, “Ginu kapewa waatdaka nae apnong. Ginda ma yanindakngawam. Aho. Aminda waatdaka aakwakga nae nangaakan dua nataaing binga daknganingu Anututa amin panangge tasinggak kakngae gepbiatang yuaikat nana aminu unin,” ngang ninike ");
INSERT INTO wnc_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","wasiyuk wam kwikwik yaniwan puyuwana peke kukut. ");
INSERT INTO wnc_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Siwan aminu tapatuta Jesue apuke anzing inikut, “Yanindamumsaapa. Nata sanga take zaaknga tasike kayuk yutnanga aknga pake kayuk asinggan asinggan yuwit,” ngang inikwaiwan ");
INSERT INTO wnc_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","yake anzing inikut, “Dasingge gata sanga take siknga akngae naninggayak? Tapatutakan take siknga. Sike gata kayuk yutnanga aknga tananggengu gata Mosesdane mama wamu kuupbam tawamso,” ngang iniwan, ");
INSERT INTO wnc_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","“Mama wamu zaaknga tawambit,” ngang inikwaikut. Inikwaiwan yake anzing inikut, “Mama wamu anzing mataking, ‘Gata aminu ma zipim. Yasewa ma tasiwim. Kukae ma papim. Amin notdae kemu ma yaniwim. ");
INSERT INTO wnc_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Nangga minggae wam gwaamuke ie gepbiatang yuyo. Siwan aminu gae wesim yuak kapae butaya natangamuyo. Unzing gikae gupba wai dua siwikge natake butaya nataayak binga,’ ngang mataking,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Iniwan ita yake anzing inikut, “Mama wamu wa kuupbam asinggan tawanggat. Ngana na dasing bingae dapmanggat,” ngang iniwan ");
INSERT INTO wnc_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","yake anzing inikut, “Gata kayuk yutnangge take natakengu ga kuke sangaka yami usiwa manina pake sangana wena aminde yamuyo. Unzing tasiwinu take siknga kayuk yutnanga akngaka enandang yukgamuwawan ga apu na nawamso,” ngang iniwan ");
INSERT INTO wnc_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","natake musia meya siknga siwan kukut. Dasingge? Itane sangaapana buyambam. ");
INSERT INTO wnc_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Unzingge ita kuwawan kake Jesuta pandetna anzing ninikut, “Nata siakande siknga daninggat. Aminu sangana buyambamda sanga Anututa amin panangge tasinggak kakngae gepbiatang kopnanggengu kwatan siknga tasike kopik. ");
INSERT INTO wnc_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Gatuna daniwa natapnong. Ikwawa gamanda tauk bupmakge ganangiatang kopnanggengu ita kwatanu aminu sangana buyambamu kayata Anutue kekeknga aknga gepbiatang kopnangge tasining binga dua,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Niniwan natake kumzang satnake anzing yakumang, “Unzingge maminda kayuu asinggan yuwik,” ngang yana Jesuta noman siknga nindunggamatake anzing ninikut, ");
INSERT INTO wnc_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","“Aminda unzingu tasinanga dua. Ngana Anututa sangabamu atasinanga,” ngang niniwan, ");
INSERT INTO wnc_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pitata yake anzing inikut, “Natapso. Ninda sangabamin peke ga gawakamang. Unzingge ninda mina binga panim,” ngang iniwan ");
INSERT INTO wnc_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","natake anzing ninikut, “Nata siakande siknga daninggat. Masande na aminbamdane notnaapata buyambamtapa enane siknga yuke wama yawa kekekawik. Siwan tapduu wagwene sangabamu kayuk dakngake yuwawa ginu na nawakaingu gikaya buyambam tapatane kekeknga aknga pake aminu Isrel nana dongu 12 usanzitning,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","“Siwan aminbamu natane umanae yanikapnangge natake yotna ba uyapna ba samina ba nana ba minga ba waaknga ba puyana peningu sanga buyambam siknga ie tangge yake pake kayuk yutnanga aknga pake kayuk asinggan asinggan yutning. ");
INSERT INTO wnc_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ngana aminu kundu tupan amin yuaingu masan amin daknganing. Siwan aminu kundu masan amin yuaingu tupan amin daknganing,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Anututa amin panangge tasinggak kaknga anzing. Puya toikga tembana siknga enake aminu kundu panangge kukut. Wain tapunde puyaangane pasiningge pake anzing yanikut, ");
INSERT INTO wnc_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","‘Gunziu anggwene puya pasiwa puyuwana mani sandu sandu damit,’ ngang yaniwan, ‘Ayom undang nimuyo,’ ngang iniking. Iniwa puya toikga yanipewan kuku wain tapunde puyaangane pasingamuking. ");
INSERT INTO wnc_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Puya pasingamuwawa puya toikga yuke kawawan gunzitda akoke gwa wekawan kakut. Kake gatuna aminu kunduat panangge natake kuke yawatakusika aminu kundu sanga usikaing komune moo yuwawa kakut. ");
INSERT INTO wnc_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Kake anzing yanikut, ‘Ginu kuku wain tapunde puya anganane kuke pasinong. Puya pasiwa mani noman damit,’ ngang yaniwan kuke puyanane pasingamuking. ");
INSERT INTO wnc_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Puya pasingamuwawa puya toikga yusika kepmaom siwan kuku bangee gunziu apukunangge dandam enaawan unzakan tasikut. ");
INSERT INTO wnc_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","“Siwan kuku bangee siknga siwawan ita gatuna sanga usikaing komune kuke kawawan aminu kundu moo yuwawa kakut. Kake kaanga anzing yanikut, ‘Ginu dasingge gunziu anggwekatang anekan moo siknga yuaing,’ ");
INSERT INTO wnc_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","ngang yaniwan yake anzing iniking, ‘Tapatuta puya takngatu dua niman ie moo yuamang,’ ngang iniwa, ‘Ginu wain tapunde puya anganane kunong,’ ngang yanipewan kuke puyana pasingamuking. ");
INSERT INTO wnc_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Puya pasingamuwawa kep gwazowan puya toikga puyae kuyana yuak kapa anzing inikut, ‘Puya amina yayawambi apa mani yamuyo. Bangee apuing aminu tupan yayawambi apa mani tupan yami puyuwana tupan apuingge mani masan yamuyo,’ ngang iniwan tasikut. ");
INSERT INTO wnc_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Tasike yayawamban bangee apbingga mani panangge apa kuyana yuak kapata mani sandu sandu yaman paking. ");
INSERT INTO wnc_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Yaman pake kuwawa tembana siknga apbingga mani panangge gatuna apbing. Apuke kawa bangee apbing aminde sandu sandu yamuwawan kaking. Kake ninu sandu sandu unzambinga dua panim. Ninu kwaapzang panim ngang musiaatang natapbing. Natapa ngana kuyana yuak kapata mani sandu sandu yaman paking. ");
INSERT INTO wnc_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Yaman pake musia toknga natake puya toikapa kaanga anzing iniking, ");
INSERT INTO wnc_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","13","‘Masan apuingga tapduknga dapakngakan puya pasiing. Siwan ninu tembana siknga puya buyambam pasiwatna gunzitda toknga siknga nisiwawan pasimang. Siwan ngana masan apuikat nikat nindupi puyaninu unzakan binga siwan nimunggayak,’ ngang kaanga iniking. Iniwa puya toikga yake anzing yanikut, ‘Waatdakana. Na wai dua ginde tasindamunggat. Ginu puya pasiwa nata mani sandu sandu damit ngang tembana gwa danit. Daniwa ginu ayom undang nimuyo ngang dua ba yaing? ");
INSERT INTO wnc_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Gwa yamangge manisa pake kunong. Apmea apuikat gikat mani buya kundukan damunangge nataat. ");
INSERT INTO wnc_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ginu dasing nataaing? Nata sanga natane pake ninae banipda tasiwa ga wai tasinggayak ngang naniwanu gutonga siwik. Puya mateknga pasiwa gunziu kuk gwendane yama kake ginu dasingge meyambam nataaing,’ ngang puya toikga unzing yanikwaikut. ");
INSERT INTO wnc_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Siwan tuwang wamu waakngae yapii anzing. Aminu tapatuta umana engatangan yuak ngang natapik ngana gatuna pimapik. Siwan aminu tapatuta umana amunandang yuak ngang natapik ngana gatuna kopik.” Jesuta wamu waaknga ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Siwan Jesuta Jerusalem gapmane kopnangge natake ninu pandetna katau kuut musaat kepianganu tapaaya nganggan papan kukumang. Kepiapane kusika Jesuta anzing ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Natapnong. Apmanu Jerusalem kopna na aminbamdane notnaapa Anutue yot takwan gwene pasikaing amikat mama wam yanindamumsa amikatde yamuning. Yama wam yawitde yake wamu na nutnangge yawan kekekawan ");
INSERT INTO wnc_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","dongu kundune nana Anutue dua nataaing aminde yamuning. Yama sapdut wam nanike ipmapa nuke amin saamdakane nuwa kupit. Nuwa kungwakenga tapduu gweaat gwenduat gwene gatuna enawit ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Siwan Sebeditane waaknga tapaatkat gatu waapaatdane mingaatda Jesue inimbaknganangge apbing. Apuke mingata kepdakane gwetake gatangamikge iniwan ");
INSERT INTO wnc_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","yake anzing inikut, “Gata minae nataayak,” ngang iniwan Jesue anzing inikut, “Gata yake masande buyambamtapa dakngawiyak gwene natane waaknga aapau gaat gatake inengan yuke umana kaya dakngake yutzan. Tapatu katakga siyaapane yuwan tapatu katakga kwanaapane yuyok,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Iniwan ita yake anzing yanikut, “Ginda sanga wa yake nanikaingge katak dua nataaing. Gitda meya nata wa kawit takngata gitde apan kake ngana gitda undang dua ba pimatzan ba dasing,” ngang yaniwan, “Ngan, nitda dua pimatzim,” ngang iniwat ");
INSERT INTO wnc_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","yake anzing yanikut, “Gitda meya nata kawit taknga akasan. Ngana Anututa dua naniwan kapewa kataknga siyaapane ba kwanaapane ngangu yuke tasan. Aho. Kekeknga waaknga aminu tapaayae Nanata gwa tandakngake teyamukut tapaatdakan tasan,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Yaniwan natake ninu pandetna katau kuut musaatda nikatnana waapaatde kaanga yanisapdukumang. ");
INSERT INTO wnc_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yanisapduwatna ngana Jesuta yaniwamban kuna anzing ninikut, “Ginu atnataaing. Aminu buyambam tapaapa dongu kundune nana Anutue dua nataaing aminda yaipapaakusike enane yuke amina wa aminde wam tawaningge kumzang kekekakaing. ");
INSERT INTO wnc_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ngana ginda unzingu ma tasiwam. Wena. Gikatnana tapatuta buyambam tapasa dakngananggengu ita gin gatandamuyaapa dakngayok,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","“Siwan gikatnana tapatuta ginde tupan tapasa dakngananggengu ita puya aminza dakngayok. ");
INSERT INTO wnc_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Na aminbamdane notnaapaaya unzakan. Nata apa aminda nae puya pasingamuningge dua apbum. Wena. Apuke puya tasike amin gatayamunangge apbum. Apuke kungwayamit takngata iwana zipmake yawamba kuwa aminbam sandeke papitde apbum,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Siwan Jeriko yot gapma teke kuwatna aminu buyambamda Jesu tawaking. ");
INSERT INTO wnc_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Tawake kuwawa aminu kai wai sikumayau tapaaya kepiapane pukwike yuwawat Jesuta apu kuwan natake wamu apaa yanggamatake anzing yakumayak, “Buyambamtapa. Ga Devitdane dongune aakuyak kapa. Gata nitde butaya natapso,” ngang inikumayak. ");
INSERT INTO wnc_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Iniwat aminbamda kuma yutzande wamu kekeknga yaniwa ngana apaya yanggamatake anzing yakumayak, “Buyambamtapa. Ga Devitdane dongune aakuyak kapa. Gata nitde butaya natapso,” ngang yawat ");
INSERT INTO wnc_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","natake Jesuta yuke apaa anzing yanikut, “Giu nata gitde dasing tasindamitde natamayak,” ngang yaniwan, ");
INSERT INTO wnc_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","“Buyambamtapa. Niu kainiu take tasinimiyakge nataamak,” ngang inikumayak. ");
INSERT INTO wnc_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Iniwat waapaatde butaya natake kainane wasiwan zetgaman kaina gatu kawat Jesuat gatake kukumang. ");
INSERT INTO wnc_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Siwan Jerusalem gapma wesim kundoke yot Betfasi gapma tawanu Oliv daka yuaune kuke Jesuta pandetna tapaaya ");
INSERT INTO wnc_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","anzing yanikut, “Gitda you atugapmasimu kaamayaune kopzon. Koke zetgaman gitda ikwawa gamana gwendu napda tewatanguwan mateknga kuut wamapeninga kake gitda waike nae pakapzon. ");
INSERT INTO wnc_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Sike aminu tapatuta wamu takngatu daniwanu anzing inison, ‘Buyambam tapata anggweyatde puya kaya,’ ngang iniwat zetgaman danipewan pakapzon,” ngang yanipewan kukumayak. ");
INSERT INTO wnc_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Sanga wa tasikumayak kakngae wamu ayanikapsa aminu tapatuta anzing yakut, ");
INSERT INTO wnc_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Ginda aminu you Saion gapmanenana anzing yaninong, ‘Kanong! Buyambam tapasata ginde apunggak. Ita inane umana dua tangenakgak kapa dakngake ikwawa gaman gwene engatangan pukwike apunggak. Ita engatangan ikwawa gaman sangaapa papsa gwene pukwike apunggak,’” ngang yanikapsa aminda yakut taknga buya unin aakut. ");
INSERT INTO wnc_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Siwan pandetna waapaau Jesuta yanikut taknga tasikumayak. ");
INSERT INTO wnc_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ikwawa gamanu matekngaat mingaat pakapat tauknga kundu ikwawa gamande masene pewat Jesuta engatangan koke pukwikut. ");
INSERT INTO wnc_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Pukwike apuwawan aminbamda Buyambam tapana initakuningge natake got tauknga kepiapane usiwa kunduta zagwa tatak matake kepiapane usiking. ");
INSERT INTO wnc_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Siwan aminbamu kundu tupan kuwawa kundu masan apuyuk anzing yanggammataking, “Devitdane dongune aakut tapata apan kana take siknga singgak. Umana tangenatnong! Anutu enane yuak kapata kawan take siknga singgak,” ngang yaking. ");
INSERT INTO wnc_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yake tasiwawa Jesuta Jerusalem gapmane kopan aminu you wanggapmanenana kuupbamda asatnake anzing yaking, “Aminu aapa mamin,” ngang yawa ");
INSERT INTO wnc_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","aminbamu kepi kukingga anzing yaking, “Ita Jesu, ayanikapsaapa Nasaret gapma Galili kep komu yuaune nanaapa,” ngang yaking. ");
INSERT INTO wnc_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Siwan Jesuta Anututane yot takwan gwende daman katang koke kawawan aminbamu mani kaitnangge tasiwawa kaka yanikwasiwan kuwawa tebona mani sanis tasikingu pangenapamapan kuwa sia apukwike kwait gwegwen yaman manita usikingu kuut pangenapamapan kuwa ");
INSERT INTO wnc_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ita anzing yanikut, “Anututane wapatang anzing matakut, ‘Natane yot gwenu tumuk wam yaningge yot ngang yaning,’ ngang matakut. Ngana ginda tasiwa kuka aminde yot gwen binga daknganggak,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Siwan Jesuta you wagwende daman gwekatang yuwawan aminu kundu kai kusiya gatu kepi wai siya ngangga ie apa take pasiyamukut. ");
INSERT INTO wnc_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Pasiyamuwawan ngana Anutue yot takwan gwene pasiya amindane take akwakat mama wam yanindamumsa amikatda duya takngatu takngatu pasikuunin kaking. Kawawa waatdakata you wagwende daman gwekatang yuke anzing yanggamataking, “Devitdane dongune aakut tapata apan take siknga singgak,” ngang yawa natake musia toknga natake anzing iniking, ");
INSERT INTO wnc_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","“Ga wamu wa yakaing kaknga atnatayak ba dasing,” ngang iniwa Jesuta anzing yanikut, “Ngan, na gwan natat. Sike Anututane wapatang anzing matakut, ‘Gata yanindamumbi waatdakaat engakatda umanda yatangenakaing,’ ngang matakuu dua kendekingge nanikaing ba dasing,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Yanikenga peke epu yot gapma kepman kuke paku zikaa wagwene Betani yot gapmane kuke dapuna wanggapmane pekut. ");
INSERT INTO wnc_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Siwan tembana Jesuta Jerusalem gapmane gatuna kuke tomna natapbut. ");
INSERT INTO wnc_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Tomna natake kawan katau baau dakatu kepiapane yuwan kake kukut. Ngana tapuya kaya dua. Wena. Tatakngikan kakut. Kake baau wandaka anzing inikut, “Ga buya gatuka ma aawim. Wena siknga,” ngang yawan zetgaman baau wandakata akumbut. ");
INSERT INTO wnc_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Kungwake kupiawan kake pandetnata asatnake, “Dasingge baapdaka zetgaman kupiakgak,” ngang yakumang. ");
INSERT INTO wnc_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yana yake anzing ninikut, “Nata siakande siknga daninggat. Ginu Anutue natapa meya dua siwanu ginda nata katau baapdakae tasinggat taknga atasining. Siwan ginda unukan dua tasining. Aho. Puya buyambamu atasining. Sike ginda tawanu andakata zike yanggabam gwene isakuwikge yawa kekekawanu itaaya unzing atasiwik,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","“Sike ginda Anututa gatanimik ngang natapa kekekawan tumuk wam iniwanu sangabamu apanangge natake yaningu apaning,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Siwan Jesuta Anututane yot takwan gwende daman gwekatang koke aminbam yanindamukut. Yanindamuke yawawan Anututane yot takwan gwene pasiya amindane take akwakat gatu Judia amindane take amikatda ie apu anzing iniking, “Ga maminda tapan sanga waaknga pasinggayak,” ngang iniwa ");
INSERT INTO wnc_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","yake anzing yanikut, “Nakaya wamu takngatu ginu danikwaiwit. Danikwaiwa yake atnaniwanu nakaya maminda tapan puya waaknga pasinggatde daniwit,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","“Jonda aminbamu yangga sauyamukut taknga enandang nanae sanga ba aminde sanga ba dasing,” ngang yanikwaiwan natake ina anzing yaking, “Ninda, ‘Enandang nanae sanga,’ ngang yananu, ‘Dasingge ginu baniu ie dua sike yuaing,’ ngang niniwik. ");
INSERT INTO wnc_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Sike ninda, ‘Aminde sanga,’ ngang yanangge gwaukamang. Unzing yananu aminu kuupbam Jonde ayanikapsaapa ngang nataaingga nisipnang,” ");
INSERT INTO wnc_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","ngang natake yake anzing iniking, “Ninu Jonde dua nataamang,” ngang iniwa anzing yanikut, “Nakaya ginu puya waaknga na maminda tapan apu pasinggatde dua daniwit,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Ginda dasing nataaing? Aminu tapatuat gatu itane waaknga tapaat unekan gatake yuking. Yusika nanata waaknga tupan tapae anzing inikut, ‘Waaknga. Ga gunziu anggwene kuke wain tapunde puyaangane pasingamuyo,’ ngang iniwan, ");
INSERT INTO wnc_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","‘Dua kuwit,’ ngang inike ngana mateknga kundusim yukenga musia tapan tekwamban kuke pasingamukut. ");
INSERT INTO wnc_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Siwan nanata waaknga masan tapae unzakan iniwan akuwit,” ngang inike ngana dua kukut. ");
INSERT INTO wnc_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Siwan tuwang wamu waaknga daniwa natake banipzaatang dasing nataaing? Aminu waapaakatnana mamin tapata nanae wam gwaamuke tasikut,” ngang Jesuta yanikwaiwan, “Tupan tapa,” ngang iniking. Iniwa yake anzing yanikut, “Siakande daninggat. Kait pasiyuk takis papsa amin takwakat yasewa pasiya amikatda waiakngana teke Anutue gen gwaamuke Anutue daman katangu tupanu waakwakga kopning. ");
INSERT INTO wnc_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Siwan Jonda noman siknga tasiningge kepiaknga danikapan ngana ginu wamna natapa siakan dua sikut. Ginda natapa siakan dua siwan ngana kait pasiyuk takis papsa amikat yasewa tasiya amikatda Jonde wamna natapa siakan sikut. Siakan siwan kake ngana ginu musipza dua tapa tekwamban wamnae siakan dua natayuaing,” ngang Jesuta unzing yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Ginu tuwang wamu takngatuat natapnong. Aminu tapatuta kepna buyambam siwan wain tapunde puyana pasike kwaike awamabasikut. Awamabasike puya banakan katangu wain tapun yainggamuwawa yanggata pukuke dopikge gapma kwaike you mamaya siknga kuka aminde kayutnangge mitapbut. Mitapan puyuwan puya waanga aminu kundue kataune yaman kayukngamuwawa buya aawan deke usanzike kautdu gisae pake kautdu ninae namunong ngang yanike ita keu maa siknga komdune kukut. ");
INSERT INTO wnc_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Kuke yuwawan wain tapun detnanga tapduknga dapaknga siwan tapuya kundu panangge natake puya amina kundu tapatu tapatu yanipewan kuwawa ");
INSERT INTO wnc_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","puyanae pasikaingga pake tapatu moo tangupbapbauke tapatu atangutapa kupan tapatu supda tanguwa kumbut. ");
INSERT INTO wnc_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Siwan puya toikga puya amina kunduat aminu buyambam yanipewan kuwawa ina unzakan pasiyamuking. ");
INSERT INTO wnc_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Pasiyama natake anzing yakut, ‘Natane waakngae wamu apme natapning,’ ngang yake inane waaknga ngang initewan kukut. ");
INSERT INTO wnc_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Kuke wesim kuwawan kake ina anzing yaking, ‘Aminu aapata nanatane kwatangi apmea papik. Ayok. Tangutna kupan puya angana ninda tana,’ ngang yaking. ");
INSERT INTO wnc_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ngang yake waapa tangutawamba kepman kuwan tangutapa kumbut. ");
INSERT INTO wnc_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Ge ginu dasing nataaing? Masande puya toikga apuke aminu puyangane pasikaingge dasing pasiwik,” ngang yanikwaiwan ");
INSERT INTO wnc_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","anzing iniking, “Bania toknga siknga natake aminu wai waakwau yake atzipan kupa wain tapunde puya waanga aminu kundu buya detnanga tapduk gwene deke ie asimuningge yaman kayutning,” ngang iniking. ");
INSERT INTO wnc_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Iniwa yake anzing yanikut, “Anututane wapatang wamu takngatu anzing matakut, ‘Suu gwendu yot mitapsa aminda kake wai pupuknga ngang yake mutewa kukuu wagwenu yotde tepa kusiwan yot gwen tapan kekekanggak. Buyambam tapata sanga waaknga tasiwan kake asatnakamang,’ ngang matakuu dua kendeking ba dasing? ");
INSERT INTO wnc_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Unzingge nata daninggat. Anututa amin panangge tasinggak kaknga ginde kaiwan kundaman dongu Anututa kekeknga gepbiatang yutnanga akngatane puya pasiwa buya asaakgak takwakge ayamik,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","(“Sike aminu yotdane sanga wandakane engatangan pimakengu zipmandakngawan matek mateknga sining. Sike sanga wandakata aminu tapatu pimake tangutapakusiwan aminu waapa asuupamapa kuning,” ngang yanikut.) ");
INSERT INTO wnc_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Siwan Anutue yot takwan gwene pasiya amindane takeakwakat Ferisi amikatda Jesuta tuwang wamu wa yakut taknga natake atnatdeking. Ita ninde tuwanguke yanggak ngang natapbing. ");
INSERT INTO wnc_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Natake Jesu tanggaganutnangge natake ngana aminbamda Jesue ayanikapsaapa ngang natapa kekekakutde akgwauking. ");
INSERT INTO wnc_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Siwan Jesuta gatuna aminbam tuwang wamu anzing yanikut, ");
INSERT INTO wnc_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Anututa amin panangge tasinggak kaknga anzing. Keu komdunenana amindane tupan tapatane waakngata maya kayuk tanangge yakut. Yawan nana tupan tapata nanamu sandama apu nanong ngang yanike nanamu buyambam sayamukut. ");
INSERT INTO wnc_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Sayamuke amina yanipewan kuke amin bamu, ‘Apu nanong,’ ngang yaniwa ngana apbitaking. ");
INSERT INTO wnc_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Siwan natake take waapata amina kunduat anzing yanikut, ‘Ginda kuke aminu apbitaking aminu anzing yaninong, Na ikwawa gamanu wawiat ikwawa gaman mateknga suyukngaat gwan zipmat. Zipmake minaka minakabam gwan tandakngat. Waakngata maatna tapikge apu nanong, ngang yaninong,’ ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Yaniwan aminata kuke unzakan yaniwa natake ngana yake dua yaniking. Yake dua yanike tapatuta puyanane kuwawan tapatuta inane usiwamyotnane kukut. ");
INSERT INTO wnc_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Siwan kunduta unzakan kuking. Kuwawa ngana kundu tupan tapatane puya amina panggaganuke atzipa kumbing. ");
INSERT INTO wnc_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Atzipa kupa natake tupan aminu waapata baniaatang toknga siknga natake inane amak amina yanipewan kuke zipa kumbing aminu yake zipa kumbing. Zipa kupa yotna katapda sawa yasiwan puyukut. ");
INSERT INTO wnc_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Yasiwan puyuwana tupan aminu waapata amina anzing yanikut, ‘Maatna tapikge sanga gwan tandakngakum ngana apu nanong,’ ngang yaniwa bitaking aminde yapii anggaman kawa wai siknga singgak. ");
INSERT INTO wnc_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Siwan ginu kepiapane kuke kaawa aminu kunduta apa kake, ‘Apu nanong, ngang yaninong,’ ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Yaniwan natake amina kepiapane kuke aminu wai ba take ba unzakan aminu nanam naningge yaniwan unekan apbing. Apa maatna tapikge you akopbing gwenu akgitnakut. ");
INSERT INTO wnc_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Siwan tupan aminu waapata unekan apbing aminu kanangge natake apbut. Apu kawan wawi tapatuta undang yuwan kakut. Kawan wawi waapata tauu kayukgomu dua mapapukuwan kopbutna kake akasatnakut. ");
INSERT INTO wnc_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Akasatnake wawi waapa anzing inikwaikut, ‘Notna. Dasingge tauu kayuk gomu gamukumu teke anggwekatangu akoyak,’ ngang inikwaiwan yake ininangge natake ngana apmeptakut. ");
INSERT INTO wnc_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Apmeptawan kake tupan aminu waapata puya amina anzing yanikut, ‘Waapatane katakngiat kepinaat napda wamake kepman mutewa zikaa sikngaatang kuke kwanam sike kaakake asinggan yuwawik,’ ngang yanikut.” ");
INSERT INTO wnc_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Siwan Jesuta tuwang wamu waaknga ngang yanikenga anzing yanikut, “Anututa aminu buyambam yayawanggak ngana aminu tapatu tapatukan papan aminabam daknganing,” ngang Jesuta unzing yaniwan natapbing. ");
INSERT INTO wnc_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Yaniwan natake Ferisi aminu waakwakga kuke paut tasiking. Paut tasike unzing inina Jesuta yake ninike undang pimapan wamu yanim ngang yaking. ");
INSERT INTO wnc_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Yakenga waakwakgane pandetna kunduat Herotde wamna natapsa aminu kunduat yanipewa kuking. Yanipewa kuke tapatuta Jesu anzing inikut, “Ninindamumsaapa. Gata kewam dua nininggayak ngang natapna siakande singgak. Gata Anutue kepi tawanim taknga siakande siknga ngang ninindamuke yawa naninang ngang natake dua gwaukgayak. ");
INSERT INTO wnc_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Siwan ganikwaitna banipbaatang natake waakngakan niniyo. Ninu Judia nana aminda gavmanu Sisae takis mani imukenga ninda Anutue mama wam sandetnim ba dasing,” ngang inikwaiking. ");
INSERT INTO wnc_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Inikwaiwa natake waakwakga wai tasingamunangge natake nanikwaikaing ngang Jesuta baniaatang natapbut. Natake yake anzing yanikut, “Ginda dasingge na tanzitnangge tasikaing? Ginu genza gwakngayasa kaya amin. ");
INSERT INTO wnc_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Takis mani sandu yeukngama kawit,” ngang yaniwan sandu ie imuking. ");
INSERT INTO wnc_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ima take anzing yanikwaikut, “Mani asanu weenaat gatu umanau mamindane matakinga kaaing,” ngang yanikwaiwan yake, ");
INSERT INTO wnc_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","“Sisatane,” ngang iniking. Iniwa yake anzing yanikut, “Sisatane sanga Sisae imunong. Siwan Anututane sanga Anutue imunong,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Yaniwan natake kuutda asatnake i teke kuking. ");
INSERT INTO wnc_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Tapduu wagwenekan aminu akungwakengu uyunga dua enakaing ngang yaya aminu Sadyusi ngang yanikaing. Siwan Sadyusi aminu wa kunduta Jesue apu anzing inikwaiking, ");
INSERT INTO wnc_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Yanindamumsaapa. Mosesda ninde baminde wamu takngatu tupa siknga anzing yakut. Aminu tapatu maatna take ngana waaknga wena siwan yusika akupanu uyapnata maya kombakobau waapa take ita paanae tangge waaknga tangamuyok ngang yakut. ");
INSERT INTO wnc_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Sike tupa inaakwau katau kautdu musa kautdu tapaaya ngangga nikat gatake yukumang. Siwan tupan tapata maatna take yusika ngana waaknga wena siwan akumbut. Kupana uyapnata maatna waapa take ");
INSERT INTO wnc_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","masanu waapaaya unzakan sikut. Siwan banakan tapata kuut unzakan tasiwan masan nana amindaaya unzakan tasiking. ");
INSERT INTO wnc_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Tasike kuupbam kupana masan siknga maya waapa kuut akumbut. ");
INSERT INTO wnc_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Sike gata niniyo. Tapduknga kupsa aminda enatning gwene maya waapa katau kautdu musa kautdu tapaayata takingge waakwakatnana mamin tapatane maatna dakngawik? Ga atnatayak. Kuupbamda taking,” ngang iniking. ");
INSERT INTO wnc_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Siwan Jesuta yake anzing yanikut, “Ginda Anututane wamu tupa siknga mataking kaknga dua nataaing. Siwan ginu Anututane kekeknga aknga kuut dua natake wamu gutonga yakaing. ");
INSERT INTO wnc_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Sike tapduknga akupsa aminda gatu enatning gwene maya wawita angela enandang nana binga dakngake maatnae ba apnae dua kuning. Wena. ");
INSERT INTO wnc_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ngana akupsa aminda gatu enatningge wamu nata ginu danikwaiwit. Ginda wamu Anututa danikut taknga dua kendeking ba dasing? Ita anzing yakut, ");
INSERT INTO wnc_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Na Ebrahamdane Anutuna, gatu Aisakgane Anutuna, gatu Jekopdane Anutuna,’ ngang yakut. Ge Anutu akupsa aminde Anutuna dua. Wena. Kayuk yuya aminde Anutuna,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Yaniwan natake aminbamda itane wamde asatnaking. ");
INSERT INTO wnc_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Siwan Sadyusi aminda yake Jesu ininangge natake meptawa kake Ferisi aminu kunduta unekan kuking. ");
INSERT INTO wnc_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Unekan kuke iatnana tapatu Mosesde mama wam Yanindamumsa aminu tapatuta Jesu tasiwan siwikge anzing inikwaikut, ");
INSERT INTO wnc_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Ninindamumsaapa. Mosesdane mama wamu zaakngata mama wamu kuupbamdane tupan siknga aknga daknganggak,” ngang inikwaikut. ");
INSERT INTO wnc_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Inikwaiwan Jesuta yake anzing inikut, “Anutu Buyambam tapakae banipbaatang gwaam siknga natake musipbaatang take siknga natangamuke natdetdetdaatang asinggan asinggan Anutue natanggamatayo. ");
INSERT INTO wnc_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Mama wamdane tupan siknga aknga unin. ");
INSERT INTO wnc_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Siwan mama wamu uneta unesim yuak kaknga anin. ‘Gae wesim yuak kapae butaya natangamuyo. Unzing gikae gupba wai dua siwikge natake butaya nataayak binga.’ ");
INSERT INTO wnc_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Mama wamu wa kuut takngaat tasiwinu Moseskat ayanikapsa amikatdane wamu yakingu buya unin aawik,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Siwan Ferisi aminu kunduta unekan apuke yuwawa Jesuta anzing yanikwaikut, ");
INSERT INTO wnc_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ginu Anututa tapan Krais dakngake yuak kapae dasing nataaing? Waapa mamindane dongane aakut,” ngang yanikwaiwan yake, “Devitdane dongane aakut,” ngang iniwa ");
INSERT INTO wnc_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","anzing yanikut, “Ayok. Dasingge Waung Takwan Tapata Devitdane musia tangenawan Devitda, ‘Buyambam tapana,’ ngang inike anzing yakut, ");
INSERT INTO wnc_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Buyambam tapata natane buyambam tapana anzing inikut, Ga umanda kayaapa dakngake yuayakge natane kataknga siyaapane yuwawi nata iwanda panggaganuke pewa gae gepbiaatang koyutning,’ ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Devitda ina, ‘Buyambam tapana,’ ngang inikut. Ngang dasingge ginda ita Devitdane dongane aakut nganggan yakaing,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Yaniwan natake tapatuta Jesutane wamu yake ininanga dua sikut. Siwan tapduu wagwene tuwanguke masande yakwaik wamu ie takngatu gatu inikwaitnangge akgwauking. ");
INSERT INTO wnc_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Siwan masande Jesuta wamu aminbampat pandetnaat anzing ninikut, ");
INSERT INTO wnc_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Mama wam yanindamumsa amikat gatu Ferisi amikatda Mosesde mama wam yake tangenakut tapae tangge yuaing. ");
INSERT INTO wnc_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Unzingge wamu kuupbam ginde damukuu natake tawanong. Ngana sanga tasikaing kaknga kake ginda ma tawambam. Wena. Wamu kwaapzang yake ngana ina wamu wa yakaing kaknga dua tawakaing. ");
INSERT INTO wnc_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Siwan wa aminu mama wamu nangaakan wamaknga meya siknga wamakaing binga aminde gwaamnane peyamuke ngana ina kataknga boopmita meya wa yamukaingu dua gatayamukaing. ");
INSERT INTO wnc_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Sike sangabamu aminu waakwakga tasikaingu kake aminu dudumna ngang yaningge tasikaing. Ngan. Aminu waakwakga katasiu mama wam mataking kaknga ngwayoknga san papakopa damawamnae wamake tumuk wam yanangge natake asinggan pasikaing. Sike tauknga nomna saasaaknga mamaya siknga pasikaing. ");
INSERT INTO wnc_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Sike nanam nananggengu pomu tupan sanekan yutnangge nataaing. Siwan tupan gan miti yot katang yutnangge nataing. ");
INSERT INTO wnc_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Sike sanga usikaing komune gaak wam umana kaya amin ayanindamumsaapa ngang yaniningge take nataaing. ");
INSERT INTO wnc_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Ngana aminda gindane umanza yatangenake ayanindamumsaapa ngangu daniningge take ma natapam. Wena. Gin danindamukgau awia tapatukan. Siwan ginu kuupbam notna dakngake yutnong. ");
INSERT INTO wnc_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Siwan keu andakane yuke aminu tapatutane umana yatangenake Toikngin ngang ma inimbakngawam. Wena. Gindane Toikza enandang yuau awia tapatukan. ");
INSERT INTO wnc_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Siwan aminda takeapa ngang daniningge take ma natapam. Wena. Gindane take aminza awia tapatukan. Waapa Anututa tapan Krais dakngake yuaunin. ");
INSERT INTO wnc_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ngana gikat nana tapatuta gindane buyambam tapasata ginde puya pasindamuke yuyok. ");
INSERT INTO wnc_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Aminu tapatuta inane umana tangenawiu itane umana apimapik. Sike aminu tapatuta inane umanae yumdekan ngang natapiu umana buyambam siwik,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Ginu mama wam yanindamumsa amikat Ferisi amikat ginu genza gwakngayasa kaya! Ginda toknga aknga apaning! Ginda Anututa amin panangge tasinggak kakngae gwabou aminbamde nomune yapukaing. Gisa undangu dua koke aminda kopnangge tasiwa ngana ginda dua kapewa kokaing,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","(“Ginu mama wam yanindamumsa amikat gatu Ferisi amikat ginu genza gwakngayasa kaya aminu toknga aknga apaning! Ginda maya kombakobatdane yotna kaiwa kuwa tumuk wamu mamaya siknga wai waakngasa takusopunangge yakaing. Unzingge ginda toknga siknga paning,” ngang yanikut.) ");
INSERT INTO wnc_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Ginu mama wam yanindamumsa amikat Ferisi amikat ginu toknga aknga apaning. Ginu genza gwakngayasa kaya amin! Ginda aminu tapatu tapan pandetza dakngawikge natake yanggabam gwene kuke kepdakane kuke aminu tapatu tapa gindane pandetza dakngake katap bapatang kunanga amin gisa binga daknganggak. Ngana ginda tasiwa aminu waapa waiaknga tasike ginu atdapbikgak,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Ginu kaisa akusiya aminu toknga apaning. Kaisa wai siwa ngana kepi yeuyamunangge tasike anzing yakaing, ‘Aminu tapatuta wamu siakan ngang yanangge natake yot takwan gwende umana yawan natake undanga,’ ngang yakaing. Ngana aminu tapatuta aminda gol sake pakapu yot takwan gwene pewa gatakukingge yake, ‘Siakan,’ ngang yakengu, ‘Ita ayawan kekekawik kaknga tasiyok,’ ngang yakaing. ");
INSERT INTO wnc_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ginu katukatum! Kaisa akusiya amin! Gol sake pakapu Anututane yot takwan gwene pewa gatakukingu takwan daknganggak. Siwan gol pewa gatakukingu wa sasanda yot takwan gwenu yapbike sanga buyambam siknga singgak ba dasing? Wena. ");
INSERT INTO wnc_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Siwan ginda anzing yakaing, ‘Aminu tapatuta sangana Anutue imuke buka pengamukaing gwende umana yake, Siakan, ngang yawanu wa sanga moi kundu. Ngana ita sanga wa Anutue imuke pengamukaing kakngae umana yake, Siakan, ngang yakengu ayawan kekekawik kaknga siakande tasiwik,’ ngang yakaing. ");
INSERT INTO wnc_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ginu kaisa akusiya amin! Buka gwenu sangana Anutue imuke pengamukaingu takwan daknganggak. Siwan sanga Anutue imukaing kakngata buka wagwenu ayapbikgak ba dasing? Wena. ");
INSERT INTO wnc_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Unzingge buka gwenu sanga Anutue imukaing gwende umana yake siakan ngang yakengu wamna sangabamu une yuaingge kuut yawan kekekawik. ");
INSERT INTO wnc_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Siwan aminda yot takwan gwende umana yake siakan ngang yakengu wamna yot takwan gwendeat gatu Anutu you wagwene yuak kapae kuut yawan kekekawik. ");
INSERT INTO wnc_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Siwan aminu tapatuta enandang Anututa yuak komde umana yake siakan ngang yawanu wamna Anututa kekeknga akngane yuak kakngaat gatu Anutu kekeknga apaatde yawan kekekawik. ");
INSERT INTO wnc_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Ginu mama wam yanindamumsa amikat gatu Ferisi amikat ngangu ginda toknga aknga apaning! Ginu genza gwakngayasa kaya amin! Ginda iyaknga kuupbam puyanenana katau kuut musaat pake usanzike kasam gatu tabapmensam gatu gwapda ngang usanzike kendewa kuku mingandaka singgakgan Anutue imuke mama wamu kwanga aknga tawake tasikaing. Ngana ginda wamu meya kananga aknga gwa teking. Unzing wamu nomana akngane amin usanzitnanga aknga gatu sanga kwikwiknga akngaat gatu Anutue natapa kekeknga siya aknga kuut gwa teking. Sike mama wamu wa meya kananga aknga dua teke sanga katau minga dakakan imanu take siwik,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","“Ginu kaisa kusiyata aminde kepi yeuyamunangge tasikaing! Ginda inguingutda yangga akngane yuwa kake kwaipamaba kuwa tangokaing binga tasikaing ngana ikwawa gamanda yangga akngane yuwan kake ngana ngok pamukaing binga tasikaing. ");
INSERT INTO wnc_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Ginu mama wam yanindamumsa amikat Ferisi amikat ginda toknga aknga apaning! Ginu genza gwakngayasa kaya amin! Ginda bapusatane wam tawake kapzaat dopangzau kepmangan saukaing ngana sangaapa panangge toknga natake ginda gwaut wam yayuk mani pake kait pasike mani pakaing kakngatakan banipzaatang dokgak,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","“Ginu Ferisi aminu kaisa akusiya amin! Tupanu kapza amaakatangu sauwana kepman saakaya dudumna kuut siwik. ");
INSERT INTO wnc_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Ginu mama wam yanindamumsa amikat Ferisi amikat ginda toknga aknga apaning! Ginu genza gwakngayasa kaya amin! Ginu unzing matmat gapma penu kwaknga gwenda pasikaing binga. Kepmanu kana dudumna siknga singgak ngana amaakatangu amindane kwataiat gatu apbukatanggakat ngang undang doke yuak. ");
INSERT INTO wnc_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Gikaya wa bingata yuaing. Aminda danduke amin noman ngang nataaing. Ngana banipzaatangu sanga kem wam gatu mama wam sandekaing kakngatakan doke yuak,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","30","“Ginu mama wam yanindamumsa amikat Ferisi amikat ginda toknga aknga apaning! Ginu genza gwakngayasa kaya amin! Ginda anzing yakaing, ‘Ninda tupa siknga bapuninda yuking komune yukumang gamu ninda ayanikapsa amin zipningge dua gatayamunam,’ ngang yake ayanikapsa aminu wa noman amin takwakge apbakngane matmatna tanomunuke tupa kwaiking komune yot matek mitake sanga kawa take siwikge sanga tasikaing. ");
INSERT INTO wnc_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Wamu wa yake tasikaing kakngata gisae yapii yakapmakaing. Ginu ayanikapsa amin zipbinggane zakngi. ");
INSERT INTO wnc_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ayok. Ginda bapusata tuwanguke tasiking kaknga undang tasiwa puyuyok! ");
INSERT INTO wnc_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Ginu gomok binga dandugwaukaingge Anututa ginu katap bapatang dua dapmambikge dasing tasining? Wena. ");
INSERT INTO wnc_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Siwan nata daninggat. Nata yanikapsaat natdetdetna kayaat Mosesde mama wam danindamumsa amikat ginde yanipewa kuning. Yanipewa ginde kuke daniwa natake ngana ginu iatnana kundu amin saamdakane zipa kumning. Siwan kundu moo zipa kumning. Siwan kundu kaipakapu miti yot gwene koke ipmapa zipmake kundu toknga takngatu takngatu yamuke yot gapma inandek tawatakuwawa yot gapma gapma inandek kuning. ");
INSERT INTO wnc_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Siwan tupa siknga aminu take aminu buyambam bapusata wai zipa kumbing. Yakap siknga Ebel tanguwa kupan kuku masande Sekaraia Berekaiatane waaknga bamzata Anutue yot takwan gwenu kautdu yuwan kaap Anutue imunangge wasau kautdu saak yuwan banakan komune tanguwa kumbut. Aminu take amin waakwak wai zipa kupa Anututa toknga akngana atzipbing aminde yamik kaknga atdamik. ");
INSERT INTO wnc_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Siakande daninggat. Zipa kumbinggane waiaknga ginu apmanu ayuamang komune nana aminda tokngabam apake kaning,” ngang Jesuta yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Jerusalem nana! Jerusalem nana! Anututa yanikapsaat kuwikngaat yanipewan kuwawa ngana ginda asinggan inandek inandek supda zipa kungwakaing. Ginde butaya natake taau minga gwenda gwauya wam yawan matekngata apa piata usikwatapan amakatang yuaing binga ginu Jerusalem nana gatu gatu yandawamba ngana ginda apbitake yuaing. ");
INSERT INTO wnc_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Unzingge Anututa dapmake kuwan ginu gisatakan gatukande moo siknga yutning. ");
INSERT INTO wnc_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Siwan daniwa natapnong. Ginda na gatusa dua nandupning. Tapduknga ginu Buyambam tapaninda initewan apunggak ngang nanimbakngake yaning gwekatang gatusa nandupning,” ngang Jesuta yaniwan natapbing. ");
INSERT INTO wnc_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Siwan Jesuta Anututane yot takwan gwen teke kuwawan pandetnata yot wagwende daman gwene yot matek gwegwenu supda mitapbingu yeukngamunangge ie kukumang. ");
INSERT INTO wnc_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Siwan ngana ita gamok anzing ninikut, “Ginda sanga a kuupbam akaing ba dasing? Nata siakande daninggat. Sup yot anggwegwenu mitapbinggane suu gwendu amak aminda dua katewa sup notna gwendune engetanganu dua yuwik. Kuupbam zipbuke muba pimaning,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Siwan Jesuta tawanu Oliv dakane yuwawan pandetnatakan ie kuku anzing inikumang, “Gata ninu niniyo. Zaapduknga sanga waakngata apik? Tuwangu zaakngata gamok apan kake ninda natdetnim. Gata gatu api tapduknga ayuamang gwenda wena siwikgen,” ngang inikwaikumang. ");
INSERT INTO wnc_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Inikwaitna yake anzing ninikut, “Ginu gwautnong. Aminu tapatuta ginu kem daniyak. ");
INSERT INTO wnc_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Aminu tapatuta enake apu natane umana yake anzing yaning. Anututa na tapan Krais dakngake gatandamuyaapa yuat ngang kem yawik. Ina unzakan sipdu sipdune aminu tapatu tapatuta enake apu wamu waakngakan kem yaning. Ina unzakan tasitakuwawa aminbamda kem wamu waaknga natapa siakan siwik. ");
INSERT INTO wnc_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Sike ginda nataawa keu komdune amak tasiwawa natapning. Gatu nataawa amnangge yawa natake ma satnawam. Sanga waakngata gamok apik ngana tapduknga wena siwik kakngatane tuwangu unin dua. ");
INSERT INTO wnc_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Siwan keu komduine nana aminda amau buyambam tasike amatakuning. Sike keu komdui tomna buyambam siknga natapning. Siwan miyamunu kepna kepna sining. ");
INSERT INTO wnc_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Sanga wa kuupbamu anzing. Toknga gamok mayaata engang tangaiwikge isinggak binga,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Tapduu waomune ginu aminde yama panggaganuke meya takngatu takngatu damuke kundu dasipa kumning. Unzing tasindamuwawa ngana natane umana gitna take yuwawa aminbamda ginde semna siknga natandamuning. ");
INSERT INTO wnc_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Siwan tapduu waomune aminbamda nae natapa kekekakut takngana tewa pimapan nae umanae yuaikatnana iwande kataune yamuke semna natayamuning. ");
INSERT INTO wnc_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Siwan aminu kundu Anututane ayanikapsa amin binga ngana kem amin dakngake wa aminda enake aminbamu kem yaniwa natapa siakan siwan undang pimaning. ");
INSERT INTO wnc_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Sike waiaknga buyambam siknga tasiwawa aminbamda banip gwaang nataaing kaknga atewa pimapik. ");
INSERT INTO wnc_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ngana mamin amindaka kekeknga yuke meya waakngaatang dua pimake yuwiu yutningu tapduknga asandewik gwene Anututa kayuk yutnanga aknga wa aminde ayamik. ");
INSERT INTO wnc_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Siwan wamu Anututa amin panangge tasinggak kakngae wamu take aaknga keu kuupbam yakapa aminu kuupbamda maakngita natapana tapduknga asandewik,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Siwan ginda kawawa sanga wai siknga tupa yanikapsa aminu Daniel ngang iniking kapata tupa siknga ie yakuu kep takwan kopatang tasinanga dua ngana undang tasike yuwawan kaning ngang yanikut. (Siwan na wamu aaknga matanggat tapata anzing natake matanggat. Aminda wamu waaknga kendekengu katak siknga natapsok.) ");
INSERT INTO wnc_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Siwan tapduu wagwene aminu Judia kep komune yuaingu datang tawandakane kopnong. ");
INSERT INTO wnc_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Sike aminu yotna engatangan gwene yuwiu epu yoakatang koke sangana pananga dua. ");
INSERT INTO wnc_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Siwan aminu puyanane yuwiu yotna kuke got tauknga tanangge kunanga dua. ");
INSERT INTO wnc_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Sike maya musia kaa ba maya engangge ngwam yaman nakaingu tapduu wagwene meya buyak yutning. ");
INSERT INTO wnc_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Siwan tapduknga ginda atdatakuning gwende natake tumuk wam yake got tapduk siwik komune dua datakuningge gatu yuwatakak tapduk gwendune dua datakuningge kuut tumuk wam yanong. ");
INSERT INTO wnc_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Tapduu wagwene meya buyambam siknga siwik. Tapduknga kep tasike tekuuneta apu apmanu kuut meya wa binga takngatu tupa dua apbut. Siwan masan kaya meya wa binga wena. ");
INSERT INTO wnc_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Sike Anututa tapduknga wagwenu dapaknga dua isatakepikge yakut gamu aminbamu wena asiwan. Ngana Anututa papan aminabam dakngake yuya aminde natake tapduu wagwen dapaknga isatakepik. ");
INSERT INTO wnc_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Sike tapduu wagwene aminu tapatuta anzing daniwik, ‘Kanong! Krais gatanimuya apata andang yuak, ba ita atunzing yuak,’ ngang yawanu ginu, ‘Siakan,’ ngang ma natapam. ");
INSERT INTO wnc_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Sike, ‘Anututa na tapan Krais dakngake yuat,’ ngang kem yaya amikat, ‘Anututa na tapan ayanikapsa amin dakngake daniwa natapnong,’ ngang kem yaya amikatda enake duya kekeknga siknga takngatu takngatu pasining. Pasiwawa kake aminu buyambamda pimatning. Siwan aminu Anututa papan inane aminabama dakngake yuya amindaaya kuut siakan ngang natake undang pimatningge panziwa maiwik. ");
INSERT INTO wnc_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Natapnong! Nata ie gwa danit. ");
INSERT INTO wnc_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Unzingge aminda anzing ba danining. Kanong! Ita atu amina wena kopatang yuak ngang daniwanu ugwak saau ma kuwam. Siwan gatu anzing ba yaning. Kanong! Ita you anggwekatang yuak ngang daniwanu siakan ngang ma natapam. ");
INSERT INTO wnc_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ginu atnataaing. Tapduknga yapasikga siwanu kakaa waaknga gunzitda akonggak katangga kakaatake kuku gunzitda pukunggak katang kuwan aminu kuupbamda kaning. Siwan ina unzakan. Aminu kuupbamda kawawa na aminbamde notnaapa dakngake apit taknga anggaman kaning. ");
INSERT INTO wnc_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Keu akupsa aminda gupnata yuaing komune tinggigita asapu doke yuaing,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Tapduu wagwene meyambamu wa wena siwana zetgaman keunenana aminda meya takngatu takngatu kaning. Gunzitda zikaandaka siwan yekau kakaa dua siwan yekapdaau ena kakaa banakan komune nana saa sike deke pimapa kaning. ");
INSERT INTO wnc_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Siwan tuwangu na aminbamde notnaapa dakngake yuat tapatane ena banakan komune siwan aminbamu keunenana aminda kawawa nata umana buyambam siwan kekekngana buyambam siknga aknganane yuke minga musatune yuke epa na nandugwautning. ");
INSERT INTO wnc_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Nandugwauke yuwawa nata pumu kumzang puyake angelana yanipewa kuke aminu Anututa papan aminabam dakngake yuaingu kepna kepna nana kuku pake pakapu unekan pening,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Ginda katau baapdaka kake natdetnong. Kainga yanggana kaya siwan tatakngi kayuk akopa kake anzingu atnatdekaing, ‘Apmanu kep takawan gunzitda isiwikge tapduknga gwa singgak,’ ngang yakaing. ");
INSERT INTO wnc_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ina unzakan. Masande kawawa sanga wa kuupbam apa kakengu ginda atnatdetnong. Nata apitde tapduknga gwa dapakanggak. Aminu tapatuta yoakatang kopnangge apuke gwabok gwaune yuak binga tapduknga gwa dapakanggak,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","“Siakande siknga nata daninggat. Tapduk ayuamang komunenana aminda dua kumning gwene sanga wa kuupbam asapik. ");
INSERT INTO wnc_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Sanga kuupbam ena kakaa banakan komune yuaikat gatu kepdakane nana kuut wena asinanga ngana natane wama wena dua siwik,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Siwan aminu tapatuta tapduknga nata apitde dua nataak. Angela enandang nanaaya dua nataaing. Na Anututane waakngaaya dua nataat. Nanatakan ie atnataak. ");
INSERT INTO wnc_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Sanga Noata yukut komune nana aminda tasiking kakngakan tapduknga na aminbamde notnaapa dakngake yuat tapata gatu apit gwene tasining. ");
INSERT INTO wnc_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Tupa yangga buyambamu dua paptakut gwene aminu waakwakga nake tangoke maatna pake tasiwawa Noata dopangbam gwene kopbut. ");
INSERT INTO wnc_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Sike wa aminu dua natake unzakan tasike yuwawa yanggabamu apaptake apu aminu wa kuupbam zipa kumbing. Sike na aminbamde notnaapa dakngake yuat tapata apit gwene ina unzakan tasining. ");
INSERT INTO wnc_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Aminu tapaaya puyaangane yuwawat Anututa tapatu take tapatu atewik. ");
INSERT INTO wnc_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Sike maya tapaaya poyakge palaua pake tasiwawat Anututa tapatu take tapatu atewik. ");
INSERT INTO wnc_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Unzingge ginu katak siknga tandakngake yutnong! Na gindane buyambam tapasata apitde tapduknga ginu dua nataaing. ");
INSERT INTO wnc_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Daniwa natanggamatanong! Tupanu yot toikga zaapduknga zikaane kuka aminda apikge katak natakengu ita tandakngake yuke dua katewan kuka aminu waapata yotna waike yotnaatang kopik. ");
INSERT INTO wnc_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Unzingge gikaya tandaknganong. Na aminbamde notnaapa dakngake yuat tapa tapduk gwendune ginda dua apik ngang natapning gwene asapit,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Sike puya aminu mamin tapata puyana pasiwan kake natdetdetna nomantapa ge puyanae katak siknga kayuak ngang ie yanim? Puya toikga puya aminu waapa tapan puya aminu kundu kayuke tapdukngane nanam yamikge asinggan yamik. ");
INSERT INTO wnc_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Siwan masande puya toikga gatu apuke kawan puya amina waapa wamu tupa inikut taknga tasiwik ngang kawanu puya aminu waapata apbakngayok ngang yakut. ");
INSERT INTO wnc_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nata siakande siknga daninggat. Puya amina waapa sangana kuupbamde kuyana yuwikge tewik. ");
INSERT INTO wnc_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Siwan ngana puya aminu waapata wai amin dakngake yukengu musiaatang anzing natapik, ‘Natane buyambam tapanata zet gatu dua apik,’ ");
INSERT INTO wnc_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ngang natake puya amin notna zipmake aminu atdatdaptaning amikat nake tangopning. ");
INSERT INTO wnc_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Siwan puya aminu waapatane buyambam tapanata gatu apik ngang dua natake puya aminu waapata kayuke tapduu ie dua natapik gwene asapik. ");
INSERT INTO wnc_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Apuke puya amina waapa gatukande siknga atasiwan maiwik. Initewan kuke gena gwakngaayana kaya aminu toknga pakaikat yutning. Undang yuke kwanamna kumzang sike kaakake yutning,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Siwan tapduu wagwene sanga Anututa amin panangge tasinggak kakngata maya katau kuut musaatda tasiking kaknga binga dakngake yuwik. Aminu tapatuta maatna take nanambam naningge amin bam yayawamban natake maya waakwau lamna pake kuke ie kayuking. ");
INSERT INTO wnc_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Siwan katau kautdu musa natdetdetna wena. Sike kautdu musa natdetdetna kaya. ");
INSERT INTO wnc_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Maya natdetdetna wena lamna apaking ngana kerosinkat dua pakapbing. ");
INSERT INTO wnc_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Sike maya natdetdetna kaya kerosina botol gopatang tukwaba pukuwan lamna buyak pakapbing. ");
INSERT INTO wnc_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Siwan aminu maatna pananga apata zet dua apan kake maya mateu kuupbam dapuna natake tuyuknga siwan apeking. ");
INSERT INTO wnc_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Apeke yuwawa petakumat dakane wamu takngatu anzing yakut, ‘Aminu maatna gwa takut tapata asapunggak! Ginu apu kawa iat gatake yutnong,’ ngang yakut. ");
INSERT INTO wnc_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Yawan maya mateu waakwau kuupbam enake lamna pandakngaking. ");
INSERT INTO wnc_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Pandakngake maya natdetna wenata natdetdetna kaya anzing yaniking, ‘Gindane kerosinza kautdu ninde nimunong. Nindane laminu akumnangge sikaing,’ ngang yaniwa ");
INSERT INTO wnc_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","ngana maya natdetdetna kayata anzing yaniking, ‘Aho! Kerosinu buyambam dua. Ginde damukengu atdapnim. Ginu usiwam yot kuke gisa usinong,’ ngang yaniwa ");
INSERT INTO wnc_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","waakwau usinangge akuwawa aminu maatna gwa takut tapata asapbut. Apan maya atandakngakingu iat gatake yoakatang nanambamu maya tapan sakingunin nanangge koke gwabou gitna yapukusiking. ");
INSERT INTO wnc_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Koke gitna yapukusiwana maya mateu kerosin usinangge kukingu apu anzing yaking, ‘Buyambamtapa! Buyambamtapa! Gata gwabou ninde zitnimung,’ ngang iniwawa ");
INSERT INTO wnc_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","ngana ita yake anzing yanikut, ‘Nata siakande siknga daninggat. Ginde dua nataat,’ ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Ina unzakan. Ginda tapduknga nata apit gwende dua natake katak siknga tandaknganong,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Sike sanga tapduk wagwene siwan kaning kaknga aminu tapatuta keu maa siknga komdune kuwik binga. Ita puya amina yayawamban apa inane sangaapa wa aminde katakngane yamukut. ");
INSERT INTO wnc_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Yamuke wa amindane natdetdet gatu kekekngana inandek inandek usanzike mani yamukut. Aminu tapatue 5,000 Kina imuke tapatue 2,000 Kina imuke tapatue 1,000 Kina imukut. ");
INSERT INTO wnc_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Unzing tasike kuwana aminu 5,000 Kina pakut tapata zetgaman puya tasike isakoke gatu 5,000 Kina kunduat pakut. ");
INSERT INTO wnc_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Siwan aminu 2,000 Kina pakut tapaaya puya tasike isakoke gatu 2,000 Kina kunduat pakut. ");
INSERT INTO wnc_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Siwan ngana aminu 1,000 Kina pakut tapata paku gapma kwaike mani wa buyambam tapanatane undang pakusopukut. ");
INSERT INTO wnc_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Siwan puya toik waapata undang yusika tapduu mamaya siknga sandewana gatuna apuke, ‘Apnong. Siwan wamu yana takuwan,’ ngang yakut. ");
INSERT INTO wnc_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Yawan aminu 5,000 Kina isakoke pakuu pakapuke anzing yakut, ‘Buyambamtapa. Gata 5,000 Kina namukuyau kayo. Nata puya tasike 5,000 Kina kunduat isakoke pakum,’ ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Iniwan yake anzing inikut, ‘Ga puya aminu take siknga. Gata take siknga tasikuyak. Gata sanga matekngae katak siknga kayukuyakge nata gapmaba sangabamde kuyana yuyo. Gata api naat unekan yuke bakngake yutzim,’ ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Siwan aminu 2,000 Kina pakut tapaaya apu anzing yakut, ‘Buyambamtapa. Gata 2,000 Kina namukuyau kayo. Nata puya tasike 2,000 Kina isakoke pakum,’ ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Iniwan yake anzing inikut, ‘Ga puya aminu take siknga. Gata take siknga tasikuyak. Gata sanga matekngae katak siknga kayukuyakge nata gapmaba sanga buyambamde kuyana yuyo. Ga api naat unekan gatake yuke bakngasim,’ ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Siwan aminu 1,000 Kina pakut tapaaya asapu anzing inikut, ‘Buyambamtapa. Nata gae aminu tokngaapa ngang nataat. Keu kautdu saau aminu tapatuta nanam zak mukgau waangane gata buya apanggayak. ");
INSERT INTO wnc_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Unzingge na gae akgwauke gatane 1,000 Kinaka paku kepatang kwaipakusopukum. Gatane manika ana. Gika papso,’ ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Iniwan ngana yake kaanga anzing inikut, ‘Ga kamun siknga apa! Aminu tapatuta keu komdune nanam zak mukgau nata apanggat ngangu siakande nataayak ba dasing? ");
INSERT INTO wnc_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Unzing natake dasingge gata natane manina mani yot gwekatangu dua pekuyak? Unzing pekuyak gamu nata gatuna apuke natane maninaat gatu isakoke penikat papam,’ ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“‘Ayok, ginda 1,000 Kina wa kaiwa kuwan aminu 10,000 Kinana kayaapae imunong. ");
INSERT INTO wnc_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Dasingge? Aminbamda sanga apaningu nata kunduat wa aminde ayamit. Siwan ngana aminu tapatuta sanga dua papikge sanga mateknga ita papiu nata akaiwa kuning. ");
INSERT INTO wnc_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Siwan puya aminu dangenau waapa ginda inikwasiwa epu kepman siknga zikaa dakaatang kuke kwanamu kumzang sike kaakake yuaing kopatang yuwik,’ ngang yakut,” ngangu Jesuta wamu waaknga ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Siwan masande na aminbamde notnaapa dakngake yuat tapata kekeknga akngana buyak apit. Naat angela kuupbapatda apnim tapduk gwene na buyambamtapa dakngake kekeknga aknganane yuwit. ");
INSERT INTO wnc_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Yuwawa aminu kuupbamda nae nomane pakapu yutning. Yuwawa nata usanzike dongu takngaa pewa ikwawa kayuak kapata usanzike sipsip kautdu saak peke memengu kautdu saak peyak binga usanzike pewit. ");
INSERT INTO wnc_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Peke aminu take amin takwau siyaapa saak sipsip binga peke aminu wai amin takwau kwana saak memeng binga pewit. ");
INSERT INTO wnc_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Pekenga buyambamtapa yuke aminu siyaapa saak yutningu anzing yaniwit, ‘Ginu natane Nanata banip kwikwik natandamunggak aminu apnong. Tupa siknga kepat yekapat dua tasike tekut gwekatang Anututa amin panangge tasinggak kaknga ginde gwan tandakngatekut. Kekeknga gepbiatang yutnanga waaknga ginda apu tanong,’ ngang yaniwit. ");
INSERT INTO wnc_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Dasingge? Tupa na tomda yuwawa ginda nanamu nae atnamuking. Nata yanggae natapa ginda yangga namuking. Nata amin yotde apa ginda nanitake yotzane takuking. ");
INSERT INTO wnc_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Nata kwangga yuwawa ginda tauu nae namuking. Nata mait siwa ginda na toiking. Nata kaautde yuwawa ginda apu na atnandupbing,” ngang yaniwit. ");
INSERT INTO wnc_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Yaniwa yake anzing nanining, ‘Buyambamtapa. Zaapduk ninda ganduwatna ga tomba natapi ninda nanamu gae gamukumang? Siwan zaapduk ga yanggae natapi ninda yangga gae gamukumang? ");
INSERT INTO wnc_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Sike zaapduk ninda ga ganduwatna gata amin yotde api ninda ganitake yotninu takukumang? Siwan zaapduk ninda ga ganduwatna gata kwangga yuwi ninda gae tauu gamukumang? ");
INSERT INTO wnc_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Sike zaapduk ninda ganduwatna ga mait sike ba kaautde yuwawi ninda kuke gandupbumang,’ ngang nanining. ");
INSERT INTO wnc_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Naniwa nata buyambamtapa yuke yake anzing yaniwit, ‘Nata siakande siknga daninggat. Sanga ginda notna umana wena apasimde tasikingu sanga wa kuupbam nae tasingamukaing ngang dandupbum,’ ngang yaniwit. ");
INSERT INTO wnc_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Unzing yanike aminu kundu kwana saak yutningu anzing yaniwit, ‘Ginu toknga pananga amin! Ginu na napmake katau dua kungwanggak gwenu Anututa tandakngatekuu Setenkat puya aminaatda kuke toknga apaning gwene kunong. ");
INSERT INTO wnc_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Dasingge? Tupa na tomda yuwawa ginda nanamu dua namuking. Nata yanggae natapa ginda yangga nae dua namuking. ");
INSERT INTO wnc_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nata amin yotde apa ginda na yotza dua nanitakuking. Nata kwangga yuwa ginda nae tauu dua namuking. Nata mait sike ba kaautde yuwawa ginda apu na dua nandupbing,’ ngang yaniwit. ");
INSERT INTO wnc_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Unzing yawana yake anzing nanining, ‘Buyambamtapa. Zaapduk ninda ganduwatna ga tomba ba yanggae natapi ba gata amin yotde api ba ga kwangga yuwawi ba ga mait sike ba ga kaautde yuwawi ninda gae take dua tasinggamukumang,’ ngang naniwa ");
INSERT INTO wnc_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","yake anzing yaniwit, ‘Nata siakande siknga daninggat. Sanga ginda aminu umana wenaapae dua tasingamukingu sanga wa kuupbam naeaya dua tasingamukaing ngang dandupbum,’ ngang yaniwit. ");
INSERT INTO wnc_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Yaniwa wa aminu kuku toknga asinggan pake yutning. Ngana amin nomanu paku kayuk asinggan asinggan yutning,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Siwan Jesuta wamu wa kuupbam yawan puyuwana ninu pandetna anzing ninikut, ");
INSERT INTO wnc_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Ginu atnataaing. Gunziu gweaya kana sandewana Pasova yuwatakak tapduk takwan gwenu kanim. Siwana na aminbamde notnaapa dakngake yuat tapa aminda yeuyama amin saamdakane nutning,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Siwan tapduu waomune Anutue yot takwan gwene pasiya amindane takeakwakat mama wam yanindamumsa amikat gatu Judia amindane take amikatda Anutue yot takwan gwene pasiya aminde tupan tapa umana Kaiafas ngang iniking. Itane yotnane paut tasiking. ");
INSERT INTO wnc_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Wamu Jesu kem kusopuke inike tanggaganuke tanguwa kupikge wam yake ");
INSERT INTO wnc_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","anzing yaking, “Ninda tapduk takwan gwende nanamu buyambam sake nakamang gwene sanga dua tasinim. Tasina aminbamda enake amak tasinang,” ngang yaking. ");
INSERT INTO wnc_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Siwan Jesuta Betani yot gapmane aminu wata kekeknga sikut tapa gwan sandekngamukut tapa Saimon ngang iniking kapae yotnane yukut. ");
INSERT INTO wnc_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Yuwawan maya tapatu wel gwendu manina buyambam sikngata usikuu botonu gomdu supda tasikwaapa kuku gomdusipatang tukngwamban pukuku tekngatusim takapbut. Takapuke Jesuta nanamu atnayuwawan gwapakngane wel yangga wa tukngwangamukut. ");
INSERT INTO wnc_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Tukngwangaman kake ninu pandetnata musipminu toknga natake nisa anzing yakumang, “Dasingge wel yangga wagwenu moo siknga tukngwanggak? ");
INSERT INTO wnc_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Wel yangga wagwenu yamuna kunduta usiwa manina buyambam siknga pake sangana wena aminde yamunanga,” ngang yakumang. ");
INSERT INTO wnc_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Unzing yana Jesuta anzing ninikut, “Dasingge ginda maya waapae meya imukaing? Ita sanga take sikngaaknga tasingamunggak. ");
INSERT INTO wnc_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Sike sangaapana wena aminu gikat gatake yutning. Tapdukbamu ginda gatayamunanggengu take tasining. Ngana na, gikat gatake asinggan dua yutnim. ");
INSERT INTO wnc_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Mayata wel yangga gupmane tukngwanggau ita sanga wa tasinggau matmat katang pukuwitde tandaknganggak. ");
INSERT INTO wnc_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nata siakande siknga daninggat. Keu kuupbam natane wama take waaknga ngang yakapning komune sanga maya aapata tasingamunggak kakngae kuut yakapa ie kuut natanggamataning,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Siwan tapduu waomune pandetna 12-pat nana tapatu umana Judas, Iskeriot yot gapmane nanaapa. Ita Anutue yot takwan gwene pasiya amindane takeakwakge kuke anzing yanikut, ");
INSERT INTO wnc_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","“Ginda mani datdasing nae nama nata nina aminu waapa ginde katakzane yeutdamit,” ngang yaniwan mani silwa sasan 30 ngang kendeke imuking. ");
INSERT INTO wnc_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ima pake tapduu waomune tuwanguke tapduknga Jesu wa aminde kataune yeuyamik gwen kanangge tasikut. ");
INSERT INTO wnc_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Siwan tapduk takwanu wagwene sanga poyakat sawa paptakaingu teke poyau moo sake nake yukinggane gunziu tupan gwene ninu pandetnata kuku Jesue anzing inikumang, “Gata ninu Pasova tapduk gwende nanamu zane tandakngana nanim,” ngang inikwaitna ");
INSERT INTO wnc_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","yake anzing ninikut, “Ginda yot Jerusalem gapmane koke aminu tapatue kuke anzing ininong, ‘Ayanindamumsa apata anzing yak. Natane tapduknga akupitde dapaknga gwa singgak. Naat pandetnaatda Pasova tapduk gwende nanamu gatane yotdane nanim ngang yak,’ ngang ininong.” ");
INSERT INTO wnc_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Siwan Jesuta ninikut taknga tasike Pasova tapduk gwende nanamu tandakngakumang. ");
INSERT INTO wnc_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Siwan bangee nanam nanangge natake iat pandetna katau kuut musa gatu kepianganu tapaaya ngangga apukwikumang. ");
INSERT INTO wnc_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Pukwike atnayuwatna anzing ninikut, “Nata siakande siknga daninggat. Gikatnana tapatuta na natane iwanae yeuyamik,” ngang niniwan ");
INSERT INTO wnc_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","musipminu meya siknga natake tapatu tapatuta inandek inandek inikwaikumang, “Buyambamtapa. Na ba dasing,” ngang inina ");
INSERT INTO wnc_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","yake anzing ninikut, “Aminu waapa dopang gwekatangu katakngiu kuutda wasikamak kapata na yeuyamik. ");
INSERT INTO wnc_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ngan, na aminbamde notnaapae Anututane wapatang matakut takngakan singamik. Ngana aminu ayeuyamik kapata toknga apapik. Mingata dua bokngikut gamu take siwan,” ngang yawan ");
INSERT INTO wnc_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judas ayeuyamik kapata yake anzing inikut, “Aana. Na ba dasing,” ngang iniwan yake inikut, “Gika unin yanggayak,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Siwan atnayuwatna Jesuta poyak pake Anutu inimbakngake apuke pandetnae nimuke anzing ninikut, “Ginda pake nanong. A natane gupma,” ngang ninikut. ");
INSERT INTO wnc_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Niniwan pake poyau wa nana puyuwana kap wainu gomdu take Anutu inimbakngakenga nimuke anzing ninikut, “Ginu kuupbamda anggomune tangopnong. ");
INSERT INTO wnc_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Sanga wa natane daknga. Nata kungwake daknga tungwaba Anututa wamu kwikwiknga kayuk kaknga yawan kekekawik. Nata kungwake daknga tukngwaba Anututa banip zikaa akngana tapan tekwamban aminbamdane waiakngana sandeyamikge tukngwambit. ");
INSERT INTO wnc_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Daniwa natapnong. Apman gatu masan ngangu wain yangga aknga dua tangoke yusika kuku tapduknga Anututa amin panangge tasinggak kaknga buya aawik gwene gikat gatake wain yangga kayuk kaknga tangopit,” ngang niniwan tangoke ");
INSERT INTO wnc_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","kau takngatu taikenga epu kepman kuke tawanu Oliv dakane kopbumang. ");
INSERT INTO wnc_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Siwan koyuk anzing ninikut, “Anututane wapatang anzing matakut, ‘Nata aminu sipsipde toiknga tanguwa kupan sipsipnata unda undang datakuning ngang matakuu zikaa anggwene buya unin asaawik. Aminda na nuwa kake ginda nae natapa kekekakut takngata apimapik.’ ");
INSERT INTO wnc_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Nuwa kungwake yusika gatu gweake nata gamok ginde Galili kuwit,” ngang niniwan ");
INSERT INTO wnc_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pitata yake anzing inikut, “Guwa kupi ganduke kuupbamda pimatning ngana na unzing dua pimapit,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Iniwan yake anzing inikut, “Nata siakande siknga ganinggat. Zikaa anggwene taakga wamu dua yawawan gata natane umana sipmaat sipduat takusopuwiyak,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Iniwan yake anzing inikut, “Nata gaat kuut nisipa kumzimde yawanu nata gatane umanda dua takusopuwit. Wena siknga,” ngang yawan pandetna kuupbamda unzakan yakumang. ");
INSERT INTO wnc_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Siwan Jesuat ninu pandetnaatda keu Getsemani ngang inikaing komune kukumang. Kukenga pandetna anzing ninikut, “Ginu ane pukwike yuwawa nata atune kuke tumuk wam yawit,” ngang ninike ");
INSERT INTO wnc_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Pitaat gatu Sebeditane waakngaapaat ngang papan kuking. Kundusim kuke meya siknga natake ");
INSERT INTO wnc_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","anzing yanikut, “Nata meya siknga natake akupanu take sinanga,” ngang yanikut. “Na kuke tumuk wam iniwawa ginu ane yuke gikaya kayuk yutnong,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Yanikenga kundusim kuke nomda pimake tumuk wamu anzing yakut, “O Nana! Take siwanu meya wa kawit taknga sandekngamuyo. Ngana gata nae banip ma tawambim. Aho. Gata gikae banip tawamso,” ngang yakut. ");
INSERT INTO wnc_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Yekenga pandetnae gatu apuke kawan dapuna pekgawa kakut. Kake Pita anzing inikut, “Dasing? Nata yuwawa gikaya kundusim kayuk yutnanga dua ba dasing? ");
INSERT INTO wnc_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ginda kayuk yuke tumuk wam yanong. Sanga gin pasiwa sinangata ginde apsak. Siakan. Banipzaatang kayuk yutnangge nataaing ngana ginda tuyuknga natake pekaing,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yanikenga gatu kuke tumuk wamu anzing yakut, “Nana. Meya wa kawit taknga napbitnanga dua siwanu nata akawit. Gikae banipban tawamso,” ngang yake ");
INSERT INTO wnc_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","gatu apuke kawan dapunae siwan kai tuyuknga siwa apekgawa kakut. ");
INSERT INTO wnc_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Kake gatu peke kuke tumuk wamu sipduat yawan sipmaat sipduat dakngakut. Tumuk wamu tupan yakut takngakan yakut. ");
INSERT INTO wnc_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Siwan masande gatu apuke pandetna anzing yanikut, “Ginu gatu gatu danit ngana dapunza asinggan peke yuwatakakaing ba dasing? Natapnong! Tapduknga na aminbamde notna dakngake yuat tapa wai aminde katakngane yeuyamuningge gwa singgak. ");
INSERT INTO wnc_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ginu enawa kuna. Kanong! Aminu ayeuyamik kapata gwa apunggak,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Siwan Jesuta wamu waaknga ayayuwawan pandetna 12-pat nana tapatu umana Judas. Iat aminbampat gatake apuke paip gatu zagwa ngang pake apbing. Anutue yot takwan gwene pasiya amindane takeakwakat gatu Judia amindane take amikatda yanipewa apbing. ");
INSERT INTO wnc_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Siwan aminu ayeuyamunanga apata tuwangu takngatu wa aminde tupa yamuke anzing yakut, “Nata aminu asinimbakngawit tapa Jesu unin. Ginda waapa atanggaganutnong,” ngang yakut taknga tasinangge natake ");
INSERT INTO wnc_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","zetgaman Jesue apuke anzing yakut, “Zikaane Aana,” ngang inimbakngakut. ");
INSERT INTO wnc_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Inimbakngawan Jesuta anzing inikut, “Notna. Sanga tasinangge natake apuyau zetgaman tasiyo,” ngang iniwan wa aminu inengan apu Jesu katakngita take tanggaganuking. ");
INSERT INTO wnc_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Tanggaganuwa aminu Jesuat yukumakatnana tapatuta paipna kaitakakoke Anutue yot takwan gwene pasiya aminde tupan tapatane puya amina maaknga patdewan pimapan ");
INSERT INTO wnc_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","kake Jesuta anzing inikut, “Paipba tangine teyo. Aminu kuupbamda paipda amningu paipde akumning. ");
INSERT INTO wnc_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ga dua ba nataayak? Nata Nanae iniwa angela buyambam siknga 72,000 zetgaman yanipewan apu gatangamuning ngang dua natake paipbata amnangge tasinggayak ba dasing? ");
INSERT INTO wnc_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Sike ngana nata angelae iniwa apu gatangamanu Anutue wamu nata kupitde mataking kaknga buyana dasing aawik? Wena,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Inikenga aminbamu anzing yanikut, “Ginu na tanangge apuke paip gatu zagwa ngang pake ginda kuka aminu tapatu wamnangge apukaing ba dasing? Tapduk bamu nata Anututane yot takwan gwene yuke aminbam yanindamuba nanduke ngana ginda na dua tanggaganukaing. ");
INSERT INTO wnc_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ngana ayanikapsa aminda tupa siknga ngang yakapbingu buyana asaawik. Unzingge sanga wa kuupbamu apunggak,” ngang yanikut. Yaniwana pandetna kuupbamda Jesu ateke datakukumang. ");
INSERT INTO wnc_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Sike aminu Jesu tanggaganukingga take Anutue yot takwan gwene pasiya amindane tupantapa umana Kaiafas. Itane yotnane takuking. Siwan mama wam yanindamumsa amikat gatu Judia amindane take amikau pauu atasike yuwawa undang takuwawa ");
INSERT INTO wnc_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pitata masa masa kuyawakut. Kuyawake kuku Anutue yot takwan gwene pasiya aminde tupan tapatane yot daman gwene kopan taukdapakat yuking. Siwan Jesue dasingga tasingamuning ngang natake ita kayukut. ");
INSERT INTO wnc_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Siwan Anutue yot takwan gwene pasiya amindane takeakwakat gatu sios kaunsil amikatda aminu Jesue kem wam yawat tanguwa kupikapaande yawaking. ");
INSERT INTO wnc_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Yawawawa aminbamda apuke temanggagunuke yake wamu inata yawa atangutningge wamu buya kundukan dua siwan masande aminu tapaayata apbumayak. ");
INSERT INTO wnc_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Apuke waapaatda wamu takngatukan anzing yakumayak, “Aminu aapata anzing yawan kakumak, ‘Nata Anututane yot takwan gwenu waike tapduu gweaat gwenduatdekan gatuna mitapit,’ ngang yawan kakumak,” ngang yakumayak. ");
INSERT INTO wnc_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Yawat natake Anututane yot takwan gwene pasiya amindane tupan tapata enake Jesu anzing inikut, “Gata wamu takngatu yake yananga dua ba dasing? Dasingge wamu waaknga gae yakamayak,” ngang iniwan ");
INSERT INTO wnc_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","ngana wamu dua yakut. Yake dua iniwan kake tupan aminu waapata anzing inikut, “Nata siakande siknga Anutu kayuk yuak kapae umande ganikwaiwa gata asiknga ngang niniyo! Ga Anututa tapan Kraistapa dakngake Anututane waaknga yuayak ngang kakengu gata niniwi natapnim,” ngang iniwan ");
INSERT INTO wnc_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","yake anzing inikut, “Gika gwa yanggayak. Ngana nata daninggat. Apman gatu masan ngang ginda nanduwawa na aminbamde notna dakngake yuat tapata Anutue kataknga siyaapa kekeknga kuupbamu kayaapane yuke minga musane yuke asepuwawa nandupning,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Unzing iniwan natake tupan aminu waapata bania toknga siknga natake tauknga wetzukuke anzing yakut, “Ita Anutune umana akngana yaitapaakusinggak. Ninda ie wam yakapningge aminu kunduat dua yayawanim. Wena. Ita Anutue umana akngana gwa yaitapaakusiwan nataamang. ");
INSERT INTO wnc_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ginu wamu wa usanzike dasing nataaing,” ngang yawan yake, “Ita akumnanga aknga yanggak,” ngang yaking. ");
INSERT INTO wnc_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Yake aapda Jesue nomna suyapbike atanguking. Siwan kunduta aamna wesike ");
INSERT INTO wnc_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","anzing iniking, “Ga Anututa tapan Krais dakngake ayanikapsa apa yuayaknga kakengu mamin amin tapata gukgakge umana yayo,” ngang iniking. ");
INSERT INTO wnc_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Siwan Pitata kepman yuke yot daman gwene pukwiwawan puya aminu maya tapatuta kuku anzing inikut, “Gakaya Jesu Galili kep komune nanaapaat yuaing,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Iniwan ngana Pitata tawak yake aminu kuupbamde kaine anzing yakut, “Na wamu gata wa yanggayak kaknga dua nataat,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Inike yusika kepman paku damandane gwabok gwaune kepman kuke yuawan maya tapatuta kake aminu inengan yukingu anzing yanikut, “Aminu aapa Jesu Nasaret yot gapmane nana apaat yuaing,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Yaniwan natake Pitata gatu siakan siknga ngang tawak wam yake, “Na aminu aapae dua nataat,” ngang yakut. ");
INSERT INTO wnc_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Siwan masande kundusim yuke kuku aminu kunduta Pita anzing iniking, “Siakande siknga. Aminu gaapa dongu waakwakatnana. Gatane wamba yawi natapna guyakga Galili nanaapata yanggayak ngang nataamang,” ngang iniwa ");
INSERT INTO wnc_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","apaa siknga anzing yakut, “Siakande dua daniwa Anututa tokngabam atnamanu noman siwik. Na aminu waapae dua nataat. Wena siknga,” ngang yawana taakga wamu yakut. ");
INSERT INTO wnc_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Yawan Pitata wamu tupa Jesuta inikut takngae anzing natdekut. Taakga wamu dua yawawan gata sipmaat sipduat nae dua nataat ngang yaya ngang inikut takngae natdeke epu kepman kuke kwanamu kumzang sikut. ");
INSERT INTO wnc_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Siwan akwakawan Anutue yot takwan gwene pasiya amindane takeakwau kuupbapat gatu Judia amindane takeakwakatda Jesu tanguwa kupikge wamu yaking. ");
INSERT INTO wnc_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Yake napda wamake taku aminu tupantapa Pailatde imuking. ");
INSERT INTO wnc_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Siwan Judas Jesu yeuyamukuu waapata kawawan Jesue wam yaitapakusike tokngabam imuke tasiwawa kakut. Tasiwawa kake butaya natake mani 30 silwa pakuu gatuna Anutue yot takwan gwene pasiya amindane takeakwakat gatu Judia amindane take amikatde yamunangge ");
INSERT INTO wnc_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","pakuke anzing yanikut, “Nata waiaknga tasikum. Nata aminu gutongana wenaapa yeutdamukumde ita kupik,” ngang yaniwan ngana yake anzing iniking, “Ninde sanga dua. Gikae sanga,” ngang iniwa natake ");
INSERT INTO wnc_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","mani wa Anututane yot takwan gwene mupewan kuwa kuke nap wasinangge kukut. ");
INSERT INTO wnc_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Kuwawan mani wa pake anzing yaking, “Mani a amin tangutna kupikgane pake miti yotde maniat undanggan pena take dua siwik,” ngang yaking. ");
INSERT INTO wnc_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Yake paut tasike wamu takngatu yawa kekekawan mani wa pake keu gapma pasikaingu komdu yotna maa nana aminde matmatnae usiking. ");
INSERT INTO wnc_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Unzingge keu waomu umana Akeldama tana tekwamban dak tukngwambikge mani imukingga keu usiking kom ngang inikingu apman kaya asinikamang. ");
INSERT INTO wnc_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Sanga unzingu wa sikut takngae ayanikapsaapa Jeremaiata Anututane wamu takngatu yake tupa siknga anzing yakut, “Isrel nana kunduta aminu waapa tanggaganutnangge natake, ‘Mani silwa 30 ngang gamuna ninde yeutnimuyo,’ ngang yake imukingu pake ");
INSERT INTO wnc_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Anututa nanikut takngakan tasike keu gapma pasikaingu komdu usiking,” ngang Jeremaiata yakut taknga buya unin aakut. ");
INSERT INTO wnc_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Siwan Jesu aminu tupan tapae kaine tewa yuwan anzing inikwaikut, “Ga Judia amindane buyambamtapa ba dasing,” ngang inikwaiwan, “Gika unzing unin yanggayak,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Inike yuwawan Anutue yot takwan gwene puya pasiya amindane takeakwakat gatu Judia amindane take amikatda kem wamu ie yawawa ngana wamu takngatu yake dua yaniwan ");
INSERT INTO wnc_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","kake Pailatda anzing inikut, “Gata wambamu gae wa yakaingu dua natayak ba dasing,” ngang iniwan ");
INSERT INTO wnc_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","ngana wamu takngatu Pailatde yake dua inikut. Dua iniwan kake nangaakan natapbut. ");
INSERT INTO wnc_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Sike nakanu kuupbam tapduk takwanu wa binga gwene aminu tupan tapata kaaut aminu tapatu asandetewan kunggak. Aminbamda aminu tapatu sandetewan kuwikge umana yawanu Pailatda aminu waapakan sandetewan kunggak. ");
INSERT INTO wnc_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Siwan tapduu waomune aminu wai siknga tapatu umana Barabas ngang iniking kapata kaautde yukut. ");
INSERT INTO wnc_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Siwan ie natake aminbamda unekan pakapu yuwana Pailatda anzing yanikut, “Ginu nata mamin sandetewa kuwikge nataaing? Nata Barabas sandewit ba Jesu umana Krais ngang inikaing kapanin sandetewa kuwik ba dasing,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Sike Pailatda natapan Jesue semna natangamuke wamu ita yawikge takapuing ngang anggaman natake wamu waaknga ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Yanike wam yake usanziya komune yuwawan maatnata wamu takngatu anzing tewan apbut, “Gata sanga takngatu amin nomanu waapae ma tasiwim. Zikaane mia aminu waapae kake meya siknga natat,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Siwan Anutue yot takwan gwene puya pasiya amindane takeakwakat gatu Judia amindane take amikatda aminbam yanindatdaukgawa yanggamatake Pailatda Barabas sandetewan kuwan Jesu tanguwa kupikge iniking. ");
INSERT INTO wnc_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Iniwa natake gatuna anzing yanikut, “Aminu ayuamayak kapaakatnana mamin tapa sandetewa kuwikge nataaing,” ngang yaniwan yake, “Barabas,” ngang yaking. ");
INSERT INTO wnc_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Yawa yake anzing yanikut, “Waapa sandetewa kuwanu Jesu umana Krais ngang inikaing kapae nata dasing tasiwit,” ngang yaniwan kuupbamda anzing yaking, “Amin saamdakane tanguyo,” ngang yawa ");
INSERT INTO wnc_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pailatda anzing yakut, “Dasingge? Ita gutonga dasing kaknga tasikut,” ngang yaniwan ngana apaya siknga yanggamatake, “Amin saamdakane tanguyo,” ngang yaking. ");
INSERT INTO wnc_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Siwan Pailatda kawawan itane wamu take dua siwan amau buyambamda enatnangge siwan kake yangga kundu pake aminu waakwakge kaine tuwangu takngatu tasinangge natake kataknga sauke anzing yakut, “Na ie dau wena. Gisae sanga,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Yaniwan kuupbamda yake anzing iniking, “Ie dau nisae gatu nindane waaknginkatde apik,” ngang iniking. ");
INSERT INTO wnc_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Iniwa natake Pailatda Barabas sandetewan kuwan amina yaniwan Jesu ipmapa tanguke amak aminde kataune amin saamdakane tangutningge yaman taking. ");
INSERT INTO wnc_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Siwan Pailatdane amak aminu kunduta Jesu Pailatde yotnane takoke amak aminu waakwakatnana kuupbamda ie kuke doke yuking. ");
INSERT INTO wnc_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Siwan itane tauknga sandeke tauu gamana sandu buyambam tapatane binga tasingamuking. ");
INSERT INTO wnc_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Tasingamuke nau bombingga gwasike gwapakngane kupnae buyambam tapatane binga gwapungamuking. Gwapungamuke pitamu tapatu kataknga siapane iman buyambam tapata binga take yuwawan inengan kuku muna puke ie sapdut wamu anzing iniking, “Judia amindane buyambamtapa! Gata asinggan asinggan yuyo,” ngang inike ");
INSERT INTO wnc_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","aapda suyapbike pitamu wa iman takut tapa take gwapakngiatang tanguking. ");
INSERT INTO wnc_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Siwan sapdut wamu wa iniwa puyuwana tauknga wa sanu sandeke inane tauknga gatu pasingamuke take amin saamdakane tangutnangge takuking. ");
INSERT INTO wnc_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Siwan take kusika aminu Sairini yot gapmanenana tapatu itane umana Saimon ngang iniking kapata apan iniyapike Jesutane amin saamdaka ima gwaamutake kukut. ");
INSERT INTO wnc_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Siwan keu komdu umana Golgota ngang inikaing. Sike tana tekwamban anzing yanim. Gapak gwikgwit kep ngang yanim. ");
INSERT INTO wnc_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Sike keu wakomune kundoke wainu kundu marasinu kaknga kunduat tasikingu Jesue iman tangopan gupna bakawan toknga siknga dua natapikge iman tangopan siwan dua tangopbut. ");
INSERT INTO wnc_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Siwan amin saamdakane tangukenga kat binga tasike itane tauknga usanzike panangge tasiking. ");
INSERT INTO wnc_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Tasike usanzike pakenga pukwike ie kayuking. ");
INSERT INTO wnc_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Sike wamu tangutningge yawa kekekakut taknga matake amin saamdaka nomnane tuptake wamu waaknga tanguking. Anzing mataking, “Aminu aapa Jesu Judia amindane buyambamtapa,” ngang mataking. ");
INSERT INTO wnc_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Sike Jesu tangukingune wesim kuka aminu tapaat kuut zipbing. Tapatu siyaapa saak tanguke tapatu kwanaapa saak tanguking. ");
INSERT INTO wnc_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Siwan aminda kungapuyuk kake gwapakngi makaike ie sapdut wamu anzing iniking, ");
INSERT INTO wnc_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Aminu gaapa Anututane yot takwan waike tapduu gweaat gwenduatdekan mitanggaunin. Gika gatanggamuyok! Sike ga Anututane waaknga kakengu amin saamdaka take ep,” ngang iniking. ");
INSERT INTO wnc_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Iniwa Anutue yot takwan gwene pasiya amindane takeakwakat gatu mama wam yanindamumsa amikat gatu Judia amindane take amikatda sapdut wamu anzing yaking, ");
INSERT INTO wnc_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ita aminu kundu akgatayamukut ngana inae gatangamunanga dua,” ngang yake tapatekwa wamu takngatu anzing yaking, “Ita ninu Isrel amindane buyambam tapata yuak. Ayok. Ita amin saamdaka teke epana ninu ie natapna kekekawik. ");
INSERT INTO wnc_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ita Anutue natapan kekekawan, ‘Na Anutue waak,’ ngang yakut. Ayok. Anututa ie take natakengu apman gatangaman epan,” ngang yaking. ");
INSERT INTO wnc_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Yawa aminu zipmake sangana kukae panangge tasikumayak kapaau Jesuat wesim zipbing tapaatdaaya kuut sapdut wamu waakngakan yakumayak. ");
INSERT INTO wnc_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Sike kepmaom zikaa keu kuupbam sike kuku bangee siwan ");
INSERT INTO wnc_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Jesuta inae wam tangan apaa anzing yakut, “Ilai, Ilai, lema sabaktani,” ngang yakuu tana tekwamban, “Anutuna! Anutuna! Dasingge gata na napmambi yuat,” ngang yakut. ");
INSERT INTO wnc_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Yawan ngana aminu kundu inengan yukingu wamu waaknga natake anzing yaking, “Aminu aapa Ilaija tupa siknga nana yanikapsa apae yatawanggak,” ngang yaking. ");
INSERT INTO wnc_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Siwan zetgaman aminu wa yukikat nana tapatuta isapmake kuku yanggabam gwenenana misa papaanga kaya wangatu take takapu wain yangga kapanga sikut takngane tewan bukatawan wa pitamu tapatune ukgouke Jesuta atangopikge imukut. ");
INSERT INTO wnc_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Iman ngana kunduta, “Teng,” ngang inike, “Kayutna siwik. Ilaijata apu apmeba gatangamik ba dasing,” ngang yaking. ");
INSERT INTO wnc_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Siwan Jesuta gatuna wamu apaa yake weenata asakowan akumbut. ");
INSERT INTO wnc_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Siwan tapduu waomunekan tauu Anututane yot takwan gwene mitapa pimakut sanu enaneta wesiwan amunane epu dewan saaya dakngawan miyamun siwan suu buyambamu atapa ");
INSERT INTO wnc_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","kepda pukapa matmat gapma gapma kwangga yuwawa Anututane aminabamu tupa gwa kumbingu asenaking. ");
INSERT INTO wnc_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Asenake masande Jesuta gatu enawana matmat gapma gapma peke Jerusalem gapmane koke anggaman siwa aminbamda kaking. ");
INSERT INTO wnc_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Siwan amak aminu tupan tapaat iat gatake yukikatda Jesue kayuke kawawa miyamun siwan kawawa sangabamu siwan kumzang siknga gwauke anzing yaking, “Siakande siknga! Aminu aapa Anututane waaknga,” ngang yaking. ");
INSERT INTO wnc_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Sike maya buyambamda Jesuta dua kumbut gwene i tawake keu Galili komu teke i gatangamunangge apbingu wesim wesim yuke katasiking. ");
INSERT INTO wnc_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Sike maya waakwau yukikat nana tapatu umana Maria Magdala yot gapmane nanaapa. Siwan tapatu Maria Jemskat Josepatdane minga. Siwan tapatu Sebeditane waakngaapatdane minga ngangga katasike yuking. ");
INSERT INTO wnc_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Siwan bangee aminu tapatu buyana babantapa umana Josep. Arimatia yot gapmane nanaapata Jesutane pandetna apata ");
INSERT INTO wnc_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Pailatde kuku inikwaike Jesutane gupnasan tanangge inikut. Iniwan natake Pailatda amina yaniwan Jesutane gupnasan ie imuking. ");
INSERT INTO wnc_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Siwan Josepda gupna take tauu kwaknga dudumna siknga sanda tapan kopan ");
INSERT INTO wnc_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","matmat inane kayuu supgapbau suu buyambam dakaatang tasikut dakane teke suu buyambamu gwendu ikomban apu supgapbatde gwabokgwak umukusiwan akukut. ");
INSERT INTO wnc_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Unzing tasiwawan maya tapaaya Maria Magdala nanaapaat gatu itane tangeatda supgapbaune wesim pukwike kayukumayak. ");
INSERT INTO wnc_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Sike kwep tapduknga yuwatakak gwendane sanga gwa tandakngaking gwekatangu Anutue yot takwan gwene pasiya amindane takeakwakat gatu Ferisi amikatda Pailatde kundoke ");
INSERT INTO wnc_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","anzing iniking, “Buyambamtapa. Ninda wamu takngatu kem aminu waapata kayuk yuke yakut takngae natanggamatakamang kaknga ngang ganinim. Ita anzing yakut, ‘Tapduu gweaat gwenduat yukenga na gatuna enawit,’ ngang yakut. ");
INSERT INTO wnc_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Unzingge gata yawi matmat gwene yuke katak siknga tapduu gweaat gwenduat kayutnong. Pandetnata apu gupnasanu kukae take aminbamu anzing yanining. Ita matmat gapmaneta gatu enak ngang yaninang. Kemu masan nana akngata kemu tupan nana aknga yapbimsak,” ngang iniking. ");
INSERT INTO wnc_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Iniwa yake anzing yanikut, “Ginda aminu akayutnanga kundu pake yanipewa kuke katak siknga matmat gapma kayutnong,” ngang yaniwan ");
INSERT INTO wnc_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","kuke matmat gapmane tuwangu sup gwene pasap tasike amak aminu kundu akayutningge peking. ");
INSERT INTO wnc_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Siwan yuwatakak tapduk gwenu gwa sandewan kepda kwakawana sande tembana siknga Maria Magdala yot gapmane nanaapaat gatu itane tangenaatda enake matmat supgapbat kom kanangge kukumayak. ");
INSERT INTO wnc_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Kuwawat ngana miyamunu buyambam siwan Anututane angelata enane sikngaatangga epu sup gwen ikotakweke wagwene engatangan pukwikut. ");
INSERT INTO wnc_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Pukwike yuwawan nomna yapasik binga waenga siknga siwan tauknga kwaknga siknga sikut. ");
INSERT INTO wnc_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Siwan amak aminu akayuking aminda kagwauke dandai kumzang yamuba kupsa amin binga dakngaking. ");
INSERT INTO wnc_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Dakngake yuwawa maya waapaatda apat angelata anzing yanikut, “Ma gwaubat. Jesu amin saamdakane tanguwa kumbut tapae apukamayak ngang danduat. ");
INSERT INTO wnc_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Waapata andang dua. Kungwake gatuna gweawit ngang yakut takngakan gwa gweak. Apu ita yukut komu kason. ");
INSERT INTO wnc_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Kake zetzet kuku kumbut katangga gweake ita gamok kuke Galili kep komune kunggak. Undang kuke kanong ngang pandetna yanison. Unukan,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Yaniwan natake kumzang gwauke zetgaman matmat wagwenu teke ngana baniaatang apbakngayuk pandetna nininangge isapmake apbumayak. ");
INSERT INTO wnc_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Isapmake apuwawat Jesuta wesim apu gaak wam yanikut. Gaak wam yaniwan natake waapaatda Jesue kepine katakngata take inimbakngakumayak. ");
INSERT INTO wnc_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Siwan Jesuta, “Ma gwaubat,” ngang yanikut. “Kuku Galili kep komune kuke undang nandupnong ngang notna yanison,” ngang yaniwan natapbumayak. ");
INSERT INTO wnc_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Siwan maya wa tapaau akuwawat amak aminu kundu matmat gwene kayukingu gatuna yot gapmane kuke Anutue yot takwan gwene pasikaing amindane takeakwau sangabamu matmat gwene kakingge yaniking. ");
INSERT INTO wnc_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Yaniwa natake aminu waakwakat gatu Judia amindane take amikatda paut tasike wamu takngatu yaking. Yake mani buyambam amak aminde yamuke ");
INSERT INTO wnc_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","anzing yaniking, “Ginda mani wa pake anzing yanong, ‘Pandetnata zikaane apuke ninu apewatna gupna gwa takuing,’ ngang yanong. ");
INSERT INTO wnc_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Sike aminu tupan tapata wamu waaknga natapanu ninda wamu kunduat apme inina ginu meyasa wena siwik,” ngang yaniking. ");
INSERT INTO wnc_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Unzingge amak aminu mani wa pake wamu waakngakan Judia aminde yatakuking. Yatakuke wamu waaknga yanggawa kekekawan apu apmanu kuut ayuak. ");
INSERT INTO wnc_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Siwan ninu pandetna aminu katau kuut musaat kepianganu tapatuatda Galili kep komune kuke tawanu Jesuta tupa ninikut dakane kopbumang. ");
INSERT INTO wnc_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Koke undang Jesu kake inimbakngake ngana nikatnana kunduta baniaatang natapa siakan dua sikut. ");
INSERT INTO wnc_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Siwan Jesuta apuke wamu takngatu anzing ninikut, “Anututa kekeknga kuupbam nae gwa naman enandang yuaikat keune nanaatde takeapa dakngake yuke daniwa natapnong. ");
INSERT INTO wnc_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ginu kepna kepna kuwa sandewan unenana yaniwa natake banip sike natane pandetna daknganong. Pandetna dakngawana Nanaat na itane waakngaat gatu Anututane Waung Takwan tapaatde umaninde yangga sauyamuke ");
INSERT INTO wnc_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","nata wamu gwan danindamukum taknga kuupbam natake tasiningge yanindamutnong. Siwan unzing tasiyuk naat gikat gatake asinggan asinggan yuwatna kuku tapduk ayuamang gwenu sandewik kopatang unekan yutnim,” ngang Jesuta ninikut. ");
INSERT INTO wnc_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jesu Krais Anututane waakngaapata yake tasikutde wamu takeaknga anzing. ");
INSERT INTO wnc_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Anutue wamu ayanikapsa apata yake ita apuke yake tasiwik ngang tupa siknga matakut taknga Jesuta unin apuke yake tasiwan buya unin aakut. Aisaiata anzing matakut, “Natapnong. Nata aminu nae wama takuwikge iniwa ita gae gamok tupan kuke gatane kepika tandakngawik. ");
INSERT INTO wnc_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Aminu tapatu keu amina wena komune yuke anzing yanggamatanggak, ‘Buyambam tapata apnangge yawan kepina tandakngakamang binga Anututa initewan apik kapae natake tandaknganong,’ ngang yanggamatanggak,” ngang Aisaiata matakut. ");
INSERT INTO wnc_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Wamu wa matakut takngatane buyana unin. Jonu yangga sauyamuyaapa dakngake keu amina wena komune yukut. Yuke wamu aminu musia tapan tekwamban yangga sauyamikge yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Siwan Judia kep komune nana kuupbam gatu Jerusalem yot gapmane nana kuut Jonde kuking. Kuke waiakngana yakapa Jonda yangga Jodan tapane sauyamukut. ");
INSERT INTO wnc_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Siwan Jonu tauknga kaap gwendu kamel ngang inikainggane danggamita tasikingunin tasikut. Siwan ita simbuna goyanga gwene wambut. Siwan ita apmakat gatu iningokat nakut. ");
INSERT INTO wnc_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Siwan ita wamu anzing yakapbut, “Apmanu nata gamok enake puya aaknga tasiwawa masande aminu tapatuta enake puya tasiwik. Sike aminu waapatane kekeknga akngata na atnapbikut. Unzing siwan na aminu umana wenaapa yuatde gwetake gatanggamuke kepi taukga sandekgama ngang ininangge apmaakanggat. ");
INSERT INTO wnc_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nata yanggatakan sautdamunggat. Ngana ita initewan Anututane Waung Takwan tapata apu kekeknga akngana daman katapda isinggak kaknga binga musipza enawik,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Siwan tapduu wagwene Jesuta Nasaret gapma Galili kep komune yuwau teke Jonda yukut komune kundopan Jonda yangga Jodan tapane saukngamukut. ");
INSERT INTO wnc_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Saukngamana zetgaman yangga teke akoke kawawan enandangu kakaa siwan Waungga kwaiu kombunanang ngang yanikamang gwenda binga epuke Jesue apu paku tangene pakuyuwan kakut. ");
INSERT INTO wnc_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Kawawan enandangga wamu takngatu anzing yakut, “Ga natane waaknga. Na gae take siknga natanggamuke na gae musip gwaang natanggamunggat,” ngang yakut. ");
INSERT INTO wnc_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Siwan zetgaman Waungga Jesu keu amina wena komune iniyapiban kukut. ");
INSERT INTO wnc_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Iniyapiban ita undang kuke kaap zokat tapduu 40 yuwawa Setenda inindatdauwana angelata apu gatangamuking. ");
INSERT INTO wnc_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Siwan Jonu tanggaganuke kaautde tewana Jesuta Galili kep komune kuke Anututane wamu takeaknga anzing yanikut, ");
INSERT INTO wnc_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Anututa sanga aawikge tapduknga tekut gwenu dapaknga gwa singgak. Siwan tapduknga Anututa amin panangge tasinggak kakngata apnangge dapaknga gwa singgak. Ginu musipza tapa tekwamban wamu take aakngae siakan ngang natapnong,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesuta yangga gapan Galili gwenu kwaimune kusika kawawan Saimonkat uyapna Endruatda asinggan pis kaike mani ita pakakumayak. Siwan yapapna yangga gapan katang mukgawat kakut. ");
INSERT INTO wnc_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Kake Jesuta aminu waapaau anzing yanikut, “Giu apu na nawambat nata danindamuba pis wa kaikamayak binga aminu papat natane pandetna daknganingge danindamumbit,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Yaniwan waapaau zetgaman yapapna peke kuku tawambat kuking. ");
INSERT INTO wnc_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Siwan ita gatu kundusim kusika kawawan Sebeditane waaknga Jemskat gatu uyapna Jonkatda dopangbam gwene yuke yapapna paibupmake yuwawat kakut. ");
INSERT INTO wnc_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Kake waapaat yayawamban nanaat puya aminaatda dopangbam gwene yuwawa undang peke waapaau kuwat Jesuta tupan pakut tapaakat unekan gatake Jesuat kuking. ");
INSERT INTO wnc_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Siwan yot Kapaneam gapmane kuking. Siwan ita yuwatakak tapduk gwene miti yot katang koke wam yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Yanike Mosesdane mama wam yanindamumsa aminda binga dua yanikut. Aho. Ita aminu kekekngana kaya apata binga yaniwawan natake asiknga satnaking. ");
INSERT INTO wnc_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Siwan aminu tapatu waung wai tapatuta takut. Sike waapata miti yot katang yuke kumzang yanggamatake anzing yakut, ");
INSERT INTO wnc_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“A! Ga Jesu! Nasaret yot gapmane nanaapa! Ga ninde dasing tasinimunangge apunggayak ngang yanggamatake gata apu ninu apasiwi mainimde ba apunggayak? Nata gae Anututane aminu dudumnaapa ngangu gae atnataat,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Iniwan ngana Jesuta kaanga inike anzing yakut, “Ga genda umuke aminu waapa teke kung,” ngang iniwan ");
INSERT INTO wnc_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","waung wai waapata aminu waapa kumzang makaike ainggamatake aminu waapa tekut. ");
INSERT INTO wnc_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Teke kuwan kuupbamda kasatnake ina banakan anzing yaking, “Sanga a mina binga? Miti wamu kayuk kaknga yanggak. Wa kekekngana kaya. Ge ita waung waie wamu yaniwan ie gen gwaamukaing,” ngang yaking. ");
INSERT INTO wnc_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Unzingge ita tasikut takngae yake Galili keu kuupbam zetgaman yatakuking. ");
INSERT INTO wnc_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Siwan miti yot gwen teke epu kepman kuke gatu Jesuat pandetnaatda kuku Saimonkat gatu Endruatdane yotnane kopbing. Siwan Jemskat Jonkat kuut kopbing. ");
INSERT INTO wnc_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Siwan Saimonda maatnatane minga mait natapan gupna toknga siwan pekut. Siwan zetgaman ie Jesu iniking. ");
INSERT INTO wnc_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Iniwa ie kuke katakngine take tangenawan mait taknga tewan kuwan ita nanam tandakngayaman naking. ");
INSERT INTO wnc_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Siwan bangee gunziu apukuwan unenanata mait amikat gatu maya wawi waung waita pakingu kuut ie pakapbing. ");
INSERT INTO wnc_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Pakapuke you wanggapmane nana aminu kuupbamda gwabok gwaune wesim apundoke yuking. ");
INSERT INTO wnc_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yuwawa maya wawi kwaapzang maitna inata inata sikingu sandeyamuke waung wai kwaapzang yanikwasiwan kuking. Sike waung waita ie atnataing. Atnatake ie yanike Anututane kuwikngaapa ngang dua yaningge ayanindakngakut. ");
INSERT INTO wnc_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Siwan tembana siknga ngana dua kwakawan ita enake epu kepman kuke amina wena saau komduatang kuke tumuk wam yake yukut. ");
INSERT INTO wnc_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Yayuwawan Saimonkat notnabapat iat pekikatda enake Jesu kawa maiwan i tawaking. ");
INSERT INTO wnc_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Tawataku kakenga anzing iniking, “Aminu kuupbamda gae gawakaing,” ngang iniking. ");
INSERT INTO wnc_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Iniwa ita anzing yanikut, “Undanga. Ninda you wesim yuaingge kuna. Nata wa aminde kuut wam yaniwitde natake apbum,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Siwan iat pandetnaatda Galili keu kuupbam pasitakuke ita aminu kuupbam inane miti yotnane koke yanike waung wai yanikwasiwan kuwawa pasikut. ");
INSERT INTO wnc_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Siwan aminu tapatu watana kekeknga sikuu tapatuta ie apuke muna puke Jesu anzing inikut, “Gata take natakengu na tasingami gupma dudumna siwan,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Iniwan butaya siknga natangamuke katakngita wasiyuk anzing inikut, “Nata gatane gupba dudumna siwikge nataat,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ngang iniwan watana kekeknga wa zetgaman wena sikut. ");
INSERT INTO wnc_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Siwan Jesuta wamu kekeknga anzing inikut, ");
INSERT INTO wnc_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Katak siknga gwaumso. Gata kuke aminu tapatu sanga wa tasinggamunggatde ma iniwim. Ngana gatu aminu Anutue yot takwan gwene pasiya aminde kuke gupba yeuyamuyo. Yeuyamuke gupba take singgakge sangaka Anutue imuyo. Unzing Mosesde mama wamda tupa yakut taknga tasike sangaka imi ganduke wataka wena gwa sik ngang yawa aminbamda natapning,” ngang inike initewan kukut. ");
INSERT INTO wnc_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Kuke ngana wamu aminbamu gatu gatu yaniwan yotna yotna kuyuk wamu waaknga yatakuking. Yatakuwawa natake asinggan asinggan ie kuke doke umuba Jesuta you gapmandune anggaman kuwikge apmeptakut. Apmeptake keu amina wena komunekan yuwawan aminu kepna kepna nanata ie asinggan kuking. ");
INSERT INTO wnc_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Tapduu kundu kawa sandewana ita Kapaneam yot gapmane gatu kukut. Kuke yuwawan ie aminu notna kundue yoakatang yuak ngang natapbing. ");
INSERT INTO wnc_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Natake aminbamda kuke doke yuwa yot gwenu akgitnakut. Akgitnawan gwabok gwaune gitnagitnauke yuwawa Jesuta wamna yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Yaniyuwawan mait aminu tapatu kwatai gatukande gwa kumbing. Siwan aminu tapaat tapaatda gwaamutakapuke ");
INSERT INTO wnc_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","keu aminbamda umuke yuwawa Jesue wesim takapnanga dua sikut. Unzingge wa aminda yotangan dumtapane takoke dumu Jesuta yukut saak papa waiwa buka mait aminda pekut gwen buyak napda tatawaawa pukukut. ");
INSERT INTO wnc_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Siwan Jesuta apme maitna sandekngamik ngang natapa kekekakut taknga kake mait sikut tapa anzing inikut, “Waaknga. Nata waiakngaka gwa sandekgamunggat,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Iniwan ngana Mosesde mama wam yanindamumsa aminu kunduta apukwike yakingga musiaatang anzing natapbing, ");
INSERT INTO wnc_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Dasingge aminu aapata unzingu yanggak? Ita Anutue umana aknga tasiwan maiwikge yanggak. Aminu tapatuta waiaknga sandetnanga dua. Wa Anutu awiaapatane puyana,” ngang sapdukngamuke yaking. ");
INSERT INTO wnc_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Sike Jesuta natdetdetnaatang wamu wa natapbing kaknga natake anzing yanikut, “Dasingge ginu musipzaatangu natdetdeu waaknga nataaing? ");
INSERT INTO wnc_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","‘Waiakngana gwa sandekngamutde gatu maitna sandekngamuke gata enake gatane pimaka pake kunggayo,’ ngang iniwa ginda kake dasing natapning? Puya zaaknga kwanga siknga tasinanga,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","“Yanike na aminbamde notnaapa dakngake keune epu yuke amindane waiakngana sandeyamitde nanitewan apbum taknga nata take tasiwa ginda kake natdetningge tasiwa kanong,” ngang yanikut. Yanike aminu kwatai kumbing kapa anzing inikut, ");
INSERT INTO wnc_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Enake bek gwenu gika gwaamutake takungga,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Iniwan natake aminu kuupbamde kaine enake ita bek gwenu zetgaman take kuwawan aminbamda akasatnaking. Kasatnake Anutue umana yatangenake anzing yaking, “Tupa ninda sanga ambinga takngatu dua kakumang,” ngang yaking. ");
INSERT INTO wnc_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Siwan Jesuta gatuna yangga gapanu Galili gwene kuke yuwawan aminbamda ie upbaap kungapuwawa Anutue wam yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Siwan keu wakom teke ita kusika kawawan Liwai Alfiasdane waaknga takis papsa apata takis mani peainggane opis gwene pukwike pawawan kakut. Kake anzing inikut, “Ga pandetna dakngawiyakge apu nawamso,” ngang iniwan ita enake kuku tawakut. ");
INSERT INTO wnc_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Siwan masande Liwaita Jesuat pandetnaat yayawamban yotnane kopa yuke nanam naking. Siwan moo aminu kunduat gatu kait pasiyuk takis papsa amikat yanikwasiwa kepman yuaing amikatnana kunduta Jesu asinggan tawaking. Wa tawakikat nana kunduta iat pandetnaat gatake nanam nake yuking. ");
INSERT INTO wnc_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Unekan gatake yuke nanam nake yuwawa Judianana aminda miti wamu inata takngatu natake dongu takngaaya dakngake yukinggane dongu takngatu Ferisi ngang yanikikat nana kundu Mosesde mama wam yanindamumsa aminu kunduta kuku Jesutane pandetna anzing yaniking, “Dasingge Jesuta nanamu moo aminu kunduat gatu takis papsa amikat yanikwasitna kepman yuaing amikat gatake yuke nakaing,” ngang yanikwaiking. ");
INSERT INTO wnc_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yanikwaiwa Jesuta wamu waaknga natake tuwang wamu takngatu anzing yanikut, “Aminu maitna wenata doktae dua kukaing. Aho. Maitna kaya amindakan doktae kukaing. Sike tuwang wamu waakngatane yapii anzing. Nata apuke amin noman yuamang ngang yakaing amin yayawamba musia papa tekwambikge dua apbum. Aho. Nata apuke waiakngana kaya amin yayawamba apuke musia papa tekwambikge natake apbum,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Sike tapduu gwendune Jondane pandetnaat gatu Ferisi amikatda tapduknga kayane nanam teke Anutuekan natake tumuk wamban yake tasiking. Tasike yuwawa aminu kunduta kuku Jesu anzing iniking, “Dasingge Jondane pandetnaat gatu Ferisi amikatdane pandetnaatda tapduknga kayane nanam teke tumuk wam yake tasikaing ngana gatane pandetda nanamu asinggan nake tasikaing ngang,” iniking. ");
INSERT INTO wnc_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Iniwa yake tuwang wamu takngatu anzing yanikut, “Aminu kundutane notna tapatuta maatna tapik gwekatang wa tapik kapaat iat notnaat gatake yuke nanamu tenanga dua. Wena,” ngang yanikut. “Aminu maatna tanangaapa iat gatake yukengu nanamu dua teke yutning. ");
INSERT INTO wnc_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Sike ngana masande aminu maya tapiu waapa takuwa notna wa amikat dua gatake yukengu tapduu waomune wa aminu notnae musia meya natake nanam teke dua nake tomda yutning,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Siwan aminu tapatuta taau kayuk sanzim take tauknga bumi awesikuu ganangi dua bupik. Wena. Sike unzing tasiwanu tauu ganangi bupiu wa sanda goopan gatu awesiwan ganangi buyambam siwik,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","“Siwan aminu tapatuta wain yangga kayuk kaknga toknga akngana kaya wa memenggane gupna yanggaumande dauke bupbingu bumi gopatang dua tukngwamban pukuwik. Wena. “Sike unzing tasiwanu wain yangga kayuk kakngatane waung kakngata isiwan gupna bumi wagomu atdakngawik. Atdakngawan wain yangga kepdakane tukngwapimapa memenggane gupna wagomu wai siwik. Sike wain yangga kayuk kaknga memenggane gupna kayuk gomune tukngwamban pukuwan take siwik,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Siwan yuwatakak tapduk gwendune Jesuat pandetnaatda puyaangane banakan kuke pandetnata poyakgane tapuya kundu zukundakngake ooya pasiwa pimaawa kuking. ");
INSERT INTO wnc_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Kuke tasiwawa kake Ferisi aminu kunduta Jesu kaanga anzing iniking, “Natapso. Yuwatakak tapduk gwene puya dua tasinimde mama wamda ayandaknganggak ngana dasingge pandetdata puya pasikaing,” ngang iniwa ");
INSERT INTO wnc_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","yake anzing yanikut, “Ginda baminu Devitda sanga tupa siknga tasikut takngae wamu akendeking gamu unzingu dua yawam. Nata wa yanggau iat aminaatda tomna natake ");
INSERT INTO wnc_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","aminu tapatu umana Abaia ngang iniking. Ita Anutue yot takwan gwene pasike yukuune Devitda Anututane you wagwene koke poyau Anutue nomune pewa yuaingu Abaiata katewan pake nakut. Poyau wa pekingu moo aminda nananga dua ngana Anutue yot takwan gwene pasiya amindakan naning. Ngana Devitda pake atnake kundu inane aminae yaman naking ngang wa matakut takngae ginu apbotake yakaing ba dasing,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","“Anututa aminu yuwatakak tapduk gwendane mama wam gwaamuke tasiningge natake dua tumukut. Aho. Ita yuwatakak tapduk gwenu amin gatayamikge tekut. ");
INSERT INTO wnc_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Unzingge na aminbamde notnaapa dakngake sangabamdane kuyana yuke gatu puya yuwatakak tapduk gwene pasikaing kakngae kuutde kuyana yuat,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Siwan Jesuta miti yot gwene gatuna kopbut. Kopan aminu tapatu itane katakngi boopmiwanga akgoptawan apmatekakut tapata undang yuwawan ");
INSERT INTO wnc_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","aminu wa yukingga Jesue kem wam yaningge katasiking. Katasike asikaya Jesuta yuwatakak tapduk gwene aminu waapa take ba tasingamik ngang natake kayuking. ");
INSERT INTO wnc_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Kayuwawa ita katakngi wai sikut tapa anzing inikut, “Gata banakan yuyo,” ngang inikenga ");
INSERT INTO wnc_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","aminbamde anzing yanikut, “Mosesda mama wapatang dasing matakut? Ninda sanga takeaknga yuwatakak tapduk gwene take tasinim ba ninda waiaknga tasinim? Ninda amin gatayamuna take yutning ba ninda atzipna kumning? Mama wapatang dasing matakut,” ngang yaniwan ngana wamu yake dua iniking. ");
INSERT INTO wnc_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Dua inike kuma yuwawa musia kekeknga siwan yamandet dakngakaing ngang katakuke musia toknga natayamuke musia meya natapbut. Natake aminu waapa anzing inikut, “Katakga tapi kwangawan,” ngang iniwan tapan kwangawan kataknga take gatu sikut. ");
INSERT INTO wnc_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Siwan zetgaman Ferisi aminda enake kepman kuking. Kuke Herotdane aminaat unekan gatake paut tasiking. Tasike Jesu tanguwa kupikge wam yaking. ");
INSERT INTO wnc_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Siwan Jesuat pandetnaatda you wa gapma teke yangga gapanu Galili ngang inikaing gwene kuking. Siwan aminbamu keu Galili komune nanaat gatu Judia kep komune nanaat ");
INSERT INTO wnc_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","gatu you Jerusalem gapmane nanaat gatu keu Idumia komune nanaat gatu yangga Jodan tapa kautdu saak yuaing amin gatu kautdu Taia gatu Saidon ngang yanikaing gapmaaune wesim yuaing aminu kuutda Jesuta sanga tasikut takngae natake ie kuking. ");
INSERT INTO wnc_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Siwan aminu buyambam sikngata apuwawa kake na tapakusinang ngang natake Jesuta pandetna anzing yanikut. Dopangbamu gwendu tandakngawa nata une kopa ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Dasingge? Tupa ita maya wawi kwaapzang take pasiyaman kake maitna kaya aminu maitna wena siningge katakngita wasinangge natake apu yupbasiking. ");
INSERT INTO wnc_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Sike tapdukbam asinggan apu yupbasike yuwawa waung waita paking aminda i kake ie muna puke anzing yanggamatakaking, “Ga Anututane waaknga,” ngang yanggamatakaking kaknga ");
INSERT INTO wnc_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","anggaman dua yakapningge ita wamu kekeknga asinggan yanindakngakut. ");
INSERT INTO wnc_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Siwan Jesuta bakubaku dakane koke aminbam kawan siwan kundutane umana yake yayawamban apbing. ");
INSERT INTO wnc_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Apana wa aminu katau kuut musaat kepianganu tapaaya ngang pakut. Iat gatake yutningge natake pakut. Pake yanipewan kuke wamna yaniningge natake pakut. ");
INSERT INTO wnc_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ita kekeknga akngana yaman waung wai yanikwasitningge natake ");
INSERT INTO wnc_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","aminu wa katau kuut musaat kepianganu tapaaya ngangu wa pakutdane umana anzing. Saimon umana takngatu Pita ngang iniking. ");
INSERT INTO wnc_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Gatu Sebeditane waaknga tapaaya umana Jems gatu uyapna Jon ngang yaniking. Aminu waapaatde umana takngatu Boanesis ngang yaniking. Sike umana waakngatane yapii anzing. Gakngatda binga kapmapa yakamayak kapaat ngang yaniking. ");
INSERT INTO wnc_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Gatu Endru, gatu Filip, gatu Batolomyu, gatu Matyu, gatu Tomas, gatu Jems Alfiasdane waaknga. Gatu Tadias, gatu Saimon umana takngatu Selot ngang iniking. Sike umana waaknga tana tekwamban musia enawan puya kekeknga iwana yapbitnangge pasikaing amikatnana tapatu ngang iniking. ");
INSERT INTO wnc_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Gatu Judas Iskeriot yot gapmane nana waapata Jesu iwande yeuyamukut tapa. ");
INSERT INTO wnc_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jesuta yotna kuwana aminbamda wamna natake maitna sandeyamikge apu yupbasiwawa Jesuat pandetnaatda nanam nananga dua sikut. ");
INSERT INTO wnc_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Siwan Jesutane uyapnata wamu waaknga natake, “Ita atdatdaptake pasinggak,” ngang yake iniwa kuningge apbing. ");
INSERT INTO wnc_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Siwan mama wam yanindamumsa aminu kundu you Jerusalem gapmaneta epbingga kake anzing yaking, “Bielsebul waung waitane tupan tapata Jesu tapan datdaptanggak ngang yaking. Ita waung wai tupan tapatane kekeknga akngane waung wai yanikwasiwan kukaing,” ngang yaking, ");
INSERT INTO wnc_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ngang yawa natake Jesuta yayawamban apana tuwang wamu kundu anzing yanikut, “Setenda ina inikwasitnanga dua,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","“Sike aminu keu komdune nana aminda enake dongu takngaya yuke amapanu keu waomune nana aminda kekeknga yutnanga dua. ");
INSERT INTO wnc_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Siwan aminu you gwendune nana aminda enake dongu takngaya yuke amapanu you wagwene nana aminda kekeknga yutnanga dua,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","“Siwan Setenda inane dongae iwan dakngawanu ita kekeknga yutnanga dua. Aho! Ita wena asiwik,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Sike aminu tapatuta Setendane yotnaatang moo siknga koke aminbamu ita pakut takwau sandepewan kunanga dua. Wena. Ita Seten gamok tanguke napda wamakenga ita take sandepewan kuning,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Nata siakande siknga daninggat. Wai takngatu takngatu tasikaingu asandeyamunangae kepi kaya. Siwan sapdut wamu asinggan yakaingu kuut asandeyamunangae kepi kaya,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","“Sike ngana aminda sapdut wamu Anututane Waung Takwan Tapae yaningu Anututa wai waakngana dua sandeyaman yutakuning. Sandeyamunangae kepi wena,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Dasingge? Aminu kunduta yake, “Waung waita tapan datdaptake pasinggak,” ngang inisapduke yawa natake Jesuta unzing yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Wamu waaknga ayayuwawan mingaat uyapnaatda apu kepman yuke ie yatawaking. ");
INSERT INTO wnc_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Yatawamba ngana aminbamu Jesu tembasike yukikatnana kunduta anzing iniking, “Natapso. Minggaat uyapbaatda kepman katang yuke gae yanggawakaing,” ngang iniking. ");
INSERT INTO wnc_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Iniwa yake anzing yanikut, “Minga uyapma ngang yaninggat aminde daniwa natapnong,” ngang yake ");
INSERT INTO wnc_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","wa yupbasikingu katakuke katapmiyuk anzing yakut, “Minga gatu uyapma ngang yaninggat aminu anin,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","“Aminda Anutue banip tawaningu, ‘Uyapma gatu samina gatu minga,’ ngang yaniwit,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jesuta yanindamutnangge natake yangga gapanu Galili gwenu kwaimune gatu kuke tuwanguke yaniwawan aminbamda ie apundopbing. Apundoke akgitnagitnauke ikotawamba keu ayutnanga wena siwan dopangbamu yangga gapan gwene yukuu gwendune koke une pukwikut. Pukwike yanindamutnangge tasiwan kake aminbamda yangga kwaimune yuking. ");
INSERT INTO wnc_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Siwan ita wamu kwaapzang tuwang wamban yanike anzing yanikut, ");
INSERT INTO wnc_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Nata ginu daniwa natapnong! Aminu tapatuta nanam zak pake paku puyaangaatang muban pimaking. ");
INSERT INTO wnc_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ita muban kuke zakngi kundu kepiapane pimakingu kwaitda apu naking. ");
INSERT INTO wnc_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Siwan zakngi kundu keu suu amaakatang yuwa kaiu engatangan mateknga siknga yuaing kopatang pimapa zuna zetgaman akopbing. ");
INSERT INTO wnc_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Akopa ngana gunzitda akoke yasiwan zuna wa muyakngi wena siwan kungwake akupiaking. ");
INSERT INTO wnc_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Siwan zakngi kundu babam yapiatang pimakingu babamda enake asusikwatapa buya dua aaking. ");
INSERT INTO wnc_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Siwan zakngi kundu keu take komune pimake buyambam takake aaking. Kundu buya matekngasim aaking siwan kundu buyambam aaking siwan kundu buyambam siknga aaking,” ngang yanikenga ");
INSERT INTO wnc_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","anzing yanikut, “Mamin aminda maakngi kaya kakengu wamu ayanggat taknga natapsok,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Masande Jesuta inatakan yuwawan pandetna 12-pat nana amikat gatu aminu kundu iat gatake yuking amikat kuutda tuwang wamu wa yanikut takngae inikwaiking. ");
INSERT INTO wnc_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","12","Inikwaiwa ita yake anzing yanikut, “Anututa amin panangge tasinggak kakngae yapii akusopuke yuau anggaman daniwitde Anututa nandutewan nata daninggat. Siwan yanikapsa aminu tapatuta Anutue wamu takngatu anzing matakut, ‘Kainata akake ngana sanga tapatu dua binga kaaing. Wamu maakngita atnatake ngana yapiie dua nataaing. Dua natake musia dua tapa tekwamban waiakngana dua sandeyamit,’ ngang Anututane wamu waaknga tupa siknga ngang yakapsa aminu tapatuta matakut taknga buya apmanu unin aakgak. Nata wamu kuupbam tuwang wamban aminu kepman yuaing aminde yaniwa nataaing,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Siwan Jesuta anzing yanikwaikut, “Ginda tuwang wamu waakngae dua natdekengu nata tuwang wamu takngatu takngatu daniwa apme natdetning? ");
INSERT INTO wnc_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Aminu nanam zak muban kuking kapa Anutue wam yaninggak kapanin. ");
INSERT INTO wnc_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Siwan nanam zau kundu kepiapane pimakingu anzing. Wamu yaniwan maakngita atnataaing siwan ngana tapduu waomunekan Setenda apuke wamu wa musiaatang pakaing kaknga asandeyamunggak,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","“Siwan nanam zau kundu keu supna kaya komune pimakingu anzing. Aminu tapatuta Anututane wam yaniwan natake zetgaman apbakngake takaing. ");
INSERT INTO wnc_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Siwan ngana wa aminu nanam zakge zuna muyakngi wena siwan zetgaman kupiakaing binga. Tapduu mateknga siknga yusika apimakaing. Aminda Anutue wam taknga tanguwa pimapikge natake maya wawi wamu ataking aminde meya yama banip siking kaknga zetgaman tewan pimanggak,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","“Siwan zakngi kundu babam yapiiatang pimakingu anzing. Wamu yaniwan atnataaing. ");
INSERT INTO wnc_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Siwan ngana sanga meya siwan nangaakan nataamang kakngaat gatu sanga buyambam siknga panangge kem wa nataaing kakngaat gatu sangabamu inata inatae iaknga nataaing kakngaatda Anutue wamu yaitapaakusiwa wamu wa atnatapbing kakngata buya dua aakgak,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","“Sike zakngi kundu keu take komune pimakingu anzing. Wam yaniwan natake take tanggaganuwa buya asaakgak. Aminu wamu waaknga nataaing amikatnana kunduta tasiwa buyana matekngasim aakgak siwan kunduta tasiwa buyana buyambam aakgak sike kunduta tasiwa buyana buyambam siknga aakgak,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Siwan Jesuta wam yake tuwang wamu takngaaya anzing yanikut, “Aminda lam gwen sake takapuke gapma gwende gepbiatang ba buka gwende gepbiatang tenangge natake takapik ba dasing? Wena. Ita buka gwene tewik. ");
INSERT INTO wnc_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Sanga apmea pangenapakwewan kaning ngang natake pakusopukamang. Siwan apmea yanikapnimde natake wamu takusopukamang. ");
INSERT INTO wnc_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Aminu maakngi kaya kakengu wamu waaknga natapsok,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","“Wamu ginda natapbing kaknga katak siknga natdetnong! Wamu wa natdekaing kaknga buyambam ba mateknga pakinga kakengu ina unzakan dua paning. Kunduat isakoyamik. ");
INSERT INTO wnc_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Sike aminu tapatuta natdetdet gwa pakuu Anututa kunduat asimik. Siwan ngana aminu tapatu dua pakutna kakengu Anututa natdetdet mateknga ita pakuu akaiwan kungamik,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Siwan ita yake tuwang wamu takngatu anzing yanikut, “Anututa amin panangge tasinggak kaknga aminu tapatuta nanam zau kepdakane muban kukaing binga. ");
INSERT INTO wnc_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Muban kuwana zikaa kuupbam aminu waapa dapuna peke kwakngaomu ita enake kawawan nanam zau wa akoke buyambam takawa kake ngana kepda anzing tasiwan akokaing ngangge yapii anggaman dua nataak. ");
INSERT INTO wnc_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Kepdakata tanguwan baptake nanam zakgane zuna akopana buya aawik. Tupanu nayoksan sike kopan tatakngita waiwik. Siwan masande buya suyuke takaning. ");
INSERT INTO wnc_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Takakenga damana siwan kake aminu wa muban kuking kapata buya pananga tapduu gwa singgak ngang natake paip take patziwik,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Siwan tuwang wamu takngatuat anzing yakut, “Anututa amin panangge tasinggak kaknga mina bingae tuwanguke yawa natapnim? Siwan ie tuwang wamu mina bingae yawa natapnim? ");
INSERT INTO wnc_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Wa anzing. Katau dakatu umana mastet ngang inikamangge tapuya wa nanamu akwaikamangu kuupbamde tapuya binga dua. Wena. Wa mateknga siknga. ");
INSERT INTO wnc_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Aminda mastetdane zakngi kwaiwanu akoke koke buyambam daka takake nanam zau kunduta mamaya kokaing ngana mastet dakata takake kuupbam ayapbimbik. Sike kainga buyambam siwan kwaitda apu yotna kaingane tasike ayutning,” ngang yakut. ");
INSERT INTO wnc_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jesuta yake tuwang wamu tupanu gwa yakut taknga binga ina unzakan gatu kunduat yanikut. Wamu aaknga apme natdetning ngang baniaatang natake waakngakan yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ita wamu takngatu anggaman dua yanikut. Wena. Ita tuwang wamban yakut. Siwan tapduknga pandetnaatdakan iat gatake yuking gwene ita tuwang wamu wa kuupbamdane yapii yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Siwan tapduu wagwene bangee ita pandetna anzing yanikut, “Ninda yangga gapan gwenu kautdu saak kuna,” ");
INSERT INTO wnc_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","ngang yawan aminbamu waakwau peke dopangbamu Jesuta gwa pukwikut gwene koke iat kuut tapa kuking. Tapa kuwawa aminu kunduta dopangbamu kunduat papa wa amikat kuking. ");
INSERT INTO wnc_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Kuwawa gou buyambam sikngata apan yangga sambuya enake dopang bampatang pukuwa yanggata dopangbam gwene dopnangge sikut. ");
INSERT INTO wnc_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Siwan Jesu dopangbam gwenu maseatang yuke pilo gwendune dapuna peawan tanguwa enawan anzing iniking, “Yanindamumsaapa! Dakpaknga siknga ninu kumnanggekamang. Siwan ngana butaya dua natanimuke dapunu pekgayak,” ngang iniwa ");
INSERT INTO wnc_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","asenake got takngae kaanga yake yangga sambuyae atzakngayo ngang yawan gotda zakngawan yangga sambuya enakuu zetgaman kuma siknga yukut. ");
INSERT INTO wnc_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Siwan ita pandetna kaanga anzing yanikut, “Dasingge ginu unzingu gwaukaing? Ginda nae natapa kekeknga dua siwan dandupa meya singgak,” ngang yaniwan ");
INSERT INTO wnc_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","kumzang siknga gwauke ina banakan anzing yaking, “Aminu aapa mamin? Ge ita yawan gotkat yanggaatda zakngawat kaamang,” ngang yaking. ");
INSERT INTO wnc_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Siwan yangga gapanu kautdu saak kuke Gerasa amindane kep komune kundopbing. ");
INSERT INTO wnc_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Kundoke Jesuta dopangbam gwenu tewana aminu tapatu waung waita tapan ");
INSERT INTO wnc_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","matmat gapma gapmane yumdekan yusika pekgak. Sike aminu tapatuta tanggaganutnanga dua. Sike nau takngataa wamatenanga dua. ");
INSERT INTO wnc_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Sike tapduk bamu asinggan nap takngata katakngaat baangaat wapa ngana apapan dakngawan kunggak. Ita kekeknga siknga siwan aminu tapatuta tanggaganutnanga dua. ");
INSERT INTO wnc_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Sike asinggan gunzitapane gatu zikaane ngangu ita matmat gapmane yuke bakubaku dakane kungapuyuk kumzang ainggamatake inane gupna supda matanggak. Siwan Jesuta keu wandakane kundopan ");
INSERT INTO wnc_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","8","ita kawawan Jesu maa yuwan kake ita matmat gapma teke asisapmake apan kake anzing inikut, “Ga waung waiapa. Aminu waapa teng,” ngang iniwan ngana apu butaya wam ininangge ie muna pukut. Puke wamu kumzang apaa yanggamatake kekeknga siknga anzing inikut, “Jesu. Ga Anutu enane siknga yuak kapatane waaknga. Gata nae dasing tasiya,” ngang yake usake apaa siknga anzing yakut, “Gata nae toknga ma siknga namim,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Iniwan yake, “Umanda mamin,” ngang inikwaiwan natake, “Natane umana Aminbam, Ninu kwaapzang.” ");
INSERT INTO wnc_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Inike, “Gata ninu ma ninipewi keu andaka teke komduatang kunim,” ngang waung waita ininggamataking. ");
INSERT INTO wnc_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Sike ikwawa buyambamu takwakgu 2,000-da wesim bakundakane zongazonga nake yuwawa ");
INSERT INTO wnc_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","kake waung waita Jesu anzing iniking, “Gata ninu ninipewi kuke ikwawa waakwak panim,” ngang iniwa ");
INSERT INTO wnc_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","ita, “Take. Kunong,” ngang yawan waung waita aminu waapa teke kuku ikwawa waakwak paking. Papa ikwawa 2,000-nu waakwau atdatdaptake kekeknga siknga isapmake kuku dameatang pimake yangga gapan katang pimake yangga tangoke akumbing. ");
INSERT INTO wnc_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Siwan aminu ikwawa wa toikaingga kake atdatakuke aminda wamu yot gapmanenana gatu kaukaut yuaikatde yatakuking. Yatakuwawa natake kuke sanga wa sikut taknga kaking. ");
INSERT INTO wnc_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Kake Jesue kuke kawawa aminu wa tupa waung wai kwaapzangga tapa datdaptakut tapata tauknga tasike natdetdetna nomana siwan apukwike yuwawan kake akagwauking. ");
INSERT INTO wnc_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Akagwauke yuwawa waung waita tapa datdaptakut tapata take siwan ikwawa akwau akupa kaking aminda yaniwa natapbing. ");
INSERT INTO wnc_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Yaniwa natake Jesu wamu kekeknga kepna teke komduatang kuwikge ininggamataking. ");
INSERT INTO wnc_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ininggamatawa Jesuta dopangbam gwene koke tasiwawan kake aminu waung waita takut tapata, “Na gaat kuut kusim,” ngang Jesu iniwan ");
INSERT INTO wnc_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","“Gaat dua kusim,” ngang inike yake anzing inikut, “Gata yotda kuke dongu gikaat nana aminde kuke sangabamu Anutu Buyambam tapata butaya natanggamuke tasinggamukge yaniyo,” ngang iniwan ");
INSERT INTO wnc_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","aminu waapa akukut. Kuke keu wakomune yot gapma gapma katau kuut musaat yuaingune kuke sanga Jesuta tasingamukutde yanitakuwan natake aminu kuupbamda nangaakan natapbing. ");
INSERT INTO wnc_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Siwan Jesuta gatu dopangbam gwene koke yangga gapanu gatu kautdu saak kunangge natake kuking. Ita kautdu saak kuke yangga kwaimune yuwawan aminbamda kuke ie doke yuking. ");
INSERT INTO wnc_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Doke yuwawa miti yotde kuyana kayuau tapatu umana Jairas ngang iniking. Ita Jesu kake butaya wam ininangge kuku muna Jesue kepine puke ");
INSERT INTO wnc_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","wamu kekeknga Jesu anzing inikut, “Natane yapamatekngata kumnangge dapaknga singgak. Gata apu katakgata wasiwi ita take siwan,” ngang iniwan ");
INSERT INTO wnc_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jesuta iat gatake kuwawat aminbamda kuku tawake yuwa akgitnakut. ");
INSERT INTO wnc_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Tawake akgitnawa maya tapatu ita yekapna sike dau asinggan pake nakanu 12 gwa yuwan sandewan ");
INSERT INTO wnc_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","dokta kwaapzangga maitna sandetnangge natake tasingamuwawa gupnane tokngabam natake buyana wa aminde yaman puyuwan ngana itane maitna takesimu dua sikut. Wena. Maitna buyambam sikut. ");
INSERT INTO wnc_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Sike maya waapata natawawan Jesuta gwa apuk ngang yawa natake nata katakngata itane tauknganekan wasikengu nata take siwit ngang natapbut. Natake kuku ngwekngweke aminbamu waakwakge banakan koke Jesue maseatang kuke katakngita Jesutane tauknga wasikut. ");
INSERT INTO wnc_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Wasiwan zetgaman daknga atzakngawan gupnaatang natapan maiu waaknga ateke kuwan natapbut. ");
INSERT INTO wnc_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Siwan wasiwan Jesuta natapan itane kekeknga aknganata aminu tapatu gatangaman natapbut. Natake aminbamde banakan tapan tekwamban anzing yakut, “Maminda katakngita taukngane wasik,” ngang yawan ");
INSERT INTO wnc_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","pandetnata anzing iniking, “Gata kayo. Aminbamu gae apundoke yuwawa kake ngana, ‘Maminda katakngita na wasik,’ ngang yanggayak,” ngang iniking. ");
INSERT INTO wnc_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Iniwa ngana Jesuta katakuke maminda waaknga tasik ngang natake katakukut. ");
INSERT INTO wnc_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Katakuwawan maya waapa sanga ie singamukut takngae atnatake akgwauke dandai yamuking. Dandai yamuwawa kuke Jesue nomune muna puke sangabamu singamukutde anggaman yakapbut. ");
INSERT INTO wnc_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yakapan Jesuta anzing inikut, “Yapana. Gata nae natapi kekeknga singgak kakngata maitda sandekgamuk. Musipba kwikwiknga natake kunggayo. Gatane maitda wena gwa singgak,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Siwan Jesuta wamu waaknga ngang iniyuwawan aminu kundu miti yotde kuyana yuak kapatane yotnane yuaingu kunduta apu anzing iniking, “Gatane yapaka gwa kungwak. Dasingge gata puya kwatan siknga ayanindamumsa apae imunggayak,” ngang iniking. ");
INSERT INTO wnc_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Iniwa ngana Jesuta wamu wa yaking kakngae maau dua pake natake miti yotde kayuakapa Jairas anzing inikut, “Ga nangaakan ma natapim. Gata nae natapi kekekayok,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Inikenga dua kapewan aminbamu iat kuking. Pita gatu Jems gatu Jon Jemsdane uyapna nganggakan iat kuking. ");
INSERT INTO wnc_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Kuke kuku aminu take waapatane yotnane kundoke natawawan kwanamu kumzang siwawa gakngat buyambam siwan ");
INSERT INTO wnc_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","natake ita yoakatang koke anzing yanikut, “Dasingge ginu kwanamu sike gakngatbamu tasikaing? Waatdaka aapata gatukande dua kungwak. Ita dapuna pekgak,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Yaniwan natake minu kumzang inimiba ngana aminbamu ayanikwasiwan epu kepman kuking. Kuwana waatdakatane minga nanaat gatu pandetna wa tapaat tapatuat nganggan papan you waatdakata pekut gwene kopbing. ");
INSERT INTO wnc_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Koke ita waatdakatane katakngane take inane wam tangan, “Talita kumi,” ngang inikut taknga tana tekwamban, “Maya matekapa. Nata ganiwa asenayo,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Iniwan zetgaman maya mateu waapasimu asenake yot gwene tuwanguke kumbasike kukut. Gwa takake nakanu 12 gwa kawan sandekut. Siwan unzing tasiwan kake kumzang satnaking. ");
INSERT INTO wnc_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Siwan Jesuta wamu kekeknga anzing yanikut. Ginda aminu tapatu sanga a kaaingge ma iniwam ngang yanike nanamu kundu maya mateu waapasimde imusande yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesuta you wanggapma teke yotna siknga kunangge kuwawan pandetnata iat gatapa kuking. ");
INSERT INTO wnc_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sike yuwatakak tapduk gwene ita miti yot gwene koke Anutue wam yanikut. Yaniwan natake aminbamda asatnake anzing yaking, “Aminu aapa wamu waaknga zane takut,” ngang yaking. “Natdetdetna wa nataak kaknga inata kundu,” ngang yaking. “Dasingge ita duya takngatu takngatu pasinggak,” ngang yake, ");
INSERT INTO wnc_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","“Aminu waapa katapsan usike sangabam pasinggakge natake kamda ngang dua inikaing ba dasing,” ngang yaking. “Ita Mariatane waaknga siwan ita Jems gatu Josis gatu Judas gatu Saimon nganggane paana. Sike itane samina ane nikat gatake yuamang,” ngang yake ie semna natangamuking. ");
INSERT INTO wnc_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Siwan ngana Jesuta anzing yanikut, “Yotna yotna nana aminda ayanikapsa aminu tapatue umana kaapa ngang unzing nataaing. Ngana yotna siknga yuwan inaatnana aminda umana wenaapa ngang natangamukaing,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Siwan ita duya takngatu you wanggapmane tasinanga dua sikut. Ita mait aminu tapatu tapatukan katakngita wasike take pasiyamukut. ");
INSERT INTO wnc_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Siwan unenanata ie natapa kekeknga dua siwan kake nangaakan natapbut. Natake you ugwak saak yuaing gapma gapmane kuke Anutue wamu aminbamde yanitakukut. ");
INSERT INTO wnc_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Siwan ita pandetna katau kuut musaat kepianganu tapaaya ngang yayawamban apana ita tapaaya tapaana kaya yanipewan kuningge yake kekeknga aknga wa aminde waung wai yanikwasiwa kuningge yamukut. ");
INSERT INTO wnc_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Yamuke anzing yanikut, “Ginu sanga tapatu kepi kunangge natake gusokzakan panong,” ngang yanikut. “Ginu nanam ba yakza ba ma papam. Mani yakza tumaekan panong. ");
INSERT INTO wnc_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Sike ginu kepi taukza take pasining ngana siotza gomayana kaya ma pasiwam. Gomdukan tasinong,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","“Ginda you gapmandune kundopa unenana tapatuta yotnaatang pakopanu you wagwenekan yutnong. Yusika masande you wanggapma tenangge natekengu you wagwen teke kunong. ");
INSERT INTO wnc_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Sike ginu you gapmanduine kuwa unenana aminda ginu yotnaatangu dua pakoke ginde wamu dua natapanu ginda you wanggapma teke yemi kaikza zipa pimapa kake wai waaknganae anggaman natapning,” ngang yake yanipewan kuke ");
INSERT INTO wnc_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","pandetna waakwau wamu, “Ginu musipza tapa tekwamsok,” ngang yanitakuking. ");
INSERT INTO wnc_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Yanitakuke waung wai kwaapzang yanikwasiwa kuwawa wel yangga botol gopatangga mait aminde gupnane tukngwake pasiyamuke maitna sandeyamuking. ");
INSERT INTO wnc_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Sike Herot tupan tapata natapan puya waaknga pasitakuwawa Jesutane umana keu kuupbam tawamban sandewan natapbut. Natapan aminu kunduta anzing yaking, “Jonu yangga sauyamukut tapata matmat gapmaneta gatu enake duya takngatu takngatu unzingu pasinggak,” ngang yawa natapbut. ");
INSERT INTO wnc_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Siwan aminu kunduta yake, “Ilaija ayanikapsaapa kayuk yuwan Anututa takopbut tapata enandangga epuke pasinggak,” ngang yaking. Siwan aminu kunduta yake, “Ayanikapsa tapatuta pasinggak,” ngang yaking. “Unzing ayanikapsa aminu tupa siknga yuke pasikakikat nana tapatu binga,” ngang yawa ");
INSERT INTO wnc_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","natake Herotda anzing yakut, “Tupa nata yanipewa Jondane guyaknga matawa kumbut tapata gatu ba enake pasinggak,” ngang yakut. ");
INSERT INTO wnc_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Sike tupa Herotda uyapna Filipdane maatna umana Herodias ngang iniking kapa kaiwan kuwan maatnae takut. ");
INSERT INTO wnc_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Siwan Jonda Herot anzing inikut, “Gata uyapbatane maatna tapi kawa take dua singgak,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Iniwan wamu waaknga natake Herodiasda Jonde semna siknga natake atanguwan kupikge natapbut. ");
INSERT INTO wnc_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Siwan ngana Herotda Jonu amin noman gatu Anututane amintapa ngang natake wai tasingamunangge akgwaukut. Akgwauke tapatuta dua tanguwan kupikge ita katak siknga kayutnangge natake amina kundu yanipewan kuku Jon tanggaganuke nap takngata wamake kaautde tewa yuwawan Herodiasda tangutnangge apmeptakut. Siwan Jonda wamu takngatu takngatu iniwan natake Herotda musiane meya natapbut. Natake ngana ita Jonde wam natapnangge take siknga natapbut. ");
INSERT INTO wnc_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Sike masande Herodiasda Jon tanguwan kupikge kepi takngatu anzing kakut. Herotda tapduknga mingata tangaikut gwende natake yawan nanamu buyambam saking. Sawa ita nanamu buyambamu wa sakingu yaman take aminu gavmande puya gatangamuke pasiya amikat gatu amak aminu tupan takwakat gatu take aminu Galili kep komune nanaatda apa unekan gatake yuke naking. ");
INSERT INTO wnc_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Nake yuwawa Herodiasdane yapanata aminu waakwau banakan koke wakumu inatakan taiwa nanduke geenguke ngang tapik ngang natake kuke taikut. Taiwawan kake Herotkat aminu iat gatake yuke naking amikatda take siknga natapbing. Siwan Herotda maya mateu waapa anzing inikut, “Gata sanga minaka tanangge natakengu gata nae naniwinu nata gae akgamit,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Inike, “Siakande siknga akgamit,” ngang yake anzing inikut, “Gata nae sanga tapatu gamitde yawinu akgamit. Sike gata natane sangabamu kautdu gae gamitde yawinu nata akgamit,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Iniwan natake maya mateu waapata epu kepman kuke minga Herodias inike, “Nata sanga mina binga tapitde iniwit,” ngang inikwaiwan Herodiasda yake anzing inikut, “Gata, ‘Jonu yangga sauyamukut tapatane guyaknga matawan kupana gwapaknga dopangu gwendune teke nae namuyo,’ ngang Herot iniyo,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Siwan maya mateu waapata zetgaman Herotde kuku anzing inikut, “Apmaatzim Jonu yangga sauyamukut tapatane gwapaknga dopangu gwendune teke nae namuyo,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ita unzing iniwan natake musia meya natapbut. Ngana ita siakan siknga ngang gwa yawan kekekawan aminu iat gatake yuke naking aminda gwa natapbing. Unzingge ita gwa yawan kekekakut takngae isapmamsa wam yanangge dua natake maya waapatane wamna zipbutnangge dua natapbut. ");
INSERT INTO wnc_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Siwan zetgaman amak aminu tapatu initewan Jondane gwapaknga takapnangge kukut. Kuke kaaut yot gwene kuke Jondane guyakngi matake ");
INSERT INTO wnc_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","gwapaknga dopangu gwendune teke takapuke maya matekapae imukut. Iman take taku mingae imukut. ");
INSERT INTO wnc_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Siwan Jondane pandetnata ie wam natake kuku gupnaapa take taku matmat gapmane kwaiking. ");
INSERT INTO wnc_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Siwan yanipewan kuke puya pasiking aminda gatu apuke Jesu iniking. Puya takngatu takngatu pasikingge wamu inike wamu kuupbam aminbamde yanikingge kuut iniking. ");
INSERT INTO wnc_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","32","Iniwawa aminbamu wamna natake maitna sandeyamikge apu tanggaganuwa Jesuat pandetnaatda nanamu nananga dua sikut. Siwan Jesuta pandetna anzing yanikut, “Ninda nisatakan keu amina wena komduatang kuke ninu kundusimu yutna takawan,” ngang yaniwan dopangbam gwen take kuking. ");
INSERT INTO wnc_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Take kuwawa kake aminbamda ie Jesu ngangu atnatapbing. Atnatake yot gapma gapmane nana kuupbamda isapmake kuke keu Jesuta kunangge natake kukut komune wa aminda gamok kundopbing. ");
INSERT INTO wnc_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Kundoke yuwawa Jesuta kwaimune kuke kaawan aminu buyambam sikngata undang yuwa kakut. Kake wa aminu sipsip kayuya aminu wena bingata yuwa kake butaya natayamuke tuwanguke wamu buyambam yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Yaniyuwawan gunzitda apukunangge siwan pandetnata ie kuke anzing iniking, “Keu akomu amina wena. Siwan gunziu apukunanggenggak. ");
INSERT INTO wnc_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Gata aminbamu yanipewi kukakut. Yanipewi unda undang kuke yot gapma gapmane kundoke nanamna undang usike naut,” ngang iniking. ");
INSERT INTO wnc_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Iniwa ngana, “Nanamu gisa yamunong,” ngang yake yanikut. Siwan anzing iniking, “Gata ninda 200 Kina pake kuku nanam usiyamunanu take dua siwik,” ngang iniwa, ");
INSERT INTO wnc_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","“Ginu poyau datdasing paing,” ngang yanikwaikut. “Ginu kuke kanong,” ngang yaniwan natake kakenga anzing iniking, “Ninu poyau katau kautdu musa gatu pis dakaaya nganggan pamang,” ngang iniwa, ");
INSERT INTO wnc_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","aminu kuupbam zatzapdakane wa aminu dongu gwendu gwendu yutakuningge yaniwan ");
INSERT INTO wnc_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","wa aminu apukwiking. Aminu dongu kundu 100-da yuking siwan kundu 50 ngangga yuking. ");
INSERT INTO wnc_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Unzing yuwawa ita poyau wa katau kuut musaat gatu pis wa dakaat ngang pake enandang pakusang kake tumuk wam inimbakngakut. Siwan ita poyak puke pandetnae yaman usanziyama aminbamda naking. Siwan ina unzakan pis wa dakaat kaya puke yamukut. ");
INSERT INTO wnc_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Siwan kuupbamda napa musia gitnawa ");
INSERT INTO wnc_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","poyau kaiknga kuupbam gatu pis ngangu ayukingu pandetnata butuke sapat yau katau kuut musaat kepianganu gweaya ngang pamuba dopbing. ");
INSERT INTO wnc_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Sike wawi poyak nakingu 5,000. ");
INSERT INTO wnc_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Siwan Jesuta pandetna yaninggamatake Betsainda yot gapma yangga gapan kwaimune yuak gapmane gamok kuningge yaniwan dopangbam gwene koke kuwawa ina aminbam yanipewan kuking. ");
INSERT INTO wnc_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ita aminbamu yanipewan kuwana baku baku dakane koke tumuk wam yake yuwawan ");
INSERT INTO wnc_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","bangee dopangbam wagwenu yangga gapan banakan yuwawan Jesuta inatakan kwaimune yukut. ");
INSERT INTO wnc_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Yuke kawawan gotda puyayapbiban kawawan pandetnata puya kekeknga siknga kwaike kunangge tasiking. Tasiwawa akwakanangge dapaknga siwan Jesuta yangga gwene engatangan yaitake kuku dopangbamu wagwende kuke ayapbitnangge tasikut. ");
INSERT INTO wnc_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Siwan pandetna kuupbamda kawawa ita engatangan yangga gapan gwene yaitake apuwawan kagwauke kongga ba apunggak ngang natake ainggamataking. ");
INSERT INTO wnc_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ainggamatawa zetgaman Jesuta anzing yanikut, “Musipza gitnata yutnong. Nata siknga apunggat. Ginu ma gwaubam,” ");
INSERT INTO wnc_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","ngang yanike dopangbam gwene koke wa amikat yuwan gotda anzakngakut. Siwan musia kukumuk akoyambing. ");
INSERT INTO wnc_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Sike tupa wa aminu poyau Jesuta putzukuke aminbamde yaman nawawa kaking ngana musia kekekngata yuke Jesutane yapii katak dua natdeke yuking. ");
INSERT INTO wnc_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Siwan yangga gapan kwaimune kuke Genesaret kep komune kundoke dopangbam gwenu awamateking. ");
INSERT INTO wnc_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Awamatewawa kake une nana aminda ie atnatdeke ");
INSERT INTO wnc_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","isapmake kuke mait aminu you ugwak saak nana aminu Jesuta you gapmandune ba zaneka yuwawan atnataaingge mait aminu buka gwegwene peke gwaamupake ie pakuking. ");
INSERT INTO wnc_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Siwan you ayukut gapmane ba keu ayukut komune ba Jesuta zandangga yukuune mait aminu yokekep tapane pakuke peking. Peke butaya wam yanggamatake Jesuta kapewan mait aminda katakngita tauknga nomna saasaakngi wangane wasiningge iniking. Siwan aminu katakngita wasikingu kuupbamda gatuna take siking. ");
INSERT INTO wnc_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Siwan Ferisi aminu kunduat gatu mama wam yanindamumsa aminu kundu Jerusalem teke pukukikatda Jesue kuke yupbasiking. ");
INSERT INTO wnc_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Yupbasike kawawa pandetnata kataknga gamok dua sauke nanamu atnawawa kake mititane kepi takngatu unin zipmandakngakaing ngang natapbing. ");
INSERT INTO wnc_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Wa natapbing kakngatane yapii anzing. Moo aminu kuupbapat gatu Ferisi amikatda bapunata tupa siknga miti yaking kaknga tawakaing. Tawake waiaknga tasikaingu katakngane gwa gatakuk ngang natake saupamaba kuningge natake kataknga tupanu saukenga nanamu nakaing. Dua saukengu dua naning. ");
INSERT INTO wnc_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Sike wa aminu kekeu nanam usikaing komuneta apuke waiakngana saupamaba kuningge natake yangga saukenga nanamu nakaing. Sike wa aminu sanga takngatui bapunatane pakingu buyambam atawakaing. Tawake kapna gatu dopanga gatu gapmana ngangu asaukaing. ");
INSERT INTO wnc_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Unzingge Ferisi amikat mama wam yanindamumsa amikatda Jesu anzing inikwaiking, “Dasingge gatane pandetdata kataknga dua sauke ngana nanamu nake bapuninda tasikaking kaknga dua tawakaing,” ngang iniking. ");
INSERT INTO wnc_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Iniwa yake anzing yanikut, “Ayanikapsaapa Aisaiata ginu kem amin ngangu noman siknga ngang yake wamu anzing matakut, ‘Aminu waakwakgane musia nae maa siknga yuwawan natane umana gena dakatakan yatangenakaing. ");
INSERT INTO wnc_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Sike wa aminu nae kem siknga tanziyuk nanimbakngake mama wamu kepdakane nana amindane yanindamuyuk wamu waaknga Anututane ngang kem yanikaing,’ ngang Aisaiata tupa siknga matakut. ");
INSERT INTO wnc_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ginu Anutue mama wamu teke aminde sanga akngakan tanggaganukaing,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","“Ginu Anutue mama wam zipbuke gisaneaknga tasinangge kepi takngatu anzing tasikaing. ");
INSERT INTO wnc_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mosesda anzing yakut, ‘Gata nangga minggae gepbiatang yuyo,’ ngang yakut. ‘Aminda nana mingae sapdut wam yaniwanu atanguwa kupsok,’ ngang yakut. ");
INSERT INTO wnc_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Siwan ngana ginda anzing yakaing, ‘Aminu tapatu sangana nana minga gatayamikge kaya ngana sanga wa Anutue imunangge gwa yakum ngang yakengu ");
INSERT INTO wnc_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ita nana mingae take ma pasiyaman,’ ngang ginda unzing yakaing. ");
INSERT INTO wnc_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Yake ginu sanga bapusatane taking kaknga tawake pandetzae yanindamukaing. Unzingge ginda Anutue wamu atzipbukaing. Siwan ginda sangabamu unzing tasikaing,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Siwan Jesuta aminbamu gatu yayawamban apana ita anzing yanikut, “Ginu kuupbamda nae wam natake natdetnong,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","“Aminu tapatuta sanga tapatu napan ie musiaatang pukuwiu ita tasiwan aminu waapa wai amin dua dakngawik. Wena. Sike sanga baniaatang nataak kakngata tasiwan aminu wai amin dakngawik,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","(“Aminu maakngi kaya kakengu wamu waaknga natapsok,” ngang yanikut.) ");
INSERT INTO wnc_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Siwan ita aminu waakwak peke yotna koke yuwawan pandetnata tuwang wamu waakngae yapiie inikwaiwa ");
INSERT INTO wnc_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","ita anzing yanikut, “Gikaya natdetdetza wena ba dasing? Sangabamu napan aminde musiaatang pukuwiu ita natdetdetnaatang dua pukuwik. Aho. Napayutnaatang pukuke yusika masande kotdekatang pukunggak. Unzingge sanga wa bingata tasiwan aminu wai amin dua dakngawik ngang ie dua natake wamdane yapiie nanikwaiing ba dasing,” ngang yanikut. Wamu waaknga yawan natake nanamu kuupbam yuaingu tapatu dua nanimde aminu tapatuta ninindakngananga dua siwik. Take nanim ngang natapbing. ");
INSERT INTO wnc_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Siwan ita anzing yakut, “Sanga aminde musiaatang nataak kakngata tasiwan aminu wai amin dakngakaing,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","“Sanga aminde musiaatang yuke musiaatangga akowawa tasikaing kaknga anzing. Musiaatang wai takngatu takngatue nataaing. Yasewa tasinangge nataaing gatu kuka panangge nataaing gatu amin tangutenangge nataaing gatu ");
INSERT INTO wnc_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","amindane sangae geengukaing. Siwan waiaknga inata inata pasikaing. Kem yakaing gatu kamunda binga pake yawakaing gatu ita sangaapana kayaapa ba umana kayaapa dakngake napbimsak ngang natake ie semna nataaing. Gatu sapdut wam yakaing gatu inae umana tangenakaing gatu yamandet sikaing gatu sanga wai buyambam tasikaing. ");
INSERT INTO wnc_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Sanga wa wai kuupbam aminde musiaatang yuke musiaatangga akopa yake tasikaing kakngata pasiwan aminu wai amin dakngakaing,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Siwan Jesuta enake you wanggapma teke kautdu Taia yot gapmae kep saak kuke you gwenduatang koke yukut. Aminu tapatuta ie andang yuak ngang dua natapikge natake wepda yukut. Siwan ngana ita kusopuke yutnanga dua. Wena. ");
INSERT INTO wnc_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Undang yuak ngang yawa natake zetgaman maya tapatu Judianana dua. Sike itane yapana waung waita takut. Tapan dataptake yuwawan mingata kuke butaya wam ininangge muna Jesue kepine pukut. ");
INSERT INTO wnc_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Maya waapa Grik wamu ayakaing amikatnana tapatu. Ita Finisia kep komu Siria kep komune yuaune nana tapatu. Ita muna puke Jesue waung waita yapana takuunin inikwasiwikge inimatakut. ");
INSERT INTO wnc_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Inimatawan yake tuwang wamu takngatu anzing inikut, “Ninda nanamu waatdakatane pake kamunde yamuna napanu noman dua siwik. Ninda nanamu waatdakae gamok yamunim,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Siwan ngana mayata yake tuwang wamu takngatu anzing inikut, “Buyambamtapa. Gata siakande yanggayak. Kamunde gamok dua yama naning ngana kamunu nanam kaiu waatdakata napa kaiknga pimakaingu kamunda apu atnakaing,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Iniwan yake anzing inikut, “Gata unzing yanggayakge waung wai yapaka takutapa gwa inikwasiwa kunggak. Ge yotda kunggayo,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Siwan ita gatuna yotna kuke kawawan waung wai gwa teke kuwan yapanata buka gwene take pekgawan kakut. ");
INSERT INTO wnc_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Siwan Jesuta gatu enake Taia yot gapmae kep saak teke Saidon yot gapma banakan kukut. Kuke keu komdu Dekapolis yot gapma katak kuut musaatda yuaing saak banakan kuke yangga gapan Galili gwene kundopbut. ");
INSERT INTO wnc_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Kundopan aminu tapatu maakngi akusiwa yembita meya sikut tapa Jesue takapuke aminu waapa kataknga wasiwikge inimataking. ");
INSERT INTO wnc_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Inimatawa aminu waapa take aminbam peke paku inatakan yukumayak. Yuke Jesuta kataknga aminu waapatane maakngine wasike aapna suke katakngita yembine wasikut. ");
INSERT INTO wnc_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Wasike pakusang enandanga kake kekeknga yawasawa kwata wam yakut. Yake ita inane wam tangan anzing yakut, “Efata,” ngang yakut. Wamu waakngatane yapii anzing, “Ga maakga akwapan gatu yambikata atatakayok,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Iniwan maaknga akwapan yambina tatakawan wamu take yakut. ");
INSERT INTO wnc_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Siwan sanga wa kaking aminda sanga ie aminu tapatu dua ininingge kekeknga siknga ngang yanindakngakut. Siwan ngana wena. Wa aminu akekekake wamu waaknga aminbam yaninangge iaknga siknga natake yatakuking. ");
INSERT INTO wnc_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Yatakuwawa natake aminbamda kumzang satnake anzing yaking, “Sanga kuupbam ita tasiu takekan tasinggak. Ita tasiwan maaknga kusiya aminda wam nataawa gena kusiya aminda wamu ayakaing,” ngang yaking. ");
INSERT INTO wnc_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Tapduu waomune aminbamu gatu Jesue kuku dopbing. Doke yuwawa nanamu wena siwan kake Jesuta pandetna yayawamban apa anzing yanikut, ");
INSERT INTO wnc_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Nata aminu aakwakge butaya nataat. Tapduu gweaat gwenduat naat gwa yutna sandewan nanamna napa puyuwan ");
INSERT INTO wnc_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","tomda yuwawa nata yotna yanipewa kukengu kaita dandambong siwa kepiapane pimatning. Kundu maa sikngata apbing,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Yaniwan pandetnata yake anzing iniking, “Keu akomu aminu wena. Sike ninda poyau zane pake nanamu aminbamu aakwakge yamuna naning,” ngang iniwa, ");
INSERT INTO wnc_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","“Ginu poyau datdasing paing,” ngang yanikwaikut. Yanikwaiwan, “Ninu poyau katau kuut musa kautdu gomaya ngang pamang,” ngang iniking. ");
INSERT INTO wnc_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Iniwa natake ita aminbam yaniwan kepdakane pukwike yuwawa ita poyau wa katau kuut musa kautdu gomaya ngang pake Anutu inimbakngake puke pandetnae yaman pake usanziyama aminbamda naking. ");
INSERT INTO wnc_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Siwan pandetnata pis dakatu dakatu kaya. Siwan ita pake Anutu inimbakngake puke pandetnae yamuke yaniwan pis wa kuut usanziyama naking. ");
INSERT INTO wnc_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Siwan napa take siwan kaiknga yukingu unekan peke sapat yau katau kuut musa kautdu gweaya ngang pamuba dopbing. ");
INSERT INTO wnc_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Sike maya wawi waakwau buyambam siknga 4,000. Napa take siwan Jesuta ayanipewan kuwawa ");
INSERT INTO wnc_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","iat pandetnaatda dopangbam gwene koke Dalmanuta kep saak kuking. ");
INSERT INTO wnc_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Undang kundoke yuwawa Ferisi aminu kunduta Jesu tasiwa siwikge natake kuku inike gata duya takngatu tasiwi kake Anututa gae take natanggamunggak ngang natapnim ngang iniwa Jesuat yanganuking. ");
INSERT INTO wnc_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yanganuwawa Jesuta meya natake yawasawan yanike dasingge ginu tapduu ayuamang komune nana aminda duya kanangge yakaing ngang yanikut. Nata siakande siknga daninggat. Nata duya takngatu dua tasiwa kaning. Wena siknga ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Yanikenga wa amin peke dopangbam gwene gatu koke yangga gapan kautdu saak iat pandetnaat kuking. ");
INSERT INTO wnc_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Yangga gwene kunangge tasike pandetnata apbotake nanamu kundu dua pakuking. Poyau gomdukan take dopangbam gwene koke kuking. ");
INSERT INTO wnc_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Kuyuk Jesuta natake Ferisi aminda kem yanike kait tasikaing kakngae natake ita gwaut wamu anzing yanikut, “Ginu katak siknga gwautnong,” ngang yanikut. “Ginu Ferisi amikat Herotdane amikatda sanga poyakat sawa paptanggak kakngae gwautnong,” ngang yaniwan ");
INSERT INTO wnc_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","natake ina anzing yaking, “Ninu poyau wena. Unzingge ita yanggak,” ngang yaking. ");
INSERT INTO wnc_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yawa Jesuta natapan poyakgekan natayuke Ferisitane kait takngae dua natake yakaing ngang atnatake ita kaanga anzing yanikut, “Dasingge gisa wamu yake ninu poyau wena ngang yumdekanu unzingu yakaing? Nata poyakge dua danit. Wena. Ginu natdetdetza anggaman dua siwan dua natdeke yuaing,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","“Ginu kaisa kaya ngana ginda sanga tapatu dua kaaing ba dasing? Ginu maakza kaya ngana wamu dua nataaing ba dasing? Ginu nanduwawa sanga tasiwa kaking ngana gwa botaking ba dasing,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","“Nata poyau 5,000 aminde puke yama napa ginda poyau kaiknga yukingu sapat yau datdasing pamuking,” ngang yaniwan, “Katau kuut musaat kepianganu gweaya,” ngang iniking. ");
INSERT INTO wnc_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Iniwa natake gatu yanikut, “Nata poyau katau kuut musa kautduanganu gomaya ngang aminu 4,000-de putzukuke yama napa ginda kaiknga yukingu sapat yau datdasing pamuking,” ngang yaniwan, “Katau kuut musa kautdu gweaya,” ngang iniwa ");
INSERT INTO wnc_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","natake, “Ginu dua natdeing ba dasing,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Siwan Jesuat pandetnaatda dopangbam gwene kusika Betsaida yot gapmane kundopa aminu kai akusiya tapatu ie takapuke Jesuta katakngita wasiwikge iniking. ");
INSERT INTO wnc_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Iniwa natake Jesuta kai akusiya waapatane katakngine take yotde kwaim saak takukut. Takuke aapna kaine suke katakngita wasike anzing inikwaikut, “Gata sanga akayak ba dasing,” ngang inikwaiwan ");
INSERT INTO wnc_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","kake anzing yakut, “Nata aminu kundu kawa katap dakandaka binga siwan akuwawa kaat,” ngang yakut. ");
INSERT INTO wnc_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ngang yawan katakngi kaine gatu wasiwan aminu waapata anggaman kanangge natake kanggamatawan take siwan sangabamu anggaman kakut. ");
INSERT INTO wnc_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Siwan Jesuta yotna initewan kuwikge anzing inikut, “Gata you anggapmaatangu ma kopim,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Siwan Jesuat pandetnaatda enake you wanggapma teke kautdu Sisaria Filipai yot gapmae kep saak yot gapma gapma yuaingune kuking. Siwan kepiapane kusika ita pandetna anzing yanikwaikut, “Aminda nae dasing yakaing,” ngang yanikwaiwan ");
INSERT INTO wnc_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","yake anzing iniking, “Kunduta gae ‘Jonu yangga sauyamukut tapa’ ngang yakaing. Siwan kunduta gae ‘Ilaija ayanikapbut tapa Anututa tupa siknga kayukapa takopbut. Ita enandangga gatu epuke pasinggak’ ngang yakaing. Siwan kunduta gae ‘ayanikapsa tapatu tupa siknga kumbut ngana apmanu gatu gweake pasinggak’ ngang yawa kakumang,” ngang yaking. ");
INSERT INTO wnc_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Yawa yake, “Gisa nae dasing yakaing,” ngang yanikwaiwan Pitata yake anzing inikut, “Ga Anututa tapan gata Krais gatanimuyaapa dakngake yuwi gaduat,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Iniwan natake aminu tapatu wamu waaknga dua ininingge ayanindakngakut. ");
INSERT INTO wnc_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Siwan kepiapane kusika ita tuwanguke anzing yanindamukut. Na aminbamde notnaapata meya takngatu takngatu papit ngang yakut. Ninu Judia amindane take amikat gatu Anutue yot takwan gwene pasiya amindane takeakwakat gatu Mosesde mama wam yanindamumsa amikatda nae semna natangamuke yawa nuwa kupit. Kungwake tapduu gweaat gwenduat yukenga gatu enawit ngang ");
INSERT INTO wnc_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","wamu waaknga yake anggaman siknga yakapbut. Yakapan natake Pitata Jesu kwaim saak takuke inatakan yuke gata toknga waakngata gae apikge ma yawim ngang kaanga inikut. ");
INSERT INTO wnc_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Iniwan Jesuta tapan tekwamban pandetnabamu undang yuwawa kake Pita kaanga anzing inikut, “Gata iwana dakngawi ganduke ganinggat. Na napbimbi ayanggat taknga tasingamuning,” ngang inikut. “Gata Anutue natdetdet taknga dua natayak. Wena. Gata aminde natdetdet takngakan natake yanggayak,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Siwan ita aminbampat gatu pandetnaat yayawamban ie apana anzing yanikut, “Aminu tapatuta na nawanangge natakengu inane banip tawanangge nataak kaknga undang teke iwanata amin saamdakane na nuwa kupit binga kumnangge dua gwauke meyana gwaamuke na nawamsok,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","“Sike aminu tapatuta kayuk yuak kaknga gitna tanangge natakengu waapata akupik. Siwan ngana aminu tapatuta nae natanggamatake gatu natane wama takeaknga ngang yanikapnangge natake tasiwawan aminu kunduta semna natangamuke tanguwa kupanu ita gatuna kayuk yuwik kakngana atake asinggan yuwik,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","“Sike aminu tapatuta sangaapana buyambam siknga papik. Pake ngana masande akupanu sangana wa pakut takwakga dasing gatangamik? Wena. ");
INSERT INTO wnc_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Sike sanga dasitna bingata kayuk yutnanga akngana wena sikuu gatuna tanangge muke usiwik? Wena,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","“Tapduknga ayuamang komune nana aminda wai takngatu takngatu tasike Anutue asinggan dua natanggamatake ie masa imuke gawaknga aknga pasikaing. Sike wa pasikaing amikatnana tapatuta nae masa namanu nata tapduknga na aminbamde notnaapaat Anututane angelanaat gatu Nanatane kakaa akngane yuke apnim gwene nata aminu waapae unzakan yuke masa asimit,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Siwan wamu waaknga yakenga Jesuta anzing yanikut, “Nata siakande siknga daninggat. Aminu ayuaingu kundu dua kumning gwene kawawa tapduknga Anututa amin panangge tasinggak kakngata apan kaning,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Siwan masande tapduu katau kuut musa kautduanganu gwendu ngang kawa sandewana Jesuta Pitaat Jems gatu Jon nganggan pake ita tawanu mamaya siknga dakatune yanipakopbut. Yaniwan koke yuwawa Jesuta aminu inata kundu dakngawan kainata kaking. ");
INSERT INTO wnc_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Kawawa itane tauknga kwaknga siknga siwan waenga siknga sikut. Aminu keunenana tapatuta tauknga tasiwan kwaknga unzingu sinanga dua. ");
INSERT INTO wnc_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Siwan kawawa baminu akumbing katangga Ilaijaat Moseskatda anggaman siwat kaking. Kawawa waapaatda Jesuat wamu yaking. ");
INSERT INTO wnc_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Yawawa kake Pitata Jesu anzing inikut, “Aana. Ninu ane take siknga yuamang. Nindupewi ninda gepa gweaat gwenduat mitapnim. Gwendu gae siwan gwendu Mosesde siwan gwendu Ilaijae,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Dasingge wa aminu akgwauking. Akgwauke Pitata wamu zaaknga yawit ngang natapan maiwan wamu waaknga yakut. ");
INSERT INTO wnc_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Yawan minga dakatuta apu wamakusiwan wamu takngatu minga ganang katangga anzing yakut. Aminu waapa natane waaknga. Nata ie take siknga nataat. Siwan ginda itane gen gwaamutnong ngang yawan ");
INSERT INTO wnc_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","natake zetgaman katakuke ngana aminu tapatu dua kaking. Jesu awiapatakan wa amikat yuking. ");
INSERT INTO wnc_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Siwan tawandaka ateke pukuyuk Jesuta wamu kekeknga anzing yanikut. Sanga ginda wa kaingge ie aminu tapatu ginda ma iniwam. Kuku tapduknga na aminbamde notnaapa matmat katangga gatu enawit gwenea yaninong ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Siwan wamu waaknga gitna take natagwaanguke ina anzing yaking. Wamu matmat teke enawikge yanggau waakngae yapii dasing ngang yake ");
INSERT INTO wnc_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","anzing inikwaiking, “Dasingge mama wam yanindamumsa aminda yake, ‘Ilaijata gamok apana aminu Anututa tapan Krais gatanimuyaapa dakngake masan apik,’ ngangu yakaing,” ngang inikwaiwa ");
INSERT INTO wnc_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","yake anzing yanikut, “‘Ilaijata gamok apuke sanga kuupbam tanomanuwik,’ ngang siakande yakaing. Ngana nata daniwa natapnong. Ilaijata gwa apbut. Apan kake Judianana aminda inae banip tawake sanga wai takngatu takngatu ie tasingamuke tanguwa kupan wamu tupa yakapbut taknga buyana unin aawan kakumang,” ngang yanikut. “Siwan ngana wamu takngatu yakapsa aminu tapatuta na aminbamde notnaapae natake aminda masa namuyuk tokngabam nae namuning ngang tupa siknga matakut taknga buyana dua aawik ba dasing nataaing,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Siwan Jesuat pandetna waakwakatda tawandakaneta epuke pandetna kunduta yuking komune kundoke kawawa aminbamda pandetna waakwau yupbasiwawa Mosesde mama wam yanindamumsa aminu kunduat wa pandetnaat yanganuwawa kaking. ");
INSERT INTO wnc_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Sike apunggawa kake aminbamu wa yukingga asatnake ie isapmake kuke gaak wam iniking. ");
INSERT INTO wnc_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Siwan ita pandetna anzing yanikwaikut, “Ginu wa amikat minae yakaing,” ngang yawan ");
INSERT INTO wnc_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","aminu tapatu aminbamu wa yukikatnana tapatuta Jesue yake anzing inikut, “Yanindamumsaapa. Natane waaknga waung waita tapan gena kusiwan nata gae takaput,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","“Tapduk bamu asinggan waung wai waapata kekeknga tapan kepdakane pimamban aapna kwakngata genane akopa ita gena sambuwawan gupna gatukande akekekanggak. Siwan nata pandetda waung wai waapa inikwasitningge yaniwa ngana tasinanga dua,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Iniwan natake ita aminbam anzing yanikut, “Ginu Anutue natapa siakan dua siwan yamandet sikaing amin! Na gikat gatake yuke asinggan dandupewa ginda meya aknga nama gwaamuba take dua siwik. Ginda waatdaka waapa nae takapnong,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ngang yaniwan waatdaka waapa ie takapuwawa waung waita Jesu kake zetgaman waatdaka waapa tandambanuwan kepdakane pimake mukwaiwan aapna kwakngata genane akopbing. ");
INSERT INTO wnc_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Unzing tasiwan kake Jesuta itane nana anzing inikwaikut, “Tapduu datdasing ita unzingu sike yuak,” ngang iniwan, “Tupa siknga ita engang yukuune,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","“Siwan tapduk asinggan waung wai waapata tasiwan maiwikge natake katap gwekatang gatu yanggaatang ngang muban pukunggak. Ngana gata sandekngamunanga take kakengu ninde butaya natake gatanimuyo,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Iniwan yake anzing inikut, “Aminu Anutue natapan kekeknga singgak kapata sanga kuupbam tasinanggengu take tasinanga ngang natayak gamu unzingu dua naniwim,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Iniwan zetgaman nana waapata anzing yakut, “Na Anutue natapa kekeknga singgak ngana kekeknga siknga siwikge gatangamuyo,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Iniyuwawan aminbamda ie isapmake apu yupbasinangge tasiwa kake ita waung wai waapa kaanga anzing inikut, “Ga waungu waatdaka aapa tapi genaat maakngaat kusikut tapa nata ga ganinggat. Gata waatdaka aapa teng! Teke gata gatuka i ma tapim,” ngang iniwan ");
INSERT INTO wnc_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","waung wai waapata kumzang ainggamatayuk waatdaka waapa kumzang tandambanuke ateke kukut. Kuwana waatdaka waapata kupsaapa yuwawan kake aminbamda, “Gwa kungwanggak,” ngang yaking. ");
INSERT INTO wnc_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Siwan ngana Jesuta katakngine take tangenawan ita dandam yukut. ");
INSERT INTO wnc_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Siwan masande Jesuta yoakatang kopana pandetnatakan undang koke anzing inikwaiking, “Dasingge ninda waung wai waapa inikwasitnanga dua,” ngang iniwa ");
INSERT INTO wnc_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","ita yake anzing yanikut, “Tumuk wamu dua yakengu waung wai inikwasitnanga dua,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Siwan you wanggapma teke kusika Galili kep komune iat pandetnaatda unekan gatake kuwawa pandetna yanindamutnangge natake ita undang yuak ngang aminu tapatuta dua natapikge natake kuking. Kuyuk anzing yanikut, “Aminu tapatuta na aminbamdane notnaapa aminde yaman nuwa kupit. Kungwake tapduu gweaat gwenduat yuke gatu gweawit,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Siwan ngana wamu waakngatane yapii anggaman dua natake inikwaitnangge akgwauking. ");
INSERT INTO wnc_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Siwan Kapaneam yot gapmane kundoke yoakatang kokenga Jesuta pandetna anzing yanikwaikut, “Kepiapane apuyuk ginu wamu dasing kaknga yaing,” ngang yanikwaiwan ");
INSERT INTO wnc_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","ngana ininangge meptake wamna wena. Kuma yuking. Dasingge? Kepiapane apuyuk wa aminda, “Ninu itane pandetnaat nana mamin tapata nindane buyambam tapa yuak,” ngang yake yanganuking. ");
INSERT INTO wnc_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Siwan ita pukwike pandetna katau kuut musaat kepianganu tapaaya yayawamban apana ita anzing yanikut, “Aminu tapatuta tupan tapa yutnanggengu ita masan siknga yuke aminu kuupbam gatayamunangge yuyok,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Yanikenga ita waatdaka tapatusimu katakngata take takapuke banakan teke betayuk anzing yanikut, ");
INSERT INTO wnc_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Aminu tapatuta nae natanggamatake waatdaka umana wena tapatusimu aapasim binga gatangamiu waapata na kuut gatangamunggak kapa unin. Siwan aminda na gatangamiu waapata natane Nana atnanitewan apbum tapae kuut gatangamunggak kapa unin,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Siwan Jonda anzing inikut, “Yanindamumsaapa. Ninda kawatna aminu tapatuta yake, ‘Jesuta na gatangamunggak,’ ngang yayuk waung wai yanikwasiwan kuwa kake nikatnana duaapa ngang natake ninda asinindakngakumang,” ngang iniwan ");
INSERT INTO wnc_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","yake anzing yanikut, “Ginda waapa ma inindakngawam. Aminu tapatuta nae umana yayuk duya takngatu tasikengu ita nae sapdut wamu zetgaman dua yawik. ");
INSERT INTO wnc_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Aminu ninda pimanimde dua natake tasinggak kapa nindane notnin daknganggak. ");
INSERT INTO wnc_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Sike aminu tapatuta gin danduke Anututa tapan Krais gatanimuyaapa dakngake yuak kapaat gatu itane pandetnaat gatayama ngang natake yangga kap gomune ginde daman atangopning. Unzing tasiwanu Anututa sanga tapatu aminu waapae siakande siknga ngang yake asimik,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Sike aminu tapatuta tasiwan aminu umana wena tapatu nae natapan kekekanggau aakwakat nana tapatuta pimapanu aminu wa atasiwan pimakut tapata tokngabam papik. Siwan suu buyambamu gwendu guyakngane wamake yanggabam gwene muba pukuke kupik gamu wai waaknga dua tasike toknga buyambamu dua papan,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","“Sike gatane katakgata tasiwan ga waiakngaatang pimakengu gata apatdakngake mumbi kuwan take siwik. Apatdakngake mumbi kuwan katakga tapatukan siwan wai waakngaatang dua pimake kayuk yuwiyak kaknga take yukengu wai dua siwiyak. Sike ga katakga dua patdakngawi tapaaya siwan wai waakngaatang pimakengu ga katau dua kungwake asinggan isiyuak gwekatang kuwi wai siknga siwik,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","(Sike keu waopatangu binda nake dua kungwakaing. Siwan katapda asinggan yasinggak.) ");
INSERT INTO wnc_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","“Siwan gatane kepikata tasiwan ga waiakngaatang pimakengu gata apatdakngake mumbi kuwan take siwik. Siwan gatane kepika tapatukan siwan wai waakngaatang dua pimake gata kayuk yuwiyak kaknga take yukengu wai dua siwiyak. Sike kepika dua patdakngawi tapaaya siwan wai waakngaatang pimakengu ga katapatang muba kuwi wai siknga siwik,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","(Sike keu waopatangu binda nake dua kungwakaing. Siwan katapda asinggan yasinggak.) ");
INSERT INTO wnc_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","“Sike gatu gatane kaikata tasiwan ga waiakngaatang pimakengu gata akwagike mumbi kuwan take siwik. Siwan ga kaika gwendukan siwan wai waakngaatang dua pimake gata Anututa amin panangge tasinggak kakngae gepbiatang koke yukengu wai dua siwiyak. Sike ga kaika dua kwagiwi gweaya siwan wai waakngaatang pimakengu katapatang muba kuwi wai siknga siwik,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","“Sike keu waopatangu binda nake dua kungwakaing. Siwan katapda asinggan yasinggak,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Sike wamu wa yanggat taknga tasikengu pangu pasiwan nanamu kaa siknga singgak bingata ginu nomana siknga yutning. ");
INSERT INTO wnc_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Pangu sanga take siknga. Ngana panggane kaa taknga sipna siwanu ginda take dasing tasiwa kaa gatu siwik? Wena. Siwan ginu sanga noman yutnanga aknga banipzaatang yuwan ginu notzaat take siknga yanggatake yutnong,” ngang yakut. ");
INSERT INTO wnc_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Siwan Jesuta enake keu waomu teke kuku Judia keu Jodan yangga apata wesiwan kautdu saak yuaing aminde kukut. Kuwan aminbamda kake ie kuku doke yuking. Doke yupbasiwawa ita asinggan tasinggak kaknga tasike Anutue wam yanikapbut. ");
INSERT INTO wnc_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Siwan Ferisi aminu kunduta i tasiwa siwikge natake ie kuke anzing inikwaiking, “Aminu tapatuta maatna inikwasiwan kuwanu Mosesde mama wamu asandewik ba dasing,” ngang inikwaiwa ");
INSERT INTO wnc_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","yake anzing yanikut, “Mosesda mama wamu dasing matakut taknga akendekaing,” ngang yaniwan ");
INSERT INTO wnc_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","anzing yaking, “Mosesda aminda pepa maya sandekaingu sandu take matake maya take sandewik,” ngang iniking. ");
INSERT INTO wnc_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Iniwa yake anzing yanikut, “Mosesda natake aminu yamandet sikaing amin ngang natayamuke mama wamu waaknga matakut. ");
INSERT INTO wnc_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Tupa siknga Anututa sangabam tasike ita aminu wawiat mayaat ngang tumukut. ");
INSERT INTO wnc_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Unzingge wawita nana minga peke kuwan maatnaat gatake unekan yutzan. ");
INSERT INTO wnc_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Yuke waapaatda tapaaya binga dua yutzan. Wena. Waapaatda sanga tapatukan binga dakngake yutzan. ");
INSERT INTO wnc_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Unzingge sanga Anututa gwa tapan gatapbuu aminda zipmandakngake sandetnanga dua,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Siwan masande iat pandetnaatda yotnane koke pandetnata wamu waakngae inikwaiwa ");
INSERT INTO wnc_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ita anzing yanikut, “Aminu tapatuta maatna sandeke gatu tapatu tapiu wawi waapata yasewaapa daknganggak,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","“Sike maya tapatuta apna teke wawi tapatu takengu maya waapata yasewaapa daknganggak,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Siwan waatdaka mateu ita katakngita wasiyuk wam kwikwik yaniwikge pakapbing. Pakapa kake ngana pandetnata kaanga yaniwa ");
INSERT INTO wnc_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","kake Jesuta musia wai natayamuke anzing yanikut, “Ginu kapewa waatdaka mateu nae apnong. Ginda ma yanindakngawam. Aho. Aminda waatdaka aakwakga nae nangaakan dua nataaing binga daknganingu Anututa amin panangge tasinggak kakngae gepbiatang yuaikatnana aminu unin,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","“Nata siakande siknga daninggat. Aminu tapatuta Anututa amin panangge tasinggak kakngae gepbiatang kopnangge ngana waatdaka binga dua dakngakengu ita undangu kopnanga dua. Wena siknga,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Yanikenga waatdaka waakwak inandek inandek betayuk wam kwikwik yamukut. ");
INSERT INTO wnc_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Siwan Jesuta enake kuwawan aminu tapatuta ie isapmake kuku ie muna puke anzing inikwaikut, “Yanindamumsa noman tapa. Nata dasing tasike kayuk yutnanga aknga pake kayuk asinggan asinggan yuwit,” ngang inikwaiwan ");
INSERT INTO wnc_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","yake anzing inikut, “Dasingge gata, ‘Yanindamumsa noman tapa,’ ngangu naninggayak? Anutu awiapatakan noman tapa yuak. ");
INSERT INTO wnc_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Gata mama wamu anzingu atnataayak. ‘Gata aminu ma zipim. Gata yasewa ma tasiwim. Gata kukae ma papim. Gata amin notdae kemu ma yaniwim. Gata kait pasiyuk amindane sanga ma papim. Gata nangga minggae wam gwaamuke ie gepbiatang yuyo,’ ngangu atnataayak,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Iniwan yake anzing inikut, “Yanindamumsaapa. Na tapduknga waatdaka yukum gweneta apu apman na mama wamu wa kuupbam tawamba sandekgak,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Iniwan katasike ie musip gwaang natake Jesuta anzing inikut, “Ga sanga tapatuekan dapmanggayak. Ga kuke sangaka kuupbam aminde yami usinong. Usike mani gama pake sangaapana wena aminde yami puyuwan take siknga kayuk yuwiyak kakngaka enandang yukgamuwawan pandetna daknawi naat gaat kusim,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Iniwan wamu waaknga natake nomna maiwan musia meya siwan ateke kukut. Dasingge? Itane sangaapana buyambam siknga. ");
INSERT INTO wnc_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ita kuwawan Jesuta pandetnabam katakuke anzing yanikut, “Anututa amin panangge tasinggak kakngae gepbiatang kopnanggengu aminu sangana babanda tasiwa maiwik,” ngang yaniwan ");
INSERT INTO wnc_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","natake asatnaking. Siwan ngana wamu yake anzing yanikut, “Waatdakana! Anututa amin panangge tasinggak kakngae gepbiatang kopnanggengu aminda kwatan siknga tasining. ");
INSERT INTO wnc_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ikwawa gamanda tauk bupmakge ganangiatang kopnanggengu ita kwatanu aminu sangana buyambamu kayata Anututane kekeknga aknganane kopnangge tasining binga dua,” ngang yaniwan ");
INSERT INTO wnc_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","natake ngana kumzang satnake ina anzing yaking, “Unzing kakengu maminda kayuk yutnanga aknga pake asinggan yuwik,” ngang yawa ");
INSERT INTO wnc_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesuta asiknga kanggamatake anzing yakut, “Aminda unzingu tasinanga dua ngana Anututa sangabamu tasinangge natakengu atasiwik. Ita gatayaman moo amikat gatu aminu sangaapanababan takwakatda kayuk yutnanga aknga pake yutning,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Siwan Pitata yake wamu takngatu anzing inikut, “Natapso! Ninu sangabamin peke gaat unekan gatake sukukamangga kayuk yutnim taknga apanim ba dasing,” ngang inikwaikut. ");
INSERT INTO wnc_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Inikwaiwan yake anzing yanikut, “Nata siakande siknga daninggat. Mamin amin takwakgaka nae natanggamatake gatu wama takeaknga ngang yanikapnangge natake yotna ba uyapna ba paana ba samina ba minga ba nana ba waatdakana ba puyana peke kuke natane puyana pasiwanu ");
INSERT INTO wnc_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Anututa yake sangabamu isakoke kwaapzang 100 binga ayamik ngang yanikut. Sike wa aminu dua kumning gwekatangu Anututa yake you buyambam gatu uyapna buyambam gatu paana buyambam gatu samina buyambam gatu minga buyambam gatu nana buyambam gatu waatdakana buyambam gatu puyana buyambam yaman paning. Siwan aminu nae masa namukaing aminu kunduta aminu nae natanggamatake natane puya tasitakuning aminde toknga takngatu takngatu yama paning ngana masande wa aminda kayuk yutnanga aknga pake kayuk asinggan asinggan yutning,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","“Sike aminu tupan takwak dakngake yuaingu kunduta apu masan amin daknganing. Siwan aminu umana wenaakwak dakngake yuaingu kunduta apu tupan amin daknganing,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Siwan kepiapane kusika Jerusalem kopnangge kuking. Kusika Jesuta gamok pandetna peke tupan kuwawan kake dasingga natake nipmake kunggak ngang natake pandetnata nangaakan natayuke musia meya buyak kuwawa kake aminbamu ayawaking amikaya unzakan natapbing. Unzing natake kuwawa Jesuta pandetna katau kuut musaat kepianganu tapaaya ngang pake tuwanguke sanga ie apik kakngae wam yake ");
INSERT INTO wnc_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","anzing yanikut, “Natapnong. Apmanu ninu Jerusalem kopnim. Koke aminu tapatuta na aminbamde notnaapa dakngake yuat tapa Anutue yot takwan gwene pasiya amikat gatu mama wam yanindamumsa amikatde kataune yamik. Yaman napmake wamu atnuningge wam yawa kekekawan dongu kundune nana Anutue dua nataaing aminde yamuning. ");
INSERT INTO wnc_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Yama sapdut wam nanike aapda sutnapbike ipmapa nuke nuwa kupit. Kungwake tapduu gweaat gwenduat yukenga gatu enawit,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Siwan kepiapane kusika Sebeditane waaknga tapaaya umana Jems gatu Jon ngang yaniking kapaatda notnabam peke Jesu ininangge kuke anzing inikumayak, “Yanindamumsaapa. Nitde sanga takngatu tasinimiyakge natamak,” ngang iniwat ");
INSERT INTO wnc_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","yake, “Giu nata gitde dasing kaknga tasindamitde natamayak,” ngang yanikwaikut. ");
INSERT INTO wnc_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Yanikwaiwan yake anzing inikumayak, “Masande ga enane siknga buyambam tapa dakngake yuke gata nit papi nitda umaniu kaya dakngake gaat gatake unekan yutnim. Tapatu katakga siyaapane yuwan tapatu katakga kwanaapane yuwik,” ngang inikumayak. ");
INSERT INTO wnc_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Iniwat ngana yake anzing yanikut, “Giu sanga atnanimayak kakngae katak dua natamayak. Meya nata wa kawit takngata gitde apan kake ngana gitda undang dua ba pimatzang ba dasing,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Yaniwan, “Ngan nitda dua pimatzim,” ngang yake iniwat yake anzing yanikut, “Siakan. Meya nata kawit taknga gitdaaya waaknga akasan. ");
INSERT INTO wnc_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Siwan ngana Anututa dua naniwan kapewa aminu tapaata kataknga siyaapane ba kataknga kwanaapane ngangu yuke tasan. Aho. Kekeknga waaknga aminu tapaae Anututa gwa tandakngake teyamukut tapaatdakan tasan,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Siwan pandetna katau kuut musaatda wamu waaknga natake waapaatde bania toknga natayamuwawa ");
INSERT INTO wnc_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","ngana Jesuta yayawamban ie apa anzing yanikut, “Ginu atnataaing. Aminu buyambam tapa apa dongu kundune nana Anutue dua nataaing aminda yaipapakusike enane yuaing. Siwan aminu buyambam tapa apatane aminabamda wa aminde wam tawaningge kumzang kekekakaing. ");
INSERT INTO wnc_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ngana ginda unzingu ma tasiwam. Wena. Aminu gikatnana tapatuta ginde buyambam tapasa dakngananggengu ita gin gatandamuyaapa dakngayok. ");
INSERT INTO wnc_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Siwan aminu ginde tupan tapasa dakngananggengu ita puya aminza dakngayok. ");
INSERT INTO wnc_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Dasingge? Na aminbamde notnaapa dakngake yuat tapa aminda nae puya pasingamuningge dua apbum. Wena. Apuke puya tasike amin gatayamunangge natake apbum. Apuke kungwayamit takngata iwana zipmake yawamba kuwa aminbam sandeke papitde apbum,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Siwan Jeriko yot gapmane kundoke gatu teke iat pandetnaat gatu aminbampatda unekan gatake kuking. Gatake kuwawa aminu tapatu kai kukgweat kusikumayau tapatu umana Batimias ngang iniking. Timiasdane waaknga. Ita kepi kwaimune pukwike aminde mani imuningge yayawanggak. ");
INSERT INTO wnc_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Yayawake natawawan tapatuta yake Jesu Nasaret nanaapata apunggak ngang yawan natake apaa anzing yanggamatakut, “Jesu! Ga nindane Buyambamtapa. Ga Devitdane dongune aakuyak kapa. Gata nae butaya natapso,” ngang yawan ");
INSERT INTO wnc_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","aminbamda, “Ga genda umukusing,” ngang kaanga iniwa natake ngana ita apaa siknga yanggamatake, “Devitdane dongune aakuyak kapa. Gata nae butaya natapso,” ngang yakut. ");
INSERT INTO wnc_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yawan natake Jesuta pakapu yuke, “Ginda yatawamba apan,” ngang yaniwan natake kai kusikuu waapa yatawake anzing iniking, “Musipba kekeknga siyok. Gae yanggawanggak. Enat!” ngang iniwa ");
INSERT INTO wnc_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","ita got tauknga waike mutewan kuwan pupzang enake Jesue kukut. ");
INSERT INTO wnc_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Siwan Jesuta anzing inikut, “Ga nata dasing tasinggamitde natayak,” ngang inikwaiwan natake ita yake, “Aana. Na kaina take tasingamiyakge nataat,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Iniwan yake anzing inikut, “Ga undang kunggayo. Musipbaatang nae natapi kekekak kakngata gatanggaman kaika take gwa sikamayak,” ngang iniwan zetgaman kaina kukgweat take siwat ita gatuna kake Jesu tawamban kuking. ");
INSERT INTO wnc_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Siwan kusika Jerusalem wesim kundoke you Betfasi gapmaat Betani gapmaatda tawanu Oliv daka gepbine yuamayak gapmaaune kundoke Jesuta pandetna tapaaya yanipewan kusande ");
INSERT INTO wnc_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","natake anzing yanikut, “Gitda you wesimu atugapmasimu kaamayaune kuke you wanggapmane koke zetgaman ikwawa gamanu aminu tapatuta masene dua pukwikuu gwendu napda tewatanguwan wamateinga kasan. Kake waike takapzon. ");
INSERT INTO wnc_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Sike aminu tapatuta danduke, ‘Dasingge gitda unzingu tasikamayak,’ ngang daniwanu gitda anzing inison, ‘Buyambam tapata anggwende puya kaya siwan ita zetgaman gatu apme tewan apik,’ ngang inison,” ngang yanipewan kukumayak. ");
INSERT INTO wnc_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Yanipewan kuke ikwawa gamanu gubanga gwendu kakumayak. Kawawat toikngata you gwendutane gwabok gwaune wamatewa kepman kepiapa wesim yuwawan kake nap taknga awaikumayak. ");
INSERT INTO wnc_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Awaiwawat aminu kundu wesim yukingga kake anzing yaniking, “Giu dasing tasinangge ikwawa gamanu wagwenu waikamayak,” ngang yaniwa ");
INSERT INTO wnc_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","wamu Jesuta yakut taknga ngang yanikumayak. Yaniwat natake kapewa ");
INSERT INTO wnc_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","ikwawa gamanu gubanga wagwenu Jesue takukumayak. Siwan waapaatda tauknga kundu masene pewat Jesuta une pukwike kukut. ");
INSERT INTO wnc_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Kuwawan aminbamda kake Buyambam tapana initakuningge natake got tauknga kepiapane usiking. Siwan kunduta puyane kuke katap kaing patdeke kepiapane usiking. ");
INSERT INTO wnc_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Siwan aminbamu kundu tupan kuwawa kundu masan apuyuk anzing yanggamataking, “Umana yatangetnatnong! Anututa initewan apan kana take siknga singgak,” ngang yaking. ");
INSERT INTO wnc_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“Bamindane tupan tapa Devitda kayukut taknga gatu tangenake ninduyuwik kapa Anututa gatangamuyok. Enane siknga yuak kapatane umana yatangetnatnong,” ngang yaking. ");
INSERT INTO wnc_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Siwan Jesu Jerusalem kundoke Anututane yot takwan gwene koke sanga kuupbamde katakuwan puyuwan gunzitda apukunangge dapaknga siwan kake kepman epuke you wanggapma teke iat pandetna katau kuut musaat kepianganu tapaaya ngakatda Betani yot gapmane kuking. ");
INSERT INTO wnc_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Siwan tembana Betani yot gapma teke Jerusalem gatu kopnangge kepiapane kusika Jesu tomna natapbut. ");
INSERT INTO wnc_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Natake kawan baau dakatu maasim tatakngi buyambam yuwan kakut. Kake ita inengan buyana kundu kanangge kukut. Kuke kawan ngana buya wena kakut. Tatakngikan kakut. Dasingge? Tapduknga baap dakata buya aatnanga tapduk dua sikut. ");
INSERT INTO wnc_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Siwan Jesuta bania toknga natake baau wandakae anzing yakut, “Ga buyaka gatu masande ma aawim. Wena siknga,” ngang yawan pandetnata wamu waaknga natapbing. ");
INSERT INTO wnc_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Siwan Jerusalem kundoke Jesuta Anututane yot takwan gwene koke kawawan aminu sangaapa yot gwene pakoke pewa apu usiwawa kake aminu wa tasikingu kuupbam yanikwasiwan kepman epuwawa ita tebo wa aminda manina sanis pasiking amindane pangenapamapan kuwa ita aminu kwait usiningge apukwike tasiking amindane sia kuut pangenapamapan kuking. ");
INSERT INTO wnc_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Siwan ita dua kapewan sangabamu pake Anututane yot gwekatang kopbing. Unzing yanindakngake ");
INSERT INTO wnc_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","anzing yakut, “Anutue wamda anzing yakut, ‘Natane yotna dongu kuupbamda tumuk wam naniningge yot gwen yuak,’ ngang yakut. Ngana ginda tasiwa kuka aminde yot gwen binga daknganggak,” ngang yakut. ");
INSERT INTO wnc_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Siwan Anutue yot takwan gwene pasiya amindane takeakwakat mama wam yanindamumsa amikatda wamu waaknga natake tuwanguke kepi takngatu Jesu tanguwa kupikge kanangge tasiking. Dasingge? Aminbamda itane wam natapa musia asenawan kake Jesue akgwauking. ");
INSERT INTO wnc_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Siwan bangee Jesuat pandetnaatda Jerusalem teke kuking. ");
INSERT INTO wnc_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Siwan tembana kepiapane kusika kawa katau baau wa inikut dakata gwa kupiakutna kaking. Tatakngiat muyakngi kuut gwa kupiakutna ");
INSERT INTO wnc_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","kake Pitata anzing inikut, “Aana. Kayo. Katau baapdaka gata kweu buya dua aawikge inikuyak dakata gwa kupiak,” ngang iniwan ");
INSERT INTO wnc_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","yake anzing yanikut, “Ginda Anutue natapa kekeknga siyok. ");
INSERT INTO wnc_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Siakande daninggat. Aminu tapatuta musiane takngaaya dua natapik. Wena siknga. Ita baniaatang anzing natapik. Siakan. Nata yawa buya asaawik ngang natapan kekeknga siknga siwanu ita tawanu andaka enake yanggabam gwene isakuwikge yawanu sanga aminu waapata ayawik kaknga siakande buya asiwik,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","“Siakande daninggat. Ginda tumuk wam yake sanga tapatu siwikge yaning kakngae natake Anututa sanga waaknga atasinimunggak ngang natapa kekekawanu sanga wa ginda ayaning kaknga asiwik,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","“Siwan ginda tumuk wam yayuk wai takngatu aminu tapatuta ginde tasindamukut takngae natake banipzaatang sandekngamunong. Sandekngama gindane Nanza enandang yuak kapata gindane waiakngasa ina unzakan asandetdamik,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","(“Siwan ngana ginda aminu kundutane waiakngana dua sandewanu gindane Nanza enandang yuak kapata gindane waisa dua sandewik,” ngang yanikut.) ");
INSERT INTO wnc_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Siwan kepiapane kusika Jerusalem yot gapmane gatu kodopbing. Kodoke Jesuta Anututane yot takwan gwekatang koke sukuwawan Anutue yot takwan gwene pasiya amindane takeakwakat gatu mama wam yanindamumsa amikat gatu Judia amindane take amikatda ie kuke ");
INSERT INTO wnc_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","anzing iniking, “Ga maminda tapan sanga waaknga tasinggayak,” ngang inikwaiking. “Maminda ga tapan puya waaknga pasinggayak,” ngang inikwaiwa ");
INSERT INTO wnc_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","yake anzing yanikut, “Nakaya wamu takngatu gin danikwaiwit. Sike ginda nae wamu yake atnaniwanu nakaya maminda na tapan puya waaknga pasinggatde daniwit. ");
INSERT INTO wnc_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Jonda aminbamu yangga sauyamukut taknga enandang nanae sanga ba aminde sanga ba dasing? Ginda yake naninong,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Yaniwan natake ina anzing yaking, “Ninda, ‘Enandang nanae sanga,’ ngang yananu ita anzing yake niniwik, ‘Dasingge ginu ie siakan ngang dua natapbing,’ ngang niniwik. ");
INSERT INTO wnc_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Sike ninda, ‘Aminde sanga,’ ngang yanangge apmeptakamang,” ngang yaking. Dasingge? Aminu kuupbamda Jonde natake ayanikapsaapa siakande siknga ngang natapa kake wa aminu siakan dua ngang yanangge akgwauking. ");
INSERT INTO wnc_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Akgwauke Jesu yake, “Ninu dua nataamang,” ngang iniwa yake Jesuta, “Nakaya ginu puya waaknga na maminda tapan apu pasinggatde dua daniwit,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Siwan Jesuta tuwang wamu kundu yanike anzing yakut, “Aminu tapatuta wain tapunde puya kwaike wamambasike wain tapun yainggamuwawa yanggata pukuke dopikge gapma kwaike you mamaya siknga kuka aminde kayutnangge mitapbut. Unzing tasiwan puyuwana ita puya waanga aminu kundue kataune yaman kayukngamuwawa buya aawan deke usanzike kautdu gisae pake kautdu ninae namunong ngang yanike ita keu maa siknga komdune kukut. ");
INSERT INTO wnc_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Kuke yuwawan wain tapun detnanga tapduknga gwa siwan natake ita puya amina tapatu initewan ita aminu wain tapunde puya pasiya aminde kukut. ");
INSERT INTO wnc_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Kuwan ngana aminu waapa tanggaganuke kumzang tanguke inikwasiwa moo siknga kukut. ");
INSERT INTO wnc_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Siwan ita puya amina tapatuat initewan kundopan waapaaya gwapakngine tanguke wai siknga tasingamuking. ");
INSERT INTO wnc_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Siwan ita puya amina tapatuat initewan kukut. Siwan wa aminda waapaaya atanguwa kumbut. Siwan ita puya amina kwaapzang inandek inandek yanipewan kuwawa ngana wa aminda kundu zipmake yawamba kuwawa kundu atzipa kumbing,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Siwan ita waaknga awia tapatukan ie musip gwaang nataak. Siwan masan siknga ita anzing yakut, ‘Wa masan siknga ita aminu natane waakngae wamu apme natapning,’ ngang yake waaknga waapa initewan puya pasikaing aminde kukut. ");
INSERT INTO wnc_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Kuke kuwawan kake ngana aminu puya pasikaingga ina anzing yaking, ‘Aminu aapata nanatane kwatangi kuupbam papik,’ ngang yaking, ‘Ninda tangutna kupan puya aanga nisae tana,’ ngang yake ");
INSERT INTO wnc_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","take tanguwa kupana gupnaapa puyaangane kepman mutewa kukut,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Tuwang wamu waakngae danikwaiwit. Wain tapunde puya waangatane toikngata dasing tasiwik? Ita apuke aminu puyaangane pasiya aminu atzipa kupana ita puya waanga aminu kundue yamik,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","“Anutue wapatang wamu takngatu anzing yakut, ‘Suu gwendu yot mitapsa aminda kake wai pupuknga ngang yake mutewa kukuu wagwenu yotde tepa kusiwan yot gwen tapan kekekanggak. ");
INSERT INTO wnc_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Anutu Buyambam tapata sanga waaknga tasiwan kake asatnakamang,’ ngang yakut taknga ginda dua binga kendeking aminda nanikaing,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yaniwan natake, “Tuwang wamu waaknga ninde yanggak,” ngang natake Jesu tanggaganutnangge natapbing ngana aminbamde akgwauke i ateke kuking. ");
INSERT INTO wnc_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Siwan wa aminda Ferisi aminu kundu gatu Herotdane aminabapat Jesue yanipewa kuke Jesu tanzitna pimapikge wam kuke inina ngang natake kuking. ");
INSERT INTO wnc_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Kuke anzing iniking, “Yanindamumsaapa. Ga siakan wamde toiknga ngang nataamang. Siwan gata ninindamuke yawa naninang ngang natake dua gwaukgayak. Wena. Siakan wamban gata maya wawi Anututa take nataak kakngakan yanindamukgayak. Ga dasing nataayak? Ninu Judianana aminda takis mani gavmanu Sisae imukengu ninda Anutue mama wam sandetnim ba dasing,” ngang iniking. ");
INSERT INTO wnc_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Iniwa ngana Jesuta wa amindane kem takngana atnatake anzing yanikut, “Ginda dasingge na tanzitnangge tasikaing? Mani sandu nae takapa kawit,” ngang yaniwan ");
INSERT INTO wnc_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","mani sandu takapu ima take anzing yanikwaikut, “Mani asanu weenaat gatu umanaau mamindane matakinga kaaing,” ngang yanikwaiwan yake, “Sisatane,” ngang iniking. ");
INSERT INTO wnc_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Iniwa yake anzing yanikut, “Sanga Sisatane wa ginda Sisae imunong. Siwan Anututane sanga ginda Anutue imunong,” ngang yaniwan natake, “Ita pimapikge tanzike tasina mainggak,” ngang natake nangaakan natapbing. ");
INSERT INTO wnc_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Siwan, “Aminu akungwakengu uyunga dua enakaing,” ngang yaya aminu Sadyusi ngang yanikaing. Siwan Sadyusi aminu wa kunduta Jesue kuke anzing inikwaiking, ");
INSERT INTO wnc_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Yanindamumsaapa. Mosesda ninde baminde wamu takngatu tupa siknga anzing matakut, ‘Aminu tapatuta maatna take ngana waaknga wena siwan yusika akupanu maya kombakobau waapa wawi waapatane uyapnata take waaknga paanae tangge tangamuyok,’ ngang matakut. ");
INSERT INTO wnc_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Sike inaakwau katau kuut musa kautdu tapaaya ngangga yuking. Sike tupan tapata maya take ngana waaknga wena siwan ita akumbut. ");
INSERT INTO wnc_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Siwan uyapna masan tapata maya waapa take ngana waaknga wena siwan akumbut. Siwan uyapna banakan tapataaya unzakan tasikut. ");
INSERT INTO wnc_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Unzakan inaakwau wa kuupbamda maya waapa taking. Siwan waakwau waaknga wena siwan akumbing. Siwan masan siknga maya waapaaya akumbut. ");
INSERT INTO wnc_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Sike masande kupsa aminda enatningu tapduu wagwene maya waapa maminde maatna dakngawik? Ga atnataayak. Inaakwau wa kuupbamda tapa waakwakge maatna dakngakut,” ngang iniking. ");
INSERT INTO wnc_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Iniwa yake anzing yanikut, “Ginu Anututane wamu apmataking kakngaat gatu Anututane kekeknganaatde dua natake wamu gutongang yakaing. ");
INSERT INTO wnc_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Tapduknga akupsa aminda matmat gapmaneta gatu enatning gwene maya wawita angela enandang nana binga dakngake maatnae ba apnae dua kuning,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","“Siwan ngana Mosesda bukatangu wamu takngatu katapdakasimu katapda isikutde matakut taknga ginda kendeke atnatdeking gamu, ‘Akupsa aminda gatu dua enatning,’ ngang dua yawam. Wamu waaknga matake Anututa Moses inikut taknga tupa siknga Mosesda anzing matakut, ‘Na Ebrahamdane Anutuna gatu Aisakgane Anutuna siwan gatu Jekopdane Anutuna,’ ngang matakut. ");
INSERT INTO wnc_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Siwan Anutu akupsa amindane Anutuna dua. Wena. Ita Anutu kayuk yuaing amindane Anutuna ngang dua natake ginda wamu gutonga siknga,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Siwan wamu waaknga ngang yaniyuwawan mama wam yanindamumsa tapatuta apuke nataawan yanganuwa natapbut. Nataawan Jesuta wamu yake yaniwan natapan take siknga siwan ita Jesu anzing inikwaikut, “Mosesdane mama wamu zaakngata mama wamu kuupbamdane tupan siknga aknga daknganggak,” ngang inikwaiwan ");
INSERT INTO wnc_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","yake anzing inikut, “Mama wamdane tupan siknga aknga anin, ‘Ginu Isrel nana! Ginda natapnong! Anutu Buyambamu nisane awia waapatakan ita Buyambam tapa. ");
INSERT INTO wnc_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Siwan gata Anutu Buyambam tapakae banipbaatang gwaam siknga natake musipbaatang ie take siknga natangamuke natdetdetdaatang asinggan asinggan natanggamatake kekeknga akngaka kuupbam ie imuyo,’ ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Siwan mama wamu uneta unesim yuak kaknga anin, ‘Gata aminu gae wesim yuak kapae butaya natangamuyo. Unzing gikae gupba wai dua siwikge natake butaya nataayak binga.’ Sike mama wamu wa takngaaya Mosesdane mama wamu kuupbamdane tupan takngaat dakngake yuamayak,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Iniwan natake mama wam yanindamumsa aminu waapata yake anzing inikut, “Yanindamumsaapa. Gata take siknga yanggayak. Ngan, siakan. Anutu awiaapatakan buyambam tapa. Siwan tapatu wena. ");
INSERT INTO wnc_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ngan. Ninda ie banipmikatang gwaam siknga natangamuke natdetdetnikatang asinggan asinggan natangamuke nindane kekeknga aknganinu kuupbam asimunim. Siwan aminu ninde wesim yuak kapae butaya natangamunim. Unzing nisae butaya nataamang binga. Sike ninda mama wamu wa tawanimde yanggayak kakngaatda tupan siknga akngaat dakngake yuamayak. Unzing yuamayakge sanga Mosesda matakut takngae natake kaap matake Anutue imunangge natake kataune gatukande sawa yasikuningu kuupbam gatu sanga inata kunduat Anutue imukamangu yumdekan binga yuaing,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Iniwan nataawan aminu waapata wamu yake natdetdetna nomanata binga yawan natake Jesuta yake anzing inikut, “Anututa amin panangge tasinggak kakngae gepbiatang kopnangge gata wesim yuayak,” ngang inikut. Iniwan natake aminbamda Jesu wamu kunduat inikwaitnangge akgwauking. ");
INSERT INTO wnc_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesuta Anututane yot takwan gwene yuke aminbam yanike anzing yakut, “Dasingge mama wam yanindamumsa aminda anzingu yakaing, ‘Aminu Anututa tapan Krais gatanimuyaapa dakngake yuwikge yakaing kapae Devitdane dongune aawik,’ ngang yakaing. ");
INSERT INTO wnc_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Anututane Waung Takwan Tapata Devitdane musia tangenawan Devitda anzing yakut, ‘Anutu Buyambam tapata buyambam tapana anzing inikut. Gata umanda kayaapa dakngake yuayakge natane kataknga siyaapane pukwike yuwawi nata iwanda panggaganuke pewa gae gepbiatang koyutning,’ ngang iniwan natapbum,” ngang yakut. ");
INSERT INTO wnc_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Siwan Anututa tapan Krais gatanimuyaapae natake Devitda, ‘Buyambam tapa,’ ngang inikut. Siwan dasingge wa aminu ie natake buyambam tapa ngang dua iniyuk Devitdane dongune aawikapa nganggan inikaing,” ngang yaniwan natake aminu wa yukingga apbakngaking. ");
INSERT INTO wnc_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Siwan Jesuta yanindamuke anzing yanikut, “Ginu mama wam yanindamumsa aminde gwautnong. Wa aminu tauknga mamaya siknga tupan amindane binga wamake kukaing. Kuke sanga usikaing kep komune sukuwawa aminbamda kake umana yapangenake gaak wam yaniningge take siknga nataaing. ");
INSERT INTO wnc_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Sike miti yot gwene aminbamde kaine yutnangge nataaing. Sike sia nanam tapduu tupan dakandakanekan yutnangge nataaing. ");
INSERT INTO wnc_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Sike maya kombakobau apna akupsatane yot kwaamupa pakaingunin. Siwan wa aminu tumuk wamu mamaya waiakngana takusopunangge kem yakaingge wam yaning tapduk gwene toknga buyambam siknga apaning,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Siwan Jesuta mani Anutue mukaing gwene wesim pukwike kawawan aminbamda apu manina pukwit gwekatang pamuwawa kakut. Kawawan sanganambaban aminda manina buyambam siknga pamuking. ");
INSERT INTO wnc_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Siwan maya kombakobau sangana wena tapatu apna gwa kumbut tapata apuke manina gamana mateknga saasimban pamuban kakut. ");
INSERT INTO wnc_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Pamuban kake Jesuta pandetna yayawamban apa anzing yanikut, “Nata ginu siakande siknga daninggat. Kombakobau sangana wena. Apna akumbuu aapata manina buyambam siknga muke aminbamu maninababanda Anutue imukaingu ayapbikgak. ");
INSERT INTO wnc_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Aminu wa kuupbamda manina kwaapzang ngana akotnake mateknga sikngakan pakapu Anutue imukaing. Ngana maya waapa asiknga dapmake ngana ita manina kuupbam muban sangaapana wena singgak,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Siwan Jesuta Anutue yot takwan gwen teke kepman epuwawan pandetna tapatuta anzing inikut, “Yanindamumsaapa. Yot takwan gwen gatu you takeake suu buyambam inata kunduta mitambingu kayo,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Iniwan yake anzing inikut, “Gata you buyambamu anggwegwen kake nangaakan natake yanggayak ba dasing? Apmea amak aminda suu gwendu dua katewa sup notna gwendune engetanganu dua yuwik. Kuupbam zipbuke muba pimaning,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Siwan Jerusalem yot gapma teke pukuke Jesuat pandetnaatda tawanu Oliv dakane koke uneta Anutue yot takwan gwenu kautdu saak yuwan kaking. Kawawa Jesuta pukwike yuwawan Pita gatu Jems gatu Jon gatu Endru nganggakan ie kuke anzing inikwaiking, ");
INSERT INTO wnc_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Gata ninu niniyo. Zaapduknga sanga wa niniyak kakngata aawik? Tuwanga zaakngata gamok apan kake sanga wa apikge dapaknga gwa singgak ngang ninu natdetnim,” ngang iniwa ");
INSERT INTO wnc_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","yake anzing yanikut, “Ginu gwautnong. Aminu tapatuta ginu panziyak. ");
INSERT INTO wnc_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Aminu tapatuta enake apu natane umana Krais gatandamuyaapa ngang yake na aminu waapanin ngang kem danike panziwik. Ina unzakan sipdu sipdune aminu tapatu tapatuta enake apu wamu waakngakan kem yaning. Ina unzakan tasitakuwawa aminbamda kem wamu waaknga natapa siakan siwik,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Siwan masande ginda natawawa, ‘Amau wesim amakaing,’ ngang yawa natakengu ginu nangaakan ma natapam. Siwan amau amnangge yawa natakengu ginu ma satnawam. Sanga wa asaawik ngana tapduknga zet dua sandewik,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","“Aminu dongu takngatuta enake dongu takngatuat amning. Siwan aminu buyambamu tapatutane dongata enake amau aminu buyambamu tapatutane dongaat amning. Sike keu komduiatangu miyamun bam sining. Siwan nanamna wena siwan tomnabam natayutning. Sanga wa asaawa ngana tapduknga zet dua sandewik. Unzing mayata engang tangaiwikge toknga gamok nataak binga,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Gisae katak siknga tagwautnong. Aminda ginu kaunsilnae pakuwa wam yaning. Siwan aminu kunduta ginu miti yot gwekatang pakoke ipmapa dasipning. Siwan aminu kunduta nae umana tanguwa pimapikge tasike ginu paku buyambam tapaapae kaine dapmaning. Dapmaba ginda nae wamu takeaknga ngang yaninong. ");
INSERT INTO wnc_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Dasingge? Aminu kuupbamda nae wamu takeaknga gamok natapana tapduknga asandewik,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","“Siwan tapduknga ginu pakuwa wam yaningge yawanu ginu nangaakan natake ninda wamu zaaknga ngang yanim ngang ma natapam. Wena. Wamu kuupbam Anututa tapduu waomzimunekan atdamiu ginda wamu waakngakan yaninong. Anututane Waung Takwan Tapata wamu takngatu takngatu yeutdaman gisatakan dua yanining,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Sike paanata uyapna wam yaningge yawa zipa kumning. ");
INSERT INTO wnc_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Siwan ginda natane gepbiatang yuwawa danduke semna siknga natandamuning. Ngana mamin amindaka kekeknga yuke meya waakngaatang dua pimake yutningu tapduknga asandewik gwene Anututa kayuk yutnanga aknga wa aminde ayamik,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Siwan ginda kawawa, ‘Sanga wai siknga,’ ngang yakuu kep takwan kopatang tasinanga dua ngana ita undang tasike yuwawan kaning,” ngang yanikut. “Siwan aminda wamu waaknga kendekengu katak siknga natdeyok. Tapduknga sanga wai siknga wa yakuu unzing yuwik gwene aminu Judia kep komune yuaingu datang tawan dakane kopnong. ");
INSERT INTO wnc_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Siwan aminu yotna engatangan gwene yuwiu epu yoakatang sangaapana pananggengu ma kopan. ");
INSERT INTO wnc_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Siwan aminu puyane yuwiu got tauknga tananggengu yotna gatu ma kuwan. ");
INSERT INTO wnc_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Tapduu wagwene maya waak musipna kaya gatu engangge ngawam yaman nakaing aminda meya buyak yutning. ");
INSERT INTO wnc_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Siwan tapduknga ginda atdatakuning gwende natake sanga wa ginde got tapduk gwene dua aawikge tumuk wam yanong. ");
INSERT INTO wnc_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Tapduu wagwene meya buyambam siknga siwik. Tapduknga Anututa kep tasike tekuuneta apu apmanu kuut meya wa binga takngatu tupa dua apbut. Siwan masan kaya meya wa binga wena. ");
INSERT INTO wnc_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Siwan Buyambam tapata tapduu wagwenu dapaknga dua isatakepikge yakut gamu aminbamu wena asiwam. Ngana ita aminu kundu papan aminabam dakngake yuaingge butaya natake ita tapduu wagwenu dapaknga isatakepikge gwa yakut. ");
INSERT INTO wnc_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Sike tapduu waomune aminu tapatuta anzing daniwik, ‘Kanong! Krais gatanimuya apata andang yuak ngang daniwan natapning. Ba kanong! Atunzing yuak,’ ngang daniwan natake ginu, ‘Siakan,’ ngang ma natapam. ");
INSERT INTO wnc_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Sike aminu kunduta apuke panzike anzing yaning, ‘Na Krais. Gatandamuya apata yuat,’ ngang kem yaning. Siwan kunduta yake, ‘Anututa nanitewan yakapsaapa dakngake apu daniwa natapnong,’ ngang kem yaning. Yake duya takngatu takngatu pasiwawa kake Anututa papan aminabam dakngake yuaingga siakan ngang natapningge panziwa ngana dua pimatning. ");
INSERT INTO wnc_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Unzingge ginu gwautnong. Nata sanga wa kuupbamda dua apning gwene gwa daniwa natake gisae tagwautnong,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Meya buyambamu wa wena siwana meya takngatu takngatu akaning. ‘Gunzitda zikaa daka siwan yekau kakaa dua siwawan ");
INSERT INTO wnc_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","yekapdaau ena kakaa banakan komune nana saa sike deke pimapa kaning.’ ");
INSERT INTO wnc_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Siwan tapduu waomune kawawa na aminbamde notnaapa dakngake yuat tapata umana buyambam siknga siwan kekekngana buyambam siknga aknganane yuke minga musatune yuke epa na nandugwautning,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","“Siwan tapduu waomune nata angelana yanipewa kuke aminu Anututa papan inane aminabam dakngake yuaingu kepna kepna nana kuku pake pakapu unekan pening,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Ginda katau baapdaka kake natdetnong. Tapduknga kainga yangga kaya siwan tatakngi kayukga akopan kake ginda anzingu atnatdekaing. Gunzitda isiwikge tapduknga gwa singgak. ");
INSERT INTO wnc_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Siwan ina unzakan masande kawawa meya wa daninggat takngata apan kake ginda atnatdetnong. Na aminbamde notnaapata apitde tapduknga gwa dapakanggak. Aminu tapatuta yoakatang kopnangge apuke gwabok gwaune yuak binga tapduknga gwa dapakanggak,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","“Nata siakande daninggat. Aminbamu tapduknga ayuamang komune nana aminda dua kumning gwene sanga wa kuupbamu asapik. ");
INSERT INTO wnc_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Sanga kuupbam ena kakaa banakan komune yuaikat gatu kepdakane nana kuut wena asinanga ngana natane wama wena dua siwik,” ngang yakut. ");
INSERT INTO wnc_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Siwan aminu tapatuta tapduknga wagwende dua nataak. Angela enandang nanaaya kuut dua nataaing. Na itane waakngaaya ie dua nataat. Nanatakan ie atnataak ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ginu wa zaapduknga apikge dua natake katak kayuke tandakngake yutnong. ");
INSERT INTO wnc_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Wa unzing. Aminu tapatuta yotna teke komduatang kuwik. Ita puya amina sangaapana kayutningge yanike puya usanzike inandek inandek yamik. Yamuke aminu gwabok gwaune kayuwik kapa yot toikga katak siknga kayuwikge iniwik,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Ina unzakan ginu katak siknga kayuke tandaknganong. Ginu dua nataaing. Zaapduknga na yot toikga apitden. Nata bangee apit ba petakumat dakane ba tapduknga taakga yawik komune ba tembana apit. Ie ginu dua nataaing. ");
INSERT INTO wnc_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Zetgaman apuke dandupa ginu dapunza petnang. ");
INSERT INTO wnc_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Wamu wa nata daninggat taknga nata aminu kuupbam yaninggat. Ginu kayuke tandakngake yutnong,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ge tapduu gweaya yuwa sandewana tapduk takwanu angelata tupa siknga Isrel nana amin yapbike Isipnana amin zipan kumbingge natake yuwatakak tapduk takwanu Pasova ngang yakaing gwenu akaningge siwan poyau dua paptaya nakaing gwenu atdapakakut. Siwan Anutue yot takwan gwene pasiya amindane takeakwakat gatu mama wam yanindamumsa amikatda paut tasike Jesu tanzike tanggaganuke tanguwa kupikge wam yake ");
INSERT INTO wnc_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","anzing yaking, “Ninda sanga wa tapduk takwan gwene dua tasinim. Tasina aminbamda enake amak tasinang,” ngang yaking. ");
INSERT INTO wnc_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Siwan aminu tapatu umana Saimon ngang iniking. Tupa ita wata kekeknga sikutapanin. Siwan Jesuta Betani yot gapmane yuke aminu waapatane yotnane kopbut. Koke iatnanaat nanam nanangge natake pukwike yuwawan maya tapatuta apbut. Apuke yangga kapanga kaya take siknga takngatu umana nart ngang yanikaingu manina buyambam sikngata usikuu botonu gomdu supda tasikwaapa kukuu gomdusipatang tukngwamban pukukuu tekngatusim takapbut. Siwan ita botonu wa gomu zipbuke yangga kapanga kaya take waaknga Jesue gwapakngane tukngwangamukut. ");
INSERT INTO wnc_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Tukngwangamuwawan ngana aminu kundu you wagwene yukingga kake musia wai natake ina anzing yaking, “Dasingge yangga kapanga kaya take siknga aknga moo siknga tukngwanggak? ");
INSERT INTO wnc_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ninda yangga waaknga aminde yamuna aminu kunduta 300 Kina nimuke usiwa pake aminu sangaapana wena aminde yamunam,” ngang yake maya waapa inisapduking. ");
INSERT INTO wnc_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Siwan ngana Jesuta anzing yanikut, “Ginu maya waapa katenong. Ie meya ma imam! Ita nae sanga take siknga tasingamunggak,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","“Sike sangaapana wena aminu gikat gatake yutning. Tapdukbamu ginda gatayamunanggengu take tasining. Ngana na. Na gikat asinggan dua yutnim,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","“Sanga mayata take tasinanga aknga unin tasinggak. Ita yangga kapanga kaya take aknga gupmane tukngwangamunggau sanga gwa kupsa aminde gupnasane dotdonguke tandakngakaing kaknga waapata tasike nata dua kungwake kayuk yuwawa nae tasingamunggak. ");
INSERT INTO wnc_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nata siakande daninggat. Keu kuupbam nae wamu takeaknga yakapning kopatangu maya aapata tasinggak kakngae kuut yanikapa natapning,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Tapduu waomune pandetna 12-pat nana tapatu umana Judas Iskeriot yot gapmane nanaapa. Ita Jesu yeuyamikge natake Anutue yot takwan gwene pasiya amindane takeakwakge kukut. ");
INSERT INTO wnc_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Kuke yaniwan natake apbakngake mani kundu imuningge yawa kekekakut. Siwan Jundasda tuwanguke kepi takngatu kake tapduu gwendune wa aminde katakngane yamikge tawakut. ");
INSERT INTO wnc_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Siwan tapduu yuwatakak tupanu poyau dua paptaya napsa gwenda apbut. Sike tapduu wagwene Judianana aminda Pasova yuwatakak tapduk takwan gwende natake sipsip matek zipmake sake nakaing. Siwan pandetnata tapduknga wagwen kanangge natake Jesu anzing inikwaiking, “Gata ninu poyakat sipsip matekat zane tandakngana nanimde natayak,” ngang iniwa ");
INSERT INTO wnc_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","yake pandetna tapaaya yanipewan kusande anzing yanikut, “Gitda Jerusalem yot gapmane koke kawawat wawi tapatu yangga gapma gwendu gwaamutakapan kake tawazon,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","“Ita you gwenduatang kopan kake gitda yot toiu anzing inisan, ‘Yanindamumsa apata anzing yak. Gata nae you gwendu naat pandetnaatda Pasova yuwatakak tapduk gwende nanam nanimde yot gwenu katekuyau zandang yuak ngang yak,’ ngang iniwat ");
INSERT INTO wnc_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","ita you bokngan mitapbingu buyambamu gwendu engatangan yuak gwenu yeutdaman kason. Wagwene tebo gatu sia ngangu gwa pandakngake pekingu wagwene gitda nanaminu tandakngason,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Yanike yanipewan kuke waapau yot gapmane kundoke Jesuta ayanikut taknga kake Pasova tapduk gwende nanamu tandakngakumayak. ");
INSERT INTO wnc_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Siwan bangee Jesuat pandetna katau kuut musaat kepianganu tapaaya nganggakan kuku you wagwene kopbing. ");
INSERT INTO wnc_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Koke tebodakane pukwike nanamu atnake yuwawa Jesuta anzing yakut, “Nata siakande siknga daninggat. Aminu gikatnana tapatuta na natane iwanae yeuyamik,” ngang yaniwan ");
INSERT INTO wnc_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","pandetna musia meya natake tuwanguke ie inandek inandek inikwaiking, “Na ba dasing,” ngang inikwaiwa ");
INSERT INTO wnc_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","anzing yanikut, “Waapa ginu katau kuut musaat kepianganu tapaat nana dopang anggwene naat nakamau tapatuta atasiwik,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","“Na aminbamde notna dakngake yuat tapata akupa Anututane wapatang matakut taknga buya unin aawik. Ngana na yeuyamik kapata toknga siknga apapik. Mingata aminu waapa dua tangaikut gamun,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Wa aminu atnayuwawa Jesuta poyau gomdu take Anutu inimbakngakenga apuke ginda pake nanong ngang yanikut. Sanga wa kake ginda natane gupma ngang natapnong ngang yake yaman natakuking. ");
INSERT INTO wnc_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Siwan ita kap wainu gomdu take Anutu inimbakngake yaman tangotakuking. ");
INSERT INTO wnc_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Siwan ita anzing yanikut, “Sanga wa natake daknga. Nata kungwake daknga tukngwaba Anututane wam kwikwiu kayuk kakngata kekekawik. Nata kungwake daknga tukngwaba Anututa inane musia zikaa ginde nataak kaknga tapa tekwamban aminbamde waiakngana sandeyamikge tukngwambit,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","“Nata siakande daninggat. Nata wain tapunde yanggaaknga gatu dua tangoke yusika kuku tapduknga Anututa amin panangge tasinggak kaknga buya aawik gwene nata wain yangga inata kundu tangopit,” ngang yaniwan puyuwan ");
INSERT INTO wnc_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","kau takngatu taike kepman epuke pukuke tawanu Oliv dakane kopbing. ");
INSERT INTO wnc_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Kepiapane koyuk Jesuta anzing yanikut, “Ginda nae banip sikaing kaknga tewa pimapan yakapsa aminda Anututane wamu takngatu matakut taknga buya unin asaawik. Ita anzing matakut, ‘Anututa kapewan akayuak kapa tanguwa kupan sipsipna kuupbamda unda undang datakuning,’ ngang matakut. ");
INSERT INTO wnc_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ngana nata gatu gweake tupanu nata gamok ginde Galili kep komune kuwit,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Siwan Pitata anzing inikut, “Aminbamda gae banip sikaing kaknga tewa pimapik ngana nata gae banip singgat taknga dua teke yuwit,” ngang iniwan ");
INSERT INTO wnc_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","yake anzing inikut, “Nata siakande ganinggat. Apmanu zikaa anggwene taakga sipmaya dua yawawan gata natane umana sipmaat sipduat takusopuwiyak,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Iniwan ngana Pitata yake kekekenga siknga anzing inikut, “Na gaat kuut kumzimde yawanu nata gatane umanda dua takusopuwit. Wena siknga,” ngang yawan pandetna kuupbamda unzakan yaking. ");
INSERT INTO wnc_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Siwan kepiapane kusika keu Getsemani ngang inikaing komune kundoke Jesuta pandetna anzing yanikut, “Ginu ane pukwike yuwawa nata atune kuke tumuk wam yawit,” ngang yanike ");
INSERT INTO wnc_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","ita Pita Jems gatu Jon ngang papan iat gatake kuking. Kusika ngana ita meya siknga natake ");
INSERT INTO wnc_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","anzing yanikut, “Nata meya siknga natake akupanu take sinanga,” ngang yanikut. “Ginu ane yuke kayuk yutnong,” ngang yanike ");
INSERT INTO wnc_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","kundusim kuke kepdakane pimake tumuk wam yakut. Anututa take natapanu meya akawik kakngata ayapbimbikge natake ");
INSERT INTO wnc_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","tumuk wamu anzing yakut, “O nan! Gata sanga kuupbam atasinangaapa. Gata meya wa kawit taknga asandekngamuyo. Ngana ga nae banip ma tawambim. Aho. Gata gikae banip tawamso,” ngang yakut. ");
INSERT INTO wnc_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Unzing yakenga ita akuke kawan pandetna wa tapaat tapatuatda dapuna pekgawa kakut. Kake Pita anzing inikut, “Saimon. Kayuk yuwiyakge ganit ngana dapunda pekgayak? Gata tapduu komdusimu yuke kayuk yutnanga dua ba dasing,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","“Ginu kayuk yuke tumuk wam yanong. Sanga gin pasiwa sinangata ginde apsak. Siakan. Banipzaatang kayuk yutnangge nataaing ngana ginda tuyuknga natake pekaing,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Yanikenga ita gatuna kuke tumuk wam yakut. Tumuk wamu tupan yakut takngakan gatuna yawan puyuwana ");
INSERT INTO wnc_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","ita gatuna pandetnae apuke kawan dapunae siwan kai tuyuknga siwa apekgawa kakut. Siwan wa aminu yake ininangge apbotake yuking. ");
INSERT INTO wnc_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Siwan Jesuta gatuna kuke tumuk wam yakenga apan sipmaat sipduaat dakngakut. Siwan apuke kawan apekgawa kake anzing yanikut, “Ginu gatu gatu danit ngana dapunza asinggan peke ayuwatakakaing ba dasing? Gwa pekaingge enake kanong. Tapduknga na aminbamde notna dakngake yuat tapa wai aminde katakngane yeuyamuningge gwa singgak. ");
INSERT INTO wnc_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ginu enawa kuna. Kanong! Aminu na yeuyamik kapata gwa apunggak,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Siwan Jesuta wamu waaknga ayayuwawan pandetna 12-pat nana tapatu umana Judas. Iat aminbampat gatake apuke paip gatu zagwa ngang pake apbing. Wa apbing aminu Anutue yot takwan gwene pasiya amindane takeakwakat gatu mama wam yanindamumsa amin gatu Judia amindane take amin ngangga yanipewa apbing. ");
INSERT INTO wnc_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Siwan aminu Jesu wa aminde kataune yeuyamik kapata tuwangu takngatu wa aminde tupa yamuke anzing yanikut, “Nata aminu asinimbakngawit tapa Jesu unin. Ginda waapa tanggaganuke take siknga take takunong,” ngang tupa yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","46","Siwan Judasda apuke Jesue zetgaman kuke aana ngang inimbakngawan kake take tanggaganuking. ");
INSERT INTO wnc_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Siwan aminu Jesuat yukikatnana tapatuta paipna kaitakakoke Anutue yot takwan gwene pasiya tupan tapatane puya aminatane maaknga patdetewan pimakut. ");
INSERT INTO wnc_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Siwan Jesuta wa apbing aminu anzing yanikut. “Dasingge ginu na apu tanangge natake paip gatu zagwa ngang pake kuka aminu tapatu binga tanangge apukaing? ");
INSERT INTO wnc_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Tapdukbamu na gikat Anututane yot takwan gwene yuke nata ginu danindamuwawa ngana ginda na dua tanggaganutnangge tasiking. Ngana Anututane wamda tupa siknga nae yakut taknga buyana asaawikge kepi umutnanga dua,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Siwan pandetna kuupbamda teke atdatakuking. ");
INSERT INTO wnc_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Siwan aminu wawi mateu tapatu tauknga kwaknga sandukan gupnane wamake Jesuat yukikatnana tapatu tanggaganutnangge tasiwa ");
INSERT INTO wnc_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ngana ita tauknga kwakngasan katakngane teke kwanggaapa datakukut. ");
INSERT INTO wnc_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Siwan Jesu take Anutue yot takwan gwene pasiya amindane tupan tapae takuke tewa Anutue yot takwan gwene pasiya amindane takeakwakat gatu Judia amindane take amin gatu mama wam yanindamumsa amin ngangga undang apundopbing. ");
INSERT INTO wnc_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Siwan Pitata masa masa kuyawake kuku Anutue yot takwan gwene pasiya aminde tupan tapatane yot daman gwene kopbut. Kopan iat taukdapakat unekan gatake yuke katap aike yuking. ");
INSERT INTO wnc_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Siwan Anutue yot takwan gwene pasiya amindane tupan tapaat gatu sios kaunsil kuupbapatda aminu tapaaya yayawamba apu wamu sanga Jesuta tasikutde wamu buya kundukan yawat kake tanguwa kupikge aminde yawaking. Siwan ngana yawamba maikut. ");
INSERT INTO wnc_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Aminbamda temanggaganuke yaking siwan ngana wa yakikat nana tapaatane wamna buya kundukan dua sikut. ");
INSERT INTO wnc_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Siwan aminu kunduta temanggaganuke anzing yaking, ");
INSERT INTO wnc_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ninda natawatna ita anzing yakut, ‘Anututane yot takwanu aminda apmitapbing gwenu waitdeke tapduu gweaat gwenduatdekan nata gwendu mitapit ngana nata katakngata dua mitapit,’ ngang yawan kakumang,” ngang yaking. ");
INSERT INTO wnc_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ngana wamu wa yaking kakngaaya buya kundukan dua sikut. ");
INSERT INTO wnc_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Siwan Anutue yot takwan gwene pasiya amindane tupan tapata enake banakan yuke Jesu anzing inikwaikut, “Gata wamu takngatu yake yananga dua ba dasing? Dasingge wamu waaknga gae yakaing,” ngang iniwan ");
INSERT INTO wnc_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","ngana kuma yuke wamu takngatu yake ie dua inikut. Dua iniwan kake waapata gatu anzing inikwaikut, “Ga Anututa tapan Krais gatanimuyaapa dakngake asinimbakngakamang kapatane waakngaapa yuayak ngang kakengu gata niniwi natapnim,” ngang iniwan ");
INSERT INTO wnc_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","yake, “Aminu waapa na unin,” ngang inikut. “Siwan ginda nanduwawa na aminbamde notna dakngake yuat tapata Anutue kataknga siyaapa kekeknga kuupbamu kayaapane yuke minga musane yuke asepuwawa nandupning,” ngang iniwan ");
INSERT INTO wnc_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","natake waapata bania toknga siknga natake tauknga wetzukuke anzing yakut, “Ninda aminu kunduat dua ie wam yakapningge yayawanim. Wena. ");
INSERT INTO wnc_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ita Anutue umana yaitapaakusiwan kaamangge ginu dasing nataaing,” ngang yawan kuupbamda wamu akumnanga aknga yanggak ngang yawa kekekakut. ");
INSERT INTO wnc_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Siwan aminu kunduta aapda suyapbikngamuwawa kunduta kai taukga wamakusike kataknga putumuke tanguke anzing iniking, “Gata ayanikapsaapa kakengu yayo. Maminda gukgakgen,” ngang inisapduwawa tauk dapakga aamna wesiking. ");
INSERT INTO wnc_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Siwan Pita kepman kekep komune yot daman gwene yoan saak yukut. Yuwawan puya aminu maya tapatu Anutue yot takwan gwene pasiya aminde tupan tapae pasingamunggau tapatuta apu kawawan ");
INSERT INTO wnc_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pitata katap ainggawan kakut. Kake ie siknga kanggamatake anzing inikut, “Gakaya Jesu Nasaret nanaapaat yuaing,” ngang iniwan ");
INSERT INTO wnc_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","ngana Pitata tawak wam yake anzing inikut, “Na dua nataat. Na gata wamu wa yanggayak kaknga yapii dua nataat,” ngang inikenga kepman kunangge yot damande gwabok gwaune wesim kuwawan taau gwenduta ayakut. ");
INSERT INTO wnc_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Siwan maya puya aminu waapata aminu wesim yukingu anzing yanikut, “Aminu aapata aminu waapaat nana tapatu,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Siwan ngana Pitata gatuna tawak yakut. Siwan kundusim yuke aminu wesim yukingga gatu Pita anzing iniking, “Siakan siknga. Aminu gaapa wa amikat nana tapatu. Ga Galili nana tapatu,” ngang iniwa ");
INSERT INTO wnc_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","ngana Pitata apaa siknga anzing yakut, “Siakande siknga. Nata yawa Anututa natapan kem siwanu tokngabam namuyak. Na aminu ginda wa yakaing kapae na dua nataat,” ");
INSERT INTO wnc_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","ngang yayuwawan taakga gatu sipduat yakut. Yawan natake Pitata wamu Jesu anzing inikut takngae gatu natdekut, “Taakga sipmaya dua yawawan gata sipmaat sipduat nae yake ie dua nataat ngang yawiyak,” ngang inikut takngae gatu natdeke kwanamu kumzang sikut. ");
INSERT INTO wnc_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Siwan tembana siknga kwakaawana Anutue yot takwan gwene pasiya amindane takeakwakat gatu Judia amindane take amikat gatu mama wam yanindamumsa amikat gatu sios kaunsil kuupbapatda paut tasike yawa Jesu napda wamake taku Pailatde imuking. ");
INSERT INTO wnc_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Siwan Pailatda anzing inikwaikut, “Ga Judia amindane buyambam tapa ba dasing,” ngang inikwaiwan Jesuta yake, “Gika unzing unin yanggayak,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Siwan Anutue yot takwan gwene pasiya amindane takeakwakga kem wamu ie kumzang yaking. ");
INSERT INTO wnc_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Siwan Pailatda gatu inikwaikut, “Gata wamu yake takngatu dua yaya ba dasing? Gae wamu buyambamu yawawa natake ngana yake dua yaniya,” ngang iniwan ngana ");
INSERT INTO wnc_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Jesuta wamu yake takngatu dua yawan kake Pailatda asatnakut. ");
INSERT INTO wnc_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Nakanu kuupbam tapduk takwanu unzing gwene Judianana aminda kaaut aminu tapatue umana yawanu Pailatda aminu waapakan sandewan kunggak. ");
INSERT INTO wnc_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Siwan tapduu waomune aminu tapatu umana Barabas. Ita aminu gavmakat ambing amikat kaautde pasiking. Wa aminu amak tasike aminu kundu atzipa kumbing. ");
INSERT INTO wnc_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Siwan aminbamda kuke Pailatde asinggan atasinggak kaknga tasiwikge iniwa ");
INSERT INTO wnc_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pailatda yake anzing yanikut, “Ginu nata ginu Judianana amindane buyambam tapasa sandetewa kuwikge nataaing ba dasing,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Dasingge? Ita anzing atnatapbut, “Anutue yot takwan gwene pasiya amindane takeakwakga Jesue semna natangamuke wamna yawikge takapuing,” ngang anggaman natake wamu waaknga yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Siwan ngana Anutue yot takwan gwene pasiya amindane takeakwakga aminbamdane musia pangenawa Pailatda Barabas sandetewan kuwikge yaking. ");
INSERT INTO wnc_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Yawa ngana Pailatda gatu anzing yanikut, “Unzingge nata aminu aapae dasing tasiwit. Ginda Judianana, ‘Amindane buyambam tapa,’ ngang yakaing kapan,” ngang yaniwan ");
INSERT INTO wnc_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","yake gatu yanggamatake, “Amin saamdakane tanguyo,” ngang yaking. ");
INSERT INTO wnc_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Yawa ngana Pailatda anzing yanikut, “Dasingge? Ita wai dasing kaknga tasikut,” ngang yaniwan ngana, “Amin saamdakane tanguyo!” ngang kumzang yanggamatawawa ");
INSERT INTO wnc_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pailatda aminbamdane musia yanigokgosanangge natake Barabas sandetewan kuwawan ita Jesu amak aminde kataune yaman ipmapa tanguke amin saamdakane tangutningge yamukut. ");
INSERT INTO wnc_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Siwan Jesu take gavmande yot daman gwene takokenga amak aminu waakwakatnana kuupbam yayawamba apbing. ");
INSERT INTO wnc_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Apana tauu gamana sandu buyambam tapatane binga tasingamuking. Tasingamuke nau bobingga gwasike gwapakngane tupan tapatane kupna binga gwapungamuking. ");
INSERT INTO wnc_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Gwapungamukenga kem tanziyuk umana yatangenake anzing yaking, “Judia amindane buyambam tapa! Gata asinggan asinggan yuyo,” ngang inike ");
INSERT INTO wnc_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","gwapaknga pitamu tapatuta tanguke aapda suyapbikngamuke kem tanziyuk muna puke tasibakngaking. ");
INSERT INTO wnc_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Siwan sapdut wamu wa iniwa puyuwana tauu gamana sanu sandeke inane tauknga gatu pasingamuke take amin saamdakane tangutnangge takuking. ");
INSERT INTO wnc_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Takuke kuwawa aminu tapatu Sairini yot gamane nana tapatu umana Saimon ngang iniking. Sike waapata Alesandaat gatu Rufuskatdane nana. Ita puyaneta apu yot gapmane kopnangge apbut. Apan iniyepike Jesutane amin saamdaka ima gwaamutake kukut. ");
INSERT INTO wnc_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ita gwaamutake kuwawan Jesu take keu komdu umana Golgota ngang inikaing. Sike tana tekwamban anzing yanim. Gwapak gwikgwit kep ngang yanim. Undang kundoke ");
INSERT INTO wnc_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Jesu wain yangga aknga marasinu kunduat tasikingu iman tangopan gupna bakawan toknga siknga dua papikge iman ngana dua tangopbut. ");
INSERT INTO wnc_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Siwan wa aminda amin saamdakane tangukenga kat binga tasike itane tauknga usanzike panangge tasiking. ");
INSERT INTO wnc_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Sike sanga wa tembana tasike gunzitda akoke awekawawan Jesu amin saamdakane tanguking. ");
INSERT INTO wnc_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Siwan wamu ayake tanguking kaknga anzing mataking, “Judia amindane buyambam tapanin.” ");
INSERT INTO wnc_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Sike Jesue wesimu aminu kukae papsa aminu tapaaya ngang amin saam dakaayane zipbing. Tapatu siyaapa saak tanguke tapatu kwanaapa saak tanguking. ");
INSERT INTO wnc_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","(Unzingge Anututane wamu takngatu tupa siknga matakut taknga buya unin aakut. Wamu waaknga anzing, “Wa aminda kawawa iat wai amikat unekan gatake yuwawa kaking,” ngang matakut.) ");
INSERT INTO wnc_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Siwan aminu kunduta kungapuyuk kake gwapakngi makaike ie sapdut wamu anzing iniking, “Ayok! Ga Anututane yot takwan gwen waike tapduu gweaat gwenduatdekan mitanggaunin. ");
INSERT INTO wnc_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ga gika gatanggamuke amin saamdaka teke ep,” ngang inisapduking. ");
INSERT INTO wnc_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Inisapduwawa Anututane yot takwan gwene pasiya amindane takeakwakat gatu mama wam yanindamumsa amindaya unekan gatake yuke sapdut wam ina banakan anzing yaking, “Ita aminu kunduekan gatayamukut ngana ina gatangamunanga dua. ");
INSERT INTO wnc_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Anututa tapan Krais ninu Isrel amindane buyambam tapa. Ita amin saamdaka teke epan ninda kake siakan ngang natapnim,” ngang yaking. Siwan aminu Jesuat wesim zipbing tapaatdaaya kuut sapdut wamu asinikumayak. ");
INSERT INTO wnc_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Sike kepmaum zikaandaka sike keu kuupbam usikwatapan kuku bangee gunziu dandam enaawan ");
INSERT INTO wnc_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Jesuta apaa inane wam tangan anzing yakut, “Ilai Ilai lama sabaktani,” ngang yakut. Wamu waaknga tana tekwamban anzing yanim, “Anutuna! Anutuna! Dasingge gata na napmambi yuat,” ngang yawan ");
INSERT INTO wnc_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","aminu kundu inengan yukingga natake anzing yaking, “Natapnong! Ita Ilaija aminu tupa siknga ayanikapsa dakngake yukut tapae yatawanggak,” ngang yawa ");
INSERT INTO wnc_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","aminu tapatuta isapmake kuku yanggabam gwene nana misa wangatu take wain yangga kapanga sikut takngane tewan bukatawan wa pitamu tapatune ukgauke wa Jesuta atangopikge imuyuk anzing yakut, “Kayutna siwik. Ilaijata apu sandeke apme ba takepik,” ngang yakut. ");
INSERT INTO wnc_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Siwan Jesuta apaa gatu yake akumbut. ");
INSERT INTO wnc_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Siwan tauu buyambam sanu Anututane yot takwan gwene mitapa pimakut sanu enaneta wesiwan amunane epu dewan saaya dakngakut. ");
INSERT INTO wnc_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Siwan amak aminu tupan tapata Jesu tanguking komune yuke kawawan ita unzing kupan kake anzing yakut, “Siakan siknga. Aminu aapa Anututane waaknga,” ngang yakut. ");
INSERT INTO wnc_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Siwan maya kunduta wesim wesim yuke katasiking. Wa katasikikat nana tapatu umana Maria Magdala yot gapmane nanaapa. Siwan tapatu itane tange Maria Jems masan tapaat gatu Josiskatdane minga gatu tapatu umana Salomi ngang iniking. ");
INSERT INTO wnc_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Tupa Jesu Galili yukuune maya wa tapaat tapatuat iat gatake yuke gatangamuking. Siwan maya waakwakat gatu maya kundu Jesuat gatake Jerusalem kopbing amikatda unekan gatake yuke katasiking. ");
INSERT INTO wnc_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Siwan aminu tapatu umana Josep ngang iniking. ");
INSERT INTO wnc_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Ita Arimatia yot gapmane nana waapa sios kaunsil aminu tapatu. Siwan umana take siknga. Waapata tapduknga Anututa amin panangge tasinggak kakngata apikge akayuak. Siwan kwepna yuwatakak tapduk gwenu apikge apmanu sangaapa tandakngananga tapduk ngang natake bangee siwana Josepda bania gitna siwan ita Pailatde kuke Jesutane gupnasan tanangge yakut. ");
INSERT INTO wnc_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Kuke yawan Pailatda nangaakan natake, “Ita gwan kungwak ba dasing,” ngang yake amak aminu tupan tapa yatawamban apan anzing inikwaikut, “Jesuta gwa kungwak ba dasing,” ngang inikwaiwan ");
INSERT INTO wnc_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","yake, “Gwa kungwak,” ngang iniwan natakenga Josepda gupnasan tapikge inikut. ");
INSERT INTO wnc_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Iniwan Josepda kuku tauu kwaknga sandu usike takapu Jesutane gupnasan takepuke tauk kwakga tapa kopan supgapbau matmatde tasiking dakane tekut. Teke Josepda suu gwendu ikomban apu sup gapbatde ganangi umukusikut. ");
INSERT INTO wnc_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ikoban apu umukusiwawan maya tapaaya umana Maria Magdala yot gapmane nanaapaat gatu itane tange Maria Jems gatu Josisdane mingaatda undang yuke kayuwawat supgapbau wandakane Jesutane gupnasanu Josepda undang tewan kakumayak. ");
INSERT INTO wnc_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Siwan yuwatakak tapduk gwenu kawa sandewana gunziu pukuwan atzikaawawan maya wa tapaat gatu Salomi ngangga Jesutane gupnane pasiwa dua bukatawikge natake kuku wel yangga kapanga kaya take siknga aknga usiking. ");
INSERT INTO wnc_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Usike pewa kwakawan sande tembana gunzitda akopana sanga wa pake supgapbat dakane kuyuk ");
INSERT INTO wnc_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ina anzing yaking, “Maminda ninu gatanimuke supgwenu supgapbatde umukusikut gwenu ikomban kuwik,” ngang yaking. ");
INSERT INTO wnc_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Yake kawawa ngana suu wagwenu gwa ikoba kukutna kaking. Sike suu wagwenu buyambam gwen. ");
INSERT INTO wnc_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Siwan maya waakwau supgapbau wandakane kuke kawawa wawi mateu tapatu siyaapa saak yuwawan kaking. Kawawa wawi waapata tauknga mamaya kwaknga tasike yuwawan akasatnaking. ");
INSERT INTO wnc_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Akasatnawa ita anzing yanikut, “Ginu ma satnawam. Na atnatat. Ginu Jesu Nasaret nanaapa amin saamdakane tanguwa kumbut tapae kanangge apukaing. Ita gwa enak! Andang dua yuak! Ateking komde kanong. ");
INSERT INTO wnc_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Kake ginda kuke Pita ininong. Inike pandetna kuupbam anzing yaninong. Jesuta gamok Galili kep komune kunggak. Siwan ginda undang kuke kanong. Unzing ita tupa gwa danikut taknga binga enake kunggak ngang yaninong,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Siwan maya waakwau akgwauke dandai yamuba musia kukumuk akoyapa supgapbau wandaka teke kepman epuke datakuking. Datakuke ngana wamu takngatu aminu tapatue dua iniking. ");
INSERT INTO wnc_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Siwan Jesuta sande wagwene tembana siknga gatuna kayuk enake Maria Magdala yot gapmane nanaapae gamok anggaman apan kakut. Maya waapa tupa Jesuta waung wai katau kuut musa kautdu tapaaya ngang yanikwasikngamukut tapanin. ");
INSERT INTO wnc_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Siwan Mariata kakenga kuku aminu Jesuat gatake sukuking aminda butaya natake kwanamna sike yuking aminde kukut. ");
INSERT INTO wnc_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Kuke anzing yanikut. Jesu kayuk yuwawan nata gwa kat ngang yanikut. Siwan wa aminu wamu waaknga natake siakan ngang dua natapbing. ");
INSERT INTO wnc_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Siwan masande pandetna tapaaya Jerusalem yot gapma teke kepiapane kukumayak. Kuwawat Jesuta inata kundu sike waapaatde anggaman kundopan kakumayak. ");
INSERT INTO wnc_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Kake waapaatda kuku pandetna kundue wamu waaknga yakapbumayak. Siwan ngana wa aminu waapaatde wam natake siakan ngang dua natapbing. ");
INSERT INTO wnc_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Siwan masande pandetna katau kuut musaat kepianganu tapatu ngang pukwike nanam naking. Nawawa Jesuta une anggaman apan kaking. Apan kawawa ita wa aminu aminbamda kawawa ita gatuna kayuk enakutde yaniwa ngana yamandet sike siakan ngang dua natapbing kakngae kaanga yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Yanikenga anzing yanikut, “Ginu kepna kepna kuke wamu takeaknga aminu kuupbam yaninong. ");
INSERT INTO wnc_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Yaniwa mamin amin takwakga nae wama natapa siakan siwan yangga sautningu kayuk yutning kaknga apaning. Ngana aminu nae natapa kekeknga dua siwiu wena asining,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","“Sike Anututa aminu nae wam natapa siakan siwiu gatayaman duya takngatu takngatu pasining. Sike nata papa nae aminabam dakngake waung wai ayanikwasitning,” ngang yanikut. Sike wamu inata kundu tupa dua natdeking ngana ina yaning. ");
INSERT INTO wnc_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Sike wa aminda gomou amin yasikaing kapa katakga yum pake ngana, “Wai dua sining,” ngang yanikut. “Sike sanga aminu atzipa kupsa tangopanu sanga ita dua pasiwan maining. Sike katakga mait amin wasiwa gatu take sining,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Siwan Buyambam tapa Jesuta wamu yawan puyuwana Anututa i take enandang takopbut. Takopan ita kekekngana kayaapa dakngake Anututane kataknga siyaapane yuak. ");
INSERT INTO wnc_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Siwan pandetnata akuke wamu keu kuupbam yanikapbing. Siwan Jesu Buyambam tapata gatayaman wamu yanike duya takngatu takngatu pasiwawa aminbamda kake natapa wamna siakan sikut. ");
INSERT INTO wnc_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","4","Sanga takngatu takngatu nin banakan apa kainata kake ninindamuking. Tapduknga waakngata apbut gwenuneta kake ninindamuking kakngae natake aminu buyambamda gwan mataking. Siwan buyambam tapa, Tiofilas, gata wamu wa mataking kakngae gwa natapbuyak. Siwan sanga wa mataking kakngae tupa siknganeta katak natake tanomanuke naaya matanangge natapbum. Natake wamu waakngakan noman siknga matanggama kendeke tupa gwa natapbuyak kaknga natapi siakan siwikge matanggamunggat. ");
INSERT INTO wnc_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Siwan Herotda Judia kep komune nanatane aminu tupan tapa yukut gwene aminu tapatu umana Sekaraia ngang iniking. Ita Anutue yot takwan gwene pasiya aminu tapatu Abaisatane donga yukut. Siwan maatna umana Ilisabet ngang iniking. Ita Erondane dongune aake yukut. ");
INSERT INTO wnc_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Siwan waapaatda Anututane mama wamu kuupbam katak siknga tasike Anutue kainae aminu dudumnata yukumayak. ");
INSERT INTO wnc_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Aminu dudumnata yuke ngana mayata waaknga yapana dua bokngike songa yukut. Yusika waapaatda aminuake sikumayak. ");
INSERT INTO wnc_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Siwan Anututane yot takwan gwene pasiya aminda usanzike puyana unzing unzing ngang yake pake pasikaking. Siwan Abaisatane donga tapduknga kayane puya pasikaking. Siwan Abaisatane donga tapduknga kayane puya pasiwawa Sekaraia tapan ita yot takwan gwene koke sanga Anutuekan natake sawan kupan akopan natapan kapanga ");
INSERT INTO wnc_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","take siknga siwawan aminbamda kepman yuke tumuk wam Anutue inike yuking. ");
INSERT INTO wnc_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Inike yuwawa angela tapatuta apuke buka kupanda konggak gwene siyaapane yuwan Sekaraiata kakut. ");
INSERT INTO wnc_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Kake nangaakan natake gwaukut. ");
INSERT INTO wnc_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Gwauban, “Sekaraia. Magwaumbim,” ngang inikut. “Anutu asinggan iniwi natake tasiwan maatdata engangu wawi tapatu tangaiwik. Tangaiwan umana Jon ngang iniyo. ");
INSERT INTO wnc_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Inike musipba tatanga natapiyak. Natake yuwawi aminbamda waakgata aawan natake take siknga natapning,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","“Dasingge? Waapata Anututane kaine umana kayaapa dakngawik. Yangga toknga aknga takngatu dua tangopik. Ita aawik gwenuneta Anututane Waung Takwan Tapata gatangamuke kekekangamik. ");
INSERT INTO wnc_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Kekekangaman ita tasiwana Isrel nana aminu buyambamda Anutue gepbiatang koyutning,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","“Tupa siknga Anutue wam yakapsa aminu Ilaijata kekeknga siknga tasikut binga Anututane kwiiknga dakngake kekeknga aknganane pasiwik. Pasike waaknga nanata kuma yuaing kaknga zipbuke pakapu unekan pewik. Sike ita pasiwan yamandet pasiya aminda kwikwiknga yuya amindane natdetdetna nomana gatu pake yutning. Siwan ita pasike yaniwan aminbamda tanomanuke Buyambam tapata apikge yutning,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Iniwan natake Sekaraiata yake angela anzing inikut, “Nata aminuake gwasinggat. Maatnaaya aminuake yuakge dasipna wamu wa naninggayak kaknga natapa siakan siwik,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Iniwan yake anzing inikut, “Na Gebriel. Nata Anutue kaine asinggan yuatde nata apu wamu wa takeaknga ngang ganiwitde nanitewan apunggat. ");
INSERT INTO wnc_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Apuke ganiwa natapi siakan dua singgakge nata ganinggat. Gwa ganinggat takngata dua apik gwekatang gata genda kusiwan wam yanangge apbotake yuwiyak. Siwan wa ganinggat takngata tapdukngane siakande buya aawik,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Iniwawan aminbamda kepman yuke ita zet dua epan kake nangaakan natapbing. ");
INSERT INTO wnc_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Natake yuwawa masande kepman epuke wam yaninangge apbotake yuwan kake mia takngatu yot takwan gwekatang ba kak ngang natapbing. Natake yuwawa ita katakngita tuwanggan tasike gena kusiwan yukut. ");
INSERT INTO wnc_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Sike puya apasikaing kakngane inane tapdukngata apan pasiwan puyuwana yotna kukut. ");
INSERT INTO wnc_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","25","Yotna kuke yuwawan maatnata musia sikut. Siwan anzing yakut, “Nata tapduknga mamaya yuwawa apmandekan Buyambam tapata gatangaman maaknga natapbum taknga wena singgak,” ngang yakut. Yake yekau katak kuut musa yotnaatang gatukande yukut. ");
INSERT INTO wnc_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Siwan Ilisabetda musia sike yekau katak kuut musaat kautdu gwenduat yukut. Tapduk wagwene Anututa Gebriel initewan kuke you gapmandu umana Nasaret ngang iniking. Galili kep komune yuak. ");
INSERT INTO wnc_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Maya mateu tapatu umana Maria ngang iniking. Siwan wawi tapatu umana Josep ngang iniking. Ita buyambam tapa Devitdane dongune aakut tapa. Siwan wawi waapata maya waapasimu maatnae tapikge gwa yaking ngana ");
INSERT INTO wnc_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","dua takut gwekatang angela waapata apu Maria gaak wamu anzing inikut, “Kwikwiknga akngane yuyo. Buyambam tapaat gaat unekan gatake yuke banip gwaang natanggamunggak,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Iniwan natake dasingge gaak wamu waaknga na naninggak ngang natake meya siknga natayukut. ");
INSERT INTO wnc_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Natayuwan angelata inikut, “Maria! Ma gwaumbim. Anututa gandupan take sikut. ");
INSERT INTO wnc_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Siwan ganiwa natapso. Gata kayaapa sike engangu wawi tapatu tangaiwiyak. Tangaike umana Jesu ngang iniyo. ");
INSERT INTO wnc_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Waapata aminu buyambam tapa dakngawan enane siknga yuak kapatane waaknga ngang inining. Siwan bamna Devitda buyambam tapa yuke tasikakut binga waapata dakngake tasiwikge Anutu buyambam tapaninda tapan tasiwik. ");
INSERT INTO wnc_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Tasike Jekopdane dongune aakingu kuupbamde takeapa dakngake asinggan yuwawik. Yuwawan kekeknga akngata asinggan asinggan yuwik,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Iniwan Mariata yake anzing inikut, “Dasipna tangaiwit? Apmae dua kukum,” ngang iniwan ");
INSERT INTO wnc_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","yake anzing inikut, “Anututane Waung Kapata gae apuke enane siknga yuak kapatane kekeknga aknganata tasinggaman engangu tapatu tangaiwiyak. Wa tangaiwiyak kapae inike Anutu enane siknga yuak kapatane waaknga ngang inining,” ngang inikut. “Gaat llisabetkat dongu unekan yuamayak. Siwan waapata aminuake ngana wawi tapatu musiaatang yuak. ");
INSERT INTO wnc_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Musia siwan yekau katak kuut musaat kautdu gwenduat ngang gwa yuak. Enganga wena songaapa ngang iniking ngana kayapa gwa singgak. ");
INSERT INTO wnc_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Anututa sangabamu atasinangge natakengu atasiwik,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Iniwan Mariata yake anzing inikut, “Ayok. Nata Buyambam tapanindane gepbiatang yuwawa gata naninggayak kakngata singaman take siwik,” ngang iniwan angela waapata teke kukut. ");
INSERT INTO wnc_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Siwan tapduk waomune Mariata tandakngake zetgaman kuke tawandaka dakatang kopbut. Koke you gapmandu Judia kep komune yuak gapmane kundoke ");
INSERT INTO wnc_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Sekaraiatane yot gwene koke gaak wamu Ilisabet inikut. ");
INSERT INTO wnc_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Iniwan engangu musiane yukut tapata sasaa siwan natayuwawan Anututane Waung Kapata kekeknga aknganata musia tangenawan ");
INSERT INTO wnc_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ilisabetda yake anzing yanggamatakut, “Gata maya kuupbam yapbike yuayak. Engangu musipbaatang yuak kapa take siknga. ");
INSERT INTO wnc_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ge gata Buyambam tapanatane minga ngana Anututa kwikwiknga natanggamuke tasinggaman gata take siknga nae apunggayak. ");
INSERT INTO wnc_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Gata gaak wamu waaknga ngang naniwi maakngata natake yuwawa engangu musipmaatang yuak kapata iaknga binga natake sasaa singgak. ");
INSERT INTO wnc_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Siwan buyambam tapata ganiwan natapi siakan sikutde apbakngayo,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Siwan Mariata anzing yakut, “Nata Buyambam tapanindane umana akngana yatangenakgat. ");
INSERT INTO wnc_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Anutu na gatangamunggak kapae banip gwaang nataat. ");
INSERT INTO wnc_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Natane umana akngana wena ngana nata itane puyana pasike yuwawa atnandupbut. Nanduke tasingaman aminbamu tapduknga apmanu ayuamang komune nanaat apmea yutning amikatda nae apbaknganggak kapa ngang yaning. ");
INSERT INTO wnc_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Dasingge? Kekekngana Kayaapata sanga buyambam pasingamukut. Itane uman takwan takngae yumdekan yananga dua. ");
INSERT INTO wnc_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Waapata ie akgwaukaingu tapduk tapduk yuaingge banip kwikwik natayamunggak. ");
INSERT INTO wnc_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ita kekeknga aknganata tasike aminu inane umana tangenake minaka tasinangge nataaingu zipmawawan atdatakuking. ");
INSERT INTO wnc_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ita buyambam tapa dakngake enane yuya aminda pimatningge tasike umana wenaapa yuya aminu tangenakut. ");
INSERT INTO wnc_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ita tomna natake yuya aminde sanga take siknga yamuke sangaapana kaya aminde sanga dua yamuke yanipewan moo siknga kuking. ");
INSERT INTO wnc_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ita bania kwikwiknga aknganae bamin yanike dua yanigokgosakut. ");
INSERT INTO wnc_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ebrahapat ie dongune masan siknga aake yuamang amikat dua ninigokgosake Isrel nana puya amina dakngake yuamang aminu akgatanimukut.” ");
INSERT INTO wnc_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ngangu Mariata wamu waaknga yakenga bautna Ilisabetkat gatake yuke yekau gweaat gwenduat kawat sandewana yotna gatu kukut. ");
INSERT INTO wnc_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Siwan tapduknga Ilisabetda engang tangaiwik gwenu gwan dapakawan engangu wawiapa tangaikut. ");
INSERT INTO wnc_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Tangaiwana itane aminabamda Buyambam tapata natangamunggak kaknga unin aawan kake apbakngaking. ");
INSERT INTO wnc_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Sike tapduknga katau kautdu musaat kautdu gweaat yukenga kepi asinggan tasikaking kaknga tawake enganggane gupna matanangge apuke umana Sekaraia ngangu nanatane umana ininangge yaking. ");
INSERT INTO wnc_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Yawa ngana mingata anzing yakut, ");
INSERT INTO wnc_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","“Aho. Umana Jon ngang ininim,” ngang yakut. ");
INSERT INTO wnc_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Yawan anzing iniking, “Apa. Namakga ba gaatnana tapatutane umana unzingu wena,” ngang iniking. Siwan tasike tasike katakngita tuwangakan tasike nanata umana iniwikge tasiking. ");
INSERT INTO wnc_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Tasiwawa ita tuwangakan wam matananga sandu takapningge tasiwan takapa ita anzing matakut, “Umana Jon,” ngang matawan notnabamu nangaakan natapbing. ");
INSERT INTO wnc_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Siwan zetgaman Sekaraiatane gena take siwan ita wam yake Anutue umana yatangenakut. ");
INSERT INTO wnc_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Siwan itane notna yotna gapmandune nanakanda kake akgwauking. Siwan sangabamu wa sikutde wamu Judia keu kuupbam tawan katang yuaingge yatakuwawa natapbing. ");
INSERT INTO wnc_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Siwan Buyambam tapatane kekeknga aknga iat gatake yuamayak kakngatane buya unin aawan kake musiane nangaakan natake anzing yaking, “Masande engangu waapa dasing binga yuwik,” ngang natapbing. ");
INSERT INTO wnc_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Siwan Anututane Waung Kapata Jondane nana Sekaraiae musia tangenawan ita ayanikapsa aminda yakaing binga wamu takngatu anzing yakut, ");
INSERT INTO wnc_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Anutu ninu Isrel nanatane Buyambam tapanindane umana yatangenatna. Ninu Anututane aminabam ita apuke gatanimunggak. Gatanimuke iwanin zipmake yawamban yotna gatu kuningge gatanimunggak. ");
INSERT INTO wnc_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Anututane aminu tapatu nindane baminu umana Devit. Itane dongune aakuu tapatu Anututa tapan nin gatanimik. ");
INSERT INTO wnc_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Tupa siknga Anututa wamu takngatu yake yanikapsa amin yaniwan natake anzing yaking, ");
INSERT INTO wnc_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","‘Aminu akgatanimik kapata apu iwanin zipmake yawamban kuning,’ ngang yanikapsa aminda yaking. ");
INSERT INTO wnc_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Aminu wa gatanimik kapata apu tasiwan Anututa nindane baminde butaya natake gatayamikge yawan kekekakut takngae dua botawik. Asiknga gatanimik. ");
INSERT INTO wnc_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Anututa yake nindane baminu Ebrahamde wamu anzing iniwan kekekakut, ");
INSERT INTO wnc_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Iwanda zipmake yawamba kuning ngang iniwan kekekakut takngakan tasiniman inimbakngake gwaut buyak dua yutnim. ");
INSERT INTO wnc_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Unzing yusika tapduk dua kunim gwekatang ninda Anutue kaine noman siknga yusikanga apmea kumnim. ");
INSERT INTO wnc_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Siwan engang! Ga takawi aminbamda gae yake enane siknga yuak kapatane yanikapsa amin tapa ngangu gae yaning. Sike ga Buyambam tapae tupan kuke itane kepina tandakngaya. ");
INSERT INTO wnc_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Gata kepina tandakngake Buyambam tapanindane aminabamu wamu takngatu anzing yaniya. ‘Nata waiakngasa sandetdama iwanzae gepbiatang yutnanga dua,’ ngang yaniya. ");
INSERT INTO wnc_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Siwan Anututa musia kwikwiknga nataniman kwakanangge siwan saamda muke zikaa aknga tawamban sandewan kwakawan kaamang. Ina unzakan tapduknga Anututa akgatanimik gwenu ");
INSERT INTO wnc_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","gata kuku tasike aminu akumnanga aknga gepbiatang yuya aminde kakaa yeuyamuya. Siwan kepdakane yuwatna musip kwikwikge kepi yeutnimi kanim,” ngang Sekaraiata waaknga Jonde natake unzing yakapbut. ");
INSERT INTO wnc_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Sike masande engangu Jonu waapata takake natdetdetna pake aminu noman musia gitnaapa dakngake yukut. Yusika tapduknga puyana dua tangenawan Isrel aminda kainata anggaman dua kaking gwekatangu keu amina wena komune yukut. ");
INSERT INTO wnc_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Tapduk wagwene gavmanu tupan sikngaapa i binga tapatu wena. Umana Onggastas ngang iniking. Inane aminabamda takis mutningge umana matanangge ");
INSERT INTO wnc_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","ita yawan tuwanguke umana paking. Siwan tupan aminu tapatu umana Sairinias ngang iniking. Ita Siria kep komune tupan tapa dakngake yuwawan aminbamdane umana mataking. ");
INSERT INTO wnc_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Umana matanangge yawan aminu kuupbamda bamnatane kep komune kuwa umana undang paking. ");
INSERT INTO wnc_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Siwan Josepda dongu Devitdane dongune aakut tapa. Unzingge yot gapma Nasaret Galili kep komune yuak gapma teke uneta Judia kep komune kopbut. Koke Betlehem yot Devitda tupa siknga yukut gapmane kukut. ");
INSERT INTO wnc_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Maria musia kayaapane apnaat umana paningge kukumayak. ");
INSERT INTO wnc_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Kusika kundoke you wanggapmane yuwawat engangu dangem tapana tangaitnangge natake wawiapa tangaikut. You apetnanga gwenu gwa gitnawan kake kuke tangaike tauk sanda tapan kopan ikwawa gamande dopang gwekatang tewan yukut. ");
INSERT INTO wnc_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Siwan aminu kundu unenana kunduta sipsip toike you wesim peke zikaane kayuking. ");
INSERT INTO wnc_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kayuwawa Anututane angelata anggaman apan wa aminda kawawa Anututane kakaa aknganata waenga siknga siwan akagwauking. ");
INSERT INTO wnc_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Akagwauwa ngana angelata ginu ma gwaubam ngang yanikut, “Natapnong. Nata wamu take siknga aknga takapunggat,” ngang yanikut. “Aminbamda wamu waaknga natake musiane iaknga natake apbakngake yutning,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","“Tapduk anggwene Devitdane yot gapmane maya tapatuta engangu gwa tangaik. Aminu waapata ginu kuupbam gatandamik. Buyambam tapa Krais ngang ininangge,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","“Tuwangu ginda kake natdetningge daniwa natapnong. Ginda engangu tapatu taukga tapan kopan ikwawa gamandane dopangaatang tewan pewik ngang kake wamu wa daninggat taknga siakan ngang natapnong,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Angelata unzing yaniwawan zetgaman angela kwaapzang enandang nanata anggaman apuke angela waapaat gatake yuking. Yuke Anututane umana anzing yatangenaking, ");
INSERT INTO wnc_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Anututane umana enane siknga singgak. Siwan Anututa kep aminde musip gwaang natayamunggak kakwakngata musip kwikwik natake yutning,” ngang yatangenaking. ");
INSERT INTO wnc_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Siwan angelata wa amin peke enandang kopana sipsip toik aminu anzing yaking, “Ayok. Betlehem kuke sanga wa singgakge Buyambam tapata ninik kaknga kanim,” ngang yaking. ");
INSERT INTO wnc_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Yake sipsipna undang peke zetgaman kuke you wanggapmane kundoke Josepat Mariaatda undang yuwat kaking. Kawawa engang kapata sipsip gamandane dopang gwekatang peawan kaking. ");
INSERT INTO wnc_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Kakenga wamu Buyambam tapata engangu waapae yaniwan natapbingu une yaniking! ");
INSERT INTO wnc_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Yanike peke aminbam yanitakuwa natake aminbamda wamu sipsip toikga yaking kakngae nangaakan natapbing. ");
INSERT INTO wnc_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Siwan ngana Mariata wamu wa kuupbam musiane gitna pake natayukut. ");
INSERT INTO wnc_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Natake yuwawan toikga gatu kuke Anutu inimbakngaking. Angelata yaniwan natake kuke kaking kakngae inimbakngayuk kuking. ");
INSERT INTO wnc_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Siwan tapduu katau kuut musa kautdu gweaat gwenduat kawa puyuwana enganggane gupna mataking. Matakenga ita mingae musip ganang dua yuwawan angelata umana yakut takngae natake umana Jesu ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Siwan Anututane wapatang tupa siknga anzing matakut, “Waaknga dangem tapana aawiu Anututane sanga ngang yaninong. Yanike waapa takapuke Anutue nomune imunong,” ngang matakut. “Sangasa kwait suyuknga gweaya ba gubanga gweaya pakapuke Anutue imunong,” ngang matakut. Siwan mingata pasap wam takngatu gepbiatang kundusim yuke tapduknga kawan sandewan minga nanata Anututane mama wapatang matakut taknga tasinangge natake engang take Anutue nomune imunangge Jerusalem gapmane kopbumayak. ");
INSERT INTO wnc_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Siwan aminu tapatu umana Simion ngang iniking. Ita Jerusalem gapmane yukut. Aminu nomantapa asinggan asinggan baniaatangu Anutue nataak. Isrel nana gatayamik kapae natayuakut. Natayuwawan Anututane Waung Kapata gatangamukut. ");
INSERT INTO wnc_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Gatangamuke tupa inikut taknga natapbut. Ga zet dua kupiyak. Tapatuta apmea apu ginu Isrel nana gatandamik ngang Take apata tupa gwa yakut. Aminu waapata apan kakenga kupiyak ngang Waung Kapata inikut. ");
INSERT INTO wnc_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Inike sipdune Waung Kapata gatu iniwan Simionda Anututane yot takwan gwene kopbut. Koke kawawan mingananata Jesu betake Mosesdane mama wapatang tupa siknga Anututa yakut taknga engangu waapa tasingamunangge natake takopbumayak. ");
INSERT INTO wnc_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Takopat Simionda Jesu kake betayuk Anutue umana anzing yatangenakut, ");
INSERT INTO wnc_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Take apana wamu tupa naniwi kekekakut taknga buya anin tasiwi kaat. Na gatane puya aminda yuat siwan gata akupitde take ngang yawi nata akupanu meya sinanga dua. ");
INSERT INTO wnc_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Gata initewi gatanimik kapata gwa apan kaat. ");
INSERT INTO wnc_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Aminu kuupbamde kaine tasiyak. ");
INSERT INTO wnc_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Tasiwi ita apu dongu kundune nana Anutue dua nataaing aminu kakaa akngaka yeuyamunangge gwa apunggak. Apuke gatane aminda Isrel nana amindane umana buyambam siwikge apan kainata kaat, waapan,” ngang wamu waaknga Simionda Anutu inimbakngayuk Jesu betake yukut. ");
INSERT INTO wnc_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Siwan Jesutane minga nanata wamu Simionda Jesue yawan natake musiane nangaakan natapbumayak. ");
INSERT INTO wnc_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Natake yuwawat Simion waapata wam kwikwik yake Maria anzing inikut, “Anututa engangu aapa tapan pasiwan Isrel aminu kunduta apimaning. Siwan ita gatayaman buyambamda nomana yutning. Ita tuwang dakatu tasiwan kake aminbamda inisapdutning. ");
INSERT INTO wnc_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Siwan aminbamdane natdetdetna wai ngang anggaman siwik. Siwan kake waakgae butaya siknga natapiyak kaknga unzing. Paipda binga banipbaatang mapik,” ngang Simionda inikut. ");
INSERT INTO wnc_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Wam yakapsa aminu maya tapatu umana Ana ngang iniking. Itane nana Panuel Asetane dongune aakutapa. Sike waapa aminuake siknga apa. Tupa ita apna tapan nakanu katau kuut musa kautdu gweaakan ngang apnaat yukumayak. ");
INSERT INTO wnc_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Yuwawat apnata kupan inatakan kobatapa yukut. Yuke itane nakanu 84. Kake Anututane yot takwan gwenu dua teke kukut. Ita Anutue umana yatangenake nanamde bitake tumuk wam yake kwakngaom gatu zikaane ngang pasinggak. ");
INSERT INTO wnc_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Pasike yuwawan Simionda wamu waaknga Maria iniwawan Ana waapata inengan kuke engangu Jesu waapa kake Anutu inimbakngakut. Inimbakngayuk Anututa Jerusalem nanatane iwana zipmake yayawamban kuningge apbakngake yuya aminde engangu waapae yanikut, Anata. ");
INSERT INTO wnc_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Siwan sanga kuupbam Anutue mama wamda yakut binga tasiwat puyuwana gatuna Galili kep komune yotna Nasaret gapmane Jesutane minga nanata kukumayak. ");
INSERT INTO wnc_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Kuke yuwawat engangu Jesu waapata une yuke buyambam takake aminu kekeknga dakngakut. Ita natdetdetna buyambam siknga siwan Anututa gatangaman yukut. ");
INSERT INTO wnc_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Tupa siknga angelata Isrel nana yapbike Isipnana amin zipan kumbingge natake yuwatakak tapduk takwanu Pasova ngang yakaing gwen kanangge natake Jesutane minga nanata nakanbamu asinggan asinggan Jerusalem kokakumayak. ");
INSERT INTO wnc_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Siwan Jesuta nakanu katak kuut musaat kepianganu gweaat kawan sandewana iat minga nanaatda gatuna kopbing. ");
INSERT INTO wnc_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Koke tapduk takwanu wagwenu kawa sandewana yotna gatu pukunangge kukumayak. Kuwawat ngana waatdaka Jesu apata Jerusalem yuwawan minga nanaat aminbampat kepiapane kusika ");
INSERT INTO wnc_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","minga nanata Jesu dua kake ngana nikat kukamang ngang baniaatang natapbumayak. Natake gunziu gwendune kusika petnangge tasikumayak. Tasike notna banakan katang Jesue tawambat maiwana ");
INSERT INTO wnc_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Jerusalem gatu koke Jesue tawatake kopbumayak. ");
INSERT INTO wnc_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Koke gunziu gweaat gwenduat tawasika Anututane yot takwan gwekatang kakumayak. Kawawat Jesuta yanindamumsa aminde banakan katang pukwike waakwakgane wamna natake yake yakwaik wamu takngatu takngatu yanikwaiwan minga nanata kakumayak. ");
INSERT INTO wnc_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Kake yuwawat Jesuta yake yanike wamu takngatu yanikwaiwan natdetdetna buyambam siwan kake nangaakan natake Jesutane minga nanata asatnakumayak. ");
INSERT INTO wnc_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Asatnake mingata anzing inikut, “Waaknga. Nanggaat naatda gae gawanda maiwan meya siknga nataamak. Dasingge nitde unzingu tasikuyak,” ngang inikut. ");
INSERT INTO wnc_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Iniwan Jesuta yake anzing inikut, “Dasingge nawakamayak? Ita nanatane yot gwene yuak ngang dua nataamayak ba dasing,” ngang yanikut. ");
INSERT INTO wnc_vpl VALUES ("LK2_50","072_2_50","LUK","2","50"