﻿USE sofia;
DROP TABLE IF EXISTS sofia.wmw_vpl;
CREATE TABLE wmw_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES wmw_vpl WRITE;
INSERT INTO wmw_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Eci ndi kitabu ca rikolo ra Insa Almasihi, ujukulu wa Daudi, ujukulu wa Iburahima. Eku ndi kufulatana ka rikolo rake: ");
INSERT INTO wmw_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Iburahima kampongola Izaki, Izaki kampongola Yankubu, Yankubu kampongola Yuda pamoja na wanduze, ");
INSERT INTO wmw_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda kampongola Paresi na Zera, wana wa Tamari; Paresi kampongola Hesironi, Hesironi kampongola Arama, ");
INSERT INTO wmw_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Arama kampongola Aminadabu, Aminadabu kampongola Nashoni, Nashoni kampongola Salmoni, ");
INSERT INTO wmw_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmoni kampongola Bowazi, mwana wa Rahabu; Bowazi kampongola Obedi, mwana wa Ruti; Obedi kampongola Yese, ");
INSERT INTO wmw_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","na Yese kampongola Daudi, ajire akiwa nfalume. Daudi kampongola Selemani, mwana wa muka wa Uriya. ");
INSERT INTO wmw_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Selemani kampongola Rehoboyamu, Rehoboyamu kampongola Abiya, Abiya kampongola Asa, ");
INSERT INTO wmw_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa kampongola Yehoshafati, Yehoshafati kampongola Yoramu, Yoramu kampongola Uziya, ");
INSERT INTO wmw_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uziya kampongola Yotamu, Yotamu kampongola Ahazi, Ahazi kampongola Hezekiya, ");
INSERT INTO wmw_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekiya kampongola Manase, Manase kampongola Amoni, Amoni kampongola Yosiya, ");
INSERT INTO wmw_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosiya, wakati wasamisiwe akiperekiwa Babiloniya, kampongola Yekoniya na wanduze. ");
INSERT INTO wmw_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Bandi yakusamisiwa kuka Babiloniya, Yekoniya kampongola Shealtiyeli, Shealtiyeli kampongola Zerubabeli, ");
INSERT INTO wmw_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubabeli kampongola Abihudi, Abihudi kampongola Eliyakimu, Eliyakimu kampongola Azori, ");
INSERT INTO wmw_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azori kampongola Zadoki, Zadoki kampongola Akimu, Akimu kampongola Elihudi, ");
INSERT INTO wmw_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Elihudi kampongola Eleazari, Eleazari kampongola Matani, Matani kampongola Yankubu, ");
INSERT INTO wmw_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yankubu kampongola Yusufu, nlume wa Mariyamu, ampongore Insa, etiwa Almasihi. ");
INSERT INTO wmw_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Basi vizazi piya mwanzo wa Iburahima mpaka Daudi vipita vizazi kumi na vine. Mwanzo wa Daudi mpaka kusamisiwa kuperekiwa Babiloniya vipita vizazi kumi na vine. Na tangu ka kusamisiwa kuperekiwa Babiloniya mpaka wakati wa Almasihi vipita vizazi kumi na vine. ");
INSERT INTO wmw_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Sambi, kupongoriwa ka Insa Almasihi kukuna javi: Mariyamu mamaye Insa, kâpofiwa na Yusufu, falakini saanamba kunlomba, Mariyamu kariwonerera emite kwa nguvu ya Roho Takatifu, we! ");
INSERT INTO wmw_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yusufu nlumake, kwa kuwa mukweli na kutowa kusaka kumwanziri, akanzimiya kumwasa kisiiri-siiri. ");
INSERT INTO wmw_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Falakini iye, paakiwaza kutenda javire, kwa mpunde noure, laika wa Mola kanjira akilota, akimwambira javi: “Yusufu ujukulu wa Daudi! Usofeleye kunlomba Mariyamu nkawako, konta waasaka kupongola‑yo ampongola kwa uwezo wa Roho Takatifu. ");
INSERT INTO wmw_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Iye ampongola mwana nlume na ujuzi umwite zina rake Insa, konta iye awavusha wanu wake nkati ya madambi awo.” ");
INSERT INTO wmw_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Basi piya vikuna ipate utimiziwe usowezi wasowere Mola julu ya nabii, akamba: ");
INSERT INTO wmw_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Onani! Mwari mmoja wa bikira akuja kwimita, ampongola mwana nlume, na wamwita zina rake Emanueli, mana ake: ‘Mwenyezimungu kawa pamoja nofwe.’ ” ");
INSERT INTO wmw_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Paasisimuke usingizi, Yusufu akitenda kamba vyaambiriwe na laika wa Mola ire, akimpokerera nkawake. ");
INSERT INTO wmw_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Fala aamwijiwe mpaka kampongola toto nlume. Na akimwita zina rake Insa. ");
INSERT INTO wmw_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Sambi, paapongoriwe Insa Betlehemu inti ya Yudeya, wakati Herodi wawere nfalume, kwa mpunde noure wafika Yerusalemu wataalamu wakilawa upande wa mashariki, wakamba: ");
INSERT INTO wmw_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Apongoriwe nfalume wa Mayahudi‑yo kandepi? Kamana tiwona nondwa yake paikiwala, ndimana tija kuntukuza.” ");
INSERT INTO wmw_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Nfalume Herodi paasikire, kafazaika pakulu sana na wanu piya wa Yerusalemu wafazaika naye. ");
INSERT INTO wmw_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Akiwajumanisa piya walongozi wa dini na wanlimu wa shariya wákiwatumikira wanu, akiwadairi: “Almasihi akuja kupongoriwa ndepi?” ");
INSERT INTO wmw_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ewo wakinjibu: “Betlehemu inti ya Yudeya, konta vyandikiwa na nabii mmoja javi: ");
INSERT INTO wmw_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Uwe! Betlehemu, inti ya Yudeya, auri ntoto fúti kati ya walongozi wa Yudeya, konta kati ya uwe alawirira nlongozi, akuja kusunga umati wangu Iziraeli.’ ” ");
INSERT INTO wmw_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Sambi Herodi akiweta wataalamu ware, akiwadairi kisiiri-siiri wakatini wayilawirire nondwa ire. ");
INSERT INTO wmw_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ikisa akiwapereka Betlehemu akamba: “Ukani, mukadadishi sana-sana kuhusu toto‑yo. Mukimmonerera, tumizani kunambira ipate nomi nije nintukuze.” ");
INSERT INTO wmw_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Pawansikire nfalume ire, wakúka. Ona, noire nondwa yawawonire ikiwala ire, ikiwalongoza mpaka mahala paakiwa toto ire, ikimira. ");
INSERT INTO wmw_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Pawawonire nondwa ire, watenda radi na wafurahi pakulu sana. ");
INSERT INTO wmw_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Nakufika nnyumba, wammona toto ire pamoja na Mariyamu mamaye, wakikokora mbere yake, wakintukuza. Kuno wakifungula mali awo, wakintuzira zawadi: oru, lubani na mafuta a nsandali. ");
INSERT INTO wmw_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Noparepare iwesukira ruhuya wasiludire ka Herodi kure. Basi, kwa njira nyengine, wakiludira kwawo. ");
INSERT INTO wmw_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ewo pawaludire, mpunde laika wa Mola akinjira Yusufu julu ya ruhuya, akimwambira akamba: “Lamuka, nsukure toto‑yo pamoja na mamaye, utire uke Miswiri, ukekare mpaka nukwambire, konta Herodi ansakula toto‑yo amuulaye.” ");
INSERT INTO wmw_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Iye akilamuka, akintwala toto ire pamoja na mamaye, usiku-usiku akilawa, akuka Miswiri. ");
INSERT INTO wmw_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Akikala nokure mpaka Herodi akifwa, ipate vitimiziwe vyaambire Mola julu ya nabii mmoja, akamba: “Kulawa Miswiri nimwita mwanangu.” ");
INSERT INTO wmw_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Sambi, Herodi pejiwe kuwa katenviwa na wataalamu ware, kakimiwa pakulu futi. Akitumiza kuwolaya wasimana walume piya wa Betlehemu na wa kaya piya zíri karibu nawo, kwanza ka hirimu ya myaka miwiri na sawanamba kufika, kwa kutunza muda waawadairire wataalamu ware. ");
INSERT INTO wmw_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Basi vikitimiziwa vyaasemire nabii Yeremiya akamba: ");
INSERT INTO wmw_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Shauti isikirika Rama, kiriro na shuku pakulu, Rakeli awaririra wanawe, aasaka kunyamaziwa, kamana awapo.” ");
INSERT INTO wmw_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Sambi, nakufwa Herodi, kwa mpunde laika wa Mola akinjira Yusufu Miswiri nokure julu ya ruhuya, ");
INSERT INTO wmw_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","akamba: “Lamuka, unsukure toto‑yo pamoja na mamaye, uke inti ya Iziraeli, konta wakisakula kumulaya‑wo wafwa.” ");
INSERT INTO wmw_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Basi, paalamuke, akinsukula toto ire pamoja na mamaye, wakingira inti ya Iziraeli. ");
INSERT INTO wmw_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Fala, paasikire kuwa Arkelau kankumiliki Yudeya, kariti cewo ca Herodi wawaye, akopa kuka noko. Na paakumbusiwe kwa nloto, akilawa akuka makaya a Galileya. ");
INSERT INTO wmw_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Paafikire, akikala kaya ulu yakwitiwa Nazareti ipate vitimiziwe visemiwe na minabii kuwa: “Akwitiwa nNazareti.” ");
INSERT INTO wmw_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Nowo wakati‑wo, kalawirira Yahaya mwenyé Koza akihubiri nlanga ra Yudeya, ");
INSERT INTO wmw_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","akamba javi: “Tubiyani, kamana ufalume wa binguni uwa karibu!” ");
INSERT INTO wmw_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Kamana javi ndi vyaambiwe na nabii Izaya, Yahaya paakamba javi: “Shauti ya munu yankufula uto nlanga: Ntengezereni Mola njira yake, molosereni barabara yake yaasaka kupita.” ");
INSERT INTO wmw_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Sambi, Yahaya mavazi ake ákiwa a mabururu a ngamiya, ákivalanga ukanda wa sambala nkiuno, na cakurya cake cíkiwa mazorombe na ansali. ");
INSERT INTO wmw_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Nowo wakati‑wo, wanu wa Yerusalemu, na wanu piya wa Yudeya, na piya inti jirani za Yordani wakuka kwake iye, ");
INSERT INTO wmw_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","newo wakoziwa neye mmuto wa Yordani, kuno wakisema madambi awo. ");
INSERT INTO wmw_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Yahaya paawawonire Mafarizeu na Masaduseu wengi wakija kwake woziwe, akiwambira: “Umwe kabila ya manyoka! Nani akushongezereni kutira kukimiwa kusaka kuja? ");
INSERT INTO wmw_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Basi, ipani visumo vyakolota kutubiya. ");
INSERT INTO wmw_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Musiwaze watupu kwamba: ‘Tanawo baba, ndi Iburahima.’ Konta nukwambirani kuwa Mwenyezimungu kanawo uwezo wakupindula eya mawe‑ya kuwa wajukulu wa Iburahima. ");
INSERT INTO wmw_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Nepa katana ituriwa fúti panzipe wa muti. Ndimana, kila muti saupa visumo vyema usinjiwa, ukwefiwa pamoto. ");
INSERT INTO wmw_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Omi‑pa nukozani na maji molote kutubiya. Fala ája bandi ya omi kanawo uwezo pakulu koliko omi, iye omi sifãi kusukula tamango zake. Noyo-noyoni akuja kukozani na Roho Takatifu na moto. ");
INSERT INTO wmw_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Iye kisero ciwa mmakono mwake, akuja kumariza kupepeta, ataya mpunga wake nkikuti, fala membu akoca na moto sauzimika tena.” ");
INSERT INTO wmw_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Sambi, Insa akilawa Galileya, akuka ka Yahaya muto wa Yordani akoziwe. ");
INSERT INTO wmw_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Fala Yahaya akinkataza, akamba: “Omi ndi nisakula koziwa nowe, sambi ujaja nukoze omi?” ");
INSERT INTO wmw_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Insa akinjibu: “Kubali novyo sambi‑pa! Kamana ndi vyavitijuzi ipate titimize piya shariya.” Ndimana, akinkubali. ");
INSERT INTO wmw_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Insa, pesire koziwa, akilawa mmaji. Kwa mpunde nowo, akifunguririwa binguni wanzu, ng'waaa! Akimmona Roho wa Mwenyezimungu akimwisukira kamba pomba. ");
INSERT INTO wmw_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Apa! Na shauti ya kulawa binguni ikisema: “Eyu ndi Mwanangu wanimpenda, niwa radi naye.” ");
INSERT INTO wmw_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ikisa, Insa akitwariwa akukisiwa na Roho Takatifu palanga akayereriwe na Ibilisi. ");
INSERT INTO wmw_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Pesire kufunga suku arubaini, usiku na nsana, mwinsho ikinkola njala. ");
INSERT INTO wmw_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Cakúyerera ire akinfika karibu, akimwambira: “Kamba kuwa Mwana wa Mwenyezimungu, sowerera mawe‑ya ataduke mikate.” ");
INSERT INTO wmw_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Fala iye akinjibu, akamba: “Vyandikiwa javi: ‘Binadamu aainshi julu ya mikate basi, fala ainshi julu ya kila masemo a Mwenyezimungu.’ ” ");
INSERT INTO wmw_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ikisa Ibilisi akintwala Insa, akuka naye Yerusalemu kaya takatifu, akintula julu mahala parefu pakulu pa Nyumba Takatifu, ");
INSERT INTO wmw_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","akimwambira: “Kamba kuwa Mwana wa Mwenyezimungu, refye pansi, kamana yandikiwa: ‘Awamuru malaika wake kuhusu uwe, wakupokerera mmakono mwawo, mawe asukulumize anta aba mulu wako.’ ” ");
INSERT INTO wmw_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Insa akimwambira: “Vyandikiwa novyo javi: ‘Usimyerere Mola, Nlungu wako.’ ” ");
INSERT INTO wmw_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ikisa Ibilisi akinsukula tena, akuka naye mpaka pamwango nrefu sana, akimolotera inti za ulumwengu piya na ubora wa utajiri wawo. ");
INSERT INTO wmw_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Akimwambira: “Ukisujudi ukinitukuza omi, vinu‑vi piya nukupa.” ");
INSERT INTO wmw_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Insa akimwambira akamba: “Lawa‑pa, uka vyako, uwe Shetwani, konta yandikiwa javi: ‘Mola Nlungu wako, iye ndi waujuzi kuntukuza, kuntumika iye yeka yake tu basi.’ ” ");
INSERT INTO wmw_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Basi Ibilisi akimwasa. Mpunde noure malaika wakinfika karibu, wakintumika. ");
INSERT INTO wmw_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Insa, paasikire kuwa Yahaya kafungiwa, akiludira inti ya Galileya. ");
INSERT INTO wmw_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Akisama Nazareti, akuka akikala Kafarnaumu, kaya íri nanyenje ya tanda, upande wa inti ya Zabuloni na ya Naftali, ");
INSERT INTO wmw_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ipate vitimiziwe visemiwe na nabii Izaya, akamba: ");
INSERT INTO wmw_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Inti ya Zabuloni na inti ya Naftali, nanyenje ya tanda, kupunda muto wa Yordani, Galileya ya mataifa! ");
INSERT INTO wmw_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Wanu wari ngiza wawona nuru yakuwala pakulu sana, wekáre nkati ya inti na kati ya kinviri ca kifo, nuru iwazunguriza.” ");
INSERT INTO wmw_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kulawa noure wakati ure, Insa akanza kwereza, akamba: “Tubiyani, kamana ufalume wa binguni uwa karibu.” ");
INSERT INTO wmw_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Insa, paakenenda nanyenje ya tanda ra Galileya, kawawona wanu, munu na nduye: Ansumani etiwa Peduru, pamoja na nduye Andere, wakitaya nyavu ntanda mure konta wákiwa wavuvi. ");
INSERT INTO wmw_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Akiwambira: “Nifulateni omi, nukutendani kuwa wavuwi-wanu.” ");
INSERT INTO wmw_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Mpunde noure, nakwasa nyavu zire, wakinfulata. ");
INSERT INTO wmw_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Nakuka mbere, akiwawona wanu wengine, munu na nduye: Yakobu mwana wa Zebedeyu, pamoja na Yahaya, nduye Yakobu. Wákiwa mungalawa na wawa yawo Zebedeyu, wakiwanza nyavu zawo. Insa akiweta, ");
INSERT INTO wmw_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","newo mpunde noure wakasa ngalawa na wawa yawo, wakinfulata. ");
INSERT INTO wmw_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Insa akenenda piya inti ya Galileya, mmasinagoga mwawo kupita akifunda. Akereza Habari Ngema ya ufalume wa Mwenyezimungu, na akiponesa ulwere piya na maradi piya a wanu ware. ");
INSERT INTO wmw_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Kusifiwa kwake kusikirikana piya inti ya Siriya. Wakija nawo kwake iye piya walwere wa kila namuna ya malwazo na kopepesiwa, wakuwa na mashetwani, wa visalasala na wakuremala, neye akiwaponesa. ");
INSERT INTO wmw_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Wanu wengi wakinfulata, kulawa Galileya, Dekapoli, Yerusalemu, Yudeya pamoja na ng'ambu nyengine ya Yordani. ");
INSERT INTO wmw_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Pawonire makundi a wanu, Insa akikwera pamwango, akikala. Na wanafunzi wake wakuka wakijumana naye. ");
INSERT INTO wmw_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Akifungula kanywa, akanza kuwafunda akamba: ");
INSERT INTO wmw_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Heri ndi wenye kuriwona usikini roho zawo kamana ufalume wa binguni ndi wawo. ");
INSERT INTO wmw_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Heri ndi wenye kulalamika, kamana wakuja kunyamaziwa. ");
INSERT INTO wmw_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Heri ndi wenye kurinyenyekeya, kamana wakuja kuwa wenye ardhi. ");
INSERT INTO wmw_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Heri ndi wenye njala na nyotwa ya shariya, kamana wakuja kwikutisiwa. ");
INSERT INTO wmw_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Heri ndi wenye utungu, kamana newo wawoneriwa utungu. ");
INSERT INTO wmw_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Heri ndi wenye moyo swafi, kamana wakuja kummona Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Heri ndi wenye kupatanisa wanu, kamana wakwitiwa wana wa Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Heri ndi wenye kuhudiwa kwa sababu ya haki, kamana ufalume wa binguni ndi wawo. ");
INSERT INTO wmw_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Heri kwenu wakati wamwiniwa, na wamwandibiwa, na wamubuniriwa kila namuna ya ulongo, kwa sababu yangu omi! ");
INSERT INTO wmw_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Furahini na muwe radi pakulu, kamana thawabu yenu ndi ulu mbinguni. Kamana novyo ndi vyawandibiwe minabii wapitire kábula ya umwe.” ");
INSERT INTO wmw_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Insa akizidi kusema javi: “Umwe ndi munyu mulumwengu‑mu! Munyu ukilamwa, cílungiriwa kinani? Auna nguvu tena, ila ukwefiwa kunundu, uluwatiwa na wanu. ");
INSERT INTO wmw_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Umwe ndi nlangaza mulumwengu‑mu. Kaya yakujengiwa pajulu ya mwango aifisiwa. ");
INSERT INTO wmw_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Hapana munu akoréza kandiyeru kufinika na tamboru, ila atula pajulu ya meza, iwamwarikire wanu piya wári nnyumba. ");
INSERT INTO wmw_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Kwa namuna moja novyo, ulangare nlangaza wenu mbere ya wanu, ipate wawone vitendo vyenu vyema, wansifu Baba wenu ári mbinguni.” ");
INSERT INTO wmw_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Cengine Insa kawambira kaamba: “Musidanizire kamba nija kufuja shariya za Taureti au vyawakifunda minabii. Sijire kuvunja, ila nija kutimiza. ");
INSERT INTO wmw_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nukwambirani kweli kuwa, mpaka kwisa ka bingu na ardhi, aipo fataha wala shada isaka kulaviwa nTaureti mpaka vinu piya vitimiziwe. ");
INSERT INTO wmw_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ndimana, munu afúja ezi ámuri‑zi, anta iwe noto moja tu basi, na kuwafunda wenziwe watende novyo, akuja kuwoniwa ntoto futi nkati ya ufalume wa binguni. Falakini afuláta ezi ámuri‑zi kuno akifunda, akuja kuwoniwa nkulu nkati ya ufalume wa binguni. ");
INSERT INTO wmw_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Basi, nukwambirani kuwa shariya yenu, ikitowa kupunda haki ya wanlimu wa shariya na Mafarizeu, amwingira futi ufalume wa binguni.” ");
INSERT INTO wmw_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Kawambira tena javi: “Musikira vyawambiriwe wámida, ‘Usiulaye. Olaya onse, imbidi ahukumiwe.’ ");
INSERT INTO wmw_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Falakini omi nukwambirani kuwa piya-mwe mwenyé kunkimwira mwenziwe, imbidi ahukumiwe. Mwenyé kunkejeli mwenziwe, imbidi oke kumilandu. Mwenyé kumwita mwenziwe ‘zozo’, imbidi oke motoni. ");
INSERT INTO wmw_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Sambi, ikiwa kwankulavya swadaka yako julu ya uralu, nopo ukikumbukira kuwa mwenziwo kanawo dugudugu julu yako, ");
INSERT INTO wmw_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","asa nopo swadaka‑yo mbere ya uralu‑wo, uke ukapatane kwanza na mwenziwo. Sambi, ukiludi, lavya swadaka yako. ");
INSERT INTO wmw_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Patana na aduwi wako upesi paúri naye munjira ipate asukupereke ka mwenyé kulamula, neye kukupereka ka amiri wa kalaboshu, wefyeriwe nomo. ");
INSERT INTO wmw_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nukwambira kweli, visaka kuwa vyonse, aulawa‑mo mpaka uripe nzuruku kamili.” ");
INSERT INTO wmw_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Insa kawafunda tena javi: “Musikira vyayâmbiwe, ‘Usizinge’. ");
INSERT INTO wmw_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Falakini omi nukwambirani kuwa kila mwenyé kunnang'aníza mwanamuka ka kumperereza iye, kazinga futi. ");
INSERT INTO wmw_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Basi sambi, kamba rikukosesa riso rako ra nkono nriro, kotopola, wefye baidi yako. Kamana, ndi fadari kwako kwefya kifingo kimoja ca mwiri wako, koliko mwiri wako nzima kwingira motoni. ");
INSERT INTO wmw_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Na kamba ukukosesa nkono nriro wako, tupula nowo, wefye baidi yako. Basi, ndi fadari kwako kwasika kifingo cako kimojawapo, koliko mwiri wako nzima kwingira motoni. ");
INSERT INTO wmw_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Yambiwa novyo javi, ‘Amwása nkawake onse, ampe talaka.’ ");
INSERT INTO wmw_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Falakini omi nukwambirani kuwa kila mwenyé kumwasa nkawake saíri kwa sababu ya uzinzi, muka‑yo antenza kuzinga. Na mwenyé kunlomba muka wakwasiwa, kankuzinga.” ");
INSERT INTO wmw_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Insa akizidi kuwambira: “Musikira tena vyawâmbiriwe wámida: ‘Usilapire ulongo ila mutimize mbere ya Mola kulapa kwenu.’ ");
INSERT INTO wmw_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Falakini omi nukwambirani kuwa usilapire kinu ciwa conse: wala binguni kamana ndi kiti ca Mwenyezimungu, ");
INSERT INTO wmw_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","wala usilapire duniya, kamana ndi yaluwatira maulu ake, wala usilapire Yerusalemu kamana ndi kaya ya Nfalume Nkulu, ");
INSERT INTO wmw_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","wala usilapire kiswa cako kamana auna uwezo wa kubadili nywiri zako kuwa nyelupa au nyerufi. ");
INSERT INTO wmw_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Basi, kusowera kwenu kuwe ‘aye’ íri ‘kweli aye’, ‘sivyo’ íri ‘kweli sivyo’. Ca kupunda epo conse, cilawa ka Mbaya.” ");
INSERT INTO wmw_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Cengine kawambira kaamba: “Musikira vyayâmbiwe kuwa: ‘Riso kwa riso, rino kwa rino.’ ");
INSERT INTO wmw_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Fala omi nukwambirani kuwa musishindane na wenye kukutendani ubaya. Kwasa javyo, ikiwa munu kakwibiya langu ra nkono nriro, zungunuka umpe langu ra upande mwengine. ");
INSERT INTO wmw_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ikiwa munu kakukeshari atware anzu yako, kazaku rako nero mwasire. ");
INSERT INTO wmw_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Munu akukulazimisha kusukula kinu kilometuru moja, uka naye mpaka mbiri. ");
INSERT INTO wmw_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Munu akukulebela kinu kimojawapo, mpe, na munu akija kukukopa, nkopeshe usinture minyongo.” ");
INSERT INTO wmw_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Ikisa kawambira javi: “Musikira vyayâmbiwe, ‘Mpende mwenziwo, mwine aduwi wako.’ ");
INSERT INTO wmw_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Fala omi nukwambirani javi: Wapendeni maaduwi wenu, na watendereni duwa wenye kukulumbatani, ");
INSERT INTO wmw_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ipate muwe wana wa Baba wenu ári binguni. Kamana awarisa juwa rake ka wema na wabaya, anyesa nvula ka wenye shariya na sawana shariya. ");
INSERT INTO wmw_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kamana mukiwapenda wenye kukupendani, thawabuni yamupata? Sinovyo vyawatenda anta wenye kuripisa nsoko? ");
INSERT INTO wmw_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Mukiwadairi habari wenzenu basi, camutendire ndi cepi? Sinovyo vyawatenda anta wanu sawamwijiwa Mwenyezimungu? ");
INSERT INTO wmw_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Basi mukamilike kamba vyakamilike Baba wenu ári binguni.” ");
INSERT INTO wmw_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Insa kasowera tena javi: “Onani! Musitende shariya yenu mbere ya wanu kuwóniwa. Mukitenda javyo, amupata thawabu ka Baba wenu ári binguni. ");
INSERT INTO wmw_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ndimana, paulavya zaka, mbere yako usibiye umambi, kamba wanafiki vyawatenda kusinagoga na munjira, wasifiwe na wanu. Nukwambirani kweli kuwa wesa kupata futi thawabu zawo. ");
INSERT INTO wmw_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Fala uwe, ukilavya zaka, usase nkono sonto wako kwijiwa citenda nkono nriro wako, ");
INSERT INTO wmw_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","zaka yako iwe kwa siiri. Na Baba wako, awona siiri, akujanliya.” ");
INSERT INTO wmw_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Insa kazidi kuwambira kaamba: “Pamulebela duwa, musitende kamba vyawatenda wanafiki. Kamana ewo kuwajibu kwimira kulebela duwa mmasinagoga na mmamembe ipate wawoniwe na wanu. Nukwambirani kweli kuwa wapata futi thawabu zawo. ");
INSERT INTO wmw_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Fala uwe, ukilebela duwa, ingira nkisusi mwako, nakufunga nryango, ulebela duwa ka Baba wako arípo kwa siiri. Na Baba wako, awóna kwa siiri, akujanliya. ");
INSERT INTO wmw_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Pamulebela duwa, musisowere novyo-novyo masemo mengi saana mana, kamba vyawatenda sawamwijiwa Mwenyezimungu. Ewo wawaza kuwa, kwa sababu ya usowezi mwingi, wasikiriwa. ");
INSERT INTO wmw_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Basi musiwalandanise, konta Baba wenu akwijiwa camusakula kábula samunlebele. ");
INSERT INTO wmw_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Kwa javyo, pamulebela duwa, ambani javi: ‘Baba wetu uri binguni, rikurisiwe zina rako, ");
INSERT INTO wmw_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","uje ufalume wako, vitendiwe vyausaka kamba vitendiwa mbinguni, na mulumwengu‑mu vitendiwe novyo. ");
INSERT INTO wmw_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Tipe luziki rero ratisakula kila suku. ");
INSERT INTO wmw_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Tiswamii makosa etu, kamba ofwe novyo vyatiwaswamii watikosa. ");
INSERT INTO wmw_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Usitase kutingira ushetwani, fala tinusuru mmakono mwa Mbaya.’ ");
INSERT INTO wmw_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Sambi, mukiwaswamii wanu makosa awo, na Baba wenu mbinguni akuswamiini novyo. ");
INSERT INTO wmw_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Fala kamba amuwaswamii wanu, na Baba wenu aakuswamiini tena.” ");
INSERT INTO wmw_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ikisa kawambira javi: “Pamufunga, musiwalande manafiki wafunga wajii, kamana wanyatisa kumaso kwawo ipate wawoniwe na wanu kuwa wafunga. Omi nukwambirani kweli kuwa ewo wesa kupokerera thawabu zawo. ");
INSERT INTO wmw_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Falakini uwe, ukifunga, taya kumaso na usamure nywiri zako, ");
INSERT INTO wmw_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ipate usiwoniwe na wanu kuwa kufunga, ila wijiwiwe na Baba wako arípo kwa siiri. Na Baba wako, awóna kwa siiri, akujanliya.” ");
INSERT INTO wmw_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Cengine tena Insa kasema javi: “Musiriturire mali mulumwengu‑mu múri uswa na ange yaribungi piya vinu, na wevi wavunjanga miryango wakwiwa. ");
INSERT INTO wmw_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Fala riturireni mali enu mbinguni, mahala savyaribika na uswa wala na ange, wala wevi sawavunja nryango wakitowa kwiwa, ");
INSERT INTO wmw_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","kamana paari mali ako, na moyo wako ndi pauwa nopo. ");
INSERT INTO wmw_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Sambi, kandiyeru ya mwiri ndi riso rako‑ro. Ikiwa maso ako meema, mwiri wako piya ukuwa nuru. ");
INSERT INTO wmw_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Fala ikiwa riso rako ribaya, mwiri wako piya ukuwa nkisi. Kwa javyo, ikiwa nlangaza kwako uwe kisi, kisi cako kikulu pakulu. ");
INSERT INTO wmw_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Hapana munu akidiri kuwatumikira mamwenye wawiri, kamana mmoja amwina, mwengine ampenda. Au aryaminisa ka mmoja, mwengine ankejeli. Basi, avikidirika kuntumika Mwenyezimungu pamoja na mali. ");
INSERT INTO wmw_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ndimana omi nukwambirani javi: Musishugulike na mainsha enu, camusaka kurya wala kunywa wala mwiri wenu camusaka kuvala. Mainsha sibora zaida ya cakurya? Na mwiri sibora zaida ya mavazi? ");
INSERT INTO wmw_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Wanang'anizeni wanyuni julu: sawavyala wala sawavuna wala sawariturira nkikuti, fala Baba wenu ári binguni awarisa. Umwe sibora koliko ewo‑po? ");
INSERT INTO wmw_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nani kati yenu ashugúlika kakidiri kongeza ora moja ya uhai wake? ");
INSERT INTO wmw_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Na mavazi, sababuni umwe kushugulikira? Tunzani maluwa a nnundu, namuna vyaakula. Aakola kazi wala aapakasa nguwo. ");
INSERT INTO wmw_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Nukwambirani kuwa anta Selemani na ubora wake piya aavarire kamba luwa rimojawapo. ");
INSERT INTO wmw_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Basi, ikiwa Mwenyezimungu avaza minyani ya nnundu iripo rero, yakuwa makeshamungu ilungula moto, futi aazidi kukuvazani umwe, wenye kwamini aba? ");
INSERT INTO wmw_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Basi, musishugulike kwamba: ‘Tiryani?’ au ‘Tinywani?’ au ‘Tivalani?’ ");
INSERT INTO wmw_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Kamana piya-vyo wanu sawamwijiwa Mwenyezimungu wasakula. Falakini ijiwani kuwa Baba wenu ári mbinguni akwijiwa kuwa musakula piya-vyo. ");
INSERT INTO wmw_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Basi, sakulani kwanza ufalume wa Mwenyezimungu na shariya yake, nevyo vinu-vyo piya vikongeziwa kwenu. ");
INSERT INTO wmw_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Musishugulike na makeshamungu, konta makeshamungu‑yo irishugulikira wanyewe. Vitosha kila suku na ubaya wake.” ");
INSERT INTO wmw_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Na tena kawambira kaamba javi: “Musilaumu, nomwe musilaumiwe, ");
INSERT INTO wmw_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","konta kamba vyamulaumu, mulaumiwa novyo. Na namuna ya kipimo camupimira, mupimiriwa noco novyo. ");
INSERT INTO wmw_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Sambi, mbana unang'aniza kizolo mmaso mwa mwenziwo, fala awufahamu kibawo ciri mmaso mwako? ");
INSERT INTO wmw_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Umwambiraja mwenziwo kuwa: ‘Asa nilavye kizolo mmaso mwako’, na kumbe mmaso mwako muwa kibawo? We! ");
INSERT INTO wmw_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Uwe nafiki! Lavya kwanza kibawo mmaso mwako, uwone sana-sana, ndipo unlavye kizolo mwenziwo. ");
INSERT INTO wmw_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Musiwape vinu takatifu waumbwa, wakukuzungunukirani wakupanyangulani. Wala musefye vifure vyenu mbere ya nguluwe, wasije kuluwata na maulu awo.” ");
INSERT INTO wmw_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Kawambira tena javi: “Lebelani, múpewa. Sakulani, múpata. Lombani hodi, mufunguririwa. ");
INSERT INTO wmw_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kamana kila alebéla, ápewa. Asakúla, ápata. Na alómba hodi, afunguririwa. ");
INSERT INTO wmw_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Nani kati yenu alebeliwa nkate na mwanawe, kampa riwe? ");
INSERT INTO wmw_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Au alebeliwa inswi, kampa nyoka? ");
INSERT INTO wmw_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Umwe, ingawa muwa wabaya, mukwijiwa kuwapa wanenu vinu vyema. Futi Baba wenu ári mbinguni aawapa vinu vyema ware wenye kunlebela? ");
INSERT INTO wmw_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Basi, piya vyamusaka kuwa wenzenu wakutendereni, nomwe watendereni novyo. Eya ndi mana a shariya ya Taureti pamoja na minabii.” ");
INSERT INTO wmw_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Akizidi tena kuwambira javi: “Ingirani nryango mpusu, kamana mpana ndi nryango wa njira ya ando yakumpereka munu motoni. Na wengi ndi wengira nowo nryango‑wo. ");
INSERT INTO wmw_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Fala nryango mpusu na njira musu ndi yuka kumainsha a peponi. Aba futi wasinganira nowo nryango‑wo.” ");
INSERT INTO wmw_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Insa kasowera tena kawambira javi: “More-moreni na minabii walongo, wakujírani wakilanda kamba makondoo, kumbe mmyoyo yawo iwa kamba miwinzi mikali. ");
INSERT INTO wmw_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Muwamanyira julu ya visumo vyawo. Muti wa miwa ukupa papaya? Au mpombwe ukupa mangera? ");
INSERT INTO wmw_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Basi, kila muti mwema ukupa visumo vyema, fala muti mbaya ukupa visumo vibaya. ");
INSERT INTO wmw_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Muti mwema aushubutu kupa visumo vibaya, na muti mbaya aushubutu kupa visumo vyema. ");
INSERT INTO wmw_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kila muti saupa visumo vyema usenguriwa, utaiwa moto. ");
INSERT INTO wmw_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Basi, kwa vitendo vyawo, muwamanyira.” ");
INSERT INTO wmw_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Insa kawambira kaamba javi: “Siyo kila aníta onse ‘Mwenye! Mwenye!’ akwingira muufalume wa binguni, ila ire aténda caasaka Baba ári mbinguni. ");
INSERT INTO wmw_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Suku ya Kiyama, wanu wengi wakuja kwamba: ‘Mwenye, Mwenye, sikweli atibushurire kwa zina rako? Na kwa zina rako, atiwatuwise mashetwani? Na kwa zina rako, atitendire maajuza mengi awenye?’ ");
INSERT INTO wmw_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Basi omi nukuja kuwambira: ‘Tangu sukwijiweni, lawani kumaso kwangu, umwe mutenda ubaya!’ ” ");
INSERT INTO wmw_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Insa kesiriza kwamba javi: “Basi sambi, kila asikíra usowezi wangu‑wu akitímiza, alandanisiwa na munu mwerevu ajengire nyumba yake pariwe. ");
INSERT INTO wmw_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Inya nvula, ijala myuto tapa-tapa, ivuma mepo, ibiya julu ya nyumba‑yo, falakini aigwire konta ijengiwa julu ya riwe. ");
INSERT INTO wmw_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Fala upande mwengine, kila asikíra usowezi wangu‑wu akitówa kutimiza, alandanisiwa tolu ajengire nyumba yake pansanga. ");
INSERT INTO wmw_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Inya nvula, ijala myuto tapa-tapa, ivuma mepo, ibiya julu ya nyumba‑yo, igwa irrr! Basi, kugwa kwake kukulu.” ");
INSERT INTO wmw_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Pesire Insa kusowera usowezi‑wu, makundi a wanu wakishanga namuna vyaakifunda, ");
INSERT INTO wmw_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","konta akifunda kamba mwenyé mamulaka, aakifunda kamba wanlimu wawo wa shariya. ");
INSERT INTO wmw_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Insa, pesuke pamwango, wanu wengi wakinfulata. ");
INSERT INTO wmw_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Mpunde noure camagundula akinfika karibu, akinkokorera, akamba: “Mwenye, ukisaka, kwanawo uwezo wa kuniswafi!” ");
INSERT INTO wmw_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Insa, nakolosa nkono, akinkumbula, akisema: “Nisaka, uwe swafi.” Na wakati noure, magundula ake are akiswafika! ");
INSERT INTO wmw_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Insa akimwambira: “Ona, usimwambire munu, ila uka ukarolote ka nkulungwa wa dini, ukapitise nadiri kamba vyaalaizire nabii Musa, ukawape ushahidi.” ");
INSERT INTO wmw_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Pengire Insa Kafarnaumu, nfalume wa masurudadu wa Roma akinfika karibu, akinlebela, ");
INSERT INTO wmw_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","akamba: “Mwenye! Ntumisi wangu kalala ukaya nlwere karemala, kankutabika pakulu futi.” ");
INSERT INTO wmw_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Iye akimwambira: “Omi nikúka, nímponesa.” ");
INSERT INTO wmw_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Nfalume wa masurudadu ire akinjibu, akamba: “Mwenye, siri bora uwe kwinama lupenu rangu! Ila, sowera usowezi wako tu basi, ntumisi wangu apona. ");
INSERT INTO wmw_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Kamana, omi novyo niwa sini ya mamulaka, nanawo novyo masurudadu sini yangu. Nimwambira mmoja ‘uka!’, akuka. Mwengine nimwambira ‘njo!’, akuja. Ntumisi wangu nimwambira ‘tenda kinu kada’, neye atenda noco.” ");
INSERT INTO wmw_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Insa paasikire javire, akitajabu, akiwambira wanu wakinfúlata ware, akamba: “Nukwambirani kweli kuwa, nkati ya wanu wa Iziraeli, sinamba kunsingana wakwamini pakulu kamba eyu! ");
INSERT INTO wmw_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nukwambirani kuwa wengi wakuja kulawa malawira-juwa na maswera-juwa, wakurya pamoja na Iburahima na Izaki pamoja na Yankubu, muufalume wa binguni. ");
INSERT INTO wmw_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Fala wanu wa nowo ufalume‑wo wakuja kwefiwa panja pakisi pi! Nopo kukuwepo kurira na kutafuna meno.” ");
INSERT INTO wmw_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ikisa Insa akimwambira nfalume wa masurudadu ire: “Uka, vikuwere novyo kamba vyawaminire.” Noure wakati ure, ntumisi wake ire akipona! ");
INSERT INTO wmw_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Insa, paafikire nyumba ya Peduru, kansingana nkwewe Peduru alarire pakinanda, ákiwa na homa. ");
INSERT INTO wmw_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Akinkumbula mmakono mwake, na homa ire ikimpita. Noparepare, akilamuka, akanza kumudumu. ");
INSERT INTO wmw_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Paifikire jironi, wakija nawo kwake wanu wengi wamashetwani. Iye, kwa usowezi wake tu basi, akiwatuwisa mashetwani. Piya wákiwa walwere akiwaponesa, ");
INSERT INTO wmw_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","ipate vitimu vyâmbiwe na nabii Izaya, âkamba: “Iye mwanyewe kasukula udainfu wetu, kapinga ulwere wetu.” ");
INSERT INTO wmw_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Sambi, Insa paawonire kuzunguriziwa na junudi ya wanu, akiwamuru wanafunzi wake walawe woke ng'ambu nyengine. ");
INSERT INTO wmw_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Nakunfika karibu mwanlimu mmoja wa shariya, akimwambira: “Mwanlimu, nukufulata kauka konse.” ");
INSERT INTO wmw_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Insa akinjibu akamba: “Marikule wanawo mapondo, wanyuni wakwirúka julu wanawo vitundu, fala Binadamu wa Binguni aana mahala pakutula kiswa kupumuzika.” ");
INSERT INTO wmw_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Nakisa, mwanafunzi wake mmoja akimwambira: “Mwenye, nipe rihusa kwanza nilawe, nikanzike wawa.” ");
INSERT INTO wmw_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Fala Insa akinjibu akamba: “Nifulate, wase wafwi wawazike wafwi wawo.” ");
INSERT INTO wmw_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Pengire Insa mungalawa, wanafunzi wake wakinfulata. ");
INSERT INTO wmw_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ikanza tufani mbahari, mpaka mungalawa mure ejala maji tapa, we! Fala Insa ákilala usingizi! ");
INSERT INTO wmw_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Wanafunzi wake wakinfika karibu, wakinlamusa, wakamba: “Mwenye, tivushe, epa tipoteya!” ");
INSERT INTO wmw_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Iye akiwambira javi: “Mbana muwa wofi? Umwe kwamini kwenu aba!” Basi, akilamuka, akisowerera mepo na bahari ka kwinyuka, kukitenda shuwari dembwe. ");
INSERT INTO wmw_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Wanu ware wakishanga, wakamba javi: “Eyu munu‑yu kawa namunani, mpaka mepo na bahari vinsikiriza?” ");
INSERT INTO wmw_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Pafikire ng'ambu nyengine, inti ya waGerasi, wakinjira kusowera naye wamashetwani wawiri, wakilawa kumakaburi. Ewo wakopesa pakulu futi, pakutowa munu kupita noyo njira‑yo. ");
INSERT INTO wmw_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Mpunde noure wakinyangula, kuno wakindairi: “Mwana wa Mwenyezimungu, mbana kwankutandibu? Kuja kuno kutopepesa wakati saunafika?” ");
INSERT INTO wmw_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Sambi, kitambo aba zíkiwapo nguluwe nyingi zikisungiwa. ");
INSERT INTO wmw_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Mashetwani ware wakinlebela Insa, wakamba: “Basi kamba utituwisa, tipe nafasi tingire nkonjo wa nguluwe zire.” ");
INSERT INTO wmw_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Iye akiwambira: “Aya, ukani!” Mashetwani ware, nakuwalawa wanu ware, wakuka wakiwengíra nguluwe zire. Basi, nkonjo wa nguluwe zire wakituwa pakulu wakifika pangulu, piya wakiteremukira mmaji wakifwa! Mama! ");
INSERT INTO wmw_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Wasunga wa nguluwe zire wakitira. Pawalawire, wakuka mpaka kaya ulu, wakereza piya habari zikunire zire na mambo awakunire wamashetwani ware. ");
INSERT INTO wmw_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Kusema kweli, wanu piya wa kaya ire wakuka ka Insa. Nakummona, wanlebela alawe inti yawo ire. ");
INSERT INTO wmw_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Pengire Insa mungalawa, akilokera ng'ambu nyengine, akuka mpaka kwawo. ");
INSERT INTO wmw_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Onani, wakija naye kitewe apingiwe mmashila. Insa paawonire kwamini kwawo, akimwambira kitewe ire, akamba: “Mwanangu, rimbisa moyo! Madambi ako aswamíiwa.” ");
INSERT INTO wmw_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Na kweli, wanlimu wa shariya wamojawapo wakanza kuwaza kimoyomoyo: “Eyu kankukufuru!” ");
INSERT INTO wmw_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Insa pejiwe mawazo awo, akamba: “Mbana mwankuwaza vinu vibaya mmyoyo mwenu? ");
INSERT INTO wmw_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Avi, kwamba ‘Madambi ako aswamíiwa’, au kwamba ‘Lamuka wenende’, cangupa ndi cepi? ");
INSERT INTO wmw_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Fala, nukoloterani kuwa Binadamu wa Binguni kanawo mamulaka a kuswamii madambi duniya.” Noparepare, iye kamwambira kitewe ire: “Lamuka usukure kinanda cako, uke vyako kwenu.” ");
INSERT INTO wmw_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Nakulamuka, akilawa, akuka kwake. ");
INSERT INTO wmw_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Junudi ya wanu ware pawammonire, wopa, wakintukuza Mwenyezimungu awapere wanu mamulaka kamba‑ya. ");
INSERT INTO wmw_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Insa, nakupita mahala pare, kammona mwananlume mmoja wakwitiwa Matwaya, ekáre mahala pakuripiwa nsoko. Akimwambira: “Nifulate!” Nakulamuka, akinfulata. ");
INSERT INTO wmw_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Insa paakirya cakurya nnyumba ya Matwaya pamoja na wanafunzi wake, ona, waja wanu wengi warípisi nsoko na wamádambi, wakikala kurya naye. ");
INSERT INTO wmw_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Mafarizeu, nakuwona javire, wakiwadairi wanafunzi wake ware: “Warípisi nsoko pamoja na wamádambi, mwanlimu wenu akurya nawo! Sababuni?” ");
INSERT INTO wmw_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Falakini iye, nakusikira javire, kaamba: “Wanu wakomu awapita wakinsakula dotoru, ila walwere.” ");
INSERT INTO wmw_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Basi, murifunde sana-sana mana a eya masemo‑ya: “Omi Mwenyezimungu nisaka huruma, sisaka swadaka.” Basi, omi sijire kuweta wenye shariya, ila wenye dambi. ");
INSERT INTO wmw_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Sambi, wanafunzi wa Yahaya mwenyé Koza wakifika karibu ya Insa, wakamba: “Ofwe na Mafarizeu mara nyingi tifunganga, ila wanafunzi wako awafunga. Sababuni?” ");
INSERT INTO wmw_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Insa akiwajibu: “Mudaniza kuwa warifiwe kuharusi wajuzi kukimiwa wari na mwenyé harusi? Fala suku yakutwariwa mwenyé harusi kati yawo, wakati‑wo wakuja kufunga. ");
INSERT INTO wmw_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Hapana mwenyé kutwala kipindi kipya, kutaya kiwamba munguwo ya mida, konta kipindi kipya‑co cilawa munguwo, nguwo‑yo izidi kupapuka. ");
INSERT INTO wmw_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Wala hapana munu atwála vinyu yakwanza kusemuka kutayirira nnumba zamida, konta ikiwa javyo, numba‑zo zipanjika, vinyu‑yo itawanyika na numba‑zo zikwaribika. Basi, tayani vinyu yakwanza kusemuka nnumba nyipya, javyo piya vikwikala suku nyingi.” ");
INSERT INTO wmw_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Insa, paawambire javyo, mpunde noure akifika nlongozi mmoja, akinkokorera, akamba: “Mwanangu mwari kafwa sambi‑pa. Fala ukúka, untula nkono wako julu yake, akuwa hai.” ");
INSERT INTO wmw_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Insa akilamuka, wakilongozana pamoja na wanafunzi wake. ");
INSERT INTO wmw_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ona, akifika karibu ya Insa mwanamuka mmoja ákiwa na ulwere wa mbobo muda wa myaka kumi na miwiri. Nakunfika kuminyongo kwake, akikumbula anzu yake, lupindo ra sini, ");
INSERT INTO wmw_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","kamana akiwaza javi: “Nikikumbula nguwo yake tu basi, nipona.” ");
INSERT INTO wmw_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Insa akizungunuka, akinnang'aníza, akimwambira javi: “Mwanangu, rimbisa moyo! Kwamini kwako kukuponesa.” Na mwanamuka ire, noure wakati ure, akiponesiwa. ");
INSERT INTO wmw_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Insa, paafikire kunyumba ya nlongozi ire, nakuwawona webii wa mitoriro na junudi ya wanu wakinyangula, ");
INSERT INTO wmw_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","akiwambira javi: “Aya, lawani‑pa! Mwari‑yu aafwire, kalala tu basi!” Falakini ware wakola kunseka. ");
INSERT INTO wmw_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Pawalaviriwe panja wanu ware, Insa akingira, akinkola nkono mwari ire, neye akilamuka! ");
INSERT INTO wmw_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ezi habari‑zi zikenera muinti mure piya. ");
INSERT INTO wmw_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Insa nakulawa pare, wanu sawawona wawiri wanfulata, kuno wakinyangula wakamba: “Mwana wa Daudi, titendere huruma!” ");
INSERT INTO wmw_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Iye nakufika ukaya, vipofu ware wakimukira karibu yake. Insa akiwadairi: “Mukwamini kuwa nanawo uwezo wakukuponesani?” Wakinjibu, “He, tukwamini, Mwenye!” ");
INSERT INTO wmw_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Basi, akiwakumbula mmaso mwawo, akamba: “Patani kadiri ya kwamini kwenu!” ");
INSERT INTO wmw_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Maso awo akiwafunguka, ngwee! Fala Insa akiwalaizira pakulu, akamba: “Onani, anta munu mmoja asijiwe!” ");
INSERT INTO wmw_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Falakini ewo, nakulawa pare, wakeneza habari zake muinti mure piya. ");
INSERT INTO wmw_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Pawalawire ware, onani, wanjisira Insa munu mmoja bubu wamashetwani. ");
INSERT INTO wmw_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Nakutuwisiwa shetwani, bubu ire akanza kusowera. Wanu wengi wakishanga, wakamba: “Tangu acinakuna kinu kamba eci inti ya Iziraeli!” ");
INSERT INTO wmw_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Fala Mafarizeu wakamba javi: “Awatuwisa mashetwani kwa nguvu za Nkulu wa mashetwani!” ");
INSERT INTO wmw_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Insa akipita akenenda kaya ulu‑ulu pamoja na kaya noto-noto zire piya, akifunda mmasinagoga mwawo, akereza Habari Ngema za ufalume wa Mwenyezimungu, na akiponesa kila namuna ya ulwere na shida piya. ");
INSERT INTO wmw_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Iye, nakuwawona wanu wengi ware, kawawonera utungu pakulu sana, konta wauzunika na wapoteya kamba makondoo sawana nsunga. ");
INSERT INTO wmw_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Kwa javyo, akiwambira wanafunzi wake javi: “Awapo mavuno mengi, falakini wakolakazi ndi aba! ");
INSERT INTO wmw_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Basi, nlebeleni Mwenyezimungu Mwenyé mavuno awapereke wakolakazi wavune mavuno ake.” ");
INSERT INTO wmw_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Insa, nakuweta wanafunzi wake kumi na wawiri, akiwapa mamulaka julu ya kuwatuwisa mashetwani, na waponese kila namuna ya ulwere na shida piya. ");
INSERT INTO wmw_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Mazina a mawalii kumi na wawiri ndiya: wakwanza ndi Ansumani atapiriwe zina ra Peduru, Andere nduye Peduru, Yakobu na Yahaya, munu na nduye wana wa Zebedeyu, ");
INSERT INTO wmw_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipi, Bartolomeu, Tamimu, Matwaya ákiripisanga nsoko, Yakobu mwana wa Alufeu, Tadeu, ");
INSERT INTO wmw_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Ansumani nKanaa, pamoja na Yuda Shikariyoti, anzungunuke Insa. ");
INSERT INTO wmw_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Insa kawatuma ewa kumi na wawiri‑wa, bandi yakuwalaizira javi: “Musuke ka wanu Sawari-Mayahudi, wala musingire kaya za waSamariya, ");
INSERT INTO wmw_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ila ukani kwanza ka waIziraeli, wasíke kamba makondoo. ");
INSERT INTO wmw_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Mwamusaka kupita‑mo, tangazani ezi habari‑zi javi: ‘Ufalume wa binguni uwa karibu!’ ");
INSERT INTO wmw_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Waponeseni walwere, waziribuseni wafwi, waswafini wamagundula, na watuwiseni mashetwani. Mupata bure, perekani bure. ");
INSERT INTO wmw_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Musirisukuze mali a oru wala a parata wala a shaba mmaramba mwenu. ");
INSERT INTO wmw_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Musisukure mirumba munjira, wala nguwo mbiri, wala viratu, wala ngombo. Kamana bora ndi nkolakazi na luziki rake. ");
INSERT INTO wmw_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Kila kaya ulu au noto yamufika yonse, nsakureni nani kamilifu, mufikire nopo mpaka kulawa. ");
INSERT INTO wmw_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Pamwingira nnyumba, komazani. ");
INSERT INTO wmw_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ikiwa wanyewe nyumba‑yo makamilifu, salama yenu wabaki nawo, fala ikiwa simakamilifu, salama yenu ikuludirani wanyewe. ");
INSERT INTO wmw_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Sakupokererani wala sasikiriza usowezi wenu, pamulawa nyumba‑yo au kaya‑yo, ripumuneni funfu mmaulu mwenu. ");
INSERT INTO wmw_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nukwambirani kweli, suku yakulamuriwa, hukumu ya makaya a Sodoma na Gomora ndi aba koliko hukumu ya kaya‑yo.” ");
INSERT INTO wmw_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Onani! Omi nukutumani kamba makondoo kati-kati ya miwinzi. Kwa javyo, muwe wajanja kamba masungula, na wororo kamba makweyi. ");
INSERT INTO wmw_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mutengemane! Kamana wanu wakuperekani mahala pamilandu, na nkati ya nsinagoga kukucapani viboko. ");
INSERT INTO wmw_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Na mbere ya mafumu na mafalume mukuja kutwariwa, kwa sababu zangu omi, ipate muwe mashahidi kwawo na mbere ya mataifa. ");
INSERT INTO wmw_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Mukiperekiwa, musishugulike cakwamba. Kamana nowo wakati‑wo, mukwambiriwa camusaka kwamba. ");
INSERT INTO wmw_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Konta sumwe musowera, asowéra ndi Roho wa Baba wenu, asowéra nkati yenu. ");
INSERT INTO wmw_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Munu akuja kumpereka nduye aulaiwe, na wawa antenda novyo mwanawe, na wana wakuja kubishana na wawa zawo kufika kuwolaisa. ");
INSERT INTO wmw_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Mukuja kwiniwa kwa sababu ya zina rangu. Fala asáka kuvumirira mpaka mwinsho, eyo akuja kuvushiwa. ");
INSERT INTO wmw_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Wakukulumbatani kaya‑yo, tuwirirani kaya nyengine. Nukwambirani kweli kuwa amumariza kupita kaya piya za Iziraeli saanaja Binadamu wa Binguni. ");
INSERT INTO wmw_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Hapana mwanafunzi anta mmoja wakumpúnda mwanlimu wake, wala ntumisi wakumpúnda mwenye wake. ");
INSERT INTO wmw_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Vitosha mwanafunzi kuwa kamba mwanlimu wake, na ntumisi kuwa kamba mwenye wake. Ikiwa mwenyé nyumba wamwita Belzebuli, futi wanu wa nnyumba mwake wawetaja?” ");
INSERT INTO wmw_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Basi musiwope ewo! Kamana hapana cakufiníkiwa sacifunuriwa, na cakufísiwa sacifisuriwa. ");
INSERT INTO wmw_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Canukwambirani pakisi erezani panlangaza, na camuteteriwa mmasikiro, ibiyani umambi. ");
INSERT INTO wmw_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Musiwope wanu wakuulaya mwiri, sawakidiri kuulaya roho. Ila mopeni pakulu ari na uwezo wakupoteza motoni mwiri pamoja na roho. ");
INSERT INTO wmw_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Sikweli madindi wawiri awoziwa raisi? Na anta mmoja aagwirira pansi bila kwijiwa Baba wenu. ");
INSERT INTO wmw_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Anta nywiri za nkiswa mwenu ziwalangiwa piya! ");
INSERT INTO wmw_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Basi, musope kamana muwa bora koliko madindi wengi. ");
INSERT INTO wmw_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Kwa javyo, kila mwenyé kwakikisha mbere ya wanu kuwa anifulata omi, nomi novyo nikwakikisha mbere ya Baba wangu ári binguni kuwa wangu omi. ");
INSERT INTO wmw_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Fala mwenyé kunikana omi mbere ya wanu, nomi novyo ninkana iye mbere ya Baba wangu ári binguni. ");
INSERT INTO wmw_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Musidanize kuwa nija kutawanya salama mulumwengu‑mu. Sijire kutawanya salama ila nija na upanga. ");
INSERT INTO wmw_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Kamana nija kunfitini mwananlume na wawaye, muka na mamaye, pamoja na munu na nkwewe. ");
INSERT INTO wmw_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Maaduwi wa munu ndi wári nnyumba mwake! ");
INSERT INTO wmw_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Mwenyé kumpenda wawaye au mamaye pakulu koliko omi siyo bora kwangu omi, na mwenyé kumpenda mwanawe pakulu koliko omi, siyo bora kwangu omi. ");
INSERT INTO wmw_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Munu saasukula nsalaba wake na kunifulata, siyo bora kwangu omi. ");
INSERT INTO wmw_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Awonérera mainsha ake, apoteza, fala apóteza mainsha ake kwa sababu yangu omi, asinganira.” ");
INSERT INTO wmw_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Akupókererani umwe, anipokerera omi. Na anipokérera omi, ampokerera anitumire omi. ");
INSERT INTO wmw_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ampokérera nabii kwa kuwa nabii apata tuzo ra nabii. Na ampokérera mwenyé shariya, kwa kuwa mwenyé shariya, apata thawabu ya mwenyé shariya. ");
INSERT INTO wmw_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nukwambirani kweli kuwa ámpa wasimana‑wa mojawapo kikombe ca maji akuzizima kwa kuwa mwanafunzi wangu, kwa hakika aakosa futi kupata thawabu yake.” ");
INSERT INTO wmw_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Insa pesire kuwalaiza wanafunzi wake kumi na wawiri, akilawa pare akuka kufunda na kwereza mmakaya mwawo. ");
INSERT INTO wmw_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yahaya nkalaboshu mure paasikire vitendo vya Almasihi, akiwatuma wanafunzi wake ");
INSERT INTO wmw_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","wakandairi javi: “Uwe nduwe úkijuzi kuja au tijuzi tinrindire mwengine mmojawapo?” ");
INSERT INTO wmw_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Insa akiwajibu, akamba: “Ukani mukamwambire Yahaya mambo a muri kusikira na a muri kuwona: ");
INSERT INTO wmw_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","wanu sawawona wankuwona, wakubadilika wankwenenda, wamagundula wankuswafiwa, makewewe wankusikira, wafwi wankuziripusiwa, na masikini wankwereziwa Habari Ngema. ");
INSERT INTO wmw_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Heri munu wakúwa kwangu omi aawona sababu yakunziwiya kuzidi kwamini.” ");
INSERT INTO wmw_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Sambi, pawokire vyawo, Insa akanza kuwambira wanu kuhusu Yahaya: “Paluwanja pare múka kuwona kinani? Nyani wakutikinyiwa na mepo? ");
INSERT INTO wmw_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Au múka kuwona kinani? Mwananlume wakuvala mavazi meema? Onani, wanu wakuvala mavazi meema, nnyumba ya nfalume ndi mwawári. ");
INSERT INTO wmw_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Fala noko múka kuwona kinani? Nabii? Nukwambirani kweli, iye kawapunda minabii. ");
INSERT INTO wmw_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Basi, iye ndi munu asemiwe nkati ya Mandiko: ‘Onani, nímpereka ntume wangu mbere yako, akutengezera njira mbere yako.’ ");
INSERT INTO wmw_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Kweli-kwelini nukwambirani kuwa nkati ya wana wapongoriwa na wanawaka, aanalawirira wakumpunda Yahaya mwenyé Koza. Falakini, ntoto muufalume wa binguni ndi nkulu wakunzaidi iye. ");
INSERT INTO wmw_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Tangu suku za Yahaya mwenyé Koza mpaka rero‑vi, ufalume wa binguni úkiwepo ushinda mwingi. Wamani wakenekeza kumiliki kwa nguvu. ");
INSERT INTO wmw_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Konta mpaka suku za Yahaya, minabii piya wabushuru na Taureti ibushuru novyo kuhusu nowo ufalume‑wo. ");
INSERT INTO wmw_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Basi, mukisaka kukubali, neye noyo ndi nabii Aliyasi akirindiriwa kuja. ");
INSERT INTO wmw_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Mwenyé masikiro, asikire! ");
INSERT INTO wmw_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Wanu wa eyi tarehe‑yi niwalandanise na wanani? Wawalanda wasimana wakwikala kubazari, wakiwanyangurira wenziwawo, ");
INSERT INTO wmw_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","wakamba: ‘Tukwibiirani mitoriro, amuvinire! Timba nyimbo za uzuni, amuririre!’ ");
INSERT INTO wmw_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Kamana kaja Yahaya aafúnga wala aánywa, ewo wasema: ‘Kanawo jini.’ ");
INSERT INTO wmw_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Kaja Binadamu wa Binguni akúrya na akúnywa, ewo wasema: ‘Mmoneni! Nfaji na nrevi‑yu! Rafiki wa waripísa nsoko na wamádambi!’ Novyo-sivyo wijiwifu wa Mwenyezimungu ukwijiwikana kwa vitendo vyake!” ");
INSERT INTO wmw_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ikisa, Insa akanza kuwalaumu wanu wa kaya zaakitenda maajuza mengi, konta awakitubiya. ");
INSERT INTO wmw_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Akamba: “Uwe, kaya ya Korazini, ulaniwe! Uwe, kaya ya Betisaida, ulaniwe! Konta maajuza akukunireni umwe, anakuna Tiru na Sidoni, nanga walawirira wengi wenye kutubiya, wakuvala maguniya na kuripaka rivu. ");
INSERT INTO wmw_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ndimana nukwambirani kuwa, suku yakulamuriwa, hukumu ya Tiru na Sidoni ikuja kuwa aba koliko yenu umwe. ");
INSERT INTO wmw_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Na uwe, Kafarnaumu, itakuwa ukweziwa? Ukwisusiwa mpaka Kuzimu! Kamana, maajuza akukunire uwe, anakuna Sodoma, kaya íri‑po mpaka rero! ");
INSERT INTO wmw_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Basi, nukwambirani kuwa, suku yakulamuriwa, hukumu ya kaya ya Sodoma ikuja kuwa aba koliko yako uwe.” ");
INSERT INTO wmw_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Noure wakati ure, Insa akisema, akamba: “Nukushukuru, Baba, Mola wa binguni na duniya, konta evi vinu‑vi kuwafisira wejiwifu na werevu, ila kuwafafanurira wanu watoto. ");
INSERT INTO wmw_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ndi kweli, Baba, kwa kuwa javyo ndi vyavikunowa mbere yako. ");
INSERT INTO wmw_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Piya vinu nigabiziwa na Baba wangu. Hapana amwijíwa Mwana ila Baba, na hapana amwijíwa Baba ila Mwana na ware wakuwa Mwana kawatondola kuwafafanurira. ");
INSERT INTO wmw_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Piya wenye kusokera na wenye kuwa na mashuguli mengi, njoni kwangu omi, nukupani pumuzi! ");
INSERT INTO wmw_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Twalani lunda rangu, murifunde kwangu omi, kamana nanawo imani na unyenyekevu wa moyo. Basi javyo, roho zenu zipumuzika, ");
INSERT INTO wmw_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","konta lunda rangu aririgariga, na nzigo wanukusukuzani úveyuka.” ");
INSERT INTO wmw_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Wakati‑wo, suku moja sabadu, Insa akipita mmasamba a tirigu. Wanafunzi ware ikiwakola njala, wakanza kuvunja masuke a tirigu, wakitafuna. ");
INSERT INTO wmw_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Fala Mafarizeu pawawonire javire, wakimwambíra: “Ló! Wawone wanafunzi wako wankutenda vinu saviri halali kutendiwa suku ya sabadu.” ");
INSERT INTO wmw_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Iye akiwajibu: “Amunafyoma vyaâtendire Daudi pamoja na wenziwe paiwakorire njala? ");
INSERT INTO wmw_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Kêngira nnyumba ya Mwenyezimungu pamoja na wenziwe, watafuna mikate yakutukuziwa. Saviri halali kutenda javyo ewo, ila íwa halali kutafuna walongozi wa dini tu basi. ");
INSERT INTO wmw_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Au amunafyoma Taureti kuwa walongozi wa dini wa nNyumba Takatifu wakikejeli suku ya sabadu, fala wawa wanu sawana makosa? ");
INSERT INTO wmw_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Basi omi nukwambirani kuwa epa kawapo nkulu koliko Nyumba Takatifu! ");
INSERT INTO wmw_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Munejiwa mana a ewu usemi‑wu: ‘Omi Mwenyezimungu nisaka huruma, sisaka swadaka’, amungari kuwalaumu wanu sawana makosa. ");
INSERT INTO wmw_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Konta Binadamu wa Binguni ndi Mwenye wa sabadu.” ");
INSERT INTO wmw_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Insa nakulawa pare, akuka nsinagoga mwawo. ");
INSERT INTO wmw_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ákiwapo munu wakuremala nkono. Ewo wandairi wakamba: “Mwaja! Halali kuponesa sabadu?” Wandairi javyo ipate wanlaumu. ");
INSERT INTO wmw_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Fala iye akiwambira: “Nani kati yenu áwa na kondoo mmoja kagwirira mpondo rikulu suku ya sabadu, kwa nowo wakati‑wo katowa kunkola, kunlavya? ");
INSERT INTO wmw_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Onani, aafãi pakulu munu koliko kondoo? Kwa javyo, halali kutenda meema suku ya sabadu.” ");
INSERT INTO wmw_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ikisa akimwambira munu ire, akamba: “Olosa nkono wako.” Iye akolosa na akiponesiwa, úkiwa nzima kamba mwengine. ");
INSERT INTO wmw_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Fala Mafarizeu wakilawa, wakitenda mpango wakumuulaya Insa. ");
INSERT INTO wmw_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Fala pejiwe mpango wawo ure, Insa karilavya pare. Wanu wengi wakinfulata, neye akiwaponesa piya, ");
INSERT INTO wmw_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","akiwalaizira wasereze vyaatendire. ");
INSERT INTO wmw_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Vitimiziwe vyaâsemire nabii Izaya kuwa: ");
INSERT INTO wmw_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Onani, eyu ndi Ntumisi wangu wanintondore, mpendani wangu anipéndeza mmoyo mwangu. Nintaya Roho yangu kati yake, iye atangaza namuna nyipya mbere ya mataifa. ");
INSERT INTO wmw_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Aakaidi wala aanyangurisana na munu, shauti yake aisikirikana panja. ");
INSERT INTO wmw_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Aanyanda muwa wakuvunjika, wala aazimisa paviyu yakufuka rosi, mpaka suku yakushinda shariya yangu. ");
INSERT INTO wmw_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Na zina rake, mataifa watumaini.” ");
INSERT INTO wmw_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ikisa Insa wakinjisira munu mmoja kipofu na bubu kwa sababu ya mashetwani. Iye akimponesa, ipate akidiri kusowera na kuwona. ");
INSERT INTO wmw_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Wanu piya wakishanga, wakamba: “Paa! Sinoyu‑yu ujukulu wa Daudi?” ");
INSERT INTO wmw_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Fala Mafarizeu pawasikire, wamba: “Eyu munu‑yu aawatuwisa mashetwani sairi kwa uwezo wa Belzebuli, nkulu wa mashetwani.” ");
INSERT INTO wmw_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Pejiwe ware cawari kuwaza, Insa kawambira: “Kila ufalume wakwawányika makundi akubishana watupu, ufujika. Na kila kaya au nyumba yakwawányika makundi akubishana watupu, aiinshi. ");
INSERT INTO wmw_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ikiwa Shetwani awatuwisa mashetwani, warawanya watupu, ufalume wake Shetwani‑yo uinshi mwaja? ");
INSERT INTO wmw_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Na ikiwa niwatuwisa mashetwani kwa uwezo wa Belzebuli, sambi wanafunzi wenu wawatuwisa kwa uwezo wa nani? Basi, ewo ndi wakulamulani. ");
INSERT INTO wmw_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Fala ikiwa niwatuwisa mashetwani kwa uwezo wa Roho wa Mwenyezimungu, basi ukufikirani futi ufalume wa Mwenyezimungu! ");
INSERT INTO wmw_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Au, munu nnyumba ya munu wakurimba akwingira kumwiwira mali ake, bila kwanza kunfunga mwanyewe, mwaja? Akinfunga ndi pamwiwira nnyumba mwake. ");
INSERT INTO wmw_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Munu saári pamoja nomi, abishana nomi, na sakusánya pamoja nomi, atawanya. ");
INSERT INTO wmw_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ndimana nukwambirani javi kuwa kila dambi na kufuru waswamiiwa wanu, fala kukufurira Roho Takatifu auswamiiwa. ");
INSERT INTO wmw_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Na asowéra kwa kubishana na Binadamu wa Binguni aswamiiwa, fala asowéra kwa kubishana na Roho Takatifu, aaswamiiwa ulumwengu‑wu wala usaka kuja.” ");
INSERT INTO wmw_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Tenderani juhudi muti uwe mwema, visumo vyake vikuwa vyema, au tenderani ubaya muti uwe mbaya, na visumo vyake vikuwa vibaya. Kusema kweli, muti ukwijiwikana kwa visumo vyake. ");
INSERT INTO wmw_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Umwe kabila ya manyoka! Musoweraja usowezi mwema, muri wabaya? Konta ciri kumoyo ndi cilawira pakanywa. ");
INSERT INTO wmw_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Munu mwema nkati ya ankiba ngema, alavya usowezi mwema, na dainfu nkati ya ankiba mbaya, alavya usowezi mbaya. ");
INSERT INTO wmw_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Basi, nukwambirani kuwa, suku yakulamuriwa, kila usowezi saufãi usowériwa na wanu, wakuka kujibu usowezi‑wo. ");
INSERT INTO wmw_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Konta kwa usowezi wako, ukwakikishiwa kuwa na haki, na kwa usowezi wako, uhukumiwa.” ");
INSERT INTO wmw_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Basi sambi, wanlimu wa shariya na Mafarizeu wamojawapo wakinlebela, wakamba: “Mwanlimu, tisaka tiwone alama yako.” ");
INSERT INTO wmw_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Fala iye akiwajibu: “Kizazi kibaya na cazinaa cisakula alama. Fala acoloteriwa alama saíri ya nabii Inusu. ");
INSERT INTO wmw_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Basi, kamba Inusu vyêkare suku natu usiku na nsana mmatumbo mwa inswi nkulu, na Binadamu wa Binguni akuja kwikala novyo nkaburi suku natu usiku na nsana. ");
INSERT INTO wmw_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Sambi, suku yakulamuriwa walawirira waNenive wahukumu kizazi‑ci, konta watubiya paakereza nabii Inusu. Na kumbe arípo epa kampunda Inusu! ");
INSERT INTO wmw_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ikisa tena, suku yakulamuriwa, alamusiwa rainya wa upande wa suheli ahukumu kizazi‑ci, konta kâlawa baidi futi kuka kusikiriza wijiwifu wa Selemani. Na kumbe arípo epa kampunda Selemani!” ");
INSERT INTO wmw_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Shetwani, akinlawa munu, apita mahala palanga, akisakula kupumula, fala aapata. ");
INSERT INTO wmw_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Sambi akwamba: ‘Niludira nyumba yangu kanilawire!’ Nakufika, asingana yawaka, yakufyairiwa, na yakutengiwa vinu sana-sana. ");
INSERT INTO wmw_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Akuka awatwala wenziwe saba wakumpunda iye mwanyewe. Nakwingira, wakwikala nkati‑mo. Kwa javyo, na munu‑yo hali yake ya mwinsho ikuwa mbaya kupunda pakwanza. Basi, novyo ndi vyacisaka kuwa eci kizazi kibaya‑ci.” ");
INSERT INTO wmw_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Insa, paakisowera na wanu, mamaye pamoja na wanduze wemira panja, wakisakula wasowere naye. ");
INSERT INTO wmw_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Munu mmoja akimwambira, akamba: “Ona! Mamayo na wanduzo wawa panja pare wasakula wasowere nawe.” ");
INSERT INTO wmw_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Iye akinjibu munu ire, akamba: “Mama omi ndi wepi? Wanduzangu ndi wepi?” ");
INSERT INTO wmw_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Nakolosa nkono akiwolota wanafunzi wake ware, akamba: “Epa ndi paári mama na wanduzangu! ");
INSERT INTO wmw_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Konta munu asaka kuwa onse aténda caasaka Baba wangu ári binguni, noyo ndi nduyangu na nlumbwangu na ndi mama.” ");
INSERT INTO wmw_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Noire suku ire, Insa akilawa nnyumba mure, akuka akikala nanyenje ya tanda. ");
INSERT INTO wmw_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Makundi ka makundi a wanu wakinzunguriza, ndimana kakwera mungalawa, akikala. Wanu ware piya wémira nanyenje ya tanda rire. ");
INSERT INTO wmw_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Noparepare, akiwafunda wanu vinu vingi vyawenye kwa kinyume, akamba: “Ákiwepo mwananlume mmoja akipita akivyala. ");
INSERT INTO wmw_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Paakivyala, mbeyu nyengine igwirira munjira, zija nyuni zidodola. ");
INSERT INTO wmw_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Mbeyu nyengine igwirira mmawe, mahala saapana misanga, noure wakati ure iwota konta aíkiwepo misanga mingi. ");
INSERT INTO wmw_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Fala pariwarire juwa, senge ire ifwa, konta aíkiwa na mizipe sana. ");
INSERT INTO wmw_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Mbeyu nyengine igwirira mmiwa, iwota, fala muti unyala. ");
INSERT INTO wmw_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Mbeyu nyengine igwirira munsanga wa rutuba, ipa visumo, muti mmoja miya, nyengine sitini, na nyengine talatini. ");
INSERT INTO wmw_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Basi, mwenyé masikiro, asikire!” ");
INSERT INTO wmw_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Wanafunzi ware wakinfika karibu, wakindairi javi: “Sababuni kuwambira kwa kinyume?” ");
INSERT INTO wmw_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Iye akiwajibu akamba: “Konta umwe‑po mwijiwisiwa siiri za ufalume wa binguni, fala ewo‑po awejiwisiwe. ");
INSERT INTO wmw_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kamana mwenyé kuwa na kinu, apewa akuwa na vingi, fala munu saana kinu, aba caári nawo noco anyang'anyiwa. ");
INSERT INTO wmw_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ndimana niwasowerera kwa kinyume, konta wanang'aniza fala awawona, wasikiriza fala awasikira wala awereriwa. ");
INSERT INTO wmw_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Javyo vitimiziwa kwawo vyaâsemire nabii Izaya, akamba: ‘Musikira na masikiro fala amwereriwa anta aba, nakunang'aniza munang'aniza fala amuwona anta aba. ");
INSERT INTO wmw_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Konta myoyo ya wanu‑wa migumu. Masikiro awo aasikira sana, maso awo afunga. Siwere javyo, maso awo nanga awona, masikiro awo nanga asikira, myoyo yawo nanga yerériwa, ewo nanga waludi waja kwangu, nomi nanga niwaponesa’ ” amba ndi Mola. ");
INSERT INTO wmw_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Insa akiwambira tena: “Heri maso enu konta muwona, pamoja na masikiro enu konta musikira. ");
INSERT INTO wmw_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nukwambirani kweli kuwa minabii wengi na makamilifu vîwajibu kuwona vyamuwona‑vi fala awawonire, na kusikira vyamusikira‑vi, fala awasikire.” ");
INSERT INTO wmw_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Sikirizani mana a kinyume kuhusu nvyari: ");
INSERT INTO wmw_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Kila mwenyé kusikira usemi wa ufalume akitowa kwereriwa mana ake ndi ire mbeyu igwirire munjira. Akuja Ibilisi anlavya círi mmoyo mwake. ");
INSERT INTO wmw_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Mbeyu igwirire mmawe ndi mwenyé kusikira usemi, nopo ka nopo kapokerera na furaha, ");
INSERT INTO wmw_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","fala aainshi nawo suku nyingi, kwa kuwa aana mizipe nkati yake. Akija akimpata mashaka au kulumbatiwa sababu ya usemi wa Mwenyezimungu, abugudika, akwasa. ");
INSERT INTO wmw_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Mbeyu igwirire kati-kati ya miwa ndi mwenyé kusikira usemi, fala kwa sababu ya mashuguli a kila suku, pamoja na udanganyifu wa mali, vikinya usemi, ubaki saupa visumo. ");
INSERT INTO wmw_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Na ire mbeyu igwirire munsanga warutuba, ndi mwenyé kusikira usemi, kwereriwa sana-sana, na kweli ukupa visumo: muti mmoja visumo miya, mwengine sitini na mwengine talatini.” ");
INSERT INTO wmw_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Kinyume cengine kawambira, kaamba: “Ufalume wa binguni uwa kamba munu wakuvyala mbeyu ngema mmasamba mwake. ");
INSERT INTO wmw_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Falakini wanu pawalarire, akija aduwi wake akivyala minyani nkati ya tirigu, akuka vyake. ");
INSERT INTO wmw_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Paikurire tirigu ire ikitambuluka, na minyani ikanza kuwoneka. ");
INSERT INTO wmw_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Basi, wakolakazi wa mwenyé-nyumba wakinfika karibu, wakimwambira javi: ‘Mwenye! Mmasamba mwenu mure, amuvyarire mbeyu ngema? Sambi, minyani ire yankulawirira ndepi?’ ");
INSERT INTO wmw_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Iye akijibu: ‘Aduwi mmojawapo ndi atendire javyo.’ Wakolakazi ware wakindairi: ‘Musaka tikadobore minyani ire?’ ");
INSERT INTO wmw_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Fala iye akiwajibu: ‘Musuke kudobola, konta pakudobola musanganya na tirigu. ");
INSERT INTO wmw_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Asani kwanza ikure na tirigu mpaka wakati wa mavuno. Wakati‑wo ndi panisaka kuwambira wavuni kuwa: “Kwanza lavyani minyani, mufunge vinyang'anya vyociwe moto, fala tirigu‑yo vunani, mutaye nkikuti mwangu.” ’ ” ");
INSERT INTO wmw_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Insa akiwambira tena kinyume cengine: “Ufalume wa binguni uwa kamba mbeyu ya mostarda, yatwarire munu mmoja akivyala mmasamba mwake. ");
INSERT INTO wmw_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ingawa eyo mbeyu‑yo noto koliko mbeyu piya, fala nrayi ukikula ukuwa nkulu koliko mirayi piya, anta nyuni wakuja wakijenga vitundu nvitambi vyake.” ");
INSERT INTO wmw_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Akiwambira tena kinyume cengine: “Ufalume wa binguni uwa kamba furumento. Mwanamuka atwala furumento aba javi, asanganya na ufu wa tirigu mwingi. Furumento ire ikwingirirana muufu mure piya.” ");
INSERT INTO wmw_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Evi vinu‑vi piya Insa kawambira wanu kwa kinyume. Aakiwambira kinu bila kutumira kinyume. ");
INSERT INTO wmw_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Kwa javyo, vikitimu vyaâsemire nabii mmoja kuwa: “Nifungula kanywa, nikwereza kwa kinyume vinu virifisire tangu mwanzo wa ulumwengu.” ");
INSERT INTO wmw_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Sambi, Insa paasire junudi ya wanu ire, akuka kwake. Noparepare, wanafunzi wake wakinfika karibu, wakamba: “Tambire mana ake kinyume kuhusu minyani mmasamba.” ");
INSERT INTO wmw_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Iye akiwajíbu: “Munu avyála mbeyu ngema ndi Binadamu wa Binguni. ");
INSERT INTO wmw_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Masamba ndi ulumwengu, mbeyu ngema ndi wanu wakuwa ufalume ndi wawo. Minyani ndi wanu wári upande wa Ibilisi, ");
INSERT INTO wmw_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","na aduwi avyarire minyani ndi Ibilisi. Mavuno ndi mwinsho wa ulumwengu, na wavuni ndi malaika. ");
INSERT INTO wmw_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Kwa javyo, kamba vyailaviwa minyani ikociwa moto ndi vyavisaka kukuna suku ya Kiyama. ");
INSERT INTO wmw_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Binadamu awapereka malaika wake wawakusanye na wawalavye nkati ya ufalume wake piya, wawakóresa dambi wenziwawo na wenye kutenda vitendo vibaya. ");
INSERT INTO wmw_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ware wawefya motoni, mahala pawoka kurira na kutafuna meno. ");
INSERT INTO wmw_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Basi wenye shariya wakuka kung'anira kamba juwa nkati ya ufalume wa Baba yawo. Mwenyé masikiro, asikire.” ");
INSERT INTO wmw_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Ufalume wa binguni ulandana na mali akufisiwa mmasamba. Vyaapita munu akiwonerera na akifisa mmasamba nomo tena. Kwa radi yake yawenye akúka, kuuzanya piya vyaári nawo, ikisa akuza masamba are! ” ");
INSERT INTO wmw_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Kinyume cengine, ufalume wa binguni ulandana na ncuruzi mmoja wakusakula ambari yakusitawi pakulu. ");
INSERT INTO wmw_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Paasingana ambari moja ya nzuruku mwingi, alawa akuka kuuzanya vyaári nawo piya, akuka kuuza ambari ire!” ");
INSERT INTO wmw_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Nfano mwengine tena, ufalume wa binguni ulandana na nyavu yakutaiwa mbahari yakukoresa inswi za kila namuna. ");
INSERT INTO wmw_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Pazijala inswi, wavuvi wavutira kungulu, wakwikala, watondola ngema, wakitaya ntenga, sazifãi wakefya. ");
INSERT INTO wmw_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Javyo ndi vyavisaka kuwa suku ya Kiyama: wakuja kulawirira malaika, wawatondola wanu wabaya nkati ya wanu wa shariya, ");
INSERT INTO wmw_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","wawefya motoni, mahala pawoka kurira na kutafuna meno.” ");
INSERT INTO wmw_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Basi, Insa akiwadairi wanafunzi wake: “Mwereriwa usowezi‑wu piya?” Wakijibu: “He, tereriwa.” ");
INSERT INTO wmw_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Iye akiwambira akamba: “Kwa javyo, kila mwanlimu wa shariya apinduka kuwa mwanafunzi nkati ya ufalume wa binguni, alandana na mwenyé nyumba wakulavya nkati ya mali zake vinu vipya na vya mida.” ");
INSERT INTO wmw_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Insa, pesire kuwambira kwa kinyume cire, akilawa akuka vyake. ");
INSERT INTO wmw_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Nakufika kwawo, akiwafunda nsinagoga mwawo, mpaka ewo wakishanga, wakisema: “Wijiwifu‑wu na eya maajuza‑ya vyankunlawirira ndepi? ");
INSERT INTO wmw_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Eyu si mwana wa karipinteru? Mamaye si etiwa Mariyamu? Na noyu si nduyawo Yakobu, Yusufu, Ansumani, na Yuda? ");
INSERT INTO wmw_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Walumbuze piya atíri nawo pamoja? Piya‑vi vyankunlawirira ndepi?” ");
INSERT INTO wmw_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Na wakibugudika naye. Fala Insa akiwambira: “Nabii ainshimiwa kila mahala, ila kwawo na mbere ya jamaa zake aainshimiwa.” ");
INSERT INTO wmw_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Basi, aatendire maajuza mengi kwawo konta awakimwamini. ");
INSERT INTO wmw_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Na noure wakati ure, nfalume Herodi akisikira swifa za Insa. ");
INSERT INTO wmw_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Akiwambira wakolakazi wake javi: “Eyo Yahaya mwenyé Koza ire. Iye kaziribuka ka wafwi, ndimana atendeka maajuza‑yo!” ");
INSERT INTO wmw_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Kamana Herodi ânkorire Yahaya, akinfunga, akintaya nkalaboshu kwa sababu ya Herodiza, muka wa nduye Filipi. ");
INSERT INTO wmw_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Konta Yahaya ákimwambiranga Herodi javi: “Siyo haki kuntenda kuwa nkawako!” ");
INSERT INTO wmw_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ingawa Herodi akisaka kumulaya, fala akiwopa wanu, konta wakintula Yahaya kuwa nabii. ");
INSERT INTO wmw_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Sambi ikifika suku ya sherehe yakutenda mwaka Herodi. Mwana mmoja wa Herodiza, mwari, kavina kati-kati ya jambo vikimwajibu sana Herodi. ");
INSERT INTO wmw_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Kwa javyo akilapira kumpa caalebela conse. ");
INSERT INTO wmw_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Mwari ire, kwa kushongezeriwa na mamaye, akilebela akamba: “Nipeni sambi‑pa nfinga kiswa ca Yahaya mwenyé Koza.” ");
INSERT INTO wmw_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Nfalume ire akikimiwa pakulu futi fala, kwa kuwa kâlapira mbere ya piya wetiwe ware, akamuru apewe. ");
INSERT INTO wmw_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Akintuma munu, akasinje kiswa ca Yahaya nkalaboshu. ");
INSERT INTO wmw_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Kweli kiswa cake cikijisiwa cikitaiwa nfinga, akipewa mwari ire, neye akitwala akimpa mamaye. ");
INSERT INTO wmw_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Mwinsho, wakija wanafunzi wa Yahaya, wakitwala kivirikiti cake, wakuka wakizika, ikisa wakuka wakimpatisa habari Insa. ");
INSERT INTO wmw_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Insa, paasikire habari zire, akilawa pare mungalawa akuka yeka yake mahala sapana wanu. Fala wanu wengi pawasikire, wakilawa mmakaya mwawo wakinfulata luwansi. ");
INSERT INTO wmw_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Iye nakwisuka, kawawona wanu wengi, akiwawonera utungu, akiwaponesa walwere wawo. ");
INSERT INTO wmw_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Paifikire jironi, wanafunzi wake wakinfika karibu wakimwambira: “Epa mahala‑pa panyamazikana na juwa riswa. Wambire wanu‑wa watawanyike woke mmamakaya, wakauze cakurya warye.” ");
INSERT INTO wmw_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Fala Insa akiwambira: “Ailazimu kuwa ewo‑po woke vyawo. Umwe‑po wapeni cakurya warye!” ");
INSERT INTO wmw_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ewo wakinjibu wakamba: “Atina kinu, ila tanawo mikate mitanu na inswi mbiri tu basi.” ");
INSERT INTO wmw_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Iye akiwambira: “Njoni nazo kuno.” ");
INSERT INTO wmw_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ikisa iye akamuru kuwa wanu piya wekare pansi mminyani, akitwala mikate mitanu na inswi mbiri zire, akinang'aniza binguni, akintukuza Mwenyezimungu, akimeya mikate ire vipande-vipande, akiwapa wanafunzi wake, newo wakiwatongera wanu ware piya. ");
INSERT INTO wmw_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Wanu piya wakitafuna mpaka wakikuta. Ikisa, wakikusanya mikate iremire ire, ikijala vikalala kumi na viwiri. ");
INSERT INTO wmw_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Jumula ya wanu piya watafune wakifika kadiri ya alufu ntanu, kwasa kuwawalanga wanawaka pamoja na wasimana, mama! ");
INSERT INTO wmw_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Mpunde noure, Insa akiwalazimisha wanafunzi wake waripakire mungalawa walongorere ng'ambu nyengine kuno akilayana nawo wanu ware. ");
INSERT INTO wmw_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Nakwisa kulayana nawo, akikwera yeka pamwango kulebela duwa. Pariswere juwa, akibaki yeka. ");
INSERT INTO wmw_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Fala ngalawa ilawire ire íkiwa baidi na kaya, íkirefya na maluwimbi konta ikibisha. ");
INSERT INTO wmw_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Paifikire alufajiri Insa akuka akifika mpaka paikenenda ngalawa pare, akenenda julu ya maji, wé! ");
INSERT INTO wmw_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Wanafunzi ware pawammonire ári julu ya maji, wakifazaika, wakamba: “Eyu nsoka!” Wakingira kurama na wofi. ");
INSERT INTO wmw_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Fala noure mpunde ure, Insa akiwambíra akamba: “Rimbisani myoyo yenu! Ndumi, musope kinu!” ");
INSERT INTO wmw_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Peduru akijibu, akamba: “Mwenye, ikiwa nduwe, namuru nenende julu ya maji nifike pauri‑po!” ");
INSERT INTO wmw_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Akinjibu: “Njo”. Nakwisuka mungalawa mure, Peduru akenenda julu ya maji, akuka paákiwa Insa pare. ");
INSERT INTO wmw_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Fala paawonire mepo kuwa nyingi, akopa, akanza kutita, kuno akifula lukuto, akamba: “Mwenye, nivushe!” ");
INSERT INTO wmw_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Kwa mpunde noure, Insa akolosa nkono, akinkola, akimwambira: “Uwe kwamini kwako aba, mbana kudanizira?” ");
INSERT INTO wmw_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Pawengire mungalawa mure, na mepo ire ikinyamala. ");
INSERT INTO wmw_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Piya wákiwa mungalawa mure wakintukuza wakamba: “Kweli-kwelini kuwa Mwana wa Mwenyezimungu!” ");
INSERT INTO wmw_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Wakiloka, wakuka ng'ambu nyengine, wakifika kaya ya Genezareti. ");
INSERT INTO wmw_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Sambi, wanu wa nkaya mure, pawammanyire Insa, wakitangaza habari kaya jirani. Ewo wakinjisira walwere piya. ");
INSERT INTO wmw_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Wakintafadali wakumbure nanga aba lupindo ra nguwo yake. Na kweli-kwelini wâkumbure ware, piya wapona. ");
INSERT INTO wmw_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Sambi, Mafarizeu na wanlimu wa shariya wakilawa Yerusalemu wakuka ka Insa, wakindairi: ");
INSERT INTO wmw_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Sababuni wanafunzi wako mbana wankutupa tabiya za wazee wa mida? Kamana wakirya awanawa.” ");
INSERT INTO wmw_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Fala Insa akiwajibu, akiwambira: “Mbana umwe novyo mutupa shariya za Mwenyezimungu kwa sababu ya tabiya zenu? ");
INSERT INTO wmw_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Konta Mwenyezimungu kasema javi: ‘Umwinshimu wawayo na mamayo.’ Na: ‘Munu wakunsowerera caputu wawaye au mamaye ajuzi aulaiwe.’ ");
INSERT INTO wmw_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Fala umwe mufunda javi: mwenyé kumwambira wawaye au mamaye kuwa canikijuzi kukupani, nilavya swadaka ka Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Basi ámba javyo aamwinshimu wawaye, kankufezeyi usemi wa Mwenyezimungu kwa sababu ya tabiya zenu. ");
INSERT INTO wmw_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Umwe manafiki! Nabii Izaya kâsema sana-sana tangu mida julu yenu, akamba: ");
INSERT INTO wmw_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Ewa wanu‑wa wanisifu pakanywa basi, fala myoyo yawo iwa baidi nami. ");
INSERT INTO wmw_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Newo wankunitukuza bure, wankufunda ngano zawalangana wanu.’ ” ");
INSERT INTO wmw_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ikisa Insa paawajumanise wanu, akiwambira javi: “Sikirizani, ereriwani! ");
INSERT INTO wmw_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Sico cingira pakanywa cintaya munu haramu, ila cilawa pakanywa ndi cintaya munu haramu.” ");
INSERT INTO wmw_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Basi, wanafunzi wake wakinfika karibu yake, wakimwambira: “Ukwijiwa kuwa Mafarizeu ware, pawasikire usowezi wako, wabugudika?” ");
INSERT INTO wmw_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Fala iye akiwajibu, akamba: “Kila muti savyarire Baba omi ári binguni udoboriwa. ");
INSERT INTO wmw_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Waseni! Ewo wanu sawawona wawalongoza wanu sawawona. Kipofu akinlongoza kipofu mwenziwe, wo‑wawiri wagwira mpondo gudu!” ");
INSERT INTO wmw_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Peduru akimwambira, akamba: “Ewo nfano‑wo tifafanurire mana ake.” ");
INSERT INTO wmw_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Iye akamba: “Umwe novyo amunamba kwereriwa? ");
INSERT INTO wmw_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Amwijiwa kuwa piya cingira pakanywa cikuka mmatumbo na cilawa cukwefyeriwa mpondo ncowero. ");
INSERT INTO wmw_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Fala vilawa pakanywa vilawa mmoyo. Evyo ndi vintenza munu kuwa haramu. ");
INSERT INTO wmw_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Konta mmoyo mulawa mawazo mabaya, kuulaya, uzinzi, ceje, wivi, ushahidi wa ulongo, na matukano. ");
INSERT INTO wmw_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Evi ndi vintenza munu kuwa haramu. Fala kurya bila kunawa mmakono, aakuntenza munu kuwa haramu.” ");
INSERT INTO wmw_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Insa nakurilavya pare, akuka makaya a Tiru na Sidoni. ");
INSERT INTO wmw_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Sambi, mwanamuka nKanaa wa nozire inti zire akikuwa, akamba: “Mwenye, njukulu wa Daudi, niwonere utungu! Mwanangu kakazika, kapatiwa na jini.” ");
INSERT INTO wmw_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Fala Insa aanjibire anta kinu. Wanafunzi wake wakinfika karibu, wakinlebela, wakamba javi: “Mwase oke vyake konta kankutinyangula nyuma kuno.” ");
INSERT INTO wmw_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Fala Insa akiwajibu, akamba: “Situmiwe ka wanu wengine ila ka waIziraeli tu basi, wenye kupoteya kamba makondoo.” ");
INSERT INTO wmw_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Fala mwanamuka ire, nakuja akintukuza, akamba: “Mwenye, nisaidiye!” ");
INSERT INTO wmw_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Iye akinjibu: “Sivyo vyema kutwala cakurya ca wana, kuwapa waumbwa wa pakaya.” ");
INSERT INTO wmw_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Fala iye akamba: “He, Mwenye, fala anta na umbwa zikuryanga vyakuwagwa watwa wawo pameza!” ");
INSERT INTO wmw_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Sambi Insa akinjibu, akimwambira: “Uwe mama, kwamini kwako kukulu! Tenderiwa kamba vyausaka.” Noure mpunde ure, mwanawe ire akipona. ");
INSERT INTO wmw_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Insa, nakulawa pare, akija kutanda ra Galileya, akikwera pamwango, akikala. ");
INSERT INTO wmw_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Wakinfika karibu yake wanu wengi, wakija nawo vitewe, wanu wakuremala, vipofu, mabubu, pamoja na wengine‑po tena wengi. Wakiwatula piya ware mbere yake, neye akiwaponesa. ");
INSERT INTO wmw_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Wanu ware washanga, konta wakiwona mabubu wakisowera, wanu wakuremala wakomu, vitewe wakenenda, pamoja na vipofu wakiwona. Wakinsifu sana Mwenyezimungu wa Iziraeli. ");
INSERT INTO wmw_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Sambi, Insa paawajumanise wanafunzi wake, akiwambira akamba: “Ewa wanu‑wa niwawonera utungu, konta wawa nomi muda wa suku natu, na awana cakurya. Sisaka kuwalaya kuwasa na njala, wasije kuzirika munjira.” ");
INSERT INTO wmw_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Wanafunzi ware wakindairi javi: “Cakurya palanga‑pa cakuwatosha wanu wengi kamba‑wa, tipata ndepi?” ");
INSERT INTO wmw_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Insa akiwambira: “Muwa nawo mikate myengapi‑po?” Ewo wakijibu: “Saba, na inswi aba.” ");
INSERT INTO wmw_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Basi Insa akiwamuru wanu ware wekare pansi. ");
INSERT INTO wmw_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Insa akitwala mikate saba ire na inswi zire, akishukuru, akimeya, akiwapa wanafunzi ware, newo wakiwatongera wanu ware. ");
INSERT INTO wmw_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Wakirya piya, wakikuta. Wakilokota vipande vya mikate vibakire, vikijala vikapu saba. ");
INSERT INTO wmw_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Wanu wârire wákiwa wanawalume alufu nne, bila kuwawalanga wanawaka pamoja na wasimana, we! ");
INSERT INTO wmw_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Basi, Insa akilayana na wanu ware, akingira mungalawa, akuka upande wa Magadani. ");
INSERT INTO wmw_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Mafarizeu na Masaduseu wakinfika karibu yake Insa, na kwa kumyerera, wakinlebela awatendere alama ya binguni awolotere. ");
INSERT INTO wmw_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Fala iye, nakuwajibu, akamba: “Ikifíka jironi mukwamba: ‘Makeshamungu kukuwa kwema, konta kunja kutenda undu.’ ");
INSERT INTO wmw_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Na subuu namapema mukwamba: ‘Rero kunja kúnyata, konta kuwa mawingu.’ Vyakuwa julu, mukwereriwa cisaka kukuna, fala alama zakolota ewo wakati maalumu‑wo amukidiri kwereriwa. Sababuni? ");
INSERT INTO wmw_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kizazi kibaya na cazinaa cisakula alama, fala acipewa alama ila alama ya nabii Inusu.” Iye akiwasa, akuka vyake. ");
INSERT INTO wmw_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Wanafunzi ware pawafikire ng'ambu nyengine, wariwala kusukula mikate. ");
INSERT INTO wmw_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Insa akiwambira javi: “Tunzani, rikengereni na furumento ya Mafarizeu na Masaduseu!” ");
INSERT INTO wmw_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ewo wakanza kuduguda watupu: “Konta atirisukuze mikate.” ");
INSERT INTO wmw_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Insa paawafahamire, akiwambira: “Mbana muduguda watupu, umwe wanu samwamini? Konta amuna mikate? ");
INSERT INTO wmw_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Mwaja amunamba kufahamu wala amukumbukira mikate mitanu ka ware wanu alufu ntanu ware? Mulokota mikate vikapu vyengapi? ");
INSERT INTO wmw_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Wala ire mikate saba ka ware wanu alufu nne ware? Mulokota mikate vikapu vyengapi? ");
INSERT INTO wmw_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Amwereriwa namunani kuwa sikamba mikate? Rikengereni furumento ya Mafarizeu na Masaduseu.” ");
INSERT INTO wmw_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Basi ndi pawafahamire kuwa aari kwamba rikengereni na furumento ya mikate, ila kankwamba rikengereni na ngano za Mafarizeu na Masaduseu. ");
INSERT INTO wmw_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Insa paafikire upande wa kaya ya Kaisariya-Filipi, kawadairi wanafunzi wake javi: “Wanu wawamwita Binadamu wa Binguni ndi wepi?” ");
INSERT INTO wmw_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ewo wakijibu: “Wengine Yahaya mwenyé Koza, wengine Aliyasi, na wengine Yeremiya au nabii mmojawapo.” ");
INSERT INTO wmw_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Iye akiwambira: “Umwe‑po mukwamba omi niwa nani?” ");
INSERT INTO wmw_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ansumani Peduru akijibu akamba: “Uwe kuwa Almasihi, Mwana wa Nlungu hai.” ");
INSERT INTO wmw_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Insa akinjibu akamba: “Heri uwe, Ansumani mwana wa Inusu, kamana siyo mwanadamu akufafanurire kusema javi, ila Baba wangu ári binguni. ");
INSERT INTO wmw_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Omi novyo nukwambira kuwa uwe kuwa Peduru, na pajulu ya ewu mwala‑wu nijenga jamati yangu, na miryango ya Kuzimu aikidiri kushinda eyo jamati‑yo. ");
INSERT INTO wmw_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nomi nukupa mifungulo ya ufalume wa binguni. Kwa javyo, kila caulunganisa conse mulumwengu‑mu, cilunganisiwa novyo binguni. Kila cawasanisa conse mulumwengu‑mu, cukwasanisiwa novyo binguni.” ");
INSERT INTO wmw_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Basi, akiwambira wanafunzi wake wasimwambire anta munu kuwa iye ndi Almasihi. ");
INSERT INTO wmw_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Mwanzo wa noure wakati ure, Insa akanza kuwereza wanafunzi wake kuwa inlazimu kuka mpaka Yerusalemu, akapate kutabishiwa pakulu na wazee, wakulungwa wa dini, pamoja na wanlimu wa shariya, ikisa aulaiwe, na suku ya tatu afufuriwe. ");
INSERT INTO wmw_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Noparepare Peduru akimwitira kunyenje, akanza kunkaidi akamba: “Anta, Mwenye! Vinu-vyo avikukuna futi!” ");
INSERT INTO wmw_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Fala iye akizungunuka, akimwambira Peduru: “Uka nyuma yangu‑ko, Ibilisi! Kwangu omi, uwe kuwa kisiki cakukwakuriwa, konta auwaza víri ka Mwenyezimungu, ila ka wanadamu.” ");
INSERT INTO wmw_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Noparepare Insa akiwambira wanafunzi wake: “Asáka kunifulata omi onse, akaidi moyo wake, aritike nsalaba wake, anifulate. ");
INSERT INTO wmw_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kamana mwenyé kusaka kukengera mainsha ake, apoteza, fala mwenyé kupoteza mainsha ake kwa sababu yangu omi, asingana. ");
INSERT INTO wmw_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Mwaja, munu apata faidani kupata ulumwengu‑wu piya, iri filihali kapoteza roho yake? Munu apereka kinani kukakanya na roho yake? ");
INSERT INTO wmw_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Kamana Binadamu wa Binguni akuja kati ya utukufu wa Baba wake pamoja na malaika wake. Epo ndi paaja kunripa kila munu kwa vitendo vyake. ");
INSERT INTO wmw_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nukwambirani kweli kuwa muripo-pa-mwe, wamojawapo awafwa sawammonire Binadamu akija na ufalume wake.” ");
INSERT INTO wmw_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Bandi ya suku sita, Insa akintwala Peduru pamoja na Yakobu na Yahaya, munu na nduye, akikwera nawo pamwango nrefu yeka yawo. ");
INSERT INTO wmw_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Iye akitaduka mbere yawo, uso wake ukinuru kamba juwa, na nguwo zake zilangala vú kamba nuru! ");
INSERT INTO wmw_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Na mpunde noure, wakilawirira Musa na Aliyasi wakipakanira naye. ");
INSERT INTO wmw_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Akilawa Peduru akimwambira Insa akamba: “Mwenye, vyema futi ofwe kwikala mahala‑pa! Mukisaka, nijenga nopa vibanda vitatu: kimoja cenu, cengine ca Musa, na cengine ca Aliyasi.” ");
INSERT INTO wmw_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Kuno akisowera, wingu relupa vú rikiwafinika na nkati ya wingu rire, isikirikana shauti ikamba: “Eyu ndi Mwanangu wanimpenda pakulu, waniri radi naye. Nsikirizeni!” ");
INSERT INTO wmw_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Wanafunzi ware, pawasikire shauti ire, wagwa warifinika kumaso, wakopa pakulu. ");
INSERT INTO wmw_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Fala Insa akiwafika karibu yawo, akiwakumbula, akiwambira: “Lamukani! Musope kinu!” ");
INSERT INTO wmw_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Pawenure uso, awammonire munu, ila Insa tu basi. ");
INSERT INTO wmw_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Pawesuke pamwango pare, Insa akiwalaizira, akamba: “Musimwambire munu amuwonire are, mpaka Binadamu wa Binguni afufuriwe ka wafwi.” ");
INSERT INTO wmw_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Wanafunzi ware wakindairi Insa, wakamba: “Mbana wanlimu wa shariya wankwereza kuwa ajuzi kwanza aje Aliyasi?” ");
INSERT INTO wmw_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Insa akiwajibu, akamba: “Kweli Aliyasi akwanza kuja, neye atengeza piya, ");
INSERT INTO wmw_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","fala nukwambirani kuwa Aliyasi kâja futi, ila Mayahudi awammanyire, wantenda vyawasakire vyonse. Ndi novyo Binadamu wa Binguni vyaaja kutabika mmakono mwawo.” ");
INSERT INTO wmw_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Noparepare wanafunzi ware watula kuwa kankumwamba Yahaya mwenyé Koza. ");
INSERT INTO wmw_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Pawafikire karibu ya wanu wengi, noparepare akija munu mmoja ka Insa, akikokora mbere yake, ");
INSERT INTO wmw_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","akamba: “Mwenye, mmonere utungu mwanangu! Iye nlwere kisalasala, kankutabika pakulu futi. Kamana mara nyingi kagwirira pamoto na mmaji mara nyingi zawenye. ");
INSERT INTO wmw_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nimpereka ka wanafunzi wako, fala awakidirire kumponesa.” ");
INSERT INTO wmw_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Insa akijibu, akamba: “Ló, kizazi kibaya sacikubali! Niinshi namwe mpaka rini? Na mpaka rini nukukuvumirirani? Njoni naye nnemba‑yo.” ");
INSERT INTO wmw_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Insa akinsutumu jini ire, akintuwisa. Kwa noure wakati ure, nnemba ire akipona. ");
INSERT INTO wmw_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Nakisa wanafunzi ware wakuka karibu ya Insa, wakindairi kiriziu: “Mbena ofwe‑pa atikidirire kuntuwisa?” ");
INSERT INTO wmw_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Iye akiwajibu: “Konta kwamini kwenu aba. Nukwambirani kweli kuwa mukiwa nawo kwamini kamba mbeyu ya amostarda mukidiri kusowerera mwango‑wu: ‘Lawa epa, ukekare pengine!’, newo nanga ulawa. Acipo camukitowa kukidiri!” ");
INSERT INTO wmw_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Pawekare pamoja Galileya, Insa kawambira wanafunzi wake javi: “Binadamu wa Binguni aperekiwa mmakono mwa wanadamu, ");
INSERT INTO wmw_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ewo wamulaya, fala suku ya tatu afufuriwa.” Ewo wakiuzunika pakulu futi. ");
INSERT INTO wmw_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Pawafikire Kafarnaumu, wanu wákiripisanga nsoko wa jarajara mbiri, wakimukira Peduru, wakindairi javi: “Nsoko wa jarajara mbiri, mwanlimu wenu aripanga?” ");
INSERT INTO wmw_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Iye akamba: “Aye, aripanga.” Basi Peduru pengire nnyumba mure, Insa kawa ntanzi kusowera, akindairi javi: “Ansumani! Kwankuwona mwaja? Mafalume wa muinti‑mu wapokerera nsoko au ushuru ka wanuni? Ka wana wawo au ka wanu wengine?” ");
INSERT INTO wmw_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Akilawa Peduru akijibu: “Ka wanu wengine.” Sambi Insa akisema javi: “Basi, wana wawa nawo uhuru, awaripa. ");
INSERT INTO wmw_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Fala kwa kuwa tisiwakwakurise, uka mwani, ukefye pavu, untware inswi wakwanza kunlowa. Nakunfungula kanywa, usingana jarajara. Utware, uke, ukaripe nsoko wangu na wako.” ");
INSERT INTO wmw_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Noure wakati ure, wanafunzi wanfika karibu Insa, wakamba: “Muufalume wa binguni, munu bora pakulu nani?” ");
INSERT INTO wmw_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Iye akimwita kisimana mmoja, akimwimisa kati-kati yawo, ");
INSERT INTO wmw_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","akamba: “Nukwambirani kweli, ikiwa amuripindure mukiwa kamba wasimana, visaka kuwa vyonse amwingira muufalume wa binguni. ");
INSERT INTO wmw_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Kamana, mwenyé kurinyenyekeya mwanyewe kamba eyu kisimana‑yu, iye ndi bora pakulu muufalume wa binguni. ");
INSERT INTO wmw_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ampokérera kisimana mmoja kamba eyu, kwa zina rangu, anipokerera omi. ");
INSERT INTO wmw_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Fala ankósesa kisimana mmojawapo wakunitumaini omi‑wa, ndi fadari kwake afungiriwe nsingo riwe rikulu rakupalaza, atosiwe kati-kati ya bahari. ");
INSERT INTO wmw_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Walaniwe wanu wa mulumwengu kwa sababu ya kukosa. Kamana sibudi siti kuwepo kukosa. Falakini alaniwe mwenyé kukosesa! ");
INSERT INTO wmw_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Basi sambi, ikiwa nkono wako au mulu wako ndi úri kukukoresa dambi, tupula nowo, wefye kunundu! Fadari kwako uwe wingire mumainsha a milele sauna nkono au mulu, koliko kwefyeriwa pamoto wa milele na makono mawiri au maulu mawiri. ");
INSERT INTO wmw_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Na riso rako rukukukoresa dambi, kotopola noro, wefye kunundu! Fadari kwako, wingire mumainsha a milele na riso rimoja basi, zaida kwefyeriwa pamoto wa Jahanamu na maso mawiri.” ");
INSERT INTO wmw_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Onani! Ewa wasimana‑wa musinkejeli anta mmoja! Konta nukwambirani kweli kuwa malaika wawo wári binguni daima wankuwona uso wa Baba wangu ári binguni. ");
INSERT INTO wmw_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Umwe muwonaja? Ikiwa munu kanawo makondoo miya, akasika kondoo mmoja, atendaja? Aawasa tuswini na kenda mmyango nomo, kupita akinsakula mmoja asike ire? ");
INSERT INTO wmw_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Na akimmonerera, nukwambirani, antendera radi pakulu koliko tuswini na kenda sawasike ware. ");
INSERT INTO wmw_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Kwa javyo, Baba wenu ári binguni vimwajibu kuwa kisimana anta mmoja asipoteye.” ");
INSERT INTO wmw_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Ikiwa nduyo kakukosa, uka ukamolotere kosa rake, muri wawiri zenu tu basi. Akukusikira, kumpata nduyo. ");
INSERT INTO wmw_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Fala akitowa kukusikira, ntware tena munu mmoja au wawiri, ipate kanywa zawo za ushahidi wa wawiri au watatu mwaha‑wo wakikishiwe. ");
INSERT INTO wmw_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Fala akikatala kuwasikiriza, kaseme kujamati. Na akitowa kusikiriza novyo jamati, nture kamba munu kafiri au munu wakuripisa nsoko. ");
INSERT INTO wmw_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Nukwambirani kweli kuwa kila camulungánisa conse mulumwengu‑mu, cilunganisiwa novyo binguni. Na kila camwasánisa conse mulumwengu‑mu, cikwasanisiwa novyo binguni. ");
INSERT INTO wmw_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Tena nukwambirani kweli kuwa, wawiri kati yenu, mukikubaliyana kunlebela Mwenyezimungu shauri mojawapo mulumwengu‑mu, cikuna noco, julu ya Baba wangu ári binguni. ");
INSERT INTO wmw_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Konta pawakusanyika wawiri au watatu kwa zina rangu omi, niwapo kati yawo.” ");
INSERT INTO wmw_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Sambi, Peduru akinfika karibu, akindairi: “Mwenye, akinikosera mwenzangu inilazimu ninswamii mpaka mara nyengapi? Mpaka mara saba?” ");
INSERT INTO wmw_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Insa akinjibu: “Sisema mpaka mara saba, ila nisema mpaka sabini mara saba! ");
INSERT INTO wmw_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ndimana ufalume wa binguni ulandana na nfalume mmoja asakire kuwalangirana nawo mali watumisi wake. ");
INSERT INTO wmw_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Paanzire kuwalangirana nawo, wakinjisira cadeni mmoja akiwiriwa talanta alufu kumi. ");
INSERT INTO wmw_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Kwa kuwa aawere nawo cakuripa, nfalume ire akilamula ntumisi ire ozanyiwe, pamoja na nkawake, wanawe, na vinu vyake piya, iripiwe deni ire. ");
INSERT INTO wmw_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ntumisi ire, nakugwa akikokora mbere yake, akamba: ‘Iwa na imani nami, nukuripa piya deni.’ ");
INSERT INTO wmw_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Nfalume ire, kwa kummonera utungu ntumisi ire, akimwasa, akinswamii deni yake. ");
INSERT INTO wmw_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Na paalawire pare, noire ntumisi ire kansingana ntumisi mwenziwe wammwira kontu amusini. Noparepare akinkola, akinpota, akimwambira: ‘Niripe nzuruku wangu!’ ");
INSERT INTO wmw_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Basi ntumisi mwenziwe ire, nakugwa akinlebela akamba: ‘Iwa na imani nami, nukuripa.’ ");
INSERT INTO wmw_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Fala iye aasakire anta kinu, akilawa, akintayisa nkalaboshu mpaka aripe deni yake ire. ");
INSERT INTO wmw_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Basi watumisi wenziwe ware pawawonire mambo akunire are, wakisikitika pakulu futi, wakuka wakimwambíra mwenye wawo piya akunire are. ");
INSERT INTO wmw_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Noparepare, mwenye wawo ire nakumwita ntumisi ire, akimwambira javi: ‘Uwe kuwa ntumisi mbaya! Deni yako piya nukuswamii konta kunilebela. ");
INSERT INTO wmw_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Aukijuzi uwe novyo kummonera utungu mwenziwo kamba vyanukuwonere omi?’ ");
INSERT INTO wmw_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Basi mwenye wawo ire akimiwe pakulu, akimpereka ka wenye kuhukumu, mpaka aripe deni yake ire piya. ");
INSERT INTO wmw_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Basi ndi kamba Baba wangu ari binguni vyaasaka kukutendani, ikiwa amuwaswamiire wenzenu ka moyo radi.” ");
INSERT INTO wmw_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Insa pesire usowezi ure, kalawa Galileya koka makaya a Yudeya, kuloka Yordani. ");
INSERT INTO wmw_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Wanu wengi wawenye wakinfulata, na noko iye akiwaponesa walwere. ");
INSERT INTO wmw_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Iwa Mafarizeu wakimukira kwa kumyerera, wakindairi: “Mwaja! Halali nlume kuntaliki nkawake kwa sababu mmojawapo?” ");
INSERT INTO wmw_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Iye kajibu kaamba: “Aya ísema kuwa tangu mwanzo, Mwenyezimungu pamumbire nlume na muka, eyo aya‑yo amufyomire? ");
INSERT INTO wmw_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Novyo akamba kuwa nlume ájuzi kumwasa wawaye na mamaye, alungana na nkawake, wó‑wawiri wakuwa mwiri mmoja. Sinovyo? ");
INSERT INTO wmw_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Kwa javyo, awawa wawiri tena, ila ukuwa mwiri mmoja. Basi, calungánise Mwenyezimungu conse, mwanadamu asasanise.” ");
INSERT INTO wmw_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ewo wakindairi tena: “Sambi, mbena nabii Musa kamuru kuntaliki muka na kumwasa?” ");
INSERT INTO wmw_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Insa akiwajibu: “Nabii Musa kakuhurusuni kuwasa waka wenu kwa sababu ya myoyo yenu kuwa migumu. Fala tangu mwanzo aiwere javyo. ");
INSERT INTO wmw_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nukwambirani kweli kuwa kila mwenyé kumwasa nkawake, saíri kwa sababu ya uzinzi, kuka kunlomba muka mwengine, kankuzinga.” ");
INSERT INTO wmw_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Wanafunzi wake ware wakamba javi: “Ikiwa ndi javyo nlume na nkawake, aipo faida yakulomba.” ");
INSERT INTO wmw_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Iye akiwambira: “Wala sipiya wakubali usowezi‑wu, ila wenye kujanliiwa na Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Kamana wawapo macande kwa kipongorero cawo, wawapo macande wengine watendiwe javyo na wanu, na wawapo macande wengine wakuritenda wanyewe kwa sababu ya ufalume wa binguni. Mwenyé kukubali kinu‑ci, akubali!” ");
INSERT INTO wmw_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ikisa, wakijisiwa wasimana ka Insa, awature makono, awalebelele duwa. Wanafunzi wake wakiwenyukira, ");
INSERT INTO wmw_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","fala Insa akamba: “Waseni wasimana‑wo waje kuno, musiwakataze, konta wári kamba ewo ufalume wa binguni ndi wawo.” ");
INSERT INTO wmw_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Nakwisa kuwatula makono, akilawa mahala pare. ");
INSERT INTO wmw_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Sambi, munu mmoja akimukira Insa, akindairi: “Mwanlimu! Cema ndi cepi canijuzi kutenda nipate mainsha a milele?” ");
INSERT INTO wmw_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Iye akimwambira: “Mbena unidairi kuhusu cema caujuzi kutenda? Mwema mmoja tu basi. Uwe ukisakula kuwa na mainsha a milele, fulata ámuri.” ");
INSERT INTO wmw_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Iye akindairi: “Ámurini?” Insa akisema: “Usiulaye, usizinge, usiwe, usiseme ushahidi wa ulongo, ");
INSERT INTO wmw_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","mwinshimu wawayo na mamayo, na mpende mwenziwo kamba vyauripenda uwe mwanyewe.” ");
INSERT INTO wmw_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Nnemba ire akamba: “Ezo ámuri‑zo piya ndi zanifulata. Kinani tena cibakire?” ");
INSERT INTO wmw_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Insa akimwambira: “Ukisakula uwe kamilifu, uka ukozanye vinu vyako, nzuruku uwape masikini. Javyo uriturira ankiba binguni. Nakisa uje unifulate.” ");
INSERT INTO wmw_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Fala nnemba ire paasikire ewu usowezi‑wu, kalawa na uzuni konta ákiwa na mali mengi. ");
INSERT INTO wmw_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Insa kawambira wanafunzi wake: “Nukwambirani kweli-kwelini kuwa tajiri virigariga kwingira muufalume wa binguni! ");
INSERT INTO wmw_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nukwambirani tena: Ngamiya raisi kupita kipenyo ca singano, koliko tajiri kwingira muufalume wa Mwenyezimungu.” ");
INSERT INTO wmw_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Nakusikira wanafunzi ware, washanga pakulu futi, wakindairi: “Avi, asáka kuvuka nani?” ");
INSERT INTO wmw_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Insa akiwanang'aniza, akiwambira: “Ka wanadamu, kinu‑co acikidirika, fala ka Mwenyezimungu, piya vinu vikidirika.” ");
INSERT INTO wmw_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Nakuwajibu, Peduru kawambira javi: “Ofwe tasa piya, tukufulata uwe. Faida yetu ofwe ndi yepi?” ");
INSERT INTO wmw_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Insa akiwambira: “Nukwambirani kweli umwe munifúlata-mwe, ulumwengu mupya‑wu, Binadamu wa Binguni paasaka kwikala kiti ca utukufu wake, nomwe novyo mukuja kwikala viti vikulu kumi na viwiri, kumiliki marikolo kumi na mawiri a Iziraeli. ");
INSERT INTO wmw_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Mwenyé kwasa nyumba, wanduze, walumbuze, wawaye, mamaye, wanawe, au masamba, kwa sababu yangu omi, apata faida mara miya, na ariti mainsha a milele. ");
INSERT INTO wmw_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Fala wengi wanzire wakuja kuwa mwinsho, na wári mwinsho wakuja kuwa watanzi.” ");
INSERT INTO wmw_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Sambi, ufalume wa binguni ulandana na mwenyé masamba, alawire subuu namapema kusikizana na wanu wakakore kazi mmasamba mwake. ");
INSERT INTO wmw_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Basi, nakusikizana nawo jarajara moja ya parata kutwa, akiwapereka kumasamba kwake. ");
INSERT INTO wmw_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Nakulawa tena ora ya subuu, kawawona wanu wengine wemira pabazari, sawatenda kinu, ");
INSERT INTO wmw_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","akiwambira javi: ‘Ukani nomwe novyo mmasamba, nukupani haki yenu.’ Newo wakúka. ");
INSERT INTO wmw_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Akilawa tena nsana na ruremba, akitenda novire. ");
INSERT INTO wmw_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ikisa tena jironi paalawire, kawasingana wanu wengine wemira, akiwadairi: ‘Mwimira epa kutwa nzima samutenda kazi, sababuni?’ ");
INSERT INTO wmw_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ewo wakijibu: ‘Hapana munu asikizane nofwe.’ Iye akiwambira: ‘Ukani nomwe novyo mmasamba.’ ");
INSERT INTO wmw_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Pariswere juwa, mwenyé masamba ire kamwambira kapatashi wake javi: ‘Wete wakolakazi piya, uwaripe nshahara wawo, uwanze wajíre mwinsho mpaka wanzire kuja.’ ");
INSERT INTO wmw_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Basi kweli, pawafikire wajíre jironi, kila munu kapokera jarajara moja ya parata. ");
INSERT INTO wmw_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Pawafikire wanzire kuja ware, wakidanizira kuwa wapokera nzuruku mwingi, fala kila mmoja kapokera novyo jarajara moja ya parata! ");
INSERT INTO wmw_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Pawapokere, wanduguda mwenyé masamba ire, ");
INSERT INTO wmw_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","wamba: ‘Wajire mwinsho‑wa wakola kazi ora moja basi, fala kawatula kuwa sawa‑sawa nofwe, tikorire kazi kutwa nzima, tíkivumirira juwa!’ ");
INSERT INTO wmw_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Fala iye, nakunjibu munu mmoja, kamwambira: ‘Ona rafiki yangu, siri kukupoka shariya. Atisikizane jarajara mmoja ya parata? ");
INSERT INTO wmw_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Twala cako, uke vyako. Nisaka nimpe mwenziwo wa mwinsho‑yu kamba vyanukupere uwe. ");
INSERT INTO wmw_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Mwaja! Omi sina haki yakutenda canisaka na nzuruku wangu? Riso rako ribaya konta ya umunu-mwema wangu?’ ");
INSERT INTO wmw_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Kwa javyo wanu wa mwinsho wakuwa watanzi, na watanzi wakuwa wa mwinsho.” ");
INSERT INTO wmw_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Insa paakikwera kuka Yerusalemu, kaweta cembe wanafunzi wake munjira akiwambira javi: ");
INSERT INTO wmw_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Sikirizani! Epa tankukwera Yerusalemu. Eko, Binadamu wa Binguni akuka kugabiziwa wakulungwa wa dini na wanlimu wa shariya, newo wanhukumu olaiwe. ");
INSERT INTO wmw_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Wampereka ka Sawari-Mayahudi, wanshupe, ebiwe viboko, na agomezeriwe pansalaba. Na suku ya tatu afufuriwa.” ");
INSERT INTO wmw_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Sambi, muka wa Zebedeyu na wanawe akuka mpaka karibu ya Insa, akikokora mbere yake akinlebela kinu. ");
INSERT INTO wmw_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Insa akindairi: “Usakani?” Iye akinjibu: “Ona, amuru wanangu wawiri‑wa wekare muufalume wako, mmoja akwikare nkono nriro wako na mwengine nkono sonto.” ");
INSERT INTO wmw_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Insa akinjibu, akamba: “Anta camulebela, amwijiwa. Mukidiri kunywa kaneka yangu canisaka kunywa omi?” Ewo wakinjibu: “Tikidiri.” ");
INSERT INTO wmw_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Insa akiwambira: “Ndi kweli mukunywa kaneka yangu. Fala kunikala nkono nriro au nkono sonto, sina ídini. Ila wenye kwikala watengezériwa na Baba wangu.” ");
INSERT INTO wmw_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Wanafunzi kumi wengine ware, pawasikire javire, wakiwakimwira ware wawiri munu na nduye. ");
INSERT INTO wmw_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Fala Insa akiweta, akiwambira: “Mukwijiwa kuwa mafalume wa mataifa wawatawala wanu, na wakulungwa wawa nawo mamulaka julu yawo. ");
INSERT INTO wmw_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Falakini kwenu umwe sivyaviri. Ila, kati yenu, asakúla kuwa nkulu onse, awe ntumisi wenu, ");
INSERT INTO wmw_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","na kati yenu asakúla kuwa ntanzi onse, awe ntwana wenu. ");
INSERT INTO wmw_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ndi kamba Binadamu wa Binguni aajire kutumikiriwa, ila atumike na apereke mainsha ake awavushe wanu wengi.” ");
INSERT INTO wmw_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Insa na wanafunzi wake, pawalawire Yeriko, wanu wengi wakinfulata. ");
INSERT INTO wmw_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Sambi, wekala nanyenje ya njira vipofu wawiri. Pawasikire kuwa Insa kankupita, wafula uto, wakamba: “Mwenye mwana wa Daudi, tiwonere utungu!” ");
INSERT INTO wmw_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Wanu ware wakiwenyukira wanyamare. Fala ewo wakizidi kufula uto: “Mwenye, Mwana wa Daudi! Tiwonere utungu!” ");
INSERT INTO wmw_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Pawemire, Insa akiweta akiwadairi: “Musaka nukutendeni mwaja?” ");
INSERT INTO wmw_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ewo wakijibu: “Mwenye, tisaka tiwone! Tiponese maso etu!” ");
INSERT INTO wmw_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Insa, kwa kuwawonera utungu, akiwakumbula maso awo. Kwa mpunde noure, ewo wakiludira kuwona, wakinfulata Insa. ");
INSERT INTO wmw_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Insa na wanafunzi wake wári karibu ya Yerusalemu, wakifika Betifage pamwango wa Mizaituni. Insa akiwatuma wanafunzi wawiri, akiwambira: ");
INSERT INTO wmw_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Ukani kaya íri mbere yenu ire. Nakufika, múnsingana buru mmoja kafungiriwa pamoja na mwanawe. Munfungure, muje naye. ");
INSERT INTO wmw_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Akilawírira wakukwambirani kinu, mwambireni kuwa: ‘Buru‑yu ansakula Mwenye’, basi iye akwasani mukuja nawo.” ");
INSERT INTO wmw_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Evi vikuna novire ipate utimiziwe usowezi waâsemire nabii mmoja akamba: ");
INSERT INTO wmw_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Mwambireni mwari wa Ziyoni: ‘Mmone nfalume wako kankuja kwako, kankuja na imani, ampandire buru, kankuperekiwa na kaburu katoto, mwana wa nyama mpingi!’ ” ");
INSERT INTO wmw_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Basi wanafunzi ware woka, watenda sawa‑sawa kamba Insa vyawatumire. ");
INSERT INTO wmw_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Waja naye buru ire pamoja na kaburu katoto kare, wakitandika nguwo zawo. Insa akikala julu yake. ");
INSERT INTO wmw_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Junudi ya wanu wengi wakitandika nguwo zawo munjira. Wanu wengine wakisinja makuti a mitende, wakitandika munjira. ");
INSERT INTO wmw_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Na makundi a wanu wákiwa mbere na wákiwa nyuma, wakipaza nyimbo, wakamba: “Hozana Mwana wa Daudi! Bora ári kuja kwa zina ra Mola! Hozana julu mbinguni!” ");
INSERT INTO wmw_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Insa, pengire Yerusalemu, wanu piya kaya ire wakifazaika, wakamba: “Eyu munu‑yu nani?” ");
INSERT INTO wmw_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Wanu ware wakisema: “Eyu ndi nabii Insa, wa Nazareti inti ya Galileya!” ");
INSERT INTO wmw_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Sambi, Insa akingira nNyumba Takatifu, akiwatuwisa piya wakiuzanya na wakiuza vinu nNyumba Takatifu. Akipidulanga meza za wacuruzi, pamoja na viti vya wakiuzanya mapomba. ");
INSERT INTO wmw_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ikisa akiwambira: “Yândikiwa javi: ‘Nyumba yangu ikuja kwitiwa nyumba ya duwa.’ Fala umwe mutenda jonga ra wevi.” ");
INSERT INTO wmw_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Nnyumba Takatifu nomo, wanjisira vipofu na wakuremala, iye akiwaponesa. ");
INSERT INTO wmw_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Kweli, wakulungwa wa dini na wanlimu wa shariya wawona matajabisa atendíre, na wawawona wasimana nNyumba Takatifu wakipaza nyimbo, wakamba: “Hozana Mwana wa Daudi!” Kwa javyo, ewo wakikimiwa, ");
INSERT INTO wmw_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","wakimwambira: “Kwankuwasikira ewa cawamba?” Insa akiwajibu: “Aye, aya isema javi: ‘Kanywa za wasimana watoto na wakujiji, zilavya kutukuza kwema.’ Amunafyoma?” ");
INSERT INTO wmw_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Nakuwasa, akilawira panja, akuka Betaniya, akilala noko. ");
INSERT INTO wmw_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Subuu namapema, Insa paakiludi akuka kaya ulu, ínkola njala. ");
INSERT INTO wmw_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Akiwona nfigu munjira, akúka mpaka nopo, fala aasingane kinu ila masamba tu basi. Akisowerera: “Cisipe tena kisumo milele!” Kwa noure mpunde ure, nfigu ure ukumiliya. ");
INSERT INTO wmw_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Nakuwona wanafunzi washanga, wakamba: “Namunani kwa mpunde nowu vyaumiliye nfigu‑wu?” ");
INSERT INTO wmw_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Nakujibu Insa akiwambira: “Nukwambirani kweli, mukitumaini bila dana, amutenda vyanitendire nfigu‑wu basi, anta na mukisowerera ewu mwango‑wu mukamba: ‘Somoka ukaritose mbahari’, vikuna novyo. ");
INSERT INTO wmw_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Na piya camulebela conse kwa duwa, mukamini, múpata.” ");
INSERT INTO wmw_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Insa pengire nNyumba Takatifu, wakulungwa wa dini pamoja na wazee wa Mayahudi wakinfika karibu kuno akifunda, wakindairi: “Evi vinu‑vi akutendesa mamulakani? Nani akupere eya mamulaka‑ya?” ");
INSERT INTO wmw_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Insa akijibu, akiwambira: “Nomi novyo nukudairini kinu kimoja. Neco mukinijibu, nomi novyo nukwambirani mwenyé mamulaka anitendesa evi vinu‑vi. ");
INSERT INTO wmw_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Koziwa ka Yahaya kukiwa ka mamulaka a nani? A binguni au a wanadamu?” Ewo wakikaidiyana watupu, wakamba: “Epa, tikamba: ‘A binguni’, atambira: ‘Sambi mbena amunkubali?’ ");
INSERT INTO wmw_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Na tikamba: ‘A wanadamu’, tiwopa wanu konta piya wankubali Yahaya ndi nabii wawo.” ");
INSERT INTO wmw_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Basi wakinjibu Insa, wakimwambira: “Atijiwa!” Na iye novyo akiwambira: “Basi, anta omi sukwambirani mamulaka a nani anitendesa evi vinu‑vi!” ");
INSERT INTO wmw_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Umwe muwonaja? Mwananlume mmoja ákiwa na wana wawiri. Akinfika wakwanza, akimwambira: ‘Mwanangu, uka rero ukakore kazi masamba.’ ");
INSERT INTO wmw_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Iye nakujibu, kaamba: ‘Sisaka!’ ikisa akitubiya akuka. ");
INSERT INTO wmw_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Akinfika wapiri, amwambira novire, fala iye nakujibu kaamba: ‘Nukuka Baba!’ fala okire. ");
INSERT INTO wmw_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Kati ya wawiri ware, atendire vyakumwajibu wawa yawo ndi wepi?” Ewo wamba: “Mwana wakwanza.” Insa akiwambira javi: “Nukwambirani kweli kuwa warípisi nsoko na mareba walongorera mbere yenu kwingira muufalume wa Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Kamana Yahaya mwenyé Koza kaja kwenu kwa njira ya shariya, fala amunkubali. Novyo-sivyo, warípisi nsoko na mareba wankubali. Na ingawa muwona, mwinsho amutubiye mukinkubali.” ");
INSERT INTO wmw_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Sikirizani kinyume cengine: Ákiwepo munu mmoja mwenyé nyumba karima masamba a uva, akijengera sereka. Nkati mwake akisimba pondo, akijenga nnara, masamba are akiwemisira warimi, akisafíri. ");
INSERT INTO wmw_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Paifikire karibu ya mavuno, kawatuma watumisi wake ka warimi ware, wakatware visumo vyake. ");
INSERT INTO wmw_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Warimi ware wakiwakola watumisi wake ware: mmoja wakimwibiya, mwengine wakimulaya, na mwengine wakimpanja na mawe. ");
INSERT INTO wmw_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Mwenyé masamba ire akiwatuma tena watumisi wengine, wengi futi zaida ya wakwanza ware. Newo wakiwatenda novire. ");
INSERT INTO wmw_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Mwinsho akintuma mwanawe, akiwaza javi: ‘Mwanangu‑yu wamwinshimu.’ ");
INSERT INTO wmw_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Fala warimi, pawammonire mwanawe ire, wakambirana watupu: ‘Noyu‑yu ndi asaka kuriti, tukeni timulaye, tinriti!’ ");
INSERT INTO wmw_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Basi, wakinkola, wakimwefya nyuma ya mpaka wa masamba a uva are, wakimulaya. ");
INSERT INTO wmw_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Paasaka kuja mwanyewe masamba are, warimi ware awatendaja?” ");
INSERT INTO wmw_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ewo wanjibu: “Visomi wabaya‑wo, awamariza nfululu na masamba‑wo awemisira warimi wengine, wakuwa wakumpa visumo wakati wa mavuno.” ");
INSERT INTO wmw_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Insa akiwambira: “Mwaja? Amufyomire Mandiko kuwa: ‘Riwe rawafezeyire wajengi, ndi riwere maalumu ra pamembe ya nyumba. Kinu‑ci akunisha ndi Mola, na citajabisa mmaso mwetu!’ ");
INSERT INTO wmw_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ndimana nukwambirani kuwa muvuriwa ufalume wa Mwenyezimungu, wapewa wanu wengine wakupa visumo vya ufalume‑wo. ");
INSERT INTO wmw_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Na asáka kugwira julu ya eri riwe‑ri, avunjiwa-vunjiwanga, na warisáka kungwirira onse asaika atenda ufu.” ");
INSERT INTO wmw_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Wakulungwa wa dini na Mafarizeu, pawasikire eci kinyume‑ci, wereriwa kuwa kankuwamba ewo. ");
INSERT INTO wmw_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Wakisaka kunfunga, fala wawopa wanu konta wakintula kuwa nabii wawo. ");
INSERT INTO wmw_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Mara nyengine, Insa akiwajibu akiwasowerera kwa kinyume, akamba: ");
INSERT INTO wmw_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Ufalume wa binguni ulandana na nfalume mmoja atengeze harusi ya mwanawe. ");
INSERT INTO wmw_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Katumiza kuweta warifíwe kujambo, fala awasakire kuja, kú! ");
INSERT INTO wmw_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Akiwatuma watumisi wengine tena, akamba: ‘Warifíwe wambireni javi: “Onani! Jambo rangu nisa kutengeza, ng'ombe na micamba isinjiwa futi, vinu piya viwa tayari. Njoni kujambo!” ’ ");
INSERT INTO wmw_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Fala warifíwe ware awayeriwe, woka vyawo: mmoja koka masamba kwake, mwengine koka kucuruza vinu vyake, ");
INSERT INTO wmw_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","na wengine wakiwakola watumisi ware, wakiwatabisha, wakiwolaya. ");
INSERT INTO wmw_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Kwa javyo, nfalume ire akikimiwa, akiwatuma masurudadu wake wakiwolaya visomi ware, nakisa wakitaya moto kaya yawo ire. ");
INSERT INTO wmw_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ikisa, akiwambira watumisi wake: ‘Epa jambo riwa tayari, fala warifíwe ndi sawari wanu. ");
INSERT INTO wmw_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Basi ukani mmasimana-manjira. Piya wamusaka kuwansingana onse warifuni waje kuharusi kuno.’ ");
INSERT INTO wmw_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Nakulawa watumisi ware woka munjira mure, wawajumanisa wawasimanane nawo piya, wabaya kamba wema. Mandowa are warifíwe wakijala bunga-bunga-bunga. ");
INSERT INTO wmw_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Fala nfalume ire, pengire mmandowa mure kuwawona warifíwe ware, kammona munu mmoja savarire mavazi a paharusi. ");
INSERT INTO wmw_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Iye akimwambira: ‘Rafiki yangu, kwingira mwaja emu sauna mavazi a paharusi?’ Iye akinyamala ndu. ");
INSERT INTO wmw_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Basi nfalume ire akiwambira watumisi wake: ‘Nfungeni maulu na makono, munsukure mumwefye panja pakisi‑po! Epo ndi pooka kurira na kutafuna meno.’ ");
INSERT INTO wmw_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Basi, wengi ndi wetiwa, fala watondoriwa ndi aba!” ");
INSERT INTO wmw_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Nakulawa pare, Mafarizeu wakitenda mpango wakunkoresa Insa kwa usemi. ");
INSERT INTO wmw_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Kwa javyo, wakiwapereka wanafunzi wawo pamoja na wa kinya Herodi, wakuka wakindairi: “Mwanlimu! Tukwijiwa kuwa uwe kuwa múkweli na ufunda njira ya Mwenyezimungu ka ukweli, aumopa munu asaka kuwa onse, konta aunang'aniza munu caari. ");
INSERT INTO wmw_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Kwa javyo, tambire mawoni ako. Iwapo haki ya kunripa nsoko Kaisari au aipo?” ");
INSERT INTO wmw_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Insa kwa kwijiwa ubaya wawo, akiwambira: “Manafiki, mbena muniyerera? ");
INSERT INTO wmw_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Nolotereni kuno jarajara ya nsoko‑yo.” Ewo wakija nawo jarajara moja, wakimpa. ");
INSERT INTO wmw_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Iye akiwadairi: “Ewu uso‑wu na mandiko‑ya a nani?” ");
INSERT INTO wmw_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Wakinjibu: “Vya Kaisari.” Iye akiwambira: “Basi, ca Kaisari mpeni Kaisari, na ca Mwenyezimungu mpeni Mwenyezimungu!” ");
INSERT INTO wmw_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Pawasikire javire wakishanga dwaraa. Wakimwasa, wakuka vyawo. ");
INSERT INTO wmw_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Noire suku ire, wafika karibu ya Insa Masaduseu, wenye kusema kuwa kufufuka akupo, wakindairi javi: ");
INSERT INTO wmw_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Mwanlimu! Nabii Musa kaamba kuwa ikiwa nlume kafwa bila kupongola naye nkawake, nduye ajuzi anjemele nankweli‑yo, filihali apongore naye, alunga rikolo ra nduye. ");
INSERT INTO wmw_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Kamana kati ya ofwe wana saba, wakwanza kanlomba, akifwa. Kwa kuwa aapongore naye mwana, nkawake akilombiwa na nduye. ");
INSERT INTO wmw_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Vikuna novyo na nduye wapiri, na watatu, mpaka wo saba. ");
INSERT INTO wmw_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Mwinsho ya piya ware, na muka ire akifwa. ");
INSERT INTO wmw_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Sambi, suku ya kufufuka wafwi, aja kuwa nlumake ndi wepi? Kamana piya ware wânlomba!” ");
INSERT INTO wmw_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Insa akiwajibu, akiwambira javi: “Umwe mupoteya konta amwijiwa Mandiko wala uwezo wa Mwenyezimungu! ");
INSERT INTO wmw_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Kamana wafwi pawaja kufufuka awalomba wala awalombiwa, wakuwa kamba malaika wari binguni. ");
INSERT INTO wmw_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Na nkati ya kufufuka ka wafwi, vyamwâmbiriwe na Mwenyezimungu, akamba: ");
INSERT INTO wmw_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Omi niwa Mwenyezimungu wa Iburahima na Mwenyezimungu wa Izaki na Mwenyezimungu wa Yankubu.’ Amufyomire javi? Basi Mwenyezimungu siyo Nlungu wa wafwi, ila wári hai!” ");
INSERT INTO wmw_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Wanu ware, pawasikire javire, watajabu kufunda kwake kure. ");
INSERT INTO wmw_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Mafarizeu, pawasikire kuwa Insa kawanyamaza Masaduseu, wakijumana novyo pamoja. ");
INSERT INTO wmw_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Kati yawo, mmoja ákiwa mwijiwifu wa shariya. Kwa kumyerera, akindairi Insa javi: ");
INSERT INTO wmw_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Mwanlimu, ámuri ulu nkati ya shariya ndi yepi?” ");
INSERT INTO wmw_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Insa akinjibu: “Mpende Mola, Mwenyezimungu wako, kwa moyo wako piya, kwa roho yako piya na kwa ankili zako piya. ");
INSERT INTO wmw_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Eyi ndi ámuri ulu na yakwanza. ");
INSERT INTO wmw_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Na yapiri ilandane neyi: ‘Mpende mwenziwo kamba vyauripenda mwanyewe.’ ");
INSERT INTO wmw_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ezi ámuri mbiri‑zi zifindikiriwa Taureti piya na vyawâfundire minabii.” ");
INSERT INTO wmw_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Pawajumane Mafarizeu pamoja, Insa akiwadairi, akamba: ");
INSERT INTO wmw_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Umwe mwankuwona mwaja kuhusu Almasihi? Iye mwana wa rikolo ranani?” ");
INSERT INTO wmw_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ewo wakijibu: “Wa rikolo ra Daudi!” Iye akiwambira: “Sambi, kwa nguvu za Roho Takatifu, Daudi kamwita ‘Mwenye wangu’. Mwaja? Konta Daudi kaamba: ");
INSERT INTO wmw_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Mola kamwambira Mwenye wangu: Ikala nkono nriro wangu, mpaka niwature maaduwi wako sini ya kumaulu kwako!’ ");
INSERT INTO wmw_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Basi, ikiwa Daudi kamwita ‘Mwenye wangu’, aawája mwana wa rikolo rake?” ");
INSERT INTO wmw_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Na awerepo munu akidirire kumwambira kinu. Tangu noyo suku‑yo, aalawirire tena wakushubutu kundairi kinu. ");
INSERT INTO wmw_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Sambi, Insa akisowera na junudi ya wanu pamoja na wanafunzi wake, ");
INSERT INTO wmw_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","akamba: “Wanlimu wa shariya na Mafarizeu wekala kiti ca nabii Musa. ");
INSERT INTO wmw_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Kwa javyo, fulatani na timizani piya vyawari kukwambirani. Fala asani kufulata vitendo vyawo, konta ewo cawasema sicawatenda. ");
INSERT INTO wmw_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Wafunga mizigo yakuremera wawatika wanu mmaweya, fala ewo awasaka kusukula anta na cala kimoja. ");
INSERT INTO wmw_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ewo watenda vitendo vyawo ipate wawoniwe na wanu. Wakurisa irizi zawo na wakongeza manyanyavu a malupindo awo. ");
INSERT INTO wmw_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Kuwajibu kwikala mahala bora mmajambo na viti vya inshima mmasinagoga. ");
INSERT INTO wmw_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Kuwajibu wenshimiwe mwawapita mmabazari, na viwajibu wanu wawete wanlimu. ");
INSERT INTO wmw_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Fala umwe musiwase wanu kukwitani ‘wanlimu’ kamana mwanlimu wenu mmoja basi, umwe piya muwa munu na nduye, ");
INSERT INTO wmw_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","wala mulumwengu‑mu musimwite ‘Baba’ munu asaka kuwa onse, kamana Baba wenu ndi mmoja basi, ári mbinguni. ");
INSERT INTO wmw_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Wala wasukwiteni mafundi, kamana fundi wenu ndi mmoja basi, Almasihi. ");
INSERT INTO wmw_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nkulungwa kati yenu awe ntumisi wenu. ");
INSERT INTO wmw_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Basi munu wakuriremeresa mwanyewe aveyesiwa, na mwenyé kuriveyesa mwanyewe, aremeresiwa.” ");
INSERT INTO wmw_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Insa akiwambira tena: “Umwe wanlimu wa shariya na Mafarizeu, manafiki, mulaniwe! Mufunga nryango wa ufalume wa binguni mbere ya wanu. Amwingira wala amuwasa wengire wenye kusakula kwingira. ");
INSERT INTO wmw_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Umwe wanlimu wa shariya na Mafarizeu manafiki, mulaniwe! Mupita mbahari na kungulu mumpate munu munsilimise dini yenu. Fala mukimpata, muntenda kuwa mwana wa Jahanamu mara mbiri zaida koliko umwe. ");
INSERT INTO wmw_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Umwe walongozi sawawona, mulaniwe! Musema kuwa: ‘Alapíra mahala takatifu kilapo‑co sico kinu, ila alapíra oru íri mahala takatifu ire, kilapo‑co ndi ca ukweli.’ ");
INSERT INTO wmw_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Wajinga sawawona! Epo kinu bora ndi cepi? Oru au mahala patendesa oru kuwa takatifu? ");
INSERT INTO wmw_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Na musema kuwa: ‘Alapíra uralu wa kafara, sikinu, fala alapíra kafara íri julu ya uralu, kilapo‑co ndi cakweli.’ ");
INSERT INTO wmw_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Wanu sawawona! Kinu bora ndi cepi? Kafara au uralu utenderiwa kafara ikiwa takatifu? ");
INSERT INTO wmw_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Basi, alapíra uralu, alapira uralu na ciri pajulu ya uralu. ");
INSERT INTO wmw_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Alapíra mahala takatifu, alapira mahala‑po na Nlungu ári nopo. ");
INSERT INTO wmw_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Na alapíra bingu, alapira kiti ca utukufu wa Mwenyezimungu na Nlungu ekare kiti cake. ");
INSERT INTO wmw_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Umwe wanlimu wa shariya na Mafarizeu manafiki, mulaniwe! Muwapa wanu zaka anta na vinu vya manukatu: safarãu, bizari, na loru. Fala mukwasa vinu bora pakulu vya shariya: haki, huruma, na uwaminifu. Evi ndi vinu vyamujuzi kutimiza, musase. ");
INSERT INTO wmw_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Walongozi sawawona! Umwe munsuja bwilimwiti fala mummiza ng'ombe! ");
INSERT INTO wmw_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Umwe wanlimu wa shariya na Mafarizeu manafiki, mulaniwe! Kiyungu na finga mukosa kunja, fala nkati mwijala ukoko wa vinu vya unyang'anyi na wájibu mbaya. ");
INSERT INTO wmw_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Nfarizeu sauwona! Kiyungu anza kosa nkati ipate na kunja kusitawi novyo. ");
INSERT INTO wmw_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Umwe wanlimu wa shariya na Mafarizeu manafiki, mulaniwe! Umwe mulanda makaburi a kupakiwa kinambo akusitawiziwa panja, iri filihali nkati muwa makongolo a wafwi, mwijala takataka na ucafu. ");
INSERT INTO wmw_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Na umwe novyo, kunja muwoniwa na wanu kamba wenye shariya, iri filihali nkati yenu wijala unafiki na vitendo vyakuvunja shariya. ");
INSERT INTO wmw_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Umwe wanlimu wa shariya na Mafarizeu manafiki, mulaniwe! Mujengera makaburi a minabii na mupamba kusitawiza makaburi a wanu wa shariya. ");
INSERT INTO wmw_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Mukwamba: ‘Tinainshi enzi za wazee wetu, atingari kujumulana nawo kutawanya damu ya minabii!’ ");
INSERT INTO wmw_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Basi, kwa javyo murolota wanyewe kuwa muwa vining'ini vya ware wawolaye minabii. ");
INSERT INTO wmw_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Basi timizani kipimo ca ubaya ca babu zenu! ");
INSERT INTO wmw_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Manyoka, wana wa miraba! Munyemaja hukumu ya moto wa Jahanamu? ");
INSERT INTO wmw_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Kwa javyo, nukuperekerani minabii, wejiwifu, na mafundi. Wamojawapo muwolaya na muwagomezera mmisalaba, wengine muwacapa viboko mmasinagoga mwenu, na muwenenda mukiwalumbata kila kaya. ");
INSERT INTO wmw_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Kwa javyo ije julu yenu hukumu kwa sababu ya damu ya wenye shariya itawanyike julu ya ardhi, tangu mwanzo kutawanyika ka damu ya Abeli, mwenyé shariya, mpaka na damu ya Zagariya, mwana wa Barakiya wamumulaye nNyumba Takatifu, kati-kati ya mahala takatifu na uralu. ");
INSERT INTO wmw_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nukwambirani kweli kuwa wanu wa eci kizazi‑ci, ezi hukumu‑zi zíwapata.” ");
INSERT INTO wmw_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Insa kaamba: “Wanu wa Yerusalemu! Ha, wanu wa Yerusalemu! Wari kuwolaya na kuwapanja na mawe minabii waperekiwe kwawo! Mara nyengapi yanisakire kuwakusanya wana wawo kamba uku vyaawakúsanya wanawe akiwafinika mumbawa zake! Fala umwe amusakire. ");
INSERT INTO wmw_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Aya basi, kaya yenu‑yo ikuja kutaduka milembe. ");
INSERT INTO wmw_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Konta nukwambirani kweli kuwa amuniwona tena, kulawa sambi‑pa mpaka suku yamusaka kusema: ‘Asifiwe mwenyé kuja kwa zina ra Mola!’ ” ");
INSERT INTO wmw_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Insa, paakilawa nNyumba Takatifu akuka vyake, wanafunzi wake wakinfíka karibu yake, wakimolotera namuna vyaijengiwe nyumba ire. ");
INSERT INTO wmw_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Insa akiwambira, akamba: “Mwankuwona evi piya‑vi? Nukwambirani kweli kuwa epa hapana riwe ríja kubaki julu ya riwe renziwe, piya abomoriwa.” ");
INSERT INTO wmw_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Insa paakikala pamwango wa Mizaituni, wanafunzi wake wakimukira cembe, wakimwambira: “Tambire vinu-vyo vikuja kukuna rini? Na alamani ya kuja kwake, suku ya Kiyama?” ");
INSERT INTO wmw_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Insa akiwajibu, akamba: “More-moreni asukuteseni munu, ");
INSERT INTO wmw_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","konta wengi wakuja kwa zina rangu, wakamba: ‘Omi ndi Almasihi’, na wawatesa wanu wengi. ");
INSERT INTO wmw_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Umwe mukuja kusikira habari na utesi wa vita. Novyo-sivyo musope. Konta evyo vinu-vyo lazima vikune. Fala siyo kuwa ndi suku ya Kiyama. ");
INSERT INTO wmw_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Taifa ikuja kutenda vita na taifa nyengine, ufalume mmoja na ufalume mwenziwe. Cikuja kupita kitikansi pamoja na njala mahala mwingi mwawenye. ");
INSERT INTO wmw_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Evi vinu‑vi piya ndi kamba mwanzo wa malwazo a kupongola. ");
INSERT INTO wmw_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ewo wakuperekani kutabishiwa na wakuulayani, na mukuja kwiniwa na piya taifa‑zi kwa sababu ya zina rangu. ");
INSERT INTO wmw_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Wengi wakuja kukosiwa, wengi wakuja kuwapereka wenziwawo kuhukumiwa, na kwinana munu na mwenziwe. ");
INSERT INTO wmw_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Wakuja kulawirira minabii wengi walongo, wakupita wakiwatesa wanu wengi wawenye. ");
INSERT INTO wmw_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kwa sababu ya kongezeka ubaya, kupendana ka wanu wengi kukuja kuwa aba. ");
INSERT INTO wmw_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Fala mwenyé kuvumirira mpaka mwinsho ndi aja kuvushiwa. ");
INSERT INTO wmw_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Na eyi habari ya ufalume‑yi ikwereziwa ulumwengu nzima, uwé ushahidi mbere ya kabila‑zi piya. Epo ndi paija kufika suku ya Kiyama.” ");
INSERT INTO wmw_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Kwa javyo, mukiwona haramu yakutenza uwaribifu mahala patakatifu, kamba vyaâmbire nabii Daniyeli (mwenyé kufyoma onse, ereriwe), ");
INSERT INTO wmw_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","basi sambi wája kuwa Yudeya wajuzi watuwirire mmyango, ");
INSERT INTO wmw_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ája kuwapo papala ra nyumba yake onse asisuke kutwala kinu nnyumba mwake, ");
INSERT INTO wmw_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","na ája kuwapo mmasamba onse asiludire kukaya kutwala mavazi ake. ");
INSERT INTO wmw_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Dambi wemite na maametoto wakowesa kwa ezo suku‑zo! ");
INSERT INTO wmw_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mulebele duwa ipate kutuwa kwenu kusije kuwa wakati wa kinja au isiwe suku ya sabadu, ");
INSERT INTO wmw_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","konta wakati‑wo ukuja kuwa wa mashaka pakulu futi, mashaka saanapita tangu mwanzo wa ulumwengu mpaka sambi‑pa, wala aaja kupita tena. ");
INSERT INTO wmw_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Siwere kunukusiwa nozo suku‑zo, aakivuka munu. Fala, kwa sababu ya watondóriwe, ezo suku‑zo zikuja kunukusiwa. ");
INSERT INTO wmw_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Basi, akilawirira munu akukwambirani: ‘Almasihi ndiyu‑pa’, au ‘Ndi ire pare’, musikubali. ");
INSERT INTO wmw_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kamana wakuja kulawirira maAlmasihi walongo na minabii walongo. Ewo wakuja kutenda alama ulu na maajuza, wafikirire kuwatesa ware watondóriwe, ikikidirika. ");
INSERT INTO wmw_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Onani, omi nankukwambirani namapema. ");
INSERT INTO wmw_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Basi akilawirira munu akukwambirani: ‘Iye kawa pare, paluwanja pare!’, musuke noko. Au: ‘Kawa nnyumba mure’, musikubali. ");
INSERT INTO wmw_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Konta kamba vyamufahamu kumensa vyakulangaza mashariki mpaka magharibi, ndi vyaasaka kuja kwisuka Binadamu wa Binguni. ");
INSERT INTO wmw_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Mahala pakufwa nyama apakosa kumota membe.” ");
INSERT INTO wmw_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Insa kaamba: “Zikipita suku za mashaka‑zo, juwa arija kuwala kukwinukala pi, mwezi auja kuwala, nondwa zisomoka binguni zikigwa, na nguvu za binguni piya zitikinyika. ");
INSERT INTO wmw_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Basi ikuja kuwoneka julu ya binguni alama ya kwisuka Binadamu wa Binguni. Kwa javyo, zilalamika kabila piya za duniya, ikisa wammona Binadamu akisuka mmawingu binguni, na nguvu pamoja na utukufu pakulu. ");
INSERT INTO wmw_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Na shauti ulu ya baramanda, iye awapereka malaika wake. Ewo wakiwakusanya waawatóndore iye, kwa kila membe nne za duniya, kwanza mwanzo mpaka mwinsho.” ");
INSERT INTO wmw_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Rifyomeseni kwa nfano wa muti wakwitiwa mmongo. Mmongo, ukiwa na vitambi viwisi, ukanza kusipuka masamba, mukwijiwa kuwa kinja cifika futi. ");
INSERT INTO wmw_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ndi sawa‑sawa novyo. Mukiwona eyo mambo‑yo akikuna, ijiwani kuwa Binadamu kawa karibu, kawa panryango! ");
INSERT INTO wmw_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nukwambirani kweli kuwa eci kizazi‑ci acipita saanakuna eyo mambo‑yo piya. ");
INSERT INTO wmw_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Bingu na ardhi piya vilainika, fala usemi wangu aulainika.” ");
INSERT INTO wmw_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Na kuhusu suku na wakati wa kukuna novyo vinu-vyo, hapana ejiwa. Awejiwa malaika mbinguni wala Mwana, ila Mwenyezimungu Baba tu basi. ");
INSERT INTO wmw_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Kamana kamba vyavîkunire wakati wa nabii Nnu, ndi vyavija kukuna pakuja Binadamu. ");
INSERT INTO wmw_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Nozo suku‑zo, zikuja kuwa kamba vyazikiwa zire suku saanapita mwanalukaya: wanu wakirya na wakinywa, wakilomba na wakilombiwa, mpaka suku yengire nabii Nnu nsafina. ");
INSERT INTO wmw_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Wanu awejiwe, mpaka paajire mwanalukaya nkulu, akiwakumba piya ware. Basi, novyo ndi vyavija kuwa wakati wa kuja Binadamu. ");
INSERT INTO wmw_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Wakati‑wo wakuwapo wanu wawiri mmasamba, mmoja atwariwa mwengine akwasiwa. ");
INSERT INTO wmw_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Wanawaka wawiri wakisaya cakurya, mmoja atwariwa mwengine akwasiwa. ");
INSERT INTO wmw_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ndimana, rinang'anizíreni konta amwijiwa suku yaasaka kuja Mwenye wenu. ");
INSERT INTO wmw_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Tulani kuwa mwenyé nyumba, anejiwa wakati wakuja mwivi, nanga kekala kunang'anizira, ásase nyumba yake kupapaturiwa. ");
INSERT INTO wmw_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kwa javyo, umwe novyo muwe tayari, kamana wakati samuwáza kuwa Binadamu kankuja, akuja.” ");
INSERT INTO wmw_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Ntumisi mwaminifu na wa ankili, wakuwa mwenye wake kantula pakaya, awape wanu wake cakurya na wakati wake, ntumisi‑yo nani? ");
INSERT INTO wmw_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Heri ntumisi‑yo wakuwa mwenye wake pakuludi, ansingana akitenda javyo! ");
INSERT INTO wmw_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nukwambirani kweli kuwa ntumisi‑yo mwenye wake antula kumiliki vinu vyake piya. ");
INSERT INTO wmw_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Fala ntumisi‑yo, akiwa mbaya, kimoyomoyo akwamba, ‘Mwenye wangu kakawa kuludi’. ");
INSERT INTO wmw_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ndimana akwanza kuwebiya wenziwe ware, akirya na akinywa pamoja na warevi. ");
INSERT INTO wmw_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Mwenye wa ntumisi‑yo paaludi, suku saakinrindira wala wakati sejiwa, ");
INSERT INTO wmw_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","iye anhukumu vibaya futi, na fungu rake antula kundi ra manafiki. Epo ndi paciwa kiriro na kutafuna meno!” ");
INSERT INTO wmw_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Insa akamba: “Ufalume wa binguni ukuja kulandana na wári kumi, wasukure kandiyeru zawo, kummwinza mwenye-harusi. ");
INSERT INTO wmw_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Nkati ya ewo wári‑wo, watanu sawawaza, na watanu wakuwaza. ");
INSERT INTO wmw_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Basi sawawaza ware wasukula kandiyeru zawo, fala awarisukuze mafuta! ");
INSERT INTO wmw_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Fala wakuwáza ware warisukuza numba za mafuta na kandiyeru zawo. ");
INSERT INTO wmw_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Kwa kuwa mwenye-harusi ire kakawa kuja, wári ware piya wanza kusinzira mpaka wakilala. ");
INSERT INTO wmw_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Usiku kati-kati kukinyanguriwa: ‘Mwenye harusi kankuja! Lawani mumpokerere!’ ");
INSERT INTO wmw_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Noparepare wári ware piya wakilamuka, wakitengeza kandiyeru zawo. ");
INSERT INTO wmw_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Sawawaza ware wakiwambira wakuwaza ware javi: ‘Timereni mafuta enu‑yo, konta kandiyeru zetu‑zi zankuzimika.’ ");
INSERT INTO wmw_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Wakuwáza ware wakijibu wakamba: ‘Aripo‑ya aatitosha futi kutúmira ofwe nnomwe. Fadari ukani kauzanyiwa konse mukauze mutumire.’ ");
INSERT INTO wmw_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Pawalawire kuka kuuza, akifika mwenye-harusi. Wári waritengeze ware wakingira naye njambo, nryango ukifungiwa. ");
INSERT INTO wmw_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ikisa, wári wengine ware pawaludire wakamba: ‘Mwenye, Mwenye, tifungurireni!’ ");
INSERT INTO wmw_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Fala iye akiwajibu akamba: ‘Nukwambirani kweli kuwa sukwijiwani.’ ");
INSERT INTO wmw_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Basi, rinang'anizireni, kamana amwijiwa suku wala wakati wakuja Mwenye!” ");
INSERT INTO wmw_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Wakati‑wo ukuja kuwa kamba munu vyaasaka kusafiri, kaweta watumisi wake, kawagabizi mali zake. ");
INSERT INTO wmw_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Akimpa mmoja talanta ntanu, mwengine talanta mbiri, na mwengine talanta moja, kila mmoja na uwezo wake. Ikisa akuka vyake. ");
INSERT INTO wmw_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Kwa mpunde noure, apokerere talanta ntanu ire, kacuruzira na kapata faida ya talanta ntanu. ");
INSERT INTO wmw_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Apokerere talanta mbiri ire kapata faida ya talanta mbiri. ");
INSERT INTO wmw_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Fala apokerere moja ire kalawa, kasimba pansi, kafisa nzuruku wapewe na mwenye wake ure. ");
INSERT INTO wmw_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Bandi ya suku nyingi zawenye, mwenye wa watumisi ire akiludi, wakiwalangirana. ");
INSERT INTO wmw_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Akija karibu apokerere talanta ntanu ire, akolota nyengine talanta ntanu zire, akwamba javi: ‘Onani Mwenye! Talanta ntanu zamunipere‑zi, nezi nyengine ntanu zanipatire faida.’ ");
INSERT INTO wmw_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Mwenye wake ire akwamba: ‘Kuwa ntumisi mwema na mwaminifu. Bandi yakuwa mwaminifu wa vinu aba, sambi nukugabizi vingi. Ingira ufurahi na mwenye wako!’ ");
INSERT INTO wmw_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Akija karibu novyo apokerere talanta mbiri ire, akwamba: ‘Mwenye, talanta mbiri zamunipere, ezi nyengine mbiri zanipatire faida.’ ");
INSERT INTO wmw_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Mwenye wake ire akwamba: ‘Kuwa ntumisi mwema na mwaminifu. Bandi ya kuwa mwaminifu wa vinu aba, sambi nukugabizi vingi. Ingira ufurahi na mwenye wako!’ ");
INSERT INTO wmw_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Akija karibu novyo apokerere talanta moja ire akwamba: ‘Mwenye, nukwijiwa kuwa kwa munu ngumu, úvuna mahala sauvyarire, ukusanya mahala sautawanye. ");
INSERT INTO wmw_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nopa, ndimana nifisa pansi talanta yako, epa kwanawo talanta yako noire.’ ");
INSERT INTO wmw_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Nakujibu mwenye wake ire ansutumu, amwambira javi: ‘Ntumisi mbaya na nfuko! Nivuna mahala sanivyarire, nikusanya mahala sanitawanye! Ukwijiwa javyo? ");
INSERT INTO wmw_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ndimana, ukijuzi kutula nzuruku wangu kubanku, nikija nisingane faida yangu. ");
INSERT INTO wmw_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Basi, mpokeni talanta‑yo, mumpe ire ári nazo talanta kumi ire. ");
INSERT INTO wmw_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kamana kila mwenyé kuwa nawo, azidi kupewa kwa wingi. Fala saana, anta aba caári nawo noco, anyang'anyiwa.’ ");
INSERT INTO wmw_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Na ntumisi safãi‑yo, ntuwisireni panja pakisi‑po. Epo ndi pooka kurira na kutafuna meno.” ");
INSERT INTO wmw_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Paaja kwisuka Binadamu wa Binguni, na utukufu wake na piya malaika wakuwa pamoja naye, basi akwikala julu ya kiti ca utukufu wake. ");
INSERT INTO wmw_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Mbere yake zikusanyika kabila piya. Ikisa iye akuja kuwatanusa munu na mwenziwe, kamba nsunga vyaawatanusa makondoo na mbuzi. ");
INSERT INTO wmw_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Makondoo áwatula upande wa nkono nriro wake, mbuzi upande wa nkono sonto. ");
INSERT INTO wmw_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ikisa nfalume ire awambira wári nkono nriro wake, akwamba: ‘Njoni kuno, wenye kujanliiwa na Baba wangu. Ritini ufalume wamutengezeriwe, tangu mwanzo wa ulumwengu. ");
INSERT INTO wmw_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kamana inikola njala, munipa cakurya. Inikola nyotwa, muninywesa maji. Nikiwa myeni, munikaribisha. ");
INSERT INTO wmw_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Nikiwa diki, munipa cakuvala. Nikiwa nlwere, munilwarisa. Nifungiwa nkalaboshu, muja kuniwona.’ ");
INSERT INTO wmw_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Basi, wanu wa shariya wakinjibu wakamba: ‘Mwenye, rini patukuwonire ikukukola njala tukukupa cakurya? Au ikukukola nyotwa tukukunywesa maji? ");
INSERT INTO wmw_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Rini patukuwonire uri myeni tukukukaribisha, au uri diki tukukupa cakuvala? ");
INSERT INTO wmw_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Rini paúkiwa nlwere au nkalaboshu, tikija tukukuwona?’ ");
INSERT INTO wmw_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Nakujibu, nfalume ire akiwambira: ‘Nukwambirani kweli kuwa, kwa kila kinu camuwatendera wanduzangu watoto futi‑wa mmojawapo, epo munitendera omi!’ ");
INSERT INTO wmw_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Nakisa kawambira novyo wákiwa upande wa nkono sonto ware: ‘Nitanukeni, wanu wakulaniwa. Ukani kuri hukumu ya moto wa milele, moto watengezeriwe Ibilisi pamoja na majini wake. ");
INSERT INTO wmw_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Konta inikola njala, amunipere cakurya. Inikola nyotwa, amuninywesire maji. ");
INSERT INTO wmw_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nikiwa myeni amunikaribishe, nikiwa diki amunipere cakuvala. Nikiwa nlwere na nifungiwa nkalaboshu fala amujire kuniwona.’ ");
INSERT INTO wmw_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Newo novyo wakijibu wakamba: ‘Mwenye, rini paikukorire njala au nyotwa, au úri myeni, au úri diki, au úri nlwere au ufungiwe, ofwe tikitowa kukuhudumu?’ ");
INSERT INTO wmw_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Iye akiwajibu akamba: ‘Nukwambirani kweli kuwa kila kinu samuntendere wanduzangu watoto futi‑wa mmojawapo, amunitendere omi!’ ");
INSERT INTO wmw_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Basi ewa wakuka kuhukumu ya milele, fala wenye shariya wakuka kumainsha a milele.” ");
INSERT INTO wmw_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Insa paamarize usemi ure piya, wanafunzi kawambira javi: ");
INSERT INTO wmw_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Mukwijiwa kuwa ubaki muda wa suku mbiri, ífika suku ya Pashukwa, na Binadamu wa Binguni aperekiwa akagomezeriwe pansalaba.” ");
INSERT INTO wmw_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Wakati‑wo wakulungwa wa dini pamoja na wazee wa Mayahudi wâjumana pamoja kunyumba ulu ya Kayafa, nkulu wa wakulungwa wa dini, ");
INSERT INTO wmw_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","wakipanga wantese Insa wankore wamulaye. ");
INSERT INTO wmw_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Fala wakamba: “Tisinkore suku ya sherehe‑yi, isije kulawa vurumãi ya wanu.” ");
INSERT INTO wmw_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Paafikire Insa Betaniya nyumba ya Ansumani camagundula, ");
INSERT INTO wmw_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","mwanamuka mmoja akinfika karibu yake. Insa pekare akirya, mwanamuka ire asukure munringi mafuta akuniwira gali sana, akimmiminira Insa nkiswa. ");
INSERT INTO wmw_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Wanafunzi wake ware pawawonire javire, wakikimiwa, wakamba: “Eyi hasarani‑yi? ");
INSERT INTO wmw_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Kamana nanga auzanyiwa nzuruku mwingi wawenye, wapewa masikini!” ");
INSERT INTO wmw_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Insa pejiwe cawari kuwaza, akiwambira: “Mbena mumwandibu mwanamuka‑yu? Kamana katenda cema kwangu omi. ");
INSERT INTO wmw_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Konta daima‑zi wamasikini wawa pamoja namwe, fala daima amuja kuwa pamoja nomi. ");
INSERT INTO wmw_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Eyu mwanamuka‑yu kanimiminira mafuta akunuwira‑ya mmwiri mwangu kwa anzima ya kunitengezera namapema maziko angu. ");
INSERT INTO wmw_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nukwambirani kweli kuwa ulumwengu nzima‑wu, kila mahala paisaka kwereziwa Habari Ngema, visemiwa novyo vyaatendire mwanamuka‑yu, kwa kukumbukiriwa kwake.” ");
INSERT INTO wmw_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ikisa mmoja wawo kati ya kumi na wawiri ware, wakwitiwa Yuda Shikariyoti, akuka ka wakulungwa wa dini, ");
INSERT INTO wmw_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","akiwadairi: “Nukukugabizini Insa, munipa kinani?” Ewo wakimpa jarajara talatini za parata. ");
INSERT INTO wmw_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Mwanzo wa noure wakati ure, akisakula nafasi ya kunzungunuka Insa, awagabizi maaduwi wake. ");
INSERT INTO wmw_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Suku yakwanza jambo ra mikate saitayiwe furumento, wanafunzi wamúkira Insa wakindairi javi: “Ndepi pausaka tikakutengezere cakurya ca Pashukwa urye?” ");
INSERT INTO wmw_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Neye akiwajibu: “Ukani mpaka kaya ulu, ka mwananlume mmoja, mukamwambire javi: ‘Mwanlimu katumiza javi: Wakati wangu uwa karibu kufika. Nukuja kwako kutenda Pashukwa pamoja na wanafunzi wangu.’ ” ");
INSERT INTO wmw_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Wanafunzi ware wakitenda kamba vyawatumiwe na Insa, wakitengeza jambo ra Pashukwa rire. ");
INSERT INTO wmw_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Paufikire usiku, Insa kekala pamoja na wanafunzi wake kumi na wawiri kusaka kurya. ");
INSERT INTO wmw_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Pawakirya, iye akamba javi: “Nukwambirani kweli kuwa piya-mwe mmojawapo anizungunuka.” ");
INSERT INTO wmw_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Wanafunzi ware wakiuzunika pakulu futi. Kwa kila mmoja akanza kundairi: “Mwenye, unamba omi?” ");
INSERT INTO wmw_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Iye akijibu, akamba: “Ataire nkono wake pamoja nomi nfinga moja, noyo ndi asaka kunizungunuka. ");
INSERT INTO wmw_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ndi kweli Binadamu wa Binguni akufwa kamba vyaasema Mandiko kuhusu iye, fala dambi ire mwenyé kunzungunuka! Fadari anatowa kupongoriwa noyo munu‑yo.” ");
INSERT INTO wmw_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Basi Yuda mwenyé kunzungunuka, akidairi akamba: “Fala sumi, Mwanlimu?” Insa akinjibu: “Kurisema mwanyewe.” ");
INSERT INTO wmw_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Pawakirya, Insa akitwala nkate, nakuntukuza Mwenyezimungu, akimeya akiwapa wanafunzi wake, akisema akamba: “Twalani mutafune, ewu ndi mwiri wangu.” ");
INSERT INTO wmw_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Nakisa akitwala kikombe, akishukuru novire, akiwapa akisema: “Inywani piya-mwe, ");
INSERT INTO wmw_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","kamana eyi ndi damu yangu yakwakikisha kupatana, damu itawanyike kwa ajili ya wanu wengi ipate waswamiiwe madambi. ");
INSERT INTO wmw_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nukwambirani kuwa eci kisumo ca uva‑ci siludira kunywa tena mpaka suku yanisaka kunywa nyipya, pamoja nomwe kati ya ufalume wa Baba wangu.” ");
INSERT INTO wmw_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Pawesire kwimba nyimbo, wakilawa wakuka mwango wa Mizaituni. ");
INSERT INTO wmw_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ikisa Insa kawambira wanafunzi wake kaamba: “Umwe piya mubugudika nami usiku wa rero‑wu, kamana yaândikiwa javi: ‘Ninlumiza nsunga, nkonjo wa makondoo wake utawanyika.’ ");
INSERT INTO wmw_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Fala bandi ya kufufuka kwangu, nilongorera Galileya.” ");
INSERT INTO wmw_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Peduru akinjibu, akamba: “Anta ikiwa piya wabugudika nawe, fala omi sishubutu futi kubugudika!” ");
INSERT INTO wmw_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Noparepare Insa akimwambira: “Nukwambira kweli kuwa usiku wa rero‑wu saanawika kokoriko ntanzi, unikana mara natu.” ");
INSERT INTO wmw_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Peduru akimwambira Insa javi: “Anta paiwa kuwa tikufwa pamoja, sishubutu futi kukukana!” Na wanafunzi wengine ware, piya wakisema novire. ");
INSERT INTO wmw_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ikisa Insa akuka nawo mahala pakwitiwa Getisemani, akiwambira wanafunzi javi: “Ikalani nopa, omi nukuka mpaka pare nikalebele duwa.” ");
INSERT INTO wmw_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Nakunsukula Peduru na wana wawiri wa Zebedeyu, akanza kukafilika, akiuzunika. ");
INSERT INTO wmw_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Basi noparepare akiwambira javi: “Uzúnika pakulu futi moyo yangu, niwa karibu kufwa! Ikalani‑pa, murinang'anizire pamoja nomi.” ");
INSERT INTO wmw_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Akuka mbere aba, akisujudi, akilebela: “Baba wangu, ikikidirika, kikombe ca nyongo yako‑ci cinitanuke. Novyo-sivyo, isiwe kamba vyanisaka omi, ila iwe vyausaka uwe.” ");
INSERT INTO wmw_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Akija ka wanafunzi wake, kawasingana walarire usingizi, akimwambira Peduru: “Kú, amukidirire kurinang'anizira pamoja nomi nanga ora moja basi? ");
INSERT INTO wmw_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Rinang'anizireni na lebelani duwa musije kushetwaniwa. Kamana moyo uwa tayari ila mwiri ndi mwepepe.” ");
INSERT INTO wmw_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Mara nyengine tena, Insa akuka akilebela duwa, akamba: “Baba wangu, kamba avikidirika kulavya kikombe‑ci saninywere, basi vitimiziwe vyausaka uwe.” ");
INSERT INTO wmw_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Akija tena, kawasingana wakilala, konta maso awaremera usingizi. ");
INSERT INTO wmw_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Nakuwasa, akuka tena akilebela duwa mara yatatu, akiludira usowezi mmoja noure. ");
INSERT INTO wmw_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Nakisa akiludi akija ka wanafunzi wake, akiwambira javi: “Mwaja, mungari mukilala, mwankupumula? Tunzani! Ufika wakati wakuzungunukiwa Binadamu wa Binguni, aperekiwa mmakono mwa wamádambi. ");
INSERT INTO wmw_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Lamukani, tuke vyetu. Onani! Kafika futi mwenyé kunizungunuka.” ");
INSERT INTO wmw_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Iri Insa kankusowera nawo, sambi akija Yuda, mmoja wawo nkati ya wanafunzi kumi na wawiri ware. Kaja na junudi ya wanu, waperekiwe na walongozi wa dini na wazee wa Mayahudi. Wasukure katana zawo pamoja na mipweke. ");
INSERT INTO wmw_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ire mwenyé kunzungunuka, akiwapa alama, akiwambira: “Wanisaka kumpa beju onse, ndi noyo. Nkoreni.” ");
INSERT INTO wmw_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Noure wakati ure, Yuda akinfika karibu Insa, akimwambira javi: “Mashikamu, mwanlimu!”, ikisa akimpa beju. ");
INSERT INTO wmw_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Fala Insa akimwambira: “Rafiki yangu, caulangele kutenda conse, tenda.” Wanu ware, nakufika karibu yake, wakolosa makono a Insa wakinkola. ");
INSERT INTO wmw_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Sambi mmojawapo wákiwa na Insa ware akolosa nkono, akisolola jambiya, akinduru ntumisi mmoja wa nkulu wa wakulungwa wa dini, akinsinja sikiro rimoja. ");
INSERT INTO wmw_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Insa akimwambíra javi: “Tula jambiya yako‑yo mahala mwake, konta wenye kulamusa jambiya onse, iwolaya jambiya noyo. ");
INSERT INTO wmw_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Mwaja? Udaniza kuwa omi sina uwezo wakunlebela Baba wangu, iye kuniperekera malaika zaida ya makundi a majeshi kumi na mawiri? ");
INSERT INTO wmw_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Avi sambi, nanga atimiziwa mwaja Mandiko asema kuwa vikijuzi vikune javi?” ");
INSERT INTO wmw_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Wakati noure, Insa akiwambira junudi ya wanu ware: “Mulawa na jambiya pamoja na mipweke kuja kunitwala! Omi niwa mwivi? Suku daima‑zi níkikalanga nikifunda Nyumba Takatifu, fala amujire kunikola! ");
INSERT INTO wmw_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ila kwa piya‑vi vikuna ipate atimu Mandiko a minabii.” Basi wanafunzi ware piya wakimwasa, wakintira. ");
INSERT INTO wmw_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Wanu wankorire Insa ware wakimukisa ka Kayafa, nkulu wa wakulungwa wa dini, mahala kawâjumane wanlimu wa shariya pamoja na wazee. ");
INSERT INTO wmw_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Sambi Peduru akinfulata baidi futi, mpaka nluwani mwa nkulu wa wakulungwa wa dini. Akingira akikala pamoja na mashikarakanzi apate kwijiwa mwinsho wake. ");
INSERT INTO wmw_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Sambi, jumula ya wakulungwa wa dini pamoja na wanu piya wa Baraza ya Milandu wakisimanana, wakisakula ushahidi wa ulongo wakunkosesa Insa wamulaye. ");
INSERT INTO wmw_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Fala awapatire ushahidi, ingawa wálawirira mashahidi wengi walongo. Mwinsho walawirira mashahidi wawiri, ");
INSERT INTO wmw_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","wamba: “Eyu kasema javi: ‘Omi nikidiri kubomola Nyumba Takatifu ya Mwenyezimungu, muda wa suku natu basi níjenga tena upya.’ ” ");
INSERT INTO wmw_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Sambi nkulu wa wakulungwa wa dini akilamuka, akindairi: “Aujibu kinu ushahidi wawari kukulongopera uwe‑wu?” ");
INSERT INTO wmw_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Fala Insa kabaki anyamare. Nkulu wa wakulungwa wa dini ire akimwambira javi: “Omi nukulapisa kwa zina ra Mwenyezimungu ári hai, tambire kamba kuwa Almasihi, Mwana wa Mwenyezimungu.” ");
INSERT INTO wmw_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Insa akinjibu: “Uwe ndi vyawamba. Fala nukwambirani kuwa kulawa sambi‑pa, mummona Binadamu wa Binguni ekare nkono nriro wa Mwenyezimungu, Mwenyé Uwezo, na akisuka julu ya mawingu a binguni.” ");
INSERT INTO wmw_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Basi nkulu wa wakulungwa wa dini akipapula mavazi ake, akamba: “Iye kakufuru! Tisakula ushahidi wa kinani tena? Munsikira sambi‑pa akikufuru. ");
INSERT INTO wmw_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Umwe muwonaja?” Ewo wakinjibu: “Ajuzi aulaiwe!” ");
INSERT INTO wmw_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Sambi wakinsunira kumaso, wakimwefya soku na malatuma pú‑pú‑pú, ");
INSERT INTO wmw_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","wakamba: “Utibushurira ofwe, Almasihi! Epa akwibiye nani?” ");
INSERT INTO wmw_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Sambi, Peduru kêkala panja nluwani. Ntumisi mmoja mwari akinfika karibu yake, akimwambira javi: “Nowe novyo úkiwa pamoja na Insa nGalileya!” ");
INSERT INTO wmw_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Fala iye akikana mbere ya wanu ware piya, akamba: “Cauri kusowera‑co, sijiwa!” ");
INSERT INTO wmw_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Nakulamuka pare, akúka mpaka nkitala, ntumisi mwengine muka akimmona, akiwambira wanu ware, akamba: “Eyu ákiwa pamoja na Insa nNazareti!” ");
INSERT INTO wmw_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Tena iye akinkana kwa kulapira: “Eyu munu‑yu, simwijiwa!” ");
INSERT INTO wmw_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Mpunde sinkulu wanu wákiwa nopare wakimukira Peduru, wakimwambira: “Kweli-kwelini, na uwe novyo nkonjo wenu mmoja na ware, konta kusowera kwako umanyirika!” ");
INSERT INTO wmw_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Noparepare, iye akanza kurilani kuno akilapira: “Simwijiwa‑mi eyu munu‑yu!” Mpunde noure, kokoriko akiwika. ");
INSERT INTO wmw_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Sambi Peduru ire akikumbukira usowezi waâsowere Insa ure kuwa: “Kokoriko saanawika, unikana mara natu.” Basi akilawira panja, akanza kurira pakulu futi. ");
INSERT INTO wmw_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Pakucere subuu namapema, wakulungwa wa dini pamoja na wazee wa Mayahudi piya wakisikizana kumuulaya Insa. ");
INSERT INTO wmw_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Wakinfunga, wakintwala, wakimpereka ka guvinadoru Pilatu. ");
INSERT INTO wmw_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Sambi Yuda, ânzungunuke Insa ire, paawonire kuwa kesa kuhukumiwa, akirishuku pakulu, akiludisa nzuruku wa jarajara talatini za parata ure, akiwapa wakulungwa wa dini na wazee ware, ");
INSERT INTO wmw_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","akiwambira: “Nikola dambi, ninzungunuka munu saana makosa.” Ewo wakijibu, wakamba: “Ofwe vitiyerireni, eyo shauri yako!” ");
INSERT INTO wmw_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Sambi Yuda noparepare akitwala jarajara za parata zire, akefyera nNyumba Takatifu, akilawa akuka akirifungangira. ");
INSERT INTO wmw_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Wakulungwa wa dini wakitwala nzuruku ure, wakamba: “Ewu nzuruku‑wu anta siyo halali kuka kuturiwa ankiba konta nzuruku wa damu.” ");
INSERT INTO wmw_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Basi wakisikizana, wakiuza uweru wa nfiyangi viyungu, iwe bushtani ya kuwazika wayeni. ");
INSERT INTO wmw_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ndimana, noyo bushtani‑yo ikwitiwa “Uweru wa damu” mpaka rero‑vi. ");
INSERT INTO wmw_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Kwa javyo, ukitimiziwa usowezi waâsowere nabii Yeremiya, akamba: “Watwala nzuruku wa jarajara talatini wa parata, beyi yawataire wanu wa Iziraeli kuwa ndi beyi yake, ");
INSERT INTO wmw_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","wakimpa nfiyangi-viyungu kuuza naye uweru, kamba Mola vyaânamurire.” ");
INSERT INTO wmw_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Insa akimisiwa mbere ya guvinadoru, iye akindairi javi: “Uwe kuwa nfalume wa Mayahudi?” Insa akinjíbu: “Uwe ndi vyauri kwamba.” ");
INSERT INTO wmw_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Fala vyawansowerere wakulungwa wa dini pamoja na wazee ware, iye aajibire kinu. ");
INSERT INTO wmw_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Sambi Pilatu akindairi: “Ausikira vyawamba‑vi kuwa wankukusowerera nowe?” ");
INSERT INTO wmw_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Falakini Insa aanjibire anta kinu kimoja, guvinadoru akibaki wakushanga pakulu pawenye. ");
INSERT INTO wmw_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Sambi, íkiwa tabiya ya guvinadoru, ikifika suku ulu ya Pashukwa, wanu wakintondolanga nfungwa mmojawapo wawansaka onse afunguriwe. ");
INSERT INTO wmw_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Wákiwa nawo nfungwa mmoja wakwijiwikana pakulu sana ka ubaya, wakwitiwa Baraba. ");
INSERT INTO wmw_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Kwa javyo, wanu pawajumane pamoja, Pilatu akiwadairi javi: “Umwe wamunsaka afunguriwe ndi wepi‑pa? Baraba au Insa wakwitiwa Almasihi?” ");
INSERT INTO wmw_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Iye kejiwa kuwa wakulungwa wa Mayahudi wampereka Insa kwa sababu ya kuntendera wiyana. ");
INSERT INTO wmw_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Visitoshe, Pilatu ekare kiti cake cakulamula, nkawake akimperekera habari zakwamba: “Usiritaye na eyo munu wa shariya‑yo! Nitabika vinu vingi rero kwa kulota kwa sababu yake.” ");
INSERT INTO wmw_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Wakulungwa wa dini pamoja na wazee, wawashongezera wanu ware wanlebele anfungure Baraba, Insa aulaiwe. ");
INSERT INTO wmw_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Sambi, guvinadoru ire akiwadairi wanu ware: “Kati ya ewa wawiri‑wa, wamumpendeleya ninfungure ndi wepi?” Ewo wakinjibu “Baraba!” ");
INSERT INTO wmw_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Mwinsho Pilatu akiwambira: “Sambi Insa wakwitiwa Almasihi nintende mwaja?” Ewo piya wakijibu: “Agomezeriwe pansalaba!” ");
INSERT INTO wmw_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Iye akiwadairi: “Kakosa kinani noyu?” Falakini ewo wakizidi kunkuwira, wakamba: “Agomezeriwe pansalaba!” ");
INSERT INTO wmw_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Kwa javyo, Pilatu paawonire kuwa acipo cakukidiri tena ila shonge ya wanu ire ikizidi, basi akitwala maji, akinawa mmakono mbere ya wanu ware piya, akamba javi: “Omi‑pa sina kosa julu ya damu ya eyu munu‑yu. Eyo shauri yenu wanyewe.” ");
INSERT INTO wmw_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Wanu ware piya wakijibu: “Damu yake iwe julu yetu na wajukulwetu!” ");
INSERT INTO wmw_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Basi Pilatu akinfungula Baraba, akiwapa. Fala Insa, bandi ya kucapiwa, wakimpereka agomezeriwe pansalaba. ");
INSERT INTO wmw_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ikisa masurudadu wa Pilatu ware wakintwala Insa, wakimwingiza nnyumba ya kifalume, wakikusanyika piya masurudadu ware, wakinzunguriza. ");
INSERT INTO wmw_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Wakinvula nguwo, wakinfinika koti reundu. ");
INSERT INTO wmw_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Nakisa wakipakasa lemba ra miwa wakinvaza nkiswa, na nlanzi wakinsukuza nkono nriro. Wakitenga malundi mbere yake, wakinshupa, wakamba: “Mashikamu, nfalume wa Mayahudi!” ");
INSERT INTO wmw_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Wakinsunira mata, wakitwala nlanzi ure, wakimpanjira nkiswa. ");
INSERT INTO wmw_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Pawesire kunshupa, wakinvula koti reundu rire, wakinvaza nguwo zake zire, ikisa wankintwala, wakuka wakingomezera pansalaba. ");
INSERT INTO wmw_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Pawakuka munjira, wakisimanana naye mwananlume mmoja wakwitiwa Ansumani nKireni, wakinshurutisa asukure nsalaba wa Insa. ");
INSERT INTO wmw_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Pawafikire mahala pakwitiwa Gologota (mana ake “Mahala pa Gula ra Kiswa”), ");
INSERT INTO wmw_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","wakimpa vinyu yakusanganyiwa na nyongo, fala nakuyeza aasakire tena kunywa. ");
INSERT INTO wmw_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Nakungomezera pansalaba pare, wakitenda kura namuna yakwawanyirana nguwo zake zire. ");
INSERT INTO wmw_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ikisa wakikala kunnang'anizira paakiwa pare. ");
INSERT INTO wmw_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Pansalaba, julu ya kiswa cake, wakitula kibawo cakwandikiwa makosa ake a kuwa javi: “EYU NDI INSA, NFALUME WA MAYAHUDI.” ");
INSERT INTO wmw_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Wakiwapo visomi wawiri wakigomezeriwa naye pamoja, mmoja nkono nriro na mwengine nkono sonto. ");
INSERT INTO wmw_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Wanu wakipita onse wakintukana, wakintikinyira kiswa, ");
INSERT INTO wmw_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","wakamba: “Ló! Uwe ubondola na kujenga Nyumba Takatifu kwa muda wa suku natu basi, rivushe mwanyewe! Kweli-kwelini, kamba kuwa Mwana wa Mwenyezimungu, isuka pansalaba‑po!” ");
INSERT INTO wmw_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Wakulungwa wa dini pamoja na wanlimu wa shariya na wazee, newo novyo wakinshupa Insa, ");
INSERT INTO wmw_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","wakamba: “Kawavusha wenziwe, fala aakidiri kurivusha mwanyewe! Ngati nfalume wa Iziraeli! Aya sambi, esuke pansalaba‑po, timwamini! ");
INSERT INTO wmw_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Antumainingi Mwenyezimungu! Basi Mwenyezimungu akisaka, anvushe, konta kasema javi: ‘Omi niwa Mwana wa Mwenyezimungu.’ ” ");
INSERT INTO wmw_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Na visomi wagomezeriwe nawo pamoja ware, newo novyo wákintukana. ");
INSERT INTO wmw_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Mwanzo wa aduhuri mpaka alhanswiri, muinti mure piya kunja kukinukala pi! ");
INSERT INTO wmw_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Kiyasi ca ora ya kenda, Insa akikuwa pakulu, akamba: “Elohi, Elohi, lama sabakitani?” Mana ake, “Nlungu wangu, Nlungu wangu, sababuni kunasa?” ");
INSERT INTO wmw_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Sambi wengine wákiwa nopare ware, pawasikire javire, wamba: “Iye kankumwita Aliyasi.” ");
INSERT INTO wmw_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Kwa mpunde noure, munu mmoja akituwa, akitwala shiponja, akicoveka nvinagiri, akisomeka munlanzi, akimpa kunywa. ");
INSERT INTO wmw_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Fala wengine ware wakamba: “Mwase, tiwone kamba Aliyasi akuja kunvusha.” ");
INSERT INTO wmw_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Basi Insa akikuwa pakulu tena, noparepare akifwa. ");
INSERT INTO wmw_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Na pazira ya Nyumba Takatifu ikanyuka perr kati-kati vipande viwiri, kulawa julu mpaka pansi. Ardhi ikitetema na mawe makulu-makulu akatuka-atukanga bwa‑bwa‑bwa. ");
INSERT INTO wmw_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Makaburi akifunuka, miri mingi ya wanu watakatifu wâfwire, ikifufuriwa. ");
INSERT INTO wmw_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Airini, bandi ya kufufuka Insa, wâlawire mmakaburi ware, wakingira nKaya Takatifu, wakiwoniwa na wanu wengi wawenye. ");
INSERT INTO wmw_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Basi, masurudadu wamwikarire Insa ware pamoja na nkulungwa wawo, pawafahamire kutetema ka ardhi kure pamoja na vikunire vire piya, wopa pakulu futi, wakamba: “Kweli-kwelini eyu ákiwa Mwana wa Mwenyezimungu!” ");
INSERT INTO wmw_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Nopare mahala pare, wákiwapo wanawaka wengi wawenye, ewo wakiwona wari baidi. Ewo wânfulata Insa paakilawa Galileya, wakipita wakintumika. ");
INSERT INTO wmw_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Munkonjo ákiwapo Mariyamu Madalena, Mariyamu mwengine mamaye Yakobu na Yusufu, pamoja na mama yawo wana wa Zebedeyu. ");
INSERT INTO wmw_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Paifikire jironi, akija munu mmoja tajiri nkulu wa kaya ya Arimataya wakwitiwa Yusufu. Neye novyo ákiwa mwanafunzi wa Insa. ");
INSERT INTO wmw_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Nakufika karibu ya Pilatu, akinlebela apewe maiti a Insa are. Basi Pilatu ire akamuru apewe. ");
INSERT INTO wmw_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yusufu akitwala maiti are, akizingiriza kafani, ");
INSERT INTO wmw_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","akitula nkaburi rake ripya ratengeze njonga. Ikisa akipiringisira riwe rikulu panryango wa kaburi rire, akuka vyake. ");
INSERT INTO wmw_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ákiwepo nopare Mariyamu Madalena pamoja na Mariyamu mwengine wekala mbere ya kaburi. ");
INSERT INTO wmw_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Subuu yake, bandi ya ire suku yakutengeza sherehe, wakulungwa wa dini na Mafarizeu wakijumulana, wakuka ka Pilatu, ");
INSERT INTO wmw_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","wakimwambira: “Mwenye, tikumbukira kuwa nlongo ire ári hai kâsema javi: ‘Bandi ya suku natu, nifufuka.’ ");
INSERT INTO wmw_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Kwa javyo, lavya ámuri kaburi rake ririmbisiwe mpaka suku ya tatu, ipate wasije kuja wanafunzi wake kwiwa maiti ake are, ikisa wawambire wanu kuwa ‘Insa kafufuka ka wafwi!’ Ukuja kuwa ulongo wa mwinsho‑wu zaida wakwanza.” ");
INSERT INTO wmw_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilatu akiwambira javi: “Walavyeni masurudadu; muwapereke wakekarire kaburi‑ro vyamwijiwa vyonse.” ");
INSERT INTO wmw_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Basi ewo wakuka wakikarira na wakimatira riwe rire, na wakiwatenga masurudadu wakinang'anizira. ");
INSERT INTO wmw_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Bandi ya sabadu, pakucere suku yakwanza ya sumana, Mariyamu Madalena na mwanamuka mwengine wakwitiwa Mariyamu wakuka kuwona kukaburi rire. ");
INSERT INTO wmw_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Noparepare, citenda kitikansi pakulu sana, konta laika wa Mwenyezimungu kesuka kulawa binguni, akija akipingirisa riwe rire, akikarira. ");
INSERT INTO wmw_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Kuwoneka kwake akiwoneka kamba kumensa, na mavazi ake ákiwa melupa vú kamba bafuta. ");
INSERT INTO wmw_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Na wofi wawo masurudadu ware wakitetema, wákiwa kamba wafwire. ");
INSERT INTO wmw_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Falakini laika ire akiwambíra wanawaka ware: “Umwe musope! Konta nukwijiwa kuwa mwankunsakula Insa âgomezeriwe pansalaba ire. ");
INSERT INTO wmw_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Epa aapo, kafufuriwa kamba vyaâsemire mwanyewe. Njoni muwone mahala paâlaziwe. ");
INSERT INTO wmw_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ikisa ukani upesi, mukawambire wanafunzi wake kuwa kafufuriwa ka wafwi, nepa kalongorera Galileya. Eko ndi kamuka kummona. Epo nisa kukwambirani.” ");
INSERT INTO wmw_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Basi wanawaka ware wakilawa pakaburi pare upesi-upesi na wofi, kuno wakifurahi pakulu futi, wakituwa wakuka wakiwambira wanafunzi wake. ");
INSERT INTO wmw_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Kwa mpunde noure, Insa akisimanana nawo, akiwambira: “Salama!” Newo wakinfika karibu, wakinkola maulu, wakintukuza. ");
INSERT INTO wmw_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ikisa Insa akiwambira: “Musope! Ukani mukawambire wanduzangu woke Galileya, noko waniwona.” ");
INSERT INTO wmw_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Wanawaka pawokire vyawo, sambi walawa masurudadu woka mpaka nkaya mure, wawambira wakulungwa wa dini piya vikunire vire. ");
INSERT INTO wmw_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Basi, wakulungwa ware wakijumana pamoja na wazee wakitenda mpango, wakiwapa masurudadu ware nzuruku mwingi wawenye, ");
INSERT INTO wmw_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","wakiwambira: “Semani javi: ‘Wanafunzi wake waja usiku wakimwiwa, ofwe tilarire.’ ");
INSERT INTO wmw_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Guvinadoru, akisikira mwaha‑wu, ofwe tisowera naye, tukulavyani wasi-wasi.” ");
INSERT INTO wmw_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ewo nakutwala nzuruku ure, wakitenda kamba vyawafundiwe. Habari ire ikenera piya nkati ya Mayahudi mpaka rero. ");
INSERT INTO wmw_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Sambi, wanafunzi kumi na mmoja ware walawa woka Galileya, pamwango paâwalaizire Insa. ");
INSERT INTO wmw_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Pawammonire wakintukuza, iri kuwa wengine wákiwa na dana. ");
INSERT INTO wmw_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Insa akiwafika karibu, akiwambira javi: “Piya mamulaka a mbinguni na a duniya nipewa omi! ");
INSERT INTO wmw_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Basi ukani kabila piya, mukawatende wawe wanafunzi wangu, wozeni kwa zina ra Baba na Mwana pamoja na Roho Takatifu. ");
INSERT INTO wmw_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Wafundeni wafulate piya vinu vyanukwamurireni. Kweli, omi niwa pamoja nomwe suku piya, mpaka mwinsho wa ulumwengu!”");
INSERT INTO wmw_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Epa ndi payanza Habari Ngema ya Insa Almasihi. ");
INSERT INTO wmw_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Kamba vyavyândikiwe nkitabu ca nabii Izaya, kuwa javi: “Ona, mbere yako nimpereka shikarakanzi wangu, ája kutengeza njira yako. ");
INSERT INTO wmw_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Iye ndi shauti iri kukuwa nlanga, ikamba: ‘Tengezani njira ya Mola, molosereni njira yake.’ ” ");
INSERT INTO wmw_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Shikarakanzi wawenye ndi Yahaya mwenyé Koza. Kaja, kankuwoza wanu kulanga na kankusema kuwa wanu wajuzi woziwe wolote kuwa watubiya, ipate waswamiiwe madambi awo. ");
INSERT INTO wmw_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Wanu piya wa makaya a Yudeya na wanu piya wa Yerusalemu wakuka ka iye, wakoziwa mmuto wa Yordani, wakitubiya madambi awo. ");
INSERT INTO wmw_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yahaya ákivalanga nguwo zakupakasiwa na mabururu a ngamiya, na ákirifunganga nkiuno ukanda wa sambala. Cakurya cake cíkiwa mazorombe na ansali. ");
INSERT INTO wmw_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Iye akihubiri, akamba: “Kankuja nyuma yangu omi ári nawo uwezo pakulu koliko omi, anta omi sifãi kwinama kufungula mzizi ya viratu vyake. ");
INSERT INTO wmw_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Omi nukozani kwa maji fala iye akuja kukozani kwa Roho Takatifu.” ");
INSERT INTO wmw_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Nozire suku zire, Insa akija kulawa Nazareti ya Galileya, nneye akoziwa na Yahaya mmuto wa Yordani. ");
INSERT INTO wmw_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Insa, nakulawa mmaji mure, kawona binguni ifunguka, na Roho Takatifu akimwisukira kamba pomba. ");
INSERT INTO wmw_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Na ikisikirikana shauti kulawa binguni ikamba: “Uwe ndi mwanangu wanukupenda, niwa radi nawe pakulu.” ");
INSERT INTO wmw_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Mpunde sinkulu, Roho Takatifu kampereka kulanga. ");
INSERT INTO wmw_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ákiwa kulanga suku arubaini, akishetwaniwa na Ibilisi. Iye ekáre kati-kati ya manyama wa nnundu, kuno wakimmudumu malaika. ");
INSERT INTO wmw_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Bandi ya Yahaya kufungiwa na nfalume Herodi, Insa akúka Galileya, akereza Habari Ngema ya Mwenyezimungu, ");
INSERT INTO wmw_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","akamba: “Wakati ufika! Ufalume wa Mwenyezimungu uwa karibu. Tubiyani na pokererani eyi Habari Ngema‑yi.” ");
INSERT INTO wmw_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Insa, paakipita nanyenje ya tanda ra Galileya, kawawona mmaji Ansumani na Andere nduye Ansumani, wakitaya nyavu kamana wákiwa wavuvi. ");
INSERT INTO wmw_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Insa akiwambira javi: “Njoni munifulate, omi nukutendani kuwa wavuvi wakuwavuwa wanu.” ");
INSERT INTO wmw_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Kwa mpunde noure, nakwasa nyavu zire, wakinfulata. ");
INSERT INTO wmw_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Wenenda kitambo aba, Insa kawawona mungalawa Yakobu mwana wa Zebedeyu na Yahaya nduye Yakobu wakiwanza nyavu zawo. ");
INSERT INTO wmw_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Mpunde noure akiweta, ewo wakimwasa Zebedeyu wawa yawo mungalawa nomure pamoja na wakazi wengine, wakinfulata Insa. ");
INSERT INTO wmw_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Insa pamoja na wanafunzi wake wakuka kaya ulu ya Kafarnaumu, na kila sabadu Insa ákukanga nsinagoga ya Mayahudi, ákiwafundanga wanu. ");
INSERT INTO wmw_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ewo wákitajabu pakulu sana kwa sababu ya kufunda kwake, kamana ákiwafunda vyaafunda munu mwenyé mamulaka, sairi vyawafunda wanlimu wa shariya. ");
INSERT INTO wmw_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Kwa suku‑yo, akifika nsinagoga munu wakumilikiwa na jini. Iye akanza kukuwa, ");
INSERT INTO wmw_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","akamba: “Insa nNazareti, utisakurira kinani? Kuja kutifuja? Omi núkwijiwa cauri, kuwa Takatifu wa Mwenyezimungu!” ");
INSERT INTO wmw_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Insa akinsutumu jini ire, akimwambira: “Nyamala nduu! Nlawe munu‑yu.” ");
INSERT INTO wmw_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Na jini ire akingwisa munu ire caputu pakulu, akikuwa na shauti ulu, ikisa akinlawa munu ire. ");
INSERT INTO wmw_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Wanu piya watajabu pakulu sana, wakidairiyana watupu: “Kinu‑ci kinani? Kufunda kupya ka mamulaka? Awamuru mashetwani na majini, newo wansikiriza!” ");
INSERT INTO wmw_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Habari za mambo yaatendire Insa, kwa mpunde noure asikirikana makaya piya a Galileya. ");
INSERT INTO wmw_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Insa na wanafunzi wake, nakulawa nsinagoga mure, wakuka kunyumba ya Ansumani na Andere. Yakobu pamoja na Yahaya newo novyo wákiwa noko. ");
INSERT INTO wmw_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Nkwewe Ansumani karitandikira, ákiwa na homa. Kwa mpunde noure, ewo wakimwambira Insa kuhusu mwanamuka nlwere ire. ");
INSERT INTO wmw_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Iye akinfika karibu, akinkola nkono, akimwinula. Na homa ire ikimpita, mwanamuka ire akanza kuwahudumu. ");
INSERT INTO wmw_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Jironi parikitita juwa, wakuka nawo ka Insa piya wenye kuwa na mashetwani. ");
INSERT INTO wmw_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Na piya wanu wa kaya ire wakijumana panryango. ");
INSERT INTO wmw_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Basi, Insa akiwaponesa wanu wengi wa shida jisijisi, na akiwatuwisa mashetwani wengi. Iye aakiwasa mashetwani kusowera konta wakimwijiwa. ");
INSERT INTO wmw_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Subuu yake, Insa akilamuka alufajiri, akilawa nkaya mure, akúka mahala sapana wanu, akilebela duwa nopo. ");
INSERT INTO wmw_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ansumani pamoja na wenziwe wakilawa kupita wakinsakula. Nakunsingana, wamwambira javi: ");
INSERT INTO wmw_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","“Wanu piya wankukusakula!” ");
INSERT INTO wmw_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Fala Insa akiwajibu: “Tukeni mahala kwengine makaya mengine jirani ipate noko nikereze, konta noco omi ndi canijirire.” ");
INSERT INTO wmw_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Basi, akipita akereza Habari Ngema mmasinagoga mwawo na makaya piya a Galileya, na akiwatuwisa mashetwani. ");
INSERT INTO wmw_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Suku moja, kaja ka Insa munu mmoja camagundula, akinlebela na akikokora mbere yake, akimwambira: “Ukisaka, kwanawo uwezo wa kuniponesa.” ");
INSERT INTO wmw_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Neye akimmonera utungu, akolosa nkono wake akinkumbula, akimwambira: “Nisaka, swafika!” ");
INSERT INTO wmw_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Kwa mpunde noure, magundula are akimpakatika, munu ire akipona. ");
INSERT INTO wmw_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Akinlaizira pakulu, akintuwisa, ");
INSERT INTO wmw_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","akimwambira: “Sikiriza! Usimwambire munu kinu. Ila ukarolote ka nlongozi wa dini, kapereke swadaka kamba vyayamba shariya ya Musa kwa kuswafika kwako uwé ushahidi kwawo.” ");
INSERT INTO wmw_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Fala nakulawa, camagundula ire akanza kutangaza, akeneza habari zire mpaka Insa aakidirire kwingira nkaya mure baina, fala kekala kunyenje mahala palanga. Wanu wakilawa kila upande wakimukira noko. ");
INSERT INTO wmw_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Paaludire tena Kafarnaumu, bandi ya suku aba, wanu wakipata habari kuwa kawapo nnyumba mwake. ");
INSERT INTO wmw_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Wanu wengi wakijumana tapa-tapa, anta panryango aíkiwepo nafasi. Noparepare, Insa akikola kuwereza usemi wa Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ikisa waja wanu wane wansukula kitewe mmashila. ");
INSERT INTO wmw_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Kwa kuwa awakikidiri kunfikisa paákiwa pare konta ya wanu, wakikwera papala wakitolola nopare paákiwa pare. Ikisa wakiteremusa mashila atandikiriwe kitewe ire. ");
INSERT INTO wmw_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Insa paawawonire wanu ware kuwa wantumaini iye, neye akimwambira nlwere ire javi: “Mwanangu, madambi ako aswamiiwa.” ");
INSERT INTO wmw_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Na wákiwapo nopare wanlimu wa shariya wékala. Ewo wakiwaza mmyoyo mwawo, wakamba: ");
INSERT INTO wmw_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Mbana asowera javi? Kakukufuru! Nani ari nawo mamulaka kuswamii madambi sairi Mwenyezimungu tu basi?” ");
INSERT INTO wmw_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Mpunde noure, pejiwe Insa cawari kuwaza mmyoyo mwawo, akiwambira: “Sababuni umwe kuwaza javyo mmyoyo mwenu? ");
INSERT INTO wmw_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Kumwambira kitewe‑yu javi: ‘Madambi ako aswamiiwa’ au kumwambira: ‘Lamuka, usukure mashila ako, uke vyako’, sacirigariga ndi cepi? ");
INSERT INTO wmw_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Fala nukoloterani kuwa Binadamu wa Binguni kanawo mamulaka a kuswamii madambi mulumwengu‑mu.” Ndimana, kamwambira kitewe ire javi: ");
INSERT INTO wmw_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Uwe nukwambira: lamuka, usukure mashila ako, uke vyako ukaya.” ");
INSERT INTO wmw_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Neye akilamuka, kwa mpunde noure, akitwala mashila ake are, akilawa, wanu wakimmona javi. Wanu piya wakishanga, wakintukuza Mwenyezimungu, wakamba: “Tangu evi atinamba kuwona javi!” ");
INSERT INTO wmw_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Sambi, Insa akilawa tena, akuka nanyenje ya tanda ra Galileya. Wanu wengi wawenye wakinfulata noko, neye akikola kuwafunda. ");
INSERT INTO wmw_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Paakuka nakupita, Insa kammona Lawi mwana wa Alufeu, ekare mahala pakiripisiwanga nsoko. Iye akimwambira: “Nifulate!” Iye akilamuka akinfulata. ");
INSERT INTO wmw_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ikisa, wakati mwengine, Insa pekare akirya nnyumba mwa Lawi‑yu, wákiwapo wakirya naye pamoja na wanafunzi wake, warípisi nsoko wengi na wamádambi wengine. Kusema kweli, awakifulatiwa na wanu wengi. ");
INSERT INTO wmw_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Sambi, wanlimu wa shariya wa kundi ra Mafarizeu, pawammonire kuwa kankurya na wamádambi pamoja na warípisi nsoko, wakiwadairi wanafunzi wake: “Sababuni kwikala na warípisi nsoko na wamádambi wengine kurya nawo?” ");
INSERT INTO wmw_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Insa, nakusikira, akiwajibu: “Wakomu awashugulika na dotoru, ila walwere. Onani, sijire kuwarifu wenye shariya wawe wanafunzi wangu, ila wamádambi.” ");
INSERT INTO wmw_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Sambi, wanafunzi wa Yahaya mwenyé Koza na Mafarizeu wákiwa na tabiya ya kufunga. Suku moja, wanu wengine wakija ka Insa, wakindairi: “Wanafunzi wa Yahaya pamoja na Mafarizeu wafunga, fala wanafunzi wako‑wa awafunga. Sababuni?” ");
INSERT INTO wmw_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Insa akiwajibu javi: “Warifiwe paharusi wari pamoja na mwenye-harusi, wafungaja? Mwenye-harusi akiwa pamoja nawo awajúzi kufunga. ");
INSERT INTO wmw_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Fala ikuja kufika suku yakulaviwa mwenye-harusi‑yo. Basi noyo suku‑yo wakuja kufunga. ");
INSERT INTO wmw_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Aapo atáya kipande ca nguwo yagoma munguwo ya mida, kamana kipande kipya‑co cipapula nguwo ya mida, izidi kupapuka pakulu. ");
INSERT INTO wmw_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Aapo munu atwala maji a kazu saanasemuka kutairira nnumba zakumiliya. Konta numba‑zo zikipanjika, maji‑yo atawanyika, na numba‑zo zikwaribika. Kwa javyo maji‑yo saanasemuka, tayani nnumba nyipya.” ");
INSERT INTO wmw_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Iwa suku moja, sabadu, Insa na wanafunzi wake wakipita nanyenje ya masamba a tirigu. Wanafunzi ware wakanza kuvunja masuke are watafune. ");
INSERT INTO wmw_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Mafarizeu wakiwambira: “Ona, wanafunzi wako mbana watenda vinu savijuzi kutendiwa suku ya sabadu?” ");
INSERT INTO wmw_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Fala Insa akiwajibu: “Amufyomire nkati ya Mandiko vyaatendire Daudi painkorire njala pamoja na wenziwe? ");
INSERT INTO wmw_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Vyengire nNyumba ya Mwenyezimungu wakati Abiyatari wâwere nkulu wa wakulungwa wa dini. Katafuna mikate maalumu, yawákiwa nawo haki kutafuna walongozi wa dini tu basi. Ikisa mikate myengine akiwatongera wenziwe.” ");
INSERT INTO wmw_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ikisa Insa akiwambira: “Wanu awombiwe kwa ajili ya sabadu, ila suku ya sabadu itendiwa kwa ajili ya wanu. ");
INSERT INTO wmw_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Basi, Binadamu wa Binguni ndi Mwenye wa sababu.” ");
INSERT INTO wmw_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Sabadu nyengine, Insa akingira tena nsinagoga, nomure ákiwapo munu wakuremala nkono. ");
INSERT INTO wmw_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Maaduwi wa Insa ware wakintunza sana-sana wammone kuwa amponesa suku ya sabadu ipate wanlaumu. ");
INSERT INTO wmw_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Noparepare iye akimwambira mwananlume wakuremala nkono ire javi: “Lamuka, uje kati‑pa.” ");
INSERT INTO wmw_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ikisa piya ware akiwadairi javi: “Ihusu suku ya sabadu kutenda meema au mabaya? Kuvusha mainsha au kuulaya?” Fala ewo wakinyamala. ");
INSERT INTO wmw_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Insa akiwanang'aniza upande piya rungu-rungu akimiwe, akiuzunika kwa ajili ya myoyo yawo kuwa migumu. Ikisa akimwambira nlwere ire javi: “Olosa nkono‑wo.” Iye akolosa, akiponesiwa nkono wake ure. ");
INSERT INTO wmw_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Wakilawa Mafarizeu wakuka wakisowera na kinya Herodi. Wakijumana kuwazisana vyakumulaya Insa. ");
INSERT INTO wmw_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Insa pamoja na wanafunzi wake wakilawa, wakuka kutanda ra Galileya. Wanu wengi wakinfulata, wanu wakulawa Galileya, Yudeya, ");
INSERT INTO wmw_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Yerusalemu, Idumeya, ng'ambu nyengine ya Yordani, upande wa Tiru pamoja na Sidoni. Wanu wengi wasikire vinu vyaakitenda, waja kummona. ");
INSERT INTO wmw_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Insa akiwambira wanafunzi wake wanvutire karibu yake ngalawa mmoja ipate wanu wasinkinye konta wákiwa wengi. ");
INSERT INTO wmw_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Kweli, wanu wengi wawenye kâwaponesa, ndimana walwere piya wakimwirukira Insa wapate kunkumbula. ");
INSERT INTO wmw_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Mashetwani, pawakimmona ponse, wakigwa mbere yake, wakikuwa wakamba: “Uwe kuwa Mwana wa Mwenyezimungu!” ");
INSERT INTO wmw_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Iye akiwashurutisa pakulu kuwa wasimwambire munu iye caari. ");
INSERT INTO wmw_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ikisa Insa akikwera mmwango, akiweta ware waawasakire iye mwanyewe. Newo wakija ka Insa. ");
INSERT INTO wmw_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Basi, iye akiwatondola wanu kumi na wawiri (ewo kaweta mawalii) awe nawo, awatume wakereze Habari Ngema, ");
INSERT INTO wmw_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","na wawe nawo mamulaka akuwatuwisa mashetwani. ");
INSERT INTO wmw_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Wanu kumi na wawiri waâwatondore ndiwa: Ansumani (wantapire zina ra Peduru), ");
INSERT INTO wmw_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yakobu mwana wa Zebedeyu, Yahaya nduye Yakobu wantapire zina ra Boanerge (mana ake “wana wa kudidima”), ");
INSERT INTO wmw_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andere, Filipi, Bartolomeu, Matwaya, Tamimu, Yakobu (mwana wa Alufeu), Tadeu, Ansumani nKanaa, ");
INSERT INTO wmw_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","pamoja na Yuda Shikariyoti anzungunuke Insa. ");
INSERT INTO wmw_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Paaludire ukaya, wanu wengi wakijumana tena, awakipata anta nafasi ya kurya. ");
INSERT INTO wmw_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jamaa zake pawasikire, wakilawa kuka kunkola, kamana wengine wakamba: “Ankili zimpoteya!” ");
INSERT INTO wmw_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Wanlimu wa shariya wa Yerusalemu pawajire, wakamba: “Kanawo Belzebuli. Awatuwisa mashetwani julu ya uwezo wa nkulu wa mashetwani.” ");
INSERT INTO wmw_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Sambi, Insa akiweta wanu, akikola kusowera nawo kwa vinyume, akiwadairi: “Shetwani antuwisa shetwani mwenziwe mwaja? ");
INSERT INTO wmw_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kila ufalume wakwawanyika makundi akubishana watupu, auinshi. ");
INSERT INTO wmw_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Nyumba ikirawanya aiinshi. ");
INSERT INTO wmw_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ona, inawa Ibilisi aritendera vita mwanyewe kurawanya, singari kainshi, nanga uwa mwinsho wake. ");
INSERT INTO wmw_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Aapo munu akidiri kwingira nnyumba ya munu wakurimba, kumwiwira vinu vyake sairi kwanza anfunga mwenyé nguvu‑yo. Ikisa amwiwire sana nnyumba mwake. ");
INSERT INTO wmw_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Nukwambirani kuwa piya viswamiiwa ka wanadamu, madambi anta na kufuru zawakufuru wanu. ");
INSERT INTO wmw_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Fala akufurira Roho Takatifu, aashubutu kuswamiiwa, fala akuwa na madambi a milele.” ");
INSERT INTO wmw_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Insa kaamba javire kwa kuwa wakamba, “Kanawo mashetwani.” ");
INSERT INTO wmw_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Kwa suku‑yo, wakija mamaye na wanduze Insa wakimira panja, wakintuma munu kumwita. ");
INSERT INTO wmw_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Neye kekala na wanu wengi wawenye wânzunguriza, wakimwambira: “Ona! Mamayo, wanduzo, na walumbuzo wawa panja pare, wankukusakula.” ");
INSERT INTO wmw_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Iye akiwajibu: “Mama ndi wepi? Na wanduzangu ndi wepi?” ");
INSERT INTO wmw_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Basi, iye akizungunuka akiwanang'aniza wekare wanzungurize ware, akiwambira: “Wawoneni! Ewa‑pa ndi mama na ndi wanduzangu. ");
INSERT INTO wmw_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Kamana ire aténda vyaasaka Mwenyezimungu, noyo ndi nduyangu na nlumbwangu na mama.” ");
INSERT INTO wmw_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Mara nyengine tena, Insa akanza kufunda nanyenje ya tanda. Wanu wengi wawenye wajumana karibu yake. Kwa javyo, iye akingira mungalawa, akikala mbahari. Piya wanu wákiwa nanyenje karibu ya maji. ");
INSERT INTO wmw_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Iye akiwafunda wanu vinu vingi kwa mifano ya kinyume. Nkati ya kuwafunda kwake, ákiwambira javi: ");
INSERT INTO wmw_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Sikirizani! Mwananlume kalawa koka kuvyala masamba. ");
INSERT INTO wmw_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Paakimwaya mbeyu ire, nyengine igwirira munjira, zija nyuni zilokota. ");
INSERT INTO wmw_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Nyengine igwirira mmawe, mahala samuna nsanga mwingi. Mpunde noure ilawa senge, kwa kuwa auwerepo nsanga. ");
INSERT INTO wmw_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Pariwarire juwa senge ire ilungula. Kwa kuwa mizipe aiwere yamana, yumiliya. ");
INSERT INTO wmw_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Mbeyu nyengine igwirira kati ya miwa. Miwa ire ikula, ikinya mbeyu ire. Ntamana aipere. ");
INSERT INTO wmw_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Nyengine igwirira munsanga warutuba. Ikula, inuru na ípa visumo, muti mmoja talatini, mwengine sitini na mwengine visumo miya.” ");
INSERT INTO wmw_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Mwinsho kaamba: “Ári na masikiro a kusikira, asikire!” ");
INSERT INTO wmw_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Wanu wengi pawokire vyawo, wengine wakinzunguriza pamoja na wanafunzi kumi na wawiri ware, wakindairi kinani cinsowerese kinyume cire. ");
INSERT INTO wmw_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Insa akiwajibu: “Umwe mwijiwisiwa siiri ya ufalume wa Mwenyezimungu. Fala ka wanu wengine wa panja, vinu piya wafundiwa kwa kinyume. ");
INSERT INTO wmw_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ndi kamba vyaasema Mandiko, kuwa javi: ‘Kunang'aniza wanang'aniza fala awawona kusikira, wasikira fala awereriwa. Wasije kongoka wakipata kuswamiiwa.’ ” ");
INSERT INTO wmw_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Insa kawambira, kaamba: “Amwereriwa na mana a eci kinyume‑ci? Sambi vinyume piya, musaka kwereriwaja? ");
INSERT INTO wmw_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Nvyari ndi ire ereza Habari Ngema. ");
INSERT INTO wmw_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Nanyenje ya njira mana ake ndi wanu wasikira usemi uvyariwe ure, nakusikira mpunde-sinkulu akuja Ibilisi awalavya habari yawavyariwe ire. ");
INSERT INTO wmw_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Na ewa ndi mbeyu ivyariwe mmawe, ndi wanu wasikíra usemi, mpunde nowo wapokerera ka radi, ");
INSERT INTO wmw_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","fala awana nzipe wawo wanyewe, wainshi nawo suku aba. Ikija tafauti au kulumbatiwa kwa sababu ya usemi wa Mwenyezimungu, mpunde nowo wabugudika. ");
INSERT INTO wmw_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Na wengine mbeyu ivyariwe mmiwa, ewa ndi wasikira usemi, ");
INSERT INTO wmw_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","fala kwa tafauti za enzi‑zi na wájibu wakupata mali na vinu vyengine, vikimwingira vikinya usemi ure, aupa visumo. ");
INSERT INTO wmw_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Na ware wavyariwe munsanga warutuba, mana ake ndi wasikíra usemi wa Mwenyezimungu, wapokerera na wakupa visumo talatini, au sitini au miya.” ");
INSERT INTO wmw_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ikisa Insa akiwadairi: “Kandiyeru ikikoreziwa itaiwa nkati ya tamboru au ituriwa mwivungu? Níkamba ikwangikiwa paarami imwarike sana. ");
INSERT INTO wmw_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kusema kweli, acipo kinu cakufisiwa sacifisuriwa. Aipo siiri sailawira panja. ");
INSERT INTO wmw_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ári na masikiro a kusikira, asikire!” ");
INSERT INTO wmw_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Akiwambira tena: “Tunzani camuri kusikira‑ci. Kipimo camupimira nomwe mupimiriwa noco na mukongeziwa. ");
INSERT INTO wmw_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kamana ári nawo, azidi kupewa. Fala saana, anta aba caari nawo noco, anyang'anyiwa.” ");
INSERT INTO wmw_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Insa akamba tena: “Ufalume wa Mwenyezimungu ulandana na munu vyaavyala mbeyu pansi. ");
INSERT INTO wmw_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Akilala usiku, nsana akilawa, kuno mbeyu ire ikiwota na ikikula, iye sejiwa. ");
INSERT INTO wmw_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ardhi iruwerya visumo wanyewe: cakwanza ulawa nnyani, ikisa suke, mwinsho wa suke ulawa mpunga. ");
INSERT INTO wmw_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Mbeyu wakati waitokota, mpunde nowo munu akwanza kusinja kamana mavuno afika.” ");
INSERT INTO wmw_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Insa akiwambira: “Kinani canisaka kulandanisa ufalume wa Mwenyezimungu? Ulandana na nfanoni? ");
INSERT INTO wmw_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ulandana na mbeyu ya mostarda paivyariwa pansi, ikuwa mbeyu noto javi. Ingawa mbeyu noto pakulu koliko mbeyu piya, ");
INSERT INTO wmw_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","fala ikivyariwa pansi, ulawirira nrayi, úkula upunda mirayi piya. Ukuwa na vitambi vikulu, anta nviri wake nyuni zakwiruka julu zijenga vitundu nomo.” ");
INSERT INTO wmw_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Na kwa kinyume cingi kamba noco, iye ákiwasowerera usowezi vyakujuzi ewo kupata kusikira. ");
INSERT INTO wmw_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Bila usowezi wa kinyume aakisowera nawo. Fala paákiwa yeka ponse na wanafunzi wake, iye akiwereza mana awo kinyume caasowere cire. ");
INSERT INTO wmw_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Noire suku ire jironi, Insa kawambira wanafunzi javi: “Tukeni tilokere ng'ambu nyengine ire.” ");
INSERT INTO wmw_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Bandi ya kulayana na wanu wengi, ewo wakingira mungalawa mwákiwa mure, wakuka. Zikiwepo ngalawa nyengine nopo. ");
INSERT INTO wmw_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Rikija gaibu rikulu, mawimbi makulu-makulu akikola kupanja ngalawa ire, anta maji akanza kwingira mungalawa mure. ");
INSERT INTO wmw_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Na kumbe Insa ákilala pasitiri, kênyamira nsawo. Wanafunzi ware wakinlamusa, wakimwambira: “Mwanlimu, tankufwa, mbana avikuyeri?” ");
INSERT INTO wmw_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Noparepare akilamuka, akamuru mepo na maluwimbi, akamba: “Kutengemane, mepo inyamare!” Na mepo ire ikinyamala, kukitenda shuwari dembwe. ");
INSERT INTO wmw_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Iye akiwadairi: “Mbana muwa wofi pakulu? Amunamba kwamini?” ");
INSERT INTO wmw_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ewo wakopa pakulu futi, wakambirana watupu: “Noyu mwananlume wakuwa anta mepo na maluwimbi vinsikiriza‑yu, nani?” ");
INSERT INTO wmw_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Insa na wanafunzi wake wakifika ng'ambu nyengine ya tanda, inti yawákikalanga waGerasi. ");
INSERT INTO wmw_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Insa nakwisuka mungalawa mure, mpunde nowo kasimanana na mwananlume wakumilikiwa na jini, ákilawa kumakaburi. ");
INSERT INTO wmw_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Noyo mwananlume‑yo ákikalanga kumakaburi, ákiwa na nguvu, anta na unyolo hapana akikidiri kunfunga. ");
INSERT INTO wmw_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Mara nyingi zawenye, wanu wakinfunga na alucema pamoja na unyolo, fala iye akitupula alucema na unyolo akisayasayanga. Aawerepo munu wanguvu wakunzaidi iye. ");
INSERT INTO wmw_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Daima usiku na nsana kumakaburi na kumyango, akinyangulanga kuno akirisinja mwanyewe. ");
INSERT INTO wmw_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Kwa suku‑yo, akimmona Insa kitambo, akintuwirira akisujudi. ");
INSERT INTO wmw_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ikisa akikuwa pakulu akamba: “Insa, Mwana wa Mwenyezimungu Nkulu, usaka unitende kinani? Nukulebela, kwa zina ra Mwenyezimungu, usinopepese.” ");
INSERT INTO wmw_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Konta kâmwambira javi: “Uwe jini, nlawe eyu munu‑yu!” ");
INSERT INTO wmw_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ikisa Insa akindairi jini ire: “Ukwitiwa mwaja?” Iye akijibu: “Nikwitiwa ‘Junudi’, konta tiwa wengi.” ");
INSERT INTO wmw_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Iye akinlebela Insa pakulu kuwa asintuwise ire inti ire. ");
INSERT INTO wmw_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Karibu nopare úkiwapo mwango na nkonjo wa nguluwe nyingi zawenye zikirya nopare. ");
INSERT INTO wmw_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Mashetwani ware wakinlebela Insa: “Tipereke kunguluwe kure tikawengire.” ");
INSERT INTO wmw_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Iye akiwetikizira, mashetwani ware wakinlawa mwananlume ire, wakuka wakingira nguluwe zire. Ikisa, piya zire zikituwa zikicubukira ntanda, kiyasi ca nguluwe alufu mbiri zigwirira ntanda. ");
INSERT INTO wmw_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Wasunga wakituwa wakuka ukaya wakereza habari zire. Nkaya mure na mmamasamba wakilawa wanu wakuka kuwona vikunire vire. ");
INSERT INTO wmw_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Wakija ka Insa, wammona mwananlume âpatiwe na mashetwani ire kekala, avarire nguwo sana-sana, ári na ankili zake. Basi ewo ukiwapata wofi pakulu futi. ");
INSERT INTO wmw_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Wawonire vinkunire vire, wakikola kuwereza vinkunire mwananlume wa mashetwani ire na nguluwe zire. ");
INSERT INTO wmw_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Wakanza kunlebela Insa alawe nkaya mwawo mure. ");
INSERT INTO wmw_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Insa paakiripakira mungalawa, munu âpatiwe na mashetwani ire akinlebela woke onse. ");
INSERT INTO wmw_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Fala Insa ampere rihusa, akimwambira: “Uka kawári wanu wa kwenu, ukawereze mambo akuténdere Mwenye na vyakuwonere utungu!” ");
INSERT INTO wmw_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Na kweli, iye akúka vyake, akanza kwereza kaya ya Dekapoli mambo makulu atendériwe na Insa. Basi, wanu piya wakitajabu. ");
INSERT INTO wmw_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Insa pengire tena mungalawa akuka upande mwengine wa tanda. Nakufika nanyenje ya tanda rire, junudi ya wanu wakijumana karibu yake. ");
INSERT INTO wmw_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Akija munu mmoja nkati ya wakulungwa wa sinagoga wakitiwa Yairu. Nakummona Insa, akisujudi, ");
INSERT INTO wmw_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","akintafadali pakulu, akamba: “Mwanangu kankufwa. Njo, unture makono ipate apone, ainshi!” ");
INSERT INTO wmw_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Insa akilawa naye. Wanu wengi wawenye wakinfulata, wakinkinya kila upande. ");
INSERT INTO wmw_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ákiwapo mwanamuka nlwere mbobo muda wa myaka kumi na miwiri. ");
INSERT INTO wmw_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Iye katabika pakulu kuritibisa mmatabibu wengi wawenye. Kapoteza vyaákiwa nawo piya kuwaripa mafundi, fala aapatire fuweni, ulwere ukinzidi. ");
INSERT INTO wmw_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Nakuka, paasikire kuhusu Insa, akija nyuma ya wanu ware, akinkumbula anzu yake. ");
INSERT INTO wmw_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Konta akamba kimoyomoyo javi: “Omi nikiwayi kukumbula lupindo ra anzu yake, nípona.” ");
INSERT INTO wmw_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Kwa mpunde noure, kububuka ka damu kure kukinyamala, neye akifahamu mmwiri mwake kuwa kaponesiwa ulwere ure. ");
INSERT INTO wmw_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Insa, mpunde noure, kafahamu neye kuwa uwezo wakuponesa unlawa mmwiri mwake, akiwanang'aniza wanu nyuma, akamba: “Akumbure anzu yangu nani?” ");
INSERT INTO wmw_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Wanafunzi wake wakimwambira: “Kwankuwawona wanu‑wa wakukinya! Udairija nani akukumbure?” ");
INSERT INTO wmw_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Iye akinang'aniza kuno na kuno ammone nani ankumbure. ");
INSERT INTO wmw_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Kwa javyo, mwanamuka ire, akopa kuno akitetema, kejiwa cinkunire. Akimukira Insa, akingwirira mbere yake, akimwambira piya ukweli. ");
INSERT INTO wmw_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Basi, iye akimwambira: “Nunu, kwamini kwako kukuvusha. Uka kwa salama. Uwe nkomu, usiwe nlwere tena.” ");
INSERT INTO wmw_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Insa kuno akisowera, wakifika wanu kulawa kunyumba ya nkulungwa wa sinagoga, wakimwambira: “Mwanawo kafwa. Unshumbuwirani mwanlimu‑yu?” ");
INSERT INTO wmw_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Fala Insa azimmwerire habari zire, akimwambira nkulungwa wa sinagoga ire: “Usisusuke, nitumaini omi tu basi.” ");
INSERT INTO wmw_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Fala iye aalavire rihusa kunfulata munu mwengine ila Peduru, Yakobu na Yahaya nduye Yakobu. ");
INSERT INTO wmw_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Wakuka wakifika kunyumba ya nkulungwa wa sinagoga ire. Insa kawona geshi za wanu, wengine wankurira pakulu-pakulu, kuno wengine wakirondongola. ");
INSERT INTO wmw_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Iye nakwingira, akiwambira javi: “Sababuni kutenda geshi kuno mukirira? Mwari‑yo aafwire, kankulala.” ");
INSERT INTO wmw_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Wanu ware wakinkejeli, fala iye akiwalavira panja piya ware. Ikisa, akintwala wawaye pamoja na mamaye mwari ire, na wanafunzi wake waalongozane nawo, wakingira mwaákiwa mwari ire. ");
INSERT INTO wmw_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Akinkola nkono mwari ire, akimwambira: “Talita, kumi”, mana ake “Mwari, nukwambira, lamuka!” ");
INSERT INTO wmw_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Kwa mpunde noure, mwari ire akilamuka, akanza kwenenda! Ku! Iye ákiwa na hirimu ya myaka kumi na miwiri. Basi, wanu ware wakitajabu pakulu futi. ");
INSERT INTO wmw_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Insa akiwamuru akiwalaizira pakulu kuwa wasimwambire munu vikunire vire. Novyo akiwambira wampe mwari ire cakurya arye. ");
INSERT INTO wmw_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Sambi Insa akilawa inti ire, akiludira kwawo Nazareti. Wanafunzi wake ware wakinfulata. ");
INSERT INTO wmw_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Paifikire sabadu, akanza kufunda nsinagoga. Wengi pawasikire, watajabu pakulu. Wakamba: “Vinu‑vi vyankulawirira ndepi? Ndi wijiwifuni wapewe‑yu? Maajuza kamba‑ya aténda na makono ake‑ya kankupata ndepi? ");
INSERT INTO wmw_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Sinoyu‑yu karipinteru, mwana wa Mariyamu, nduye Yakobu, Yose, Yuda pamoja na Ansumani? Walumbuze atiri kwikala nawo nkaya nomu?” Ewo wakibugudika naye. ");
INSERT INTO wmw_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Basi Insa akiwambira: “Nabii ainshimiwa kila upande, ila aainshimiwa kwawo na awamwishimu wajamaa zake na wenziwe.” ");
INSERT INTO wmw_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Kwa javyo, iye aakidiri kutenda anta maajuza mamoja, sairi kuwatula makono walwere wamojawapo, kuwaponesa. ");
INSERT INTO wmw_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Iye akiwatajabu pakulu kwa sababu ya kutowa kumwamini. Ikisa, akilawa akipita akifunda mmakaya. ");
INSERT INTO wmw_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Sambi Insa akiweta wanafunzi kumi na wawiri ware, akanza kuwapereka wawiri-wawiri. Akiwapa mamulaka a kuwatuwisa mashetwani. ");
INSERT INTO wmw_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Akiwamuru wasirisukuze kinu munjira ila ngombo tu basi. Wasisukure cakurya, wala nrumba wala nzuruku, ");
INSERT INTO wmw_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","wasirisukuze nguwo mbiri ila wawe na viratu mmaulu tu basi. ");
INSERT INTO wmw_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Akiwambira novyo: “Mukifika mahala, nyumba yamusaka kufikira noyo, ikalani nomo mpaka suku yamusaka kulawa nopo mahala‑po. ");
INSERT INTO wmw_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ikiwa awakupokerereni na awakusikirizeni, pakulawa pumunani matako enu, iwe ushahidi kwawo.” ");
INSERT INTO wmw_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ewo nakulawa pare, wakipita wakereza kuwa wanu wajuzi watubiye. ");
INSERT INTO wmw_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Mashetwani wengi wakiwatuwisa, na walwere wengi wakiwamiminira mafuta kuno wakiwaponesa. ");
INSERT INTO wmw_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Sambi, nfalume Herodi akisikira habari kuhusu Insa kwa kuwa zina rake rikisifiwa pakulu. Wengine wakamba: “Yahaya mwenyé Koza kaziribuka ka wafwi, ndimana kankukunisha mambo a maajuza.” ");
INSERT INTO wmw_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Fala wengine wakamba: “Eyo Aliyasi.” Na wengine wakamba: “Eyo nabii mwengine, kamba minabii wamojawapo wa mida.” ");
INSERT INTO wmw_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Fala Herodi paasikire akamba: “Wanintupure kiswa omi, Yahaya mwenyé Koza, kaziripusiwa!” ");
INSERT INTO wmw_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Kamana Herodi mwanyewe kâwatuma masurudadu wakankore Yahaya wanfunge na wantaye nkalaboshu kwa sababu ya Herodiza, muka wa Filipi nduye Herodi, kwa kuwa kânlomba. ");
INSERT INTO wmw_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ndimana Yahaya kamwambira Herodi javi: “Auna haki ya kunlomba nlamuwo.” ");
INSERT INTO wmw_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Kwa javyo, Herodiza akikimiyana na Yahaya, vikimwajibu amulaye. Fala aakidirire, ");
INSERT INTO wmw_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","konta Herodi akimopa Yahaya, akijiwa kuwa iye mwananlume mmoja wa shariya na takatifu, ndimana akinkengera. Wakati waansikire Yahaya, Herodi akifazaika, fala novyo-sivyo vikimwajibu kunsikira. ");
INSERT INTO wmw_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Kwa suku moja Herodiza akija akipata nafasi ya kumulaya, suku Herodi yaakitenda mwaka. Kwa javyo, akitenda jambo, akiwarifu mawaziri wake, wakulungwa wa masurudadu, na wanu wakuinshimiwa wa Galileya. ");
INSERT INTO wmw_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Pengire kuvina mwana wa Herodiza, Herodi vimwajibu pakulu pamoja na wawarífire. Ndimana nfalume ire akimwambira mwari ire javi: “Nilebele causaka conse, omi nukupa.” ");
INSERT INTO wmw_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ikisa akilapira tena, akamba: “Causaka kulebela conse, anta paiwa nusu ya ufalume wangu‑wu, nukupa!” ");
INSERT INTO wmw_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Nakulawa iye akindairi mamaye: “Nilebele kinani?” Mamaye akamba: “Lebela kiswa ca Yahaya mwenyé Koza.” ");
INSERT INTO wmw_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Basi mwana ire akiludira upesi ka nfalume nokure, akilebela akamba: “Nisaka munipe nfinga sambi nopapa, kiswa ca Yahaya mwenyé Koza.” ");
INSERT INTO wmw_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Nfalume ire akikafilika pakulu futi, fala kwa kuwa kâlapira mbere ya wanu warifiwe ware, aankatarire. ");
INSERT INTO wmw_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Basi, kwa mpunde noure, nfalume ire akintuma surudadu na akamuru cikaje kiswa ca Yahaya. Surudadu ire akuka kukalaboshu, akitupula kiswa ca Yahaya, ");
INSERT INTO wmw_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","akija naco nfinga, akimpa mwari ire. Iye akipokerera, akimpa mamaye. ");
INSERT INTO wmw_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Wanafunzi wa Yahaya ware, pawasikire vinkunire mwanlimu wawo, wakuka wakitwala maiti a Yahaya, wakizika. ");
INSERT INTO wmw_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Mawalii ware wakijumana mbere ya Insa, wakimwambira piya vyawakitenda na vyawakifunda. ");
INSERT INTO wmw_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Iye akiwambira: “Njoni yeka yenu pakiriziu, mupumuzike aba.” Kamana wanu wákija na wákiludi wákiwa wengi, ewo awákiwa nawo anta nafasi yakurya. ");
INSERT INTO wmw_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Wakisuka mungalawa mure, wakuka mahala kiriziu wakipumuzika. ");
INSERT INTO wmw_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Fala wanu wengi wâwawona pawakilawa na wawéjiwa. Basi, ewo wakilawa luwansi mmakaya mure, wakiwatuwirira noko, wakifika kábula ewo sawanamba. ");
INSERT INTO wmw_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Basi, Insa nakwisuka mungalawa mure, kawawona wanu wengi wajumana, akiwawonera utungu pakulu konta wákiwa kamba makondoo sawana nsunga. Akanza kuwafunda vinu vingi vyawenye. ");
INSERT INTO wmw_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Paripepire juwa, wanafunzi ware wakuka ka Insa, wakimwambira javi: “Epa mahala‑pa pakilanga-langa, na juwa ripepa futi. ");
INSERT INTO wmw_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Wambire wanu‑wa woke vyawo mmakwawo au mmasamba ári karibu ipate wakauze cakurya.” ");
INSERT INTO wmw_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Fala Insa akiwajibu, akamba: “Wapeni umwe‑po cakurya warye!” Ewo wakamba: “Basi, tuke tikauze mikate ya jarajara miyateni tije tiwape watafune?” ");
INSERT INTO wmw_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Iye akiwadairi: “Umwe mwanawo mikate myengapi? Ukani mukanang'anize.” Nakuwona wakija wakisema: “Mitanu, na inswi mbiri.” ");
INSERT INTO wmw_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Basi, Insa akiwamuru wanafunzi ware wawambire wanu ware wekare makundi-makundi mminyani miwisi mure. ");
INSERT INTO wmw_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Piya ware wakikala makundi-makundi a wanu miya au amusini. ");
INSERT INTO wmw_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Insa nakutwala mikate mitanu ire na inswi mbiri zire, akinang'aniza julu, akishukuru, akimeya mikate, akiwapa wanafunzi wake ware wawatongere wanu ware. Na inswi mbiri zire akiwatongera piya ware. ");
INSERT INTO wmw_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Piya warya na wekuta. ");
INSERT INTO wmw_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Wakilokotera pamoja vipande vyakubaki vya mikate na inswi, vikalala kumi na viwiri vyakwijala tapa-tapa. ");
INSERT INTO wmw_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Na watafune mikate wákiwa wanawalume alufu ntanu! ");
INSERT INTO wmw_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Kwa mpunde noure Insa, akiwalazimisha wanafunzi wake wengire mungalawa, walongorere ng'ambu nyengine, Betisaida, mpaka iye ese kulayana nawo wanu ware. ");
INSERT INTO wmw_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Pawesire kulayana, Insa akuka pamwango kulebela duwa. ");
INSERT INTO wmw_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Paripepire juwa, ngalawa ilongorere ire íkiwa kati-kati ya tanda, na Insa ákiwa yeka yake kungulu. ");
INSERT INTO wmw_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Kwa kuwawona kuwa wankutaya magasiya kwa tafauti kamana úkiwa mbisho, alufajiri galu ntanzi, iye akiwokira kuno akenenda julu ya maji. Akenenda kamba asaka kuwapunda, ");
INSERT INTO wmw_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","fala ewo pawammonire akenenda julu ya maji, wakidaniza kuwa nsoka, wakanza kufula uto. ");
INSERT INTO wmw_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Kweli, piya wammona na wasusuka pakulu futi. Fala kwa mpunde noure, Insa akisowera nawo, akiwambira javi: “Rimbani myoyo! Ndi nomi, musope kinu!” ");
INSERT INTO wmw_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Iye akingira mungalawa mure, na mepo ire ikinyamala. Ewo wakitajabu pakulu futi! ");
INSERT INTO wmw_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Kusema kweli, wákiwa sawanamba kwereriwa kuhusu mikate ire, kamana myoyo yawo íkiwa migumu. ");
INSERT INTO wmw_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Pawalokire wakifika kungulu ya ng'ambu nyengine, inti ya Genezareti, wakitaya nanga. ");
INSERT INTO wmw_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Nakwisuka mungalawa mure, mpunde noure wanu ware wammanyira. ");
INSERT INTO wmw_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Wakipita, wakituwa piya mmakaya mure. Walwere wakiwasukula mmashila, wakuka nawo mahala pawasikire kuwa ndi paari Insa. ");
INSERT INTO wmw_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Mwakipita Insa monse, mmakaya asaka kuwa onse na nvitongojo, mmabazari wakiwatula walwere wawo, wakintafadali nanga anzu yake wankumbure. Na piya wakinkumbula, wákipona. ");
INSERT INTO wmw_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Suku moja, Mafarizeu pamoja na wanlimu wa shariya wamojawapo wâlawa Yerusalemu, wakijumana ka Insa. ");
INSERT INTO wmw_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ewo wawawona wanafunzi wamojawapo wa Insa wakirya sawatawade. ");
INSERT INTO wmw_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Kamana Mafarizeu, na Mayahudi piya, awarya sawatawade sana-sana, kwa kutumira tabiya ya wazee wawo. ");
INSERT INTO wmw_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Nakuludi kubazari, ikiwa awatawade sana-sana, awakirya. Ziwapo tabiya nyingi zawenye zawákifulata: kosa kopo, miringi na vyombo vya shaba.) ");
INSERT INTO wmw_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Basi, Mafarizeu pamoja na wanlimu wa shariya wandairi javi: “Wanafunzi wako awafulata tabiya za wazee, sababuni kurya sawatawade mmakono sana-sana?” ");
INSERT INTO wmw_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Iye akiwajibu: “Nabii Izaya kasowera tangu-mida kuhusu umwe manafiki kamba vyavyândikiwe javi: ‘Ewa wanu‑wa wanitukuza nkanywa tu basi, fala myoyo yawo iwa baidi nami. ");
INSERT INTO wmw_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Akufãi kinu kunitukuza kwawo, wafunda mafunzo na shuruti za wanadamu.’ ” ");
INSERT INTO wmw_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ikisa Insa akiwambira: “Wakwasa ámuri za Mwenyezimungu, ila wafulata shuruti za wanadamu.” ");
INSERT INTO wmw_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Akiwambira tena: “Mwanawo tabiya yakukatala ámuri ya Mwenyezimungu ipate tabiya zenu zisise! ");
INSERT INTO wmw_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Kamana Musa kâsema: ‘Mwinshimu wawayo na mamayo’, na ‘Munu wakunsowerera caputu wawaye au mamaye, ahukumiwe kifo.’ ");
INSERT INTO wmw_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Fala umwe mukwamba kuwa munu akimwambira wawaye au mamaye: ‘Vinu vyanikijuzi kukupani umwe ndi Kurbani’, ");
INSERT INTO wmw_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","mwankukataza munu kuwasaidiya wawaye na mamaye. ");
INSERT INTO wmw_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Kwa javyo, mwankufuja usemi wa Mwenyezimungu kwa tabiya zenu zamufunda. Na mwankutenda vinu vingi kamba novyo.” ");
INSERT INTO wmw_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Mara nyengine Insa kaweta wanu wanfike karibu yake, akiwambira javi: “Piya-mwe, nisikirizeni omi, ereriwani. ");
INSERT INTO wmw_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Hapana kinu cakuwa panja ya mwanadamu cakuwa cikimwingira mmwiri cintaya haramu. Ila vinu vinlawa ndi vintaya haramu.” ");
INSERT INTO wmw_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Sambi, nakutanuka junudi ya wanu ire, Insa akingira nnyumba, na wanafunzi wake wakindairi: “Kinyume‑ci mana ake kinani?” ");
INSERT INTO wmw_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Insa akiwajibu: “Umwe novyo amwereriwe? Amwijiwa kuwa vya panja vikimwingira munu avintaya haramu? ");
INSERT INTO wmw_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Kweli, avimwingira mmoyo, ila vimwingira ntumbokulu ikisa vilawira nsintina.” Kwa javyo, Insa kolota kuwa piya vyakurya halali kurya. ");
INSERT INTO wmw_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Insa akamba tena: “Vinlawa munu, ndi vintaya haramu. ");
INSERT INTO wmw_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Konta, mmoyo mwa munu, alawa mawazo akunyata: ceje, wivi, ukisomi, ");
INSERT INTO wmw_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","uzinzi, wájibu wakupata vinu piya, ubaya, ulongo, wájibu wa vitendo vya ucaputu, wiyana, kufuru, kuridãi pamoja na urevi. ");
INSERT INTO wmw_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Vitendo vyakunyata‑vi, piya vílawa mmoyo, ndimana vintaya munu haramu.” ");
INSERT INTO wmw_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Nakulawa pare, akukirira makaya a Tiru na a Sidoni. Iye nakwingira nnyumba, kasaka asijiwikane, falakini aakidirire kurifisa. ");
INSERT INTO wmw_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Mwanamuka mmoja, akíwa na mwanawe kâpatiwa na jini, akisikira kuwa Insa kaja. Nakunfika akinkokorera mmaulu mwake. ");
INSERT INTO wmw_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Mwanamuka ire aáwere Yahudi, kwawo kúkiwa Sirufoinike. Akilebela atuwisiwe jini mwanawe ire. ");
INSERT INTO wmw_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Iye akamba javi: “Wase kwanza wasimana wekute. Kamana sivyema kutwala mikate ya wasimana, kuwefyera wawumbwa.” ");
INSERT INTO wmw_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Mwanamuka ire akijibu akamba: “Aye, Mwenye, fala wawumbwa wakuryanga songolo za pansi zakuwagwa wasimana pameza.” ");
INSERT INTO wmw_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Basi Insa akimwambira tena: “Kwa sababu ya usowezi wako, mwanawo katuwisiwa jini‑yo futi. Ludi, uka ukaya.” ");
INSERT INTO wmw_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Mwanamuka ire nakuludira ukaya, kansingana kisimana ire alarire pakinanda, jini ire anlawire. ");
INSERT INTO wmw_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Insa akilawa tena makaya a Tiru akija Sidoni, kutanda ra Galileya, kati-kati ya makaya a Dekapoli. ");
INSERT INTO wmw_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Noparepare wakinjisira mwananlume mmoja bubu, saasikira. Wakinlebela anture nkono. ");
INSERT INTO wmw_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Insa akintanusa pawanu pare, akuka naye kiriziu, akintaya vyala mmasikiro, akintaya mata ake julu ya lulimi, ");
INSERT INTO wmw_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","akimwinula uso julu binguni, akimpumuzikira, akimwambira na luga ya kiyaramaiku: “Efata”, mana ake “Ziuka.” ");
INSERT INTO wmw_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Kwa mpunde noure, masikiro akinziuka na nzipe wa lulimi ukinkunjuka, akanza kusowera sana-sana. ");
INSERT INTO wmw_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ikisa akiwamuru wanu ware kuwa wasimwambire munu. Fala kila paákiwamuru kuwa wasiseme, ndi pawakizidi kwereza. ");
INSERT INTO wmw_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Kwa javyo, wakitajabu pakulu, wakamba: “Vitendo vyake piya vyema! Sawasikira awasikirisa, na mabubu awasoweresa!” ");
INSERT INTO wmw_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Nozire suku zire, iwa tena wanu wengi awákiwa nawo cakurya, Insa akiweta wanafunzi wake, akiwambira javi: ");
INSERT INTO wmw_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Wanu‑wa niwawonera utungu konta wawa nomi suku natu, awana kinu cakurya. ");
INSERT INTO wmw_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nikilayana nawo wakiludira mmamakwawo wafungire, awaja kuzirika munjira? Wengine waja kulawa baidi.” ");
INSERT INTO wmw_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Fala wanafunzi ware wakinjibu: “Palanga kamba‑pa, munu akidirija cakurya cakuwekutisa ewa wanu‑wa?” ");
INSERT INTO wmw_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Insa akiwadairi: “Mwanawo mikate myengapi?” Ewo wakinjibu: “Saba.” ");
INSERT INTO wmw_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Basi akamba: “Wanu piya wekare pansi.” Akitwala mikate saba ire, akinshukuru, akimeya, akiwapa wanafunzi ware, newo wakiwatongera wanu ware. ");
INSERT INTO wmw_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Wákiwa nawo novyo inswi aba. Noparepare Insa akintukuza Mwenyezimungu, akisema: “Nezo novyo watongereni piya‑wo.” ");
INSERT INTO wmw_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Na wanu ware wakirya wakikuta, mwinsho wakilokotera vipande, vikilawirira vikalala saba vyakwijala vyawenye. ");
INSERT INTO wmw_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Wanu wákiwa kiyasi ca alufu nne. Ikisa, akilayana nawo. ");
INSERT INTO wmw_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Kwa mpunde noure, iye akingira mungalawa pamoja na wanafunzi wake ware, akuka upande wa Dalmanuta. ");
INSERT INTO wmw_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Wakilawa Mafarizeu, wakuka wakikaidiyana naye. Ewo wakisakula alama ya binguni, wakimyerera. ");
INSERT INTO wmw_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Kwa javyo, Insa akipumuzika pakulu, akamba: “Sababuni eci kizazi‑ci kisákula alama? Nukwambirani kweli kuwa kizazi‑ci acoloteriwa alama.” ");
INSERT INTO wmw_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Basi, akiwasa, akiripakira tena, akuka ng'ambu nyengine. ");
INSERT INTO wmw_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Na kumbe, wanafunzi ware wariwala kusukula cakurya. Mungalawa mure wákiwa nawo nkate mmoja tu basi. ");
INSERT INTO wmw_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Insa akiwalaizira, akamba: “More-moreni na furumento ya Mafarizeu pamoja na ya nfalume Herodi.” ");
INSERT INTO wmw_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Wakikola kukaidiyana watupu konta awâwere nawo mikate. ");
INSERT INTO wmw_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Insa, pejiwe kuwa wankukaidiyana, akiwambira: “Mbana mukaidiyana kwa kutowa kuwa nawo mikate? Amunamba kwijiwa mana wala amunereriwa? Myoyo yenu migumu pakulu? ");
INSERT INTO wmw_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Umwe mwanawo maso, amuwona? Mwanawo masikiro, amusikira? Amukumbukira? ");
INSERT INTO wmw_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Mikate mitanu yaniwatongere wanu alufu ntanu ire, vipande víbakire víjala vikalala vyengapi?” Ewo wakijibu: “Kumi na viwiri.” ");
INSERT INTO wmw_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Na mikate saba kwa wanu alufu nne, vipande víbakire víjala vikalala vyengapi?” Ewo wakijibu: “Saba.” ");
INSERT INTO wmw_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Basi iye akiwambira tena: “Mpaka sambi amunamba kwereriwa?” ");
INSERT INTO wmw_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Insa na wanafunzi wake wakifika Betisaida. Wakija nawo ka Insa munu mmoja sawona, wakinlebela ankumbure. ");
INSERT INTO wmw_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Iye nakunkola nkono sawona ire, akinlongoza nanyenje ya kaya ire. Nakunsunira mata mmaso, akintula makono, akindairi: “Kwankuwona kinu kimojawapo?” ");
INSERT INTO wmw_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Mwananlume ire akinang'aniza julu, akamba: “Nankuwawona wanu kamba miti íri kwenenda!” ");
INSERT INTO wmw_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ikisa tena, akintula makono julu ya maso ake. Munu ire akinang'aniza rungu-rungu, akiponesiwa, akanza kuwona piya vinu sana-sana. ");
INSERT INTO wmw_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Insa akimwambira: “Epa, uka nfululu kwenu, usipite nkaya tena.” ");
INSERT INTO wmw_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Insa na wanafunzi wake wakuka mpaka makaya a Kaisariya-Filipi. Munjira iye akiwadairi, akamba: “Wanu wakwamba kuwa omi niwa nani?” ");
INSERT INTO wmw_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ewo wakinjibu: “Wengine wakwamba uwe kuwa Yahaya mwenyé Koza, wengine wakwamba kuwa Aliyasi, na wengine wakwamba kuwa nabii mwengine mmojawapo.” ");
INSERT INTO wmw_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Insa akiwadairi tena: “Sambi, umwe mudaniza kuwa omi niwa nani?” Peduru akinjibu, akamba: “Uwe ndi Almasihi!” ");
INSERT INTO wmw_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Basi, Insa akiwalaizira kuwa wasimwambire munu kuhusu iye caari. ");
INSERT INTO wmw_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Sambi, Insa akanza kuwafunda kuwa Binadamu wa Binguni ajuzi atabike pakulu, akatariwe na wazee, wakulungwa wa dini, pamoja na wanlimu wa shariya. Ikisa ajuzi aulaiwe, fala bandi ya suku natu afufuke. ");
INSERT INTO wmw_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Iye akisowera evi vinu‑vi bila kuwafisa. Fala Peduru akimwita kunyenje, akanza kunsutumu. ");
INSERT INTO wmw_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Insa akizungunuka, akiwanang'aniza wanafunzi ware, akinsutumu Peduru, akamba: “Lawa‑pa uka nyuma‑ko, Shetwani! Kamana auwaza mawazo a Mwenyezimungu ila a wanadamu!” ");
INSERT INTO wmw_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ikisa akiweta wanu ware pamoja na wanafunzi wake akiwambira javi: “Ikiwa munu mmojawapo asaka kunifulata, arikane mwanyewe, asukure nsalaba wake, na anifulate. ");
INSERT INTO wmw_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kamana asáka kuvusha mainsha ake, apoteza. Fala apotéza mainsha ake kwa sababu yangu omi na ya Habari Ngema, ávusha. ");
INSERT INTO wmw_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Munu kupata duniya nzima‑yi, kupoteza mainsha ake, faidani? ");
INSERT INTO wmw_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Munu cakakanya na mainsha ake kinani? ");
INSERT INTO wmw_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Munu akiriwónera haya nomi au usowezi wangu kati ya eci kizazi ca uzinzi na dambi‑ci, Binadamu wa Binguni, pakuludi na utukufu wa Baba na malaika matakatifu, iye novyo akuja kuriwonera haya naye.” ");
INSERT INTO wmw_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Insa akiwambira, akamba: “Nukwambirani kweli kuwa wawapo nopapa wamojawapo aciwapata kifo viwa vyonse sawawonire ufalume wa Mwenyezimungu ukija na uwezo.” ");
INSERT INTO wmw_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Bandi ya suku sita, Insa akiwatwala Peduru, Yakobu, pamoja na Yahaya, akiwalongoza kumwango nrefu kiriziu, yeka yawo. Akitaduka mbere yawo, ");
INSERT INTO wmw_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","mavazi ake akimensa, ákiwa melupa pakulu vú koliko kinu cisaka kuwa conse duniya‑yi. ");
INSERT INTO wmw_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Nopare, wakilawirira nabii Aliyasi pamoja na Musa, wakanza kupakanira na Insa. ");
INSERT INTO wmw_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Sambi Peduru akamba: “Mwanlimu, vyema tikare nopa! Tijenge vibanda vitatu: kimoja cako, cengine ca Musa, na cengine ca Aliyasi.” ");
INSERT INTO wmw_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Kusema kweli, Peduru aakijiwa caakisowera konta wanafunzi ware piya uwapata wofi pakulu. ");
INSERT INTO wmw_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Rikija wingu rikiwafinika. Nkati ya wingu ikisikirika shauti ikamba: “Eyu ndi Mwanangu wanimpenda. Nsikirizeni!” ");
INSERT INTO wmw_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Kwa mpunde noure, wanafunzi ware wakimangamanga kunang'aniza, wammona Insa tu basi ari pamoja newo. ");
INSERT INTO wmw_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Pawakisuka pamwango pare, Insa kawambira kuwa wasimwambire munu vyawawonire vire, Binadamu wa Binguni saanamba kufufuka ka wafwi. ");
INSERT INTO wmw_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ure usowezi ure wakitula ila wakikola kukaidiyana watupu mana a usowezi wa “kufufuka ka wafwi”. ");
INSERT INTO wmw_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ikisa wakuka wakindairi Insa: “Sababuni wanlimu wa shariya za dini wakwamba kuwa kwanza ajuzi aludi Aliyasi?” ");
INSERT INTO wmw_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Insa akijibu: “Ndi kweli kuwa Aliyasi akijuzi anze kuja, antengezere vinu piya Binadamu wa Binguni. Fala vyaândikiwa novyo kuwa Binadamu akuja kutabika na kukejeliwa, sivyo? ");
INSERT INTO wmw_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Kusema kweli, omi nukwambirani kuwa Aliyasi kâja futi na wantenda piya vyawasakire vyonse kamba vyavyândikiwe kuhusu iye.” ");
INSERT INTO wmw_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Paafikire karibu ya wanafunzi ware, wakija wanu wengi wakiwazunguriza, na wanlimu wa shariya wengine wakikaidiyana nawo. ");
INSERT INTO wmw_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Mpunde noure, wanu ware, pawammonire Insa, wakitajabu pakulu, wakituwa wakuka wakinkomaza. ");
INSERT INTO wmw_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Insa akiwadairi: “Umwe mwankukaidiyana nawo kinani?” ");
INSERT INTO wmw_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ákiwepo mwananlume mmoja kati ya wanu ware akijibu: “Mwanlimu, nija nawo mwanangu‑yu, iye kâpatiwa na jini bubu. ");
INSERT INTO wmw_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Daima jini paampata ponse arefya pansi. Nnemba‑yu akwanza kulawa makovu kukanywa, kutafuna meno, na aawa na nguvu. Niwalebela wanafunzi wako‑wa wantuwise jini‑yu, awakidirire.” ");
INSERT INTO wmw_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Insa akiwajibu javi: “Ha! Kizazi sacamini! Nukwikala namwe mpaka rini? Nukuhitamilini mpaka rini? Njoni naye nnemba‑yo kuno.” ");
INSERT INTO wmw_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ewo wakuka naye. Jini ire nakummona Insa, mpunde noure kangwisira pansi nnemba ire. Iye akinyongoloka kuno akilawa makovu nkanywa. ");
INSERT INTO wmw_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Insa akindairi wawaye ire: “Nowu ulwere‑wu umwanza rini?” Iye akijibu: “Umwanza tangu ári kisimana. ");
INSERT INTO wmw_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Mara nyingi zawenye, jini angwisira pamoto na mmaji, kalangela amulaye. Basi, tiwonere utungu! Ukikidiri, tisaidiye!” ");
INSERT INTO wmw_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Insa akinjibu, akamba javi: “Sababuni kwamba ‘ukikidiri’? Piya vikidirika ka mwenyé kwamini.” ");
INSERT INTO wmw_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Kwa mpunde noure, wawaye ire akijibu: “Omi nukwamini, fala nisaidiye nisiwe na dana tena!” ");
INSERT INTO wmw_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Insa paawanang'anize wanu ware, kawawona kuzidi kwengezeka. Basi akinsutumu jini ire, akamba: “Jini untenza bubu na kewewe nnemba‑yu, omi nukwamuru unlawe sambi nopapa. Usishubutu kumwingira tena!” ");
INSERT INTO wmw_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Jini ire akikuwa, akinsasanya kanguvu, akinlawa, akimwasa kamba mufwi. Anta na wengi wakidaniza kafwa. ");
INSERT INTO wmw_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Fala Insa akinkola nkono, akinlamusa, neye akimira. ");
INSERT INTO wmw_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Airini, Insa pengire nnyumba, wanafunzi wake wakindairi cembe: “Ofwe atikidirire kuntuwisa jini âmpatire ire, sababuni?” ");
INSERT INTO wmw_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Insa akiwajibu: “Ire jini ire atuwisiwa kwa duwa tu basi.” ");
INSERT INTO wmw_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Insa na wanafunzi wake, nakulawa pare, wakipita kati-kati ya Galileya. Iye avikimwajibu kuwa munu ejiwe mahala pare, ");
INSERT INTO wmw_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","kamana akiwafunda wanafunzi ware, akiwambira javi: “Binadamu wa Binguni agabiziwa mmakono mwa wanadamu, newo wamulaya. Fala bandi ya kuulaiwa, muda wa suku natu, iye afufuka.” ");
INSERT INTO wmw_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ewo awakereriwa caakamba, na wakopa kundairi. ");
INSERT INTO wmw_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Wakifika Kafarnaumu. Pawafikire ukaya, Insa akiwadairi wanafunzi ware: “Munjira mure umwe mukikaidiyana kinani?” ");
INSERT INTO wmw_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Fala ewo wakinyamala, konta wakikaidiyana munjira kuwa nani ári bora. ");
INSERT INTO wmw_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Noparepare, Insa akikala, akiweta wanafunzi kumi na wawiri ware, akiwambira: “Ikiwa munu‑yo asaka awe ntanzi, ajuzi ariture kuwa wa mwinsho, awatumike wenziwe piya.” ");
INSERT INTO wmw_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ikisa, Insa akinkola kisimana mmoja akimwimisa kati yawo, akimpinga mmakono, akiwambira: ");
INSERT INTO wmw_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Munu asaka kuwa onse ampokérera kisimana kamba‑yu, kwa zina rangu, kanipokerera omi. Na anipokérera omi, kusema kweli aanipokerera omi fala ampokerera Baba wangu ári mbinguni anipereke omi.” ");
INSERT INTO wmw_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yahaya kamwambira Insa: “Mwanlimu, timmona mwananlume mmoja akiwatuwisa mashetwani kwa zina rako. Tinkataza konta aari munkonjo mwetu.” ");
INSERT INTO wmw_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Insa akimwambira javi: “Musinkataze! Aapo munu aténda maajuza kwa zina rangu ikisa kanisowerera vibaya. ");
INSERT INTO wmw_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Kamana munu satilumbata ofwe, kawa upande wetu. ");
INSERT INTO wmw_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Munu akupani kopo ya maji kwa kuwa kawa upande wa Almasihi, nukwambirani kweli aakosa futi kupata thawabu yake.” ");
INSERT INTO wmw_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Akizidi kwamba: “Munu mmojawapo ankósesa ewa wasimana mmojawapo wanámini‑wa, ndi fadari afungiriwe riwe rakupalaza nsingo, atosiwe kati-kati ya bahari. ");
INSERT INTO wmw_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Novyo, ikiwa ukukósesa ndi nkono wako, tupula nowo. Fadari ubadilike wingire mainsha a milele, koliko kuwa na makono mawiri kuka Jahanamu kauri moto sauzimika tena. ");
INSERT INTO wmw_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ikiwa ukukósesa ndi mulu wako, tupula nowo. Fadari uwe kitewe wingire mainsha a milele koliko kuwa na maulu mawiri kwefiwa Jahanamu. ");
INSERT INTO wmw_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ikiwa riso rako rimojawapo ndi rukukósesa, kotopola noro. Fadari kwingira muufalume wa Mwenyezimungu na riso rimoja basi, koliko kuwa na maso mawiri kwefiwa Jahanamu. ");
INSERT INTO wmw_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Eko nvunyo awafwa wala moto‑wo auzimika. ");
INSERT INTO wmw_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Kamana kila munu ataiwa munyu kwa moto. ");
INSERT INTO wmw_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Munyu ufãi, ulunga cakurya, fala ikiwa munyu ulamwa cilungiriwa kinani? Basi mujuzi muwe kamba munyu. Piya inshini kwa salama munu na mwenziwe.” ");
INSERT INTO wmw_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ikisa Insa akilawa mahala pare, akukirira makaya ya Yudeya na ng'ambu ya muto wa Yordani. Akijumana nawo novyo tena wanu wengi, na kamba vyazowerere, akikola kuwafunda. ");
INSERT INTO wmw_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Mafarizeu wakinfika karibu wakindairi javi: “Iwapo haki nlume kumwasa nkawake?” Wandairi javyo konta wakisakula wankorese. ");
INSERT INTO wmw_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Insa akijibu, akamba: “Musa kakwamuruni mwaja?” ");
INSERT INTO wmw_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ewo wakijibu: “Musa karuhusu nlume antaliki nkawake, ushahidi wa kumwasa.” ");
INSERT INTO wmw_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Insa akiwambira: “Musa kândika eyi ámuri‑yi kwa sababu ya myoyo yenu kuwa migumu. ");
INSERT INTO wmw_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Fala tangu mwanzo wa kumba, Mwenyezimungu kamumba nlume na muka. ");
INSERT INTO wmw_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ndimana, mwananlume awasa wawaye na mamaye, alungana afulatana pamoja na nkawake, ");
INSERT INTO wmw_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","wo‑wawiri wakuwa mwiri mmoja, awawa futi wawiri tena, ila mwiri mmoja tu basi. ");
INSERT INTO wmw_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kwa javyo, kinu caaluganise Mwenyezimungu, munu asasanise.” ");
INSERT INTO wmw_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Airini, Insa paákiwa ukaya na wanafunzi wake, ewo waludira kundairi kuhusu noure mwaha ure. ");
INSERT INTO wmw_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Iye kawambira: “Mwenye kumwasa nkawake akinlomba mwengine, kawakuzinga naye. ");
INSERT INTO wmw_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Na ikiwa mwanamuka kamwasa nlumake, akilombiwa na nlume mwengine, neye novyo kawankuzinga.” ");
INSERT INTO wmw_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Sambi wanu wengine waja nawo wana awakumbure, fala wanafunzi ware wakiwasutumu wanu ware. ");
INSERT INTO wmw_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Iye paawawonire, akikimiwa na wanafunzi wake pakulu futi, akiwambira javi: “Waseni wasimana‑wo waje kwangu omi kuno! Musiwakataze! Kamana ufalume wa Mwenyezimungu wanu kamba ewa ndi wawo. ");
INSERT INTO wmw_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nukwambirani kweli kuwa munu saapokerera ufalume wa Mwenyezimungu kamba kisimana, visaka kuwa vyonse emo engira.” ");
INSERT INTO wmw_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ikisa wasimana ware akiwakola makono, akiwajanliya kuno akiwatula makono. ");
INSERT INTO wmw_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Insa, nakulongoza njira, mwananlume mmoja akintuwirira, akikokora mbere yake, akindairi: “Mwanlimu mwema, kupata mainsha a milele, nijuzi kutenda kinani?” ");
INSERT INTO wmw_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Insa akinjibu: “Sababuni kunita mwema? Hapana mwema ila Mwenyezimungu tu basi. ");
INSERT INTO wmw_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ukwijiwa ámuri zamba javi: usimulaye munu, usizinge, usiwe, usiseme ushahidi wa ulongo, usitende udanganyifu, na umwinshimu wawayo na mamayo.” ");
INSERT INTO wmw_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Iye akinjibu: “Mwanlimu, ezo ámuri‑zo ndi zanifulata tangu unemba wangu.” ");
INSERT INTO wmw_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Insa akinang'aniza ka kumpenda pakulu, akimwambira javi: “Ciwapo kinu cukubakire. Uka, ukauzanye vyaúri navyo piya, uwape masikini. Kwa javyo, ukuwa nawo mali mbinguni. Njo, unifulate.” ");
INSERT INTO wmw_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Nakusikira usowezi ure, akilawa auzunike pakulu futi, konta ákiwa tajiri pakulu. ");
INSERT INTO wmw_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Insa akinang'aniza nanyenje ire, akiwambira wanafunzi wake ware javi: “Virigariga pakulu matajiri kwingira muufalume wa Mwenyezimungu!” ");
INSERT INTO wmw_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Wanafunzi, pawasikire usowezi ure, wakishanga. Fala Insa akisowera tena: “Wanangu, virigariga pakulu kwingira muufalume wa Mwenyezimungu! ");
INSERT INTO wmw_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Raisi pakulu ngamiya kupita kupenya pakipenyo ca singano koliko tajiri kwingira muufalume wa Mwenyezimungu.” ");
INSERT INTO wmw_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Wanafunzi ware watajabu pakulu, wakidairiyana watupu: “Kwa javyo, nani aja kuvushiwa?” ");
INSERT INTO wmw_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Insa akiwanang'aniza rungu-rungu, akiwambira: “Virigariga ka wanadamu. Fala ka Mwenyezimungu avirigariga, konta kwake iye, piya vikidirika.” ");
INSERT INTO wmw_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Peduru akanza kumwambira Insa javi: “Ona, ofwe tasa piya vinu, tiwankukufulata.” ");
INSERT INTO wmw_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Insa akijibu: “Nukwambirani kweli kuwa kila mwenyé kwasa nyumba, wanduze, walumbuze, mamaye, wawaye, wanawe, au inti yake, kwa sababu yangu omi na kwa sababu ya Habari Ngema, ");
INSERT INTO wmw_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","apata mara miya sambi‑pa nowu wakati‑wu, manyumba, wanduze, walumbuze, mamaze, wanawe, na inti, pamoja na kulumbatiwa. Na ulumwengu uja‑wo, apata mainsha a milele. ");
INSERT INTO wmw_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Na wengi wari watanzi sambi‑pa wakuja kuwa wamwinsho, na wamwinsho wakuja kuwa watanzi.” ");
INSERT INTO wmw_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Sambi ewo wari munjira wakuka Yerusalemu, Insa kalongorera. Wakinfulata piya washanga na wanu wengine walongozane nawo wakiwa na wofi. Basi, Insa akiweta mara nyengine tena wanafunzi kumi na wawiri ware akanza kuwambira piya vyuka kunkuna Yerusalemu. ");
INSERT INTO wmw_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Akiwambira javi: “Sikirizani! Tankuka Yerusalemu, Binadamu wa Binguni agabiziwa walongozi wakulu wa dini na wanlimu wa shariya. Ewo wakuka kunlamula aulaiwe na wampereka ka Sawari-Mayahudi. ");
INSERT INTO wmw_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ewo wakuka kunshupa, kunsunira mata, kumwibiya, na kumulaya. Fala muda wa suku natu, iye afufuka.” ");
INSERT INTO wmw_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ikisa, Yakobu pamoja na Yahaya, wana wawiri wa Zebedeyu, wakimukira Insa, wakimwambira: “Mwanlimu, tisaka catukulebela conse, utitendere noco.” ");
INSERT INTO wmw_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Insa akijibu: “Musaka nukutendereni kinani?” ");
INSERT INTO wmw_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ewo wakimwambira: “Pausaka kuwa muufalume wako wa utukufu, ofwe‑pa mmoja akwikare upande wa nkono sonto na mwengine upande wa nkono nriro wako.” ");
INSERT INTO wmw_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Insa akijibu: “Umwe anta camulebela amwijiwa. Mukidiri kunywa kikombe ca ninywa omi au mukidiri koziwa kamba vyanoziwe omi?” ");
INSERT INTO wmw_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ewo wakinjibu: “Aye, tikidiri!” Basi, Insa akiwambira: “Mukuja kunywa kikombe caninywa omi, na koziwa kanoziwe omi nomwe mukuja koziwa. ");
INSERT INTO wmw_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Fala kwikala upande wa nkono-nriro au nkono-sonto wangu sumi namuru kwikaza ila wakwikaziwa watengezeriwe kwikala.” ");
INSERT INTO wmw_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Wanafunzi wengine kumi ware pawejiwe cawakilebela, wakiwakimwira Yakobu na Yahaya. ");
INSERT INTO wmw_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Basi, Insa akiweta wanafunzi ware, akiwambira: “Umwe mukwijiwa kuwa inti piya mafalume ndi wawatawala wanu kwanguvu, na wakulungwa wawo ndi walavya ámuri zakuwatuma. ");
INSERT INTO wmw_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Falakini kati yenu umwe, sivyaviri javyo. Kusema kweli, asakula awe nkulu, akuwa ntumisi wenu. ");
INSERT INTO wmw_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Na kati yenu asaka kuwa awe wakwanza siti awe ntwana wa piya-mwe. ");
INSERT INTO wmw_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Konta na Binadamu wa Binguni novyo, aajire kutumikiriwa ila kaja kutumika na kupereka mainsha ake kuwa maripo, awavushe wanu wengi.” ");
INSERT INTO wmw_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Basi, ewo wakifika Yeriko. Insa ákiwa na wanafunzi wake pamoja na junudi ya wanu wengi wawenye. Pawalawire Yeriko, nzimola munu sawona wakwitiwa Bartimeu (mana ake mwana wa Timeu), kekala nanyenje ya njira. ");
INSERT INTO wmw_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Paasikire kuwa Insa nNazareti ndi ari kupita, iye akanza kukuwa: “Insa mwana wa Daudi, niwonere utungu!” ");
INSERT INTO wmw_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Wengi wakimwambira anyamare. Fala iye akizidi kukuwa pakulu-pakulu: “Mwana wa Daudi, niwonere utungu!” ");
INSERT INTO wmw_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Insa paansikire, iye akimira, akamba: “Mwiteni aje kuno.” Basi, ewo wakimwita kipofu ire, wakimwambira: “Iwa radi! Lamuka, kwankwitiwa.” ");
INSERT INTO wmw_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Kipofu Bartimeu ire akivula vazi rake akefya pansi, akilamuka akuka ka Insa. ");
INSERT INTO wmw_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Insa akindairi: “Uwe usaka nukutende mwaja?” Iye akamba: “He, mwanlimu! Nisaka niludire kuwona!” ");
INSERT INTO wmw_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Insa akimwambira: “Uka! Kwamini kwako kukuponesa!” Kwa mpunde noure, akiludira kuwona tena, neye akikola kunfulata noire njira ire. ");
INSERT INTO wmw_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Insa pamoja na wanafunzi wake wari karibu ya Yerusalemu, pepi ya Betifage na Betaniya pamwango wa Mizaituni, iye akiwatuma wanafunzi wawiri, ");
INSERT INTO wmw_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","akiwambira javi: “Ukani mpaka kaya iri mbere ire. Mukifika, munsingana buru afungiriwe pamuti, tangu saanapandiwa na munu. Munfungure, muje nawo kuno. ");
INSERT INTO wmw_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ikiwa munu kakudairini camutenda‑ci kinani, mwambireni kuwa Mwenye ndi ari kunsakula, anludisa sambi‑pa.” ");
INSERT INTO wmw_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ewo wakuka, wakinsingana buru afungiriwe pamuti panja karibu ya nryango, wakinfungula. ");
INSERT INTO wmw_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Wanu wengine wemire nopare wakiwadairi: “Mbana mwankunfungula buru‑yo?” ");
INSERT INTO wmw_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ewo wakiwajibu kamba vyawatumiwe na Insa, wakiwasa wakuka vyawo. ");
INSERT INTO wmw_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ikisa, wanafunzi ware wakintwala buru ire wakuka naye ka Insa, wakitandika makapa awo julu ya buru ire, na iye akimpanda. ");
INSERT INTO wmw_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Wanu wengi wawenye wakitandika mavazi awo munjira mure, na wengine wakitandika makuti a mitende awakisinja a mmamasamba. ");
INSERT INTO wmw_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Walongorere mbere na wakiwafulata wakimba pakulu-pakulu: “Hozana! Ajanliiwe ári kuja kwa zina ra Mola! ");
INSERT INTO wmw_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ujanliiwe ufalume usaka kuja‑wo, ufalume wa babu yetu Daudi! Hozana mbingu ya mwinsho!” ");
INSERT INTO wmw_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Neye akingira Yerusalemu, akuka nNyumba Takatifu. Bandi ya kutunza sana-sana vinu vire piya, akilawa, na kwa kuwa juwa riswa futi, akuka Betaniya na wanafunzi kumi na wawiri ware. ");
INSERT INTO wmw_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Subuu yake, pawalawire Betaniya, Insa ikinkola njala. ");
INSERT INTO wmw_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ari baidi kawona nfigu, uri na masamba nyanyama. Akuka karibu awone kamba viwapo visumo, fala aasingane kinu ila masamba tu basi, kamana wakati‑wo aikiwa mirongo ya figu. ");
INSERT INTO wmw_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Nakulawa iye akisowerera muti ure akamba: “Mwanzo wa rero mpaka milele, asiwepo arya kisumo cako!” Na vyaasowere vire, wanafunzi wake wakisikira. ");
INSERT INTO wmw_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Pawafikire Yerusalemu, Insa akingira nNyumba Takatifu, akanza kuwatuwisa wanu wacuruzi na wajire kuuza wakiwa nkati mure. Akipindula-pindulanga meza za wanu wakikakanya mizuruku, na viti vya wanu wacuruzi wa mapomba. ");
INSERT INTO wmw_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Amwasire anta munu mmoja kutwala kinu ca biashara nNyumba Takatifu mure. ");
INSERT INTO wmw_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ikisa Insa akanza kuwafunda, akiwambira javi: “Vyandikiwa kuwa, ‘Nyumba yangu ikuja kwitiwa Nyumba ya duwa ka wanu wa mataifa piya’, sinovyo? Falakini mupindula mutenda kuwa jonga ra wevi!” ");
INSERT INTO wmw_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Na wakulungwa wa dini pamoja na wanlimu wa shariya wakinsikira, wakimopa, wakanza kupanga namuna za kumulaya. Wakimopa konta wanu vikiwajibu pakulu vyakiwafunda vire. ");
INSERT INTO wmw_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Paifikire jironi, Insa na wanafunzi ware wakilawa kaya ulu ire. ");
INSERT INTO wmw_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ewo pawapitire subuu wawona nfigu ure umiliye mizipe na mizipe. ");
INSERT INTO wmw_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Peduru akikumbukira akimwambira Insa javi: “Mwanlimu! Ona, nfigu waulanire ure umiliya nfululu!” ");
INSERT INTO wmw_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Basi, Insa akiwajibu, akamba: “Ntumainini Mwenyezimungu! ");
INSERT INTO wmw_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nukwambirani kweli asowerera onse ewu mwango‑wu kwamba, ‘Siwuka, urefye mbahari!’ bila kuwa na dana mmoyo, fala akamini casowera‑co cikuna, novyo na ápata. ");
INSERT INTO wmw_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ndimana nukwambirani kila camulebela kwa duwa conse, tumainini kuwa múpata, na cikuwa cenu. ");
INSERT INTO wmw_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Na pamulebela duwa, mukiwa na ngorofi na munu, kwanza nswamiini ipate na Baba wenu ari mbinguni novyo akuswamiini madambi yenu”. ");
INSERT INTO wmw_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Sambi, wakija tena Yerusalemu. Insa paakenenda nNyumba Takatifu, wakulungwa wa dini, na wanlimu wa shariya, pamoja na wazee wakinjira kusowera naye. ");
INSERT INTO wmw_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Wakindairi: “Evi vyautenda‑vi kwankutenda kwa mamulaka a nani? Au nani akupere mamulaka a kutenda evi vinu‑vi?” ");
INSERT INTO wmw_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Insa akiwambira: “Omi nukudairini kinu kimoja‑ci. Mukinijibu, nukwambirani anipere mamulaka a kutenda vyanitenda‑vi. ");
INSERT INTO wmw_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yahaya akoza na mamulaka a nani? A binguni au a wanadamu? Aya nijibuni!” ");
INSERT INTO wmw_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Wakikaidiyana watupu, wakamba: “Tikamba ‘a binguni’, iye akwamba: ‘Sambi mbena amumwaminire?’ ");
INSERT INTO wmw_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Na tikamba ‘alawa ka wanadamu’ ”, kusema kweli, awamarize cawakiwaza kamana wakiwopa wanu konta piya wakintula Yahaya kuwa nabii wakweli. ");
INSERT INTO wmw_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Wakinjibu Insa, wakamba: “Atijiwa.” Basi Insa akiwambira: “Wala omi sukwambirani anipa mamulaka a kutenda vyanitenda‑vi.” ");
INSERT INTO wmw_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ikisa Insa akanza kuwambira nkinyume, akamba: “Ákiwapo mwananlume mmoja kâvyala uva. Akijengera sereka akizunguriza, na akisimba mahala pakuminyira uva zire, na akijenga nnara. Ikisa masamba are akiwemisira warimi wamojawapo, akilawa akuka inti nyengine. ");
INSERT INTO wmw_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Paafikire mavuno, kantuma ntumisi wake ka warimi kure akapewe visumo vyake. ");
INSERT INTO wmw_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Fala warimi ware wankola ntumisi ire, wamwibiya, wakintuwisa akiludi makono-waka. ");
INSERT INTO wmw_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Na tena akimpereka ntumisi mwengine, na iye wakimpanja nkiswa, wakintukana-tukananga. ");
INSERT INTO wmw_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Akimpereka mwengine, ewo wakimulaya. Na wengine tena wengi wawenye wâtumiwe wakibiiwa au wakiulaiwa. ");
INSERT INTO wmw_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Akibaki munu mmoja tu basi, mwanawe wakumpenda pakulu. Mwinshoni akimpereka noire, akidaniza javi: ‘Nikimpereka mwanangu‑yu wamwishimu.’ ");
INSERT INTO wmw_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Fala warimi ware wakambirana watupu wakamba: ‘Eyu ndi mwana aja kuriti! Tukeni timulaye, mali‑ya tiriti ofwe.’ ");
INSERT INTO wmw_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Basi wakinkola, wakimulaya, wakimwefya nyuma ya mpaka wa masamba are. ");
INSERT INTO wmw_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Sambi, mwenye masamba are atenda mwaja? Iye akuja mwanyewe, awolaya piya warimi‑wo, na masamba‑wo awemisira wanu wengine. ");
INSERT INTO wmw_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Amufyomire novi nkati ya Mandiko? Kuwa javi: ‘Riwe rawakatare wajengi rilawirira kuwa riwe maalumu pakulu. ");
INSERT INTO wmw_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Kinu‑ci cilawa ka Mola, matajabisa kwetu kuwona javi!’ ” ");
INSERT INTO wmw_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Wakulungwa wa Mayahudi wakisaka wanfunge Insa fala wakopa junudi ya wanu; kweli, wereriwa kuwa ewo ndi warimi wabaya mana a ewu usowezi wa kinyume‑wu. Basi, wakimwasa, wakuka vyawo. ");
INSERT INTO wmw_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ikisa, wakulungwa wa Mayahudi wawatuma Mafarizeu wamojawapo na wa kinya Herodi wakapate kunkoresa kwa usowezi. ");
INSERT INTO wmw_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Nakufika ka Insa, wamwambira javi: “Mwanlimu, tikwijiwa kuwa kwa múkweli, aakuyeri munu kamana aunang'aniza munu caari. Kusema kweli kwankufunda njira ya Mwenyezimungu. Iwapo haki kunripa nsoko Kaisari au aipo? Tijuzi au atijuzi kunripa?” ");
INSERT INTO wmw_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Fala iye kwa kwijiwa unafiki wawo, kawambira javi: “Mbana mwankuniyerera? Njoni nawo jarajara moja niwone.” ");
INSERT INTO wmw_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Wakija nawo. Iye akiwambira: “Uso‑wu na mandishi‑ya vyanani?” Ewo wakijibu: “Vya Kaisari.” ");
INSERT INTO wmw_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Na Insa akiwambira: “Basi, vya Kaisari, mpeni Kaisari, na vya Mwenyezimungu, mpeni Mwenyezimungu!” Ewo wakintajabu pakulu futi. ");
INSERT INTO wmw_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ikisa, wakija Masaduseu, wenye kusema kuwa akupo kufufuka wafwi suku ya kiyama. Wakindairi javi: ");
INSERT INTO wmw_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Mwanlimu, Musa katandikira kuwa ikiwa munu kafwa nduye, kamwasa nkawake sapongore naye, nduye ajuzi anjemele nankweli‑yo apongore naye alunge rikolo ra mufwi‑yo. ");
INSERT INTO wmw_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Sambi, wákiwapo wana saba. Mwana ntanzi kâlomba, kafwa aawasire wana. ");
INSERT INTO wmw_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Nduye anfulate akinlomba nankweli ire, na iye novyo kafwa aapongore naye. Kinu kimoja noco cinkuna mwana watatu, ");
INSERT INTO wmw_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","mpaka mwana wasaba. Kusema kweli, wana wo‑saba wafwa sawapongore naye. Mwinsho, na muka ire neye akifwa. ");
INSERT INTO wmw_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ona, suku ya kufufuka wafwi, wakija wakiinshi tena, aja kuwa nlumake ndi wepi? Konta piya wo‑saba wanlomba muka mmoja noyo!” ");
INSERT INTO wmw_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Insa akiwajibu: “Umwe mukosa kwa kutowa kwijiwa Mandiko wala uwezo wa Mwenyezimungu, sikweli? ");
INSERT INTO wmw_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Kamana pawaja kufufuka wafwi, awaja kulomba wala kulombiwa, fala wakuwa kamba malaika a binguni. ");
INSERT INTO wmw_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Fala kuhusu wafwi waja kufufuriwa, amufyomire nkitabu ca Musa kuhusu fukutu, namuna Mwenyezimungu vyaasowere naye akamba: ‘Omi ndi Mwenyezimungu wa Iburahima, na wa Izaki, na wa Yankubu.’ ");
INSERT INTO wmw_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Basi, iye ndi Nlungu wa wanu wari hai, siyo Nlungu wa wafwi. Ndimana, umwe muteseka pakulu!” ");
INSERT INTO wmw_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Mwanlimu mmoja wa shariya, paasikire wakikaidiyana, kwa kuwona kuwa kawajibu sana, akidairi javi: “Ámuri bora pakulu ndi yepi?” ");
INSERT INTO wmw_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Insa akinjibu: “Ámuri bora pakulu ndiyi: ‘Sikirizani, wanu wa Iziraeli! Mola Mwenyezimungu wetu ndi Mola mmoja tu basi. ");
INSERT INTO wmw_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Mpende Mola Nlungu wako kwa myoyo wako piya, na roho yako piya, na ankili zako piya, na nguvu zako piya.’ ");
INSERT INTO wmw_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Na yapiri bora pakulu ndiyi: ‘Mpende mwenziwo kamba vyauripenda mwanyewe.’ Aipo tena ámuri bora pakulu ya kupunda ezi mbiri‑zi!” ");
INSERT INTO wmw_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Mwanlimu wa shariya akamba: “Vyema, mwanlimu! Kusowera kweli pawambire kuwa Nlungu mmoja tu basi, aapo mwengine. ");
INSERT INTO wmw_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Na tijuzi timpende kwa myoyo piya, kwa ankili piya, kwa nguvu piya, na tijuzi tiwapende majirani kamba vyatiripenda ofwe wanyewe. Ndi bora pakulu koliko kulavya kafara piya zamuriwe nkati ya shariya.” ");
INSERT INTO wmw_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Insa kejiwa kuwa mwananlume ire kereriwa vyema, ndimana akimwambira: “Uwe auri baidi ya ufalume wa Mwenyezimungu.” Mwanzo wa noparepare, aawerepo tena wakushubutu kundairi kinu. ");
INSERT INTO wmw_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Insa akiwambira kuno akiwafunda nNyumba Takatifu, kadairi javi: “Wanlimu wa shariya wambaja kuwa Almasihi ujukulu wa Daudi? ");
INSERT INTO wmw_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Daudi mwanyewe kwa uwezo wa Roho Takatifu kaamba: ‘Mola kamwambira Mwenye wangu: “Ikala upande wangu wa nkono nriro mpaka niwature maaduwi wako sini ya kumaulu kwako.” ’ ");
INSERT INTO wmw_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ona, ikiwa Daudi kamwita ‘Mwenye’, sambi akuwa ujukulu wake mwaja?” Basi wanu wengi wakiwa radi kunsikiriza Insa. ");
INSERT INTO wmw_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Insa akizidi kuwafunda wanu, akamba: “More-moreni na wanlimu wa shariya! Ewo kuwajibu kupita wakenenda wavarire anzu ulu‑ulu, na kukomaziwa ka inshima pakulu mmaluwanja. ");
INSERT INTO wmw_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Watondola kwikala mahala bora mmasinagoga na mmajambo. ");
INSERT INTO wmw_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Visitoshe, wakapira mmanyumba a manankweli. Ikisa, wakenekeza kufisa ubaya wawo julu ya kutenda duwa nrefu-nrefu. Ewo wakuja kuhukumiwa pakulu futi.” ");
INSERT INTO wmw_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Wakati mwengine, Insa kekala Nnyumba Takatifu mbere ya uralu wa kupereka swadaka. Iye akiwatunza wanu ware vyawapereka nzuruku pauralu pare. Matajiri wengi wakipereka nzuruku mwingi-mwingi. ");
INSERT INTO wmw_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ikisa, akija nankweli mmoja masikini, akipereka jarajara mbiri, nzuruku aba javi. ");
INSERT INTO wmw_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Insa akiweta wanafunzi wake, akiwambira: “Nukwambirani kweli kuwa nankweli masikini ire kapereka nzuruku mwingi koliko piya wanu wengine. ");
INSERT INTO wmw_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Konta ewo wapereka turuka yawabakire nawo. Fala iye, na usikini wake, kapereka piya cawere nawo, ankiba yake yakurya.” ");
INSERT INTO wmw_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Insa pakilawa nNyumba Takatifu, mwanafunzi wake mmoja akimwambira: “Mwanlimu! Ngawona mawe‑ya na manyumba‑ya vyaari makulu-makulu!” ");
INSERT INTO wmw_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Insa akimwambira: “Uwe uwona manyumba makulu-makulu‑ya? Kusema kweli, aribaki‑pa anta riwe rimoja julu ya riwe saribomoriwe.” ");
INSERT INTO wmw_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Sambi Insa ekare pamwango wa Mizaituni mbere ya Nyumba Takatifu, Peduru na Yakobu na Yahaya pamoja na Andere wakisowera naye kiriziu, wakindairi: ");
INSERT INTO wmw_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Tambire, evi vinu‑vi vikuja kukuna rini? Pavisaka kutimiziwa, alama yake ndi yepi?” ");
INSERT INTO wmw_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Insa akanza kuwajibu: “Onani asukuteseni munu! ");
INSERT INTO wmw_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Kwa zina rangu omi, wengi wakuja kwamba: ‘Omi ndi Almasihi’, na wengi wakiwatesa. ");
INSERT INTO wmw_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Pamusaka kusikira vita na matisho a vita, musisusuke. Siti vikune novyo, fala siyo kuwa ifika suku ya Kiyama. ");
INSERT INTO wmw_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Kamana kabila moja ikuja kutenda vita na kabila nyenziwe, na ufalume mmoja ukuja kushambuliyana na ufalume mwengine. Cikuja kuwepo kitikansi mahala mumojawapo, na njala. Evyo vinu-vyo ndi mwanzo wa malwazo akupongola.” ");
INSERT INTO wmw_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Kuhusu umwe, roperezeni wanyewe! Kamana wakuperekani mbere ya tiribunali, na nkati ya masinagoga mukuja kwibiwa. Mukuja kulongoperiwa mbere ya maguvirinadoru na mafalume kwa sababu yakunifulata omi, muwe mashahidi mbere yawo. ");
INSERT INTO wmw_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Savinakuna piya-vyo, ibidi kwanza Habari Ngema wereziwe wanu wa mataifa piya. ");
INSERT INTO wmw_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Wakati wawasaka kukuperekani mmakono mwa mafalume, musishugulike na camusaka kwamba. Kila usowezi usaka kukujirani nowo wakati‑wo, sowerani nowo. Kamana sumwe musowera, asowera ndi Roho Takatifu. ");
INSERT INTO wmw_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Nowo wakati‑wo, munu ampereka nduye akaulaiwe, wawa ampereka mwana, na wana wakuja kuwazungunukira wawa zawo, kuwolaisa. ");
INSERT INTO wmw_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Na mukuja kukimisa mbere ya wanu piya kwa sababu ya zina rangu. Fala mwenye kuhitamili mpaka mwinsho akuja kuvushiwa.” ");
INSERT INTO wmw_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Mukiwona kinu cakofya mahala sapajuzi kuwa, (afyóma onse ereriwe sana-sana), basi waYudeya wajuzi watuwirire kumyango, ");
INSERT INTO wmw_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","na ári patarado asisuke wala asingire nnyumba mwake kulavya kinu. ");
INSERT INTO wmw_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Na ári masamba, asiludire ukaya kutwala anta zubãu yake. ");
INSERT INTO wmw_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Dambi nozo suku‑zo ka waka wamimba na wakujijisa. ");
INSERT INTO wmw_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Lebelani duwa ipate evi vinu‑vi visikune mirongo ya baridi, ");
INSERT INTO wmw_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","konta nozo suku‑zo zikuja kuwepo tabu zakofya pakulu sazinalawirira tangu Mwenyezimungu pombire duniya‑yi mpaka sambi‑pa, sazija kuwepo tena. ");
INSERT INTO wmw_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kusema kweli, inawa Mola aapungure nozo suku‑zo, ásivushiwe munu anta mmoja. Fala, kwa sababu ya watomoriwe waawatondore iye, Mwenyezimungu kapungula nozo suku‑zo. ");
INSERT INTO wmw_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ikisa, ikiwa munu kakwambirani: ‘Mmoneni, Almasihi ndiyu‑pa’, au ‘Almasihi kawa pare’, musikubali! ");
INSERT INTO wmw_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Konta wakuja kulawirira maAlmasihi sawari wakweli na minabii walongo. Ewo wakidiri kutenda alama za maajuza akutajabisa ipate wakenekeze kuwatesa, ikikidirika, anta na wanu watomoriwe na Mwenyezimungu nnewo. ");
INSERT INTO wmw_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kwa javyo, onani! Ndi canukulaizireni savinamba kukuna piya vinu!” ");
INSERT INTO wmw_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Insa akizidi kusowera: “Fala bandi ya ezo suku za tabu‑zo, juwa rifungiwa kukwinukala na mwezi auwala. ");
INSERT INTO wmw_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Julu zikugwa nondwa, na viyumbe vya nguvu vya mbinguni vikuja kutetema. ");
INSERT INTO wmw_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ikisa, piya wanu wammona Binadamu wa Binguni akisuka mmawingu na uwezo nkulu na utukufu. ");
INSERT INTO wmw_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Na iye awapereka malaika wawajumanise wanu waawatondore wa membe nne za ulumwengu nzima‑wu.” ");
INSERT INTO wmw_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Insa akiwambira: “Rifundeni ngano ya nfano wa mmongo. Vitambi vikisipuka vikarika, mukwijiwa kuwa kinja ciwa karibu. ");
INSERT INTO wmw_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Nomwe ndi novyo, mukiwona vikikuna novyo, ijiwani kuwa wakati wa kuludi Almasihi uwa karibu. ");
INSERT INTO wmw_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nukwambirani kweli kuwa visaka kuwa vyonse, acipita eci kizazi‑ci savikunire evyo vinu-vyo piya. ");
INSERT INTO wmw_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Bingu na ardhi vyanawo mwinsho, fala usemi wangu auna mwinsho!” ");
INSERT INTO wmw_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Sambi, kuhusu suku‑yo au ora‑yo, aapo ejiwa; wala malaika wa mbinguni wala Mwana awejiwa, ila Baba ndi ejiwa. ");
INSERT INTO wmw_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","More-more, rinang'anizireni kamana amwijiwa nowo wakati‑wo! ");
INSERT INTO wmw_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ndi kamba nlume asafirire; sanamba kulawa ukaya, iye kawapa ámuri watumisi wake kazi yaajuzi kukola kila munu. Kampa, novyo, ámuri nakola wa nryango, annang'anizire kuludi kwake. ");
INSERT INTO wmw_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Basi, muwe tayari! Umwe amwijiwa suku ya kuludi mwanyewe nyumba. Dalili aludi jironi au nsana au alufajiri au subuu. ");
INSERT INTO wmw_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Musiriziuke kukusinganani mularire, pasaka kuja salaize. ");
INSERT INTO wmw_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Vyanukwambirani‑vi, nankuwambira wanu piya: ‘Rinang'anizireni!’ ” ");
INSERT INTO wmw_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Zibaki suku mbiri kufika Suku ya Pashukwa na Jambo ra Mikate Saitaiwe Furumento. Walongozi wa dini pamoja na wandishi wakisakula namuna ya kuntesa Insa ipate wankore wamulaye. ");
INSERT INTO wmw_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Fala wakambirana watupu: “Wakati‑wo aifãi kutenda javyo kwa sababu ya ngigiri wa wanu.” ");
INSERT INTO wmw_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Insa paákiwa Betaniya nnyumba mwa Ansumani camagundula, kekala ákirya, akija mwanamuka mmoja, asukure numba ngema ya mafuta akunuwira sana, akuuziwa beyi gali futi. Akifungula kiziwiro, akimmiminira Insa nkiswa. ");
INSERT INTO wmw_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Noparepare wanu wengine wakimiwa pakulu sana, wakamba: “Konta ya kinani mwanamuka‑yu kwaribu sheru ya beyi gali‑yi? ");
INSERT INTO wmw_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Nanga iuzanyiwa jarajara miya natu, nzuruku‑wo wapewe masikini.” Wakinduguda pakulu futi mwanamuka ire. ");
INSERT INTO wmw_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Fala Insa, akiwambira: “Mwaseni mwanamuka‑yu salama, musinkimwise. Iye katenda vyema kwangu omi. ");
INSERT INTO wmw_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Kamana masikini daima wawa pamoja namwe, pamusaka ponse muwasaidiya. Fala omi amuwa nami daima. ");
INSERT INTO wmw_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Iye katenda cawere nawo, kalongoza fúti kunipaka mwiri wangu mafuta akuniwira nikazikiwe. ");
INSERT INTO wmw_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Omi nukwambirani kweli, duniya‑yi piya paisaka kwereziwa Habari Ngema ponse, vikuja kwereziwa vyaatendire mwanamuka‑yu ipate akumbukiriwe.” ");
INSERT INTO wmw_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Yuda Shikariyoti, mwanafunzi mmoja nkati ya kumi na wawiri, koka ka wakulungwa wa dini ampereke Insa. ");
INSERT INTO wmw_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Pawasikire, ewo wafurahi pakulu futi, wakimpa tamaa ya kumpa nzuruku. Basi, Yuda akanza kupanga namuna ngema ya kumpereka Insa. ");
INSERT INTO wmw_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Suku ya mwanzo wa Jambo ra Mikate Saitaiwe Furumento, (suku ya Mayahudi yawakilavyanga kafara), wanafunzi wake wandairi javi: “Ndepi pausaka tikakutengezere jambo ra Pashukwa urye?” ");
INSERT INTO wmw_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Basi, Insa akiwatuma wanafunzi wawiri, akiwalaizira javi: “Ukani kaya ire; munsingana mwananlume mmoja asukure nringi wa maji. Munfulate noyo, ");
INSERT INTO wmw_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","na nyumba yasaka kwingira, mumwambire mwenye nyumba‑yo javi: ‘Mwanlimu katumiza kudairi kaamba: Nsana wa wayeni wanisaka kutendera Pashukwa na wanafunzi wangu ndi wepi?’ ");
INSERT INTO wmw_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Iye akoloterani nsana nkulu pagorofa, na vinu piya visakikana. Basi, titengezereni nomo jambo ra Pashukwa.” ");
INSERT INTO wmw_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Sambi, wanafunzi wakuka kukaya kure, wakisingana piya kamba Insa vyawambire, newo wakitengeza jambo ra Pashukwa nomure. ");
INSERT INTO wmw_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Paifikire jironi akija pamoja na ware kumi na wawiri. ");
INSERT INTO wmw_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Na pawarinamire pameza wakirya, Insa akiwambira: “Nukwambirani kweli, kati yenu umwe murya nami-pa-mwe, mmojawapo anitendera husuma.” ");
INSERT INTO wmw_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ewo wakiuzunika pakulu futi, mmoja-mmoja akanza kundairi: “Unamba omi? Sinovyo?” ");
INSERT INTO wmw_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Insa akiwajibu: “Kati ya kumi na wawiri-mwe, ari kutovyezera nkate nfinga nnomi mmojawapo. ");
INSERT INTO wmw_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Kamana, Binadamu wa Binguni akuka kamba vyaasema Mandiko kuhusu iye. Fala dambi munu wakuwa julu yake, Binadamu atenderiwa husuma! Vyema vyake, fadari anatowa kupongoriwa!” ");
INSERT INTO wmw_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Pawakirya, Insa akitwala nkate, akishukuru, akimeya, akiwapa, akamba: “Twalani, ewu ndi mwiri wangu.” ");
INSERT INTO wmw_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ikisa akitwala kikombe ca vinyu, akishukuru, akiwapa, piya wakinywa nocire. ");
INSERT INTO wmw_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ikisa akiwambira: “Eyi ndi damu yangu alama ya miyadi ya kupatana, itawanyike ka wanu wengi. ");
INSERT INTO wmw_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nukwambirani kweli kuwa vinyu sishubutu kunywa tena mpaka suku yanisaka kunywa nyipya muufalume wa Mwenyezimungu.” ");
INSERT INTO wmw_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ikisa ewo wakimba rimbo ra swifa, wakilawa, wakuka mpaka kumwango wa Mizaituni. ");
INSERT INTO wmw_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ikisa, akiwambira wanafunzi wake: “Piya-mwe mukuja kunitipuka. Kamana Mandiko akwamba: ‘Omi nilumiza Nsunga, makondoo wakuja kwasikana!’ ");
INSERT INTO wmw_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Falakini bandi ya kufufuriwa, nilongorera Galileya.” ");
INSERT INTO wmw_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ila Peduru akimwambira: “Anta piya wakutipuke fala omi sishubutu kukutipuka!” ");
INSERT INTO wmw_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Insa akimwambira: “Ona, Peduru! Nukwambira kweli kuwa usiku wa rero‑wu, kábula kokoriko saanawika mara mbiri, unikana mara natu.” ");
INSERT INTO wmw_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Fala Peduru akikenekezera akamba: “Anta painibidi kufwa pamoja nowe, sishubutu kukukana.” Na piya wakamba novyo. ");
INSERT INTO wmw_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ikisa wakija mahala pakwitiwa Getisemani, akiwambira wanafunzi wake javi: “Ikalani nopa, kuno nikilebela duwa.” ");
INSERT INTO wmw_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Akiwasukula Peduru, Yakobu pamoja na Yahaya. Insa akanza kufazaika pakulu na umwijala uzuni, ");
INSERT INTO wmw_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","akiwambira: “Moyo wangu ukafilika pakulu karibu ya kufwa. Ikalani nopa muninang'anizire.” ");
INSERT INTO wmw_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Iye akuka mbere aba, akigwira pansi, akilebela duwa kuwa ikikidirika, tabu ire ilaviwe wakati noure. ");
INSERT INTO wmw_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Akamba javi: “Baba wangu, kwako uwe piya vikidirika. Tenda fadili, nilavye eci kikombe ca tabu‑ci. Visikune vyanisaka ila vyausaka uwe.” ");
INSERT INTO wmw_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ikisa akiludira ka wanafunzi wake, fala kawasingana wakilala. Basi akimwambira Ansumani Peduru: “Mwaja, Ansumani? Kwankulala? Aukidiri kunang'anizira ora mmoja tu basi? ");
INSERT INTO wmw_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Rinang'anizireni na lebela duwa ipate musiyereriwe. Moyo uwa tayari, ila mwiri ndi mwepepe.” ");
INSERT INTO wmw_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ikisa Insa akitanuka tena, akuka akilebela duwa, akiludira kwamba usemi mmoja nowo. ");
INSERT INTO wmw_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ikisa akiludi mara nyengine, akiwasingana wanafunzi wakilala, konta maso awaremera usingizi, awakijiwa anta cakunjibu. ");
INSERT INTO wmw_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Insa akija mara yatatu, akiwambira javi: “Mungari mukilala kupumula? Toshekani! Ufika wakati: Binadamu wa Binguni aperekiwa mmakono mwa wamádambi. ");
INSERT INTO wmw_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Lamukani, tuke vyetu. Onani, asaka kunitendera husuma kafika futi.” ");
INSERT INTO wmw_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Kwa mpunde noure, Insa kuno akisowera, akifika Yuda, mwanafunzi mmoja nkati ya kumi na wawiri. Kalongozana na wanu wengi wasukula maupanga na mipweke. Akilawa ka wakulungwa wa dini na wanlimu wa shariya pamoja na wazee. ");
INSERT INTO wmw_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Na ire akintendera husuma kâsikizana nawo eyi alama‑yi: “Wanisaka kumpa beju onse, ndi noyo. Nkoreni, muke naye munrimbise.” ");
INSERT INTO wmw_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ewo nakufika kawenye, Yuda akimukira Insa, akimwambira: “Mwanlimu!” Noparepare akimpa beju. ");
INSERT INTO wmw_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ikisa, wengine ware wakinkola makono, wakinfunga. ");
INSERT INTO wmw_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Fala munu mmoja kati ya noware akisolola upanga, akinduru ntumisi mmoja wa nkulu wa wakulungwa wa dini, akinsinja sikiro rake. ");
INSERT INTO wmw_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Insa akiwadairi wanu ware javi: “Omi niwa kisomi? Sababuni kunijira na maupanga na mipweke kunifunga? ");
INSERT INTO wmw_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Daima‑zi tíkiwa onse nNyumba Takatifu nikifunda, fala amunifungire. Evi vyankukuna ipate vitimiziwe vyaandikiwe mMandiko.” ");
INSERT INTO wmw_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Noparepare wanafunzi piya nakumwasa, wakintira. ");
INSERT INTO wmw_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Na nnemba mmoja akinfulata Insa nyuma yake. Iye kavala ntunda mwiri wanzu, wakinkola. ");
INSERT INTO wmw_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Iye akasa nguwo yaavarire, akituwa diki rabana, akuka vyake. Ku! ");
INSERT INTO wmw_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ikisa wakintwala Insa wakuka naye ka nkulu wa wakulungwa wa dini; na wakijumana wakulungwa wa dini, na wazee pamoja na wanlimu wa shariya. ");
INSERT INTO wmw_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Peduru akinfulata Insa aba-aba mpaka pengire panryango wa luwani ra nyumba ya nkulu wa wakulungwa wa dini. Iye kekala pamoja na watumisi akota moto. ");
INSERT INTO wmw_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Walongozi wakulu wa dini na wanu wengine wa Baraza ya Milandu, wákisakula ushahidi wakumpa makosa Insa ipate wahukumu kifo, fala awapatire. ");
INSERT INTO wmw_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Kamana wengi wakereza ushahidi wa ulongo na ushahidi wawo auwaringanire. ");
INSERT INTO wmw_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Wengine wakilamuka, wakilavya ushahidi wa ulongo, wakamba: ");
INSERT INTO wmw_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ofwe tinsikira akamba javi: ‘Omi nidangula Nyumba Takatifu ijengiwe na wanadamu‑yi na kwa muda wa suku natu, níjenga nyengine, saijengiwe na makono a wanadamu.’ ” ");
INSERT INTO wmw_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Wala javyo, ushahidi wawo auwaringanire. ");
INSERT INTO wmw_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ikisa nkulu wa wakulungwa wa dini akimira kati-kati, akindairi Insa, akamba: “Vinu vyawakubunira‑vi, aujibu kinu kimojawapo? Wambani?” ");
INSERT INTO wmw_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Fala iye akinyamala, aajibire kinu. Basi, nkulu wa wakulungwa wa dini akindairi tena: “Uwe ndi Almasihi, Mwana wa Mwenyé kusifiwa?” ");
INSERT INTO wmw_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Insa akijibu: “Ndi nomi. Mukuja kummona Binadamu wa Binguni ekare nkono nriro wa mwenye uwezo piya. Ikisa akija mmawingu a binguni.” ");
INSERT INTO wmw_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Nkulu wa wakulungwa wa dini akipapula anzu yake, akamba: “Ushahidini watisakula tena? ");
INSERT INTO wmw_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Musikira kukufuru kwake! Epa muwazaja?” Basi piya wanu ware wakilamula ahukumiwe kifo. ");
INSERT INTO wmw_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Noparepare, wengine wakanza kunsunira na wakinfinika kumaso, wakimwibiya kuno wakimwambira: “Aya, bushuru!” na watumisi novyo wampokerera na malatuma. ");
INSERT INTO wmw_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Sambi, Peduru kékala pansi nluwani. Akija mwanamuka mukazi wa nkulu wa wakulungwa wa dini, ");
INSERT INTO wmw_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","akimmona Peduru akota moto, akimmanyira akimwambira: “Uwe úkiwa pamoja na Insa nNazareti!” ");
INSERT INTO wmw_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Fala iye akikana akamba: “Sijiwa wala sereriwa vyawamba-vyo.” Akilawira panja akingira nkitala. ");
INSERT INTO wmw_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Mukazi ire nakummona, tena akiwambira wakiwa nopare ware: “Eyu novyo nkonjo wawo mmoja.” ");
INSERT INTO wmw_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Falakini iye akinkana mara nyengine tena. Nakupita wakati aba, wákiwa nopare ware wakimwambira Peduru javi: “Kweli-kwelini uwe nkonjo wenu mmoja, kamana uwe novyo kuwa nGalileya.” ");
INSERT INTO wmw_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Fala iye akanza kunlani kuno akilapira akamba: “Simwijiwa‑mi mwananlume wamumwamba‑yo.” ");
INSERT INTO wmw_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Mpunde sinkulu, kokoriko akiwika mara ya piri. Kwa mpunde noure, Peduru akikumbukira vyambiriwe na Insa javi: “Saanawika kokoriko mara mbiri, uwe ukuja kunikana mara natu.” Iye akikola kuwaza akanza kurira. ");
INSERT INTO wmw_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Pakucere subuu namapema, wajumana wakulungwa wa dini na wazee na wanlimu wa shariya, pamoja na piya wanu wa Baraza ya Milandu ipate wanuwiye vyawasaka kuntenda Insa. Ikisa wakinfunga, wakintwala, wakuka wakimpereka ka Pilatu. ");
INSERT INTO wmw_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilatu akindairi Insa javi: “Uwe kuwa nfalume wa Mayahudi?” Insa akijibu akamba: “Uwe‑po kusema futi.” ");
INSERT INTO wmw_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ikisa, wakulungwa wa dini wambunira Insa vinu vingi vyawenye. ");
INSERT INTO wmw_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilatu akindairi tena akamba: “Uwe aujibu kinu? Ona! Vyengapi vyawakubunira!” ");
INSERT INTO wmw_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Fala Insa aajibire kinu, mpaka Pilatu akitajabu. ");
INSERT INTO wmw_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Sambi, kila sherehe ya Pashukwa Pilatu akinfungula nfunga mmoja wawakinlebela onse. ");
INSERT INTO wmw_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ákiwepo nfungwa mmoja akitiwa Baraba. Iye ákiwa nkati ya wafungwa wabishi wôlaye. ");
INSERT INTO wmw_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ikifika junudi ya wanu ware, wakinlebela Pilatu atende kamba vyaikiwa tabiya yake. ");
INSERT INTO wmw_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Basi, Pilatu akiwadairi: “Musaka ninfungure nfalume wa Mayahudi?” ");
INSERT INTO wmw_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Kamana akijiwa kuwa wakulungwa wa dini wampereka Insa konta ya kuntendera wiyana. ");
INSERT INTO wmw_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Fala wakulungwa ware wawashongezera wanu wanlebele Pilatu kuwa anfungure Baraba. ");
INSERT INTO wmw_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Sambi, Pilatu akiwajibu tena akiwambira javi: “Camusaka nukutendereni eyo wamumwita nfalume wa Mayahudi‑yo ndi cepi?” ");
INSERT INTO wmw_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Wanu wakikuwa tena: “Ngomezereni!” ");
INSERT INTO wmw_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Falakini Pilatu akiwadairi: “Noyu catendire cakunyata ndi cepi?” Ewo wakikuwa tena: “Ngomezereni!” ");
INSERT INTO wmw_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Basi, Pilatu kwa kusaka kutenda viwajibu wanu ware, akiwafungurira Baraba. Ikisa akitumiza Insa acapiwe viboko, mwinsho akiwagabizi masurudadu wakangomezere. ");
INSERT INTO wmw_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Masurudadu ware wakintwala Insa mpaka nnyumba ya kifalume, nyumba itendiwe kuwa ya kulamula milandu, wakilarikana kipinga ca masurudadu piya. ");
INSERT INTO wmw_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Wakinvaza Insa vazi ra rangi ya njambalãu, na wakitenda ata ya muti wa miwa, wakinvaza nkiswa. ");
INSERT INTO wmw_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ikisa, wakinkomaza kwa kunkejeli: “Mashikamu, nfalume wa Mayahudi!” ");
INSERT INTO wmw_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ewo wakimpanja na mpweke nkiswa, wakinsunira mata, na wakikokora mbere yake wakimwabudu. ");
INSERT INTO wmw_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Pawesire kunshupa, wakinvula kapa ra rangi ya njambalãu rire, wakinvaza nguwo zake; ikisa wakintwala, wakúka naye wakagomezere. ");
INSERT INTO wmw_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Sambi, mwananlume mmoja wakwitiwa Ansumani wa Kireni, wawaye Alishandere na Rufo, akipita akilawa masamba, wakinlazimisha asukure nsalaba. ");
INSERT INTO wmw_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Wakintwala Insa mpaka mahala pakwitiwa Gologota, mana ake “Kongolo ra Kiswa”. ");
INSERT INTO wmw_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Wakimpa vinyu yakusanganyiwa na kinywaji ca kusambala, fala iye aanyuwere. ");
INSERT INTO wmw_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ikisa wakingomezera pansalaba, na wakawanyirana nguwo zake. Wâtenda kura wejiwe kila munu baraka yake casaka kutwala. ");
INSERT INTO wmw_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Wakati wawangomezere íkiwa novi ora ya subuu. ");
INSERT INTO wmw_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Na mandiko a vitendo vyaabuniriwe wakandika javi: “NFALUME WA MAYAHUDI”. ");
INSERT INTO wmw_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Na pamoja naye wakigomezeriwa wevi wawiri, mmoja nkono nriro na mwengine nkono sonto. ");
INSERT INTO wmw_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Wanu wákipita mahala pare wákinsowerera masowezi akufuru, kuno wakintikinyira kiswa, wakamba: “He, adangula Nyumba Takatifu na ajenga upya muda wa suku natu! ");
INSERT INTO wmw_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Basi, rivushe, wisuke pansalaba‑po!” ");
INSERT INTO wmw_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Walongozi wakulu wa dini pamoja na wanlimu wa shariya newo novyo wakinshupa Insa, wakambirana watupu: “Kawavusha wenziwe fala iye mwanyewe aakidiri kurivusha! ");
INSERT INTO wmw_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Almasihi, nfalume wa Mayahudi, esuke sambi‑pa pansalaba‑po tiwone na tikubali.” Anta na wagomezeriwe nawo ware, newo novyo wakintukana. ");
INSERT INTO wmw_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Mwanzo wa aduhuri, kunja piya kwinukala pi, zipita ora natu. ");
INSERT INTO wmw_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Paifikire alhanswiri, Insa akikuwa, akamba: “Elohi, Elohi, lama sabakitani?”, mana ake “Nlungu wangu, Nlungu wangu, sababuni kunitipuka?” ");
INSERT INTO wmw_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Wanu wengine nopare, pawasikire, wakamba: “Mmoneni, kankumwita Aliyasi.” ");
INSERT INTO wmw_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Munu mmoja akituwa, akilovya shiponja nvinagiri, akisomeka mmuti, akimpa Insa afyonje. Ikisa akamba: “Mwaseni, timmone kamba Aliyasi‑yo akuja kunlavya!” ");
INSERT INTO wmw_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Fala Insa akirama, akisa roho. ");
INSERT INTO wmw_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Na pazira ya Nyumba Takatifu ikipapuka kati-kati perr, kulawa julu mpaka pansi. ");
INSERT INTO wmw_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Nkulungwa wa kipinga ca masurudadu emire mbere yake, pawonire namuna vyaafwire, akamba: “Kweli-kwelini eyu mwananlume‑yu ákiwa Mwana wa Mwenyezimungu!” ");
INSERT INTO wmw_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Wákiwapo novyo wanawaka wêkala baidi wakiwona. Kati yawo ákiwapo Mariyamu Madalena, na Mariyamu (mamaye Yakobu ntoto na nyenyeye wakwitiwa Yose), pamoja na Salome. ");
INSERT INTO wmw_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ewa wákiwa waka wamoja Insa pakenenda Galileya wakinfulatanga wakipita wakinsaidiya, na wengine wengi wampereka mpaka Yerusalemu. ");
INSERT INTO wmw_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Paifikire jironi, kwa kuwa vitengeziwa ikirindiriwa suku ya sabadu, ");
INSERT INTO wmw_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","akija Yusufu kwawo Arimataya. Iye ákiwa mwananlume wakwinshimika pakulu, ákiwa mBaraza ya Milandu. Neye novyo akirindira ufalume wa Mwenyezimungu. Akirimba moyo, akuka ka Pilatu, akinlebela mwiri wa Insa ure. ");
INSERT INTO wmw_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilatu pasikire kuwa Insa kafwa, akitajabu pakulu. Ndimana akitumiza kumwita nkulungwa wa kipinga ca masurudadu, akindairi kuwa kafwa mida? ");
INSERT INTO wmw_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pasoweriwa na nkulungwa wa kipinga ca masurudadu kuwa Insa kafwa, Pilatu akimpa Yusufu rihusa maiti are agabiziwe. ");
INSERT INTO wmw_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yusufu akiuza kafani, akilavya maiti wa Insa akikafini. Ikisa akuka akizika nkaburi risivu njonga. Akipiringisa riwe rikulu, akiziwa panryango wa kaburi rire. ");
INSERT INTO wmw_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mariyamu Madalena pamoja na Mariyamu mamaye Yose, wakitunza mahala pazikiwe Insa pare. ");
INSERT INTO wmw_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Paipitire suku ya sabadu, Mariyamu Madalena na Mariyamu mamaye Yakobu, pamoja na Salome wakuka wakiuza mafuta akunuwira wakapake maiti a Insa. ");
INSERT INTO wmw_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Pakucere subuu namapema, juwa nero rikilawa, suku yakwanza ya sumana, ewo wakija kukaburi kure. ");
INSERT INTO wmw_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Munjira mure wakambirana watupu javi: “Epa oka kutavya kupiringisa riwe rituriwe panryango wa kaburi rire nani?” ");
INSERT INTO wmw_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Nakunang'aniza mbere, wawona riwe rire ripiringisiwa, nero ríkiwa rikulu pakulu futi. ");
INSERT INTO wmw_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Basi, wakingira nkaburi mure. Wammona nnemba mmoja ekare upande wa nkono nriro, kavala mavazi melupa vú, wakisusuka pakulu futi. ");
INSERT INTO wmw_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Fala iye akiwambira javi: “Musisusuke! Mwankunsakula Insa nNazareti agomezeriwe pansalaba ire. Iye kafufuka ka wafwi, emu aapo! Nang'anizani mahala pawanturire‑po. ");
INSERT INTO wmw_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Epa ukani, mukawambire wanafunzi wake pamoja na Peduru, kuwa iye katangurira Galileya. Umwe mukuka kunsingana noko mummona, kamba iye vyâkwambireni.” ");
INSERT INTO wmw_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Wanawaka ware walawa nkaburi mure, wakituwa, kuno wakitetema. Washanga pakulu futi, wala awamwereze munu kinu kamana wakopa. ");
INSERT INTO wmw_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Insa kafufuka ka wafwi subuu namapema suku yakwanza ya sumana. Iye kanza kunlawirira Mariyamu Madalena, âtuwisiwe mashetwani saba. ");
INSERT INTO wmw_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ware wakiwanga pamoja na Insa, wari nkati ya uzuni wakirira, Mariyamu akuka akiwambira. ");
INSERT INTO wmw_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ewo, pawansikire kuwa Insa kawa hai na iye kammona, awankubalire. ");
INSERT INTO wmw_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Airini vikuna tena, Insa karolota ka wanafunzi wawiri, ari na sura nyengine. Ewo walongozana munjira wakuka nvitongojo. ");
INSERT INTO wmw_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ewo nakulawa wakuka wakiwambira wengine, anta newo novyo awakubalire. ");
INSERT INTO wmw_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Mwinsho, Insa karolota ka wanafunzi kumi na mmoja warinamire pameza wakirya. Akiwasutumu kutowa kwamini kwawo na ugumu wa myoyo yawo kamana awawakubalire wanu wammonire bandi yakufufuriwa. ");
INSERT INTO wmw_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ikisa akiwambira javi: “Enendani duniya nzima‑yi, mupite mukereza Habari Ngema‑yi kwa kila munu mulumwengu‑mu piya. ");
INSERT INTO wmw_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Mwenye kwamini na akoziwa, avushiwa. Fala munu akatala kwamini, ahukumiwa. ");
INSERT INTO wmw_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Na wenye kwamini wakuwa nawo alama kamba ezi: kwa zina rangu omi, wawatuwisa mashetwani, wasowera luga nyipya, ");
INSERT INTO wmw_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","wankola nyoka, na wakunywa kinywaji cisaka kuwa conse ca kusambala awawengiwa. Na walwere wakiwatula makono, wapona.” ");
INSERT INTO wmw_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Basi, Mwenye Insa pesire kusowera nawo, akitwariwa akipanda mbinguni, akikala nkono nriro wa Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","wo nakulawa pare wakipita wakereza kila upande, na Mwenye Insa akiwasaidiya, kwa kwitikizira usowezi julu ya alama zikifulata.");
INSERT INTO wmw_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Mwenshimiwa Tiyofilu, ndi kweli kuwa wanu wengi watenda kazi yakutunga waraka kuhusu mwaha wa vire vitimiziwe kati yetu, ");
INSERT INTO wmw_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","sawa‑sawa vyawatereze mashahidi na watumisi wa usemi wawawonire tangu mwanzo. ");
INSERT INTO wmw_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Na kwa kuwa omi suku nyingi nikitunza mwaha‑wu, niwona kuwa vyema omi novyo nukwandikire kwa namuna ngema, ");
INSERT INTO wmw_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ipate kuhusu vinu vyaufundiwe wijiwe ukweli. ");
INSERT INTO wmw_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herodi paákiwa nfalume wa Yudeya, ákiwapo nlongozi mmoja wa dini wakwitiwa Zagariya, ákiwa nkundi ra Abiya. Nkawake akitiwa Zabeli, njukuluwe Aruna. ");
INSERT INTO wmw_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zagariya na Zabeli wo‑wawiri wákiwa wenye shariya mbere ya Mwenyezimungu, ewo wátimiza bila ukosa shuruti na ámuri piya za Mola. ");
INSERT INTO wmw_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Falakini awapongore konta Zabeli ákiwa nata, na wo‑wawiri woluvala pakulu futi. ");
INSERT INTO wmw_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Suku moja, Zagariya ákiwa pakazi ya kulongoza dini mbere ya Mwenyezimungu, ifika suku ya kutumika kundi rake. ");
INSERT INTO wmw_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Kwa kufulata tabiya ya walongozi wa dini, ítendiwa kura akitondoriwa. Kwa javyo iye akingira nNyumba Takatifu ya Mola, ataye lubani. ");
INSERT INTO wmw_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Sambi, wanu wengi piya wakilebela duwa panja, wakati wakutaya lubani ure. ");
INSERT INTO wmw_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Kwa mpunde noure, Zagariya mbere kanlawirira laika wa Mola, kamwimira upande wa nkono nriro wa kashoti maalumu parikifukiziwanga lubani. ");
INSERT INTO wmw_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zagariya nakummona, akisusuka, ukimwingira wofi pakulu futi. ");
INSERT INTO wmw_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Fala laika ire akimwambira javi: “Usope kinu, Zagariya! Konta Mwenyezimungu kasikira vyaunlebele. Nkawako Zabeli akupongorera mwana nlume, ujuzi umwite zina ra Yahaya. ");
INSERT INTO wmw_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Na ukuja kuwa radi pakulu na kuriwona, na wanu wengi novyo wakuja kuwa radi kwa kupongoriwa kwake. ");
INSERT INTO wmw_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Kamana iye akuja kuwa nkulu mbere ya Mwenye Nvushi, aaja kushubutu kunywa vinyu wala kirevi kikali. Akuja kumwijala Roho Takatifu tangu mmatumbo mwa mamaye. ");
INSERT INTO wmw_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Iye waIziraeli wengi akuja kuwaludisira ka Mwenye Nvushi, Nlungu wawo. ");
INSERT INTO wmw_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Iye akuja kulongorera mbere yake na roho pamoja na uwezo wa Aliyasi, ipate myoyo ya kuuwáwa iwaludire wana wawo, na wabishi awaludisire wijiwifu wa wenye shariya. Kwa javyo, antengezere Mwenye Nvushi umati uwe tayari.” ");
INSERT INTO wmw_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Basi Zagariya akindairi laika ire: “Nukwijiwa kuwa kweli mwaja? Omi nuluvala na nkawangu novyo kapongoriwa mida na midada.” ");
INSERT INTO wmw_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Laika ire kanjibu javi: “Omi niwa Jiburilu, nikwimira mbere ya Mwenyezimungu. Nitumiwa nije nisowere nawe nukwambire evi vinu‑vi. ");
INSERT INTO wmw_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ona, kwa kuwa aukubali usowezi wangu uja kutimiziwa noyo suku‑yo, mwanzo wa rero‑vi unyamala nduu, nukwambira kweli-kwelini ausowera mpaka pavisaka kukuna.” ");
INSERT INTO wmw_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Wanu ware wakinrindira Zagariya, wakishanga konta mahala bora nNyumba Takatifu mure kákawa. ");
INSERT INTO wmw_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Mwinsho palawire mure, aakidirire kusowera tena na wanu ware. Akisowera nawo kibubu, newo wereriwa kuwa îmwisukira ruhuya mmojawapo mahala bora nNyumba Takatifu mwaakiwa mure. Na iye akizidi kuwa bubu. ");
INSERT INTO wmw_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Pazitimire suku za kazi zake, Zagariya akiludi akuka kwake. ");
INSERT INTO wmw_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Pazipitire suku zire, nkawake Zabeli akimita, akikala nnyumba muda wa myezi mitanu salawira panja. ");
INSERT INTO wmw_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Zabeli akisowera, akamba: “Mola kanitenda javi suku yaanitendere fadili ipate alavye aibu yangu mbere ya wanu.” ");
INSERT INTO wmw_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Sambi, mimba ya Mariyamu paifikire myezi sita, Mwenyezimungu akinpereka laika Jiburilu kaya ulu ya Nazareti, porovinsiya ya Galileya, ");
INSERT INTO wmw_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","akasowere na mwari apofiwe na mwananlume wakwitiwa Yusufu, ujukulu wa nfalume Daudi. Mwari‑yo akitiwa Mariyamu. ");
INSERT INTO wmw_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Laika akinfika, akimwambira javi: “Salama! Uwe kujanliiwa pakulu sana! Mola kawa pamoja nawe!” ");
INSERT INTO wmw_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Nakusikira usowezi ure javire, iye imwingira wasi-wasi, akiridairi kimoyomoyo, akamba: “Mámá! Kunidairi salama javi, mana ake kinani?” ");
INSERT INTO wmw_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Basi, laika ire akimwambira: “Mariyamu, usope kinu, konta Mwenyezimungu kakutendera fadili! ");
INSERT INTO wmw_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ona, ukwimita, umpongola mwana nlume, mwana‑yo ujuzi umwite Insa. ");
INSERT INTO wmw_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Iye akuja kuwa munu bora pakulu, na akuja kwitiwa Mwana wa Mwenye Nkulu. Mwenyezimungu Mola wetu akuja kumpa kiti ca wawaye Daudi. ");
INSERT INTO wmw_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Na akuja kuwatawala ujukulu wa Yankubu kwa milele, na ufalume wake aauna mwinsho.” ");
INSERT INTO wmw_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mariyamu akindairi laika ire: “Nipongolaja? Nomi sinamba kumwijiwa nlume!” ");
INSERT INTO wmw_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Laika ire akinjibu, akamba: “Roho Takatifu akwisukira, na uwezo wa Mwenye Nkulu ukufinika na kinviri cake. Ndimana, wauja kumpongola‑yo takatifu, akuja kwitiwa Mwana wa Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ona, jamaa yako Zabeli, iye novyo kamwimita mwana nlume ingawa koluvala. Akitíwa nata, ewu mwezi‑wu wasita emíte. ");
INSERT INTO wmw_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Konta ka Mwenyezimungu, acipo kinu cakunzaidi.” ");
INSERT INTO wmw_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Basi, Mariyamu akamba: “Kweli-kwelini, omi niwa ntumisi wa Mola. Vikune kamba vyaunambire-vyo.” Ikisa, laika ire akilawa akuka vyake. ");
INSERT INTO wmw_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Nozire suku zire, Mariyamu akilawa, akuka upesi-upesi, upande mmoja uri myango kaya ya Yudeya, ");
INSERT INTO wmw_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","akingira nnyumba ya Zagariya, wakidairiyana habari na Zabeli. ");
INSERT INTO wmw_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Zabeli, nakusikira shauti ya Mariyamu paandairire habari, mwanawe mmatumbo mure katupa, na Zabeli kamwijala Roho Takatifu. ");
INSERT INTO wmw_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Akimwambira pakulu-pakulu, akamba: “Uwe ndi ujanliiwe pakulu kuwapunda wanawaka piya! Ajanliiwe ndi wauja kumpongola mmatumbo mwako‑yo! ");
INSERT INTO wmw_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Vyakuja kwangu omi kuwoniwa na mama wa Mwenye wangu namunani? ");
INSERT INTO wmw_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ona, panisikire shauti yako, kwa mpunde nowo, mwanangu mmatumbo mwangu katikinyika kuwa radi! ");
INSERT INTO wmw_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Heri ire akubali kuwa vitimiziwe visemiwe kwake upande wa Mola!” ");
INSERT INTO wmw_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Sambi, Mariyamu akamba: “Moyo wangu unkurisa Mola! ");
INSERT INTO wmw_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Roho yangu iwa radi kwa Mwenyezimungu, Nvushi wangu. ");
INSERT INTO wmw_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Kamana kanang'aniza unyenyekevu wa ntumisi wake. Kweli, mwanzo wa sambi‑pa, vizazi piya wanita wakujanliiwa, ");
INSERT INTO wmw_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","kamana Mwenyé Uwezo kanitendera vinu vikulu pakulu! Takatifu ndi zina rake! ");
INSERT INTO wmw_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Rehema yake izidi vizazi ka vizazi ka wenye kumopa. ");
INSERT INTO wmw_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Kâtenda uwezo na nkono wake! Kâwatawanya waridãi kati ya mawazo a myoyo yawo. ");
INSERT INTO wmw_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Kâwesusa wenye uwezo nviti vyawo, kâwakweza wenye kurinyenyekeya. ");
INSERT INTO wmw_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Wenye njala kâwejaza vinu vyema-vyema, matajiri kâwatuwisa makono waka. ");
INSERT INTO wmw_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Kânsaidiya Iziraeli ntumisi wake julu ya kukumbukira huruma yake, ");
INSERT INTO wmw_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","kamba tamaa yawapere wababu zetu, Iburahima na ujukulu wake mpaka milele.” ");
INSERT INTO wmw_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mariyamu akikala na Zabeli kiyasi ca myezi mitatu, ikisa akiludira kwawo. ");
INSERT INTO wmw_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Sambi, Zabeli wakati wakupongola ufika, neye kampongola mwana nlume. ");
INSERT INTO wmw_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Majirani na jamaa wasikira kuwa Mwenyezimungu kantendera huruma pakulu Zabeli, wafurahi naye pakulu sana. ");
INSERT INTO wmw_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Paifikire suku yanane, ewo wakija wakintaya itani toto ire. Wasaka kumwita zina ra wawaye, Zagariya, ");
INSERT INTO wmw_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","fala mamaye akijibu, akamba: “Anta, zina rake Yahaya.” ");
INSERT INTO wmw_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ewo wakinjibu: “We! Aapo jamaa yako anta mmoja wakwitiwa ero zina‑ro!” ");
INSERT INTO wmw_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Newo wakindairi kibubu wawaye mwana ire zina rakisaka etiwe. ");
INSERT INTO wmw_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zagariya akilebela kipande ca kibawo kitoto, akandika javi: “Zina rake Yahaya.” Piya ware wakibaki wakushanga wawenye. ");
INSERT INTO wmw_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Kwa mpunde noure, kanywa yake ikifunguriwa, lulimi rake rikisowera, akinsifu Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Majirani wakisusuka na vyawawonire vire. Kaya piya za upande wa kumyango ya Yudeya zikisoweriwa habari za evi vinu vikunire‑vi. ");
INSERT INTO wmw_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Na piya wanu wasikire wakitula mmyoyo mwawo, wakamba: “Noyu mwana‑yu akuja kuwa nani? Kamana nkono wa Mola uwa pamoja neye.” ");
INSERT INTO wmw_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zagariya, wawaye toto ire, kamwijala Roho Takatifu, noparepare akanza kubushuru javi: ");
INSERT INTO wmw_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Atukuziwe Mola, Nlungu wa Iziraeli, kamana kawawona na kawavusha wanu wake. ");
INSERT INTO wmw_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Iye katilamusira Nvushi wa uwezo, ujukulu wa ntumisi wake Daudi, ");
INSERT INTO wmw_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","kamba vyaasowere tangu mida julu kanywa za minabii wake matakatifu. ");
INSERT INTO wmw_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Katilamusira eyu Nvushi‑yu ativushe upande wa maaduwi wetu na mmakono mwa piya wenye kutina. ");
INSERT INTO wmw_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Javyo, kawolotera huruma wababu zetu, na kukumbukira tamaa yake takatifu, ");
INSERT INTO wmw_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","kulapa kalapire ka babu yetu Iburahima. ");
INSERT INTO wmw_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Akimpa tamaa yakutivusha mmakono mwa maaduwi ipate tintumike bila wofi, ");
INSERT INTO wmw_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","kwa utakatifu na ukamilifu mbere yake suku zetu piya. ");
INSERT INTO wmw_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Uwe, mwanangu, ukwitiwa nabii wa Mwenye Nkulu, kamana ulongorera mbere ya Mwenye untengezere njira yake, ");
INSERT INTO wmw_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","wanu wake uwafahamu kuhusu kuvushiwa, julu ya kuswamiiwa dambi zawo. ");
INSERT INTO wmw_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Nlungu wetu atenda javyo kwa sababu ya wema wa huruma yake. Ndimana, nuru ya binguni itisukira ofwe, ");
INSERT INTO wmw_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","tiwamwarikire wari pakisi, wekala kinviri ca kifo, ilongoze maulu etu njira ya usalama.” ");
INSERT INTO wmw_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Kisimana Yahaya ire akikula na akongezeka nguvu ya kiroho. Kekala nlanga mpaka suku ya kurolota kwake mbere ya waIziraeli. ");
INSERT INTO wmw_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Nozire suku zire, ílawa ámuri ya Kaisari Agustu wakambiriwa wanu piya kila upande wandikiwe mazina awo wawalangiwe. ");
INSERT INTO wmw_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","(Eyi ndi íwere mara yakwanza kuwalangiwa wanu, wakati Kirinu waákiwa guvinadoru wa Siriya.) ");
INSERT INTO wmw_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Wanu piya kila mmoja ákuka kuryandikisa kaya yawo yapongoriwe. ");
INSERT INTO wmw_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Sambi, Yusufu neye akilawa Galileya, kaya ya Nazareti, akuka Yudeya kaya ya nfalume Daudi yakwitiwa Betlehemu, kwa kuwa ndi rikiwa rikolo rake, ");
INSERT INTO wmw_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ipate akandikiwe pamoja na Mariyamu, muka wampofire ncumba wake, wakati‑wo ari na mimba. ");
INSERT INTO wmw_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Pawakiwa Betlehemu kure, ukifika wakati wakupongola Mariyamu. ");
INSERT INTO wmw_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Basi, akimpongola toto nlume, mwanawe ntanzi. Akinzingiriza munguwo, akintandikira ngamela konta nnyumba ya wayeni aawerepo mamburo akufikira. ");
INSERT INTO wmw_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Noure upande ure, wakiwapo wasunga, wakiinshi nlanga wakiwasunga makondoo awo usiku. ");
INSERT INTO wmw_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Noparepare, akiwesukira laika wa Mola, basi nuru ya utukufu wa Mola ikiwazunguriza, wakopa pakulu futi. ");
INSERT INTO wmw_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Laika ire akiwambira javi: “Musope! Omi nukwerezani Habari Ngema yakukutayani radi pakulu, pamoja na wanu piya. ");
INSERT INTO wmw_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Rero, kaya ulu ya Daudi, mupongoreriwa Nvushi, iye ndi Almasihi, Mwenye wenu. ");
INSERT INTO wmw_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Eyi ndi alama yenu: munsingana toto kazingiriziwa munguwo, katandikiriwa ngamela.” ");
INSERT INTO wmw_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Kwa mpunde noure, ulawirira pamoja na laika ire nkonjo wa malaika wengi wakulawa binguni. Piya wakintukuza Mwenyezimungu, wakamba javi: ");
INSERT INTO wmw_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Atukuziwe Mwenyezimungu ari julu bingu ya mwinsho! Mulumwengu‑mu wanu wakufadiliwa wawe na salama!” ");
INSERT INTO wmw_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Malaika ware pawalawire wakúka mbinguni, ikisa wasunga ware wakambirana watupu: “Tukeni Betlehemu, tikawone mambo ákunire, aari kutijiwisa Mola.” ");
INSERT INTO wmw_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Basi, wakipita wakangupa mpaka ukaya, wakinsingana Mariyamu na Yusufu pamoja na toto ire atandikiriwe ngamela. ");
INSERT INTO wmw_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Bandi ya kummona, wasunga ware wakikola kuwambira wanu usemi wawâmbiriwe kuhusu toto ire. ");
INSERT INTO wmw_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Wanu piya wasikire watajabu vyawakambiriwa na wasunga ware. ");
INSERT INTO wmw_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mariyamu vyaakisikira vire piya akitaya nkiswa, na kila mara akikumbukira mmoyo mwake. ");
INSERT INTO wmw_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Wasunga ware wakiludi, wakintukuza na wakinsifu Mwenyezimungu kwa piya vyawasikire vire na vyawawonire, vikuna sawa‑sawa kamba vyawereziwe. ");
INSERT INTO wmw_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Toto ire patimire suku nane, wantaya itani, wamwita zina ra Insa, zina raâsemire laika kábula sanamba kwimitiwa. ");
INSERT INTO wmw_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ikisa, wakati wazitimiziwe suku za kuswafiwa kwawo kamba vyairi shariya ya Musa, Yusufu na Mariyamu wakwera naye Yerusalemu, wakanture mbere ya Mola, ");
INSERT INTO wmw_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","kamba vyailazimu shariya ya Mola javi: “Kila mwana nlume ntanzi kupongoriwa ajuzi awe takatifu ka Mola!” ");
INSERT INTO wmw_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Na wakilavya kafara kamba vyailazimu shariya ya Mola: “Wanjiwa wawiri muka na nlume, au wana wawiri wakadiri wa mapomba.” ");
INSERT INTO wmw_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ona, nowo wakati‑wo kaya ya Yerusalemu akikalanga mwananlume mmoja wakwitiwa Simiyoni. Noyu mwananlume‑yu ákiwa kamilifu na akimwabudu Mwenyezimungu. Iye akirindira kunyamaziwa Iziraeli, na kamwijala Roho Takatifu. ");
INSERT INTO wmw_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Na Roho Takatifu kâmwambira kuwa iye aafwa sammonire Almasihi aperekiwe na Mola. ");
INSERT INTO wmw_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Kwa kulongoziwa na Roho Takatifu, Simiyoni akuka mpaka kuNyumba Takatifu. Wawaye na mamaye Insa, pawakingira na mwana ire wakatende vyaisaka tabiya ya shariya yawo vyaapongoriwe mwana ire, ");
INSERT INTO wmw_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simiyoni akinsukula toto ire mmakono, akintukuza Mwenyezimungu, akamba: ");
INSERT INTO wmw_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Mwenye Mola, kamba vyaunipere tamaa, epa sambi layana nami nuke vyangu kwa salama! ");
INSERT INTO wmw_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Konta maso angu awona kuvusha kwako, ");
INSERT INTO wmw_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","kauwatengezere mbere ya wanu piya. ");
INSERT INTO wmw_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Iye ndi nuru yakufafanuriwa wanu Sawari-Mayahudi, na ndi utukufu wa wanu wako, waIziraeli.” ");
INSERT INTO wmw_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Wawaze Insa ware washanga pakulu vyaakisowera Simiyoni kuhusu Insa. ");
INSERT INTO wmw_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ikisa, Simiyoni akiwajanliya, akimwambira Mariyamu, mamaye Insa javi: “Kweli, eyu mwana‑yu katondoriwa kuwagwisa na kuwalamusa wanu wengi Iziraeli. Na iwe alama ya kukaidi wanu, ");
INSERT INTO wmw_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ipate afafanuriwe mawazo a myoyo mingi. Na upanga upita ukwingira mmoyo mwako novyo.” ");
INSERT INTO wmw_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ákiwapo nopo nabii mmoja muka wakwitiwa Ana, mwana wa Fanuweli wa rikolo ra Aseri. Iye kôluvala pakulu. Tangu harusi yake, kainshi myaka saba, nlumake akifwa. ");
INSERT INTO wmw_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Kekala ari nankweli mpaka myaka tamanini na mine. Iye aakilawa Nnyumba Takatifu, akambudu julu ya kufunga na kulebela duwa usiku na nsana. ");
INSERT INTO wmw_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ana kalawirira noure wakati Simiyoni waakisowera na wawaze Insa ure. Neye novyo akanza kuntukuza Mwenyezimungu, na akisowera kuhusu toto ire ka wanu piya wakirindira kuvushiwa ka Yerusalemu. ");
INSERT INTO wmw_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Pawesire shuguli zire piya kamba vyaisema shariya ya Mola, ewo wakiludira kwawo Galileya mpaka Nazareti kawakikala. ");
INSERT INTO wmw_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Kisimana ire akikula na akikomala, na umwijala wijiwifu. Na fadili ya Mwenyezimungu ikiwa pamoja naye. ");
INSERT INTO wmw_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Piya myaka‑yi, wawaze Insa wâkukanga Yerusalemu kujambo ra Pashukwa. ");
INSERT INTO wmw_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Insa paafikire myaka kumi na miwiri, ewo wakuka noko kamba vyaikiwa tabiya yawo. ");
INSERT INTO wmw_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Pawatimize jambo‑ro, Yusufu na Mariyamu wakitwala njira wakiludira ukaya. Nnemba Insa akibaki Yerusalemu nokure, fala wawaze sawejiwe. ");
INSERT INTO wmw_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ewo wakidaniza kuwa kalongozana na nkonjo wa wenziwe. Watenda safari kutwa nzima, wakipita wakinsakula mwa wajamaa zawo na wanu wakuwejiwa. ");
INSERT INTO wmw_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Pawatowire kunsingana, wakiludi wakuka Yerusalemu, kupita wakinsakula. ");
INSERT INTO wmw_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Bandi ya suku natu wansingana nNyumba Takatifu, kekala pamoja na wanlimu, akiwasikiriza vyawakamba na vyengine akiwadairi. ");
INSERT INTO wmw_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Piya wanu wakinsikira wakintajabu werevu na majibu ake. ");
INSERT INTO wmw_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Wawaze ware pawammonire, wabaki wanshangire, sambi mamaye akimwambira javi: “Mwanangu, mbana kutitenda javi? Mmone, wawayo‑yu nomi novyo tifazaika pakulu tankukusakula nowe.” ");
INSERT INTO wmw_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Insa akiwajibu: “Munisakurirani? Amwijiwa kuwa nijuzi nishugulukire mwaha wa Baba?” ");
INSERT INTO wmw_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Fala ewo awereriwe vyaambire vire. ");
INSERT INTO wmw_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Iye pamoja na wawaze wakiteremuka, wakiludira Nazareti, na iye akizidi kuwasikiriza. Na mamaye piya vire akitula sana-sana mmoyo mwake. ");
INSERT INTO wmw_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Basi, Insa akizidi kukula na wijiwifu, akikula ujunda, na akizidi kuwa na fadili za Mwenyezimungu pamoja na wanu. ");
INSERT INTO wmw_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Mwaka wa kumi na ntanu wa kutawala ka Kaisari Tiberiya, ndi wakati Pontiyu Pilatu wákiwa guvinadoru wa Yudeya, Herodi ari nfalume wa Galileya, Filipi nduye Herodi ari nfalume wa inti za Itureya na Tarakoniti, Lisaniya ari nfalume wa Abileni, ");
INSERT INTO wmw_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","na Anasi na Kayafa wari wakulu wa wakulungwa wa dini. Nowo wakati‑wo, usemi wa Mwenyezimungu ukimwisukira Yahaya mwana wa Zagariya ari nlanga. ");
INSERT INTO wmw_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Iye kapita inti piya zíkiwa nanyenje ya muto wa Yordani, akiwereza wanu, akamba javi: “Tubiyani, moziwe ipate Mwenyezimungu akuswamiini madambi enu.” ");
INSERT INTO wmw_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Evi ndi kamba vyavyandikiwe nkitabu ca nabii Izaya javi: “Munu mmojawapo kawankukuwa nlanga, kankwamba: ‘Tengezani njira mumpokerere Mwenye Nvushi, olosani barabara yake. ");
INSERT INTO wmw_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Mirati piya ikwijala, myango na makinga piya vyandaziwe, mwa kupombonyoka molosiwe, muri mawe mubambadiwe. ");
INSERT INTO wmw_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Na wanu piya wakuja kuwona kuvusha ka Mwenyezimungu.’ ” ");
INSERT INTO wmw_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Wanu wákuka kwake wakóziwe, Yahaya akiwambira javi: “Kabila ya mirába sumwe! Nani akukumbuseni kutira hukumu ya Mwenyezimungu suku zambere? ");
INSERT INTO wmw_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Lavyani visumo vyema vyakolóta kutubiya kwenu. Wala musambe mmyoyo yenu: ‘Tiwa nawo wawa yetu, ndi Iburahima.’ Kamana nukwambirani kuwa anta na eya mawe‑ya, Mwenyezimungu akidiri kutadula kuwa ujukulu wa nabii Iburahima! ");
INSERT INTO wmw_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Epa sambi‑pa, soka riwa panzipe wa muti, tayari kutupula. Kwa javyo, kila muti saupa visumo vyema usinjiwa, ukwefiwa pamoto.” ");
INSERT INTO wmw_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Wanu ware wakindairi, wakamba: “Sambi, catijuzi kutenda kinani?” ");
INSERT INTO wmw_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yahaya akiwajibu, akisema javi: “Ári na zubãu mbiri alavye mmoja, ampe mwenziwe saana. Ári nawo cakurya, kwa namuna moja, alavye ammere mwenziwe.” ");
INSERT INTO wmw_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Na waja novyo warípisi nsoko wamojawapo kusakula koziwa. Ewo wakindairi Yahaya: “Mwanlimu, ofwe tijuzi titende kinani?” ");
INSERT INTO wmw_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Iye akiwajibu: “Musiripise kinu tena kupundisa vyamwamuriwe.” ");
INSERT INTO wmw_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Masurudadu newo novyo wakindairi javi: “Sambi ofwe, tíjuzi titende kinani?” Yahaya akiwajibu, akamba: “Musinyang'anye munu nzuruku, wala musinlongopere kinu. Muwe radi na nshahara wenu.” ");
INSERT INTO wmw_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Wanu piya wakinrindira kuja Almasihi, wakiwaza mmyoyo yawo kuwa dalili Yahaya, wakamba: “Fala iye si Almasihi?” ");
INSERT INTO wmw_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Novyo-sivyo, Yahaya akiwambira wanu ware piya: “Kusema kweli, omi nukozani na maji, fala akuja mwengine wanguvu pakulu koliko omi. Kusema kweli, omi siri bora anta wa kunvula tamango zake. Iye akozani na Roho Takatifu pamoja na moto. ");
INSERT INTO wmw_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Iye paa iwa mmakono mwake, apate kuwandala masansi na tirigu ature kwake-kwake. Ikisa tirigu‑yo ature nkikuti mwake, ila masansi ataya moto sauzimika.” ");
INSERT INTO wmw_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Basi javyo, na masowezi mengine tena, Yahaya ndi vyakiwarimbisa wanu myoyo, kuno akiwereza Habari Ngema. ");
INSERT INTO wmw_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Fala nfalume Herodi, kâsutumiwa na Yahaya kwa sababu ya vitendo vyake na Herodiza muka wa nduye, pamoja na vitendo vyakunyata piya vyaatendire, ");
INSERT INTO wmw_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","iye akamuru Yahaya afungiwe. Kwa javyo, Herodi akipambanya akizidisa makosa ake. ");
INSERT INTO wmw_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Sambi, suku moja pawesire koziwa wanu ware piya, Insa neye novyo akoziwa. Paakitenda duwa, bingu zikifunguka ");
INSERT INTO wmw_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","na Roho Takatifu akimwisukira kwa nfano wakuwoneka kamba pomba. Na ikisikirikana shauti ya kulawa mbinguni ikamba: “Uwe ndi mwanangu wanukupenda, kwako uwe niwa nawo radi pakulu!” ");
INSERT INTO wmw_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Insa paanzire kazi zake ákiwa na kiyasi ca myaka talatini. Akijiwikana kamba mwana wa Yusufu. Yusufu ákiwa mwana wa Heli, ");
INSERT INTO wmw_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli mwana wa Matati, Matati mwana wa Lawi, Lawi mwana wa Melki, Melki mwana wa Yana, Yana mwana wa Yusufu, ");
INSERT INTO wmw_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yusufu mwana wa Matatia, Matatia mwana wa Amosi, Amosi mwana wa Nahumu, Nahumu mwana wa Eshili, Eshili mwana wa Nagayi, ");
INSERT INTO wmw_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagayi mwana wa Mahati, Mahati mwana wa Matatia, Matatia mwana wa Simeyi, Simeyi mwana wa Yoseku, Yoseku mwana wa Yoda, ");
INSERT INTO wmw_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda mwana wa Yowana, Yowana mwana wa Resa, Resa mwana wa Zorobabeli, Zorobabeli mwana wa Salatiyeli, Salatiyeli mwana wa Neri, ");
INSERT INTO wmw_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri mwana wa Meliki, Meliki mwana wa Adi, Adi mwana wa Kosamu, Kosamu mwana wa Elimadamu, Elimadamu mwana wa Eru, ");
INSERT INTO wmw_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eru mwana wa Yoshwa, Yoshwa mwana wa Elizeli, Elizeli mwana wa Yorimu, Yorimu mwana wa Matati, Matati mwana wa Lawi, ");
INSERT INTO wmw_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lawi mwana wa Ansumani, Ansumani mwana wa Yuda, Yuda mwana wa Yusufu, Yusufu mwana wa Yonamu, Yonamu mwana wa Eliyakimu, ");
INSERT INTO wmw_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakimu mwana wa Meleya, Meleya mwana wa Mena, Mena mwana wa Matata, Matata mwana wa Natani, Natani mwana wa Daudi, ");
INSERT INTO wmw_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Daudi mwana wa Yese, Yese mwana wa Obedi, Obedi mwana wa Bowazi, Bowazi mwana wa Salmoni, Salmoni mwana wa Nashoni, ");
INSERT INTO wmw_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nashoni mwana wa Aminadabu, Aminadabu mwana wa Adimini, Adimini mwana wa Arni, Arni mwana wa Hesironi, Hesironi mwana wa Paresi, Paresi mwana wa Yuda, ");
INSERT INTO wmw_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yuda mwana wa Yankubu, Yankubu mwana wa Izaki, Izaki mwana wa Iburahima, Iburahima mwana wa Tera, Tera mwana wa Nahori, ");
INSERT INTO wmw_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahori mwana wa Serugi, Serugi mwana wa Rehu, Rehu mwana wa Pelegi, Pelegi mwana wa Eberi, Eberi mwana wa Sala, ");
INSERT INTO wmw_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala mwana wa Kenani, Kenani mwana wa Aripakisadi, Aripakisadi mwana wa Shemu, Shemu mwana wa Nnu, Nnu mwana wa Lameki, ");
INSERT INTO wmw_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lameki mwana wa Metusela, Metusela mwana wa Henoki, Henoki mwana wa Yaredi, Yaredi mwana wa Mahalaleli, Mahalaleli mwana wa Kenani, Kenani mwana wa Enoshi, ");
INSERT INTO wmw_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Enoshi ákiwa mwana wa Seti, Seti ákiwa mwana wa Adamu, na Adamu wa Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Insa kamwijala Roho Takatifu, akilawa muto wa Yordani. Roho Takatifu akinlongoza kulanga, ");
INSERT INTO wmw_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","mahala kayereriwe na Ibilisi muda wa suku arubaini. Kwa nowo wakati‑wo, iye aarire kinu, ndimana mwinsho ikinkola njala. ");
INSERT INTO wmw_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ibilisi kamwambira javi: “Ikiwa kuwa Mwana wa Mwenyezimungu, amuru riwe‑ri ritaduke nkate.” ");
INSERT INTO wmw_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Insa akinjibu: “Mandiko Matakatifu akwamba: ‘Wanu awainshi kwa nkate basi.’ ” ");
INSERT INTO wmw_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ikisa Ibilisi akintwala, akuka naye mahala parefu. Kwa muda aba javi, akimolotera piya ufalume wa mulumwengu. ");
INSERT INTO wmw_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ibilisi akimwambira: “Omi nukupa utukufu wa inti‑zi piya pamoja na mamulaka julu yawo kamana ewo ndi wanipereke omi, ningabizi waninsaka. ");
INSERT INTO wmw_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Kwa javyo, piya vikuwa vyako ukinabudu.” ");
INSERT INTO wmw_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Insa akinjibu javi: “Mandiko Matakatifu akwamba: ‘Ntukuze Mola Nlungu wako, untumikire noyo tu basi.’ ” ");
INSERT INTO wmw_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ikisa, Ibilisi akimpereka Insa Yerusalemu, akinkweza mahala parefu pakulu paNyumba Takatifu, akimwambira javi: “Ikiwa kuwa Mwana wa Mwenyezimungu, refyere pansi pare. ");
INSERT INTO wmw_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Kamana Mandiko akwamba: ‘Mwenyezimungu awapereka malaika wake wakukengere’, ");
INSERT INTO wmw_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","na ‘ewo wakusukula mmakono, ipate maulu ako asilumizike na mawe.’ ” ");
INSERT INTO wmw_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Insa akinjibu, akamba: “Yambiwa novyo: ‘Usimyerere Mola Nlungu wako.’ ” ");
INSERT INTO wmw_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Basi, Ibilisi paatumire namuna‑zi piya za kunyerera Insa, akintanuka Insa mpaka apate atuwa nyengine. ");
INSERT INTO wmw_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Insa, umwijare uwezo wa Roho Takatifu, akiludira Galileya. Wanu nkaya mure piya wakisowera kuhusu iye. ");
INSERT INTO wmw_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Iye akipita akifunda nmasinagoga mwawo, piya wakinsifu. ");
INSERT INTO wmw_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Insa kafika Nazareti, inti yâreriwe. Suku takatifu, kamba vyaikiwa tabiya yake, iye koka nsinagoga. Akilamuka kufyoma Mandiko Takatifu. ");
INSERT INTO wmw_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Wâmpa kitabu ca nabii Izaya. Iye nakufungula kitabu cire, kasingana mahala pakwandikiwa javi: ");
INSERT INTO wmw_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Roho wa Mola kawa julu yangu, kwa kuwa kanitawaza nikawereze Habari Ngema masikini. Kanipereka niwereze wafungiwe komboriwa kwawo, vipofu wawone tena, wenye kutabishiwa niwereze komboriwa kwawo, ");
INSERT INTO wmw_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","na niwereze kuwa ufika wakati Mola watenda fadili.” ");
INSERT INTO wmw_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ikisa, Insa akifunga kitabu cire, akimpa amiri, akikala. Wanu piya nsinagoga mure wakinang'aniza rungu-rungu. ");
INSERT INTO wmw_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ikisa akanza kuwambira javi: “Epa rero pamusikire‑pa, ewu usemi wandikiwe‑wu utimiziwa mbere yenu umwe!” ");
INSERT INTO wmw_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Piya ware wakanza kusowera vyema kuhusu Insa, wakishanga pakulu futi kwa usemi wa neema ulawirire nkanywa mwake ure. Ewo wamba: “Eyu mwananlume‑yu, simwana wa Yusufu‑yu?” ");
INSERT INTO wmw_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Insa akiwambira: “Bila shaka mukuja kusowera kinyume mukwamba javi: ‘Ntibabu, riponese mwanyewe.’ Kamba vyatisikire vyautendire Kafarnaumu, tenda novyo emu muinti mwaupongoriwe‑mu!” ");
INSERT INTO wmw_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Na akizidi kusema: “Nukwambirani kweli kuwa aapo nabii anta mmoja wakupokereriwa sana muinti mwaapongoriwe. ");
INSERT INTO wmw_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Kweli-kwelini, wakati wa Aliyasi, paitowire nvula muda wa myaka mitatu na nusu, wákiwapo manankweli wengi Iziraeli. Ipita njala ulu futi inti nzima. ");
INSERT INTO wmw_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Fala Aliyasi aaperekiwe ka manankweli‑wo anta mmoja, ila ka nankweli wa inti nyengine, akikalanga Sarepta ya Sidoni. ");
INSERT INTO wmw_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Novyo Iziraeli neko, wakati wa nabii Elisha, wákiwapo wanu wengi wawenye wamagundula. Fala hapana munu anta mmoja nkati yawo aponesiwe sairi Naamani wa Siriya.” ");
INSERT INTO wmw_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Pawansikire vinu‑vi, wanu piya nsinagoga mure wakimiwa pakulu futi. ");
INSERT INTO wmw_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Basi, wakilamuka, wakinlavira panja ya kaya ire. Wakinlongoza mpaka pamwango paijengiwe kaya ire, wakinsukumira pansi. ");
INSERT INTO wmw_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Fala Insa akiwapita kati-kati, akuka vyake. ");
INSERT INTO wmw_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Insa akilawa akúka Kafarnaumu, kaya moja ulu ya Galileya, nokurekure akifundanga suku takatifu za sabadu. ");
INSERT INTO wmw_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Wanu wakisikira vyaakifunda Insa vire wakishanga, kamana akisowera na mamulaka. ");
INSERT INTO wmw_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Suku moja nsinagoga, ákiwapo munu mmoja wa mashetwani. Iye akanza kukuwa na shauti ulu, akamba: ");
INSERT INTO wmw_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ari! Uwe Insa nNazareti, utandibirani? Sambi, kuja epa utipoteze? Omi núkwijiwa uwe, kuwa Ntakatifu uperekiwe na Mwenyezimungu!” ");
INSERT INTO wmw_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Fala Insa akinsutumu shetwani ire, akamba: “Nyamala nduu! Nlawe munu‑yu!” Shetwani ire akingwisa munu ire, akinlawa bila kuntenda kinu kibaya. ");
INSERT INTO wmw_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Wanu piya wakishanga pakulu, wakambirana watupu: “Mashala! Usowezini‑wu? Awamuru mashetwani ka mamulaka na uwezo, newo walawa!” ");
INSERT INTO wmw_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Na habari kuhusu Insa zikenera kaya jirani piya za inti ire. ");
INSERT INTO wmw_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Insa palawire nsinagoga, kengira nyumba ya Ansumani. Nkwewe Ansumani ari nlwere homa pakulu futi. Wanu wakinlebela Insa amponese. ");
INSERT INTO wmw_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Basi, Insa akimwinamira karibu yake, akamuru homa ire inlawe, neyo ikinlawa. Kwa mpunde noure, iye akilamuka, akanza kuwaudumu. ");
INSERT INTO wmw_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Parititire juwa, piya wanu wákiwa na walwere wa ulwere jisijisi onse wakiwatwala wakija nawo ka Insa. Iye akintula makono pakiswa kila mmoja, akiwaponesa. ");
INSERT INTO wmw_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Novyo mashetwani wakiwalawa wanu wengi, kuno wakikuwa, wakamba: “Uwe Mwana wa Mwenyezimungu!” Fala Insa kawasutumu, aawasire kusowera, konta ewo wakijiwa kuwa iye Almasihi. ");
INSERT INTO wmw_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Pakucere subuu namapema, Insa akilawa nkaya mure, akúka akikala mahala kiriziu. Junudi ya wanu ire ikanza kupita ikinsakula. Mwinshoni wakimmona, wakintafadali asiwase. ");
INSERT INTO wmw_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Fala Insa akiwajibu: “Omi nijuzi nuke makaya mengine novyo, nikereze habari ngema kuhusu ufalume wa Mwenyezimungu, kamana ndi canitumiwe kuja kutenda.” ");
INSERT INTO wmw_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Na iye akereza mmasinagoga a Yudeya. ");
INSERT INTO wmw_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Suku moja, Insa akereza nanyenje ya tanda ra Galileya. Wanu wengi wâkinyana wansikire usemi wa Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Insa kawona ngalawa mbiri nlufuko mure. Wavuvi wêsuka, wakosa nyavu zawo. ");
INSERT INTO wmw_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Mwenyé ngalawa mmoja ákitiwa Ansumani. Insa akingira, ikisa akinlebela tena avutire aba ngalawa ire kubahari. Basi, Insa akikala nomure mungalawa mure, akanza kuwafunda wanu ware. ");
INSERT INTO wmw_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Pesire kusowera na wanu ware, kamwambira Ansumani javi: “Sambi, twala ngalawa‑yi, uke nayo parindo pare, ukataye nyavu‑zi mmaji, uvuwe inswi.” ");
INSERT INTO wmw_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ansumani akinjibu: “Mwanlimu, ofwe tivuwa usiku nzima, atipatire kinu! Fala kwa kuwa uwe kwankwamba javyo, nitaya tena nyavu‑zi.” ");
INSERT INTO wmw_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Nakutaya nyavu zire mmaji, wavuwa inswi nyingi zawenye, mpaka nyavu zawo zíre zikanza kurundumuka! ");
INSERT INTO wmw_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Wakiwapa alama wenziwawo wákiwa mungalawa nyengine woke wakawavye. Kweli, ewo wakuka wakiwavya. Wejaza inswi ngalawa zombiri mpaka ngalawa zire zíbaki aba javi kutota! ");
INSERT INTO wmw_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ansumani Peduru pawonire inswi zire, akitenga malundi mbere ya Insa, akamba: “Ha! Mwenye, nitanuke konta omi niwa mmadambi pakulu.” ");
INSERT INTO wmw_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Kamana iye kâshanga pakulu, pamoja na wenziwe ware piya, konta inswi zawápatire zíkiwa nyingi. ");
INSERT INTO wmw_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Wenziwe Ansumani wakwitiwa Yakobu na Yahaya, wana wa Zebedeyu, newo novyo washanga pakulu futi. Insa akimwambira Ansumani, akamba: “Usope! Mwanzo wa sambi‑pa mpaka mbere, uwakoresa wanu!” ");
INSERT INTO wmw_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Pawafikire kulufuko, wakikweza ngalawa zawo zire. Mpunde noure, wakasa vinu piya, wakinfulata Insa. ");
INSERT INTO wmw_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Safari moja, Insa ákiwa kaya moja, noyo kaya‑yo ákiwapo munu anyakatuka magundula, we! Munu ire nakummona Insa, akisujudi, akintafadali Insa, akamba: “Mwenye, ukisaka, kwanawo uwezo wa kuniswafi.” ");
INSERT INTO wmw_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Insa akolosa nkono, akinkumbula, akamba: “Nisaka, uwe swafi!” Mpunde noure, magundula are akimpakatika. ");
INSERT INTO wmw_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Insa akinlaizira, akamba: “Usangupe kumwambira munu, ila uka ukarolote ka nlongozi wa dini. Tenda nadiri kamba vyaalaizire Musa kwa uswafi wako, iwe ushahidi ka wanu.” ");
INSERT INTO wmw_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Fala habari kuhusu Insa kila mara ikizidi kwenera. Ndimana wanu wengi wakija kusikiriza usowezi wake, na wapate kuponesiwa ulwere wawo. ");
INSERT INTO wmw_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Fala Insa akilawa akisakula mahala kiriziu, akitenda duwa. ");
INSERT INTO wmw_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Suku moja, Insa pakiwafunda wanu, Mafarizeu wamojawapo na wanlimu wa shariya wekala karibu yake. Ewo wakilawirira mmakaya piya a Galileya na Yudeya pamoja na Yerusalemu. Uwezo wa Mwenyezimungu wakuponesa úkiwa na Insa. ");
INSERT INTO wmw_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Noparepare, wakija wanu na kitewe wansukure mmashila. Wakisakula wapite wafike paakiwa Insa, ");
INSERT INTO wmw_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","fala awakidirire kwa sababu ya wanu kuwa wengi. Basi wakikwera papala, wakibomola tijolu, wakinteremusa nlwere ire mmashila, mpaka kati-kati ya wanu mbere ya Insa. ");
INSERT INTO wmw_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Insa, paawonire kwamini kwawo, akamba: “Rafiki yangu, madambi ako aswamiiwa!” ");
INSERT INTO wmw_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Nakusikira javire, wanlimu wa shariya na Mafarizeu ware walalamika: “Noyu mwananlumeni noyu akufuru javi‑yu? Nani ajuzi kuswamii sairi Mwenyezimungu tu basi?” ");
INSERT INTO wmw_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Insa, pejiwe mawazo awo, akiwadairi: “Mbena mwankulalamika mmyoyo mwenu? ");
INSERT INTO wmw_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Cirimba kusema ndi cepi? Kwamba, ‘Madambi ako aswamiiwa’ au kwamba, ‘Lamuka, enenda’? ");
INSERT INTO wmw_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Fala ipate mwijiwe kuwa Binadamu wa Binguni kanawo mamulaka mulumwengu‑mu kuswamii madambi, nukoloterani.” Basi, Insa akimwambira kitewe ire: “Uwe nankukwambira, lamuka, usukure mashila ako‑ya, uke vyako kwenu.” ");
INSERT INTO wmw_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Kwa mpunde noure, mbere ya wanu ware piya, iye akilamuka, akisukula caatandikiriwe cire, akuka kwawo, kuno akinsifu Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Wanu piya watajabu, wantukuza Mwenyezimungu, uwapata wofi, wakamba: “Rero tiwona mambo a matajabisa!” ");
INSERT INTO wmw_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Pavisire vire, Insa nakulawa kammona mwananlume mmoja akiripisanga nsoko. Iye akitiwa Lawi, kekala mahala pake paakiripisanga nsoko. Insa akimwambira: “Nifulate!” ");
INSERT INTO wmw_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lawi akasa vinu piya, akilawa, akinfulata Insa. ");
INSERT INTO wmw_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ikisa Lawi akintendera Insa jambo rikulu pakaya pake. Nopo wákiwapo wanu wengi wakuripisa nsoko pamoja na wanu wengine pawakirya. ");
INSERT INTO wmw_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Mafarizeu na wanlimu wawo wa shariya wakiwaduguda wanafunzi wa Insa ware, wakamba: “Ewa warípisi nsoko na wamadambi‑wa, mbena mwankurya na mwankunywa nawo?” ");
INSERT INTO wmw_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Insa akiwajibu, akamba: “Wakomu awansakula dotoru, ila walwere. ");
INSERT INTO wmw_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Omi sijire kuweta wenye shariya ila wamádambi watubiye.” ");
INSERT INTO wmw_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Wanu ware wamwambira Insa: “Wanafunzi wa Yahaya wafunganga na walebelanga duwa. Wanafunzi wa Mafarizeu watenda novyo, fala wanafunzi wako wakuryanga na wakunywanga.” ");
INSERT INTO wmw_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Insa akiwajibu: “Warifiwe paharusi, filihali wari pamoja na mwenyé harusi, umwe muwafungisa? ");
INSERT INTO wmw_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ukuja kufika wakati wa kuwa mwenyé harusi alaviwa kati yawo, basi nowo wakati‑wo ndi wawaja kufunga.” ");
INSERT INTO wmw_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ikisa, Insa kawasowerera novyo kinyume, akamba: “Hapana munu apapula nguwo nyipya, kutaya kiwamba nguwo ya mida. Akitenda javyo, akwaribu nguwo nyipya, na kiwamba‑co acifãi kutaya munguwo ya mida. ");
INSERT INTO wmw_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Novyo, aapo munu ataya vinyu nyipya nnumba za mida, konta vinyu‑yo ipanja numba‑zo. Kwa javyo, vinyu ítawanyika na numba‑zo zíkwaribika. ");
INSERT INTO wmw_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Fala vinyu nyipya ijuzi itayiwe nnumba nyipya. ");
INSERT INTO wmw_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Hapana munu, bandi ya kuyeza vinyu ya mida, asaka kunywa vinyu nyipya, kamana akwamba kuwa ya mida‑yi ndi ngema pakulu.” ");
INSERT INTO wmw_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Suku mmoja sabadu, Insa na wanafunzi wake wakipita mmasamba a mafuluwela. Wanafunzi ware wákipita wakivunja mafuluwela are, wakikukurula na makono, wakitafuna. ");
INSERT INTO wmw_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Fala Mafarizeu wamojawapo wawadairi javi: “Mutenda vitendo savina shariya suku ya sabadu‑yi sababuni?” ");
INSERT INTO wmw_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Insa akiwajibu, akamba: “Tangu amunamba kufyoma Mandiko vyaamba caatendire Daudi na wanu wake paîwakorire njala? ");
INSERT INTO wmw_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Iye kengira nnyumba ya Mwenyezimungu, katwala mikate ituriwe kuwa takatifu, katafuna, na myengine kawapa wenziwe. Iye aâwere na shariya ya kutafuna, ila walongozi wa dini basi.” ");
INSERT INTO wmw_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Na Insa akamba: “Binadamu wa Binguni ndi Mwenyé wa sabadu.” ");
INSERT INTO wmw_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Vikuna suku nyengine ya sabadu, Insa kengira nsinagoga, akanza kuwafunda wanu. Nomo ákiwapo mwananlume mmoja wakumufwa nkono nriro. ");
INSERT INTO wmw_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Wanlimu wa shariya na Mafarizeu wákinnang'anizira Insa sana-sana wammone kamba amponesa suku ya sabadu, wammonerere kitendo kimojawapo ca kukosa. ");
INSERT INTO wmw_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Fala Insa akijiwa vyawakiwaza, akimwambira munu wakumufwa nkono ire javi: “Lamuka, wimire kati-kati‑po.” Munu ire akilamuka, akimira. ");
INSERT INTO wmw_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Insa akiwambira: “Nukudairini, suku ya sabadu halali kutenda kinu cema au kibaya? Eyi suku‑yi halali kunvusha munu mainsha ake, au kupoteza?” ");
INSERT INTO wmw_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Bandi ya kuzungunuka kuwanang'aniza sana wanu ware piya, iye akimwambira mwananlume ire: “Olosa nkono.” Iye akolosa, nkono ure ukipona! We! ");
INSERT INTO wmw_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Fala ewo wakikimiwa naye pakulu, wakanza kuwazisana watupu kuhusu vyakuntenda Insa. ");
INSERT INTO wmw_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Nozire suku zire, Insa akilawa, akuka kumwango kulebela duwa. Akitenda duwa kunlebela Mwenyezimungu usiku nzima. ");
INSERT INTO wmw_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Pakucere subuu, akiweta wanafunzi wake. Kati yawo akiwatondola kumi na wawiri, waawetire mawalii. Mazina awo wakitiwa javi: ");
INSERT INTO wmw_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ansumani Insa wampere zina rengine ra Peduru, Andere (nduye Peduru), Yakobu, Yahaya, Filipi, Bartolomeu, ");
INSERT INTO wmw_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matwaya, Tamimu, Yakobu mwana wa Alufeu, Ansumani wakwitiwa Zeloti, ");
INSERT INTO wmw_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yuda mwana wa Yakobu, pamoja na Yuda Shikariyoti, airini ajire akinzungunuka Insa, akimpereka ka maaduwi wake. ");
INSERT INTO wmw_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Insa kesuka nawo pamoja pamwango, akifika mahala pakuritandika sana-sana, akimira nopo azunguriziwe na wanafunzi wake wengi. Íkiwepo novyo junudi ya wanu wengi wawenye wakulawa mmakaya piya a Yudeya na a Yerusalemu, na makaya a Tiru na a Sidoni upande wa mwani. ");
INSERT INTO wmw_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Wája kunsikira Insa na wapate kuponesiwa malwazo awo. Ware wakopepesiwa na mashetwani wáponesiwa. ");
INSERT INTO wmw_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Wanu piya wakisakula wankumbure Insa, konta uwezo ukinlawa, ukiwaponesa piya! ");
INSERT INTO wmw_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ikisa, Insa kawanang'aniza wanafunzi wake, akiwambira: “Heri umwe muri masikini konta ufalume wa Mwenyezimungu ndi wenu. ");
INSERT INTO wmw_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Heri umwe muri nawo njala sambi‑pa kamana mukuja kwikuta. Heri umwe muríra sambi‑pa kamana mukuja kuseka. ");
INSERT INTO wmw_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Heri umwe wakati wanu wawakwinani, au wawakukatalani, au wawakutukanani, au vyawefya panja zina renu kamba kinu kibaya, kwa sababu ya kunfulata Binadamu wa Binguni. ");
INSERT INTO wmw_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Muwe radi suku‑yo, tupani kwa kuwa radi! Kamana thawabu yenu mbinguni ulu. Wababu zawo wawatenda minabii namuna moja novyo.” ");
INSERT INTO wmw_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Mulaniwe umwe matajiri, kamana furaha yenu mwisa kupokerera. ");
INSERT INTO wmw_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Mulaniwe umwe muri kwikuta sambi‑pa, kamana ikuja kukukolani njala. Mulaniwe umwe museka sambi‑pa kamana mukuja kurira na kurishuku. ");
INSERT INTO wmw_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Mulaniwe umwe wakati wamusifiwa na wanu piya, kamana ndi kamba wababu zawo vyawakiwatenda novyo minabii walongo!” ");
INSERT INTO wmw_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Falakini umwe muri kunisikiriza, nikwambirani javi: wapendeni maaduwi wenu, watafitini sana wenye kukuwindani. ");
INSERT INTO wmw_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Wajanliyeni wenye kukulanini, walebeleleni duwa wari kukutabishani. ");
INSERT INTO wmw_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ikiwa munu kakwibiya langu rimoja, mwasire novyo rengine akwibiye. Ikiwa munu katwala anzu yako, na galasau yako neyo usiziwiye. ");
INSERT INTO wmw_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Wakulebela onse, wamere; na ikiwa munu katwala kinu cako, usindãi kuwa akuludisire. ");
INSERT INTO wmw_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Kamba vyavikwajibuni kukukutenderani wenzenu, nomwe watendereni novyo. ");
INSERT INTO wmw_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Mukiwapenda wenye kukupendani, faidani yamurindira? Anta na wamádambi novyo wawapenda ware wawapénda ewo. ");
INSERT INTO wmw_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Mukiwatafiti vyema wenye kukutafitini vyema, faidani yamurindira? Anta wamádambi watenda novyo. ");
INSERT INTO wmw_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Mukinkopesha munu mukirindira kukuludisirani, faidani yamurindira? Anta wamádambi wawakopesha wamádambi wengine ipate waludisiriwe cawakopeshe. ");
INSERT INTO wmw_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ila wapendeni maaduwi wenu, watendeni vyema, wakopesheni bila tamaa yakukuludisirani. Kwa javyo, mupokerera thawabu ulu, mukuwa wana wa Mwenye Nkulu, kamana iye atenda meema anta ka wanu sawashukuru na wabaya. ");
INSERT INTO wmw_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Muwe na huruma kamba Baba wenu vyaari na huruma.” ");
INSERT INTO wmw_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Musilaumu, nomwe amushubutu kulaumiwa. Musihukumu, nomwe amushubutu kuhukumiwa. Waswamiini wenzenu, nomwe muswamiiwa. ");
INSERT INTO wmw_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Merani, nomwe novyo mumeriwa, kipimo cema cakusindiririwa, cakutikinyiriwa, cakupakatika, mupewa pakulu pawenye. Kamana kipimo camupimira ndi kipimo camuludisiriwa noco.” ");
INSERT INTO wmw_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Insa kawasowerera novyo kinyume cengine: “Sawawona watupu wakorerana nkongojo? Wo‑wawiri awagwirira mpondo? ");
INSERT INTO wmw_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Aapo anta mwanafunzi mmojawapo wakumpunda mwanlimu wake, fala mwanafunzi wakufyoma sana anlanda mwanlimu wake. ");
INSERT INTO wmw_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Sababuni kushugulika na kizolo ciri mmaso mwa nduyo, kwasa kushugulikira kibawo ciri mmaso mwako? ");
INSERT INTO wmw_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Umwambira nduyo: ‘Nduyangu njo kuno, inga nukusaidiye nukulavye kizolo mmaso mwako‑mo.’ Mwaja? Iri kuwa uwe auri kuwona kibawo ciri mmaso mwako? Uwe nafiki, lavya kwanza kibawo ciri mmaso mwako, ikisa uwone sana-sana kizolo ciri mmaso mwa nduyo ulavye.” ");
INSERT INTO wmw_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Aupo muti mwema wakupa visumo vyakunyata. Muti wakunyata newo novyo aupa visumo vyema. ");
INSERT INTO wmw_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kamana kila muti ukwijiwikana kwa visumo vyake. Figu azisumiwa mmuti wa miwa, wala uva azisumiwa mumbiriwiri. ");
INSERT INTO wmw_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Munu mwema akuwa na meema mengi mmoyo mwake, ndimana alavya meema mmoyo. Munu mbaya, wa moyo mbaya, alavya mabaya. Konta kanywa ya munu isowera cijáre mmoyo.” ");
INSERT INTO wmw_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Munita: ‘Mwenye! Mwenye!’ fala amutenda canamba omi, sababuni? ");
INSERT INTO wmw_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Kila ája kwangu omi, ásikiriza usemi wangu, áfulata vyanamba novyo, nukoloterani anlandire. ");
INSERT INTO wmw_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Kanlanda munu ajengire nyumba, akisimba pansi pakwica, akipanga mawe a aluserusu. Uja mpupu wa maji mengi a muto, wibiya na nguvu nyumba ire, fala aitikinyike, konta ijengiwa sana. ");
INSERT INTO wmw_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Fala ire asikire usemi wangu akitowa kufulata, kalandana na munu ajengire nyumba munsanga, bila kupanga mawe a aluserusu. Pauja mpupu wa maji a muto, akwibiya nyumba‑yo. Kwa mpunde nowo ikugwa, na ipondomoka nfululu!” ");
INSERT INTO wmw_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Insa pesire kuwambira wanu vinu vire piya, akingira Kafarnaumu. ");
INSERT INTO wmw_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Noko ákiwapo nkulungwa mmoja wa masurudadu, ákiwa nawo ntumisi mmoja waakimpenda pakulu futi. Ntumisi ire ákiwona kulwaza, nusura kufwa. ");
INSERT INTO wmw_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Surudadu ire pasikire vikisoweriwa kuhusu Insa, kawatuma wakulungwa wamojawapo wa Mayahudi wakanlebele Insa oke akamponese ntumisi wake. ");
INSERT INTO wmw_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Wajire ka Insa ware wakintafadali pakulu, wakamba: “Eyo mwananlume‑yo ájuzi kusaidiiwa, ");
INSERT INTO wmw_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","kamana awapenda wanu wetu Mayahudi, ndi kweli iye katijengera sinagoga yetu!” ");
INSERT INTO wmw_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Insa akilongozana nawo wakuka. Nakufika karibu ya nyumba ire, surudadu ire akiwatuma marafiki zake wamojawapo wapite wakimmwinza Insa, wamwambire: “Mwenye, usiwone kukushumbuwa, omi siri bora uwe kuja kwinama lupenu rangu kwingira. ");
INSERT INTO wmw_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Kwa javyo, omi sikidaniza kuwa nijuzi kuja kusowera nowe. Lavya ámuri tu basi, ntumisi wangu‑yu ápona. ");
INSERT INTO wmw_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Kamana omi nanawo wakulungwa wangu wanijuzi kuwasikiriza. Nanawo novyo masurudadu waniwapanga ámuri. Nimwambira mmoja ‘uka’, neye alawa akuka. Nimwambira mwengine ‘njo kuno’, iye akuja. Na nimwambira ntumisi wangu ‘tenda‑ci’, iye atenda.” ");
INSERT INTO wmw_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Insa nakusikira javire, kanshanga, akiwazungunukira wakinfulata ware, akiwambira: “Nukwambirani kuwa tangu sinansingana anta mmoja kati ya wanu waIziraeli wa kwamini pakulu kamba eyu!” ");
INSERT INTO wmw_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Nakufika ukaya, watumiwe ware wansingana ntumisi ire aponire. ");
INSERT INTO wmw_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Subuu yake, Insa akilawa, akuka mpaka kaya yakwitiwa Naimu. Kalongozana na wanafunzi wake na wanu wengi wawenye. ");
INSERT INTO wmw_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Insa paafikire karibu ya kaya ire, ona, asukuriwa maiti. Maiti are ákiwa mwana mmoja noyo tu basi wa mamaye, na iye ákiwa nankweli. Wanu wengi wawenye wakimpereka kuka kuzika. ");
INSERT INTO wmw_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Mwenye pammonire nankweli ire, kantendera huruma pakulu, akimwambira javi: “Usirire.” ");
INSERT INTO wmw_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ikisa akiwandika janeza ire, akikumbula, na wanu wasukure janeza ware wakimira. Insa akamba: “Nnemba, nankukwambira, lamuka!” ");
INSERT INTO wmw_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Neye âfwire ire akikala, akanza kusowera. Insa nopare akingabizi mmakono mwa mamaye. ");
INSERT INTO wmw_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Piya ware ukiwapata wofi, wakinsifu Mwenyezimungu, wakamba: “Kati yetu kalawirira nabii nkulu!” Ikisa wakamba: “Mwenyezimungu kawanang'aniza wanu wake!” ");
INSERT INTO wmw_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Habari kuhusu vyaâtendire Insa zikenera piya porovinsiya ya Yudeya na makaya jirani piya. ");
INSERT INTO wmw_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Wanafunzi wa Yahaya wakuka wakimwereza mwanlimu wawo kuhusu piya vinu vikunire. Yahaya akiweta wanafunzi wake wawiri, ");
INSERT INTO wmw_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","akiwatuma kuka kusowera na Mwenye, wandairi javi: “Uwe ndi ire akirindiriwa kuja, au titumaini kunrindira mwengine?” ");
INSERT INTO wmw_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Wakija ka Insa, wanu ware wakimwambira: “Yahaya mwenyé Koza katituma kuno tije tukudairi: ‘Uwe ndi ire akirindiwa kuja, au titumaini kunrindira mwengine?’ ” ");
INSERT INTO wmw_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Wakati noure, Insa kawaponesa wanu wengi wawenye wakulwaziwa na ulwere jisijisi na wakupatiwa na mashetwani, na kawaponesa novyo vipofu wengi wawenye, ewo wakanza kuwona. ");
INSERT INTO wmw_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ndimana, Insa akiwajibu wanafunzi wa Yahaya ware, akamba: “Ukani mukamwambire Yahaya vyamuwonire na vyamusikire‑vi, kuwa vipofu wankuwona, wanu wakubadilika maulu wankwenenda, wamagundula wankuswafiwa, sawasikira wankusikira, wafwi wankuziripusiwa, na wamasikini wankwereziwa Habari Ngema. ");
INSERT INTO wmw_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Heri munu wakuwa kwangu omi aawona sababu ya kunziwiya kuzidi kunamini.” ");
INSERT INTO wmw_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Wanafunzi wa Yahaya pawokire vyawo, Insa kengira kuwambira wanu ware kuhusu Yahaya, akamba: “Mwananlume wamukire kummona kulanga‑yo nani? Wamummonire kuwa mwepepe kamba bambati, rakutikinyika na mepo‑yo? ");
INSERT INTO wmw_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Noko muka kuwona kinani? Muka kummona mwananlume wakuvala sana-sana? Onani, wanu wa mavazi meema wakwikala mmanyumba makulu a kifalume, awekala nlanga. ");
INSERT INTO wmw_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Sambi, muka kuwona kinani? Muka kummona nabii? Ndi kweli, na iye kampunda nabii. ");
INSERT INTO wmw_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Yahaya ndi noyo asemiwa mMandiko kuwa: ‘Ona, omi nimpereka ntumwa wangu wakukulongorera, iye akutengezera njira mbere yako.’ ");
INSERT INTO wmw_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Omi nukwambirani kuwa kati ya wanu wapongoriwe na wanawaka, aapo nkulu wakumpunda Yahaya. Novyo-sivyo, munu saari kinu onse muufalume wa Mwenyezimungu, noyo ndi nkulu wakumpunda iye!” ");
INSERT INTO wmw_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Warípisi nsoko wamojawapo, pamoja na piya wanu wengine wasikire, kwa kuwa wôziwa na Yahaya, wakikisha kuwa Mwenyezimungu mwenyé haki. ");
INSERT INTO wmw_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ila Mafarizeu na wenye kupendeleya shariya awoziwe na Yahaya, kwa javyo wakatala vyaasaka Mwenyezimungu wawo. ");
INSERT INTO wmw_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Insa akamba tena: “Wana wa nozi enzi‑zi niwalandanise na nani? Wanlanda nani? ");
INSERT INTO wmw_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Wawa kamba wasimana wekare pabazari wakambirana javi: ‘Tibiya ngoma ya sherehe fala amuvinire, timba nyimbo za uzuni, fala amuririre!’ ");
INSERT INTO wmw_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Kamana, kaja Yahaya mwenyé Koza aatafuna mikate wala aanywa vinyu, umwe mukwamba: ‘Iye kanawo jini.’ ");
INSERT INTO wmw_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Sambi, kaja Binadamu wa Binguni, akuryanga na akunywanga, umwe mukwamba: ‘Mmoneni, nryaji na nnywaji‑yu, rafiki wa warípisi nsoko na wamádambi‑yu.’ ");
INSERT INTO wmw_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Wijiwifu wa Mwenyezimungu wakikishiwa kuwa shariya na piya wenye kufulata nowo wijiwifu‑wo.” ");
INSERT INTO wmw_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Suku moja, Nfarizeu mmoja kamwarifu Insa akarye kwake. Ndimana Insa akuka kunyumba ya Nfarizeu ire, nakufika akikala kurya. ");
INSERT INTO wmw_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ona, ákiwapo nkaya‑mo mwanamuka mmadambi. Iye, paasikire kuwa Insa kekala kurya kunyumba ya Nfarizeu kure, akilawa akuka noko. Akisukula numba ngema sana yaâtayire mafuta akunuwira. ");
INSERT INTO wmw_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Nakufika, akikokora nyuma ya maulu a Insa, akirira akimugwa masozi. Kuno akinlovya na masozi ake Insa mmaulu, ikisa akinfuta na nywiri zake. Na kila mara, akimpa beju, kuno akintawanyira mafuta akunuwira are. ");
INSERT INTO wmw_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Nfarizeu ámwarifire ire, nakuwona vyaakitenda mwanamuka ire, akisowera kimoyomoyo akamba: “Eyu mwananlume‑yu anáwa nabii, iye nanga kamwijiwa mwanamukani ári kunkumbula mmaulu‑yu. Eyu mwanamuka‑yu mmadambi!” ");
INSERT INTO wmw_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Insa akinjibu Nfarizeu ire, akamba: “Ansumani, ciwapo kinu canisaka kukwambira.” Iye akijibu: “Sema, Mwanlimu.” ");
INSERT INTO wmw_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Insa akintambira javi: “Wákiwapo wanawalume wawiri wakiwiriwa na munu mmoja. Mmoja akiwiriwa jarajara miya ntanu za parata, na mwengine amusini. ");
INSERT INTO wmw_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Wo‑wawiri anta mmoja aawerepo wakuwa na uwezo wa kuripa deni yake, ndimana mwanyewe akiwaswamii nfululu piya ware. Munu asaka kumpenda pakulu aswamiire ire ndi wepi?” ");
INSERT INTO wmw_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ansumani akijibu, akamba: “Niwona kuwa ire aswamiiwe pakulu ire.” Insa akamba: “Kweli, kuwaza sana.” ");
INSERT INTO wmw_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ikisa Insa akimolota mwanamuka ire, akimwambira Ansumani: “Mmone mwanamuka‑yu? Ningira nnyumba mwako‑mu, aunipere maji nikitawada mmaulu‑mu, fala iye kanosa maulu angu‑ya na masozi ake, kanifuta na nywiri zake. ");
INSERT INTO wmw_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Aunipokerere kwa beju, fala iye tangu nikingira‑mu, aasire kunipa pakulu beju mmaulu. ");
INSERT INTO wmw_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Aunipakire mafuta nkiswa‑mu, fala iye kanipaka mafuta akunuyira mmaulu. ");
INSERT INTO wmw_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kwa javyo, nukwambira kuwa madambi ake, newo mengi, aswamiiwa kamana kanolotera pendo pakulu. Fala mwenyé kuswamiiwa aba, akolota kupenda aba.” ");
INSERT INTO wmw_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ikisa Insa akimwambira mwanamuka ire: “Madambi ako aswamiiwa.” ");
INSERT INTO wmw_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Kwa javyo, wanu wengine wekare nawo ware wakanza kwambirana watupu: “Eyu mwananlume‑yu, wakuwa anta madambi aswamii, nani?” ");
INSERT INTO wmw_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Insa akimwambira mwanamuka ire: “Kwamini kwako kukuvusha. Uka vyako kwa salama!” ");
INSERT INTO wmw_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Bandi ya javire, Insa akipita mmakaya makulu na matoto, akereza Habari Ngema kuhusu ufalume wa Mwenyezimungu. Iye kalongozana na wanafunzi kumi na wawiri ware. ");
INSERT INTO wmw_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Wakinfulata novyo wanawaka wengine wawaponese ulwere wa mashetwani na malwere mengine. Nkati ya ewo wákiwa Mariyamu Madalena âtuwisiwe mashetwani saba. ");
INSERT INTO wmw_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Zuwana muka wa Kuza, amiri nkulu wa Herodi; Suzana; na wengine tena wengi wawenye. Ewa wanawaka‑wa wakilavyanga vinu vyawo wanyewe, wakinsaidiya Insa pamoja na wanafunzi wake. ");
INSERT INTO wmw_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Suku moja, wajumana wanu wengi, wakilawa kaya nyingi wakija ka Insa. Iye akiwasowerera kwa kinyume, akiwambira javi: ");
INSERT INTO wmw_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Safari mmoja kalawa nvyari mmoja kuka kuvyala mbeyu yake. Paakivyala, mbeyu nyengine igwirira munjira, iluwatiwa, na nyuni zidodola piya. ");
INSERT INTO wmw_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Nyengine ikigwirira mmawe, nakukula yumiliya kwa kutowa kanawo napanapa ya maji. ");
INSERT INTO wmw_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Nyengine igwirira mmiwa, ikula pamoja na minyani ya miwa, fala miwa ire ikinya. ");
INSERT INTO wmw_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Na mbeyu nyengine igwirira munsanga warutuba. Mbeyu ire ikula, ipa visumo miya kwa mbeyu moja.” Mwinsho kaamba kwa shauti ulu: “Basi, ári na masikiro a kusikira, asikire!” ");
INSERT INTO wmw_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Wanafunzi ware wandairi Insa kuhusu kinyume cire mana ake. ");
INSERT INTO wmw_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Iye akiwajibu: “Umwe mweleweshiwa siiri ya ufalume wa Mwenyezimungu. Fala wanu wengine niwasowerera nkinyume ipate anta wanang'anize wasiwone, anta wasikire wasereriwe. ");
INSERT INTO wmw_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Eci kinyume‑ci mana ake ndi javi: Mbeyu ikolota usemi wa Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Mbeyu igwirire munjira ikolota wanu wasikíra usemi wa Mwenyezimungu. Ikisa akuja Shetwani, awalavya usemi ure mmoyo mwawo ipate wasikubali, wasivushiwe. ");
INSERT INTO wmw_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Mbeyu igwirire mmawe ikolota wanu wakuwa pawasikira usemi wa Mwenyezimungu, wapokerera kwa radi sana. Fala awana mizipe mirefu. Kwa muda aba wakubali, fala wakati wakuwayerera, watipuka kunifulata. ");
INSERT INTO wmw_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Mbeyu igwirire mmiwa ikolota wanu wasikíra usemi wa Mwenyezimungu, fala pawenenda, mashuguli a mainsha na utajiri na starehe za mainsha awapota wanu ware. Kwa javyo, awapa visumo vyakutokota. ");
INSERT INTO wmw_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Mbeyu igwirire munsanga warutuba ikolota kuwa ndi wanu wasikira habari, watula habari‑yo mmoyo mwema na kamilifu. Mwinsho wakupa visumo kwa sababu ya imani yawo.” ");
INSERT INTO wmw_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Aapo munu akoreza kandiyeru ikisa kataya ntamboru au katula mwivungu. Ila atula mahala pakuwa engira nnyumba onse, áwona nlangaza sana-sana. ");
INSERT INTO wmw_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Kamana acipo kinu cakufisiwa sacifisuriwa, wala ca siiri airini sacijiwikana na kusikirika panja. ");
INSERT INTO wmw_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Basi, tunzani namuna vyamusikira. Kamana mwenyé kuwa nawo, akuja kupewa. Saana, mpaka na aba caari nawo, akuja kupokeriwa.” ");
INSERT INTO wmw_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ikisa mamaye Insa na wanduze woka kummona Insa, fala awakikidiri kunfika karibu konta wanu wákiwa wengi. ");
INSERT INTO wmw_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Akambiriwa Insa: “Ona, mamayo na wanduzo wemira panja pare, wasaka wasowere nawe.” ");
INSERT INTO wmw_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Fala iye akiwajibu, akamba: “Mama na wanduzangu ndi wasikira habari ya Mwenyezimungu na kufulata.” ");
INSERT INTO wmw_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Suku moja, Insa kengira mungalawa na wanafunzi wake, akiwambira: “Tukeni ng'ambu nyengine ya tanda.” Basi ewo, wakilawa pare. ");
INSERT INTO wmw_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Pawakiloka, Insa akiritandikira, akilala. Ikanza kuvuma mepo pakulu ya gaibu ntanda mure, mungalawa mukijala maji, nusura kuzama. ");
INSERT INTO wmw_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ewo wakinfika karibu, wakinlamusa, wakamba: “Mwanlimu, mwanlimu, tankuzama!” Iye kâlamusiwa, akamuru mepo inyamare, na maluwimbi makulu anyamare. Kwa mpunde noure, mepo na maluwimbi vikinyamala, mmaji mure mukitenda shuwari dembwe. ");
INSERT INTO wmw_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ikisa Insa akiwadairi: “Kwamini kwenu ndi kwepi?” Ewo wakopa pakulu, wakitajabu, wakidairiyana watupu: “Noyu mwananlume‑yu nani, wakuwa akwamuru mepo na maji, na piya vinsikiriza iye?” ");
INSERT INTO wmw_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Nakisa woka na ngalawa, wakifika upande wa inti ya waGerasi, ng'ambu nyengine ya tanda ra Galileya. ");
INSERT INTO wmw_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Insa pesuke mungalawa mure, akifika mwananlume mmoja wa nkaya mure. Mwananlume ire akimilikiwa na mashetwani. Suku nyingi zawenye akenenda diki, aakilalanga nnyumba, akikalanga kumakaburi. ");
INSERT INTO wmw_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Nakummona Insa ire, akikuwa pakulu, akigwa mbere yake, na shauti ulu akamba: “Mbana kwankunandibu, Insa, Mwana wa Mwenyezimungu Nkulu? Nukulebela usinopepese!” ");
INSERT INTO wmw_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Kamana Insa kâmwamuru jini ire alawe mmwiri mwa mwananlume ire. (Kweli, jini ire kâmmiliki munu ire suku nyingi. Wanu wakinfunga na alucema na unyolo, wakinnang'anizira, fala iye akivunja-vunjanga piya vyuma vyakifungiriwa vyonse, jini akintuwisira kulanga.) ");
INSERT INTO wmw_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Basi, Insa kandairi: “Zina rako nani?” Iye akijibu: “Junudi” konta mashetwani wengi wâmwingira mmwiri mwake. ");
INSERT INTO wmw_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Mashetwani ware wakizidi kunlebela Insa asiwamuru ewo kulawa kwingira Mpondo sarina mwinsho. ");
INSERT INTO wmw_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Noparepare zikiwapo nguluwe nyingi zawenye zikirisiwa mmwango. Mashetwani ware wakinlebela Insa awase wakawengire nguluwe zire. Ndimana Insa akiwetikizira. ");
INSERT INTO wmw_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Mashetwani ware wakinlawa mwananlume ire, wakiwengira nguluwe zire. Na piya nguluwe zire zikituwa, zikicubukira ntanda, zikizama nomo. ");
INSERT INTO wmw_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Wasunga wa nguluwe zire, pawawonire javire, wakitira, wakuka kaya íkiwa karibu ya mmamasamba, wakereza vikunire vire. ");
INSERT INTO wmw_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Wanu woka kaakiwa Insa kure kuwona vikunire vire. Munu âmilikiwe na mashetwani ire, ewo wammona ekare karibu ya maulu a Insa, kavala nguwo zake, na ankili zintengemana. Nakuwona javire, wakibaki na wofi. ");
INSERT INTO wmw_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ware wanu wawonire vikunire vire, wawambira wenziwawo namuna vyaaponesiwe munu âkiwa na mashetwani ire. ");
INSERT INTO wmw_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ikisa, wanu piya inti ya waGerasi ire wanlebela Insa kuwa alawe kwawo oke vyake, kamana piya wákiwa na wofi pakulu. Basi, Insa akingira mungalawa mure, akiludi. ");
INSERT INTO wmw_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mwananlume wawânlawire mashetwani ire kantafadali Insa ekare naye. Fala Insa akinludisa, akamba: ");
INSERT INTO wmw_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ludira kwenu, ukereze vinu vyakutendere Mwenyezimungu.” Basi, iye akilawa, akipita nkaya mure piya, akereza vinu vyaatenderiwe na Insa. ");
INSERT INTO wmw_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Insa paaludire, wanu wengi wampokerera na radi kamana piya wakinrindira. ");
INSERT INTO wmw_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Sambi, akija mwananlume wakwitiwa Yairu, ákiwa nkulungwa wa sinagoga. Yairu nakufika, akinsujudira Insa mmaulu, akintafadali pakulu oke kwake, ");
INSERT INTO wmw_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","kamana ákiwa nawo mwana muka mmoja tu basi wa hirimu ya myaka kumi na miwiri, ákiwa nlwere pakulu, karibu kufwa. Insa paakuka, wanu wengi wakinkinya kila upande. ");
INSERT INTO wmw_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Munkonjo mure, ákiwapo mwanamuka ákiwa na ulwere wa mbobo muda wa myaka kumi na miwiri, fala iye ákiwa saanaponesiwa na munu mmojawapo. ");
INSERT INTO wmw_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Iye akinfika karibu Insa kumiyongo kwake, akinkumbula lupindo ra anzu yake. Kwa mpunde noure, damu ikinlawa ire ikinyamala. ");
INSERT INTO wmw_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Insa akidairi: “Anikumbure nani?” Pawakanire wanu ware piya, Peduru akamba: “Mwanlimu, piya wanu wakukinya, wankukusukuma kuno-na-kuno!” ");
INSERT INTO wmw_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Fala Insa akamba: “Anta, kawapo mmojawapo anikumbure kasidi, kamana nifahamu uwezo ukinilawa.” ");
INSERT INTO wmw_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Mwanamuka ire, kwa kuwona kuwa aifãi kurifisa, akija akitetema akirefya pansi mbere yake, akisema mbere ya wanu piya sababu yankumburire, na namuna vyaaponesiwe kwa noure mpunde ure. ");
INSERT INTO wmw_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Basi, Insa akimwambira: “Nunu, kwamini kwako kukuvusha, uka salama.” ");
INSERT INTO wmw_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Insa paakisowera, akija munu kulawa kunyumba ya nkulungwa wa sinagoga, akamba: “Mwanenu kafwa. Musimwandibu mwanlimu‑yu bure-bureni!” ");
INSERT INTO wmw_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Fala Insa nakunsikira javire, kamwambira Yairu: “Usope kinu! Ila tumaini tu basi, mwanawo avuka!” ");
INSERT INTO wmw_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Insa paafikire kunyumba ya Yairu, nnyumba mure aamwasire munu kwingira ila Peduru, Yakobu, Yahaya, pamoja na wawaze mwari ire. ");
INSERT INTO wmw_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Piya wanu wakirira na wakirishuku kuhusu mwari ire, fala Insa akiwambira: “Musirire! Aafwire, ila kankulala!” ");
INSERT INTO wmw_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Wanu wankejeli konta wakijiwa kuwa kafwa. ");
INSERT INTO wmw_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Basi, Insa akinkola nkono wake, akimwita akamba: “Mwari, lamuka!” ");
INSERT INTO wmw_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Kweli, ukinludira uhai wake. Kwa mpunde noure akilamuka, na iye akiwamuru wampe cakurya. ");
INSERT INTO wmw_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Wawaze mwari ire wabaki wakutajabu wawenye, fala Insa akiwamuru wasimwambire munu vikunire vire. ");
INSERT INTO wmw_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Insa, paawajumanise mawalii kumi na wawiri ware, akiwapa uwezo na mamulaka julu ya mashetwani piya na ulwere waponese. ");
INSERT INTO wmw_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Na akiwatuma walawe wapite wakereza ufalume wa Mwenyezimungu na wakiwaponesa walwere. ");
INSERT INTO wmw_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Iye kawambira: “Musirisukuze anta kinu munjira: wala nkongojo wala nrumba wala nkate wala nzuruku wala nguwo nyengine zakwaluriza. ");
INSERT INTO wmw_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nyumba yamusaka kwingira, ikalani nomo mpaka kulawa kwenu. ");
INSERT INTO wmw_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Piya sawakupokererani umwe, mukilawa kaya‑yo, ripumuneni vunvu mmaulu mwenu, iwe ushahidi kubishana nawo.” ");
INSERT INTO wmw_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Basi, ewo wakilawa wakipita kaya anta kaya, wakereza Habari Ngema na wakiponesa kila upande. ");
INSERT INTO wmw_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Sambi, nfalume Herodi akisikira piya vikikuna vire, akikafilika pakulu kwa kwambiriwa na wamojawapo kuwa Yahaya kafufuriwa ka wafwi. ");
INSERT INTO wmw_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Wengine wakwamba kuwa Aliyasi kalawirira upya. Na wengine wakwamba kuwa nabii mwengine wa mida kafufuriwa ka wafwi. ");
INSERT INTO wmw_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herodi akamba: “Yahaya nintupula kiswa. Sambi, munu wanisikira akunisha vinu‑yo, nani?” Kwa piya vire, akisakula ammone Insa. ");
INSERT INTO wmw_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Mawalii ware pawaludire, wamwambira Insa piya vyawatendire. Ikisa iye akiwatwala, wakilawa yeka yawo mpaka kaya yakwitiwa Betisaida. ");
INSERT INTO wmw_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Junudi ya wanu pawejiwe kokire Insa kure, wakinfulata. Iye nakuwapokerera, akisowera kuhusu ufalume wa Mwenyezimungu, na ware wakisakula kupona, kawaponesa. ");
INSERT INTO wmw_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Parikitita juwa, kumi na wawiri ware wakuka, wakimwambira: “Layana nawo wanu‑wa walawe, woke mmakaya na mmamasamba ankaribu‑mu, wakafikire na wapate cakurya. Epa mahala patiri‑pa panundu!” ");
INSERT INTO wmw_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Fala iye akiwambira javi: “Wapeni umwe‑po warye!” Ewo wakamba: “Atina kinu tena ila tanawo mikate mitanu na inswi mbiri, sairi tuke tikauze cakurya ca ewa wanu‑wa piya.” ");
INSERT INTO wmw_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Kamana wákiwapo kiyasi ca wanawalume alufu ntanu. Insa akiwambira wanafunzi ware: “Wanu‑wo wambireni wekare amusini-amusini.” ");
INSERT INTO wmw_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Wakitenda novire, wakiwekaza ware piya bunga-bunga. ");
INSERT INTO wmw_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Insa, nakutwala mikate mitanu ire na inswi mbiri zire, akinang'aniza julu, akinshukuru Mwenyezimungu cakurya cire. Ikisa akimeya, akiwapa wanafunzi ware wawatongere wanu ware. ");
INSERT INTO wmw_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Newo piya wakirya, wakikuta. Mwinsho, ewo wakilokotera pamoja vipande vibakire vire, vikijala vikapu kumi na viwiri! ");
INSERT INTO wmw_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Suku moja, Insa akilebela duwa yeka yake. Upande wákiwapo wanafunzi ware. Iye akiwadairi, akamba: “Wanu wakwamba kuwa omi niwa nani?” ");
INSERT INTO wmw_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ewo wakijibu, wakamba: “Wamojawapo wakwamba kuwa Yahaya mwenyé Koza. Fala wengine wakwamba kuwa Aliyasi, na wengine tena wakwamba kuwa nabii wa mida kufufuriwa.” ");
INSERT INTO wmw_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Iye akiwadairi tena: “Sambi umwe, mukwamba kuwa omi niwa nani?” Peduru akijibu, akamba: “Uwe kuwa Almasihi wa Mwenyezimungu!” ");
INSERT INTO wmw_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Insa kwa kuwalaizira akamuru kuwa wasimwambire munu iye caari. ");
INSERT INTO wmw_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ikisa Insa akamba: “Isakikana Binadamu wa Binguni atabike pakulu, akatariwe na wazee, wakulungwa wa dini, pamoja na wanlimu wa shariya, aulaiwe, na suku ya tatu afufuriwe ka wafwi.” ");
INSERT INTO wmw_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ikisa kawambira wanu piya: “Munu mmojawapo asaka kunifulata omi onse, arikatare mwanyewe, asukure nsalaba wake suku daima‑zi, anifulate. ");
INSERT INTO wmw_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kamana ásaka kuvusha mainsha ake, apoteza. Fala ápoteza mainsha ake kwa sababu yangu omi, avusha. ");
INSERT INTO wmw_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Munu kupata duniya nzima‑yi, kuripoteza au kwaribu mainsha ake, faidani? ");
INSERT INTO wmw_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Kamana munu akiriwonera haya nomi au usowezi wangu, Binadamu wa Binguni, akiludi na utukufu wake na wa Baba na wa malaika matakatifu, iye novyo akuja kuriwonera haya naye. ");
INSERT INTO wmw_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Fala nukwambirani kweli kuwa, epa wawapo wanu wamojawapo awafwa sawanamba kuwona ufalume wa Mwenyezimungu.” ");
INSERT INTO wmw_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Zipita suku nane bandi ya kusowera javire, Insa akilawa na Peduru, Yahaya, pamoja na Yakobu, akikwera pamwango kulebela duwa. ");
INSERT INTO wmw_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Paakilebela duwa pare, uso wake ure utaduka, nguwo zíkiwa nyelupa‑vu ziking'anira ng'ani-ng'ani-ng'ani. ");
INSERT INTO wmw_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ona, wákilawirira wanawalume wawiri wakanza kupakanira naye. Ewo wákiwa Musa na Aliyasi, ");
INSERT INTO wmw_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","wazunguriziwa na nuru ya utukufu, wakisowera kuhusu namuna za kifo cake vyaakuka kutimiza Yerusalemu. ");
INSERT INTO wmw_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Peduru na wenziwe wâlala usingizi pakulu futi. Nakusisimuka, wawona utukufu wa Insa pamoja na wanawalume wawiri waâkiwa nawo ware wemire. ");
INSERT INTO wmw_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Musa na Aliyasi, nakulawa pare, Peduru akimwambira Insa: “Mwanlimu, vyema tiwe nopa! Tíjenga vitala vitatu: kimoja cako, cengine ca Musa, na cengine ca Aliyasi.” Iye aakijiwa anta caamba! ");
INSERT INTO wmw_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Kuno akisowera, rikisuka wingu, rikiwafinika. Ewo paringire wingu rire ukiwapata wofi pakulu. ");
INSERT INTO wmw_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Muwingu mure ikisikirikana shauti ikamba: “Eyu ndi mwanangu wanintondore, nsikirizeni iye!” ");
INSERT INTO wmw_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Nakusowera shauti ire, Insa kawoniwa yeka yake. Wanafunzi ware wakinyamala. Nozire suku zire awamwambire anta munu vyawawonire vire. ");
INSERT INTO wmw_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Subuu yake, pawakisuka pamwango ure, wakisimanana na wanu wengi wawenye. ");
INSERT INTO wmw_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ona, mwananlume mmoja munkonjo mure akikuwa kuno akamba: “Mwanlimu, tenda fadili ummone utungu mwanangu‑yu konta nanawo mmoja noyu tu basi! ");
INSERT INTO wmw_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Kawapo jini ári kunkola, mpunde nowo annyangurisa. Ampata mwanajulu mpaka anlawa makovu nkanywa. Amwasa na vilaso, arigariga kunlawa! ");
INSERT INTO wmw_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Niwatafadali pakulu futi wanafunzi wako wantuwise jini‑yu, fala awakidirire!” ");
INSERT INTO wmw_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Insa akijibu, akamba: “Ha, kizazi sacamini na cakusiyanika! Nikwikala namwe nukukuhitamilini mpaka rini? Njo nawo kuno mwanawo‑yo.” ");
INSERT INTO wmw_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nnemba ire nakufika karibu yake, jini ire akimwefya pansi, akimpata mwanajulu. Fala Insa akinsutumu jini ire, akimponesa nnemba ire, ikisa akingabizi wawaye. ");
INSERT INTO wmw_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Na wanu piya wakishanga dwaraa uwezo nkulu wa Mwenyezimungu ure. Pawakishanga wanu piya kwa vitendo piya vyaatendire Insa, iye akiwambira wanafunzi wake javi: ");
INSERT INTO wmw_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Sikirizani sana-sana canamba omi: Binadamu wa Binguni wakati karibu aperikiwa mmakono mwa wanadamu.” ");
INSERT INTO wmw_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Fala ewo awejiwe ewu usemi‑wu, mana ake wafisiwa, ipate wasereriwe. Na kuhusu usowezi ure, ewo wakopa kundairi. ");
INSERT INTO wmw_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Suku moja wanafunzi ware wakikaidiyana watupu kuhusu nani ari bora. ");
INSERT INTO wmw_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Insa kwa kwijiwa ciri mmyoyo mwawo, akintwala kisimana mmoja, akimira naye, ");
INSERT INTO wmw_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","akiwambira javi: “Munu asaka kuwa onse ampokérera kisimana‑yu kwa zina rangu, kanipokerera omi. Na anipokérera omi, kankumpokerera anipereke omi. Kamana kati yenu umwe, mwenyé kurinyenyekeya pakulu, noyo ndi bora!” ");
INSERT INTO wmw_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yahaya kaamba: “Mwanlimu, timmona mwananlume mmoja akiwatuwisa mashetwani kwa zina rako. Tikinkataza, konta iye aafulatana nafwe!” ");
INSERT INTO wmw_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Fala Insa akimwambira javi: “Musinkataze! Munu saabishana nomwe kawa upande wenu.” ");
INSERT INTO wmw_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Paifikire karibu suku ya kukweziwa Insa, iye akitwakali kuloza uso kuka Yerusalemu. ");
INSERT INTO wmw_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Akiwatuma mashikarakanzi wamojawapo walongorere. Ewo wakingira kaya ya waSamariya wantengezere. ");
INSERT INTO wmw_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Fala wenye kaya awasakire kumpokerera, konta Insa katwakali kuka Yerusalemu. ");
INSERT INTO wmw_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Wanafunzi wawiri Yakobu na Yahaya, nakuwona javire, wamwambira: “Mwenye, usaka titise moto kulawa mbinguni tiwapoteze wanu‑wa?” ");
INSERT INTO wmw_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Fala Insa akizungunuka, akiwasutumu. ");
INSERT INTO wmw_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Basi, wakilawa wakuka kaya nyengine. ");
INSERT INTO wmw_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ewo wari munjira wakuka, mmojawapo akimwambira Insa: “Omi nukufulata kauka konse.” ");
INSERT INTO wmw_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Insa akinjibu: “Marikule wanawo mapondo, nyuni zanawo vitundu, fala Binadamu wa Binguni aana anta pakwinyamira kupumula.” ");
INSERT INTO wmw_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ikisa, akimwambira munu mwengine: “Uwe nifulate!” Fala iye akamba: “Mwenye, nase kwanza nuke nikanzike wawa.” ");
INSERT INTO wmw_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Insa akinjibu: “Wase wafwi wawazike wafwi wawo. Ila uwe lawa, pita ukereza ufalume wa Mwenyezimungu.” ");
INSERT INTO wmw_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Akilawa munu mwengine akamba: “Mwenye, omi nisaka nukufulate. Ila kwanza nase nuke, nikawalaye wajamaa zangu.” ");
INSERT INTO wmw_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Insa akinjibu: “Munu anza kutenda matuto, akinang'aniza nyuma, aajuzi kwingira muufalume wa Mwenyezimungu.” ");
INSERT INTO wmw_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Bandi ya vire, Mwenye Insa akiwatondola wanafunzi wengine sabini na wawiri, akiwapereka wawiri-wawiri walongorere piya kaya na upande mwalangele kupita mure. ");
INSERT INTO wmw_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Akiwambira javi: “Kuvuna kukulu fala wavuni wawa aba. Kwa javyo, ntafadalini Mwenyé mavuno awatume wakazi pa mavuno ake. ");
INSERT INTO wmw_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ukani! Onani, nankukutumani kamba makondoo kati-kati ya miwinzi. ");
INSERT INTO wmw_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Musirisukuze poci wala nkoba wala tamango. Na munjira musidairiyane nawo wanu habari. ");
INSERT INTO wmw_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Nyumba yamusaka kwingira yonse, kinu cakwanza ambani javi: ‘Salama iwe julu ya eyi nyumba‑yi!’ ");
INSERT INTO wmw_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Akiwapo nnyumba‑mo munu wa salama, salama yenu íbaki neye. Akitowa kuwepo, ikuludirani wanyewe. ");
INSERT INTO wmw_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Noyo nyumba‑yo ikalani murye na munywe cawakumerani conse. Kamana múkazi kanawo haki ya nshahara wake. Musisamesame nyumba anta nyumba. ");
INSERT INTO wmw_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Kaya yamwingira yonse wakukupokererani, iryani vyawakumerani vyonse. ");
INSERT INTO wmw_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Noko walwere waponeseni, wambireni: ‘Ukufikani karibu ufalume wa Mwenyezimungu!’ ");
INSERT INTO wmw_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Fala mukingira nkaya mojawapo, ikiwa wanu awakupokerereni, mukilawira mbarabara za kaya‑yo, ambani javi: ");
INSERT INTO wmw_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Anta vunvu ra nkaya mwenu‑mu aritingire mmaulu tankukupumunirani. Novyo-sivyo, mwijiwe kuwa ukufikani karibu ufalume wa Mwenyezimungu.’ ");
INSERT INTO wmw_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nukwambirani kuwa suku ya Kiyama, eyo kaya‑yo ípata adhabu ulu koliko Sodoma!” ");
INSERT INTO wmw_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Uwe Korazini, ulaniwe! Uwe Betisaida, ulaniwe! Kamana mambo a uwezo atendíwe kwenu umwe anatendiwa kaya za Tiru na Sidoni, wenye kaya‑zo nanga watubiya madambi awo mida na midada, nanga wekala pansi wavala nguwo nzito na kuripaka rivu nkiswa. ");
INSERT INTO wmw_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Suku ya Kiyama, umwe múpata adhabu pakulu koliko Tiru na Sidoni. ");
INSERT INTO wmw_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Na uwe Kafarnaumu, udaniza kuwa kulamusiwa kuperekiwa binguni? Anta, uwe ukwisusiwa, úperekiwa Kuzimu!” ");
INSERT INTO wmw_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ikisa Insa akiwambira wanafunzi wake ware: “Munu akusikirizani umwe anisikiriza omi. Munu akukatalani umwe, anikatala omi, na munu anikatala omi, ankatala anipereke omi.” ");
INSERT INTO wmw_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Wanafunzi sabini na wawiri ware wakiludi wari radi, wakimwambira Insa javi: “Mwenye, anta na mashetwani watisikiriza kwa zina rako!” ");
INSERT INTO wmw_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Insa akiwajibu: “Aye, omi nimmona Ibilisi akisomoka kulawa binguni, akigwa kamba kumensa. ");
INSERT INTO wmw_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Onani, omi núkupangani mamulaka a kuwaluwata manyoka na viluma-ombo, na mamulaka a kushinda nguvu piya za aduwi. Acipo kinu kwa namuna isaka kuwa yonse cakukuduruni. ");
INSERT INTO wmw_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Fala novyo-sivyo, musifurahi kwa kuwa mashetwani wakusikirizani. Ila furahini kwa kuwa mazina enu andikiwa binguni.” ");
INSERT INTO wmw_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Noure wakati ure, Insa ákiwa radi pakulu kwa uwezo wa Roho Takatifu, akamba: “Ha, Baba, Mola wa binguni na wa duniya, nukutukuza konta kuwafisa evi vinu‑vi wejiwifu na werevu, kuwolotera watoto. Aye, Baba, nukutukuza kwa kuwa evi ndi vyausaka kutenda kwa rehema yako. ");
INSERT INTO wmw_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Piya vinu nigabiziwa na Baba wangu. Aapo amwijiwa Mwana sairi Baba, na aapo amwijiwa Baba sairi Mwana na ware wakuwa Mwana asaka kuwafafanurira.” ");
INSERT INTO wmw_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ikisa, akiwazungunukira wanafunzi wake cembe, akiwambira javi: “Heri maso awóna vinu vyamuri kuwona umwe! ");
INSERT INTO wmw_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Kamana nukwambirani kuwa minabii na mafalume wengi vikiwajibu wawone vyamuri kuwona umwe, fala awawonire. Vikiwajibu wasikire vyamuri kusikira, fala awasikire.” ");
INSERT INTO wmw_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ona, suku moja mwanlimu mmoja wa shariya wa Mayahudi akilamuka kumyerera Insa, akamba: “Mwanlimu, nikisakula niriti mainsha a milele, nijuzi nitende kinani?” ");
INSERT INTO wmw_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Iye akinjibu: “Nkati ya Taureti yandikiwa mwaja? Wereriwaja?” ");
INSERT INTO wmw_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Iye akinjibu, akamba: “Mpende Mola, Nlungu wako na moyo wako piya, na roho yako piya, na nguvu zako piya, na ankili zako piya. Na mpende mwenziwo kamba vyauripenda uwe mwanyewe.” ");
INSERT INTO wmw_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Insa akamba: “Kujibu sana. Tenda novyo, úinshi.” ");
INSERT INTO wmw_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Mwanlimu wa shariya ire akisaka olote kuwa kamilifu, ndimana akindairi Insa: “Mwenzangu ndi wepi?” ");
INSERT INTO wmw_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Insa akinjibu, akamba javi: “Mwananlume mmoja akilawa Yerusalemu, akiteremukira Yeriko. Munjira mure wakinlawirira wevi, wakimwiwira nguwo, wakimwibiya, wakuka vyawo, wakimwasa karibu ya kufwa. ");
INSERT INTO wmw_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Vikuna noire njira ire ákipita nlongozi mmoja wa dini. Pammonire, akinnyemera upande mwengine. ");
INSERT INTO wmw_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Akija novyo nopare mwananlume akikolanga kazi nNyumba Takatifu. Pammonire, neye novyo akinnyemera upande mwengine. ");
INSERT INTO wmw_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ikisa akija nSamariya mmoja, akipita na safari yake, akinsingana. Iye nakummona munu ire, kantendera huruma pakulu. ");
INSERT INTO wmw_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Akinfika karibu, akintafiti vijaraa vyake vire, akintaya mafuta na vinyu. Ikisa, akimpakira mburu mwake mwanyewe, akuka nawo mpaka kunyumba ya wayeni, akinsunga nomure. ");
INSERT INTO wmw_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Subuu yake, akitwala jarajara mbiri za parata, akimpa mwanyewe nyumba ire, akimwambira javi: ‘Nsunge‑yu. Na vinu vyausaka kumwaribira tena, omi nikiludi, nukuripa.’ ");
INSERT INTO wmw_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Sambi, uwonaja? Kati ya wanu watatu ware, mwenziwe mwananlume alawiriwe na wevi ire ndi wepi?” ");
INSERT INTO wmw_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Iye akijibu: “Ántendere huruma ire.” Na Insa akimwambira: “Basi katende sawa‑sawa novyo.” ");
INSERT INTO wmw_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Insa na wanafunzi wake wakendeleya na safari yawo. Insa paafikire kaya moja, mwanamuka mmoja wakwitiwa Marta akimpokerera nnyumba mwake. ");
INSERT INTO wmw_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta ákiwa nawo nduye wakwitiwa Mariyamu kamwikala Mwenye Insa kumaulu, ansikire vyaafunda. ");
INSERT INTO wmw_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Fala Marta akishugulika pakulu konta ákiwa nawo vinu vingi vyawenye vyakuwahudumu. Iye akinfika karibu, akindairi: “Mwenye, avikuyeri nduyangu kunasa nikikola kazi yeka? Basi, mwambire aje anisaidiye.” ");
INSERT INTO wmw_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Fala Mwenye akinjibu: “Ha, nunu Marta, ukwangaika na vinu vingi vyawenye, autengemana. ");
INSERT INTO wmw_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Fala cisakikana pakulu kinu kimoja tu basi. Mariyamu katondola fungu rimoja rema, nero fungu‑ro aalaviwa.” ");
INSERT INTO wmw_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Safari moja, Insa ákiwa mahala pamojawapo, akilebela duwa. Pesire, mwanafunzi wake mmoja akimwambira: “Mwenye, tifunde kulebela duwa, kamba Yahaya vyaawafundire wanafunzi wake.” ");
INSERT INTO wmw_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Insa akiwambira: “Mukilebela duwa, ambani javi: Baba, ritukuziwe zina rako! Utaware ufalume wako. ");
INSERT INTO wmw_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Tipe luziki rero ratisakula kila suku. ");
INSERT INTO wmw_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Tiswamii madambi etu, kamana ofwe novyo tiwaswamiingi watikosa. Usitase kutingira ushetwani.” ");
INSERT INTO wmw_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ikisa akiwambira: “Tulani kuwa, kati yenu, mmoja akuwa na rafiki yake, kamukira usiku kati-kati, kamwambira: ‘Tafadali, rafiki yangu, nikopeshe mikate mitatu. ");
INSERT INTO wmw_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Rafiki yangu kaja kanifikira nkati ya safari yake, omi sina cakurya cakumpa.’ ");
INSERT INTO wmw_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Na iye nyumba-nyumba nomo akijibu, akamba: ‘Usinandibu! Nryango ufungiwa. Omi na wanangu tapakinanda tankulala. Silamuka kuja kukupa.’ ");
INSERT INTO wmw_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Kusema kweli, ikiwa aalamuka ampe kwa kuwa rafiki yake, fala ammwandibu kunlebela, alamuka akumpa piya vyaasakula. ");
INSERT INTO wmw_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Na omi nukwambirani javi: Lebelani, mupewa; sakulani, mupata; lombani hodi, mufunguririwa. ");
INSERT INTO wmw_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kamana álebela onse, apewa; ásakula apata; na álomba hodi afunguririwa. ");
INSERT INTO wmw_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Nani kati ya umwe wawawa, alebeliwa na mwanawe inswi, kasa kumpa inswi kampa nyoka? ");
INSERT INTO wmw_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Au alebeliwa rĩ, kampa kilumaombo? ");
INSERT INTO wmw_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Onani, umwe wabaya mukwijiwa kuwapa wanenu vinu vyema-vyema, futi Baba wetu mbinguni siazidire pakulu, awapa Roho Takatifu wenye kunlebela!” ");
INSERT INTO wmw_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Suku moja, Insa akintuwisa jini mwananlume mmoja bubu. Jini ire nakunlawa, bubu ire akanza kusowera, na wanu wakitajabu pakulu futi. ");
INSERT INTO wmw_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Fala wamojawapo wakamba: “Iye awatuwisa mashetwani julu ya Belzebuli, nfalume wa mashetwani.” ");
INSERT INTO wmw_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Wengine wakisakula wamyerere Insa, ndimana wakinlebela atende alama mmojawapo ya binguni. ");
INSERT INTO wmw_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Fala Insa akijiwa mawazo awo, basi akiwambira: “Piya ufalume wakwawanyika wanyewe-ka-wanyewe ufujika, na ujamaa wa nyumba saupatana wanyewe-ka-wanyewe, ufujika. ");
INSERT INTO wmw_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Na ikiwa novyo Ibilisi akirawanya mwanyewe, ufalume wake‑wo ukwikala mwaja? Kamana mukwamba kuwa, julu ya Belzebuli, omi niwatuwisa mashetwani. ");
INSERT INTO wmw_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ikiwa niwatuwisa mashetwani julu ya Belzebuli, wanenu wawatuwisa julu ya nani? Kwa javyo, ewo ndi waja kukulamulani. ");
INSERT INTO wmw_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Fala ikiwa niwatuwisa mashetwani na cala ca Mwenyezimungu, basi julu yenu ukufikani ufalume wa Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Munu wanguvu, wakuwa na sulaha zake sana-sana, paasunga nyumba yake, vyombo vyake visalimika. ");
INSERT INTO wmw_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Fala akilawirira mwengine wakunzaidi nguvu koliko iye, anshambuliya, ankidiri, sulaha zake zatumainire akwawanya, vinu vyaanyanganye-vyo. ");
INSERT INTO wmw_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Munu saari pamoja nomi, abishana nami. Na saakusanya pamoja nnomi, atawanya.” ");
INSERT INTO wmw_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Insa akizidi kusowera, akamba: “Jini, paanlawa munu, apita mahala mwakumiliya, kusakula pumuzi. Akitowa kupata, akwamba: ‘Niludira nyumba yangu yanilawire’. ");
INSERT INTO wmw_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Paaludi, asingana nyumba ifyairiwa, itengiwa sana-sana. ");
INSERT INTO wmw_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Basi, awokira mashetwani saba wabaya pakulu koliko iye, ware wamwingira, wamwikala iye. Na munu ire hali yake ya mwinsho ikuwa mbaya ipunda yakwanza.” ");
INSERT INTO wmw_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Insa paasowera vinu‑vi, mwanamuka mmoja kati ya junudi akamba na shauti ulu: “Heri mwanamuka akwimite, na mawere aujijire!” ");
INSERT INTO wmw_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Fala iye akinjibu: “Heri pakulu wenye kusikira usemi wa Mwenyezimungu na kufulata.” ");
INSERT INTO wmw_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Wanu piya pawankinyire Insa, iye akanza kuwambira javi: “Ha! Eci kizazi‑ci, kizazi kimoja kibaya. Cisakula alama, fala acipewa alama sairi alama ya Inusu. ");
INSERT INTO wmw_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Kamana, kamba Inusu vyawere alama ka waNenive, ndi novyo Binadamu wa Binguni akuwa alama ka wanu wa eci kizazi‑ci. ");
INSERT INTO wmw_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Suku ya Kiyama, rainya wa suheli akuja kulamuka na wanu wa eci kizazi‑ci, awalamula hukumu yawo, kamana kasafiri kulawa inti ya baidi, asikire wijiwifu wa Selemani. Onani, epa kawapo munu bora pakulu koliko Selemani! ");
INSERT INTO wmw_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Na suku ya Kiyama waNenive wakuja kulamuka pamoja na wanu wa eci kizazi‑ci, awalamula hukumu, konta waNenive watubiya pâwasikire utuba wa Inusu. Na onani, epa kawapo munu bora pakulu koliko Inusu!” ");
INSERT INTO wmw_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Insa kawambira: “Aapo munu akoreza kandiyeru ikisa kufisa au kufinika na tamboru. Ila atula mahala iwamwarikira wanu wéngira, ipate wawone nlangaza. ");
INSERT INTO wmw_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Kandiyeru ya mwiri ndi riso rako. Ikiwa maso ako meema, mwiri wako piya ukuwa nuru. Fala ikiwa riso rako ribaya, mwiri wako piya ukuwa nkisi. ");
INSERT INTO wmw_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ndimana, rikengere ipate nuru yauri nawo‑yo isiwe kisi. ");
INSERT INTO wmw_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kwa javyo, ikiwa mwiri wako piya wanawo nuru, bila mahala pamojawapo kuwa pakisi, únuru nfululu, kamba mwenge vyaukumwarikira na nlangaza wake.” ");
INSERT INTO wmw_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Insa paasowera, Nfarizeu mmoja akimwarifu kwake wakarye. Basi, iye akingira nnyumba mure, akikala akirya. ");
INSERT INTO wmw_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Nfarizeu ire, nakummona Insa akirya sanamba kunawa, katajabu pakulu. ");
INSERT INTO wmw_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Mwenye Insa akiwambira: “Umwe Mafarizeu mushugulikira pakulu kosa panja ya kikombe na finga, fala mmyoyo mwenu cukwijalani coyo na ubaya. ");
INSERT INTO wmw_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Wanu wajinga sumwe! Atendire vya panja siatendire noyo vya nkati? ");
INSERT INTO wmw_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Basi, vinu vya nfinga, perekani viwe zaka, na piya vinu vikuwa swafi kwenu umwe. ");
INSERT INTO wmw_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Fala umwe Mafarizeu, mulaniwe! Mulavya fungu rakumi kwa kuminyu, alvadosi, na kila nnyani mojawapo wakuriwa, fala umwe mufezeyi shariya na kumpenda Mwenyezimungu. Evi ndi vikulazimuni kutenda bila kwasa vyengine-vyo. ");
INSERT INTO wmw_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Umwe Mafarizeu, mulaniwe! Kukwajibuni kwikala mahala mwa swifa nsinagoga, na kukomaziwa na inshima pamupita mukenenda mmanjira. ");
INSERT INTO wmw_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Umwe, mulaniwe! Muwa kamba makaburi akusira sawoneka. Wanu wakwenenda julu yawo sawejiwa!” ");
INSERT INTO wmw_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Basi, mwanlimu mmoja wa shariya akinjibu Insa, akamba: “Mwanlimu, pawambire javyo‑po, kutitukana!” ");
INSERT INTO wmw_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Insa akijibu: “Umwe, wanlimu wa shariya, mulaniwe novyo! Muwatika wanu mizigo sawakidiri kusukula, fala umwe amukumbula mizigo‑yo na cala cenu anta kimoja! ");
INSERT INTO wmw_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Umwe, mulaniwe! Mujengera makaburi a minabii wolaiwe na wababu zenu. ");
INSERT INTO wmw_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Kwa javyo, muwa mashahidi, mwankwitikizira vitendo vyawatendire wababu zenu! Kamana ewo wawolaya minabii, sambi umwe mwankujengera makaburi awo! ");
INSERT INTO wmw_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ndimana, wijiwifu wa Mwenyezimungu ukwamba javi: ‘Niwapereka minabii na mawalii, fala wamojawapo wawolaya na wawalumbata!’ ");
INSERT INTO wmw_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Kwa javyo, isakikana eci kizazi‑ci cijibu damu itawanyike ya piya minabii waulaiwe tangu kumbiwa ka ulumwengu. ");
INSERT INTO wmw_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Isakikana cijibu mwanzo wa damu yolaiwe Abeli mpaka damu yolaiwe Zagariya, aulaiwe kati ya uralu wa kafara na Mahala Patakatifu. Nukwambirani kuwa isakikana eci kizazi‑ci cijibu. ");
INSERT INTO wmw_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Umwe, wanlimu wa shariya, mulaniwe! Mutwala nfungulo wa wijiwifu. Umwe wanyewe amwingire, na wári kusaka kwingira, mwankuwaziwiya.” ");
INSERT INTO wmw_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Insa paakilawa mahala pare, wanlimu wa shariya na Mafarizeu wakimiwa naye pakulu futi, wakanza kumwandibu ka kundairi-dairingi vinu vingi vyawenye. ");
INSERT INTO wmw_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ewo wakinang'anizira asowere kinu kimojawapo wankorese. ");
INSERT INTO wmw_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Basi sambi, wanu alufu ka maalufu wajumana mpaka wengine wakiluwatana watupu. Insa cakwanza akiwambira wanafunzi wake javi: “More-moreni na furumento ya Mafarizeu‑yo, mana ake unafiki wawo‑wo. ");
INSERT INTO wmw_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Hapana cakufinikiwa sacifafanuriwa, na cakufisiwa sacijiwikana. ");
INSERT INTO wmw_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Kwa javyo, vinu vyamwambire pakisi, visikirikana juwa rikiwala. Na vyamuteterana mmasikiro kukati, vikwibiiriwa umambi.” ");
INSERT INTO wmw_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Insa akizidi kusowera: “Nukwambirani umwe, marafiki zangu: musiwope wanu wakuulaya mwiri, bandi ya eco awakidiri kutenda kinu cengine tena. ");
INSERT INTO wmw_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Fala nankukukumbusani wamujuzi kumopa: mopeni ire ári na mamulaka bandi ya kuulaya, kumpereka munu Jahanamu! Nukwambirani kweli, eyu mopeni!” ");
INSERT INTO wmw_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Na akamba tena: “Nyuni ntanu azuzanyiwa jarajara mbiri? Novyo-sivyo, aariwariwa anta mmoja mbere ya Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Fala mpaka na nywiri zenu nkiswa, piya ziwalangiwa. Basi musope kinu, umwe ndi bora pakulu koliko nyuni nyingi!” ");
INSERT INTO wmw_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Nukwambirani tena kuwa kila mwenyé kwakikisha mbere ya wanu kuwa anifulata omi, na Binadamu wa Binguni amwakikisha novyo mbere ya malaika wa Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Fala ire anikana omi mbere ya wanu akuja kukaniwa novyo mbere ya malaika wa Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Kila ansowerera caputu Binadamu, aswamiiwa. Fala mwenyé kukufurira Roho Takatifu ashubutu kuswamiiwa. ");
INSERT INTO wmw_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Pamukoriwa mukukisiwa nsinagoga, mbere ya wakulungwa na wenye mamulaka, musishugulike kwa kuwaza masemo enu namuna vyamusaka kujibu au kusema. ");
INSERT INTO wmw_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Kamana Roho Takatifu, kwa nowo wakati‑wo, akufundani usowezi vyamujuzi kwamba.” ");
INSERT INTO wmw_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ikisa mmojawapo pawanu pare, akamba: “Mwanlimu, mwambire nduyangu awanye irati yetu anipe fungu rangu.” ");
INSERT INTO wmw_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Fala Insa akinjibu: “Uwe mwanadamu, nani aniturire kuwa nlamuri au mwawanyi kati yenu umwe?” ");
INSERT INTO wmw_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ikisa Insa akiwambira wanu ware: “Rinang'anizireni, rikengereni na ucoyo piya, kamana mainsha a munu aapimiwa julu ya kuwa nawo vinu vingi.” ");
INSERT INTO wmw_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Na iye akiwambira nkinyume, akamba javi: “Ákiwapo mwananlume mmoja tajiri, mmasamba mwake karuwerya pakulu futi. ");
INSERT INTO wmw_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Tajiri ire akanza kuwaza javi: ‘Epa nitendaja? Kamana sina mahala pakutula vyakurya vyangu‑vi!’ ");
INSERT INTO wmw_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Basi akamba javi: ‘Nitenda javi! Nukuka kudangula vikuti vyangu vire, nijenge vyengine vikulu-vikulu. Nomo nitula tirugu yangu piya na vinu vyengine. ");
INSERT INTO wmw_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ikisa, nirambira kimoyomoyo: “Uwe, kwanawo vyakurya vingi komakoma vyauturire myaka mingi yawenye. Sambi, pumula, irya, inywa, na tenda radi!” ’ ");
INSERT INTO wmw_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Fala Mwenyezimungu kamwambira javi: ‘Kubanga! Usiku wa rero‑wu Nzulairi asakula moyo wako. Basi, vinu vyautengeza-vyo, vikuwa vya nani?’ ” ");
INSERT INTO wmw_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Insa akimariza: “Ndi vyaviri novyo, munu arikusanyira mwanyewe siyo tajiri ka Mwenyezimungu.” ");
INSERT INTO wmw_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Insa kawambira wanafunzi wake: “Kwa javyo nukwambirani, musishugulike na mainsha enu, camusaka kurya, wala mwiri wenu camusaka kuvala. ");
INSERT INTO wmw_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kamana mainsha bora zaida ya cakurya, na mwiri bora zaida ya mavazi. ");
INSERT INTO wmw_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Wanang'anizeni mabaruku: sawavyala wala sawavuna, wala sawariturira nyumba wala nkikuti. Novyo-sivyo, Mwenyezimungu awarisa cakurya. Futi umwe muri bora pakulu koliko nyuni! ");
INSERT INTO wmw_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Nani kati yenu akidiri, julu ya kushugulika, kongeza ora moja ya uhai wake? ");
INSERT INTO wmw_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Basi sambi, ikiwa aakidiri kutenda vinu vitoto kamba evyo, faidani kushugulikira kuhusu vikulu-vikulu? ");
INSERT INTO wmw_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Nanang'anizani maluwa namuna vyaakula: aakola kazi wala aapakasa, fala nukwambirani kuwa anta Selemani na ubora wa wema wake piya aavarire kamba luwa rimojawapo! ");
INSERT INTO wmw_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Basi, ikiwa Mwenyezimungu avaza minyani ya nnundu iripo rero, yakuwa makeshamungu ilungula moto, futi aazidi kukuvazani umwe, muri na kumwamini aba! ");
INSERT INTO wmw_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Musisakure vyakurya wala vyakunywa, na musiwe na wasi-wasi. ");
INSERT INTO wmw_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Makafiri piya mulumwengu‑mu wasakula evi vinu‑vi, fala Baba wenu akwijiwa kuwa musakula. ");
INSERT INTO wmw_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Kwasa javyo, sakulani ufalume wake, ikisa na piya vyamusakula mupewa. ");
INSERT INTO wmw_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Umwe muri kamba nkonjo ntoto wa makondoo, musope! Baba wenu kawa radi pakulu kukupani ufalume wake. ");
INSERT INTO wmw_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Uzanyani vyamuri nawo, nzuruku‑wo muwape masikini. Ritendereni poci sazuluvala, mali mbinguni aana mwinsho. Eko aapo mwivi wakwiwa, wala uswa wakwaribu. ");
INSERT INTO wmw_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Konta paari mali enu, na moyo wenu ndi pauri nopo!” ");
INSERT INTO wmw_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Insa akamba tena: “Ritengezeni, muvare muririmbise na ukanda wakurimba, na kandiyeru zenu zikorere. ");
INSERT INTO wmw_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Muwe kamba watumisi vyawanrinda mwenye wawo kuludi kusherehe ya harusi, ipate akija akibiya nryango, kwa mpunde noure, wanfungurire. ");
INSERT INTO wmw_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Heri watumisi wakuwa mwenye nakuja, awasingana tayari wakinang'anizira. Nukwambirani kweli, aritengeza, amwikaza na ahundumu cakurya. ");
INSERT INTO wmw_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ikiwa kaja zamu yapiri au yatatu akiwasingana wakinang'anizira, heri watumisi wakutenda javyo! ");
INSERT INTO wmw_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ijiwani eci kinu‑ci javi: inawa mwanyewe nyumba akwijiwa wakati wakuja mwivi, singari kamwasa akipapatula nyumba yake. ");
INSERT INTO wmw_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Basi, muwe tayari novyo kamana wakati samudanizira ndi paaja Binadamu wa Binguni.” ");
INSERT INTO wmw_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Peduru akinjibu Insa: “Mwenye, eci kinyume‑ci kwankusowera kwetu ofwe basi, au ka wanu piya?” ");
INSERT INTO wmw_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Mwenye akijibu: “Amiri mwaminifu, ári na ankili, wakuwa mwenye wake amwamini kumwasira watumisi wake piya, awape poso na wakati wake, nani? ");
INSERT INTO wmw_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Heri noyo ntumisi‑yo wakuwa akiludi mwenye wake, ansingana akitenda javyo. ");
INSERT INTO wmw_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nukwambirani kweli kuwa antula ntumisi‑yo kuwa amiri wa vinu vyake piya. ");
INSERT INTO wmw_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Fala dalili ntumisi‑yo awaza mmoyo mwake javi: ‘Mwenye wangu kankukawa kuja’, ndimana akanza kuwatabisha wenziwe waka na walume, akurya na akunywa mpaka kurewa. ");
INSERT INTO wmw_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ikiwa ntumisi atenda javyo, mwenye wake akija suku saakinrindira na wakati sejiwa, basi amwawanya vipande-vipande, antula nkonjo wa wanu sawamini. ");
INSERT INTO wmw_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Kweli, ntumisi wakwijiwa nafsi ya mwenye wake ila akasa kutengeza na kutenda nafsi‑yo, akuja kwibiiwa pakulu. ");
INSERT INTO wmw_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Fala ire sejiwa nafsi ya mwenye wake, na akitenda kinu cakujuzi kuhukumiwa, akuja kwibiwa aba. Basi, mwenyé kupewa vingi, alazimishiwa vingi. Ázidi kupewa vingi, iye azidi kulazimishiwa vingi.” ");
INSERT INTO wmw_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Insa akiwambira: “Omi nija kutaya moto duniya, vinajibu kuwa ukorere futi. ");
INSERT INTO wmw_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nijuzi noziwe, niuzunika pakulu mpaka vitimiziwe. ");
INSERT INTO wmw_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Mudaniza kuwa nija niwape wanu salama duniya‑yi? Nukwambirani, sivyo javyo, ila nija niwatenze kwawanyana. ");
INSERT INTO wmw_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kamana mwanzo wa sambi‑pa, wanu watanu nnyumba wakwawanyana, watatu wabishana na wawiri, na wawiri wabishana na watatu. ");
INSERT INTO wmw_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Wakwawanyana: wawa abishana na mwana, mwana abishana na wawa; mama abishana na mwana muka, mwana muka abishana na mama; mukwe abishana na alombíwe, alombíwe abishana na nkwewe.” ");
INSERT INTO wmw_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Insa akiwambira umati ure tena: “Mukiwona mawingu akilamuka upande wa magaribi, mpunde nowo mukwamba: ‘Ikunya nvula.’ Na vikuna novyo. ");
INSERT INTO wmw_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Mukiwona ikivuma mepo ya kashikazi, mukwamba: ‘Kukuja kuvujusa.’ Na vikuna novyo. ");
INSERT INTO wmw_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Manafiki sumwe! Mukwijiwa kwereza mana a alama za ardhi na za bingu. Basi, mana a ewu wakati‑wu mutowaja kutambula?” ");
INSERT INTO wmw_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Insa akizidi kusowera, akamba: “Sababuni umwe kutowa kulamula viri na shariya? ");
INSERT INTO wmw_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ukilongozana na aduwi wako, mukuka kumilandu, tenda jitiyadi mwaha wenu wise salama muri munjira. Tenda javyo, asije kukufikisa ka nlamuri, na iye akupereke ka mwandishi akutware akutaye nkalaboshu. ");
INSERT INTO wmw_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nukwambira kuwa aulawa‑mo sauripire nzuruku piya!” ");
INSERT INTO wmw_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Nowo wakati‑wo, wákiwapo noko wanu wamojawapo wamwambira Insa kuwa Pilatu katwala damu ya waGalileya wamojawapo, kasanganya na kafara yawo ewo. ");
INSERT INTO wmw_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Insa akiwadairi: “Muwaza kuwa waGalileya waulaiwe‑wo wákiwa wamádambi pakulu kuwapunda waGalileya wengine, ndimana watabika javyo? ");
INSERT INTO wmw_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nukwambirani awawere! Fala mukikatala kutubiya, nomwe novyo mukufwa piya. ");
INSERT INTO wmw_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Au ware kumi na wanane uwagwirire nnara wa Siloamu, ukiwolaya, mudaniza kuwa ewo wákiwa wamádambi pakulu kuwapunda wanu wengine wekala Yerusalemu? ");
INSERT INTO wmw_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nukwambirani awawere! Fala mukikatala kutubiya, nomwe novyo mukufwa piya.” ");
INSERT INTO wmw_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ikisa Insa akisowera eci kinyume‑ci, akamba: “Ákiwapo mwananlume mmoja âvyarire nfigu mmasamba mwake a uva. Suku‑yo akija kunang'aniza visumo, fala aasingane anta kisumo kimoja. ");
INSERT INTO wmw_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Akimwambira ntumisi wake javi: ‘Sikiriza! Muda wa myaka mitatu ninang'aniza muti‑wu kamba ukupa visumo, fala sisingane anta kimoja. Basi, sinja muti‑wu! Waribirani rutuba pansi‑pa?’ ");
INSERT INTO wmw_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ntumisi ire akijibu, akamba: ‘Mwenye, asani muti‑wu nowu mwaka‑wu, mpaka nisimbe nanyenje yawo‑yi, nitayirire tiba ya rutuba. ");
INSERT INTO wmw_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Mwaka usaka kuja‑wo, ukipa visumo, mukwasa. Fala ikiwa aupere, músinja.’ ” ");
INSERT INTO wmw_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Suku moja sabadu, Insa akiwafunda wanu nsinagoga moja. ");
INSERT INTO wmw_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ákiwepo nomo mwanamuka mmoja ákiwa nlwere, akimilikiwa na jini antenzire kuveya, kalwala muda wa myaka kumi na minane. Întumba minyongo, aakikidiri kwinuka. ");
INSERT INTO wmw_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Insa pammonire, kamwita, akimwambira javi: “Mama, kufunguriwa ulwere wako‑wo!” ");
INSERT INTO wmw_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Iye akintula makono, na mpunde noure, mwanamuka ire akoloka, akanza kuntukuza Mwenyezimungu! ");
INSERT INTO wmw_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Fala nkulungwa wa sinagoga akikimiwa pakulu futi kwa sababu Insa kâmponesa mwanamuka ire suku takatifu. Kawambira wanu ware javi: “Sumana iwa nawo suku sita zakukoriwa kazi. Basi, njoni muponesiwe nozi suku‑zi, fala musije suku ya sabadu.” ");
INSERT INTO wmw_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ikisa Mwenye akinjibu akamba: “Manafiki! Umwe kila mmoja aanfungula ng'ombe au buru wake pafukutu, kuka kunnywesa maji, ingawa suku takatifu? ");
INSERT INTO wmw_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Sambi eyu mwana muka wa Iburahima‑yu kâfungíwa na Ibilisi myaka kumi na minane, aajuzi kufunguriwa alucema‑zi suku ya sabadu?” ");
INSERT INTO wmw_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Nakusowera vinu‑vi, piya wakinsutumu ware wakiriwonera haya. Na piya wanu wákiwa radi na mambo matukufu aâkitenda Insa. ");
INSERT INTO wmw_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ikisa Insa akiwadairi: “Ufalume wa Mwenyezimungu ulandana na kinani? Kinani canisaka kulandanisa? ");
INSERT INTO wmw_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ulandana na mbeyu ya mostarda yaavyala munu mmasamba mwake. Ikula, ulawirira muti nkulu wawenye, na nyuni wajenga vitundu nvitambi mwawo‑mo.” ");
INSERT INTO wmw_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ikisa akiwadairi mara nyengine tena javi: “Ufalume wa Mwenyezimungu ulandana na kinani? ");
INSERT INTO wmw_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Uwa kamba furumento yaatwala mwanamuka, akisanganya na vipimo vitatu vya ufu mpaka newo ukilovodari piya.” ");
INSERT INTO wmw_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Insa akizidi kuka na safari yake yakuka Yerusalemu, mmakaya makulu na matoto ákipita akiwafunda wanu. ");
INSERT INTO wmw_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Munu mmoja akindairi: “Mwenye, wanu wavushiwa ndi aba?” Iye akiwajibu: ");
INSERT INTO wmw_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Tendani jitiyadi mwingire nryango mpusu. Kamana nukwambirani kuwa wengi wakuja kusakula kwingira fala awaja kukidiri. ");
INSERT INTO wmw_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Mwanyewe nyumba paasaka kulamuka, akifunga nryango‑wo, mukibaki mwimire panja mukibisha nryango‑wo kuno mukamba: ‘Mwenye, tifungurire’, iye akukujibuni akwambirani javi: ‘Sukwijiwani kamulawa.’ ");
INSERT INTO wmw_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ikisa, mukwanza kwamba: ‘Ofwe tikiryanga na tikinywanga nawe pamoja, na ukitifundanga mmaluwanja mwetu.’ ");
INSERT INTO wmw_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Fala iye akuja kwamba: ‘Nukwambirani, sukwijiwani kamulawa. Nitanukeni‑pa, umwe wanu wa vitendo vibaya-mwe!’ ");
INSERT INTO wmw_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Epo ndi pacija kuwepo kiriro na kutafuna meno, pamummona Iburahima na Izaki na Yankubu pamoja na minabii piya muufalume wa Mwenyezimungu fala umwe mukwefyeriwa panja. ");
INSERT INTO wmw_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Basi, wanu wakuja kulawa malawira-juwa, maswera-juwa, kibula, pamoja na suheli, mukwikala kurya muufalume wa Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ndi kweli, wawapo wanu wari mwinsho waja kuwa watanzi, na wawapo watanzi waja kuwa wa mwinsho.” ");
INSERT INTO wmw_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Nowo wakati‑wo, wakija Mafarizeu wamojawapo ka Insa, wakimwambira javi: “Lawa‑pa uke vyako, konta Herodi asaka akuulaye!” ");
INSERT INTO wmw_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Insa akiwajibu: “Mukuka kamwambireni noyo rikule‑yo, kuwa ningari kuwatuwisa mashetwani na nankuwaponesa wanu rero na makeshamungu, mpaka suku yatatu kazi zangu nifikisa mwinsho. ");
INSERT INTO wmw_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Novyo-sivyo, isakikana nizidi kusafiri rero, makeshamungu, na ntondo, kamana nabii aajuzi kufwira kaya nyengine sairi Yerusalemu. ");
INSERT INTO wmw_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Yerusalemu, Yerusalemu! Uwe uwolaya minabii, na uwefya mawe watumiwe kwako! Mara nyingi zawenye nikisaka kuwakusanya wanu wako, kamba uku vyawakusanya wanawe mumbawa, fala amusakire! ");
INSERT INTO wmw_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Sambi, ona! Isamiwa nyumba yenu. Nukwambirani kweli kuwa amuniwona tena mpaka pamusaka kwamba: ‘Ajanliiwe ája kwa zina ra Mola!’ ” ");
INSERT INTO wmw_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Suku moja, sabadu, Insa paakingira nyumba ya nkulungwa mmoja wa Mafarizeu kurya, ewo wakintunza sana-sana. ");
INSERT INTO wmw_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ona, na mbere yake ákiwepo mwananlume mmoja akíwa na matende mmaulu na mmakono. ");
INSERT INTO wmw_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Insa akiwadairi wanlimu wa shariya na Mafarizeu javi: “Halali kumponesa munu suku ya sabadu au siyo halali?” ");
INSERT INTO wmw_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ewo wakinyamala. Basi, Insa akintwala nlwere ire, akimponesa, akimwambira alawe oke vyake. ");
INSERT INTO wmw_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ikisa akiwambira: “Pamuri‑pa, nani wakuwa mwanawe au ng'ombe wake kagwirira munrimbu, oka kunlavya kwa mpunde nowo, anta paiwa suku ya sabadu?” ");
INSERT INTO wmw_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Na kuhusu vyawadairire vire aalawirire wakukidiri kunjibu kinu. ");
INSERT INTO wmw_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Insa, paawawonire wanu warifiwe ware namuna vyawakitondola viti bora, kawambira nkinyume akamba: ");
INSERT INTO wmw_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Ikiwa kwarifiwa na munu mojawapo kusherehe ya harusi, usikare kiti bora asije kuja munu arifiwe bora zaida ya uwe, ");
INSERT INTO wmw_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","na mwenyé jambo akwarifireni wo‑wawiri-mwe, akwambira javi: ‘Mpitise‑po mwenye‑yu ekare!’ Basi ukuja kuwona haya kwikala nyuma ya wanu. ");
INSERT INTO wmw_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Fala ukarifiwa kujambo, ukuka, ikala nyuma. Kwa javyo, akija akwarífire onse, akwambira: ‘Rafiki yangu, njo wikare mbere kuno.’ Basi, ndi pausaka kupata swifa mbere ya wanu piya waurinamire nawo‑wo. ");
INSERT INTO wmw_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Konta kila mwenyé kurisifu mwanyewe akuja kukejeliwa, na munu wa kurinyenyekeya, asifiwa.” ");
INSERT INTO wmw_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ikisa Insa akimwambira amwarífire ire: “Ukiwarifu wanu kuka kurya nawo au kutenda nawo sherehe, usiwarifu marafiki zako wala wanduzo, wala wajamaa zako wala majirani wako matajiri, wasije newo kukwarifu, wariripire vyautendire uwe. ");
INSERT INTO wmw_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ila, ukitenda jambo, warifu masikini, wanu wakubadilika, wakutumbela, na vipofu. ");
INSERT INTO wmw_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ujanliiwa kamana ewo awana cakukuripa. Ila maripo ako uwe awa suku ya kufufuka wenye ukamilifu.” ");
INSERT INTO wmw_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Kati ya wanu wename kurya ware, munu mmoja paasikire javire, kamwambira Insa javi: “Heri ája kurya mikate muufalume wa Mwenyezimungu!” ");
INSERT INTO wmw_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Fala iye akinjibu javi: “Ákiwepo mwananlume mmoja kâtengeza jambo rikulu futi, akiwarifu wanu wengi wawenye. ");
INSERT INTO wmw_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Paufikire wakati wakurya, akintuma ntumisi wake awambire warifíwe ware javi: ‘Njoni, vinu piya viwa tayari.’ ");
INSERT INTO wmw_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Fala piya ware kwa ankili moja, wakanza kulebela nswamaa. Wakwanza akimwambira: ‘Omi niuza uweru, nijuzi nikawone, nukulebela uniswamii.’ ");
INSERT INTO wmw_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Mwengine akamba: ‘Omi niuza ng'ombe mbiri-mbiri joshi ntanu, inibidi nikawayerere, nukulebela uniswamii.’ ");
INSERT INTO wmw_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Mwengine ire akamba: ‘Nilomba sambi, ndimana sija!’ ");
INSERT INTO wmw_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ntumisi ire akiludi, akija akimwambira mwenye wake vyaambiriwe vire. Mwenye wake ire akikimiwa pakulu futi, akimwambira ntumisi ire javi: ‘Lawa upesi-upesi, uke mmabarabara na mmanjira a kaya. Ukawarifu wamasikini, wanu wakubadilika, vipofu, pamoja na wakutumbela waje wengire‑mu.’ ");
INSERT INTO wmw_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ikisa ntumisi ire akimwambira mwanyewe javi: ‘Mwenye, nitenda piya kamba vyamunitumire, na mpaka‑pa maburu awapo.’ ");
INSERT INTO wmw_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Basi, mwanyewe ire akimwambira ntumisi wake: ‘Lawa uke mmabarabara na mmipaka, uwashurutise wanu waje wengire ipate nyumba yangu ijare. ");
INSERT INTO wmw_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nukwambirani kweli kuwa ware warifíwe ware, anta mojawapo aaja kuyeza aba cakurya cangu!’ ” ");
INSERT INTO wmw_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Junudi ya wanu wengi wajumana na Insa. Iye akizungunuka, akiwambira: ");
INSERT INTO wmw_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Munu ája kwangu, ikiwa aanipenda pakulu koliko wawaye, mamaye, nkawake, wanawe, wanduze, walumbuze, anta na mainsha ake mwanyewe, munu‑yo siyo mwanafunzi wangu. ");
INSERT INTO wmw_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Saasukula nsalaba wake mwanyewe akinifulata omi, iye aawa mwanafunzi wangu. ");
INSERT INTO wmw_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Nkati yenu, munu akisaka kujenga nyumba, akwanza kwikala, atenda isabu awone kamba kanawo nzuruku wakutosha kujengera nyumba‑yo, sinovyo? ");
INSERT INTO wmw_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Akasa kutenda javyo, bandi ya kujenga aluserusu, ásokerera kumariza, wanu wawóna, piya wanseka. ");
INSERT INTO wmw_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Wakwamba javi: ‘Mwananlume‑yu kanza kujenga‑pa fala kasokerera kumariza!’ ");
INSERT INTO wmw_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Na novyo, nfalume mmoja akisaka kuka kutenda vita na nfalume mwenziwe, kwanza akwikala kuwaza kamba masurudadu wake alufu kumi wanawo uwezo wakuwashinda masurudadu alufu shirini wari kuja kutenda naye vita. Sikweli? ");
INSERT INTO wmw_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ikiwa aana uwezo, iye anta ekare baidi, atumiza kulebela watende miyadi ya kupatana kwa usalama. ");
INSERT INTO wmw_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Kati yenu umwe piya, saasa vinu vyake piya, aawa mwanafunzi wangu.” ");
INSERT INTO wmw_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Munyu kinu cema, fala ikiwa munyu ure ulamwa, cilungiriwa kinani? ");
INSERT INTO wmw_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Aufãi kinu muardhi wala kutenda tiba ya rutuba, ila ukwefiwa kunundu. Ári na masikiro a kusikira, asikire!” ");
INSERT INTO wmw_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Sambi, warípisi nsoko na wamádambi piya wakinfika karibu wansikire vyaasowera. ");
INSERT INTO wmw_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Kwa javyo, Mafarizeu pamoja na wanlimu wa shariya wakiduguda pakulu, wakamba: “Eyu awapokerera wanu wamádambi na akurya nawo!” ");
INSERT INTO wmw_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Basi, Insa akiwasowerera eci kinyume‑ci, akamba: ");
INSERT INTO wmw_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Tulani kuwa munu mmoja kati ya umwe akuwa na makondoo miya, mmoja akwasika. Sikweli kuwa iye awasa tuswini na kenda ware kunundu noko, apita akinsakula mpaka ammone asíke ire? ");
INSERT INTO wmw_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Akimmona, ansukula mmaweya, kuno akitenda radi. ");
INSERT INTO wmw_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Nakufika ukaya, aweta majirani wake pamoja na marafiki zake, awambira: ‘Tendani radi pamoja nomi, konta kondoo wangu ásike ire, nimmona.’ ");
INSERT INTO wmw_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nukwambirani kuwa ndi novyo-novyoni, ikuwepo radi binguni kwa sababu ya mmadambi mmoja wakutubiya koliko wenye kutenda shariya tuswini na kenda sawana haja ya kutubiya.” ");
INSERT INTO wmw_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Insa kawasowerera kinyume cengine: “Tulani kuwa mwanamuka mmoja akuwa nawo jarajara kumi za parata, imwasika mmoja. Asaka kutendaja? Aakoreza kandiyeru, aafyãira nnyumba, kuno akisakula more-more mpaka awone? ");
INSERT INTO wmw_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Akiwona, akuka kuweta marafiki zake pamoja na majirani wake, awambira javi: ‘Tendani radi pamoja nomi konta ire jarajara inasike ire, niwona.’ ");
INSERT INTO wmw_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nukwambirani kuwa ndi novyo-novyoni, iwapo radi pakulu sana mbere ya malaika wa Mwenyezimungu kwa mmadambi mmoja wakutubiya.” ");
INSERT INTO wmw_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ikisa Insa akamba: “Ákiwapo mwananlume mmoja akíwa na wana wawiri. ");
INSERT INTO wmw_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Kifindi ire akinlebelela wawaye: ‘Baba, fungu rangu ra irati yangu, niritiseni.’ Basi wawaye ire akawanya vinu vire mafungu mawiri, kila mwana akimpa mali ake. ");
INSERT INTO wmw_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Azipitire suku nyingi, kifindi ire akikusanya vinu vyake vire piya, akisafiri akuka kaya ya baidi futi. Paafikire kure, akaribu piya nzuruku ure julu ya kuinshi visaka kuwa vyonse. ");
INSERT INTO wmw_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Paamarize kutumira nzuruku ure piya, noire inti ire ikija njala nyingi futi, akanza kusakula cakurya. ");
INSERT INTO wmw_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ndimana, akuka akipata kazi ka mwananlume mmoja wa noire kaya ire. Iye akimpereka masamba kwake kurisa nguluwe. ");
INSERT INTO wmw_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Basi mwana ire akihitari kulokota songolo zawakasa wanguluwe zire akirya. Fala aalawirire anta munu wakumpa kinu. ");
INSERT INTO wmw_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Mwinshoni, iye pavimwanuke, akamba kimoyomoyo: ‘Nyumba ya baba, wakazi wengapi waripo, ewo wakurya wakwikuta waremeza, fala omi kuno nankutabika na njala! ");
INSERT INTO wmw_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nilawa nukuka ka baba. Nikifika nimwambira javi: “Baba, nikosera binguni na nikosa mbere yenu. ");
INSERT INTO wmw_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Wala sijuzi tena kwitiwa mwanenu, fala tendani fadili, munipokerere kamba mukazi wenu mmojawapo!” ’ ");
INSERT INTO wmw_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Basi, akilawa, akuka ka wawaye. Wawaye ire kammona akija ári baidi. Kwa kuwa wawaye ire akimonera utungu mwanawe ire, akintuwirira. Nakufika pare, akimpatika na akimpa beju. ");
INSERT INTO wmw_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Mwana ire akimwambira: ‘Baba, nikosera binguni na nikosa mbere yenu. Wala sijuzi tena kwitiwa mwanenu.’ ");
INSERT INTO wmw_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Fala wawaye ire akiwambira watumisi wake: ‘Angupani! Njoni nawo mavazi meema noyo, munvaze. Nvazeni novyo mete mmakono mwake na tamango mmaulu. ");
INSERT INTO wmw_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Na njoni nawo ng'ombe wakunenepa noyo, munsinje. Timurye, kuno tikitenda sherehe ulu! ");
INSERT INTO wmw_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kamana mwanangu‑yu kâfwa futi, epa kavuka. Kâsika, epa sambi kawoneka!’ Newo wakanza kutenda sherehe ire. ");
INSERT INTO wmw_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ona, mwana ntanzi nowo wakati‑wo ákitenda kazi masamba. Pakuludi ári karibu na ukaya, kasikira ngoma ikiviniwa. ");
INSERT INTO wmw_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Nakufika, akimwita ntumisi mmoja, akindairi: ‘Cikunire kinani?’ ");
INSERT INTO wmw_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ntumisi ire akimwambira javi: ‘Nduyo kaludi, sambi wawayo kansinja ng'ombe wakunenepa ire, konta kampokerera mwanawe ári nkomu.’ ");
INSERT INTO wmw_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Paasikire javire, mwana ntanzi ire akikimiwa pakulu futi, aakisaka kwingira nnyumba mure. Ndimana, wawaye ire akilawira panja pare, akintafadali engire. ");
INSERT INTO wmw_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Fala iye akinjibu wawaye, akamba: ‘Onani, myaka mingi yawenye nukutumikirani, tangu sinamba kukatala ámuri zenu! Fala umwe amunamba kunipa nanga mbuzi moja, nikitenda sherehe na marafiki zangu! ");
INSERT INTO wmw_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Fala sambi kafika mwanenu aribire nzuruku wenu na mareba‑yu, munsinjira ng'ombe wakunenepa pakulu noyo!’ ");
INSERT INTO wmw_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Wawa ire akamba: ‘Mwanangu, uwe daima kuwa nnomi, na paapitire mali‑zi pakaya‑pa zako. ");
INSERT INTO wmw_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ila ibidi titende sherehe, tiwe radi, konta nduyo kâfwa, kaludira kuinshi! Iye kâsika, epa sambi kawoneka!’ ” ");
INSERT INTO wmw_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Na tena, Insa kawambira wanafunzi wake javi: “Ákiwapo mwananlume mmoja tajiri, ákiwa nawo amiri wa mali zake. Tajiri ire akambiriwa: ‘Amiri wako‑yo mali ako atumiranga caputu.’ ");
INSERT INTO wmw_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Basi, tajiri ire akimwita, akindairi: ‘Caniri kusikira‑ci kuhusu uwe‑po ndi kinani? Ereza vyautumire mali‑yo kwa sababu aujuzi kuwa amiri wangu tena.’ ");
INSERT INTO wmw_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Amiri ire akiriwazira iye mwanyewe: ‘Epa sambi, nisaka kutendaja? Mwenye wangu kankunilavya kazi. Omi kurima sikidiri, na kulebela zimola niwona haya. ");
INSERT INTO wmw_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Sambi, nijiwa vyanisaka kutenda ipate nikilaviwa kazi, wanu wanipokerere mmanyumba mwawo.’ ");
INSERT INTO wmw_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Basi, iye akanza kuweta mmoja-mmoja wari na deni ka mwenye wake. Wakwanza akimwambira javi: ‘Mwenye wangu akuwira kadirini?’ ");
INSERT INTO wmw_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Iye akijibu: ‘Vipimiro miya vya mafuta.’ Iye akimwambira: ‘Twala waraka yako‑yi, wikare upesi-upesi, wandike amusini.’ ");
INSERT INTO wmw_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ikisa, akindairi mwengine ire: ‘Uwe, uwiriwa kadirini?’ Iye akijibu: ‘Maguniya miya a tirigu.’ Amiri ire akimwambira: ‘Twala waraka yako‑yi, wandike tamanini.’ ");
INSERT INTO wmw_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Mwenye tajiri ire akinsifu amiri saari kamilifu ire kwa kuwa katenda ankili ya maarifa. Kamana wana wa ewu ulumwengu‑wu wajanja pakulu kuhusu vinu vya mulumwengu‑mu koliko wana wa nuru wajanja kuhusu vinu vya ulumwengu usaka kuja. ");
INSERT INTO wmw_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Na nukwambirani javi: Tumirani mali a mulumwengu‑mu muwapate marafiki, ipate pavija kutowa vinu vya mali wakukaribisheni mamburo a milele. ");
INSERT INTO wmw_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Mwaminífu wa vinu vitoto, na vinu vikulu novyo akuwa mwaminifu. Nkósi shariya wa vinu vitoto, na vikulu nevyo novyo akosa shariya. ");
INSERT INTO wmw_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ikiwa amuri waminifu wa mali a mulumwengu‑mu, nani asaka kukwaminini mali a kweli? ");
INSERT INTO wmw_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Na ikiwa amwaminika na mali za munu mwengine, nani asaka kukupani vyenu umwe wanyewe? ");
INSERT INTO wmw_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Aapo ntumisi anta mmoja akidiri kuwatumika mamwenye wawiri. Siti mwenye mmoja amwina, mwenye mwengine ampenda, au mmoja ampendeleya, mwengine ankejeli. Basi, avikidirika kuntumika Mwenyezimungu na mali.” ");
INSERT INTO wmw_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Mafarizeu wakisikira piya‑vi na, kwa kuwa nzuruku ukiwajibu pakulu, wakinkejeli Insa. ");
INSERT INTO wmw_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Insa akiwambira: “Umwe muritula kamba wanu wakukamilika mbere ya wanu, fala Mwenyezimungu akwijiwa myoyo yenu. Kamana vinu vyawakurisa wanadamu, ndi haramu mbere ya Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Taureti ya Musa na kufunda ka minabii vyereziwa mpaka wakati wa Yahaya. Mwanzo wa nopo yankwereziwa Habari Ngema kuhusu ufalume wa Mwenyezimungu, na piya wakikukulula kwingira. ");
INSERT INTO wmw_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Fala raisi bingu na ardhi kwisa, koliko kufujika kipande kimoja kitoto ca Taureti. ");
INSERT INTO wmw_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Kila mwenyé kumwasa nkawake akinlomba muka mwengine kankuzinga. Na kila mwenyé kunlomba muka wakwasiwa, neye novyo kankuzinga.” ");
INSERT INTO wmw_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Insa akamba: “Ákiwapo mwananlume mmoja tajiri, ákivalanga nguwo za rangi ya njambalãu na za linyu nyepepe. Daima‑zi ákitendanga jambo rikulu ra sherehe. ");
INSERT INTO wmw_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ákiwapo novyo masikini mmoja wakwitiwa Lazaru, kâturiwa panryango wa tajiri ire. Mwiri wake piya úkiwa na buba. ");
INSERT INTO wmw_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Iye kukimwajibungi kulokota songolo zakugwa sini ya meza paakirya tajiri ire. Anta umbwa zíkijanga zikinlamba-lamba buba ire. ");
INSERT INTO wmw_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Mwinshoni, masikini ire akifwa, akitwariwa na malaika akawe pamoja na Iburahima. Tajiri ire neye novyo akifwa, akizikiwa, ");
INSERT INTO wmw_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","akiperekiwa Kuzimu, noko akitabika pakulu futi. Nakulamusa uso, kawawona Iburahima pamoja na Lazaru wari baidi futi. ");
INSERT INTO wmw_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Basi, tajiri ire akinkuwira Iburahima, akamba: ‘Baba Iburahima, niwonere utungu! Ntume Lazaru‑yo aje kuno, mwinsho ya cala cake‑co acoveke mmaji, aje anidonosere palulimi‑pa. Nankutabika pakulu na malulimi a moto!’ ");
INSERT INTO wmw_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Fala Iburahima akimwambira: ‘Mwanangu, kumbukira kuwa kupokerera vinu vyako vyema kati ya mainsha ako, na Lazaru novyo kapokerera vinu vibaya. Fala sambi nopa, iye kankunyamaziwa, uwe kwankutabika. ");
INSERT INTO wmw_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Visitoshe, riwapo pondo rikulu rititanusa umwe nofwe ipate asakúla kukiruka kulawa kuno kuja eko asikidiri, wala kulawa kwenu‑ko kuja kwetu kuno!’ ");
INSERT INTO wmw_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Tajiri ire akamba: ‘Basi, nukulebelani baba, ntumeni Lazaru kunyumba ya wawa. ");
INSERT INTO wmw_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Nanawo wanduzangu watanu ukaya‑ko, oke akawambire wasije kufika epa mahala patabu‑pa.’ ");
INSERT INTO wmw_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Fala Iburahima akinjibu: ‘Ewo wanawo vyawafundiwe na Musa na vyawalaiziriwe na minabii wengine. Wawasikirize nowo.’ ");
INSERT INTO wmw_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Tajiri ire akamba: ‘Ha, baba Iburahima. Fala mmojawapo kati ya wafwi inawa akuka mpaka noko, ewo nanga watubiya.’ ");
INSERT INTO wmw_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Iburahima akijibu: ‘Ikiwa ewo awasaka kunsikiriza Musa pamoja na minabii, anta munu alawe ka wafwi, neyo novyo aazungunusa mawazo awo.’ ” ");
INSERT INTO wmw_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Insa kawambira wanafunzi wake javi: “Daima munu vinkuna vinu vya kunkosesa, fala alaniwe ire akosésa! ");
INSERT INTO wmw_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ndi fadari kwake iye afungiriwe nsingo riwe rikulu rakuremera, efyeriwe mbahari, koliko kunkosesa ewa watoto‑wa mmojawapo. ");
INSERT INTO wmw_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","More-moreni umwe wanyewe! Ikiwa nduyo kakukosa, nsutumu. Akitubiya, nswamii. ");
INSERT INTO wmw_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Anta iye paakukosa mara saba kutwa moja noyo, na kila mara akija akitubiya kulebela nswamaa, ujuzi unswamii.” ");
INSERT INTO wmw_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Mawalii wamwambira Mwenye Insa, wamba: “Tongeze kwamini kwetu!” ");
INSERT INTO wmw_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Mwenye akamba: “Munawa nawo kwamini aba kamba utoto wa mbeyu ya mostarda, nanga musowerera muti nkulu‑wu: ‘Siuka, ukarisomeke mbahari!’, newo nanga ukusikirizani!” ");
INSERT INTO wmw_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Tulani kwa nfano, umwe mmojawapo akuwa na ntumisi wa masamba au wakusunga mifuwo. Iye akiludi, utakumwambira kuwa njo kuno upesi pameza‑pa, wikare urye? Aumwambira javyo futi! ");
INSERT INTO wmw_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ila umwambira: ‘Tengeza cakurya nirye. Vala mavazi‑yo, uniudumu nirye, ninywere maji. Ikisa, nowe urye, unywe maji.’ Sinovyo? ");
INSERT INTO wmw_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Atakunshukuru ntumisi‑yo kwa kuwa katenda vyaatumiwe? ");
INSERT INTO wmw_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Nomwe novyo, mukisa kutenda piya vyamutumiwe, mwambe: ‘Ofwe tiwa watumisi satijuzi kusifiwa. Titimiza kutenda vitibidire tu basi.’ ” ");
INSERT INTO wmw_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Insa, paakuka Yerusalemu, akipita kati-kati ya Samariya na Galileya. ");
INSERT INTO wmw_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Pengire kaya mója, wanu kumi walwere magundula wakimukira, wámwimira, baidi aba. Wakikuwa wakamba: ");
INSERT INTO wmw_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","“Insa, mwanlimu, tiwonere utungu!” ");
INSERT INTO wmw_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Insa akiwanang'aniza, akamba: “Ukani, mukarolote ka walongozi wa dini.” Ewo nakulawa wakuka, wakiponesiwa. We! ");
INSERT INTO wmw_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Mmoja kati ya noware, paawonire kuwa kaponesiwa, akiludira ka Insa nokure, kuno akinsifu Mwenyezimungu na shauti ulu‑ulu. ");
INSERT INTO wmw_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Akingwirira Insa mmaulu, akinshukuru. Ona, noyo ákiwa nSamariya. ");
INSERT INTO wmw_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Basi Insa akinjibu: “Omi siwaswafire wanu kumi? Sambi, kenda wandepi? ");
INSERT INTO wmw_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Mbena awawoneka‑pa wakiludi waje wampe Mwenyezimungu utukufu wake? Ila awoneka noyu myeni‑yu tu basi!” ");
INSERT INTO wmw_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Na Insa akimwambira mwananlume ire: “Lamuka, uke vyako. Kwamini kwako kukuvusha.” ");
INSERT INTO wmw_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Mafarizeu wamojawapo wandairi Insa: “Ufalume wa Mwenyezimungu ukuja kufika rini?” Insa akiwajibu: “Ufalume wa Mwenyezimungu auja na alama yakuwoneka. ");
INSERT INTO wmw_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Wala amwamba: ‘Ndiwu‑pa’ wala ‘Ndi ure pare’ kamana ufalume wa Mwenyezimungu uwa kati yenu.” ");
INSERT INTO wmw_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ikisa, akiwambira wanafunzi wake javi: “Ukuja kufika wakati wamuja kusakula kuwona suku mojawapo ya Binadamu wa Binguni, fala amuwona. ");
INSERT INTO wmw_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Wakuja kukwambirani javi: ‘Mmone-yu‑pa!’ au ‘Mmone ire pare!’ Fala musilawire panja wala musiwafulate. ");
INSERT INTO wmw_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Konta kamba kumensa vyakumesanga julu, kukimwarika upande moja mpaka mwengine, ndi vyaari Binadamu kwa suku yake. ");
INSERT INTO wmw_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Fala kwanza, ilazimu iye atabike vinu vingi, na akatariwe na wanu wa eci kizazi‑ci. ");
INSERT INTO wmw_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Kamba vyavikunire suku za Nnu ndi vyavija kuwa novyo suku za Binadamu wa Binguni. ");
INSERT INTO wmw_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Wanu wakirya, wakinywa, wakilomba na wakilombiwa, mpaka suku yengire Nnu nsafina, akija mwanalukaya akiwapoteza piya. ");
INSERT INTO wmw_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Kwa namuna mmoja novyo kamba vyavikunire suku za Loti: wakirya na wakinywa, wakiuza na wakiuzanya, wakivyala na wakijenga, ");
INSERT INTO wmw_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","fala suku yaalawire Loti Sodoma, moto na unga vikisuka julu kamba nvula, vikiwapoteza wanu piya. ");
INSERT INTO wmw_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Kwa namuna mmoja noyo ndi vyavija kuwa suku Binadamu wa Binguni yaaja kufafanuriwa. ");
INSERT INTO wmw_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Noyo suku‑yo, ája kuwa papala, asisuke kwingira nnyumba mwake kulavya vinu vyake. Na ája kuwa masamba, aaja kuwayi kuludira ukaya. ");
INSERT INTO wmw_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Kumbukirani cinkunire muka wa Loti. ");
INSERT INTO wmw_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Munu asaka kusunga mainsha ake, mwinsho apoteza. Fala munu apoteza mainsha ake, ásunga ukomu wake‑wo. ");
INSERT INTO wmw_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nukwambirani kuwa noyo suku‑yo usiku, wakuwapo wawiri wakulala kinanda kimoja, mmoja atwariwa, mwengine akwasiwa. ");
INSERT INTO wmw_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Wakuwapo wanawaka wawiri wakusaya pamoja ufu, mmoja atwariwa mwengine akwasiwa.” ");
INSERT INTO wmw_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Basi wanafunzi ware wakindairi: “Mwenye, víkuna ndepi?” Iye akiwajibu: “Mahala pauwa mwiri wakufwa, nopo ndi pawajumana marembo.” ");
INSERT INTO wmw_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Suku moja Insa kawambira wanafunzi wake kinyume kimoja cakuwa daima wájuzi watende duwa daima, wasisokeziwe. ");
INSERT INTO wmw_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Iye akamba: “Kaya mmoja ákiwapo mwenyé kulamula. Iye aakopesiwa na Mwenyezimungu wala aakimwinshimu munu asaka kuwa onse. ");
INSERT INTO wmw_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Noyo kaya‑yo, ákikalanga mwanamuka nankweli. Iye ákukanga ka mwenyé kulamula ire, akimwambira: ‘Nipe shariya yakunisaidiya na aduwi wangu.’ ");
INSERT INTO wmw_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Upita muda, mwenyé kulamula ire akikatala. Fala mwinshoni, akisowera kimoyomoyo, akamba: ‘Ingawa simopa Mwenyezimungu wala simwinshimu munu, ");
INSERT INTO wmw_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","fala, kwa kuwa nankweli‑yu asinipe kazi daima‑zi, basi nukumpa shariya yake ipate asije kunisokeza.’ ” ");
INSERT INTO wmw_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Mwenye akamba: “Sikirizani vyaasemire ire mwenyé kulamula saari kamilifu ire. ");
INSERT INTO wmw_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Novyo, Mwenyezimungu aawalamula kwa shariya wawatondore iye, wenye kunlalamikira iye usiku na nsana? Atakukawa kuwasaidiya? ");
INSERT INTO wmw_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nukwambirani kuwa iye awapatisa shariya yawo upesi-upesi! Novyo-sivyo, paasaka kuludi Binadamu wa Binguni, itakuwa awasingana mulumwengu‑mu wanu wakumwamini iye?” ");
INSERT INTO wmw_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ikisa tena Insa akiwasowerera kwa kinyume, akiwambira wamojawapo wakiritula kuwa wanu wa shariya, wakiwakejeli wenziwawo. Iye akamba javi: ");
INSERT INTO wmw_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Wanawalume wawiri woka nNyumba Takatifu kunlebela Mwenyezimungu. Mmoja ákiwa Nfarizeu, mwengine ákiripisanga nsoko. ");
INSERT INTO wmw_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Nfarizeu ire emire yeka, akilebela, akaamba javi: ‘Yarabi Mwenyezimungu! Nukushukuru kuwa omi siri mmadambi kamba vyawari wanu wengine: wanyang'anyi, wakosi shariya na wazinzi, wala kamba cakúripisa nsoko ire. ");
INSERT INTO wmw_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nifunga mara mbiri kila sumana, na nilavya fungu rakumi kwa piya faida zangu.’ ");
INSERT INTO wmw_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Fala cakúripisa nsoko ire kemira baidi, anta maso aakikidiri kufungula kunang'aniza julu. Ila ákiribiya pakifuwa kuno akamba: ‘Yarabi Mwenyezimungu, niwonere utungu, omi niwa mmadambi!’ ” ");
INSERT INTO wmw_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Insa akimariza akamba: “Nukwambirani kuwa eyu mwananlume‑yu kaludira kwake kakikishiwa mbere ya Mwenyezimungu, mwengine ire aakikishiwe. Kamana kila mwenyé kurikweza mwanyewe akwisusiwa, ila arisúsa mwanyewe akweziwa.” ");
INSERT INTO wmw_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Bandi ya vire, wanu wamojawapo wakija nawo wana watoto ka Insa ipate awakumbure na nkono wake awajanliye. Wanafunzi wake pawawawonire, wakikola kuwasutumu. ");
INSERT INTO wmw_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Fala Insa akiweta kuno akiwambira: “Waseni wasimana‑wo waje kwangu omi! Musiwakataze! Ufalume wa Mwenyezimungu, wanu kamba ewo ndi wawo. ");
INSERT INTO wmw_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nukwambirani kweli kuwa saapokerera ufalume wa Mwenyezimungu kwa namuna ya kisimana visaka kuwa vyonse aashubutu kwingira.” ");
INSERT INTO wmw_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Nkulungwa mmoja akindairi Insa javi: “Mwanlimu mwema, nitende kinani ipate niriti mainsha a milele?” ");
INSERT INTO wmw_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Insa akimwambira: “Kunita mwema sababuni? Aapo mwema, ila Mwenyezimungu tu basi! ");
INSERT INTO wmw_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Uwe ukwijiwa ámuri‑zi: ‘Usizinge, usiulaye, usiwe, usiseme ushahidi wa ulongo, uwenshimu wawayo na mamayo.’ ” ");
INSERT INTO wmw_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Iye akamba: “Ezi ámuri‑zi piya ndi zanifulata tangu niri nnemba.” ");
INSERT INTO wmw_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Nakusikira javire, Insa akimwambira: “Ila cukubakira kinu kimoja tu basi. Kauzanye piya vyauri nawo, nzuruku‑wo uwatongere masikini. Kwa javyo, uriturira mali mbinguni. Ikisa uje unifulate.” ");
INSERT INTO wmw_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Fala mwananlume ire paasikire vyaajibiwe vire, akiwuzunika pakulu konta ákiwa tajiri nkulu. ");
INSERT INTO wmw_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Noparepare Insa, nakummona mwananlume ire javire, akamba: “Virigariga wenye mali kwingira muufalume wa Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ndi kweli, raisi ngamiya kupenya kipenyo ca singano koliko tajiri kwingira muufalume wa Mwenyezimungu.” ");
INSERT INTO wmw_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Wanu wakisikira ware, wakindairi Insa: “Kwa javyo, avushiwa ndi wepi?” ");
INSERT INTO wmw_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Fala iye akijibu: “Vinu savikidirika na wanu, akidiri ndi Mwenyezimungu.” ");
INSERT INTO wmw_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Peduru akimwambira Insa: “Ona, ofwe tasa nyumba zetu tukufulata uwe.” ");
INSERT INTO wmw_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Iye akiwambira: “Nukwambirani kweli, hapana munu wakwasa nyumba yake, nkawake, wanduze, wawaze, au wanawe kwa ajili ya ufalume wa Mwenyezimungu, ");
INSERT INTO wmw_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","saapokerera maripo mara nyingi zawenye mulumwengu nomu. Novyo, bandi yakufwa, apata mainsha a milele.” ");
INSERT INTO wmw_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Insa akiwatwala wanafunzi kumi na wawiri ware, akiwambira javi: “Sikirizani! Tankuka Yerusalemu, koóka kutimiziwa piya mambo awandike minabii kuhusu Binadamu wa Binguni. ");
INSERT INTO wmw_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Kamana iye akuka kuperekiwa mmakono mwa Sawari-Mayahudi, ashupiwa, atukaniwa, na asuniriwa mata. ");
INSERT INTO wmw_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Nakwisa kuncapa, wamulaya, fala suku ya tatu, iye afufuka.” ");
INSERT INTO wmw_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Evi vinu‑vi ewo awereriwe anta aba. Vyaawambire vire wafisiwa, awakereriwa vyaakisowera vire. ");
INSERT INTO wmw_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Insa, paákifika karibu ya Yeriko, ákiwapo munu mmoja kipofu kekala nanyenje ya njira, akilebela zimola. ");
INSERT INTO wmw_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Kipofu ire, paawasikire wanu wengi wakipita, akiwadairi: “Kinu‑ci kinani?” ");
INSERT INTO wmw_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Wakimwambira: “Insa wa Nazareti ndi ári kupita.” ");
INSERT INTO wmw_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ndimana kipofu ire akanza kukuwa: “Insa, ujukulu wa Daudi, nitendere huruma!” ");
INSERT INTO wmw_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Walongorere ware wakinsutumu, wakimwambira anyamare. Fala iye kila mara akizidi kukuwa: “Mwana wa Daudi, nitendere huruma!” ");
INSERT INTO wmw_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Insa akimira, akitumiza waje nawo munu ire. Paajire karibu, Insa akindairi: ");
INSERT INTO wmw_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Usaka nukutende mwaja?” Iye akijibu: “Mwenye, nisaka niludire kuwona.” ");
INSERT INTO wmw_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Insa akamba: “Ludira kuwona! Kwamini kwako kukuvusha.” ");
INSERT INTO wmw_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Kwa mpunde noure, iye akanza kuwona, akinfulata Insa kuno akintukuza Mwenyezimungu. Na piya wanu pawammonire, wakinsifu Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Insa kengira Yeriko, akipita akenenda. ");
INSERT INTO wmw_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ákiwapo mwananlume mmoja wakwitiwa Zakeu, ákiwa nkulungwa wa warípisi nsoko, iye ákiwa tajiri. ");
INSERT INTO wmw_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Iye ákisakula ammone Insa na amwijiwe namuna zake. Fala aakikidiri konta wanu wákiwa wengi, na iye ákiwa mwipi pakulu. ");
INSERT INTO wmw_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Kwa javyo, akituwa mbere, akikwera mmuti ammone sana, kamana Insa ákiwa tayari kupita noire njira ire. ");
INSERT INTO wmw_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Insa, paafikire nopare mahala pare, akinang'aniza julu, akimwambira javi: “Zakeu, isuka upesi! Rero nijuzi nifikire nnyumba mwako.” ");
INSERT INTO wmw_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ndimana akisuka upesi-upesi, akimpokerera Insa nnyumba mwake kwa sherehe pakulu sana. ");
INSERT INTO wmw_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Junudi ya wanu ware pawawonire javire, piya wakiduguda, wakamba: “Iye kengira mwa mmadambi mure ndi mwafikire!” ");
INSERT INTO wmw_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zakeu akimira, akimwambira Mwenye: “Ona, Mwenye, nilavya nusu ya mali angu, niwapa masikini. Ikiwa kawapo waninnyáng'anye kinu, ninludisira mara nne.” ");
INSERT INTO wmw_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Insa akimwambira javi: “Rero eyi nyumba‑yi kufika kuvuka kwa sababu eyu novyo ujukulu wa Iburahima. ");
INSERT INTO wmw_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Kamana Binadamu wa Binguni kaja kunsakula na kunvusha ire asíke.” ");
INSERT INTO wmw_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Junudi ya wanu ware pawasikire evi, Insa akizidi kuwambira kinyume cengine konta ákiwa karibu kufika Yerusalemu, na kwa kuwa wakidaniza kuwa ufalume wa Mwenyezimungu ulawirira kwa mpunde noure. ");
INSERT INTO wmw_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Basi, iye akamba: “Ákiwapo mwananlume mmoja bora pakulu. Iye kasafiri akuka inti nyengine ya baidi. Koka akatawaziwe kuwa nfalume wa inti yake, ikisa aludi. ");
INSERT INTO wmw_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Kábula ya kulawa, kaweta wakazi wake kumi, kila mmoja akingabizi jarajara moja ya faida pakulu, akiwambira: ‘Curuzirani nzuruku‑wu mpaka omi niludi.’ ");
INSERT INTO wmw_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Fala wanu wa muinti mwake wakimwina. Ndimana, wakiwatuma wanu nyuma yake wakaseme javi: ‘Eyo mwananlume‑yo atinsaka kutitawala.’ ");
INSERT INTO wmw_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pesire kutawaziwa kuwa nfalume wa inti ire, akiludi. Akitumiza kuweta wákazi noware waâwasire nzuruku ware, ipate ejiwe faida yaapatire kila mmoja, kwa biyashara yawakitenda. ");
INSERT INTO wmw_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Akifika mukazi wakwanza ire, akamba: ‘Mwenye, omi nipatira faida mara kumi kwa nzuruku wamunipere.’ ");
INSERT INTO wmw_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Nfalume ire akamba: ‘Vyema pakulu sana! Kuwa amiri mwaminifu! Tangu pauwere mwaminifu wa kinu kitoto, ukuja kupata mamulaka julu ya makaya kumi.’ ");
INSERT INTO wmw_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ikisa akija amiri wapiri ire, akamba: ‘Mwenye, kwa nzuruku wenu ure, omi nipatira faida mara ntanu.’ ");
INSERT INTO wmw_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Nfalume ire akimwambira novyo: ‘Uwe ukuja kupata mamulaka julu ya makaya matanu.’ ");
INSERT INTO wmw_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Akija novyo mwengine, akamba: ‘Mwenye, nzuruku wenu ndiwu, nifindika munguwo nikitula, ");
INSERT INTO wmw_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","konta nikopa. Uwe kuwa munu mmoja ngumu, ulavya faida ya kazi sautendire, uvuna vinu saurimire.’ ");
INSERT INTO wmw_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Nfalume ire akijibu: ‘Uwe kuwa mukazi mbaya! Nukulamula julu ya usowezi wako mwanyewe. Uwe ukwijiwa kuwa omi niwa ngumu, nilavya faida ya kazi sanitendire, nivuna vinu sanirimire? ");
INSERT INTO wmw_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Sambi mbena nzuruku wangu‑wo auturire mbanku mojawapo? Omi pakuludi nanga nisingana nzuruku wangu pamoja na faida yake.’ ");
INSERT INTO wmw_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ikisa nfalume ire akiwambira wenziwe wákiwa karibu ware, akamba: ‘Mpokereni nzuruku eyu mukazi‑yu, mumpe apatíre faida mara kumi ire.’ ");
INSERT INTO wmw_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ewo wakimwambira: ‘Mwenye, iye kanawo futi jarajara kumi!’ ");
INSERT INTO wmw_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Nfalume ire akiwajibu: ‘Nukwambirani kuwa mwenyé kuwa nawo apewa pakulu, fala saana, caari nawo noco anyang'anyiwa. ");
INSERT INTO wmw_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Sambi, maaduwi sawakisaka kuwa omi nitawaziwe nfalume ware, njoni nawo kuno, muwolaye mbere yangu!’ ” ");
INSERT INTO wmw_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Insa pesire kwamba evi vinu‑vi, akilongorera akuka Yerusalemu. ");
INSERT INTO wmw_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Paafikire karibu ya makaya a Betifage na Betaniya, karibu ya mwango wa Mizaituni, Insa akiwatuma wanafunzi wawiri, ");
INSERT INTO wmw_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","akiwambira javi: “Ukani kaya íri mbere ire. Mukifika, munsingana buru kafungiriwa, iye tangu aanamba kupandiwa na munu mmojawapo. Nfungureni, muje naye kuno. ");
INSERT INTO wmw_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ikiwa munu kakudairini kuwa: ‘Munfungurirani?’, mwambireni javi: ‘Mwenye ndi ári kunsakula.’ ” ");
INSERT INTO wmw_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Basi, watumíwe ware nakuka, wasingana kamba vyaâwambire novire. ");
INSERT INTO wmw_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Nakunfungula buru ire, wanyewe wakiwadairi: “Mbena mankunfungula buru‑yo?” ");
INSERT INTO wmw_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ewo wakijibu: “Mwenye Insa ndi ári kunsakula.” ");
INSERT INTO wmw_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ikisa, wakinlongoza mpaka ka Insa, wakitandika nguwo zawo julu ya buru ire wakimpandisa Insa. ");
INSERT INTO wmw_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ikisa munjira mwakipita Insa, wanu ware wakitandika nguwo zawo. ");
INSERT INTO wmw_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Pawafikire karibu ya Yerusalemu, mahala pakwisukira Mwango wa Mizaituni, wanu piya wa kundi ra wanafunzi watenda radi, wakintukuza Mwenyezimungu kwa shauti ulu‑ulu kwa piya vitendo vya uwezo vyawakiwona. ");
INSERT INTO wmw_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ewo wakamba: “Heri nfalume ári kuja kwa zina ra Mola! Mbinguni iwepo salama, na julu pakulu uwe‑po utukufu!” ");
INSERT INTO wmw_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Mafarizeu wamojawapo wákiwa kati ya junudi ya wanu ware, wamwambira javi: “Mwanlimu, wadume wanafunzi wako‑wo!” ");
INSERT INTO wmw_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Iye akijibu: “Onani, ewa wakinyamala, mawe akwanza kutamba!” ");
INSERT INTO wmw_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Pawakiwa karibu yakufika, nakuwona kaya ya Yerusalemu, Insa akanza kurira, ");
INSERT INTO wmw_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","akamba: “Ha! Yerusalemu! Vikinajibu rero wijiwe vinu vija na usalama! Ila sambi‑pa kufisiwa mmaso mwako usiwone! ");
INSERT INTO wmw_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Kamana zikuja kukufikira suku maaduwi wako wakujengera ngulu zakukushambuliya, wakuzunguriza, wakukinya kila upande, ");
INSERT INTO wmw_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","wapita wakugwisira pansi pamoja na wanawo wari nkati yako. Ewo awasa riwe anta rimoja kubaki julu ya riwe renziwe, konta aumanyire wakati wajire Mwenyezimungu kukuvusha.” ");
INSERT INTO wmw_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Insa kengira Nyumba Takatifu, akanza kuwatuwisa wacuruzi, ");
INSERT INTO wmw_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","akiwambira javi: “Yandikiwa javi: ‘Nyumba yangu‑yo ikuja kuwa nyumba ya duwa.’ Fala umwe nyumba‑yi mutenda kuwa jonga ra wevi.” ");
INSERT INTO wmw_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Insa daima‑zi akifundanga nNyumba Takatifu mure. Wakulungwa wa dini, wanlimu wa shariya, pamoja na wakulungwa wa nkaya mure, wakisakula namuna yakumpoteza Insa. ");
INSERT INTO wmw_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Fala awakiwonerera namuna, konta wanu piya watengemana pakulu kunsikiriza. ");
INSERT INTO wmw_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Suku moja, Insa paakiwafunda wanu na paakereza Habari Ngema nNyumba Takatifu, wakilawirira nomo wakulungwa wa dini, wanlimu wa shariya, pamoja na walongozi, ");
INSERT INTO wmw_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","wakimwambira, wakamba: “Tambire, uwe evi vinu‑vi kwankutenda na mamulaka a nani? Eya mamulaka‑ya akupere nani?” ");
INSERT INTO wmw_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Insa akiwajibu, akamba: “Sambi, nomi novyo nukudairini kinu. Nambireni: ");
INSERT INTO wmw_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yahaya paakiwoza wanu, akitenda javyo kwa mamulaka a Mwenyezimungu au a wanadamu?” ");
INSERT INTO wmw_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ewo wakingira kukaidiyana, wakamba: “Tikinjibu kuwa ‘a Mwenyezimungu’, iye atidairi: ‘Umwe kutowa kunkubali Yahaya sababuni?’ ");
INSERT INTO wmw_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Fala, tikamba kuwa ‘a wanadamu’, wanu piya watipanja na mawe, konta wakikubali kuwa Yahaya nabii wakweli.” ");
INSERT INTO wmw_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Basi, mwinshoni wakinjibu javi: “Atijiwa.” ");
INSERT INTO wmw_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Insa akijibu: “Basi, nomi novyo sukwambirani mwanyewe mamulaka anitendesa evi vinu‑vi.” ");
INSERT INTO wmw_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Sambi, Insa akanza kuwasowerera wanu eci kinyume‑ci javi: “Mwananlume mmoja kavyala muti wake wakupa uva, akitula rani na warimi wamojawapo, ikisa akisafiri suku nyingi zawenye. ");
INSERT INTO wmw_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Paufikire wakati wa kutokota uva, iye kantuma ntumisi ka warimi kure ipate wakampe fungu ra mwenye wake ire. Fala warimi ware wakimwibiya, wakinludisa makono-waka. ");
INSERT INTO wmw_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ikisa, mwanyewe masamba ire akintuma ntumisi mwengine, neye novyo wakimwibiya, wakimwanziri, wakinludisa makono-waka. ");
INSERT INTO wmw_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Mwanyewe masamba ire akintuma ntumisi watatu, fala warimi ware neyo novyo wakinlumiza, wakintuwisa. ");
INSERT INTO wmw_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Basi, mwanyewe masamba ire akisowera kimoyomoyo akamba: ‘Sambi, nisaka kutendaja? Hã, nijiwa! Nimpereka mwanangu wanimpenda pakulu. Dalili wakuka kumwinshimu!’ ");
INSERT INTO wmw_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Fala warimi ware pawammonire mwana ire, wakisowera watupu-watupu: ‘Epa kankuja mwenyé haki yakuriti masamba‑ya! Tukeni timulaye, irati‑yo iwe yetu ofwe!’ ");
INSERT INTO wmw_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Basi, wakinlavira panja ya masamba are, wakimulaya.” Ikisa Insa akiwadairi: “Mwenyé masamba ire warimi ware awatendaja? ");
INSERT INTO wmw_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Iye akuja, awapoteza warimi‑wo, na masamba‑yo awemisira wanu wengine.” Wanu ware pawasikire javire, wamba: “Visikune javyo!” ");
INSERT INTO wmw_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Fala iye kawanang'aniza wanu ware rungu-rungu, ikisa kawadairi javi: “Sambi eya Mandiko‑ya javi: ‘Riwe rawakatare wajengi ndi rilawirire kuwa riwe maalumu’, mana ake kinani?” ");
INSERT INTO wmw_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Insa akizidi kusowera: “Agwiríra onse eri riwe‑ri akuwa kipande-kipande. Warisaka kungwirira eri riwe‑ri, asaika-saikanga atenda ufu.” ");
INSERT INTO wmw_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Wanlimu wa shariya na wakulungwa wa dini pawasikire kinyume cire, wakisaka wanfunge Insa kwa mpunde noure, konta wejiwa kuwa Insa kankuwasutumu ewo‑po, fala wakiwopa wanu ware. ");
INSERT INTO wmw_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Kwa javyo, wanlimu wa shariya na wakulungwa wa dini wakintunza Insa sana-sana. Ewo wawapereka wapererezi wamojawapo wakiritula kuwa wanu wakweli. Wakisakula wammonerere kamba iye asowera kinu cakunkoresa ipate wampereke ka guvinadoru, mwenyé uwezo na mamulaka. ");
INSERT INTO wmw_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ndimana wakindairi, wakamba: “Mwanlimu, tukwijiwa kuwa piya vyausowera na vyaufunda vyakweli, wala aulamula kwa kunang'aniza munu caari, ila kwankufunda kamili njira ya Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Sambi, tambire kinu kimoja: Ofwe tijuzi au atijuzi kunripa nsoko Kaisari?” ");
INSERT INTO wmw_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Fala Insa nakwijiwa ujanja wawo ure, akiwambira: ");
INSERT INTO wmw_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Nolotereni jarajara moja. Ewu uso‑wu na eya mandiko‑ya vyanani?” Ewo wakijibu: “Vya Kaisari.” ");
INSERT INTO wmw_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Iye akiwambira: “Basi, vinu vya Kaisari, mpeni Kaisari. Vinu vya Mwenyezimungu, mpeni Mwenyezimungu.” ");
INSERT INTO wmw_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Kweli, awapatire mbere ya wanu kunkoresa Insa na majibu ake. Kwasa javyo, washanga na majibu ake are, wakinyamala vii. ");
INSERT INTO wmw_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ikisa, wakinfika karibu Masaduseu wamojawapo, ware wakatála kuwa kuwapo kufufuka ka wafwi. ");
INSERT INTO wmw_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Ewo wakindairi Insa javi: “Mwanlimu, Musa katandikira eya mandiko‑ya javi: ikiwa munu kafwa, kamwasa nkawake saapongore naye wana, nduye marehemu ajuzi amwingire manyumba nankweli ire, filihali apongola naye rilunga rikolo. ");
INSERT INTO wmw_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Sambi, wákiwapo wana saba wawa mmoja na mama mmoja. Ntanzi kalomba, kafwa saapongore naye mwana. ");
INSERT INTO wmw_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Nduye wapiri, ");
INSERT INTO wmw_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","na watatu, neyo novyo wantwala muka ire, wanlomba awapongore naye mwana. Wo‑saba ware piya wanlomba awapongore naye wana, wafwa. ");
INSERT INTO wmw_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Mwinshoni, mwanamuka ire neye novyo akifwa. ");
INSERT INTO wmw_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Basi, suku ya kufufuka, mwanamuka ire akuja kuwa muka wa nani? Kamana wo‑saba ware wanlomba muka mmoja noire!” ");
INSERT INTO wmw_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Insa akiwajibu: “Duniya‑yi wanu walomba na walombiwa. ");
INSERT INTO wmw_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Fala waturiwe ubora kupata enzi zisaka kuja pawaja kufufuka ka wafwi, ewo awaja kulomba wala kulombiwa. ");
INSERT INTO wmw_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Kweli, awaja kufwa tena, konta wakuja kuwa kamba malaika. Ewo wana wa Mwenyezimungu kamana wafufuriwa ka wafwi. ");
INSERT INTO wmw_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Kuhusu mwaha wa kuwa wafwi wakuja kufufuriwa, anta na Musa wawenye kakikisha novyo paasowere kuhusu muti ukikorera. Iye kamwita Mola zina ra ‘Nlungu wa Iburahima, wa Izaki, na wa Yankubu.’ ");
INSERT INTO wmw_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Basi, iye siyo Nlungu wa wafwi, ila Nlungu wa wanu wari hai. Kwake iye, wanu piya wawa hai.” ");
INSERT INTO wmw_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ikisa wanlimu wengine wa shariya wakimwambira Insa: “Mwanlimu, kusowera sana!” ");
INSERT INTO wmw_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Bandi ya evi, awerepo munu wakurimba moyo kundairi Insa kinu. ");
INSERT INTO wmw_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ikisa Insa akiwadairi: “Wanu wakwamba mwaja kuwa Almasihi ujukulu wa Daudi? ");
INSERT INTO wmw_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Kamana Daudi mwanyewe ndi ambire nkitabu ca Zaburi: ‘Mola kamwambira Mwenye wangu: Ikala nkono nriro wangu ");
INSERT INTO wmw_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","mpaka niwature maaduwi wako wawe sini kamba gogo rakwirika maulu ako.’ ");
INSERT INTO wmw_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ona, ikiwa Daudi Almasihi kamwita ‘Mwenye’, namunani vyaawa upande wa ujukulu wake?” ");
INSERT INTO wmw_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Wanu piya pawakinsikiriza, Insa akisowera na wanafunzi wake, akiwambira javi: ");
INSERT INTO wmw_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“More-more na wanlimu wa shariya! Kuwajibu kupita wakenenda wavarire sana-sana na kukomaziwa kwa inshima mmaluwanja. Watondola kwikala mahala mwa swifa nsinagoga na mmajambo. ");
INSERT INTO wmw_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Fala wawewiranga manankweli vinu vyawo, na watendanga siyasa yakulebela duwa zakurepa. Basi, ewo wakuja kuhukumiwa pakulu futi!” ");
INSERT INTO wmw_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Insa paakiwa nNyumba Takatifu, akiwatunza matajiri wakasa nzuruku nkashoti ya swadaka. ");
INSERT INTO wmw_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ikisa akimmona nankweli mmoja masikini pakulu, akitaya jarajara mbiri za nzuruku aba. ");
INSERT INTO wmw_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Basi, Insa akamba: “Nukwambirani kweli kuwa eyu nankweli masikini‑yu kataya nzuruku mwingi koliko piya wanu wengine‑wo. ");
INSERT INTO wmw_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Konta ewo na utajiri wawo mwingi wataya cawaremire nawo, fala iye na usikini wake kataya piya caawere nawo kati ya mainsha ake.” ");
INSERT INTO wmw_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Wanu wengine, pawakisifu Nyumba Takatifu kuhusu namuna vyaisitawiziwe na mawe meema-meema pamoja na mapambo a kutuziriwa, Insa akamba javi: ");
INSERT INTO wmw_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Evi vinu‑vi vyamuwona‑vi, ikuja kufika suku yakudanguriwa nfululu. Arija kubaki anta riwe rimoja julu ya riwe renziwe.” ");
INSERT INTO wmw_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ewo wakindairi Insa javi: “Mwanlimu, vinu-vyo vikuja kukuna rini? Alamani isaka kuwoneka kábula ya kukuna novyo vinu-vyo?” ");
INSERT INTO wmw_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Iye akijibu: “More-more, asukuteseni munu! Kamana wakuja kulawirira wengi wawenye, waja kwa zina rangu, wakamba: ‘Omi ndi Almasihi’ na ‘Wakati ufíka!’ Musiwafulate! ");
INSERT INTO wmw_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Na pamusikira kuhusu vita na mapinduzi, musope! Evyo siti vyanze kukuna, fala Kiyama acifika kwa mpunde nowo.” ");
INSERT INTO wmw_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ikisa akiwambira: “Taifa itenda vita na taifa nyenziwe na ufalume utenderana vita na ufalume mwenziwe. ");
INSERT INTO wmw_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Vikuja kulawirira vitikansi vikulu muardhi, na balayi na njala mahala mumojiwapo. Mukuja kuwona vinu vyakofya, na julu‑ko alama ulu‑ulu za matajabisa. ");
INSERT INTO wmw_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Fala kábula ya piya‑vi, mukuja kufungiwa na kulumbatiwa. Mukuja kuperekiwa mmasinagoga kulamuriwa, na kwefyeriwa nkalaboshu. Mukuja kuvutiwa mbere ya mafalume na maguvirinadoru, kwa sababu ya zina rangu. ");
INSERT INTO wmw_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Eyo ndi isaka kuwa nafasi yenu yakulavya ushahidi kuhusu omi. ");
INSERT INTO wmw_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Basi, musifazaike na namuna vyamusaka kurikotola, ");
INSERT INTO wmw_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","kamana omi mwanyewe nukuja kukupani usemi wa wijiwifu, wakuwa anta aduwi wenu mmoja aaja kukidiri kukukayidini. ");
INSERT INTO wmw_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Umwe mukuja kupoteziwa anta julu ya wawa zenu, wanduzenu, jamaa wengine‑po, na marafiki zenu. Na wanu wamojawapo kati yenu, ewo wakuja kuwolaya. ");
INSERT INTO wmw_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Wanu piya wakuja kukwinani kwa sababu ya zina rangu. ");
INSERT INTO wmw_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Fala anta nywiri mmoja nviswa vyenu aipoteya. ");
INSERT INTO wmw_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Basi, kwa sababu ya kuvumirira kwenu, roho zenu zívushiwa.” ");
INSERT INTO wmw_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Fala pamusaka kuwona Yerusalemu izunguriziwe na masurudadu, mwijiwe kuwa ufika wakati wakudanguriwa kaya‑yo. ");
INSERT INTO wmw_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Wakati‑wo, wanu waja kuwa Yudeya watuwirire mmyango. waja kuwa Yerusalemu walawe, waja kuwa mmamasamba wasingire nkaya. ");
INSERT INTO wmw_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kamana nozo suku‑zo zikuja kuwa suku za hukumu, pavisaka kutimiziwa piya vibushuriwe mMandiko Matakatifu. ");
INSERT INTO wmw_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Dambi wanawaka suku‑zo wája kuwa na mimba, na wakujíjisa wana wawo! Kamana zikuja kwingira balayi nyingi zawenye muinti‑mo. Wanu wa Iziraeli wakuja kuhukumiwa pakulu. ");
INSERT INTO wmw_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Wengi wakuja kuulaiwa na upanga, na wengine wakuja kutwariwa kukisiwa kamba wafungwa inti piya. Na Yerusalemu ikuja kutawariwa na wanu Sawari-Mayahudi, mpaka wakati wa Sawari-Mayahudi pausaka kutimiziwa.” ");
INSERT INTO wmw_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Insa kaamba novyo: “Zikuja kuwapo alama ya juwa, ya mwezi, pamoja na za nondwa. Mulumwengu‑mu, piya mataifa akuja kuuzunika, kukafilika na shauti ya kitukulu na maluwimbi akofya. ");
INSERT INTO wmw_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Wanu ukuja kuwengira wofi pakulu kwa kinu cisaka kuja mulumwengu‑mu, mpaka nguvu zawo ziwesa. Kamana wenye nguvu mbingu watikinyika. ");
INSERT INTO wmw_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ikisa, ewo wakuja kummona Binadamu wa Binguni akija na wingu, na uwezo na utukufu pakulu. ");
INSERT INTO wmw_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Basi, wakati wazisaka kukuna ezo alama‑zo, inukani, lamusani viswa vyenu, konta kuvuka kwenu kukuwa karibu!” ");
INSERT INTO wmw_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ikisa, Insa akiwambira usowezi mmoja nkinyume akamba: “Tunzani mimongo na miti myengine. ");
INSERT INTO wmw_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Payanza kusipuka miti mukwijiwa sana-sana kuwa mirongo ya kinja iwa karibu-karibu. ");
INSERT INTO wmw_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Kwa namuna mmoja noyo, pamuja kuwona ezi alama‑zi, mwijiwe kuwa ufalume wa Mwenyezimungu uwa karibu. ");
INSERT INTO wmw_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Nukwambirani kweli kuwa eci kizazi‑ci acipita evi vinu‑vi savikunire piya. ");
INSERT INTO wmw_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Bingu na ardhi vilainika, fala usemi wangu aushubutu kulainika.” ");
INSERT INTO wmw_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Insa akizidi kusowera: “More-moreni ipate myoyo yenu isifazaike na cakurya wala cakunywa pakulu anta kushugulika na mambo a mainsha a rero‑ya. Ritengezeni sana-sana ipate noyo suku‑yo isukulawirireni gáfula kamba nambo. ");
INSERT INTO wmw_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Kamana noyo suku‑yo iwajira wanu piya duniya‑yi. ");
INSERT INTO wmw_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ikalani mukirinang'anizira daima. Lebelani ipate muwe nawo uwezo wa kunusurika piya vinu vija kukuna-vyo, mwimire mbere ya Binadamu wa Binguni.” ");
INSERT INTO wmw_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Suku daima‑zi, Insa ákukanga kuNyumba Takatifu ákiwafunda wanu, fala rikiswa juwa, ákilawanga akuka kulala kuMwango ya Mizaituni. ");
INSERT INTO wmw_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Na kila subuu namapema, wanu piya wákijumulana nNyumba Takatifu wansikirize. ");
INSERT INTO wmw_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Sambi, ríkiwa karibu-karibu jambo rakutafuniwa mikate saitayiwe furumento, jambo rakwitiwa Pashukwa. ");
INSERT INTO wmw_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Wakulungwa wa dini pamoja na wanlimu wa shariya wakisakula namuna za kumulaya Insa kisiiri-siiri konta wakiwopa wanu. ");
INSERT INTO wmw_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Wakati‑wo, Ibilisi kamwingira Yuda Shikariyoti, iye ákiwa mmojawapo kati ya mawalii kumi na wawiri wa Insa. ");
INSERT INTO wmw_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yuda akilawa akuka akiwonana nawo wakulungwa wa dini na minduna wa Nyumba Takatifu, akisikizana nawo namuna ya kumpereka mmakono mwawo. ");
INSERT INTO wmw_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ewo wakitenda radi pakulu, wakisikizana naye wampe nzuruku. ");
INSERT INTO wmw_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Basi, Yuda akikubali, akanza kusakula wakati mwema wakumpereka Insa sawapo wanu wengi. ");
INSERT INTO wmw_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ikifika suku ya jambo ra mikate saitayiwe furumento, ikibidi asinjiwe kondoo wa Pashukwa awe kafara. ");
INSERT INTO wmw_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Kwa javyo, Insa akintuma Peduru na Yahaya, akamba: “Ukani mukatengeze piya visakikana kujambo ra Pashukwa, tirye pamoja.” ");
INSERT INTO wmw_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ewo wakindairi: “Usaka tikakutengezere nyumbani?” ");
INSERT INTO wmw_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Iye akiwajibu: “Onani, pamusaka kwingira Yerusalemu, munsingana mwananlume asukure ndoo ya maji. Munfulate noyo nyumba yaasaka kwingira‑yo. ");
INSERT INTO wmw_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Mwanyewe nyumba‑yo, mumwambire javi: ‘Mwanlimu katumiza kukudairi javi: “Nsana wa wayeni uwa ndepi? Nisaka nitumire, nirye Jambo ra Pashukwa na wanafunzi wangu.” ’ ");
INSERT INTO wmw_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Iye akoloterani nsana nkulu sana kugorofa‑ko, na piya visakikana. Mukatengeze noko jambo retu‑ro.” ");
INSERT INTO wmw_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ewo nakuka, wasingana kamba vyaawambire, wakitengeza jambo ra Pashukwa nomure. ");
INSERT INTO wmw_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Paufikire wakati wa kurya kujambo rire, Insa akikala pameza na mawalii wake. ");
INSERT INTO wmw_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Iye akiwambira: “Vinajibu pakulu futi kurya namwe eri jambo ra Pashukwa‑ri, saninatabika. ");
INSERT INTO wmw_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Konta nukwambirani kweli kuwa sirya namwe tena pajambo ra Pashukwa mpaka mana a Pashukwa akuja kutimiziwa, muufalume wa Mwenyezimungu.” ");
INSERT INTO wmw_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ikisa Insa akitwala kikombe kimoja ca vinyu, akishukuru, akamba: “Twalani, mumerane watupu. ");
INSERT INTO wmw_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Kamana nukwambirani kweli kuwa omi sinywa vinyu tena mpaka ufike ufalume wa Mwenyezimungu.” ");
INSERT INTO wmw_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ikisa akitwala nkate mmoja, akishukuru, akimeya, akiwapa wanafunzi ware, akamba: “Ewu nkate‑wu ndi mwiri wangu wanipereka kwa kukupendeleyani. Tendani novi kwa kunikumbukira omi.” ");
INSERT INTO wmw_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Pesire kurya, akitwala kikombe ca vinyu, akamba: “Eyi vinyu‑yi ndi alama ya miyadi mipya ya Mwenyezimungu, ikwakikishiwa julu ya damu yangu, itawanyike kwa faida yenu umwe.” ");
INSERT INTO wmw_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Na akamba tena: “Onani, pameza‑pa kawapo munu mmoja asaka kunizungunuka, kunipereka ka maaduwi wangu. ");
INSERT INTO wmw_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ndi kweli kuwa Binadamu wa Binguni ajuzi afwe konta ewo mpango wa Mwenyezimungu. Fala alaniwe mwananlume asaka kunizungunuka!” ");
INSERT INTO wmw_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Basi, wanafunzi ware wakanza kudairiyana watupu: “Patiri‑pa nani ája kutenda kinu kamba‑co?” ");
INSERT INTO wmw_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Kukiwapo novyo kukaidiyana nkati ya wanafunzi ware kuhusu munu ári bora pakulu nkati yawo. ");
INSERT INTO wmw_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Kwa javyo, Insa akiwambira: “Mafalume wa mataifa wawatawala wanu watende vyawasaka. Wari na mamulaka julu yawo viwajibu kwitiwa javi: ‘wenye fadili’. ");
INSERT INTO wmw_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Fala kati yenu, sijavyo. Ila munu nkulu kati yenu awe kamba munu ntoto, alongóza awe kamba awudúmu. ");
INSERT INTO wmw_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Sambi ári bora pakulu ndi wepi? Árya pameza, au awaúdumu wenziwe? Siire árya pameza? Fala omi epa kati yenu niwa maúdumu. ");
INSERT INTO wmw_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Umwe ndi muwanga pamoja nomi kwa piya kuyereriwa kukinipatanga. ");
INSERT INTO wmw_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ndi ntamana, nukugabizini ufalume kamba Baba wangu vyaanigabizi ufalume, ");
INSERT INTO wmw_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ipate murye na munywe pameza yangu muufalume wangu. Na umwe mukuja kwikala viti vya ufalume, mukuja kumiliki marikolo kumi na mawiri a Iziraeli.” ");
INSERT INTO wmw_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Mwenye Insa akizidi kusowera, akamba: “Ansumani! Ansumani! Wona, Shetwani kalebela pakulu ipate akuyerereni piya-mwe, kamba tirigu yakupepetiwa. ");
INSERT INTO wmw_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Fala omi nukulebelela duwa kuhusu uwe ipate usase kunitumaini omi. Na uwe, pausaka kuludira kwangu omi, warimbise myoyo wanduzo.” ");
INSERT INTO wmw_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Peduru akinjibu: “Mwenye, omi niwa tayari kuka nkalaboshu au anta paiwa kufwa nawe.” ");
INSERT INTO wmw_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Insa kamwambira: “Ona Peduru, rero kokoriko aawika saunikanire mara natu kuwa aunijiwa.” ");
INSERT INTO wmw_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ikisa, Insa akiwadairi wanafunzi ware javi: “Panukutumireni kupita mukitangaza Habari Ngema bila poci wala nrumba wala tamango, ciwapo cukutowireni?” Ewo wakijibu: “Acipo!” ");
INSERT INTO wmw_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ikisa akiwambira: “Fala sambi, ári na poci, arisukuze, na ári na nrumba, ndi novyo. Na saána upanga, auzanye anzu yake auze. ");
INSERT INTO wmw_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Kamana ibidi vitimiziwe vibushuriwe kuhusu omi: ‘Wantenda kamba dainfu.’ Kusema kweli, piya vyaandikiwe na minabii kuhusu omi vyankutimiziwa.” ");
INSERT INTO wmw_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ewo wakimwambira: “Ona Mwenye, epa tanawo maupanga mawiri.” Neye akiwambira: “Atosha.” ");
INSERT INTO wmw_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Sambi, Insa akilawa, akuka kuMwango wa Mizaituni kamba vyaíkiwa tabiya yake. Wanafunzi wake, newo novyo wakinfulata. ");
INSERT INTO wmw_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Nakufika kure, Insa akiwambira: “Lebelani duwa musije kushetwaniwa.” ");
INSERT INTO wmw_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ikisa Insa akiwatanuka wanafunzi wake ware kitambo ca mima talatini, akikokora malundi, akilebela duwa, akamba: ");
INSERT INTO wmw_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Baba, ikiwa usaka, kaneka ya tabu‑yi initanuke. Novyo-sivyo, isiwe kamba vyanisaka omi, ila vyausaka uwe.” ");
INSERT INTO wmw_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Kwa javire, akisuka laika mmoja kulawa mbinguni kumwengeza nguvu. ");
INSERT INTO wmw_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Kwa kuwa kakafilika pakulu, iye akilebela duwa pakulu-pakulu, mpaka luvuju rake ríkiwa kamba damu rikisulurira pansi. ");
INSERT INTO wmw_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Pesire duwa, akilamuka akuka ka wanafunzi wake. Kawasingana wakilala, kwa kuwa wáuzunika. ");
INSERT INTO wmw_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Basi, akiwambira javi: “Mbena mwankulala usingizi? Lamukani, mulebele duwa ipate musije kushetwaniwa.” ");
INSERT INTO wmw_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Insa paakisowera, ikifika junudi ya wanu yakulongoziwa na ire wakwitiwa Yuda ire, ákiwa mwanafunzi mmoja kati ya kumi na wawiri ware. Yuda akimukira Insa ankomaze kwa namuna yawatendana munu na rafiki yake. ");
INSERT INTO wmw_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Fala Insa akimwambira: “Yuda, utumira alama ya urafiki kunzungunuka Binadamu wa Binguni?” ");
INSERT INTO wmw_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Wanafunzi wengine wanzungurize ware, pawawonire vikisaka kunkuna vire, wakimwambira Insa: “Mwenye, tiwashambuliye na upanga?” ");
INSERT INTO wmw_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Kweli, mmoja wawo akinduru ntumisi mmoja wa nkulu wa wakulungwa wa dini, akinsinja sikiro ra nkono nriro. ");
INSERT INTO wmw_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Fala Insa nakuwajibu kaamba: “Hee, musitende javyo!” Iye akinkumbula mmasikiro mwananlume ire, akimponesa. ");
INSERT INTO wmw_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ikisa, Insa akiwambira wakulungwa wa dini, na wakulungwa wa mapulisiya wa Nyumba Takatifu, pamoja na walongozi wokire kunfunga ware, akamba: “Mwaja? Omi niwa kisomi wakunijirira na mapanga na mipweke kunifunga sababuni? ");
INSERT INTO wmw_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Daima‑zi nukuwanga namwe nNyumba Takatifu fala amunifungire. Fala ewu ndi wakati wenu wamupewe, wanu wa nkisi pawári nawo mamulaka!” ");
INSERT INTO wmw_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ikisa, ewo wakinfunga Insa, wakintwala, wakuka naye kunyumba ya nkulu wa wakulungwa wa dini. Peduru akipita, akinfulata kitambo aba. ");
INSERT INTO wmw_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Wakikoreza moto nluwani, wakikala kota. Na Peduru neye akikala na wanu ware. ");
INSERT INTO wmw_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Njakazi mmoja kammona Peduru ekare pakilanga-langa pamoto pare, akinnang'aniza sana-sana, akamba: “Eyu mwananlume‑yu ákiwa pamoja naye!” ");
INSERT INTO wmw_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Fala iye akikana, akamba: “Nunu, omi iye simwijiwa!” ");
INSERT INTO wmw_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Aupitire muda, ikisa ntumisi mwengine kammona, akamba: “Nnowe novyo ndi mmoja wawo!” Fala Peduru akijibu: “Mwenye, omi siri!” ");
INSERT INTO wmw_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ipita ora mmoja, ikisa akilawirira munu mwengine, akinkenekezera: “Siyo dana kuwa eyu mwananlume‑yu ákiwa pamoja naye, kamana neyu novyo nGalileya!” ");
INSERT INTO wmw_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Fala Peduru akijibu: “Uwe mwananlume‑we, causowera‑co, omi sijiwa anta aba javi!” Kuno akisowera, kwa mpunde noure, kokoriko akiwika. ");
INSERT INTO wmw_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Mwenye Insa akizungunuka, akinnang'aniza Peduru. Na Peduru akikumbukira vyaâmbire Mwenye vire kuwa: “Saanawika kokoriko rero, ukuja kunikana mara natu.” ");
INSERT INTO wmw_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Basi Peduru akilawa nluwani mure, akanza kwibiya lukuto. ");
INSERT INTO wmw_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Sambi, minduna wamwikarire Insa ware wakanza kunshupa kuno wakimwibiya. ");
INSERT INTO wmw_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Wakinfinika kumaso kuno wakindairi: “Kubushuru! Nseme munu ári kukwibiya!” ");
INSERT INTO wmw_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Na wakinsowera caputu vinu vingi vyawenye, vyakunkufurira. ");
INSERT INTO wmw_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Subuu namapema, kundi ra walongozi wa Mayahudi wakijumulana pamoja. Wákiwepo wakulungwa wa dini na wanlimu wa shariya. Insa akijisiwa mbere yawo, wakamba: ");
INSERT INTO wmw_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Tambire, uwe ndi Almasihi?” Fala iye akiwajibu: “Ikiwa omi nukwambirani, umwe amunamini. ");
INSERT INTO wmw_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Na ikiwa nukudairini kinu, umwe amunijibu! ");
INSERT INTO wmw_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Fala mwanzo wa sambi‑pa, Binadamu wa Binguni akuja kwikala upande wa nkono nriro wa Mwenyezimungu, Mwenyé Uwezo.” ");
INSERT INTO wmw_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Kwa javyo, ewo wakisowera kapamoja: “Sambi, uwe kuwa Mwana wa Mwenyezimungu?” Iye akiwajibu: “Umwe ndi musema kuwa omi niwa Mwana wa Mwenyezimungu.” ");
INSERT INTO wmw_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ikisa wakamba: “Sababuni tena kusakula ushahidi mwengine? Ofwe wanyewe tinsikira na kanywa yake!” ");
INSERT INTO wmw_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ikisa, piya wanu wakilamuka, wakimpereka Insa ka Pilatu. ");
INSERT INTO wmw_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Wakanza kunlongopera, wakamba: “Eyu mwananlume‑yu tankummona kuwa kankuwazungunusa wanu wetu, na kankuwakataza wanu wasinripe nsoko Kaisari. Kaamba novyo kuwa iye Almasihi, Nfalume.” ");
INSERT INTO wmw_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilatu akindairi: “Uwe ndi nfalume wa Mayahudi?” Insa akinjibu, akamba: “Uwe ndi uri kwamba.” ");
INSERT INTO wmw_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ikisa Pilatu akiwambira wakulungwa wa dini na junudi ya wanu, akamba: “Siwona kosa rimojawapo ra mwananlume‑yu.” ");
INSERT INTO wmw_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Fala ewo wakikenekezera, kwamba: “Iye kankuwashonga wanu, apite akifunda Yudeya‑yi piya, mwanzo wa Galileya mpaka epa!” ");
INSERT INTO wmw_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Paasikire javyo, Pilatu akiwadairi: “Ha! Noyo mwananlume‑yo nGalileya?” ");
INSERT INTO wmw_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ewo wakijibu: “Aye!” Pilatu, pejíwe kuwa mwenyé mamulaka ndi Herodi, akimpereka ka Herodi. Kweli, nozire suku zire, Herodi ákiwa Yerusalemu nokure. ");
INSERT INTO wmw_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herodi nakummona Insa kawa radi pakulu futi, kamana zipita suku nyingi zawenye akinsakula ammone, kwa kuwa ákisikira habari zake. Iye akirindira kuwa akuja kuwona alama yake mojawapo yaatendire. ");
INSERT INTO wmw_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Kwa javyo, kandairi Insa vinu vingi vyawenye, fala iye aanjibire anta kinu kimoja. ");
INSERT INTO wmw_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Wákiwapo noparepare wakulungwa wa dini na wanlimu wa shariya wakinlongopera Insa pakulu. ");
INSERT INTO wmw_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Na Herodi novyo ákiwepo nopo na masurudadu wake wakanza kunkejeli Insa kuno wakinshupa. Wakinvaza anzu kamba ya kifalume, ikisa wakimpereka tena ka Pilatu. ");
INSERT INTO wmw_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Noire suku ire, Herodi na Pilatu wakanza kuwa munu na rafiki yake. Pakwanza wákiwa munu na aduwi wake. ");
INSERT INTO wmw_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ikisa, Pilatu akiwajumanisa wakulungwa wa dini na wakulungwa wengine pamoja na wanu wa nkaya mure, ");
INSERT INTO wmw_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","akiwambira javi: “Umwe muja naye mwananlume‑yu kwangu omi, mwankwamba kuwa kankuwashonga wanu kutenda ubishi. Omi nopapa vyamuri kunlongopera mwananlume‑yu nankutunza sana-sana mbere ya wanu-mwe piya, fala onani, siri kuwonerera kosa rimojawapo. ");
INSERT INTO wmw_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Anta na Herodi, neye novyo, kamana katiludisira nokuno tena. Onani, eyu mwananlume‑yu aakosire kinu cakujuzi kuhukumiwa kifo. ");
INSERT INTO wmw_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Basi nikwamuru acapiwe viboko, ikisa asiwe oke vyake.” ");
INSERT INTO wmw_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Junudi ya wanu ware piya wakanza kukuwa pakulu-pakulu kapamoja, wakamba: “Eyo mwaseni novyo, tifungurireni Baraba!” ");
INSERT INTO wmw_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Baraba‑yu kafungíwa kwa sababu ya vurumãi yaalavire nkaya mure, na kwa sababu ya kumulaya munu. ");
INSERT INTO wmw_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilatu akisaka kunfungula Insa, ndimana akikola kusowera tena na wanu ware. ");
INSERT INTO wmw_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Fala ewo wákizidi kukuwa, wakamba: “Ngomezereni! Ngomezereni!” ");
INSERT INTO wmw_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Mara ya tatu Pilatu akiwadairi, akamba: “Noyu katenda kinani cakunyata? Omi simmonerere anta kosa rimojawapo rakujuzi kuhukumiwa kifo. Ndimana, nikwamuru acapiwe viboko, ikisa asiwe oke vyake.” ");
INSERT INTO wmw_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Fala ewo wakikenekezera, wakikuwa na shauti ulu‑ulu, wakilebela kuwa Insa agomezeriwe. Na shauti zawo zikishinda. ");
INSERT INTO wmw_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ndimana, Pilatu akamuru vitendiwe kamba vyawari kunlebela novire. ");
INSERT INTO wmw_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Basi, kamba ewo vyawanlebele, ire ataíwe nkalaboshu kwa sababu ya vurumãi na kuulaya ire, iye akinfungula. Akintwala Insa, akiwagabizi wanu ware watende viwajibu. ");
INSERT INTO wmw_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Sambi, pawanlongoze Insa, munjira wakinkola mwananlume wakwitiwa Ansumani, ákiwa nKireni, akiláwa masamba. Ewo wakinsukuza nsalaba wa Insa mmaweya, akinfulata Insa. ");
INSERT INTO wmw_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Wákiwapo novyo wanu wengi wawenye wakinfulata Insa, na wanawaka wakinririra na úwengira úzuni. ");
INSERT INTO wmw_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Insa akizungunuka, akiwambira: “Umwe wanawaka wa Yerusalemu, musiniririre omi basi. Ila riririreni umwe wanyewe pamoja na wanenu. ");
INSERT INTO wmw_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Konta onani, zikuja kufika suku ewo zakuja kwamba javi: ‘Heri wanawaka sawana wana, matumbo saanamba kwimita, mawere tangu saanamba kujijisa!’ ");
INSERT INTO wmw_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ikisa, wanu wakuja kulebela myango wakamba: ‘Mwango, tigwirire!’ na walebela mwala: ‘Mwala, tifise!’ ");
INSERT INTO wmw_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kamana ikiwa watenda vinu‑vi uni ziri mbisi, futi zikumiliya watendaja?” ");
INSERT INTO wmw_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Wâtwariwa novyo visomi wawiri wakaulaiwe pamoja na Insa. ");
INSERT INTO wmw_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Pawafikire mahala pakwitiwa “Kongolo ra kiswa”, noparepare wakingomezera iye pamoja na visomi wawiri, mmoja upande wa nkono sonto, mwengine upande wa nkono nriro. ");
INSERT INTO wmw_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Insa akamba: “Baba, waswamii kamana awejiwa cawatenda!” Na masurudadu ware wakitenda kura kwa ajili ya kwawanyirana nguwo zake. ");
INSERT INTO wmw_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Junudi ya wanu ware wemira nopare wakinang'aniza. Fala wakulungwa wakanza kunshupa Insa, wakamba: “Iye kawavusha wenziwe. Basi, arivushe mwanyewe, ikiwa kweli-kwelini iye Almasihi, Atondoriwe na Mwenyezimungu!” ");
INSERT INTO wmw_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Masurudadu ware newo novyo wakinshupa, wakimukira karibu, wakintula vinagiri kukanywa, ");
INSERT INTO wmw_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","wakimwambira javi: “Ikiwa uwe kuwa nfalume wa Mayahudi, rivushe mwanyewe!” ");
INSERT INTO wmw_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Julu ya nsalaba cíkiwapo kibawo cakwandikiwa javi: “EYU NDI NFALUME WA MAYAHUDI.” ");
INSERT INTO wmw_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Kisomi mmoja agomezériwe upande mmoja wa Insa akikufuru, akamba: “Uwe auri Almasihi? Rivushe uwe mwanyewe, nofwe utivushe!” ");
INSERT INTO wmw_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Fala kisomi mwengine ire akinjibu, akamba javi: “Uwe aumopa Mwenyezimungu, kwa kuwa kuhukumiwa kwenu kumoja? ");
INSERT INTO wmw_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Upande wetu, iwapo haki yakuhukumiwa konta titendiwa hukumu itijuzire, kwa sababu ya vitendo vyatitendire. Fala eyu mwananlume‑yu aatendire anta kinu kimoja cakunyata!” ");
INSERT INTO wmw_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ikisa akamba tena: “Insa, nikumbukire pausaka kwingira muufalume wako.” ");
INSERT INTO wmw_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Insa akinjibu: “Nukwambira kweli kuwa rero‑vi ukuwa nomi mpeponi.” ");
INSERT INTO wmw_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Wakati síwo íkiwa aduhuri. Kunja piya inti kutenda kisi mpaka wakati wa lulemba. ");
INSERT INTO wmw_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Pakwinukare kunja, pazira ya Nyumba Takatifu ikipapuka kati-kati perr. ");
INSERT INTO wmw_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ikisa Insa akikuwa na shauti ulu, akamba: “Baba, roho yangu nankukugabizi mmakono mwako.” Pesire kusowera javire, akifwa. ");
INSERT INTO wmw_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Nkulungwa wa masurudadu nakuwona vikunire vire, akintukuza Mwenyezimungu, akamba: “Kweli-kwelini, eyu mwananlume‑yu ákiwa mwenyé shariya!” ");
INSERT INTO wmw_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Na piya wanu wajumane kuwona mambo are, pawawonire vikunire vire, wákiribiya pakifuwa kuno wakiludira mmakwawo. ");
INSERT INTO wmw_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Na wanu piya wakimwijiwa Insa, pamoja na wanawaka wâmpereke paakilawa Galileya, ewo wemira kitambo aba, wakiwona vikikuna vire. ");
INSERT INTO wmw_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ona, ákiwapo mwananlume mmoja wakwitiwa Yusufu, munu mwema na kamilifu kati ya Baraza ya Milandu. ");
INSERT INTO wmw_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Kwawo kukiwa Arimataya, kaya moja ya Mayahudi. Iye aakubalire vyawalamure na vyawakunishe wakulungwa wengine vire. Akirindira ufalume wa Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Iye nakufika karibu ya Pilatu, akinlebela maiti a Insa. ");
INSERT INTO wmw_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Nakulavya maiti are, akizingiriza kafani, akuka akizika njonga rikoporiwe, ríkiwa saarinamba kuzikiwa munu. ");
INSERT INTO wmw_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Noyo suku‑yo ikiwa jumaa jironi, suku yakutengezera wanu suku takatifu. Na sabadu, suku takatifu‑yo, yânza futi. ");
INSERT INTO wmw_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Wanawaka wâjire pamoja neye kulawa Galileya, wafulata, wawona kaburi rire na namuna maiti ake vyaazikiwe. ");
INSERT INTO wmw_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ikisa, wanawaka ware wakiludira ukaya, wakitengeza sheru pamoja na balsamu. Na suku takatifu ya sabadu wakipumula, kamba vyaisaka shariya. ");
INSERT INTO wmw_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Fala pakucere subuu namapema, suku yakwanza ya sumana, wanawaka ware watwala sheru yawatengeze ire, wakuka nawo kukaburi. ");
INSERT INTO wmw_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Nakufika kure, riwe rituriwe pakaburi rire wasingana ripiringisiwe. ");
INSERT INTO wmw_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Basi, wengira njonga mure, fala mwiri wa Mwenye Insa awasingane. ");
INSERT INTO wmw_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ewo, pawashangire kuhusu vikunire vire, simpunde nkulu wanawalume wawiri wawemira karibu yawo, wâvala nguwo nyelupa vú! ");
INSERT INTO wmw_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Wanawaka ware wakisusuka, wakinamira pansi, fala wanawalume ware wakiwadairi javi: “Mbana munsakula ka wafwi munu hai? ");
INSERT INTO wmw_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Iye aapo‑mu, kafufuka! Amukumbukira vyaâkwambireni Galileya? ");
INSERT INTO wmw_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Amukumbukira kuwa iye kâsema kuwa Binadamu wa Binguni ajuzi aperekiwe mmakono mwa wamádambi wangomezere, na suku ya tatu afufuke?” ");
INSERT INTO wmw_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Newo wakikumbukira usemi wake ure. ");
INSERT INTO wmw_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Basi, wakilawa nkaburi mure, wakiludira kawákiwa mawalii kumi na mmoja kure pamoja na wenziwawo, wakiwambira piya vikunire. ");
INSERT INTO wmw_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Kweli, wanawaka ware wákiwa Mariyamu Madalena, Zuwana, Mariyamu mamaye Yakobu, na wengine tena. Ewo wakiwambira mawalii ware vikunire vire, ");
INSERT INTO wmw_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","fala mawalii ware awaminire. Wawona kuwa vyawereze wanawaka vire vyauzozo. ");
INSERT INTO wmw_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Noyo suku‑yo, wanu wawiri wafulati wa Insa wakuka kaya moja yakwitiwa Emau, kiyasi ca kilometuru kumi na mmoja na Yerusalemu. ");
INSERT INTO wmw_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Munjira, wakipita wakipakanira kuhusu vikunire vire piya. ");
INSERT INTO wmw_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Wakati wawakipakanira kuno wakikaidiyana, Insa mwanyewe akilawirira munjira mure, akifunga nawo nkonjo. ");
INSERT INTO wmw_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Fala ewo wafungiwa maso, awakimmanyira kuwa ndiye. ");
INSERT INTO wmw_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Insa akiwadairi: “Mwankupita, mukipakanira kinani?” Ewo wakimira, wakibaki wakuzizimiriwa wawenye. ");
INSERT INTO wmw_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ikisa mmoja wakwitiwa Keleopa akimwambira: “Nowe‑we tu basi ndi myeni ubakire sawijiwa cikunire Yerusalemu suku za mwinsho‑zi?” ");
INSERT INTO wmw_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Iye akiwadairi: “Cikuna kinani?” Ewo wakinjibu: “Vinkunire Insa wa Nazareti. Iye ákiwa nabii, akitendanga maajuza a kutajabisa na akisowera kwa uwezo mbere ya Mwenyezimungu na wanu piya. ");
INSERT INTO wmw_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Fala wakulungwa wetu wa dini pamoja na wakulungwa wengine wampereka kuhukumiwa kifo, iye kagomezeriwa pansalaba. ");
INSERT INTO wmw_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ofwe tikirindira kuwa iye ndi ire akija kombola Iziraeli! Fala kwa piya-vyo, epa rero zipita suku natu tangu vikikuna. ");
INSERT INTO wmw_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Visitoshe, wanawaka wamojawapo wa kipinga cetu watisususa. Subuu namapema pawokire kukaburi, ");
INSERT INTO wmw_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","awasingane maiti ake! Pawaludire, wasema kuwa wawawona malaika wawereza kuwa Insa kawapo hai! ");
INSERT INTO wmw_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Wengine wákiwa pamoja nofwe, wakuka kukaburi noko, wakisingana piya sawa‑sawa kamba vyawereze wanawaka novire. Fala iye awammonire.” ");
INSERT INTO wmw_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Insa akiwambira javi: “Umwe mubanga, murimba kukubali mmyoyo mwenu piya vyawambire minabii! ");
INSERT INTO wmw_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Aikisakikana kuwa Almasihi vinu‑vi atabike ikisa engire nkati ya utukufu wake?” ");
INSERT INTO wmw_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ikisa Insa, mwanzo wa vitabu vya Musa mpaka vitabu vya minabii wengine, akiwafafanurira Mandiko piya ákisowera kuhusu iye. ");
INSERT INTO wmw_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Kwa javyo, wari karibu na kaya yawakuka, Insa karitenza kupunda, ");
INSERT INTO wmw_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","fala ewo wakintafadali, wakamba: “Ikala nofwe konta juwa riswa fúti.” Basi, akingira akikala nawo. ");
INSERT INTO wmw_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Pawekare pameza kurya, Insa akitwala nkate, akishukuru, akimeya, akiwawanyira. ");
INSERT INTO wmw_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Mpunde sinkulu, wanu ware maso awo akiwafunguka ngwê, wakimmanyira. Neye akilainika! ");
INSERT INTO wmw_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Wakambirana watupu: “Iye paakisowera nofwe munjira mure kuno akitifafanurira Mandiko, myoyo yetu ikitibiya shindo pakifuwa, sinovyo?” ");
INSERT INTO wmw_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Kwa mpunde noure wakilamuka, wakiludira Yerusalemu, wakiwasingana mawalii kumi na mmoja na wengine‑po wajumane pamoja. ");
INSERT INTO wmw_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Pawafikire, wo‑wawiri wakamba: “Ndi kweli Mwenye kafufuka! Iye kânlawirira Peduru!” ");
INSERT INTO wmw_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ikisa ewo wakiwereza viwakunire munjira mure. Wakamba: “Insa timmanyira wakati wameyire nkate.” ");
INSERT INTO wmw_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Evi vinu‑vi pawakereza, Insa akiritula kati-kati yawo, akiwambira: “Salama iwe namwe!” ");
INSERT INTO wmw_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Fala ewo wasusuka, wakibaki wakushanga wawenye, wakidaniza kuwa nsoka. ");
INSERT INTO wmw_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Iye akiwambira: “Mbana mususuka? Sababuni kuwa na dana mmoyo mwenu? ");
INSERT INTO wmw_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ninang'anizeni mmakono mwangu‑mu na mmaulu mwangu‑mu. Ndi nomi-nomini. Nipameni muniwona, kamana nsoka auna nyama wala makongolo, kamba vyamuniwona vyaniri nawo omi‑vi.” ");
INSERT INTO wmw_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Nakusowera javire, kawolotera mmakono na mmaulu. ");
INSERT INTO wmw_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ingawa awakikubali sana, fala iwejala radi na kutajabu! Basi Insa akiwadairi: “Epa mwanawo cakurya kimojawapo?” ");
INSERT INTO wmw_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ewo wakimpa kipande kimoja ca inswi wakumanikiwa. ");
INSERT INTO wmw_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Insa akitwala, akitafuna mbere yawo. ");
INSERT INTO wmw_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ikisa akiwambira: “Mida patíkiwa onse, nukwambirani kuwa piya vyaandikiwe kuhusu omi nTaureti na nvitabu vya minabii na nZaburi víjuzi vitimiziwe.” ");
INSERT INTO wmw_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ikisa akiwafungula viswa awerere Mandiko Matakatifu, ");
INSERT INTO wmw_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","na akiwambira: “Yandikiwa javi, Almasihi akijuzi atabike, na suku ya tatu afufuke kati ya wafwi, ");
INSERT INTO wmw_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","na kwa zina rake itangaziwe kwa piya kabila, mwanzo wa Yerusalemu, habari yake kuhusu kutubiya ipate wanu waswamiiwe madambi awo. ");
INSERT INTO wmw_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Umwe muwa mashahidi wa eya mambo‑ya. ");
INSERT INTO wmw_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Visitoshe, omi mwanyewe nukuperekerani caalavire tamaa Baba. Fala rindirani Yerusalemu nopa, mpaka mupokerere uwezo usaka kukwisukirani kulawa mbinguni.” ");
INSERT INTO wmw_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ikisa Insa akiwalongoza wanafunzi wake upande wa Betaniya. Nokure akilamusa makono, akiwajanliya. ");
INSERT INTO wmw_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Bandi ya kuwajanliya, akiwanyema, ikisa akikweziwa mbinguni. ");
INSERT INTO wmw_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Na ewo wakimwabudu, nakwisa wakiludira Yerusalemu wári radi pakulu. ");
INSERT INTO wmw_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Mara kwa mara wákilawanga nNyumba Takatifu, wakinsifu Mwenyezimungu.");
INSERT INTO wmw_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Tangu mwanzo ákiwapo ire etiwa Usemi. Usemi‑yo ákiwa pamoja na Mwenyezimungu, na Usemi noyo ákiwa Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Iye tangu mwanzo ákiwa pamoja na Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Julu ya noyo Usemi‑yo, vinu piya vyumbiwa. Acipo kinu anta kimoja cumbiwe bila Usemi. ");
INSERT INTO wmw_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Usemi noyo ndi nviriro wa mainsha, na mainsha‑yo ndi nuru ya wanadamu. ");
INSERT INTO wmw_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Nuru ilangaza pakisi, ila kisi acikidiri kwinukaza panuru. ");
INSERT INTO wmw_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Sambi, akiwapo mwananlume mmoja wakwitiwa Yahaya kâperekiwa na Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Iye kâja kulavya ushahidi na kwakikisha kuhusu noyo nuru‑yo ipate wanu piya wakubali julu yake iye. ");
INSERT INTO wmw_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yahaya siyo nuru yambiwa‑yo, ila iye kâja kulavya ushahidi wa noyo nuru‑yo. ");
INSERT INTO wmw_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Nuru yakweli yakuwamwarikira wanu piya ikingira mulumwengu‑mu. ");
INSERT INTO wmw_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Kweli, iye ákiwapo mulumwengu‑mu, na ulumwengu‑wu umbiwa kwa ajili yake, fala wanu mulumwengu‑mu awamwijiwe. ");
INSERT INTO wmw_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Iye kâjira cake, fala wanu wake iye mwanyewe awampokerere. ");
INSERT INTO wmw_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Fala kwa piya wampokerere iye, waminire zina rake, iye kawapa haki ya kuwa wana wa Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ewo awawere wana wa Mwenyezimungu kwa kupongoriwa kibinadamu wala wájibu wa ceje wala nafsi ya nlume, ila Mwenyezimungu mwanyewe ndi awaturire kuwa wanawe. ");
INSERT INTO wmw_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Usemi utaduka kawa mwanadamu, kainshi kati yetu ofwe. Tiwona utukufu wake, utukufu wa mwana mmoja tu basi wa Baba, wakumwijala rehema na ukweli. ");
INSERT INTO wmw_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yahaya kalavya ushahidi kuhusu noyo, ákilalamikanga akamba: “Eyu ndi noire wanikimwamba ire kuwa: ‘ Ire ája bandi ya omi ndi bora pakulu koliko omi konta iye ákiwapo tangu saninamba kupongoriwa omi.’ ” ");
INSERT INTO wmw_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ofwe piya tankupokerera utajiri wake nkulu, tankupokerera neema julu ya neema. ");
INSERT INTO wmw_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Konta Taureti isusiwa julu ya mmakono mwa Musa, fala rehema na ukweli visuka julu ya Insa Almasihi. ");
INSERT INTO wmw_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Tangu aapo munu ammonire Mwenyezimungu, ila Mwenyezimungu Mwana mmoja noyo tu basi, ári pamoja na Baba wake, iye ndi atifafanurire. ");
INSERT INTO wmw_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ewu ndi ushahidi wa Yahaya wakati Mayahudi wa Yerusalemu wawaperekiwe kwake iye walongozi wa dini na waLawi kuka kundairi: “Uwe kuwa nani?” ");
INSERT INTO wmw_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Iye akitikiza aakanire, akitikiza javi: “Omi siri Almasihi.” ");
INSERT INTO wmw_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ewo wakindairi: “Sambi, uwe kuwa nani? Uwe kuwa Aliyasi?” Yahaya akijibu: “Iii, sumi.” Wakindairi tena: “Uwe kuwa nabii maalumu?” Iye akijibu: “Iii, siri.” ");
INSERT INTO wmw_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Mwinsho wakamba: “Sambi, uwe kuwa nani? Tambire ipate tikawajibu watitumire ofwe. Wambani kuhusu uwe?” ");
INSERT INTO wmw_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Iye akisema: “Omi ndi shauti íri kukuwa nlanga ikamba: ‘Olosani njira ya Mwenye apite’ kamba vyaâmbire nabii Izaya.” ");
INSERT INTO wmw_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","(Kusema kweli, wanu ware wâtumiwa na Mafarizeu.) ");
INSERT INTO wmw_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ewo wandairi tena, wamba: “Uwe auri Almasihi wala Aliyasi wala nabii maalumu. Sambi ukóza sababuni?” ");
INSERT INTO wmw_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yahaya akiwajibu, akamba: “Omi niwoza wanu na mmaji, fala kati yenu umwe kawapo munu samumwijiwa iye caari. ");
INSERT INTO wmw_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Noyo-noyoni ndi ája bandi ya omi. Kweli, mizizi ya tamango zake, sijuzi anta kufungula.” ");
INSERT INTO wmw_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Evi piya‑vi vikuna Betaniya, ng'ambu nyengine ya muto wa Yordani, Yahaya kaakozanga wanu. ");
INSERT INTO wmw_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Subuu yake, Yahaya kammona Insa akija kwake, akamba: “Mmoneni ire ndi Kakondoo kalume ka Mwenyezimungu, kaperekiwe kuja mulumwengu‑mu kuwalavya wanu madambi! ");
INSERT INTO wmw_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Eyu ndi wanikimwamba panikisowera pare nikamba: ‘Bandi ya omi akuja munu bora pakulu koliko omi, konta saninamba kuwapo, iye ákiwapo!’ ");
INSERT INTO wmw_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nomimi sikimwijiwa iye, ila omi nija, nikozanga na maji, ipate iye afafanuriwe ka wanu wa Iziraeli.” ");
INSERT INTO wmw_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Na Yahaya kalavya ushahidi, kaamba: “Omi nimmona Roho akilawa binguni akimwisukira iye kamba pomba vyesuka, na Roho ire akimmotera emire novirevire. ");
INSERT INTO wmw_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Omi‑pa sikimwijiwa caari. Fala ire anipereke kuwoza wanu mmaji kanambira javi: ‘Wausaka kummona akimwisukira Roho akimmotera‑yo, noyo ndi aja kukozani na Roho Takatifu.’ ");
INSERT INTO wmw_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Omi niwona na niwa shahidi kuwa eyu Mwana wa Mwenyezimungu.” ");
INSERT INTO wmw_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Subuu yake, Yahaya akikala tena nopare na wanafunzi wake wawiri. ");
INSERT INTO wmw_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Pammonire Insa akipita, iye akamba: “Mmoneni! Ire ndi Kondoo wa Mwenyezimungu!” ");
INSERT INTO wmw_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Wanafunzi wawiri ware wansikira akisowera, newo wakinfulata Insa. ");
INSERT INTO wmw_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Insa akizungunuka, kawawona wakinfulata, iye akiwadairi: “Umwe musakulani?” Ewo wakimwambira: “Rabi” (mana ake Mwanlimu), “kufikira ndepi?” ");
INSERT INTO wmw_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Iye akiwajibu: “Tukeni mukejiwe.” Basi wakilawa wakuka, wakiwona paafikire pare, wakikala naye noire suku ire. Úkiwa wakati wa ruremba. ");
INSERT INTO wmw_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Mmoja nkati ya wawiri ware ânsikire Yahaya akisowera ikisa akinfulata Insa, ákiwa Andere, nduye Ansumani Peduru. ");
INSERT INTO wmw_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Kwa noure mpunde ure, kansakula Ansumani nyenyeye, akimwambira: “Timmona Almasihi!” (“Almasihi” mana ake “ire atawaziwe na Mwenyezimungu kwa namuna maalumu”.) ");
INSERT INTO wmw_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Akintwala Ansumani akuka naye ka Insa. Insa akinnang'aniza, akamba: “Uwe ukwitiwa Ansumani, mwana wa Yahaya. Fala mwanzo wa rero, uwe zina rako Sefa” (kufasuli isema Peduru). ");
INSERT INTO wmw_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Subuu yake Insa akiwaza kulawa kuka Galileya. Iye akimmona Filipi, akimwambira: “Nifulate!” ");
INSERT INTO wmw_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipi kâpongoriwa kaya ya Betisaida, kwawo novyo Andere na Peduru. ");
INSERT INTO wmw_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipi akinsakula Nataniyeli. Nakummona, akimwambira javi: “Timmona noire wansemire Musa nTaureti, kamba vyawandike novyo minabii wengine. Tinsingana Insa nNazareti, mwana wa Yusufu.” ");
INSERT INTO wmw_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Akilawa Nataniyeli akamba: “Nazareti? Udaniza kuwa Nazareti cilawirira kinu cema?” Filipi akamba: “Njo ummone!” ");
INSERT INTO wmw_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Insa paammonire Nataniyeli akija, akamba, akimwamba iye: “Eyo ája‑yo ndi muIziraeli wakweli, saari njanja!” ");
INSERT INTO wmw_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nataniyeli akindairi: “Kunijiwa ndepi?” Insa akinjibu, akamba: “Filipi saanamba kukwita, omi nukuwona panviri wa nfigu.” ");
INSERT INTO wmw_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Basi Nataniyeli akimwambira: “Mwanlimu, uwe kuwa Mwana wa Mwenyezimungu! Uwe ndi Nfalume wawenye wa Iziraeli!” ");
INSERT INTO wmw_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Insa akindairi, akamba: “Kukubali kwa kuwa omi namba nukuwona tangu uri panviri wa nfigu? Basi, ukuja kuwona vinu vikulu-vikulu vyakupunda evi!” ");
INSERT INTO wmw_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Insa akizidi kusema tena: “Nukwambirani kweli kuwa mukuja kuwona bingu íri wanzu, na malaika wa Mwenyezimungu wakikwera, wengine wakisuka, wakintumika Binadamu wa Binguni.” ");
INSERT INTO wmw_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Suku yatatu, kaya ya Kanaa porovinsiya ya Galileya, ikitendiwa sherehe ya harusi. Na ákiwapo nopo mamaye Insa. ");
INSERT INTO wmw_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Insa neye kârifiwa pamoja na wanafunzi wake. ");
INSERT INTO wmw_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Paisire vinyu, mamaye kamwambira mwanawe javi: “Epa, vinyu aipo, isa!” ");
INSERT INTO wmw_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Iye akinjibu: “Mama, mbana munambira javyo? Wakati wangu wakutenda vinu-vyo aunafika!” ");
INSERT INTO wmw_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Noparepare, mamaye ire akiweta wamaudumu, akiwambira: “Iye caasaka kukwambirani noco, tendani noco.” ");
INSERT INTO wmw_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Sambi, íturiwa karibu nopare mivulo sita ya mawe, kila nvulo ukingira maji kiyasi ca lituru miya. Mivulo‑yo wakitúmira Mayahudi wakati wa kutawada wawe swafi. ");
INSERT INTO wmw_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Insa akiwambira maudumu ware javi: “Eyi mivulo‑yi ijazani maji.” Newo wakijaza mpaka pakanywa. ");
INSERT INTO wmw_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ikisa akiwambira: “Sambi, tekani aba, mukampe amiri wa jambo‑ri.” Ewo wakiteka, wakuka wakimpa. ");
INSERT INTO wmw_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Amiri wa jambo ire akiyeza maji âtadusiwe vinyu are, fala ejiwe kawatekire maji are. (Ila maudumu ware wakijiwa konta ndi watekire.) Noparepare, amiri wa jambo ire akitumiza kumwita mwenye harusi, ");
INSERT INTO wmw_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","akimwambira: “Wanu piya wazowerera kwanza kuudumu vinyu ngema, ikisa wakinywa pakulu ndi paiudumiwa vinyu sairevya‑yi. Fala umwe mutula vinyu ngema mpaka sambi‑pa!” ");
INSERT INTO wmw_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Insa katenda eyi alama ya maajuza akwanza‑ya kaya ya Kanaa porovinsiya ya Galileya. Kwa javyo ndi vyolote utukufu wake, ndimana wanafunzi wake wakinkubali. ");
INSERT INTO wmw_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Bandi ya evi, Insa akilongozana na mamaye, wanduze, pamoja na wanafunzi wake, wakiteremukira kaya ya Kafarnaumu, wakikala noko fala awekare suku nyingi. ");
INSERT INTO wmw_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Suku ya Pashukwa íkiwa karibu-karibu, suku ya sherehe ya Mayahudi, ndimana Insa kâkwera Yerusalemu. ");
INSERT INTO wmw_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Akiwasingana wanu nluwani nNyumba Takatifu wakiúzanya ng'ombe, makondoo, na mapomba, na wengine wekáre mmameza wakikakanya mizuruku. ");
INSERT INTO wmw_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Iye akitwala nzizi akipikisa nkwaju, akiwatuwisa wanu piya nluwani mure, pamoja na makondoo na ng'ombe. Mizuruku ya wanu wakikakanya ware akefya coro-coro-coro, na meza zawo akipindula pindu-pindu-pindu. ");
INSERT INTO wmw_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Akiwambira wanu wakiuzanya mapomba ware javi: “Umwe, evi vinu‑vi aya lavyani‑pa! Nyumba ya Baba‑yi mutwakalija kutenda bazari?” ");
INSERT INTO wmw_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Wanafunzi wake ware wakumbukira vyaandikiwe Mandiko Matakatifu kuwa javi: “Wivu wautendera Nyumba yako uwa kamba moto vyaunoca.” ");
INSERT INTO wmw_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Sambi, Mayahudi wandairi, wamba: “Uwe uri na mamulaka yakutenda evi vinu‑vi, ukolota alamani?” ");
INSERT INTO wmw_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Insa akiwajibu, akamba: “Dangulani Nyumba Takatifu‑yi, kwa muda wa suku natu nilamusa!” ");
INSERT INTO wmw_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Kwa javyo Mayahudi wakinjibu: “Eyi Nyumba‑yi ijengiwa myaka arubaini na sita. Uwe kwa muda wa suku natu basi ulamusaja?” ");
INSERT INTO wmw_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Fala iye akamba mwiri wake mwanyewe. ");
INSERT INTO wmw_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ndimana, paafufuke ka wafwi, wanafunzi wake wakumbukira kuwa iye kâsema novi, basi wakikubali Mandiko Matakatifu pamoja na usemi waasowere Insa. ");
INSERT INTO wmw_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Insa paakiwa Yerusalemu kusherehe ya Pashukwa, wanu wengi wankubali iye, kwa kuwona alama za maajuza zaakitendanga iye. ");
INSERT INTO wmw_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Fala Insa mwanyewe ewo aawakubalire, konta piya wanu akiwejiwa. ");
INSERT INTO wmw_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Aakinsakula munu wakumwámbira ewo cawawaza, konta iye akijiwa sana-sana mawazo a mwanadamu. ");
INSERT INTO wmw_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ákiwapo mwananlume mmoja Nfarizeu ákitiwa Nikodemu, iye ndi ákiwa nlongozi mmoja wa Mayahudi. ");
INSERT INTO wmw_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Kwa suku moja usiku, koka ka Insa, akimwambira: “Mwanlimu, tikwijiwa kuwa uwe kuwa mwanlimu kuperekiwa na Mwenyezimungu. Kamana aapo akidiri kutenda alama za maajuza zautenda‑zi ikiwa munu‑yo aári upande wa Mwenyezimungu.” ");
INSERT INTO wmw_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Insa akinjibu akimwambira javi: “Nukwambira kweli-kwelini kuwa ikiwa munu aapongoriwe mara yapiri, aawona futi ufalume wa Mwenyezimungu.” ");
INSERT INTO wmw_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemu akindairi: “Munu ari nkulu, aludira kupongoriwa mwaja? Vikidirika kuludira mmatumbo mwa mamaye apongoriwe tena?” ");
INSERT INTO wmw_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Insa akinjibu: “Nukwambira kweli kuwa munu sáapongoriwe kwa maji na kwa Roho wa Mwenyezimungu, iye engira muufalume wa Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Apongóriwe na mwiri ndi mwiri, na apongóriwe na Roho wa Mwenyezimungu ndi roho. ");
INSERT INTO wmw_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Uwe usishange vyanukwambire kuwa ibidi mupongoriwe mara yapiri. ");
INSERT INTO wmw_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Mepo ivungira kaisaka konse, na shauti yake usikira, fala awijiwa ndeyi kailawirira wala kayukirira. Ndi namuna moja noyo munu wakupongóriwa julu ya Roho wa Mwenyezimungu.” ");
INSERT INTO wmw_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemu akindairi, akamba: “Vinu kamba-vyo viwaja?” ");
INSERT INTO wmw_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Insa akinjibu akimwambira javi: “Uwe kuwa mwanlimu nkulu wa waIziraeli. Evi vinu‑vi aavikwerera sababuni? ");
INSERT INTO wmw_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nukwambira kweli kuwa vyatijiwa tikwereza, na vyatiwonire tankulavya ushahidi, fala ushahidi wetu umwe amukubali. ");
INSERT INTO wmw_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ikiwa nukwambirani vinu vikuna mulumwengu‑mu amunikubali, futi nukukwambirani vya binguni mukubalija? ");
INSERT INTO wmw_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Aapo akweríre kuka binguni sairi Binadamu wa Binguni esúke kulawa binguni. ");
INSERT INTO wmw_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Kamba Musa vyanlamuse nyoka nlanga, na visakikana novyo kulamusiwa Binadamu, ");
INSERT INTO wmw_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ipate kila mwenyé kumwamini onse apate mainsha a milele. ");
INSERT INTO wmw_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Kamana Mwenyezimungu kawapenda wanu mulumwengu javi: kawagabizi Mwanawe mmoja noyo tu basi, ipate kila mwenyé kumwamini asipoteye nfululu fala awe na mainsha a milele. ");
INSERT INTO wmw_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Konta Mwenyezimungu aampereke Mwanawe mulumwengu‑mu kuwalamula hukumu wanu, ila kampereka ipate wanu wapate kuvuka julu yake iye. ");
INSERT INTO wmw_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Amwámini aalumuriwa hukumu, ila saamwámini kesa kulamuriwa hukumu futi, konta aamini caari Mwana mmoja tu basi wa Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Na javi ndi namuna vyakujire kulamuriwa hukumu, kwa kuwa ija nuru mulumwengu‑mu, fala wanu wapenda pakulu kisi koliko nuru konta vitendo vyawo vya ubaya. ");
INSERT INTO wmw_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Kamana kila munu aténda vitendo vya ubaya inkima nuru, na aaja pairi nuru, ipate visiwoneke vitendo vyake. ");
INSERT INTO wmw_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Fala ire aténda vitendo vyakweli akuja pairi nuru, ipate wanu wawone kuwa vitendo vyake kankutenda julu ya Mwenyezimungu.” ");
INSERT INTO wmw_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Bandi ya evi, Insa pamoja na wanafunzi wake wakija inti ya Yudeya. Akikala nawo nokure, akozanga wanu. ");
INSERT INTO wmw_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yahaya novyo akozanga wanu Ainoni karibu ya Salemu, konta noko ákiwapo maji mengi. Wákijanga wanu, wakoziwa. ");
INSERT INTO wmw_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Epo Yahaya saanamba kufungiwa nkalaboshu. ");
INSERT INTO wmw_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Sambi, wanafunzi wa Yahaya na Yahudi mmoja wakanza kukaidiyana kuhusu kutawada. ");
INSERT INTO wmw_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ewo wakija ka Yahaya, wakimwambira: “Mwanlimu, ire waúkiwa nawo ng'ambu nyengine ya muto wa Yordani, noire waukílavya ushahidi wake ire, iye kankoza wanu, na piya wanu wankuka kwake iye!” ");
INSERT INTO wmw_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yahaya akijibu, akamba: “Hapana munu apáta kinu sesusiriwe kulawa binguni. ");
INSERT INTO wmw_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Anta nomwe-mwe muwa mashahidi wangu vyanambire omi: ‘Omi siri Almasihi, ila ndi niperekiwe kábula ya kuja iye.’ ");
INSERT INTO wmw_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ári na mwari-harusi ndi mwenye-harusi, fala rafiki wa mwenye-harusi ndi arípo epa, na ansikíra akuwa radi pakulu kwa sababu ya shauti ya mwenye-harusi. Kwa javyo, radi yangu itímu. ");
INSERT INTO wmw_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Lazima iye awe bora pakulu, ubora wangu upunguke.” ");
INSERT INTO wmw_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Yahaya akizidi kusema, akamba: “Alawíre julu binguni ndi bora koliko piya. Munu wa mulumwengu‑mu wa mulumwengu nomu, na asowera kiulumwengu. Alawíre binguni ndi bora koliko piya. ");
INSERT INTO wmw_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Asikíre na awoníre evyo kankulavya ushahidi, fala hapana akubali ushahidi wake. ");
INSERT INTO wmw_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Novyo-sivyo, mwenyé kukubali ushahidi wake akwakikisha kuwa Mwenyezimungu ndi mwenyé ukweli. ");
INSERT INTO wmw_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Konta aperékiwe na Mwenyezimungu asowera usemi wa Mwenyezimungu, kamana iye akumpa Roho bila kipimo. ");
INSERT INTO wmw_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Baba ampenda Mwanawe na piya vinu kangabizi mmakono mwake. ");
INSERT INTO wmw_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ankubali Mwanawe onse kanawo mainsha a milele. Fala saansikiriza Mwanawe onse aapata mainsha, ila nyongo ya Mwenyezimungu ikuwa julu yake iye.” ");
INSERT INTO wmw_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Mwenye Insa, pejiwe kuwa Mafarizeu wâsikira kuwa iye kankoza wanu wengi na ákiwa nawo wanafunzi zaida ya Yahaya, ");
INSERT INTO wmw_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(ingawa Insa mwanyewe siakoza, ila wakoza ndi wanafunzi wake), ");
INSERT INTO wmw_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","iye akilawa Yudeya, akiludira tena Galileya. ");
INSERT INTO wmw_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ikimbidi apite Samariya. ");
INSERT INTO wmw_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Basi, akija ire mpaka kaya moja ya Samariya yakwitiwa Sikari, karibu na uweru Yankubu wampere mwanawe Yusufu. ");
INSERT INTO wmw_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Noparepare úkiwepo nrimbu waasimbire Yankubu. Ndimana, Insa kwa kuwa kasokera na safari yake, akikala panrimbu nopare. Nowo wakati‑wo íkiwa karibu ya aduhuri. ");
INSERT INTO wmw_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Noparepare, akija mwanamuka mmoja nSamariya kuteka maji. Insa akimwambira: “Nunu, nimereni maji ninywe.” ");
INSERT INTO wmw_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Epo iri wanafunzi wake woka kaya ulu kuuza cakurya.) ");
INSERT INTO wmw_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Mwanamuka nSamariya ire akinjibu: “Umwe muwa Yahudi, omi niwa nSamariya. Munilebelaja maji a kunywa?” (Akisema javyo kamana Mayahudi na waSamariya awakipatana.) ");
INSERT INTO wmw_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Insa akinjibu, akimwambira javi: “Kamba ukijiwa uwezo wa Mwenyezimungu, na ari kukulebela maji a kunywa‑yo, uwe ndi ukisaka kunlebela, na iye nanga kakupa maji a mainsha ako.” ");
INSERT INTO wmw_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Iye akimwambira: “Mwenye, umwe amuna ndoo, na nrimbu‑wu wica pakulu. Sambi maji akunipa mainsha‑yo, musaka kupata ndepi? ");
INSERT INTO wmw_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ewu nrimbu‑wu katipa babu yetu Yankubu. Wákinywanga iye na wanawe pamoja na mifuwo yake. Sambi, uwe kunzaidi iye?” ");
INSERT INTO wmw_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Insa akinjibu, akamba: “Eya maji‑ya anywa onse iludira kunkola nyotwa tena. ");
INSERT INTO wmw_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Fala munu akinywa maji animpa omi, ainludira futi kunkola nyotwa kwa milele. Kwasa javyo, maji animpa omi, kwake iye antadukira kuwa nviriro wakububuka mainsha a milele.” ");
INSERT INTO wmw_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Mwanamuka ire akimwambira: “Mwenye, nimere noyo maji‑yo ipate isinikore nyotwa tena, wala nisije epa tena kuteka maji!” ");
INSERT INTO wmw_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Insa akimwambira: “Uka ukamwite nlumako, muje onse.” ");
INSERT INTO wmw_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Mwanamuka ire akinjibu, akamba: “Omi sina nlume.” Insa akimwitikizira: “Kusowera sana kwamba: ‘Omi sina nlume’. ");
INSERT INTO wmw_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Kwa kuwa úkiwa nawo walume watanu. Na nlume waúri nawo sambi‑yo siyo nlumako. Epo kusowera kweli yako!” ");
INSERT INTO wmw_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Mwanamuka ire akimwambira Insa: “Mwenye, omi niwona kuwa uwe kuwa nabii! ");
INSERT INTO wmw_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","WaSamariya wababu zetu, pawakabudu ndi nowu mwango‑wu. Fala umwe Mayahudi mukwamba kuwa mahala wanu pawajuzi kwabudu ndi Yerusalemu.” ");
INSERT INTO wmw_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Insa akimwambira: “Nunu, namini omi vyanukwambira‑vi: ukuja kufika wakati wakuwa ewu mwango‑wu wala Yerusalemu amuja kumwabudu Baba. ");
INSERT INTO wmw_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Umwe waSamariya mumwabudu nlungu samumwijiwa. Ila ofwe Mayahudi Nlungu watimwábudu timwijiwa, konta kuvushiwa kulawa ka Mayahudi. ");
INSERT INTO wmw_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Fala wakati wankufika, na kweli epa ufika futi, ware wamwábudu ka ukweli wamwabudu Baba kwa roho, wakifulata ukweli. Kamana Baba nowo ndi wawasakula wamwabúdu iye. ");
INSERT INTO wmw_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Mwenyezimungu ndi roho. Basi wenye kuntukuza iye wajuzi wantukuze kwa roho, wakifulata ukweli.” ");
INSERT INTO wmw_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Mwanamuka ire akilawa akamba: “Omi nukwijiwa kuwa Almasihi akuja. Na akija, atambira vinu piya.” ");
INSERT INTO wmw_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Basi Insa akisema: “Omi‑pa ndi noyo-noyoni, omi niri kusowera nawe‑mi.” ");
INSERT INTO wmw_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Kwa noure wakati ure, wanafunzi wa Insa wakiludi, washanga kunsingana Insa akipakanira na mwanamuka ire. Falakini anta mmoja andairire: “Usakulani‑pa?” wala “Mbana kwankusowera naye?” ");
INSERT INTO wmw_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ikisa, mwanamuka ire akasa nkanfu wake ure nopare, akiludira ukaya, akuka akiwereza wanu: ");
INSERT INTO wmw_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Tukeni mukammone munu anifafanurire piya vyanitendire. Fala noire si Almasihi?” ");
INSERT INTO wmw_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Basi wanu ware wakilawa nkaya mure, wakuka mpaka kaakiwa Insa kure. ");
INSERT INTO wmw_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Paalawire mwanamuka ire, wanafunzi ware wakinlebela Insa: “Mwanlimu, iryani ciwa conse‑ci.” ");
INSERT INTO wmw_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Fala iye kawambira: “Omi nirya cakurya umwe samwijiwa.” ");
INSERT INTO wmw_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Kwa javyo, wanafunzi ware wanza kudairiyana watupu: “Fala aapo ajire nawo cakurya akimpa?” ");
INSERT INTO wmw_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Insa akiwambira: “Cakurya cangu omi ndi kutenda vyaasaka Mwenyezimungu anipereke, na kutimiza canitumiwe kutenda. ");
INSERT INTO wmw_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Umwe musoweranga javi: ‘Ibaki tena myezi mine kufika wakati wa mavuno’, sinovyo? Fala omi nukwambirani: fungulani maso, munang'anize mmamasamba‑mo konta mbeyu piya zitokota, zisaka kuvuniwa. ");
INSERT INTO wmw_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Mwenyé kuvuna kapata nshahara wake futi, na akusánya visumo apata mainsha a milele. Kwa namuna‑yi, nvyari pamoja na nrimi piya watenderana radi. ");
INSERT INTO wmw_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Konta ewu usowezi‑wu wakweli: ‘Mmoja ndi avyála na mwengine ndi avúna.’ ");
INSERT INTO wmw_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Omi nukuperekani umwe muvune camutowire kukola kazi. Wengine wanza eyi kazi‑yi, umwe mwankufaika ewo cawanzire kutenda.” ");
INSERT INTO wmw_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","WaSamariya wengi wakikálanga kaya ulu ire wankubali Insa julu ya ushahidi wereze mwanamuka ure akamba javi: “Iye kanifafanurira omi piya vyanitendire!” ");
INSERT INTO wmw_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","WaSamariya pawajire, wakintafadali kuwa wekare nawo. Basi Insa akikala nawo suku mbiri. ");
INSERT INTO wmw_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Na wengi wawenye tena wankubali Insa julu ya usemi wake iye mwanyewe. ");
INSERT INTO wmw_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ewo mwanamuka ire wakimwambira javi: “Ataminire kwa sababu vyausowere uwe basi, kamana nofwe wanyewe tinsikira. Epa tijiwa kuwa eyu kweli-kwelini ndi Nvushi wa mulumwengu‑mu.” ");
INSERT INTO wmw_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Bandi ya suku mbiri zekare zire, Insa akilawa akiludira Galileya. ");
INSERT INTO wmw_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(Kusema kweli, Insa mwanyewe kâlavya ushahidi wakuwa aapo nabii anta mmoja wakwinshimiwa kwawo.) ");
INSERT INTO wmw_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Paafikire Galileya, waGalileya wampokerera sana-sana, kamana wâwona piya vyaatendire Yerusalemu pasherehe ya Pashukwa. Kamana ewo novyo woka noko. ");
INSERT INTO wmw_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Sambi, Insa akiludira tena Kanaa porovinsiya ya Galileya, kaya yaâtaduse maji akitenda vinyu. Kaya nyengine, Kafarnaumu, ákiwapo nkolakazi maalumu wa nfalume, mwanawe ákiwa nlwere. ");
INSERT INTO wmw_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Nkolakazi ire, paasikire kuwa Insa kalawa Yudeya kafika Galileya, akipita akinsakula. Nakummona akintafadali pakulu pawenye akamba: “Tuke ukamponese mwanangu, iye kawa karibu kufwa!” ");
INSERT INTO wmw_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Insa akimwambira javi: “Ikiwa amuwonire alama na maajuza, amushubutu futi kukubali.” ");
INSERT INTO wmw_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Nkolakazi ire akijibu: “Mwenye, tuke onse sambi‑pa, mwanangu saanamba kufwa.” ");
INSERT INTO wmw_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Insa akimwambira: “Uka, mwanawo‑yo apona!” Mwananlume ire akikubali usowezi wa Insa ure, akiludira kwawo. ");
INSERT INTO wmw_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Munjira paakiteremukira kwawo, akisimanana na watumisi wake wakimwinza, wakimwambira wakamba: “Mwanenu kapona, kawa hai!” ");
INSERT INTO wmw_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Iye kawadairi: “Mwanangu kapona wakatini?” Ewo wakinjibu: “Ijana, ‘uma ora’, homa ndi paimpitire.” ");
INSERT INTO wmw_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Wawa ire kejiwa kuwa kweli-kwelini mwanawe kapona noure wakati wambiriwe na Insa ure akamba javi: “Mwanawo kapona!” Kwa javyo, iye pamoja na wajamaa zake piya wakimwamini Insa. ");
INSERT INTO wmw_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Na eyi iwa ndi mara yapiri Insa yaatendire alama ya matajabisa paalawire Yudeya akija Galileya. ");
INSERT INTO wmw_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Bandi ya evi, rikiwapo jambo ra Mayahudi, Insa akikwera akuka Yerusalemu. ");
INSERT INTO wmw_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Sambi, Yerusalemu nokurekure, karibu ya nryango wakwitiwa “Nryango wa Makondoo”, íkiwapo tanki nkiebraniya wakita “Betizata”, noyo íkiwa na vitololo vitanu. ");
INSERT INTO wmw_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Nkati ya evyo vitololo-vyo, wákiwapo wanu wengi walwere: wanu sawawona na wakuremala na vitewe. ");
INSERT INTO wmw_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Nopo ákiwapo mwananlume mmoja kálwala myaka talatini na minane. ");
INSERT INTO wmw_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Insa paammonire aritandikire pansi, na kwa kwijiwa kuwa ákiwapo kure myaka mingi yawenye, kandairi: “Usaka upone?” ");
INSERT INTO wmw_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Nlwere ire akinjibu: “Mwenye, maji‑ya paaguburiwa, sina anta munu wakunauni kuningiza ntanki‑mu. Panikenekeza kwingira ponse, mwengine arefya omi saninamba.” ");
INSERT INTO wmw_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Insa akimwambira: “Lamuka! Sukula nanga yako‑yo, wenende!” ");
INSERT INTO wmw_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Kwa mpunde noure, mwananlume ire akipona, akitwala nanga yake ire, akenenda mwanyewe gidi‑gidi‑gidi. Suku yaakunire eya maajuza‑ya íkiwa sabadu. ");
INSERT INTO wmw_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ndimana walongozi wa Mayahudi wakimwambira mwananlume aponesiwe ire: “Uwe, rero suku ya sabadu! Siyo shariya kusukula nanga yako‑yo.” ");
INSERT INTO wmw_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Fala iye akiwajibu: “Mwananlume aniponese omi ndi vyaanambire, iye kanambira: ‘Sukula nanga yako‑yo, wenende.’ ” ");
INSERT INTO wmw_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ewo wakindairi: “Noyo akwambire: ‘Sukula nanga yako wenende‑yo’, nani?” ");
INSERT INTO wmw_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Mwananlume aponesiwe ire aamwijiwe mununi, kamana Insa kalainika, kamana noparepare wákiwapo wanu wengi wawenye. ");
INSERT INTO wmw_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Airini Insa akisimanana naye tena noire munu ire kuluwani ra Nyumba Takatifu, akimwambira: “Wona, uwe kupona! Usikore tena dambi ipate cisukukune kinu cakofya pakulu!” ");
INSERT INTO wmw_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ikisa akilawa mwananlume ire, akanza kuwambira walongozi wa Mayahudi: “Insa ndi aniponese.” ");
INSERT INTO wmw_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ndimana Mayahudi wakanza kunlumbata Insa kwa kuwa kâtenda evi vinu‑vi suku ya sabadu. ");
INSERT INTO wmw_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Fala Insa akiwajibu, akamba: “Mpaka rero Baba wangu daima‑zi kankukola kazi, nnomi novyo nankukola kazi.” ");
INSERT INTO wmw_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Insa, kwa sababu ya kwamba javire, walongozi wa Mayahudi warimbisa mpango wakunsakula wamulaye. Aiwere kwa sababu ya kutupa shariya ya suku ya sabadu noyo tu basi. Ciwakimire pakulu ndi kwa iye kâmba Mwenyezimungu ndi wawaye-wawayeni. Kwa namuna‑yi, akiritula kuwa sawa‑sawa na Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Insa akikola kuwajibu akamba: “Omi nukwambirani kweli kuwa Mwana aatenda kinu cakuwaza mwanyewe ila atenda caammonire wawaye akitenda. Kamana Baba caatenda conse, Mwana neye atenda noco. ");
INSERT INTO wmw_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Kweli, Baba ampenda Mwanawe na piya vinu vyaatenda, amolotera. Visitoshe, vinu vikulu-vikulu vya matajabisa vyakupunda evi akuja kumolotera ipate piya-mwe mutajabu. ");
INSERT INTO wmw_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Kamba Baba vyawalámusa wafwi kuwapa mainsha, Mwanawe novyo akumpa mainsha waansaka onse. ");
INSERT INTO wmw_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Kusema kweli, Baba aanlamula munu, ila kulamula piya kangabizi Mwanawe, ");
INSERT INTO wmw_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ipate wanu piya wansifu Mwanawe kamba vyawansifu Baba. Ire akatála kunsifu Mwanawe, novyo kankukatala kunsifu Baba ampereke iye. ");
INSERT INTO wmw_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Omi nukwambirani kweli: asikíriza usemi wangu onse na amwámini anipereke omi, kanawo mainsha a milele. Iye oka kulamuriwa, ila katupa kifo, kengira futi mmainsha a milele. ");
INSERT INTO wmw_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Omi nukwambirani kweli kuwa ukuja kufika wakati, na ufika futi, wafwi wakuja kusikira shauti ya Mwana wa Mwenyezimungu, na wája kusikira‑wo wainshi. ");
INSERT INTO wmw_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Kamana, kamba Baba vyaári nawo mainsha iye mwanyewe, iye novyo kampa mainsha Mwanawe awe nawo iye mwanyewe. ");
INSERT INTO wmw_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Na kampa Mwanawe mamulaka a kulamula konta iye ndi Binadamu wa Binguni. ");
INSERT INTO wmw_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Musitajabu kukuna kinu kamba‑ci, kamana ufika wakati wakuwa piya wari mmakaburi wasikira shauti yake, ");
INSERT INTO wmw_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","na wakuja kulawa. Watendire meema wafufuriwa wawe na mainsha, na watendire mabaya wafufuriwa wakahukumiwe.” ");
INSERT INTO wmw_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Omi sitenda kinu mwanyewe. Nilamula kamba vyanisikira. Kulamula kwangu ndi ka shariya, konta sitenda vyanisaka omi, ila vyaasaka ire anipereke omi. ");
INSERT INTO wmw_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Nikilavya ushahidi kuhusu omi mwanyewe, ushahidi wangu auna faida. ");
INSERT INTO wmw_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Fala kawapo mwengine alávya ushahidi kuhusu caniri omi. Nukwijiwa kuwa ushahidi walavya kuhusu omi‑wo ndi kweli. ");
INSERT INTO wmw_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Umwe muwapereka wanu ka Yahaya kukudairirani, na iye kalavya ushahidi kuhusu ukweli. ");
INSERT INTO wmw_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Kweli, omi sipokerera ushahidi wa wanadamu, ila evi vinu‑vi nukwambirani ipate muvushiwe. ");
INSERT INTO wmw_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yahaya‑yo ákiwaka kamba mwenge vyauwaka ukimwarika. Umwe nlangaza wake mutendera radi muda aba tu basi. ");
INSERT INTO wmw_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Fala ushahidi wangu nkulu koliko wa Yahaya, kamana vinu Baba vyanamurire kutenda, novyo-novyoni ndi vyanitenda, vikolota ushahidi kuwa niperekiwa na Baba. ");
INSERT INTO wmw_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Baba anipereke omi, neye-neyeni alavyanga ushahidi kuhusu omi. Shauti yake tangu amunamba kunsikira, wala umbo wake amunammona. ");
INSERT INTO wmw_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Usemi wake auri pamoja nomwe kamana amunkubali wampereke iye. ");
INSERT INTO wmw_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mandiko Matakatifu mutunza sana-sana konta mudaniza kuwa nkati yawo mupata mainsha a milele. Noyo Mandiko‑yo alavya ushahidi kuhusu omi! ");
INSERT INTO wmw_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Fala narero, amusaka kuja kwangu omi kupata mainsha. ");
INSERT INTO wmw_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Sipokerera kutukuziwa ka wanadamu. ");
INSERT INTO wmw_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Fala nukwijiwa namuna yenu, kuwa nkati yenu amuna pendo ra Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Omi nija mulumwengu‑mu kwa zina ra Baba wangu, fala amunipokerere. Ila akija mwengine wakulavya ushahidi wake mwanyewe, iye mumpokerera. ");
INSERT INTO wmw_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Umwe íri mupokerera kusifiyana watupu, amuyerera kupata kusifiwa na Nlungu mmoja tu basi, mukubalija? ");
INSERT INTO wmw_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Musidanizire kuwa nukuka kukwerezani ka Baba. Kawapo wakuka kukwerezani umwe ka Baba, ndi Musa, wamuntumaini umwe. ");
INSERT INTO wmw_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Munankubali Musa, nnomi nanga munikubali, kamana kandika kuhusu omi. ");
INSERT INTO wmw_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Fala ikiwa vyaandike Musa amukubali, futi usemi wangu mukubalija?” ");
INSERT INTO wmw_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Bandi ya evi, Insa kalawa, kaloka ng'ambu nyengine ya Tanda ra Galileya, zina rengine ra tanda‑ro Tiberiya. ");
INSERT INTO wmw_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Wanu wengi wakinfulata konta wâwona alama zake za maajuza zakuwaponesa walwere. ");
INSERT INTO wmw_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Insa akikwera pamwango, akikala nopo na wanafunzi wake. ");
INSERT INTO wmw_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Pashukwa, suku ya sherehe ya Mayahudi, íkiwa karibu. ");
INSERT INTO wmw_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Insa kwefya maso, kawona kundi ra wanu wengi wakija karibu yake, ndimana akindairi Filipi: “Cakurya cakuwatosha ewa wanu‑wa tisaka kuuza ndepi?” ");
INSERT INTO wmw_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Kandairi javyo kwa kunyerera tu basi, kamana caakisaka kutenda, akijiwa mwanyewe. ");
INSERT INTO wmw_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipi akinjibu: “Jarajara miyateni za parata aziuza mikate yakuwatosha, anta kila munu apate kipande kimoja-kimoja.” ");
INSERT INTO wmw_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Mwanafunzi wake mmoja wakwitiwa Andere, nyenyeye Ansumani Peduru, akamba: ");
INSERT INTO wmw_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Ona, kawapo‑pa nnemba mmoja ári nawo mikate mitanu ya tirigu na inswi mbiri. Fala viwatosha wanu wengi kamba‑wa?” ");
INSERT INTO wmw_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Insa akiwambira wanafunzi wake ware javi: “Wambireni wanu‑wo wekare.” Nopare mahala pare íkiwapo minyani mingi, basi piya ware wakikala bunga-bunga-bunga. Jumula ya wanu ware kuwawalanga wanawalume tu basi wákiwa alufu ntanu. ");
INSERT INTO wmw_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Basi Insa akitwala mikate ire, akinshukuru Mwenyezimungu, ikisa akanza kuwatongera wanu wekare ware. Inswi zire novyo akiwatongera, wakipata kamba vyawakisaka. ");
INSERT INTO wmw_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Bandi ya kwikuta piya wanu ware, Insa akiwambira wanafunzi wake ware, akamba: “Vipande vibakire-vyo, lokoterani pamoja tuke, anta kipande kimoja cisipoteye.” ");
INSERT INTO wmw_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Basi ewo wakilokotera vipande vya mikate mitanu vyawâtafune wanu vikibaki vire, vikijala vikalala kumi na viwiri. ");
INSERT INTO wmw_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Wanu ware, pawawonire alama yaatendire Insa ire, wakamba: “Kweli-kwelini, nabii akirindiriwa kuja mulumwengu‑mu ndi noyu!” ");
INSERT INTO wmw_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Insa kejiwa kuwa wákiwa tayari kuja kunkola makunje, wantawaze kuwa nfalume. Ndimana akilawa tena yeka yake, akiludira kumwango. ");
INSERT INTO wmw_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Paifikire jironi, wanafunzi wa Insa wakiteremukira kutanda. ");
INSERT INTO wmw_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Wakingira mungalawa, wakilokera Kafarnaumu. Juwa riswa kunja kwinukala pi, na Insa akiwa saanamba kuja pawákiwa pare. ");
INSERT INTO wmw_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ntanda mure mutimbuka kwa kuwa ikivunga mepo nyingi ti‑ti‑ti. ");
INSERT INTO wmw_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Wanafunzi ware, pawakivuta magasiya kitambo ca kilometuru ntanu au sita, noparepare wammona Insa akija akenenda julu ya maji, akifika karibu ya ngalawa ire! Ewo wakisusuka! ");
INSERT INTO wmw_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Fala Insa akiwambira: “Ndumi! Musope kinu!” ");
INSERT INTO wmw_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Basi, wakisaka kumpokerera mungalawa mure. Kwa mpunde noure, wawona wári nlufuko kaya yawakuka ire. ");
INSERT INTO wmw_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Subuu yake, wanu wabakire ng'ambu nyengine ya tanda ire, wawona kuwa ibaki ngalawa moja tu basi. Ewo wejiwa kuwa mungalawa mure Insa eengire nawo pamoja na wanafunzi ware engire nawo, walawa yeka yawo. ");
INSERT INTO wmw_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Mahala pawâtafune wanu mikate bandi ya Insa kushukuru pare, karibu pake zikija ngalawa nyengine za Tiberiya. ");
INSERT INTO wmw_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Wanu ware, pawejiwe kuwa Insa na wanafunzi wake awapo pare, wakingira mmangalawa mwawo, wakuka Kafarnaumu kunsakula Insa. ");
INSERT INTO wmw_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Pawansingane ng'ambu nyengine ya ntanda ire, wakindairi: “Mwanlimu, epa kufika rini?” ");
INSERT INTO wmw_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Insa akiwajibu, akamba: “Omi nukwambirani kweli kuwa munisakula siyo kwa kuwa muwona alama mojawapo, ila kwa kuwa mutafuna mikate mwikuta. ");
INSERT INTO wmw_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Musikore kazi kwa anzima ya cakurya camwéfya kunundu, ila shugulikirani cakurya cukupani mainsha a milele, caakupani Binadamu wa Binguni. Kamana ndi noyo-noyoni apewe na Mwenyezimungu Baba alama yakwakikisha.” ");
INSERT INTO wmw_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ikisa wanu ware wakindairi: “Tikitenda kazi za Mwenyezimungu, tíjuzi titende kinani?” ");
INSERT INTO wmw_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Insa akiwajibu, akamba: “Kazi za Mwenyezimungu ndi javi: munkubali waampereke iye.” ");
INSERT INTO wmw_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Kwa javyo, wandairi: “Alama yautenda tiwone tukukubali, kinani? Kwankutenda kinani? ");
INSERT INTO wmw_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Babu zetu wârya nlanga mikate yakwitiwa manã. Kamba vyavyândikiwe mMandiko: ‘Iye mikate ya mbinguni kawapa warye.’ ” ");
INSERT INTO wmw_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Insa akiwambira tena: “Nukwambirani kweli kuwa akupereni mikate ya mbinguni siyo Musa. Ila Baba wangu ndi akupani mikate yakweli ya mbinguni. ");
INSERT INTO wmw_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Kamana cakurya ca Mwenyezimungu ndi ire esuke binguni, awápa mainsha wanu wa mulumwengu.” ");
INSERT INTO wmw_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Wamwambira: “Mwenye, noyo mikate‑yo, tipe daima!” ");
INSERT INTO wmw_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Insa akiwambira: “Omi ndi cakurya ca mainsha. Ája kwangu omi, ainkola njala tena. Munu anikúbali, ainkola nyotwa tena. ");
INSERT INTO wmw_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Fala omi nukwambirani kuwa muniwona, novyo-sivyo amukubali. ");
INSERT INTO wmw_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Piya wanigabizire Baba wakuja kunifulata, na ája kwangu onse, simwefya panja. ");
INSERT INTO wmw_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Kamana nisuka kulawa binguni sijire kutenda vyanisaka omi mwanyewe ila vyaasaka anipereke omi. ");
INSERT INTO wmw_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Vyaasaka ire anipereke omi ndi javi: kuwa piya waanipere iye, wasipoteye anta mmoja, suku ya mwinsho niwafufure. ");
INSERT INTO wmw_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Kamana vyaasaka Baba wangu ndi kuwa ammóna Mwana, akinkubali iye, akuwa na mainsha a milele. Suku ya mwinsho nomi ninfufula awe hai kwa milele.” ");
INSERT INTO wmw_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ndimana Mayahudi wamojawapo wakanza kunduguda konta kâsema javi: “Omi ndi nkate wisuke binguni.” ");
INSERT INTO wmw_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ewo wakamba: “Eyu sinoyu Insa, mwana wa Yusufu, wawaye na mamaye nikamba timwijiwa? Sambi akwamba, ‘Nisuka kulawa binguni’, namunani?” ");
INSERT INTO wmw_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Insa akiwajibu: “Asani kuduguda watupu! ");
INSERT INTO wmw_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Aapo munu ája kwangu omi bila kuvutiwa na Baba anipereke omi. Noyo munu‑yo ninfufula suku ya mwinsho. ");
INSERT INTO wmw_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Nabii mmoja kândika javi: ‘Piya wakuja kufundiwa na Mwenyezimungu.’ Ndi kweli kuwa piya wenye kunsikiriza Baba na warifunda kwake, wakuja kwangu omi. ");
INSERT INTO wmw_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Kusema kweli, aapo munu ammonire Baba sairi ire alawire ka Mwenyezimungu, ndi ammonire Baba. ");
INSERT INTO wmw_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Omi nukwambirani kweli kuwa mwenyé kwamini kanawo mainsha a milele. ");
INSERT INTO wmw_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Omi ndi nkate wa mainsha. ");
INSERT INTO wmw_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Wababu zenu wârya manã nlanga, wafwa nfululu. ");
INSERT INTO wmw_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Eyi ndi mikate isuke mbinguni ipate munu asaka kuwa onse akirya, asifwe. ");
INSERT INTO wmw_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nomi-nomini ndi mikate ya mainsha isuke mbinguni. Munu mmojawapo akirya noyi mikate‑yi, ainshi milele. Mikate yanukupani wanu wa mulumwengu kuwa mupate mainsha ndi mwiri wangu‑wu.” ");
INSERT INTO wmw_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ndimana Mayahudi wakanza kukaidiyana watupu, wakamba: “Eyu munu‑yu vyaatipa mwiri wake tikirya, namunani?” ");
INSERT INTO wmw_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Kwa javyo, Insa akiwambira: “Omi nukwambirani kweli: ikiwa amurire mwiri wa Binadamu wa Binguni wala amunywere damu yake, amuwa na mainsha nkati yenu. ");
INSERT INTO wmw_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Mwenyé kurya mwiri wangu na kunywa damu yangu kanawo mainsha a milele, omi ninfufula suku ya mwinsho. ");
INSERT INTO wmw_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Kamana mwiri wangu ndi mikate yakweli, damu yangu ndi kinywaji cakweli. ");
INSERT INTO wmw_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Mwenyé kurya mwiri wangu na kunywa damu yangu, iye alungana nami, nnomi nilungana naye. ");
INSERT INTO wmw_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Kamba Baba vyaári hai anipereke omi, nomi niwa hai kwa ajili ya Baba, ndi novyo anírya omi, akuwa na uhai julu yangu omi. ");
INSERT INTO wmw_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Sambi, eyi ndi mikate isuke mbinguni. Siyo kamba mikate yawarire wababu zenu ikisa wakifwa. Ila ire árya eyi mikate‑yi onse akuwa na mainsha a milele.” ");
INSERT INTO wmw_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Vinu‑vi ndi vyaasowere paakiwafunda wanu nsinagoga ya Kafarnaumu. ");
INSERT INTO wmw_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Wanafunzi wake wengi, pawasikire usemi ure, wakamba: “Kusikira ewu usemi‑wu urigariga. Epa, asikíre vyaambire‑vi, nani?” ");
INSERT INTO wmw_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Insa kejiwa mwanyewe kuwa wanafunzi wake wankuduguda kuhusu vyaasowere vire, ndimana akiwambira javi: “Usemi wangu‑wu ukutipusani? ");
INSERT INTO wmw_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ndimana, futi ikiwa mummona Binadamu akikwera kuludira kaákiwa mida? ");
INSERT INTO wmw_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ampa munu mainsha ndi Roho, mwiri aufãi kinu. Usemi wanukwambireni umwe ndi roho na ndi mainsha. ");
INSERT INTO wmw_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Fala kati yenu wawapo wamojawapo sawakubali.” (Insa kasowera javyo kamana kawejiwa tangu mida sawakubali, na kamwijiwa nani ája kunzungunuka kumpereka ka maaduwi.) ");
INSERT INTO wmw_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Iye akizidi kuwambira akamba: “Ndimana, nukwambirani kuwa aapo munu ája kwangu omi iye saamuriwe na Baba.” ");
INSERT INTO wmw_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Kwa sababu ya kusowera javyo, wanafunzi wake wengi wakiludira nyuma, awanfulate iye tena. ");
INSERT INTO wmw_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ndimana Insa akiwadairi mawalii kumi na wawiri ware: “Nomwe novyo, musaka muke vyenu?” ");
INSERT INTO wmw_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ansumani Peduru akinjibu: “Mwenye, tikuka ka nani? Uwe ndi úri nawo masemo wakuwapa wanu mainsha a milele. ");
INSERT INTO wmw_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ofwe sambi tukwamini, tikwijiwa kuwa uwe ndi Ntakatifu wa Mwenyezimungu.” ");
INSERT INTO wmw_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Insa akiwajibu: “Umwe kumi na wawiri-mwe, nikamba omi ndi nukutondoreni? Fala kati yenu alawirira mmoja akuwa shetwani!” ");
INSERT INTO wmw_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Iye akimwamba Yuda, mwana wa Ansumani Shikariyoti. Kamana Yuda, ingawa ákiwa munkonjo wa ware kumi na wawiri ware, fala kanzungunuka. ");
INSERT INTO wmw_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Bandi ya vire, Insa akenenda Galileya. Aasakire tena kwenenda makaya a Yudeya konta wakulungwa wa Mayahudi wakinsakula wamulaye. ");
INSERT INTO wmw_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ífika karibu suku ya jambo ra Mayahudi rakwitiwa Sherehe ya Vitala. ");
INSERT INTO wmw_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ndimana wanduze Insa ware wamwambira: “Lawa‑pa, uka Yudeya, ipate wanafunzi wako newo novyo wakawone maajuza a utendanga‑yo. ");
INSERT INTO wmw_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Kamana munu akisaka kwijiwikana, aajuzi kufisa vitendo vyake vyaatenda. Ukitenda vinu‑vi, rolote baina.” ");
INSERT INTO wmw_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Wasema javi konta wanduze Insa awakinkubali. ");
INSERT INTO wmw_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Insa akiwambira: “Wakati wangu aunafika, ila wakati wenu umwe‑po daima uwa tayari. ");
INSERT INTO wmw_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Wanu wa mulumwengu‑mu umwe awakwinani, ila omi wanina, kwa sababu nilavya ushahidi kuwa vitendo vyawo vya ubaya. ");
INSERT INTO wmw_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Umwe kwerani muke kusherehe. Omi suka kusherehe‑ko konta wakati wangu aunafika nfululu.” ");
INSERT INTO wmw_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Nakuwambira javire, iye akibaki Galileya nokure. ");
INSERT INTO wmw_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Bandi ya wanduze ware kukwera kuka kusherehe kure, neye novyo akikwera akuka. Ila okire baina, kóka kwa kurifisafisa. ");
INSERT INTO wmw_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ndimana Mayahudi wakinsakula pasherehe pare, wakamba: “Ari, iye noyo kawa ndepi?” ");
INSERT INTO wmw_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Noparepare wanu wengi wateta kuhusu Insa. Wengine wakamba: “Iye munu mwema” fala wengine wakamba: “Siyo munu mwema, kankuwatesa wanu.” ");
INSERT INTO wmw_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Fala awerepo munu wakusowera baina kuhusu iye konta wakiwopa wakulungwa wa Mayahudi. ");
INSERT INTO wmw_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Kati-kati ya suku za sherehe ire, Insa akikwera kuNyumba Takatifu, akanza kuwafunda wanu. ");
INSERT INTO wmw_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Kwa javyo, Mayahudi wakitajabu wakamba: “Eyu mwananlume‑yu kwijiwa evi vinu‑vi piya saafundiwe namunani?” ");
INSERT INTO wmw_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Insa akiwajibu, akamba: “Kufunda kanifunda siko kwangu omi, ila ndi kufunda ka ire anipereke omi. ");
INSERT INTO wmw_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Munu mmojawapo akisaka atende vyaasaka Mwenyezimungu, basi akwijiwa kuwa eku kufunda‑ku ka Mwenyezimungu au nankusowera kwa mamulaka angu mwanyewe. ");
INSERT INTO wmw_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Asowéra kwa mamulaka ake mwanyewe asakula kurisifu mwanyewe. Fala ire asakúla kuwa wanu wansifu ampereke iye onse, akupo kukosa kweli kwake, iye ndi mwenyé ukweli. ");
INSERT INTO wmw_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Musa kakupani Taureti yakufulata, sinovyo? Fala piya-mwe aapo aténda vyaisaka Taureti. Musakula kunulaya sababuni?” ");
INSERT INTO wmw_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Junudi ya wanu ire ikijibu: “Uwe kuwa na shetwani! Asakula kukuulaya nani?” ");
INSERT INTO wmw_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Insa akiwajibu, akamba: “Omi nitenda maajuza mamoja na piya-mwe mushanga vyanitendire. ");
INSERT INTO wmw_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Novyo-sivyo, Musa kakupani tabiya ya itani. (Kusema kweli, eyi tabiya‑yi sianzire, wanza wababu zenu.) Umwe mwana nlume muntaya itani anta iwe suku ya sabadu. ");
INSERT INTO wmw_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Onani, dalili ndi suku ya sabadu mwananlume yaataiwa itani isifujike shuruti ya Musa. Ndimana, munikimwira kwa kumponesa munu mwiri nfululu suku ya sabadu sababuni? ");
INSERT INTO wmw_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Musilamure kwa kunang'anizana kumaso, ila lamulani kwa shariya.” ");
INSERT INTO wmw_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Kwa javyo, wanu wamojawapo wa Yerusalemu wakamba: “Mwananlume wawári kunsakula kumulaya‑yu, sinoyu‑yu? ");
INSERT INTO wmw_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Mmoneni, iye kankusowera baina wala awamwambira kinu! Itakuwa wakulungwa wamwijiwa ka ukweli kuwa iye Almasihi? ");
INSERT INTO wmw_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Fala ofwe eyu tikwijiwa kwawo. Paasaka kuja Almasihi, aapo ája kumwijiwa kwawo!” ");
INSERT INTO wmw_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Kwa javyo Insa, paakiwafunda wanu nNyumba Takatifu, kasowera na shauti ulu, akamba: “Umwe munijiwa? Anta kwetu mukwijiwa? Fala omi sijire epa kwa kusaka omi mwanyewe. Ila anipereke omi ndi mwenyé ukweli, iye umwe amumwijiwa. ");
INSERT INTO wmw_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Fala omi nimwijiwa konta nilawa upande wake, iye ndi anipereke.” ");
INSERT INTO wmw_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Basi ewo wayerera kunfunga, fala aapo ankorire nkono, konta wakati wake úkiwa saunafika. ");
INSERT INTO wmw_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Novyo-sivyo, wanu wengi ware wankubali, wakamba: “Akija Almasihi, atakutenda alama ulu‑ulu zakupunda zaatenda eyu mwananlume‑yu?” ");
INSERT INTO wmw_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Mafarizeu wawasikira wanu wakiteta nowu mwaha‑wu kuhusu Insa. Ndimana, ewo pamoja na wakulungwa wa dini wawapereka minduna wakanfunge. ");
INSERT INTO wmw_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Noparepare Insa akamba: “Nanawo suku aba futi namwe, ikisa nukuka ka ire anipereke. ");
INSERT INTO wmw_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Mukuja kunisakula fala amuja kunipata. Mahala kanisaka kuwa omi, umwe amukidiri kuja.” ");
INSERT INTO wmw_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Wakulungwa wa Mayahudi wakanza kudairiyana watupu: “Noyu mwananlume‑yu, ndepi kaasaka kuka ofwe tikisokerera kummona? Apunda makaya etu akuka inti za Sawari-Mayahudi, akawafunde wanu Sawari-Mayahudi? ");
INSERT INTO wmw_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Paasowera, ‘Mukuja kunisakula fala amuja kunipata’, mana ake kinani? Na ‘Mahala kaniri omi, umwe amukidiri kuja’, manani?” ");
INSERT INTO wmw_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Suku ya mwinsho ya sherehe, suku iwere ulu, Insa kémira, akisowera na shauti ulu‑ulu, akamba: “Ikiwa kawapo wakunkóla nyotwa, aje kwangu omi, anywe. ");
INSERT INTO wmw_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Mwenyé kunikubali omi, kamba vyaasema Mandiko Matakatifu, ‘Nroho yake ibubuka miviriro ya maji a mainsha.’ ” ");
INSERT INTO wmw_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Iye akamba javi kuhusu Roho wa Mwenyezimungu, kwa ware wenye kunkubali iye waja kumpokerera. Kamana nowo wakati‑wo, Roho Takatifu ákiwa saanamba kuwesukira, konta Insa ákiwa saanamba kutukuziwa. ");
INSERT INTO wmw_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Wanu wengine pajunudi ya wanu pare, pawasikire ewu usemi‑wu, wakamba: “Kweli-kwelini, eyu mwananlume‑yu ndi nabii watikinrindira!” ");
INSERT INTO wmw_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Wengine wakamba: “Eyu ndi Almasihi.” Fala wengine wadairi: “Almasihi atakulawirira Galileya? ");
INSERT INTO wmw_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Mandiko Matakatifu akwamba kuwa Almasihi ujukulu wa Daudi, sinovyo? Akwamba kuwa akuja kupongoriwa inti Betlehemu kwawo Daudi, sikweli?” ");
INSERT INTO wmw_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Kwa javyo, kukilawirira kwawanyikana wanu ware kwa sababu ya Insa. ");
INSERT INTO wmw_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Noparepare wengine wakisakula wanfunge, fala aawerepo wakolosa nkono wake kunkola. ");
INSERT INTO wmw_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ikisa minduna waludira ka wakulungwa wa dini pamoja na Mafarizeu. Wakulungwa wawadairi minduna ware: “Umwe amujire nawo mwananlume ire sababuni?” ");
INSERT INTO wmw_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ware minduna ware wakamba: “Vyaasowere iye tangu anamba kusowera munu javire!” ");
INSERT INTO wmw_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Basi, Mafarizeu ware wakiwajibu: “Mwaja? Nomwe novyo mutesiwa? ");
INSERT INTO wmw_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Anta mmoja nkati ya wakulungwa ankubalire? Nfarizeu mmoja ankubalire? ");
INSERT INTO wmw_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ewu umati‑wu awijiwa shariya za Musa! Ewo walaniwa!” ");
INSERT INTO wmw_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nfarizeu mmoja nopare wakwitiwa Nikodemu, âsimanane na Insa kwa suku zipitire, iye akiwambira javi: ");
INSERT INTO wmw_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Shariya yetu isema kuwa atijuzi kunlamula munu satinamba kunsikira ushahidi wake, tikijiwa caakosire.” ");
INSERT INTO wmw_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ewo wakijibu: “Epa sambi, nowe novyo kuwa nGalileya? Unafyoma nanga kuwonerera kuwa nabii mmojawapo wakulawa Galileya aukijuzi kunrindira.” ");
INSERT INTO wmw_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Basi wakitawanyikana, kila mmoja akuka kwake. ");
INSERT INTO wmw_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Fala Insa akuka kuMwango wa Mizaituni. ");
INSERT INTO wmw_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Alufajiri, Insa akiludira nNyumba Takatifu. Wanu piya wákija naye, iye akikala nawo, akikola kuwafunda. ");
INSERT INTO wmw_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Wanlimu wa shariya pamoja na Mafarizeu waja nawo mwanamuka ásinganiwe akizinga. Nakufika, wakimwimisa mbere ya wanu, ");
INSERT INTO wmw_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","wakindairi Insa: “Mwanlimu, eyu mwanamuka‑yu kakoriwa akizinga. ");
INSERT INTO wmw_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Kwa shariya yetu ofwe, Musa kâtamuru wanu kamba ewa tiwapanje na mawe. Sambi uwe, ukwamba mwaja?” ");
INSERT INTO wmw_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Wakindairi javi wamyerere ipate wammonerere ukosa mmojawapo. Insa akinama, akanza kuremba pansi na cala. ");
INSERT INTO wmw_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ikisa, kwa kuwa wakizidi kundairi-dairi, iye akilamuka, akiwambira: “Pamuri‑pa, munu saanakola dambi tangu, noyo anze kulokota riwe ampanje.” ");
INSERT INTO wmw_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Mara tena akinama, akizidi kuremba pansi pare. ");
INSERT INTO wmw_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Fala ware pawasikire javire, wakilawa mmoja-mmoja, ino-ino-ino-ino bila ncocoro. Wanzire kulawa ndi wazee. Insa wakimwasa nopare, na mwanamuka ire emire novire mbere yake. ");
INSERT INTO wmw_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Iye akilamuka, akindairi: “Nunu, ewo wandepi? Aabakire‑pa anta mmoja wakusaka kukulaumu?” ");
INSERT INTO wmw_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Akinjibu: “Mwenye, aapo‑pa munu anta mmoja.” Na Insa akimwambira: “Nomi novyo sukulamula hukumu. Uka vyako, usikore dambi tena.” ");
INSERT INTO wmw_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Sambi, Insa akikola kusowera mara nyengine tena na wanu, akiwambira: “Omi ndi nuru ya mulumwengu‑mu. Mwenyé kunifulata omi aashubutu kwenenda nkisi, ila apata nuru yakumpa mainsha.” ");
INSERT INTO wmw_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Kwa javyo, Mafarizeu wakimwambira: “Epa sambi, uwe kwankulavya ushahidi wako uwe mwanyewe, fala ushahidi wako‑wo siwo bora wakutumainiwa!” ");
INSERT INTO wmw_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Insa akiwajibu, akamba: “Ingawa nilavya ushahidi wangu omi mwanyewe, fala ushahidi wangu wakweli. Kamana mahala kanilawire na mahala kanuka nukwijiwa. ");
INSERT INTO wmw_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Umwe mulamula namuna ya kibinadamu. Omi sinlamula munu. ");
INSERT INTO wmw_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Anta panilamula, kulamula kwangu ka shariya kamana omi silamula yeka yangu, nilamula pamoja na Baba anipereke omi. ");
INSERT INTO wmw_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Anta nkati ya shariya yenu yandikiwa kuwa, ikiwa mashahidi wawiri wasema kinu kimoja noco, cawamba‑co cakweli. ");
INSERT INTO wmw_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Omi nilavya ushahidi wangu omi mwanyewe. Baba anipereke‑yo alavya novyo ushahidi wangu omi.” ");
INSERT INTO wmw_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Kwa javyo, wakindairi: “Wawayo uwe kawa ndepi?” Insa akijibu: “Umwe amunijiwa omi caniri na amumwijiwa Baba wangu. Munanijiwa, nanga mumwijiwa novyo Baba wangu.” ");
INSERT INTO wmw_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Insa kasowera evi piya‑vi ári nNyumba Takatifu akifunda. Iye ákiwa pansana paikikalanga kashoti ya swadaka ya Mwenyezimungu. Fala aapo anfungire, konta úkiwa saunafika wakati wake. ");
INSERT INTO wmw_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Kwa mara nyengine tena, Insa akiwambira: “Omi nukuka vyangu, umwe mukuja kunisakula, fala mukufwa na dambi zenu. Umwe amufika kanuka omi.” ");
INSERT INTO wmw_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ndimana Mayahudi wakambirana: “Iye akwamba kuwa ofwe atifika kooka iye‑po. Iye vyamba‑vi asaka kurulaya?” ");
INSERT INTO wmw_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Insa akiwambira, akamba: “Umwe mulawa pansi‑pa fala omi nilawa julu mbinguni. Umwe muwa wanu wa mulumwengu nomu, omi siri wa mulumwengu‑mu. ");
INSERT INTO wmw_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Omi nukukwambirani kuwa mukufwa na dambi zenu, konta ikiwa amukubali kuwa omi ndi noyo-noyoni, mukuja kufwa na dambi zenu.” ");
INSERT INTO wmw_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Kwa javyo, ewo wakindairi: “Uwe kuwa nani?” Insa akiwajibu: “Omi ndi noyo wanukwambireni tangu mwanzo. ");
INSERT INTO wmw_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Viwapo vinu vingi vyawenye vyaníri nawo vyakukuhusuni umwe kukwambirani, na kukulamulani. Fala anipéreke omi ndi mwenyé ukweli. Vyaninsikire iye ndi vyanukwambirani mulumwengu‑mu.” ");
INSERT INTO wmw_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ewo awereriwe kuwa Insa akisowera kuhusu Baba. ");
INSERT INTO wmw_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Kwa javyo, Insa akiwambira: “Umwe pamusaka kumwimisa pansalaba Binadamu wa Binguni, basi ndi pamusaka kwijiwa omi caniri. Mukwijiwa kuwa omi Binadamu, na sitenda kinu kwa mamulaka yangu, ila nisowera vyaanifundire Baba tu basi. ");
INSERT INTO wmw_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Anipéreke‑yo kawa pamoja nomi. Iye aanasire yeka, kamana omi daima nitendanga vyakumwajibu iye.” ");
INSERT INTO wmw_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Wanu wengi pawansikire Insa akisowera javyo, wakinkubali. ");
INSERT INTO wmw_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Kwa javyo, Insa akiwambira Mayahudi wankubalire ware: “Umwe, ikiwa mutenda vyanukwambireni, kweli-kwelini mukuwa wanafunzi wangu. ");
INSERT INTO wmw_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Umwe mukuja kwijiwa ukweli, na ukweli‑wo nowo umwe ukunusuruni.” ");
INSERT INTO wmw_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ewo wakinjibu: “Ofwe tiwa ujukulu wa Iburahima, tangu atinamba kuwa watwana wa munu. Kutisowerera kuwa tisakula kunusuriwa sababuni?” ");
INSERT INTO wmw_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Insa akiwajibu: “Nukwambirani kweli kuwa piya wenye kukola dambi wakuwa watwana wa dambi noyo. ");
INSERT INTO wmw_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ntwana aana pake kwa milele, fala mwana wa pakaya kanawo pake kwa milele. ");
INSERT INTO wmw_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ndimana ikiwa Mwana akukunusuruni, kweli-kwelini munusurika. ");
INSERT INTO wmw_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Omi nukwijiwa kuwa muwa ujukulu wa Iburahima. Novyo-sivyo, musaka munulaye, konta usemi wangu amutula mmyoyo mwenu. ");
INSERT INTO wmw_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Omi nisowera vyanimmonire Baba wangu, umwe mutenda vyamunsikire wawa yenu.” ");
INSERT INTO wmw_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ewo wakinjibu, wakamba: “Ofwe wawa yetu Iburahima.” Insa akiwambira: “Umwe, munawa wana wa Iburahima, nanga mufulata vyaákitendanga Iburahima. ");
INSERT INTO wmw_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Fala umwe musaka munulaye, omi níri kukwambirani ukweli waninsikire Mwenyezimungu. Iburahima aatendire javyo. ");
INSERT INTO wmw_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Umwe mwankutenda vitendo vya wawa yenu.” Ewo wakimwambira: “Ofwe atiri wana wa zinaa, tanawo wawa mmoja tu basi, Mwenyezimungu!” ");
INSERT INTO wmw_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Insa akiwambira: “Inawa Mwenyezimungu Baba wenu, umwe nanga munipenda omi, konta omi nilawa ka Mwenyezimungu, niwa epa. Sirijisire omi mwanyewe, ila iye ndi anipereke. ");
INSERT INTO wmw_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Umwe amwereriwa vyanukwambirani‑vi, sababuni? Ndi kwa kuwa avikwajibuni kufulata usemi wangu. ");
INSERT INTO wmw_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Umwe wawa yenu ndi Ibilisi, na umwe vikwajibuni kutenda vimwajibu wawa yenu. Iye tangu mwanzo kisomi, enendera njira ya ukweli, konta ukweli wawenye aana. Ibilisi paalongopa, atenda vitendo vya tabiya yake, kamana iye nlongo, ndi wawa wa walongo. ");
INSERT INTO wmw_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Fala omi, kwa kuwa nukwambirani kweli, umwe amunikubali. ");
INSERT INTO wmw_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Pamuri‑po, nani akidiri kwakikisha kuwa nanawo dambi? Ikiwa nankukwambirani ukweli, umwe amunikubali sababuni? ");
INSERT INTO wmw_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ári ka Mwenyezimungu onse, asikiriza caasema Mwenyezimungu. Sababu umwe amusikiriza ndi kwa kuwa ámuri ka Mwenyezimungu.” ");
INSERT INTO wmw_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Mayahudi wakinjibu, wakamba: “Atina haki yakukwambira kuwa uwe kuwa nSamariya, na kwanawo shetwani?” ");
INSERT INTO wmw_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Insa akijibu: “Omi sina shetwani ila ninsifu Baba wangu, umwe amunisifu. ");
INSERT INTO wmw_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Wala omi sisakula kuritukuza omi mwanyewe. Kawapo mwengine asakula kutukuziwa kwangu omi, iye ndi mwenyé kulámula. ");
INSERT INTO wmw_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Omi nukwambirani kweli: munu akifulata usemi wangu, kwa milele aayeza kifo.” ");
INSERT INTO wmw_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Mayahudi wakimwambira javi: “Sambi tikwijiwa kuwa uwe kwanawo shetwani! Iburahima kafwa na minabii wafwa, fala uwe ukwamba, ‘Munu akifulata usemi wangu, kwa milele aayeza kifo.’ ");
INSERT INTO wmw_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Uwe auri bora wakunzaidi baba wetu Iburahima afwire? Minabii novyo wafwa. Sambi uwe uritula kuwa nani?” ");
INSERT INTO wmw_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Insa akijibu: “Ikiwa omi niritukuza mwanyewe, utukufu wangu aufãi kinu. Anitúkuza omi ndi Baba, noyo wamwámba kuwa ndi Mwenyezimungu wenu‑yo. ");
INSERT INTO wmw_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Fala umwe iye amumwijiwa, ila omi nimwijiwa. Omi nikamba simwijiwa, nukuwa nlongo kamba umwe. Falakini omi kweli-kwelini nimwijiwa, na usemi wake nifulata. ");
INSERT INTO wmw_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Baba wenu Iburahima kafurahi konta kejiwa kuwa nukuja. Iye kawona na kawa radi.” ");
INSERT INTO wmw_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Kwa kusema javyo, Mayahudi ware wakimwambira javi: “Uwe aunatimu myaka amusini. Iburahima‑yo kûmmona?” ");
INSERT INTO wmw_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Insa akiwajibu: “Omi nukwambirani kweli: kábula yakupongoriwa Iburahima, omi niwapo.” ");
INSERT INTO wmw_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Basi wakilokota mawe kusaka kumpanja, fala Insa akirifisa, akilawa nNyumba Takatifu mure. ");
INSERT INTO wmw_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Insa paakipita, kammona munu sawona tangu kupongoriwa kwake. ");
INSERT INTO wmw_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Wanafunzi wake wakindairi: “Mwanlimu, mwananlume‑yu kapongoriwa sawona kwa sababu ya dambi zake au za wawaze?” ");
INSERT INTO wmw_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Insa akiwajibu: “Eyu kutowa kuwona kuno siyo kwa sababu ya dambi zake wala za wawaze, ila ipate julu yake viwoneke vyaatenda Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ofwe tijuzi tikore kazi za ire anitumire nsana nowu. Ukuja usiku saukidirika kukoriwa kazi. ");
INSERT INTO wmw_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Paniri‑po mulumwengu‑pa, omi ndi nuru ya mulumwengu‑mu.” ");
INSERT INTO wmw_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Nakwisa kusema javire, akisunira pansi, akivulula nsanga ure na mata, akimpaka mwananlume ire mmaso, ");
INSERT INTO wmw_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","akimwambira javi: “Uka, ukataye kumaso tanki ulu ya Siloamu.” (Zina ra Siloamu mana ake “kaperekiwa”.) Basi, mwananlume ire akuka, akitaya kumaso, akiludira ukaya wakuwona wawenye ngwee. ");
INSERT INTO wmw_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Kwa javyo, majirani wake wákimmonanga vyaákiwa, pamoja na wanu wákimmonanga akipita akilebela zimola, wakamba: “Eyu sinoyu‑yu mwananlume ákikalanga akilebela zimola‑yu?” ");
INSERT INTO wmw_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Wanu wengine wakamba: “Aye, ndi noyu.” Fala wengine wakamba: “Siye! Eyu kalandana naye tu basi.” Iye akizidi kwamba: “Ndi nomi.” ");
INSERT INTO wmw_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Kwa javyo, ewo wakindairi: “Sambi, maso ako‑yo afunguka mwaja? Uwonaja?” ");
INSERT INTO wmw_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Iye akijibu: “Mwananlume wakwitiwa Insa ndi avulure nsanga na mata akinipaka mmaso‑mu, akinambira javi: ‘Uka ukataye kumaso Siloamu.’ Nomi nukuka, nikowa, nikanza kuwona!” ");
INSERT INTO wmw_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ewo wakindairi: “Noyo mwananlume‑yo kawa ndepi?” Iye akijibu: “Sijiwa.” ");
INSERT INTO wmw_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ikisa ewo wakintwala mwananlume saâkiwona ire, wakuka naye ka Mafarizeu. ");
INSERT INTO wmw_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Kusema kweli, suku Insa yaâvulure nsanga na mata, akimponesa mwananlume saakiwona ire, íkiwa suku ya sabadu. ");
INSERT INTO wmw_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Kwa javyo, Mafarizeu ware newo novyo wakindairi tena namuna vyaaponesiwe awone. Iye akiwambira: “Iye kavulula nsanga na mata, akinipaka mmaso‑mu, ikisa nikitaya kumaso, nikanza kuwona ngwee.” ");
INSERT INTO wmw_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Mafarizeu wamojawapo wakamba: “Eyu munu‑yu aaperekiwe na Mwenyezimungu, kamana aafulata shariya ya sabadu.” Fala wengine wadairi: “Munu mmadambi atendaja maajuza kamba‑ya?” Noparepare wakawanyana. ");
INSERT INTO wmw_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ndimana Mafarizeu ware wakindairi saakiwona ire mara nyengine tena: “Kwa kuwa kakufungula maso ako, kuhusu iye waambani?” Iye akijibu: “Iye nabii.” ");
INSERT INTO wmw_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Wakulungwa wa Mayahudi ware awakinkubali kuwa aakiwona tangu kupongoriwa kwake, akiludira kuwona, mpaka wakiwetisa wawaze mwananlume aponesiwe ire. ");
INSERT INTO wmw_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Nakufika wawaze, ewo wakiwadairi: “Eyu mwanenu wamwamba kapongoriwa sawona‑yu? Epa sambi kanza kuwona mwaja?” ");
INSERT INTO wmw_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Wawaze ware wakijibu, wakamba: “Tikwijiwa kuwa eyu mwanetu, na kâpongoriwa sawona. ");
INSERT INTO wmw_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Fala vyenende akanza kuwona atijiwa, wala atimwijiwa munu mmojawapo amponese. Iye munu nzima wawenye, ndairini mwanyewe, akisaka akujibuni!” ");
INSERT INTO wmw_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","(Wawaze ware wasowera javire kwa sababu yakuwopa wakulungwa wa Mayahudi, kamana wakulungwa ware wâsikizana kuwa wantuwise ndaraja ya nsinagoga munu mmojawapo asáka kuwambira wenziwe kuwa Insa Almasihi.) ");
INSERT INTO wmw_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ndimana wawaze ware wajibu javi: “Iye munu nzima, ndairini mwanyewe!” ");
INSERT INTO wmw_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Kwa javyo, mara yapiri ewo wakimwita mwananlume saakiwona ire, wakimwambira: “Kwa kutukuziwa Mwenyezimungu, sema kweli yako! Ofwe tikwijiwa kuwa eyo munu‑yo mmadambi.” ");
INSERT INTO wmw_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Akijibu: “Kamba iye mmadambi omi sijiwa. Canijiwe omi kinu kimoja: ingawa síkiwona, fala sambi nankuwona!” ");
INSERT INTO wmw_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ewo wakindairi: “Iye kakutenda kinani? Kakuponesa mwaja?” ");
INSERT INTO wmw_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Iye akiwajibu: “Omi nûkwambirani futi, fala umwe amusikire. Musaka kusikira tena sababuni? Nomwe novyo musaka muwe wanafunzi wake?” ");
INSERT INTO wmw_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ewo wakintukana cwaa, wakamba: “Epa, uwe kuwa mwanafunzi wake, fala ofwe tiwa wanafunzi wa Musa! ");
INSERT INTO wmw_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ofwe catijiwe ndi kuwa Mwenyezimungu kasowera julu ya Musa, fala kuhusu eyu, atimwijiwa anta upande waalawirire!” ");
INSERT INTO wmw_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Mwananlume ire akiwajibu, akamba: “Mama! Mbana vishangisa! Umwe amwijiwa kalawirira, fala iye omi kaniponesa. ");
INSERT INTO wmw_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tikwijiwa kuwa Mwenyezimungu aawasikiriza wamádambi, fala awasikiriza wenye kumwishimu, watimiza vyaasaka iye. ");
INSERT INTO wmw_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Tangu mwanzo wa ulumwengu, hapana manziro kasikirikana kuwa munu mmojawapo kamponesa munu waâkupongoriwa sawona. ");
INSERT INTO wmw_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Inawa eyu munu‑yu aajire kulawa ka Mwenyezimungu, aangari kutenda kinu kamba‑ci.” ");
INSERT INTO wmw_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ewo wakinjibu: “Uwe kuwa mmadambi nfululu! Sambi, uyerera kutifunda ofwe mwaja?” Noparepare wakintuwisa wakinlavira panja ya sinagoga ire. ");
INSERT INTO wmw_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Insa paasikire kuwa wantuwisira panja, akinsingana mwananlume ire, akindairi: “Uwe, unkubali Binadamu wa Binguni?” ");
INSERT INTO wmw_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Mwananlume ire akijibu, akamba: “Noyo nani, Mwenye? Nambire, ipate ninkubali!” ");
INSERT INTO wmw_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Insa akimwambira: “Uwe kummona, ndi noyu-noyuni wauri kusowera naye sambi-pa‑yu!” ");
INSERT INTO wmw_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Iye akamba: “Mwenye, nukwamini!” Naye akimwabudu. ");
INSERT INTO wmw_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Insa akimwambira: “Omi nija mulumwengu‑mu niwalamure wanu. Nija ipate vipofu wawone, na wawona wawe vipofu.” ");
INSERT INTO wmw_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Mafarizeu wengine waákiwa nawo karibu iye wansikire akisowera javire, wakindairi: “Epa, ikuwa ofwe novyo tiwa vipofu, nikamba?” ");
INSERT INTO wmw_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Insa akiwajibu: “Inawa umwe muwa vipofu, amungari kuwa na wamádambi! Fala kwa kuwa mukwamba ‘Tiwona’, salani na madambi yenu.” ");
INSERT INTO wmw_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Insa kazidi kusowera, akamba: “Omi nukwambirani kweli. Akwéra sereka ya makondoo onse, kwasa kupita panryango, noyo-noyoni mwivi na nnyang'anyi. ");
INSERT INTO wmw_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Fala apíta panryango onse, ndi nsunga wa makondoo. ");
INSERT INTO wmw_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Kwake iye nakola wa panryango wa sereka ndi afungúla nryango. Makondoo wamanyira shauti yake. Aweta makondoo mazina awo, newo awasungira panja. ");
INSERT INTO wmw_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Bandi yakuwalavira piya panja, iye alongorera. Makondoo wanfulata konta wamanyira shauti yake. ");
INSERT INTO wmw_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Munu sawamwijiwa awanfulata ila wantira, konta awamanyira shauti za wanu sawawejiwa.” ");
INSERT INTO wmw_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Insa wanu ware kawasowerera eci kinyume‑ci, fala ewo awereriwe mana ake vyawambiriwe vire. ");
INSERT INTO wmw_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Kwa javyo, Insa akiwambira tena: “Nukwambirani kweli. Omi ndi nryango ka makondoo. ");
INSERT INTO wmw_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Piya walongorere kábula ya omi wevi na wanyang'anyi, na makondoo awawasikirize. ");
INSERT INTO wmw_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Omi ndi nryango. Anipíta akingira julu yangu omi onse, avushiwa. Kanawo mahala pakutumaini. ");
INSERT INTO wmw_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Mwivi aaja sairi kuja kwiwa, kuulaya na kudangula. Omi nija ipate wawe na mainsha, wawe nawo pakulu pawenye.” ");
INSERT INTO wmw_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Insa akizidi kusowera, akamba: “Omi niwa Nsunga mwema. Nsunga mwema apereka mainsha ake afwe kwa ajili ya makondoo wake. ");
INSERT INTO wmw_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Nsunga wakupokeresiwa, nsunga‑yo makondoo siwakewakeni. Iye siyo nsunga wa kweli. Ndimana, akimmona mmwinzi akija, atuwa, awasa makondoo. Basi mmwinzi anduru kondoo mmoja, wengine watawanyikana. ");
INSERT INTO wmw_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Kwa kuwa nsunga wakupokeresiwa aawashugulikira makondoo. ");
INSERT INTO wmw_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Omi niwa Nsunga mwema. Niwejiwa makondoo wangu, newo omi wanijiwa, ");
INSERT INTO wmw_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","kamba Baba vyanijiwa, nomi nimwijiwa Baba. Omi nipereka mainsha angu nifwe kwa ajili ya makondoo wangu. ");
INSERT INTO wmw_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Nanawo makondoo wengine sawapo eci kitundu‑ci, newo novyo nijuzi niwalongoze. Ewo wakuja kusikira shauti yangu. Kwa javyo, uwapo nfuwo moja na nsunga mmoja. ");
INSERT INTO wmw_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Baba anipenda kwa kuwa nipereka mainsha angu nifwe, niludire kutwala tena. ");
INSERT INTO wmw_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Hapana alávya mainsha angu, ila omi niripereka mwanyewe nifwe. Nanawo mamulaka a kupereka, na nanawo mamulaka a kupewa kupokerera tena. Ndi vyanilaiziwe na Baba wangu.” ");
INSERT INTO wmw_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Kwa mara nyengine tena, kukilawirira kwawanyana nkati ya Mayahudi kwa sababu ya nowu usemi‑wu. ");
INSERT INTO wmw_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Wengi wakamba: “Iye kapatiwa na shetwani, kangamiya! Noyu munsikiriza sababuni?” ");
INSERT INTO wmw_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Wengine wakamba: “Usemi‑wu siwo wa munu wakumilikiwa na shetwani. Shetwani amponesa munu sawona?” ");
INSERT INTO wmw_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Nowo wakati‑wo, Yerusalemu ritendiwa Jambo ra Nyumba Takatifu. Úkiwa wakati wa baridi. ");
INSERT INTO wmw_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Insa akipita akenenda nlupenu ra Nyumba Takatifu, lupenu‑ro rikitiwa “Lupenu ra Selemani”. ");
INSERT INTO wmw_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Mayahudi wakijumana wakinzunguriza wakindairi: “Uwe kwankutangaisha mpaka rini? Tambire kweli kamba uwe kuwa Almasihi, au auri?” ");
INSERT INTO wmw_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Insa akiwajibu: “Omi nûkwambirani futi fala amusaka kukubali. Kazi zanitenda omi kwa zina ra Baba zikolota ushahidi caniri omi. ");
INSERT INTO wmw_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Fala umwe amukubali konta ámuri makondoo wangu. ");
INSERT INTO wmw_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Makondoo wangu wasikira shauti yangu. Omi niwejiwa, newo wanifulata. ");
INSERT INTO wmw_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Omi niwapa mainsha a milele, awapoteya tena. Hapana akidíri kunipokonyola mmakono mwangu. ");
INSERT INTO wmw_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Baba wangu anipére ewo ndi bora pakulu kupunda piya. Hapana akidíri kumpokonyola Baba mmakono mwake.” ");
INSERT INTO wmw_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Omi na Baba tiwa kinu kimoja. ");
INSERT INTO wmw_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Mayahudi mara nyengine tena wakilokota mawe wampanje. ");
INSERT INTO wmw_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Insa akiwambira: “Omi nukoloterani kazi nyingi ngema za Baba. Kazi mojawapo yamusaka kunipanjira ndi yepi?” ");
INSERT INTO wmw_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Mayahudi wakinjibu: “Atisaka kukupanja kwa sababu ya meema yautendire, ila kwa namuna zako zakukufuru! Konta uwe kuwa mwanadamu, fala uritula kuwa Mwenyezimungu!” ");
INSERT INTO wmw_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Insa akiwajibu: “Yandikiwa nkati ya shariya yenu kuwa Mwenyezimungu kâmba javi: ‘Umwe muwa milungu.’ Sikweli? ");
INSERT INTO wmw_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Iye kaweta ‘milungu’ ware wapokerere habari za Mwenyezimungu, (na Mandiko aapinduka). ");
INSERT INTO wmw_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Kwa javyo, ire atawáziwe na Baba, akiperekiwa mulumwengu‑mu, mwamba kuwa iye kankukufuru kwa sababu nukwamba: ‘Niwa Mwana wa Mwenyezimungu’. Mwaja? ");
INSERT INTO wmw_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ikiwa sitenda kazi za Baba, musinikubali. ");
INSERT INTO wmw_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Fala ikiwa nankutenda kazi za Baba, anta musinikubali omi‑pa, kubalini kwa kazi zanitenda, ipate mwijiwe na mwereriwe sana-sana kuwa nilungana na Baba na Baba kalungana nami.” ");
INSERT INTO wmw_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Kwa mara nyengine tena wayerera kunfunga, fala iye akiwapolonyoka mmakono mwawo. ");
INSERT INTO wmw_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Iye akuka vyake tena, akiloka muto wa Yordani, akuka mpaka mahala paânzire Yahaya koza, akikala nopare. ");
INSERT INTO wmw_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Wanu wengi wawenye wakija kwake iye, wakamba: “Yahaya aatendire alama anta mamoja, fala piya vyaambire kuhusu eyu mwananlume‑yu vyakweli!” ");
INSERT INTO wmw_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Basi nokurekure, wanu wengi wawenye wankubali Insa. ");
INSERT INTO wmw_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ákiwapo mwananlume mmoja wakwitiwa Lazaru ákiwa nlwere. Iye kwawo kúkiwa Betaniya, kaya yawákikalanga Mariyamu na Marta nduye. ");
INSERT INTO wmw_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mariyamu noire âmmiminire sheru Mwenye, ânfutire mmaulu na nywiri zake ire, nlumbuwe wakwitiwa Lazaru ndi ákiwa nlwere. ");
INSERT INTO wmw_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Basi walumbuze ware watumiza kumwambira Insa: “Mwenye, waumpenda uwe‑yo kuno umpata ulwere.” ");
INSERT INTO wmw_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Fala Insa paasikire javire, akamba: “Ewo ulwere‑wo mwinsho wake siyo kufwa ila wolote utukufu wa Mwenyezimungu. Julu ya ulwere‑wo atukuziwe Mwana wa Mwenyezimungu.” ");
INSERT INTO wmw_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Sambi, Insa akiwapenda pakulu sana Marta na nduye pamoja na nlumbwawo Lazaru. ");
INSERT INTO wmw_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Kwa javyo, paasikire habari yakuwa Lazaru nlwere, Insa akikala tena suku mbiri kaákiwa nokure. ");
INSERT INTO wmw_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ikisa akiwambira wanafunzi wake: “Tukeni tiludire tena Yudeya.” ");
INSERT INTO wmw_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Wanafunzi ware wakimwambira: “We! Mwanlimu! Mayahudi suku mbiri-nozizi noko wákisaka kukupanja na mawe, sambi uludira kuka tena noko mwaja?” ");
INSERT INTO wmw_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Insa akiwajibu: “Kutwa iwa nawo ora kumi na mbiri, sikweli? Mwenyé kwenenda nsana aakwakula, konta awona nuru íri kumwarika mulumwengu‑mu. ");
INSERT INTO wmw_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Fala mwenyé kwenenda usiku akwakula konta aana nuru.” ");
INSERT INTO wmw_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Bandi yakusowera evyo vinu-vyo, akiwambira: “Rafiki yetu Lazaru kalala, fala omi nukuka nikanlamuse.” ");
INSERT INTO wmw_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Wanafunzi wake wakinjibu: “Mwenye, ikiwa kankulala basi, anusurika.” ");
INSERT INTO wmw_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Kusema kweli, usowezi wa Insa ure ukisema kuwa Lazaru kafwa, fala wanafunzi wake ware wakidaniza kuwa asowera kuhusu kulala usingizi tu basi. ");
INSERT INTO wmw_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ndimana, Insa akiwambira baina, akamba: “Lazaru kafwa. ");
INSERT INTO wmw_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Fala kwa ajili yenu umwe, niwa radi kuwa eko kaári‑ko atiri pamoja, ipate mwamini. Ila epa, tukeni tikammone.” ");
INSERT INTO wmw_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Basi Tamimu (atapiriwe zina ra “Masa”) akiwambira wanafunzi wenziwe: “Tukeni novyo, tikafwe naye pamoja.” ");
INSERT INTO wmw_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Insa paafikire, kasingana maiti a Lazaru azikiwe njonga, zipitire suku nne tangu kuzikiwa kwake. ");
INSERT INTO wmw_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betaniya kúkiwa karibu ya Yerusalemu, kitambo ca kilometuru natu. ");
INSERT INTO wmw_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Mayahudi wengi waja ka Mariyamu na Marta kuwani matanga a nlumbwawo. ");
INSERT INTO wmw_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Kwa javyo Marta, paasikire kuwa Insa kankuja, akilawa kuka kummwinza, fala Mariyamu kabaki ukaya. ");
INSERT INTO wmw_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta, paasimanane na Insa, kamwambira: “Mwenye, unawepo, nlumbwangu angari kufwa. ");
INSERT INTO wmw_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Fala omi nukwijiwa kuwa caulebela conse ka Mwenyezimungu, iye akupa.” ");
INSERT INTO wmw_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Insa akimwambira: “Nlumbuwo‑yo afufuka hai.” ");
INSERT INTO wmw_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta akinjibu: “Omi nukwijiwa kuwa iye afufuka hai pawaja kufufuka wanu suku ya mwinsho wa ulumwengu.” ");
INSERT INTO wmw_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Insa akimwambira: “Omi ndi kufufuka kawenye na mainsha. Anta munu‑yo afwe, akinikubali omi, ainshi. ");
INSERT INTO wmw_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Wenye piya kuinshi kuno wakinikubali omi, kweli-kwelini awafwa tena. Uwe ukubali javyo?” ");
INSERT INTO wmw_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Iye akinjibu: “Aye Mwenye, omi nikubali kuwa uwe ndi Almasihi, Mwana wa Mwenyezimungu, ire ája mulumwengu‑mu.” ");
INSERT INTO wmw_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marta, bandi ya kwamba javire, akuka akintetera nduye Mariyamu. Akimwambira kiriziu: “Mwanlimu ire kawapo, kankukwita!” ");
INSERT INTO wmw_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mariyamu nakusikira javire, akilamuka upesi-upesi, akuka wakawonane na Insa. ");
INSERT INTO wmw_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Epo Insa ákiwa saanamba kufika nkaya mure, ákiwa nopare pawasimanane na Marta pare. ");
INSERT INTO wmw_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Kwa javyo, Mayahudi wakinyamaza Mariyamu nnyumba mure ware, pawammonire iye akilamuka, akilawa upesi-upesi, wakinfulata. Ewo wakidaniza kuwa kankuka kukaburi kurira. ");
INSERT INTO wmw_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mariyamu nakufika paákiwa Insa pare, nakummona, akingwirira mmaulu akamba: “Mwenye, unawepo nlumbwangu angari kufwa.” ");
INSERT INTO wmw_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Insa nakummona Mariyamu akirira, na Mayahudi wákimpereka ware newo novyo wakirira, iye akikafilika pakulu nkati ya roho yake, akiwawonera utungu, ");
INSERT INTO wmw_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","akamba: “Maiti‑yo mutula ndepi?” Ewo wakimwambira: “Mwenye, tuke ukawone.” ");
INSERT INTO wmw_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Insa akimpakatika masozi pakata-pakata-pakata. ");
INSERT INTO wmw_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Kwa javyo, Mayahudi wakanza kwambirana watupu: “Mmoneni namuna vyaakimpenda!” ");
INSERT INTO wmw_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Fala wengine wakambirana watupu: “Níkamba noyu‑yu ndi amponese munu sawona ire. Epa itakuwa angari kutenda kinu kimojawapo Lazaru asifwe?” ");
INSERT INTO wmw_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ikisa Insa kwa mara nyengine tena akiuzunika, akuka mpaka kukaburi. Noro kaburi‑ro ríkiwapo jonga, na ríkiwapo riwe rikulu riziwiriwa panryango. ");
INSERT INTO wmw_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Insa akiwatuma wanu wamojawapo nopare: “Lavyani riwe‑ri.” Marta, nunuye marehemu ire, akimwambira: “Mwenye, iye anuha kituti pé, konta tangu akizikiwa rero suku nne.” ");
INSERT INTO wmw_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Insa akimwambira: “Omi sukwambire kuwa ukinamini, ukuja kuwona utukufu wa Mwenyezimungu?” ");
INSERT INTO wmw_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Basi, wakipiringisira panja riwe rire. Insa akinang'aniza julu binguni, akamba: “Baba, nukushukuru konta kunisikira. ");
INSERT INTO wmw_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Omi nukwijiwa kuwa daima unisikira, fala kwa sababu ya wanu wengi wári epa‑wa nisowera, ipate wakubali kuwa uwe ndi unipereke.” ");
INSERT INTO wmw_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Bandi yakusowera javire, Insa akikuwa pakulu, akita: “Lazaru! Lawira panja‑pa!” ");
INSERT INTO wmw_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Âfwire ire akilawira panja, akafiniwe na vipande vya kafani mmaulu na mmakono, pamoja na kafani yaavaziwe kumaso. Insa akiwambira: “Mpambureni, mumwase oke!” ");
INSERT INTO wmw_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ndimana, Mayahudi wengi wâjire ka Mariyamu, wawona vinu vyaatendire Insa vire, newo wakinkubali. ");
INSERT INTO wmw_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Fala wengine ware woka ka Mafarizeu, wawereza vyaakunishe Insa vire. ");
INSERT INTO wmw_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Kwa javyo wakulungwa wa dini na Mafarizeu ware wakijumana Baraza ya Milandu, wakidairi: “Epa titende mwaja? Kamana mwananlume‑yu kankutenda alama nyingi za maajuza! ");
INSERT INTO wmw_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Tikimwasa akizidi kutenda javi, piya wanu wankubali. Mwinsho, waRoma wadangula Nyumba yetu Takatifu na watifuja inti yetu‑yi!” ");
INSERT INTO wmw_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Fala mmoja wawo wakwitiwa Kayafa, nowo mwaka‑wo ndi ákiwa nkulu wa wakulungwa wa dini, akiwambira: “Umwe amweririwa kinu cisaka kuwa conse! ");
INSERT INTO wmw_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Amuwona kuwa ndi vyema kwenu umwe kufwa munu mmoja kwa faida ya wanu, koliko kudanguka inti nzima?” ");
INSERT INTO wmw_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kayafa vyaasowere vire aákidanizira, fala kwa kuwa noure mwaka ure ákiwa nkulu wa wakulungwa wa dini, iye kabushuru kuwa Insa akufwa kwa faida ya kabila ya Mayahudi. ");
INSERT INTO wmw_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Visitoshe, aafwa kwa faida ya Mayahudi tu basi fala ipate awajumulanise piya wana wa Mwenyezimungu watawanyikane, wawe kinu kimoja. ");
INSERT INTO wmw_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Basi, mwanzo wa noire suku ire, wakulungwa wa Mayahudi watenda mpango wakumulaya Insa. ");
INSERT INTO wmw_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ndimana Insa aákenenda akiriwonesa na Mayahudi, ila kalawa akukirira upande mmoja karibu ya langa, kaya yakwitiwa Efraimu. Akikala noko pamoja na wanafunzi wake. ");
INSERT INTO wmw_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Sambi, suku ya Pashukwa ya Mayahudi íkiwa karibu. Wanu wengi walawa nozire inti zire, wakikwera wakuka Yerusalemu ipate wakaswafiwe kábula ya Pashukwa. ");
INSERT INTO wmw_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ewo wakinsakula Insa, wakidairiyana watupu wákiwepo nNyumba Takatifu mure: “Muwonaja? Iye aaja kusherehe kuno?” ");
INSERT INTO wmw_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Kusema kweli, wakulungwa wa dini pamoja na Mafarizeu wâwatuma wanu, wakiwambira javi: “Munu mmojawapo akijíwa paari Insa, aje atambire tikanfunge.” ");
INSERT INTO wmw_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Suku sita kábula ya sherehe yakwitiwa Pashukwa, Insa akija Betaniya kaákikalanga Lazaru, noire mwananlume afufuriwe na Insa ka wafwi ire. ");
INSERT INTO wmw_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Kwa javyo wantengezera Insa cakurya maalumu. Marta akiwaudumu, Lazaru neye ákiwa pamoja na wanu wekare warinamire pansi nawo Insa wakirya ware. ");
INSERT INTO wmw_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Basi, Mariyamu akitwala numba ya nusu lituru ya sheru mmoja gali sana ya maluwa maalumu a kunuwira. Sheru ire akimmiminira Insa mmaulu na akinfuta mmaulu na nywiri zake. Nnyumba mure piya mukinuwira sheru dindeee. ");
INSERT INTO wmw_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Fala Yuda Shikariyoti, ákiwa mmoja wawo nkati ya wanafunzi wa Insa, (mwinshoni ajire akinzungunuka, akimpereka ka maaduwi), iye akamba: ");
INSERT INTO wmw_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Eyi sheru‑yi caitowire kuzanyiwa, isabu ya jarajara miya natu wakipewa masikini. Sababuni?” ");
INSERT INTO wmw_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Iye cimwambise javyo, aiwere sababu ya kuwashugulikira masikini, ila kwa kuwa ákiwa mwivi. Iye ndi ákiwa amiri wakusunga nzuruku wa wanafunzi wenziwe, na wakati mwengine ákiwanga akitendera mashuguli ake. ");
INSERT INTO wmw_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Insa akijibu: “Mwaseni, caatendire‑co ndi kutengeza ka mazishi angu. ");
INSERT INTO wmw_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Daima‑zi masikini muwa pamoja nawo, falakini omi amuwa nami daima.” ");
INSERT INTO wmw_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Mayahudi wengi pawejiwe kuwa Insa kawa kure, wakilawa wakuka noko. Ewo awokire kummona Insa basi, fala woka kummona novyo Lazaru, ire âfufuriwe na Insa ka wafwi. ");
INSERT INTO wmw_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Kwa javyo, wakulungwa wa dini wakitenda mpango na Lazaru ire novyo wamulaye, ");
INSERT INTO wmw_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","konta kwa sababu ya maajuza ankunire Lazaru, Mayahudi wengi wakilawa ndaraja mwawo wakinkubali Insa. ");
INSERT INTO wmw_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Subuu yake, wanu wengi wâjire kusherehe ya Pashukwa, wasikira kuwa Insa kankuja Yerusalemu. ");
INSERT INTO wmw_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Kwa javyo, wakisinja makuti a mitende, wakisukula, wakilawa, wakipita wakimmwinza, kuno wakibiya kilulu lu‑lu‑lu wakamba: “Hozana! Heri ári kuja kwa zina ra Mola, nfalume wa Iziraeli!” ");
INSERT INTO wmw_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Insa akinsingana kaburu katoto, akimpanda. Evi vikuna kamba vyayândikiwe: ");
INSERT INTO wmw_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Usope, mwana wa Ziyoni. Onani, nfalume wenu kankuja, ampandire kaburu katoto!” ");
INSERT INTO wmw_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Pavikunire evi vinu‑vi, wanafunzi ware awereriwe mana ake. Fala bandi ya Insa kutwariwa kukisiwa binguni, ewo wakumbukira kuwa evi vinu‑vi vyaândikiwa kuhusu iye, na novyo-novyoni ndi vyaawankunishe iye. ");
INSERT INTO wmw_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Wanu wâkiwa pamoja na Insa pawakimwita Lazaru kukaburi, akinfufula ka wafwi, ewo wakizidi kulavya ushahidi kuhusu iye. ");
INSERT INTO wmw_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Wanu wengi wasikira kuwa iye ndi âtendire ire alama ire, ndimana walawa kuka kummona Insa. ");
INSERT INTO wmw_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Kwa javyo, Mafarizeu wakambirana watupu: “Epa, atiri kukidiri kutenda kinu tena. Onani ulumwengu nzima‑wu wankufulata neye!” ");
INSERT INTO wmw_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Sambi, nkati ya ware wanu wokire kutukuza sherehe ya Pashukwa, wákiwapo Sawari-Mayahudi wamojawapo. ");
INSERT INTO wmw_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ewo wakimukira Filipi wa Betisaida ya Galileya, wakinlebela javi: “Mwenye, tisakula tiwonane naye Insa.” ");
INSERT INTO wmw_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipi akuka akimwambira Andere vyawalebele vire, wo‑wawiri wakuka wakimwambira Insa. ");
INSERT INTO wmw_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Insa akiwajibu, akamba: “Epa ufika wakati wakutukuziwa Binadamu wa Binguni. ");
INSERT INTO wmw_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nukwambirani kweli, mbeyu ikitowa kufifiriwa pansi ikifwa, ikuwa mbeyu mmoja noyo. Fala ikififiriwa ikifwa, ikupa visumo vingi vyawenye. ");
INSERT INTO wmw_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Mwenyé kupenda mainsha ake, apoteza mainsha‑yo. Munu saapenda mainsha ake mulumwengu‑mu, mainsha‑yo ariturira milele. ");
INSERT INTO wmw_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ikiwa munu mmojawapo asaka kunitumika, ájuzi anifulate omi. Mahala paniwa omi, ntumisi wangu akuwa nopo. Mwenyé kunitumika onse, na Baba wangu neye ansifu.” ");
INSERT INTO wmw_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Insa akizidi kuwambira: “Epa sambi roho yangu iuzunika, nambe mwaja? Nambe: ‘Baba, ninusuru ewu wakati‑wu’? Noci ndi canijirire ewu wakati‑wu. ");
INSERT INTO wmw_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Baba, olota utukufu wa zina rako!” Noparepare isikirikana shauti mbinguni ikamba javi: “Omi nîtukuza, na nizidi kutukuza tena.” ");
INSERT INTO wmw_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Wanu wákiwapo nopare ware, pawasikire noire shauti ire, wengine wakamba: “Eko kudidima!” Wengine wakamba: “Eyo laika kasowera naye.” ");
INSERT INTO wmw_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Insa akiwambira: “Eyi shauti‑yi aisikirikane kwa faida yangu, ila kwa faida yenu. ");
INSERT INTO wmw_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Epa sambi ufika wakati wakulamuriwa ulumwengu‑wu. Nfalume wa mulumwengu‑mu akwefyeriwa panja sambi‑pa. ");
INSERT INTO wmw_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Omi, panisaka kulamusiwa pansalaba julu ya ardhi, niwavuta wanu piya waje kwangu.” ");
INSERT INTO wmw_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Iye kasowera javyo kolota namuna ya kifo cikija kunsingana. ");
INSERT INTO wmw_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Wanu ware wakinjibu: “Shariya zetu zisema kuwa Almasihi ainshi milele. Uwe ukwamba kuwa Binadamu ibidi alamusiwe pansalaba. Mwaja? Noyo Binadamu‑yo nani?” ");
INSERT INTO wmw_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Insa akiwajibu: “Kwa wakati ntoto, iwapo nuru kati yenu. Enendani pamuri na nuru nopa, ipate kisi cisukutawareni. Ire enénda pakisi onse ejiwa koka. ");
INSERT INTO wmw_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Pamuri na nuru‑pa, aminini nuru‑yo nopa, ipate mulawirire kuwa wana wa nuru.” Insa pesire kusowera javire, akilawa akuka akirifisa. ");
INSERT INTO wmw_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ingawa akitenda alama nyingi mbere yawo, fala ewo wankuzidi kutowa kunkubali. ");
INSERT INTO wmw_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Vikuna ipate vitimiziwe vyaasemire nabii Izaya akamba javi: “Mola, akubalire habari zetu nani? Uwezo wa Mola kafafanuririwa nani?” ");
INSERT INTO wmw_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Kwa javyo, ewo awakidiri kukubali, kamana Izaya kereza mahala pengine: ");
INSERT INTO wmw_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Ewo wafungiwa maso awo ipate wasiwone, watenziwa myoyo yawo kuwa migumu ipate wasereriwe. Siwere javyo, ewo nanga waludi waja kwangu, nomi nanga niwaponesa” amba ndi Mola. ");
INSERT INTO wmw_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Izaya kasowera javyo konta kawona utukufu wa Insa na kasowera kuhusu iye. ");
INSERT INTO wmw_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Novyo-sivyo, ingawa walawirira wakulungwa wa Mayahudi wengi wakunkubali Insa. Fala awakisema baina kwa kuwa wakiwopa Mafarizeu wasiwatuwise ndaraja ra sinagoga. ");
INSERT INTO wmw_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Kusema kweli, wakipendeleya kusifiwa na wanadamu koliko kusifiwa na Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ikisa Insa akisowera pakulu-pakulu, akamba: “Anikúbali omi onse, asinikubali omi basi, na ankubali novyo anipereke omi‑yo. ");
INSERT INTO wmw_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Aniwóna omi onse, ammona novyo anipereke omi. ");
INSERT INTO wmw_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Omi nija kuwa nuru ya mulumwengu‑mu ipate piya anikúbali onse asikare nkisi. ");
INSERT INTO wmw_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ikiwa munu mmojawapo kasikira habari zangu, akitowa kufulata, omi sinlamula. Kamana omi sijire mulumwengu‑mu kuwalamula wanu, ila nija kuwavusha. ");
INSERT INTO wmw_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Anikátala onse akitowa kupokerera usemi wangu, kawapo mwenyé kunlamula iye. Usemi wanisowere, nowo ndi usaka kunlamula suku ya Kiyama. ");
INSERT INTO wmw_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Kamana omi sisowere kwa mamulaka angu mwanyewe, ila Baba anipereke ndi anamúru canamba na canereza. ");
INSERT INTO wmw_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Na omi nukwijiwa kuwa ámuri yake ndi itipa mainsha a milele. Basi, Baba canambira omi, noco ndi canisowera.” ");
INSERT INTO wmw_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Kábula kufika suku ya sherehe ya Pashukwa, Insa ákijiwa kuwa uwa karibu wakati wakwasa ulumwengu‑wu kuka ka Baba wake. Iye kâwapenda wanafunzi mulumwengu‑mu, na kawapenda mpaka mwinsho. ");
INSERT INTO wmw_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Usiku paakirya, Ibilisi kâgilibu futi moyo wa Yuda, mwana wa Ansumani Shikariyoti, kummwazira Insa kunzungunuka. ");
INSERT INTO wmw_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Insa ákijiwa kuwa Baba wake vinu piya kangabizi mmakono mwake. Ákijiwa kuwa kalawa ka Mwenyezimungu, na aludira ka Mwenyezimungu noko. ");
INSERT INTO wmw_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ndimana pawakirya pare akilamuka, akivula anzu yake, akitwala nkumi, akirizingiriza nkiuno, ");
INSERT INTO wmw_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","akimiminira maji mbasiya, akanza kuwosa maulu wanafunzi wake, akiwafuta na nkumi warizingirize ure. ");
INSERT INTO wmw_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Kwa javyo, akinfika Ansumani Peduru, akindairi: “Mwenye, maulu angu munosa?” ");
INSERT INTO wmw_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Insa akinjibu, akamba: “Uwe eci canukutenda‑ci awereriwa sambi‑pa, ila airini ukuja kwereriwa.” ");
INSERT INTO wmw_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Peduru akinjibu: “Iii! Anta suku moja umwe amunosa omi maulu!” Insa akinjibu: “Kamba sukosire, basi aúri mwanafunzi wangu.” ");
INSERT INTO wmw_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ndimana, Ansumani Peduru akinlebela akamba: “Kwa javyo, Mwenye, musinose maulu basi, nose novyo mmakono na nkiswa.” ");
INSERT INTO wmw_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Insa akinjibu: “Owire onse acibakire kinu cengine awe swafi ila ose maulu tu basi. Umwe piya muwa swafi, ila mmoja aari swafi.” ");
INSERT INTO wmw_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Kamana akimwijiwa munu asaka kunzungunuka, ndimana akamba: “Amuri swafi piya.” ");
INSERT INTO wmw_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Pesire kuwosa maulu awo, akitwala anzu yake akivala, akikala, akiwadairi: “Umwe canukutendireni sambi-pa‑ci, mwijiwa mana ake? ");
INSERT INTO wmw_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Umwe munita ‘Mwanlimu’ na ‘Mwenye’. Muwa nawo shariya konta ndi caniri. ");
INSERT INTO wmw_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Basi, ikiwa omi niwa Mwanlimu na Mwenye wenu, nukoseni maulu, na umwe noyo mujuzi mosane maulu watupu. ");
INSERT INTO wmw_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Kamana omi nukoloterani nfano. Kamba vyanitendire omi, na umwe mutende novyo. ");
INSERT INTO wmw_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Omi nukwambirani kweli. Hapana ntumisi anta mmoja wakumpunda ubora mwenye wake, wala hapana ntume wakumpunda antumire iye. ");
INSERT INTO wmw_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ikiwa mukwijiwa kuwa ndi javyo, na mukifulata novyo-novyoni, heri kwenu umwe! ");
INSERT INTO wmw_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Vyanisema‑vi sukwambani piya-mwe. Omi niwejiwa sana-sana waniwatondore. Fala Mandiko ajuzi kutimiziwa vyaamba: ‘Munu atafune nkate wangu kanipindukira.’ ");
INSERT INTO wmw_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Evi nukwambirani sambi‑pa savinamba kukuna, ipate pavija kukuna, mukubali kuwa omi nanawo zina ra Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nukwambirani kweli kuwa ampokérera wanimpereka onse, kanipokerera omi, na novyo anipokérera omi onse kampokerera anipereke omi.” ");
INSERT INTO wmw_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Bandi ya kwisa kusowera javire, Insa ikikafilika pakulu roho yake, akitangaza baina, akamba: “Omi nukwambirani kweli kuwa umwe mmojawapo anizungunuka.” ");
INSERT INTO wmw_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Wanafunzi wake ware wanza kunang'anizana watupu, awakereriwa munu waári kumwamba. ");
INSERT INTO wmw_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Upande wa Insa kamwikala mwanafunzi wake mmoja waakimpenda pakulu, kenamira upande wa Insa. ");
INSERT INTO wmw_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Kwa javyo, Ansumani Peduru akintendera alama andairi Insa mununi waari kumwamba. ");
INSERT INTO wmw_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Basi mwanafunzi ire akimwinamira pakifuwa Insa, akindairi: “Mwenye, ndi wepi‑pa?” ");
INSERT INTO wmw_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Insa akijibu: “Ndi noyo wanisaka kutwala nkate nikitoweza munsuzi nikimpa.” Basi akimeya nkate, akitoweza munsuzi, akimpa Yuda, mwana wa Ansumani Shikariyoti. ");
INSERT INTO wmw_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Bandi yakupokerera nkate ure, Shetwani akimwingira. Sambi Insa akimwambira: “Causaka kutenda conse, tenda upesi.” ");
INSERT INTO wmw_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Fala wenziwe wékare nawo pameza ware anta mmoja ereriwe caamwambire javire. ");
INSERT INTO wmw_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Kwa kuwa Yuda ndi ákiwa amiri wa nzuruku wa wanafunzi, wengine wakidaniza kuwa Insa kantuma Yuda kuka kuuza vinu visakikana pasherehe, au kantuma akawape masikini kinu kimojawapo. ");
INSERT INTO wmw_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yuda nakupokerera nkate ure, kwa mpunde noure akilawa. Nepo úkiwa usiku. ");
INSERT INTO wmw_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Bandi yakulawa Yuda, Insa akamba: “Epa sambi katukuziwa Binadamu wa Binguni. Na julu yake, Mwenyezimungu apata kutukuziwa. ");
INSERT INTO wmw_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ikiwa Mwenyezimungu katukuziwa julu yake, Mwenyezimungu novyo antukuza, na antukuza kwa mpunde noure. ");
INSERT INTO wmw_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Wanangu, omi niwa pamoja namwe suku aba futi. Umwe mukuja kunisakula, fala nukwambirani kamba vyaniwambire Mayahudi: ‘Kanuka omi, umwe amufika.’ ");
INSERT INTO wmw_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nankukupani ámuri nyipya: pendanani, munu na mwenziwe. Kwa namuna kamba omi vyanukupendireni, nomwe novyo mupendane, munu na mwenziwe. ");
INSERT INTO wmw_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Basi umwe, mukipendana, kweli ikuwa muwa wanafunzi wangu wakwijiwikana na wanu piya.” ");
INSERT INTO wmw_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ansumani Peduru kandairi Insa: “Mwenye, ukuka ndepi?” Insa akinjibu: “Kanuka‑ko, umwe‑po amunifulata sambi‑pa, fala airini munifulata.” ");
INSERT INTO wmw_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Peduru akindairi: “Mwenye, canitowa kukufulata sambi‑pa kinani? Omi niwa tayari kupereka mainsha angu kwa sababu yako!” ");
INSERT INTO wmw_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Insa akinjibu: “Mainsha ako upereka kwa sababu yangu omi? Nukwambira kweli kuwa aawika kokoriko saunikanire mara natu.” ");
INSERT INTO wmw_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Insa kawambira wanafunzi wake: “Musiuzunike mmyoyo yenu! Mwaminini Mwenyezimungu na munamini nomi novyo. ");
INSERT INTO wmw_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ka Baba awápo mamburo mengi awenye. Singari, nukwambirani kuwa nukuka kukutafitirani mamburo. ");
INSERT INTO wmw_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ikiwa nuka nukukutafitirani mamburo, niludi, nukuja kukutwalani ipate panuka kwikala omi, nomwe mukekare nopo. ");
INSERT INTO wmw_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Umwe mukwijiwa njira ya mahala kanuka‑ko.” ");
INSERT INTO wmw_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tamimu kandairi: “Mwenye, ofwe atijiwa kauka. Sambi, tikwijiwa njira ya mahala kauka‑ko mwaja?” ");
INSERT INTO wmw_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Insa akinjibu javi: “Omi ndi njira, ukweli, na mainsha. Aapo aja ka Baba sairi julu yangu omi. ");
INSERT INTO wmw_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ikiwa munijiwa omi, mukuja kumwijiwa novyo Baba. Mwanzo wa sambi‑pa, mumwijiwa na mummona.” ");
INSERT INTO wmw_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipi akimwambira Insa: “Mwenye, tolotere Baba wawenye‑yo tu, vititosha.” ");
INSERT INTO wmw_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Insa akiwajibu: “Filipi, omi niwa pamoja namwe suku nyingi zawenye. Aunijiwa? Aniwónire onse kammona Baba. Sambi mwambaja: ‘Tolotere Baba’? ");
INSERT INTO wmw_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Amwamini kuwa nilungana na Baba, na Baba kalungana nami? Usemi wanukwambirani‑wu, sisowera kwa mamulaka angu mwanyewe. Ila Baba ari nkati ya omi, ndi anitendesa kazi zake. ");
INSERT INTO wmw_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Kubalini kuwa omi nilungana na Baba, na Baba kalungana nami. Kwasa javyo, kubalini kwa sababu ya kazi zanitenda zawenye. ");
INSERT INTO wmw_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Nukwambirani kweli kuwa mwenyé kunikubali omi onse, atenda novyo piya vyanitenda omi. Kusema kweli, atenda vyakupunda evi, konta omi nankuka ka Baba. ");
INSERT INTO wmw_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Camulebela kwa zina rangu conse, nukutenderani noco ipate Baba atukuziwe julu ya Mwana. ");
INSERT INTO wmw_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Mukinilebela kinu kimojawapo kwa zina rangu, omi nukutenderani.” ");
INSERT INTO wmw_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Insa akizidi kusowera: “Mukinipenda, mufulata ámuri zangu. ");
INSERT INTO wmw_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nomi nukuja kunlebela Baba, na iye akwisusirani Mmashauri mwengine, muwe naye daima milele. ");
INSERT INTO wmw_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Iye ndi Roho ya ukweli. Roho‑yo wanu wa mulumwengu‑mu awakidiri kumpokerera, konta awammona wala awamwijiwa. Umwe mumwijiwa konta kawa pamoja nomwe na akuwa nnomwe. ");
INSERT INTO wmw_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Omi sukwasani kamba wana wa yatima, nukuja kwenu umwe. ");
INSERT INTO wmw_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ubaki wakati aba, wanu wa mulumwengu‑mu awaniwona tena, ila umwe omi muniwona. Kwa kuwa omi nankuinshi, nomwe novyo mukuja kuinshi. ");
INSERT INTO wmw_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Noyo suku‑yo ndi yamusaka kwijiwa kuwa omi nilungana na Baba, umwe mulungana nomi, na omi nilungana nomwe. ");
INSERT INTO wmw_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ejíwa ámuri zangu kuno akifulata ndi anipenda omi. Anipénda omi apendiwa na Baba wangu, nomi novyo nimpenda, nirifafanula mbere yake.” ");
INSERT INTO wmw_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yuda (sairi ire Yuda Shikariyoti ire) akidairi akamba: “Mwenye, utifafanurira ofwe tu basi, uwasa wanu wa mulumwengu, mwaja?” ");
INSERT INTO wmw_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Insa akinjibu akamba: “Anipénda onse afulata usemi wangu. Noyo munu‑yo Baba wangu ampenda. Nomi na Baba timwisukira, tiinshi naye pamoja. ");
INSERT INTO wmw_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Sanipenda omi onse aafulata usemi wangu. Usemi wamunisikira siwo wangu omi, ila wa Baba anipereke omi. ");
INSERT INTO wmw_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Vyanisowera‑vi nukwambirani patiwanga onse omi nnomwe. ");
INSERT INTO wmw_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Fala Mmashauri, Roho Takatifu, asaka kuperekiwa na Baba kwa zina rangu, iye akuja kukufundani vinu piya, akukumbusirani vinu piya vyanukwambireni. ");
INSERT INTO wmw_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Nukwasirani salama. Salama yangu nukupani umwe. Sukupani kamba ulumwengu vyaumpa munu salama. Musifazaike mmyoyo mwenu wala musope kinu. ");
INSERT INTO wmw_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Umwe musikira vyanukwambireni kuwa nukuka, ikisa nukuja kwenu umwe. Munanipenda, nanga muwa radi pakulu, konta nankuka ka Baba, kamana iye bora pakulu kanizaidi omi. ");
INSERT INTO wmw_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Epa sambi, nukwambirani evi savinamba kukuna, ipate vikija vikikuna, muje mukubali. ");
INSERT INTO wmw_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Wala sisowere namwe tena vinu vingi, konta mwenyé kutawala ulumwengu‑wu kankuja. Iye aana uwezo mmojawapo julu yangu, ");
INSERT INTO wmw_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","fala nitenda kamba vyanamurire Baba, ipate wanu wa mulumwengu‑mu wejiwe kuwa omi nimpenda Baba. Basi epa lamukani, tuke vyetu.” ");
INSERT INTO wmw_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Insa kaamba: “Omi niwa nzabibu wakweli, na Baba wangu ndi nrimi. ");
INSERT INTO wmw_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Piya vitambi vyangu savípa, iye alavya. Piya vitambi vyakupa, iye asinja vyakumiliya ipate vizidi kuupa sana. ");
INSERT INTO wmw_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Epa sambi, umwe muwa swafi, kwa sababu ya usemi wanukwambireni. ");
INSERT INTO wmw_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Lunganani nami, na omi nilungane namwe. Kamba kitambi vyacitowa kupa wanyewe sacilungane na muti, na umwe ndi novyo. Ikiwa amulungane nomi, amupa. ");
INSERT INTO wmw_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Omi ndi nzabibu, umwe muwa vitambi. Ire alungána nami na omi nilungana naye, munu‑yo akupa visumo vingi, kamana bila omi amukidiri kutenda kinu. ");
INSERT INTO wmw_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ikiwa munu aalungane nami, iye akwefiwa kunundu kamba kitambi, akumiliya. Ikisa vitambi vikusanyiwa, vikwefiwa pamoto, vilungula. ");
INSERT INTO wmw_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Umwe mukikala nkati yangu na mukitula usemi wangu, mulebela camusaka conse, cikukuna noco. ");
INSERT INTO wmw_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Kwa namuna‑yi Baba wangu atukuziwa, julu ya umwe visumo vingi vipa. Kwa javyo, mukwakikisha kuwa mukuwa wanafunzi wangu. ");
INSERT INTO wmw_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Kamba vyaanitendire Baba wangu, na omi ndi vyanukupendireni novyo. Ikalani na pendo rangu. ");
INSERT INTO wmw_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Mukifulata ámuri zangu, mukwikala nkati ya pendo rangu, kamba omi vyanifulata ámuri za Baba wangu, nikikala nkati ya pendo rake. ");
INSERT INTO wmw_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Evi vinu‑vi nukwambirani ipate radi yangu iwe nkati yenu, na radi yenu‑yo itimu nfululu. ");
INSERT INTO wmw_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Eyi ndi ámuri yangu: mupendane munu na mwenziwe kamba vyanukupendireni. ");
INSERT INTO wmw_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Aapo munu wakuwa nawo pendo pakulu koliko wakupereka mainsha ake kwa ajili ya marafiki zake. ");
INSERT INTO wmw_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Umwe mukitenda vyanukwamuruni omi, mukuwa marafiki zangu. ");
INSERT INTO wmw_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Sukwitani tena watumisi, konta ntumisi ejiwa caatenda mwenye wake. Ila, nukwitani marafiki zangu, kamana piya vyaanambira Baba wangu, nomwe nukwambirani. ");
INSERT INTO wmw_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Umwe amunitondore omi, ila omi ndi nukutondoreni umwe. Nukuperekani muke muwe kamba vitambi vyakupa visumo, na visumo vyenu vikare daima, ipate camunlebela Baba conse, kwa zina rangu, iye akupeni. ");
INSERT INTO wmw_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Eci ndi canukwamuruni: mupendane munu na mwenziwe.” ");
INSERT INTO wmw_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Wanu wa mulumwengu wakukwinani, ijiwani kuwa wanza kunina omi. ");
INSERT INTO wmw_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Munawa wa mulumwengu‑mu, wanu wa mulumwengu‑mu nanga wakupendani kamba wenziwawo. Fala kwa kuwa amuri wa mulumwengu‑mu ila nukutondolani mulumwengu, ndimana wakwinani. ");
INSERT INTO wmw_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Kumbukirani vyanukwambireni: aapo ntumisi anta mmoja bora koliko mwenye wake. Ikiwa wankunilumbata omi, nomwe novyo wakulumbatani. Ikiwa wafulata vyanifunda omi, wafulata novyo vyamufunda umwe. ");
INSERT INTO wmw_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Evyo vitendo-vyo ewo wakutendani kwa ajili ya zina rangu, konta awamwijiwa anipereke omi. ");
INSERT INTO wmw_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Inawa sijire nikiwambira, awangari kuwa na dambi. Fala sambi ewo awana namuna yakujibu kuhusu dambi zawo. ");
INSERT INTO wmw_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Anína omi onse, na Baba wangu amwina novyo. ");
INSERT INTO wmw_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ikiwa mbere yawo sitendire vinu vyakutajabisa vyakuwa tangu anátenda munu mwengine, ewo awangari kuwa na dambi. Fala sambi‑pa ewo wawona vyanitendire, novyo-sivyo wanina omi pamoja na Baba wangu. ");
INSERT INTO wmw_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Falakini evi vikijuzi vikune ipate vitimiziwe vyaândikiwe nkati ya shariya yawo javi: ‘Waniwinda bila sababu.’ ");
INSERT INTO wmw_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Fala paasaka kuja kwenu Mmashauri, wanisaka kukuperekerani kulawa ka Baba, Roho ya ukweli kulawa ka Baba, iye akuja kulavya ushahidi kuhusu caniri omi. ");
INSERT INTO wmw_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Nomwe novyo, lavyani ushahidi konta múkiwa nomi tangu mwanzo.” ");
INSERT INTO wmw_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Omi piya‑vi nukwambirani ipate musije kunitipuka. ");
INSERT INTO wmw_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Umwe mukuja kutuwisiwa mmasinagoga. Kwa ukweli, ukuja kufika wakati wakuwa mwenyé kukuulayani adanizira kuwa kankuntumika Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Wakuja kutenda javyo konta awamwijiwe Baba wala omi awanijiwa. ");
INSERT INTO wmw_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Fala omi nukwambirani piya‑vi ipate wakanza kulawirira, mukumbukire kuwa ndi noci cákitambiranga.” Insa akizidi kusema, akamba: “Umwe pamwanzire kunifulata, vinu‑vi sukwambireni konta omi níkiwa nomwe. ");
INSERT INTO wmw_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Fala epa sambi nankuka ka ire anipéreke omi. Kati yenu aapo anta mmoja‑pa wakunidairi: ‘Kwankuka ndepi?’ ");
INSERT INTO wmw_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Fala kwa kuwa nukwambirani javi, myoyo yenu ijala uzuni. ");
INSERT INTO wmw_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Novyo-sivyo nukwambirani kweli, vyema kwenu umwe nilawe. Kamana, ikiwa sukire, Wakukusaidiyani aakwisukirani. Ila omi nukuka vyangu, iye nukuperekerani. ");
INSERT INTO wmw_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Iye paasaka kwisuka, akuja kuwakubalisa wanu wa mulumwengu kuhusu ukweli wa mambo a dambi, na a shariya, na a hukumu: ");
INSERT INTO wmw_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","kuhusu dambi konta awanikubali omi; ");
INSERT INTO wmw_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","kuhusu shariya konta omi nukuka ka Baba, umwe amuniwona tena; ");
INSERT INTO wmw_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","na kuhusu kuhukumu konta ataware mulumwengu‑mu, iye kesa kuhukumiwa futi. ");
INSERT INTO wmw_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Nanawo tena vingi vyakukwambirani, fala kwa sambi‑pa amuhitamili kusikiriza. ");
INSERT INTO wmw_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ila Roho wa ukweli paasaka kwisuka, iye akuja kukulongozani mwereriwe ukweli piya. Iye aaja kusowera kwa mamulaka ake mwanyewe, ila vyaaja kusikira, akuja kusowera, na kukwerezani vinu víja kukuna. ");
INSERT INTO wmw_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Iye omi akuja kunitukuza, kamana akuja kupokerera cangu omi, akukwerezani umwe. ");
INSERT INTO wmw_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Piya vyaári nawo Baba, vyangu omi. Ndimana namba kuwa Roho Takatifu akuja kupokerera cangu omi, akukwerezani umwe.” ");
INSERT INTO wmw_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Ikisa Insa akamba: “Kwa muda ntoto javi, amuniwona tena. Ikisa kwa muda ntoto, muniwona tena.” ");
INSERT INTO wmw_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Wanafunzi wake wengine wakanza kudairiyana watupu: “Noci catambira‑ci kinani? ‘Kwa muda ntoto amuniwona, ikisa kwa muda ntoto, muniwona tena’ na ‘Kwa kuwa nankuka ka Baba’, mana ake kinani?” ");
INSERT INTO wmw_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Kwa javyo, wakamba: “Pambire ‘muda ntoto’ mana ake kinani? Atijiwa caamba!” ");
INSERT INTO wmw_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Insa kejiwa kuwa ewo wasaka wandairi, ndimana akiwambira: “Umwe mwankudairiyana watupu konta namba: ‘Kwa muda ntoto amuniwona, ikisa kwa muda ntoto muniwona tena.’ Sinovyo? ");
INSERT INTO wmw_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nukwambirani kweli, mukuja kurira na kurishuku, fala wanu mulumwengu‑mu wakuwa radi. Umwe muuzunika, fala kuuzunika kwenu kukuja kuwa radi yenu. ");
INSERT INTO wmw_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Mwanamuka akiwa kulupenu auzunika konta ufíka wakati wake wakutabika. Fala akimpongola mwanawe, aakumbukira tena tabu zakunire zire. Akuwa radi, kwa sababu kampongola mwana mulumwengu‑mu. ");
INSERT INTO wmw_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ndi kamba umwe novyo: epa sambi muwa nawo uzuni, fala nukuja kukuwonani tena, na mukuja kuwa radi pakulu mmyoyo mwenu. Noyo radi‑yo, aakidiri munu kukulavyani. ");
INSERT INTO wmw_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Noyo suku‑yo, aisakikana kunidairi kinu. Omi nukwambirani kweli kuwa piya vyamunlebela Baba kwa zina rangu, iye akupani. ");
INSERT INTO wmw_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Mpaka sambi‑pa, amunamba kunlebela anta kinu kwa zina rangu. Lebelani mupata, ipate radi yenu itimu nfululu. ");
INSERT INTO wmw_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Omi evi vinu‑vi nukwambirani kwa mifano. Kwa suku karibu, nukwasa kukwambirani namuna‑yo, ila nukwambirani baina kuhusu Baba. ");
INSERT INTO wmw_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Noyo suku‑yo, mukuja kunlebela kwa zina rangu. Sukwambirani kuwa nisaka kukulebelelani ka Baba kwa fadili yenu, ");
INSERT INTO wmw_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","kamana Baba mwanyewe akupendani, kwa kuwa munipenda na mukubali kuwa omi nilawa ka Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Omi nilawa ka Baba, nija mulumwengu‑mu. Sambi‑pa, nukwasa ulumwengu‑wu, niludira ka Baba.” ");
INSERT INTO wmw_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Wanafunzi wake wakimwambira: “Epa sambi kwankutambira baina, aúri kutambira kwa mifano. ");
INSERT INTO wmw_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Sambi tukwijiwa kuwa vinu piya ukwijiwa, aunsakula munu kukudairi kinu. Kwa javyo, ofwe tukwamini kuwa uwe kulawa ka Mwenyezimungu.” ");
INSERT INTO wmw_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Insa akiwajibu: “Epa sambi mwankwamini? ");
INSERT INTO wmw_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Sikirizani! Ikuja kufika suku, na epa ifika futi, piya-mwe mukuja kutawanyiwa, kila mmoja kwake-kwake, munasa yeka yangu. Fala omi siri yeka, konta Baba kawa pamoja nami. ");
INSERT INTO wmw_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Evi vinu‑vi nukwambirani ipate, kwa kuwa mulungana nomi, muwe na salama. Mulumwengu‑mu muwa nawo mashaka, fala rimbisani myoyo yenu. Omi nishinda mulumwengu‑mu!” ");
INSERT INTO wmw_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Insa, pesire kusowera javire, akinang'aniza julu, akamba: “Baba, ufika wakati. Olota utukufu wa Mwanawo ipate Mwanawo akutukuze uwe, ");
INSERT INTO wmw_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","kwa kuwa kungabizi iye mamulaka julu ya wanu piya, awape mainsha a milele kwa ware piya waungabizire. ");
INSERT INTO wmw_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Mainsha a milele ndi‑ya javi: wakwijiwe uwe, Nlungu mmoja tu basi wa ukweli, na wamwijiwe ire waumpéreke, Insa Almasihi. ");
INSERT INTO wmw_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Omi nukutukuza mulumwengu‑mu, nitimiza kazi zaunamurire kutenda. ");
INSERT INTO wmw_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Basi Baba, pauri nopo, nitukuze na utukufu wanîwere nawo pamoja nawe kábula ya kumba duniya.” ");
INSERT INTO wmw_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Insa kazidi kutenda duwa, akamba: “Wanu wa mulumwengu‑mu waunigabizire omi, niwolotera kweli-kwelini uwe cauri. Ewo wákiwa wako, ukinigabizi omi, na ewo wankufulata usemi wako. ");
INSERT INTO wmw_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Epa sambi ewo wakwijiwa kuwa piya vyaunipere vilawa mmakono mwako. ");
INSERT INTO wmw_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Kamana habari zaunambire omi, niwambira, newo wapokerera. Ewo walawirira kwijiwa kwa ukweli kuwa nilawa kwako, wakubali kuwa uwe ndi unipereke omi. ");
INSERT INTO wmw_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Omi niwalebelela duwa ewo. Siwalebelela wanu wengine mulumwengu‑mu, ila ware waunigabizire konta ewo ndi wako. ");
INSERT INTO wmw_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Vyangu omi piya, vyako uwe, na vyako, vyangu omi. Ndimana nitukuziwa julu yawo. ");
INSERT INTO wmw_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Omi siri wa mulumwengu ila ewo wawa mulumwengu‑mu, omi nankuja kwako uwe. Baba ntakatifu, wasunge kwa zina rako waunipere omi‑wa, ipate wawe na niya mmoja, kamba ofwe vyatíri na niya mmoja. ");
INSERT INTO wmw_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Paníkiwa pamoja newo, omi ewo nikiwasunga kwa zina rako raunipere omi. Omi niwasunga, na anta mmoja aapoteye saíri ire ândikiriwe kupoteya. Evi vikuna ipate vitimu vyaândikiwe mMandiko Matakatifu. ");
INSERT INTO wmw_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Fala sambi, nankuja kwako uwe. Paniri mulumwengu‑mu, niwambira javi ipate radi ya níri nawo ewo itimu nfululu. ");
INSERT INTO wmw_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Omi niwereza wanafunzi wangu usemi wako. Wanu wa mulumwengu wawena, konta wanafunzi‑wo siwo wa mulumwengu‑mu kamba omi novyo vyanitowire kuwa wa mulumwengu‑mu. ");
INSERT INTO wmw_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Omi sukulebela kuwa ewo uwalavye mulumwengu‑mu, fala nukulebela uwakengere mmakono mwa Mbaya. ");
INSERT INTO wmw_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ewo siwo wa mulumwengu, kamba omi novyo vyanitowire kuwa wa mulumwengu‑mu. ");
INSERT INTO wmw_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Julu ya ukweli wa usemi wako, uwatenze utakatifu kukutumika. ");
INSERT INTO wmw_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Kamba uwe vyaunipereke omi mulumwengu, nomi ndi vyaniwapereke mulumwengu. ");
INSERT INTO wmw_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Kwa faida yawo, omi nirigabizi mmakono mwako kukutumika, ipate newo novyo warigabizi mmakono mwako kukutumika, julu ya ukweli.” ");
INSERT INTO wmw_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Insa akizidi kutenda duwa, akamba: “Omi siwalebelela duwa ewo‑po tu basi, fala niwalebelela novyo ware wája kunamini kwa sababu ya usemi wawo. ");
INSERT INTO wmw_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Niwalebelela ipate piya wawe nawo umoja, kamba uwe Baba vyaulungane nomi, na omi vyanilungane nawe, newo novyo walungane nofwe ipate wanu wa mulumwengu‑mu wakubali kuwa uwe ndi unipereke. ");
INSERT INTO wmw_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Utukufu waunipere omi ndi utukufu waniwapere ewo, ipate wawe na umoja kamba ofwe vyatíri na umoja, ");
INSERT INTO wmw_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","omi nilungana nawo na uwe kulungana nami. Niwalebelela javyo ipate ewo wawe na umoja nfululu munu na mwenziwe, wanu wa mulumwengu‑mu wejiwe kuwa uwe ndi unipereke, na wejiwe kuwa uwapenda wafulati wangu kamba vyaunipenda omi. ");
INSERT INTO wmw_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Baba, ware waunigabizire omi, nisaka mahala paniwa omi, newo wawe nopo pamoja nomi, wawone utukufu wangu waunigabizire, konta uwe kunipenda saunomba duniya. ");
INSERT INTO wmw_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Baba mwenyé shariya, ingawa wanu mulumwengu‑mu awakwijiwa, fala omi nukwijiwa, na ewo wakwijiwa kuwa uwe ndi unipereke. ");
INSERT INTO wmw_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Omi nîwejiwisa zina rako na nizidi kuwejiwisa, ipate pendo raunipendire omi riwe nkati yawo, na omi niwe nkati yawo.” ");
INSERT INTO wmw_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Bandi yakusowera javire, Insa akilawa pamoja na wanafunzi wake, akiloka nrati wa Kedorini, akuka ng'ambu nyengine kaíkiwapo bushtani. Insa na wanafunzi wake wakingira nomure. ");
INSERT INTO wmw_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Sambi Yuda, airini ajire akinzungunuka akimpereka Insa, akijiwa mahala pare, konta Insa na wanafunzi wake wákijumananga nopare. ");
INSERT INTO wmw_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Kwa javyo, Yuda akilongoza kipinga kimoja ca masurudadu pamoja na minduna waperékiwe na wakulungwa wa dini na Mafarizeu, akuka pabushtani nopare. Ewo wakisukula myenge na kandiyeru pamoja na sulaha. ");
INSERT INTO wmw_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Insa, kwa kuwa akijiwa piya visaka kukuna, wanjirire ware akilawa akiwadairi: “Mwankusakula nani?” ");
INSERT INTO wmw_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ewo wakinjibu: “Insa nNazareti.” Insa akiwambira: “Ndumi.” Sambi Yuda, airini ajire akinzungunuka Insa, ákiwapo nopare. ");
INSERT INTO wmw_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Paawámbire “Ndumi”, ewo waludira kinyumanyuma, wakigwa pansi pi‑pi‑pi. ");
INSERT INTO wmw_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Kwa javyo, Insa akiwadairi tena upya: “Mwankunsakula nani?” Ewo wakamba: “Insa nNazareti.” ");
INSERT INTO wmw_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Insa akijibu: “Omi nukwambirani kuwa ndumi. Ikiwa mwankunisakula omi, ewa waseni woke vyawo.” ");
INSERT INTO wmw_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Insa kasowera javire ipate utimiziwe usemi wasowere iye akamba: “Wanu waunipere kuwasunga‑wa awanamba kunipoteya anta mmoja.” ");
INSERT INTO wmw_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ansumani Peduru ákiwa nawo upanga, akisolola, akinduru ntumisi wa nkulu wa wakulungwa wa dini, kansinja sikiro ra nkono nriro. (Noyo ntumisi‑yo zina rake akitiwa Malukuzi.) ");
INSERT INTO wmw_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Basi Insa akimwambira Peduru: “Upanga wako‑wo tula paúkiwa! Udaniza kuwa omi síri tayari kutabika nipate kutimiza vyaasaka Baba wangu?” ");
INSERT INTO wmw_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ikisa masurudadu na nkulungwa wawo pamoja na minduna waperékiwe na Mayahudi ware wakinkola Insa, wakinfunga. ");
INSERT INTO wmw_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Kwanza wakinlongoza mpaka ka Anasi nkwewe Kayafa. Nowo mwaka‑wo Kayafa ndi awere nkulu wa wakulungwa wa dini. ");
INSERT INTO wmw_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayafa‑yo ndi ânzire kuwambira wakulungwa wa Mayahudi kuwa: “Vyema kufwa munu mmoja kwa faida ya wanu wengi.” ");
INSERT INTO wmw_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ansumani Peduru akinfulata Insa. Mwanafunzi mwengine akinfulata novyo. Kwa kuwa mwanafunzi ire akijiwiwa na nkulu wa wakulungwa wa dini, iye akingira pamoja na Insa mpaka paluwanja ra nyumba ya nkulu wa wakulungwa wa dini ire. ");
INSERT INTO wmw_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Fala Peduru kabaki panja, karibu ya nryango. Kwa javyo, mwanafunzi mwengine akijiwiwa na nkulu wa wakulungwa wa dini ire akuka akisowera na mwari amiri wa panryango, akimpitisa Peduru. ");
INSERT INTO wmw_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Mwari ire panryango pare akindairi Peduru: “Uwe novyo aúri mwanafunzi wa eyu mwananlume‑yu?” Iye akamba: “Iii, siíri!” ");
INSERT INTO wmw_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Wakati‑wo ikizizima baridi pakulu futi, ndimana watumisi ware pamoja na minduna wâwesa moto wakizunguriza kota wemire. Basi, Peduru neye novyo ákiwapo nopare kemira pamoja newo akota moto. ");
INSERT INTO wmw_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Wakati mmoja nowo, nkulu wa wakulungwa wa dini akindairi Insa kuhusu wanafunzi wake na kuhusu kufunda kwake. ");
INSERT INTO wmw_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Insa akinjibu: “Omi níkiwambiranga bila kuwafisa wanu wa ulumwengu‑wu. Daima‑zi níkiwafundanga mmasinagoga pamoja na nNyumba Takatifu mwawakijumana Mayahudi piya. Anta suku moja sisowere kinu ca siiri. ");
INSERT INTO wmw_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Basi, munidairi sababuni? Wadairini wanu wânisikire, ewo ndi wejiwa canambire.” ");
INSERT INTO wmw_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Insa pesire kwamba javire, nduna ákiwa karibu naye akimwibiya kuno akamba: “Arri! Uwe unjibu javyo nkulu wa wakulungwa wa dini?” ");
INSERT INTO wmw_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Insa akinjibu: “Ikiwa nisowera caputu, lavya ushahidi wa kinu canisowere caputu. Fala ikiwa nisowera sana, kunibiya sababuni?” ");
INSERT INTO wmw_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Basi, Anasi akamuru kuwa Insa afungiwe makono novire, aperekiwe ka Kayafa nkulu wa wakulungwa wa dini ire. ");
INSERT INTO wmw_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Basi sambi, Ansumani Peduru pakota moto pare, wanu wengine wakindairi: “Uwe kuwa kundi ra wanafunzi wake, aúri?” Iye akikana, akamba: “Omi siíri!” ");
INSERT INTO wmw_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ntumisi mmoja wa nkulu wa walongozi wa dini ákiwa nopare. Iye ákiwa jamaa wa mwananlume âsinjiwe sikiro na Peduru ire. Iye akimwambira Peduru, akamba: “Omi nukuwona úri na Insa kubushtani, sinowe?” ");
INSERT INTO wmw_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Basi, mara nyengine tena, Peduru akikana. Kwa mpunde noure, galu akiwika. ");
INSERT INTO wmw_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Pakucere subuu namapema, wakintwala Insa nnyumba mwa Kayafa, wakuka naye kunyumba ya kifalume yaákikalanga guvinadoru. Fala awengire nnyumba mure konta awakisaka kuringiza haramu, kwa kuwa wakisaka kurya cakurya ca sherehe ya Pashukwa. ");
INSERT INTO wmw_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ndimana, Pilatu akilawira panja, akamba: “Kinu kibaya camummwene akitenda eyu mwananlume‑yu ndi cepi?” ");
INSERT INTO wmw_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ewo wakinjibu, wakimwambira javi: “Inawa eyu aatendire kitendo kibaya, ofwe atingari kuja naye kwako.” ");
INSERT INTO wmw_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilatu akiwajibu: “Basi, ntwareni umwe‑po, munlamure kamba vyaisaka shariya yenu.” Mayahudi wakinjibu: “Ofwe atina mamulaka a kumulaya munu.” ");
INSERT INTO wmw_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Evi vikuna ipate vitimiziwe vyaasemire Insa kuhusu namuna vyaaja kufwa. ");
INSERT INTO wmw_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Sambi, Pilatu akingira tena nnyumba ya kifalume ire, akimwita Insa, akindairi: “Uwe kuwa nfalume wa Mayahudi?” ");
INSERT INTO wmw_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Insa akijibu: “Vyaunidairi‑vi uwe ndi úri kuwaza, au wawapo wakwambire kinu kimojawapo kuhusu omi?” ");
INSERT INTO wmw_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilatu akijibu: “Udaniza kuwa omi niwa Yahudi? Wanigabízire mmakono mwangu uwe‑po ndi wanu wako nowo pamoja na wakulungwa wa dini. Uwe kukosa kinani?” ");
INSERT INTO wmw_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Insa akamba: “Ufalume wangu siwo wa ewu ulumwengu‑wu. Inawa ufalume wangu wa ewu ulumwengu‑wu, watumisi wangu nanga watenda vita, wasinipereke mmakono mwa Mayahudi. Fala ufalume wangu siwo wa ulumwengu-wu‑pa.” ");
INSERT INTO wmw_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ikisa Pilatu akindairi: “Sambi, epa kuwa nfalume?” Insa akijibu: “Uwe ndi úri kwamba kuwa niwa nfalume. Omi nipongoriwa na nija mulumwengu‑mu ipate nilavye ushahidi kuhusu ukweli. Piya wenye ukweli wasikiriza canamba omi.” ");
INSERT INTO wmw_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilatu akindairi: “Ukweli kinani?” Pilatu, nakwisa kwamba javire, akilawira panja tena upya, akuka ka Mayahudi, akiwambira: “Eyu simonerera anta kosa rimojawapo. ");
INSERT INTO wmw_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Fala kwa tabiya yenu ndi kuwa, wakati wa Pashukwa, ninfungulanga nfungwa mmoja. Sambi, musaka nukufungurireni nfalume wa Mayahudi?” ");
INSERT INTO wmw_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Wakikola kunyangula tena, wakamba: “Iii, usitifungurire iye! Nfungure Baraba!” Ona, Baraba‑yo ákiwa kisomi. ");
INSERT INTO wmw_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ikisa Pilatu akintwala Insa, akamuru acapiwe viboko. ");
INSERT INTO wmw_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Masurudadu wakitwala mpombwe, wakitenda kamba lemba, wakinvaza nkiswa. Wakinvaza novyo kapa ra rangi ra njambalãu. ");
INSERT INTO wmw_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Wakinjira wakunshupa javi: “Mashikamu, nfalume wa Mayahudi!” Wakikola kumwefya malatuma. ");
INSERT INTO wmw_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Mara nyengine tena, Pilatu akilawira panja, akiwambira Mayahudi: “Sikirizani, omi nukuja naye epa mbere yenu, ipate mwijiwe kuwa simmonire kuwa na kosa rimojawapo.” ");
INSERT INTO wmw_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Kwa javyo, Insa wakija naye panja pare, avaziwe lemba ra miwa na kapa ra rangi ya njambalãu rire. Pilatu akiwambira: “Mwananlume‑yo ndiyu!” ");
INSERT INTO wmw_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Wakulungwa wa dini pamoja na minduna nakummona, wakanza kuntambira kuno wakamba: “Ngomezereni! Ngomezereni!” Pilatu akiwajibu: “Ntwareni umwe‑po, mungomezere. Simmonire kuwa na kosa rimojawapo.” ");
INSERT INTO wmw_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Mayahudi wakinjibu wakamba: “Tanawo shariya, na noyo shariya‑yo isema kuwa iye ajuzi aulaiwe, konta aritula kuwa Mwana wa Mwenyezimungu.” ");
INSERT INTO wmw_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilatu nakusikira usowezi ure, ukimwingira wofi pakulu. ");
INSERT INTO wmw_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Iye akingira tena nnyumba ya kifalume, akindairi Insa: “Uwe kwenu ndepi?” Fala Insa aanjibire kinu. ");
INSERT INTO wmw_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ndimana Pilatu akimwambira: “Ukatala kusowera nami? Awijiwa kuwa omi nanawo mamulaka a kukufungula, na nanawo mamulaka a kukugomezera pansalaba?” ");
INSERT INTO wmw_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Insa akijibu: “Uwe aungari kuwa nawo mamulaka julu yangu omi sawisusiriwe na Mwenyezimungu. Ndimana anigabizire mmakono mwako ndi akorire dambi pakulu.” ");
INSERT INTO wmw_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Mwanzo wa noure wakati ure, Pilatu akisakula namuna yakunfungula, fala Mayahudi wakizidi kuntambira: “Uwe ukinfungula eyo mwananlume‑yo, auwa rafiki wa Kaisari. Kila munu aritula kuwa nfalume abishana na Kaisari.” ");
INSERT INTO wmw_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Kwa javyo, Pilatu paasikire javire, akinlavira panja Insa ire, akikala kiti ca nfalume wakulamula shariya, mahala pakujengiwa sana-sana na mawe pakwitiwa “Pansi pajengiwe na Mawe”. (Kwa luga ya kiebraniya, mahala pare pakwitiwa “Gabata”.) ");
INSERT INTO wmw_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ikituwirira kiyasi ca aduhuri, suku wanu yawakiritengeza subuu yake wapitise Pashukwa. Pilatu akiwambira Mayahudi: “Mmoneni nfalume wenu‑yu!” ");
INSERT INTO wmw_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ewo wakikuwa: “Nlavyeni‑po! Nlavyeni‑po! Ngomezereni!” Pilatu akiwadairi: “Musaka ningomezere nfalume wenu‑yu?” Wakulungwa wa dini wakijibu: “Atina nfalume mwengine tena, nfalume wetu Kaisari tu basi!” ");
INSERT INTO wmw_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Basi, Pilatu akiwagabizi Insa mmakono mwawo wakangomezere wanyewe. Kwa javyo, ewo wakintwala Insa ire. ");
INSERT INTO wmw_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Iye asukure mwanyewe nsalaba wake, akilawa akuka mahala pakwitiwa “Kongolo ra kiswa” (kwa luga ya kiebraniya pakwitiwa “Gologota”.) ");
INSERT INTO wmw_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ndi mahala pawangomezere nopo. Wawagomezera novyo wanu wawiri: mmoja kuno, mmoja kuno, Insa wakintula kati. ");
INSERT INTO wmw_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilatu akitumiza kutengeziwa kibawo cakwandikiwa cikigomezeriwa pansalaba pare julu, kibawo‑co candikiwa javi: “INSA NNAZARETI, NFALUME WA MAYAHUDI.” ");
INSERT INTO wmw_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Mayahudi wengi wawenye wafyoma kibawo caandikiwe‑co, kamana paagomezeriwe Insa pákiwa karibu ya kaya. Noco kibawo‑co caandikiwa luga za kiaramaiku, kiroma, pamoja na kigeregu. ");
INSERT INTO wmw_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Wakulungwa wa dini wa Mayahudi wakimwambira Pilatu: “Usandike ‘Nfalume wa Mayahudi’, ila andika kuwa mwananlume‑yu akisema javi: ‘Omi niwa nfalume wa Mayahudi’. ” ");
INSERT INTO wmw_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilatu akijibu: “Canandike noco, nandika.” ");
INSERT INTO wmw_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Masurudadu ware, pawangomezere Insa pansalaba, wakitwala nguwo zake, wakawanyirana mafungu mane, fungu rimoja kila surudadu. Na anzu yake wakitongana novyo. Fala kwa kuwa anzu‑yo íkiwa nkuto wawenye saisoniwe, ");
INSERT INTO wmw_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","ewo wakambirana watupu: “Tisipapure. Tukeni titende kura, tiwone waisaka kungwirira.” Evi vikuna ipate atimu Mandiko asema javi: “Nguwo yangu wawanyirana watuputupu, anzu yangu watendera kura.” Javyo, masurudadu ware ndi vyawakunishe. ");
INSERT INTO wmw_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Karibu ya nsalaba paagomezeriwe Insa pare, ákiwapo mamaye Insa, nduye mamaye, Mariyamu muka wa Keleopa, pamoja na Mariyamu wa Magadala. ");
INSERT INTO wmw_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Insa, paawawónire mamaye na mwanafunzi waakimpenda pakulu wari karibu naye, akimwambira mamaye ire javi: “Mama, sambi mwanawo ndiyo.” ");
INSERT INTO wmw_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ikisa akimwambira mwanafunzi ire: “Ona, sambi mamayo ndiyo.” Mwanzo wa noure wakati ure, mwanafunzi ire akimpokerera kunyumba yake. ");
INSERT INTO wmw_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Bandi ya evyo, Insa, kwa kwijiwa kuwa piya vyaakijuzi kutenda vitimiziwa, akamba javi: “Inikola nyotwa!” (Piya vikuna ipate atimiziwe Mandiko Matakatifu.) ");
INSERT INTO wmw_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Noparepare íturiwa numba yakwijala ya vinyu yakusanganyiwa na maji. Basi wakitwala shiponja, wakilovya nvinyu mure, wakisomeka mmuti wakwitiwa isopo, wakintula kukanywa. ");
INSERT INTO wmw_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Basi, paapokerere vinagiri ire, Insa akamba: “Piya nitimiza!” Ikisa akinamisa kiswa, akipereka roho yake. ");
INSERT INTO wmw_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Noyo suku‑yo íkiwa suku yakuritengeza kwa suku takatifu ya sabadu. Wakulungwa wa Mayahudi avikiwajibu maiti are kwikala pansalaba nopare mpaka sabadu, kwa kuwa sabadu‑yo íkiwa suku ulu. Ndimana, wakinlebela Pilatu awamuru wawavunje maulu wanu wâgomezeriwe pansalaba ware, wawalavye pare. ");
INSERT INTO wmw_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Basi, masurudadu wakuka wakinvunja maulu munu wakwanza ire, ikisa wakintenda novire mwengine ire, ware wâgomezeriwe na Insa ware. ");
INSERT INTO wmw_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Fala pawanfikire Insa, wammona kuwa iye kafwa futi, ndimana awanvunjire maulu. ");
INSERT INTO wmw_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Kwasa javire, surudadu mmoja na nkuki wake, akinsoma Insa mumbavu. Kwa mpunde noure, akanza kulawa damu na maji. ");
INSERT INTO wmw_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Áwonire onse kâlavya ushahidi, na ushahidi waâlavire uwa wakweli. Iye akwijiwa kuwa kankusema kweli, ipate umwe mukubali. ");
INSERT INTO wmw_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Kamana evi vinu‑vi vikuna ipate atimu Mandiko Matakatifu vyaasema kuwa: “Kongolo rake anta rimoja arija kuvunjiwa.” ");
INSERT INTO wmw_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Na uwapo nsitari mwengine wa Mandiko Matakatifu ukwamba: “Wanu wakuja kunnang'aniza wawansomire‑yo.” ");
INSERT INTO wmw_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Bandi ya evi, Yusufu wa kaya ya Arimataya, kanlebela Pilatu alavye maiti a Insa. Yusufu ákinfulata Insa fala kisiiri-siiri, konta ákiwopa wakulungwa wa Mayahudi. Pilatu akimpa rihusa, ndimana Yusufu akija akilavya maiti a Insa are. ");
INSERT INTO wmw_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Sambi Nikodemu, ôkire mida kummona Insa usiku ire, neye novyo akija. Kasukula mafuta akunuwira a miti yakusanganyiwa, kiyasi ca kilu talatini. ");
INSERT INTO wmw_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Basi, ewa wanawalume wawiri‑wa watwala maiti a Insa are, wakikafini munkuto wa kafani ya linyu, wakisasanyira mafuta ya kunuwira are. Eyi ndi íkiwa tabiya ya Mayahudi yakutafiti maiti kábula ya kuzika. ");
INSERT INTO wmw_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Sambi, mahala paagomezeriwe Insa pare íkiwepo karibu bushtani. Mbushtani‑mo ríkiwapo kaburi ripya, ríkiwa saanazikiwa munu. ");
INSERT INTO wmw_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Basi, kwa kuwa íkiwa suku yakuritengeza Mayahudi kwa suku takatifu ya sabadu, na kwa kuwa kaburi rire ríkiwa karibu, maiti a Insa are wakitula nomure. ");
INSERT INTO wmw_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Suku ya mwanzo wa sumana, Jumapiri, Mariyamu wa Magadala akipwesera namapema kukaburi, kunja kwinukare pi. Nakufika, kasingana riwe ripiringisiriwa panja ya kaburi. ");
INSERT INTO wmw_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Kwa javyo, akipita akituwa mpaka ka Ansumani Peduru na mwanafunzi mwengine, ire ákipendiwanga pakulu na Insa ire, akiwambira: “Watwala maiti a Mwenye nkaburi mure, atijiwa pawaturire!” ");
INSERT INTO wmw_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ndimana Peduru pamoja na mwanafunzi mwengine ire wakilawa, wakuka kukaburi nokure. ");
INSERT INTO wmw_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Wo‑wawiri wakipita wakituwa pamoja, fala mwenziwe ire akituwa pakulu, akimpunda Peduru, ákiwa iye ntanzi kufika. ");
INSERT INTO wmw_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Nakufika kenama, kawona kafani nkati mure, wala engire. ");
INSERT INTO wmw_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ikisa Ansumani Peduru akinfulata nyuma yake ire. Nakufika akingira nkaburi mure, akiwona kafani ire pansi nopare, ");
INSERT INTO wmw_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","pamoja na lemba raâkongiwe Insa nkiswa. Lemba rire ariwere pamoja na kafani yaâkafiniwe ire, ríkiwa upande mwengine rakushokotiwa novire. ");
INSERT INTO wmw_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ikisa mwanafunzi mwengine ânzire kufika ire, neye novyo akingira nomure. Iye nakuwona, akamini. ");
INSERT INTO wmw_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Kwa nowo wakati‑wo, ewo wákiwa sawanamba kwereriwa Mandiko vyaamba kuwa iye ibidi afufuriwe ka wafwi. ");
INSERT INTO wmw_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ikisa, wanafunzi ware wakiludira ukaya. ");
INSERT INTO wmw_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Fala Mariyamu kemira panja ya kaburi, akirira. Kuno akirira, kazungunuka kanang'aniza nkaburi mure, ");
INSERT INTO wmw_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","kawawona malaika wawiri wekare. Ewo wavala mavazi melupa, wekala paâturiwe maiti pawenye nopo, mmoja kekala kukiswa, wapiri kumaulu. ");
INSERT INTO wmw_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ewo wakindairi: “Nunu, urirani?” Iye akijibu: “Watwala maiti a Mwenye wangu, sijiwa kawaturire.” ");
INSERT INTO wmw_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Bandi yakusowera javire, iye akizungunuka, kammona Insa emire, fala iye aammanyire. ");
INSERT INTO wmw_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Insa akindairi: “Nunu, urirani? Kwankunsakula nani?” Mariyamu akidaniza kuwa munu ire akikaza bushtani, ndimana akamba: “Mwenye, ikiwa ndi mutwarire maiti‑ya‑mu, nambireni pamuturire, omi nikatware.” ");
INSERT INTO wmw_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Insa akimwambira: “Mariyamu!” Mwanamuka ire akizungunuka, akimwambira nkiebraniya: “Raboni!” (Mana ake: “Mwanlimu”.) ");
INSERT INTO wmw_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Insa akimwambira: “Usinikumbure, kamana sinamba kukwera kuka ka Baba. Ila uka mpaka ka wanduzangu, ukawambire kuwa nikwera kuka ka Baba wangu, nomwe novyo Baba wenu, ka Nlungu wangu, nomwe novyo Nlungu wenu.” ");
INSERT INTO wmw_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Basi, Mariyamu wa Magadala akuka akiwereza wanafunzi ware akamba: “Umwe, nimmona Mwenye!” Na akiwereza vyaambiriwe vire. ");
INSERT INTO wmw_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Kwa noire suku ya Jumapiri ire lulemba, wanafunzi wajumulana. Warifungira miryango ti kamana wawopa wakulungwa wa Mayahudi. Kwa mpunde noure, Insa akingira akimira kati-kati yawo, akiwambira: “Salama iwe namwe!” ");
INSERT INTO wmw_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Bandi yakwamba javire, kawolotera mmakono na mumbavu. Ikisa wanafunzi ware wákiwa radi pakulu sana kwa kummona Mwenye. ");
INSERT INTO wmw_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Insa akiwambira tena: “Salama iwe namwe! Namuna mmoja noyo kamba Baba vyaanipereke, omi novyo nukuperekani umwe.” ");
INSERT INTO wmw_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Nakwisa kwamba javire, akiwawesezera akiwambira: “Mpokerereni Roho Takatifu. ");
INSERT INTO wmw_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Mukiwaswamii wanu dambi zawo, newo waswamiiwa. Mukitowa kuwaswamii, newo awaswamiiwa.” ");
INSERT INTO wmw_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tamimu (zina rake rengine wakwitiwa “Masa”) mwanafunzi mmoja nkati ya kumi na wawiri ware, iye âwerepo paâjire Insa. ");
INSERT INTO wmw_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Kwa javyo, wanafunzi wengine ware ndi wakimwambira: “Ofwe timmona Mwenye!” Fala iye akiwambira: “Kamba siwonire vilaso vya misumari mmakono mwake, na kamba sinkumbure javi na cala cangu mwâkigomezeriwa, na kamba simpamire mumbavu na makono angu, sishubutu kukubali.” ");
INSERT INTO wmw_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Airini bandi ya suku nane, wanafunzi wakijumulana tena nnyumba, na Tamimu ire ákiwapo munkonjo nomo. Miryango wâfungiriwa ti‑ti‑ti, fala Insa kengira, akimira kati-kati yawo, akamba: “Salama iwe namwe!” ");
INSERT INTO wmw_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ikisa akimwambira Tamimu: “Njo naco kuno cala cako‑co, uwone canja cangu. Nipame mumbavu‑mu na nkono wako. Asa kudanizira‑ko, kubali!” ");
INSERT INTO wmw_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tamimu akinjibu: “Mwenye wangu, Nlungu wangu!” ");
INSERT INTO wmw_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Insa akimwambira: “Uwe ukubali kwa kuwa kuniwona? Heri ka ware sawaniwona fala wangari kukubali.” ");
INSERT INTO wmw_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Kusema kweli, Insa akitendanga alama nyengine mbere ya wanafunzi sazandikiwe nkitabu‑mu, ");
INSERT INTO wmw_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","fala evi vyandikiwa ipate mukubali kuwa Insa ndi Almasihi, Mwana wa Mwenyezimungu. Na kwa kunkubali iye, mupata mainsha julu ya mamulaka a zina rake. ");
INSERT INTO wmw_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Bandi ya evi vinu‑vi, Insa kawalawirira tena upya wanafunzi wake lufuko ra Tanda ra Tiberiya. Vikuna javi: ");
INSERT INTO wmw_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Wekala pamoja Ansumani Peduru, Tamimu (wakwitiwa “Masa”), Nataniyeli wa Kanaa ya Galileya, wana wa Zebedeyu, pamoja na wanafunzi wengine wawiri. ");
INSERT INTO wmw_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ansumani Peduru akiwambira wenziwe ware: “Nankuka kuvuwa.” Ewo wakamba: “Ofwe tukufulata tikakwavye.” Wakilawa wakiripakira mungalawa wakuka. Wavuwa usiku nzima, awapatire kinu. ");
INSERT INTO wmw_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Pakucere subuu, Insa ákiwa nlufuko, fala wanafunzi ware awakimmanyira. ");
INSERT INTO wmw_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Insa akiwadairi: “Wanangu, amumpatire inswi anta mmoja?” Ewo wakijibu: “Iii, atipatire kinu.” ");
INSERT INTO wmw_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Iye akiwambira: “Tayani nyavu‑zo upande wa nkono nriro‑wo, mupata.” Basi, wakitenda novire, awakidirire kuvuta nyavu zire, konta zikoreka inswi nyingi futi. ");
INSERT INTO wmw_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Kwa javyo, mwanafunzi ákipendiwa pakulu na Insa ire akimwambira Peduru: “Ire Mwenye!” Ansumani Peduru paasikire kuwa ákiwa Mwenye, akivala nguwo zake sana-sana (konta kâvala nguwo za mwani), akirefya mbahari. ");
INSERT INTO wmw_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Wanafunzi wengine ware wakinfulata na ngalawa ire, wakipita wakivuta nyavu zire na inswi tapa-tapa, kamana awawere baidi na lufuko, wákiwa kiyasi ca pima miya. ");
INSERT INTO wmw_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Nakwisuka mungalawa mure, wasingana makala a moto na inswi pajulu. Íkiwapo novyo mikate. ");
INSERT INTO wmw_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Insa akiwambira: “Njoni nazo inswi aba zamuvuwire sambi-pa‑zo.” ");
INSERT INTO wmw_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Kwa javyo, Ansumani Peduru akingira mungalawa mure, akivutira nyavu zire kungulu. Zikoreka inswi ulu‑ulu, kwisabu piya zíkiwa inswi miya na amusini na natu. Ingawa zikoreka inswi nyingi, fala nyavu zire azipapuke. ");
INSERT INTO wmw_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Insa akiwambira: “Njoni murye.” Aalawirire anta mwanafunzi mmojawapo wakutwakali kundairi: “Uwe nani?” Wakijiwa kuwa ndi Mwenye wawenye. ");
INSERT INTO wmw_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Insa akija akitwala nkate ure, akiwapa. Na inswi zire novyo akiwapa. ");
INSERT INTO wmw_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Bandi ya kufufuriwa ka wafwi, Insa akiwalawirira mara ka mara wanafunzi wake, eyi ndi íwere mara yatatu. ");
INSERT INTO wmw_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Nakwisa kurya, Insa akindairi Ansumani Peduru: “Ansumani, mwana wa Yahaya, unipenda pakulu kuwapunda ewa piya‑wa?” Iye akijibu: “Aye, Mwenye, ukwijiwa kuwa omi uwe nukupenda.” Insa akimwambira: “Warise makondoo wangu watoto‑wa.” ");
INSERT INTO wmw_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Mara yapiri Insa akindairi: “Ansumani, mwana wa Yahaya, unipenda?” Iye akijibu: “Aye, Mwenye, ukwijiwa kuwa omi uwe nukupenda.” Insa akimwambira: “Wasunge makondoo wangu.” ");
INSERT INTO wmw_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Mara yatatu Insa akindairi: “Ansumani, mwana wa Yahaya, unipenda?” Peduru akikimiwa konta kândairi mara ya natu, “Unipenda?” Basi akinjibu: “Mwenye, uwe ukwijiwa piya vinu. Ukwijiwa kuwa omi uwe nukupenda.” Insa akimwambira: “Warise makondoo wangu. ");
INSERT INTO wmw_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nukwambira kweli: paukiwa nnemba, ukivala nguwo zako, ukuka kaukisaka konse. Fala pausaka kuluvala, ukolosa makono ako, munu mwengine akuvaza nguwo, akukisa kautowa kusaka.” ");
INSERT INTO wmw_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Insa kasowera javire ipate amwambire Peduru namuna vyaaja kufwa kuno akinsifu Mwenyezimungu.) Bandi yakusowera javire, iye akimwambira: “Nifulate!” ");
INSERT INTO wmw_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Peduru kazungunuka, kammona nyuma kure mwanafunzi mmoja akipendiwa pakulu na Insa. Eyu ndi ire mwanafunzi ârinamire upande wa mumbavu wa Insa pawekare piya wakirya, ádairire javi: “Mwenye, asaka kukuzungunuka ndi wepi?” ");
INSERT INTO wmw_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Peduru pammonire mwanafunzi ire, akindairi Insa: “Mwenye, sambi eyu mwananlume‑yu, cisaka kunkuna kinani?” ");
INSERT INTO wmw_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Insa akijibu: “Nikisaka kuwa ainshi mpaka niludi, uwe cukuyeri kinani? Uwe nifulate tu basi!” ");
INSERT INTO wmw_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Eya masowerero‑ya enera kati ya wanafunzi, ewo wereriwa kuwa mwanafunzi ire aafwa. Fala Insa aambire kuwa aafwa, ila kaamba: “Nikisaka iye ainshi mpaka niludi, uwe cukuyeri kinani?” ");
INSERT INTO wmw_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Eyu ndi mwanafunzi alavya ushahidi wa vinu‑vi, na ndi noyu andike evi vinu‑vi. Tukwijiwa kuwa ushahidi wake‑wo wakweli. ");
INSERT INTO wmw_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Na viwapo vinu vingi vyengine tena vyaatendire Insa. Inawa vinu-vyo vyandikiwa kimoja-kimoja, niwona kuwa duniya isiwepo ando yakutula vitabu vikisaka kwandikiwa-vyo.");
INSERT INTO wmw_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Mwenye Teyofilu, kwa kitabu cangu cakwanza canandike kuhusu Insa piya vyaanzire kutenda na kufunda, ");
INSERT INTO wmw_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","mpaka suku yaakweziwe mbinguni bandi ya kuwamuru mawalii wake wâwatondore, julu ya Roho Takatifu. ");
INSERT INTO wmw_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Bandi ya tabu zake, Insa ákirolotanga mbere yawo, julu ya kutenda vinu vingi vyawenye vyakuwakikisha kuwa iye kawa hai. Kawalawirira muda wa suku arubaini, na akisowera nawo kuhusu ufalume wa Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Paajumane nawo, kawalaizira javi: “Musilawe Yerusalemu, murindire tamaa ya Baba yamunisikire omi. ");
INSERT INTO wmw_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Kwa kuwa kweli Yahaya koza na maji, fala umwe suku karibu mukuja koziwa na Roho Takatifu.” ");
INSERT INTO wmw_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Sambi, ewo pawajumulane, wanza kundairi, wakamba: “Mwenye, nowo wakati‑wo ndi pausaka kuludisiriwa ufalume Iziraeli?” ");
INSERT INTO wmw_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Iye akiwajibu: “Visukuyerini kwijiwa suku wala wakati waaturire Baba nkati ya mamulaka ake mwanyewe. ");
INSERT INTO wmw_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Fala paasaka kukwingirani Roho Takatifu, mupewa uwezo na mukuwa mashahidi wangu, mwanzo wa Yerusalemu na Yudeya piya pamoja na Samariya na mpaka kaisirize duniya.” ");
INSERT INTO wmw_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Pesire kwamba javire, akikweziwa wakinang'aniza javi, na wingu rikinfinika. ");
INSERT INTO wmw_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Pawakinang'aniza julu rungu-rungu novire wakimmona iye akikweziwa, mpunde noure walawirira wanu wawiri na mavazi melupa vú, ");
INSERT INTO wmw_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","wakiwadairi: “Umwe, wanu waGalileya, mbana munang'aniza julu rungu-rungu? Noyu Insa wamumonire akikweziwa mbere yenu akuka binguni, iye aludi kamba vyamummwene akuka binguni novyo.” ");
INSERT INTO wmw_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ikisa wanafunzi ware wakilawa pamwango pare, wakiludira Yerusalemu. Mwango‑wo ukitiwa Mizaituni, uwa karibu na Yerusalemu, kitambo ca kilometuru moja. ");
INSERT INTO wmw_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Pawafikire Yerusalemu kure, wakikwera mpaka julu pansana nyumba yawarindire: Peduru, Yahaya, Yakobu, Andere, Filipi, Tamimu, Bartolomeu, Matwaya, Yakobu mwana wa Alufeu, Ansumani Zeloti pamoja na Yuda mwana wa Yakobu. ");
INSERT INTO wmw_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Piya ware wákijumananga wakitenda duwa pamoja na wanawaka, Mariyamu mamaye Insa, na wanduze Insa. ");
INSERT INTO wmw_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Nozire suku zire, Peduru akimira kati ya wenziwe ware, jumula ya wanu wákiwa kiyasi ca miya na shirini, ");
INSERT INTO wmw_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","akisema: “Jamaa zangu, ajuzi atimiziwe Mandiko vyaâsowera Roho Takatifu mbere julu ya Daudi kuhusu Yuda, noyu awalongoze wanadamu wanfunge Insa. ");
INSERT INTO wmw_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yuda ákiwa nkati ya kipinga cetu, ákipata fungu ra eyi kazi‑yi.” ");
INSERT INTO wmw_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Na maripo apatire bila shariya, nzuruku wake uziwa uweru. Noparepare akisomoka akigwirira pansi, mwiri wake ukilumuka kati-kati, utumbo ukisololokera panja. ");
INSERT INTO wmw_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Vikunire vire, wanu wa Yerusalemu piya wakipata kwijiwa, kwa javyo, kwa luga yawo uweru ure ukitiwa “Akeldama”, mana ake “uweru wa damu”.) ");
INSERT INTO wmw_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Peduru akizidi kusowera, akamba javi: “Kamana kitabu ca Zaburi caândikiwa javi: ‘Nyumba yake isamiwe, asiwepo wakwikala.’ Ikisa tena cikwamba: ‘Munu mwengine ekare kiti cake.’ ");
INSERT INTO wmw_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Kwa javyo, tíjuzi tintondore mwananlume mmojawapo âwere nafwe wakati piya watiinshire na Mwenye Insa, ");
INSERT INTO wmw_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","tangu paanzire koza Yahaya mpaka suku yaatwariwe Insa binguni, ipate awe shahidi pamoja nofwe wa kufufuka kwake.” ");
INSERT INTO wmw_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Basi, wakiwatondola wanu wawiri: Matiya, na Yusufu akitiwa Barisaba akijiwikana kwa zina ra Zushutu. ");
INSERT INTO wmw_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ikisa wakilebela duwa, wakamba: “Mwenye, uwe ndi wijiwa myoyo ya piya‑wa. Basi, kati ya ewa wawiri‑wa, tolotere wauntondore mmojawapo, ");
INSERT INTO wmw_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ipate tikore naye kazi za uwalii, zaasire Yuda akuka mahala pake paanjuzire iye mwanyewe.” ");
INSERT INTO wmw_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Basi wakitenda kura, ikingwirira Matiya. Javyo iye akisanganyiwa na mawalii kumi na mmoja ware. ");
INSERT INTO wmw_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Paifikire suku ya sherehe ya Pentekoshiti, piya wakijumulana. ");
INSERT INTO wmw_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Kwa mpunde noure, ikisikirikana shauti kulawa binguni, kamba vyaivuma mepo nyingi kanguvu. We! Mepo ijala nnyumba mwawekare mure fo! ");
INSERT INTO wmw_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Na vikilawirira vinu vyakulanda malulimi a moto akawanyika, akiwesukira kila mmoja. ");
INSERT INTO wmw_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Piya ikiwejala Roho Takatifu, wakanza kusowera luga nyengine, kwa uwezo wa Roho Takatifu. ");
INSERT INTO wmw_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Yerusalemu wákiwapo Mayahudi, wakuwajibu mambo a Mwenyezimungu, wakilawirira kila inti za ulumwengu. ");
INSERT INTO wmw_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Paasikirikane namalove wa shauti za wanu, wanu wajire ware wakijumulana nopare. Wakifazaika kwa kuwa kila mmoja akisikira kwa luga yake yaapongoreriwe. ");
INSERT INTO wmw_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ewo washanga na watajabu, wakamba: “Paa, namunani? Wanu‑wa piya waGalileya, sinovyo? ");
INSERT INTO wmw_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Sambi, iwa mwaja? Ofwe kwa kila mmoja asikiraja kwa luga yake yaapongoreriwe? ");
INSERT INTO wmw_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ofwe tiwa wanu wa inti za Pariti, Medi, Elamu, Mezopotamiya, Yudeya, Kapadokiya, Pontu, Aziya, ");
INSERT INTO wmw_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Furujiya, Panfiliya, Miswiri, upande wa Libiya karibu ya kaya ya Kireni, pamoja na wayeni wakulawa Roma. ");
INSERT INTO wmw_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Mayahudi na wengine wakubali dini ya kiyahudi, wengine walawa Kereta, na wengine walawa Arabiya. Piya-fwe tisikira kwa kila moja luga yake, ewo wakisowera vinu vikulu vyaajabu vyaakunishe Mwenyezimungu. Mwaja?” ");
INSERT INTO wmw_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Piya washanga na watajabu, wakidairiyana watupu: “Noci kinu‑ci, mana ake kinani?” ");
INSERT INTO wmw_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Fala wengine wakiwakejeli, wakamba: “Ware warewa!” ");
INSERT INTO wmw_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Peduru akilamuka pamoja na mawalii kumi na moja ware, na kwa shauti ulu akamba: “Umwe Mayahudi na piya muri kwikala Yerusalemu, vijiwikane kwenu. Tengani masikiro‑yo musikire canisowera. ");
INSERT INTO wmw_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ewa wanu‑wa awarewire, kamba umwe vyamuri kudanizira kamana eyi novi ora, ingari namapema! ");
INSERT INTO wmw_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Kwasa javyo, evi ndi vire visemiwe julu ya nabii Yoweli: ");
INSERT INTO wmw_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Mwenyezimungu kasema javi: Vikuja kukuna suku za mwinsho, Roho yangu niwatawanyira wanu piya nroho zawo. Wanenu, waka na walume, wakuja kubushuru, wanemba wakuja kuwa na ruhuya ya mawoni, na wakulungwa wakuja kulota. ");
INSERT INTO wmw_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Kweli-kwelini, watwana wangu, waka na walume, nozo suku‑zo Roho yangu niwatawanyira, newo wakuja kubushuru. ");
INSERT INTO wmw_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Nikolota mambo a matajabisa julu binguni, na pansi muardhi nikolota alama: ya damu, ya moto, na ya mawingu a rosi ra kwinukala pi! ");
INSERT INTO wmw_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Juwa rikwinukala pi na mwezi ukuwa mweundu pyũ kamba damu, kábula sainafika suku ulu yakutukuziwa Mwenye. ");
INSERT INTO wmw_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Na itakuwa kila mwenyé kutaja zina ra Mwenye Insa, avushiwa.’ ” ");
INSERT INTO wmw_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Peduru akizidi kusowera, akamba: “Umwe waIziraeli, sikirizani ewu usowezi‑wu: Insa nNazareti ákiwa mwananlume akikishiwe na Mwenyezimungu mbere yenu, kwa maajuza, matajabisa, na alama zaakunishe Mwenyezimungu julu yake kati yenu umwe, kamba vyamwijiwe. ");
INSERT INTO wmw_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Eyu munu‑yu, kwa sababu ya mpango kamili wakusudiye Mwenyezimungu na wijiwifu wake tangu mida, kaperekiwa mmakono mwa wanu sawana shariya wangomezera pansalaba. Iye mumulaya. ");
INSERT INTO wmw_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Fala Mwenyezimungu kansisimusa na kanlavya malwazo a kifo, konta eco acikidiri kunfunga iye. ");
INSERT INTO wmw_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Kamana Daudi kâsema kuhusu iye: ‘Daima nimmona Mola mbere yangu. Kawa upande wa nkono nriro wangu, ndimana sitikinyika. ");
INSERT INTO wmw_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Kwa javyo, moyo wangu uwa radi lulimi rangu rifurahi, visitoshe mwiri wangu untumaini, ");
INSERT INTO wmw_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","kamana awasa roho yangu kuka Kuzimu, aumwasa Ntakatifu wako kuvunda nkaburi. ");
INSERT INTO wmw_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Unolotera njira za mainsha. Utakunijaza radi kwa kuwa pamoja nami.’ ");
INSERT INTO wmw_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Jamaa zangu, vyema nukwambireni bila kukufisani kuhusu wawa yetu nkulu Daudi. Kweli, iye kafwa, kazikiwa, na kaburi rake riwa pamoja nafwe mpaka rero‑vi. ");
INSERT INTO wmw_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Iye ákiwa nabii. Iye ákijiwa kuwa Mwenyezimungu kânlapira kuwa, nkati ya ujukulu wake, mmojawapo akuja kwikala kiti cake ca ufalume. ");
INSERT INTO wmw_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ndimana Daudi kâsowera kuhusu kufufuka ka Almasihi, sakunamba kukuna. Iye kaamba kuwa aasiwe Kuzimu wala mwiri wake auvundire. ");
INSERT INTO wmw_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Insa ambiwa‑yu Mwenyezimungu kanfufula. Ofwe piya tiwa mashahidi kuwa kweli. ");
INSERT INTO wmw_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Kwa kuwa iye kâkweziwa, kekaziwa upande wa nkono nriro wa Mwenyezimungu, na kâpokerera tamaa ya Roho Takatifu ka Baba, iye katimiminira evi vyamuri kuwona‑vi na vyamuri kusikira‑vi. ");
INSERT INTO wmw_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Kamana Daudi aapandire binguni, fala iye kâsema javi: ‘Mola kamwambira Mwenye wangu: Ikala nkono nriro wangu, ");
INSERT INTO wmw_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","mpaka niwatende maaduwi wako wawe sini, kamba gogo rakwirika maulu ako.’ ");
INSERT INTO wmw_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Ndimana waIziraeli piya wejiwe sana-sana kuwa noyu Insa wamûgomezere pansalaba‑yu, Mwenyezimungu kantula kuwa Mwenye na kantula kuwa Almasihi.” ");
INSERT INTO wmw_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Wanu ware pawasikire javire, vikiwalwaza mmyoyo mwawo, wakindairi Peduru pamoja na mawalii wengine ware: “Jamaa zangu, epa titende mwaja?” ");
INSERT INTO wmw_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Peduru akiwajibu: “Tubiyani, na kila mmoja oziwe kwa zina ra Insa Almasihi, ipate dambi zenu ziswamiiwe. Na umwe mupokerera tamaa ya Roho Takatifu. ");
INSERT INTO wmw_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Kamana eyi tamaa‑yi yenu umwe, pamoja na wanenu, na piya wari baidi naye, kwa piya wenye kwitiwa na Mola, Nlungu wetu.” ");
INSERT INTO wmw_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Kwasa javyo, iye ákilavyanga ushahidi na usowezi mwingi wawenye na akiwarimbisa myoyo, akamba: “Muvushiwe nkati ya eci kizazi kibaya‑ci.” ");
INSERT INTO wmw_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Basi, wakubalire usowezi wake, woziwa noparepare. Na kwa noire suku ire, isabu ya wenye kunfulata Insa yongezeka kiyasi ca wanu alufu natu. ");
INSERT INTO wmw_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ewo watengemana kufulata kufunda ka mawalii ware, kuno wakiinshi na umoja wakupendana, wakitenda Jambo ra Kumbukumbu, na wakilebela duwa pamoja. ");
INSERT INTO wmw_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Mawalii ware wákitenda mambo a matajabisa na alama nyingi, ndimana wanu piya uwengira wofi. ");
INSERT INTO wmw_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Piya wamwaminire Insa wákiwa pamoja na vinu vyawo wakitumira ka upamoja. ");
INSERT INTO wmw_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Wákiuzanya ankiba za mali awo na vinu vyawákiwa nawo, wakawanyirana kwa kila munu na aja yake. ");
INSERT INTO wmw_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Suku daima wákitengemana kwa moyo mmoja paluwanja ra Nyumba Takatifu. Na nyumba anta nyumba wakitongerana Jambo ra Kumbukumbu na furaha, ka moyo radi. ");
INSERT INTO wmw_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Wakintukuza Mwenyezimungu, na wakisifiwa na wanu piya. Basi, kila suku Mwenye akongeza isabu ya ware wakija kuvushiwa. ");
INSERT INTO wmw_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Nakisa, wakati wa kutenda duwa, Peduru na Yahaya wakikwera nNyumba Takatifu. ");
INSERT INTO wmw_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Na ákiwapo mwananlume mmoja wakuremala kipongorero. Ákisukuriwanga, ákituriwa panryango wa Nyumba Takatifu pakitiwa “Nryango Mwema” akiwalebela zimola wanu wakingira nluwani ra Nyumba Takatifu mure. ");
INSERT INTO wmw_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Nakuwawona Peduru na Yahaya wari karibu yakwingira nNyumba Takatifu mure, iye akiwalebela wammere zimola. ");
INSERT INTO wmw_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Peduru akinang'aniza rungu-rungu, pamoja na Yahaya, ikisa akamba: “Tinang'anize!” ");
INSERT INTO wmw_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Basi, iye akiwanang'aniza sana-sana, ákiwa na tamaa yakupokerera kinu kwawo. ");
INSERT INTO wmw_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Fala Peduru akamba: “Omi sina parata wala oru, fala caniri naco, nukupa. Kwa zina ra Insa nNazareti, lamuka enenda!” ");
INSERT INTO wmw_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Nakunkola nkono nriro, akinlamusa. Kwa mpunde noure, maulu ake mmaluwata, akipata nguvu. ");
INSERT INTO wmw_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Upesi-upesi akimira, akanza kwenenda. Akingira nawo nNyumba Takatifu mure, akenenda, akidaruka, akintukuza Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Basi wanu piya wammona akenenda akintukuza Mwenyezimungu, ");
INSERT INTO wmw_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","na wamanyira kuwa ndi noire ákikalanga paNryango Mwema wa Nyumba Takatifu, ákilebelanga zimola ire. Ndimana washanga na viwatikinisa vinkunire iye vire, manshala! ");
INSERT INTO wmw_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Mwananlume aponesiwe ire, paankorire Peduru na Yahaya, wanu piya wakiwatuwirira ewo kapamoja mahala pakwitiwa “Lupenu ra Selemani”, wakitajabu pakulu futi. ");
INSERT INTO wmw_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Peduru nakuwona javire, akiwambira wanu ware: “WaIziraeli wenzangu, mbena vyukushangishani kuwona evi? Mbana mutilavira maso ofwe kamba ndi timwenendese iye kwa uwezo wetu au ibada yetu? ");
INSERT INTO wmw_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Nlungu wa Iburahima na wa Izaki na wa Yankubu, Nlungu wa babu zetu, kantukuza ntumisi wake, Insa. Noyo-noyoni umwe wamumpereke aulaiwe na wamunkatare mbere ya Pilatu, ingawa kalangela kunfungula. ");
INSERT INTO wmw_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Fala umwe munkatala Ntakatifu, Mwenyé shariya, munlebela akufungurireni kisomi, ");
INSERT INTO wmw_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","na mumulaya mwenyé kuwa nviriro wa uhai. Ila Mwenyezimungu kanfufula ka wafwi, na kwa eco, ofwe tiwa mashahidi. ");
INSERT INTO wmw_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Kweli, kwa kutumaini zina rake, eyu mwananlume wamummona na wamumwijiwa‑yu, iwa kwa noro zina‑ro ndi rimpatise nguvu. Kwamini kwake kuja julu ya Insa ndi cimponese nfululu mbere yenu. ");
INSERT INTO wmw_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Basi sambi, jamaa zangu, omi nukwijiwa kuwa mûtenda kwa kutikina, kamba vyawâtenda novyo mafalume wenu. ");
INSERT INTO wmw_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Fala iwa novyo-novyoni Mwenyezimungu vyaâsowere tangu mida julu ya minabii piya, kuwa Almasihi wake ajuzi atabike, ndi vyaatimize namuna‑yo. ");
INSERT INTO wmw_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Basi, tubiyani muludi, ipate madambi enu aswamiiwe, ");
INSERT INTO wmw_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","na mupate wakati wakupumuzika kwa kuwa muwa pamoja na Mola, na iye akugabizini Almasihi Insa wamutuririwe tangu mida. ");
INSERT INTO wmw_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Iye ibidi ekare binguni mpaka wakati wakuludira vinu piya upya, kamba vyaasowere Mwenyezimungu tangu mida julu ya minabii watakatifu. ");
INSERT INTO wmw_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Kusema kweli, Musa kâsema javi: ‘Mola Mwenyezimungu akuzushirani kati ya rikolo renu, nabii mmoja kamba omi. Iye nsikirizeni piya caasaka kukwambirani conse. ");
INSERT INTO wmw_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Na munu saansikiriza onse noyo nabii‑yo, apoteziwa ndaraja ra umati.’ ");
INSERT INTO wmw_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Minabii wengine piya novyo, tangu Samuweli mpaka ware wajire nyuma yake, wereza viri kukuna ezi suku‑zi. ");
INSERT INTO wmw_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Umwe ndi ujukulu wa minabii na wa miyadi yakupatana yaturire Mwenyezimungu na wababu zenu, kâmwambira Iburahima javi: ‘Julu ya ujukulu wako, zijanliiwa piya kabila ziri mulumwengu‑mu.’ ");
INSERT INTO wmw_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ndimana Mwenyezimungu, paanfufure ntumisi wake Insa, kakuperekerani kwanza ipate akujanliyeni ajili ya kukutanusani, kila mmoja ase kukola dambi.” ");
INSERT INTO wmw_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Peduru na Yahaya, pawakisowera na wanu ware, wakiwalawirira walongozi wengine wa dini, nkulungwa wa minduna wa Nyumba Takatifu, pamoja na Masaduseu wengine. ");
INSERT INTO wmw_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ewa wakifazaika pakulu futi konta mawalii ware wakiwafunda wanu na wakiwereza kuwa kuwapo kufufuka ka kifo, julu ya Insa. ");
INSERT INTO wmw_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ndimana wawakola wakiwafunga, wakiwataya nkalaboshu mpaka subuu, konta juwa riswa. ");
INSERT INTO wmw_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Fala wengi wâsikire usowezi‑wo wakubali. Isabu ya wanawalume wankubalire wakifika kiyasi ca alufu ntanu. ");
INSERT INTO wmw_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Iwa pakucere subuu, mafalume wawo, pamoja na wazee na wanlimu wa shariya wakijumana Yerusalemu. ");
INSERT INTO wmw_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ákiwapo novyo Anasi, nkulu wa wakulungwa wa dini, Kayafa, Yahaya, Alishandere, na piya wengine wawere jamaa za nkulu wa wakulungwa wa dini. ");
INSERT INTO wmw_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Wakitumiza kuweta Peduru na Yahaya, wakiwemisa kati yawo, wakanza kuwadairi: “Mupata uwezoni au kwa zina ra nani vyamutendire‑vi?” ");
INSERT INTO wmw_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Basi, Peduru wakumwijala Roho Takatifu, akiwajibu: “Umwe mafalume wenye inti pamoja na wazee, ");
INSERT INTO wmw_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ikiwa rero mwankutidairi kuhusu meema atendiwe kitewe‑yu na musakula mwijiwe nani amponese, ");
INSERT INTO wmw_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","bakini mukijiwa umwe pamoja na piya wanu wa Iziraeli, kuwa eyu mwananlume ári mbere yenu‑yu kapona nfululu kwa zina ra Insa nNazareti, Almasihi. Noire wamûngomezere pansalaba ire, Mwenyezimungu akinfufula ka wafwi. ");
INSERT INTO wmw_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Insa ndi ire asemiwe mMandiko Matakatifu paamba javi: ‘Riwe ramukatare umwe wajengi, mwinsho ndi riwe rikulu rifaire kujengera pamembe.’ ");
INSERT INTO wmw_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Kweli, hapana kuvuka julu ya mwengine tena, kamana aripo zina rengine sini ya binguni, rapewe mwanadamu, wakuwa ibidi ativushe ofwe.” ");
INSERT INTO wmw_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Sambi, wakulungwa ware, pawawawonire kurimba moyo Peduru na Yahaya, na pawejiwe kuwa wákiwa wanu sawafyomire na sawasilimuke, ewo washanga na wawamanyira kuwa wakenendanga na Insa. ");
INSERT INTO wmw_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Fala pawammonire mwananlume aponesiwe ire ari pamoja nawo, awakidirire kufungula kanywa julu yawo. ");
INSERT INTO wmw_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Basi sambi, wakiwamuru walawe nnyumba ya Baraza ya Milandu ire, ewo wakibaki wakikaidiyana watupu, ");
INSERT INTO wmw_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","wakamba: “Tiwatende mwaja nowa wanu‑wa? Kamana wanu piya wa Yerusalemu wakwijiwa kuwa eya maajuza‑ya ewo ndi watendire, na ofwe atina vyakukaniza. ");
INSERT INTO wmw_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Epa, kwa kusakula habari‑zi zisisikirikane ka wanu piya, tíjuzi tiwatishe wasisowere na munu asáka kuwa onse tena kuhusu noro zina‑ro.” ");
INSERT INTO wmw_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Basi, wakitumiza kuweta tena, wakiwamuru kuwa wasisowere na wasifunde tena kwa zina ra Insa. ");
INSERT INTO wmw_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Falakini Peduru pamoja na Yahaya wakijibu, wakiwambira javi: “Lamulani umwe wanyewe. Cakweli ndi cepi mbere ya Mwenyezimungu? Tikusikirizeni umwe au Mwenyezimungu? ");
INSERT INTO wmw_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Konta ofwe aitibidi kunyamala, tíjuzi pakulu tisowere baina catiwonire na catisikire.” ");
INSERT INTO wmw_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Basi, wakulungwa ware wakingira kuwopepesa tena, mwinsho wakiwafungula wakiwasa. Awawonire shariya ya kuwahukumu, konta piya wanu wakintukuza Mwenyezimungu kwa vinu vîkunire vire. ");
INSERT INTO wmw_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Kamana, ire mwananlume ankunire maajuza akuponesiwa ire, ákiwa na umuri wa kupunda myaka arubaini. ");
INSERT INTO wmw_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Peduru na Yahaya pawafunguriwe, wakiludira ka wenziwawo ware, wakiwereza piya vyawâmbiriwe na wakulungwa wa dini pamoja na wazee. ");
INSERT INTO wmw_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ewo nakusikira, wakilebela duwa pamoja ka Mwenyezimungu, wakamba: “Mola Nkulu, uwe ndi umbire bingu, ardhi, bahari, pamoja na viyumbe piya viri nkati yake. ");
INSERT INTO wmw_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Uwe kusowera kwa Roho Takatifu julu ya babu yetu Daudi, ntumisi wako, ukamba: ‘Mbana Sawari-Mayahudi wankubishana na Mola? Mbana wanu wankupanga vinu savina kazi? ");
INSERT INTO wmw_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Mafalume wa mulumwengu wankuritengeza, wenye mamulaka wajumana, wabishane na Mola pamoja na Waantawaze iye.’ ");
INSERT INTO wmw_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Kweli, eyi kaya ulu‑yi, Herodi na Pontiyu Pilatu wajumana na Sawari-Mayahudi pamoja na wanu wa Iziraeli, kubishana na Insa, ntumisi wako takatifu wauntawaze. ");
INSERT INTO wmw_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ewo wajumana watende piya vyaupangire tangu mida kuwa vijuzi vikune. Kupanga javyo kwa sababu ya uwezo wako na kamba vyausakire. ");
INSERT INTO wmw_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Basi sambi, Mola, ona kutisha kwawo, walavye wofi nfululu watumisi wako wereze habari zako. ");
INSERT INTO wmw_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Tenda javyo kuno ukolosa nkono wako ipate uponese, na tenda alama na matajabisa kwa zina ra Insa, ntumisi wako takatifu.” ");
INSERT INTO wmw_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Pawesire kulebela duwa, mahala pawajumane pare patenda kitikansi. Piya akiwengira Roho Takatifu, wakanza kwereza habari za Mwenyezimungu bila wofi. ");
INSERT INTO wmw_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Kwa nkonjo wa ware waminire ware, piya wákiwa na mawazo mamoja na nafsi moja. Áwerepo anta munu mmoja wakwamba kuwa evi vinu‑vi vyangu omi, ila piya vinu vyawákiwa nawo, víkiwa vyawo. ");
INSERT INTO wmw_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Kwa uwezo nkulu, mawalii wákilavya ushahidi wa kufufuka ka Mwenye Insa. Na rehema nyingi íkiwesukira wanu ware piya. ");
INSERT INTO wmw_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Kamana noure nkonjo wa wenye kwamini ure, áwerepo wakusakula kinu, kutowa kupata. Wákiwa na masamba au manyumba onse wakiuzanya, nzuruku ure wákijanga, ");
INSERT INTO wmw_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","wákiwagabizi mawalii mmakono mwawo, newo wákiwatongeranga wanu, kwa kila mmoja ákipata caasakula. ");
INSERT INTO wmw_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ákiwapo mwananlume akitiwa Yusufu, wa rikolo ra kinya Lawi, kâpongoriwa kisirwa ca Kiporo. Mawalii wántapira zina ra Barinaba, mana ake “mwenyé kutaya niya”. ");
INSERT INTO wmw_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Kwa kuwa Yusufu ire ákiwa nawo ngwamba, iye kauzanya, ikisa nzuruku akija nawo, akiwagabizi mawalii mmakono mwawo. ");
INSERT INTO wmw_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ákiwapo mwananlume mmoja akitiwa Ananiya. Iye na nkawake Safira wôzanya amana yawo, ");
INSERT INTO wmw_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","fala Ananiya, kasikizana na nkawake, nzuruku ure fungu rimoja akiriturira pambari, mwengine akiwagabizi mmakono mawalii. ");
INSERT INTO wmw_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Sambi, Peduru akindairi: “Ananiya, sababuni kumwasa Ibilisi kukidiri moyo wako kuntesa Roho Takatifu, kulavya nzuruku mwengine kuriturira pambari? ");
INSERT INTO wmw_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Kábula saunauzanya, kanzi‑yo aiwere yako? Na bandi ya kuzanya, nzuruku‑wo auwere wako? Sambi, kinani cukuwazise mmoyo mwako kutenda javyo? Uwe aulongope ka wanadamu, kulongopa ka Mwenyezimungu!” ");
INSERT INTO wmw_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananiya, paasikire ewu usowezi‑wu, akigwa rã, wakufwa wawenye. Na piya wasikire vîkunire vire uwapata wofi pakulu futi. ");
INSERT INTO wmw_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Noparepare, wakija wanemba wakintwala, wakinkafini, wakinsukula wakuka wakinzika. ");
INSERT INTO wmw_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Bandi ya ora natu, akilawirira nkawake. Iye aákijiwa cinkunire nlumake. ");
INSERT INTO wmw_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Peduru akindairi: “Nganambire, ewu ndi nzuruku wamuzanye amana yenu?” Iye akijibu: “Aye, ndi nowu.” ");
INSERT INTO wmw_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Peduru akimwambira: “Sababuni uwe na nlumako kusikizana kuntenvya Roho wa Mwenyezimungu? Basi, wanemba wanzikire nlumako ndi ware panryango pare. Nowe novyo wákusukula.” ");
INSERT INTO wmw_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Kwa mpunde noure, akingwira Peduru mmaulu rã, wakufwa wawenye. Wanemba ware pawengire wansingana wakufwa. Noparepare wakinsukula, wakuka wakinzika upande wa nlumake. ");
INSERT INTO wmw_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Basi, wanu wa jamati, na ware wasikire eyi habari‑yi ware, piya uwapata wofi pakulu pawenye. ");
INSERT INTO wmw_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Alama na matajabisa mengi akikuna kati ya wanu, julu ya makono a mawalii. Newo piya wákiwa Lupenu ra Selemani na niya mmoja. ");
INSERT INTO wmw_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Wanu wengine awakitwakali kuringiza nowo nkonjo wawo‑wo, fala wakiwasifu. ");
INSERT INTO wmw_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Kwa kila mara, nkonjo wa ware wákimwamini Mwenye ukizidi kongezeka, waka na walume wengi. ");
INSERT INTO wmw_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Kwa javyo, wanu wakija nawo walwere nvinanda na mmashila panja pare, ipate akipita Peduru, nanga kinviri cake ciwafinike walwere wamojawapo. ");
INSERT INTO wmw_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Wanu wengine tena wa kaya jirani za Yerusalemu wakija nawo walwere na wamízuka. Na piya ware wakiponesiwa. ");
INSERT INTO wmw_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Basi, nkulu wa wakulungwa wa dini, na piya wawawere nawo pamoja kati ya nkonjo wa Masaduseu, ukiwengira wiyana. ");
INSERT INTO wmw_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ndimana wakiwafunga mawalii ware, wakiwataya nkalaboshu ya wafungwa piya. ");
INSERT INTO wmw_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Fala usiku, laika wa Mola kafungula miryango ya kalaboshu ire, akiwalavira panja, akiwambira: ");
INSERT INTO wmw_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Ukani kuNyumba Takatifu, mukawereze wanu habari piya kuhusu eya mainsha‑ya.” ");
INSERT INTO wmw_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ewo nakusikira javire, pakucere wakuka wakingira nNyumba Takatifu, wakanza kuwafunda wanu. Sambi, nkulu wa wakulungwa wa dini akifika pamoja na ware waákiwa nawo. Ewo wakiwarifu wanu wa Baraza ya Milandu pamoja na wazee piya wa wana wa Iziraeli. Ikisa wakiwatuma minduna kukalaboshu kure ipate wakaje nawo mawalii ware. ");
INSERT INTO wmw_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Fala minduna ware, pawafikire kukalaboshu kure, awawasingane. Basi wakiludi, wakija, wakijibu: ");
INSERT INTO wmw_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Katukire kure tisingana miryango ya kalaboshu ifungiwe ti, na maamiri wekare panryango nopo. Fala patifungure, nkati atinsingane anta munu mmoja.” ");
INSERT INTO wmw_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Nkulungwa wa minduna wa Nyumba Takatifu na wakulungwa wa dini, pawasikire javire, wafazaika mama! Vikuna‑vi ndi vyepi? ");
INSERT INTO wmw_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Kwa mpunde noure, akifika munu mmoja akiwambira: “Onani! Wanawalume wamuwataire nkalaboshu mure ware, wemira nNyumba Takatifu, wankuwafunda wanu!” ");
INSERT INTO wmw_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Basi, nkulungwa wa minduna wa Nyumba Takatifu, akuka pamoja na minduna kuwatwala mawalii ware. Fala wawatwala bila kuwatendera nguvu, konta wakiwopa wanu kuwapanja na mawe. ");
INSERT INTO wmw_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Pawawafikise kuBaraza ya Milandu, wakimisiwa mbere. Nkulu wa wakulungwa wa dini akiwadairi, ");
INSERT INTO wmw_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","akamba: “Ofwe atukukatazeni kufunda kuhusu eri zina‑ri, fala kweli-kwelini umwe mwankwijaza kila upande wa Yerusalemu kufunda kwenu, na musaka mutipatise lawama na damu ya noyu munu‑yu!” ");
INSERT INTO wmw_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Peduru na mawalii wenziwe wakijibu: “Tíjuzi tinsikirize Mwenyezimungu koliko wanadamu. ");
INSERT INTO wmw_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Nlungu wa babu zetu kanfufula Insa wamûmulaye mukingomezera pansalaba. ");
INSERT INTO wmw_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Fala noyu, Mwenyezimungu kanlamusa upande wake wa nkono nriro awe Nlongozi na Nvushi, ipate iye Mwenyezimungu waIziraeli awatubise na awaswamii dambi zawo. ");
INSERT INTO wmw_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ofwe tiwa mashahidi wa evi vinu‑vi, na shahidi mwengine ndi Roho Takatifu. Iye ndi Roho Mwenyezimungu wawapa piya wenye kunsikiriza iye.” ");
INSERT INTO wmw_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Wanu ware, pawasikire javire, wakimiwa pakulu futi, wakisaka wawolaye. ");
INSERT INTO wmw_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Falakini munkonjo wa Baraza ya Milandu mure, mwanlimu mmoja wa Taureti, Nfarizeu wakwitiwa Gamaliyeli, wakwinshimiwa na wanu piya, akamuru kuwa wanawalume ware walaviriwe panja wakati aba. Ikisa, akiwambira, ");
INSERT INTO wmw_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","akamba: “Wenzangu waIziraeli, more-moreni na ewa wanu‑wa. Wazani sana-sana vyamuka kuwatenda-vyo. ");
INSERT INTO wmw_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Suku za nyuma, kâlawirira mwananlume mmoja wakwitiwa Tehuda, akiritula kuwa munu bora. Iye kâwapata wanu kiyasi ca miya nne. Fala mwinsho kâulaiwa, na wanu wakinfulata ware wakitawanyikana piya, nkonjo ure ukifujika. ");
INSERT INTO wmw_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Airini, suku zakwandikiwa marikolo, akija akilawirira Yuda, nGalileya. Iye novyo kâkidiri kuwapata wanu wengi wawenye wakunfulata, fala neye novyo kôlaiwa, na wakinfúlata piya wâtawanyikana. ");
INSERT INTO wmw_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Basi, nukulebelani javi: ritanuseni na ewa wanu‑wa, waseni woke kwa salama, konta ikiwa ewu mpango‑wu ulawa ka munu, ufujika. ");
INSERT INTO wmw_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Falakini ikiwa ulawa ka Mwenyezimungu, umwe amukidiri kufuja, musije kuwoniwa kamba mubishana na Mwenyezimungu.” Na ewo wakikubali vyaambire Gamaliyeli vire. ");
INSERT INTO wmw_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Sambi wakiweta mawalii, wakiwacapisa, wakiwakataza kuwa wasisowere tena zina ra Insa rire, na wakiwafungula. ");
INSERT INTO wmw_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Kwa javyo, mawalii ware nnyumba ya Baraza ya Milandu mure walawa na moyo radi, konta Mwenyezimungu kawatula ubora wakejeliwe kwa sababu ya zina ra Insa. ");
INSERT INTO wmw_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Na daima‑zi, nNyumba Takatifu na mwawákipita mmamanyumba, awakasa kufunda na kwereza kuwa Insa Almasihi. ");
INSERT INTO wmw_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Kwa nozire suku zire, pawazidire kongezeka wanafunzi wa Insa, íkiwapo dugudugu nkati ya Mayahudi wakusowera kigeregu na ware wakusowera kiebraniya. Ware wakisowera kigeregu wakiduguda kuwa manankweli wawo awanang'aniziwa sana pacitongiwa cakurya kila suku. ");
INSERT INTO wmw_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ndimana mawalii kumi na wawiri wawajumanisa piya wanafunzi wa Insa, wakiwambira: “Sivyo vyema ofwe kwasa kufunda usemi wa Mwenyezimungu, kupita tikihudumu mmameza. ");
INSERT INTO wmw_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Kwa javyo, kati ya wanduzetu‑wa, watondoreni wanu saba wakuwa nawo ushahidi wakuwejala Roho Takatifu na fahamu ipate tiwagabizi eyi kazi‑yi. ");
INSERT INTO wmw_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ila ofwe tishugulikire kulebela duwa na kufunda usemi wa Mwenyezimungu.” ");
INSERT INTO wmw_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Piya ware uwajibu usowezi ure. Wakintondola Shitefanu, wakolota kwamini pakulu na wakumwijala Roho Takatifu. Wakiwatondola tena Filipi, Porokoro, Nikanori, Timoni, Parmena, pamoja na Nikolayu wa Antiyokiya, akubalire dini ya kiyahudi. ");
INSERT INTO wmw_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Wanu ware wakolotiwa mbere ya mawalii, wakilebeleliwa duwa, na wakituriwa makono. ");
INSERT INTO wmw_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Basi sambi usemi wa Mwenyezimungu ukenera. Isabu ya wanafunzi Yerusalemu ikongezeka pakulu, na walongozi wa dini wengi wakisikiriza ka kwamini. ");
INSERT INTO wmw_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Shitefanu, kwa kumwijala rehema na uwezo, ákitendanga matajabisa makulu-makulu na alama mbere ya wanu. ");
INSERT INTO wmw_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Fala wakizuka wanu wamojawapo wa sinagoga ikitiwa “Ya wenye uhuru”. Wákiwa Mayahudi wa Kireni na Aleshandriya, na wengine wa Kilikiya na Aziya. Ewo wakanza kukaidiyana na Shitefanu. ");
INSERT INTO wmw_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Falakini ewo awakikidiri kunshinda wijiwifu tele‑tele pamoja na Roho vikinsoweresa. ");
INSERT INTO wmw_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ikisa wawaripa wanu wengine wambe javi: “Tinsikira akikufuru ka Musa pamoja na Mwenyezimungu.” ");
INSERT INTO wmw_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Wakiwashongezera wanu ware, wazee, na wanlimu wa shariya. Nakunfika karibu Shitefanu, wakinkola, wakinlongoza kuBaraza ya Milandu ya Mayahudi. ");
INSERT INTO wmw_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Noparepare, wakiwemisa mashahidi walongo wakisema: “Eyu mwananlume‑yu aasa kukufurira mahala takatifu‑pa pamoja na Taureti. ");
INSERT INTO wmw_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Konta tinsikira akisema kuwa Insa nNazareti‑yo adangula mahala‑pa na apindula tabiya zaatasire Musa.” ");
INSERT INTO wmw_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Na piya wanu wekare paBaraza ya Milandu ire, nakunang'aniza rungu-rungu, wammona uso wake ure kuwa kamba wa laika. ");
INSERT INTO wmw_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Sambi, nkulu wa wakulungwa wa dini kandairi Shitefanu: “Uwe, kweli-kwelini ndi novyo?” ");
INSERT INTO wmw_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Iye akijibu: “Jamaa zangu, wanduzangu pamoja na wawawa, sikirizani! Mwenyezimungu ntukufu kâmwisukira wawa yetu Iburahima paákiwa Mezopotamiya, saanasamira kwikala Harani, ");
INSERT INTO wmw_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","kâmwambira javi: ‘Lawa inti yako, wase jamaa zako, uke inti yanisaka kukolotera yonse.’ ");
INSERT INTO wmw_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ikisa, Iburahima akilawa inti ya waKaldayo, akuka akiinshi Harani. Nokurekure, bandi ya kufwa wawaye, Mwenyezimungu kansamisira Iburahima eyi inti yamuri kwikala umwe sambi‑yi. ");
INSERT INTO wmw_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Mwenyezimungu ampere Iburahima kuriti, anta mahala pakutula mulu. Novyo-sivyo, iye kâmpa tamaa ya kumpa inti‑yi iye iwe yake-yakeni pamoja na ujukulu wake, ingawa âwere nawo mwana. ");
INSERT INTO wmw_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Mwenyezimungu akamba kuwa ujukulu wake wakuja kuwa wamalamboni wakwikala inti ya wanu wengine, wawe watwana, watabishiwe kwa muda wa myaka miya nne. ");
INSERT INTO wmw_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Tena Mwenyezimungu akamba: ‘Inti yawasaka kutendiwa utwana‑yo, niwahukumu. Ikisa, bandi ya evyo, wasama, wakuja kunitukuza omi epa mahala‑pa.’ ");
INSERT INTO wmw_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Mwinsho akimpa miyadi ya kupatana julu ya itani. Kwa javyo, paampongore Izaki, akintaya itani suku yanane yawenye. Izaki akimpongola Yankubu, na Yankubu akiwapongola wanawe kumi na wawiri, wababu zetu wakulu. ");
INSERT INTO wmw_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Wababu zetu wakulu ware wantendera fitina nduyawo Yusufu, wamuzanya akuka inti ya Miswiri. Fala Mwenyezimungu ákiwa pamoja neye. ");
INSERT INTO wmw_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Iye akinlavya tafauti zake piya, akimpa fadili na wijiwifu mbere ya Firyauna, nfalume wa Miswiri. Ndimana Firyauna akintawaza kuwa waziri wake Miswiri, na akingabizi nyumba yake ya kifalume. ");
INSERT INTO wmw_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ikisa ikija njala inti ya Miswiri na Kanaa piya, ikiwataya wanu mashaka makulu futi. Anta babu zetu awakipata cakurya. ");
INSERT INTO wmw_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Fala Yakobu, paasikire kuwa Miswiri iwapo tirigu, kawatuma wanawe, wababu zetu, safari yakwanza. ");
INSERT INTO wmw_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Pawokire safari yapiri, Yusufu karijiwisa mbere ya wanyenyeze, na Firyauna akipata kuwejiwa jamaa zake Yusufu. ");
INSERT INTO wmw_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Yusufu akitumiza kumwita Yakobu wawaye na jamaa zake piya, isabu ya wanu sabini na watanu. ");
INSERT INTO wmw_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Basi Yakobu akiteremukira Miswiri, nokurekure akifwa pamoja na wababu zetu. ");
INSERT INTO wmw_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Airini, maiti awo aperékiwa Sikemi, kawazikiwe kaburi râuzire Iburahima kwa isabu ya parata na wakinya Emori Sikemi kure. ");
INSERT INTO wmw_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Wakati paufikire karibu, Mwenyezimungu katimiza tamaa yaâmpere Iburahima, kabila yetu Miswiri ikizidi kongezeka pakulu. ");
INSERT INTO wmw_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Sambi Miswiri kure katawala nfalume mwengine sakimwijiwa Yusufu. ");
INSERT INTO wmw_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Eyu kawatenvya jamaa zetu, kawatabisha babu zetu julu ya kuwalazimisha wawase panja wasimana watoto wasiinshi. ");
INSERT INTO wmw_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Kwa nowo wakati‑wo ndi waapongoriwe Musa. Iye ákiwa mwema sana. Kareriwa myezi mitatu nnyumba ya wawaze, ");
INSERT INTO wmw_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","na paasiwe toto ire, mwana wa Firyauna akinlokota, akinrera kamba mwanawe. ");
INSERT INTO wmw_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Musa kafundiwa wijiwifu piya wa Miswiri, na kawa mwenyé nguvu wa masemo na vitendo. ");
INSERT INTO wmw_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Musa, paafikire hirimu ya myaka arubaini, akiwaza kuka kuwawona jamaa zake, waIziraeli. ");
INSERT INTO wmw_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Paammonire muIziraeli mmoja akitabishiwa, iye akimwingirira, akiriripira kwa ire akitabishiwa ire, akinduru mMiswiri ire. ");
INSERT INTO wmw_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Musa akiwaza kuwa wanduze waIziraeli wakwereriwa kuwa Mwenyezimungu awanusuru julu yake iye, fala awereriwe. ");
INSERT INTO wmw_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Subuu yake akiwalawirira waIziraeli wamojawapo wakumana. Akiyerera kuwapatanisa, akiwambira: ‘He! Umwe muwa munu na nduye, mbena musausana watupu?’ ");
INSERT INTO wmw_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Fala munu akintabisha mwenziwe ire, akintanuka Musa, akimwambira: ‘Uwe, akutawaze kuwa nkulungwa wetu waakutilamula nani? ");
INSERT INTO wmw_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Usaka unulaye novyo kamba vyaumulaye ijana mMiswiri ire?’ ");
INSERT INTO wmw_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Nakusikira javire, Musa akitira, akuka inti ya Midiyani kamba mmalamboni. Nokurekure akiwapongola wana wawiri. ");
INSERT INTO wmw_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Ipita myaka arubaini, ari nlanga ra mwango wa Sinayi, kamwisukira laika na malulimi a moto, akikorera pafukutu. ");
INSERT INTO wmw_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Musa akishanga kwa ruhuya imwisukire ire, nakusengereza karibu awone sana, ikinjira shauti ya Mola, ikamba: ");
INSERT INTO wmw_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Omi ndi Nlungu wa kinya babuzo: Nlungu wa Iburahima, wa Izaki, na wa Yankubu.’ Musa akanza kutetema, anta kunang'aniza aakishubutu. ");
INSERT INTO wmw_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Mola akimwambira: ‘Vula viratu vya mmaulu mwako-vyo, konta mahala pauri‑po patakatifu. ");
INSERT INTO wmw_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Niwonanga mashaka makulu awatabishiwa wanu wangu wari Miswiri, nisikiranga kiriro cawo. Ndimana nisuka niwafungure. Sikiriza sana-sana! Nankukutuma uludire Miswiri.’ ");
INSERT INTO wmw_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Noyo Musa wawânkatare‑yo, ewo pawandairire javi: ‘Nani akutawaze kuwa nkulungwa na mwenyé kulamula?’, noyo noyoni, Mwenyezimungu kampereka kuwa nkulungwa na nvushi, julu ya laika âmwisukire pafukutu ire. ");
INSERT INTO wmw_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Na noyo noyoni ndi awalavire wanu Miswiri, pesire kutenda matajabisa na alama inti ya Miswiri, Bahari Nyeundu, na nlanga, muda wa myaka arubaini. ");
INSERT INTO wmw_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Noyo noyoni ndi Musa awambire waIziraeli javi: ‘Mwenyezimungu anzusha nkati ya wanu wake nabii wenu kamba vyanizushire omi.’ ");
INSERT INTO wmw_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Noyu ndi ire ákiwa pamoja nawo waIziraeli wajumane nlanga. Iye ndi awere shikarakanzi kati ya laika na kinya babu zetu kumwango wa Sinayi kure. Iye ndi apokerere usemi hai, akitipa ofwe. ");
INSERT INTO wmw_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Fala wababu zetu awasakire kunsikiriza Musa, wankatala. Mmyoyo yawo, wakisaka kuludira Miswiri, ");
INSERT INTO wmw_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","wakimwambira Aruna: ‘Titendere maswanamu wakutilongoza. Kamana Musa atilavire Miswiri‑yo, atijiwa cinkunire.’ ");
INSERT INTO wmw_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Newo wakintenda swanamu, nfano wa ng'ombe ntoto. Ikisa, wakintendera kafara swanamu ire, na wakinsheherekera pakulu kinu cawantendire na makono awo. ");
INSERT INTO wmw_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Basi, Mwenyezimungu akiwatanuka, akiwasa wakambudu vyumbiwe binguni kamba vyavyândikiwe nkitabu ca minabii, cisema javi: ‘Onani, waIziraeli! Nlanga, muda wa myaka arubaini, munilavira omi kafara yenu na swadaka? ");
INSERT INTO wmw_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","He! Kwasa kutenda javyo, musukula ema ya Moleki, na nondwa ya swanamu Rafani, mifano yamutendire wanyewe mupate kwambudu. Sikweli? Ndimana nukutuwisirani baidi kupunda Babiloniya.’ ");
INSERT INTO wmw_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Wababu zetu wákiwa nawo nlanga Ema ya Ushahidi, íjengiwa kamba Mwenyezimungu vyamwamurire Musa kujenga, kwa kufulata nfano waawonire. ");
INSERT INTO wmw_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Wababu zetu wapokerera noire Ema ire, na wasukula pawalawire na Yoshwa kuriti inti‑yi. Mwenyezimungu yaawatuwisire mataifa mengine mbere ya wababu zetu. Na Ema ire ikibaki nokure mpaka wakati wa Daudi. ");
INSERT INTO wmw_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Iye karehemiwa na Mwenyezimungu, kanlebela nafasi ya kuwatafitira waIziraeli mamburo awo. ");
INSERT INTO wmw_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Falakini, ajire akijenga nyumba‑yo ndi Selemani. ");
INSERT INTO wmw_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ka ukweli, Mwenye Nkulu ekala nyumba zakujenga wanadamu. Kamba vyêreze nabii mmoja, akamba javi: ");
INSERT INTO wmw_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Binguni ndi kiti cangu, ardhi ndi yanirika maulu angu. Ndi nyumbani yamusaka kunijengela? (amba ndi Mola). Au mahalani panisaka kupumula? ");
INSERT INTO wmw_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Sumi na nkono wangu mwanyewe nitendire piya vinu‑vi?’ ” ");
INSERT INTO wmw_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Shitefanu mwinsho akamba javi: “Umwe muwa wabishi, amukeketiwe myoyo yenu na murimba masikiro. Daima munkatala Roho Takatifu, kamba vyawákinkatalanga wababu zenu. ");
INSERT INTO wmw_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Nabiini salumbatiwe na babu zenu? Ewo wawolaya mitume wákerezanga mida habari ya kwisuka ka Mwenyé shariya. Sambi, na umwe ndi novyo: munzungunuka, mumulaya iye. ");
INSERT INTO wmw_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Nomwe-nomweni ndi mupokerere shariya ilawire ijire na malaika. Novyo-sivyo, umwe amutumire noyo shariya‑yo.” ");
INSERT INTO wmw_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Wakulungwa ware, pawasikire usowezi‑wu, ukiwasoma mmyoyo mwawo, wakintafunira meno. ");
INSERT INTO wmw_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Fala iye kamwijala Roho Takatifu, kanang'aniza binguni, kawona nuru ya utukufu wa Mwenyezimungu, na kammona Insa emire upande wa nkono nriro wa Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Neye akisema: “Onani! Nankuwona binguni wanzu, na Binadamu wa Binguni kemira upande wa nkono nriro wa Mwenyezimungu!” ");
INSERT INTO wmw_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Fala nakukuwa pakulu, wakiziwa masikiro, wakimwirukira piya kwa niya mmoja. ");
INSERT INTO wmw_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Wakintuwisira panja ya kaya ulu ire, kuno wakinpanja na mawe. Mashahidi wakinvula nguwo zake zaâvarire wakingabizi mmakono nnemba wakwitiwa Saulu. ");
INSERT INTO wmw_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ewo wakizidi kumwefya mawe, kuno Shitefanu akilebela duwa, akamba: “Mwenye Insa, pokerera roho yangu.” ");
INSERT INTO wmw_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ikisa akikokora, akifula uto, akamba: “Mola, usiwahukumu kwa eyi dambi‑yi!” Pesire kusema javire, akifwa. ");
INSERT INTO wmw_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Na Saulu kakubali kuulaiwa ka Shitefanu. Noire suku ire, jamati Yerusalemu akanza kuwapata mashaka a kulumbatiwa pakulu. Piya wakitawanyikana inti za Yudeya na Samariya, ila mawalii awatirire Yerusalemu kure. ");
INSERT INTO wmw_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Wanu mamuminu wanzika Shitefanu na wanririra pakulu futi. ");
INSERT INTO wmw_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Fala Saulu akifuja jamati ire, akingira nyumba anta nyumba, akiwasukuma waka na walume, akiwatayisa nkalaboshu. ");
INSERT INTO wmw_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Sambi, watawanyikane ware wapita wakereza Habari Ngema. ");
INSERT INTO wmw_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipi neye akiteremukira kaya moja ya Samariya, nokurekure akiwereza wanu kuhusu Almasihi. ");
INSERT INTO wmw_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Wanu wengi wakinsikiriza sana-sana Filipi vyaakisowera, wakinsikiriza kwa niya mmoja kuno wakiwona alama zaakitenda. ");
INSERT INTO wmw_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Kamana wanu wengi wakupatiwa na mashetwani, wakisomoka kuno wakituwisiwa mashetwani ware. Na vitewe pamoja na wakútumbela wengi wakiponesiwa. ");
INSERT INTO wmw_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Kwa javyo, nkaya mure íkiwapo radi pakulu futi. ");
INSERT INTO wmw_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Nokure, akiinshi mwananlume mmoja wakwitiwa Ansumani, mida âkitenda vitendo vya usawi, ákiwatajabisanga waSamariya. Iye akiritula ubora. ");
INSERT INTO wmw_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Piya wenye kaya ire kwanza ntoto mpaka nkulu wakinsikiriza, wakamba: “Eyu munu‑yu kanawo uwezo wa Mwenyezimungu, kanawo uwezo Nkulu.” ");
INSERT INTO wmw_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ewo wakinsikiriza konta suku nyingi zawenye ákiwatajabisa na vitendo vya usawi. ");
INSERT INTO wmw_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Fala pawankubalire Filipi vyaakereza kuhusu ufalume wa Mwenyezimungu na zina ra Insa Almasihi, wakanza koziwa, waka kamba walume. ");
INSERT INTO wmw_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Anta na Ansumani novyo iye mwanyewe kakubali. Bandi ya koziwa, ákenendanga na Filipi. Iye, kwa kuwona alama na matajabisa makulu ákitendanga are, akitajabu. ");
INSERT INTO wmw_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Mawalii Yerusalemu, pawasikire kuwa waSamariya wakubali usemi wa Mwenyezimungu, wakiwapereka noko Peduru na Yahaya. ");
INSERT INTO wmw_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Pawafikire, wawalebelela duwa ipate wampokerere Roho Takatifu. ");
INSERT INTO wmw_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Konta noure wakati ure, ákiwa saanamwisukira munu anta mmoja. Ila ewo woziwa kwa zina ra Mwenye Insa tu basi. ");
INSERT INTO wmw_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Basi, wakiwatula makono, newo wakimpokerera Roho Takatifu. ");
INSERT INTO wmw_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Ansumani, paawonire kuwa wankupewa Roho Takatifu julu ya kuturiwa makono na mawalii ware, neye akiwamera nzuruku, akamba: ");
INSERT INTO wmw_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Nnomi novyo nipeni noyo mamulaka‑yo, ipate wanintula makono onse, ampokerere Roho Takatifu.” ");
INSERT INTO wmw_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Fala Peduru akimwambira: “Upoteya uwe pamoja na nzuruku wako‑wo mwanyewe! Kuwaza kuwa ruhuya ya Mwenyezimungu ipatikana kwa nzuruku? ");
INSERT INTO wmw_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Uwe auna fungu wala upande kati ya eyi kazi‑yi kamana moyo wako auri sana mbere ya Mwenyezimungu! ");
INSERT INTO wmw_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Basi, tubiya mabaya ako‑yo, unlebele Mola, dalili akuswamii caulangele mmoyo mwako‑co. ");
INSERT INTO wmw_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Kamana niwona kuwa kwanawo nyongo ya wiyana pakulu, na kuwa nkati ya kifungo ca ubaya.” ");
INSERT INTO wmw_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ansumani akiwajibu, akamba: “Umwe‑po nilebeleleni ka Mola ipate cisinikune kimojawapo vyamusowere-vyo.” ");
INSERT INTO wmw_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Peduru na Yahaya, pawesire kulavya ushahidi na kwereza usemi wa Mola, wakiludira Yerusalemu. Pawakiludi, wakereza Habari Ngema makaya mengi a waSamariya. ");
INSERT INTO wmw_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ikisa, laika wa Mola akisowera na Filipi, akamba: “Lawa uke upande wa suheli, utware njira ya kuteremukira Yerusalemu ukukirira Gaza.” Noyo njira‑yo yalanga. ");
INSERT INTO wmw_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Basi Filipi akilawa akuka. Paakuka akisimanana naye mwananlume cande wa Etiyopiya, ákiwa ntumisi nkulu wa Kandasi, Rainya wa Etiyopiya. Noyo mwananlume‑yo ndi agabiziwe piya kazi za mizuruku. Iye kôka Yerusalemu kuntukuza Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Paásimanane nawo‑po ákiludira kwawo. Kekala munkukuta mwake, akifyoma kitabu ca nabii Izaya. ");
INSERT INTO wmw_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Roho Takatifu kamwambira Filipi: “Sengereza karibu ya nkukuta ure pare, ukasikire nowe.” ");
INSERT INTO wmw_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filipi akituwa akisengereza pankukuta pare, akinsikira nTiyopiya ire akifyoma kitabu ca nabii Izaya. Filipi akindairi: “Mwaja? Camufyoma‑ci, mwankwereriwa?” ");
INSERT INTO wmw_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Amiri ire akinjibu: “Nereriwaja saneleweshiwe?” Kwa javire, iye akimwambira Filipi, akamba: “Kwera munkukuta‑mu, tikare onse.” ");
INSERT INTO wmw_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Usowezi takatifu wawenye waákifyoma ndiwu, ukwamba javi: “Iye ákiwa kamba kondoo wakuka kusinjiwa, kamba mwana wa kondoo vyanyamala ndu, ka mwenye kunsinja mabururu ake, novyo-novyoni neye aambure kanywa yake. ");
INSERT INTO wmw_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Kwa kurinyenyekeya kwake, wantuwa shariya. Hapana asaka kusowera kuhusu kizazi cake konta uhai wake ulaviwa mulumwengu‑mu.” ");
INSERT INTO wmw_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Amiri ire akindairi Filipi: “Nukulebela, evi vyaamba nabii‑vi kankumwamba nani? Kankuramba mwanyewe au munu mwengine mmojawapo?” ");
INSERT INTO wmw_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Basi Filipi akanza kusowera, na mwanzo wa noya Mandiko Takatifu‑ya, akimwereza habari ya Insa. ");
INSERT INTO wmw_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Pawakuka munjira, wakisingana maji. Amiri ire akamba: “Are pare maji! Cikataza omi koziwa kinani?” ");
INSERT INTO wmw_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Basi, amiri ire akimisisa nkukuta ure, wakisuka wo‑wawiri, wakingira mmaji, Filipi ire akimoza noparepare. ");
INSERT INTO wmw_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Pawalawire mmaji mure, Roho wa Mola akinlainisa Filipi, na amiri ire awere wakummona tena. Basi, akitwala njira akuka vyake ka moyo radi! ");
INSERT INTO wmw_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filipi akiwoniwa Azoto, akipita akereza Habari Ngema kaya ulu‑ulu zire piya mpaka akifika Kaisariya. ");
INSERT INTO wmw_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Saulu akizidi kutisha na mawazo a kuwolaya wanafunzi wa Mwenye Insa. Akimukira nkulu wa wakulungwa wa dini, ");
INSERT INTO wmw_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","kunlebela waraka ya kuka Damashiku akolote mmasinagoga, ipate akiwasingana walume au waka wenye kufulata Njira ya Insa, awafunge, oke nawo Yerusalemu. ");
INSERT INTO wmw_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Fala iye paakuka vikinkuna ari karibu ya Damashiku, kwa gafula ikinzunguriza nuru ya kulawa binguni. ");
INSERT INTO wmw_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Noparepare akigwa, akisikira shauti ikimwambira: “Saulu, Saulu, mbana unilumbata?” ");
INSERT INTO wmw_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Iye akidairi: “Uwe nani, Mwenye?” Shauti ire ikinjibu: “Omi Insa waunlumbatanga‑yo. ");
INSERT INTO wmw_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Fala lamuka, uke ire kaya ire, eko ukwambiriwa caukujuzi kutenda.” ");
INSERT INTO wmw_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Wanawalume walongozane naye Saulu ware, wakimira wakinyamala, wakisikira shauti fala awakimmona munu wawenye. Mashala! ");
INSERT INTO wmw_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saulu akilamuka pansi pare, na ingawa maso ake kafungula, fala aákiwona kinu. Ndimana, ewo wakinkola nkono, wakimukisa Damashiku. ");
INSERT INTO wmw_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Iye kekala suku natu saawona. Nozo suku‑zo, aataire pakanywa cakurya wala maji. ");
INSERT INTO wmw_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damashiku kure ákiwapo mwanafunzi mmoja wakwitiwa Ananiya, imwisukira ruhuya ya Mwenye Insa, shauti ikimwita: “Ananiya!” Iye akijibu: “Labeka, Mwenye.” ");
INSERT INTO wmw_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Mwenye Insa akimwambira: “Ritengeze, uke barabara yakwitiwa Koloka. Ukafike nyumba ya Yuda, ukandairishe mwananlume wa Tarusu wakwitiwa Saulu. Ka ukweli, iye kankulebela duwa. ");
INSERT INTO wmw_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Imwisukira ruhuya, neye kammona mwananlume wakwitiwa Ananiya akingira akintula makono, akinlebelela aludire kuwona.” ");
INSERT INTO wmw_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananiya akijibu: “Mwenye, niwasikiranga wanu wengi wawenye wakisowera kuhusu noyo mwananlume‑yo na ubaya mwingi iye awatendanga wanu wako watakatifu Yerusalemu‑ko. ");
INSERT INTO wmw_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Na epa iye kanawo mamulaka a wakulungwa wa dini a kuwafunga piya wenye kwambudu zina rako.” ");
INSERT INTO wmw_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Fala Mwenye kamwambira: “Uka, konta noyo mwananlume‑yo nintondola nintumire awereze zina rangu Sawari-Mayahudi, mafalume, pamoja na waIziraeli. ");
INSERT INTO wmw_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Omi mwanyewe nimolotera Saulu mashaka akija kunkuna kwa ajili yangu.” ");
INSERT INTO wmw_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Basi Ananiya akuka, akingira nyumba ire, akintula makono, akamba: “Nduyangu Saulu, Mwenye kanituma kwako, Insa mwanyewe akulawírire munjira‑yo, ipate uludire kuwona na akwijare Roho Takatifu.” ");
INSERT INTO wmw_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Kwa mpunde noure, vigwa vinu mmaso mwa Saulu vyakulanda mamba a inswi. Kweli, iye akiludira kuwona. Basi, akilamuka akuka akoziwa. ");
INSERT INTO wmw_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Pesire kurya, akipata nguvu. Saulu akikala Damashiku nokure pamoja na wanafunzi wa Insa kwa muda wa suku aba. ");
INSERT INTO wmw_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Kwa wakati noure, akuka mmasinagoga a Mayahudi, akanza kwereza kuhusu Insa, kuwa iye ndi Mwana wa Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Piya wakinsikira, wakitajabu, wakamba: “Sinoyu mwananlume akiwalumbata wambudu zina ra Insa Yerusalemu kure‑yu? Sicinjisire epa noco, awafunge, awapereke ka walongozi wa dini?” ");
INSERT INTO wmw_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Fala Saulu kila mara akizidi kwijaziwa uwezo. Iye akiwatikinisa Mayahudi wakikala Damashiku kwa kuwejiwisa kuwa Insa ndi Almasihi. ");
INSERT INTO wmw_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Zipita suku nyingi zawenye, ");
INSERT INTO wmw_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Mayahudi wakisikizana kumulaya, fala iye kawejiwirira mipango yawo. Ikisa tena, Mayahudi wakisonderanga mmiryango ya kaya, usiku na nsana, ipate wammone Saulu wamulaye. ");
INSERT INTO wmw_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ndimana, wanafunzi wake wakintwala usiku, wakimpenyeza pakitololo ca kipama, wakinteremusa. ");
INSERT INTO wmw_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saulu paafikire Yerusalemu, kayerera kusanganyika na wanafunzi wa Insa. Fala piya ware wakimopa, awakamini kuwa iye kweli-kwelini mwanafunzi. ");
INSERT INTO wmw_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Fala Barinaba akintwala, akimpereka ka mawalii. Akiwereza namuna Saulu vyaâmonire Mwenye Insa munjira, âkisowera naye. Na kawereza novyo namuna vyêreze kuhusu Mwenye Insa bila wofi Damashiku. ");
INSERT INTO wmw_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Kwa javyo, Saulu akenenda nawo pamoja Yerusalemu, ákiwa na uhuru wa kwingira na kulawa kati yawo, ákiwereza kuhusu Insa bila wofi. ");
INSERT INTO wmw_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Iye ákisoweranga na ákikaidiyana nawo Mayahudi wakusowera kigeregu, fala ewo wakisakula namuna ya kumulaya. ");
INSERT INTO wmw_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Pawasikire, wanduze wenye kwamini wakintwala Saulu, wakuka naye Kaisariya, nokurekure wakimpereka Tarusu. ");
INSERT INTO wmw_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Kwa javyo, jamati inti za Yudeya, Galileya, na Samariya zíkiwa nawo usalama na zikirimba. Zíkirijenga na inshima za Mola na kwa nguvu za Roho Takatifu, zikizidi kongezeka. ");
INSERT INTO wmw_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Peduru ákenendanga kila upande, koka novyo kuwawona watakatifu wakikala Lida. ");
INSERT INTO wmw_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Noko akisimanana na mwananlume mmoja wakwitiwa Aineya, ákiwa kitewe, mainsha ake ákiwa a pakinanda muda wa myaka minane. ");
INSERT INTO wmw_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Peduru akimwambira: “Aineya, Insa Almasihi akuponesa! Lamuka, tandika kinanda cako.” Neye, kwa mpunde noure, akilamuka. ");
INSERT INTO wmw_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Wanu piya wa makaya a Lida pamoja na a Saroni wammona, newo wamwamini Mwenye Insa. ");
INSERT INTO wmw_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Kaya ulu ya Yafa ákiwapo mwanafunzi mmoja wakimwita Tabita. (Zina nkigeregu akitiwa Dorka.) Noyo mwanamuka‑yo ákitendanga vitendo vyema na ákilavyanga zaka. ");
INSERT INTO wmw_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Kwa nozire suku zire, kalwala, ikisa akifwa. Bandi ya kumosa, maiti wakitula kukisusi kugorofa. ");
INSERT INTO wmw_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Kwa kuwa Yafa kúkiwa karibu na Lida, wanafunzi pawasikire kuwa Peduru kawa Lida, wamperekera wanawalume wawiri kuntafadali javi: “Njo kwetu kuno, usikawe.” ");
INSERT INTO wmw_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Kwa javyo, Peduru akilawa, akilongozana nawo. Nakufika, wakimpereka kugorofa nkisusi. Piya manankweli wakimira karibu ya Peduru, kuno wakirira na wakimolotera anzu na nguwo zaákisonanga Dorka ári hai. ");
INSERT INTO wmw_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Peduru wanu ware piya akiwalavira panja, akikokora, akilebela duwa. Ikisa akizungunuka, akinnang'aniza maiti ire, akamba: “Tabita, lamuka!” Iye akifungula maso ake, nakummona Peduru, akikala. Mama! ");
INSERT INTO wmw_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Peduru akinkola nkono, akinlamusa, akimwimisa. Ikisa akiweta wenye kwamini ware pamoja na manankweli, akiwolotera nkomu wawenye dodola. ");
INSERT INTO wmw_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Wanu piya wa kaya ulu ya Yafa ire wakisikira habari zikunire zire, na wengi wakinkubali Mwenye Insa. ");
INSERT INTO wmw_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Na Peduru kainshi suku nyingi zawenye Yafa kure nnyumba ya mwenye Ansumani. Ansumani‑yo kazi yake íkiwa nsuwa-sambala. ");
INSERT INTO wmw_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ákiwapo Kaisariya mwananlume mmoja ákitiwa Koroneliyu, ákiwa nfalume wa kundi ra masurudadu rikitiwa “Kundi ra Italiya”. ");
INSERT INTO wmw_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Iye akimwajibu mambo a Mwenyezimungu, na akimopa Mwenyezimungu, iye pamoja na jamaa zake piya. Iye ákilavyanga zaka pakulu, na daima ákilebelanga duwa ka Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Kwa suku moja, wakati wa alhanswiri, imwisukira ruhuya, kammona sana-sana laika wa Mwenyezimungu akinjira akimwita: “Koroneliyu!” ");
INSERT INTO wmw_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","We! Akibaki akinnang'aniza laika ire rungu-rungu, wakushanga wawenye, akindairi: “Kinani mwenye?” Laika ire akinjibu: “Duwa yako pamoja na zaka yaulavyanga ifika ka Mwenyezimungu akumbukire tamaa zake. ");
INSERT INTO wmw_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Epa sambi, wapereke wanawalume woke mpaka Yafa, wakantware mwananlume wakwitiwa Ansumani, atapiriwe zina ra Peduru. ");
INSERT INTO wmw_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Eyu munu‑yu kafikira ka mwananlume wakwitiwa Ansumani, nsuwa-sambala. Nyumba yake iwa nanyenje ya mwani.” ");
INSERT INTO wmw_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Nakulainika laika waakisowera naye ire, iye akiweta watumisi wake wawiri na surudadu mmoja muminu kati ya ware wákiwa pakazi yake. ");
INSERT INTO wmw_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Akikola kuwereza piya, akiwatuma kuka Yafa. ");
INSERT INTO wmw_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Subuu yake, ewo pawakenenda munjira karibu ya Yafa, Peduru akikwera pajulu ya nyumba kulebela duwa. Íkiwa kiyasi ca aduhuri. ");
INSERT INTO wmw_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ikinkola njala, akisakula kurya. Pawakipika cakurya, ikimwisukira ruhuya. ");
INSERT INTO wmw_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Kawona bingu iri wanzu, cikija kinu cakulanda nguwo ulu ifungiwe malunsa ómane, ikiteremusiriwa pansi. ");
INSERT INTO wmw_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Nkati‑mo wákiwapo kila namuna ya manyama wa maulu mane na wadudu wakurikweta pansi pamoja na nyuni za julu. ");
INSERT INTO wmw_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Basi iye akisikira shauti, ikamba: “Lamuka Peduru, sinja, urye.” ");
INSERT INTO wmw_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Peduru akamba: “Sishubutu, Mwenye! Kamana tangu sinarya kinyafu wala caharamu.” ");
INSERT INTO wmw_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Kwa mara nyengine tena, shauti ire ikimwambira javi: “Usite haramu kinu caahalalishe Mwenyezimungu.” ");
INSERT INTO wmw_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Evi vikuna mara natu. Kwa mpunde noure, nguwo ire ikiludisiriwa binguni. ");
INSERT INTO wmw_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Peduru, paakishanga kuhusu mana a ruhuya imwisukire ire, wanu watumiwe na Koroneliyu ware wêmira panryango, wakidairi nyumba ya Ansumani. ");
INSERT INTO wmw_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Wakita, wakidairi: “Mwananlume wakwitiwa Ansumani Peduru kafikira nomu?” ");
INSERT INTO wmw_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Peduru paakiwaza mana a ruhuya ire, Roho Takatifu akimwambira javi: “Ona, wanu watatu wajire‑wo wakusakula. ");
INSERT INTO wmw_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Basi, lamuka wisuke, ulongozane nawo, usiwe na dana, konta omi ndi niwatumire.” ");
INSERT INTO wmw_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Kwa javyo, Peduru akisuka, akiwambira wanu ware: “Omi ndi munu wawenye wamúri kunsakula‑yo, epa cikujisireni kinani?” ");
INSERT INTO wmw_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ewo wakinjibu: “Ofwe katituma Koroneliyu, nfalume wa kundi ra masurudadu. Iye mwenyé shariya, amopa Mwenyezimungu, na Mayahudi piya wansifu pakulu sana. Iye kamuriwa na laika takatifu atumize kukwita uke kwake, ipate akakusikire usowezi wako.” ");
INSERT INTO wmw_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Basi Peduru akiwakaribisha wakingira, wakifikira nopare. Subuu yake iye akilawa, akilongozana nawo, pamoja na wenziwe wamojawapo wa Yafa wakimpereka. ");
INSERT INTO wmw_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Subuu yake, akifika Kaisariya, na Koroneliyu neye kekala ákiwarindira. Iye kâwalarika jamaa zake na marafiki zake wa pamoyo. ");
INSERT INTO wmw_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Sambi, Peduru pengire, Koroneliyu nakummona, akingwirira mmaulu kuntukuza. ");
INSERT INTO wmw_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Fala Peduru akinlamusa, akimwambira: “Imira! Omi novyo niwa mwanadamu!” ");
INSERT INTO wmw_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Peduru nakusowera naye, kengira pansana, kawasingana wanu wengi wajumana, ");
INSERT INTO wmw_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","akikola kuwambira: “Umwe mukwijiwa kuwa Yahudi aajuzi kusanganyika au kuwandikana naye munu Saari-Yahudi. Fala Mwenyezimungu kanifahamisha munu nisimwite nnyafu wala haramu. ");
INSERT INTO wmw_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ndimana panitiwe, nija epa ka moyo radi. Kwa javyo, munitira kinani?” ");
INSERT INTO wmw_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Koroneliyu akinjibu: “Bandi ya suku nne, nowu wakati wa alhanswiri‑wu, nikilebela duwa nnyumba mwangu‑mu. Kwa mpunde nimmona munu kemira mbere yangu, kavala mavazi melupa akumensa-mensa, ");
INSERT INTO wmw_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","akinambira: ‘Koroneliyu, isikiriwa duwa yako‑yo pamoja na zaka yaulavyanga‑yo vyankukumbukiriwa mbere ya Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Kwa javyo, ntume munu Yafa akantware Ansumani atapiriwe zina ra Peduru. Iye kafikira nyumba ya Ansumani, nsuwaji sambala, akwikala nanyenje ya mwani.’ ");
INSERT INTO wmw_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ndimana, nitumiza kukwita upesi-upesi, na uwe kutenda sana kuja. Epa sambi piya tijumana nopa mbere ya Mwenyezimungu kusikira piya vyaakwamurire Mola.” ");
INSERT INTO wmw_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Basi, Peduru akanza kusowera, akamba: “Ka ukweli, nereriwa kuwa Mwenyezimungu wanu piya awatafiti sawa‑sawa. ");
INSERT INTO wmw_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Wanu wa kabila mojawapo wakumópa na wakuténda shariya, iye awapokerera. ");
INSERT INTO wmw_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Mukwijiwa habari Mwenyezimungu zawaperekere waIziraeli, kupata kuwereza usalama julu ya Insa Almasihi. Iye ndi Mwenye wa wanu piya. ");
INSERT INTO wmw_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Umwe mukwijiwa vinu vikunire inti ya Yudeya piya, mwanzo wa Galileya, bandi ya koza kakerezanga Yahaya. ");
INSERT INTO wmw_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Mukwijiwa kuhusu Insa nNazareti namuna Mwenyezimungu vyaantawaze kwa Roho Takatifu na vyaampere uwezo. Mukwijiwa kuwa iye kenenda kila upande, akiwatenda wanu vyema, na akiwaponesa piya wenye kutabishiwa na mashetwani konta Mwenyezimungu ákiwa pamoja naye. ");
INSERT INTO wmw_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ofwe tiwa mashahidi wa piya vyaatendire Insa, inti za Mayahudi na Yerusalemu. Ikisa tena ewo wamûlaya, wangomezera pamuti. ");
INSERT INTO wmw_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Fala suka ya tatu, Mwenyezimungu munu‑yu kanfufula na kamolota baina awoniwe, ");
INSERT INTO wmw_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","siyo kuwa wammona wanu piya, ila kawoniwa na mashahidi watondoriwe mida na Mwenyezimungu, ofwe tirire na tinywere naye, bandi ya iye kufufuka ka wafwi. ");
INSERT INTO wmw_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Iye katilaizira tiwereze wanu, tilavye ushahidi kuwa iye ndi ire atomoriwe na Mwenyezimungu awe mwenyé kuwalamula wari hai na wafwire. ");
INSERT INTO wmw_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Piya minabii walavya ushahidi kuhusu noyu, wamba kuwa piya wenye kumwamini onse wapata kuswamiiwa madambi, kwa zina rake.” ");
INSERT INTO wmw_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Peduru kuno akisowera novire, Roho Takatifu akiwesukira piya wanu wakisikira usowezi ware. ");
INSERT INTO wmw_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Mayahudi makamilifu wampereke Peduru ware, watajabu pakulu sana konta Roho Takatifu kawamiminira novyo wanu Sawari-Mayahudi. ");
INSERT INTO wmw_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Kamana wawasikira wakisowera luga sazijiwikana, kuno wakinsifu Mwenyezimungu. Ikisa Peduru akijibu, ");
INSERT INTO wmw_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","akamba: “Ewa wanu‑wa wampokerera Roho Takatifu kamba ofwe. Akataza maji koziwa ewo nani?” ");
INSERT INTO wmw_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ikisa Peduru akamuru wakoziwe kwa zina ra Insa Almasihi. Mwinsho, wakinlebela Peduru wekare naye muda wa suku aba. ");
INSERT INTO wmw_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Sambi, mawalii na wenye kwamini inti ya Yudeya piya wasikira kuwa wanu Sawari-Mayahudi wakubali usemi wa Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Peduru, paafikire Yerusalemu, akisutumiwa na wenziwe ware wataiwe itani ware. ");
INSERT INTO wmw_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Ewo wakamba: “Uwe kwingira nyumba ya wanu sawatayiwe itani, ikisa tena kurya nawo pamoja!” ");
INSERT INTO wmw_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Fala Peduru akanza kuwambira vyavifulatane, akamba: ");
INSERT INTO wmw_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Omi níkiwa kaya ulu ya Yafa níkilebela duwa. Noparepare, inisukira ruhuya. Niwona kinu karibu yangu cakulanda nguwo ulu ikilawa binguni, yakuwa na malunsa mane ikinitelemukira panikiwa pare. ");
INSERT INTO wmw_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Panikinang'aniza sana, nkati mwake niwawona manyama wa maulu mane, nyama za nundu, wadudu wakurikweta pansi, pamoja na nyuni za julu. ");
INSERT INTO wmw_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ikisa nisikira novyo shauti ikinambira: ‘Lamuka Peduru, usinje, urye!’ ");
INSERT INTO wmw_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Nikilawa omi nikijibu: ‘Sishubutu, Mwenye! Sinarya kinu kinyafu wala ca haramu.’ ");
INSERT INTO wmw_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Shauti ya mbinguni ire ikinambira tena javi: ‘Usite haramu kinu caahalalishe Mwenyezimungu.’ ");
INSERT INTO wmw_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Evi vinikuna mara natu, ikisa nguwo ire ikiludisiriwa binguni. ");
INSERT INTO wmw_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Kwa mpunde noure, wanawalume watatu wakija mpaka nyumba yanifikire ire. Ewo wakilawa Kaisariya wâtumiwa kwangu omi. ");
INSERT INTO wmw_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Roho wa Mwenyezimungu kanambira nilawe nuke na wanu ware, nisiwe na wasi-wasi nawo ingawa siwo Mayahudi. Tikilongozana na wanduzangu sita ware. Nakufika tikingira nyumba ya ire atumire ire. ");
INSERT INTO wmw_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Basi iye akanza kutereza namuna vyaammonire laika pakaya pake, emire akamba: ‘Watume wanu Yafa wakantware Ansumani Peduru. ");
INSERT INTO wmw_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Iye akwambira usowezi wakukuvusha uwe pamoja na jamaa zako.’ ");
INSERT INTO wmw_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Pananzire kusowera nawo, akiwesukira Roho Takatifu, kamba vyaanzire kutisukira ofwe. ");
INSERT INTO wmw_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Na nikumbukira vyaasemire Mwenye Insa kuwa: ‘Ndi kweli kuwa Yahaya koza na maji, fala umwe mukuja koziwa na Roho Takatifu.’ ");
INSERT INTO wmw_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Sambi, ikiwa Mwenyezimungu kawapa wanu ware uwezo mmoja kamba vyatipere ofwe novyo, patimwaminire Mwenye Insa Almasihi, omi ndi nani wakubishana na Mwenyezimungu?” ");
INSERT INTO wmw_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ewo pawasikire usowezi‑wu wakitengemana, wakintukuza Mwenyezimungu, wakamba: “Wanu Sawari-Mayahudi newo novyo Mwenyezimungu kawapa kutubiya, wapate mainsha a milele.” ");
INSERT INTO wmw_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Wenye kwamini watawanyikana kwa sababu ya kulumbatiwa kulawirire bandi ya kufwa Shitefanu. Wengine wakuka inti ya Foinikiya, wengine Kiporo, na wengine Antiyokiya. Wakipita wakereza habari ya Insa, ila wakiwereza Mayahudi tu basi. ");
INSERT INTO wmw_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Fala wengine wa Kiporo na wa Kireni woka mpaka Antiyokiya, nokurekure wakisowera novyo na wanu Sawari-Mayahudi, wakiwereza kuhusu Mwenye Insa. ");
INSERT INTO wmw_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Na uwezo wa Mola úkiwa pamoja newo. Wanu wengi wakinkubali Mwenye Insa. ");
INSERT INTO wmw_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Habari‑zi zisikirikana jamati ya Yerusalemu, newo wakintuma Barinaba oke Antiyokiya. ");
INSERT INTO wmw_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Barinaba paafikire nakuwona neema ya Mwenyezimungu kawa radi, na kawarimbisa myoyo piya ware walungane na Mwenye wawe na niya ya mmoyo. ");
INSERT INTO wmw_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Kamana Barinaba ákiwa munu mwema, wakumwijala Roho Takatifu na waminifu. Na wakongezeka wanu wengi wawenye upande wa Mwenye Insa. ");
INSERT INTO wmw_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ikisa Barinaba akilawa akuka Tarusu kupita akinsakula Saulu. ");
INSERT INTO wmw_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Nakunsingana, akinsukula mpaka Antiyokiya. Wakijumana nokurekure mwaka nzima pamoja na jamati ya Antiyokiya, mwawákiwafunda wanu wengi wawenye. Na Antiyokiya kure, wanafunzi ndi kawanzire kwitiwa “wafulati wa Insa”. ");
INSERT INTO wmw_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Kwa nozire suku zire, minabii wengine wâlawa Yerusalemu wakuka Antiyokiya. ");
INSERT INTO wmw_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Katika kundi rawo, munu mmoja wakwitiwa Agabu akilamuka, na kwa uwezo wa Roho Takatifu akiwambira: “Ikuja njala ulu futi ulumwengu nzima‑wu.” (Eyo njala‑yo kweli-kwelini ikija ikilawirira wakati wa Klaudiyu.) ");
INSERT INTO wmw_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Basi wanafunzi wakinuwiya kuwasaidiya wenziwawo wakiinshingi Yudeya, kila mmoja kacanga cawere nawo. ");
INSERT INTO wmw_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Newo wakitenda novire, wakipereka ka walongozi wa jamati mmakono mwa Barinaba pamoja na Saulu. ");
INSERT INTO wmw_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Kwa nowo wakati‑wo, nfalume Herodi akitumiza kuwatabisha wanu wamojawapo wa jamati kwa kutumira makono awo. ");
INSERT INTO wmw_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Iye kamulaya na upanga Yakobu nduye Yahaya. ");
INSERT INTO wmw_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Pawonire kuwa Mayahudi viwajibu, Peduru novyo akinfunga. (Evyo vikuna wakati wa jambo ra Mayahudi ra “Mikate saina furumento”). ");
INSERT INTO wmw_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Nakunkola akintaya nkalaboshu, akingabizi mmakono mwa vipinga vine vya masurudadu wane‑wane wakipitisana. Mpango wake úkiwa olotiwe mbere ya wanu bandi ya suku ya Pashukwa. ");
INSERT INTO wmw_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Kwa javyo, Peduru akifungiwa nkalaboshu, kuno jamati ikinlebelela duwa mpunde-mpunde ka Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ifikire karibu Herodi kumolota Peduru mbere ya wanu, noire suku ire usiku wake Peduru kâlala kati-kati ya masurudadu wawiri, afungiwe na alucema kuno na kuno. Wákiwepo masurudadu wengine wêkala panryango wa kalaboshu ire. ");
INSERT INTO wmw_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Mpunde noure akimwisukira laika wa Mola, nkalaboshu mure ikijala nuru mukilangala vu! Laika akintikinya weya Peduru akinlamusa, akimwambira javi: “Lamuka upesi!” Unyolo ure ukinvurika makono mure ukigwa, iyaii! ");
INSERT INTO wmw_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Laika ire akimwambira javi: “Vala ukanda na viratu vyako.” Peduru akitenda novire. Laika ire akamba tena: “Vala koti rako mmaweya‑mo, unifulate.” ");
INSERT INTO wmw_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Iye akilawa akinfulata, sejiwa kuwa vyakweli vyaakikunisha laika ire, akitula kamba ári kulota. ");
INSERT INTO wmw_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ewo, bandi yakumpunda surudadu wakwanza na wapiri, wakifika panryango wa cuma wakulawira nkaya. Ukifunguka wanyewe, newo wakilawa, wakidanira mbarabara. Kwa mpunde noure, laika ire akilainika. ");
INSERT INTO wmw_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Noure wakati ure, Peduru akifahamu vikunire vire, akamba: “Sambi ndi panijiwe kweli-kwelini kuwa Mola kampereka laika wake, kaninusuru mmakono mwa Herodi na piya vyawalangele kunitenda Mayahudi.” ");
INSERT INTO wmw_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Paakiwaza javire, Peduru akifika kwawo Mariyamu, mamaye Yahaya ákitiwanga kwa zina rengine Maruku. Noko ndi kawajumane wanu wengi wakinlebelela duwa. ");
INSERT INTO wmw_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Peduru nakufika, akibiya nryango wa kubalakãu. Ntumisi wakwitiwa Roza akilamuka akuka kwitika hodi ikilombiwa ire. ");
INSERT INTO wmw_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Paamanyire kuwa shauti ya Peduru, akitenda radi pakulu sana, akasa kufungula nryango, akituwirira pansana, akereza akamba: “Umwe! Peduru ndi ari kulomba hodi.” ");
INSERT INTO wmw_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Fala ewo wamwambira, wamba: “Uwe kunamava.” Fala iye akakikisha kanguvu: “Kweli!” Sambi ewo wakinjibu: “Siyo iye, laika wake.” ");
INSERT INTO wmw_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Basi sambi, Peduru akizidi kwibiya nryango ure kim-kim-kim! Mwinsho, pawafungure wammona Peduru, mama! Wakitajabu pakulu futi! ");
INSERT INTO wmw_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Iye akiwatendera alama na makono ipate wanyamare. Sambi, akikola kuwereza namuna Mola vyaanlavire nkalaboshu. Ikisa akiwambira: “Ezi habari‑zi mwerezeni Yakobu na wajamaa wengine.” Nakulawa, akuka upande mwengine. ");
INSERT INTO wmw_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Pakucere subuu, masurudadu wanza kufazaika pakulu sana. Awakijiwa cinkunire Peduru. ");
INSERT INTO wmw_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herodi akitumiza asakuriwe Peduru. Paatowire kuwoneka, akiwadairi masurudadu ware, na akamuru wolaiwe. Mwinsho, Herodi akilawa Yudeya, akuka akikala Kaisariya suku aba. ");
INSERT INTO wmw_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Sambi, Herodi kakimiyana nawo pakulu wanu wa Tiru na wa Sidoni. Basi ewo wakijumana wakuka wakisowera naye. Ewo wanza kunfika Balashitu, nkolakazi maalumu wa nyumba ya nfalume awasaidiye. Ikisa wakinlebela Herodi wapatane naye kwa usalama konta ewo inti ya Herodi nokure ndi kawakukanga wakipata vyakurya. ");
INSERT INTO wmw_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Suku Herodi yaâturire kusowera na wanu ware, iye kavala mavazi a kifalume, akikala pakiti cake, akanza kuwapa habari mbere yawo. ");
INSERT INTO wmw_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Basi wanu wakibiya kilulu. Lu‑lu‑lu! Wakamba: “Eyo asowera‑yo nlungu, siyo mwanadamu!” ");
INSERT INTO wmw_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Kwa noure mpunde ure, laika wa Mola akimwibiya Herodi, konta aampere utukufu Mwenyezimungu! Ndimana, Herodi akifwa, akiriwa na nvunyo. ");
INSERT INTO wmw_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Sambi, usemi wa Mwenye ukereziwa, na inti ire piya ukizidi kwenera. ");
INSERT INTO wmw_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barinaba na Saulu, pawatimize kazi zawo, wakiludira Yerusalemu kure, wânsukula Yahaya wakwitiwa Maruku. ");
INSERT INTO wmw_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Nkati ya jamati ya Antiyokiya, wákiwapo minabii na wanlimu. Kati ya ewo, wákiwapo Barinaba, Ansumani (zina rengine akitiwa “Mwerufi”), Lukiyu nKireni, Manaheni (rafiki yake nfalume Herodi tangu usimana wawo) pamoja na Saulu. ");
INSERT INTO wmw_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Suku moja, pawákitenda ibada ya Mwenye pamoja na kufunga, Roho Takatifu kawambira javi: “Walavyeni sambi‑pa Barinaba na Saulu wawe wangu omi, watende kazi maalumu yaniwetire.” ");
INSERT INTO wmw_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Basi, pawesire kufunga na kutenda duwa, wawatula makono ikisa wakilayana nawo wakuka. ");
INSERT INTO wmw_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Kwa javyo, Barinaba na Saulu, kwa kuperekiwa na Roho Takatifu, wakilawa wakukirira Selukiya. Nokurekure wakiripakira, wakuka na batela mpaka Kiporo. ");
INSERT INTO wmw_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Nakufika Salamina, wakanza kwereza usemi wa Mwenyezimungu mmasinagoga a Mayahudi. Wákiwa pamoja na Yahaya akiwasaidiya. ");
INSERT INTO wmw_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Wenenda kisirwa ca Kiporo piya mpaka wafika Pafu. Nokurekure wansingana Yahudi mmoja wakwitiwa Bar-Insa. Iye ákiwa nabii nlongo na nsawi. ");
INSERT INTO wmw_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Iye ákiwa pamoja na nfalume wa kisirwa cire wakwitiwa Seruju Paulu, mwananlume mwerevu. Eyu akiwarifu Barinaba na Saulu konta akisaka kusikira usemi wa Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Falakini Elima (ndi vyaakitiwa nkigeregu) noire nsawi ire, akibishana nawo Barinaba na Saulu. Akinkenekeza nfalume anzungunuse kwamini. ");
INSERT INTO wmw_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Fala Saulu, kwa zina rengine wawakimwita Paulu, kamwijala Roho Takatifu, akinnang'aniza nsawi ire rungu-rungu, akimwambira javi: ");
INSERT INTO wmw_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Uwe kuwa mwana wa Ibilisi! Ukwijala ulongo na vitendo vya ubaya. Kuwa aduwi wa shariya piya. Ukwasa rini kuzungunusa njira za kweli za Mwenye Insa? ");
INSERT INTO wmw_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Epa sambi, nkono wa Mwenye ubishana nowe. Ukuwa kipofu, kwa muda mojawapo auja kuwona juwa.” Kwa mpunde noure, Elima kumaso kukimwinukala pi. Akizungunuka-zungunuka kunsakula munu ankore nkono, ankongoje. ");
INSERT INTO wmw_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Basi nfalume ire nakuwona vikunire vire, kamini, na katajabu mafundiro a Mwenye. ");
INSERT INTO wmw_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paulu na wenziwe wakilawa Pafu, wakiloka, wakuka Perga ya Panfiliya. Nokurekure, Yahaya akiwasa, akiludira Yerusalemu. ");
INSERT INTO wmw_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ewo wakizidi kusafiri, wakilawa Perga, wakuka mpaka Antiyokiya, inti ya Pisidiya. Suku ya sabadu wakingira nsinagoga, wakikala. ");
INSERT INTO wmw_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Ikisa zikifyomiwa shariya za Musa na mandiko a minabii wengine‑po. Nakisa wakulungwa wa sinagoga wakiwakaribisha Paulu na Barinaba, wakiwambira: “Wanduzangu, ári na usowezi wakuwahurumiya wanu‑wa onse, ereze.” ");
INSERT INTO wmw_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Sambi, Paulu akilamuka, akolosa nkono, akisema: “Wenzangu waIziraeli na umwe muri kumopa Mwenyezimungu: sikirizani sana-sana. ");
INSERT INTO wmw_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Nlungu wa umati waIziraeli‑wu kawatondola babu zetu na kawatula ubora pawákikalanga kiyeni inti ya Miswiri. Kwa nkono wake wa uwezo, kawalamusa kawalavya noyo inti‑yo. ");
INSERT INTO wmw_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Iye pawákiwa nlanga kawavumirira kiyasi ca myaka arubaini. ");
INSERT INTO wmw_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Na bandi ya kupoteza kabila saba inti ya Kanaa, iye kawapa wanu wake kuriti inti yawo, ");
INSERT INTO wmw_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","kiyasi ca myaka miya nne na amusini. Ikisa akiwagabizi mafalume wanguvu mpaka paataware nabii Samuweli. ");
INSERT INTO wmw_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Basi sambi, wanu ware wâlebela wapewe nfalume, na Mwenyezimungu akiwapa Saulu, mwana wa Kishi, mwananlume mmoja wa rikolo ra Benjami. Iye kamiliki myaka arubaini. ");
INSERT INTO wmw_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Nakunlavya Saulu, akintawaza Daudi kuwa nfalume wawo. Kuhusu Daudi, Mwenyezimungu kalavya ushahidi, kaamba javi: ‘Nimmonerera Daudi, mwana wa Yese. Iye nomi moyo wetu mmoja, iye ndi ája kutimiza nafsi yangu piya.’ ");
INSERT INTO wmw_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Kati ya ujukulu wa noyu Daudi‑yu, Mwenyezimungu kawaperekera waIziraeli Nvushi, Insa, kamba iye vyaâwapere tamaa. ");
INSERT INTO wmw_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Kábula ya kuja Insa, Yahaya kâwereza futi wanu piya wa Iziraeli kuwa watubiye dambi zawo, woziwe. ");
INSERT INTO wmw_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Karibu ya kumariza kazi zake, Yahaya kawambira wanu javi: ‘Umwe mudaniza kuwa omi niwa nani? Omi siri Almasihi, ila iye akuja bandi ya omi, na noyo‑yo anta omi siri bora kufungula mizizi ya viratu vyake.’ ” ");
INSERT INTO wmw_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Paulu akizidi kusowera: “Jamaa zangu, ujukulu wa Iburahima na umwe muri kumopa Mwenyezimungu, ijiwani kuwa usemi wakutivusha tiperekeriwa nófwe. ");
INSERT INTO wmw_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Kamana wanu wa Yerusalemu pamoja na wenye mamulaka awamwijiwe Insa wala awejiwe vyawákifundanga minabii vyawakifyomanga kila sabadu. Pawanhukumire kifo, watimiza novyo-novyoni. ");
INSERT INTO wmw_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ingawa awapatire sababu mmojawapo ya kunhukumu Insa kifo, fala wanlebela Pilatu kuwa aulaiwe. ");
INSERT INTO wmw_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Na pawesire kutimiza piya vyavyândikiwe kuhusu iye, wanlavya pansalaba, wanzika nkaburi. ");
INSERT INTO wmw_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Falakini Mwenyezimungu kanfufula ka wafwi. ");
INSERT INTO wmw_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Suku nyingi zawenye, kawalawirira ware wampereke kulawa Galileya kuja Yerusalemu. Na nowo sambi‑pa ndi mashahidi wake mbere ya wanu wa Iziraeli. ");
INSERT INTO wmw_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Nofwe tankukwerezani Habari Ngema kuwa tamaa yawâpewe wababu zetu, ");
INSERT INTO wmw_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","noyo tamaa‑yo Mwenyezimungu katimiza kwetu ofwe, ujukulu wawo, kwa kunfufula Insa. Kamba vyavyandikiwe nZaburi yapiri: ‘Uwe kuwa mwanangu, mwanzo wa rero omi niwa wawayo.’ ");
INSERT INTO wmw_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ndi ntamana kuhusu habari ya kufufuka ka Insa, Mwenyezimungu kakikisha kuwa mwiri wake aushubutu kuvunda. Iye kasema javi: ‘Nukutenderani mambo takatifu kwa tamaa kamili zanîmpere Daudi.’ ");
INSERT INTO wmw_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ndimana mahala pengine iye kaamba javi: ‘Uwe Ntakatifu wako aumwasa kuvunda nkaburi.’ ” ");
INSERT INTO wmw_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Paulu kasema tena: “Kusema kweli, Daudi kafwa bandi ya kutumika vyanuwiye Mwenyezimungu kati ya kizazi cake. Nakisa iye kazikiwa pawazikiwe wababuze, na kavunda. ");
INSERT INTO wmw_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Fala mwiri wa ire afufuriwe na Mwenyezimungu, aavundire. ");
INSERT INTO wmw_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Kwa javyo, jamaa zangu, ijiwani kuwa julu ya noyu‑yu, mwankwereziwa habari ya kuswamiiwa madambi enu. Julu yake iye, piya wenye kumwamini wavushiwa. ");
INSERT INTO wmw_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Kusema kweli, ewo awavushiwa julu ya shariya ya Musa. ");
INSERT INTO wmw_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Basi, more-moreni visukukuneni kamba vyawandike minabii, wakamba: ");
INSERT INTO wmw_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Onani umwe, wenye kukejeli! Mususuka, na mupoteya, konta suku ndi suku nukutenderani kinu, umwe amushubutu kukubali, anta pawepo munu wakukwerezani.’ ” ");
INSERT INTO wmw_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pawalawire Paulu na Barinaba, wanu ware wakiwatafadali, wakamba: “Sabadu ija‑yo, musikose kutereza tena nowu usowezi‑wu.” ");
INSERT INTO wmw_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Pawesire kutawanyikana pasinagoga pare, Mayahudi wengi pamoja na wanu wengine waminire dini ya kiyahudi, wanfulata Paulu na Barinaba. Ewo wakisowera nawo, wakiwataya niya iwazidise kuwa nkati ya rehema ya Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Paifikire sabadu nyengine ire, aâbakire munu, wanu wengi nkaya mure wajumana kusikira habari za Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Mayahudi, pawawawonire wanu kuwa wengi, wanza kuwatendera wiyana, wakinkaidi Paulu kuno wakikufuru. ");
INSERT INTO wmw_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Fala Paulu na Barinaba, kwanguvu wakiwambira: “Iwa lazima usemi wa Mwenyezimungu kwanza mwambiriwe umwe. Falakini kwa kuwa mukatala na mukolota kuwa amujuzi kuwa na mainsha a milele, basi, tilawa tuka kuwereza wanu Sawari-Mayahudi. ");
INSERT INTO wmw_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Kamana Mola ndi vyaatamurire javyo: ‘Omi nukutula kuwa nlangaza wa Sawari-Mayahudi, ipate wanu ulumwengu nzima‑wu wavushiwe.’ ” ");
INSERT INTO wmw_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Sawari-Mayahudi, pawasikire habari zire, watenda radi na watukuza usemi wa Mwenyezimungu. Basi wakubalire ndi ware watondoriwe wawe na mainsha a milele. ");
INSERT INTO wmw_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Na usemi wa Mola ukereziwa inti ire piya. ");
INSERT INTO wmw_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Fala Mayahudi wakiwashongezera wanawaka mamuminu wa vyewo vikulu-vikulu pamoja na walume wakwinshimika wa nkaya mure, wakanza kuwabugudi Paulu na Barinaba, wakiwatuwisira panja ya mipaka yawo. ");
INSERT INTO wmw_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Basi, mawalii ware wakiripumuna vunvu mmaulu mwawo, wakuka Ikoniyu. ");
INSERT INTO wmw_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Na wanafunzi ikiwejala radi pakulu futi pamoja na Roho Takatifu. ");
INSERT INTO wmw_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Kaya ya Ikoniyu, Paulu pamoja na Barinaba woka wengira nsinagoga ya Mayahudi, wasowera kwa namuna yakuwa wanu wengi Mayahudi na ware Sawari-Mayahudi wakamini. ");
INSERT INTO wmw_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Fala Mayahudi sawakamini ware wawashongezera na wakimwisa roho za ware Sawari-Mayahudi ipate wakimiyane nawo wanduzawo waminire ware. ");
INSERT INTO wmw_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Kwa javyo, Paulu na Barinaba wekala nokure suku nyingi zawenye. Ewo wákisoweranga habari ya Mwenye Insa bila kuropereza, na wakilavya ushahidi kuhusu usemi wa neema yake. Na Insa akwakikisha usemi‑wo, kwa kuwajanliya alama na matajabisa awakitenda julu ya makono awo. ");
INSERT INTO wmw_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Wanu nkaya mure wakawanyika bandi mbiri: wengine wakiwapendeleya Mayahudi, wengine wakiwapendeleya mawalii. ");
INSERT INTO wmw_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Basi, Sawari-Mayahudi wamojawapo na Mayahudi pamoja na wakulungwa wawo, wakanza kuwatabisha na kuwapanja na mawe. ");
INSERT INTO wmw_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Ndimana, Paulu na Barinaba pawejiwe, wakitirira Lishitera na Deribi, makaya a inti za Likawoniya, na inti nyengine jirani. ");
INSERT INTO wmw_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Nokurekure wakerezanga Habari Ngema. ");
INSERT INTO wmw_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Lishitera ákiwapo munu mmoja kitewe wa kipongorero, tangu ákiwa saanamba kwenenda. ");
INSERT INTO wmw_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Noire kitewe ire kansikira Paulu akisowera. Paulu akinang'aniza rungu-rungu, akiwona kuwa akwamini kuponesiwa, ");
INSERT INTO wmw_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ndimana akimwambira na shauti ulu‑ulu: “Lamuka, wimire sana-sana!” Kitewe ire akitupa, akanza kwenenda-nenda. ");
INSERT INTO wmw_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Wanu pawawonire vyaatendire Paulu vire, wakanza kutamba kwa luga ya Likawoniya, wakipaza wakamba: “Milungu itisukira, nfano wa wanadamu!” ");
INSERT INTO wmw_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Barinaba wakimwita nlungu Zeyu, na Paulu wakimwita nlungu Herimeyu, konta Paulu ndi akisowera. ");
INSERT INTO wmw_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Nlongozi wa dini ya Zeyu ákiwa karibu ya kaya ire, kwa javyo akija mpaka panryango pare, kaja nawo ng'ombe na maluwa. Iye na junudi ya wanu ware wakisaka kutenda kafara ya manyama. ");
INSERT INTO wmw_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Fala mawalii Barinaba na Paulu, pawasikire, wapapula mavazi awo, wawatuwirira wanu ware, wakiwambira na shauti ulu‑ulu, wakamba: ");
INSERT INTO wmw_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Wanduzangu! Eci camutenda‑ci kinani? Ofwe tiwa wanadamu kamba nomwe! Tiwa epa tukwerezeni ipate mwase evi vinu savina mana‑vi, muludire upande wa Nlungu hai ombire bingu, ardhi, bahari, pamoja na piya viripo nkati yake. ");
INSERT INTO wmw_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Vizazi vipitire, Mwenyezimungu kâsa mataifa piya wafulate njira zawo wanyewe. ");
INSERT INTO wmw_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Fala aasire kolota ushahidi wake kuhusu vitendo vyake vyema vyaatendanga. Iye apereka nvula kulawa binguni na mavuno a kila mbeyu na mirongo yake, akupani cakurya camusaka, na akwijaza radi myoyo yenu.” ");
INSERT INTO wmw_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ingawa mawalii ware wasema javire, fala wákiwa nawo tafauti yakuwakataza kutenda kafara yawo. ");
INSERT INTO wmw_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ikisa, wakija Mayahudi wamojawapo kulawa Antiyokiya na Ikoniyu. Wakiwashetwani wanu ware, wakikola kumpanja Paulu na mawe, na wakinkwekwetera panja ya kaya ire, wakidaniza kuwa kafwa. ");
INSERT INTO wmw_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Fala wanafunzi pawanzungurize Paulu, iye kalamuka, kengira tena nkaya nomure. Subuu yake, Paulu na Barinaba woka Deribi. ");
INSERT INTO wmw_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Paulu na Barinaba wereza Habari Ngema Deribi, na bandi ya kuwapata wanafunzi wengi, waludira tena Lishitera, Ikoniyu, na Antiyokiya. ");
INSERT INTO wmw_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Wakipita wakiwarimbisa myoyo wanafunzi, na wakiwataya nguvu wabaki wakamini. Wakiwahurumiya javi: “Piya tíri kuwamini tíjuzi tikune mashaka mengi tingire muufalume wa Mwenyezimungu.” ");
INSERT INTO wmw_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Mawalii ware wakipita kila jamati, wakiwatondola wakulungwa wa jamati zire. Bandi yakulebela duwa na kufunga, ewo wakingabizi Mola wawamwaminire. ");
INSERT INTO wmw_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ikisa wapita inti ya Pisidiya, mpaka wakifika inti ya Panfiliya. ");
INSERT INTO wmw_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Bandi yakuwereza wanu wa Perga usemi wa Mwenyezimungu, wakuka Ataliya. ");
INSERT INTO wmw_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ikisa wakiripakira mbatela wakuka Antiyokiya. Noko ndi kawâlebeleliwe duwa wapate rehema ya Mwenyezimungu watende kazi yawatimize. ");
INSERT INTO wmw_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Pawafikire Antiyokiya kure, wakiwajumanisa wenye jamati, wakanza kuwambira piya vyaakunishe Mwenyezimungu julu yawo, na wakiwambira Mwenyezimungu vyawafungurire miryango wanu Sawari-Mayahudi newo wamini. ");
INSERT INTO wmw_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Basi, wekala noko na wanafunzi ware suku nyingi zawenye. ");
INSERT INTO wmw_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Sambi, wamojawapo wakilawa Yudeya wakuka Antiyokiya, wakiwafunda wenye kwamini javi: “Umwe, ikiwa amutaiwe itani kamba vyaisema tabiya ya Musa, amuvushiwa.” ");
INSERT INTO wmw_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Paulu na Barinaba wakanza kubishana na kukaidiyana nawo wanu ware pakulu. Basi, vikilamuriwa kuwa wo‑wawiri walawe na wanu wamojawapo woke Yerusalemu, ukasoweriwe ewu mwaha‑wu na mawalii pamoja na wakulungwa wa jamati. ");
INSERT INTO wmw_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Kwa javyo, wakisafiriziwa na jamati, wakipita Foinikiya na Samariya, wakereza sana piya viwakunire wanu Sawari-Mayahudi vyawamwaminire Mwenyezimungu. Habari zire ziwafuraisha pakulu sana piya wenye kwamini ware. ");
INSERT INTO wmw_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Pawafikire Yerusalemu, ewo wapokereriwa sana-sana na jamati na mawalii pamoja na wakulungwa. Ewo wakiwambira vyaakunishe Mwenyezimungu julu yawo. ");
INSERT INTO wmw_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Fala Mayahudi wengine, wenye kwamini wákiwa nkonjo wa Mafarizeu, walamuka, wakamba: “Lazima wataiwe itani na walazimishiwe kufulata shariya za Taureti.” ");
INSERT INTO wmw_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Mawalii na wakulungwa ware wakijumana kushauriyana noure mwaha ure. ");
INSERT INTO wmw_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Pawesire kukaidiyana pakulu, Peduru akilamuka akiwambira javi: “Jamaa! Umwe mukwijiwa kuwa tangu mida, Mwenyezimungu kanitondola kati yenu ipate Sawari-Mayahudi wasikire julu yangu Habari Ngema na wakubali. ");
INSERT INTO wmw_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Mwenyezimungu, Mwenyé kwijiwa myoyo piya, kakikisha kuwa awakubali Sawari-Mayahudi julu ya kuwapa newo novyo Roho Takatifu, kamba vyatipere ofwe. ");
INSERT INTO wmw_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Iye asiyanise kinu kati yetu ofwe newo, kawaswafi myoyo yawo julu ya kwamini. ");
INSERT INTO wmw_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Kwa javyo, mbena mumyerera Mwenyezimungu? Wanafunzi muwatika mizigo yakuwa wababu zetu awakidirire wala ofwe atikidiri, sababuni? ");
INSERT INTO wmw_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Kwasa javyo, ofwe‑pa tukwamini kuwa tivushiwa julu ya rehema ya Mwenye Insa, kamba vyawavushiwe ewo novyo.” ");
INSERT INTO wmw_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Kundi ra wanu ware piya wanyamala vii. Wakiwasikiriza Barinaba na Paulu wakereza kuhusu alama na matajabisa atendire Mwenyezimungu julu yawo kati ya ware Sawari-Mayahudi. ");
INSERT INTO wmw_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Pawesire kusowera, Yakobu akijibu, akamba: “Jamaa, nisikirizeni omi. ");
INSERT INTO wmw_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Ansumani kankutereza namuna Mwenyezimungu vyaanzire kutunza mataifa ipate kati yawo awatondore wanu wawe upande wa zina rake. ");
INSERT INTO wmw_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Evi ndi sawa‑sawa kamba masemo a minabii, vyaamba javi: ");
INSERT INTO wmw_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Bandi ya evyo, omi niludi. Nyumba ya Daudi igwire‑yo nijenga tena upya. Vipama vibomoke-vyo nilamusa, nijenga tena upya, ");
INSERT INTO wmw_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","ipate wanu wabakire wansakure Mola, na Sawari-Mayahudi piya wakuwa zina rangu ritajiwa julu yawo, newo novyo wansakure. Javi ndi vyaasowere Mola aténda vinu‑vi ");
INSERT INTO wmw_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","vinu vijiwikane tangu mida.’ ” ");
INSERT INTO wmw_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Yakobu akizidi kusowera, akamba: “Ndimana omi niwona kuwa tisiwatabishe Sawari-Mayahudi wari kuja ka Mwenyezimungu‑wa. ");
INSERT INTO wmw_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Vitosha kuwandikira kuwambira wakatare vyakutenderiwa kafara maswanamu, pamoja na nyama zakupotiwa, wasinywe damu, na wasiwe na lukware. ");
INSERT INTO wmw_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Kamana tangu-tangu vizazi vya mida, kila kaya wawapo ware wereza shariya za Musa, zifyomiwanga mmasinagoga kila sabadu.” ");
INSERT INTO wmw_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ikisa, mawalii, wakulungwa, pamoja na wanu piya wa jamati wawona kuwa vyema wawatondore wanawalume wamojawapo kati yawo wawapereke Antiyokiya, woke na Paulu pamoja na Barinaba. Na wakitondoriwa Yuda (atapiriwe zina rengine Barisaba) na Sila, wawere wakulungwa wa jamati ire. ");
INSERT INTO wmw_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ewo wakandika waraka na makono awo wakamba javi: “Ofwe mawalii na wakulungwa, pamoja na wanduzenu, tukuperekerani salamu wenye kwamini Samuri-Mayahudi, muri kuinshi Antiyokiya, Siriya na Kilikiya. ");
INSERT INTO wmw_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Kwa kuwa tisikira kuwa wanawalume wamojawapo munkonjo mwetu‑mu, wataya tafauti myoyo yenu, (ingawa atiwapere mamulaka akutenda javyo), ");
INSERT INTO wmw_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","tiwona kuwa vyema (kwa kuwa tisikizana kwa niya moja) tiwatondore maámiri, tiwatume kwenu umwe. Ewo tankuwapereka pamoja na wapendani wetu Barinaba na Paulu, ");
INSERT INTO wmw_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","wanu watula hatari mbere ya mainsha awo, kwa ajili ya zina ra Mwenye wetu, Insa Almasihi. ");
INSERT INTO wmw_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Kwa javyo, tiwapereka Yuda na Sila, ewo wanyewe wakwambirani novyo novyoni. ");
INSERT INTO wmw_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Kamana tiwaza kuwa vyema upande wa Roho Takatifu pamoja nofwe kuwa hapana tena nzigo nkulu wakukulazimishani, saviri novi visakikana‑vi: ");
INSERT INTO wmw_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Mukatare vyakutenderiwa kafara maswanamu, pamoja na nyama zakupotiwa, musinywe damu na musiwe na lukware. Mukinarira piya‑vi, mutenda vyema. Salamu zenu nyingi sana.” ");
INSERT INTO wmw_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Sambi, watondoriwe ware wakilaya, wakisukira Antiyokiya. Nakufika kure, wakiwajumanisa wenye kwamini ware, wakiwagabizi waraka ire. ");
INSERT INTO wmw_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ewo pawesire kufyoma waraka ire, masemo are awataya radi pakulu sana. ");
INSERT INTO wmw_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yuda na Sila, kwa kuwa wákiwa minabii, wakereza masemo mengi a kuwahurumiya wenye kwamini, kuwataya nguvu roho zawo. ");
INSERT INTO wmw_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Bandi yakwikala nokure suku aba, wakilayana nawo wenye kwamini kwa salama, wakiwapereka kawatumiwe kure. ");
INSERT INTO wmw_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Ila Paulu na Barinaba wakibaki Antiyokiya. Ewo, pamoja na wanu wengine wengi wawenye, wakifunda na wakereza usemi wa Mwenye Insa. ");
INSERT INTO wmw_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Bandi ya kupita muda wa suku aba, Paulu kamwambira Barinaba: “Tuke tiludire tena tipite tikiwawona jamaa zetu piya wa makaya atipitire tikereza Habari Ngema za Mwenye. Tikawawone vyawari kwenenda.” ");
INSERT INTO wmw_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barinaba vikimwajibu amwarifu Yahaya ákitiwa kwa zina rengine Maruku woke onse. ");
INSERT INTO wmw_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Fala Paulu kawona kuwa ewo‑po awajuzi kunsukula, konta kâwatira pawakiwa Panfiliya, kazi sainesa. ");
INSERT INTO wmw_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Basi, wakikola kubishana watupu pakulu futi mpaka wakisapukana kila mmoja. Barinaba akintwala Maruku, wakilokera Kiporo. ");
INSERT INTO wmw_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Paulu akintondola Sila, akilawa naye wakuka vyawo, bandi ya wenye kwamini kuwalebelela duwa wapate rehema za Mola. ");
INSERT INTO wmw_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Iye akipita Siriya na Kilikiya, akiwataya nguvu jamaa wa jamati. ");
INSERT INTO wmw_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paulu kafika makaya a Deribi na Lishitera. Noko ákiwapo mwanafunzi mmoja akitiwa Timotiyu, mwana wa mwanamuka Yahudi mwenyé kwamini, ila wawaye ákiwa nGeregu. ");
INSERT INTO wmw_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Wenye kwamini wa Lishitera na Ikoniyu wakilavyanga ushahidi wakunsifu Timotiyu. ");
INSERT INTO wmw_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paulu akisaka ansukure Timotiyu‑yu ndimana akintaisa itani konta Mayahudi wákikalanga upande wa kaya ire wakijiwa kuwa wawaye aawere Yahudi. ");
INSERT INTO wmw_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Pawákipitanga mmakaya makulu mure, wakereza shuruti zawanuwiye mawalii pamoja na wakulungwa wa Yerusalemu ipate watimize. ");
INSERT INTO wmw_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Kwa javyo, jamati zikitaiwa nguvu nkati ya kwamini, na zíkongezeka kila suku. ");
INSERT INTO wmw_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Paulu na Sila wakipita makaya a Furujiya na Galata. Roho Takatifu aâwasire kwereza habari za Mwenyezimungu Aziya. ");
INSERT INTO wmw_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Pawafikire mpaka wa Misiya, wakenekeza kwingira Bitaniya fala Roho ya Insa aiwamurire kuka. ");
INSERT INTO wmw_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Basi, wakitambala Misiya, wakuka Torowa. ");
INSERT INTO wmw_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Usiku, Paulu ikimwisukira ruhuya, kammona munu wa Makedoniya emire, akintafadali akamba: “Uje Makedoniya, utavye!” ");
INSERT INTO wmw_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Bandi ya Paulu kuwona javire, kwa mpunde noure, tishugulika kulawa kuka Makedoniya. Tiwona kuwa Mwenyezimungu ndi atitire kuka noko, tikawereze Habari Ngema. ");
INSERT INTO wmw_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Basi, tikivuta nanga tikiripakira Torowa, tikuka tanga rimoja mpaka Samotaraki. Subuu yake tikingiza Neyapoli. ");
INSERT INTO wmw_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ikisa tikuka mpaka Filipi, kaya ulu ya porovinsiya ya Makedoniya, tikala suku aba. Noyo kaya‑yo itawariwa na waRoma. ");
INSERT INTO wmw_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Sabadu tikipita panryango wa kaya ire tikilawira panja, tikuka nanyenje ya muto, patikidanizira kuwa mahala pawatendanga ibada. Tikikala, tikanza kupakanira na wanawaka wajumane nopare. ");
INSERT INTO wmw_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Kati yawo, ákiwapo mwanamuka mmoja wakuntukuza Mwenyezimungu, wakwitiwa Lidiya, kwawo Tiyatira. Iye ákiuzanyanga nguwo maalumu za rangi ya njambalãu. Iye akitisikira, na Mola kanfungula moyo wake kutumaini vyaakamba Paulu vire. ");
INSERT INTO wmw_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Nakwisa koziwa iye pamoja na jamaa zake, katitafadali, akamba javi: “Ikiwa mwankuniwona kuwa kamilifu mbere ya Mola, tukeni kwangu, mukekare.” Akanza kutikenekezera. ");
INSERT INTO wmw_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Sambi, patikuka mahala pakulebela duwa, noparepare katilawirira mwari mmoja wakumilikiwa na jini akilauzanga sengere. Ákipatanga faida ya nzuruku mwingi akiwapa watwa wake. ");
INSERT INTO wmw_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Mwari ire akinfulata Paulu pamoja nofwe kuno akikuwa, akamba: “Ewa wanawalume‑wa watumwa wa Mwenyezimungu Nkulu! Ewo wankukwerezani njira ya kuvushiwa!” ");
INSERT INTO wmw_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ákikuwanga suku nyingi zawenye. Basi Paulu akikimiwa, akinzungunukira, akinsowerera na jini ire, akamba: “Uwe jini, nukwamuru kwa zina ra Insa Almasihi, nlawe munu‑yu!” Mpunde noure, jini ire akinlawa. ");
INSERT INTO wmw_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Watwawe ware, pawawonire kuwa iwesira tamaa ya faida yawo ire, wakinkola Paulu na Sila, wakiwavuta mpaka paluwanja, mbere ya mafalume. ");
INSERT INTO wmw_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Pawakiwapereka ka wenye kulamula, wakamba: “Ewa wanu‑wa Mayahudi, wankuwadanganya wanu wa nkaya‑mu! ");
INSERT INTO wmw_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Wankwereza tabiya saziri halali kwetu ofwe kupokerera wala kufulata, kwa kuwa tiwa waRoma.” ");
INSERT INTO wmw_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Basi wanu wakilamuka kaupamoja wakiwokira, na wenye kulamula wakiwavula nguwo zawo kanguvu, wakamuru wacapiwe na bakora. ");
INSERT INTO wmw_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Pewesire kuwacapa pakulu pawenye, ewo wakiwataya nkalaboshu na wakinlaizira amiri wa nkalaboshu awasunge sana. ");
INSERT INTO wmw_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Iye, nakupokerera eyi ámuri‑yi, akiwataya nkisusi, akiwafunga maulu na unyolo akiwafungira pagogo. ");
INSERT INTO wmw_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Usiku kati-kati, Paulu na Sila wakilebela duwa, kuno wakimba nyimbo za kunsifu Mwenyezimungu. Wafungwa wenziwawo wakiwasikiriza. ");
INSERT INTO wmw_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Kwa mpunde noure, ardhi yanza kutetema pakulu, aluserusu ya kalaboshu ikibomoka, miryango piya ikifunguka, na unyolo piya ukiwavurika. ");
INSERT INTO wmw_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Amiri wa nkalaboshu paalamuke na paawonire miryango ya kalaboshu ire iri wanzu, akivuta upanga kusaka kurulaya, konta akidaniza kuwa wafungwa ware watira. ");
INSERT INTO wmw_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Fala Paulu akinkuwira, akamba: “Usirulaye! Ofwe piya tiwapo nomu!” ");
INSERT INTO wmw_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Basi amiri ire akitisa kandiyeru, akituwa akingira nkalaboshu mure kuno akitetema, akigwa mbere ya Paulu na Sila. ");
INSERT INTO wmw_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ikisa akiwalavira panja, akiwadairi: “Mamwenye, kupata kuvushiwa, nijuzi nitende kinani?” ");
INSERT INTO wmw_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ewo wakinjibu: “Mwamini Mwenye Insa, uvuka uwe pamoja na jamaa zako.” ");
INSERT INTO wmw_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Basi wakimwereza usemi wa Mwenyezimungu amiri ire pamoja na piya wakiinshi nawo pakaya pake. ");
INSERT INTO wmw_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Iye usiku-usiku noure, akiwatwala Paulu na Sila, akiwosa vijaraa vyawo. Ikisa, kwa mpunde noure, akoziwa iye pamoja na jamaa zake piya. ");
INSERT INTO wmw_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ikisa, akiwatwala akuka nawo kwake, akiwapa cakurya. Iye pamoja na jamaa zake piya watenda radi pakulu sana, kwa kuwa wamwamini Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Pakucere subuu, wenye kulamula wawatuma masupai wawambira javi: “Kawafungureni wanawalume ware.” ");
INSERT INTO wmw_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Basi amiri wa kalaboshu ire akimwambira Paulu ewu usemi‑wu javi: “Wenye kulamula watumiza nukufungureni, basi lawani, muke kwa salama.” ");
INSERT INTO wmw_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Fala Paulu akiwajibu: “Ofwe waticapa mbere ya wanu, sawatilamure vijuzi, ingawa nofwe tiwa waRoma! Ikisa watitaya nkalaboshu, sambi wasaka watituwise kisiiri-siiri? Javyo sivyo! Basi, waje kuno mafalume‑wo wanyewe, watifungure‑mu!” ");
INSERT INTO wmw_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Masupai ware wakuka wakiwambira habari zire wenye kulamula. Pawejiwe kuwa ewa waRoma, wasusuka. ");
INSERT INTO wmw_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ewo wakija, wakiwatafadali, ikisa wakiwafungula, wakiwalebela walawe nkaya mure. ");
INSERT INTO wmw_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pawalawire nkalaboshu mure, ewo woka mpaka nyumba ya Lidiya. Nokurekure wakiwonana na wenye kwamini. Bandi ya kuwataya niya, wakilawa wakuka vyawo. ");
INSERT INTO wmw_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Paulu na Sila, bandi ya kupita Anfipoli na Ampoloniya, wafika Tesalonika. Noko íkiwapo sinagoga ya Mayahudi. ");
INSERT INTO wmw_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Paulu sabadu natu akuka kusinagoga noko, kamba vyaiwere tabiya yake. Iye akanza kowolotera uhakika wa Mandiko Matakatifu. ");
INSERT INTO wmw_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Iye akifunula akiwelewesha sana kuwa Almasihi akijuzi atabike, ikisa afufuke ka wafwi. Tena akiwambira: “Eyu Insa wanukwambirani umwe‑yu ndi Almasihi.” ");
INSERT INTO wmw_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Basi Mayahudi wengine wakiwakubalisa, wakingira nkonjo wa Paulu na Sila. Novyo, Sawari-Mayahudi wengi wawenye wakuwajibu mambo a Mwenyezimungu pamoja na wanawaka wengi mabora wakisanganyika nawo. ");
INSERT INTO wmw_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Fala Mayahudi wakiwatendera wiyana, wawajumanisa wanawalume wabaya sawana rai, wakiwomanisa nkaya mure. Ikisa wakibisha nyumba ya Yasoni, wakiwasakula Paulu na Sila ipate wawapereke mbere ya wanu ware. ");
INSERT INTO wmw_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Fala kwa kuwa awawasingane, ewo wakinvuta Yasoni na wenye kwamini wengine, wakiwapereka ka mafalume wa kaya ire, kuno wakikuwa javi: “Wapindulanga ulumwengu ware ndiwa‑pa. ");
INSERT INTO wmw_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Yasoni kawapa malazi kwake. Ewa piya‑wa vyawatenda‑vi wankutupa shariya za Kaisari, konta wankwamba kuwa kawapo nfalume mwengine wakwitiwa Insa.” ");
INSERT INTO wmw_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Wanu ware pamoja na mafalume wa nkaya mure, pawasikire vinu‑vi, wakifazaika. ");
INSERT INTO wmw_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Nakupokerera ushuru wa Yasoni pamoja na wenziwe, mafalume ware wakiwafungula. ");
INSERT INTO wmw_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Kwa mpunde noure usiku ure, wenye kwamini ware wawatwala wo‑wawiri Paulu na Sila wawapereka Bereya. Nakufika kure, wakuka sinagoga ya Mayahudi. ");
INSERT INTO wmw_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Mayahudi wa Bereya werevuka koliko wanu wa Tesalonika, kwa kuwa wapokerera habari zire ka moyo radi pakulu. Daima wákifyoma sana Mandiko Matakatifu ipate wawone kuwa vyawakambiriwa na Paulu vire vyakweli. ");
INSERT INTO wmw_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Kwa javyo, wengi kati yawo wakamini. Wákiwa wanawaka mabora wa Sawari-Mayahudi pamoja na wanawalume wengi wawenye. ");
INSERT INTO wmw_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Fala Mayahudi wa Tesalonika, pawejiwe kuwa Paulu kankwereza novyo habari za Mwenyezimungu Bereya, newo novyo wakuka noko, wakiwataya wanu shonge, wakiwafazaisa. ");
INSERT INTO wmw_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Ndimana kwa mpunde noure, wenye kwamini ware wampereka Paulu mwani kukisiko, fala Sila na Timotiyu wakibaki Bereya nokure. ");
INSERT INTO wmw_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Wampéreke Paulu ware wanfikisa mpaka Atena. Bandi ya kulaiziwa habari na Paulu zakuka kumwambira Sila na Timotiyu kuwa woke upesi-upesi noko, ewo wakilawa. ");
INSERT INTO wmw_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Paulu, paakiwarinda Sila na Timotiyu Atena kure, kakafilika kwa kuwona nkaya mure kwijala maswanamu. ");
INSERT INTO wmw_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Ndimana nsinagoga akiwolotera uhakika Mayahudi pamoja na Sawari-Mayahudi wakuwajibu mambo a Mwenyezimungu. Na suku daima ákisoweranga na wanu mbazari. ");
INSERT INTO wmw_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Wanlimu wengine wakwijiwikana kuwa wataalamu Waepikureyu na Washitoyiku wakikaidiyana naye novyo. Wengine wakamba: “Munu njinga‑yu kankusaka kwamba kinani?” Wengine wakamba: “Kawa kamba munu wakupita akereza milungu ya inti za wamalamboni.” Wakamba javire konta iye akiwereza habari kuhusu Insa na kufufuka kwake. ");
INSERT INTO wmw_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Basi, wakinkola, wakimpereka kukundi rakwitiwa Aeropagu, wakindairi: “Habari nyipya zaufunda‑zi zakinani? ");
INSERT INTO wmw_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Kamana vinu vyauri kutambira‑vi vyankutishangisa. Ofwe tisaka tijiwe, mana ake kinani?” ");
INSERT INTO wmw_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Kusema kweli, piya wanu wa Atena na wanu wa inti nyengine wákikalanga nokure, awakishugulika na kinu cengine, sairi kupakanira habari za sambi. ");
INSERT INTO wmw_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Basi, Paulu akimira kati-kati ya Aeropagu, akamba: “Umwe wanu wa Atena, niwona kuwa, kwa namuna piya, muwa wenye dini. ");
INSERT INTO wmw_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Kamana panikipita nizungunuka niwawona maswanamu milungu yenu yamutukuzanga. Ninsingana novyo swanamu mmoja wakwandikiwa javi: ‘Ka nlungu sejiwikana.’ Basi sambi, nlungu wamumwabudu‑yu bila kumwijiwa, ndi noyo-noyoni waniri kukwerezani omi. ");
INSERT INTO wmw_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Nlungu ombire ulumwengu‑wu na piya viripo nkati yake, eyu ndi Mwenye wa bingu na ardhi. Iye ekala nyumba takatifu zakujengiwa na makono a wanu. ");
INSERT INTO wmw_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Iye aasakula kuudumiwa na makono a wanadamu, konta iye acipo casakula. Kweli, iye ndi awapa uhai piya wanu na kupumuzika na vinu piya. ");
INSERT INTO wmw_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Iye komba, kwa kiyumbe mmoja, kila kabila ya wanu wekare piya duniya‑yi. Na iye katula wakati na mpaka wakwikala, ");
INSERT INTO wmw_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","ipate wansakure Mwenyezimungu, ikiwa dalili wengine kwa kumpamapama wansingane. Kusema kweli, iye aari baidi nofwe kila mmoja. ");
INSERT INTO wmw_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Kamba vyaasemire munu mmoja, akamba: ‘Iye ndi atitenza tikiinshi, tikenenda na tikiwepo.’ Wenye mashairi wenu novyo wamojawapo wamba: ‘Ofwe piya tiwa viyumbe vyake.’ ");
INSERT INTO wmw_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Kwa kuwa ofwe tiwa viyumbe vya Mwenyezimungu, avitifãi tisiwaze kuwa Nlungu alandanisiwa na oru wala parata wala riwe, nfano wakuwajiwa na kutendiwa na fundi mwanadamu mmojawapo. ");
INSERT INTO wmw_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Wakati wanu wawakintikina, Mwenyezimungu avikimmweri. Fala epa sambi, kankuwatuma wanu piya kila mahala watubiye. ");
INSERT INTO wmw_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Konta katula suku yakuwalamula wanu ulumwengu piya na shariya, julu ya Munu wantondore. Na iye kawakikisha wanu piya kinu‑ci julu ya kunfufula iye ka wafwi.” ");
INSERT INTO wmw_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Sambi, pawasikire kuhusu kufufuka ka wafwi, wanu wengine wakinshupa, wengine wamba: “Kuhusu ewu mwaha‑wu, tisaka tukusikire uwe novyo tena.” ");
INSERT INTO wmw_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Basi, Paulu akilawa kati yawo, akuka vyake. ");
INSERT INTO wmw_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Fala wanu wengine wanlunga nkono Paulu, wakubali. Kati yawo ákiwapo Diyoniziyu wa kundi ra Aeropagu, mwanamuka mmoja wakwitiwa Damari, na wengine‑po tena. ");
INSERT INTO wmw_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Bandi ya piya vire, Paulu akilawa Atena, akuka Korintiyu. ");
INSERT INTO wmw_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Paafikire Korintiyu kure, kansingana Yahudi mmoja wakwitiwa Akila, kâpongoriwa Pontu. Akila na nkawake Pirisila wâja kulawa Italiya kwa suku aba, konta nfalume Kalaudiyu kâmuru kuwa Mayahudi piya walawe Roma kure. Paulu koka kwawo kuwawona, ");
INSERT INTO wmw_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","na kwa kuwa kazi yawo íkiwa mmoja, iye akiinshi nopare wakikola kazi pamoja, kazi ya kusona ema. ");
INSERT INTO wmw_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Kila sabadu, iye akiwolotera ukweli kusinagoga, akiyerera kuwavuta Mayahudi na Sawari-Mayahudi. ");
INSERT INTO wmw_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Sila na Timotiyu, pawateremuke kulawa Makedoniya, Paulu kashugulika na Habari Ngema, akilavya ushahidi mbere ya Mayahudi kuwa Insa ndi Almasihi. ");
INSERT INTO wmw_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Fala pawakintukana na wakinsowerera kufuru, iye akisasanya nguwo zake, akiwambira: “Damu yenu iwe julu yenu. Omi sina lawama nkati yenu. Mwanzo wa sambi‑pa, nukuka ka wanu Sawari-Mayahudi.” ");
INSERT INTO wmw_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Nakulawa pare, akuka akingira nyumba ya mwananlume mmoja wakwitiwa Titu Zushutu, munu mmoja ákintukuzanga Mwenyezimungu. Nyumba yake ilungana na sinagoga. ");
INSERT INTO wmw_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kirispu, amiri wa sinagoga ire, pamoja na jamaa zake piya, wâmwamini Mwenye Insa. Na wanu wengi waKorintiyu pawasikire, newo novyo wakamini na wakoziwa. ");
INSERT INTO wmw_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Suku moja usiku, Paulu imwisukira ruhuya. Mwenye akimwambira, akamba javi: “Usope! Zidi kwereza, usinyamare, ");
INSERT INTO wmw_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","kwa kuwa omi niwa pamoja nawe. Aapo atenda vita nnowe kukutenda kinu kibaya, konta nanawo wanu wengi wawenye eyi kaya‑yi.” ");
INSERT INTO wmw_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Basi, iye kekala mwaka mmoja na nusu, akiwafunda usemi wa Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Fala Galiyu paákiwa nfalume wa Akaya, wakilawa Mayahudi kwa niya mmoja wakikola kubishana na Paulu, ewo wampereka kuNyumba ya Milandu, ");
INSERT INTO wmw_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","wakamba: “Eyu mwananlume‑yu kankuwahimu wanu wantukuze Mwenyezimungu kwa namuna sairi ya shariya.” ");
INSERT INTO wmw_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Paulu ári tayari kusowera, Galiyu kawambira Mayahudi ware kamba: “Inawa mwanawo makosa mamojiwapo au anakunisha vinu vyakofya, nanga inilazimu nukusikirizeni vyamunereza‑vi. ");
INSERT INTO wmw_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Fala, kwa kuwa ndi mwaha wa kukaidiyana kuhusu masemo na mazina na vinu vya shariya zenu, lamulanani watupu. Omi sisaka kuwa mwenyé kulamula vinu kamba-vyo.” ");
INSERT INTO wmw_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Na akiwatuwisa nNyumba ya Milandu mure. ");
INSERT INTO wmw_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ikisa, wanu ware piya wakinkola Soshiteni, amiri wa sinagoga ire, newo wakanza kumwibiya nopare mbere ya Nyumba ya Milandu ire. Fala Galiyu avikimmweri kinu. ");
INSERT INTO wmw_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paulu kekala suku nyingi zawenye Korintiyu. Ikisa akilayana na wanduze wa jamati, akingira mbatela, akiloka akuka Siriya, koka pamoja na Pirisila na Akila. Kaya ya Kenkereya, kâmyola nywiri zake ipate atimize nadiri yake. ");
INSERT INTO wmw_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Paulu akifika Efezu, akiwasa Pirisila na Akila. Iye mwanyewe akuka akingira nsinagoga, akanza kuwolotera uhakika Mayahudi nomure. ");
INSERT INTO wmw_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ewo wanlebela ekare nawo tena muda aba, fala Paulu akamba anta. ");
INSERT INTO wmw_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Novyo-sivyo, paawalaire akiwambira: “Mwenyezimungu akinijanliya, nukuja tena kwenu umwe.” Akilawa Efezu, akilokera ng'ambu nyengine. ");
INSERT INTO wmw_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Pesuke Kaisariya, akikwera Yerusalemu, akidairiyana nawo habari wenye jamati. Ikisa, akiteremukira Antiyokiya. ");
INSERT INTO wmw_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Bandi ya kwikala nokure suku aba, akilawa akuka vyake. Akipita makaya a Galata na Furujiya, kupita akiwahurumiya wanafunzi piya. ");
INSERT INTO wmw_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Sambi, ákiwapo Yahudi mmoja wa Aleshandriya wakwitiwa Apolu, akifika Efezu. Iye akereza sana-sana, akijiwa pakulu Mandiko Matakatifu. ");
INSERT INTO wmw_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Iye kâfundiwa sana njira ya Mwenye. Akisowera na juhudi kuno akifunda na ukweli habari ya Insa, ingawa akijiwa koza kaakifundanga Yahaya tu basi. ");
INSERT INTO wmw_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Iye akanza kusowera nsinagoga bila wofi. Pawasikire, Pirisila na Akila wakintwala, wakanfunde pakulu sana njira ya Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Na Apolu, paakiwaza kulokera Akaya, wenye kwamini wakimuhurumiya, wakiwandikira wanafunzi wa noko kuwalebela wampokerere sana. Apolu paafikire Akaya, kawasaidiya pakulu sana ware waminire julu ya rehema. ");
INSERT INTO wmw_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Iye akiwakidiri baina Mayahudi kwa uwezo, na kwakikisha julu ya Mandiko kuwa Almasihi ndi Insa. ");
INSERT INTO wmw_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolu paakiwa Korintiyu, Paulu akipita makaya a nrima, akifika mpaka Efezu. Nokurekure, akiwasingana wamojawapo wenye kumwamini Insa, ");
INSERT INTO wmw_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","akiwadairi: “Umwe pamukubalire, kakwisukirani Roho Takatifu?” Ewo wakinjibu: “Ofwe wala atijiwa kuwa kawapo Roho Takatifu!” ");
INSERT INTO wmw_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Paulu akiwadairi tena: “Sambi, umwe moziwa kinamunani?” Ewo wakinjibu: “Kwa namuna ya koza Yahaya.” ");
INSERT INTO wmw_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Basi Paulu akiwambira: “Koza kakoza Yahaya kukiwa ka kutubiya wanu. Iye kâwambira wanu kuwa wajuzi wamwamini eyo asaka kuja nyuma yake, akimwamba Insa.” ");
INSERT INTO wmw_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Bandi yakusikira javire, ewo wakoziwa kwa zina ra Mwenye Insa. ");
INSERT INTO wmw_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Na Paulu, paawaturire makono, kawesukira Roho Takatifu, wakanza kusowera luga sazijiwikana na kubushuru. ");
INSERT INTO wmw_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ewo piya wákiwa kiyasi ca wanawalume kumi na wawiri. ");
INSERT INTO wmw_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Paulu akukanga nsinagoga, akisowera bila wofi muda wa myezi mitatu. Ákisoweranga nawo, kusakula kuwahimu kuhusu ufalume wa Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Fala wengine wákiwa wabishi, awakikubali, na wakisowera caputu mbere ya wanu kuhusu Njira ya Insa, ndimana Paulu akiwatanuka. Kwasa javyo, suku daima‑zi, iye ákijumananga na wanafunzi pansana nkulu, mahala paakifundanga mwananlume wakwitiwa Turanu. Iye akisoweranga nawo, akiwolotera uhakika. ");
INSERT INTO wmw_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Eci cikikuna muda wa myaka miwiri mpaka wanu piya wa Aziya, Mayahudi na Sawari-Mayahudi ware, wasikira habari kuhusu Mwenye Insa. ");
INSERT INTO wmw_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Mwenyezimungu, julu ya mmakono mwa Paulu, akitenda maajuza akupunda kiyasi. ");
INSERT INTO wmw_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Ifika mpaka kutwariwa lemba na anzu yake wakiponeseriwa walwere julu ya kukumbula, kweli newo wakipona na mashetwani wakiwalawa. ");
INSERT INTO wmw_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Sambi, Mayahudi wasawi wamojawapo wákipitanga kaya anta kaya, wákiyerera kulebela kwa zina ra Mwenye Insa wawatuwise mashetwani walwere. Ewo wákiwambira mashetwani javi: “Nukutuwisa kwa zina ra Insa, noyo waari kuntangaza Paulu‑yo.” ");
INSERT INTO wmw_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Wamojawapo wákitendanga javyo‑wo wákiwa wana saba wa Yahudi mmoja wakwitiwa Sikeva. Iye ákiwa nkulungwa wa dini. ");
INSERT INTO wmw_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Shetwani kawajibu javi: “Insa nimwijiwa, Paulu ninfahamu. Fala umwe wanani?” ");
INSERT INTO wmw_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ikisa, mwananlume ákiwa na mashetwani ire ákiwerukira wanu ware, akiwakidiri mpaka akiwashinda. Basi, piya wakilawa nnyumba mure, wakipita wakituwa diki na vijaraa. ");
INSERT INTO wmw_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Vikunire‑vi wejiwa piya wakikala Efezu, Mayahudi na Sawari-Mayahudi. Piya ware wakanza kopa pakulu, na zina ra Mwenye Insa rikitukuziwa pakulu. ");
INSERT INTO wmw_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Wengi wâmwaminire wakija, wakereza baina vitendo vyawo vibaya vyawatendanga. ");
INSERT INTO wmw_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Wengi wákitendanga vitendo vya usawi ware, wakikusanya mabuku awo wakoca pamoto mbere ya piya wanu. Wesabu kadiri yawo jumula ya mabuku awocire, akifika alufu amusini za jarajara za parata. ");
INSERT INTO wmw_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Kwa javyo, usemi wa Mwenye ukizidi kwenera na úkiwa na nguvu. ");
INSERT INTO wmw_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Bandi ya vire vikunire vire, Paulu, kwa kulongoziwa na Roho Takatifu, kanuwiya apite Makedoniya na Akaya, oke mpaka Yerusalemu. Iye akamba: “Bandi yakuka Yerusalemu, inilazimu nuke novyo Roma.” ");
INSERT INTO wmw_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Basi, akiwatuma Makedoniya wasimana wake wawiri, Timotiyu na Erashitu. Iye akibaki kwa muda wa suku aba Aziya nokure. ");
INSERT INTO wmw_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Noure wakati ure, ikilawirira vurumãi ulu futi, kwa sababu ya Njira ya Insa. ");
INSERT INTO wmw_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Ákiwapo urivi mmoja akitiwa Demetiriyu, ákitendanga vifure vitoto vya parata vya nfano wa nyumba ya Aritema. Kwa eyi kazi‑yi, wákipatiranga faida ya nzuruku mwingi wawenye. ");
INSERT INTO wmw_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Iye akiwajumanisa mafundi wákitendanga noire kazi ire, akiwambira: “Wenzangu, umwe mukwijiwa kuwa ofwe tankutajiri kwa noyi kazi‑yi. ");
INSERT INTO wmw_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Mwankusikira na mwankuwona vyaatenda Paulu‑vi, aari kutenda Efezu nopa basi, kankutenda kiyasi ca Aziya piya. Iye kankuwakubalisa wanu wengi wawenye, akiwazungunusa, kwa kuwambira kuwa maswanamu wakuwajiwa na binadamu siyo milungu ya kweli. ");
INSERT INTO wmw_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Kwa javyo, kazi yetu aija kuwa nawo faida tena. Vikopesa wanu awaja kutukuza tena nyumba ya nlungu nkulu Aritema, na ulaviwa utukufu wake, waari kutukuziwa na piya wanu wa Aziya na duniya nzima.” ");
INSERT INTO wmw_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Pawasikire, ewo wakimiwa pakulu futi, wakanza kukuwa wakamba: “Asifiwe Aritema, nkulu wa waEfezu!” ");
INSERT INTO wmw_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Umani ure wenera kaya ire piya. Wanu nkonjo nzima wakituwirira nteni mwawajumane wanu wa kaya ire. Wankola Gayu na Arishitariku, waMakedoniya, wenziwe Paulu. ");
INSERT INTO wmw_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paulu, paakisaka engire nkati ya kundi ra wanu ware, wanafunzi awamwasire. ");
INSERT INTO wmw_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Na mafalume wamojawapo wa Aziya kure, wawere marafiki wa Paulu, wamperekera novyo habari yakunlebela asishubutu kuka kuteni kawajumane wanu kure. ");
INSERT INTO wmw_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Wajumane ware, wengine wakamba eci, wengine wakamba cengine. Pabanja pare pákiwa ngorofi, wengi awakijiwa sababu iwajumanise pare. ");
INSERT INTO wmw_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Wamojawapo kati ya wanu ware wakimolota Alishandere kuwa ndi ari na cakusowera. Ndimana Mayahudi wakinsukumira mbere ya wanu ware. Basi, Alishandere akiwatendera alama na nkono kuwapoza, konta akisaka awambire wanu ware kuwa ewa awana makosa. ");
INSERT INTO wmw_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Fala wanu pawejiwe kuwa Alishandere ire Yahudi, piya wakikuwa kapamoja, wakamba kinu kimoja noco kiyasi ca ora mbiri: “Asifiwe Aritema wa waEfezu!” ");
INSERT INTO wmw_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Mwandiki wa kaya ire, nakwisa kuwanyamaza wanu ware, akiwambira javi: “Wanu wa Efezu, nani atikina kuwa Efezu ndi kaya amiri yakwikaza nyumba ya nlungu nkulu Aritema, pamoja na riwe takatifu rigwire binguni? ");
INSERT INTO wmw_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Aapo akaidi kinu‑ci, basi epa nyamalani, musitende kinu samuwazire sana-sana! ");
INSERT INTO wmw_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Kamana ewa wanu wamujire nawo‑wa awavunjire nyumba ya nlungu wala awansowerere kufuru nlungu wetu. ");
INSERT INTO wmw_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Kwa javyo, ikiwa Demetiriyu na wakolakazi wenziwe wasaka kusema makosa a munu mmojawapo, iwapo nafasi yakupereka ka wenye kulamula. Nyumba za kulamula ziwa wanzu, wakereze noko. ");
INSERT INTO wmw_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ikiwa wasakula kinu cengine, cakujuzi kulamuriwa kunyumba ya milandu yawasimanananga suku maalumu. ");
INSERT INTO wmw_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Kamana vititisira ajali rero kwa kulongoperiwa kulavya vurumãi‑yi. Kweli, aipo shariya mmojawapo ya ewu umani‑wu, ofwe atina namuna yakujibu.” ");
INSERT INTO wmw_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Nakuwambira evi vinu‑vi akifunga banja ire. ");
INSERT INTO wmw_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Paisire vurumãi ire, Paulu akitumiza kuweta wanafunzi. Bandi ya kuwataya niya, iye akilayana nawo, akilawa akuka Makedoniya. ");
INSERT INTO wmw_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Bandi yakupita mahala mwaapitire, ákiwataya niya wenye kwamini, mwinsho akuka porovinsiya ya Geresiya. ");
INSERT INTO wmw_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Kainshi nokure myezi mitatu. Ikisa, bandi ya kuwa tayari kulokera Siriya, kejiwa kuwa Mayahudi wankuntendera mpango wakumulaya. Ndimana akinuwiya kuludira Makedoniya. ");
INSERT INTO wmw_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Wâmpereke Paulu wákiwa Sapaturu mwana wa Piru, kwawo Bereya, Arishitariku na Sekundu wo‑wawiri‑wa waTesalonika, Gayu nDeribi, Timotiyu, pamoja na Tikiku na Torofimu, ewa wawiri‑wa wa Aziya. ");
INSERT INTO wmw_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ewa wanu‑wa wálongorera, wakitirindira Torowa. ");
INSERT INTO wmw_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Bandi yakwisa sherehe ya Pashukwa, tikiripakira kisiko ca Filipi, tenenda safari ya muda wa suku ntanu, tikifika Torowa kawákiwa kure. Tikala sumana nzima nokure. ");
INSERT INTO wmw_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Suku ya mwanzo wa sumana, tikare tijumane pajambo ra Kumbukumbu tikirya mikate. Paulu akikola kusowera nawo wenye kwamini. Kwa kuwa ákiwa na mpango wakulawa subuu yake, iye akizidi kuwereza mpaka usiku kati-kati. ");
INSERT INTO wmw_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Sambi, zíkiwapo kandiyeru nyingi zikikorera pansana pajulu ya gorofa patijumane pare. ");
INSERT INTO wmw_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Nnemba mmoja wakwitiwa Eutiku kékala pajanela. Noparepare akisokera pakulu, ukimpata usingizi mwingi vutu, kwa kuwa Paulu akisowera pakulu. Usingizi ukinkidiri, akisomoka akigwa rã mahala baidi, gorofa ya tatu. Akitekiwa wakufwa wawenye. ");
INSERT INTO wmw_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Basi Paulu neye akisuka, akimwinyamira patumbo, akimpatika, akamba: “Musiuzunike, eyu angari nawo uhai!” ");
INSERT INTO wmw_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Ikisa Paulu akiludira tena pansana kugorofa nokure, akimeya nkate, akitafuna pamoja na wenye kwamini ware. Bandi ya kupakanira nawo mpaka alufajiri, Paulu akilawa, akuka vyake. ");
INSERT INTO wmw_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Noparepare nnemba ire wakimpereka kwawo ári nkomu dodola. Ewo wakiludi wari radi pakulu sana. ");
INSERT INTO wmw_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Sambi ofwe tikilongorera mbatela, tikisafiri mpaka pafungu kaya ya Asu, konta noko iwa tikampokerere Paulu. Ndi vyatísikizane javyo kamana niya yake íkiwa kupita ya nrima. ");
INSERT INTO wmw_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Paulu patisimanane kaya ya Asu, tikimpokerera akingira mbatela, tikisafiri mpaka Mituleni. ");
INSERT INTO wmw_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Basi tikilawa pare, mpaka subuu yake tikifika sawa‑sawa na Kiyu. Tenenda kutwa nzima tikifika Samu, na mpaka subuu yake tena tikifika Miletu. ");
INSERT INTO wmw_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paulu kânuwiya asipite Efezu kwa kuwa asipoteze wakati Aziya, konta ákiwa na upesi ikimbidi afike Yerusalemu sainafika suku ulu ya Pentekoshiti. ");
INSERT INTO wmw_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Sambi Miletu kure, Paulu akintuma munu Efezu kuwarifu wakulungwa wa jamati waje wawonane naye. ");
INSERT INTO wmw_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Pawajire, Paulu kawambira javi: “Umwe mukwijiwa vyaviwere tangu mwanzo panifikire Aziya kuwa suku daima tíkiwa onse. ");
INSERT INTO wmw_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Daima nintumika Mwenye na unyenyekevu na masozi, pamoja na kuyereriwa na tabu zawanikunishe Mayahudi vyawakinitabisha. ");
INSERT INTO wmw_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Panukukwerezangani Habari Ngema, kukufundani wanzu-wanzu nikipita nyumba anta nyumba, omi hapana canasire kukwambirani upande wa vinu vya faida. ");
INSERT INTO wmw_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Nikilavya ushahidi kuwereza Mayahudi na Sawari-Mayahudi, kuwa wajuzi watubiye na wamwamini Insa, Mwenye wetu. ");
INSERT INTO wmw_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Epa sambi, kamba nfungwa wa Roho Takatifu, ndi vyaniri kuka Yerusalemu, sijiwa cuka kunikuna. ");
INSERT INTO wmw_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ila Roho Takatifu caanijiwise ndi kuwa kaya ulu‑ulu piya kalaboshu na kulumbatiwa piya vinirindira omi. ");
INSERT INTO wmw_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Falakini omi mainsha angu siyo faida kwangu omi. Kikulu kwangu omi nitimize kazi yanipere Mwenye Insa, ipate nilavye ushahidi kuhusu rehema ya Mwenyezimungu nkati ya Habari Ngema. ");
INSERT INTO wmw_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Epa sambi, omi nukwijiwa kuwa umwe piya wanipitire nukukwerezani ufalume wa Mwenyezimungu-mwe, amuwona tena uso wangu. ");
INSERT INTO wmw_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Ndimana, kwa suku ya rero‑yi, nilavya ushahidi kuwa sina kosa ka wenye kwasika kati yenu umwe piya, ");
INSERT INTO wmw_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","kamana omi saasire kukwerezani ngano piya za upande wa Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Kwa javyo, ritunzeni umwe wanyewe pamoja na piya wenye kwamini, kwa kuwa Roho Takatifu ndi ikuturireni umwe kuwa maamiri. Muwe wasunga wa jamati ya Mwenyezimungu, jamati yaapatire julu ya damu ya Mwanawe. ");
INSERT INTO wmw_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Nukwijiwa kuwa nikilawa‑pa, wakwingira wanu kusakula kudangula jamati‑yi. Ewo wakuja kulanda miwinzi yakutonya vyaiwaduru makondoo. ");
INSERT INTO wmw_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Na nkati yenu nomwe-mwe, walawirira wamojawapo wakufunda ngano za ulongo, kusakula kuwatesa wanafunzi wawafulate ewo. ");
INSERT INTO wmw_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Kwa javyo, rinang'anizireni. Daima mukumbukire kuwa, muda wa myaka mitatu usiku na nsana, omi sasire kunkumbusa kila mmoja, kuno nikirira. ");
INSERT INTO wmw_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Sambi, nukugabizini mmakono mwa Mwenyezimungu na kwa usemi wa rehema zake, zíri na uwezo wakurimbisa roho zenu, mwinsho mupewa irati yawatuririwe watakatifu piya. ");
INSERT INTO wmw_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Sajibiwe na kinu ca munu: wala parata wala oru wala nguwo. ");
INSERT INTO wmw_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Anta umwe wanyewe mukwijiwa kuwa nikola kazi na makono angu mwanyewe ipate omi na wenzangu tipate catisakula. ");
INSERT INTO wmw_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Kwa namuna‑zi piya, nukoloterani kuwa julu ya kukola kazi nyingi javi, itibidi kuwavya wenye tafauti zawo. Kumbukirani usowezi wa Mwenye Insa paasemire javi: ‘Vyema pakulu kumera zaida kumeriwa.’ ” ");
INSERT INTO wmw_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Pesire kwamba javire, Paulu akikokora pamoja na wenye kwamini ware piya, wakilebela duwa. ");
INSERT INTO wmw_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Piya akiwetika masozi bu-bu-bu-bu, wakimwirukira Paulu pasingo, wakimpa beju. ");
INSERT INTO wmw_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Ewo wauzunika pakulu futi, kwa kuwa kâwambira javi: “Amuwona uso wangu tena.” Ikisa wakinsafiriza mpaka kubatela. ");
INSERT INTO wmw_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Patisire kulayana nawo wenye kwamini ware, tikisafiri na batela moja ka moja mpaka tikifika Kosi. Subuu yake tikitaya nanga kisiko ca Rodi. Nakupunda pare, tikuka mpaka Patara. ");
INSERT INTO wmw_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Patisingane batela rakuka Foinikiya, tikiripakira tikuka mbere ya safari yetu. ");
INSERT INTO wmw_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Tipita karibu ya Kiporo, tasa upande wa nkono sonto, tikuka mpaka Siriya. Tisoza kisiko ca Tiru, tikisuka konta batela rire rikipakula vinu nopare. ");
INSERT INTO wmw_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Noyo kaya‑yo, tiwasingana wenye kwamini wamojawapo, tikikala nawo sumana mmoja. Ewo, wakamuriwa kwa uwezo wa Roho Takatifu, wakimwambira Paulu kuwa asuke Yerusalemu. ");
INSERT INTO wmw_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Wakati watimarize suku zetu, tikilawa tikuka na safari yetu. Wenye kwamini piya pamoja na waka wawo na wana wawo, wakitisafiriza mpaka mwinsho ya kaya ire. Basi, nakufika mwani tikikokora, tikinlebela Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Noparepare tikilayana, ikisa tikingira mbatela, ewo wakiludira kukaya. ");
INSERT INTO wmw_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Mwinsho ya safari yetu ya Tiru, tikifika Tolemayi. Noparepare tikidairiyana nawo habari wenye kwamini, tikikala nawo kutwa nzima. ");
INSERT INTO wmw_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Subuu yake, tikilawa tikifika Kaisariya, tikuka kunyumba ya Filipi, mwenyé kwereza Habari Ngema za Insa, tikikala naye. Iye ákiwa nkati ya nkonjo wa wanu saba wâtondoriwe Yerusalemu watumike shuguli za nzuruku wa jamati. ");
INSERT INTO wmw_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Iye ákiwa na wana wane wári sawalombiwe, newo wákiwa minabii. ");
INSERT INTO wmw_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Kwa kuwa tikawa Kaisariya kure suku nyingi zawenye, akija nabii mmoja kulawa Yudeya, zina rake Agabu. ");
INSERT INTO wmw_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Akifika karibu yetu, akitwala sinturãu ya Paulu, akirifunga mmakono na mmaulu, akamba: “Roho Takatifu ikwamba kuwa mwanyewe ukanda‑wu akifika Yerusalemu, Mayahudi wanfunga novi‑vi javi, ikisa wampereka mmakono mwa wanu Sawari-Mayahudi.” ");
INSERT INTO wmw_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Patisikire javire, ofwe na wenye kwamini wengine wa nokure, tintafadali Paulu kuwa asikwere kuka Yerusalemu. ");
INSERT INTO wmw_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Paulu akijibu: “Umwe camurira kinani? Mbana mwankunivunja nguvu mmoyo mwangu sababuni? Kamana omi sikufungiwa basi, anta paiwa nukuka kufwa Yerusalemu, omi niwa tayari novyo kwa sababu ya Mwenye Insa.” ");
INSERT INTO wmw_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Kwa kuwa atinkidirire kunkubalisa kuwa asuke, tikimwasa ikisa tikamba: “Vikune vyaisaka nafsi ya Mwenyezimungu.” ");
INSERT INTO wmw_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Bandi ya suku aba javi‑pa na bandi yakuritengeza, tikikwera tikuka Yerusalemu. ");
INSERT INTO wmw_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Wanafunzi wamojawapo wa Kaisariya watipereka, wakija nawo mpaka nnyumba ya mwananlume wakwitiwa Mnasoni kwawo Kiporo, mwanafunzi wa mida watifikire kwake. ");
INSERT INTO wmw_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Patifikire Yerusalemu, wenye kwamini watipokerera ka moyo radi pakulu futi. ");
INSERT INTO wmw_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Subuu yake, Paulu akilawa pamoja nofwe, tikuka mpaka ka Yakobu kummona. Piya wakulungwa wa jamati wajumana noko. ");
INSERT INTO wmw_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Paulu, bandi yakudairiyana nawo habari, akiwereza kimoja-kimoja Mwenyezimungu vyaawakunishe wanu Sawari-Mayahudi julu yake iye. ");
INSERT INTO wmw_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Wasikire ware wakintukuza Mwenyezimungu, ikisa wakimwambira Paulu wakamba: “Epa nduyetu ngatunza, Mayahudi alufu ka maalufu wankwamini, fala novyo-sivyo wangari wakifulata nfululu Taureti. ");
INSERT INTO wmw_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ewo wambiriwa kuhusu uwe‑po, kuwa kwankupita ukiwafunda Mayahudi wekala mmakaya mwa wanu Sawari-Mayahudi wasifulate Taureti, wasiwataye itani wana wawo wala wasenendere tabiya zetu. ");
INSERT INTO wmw_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Sambi titende mwaja? Epa, ewo kweli-kwelini watakusikira kuwa uwe kuja. ");
INSERT INTO wmw_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Fadari tenda vyatisaka kukwambira‑vi: nkati ya ofwe‑pa, wawapo wanawalume wane wasaka walavye nadiri yawo yawaturire ka Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Watware wikare nawo pajambo rawo ra ibada ya kuswafiwa, na uwaripire wamyoriwe nywiri. Javyo wanu-wa‑pa piya watakwijiwa kuwa ulongo vyawari kukusowerera-vyo, wakwamba kwankufulata na kwankutimiza Taureti. ");
INSERT INTO wmw_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Kuhusu Sawari-Mayahudi wamwaminire Insa ware, ofwe tiwandikira futi waraka tiwamuru javi: ‘Musirye vyakutenderiwa kafara milungu ya maswanamu, wala musinywe damu, wala vyakupotiwa, wala musiwe na lukware.’ ” ");
INSERT INTO wmw_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Kwa javyo, Paulu akiwatwala wanawalume ware, na subuu yake, bandi ya kuswafiwa pamoja newo, iye akingira nawo nNyumba Takatifu. Iye koka kuwambira baina kutimiziwa ka suku zakuswafiwa zire, na kafara inlazimire kulavya kila mmoja. ");
INSERT INTO wmw_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Karibu ya kutimu zire suku saba, Mayahudi wamojawapo wa Aziya nakummona Paulu nNyumba Takatifu mure, wakiwashongezera wanu piya, wakinkola. ");
INSERT INTO wmw_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Ewo wakikuwa wakamba: “WaIziraeli, tangupireni! Eyu ndi mwananlume abishana na wanu wetu, na shariya yetu, pamoja na mahala‑pa. Kankupita akiwafunda wanu kila upande. Kwasa javyo, kawengiza Nnyumba‑mu wanu Sawari Mayahudi, kataya haramu mahala patakatifu‑pa.” ");
INSERT INTO wmw_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","(Ewo ciwambise javyo ndi kuwa wammona nkaya mure ári na Torofimu, muEfezu. Basi wakidaniza kuwa Paulu ndi amwingize nNyumba Takatifu.) ");
INSERT INTO wmw_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Kaya ire piya ikijala girita, wanu piya wakija wakituwa wengi-wengi. Wakinkola Paulu, wakinsukumira panja ya Nyumba Takatifu. Kwa mpunde noure, wakifunga miryango yawo ti! ");
INSERT INTO wmw_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Pawakiwazisana namuna zakumuulaya Paulu, nkulungwa wa masurudadu wa waRoma akipata habari kuwa Yerusalemu piya ilawa girita. ");
INSERT INTO wmw_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Kwa mpunde noure, iye akiwatwala masurudadu pamoja na wakulungwa wawo, akisika akituwirira nokure. Ewo, pawammonire nkulungwa ire akija pamoja na masurudadu, wakasa kumwibiya Paulu. ");
INSERT INTO wmw_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Nkulungwa ire na kufika karibu, akinkola Paulu, akitumiza afungiwe na unyolo miwiri, ikisa akindairi: “Eyu munu‑yu nani? Na kakosa kinani?” ");
INSERT INTO wmw_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Wanu ware wakanza kunyangula, wengine wakamba eci, wengine wakamba cengine. Nkulungwa ire aapatire kwijiwa sana cikunire kwa sababu ya ngigiri ure kuwa mwingi. Basi akiwamuru masurudadu wantware Paulu wakantaye nfurtaleza. ");
INSERT INTO wmw_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Pawafikire pashikada ya kwingirira nkati, masurudadu iwabidi wankore mmaweya wankweze, konta wanu wakitenda ngigiri pakulu. ");
INSERT INTO wmw_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Kusema kweli, wanu wengi wakija nyuma wakikuwa wakamba: “Mulayeni, mulayeni!” ");
INSERT INTO wmw_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Masurudadu wari tayari kuntaya Paulu mufurtaleza, iye kandairi nkulungwa ire: “Iwapo nafasi ya kukwambira kinu?” Nkulungwa ire akinjibu: “Uwe usowera kigeregu? ");
INSERT INTO wmw_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Uwe sinowe‑we mMiswiri sukumbiri nozi‑zi usalamure mageshi ukiwatwala visomi alufu nne ukiwalongoza kulanga‑we?” ");
INSERT INTO wmw_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Paulu akinjibu: “Omi ndi kweli niwa Yahudi, nipongoriwa Tarusu iri Kilikiya, niwa munu wa inti bora. Tafadali nipe riusa nisowere na wanu‑wa.” ");
INSERT INTO wmw_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Kwa kuwa nkulungwa ire kampa riusa, Paulu akimira pashikada na akilamusa nkono, alama ya kuwanyamaza wanu ware. Pawanyamare, akanza kusowera kiebraniya, akamba javi: ");
INSERT INTO wmw_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Umwe jamaa zangu, wanduzangu pamoja na wawáwa! Sambi kwa kurikengera kwangu, nisikirizeni canisaka kukwambirani‑ci.” ");
INSERT INTO wmw_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Pawansikire akisowera kiebraniya, wakizidi kutegemana wansikire. Basi Paulu akikola kuwambira javi: ");
INSERT INTO wmw_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Omi niwa Yahudi, nipongoriwa Tarusu ya Kilikiya, fala nireriwa nkaya nomu, mmakono mwa Gamaliyeli. Nireriwa vyakurigariga futi kamba shariya yawákifulatanga wababu zetu. Daima nisakula namuna yakuntumika Mwenyezimungu ka moyo wangu piya, kamba vyamuri kutenda piya-mwe rero. ");
INSERT INTO wmw_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Omi nikiwalumbatanga wanu wákifulatanga noyi Njira ya Insa‑yi mpaka kuwolaya. Niwafunga na niwataya nkalaboshu, walume pamoja na waka, ");
INSERT INTO wmw_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","kamba novyo nkulu wa wakulungwa wa dini, na piya Baraza ya Milandu vyawalavya ushahidi kuhusu omi. Visitoshe nipokerera waraka zawo zawawaperekere Mayahudi wakikalanga Damashiku. Eko nuka nikiwakola wafulati wa Insa, nikiwafunga, nikija nawo Yerusalemu kuno wahukumiwe.” ");
INSERT INTO wmw_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Vinikuna javi: “Nukuka na safari yangu karibu ya Damashiku, kiyasi ca aduhuri, gafula niwona kinu cakulangala vú, cikilawa binguni cikinizunguriza piya‑mi. ");
INSERT INTO wmw_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Noparepare nikigwirira pansi, nikisikira shauti ikinambira: ‘Saulu, Saulu, mbana unilumbata?’ ");
INSERT INTO wmw_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Omi nikidairi: ‘Uwe nani, Mwenye?’ Shauti ire ikinambira: ‘Omi Insa nNazareti wauri kunlumbata‑yo.’ ");
INSERT INTO wmw_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Wenzangu wanilongozane nawo wákiwa upande mwengine, wawona sana-sana nlangaza ure, fala shauti ikinisoweza ire awereriwe. ");
INSERT INTO wmw_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Basi omi nikidairi: ‘Mwenye! Nitende mwaja?’ Mwenye Insa akijibu: ‘Lamuka, uke Damashiku. Noko ukuka kwambiriwa piya vinu vyawamuriwe kutenda.’ ");
INSERT INTO wmw_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Kwa kuwa sikiwona kwa sababu ya nlangaza ure kuniseka-seka mmaso, nikikoriwa nkono mpaka Damashiku. ");
INSERT INTO wmw_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Noko ákiwapo mwananlume wakwitiwa Ananiya, iye ákiwa munu wakumwajibu vinu vya Mwenyezimungu, ákifulatanga Taureti pakulu sana, na piya Mayahudi wa Damashiku wakinsifu. ");
INSERT INTO wmw_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Iye akija akinifika karibu, akinambira akamba: ‘Nduyangu Saulu, ludira kuwona tena.’ Kweli na omi, kwa mpunde noure nakwinusa uso, nanza kuwona tena. ");
INSERT INTO wmw_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Basi Ananiya akinambira: ‘Nlungu wa wababu zetu kakutondola uwe wijiwe nafsi yake, ummone Mwenyé shariya, na unsikire mwanyewe akisowera na kanywa yake. ");
INSERT INTO wmw_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Konta uwe ukuwa shahidi wake mbere ya wanu piya, kuwereza vyausikire na vyauwonire. ");
INSERT INTO wmw_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Epa sambi mbana kwankukawa? Lamuka ukoziwe, uswafiwe dambi zako, ukitaja zina rake.’ ” ");
INSERT INTO wmw_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Paulu akisema tena javi: “Wakati waniludire Yerusalemu, panikilebela duwa nNyumba Takatifu, inisukira ruhuya. ");
INSERT INTO wmw_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Nimmona Mwenye Insa, iye akinambira javi: ‘Lawa upesi Yerusalemu konta ewa wanu‑wa awakubali causema kuhusu omi.’ ");
INSERT INTO wmw_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Nikijibu: ‘Mwenye, ewo wakwijiwa sana-sana kuwa omi níkipitanga mmasinagoga níkiwafunga na níkiwebiya wanu wakukwamini. ");
INSERT INTO wmw_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Na wanu pawâkimulaya Shitefanu akerezánga habari zako, nomi novyo níkiwapo nopo, nilunga nkono mwana kitendo‑co. Wanu wakimulaya‑wo omi ndi nisukure nguwo zawo.’ ");
INSERT INTO wmw_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Fala Mwenye akinambira: ‘Lawa uke, konta omi nukutuma baidi, ka wanu Sawari-Mayahudi.’ ” ");
INSERT INTO wmw_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Wanu ware wakinsikiriza Paulu mpaka usowezi wake wa mwinsho. Noparepare ewo wakanza kukuwa kwa shauti ulu: “Eyu aulaiwe! Asiinshi tena‑pa!” ");
INSERT INTO wmw_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Wakikuwa, wakipapula nguwo zawo kuno wakilavya vunvu, ");
INSERT INTO wmw_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","ndimana nkulungwa wa masurudadu akiwamuru wantaye Paulu nfurtaleza. Ikisa akiwambira wamwibiye mpaka aseme wanu ware cawakinkuwira javire. ");
INSERT INTO wmw_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Wakati wawakinfunga Paulu, iye kandairi nfalume wa kundi ra masurudadu ákiwa karibu yake javi: “Iwapo shariya yakumwibiya munu wakuwa na haki ya muRoma sanalamuriwa?” ");
INSERT INTO wmw_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Nfalume wa kundi ra masurudadu, paasikire javire, akuka akimwambira nkulungwa wa masurudadu: “Epa usaka kutendaja? Eyu mwananlume‑yu muRoma!” ");
INSERT INTO wmw_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Nkulungwa wa masurudadu ire akinfika karibu Paulu, akindairi: “Kweli uwe kuwa muRoma?” Paulu akinjibu: “Aye, niwa muRoma.” ");
INSERT INTO wmw_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Nkulungwa wa masurudadu ire akamba: “Nomi nipoteza nzuruku mwingi futi niwe muRoma.” Paulu akinjibu: “Basi, omi niwa muRoma wakupongoreriwa.” ");
INSERT INTO wmw_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Kwa mpunde noure, wanu wawere tayari kumwibiya ware wakintanuka. Nkulungwa wa masurudadu ire, pejiwe kuwa Paulu muRoma, umwingira wofi konta kâmuru afungiwe na unyolo. ");
INSERT INTO wmw_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Subuu yake, nkulungwa wa masurudadu, kwa kusakula kwijiwa kweli-kwelini Paulu caawakosere Mayahudi, akinfungula unyolo ure. Ikisa akamuru wajumane wakulungwa wa dini na Baraza ya Milandu, akitumiza kutwariwa Paulu, akimolota mbere yawo. ");
INSERT INTO wmw_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Paulu, nakunang'aniza rungu-rungu mbere ya Baraza ya Milandu ire, akamba: “Jamaa zangu, nankuinshi saunisusuka moyo mbere ya Mwenyezimungu mpaka rero.” ");
INSERT INTO wmw_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Ananiya, nkulu wa wakulungwa wa dini, akiwamuru wakíwa karibu na Paulu ire wamwibiye kukanywa. ");
INSERT INTO wmw_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Kwa javyo, Paulu akimwambira Ananiya: “Mwenyezimungu akuja kukuhukumu, eko kusitawi ka panja basi! Kwikala‑po unilamure vyaisaka shariya, sambi uwambiraja wanu kunibiya bila shariya?” ");
INSERT INTO wmw_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Wakíwa karibu na Paulu ire, wakimwambira: “Uwe! Nkulu wa wakulungwa wa dini ya Mwenyezimungu kwankuntukana?” ");
INSERT INTO wmw_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Paulu akijibu: “Jamaa zangu, sikijiwa kuwa iye nkulu wa wakulungwa wa dini. Kamana yandikiwa: ‘Nfalume wa inti yenu usintukane.’ ” ");
INSERT INTO wmw_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Paulu, kwa kuwa kêjiwa kuwa Baraza ya Milandu ire iwa cama ca Mafarizeu na wengine ca Masaduseu, akiwambira pakulu-pakulu mBaraza mure: “Jamaa zangu, omi níwa Nfarizeu, ujukulu wa Mafarizeu. Kwa kuwa nanawo tamaa ya kuwa wafwi wakuja kufufuka, nankurindira kulamuriwa.” ");
INSERT INTO wmw_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Iye nakwisa kwamba javire, Mafarizeu na Masaduseu wakanza kukaidiyana, wenye kulamula wakawanyana makundi mawiri. ");
INSERT INTO wmw_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","(Kamana Masaduseu awákikubali kuwa wafwi wafufuka, wala kuwa malaika wawapo, wala awakikubali kuwa roho ziwapo. Falakini Mafarizeu piya vyo vitatu-vyo wákikubali.) ");
INSERT INTO wmw_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Ikisa, ikilawirira girita ulu futi. Wandiki wa kundi ra Mafarizeu wakilamuka, wakikaidi kanguvu, wakamba: “Atimmonerera kosa rimojawapo munu‑yu. Itakuwa kasowera na roho mojawapo au laika, nani ejiwa?” ");
INSERT INTO wmw_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Kukaidiyana kure kukizidi kofya mpaka nkulungwa wa masurudadu kengira kumopereza Paulu asije kupanguriwa kipande-kipande. Ndimana akiwatuma masurudadu wanlavye pare kanguvu, wanludisire kufurtaleza. ");
INSERT INTO wmw_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Suku yapiri usiku, Mwenye Insa akimwisukira Paulu, akimwambira: “Usiwe na wofi! Kulavya ushahidi wangu epa Yerusalemu, na ibidi uke Roma ukalavye ushahidi novyo.” ");
INSERT INTO wmw_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Subuu yake, Mayahudi wamojawapo wakijumana, wakiwaza mpango wakunlumbata Paulu. Walapira kuwa awarya wala awanywa sawamulaye Paulu. ");
INSERT INTO wmw_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Wákiwa zaida ya wanu arubaini wawazire nowo mpango‑wo. ");
INSERT INTO wmw_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Ewo wakiwafika karibu wakulungwa wa dini pamoja na wazee, wakiwambira: “Ofwe tilapira kuwa atirya kinu mpaka timulaye Paulu. ");
INSERT INTO wmw_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Epa sambi, umwe pamoja na Baraza ya Milandu, mwambireni nkulungwa wa masurudadu atumize waje naye kwenu umwe, kamba musaka kundairi sana-sana mwaha wake. Na ofwe, saanafika karibu, tikuwa tayari kumulaya.” ");
INSERT INTO wmw_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Fala mwana wa nlumbuwe Paulu, nakusikira mpango mbaya ure, akinyemerera akingira nfurtaleza mure, akintetera Paulu. ");
INSERT INTO wmw_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Paulu akimwita nfalume mmoja wa kundi ra masurudadu, akimwambira: “Ntware nnemba‑yu umpereke ka nkulungwa wa masurudadu, ciwapo casaka kuka kumwambira.” ");
INSERT INTO wmw_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Kwa javyo iye akimpereka nnemba ire ka nkulungwa wawo masurudadu, akamba: “Nfungwa Paulu kanita, akinilebela nimpereke nnemba‑yu kwako kuno. Kanambira kuwa kanawo kinu kimojawapo caasaka kukwambira.” ");
INSERT INTO wmw_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Nkulungwa wa masurudadu ire akinkola nkono nnemba ire, akuka naye kunyenje, akindairi: “Kinani causaka kunambira?” ");
INSERT INTO wmw_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Iye akijibu: “Mafalume wa Mayahudi wasikizana makeshamungu wakulebele umpereke Paulu kuBaraza ya Milandu, watende kamba wasaka kundairidairi kuhusu mwaha wake. ");
INSERT INTO wmw_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Uwe wasukukidiri, konta ewo, wawa zaida ya wanu arubaini, wasaka kurifisa wanrindire Paulu wamuulaye. Piya walapa kuwa awarya wala awanywa mpaka wamulaye. Ewo wawa tayari kutenda javyo wakirindira uwape majibu.” ");
INSERT INTO wmw_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Basi nkulungwa ire akinlaizira javi: “Usimwambire munu mwengine vyaunambire‑vi.” Ikisa akimwambira nnemba ire: “Uka vyako.” ");
INSERT INTO wmw_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Nkulungwa wa masurudadu ire akiweta mafalume wawiri wa kundi ra masurudadu, akiwambira: “Watengezeni masurudadu miyateni, wacamakavalu sabini, na wamikuki miyateni, woke Kaisariya. Muwe tayari, mulawe rero‑vi, novi ora ya usiku. ");
INSERT INTO wmw_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Ntengezeni novyo kavalu ampande Paulu na munsunge sana-sana munfikise ka guvinadoru Felishi.” ");
INSERT INTO wmw_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Na kamperekera waraka yakusema javi: ");
INSERT INTO wmw_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Omi Kalaudiyu Luziya, nukwandikira mwinshimiwa, guvinadoru Felishi. Nukuperekera salamu. ");
INSERT INTO wmw_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Mayahudi kuno wanfunga mwananlume‑yu, wasaka kumulaya, fala nuka noko na masurudadu wangu kunvusha, panijiwe kuwa muRoma. ");
INSERT INTO wmw_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Omi nikisakula nijiwe sana-sana sababu yakosire, ndimana nikimpereka ka wakulungwa wa Mayahudi, Baraza ya Milandu. ");
INSERT INTO wmw_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Epa nijiwa kuwa ewo wanlongopera kuwa aakifulata shariya zawo. Aakosire kinu cakuwa afungiwa au kuulaiwa. ");
INSERT INTO wmw_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Panambiriwe kuwa Mayahudi wamojawapo wampangira mabaya akusaka kumulaya, ndi paniwazire kukuperekera kwa mpunde nowu. Na ware wammonerere ukosa, niwambira waje noko wereze mbere yako.” ");
INSERT INTO wmw_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Kwa javyo masurudadu, kwa ámuri yawapewe na nkulungwa wawo, wakintwala Paulu usiku-usiku mpaka Antipatiriya. ");
INSERT INTO wmw_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Subuu yake, wacamakavalu wakizidi na safari yawo pamoja na Paulu, kuno masurudadu wakiludira kufurtaleza. ");
INSERT INTO wmw_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Nakufika Kaisariya, waraka ire wakimpa guvinadoru, na wakimolota Paulu ire. ");
INSERT INTO wmw_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Nakufyoma waraka ire, ikisa akindairi Paulu: “Kwenu ndepi?” Paajibiwe kuwa kwawo Kilikiya, ");
INSERT INTO wmw_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","akimwambira: “Nakisa nukusikira, nukuja kulamula pawasaka kuja wakulongopere‑wo.” Basi noparepare akamuru akafungiriwe kunyumba ya kifalume yaâjengire Herodi. ");
INSERT INTO wmw_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Bandi ya suku ntanu, Ananiya nkulu wa wakulungwa wa dini, na wazee wamojawapo, pamoja na mwenyé kupendeleya shariya wakwitiwa Teratulu. Ewa wamwereze guvinadoru makosa a Paulu. ");
INSERT INTO wmw_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Wakati wetiwe Paulu akifika, Teratulu akanza kwereza makosa a Paulu, akamba javi: “Mwenshimiwa Felishi! Kwa sababu yako uwe, tankuinshi kwa salama na mainsha meema julu ya wijiwifu wa ulongozi wako, na vinu vingi vyawenye viri kulamusiwa wafarijike wenye inti‑yi. ");
INSERT INTO wmw_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Tukwakikisha na tishukuru pakulu pawenye kwa piya vyautendanga kila wakati na kila mahala. ");
INSERT INTO wmw_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Basi tenda fadili kwa wema wako, usikirize sana-sana vyatisaka kukwereza‑vi bila kupoteza wakati mwingi. ");
INSERT INTO wmw_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Eyu munu‑yu timmonerera kuwa ndanganyifu na nsabwanyizi nkati ya Mayahudi piya mulumwengu‑mu. Visitoshe, iye ndi nkulungwa wa kundi ra waNazareti. ");
INSERT INTO wmw_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Mpaka kafika kuyerera kufezeyi Nyumba Takatifu, fala tikinkola tikinfunga. ");
INSERT INTO wmw_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Uwe mwanyewe ukindairi ukwijiwa kutunza ukweli kwa makosa atimmonerere.” ");
INSERT INTO wmw_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Mayahudi newo wajumana kwakikisha vyakilongoperiwa vire kuwa vyakweli. ");
INSERT INTO wmw_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Guvinadoru Felishi ire kantendera alama Paulu anze kusowera, basi Paulu akamba: “Omi nukwijiwa kuwa myaka mingi yawenye utilamulanga shariya noyi inti‑yi. Ndimana nirikotola mbere yako kwa kutumaini. ");
INSERT INTO wmw_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Kamba vyawijiwe mwanyewe, ukisaka ndairi asaka kuwa onse, epa rero suku ya kumi na mbiri tangu nikikwera Yerusalemu kuka kuntukuza Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Mayahudi awanisingane nikikaidiyana naye munu nNyumba Takatifu, wala awanisingane nikiwomanisa wanu nsinagoga wala mahala paasaka kuwa ponse nkaya mure. ");
INSERT INTO wmw_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ikisa tena, ewo awakikisha kuwa vyakweli vyawasema kuwa nikosa‑vi. ");
INSERT INTO wmw_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ila canitikiza kutenda kinu kimoja. Nifulata kundi ra Njira ya Insa, fala ewo wakwamba kuwa kundi ra walongo. Omi nintumika Mwenyezimungu wawantukuze wababu zetu. Nukwamini piya vyaandikiwe nTaureti na vyawandike minabii. ");
INSERT INTO wmw_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Omi nirindira na nitumaini ka Mwenyezimungu kamba vyawantumaini ewo novyo, kuwa wenye shariya na ware sawana shariya wakuja kufufuka. ");
INSERT INTO wmw_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Ndimana daima vinajibu moyo wangu usisusuke mbere ya Mwenyezimungu pamoja na wanu piya. ");
INSERT INTO wmw_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Bandi ya myaka mingi yawenye, niludira inti yangu nilavye zaka na nitende kafara. ");
INSERT INTO wmw_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Panikitenda javyo, nakwisa jambo ra kuswafi, waniwona nNyumba Takatifu, nemo siwere kaumu ya wanu, wala siwadimbwanye. ");
INSERT INTO wmw_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Falakini nomo, wakiwapo Mayahudi wamojawapo wa Aziya. Ewo ndi wajuzi kuja mbere yako, wereze makosa angu ikiwa wawonerera kinu kimojawapo julu yangu omi. ");
INSERT INTO wmw_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Kuwasa ewo, ewa wari epa‑wa, wereze kamba waniwonerera kosa panimisiwe mbere ya Baraza ya kulamula. ");
INSERT INTO wmw_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Ila canifahamu omi, panikiwa kati yawo nitenda kinu kimoja. Omi nisema na shauti ulu‑ulu, namba: ‘Umwe rero munilamula, kwa sababu nukwamini kuwa wafwi wafufuka.’ ” ");
INSERT INTO wmw_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Felishi, kwa kuwa iye mwanyewe akijiwa sana-sana Njira ya Insa ire, akifuja kulamula kure akamba: “Epa, silamula. Mpaka aje Lisiya ndi panisaka kulamula.” ");
INSERT INTO wmw_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Noparepare akimwambira nfalume wa masurudadu, akamba: “Kanture Paulu nkalaboshu, ila umpe nafasi aba, asikazike na marafiki zake wakija kunsaidiya, usiwakataze.” ");
INSERT INTO wmw_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Bandi yakupita suku nyingi zawenye, Felishi pamoja na nkawake Durusira, Yahudi, watumiza kumwita Paulu. Iye akiwereza kuhusu kumwamini Insa Almasihi, ewo wakisikira. ");
INSERT INTO wmw_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Paulu paakolota uhakika kuhusu mambo a shariya, vyaakidiri munu kukaidi moyo wake, na kuhusu suku ya Kiyama cisaka kuja, Felishi akisusuka, akijibu akamba: “Epa lawa kwanza. Nikipata nafasi suku nyengine, nukwitisa!” ");
INSERT INTO wmw_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Felishi akirindira kuwa Paulu akumpa ciwa conse, ndimana akimwita akisowera naye mpunde-mpunde. ");
INSERT INTO wmw_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Paitimire myaka miwiri, Poritiyu Feshitu akitawaziwa kuwa guvinadoru kiti ca Felishi. Kwa kuwa Felishi akiwapendeleya Mayahudi, Felishi paalawire kamwasa Paulu nkalaboshu nomure. ");
INSERT INTO wmw_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Feshitu, paafikire porovinsiya ire, bandi ya suku natu akilawa Kaisariya kure, akikwera akuka Yerusalemu. ");
INSERT INTO wmw_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Nakufika, wakulungwa wa dini pamoja na wakulungwa wa Mayahudi wakimpatisa habari kuhusu makosa a Paulu. Wakinlebela, ");
INSERT INTO wmw_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","awatendere fadili amwitise Paulu aje Yerusalemu kure, ewo wakiritengeza wamwikarire munjira wamulaye. ");
INSERT INTO wmw_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Fala Feshitu akiwajibu javi: “Paulu ajuzi arinde kwanza Kaisariya, anta omi mwanyewe nukuka noko suku karibu. ");
INSERT INTO wmw_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Basi, ikiwa iye katenda kinu kimojawapo cakunyata, wakulungwa wenu wanifulate wakaseme caakosire.” ");
INSERT INTO wmw_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Feshitu kekala nawo Yerusalemu kure kiyasi ca suku nane wala azipundire suku kumi, ikisa akisuka akuka Kaisariya. Subuu yake pekare kiti cake kati ya wenye kulamula, akitumiza kumwita Paulu. ");
INSERT INTO wmw_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Paafikire Paulu, Mayahudi wajire kulawa Yerusalemu ware wakinzunguriza, wakanza kumbunira vitendo vingi vyawenye vyakofya, fala vitendo-vyo awakikidiri kwakikisha. ");
INSERT INTO wmw_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Sambi, Paulu kwa kurikotola, akamba: “Omi sikosere shariya ya Mayahudi wala shariya ya Nyumba Takatifu, wala shariya ya Kaisari.” ");
INSERT INTO wmw_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Basi Feshitu, kwa kuwapendeleya Mayahudi, kandairi Paulu: “Usaka uke Yerusalemu mwaha‑wu nikakulamure noko?” ");
INSERT INTO wmw_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Fala Paulu akijibu, akamba: “Epa nimira mbere ya wenye kulamula wa Kaisari, mahala panijuzi kulamuriwa. Mayahudi siwatendire kinu ca ubaya anta kimoja, kamba vyawijiwe. ");
INSERT INTO wmw_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Ikiwa kweli-kwelini nitupa shariya mojawapo yakujuzi kuhukumiwa kifo, sikatala kufwa. Fala ikiwa vyawanisowerera‑vi sivyo vyakweli, aapo wakujuzi kunipereka mmakono mwawo. Basi, nilebela ka Kaisari akanilamure!” ");
INSERT INTO wmw_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Basi, Feshitu akisowera na wamashauri wake, ikisa akinjibu Paulu: “Kulebela ka Kaisari, epa ukuka ka Kaisari noko!” ");
INSERT INTO wmw_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Basi, bandi ya wingi wa suku, wakija Kaisariya kuwonana na Feshitu nfalume wakwitiwa Agiripa na nlumbuwe Berenika. ");
INSERT INTO wmw_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Kwa kuwa wékala noparepare suku aba, Feshitu akimwereza nfalume ire habari za Paulu, akamba: “Kawapo‑pa mwananlume mmoja kasiwa na Felishi, kawa nkalaboshu kafungiwa. ");
INSERT INTO wmw_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Panukire Yerusalemu, wakulungwa wa dini pamoja na wazee wa Mayahudi wanereza makosa ake na wanilebela nimhukumu noyo mwananlume‑yo. ");
INSERT INTO wmw_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Omi niwambira kuwa siyo tabiya ya waRoma kumhukumu mwenyé ukosa saari mbere ya wenye kukosiwa, ipate apewe nafasi ya kujibu vyaalongoperiwe. ");
INSERT INTO wmw_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Ndimana wakati wawajire kuno, sisakire kupoteza wakati. Pakucere subuu, nikala kiti cangu cakulamula shariya, na nikitumiza kutwariwa mwananlume‑yo. ");
INSERT INTO wmw_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Kuhusu iye, pawalamuke wenye kunlongopera ware, acipo cawasemire vyanikidanizira omi kuwa katenda kinu kibaya. ");
INSERT INTO wmw_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Ila wâmmonerera tafauti mmojawapo kuhusu dini yawo, na kuhusu munu mmoja wakwitiwa Insa, afwire fala Paulu akwamba kawapo hai. ");
INSERT INTO wmw_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Kwa kuwa omi sereriwa kukaidiyana kwawo kuhusu mwaha‑wu, ndimana nindairi kamba asaka kuka Yerusalemu akalamuriwe noko mwaha‑wu. ");
INSERT INTO wmw_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Fala Paulu, kwa kuwa kalebela ekare akisungiwa novire ipate alamuriwe kwa shariya na nfalume nkulu wa Roma, namuru namba: ‘Nsungeni, mpaka panisaka kumpereka ka Kaisari.’ ” ");
INSERT INTO wmw_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Ikisa nfalume Agiripa ire akimwambira Feshitu: “Omi vikinajibu ninsikire mwanyewe noyo mwananlume‑yo.” Feshitu akinjibu: “Unsikira makeshamungu.” ");
INSERT INTO wmw_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Kwa javyo, subuu yake Agiripa na Berenika wakifika na fahari zawo, wakingira pansana nkulu pamoja na wakulungwa wakulu wa masurudadu na wanu wengine mabora wa noire kaya ire. Ikisa Feshitu akitumiza, wakija nawo Paulu. ");
INSERT INTO wmw_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Feshitu akamba: “Nfalume Agiripa na piya mamwenye muripo epa pamoja nofwe, mwankumona eyu mwananlume‑yu wawari kunilebela Mayahudi piya wankaya‑mu, na wa Yerusalemu, kuno wakilalamika kuwa iye asiinshi tena‑yu. ");
INSERT INTO wmw_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Fala omi simmonerere kinu camana caatendire cakujuzi iye kuulaiwa. Na kwa kuwa kalebela akalamuriwe na nfalume nkulu wa Roma, namuru kumpereka. ");
INSERT INTO wmw_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Fala omi sina kinu maalumu cakumwandikira nfalume nkulu‑yo kuhusu iye. Ndimana nija naye epa mbere yenu, pakulu-pakulu mbere yako uwe, nfalume Agiripa, ipate ikiwa mwaha wake wikaririwa, nipate cakwandika. ");
INSERT INTO wmw_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Kamana aviswii kumpereka nfungwa bila kwereza sana-sana makosa ake.” ");
INSERT INTO wmw_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agiripa kamwambira Paulu: “Aya, nukupa riusa ya kusowera kwa ajili yako.” Paulu akolosa nkono, akanza kurikotola, akamba: ");
INSERT INTO wmw_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Nfalume Agiripa, kuhusu piya vinu vyanilongoperiwa na Mayahudi, niwa radi kuwa mbere yako rero kurikotola. ");
INSERT INTO wmw_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Visitoshe, niwa radi kwa kuwa ukwijiwa piya kuhusu tabiya na tafauti za Mayahudi. Ndimana nukulebela uhitamili kunisikiriza canisaka kusowera‑ci. ");
INSERT INTO wmw_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Mainsha angu tangu mwanzo wa unemba wangu, kati ya kabila yangu na Yerusalemu, wakwijiwa sana-sana piya Mayahudi. ");
INSERT INTO wmw_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Ewo wanijiwa tangu mida, wakisaka kwakikisha kuwa, kwa kufulata shuruti za kaumu ya dini yetu, niinshi kamba Nfarizeu. ");
INSERT INTO wmw_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Epa sambi, kwa kuwa nirindira tamaa ya Mwenyezimungu yaawapere wababu zetu, niwa epa nankulamuriwa. ");
INSERT INTO wmw_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Neyo ndi tamaa moja noyo irindiriwa na marikolo etu kumi na mawiri, kuntumika na niya Mwenyezimungu usiku na nsana. Ndi kuhusu noyo tamaa‑yo, nfalume wangu, kuwa nankulongoperiwa na Mayahudi. ");
INSERT INTO wmw_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Umwe muwaza kuwa virigariga Mwenyezimungu kuwafufula wafwi, sababuni? ");
INSERT INTO wmw_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Anta na nomimi novyo, nîwona kuwa inibidi kutenda vinu vingi vyakubishana na zina ra Insa nNazareti. ");
INSERT INTO wmw_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Ndi vyanikunishe novyo Yerusalemu. Panikipewa mamulaka na wakulungwa wa dini, wengi kati ya watakatifu, nikiwataya nkalaboshu nikiwafunga. Na pawakiulaiwa, omi nikipendeleya. ");
INSERT INTO wmw_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Masinagoga mengi, mara nyingi zawenye, niwatubisa, niwashurutisa kukufuru. Niwashupa na niwalumbata anta na inti nyengine za baidi.” ");
INSERT INTO wmw_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Kwa kuwa wanipa mamulaka na uwezo wa wakulungwa wa dini, noyi niya‑yi ndi initenzire kuka Damashiku. ");
INSERT INTO wmw_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Nfalume wangu, úkiwa wakati wa aduri, munjira niwona nuru binguni. Nuru‑yo yakuzaidi juwa, ikinuru nanyenje yangu na piya wanisafirire nawo. ");
INSERT INTO wmw_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Noparepare piya-fwe nakugwira pansi, nisikira shauti ikisowera kiebraniya, ikamba: “Saulu, Saulu! Sababuni kunilumbata? Wase kubishana na wema wako!” ");
INSERT INTO wmw_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Nomi nikidairi: “Uwe nani, Mwenye?” Mwenye akinijibu: “Omi Insa, noyo wauri kunlumbata‑yo! ");
INSERT INTO wmw_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Lamuka, wimire na maulu ako. Kamana noci ndi canukulawirire ipate nukuture kuwa ntumisi na ushahidi wangu, wa evi vinu vyanukolotere‑vi na vyanisaka kukolotera mbere. ");
INSERT INTO wmw_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Nukuvusha kati ya Mayahudi na Sawari-Mayahudi, ka wanu waniri kukutuma, ");
INSERT INTO wmw_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","ipate uwafungure maso awo, waludi kukisi waje kunlangaza, na uwavushe kati ya uwezo wa Ibilisi waje ka Mwenyezimungu. Kwa javyo, waswamiiwa dambi zawo na wapokerera irati yawo kati ya wanu watakatifiwe julu ya kunamini omi. ");
INSERT INTO wmw_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Kwa javyo, nfalume wangu Agiripa, aabishire ruhuya ya binguni. ");
INSERT INTO wmw_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Nanza kuwereza wanu wa Damashiku, waYerusalemu, inti za Yudeya, pamoja na Sawari-Mayahudi. Piya‑wo niwereza watubiye, waludire upande wa Mwenyezimungu, watende vitendo vyakolota kutubiya kwawo. ");
INSERT INTO wmw_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Kwa sababu ya novi vinu‑vi, Mayahudi wakinikola niri nNyumba Takatifu, wakisakula kunulaya. ");
INSERT INTO wmw_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Basi, kwa kuwa nipata kunusuriwa na Mwenyezimungu, niwapo mpaka rero nankulavya ushahidi ka ntoto na nkulu, bila kongeza vinu, vyawasemire minabii pamoja na Musa kuwa vikuja kukuna. ");
INSERT INTO wmw_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Nankulavya ushahidi kuwa ikibidi Almasihi atabike, awe ntanzi kufufuka kati ya wafwi, ipate habari ya nuru yereziwe ka Mayahudi na wanu Sawari-Mayahudi.” ");
INSERT INTO wmw_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Paulu, paakisowera javi akirikotola, Feshitu akikuwa na shauti ulu‑ulu: “Uwe Paulu kubanga! Kufyoma pakulu kukubangisa na kukubadili!” ");
INSERT INTO wmw_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Fala Paulu akijibu: “Mwenshimiwa Feshitu, omi sibangire, ila nankusema usemi wa kweli na wa ankili kamili. ");
INSERT INTO wmw_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Kamana nfalume wangu akwijiwa sana-sana vinu‑vi piya. Ndimana nikidiri kusowera mbere ya nfalume wangu bila wofi. Nanawo uhakika kuwa hapana kinu cakunfisa iye. Kusema kweli, avikunire mahala pakufisika. ");
INSERT INTO wmw_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Nfalume wangu Agiripa, uwakubali minabii? Nukwijiwa kuwa uwakubali!” ");
INSERT INTO wmw_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Basi Agiripa kamwambira Paulu: “Kwa wakati ntoto javi, unitenza kuwa nfulati wa Insa?” ");
INSERT INTO wmw_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Paulu akijibu akamba: “Ninlebela Mwenyezimungu kwa wakati ntoto au nkulu, suwe basi fala na piya wari kunisikira rero wawe novyo caniri‑ci, ila sawafungiwe nevi vyuma‑vi!” ");
INSERT INTO wmw_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Ikisa wakilamuka nfalume Agiripa, guvinadoru, Berenika, na piya ware wákiwa pamoja nawo. ");
INSERT INTO wmw_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Pawalawire, wakambirana watupu, wakamba: “Eyu mwananlume‑yu aatendire kinu cakujuzi kuulaiwa wala cakujuzi kufungiwa.” ");
INSERT INTO wmw_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Basi, Agiripa akimwambira Feshitu: “Mwananlume‑yu nanga kafunguriwa sambi‑pa paiwa âlebele kulamuriwa na Kaisari!” ");
INSERT INTO wmw_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Payamuriwe kuwa tíjuzi tisafiri tuke Italiya, Paulu na wafungwa wengine akigabiziwa Juliyu, nkulungwa wa masurudadu maalumu wa Kaisari. ");
INSERT INTO wmw_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Tikingira mbatela ra mwananlume wakwitiwa Adiramitu, batela síro rikuka visiko vya Aziya. Kwa javyo tikilawa, tikisafiri na mwenye wakwitiwa Arishitariku, mMakedoniya kwawo Tesalonika. ");
INSERT INTO wmw_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Subuu yake, tikifika Sidoni. Juliyu kantafiti Paulu sana, kampa riusa kuka ka marafiki zake ipate apewe vyaakisakula. ");
INSERT INTO wmw_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Noparepare tikuka mbere na safari yetu mpaka sini ya kisirwa ca Kiporo, kwa kuwa úkiwa mbisho. ");
INSERT INTO wmw_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Nakutupula bahari ya Kilikiya na Panfiliya, tikifika Mira, kaya ya Lisiya. ");
INSERT INTO wmw_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Pakisiko pare, nfalume wa kundi ra masurudadu kasingana batela ra Aleshandriya, rikuka Italiya. Akitipakirisa nomo. ");
INSERT INTO wmw_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Tenenda more-more suku nyingi zawenye, na kwa tafauti nyingi, tikifika karibu ya Nidu. Na, kwa kuwa úkiwa mbisho, tikisafiri mpaka sini ya Kereta, tikipunda ransi ya Salamona. ");
INSERT INTO wmw_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Na tafauti nyingi zawenye, nanyenje-nanyenje tikifika mahala pamoja pakwitiwa “Kisiko Cema”, karibu na nopo íkiwepo kaya yakwitiwa Laseya. ");
INSERT INTO wmw_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Kwa kuwa zîpita suku nyingi zawenye (kusema kweli, ûpita wakati wakufunga Mayahudi), ndimana zíkiwapo tafauti zakofya kati ya safari. Kwa javyo, Paulu akiwakumbusa, akiwambira javi: ");
INSERT INTO wmw_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Jamaa, nankuwona kuwa iwapo hasara na kupoteyiwa kwingi, aipoteya mizigo na batela‑ri basi, na mainsha etu novyo.” ");
INSERT INTO wmw_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Fala nfalume wa kundi ra masurudadu ire kasikiriza vyaambiriwe na nawoda pamoja na mwanyewe batela ire, koliko kunsikiriza Paulu vyaasowere. ");
INSERT INTO wmw_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Pakisiko pare apawerepo mahala pema pakwikala wakati wa baridi. Ndimana wanu wengi wâwaza kuwa tíkijuzi titweke tuke na safari yetu, tiyerere kufika kaya ya Foinikiya, ipate tikekare noko wakati wa baridi. Foinikiya kisiko ca Kereta, cikala sana, cíkiwa na upande wakukashikazi na wakukusi. ");
INSERT INTO wmw_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Kanza kuvuma kusi aba-aba, wanawalume ware wakidaniza kuwa haja yawo watimiza, wakivuta nanga wakilawa, wakitambala na lufuko ra Kereta. ");
INSERT INTO wmw_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Falakini, kwa mpunde sinkulu, akanza kuvuma ulani mwingi, akilawirira na kisirwa. ");
INSERT INTO wmw_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Ulani ire kavuma batela rikanza kubengwa. Kwa kuwa akukikidirika kubisha, tikasa batela rire, rikiveverusiwa na mepo. ");
INSERT INTO wmw_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Tikisafiri kuno tikiribanza na kisirwa kitoto cakwitiwa Kauda. Ingawa na mashaka, fala tikidiri kukweza kiboti ca batela rire. ");
INSERT INTO wmw_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Nakukweza wakifungira mbatela na mizizi yakurimba. Ikisa wakopereza kupwerera mmavula a lufuko ra Libiya. Basi wakitula matanga, wakasa batela rire rikiveveruka na mepo. ");
INSERT INTO wmw_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Kwa kuwa maluwimbi akitibiya pakulu-pakulu, subuu yake wakanza kwefya mizigo mbahari. ");
INSERT INTO wmw_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Suku yatatu, na makono awo wanyewe, vyombo vya mbatela mure wakanza kwefya mmaji. ");
INSERT INTO wmw_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Anta juwa wala nondwa avikiwoneka suku nyingi zawenye, na rikitisalamukira gaibu, mwinsho ikitilawa tamaa piya ya kuvuka. ");
INSERT INTO wmw_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Kwa kuwa wanu wekala wakati mwingi sawarya, ndimana Paulu kemira kati-kati, akiwambira: “Ikibidi, jamaa zangu, munisikirize omi noparepare, musilawe Kereta kure, kukengera eyi hasara‑yi na kupoteyiwa kuno. ");
INSERT INTO wmw_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Fala sambi, nukupani ankili musiuzunike, kamana aakupoteyani munu, ila rukupoteyani batela‑ri basi. ");
INSERT INTO wmw_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Kamana ijana usiku kanisukira laika wa Mwenyezimungu, Nlungu wangu wanimwabudu omi. ");
INSERT INTO wmw_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Laika‑yo kanambira: ‘Paulu, usope! Ikukubidi wimisiwe mbere ya Kaisari. Ona, Mwenyezimungu kakugabizi mainsha a piya wauri kusafiri nawo‑wa, ewo wanusurika.’ ");
INSERT INTO wmw_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Ndimana jamaa zangu, muwe radi. Kamana nintumaini Mwenyezimungu kuwa vikuwa novyo kamba vyanambiriwe. ");
INSERT INTO wmw_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Fala itibidi tikapwerere kisirwa kimojawapo.” ");
INSERT INTO wmw_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Paufikire usiku suku yakumi na nne, paakitipata makucukucu kuno na kuno bahari ya Mediteraneya, kiyasi ca usiku kati-kati, mabahariya wa fahamu kuwa tiwa karibu na nrima. ");
INSERT INTO wmw_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Sambi, wakefya kipimo ca maji, wakiwona kuwa awa meturu shirini. Wakisengereza mbere, wakefya tena kipimo cire, wawona awa meturu kumi na ntanu. ");
INSERT INTO wmw_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Ewo wakopereza batela rire kuveverusiriwa pamwamba. Ndimana wakitaya nanga nne, ikisa wakilebela duwa kuce. ");
INSERT INTO wmw_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Mabahariya wakisakula kutira mbatela mure. Ndimana wêsusira kiboti mmaji, wakiritenza kamba woka kutaya nanga ya mbere mbatela mure. ");
INSERT INTO wmw_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Kwa javyo, Paulu akimwambira nkulungwa na masurudadu wake: “Ikiwa mabahariya‑wa awekala mbatela‑mu, basi amuvuka.” ");
INSERT INTO wmw_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Ikisa, masurudadu wakitupula mizizi yawafungire kiboti ire, wakasa cikigwirira mmaji cubuu. ");
INSERT INTO wmw_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Pakucere, Paulu akiwatafadali piya warye cakurya, akiwambira javi: “Epa zankutimu sumana mbiri mukirindira kuno mufungire samunaluma luziki. ");
INSERT INTO wmw_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Ndimana nankukwambirani iryani cakurya, kamana mukirya ndi salama yenu. Konta anta nywiri mmoja nkiswa mwake aapo waisaka kumpoteya.” ");
INSERT INTO wmw_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Nakwamba javire, akitwala nkate, akishukuru ka Mwenyezimungu mbere ya wanu piya, ikisa akimeya nkate, akanza kutafuna. ");
INSERT INTO wmw_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Piya ware ikiwengira niya, newo novyo piya wakanza kurya. ");
INSERT INTO wmw_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Jumula ya wanu mbatela mure piya tíkiwa miyateni na sabini na sita. ");
INSERT INTO wmw_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Pawarire wakikuta, wakiveusa batela rire kwa kutwala saku za tirigu wakipakurira mbahari. ");
INSERT INTO wmw_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Pakucere, awamanyire nrima. Fala wawona muto wakwingira nkati na lufuko. Basi wakiwaza kuka kupwereza batela rire nopare. ");
INSERT INTO wmw_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Mabahariya ware wakifungula mizizi ya nanga, wakasa mmaji, kuno wakifungula mizizi ya shukani ya batela rire. Ikisa wakitweka tanga rikingira mepo, wakilongoza kulufuko. ");
INSERT INTO wmw_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Fala batela rire rikuka rikipwerera pavula. Ripwerera mbere arikenenda, nyuma rikibiiwa na maluwimbi. ");
INSERT INTO wmw_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Mpango wa masurudadu ware wâwaza wawolaye wafungwa ipate wasije kowera kuwatira. ");
INSERT INTO wmw_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Fala nfalume wa kundi ra masurudadu akisaka kunvusha Paulu, ndimana akiwakataza cawalangele cire. Akiwamuru javi: “Wejiwa kowera onse, wanze kurefya mbahari, woke kungulu.” ");
INSERT INTO wmw_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Wengine woke na mbawo au kinu kimojawapo ca mbatela mure. Javi ndi vyaviwere piya tikivuka salama kungulu. ");
INSERT INTO wmw_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Patisire kuvuka salama, tijiwa kuwa kisirwa cire cikwitiwa Melita. ");
INSERT INTO wmw_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Wenye kaya wa kisirwa cire watitafiti vyema pakulu futi. Watiwesera moto mwingi wakitikaribisha kota kwa kuwa ikinya nvula na ikizizima baridi. ");
INSERT INTO wmw_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Paulu akilokota viwanzu, akitaya pamoto. Mpunde noure, kwa ntukuta wa moto ure, akilawa nyoka nviwanzu mure, akiluma cala Paulu. ");
INSERT INTO wmw_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Wenye kaya ware, pawammonire nyoka ire angamire ncala cake, wakanza kwambirana watupu: “Kweli-kwelini eyu mwananlume‑yu kisomi. Ingawa kakidiri kuvuka mbahari fala shariya aimwasa kuinshi tena.” ");
INSERT INTO wmw_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Fala nyoka ire akinsasanyira pamoto, iye aalumire anta mahala. ");
INSERT INTO wmw_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Wanu ware wakidanizira kuwa avimba au akufwa gafula mpunde noure. Fala upita wakati mwingi wawenye, wammona kuwa acinkunire kinu, wapindula mawazo, wamba: “Eyu nlungu!” ");
INSERT INTO wmw_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Karibu noparepare, ákiwapo masamba a nkulungwa wa kisirwa cire, mwenye mmoja wakwitiwa Pubiliyu. Iye katipokerera sana-sana, tíkiwa wayeni wake muda wa suku natu. ");
INSERT INTO wmw_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Wawaye Pubiliyu ákiwa na homa na akipulugari damu, ákilala pakinanda. Paulu akuka akimmona, akintula nkono, nakunlebelela duwa, nlwere ire akipona. ");
INSERT INTO wmw_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Bandi yakukuna javire, piya wakiwóna kulwaza nkisirwa mure wakija ka Paulu akiwaponesa. ");
INSERT INTO wmw_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Nowo watinshimu pakulu futi, na wakati watikilawa kuka, wenye kaya watipa piya catikisakula. ");
INSERT INTO wmw_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Bandi ya myezi mitatu, tikiripakira mbatela rengine rakulawa Aleshandriya. Batela‑ro ríkiwa Melita wakati wa kinja, mbere ricapariwa alama “Milungu ya masa”. ");
INSERT INTO wmw_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Tikenenda, tikifika Sirakusa, tikisuka tikikala noko suku natu. ");
INSERT INTO wmw_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Ndi katilawire, tikuka tikifika kaya ya Reziyu. Subuu yake akanza kuvuma kusi, basi tenenda suku mbiri, tikifika kisiko ca Potiyoli. ");
INSERT INTO wmw_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Pakisiko pare, tiwasingana wanduzetu wakitilebela tikare nawo sumana mmoja. Javi ndi vyatenende, tikifika mpaka Roma. ");
INSERT INTO wmw_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Wanduzetu wa Roma, pawejiwe kuwa tankuka kwawo, wakija kutiwinza. Wengine tisimanana “Kumangisha a Apiyu” na wengine mahala pakwitiwa “Manyumba matatu a wayeni”. Paulu, pawawonire wanu ware, akinshukuru Mwenyezimungu, akizidi kuwa na nguvu. ");
INSERT INTO wmw_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Patifikire Roma, Paulu kapewa riusa kufikira nyumba yake yeka na surudadu mmoja basi wakunsunga. ");
INSERT INTO wmw_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Iwa zipita suku natu, Paulu akitumiza kuwarifu wakulungwa wa Mayahudi wa Roma akanza kujumana nawo. Pawajumane, akiwambira: “Wanduzangu, omi sitendire kinu cakuwakosera wanu wetu, wala situpire tabiya ya wababu zetu. Fala Yerusalemu niperekiwa mmakono mwa waRoma kamba nfungwa. ");
INSERT INTO wmw_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Ewo wanidairi na wakisaka kunifungula, kwa kuwa kosa rimojawapo rakujuzi kunihukumu kifo awaniwonerere. ");
INSERT INTO wmw_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Fala Mayahudi kwa kuwa wakinikaidi, ndimana inibidi kulebela nuke ka Kaisari, ingawa sina kinu kimojawapo cakuwasema cakubishana na wanu wa kwetu. ");
INSERT INTO wmw_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Ndimana nukwitani munang'anize muwone na tipakanire. Kwa sababu ya tamaa ya waIziraeli, epa nifungiwa na unyolo wa cuma‑wu.” ");
INSERT INTO wmw_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Basi ewo wakimwambira javi: “Ofwe kuhusu uwe atipokerere waraka anta moja yakulawa Yudeya, wala aajire nduyetu mmojawapo na habari kuhusu ewu mwaha‑wu, wakukusowerera kinu kibaya. ");
INSERT INTO wmw_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Fala ofwe vikitajibu tukusikire na kanywa yako cauwaza, konta tukwijiwa kuwa kipinga cauri‑ci kila mahala cikaidiwa.” ");
INSERT INTO wmw_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Basi, wakisikizana wakitula suku. Noyo suku‑yo, wanu wengi wawenye waja ka Paulu. Mwanzo wa subuu mpaka jironi, iye akiwambira ushahidi kuhusu ufalume wa Mwenyezimungu, akiyerera kuwakubalisa kuhusu Insa, kwa kutumira Taureti na mandiko a minabii wengine. ");
INSERT INTO wmw_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Wengine wakikubalisiwa kwa vyawakereziwa vire, fala wengine awakikubali. ");
INSERT INTO wmw_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Wakikaidiyana watupu. Sawanamba kulawa, Paulu akiwambira kinu cengine, akamba: “Roho Takatifu ákiwa na shariya yakusowera na babu zenu julu ya nabii Izaya, paambire javi: ");
INSERT INTO wmw_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘Uka ka ewa wanu‑wa, ukawambire javi: Musikira na masikiro fala amwereriwa anta aba, nakunang'aniza munang'aniza fala amuwona anta aba. ");
INSERT INTO wmw_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Konta myoyo ya wanu‑wa migumu. Masikiro awo aasikira sana, maso awo afunga. Siwere javyo, maso awo nanga awona, masikiro awo nanga asikira, myoyo yawo nanga wereriwa, ewo nanga waludi waja kwangu, nomi nanga niwaponesa’ ” amba ndi Mola. ");
INSERT INTO wmw_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Paulu akizidi kusowera akamba: “Basi, ijiwani kuwa eku ndi kuvuka Mwenyezimungu kawaperekere Sawari-Mayahudi; na ewo wakuja kusikiriza.” ");
INSERT INTO wmw_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Paulu kekala myaka miwiri noire nyumba yake yaâlugariwe ire. Nomo, akiwapokerera piya wanu wakija kummona. ");
INSERT INTO wmw_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Iye akereza habari ya ufalume wa Mwenyezimungu, na akifunda kuhusu Mwenye Insa Almasihi, akisowera bila wofi wala aakikataziwa na munu.");
INSERT INTO wmw_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Omi Paulu, ntumisi wa Almasihi Insa, etiwe awe walii, wapambari wa kwereza Habari Ngema ya Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Eyi habari‑yi Mwenyezimungu kâlavya tamaa mida julu ya minabii wake mMandiko Matakatifu. ");
INSERT INTO wmw_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Habari‑yi íkiwa kuhusu Mwanawe. Upande wa kibinadamu, iye kapongoriwa nkati ya rikolo ra Daudi. ");
INSERT INTO wmw_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Upande wa roho yake, ákiwa takatifu, iye aturíwe na uwezo kuwa Mwana wa Mwenyezimungu kwa kufufuka ka wafwi. Iye ndi Insa Almasihi, Mwenye wetu. ");
INSERT INTO wmw_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Julu yake iye ndi patipokerere rehema na uwalii ipate tiwete wanu wa mataifa piya wamwamini iye, wanfulate, kwa faida ya zina rake. ");
INSERT INTO wmw_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Umwe novyo muwa kati ya wanu mwitiwe kuwa wa Insa Almasihi. ");
INSERT INTO wmw_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Kwa piya umwe muri Roma, wenye kupendiwa na Mwenyezimungu, mwitiwe muwe watakatifu, rehema na usalama viwe namwe kulawa ka Mwenyezimungu Baba wetu na ka Insa Almasihi, Mwenye wetu. ");
INSERT INTO wmw_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Cakwanza, ninshukuru Nlungu wangu, julu ya Insa Almasihi, kwa umwe piya, konta kwamini kwenu kwankwereziwa ulumwengu‑wu piya. ");
INSERT INTO wmw_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Shahidi wangu ndi Mwenyezimungu, waniri kuntumika na roho yangu julu ya kwereza Habari Ngema ya Mwanawe, kuwa panilebelanga duwa, nukukutajani nfululu moja. ");
INSERT INTO wmw_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Nilebela kuwa, kwa kufulata vyaasaka Mwenyezimungu, nipate nafasi ya kuja kwenu umwe. ");
INSERT INTO wmw_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Konta vinajibu pakulu futi nije nukuwoneni, ipate nukugabizini uwezo maalumu mmojawapo wakwisusiriwa na Roho, ipate murimbisiwe. ");
INSERT INTO wmw_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Caniri kwamba ndi‑ci: tirimbisane myoyo nkati ya kwamini kwetu kumoja, kwenu umwe na kwangu omi. ");
INSERT INTO wmw_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Wanduzangu, vinajibu mwijiwe kuwa nipanga mara nyingi zawenye kuja kukuwonani, fala mpaka sambi‑pa sinapata nafasi. Vinajibu niwatenze wanu wamojawapo wamwamini na wanfulate Insa, kati yenu umwe na novyo kati ya wanu wengine Sawari-Mayahudi. ");
INSERT INTO wmw_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Kusema kweli, vinilazimu kuwasaidiya wanu wa tabiya yetu na wanu wa tabiya nyengine, wanu wakusilimuka na wanu sawasilimuke. ");
INSERT INTO wmw_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Ntamana, niwa radi kuja kwenu mwikala Roma-mwe kukwerezani Habari Ngema. ");
INSERT INTO wmw_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Kusema kweli, siwona haya kwa eyi Habari Ngema‑yi konta ndi uwezo wa Mwenyezimungu kuwavusha piya wenye kumwamini, mwanzo wa Yahudi mpaka Saari-Yahudi. ");
INSERT INTO wmw_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Kamana ukamilifu wa Mwenyezimungu ufafanuriwa nkati ya Habari Ngema, namuna za kwamini mwanzo mpaka mwinsho. Kamba vyavyandikiwe: “Kamilifu áinshi julu ya kwamini.” ");
INSERT INTO wmw_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Ifafanuriwa nyongo ya Mwenyezimungu binguni julu ya piya kutowa kuwepo ka dini na kukosa ukamilifu ka wanu, julu ya kutowa ukamilifu‑ko, ndi kuwatenza wanu kufuja ukweli. ");
INSERT INTO wmw_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Kamana ukweli kuhusu Mwenyezimungu ufafanuriwa kati yawo, kwa kuwa Mwenyezimungu kawafafanurira. ");
INSERT INTO wmw_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Tangu kumbiwa ulumwengu, namuna zake saziwoneka, kwa nfano uwezo wake sauna mwinsho na unlungu wake, vyeleweka na vijiwikana sana-sana julu ya vinu vyaatenda Mwenyezimungu. Basi ewo awana shariya yakolota. ");
INSERT INTO wmw_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Kamana ingawa wamwijiwa Mwenyezimungu, fala awantukuze kamba Nlungu wawo wala awanshukurire. Kwasa javyo, wanza kufikiri mawazo saana mana, na myoyo yawo iwazizima, ikingíziwa nkisi. ");
INSERT INTO wmw_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Waritula kuwa wejiwifu kumbe mazozo. ");
INSERT INTO wmw_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Wasa kumwambudu Mwenyezimungu saabadilika, wapindula wambudu maswanamu a wanu wakubadilika, a nyuni, a wadudu pamoja na a manyoka. ");
INSERT INTO wmw_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Ntamana, Mwenyezimungu kawasa watende viwájibu myoyo yawo, vitendo vya ucafu, watebeni miri yawo wanyewe. ");
INSERT INTO wmw_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Iye awatenda javyo konta wapindula ukweli wa Mwenyezimungu wafulata ulongo. Novyo, wamwabudu na wantumika kiyumbe, wasa kumwambudu Mwenyé kumba wawenye. Iye ájuzi asifiwe milele! Aamina. ");
INSERT INTO wmw_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Ntamana, Mwenyezimungu kâwasa watende vitendo vyawo vyakuwajibu vyakuwatenza aibu. Anta na wanawaka wapindula namuna yawajuzi kuloriwa na walume wawo, wanza kulolana wanawaka watupu. ");
INSERT INTO wmw_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Namuna mmoja noyo, walume wasa kuwalola sana waka wawo, yanza kuwalunguza myoyo kwajibiwa pakulu na walume wenziwawo. Walume watupu watenda vitendo vya aibu, ntamana nkati yawo hukumu iwajuzire kwa makosa awo waritabisha wanyewe. ");
INSERT INTO wmw_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Kwa kuwa awolote kumwijiwa Mwenyezimungu, iye kawasa na ankili zawo za ubaya, watende vitendo sawajuzi kutenda. ");
INSERT INTO wmw_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Myoyo yawo ijala udainfu wa kila namuna, kusiyanisa masemo, ulwaziwa moyo, na ubaya. Kusema kweli, uwejala nfululu wiyana, ukakatima, wivu, ulongo, na uzuda. Walawirira kuwa wasemisemi, ");
INSERT INTO wmw_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","wanu wakuwasowerera caputu wenziwawo, wamwina Mwenyezimungu, majauri, wakuritenza, wakuridãi, wakubuni vinu vibaya, na wakubishana na wawa zawo. ");
INSERT INTO wmw_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Ewo awana ankili, awana kwamini, awampenda munu, na awana utungu. ");
INSERT INTO wmw_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Ewo wakwijiwa sana-sana shariya za Mwenyezimungu, kuwa wanu watenda novi vitendo‑vi wajuzi waulaiwe. Evi vitendo‑vi awatenda tu basi fala wawetikizira wengine watenda. ");
INSERT INTO wmw_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Ntamana auswamiiwa, uwe mwenyé kulaumu. Kamana unlaumu munu mwengine, kumbe kwankurilaumu mwanyewe. Konta uwe kwankutenda vitendo vimoja novyo vyaulaumu-vyo. ");
INSERT INTO wmw_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Tukwijiwa kuwa Mwenyezimungu, paabishana na wanu watenda vinu‑vi, hukumu yake ifulata shariya. ");
INSERT INTO wmw_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Tunza javi, uwe munu mmojawapo, uwalaumu watenda vitendo nnowe ukitenda novyo, udaniza kuwa utakunyema hukumu ya Mwenyezimungu? ");
INSERT INTO wmw_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Au kwankukejeli utajiri wa wema wa Mwenyezimungu, na kuvumirira kwake, pamoja na imani yake? Awijiwa kuwa wema wa Mwenyezimungu ukulongoza upate kutubiya? ");
INSERT INTO wmw_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Fala uwe, kwa sababu ya ugumu wa moyo wako pamoja na ubishi, kwankurongeza nyongo ikupate uwe mwanyewe suku yakwisuka nyongo, na suku yakolotiwa hukumu ya haki ya Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Iye mwenyé kunludisira kila mmoja kwa kitendo caatendire: ");
INSERT INTO wmw_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","upande mmoja, wasakúla utukufu, inshima, na uzima julu ya kutenda vinu vyema-vyema kwa kuvumirira, Mwenyezimungu awapa mainsha a milele. ");
INSERT INTO wmw_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Upande mwengine wafitíni na awafulata ukweli, wafuláta kukosa haki, Mwenyezimungu akimiyana nawo na nyongo pakulu. ");
INSERT INTO wmw_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Zije tabu na shida kwa kila mwanadamu aténda ubaya, mwanzo wa Mayahudi na novyo Sawari-Mayahudi, ");
INSERT INTO wmw_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","ila uje utukufu, inshima, pamoja na usalama kwa kila mwanadamu aténda meema, mwanzo wa Mayahudi na novyo Sawari-Mayahudi. ");
INSERT INTO wmw_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Kamana akupo kusiyana ka wanu mbere ya Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Wakorire dambi sawana shariya, newo novyo sawana mpaka wa shariya wapoteya. Ila wakorire dambi wari na shariya, shariya noyo iwahukumu. ");
INSERT INTO wmw_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Kamana sikuwa wasikíra shariya kuwa ndi makamilifu mbere ya Mwenyezimungu ila ware waja kwakikishiwa ndi waténda vyaisaka shariya. ");
INSERT INTO wmw_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Kamana wanu Sawari-Mayahudi sawana shariya, wakitenda vyaisaka shariya kwa kipongorero, ingawa awana shariya, wakolota kuwa wakwijiwa wanyewe shariya ya cema na kibaya. ");
INSERT INTO wmw_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Ewo wakolota kuwa shuruti ya shariya yandikiwa mmyoyo yawo. Fahamu zawo pamoja na ankili zawo zilavya ushahidi. Wakati mwengine ziwalaumu, wakati mwengine ziwengirira, suku ya Kiyama. ");
INSERT INTO wmw_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Suku‑yo, kwa kufulata utuba wangu, Mwenyezimungu julu ya Almasihi Insa alamula siiri za wanu. ");
INSERT INTO wmw_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Ona, uwe uritula kuwa Yahudi, utejemera shariya, na uridãi kuwa munu maalumu mbere ya Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Ukwamba kuwa ukwijiwa vyaasaka iye, na vikwajibu vinu bora vyaufundiwe kati ya shariya. ");
INSERT INTO wmw_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Ukuwa na uhakika kuwa uwakorera nkongojo vipofu, na kuwa nuru ka wanu wenenda pakisi, ");
INSERT INTO wmw_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","uwalongoza wenye kutikina, kuwa mwanlimu wa wanemba, na kuwa nazo namuna za wijiwifu na ukweli nkati ya shariya. ");
INSERT INTO wmw_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Uwe uwafunda wanu wengine, kutowa kurifunda mwanyewe sababuni? Uwe ukwereza kuwa munu aajuzi kwiwa, uwe wiwaja? ");
INSERT INTO wmw_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Ukwamba munu asizinge, sambi, uwe uzingaja? Ukwamba kuwa ayukwajibu milungu ya ulongo, sambi, upitaja ukiiwa mmanyumba a dini? ");
INSERT INTO wmw_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Uwe úridãi kwijiwa shariya, fala aufulata noyo shariya‑yo, kwankunkejeli Mwenyezimungu, sinovyo? ");
INSERT INTO wmw_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Kamana Mandiko akwamba javi: “Zina ra Mwenyezimungu riwankukejeliwa na wanu Sawari-Mayahudi kwa sababu zenu umwe.” ");
INSERT INTO wmw_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Kusema kweli, itani yanawo faida ukitimiza shariya. Fala ikiwa kuwa nvunji wa shariya, ukuwa kamba sawingire itani. ");
INSERT INTO wmw_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Ikiwa wanu sawengire itani ndi wafuláta shariya, awaturiwa nowo kamba wanu wengire itani? ");
INSERT INTO wmw_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Ntamana wanu sawengire itani watimíza shariya, ewo wakulaumu kwa kuwa kwanawo shariya yakwandikiwa yawenye na kwingira itani, fala aufulata shariya. ");
INSERT INTO wmw_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Kamana iye siyo Yahudi wa vitendo vya panja tu basi. Itani sikinu, ila kitendo ca panja ca mmwiri tu basi. ");
INSERT INTO wmw_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Fala iye Yahudi nkati ya roho yake, na itani ndi yengiziwe mmoyo julu ya Roho wa Mwenyezimungu, siyo julu ya shariya yakwandikiwa. Iye swifa zake sizo za wanadamu ila za Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Epa, faida yakuwa Yahudi ndi yepi? Au nkati ya itani, cipatikana kinani? ");
INSERT INTO wmw_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Aye, ziwapo faida nyingi. Faida ya kwanza ndi kuwa Mayahudi wagabiziwa usemi wa Mwenyezimungu mwanyewe. ");
INSERT INTO wmw_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Iwaja? Mayahudi wamojawapo wakitowa kwamini, kutowa kauli kwawo, Mwenyezimungu afuja kauli yake? ");
INSERT INTO wmw_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Isiwe javyo, ila ingawa kila mwanadamu nlongo, fala Mwenyezimungu ndi mwenyé ukweli. Kamana mMandiko vyandikiwa javi: “Wakikishiwe nkati ya usemi wako, ushinde pauja kulamuriwa.” ");
INSERT INTO wmw_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Fala ikiwa kutowa kukamilika kwetu kukolota ukamilifu wa Mwenyezimungu, tambani tena? Tikwamba Mwenyezimungu sikamilifu paatihukumu na nyongo yake? (Nisowera kamba vyawasowera wanadamu.) ");
INSERT INTO wmw_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Kusema kweli, sivyo! Ikiwa javyo, Mwenyezimungu ulumwengu‑wu alamulaja? ");
INSERT INTO wmw_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Fala ikiwa ulongo wangu ukolota pakulu ukweli wake ipate iye atukuziwe pakulu, nihukumiriwani kamba mmadambi? ");
INSERT INTO wmw_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Mbana atamba (kamba wanu wengine vyawabuni kuwa tikwamba): “Titende vitendo vibaya ipate vije vitendo vyema, sinovyo?” Kuhukumiwa kwawo ka haki. ");
INSERT INTO wmw_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Kinani tena? Itakuwa ofwe Mayahudi tiwa bora pakulu koliko wengine? Anta! Tibainisha futi kuwa wanu piya, Mayahudi pamoja na Sawari-Mayahudi, wamilikiwa na dambi. ");
INSERT INTO wmw_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Mandiko Matakatifu akwamba: “Aapo munu kamilifu, anta mmoja. ");
INSERT INTO wmw_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Aapo anta munu mmoja wakwereriwa sana. Aapo munu antaja Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Piya wanu wanloza minyongo, waridanganya awafãi kinu. Aapo atenda meema, aapo anta mmoja. ");
INSERT INTO wmw_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Paulo pawo pawa kamba kaburi ra kuwa wanzu. Kwa malulimi awo walongopa. Mivumbu yawo ílawa sumu ya nyoka wakofya. ");
INSERT INTO wmw_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Viwejala pakanywa pawo lana na usowezi wa kuwawa. ");
INSERT INTO wmw_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Maulu awo akwenenda upesi kusuja damu. ");
INSERT INTO wmw_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Menenzi awo auwaribifu na ausikini. ");
INSERT INTO wmw_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Awejiwa njira ya usalama. ");
INSERT INTO wmw_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Mmaso mwawo awamopa Mwenyezimungu anta aba.” ");
INSERT INTO wmw_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Sambi, tukwijiwa kuwa piya vyaisema shariya wakwambiriwa ware wenendera shariya ipate kanywa zawo zinyamare, na piya wanu mulumwengu‑mu wajuzi kunjibu Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Kamana kwa vitendo vya shariya aapo munu anta mmoja aja kwakikishiwa mbere ya Mwenyezimungu. Kamana shariya ndi intenza munu kwijiwa kuwa kanawo madambi. ");
INSERT INTO wmw_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Fala sambi, ukamilifu wa Mwenyezimungu ubainisha namuna nyengine sairi ya kufulata shariya (ingawa shariya pamoja na mandiko a minabii vilavya ushahidi kuhusu ukamilifu‑wo). ");
INSERT INTO wmw_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Ukamilifu wa Mwenyezimungu uwa julu ya kauli ya Insa Almasihi, kwa piya wenye kumwamini. Kati ya wanu akupo kusiyana, ");
INSERT INTO wmw_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","konta wanu piya wakola dambi na uwapunguka utukufu wa Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Wanu piya wakikishiwa kwa rehema yake bila maripo, julu ya komboriwa na Insa Almasihi. ");
INSERT INTO wmw_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Mwenyezimungu wantondore kuwa awe kafara yakupatanisa julu ya damu yake ka ware wenye kuntumaini, iwa ipate olote ukamilifu wake. Mida, kwa sababu ya imani yake, iye akitowa kuhukumu madambi a munu akorire. ");
INSERT INTO wmw_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Epa sambi, Mwenyezimungu kantondola Insa kuwa kafara yakupatanisa ipate wakati‑wu olote ukamilifu wake, kuwa iye ndi mwenyé shariya na wakumwakikisha ire antumaini Insa. ");
INSERT INTO wmw_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Kwa javyo, tiridãi sababuni? Kuridãi akupo. Kwa shariyani? Kwa shariya ya vitendo? Anta, kwa sababu ya kwamini. ");
INSERT INTO wmw_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Konta tijiwa kuwa munu ápatana na Mwenyezimungu julu ya kumwamini Insa, siyo julu ya kutimiza shariya. ");
INSERT INTO wmw_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Mwenyezimungu Nlungu wa Mayahudi tu basi? Níkamba Nlungu wa wanu Sawari-Mayahudi novyo? Ndi kweli, wawo na Sawari-Mayahudi newo novyo! ");
INSERT INTO wmw_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Kamana Nlungu ndi mmoja, na iye antenza munu kupatana naye julu ya kumwamini, awe Yahudi au Saari-Yahudi. ");
INSERT INTO wmw_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Kwa javyo tifuja shariya kwa sababu ya kwamini? Kusema kweli, anta! Ila na shariya, neyo tukwakikisha. ");
INSERT INTO wmw_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Kwa javyo, kuhusu Iburahima, wawa wa mataifa etu kibinadamu, iye kapata kinani? ");
INSERT INTO wmw_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Kamana ikiwa kakikishiwa julu ya vitendo vyake, kanawo haki ya kuridãi, ila aawa nawo haki‑yo mbere ya Mwenyezimungu! ");
INSERT INTO wmw_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Kamana Mandiko akwamba javi: “Iburahima kamwamini Mwenyezimungu, ntamana Mwenyezimungu kamwisabu kuwa kamilifu.” ");
INSERT INTO wmw_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Sambi, nshahara waapokera nkolakazi siyo zawadi ila deni. ");
INSERT INTO wmw_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Na munu saatumaini kazi yaatenda ila antumaini ire amwakikisha mbaya, kwamini kwake ndi kuntenza iye awe kamilifu. ");
INSERT INTO wmw_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Kwa namuna moja noyo, Daudi kuhusu heri ya munu wakuwa Mwenyezimungu ankubali kuwa kamilifu bila kwisabu vitendo vyaatendire, kaamba: ");
INSERT INTO wmw_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“Heri wenye kuswamiiwa makosa awo, ware wafutiwe madambi awo! ");
INSERT INTO wmw_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Aye, heri munu wakuwa Mwenye aaisabu dambi zake!” ");
INSERT INTO wmw_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Sambi, noyi heri‑yi itakuwa ya wenye kwingira itani tu basi, au na ya wanu sawengire newo novyo? Kamana tikwamba kuwa Iburahima kesabiwa kuwa kamilifu kwa sababu ya kwamini kwake. ");
INSERT INTO wmw_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Kesabiwa rini? Iwa esire kutaiwa itani, au saanamba? Iwa saanamba, ila saanataiwa itani! ");
INSERT INTO wmw_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Kusema kweli, iye kapokerera alama ya itani, iwe kipaji cakuwa mwenyé haki kwa sababu ya kwamini kwake, na evyo vikuna saanataiwa itani. Vikuna javyo, ipate awe wawa wa wanu piya wamwamini Mwenyezimungu sawengire itani, na ware wesabiwe kuwa makamilifu. ");
INSERT INTO wmw_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Na iye ndi wawa wa ware wengire itani, fala siwengire itani tu basi ila newo novyo wari kulondoza kwamini ka babu yetu Iburahima kábula saanataiwa itani. ");
INSERT INTO wmw_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Kamana aiwere kwa kufulata shariya kuwa ndi citenzire Iburahima pamoja na ujukulu wake kupokerera tamaa ya kuwa akúja kuriti ulumwengu‑wu, ila kwa sababu ákiwa mwenyé haki julu ya kwamini kwake. ");
INSERT INTO wmw_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Kwa kuwa, ikiwa wafulati shariya ndi wariti, basi kwamini akufãi na tamaa ifujika. ");
INSERT INTO wmw_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Kamana shariya ikuja na nyongo, fala mahala saipo shariya, kukosa akupo. ");
INSERT INTO wmw_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Ndi ntamana, tamaa ikuja julu ya kwamini ipate iwe julu ya rehema, na kuhusu tamaa‑yo, piya ujukulu wa Iburahima wawe na uhakika. Siware wafulata shariya basi, fala na wari na kwamini ka Iburahima, wawa yetu piya-fwe. ");
INSERT INTO wmw_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Kamba vyavyandikiwe: “Omi nukutula kuwa wawa wa kabila nyingi.” Iburahima kantumaini Mwenyezimungu, ire awápa mainsha wafwi, na mwenyé kumba savikiwepo. ");
INSERT INTO wmw_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Ingawa upande wa kibinadamu aikiwepo tamaa, novyo-sivyo katumaini na tamaa kuwa álawirira kuwa wawa wa kabila nyingi zawenye, kamba vyaisemiwe: “Ujukulu wako ukuja kuwa mwingi.” ");
INSERT INTO wmw_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Iburahima aasokeziwe nkati ya kwamini kwake, ingawa akirinang'aniza mwiri wake wîsa (kwa kuwa hirimu yake íkiwa kiyasi ca myaka miya), na tumbo ra Sara rîfunga. ");
INSERT INTO wmw_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Novyo-sivyo, iye aasire niya ya kutumaini tamaa ya Mwenyezimungu ila karimbisiwa na kwamini kwake kuno akinsifu Mwenyezimungu, ");
INSERT INTO wmw_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","konta ákiwa na hakika piya kuwa Mwenyezimungu tamaa yaalavire, ákiwa nawo uwezo wakutimiza novyo. ");
INSERT INTO wmw_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Ntamana, Iburahima “kesabiwa kuwa kamilifu”. ");
INSERT INTO wmw_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Usemi ukwamba “kesabiwa kuwa kamilifu”, aamwamba iye tu basi, ");
INSERT INTO wmw_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","ila wandikiwa novyo kwa faida yetu ofwe, tija kwisabiwa kuwa wenye ukamilifu kamana tintumaini ire anfufure Insa ka wafwi, Mwenye wetu. ");
INSERT INTO wmw_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Insa‑yu aperekiwe kufwa kwa sababu ya madambi etu, na afufuriwe ipate takikishiwe. ");
INSERT INTO wmw_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Kwa kuwa takikishiwa julu ya kwamini kwetu, tanawo salama na Mwenyezimungu julu ya Mwenye wetu, Insa Almasihi. ");
INSERT INTO wmw_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Julu ya kuntumaini Insa, tanawo uwezo wakupata rehema yatiri nawo‑yi. Kusema kweli, tifurahi kwa kuwa tirindira kuwona utukufu wa Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Visitoshe, tifurahi novyo pazitipata tabu, konta tukwijiwa kuwa tabu zitifunda kuhitamili. ");
INSERT INTO wmw_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Ikisa tena, kuhitamili kutitaya namuna yakusakikana, na namuna yakusakikana ititaya tamaa. ");
INSERT INTO wmw_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Na eyi tamaa‑yi aititenza aibu, konta pendo ra Mwenyezimungu rijala mmyoyo mwetu julu ya Roho Takatifu watipewe ofwe. ");
INSERT INTO wmw_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Kamana ingawa tiveya, paufikire wakati wake, Almasihi kafwa kwa ajili ya makafiri. ");
INSERT INTO wmw_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Kusema kweli, munu kufwa kwa ajili ya mwenyé ukamilifu, virigariga pakulu. Dalili, munu ákidiri kufwa kwa ajili ya ntenda-mema. ");
INSERT INTO wmw_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Fala Mwenyezimungu kolota pendo rake kwetu ofwe, kamana Almasihi kafwa kwa ajili yetu ofwe patíkiwa wamádambi. ");
INSERT INTO wmw_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Ntamana, kwa kuwa takikishiwa na Mwenyezimungu julu ya damu ya Almasihi, kuzidi pakulu iye akuja kutivusha nkati ya nyongo ya Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Kamana, kwa kuwa tipatanisiwa naye julu ya kifo ca Almasihi patikiwa maaduwi wake, vizidi futi patipatanisiwe‑pa, tikuja kuvushiwa julu ya mainsha ake. ");
INSERT INTO wmw_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Visitoshe, tifurahi novyo ka Mwenyezimungu julu ya Insa Almasihi, Mwenye wetu, konta julu yake, tipatanisiwa. ");
INSERT INTO wmw_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Kwa javyo, julu ya munu mmoja ingira dambi mulumwengu‑mu, na kwa javyo cingira kifo novyo. Ikisa kifo ciwapata wanu piya, konta piya wakola dambi. ");
INSERT INTO wmw_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Kusema kweli, sainamba kuwepo shariya, dambi ikiwapo mulumwengu‑mu. Fala, kwa kuwa aiwerepo shariya, dambi‑yo aikiwalangiwa. ");
INSERT INTO wmw_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Novyo-sivyo, kifo cîtawala wanu piya tangu wakati wa Adamu mpaka wakati wa Musa, anta na ware sawakorire dambi kamba vyaatupire kauli Adamu. Adamu nfano wa namuna mmojawapo wa munu akirindiriwa kuja. ");
INSERT INTO wmw_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Fala kitendo ca neema ca Insa aciri kamba ukosa wa Adamu. Kamana kwa kukosa munu mmoja wafwa wanu wengi. Fala kwa rehema ya Mwenyezimungu na ya munu mmoja Insa Almasihi yolotiwe julu ya meema yake, wengezeka wanu wengi wakujanliiwa. ");
INSERT INTO wmw_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Novyo, kuwapo kusiyana kuwonekana nkati ya neema na dambi ya munu mmoja. Konta kulaumiwa kufulata ukosa mmoja ujire na hukumu, fala neema yesusiriwe munu ifuláta makosa mengi ajire na uhakika. ");
INSERT INTO wmw_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Kamana, ikiwa kukosa ka munu mmoja, kifo citawala kwa sababu ya noyo munu‑yo, kuzidi pakulu ware wapokerere rehema pakulu-pakulu na neema ya uhakika, ewo wakuja kutawala nkati ya mainsha julu ya munu mmoja, noyo Insa Almasihi‑yo. ");
INSERT INTO wmw_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Sambi, kamba ukosa wa munu mmoja vyaujire na hukumu ka wanu piya, ndi sawa‑sawa novyo kitendo kimoja ca kukamilika cikuja na uhakika pamoja na mainsha ka wanu piya. ");
INSERT INTO wmw_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Kamana, kamba ubishi wa munu mmoja vyawaturiwe wengi kuwa wenye ukosa, ndi sawa‑sawa novyo kwa kusikiriza ka munu mmoja, wengi wakuja kuturiwa kuwa wenye ukamilifu. ");
INSERT INTO wmw_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Shariya ija ipate yolote sana-sana ukosa wa kutupa shariya. Fala paizidire dambi, izidi kwijala rehema, ");
INSERT INTO wmw_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","ipate, kamba vyaitaware dambi nkati ya kifo, na rehema novyo itaware, itipe ukamilifu mbere ya Mwenyezimungu, tipate mainsha a milele julu ya Insa Almasihi, Mwenye wetu. ");
INSERT INTO wmw_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Sambi, tambe mwaja? Tibaki tikiinshi nkati ya dambi, ipate rehema yongezeke? ");
INSERT INTO wmw_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Anta! Ofwe tifwire dambi, tizidija kuinshi na dambi tena? ");
INSERT INTO wmw_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Au mutikina kuwa piya-fwe toziwa tilungane na Insa Almasihi, toziwa tilungane novyo na kifo cake? ");
INSERT INTO wmw_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Kamana tizikiwa pamoja naye julu ya kutoza nkifo cake ipate, kamba vyafufuriwe Almasihi nkifo julu ya utukufu wa Baba, na ofwe novyo tiinshi kwa namuna nyipya. ");
INSERT INTO wmw_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Konta ikiwa tilungana naye nkati ya kifo cake, ndi sawa‑sawa novyo nkati ya kufufuriwa kwake, nofwe tifufuriwa. ");
INSERT INTO wmw_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Tijiwe javi, kuwa umunu wetu watíkiwa mida ugomezeriwa pansalaba pamoja neye ipate ufujike mwiri wetu wa dambi, tisiwe tena watwana wa dambi. ");
INSERT INTO wmw_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Kamana mmojawapo afwire onse namuna‑yo, komboriwa nkati ya uwezo wa dambi. ");
INSERT INTO wmw_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Na ikiwa tifwa na Almasihi, tukwamini kuwa novyo tiinshi naye. ");
INSERT INTO wmw_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Tukwijiwa kuwa Almasihi kafufuriwa nkifo, ntamana aafwa tena, kifo acinkidiri tena. ");
INSERT INTO wmw_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Paafwire, kafwa kwa sababu ya dambi, ntamana uwezo wa dambi ushindiwa kwa milele. Na sambi, nkati ya uhai wake, kankuinshi vyavimwajibu Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Kwa javyo, nnomwe novyo ritureni wanyewe kamba mufwire, uwezo wa dambi ushindiwe, fala kwa kuwa mulungana na Almasihi Insa, mwankuinshi vyavimwajibu Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Kwa javyo, musase dambi kutawala mwiri wenu kusikiriza wájibu wenu wa vitendo vibaya. ");
INSERT INTO wmw_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Musipereke vifingo vya mwiri wenu kudambi, kutenda vinu savina shariya. Ila, riperekeni umwe ka Mwenyezimungu kamba wanu wakulawa nkifo ipate muinshi ka ukweli. Riperekeni vifingo vya mwiri wenu kuwa combo ca kutenda shariya ka Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Kamana dambi aikukidirini, konta amutawariwa na shariya, muinshi julu ya rehema ya Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Mana ake kinani? Tikore dambi kwa kuwa atiri sini yakumilikiwa na shariya ila timilikiwa na rehema? Anta! ");
INSERT INTO wmw_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Amwijiwa kuwa mukiripereka ka munu kuntumika na mukinsikiriza kamba watwana, muwa watwana wamuntumika mukinsikiriza noyo? Anta iwe musikiriza dambi mwinsho íja na kifo, anta iwe munsikiriza Mwenyezimungu, mwinsho ája na uhakika. ");
INSERT INTO wmw_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Fala shukuruni ka Mwenyezimungu! Ingawa mida múkiwa watwana wa dambi, fala sambi musikiriza kwa myoyo yenu ngano zamugabiziwe. ");
INSERT INTO wmw_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Basi, momboriwa mmakono mwa dambi, mulawirira kuwa watwana wa njira ya uhakika. ");
INSERT INTO wmw_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Omi nisowera kwa kutumira nfano wa kibinadamu konta ankili zenu aba. Umwe mida mupereka vifingo vyenu kuwa watwana wa ucafu na udainfu pakulu. Epa sambi, riperekeni vifingo vyenu viwe watwana wa njira ya haki ipate muwe watakatifu. ");
INSERT INTO wmw_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Pamúkiwa watwana wa dambi, múkiwa na uhuru amukifulata njira ya haki. ");
INSERT INTO wmw_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Faidani yamupatire nowo wakati‑wo? Mukitenda vitendo vyamuriwonera haya kutenda sambi‑pa, na mwinsho yawo novyo vitendo-vyo ndi kifo! ");
INSERT INTO wmw_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Fala sambi, kwa kuwa momboriwa nkati ya uwezo wa dambi, mulawirira kuwa watwana wa Mwenyezimungu, mupata faida yenu ya kuwa watakatifu, na mwinsho ndi mainsha a milele. ");
INSERT INTO wmw_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Konta nshahara wa dambi ndi kifo, fala kitendo ca neema ya Mwenyezimungu ndi mainsha a milele julu ya Almasihi Insa, Mwenye wetu. ");
INSERT INTO wmw_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Niwasowerera wejiwa shariya. Mutikina wanduzangu, kuwa shariya yanawo uwezo julu ya munu ari hai tu basi? ");
INSERT INTO wmw_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Kwa nfano, mwanamuka wakulombiwa, alungana naye nlumake nkati ya shariya. Fala ikiwa nlume‑yo kafwa, mwanamuka akuwa na uhuru wa noyi shariya ya ndowa‑yi. ");
INSERT INTO wmw_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Ndi ntamana, akilombiwa na nlume mwengine nlumake ari hai, iye akwitiwa nzinzi. Fala nlumake akifwa, iye akuwa na uhuru nkati ya shariya, na akilombiwa na nlume mwengine, aawa nzinzi. ");
INSERT INTO wmw_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Basi, wanduzangu, paufwire mwiri wa Almasihi, nomwe novyo mufwira shariya, ipate muwe wa mwengine, ire afufuriwe nkifo, muntendere Mwenyezimungu vitendo vyema. ");
INSERT INTO wmw_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Kamana patikiwa na hali ya kibinadamu, shariya íkisalamula wájibu mbaya mmwiri mwetu ipate tikore dambi, na mwinsho yawo ndi kifo. ");
INSERT INTO wmw_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Fala sambi tomboriwa nkati ya shariya konta tifwira cire citifungire, ipate titumike sairi kwa namuna ya mida ya shariya yandikiwe, ila kwa namuna nyipya ya Roho. ");
INSERT INTO wmw_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Sambi, tikwamba kinani? Shariya ndi dambi? Anta, sivyo-javyo! Kusema kweli, singari kwijiwa dambi sairi julu ya shariya. Singari kwijiwa kuperereza saisemire shariya kuwa: “Usiperereze”. ");
INSERT INTO wmw_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Fala dambi ítwala nafasi julu ya ámuri‑yo inisalamurira kila namuna yakuperereza. Kamana, inatowa kuwepo shariya, dambi aingari kuwa na uwezo. ");
INSERT INTO wmw_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Wakati‑wo omi nikiinshingi bila shariya, fala panijiwe ámuri, dambi yanza kuwepo julu yangu omi, nomi nikifwa. ");
INSERT INTO wmw_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Basi ámuri íkijuzi kuja nawo mainsha kwangu, falakini inijisira kifo. ");
INSERT INTO wmw_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Kamana dambi itumira nafasi julu ya ámuri‑yo initesa, basi ámuri‑yo inulaya. ");
INSERT INTO wmw_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Kwa javyo, shariya kinu takatifu, na ámuri kinu takatifu, kamilifu, na cema. ");
INSERT INTO wmw_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Basi, kinu cema cinisalamurira kifo? Kusema kweli, sivyo! Ila dambi itumira kinu cema kunisalamurira kifo, ipate dambi iwoneke sana-sana kuwa dambi, na julu ya ámuri izidi kuwa mbaya pakulu. ");
INSERT INTO wmw_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Tikwijiwa kuwa shariya ndi ya Roho, fala omi niwa kibinadamu, epa niuzanyiwa niwa ntwana wa kutumikira dambi. ");
INSERT INTO wmw_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Kamana vyanitenda sereriwa: vitendo vyanisaka kutenda, sitenda, na vitendo vyakunikima, novyo ndi vyanitenda. ");
INSERT INTO wmw_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Canitowa kusaka kutenda, nítenda, ntamana omi nikwitikizira kuwa shariya ngema. ");
INSERT INTO wmw_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Fala sambi, sumi mwanyewe niri kutenda ila dambi iri nkati yangu. ");
INSERT INTO wmw_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Nukwijiwa kuwa hapana kinu cema cisaka kuwa conse kati ya hali ya kibinadamu. Kweli, nanawo wájibu wakutenda cema, fala wájibu‑wo sitenda. ");
INSERT INTO wmw_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Konta meema anisaka kutenda sitenda, fala ubaya sanisaka kutenda, nankuzidi kutenda. ");
INSERT INTO wmw_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Basi, omi nikitenda kinu sanisakula kutenda, mana ake ndi kuwa sumi nitenda, ila dambi iri nkati yangu ndi itenda. ");
INSERT INTO wmw_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Kwa javyo, nankuwona kuwa ndi kamba shariya: panisakula kutenda meema, kitendo kibaya ciwa mbere yangu. ");
INSERT INTO wmw_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Kamana inajibu shariya ya Mwenyezimungu nkati ya mmoyo mwangu, ");
INSERT INTO wmw_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","fala nankuwona uwezo wa shariya nyengine iri nvifingo vyangu. Ewo uwezo‑wo ubishana na shariya ya ankili zangu, initenza kuwa nfungwa wa uwezo wa dambi iri nvifingo vyangu. ");
INSERT INTO wmw_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Mama! Omi ndi mununi wakuwa na uzuni‑mi! Nani anivusha nkati ya ewu mwiri unipereka kukifo‑wu? ");
INSERT INTO wmw_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","He! Ninshukuru Mwenyezimungu kwa sababu ya Insa Almasihi, Mwenye wetu. Basi nomimi, upande mmoja kwa ankili zangu, nitumika uwezo wa shariya ya Mwenyezimungu. Kwa upande mwengine, kwa mwiri wangu, nitumika uwezo wa dambi. ");
INSERT INTO wmw_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Kwa javyo, hapana hukumu ka wanu walungane na Almasihi Insa. ");
INSERT INTO wmw_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Kamana uwezo wa shariya ya Roho wa mainsha nkati ya Almasihi Insa ukombola nkati ya uwezo wa dambi na wa kifo. ");
INSERT INTO wmw_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Kinu cakurigariga pakulu upande wa shariya kwa sababu ya kuveya ka hali ya kibinadamu, kinu‑co Mwenyezimungu katenda pampereke Mwanawe mwanyewe, na mwiri wakulandana na wa binadamu wa madambi. Na kuhusu dambi, Mwenyezimungu kahukumu dambi ya binadamu, ");
INSERT INTO wmw_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","ipate shuruti kamili ya shariya itimiziwe kwetu ofwe, ofwe atifulata wájibu mbaya watipongoreriwe fala tinfulata Roho wa Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Kamana ware waínshi na wájibu wa kibinadamu washugulikira vitendo vya kibinadamu, fala waínshi na Roho washugulikira vinu vyakumwajibu Roho wa Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Namuna zakuwaza za kibinadamu kifo, ila kunshugulikira Roho Takatifu ndi mainsha na usalama. ");
INSERT INTO wmw_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Kamana namuna zakuwaza za kibinadamu zibishana na Mwenyezimungu, konta azifulata shariya za Mwenyezimungu, kusema kweli azikidiri kufulata. ");
INSERT INTO wmw_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Wanu wari nkati ya hali ya kibinadamu awakidiri kutenda vyakumwajibu Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Falakini umwe amuri nkati ya hali ya kibinadamu ila mwankulongoziwa na Roho wa Mwenyezimungu, ikiwa kweli-kwelini Roho wa Mwenyezimungu muwa naye mmyoyo mwenu. Mmojawapo ikiwa aana Roho wa Almasihi mmoyo mwake, siyo wake iye. ");
INSERT INTO wmw_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Ila ikiwa Almasihi kawa mmyoyo mwenu, ingawa mwiri wenu ufwa kwa sababu ya dambi, fala Roho wa Mwenyezimungu akupani mainsha kwa kuwa mwakikishiwa. ");
INSERT INTO wmw_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Ikiwa Roho wa Mwenyezimungu anfufure Insa ka wafwi kawa mmyoyo mwenu, noyo akuja kukupani mainsha mwiri wenu wakufwa, julu ya Roho yake iripo mmyoyo mwenu. ");
INSERT INTO wmw_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Basi, wanduzangu, ofwe tidãiwa, fala sikibinadamu, tisiinshi kibinadamu. ");
INSERT INTO wmw_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Kamana ikiwa muinshi kibinadamu, mwinsho wenu mukufwa. Fala ikiwa mukulaya vitendo vya kimwiri, julu ya uwezo wa Roho Takatifu, mukuja kuinshi. ");
INSERT INTO wmw_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Kamana piya walongóziwa na Roho wa Mwenyezimungu, ewo wana wa Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Kamana amupokerere roho yakukutenzani kuwa watwana muludire kutetema kamba mida, ila mumpokerera Roho Takatifu akutendani kuwa wana wa Mwenyezimungu, ntamana titamuka kwita “Abba, Baba”. ");
INSERT INTO wmw_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Kusema kweli, Roho Takatifu mwanyewe alavya ushahidi pamoja na roho zetu kuwa tiwa wana wa Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Na kwa kuwa tiwa wanawe, tanawo novyo haki ya kuriti: upande mmoja, tanawo haki kuriti ka Mwenyezimungu. Upande mwengine, tanawo haki ya kuriti pamoja na Almasihi, kamana tikitabika naye, tukuja kutukuziwa novyo pamoja naye. ");
INSERT INTO wmw_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Basi sambi, niwalanga kuwa tabu zetu za ewu wakati‑wu azijuzi kuringanisiwa na utukufu usaka kuja watija koloteriwa ofwe. ");
INSERT INTO wmw_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Kamana viyumbe piya wankurindira na hamu pakulu wakati wawaja kufafanuririwa wana wa Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Konta viyumbe piya vituriwe vyaufwabure, avitenda kinu kwa nafsi yawo ila kwa kusaka ka ire aturire. Iye katenda javyo kwa tamaa ");
INSERT INTO wmw_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","yakuwa viyumbe vikuja komboriwa, visiwe tena vitwana vyakuvunda, viwe na uhuru nkati ya utukufu wa wana wa Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Kamana tikwijiwa kuwa viyumbe piya viwankurama na viwankutabika na malwazo a kupongola mpaka sambi‑pa. ");
INSERT INTO wmw_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Na sivyo viyumbe basi. Ofwe wanyewe vyatiwa nawo Roho Takatifu kamba visumo vyakwanza, nofwe novyo wanyewe tankurama patiwarindira na hamu pakulu tilawirire kuwa wanawe, mwiri wetu womboriwe nfululu. ");
INSERT INTO wmw_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Kamana tivushiwa nkati ya kutumaini tamaa‑yo. Ona, kinu cakuwoneka sico ca tamaa. Kinu ciri kuwoneka, munu awaja na tamaa? ");
INSERT INTO wmw_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Falakini kinu satiwona, eco ndi catiwa na tamaa, tirindira ka kuvumirira. ");
INSERT INTO wmw_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Sawa‑sawa novyo, patisokera Roho Takatifu atisaidiya. Kamana atinéjiwa vyatijuzi kutenda duwa, fala Roho Takatifu mwanyewe átilebelela ka Mwenyezimungu kwa namuna saikidirika kwereza. ");
INSERT INTO wmw_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Na ire atúnza ciri nkati ya roho piya akwijiwa caawaza Roho Takatifu, konta iye áwalebelela watakatifu kamba vyaasaka Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Ofwe tukwijiwa kuwa, ka wenye kumpenda Mwenyezimungu, piya vinu‑vi vikwenendera kuwema ka ware wetiwe watimize mpango wake. ");
INSERT INTO wmw_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Konta wawéjiwe tangu mwanzo iye kâwatondola wanlande Mwanawe ipate Mwanawe awe ntanzi kati ya wanduze wengi wawenye. ");
INSERT INTO wmw_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Ware watondoriwe tangu mwanzo, Mwenyezimungu kaweta. Ware wawetire, iye kawakikisha, na ware wawakíkishe, iye kawawanyira utukufu wake. ");
INSERT INTO wmw_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Kwa javyo, tambani kuhusu vinu‑vi? Ikiwa Mwenyezimungu kawa upande wetu, akidiri kutilumbata nani? ");
INSERT INTO wmw_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Mwenyezimungu aatituwire Mwanawe wawenye, ila kanlavya kuwa kafara kwa faida yetu ofwe piya. Kwa javyo, namunani vyaatowa kutipa neye novyo piya vinu? ");
INSERT INTO wmw_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Ware watondoriwe na Mwenyezimungu, ari na haki yakuwawonerera makosa nani? Mwenyezimungu ndi mwenyé kumwakikisha munu. ");
INSERT INTO wmw_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Mwenyé kuhukumu nani? Almasihi Insa ndi afwire, visitoshe kafufuriwa ka wafwi, na iye kekala upande wa nkono nriro wa Mwenyezimungu, novyo iye ndi atilebelela. ");
INSERT INTO wmw_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Atitanusa nani nkati ya pendo ra Almasihi? Kutabika, tafauti, kulumbatiwa, njala, diki, hatari au upanga? ");
INSERT INTO wmw_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Anta! Kamba vyaandikiwe: “Kwa sababu zako uwe, tikulaiwa suku‑zi piya, titafitiwa kamba makondoo vyawokisiwa kusinjiwa.” ");
INSERT INTO wmw_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Fala nkati ya piya‑vi, ofwe tiwazaidi washindi wakulu, julu ya ire atipendire ofwe. ");
INSERT INTO wmw_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Kamana omi nanawo hakika kuwa wala kifo wala uhai, wala malaika wala wenye mamulaka, wala mashuguli yetu a rero wala a makeso, wala wenye uwezo, ");
INSERT INTO wmw_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","wala viripo julu au sini, wala kiyumbe cengine kimojawapo, acikidiri kutitanusa nkati ya pendo ra Mwenyezimungu, rolote julu ya Mwenye wetu, Insa Almasihi. ");
INSERT INTO wmw_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Kwa kuwa nilungana na Almasihi, nisowera kweli, silongopa. Fahamu yangu julu ya Roho Takatifu ilavya ushahidi pamoja nomi. ");
INSERT INTO wmw_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","Nisowera kweli panisowera kuwa mmoyo mwangu unijala uzuni nkulu na kulwaziwa sakuna mwinsho. ");
INSERT INTO wmw_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Kamana vinilwaza mpaka vikinajibu nilaniwe ndaraja ra Almasihi kwa ajili ya wanduzangu, ware wa kabila yetu moja, ");
INSERT INTO wmw_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","niwamba waIziraeli. Ewo waturiwa kuwa wana wa Mwenyezimungu, wawona utukufu wake, wapokerera miyadi yakupatana, wagabiziwa Taureti, wapewa nafasi ya kumwabudu, na wapokerera tamaa zake. ");
INSERT INTO wmw_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Nkati yawo wákiwa wababu zawo, na mmoja wawo nkabila yawo ndi Almasihi, Nlungu ari julu ya mambo piya. Iye Almasihi asifiwe milele! Aamina. ");
INSERT INTO wmw_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Sambi, sikuwa usemi wa Mwenyezimungu ukosa. Kamana sikuwa piya ware wa Iziraeli kibinadamu, waIziraeli wakweli, ");
INSERT INTO wmw_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","wala sikuwa piya wa rikolo ra Iburahima ujukulu wake. Konta Mandiko akwamba: “Wajukuluwo zina rawo ndi riwalangiwa julu ya Izaki.” ");
INSERT INTO wmw_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Kinu‑ci mana ake ndi kuwa wana wapongoriwe kibinadamu siwo wana wa Mwenyezimungu ila wana wapongoriwe kamba vyaalavire tamaa ndi wawalangiwa kuwa ujukulu. ");
INSERT INTO wmw_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Konta tamaa isema javi: “Kwa muda wa mwaka mmoja nukuja, na Sara ampongola mwana mmoja nlume.” ");
INSERT INTO wmw_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Visitoshe, Rebeka cinkuna kinu kimoja paawemite wanawe na nlume mmoja, Izaki baba wetu. ");
INSERT INTO wmw_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","Anta wanawe sawanapongoriwa, wala sawanatenda cema wala kibaya, Mwenyezimungu kantondola mwana mmoja ipate vyaalangele Mwenyezimungu kuhusu kutondola kwake kwendeleye, siyo kwa vitendo fala awepo wakwita, ");
INSERT INTO wmw_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","iye kambiriwa javi: “Mwana ntanzi akuja kuntumika wa mwinsho.” ");
INSERT INTO wmw_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Kamba vyavyandikiwe mMandiko: “Yankubu nimpenda, Ezau nimwina.” ");
INSERT INTO wmw_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Sambi tambe mwaja? Mwenyezimungu aana shariya? Anta siyo javyo! ");
INSERT INTO wmw_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Kamana kamwambira Musa javi: “Nintendera huruma waninsaka onse, nimmonera utungu anajibu onse.” ");
INSERT INTO wmw_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Kwa javyo, avikuna kamba vyatisaka au vyatitenda ila vikuna kwa uwezo wa mwenyé kutendera huruma, Mwenyezimungu tu basi. ");
INSERT INTO wmw_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Javi ndi vyaasowere Mwenyezimungu mMandiko Matakatifu, akimwambira nfalume wa Miswiri: “Ndi noco canukuturire kuwa nfalume ipate julu ya uwe nolote uwezo wangu, na zina rangu rijiwikane ulumwengu nzima‑wu piya.” ");
INSERT INTO wmw_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Kwa javyo, iye antendera huruma waansaka, na antula kuwa ngumu waansaka. ");
INSERT INTO wmw_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Umwe nanga munidairi javi: “Sababuni iye kuwapa wanu ukosa? Kamana akidíri kubishana na vyaasaka iye nani?” ");
INSERT INTO wmw_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Fala uwe binadamu, kuwa nani wakunsutumu Mwenyezimungu? Kiyungu cakufiyangiwa cindairi afiyange kwamba: “Sababuni kunifiyanga javi?” ");
INSERT INTO wmw_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Munu wakufiyanga, akitwala utope akifiyanga nringi wapambari, na utope mmoja nowo akifiyanga nringi mwengine wakutumiriwa pakaya, aana mamulaka a kutenda javyo? ");
INSERT INTO wmw_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Sikuwa Mwenyezimungu ásaka kolota kukimiwa kwake na kwijiwisa uwezo wake? Ntamana iye ketamili na imani pakulu miringi yejaze nyongo yake, yaatengeze kwaribiwa, ");
INSERT INTO wmw_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","ipate ejiwise novyo utajiri wa utukufu wake ka miringi yejaze huruma zake, yaatengeze mida kupokerera utukufu wake. ");
INSERT INTO wmw_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Miringi‑yo ndufwe titondoriwe na Mwenyezimungu. Atitondoriwe nkati ya Mayahudi tu basi, fala nkati ya Sawari-Mayahudi newo novyo. ");
INSERT INTO wmw_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Kamba Mwenyezimungu vyaambire julu ya nabii Ozeya, akamba javi: “Niweta wanu sawari wangu, wawe wanu wangu; niweta sawari wapendani wangu, wawe wapendani wangu.” ");
INSERT INTO wmw_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Novyo: “Na vikuja kukuna mahala pawâmbiriwe javi: ‘Umwe amuri umati wangu’, mahala‑po ewo wakuja kwitiwa ‘wana wa Mwenyezimungu hai.’ ” ");
INSERT INTO wmw_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Izaya nneye kankukuwa kuhusu Iziraeli, akwamba: “Ingawa ujukulu wa Iziraeli mwingi kamba misanga ya mwani, fala aba javi ndi waja kuvushiwa.” ");
INSERT INTO wmw_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Konta kulamula kwake muardhi, Mola aakawisa na atimiza nfululu. ");
INSERT INTO wmw_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Kamba tangu mida vyaâsemire Izaya, akamba: “Inawa Mola, Mwenyé Uwezo, aâtasire ujukulu anta aba, nanga tiwa kamba Sodoma, nanga tilanda Gomora.” ");
INSERT INTO wmw_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Sambi, kuhusu novi vinu‑vi, tikwamba kinani? Tikwamba kuwa Sawari-Mayahudi awakisakula ukamilifu, wakipata, fala vikuna julu ya kuntumaini Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Upande mwengine, Mayahudi wakisakula ukamilifu julu ya kufulata shariya, fala awapatire. ");
INSERT INTO wmw_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Konta ya kinani? Konta namuna zawo azíkiwa julu ya kwamini ila zíkiwa julu ya vitendo vyawo. Wakwakula riwe rakukwakuriwa, ");
INSERT INTO wmw_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","kamba vyayandikiwe: “Ona, nankutula Ziyoni riwe rawaja kukwakula, riwe risaka kuwagwisa. Mwenyé kuntumaini iye, aaja kuriwonera haya.” ");
INSERT INTO wmw_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Wanduzangu, vinajibu pakulu mmoyo mwangu na niwanlebelela ka Mwenyezimungu Mayahudi wavushiwe. ");
INSERT INTO wmw_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Omi niwa shahidi kuhusu ewo kuwa wanawo hamu pakulu na Mwenyezimungu, fala noyo hamu‑yo airi nkati ya kumwijiwa. ");
INSERT INTO wmw_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Kamana awejiwa ukamilifu ulawa ka Mwenyezimungu, ila wasakula kubainisha ukamilifu wawo wanyewe. Kwa javyo, awasaka kupokerera ukamilifu wakulawa ka Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Kamana Almasihi ndi kusudi ya shariya, impa ukamilifu kila mwenyé kumwamini. ");
INSERT INTO wmw_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Musa kandika kuhusu ukamilifu ulawa julu ya kufulata shariya. Kaamba javi: “Mwenyé kufulata ámuri za shariya, áinshi julu yake.” ");
INSERT INTO wmw_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Fala ukamilifu julu ya kumwamini Mwenyezimungu ukwamba: “Usambe mmoyo mwako: ‘Asáka kukwera mbinguni nani?’ ” Kwamba javyo, Almasihi umwisusa. ");
INSERT INTO wmw_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","“Wala: ‘Asáka kwisukira mahala ka wafwi nani?’ ” Konta eco Almasihi kunlamusa ka wafwi. ");
INSERT INTO wmw_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Musa kankwamba kinani? Iye akwamba javi: “Usemi uwa karibu yako, nkanywa mwako na mmoyo mwako.” (Mana ake ndi usemi watitangaza, kuwa tijuzi timwamini Mwenyezimungu.) ");
INSERT INTO wmw_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Kamana ukisowera na kanywa yako kuwa Insa ndi Mwenye, na ukamini mmoyo mwako kuwa Mwenyezimungu kanfufula nkifo, ukuja kuvushiwa. ");
INSERT INTO wmw_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Kamana mmoyo munu akamini, apata kwakikishiwa. Julu ya kusema na kanywa yake, apata kuvushiwa. ");
INSERT INTO wmw_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Konta Mandiko akwamba javi: “Munu asáka kuwa onse akimwamini Mwenyezimungu, aimpata aibu.” ");
INSERT INTO wmw_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Akupo kusiyana nkati ya Mayahudi na Sawari-Mayahudi. Mwenye mmoja ndi Mwenye wa wanu piya, na iye ndi mwenyé utajiri ka piya wenye kunlebela. ");
INSERT INTO wmw_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Kamana “Munu asaka kuwa onse anlébela Mwenye akuja kuvushiwa.” ");
INSERT INTO wmw_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Fala wanu wanlebelaja sawanamba kumwamini? Na wamwaminija sawanasikira akitamburiwa? Na wasikiraja sawerepo munu wakuwereza Habari Ngema? ");
INSERT INTO wmw_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Na wanu wokaja kwereza sawaperekiwe? Kamba vyandikiwe Mandiko Matakatifu: “Namuna vyasitawire maulu a ware wapita wakereza Habari Ngema.” ");
INSERT INTO wmw_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Fala siyo kuwa Mayahudi piya wafulata Habari Ngema. Kamana Izaya kasema javi: “Mola, amíni habari zetu nani?” ");
INSERT INTO wmw_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Basi, kwamini kukuja na kusikira Habari Ngema, na kusikira Habari‑yo ikuja nkati ya kwereza kuhusu Almasihi. ");
INSERT INTO wmw_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Fala nukwamba, Mayahudi piya awasikire? Kusema kweli, wasikira. Mandiko awenye akwamba: “Shauti zawo zenera ardhi piya, usemi wawo ufika mpaka mwinsho wa ulumwengu.” ");
INSERT INTO wmw_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Nukwamba, itakuwa wanu wa Iziraeli awereriwe? Aye, wereriwa. Cakwanza, julu ya Musa, Mwenyezimungu kaamba javi: “Omi nukushongani muwatendere wiyana wanu sawari wa taifa. Julu ya taifa watikinifu, nukukimwisani.” ");
INSERT INTO wmw_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Julu ya Izaya, Mwenyezimungu karikomarisa, kaamba javi: “Nisinganiriwa na wanu sawakinisakula, nirolota ka wanu sawakinidairi.” ");
INSERT INTO wmw_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Fala ka Iziraeli, Mwenyezimungu kaamba javi: “Suku daima‑zi nikolosa makono angu kwawo ewo, fala ewo awanisikiriza, wanikaidi.” ");
INSERT INTO wmw_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Sambi, omi nídairi: Mwenyezimungu wanu wake kawakatala? Anta! Omi mwanyewe niwa muIziraeli, ujukulu wa Iburahima, na wa rikolo ra Benjami. ");
INSERT INTO wmw_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Mwenyezimungu aawakatare wanu wake wawatondore tangu mwanzo. Au amukumbukira vyaamba Mandiko Matakatifu kuhusu Aliyasi, namuna vyanlalamikira Mwenyezimungu kuhusu wanu wa Iziraeli? ");
INSERT INTO wmw_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","Iye kaamba javi: “Mola, ewo minabii wako wawolaya, mauralu ako a kafara wadangula. Ila wanasa omi tu basi yeka yangu, na wanisakula nomi novyo wanulaye.” ");
INSERT INTO wmw_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Mukumbukira majibu a Mwenyezimungu mbere yake? Akwamba: “Niriturira omi mwanyewe wanu alufu saba sawankokorere Baal!” ");
INSERT INTO wmw_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Na wakati wa rero‑wu ndi novyo, ribaki kundi ra wanu aba futi, watondoriwe kwa rehema ya Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Kutondoriwa‑ko kuwa julu ya rehema, aiwere kwa sababu ya vitendo vyawo wanu‑wo. Kamana rehema yakupatikana julu ya vitendo siyo rehema. ");
INSERT INTO wmw_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Sambi tambe, mwaja? Cawakisakula Mayahudi, kinu‑co awapatire. Ila wanu watondoriwe ndi wapatire. Wengine‑wo wataiwa myoyo migumu. ");
INSERT INTO wmw_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Kamba vyaamba Mandiko: “Mwenyezimungu kawapa roho ya usingizi, maso sawona, na masikiro sasikira, mpaka rero‑vi.” ");
INSERT INTO wmw_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Daudi neye novyo kasema javi: “Sherehe ya vyakurya vyawo iwe nambo na kiruzi, cakuwakwakurisa awe ndi maripo awo. ");
INSERT INTO wmw_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Kuwenukare kumaso wasiwone, iwatumbe miyongo yawo suku piya‑zi.” ");
INSERT INTO wmw_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Kwa javyo, nídairi tena: Mayahudi wakwakula, wagwe milele? Sivyo javyo! Ila kwa kuwa ewo wakosa, kuvushiwa kuja kwa ajili ya wanu Sawari-Mayahudi, kuwataye wivu Mayahudi. ");
INSERT INTO wmw_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Basi, ikiwa ukosa wawo uwatenza wanu mulumwengu‑mu kupata utajiri, na kupunguka kwawo ndi utajiri wa Sawari-Mayahudi, utajiri nkulu pakulu ulawirira Mayahudi pawasaka kuludira ka Mwenyezimungu! ");
INSERT INTO wmw_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Epa nankukwambirani umwe, Samuri-Mayahudi. Kwa kuwa omi niwa walii wa wanu Sawari-Mayahudi, nintukuza Mwenyezimungu kwa kazi yanipere. ");
INSERT INTO wmw_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","Konta, kwa namuna mojawapo, nisaka niwashonge wanu wa kabila yangu wawe na wivu, niwavushe wamojawapo. ");
INSERT INTO wmw_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Kamana, ikiwa kutuwisiwa kwawo ndi sababu ya wanu wa mulumwengu‑mu kupatana na Mwenyezimungu, vikuja kukuna mwaja wakikubaliwa? Ndi kamba kuludisiriwa uhai bandi ya kufwa, sinovyo? ");
INSERT INTO wmw_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Ikiwa mikate yakwanza kociwa takatifu, na ibakire neyo takatifu. Na ikiwa nzipe wa muti takatifu, na vitambi nevyo takatifu. ");
INSERT INTO wmw_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Ikiwa visinjiwa vitambi vimojawapo vya muti, na uwe kitambi ca nzaituni wa nnundu cikilunganisiwa nawo, cisanganyika na mizipe ya nzaituni mwema, cipata unoni wake, ");
INSERT INTO wmw_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","basi usiridãi julu ya vitambi visinjiwe vire. Ukiridãi, kumbukira kuwa uwe siwitamili nzipe‑wo, ila nzipe‑wo ndi ukwitamili uwe. ");
INSERT INTO wmw_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Dalili ukwamba: “Visinjiwa vitambi ipate nilunganisiwe omi.” ");
INSERT INTO wmw_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Vyema, ila kumbukira kuwa vitambi-vyo visinjiwa kwa sababu yakutowa kumwamini Mwenyezimungu. Na uwe koloka kwa sababu ya kwamini. Usiwaze kuridãi, ila wopesiwe. ");
INSERT INTO wmw_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Kamana Mwenyezimungu, ikiwa aasire vitambi kaanuni, futi uwe, aatakukwasa. ");
INSERT INTO wmw_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Kwa javyo, tunza wema na ukali wa Mwenyezimungu: upande mmoja, iye nkali ka ware wagwire, upande mwengine, iye akutenda meema, ukizidi kuinshi nkati ya wema wake. Ukasa, nnowe novyo ukuja kusinjiwa. ");
INSERT INTO wmw_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Mayahudi novyo, wakiludira kumwamini Mwenyezimungu, ewo walunganisiwa. Kamana Mwenyezimungu kanawo uwezo wakuwaludisira kuwalunganisa. ");
INSERT INTO wmw_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Kamana uwe ndi kamba kitambi cakusinjiwa munzaituni kaanuni wa nnundu, cilunganisiwe munzaituni wakuvyariwa ingawa sico kaanuni. Futi vitambi kaanuni vilunganisiwe munzaituni wawo wawenye? ");
INSERT INTO wmw_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Wanduzangu, vinajibu musitikine eyi siiri ya kweli‑yi ipate musiwaze kuwa mwa wejiwifu pakulu. Eyi siiri‑yi ndi kuwa Mayahudi wamojawapo myoyo yawo ilawirira kuwa migumu mpaka isabu ya wanu Sawari-Mayahudi Mwenyezimungu waapangire kuvushiwa, wavushiwe. ");
INSERT INTO wmw_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Kwa javyo, piya Iziraeli ikuja kuvushiwa, kamba vyavyandikiwe: “Nvushi akuja kulawa Ziyoni, akuja kulavya ubaya wa waIziraeli. ");
INSERT INTO wmw_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Na eyi ndi miyadi yaniwaturire ewo, panija kuwalavya madambi awo.” ");
INSERT INTO wmw_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Upande mmoja, kuhusu Habari Ngema, ewo maaduwi wa Mwenyezimungu kwa faida yenu. Fala, kwa kuwa Mwenyezimungu kawatondola, ewo wapendiwa pakulu kwa sababu ya tamaa yawâpewe wababu zawo. ");
INSERT INTO wmw_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Kamana Mwenyezimungu aapindula mawazo ake kuhusu wanu wawatondola na uwezo maalumu awajanliya. ");
INSERT INTO wmw_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Mida umwe amukinsikirizanga Mwenyezimungu, fala sambi‑pa moloteriwa huruma kwa sababu ya ubishi wawo. ");
INSERT INTO wmw_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Kwa namuna moja novyo, Mayahudi sambi‑pa awansikiriza Mwenyezimungu ipate kwa sababu ya huruma yamoloteriwe, newo novyo sambi‑pa woloteriwe huruma. ");
INSERT INTO wmw_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Basi, kwa sababu ya ubishi wa wanu piya, Mwenyezimungu awatula kamba wafungwa ipate awolotere wanu piya huruma yake. ");
INSERT INTO wmw_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","He, namuna vyauri nkulu utajiri wa Mwenyezimungu! Na vyaziri nyingi fahamu zake na wijiwifu wake! Nani afafánula vyaalamula iye? Nani erériwa mipango yake? ");
INSERT INTO wmw_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Kamba vyaasema Mandiko: “Nani ejíwa ankili za Mola? Nani akidiri kunlanga iye? ");
INSERT INTO wmw_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Mununi ampere kinu Mwenyezimungu kwa kuwa ajuzi kuripiwa?” ");
INSERT INTO wmw_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Konta piya vílawa kwake iye, julu yake iye, na kwa faida yake iye. Mwenyezimungu apewe utukufu wa milele! Aamina. ");
INSERT INTO wmw_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Kwa javyo, wanduzangu, kwa sababu ya huruma ya Mwenyezimungu, nukutafadalini mwiri wenu‑wo mupereke nfululu ka Mwenyezimungu, uwe kafara hai na takatifu, kamba vyavimwajibu iye. Eyi ndi ibada yako ya kweli. ");
INSERT INTO wmw_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Musiinshi vyawainshi wanu wa mulumwengu‑mu, ila mwaseni Mwenyezimungu akupindureni ankili zenu muwe na mawazo mapya. Tendani javyo ipate mwijiwe vyaasaka Mwenyezimungu, vyema, vyakwajibisa, na vyakukamilika. ");
INSERT INTO wmw_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Kamana, kwa sababu ya rehema yanipewe, nukulaizirani umwe kila mmoja: musiriwone pakulu kupunda camuri‑co. Ila kila mmoja awaze kunyenyekeya mwanyewe kwa namuna ya kwamini Mwenyezimungu vyaantongera kila mmoja. ");
INSERT INTO wmw_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Kamana kamba mwiri mmoja vyauri nawo vifingo vingi, fala vifingo-vyo piya avitenda kazi moja, ");
INSERT INTO wmw_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","ndi sawa‑sawa nofwe: tiwa wengi, fala kwa kuwa tilungana na Almasihi, tiwa mwiri mmoja, na kila mmoja kifingo ka mwenziwe. ");
INSERT INTO wmw_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Mwenyezimungu, julu ya rehema yake, katipa neema ya uwezo jisijisi. Apéwe uwezo wakubushuru, atende kwa kufulata kiyasi ca kwamini kwake. ");
INSERT INTO wmw_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Apéwe uwezo wakutumika, atumike. Ikiwa wakufunda, afunde. ");
INSERT INTO wmw_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","Apéwe uwezo wakuwarimbisa myoyo wenziwe, basi awarimbise myoyo. Apéwe uwezo wakumera, amere asiwe na coyo. Apéwe uwezo wakuwalongoza wenziwe, awalongoze kwa juhudi. Apéwe uwezo wakuwolotera wanu huruma, atende kwa radi. ");
INSERT INTO wmw_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Kupenda kwenu kuwe ka kweli. Ubaya ukukimeni, rimbisani kutenda meema. ");
INSERT INTO wmw_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Pendanani munu na mwenziwe kwa pendo ra unduyu, na mwinshimiyane kwa juhudi. ");
INSERT INTO wmw_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Tenderani juhudi kazi, musiwe wafuko. Ntumikeni Mwenye kwa roho ya kukulunguzani. ");
INSERT INTO wmw_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Nkati ya tamaa, furahini. Nkati ya tabu, vumirirani. Na nkati ya duwa, zidini kulebela. ");
INSERT INTO wmw_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Wasaidiyeni wenye kwamini. Na wayeni wapokerereni na jitiyadi. ");
INSERT INTO wmw_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Wanu wakulumbatani, nlebeleni Mwenyezimungu awabariki. Lebelani wajanliiwe, musiwalani. ");
INSERT INTO wmw_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Wenzenu wari kufurahi, furahini nawo. Wenzenu wari kurira, rirani nawo. ");
INSERT INTO wmw_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Munu na mwenziwe, mutafitiyane kwa namuna moja noyo. Musiriture ubora, ila pamulongoziwa murinyenyekeye. Musiriwone kuwa wejiwifu umwe wanyewe! ");
INSERT INTO wmw_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Musiripirirane na munu awa onse, ubaya ka ubaya. Tendani wanu vyawawona piya kuwa vyema. ");
INSERT INTO wmw_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Camukidiri umwe wanyewe, tenderani juhudi muinshi salama na wanu piya. ");
INSERT INTO wmw_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Wapendani wangu, musishupane watupu ila mwasireni nyongo Mwenyezimungu atende shariya. Konta yandikiwa javi: “Omi ndi mwenyé maripo a ubaya. Omi ndi nija kuripa, amba ndi Mola.” ");
INSERT INTO wmw_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Fala, “Aduwi wako, ikinkola njala, mpe cakurya. Ikinkola nyotwa, mpe maji. Ukintenda javyo, aduwi wako kuntula makala a moto patumela, alama ya kuntenza aya.” ");
INSERT INTO wmw_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Usishindiwe na ubaya, ila shinda ubaya na meema. ");
INSERT INTO wmw_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Kila munu ariture kusikiriza mamulaka a mafalume, konta aangari kuwepo mamulaka a ufalume bila Mwenyezimungu. Piya wenye mamulaka, iye ndi awaturire. ");
INSERT INTO wmw_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Basi, wanu wakukatala mamulaka a ufalume wawankubishana na kauli ya Mwenyezimungu. Na ware wabishana naye, wakuja kuhukumiwa. ");
INSERT INTO wmw_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Kusema kweli, mafalume awawataya wofi waténda meema, ila wawataya wofi, waténda ubaya. Úkisaka usiwope wenye mamulaka? Basi, tenda meema, ukuja kusifiwa nawo. ");
INSERT INTO wmw_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Kamana mwenyé mamulaka antumikira Mwenyezimungu kwa wema wako uwe. Fala, ukitenda ubaya, ukuwa mofi, konta iye aakusukurira bakora bure-bureni. Kamana iye ndi ntumisi wa Mwenyezimungu wakunshupa na wakunlavira nyongo aténda ubaya. ");
INSERT INTO wmw_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Ntamana, ibidi kuwasikiriza wenye mamulaka, siyo kwa kunyema nyongo ya Mwenyezimungu tu basi, fala novyo ipate fahamu zako zitengemane. ");
INSERT INTO wmw_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Kwa namuna moja novyo waripeni nsoko, konta ewo watumisi wa Mwenyezimungu, washugulikira kazi‑yo suku daima. ");
INSERT INTO wmw_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Nripeni kila mmoja camujuzi kunripa: nripeni nsoko munu wamujuzi kunripa nsoko, mpeni ncango munu wamujuzi kumpa ncango, mopeni wamujuzi kumopa, na nsifuni ire wamujuzi kunsifu. ");
INSERT INTO wmw_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Musiwiriwe anta kinu, sairi kupendana, konta ampénda munu mwengine, atimiza piya ámuri ziri nkati ya shariya. ");
INSERT INTO wmw_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Kamana ámuri‑zo zikwamba, “Usizinge”, “Usiulaye”, “Usiwe”, “Usiperereze”, na ámuri vyaziri piya, zijumulanisiwa kwa ámuri mmoja tu basi: “Mpende mwenziwo kamba vyauripenda uwe mwanyewe.” ");
INSERT INTO wmw_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Munu ampénda mwenziwe aantenda ubaya. Kwa javyo, kuwa na pendo ndi kutimiza shariya. ");
INSERT INTO wmw_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Visitoshe, mukijiwa enzi zatiri‑zi, kuwa ufika futi wakati wakusisimuka. Kamana epa sambi kuvuka kwetu kuwa karibu pakulu koliko patanzire kunkubali Insa. ");
INSERT INTO wmw_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Usiku wankupita, kuca kuwa karibu. Basi, tase vitendo vya kisi, ila tivare sulaha za panlangaza. ");
INSERT INTO wmw_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Tiinshi kwa namuna ngema kamba wanu wari kuinshi nsana juwa rikiwala. Musipite mmajambo a kurewiwa pakulu, wala musirewe. Musizinge, wala musitende kitendo kimojawapo ca ceje. Musumane, wala musiwatendere wiyana wenzenu. ");
INSERT INTO wmw_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Kwasa evyo, rikengereni na kuwapo ka Mwenye Insa Almasihi. Musisakure kurinafusi wájibu wenu mbaya wa kibinadamu. ");
INSERT INTO wmw_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Sawana nguvu nkati ya kwamini, wapokerereni, wala musiwakaidi mawazo awo. ");
INSERT INTO wmw_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Munu mmojawapo akwamini kuwa kanawo haki ya kurya kila namuna ya cakurya, fala wakwamíni aba akurya unde na masamba tu basi. ");
INSERT INTO wmw_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Munu árya cakurya kimojawapo asikejeli cakurya saarya. Na saarya cakurya kimojawapo, asinlaumu munu wakurya piya vinu, konta Mwenyezimungu kawapokerera nowo wanu‑wo. ");
INSERT INTO wmw_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Uwe nani wakusaka kunlaumu ntumisi wa munu mwengine? Ntumisi‑yo akuja koloka au kwinama mbere ya mwenye wake. Kweli, iye akuja koloka konta Mwenye Insa akidiri kumolosa. ");
INSERT INTO wmw_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Munu mmojawapo awaza kuwa iwapo suku bora pakulu koliko suku nyengine, fala munu mwengine atula kuwa suku piya sawa‑sawa. Sikirizani, kila munu oloke na mawoni ake. ");
INSERT INTO wmw_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Atúla kuwa iwapo suku maalumu atenda novyo ansifu Mwenye. Na árya vyakurya piya, akurya ka kunsifu Mwenye, konta anshukuru Mwenyezimungu. Na sawarya, newo novyo watenda javyo ajili ya kunsifu Mwenye, na wanshukuru Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Kamana kati yetu aapo munu ainshi kwa nafsi yake mwanyewe, wala aapo afwa kwa nafsi yake mwanyewe. ");
INSERT INTO wmw_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Ikiwa tankuinshi, tiinshi kunsifu Mwenye. Ikiwa tukufwa, tukufwa kunsifu Mwenye. Kwa javyo, anta tiinshi au tifwe, tiwa wa Mwenye. ");
INSERT INTO wmw_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Kamana kwa sababu ya noco, Almasihi kâfwa na kaludira kuinshi, ipate awe Mwenye wa wafwi na wari hai. ");
INSERT INTO wmw_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Sambi, uwe, konta ya kinani kunlaumu nduyo? Na uwe, sababuni kunkejeli nduyo? Kamana ofwe piya tukuja kujibu mbere ya Mwenyezimungu tilamuriwe. ");
INSERT INTO wmw_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Konta vyandikiwa: “Kamba kweli-kwelini niwapo, amba ndi Mola, wanu piya wakuja kukokora mbere yangu omi, na kila lulimi rikuja kwakikisha kuwa omi ndi Mwenyezimungu!” ");
INSERT INTO wmw_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Kwa javyo, ofwe kila mmoja akuja kujibu mwanyewe mbere ya Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Ndimana, tisilaumiyane tena. Kwasa javyo, kila mmoja alamure asintende mwenziwe kinu cakunkosesa au cakunkoresa dambi. ");
INSERT INTO wmw_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Omi nukwijiwa, visitoshe nukwakikishiwa na Mwenye Insa, kuwa acipo cakuriharamisha wanyewe. Fala, ikiwa munu awaza kimojawapo kuwa haramu, kweli-kwelini cikuwa haramu kwake. ");
INSERT INTO wmw_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Kamana, ikiwa nduyo abugudika kwa sababu ya cakurya caúrya, auri kumpenda. Usase cakurya cako kuntenza kwasika munu wakuwa, kwa ajili yake, Almasihi kâfwa. ");
INSERT INTO wmw_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Basi, musiwase wanu kusowerera caputu kitendo cenu cema. ");
INSERT INTO wmw_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","Kamana ufalume wa Mwenyezimungu siwo kurya wala kunywa, ila ndi ukamilifu na salama pamoja na radi kati ya Roho Takatifu. ");
INSERT INTO wmw_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Antumíka Almasihi kwa namuna‑yi, iye akwajibisa ka Mwenyezimungu na akubaliwa na wanadamu. ");
INSERT INTO wmw_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Basi, tukeni tisakure vinu vyakutipa usalama, na vyakujengana. ");
INSERT INTO wmw_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Isiwe kwa sababu ya cakurya úfuja kazi ya Mwenyezimungu. Kweli-kwelini vinu piya halali kurya, fala cinyáta ndi munu kurya kinu cakunkosesa. ");
INSERT INTO wmw_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Vyema kutowa kurya nyama au kunywa vinyu au kutenda kitendo kimojawapo cakuntenza nduyo kunkosesa. ");
INSERT INTO wmw_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Kwamini kauri nawo, zidi kuwa nawo mwanyewe mbere ya Mwenyezimungu. Heri ire saarihukumu mwanyewe kwa kinu caari kuyeza. ");
INSERT INTO wmw_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Fala, munu árya akidanizira, ahukumiwa, konta aarya ka kwamini. Basi, kila citendiwa bila kwamini ndi dambi. ");
INSERT INTO wmw_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Ofwe tiri na nguvu tijuzi tihitamili kuveya ka ware sawana nguvu. Tisenendere vyakutajibu ofwe wanyewe. ");
INSERT INTO wmw_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Ofwe kila mmoja atende vyakumwajibu mwenziwe kwa wema, apate kunjenga. ");
INSERT INTO wmw_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Kamana anta Almasihi aatendire vyakumwajibu iye mwanyewe. Ila kamba vyavyandikiwe: “Matukano awakutukana uwe, anigwirira omi.” ");
INSERT INTO wmw_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","Piya vyaandikiwe tangu mida, vyandikiwa vitifunde, ipate julu ya imani na kurimbisiwa myoyo vyatipewe mMandiko, tiwe na tamaa. ");
INSERT INTO wmw_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","Mwenyezimungu, mwenyé imani na mwenye kurimbisa moyo, akupeni mawazo mamoja pamunfulata Almasihi Insa, ");
INSERT INTO wmw_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","ipate kwa shauti moja muntukuze Mwenyezimungu, Baba wa Mwenye wetu, Insa Almasihi. ");
INSERT INTO wmw_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Basi sambi, kamba Almasihi vyakukaribisheni, nomwe karibishanani ipate atukuziwe Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","Omi nukwambirani kuwa Almasihi kâja awe ntumisi wa Mayahudi, olote kuwa Mwenyezimungu ndi mwenyé ukweli, atimize tamaa zaawapere wababu zawo. ");
INSERT INTO wmw_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","Almasihi kâja novyo kuwolotera huruma Sawari-Mayahudi ipate wantukuze Mwenyezimungu. Kamba vyavyandikiwe: “Ntamana nukuja kukushukuru kati ya wanu Sawari-Mayahudi, nukuja kwimba kusifu zina rako!” ");
INSERT INTO wmw_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","Akamba tena: “Furahini umwe, wanu Samuri-Mayahudi, pamoja na umati wake.” ");
INSERT INTO wmw_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","Na tena javi: “Ntukuzeni Mola, piya Samuri-Mayahudi, wantukuze wanu wa mataifa piya!” ");
INSERT INTO wmw_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Tena nabii Izaya kaamba: “Ukuja kuwepo nzipe wa rikolo ra Yese, iye alamuka awataware Sawari-Mayahudi. Iye Sawari-Mayahudi ndi wawaja kuwa na tamaa naye.” ");
INSERT INTO wmw_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","Basi sambi, Mwenyezimungu atípa tamaa akwijazeni radi pamoja na usalama piya, julu ya kumwamini iye, ipate tamaa yenu izidi kukula daima, kwa uwezo wa Roho Takatifu. ");
INSERT INTO wmw_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Wanduzangu, omi mwanyewe nanawo uhakika kuhusu umwe, kuwa ukwijalani wema pamoja na wijiwifu piya, na mukidiri kulangana. ");
INSERT INTO wmw_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","Kwa sababu ya rehema zaanipere Mwenyezimungu, nukwandikirani kwa hakika kuhusu vimojawapo ipate nukukumbuseni. ");
INSERT INTO wmw_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","Nipewa rehema‑zo niwe shikarakanzi wa Insa Almasihi, ka wanu Sawari-Mayahudi. Nituriwa kuwa ntumisi maalumu wakwereza habari ya Mwenyezimungu kamba nlongozi wa dini ipate Sawari-Mayahudi wawe kafara yakwajibisa ka Mwenyezimungu, wakuswafiwa na Roho Takatifu. ");
INSERT INTO wmw_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Basi, kwa kuwa nilungana na Almasihi Insa, omi niridãi nkati ya kazi yangu yakuntumika Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","Sitwakali kusowera kinu sairi cire caatendire Almasihi julu yangu omi kuwatwala wanu Sawari-Mayahudi wansikirize Mwenyezimungu. Evi vikuna julu ya usemi wangu na vitendo vyangu, ");
INSERT INTO wmw_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","julu ya uwezo wa alama na maajuza, atendiwe na uwezo wa Roho Takatifu. Kwa javyo, nereza nfululu Habari Ngema za Almasihi, mwanzo wa Yerusalemu mpaka inti ya Ilíriko. ");
INSERT INTO wmw_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","Kweli-kwelini, anzima yangu daima íkiwa yakwereza Habari Ngema mahala mwaritowire kusikirika zina ra Almasihi, ipate nisijenge julu ya aluserusu zijengiwe na wanu wengine. ");
INSERT INTO wmw_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","Ila kamba vyaandikiwe: “Wanu sawambiriwe habari zake, wakuja kuwona. Wanu sawanasikira kuhusu iye, wakuja kwereriwa!” ");
INSERT INTO wmw_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","Ndimana, mara nyingi zawenye sikipata nafasi ya kuja kukuwonani. ");
INSERT INTO wmw_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","Epa sambi, kwa kuwa sina mahala tena pakutenda kazi ezi inti‑zi, na kwa kuwa tangu mida nilangela kuja kukuwonani, ");
INSERT INTO wmw_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","nanawo tamaa yakupita kwenu nukuwoneni, panisaka kuka Shipanya. Tikisa kutenda radi ya kuwonana wakati aba, vikinajibu munipereke Shipanya‑ko. ");
INSERT INTO wmw_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Fala sambi‑pa nankuka Yerusalemu, nikawaudumu wenye kwamini. ");
INSERT INTO wmw_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","Konta wafulati wa Insa Makedoniya na Akaya wawazisana vyema wacange wawaperekere wakosofu wenye kwamini wa Yerusalemu. ");
INSERT INTO wmw_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","Wawaza vyema kutenda javyo. Kweli-kwelini, ewo Sawari-Mayahudi wákiwa na deni na nowo wanu wa Yerusalemu‑wo. Basi, kwa kuwa ewo Sawari-Mayahudi wafaiwa na mambo a kiroho a Mayahudi, newo iwabidi wawahudumu kwa vinu vyawari nawo. ");
INSERT INTO wmw_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","Kwa javyo, nikimariza shuguli‑yi, nikiwagabizi sana ewu nsada‑wu, nílawa nukuka Shipanya, na noyo safari‑yo, ndi yanija kukuwonani. ");
INSERT INTO wmw_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","Nukwijiwa kuwa nikija, julu yangu omi Almasihi akujanliyani nfululu. ");
INSERT INTO wmw_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","Wanduzangu, kwa kuwa tintumaini Mwenye Insa Almasihi, na kwa sababu ya pendo ratipewe na Roho Takatifu, nukutafadalini mutende vita pamoja nomi julu yakunilebelela ka Mwenyezimungu, ");
INSERT INTO wmw_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","ipate anivushe mmakono mwa wabishi wari Yudeya. Munilebelele duwa novyo ipate kazi yangu yanuka kutenda Yerusalemu ikakubaliwe na wenye kwamini. ");
INSERT INTO wmw_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","Basi, Mwenyezimungu anijanliye, nije kwenu kwa radi, na nipate kupumuzika pamoja nomwe. ");
INSERT INTO wmw_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","Mwenyezimungu mwenyé usalama awe pamoja nomwe piya. Aamina. ");
INSERT INTO wmw_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","Omi nukulaizirani kuhusu nlumbwetu Foibe, ari kutumika njamati ya Kenkereya, ");
INSERT INTO wmw_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","ipate mumpokerere vyema kwa zina ra Mwenye, kamba vyawajuzi kutenda wenye kwamini. Munsaidiye vinu piya vyaaja kusakula kwenu umwe, kamana kawasaidiya wanu wengi wawenye, anta nomi kanisaidiya. ");
INSERT INTO wmw_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","Salamu zawo Pirisila na Akila, ewo watenda kazi pamoja nomi kuntumika Almasihi Insa. ");
INSERT INTO wmw_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","Kusema kweli, ewo watwakali mainsha awo wanyewe ipate wanivushe omi. Omi niwashukuru, na sumi basi, anta na jamati piya za wanu Sawari-Mayahudi ziwashukuru. ");
INSERT INTO wmw_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","Salamu zawo novyo wenye kwamini wasimanananga nnyumba mwawo. Salamu zake mpendani wangu, Epayinetu. Iye ndi awere nfulati ntanzi wa Almasihi mporovinsiya ya Aziya. ");
INSERT INTO wmw_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","Salamu zake Mariyamu, akorire kazi pakulu kwa faida yenu umwe. ");
INSERT INTO wmw_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","Salamu zawo Andoroniku pamoja na Juniya, jamaa zangu wa kwetu kumoja, wákiwa wenzangu nkalaboshu. Ewo wakwinshimiwa pakulu pawenye nkati ya mawalii. Ewo wankubali Almasihi omi saninamba kunkubali. ");
INSERT INTO wmw_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","Salamu zake Ampiliyatu, mpendani wangu nkulu nkati ya mainsha yetu upande wa Mwenye Insa. ");
INSERT INTO wmw_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","Salamu zake Urubanu, mwenzetu nkati ya kuntumika Almasihi, pamoja na mpendani wangu, Sitaku. ");
INSERT INTO wmw_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","Salamu zake Apele, olote kwaminika mbere ya wafulati wa Almasihi. Na salamu zawo jamaa wa Arishitobulu. ");
INSERT INTO wmw_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","Salamu zake Herodiyana jamaa yangu, pamoja na wenye kwamini jamaa zake Narikisi. ");
INSERT INTO wmw_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","Salamu zawo Turufena pamoja na Turufosa wantumikanga Mwenye, na mpendani wangu Perisi, akorire kazi pakulu kwa Mwenye. ");
INSERT INTO wmw_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","Salamu zake Rufo atondoriwe na Mwenye awe wake. Na salamu zake mamaye Rufo, wanintendire kuwa mama. ");
INSERT INTO wmw_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","Salamu zawo Asunkiritu, Feligoni, Herimeyu, Potoroba, Herima, pamoja na piya wafulati wa Insa wari pamoja nomwe. ");
INSERT INTO wmw_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","Niwaperekera salamu novyo ka Filologu, Juliya, Nereya na nunuye, Olumpa, pamoja na piya wenye kwamini wari pamoja nawo. ");
INSERT INTO wmw_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","Musalimiyane kwa alama takatifu yakolota pendo ra Insa. Piya jamati za Almasihi wakuperekerani salamu. ");
INSERT INTO wmw_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","Sambi, wanduzangu, nukutafadalini muwatunze wawatenza wanu kwawanyana na kuwadanganya nkati ya inlimu yamurifundire umwe, watanukeni. ");
INSERT INTO wmw_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","Kamana wanu kamba ewo awantumika Mwenye wetu, Almasihi, ila waritumika ewo wanyewe. Julu ya kusowera usowezi mwema nkijanja, wawatesa wanu sawana ankili. ");
INSERT INTO wmw_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","Wanu piya wakwijiwa kuwa umwe munsikiriza Mwenye Insa. Kwa javyo, niwa radi kwa sababu zenu umwe. Novyo-sivyo, vinajibu muwe wejiwifu mufulate wema, fala mutikine kutenda vitendo vibaya. ");
INSERT INTO wmw_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","Mwenyezimungu, Mwenyé usalama, kwa mpunde nowo, ansapa Ibilisi mmaulu mwenu. Rehema ya Mwenye wetu, Insa, iwe pamoja namwe. ");
INSERT INTO wmw_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","Timotiyu, mwenzangu wa kazi, akuperekerani salamu. Jamaa zangu wa kwetu kumoja, Lukiyu, Yasoni, pamoja na Sosipateri, newo novyo wakuperekerani salamu. ");
INSERT INTO wmw_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","Omi Teritiyu, niri kwandika eyi waraka‑yi, nukuperekani salamu kwa zina ra Mwenye Insa. ");
INSERT INTO wmw_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","Gayu, wanifikire nnyumba mwake, iye apereka salamu pamoja na jamati ijumananga nnyumba mwake. Erashitu, mwenyé kupokerera nzuruku wa kaya ulu, neye novyo akuperekerani salamu, pamoja na nduyetu Kwarutu. ");
INSERT INTO wmw_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","Basi, atukuziwe Mwenyezimungu! Iye akidiri kukwakikishani nkati ya kwamini kwenu, kwa namuna vyaisema Habari Ngema yangu na vyereze Insa Almasihi. Iye akoloseni kwa kufulata siiri ifisiwe tangu mwanzo fala sambi ifafanúriwa. ");
INSERT INTO wmw_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","Siiri‑yo ifafanúriwa julu ya mandiko a minabii, ikwijiwikana ka kabila piya, kwa kufulata vyaalazimishe Mwenyezimungu wa milele, ipate wantumaini na wanfulate. ");
INSERT INTO wmw_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","Mwenyezimungu ndi Mwenyé wijiwifu mmoja tu basi. Iye, julu ya Insa Almasihi, atukuziwe kwa milele! Aamina.");
INSERT INTO wmw_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","Omi Paulu, nitondoriwa niwe walii wa Almasihi Insa kamba vyaasaka Mwenyezimungu. Omi na nduyetu Soshiteni ");
INSERT INTO wmw_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","tukwandikirani eyi waraka‑yi umwe wa jamati ya Mwenyezimungu mwikala Korintiyu, muswafíwe julu ya Almasihi Insa. Umwe mwitiwa watakatifu pamoja na piya wanu wa kila upande wari kwita zina ra Insa Almasihi, Mwenye wetu. Iye ndi Mwenye wawo na wetu. ");
INSERT INTO wmw_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","Mwenyezimungu, Baba wetu, pamoja na Mwenye wetu, Insa Almasihi, wakujanliyeni rehema na salama. ");
INSERT INTO wmw_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","Ninshukuru daima Mwenyezimungu kwa rehema yake yakujanliyeni julu ya Almasihi Insa. ");
INSERT INTO wmw_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","Kamana mutajirisiwa kwa vinu piya julu ya iye, kwa piya usowezi na piya wijiwifu, ");
INSERT INTO wmw_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","konta ushahidi kwetu kuhusu Almasihi ukolosiwa kati yenu umwe. ");
INSERT INTO wmw_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","Kwa javyo, ayukutowani neema ya uwezo isaka kuwa yonse, kuno mukirindira kufafanula ka Mwenye wetu, Insa Almasihi. ");
INSERT INTO wmw_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","Iye novyo akusaidiyani koloka mpaka mwinsho, bila kusutumiwa makosa, suku ulu paasaka kuludi Mwenye wetu, Insa Almasihi. ");
INSERT INTO wmw_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","Mwenyezimungu mwaminifu. Julu yake, mukwitiwa muinshi ka umoja na Mwanawe, Insa Almasihi, Mwenye wetu. ");
INSERT INTO wmw_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","Nukulebelani wanduzangu, kwa zina ra Mwenye wetu, Insa Almasihi, ipate muwe nawo mawazo mamoja, kusiwepo kwawanyana kati yenu, ila mulungane, ankili zenu ziwe moja, na mawoni enu awe mamoja. ");
INSERT INTO wmw_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","Wanduzangu, jamaa zake Kolowi wanipa habari zenu, kuwa kati yenu uwapo umani. ");
INSERT INTO wmw_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","Nukwamba kuwa kila mmoja akwamba “Omi ninfulata Paulu”, mwengine “Omi ninfulata Apolu”, mwengine “Omi ninfulata Peduru”, na mwengine “Omi ninfulata Almasihi”. ");
INSERT INTO wmw_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","Itakuwa Almasihi‑yo kawanyika? Itakuwa mwenyé kufwa kwa ajili yenu pansalaba níkiwa omi Paulu? Au wamojawapo kati yenu woziwa kwa zina ra Paulu? ");
INSERT INTO wmw_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","Nishukuru kuwa nkati yenu simozire munu anta mmoja, ila nimoza Kirispu na Gayu, ");
INSERT INTO wmw_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","ipate asiwepo munu wakwamba kuwa moziwa kwa zina rangu. ");
INSERT INTO wmw_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","(Nikumbukira kuwa niwoza novyo jamaa zake Eshitefanu, fala sikumbukira kuwa nimoza munu mwengine tena.) ");
INSERT INTO wmw_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","Konta Almasihi aanitumire kupita nikoza wanu, ila kwereza Habari Ngema, sanitumira usowezi wa wijiwifu, ipate nisilavye faida ya uwezo wa kifo ca Almasihi pansalaba. ");
INSERT INTO wmw_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","Kamana habari za kifo ca Almasihi pansalaba ndi habari za uzozo ka wari kwasika. Fala kwetu ofwe tiri kuvushiwa, ezi ndi habari za uwezo wa Mwenyezimungu. ");
INSERT INTO wmw_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","Kamana kamba vyavyandikiwe: “Nifuja wijiwifu wa wejiwifu, na kwereriwa ka werevu, nikatala!” ");
INSERT INTO wmw_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","Wandepi wejiwifu? Wandepi wanlimu wa shariya? Wandepi wakuwajibu kukaidi vinu vya ezi enzi‑zi? Mwenyezimungu wijiwifu wa mulumwengu‑mu aaturire uzozo? ");
INSERT INTO wmw_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","Kamana, nkati ya wijiwifu wa Mwenyezimungu, wanu awakidirire kumwijiwa julu ya wijiwifu wawo. Kwasa javyo, Mwenyezimungu kalamula, julu ya uzozo watiri kwereza, kuwavusha wenye kumwamini. ");
INSERT INTO wmw_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","Mayahudi wasaka wawone alama, Sawari-Mayahudi wasakula wijiwifu, ");
INSERT INTO wmw_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","fala ofwe tintangaza Almasihi agomezeriwe. Habari‑zi ka Mayahudi matukano, na ka Sawari-Mayahudi uzozo. ");
INSERT INTO wmw_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","Novyo-sivyo, kwa ware wetiwe na Mwenyezim