﻿USE sofia;
DROP TABLE IF EXISTS sofia.wmt_vpl;
CREATE TABLE wmt_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES wmt_vpl WRITE;
INSERT INTO wmt_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","31","Jarluwarlany pa Kuttu ngartakpani pujurni nguwajaa ngapa yalkirijaa yimpiyimpi. Kujartikarra manya ngartakpani Ngarpungu. Jarluwarlany pa yarr ngunangani munga ngapa mapirri. Ngajirta nguwa ngunarla. Walypa Ngarpukurajangka pa kirilyyanani ngapangarni marnpa kankarnimarrangu. Nyanartijangka Ngarpu marni, “Parralanku pa tili.” Mapunparnila parralani tili nyanarti. Kurrinypala pila ngunangani tilijarra munga. Tili parralani, wali wirriyajarrinyala Ngarpu. Tiliwu parla wulyumarni. Yinijartila pinya yutukani jininyarajartijaa pukanyjajarti. Wali kajalkajal Ngarpungu ngartakpani tililiny. Nyanartijangka jirna Ngarpungu pinya ngurrujarrakujirni ngapajarra. Ngarpungu marni jarlu, “Ngurrujarrakujiwu pinya ngapajarra.” Wali mapunparnila ngurrujarrajarrinya pila ngapajarra. Kanarlany ngapa kankarni yimpiyimpirla, ngapawarlany kaniny. Yini yutukani yimpiyimpi Ngarpungu. Wali kujartikarra pinya ngartakpani ngapawarlany kankarni ngapawarlany kaniny. Nyanartijangka wartangurniwarlany pa ngartakpani nguwa. Ngarpungu marni, “Kayantajarrilu ngapa kaniny, yangkala pa nguwa mapirri ngunawujaa pamarr mapirri.” Wali Ngarpungu mapunparnila kayantakujirni ngapa, nguwa mapirrijaa pamarr mapirrila nguja. Ngunangani palu pamarrjaa nguwajaa jawurlata. Yinijarti pinya yutukani nguwajartijaa jawurlatajarti. Wali wirriyajarrinyala pa Ngarpu. Yarntarni Ngarpu marni, “Nguwanga pa wurrkal turtangku manawarntijaa yukawarnti. Nyanarti turtapungku, purlkajarriwula palu. Yarntarni kanarlany yitilalwarlany turtangku, yarntarni kiyijangka turtangku, yarntarni wurrkaljarriwu kiyijangka. Yangkartirni yuka kirlirni manawurti nganapartu nganapartu.” Wali mapunparnila palu turtapinya wurrkalwarnti paja yukawarntijaa manawarnti nganapartu nganapartu. Walimpa palu purlkajarrinya kiyijartijarrinyala. Yarntarni kanarlanyja turtapungku kiyijangka kirlirni. Kujartikarra nira turtapunganku yitilalwarlany yitilalwarlany. Wali wirriyajarrinyala Ngarpu. Wali kujartikarra manya Ngarpungu ngartakpani jawurlatajaa nguwajaa pamarr, yukawarntijaa manawarnti. Yarntarni wartangurniwarlany pa ngartakpani purangujaa yakarn. Ngarpungu marni, “Tilijarra pila ngunawu yimpiyimpirla parralanupurru. Purangu pa ngunawu jininyarapurru. Jininyara pa parralanku nguwa. Kanarlany yakarn ngunawu pukanyjapurru. Pukanyja pa parralanku nguwa.” Mapunparnila pinya Ngarpungu ngartakpani purlkajarra purangujaa yakarn. Yangkarti layiwarlany purangu pa purlkajinyangu jininyarapurru. Kanarlany lamparn pa pukanyjapurru yakarn. Nyanartijangka ngurrujarrajarrinyala pila jininyarajaa pukanyja. Pinayungany parlipanya purangurlu. Turtapungany kumantawarlany kumantawarlany, wali pinarrila parlipa nguniny. Nyanartijangka purangu karla takurryanany, mungajarrilanypala pukanyjajarrilany. Yarnta purangu parlipangu kurnakwantilany makurrajaa parranga, yarnta yitilal. Yarnta manya Ngarpungu ngartakpani wirlwarnti. Yutukani manya yimpiyimpirla purangujaa yakarn, wirlwarnti mapirri, wirriyajarrinyala. Wali kujartikarra manya Ngarpungu ngartakpani tiliwarnti yimpiyimpikarrajiwarnti. Yarntarni wartangurniwarlany pa ngartakpani kuyiwarnti ngapakarrajiwarntijaa yalkirikarrajiwarnti. Ngarpu marni, “Kuyiwarnti pajajinyangu ngunawu ngapawarlany ngapawarlany, kapiwarntijaa kuyiwarnti yangka pakitkarra yanany ngapakarrajiwarnti. Yarnta jirikiwarnti pajajinyangu palu lapalku yimpiyimpirlal.” Mapunparnila manya ngartakpani nukarnini kapiwarnti purlkapurlka lamparnlamparn. Kuyiwarntiwarlany ngapakarrajiwarntiwarlany manya ngartakpani pakitkarrajartiwarnti wurnajartiwarnti. Nyarnakarrajiwarntijaa partikarrajiwarntijaa rirringkikarrajiwarnti manya ngartakpani Ngarpungu. Kanarlanywarnti manya purlkawarntijinyangu ngartakpani. Jirikiwarnti manya ngartakpani nukarnini purlkapurlka lamparnlamparn. Wirriyajarrinyala Ngarpu. Marnila manyanangu Ngarpungu kuyiwarntiwu ngapakarrajiwarntiwujaa yalkirikarrajiwarntiwu, “Wulyu marnanya ngartakpani. Ngajirta nganta nyurrawarntimipa nguna. Jukuwarnti mantanya martawu kanarlanywarnti, pajajarriwula palu. Yarntarni palunya jirna jukuwarntiwarlany martawu. Kujangkurrarni kujangkurrarnila pajajarrinyanku. Yarr palu ngunawu kuyi pajajinyangu wanyjurlajarra ngapawarlany ngapawarlany kuyipartu kuyipartu palu ngunawu. Jirikiwarnti palu pajajinyangu ngunawu wanyjurlajarra.” Wali kujartikarra manya Ngarpungu ngartakpani kuyiwarnti ngapakarrajiwarntijaa jirikiwarnti yalkirikarrajiwarnti. Yarntarni wartangurniwarlany manya ngartakpani nguwakarrajiwarnti. Ngarpungu marni, “Kuyiwarnti pajajinyangu ngunawu nguwanga nganapartu nganapartu purlkapurlka lamparnlamparn jinajartiwarntijaa jilpirtijartiwarnti.” Mapunparnila manya ngartakpani Ngarpungu kuyiwarnti nganapartu nganapartu jilpirtijartiwarntijaa jinajartiwarnti palkakarrajiwarnti. Wirriyajarrinyala pa. Nyanartijangka Ngarpu marni, “Ngartakpankurlipa piyirn ngalimpajilinyparni, nyapartukarra parlipa nguniny. Maja manyanangu ngunawu kuyiwarntiwu nguwakarrajiwarntiwujaa yalkirikarrajiwarntiwujaa ngapakarrajiwarntiwu mapirri.” Mapunparnila Ngarpungu ngartakpani piyirn nyantujilinyparni. Ngarpujilinyparni pa ngartakpani piyirn. Nganpayijaa marnin pinya ngartakpani. Marnila pilangu Ngarpungu, “Wulyu marnanypinya ngartakpani. Ngajirta nganpila nyurrajarramipa nguna. Juku manpilanya martawu kujangkurrarnila palu pajajarrinyanku. Kujangkurrarni kujangkurrarni pajajarrinyanku palu marninjaa nganpayi. Kujangkurrajarra nguwanga ngunawu piyirn pajajinyangu.” Yarntarni pilangu marni Ngarpungu, “Maja manpilanyanangu ngunawu kuyiwarntiwu nguwakarrajiwarntiwujaa yalkirikarrajiwarntiwujaa ngapakarrajiwarntiwu. Nukarniwu manpilanyanangu maja.” Yarntarni pilangu marni Ngarpungu, “Yinya marnanypinya miyiwarnti nukarnini ngarnupurru kiyijartiwarnti. Kanarlanywarnti palu yukajiliny turtangany, kanarlanywarnti palu mana turtangany miyila martalany mananga nyanayirla. Nukarnini manpila ngalku.” Kuyiwarntijaa jirikiwarnti marnanya yinya wurrkal ngarnupurru. Miyi manyanangu ngunawu yukajangkajaa manajangka nukarni.” Nyanartijangka nyanganila manya Ngarpungu nyapartukarra manya ngartakpani nukarni. Nganapartu nganapartu manya ngartakpani Ngarpungu, nyanganila manya wulyujinyangu. Wali wirriyajarrinyala. ");
INSERT INTO wmt_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","25","Nyanartijangka warrkam pujumanurla, yarrpala kirrarni Ngarpu. Warrkamjangka pa kirrarnani yarr. Nyanartila pa kirrarnujangkarlu nyanya wulyujinyangu. Wirriyajarrinya Ngarpu. Pinapinakarrinyani, “Jalarra paji wulyujinyangu marulujinyangu. Kanarlanyparni paji nguniny, tumaj marna kirrarnana warrkamjangka. Julawu marnanyanangu kanarlanywarntiwu, warrkamjarti palu ngunawu murrkurnwarlany murrkurnwarlany. Nyanartijangka puranguwarlanyja palu kirralku warrkamngajirtajarti. Yarntarni wangkiwarlany kirlingalparni tikirrjularnuwu nyapartukarra Ngarpungu ngartakpani nguwajaa ngapa yalkirijaa yimpiyimpi. Warrarni piyirn ngajirta ngunarla warrkampurru katinpurru. Ngarpungu ngajirta yiparla ngapa kankarnimarrangu yimpiyimpijangka warrarni. Piyirn mapirri ngajirta ngunarla warrarni katin ngajirta turtangantarla. Ngapa nguwajangkamipa laparnani. Nyanartirlu jarlanykujirnani ngapangu. Nguwa pujurni wapalkarra pa jarlanykujirnani. Wali nguwajangka ngartakpani piyirn Ngarpungu purlkangu, puwumanila punul, ngayilajartila ngujangurra, rangarnanila wanji, nyanartila ngujangurra piyirn wanji. Nyanartijangka Ngarpungu purlkangu pa katin kakarra yutukani. Katin nyanarti yini parla Yitin. Wali nyanayirla katinta pa yutukani piyirn yangkarti. Manawarnti pajajinyangu manya yutukani. Turtanyala palu manawarnti, kankarnikujirnila manawarnti Ngarpungu. Nyanartiwarnti manawarnti palu wulyujinyangu miyijarti wulyujarti. Yarnta jalungurru palu wulyujinyangu nyangupurru nguja. Kurriny pila karrinyani kaparn manajarra. Layiwarlany pa wanji yungujuwal. Puju miyi wanji yungujuwal nganyjarla, wanjila pa ngunarla kujawurlurra. Kanarlany mana pa pinayungujuwal. Puju miyi nganyjarla pinayungujuwal, pinarrila ngunarla. Pujuwurni parla pinarri ngunarla wulyuwujaa yakurrku nganapartuwu nganapartuwu. Katin yini Yitin ngunangani. Wali nyanartingurni martuwarrala laparnani layi. Jarlanykujirnani nguwa. Ngapangula manya kalypajanani manawarnti katinjangkawarnti. Wali kurlirrawarlany palmapinyala palunyanu martuwarrawarntirlu. Ngurrungurrujarrinyala palu nyanartiwarnti martuwarrawarnti kurrinywarlany kurriny. Nyanartiwarnti martuwarrawarnti palu yinijartiwarnti. Wali Ngarpungu pa yutukani piyirn yangkarti katinta Yitinta ngampurrikanupurrujaa karlarnupurrujaa kiyi yutukanupurru. Jinjinyinya parla miyiwarntiwu katintajangkawu ngarnupurru kanarlanywarnti miyiwarnti. Marni parla Ngarpungu, “Kanarlanywarnti manya ngalku miyi nganapartu nganapartu yangka palu nguniny katinta. Layi mana ngajirta ngan nganyja yangkarti pinarriyungujuwal kaparn karrilany. Puju man ngalku nyanarti, pirlajarriwula man.” Nyanartijangka Ngarpu marni, “Layi nganpayi pa kirrarnana minilingajirta kayanwarlany jintanga. Yakurr pa kirrarnupurru jintanga. Ngartakpanku marnarla minili, turtukpala pila ngunawu.” Wali yiparnila manya kuyiwarntijaa jirikiwarnti nguwajangkawarnti yangka manya ngartakpani. Nyanartikarti piyirnkarti manya yiparni Ngarpungu. Nganpayirlu nyanartirlu manya yinila julawu. Yinijarti yinijarti kuyiwarnti nyanartiwarnti pujurni nganapartu nganapartu nguwakarrajiwarntijaa yalkirikarrajiwarnti. Yinila manya yutukani nganpayirlu. Yinijartiwarnti palu ngunangani. Wali nyangani Ngarpungu, kujarti pa yakurr turtukngajirta nganpayipurru, tumaj palu kuyiwarnti nyanartiwarnti. Nyanartijangka Ngarpungu pa manyankujirni nganpayi purlkajinyangu manyan. Wali Ngarpungula manyanta layi yilpirn warntarni, tikirrpala nimpinya nyanarti kirli warntarnujangka. Ngartakpanila marnin yilpirnjangka, marninpala parla nyanarti nganpayi yinya. Wirriyajarrinyala nganpayi, marnila, “Minyarti wulyu turtukjinyangu ngajukurajangka kujijangkajaa ngilykijangka mapirri. Minyarti wulyu turtuk.” Wali yinijarti pa marnin nyanarti yutukani nganpayirlu nyantukurarlalparni yini. Marnin pa yutukani yini. Kujartikarra nira piyirntu ngarpujaa ngamaji pinya wanyjarralany, marnintala manyanta kirralany kartunga nyantukurarla. Kayanjilinyparnila pila nguniny. Wali kurtangarri pila ngunangani marninjaa nganpayi nyanarti pila wulyu ngunangani. Ngajirta pila kurntayijarrirla nyanartikarra pila wulyu ngunangani kurntayingajirta. ");
INSERT INTO wmt_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","24","Wali jilpirtijarti manyanta pirriyani marninta. Kuyi nyanarti jilpirtijarti pa ngintanjinyangu kajiyungujuwal. Japirlyinyala parla marnin jilpirtijartirlu, “Jarrmarni nganypilangu miyiwu pujuwurni ngarnupurru Ngarpungu. Mapun nganypilangu jarrmarni.” Jangkumani manyanta marnintu, “Miyi pajarra ngalku nganapartu nganapartu katinjangka. Layiwula pajarrangu jarrmarni. Marni pajarrangu, ‘Nyanarti mana layi yangkarti kaparn karrinyana ngajirta nganpila nganyja miyi, yarnta ngajirta nganpila palymanta. Puju manpila palymankuwurti, ngalkuwurti, wali pirlajarriwula manpila.’” Wali jilpirtijartirlu parla marni, “Ngajirta. Kayan nganpila pirlajarri.” Yarntarni parla marni marninku, “Yangka miyi nyanarti manpila ngalku, pinajarrala manpila tarlkalku. Pinarrila manpilarla ngunawu yakurrkujaa wulyuwu pujuwurni. Ngarpujilinyparni manpila ngunawu. Ngarpungu parla pinarri pujuwurni wulyuwujaa yakurrku. Nyantujilinyparni manpila ngunawu. Nyanartirlamarra pinarrijarrinyurlamarra manypilangu jarrmarni Ngarpungu.” Kujarti parla marni marninku jilpirtijartirlu. Nyanartijangkarlu marnintu nyanartirlu parla mapunikani jilpirtijartiwu. Nyangani mana yangkarti pinayungujuwal. Marrupungani, wulyumarnani parla, yarnta pa wulyujinyangu jalungurru. Marrupunganila ngarnungurla pa pinarrijarriwu. Nyanartijangkarlu miyi parlanyanu warntarni manajangka nyanartijangka, ngarnila pa marnintu. Nyanartijangkarlu yinyala parla nganpayi, ngarnila nganpayirlu. Wali ngarnungurla pinajarrala pila tarlkani. Partalurnila pila pinakarrinyani, “Nyapartu parli kurtangarri nguniny.” Kurntayijarrinyala pila. Warnjalwarnti pila jungani, mintimmarnila pila nyimparrapurru rukukanupurru. Warnjalwarnti purlkapurlka palu marrkurtajiliny japal. Wali nyanartijangka yangka walypa pirriyani karuwarrajarti, nyanartikarrarni pila Ngarpu pinakarrinya kartajkarra yanujangka. Wali ranyjiwantinyala pila nganpayijaa marnin. Ngarpuwu pilarlanyanta ranyjiwantinya yungkunga katinta. Ngarpungu parla japirlyinya nganpayi, “Nganajangka pajinkurla ranyjiwantinya.” Jangkumanila manyanta nganpayirlu, “Ngajirta. Pinakarrinya marnanta kartajkarra yanujangka, ranyjiwantinyala marna, tumaj marna kurntayijarrinya kurtangarrijangka. Rayinkarrinya marna, nyanartila marna ranyjiwantinya.” Ngarpungu parla japirlyinya, “Nyapartukarra manyanu nyanya kurtangarri. Ngantungu manta pinayinya.” Yarntarni japirlyinya, “Ngarni ngan miyi yangkarti pinayungujuwal yangka marnangu jarrmarni.” Nganpayirlu manyanta jangkumani, “Yangkarti marnin pajan yinya, nyanartirlu paja miyi yinya, ngarnila marna.” Wali marnila parla marninku Ngarpungu, “Nganajangkarlu mankurla yinya.” Marnintu manyanu jularni, “Jinjinyinya paja jilpirtijartirlu, yarnta paja kajiyinya, ngarnila marna.” Marnila parla Ngarpungu jilpirtijartiwu, “Kujikani manyanu. Kanarlanywarntirlu kuyiwarntirlu ngajirta palunyanu kujikanantarla. Nyuntungu manyanu kujikani. Wartangurnijinyangula man ngunawu. Nyuntuwu mangu jarrkanganku muntangu. Yanku man nira ruwukarra kaniny nguwangal.” Yarntarni parla marni Ngarpungu jilpirtijartiwu, “Nyurrajarrarlu manpilanyanu nira kurninykanganku marninjarrarlu, kurninykangankula manpilanyanu muntangu. Wali jilpirtijartikurawarnti nyuntukurawarnti yapajirnanyungu palu ngunawu, yarnta marninkurawarnti palu ngunawu yapa jirnanyunguwarlanyparni. Marninkurarlu jukuwarntirlu palunya jurlu pungku, pajarrkula palunya jina jilpirtijartikurawarntirlu jukuwarntirlu. Kujartikarra palu ngunanganku.” Nyanartijangka parla marninku marni Ngarpungu, “Yapawarnti manya martawu karrkarr purlkajawurlu. Yarntarni mankurla juturni yuwurnjarriwu ngumparnawu, nyantula mangu maja ngunawu ngumparna.” Nganpayiwula parla marni Ngarpungu, “Mapunikanila mankurla kartu nyuntukura. Pinakarrinya manyanta, miyila manta yinya, ngarnila man yangkarti miyi marnangu jarrmarni, ‘Ngajirta ngan nganyja.’ Nyanartijangka marna yakurrkujiwu nguwa nyuntungurni. Nyuntungu manyanu jarlu kujikani, nguwala ngunawu yakurryakurrwarnti. Yakurrwarntijaa wulyuwarnti palu turtapunganku kirninyja kanarlanywarnti wulyu ngarnupurru, kanarlanywarnti ngarla ngarnupurrungajirta. Wajapungankula palu yakurrwarntirlu kanarlanywarntirlu kirlijartiwarntirlu. Kayan ngarta wulyumipa turtangka miyi. Kujartikarra ngunawu. Miyi man ngalku yukajangka turtapungujangka. Warrkammarnanku man nira purlka warrkam miyiwu ngarnupurru. Jirrmirljarti man ngunawu warrkamjangka. Kayan ngan yarr kirranyja. Warrkammarnanku man nira, kitangarni man pirlajarriwu. Nguwajarriwu man tikirr kirlingalparni. Yangkarti marnanta ngartakpani nguwajangka, jalarra man nguniny nguwajangka piyirn. Puju man pirlajarriwu, wali tikirr man nguwajarriwu kirlingalparni.” Kujarti parla marni Ngarpungu nganpayiwu. Nyanartijangka pinapinakarrinya nganpayirlu marnin nyanarti, “Ngamaji manyanangu ngunawu pujuwurni nukarniwu.” Nyanartijangkala jularni yini parla Yip. Nyanartijangka Ngarpungula pinya ngartakpanurla yinya partu kuyijangka nyimparrapurru. Yutukani pilanyanu partu kuyijangka karrkinta, kanganila pila. Wali Ngarpungu pinapinakarrinyani, “Manajarra yangkartijarra pila karrilany katinta kaparn, kanarlany pinayungujuwal, kanarlany wanjiyungujuwal. Wali pila ngarni kanarlany miyi pinayungujuwaljangka, pinarrila pilarla nguniny pujuwurni yakurrkujaa wulyuwu. Warra ngartapila yarnta nganyja miyiwarlany yangka kanarlany wanjiyungujuwal. Ngarnungurla pila wanji kujawurlurra ngunawu. Wali kayan ngartapila nguna wanji kujawurlurra.” Wali ngunyipinyala pinya nyanartingurni katinngurni Yitinngurni palkakarti. Warrkammalkula pila nguwa, nguwajangkarni yangkarti ngartakpani nganpayi Ngarpungu. Purlka warrkam pilangu ngunawu karlarnupurrujaa kiyi yutukanupurru. Wali yutukani manya Ngarpungu nyantukurawarnti ngampurrjiwarnti katinngurni kakarra. Ngampurrikanani palupinya nganpayijaa marnin, ngajirta ngartapila tikiyanta yarnta katinkarti. Ngajirta ngartapila nganyja miyi wanjiyungujuwal. Nyanartirlamarrala palu ngampurrikanani. Ngampurrjiwarnti palu purlkajarti nayipjarti ngunangani, nyanarti nayip purlka warlujarti wirriwirrimarnani. Tirnyutukani palu warntarrirla. ");
INSERT INTO wmt_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","26","Wali nyanartijangka yukarnani manyanta ngumparnarla Ratamja marnin Yip. Nyanartijangkala pila yapajartijarrinya, tarlkujirnila manyanu parri yini parla Kayin. Wali Yipju marni, “Parri marnajin parlipinya. Ngarpungu paja juku yinya.” Yapawarlany tarlkujirni manyanu yini parla Yipul wartangurnijangka. Wali purlkajarrinyala pila, nganpayijarrinyala. Wali kanarlanyju kajalurnijangkarlu warrkammarnani katin. Nguwa pa karlarnani katinpurru. Karlarnurla kiyila tarrapungku, miyila turtangku. Wartangurnijangkarlu kanarlanyju kukunjawarnti manya ngampurrikanani. Nyanarti warrkam parla nyantukura. Walimpawarlany nganpayirlu kajalurnijangkarlu parla Ngarpuwu kanya miyiwarnti katintajangka nyantukurajangka. Yiji parla kanya Ngarpuwu yiningu Kayintu. Yarnta kanarlanyju nganpayirlu Yipullu layi kurajpinya kukunja wulyujinyangu jirajarti, nyanartila parla Ngarpuwu kanya yiji. Wali nyanya pinya Ngarpungu nyanartijarra yijijarra kuyijaa miyi. Nganpayiwu layiwarlanyku parla wirriyajarrinya Yipulku yijijangkawu. Yangka parla kuyi yinya, wirriyajarrinyala parla. Kanarlanyku Kayinku parla ngajirta wirriyajarrirla. Yarnta nyantukurawu yijiwu ngajirta parla wulyumanyjarla. Wali nganpayi nyanarti Kayin munta yakurrjarrinya, ngajirta wirriya ngunarla. Kulijarrinyala nganpayi nyanarti. Ngarpungu parla japirlyinya nganpayi, “Nganajangka man kulijarrinyajaa munta yakurrjarrinya.” Yarntarni parla marni Ngarpungu, “Puju man wulyu ngunawu, wirriya marnangu ngunawu. Puju man pinapinakarrilany kuli kujangkurrarni kujangkurrarni, wali kulingu manyanu kujikananku, nirnparnila nyanarti yakurr man ngunawu. Wali lamajarriwu man kulijangka. Rukalku mannyanta kulinga, wulyula man ngunawu.” Nyanartijangka marni parla Kayintu ngajanyankurawu, “Pa. Yankurli ruwa.” Wali yani pila ngurrangurni marri pakul. Pinyala nganpayirlu Kayintu ngajanyankura pirlawurra. Wali Ngarpungu parla japirlyinya, “Wanyjurla mangu ngaja nyuntukura.” Jangkumani manyanta nganpayirlu, “Ngajirta. Ngurrpa marnarla. Ngajirta marnarla ngaju ngampurrji ngajawu ngajukurawu. Kayan ngarna nira ngampurrikananta ngaja ngajukura. Wali Ngarpungu parla marni Kayinku janginyjurrarni jirrkirlparni, “Pinarri marnangu. Pinya man ngaja nyuntukura pirlawurra. Nyangany marna nungu nyuntukurajangka ngaja warrarni nguniny nguwanga.” Yarntarni parla marni Ngarpungu. “Wali kujikani manunyanu. Jurramanku marnanta minyartingurni ngurrangurni.” Wali yangkarti ngurra yangka ngajanyankura pinya, nyanayirla Ngarpungu jurramani nyanartijangka ngurrajangka. Yarntarni parla marni Ngarpungu, “Yarnta man pinya nyuntukura ngaja, karlarnanku man nguwa miyipurru katinpurru, jartila man kiyi tarrapunganku. Kayan ngartangu turtapungka miyi. Kitpunganku man wamarn wurnamipa. Ngurrawarlany ngurrawarlany man kitpunganku. Kayan ngan lama kirranyja.” Wali Kayintula pinapinakarrinyani nyapartukarra parla Ngarpungu marni, rayinjarrinyala pungukarrarla. Marnila parla Ngarpuwu, “Jarti marna pinapinakarrinyana nyapartujarriwu marna. Tanyjingaljinyangu pajan yinya. Ngurrangurnijaa nyuntungurni pajan jurramanku, nyapartujarriwu marna. Puju ngarna kujarti kitpunganta, kanarlanywarntirlu ngajalu nyaka, pungkala ngajalu.” Ngarpungula marni, “Ngajirta. Kayan ngantalu pungka. Yangka ngananguwurti manta pungku, tanyjingalpala parla ngunawu. Nyuntuwu mangu ngunawu yarpalmartamarta. Nyantuwu pungujangkawu marnarla ngunawu kuli purlkajinyangu.” Wali nyanartijangkarlu nganpayi nyanarti pa wirirrpinya Ngarpungu pinalkarrapurru pungukarrarla. Nginyjirrikanankula palu piyirnwarntirlu kanarlanywarntirlu liyimijarti. Kayan ngalu pungka. Yarnta pa Ngarpungu wirirrpinya. Wali Ngarpungurni yapyani nganpayi nyanarti kakarra, nyanayirla kakarra pa ngunangani. Wali kartujarti pa ngunangani nganpayi Kayin kakarra. Paja manya martarnani jukuwarnti nyantukurawarnti. Yarnta nyantukurajangka jukujangka kilakiwarnti palurla paja ngunangani. Yarnta jamirtiwarnti nyantukurajangka jukujangka pajawarlanyparni palurla ngunangani. Wali Yipju martarni yapawarlany kanarlany parri. Wirriyajarrinya, marni parlanyanu, “Yarnta paji pinya kanarlany yapa papajinyankurarlu, nyanartila paja yinya kanarlany parri Ngarpungu juku.” Wali juku pajajarti pila ngunangani Ratamjaa Yip, kurntaljaa walaku pilanya martarnani. Nyanartijangka nyantukurawarnti Ratamkurawarnti jukuwarnti palu nguja, martarnanila palunya yapa pajawarlanyparni. Martarnanila palunya yapajirnanyungu pajawarlanyparni. Nyanartijangka walimpa nganpayi Yinak nguja yapa pajajartiwarlanyparni. Nira pa yanani Ngarpukurarlal warntarrirlal nganpayi Yinak. Mapunikanani parla Ngarpuwu. Yarnta yanani purrkujinyangujarrinya. Wali wirlmarnila, Ngarpungula kanya pujurni karrkin jipirrarni. Yinakju manya martarnani jukuwarnti walakuwarntijaa kurntalwarnti yapajirnanyunguwarnti. Nyanartijangka walimpa Nawala nguja yapa pajajartiwarlanyparni. ");
INSERT INTO wmt_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","22","Nganpayi Nawa ngunangani wulyu. Pinapinakarrinyani pa Ngarpu. Yarnta nyantukura kartujaa walakuwarnti murrkurn kartujartiwarnti manya martarnani. Kanarlanywarnti palu yakurrwarntimiparni, ngajirta palu wulyu ngunangantarla. Kulijarrinyani palurlanyanu, punganila palunyanu pajangalmirri, yarnta palurlanyanu jirnapungani wapal. Wali Ngarpungu manya nyangani. Marni parlanyanu, “Nganapurru marnanya ngartakpani minyartiwarnti piyirnwarnti. Ngajirta pajilu wulyu nguna. Nyanartijangka marnanya nukarnini wajapungku.” Wali marni parla Ngarpungu Nawawu, “Nyangana marnanya nyanartiwarnti piyirnwarnti, yakurrmipa palu. Nyuntu marnanta kayan nyangana wulyu. Wali ngapa marnanyirrangu yipawu purlka, wajapungku marnanya nyanartiwarnti piyirnwarnti yakurrwarnti. Wali ngurti manurlanyanu purlka ngartakkarrku, wanjila manya yungku nyuntukurawarnti walakuwarnti mapirrirni, yarnta kartu nyuntukurajaa lamparrjiwarnti.” Yarnta parla Ngarpungu marni Nawawu, “Takurrpungku manunya kuyiwarnti nganapartu nganapartu. Kujarti manunya takurrpungku maljiwarntijaa ngamartiwarnti mapirrirni.” Nyanartikarrarni parla Ngarpungu jularnani pikawurra. Wali nyanartijangka Nawangu mapunikani Ngarpuwu, ngartakpanila ngurti ngapakarraji yurnturrungajirtarla pulparra. Nganpayirlu Nawangu manyanta mapunikani Ngarpunga. Pajajinyangu manya ngartakpani najiwarnti jirikiwarntiwujaa kuyiwarntiwu. Kanarlanywarntiwu mapirrirni manyanangu ngartakpani yarnta piyirnwarntiwu mapirrirni yukarnupurru. Japal nyanarti ngurti ngartakpani. Nyanartijangkarlu limirrijilinyparnila manyanta rukukani, ngajirta nganyanta ngapa pirriyanta kirlingirrirla. Nyanartirlamarra manyanta rukukanani. ");
INSERT INTO wmt_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","24","Wali Ngarpungu parla marni yangkakaji nyanarti ngurti pujumani. Marni parla, “Kaj. Takurryantalu walakuwarntijaa kartuwarnti mapirrirni. Yarnta nyuntukura kartu mapirrirni palu takurryanku. Yarnta kuyiwarnti yangkartiwarnti mapirrirni palu takurryanku. Minyarti marna yipawu ngapa purlka.” Wali takurrkanya manya Nawangu nukarnini nyantukura kartujaa nyantukurawarnti walakuwarnti kartujartiwarnti, yarnta kuyiwarnti mapirrirni. Wali takurryanila palu ngurtinga kaninykaniny. Wali nyanartikarrarnila Ngarpungu rukukani tuwa. Kayan ngarta ngananguwurti warijpantarla. Nyanartijangka ngapala manyanangurla pirriyani. Wantinyanila purlkajinyangu ngapa. Yarrparni purtkujirnani. Rukukani manya pamarrwarntijaa manawarnti nukarnini. Ngajirta kirlingirri ngunarla nguwajaa yalkiri. Yarr pa purtkujirnani ngapangu. Nyantu pa kaninykaniny kirrarnani nganpayi Nawa pulparr. Kuyijaa mayaru yarnta piyirnwarnti wartangurnijangkawarnti mapirrirni manya yurrkujirni ngapangu. Yarrpala ngujangurra, ngapamipajarrinya nukarnini. Kanarlanywarnti manya kunyungurla kapingu ngarnani. Kunyungurla manya marri rinkangani ngapangu. Kunyungurla manya kaninyparralparni yurrukujirnani. Wali wantinyani ngapa layi yakarn. Ngurti nyanarti yarr pa kankarralparni tuwumarnani, ngapangu kankarnikujirnani. Kujangkurrarni kujangkurrarni pa kankarnikujirnani ngapangu. Wali ngunangani palu rawa, yakarnwarnti kurriny kurriny kayan. ");
INSERT INTO wmt_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","22","Wali palu nyantuwarntimipa wanji ngunangani kaninykaniny ngurtinga. Wali kujartukarra palu ngunangani piyirnwarntijaa manawarntijaa nganapartu nganapartu manya pujukujirni ngapangu Ngarpukurarlu, tumaj palu yakurrmipa piyirnwarnti nguja, ngajirta palu Ngarpu pinakarrinyantarla. Nyanartijangkala manyanangu yiparni ngapa purlka Ngarpungu. Warpij manya ngarni, yarnta ngurra nyantuwarntikura pujumani. Wali nyanartikarra Ngarpungu yiparni walypa pulparrawurra luwarnupurru nguwa lukajangka, yarnta kaninykujiwu ngapa. Wali ngapa nyanartikarra kaninyjarrinyanila. Ngajirta partalurni pulparrajarrirla ngapa nyanarti. Marrki pa kaninyjarrinyani. Wali nyanartikarra yutantinyala ngurti nyanarti pamarra yininga Yararatta. Nyanartijangkarlu Nawangu wupunumkujirni winta, jirikila yiparni layi wangkarna. Wali jiriki nyanarti wamarnwamarn laparnani. Jarti parla manawu muwupungani yutantinyupurru. Ngurrparni yap yani. Ngajirta manyanta tikirrlapanyjarla Nawakarti nyanarti jiriki. Ngajirtarni parlipungkarla mana. Warrarni pa ngapapururni karrinyani mana. Wali yarntarni jirikiwarlany yiparni kumantawarlany yini parla purrjarti. Yap laparni. Yarntarni parla wamarn kitpungani parlipungupurru manawu. Jartijinyangu. Nyanartijangkala tikiyani manyanta Nawakarti. Wali nyantungu parla yawiyijarrinya, talmarni parla kurrapa yawiyirlu. Yutantinyurla manyanta tikirrpala takurrpinya. Wali kirrarnani palu kaninykaniny ngurrawarnti kurriny kurriny kurriny kayan. Yarntarni kayanparni jiriki yiparni purrjarti, yarntarni parla kitpungani. Wali parlipinyala jurtal. Warntarnila parla Nawawu warnjal, kanyala parla tikirr, yinyala parla Nawa. Wali nginyjirrikanila Nawangu ngapakura kaninyjarrinyujangka. Marni parlanyanu, “Kunyungurla parta ngapa kaninyjarrinya. Minyajiliny paji parlipungurla warntarni manangajangka warnjal.” Wali jiriki mapirri palu kirrarnani kaninykaniny ngurrawarnti kurriny kurriny kurriny kayan. Nyanartijangka yarntarni kayanparni jiriki tikirryiparni Nawangu. Wali nirnparnila yapyani, ngajirtarnila tikiyantarla. Kunyungurla ngurra partarlanyanu parlipinya nyanayirla kaniny. Wali nyanartijangka wupunumkujirnila winta Nawangu. Marnila, “Yu. Wali pulparrjarrinya pa nyanarti ngurra.” Pirmarningurra parla wintangurni. Wali yarntarni parla marni Ngarpungu, “Kaj. Yantalu minyartijangka ngurtijangka nyurrawarnti nukarnini. Wali ngurrakartila manta yanku. Juntumankula mantarlanyanu ngurra wulyunga.” Wali mapunikanila manyanta Nawangu. Jupantinyala palu nukarnini ngurtingurni. Nyanartijangka pamarrpala parla mungkurrpinya kuyiwu kamparnupurru Ngarpuwu parntimanupurru wirriyawurra. Wali kamparnila manya, Ngarpungula manya parntimani minyjurruminyjurru kankarnimarrangujangkarlu. Nyanartijangka wirriyajarrinyala parla Ngarpu. ");
INSERT INTO wmt_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","29","Wali yarntarni manyanangu Ngarpungu marni, “Pajajarriwu manta piyirnwarntijaa kuyiwarnti mapirrirni kujangkurrarni kujangkurrarni.” Yarntarni parla jularni Ngarpungu, “Wali marna kayankurrarni yiparni ngapa minyarti. Yarntawarlany ngajirta ngarna ngapa yipa kujartijiliny purlka piyirn wakaj ngarnujuwaljaa ngurra mapirrirni wajapungujuwal. Wali nira man ngunawu wulyu. Kujarti manunya martarnanku nyuntukurawarnti yapajirnanyunguwarntijaa kanarlanywarnti mapirrirni wartangurniwarlanyjangkawarnti mapirrirni. Wali marna mirtiny yutukani ngumurrurlal pinalkarrapurru. Yangka marna nyaku nyanarti mirtiny takiwurra, pinarrijarriwula marnarla nyangungalku. Yarntawarlany kayan ngarna ngapa purlka yipa kujartijiliny warpijkujirnujuwal.” Kujarti manya Ngarpungu jarlu lirrkarnpinya. Wali minyarti jutukparni Nawakura wangki. Wartangurni palu nguja jukuwarnti Nawakurawarnti murrkurn yiniwarnti Jiyim, Yam, Japit. Wali jukula palunya martarni pajawarlanyparni Nawakurawarntirlu walakuwarntirlu. ");
INSERT INTO wmt_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","32","Nyanartijangka paja palu piyirnwarnti ngunangani. Layi wangki palu marnani, ngajirta paja wangki. Wali pirntirrikarraji palu ngunangani, marnila palurlanyanu, “Pa. Ngartakkarrku parlipa mayaru juwal. Puju kayan ngarlipa mayaru ngartakkarra, ngurrujarrajarri ngarlipa. Kayantakalangu ngurra parlipa ngunanganku.” Wali pamarr palu mayaru ngartakkani juwaljinyangu yalkirirlurra palu ngartakkani kankarra marri. Yarnta palunyanu kajalkajalkujirnani kayanta ngunangupurru. Ngajirta palu ngurrujarrajarrinyantarla ngurrawarntirla wanyjurlajarra. Kayantarni palu ngunangani. Nyanartijangka Ngarpungu mayaru nyanya. Wali yakurrmarnila parla. Wangki palu layi marnani, wali Ngarpungu manya wangki ngurrujarrakujirnila. Wali nyanartijangka wangkiwarlany wangkiwarlany palu marnani pajajinyangu wangki. Pulykarra yanila palu ngurrawarlany ngurrawarlany, ngurrungurrujarrinyani palu. Mayaru nyanarti juwal yini parla Papurl. Nyanartijangka walimpawarlany purrku layi ngunangani yini parla Tira. Martarnani manya murrkurn paparlangujarti Ayiparanjaa kurrinywarlany nganpayi, ngaja pilarla Ayiparanku. Ayiparanju warntarni kartu rimpijangka kurrinyku pilanyanangu ngamajijarrawu. Wali warntarnila rimpi kartu yini Jayira. Ayiparanjaa Jayira pila warrarni ngunangani marlal jukungajirtajarti. Yarnta layi juku martarni wartangurnijangkarlu Ayiparankurarlu ngajangu yini parla Lat. Nganpayi nyanarti wartangurnijangka pirlajarrinya Latkura parla ngarpu. ");
INSERT INTO wmt_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","20","Kuttula parla Ayiparanku marni, “Wanyjarrku man nyuntukura ngarpujaa jarntuwarnti mapirri, yarnta ngurra nyuntukura wanyjarrku man. Yanku man ngurrawarlanykarti, tumaj marnanta kurajpinya. Pinayungku marnanta ngurra, wali wulyula man ngunawu. Pajajinyangu manya martawu kilakiwarntijaa jamirtiwarnti mapirri. Yapa jirnanyunguwarnti palu pajajarriwu kujangkurrarni kujangkurrarni, pajajinyangula palu ngunawu. Yangka ngananguwurti mangu yakurrmalku piyirnwarntirlu kanarlanywarntirlu, ngajungula marnarla yakurrmalku nyanartiwu piyirnku yakurrmarnujangkawu. Yarnta yangka ngananguwurti mangu wulyumalku kanarlanywarntirlu, ngajungula marnarla wulyumalkuwarlanyparni. Nyuntunga wartangurni manyanangu wirriya ngunawu. Yangka pajin mapunikarrku, wali piyirnwarnti kanarlanywarnti mapirrila palu ngunawu wartangurnijangka mapirri wirriya wapalkarra wanyjurlajarra.” Wali nyanartijangka mapunikanila Ayiparanju, yanila Kuttu parla jularni jarlu. Jakarnila palu kurlirra nyantukura kartujaa juku nyantukurajangka ngajajangka mapirri. Kanya manya Ayiparanju warrkammayinwarnti nyantukurawarntijaa manawarnti mapirri kuyiwarnti mapirri. Ngarpunyankura pa wanyjani Ayiparanju mayarurla yininga Yaranta. Yanila palu marri kurlirra ngurrawarlanykarti yinikarti Kayininkarti. Kirrarnani palu piyirnwarnti nyanartikarrajiwarnti Kayininkarrajiwarnti. Wali Ayiparanngurra palu pirriyani Kayininta, ngurrala palu juntumani. Nguja palu, wali. Ngarpungu parla marni Ayiparanku, “Minyarti ngurra marnanta yungku yini parla Kayinin pujurni. Ngunawu palu yapawarnti pajajinyangu yapajirnanyungu, nyuntukurajangkawarnti yapawarnti kilakiwarntijaa jamirtiwarnti mapirri palu ngunawu pujurni minyayirla ngurranga.” Wali Ayiparanju manya pamarrwarnti mungkurrpinya pinalkarrapurrujaa kajalkajalkujirnupurru Ngarpu. Nira palu kujarti pamarrwarnti mungkurrpungani kamparnupurru kuyipurru pinalkarrapurru. Nira palurla kujarti kamparnani pinalkarrapurru Ngarpuwu. Kamparni palu pirrkiwurra, Ngarpungula parntimani kujirirriny, wirriyajirrinyala Ngarpu. Yarntarni yani kulirrawarlany, pakulyani ngurrawarlanyjurra kayanparni ngurra yini parla Kayinin purlka japal. Yarntarni juntumani ngurra, yarntarni pamarr nyanayirla kayantakujirni Ngarpuwu kajalkajalkujirnupurru pinalkarrapurru. Ngarpuwu parla marnani Ayiparanju. Wali kirrarnani palu. Yarntarni jakarni nyanartijangka ngurrajangka, kulirrawarlany yani. Kuyiwarnti manya martarnani Ayiparanju. Kangani manya kukunjawarnti purlumanwarnti tangkiwarnti. Wali ngapa ngajirta wantirla. Yuka pujujarrinya manyanangu kuyiwarntiwu, yarnta miyi manyanangu pujujarrinya piyirnwarntiwu. Wali muwupungani parla jarti, yanila Yijipkarti kurlirra miyikarti. Yani palu Ayiparanjaa juku nyantukurajangka ngajajangkajaa kanarlanywarnti warrkammayinwarnti. Kartujarti pa yani Ayiparan Yijipkarti. Marnila parla Ayiparanju kartunyankurawu, “Nyuntu man jalungurrujinyangu wulyu. Marrupungka ngantalu minyartikarrajiwarntirlu. Marrupungurla ngantalu ngurru warntarnkarrakangka. Pungkala ngajalu ngaju nyuntungurni.” Rayinjarrinya parlanyanu Ayiparan. Lirrkarnpinya parla, marni parla kartunyankurawu, “Kuja man malku, julawu pajan rimpi marnangu. Julawu manyanangu piyirnwarntiwu, yangkala pajalu wanyjarrku wanji.” Nyanartijangka pirriyani palu Yijipja, wali juntumanila palu ngurra, kirrarnanila palu. Wali nganpayirlu purlkangu nyanartikarrajirlu nyanya marnin Ayiparankura kartu. Marrupinya, wurnarnila kanya nyantukurakarti ngurrakarti. Wali nyanartijangka yinya parla yiji Ayiparan purlkangu nyanartirlu Yijipkarrajirlu kukunjawarntijaa purlumanwarnti mapirri, yarnta kanarlanywarnti tangkiwarntijaa kamulwarnti mapirri. Yarnta piyirnwarnti mapirri nyantukurawarnti warrkammayin parla yinya. Warrkammalkula palunyanta Ayiparanja. Watanymani parla nukarnini. Wali mimijartijarrinyala purlka nyanarti Yijipkarraji maja yarnta nyantukurawarnti jarntuwarnti. Ngarpungu mimikujirni nganpayi nyanarti yarnta parla Ayiparankura kartu warntarni. Wali japirlyinya parla Ayiparan purlkangu Yijipkarrajirlu, “Nganajangka pajin jarlu jularla kartu mangu minyarti nyuntukura. Wapal pajan kajiyinya. Jularni pajin rimpi mangu nyuntukura minyarti.” Wali kartunyankura parla tikirryinya Ayiparan. Ngunyipinyala manya tikirr. Wali tikiyanila palu Ayiparanngurra kayili kirlingkurrarni nyanartikarti, yangka jarlu parla Ngarpuwu pamarr mungkurrpinya, nyanartikartirni tikiyani kirlingkurrarni. ");
INSERT INTO wmt_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","18","Wali pajajarti pila ngunangani wapirra. Paja pilanya martarnani piyirnwarnti warrkammayinwarntijaa kuyiwarnti mapirri kukunjawarntijaa tangkiwarntijaa purlumanuwarnti. Ngunangani pila pamarr purlkajarti. Ngurrujarra ngurrujarra pilanya martarnani kuyiwarntijaa warrkammayinwarnti Ayiparanjujaa Lattu. Ngampurrikanani palu warrkammayinwarntirlu kuyiwarnti kukunjawarntijaa purlumanuwarntijaa tangkiwarnti, yangkala pajajinyangu. Yuka palurlanyanu pujukujirnani pajangu. Nyanartijangka marrarnila palunyanu warrkammyinwarntirlu Ayiparankurawarntirlujaa Latkurawarntirlu. Yakurrmarni parla Ayiparanju kulipurru. Marni parla jukuwu ngajangajangkawu, “Ngajirta ngarlinyanu marra. Yarnta warrkammayinwarntirlu ngajirta ngalunyanu marra. Jarntuwarnti parlipa. Ngurrujarrajarriwu parli. Kangkula manunya nyuntungu kuyiwarntijaa piyirnwarnti nyuntukurawarnti, ngajungu marnanya ngajukurawarnti piyirnwarntijaa kuyiwarnti kangku. Nyuntujal, wanyjurla man yanku. Wangki pikakujirlanyanu.” Wali pinapinakarrinyani wanyjurla yanku. Mapunparni pinapinakarrinya. Nyanyangurra Lattu. Warrkarra nyanya. Nyanya mapunparni yuka purlka wurrkaljinyangu martuwarrarla kakarra. Karlarra nyanya yuka ngajirta yarr yarpal. Wali kakarrala kurajpinya martuwarrarla yuka purlkajinyangu, nyanartikartila yani. Kanya manya Lattu wurrkalkarti kuyiwarntijaa warrkammayinwarnti nyantukurawarnti. Juntumani ngurra marnparni mayarurla yininga Satamja. Kirrarnanila manyanangurla nyanartikarrajirla piyirnwarntirla. Nyanayirla palu kirrarnani Ngarpungajirtajartiwarnti. Ngarpu ngajirta palu mapunikarrarla, yakurr palu ngunangani. Ayiparan pa kirrarnani karlangjarti. Martarnani manya nyantukurawarnti warrkammayinwarnti yarnta kuyiwarnti mapirri. Ngunangani pila Kayininta ngurra purlka japal Kayinin. Kakarrangjartijaa karlangjarti pila ngunangani ngurrujarra. Nyanartijangka marni parla Ngarpungu Ayiparanku, “Warrpunyaku man ngurra kujangkurrajarra karlarrara, kakarrara, kurlirrara yarnta kayirrara. Yungkula marnanta ngurra minyarti. Yangka man pirlajarriwu, wali yapajirnanyungula palu martarnanku minyarti ngurra. Pajajinyangu palu ngunawu nyuntukurawarnti yapajirnanyunguwarnti. Kayan ngan kurajpungka, yarnta palu pajajinyangu. Wali warnjaljilinyparnila paja, kayan ngan kurajpungka, yarnta palu pajajinyangu. Wali kujarti palu ngunawu yapajirnanyungu.” Yarntarni Ngarpungu parla marni, “Kitpungku man minyayirla ngurrawarlany ngurrawarlany. Nyuntukura mangu minyarti ngurra, yungany marnanta.” ");
INSERT INTO wmt_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","24","Wali nyanartijangka kulipariwarnti piyirnwarnti palunyanangurla pirriyani kakarrangu. Kajalunypuwala palunyanangurla pirriyani piyirnwarntiwarlanyja Satamkarrajiwarntirla. Wali pinyala palunyanu. Kanarlanywarnti palunya pirlawurra pinya nyanartikarrajiwarnti Satamkarrajiwarnti, purpankanyala palunya kanarlanywarnti wurna. Kanya palunya warrkamjakujirnupurru Yarnta palunya ngurru kanya manawarntijaa pamarrwarntijaa kuyiwarnti mapirri. Kanya palunya ngurru. Yarnta nganpayi Lat mapirri palu kanya Ayiparankura juku. Yarntarni palu yani. Pirriyani palunyanangurla ngurrawarlanyja piyirnwarntiwarlanyja. Pinyala palunya, wurnala palunya purpankanya. Mapirri palunya kanya ngurrawarntijangka murrkurnjangka. Wali layila nganpayi manyanangurla lurrpjakarni, ranyjila yani, Ayiparankartila manyanta pirriyani wangkijarti. Kanya parla wangki. Jularnila parla Ayiparanku yangka palu Lat purpankanya. Kanya palu kulipariwarntirlu Lat. Wali partalurnila turtapinya nganpayi Ayiparan, jamurn pinakarrinya wangki nganpayirlu parla jularni. Wali nyantukurawarntiwula manyanangu pawumarni. Nyanartijangka wajilpinyala palunya kulipariwarnti. Pirriyanila palunyanangurla. Pinyala palunya nyanartiwarnti kulipariwarnti. Pirlawurra palunya pinya kanarlanywarnti, kanarlanywarnti palunya ngunyipinya yarr. Tikirrkanyala palunya piyirnwarnti kanarlanywarnti, jukunyankura mapirri, yarnta kuyiwarntijaa pamarrwarnti mapirri. Satamkarrajiwarntijaa ngurrawarlanyjangka mapirri manya kanya Ayiparanju tikirr. Wali kaparn palu tikirrjawurlu mitimkujirni nganpayi miyijarti yini parla Milkisatik, Ngarpukura nganpayi nyanarti. Mapunikani Ngarpu. Jarntuwarnti nyantukurawarnti manya kangani Ayiparanju. Tikirrkujirni manya nyanartikarti nganpayikarti. Wali Milkisatikju manya yinya miyi Ayiparanngurra. Yiji manya yinya, tumaj wurnajangka marrijangka lurrujarti palu pirriyani yarnta marranyanjarti. Marni parla Milkisatikju Ayiparanku, “Ngarpu mangu wirriya nguniny. Piyirnwarnti nyanartiwarnti kulipariwarnti manunya jurramani. Ngarpungu manta yinya maya jurramanupurru. Marlamani manta Ngarpungu. Mapunparni pa Ngarpu wulyujinyangu marlamanujuwal.” Wali yiji parla yungkarla Milkisatik Ayiparanju tumaj Ngarpukura nganpayi nyanarti Milkisatik. Yangkala manya ngurrungurrukujirni nyantukurawarnti pamarrwarntijaa manawarntijaa kuyiwarnti. Tukunga manya yutukani Ayiparanju pajajinyangu 10. Layiwarlanypala parla Ayiparanju yinya nganpayi nyanarti Ngarpukura. Yiji parla murtarni yinya. Wali tikiyanila pila Ayiparanjaa juku nyantukura ngurrakarti nyantujarrakurakarti, piyirnwarnti mapirri Satamjangkawarnti. Yiparni manya tikirr Satamkarti Ayiparanju. ");
INSERT INTO wmt_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","21","Wali nyanartila pa kirrarnani Ayiparan. Walimpa pa winkirrmarni Ngarpu Kut Ayiparanju. Ngarpungu parla marni winkirru, “Ngajirta ngan rayinjarri. Najungu marnanta ngampurrikarrku. Ngajungu marnanta kurraparla martalany.” Marni parla Ayiparanju, “Wulyumalany marnarla walakuwu. Ngajirta marna marta ngajukurajinyangu walaku. Juku pajan ngajukurajinyangu yungku.” Jangkumanila manyanta Ngarpungu, “Yu. Walaku man martawu nyuntukurajinyangu. Jayirarlu mangu martawu.” Yarntarni parla marni Ngarpungu, “Nyaku man kankarni yalkiri. Wirl palu pajajinyangu. Wali nyanartijilinypala palu ngunawu walakujangka nyuntukurajangka yapajirnanyungu wirljilinyparni. Kayan ngannya kurajpungka.” Wali mapunikanila parla Ayiparanju Ngarpuwu. Walaku parla yungku. Ngarpu parla wirriyala ngunangani Ayiparanku. Wulyujinyangu pa nyangani yakurrngajirta. Ngajirta pa nyakarla yakurr Ayiparankura. Wulyujinyangu nganpayi nyanarti. Kujarti pa nyangani Ngarpungu, tumaj parla nyantuwu mapunikananimipa Ayiparanju. ");
INSERT INTO wmt_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","16","Wali kartu Ayiparankura yini parla Jayira ngunangani yapangajirtajarti. Juku ngajirta martarla. Pinapinakarrinyani Jayirarlu, yapawu parla wulyumarnani. Jirnapungani parlanyanu, tumaj pa yapangajirtajarti. Pinapinakarrinyani, “Yarr marna pikawurti martawu yapa kanarlanykura ngamaji.” Wali marnila parla Jayirarlu purrkuwu ngumparnanyankurawu, “Juku marna ngajirta marta. Wulyumalany marnarla jukuwu. Kunyungurla paji kanarlanyju martawu marninwarlanyju. Pikala marna warntawu ngamajiwarlanykura. Yangkarti marnin warrkammayin ngajukura nguniny Yijipkarraji. Yukalku manpila, yapala martawu.” Wali mapunikani parla purrkungu kartunyankurawu, yangka parla marni yukalku manyanta Ayiparanja nyanarti marnin warrkammayin. Wali yukarnila manyanta ngurranga. Nyanartijangka yapajartijarrinya marnin nyanarti warrkammayin. Ngurrkujarrinyala yapangurni, yarringarnani manyanu. Marni parla Jayirawu, “Ngaju marna yapajartijarrinya.” Warralpunganila parla jingkirti nyanartiwu marninku yapangajirtajartiwu Jayirawu. Marnintu Jayirarlu parla marni Ayiparanku, “Nyanartirlu marnintu warrkammayintu paji jingkirti warralpungani.” Wali purrkungu parla marni, “Nyuntu manurla maja warrkammayinku. Nyuntungu nyapartukarra mankurla malku nyanartiwu marninku.” Nyanartijangka Jayirarlu marrarni marnin nyanarti yarnta pinya, nyanartila wurna yani kulijangka. Marri yani ngunku, ngapangala kirrarnani. Wali yinjilpala manyanta pirriyani Ngarpukura. Japirlyinya parla, “Wanyjurla man yanany.” Jangkumani manyanta marnintu, “Kulijangka marna yani, Jayirarlu paja marrarni, yanila marna.” Wali yinjillu parla lirrkarnpinya. Marni parla, “Tikiyanku man. Jayirakarti man yanku majakarti. Mapunikarrku manyanta Jayirarla. Warra man parri martawu Ayiparankura juku yini parla Yijmayil. Nyantu pa ngunawu kulijuwal parri nyanarti. Jukuwarnti manya martawu nyanartirlu. Yapajirnanyunguwarnti palu pajawarlanyparni ngunawu.” Wali tikiyanila marnin. Yinjillu pa tikirrkujirni. Nyanartijangka walimpa parringu manyanu tarlkujirnila Yijmayillu. Yangkartikarrarni yangka manyanu Yijmayillu tarlkujirni, nyanartikarrarni nguja Ayiparan purrkujinyangu yitilalwarnti 86. ");
INSERT INTO wmt_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","27","Nyanartijangka walimpa purrkujarrinyajinyangula Ayiparan yitilalwarnti 99. Nyanartikarra pirriyani manyanta Ngarpu Ayiparanja. Marni parla Ayiparanku, “Ngaju marna purlka kayan yini Kut. Ngajukurarlal man yanku wulyungal. Ngajirta ngan yakurrjarri.” Yarntarni parla marni Ngarpungu, “Mapunjinyangu mangulu ngunawu nyuntukurajangka yapajirnanyunguwarnti pajajinyangu. Kanarlanywarnti palunyanangu ngunawu purlkawarnti majawarnti. Wali yungku marnanta ngurra minyarti Kayinin pujurni. Yangka man pirlajarriwu, wali yapajirnanyunguwarntila palu ngunanganku minyayirla ngurranga Kayininta. Ngaju marnanyirrangu Ngarpu purlka. Wajilpungkula pajanta pujungurni nyuntungujaa wartangurnijangkawarntirlu mapirri yapajirnanyunguwarntirlu mapirri.” Wali nyanartikarra Ngarpungu pinya yinijartijarra yutukani Ayiparanjaa Jayira. Yarntarni parla marni Ayiparanku Ngarpungu, “Nyuntungujaa kanarlanywarntirlu mapirri yapajirnanyunguwarntirlu nganpayiwarntirlu mantanyanu nganpayikujiwu pinalkarrapurru. Nyaku mantanyanu nyurrawarntirlu, nginyjirrkarrkula manta kujarti, ngajukurawarnti manta. Pinapinakarrkula manta ngajukura wangki. Kayan ngantanyanta rukanyja. Yangka nganawurti piyirn nganpayikujirnungajirtajangka, ngajirta mangu nyuntukura jarntu, tumaj ngajukura wangki ngajirta paji mapunikarra. Yangka parri nguniny mirtily ngurtinga, nyanartikarrarni mantanya nganpayikujiwu. Tarlkujirnujangka yangka ngurrawarnti 8 nyanartikarrarni mantanya nganpayikujiwu.” Yarnta parla marni Ngarpungu Ayiparanku, “Kartungu nyuntukurarlujinyangu mangu martawu yapa parri walaku nyuntukurajinyangu. Wali nyantukurawarnti yapawarnti yapajirnanyunguwarnti palu pajawarlanyparni ngunawu.” Nyanartijangka warralpinyala Ayiparan. Pinapinakarrinyani, “Parnanyjaa purrku pajarra. Kayan ngajarra yapa marta. Ngaju marna purrkujinyangu jarlujangka yitilalwarnti 100, nyantula parnany jarlujangkawarlanyparni yitilalwarnti 90.” Wali japirlyinyala parla Ngarpu Ayiparanju, “Wayila yangkarti parri ngajukura ngamajiwarlanykura.” Jangkumanila manyanta Ngarpungu, “Yu. Yara pa nyantu Yijmayil. Ngampurrikarrku marna ngajungu. Ngarpu manyanangu ngunawu Yijmayil kanarlanywarntiwu wartangurnijangkawarntiwu yapajirnanyunguwarntiwu. Mapunparni mangu martawu nyuntukurarlu kartungu Jayirarlu nyuntukurajinyangu parri walaku. Jalarra mangu martawu, ngajirta yinki. Yini parla Asik. Yangka purlkajarriwu nganpayijarriwu Asik, wali ngajukurajinyangu paji ngunawu nganpayi nyanarti. Ngajukurarlal pa yananku. Ngaju marnarla ngunawu Ngarpu purlka. Yarnta kanarlany mapirri palu ngunawu nyantunga wartangurni yapajirnanyunguwarnti. Pajawarlanyparni palu ngunawu.” Wali nyanartikarra Ngarpungula wanyjani Ayiparan. Wali warntarnila manya Ayiparanju nganpayiwarntijaa nyantukurawarnti warrkammayinwarnti mapirri. Nganpayikujirni palunyanu. ");
INSERT INTO wmt_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","33","Wali yarntarni manyanta pirriyani Ngarpu ngurranga nyantukurarla Ayiparankurarla. Kirrarnani Ayiparan jininyarajarti kalukurla marnparni yarr. Wali nganpayiwarntirla palunyanta murrkurn pirriyani. Kulalu ngayirni marrijangka, minyangula parla Ngarpu pirriyani. Wali laparnila manyanangurla langkarni ngurrajangka nyantukurajangka. Purpani manya nyantukurakarti ngurrakarti. Jarntukujirni manya, miyila manya yinya kuyi mapirri. Marni manyanangu, “Ngalunga manta kirralku yumpaly, yarnta manta marringurni yani. Jurumanku mantanyanu minyayirla. Miyi marnanyirrangu warntawu. Ngarnungurla manta wurnala yanku.” “Yu,” marni palurla. “Jurumanku marnangulu. Kajalurni marnalu kirralku. Warntarnanpangu miyi.” Wali takurryani Ayiparan kalukurla, marnila parla kartunyankurawu, “Partalurni kampanya miyiwarnti.” Nyanartijangka Ayiparan laparni nyantukurakarti kuyikarti. Kuyiwarnti palu karrinyani purlumanwarnti. Layila pinya lamparnmarta jirajartijinyangu wulyu ngarnupurru. Kamparnila palu, yinyala manya nganpayiwarnti nyanartiwarnti kuyijaa miyi. Nyanartijangka japirlyinya palu Ayiparan, “Wanyjurla mangu kartu nyuntukura Jayira.” Jangkumani manyanangurla, “Kaninykaniny pa nguniny kalukurla.” Wali nyanartiwarntirla nganpayiwarntirla layi pa Ngarpu nganpayijiliny karrkinjarti. Marni parla Ngarpungu Ayiparanku, “Warra marnangu tikiyanku, jamurn purangu yangka lanylanymarnanku, nyanartikarra marnangu tikiyanku. Wali Jayirarlu mangu martawu yapa nyuntukurajinyangu parri walaku.” Wali ranyjingu pa pinakarrinyani Jayirarlu, yangka Ngarpungu parla marnani Ayiparanku parri martarnupurru. Wurrunga kirrarnani kalukurla kaninykaniny. Ngajirta palu nyakarla nganpayiwarntirlu. Wurrunga kirrarnani, nyanartila manya pinakarrinya wangki nyantungurni juku martarnupurru parri nyantukurajinyangu. Wali warralpinyala kaninykaniny ranyji yarr munta. Pinapinakarrinyani, “Ngajirta. Parnany marna ngaju. Kayan ngarna yapa marta, yarnta ngajukura ngumparna pa purrku kayan ngajarra yapa marta.” Wali marni parla Ayiparanku Ngarpungu nganpayirlu, “Nganajangka pa warralpinya Jayira. Ngajirta paji mapunikarrarla wangki, yangka marnarla jularni yapa martarnupurru. Mapunparni marnangu pirriyanku yangka marnangu jularni.” Wali Jayirarlu parla marni, “Ngajirta marnangu warralpungkarla.” Jirnapinyala manyanu Jayira. Ngarpungu parla marni jirrkirlparni, “Mapunparni man warralpinya.” Nyanartijangka turtapinya palu, wurnala palu yani. Ayiparanju manya muntukanya. Karrinyani manyanangurla kaparn. Wali marni parla Ngarpungu Ayiparanku, “Nyanartiwarnti piyirnwarnti palu yakurrjinyangu ngurrajarrajangka Satamjangkajaa Kumarajangka. Yanku marna nyangupurru. Puju palu yakurr, wali pungkula marnanya pujurni.” Ayiparanju manya pinapinakarrinyani jarntuwarnti nyantukurawarnti yangka palu Satamja ngunangani Latngurra, yangkala ngajirta nganya pungka Ngarpungu. Kunyungurla manya Ngarpungu pungkarla yakurrwarntijaa wulyuwarnti, yangkala manyanangu Ayiparanju purntukangani. Jarrmarnani parla Ngarpuwu. Lamakujirnani Ayiparanju. Marni parla Ngarpuwu, “Pungku nganunya pujurni wulyuwarnti mapirri. Kunyungurla palunyanangurla paja nguniny wulyuwarnti 50. Pungku nganunya pujurni wulyuwarnti mapirri. Purlka man wali. Pinarri mannyanangu. Nyuntungu mannya nyangany piyirn wulyuwarntijaa yakurrwarnti. Nyuntu mankurla pinarri. Nyuntu man wulyu.” Ngarpungu parla marni Ayiparanku, “Yu. Kayan ngarnanya pungka, yangkarti pajin jarrmarni.” Wali tikirrparni tikirrparni pa japirlyungani Ayiparanju Ngarpu. Walimpala jirna japirlyinya wartangurniwarlany, “Kunyungurla palunyanangurla wulyuwarnti nguniny murrkurn 10. Pungku nganunya pujurni wulyuwarnti mapirri.” Jangkumani manyanta Ngarpungu, “Yu. Kayan ngarnanya pungka, yangkarti pajin jarrmarni. Puju kayan ngarnanya parlipungka wulyuwarnti 10, nyanarti marnanya pungku yakurrwarnti nukarnini.” Wali yanila Ngarpu wurna, nyanartila Ayiparan ngurrakarti tikiyani nyantukurakarti karla wangkijangka. ");
INSERT INTO wmt_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","38","Wali nyanartijangka pila yani Ngarpukurajarra yinjiljarra kakarra Satamkarti karuwarrajarti. Pirriyani palunyanta nganpayirla Latta. Kanyala pinya ngurrakarti nyantukurakarti, miyila pinya yinya. Wali pukanyjajarti palu pirriyani nyanartiwarnti nganpayiwarnti Satamkarrajiwarnti nukarnini. Ngurranga Latkurarla palu warruyani, pajajinyangula karrinyani linti. Nyantuwarnti palu Latngurra kaninykaniny kirrarnani mayarurla. Papajanila palurla Latku, “Wanyjurla pila yangkartijarra nganpayijarra. Kartukujiwu marnalupinya. Yipapinya mirnu.” Piyirnwarntirlu palupinya marrupungani nganpayijarrawarlanyparni yinjiljarra. Ngurrpa palurla ngunangani yinjilku, kula pila piyirnjarrarni. Lattu manyanangu jarrmarni, “Ngajirta. Yakurr nyanarti. Minyartijarra piyirnjarra mantalupinya wanyjarrku. Ngajukurarla mayarurla pila ngunawu. Yungku marnanya ngajukurajarra kurntaljarra. Kangku mantalupinya.” Nyanartijangka ngajirta palupinya kangkarla kurntaljarra Latkurajarra. Wali palupilangu jutujarrinyani yinjiljarrawu kangkarla palupinya. Wali kulijarrinya palu nyanartiwarnti nganpayiwarnti. Nyanartijangka yinjiljarrarlu pila takurrkujirni nganpayi Lat kulipariwarntirlamarra mayarurla kaninykaniny, palkakartila pilanyanangurla yani langkarni nganpayiwarntikarti. Wali jankakujirnila pilanya yinjiljarrarlu. Wali jartila palu wampalmarnani kirlingirrirla takurryanupurru. Jatajatalananila palu. Nyanartijangkarlu yinjiljarrarlu pilarla marni Latku, “Minyarti mayaru pajarra turlkujiwu. Yakurr palu piyirnwarnti minyartiwarnti. Nyantuwarnti mapirri manya manyjiwu. Pujumanku manya warlungu. Wurna parlipa yanku yakurrngurni ngurrangurni minyartingurni. Jarntuwarnti mapirri mannya kangku.” Wali yanila pilangu lamparrnyankurajarrawu purpanupurru. “Yankurlipa minyartingurni ngurrangurni. Ngarpungu pa turlkujiwu minyarti ngurra.” Jarti pinya purpani nyantukurajarra lamparrjarra. Ngajirta pilarla mapunikarrarla. Lama pila kirrarni. Kumantajarrinya wali, rakarrarlarnila. Marni pilarla Latku yinjiljarrarlu, “Pa. Yankurlipa jalarrarni.” Ngajirta partalurni yantarla Lat, warrarni yinkirni kirrarnani. Nyanartijangka partalkujirni pilanya, ngarrpirtikanya pilanya Latjaa nyantukura kartujaa kurntaljarra nyantukurajarra. Ngarrpirtikanya pilanya mayarungurni. Marni pilanyanangu, “Partapartal lapalkurlipa. Ngajirta nganta wirlilkarri. Jirrkirl manta yanku pamarrkarti purlkakarti pirlajarrinyurlamarra.” Lattu pilangu marni, “Pamarr nyanarti pa marri. Kayan ngarna partalurni pirriyanta. Jarti ngarna yanta pamarrkarti. Minyartiwu marnarla wulyumalany mayaruwarlanyku kayiliwu. Marnpa pa nyanarti yanupurru. Yanku marna nyanartikarti mayarukarti.” Yinjiljarrarlu pilarla marni, “Wali man nyanartikarti yanku partalurni, ngajirta ngan yunta yanta. Partalurni man yanku.” Wali yani palu. Jamurn purangu turtapinya, wali pirriyani palu mayarurla nyanayirla. Nyanartijangka warlu wantinya kankarnumarrangu mayarujarrarla Satamjajaa Kumararla, Ngarpungu turlkujirni. Mayarujarra nyanartijarra pinya pujumani warlungu, yarnta lamparrjarra kurriny Latkurajarra, piyirnwarnti kanarlanywarnti mapirri, yarnta kuyiwarnti mapirri nganapartu nganapartu nyanartikarraji. Yukajaa mana mapirri manya manyjirni warlungu. Wali wartangurni manyanangurla yanani Latkura kartu. Nyantuwarnti palu kajalurni yanani. Kartu nyantukura jatparamanila. Wirlilkarrinyala. Wantinya manyanta jarlku, wajapinyala. Jarlkujarrinyala marnin nyanarti, pamarrjilinyjarrinyala. Wartangurni ngunangani jarlku lama. Ayiparan pa marri ngunangani nyantukurarla ngurranga, nyanganila warlu ngunyjurr manyjirnanujangka. ");
INSERT INTO wmt_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","18","Wali nyanartijangka nyantukurajangka ngurrajangka yani Ayiparan kurlirra. Kanya manya nyantukurawarnti warrkammayinwarnti mapirri, kuyiwarnti mapirri. Pujurni manya kanya. Pirriyani palu nyanayirla ngurranga, juntumanila palu ngurra. Ngajirta marri, yarr marnparni kaparn, Yijipngurni kaparn. Wali yarntarni manyanangu jularni nyanartikarrajiwarntiwu piyirnwarntiwu, “Minyarti paji rimpi.” Nganpayirlu nyanartikarrajirlu purlkangu pa Jayira nyanya. Warntarnkanyala nyantukurakarti ngurrakarti. Nyanartikarrarni Ngarpungu parla marni winkirru pukanyja, “Nyanarti parla nganpayiwarlanyku kartu. Warntarni mankurla ngurru. Nyanartingurni marninngurni marnanta pirlakujiwu, yarnta mankurla warntarni Ayiparankura kartu ngurru, nyanartila marnanta pirlakujiwu.” Winkirru manyanta jangkumani nganpayirlu purlkangu, “Ngajirta. Jularni pajipila kurrinyjurni Ayiparanjujaa Jayirarlu, rimpirlangu pilanyanu jularni rimpirlangu pila, nyanartila marna warntarnkanya ngajukurakarti ngurrakarti.” Ngarpungu parla marni yarntarni, “Yu. Pinarri marnangu. Nyanarti marnin man warntarnkanya ngurrpangu, nyanartila marnangu jarrmalany. Wali tikirryungkula mankurla Ayiparan nyanarti marnin.” Wali kumanta turtapinya, jularnila manyanangu piyirnwarntiwu nyantukurawarntiwu jarntuwarntiwu winkirrjangka pukanyja winkirrmarnani, rayinjarrinyala palu. Japirlyinyala parla Ayiparan purlkangu, “Nyapartujangkarlu pajan kajiyinya. Wapal man marni. Rimpi man jularni nyuntukura kartu.” Jangkumanila Ayiparanju, “Nyurrawarntirlu ngajirta manta mapunikarra Ngarpu, yangkala marnanyirrangu rayinkarrinya pungukarrarla. Pungka ngajanta pirlawurra marninngurni. Mapunparni nyanarti yarnta pajarra kurrinyjangka. Layi pajarrangu ngarpu kurrinyjangka ngamaji, rimpirlangu pajarra jarntujarra, yarnta marna kartukujirni rimpijangka.” Wali tikirryinya parla kartu nyanartirlu nganpayirlu. Nyanartijangka kurntayijarrinyala. Yinyala parla yiji Ayiparan purlkangu kurntayirlu. Pujurni parla yinya kuyiwarnti wanjiwarnti kukunjawarntijaa purlumanwarnti, piyirnwarnti warrkammayinwarnti mapirri parla yinya. Nyanartijangka Ayiparanju japirlyinya Ngarpu nganpayipurru, wanjila nguja nyanarti nganpayi purlka. ");
INSERT INTO wmt_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","34","Wali yangkartijangka yangka parla marni jarlu Ngarpungu, yinyala parla parri. Tarlkujirnila manyanu parringu. Jayirarlu parnanyju martarni nyantukurajinyangu walaku. Jamurn lanylanymarnani purangu, nyanartikarrarni yangkartirni parla jarlu jularni. Wirriyajarrinya marnin nyanarti Jayira, yapawu parla wirriyajarrinya, warralpinyala wirriya, yarnta parri nyanarti martarni parnanyju. Marni parlanyanu, “Wirriyakujirni paja Ngarpungu. Kanarlanywarnti mapirri palu wirriya ngunawu, warralpungkula palu wirriya.” Yini pa Ayiparanju yutukani Asik. Yangka warrarni mirtily ngunangani ngurtinga ngurrawarnti 8, wali nganpayikujirnila yangka parla jarlu jularni Ngarpungu Ayiparanku. Wali yangka parringu nyanartirlu wanyjani ngamarna, yangka purlkajarrinya kuyila ngarnani. Nyanartikarra palurla miyijaa kuyi ngarni purlka wirriyarlu. Pinya manya kuyiwarnti nyantukurawarnti Ayiparanju. Kamparnurla manya yinya, ngarnila palu pajangu wirriyarlu kuyijaa miyi. Nyanartijangka rijikarrinyani pila parrijarra. Jayirarlu pinya nyangani. Pinapinakarrinyani Jayirarlu, wulyumarnani parla parriwu nyantukurawu. Yangka Ayiparan pirlajarriwu, nyanartila manya pujurni martawu Asikju manawarntijaa kuyiwarnti mapirri pujurni. Warrkammayinwarnti piyirnwarnti mapirri manya martawu ngarpunyankurajangka. Wulyumarnani parla nyantukurarlu ngamajirlu Asikku. Pujurni manya martawu Asikju. Puju pila warrarni ngunawu ngamarlangu parrijaa marnin yangkarti warrkammayin, wali ngurrujarrakujiwula pilanya piyirnwarntijaa kuyiwarnti mapirri. Ngurrujarrala pilanya martawu. Jayirarlu parla wulyumarnani parriwu Asikku nyantungumiparni manya martarla. Pinapinakarrinyani pa Asikjumiparni manya martawu, parriwarlany pa marlalparni. Malykunyangani pa Jayirarlu parriwarlany Yijmayil pamarrwarntingurnijaa manawarntingurni. Ngajirta ngartanya marta nganawurti. Wali nyanartijangka Jayira yani manyanta Ayiparankarti. Marnila parla, “Ngunyipungku manpinya ngamarlangu, wurna pila yanku.” Ayiparan ngajirta wulyumanyjarla. Jayirarlu parla jularni ngunyipungupurru, ngamarlangu pinya ngunyipungkarla. Wali Ngarpungu parla marni Ayiparanku, “Wali manpinya yipawu. Ngampurrikarrku marna ngajungu parri nyanarti nyuntukura Yijmayil yarnta pa nyuntukura parri nyanarti. Jukuwarnti paja manya martawu yapajirnanyunguwarnti pajajinyangula palu ngunawu.” Nyanartijangka kumantajarti ngapajaa miyi pinya yinya ngamarlangu, wurnala pinya yiparni. Kitpungani pila, ngapala pilangu pujujarrinya. Ngalungala yutukani parri ngamajirlu, yawiyijarrinya parla parriwu. Ngajirta ngarta nyaka pirlajarrinyujangka. Nyantu pa ngaluwarlanyjala pakul kirrarnani. Wali yinjil manyanta pirriyani wangkijarti Ngarpukurajarti. Marni parla, “Ngajirta ngan yawiyijarri. Yara pa parri wanji ngunawu. Pinakarrinya marna lungujangka. Yara pa wanji ngunawu parri.” Nyanartijangka ngapala jila nyanya ngamajinyankurarlu. Purrakpurrakmarnani kaninymarrangu nguwajangka. Ngarpungu parla yinya. Wali warntarni ngapa, yinyala parla parri nyantukura ngapa, ngarnila parringu. Wali purlkajarrinyala Yijmayil, nganpayijarrinya. Kurlila pa ngunangani. Walimpa parlanyanu kartu warntarni Yijipjangka. ");
INSERT INTO wmt_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","24","Wali Ayiparanngurrarlu palu nira kuyi kamparnani pinalkarrapurru parntimanupurru. Ngarpungu pa parntimanku, wirriyajarriwula pa Ngarpu. Ngajirta palunya piyirn pungantarla kamparnupurru, kuyimipa palunya pungani kamparnanila palunya parntimanila Ngarpungu. Kanarlanywarnti palunya kamparnani pirrkiwurra, kanarlanywarnti palunya kamparnani pukarrwurra. Kujartikarra manyanangu nyantuwarntikura yurru. Wali Asik pa parri purlkajarrinya. Nyanartijangka Ngarpungu parla marni Ayiparanku. Tajjularni yini Ayiparan. Jangkumani Ayiparanju, “Minyayirla marna nguniny.” Ngarpungu parla marni, “Parri yangkarti man kangku pungupurru kamparnupurru, parntimankula marna wirriyawurra. Kayili man kangku pamarrkarti. Pinayungku marnanta pamarr, nyanayirla man pungku parri, kampawula man pirrkiwurra kuyijilinyparni.” Yarr pa Ayiparan kurlpinya, mapun ngarta mapunikarralany Ngarpu. Wali kumantajarti pa turtapinya Ayiparan rakarrarla. Tangki warntarni, tangkijaa piyirnjarra warrkammayinjarra mapirri. Yarnta parri nyantukura walaku. Warlu palu warntarni, karrpirni palu kangupurru. Kayilila palu yani pamarrkarti. Ngurrajarra kurriny palu yukarni kaparn, kumantawarlanyja palu yani. Wali nyanya nyanarti pamarr Ayiparanju. Wanyjanila pinya kurrinywarlany nganpayijarra warrkammayinjarra. Marni pilangu Ayiparanju, “Kirranyjapila minyayirla tangkijartijarra. Yanku pajarra jina. Kangku marna ngajukura parri Ngarpu kajalkajalkujirnupurru. Tikiyankula pajarra.” Nyanartijangka Ayiparanju manyanta warnturakujirni warluwarnti parringa, kanganila pa pamarrkarti warlu munga. Nyantungu Ayiparanju jarra kangani warlu tilijarti kurraparla. Yarnta nayip kangani Ayiparanju. Yanani pila wapirra pamarrkarti kankarni. Wurna pila parayanani wapirra. Japirlyinyala parla wurnangarni ngarpunyankura parringu, “Ngana parli kuyi pungku kamparnupurru Kutkura.” Nginyjirrikani pinya warlujaa nayip jirrkirl parringu nyanartirlu. Wali japirlyinyala parla ngarpunyankura, “Ngana parli pungku kuyi Ngarpupurru pinalkarrapurru.” Jangkumani manyanta Ayiparanju, “Ngarpungu parlinya yungku kuyi nyantungurni.” Wali pirriyanila pila yangkartirla pamarra, yangka Ngarpungu parla jularni jarlu. Ayiparanju pa mungkurrpinya pamarrwarnti, yutukanila warlu kankarnumarrangu pamarra mungkurrpungujangkarla. Nyanartijangka parri warntarni, karrpirnila parri, kankarnumarrangula warlunga yutukani parri, tujkujirni. Nyanartijangkarlu nayippala warntarni junganupurru. Jamurn jungantarla, yinjillula pa yini tajjularni. Wali lamajarrinyala Ayiparan. Yarntarni parla marni yinjillu Ngarpukurajangkarlu, “Wanyjarra parri nyanarti nyuntukura. Ngajirta ngan junganta. Pinarri marnangu. Mapunikarralany man Ngarpu mapunparni. Ngajirta pajan panypungkarla parripurru. Yinya pajan jirrkirlparni parri.” Wali nyanartijangka Ayiparanju nyanya kukunja malji larrkantinya mananga. Kurtamani manyanta parringa, kukunjala warntarni, nyanayirla yutukani kirlinga, yangka parri nguja warlunga kankarnumarrangu, nyanayirla yutukani kukunja Ayiparanju. Wali junganila kukunja nyanarti kamparnila pirrkiwurra, parntimanila Ngarpungu wirriyawurra. Yarntarni parla marni yinjillu Ayiparanku, “Mapunparni pajan yinya parri nyuntukurajinyangu layi man martarnani kayan, yangkala pajan yinya. Ngajirta pajan panypungkarla. Jirrkirlparni pajan yinya. Nyanartijangka marnanta wirriyakujiwu, yarnta marnanta ngampurrikarrku. Pajajinyangu manya martawu kilakiwarntijaa jamirtiwarnti mapirri. Yapajirnanyunguwarnti palu pajajarriwu kujangkurrarni kujangkurrarni pajajinyangula palu ngunawu nyuntunga wartangurni. Nyantuwarnti mapirri palu wirriya ngunawu yapajirnanyunguwarnti. Yarnta kanarlanywarnti mapirri palu wirriya ngunawu pujurni wanyjurlajarra wapalkarra, tumaj pajan mapunikarralany.” Nyanartijangka tikiyanila pila wapirra, Ayiparanjaa juku nyantukura. Yangkartijarrakarti purpankanya pilanya, jarlu pilanya wanyjani tangkijartijarra pila kaparn kirrarnani warrkammayinjarra. Tikirrjawurlu pilanya purpankanya nganpayijarrawarlany warrkammayinjarra. Tikiyanila palu ngurrakarti kurlila. Wali ngunanganila palu. Nyanartijangka pakulyani palu kayili yarr marnparni, ngajirta marri. Juntumani palu ngurra. ");
INSERT INTO wmt_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","20","Nyanartijangka Jayira pirlajarrinya kartunyankura parla Ayiparanku. Lungani parla ngumparnanyankura kartuwu nyantukurawu. Ngajirta palu turnmantarla kaniny nguwanga, yutukani palu najinga pamarra. ");
INSERT INTO wmt_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","67","Ayiparan pa purrkujarrinyajinyangu. Pinapinakarrinyani, “Wanyjurlajangka marnarla kartu warntawu Asikku.” Nganpayiwarlany parla jinjinyinya warrkammayin nganpayi. Kartu parla parlipungku Asikku, tumaj nyantu pa purrkujinyangu, kayan ngarta marri yanta. Wali marni parla Ayiparanju warrkammayinku, “Yanku man kayili marri ngajukurakarti jarntukarti, kartula mankurla purpanku Asikku. Ngajirta ngankurla warnta marnpajangka Kayininkarraji, yarnta palu Ngarpukurangajirtajarti. Jarntu manurla warntawu ngajukurajangka ngurrara.” Warrkammayintu parla marni, “Kunyungurla marnintu kayan ngaja wajilpungka. Marri parlanyanta. Kayan nganya jarntuwarnti wanyjarra.” Japirlyinyala parla Ayiparan warrkammayintu, “Kangku ngarna Asik nyanartikarti kayili nyuntukurakarti ngurrarakarti.” Marni parla Ayiparanju, “Ngajirta. Nyantukura ngurra parla minyarti Asikku. Minyayirla pa nira ngunanganku. Ngarpungu pa yinjil yipawu kajalurni junpungkula marnin nyanarti. Ngarpungu manta pinayungku, pirriyankula mannyanta nyantungarni. Yangka marnin kayan ngarta mirnu yanta, wanyjarrkula man. Ngajirta ngan kangka kayili Asik.” Jarrmarni parla Ayiparanju. Marni parla Ayiparanku warrkammayintu, “Kangkujal marna mirnu. Kayan ngarnangu kayili kangka walaku nyuntukura. Mapunparni marnarla kartu kangku mirnu.” Wali kamulwarnti paja manya warntarni nyanartirlu warrkammayintu, karrpirnila manya manawarnti nganapartu nganapartu yijipurru. Yiji manya yungurlakarrku jarntuwarnti Ayiparankurawarnti. Wali jakarnila kamuljarti kayili, kanya manya murrkurn nganpayiwarnti minili. Pirriyani palu kayili. Ngapangarnila palu lamajarrinya, kamulwarnti manya parntakujirni. Pinapinakarrinyani, nyanarti pa Ayiparanju parla jularnurlakani. Wali kirrarnanila palu ngapanga marnpa. Japkarra kirrarnani manyanangurla yangka palu marninwarnti ngapakarti yananku. Ngapa nyanarti wil. Nira palu warntarnani ngapa marninwarntirlu karuwarrawarlany karuwarrawarlany. Jarlu pa japirlyinya Ngarpu, wali junpinyala nyanarti marnin kartu parla Asikku. Wali nganpayirlu pinapinakarrinya, “Japirlyungku marnarla ngapapurru yungupurru. Puju paja yungku ngapa ngajujaa kamulwarnti mapirri, wali nyanarti nginyjirrikarrkula marna nyanarti nyantu.” Mapunparni pirriyani ngapakarti layi marnin yini parla Rupayika takurryanila, ngapala parlanyanu warntarni. Nganpayirlula japirlyinya, “Ngapa yungkaja.” Yinyala parla marnintu ngapa. Lurrujawurlu pa ngarni ngapa. Wali marni parla marnintu, “Yarnta marnanya kamulwarnti mapirri yungku. Warntawu marnanyanangu, purtkujiwu marnanyanangu.” Warntarnila ngapa purlka kamulwarntiwu manyanangu purtkujirnani manyanangu ngurtinga purlkanga. Nganpayirlu nyanartirlu nyangani marnin warrkammarnanujangka, “Kunyungurla partarla minyarti kartu kurajpinya Asikkura Kuttu. Minyarti marnin pa jangarra.” Nginyjirrikanila nyapartukarra parla warrkammayintu japirlyinya Ngarpu. Wali yijila parla yinya marnin kurraparlapurru mana tarrjakkujirnupurru. Nganpayirlu parla japirlyinya, “Wanyjarra mangu ngarpu nyuntukura. Yini takijulaji.” Wali jularnila parla marnintu ngarpujaa ngamaji, yarnta ngawiji. Nginyjirrikanila manya nganpayirlu jarlujangkawarnti palu nyanartiwarnti Ayiparankurawarnti jarntuwarnti. Nginyjirrikani parla Ayiparankura ngaja kaji nyanawurlu marnintu parla jularni. Kilaki nyantukura parla marninku minyartiwu. Wirriyajarrinyala nganpayi. Jamalkanyala Kut warrkammayintu. “Wulyu man nyuntu. Jirrkirl pajan kanya jarntukarti Ayiparankurakarti.” Yarntarni parla japirlyinya warrkammayintu marninku, “Yara ngarta. Yukalku marnalunyanta ngarpunga nyuntukurarla.” “Yu,” marnila parla. Wali laparnkanyala marnin nyantukurakarti ngurrakarti jarntuwarntikarti. Wanyjani manya ngapanga. Jularnila manyanangu ngarpunyankurawujaa kanarlanywarntiwu mapirri. Wali pinakarrinyala papanyankurarlu wangki mapirrirni, yarnta nyanya manyanta rimpinyankurarla kurraparla martarninyirra marnintu. Nyanartiwu papanyankura manyanangurla yani ngapakarti. Pirriyanila manyanta nganpayirla Ayiparankurarla warrkammayinta. Marni parla warrkammayinku, “Takurryanku man. Ngurra man yukalku. Yuka pa paja nguniny kamulwarntiwu manyanangu.” Rupayikakurarlu papajinyankurarlu manya yinya yuka kamulwarnti, yarnta nganpayi parla yinya miyi. Marni manyanangu nganpayirlu, “Warra marna ngalku. Wangkiliny marnanyirrangu julawu. Ayiparan pa wulyu nguniny. Kuttu pa ngampurrikarralany. Pajajinyangu manya martalany kuyiwarntijaa warrkammayinwarnti piyirnwarnti, yarnta pamarrwarnti mapirri. Paja manya martalany. Yarnta layi walaku martalany nyantukurajinyangu. Marulu parla nyantukurajinyangu kayanmipa yini parla Asik.” Yarntarni manyanangu marni, “Yiparni paja Ayiparanju. Kartu minyartijangka marnarla warntawu nganpayiwu Asikku, kangkula marna kurlirra. Ngajirta parla Ayiparanju wulyumanyja kartu warntarnuwu Kayininkarraji. Wulyumalany parla minyartijangka ngurrarajangka parla warntawu kartu walakunyankurawu. Ayiparanju parla yakurrmalany ngurrawarlanyjangka. Kayan ngartarla warnta kartu Asikku. Wali mapunparni marna parlipinya minyayirla marnin layi nyurrawarntikurajangka jarntu. Kuttu paja pinayinya.” Japirlyinyala manya, “Wayila. Kangku ngarna.” Wali jangkumanila palu nganpayi, “Yu. Kayan ngarnalu wirtinyikarra marnin. Ngarpungu manta pinayinya, kangkujal man Asikkarti.” Nganpayi Ayiparankura warrkammayin wirriyajarrinyala, yinyala manya kamuljangkawarnti manawarnti paja. Yiji manya yinya Ayiparankura jarlu manyanangu yiparni, tumaj kartu nyanartijangka warntarni. Nyanartijangka ngarnila palu miyi japa wangkijangkarlu. Ngarni palu miyi. Nyanartijangka ngurrala palu yukarni layi. Kumanta wurnapurru manya japirlyinya. Wurna palu yantarla. Jarntuwarntirlu palu lamakujirla warramarta ngunarla marnin Rupayika ngurrawarnti paja. Marnila manyanangu nganpayirlu, “Kayan ngarna nguna. Partalurni marna yanku.” Wali marninpala palu japirlyinya. “Puju man wirriya nguniny, wajilpungkula man.” Wirriyala ngunangani marnin yanupurru. Wali yanila palu kurlirra. Ayiparankarti palunyanta, marnin Rupayika mapirri. Marninwarnti murrkurn palu yani, minili manya kanya murrkurnwarlany marnintu Asikkurarlu kartungu. Walimpa palu pirriyani, yanani palu, kaparnpala palu parlipinya nganpayi Asik ngurrangarni marnpa. Nyanya palu Asik. Japirlyinya parla marnintu nganpayi Ayiparankura warrkammayin, “Ngana nganpayi minyarti yanana wurna.” Jularnila parla nganpayirlu, “Ngajirta. Nyanarti pa nganpayi Asik.” Wali lamajarrinyala palu, jularnila parla nganpayirlu Ayiparankurarlu warrkammayintu wurnajangkajaa kartu purpanujangka. Kartu parla nyantuwu Asikku. Nyanartijangka Asikju kanya marnin nyanarti kartunyankura ngurrakarti nyantukurakarti. Wali nyanarti kartu parlanyanu warntarni, ngurrangala pila ngunangani. Wulyumarnani parla kartunyankurawu Asikju. ");
INSERT INTO wmt_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","34","Wali nyanartijangkarlu Ayiparanju kartuwarlany parlanyanu warntarni. Marnintu nyanartirlu manya martarni jukuwarnti murrkurnwarlanyparni Ayiparankura yapajirnanyunguwarnti. Asik pa jarlu nganpayijarrinya, kartujartila ngunangani. Nyanartijangka Ayiparan purrkujinyangujarrinya, nyanartila pirlajarrinya. Yutukanila palu kayantarni nyantu karrkin layingarni najinga yangkartirla jarlu palu yutukani Jayira, nyanayirlarni layingarnila palu yutukani Ayiparan karrkin nyantukura. Ngujala pila layingarni pamarra najinga. Kayininta pa kirrarnani nganpayi kartujarti Asik. Kartu parla yini Rupayika. Yapangajirta pila kirrarnani. Wulyumarnani pilarla yapawu martarnupurru. Warrarni pila ngajirta yapajartijarrirla. Wali Asikju parla japirlyinya Ngarpu. Nyanartijangka yapajartijarrinya marnin yangkarti Rupayika. Yapajarra kurriny pinya martarni kaninykaniny. Ngungkupunganila manyanu Rupayikarlu. Riyimarnani pilanyanta muntanga kaninykaniny yapajarra. Wirrptarrangani pilanyanu ngamajirla muntanga. Marni parlanyanu, “Ngana partajirla muntanga riyimarnana.” Nyanartijangka Ngarpu parla japirlyinya Rupayikarlu. Wali nyanartijangka Ngarpungu parla marni, “Kurriny mangupilarla nguniny parrijarra. Yangka manpinya martawu, wartangurnijangka parlanyanta ngunawu tanyji majajilinyparni. Yangka pila walimpa purlkajarriwu nganpayijarriwu, kajalkajaljangkarlu manyanta mapunikananku ngajanyankurarla wartangurnijangkarla. Nyanartijangka ngurrujarrarni palu ngunawu nyantujarrakurawarnti yapajirnanyunguwarnti. Ngajirta ngartalu ngurranga layinga nguna.” Wali kujarti pilangu Ngarpungu taki jularni. Wali mapunparni pinya martarni walakujarra kurriny ngamajirlu. Yangka pilangu jamurnjamurnjarrinyani palkangajarrinyupurru ngamajingurni, parriwarlany pa tarrpartarni luku wartangurnijangkarlu. Parri kajalurnijangka pila yini yutukani Yijuwu. Yijuwu palu jularnani ngirljarti nyantukurajawurlu wangkijawurlu. Nyantu pa ralmipa, yarnta karrkin ngirljarti. Wali parriwarlany palkangawantinya wartangurni. Yinila pila yutukani Jayikap. Walimpa pila purlkajarrinya nganpayijarrinya. Layiwarlany pa ruwa kitpungani yini parla Yijuwu. Pungani manya kuyi ruwangu. Kanarlany nganpayi Jayikap lamamipa kirrarnani. Ngajirta pa ruwa yanantarla. Nira manya nanikutwarnti ngampurrikanani. Wali Rupayikarlu parla Jayikapku wulyumarnani ngamajinyankurarlu. Yarnta Asikju parla Yijuwu wulyumarnani ruwajuwalku tumaj parla Asikju wulyumarnani kuyiwumipa ngarnanuwu. Wali Yijuwu ruwa yani kuyingal. Nyanartijangka yumpalyjarrinyala tikirrjarti ruwajangka. Ruwapurru manyanu jarti kurlpinya kuyingal yanupurru. Manyjarrjinyangu manyanu ngungkupinya. Nyanartijangkala manyanta ngajanyankurarla pirriyani linti marranyanjarti miyipurru yungupurru. Jayikapju parlanyanu miyi kamparnani. Nyanartijangka ngarntikanyala manyanta ngajanyankurarla miyi yungupurru. Marni parla, “Miyi yungkaja, marranyan marna.” Wali Jayikapju parla yirrarnmarni. Marni parla, “Ngajirta. Kayan ngarnanta yungka. Yarnta puju marnangu nyuntuwu majajarriwu, wali nyanarti miyila marnanta yungku. Julaji. Ngaju marnangu maja ngunawu. Puju pajin julawu, wali miyila marnanta yungku.” Wali Yijuwu parla papaji. Maja parla ngunangantarla Jayikapku. Kayan ngartarla japirlyungkarla Jayikapju nyanartipurru. Yijuwurlula parla kujarti marni, “Wali pajin ngunawu maja, miyiwurti pajan yungku. Ngaju marna marranyan, ngunangurla ngarna pirlajarri.” Wali nyanartijangka Jayikapju parla marni, “Mapun ngarnangu ngunawu maja papajijiliny wartangurnijangka.” Yijuwurlula parla marni, “Wali pajin ngunawu papajijiliny, miyiwurti pajan yungku. Maja pajin ngunawu.” Jamulu parla yarr marni. Wali yinyala parla miyi. Ngarnungurla yanila Yijuwu. ");
INSERT INTO wmt_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","35","Wali nyanartijangka Yijuwu karrayilijarrinya yangkala parlanyanu kartujarra kurriny warntarni Kayininkarrajijarra. Asikjaa Rupayika ngajirta pilangulu wirriya ngunarla Yijuwukurajarrawu kartunyankurajarrawu. Nyantujarra pila ngurrawarlanyjangka. Ngajirta pila jarntujarra. ");
INSERT INTO wmt_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","46","Walimpawarlany Asik purrkujinyangujarrinya jankajartijarrinya. Nyanartijangkala parla wangki walakunyankurawu yiparni Yijuwu nyantukarti yanupurru. Pirriyanila manyanta Yijuwu. Marnila parla Asikju, “Ngaju marna purrkujinyangu jamurnparni paji kutajarrilany pirlajarrinyupurru. Kuyi pungkaji. Jirnal warntarlanyanu, ruwala man yanku. Kuyi pajin lanku wulyujinyangu. Kamparnurla pajin kangku pukarr, ngarnturijartila marna ngalku. Nyanartijangka marnangurla Ngarpu japirlyungku, nyuntula manyanangu maja ngunanganku kajalkajal ngurrarawujaa piyirnku warrkammayinkujaa ngajajipurruwu mapirrirni.” Wali Rupayika pa karrinyani wuta. Pinakarrinyani yangka parla marnani Asikju Yijuwu walakunyankurawu. Nyanartijangkala Yijuwu pa yap yani ruwa. Wali nyanartijangka Rupayikarlu parla kanya wangki Jayikapku. Marnila parla, “Kujarti marna pinakarrinyani Asikkura wangki. Yiparni Yijuwu. Kuyi parla pungku, nyanartijangka Ngarpula parlanyanta japirlyungku kajalkajalkujirnupurru Yijuwu.” Wali jinjinyinyala parla Rupayikarlu Jayikap. “Kuyi pajin pungku. Ngarpujipurruwula marnarla kampawu wulyu ngarnturijarti yangka parla wulyumalany. Nyanartijangkala manurla kangku. Kajiyungku manurla, kula man nyuntu Yijuwurni nyanartilankula manta. Nyanartijangkala mangurla nyuntuwurni Ngarpu japirlyungku Asikju majakujirnupurru. Wali pungkaji kurriny nanikutjarra jirajartijarra. Kangkula pajin mirnu kamparnupurru.” Jayikapju parla marni ngamajinyankurawu, “Ngajirta, ngaju marna ralngajirtajarti. Yijuwu pa raljarti. Ngarpungu ngaja palymanta. Nginyjirrikanurla ngaji jula, ‘Nyuntu man Jayikap.’ Kujarti ngaji manyja. Yarnta ngaji yakurrmanyja. Nyanartijangka kayan ngajirla Ngarpu japirlyungka majakujirnupurru. Kunyungurla ngajirla japirlyungka pungupurru pirla.” Wali Rupayikarlu parla marni, “Yarrwurti pajan mapunikarrku, kuyila pajin pungku. Ngajirta ngankurla Kutku rayinjarri jamulu. Ngaju paja ngirtilykarra julawu Kuttu kajiyungujuwal.” Wali Jayikapju parla pinya nanikutjarra. Kanguyinyala parla Rupayika. Kamparnila parla Asikku pukarrwurra. Nyanartijangka kuluwujpala warntarni Yijuwukura, yinyala parla Jayikap. Jayikapju manyanu yutukani kuluwujwarlany ngarnturimipa. Kajiyungku parla Asik. Nyanartijangka Rupayikarlu warntarni nanikutkura partu. Yutukanila manyanta palpungaljaa kurrapajarrarlal, Yijuwujilinyjarrinyala Jayikap. Nyanartijangka kanyala parla Jayikapju kuyijaa miyi ngarpunyankurawu. Marni parla, “Pirriyani marnangu ngarpu. Kuyijaa miyi marnangu pirrikanya.” Asikju parla marni, “Ngana man nyuntu. Yijuwu ngan.” “Yu, ngajujal marna Yijuwu. Kuyi marnangu kanya. Turtangurla man ngalku. Nyanartijangkarlu Ngarpula pajinurla japirlyungku majakujirnupurru.” Nyantungula parla marni ngarpunyankurarlu, “Partalurni ngan pirriyani.” “Yu, partalurnijal marna pirriyani. Ngarpungu nyuntukurarlu paja marlamani purlkangu, yangka man japirlyungany nira kankarnijangka. Partalurnila marna kuyi parlipinya.” Asikju parla marni, “Mirnu yantajirla. Palymanku marnanta. Nyuntu ngan Yijuwu raljarti.” Wali marnpajarrinya manyanta, palymanila kurrapajarra ralku parla. Marni parla Jayikapku, “Minyarti ral marna palymanana Yijuwukurajiliny, yarnta marnanta pinakarrilany lin Jayikapjiliny. Mapun ngan nyuntu Yijuwu.” “Yu,” marni parla, “Ngajujal marna Yijuwu mapun.” Wali Asikju parla marni, “Yungkaja kuyi. Ngalkuliny marna kuyijaa miyi nyanartijangkarlu marnangurla japirlyungku Ngarpu.” Wali yinyala parla kuyijaa miyi, ngapa wayin mapirri. Ngarnila. Nyanartijangka parla yarntarni marni, “Mirnu yarnani. Lawukarrku pajan.” Yanila manyanta Jayikap, lawukanila. Wali parntimani manyanta Yijuwukura kuluwuj. Nginyjirrikanila Asikju, marni parlanyanu, “Ya wali pa. Yijuwu pa kunyungurla minyarti.” Wali nyanartijangka Asik marni, “Ruwajangka marnajin walaku parntimanana ngarnturijarti wulyujinyangu.” Nyanartijangka Ngarpu parlanyanta Jayikap japirlyungani majakujirnupurru. Marni parla, “Ngarpu, purlka ngapa manurla yipawu minyartiwu walakuwu ngajukurawu. Manawarntila palurla turtapungku. Pajakujiwula manurla miyi manangajangka, wanykurrmalku palurla. Yarnta pajin majakujiwu walaku ngajukura. Maja manyanangu ngunawu piyirnwarntiwu nukarniwu, jarntuwarntiwu mapirrirni. Yangka ngananguwurti parla yakurrmalku piyirntu kanarlanyju wali nyuntungu manurla yakurrmalku nyanartiwu piyirnku yakurrmarnujangkawu. Yarnta yangka ngananguwurti parla wulyumalku piyirntu kanarlanyju, nyuntungula manurla wulyumalkuwarlanyparni.” Wali nyanartijangka yanila Jayikap ngarpunyankurajangka. Wali Yijuwula pirriyani wartangurni ruwajangka kuyijarti wanykurrjarti. Nyanartijangka kamparnila parla ngarpunyankurawu kuyi nyanarti. Kamparnurla parla kanya kuyi pukarr, yinyala parla. Marnila parla, “Minyarti marnanta yungana yangka pajan jarlu yiparni ruwa kuyi pungupurru. Minyartijal kuyi nganyja. Nyanartijangka Ngarpula pajinurla japirlyungku majakujirnupurru.” Wali Asik parla purrpurrmarni. Marni parla, “Ngana man nyuntu.” “Ngaju marna Yijuwu walaku nyuntukura kajalurnijangka.” Nyanartijangka pilpilmarni Asik karrarta. Marnila parla, “Nganangu paja yangkarti kuyi yinya kajalurn. Kunyungurla kanarlanyju paja yinya. Wali marna ngarni, nyanartijangka marnarla japirlyinya Ngarpu majakujirnupurru. Kayan ngarna yarntarni Ngarpu japirlyungka nyuntuwu majakujirnupurru.” Wali Yijuwurlu parla ngarpunyankurawu nginarrmarni kurturru. Marni parla, “Ngaju mapirrirni pajinurla japirlyungku Ngarpu.” “Ngajirta. Ngajajpurru paji jarlu pirriyani. Kajiyinya paja nyanartila marnarlanyanta Ngarpu japirlyinya. Nyantu manyirrangu maja ngunawu.” Yijuwurlu parla marni, “Ngaju paja jarlu kaninykujirni Jayikapju. Jalarra manta kajiyinya nyuntu jirnajangkarlu, nyanartila manurlanyanta Ngarpu japirlyinya majakujirnupurru. Kala ngaju, kajalurnijangka, japirlyungkajirla ngarpu jalarrarni.” Asikju parla marni, “Jarlu marnangu majakujirni Jayikap. Jarntuwarnti palurla warrkammayinjarrinya, nyantula manyanangu maja ngunawu. Jarlu marnarla miyi pikakujirni katintajangka. Nyuntu kayan ngarnanta yungka wartangurnijangka. Marlal marnangurla.” Yijuwurlu manyanta jutungu ngarntimarnani, “Ngajuwu japirlyungkajirla.” Kujarti parla marnani. Nyanartijangka lunganila. Asikjula parla lirrkanpungani Yijuwu, “Ngarpungu kayan nganta yungka ngapa. Miyi mapirrirni katintajangka kayan ngangu turtangka. Jarlu marnarlanyanta walakuwarlanyku japirlyinya pikakujirnupurru Ngarpu. Yarnta man ngunawu kulipari pungujuwal. Nyuntu manurla ngunawu warrkammayin ngajajpurruwu. Nyantu mangu ngunawu kajalkajal wartangurnijangka. Walimpawarlany manpilanyanu ngurrujarrakujiwu rantangajarriwu manurlanyanta. Wanyjarrku man nyanarti ngajajpurru.” Kujartikarra parla marnani Yijuwu ngarpunyankurarlu. Nyanartijangka Yijuwu parla Jayikapku kulijarrinyajinyangu kaninykaniny munta, tumaj pa nyantu majakujirni wartangurnijangka ngarpunyankurarlu nyantujarrakurarlu. Wali pikakujirni parlanyanta Jayikapku pungupurru pirla. Walimpa Jayikap pa Yijuwurlu pungku yangka ngarpunyankuraliny pirlajarriwu. Wali piyirnwarntirlu palurla Rupayikawu jularni pikakujirnujangka wangki Yijuwukura. Nyanartijangka parla jularnani Jayikapku, “Papaji mangurla kulijarti kirrarnana. Pungku manta. Julawu marnangu wurnapurru. Yanku man minyartingurni ngurrangurni kayili. Kirralku manyanta kakajpurrurla ngajukurarla papajirla Layipanta. Wali rawa manyanta kirrarnanku kitangarni mangu papajijpurru ngaru kirtilyjarriwu. Walimpa marnangu ngajungurni piyirn yipawu purpanupurru yangka mangu minyartiliny yarajarriwu. Puju ngan minyayirla kirrarnanta, wali pungka nganta papajijpurrurlu pirla. Kanarlanywarntirlu ngartalu purntumanta. Pungkarla ngartalu nyantu. Ngajula ngarna jukungajirtajarti kirrarnanta.” Kujarti parla marnani Rupayikarlu walakunyankurawu Jayikapku. Wali nyanartijangka marni parla Asikku ngumparnanyankurawu Rupayikarlu kujartikarra, “Yakurrmalany marnapilangu Yijuwukurajarrawu kartunyankurajarrawu. Puju pa Jayikapju warntawu kartu minyartikarraji Yijuwujilinyju, wali nyanarti, wurnala marnanyanangurla yanku ngurrawarlanykarti. Yakurrmalany marnarla warntarnuwu kartu minyartikarraji.” ");
INSERT INTO wmt_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","22","Nyanartijangka Asikju wangki yiparni Jayikap purpanupurru. Marnila parla Asikju, “Ngajirta ngan warnta kartu minyartikarraji. Kayili man yanku jarungkurra. Warntawu man nyuntukurajangka kakakurajangka kartu. Wali nyanartijangka Ngarpungu manypinya wirriyakujiwu. Kayanparnila manpilarla ngunawu. Yapawarnti manpilanya martarnanku paja. Yapajirnanyunguwarnti palu pajajarriwu kujangkurrarni kujangkurrarni. Pajajinyangurla palu ngunawu. Ngarpungu manyirrangu wulyumalku nyuntuwujaa yapajirnanyunguwarntiwu. Mapirriwurni manyanangu wulyumalkuwarlanyparni Ngarpungu. Minyarti ngurrara parla yinya jarlu nyuntukura kilaki Ayiparan. Wali tikiyanungurla manta martarnanku nyurrawarntirlu nirnparni. Wali marnangu jularni. Jalarra man wurna yanku kayili.” Wali yanila Jayikap kayili. Wartangurn palurla Yijuwu jularni Jayikap kayili yanujangka, kartu parlanyanu warntawu. Purayimarnangurla parla Asikju yiparni. Kujarti palurla jularni Yijuwu. Wali Yijuwurlu parlanyanu marni, “Kunyungurla Ngarpungu ngajukurarlu parla marninku wulyumalany marrijangkawu kartu warntarnuwu jarntuwu. Ngajirta parla wulyumanyja minyartikarrajiwu.” Wali yanila manyanta nganpayikarti Yijmayilkarti, walakuwarlany parla Ayiparanku. Ngarpuwarlany pilangu Yijuwujaa Jayikapku. Wali yinyala parla Jayikap Yijmayillu kartuwarlany kurntal nyantukura. Wali Jayikap pa jarlu yani kayili. Nyanartijangka kaparnpala ngurra juntumani, yukarnila. Jurluwu parlanyanu yutukani pamarr pila, yukarnanila manyan pukanyja. Nyanya manya yinjilwarnti Ngarpukurawarnti. Jarrnga manyanangurla ngujangurra nguwangurnijaa yalkirirlurra. Yirrawarlany palu kankarral parayanani, yirrawarlany palu kaninyparral turtuyanani. Nyanartijangka Ngarpula manyanta karrinyani. Jayikapkula parla marni, “Ngaju marna purlka Kut. Ngaju marnapilangu purlka Ayiparankujaa Asikku. Yungku marnanya minyarti ngurra yangka man yukarnana. Yungku marnanya nukarnini jirnajangkawarnti mapirrirni. Pajajarriwula palu pingajilinyparni. Kujangkurrarni kujangkurrarni palu ngunawu. Pinakarri. Ngajirta nganyanta rukanyja ngajukurarla wangkinga. Warrarni marnangurla ngunawu, yangka man wanyjurlawurti yanku. Ngajungu mapirrirni marnanta ngampurrikananku. Walimpa marnanta tikirrkangku minyartikarti ngurrarakarti Kayininkarti.” Wali warrarni pukanyja kaparnkaparn parnkijarrinya Jayikap. Rayintu parlanyanu marni, “Ngarpu pa kunyungurla nguniny minyayirla mapunparni. Ngurrpangu marna ngurra juntumani minyayirla manyan yukarnupurru. Ngajirta marnarla pinarri ngunangantarla Ngarpuwu. Minyakujala parla nyantukura ngurra. Kunyungurla minyayirlarni parlipa parayanku yapinkarti kankarral.” Wali kumantala turtapinya, warntarni pamarr yangkarti pila kanyjirnujangka. Warntarnurla kirrarnukujirnila. Marnila parlanyanu, “Minyarti pamarr marna yutukarralany pinalkarrarlu, tumaj marna Ngarpu nyanya minyayirla karrinyjangka.” Nyanartijangka ayilpala manyanta purtkujirni pamarra. Yinila yutukani ngurra Pajil. Tumaj Ngarpu nyanya nyanayirla. Nyanartijangka Jayikapju parla takijularni Ngarpuwu ngampurrikananupurru, “Puju pajan ngampurrikananku niranira kumantajaa karuwarrajaa pukanyja, wali nyanarti, Kutpala pajin ngunawu purlka. Yarnta puju pajan tikirrkangku ngajukurakarti ngurrarakarti yarnta ngajukurakarti ngarpukarti, wali nyanarti, Kutpala pajin ngunawu purlka. Minyayirla pamarra marnantalu nyuntu nira kajalkajalkujirnanku. Nganawurti pajan yunganku, walimpa marnanta tikirryungku lamparn.” ");
INSERT INTO wmt_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","35","Nyanartijangka Jayikap jakarni kayili kitangarni manyanangurla pirriyani kukunja ngampurrjiwarntirla. Wali nyanartiwarnti kukunjawarnti palu palkanga yukarnani. Yarnta ngapanga willa palu piyirnwarnti kirrarnani. Ngapa nyanarti manyanangu ngunangani, pamarr purlka palanta rukukanani. Yangka palunya kukunjawarnti paja kanya warijpanungurla palunyanangu ngapa purlanani. Yarnta palanta tikirrparni rukukanani pamarr. Wali Jayikapju manya japirryinya, “Wanyjarrajangkawarnti manta nyurrawarnti.” “Yarankarrajiwarnti marnalu nganampa minyartikarrajiwarnti.” “Kala pinarri ngantarla nganpayiwu Layipanku.” “Yu. Pinarrijal marnalurla.” “Yara ngarta nyantu nguniny.” “Yu. Yara pa nguniny. Kurntal parla kukunja ngampurrji nyantukura yini parla Rajil. Nyanartila manya pirrikangana kukunjawarnti ngapakarti.” Wali Jayikapju manyanangu marni, “Nganajangka palu minyarti kukunjawarnti yukarnana. Jalarra pa jininyara. Ngapa yungkalunya, wurnala mantanya kangku yukakarti.” “Ngajirta,” marni palurla nyantuwarntirlu, “Kanarlanywarntiwu marnalunangu jurumanana. Nyanartila marnalunyanangu pamarr warijpanungurla ngapa purlananku nukarninirlu. Ngalkula palu kukunjawarntirlu ngapa.” Nyanartikarrarnila manya pirrikanya kukunjawarnti Layipankurarlu kurntalnyankurarlu. Wali Jayikappala turtangkarra kanya ngapakarti nyantuliny kajalkajal. Nyantungula manyanta warijpani pamarr. Ngapala manya warntarnurla yinya kukunjawarnti Rajilkurawarnti. Nyanartijangkarlu lawukanila nyanarti marnin. Linyala manyanta jarntunga. Jayikapjula parla marni, “Ngaju marnarla nyuntukurawu ngarpuwu walaku. Ngamaji ngajukura parla rimpi Rupayika.” Wali nyanartijangka marnin manyanta laparni ngarpunyankurakarti Layipankarti. Jularnila parla, “Jarntu ngalimpakura parlipangu pirriyani. Nyanya marna nyuntukura walaku, ngamaji parla Rupayika nyuntukura rimpi.” Nyanartijangka pinakarrinyurla wilkartila turtangurla laparni Layipan. Langkarnikanurla pa lawukani Jayikap. Linyala manyanta. Ngurrakartila purpankarranya. Kirrarnanila pila wangkikarra. Jularnani parla nyapartukarra Jayikap pa wurnajarrinya marringurni. Wali Layipantu parla marni, “Yu. Ngajukurajinyangu pajin walaku jarntu.” Nyanartijangka Jayikap manyanta kirrarnani rawa layi yakarn. Wali nyanartijangka Layipantu parla marni Jayikapku, “Yarr pajin warrkammarnani. Ngajirta marnanta nganawurti yungantarla yiji. Ngana marnanta yungku warrkamjangka.” Wali Jayikapju parla marni, “Ngajirta. Marnin pajan yungku Rajil.” Wali kurriny pinya kurntaljarra martarnani Layipantu Liyajaa Rajil. Liya pa kajalurnijangka. Wali wartangurnijangkawu parla Rajilku wulyumarnani Jayikapju. Nyanarti marnin pa wulyu jurnanykarra. Liya pa kapakapamarta. Nyanartijangka parla marni Jayikapju, “Yungku pajan Rajil. Warrkammalku marnangu yitilalwarnti 7, nyanartila pajan marnin yungku Rajil.” Wali Layipantu parla marni, “Kirrarnanku pajinurla minyayirla lama, nyanartila marnanta ngajukura kurntal yungku. Kayan ngarnarla kanarlany yungku nyuntuwurni marnangu wulyumalany.” Wali Jayikapju parla Rajilku warrkammarnani yitilalwarnti 7. Wirriyarlu parla warrkammarnani tumaj parla Rajilku wulyumarnani. Nyanartijangka Jayikapju parla marni Layipanku lamparrnyankurawu, “Yitilalwarnti palu pujujarrinya. Nyangurla pajan yungku marnin. Wali marnangu rawa warrkammarnani.” Nyanartijangka Layipantu manyanangu piyirnwarntiwu marni nyanartikarrajiwarntiwu, “Miyijaa kuyi parlipa ngalku wirriyakujirnupurru. Wali nyanartijangka kartula marnarla yungku Jayikap.” Nyanartikarrarni pukanyja miyijangkarlu parla kanya Layipantu Jayikapku kartu Liya. Kula parla Rajilparni kanya. Minya parla kanarlany kurntal kajiyinya. Wali yukarnila pila pukanyja. Kumantajarrinya pilangu nyanyala marninwarlany janginy Liya Jayikapju. Nyanartijangka parla Jayikapju marni Layipanku, “Nganajangkarlu pajan Liya yinya. Ngajungu marnarla warrkammarnani Rajilku. Rajil pajan yungkarla. Kajiyinya pajan.” Layipantu manyanta jangkumani, “Wali marnanta yinya kajalurnijangka Liya. Kujartikarra marnalunya nira yungany kajalurnijangkaliny wartangurnijangkala warra. Wali kirrarnanku parlipa wirriya warrarni, nyanartijangkarlula marnanta yungku Rajil kartuwarlany. Yitilalwarnti 7 pajin warrkammarnanku yarntarni,” Wali Jayikapju parla yu marni. Nyanartijangka parla yinya Rajil yangka palu ngarnunga pujujarrinyajaa jujujangka mapirrirni palu lamajarrinya. Wali Jayikapjarra Rajil pila yukarnani pukanyja. Wulyumarnani parla Rajilku, ngajirta parla wulyumarnantarla Liyawu. Wali yarntarni parla warrkammarnani Layipanku yitilalwarnti 7 Rajil warntarnupurru. Wali marninkujarra warrkammayinjarra pinya Layipantu yinya kurntalkujarra nyantukurajarra, layiwarlany parla Rajilku, layiwarlany parla Liyawu. Ngajirta parla wulyumarnantarla Liyawu ngumparnanyankurarlu Jayikapju. Nyanartijangkarlu parla Ngarpungu kankarnumarrangurla Liyawu yawiyijarrinya. Wali yapawarntila parla yinya Ngarpungu parriwarnti kurrinykurriny. Yiniwarnti manya jularni Rupun, Jimiyin, Lipayi, Juta. Nyanartiwarnti yiniwarnti palurla walakuwarnti. Nyanartijangka Liya pa wirriyajarrinya. Marni parlanyanu, “Yapawarntijarti marna. Wali ngajukurarlu ngumparnarlu paji wulyumarnanku.” ");
INSERT INTO wmt_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","43","Wali Rajillu ngajirta parla yapa martarla Jayikapku nyantukurarlujinyangu kartungu. Liyangumiparni manya martarni yapawarnti. Nyanartijangka parla yurrulyjarrinya Rajillu. Wali marninwarlany warrkammayin manyanta Rajillu yiparni Jayikapkarti. Nira pila yukarnani Jayikapjaa marnin nyanarti warrkammayin, parrila parla Jayikapku martarni yini Tan. Yarnta kanarlany parla martarni yini Natali. Parrijarra kurriny parla martarni Rajilkurarlu warrkammayintu. Yangka Liyangu ngajirta manya yarntarni yapawarntiwarlany martarla, wali kanarlany manyanta marninwarlany yiparni nyantukura warrkammayin Jayikapkarti yukarnupurru. Wali parrila parla martarni yini Kata. Yarnta kanarlany parla martarni yini Yaja. Parrijarra kurriny parla martarni Liyakurarlu marnintu. Nyanartijangka yarntarni wartangurniwarlany parrijarrawarlany pinya martarni Liyangu yinijarra Yijikajaa Japilan. Yarnta manga layi yini Tana. Nyanartijangka wartangurniwarlany parla Ngarpu japirlyinya Rajillu yapa yungupurru. Wali pinakarrinya pa Rajilkura wangki. Parrila parla yinya yini Jawujap. Wali Jayikapju manya ngampurrikanani kukunjawarntijaa nanikutwarnti Layipankurawarnti. Nyanartijangka Layipanku parla marni, “Wurna marna yanku ngurrarakarti ngajukurakarti tikirr.” Layipantu parla marni, “Ngajirta. Lama man warrkammarnanku minyayirla. Marrki manunya ngampurrikanana kukunjawarnti ngajukurawarnti tumaj Ngarpungu manta marlamani kankarnijangkarlu. Puju pajin jutungu warrkammarnanku wali pamarrpala marnanta yungku purlka. Nyapartukarra man nyuntungu malku.” Jayikapju parla marni, “Ngajirta. Yarr pajan yungku kukunjawarnti kurnkurnwarntijaa nanikutwarnti wirntikirliwarnti. Ngurrujarrakujirnurla pajan yungku minyartiwarnti. Ngajungula marnajin martarnanku.” Layipantu parla marni, “Yu, yungku marnanta.” Wali kajiyinya parla Layipantu. Nyanartijangka yinyala manya nyantukurawarnti walakuwarnti. Ngajirta parla nyantu yungkarla jirrkirl Jayikap kajiyinya parla. Wali Jayikapju manya parpjartiwarntimipa ngampurrikanani Layipankurawarnti. Nyanartijangka Ngarpungu pa Jayikap ngampurrikanani warrkampurru jirrkirl. Nyanartiwarntirlu kuyiwarntirlu parpjartiwarntirlu palunya martarni kurnkurnwarntijaa wirntikirliwarnti yapawarnti wulyuwarnti. Paja palunya martarni. Layipankurawarnti palu parpjartiwarntimipa ngarlawarnti. Jayikapkurawarnti palu kurnkurnwarntijaa wirntikirliwarnti wulyuwarnti. Kujartikarra pa Ngarpungu marlamani Jayikap. Nyanartijangka payamkujirnila manya Jayikapju pamarrjawurlu kamulwarntijaa tangkiwarnti, yarnta piyirnwarnti paja warrkammayinwarnti. Maja manyanangu ngunangani manawarntiwujaa kuyiwarntiwujaa piyirnwarntiwu. ");
INSERT INTO wmt_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","55","Layipankurawarntirlu walakuwarntirlu palunyanangu marnani, “Jayikapju parla ngurru warntarni ngalimpakurawu ngarpuwu nanikutwarntijaa kukunjawarnti. Jayikap pa ngunangana kuyi pajajartijaa mana pajajarti. Ngarpu nganampakura pa ngunangana yarpalmartajarti.” Yarnta lamparrnyankurarlu Layipantu parla yakurrmarnani Jayikapku. Nyanartijangka Ngarpungu parla Jayikapku marni, “Wurna man yanku tikirr ngurrarakarti nyuntukurakarti. Ngampurrikananku marnanta ngajungu.” Nyanartijangka marni pilangu Jayikapju kartunyankurajarrawu, “Yanku parlipa ngajukurakarti ngurrarakarti kurlirra. Ngarpungu paji jularni kankarnijangkarlu tikiyanupurru. Nyurrajarrakura ngarpu pa kajiyungujuwal. Jarlujangkarlu paja kirrijiliny kajiyinya Rajilngurni. Yarnta paja kajiyinya kuyiwarntingurnijaa pamarrngurni warrkamjangka. Nyanartijangka paji marni Ngarpungu kurlirra tikiyanupurru. Wurna parlipa yanku minyartingurni ngurrangurni.” Kartunyankurajarrarlu pilarla marni, “Wali mapunikarrku man Ngarpu kankarnijangka yangka mangu jularni. Ngajarrakurarlu ngarpungu kayan ngajarranya yungka pamarrjaa manawarnti. Kula parlipanyanta ngayiwarntirni kirrarnana. Wurna parliparlanyanta yanku kajiyungujuwalku.” Nyanartijangkarlu marurrpinyala manya Jayikapju wurnapurru kukunjawarntijaa nanikutwarnti yarnta warrkammayinwarnti mapirri. Kamulwarntirlala palu parayani kartujarrajaa yapawarnti. Yarnta manya manawarnti paja karrpirni kamulwarntirla. Nyanartijangka wurnala palu jakarni. Kuyiwarntirla palunangurla wartangurni yanani kamulwarnti piyirnjartiwarnti. Ranyji palurlanyanta yani Layipanku warrkamjapururla. Jamurnku wurnawu Rajilpala yani mayarukarti Layipankurakarti. Nyanartiwarnti manawarnti yangka manya Layipantu kajalkajalkujirnani Ngarpujilinywarnti, nyanartiwarntirnila parla warntarnkarrakanya Rajillu ngurru kurntalnyankurarlu. Wartangurni pa kirrarnani Layipan ngurrpa ngurrawarnti murrkurn. Nyanartijangka jularni palurla Layipanku lamparrnyankura yap yanujangka. Jamurn pinakarrinya kulijarrinyala parla. Wurnarnila jakarni wartangurni. Waangurla manyanangurla pirriyani wartangurni. Jutparnila palu yukarni kaparn. Nyanartikarra pukanyja parla winkirru marni Ngarpungu, “Ngajirta ngan pungka nganpayi nyanarti Jayikap. Wanyjarrku man.” Kumantajartila manyanta pirriyani Jayikapja. Marni parla Layipantu, “Nganajangkarlu manpinya yap kanya ngajukurajarra kurntalkujarra, yarnta jamirtiwarnti mapirrirni. Ngajirta pajin jularla wurna yanupurru jarlu yalayirla. Yarrpala marnangu pirriyani nyana marnanta pungkarla tumaj paji Ngarpungu jarrmarni.” Jayikapju parla marni, “Puju ngarnangu jularla yanupurru lamakujirlala nganpinya kurntalkujarra nyuntukurajarra. Wali marna yani ranyjirni.” Yarntarni parla marni Layipantu, “Wanyjarra paji ngajukurawarnti manawarnti Ngarpujilinywarnti yala pajin warntarnkanya ngurru.” Jayikapju parla marni, “Ngajirta marnangu ngajungu kangkarla ngurru. Ngurrpa marnarla nyuntukurawarntiwu manawarntiwu.” Nyanartijangka muwupunganila parla Layipantu kalukuwarntirla. Manawarnti nyanartiwarnti manya kaninymarrangu ranyjikujirni Rajillu payikirla. Kankarnumarrangula manyanangurla nyantu kirrarnani. Jarti parla warijpanani Layipantu. Nyanartijangka Jayikapju parla kulijarrinya. Marni parla, “Wayila manunya parlipinya.” Yarnta parla marni, “Nganajangkarlu pajan waangani wartangurni yangkakatarnangu warrkammarnani jirrkirl jarlujangkarlu. Ngajirta marnangu wanyjanantarla warrkam. Nyuntungu pajan kajiyungani kuyingurnijaa pamarrngurni. Walirni paja ngaju Ngarpungu ngampurrikanani yarnta paja pamarr purlkajartikujirnijaa kuyi pajajartikujirni. Nyanartijangkala marna jalarra pajajarti ngunangana. Ngajirta pajan nyuntungu yungkarla. Ngarpungu paja yinya pamarrwarntijaa kuyiwarnti yarnta piyirnwarnti warrkammayinwarnti.” Layipantula parla marni, “Ngajukurawarntijal pajilu kurntalkujarrajaa jamirtiwarnti, kuyiwarnti mapirri. Nukarnini pajilu ngajuwu. Wali jamulu manunya martawu. Kayan ngarnanta pungka tumaj paji Ngarpungu jarrmarni. Kurlirra man yananku. Pamarrwarnti parli kaparn tirnyutukarrku pinalkarrapurru. Kayan ngajin kayili tirrinyyanta ngajukarti pungupurru. Yarnta ngaju kayan ngarnangurla nyuntukarti tirrinyyanta kulijarti. Ngurrujarra parli wali kirrarnanku kayilijaa kurlirra. Minyarti parli pamarrwarnti tirnyutukanana pinalkarrapurru.” Nyanartijangka manya wurnangu kumantawarlany nurtpungurlakani Layipantu. Yarnta manya ngukupajani jamirtiwarntijaa kurntalkujarra. Nyanartijangka wurnala tikiyani kayili. Jayikapngurra palu wurnala yanani kurlirra. ");
INSERT INTO wmt_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","32","Nyanartijangka yinjilwarntila palurla pirriyani wurnajangkawu. Jayikapju parlanyanu marni, “Kunyungurla parla minyarti ngurra Ngarpukura.” Nyanartijangka kaparnngurni manya Jayikapju yiparni piyirnwarnti kajalurn. Papajinyankurakarti Yijuwukarti manya yiparni kurlirrara wangkijarti. Wali Yijuwurla palunyanta pirriyani, marni palurla kujartikarra, “Jayikap mangurla jalarrarni pirriyanku ngajajpurru, wartangurni pa yanana kayilungu.” Nyanartijangka palunyanta tikiyani Jayikapkarti kayili kaparnkarti. Marni palurla Jayikapku, “Papajpurru mangu pirriyanana wartangurni piyirn pajajarti.” Nyanartijangka Jayikap rayinjarrinyala. Pungka ngarta papajinyankurarlu. Nyantungu pa pinapinakarrinya jarlujangka yangka Yijuwurlu parla marni walimpa pungupurru. Nyanartijangka Ngarpuwu parla marni Jayikapju, “Ngarpu, nyuntungu pajin jularni ngampurrikanupurru. Yarnta pajan yinya manawarnti pajajaa piyirnwarnti warrkammayinwarnti mapirrirni yapawarntijaa kuyiwarnti. Nganapartu nganapartu pajan yinya nyuntungu. Yarr marna ngaju piyirn, nira pajin wulyumarnana. Papajirlu ngaja pungka ngajukurakarrarlu pirla. Ngampurrikarrku pajan jalarra nyuntungu ngajukurakarrarla papajikarrarla. Rayinkarrinyana marnarla. Pungka ngarnapanya nukarni marninwarntijaa yapawarnti. Nyanartirlamarra marnanpanya ngampurrikananku. Pungka ngarnapanya.” Nyanartijangka marnila manyanangu Jayikapju warrkammayinwarntiwu, “Ngurrujarrakujiwu parliparla Yijuwu kamulwarntijaa tangkiwarntijaa purlumanwarnti. Kangkula mantarla kajalurn Yijuwu.” Yarnta parlanyanu marni ranyjingurni muntanga, “Wirriyakujiwu marna ngajukura papaji. Yipawu marnarla kajalurn kuyiwarnti, nyanartijangka paja langkarnikarrku kulingajirtarlu wulyungu. Ngangakujiwula palu kuyiwarntirlu nyanartiwarntirlu.” Wali yiparni parla kajalurn. Nyantu kayilirni lama kirrarnani. Nyanartikarrarni pukanyja manya yiparni nyantukurawarnti kartujarrajaa marninjarrawarlany warrkammayinjarra. Yapawarntijaa warrkammayinwarnti mapirrirni manya yiparni. Yarnta kuyiwarntijaa manawarnti nukarni manya kajalurni yiparni Jayikapju. Marni manyanangu, “Yanku manta kurlirra tirriny martuwarrarlal. Ngaju marna minyayirla lama kirralku.” Nyanartijangka pukanyjala parla nganpayi pirriyani Jayikapku. Turturlikananila pilanyanu kulingu, wanyjarra parlanyanta maja ngunawu, kunyungurla Jayikap kunyungurla nganpayiwarlany. Wali turturlikanani pilanyanu kitangarni pilangurla rakarrakanya. Yangka ngungkupinya Jayikapkura maya nyanawurlu nganpayiwarlanyju, marni parlanyanu, “Kunyungurla minyartirlu nganpayirlu paja yukarnukujiwu.” Wali nyanartijangkarlu mirtalpala pinya Jayikap. Marnila parla Jayikapku, “Jarlu parlingu rakarrakangana, yartajpantaja.” “Ngajirta. Tarrpartarnanku marnanta jutungu. Japirlyungkuliny manurla Ngarpu ngajupurru, nyanartila marnanta yartajpanku.” Wali marni parla nganpayirlu nyanartirlu, “Ngana man nyuntu yini, julajirlanyanu.” “Ngaju marna Jayikap.” “Kayan ngan Jayikap nguna. Kanarlany marnanta yiniwarlany julawu Yijirayil. Tumaj man Ngarpu turturlikanani, yarnta man yukarnukujirni. Piyirnwarnti kanarlanywarnti mapirrirni manunya kaninykujirnani nira.” Wali Jayikapju parla marni nyantuwarlanyku, “Kala ngana man nyuntu yini. Julajirlanyanu.” “Ngajirta ngajan yiniwu japirlyungka. Pinarri pajin ngunarla. Ngampurrikanankujal marnanta.” Nyanartijangka wurnala parlanyanta yani rakarrarla. Wali Jayikapju parlanyanu marni, “Kunyungurla marna minyarti nganpayi turturlikani Ngarpu pukanyja. Yarnta marna warrarni nguniny wanji. Ngajirtarni paja pungkarla pirlawurra. Wali nyanartirni ngurra pa yini yutukani Piniyil Jayikapju. Nyanartijangka jamurn purangu turtapinya Jayikap wurnala jakarnkanya. Nyikitkarrala yanani mirtal pungujangka. ");
INSERT INTO wmt_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","20","Nyanartikarrarni kumanta nyanyala Jayikapju papajinyankura Yijuwu pirriyanujangka piyirnwarnti pajajarti. Kurlangu palu pirriyanani, pajajinyangu manya kangani piyirnwarnti 400. Jayikapju nyangungurla langkarnikani pirriyanujangka. Yijuwukarti manyanta yani jutinykarra rayintu kajalkajalkujirnupurru. Kujartikarra manyanangu yurru ngunangani kanarlany kajalkajalkujirnupurru. Wali lawukanila Yijuwurlu Jayikap yawiyijangkarlu. Lunganila pilanyanu ngayijarrinyujangkarlu. Nyanartijangka lungujangka pila yarrjarrinya. Marnila parla Yijuwurlu, “Nganajangkarlu pajin kajalurn yiparni piyirnwarnti kuyijartiwarnti langkarni.” “Ngajirta. Yiparni marnangu yalyakujirnupurru.” “Ngajirta. Wali marnanya ngajungu ngarrja martalany kuyiwarntijaa manawarnti. Tikirrwarntawu manurlanyanu nyuntungu.” “Ngajirta. Martawu man nyuntungu. Puju pajin kirtilyjarrinya, wali nyanarti, minyarti yijijangka manurlanyanu martawu. Kangku manunya minyartiwarnti kuyiwarnti. Ngarpungu kankarnumarrangujangkarlu paja ngampurrikanani yarnta paja kuyiwarnti paja yinya. Ngarrjawarlany marnanya martalany ngajungu.” Kujartikarra parla marnani Jayikapju kitangarni Yijuwurlu parlanyanu kanya yijijangkawarnti Jayikapkurawarnti. Nyanartijangka wurnala jakarni Yijuwu kurlirra Yitimkarti nyantukurakarti ngurrakarti. Kirrarnanila nyanayirla. Wali ngajanyankura Jayikap pa yani wartangurni ngurrakarti Jikimkarti. Wali nyanarti ngurra parlanyanu Jayikapju payamkujirni nyantungumiparni. Yarnta manya pamarrwarnti purlkawarnti mungkurrpinya pinalkarrapurru Ngarpu kajalkajalkujirnupurru. Wali kirrarnanila palu nyanayirla Jikimja rawarni. ");
INSERT INTO wmt_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","29","Wali nyanartijangka Ngarpungu parla marni Jayikapku, “Yanku man kurlirra Pajilkarti. Nyanayirla man kirrarnanku. Yarnta manunya pamarrwarnti mungkurrpungku ngajuwu kajalkajalkujirnupurru. Ngaju marnangu purlka Ngarpu yangka pajan nyanya jarlu minyayirla ngurranga, nyanartikarra yangka manurlanyanta papajiwu nyuntukurawu wurnamipa kitpungani.” Nyanartijangka Jayikapju manyanangu jularni nyantukurawarntiwu piyirnwarntiwu, “Tarrapungkalunya nyanartiwarnti manawarnti Ngarpujilinywarnti kayilungujangkawarnti yangka mantanya kajalkajalkujilany nira. Nyanartijangka nyumukmalkuliny manta, manala mantanyanu wulyu yutukarrku karrkinta. Nyanartijangka ngurrajangka parlipa yanku kurlirrara Pajilkarti. Mungkurrpungkula marnarla pamarrwarnti nyanayirla Ngarpuwu kankarnimarrangujangkawu kajalkajalkujirnupurru. Nyantungu paja marlamanani yangkartujangka. Warrarni paja Ngarpungu jalarrawurti ngampurrikanana.” Nyanartijangka piyirnwarntirlu palurla yinya manawarnti Ngarpujilinywarnti. Wali karlarnurla manya nguwanga turnmarni mananga rirringki warnamintirla. Nyanartijangka palu Pajilkarti yani, pirriyanila palu. Mungkurrpinyala parla pamarrwarnti Ngarpu kajalkajalkujirnupurru. Wali Ngarpu manyanta pirriyani Jayikapja. Marni parla Jayikapku, “Jalarra marnanta yiniwarlany julawu. Jarlu man nguja Jayikap, jalarra man ngunawu Yijirayil. Ngaju marnanyirrangu purlka Ngarpu. Yapawarnti paja manunya martawu nyuntukurawarntijangka walakuwarntijangka. Kujangkurrajarrala palu ngunanganku. Yarnta palunyanangu majawarnti ngunanganku piyirnwarntiwu kanarlanywarntiwu. Jarlu marnapinya yinya Ayiparanjaa Asik minyarti ngurra Kayinin. Nyuntula marnanta jalarra yungany jirnajangka. Walimpawarlany palurlanyanu yapajirnanyunguwarntirlula martarnanku minyarti ngurra nyuntukurawarntirlu.” Nyanartijangka Ngarpungula Jayikap wanyjani. Wali purtkujirnila pamarra ayil kajalkajalkujirnupurru Ngarpu ngurranga kirlingarni yininga Pajilla. Nyanartijangka Pajilngurni palu jakarni kurlirrara ngurrawarlanykarti. Wali pitparni manyanangurla muntajarti Rajil. Jurumanani palunyanta kaparn. Jamurnjamurnjarrinya parla yapa martarnupurru, parrila palkangawantinya. Ngamajila parla pirlajarrinya parrikura. Kankarlajarrala jularni yini Pinjimin ngarpunyankurarlu Jayikapju. Yawiyila palurla lungani. Nyanayirlarni palu turnmani pirlajarrinyjangka. Pamarrpala manyanta yutukani Jayikapju pinalkarrapurru kartunyankurarla. Yarntarni kurlirrawarlany yanani Jayikap. Pirriyanila ngurranga Mamurirla. Ngarpunyankura parla nyanayirlarni kirrarnani. Nyantu pa purrkujinyangu Asik, yitilalwarntirla pajanga nguja 180. Nyanartijangka walimpa pirlajarrinya purrkujarrinyujangka. Turnmanila pila walakunyankurajarrarlurni Yijuwurlujaa Jayikapju. ");
INSERT INTO wmt_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","43","Wali purlumanwarnti pilanya paja martarni Yijuwurlujaa Jayikapju kayanta. Yukala palurlanyanu warpijngarnani. Nyanartijangka Yijuwurlu manya pakulkanya ngurrawarlanykarti kurlirra. Nyantukurawarnti manya kanya kuyiwarntijaa kartuwarnti yapawarnti mapirri. Pamarra palu kirrarnani ngurranga Yitimja. Wali ngurrujarra pila kirrarnani Yijuwujarra Jayikap kayilijaa kurlirra. Wali Yijuwukurawarnti yapajirnanyunguwarnti palu nyanayirlarni kirrarnani. Nyanartiwarnti yapawarnti palunya jularnani Yitimkarrajiwarnti. ");
INSERT INTO wmt_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","4","Jayikap pa Kayininta kirrarnani. Warrkammarnani palurla walakuwarntirlu 12ju. Ngampurrikanani palunya kukunjawarntijaa nanikutwarnti. Layingu Jawujapju parla jularnani ngarpunyankurawu Jayikapku, “Ngarpu, nyanartiwarnti palu yarr kirrarnani ngajukurawarnti papajiwarnti. Ngajungumipa marnanya ngampurrikanana kukunjawarnti.” Kujartikarra parla jakuljularnani Jawujapju Jayikapku ngarpunyankurawu. Jayikapju parla wulyumarnani walakuwarlanyku kaparnngarrangarrawu Jawujapku. Purrkungu kangujangkarlu parla wirriya ngunangani. Nyanartijangka parla nyantuwumipa mintimmarnani kuwut mana wirrimpurru wulyu. Nyanartijangka papajiwarntirlu palurla yakurrmarnani Jawujapku. Marni palurlanyanu, “Ngarpungu ngalimpakurarlu ngajirta parlipangu wulyumanyja. Nyantuwumipa parla wulyumarnani Jawujapku, ngajirta ngalimpawu.” Wali ngajirta palurla wulyuwulyu wangki manyjarla Jawujapku jarntuwarntirlujal. ");
INSERT INTO wmt_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","11","Wali Jawujapju winkirrmarni. Nyanartijangka jularni manyanangu papajiwarntiwu winkirrjangka. Marni manyanangu, “Warrkammarnani parlipa pirntirrirla. Kayantakujirnani parlipanya yukawarnti miyijartiwarnti. Nyanartijangka karrpirnanila parlipanya warrapurru tukarnupurru. Minyarti layi ngajukura yuka turtangurlala karrinyani, kaparn manyanangurla. Kanarlanywarnti yukawarntiwarlany karrpirnujangkawarnti turtangurlawarlanyparni palu karrinyani yangka mantanya nyurrawarntirlu junganurla karrpirni. Wamarn karrinyani palu ngajukurangurni marnpa. Nyanartijangka parntawantinyala palu nyanartiwarnti yukawarnti. Kayanmipala manyanangurla karrinyani kankarnumarrangu yangka marna ngajungu karrpirni. Minyarti marnanyirrangu jularnana winkirrjangka. Kujarti marna winkirrmarni.” Wali kujarti manyanangu ngunangani nyantuwarntikura yurru. Parntawantinyani palunangurla yangka nganawurti piyirn purlka ngunangani kajalkajal. Wali papajiwarntirlu palurla marni Jawujapku, “Nyuntungu nganunyanu yutukani kajalkajal jirnajangkarlu. Nganampa marnalu kajalujangkawarnti.” Nyanartijangka palurla yirrmarnani Jawujapku winkirrjuwalku. Nyanartijangka yarntarni manya winkirrmarni Jawujapju. Jularnila manyanangu papajiwarntiwu, “Winkirrmarni marnanya wirlwarnti paja 11 yarnta purangujaa yakarn. Nyanartijangka parntawantinyala pajilurla ngajunga kajalkajalkujirnupurru.” Jayikapjula Jawujap marrarni ngarpunyankurarlu. Marni parla, “Nyapartukarra man minyarti kanarlanyparni winkirrmarnani. Ngajungujaa papajiwarntirlu nyuntukurawarntirlu ngamajirlu mapirrirni kayan ngarnantalu nyuntu kajalkajalkuji winkirrjuwal. Nyuntu man wartangurnijangka. Kayan ngarnanpangu purlka nguna.” Nyanartijangkarlu papajiwarntirlu palurla yakurrmarnani Jawujapku. Ngajirta nganyanangu kajalkajal nguna wartangurnijangka. Yarnta ngarpunyankurarlu pa pinapinakarrinyani winkirrjangka Jawujapkura. ");
INSERT INTO wmt_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","36","Nyanartijangka manya yiparni walakuwarnti kayili Jayikapju ngurrakarti Jikimkarti. Kukunjawarntijaa nanikutwarnti palunya kanya yukangkurra. Jawujap wartangurni kirrarnani. Wali Jawujapku parla marni wartangurni Jayikapju, “Yanku manyanangurla kayili. Nyaku manyanangu papajpurruwarntiwu. Yara ngartalu nguniny yarnta kukunjawarntijaa nanikutwarnti, yara ngalunya ngampurrikarralany. Nyanartijangka pajin wangki tikirrkangku papajpurruwarntikura.” Wali nyanartijangka wurnala jakarni Jawujap kayili. Pirriyanila manyanangurla Jikimja. Jarti manyanangu muwupungani papajiwarntiwu. Wali pirriyanila manyanta layinga nganpayirla. Japirryinyala parla Jawujap, “Nganawu manurla muwupungana.” Jawujapjula parla marni, “Ngajirta, papajiwarntiwu marnanyanangu muwupungana ngajukurawarntiwu. Nyanya nganunya. Yala palu yani kukunjajartiwarntijaa nanikutjarti. Kanya palunya mirnu.” Nyantungula parla marni nyanartikarrajirlu, “Yu. Nyanya marnanya. Jarlu palu tirrinyyani ngurrawarlanykarti kayirrara.” Wali nyanartijangka Jawujapju manya kayirrarni puranwaanya. Nyanartijangka manyanangurla pirriyanila. Parlipinyala palu Jawujap marringurni papajiwarntirlu. Marni palurlanyanu, “Yangkarti parri pa pirriyani winkirrjuwal. Pungku parlipa pirlawurra. Takurrtarrangkula parlipa kurrkunga pulparra willa. Nyanartijangka tikiyanku parlipa kurlirra. Julawu parliparla ngarpuwu ngalimpakurawu, ‘Kunyarrwarntirlu palu pajani ngurrpa wanyjurlaparta.’ Kajiyungku parliparla ngarpuwu ngalimpakurawu kujarti.” Kanarlanyju kajalurnijangkarlu manyanangu marni yiningu Rupuntu, “Kayan ngarlipa pungka. Yarr parlipa tarrangku wanji kurrkunga.” Nyanartijangka pinapinakarrinya ranyjingurni Rupuntu. Marni parlanyanu, “Warra marna warntawu parri kurrkungajangka, tikirrkujiwula marnanyanta ngarpukarti ngajarrakurakarti.” Yawiyijarrinya parla Jawujapku papajiwarlanyju. Wali pirriyanila manyanangurla Jawujap. Langkirrmanila palunyanta mana kuwut. Tarrpartarnurlala palu kanya kurrkukarti. Takurrtarranyala palu kurrkunga. Nyanartijangka Rupun manyanangurla yap yani papajiwarlany. Kanarlanywarnti palu ngurrakarti tikiyani. Kurrkungaliny palu takurrtarrangurlakani Jawujap. Miyila palu ngarnani. Nyanyala palunya piyirnwarnti kamuljartiwarnti. Pirriyanani palu kayilungu. Kangani palunya manawarnti nganapartu nganapartu Yijipkarti jalimkujirnupurru. Wali nganpayirlu Jutangu manyanangu marni yawiyirlu, “Ngajirta ngarliparlanyanu pungka ngalimpakura ngaja. Yarrwurti parlipanyanangurla yipawu kamuljartiwarntirla. Kangkula palu Yijipkarti jalimkujirnupurru. Manajilinyparni palu jalimkujiwu.” Kanarlanywarntirlu palurla marni, “Yu. Purpanku parlipa. Yipawula parlipanyanangurla kamuljartiwarntirla.” Nyanartijangka palu turtangkanya kurrkukarti, warntarnila palu Jawujap. Nyanartijangka kanya palunyanangurla kamuljartiwarntikarti. Yungurlakani palunya pamarr papajiwarnti wurnangu. Wali kanyala palurlanyanu nyanarti nganpayi kurlirra Yijipkarti. Walimpa pirriyani Rupun wartangurni. Jartila parla yanunga nyanya kurrkunga Jawujapku. Nyanartijangka yawiyijarrinyala parla. Langkirrmanila parlanyanu mana karrkintajangka yawiyirlu. Wali tikiyani manyanangurla. Marnila manyanangu, “Jarti marnarla nyanya parriwu, ngurrpa palu yap kanya. Nyapartujarriwula marna ngaju. Kunyungurla paja marrawu ngarpungu ngalimpakurarlu ngampurrikanungajirtangurni.” Nyanartijangka nanikut palu pinya. Maparnila palurla kuwut nyantukura Jawujapkura nungujawurlu. Kanyala palurla nungujarti ngarpunyankurawu kuwut. Yijingkanyala palunyanta. Marni palurla, “Minyarti mana marnalu parlipinya. Jawujapkura ngarta.” Wali nginyjirrikanila parla ngarpunyankurarlu nyantukurawu walakuwu. Marni manyanangu, “Yu, nyantuwurni parla. Wali paja kunyarru marlalkujirni.” Nyanartijangka parlanyanu langkirrmanila nyantukura kuwut yawiyirlu. Yawiyijarrinya parla walakuwu nyantukurawu maruluwu. Kanarlanypala manyanu karrpirni payikijangka mana. Nyanartijangka lunganila parla maya yawiyirlu. Nukarninila palurla pirriyani walakuwarntijaa kurntalwarnti ngangakujirnupurru yawiyijangka. Jarti palu ngangakujirni. Nyantungu ngajirta manya pinakarrinyantarla. Juturni parlanyanu lungani maruluwu. ");
INSERT INTO wmt_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","23","Wali kamuljartiwarntirlu palu pirrikanya Yijipja nganpayi yini parla Jawujap. Nyanartijangka purlkangu nyanya Yijipkarrajirlu, pamarrpala manya yinya kamuljartiwarnti. Warntarnila parlanyanu Jawujap warrkammarnupurru. Nyanarti nganpayi parla yini Patipa. Piyirnwarntiwu pajawu manyanangu maja ngunangani. Wali nyanartijangka pa kirrarnani Jawujap purlkakurarla mayarurla. Ngarpu manyanta warrarni ngunangani Kut. Nyanartila parla jirrkirl warrkammarnani Patipawu purlkawu. Nyanartijangkala parla Patipa wirriyajarrinya. Nyantuwujinyangula parla ngunangani warrkammayin Jawujap. Yarnta manyanangu majakujirni Jawujap manawarntiwujaa kanarlanywarntiwu warrkammayinwarntiwu. Mapunparni Ngarpungu marlamanani Jawujap. Nyanartijangka yarrjarrinyurlala kirrarnani Patipa. Jawujap manyanangurla wali pikajarrinya warrkammayinwarntirla. Rukarnila manyanangurla Patiparlu. Miyijaa kuyi ngarnani ngangangu. Jawujap pa nganpayi wulyujinyangu janginy yarajaa karrkin wulyu. Nyanartijangka marrupunganila Patipakurarlu kartungu. Marnani parla Jawujapku nira kumantawarlany kumantawarlany, “Yanku marnangurla nyuntunga. Wulyumalany marnangu nyuntuwu.” Nyantungu parla Jawujapju marnani, “Ngajirta. Ngajungu ngajirta marnanta marrupungka. Nyuntu manurla purlkakura Patipakura yangka paja ngaju majakujirni. Wali paja nyantungu jirrkirl nyangana. Yarnta paja ngaju mapirri nyangana Ngarpungu. Kayan ngarnanyanta yakurrjarri nyantunga.” Wali Jawujapju parla jarti yirrarnmarnani nyanartiwu marninku. Jutungurni parla marnintu marnani, “Ngajirta. Nyuntuwu marnangu wulyumalany. Yanku marnangurla.” Kujarti parla Jawujapku marnintu nyanartirlu marnani. Kumantawarlanyja pirriyanila parla warrkamku nganpayi Jawujap. Ngajirta palu kanarlanywarnti ngunarla warrkammayinwarnti. Kayanta manyanta pirriyani marninta. Nyanartirlu marnintu parla murtarni tarrpartarni nyantukura kuwut. Marni parla, “Yanku marnangurla.” Wali nyanartijangka pupurula laparnkarrakanya Jawujap marninkarrarla kujikanukarrarla. Papajanila manyanangu marnin warrkammayinwarntiwu yirri. Marni manyanangu, “Nyaku manta minyarti Jawujapkura kuwut. Wanyjani parlanyanu ngurranga ngajukurarla rayintu. Nyakarla nganta nyurrawarntirlu.” Kujartikarra manyanangu marni marnintu. Yirri manya kajiyinya. Yarnta manyanangu marni, “Jawujapju paja marrupinya ngaju. Kangkarla paja nyantungu. Yangka marnanyirrangu papajani, nyantu pa rayin yap laparni nyurrawarntikarrarla. Nyakarla nganta. Kuwut minyarti parlanyanu wanyjani rayintu.” Marnintu nyanartirlu martarnani Jawujapkura kuwut kitangarni parla pirriyani ngumparnanyankura Patipa. Nyanartirni wangki parla jularni wapal. “Yangkarti nganpayi man nyuntungu warrkammayinkujirni yarnta manyanangu warrkammayinwarntiwu majakujirni, nyanartirlu paja marrupinya ngaju. Kangkarla paja. Wali partalurnila marnanyanangu papajani warrkammayinwarntiwu. Rayinpala pupuru laparnkarrakanya. Wanyjanurlakani parlanyanu minyarti kuwut rayintu.” Nyanartijangka wangkijangka kulijarrinyala parla Jawujapku, jirljirljarrinya parla. Marnila manyanangu warrkammayinwarntiwu, “Nganpayi nyanarti manta tarrpartawu, jayillala manta yutukarrku.” Wali tarrpartarnurla palu yutukani jayilla. Kanarlanywarnti jayilmayinwarnti palu kajalurni kirrarnani yangka manya purlkangu jarlu yutukani kingju Yijipkarrajirlu. Jawujappala manyanangurla kirniny yutukani. Jawujapja manyanta Ngarpu warrarni ngunangani. Nganpayirlu purlkangu limpangu parla wulyumarnani Jawujapku tumaj parla warrkammarnani wulyuwulyu Jawujap. Nyanartijangka limpangu manyanta pikajarrinya nyantunga. Marnila parla Jawujapku, “Nyuntula manyanangu purlka ngunawu jinjinyungupurru. Ngaju marna yarrjarrinyurla kirralku.” Wali Jawujap pa jirrkirljinyangu warrkammarnani tumaj pa Ngarpungu warrarni jirrkirlkujirnani. ");
INSERT INTO wmt_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","8","Walimpa pilangu purlkangu kulijarrinya kingju Yijipkarrajirlu warrkammayinjarrawu. Jayilla pinya takurrpinya. Kanarlanyju nganpayiwarlanyju parla kingku ngapa pirrikangani wayin ngarnupurru. Warrkam parla nyantukura nyanarti. Kanarlanyju warrkammayintu parla kingku kamparnani miyi. Kukumanu parla nyantu ngunangani. Rawa pila ngunangani jayilla nyanartijarra nganpayijarra. Jawujap pilangu limpangu yutukani warrkammayin ngampurrikanupurru. Pukanyjawarlany pila nyanartijarrarlu winkirrmarni. Nyanartijangka kumantala pinya nyanya Jawujapju. Kanarlanyparni pila kirrarningurra winkirrjangka. Japirryinya pinya Jawujapju, “Nganajangka manpila wirriyangajirta. Nyapartukarra manpila pinapinakarrilany.” Kanarlanyju parla marni, “Ngajirta, winkirrjangka pajarra. Kanarlanyparni pajarra winkirrmarni. Ngurrpa pajarrarla minyartiwu winkirrku.” Wali Jawujapju pilangu marni, “Ngarpu parlipangu pinarri nguniny nyanartijilinyku winkirrku. Nyapartukarra manpila winkirrmarni. Julajipila.” ");
INSERT INTO wmt_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","19","Wali jularni parla nganpayirlu ngapa wayin kanguyungujuwallu, “Wali kayan mana marna nyanya kuriyipjangka. Minyarti mana pa karrinyani wirkijarti murrkurnjarti. Wali yangka warnjal turtapinya partirila manyanta kalarawantinya. Wali jurtantinya manyanta, miyiwarntila palu ngujangurra tarnku. Nyanartijangka pakirtila marnarla warntarni wuruwu. Nyulypinyala marna kuriyipjangka, wurula ngujangurra pakirtirla. Yinyala marnarla nganpayi king. Wali kujarti marna winkirrmarni.” Wali Jawujapju parla marni, “Julawu marnangu, ngaju marnarla pinarri nyanartijilinyku winkirrku. Nyuntungu man winkirrmarni mana wirkiwarntijarti murrkurnjarti. Wali wirkiwarnti murrkurn palu ngurrawarnti murrkurnjilinyparni. Ngurrawarnti murrkurnwarlany man kirrarnanku minyayirla jayilla, nyanartijangka manta kingju yipawu palkakarti majangu nyuntukurarlu. Yarntarni manurla warrkammarnanku kingku, wayin manurla yunganku. Wali yangka man tikiyanku ngurrakarti kingkurakarti warrkampurru, julawu manurla ngaju mapirrirnila paja yipawu. Murtangkurra marna kirrarnana minyayirla jayilla. Wulyumalany marnarla minyartingurni jayilngurni yanupurru palkangkurra.” Wali nyanartijangka nganpayirlu kukumanurlu parla jularni Jawujapku winkirrjangka. Marni parla, “Kujarti marna winkirrmarnani. Pikala marnanya kangani ngurtiwarnti murrkurn larrpuk kankalipil kaninykaniny. Kankarnimarranguwarlanyjangka marnarla kangani purlkawu nganapartu nganapartu miyiwarnti kamparnujangkawarnti. Nyanartijangka jirikiwarntirlula pajilurla tawurnkarrapungurla ngarnani miyi nyanarti. Kujartijiliny marna winkirrmarnani.” Wali Jawujapju parla marni kukumanuwu, “Julawu marnangu. Nyanarti manunya winkirrmarnani ngurtiwarnti murrkurn. Wali nyanartiwarnti ngurtiwarnti palu ngurrawarntijilinyparni murrkurn. Ngurrawarnti murrkurnwarlany man kirrarnanku minyayirla jayilla. Nyanartijangka manta kingju yipawu walimpa palkakarti majangu nyuntukurarlu. Julawula manyanangu warrkammayinwarntiwu nyuntu pungupurru. Nyanartijangka mantalu kangkul tilypurrjunganurla tirrinylanku. Manangala mantalu tarnikarrku. Jirikiwarntirlula mantalu karrkin ngalku.” Jawujapju pilangu kujarti takijularni winkirrjangka. ");
INSERT INTO wmt_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","23","Wali kirrarnani pila jayilla ngurrawarnti murrkurnwarlany. Nyanartijangka kingju pinya yiparni palkangkurra. Layiwarlany nganpayi wayin kanguyungujuwal tikiyani warrkamkarti. Kingku parla yarntarni wayin kanguyungani. Yangkarti nganpayi manya jinjinyinya kingju kukumanu pungupurru warrkammayinwarntirlu. Wali tilypurrjunganila palu pirlawurra kangkul. Yangka pilangu pikakujirni nyantujarrakura winkirrjangka, mapunparnila palu layiwarlany pinya, kanarlany wanji ngunangani. Yangkarti nganpayi wayin kanguyungujuwal parla warrkammarnani majawu kingku. Kajaluwarlany parla Jawujapju jularni jayilla, “Julawu manurla majawu ngaju mapirrirni paja yipawu minyartingurni jayilngurni.” Wali rukarni manyanta wangkinga Jawujapkurarla wayin kanguyungujuwallu. Ngajirta parla majawu manyjarla kingku. Jawujap pa warrarni jayilla kirrarnani. ");
INSERT INTO wmt_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","36","Nyanartijangka winkirrmarnanila manya kingju purlumanwarnti parnanywarnti 7 jirajartiwarnti wulyuwarnti. Kaninymarrangu palu martuwarrangurni kankarral parayani wurrkalkarti. Ngarnanila palu wurrkal. Nyanartijangka yarntarni kanarlanywarnti purlumanwarnti palu martuwarrangurni parayani parnanywarntiwarlany 7. Nyantuwarnti palu jirangajirtajartiwarnti ngarlawarnti. Nyanartijangka palunyanangurla kirniny yani jirajartiwarntirla. Wali ngarnanila palunya ngarlawarntirlu jirajartiwarnti. Nyanartijangka parnkijarrinyala king pukanyja kaparnkaparn. Yarntarni king tikirrparni manyanjarrinya. Yarntarni manya winkirrmarnani. Yuka talykarrjiliny karrinyani, miyila manyanangurla turtapinya pukarr 7. Nyanarti miyi wulyujinyangu. Mananga kayantarni palu turtapungurla karrinyani miyi 7warlanyparni. Kanarlanywarnti manya lalkawurra, wiliwili luwarni. Nyanartiwarntirlula lalkawarntirlu palunya ngarnani warpij wulyuwarnti. Kujarti manya kingju winkirrmarnani. Nyanartijangka parnkijarrinya king kumanta. Pinapinakarrinyani. Marni parlanyanu, “Nyapartukarrarna minyarti winkirrmarnani. Jarti marna pinakarrinyana. Kunyungurla marnanya kanarlanywarnti japirlyungku. Julawu pajilu.” Nyanartijangka yiparni manyanangu wangki piyirnwarntiwu pinangurruwarntiwu. Yanku palurla kingku. Nyanartijangka marni manyanangu, “Julawu marnanyirrangu minyarti winkirrjangka. Winkirrmarnani marnanya wulyuwarnti purlumanwarnti yarnta ngarlawarnti purlumanwarnti. Ngarnila palunya ngarlawarntirlu jirajartiwarnti. Yarnta kanarlany winkirrwarlany. Miyiwarnti yangka palu kirninyja turtapinya wulyuwarntijaa ngarlawarnti. Ngarlawarntirlu nyanartiwarntirlu ngarni palunya wulyuwarnti warpij. Wali nyapartukarra minyarti winkirr. Ngurrpa marnarla. Julajilu.” Jangkumani palunyanta pinangurruwarntirlu, “Ngajirta. Ngurrpa marnalurla nyanartijilinyku winkirrku. Kunyungurla parlipangu kanarlanyju julawu.” Wali nganpayi yangkarti wayin kanguyungujuwal parla pirriyani. Jularnila parla Jawujapkurajangka wangki winkirrjangka. Marni parla kingku, “Nyantu parla pinarri winkirrku nyanartijilinyku nganpayi Jawujap. Nyantu pa jayilla kirrarnana.” Wali kingku purlkangu parla wangki yiparni Jawujapku. Purpanila palurla kingku. Japirlyinyala parla purlkangu, “Nyapartukarra minyarti winkirr yangka marna jalarra winkirrmarnani. Kunyungurla manurla nyuntu pinarri. Ngaju marnarla ngurrpa. Kanarlanywarnti mapirrirni palurla ngurrpa.” Wali nyanartijangka parla kingju marnani Jawujapku wangki winkirrjangka. Nyanartijangka Jawujapju parla marni, “Minyartiwu winkirrku ngajirta marnarla pinarri ngaju, yarnta Ngarpungu kankarnumarrangurlu paji jirrkirl jularnani. Julawula marnangu jalarra winkirrjangka. Wali kurrinymarri man winkirrmarnani. Kayanparni pila winkirrjarra nyanartijarra. Kunyungurla manta Ngarpungu lirrkarnpungana nyapartukarra man walimpa ngunawu. Yitilalwarntiwarlany parlipangu ngapa wulyu ngunawu 7. Miyi manya paja warntarnanku ngapangu. Nyanartijangka yarnta piyirnwarntirlu palu ngarnanku miyi nyanarti. Jularnanku palu, Minyarti miyi parlipangu kuyangayi pajakarra. Yarnta parlipangu ngunawu walimpa yitilalwarnti 7. Kayan ngarlipangu ngapa wanti. Yarnta miyiwarnti ngajirta ngalu turtangka. Yarnta palurla piyirnwarntirlu muwupunganku miyiwu jarti. Murrkurnmipa palu miyi warntarnanku, yarnta marlal.” Kujarti parla tikirrjularnani Jawujapju winkirrjangka kingkurajangka. Yarnta parla kingku lirrkarnpinya Jawujapju, “Parlipungku man nganpayi layi pinangurru. Maja manyanangu ngunawu warrkammayinwarntiwu. Yarnta miyi palu warntarnanku yitilaljangka wulyujangka. Wali takurrpungankula palu warrapurru munyal mayaruwarntirla. Minyartirlu majangu manya miyi ngampurrikananku. Yangkaliny palu miyiwarntiwarlany pujujarriwu walimpa yitilaljangka yakurrjangka, majangula manya piyirnwarnti yunganku mayarurlajangka munyaljangka.” ");
INSERT INTO wmt_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","57","Nyanartijangka kingju parla marni Jawujapku, “Nyuntu man wulyu nganpayi yangka pajin jirrkirl jularni. Kunyungurla Ngarpungu manta pinayinya taki jularnupurru minyarti wangki. Yarnta marnanta kurajpungku nyuntu. Maja manyanangu ngunawu warrkammayinwarntiwu, yarnta miyiwarnti manya ngampurrikananku. Wali marnanyirrangu ngaju king, wali nyuntu manyanangu ngunawu purlka ngajunga wartangurni piyirnwarntiwu Yijipkarrajiwarntiwu nukarniwu. Yarnta mangulurla mapunikarrku kanarlanywarntirlu mapirrirni nyuntunga.” Wali yinyala parla kingju kartu nganpayi nyanarti Jawujap. Yarnta parla kuluwuj mapirrirni yinya wirrimkangupurru wulyu. Mapunparni manyanangu miyi turtapungani ngapa wantinyujangka. Wali kanyala palunyanta miyi nyanarti pukarr warrkammayinwarntirlu Jawujapkarti, yinya palurla. Nyantungula manya yutukanani mayaruwarntirla kaninykaniny. Muntumuntukangani palurla. Purlkajarrinya manyanangu nyanarti miyi. Ngunangani manyanangu purlkajinyangu munyal walimpapurru. Nyanartijangka walimpawarlany yitilalwarntiwarlanyja ngajirta manyanangu ngapa wantirla. Miyi mapirrirni, ngajirta manyanangu turtangkarla. Marranyanjarrinya palu. Yananila palunyanta majakarti Jawujapkarti. Yinyala manya miyi munyaljangka. Payamkujirni palu miyi nyanarti. Wali ngarnanila palu. Wali piyirnwarnti kanarlanywarnti palu marri kirrarnani marranyanjarti. Nyanartijangka palurla yanani Yijipkarti miyi warntarnupurru. Linti palunyanta yanani Jawujapkarti. ");
INSERT INTO wmt_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","38","Wali purrku Jayikap pa warrarni kirrarnani Kayininta Jawujapkura ngarpu. Nyanartijangka pinarrijarrinya parla miyiwu Yijipjangkawu yangka kajilurla jularni kanarlanywarntirlu. Marnila manyanangu walakunyankurawarntiwu, “Kunyungurla miyiwu mantarla muwupungku. Julalany palu miyi paja nguniny Yijipja kurlirra. Wurna manta yanku nyanartikarti Yijipkarti. Miyi mantarlipangulu payamkujiwu. Pirlajarri ngarlipa marranyanjarti miyingajirtajangka.” Wali kurlirrara palu yani Yijipkarti walakuwarnti Jayikapkurawarnti miyi payamkujirnupurru. Wali pirriyanila palunyanta Jawujapja Yijipja. Parntawantinyala palanta kajalkajal. Nyantungu manya nginyjirrikani Jawujapju. Marni parlanyanu ranyjingurni, “Minyarti pajilu ngajukurawarnti papajiwarnti pirriyani.” Nyantuwarntirlu ngajirta palu nginyjirrikarrarla. Jawujapju manyanangu marni, “Wanyjarrangurni manta pirriyani nyurrawarnti.” Yirri manya japirryinya kujawarlanyngurni jarlungurru manya nginyjirrikani. Nyantuwarntirlu palurla marni, “Kayininngurni marnalu pirriyani. Miyiwu marnalurla muwupungana, payamkujiwu marnalurlanyanu.” Wali Jawujapju manyanangu yarntarni marni, “Ngajirta. Nyurrawarnti manta kunyungurla pirriyani kulijarti.” Nyantuwarntirlu palurla marni, “Ngajirta marnalu kulijarti pirriyantarla. Nganampa marnalu paparlangujarti kayankura ngarpu. Nganampa marnalu mapunjiwarnti pirriyani.” Jawujapju manyanangu marni, “Ngajirta manta miyikarti pirriyantarla. Kulijarti manta pirriyani.” Marni palurla, “Jarlu marnalu nguja 12. Layiwarlany marnapangu pirlajarrinya. Kanarlany marnalu wanyjani wartangurni. Ngarpunga manyanta kirrarnana nganampakurarla.” Jawujapju manyanangu marni yarntarni, “Yu. Mapun manta kulijartiwarnti pirriyani. Pungkula marnanya ngajungu pirlawurra. Yarnta marnanya kurlpungany. Yara nganta ngunawu mapunjiwarnti, miyikarti manta pirriyani. Wali layi nganpayi marna kurajpungku nyurrawarntijangka. Jayilla marna martarnanku. Nyurrawarntirlula manta ruwangu purpanku ngaja nyurrawarntikura. Nyanartijangka marnanyirrangurla mapunikarrku. Wanjila marnanya wanyjarrku.” Wali mapunikani palunyanta Jawujapja Kayininkarrajiwarntirlu. Marnanila palurlanyanu, “Kujikani parlipanyanu ngalimparlu yangka parlipa ngalimpakura ngaja jarlu yiparni pirlajarrinyupurru. Nyanartila parlipanya purlkangu pungku.” Nyanartijangka Jawujapju manyanangu marni warrkammayinwarntiwu nyantukurawarntiwu, “Yutukarrarlanangu miyi payikiwarntirla wurnapurru. Mani nyantuwarntikura payamjangka manta ranyji yutukarrku miyinga. Pukarr mapirrirni mantanya yungku kaparnpurru.” Nyanartijangka miyila palanangu yutukani wurnapurru. Wali jakarnila palu kayili miyijarti. Papajiwarlany Jimiyin manyanangu wirtinyikani jayilla. Lamala kirrarnani wartangurni. Wali nyanartijangka pukanyja palu juntumani kaparn. Layingu nganpayirlu payiki kurtamani miyijarti tangki yungupurru. Nyanyala nyanarti mani payikirla ngunanyjangka ranyji. Wali japirrjapirryunganila palunyanu rayintu, “Wanyjarrajangka minyarti mani.” Wali kayili palu yanani Kayininkarti. Pirriyanila palu, yinyala palunya miyi ngarpu nyantuwarntikurajaa kartuwarntijaa yapawarnti mapirrirni. Jularnila palurla ngarpunyankurawu, “Kujikani marnalunyanu, yangka marnapangurla layiwarlany wirtinyikani purlkangu Yijipjangkarlu. Yarnta marnapangu jularni kangku marnalurla ngaja wartangurnijangka. Kujarti marnapangu marni majangu Yijipkarrajirlu.” Jayikapju manyanangu marni ngarpunyankurarlu, “Ngajirta. Kayan nganta kangka minyarti walaku ngajukura. Marulu paji yangka waliwarlany paji marlaljarrinya kayanku pilarla ngamajiwu. Kunyungurla ngajilu yarntarni pungka pirlawurra. Minyarti paji kayanparni. Lungungurla ngarnarla pirlajarri.” ");
INSERT INTO wmt_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","34","Wali rawa palu ngunangani nyanayirla Kayininta. Ngajirtarni manyanangu ngapa wantirla miyipurru turtangupurru yarnta yuka kukunjapurru. Yarnta manyanangu Yijipjangka miyi pujujarrinya. Marnila manyanangu Jayikapju walakuwarntiwu nyantukurawarntiwu, “Yanku manta kurlirra Yijipkarti. Yarntarni mantarlipangulu ruwangu warntawu miyi.” Marnila parla layingu Jutangu, “Ngajirta. Yangka marnapangu jularni majangu nyanartikarrajirlu Yijipkarrajirlu pirrikangku marnalurla ngaja nganampakura. Puju ngarnalu yanta ngajangajirtajarti, wali tikirryipanyja ngarnapanya miyingajirtajarti.” Wali Jutawu parla marni ngarpunyankurarlu, “Nganajangkarlu manurla jularni majawu nyanartiwu minyarti ngajajpurru. Ranyjimarrarla manurla.” Jutangu parla marni, “Ngajirta. Japirrjapirryungani marnapanya. Nyanartila marnarla jularni. Wali Pinjimin marna ngajungu kangku. Ngampurrikarrkula marnangu. Nyanartijangka wanjila marnangu tikirrkangku.” Wali pinapinakarrinya ngarpunyankurarlu. Marnila parla Jutawu, “Yu. Kangku manta wampurr. Yarr marnarla pikajarriwu. Yarnta mantarla kangku majawu miyiwarnti yiji yarakujirnupurru karlakajaa miyi ngarlkajiliny mapirrirni. Nyanartijangka japirryungkula marnanyirrangurla Ngarpu. Yawiyijarriwula manyirrangu maja nyanartikarraji. Wali partalurnila mantapinya tikirrkangku kurrinyparni jayillajangkajaa minyarti ngajajpurru. Kaj. Yantalu miyikarti.” Yiparni manya ngarpunyankurarlu. Nyantu pa lama kirrarnani. Nyanartijangka palu yani kurlirra Yijipkarti. Pirriyanila palurla Jawujapku majawu. Nyanyala Pinjimin Jawujapju. Marnila parla layiwu warrkammayinku, “Kangku manunya minyartiwarnti ngajukurakarti mayaru. Jurumankujilu kajalurni nyanayirla. Tinala marnanya yungku jininyara.” Papajiwarntirlula palurla marni warrkammayinku, “Jarlu marnalu miyiwarnti payamkujirni nganampakurajawurlu pamarr. Nyanartirni pamarr kirlirni yarntala marnalunya nyanya payikiwarntirla. Nganangu partarnapangurla yutukani payikirla tikirrparni. Minyarti pamarr marnalurla tikirrkanya majawu kajalurnijangka yungupurru. Yarnta pamarrwarntiwarlany nganampakura warntangurnijangka marnalu jalarrapurru martalany payamkujirnupurru.” Marni manyanangu warrkammayintu, “Wali marnanyirrangu jarlujangka pamarr martalany nyurrawarntikura. Ngajirta nganta rayinjarri pamarrngurni. Kunyungurla manyirrangu Ngarpungu Kuttu nyurrawarntikurarlu yutukani yangka manyirrangu purlka nguniny kajalkajal. Nyanartirlu partanyirrangu yutukani nyanarti pamarr.” Nyanartijangka nganpayila manyanangurla kanya Jimiyin jayillajangka papajiwarlany. Nyanartijangka mapirrikujirnurla manya kanya Jawujapkurakarti ngurrakarti. Wartangurnila manyanangurla Jawujap pirriyani tinakarti. Parntawantinyala palunyanta papajiwarnti nyangungalku kajalkajalkujirnupurru maja. Yarnta palurla miyiwarnti yinya yijiwarnti nyantuwarntikura kayilungujangka. Wali Jawujapju manyanangurla japirryinya, “Yara nganta. Yarnta nyurrawarntikura ngarpu wanji nganyirrangu.” Jularnila palurla, “Yu. Yara pa nyantu wanji mimingajirta.” Pinjiminpala nyanya Jawujapju ngajanyankura. Marni manyanangu, “Ya. Minyarti nganyirrangu ngaja wartangurnijangka.” “Yu. Minyartijal marnapangu.” Nyanartijangka ranyjingurni nginyjirrikani ngajanyankura. Yawiyijarrinyala parla. Yarrparnila turtangkarrakanya nginyjirrikanulalku kulkururni rumkarti nyantukurakarti. Nyanartijangka lunganila kaninykaniny rumja. Wali wajapinyala manyanu minngarli ngapajawurlu lungujangka, tikiyanila manyanangurla. Marni manyanangu warrkammayinwarntiwu, “Miyijaa kuyi kangkarnanpangulu.” Wali nyanartijangka kirrarnukujirni manya kirri papajiwarnti kayanngurla kayanngurla. Kayilungujaa kurlilangu pila kirrarnani papajijaa ngaja, kanarlanywarnti palu kirrarnani kaparnjarti. Nyanartijangka marni palurlanyanu, “Nganajangkarlu parlipanya kirrarnukujirni kayanngurla kayanngurla kajalurnijangkangurni warntangurnijangkakarti. Pinarri ngarlipangu.” Wali rayinjarrinyala palu, mil palu purlkajarrinya. Wali yinyala manya miyijaa kuyi. Pinjiminku parla yutukani purlkajinyangu. Ngarnanila palu kinkijartiwurra. ");
INSERT INTO wmt_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","34","Layiwula warrkammayinku parla marni Jawujapju, “Yutukarranyanangu miyi payikiwarntirla wurnapirri. Yarnta man pamarr nyantuwarntikura ranyji yutukarrku payikiwarntirla. Ngajukurajinyangu pakirti man yutukarrku layiwarlanykurarla pingkayikurarla Pinjiminkurarla.” Nyanartijangka kumantawarlanyja palu wurnajarrinya kayili. Jawujapju parla marni wartangurni warrkammayinku, “Waangku manunya wartangurni. Yangka manyanangurla pirriyanku, japirryungkanya, ngajukura pajilu pakirti ngurru warntarnkarranya.” Wali wartangurnila manya warrkammayintu waanya. Pirriyani manyanangurla. Jularni manyanangu, “Yala mantarla pakirti warntarnkarrakanya majakura ngurru, tikirryungkajalu. Marulu parla nyantuwu. Puju kayan ngajanta tikirryungka, wali pungku marnanya. Nyurrawarnti manta ngurrujiwarnti pirriyani.” Marni palurla, “Ngajirta marnalu ngurru warntarnkarrakangkarla nganamparlu.” Nyantungu manyanangu marni, “Kala nyaku ngarnarla payikiwarntirla.” Marni palurla, “Yu. Nyakarla.” Wali parlipinyala Pinjiminkurarla payikirla. Marnila manyanangu, “Mapunparni mantarla minyarti warntarnkanya.” Wali nyanartijangkarlu palurlanyanu langkirrmani kuwutwarnti papajiwarntirlu yawiyirlu. Pujurnila palu tikiyani majakarti kaparnngurni Yijipkarrajikarti. Wali Jawujap manyanangu kulijarrinya. “Nganajangkarlu pajanta warntarnkarranya ngajukura pakirti,” manyanangu marni. Jutangu parla marni, “Kayan ngarnangulurla jangkumanta. Minyarti yurru marnalu jarlujangka warrarni martarnana nganamparlu. Kayan ngarnalunyanta rukanyja. Wali warrkammarnanku marnangulu nyuntuwu nirnparni.” Yarntarni manyanangu marni Jawujapju, “Ngajirta. Kayantu paji ngurrujirlu warntarnkarranya ngajukura pakirti. Nyanartirlu paji warrkammarnanku layingu yangka paji warntarnkarranya pakirti. Nyurrawarnti wali manta tikiyanku kayili ngarpukarti nyurrawarntikurakarti. Pinjimintu paji warrkammarnanku. Jutangula parla marni, “Ngajirta. Ngarpu nganampakura ngarta pirlajarri. Pinjimin nyantukurajinyangu parla walaku. Kayan ngarnalu tikiyanta marlal. Yawiyi marnalurla ngarpuwu nganampakurawu.” ");
INSERT INTO wmt_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","28","Nyanartijangka Jawujapju manyanangu yawiyijarrinya papajiwarntiwu. Lunganila manyanangurla. Yini manyanangurlanyanu jularni, “Ngaju marna Jawujap nyurrawarntikura ngaja. Ngajukura ngarpu yara ngarta wanji.” Nyanartijangka papajiwarnti palurla rayinjarrinya. Ngajirta palunyanta jangkumantarla. Wali Jawujapju manyanangu marni, “Ngajirta nganta rayinjarri. Yantajilurla ngajukarti marnpa. Ngaju marnanyirrangu ngaja yangka manyalu jarlu yinya kamuljartiwarntirlu pamarr. Payamkujirni pajalu ngaju. Wurnala pajanta yiparni minyartikarti Yijipkarti. Ngajirta ngantanyanu nyurrawarntirlu ngirtilykarra jula, ngaju paja Ngarpungu yiparni Kuttu. Ngajirta pajanta nyurrawarntirlu yiparla. Ngarpungu paja kanya. Nyanartijangka paja warrkam minyarti yinya miyi ngampurrikanupurru. Piyirnwarnti paja marrijangkawarnti mapirrirni marnanya yunganku. Nyanartipurru paja minyarti warrkam yinya tuwanga miyi ngampurrikanupurru.” Yarntarni manyanangu marni, “Kayan ngarlipangu ngapa wanti miyipurru turtangupurru. Yukajaa mana warrarni pa lalka ngunanganku. Miyi pa ngunangana minyayirlamiparni Yijipja munyal. Nyanartijangkala paja Ngarpungu yiparni yungupurru ngajukurawarnti piyirnwarnti jarntuwarnti. Kayan ngarlipa pirlajarri. Yapajirnanyunguwarnti mapirrirni palu ngunanganku wanji. Ngarpungu paja majakujirni minyayirla Yijipja kujartipurru.” Yarntarni manyanangu marnani, “Tikiyanku manta ngalimpakurakarti ngarpukarti. Julawu mantarla ngaju minyayirla kirrarnujangka, yangka pajalu jarlu yap kanya kamuljartiwarntirlu Yijipkarti. Yara marna wanji kirrarnana. Kujarti mantarla julawu. Partalurnila paji pirriyanku. Kirrarnankula manta nukarni ngajungarni marnpa. Nyanartijangka miyila marnanya yunganku nyurrawarntijaa ngarpu ngalimpakura mapirrirni yangka kajinta ruwanguliny purpanku minyartikarti.” Nyanartijangka lawukanila Pinjimin yarnta ngukupajanurla manyanta lungani. Kanarlanywarnti mapirrirni manya lawukani. Yarnta manyanangurla lungani papajiwarntirla. Wali wangkikarra palu kirrarnani. Wurnajarrinyala palu papajiwarnti kayili Kayininkarti. Pirriyanila palurla Jayikapku. Yinya palurla miyi ngarpunyankura. Marnila palurla, “Nyanya marnalu Jawujap nganampakura ngaja yangka palu jarlu yapkanya. Jalarra manyanangu nyantu maja kirrarnana Yijipja. Miyi manyanangu ngampurrikanana.” Wali Jayikap parla purrpurrmarni. Marni manyanangu, “Mapun ngartaji ngajukura walaku wanji. Partalurnila pajanta nyantukarti kangku. Ngajirta ngarna pirlajarri jutparni nyangungajirtajangka. Nyaku marnajin wanjingurnikarra.” Nyanartijangka marni manyanangu walakunyankurawarntiwu wirriyarlu, “Manawarnti pikakujilu. Wurna parlipa yanku.” ");
INSERT INTO wmt_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","34","Nyanartijangka jakarnila palu kurlirra. Kaparn palu lamajarrinya ngurranga. Kamparni parla kuyi Jayikapju kajalkajalkujirnupurru Ngarpu. Nyanartikarra pukanyja parla marni Ngarpungu, jularni yini, “Jayikap. Ngajirta ngan rayinkarri Yijipkarti yanupurru. Yara man yanku. Ngaju marnanyirrangurla mapirrirni yananku. Yarnta marnanya pikakujiwu yapajirnanyunguwarnti nyuntukurawarntijangka walakuwarntikurajangka. Walimpawarlany marnanya tikirrkangku minyartikarti Kayininkarti yapajirnanyunguwarnti.” Nyanartijangka kanya manya Jayikapju nyantukurawarnti walakuwarnti kartujartiwarnti lamparrwarntijaa kilakiwarnti yarnta nganapartu nganapartu manawarntijaa kukunjawarntijaa nanikutwarnti kamulwarnti manajartiwarnti mapirrirni. Nukarnini manya kanya nyantukurawarnti piyirnwarnti. Nyanartijangka pirriyani manyanangurla Jawujap. Jirrkirlparnila manyanta yani ngarpunyankurakarti. Ngamurlamanurla pilanyanu lungani wapirrarlu. Nyanartijangka marni parla Jayikapju, “Wali marnanya martarnanku wanjingurnikarra nukarni ngajukurawarnti walakuwarnti.” ");
INSERT INTO wmt_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","12","Nyanartijangka Jawujapju manya kanya papajinyankurawarnti murrkurn 5 japirlyungupurru king. Marni palurla, “Wanyjarrarla marnalunya yukanga martarnanku kukunjawarnti. Yarnta nganampa mapirrirni, wanyjungu marnalu kirrarnanku.” Kingju manyanangu marni, “Yu. Wali manta kirrarnanku kakarra ngurranga Kujunta.” Wali kirrarnani palu nyanayirla. Ngampurrikanani palunya kukunjawarnti. Nyanartijangka Jawujapju kanya ngarpunyankura kingkarti. Nyaku pa kingju. Wali Jawujapjula parla kingku marni, “Minyarti paji ngajukura ngarpu.” Kingju parla nyangungurla marni Jayikapku, “Nyangurlakarrajangka man.” “Ngaju marna jarlujangkajinyangu. Yitilalwarnti paja 130 marna ngunangani.” Nyanartijangka Jayikapju parlanyanta japirlyinya Ngarpu kingku. Wali tikiyanila Jayikap kakarra ngurrakarti Kujunkarti. Nyanayirla palu kirrarnani. ");
INSERT INTO wmt_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","21","Jayikap pa walimpawarlany pirlajarrinya nyanayirla Yijipja. Lunganila palurla walakuwarntirlujaa jarntuwarntirlu mapirrirni pirlajarrinyujangkawu. Nyanartijangka palu maparni mirrijinjawurlu jarnngukarrarla. Yangka palu lungujangka lamajarrinya walimpa, kanyala palu kayili karrkin nyantukura Kayininkarti. Yutukanila palu nyanayirla najinga yangka palunya jarlu yutukani nyanayirla nyantukurawarnti kilakijaa ngawiji ngarpujaa ngamaji mapirrirni. Wali nyanartijangka palu tikiyani kurlirra Yijipkarti. Nyanartijangka marni palurlanyanu Jawujapkurawarntirlu papajiwarntirlu, “Kunyungurla parlipangu Jawujap warrarni nguniny kuli yangkartijangkangurni jarlujangkangurni. Jawujapju parlipanya kunyungurla ngunyipungku jirna. Kuli partarlipangu nguniny warrarni yangkajiliny parliparla ngalimpa jarlu kulijarrinya. Ngalimpakura parlipangu ngarpu jarlu pirlajarrinya purntumanupurru.” Wali Jawujapkarti palunyanta yani papajinyankurawarnti. Parntawantinyala palanta, kajalkajalkujirni palu Jawujap. Marni palurla, “Nyuntuwu marnangulu ngunawu warrkammayinwarnti, mapunikanankula marnangulurla nyuntunga.” Wali Jawujapju manyanangu marni, “Ngajirta ngajinta rayinkarri. Ngaju marna yara. Ngajirta marna ngaju Ngarpu purlka, yarr marna piyirn. Kayan ngarnanya pungka yakurrngurni Ngarpujilinyju. Kujarti manta pinapinakarrinya pirlawurra kurrkunga tarrapungupurru, yarnta marri yiparnupurru piyirnwarntiwarlanykarti. Ngaju paja Ngarpungu jirrkirlkujirni, yangka marnarla jularni minyartikarrajiwu kingku miyi martarnupurru tanyjingu. Nyanartijangka paja jinjinyinya miyi purlkakujirnupurru, yarnta ngampurrikanupurru walimpawu. Nyanartijangka marnanya miyi yinya marranyanjartiwarnti. Yarnta marnanya ngajungu wanji martarni miyi yungujangkarlu. Kujartikarra paja Ngarpungu jirrkirlkujirni.” Yarnta manyanangu marni Jawujapju, “Ngajirta ngajintarla rayinkarri. Ngajungu marnanya ngampurrikananku nyurrawarnti, yarnta yapawarnti mapirrirni.” Nyanartijangka Jawujapkurawarnti papajiwarnti palurla wirriyajarrinya, yarnta palurla yawiyijarrinya. ");
INSERT INTO wmt_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","26","Walimpawarlany Jawujap purrkujarrinya. Marnila manyanangu jarntuwarntiwu, “Ngaju marna purrkujinyangu, jamurnjamurnjarrinya paji pirlajarrinyupurru. Nyurrawarnti manya Ngarpungu ngampurrikananku wartangurni. Yarnta manyirrangurla jarrkanganku Yijipngurni Kayininkarti. Jarlu parla Ngarpungu pinakanya Ayiparanku nyanarti ngurrara Kayinin. Ngaju mapirrirni pajalu kangku karrkin Kayininkarti yapajirnanyunguwarntirlu ngalimpakurawarntirlu.” Wali Jawujapju parlanyanu kujarti pikakujirni. Ngajirta ngalunyanta rukanyja. Nyanartijangka marlaljarrinyala Jawujap. Mirrijinjawurlu palu maparni karrkin nyantukura. Yutukanila palu ngurtinga pirla. ");
INSERT INTO wmt_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","22","Jarluwarlany ngurra manyanangu Juwujwarntiwu yakurrjarrinya. Miyingajirta palu ngunangani. Ngapa ngajirta wantirla nyanayirla. Ngajirta yatuwurra pajarrarla nyanartipurru miyiwu turtangupurru. Wali layi nganpayi Juwuj yini parla Limilikjaa kartunyankura Nayami pila. Ngarpukurajarra ngunangani Pajilimja. Nyanartijangka miyi ngajirtajinyangurla palu nguja. Wali nyanartijangka pila wurna jakarni kakarra parrijarra mapirrirni pinyalu kanya nyantujarrakura walakujarra. Pajilimngurni pila jakarni kakarra wamarn Muwapkarti. Pakulyani palu Muwapkarti. Nyanartijangka pila nguja yinkirni kitangarni pila parrijarra purlkajarrinyani nyanayirlarni Muwapja. Limilikpala pilangu pirlajarrinya ngarpunyankura Muwapja. Nyanartijangkajarra pilanya kartujarra warntarni Muwapkarrajijarra Limilikkurajarrarlu walakujarrarlu. Nguja palu nyanayirlarni Muwapja. Walimpawarlany pila pirlajarrinya nyanartijarra nganpayijarra paparlangu. Layila pilangu wanji nguja ngamaji Nayami. Nyanartijangka Nayamirlu parlanyanu marni, “Tikiyanku marna ngajukurakarti ngurrarakarti. Ngajirta ngarna minyayirla kirranyja.” Nyanartijangka jakarnkarrakanyala tikirr Pajilimkarti karla. Walilpinyala pila ngunyarri nyantukurajarrarlu. Marni pilangu, “Tikiyanku manpilanyanangurla nyurrajarrakurawarntikarti piyirnwarntikarti. Kirralku manpila jarntuwarntirlajaa ngamajirlajaa ngarpunga.” Wali nyanartijangka layiwarlanyju jutungurni wajilpinya. Jarti ngunyipungurla kanyala pa mapirri. Pirrikanyala pa Pajilimja. Pajangu piyirnwarntirlujaa marninwarntirlu pinyalu nyanyangurra nyanartikarrajiwarntirlu Pajilimkarrajiwarntirlu. Nayami palu nginyjirrikani. Marninwarlany palu jarti nginyjirringinyjirrikani ngayi. ");
INSERT INTO wmt_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","23","Nyanartijangka pila Pajilimja kirrarnani miyingajirtajarti ngunyarrirlangu nyanartijarra yinijarra Nayamijarra Ruj. Kirrarnani pila pamarrngajirtajarti, tumaj palu Juwujwarntirlu ngajirta palunya kalkarrawarnti pinjina yungantarla. Nyanayirla ngurranga Pajilimja palurlanyanu ngurrujarra kiyi jurajijiliny tarrapungani, miyila turtangani. Pukarrjarrinyujangka ngurrujarrarni palurlanyanu warrpungani nganpayiwarntirlujaa marninwarntirlu. Yangka palurlanyanu ngarrjarni warntarnani, yangkala manyanangu purlka ngunangani, wartangurnila palu warrumanani marninwarntirlu pamarrngajirtajartiwarntirlujaa miyingajirtajartiwarntirlu. Nyanarti kirlijangka palurlanyanu warntarnani. Ngurrakartila palurlanyanu kangani ngarnupurru. Nyanarti miyi palu warrpungujangka kangani ngurrakarti, talykarrjiliny palu rawukarra luwarnani pamarra, kamparnanila palu warlunga. Wali miyi nyanartikarra pulparr pa ngujangurra warrpungupurru. Japirlyinya parla Nayami Rujju, “Yanku marna warrkamjurra. Miyi marna warntawu, ngalkula parli.” Jangkumani manyanta, “Yanta ngajukura kurntal. Warrkammalku mantarlingurla miyiwu, nganangula parlinya yungku.” Wali marnin nyanarti yani nyanartikarti warrkamkarti kirliwarntipurru warntarnupurru. Nyanayirla yartta pa warrkammarnani Ruj. Ngurrparni parla nganpayiwu nyanartiwu ngujangurra majawu yiniwu Puwajku, Nayamikura parla walakuwarlany marnpajangka. Pirriyani nyanarti nganpayi maja Puwaj ngurrangurni nyantukurangurni. Parlipinyala Ruj warrkammarnujangka. Japirlyinyala parla nyantukura warrkammayin, “Ngana marnin minyarti.” Jangkumani pa, “Marnin nyanarti yangkarti Nayamirlu pirrikanya ngunyarrinyankura. Nyanawurlu marnintu paja japirryinya warrkampurru minyayirlapurru minyartijangkawarnti kirliwarntiwu japurnupurru. Nyangani marna jarlujangkarlurni warrkammarnani. Ngajirta manyanu jurumanantarla,” marni parla warrkammayintu Puwajku. “Ya,” marni parla Puwajju. Wali yanungurla parla marni Rujku Puwajju, “Ngajirta ngan pakulyanta minyartingurni yartngurni. Minyayirlarni man warrkammalku ngajukurarlarni nganpayiwarntirla wartangurni.” Ngurrpangu parla Rujju marni, “Nyapartu pajin ngajuwu wulyuwulyu marnana. Ngaju ngajirta marnangu jarntu, marrijangka marna.” Nyantungula parla marni Puwajju, “Pinakarrinya marnanya piyirnwarnti wulyu mantalu jularnani, Nayamirla manyanta lapantinya. Wanyjani manunya nyuntukurawarnti jarntuwarntijaa ngamajijaa ngarpu.” Nyanartijangka miyi palurla Rujku ngarrjala tarrangani nganpayiwarntirlu warrkammayinwarntirlu. Nyanartijangka ngarrjala parlanyanu kirninymanani Puwajkurajangka mapirri. Kanyala nyantukurakarti ngurrakarti Rujju, yinyala parla Nayami miyi purlkajaa wangkiwarnti parla jularnani nyapartukarra nguja warrkamja. Nganpayi parla nyanarti Puwaj jularni Nayamiwu. ");
INSERT INTO wmt_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","18","Layimirri parla marni Nayamirlu Rujku, “Nganpayi marnangu jalarra parlipungku nyuntuwu ngumparna, nganpayi nyanarti Puwaj.” “Yu. Wali. Nyuntunga marnangurla mapunikarrku.” Nayamirlu parla jinjinyinya, “Yantanyanta Puwajkarti, parlipungku man mayarurla warrpungupurrurla. Yanungurla manyanta jinamartaji yukuyanku.” Wali Ruj manyanta yani Puwajkarti mayarurlurra warrpungupurrurlurra. Yanungurla manyanta jinamartaji yukuyanurramarni, manyan yukarnujangkarla. Pukanyjala parnkijarrinya Puwaj, karrpirlparnila, marninpala parlipinya jinanga yukarnanujangka. Kujartikarra manyanangu nyantuwarntikura kartiny, yangka ngumparnarlu nganpayirlu palunya kalkarra warntarnani. Puwajju parla marni, “Ngana man nyuntu.” Jangkumani manyanta, “Ngaju marna Ruj. Nyuntukarti marnangurla yani ngumparnakarti jarntukarti.” Puwajjula parla marni Rujku, “Ngajirta marnangu ngumparna jarntujinyangu. Nganpayi layiwarlany mangu nguniny jarntujinyangu. Japirlyungku marnalurla nganpayi nyanarti nyapartukarra malku.” ");
INSERT INTO wmt_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","22","Nyanartijangka kumantawarlany parla pirriyani nyanartiwu nganpayiwu, marnila parla pajanga purrkuwarntirla majawarntirla, “Warntawu ngan nyuntungu ngurra ngalimpakurarlu papajirlu wanyjani pirlajarrinyujangkarlu. Pirlajarrinya parlipangu.” Jangkumani manyanta nyanawurlu nganpayirlu, “Yu. Warntawu marna ngurra.” Marnila parla Puwajju, “Ngurra man nyanarti warntawu marnin nyanarti kalkarra mapirri Nayamikura ngunyarri.” “Ngajirta. Kayan ngarna warnta nyanarti ngurra marnin mapirrijarti. Nyuntungu warnta,” marni parla Puwajku. Nyanayirlarni pajangarni manyanu nganpayiwarlanyju kurtamani jinangajangka yakapiri kayan, yinyala parla Puwaj. Nyanarti manyanu kurtamani nyanawurlu nyantukura jinangajangka, nirn parla wali wulyu nguja. Yakapiri parla yinya pinakarrinyupurru. Kayan ngarta marninjaa ngurra tikirrkuji. Kujartikarra palu ngunangani jarlu nyantuwarntikurarla ngurranga Juwujwarnti. Nyanartijangka ngujala pila nyanartijarra jamirlangu Rujjarra Puwaj. Walimpa pila parrila martarni yini parla Wupit. Nganpayiwarlany Tayipit wartangurnijangka nyanarti parla parri Wupit kilaki. ");
INSERT INTO wmt_vpl VALUES ("S11_1","010_1_1","1SA","1","1","28","Nganpayi nyanarti ngunangani marninkujarra kurrinyjarti yini Yilkana. Nyantu pa Ngarpukura. Marninwarlanyju parlanyanta jarti nyangani yapawu yiningu Yanangu. Yarringarnani parlanyanu marninwarlany yapajarti. Marnani parla, “Nyuntu man yapangajirta.” Yangkala kurntayikujirnani Yana. Wali yitilalwarlany yitilalwarlany palu yanani ngurrawarlanykarti Jalukarti. Nyanayirla pa ngunangani kaluku Ngarpukura mayarujilinyparni jujupurrujaa mitingpurru. Wali yangkartiwarnti palu yani jamirlanyjarti. Kujarti palurla kangani yiji Ngarpuwu kuyi. Nyanartikarrarni manyanu yarringarnani nyanarti marninwarlanyju yapajawurlu yitilalwarlany yitilalwarlany. Wali pinapinakarrinyani marnintu Yanangu yapawu martarnupurru. Luyurrmarni ngaru kaninykaniny. Nyanartijangka pa yani jintanga Ngarpuwu japirlyungupurru. Takurryanila kalukurla. Lungukarrarlu parla Ngarpu japirlyungani. Marni parla, “Parri pajan yungku. Yangka marna martawu nyanarti yapa, tikirryungkula marnanta nyuntu warrkampurru. Warrkammarnanku mangu parrijangkarlu kitangarni purrkujarrinyurla pirlajarriwu.” Pajangal parla japirlyungani tikirrparni tikirrparni Ngarpuwu. Wali nganpayi parla Ngarpukurajinyangu puris kirrarnani warntarrirla takurryanupurrurla, yini Yilayi. Nyanarti warrkam parla nyantukura kalukumiparni ngampurrikanani Ngarpukura. Wali kirlingirringurni nyangani marnin nyanarti tamtammarnani lirramipa. Ngajirta pa pinakarrirla wangki marnujangka. Kula pa wangarta marnani ngapajangka. Yilayirlu parla marni, “Ngajirta ngan wangartajarri, wanyjarrku man ngapa nyanarti. Wulyu man ngunawu.” Jangkumanila manyanta, “Ngajirta marna ngaju wangarta, ngaju marna wulyu. Yawiyi marnajin nguniny, japirlyungani marnarla Ngarpuwu.” Nyantungula parla purturu marni Yilayirlu, “Wali yanta. Ngarpungu manta yungku, yangka man japirlyungany.” Wali tikiyani manyanangurla jarntuwarntikarti nyanarti marnin, wirriyajarrinyurla. Nyanartijangka palu tikiyani jampirlangujarti nyantuwarntikurakarti ngurrakarti. Nyanartijangka yapajartijarrinya nyanarti marnin yangka lirramiparni tamtammarnani, parrila martarni Jamiyurl. Wali purlkakujirni ngamajirlu. Wanyjanila ngamarna, ngajirta ngamarna ngarnantarla purlkajarrinyjangkarlu. Nyanartijangka tikirrkanyala Jalukarti marnintu ngamajirlu Ngarpukurakarti kalukukarti. Yinya parla Yilayi nyanartikarraji puris. Wanyjanila manyanta nyantunga Ngarpukura warrkam pinarrijarrinyupurru. Walila warrkammarnani kitangarni purlkajarrinya nyanayirla kalukurla. ");
INSERT INTO wmt_vpl VALUES ("S12_19","010_2_19","1SA","2","19","26","Wali yitilalwarlany yitilalwarlany manyanta najanu yanani ngamajinyankura. Kanganila parla mana mintimjangka kuwutjilinyparni. Nyanartijangka yawiyirlula parla yarntarni yinya Ngarpungu. Kanarlanywarnti wartangurnijangkawarnti manya Yanangu yarntarni martarni yapawarntiwarlany parriwarnti murrkurn, mangajarra kurriny. Yangkarti parri kajalurnijangka Jamiyurl warrarni parla warrkammarnani Ngarpuwu kalukurla Ngarpukurarla. Nyanartijangka Yilayikurajarra walakujarra pila purisjarra ngunangani. Warrkammarnani pila Ngarpukurarla kalukurla. Ngajirta pila jirrkirl warrkammarnantarla, ngajirta pila Ngarpu mapunikanantarla, kurrinykurriny pila ngunangani. ");
INSERT INTO wmt_vpl VALUES ("S13_1","010_3_1","1SA","3","1","21","Nyanartijangka pukanyjajarti yukarnani rumwarlanyja nganpayi Yilayi. Nyantu pa purrkujinyangu. Mil pa puyujarrinya jamurnku jankawu. Parri pa rumwarlanyja yukarnani. Wali Ngarpungu parla marni. Taj jularni yini jamurnku rakarra kangupurru kunyungurla mungangarni. Wali jangkumani parringu, “Yu,” marni parla. Wali laparnila nganpayikarti Yilayikarti. Marni parla parringu, “Nyuntungu ngajan jularni.” Nyantungu parla marni, “Ngajirta marnangu ngajungu papajarrarla. Tikiyanta manyankarti.” Wali tikiyanurla yukarni. Yarntarni jularni Ngarpungu. Marni parla, “Jamiyurl.” Yarntarni yani Yilayikarti. “Nyuntungu ngajan jularni.” Yarntarni parla marni Yilayirlu, “Ngajirta. Tikiyanta manyankarti.” Murrkurnmirri parla marni Ngarpungu. Nyanartijangka nginyjirrikani Yilayirlu, kunyungurla parla Ngarpungu marnana. Wali Yilayirlu parla marni, “Tikiyanurla yukanyja. Puju mangu yarnta malku nyanarti Ngarpungu, wali jangkumanku man. Malku manurla, ‘Pinakarrilany marnanta nyuntukurarlu warrkammayintu.’” Wali tikiyanurla yarntarni yukarni. Nyanartijangka Ngarpula manyanta pirriyani marnpa. Karrinyungurni parla marni, “Jamiyurl.” Kurrinymirri pa taj jularni yini. Jamiyurllu jangkumani, “Julaji Ngarpu. Pinakarrinyana marnanta nyuntukurarlu warrkammayintu.” Ngarpungu parla jularni, “Yilayikurajarra walakujarra yakurrjarra pila. Ngajirta pila jirrkirl wulyuwulyu warrkammanyja kalukurla ngajukurarla. Ngajirta pilangu Yilayirlu jarrmanyjarla. Pungkula marnapinya nyanartingurni warrkamngurni.” Kujarti parla marni Ngarpungu Jamiyurlku. Wali nyanartijangka Ngarpungu pa wangki nyanarti pujumani. Wanyjanila Jamiyurl. Ngajirta pa Jamiyurl partalurni turtangkarla, warrarni pa yukarnani, kitangarni kumantajarrinya. Nyanartijangka turtapinya wartangurni yangka Ngarpungu wanyjani. Warrkammarnani pa Jamiyurllu kulkururlu, ngajirta parla winkirrjangka jularla Yilayiwu, tumaj pa rayinkarrinyani. Nyanartijangka papajani parla parriwu, “Mirnu yanani parri ngajukura.” Jamiyurllu manyanta jangkumani, “Yu. Minyarti marna.” Yilayirlu parla marni, “Ngana mangu jularni Ngarpungu. Julaji. Ngajirta ngan kulkuru karrinyanta.” Nyanartijangka Jamiyurllu manyanta jangkumani. Jularni parla wangkiwarnti nukarnini yangka parla Ngarpungu jularni. Yilayirlula parla marni, “Yu. Wali Ngarpu pa kayan purlka. Maja parlipangu nyantu wulyujuwal.” ");
INSERT INTO wmt_vpl VALUES ("S14_1","010_4_1","1SA","4","1","1","Walimpa palu pirriyani Pilijayinwarnti, pinyala palunyanu Juwujwarntirlujaa Pilijayinwarntirlu. Nyanartikarrarni pinyalu pinya Yilayikurajarra walakujarra pirlawurra, yarnta kanarlanywarnti mapirrirni. Yangka parla jularni takiwurra Jamiyurlku Ngarpungu jarlu. Wali nyanartijangka yangka Jamiyurl purlkajarrinya nganpayijarrinya, wali nira parla kujartijiliny jularnani Ngarpungu takingu. Purlkala manyanangu ngunangani nganpayi Jamiyurl majajilinyparni Juwujwarntiwu puraput. ");
INSERT INTO wmt_vpl VALUES ("S18_1","010_8_1","1SA","8","1","22","Nyanartijangka Jamiyurl pa purrkujarrinya walimpawarlany. Kurriny walakujarra pinya martarni. Nyanartijangka pinya purlkakujirni. Maja pilanyanangu ngunawu Juwujwarntiwu. Wali ngajirta pila mapunjijarra Ngarpu mapunikanujuwal, pamarr warntarnjuwal pila ngunangani. Wali yakurrmarnani pilangulu Juwujwarntirlu nyantujarra pila pamarr warntarnujuwalkujarra, ngajirta pila ngarpujiliny ngunangantarla Jamiyurljiliny. Nyanartijangka palanta yani Jamiyurlkarti purrkuwarnti Juwujwarnti japirlyungupurru. Marni palurla, “Kurajpungku marnanpangu nganpayiwarlany. Purlka marnapangu ngunawu king. Nyuntu man purrkujinyangujarrinya. Kayan ngarnapangupila nguna nyuntukurajarra walakujarra, tumaj pila jirrkirl ngajirta.” Wali ngajirta parla wulyumanyjarla Jamiyurllu wangkiwu nyanartiwu king kurajpungupurru. Ngarpuwula parla purayimarni. Jangkumanila Ngarpungu Jamiyurl, “Yangka palurla majawu wulyumalany kingku, wali nyanarti. Ngajula pajalu wartangurnikujirni. Ngajirta pajalu ngajuwu mapunikarrarla.” Nyanartijangka jarti manyanangu jarrmarnani Jamiyurllu. Marni manyanangu, “King pa manawarnti warntarnujuwaljaa warrkammayinkujirnujuwal. Nira mantarla warrkammarnanku. Yakurrmalku mantarla walimpa, puju manta yumpaljarriwu.” Wali jarti manyanangu marni. Nyantuwarntirlu palurla marni jutungurni, “Ngajirta. Kingku marnalurla wulyumalany.” Wali Ngarpungu parla marni Jamiyurlku, “Mapunikarrku mannyanangu kingpurru warntarnupurru.” ");
INSERT INTO wmt_vpl VALUES ("S19_15","010_9_15","1SA","9","15","17","Wali kanarlanyja purangu yarnta parla marni Ngarpungu Jamiyurlku, “Kumanta marnangu yipawu nganpayi. Nginyjirrikarrku man king. Purtkujiwula mananta ayiljawurlu pinalkarrapurru. Nginyjirrikarrkula manyanu kurajpungujangkarlu.” Wali kumantajarti manyanta pirriyani nganpayi yini Juwul. Yangka Jamiyurllu nyanya, nginyjirrikanila. Ngarpungu parla marni nyanartikarrarni, “Minyarti pa nyantu.” ");
INSERT INTO wmt_vpl VALUES ("S19_25","010_9_25","1SA","9","25","25","Nyanartijangka ngurra layi manyanta yukarni Jamiyurlla. Kumantala pila turtapinya. Pakulpala pila yani, rirringkingurni manyanta jatkarrinya. ");
INSERT INTO wmt_vpl VALUES ("S110_1","010_10_1","1SA","10","1","17","Wali nyanartijangka Jamiyurllu warntarni ayil, purtkujirnila manyanta jurlunga Juwulla. Marni parla, “Juwujwarntiwu mananangu ngunawu king purlka. Marlamanku manunya, puju ngananguwurti manya pungku kuliparirlu marrijangkarlu. Wali Ngarpungu manta kurajpinya nyuntu, nyanartijangka marnangurla purtkujirnana.” Nyanartijangka wurnala yani Juwul jarntuwarntikarti. Wali ngajirtarni manyanangurlanyanu jularla kingkujirnujangka, kulkururni pa kirrarnani. Nyanartijangka Jamiyurllu manya marurrpinya Juwujwarnti mitingpurru jujupurru. Nyanartikarrarnila manyanangu julawu. Yanku palu mayarukarti Mijpakarti. Wali warryani palu, kirrarnanila palu mitingja. ");
INSERT INTO wmt_vpl VALUES ("S110_22","010_10_22","1SA","10","22","26","Juwul pa ranyji kirrarnani manawarntirla. Wali Jamiyurllu manya yiparni kanarlanywarnti purpanupurru Juwul, tumaj pa nyantu kunyungurla kurntayi. Palkangakujirnila palu nyangupurru. Wali Jamiyurllu manyanangu marni, “Minyarti nganpayi kurajpinya Ngarpungu, maja manyirrangu ngunawu king.” Wali ngarrurtarlu palurla papajanani Juwujwarntirlu. Marnani palurla Juwulku, “Rawa marnanpangu ngunawu maja king.” Nyanartijangka lirrkarnpinya manya Jamiyurllu nukarnini nyapartukarra pa Juwulkura warrkam ngunawu. Wali miting pujujarrinya, jaarlanila palunyanu ngurrawarntikarti. Kanarlanywarntirlu nganpayiwarntirlu palu wajilpinya Juwul. ");
INSERT INTO wmt_vpl VALUES ("S115_1","010_15_1","1SA","15","1","9","Layimirri manyanta pirriyani Jamiyurl Juwulkarti wangkijarti. Jularni parla Juwulku, “Ngarpungu paji jularni yakurrwarnti pungupurru. Pungku manunya piyirnwarnti Malakayitwarnti. Wali pungku manunya Juwullu pujurni. Ngajirta nganunya kanarlanywarnti jarnmanta, pungku manunya pujurni piyirnwarntijaa marninwarnti, yapawarnti kuyiwarnti nyantuwarntikura mapirrirni. Warpiny manunya pungku purlumanjaa tangki, kamuljaa kukunja. Ngajirta ngan kayanwurti wanyjarra. Nyanartijangka manya Ngarpungu ngulikani. Yangka palunya jarlu pinya Ngarpukurawarnti kilakiwarnti, yangka manya Mujijju ruwa kangani Yijipngurni, nyanartikarra palunya pungani Malakayitwarntirlu Ngarpukurawarnti.” Wali nyanartijangka Juwul pa yani, marurrpinya manya nyantukurawarnti kulipariwarnti. Pungkula palunya kurlirra. Nyanartijangka ngajirta palunya pujurni pungkarla, layi palu nganpayi wanyjani wanji nyantuwarntikura kingjaa kuyiwarnti jurnankarrawarnti. Tikirrkanya palunya wanji. ");
INSERT INTO wmt_vpl VALUES ("S115_10","010_15_10","1SA","15","10","15","Wali Ngarpungu parla Jamiyurlku jularni, “Ngajirta paji mapunikarrarla Juwullu, wanji manya kanya kanarlanywarnti.” Nyanartijangka Jamiyurl manyanta yani Juwulkarti. Juwullu parla marni, “Pinya marnanya yangkartiwarnti, yangka pajin jularni.” Wali Jamiyurllu marni, “Wayila. Pinakarrilany marnanya purlumanwarntijaa kukunjawarnti lungujangka. Wanyjarrajangkawarnti palu nyanartiwarnti lungana.” Juwullu manyanta jangkumani, “Ngajirta. Ngajukurawarntirlu palunya kangana. Ngarpuwu marnalurla jarnmani.” ");
INSERT INTO wmt_vpl VALUES ("S115_22","010_15_22","1SA","15","22","23","Jamiyurllu parla marni Juwulku, “Ngarpungu parla mapunjinyangu wulyumalany mapunikanupurru nyantukura wangki wulyujinyangu, ngananguwurti parla nyantuwu piyirntu mapunikarrku. Kunyungurla man nyuntungu kujarti pinakarrilany yiji yungungurla wirriyakujirnupurru Ngarpu mapunikanungajirtarlu.” Yarntarni parla Jamiyurllu marni, “Wali manu ngumujilinyparni wanyjarralany Ngarpukura wangki, nyanartijangka manta nyuntu kujartirni rantangakujiwu Ngarpungu. Kanarlany king pa kurajpungku.” ");
INSERT INTO wmt_vpl VALUES ("S115_35","010_15_35","1SA","15","35","35","Nyanartijangka Jamiyurllu wanyjani Juwul nirnparni. Ngajirta parla yarnta tikiyantarla. ");
INSERT INTO wmt_vpl VALUES ("S116_1","010_16_1","1SA","16","1","5","Wali nyanartijangka Ngarpungu parla marni Jamiyurlku, “Ngajirta nganurla kujarti lunganta Juwulku. Kanarlany marnanta nganpayiwarlany pinarriyungku. Kurajpinya marnangu kingwarlany Jisikurajangka walaku. Yanku man Pajilimkarti ayiljarti purtkujirnupurru.” Nyanartijangka yani, kanya pinya ayiljaa kuyi. Ayil pa kanya ranyjingu Juwullamarra. Pungka ngarta Juwullu. Kuyi pa kanya warraja yiji yungupurru Ngarpu. Wali pirriyani manyanangurla Pajilimja purrkuwarntirla. Nyanyala palu, marnila palurla, “Nganapurru man nyuntu mirnu pirriyani nganampakarti.” Jangkumani manyanangurla Jamiyurllu, “Ngajirta. Kuyi marna kanya, Ngarpuwu marnarla pungku. Nyurrawarntirla marnanyirrangurla pungku minyayirla Pajilimja marnpa. Wali warryanku mantarla mitingpurru, nyanartikarrarnila marnanyirrangu kuyi pungku.” ");
INSERT INTO wmt_vpl VALUES ("S116_6","010_16_6","1SA","16","6","14","Wali Jisingurra palunyanangurla pirriyani wapirrajarti mitingkarti. Jamiyurllula nyanya layiwarlany nganpayi wulyujinyangu karrkinjaa janginy Jisikura walaku. Pinapinakarrinya, “Kunyungurla pa nganpayi minyarti kurajpinya Ngarpungu.” Ngarpungu parla marni, “Ngajirta ngan nyaka karrkinjaa janginy yara, wali ngajungu marna nyangany turlpu kaninykaniny. Ngajirta marna minyarti nganpayi kurajpungka. Kanarlany marna nyangany ngajungu.” Nyanartijangka kanarlanywarnti manya kanya walakuwarntiwarlany Jisingu Jamiyurlkarti. Kayanngurla kayanngurla palunyanta pirriyani Jamiyurlkarti. Jularnila parla Ngarpungu, pajangalmirri Jamiyurlku, yangka palanta tirrinyyanani. Marnani parla nyanartikarrarni, “Ngajirta ngan minyarti kurajpungka.” Nyanartijangka Jamiyurllu parla japirlyinya Jisi, “Wayila palu nguniny kanarlanywarnti.” “Yu,” marni parla, “Layiwarlanyju manya warrkammarnana kukunjawarnti wartangurnijangkarlu.” Wali Jamiyurllu manyanangu marni, “Kaj. Purpantalu. Jurumanku parliparla mitingpurru.” Wali pirrikanya palu yini Tayipit. Jamiyurlkula parla jularni Ngarpungu, “Minyarti nganpayi marnangu jularni. Purtkujiwu mananta ayil.” Nyanartijangka ayil pa warntarni, purtkujirnila manyanta Tayipitta. Pajangu palu nyanya nyantukurawarntirlu papajiwarntirlu. Nyanartijangka Pirlurr Ngarpukurajangka manyanta takurryani Tayipitta, mayakujirnila. Wali nyanartikarra Pirlurru Ngarpukurajangkarlu Juwul wanyjani, yarnta pirlurrwarlany manyanta yiparni kulipari, takurryanila manyanta Juwulla. ");
INSERT INTO wmt_vpl VALUES ("S117_1","010_17_1","1SA","17","1","16","Nyanartijangka palu kakarrangjarti karrinyani Juwujwarnti. Kanarlanywarnti palu karrinyani karlangjarti piyirnwarnti Pilijayinwarnti. Pamarrjarrangurni palunyanu jatnyangani kulijawurlu kakarrangurlujaa karlangurlu. Ngurrujarrarni palurlanyanu japantinyani ngurrajarrangurni. Wali nyanartijangka purlkajinyangu nganpayi pirriyani yini Kilayi karlangujangka purntukangupurru Pilijayinwarntiwu. Nganpayi nyanarti pa purlkajinyangu kaparlawurru. Wali nyantukura kuluwuj purlkajinyangu pa wirrimkujirni tanyji kanarlanyparni. Kayan ngartalu tirrinylanta jirnallu. Jirnal nyurilymanjuwal pa nyanarti kuluwuj. Wali nukarnini manyanu rukukani karrkintajaa jurlunga, yarnta jinajarrarlajaa kurrapajarrarla. Yarnta jirnal kangani purlkajinyangu japirrijarti. Yarnta kanarlanyju nganpayirlu parla jara kangani purlkajinyangu. Marnparni kajalkajal yanani. Wali nginarrmarnani manyanangu kakarrangjangkawarntiwu. Marni manyanangu, “Warntawu mantarlanyanu kanarlany nganpayiwarlany purntumanupurru. Wali puju paja pungku layingu nyurrakurajangkarlu, wali nyurrawarntila manta maja ngunawu. Puju ngajungu marna pungku nyantu, wali nyanarti, nganampala karlangjangkawarnti marnanyirrangulu maja ngunawu.” Wali pinakarrinyani palu Juwulngurrarlu kakarrangjangkarlu. Pinakarrinyurla palurla karrartajarrinyurla rayinjarrinya. Wali kumantawarlany kumantawarlanyjaa karuwarrawarlany karuwarrawarlany manyanangurla nginarrmarnani, minyakujala jijijarti pajangalmirri marnani. Wali papajinyankurawarnti palanta Juwulla kirrarnani Tayipitkurawarnti. Pinakarrinyani palu nganpayi yangka Kilayi nginarrmarnani manyanangurla kuli. Ngajirta pa nyantu Tayipit marnpa kirrarnantarla. Marri pa warrkammarnani kukunjawarnti manya. Yarnta ngarpunga mapirrirni manyanta kirrarnani, yarnta jarntuwarntirla mapirrirni manyanangurla kirrarnani. ");
INSERT INTO wmt_vpl VALUES ("S117_17","010_17_17","1SA","17","17","22","Wali nyanartijangka nyantukurarlu ngarpungu parla marni Tayipitku, “Miyi mananangu kangku nyuntukurawarntiwu papajiwarntiwu, yangka palanta Juwulla kirrarnana. Wali nyanartijangka tikirrkangkula pajin wangki nyapartukarra palu nguniny Juwulkurawarnti.” Nyanartijangka kumantajarti pikakujirni manya miyiwarnti. Wali tangkirlala karrpirni wurnapurru. Yanila manyanangurla Juwulngurrakarti. Kanya manyanangu miyi papajiwarntiwu. ");
INSERT INTO wmt_vpl VALUES ("S117_23","010_17_23","1SA","17","23","31","Nyanartijangka pirriyanurla manyanangurla wangkikarra karrinyani, nyanartikarrarnila pirriyani yangkarti nganpayi purlka Kilayi. Wali nginarrmarnanila. Marnani manyanangu Juwulkurawarntiwu, kirlingal kirlingal manya liyilanani. Kujarti manyanangu marnani, “Warntawu mantarlanyanu kanarlany nganpayi purntumanupurru.” Wali pinakarrinyurla palu yaplaparni rayin Juwulkurawarnti. Tayipittu pinakarrinya jalarramiparni wurnakartirlu. Marni manyanangu Tayipittu, “Minyarti nganpayi pa yarr kurajpungana Juwujwarnti Ngarpujiliny. Kajalkajalkujilany manyanu. Nyapartujarriwula nganpayirlu puju lankujangka pirlawurra nyanarti nganpayi.” Jangkumanila palu kanarlanywarntirlu, “Yangka ngananguwurti lanku pirlawurra minyarti nganpayi, wali nyanarti, yungkula parla Juwullu wirriyarlu yiji manawarntijaa pamarrwarnti, yarnta kartu mapirrirni nyantukura kurntal.” ");
INSERT INTO wmt_vpl VALUES ("S117_32","010_17_32","1SA","17","32","37a","Wali nyanartijangka Tayipittu parla marni Juwulku, “Ngajirta nganta rayinkarri. Ngajungu marna pungku.” Juwullu parla jarrmarni, “Ngajirta. Kayan ngan jintanga yanta. Nyuntu man pingkayi, nyantu parla pinarri kuliwu pungupurru jarlujangka. Nyuntu manurla ngurrpa kuliwu pungupurru.” Wali Tayipittu marni, “Ngajirta. Ngaju marnarla pinarri, yangka manyanangurla kukunjawarntirla pirriyanany kulipari layin pajanjuwal, nyanarti marna pungany pirlawurra, kukunja marnarla wanji yungany. Wali ngajungu marna nyangany minyarti nganpayi Kilayi layinjilinyparni. Ngaju paja marlamanku Ngarpungu yangkartijilinyparni yangka paja marlamani layin pungupurru.” ");
INSERT INTO wmt_vpl VALUES ("S117_37b","010_17_37b","1SA","17","37b","40","Juwullu parla marni Tayipitku, “Kaj. Yanta. Ngarpungu manta ngampurrikarrku kulijangka.” Yarnta manyanta Juwullu kuluwuj tanyji yutukani nyantukurajinyangu jirnalamarra yangkarti Kilayikurajiliny. Lanta ngarta Tayipit nyanartirlu purlkangu. Nyanartijangka jarti pa wirrimkangani Tayipittu, tumaj purlkajinyangu. Kunyungurla pa patkanyjirnani. Wali marni parla Juwulku, “Kayan ngarna minyarti wirrimkangka, ngurrpa marnarla minyartiwu tanyjiwu.” Wali kurtamanila manyanu, yarnta parlanyanu mana warntarni kanajiliny, yangka warrkamja kukunjawarntirla kangani nira. Yarnta manya pamarrwarnti kurajpinya ngapangajangka karntalywarnti kurriny kurriny kayan. Takurrpinyala manya payikirla pakittajiliny. Yarnta parlanyanu kangani manawarlany taki luwarnupurru rapajilinyparni, yangka pa nira kangani layinpurru luwarnupurru, kajilurla kukunjawarnti pajarrku. Wali nyanartiwarntijarti manawarntijarti jakarni, ngajirta parlanyanu jirnal kangkarla. ");
INSERT INTO wmt_vpl VALUES ("S117_41","010_17_41","1SA","17","41","42","Wali nyanartijangka yangarrijarrinya pilanyanu Tayipitjaa Kilayi. Kanarlany parla yanani nganpayiwarlany kaparn karrpirnajarti. Kilayirla manyanta marnpa yanani pilurupungupurru. Nganpayirlu nyanya nyanartirlu purlkangu Tayipit pingkayi jirnalngajirtajartijaa kuluwuj ngajirta kangkarla tanyji, kirlirni pa wirrimkangani. ");
INSERT INTO wmt_vpl VALUES ("S117_43","010_17_43","1SA","17","43","47","Nyanartijangka Kilayirlu parla nginarrmarni, “Wanyjarra manurlanyanu minili kanya jara. Minyarti man pirriyani lamparnjarti mana. Kula marnangu kuyirni karrinyana.” Yarntarni parla marni, “Mirnu yanani. Pungku marnanta, ngumula marnanta tarrapungku. Jirikiwarntirlula mantalu ngalku ngilyki Juwulngurra yarnta marranywarntirlu.” Wali Tayipittu manyanta jangkumani, “Ngajirta. Ngaju paja Ngarpungu marlamanku. Wali man nyuntu karrinyana jirnaljartijaa purlkawarnti manunya manawarnti martarnana. Nyuntu mantalu manawarntirlu marlamanku, ngaju paja Ngarpungumipa marlamanku Yijirayilkurarlu.” Wali kulijarrinyala parla Tayipit. Marni parla, “Jalarra marnanta luwawu, yarnta marnanta kangkul talypajarrku. Ngumula marnanta tarrapungku nyuntukurawarnti mapirrirni Pilijayinwarnti. Jirikiwarntirlujaa marranywarntirlu manyalu nukarnini ngalku ngilyki. Nyanartijangkarlu palu nginyjirrikarrku piyirntu pajangu wapalkarrarlu nyapartukarra paja Ngarpungu Yijirayilkurarlu marlamani nyurrawarnti pungupurru.” Kujartikarra pilanyanu marrarnani karlangujaa kakarrangu. ");
INSERT INTO wmt_vpl VALUES ("S117_48","010_17_48","1SA","17","48","51","Wali yanani pilanyanu langkarnijarra. Nyanartijangka Tayipit ngarrujarrinya, payikijangka warntarni pamarr pupururlurni. Wali pikala martarni kurraparla. Nyanartijangka wurna jutjutparnila luwarni. Wali janginyjinyangula luwarni, yarrparnila jirrpart wantinya. Nyanartijangka laparni Tayipit kankarnumarrangu manyanta jatparamani. Nayip warntarni Kilayikura, yarrparnila jungani kangkul taly. Wali jurlula kanya Tayipittu. Yijingkangku manyanangurla kanarlanywarntirla mapun ngarta minyarti nganpayi pinya. Kanarlanywarntirlu palurla pinarri ngunangani, nyantu pa purlkajinyangu. Nyantuwarntirlu palu nyangani Tayipit pa pingkayi. ");
INSERT INTO wmt_vpl VALUES ("S117_52","010_17_52","1SA","17","52","54","Wali nyanartijangka Juwulkurawarnti palu laparni Pilijayinwarntikarti pungupurru pirlawurra. Wali wapalkarrala palunya tarrapinya pirlawarnti, mapunparnila palunya ngarnani jirikirlujaa marranyju Pilijayinwarnti yangka parla jularni Tayipittu junganurla tarrapungupurru ngilyki. ");
INSERT INTO wmt_vpl VALUES ("S117_55","010_17_55","1SA","17","55","58","Wali Juwullu manya japirlyinya, “Nganakura minyarti nganpayi pingkayi. Ngana parla ngarpu.” Nyantuwarntirlu palurla marni, “Ngurrpa marnalurla.” Nyanartijangka Juwullu nyanturni japirlyinya, “Nganakura man nyuntu. Ngana mangu ngarpu.” Tayipittu manyanta jangkumani, “Ngaju marna Jisikura walaku Pajilimjangka.” Ngajirta parla Juwul pinarri ngunarla Tayipitku yangka manyanta Jamiyurllu purtkujirni ayil, ngurrpa parla nguja. ");
INSERT INTO wmt_vpl VALUES ("S118_1","010_18_1","1SA","18","1","4","Wali Juwulkura walaku nyanayirla ngunangani yini Janijin. Nyanartijangka wurnakartijangkarni Tayipit jarntukujirni Janijintu. Wali lamakujirni parlanyanu Tayipit Juwullu. Ngajirta manyanta yipanyjarla tikirr ngarpukarti. Warrkammayinkujirni parlanyanu. Wali jarntukujirnila pilanyanu Janijintujaa Tayipittu. ");
INSERT INTO wmt_vpl VALUES ("S118_6","010_18_6","1SA","18","6","11","Wali nyanartijangka kulijangka palu tikitikiyani ngurrawarntikarti ngurrujarra ngurrujarra. Kanarlanywarnti palu wurnarni tirrinyyanani, kanarlanywarnti palunyanangurla jarntuwarntirla kirrarnani. Walimpala palu wartangurni pirriyanani. Yangka palu tirrinyyanani mayaruwarntirlurra, marninwarntirlu palu ngarrurtarlu juju yinparnani, yarnta palu Tayipit kajalkajalkujirnani wirriyajangkarlu. Kujarti palu yinparnani, “Juwullu manya pinya murrkurnmartamarta, Tayipittu manya pinya pajajinyangu.” Wali Juwullu manya kingju pinakarrinya jujujangka yinparnjangkawarnti marninwarnti, kulijarrinyala. Pinapinakarrinyani parlanyanu, “Wali palu kajalkajalkujilany Tayipit. Kunyungurla pajalu ngaju wanyjarrku. Nyantuwurtu ngalu kingkuji Tayipit.” Nyanartijangka Tayipitku parla yakurrmarnani Juwullu. Nira pa ngampurrikanani. Tayipittu nganyanu kajalkajalkujirla king ngunangupurru. Marrkijarrinyanila parla. Wali nyanartijangka kumantawarlany wangartajarrinyala Juwul. Layilaparnanila pupuru mayarurla nyantukurarla. Yangka parla Ngarpungu yiparni kulipari pirlurr, nyanartirlu pa wangartakujirni. Wali Tayipittu pa pungani kitajiliny tirrinytirriny ngangakujirnupurru Juwul wangartajangka. Nira pa pungani kujarti. Nyanartijangka Juwullu warntarni jirnal. Marni parlanyanu, “Larrpuklanku marna mayaru mapirrirni.” Mapunparni jalikanurla parlanyanta jurtuklani. Nyantungu parla minkiri wanyjani Tayipittu kurrinymirri. Nyanartijangka jarti pa kurlpungani Juwullu, pungkarla pa. Nira manyanta murlkarra ngunangani Juwul pungupurru. ");
INSERT INTO wmt_vpl VALUES ("S122_1","010_22_1","1SA","22","1","2","Nyanartijangka yaplaparni Tayipit Juwulkurajangka mayarujangka rayin. Karla pa yani, ranyjiwantinyala pa najinga Juwullamarra parlanyanta. Nyanartijangka palunyanta jarntuwarnti pirriyani Tayipitkurawarnti. Ngurra palu yukarnani nira nyanayirla najinga papajiwarnti mapirrirni. Yangka palurla Juwulku yakurrmarnani, nyanartila palanta yani Tayipitkarti. Nyanartijangka manyanangu Tayipit majajarrinya najikarrajiwarntiwu. Pakulyanani palu ngurrawarlany ngurrawarlany Juwulkarrarla. Pungka ngarta Tayipit. Wali Juwullu parla jarti muwupungani. Nyantu pa Ngarpungu marlamananijaa ngampurrikanani. ");
INSERT INTO wmt_vpl VALUES ("S124_1","010_24_1","1SA","24","1","22","Wali nyanartijangka Juwul jakarni kurlirra, tumaj palurla jularni nyantungurni kurlirrawarlanyjangkarlu. Marni palurla, “Tayipit pa minyayirla kirrarnana.” Juwullu parla muwupungani kulipariwarntijawurlu. Nyantu pa ranyji kirrarnani yininga pamarrwarntirla Pilikutkurawarntirla. Tayipitngurra palu kirrarnani ranyji pamarra najinga. Nyanarti pa naji kakarrangujarti kirlingirri pukanyjajilinyparni purlkajinyangu. Pirriyanila palu Juwulngurra. Nyantukurawarnti manya wanyjani, palkangala palu karrinyani. Nyantumipala Juwul manyanangurla takurryani ngapajangkajaa miyijangka. Wali yutantinyala kirlingirrirla jut nganpayi Juwul. Ngajirta manya nyakarla Tayipitngurra. Wali nyanya palu, marnila palurla Tayipitku, “Pungka.” Jinjinyungani palurla. Kujarti palurla marni, “Ngarpungu mangu yiparni pungupurru, pungkula man.” Wali jarlkarra pirriyani manyanta nayipjarti wartangurni ranyji. Kuwutmiparnila manyanta jungankarranya. Juwul pa ngurrpa kirrarnani. Ngajirta parla pinarri. Nyanartijangka Tayipit parla yawiyijarrinya. Pinapinakarrinyani, “Nganpayi minyarti pa Ngarpukura. Ngarpungu pa jarlu kurajpinya. Kayan ngarna ngajungu pungka.” Jarrmanila manyanangu nyantukurawarntiwu ngajirta ngartalu pungka. Nyanartijangka Juwul turtapinya walimpa ngarrjarni kirrarnurla, palkakartila manyanangurla tirrinyyani. Nyanartijangka Tayipit parla partalurni yani kirlingirrikarti. Papajanila parla. Marni parla, “Purlka. Minyarti nyaka.” Jirrimartarni parla kuwutjangka kunku yangka manyanta jungani. Yarntarni parla marni Juwulku, “Pungkarla marnanta, yangkala marnanta wanyjani. Ngajukurawarntirlu pajilu marni pungupurru, ngajungu marnangu yawiyijarrinya, tumaj manta Ngarpungu kurajpinya king. Wayila pajin pinarri ngunawu, ngajirta marnangu kulijarrirla. Ngaju nganajangkarlu pajan nira waangana pungupurru nyuntungu.” Yarnta parla marni Tayipittu, “Kunyungurla pajan kunyarr pirla wajilpungana, yarnta pirniny. Wali Ngarpungu parlinya nyangany nyantungu paja wanji yungany.” Wali Juwullu manyanta jangkumani, “Wara, ngajukura paji karrinyana jarntu.” Nyanartijangka manyanta milngarli pirriyanijaa lungani. Marni parla, “Nyuntungu pajan wanyjani, ngajirta pajan pungkarla. Ngaju marna yakurr.” Kujarti manyanu jularni Juwullu. Yarntarni parla marni Juwullu Tayipitku, “Mapunparni manta Ngarpungu kurajpinya king ngunangupurru. Warra man ngunawu king. Wali ngajirta nganunya pungka ngajukurawarnti jirnanyunguwarnti yangka marna ngaju pirlajarriwu.” Tayipittu parla yu marni. Nyanartijangka Juwul tikiyani kayili nyantukurarlurra ngurra Kipiyarlurra. Tayipit pa warrarni ranyji kirrarnani Juwullamarra, pungka ngarta. ");
INSERT INTO wmt_vpl VALUES ("S131_1","010_31_1","1SA","31","1","4","Nyanartijangka palu yani kayili Pilijayinwarnti, punganila palunya Yijirayiljangkawarnti. Nyanartijangka Juwulngurra palu yaplaparni rayin. Wali wajilpinyala palunya wartangurnirlu. Lanila palunya paja pirlawurra nyantuwarnti mapirri Juwulkurawarnti walakuwarnti. Yarnta palu Juwul lani yarumartarni. Yukarnanila liyimijarti lanujangka, jarti parlanyanu wurnawu kurlarnani. Wali nyanartijangka nayip jalani jiri nyantukarti, wantinyala manyanta tarrparni nayipkarti pirlawurra. ");
INSERT INTO wmt_vpl VALUES ("S21_1","011_1_1","2SA","1","1","4","Wali nyanartijangka Tayipitkartila manyanta yani layi nganpayi kukajarti. Jularni parla yangka palu pirlajarrinya Juwulngurra wapirrajartijaa jarntuwarnti mapirri Janijin mapirri. ");
INSERT INTO wmt_vpl VALUES ("S21_12","011_1_12","2SA","1","12","27","Lunganila manyanangu yawiyijarrinyurla. Yarnta miyi ngajirta palu ngarnantarla Tayipitngurrarlu. Nguja palu layi ngurra miyingajirtajartijaa kuyingajirtajarti. Lungukarra palu kirrarnani. ");
INSERT INTO wmt_vpl VALUES ("S22_1","011_2_1","2SA","2","1","1","Nyanartijangka lungujangka yarrjarrinyala. Japirlyinyala parla Ngarpu Tayipittu, “Ngaju ngarnanyanangu maja ngunawu Jutajangkawarntiwu.” “Yu,” marni parla Ngarpungu. Kurrinymirri parla japirlyinya Ngarpu, “Ngananga mayarurla marnanyanangu ngunawu.” Ngarpungu parla jularni, “Yipurunta.” ");
INSERT INTO wmt_vpl VALUES ("S22_2","011_2_2","2SA","2","2","3","Wali nyanartijangka yanila Yipurunkarti. Kanya pinya nyantukurajarra kartujarrajaa jarntuwarnti mapirrirni manya kanya. Juntumanila palu ngurra nyanayirla. Nyanartijangka warntarni manya kartuwarntiwarlany kurriny kurriny kayan. Yarnta palunya martarni walakuwarnti pajawarlanyparni Tayipitkurawarnti jukuwarnti kurriny kurriny kurriny. ");
INSERT INTO wmt_vpl VALUES ("S22_4","011_2_4","2SA","2","4","11","Kingjarrinyala manyanangu Tayipit Jutajangkawarntiwumipa, ngajirta kayilijangkawarntiwu Yijirayiljangkawu. Nyantuwarntirlu palurlanyanu kurajpinya kingwarlany Juwulkura walakuwarlany. Nyanartijarrajarti palu kirrarnani kurrinyjarti king. Kunyungurla 7 yitilalwarnti. Nyanartikarrarni parla Tayipittu yiparni Juwulkurawu kurntalku kartuwarlanyku yangka parla jarlu yinya Juwullu. ");
INSERT INTO wmt_vpl VALUES ("S24_7","011_4_7","2SA","4","7","7","Nyanartijangka pila nganpayijarrarlu pinya kayilungujangka king Yijirayiljangka. ");
INSERT INTO wmt_vpl VALUES ("S25_1","011_5_1","2SA","5","1","3","Wali yanila palanta kayilungujangkawarnti kurlirra Tayipitkarti. Marni palurla Tayipitku, “Nyuntu marnanpangu jarntu yangka manta Ngarpungu kurajpinya king ngunangupurru.” Kayanpala manyanangu king ngunangani. ");
INSERT INTO wmt_vpl VALUES ("S25_6","011_5_6","2SA","5","6","9","Nyanartijangka kayili yani Jurujulumkarti Tayipit, pinyala manya Jurujulumja pirlawurra ngayiwarnti Ngarpungajirtajartiwarnti. Nyanartijangkala parlanyanu warntarni ngurra nyanarti. Wali nyanartijangkala palu julalany Jurujulum Tayipitkura mayaru. ");
INSERT INTO wmt_vpl VALUES ("S25_13","011_5_13","2SA","5","13","13","Nyanartijangka manya warntarni kartuwarntiwarlany paja Tayipittu. Waliwarlany manya kanya kurlangu murrkurnwarlany. Yarnta manya pajawarlany martarni Jurujulumja jukuwarnti parriwarntijaa mangawarnti. ");
INSERT INTO wmt_vpl VALUES ("S27_1","011_7_1","2SA","7","1","17","Wali Tayipitku palurla purlka mayaru ngartakpani, nyanayirla kirrarnani. Yarnta Ngarpungu ngampurrikanani, ngajirta palu pungkarla ngayiwarntirlu. Nyanartijangka parla jularni nganpayiwu puraputku yiniwu Nayijinku, “Ngaju marna kirrarnana wulyungajinyangu mayarurla. Mana yangkarti Ngarpukura nyangajirtapurru warrarni pa ngunangana kaninykaniny kalukurlamipa. Ngartakpankula marnarla mayaru Ngarpuwu.” Jangkumanila manyanta Nayijintu, “Kaj. Ngartakkarrarla, puju manurla wulyumalany. Ngarpungu manta marlamanku.” Nyanartijangkala parla Ngarpungu jularni pukanyjajarti Nayijinku Tayipitku jarrmarnupurru. Marni parla, “Kujarti manurla julawu. Ngajirta ngaji mayaru ngartakpanta. Wali marna kirrarnana kalukurla. Walimpa paji ngartakpanku nyantukurarlu walakurlu jirnajangkarlu. Yarnta marna Tayipit ngampurrikananku ngajungu nyantukurawarnti yapajirnanyunguwarnti kilakiwarntijaa jamirtiwarnti mapirrirni marnanya marlamananku.” Yanila manyanta Tayipitkarti Nayijin. Jularnila parla Ngarpukurajangka wangki nukarnini. ");
INSERT INTO wmt_vpl VALUES ("S27_18","011_7_18","2SA","7","18","28","Nyanartijangka Tayipit yani kalukukarti kaninykaniny. Japirlyungani parla Ngarpuwu wirriyarlu Tayipittu kirrarnungurni. Kujarti parla marnani, “Ngarpu. Wali pajan marlamanani. Wulyu man, nyuntu purlka. Ngaju marna marlal, yangkala pajinunya marlamanku ngajukurawarnti mapirrirni yapajirnanyunguwarnti. Wali pajan nira pinayungany Ngarpu nyuntungu purlkangu. Ngajirta mangurla nyuntujiliny nguna kanarlany. Wali manunya kanya ngajukurawarnti kilakiwarnti Yijipngurni mirnu jarlu minyartikarti wulyukarti ngurra. Wali pajin jularni ngampurrikanupurru yapajirnanyunguwarnti, nyanarti marnangurla walirni mapunikarralany.” Kujarti parla japirlyinya Tayipittu Ngarpuwu. ");
INSERT INTO wmt_vpl VALUES ("S28_1","011_8_1","2SA","8","1","18","Walimpawarlany yarntarni palunyanu pinya Yijirayilwarntirlujaa ngayiwarntirlu pajangujinyangu. Wali Tayipitngurrarlu palunya pungani kujawarlanyjangka. Kanarlanywarnti palu warrkammayinkujirnani Tayipitngurrarlu, majajarrinyani palu. ");
INSERT INTO wmt_vpl VALUES ("S211_1","011_11_1","2SA","11","1","27","Nyanartijangka Tayipittu manya yiparni kulipariwarnti. Nyantu pa lama kirrarnani mayarurla. Kanya manya nganpayirlu Juwapju. Maja manyanangu nguja kulipariwarntiwu. Kakarra palu yani, pungku palunya ngayiwarnti. Nyanartijangka Tayipit pa mayarurla kirrarnani wartangurni. Turtapinya pa manyanjangka karuwarrarla purangu kaninyjarrinyjangkarla. Kankarnumarrangurla parayani mayarurla, wamarn karrinyanila. Wali kanarlanyparni pa nyanarti mayaru. Kujarti palu parayanani kankarral yarnta palu kirrarnani kankarnumarrangu kirtilya. Wali nyanyala kankarnumarrangurlu marnin nyumukarnjangka manangajirtajarti kaniny mayaruwarlanyja. Wali nyangungurla pa muyurrnyanya. Marnila parla warrkammayinku, “Ngana marnin nyanarti yini. Julaji.” Wali jularni parla, “Marnin nyanarti pa Pajiyipa. Ngumparna nyantukura pa nganpayi Yuraya. Kulikarti parla yani kakarra.” Nyanartijangka warrkammayinpala parla yiparni purpanupurru. Purpanku parla nyanarti marnin Tayipitku. Pirrikanyala palurla, yukarnanila manyanta Tayipit nyanayirla marninta. Yarnta nyanartikarrarni pukanyja tikiyanila nyanarti marnin ngurrakarti nyantukurakarti. Walimpa ngungkupinyala manyanu, “Kunyungurla marna yapajarti.” Yangkala parla Tayipitku wangki yiparni, “Yapa partarnangu nyuntuwu martarnana.” Wali ngajirta parla ngumparna nyantukura marnpa kirranyjarla. Marri parla nguja kulinga. Nyanartijangkala parla Tayipittu wangki yiparni Juwapku. Marni parla, “Tikirryipanyjaji nganpayi Yuraya.” Wali tikirryiparnila manyanta Tayipitkarti. Wali Tayipittu parla japirlyungani nganpayi Yuraya, “Yara ngalu ngajukurawarnti nguniny. Warrarni ngalan kuli pungana.” Kujarti pila wangkikarra kirrarnani. Marnila parla Tayipittu, “Ngurrakarti yanta. Marrijangka man pirriyani, yarnta man yukalku manyan.” Kula manyanta yukanyjarla nyanayirlarni marninta, nyantu manyanangurla yukarni kulipariwarntirla mapirri. Tayipittu parla yiparni kujawarlanyngurni minya parla nyantukura yapa martarnana Tayipitkura, nyantungula nyanarti lanku. Kula parla nyantukurarni yapa Yurayakurarni, minya parla Tayipitkura martarnana. Kujartikarrapurru parla Tayipittu yiparni, ngajirta manyanta nyantu yukanyjarla kartunga Yuraya. Nyanartijangka Tayipittu nyanya ngajirta manyanta yantarla kartukarti. Jut manyanangurla yukarni kanarlanywarntirla. Marnila parla, “Nganajangka mananta yantarla kartukarti ngurrakarti.” Nyantungula parla marni Yurayarlu. “Ngajirta. Kulimipa marnarla ngaru kayan nguniny. Ngaju marna kayan tikiyani, kanarlanywarnti palu warrarni kulinga ngunangana. Kayan ngarnanyanta ngajukurarla kartunga yukanyja, nyanartijangkala marnarlanyanta jutpala lamajarrinya, kulikartiwarlany marna tikiyanku.” Yarntarni parla marni Tayipittu, “Lama man kirralku minyayirla. Warrala marnanta yipawu kumantawarlany.” Wali miyila japala pila ngarni nyanayirla mayarurla. Yarnta ngapa mapirrirni parla yinya wangartakujirnujuwal Tayipittu. Kula manyanta nyanartijangka yantarlarni kartukarti wangartajarrinyujangka. Wali ngarnujangka ngurrajarra kurriny pa yukarni kingkurarla mayarurla. Kumantawarlany pa tikirryiparni kulikarti kakarra. Wali kumantajarti mirlimirlila parla lani Tayipittu Juwapku. Kujartikarra parla lani, “Minyarti nganpayi man yutukarrku kulinga kaparn, lankula palu partal pirlawurra.” Kanya parla Yurayarlu mirlimirli nyanarti Juwapku. Wali mapunikani manyanta Juwapju yangka parla Tayipittu yiparni mirlimirli. Kaparnpala yutukani kulinga yangkarti nganpayi Yuraya. Nyanartijangka palu lanila ngayiwarntirlu pirlawurra. Wali tikirryiparnila parla Juwapju. Kujartikarra parla yiparni Tayipitku, “Yangkartiwarntirlu marnapanyalu kulipurru tintinyinya ngayiwarntirlu, yangkarti nganpayi Yuraya mapirrirni palu lani.” Wali jularni palurla kuka Pajiyipawu kartunyankurawu, “Ngumparna mapirrirni palu lani nyuntukura.” Lunganila parla yawiyirlu. Nyanartijangka karrkarnurlala kirrarnani, yangkala parla Tayipittu yiparni warrkammayin purpanupurru nyantukarti nyanartiwu marninku. Marnin nyanarti warntarnila parlanyanu, mayarurlala kirrarnani nyantukurarla Tayipitkurarla. Kartukujirni parlanyanu. Nyanartijangka parrila martarni yangkarti. Wali yangkartijangkangurni parla Ngarpungu yakurrmarnani. Marnin kanarlanykura parla yapajartikujirni, yarnta purturuyiparni kulikarti nyantukurajinyangu jarntu. ");
INSERT INTO wmt_vpl VALUES ("S212_1","011_12_1","2SA","12","1","15","Nyanartijangka Ngarpungu yiparni nganpayi Nayijin puraput. Jularnila parla Tayipitku wangki kujartikarra. “Wali layiwarlany nganpayi pa ngunangani pajajarti kukunjawarntijaa purlumanwarnti. Kanarlanyju parlanyanu kayanmipa martarni ngamarti lamparn kukunja, yarnta ngurranga kayanta martarnani kurntaljilinyparni. Ngamurlakanganijaa miyi mapirri parla yirrangarni, ngapa mapirri parla yungani kapjangka. Wali nyanartijangka pirriyanila manyanta kanarlany nganpayi marrijangka yangkartirla pajajartirla. Marnila parla, ‘Kuyi marnangu pungku. Nyuntu man marrijangka pirriyani wurnajangka marranyanjarti.’ Mapunparni pa tarrpartarni kayanmipa, yangka marlaljawurlu parlanyanu martarni. Nyanarti manyanta warntarni, pinyala parla. Ngajirta nyantukurajangka kurajpungkarla pajajangka. Nyantungu parlanyanu marulukani.” Wali nyanartijangka Tayipit kulijarrinyala parla. Marni parla Tayipittu Nayijinku, “Mapunparni palu pungku nyanarti nganpayi ngurriji. Wali nyantuwarlanyju parla tikirr yungku pajajawurlu kurriny kurriny kukunjawarnti nyirrwirijangkarlu, yangka manyanta nyantunga kayanmipa kurlmani, tumaj manyanta yawiyingajirtarlu warntarni.” Wali Nayijintu parla marni jirrkirlparni Ngarpukurajawurlu Tayipitku, “Nyuntu man nganpayi nyanarti. Kujarti mangu Ngarpungu julalany. Yarnta manta majakujirni Ngarpungu Juwulkarrarla mapirrirni, yangka jarlu mantalu pungkarla pirlawurra. Wali manta yinya kartuwarnti paja yarnta Yijirayiljangkawarntirlajaa Jutajangkawarntirla manta majakujirni Ngarpungu. Kanarlany manta Ngarpungu yungkarla. Nganajangkarlu man Ngarpu mapunikarrarla yarnta mananta panypinya. Kanarlanypala manurlanyanu warntarni. Nyanartijangkala manurla puturuyiparni nganpayi Yuraya, lanila palurla. Wali manyanu kujikani nyuntungujaa kanarlanywarnti mapirrirni manunya kujikani.” Kujarti parla Tayipitku marni Nayijintu Ngarpukurarlu puraputtu. Tayipittu manyanta jangkumani, “Mapunparni marna ngaju yakurr, Ngarpunga marnanyanta panypinya. Ngajirta marnarla mapunikarrarla.” Nayijintu parla marni, “Wali Ngarpungu mangurla wajapinya yakurr nyuntukura. Kayan nganta pungka, tumaj man panypinya Ngarpu. Nyanartijangkala mangu yapa yangkarti pirlajarriwu.” Nyanartijangka Nayijinpala yapyani ngurrakarti nyantukurakarti. ");
INSERT INTO wmt_vpl VALUES ("S212_16","011_12_16","2SA","12","16","24","Wali nyanartijangka parri nyanarti pa mimijarrinya Pajiyipakura. Wali Tayipittu parla jarti japirlyungani Ngarpu parriwu parlanyanta wulyukujirnupurru. Ngajirta pa miyi nganyjarla Tayipittu, yawiyi parla kirrarnani. Jarti palurla yungani miyi ngarnupurru. Nyanartijangka pirlajarrinyala parri nyanarti. Wali ngajirta palurla jularla warrkammayinwarntirlu pirlajarrinyujangka parri nyanarti Tayipitku. Warrkammayinwarntirlu palurlanyanu marni, “Ngajirta ngarliparla jula. Kunyungurla ngartanyanu pirlawurra pungka Tayipittu.” Wali Tayipittu manya pinakarrinya wangkikarra karrinyujangka. Marnila manyanangu, “Pirlajarrinya ngarta.” Nyantuwarntirlula palurla marni, “Yu. Pirlajarrinyajal.” Nyanartijangka Tayipit turtapinya. Kuluwuj parlanyanu warntarni, nyumukkartila yani, jurlu manyanu kumapkujirni. Nyanartijangkala yani kaninykaninyjurra kalukurlurra purayimarnupurru Ngarpuwu, nyanartijangkarlula tikiyanurla miyi ngarni Tayipittu. Japirlyinyala palurla warrkammayinwarntirlu, “Nyapartujangka man yangkarti yukarnanijaa lungani, miyi ngajirta man ngarnantarla. Walimpa yangka pirlajarrinya, nyanartikarrarla man ngarni wartangurni.” Tayipittu manya jangkumani, “Yu. Wali marna lunganijaa yawiyi marna yukarnani. Kula paji Ngarpungu yawiyijangkarlu wulyukujirlarni. Wali pa jalarra pirlajarrinya, kayan ngarna miyi wanyjarra. Wali marna ngarnanku. Tikirrkujiwu ngarnanyin lungujangkarlu. Wali manyanta Ngarpungkurra yani, ngaju mapirrirni marna yanku walimpa yangka marna pirlajarriwu. Kayan ngajirla yarntarni tikiyanta ngajukarti.” Wali kartunyankurakartila manyanta yani Pajiyipakarti Tayipit. Yarntarni pila walimpa parriwarlany martarni, yinila yutukani Tayipittu Jalaman. Tayipittu parla marni kartunyankurawu Pajiyipawu. Kujarti parla jularni, “Jalaman pa king ngunawu walimpa yangka kajirna ngajuliny purrkujarriwujaa pirlajarriwu.” Kajalkujirni pa wartangurnijangka Jalaman, wartangurnikujirni manya kajalurnijangkawarnti walakuwarnti. ");
INSERT INTO wmt_vpl VALUES ("K11_1","012_1_1","1KI","1","1","10","Nyanartijangka parri yangkarti Jalaman purlkajarrinya. Wali Tayipit ngarpunyankura pa purrkujinyangujarrinya. Kayan ngarta wurna marri yanantarla. Kunyungurla tititikarrala yanani. Wali jarlu pa kurajpinya Tayipittu Jalaman kingkujirnupurru walimpapurru. Nyanartijangka Tayipitkurarlu walakuwarlanyju parlanyanu wulyumarnani nyantu king ngunangupurru kajalujangkarlu ngamajiwarlanykurarlu yiningu Yatinajarlu. Wali jarlu pa kurajpinya Tayipittu Jalaman, ngajirta nyantu. Nyanartijangka pamarrkartila manya kanya Yatinajarlu kingkujirnupurru. Kingkujiwu palu nyantu. Kanya manya ngajanyankurawarntijaa purlkawarnti warrkammayinwarnti. Ngajirta parla Jalamanku jularla Yatinajarlu. Nyantuwarntiwu manyanangu Jalamanngurrawu ranyjimarrarni. Ngarnani palurla wirriyarlu Yatinajangurrarlu miyijaa kuyi, kingkujiwula palu yangkarti nganpayi Yatinaja. ");
INSERT INTO wmt_vpl VALUES ("K11_11","012_1_11","1KI","1","11","31","Wali nganpayi yangkarti Nayijin Ngarpukura puraput yani manyanta Pajiyipakarti. Jularni parla, “Nyapartu manyanu kajalkajalkujirnana kanarlanyju kingju. Tayipit parla ngurrpa ngunangana wanyjarra pa ngunawu king.” Nyanartijangka yani manyanta Tayipitkarti Pajiyipa kartunyankura. Jularnila parla Tayipitku, “Yangkartikarra man kurajpinya ngajukura walaku Jalaman kingkujirnupurru. Wayila yangkarti. Jalarra palu kingkujirnana ngamajiwarlanykura walaku. Nyapartukarra manurla malany.” Wali nganpayila manyanta pirriyani Nayijin yangkarti puraput Tayipitkarti. Marnintu pinya wanyjani, yani pilangurla. Wali kayanparni wangki parla jularni Nayijintu yangka parla kartunyankurarlu Pajiyiparlu kajalurni jularni. Wali yarntarni Tayipittu tikirrkujirni kartunyankura. Marni parla Tayipittu, “Mapunparni marna kingkujiwu nyuntukura walaku Jalaman wanjingurnikarra. Walirni marna wanji nguniny. Ngajirta marna nyanarti kanarlany ngamajiwarlanyjangka kurajpungkarla kingkujirnupurru.” ");
INSERT INTO wmt_vpl VALUES ("K11_38","012_1_38","1KI","1","38","49","Nyanartijangka palu Jalaman kanya Ngarpukurawarntirlu puraputwarntirlu. Layingula manyanta purtkujirni ayil Jalamanta kingjarrinyupurru. Nyantuwarntirlu palu warrarni ngarnani miyi pamarra wirriyarlu, kula manyanangu nyanartirni nganpayi ngunarla king. Nyanartijangka yani manyanangu layi nganpayi. Jularni manyanangu nyapartukarra pa kingkujirni Tayipittu layiwarlany nganpayi Jalaman. Rayinjarrinyala palu nyanartijangka wangkijangka yangka manyanangu jularni. Ngurrujarrakujirni palunyanu rayintu. ");
INSERT INTO wmt_vpl VALUES ("K12_1","012_2_1","1KI","2","1","4","Wali nyanartijangka yangka Tayipit maljarrjarrinya jamurnku pirlawu, kujartikarrala parla Jalamanku jularnani, “Wali ngungkupungana marnanyanu maljarr jamurnku pirlawu. Lirrkarnpungku marnanta kujayirlarni. Wali Ngarpu man mapunikarrku, yarnta man pinakarrinyanku nyantukura wangki. Puju man Ngarpu mapunikarrku, wali yapajirnanyunguwarnti ngajukurawarnti manya Ngarpungu ngampurrikarrku yarnta kingkujiwu manya Yijirayilla minyayirla kilakiwarnti wartangurnijangkawarnti.” Kujarti parla marnani Jalamanku Tayipittu. ");
INSERT INTO wmt_vpl VALUES ("K12_10","012_2_10","1KI","2","10","12","Nyanartijangka pirlajarrinyala Tayipit. Turnmanila palu Jurujulumja marnpa. Nyanartijangka manyanangu Jalamanpala king ngunangani nyantukura walaku. ");
INSERT INTO wmt_vpl VALUES ("K13_3","012_3_3","1KI","3","3","14","Jalaman pa ngunangani nyantukurajiliny ngarpu Tayipitjiliny. Jirrkirl pa wajilpungani Ngarpu. Wali layimirri yani pamarrkarti, kuyila parla pinya Ngarpuwu. Nyanartijangka yukarni pamarra pukanyja. Ngarpula parla pirriyani winkirr. Ngarpungu parla marni, “Nganawu manurla wulyumalany. Japirlyungku pajanurla ngaju.” Jangkumani manyanta Jalamantu, “Wali man ngarpu ngajukura marlamanijaa ngampurrikani jarlu, ngajula pajan jalarra ngampurrikarrku. Wali pajan kingkujirni jirnajangka. Ngaju marnarla ngurrpa ngunangani minyartiwu warrkamku, nyanartijangkarlu marnanta japirlyungana jirrkirlikanupurru. Yirrikarrku marnanya nyapartukarra palu nguniny wulyujaa yakurr. Nyanartipurru marnanta japirlyungana.” Wali wirriyajarrinyala Ngarpu Kut nyanartijangka wangkijangka. Marni parla Ngarpungu, “Kujarti marnangu julawu. Ngunawu man jirrkirlikanujuwal, yarnta nganawurti piyirn mangurla pirriyanku nyuntukarti yirrijartijaa mapunjarti, wali nyuntungula manurla takijulawu.” Yarntarni parla marni Jalamanku Ngarpungu, “Kula pajanurla japirlyungkarla mayarupurrujaa manawarnti paja martarnupurru nyuntungu, minyakujala pajanurla japirlyinya piyirnwarnti marlamanupurru. Nyanartijangka marnanta yungku mayaru purlkajaa pamarr purlka, yarnta palurlanyanu piyirnwarntirla jakuljakuljulawu nyuntu nyapartukarra manta nguniny warraja wangki jularnujuwal.” Wali nyanartijangka parnkijarrinya manyanjangka, jakarnila Jurujulumkarti ngurrakarti nyantukurakarti. Wali Jalaman pa kirrarnani Jurujulumja. ");
INSERT INTO wmt_vpl VALUES ("K13_16","012_3_16","1KI","3","16","28","Wali marninkujarra pila kayanta ngurranga yukarnani muntajartijarra. Nyanartijangka kajalurnpala yapawarlany martarni. Yukarnila pila ngurrajarra kurriny, nyanartijangka yapawarlanypala palkangawantinya, wali kurrinyparnila pila ngunangani yapajartijarra. Nyanartijangka pukanyja pila yukarni, kanarlanyju parlanyanu patkanyjirni yapa pirlawurra. Kumantala pila parnkijarrinya, parlipinya pila layi yapa pirla yukarnani. Marnanila pilarlanyanu, “Ngajirta. Ngajukura pa nyanarti yapa. Tikirryungkaja. Nyuntukura mangu minyarti pirla.” Kanarlanyju parla marni, “Ngajirta. Nyanarti mangu nyuntuwu.” Wali jarti pilanyanu kurlkurlmarni. Nyanartijangka yanila pilanyanta Jalamankarti. Julawu pilarla yapa pirlajarrinyujangka kurrinypalkurlu. Wali layingu parla jularni kajalurni nyapartukarra pila yukarni pukanyja. Marni parla Jalamanku, “Kayanta pajarra yukalany ngurranga. Wali ngajungu marna kajalurni yapa martarni, yukarnila pajarra ngurrajarra kurriny, nyanartijangka yapawarlany nyantukura palkangawantinya. Kurrinyparnila pajarra yapajarti ngunangani. Nyanarti pukanyja pajarra yukarni, nyantungu parlanyanu patkanyjirni yapa pirlawurra. Kanyala pajarla pukanyja ngajukarti tujkujirni pajarla, nyantukurala paji jatpankarranya manyantapururla. Wali nyanartijangka parnkijarrinya marna ngamarna yungupurru, nyanyala marna pirla. Nyanartijangka nyanyajinyangu marna. Marnila marnarlanyanu, ‘Minyakata pirla yukarnana yapa.’ Kanginypinya marna kanarlanyparni janginy. Marnila marnarlanyanu, “Ngajirta paji minyarti ngajukura yapa. Minya parla kanarlanykura.” Nyanartijangka yangka pilanyanta Jalamanta marnpa karrinyani, tilajparni pilarlanyanu. Kanarlanyju parla marni, “Ngajirta. Minyarti paji ngajukura parri wanji. Nyuntukura pa pirla.” Yarntarni parla marni, “Ngajirta. Nyuntukura pa pirla, ngajukura paji nyanarti wanji.” Wali Jalamantu pilangu marni, “Kurrinyju pajinpila julalany kanarlanykura wanji kanarlanykura pirla.” Nyanartijangka parla marni Jalamantu warrkammayinku nyantukurawu, “Warntaji nayip purlka. Tilypurrjunganta nyanarti yapa wanji. Yungkapinya ngurrujarra.” Wali nyantukurarlujinyangu ngamajirlu parla marni, “Ngajirta ngan junganta. Wanji pa ngunawu. Yungkarla minyarti marnin.” Wali yirrijirlu parla marni, “Kaj. Junganta nyanarti yapa. Kayan ngarta ngananguwurti wanji marta. Kurrinyparni pajarra ngunawu marlaljartijarra.” Nyanartijangka Jalamantu nginyjirrikani. Marni parlanyanu, “Kunyungurla parla minyarti ngamaji.” Nyanartijangka parla jarrmarni warrkammayinku, “Ngajirta ngan junganta. Minyarti marnin yungkarla. Nyanarti parla ngamaji mapunji.” Wali yinyala parla. Nyanartijangka kanarlanywarntirlu palu nyanya jirrkirlikanujuwaljaa yirrikanujuwal. Marnani palurlanyanu, “Minyarti parlipangu nganpayi purlka yirrikanujuwal. Wali Ngarpungurni pa jirrkirlikani Kuttu.” Wali palurla wulyumarnani purlkawu nyantuwarntikurawu Jalamanku. ");
INSERT INTO wmt_vpl VALUES ("K14_20","012_4_20","1KI","4","20","21","Nyanartijangka Jalaman manyanangu purlka ngunangani piyirnwarntiwu pajawu Yijirayiljangkawujaa Jutajangkawu. Wali palu ngarnani miyijaa kuyi purlka. Wirriya palu kirrarnani. Purlka manyanangu king marnparni kirrarnani, ngurtpala palanta ngunangani Jutakarrajiwarntirlujaa Yijirayilkarrajiwarntirlu. Yarnta kanarlanywarntiwu marrijangkawarntiwu mapirrirni manyanangu ngunangani purlka Jalaman. Nyantuwarntirlu marrijangkawarntirlu palurla rayinkarrarlu pamarr yungani. Nyangani palu, “Purlka pa minyarti nganpayi.” ");
INSERT INTO wmt_vpl VALUES ("K14_34","012_4_34","1KI","4","34","34","Nyanartijangka palu kingwarntiwarlanyju pinakarrinya nyapartukarra manyanangu Jalaman ngunangani purlka jirrkirlikanujuwaljaa yirrikanujuwal. Wali palunya yiparni kingwarntiwarlanyju nyantu pinakarrinyupurru. ");
INSERT INTO wmt_vpl VALUES ("K15_1","012_5_1","1KI","5","1","18","Wali kayilungurlu parla wangki yiparni kingwarlanyju Tayiyajangkarlu. Tayipitku parla jarlu wulyumarnani nyanartirlu nganpayirlu. Nyanartijangka tikirryiparnila parla Jalamantu kayili kujarti wangki. “Wali pa jarlu ngartakkarrarla mayaru Ngarpukura Tayipittu ngajukurarlu ngarpungu, tumaj manya kuli pungani kanarlanywarnti marrijangkawarnti, nyanartila Ngarpungu lamakujirni kankarnumarrangujangkarlu. Ngaju marna kirrarnana kulingajirta jirnajangka. Wali marna ngajungu ngartakpanku mayaru nyanarti Ngarpukura. Wayila nyuntukurarla mayarurla palu pajangal karrinyana manawarnti yarnta nyuntukurawarnti piyirnwarnti palu jirrkirl warrkamjuwalwarnti. Pinarri palurla nyantuwarnti nguniny manawu pajanupurrujaa mayaru ngartakanupurru. Ngajukurawarnti palurla ngurrpa. Wali palu pajarrku manawarnti, yarnta palunya ngajukurawarnti marlamanku nyuntukurawarntirlu. Kayanta palu warrkammalku.” ");
INSERT INTO wmt_vpl VALUES ("K16_1","012_6_1","1KI","6","1","38","Nyanartijangka parla tikirryiparni wangki Tayiyajangkarlu kayilungjangkarlu Jalamanku, “Nyuntu manyanangu wulyu Tayipitkura walaku. Mapunparni manta wulyu kurajpinya Ngarpungu Kuttu. Nyanartijangka marnanya yipawu ngajukurawarnti warrkammayinwarnti. Pajarrku palu manawarnti. Wali yipawula marnangulu ngapangal karrpirnurla jawurlatarla kurlirra. Nyuntukurawarntiwu manunyanangu malku japantiwu palurla warntawula mangulu, kangkula palu kakarrara Jurujulumkarti. Wali marnanta yungku manawarnti, nyuntuwarlanyju manunyanangu yipawu miyiwarntijaa kuyiwarnti ngajukurawarntiwu warrkammayinwarntiwu.” Kujarti parla marni nyanartipurru warrkampurru kayilungjangkarlu. Wali nyanartijangka palu Ngarpukura mayaru ngartakpani Jurujulumja yini Timpul. Ngajirta lamparn minyarti warrkam, purlkajinyangu palu warrkammarnani rawangu yitilalwarnti 7.");
INSERT INTO wmt_vpl VALUES ("K18_1","012_8_1","1KI","8","1","66","Wali nyanartijangka manya marurrpinya Yijirayiljangkawarntijaa Jutajangkawarnti kangupurru. Pakulkangku palu kalukujangka mana nyanarti kaninykaniny mayarukarti Timpulkarti. Nyanartipurru manyanangu wangki yiparni. Wali warryani palu kalukurla nyanayirla. Kuyiwarnti palurla pinya Ngarpuwu kukunjawarntijaa purlumanwarnti pajajinyangu. Nyanartijangkarlu palu warnkurrmani mana nyanarti puriswarntirlu pajangu, kanyala palu Timpulkarti kaninykaninykarti. Wali kurriny pila pamarrjarra ngunangani ranyji kaninykaniny nyanayirla mananga, yangka parla jarlu Mujij yinya Ngarpungu. Wali yutukani palu, nyanartijangka palu tikiyani palkakarti piyirnwarntiwarlanykarti. Nyanartikarrarnila ngumurrurlu pa tipani nyanarti rum tumaj pa Ngarpu pirriyani nyantujinyangula kirrarnani. Wali nyanyala palu, parrparrmarnanila, mil manya warntarni. Jarti palu tikirr takurryani warrkampurru. Nyanartijangkarlu manyanangurla karrinyani palkanga Jalaman wangkikarra. Jularni manyanangu nyapartukarra parla Tayipitku jarlu Ngarpungu jularni pikawurra Kuttu mayaru ngartakpanupurru. Nyanartijangkarlu palu mayaru minyarti ngartakpani jirnajangkarlu wirriyarlu. Yarntarni manyanangu Ngarpuwu purayimarnani Jalamantu. Wali nyanartijangkarlu jujula palu wirriyarlu yinparnani. Kirrarnani palu ngurrawarnti 7 purayikarrajaa juju palu yinparnani. Kajalkajalkujirnani palu Ngarpu wirriyarlu. Kumantawarlanyjala manya yiparni Jalamantu ngurrawarlany ngurrawarlanykarti. ");
INSERT INTO wmt_vpl VALUES ("K111_1","012_11_1","1KI","11","1","6","Wali jarlu manyanangu jularni Ngarpungu Yijirayilkarrajiwarntiwujaa Jutajangkawarntiwu kartu palunya warntarnanku nyanartikarrajimipa jarntu ngajirta ngalunya marrijangka warnta. Nyanartijangka Jalamantu manya warntarni marriwarntijangka mapirrirni. Paja manya warntarni jarntuwarnti yarnta kanarlanywarnti marrijangkawarnti pajawarlanyparni. Wali marrijangkawarntirlu palu tikirrkujirni Ngarpukurajangka. Wali ngajirta pa Tayipitjilinyju wajilpungkarla Ngarpu jutungu pirlangkurrarni. Yangka pa Jalaman purrkujarrinya, nyanartikarra pa Ngarpu wanyjani. Kanarlanywarnti manya wajilpungani marrijangkawarntikura Ngarpujilinywarnti pamarrwarntijaa manawarnti. ");
INSERT INTO wmt_vpl VALUES ("K111_11","012_11_11","1KI","11","11","11","Nyanartijangka parla kulijarrinya Ngarpu, tumaj pa Ngarpu panypinya. Ngajirta pa mapunikarrarla wangki Ngarpukurajangka. Wali Ngarpungu parla marni Jalamanku, “Ngajirta man ngajukura wangki mapunikarrarla. Panypinya pajanurla, nyanartijangka nyuntukurawarntirlu wartangurnijangkarlu kilakiwarntirlu palunyanangu maja ngunawu yarr murrkurnku Jutajangkawarntiwumipa. Kanarlanywarnti palunyanangu king ngunawu Yijirayiljangkawarntiwu pajawu.” ");
INSERT INTO wmt_vpl VALUES ("K111_43","012_11_43","1KI","11","43","43","Wali nyanartijangka walimpawarlany purrkujarrinyjangka Jalaman pirlajarrinya, turnmanila palu mayarurla Jurujulumja Tayipitkurarla. Nyanartijangka walakunyankurala Jalamankura kingjarrinya yini Riyapun. ");
INSERT INTO wmt_vpl VALUES ("K112_1","012_12_1","1KI","12","1","19","Nyapartukarra palu ngunangani Jutajangkawarntijaa Yijirayiljangkawarnti kayirrarajaa kurlirra, yangkala manyanangu kayanparni king ngunangani Jalaman jarlu kajaluwarlany. Nyanartijangka pa kujarti pinakarrinyani nyantukurarlu walakurlu Riyapuntu. Kula manyanangu nyantu king ngunarla nukarniwurni kayilungujangkawujaa kurlirrajangkawu. Nyanartijangka manyanangurla yani Jurujulumjangka kayili kingkujirnupurru Yijirayilkarti. Pinalkarra manyanangu yani, kula palu murtarni kingkujirla. Wali nyantuwarntiliny palu yani kayilungujangkawarnti japirlyungupurru. Japirlyinya palurla, “Ngarpu nyuntukura pa ngunangani warrkam marnapanya yungani purlka, ngajirta yarpal.” Yarntarni palurla marni, “Nyuntungu marnanpangu ngunawu yarpalmartamarta, nyanartila marnangulurla jutungu warrkammarnankujaa wajilpungku marnantalu king.” Wali marni manyanangu Riyapuntu, “Kirranyjalu ngurrawarnti murrkurn, nyanartijangka marnanyirrangu julawu warra.” Nyanartijangka yani manyanangurla purrkuwarntikarti pinakarrinyupurru. Minyartiwarnti purrkuwarnti palu lirrkarnpungujuwal yangka palurla Jalamanku nira jirrkirlikanani jarlu. Marni palurla lirrkarnpungujuwalwarntirlu, “Yarpalmarta manunya warrkam yungku. Ngarpu nyuntukura pa ngunangani purlka warrkam yungujuwal. Nyuntu man ngunawu yarpal yungujuwal warrkam. Nyanartijangka jartamankula manta warramarta.” Wali ngajirta manyanangurla nyantuwarntirla kingju Riyapuntu mapunikarrarla purrkuwarntirla. Panypinya manyanangurla. Yanila manyanangurla pingkayiwarntikarti takijularnupurru yirrkujarrajangkawarntikarti. Japirlyinyala manya pingkayiwarnti. Wali kujarti palurla jularni pingkayiwarntirlu, “Ngajirta. Purlka manunya warrkam yungku. Wali julanyanangu, ‘Ngarpungu ngajujurarlu manya yinya yarpalmartamarta, ngajungu marnanya yungku purlkajinyangu.’” Kujarti palurla lirrkarnpinya pingkayiwarntirlu. Wali pirriyani palu yangkartiwarnti kayilunyjangkawarnti Yijirayiljangkawarnti Riyapunkarti pinalkarra. Marni manyanangu Riyapuntu, “Ngajirta. Ngajukurarlu ngarpungu manya yinya yarpalmarta warrkam. Ngajungu marnanya purlkajinyangu yungku warrkam.” Wali ngajirta manya Riyapuntu mapunikarrarla purrkuwarnti, nyantungu manya mapunikani pingkayiwarnti. Nyanartijangka nyantuwarntirlu palurlanyanu marni Yijirayilkarrajiwarntirlu, “Wanyjarrku parlipa minyarti nganpayi Tayipitkura kilaki. Ngurrakarti parlipa yanku.” Wali wanyjani palu kayilunyjangkawarntirlu Yijirayiljangkawarntirlu. Nyanartijangka nganpayi layi yiparni warrkammayin Riyapuntu wangkijarti Yijirayiljangkawarntikarti. Ngajirta palu pinakarrirla, partalurni palurla kulijarrinya. Pinyala palu pamarrjawurlu. Nyanartijangka yangka palurla jularni nyantukura warrkammayin pungujangka, nyantula rayinjarrinya Riyapun. Wali partalurnila paralaparni ngurtinga. Yawartawarntirlula palu ruwarrakanya, kurlirrala laparni Jurujulumkarti. Nyanartijangka kirrarnanila manyanangurla nyanayirla kurlirra Jutajangkawarntirla. King manyanangurla ngunangani Jutajangkawarntirlamipa. Wanyjani palu kayilungujangkawarntirlu Yijirayiljangkawarntirlu. ");
INSERT INTO wmt_vpl VALUES ("K112_20","012_12_20","1KI","12","20","20","Wali kanarlanypala palu nganpayi kingkujirni kayilunyjangkawarntirlu yini Jirapun warrkammayinjangka, ngajirta Jalamankura walaku. Nyanartijangka palu kirrarnani kurrinyjarti king Riyapunjartijaa Jirapunjarti. Yijirayiljangkawarnti palu kirrarnani pajajinyangu Jirapunjarti kayilunyjangkawarnti. Kurlirra pa kirrarnani Riyapun murrkurnmartajarti. Jutajangkawarntiwumipa manyanangu king ngunangani Riyapun. ");
INSERT INTO wmt_vpl VALUES ("K112_25","012_12_25","1KI","12","25","30","Wali nyanartijangka pajajawurlu pinapinakarrinyani Jirapuntu kayilijangkarlu. Marni parlanyanu, “Ngajukurawarnti piyirnwarnti ngalu yanta kurlila Riyapunkurakarti ngurrakarti Jurujulumkarti Ngarpu kajalkajalkujirnupurru. Ngarpu palu kajalkajalkujilany nyanayirla Jurujulumja Timpulla. Yurru marnarla nyangany. Puju kujartikarra ngartalu nira yananta, wanyjarra ngajalu ngaju, pungkala ngajalu wartangurni. Kunyungurla marnanyanangu kanarlanyjarra manajarra ngartakkarrku. Minyayirla palu kajalkajalkujirnanku.” Nyanartijangka pinya ngartakpani pamarrjarra purlumanjiliny Jirapuntu. Yutukanila pinya ngurrujarra mayarujarrarla Yijirayilla kayili. Jularni manyanangu Yijirayiljangkawarntiwu, “Marri manyirrangurla Jurujulum. Minyartijarra marnanya yungku manajarra. Minyayirla manta marnpa kajalkajalkujirnanku Ngarpujarrajiliny.” Nyanartijarra manya watanymani purlumanjilinyjarra. Nyanartijangka purlumanjarra palupinya wajilpungani. Rukarni palunyanta mapunta Ngarpunga Yijirayiljangkawarntirlu piyirnwarntirlu. Wali Jutajangkawarnti palu warrarni ngunangani Timpuljartiwarnti. Ngarpu palu wajilpungani kurlirrajangkawarntirlu Jutajangkawarntirlu. ");
INSERT INTO wmt_vpl VALUES ("K114_22","012_14_22","1KI","14","22","29","Wali ngarrjarni palu wajilpungani Ngarpu Jutajangkawarntirlu. Nyanartijangka walimpa palu yarpalmartajarrinya. Ngarpujilinywarnti palurlanyanu ngartakpani kanarlanywarnti yiniwarnti Ajirawarnti. Pajajinyangu palunya yutukani ngaluwarntirlajaa pamarrwarntirla. Yarnta palunya ngartakpani mayaruwarnti yutukanupurru Ajirawarnti. Yarnta palunyanangurla yukarnani nyanartiwarntirla mayaruwarntirla. Kanarlanywarnti mapirrirni palunya kartukujirnani. Kujarti manyanangu ngunangani nyantuwarntikura yurru Ajirakurawarntiwu. Layimirri manyanangurla pirriyani kingwarlany Yijipjangka kulipari pungujuwal, yarnta manya kanarlanywarnti kanya piyirnwarnti, pinyala palunya Jurujulumjangkawarnti. Wali nyanartijangka yarnta manya warntarnkarrakanya Timpuljangka jarawarnti wulyuwarntijinyangu muyurrpirriwarnti ngurru, yangka manya jarlu yutukani Jalamantu. Timpuljangka manya yapkanya Ngarpukurawarnti Yijipjangkarlu kingju. ");
INSERT INTO wmt_vpl VALUES ("K114_30","012_14_30","1KI","14","30","31","Yarnta palunyanu pungani Jutajangkawarntirlujaa Yijirayiljangkawarntirlu yangka pilanyanangu kingkujarra ngunangani yinijarra Riyapunjaa Jirapun. Nyanartijangka purrkujarrinya Jutajangka kingwarlany Riyapun. Wali pirlajarrinyala, nyanayirlarnila palu turnmani Jurujulumja Tayipitkurarla marnparni, tumaj parla Tayipitkura kilaki nyanarti nganpayi Riyapun. Nyanartijangka kingjarrinya walakunyankura Riyapunkura jirnajangka. Nira palu ngunangani kujarti Jutajangkawarnti. Yangka palunyanangu ngarpuwarnti ngunangani king kajalujangkawarnti, wartangurnila palu walakuwarnti kingjarrinyaniwarlanyparni. Kujartikarra palu nira ngunangani. Wali Yijirayiljangkawarnti palu kanarlanyparni ngunangani. Yarnta ngajirta palunya takingu kingkujirnantarla jarlujangkakura walaku. Nyantungurni palunyanu kingkujirnani pungujangkarlu. Kanarlanywarntiliny palunya pungani kingwarlany pirlawurra, nyanartijangkarlu partalurni palunyanu yarntarni kingkujirnani jirnajangkarlu, yarnta kanarlanywarnti palu pirlajarrinya purrkujarrinyjangka. Kujartikarra kujartikarra palu ngunangani Yijirayiljangkawarnti. ");
INSERT INTO wmt_vpl VALUES ("K116_28","012_16_28","1KI","16","28","31","Nyanartijangka walimpa manyanangu kingjarrinya nganpayi Ayap Yijirayilkarraji. Wali ngajirta pa Ngarpu wajilpungkarla, munta pilangu kayan ngunangani kurrinywarlanyku Payilkujaa Ajirawu. Nyantujarrawu pilangu ngurt ngunangani Ayap pamarrkujaa manawu. Nira palupinya ngartakpanani Ngarpujilinykujarra Yijirayiljangkawarntirlu. Nyanartijangka yarntarni parla Ayapju mayaru ngartakpani Timpul pamarrku Payilku, nyanartila yutukani kaninykaniny timpulla. Ngajirta Ngarpukura Timpul, minyarti kanarlanyparni. Yarntarni marnin parlanyanu kayilunyjangka warntarni yini Jisipil. Nyantungu mapirri pinya wajilpungani pamarrjaa mana. ");
INSERT INTO wmt_vpl VALUES ("K117_1","012_17_1","1KI","17","1","7","Wali nganpayi puraput Yilayija Ngarpukurajinyangu ngunangani. Ayapku parla marni nyantukurawu kingku Yilayijarlu, “Ngarpungu paji jularni. Kayan ngarlipangu ngapa wanti. Yitilalwarnti murrkurn parlipa ngunawu ngapangajirta. Nyanartijangka walimpa marnangu julawu ngajungurni ngapa wantinyupurru.” Nyanartijangka wanyjanila Ayap. Marni parla Ngarpungu Yilayijawu, “Yanku man. Wanyjarrku man minyarti ngurra. Kakarra man yanku palmakarti yinikarti Jirritkarti. Ranyjiwantiwu man nyanayirla. Yarntarni marnanyanangu wangkarnawarntiwu marni pikawurra, miyi mantalu kangungurla yunganku karuwarrajaa kumantajarti. Ngapa marnangu jarlu jinpinya.” Walila jakarni. Yanungurla pirriyani nyanayirla ngapanga. Walila nyanayirla kirrarnani palmanga ngapajartirla. Miyila palurla jirikirlu kangungurla yungani wangkarnarlu. Miyijaa kuyi palurla yungani karuwarrajaa kumantajarti. Kirrarnani nyanayirlarni. Walimpa parla kurrkantinya ngapa nyanarti. Pulparrjarrinya lamparn palma. Ngapangajirtarni wantirla kaparnwarlany, yitilalwarnti mungkartu nguja marlalparni ngapangajirta. ");
INSERT INTO wmt_vpl VALUES ("K117_8","012_17_8","1KI","17","8","16","Ngarpungu parla marni Yilayijawu, “Yanku man kayili Jarapitkarti. Wali marnangu jarlu pikakujirni. Kalkarrawu marnarla jularni miyi manta yirranganku.” Nyanartijangka yani ngarrjarni. Walimparni pirriyani nyanartikarti ngurrakarti Jarapitkarti. Jamurn marnpajarrinya tawunkarti, kiyittala parlipinya nyanartirni marnin kalkarra. Warlu parlanyanu warntarnani tawunngurni ruwangu. Japirlyinyala parla Yilayijarlu, “Wayila ngapa nguniny lurru. Kangkaji.” Nyanarti kalkarra tawunkarti yani jamurnku ngapawu warntarnupurru. Yarntarni parla pawumarni, “Kangkaji miyi mapirrirni.” Jangkumani manyanta marnintu, “Mapunparni marnangu malany. Ngajirta marna miyi marta. Yarr pajarrangu lamparn nguniny parriwujaa ngajuwu. Yarr marnajin warluliny karrpungany ruwangu, tikirrkangurlala marna miyi kampawu. Pujujarriwu nyanarti miyi, yarrpala pajarra marranyanjarti ngunangurla pirlajarriwu.” Marnila parla Yilayijarlu, “Ngajirta ngankurla yarpal nguna miyiwu nyanartiwu. Yanungurla miyi ngartakkarra nyanarti lamparn, nyanartijangka ngajuliny pajan yungku pukarr ngarnupurru. Nyurrajarrarlula manpila wartangurni ngalku. Kujartikarra paji marni Ngarpungu Yijirayilkurarlu, kayan ngarta pujujarri miyi nyanartijangka pakirtijangkajaa kayan ngarta pujujarri nyanarti jira. Kayan ngartapila pujujarri miyijaa jira. Kujartirni pila ngunawu kitangarni ngapa pirriyanku. Ngarpungu parlipangu yipawu ngapa walimpa.” Wali jira nyanarti pa pulawarla purtkujirnuwu ngapajiliny kurraparlula kirninymanuwu. Mapunikanila manyanta Yilayijarla miyipurru kamparnupurru. Wali ngujala palu. Miyi palu ngarnani puranguwarlany puranguwarlany. Ngajirta pujujarrinyantarla miyijaa jira nyanarti. Kujartirni pila nguja. Nyanartikarra parla takijularni Yilayijarlu Ngarpukura wangki marninku, kayan ngarta pujujarri jirajaa pulawa nyanarti. ");
INSERT INTO wmt_vpl VALUES ("K117_17","012_17_17","1KI","17","17","24","Wali nguja palu. Nyanartijangka parri mimila wantinya. Yukarnani lamparnpaliny mimi. Nyanartijangka purlkajarrinyanila kujangkurrarni mayajarrinyani mimi. Nyanartijangka pirlajarrinyala nyanarti parri kalkarrakura. Wali marni parla kalkarrarlu kujartikarra, “Purlkajal man nyuntu Ngarpukura nganpayi. Nyapartu man pirriyani mirnu ngajukarti. Kunyungurla mankurla Ngarpuwu jularni ngajukura yakurryakurr. Kunyungurla nyanartijangkala paji Ngarpungula pinya parri minyarti ngajukura.” Yilayijarlu manyanta ngarntikanya, “Yungkaja parri nyanarti mirnu.” Wali ngamurlumani parri nyanarti, kanyala kankarral nyantukurakarti ngurrakarti, wanyjarrarla yukarnani nganpayi Yilayija kaninykaniny. Nyanartikarti parakangurla tujkujirni nyantukurarla pilangkirra. Wali Yilayijarlu parla marni Ngarpuwu, “Nganapurru manurla lunguwu jinjinyinya minyarti kalkarra marnin. Parri manurla pinya. Wulyuwulyu paja nyantungu yungani miyiwarntijaa ngurra paja yinya.” Wali tujkujirnurla manyanta lapartwantinya kankarnimarrangu. Ngarntimani manyanta Ngarpunga kankarral, “Ngarpu jalarra tikirr wanjikuji minyarti yapa.” Yarntarni turtapinya, nyanartijangka tikirr manyanta yarntarni lapartwantinya. Yarntarni parla japirlyinya Ngarpu. Nyanartijangka yarntarni tikirr turtapinya, yarnta manyanta lapartwantinya. Japirlyinya parla kirlingalparni Ngarpukarti kankarral murrkurnmirri. Wali nyanartijangka tikirr turtapinya. Nyanartijangka Ngarpungula parla pinakarrinya wangki Yilayijakura. Mapunikanila Ngarpungu. Nyanartijangka nyanarti parri wanjikujirnila Ngarpungu. Nyanyala rangarnani Yilayijarlu. Wali warntarnkarrakanya Yilayijarlu tikirr manyanta ngamajikarti. Kangurla parla yinya. Wali marnila parla Yilayijarlu kujartikarra, “Nyaka. Parri mangu wanjijarrinya.” Wali marnintu parla kujartikarra marni, “Wali mapunikarralany marnanta, mapunparni man Ngarpukurajinyangu. Ngarpungu manta yungany wangki, julalany marnanpangu nganampawu mapunparni Ngarpukura wangki.” ");
INSERT INTO wmt_vpl VALUES ("K118_1","012_18_1","1KI","18","1","19","Wali nyanartijangka murrkurn yitilalwarntirla ngapa ngajirtarni wantirla. Nyanartikarra parla marni Ngarpungu Yilayijawu, “Yantanyanta Ayapkarti. Yanungurla mankurlanyanu kalarakujiwu. Wali ngapala marna yipawu.” Nyanartijangka jakarnila Yilayija kurlirrara. Kaparnparni yanani. Wali nyanartikarra palu juturni ngunangani ngapangajirtarni wantirla. Wali pujujarrinya manyanangu yuka Jimariyarla yawartawujaa miyulku. Ayapju parla warrpajparni nganpayiwu Wupatayawu. Ayapkura mayaru parla ngampurrikanani nganpayirlu Wupatayarlu. Marni parla Ayapju, “Mirnu yanta. Wangki parli malku. Yawartawarntijaa miyulwarnti nyapartukujiwu parlinya. Ngapawu jilawarntiwu muwupungkurlirla yukajartiwarntiwu. Marranyanjarti ngarlingulu pirlajarri. Waliwarlany parlipanya pungku partalurni yawiyirlamarra.” Kujartikarra pilarlanyanu marni nyantujarrarlu Ayapjujaa Wupatayarlu. Nyanartijangkala pilanyanu jaarlani kujangkurrajarra muwupungkarra yukawujaa ngapawu. Martuwarrawarntirla rirringki yukawujaa ngapawu pilarla muwupungani wulyuwulyuwu wurrkaljartiwujaa ngapajartiwu. Kunyungurla jilawarntirla nguniny yuka wulyuwulyu yawartapurru ngarnupurru nyanartiwarntirlal, yarnta martuwarrarlal rirringki. Wupatayarlu parla Ngarpuwu mapunikanani. Ngajirta manyanangu nganawurtiwu mapunikarrarla kanarlanyku. Ayapkurarlu kartungu manya jarlu puraputwarnti pungani pirlawurra nyantungu manya Wupatayarlu kanya pajajinyangu puraputwarnti 100. Ranyjikujirni manya najijarrarla Jisipilkarrarla rayin. Kuyijaa miyi manya ranyjingurni kangurla yungani Wupatayarlu ngapa mapirrirni. Wali Wupatayarlu parla yukawu muwupungani ngapawu mapirri. Ngangayanani, nyanartijangka Yilayija murtarni pirriyani. Yangkala parlipinya Wupatayarlu, nginyjirrikanila. Parntawantinya manyanta marnparni Wupataya kajalkajalkujirnupurru nyanarti puraput Ngarpukura. Marnila parla, “Mapun ngan nyuntu Yilayija.” “Yu. Ngajujal marna,” marni parla Yilayijarlu. “Jalarra mankurla yanku. Malku mankurla nyuntukurawu majawu purlkawu Ayapku. Pirriyani marna.” Marnila parla Wupatayarlu, “Nganapurru pajan ngaju jinjinyungana. Yanungurla marnarla malku Ayapku. Parlipinya marnanta. Kayan ngarnarla yanungurla manyja ngajungu. Puju marnarla yanku, nyuntu marnanta wanyjarrku minyayirla, wali nyanarti, puju manta Ngarpungu Pirlurru warntarnkarrakangku marri yangkartijilinyparni. Tikiyanurla pajarra Ayapjarrarlu jakarr nyaku, nyapartu malku paji. Nyanarti paja murtarni pirla pungku. Nyuntu pinarri ngankurla muwupungani mangu ngurrawarlany ngurrawarlany marriwarnti wamarnkujarra. Japirlyungani manya nyuntuwu, wanyjurlajarra manya purlkawarnti japirlyungani. Jirnapungani palurla yangka waliwarlanyparni. Jakarrparni kujala. Nyantungu Ayapju manya jutungu japirlyungani. Ngajirta manya partalurni mapunikarrarla. Panypungani manyanangurla. “Minyarti nyapartu pajan jinjinyungany, wali kunyungurla pajan kujikanana. Ngajujal marna Ngarpukura. Jarlujangkarlu marnarla Ngarpuwu mapunikani lamparnngurnijangkarlu parringurnijangkarlu kitangarni jalarra. Pinarri pajin nyuntu, yarnta nyuntu pinarri ngankurla ranyjikujirni marnanya puraputwarnti paja 100 tukujarra kurriny najijarrarla, Jisipilkarrarla Ayapkura kartu. Marnintu nyanartirlu Jisipillu manya jinjinyungani piyirnwarnti nyantukurawarnti, Ngarpukurajartila piyirnwarnti puraputwarnti palunya pungani pirlawurra Jisipilkurawarntirlu.” Yarntarni parla marni Wupatayarlu Yilayijawu, “Mapunparni marna Ngarpukura. Nyapartu pajan jinjinyungani yanungurla marnarla julawu nyuntu marnanta nyanya nyanarti paja mapunparni pirlala pungku.” Yilayijarlu manyanta jangkumani. Marnila parla, “Nyuntu man yanku kujangkurra. Malku mankurla Ayapku, ngajungu marnarla jarranyaku minyartingurni. Mapun marnangu malany mapunparni. Ngaju marna Ngarpukurajinyangu.” Wali Wupataya yani, pirriyani parla Ayapku. Marnila parla Wupatayarlu, “Yangkartiwu marnarla pirriyani, yangka parliparla warryinyangurra ngurrawarlany ngurrawarlany nganpayi Yilayijawu.” Wali Ayap jakarni. Yani pa, pirriyanila parla. “Ya. Minyakujalan ngurrawarlany ngurrawarlany marnangulu warryinya yangkarti ngapa lamakujirnujuwal. Kujikarralany manpanya Yijirayilkarrajiwarnti.” Yilayijarlu parla marni, “Ngajirta marna ngaju ngapa lamakujirnujuwal. Nyuntu mankurlanyanta julngurrujarrinya Ngarpungurni. Jirnangalparni man nyuntukura ngarpu jartamanany. Kanarlany manpila jartamananyjaa kajalkajalkujilany pamarr yini parla Payil. Ngajirta man Kut mapunikarra.” Jinjinyinyala parla Ayap Yilayijarlu, “Kaj. Marurrpungkanya pamarrkarti Kaamulkarti. Warrwajilpungku parlipanyanu. Marurrpungkanya piyirnwarnti Yijirayilkarrajiwarntijaa yangkartiwarnti purlkawarnti Payilkurawarnti kajalkajalwarnti yangka warnjaljilinyparni 450. Yarntarni kanarlanywarnti Ajirrakurawarnti kajalkajalwarnti warnjaljilinywarlanyparni 400. Ajirrakurawarnti piyirnwarnti warrkammayinwarnti palurla nguniny Jisipilku. Yungany manya miyi marnintu Jisipillu. Nyaku marnanya yangkartirla pamarra kankarni yininga Kaamulla.” ");
INSERT INTO wmt_vpl VALUES ("K118_20","012_18_20","1KI","18","20","24","Wali nyanartijangka marurrpinya manya Ayapju pamarrkarti Kaamulkarti Yijirayilkarrajiwarntijaa Payilkurawarnti. Warryanila palunyanta pamarra kankarra marri nganpayirla Yilayijarla. Wali Yilayijarlu manyanangu marni, “Nyapartu manta wampalmalany. Nyangurla manta munta kayanjarriwu, puju manta yirrikarralany wanyjarra mapunjinyangu. Wanyjarrawarntirlu manta Ngarpu nyangany purlka kajalkajal, wali jartamantalu. Wanyjarrawarntirlu palu Payil nyangany purlka kajalkajal, waliwarlanyparni manta jartamanku.” Yilayijarlu manyanangu marni kujartikarra. Piyirnwarntirlu palu yarr wutangurni pinakarrinyani Yilayija. Yarntarni manyanangu marni Yilayijarlu, “Ngaju marna kayan Ngarpukura karrilany. Kanarlanywarnti yangka 450 warnjaljiliny palurlanyanta lurrpantinya Ngarpungurni. Wajilpungany palu kanarlany yini Payil.” Yarntarni manyanangu marni kujartikarra kuyijarra purlumanjarra warntarnupurru. Wali marni manyanangu Yilayijarlu, “Kayan nyurrawarntiwu purlkawarntiwu yangka manta Payil wajilpungany. Manawarnti lalkawarnti manta mungkurrpungku, wali kuyila manta yutukarrku kankarnumarrangu warlupurru warrapurru. Jungjungmanurla mantarla kutakutakujiwu purlumanu. Kutakutakujirnurla manta yutukarrku kankarnumarrangu lalkanga manawarntirla. Ngajungu marnajin warntawu kayanwarlanyparni purlumanu jipirra. Ngajungurni marna kutakutakujirnurla yutukarrku mananga kirlingalparni. Ngajirta ngarlipa turlkuji warlu tiliwurra, warrarni pila ngunawu. Nyanartijangka mantarla japirlyungku kankarral nyurrawarntikura pamarr Payil warlupurru turlkujirnupurru. Ngajungu marnarla kujartiwarlanyparni japirlyungku ngajukurawu Ngarpuwu turlkujirnupurru.” Wali ngarrurtajarrinya palurla piyirnwarnti wangkiwu Yilayijakurawu. ");
INSERT INTO wmt_vpl VALUES ("K118_25","012_18_25","1KI","18","25","29","Yilayijarlu manyanangu marni Payilkurawarntiwu piyirnwarntiwu, “Nyurrawarntijal manta paja. Nyurrawarntirluliny manta pungku layi purlumanu, jungjungmanurla yutukarrkula manta kutakuta kankarnumarrangu. Ngajirta nganta turlkuji.” Nyanartijangka palu warntarni kuyi nyanarti purlumanu. Pinyala palu kuyi. Jungjungmanurla palu kutakuta yutukani kankarnumarrangu manawarntirla. Kumantajal palurla juntumani. Pawumarni palurla kumantajangkarlu, purayimarnani palurla Payilku kumantajangkarlu. Wamarnkanyjirnani palunyanta kuyinga purayikarrarlu. Payilku palurla purayimarningurra. “Pinakarrinyanpanya Payil. Warlu yiparnanpangu. Japirlyungany marnantalu.” Wali jininyarajarrinya manyanangurla. Yinkirni palu purayimarnani jartijinyangu. Ngajirta manyanangurla jangkumantarla Payillu. Jininyarajartijarrinyajangka manya Yilayijarlula jingkirrkanya. Kujala manyanangu marni, “Mayamarta purayimanyjalurla. Kunyungurla pa pukurrpukurr kirrarnana, kayan nganya pinakarri. Mayarni pawumanyjalurla, yarnta kunyungurla ngapajangka parta karrinyana.” Juturni manya jingkirtimarnani Yilayijarlu, “Kunyungurla wurna parta yani marri. Kunyungurla manyan parta yukarnana. Mayarni pawumanyjalurla. Parnkimankuwurti manta. Warlu manyirrangu yipawu partalpartal.” Wali junganani palunyanu nyantuwarntirlu Payilkurawarntirlu. Yarntarni palunyanu jarntungurni jitaklanani nungujartiwurra. Wali nyantuwarntikura kartiny kujarti palunyanu jarlu jungjungmanani Payilkurawarntirlu. Jarlula karuwarrajarrinyani. Wurna yarrpala palu karrkarrmarningurra wangartajiliny. Ngajirtarni manyanangurla jangkumantarla marlalparni. ");
INSERT INTO wmt_vpl VALUES ("K118_30","012_18_30","1KI","18","30","37","Wali Yilayijarlu manyanangu marni, “Mirnu yantanilu. Wamarn karrijalurla ngajunga.” Marnila manyanangu kujartikarra. Marnpakujirni manya piyirnwarnti nyanartiwarnti. Wali nyanartijangka pamarrpala manya japurnani ngumuwarnti jarlujangkawarnti. Kayantakujirnani manya. Tikirrkarrakujirnani manya Yilayijarlu. Jarlu palunya tarratarrapinya. Wali kayantakujirnila manya kirlingarni Yilayijarlu pamarrwarnti nyanartiwarnti. Nyanayirlarni palurla jarlu Ngarpukurawarntirlu pamarra kuyi kamparnani Ngarpuwu purayikarrarlurni. Purayimarnani palurla Ngarpuwu. Wali yutukani manya Yilayijarlu kirri pamarrwarnti nyanartiwarnti 12 yinijartiwarnti pinalkarrapurru. Jularni manyanangu Yilayijarlu yinijartiwarnti kilakiwarnti, “Minyartiwarnti manyirrangulu kilakiwarnti nyurrawarntikura. Ngarpu palu kajalkajalkujirnani jarluwarlany nyurrawarntingajirtarla.” Wali layiwarlany nganpayiwarlany kajaluwarlanyjangka manyanangu ngarpu 12ku nyanartiwarntiwu, yini parla Jayikap. Yinijarra kurriny pinya martarnani Jayikapjaa Yijirayil. Wali Yilayijarlu manya yutukani pamarrwarnti Ngarpupurru kajalkajalkujirnupurru. Nyanartijangkarlu mulnyila karlarni nyanayirlal pamarral. Wamarn karlarni ngarrjarni ngapawu tarrpartarnuwu. Wali nyanartijangka warluwarntila lalkawarnti warntarni. Yutukani manyanta nyanayirla pamarra kankarnumarrangu Yilayijarlu. Wali kuyila warntarni nyantungurni kutakutakujirni pa warlupurrupurrurni. Yutukanila manya kutakuta kuyi manawarntirla kankarnumarrangu. Wali jinjinyinya manya, “Pakirti warntalu ngarrjamartarni ngapawu. Purlantalu, purtkujiwula mantanyanta kuyingajaa nyanayirla warlunga lalkanga.” Wali purtkujirnila palunyanta kuyingajaa warlunga lalkanga kankarnumarrangu. Ngapa jilkarnani manyanta warlunga kankarnumarrangu. Yarntarni manya jinjinyinya Yilayijarlu. Purtkujirni palunyanta, yarntarni manya jinjinyinya, purtkujirni palunyanta. Kitangarni ngapangu tipani nyanartirni kurrkungal wamarn karlarnujangkarlal. Ngapa manyanta nguja. Wali karuwarrarlurra purayimarni parla Yilayijarlu. Kujarti palu nira purayimarnani karuwarrarlurra Ngarpukurawarntirlu Jurujulumja, nyanartikarra purayimarningurra Yilayijarlu pamarra Kaamulla. Marni parla Ngarpuwu, “Ngarpu nyuntu manyanangu kajalkajaljinyangu jarluwarlanyjangka yangkartiwarntijiliny manunya ngampurrikanani Ayiparanjaa Jayikapjaa Asik. Nyanartijilinyparni marnangu nguniny Yilayija wartangurnijangka warrkammayin nyuntukura. Wali yipanyanangu. Turlkujiwu man minyarti warlu kuyi mapirrirni, nyanartijangkarlu mangulurla mapunikarrku, nginyjirrikarrkula mantalu mapunparni Ngarpu mapunjinyangu mayajarti. Yangka palu nyaku warlu manyjirnujangka, wali nginyjirrikarrkula pajalu ngaju, yangka ngapapurru pajin nyuntungurni marni jarlu, mapunparnila marnanyanangu jularni, ngajirta ngajukurajangka.” Yarntarni parla japirlyinya Ngarpu Yilayijarlu, “Ngarpu jangkumantaja. Mapunparni marnangu marnana. Jalarrarni manunya tikirrkujiwu minyartiwarnti piyirnwarnti. Wali mapunikarrkula mantalu nyuntu.” ");
INSERT INTO wmt_vpl VALUES ("K118_38","012_18_38","1KI","18","38","40","Nyanartijangka Ngarpungula yiparni warlu yalkiringurni kanimpal. Wali turlkujirnila, manyjirnila manya nukarnini kuyijaa manajaa pamarrwarnti. Pujukujirni manya nukarnini warlungu Ngarpukurarlu. Nguwa mapirrirni manyjirni kurnkurnwurra. Ngapa yangkarti rirringkirla wamarn nguja nyanarti warpiny yilymanyjirni. Nyanartijangka piyirnwarntirlu palu nyanya. Jamurn palu nyanya nyanarti warlu, manawarnti warpiny manyjirnujangka, murtarni palunyanu tarrapinya kanimparral nguwangkurra. Nyanartijangka palu murtarni marningurra, kajalkajalkujirni palu Ngarpu. Nyantu pa Ngarpu kayan parlipangu kajalkajal pajawu, ngajirtarni parla nganawurti tanyji nguna. Nyantu pa kayanjinyangu. Nyanartijangka manya Yilayijarlu jinjinyinya, “Tarrpartalunya nyanartiwarnti Payilkurawarnti purlkawarnti pujurni. Ngajirta ngarta kayanwurti laparnkarrangka.” Nyanartijangka palunya piyirnwarntirlu tarrpartarni. Wali kanimparral palunya kanya martuwarrakarti yinikarti Kijankarti. Yilayijarlu manyanangu jarrkangani. Nyanayirlala manya jinjinyinya Yilayijarlu, “Piyirnwarnti pungkalunya nyanartiwarnti Payilkurawarnti pirlawurra.” Wali nyanartiwarnti palunya pinya Payilkurawarnti purlkawarnti. ");
INSERT INTO wmt_vpl VALUES ("K118_41","012_18_41","1KI","18","41","46","Nyanartijangka Yilayijarlula parla marni Ayapku, “Miyi nganyja. Jarlu marna pinakarrilany ngapa rangkurrmanujangka.” Wali miyikartila yani Ayap. Nyanartijangka nyantu Yilayija tikirrparayani kankarni pamarra kirlingarni. Purayipurayimarnani nyanayirla kankarni pamarra Kaamulla. Warrkammayin nyantukura mapirri manyanta nguja. Parntawantinya nguwanga kaniny Yilayija. Janginy manyanu yutukani nimirtijarrarla kaparn nguwangapurru. Yangka kaji parla purayimarnani Yilayijarlu Ngarpuwu, nyanartikarrarnila parla jinjinyinya warrkammayin nyantukura, “Karlarrara parayanta jawurlatakarti, nyaka.” Pajangal yiparnani tikirrparni tikirrparni, yiparnani Yilayijarlu warrkammayin nyantukura. Wali yiparnani parlipungupurru tikirrparni tikirrparni. Walimpa nyanarti warrkammayin tikirrwantinya wangkijarti. Jularnila parla Yilayijawu, “Yu. Nyanya marna lamparn yurnturr piyirnjiliny kurrapajiliny. Parayanany jawurlatarlal kankarninyirra mirnu.” Yilayijarlula parla marni nyantukurawu warrkammayinku, “Yanungurla manyjarla Ayapku. Partapartal pa tikiyanku nyantukurakarti ngurrakarti. Ngajirta ngarta yinki kirranyja minyayirla, yangkala ngarta lamakuji ngapangu. Manyjarla partalurni pa paralapalku pakinga manyanta, yangkala ngarta yapatamanyja lukanga, puju ngarta warrarni nguna, ngapangu ngarta lamakuji.” Nyanartijangka yarr partalurni rukantinya ngapa kankarnumarrangu. Mungajarrinya. Yarrpala wantinyangurra ngapa purlka jipirrarni. Ayappala parayani pakinga. Laparnila wurna Jisrilkarti tikirr. Nyanartijangka Ngarpungu parla yinya maya Yilayija. Yilayijarlula manyanu karrpirni kuluwuj nyantukura juwaljangka kutawurra. Jamurnparni pupurupurru laparnupurru manyanu karrpirni muntanga. Turitijiliny juwal kujartikarra palu nira kangani nganpayiwarntirlu. Nirn ngarta wiyimantarla palyangu. Laparnila nyantuliny pirrilaparni ngarrjamartarni laparni pupuru. Nyantulinypala pirrilaparni Jisrilla. Ayap warrarni laparnani wartangurni marnparni. Pirriyanila manyanta nyantukurarla kartunga. Jularni parla wangki nyapartukarra palu kankarni nguja Kaamulla. Partalyarru marni parla pujurni wangki. Warrarnila pila ngunangani Jisrilla. Ngajirta pila Ngarpu wajilpungkarla. Ngujala pila yitilalwarnti ngarrjarni, kurlila palunyanu pinya, layingu nganpayirlu lani pirlawurrarni Ayap. ");
INSERT INTO wmt_vpl VALUES ("K119_19","012_19_19","1KI","19","19","21","Wali nyanartijangka Yilayija wurna yanani kuwutjarti warnturajarti. Nyanarti kuwut pa Juwujwarntirlu palu wirrimkangani. Parlipinyala nganpayiwarlany purlumanujawurlu warrkammarnani katin. Pajangu palu warrkammarnani purlumanuwarntijawurlu. Wali jatparamani manyanta yininga Layijanga wirrimkujirnila manyanta kuwut Layijarla Yilayijarlu, wurnala yani. Wali Layijarlu wanyjani purluman nyantukura, wartangurnirlula wajilpinya nganpayi Yilayija. Marni parla Yilayijawu, “Warra. Nurtpungku marnapinya ngajukurajarra ngamajijaa ngarpu. Yankula marnantarla nyuntunga.” Yilayijarlu jangkumani, “Yantapilangu. Kayan ngarnangu jarrmanyja.” Wali yuwuk purlumanjarrajangka warntarni Layijarlu, jungjungpajani, jartkujirnila. Nyanartijangka kurrinypala pinya purlumanujarra. Kamparnila manyanangu yiji. Wurnangu manya yungku. Pujujarrinya manyanta katinta warrkam, Ngarpukurakartila yani warrkam. Wali ngarnila palu nukarnirlu, nyanartijangka wurnala manyanta jakarni Yilayijarla. Nyanartila manyanta mapirrikarrajijarrinya nganpayiwarlanyja. Pinarrikujirnani parla nyapartukarra ngunawu puraput Ngarpukura Yilayijarlu. Yarnta pa marlamanani Yilayija nira. Mapirrila pila yanani. Pinarriyunganila parla takiwurra warrkam Ngarpukura Yilayijarlu. ");
INSERT INTO wmt_vpl VALUES ("K22_6","013_2_6","2KI","2","6","8","Nyanartijangka marni parla Yilayijarlu mapirrikarrajiwu, “Wurna marna yanku martuwarrakarti. Ngarpungu paja jinjinyinya nyanartikarti martuwarrakarti yanupurru. Nyuntu man lama kirralku minyayirla.” Mapirrikarrajirlu parla marni, “Ngajirta. Ngaju marnangurla yanku mapirrirni, ngajirta ngajan wanyjarra.” Wali yanila pila mapirri. Nyanartijangka puraputwarnti paja pilangulurla yani. Wajilpinya palupinya martuwarrakarti. Wali jatparamanila pila. Nyantujarra pila kajalurni karrinyungurra, kanarlanywarnti palu karrinya wartangurni. Warntarni Yilayijarlu kuwut nyantukura, nyanartijangkarlu rulumapkujirni. Karlpinyala kaparn ngapa nyanarti. Kayirrajaa kurlirra pila ngapajarra laparningurra. Pulparrala pila kakarrara tirrinyyani karlpungujangkarlal. ");
INSERT INTO wmt_vpl VALUES ("K22_9","013_2_9","2KI","2","9","14","Nyanartijangka karrinyanila pila. Marni parla Yilayijarlu, “Nyapartu malku marnangu wurnangu, yangka paja yapkangku Ngarpungu.” Nyantungu parla marni mapirrikarrajirlu, “Wulyumalany marnarla nyuntukurajilinyku mayawu, yangka manta Ngarpungu yinya jarlu.” Yilayijarlu parla marni, “Puju pajan nyaku yapkangujangka, mayajartila man ngunawu ngajukurajarti wartangurni.” Nyanartijangka wangkikarra pila wamarn kitpungani. Wali kankarnumarrangu pilangu murtarni wurlurlupajani ngurtijiliny yawartajarti. Kaparnjarrinyala pilangurla. Wali kanarlanyparni pa nyanarti warlujartijiliny. Wali walypajilinyjurni tawurnpinya nganpayi Yilayija, yapkanyala kankarral yapinkarti. Jamurn kankarnijarrinya Yilayija, kuwutpala manyanta wilantinya. Wali nganpayi nyanarti mapirrikarraji, yarrpala wampalkarra karrinyangurra wartangurni. Nyanartijangka pawumarningurra parla, “Ngarpu ngajukura. Ngarpu ngajukura. Yap nganu yani. Purlka marnanpangu nyuntu Yijirayiljangkawarntiwu.” Yarnta ngajirta nyakarla, nirnparni parlanyanta yapyani. Nyanartijangka Layijarlula langkirrmani parlanyanu kuwut karrkintajangka yawiyirlu. Wali nyantuwarntikura yurru manyanangu kujarti langkirrmanani palurlanyanu kuluwuj yawiyirlu. Wali warntarnila nyanarti kuwut Yilayijakura nganpayirlu mapirrikarrajirlu yangka manyanta wantinya. Martarnanila wartangurni, Tikiyanila martuwarrakarti. Nyanartijangka karlpinyala Yilayijakurajawurlu kuwutjawurlu. Marnila, “Wanyjurla Ngarpu Yilayijakura.” Nyanartijangkarlu yarntarni karlpinya kurrinymirri, ngurrujarrajarrinyala pila ngapajarra. Kayilijaa kurlirrala pila murrulaparni. Wali tirrinyyanila pulparral. ");
INSERT INTO wmt_vpl VALUES ("K22_15","013_2_15","2KI","2","15","18","Nyanartijangka parlipinyala palu puraputwarntirlu. Marni palurlanyanu, “Minyarti nganpayi pa pirriyani mayajarti Yilayijakurajarti.” Wali japirlyinyala palurla puraputwarntirlu mapirrikarrajiwu, “Wanyjungu yangkarti nganpayi maja nyuntukura. Kunyungurla pa Ngarpungu wanyjani pamarra marri. Muwupungku marnalurla.” Nyantungu manyanangu jarrmarni, “Ngajirta nganta yanta.” Wali tilajparni palu jutungu nyantuwarntirlu, kitangarni manya yiparni. Marni manyanangu, “Kaj. Yantalu.” Nyanartijangka muwumuwupungani palurla ngurrawarnti murrkurn. Ngajirtarni palu parlipungkarla. Tikiyanurla palurla jirnapinya. Marnila manyanangu nyantungu, “Mapunparni marnanyirrangu jarlu jarrmarni. Ngajirta pajanta mapunikarrarla, panypinya pajantalu.” ");
INSERT INTO wmt_vpl VALUES ("K25_1","013_5_1","2KI","5","1","6","Wali nyanartijangka kayilungujangka palu pirriyanani Jiriyajangka Yijirayilkarti. Ngajirta palurla pinarri Ngarpuwu. Wali pungani palunya Yijirayilkarrajiwarnti. Walimpawarlany manya kanya nganpayirlu kurlirra Yijirayilkarti kulipurru yiningu Nayimantu. Pungani palunyanu. Kanarlanywarnti palunya pungani pirlawurra, kanarlanywarnti palunya wanjirni kangani. Wali kangani palunya warrkamkujirnupurru nyantuwarntikurakarti ngurrakarti kayili. Manga layi Yijirayiljangka parlanyanu warrkammayinkujirni purlkakurarlu marnintu Nayimankurarlu kartungu. Wali nyanartijangka nganpayi nyanarti purlka Nayiman mimijartijarrinya. Yarr pa mimi nyanarti putajilinyparni. Wali mangangu nyanartirlu Yijirayiljangkarlu parla yawiyijarrinya. Ngarpuwu parla ngurrpa ngunangani Nayiman. Marni parla marninku Nayimankurawu kartuwu, yangka manyanta warrkammarnani, “Puju pa yanku kurlirrara Yijirayilkarti, nganpayi nyanayirla kirrarnana puraput Ngarpukura. Kunyungurla pa nyanartirlu wulyukujiwu mimijangka nganpayirlu puraputtu.” Jularnila parla Nayimanku kartunyankurarlu wangki mangakura nyanartikura, “Jularni paji mangangu nyanartirlu nganpayi nyanayirla wulyukujirnujuwal kirrarnana. Kunyungurla mananta nyanartikarti yanku.” Nyanartijangka Nayiman manyanta yani purlkakarti kingkarti Jiriyakarrajikarti japirlyungupurru. Purlka manyanangu ngunangani Jiriyakarrajiwarntiwu. Jularni parla Nayimantu mangakura wangki nyanarti. Wali kingju Jiriyakarrajirlu manyanta jangkumani, “Wali yanku man Yijirayilkarti kingwarlanykarti. Mirlimirli marnangu lanku, kangkula manurla kingwarlanyku, yarala mangu ngunawu.” Kujartikarra parla lani mirlimirlirla, “Minyarti nganpayi marnangurla yiparnana ngajukura warrkammayin Nayiman nyuntukarti. Wulyukujiwu pajin mimijangka.” Nyanartijangka jakarnila kurlirrara. Kangani manya pamarrwarnti paja yijipurru, yarnta kuluwujwarnti paja wulyuwarnti. Yungku parla nganpayi nyanarti wulyukujirnujangka yiji. ");
INSERT INTO wmt_vpl VALUES ("K25_7","013_5_7","2KI","5","7","11","Nyanartijangka pirriyanila manyanta nyanarti nganpayi Nayiman kingkarti Yijirayilkarrajikarti, yinyala parla mirlimirli Nayimantu. Marnila parla kingju, “Nganapurru manta mirnu yiparni ngajukarti. Kayan ngarnanta wulyukuji ngajungu. Ngajirta marna ngaju Ngarpu, ngajirta marna wulyukujirnujuwal ngaju.” Jularni palurla kanarlanywarntirlu nganpayiwu Layijawu puraputku, “Nganpayi layi kayilungjangka pirriyani mimijarti wulyukujirnupurru minyartikarti.” Nyanartijangka parla yiparni kingku. Marni parla, “Yipanyjaji mirnu. Ngaju marna Ngarpukura japirlyungujuwal.” Nyanartijangka yiparnila manyanta. Wali nyantukura ngurti Nayimankura parla yawartarlu ruwarrakanya. Marnpala manyanta jatparakujirni mayarurla puraputkurarla. Nyantu pa kaninykaniny kirrarnani nganpayi yangkarti puraput. Ngajirta pa palkakarti pirriyantarla, yiparnila parla warrkammayin wangkijarti. Marni parla warrkammayintu Nayimanku, “Nyanartirlu puraputtu mangu jularni, ‘Yanku man martuwarrakarti yinikarti Jutunkarti. Nyanayirla man nyumukmalku ngapanga tikirrparni tikirrparni 7mirri kitangarni mangurla Ngarpungu mimi nyanarti luwumanku layimirrirni.’” Nyanartijangka kulijarrinyala nganpayi nyanarti Nayiman. Wurnarnila nguyi jakarni. Marni manyanangu, “Kula paji warrajarni pirriyantarla, minyakujala paji jutngurni yiparni. Kula pajirla Ngarpu nyantukura japirlyungkarla palkangarni pirriyanungurla marnpangurni, yarnta panymanurla pajirla japirlyungkarla, nyanartila paja wulyukujirla partalurni wulyuwurra.” ");
INSERT INTO wmt_vpl VALUES ("K25_12","013_5_12","2KI","5","12","15","Yarntarni manyanangu marni Nayimantu, “Ngajukurarla yalayirla pila martuwarrajarra kurriny nguniny wulyujarra, nyanayirla marna nyumukmanyjarla jarntunga, wulyukujirlala paja.” Nyantukurawarntirlu palurla jularni warrkammayinwarntirlu Nayimankurawarntirlu, “Nganajangka manurla wakirrmarni. Nyantungu mangu jularni marnpa nyanarti martuwarra nyumukarnupurru. Wayila man mapunikanurla nyumukmalku wulyuwurra nyanayirla martuwarrarla.” Wali mapunikanila manyanangurla, yanila martuwarrakarti, nyumukmarnanila nyanayirla ngapanga tikirrparni tikirrparni 7mirri. Nyanartijangka wulyujarrinyala. Nukarnini manyanta jutantinya nyanarti mimi, wulyula ngujangurra. Wali tikiyanila manyanta puraputkarti. Marni parla, “Mapunikarralany marna Ngarpu Yijirayilkura. Nyantu pa kayan purlka. Kanarlanywarnti palu yarpalmarta.” Wali tikiyanila kayili. ");
INSERT INTO wmt_vpl VALUES ("K217_5","013_17_5","2KI","17","5","7a","Nyanartijangka walimpawarlany kakarrangu palu pirriyani kulipariwarnti Yajiriyajangka. Wali Yijirayiljangkawarnti palunyanangu rayin karrinyani kakarrangjangkawarntiwu. Rukukanila palunyanu mayarurla kaninykaniny kulipariwarntirlamarra rayintu. Pungka ngalunya. Mayaru nyanarti yini Jimariya yangka palu rukjarti kirrarnani. Wali jarranyanganila palunya kulipariwarntirlu, nyangurlakarra palu turtanganku kaninykaninyngurni mayarungurni. Nyanartijangka palunya jarranyangani yitalaljarra kurriny. Wali miyi manyanangu kitangarni pujujarrinya kaninykaninyjangkawarntiwu, yarrpala palu kirrarnani marranyanjarti. Maljarrjarrinya palu miyingajirtajangka. Nyanartijangka palunya warntarnurla yapkanya kakarra, warrkammayinkujirnila palunya. ");
INSERT INTO wmt_vpl VALUES ("K217_24","013_17_24","2KI","17","24","28","Yarnta palunya kanya kakarrangjangkawarnti purtayan Jimariyakarti karlarrara. Wali nyanayirlarnila palu kayanta kirrarnani mayarurla yininga Jimariyarla. Kakarrangjangkawarntirlu palu Ngarpu ngajirta mapunikarrarla, ngurrpa palurla ngunangani. Nyantuwarntirlu palurlanyanu kangani pamarrjaa mana Ngarpujilinyparni. Wali juntumani palu ngurra nyanayirla Jimariyarla kakarrangjangkawarntirlu. Nyanartijangka nira palu pirriyanani purlka miyawujilinyparni piyirn ngarnujuwal. Piyirnpala palunya pajanurla ngarnani. Wali kakarrangjangkawarntirlu palurlanyanu pinapinakarrinyani. Marni palurlanyanu, “Kunyungurla parlipangu Ngarpungu kulijarrinya minyartikarrajirlu. Kunyungurla parlipangurla Ngarpungu yiparni minyartiwarnti miyawujilinywarnti. Ngalimpa parlipanya ngalku pirlawurra.” Wali parlipinyala palu nganpayi Yijirayiljangka yangka parla Ngarpu pinarri ngunangani. Wali pinarriyinyala manya kakarrangjangkawarnti Yajiriyajangkawarnti Ngarpu Yijirayiljangkawarntikura. ");
INSERT INTO wmt_vpl VALUES ("K217_41","013_17_41","2KI","17","41","41","Nyanartijangka palurla walimpa Ngarpu pinarrijarrinyala. Pamarr palurlanyanu warrarni jutungurni martarnanijaa ngartakpanani. Ngajirta palu wanyjarrarla, marulu manyanangu. Kurrinykurriny palurla ngunangani pamarrkujaa Ngarpuwu. Wali yapajirnanyunguwarnti palu nira kujartikarra ngunangani Jimariyakarrajiwarnti. Kurrinykurriny palurla mapunikanani pamarrkujaa Ngarpuwu. ");
INSERT INTO wmt_vpl VALUES ("K225_1","013_25_1","2KI","25","1","13","Nyanartijangka kulipariwarntila manya yiparni Jutakarti kakarrangjangkarlu Nipikinijarlu. Takurryanila palu mayarurla Jurujulumja. Parrparrpinya palu mayaru nyanarti, yarnta palu turlkujirni warlungu. Ngurrawarnti palunya turlkujirni purlkawarntikura mayarujaa kingkura mayarujaa jujupurru Ngarpukura mayaru, yini Timpul mapirrirni. Yarnta palunya tarratarrapinya pamarrwarnti ngartakpanujangkawarnti. Yarnta palunya kanya piyirnwarntijaa manawarnti mapirrirni Timpuljangkawarnti. Ngurru palu warntarnkanya kakarra. ");
INSERT INTO wmt_vpl VALUES ("K225_21","013_25_21","2KI","25","21","21","Kujartikarra palunya pakulkangani nyantuwarntikurajangka ngurrarajangka Jutajangkajaa Jurujulumjangka. Kakarrala palunya pakulkanya nyantuwarntikurangurni ngurrarangurni kanarlanykarti ngurra yini Papulun. Kanarlanyja ngurra palunya martarnani Papulunta. ");
INSERT INTO wmt_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","6","Puju nganawurti piyirn parla ngajirta Ngarpuwu jingkirti warralpungka, yarnta ngajirta manya mapunikarra lirrkarnpungujuwal ngarlajawurlu. Nyanarti piyirn pa wirriya nguniny Ngarpukurarlal. Yarnta pa Ngarpukura wangki tapungmanany. Wangkingu Ngarpukurarlu pa ngarrurtakujilany. Ngarpukura wangki pa pinapinakarrilany nira jutungu. Yangka kumantajaa jininyara pukanyja pa pinapinakarrilany. Nyanarti piyirn, nyanarti marnin pa manajilinyparni yangka ngapanga karrilany martuwarrarla rirringkirla. Ngapangu kalypajarrilany, kirtily martalany, wulyuwulyurni martalany. Kayan ngarta lalkajarri warnjaljaa kayan ngarta miyingajirtajarri. Yitilalwarlany yitilalwarlany manya miyi martalany. Manangu parlipanya pinayungany. Yangka piyirn manajilinypala nguniny, wulyungal yanany nira. Martalany pa wulyu miyijilinyparni. Kujarti pa nguniny Ngarpukura piyirnjaa marnin. ");
INSERT INTO wmt_vpl VALUES ("IS41_1","024_41_1","ISA","41","1","9","Wali yakurrwarnti piyirnwarnti palu kanarlanyparni nguniny Ngarpungajirtajartiwarnti. Nyanartiwarnti palu yukajiliny lalkajiliny. Walypangu manya karankanganyjaa tupluwalany manya ngumu. Kujarti palu nguniny piyirn yakurrwarnti. Yangka walimpa parlipanya Ngarpungu kurajpungku, yakurrwarntijaa wulyuwarnti ngurrujarrakujiwula parlipanya. Kayan nganyanangu Ngarpungu wulyumanyja nyanartiwu piyirnku yakurrku. Kayan ngalunyanangurla yakurrwarnti Ngarpungajirtajartiwarnti nguna kirninyja Ngarpukurawarntirla kurajpungujangkawarntirla. Ngarpu manyanangu pinarri nguniny nyantukurajartiwarnti nyapartukarra palu nguniny ngampurrikarralany manya Ngarpungu. Nyanartiwarnti kanarlanywarnti Ngarpungajirtajartiwarnti kayan ngalu wanji nguna kujawurlurra. Wirlmalku palu. ");
INSERT INTO wmt_vpl VALUES ("IS41_10","024_41_10","ISA","41","10","10","Ngarpungu parlipangu jularni kujarti, “Ngajirta nganurlanyanu karrartajarri, minyarti marnangurla nguniny mapirrirni ngaju. Ngajirta nganunyanu yartajkarramanta yawiyirlu, minyarti marnangurla nguniny marnparni ngaju Kut. Ngajungu marnanta tanyjikujiwu, minyarti marnangurla nguniny mapirrirni. Ngajirta man nyuntumipa kayan, kurraparla pajanurla nguniny nyuntu ngajunga.” ");
INSERT INTO wmt_vpl VALUES ("JH1_1","033_1_1","JON","1","1","17","Ngarpungu parla marni Jawunawu, “Yanta kakarra mayarukarti Ninipakarti. Purlkajinyangu pa nyanarti mayaru. Julanyanangu piyirnwarntiwu nyanartikarrajiwarntiwu minyarti wangki ngajukurajangka. Yakurrjinyangu palu nguniny pujurni. Pinarri marnanyanangu, nyanartijangka marnanyanangu kulijarrinya yangkala marna mayaru pungku, piyirnwarnti mapirri marnanya pungku.” Wali Jawuna lurrpantinykarrany karla. Ranyjiwantinya parlanyanta Ngarpuwu. Pirriyani mayarurla yininga Japanga. Nyanartijangka parlipinya ngurti ngapakarraji pawut karrinyujangka marnpa. Nyanarti pawut parla wurnawu jamurnkujarrinya karlapurru. Nyanartijangka parayankarrany manyanangurla piyirnwarntirla. Pamarr manya yinya wurnapurru. Takurryanila pawutta kaninykaniny. Nyanartijangka wurnakujirni palu pawut warrkammayinwarntirlu pawutkarrajiwarntirlu. Karla palu marri yantarla Payinkarti. Wali Jawuna pa manyanjarrinya wurnanga wurnanga. Ngurrurnkarra pa yukarnani kaninykaniny manyan. Wali jamurn palu kaparnjarrinya, walypa manyanangu yiparni Ngarpungu walypa purlkajinyangu. Yarr pa pawut wirrinyjalkarra pinya. Nyanartijangkarlu mana palu tarratarrapinya. Tarrapinya palunya manawarnti purlkawarnti yarpalwurra. Nyanartiwarntirlu warrkammayinwarntirlu palurla ngarntikanya nyantuwarntikura mana marlamanupurru Ngarpujilinyparni. Nyanartijangka piyirn purlka takurryani kaninykaniny. Pawutku parla maja nyanarti. Jawuna pa nyanya manyanjangka, parnkimani. Mani parla, “Parnkijarri. Nyapartujarrinyana man. Turtapungka Jawuna. Japirryungku manurla nyuntukura Ngarpu kankarral, mulawurtu ngarlipangu yawiyijarri. Lamakuji ngartapinya walypajaa ngapa, ngapangu ngarlipanya nganyja.” Nyanartijangka warrkammayinwarntirlu palurlanyanu marni, “Ngantungurlipanya kujikani. Yiniwarnti nyakurlipanyanu.” Nyanyala palunyanu yiniwarnti, yinijarti yinijarti wali. Layi palu kurajpinya yini Jawuna. Marni palurla, “Nyuntungu marnanpanya kujikani Jawuna. Nyuntungu marnanpanya kujikani. Minyartila pinya yiparni walypajaa ngapa Ngarpungu kujikanujangka. Nyapartujarrinyana man minyayirla pawutta. Wanyjurlajangka man pirriyani, julanyanu taki.” Wali jangkumani manyanangurla Jawunarlu, “Ngajirta, ngaju marna Juwuj. Ngarpu marna japirlyungany, nyantu pa kayan kankarni nguniny. Jarlu pinya ngartakpani mulnyijaa ngapa. Yap yani marna Ngarpungurni marri. Nyanartila marnanyirrangurla parayanukarranya.” Wali nyanartijangka wangkijangka rayinjarrinyala palu warrkammayinwarnti. Marni palurla, “Ngajirta ngan kujartijarri. Mapunikarrarla manyanta Ngarpunga. Nganajangkarlu manyanta panypinya.” Nyanartijangka kulijarrinya pa walypa. Jamurn pa tirlpurrjungantarla nyanarti pawut. Wali marni palurla warrkammayinwarntirlu Jawunawu, “Nyapartukujiwu parlipa walypajaa ngapa lamakujirnupurru.” Wali Jawunarlu manyanangurla jangkumani, “Tarrapungkajalu ngapanga kaparn, nyanartila pila lamajarriwu walypajaa ngapa. Ngajungu marnanya kujikani.” Wali jarrmarni palurlanyanu warrkammayinwarntirlu. “Ngajirta, warra ngunawu yawiyi. Yarr parlipa kangku, ngajirta ngarlipa tarrapungka. Tikiyanku parlipa rirringkikarti.” Nyanartijangka jarti palu ngurti jawukangani rirringkikarti. Karlalani palu ngapa mayajinyangu manawarntijawurlu. Kaparnparni pa walypangu kurinyjikarra kangani pawut nyanarti. Jarti palu wurnakujirni. Nyanartijangka japirlyinyala palu Ngarpu kankarral. Marni palurla, “Ngarpu, nganpayi minyarti marnalu tarrapungku. Lamajarriwula pila walypajaa ngapa. Nyanartijangka ngajirta ngarnanpanya pungka purntungu. Minyarti nyuntukura ngapajaa walypa yangka man yiparni.” Wali warntarni palu nganpayi Jawuna, tarrapinyala palu jupuk ngapanga kaparn muntanga. Wali nyanartikarra partalurnila pila lamajarrinya walypajaa ngapa. Rayinjarrinyala palu warrkammayinwarnti. Nyanya palu walypajaa ngapa pila lamajarrinya. Mapunikani palurla nyanartikarra Ngarpuwu. Nyanartijangka kuyila palurla kamparni warlunga. Minyjurrminyjurr parla kankarral yani kamparnujangka. Parntimanila Ngarpungu. Marnila palurla, “Nyuntuwu marnangulu mapunikarralany Ngarpu.” Nyanartijangka takingurni parla Jawunawu yiparni kapi purlka yawiyijarrinyurla Ngarpungu. Parlipinya kapingu, nyurnungkujirnila. Muntanga pa martarnani kaninykaniny wanji. Ngajirta pirlajarrirla, yararni pa wanji martarnani muntanga. ");
INSERT INTO wmt_vpl VALUES ("JH2_1","033_2_1","JON","2","1","10","Wali kapingurni manyanta kaninykaninyngurni ngarntimanani Jawunarlu Ngarpunga. “Ngarpu, japirryungana marnanta. Nyuntungujal pajan nyangany. Kujikani marnanyanu ngajungu, nyanartijangka marna ngunangana ngapanga kaninyjinyangu. Jarti marna kalayilanana marlamanupurru. Nyuntu marnanta japirryungana kankarral. Wali pinakarrinya pajan. Kaninyjinyangu marna ngunangana pirlawarntikurarla. Japirryungana marnanta, nyuntungula pajan pinakarrinyana mapunparni. Yarnta pajan nyuntungu tarrapinya, ngapakarti kaninyparral. Yarnta ngapa pajarla pirriyani. Kuparlaparla pajarla yani kankarnumarrangu. Kulajan walirni ngunyipinya, minya kujalajan warrarni pinakarrinyani. Kayan ngarnangu nyaka yarntarni mayaru nyuntukura yangka marna pirlajarrirla. Ngapangu paja ngarni, nyanartila paja ngayila rukukani. Jurlu paja karrpirni kurrjangu.” Yarntarni Jawunarlu parla marni Ngarpuwu, “Ngapanga marna nguja kaninyjinyangu yangka pirlawarntikurarla ngurranga rukjawurla rukjartijinyangu. Kayan ngarta nganawurti tikirrturtapungkarla. Nyanayirla marna nguja. Ngarpu, nyuntungu pajan tikirrkujirni kaninyjangka. Nyuntungu pajan wanjikujirni. Purlka pajin nyuntu. Kularna walirni pirlajarrinya, minya kujalajan tikirrkujirni kaninyjangka nyuntungu. Japirlyungani marnanta, pinakarrinyala pajan nyuntungu. Jangkumani pajanurla nyuntukurangurni mayarungurni. Piyirnwarntirlu kanarlanywarntirlu palunya japirlyungany manawarnti marlamanupurru. Purlkakujilany palunya manawarnti Ngarpujilinyparni. Minyartiwarntirlu mantalu wanyjani nyuntu. Jarlu mantalu ngarntikangani nyuntu marlamanupurru. Jalarra palurlanyanu ngarntikangana manawarnti Ngarpujiliny nyantuwarntikura. Ngarpu, wirriya marnangu nguniny. Nyuntungu pajan kaninyjangka warntarni ngapangajangka. Marlamani pajan. Wanjikujirni pajan nyuntungu kaninyjangka.” Wali yarntarni parla marni Ngarpuwu, “Kuyi marnanta yungku, kampawu marnangu. Parntimankula man kujirirriny. Ngapajangka kaninyjangka pajan marlamani. Wanjikujirni pajan nyuntungu. Nyanartila marnangu kampawu kuyi warlunga. Parntimankula man kujirirriny kankarnumarrangurlu. Jarlu marnangu marni wangki mapunikanupurrujaa warrkammarnupurru. Jalarra marnangu nyuntuwu warrkammalku. Ngajirta yangkartijiliny jarlu, yangka marna lurrpantinya. Jalarra marnangu nyuntuwu warrkammalku mapunjinyangu. Mapunikarralany marnangurla nyuntunga. Ngarpu, nyuntu man kayan marlamanujuwaljaa wanjikujirnujuwal.” Wali Jawuna pa nyanayirla ngunangani kapinga ngurrawarntirla murrkurnta. Nyanartijangka kapiwu parla Ngarpungu marni, “Kangka nyanarti nganpayi rirringkirlurra. Kurlpakarrku man pulparra.” Wali kapingu parla mapunikani, kanyala, kurlpakkanila rirringkirla pulparra. ");
INSERT INTO wmt_vpl VALUES ("JH3_1","033_3_1","JON","3","1","10","Wali nyanartijangkarlu yarntarni parla Jawunawu marni kirlirni wangki yangka parla jarlu marni Ngarpungu. Marni parla, “Jawuna, yanta yangkartirlurra mayarurlurra purlakangkurra. Julawu manyanangu wangki ngajukurajangka yangka marnangu jarlu marni.” Wali mapunikanila Ngarpu jamurn kurlpakkani kapingu. Jirrkirlparnila turtangkarranya kakarra wurnarni. Ngurra manyanangu nyanarti Ninipa purlka mayaru ngurruwarlanyparni jirrkirlyanupurrungajirta, kakurrkakurrjinyangu. Ngurrawarnti murrkurn palu yukalany kaparnwarlanyparni yangka piyirn jina yanany walimparni pirriyanupurru. Wali pirriyani Jawuna mayarurla. Tirrinyyanani mayarujarrarla kaparn, nyanartijangka karuwarrakaruwarra lamajarrinya mayarurla kaparn. Jularnanila manyanangu wangki Ngarpukura. Marni manyanangu, “Minyarti mayaru pa wajapungku Ngarpungu. Ngajirta yinki yarr jalarrarni. Ngurrawarnti paja, 40 manta ngunawu, nyanartijangka Ngarpungu mannya wajapungku.” Nyanartijangka mapunikanila palurla pujungurni piyirntu. Kuyijaa miyi palu wanyjani pujungurni, ngajirta kayantuwurti nganyjarla. Jaminy palurla nguja pujurni. Yarnta ral nanikutkurajangka palu ngartakpani wirrimkangupurru. Wirrimkanganila palunyanu pirtilypayikjiliny. Kurnakwantinya palu yakurrjangka, nyanartijangka palunyanu wirrimkangani kujarti. Yawiyijarrinya palurla Ngarpuwu. Nyaku manya Ngarpungu yawiyijarrinyujangka. Wali Jawunakura wangki palurla kanya piyirnwarntirlu purlkawu nyantuwarntikurawu. Kirrarnani mayarurla nyantukurarla. Jularni palurla. Jamurn pinakarrinya jularnujangka, kurtamanila parlanyanu nyantukura kuwut yangkala manyanu yutukani nanikutkura ral ngartakpanujangka. Nyanartijangka jurnpullala kirrarnani. Nyanartijangka tikirr yiparni manyanangu wangki purlkangu majangu wanyjanupurru. “Kuyijaa miyi ngapa mapirri ngajirta nganta nganyja piyirntujaa marnintujaa yapangu mapirri. Pujungurni manta wanyjarrku. Yarnta purlumanwarntirlujaa kukunjawarntirlu mapirri ngajirta ngartalu nganyja miyi yuka.” Kujartikarra palu nyanartikarrajiwarnti ngunangani. Yurru manyanangu nyantuwarntikura Ninipakarrajiwarntiwu. Yawiyijarrinya palurla Ngarpuwu ngangangunangujangkarlu. Wangkiwarlany manyanangu yiparni purlkangu, “Karrkintapirri palu wirrimkangku yangkarti kukunjarlujaa purlumanurlu piyirnwartirlu mapirrirni. Pujungurni parlipa wirrimkangku mana yangkarti karrkintapirri. Nyanartijangka japirlyungku parlipa Ngarpu kankarral yarnta yakurrjangka parlipa kurnakwantiwu wulyungkurra. Nyanartijangka kunyungurla parlipangu Ngarpu kurnakwantiwu munta yakurrjangkawu kurnakwantinyujangkawarntiwu. Kayan ngarlipangu kulijarri, wanji parlipa ngunawu. Ngarpungu parlipanya nyaku kurnakwantinyujangkawarnti. Nyanartila parlipanya wanyjarrku Ngarpungu mayarujaa piyirnwarnti mapirri yangka parliparla kurnakwantinya nyantuwu.” Nyanarti wangki manyanangu yiparni purlkangu. ");
INSERT INTO wmt_vpl VALUES ("JH4_1","033_4_1","JON","4","1","11","Nyanartijangka Jawuna ngajirta pa wirriya ngunarla. Kulijarrinya parla Ngarpuwu. Ngajirta manya pungkarla piyirnwarntijaa mayaru mapirri. Nyanartijangka Ngarpuwu parla kulijarrinya. Marnila parla Jawunarlu, “Ngarpu, yangka marna warrarni kirrarnani ngajukurarla ngurranga kurlirra, kujarti marna pinapinakarrinyani. Kayan nganunya pungkarla nyuntungu piyirnwarnti Ninipakarrajiwarntijaa nyantuwarntikura mayaru. Wali mapunparni ngajirta manunya pungkarla. Jirrkirlparni marna pinapinakarrinyani. Nyanartijangkala marna laparnkarrakanya karla. Wali nyuntu man Ngarpu wulyu. Ngajirta man partalurni kulijarrinyujuwal. Yarnta marna pinapinakarrinyani, nyuntu man piyirn tapungmanujuwal, yarnta yawiyijarrinyujuwal. Kayan nganurla partalurni kulijarri piyirnku. Jarranyangujuwal man nyuntu Ngarpu. Kayan nganunya partalurni pungka. Wulyu man. Nira man kujarti nguniny. Nyuntu man tapungmanujuwaljaa marlamanujuwal yakurrjangka. Nyuntu man partalurni munta kurnakwantinyujuwal. Ngajirta man pungujuwal. Nira man warrarni jurumanujuwal. Kujartikarra man nira nguniny. Yarrwurti marna ngaju pirlajarriwu. Wulyumalany marnarla pirlajarrinyupurrujaa ngajirta ngarna wanji nguna.” Nyanartijangka Ngarpungu parla marni Jawunawu, “Nganajangka man kulijarrinya Jawuna. Ngajirta ngan kujartijarri, wulyu man ngunawu.” Wali turtangkarranya mayarungurni marri kakarra. Nyanartijangka yutantinya jintanga, kirrarnani. Nyanartijangka ngartakpani parlanyanu ngalu kirrarnupurru. Nyanartijangka kirrarnanila ngalunga, pinapinakarrinyani kirrarnungurni. Ngarpungu nyangurla pungku nyanarti mayaru Ninipa. Nyanartijangka Ngarpungu parla tarrapinya kiyi. Nyanartila turtapinya mana. Ngalu parla turtapinya. Kirrarnani nyanayirla ngalunga nganpayi Jawuna. Wulyumalany parla Jawunarlu manawu kirrarnupurru ngalunga. Nyanartijangka kumanta jamurn rarrpajarrinya kakarra, Ngarpungu parla yiparni pirniny. Manala parla lakarrngarni nyanawurlu pirninyju. Wali manala parla lalkajarrinya. Nyanartijangka jamurn purangu turtapinya walypala parla yiparni Ngarpungu parrparrjinyangu kakarrangu. Walypangu nganpayi wiliwililuwarni parrparrwurra, yarnta purangurlu lani mirrmaruwurra. Jamurn wantirla Jawuna. Nyanartijangka nyantungula manyanu pirlalakani. Yarntarni marni, “Kayankurrarni marna pirlajarriwu.” Yarntarni Ngarpungu parla marni, “Nganajangka pajin kulijarrinya manangurni.” Jangkumani manyanta, “Mapunparni marnangu kulijarrinya, kulijartirni marna pirlajarriwu.” Wali Ngarpungu parla marni, “Mana minyarti pukanyjaliny turtapinya nyanartijangka purlkajarrinya, kumantala lalkajarrinya. Minyarti mana ngajirta man nyuntungu purlkakujirla. Ngajirta man nyuntungu ngampurrikarrarla. Yarnta manurla yawiyi nguniny manawu minyartiwu.” Yarntarni Ngarpungu parla marni, “Ngajirta manyanangu yawiyijarrirla piyirnwarntiwu Ninipakarrajiwarntiwu. Yapawarnti palu nyanayirla nguniny pajajinyangu Niniparla warnjaljiliny yangka 120 jawujan. Kuyi mapirri palu nguniny paja yawarta purluman kukunja. Ngajirta manyanangu yawiyijarrirla nyanartiwarntiwu. Manawumiparni mankurla yawiyijarrilany.” Wali kujartikarra parla Ngarpungu marnani Jawunawu. Lirrkarnpungani. ");
INSERT INTO wmt_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","19","Walimpa Mayiri yapajartijarrinya. Pirlurrpaliny manyanta takurryani Ngarpukurajangka. Warrarni pila ngurrujarra ngunangani Mayirijarra Jawujap purntajangkajarra. Ngajirta manyanta Mayirirla yukarnantarla Jawujap. Walirni parla nyantukura kartu purntajangka Jawujapku. Kujarti manyanangu ngunangani Juwujwarntikura yurru. Puju kanarlanyju muntajartikujilany marnin piyirnwarlanyju, wali nyanarti, tampirni palunya wanyjanani ngumparnarlu. Kurntayikujirnani palunya marnin. Wali Jawujapju nyanya nyantukura purnta, marnin nyanarti jarlu parla muntajartijarrinya. Jawujapju muntangu nyantukurarlu pirtinyikani Mayiri nyantukura purnta. Yakurrmarni parla muntajartiwu Jawujapju. Nyantungu pa nira luwu Juwujwarntikura martarnani, walirni pa ngajirta Mayiri wanyjarrarla tampingu. Pinapinakarrinyani pa, “Wanyjarrku marna ranyjingu. Ngajirta tampingu. Kayan ngarna kurntayikuji marnin nyanarti.” ");
INSERT INTO wmt_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Wali nganpayi Jawujap pa yukarnani munta yakurr. Pinapinakarrinyani parlanyanu purntajangka marnin wanyjanupurru, yangkala parla pirriyani winkirr yinjil Ngarpukurajangka purlkakurajangka. Marni parla Jawujapku yinjillu, “Ngajirta. Warntawu mankurlanyanu nyuntukura nyanarti marnin. Kangku man. Ngajirta ngan rayin nyaka muntajarti. Nyanarti yapa muntanga martarnana Ngarpukura walaku Kutkura. Jarlu manyanta takurryani Pirlurr Ngarpukurajangka, yangkala muntajartijarrinya. Ngajirta manyanta nganpayirla yukanyjarla kanarlanyja.” ");
INSERT INTO wmt_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Yinjillu parla yarntarni marni, “Nyanarti yapa martalany muntanga kaninykaniny walaku parla Kutku. Puju manyanu tarlkujiwu, yini man julawu Jesus. Wali purlkala ngunawu, piyirn manya tikirrkujiwu yakurrjangka.” ");
INSERT INTO wmt_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Wali Jawujap parnkijarrinya manyanjangka. Mapunikani parla yinjilku. Yanungurla parlanyanu warntarni Mayiri purntajangka. ");
INSERT INTO wmt_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Wali pa warntarni Mayiri yangkala pila ngurrujarrarni ngunangani. Jurumanani pilarla yapawu palkangajarrinyupurru. Walimpa yapangu manyanu tarlkujirni. Yinila jularni Jesus Jawujapju. ");
INSERT INTO wmt_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","2","Yangka kaji manyanu tarlkujirni Jesusju, nyanartikarra pa ngunangani nganpayi Yarrit. Purlka manyanangu maja Juwujwarntikura. Nyanartijangkala palu kakarrangu yanani marringurni pinangurruwarnti piyirnwarnti. Pinarri palurla ngujangurra nyapartukarra wirl pirriyanku. Walimpawarlany palu nyanya wirl nyanarti turtapinya. Wali turtangkarranya palu kakarrangu, jartamanani palu wirl, jarrkangani manyanangu Jurujulumkarti. Japirlyungani palunya kujangkurrajarra piyirn, “Wayila pinarri ngantarla murlawu purlkawu yapawu, wanyjurla marnalu parlipungku yapa minyarti. Juwujwarntikurajangka manyanangu maja. Wirl nyantukura marnalu nginyjirrikani kakarrangurlu, yangkala marnalu pirriyani minyayirla nyangupurrujaa kajalkajalkujirnupurru.” ");
INSERT INTO wmt_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Tampi palunyanta marnani wangki, yangkala manya pinakarrinyani purlkangu Yarrittu. Wali nyanartijangka malykunyanya pa nyanarti yapa Yarrittu, nyantu manyanangu ngunarla purlka nganpayi Yarrit. Munta yakurrjarrinya, kurnakwantinya nganpayi Yarrit wangkijangkarla. Kanarlanywarnti mapirri palu piyirnwarnti munta yakurrjarrinya, kurnakwantinya palu nyantukurawarnti Jurujulumkarrajiwarnti. ");
INSERT INTO wmt_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Wali nganpayirlu Yarrittu manya marurrpinya kurayipwarntijaa piyirnwarnti purlkawarnti yiniwarnti puriswarnti. Japirlyungani manya, “Wanyjurla manyanu tarlkujiwu yapangu yiningu Kurayijju.” ");
INSERT INTO wmt_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Marni palurla Yarritku nyantuwarntirlu, “Kurlila manyanu tarlkujiwu ngurranga Pajilimja Jutiyarla. Kujarti marnalu nyangany kurrumparla Ngarpukurarla. Wali jarluwarlany Ngarpungu parla yinya layi nganpayi wangki yapapurru tarlkujirnupurru, lanila pa nganpayirlu nyanawurlu wangki kurrumparla yungujangka. Jularnani palu nganpayi nyanarti puraput.” ");
INSERT INTO wmt_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Wali piyirntu purlkangu Yarrittula manyanangu yiparni wangki ranyji purpanupurru piyirnwarntiwu nyanartiwarntiwu pinangurruwarntiwu kakarrangujangkawarntiwu. Pirriyanila palunyanta Yarritta. Wirlku nyanartiwu manya japirlyinya Yarrittu. “Wayila. Nyangurla manta nyanya nyanarti wirl turtapungujangka.” Wali jangkumani palunyanta, “Ngajirta. Nyanya marnalu kakarrangurlu yitilaljarrarla kurrinyja.” ");
INSERT INTO wmt_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Marni manyanangu Yarrittu, “Wali Pajilimkarti yantalu. Warpiny muwupungkalurla yapawu. Parlipungku manta, tikirr pajinta kangku wangki ngajuwu. Nyaku marna ngajunguwurti. Kajalkajalkujiwu marna yapa nyanarti.” ");
INSERT INTO wmt_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Nyanartijangka Jurujulumjangka palu turtangkarranya. Yani palu Pajilimkarti kurlirrara piyirnwarnti pinangurruwarnti. Yarntarni palu nyanya wirl, yangkarti palu jarlu nyanya kakarrangurlu. Wirl yanani kankarral kajalkajal, nyantuwarntirlu palu wartangurni jartamanani wirl nyanarti. Jarlungurru wirl manyanta lamajarrinya mayarurla yapakurarla kankarnimarrangu. Yangka palu wirl nyanya, wirriyajarrinyala palu, ngarrurtajinyangula palu yanani nyangupurru yapa lamparn. ");
INSERT INTO wmt_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Pirriyani palunyanta, takurryanila palu mayarurla, nyanyala palupinya ngamarlangu. Yapa parlanyanu martarnani ngamajirlu. Nyanartijangka palunyanta parntawantinya yapanga, kajalkajalkujirnupurru yapa nyanarti. Kujarti palu nyanartikarrajirlu piyirnwarntirlu kajalkajalkujirnani piyirn purlka piyirnwarntirlujaa marninwarntirlu pujungurni. Parntawantinyani palunyanangurla purlkawarntirla. Yangkala palunyanta yapanga parntawantinya kujarti. Wali nyanartijangka palunya manawarnti warntarni yijipurruwarnti yungupurruwarnti nyantuwarntikurajangka ngurti. Yijiwarnti nyanartiwarnti palurla nganapartu nganapartu yinya. Layi parlipa julalany pamarr wulyu marulu yini kuwul. Yijijarrawarlany pila kurrinywarlany mirrijinjilinyjarra wulyu parntimanupurru yinijarra purakinjanjaa miya. Wali yinyala palurla yijiwarnti murta. Wulyuwulyu palurla kanya yijiwarnti yapawu Jesusku. ");
INSERT INTO wmt_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Pakul palu yani, ngurrala palu yukarnani pinangurruwarnti. Jarrmarni manyanangu Ngarpungu winkirra, “Ngajirta ngantarla yanta Yarritkarti. Wurna tikiyantalu rantanga nyurrawarntikurakarti ngurrakarti.” Wali turtapinya palu, rantanga palu tikiyani kujartirni. Ngajirta palurla yantarla Yarritku, wurnala palu tikiyani. ");
INSERT INTO wmt_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nyanartijangkala wartangurni pila ngunangani jampirlangu Jawujapjarra Mayiri. Yinjillu purlkakurarlu parla marni pukanyja winkirr Jawujapku. “Yanku man wurna jalarrarni. Kangku manpinya ngamarlangu karla Yijipkarti. Nyanayirla manpila martawu. Walimpa marnanypilangu malku tikirrkangupurru. Muwupungku parla Yarrittu wartangurni pungupurru. Nyuntungu man kangku jalarrarni Jesus lamparn karlarrara Yarritkarrarla. Yarrittu ngarta pungka lamparn Jesus.” ");
INSERT INTO wmt_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Nyanartijangka palu pukanyja jakarni karla Yijipkarti. Jawujapju pinya kanya ngamarlangu. ");
INSERT INTO wmt_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","16","Jurumanani parla Yarrittu pinangurruwarntikurawu wangkiwu tikirrkangupurru Jesus. Pungkarla pa yapa nyantungu. Wali kajiyinya palurla Yarrit pinangurruwarntirlu. Yarrit parla jarti jurumanungurla wirrilyijarrinya. Wali pinapinakarrinyani wangki yangkartirni jarlu palurla marni pinangurruwarntirlu. Wirl yangkarti palurla jularni. Nyantungu pa nyanarti wangki jutungu pinapinakarrinyani Yarrittu. “Kunyungurla yangkarti parri purlkajarrinya pakatkarrala yanany kurrinyja wurrkallajangka.” Nyanartijangka pawumarnila manyanangu nyantukurawarntiwu kulipariwarntiwu piyirnwarntiwu, “Yantalu. Pungkalunya lamparnlamparn parriparri yangka pakatkarra yanany kurrinyja wurrkallajangka ngurranga nyanayirla Pajilimja kujangkurrajarra. Ngajirta ngantanyanangu yawiyijarri. Pungkalunya pujurni. Warpinypungkalunya pirlawurra.” Wali mapunparni palu turtangkanya nyanartiwarnti Yarritkurawarnti. Pinya palunya paja yapa parriparri lamparnlamparn Pajilimkarrajiwarnti. Kula palu walirni pinya nyantu Jesus. Wali kirrarnani pila Jawujapjarra Mayiri karla Yijipja. Ngunangani pila, martarnani pila yapa nyanarti Jesus. Walimpa Yarrit pirlajarrinya. Wali jarluwarlany parla Ngarpungu purlkangu wangki marni nganpayiwu puraputku, lanila pa wangki Ngarpukura kurrumparla puraputtu. Ngarpungu parla marni, “Ngurrangurni Yijipngurni marna purpankanya walaku ngajukura.” Wali kurrumparla pa lani takingu. Kujartikarra pa Jesus pirriyani pikanga wangkinga jarluwarlanyjangka Yijipngurni. ");
INSERT INTO wmt_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Wali Yijipja parla pirriyani yinjil purlkakurajangka Jawujapku, kaji Yarritpaliny pirlajarrinya. Marnila parla winkirr Jawujapku, ");
INSERT INTO wmt_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Yanku manpila yangkartikarti ngurra nyurrawarntikurakarti Yijirayilkati. Tikirrkangku manpila yapa nyanarti. Martarnanku manpila nyanayirla. Jarlu pa Yarrit pirlajarrinya. Kayan ngarta pungka nyanarti yapa. Yara manpila wanji martarnanku nyanayirla.” ");
INSERT INTO wmt_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Wali tikiyani pila ngurrakarti nyantujarrakurakarti. Kanya pinya ngamarlangu, ngunanganila pila nyanayirla ngurranga Yijirayilla. ");
INSERT INTO wmt_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Jesusju manya pinarriyungani mapirrikarrajiwarnti, “Ngajirta nganta yangkartiwarntijilinyjarri yangka palunyanu kajalkajalkujilany yarr piyirntu yarringarnupurru. Yangka palu purayimalany piyirnwarntirlu nyangupurru mayarurla Ngarpukurarlajaa warntarrirla piyirnkurarla. Wali palurlanyanu ngurtnguniny, tumaj palunyanangurla kanarlanywarntirlu yarringalany. ");
INSERT INTO wmt_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Nyurrawarnti manta kanarlanyparni ngunawu. Yangka kayantuwurti parla Ngarpuwu purayimalku, wali kirralku man jintanga piyirnwarntingurni ranyji. Rukukarranyanu kaninykaniny mayarurla, nyanartikarra manta purayimarnanku Ngarpuwu nyuntukurawu kankarnijangkawu ranyjikarrajiwu. Ngarpungu parlipanya nyangany tirriny ranyjingurni. Ngungkupungkula manyanu wirriya, Ngarpungu manta ngurtkujiwu. ");
INSERT INTO wmt_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Yangkawurti manta purayimalany, ngajirta nganta wangkimipa pajakujirnanta kanarlanywarntijilinyju yangka palu wapalkarra purayimalany ngurrpangurrparlu lirrangumipa wangki juwal. Nyantuwarnti palu malany kula manya Ngarpungu pinakarrilanyparni yangka palu wangkimipa purlkajinyangu juwal purayimalany. ");
INSERT INTO wmt_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Wali ngajirta nganta kujartijarri nyantuwarntijiliny lirrangumipa purayimarnujuwal. Ngarpu manyirrangu pinarri. Jarlurni kajaluwarlany mannya nyangany nyantungu, nyapartukarra manta nguninyjaa nyapartukarra mantarla purayimalany. ");
INSERT INTO wmt_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Nyanartijangkala yangka mantarla purayimalku kujartikarra manta Ngarpu japirlyungku. Ngarpu nganampakura, kankarnumarrangu man nguniny. Nyuntu marnantalu yini julawu ngirrpiri nukarnirlu. ");
INSERT INTO wmt_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Japirlyungana marnantalu nyuntu maja ngunangupurru wapalkarrawu. Nukarnirlu marnangulu mapunikarrku yangka marnanpangu kurajpungany jirrkirl ngunangupurru nyuntukurarlal. Kayanparni marnantalu mapunikarrku nguwakarrajiwarntirlujaa yalkirikarrajiwarntirlu Ngarpukurawarntirlu. ");
INSERT INTO wmt_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Yungkarnanpanya miyijaa kuyi jalarrapurru ngarnupurru yangka marnanpanya jininyarawarlany jininyarawarlany yungany. ");
INSERT INTO wmt_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Wajapungurla rukanyjanpangurla yakurryakurr nganampakura, yangka marnalunyanangu nganampa ngaru kirtilyjarrilany kanarlanywarntiwu. ");
INSERT INTO wmt_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ngajirta ngarnanpanya kangka yakurrwarntirlal warntarrirlal. Marlamantarnanpanya warntarrirlaljangka pirlakuralaljangka yangkawurti ngarnalu tarrpantilany. ");
INSERT INTO wmt_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Yarntarni manya pinarriyungani Jesusju, “Puju mantanyanangu kanarlanywarntiwu ngaru kirtilyjarrilany, wali nyanarti, Ngarpungula kankarnumarrangurlu manyirrangurla yakurryakurr wajapungurla rukalku. ");
INSERT INTO wmt_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Yarnta puju ngajirta mantanyanangu kanarlanywarntiwu ngaru kirtilyjarri, wali nyanarti, ngajirta manyirrangurla yakurryakurr nyurrawarntirla wajapungurla rukanyja Ngarpungu kankarnimarrangurlu.” ");
INSERT INTO wmt_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","30","Purlumanurlu palu martarnani nyankangal, warrkammarnanila palu, yini parla yuwuk. Kangani palu yuwuk wulyu nyankangal jiralyjinyangu, wulyu palu warrkammarnani wirriyarlu. Yarnta puju palu jatkajatka kangani yuwuk japalmartamarta, tumaj pa mimikujirnujuwal. Yarntarni piyirnjaa marninjaa yapa palu wulyuwulyu niranira yanany Ngarpukurarlal, yangkala palu yumpalyjarrilany niranirajangka. Patkanyjilany manya yakurryakurru, yangkala jarti palurla Ngarpuwu muwupungany. Kujarti palu yanany piyirnjaa marninjaa yapa purlumantujiliny martalany yuwuk nyankangal. Yuwukju manya yumpalykujilanyjaa patkanyjilany. Wali Jesusju parlipangu malany, “Mirnu yantajalurla ngajukarti piyirnjaa marninjaa yapa pujurni yumpalyjartiwarntijaa patkanyjirnujangkawarnti. Kunyungurla manta yumpalyjarrinya warrkamjangka Ngarpukurajangka. Niranira manta yanany Ngarpukurakarti. Ngajungula marnannya wirriya yungku, rinymalkula manta. Ngajukura yuwuk pa wulyujinyangu jiralyjinyangu, ngajirta jatkajatka. Kayan nganta patkanyji ngajukurarlu yuwukju. Warntarnurla tarrjakkujilunyanu.” Yarntarni Jesusju marni, “Yungku marnanta wangki yuwukjilinyparni. Pinayungku marnanya ngajungu Ngarpuwu. Pinarrijarriwula mantarla Ngarpuwu. Ngaju marna wulyu. Ngajirta marnanyanu kajalkajalkuji. Puju pajin kangku wangki ngajukura yuwukjilinyparni, wali nyanarti, parlipungkula mankurlanyanu wirriya. Pirlurr man kirtilyjarriwu. Ngarpu man parlipungku. Wajapungku mangurla yakurr.” ");
INSERT INTO wmt_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Purayitirla palu Jesus yutukani najinga, wali kumantawarlanyja Jarritirla palurla yani puriswarntijaa Parajiwarnti Payilitku japirlyungupurru. ");
INSERT INTO wmt_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","64","Marni palurla Payilitku, “Limpawarnti manunya yipawu. Ngampurrikarrku palu Jesus najinga yukalany karrkin. Warntarnkarrakangka ngartalu wartangurni mapirrikarrajiwarntirlu nyantukurawarntirlu. Jarlu manyanangu Jesusju yirrijirlu marni wanjingurnikarra kujartikarra ngurrajarrarla kurrinyja yukarnuwu. Nyanartijangka kumantawarlanyja wanjikujiwu paja Ngarpungu. Pinapinakarrilany marnalu nyanarti wangki, yangkala marnantalu japirlyungana nyuntu murrkurnmirri ngampurrikanupurru Jesus. Puju mapirrikarrajiwarntirlu palu warntarnkarrakangka Jesus karrkin, kunyungurla ngalunyanangu jakuljakulkangka mapirrikarrajiwarntirlu yirrawarlanyku. Yirri ngalunyanangu jula Jesus wanjikujirnujangka. Kujarti pa yakurrjinyangu. Nyanayirlamarra manunya yipawu limpawarnti. Ngampurrikarrku palu marrkijinyangu, warntarnkarrakangka ngartalu karrkin najingajangka kanarlanywarntirlu.” ");
INSERT INTO wmt_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Payilittu manyanangurla jangkumani, “Kaj. Kangkalunya limpawarnti. Rukukarrku mantanyanta najinga mayajinyangu.” ");
INSERT INTO wmt_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Wali yanani palu najikarti. Purlka paljarr pamarr palunyanta rukukani kirlingirrirla. Nyanartijangka palunyanta pajkarrpirni juntu pamarra. Puju ngananguwurti pamarr rirripkangku nyanarti paljarr, wali nginyjirrikarrkula palu juntu junganyjangka. Kujartipurru palu yutukani juntu nyanarti. Wali tikiyanila palu nyanartiwarnti puriswarntijaa Parajiwarnti mayarukarti. Wanyjani palunya limpawarnti murrkurn najinga ngampurrikanupurru. ");
INSERT INTO wmt_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Wali jarluwarlany parla Kuttu marni nganpayiwu Yajayawu, lanila wangki nyanarti kurrumparla Yajayarlu, Ngarpungu parla yinya. Nganpayi nyanarti parla puraput ngunangani Ngarpuwu. Julalany parlipa nganpayi Ngarpukura puraput, yangka Ngarpungu parla wangki yungany piyirnwarntiwarlanyku jularnupurru. Kujarti pa kurrumparla lani Yajayarlu Ngarpukura wangki. Ngarpungu marni, “Pinakarrilu. Ngajungu marna julawu wangki Ngarpungu. Yipawu marna nganpayi ngajukura wangkijarti. Kajalurni marnangurla yipawu nyuntunga ngajukurarla walakurla pikakujirnupurru. Jakurrpungku mangu kajalurni warntarri. ");
INSERT INTO wmt_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Nganpayirlu nyanawurlu yiparnujangkarlu pa jularnanku pawukarrarlu pintirningurni. Jularnanku manyanangu, ‘Jakurrpungkalurla warntarri parla Ngarpuwu purlkawu. Jirrkirlkujilurla nyanarti warntarri.’” Kujarti parla jarlu marni Ngarpungu Yajayawu lanupurru. ");
INSERT INTO wmt_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Nyanartijangka wangkijangkarla pikakujirnujangkarla yangkarti nganpayi Junpala pirriyani. Nganpayi Jun parlipa julalany pulukkujirnujuwal. Wali pintirningurni manyanangu pawukarrarlu jularnani, “Kurnakwantilu Ngarpukurarlurra, pulukkujirnankula marnannya ngapanga kurnakwantinyujangkawarnti. Ngarpungu manyirrangurla wajapungku yakurr nyurrawarntikurajangka. Kayan nganyirrangurla yutukarra yakurryakurr nyanarti Ngarpungu. Wajapungku manyirrangurla.” ");
INSERT INTO wmt_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Wali nyanartijangka piyirnwarnti ngurrawarntijangka palu pirriyani pajajinyangu. Junkarti palunyanta yanani pinakarrinyupurru. Paja piyirn palu yanani mayarujangkawarnti Jurujulumjangkawarnti. Mayaruwarntiwarlanyjangka Jutiyakarrajiwarnti mapirrirni palu warryanani. Nyanartijangka pulukkujirnani manya ngapanga martuwarrarla yininga Jutunta. Nyantuwarntirlu piyirnwarntirlu palunyanu tampirni jularnani yakurr nyantuwarntikura. ");
INSERT INTO wmt_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Wali parlanyanu Juntu kangani karrkinta kuluwuj yangka raljangka parlanyanu ngartakpani kamulkurajangka. Nyantungumipa pa kujarti kangani, kanarlanywarntirlu palu kanarlanyparni kangani. Yarntarni pa ngantinga kangani manawarlany jarrjajangka pilkujiliny. Nyantukura miyi pa karlaka. Kuyi pa ngarnani jarrjurnwarntimipa. ");
INSERT INTO wmt_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Jularnani manyanangu Juntu. Marnanila manyanangu, “Wartangurni pajarla yanana nganpayi. Nyantu pa tanyjijinyangu mayapari, ngaju marna wartangurnijangkarni. Nyantu pa purlka kajalkajal, ngaju marna wartangurnijangkarni.” ");
INSERT INTO wmt_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Yarntarni manyanangu marnani Juntu, “Pulukkujilany marnanya nyurrawarnti ngapanga. Kanarlany wartangurni pirriyanku, nyantungu manya pulukkujiwu Pirlurra Ngarpukurajangkarla ngapajilinyja.” ");
INSERT INTO wmt_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Nyanartijangka Jesus yani Najuritjangka Kalalijangka. Pirriyani manyanta Junta. Wali Jesus pulukkujirnila Juntu ngapanga martuwarrarla Jutunta. ");
INSERT INTO wmt_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jesus ngapanga pulukkujirni. Jamurn turtapinya, nyanartijangka nyanyala kankarral ngapangurni yalkiri langkirrlaparni. Kirlingirrijarrinyani kankarni yapin. Pirlurr Ngarpukurajangka pa nyanya kankarni jirikijiliny kiluwutujiliny. Kankarnimarrangu manyanta kanimparraljarrinya Pirlurr Ngarpukurajangka Jesusja, takurryanila manyanta. ");
INSERT INTO wmt_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Pinakarrinya pa Jesusju lin Kutkura marnujangka kankarnimarrangujangka. Marni parla Ngarpungu Jesusku, “Nyuntu pajin walaku ngajukurajinyangu. Wulyumalany marnangu. Muntanga marnanta martalany wulyu. Ngarrurta marnangu nguniny.” ");
INSERT INTO wmt_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Nyanartijangka partalurnila wurnakujirni Jesus Pirlurru Ngarpukurajangkarlu pintirnikarti kanya. ");
INSERT INTO wmt_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Nyanartijangka Jesus ngunangani pintirni jintanga piyirnngajirtarla. Nyanayirla pa ngunangani yakarn layijaa ngurrawarnti paja. Ngurrawarnti 40 pa ngunangani. Jesus pa kurlpungani pirlangu purlkangu. Ngarpungurni pa tikirrkujirla. Jarti kurlpinya. Wali piyirnwarlany ngajirta palu ngunarla. Kuyiwarntirlamipa manyanangurla ngunangani Jesus, kuyiwarnti yangka rayinjiwarnti. Yarnta ngampurrikanani palu Jesus yinjilwarntirlumipa, ngajirta piyirntu. ");
INSERT INTO wmt_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Nyanartijangka nganpayirlu purlkangu pa tartpartarni yangkarti Jun pulukkujirnujuwal. Yutukanila Jun jayilla. Wali nyanartijangkala Jesus yani Kalalikarti wangkijarti. Wangki wulyu Ngarpukura manyanangu jularnani Jesusju nyapartukarra Ngarpu parlipangu kajalkajal nguniny. ");
INSERT INTO wmt_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Kujarti manyanangu marnani Jesusju, “Jalarra pa kutajarrinya Ngarpupurru majajarrinyupurru, jalarrarni pa Ngarpu kajalkajaljarriwu. Kurnakwantilu yakurrjangka, mapunikarralula wangki wulyu. ");
INSERT INTO wmt_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Wali Jesus kurlangu yanani rirringkirla ngapangal purlkangal yiningal Kalalirlal. Parlipinyala pinya nganpayijarra nyanartikarrajijarra Jayiminjaa Yanturu, paparlangu pila. Tarrapungani pilarla niting kapipurru warntarnupurru, warrkam pilangu nyanarti ngunangani. Wali kapi pila purlkapurlka warntarnani, yijila pilanya yungani pamarrpurru. ");
INSERT INTO wmt_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Wali Jesusju pilangu marni, “Pa. Waangkajapila ngaju. Nyurrajarrajal manpila takiparijarra kapi warntarnujuwaljarra. Pinayungku marnanypinya ngajungu piyirn warntarnupurru taki.” ");
INSERT INTO wmt_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Jamurn pilangu marni Jesusju, partalurnila pila wanyjanurlakani nyanartijarrakura niting, wurnala pila waanya Jesus. ");
INSERT INTO wmt_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Nyanartijangka yanungurla pinya nyanya Jesusju jirna kurrinywarlany nganpayijarra Jayimjijaa Jun. Martarnani pinya paparlangu purrkungu yiningu Jipitirlu ngarpungu nyantujarrakurarlu. Jesus manyanangurla pirriyani. Niting palu ngartakpanani wapirrajawurlu, ngurtinga ngapakarrajirla palu kirrarnani. Purrkungu pinya martarnani walakujarra. ");
INSERT INTO wmt_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jesusjula pinya purpankanya Jayimjijaa Jun. Wanyjanurlakani pilanya ngurtinga nyantujarrakura ngarpujaa kanarlanywarnti warrkammayinwarnti mapirrirni pilanya wanyjanurlakani. Yanila pilanyanta Jesusja. ");
INSERT INTO wmt_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Kurlangu palu yani Jesusjaa Jayiminjaa Yanturujaa Jayimjijaa Jun, Kapaniyakarti palu yani. Jarritijarrinya manyanangurla. Jarriti palu kirrarnani Juwujwarnti warrkamngajirta. Wali mayarurla jujupurrurla pinayungani manya Jesusju. ");
INSERT INTO wmt_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Jesusju manyanangu marni wangki, purrpurrmarnila palu nyanartiwarnti piyirnwarnti Juwujwarnti, Jesusjula wangki manya pinayungani pinangurrurlujinyangu. Pinayungani manya purnkungu. Kanarlanywarnti piyirnwarnti palu tarrukuwu nyantukurawu pinangurruwarnti yini kurayip. Yangkartiwarntirlu kurayipwarntirlu palunya ngajirta kujarti pinayungkarla purnkungu, Jesusju manya purnkungu pinayungani. ");
INSERT INTO wmt_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Wali murtarni pirriyani nganpayi layi pirlajarti mayarukarti jujupurrukarti. Jarlu manyanta pirla takurryani muntanga. Papajani pa nganpayirlu Jesusku, ");
INSERT INTO wmt_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Jesus, nganajangkarlu marnanypanya kujartikujilany. Pirriyani ngan wajapungupurru, wajapungku ngarnanypanya nganampa pirlawarnti. Pinarri marnangu nyuntuwu. Nyuntu man yangkarti wulyujinyangu Ngarpukura.” ");
INSERT INTO wmt_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesusju parla pirlawu jarrmarni, “Kulkurujarri. Jarntakpanyjarlanyanta nganpayijangka nyanartijangka.” ");
INSERT INTO wmt_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Nyanartijangka purtulykujirni pirlangu, pilpilmarnanila. Mayajinyangula papajani pirla. Jarntakparnila parlanyanta nganpayijangka. ");
INSERT INTO wmt_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Wali jamurn palu nyanya nyanarti nganpayi wulyujarrinyujangka, purrpurrmarnila palu. Japirlyungani palunyanu nyantuwarntirlu piyirnwarntirlu, “Nyapartukarra minyarti. Pirlawu parla jarrmalany Jesusju, mapunikarralanypala manyanta jarrmarnujangka pirlangu, pinangurrujilinyjurni manyanangu jarrmalany pirlawu.” ");
INSERT INTO wmt_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Wali pujungurni palunyanangu Kalalijangkarlu Jesus jakuljakuljularni wapalkarrarlu wulyukujirnujangka. ");
INSERT INTO wmt_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Nyanartijangka mayarungurni jujupurrungurni palu yani kanarlanyjurra mayaru. Jesus Jayimjijaa Jun mapirri palu yani, pirriyanila palu mayarurla Jayiminkurarlajaa Yanturukurarla. ");
INSERT INTO wmt_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Takurryani palu mayarurla. Mimijarti pa yukarnani kaninykaniny mayarurla marnin Jayiminku parla mali. Nyanartijangkarlu palurla marni Jesusku, “Mimijarti pa parrparr yukarnana minyarti marnin Jayiminku parla mali.” ");
INSERT INTO wmt_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Wali Jesusju yanungurla ngarrpirtimani, marnin kirrarnukujirni. Parrparr kurrkantinyala, marnin nyanarti kirtilyjarrinyala. Miyila manya yinya malingu Jayiminkurarlu. ");
INSERT INTO wmt_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Nyanartijangka karuwarrarla mungangkurrarla palu yani Jesuskarti. Puranguliny takurryani. Piyirn mimijartiwarntijaa piyirnwarntiwarlany pirlajartiwarnti palunya Jesuskarti kanya piyirnwarntirlu nyanartikarrajiwarntirlu. ");
INSERT INTO wmt_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Piyirnwarnti nukarnini tawunjangkawarnti palu kirlingirrirla ngunangani mayarurla. ");
INSERT INTO wmt_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Mimijartiwarnti paja manya wulyukujirnani Jesusju. Yarnta pirlawarnti manyanangurla jurramanani piyirnwarntiwarlanyjangka. Kulkurukujirnila manya pirlawarnti, tumaj palurla Jesusku pinarri ngunangani, yangkala manya Jesusju kulkurukujirni. ");
INSERT INTO wmt_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Nyanartijangka kumantarla pa Jesus turtapinya manyanjangka. Pukanyjajarti pa mayarungurni yani. Kayanwarlany pa. Purayimarnani parla Ngarpuwu, Ngarpuwu parla wangki marnani. ");
INSERT INTO wmt_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Wali muwupungani palurla pajangu. Jinamanurla palu wajilpinya Jesus Jayimintujaa kanarlanywarntirlu, kitangarni palurla pirriyani. ");
INSERT INTO wmt_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Parlipinya palu. Marni palurla, “Muwupungana mangulu piyirnwarntirlu nukarnirlu.” ");
INSERT INTO wmt_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Nyantungu manyanangu marni, “Yankurlipa mayaruwarntiwarlanykarti. Julawu marnanyanangu Ngarpukura wangki kanarlanywarntiwuwurti. Minyartipurru wangki marna pirriyani.” ");
INSERT INTO wmt_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Nyanartijangkala Jesus kitpungani Kalalirla. Wamarn jularnani manyanangu wangki Ngarpukura mayaruwarntirla jujupurruwarntirla. Yarnta pirlawarnti manyanangurla jurramani piyirnwarntijangka. ");
INSERT INTO wmt_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Nyanartijangka Jesus pa tikiyani mayarukarti tawunkarti Kapaniyakarti. Ngurrawarnti murrkurn pa kirrarni nyanayirla mayarurla Jesus. Nyanartijangka piyirnwarntirlu Kapaniyakarrajiwarntirlu palurlanyanu jakuljularnani, “Jesus pa nyanayirla mayarurla marnpa kirralany.” Piyirnwarntirlu palurlanyanu jakuljularnani. ");
INSERT INTO wmt_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Nyanartijangka mayarurla pa kirrarnani Jesus kaninykaniny. Mayaru pa nyanarti lukajiliny. Jarlu palu ngartakpani lukajangka. Wali pirripirriyanani palunyanta Jesuskarti. Wali nyanarti mayaru palu tipani piyirntu, kurayipwarnti murrkurnjaa kanarlanywarnti piyirnwarnti paja palu ngunangani mayarurla nyanayirla. Tipani palu, kanarlanywarnti palu palkangala karrinyani kirlingirrirla. Kaninykaninyngurni manyanangu wangki wulyu jularnani Jesusju. Kalpurrwarlanyju piyirntu ngarlkarlala palu pinakarrinyani. ");
INSERT INTO wmt_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Kanarlanywarntirlu palurla pirrikanya nganpayi layi nyanarti mimijarti kanyjijarra yakurr yanungajirtajinyangu. Jesuskula palurla kanya kurrinykurrinyju wulyukujirnupurru nganpayiwarntirlu kalukurla. ");
INSERT INTO wmt_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Kanya palu mayarukarti kaninykaninyjurra, yangkala palu jatajatalani. Jarti palurla nyanyangkurra kirlingirriwu takurryanupurru. Paja palunyanta ruk karrinyangurra kirlingirrirla. Parakanya palu nganpayi mimijarti kankarral kurrinykurrinyju kankarnumarrangurlu yungupurru. Nyanartijangkala palu numpurrkarlarni mayaru kankarnumarrangu, kirlingirrila ngujangurra. Wali nyanarti piyirn palu takurrpinya kirlingirrirlal kalukujarti kanimparral. Kankarnumarrangungurni palurla nganpayi kanimpalkujirni. Jesusja palunyanta marnpa yutukani. ");
INSERT INTO wmt_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Wali Jesusju manya nyangani, ngurtparnani palurla Jesusku. Nyanartijangka marni parla nganpayiwu mimijartiwu Jesusju, “Nganpayi. Jalarrarni marnangu wajapungana yakurr nyuntukurajangka.” ");
INSERT INTO wmt_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Wali piyirnwarntirlu nyanartiwarntirlu kurayipwarntirlu palu nyanya. Pinapinakarrinyani palu wangki yangkarti Jesuskura, Jesusju parla marni minyartiwu. Marnani palurlanyanu nyanartiwarntirlu kurayipwarntirlu muntanga kaninykaniny ranyji, ");
INSERT INTO wmt_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Nganajangka pa nganpayi minyarti kujarti malany. Kayan ngartanyanangurla ngananguwurti wajapungka yakurryakurr piyirnngurni. Ngarpungumipa pa wajapungany. Nyapartu manyanu Jesusju kajalkajalkujilany, Ngarpula wartangurnikujilany. Kayan ngartanyanangurla nyantungu wajapungka piyirnngurni.” Kujarti palu kurayipwarntirlu pinapinakarrinyani. ");
INSERT INTO wmt_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","9","Jesusjula manya nyangani yangka palu pinapinakarrinyani muntanga kaninykaniny. Wali marnila manyanangu Jesusju kurayipwarntiwu, “Nganajangkarlu manta kujarti pinapinakarrinyana muntanga. Pinapinakarrilany manta ngulikanupurru. Ngulikarrkula pajanta minyartingurni wangkingurni ngajukurangurni.” Nyanartijangkarlu manyanangu marni, “Nganpayi minyarti marna wulyukujiwu mimijangka, yarnta marna piyirnjangka minyartijangka yakurryakurr wajapungkuwurti. ");
INSERT INTO wmt_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ngarpungu paja yiparni minyartikarti nguwakarti. Ngarpukura maya marna ngajungu martalany, yangkala marna yakurryakurr wajapungany piyirnjangka, marninjangka yapajangka pujurni. Wali kujartikarra marnarla malku nganpayiwu minyartiwu, yangkala pajinta pinarri ngunawu mayawu ngajuwu.” ");
INSERT INTO wmt_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Marnila parla nganpayiwu mimijartiwu Jesusju, “Pinamantaja nganpayi. Turtangka. Kaluku warntarlanyanu, wurnala man turtangurla yanku ngurrakarti.” ");
INSERT INTO wmt_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Nyanartijangka turtapinya pa. Turtangurla warntarni parlanyanu kaluku, partalurnila wurna yani. Tirrinyyanila manyanangurla piyirnwarntirla palkakarti. Wali nyanartijangka purrpurrmarnila palu piyirnwarnti nukarni. Milpala palu purlkajarrinya. Nyangani palu nganpayi wurnajangka yananyjangka. Nyanartijangka wirriyajarrinya palu nukarnini, Ngarpupala palu kajalkajalkujirnani. Marnani palurlanyanu wirriyarlu, “Ngajirta parlipa nyakarla kujartijiliny jarlu. Minyarti parlipa nyangany jalarramipa.” ");
INSERT INTO wmt_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Walimpa ngapanga purlkanga pa Jesus kirrarnani rirringkirla. Wali piyirn paja palunyanta pirriyani yalartiwarntingurni wartangurniwarlany wartangurniwarlany. Ruklaparnani palanta piyirnwarnti paja Jesusja. Ngajirta parla kirlingirri ngunarla. Warpiny palanta rukukani, yangkala ngurtingala parayani ngapakarrajirla Jesus. Piyirnwarnti nyanartiwarnti paja piyirn palu palkangala rirringkirla ngunangani, Jesus pa kirrarnani ngurtinga. Parayanurlala wangki manyanangurla marnani ngurtingurni ngapakarrajingurni. ");
INSERT INTO wmt_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","3","Pinarriyungani manya Jesusju wangki purlka ranyjikarraji. Jularnani manyanangu piyirnwarntiwu, “Piyirnwarnti pinakarrilu. “Layi nganpayi pa kiyi tarrapungujuwal yanani, tarrapungku pa kiyi jirajijiliny miyipurru turtapungupurru. Nyantukurarla yartta nguwanga pikanga manya tarrapungku. ");
INSERT INTO wmt_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","“Nyanartijangkarlula yartta manya tarrapungani kiyi nyanawurlu piyirntu. Tarrapungani manya wamarnkujarra. Kiyiwarnti palu wantinyani kujangkurrajarra. Kanarlanywarnti palu wantinya kirliwarntirla kirninyja. Kanarlanywarnti palu wantinya nguwanga paljarra. Kanarlanywarnti palu wantinya warntarrirla patinga. Nukarnini palu wantinya wulyuwulyu kiyiwarnti tarrapungujangkawarnti, yangka manya tarrapungani piyirntu. Wanyjani manya, walimpa palu wartangurni ngapajangka turtapungku. “Wali wartangurnila palu yukarnani kiyiwarnti nyanartiwarnti. Kanarlanywarnti palu yukarnani warntarrirla palkanga. Jirikiwarntila palu laparni, parlipinyala palunya kiyiwarnti palkangajangka. Yutantinyala palunyanangurla kiyiwarntirla, ngarnanila palunya nyanartiwarnti kiyiwarnti. ");
INSERT INTO wmt_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","“Yarntarni kanarlanywarnti kiyiwarnti wulyuwarnti palu yukarnani nguwanga lartanga. Kankarnumarrangu pa nguwa nyanarti yaru, kaninymarrangu pa paljarr, pamarr ngunangani purlka ranyji kaninymarrangu. Nguwa nyanarti parla kiyiwu larta, ngajirta parla nguna warnamintiwu tartayanupurru kanimpal. Wali partalurnila palu turtapinya warnjal kiyiwarntijangka, turtapungurla kutarni karrinyani. ");
INSERT INTO wmt_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Purangurlula lani lalkawurra warnjal, lalkajarrinyala wurrkal nukarni, yangka nyanarti warnaminti kiyikura ngajirta kaninyparral tartayantarla. ");
INSERT INTO wmt_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","“Yarntarni kanarlanywarnti kiyiwarnti wulyuwarnti palu yukarnani nguwanga kirlinga. Jarlu pa piyirntu jakurrpinya nguwa. Warnaminti kirlikura warrarni ngunangani kaninykaniny nguwapuru. Kula walirni warpinykujirni, minyakujala warrarni ngunangani kaninykaniny. “Nyanartijangkarla palunyanangurla yukarnani kirliwarntirla kiyiwarnti piyirntu tarrapinya. Wali kirninyjarni pila turtapinya ngarlajaa wulyu. Ngarlanguninyju parla tinyungani mana wulyunguniny. Wali ngarlangu manangu nyanawurlu wajapunganila nyanarti mana wulyunguniny. Ngajirta pa nyanawurlu manangu wulyungu martarnantarla miyi, yangka pa nyanawurlu ngarlangu wajapungani. ");
INSERT INTO wmt_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","“Yarntarni kanarlanywarnti kiyiwarnti palu yukarnani nguwanga wulyunga yatunga. Wali nyanartijangka kiyiwarnti palu turtapinya yukajiliny, kankarralparni lani turtapungurla palu karrinyani. Yingkinjarti palu karrinyani. Purlkajarrinyala kiyijangka. Yangka palu nguwanga yatunga wantinyani, nyanarti palu miyi martarnani yingkinjarti nukarnirlu. Kanarlanywarnti palu karrinyani murrkurnjarti miyi. Yingkintu manya martarnani 30 kiyiwarnti jirajijilinywarnti. Kanarlanywarnti palu karrinyani ngarrjamartajarti miyi. Yingkintu manya martarnani 60 kiyiwarnti jirajijilinywarnti. Kanarlanywarntiwarlany palu karrinyani pajajartijinyangu miyi. Yingkintu manya martarnani 100 kiyiwarnti jirajijilinywarnti.” ");
INSERT INTO wmt_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Marnanila manyanangu Jesusju, “Puju manta pinangu tarrpartawu, wali nyanarti, pinakarriwu manta.” ");
INSERT INTO wmt_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Walimpawarlany manyanangurla ngunangani piyirnwarntirla mapirrikarrajiwarntirlajaa piyirnwarntiwarlanyja murrkurnta. Japirlyungani palurla Jesus, “Nyapartukarra yangkarti man marni, kiyiwarnti tarrapungujangkawarnti manunya jularni.” ");
INSERT INTO wmt_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesusju manyanangu marni mapirrikarrajiwarntiwu, “Jarlu marnanyirrangu jularni wangki ranyjikarraji. Jalarrala marnanyirrangu wangki yangkarti kalarakujiwu nyurrawarntiwu, yangkala mantarla wangkiwu pinarri ngunawu. Pinarri mantarla ngunawu nyapartukarra Ngarpu parlipangu kajalkajal nguniny. “Wali nyurrawarntiwu mapirrikarrajiwarntiwu marnanyirrangu ngajungu kalarakujilany wangki, yangkala nyanartiwarntiwu kanarlanywarntiwu marnanyanangu julawu ngajungu wangki rantangangurni.” ");
INSERT INTO wmt_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yarntarni Jesusju manyanangu marni mapirrikarrajiwarntiwu, “Puju kayan nganta pinangu pinakarri minyarti wangki kiyi tarrapungujangka, kayan nganta pinangu pinakarri wangki nganawurti minyartijiliny ranyjikarraji nyurrawarntirlu.” ");
INSERT INTO wmt_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Wali nyanartijangka Jesusju manyanangu kalarakujirni mapirrikarrajiwarntiwu wangki ranyjijangka nyapartukarra parlipangu kiyiwarntirlu pinajulalany. Kujartikarra manyanangu marni, “Nyanarti piyirn Ngarpukura yangka manyanangu julalany, nyanartijilinyparni piyirn minyarti kiyi tarrapungujuwal ngunangani. Wali nyanarti kirlingalparni piyirntu julalany Ngarpukura wangki lirrangu, nyanartijilinyparni kiyi tarrapungujangkajiliny nguwanga yukarnani. ");
INSERT INTO wmt_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Wali kiyiwarnti kanarlanywarnti palu yukarnani palkanga warntarrirla, jirikirlula palu ngarnani. Nyanartijilinyparni palu piyirnwarnti kanarlanywarnti nguniny. Wangki palu pinakarrilany Ngarpukura jularnujangka. Ngajirta palu mapunikarra. Pirlangu purlkangu yap kangany partalurni. Kulmanurla manyanangurla kangany wangki nyanarti. Piyirnwarnti nyanartiwarnti palu kiyijilinyparni nguniny palkanga. ");
INSERT INTO wmt_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","17","Yarntarni kanarlanywarnti kiyiwarnti palu yukarnani nguwanga paljarra, partalurnila palu turtapinya. Walimpa purangurlula manya lani lalkawurra. Nyanartijilinyparni palu nguniny piyirnwarnti kanarlanywarnti. Pinakarrilany palu nyanarti wangki Ngarpukura, wirriyajarrilanypala palu. Walimpa jingkirrikangany palunya piyirnwarntiwarlanyju, yarnta kujikarralany palu kanarlanykanarlanyju piyirntu tumaj palu mapunikarralany wangki Ngarpukura. Nyanartijangka ngajirta palurla mapunikarra jutungurni. ");
INSERT INTO wmt_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Yarntarni kanarlanywarnti kiyiwarnti palunyanangurla yukarnani kirlinga. Turtapinyajal palu wurrkal wulyuwarntijaa ngarlawarnti. Tintinyinyala palunya ngarlanguninyju kirliwarntirlu, yangkala ngajirta palu wulyuwarntirlu miyi martarla. Wali nyanartijilinyparni palu nguniny piyirnwarnti kanarlanywarnti. Pinakarrilany palu wangki Ngarpukura, mapunikarralanypala palurla kaparnwarlanyparni. Ngajirta palurla munta kayan nguna Ngarpuwu. Wali pinapinakarrilanypala palu pamarrjaa manawarnti. Nganapartu nganapartu palu pinapinakarrilany jutungu. Ngajirta palu Ngarpu pinapinakarri. Yarnta palurla yakurr nguniny munta kayan kujikanurlamarra. Ngajirta palu nurrurrurlu mapunikarra. ");
INSERT INTO wmt_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Yarntarni kanarlanywarnti kiyiwarnti palu yukarnani nguwanga wulyunga. Turtapinyala palu, purlkajarrinyala palu, walimpa palu nukarnini miyijartijarrinyala. Kanarlanywarntirlu palu murrkurn martarnani kiyiwarnti 30 yingkintu, kanarlanywarntirlu palu ngarrjamarta martarnani kiyiwarnti 60 yingkintu, kanarlanywarntirlu palu pajajinyangu martarnani kiyiwarnti 100 yingkintu. Nyanartijilinyparni palu piyirnwarnti kanarlanywarnti nguniny. Pinakarrilany palu wangki Ngarpukura. Mapunikarralanypala palu, munta kayan palurla nguniny Ngarpuwu. Nurrurrurlu palurla mapunikarralany. Nguninypala palu nyapartukarra manyanangu Ngarpungu wulyumalany. ");
INSERT INTO wmt_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Nyanartijangka karuwarrarla Jesusju manyanangu marni piyirnwarntiwu mapirrikarrajiwarntiwu, “Wurna parlipa yanku rirringkiwarlanykarti kurlirninyirra kurlirninyirrakarti.” ");
INSERT INTO wmt_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Jesus pa kirrarnani juturni ngurtinga. Nyanartijangka palu mapirrikarrajiwarnti parayanukarrakanya ngurtinga. Kanyala palu Jesus ngurtijarti. Wali paja piyirn palunya wanyjani ngurtijawurlu ngapakarrajijangkajawurlu. Ngurtiwarntiwarlany palu mapirrirni jakarni. ");
INSERT INTO wmt_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Nyanartijangka walypa purlka pirriyani. Kuparlaparla purlkajarrinya manyanangurla, walypangu ngapa kuparlaparla purlkakujirni. Ngapa manyanta yimpirlmarnani ngurtikarti, tipanani manyanta ngurtinga. ");
INSERT INTO wmt_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesus pa ngurtinga yukarnani wartangurni jiwaljirla. Yukarnani manyan wurnanga wurnanga ngurtinga ngapakarrajirla. Wali parnkimani palu manyanjangka, marnila palurla, “Purlka. Nganajangka man manyanmipa yukarnana. Ngapangujal parlipanya ngalku jalarra. Jalarrajal parlipa pirlajarriwu.” ");
INSERT INTO wmt_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Purlka nyanartijangka parnkijarrinya. Wali jarrmarnila parla walypawu, marnila parla ngapawu Jesusju, “Lamajarri.” Wali lamala larlnguja ngapa nyanarti walypangajirtajarti. ");
INSERT INTO wmt_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jesusju manyanangu marni mapirrikarrajiwarntiwu, “Ngapangu manya rayinkujilany. Ngajirta manta pinakarri Ngarpu mapunjinyangu. Pinakarrilany manta rayinkarrinyupurru.” ");
INSERT INTO wmt_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Wali rayinjarrinyala palu, purlkajinyangu rayin. Wali jularnani palurlanyanu, “Nganaparta nganpayi minyarti. Minyajal pilanyanta mapunikarralany walypanguwurtijaa ngapanguwurti. Jarrmalany pilangu.” ");
INSERT INTO wmt_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Nyanartijangka Jesusjaa piyirn nyantukurawarnti mapirrikarrajiwarnti palu pirriyani ngurtijarti ngapakarrajijarti kakanikakani ngapanga purlkanga. ");
INSERT INTO wmt_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","3","Piyirn yini Karrajiyin palu ngunangani nyanayirla. Jamurn Jesus jupantinya ngurtijangka, marnpa parla pirrilaparni piyirn kayan najijangka, wanyjarrarla palunya pirlajarrinyujangka tartakujirnani. Minyarti nganpayi pa pirlajarti ngunangani nyanayirla najinga. Muntanga manyanta pirla ngunangani. Pirlangu pa wangartakujirnani. Pajamirru palu jakarr karrpirni jinajaa kurrapa. ");
INSERT INTO wmt_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Manangu nyanawurlu tanyjingu ngajirta pa tartpartarnantarla. Nyantungu pa yarrparni tulungjunganani nyanarti mana tanyji kurrapajarrajangka. Nyamarrpunganila manyanu tanyji nyantukurajangka jinajarrajangka. Mayaparijinyangu pa ngunangani, yangkala ngananguwurti piyirntu ngajirta pa lamakujirla. ");
INSERT INTO wmt_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Kakarra piyip karla takurr pukanyja julngurru kujartirlurra wampalmarnaninyirra pirlawarntikurarla ngurrangajaa pamarra. Nira pa papajananinyirrajaa junganani manyanu pamarru jiringu. ");
INSERT INTO wmt_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Wali piyirntu nyanawurlu Jesuspala parlipinya marringurni ngurtijangka jupantinyujangka. ");
INSERT INTO wmt_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Nyanartijangka pupurula laparnkanya yalartingurni. Mirtijurrurnjurrurn wantinyala manyanta Jesusja. Jesusju parla marni, “Nyuntu pirla jarntakpanyjarlanyanta nyanartijangka nganpayijangka.” Nyanawurlu nganpayirlu parla nganymarni Jesusku, marnila parla, “Jesus, walaku Ngarpukura purlkakura, nganajangkarlu paja kujartikujilany. Ngajirta ngajan walajiyungka. Ngajirta ngajan pirlapirlakarra.” Nurrurrurlu parla marni nganpayirlu. ");
INSERT INTO wmt_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jesusjula japirlyinya, “Ngana man nyuntu yini.” Nyantungula manyanta jangkumani, “Ngaju marna yini Paja, tumaj marnalu paja nguniny.” ");
INSERT INTO wmt_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Nyanawurlula piyirntu parla marni nurrurrurlurni, “Ngajirta nganunya ngunyipungka minyartiwarnti pirlawarnti ngurrajangka minyartijangka.” ");
INSERT INTO wmt_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Wali nyanartikarra marnparni palu paja pikipikiwarnti karrinyani pamarra rirringki, miyi palu ngarnani. ");
INSERT INTO wmt_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Wali nyanartiwarntirlu pirlawarntirlu palu nurrurrurlu ngarntimani, “Jesus, yipawu manpanya pikipikiwarntikarti. Takurryanku marnalunyanangurla.” ");
INSERT INTO wmt_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Nyanartijangka yiparnurlakani manya Jesusju. Nyanartiwarnti pirlawarnti palu pirriyani, tartayanila palunyanangurla pikipikiwarntirla pajanga. Nyanartiwarnti pikipikiwarnti pajajinyangu palu karrinyani kunyungurla 2 jawujun. Pujurnila palu laparni kanimpal ngalangalangurni. Puluklaparni palu ngapanga purlkanga, yurrantinyala palu pujurni. ");
INSERT INTO wmt_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Nyanartijangka laparnkanyala palu piyirnwarnti nyanartiwarnti pikipiki ngampurrjiwarnti. Nyanartirni wangki palunyanangu jakuljularnani piyirnwarntiwu mayarukarrajiwu. Wali mayaruwarntijangkala palu pirriyani nyanartikarra piyirnwarnti nyangupurru. ");
INSERT INTO wmt_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Marnpa pirriyanurla parlipinyala palu Jesus. Piyirn wulyujarrinyujangka manyanta kirrarnani marnpa, nyanartirni piyirn yangka pirlawarnti paja manya martarni. Mana karrkinta martarnani, pinangu jirrkirlpala pinakarrinyani. Purrpurrmarnila palurla piyirn paja nyangujangka. ");
INSERT INTO wmt_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Jularnila palunyanangu mayarujangkawarntiwu kanarlanywarntirlu, “Yangkarti nganpayi marnalu nyanya wangartajangka, wulyujarrinya pa. Yarnta pirlawarnti palunangurla takurryani pikipikiwarntirla. Puluklaparnila palu ngapanga nukarnini pirlawarnti mapirrirni.” ");
INSERT INTO wmt_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Nyanartijangka piyirnwarntirlu pujungurnila palurla Jesusku nurrurrurlu ngarntimani, “Yanku man ngurrajangka minyartijangka.” ");
INSERT INTO wmt_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Wali jamurn Jesus parayanani ngapakarrajirla ngurtinga, nganpayirlu nyanawurlu wulyukujirnujangkarlu parla juturni ngarntimani. Marni parla Jesusku, “Mapirri marnangurla yanku.” ");
INSERT INTO wmt_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jesusju lamakujirni. Kujala parla marni, “Tikiyantanyanangu nyuntukurawarntiwu. Julawu manunyanangu nyapartukarra manta Ngarpungu purlkangu yarakujirni. Yarntarni manunyanangu julawu nyapartukarra mangu yawiyijarrinya Ngarpungu.” ");
INSERT INTO wmt_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Wali nganpayi nyanarti turtangkanya, jularnanila manyanangu wangki mayarurla Tikapalijja. Piyirnwarntiwu pajawu manyanangu jularnani nyapartukarra Jesusju wulyukujirni, purrpurrmarnila palu piyirnwarnti nyanartiwarnti pinakarrinyujangka. ");
INSERT INTO wmt_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Wali nyanartijangka Jesus tikiyani karlanikarlani ngapanga purlkanga. Nyanayirla rirringki palunyanta marnpajarrinya Jesusja piyirnwarnti paja. ");
INSERT INTO wmt_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Layi nganpayi manyanta pirriyani Jesusja yini parla Jarij. Warrkammarnani pa mayarurla jujupurrurla. Parlipungurla jinanga Jesusja manyanta lapart parntawantinya kajalurni japirlyungupurru. Ngarntimananila parlanyanta nurrurrurlu Jarijju mangawu kurntalku. Marni parla, “Ngajukura yapa pa yukalany purlka mimi jamurnku pirlawu. Yanungurla man palymanku yarakujiwujaa wanjikujiwu.” ");
INSERT INTO wmt_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Nganpayi nyanarti turtapinya. Jarrkanya parla Jesusku, yananila pila. Piyirn paja palunyanta warryani Jesusja, marnpa palunyanta lawuwantinyani tirntirnkarra. ");
INSERT INTO wmt_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Layi marnin manyanangurla ngunangani yitilalwarnti paja 12 ranyjipirrajarti. Marninkurajiliny martarnani. ");
INSERT INTO wmt_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Jarti palurla mirrijin yungani maparnwarntirlu lamakujirnupurru. Pamarr manyanangurla pujumani maparnwarntirla. Ngajirta wulyujarrirla, mayajarrinyala. ");
INSERT INTO wmt_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Jarlu palurla jularni Jesus wulyukujirnujuwal. Nyanartijangka Jesusja palanta paja warrlaparni, wali marnin nyanarti manyanangurla mapirri yanani. ");
INSERT INTO wmt_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Pinapinakarrinyani parlanyanu, “Palymanku marnanyanta Jesusja palya, wulyujarriwula marna.” ");
INSERT INTO wmt_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Nyanartijangka palymani parla Jesuskura palya marnintu, lamajarrinyala nyanartikarra. Ngungkupungani manyanu kaninykaniny lamajarrinyujangka. ");
INSERT INTO wmt_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jesusju manyanu ngungkupinya nyantukura maya manyanta tirrinyyani karnalanyjurra. Nyanartijangka kurnakwantinya. Marni manyanangu, “Nganangu paji ngajukura palya palymani.” ");
INSERT INTO wmt_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Mapirrikarrajiwarntirlu palurla marni, “Paja marnangulurla wamarn karrilany. Kunyungurla nganangu partanta palymani. Ngurrpa marnalurla.” ");
INSERT INTO wmt_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jesusju parla nyangani kulkururlu wanyjarrarlu palymani. ");
INSERT INTO wmt_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Marnintu manyanu ngungkupungani kaninykaniny Jesuskurarlu mayangu lamakujirni. Nyanartijangka yanila manyanta Jesuskarti parntawantinyala manyanta jinanga rayintu. Jularni parlanyanu nukarnini. ");
INSERT INTO wmt_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesusjula parla marni nyanartiwu marninku, “Mapunikani pajan, wulyujarrinyala man. Wali marnanta wulyukujirni, wurnala man yanku wirriya.” ");
INSERT INTO wmt_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Walimpawarlany kukajartila palurla pirriyani nyanartiwu nganpayiwu Jarijku. Marni palurla, “Kurntalku man marlaljarrinya. Nganapurru man jutungu ngarntimalany nyanarti nganpayi pinayungujuwal Jesus.” ");
INSERT INTO wmt_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesusju manya jamulu pinakarrinya. Marnila parla Jesusju nganpayiwu nyanartiwu Jarijku, “Ngajirta ngankurlanyanu karrartajarri, yarr pajanurla ngurtngunawu ngajunga.” ");
INSERT INTO wmt_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Jarrmarni manyanangu Jesusju, “Ngajirta nganta piyirn paja pirriyanta. Yarr murrkurnmipa yantajilurla.” Kanya manya Pitajaa paparlangu Jayimjijarra Jun. ");
INSERT INTO wmt_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Nyanartijangka pirriyanila palunyanta Jarijkurarla mayarurla. Piyirnpala paja palunya parlipinya nyanayirla, maya palu lungani kujangkurrajarra. ");
INSERT INTO wmt_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Tartayanurla marnila manyanangu Jesusju, “Nganapurru manta kuja warawaramalany. Nyanarti manga ngajirta pirla, yarr pa manyan yukalany.” ");
INSERT INTO wmt_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Yarrparnila palurla jingkirti warralpinya nyanartiwarntirlu pajangu. Nyantungu manya yarrmipa ngunyipinya palkakarti. Murrkurn manya tartakujirni Pitajaa Jayimjijaa Jun. Ngamajijaa ngarpu, mapirrirni manya tartakujirni. Wali nyanartijangka yanila palu mangakarti ngurra wanyjarrarla yukarninyirra. ");
INSERT INTO wmt_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Jesusjula tarrpartarni kurrapa nyanarti manga, marnila parla, “Turtapungka manga.” ");
INSERT INTO wmt_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Manga nyanarti mapunparnila turtangurla kitpungani. Nyanartiwarntirlula palurla purrpurrmarni, mil palu purlkajarrinya. Manga yangka purlka yitilalwarnti 12 parla. ");
INSERT INTO wmt_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jarrmarnila manyanangu nyanartiwarntiwu mapirrijangkawu Jesusju, “Ngajirta ngantanyanangu jula kujangkurrajarrawu kanarlanywarntiwu.” Miyiwula manya jinjinyinya yungupurru manga nyanarti marranyan. ");
INSERT INTO wmt_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jesus manyanangurla piyirnwarntirla mapirrikarrajiwarntirla ngunangani. Piyirnwarnti kanarlanywarnti paja palu pirripirriyanani. Mirnpungani palu nyanartiwarntirlu piyirnwarntirlu, yangkala miyi ngajirta palu nganyjarla Jesusjujaa nyantukurawarntirlu mapirrikarrajiwarntirlu. Nyanartijangka marni manyanangu Jesusju nyantukurawarntiwu mapirrikarrajiwarntiwu, “Wurna parlipa yanku. Jintanga parlipa kirralku piyirnwarntingurni rantanga.” ");
INSERT INTO wmt_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ngapakarti palu turtangkanya ngurtikarti ngapakarrajikarti Jesusjaa mapirrikarrajiwarnti piyirnwarnti. Ngapangal purlkangal palu yani ngurtijarti pintirnikarti. ");
INSERT INTO wmt_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Nyanartijangka piyirnwarntirlu palunya pajangu nyanya nyanartiwarnti turtangkarranyjangka ngurtijarti. Nginyjirrikani palunya, jinala palu wamarn laparni ngapangal rirringki. Mayaruwarntijangka palu pirripirrilaparni piyirnwarnti nyanartiwarnti kanarlanywarnti. Kajalurni wantinya palu, Jesus jupantinyala ngurtijangka. ");
INSERT INTO wmt_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Nyanartijangka jupantinyurla piyirnwarnti pupurujangkawarnti manya nyanya Jesusju. Yawiyijarrinyala manyanangu, tumaj palu yarr wampalmarnani, ngananguwurti ngajirta manya ngampurrmanantarla. Wali purlka wangki manya pinayungani Jesusju. ");
INSERT INTO wmt_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Nyanartijangka karuwarrajarrinya. Piyirnwarnti mapirrikarrajiwarnti palunyanta yani Jesuskarti. Marni palurla Jesusku, “Minyarti ngurra pa walmarta, miyi ngajirta parlipangu nguna. Purangu pa kutajarrinya. ");
INSERT INTO wmt_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Manyjanyanangu minyartiwarntiwu piyirnwarntiwu. Mayarukarti palu yanku. Warntawu palurlanyanu ngurrujarra ngurrujarra miyi pamarrjawurlu.” ");
INSERT INTO wmt_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Wali jangkumani manyanangurla Jesusju mapirrikarrajiwarntiwu, “Kayan ngarnanya marri yipanyja, nyurrawarntirlu mantanya yungku miyi ngarnupurru marnpajangka.” Marni palurla Jesusku, “Nyapartukarrala marnalunyanangu miyi warntawu nyanartiwarntiwu piyirnwarntiwu. Ngajirta marnalu marta pamarr purlka yangka $200 miyiwu warntarnupurru.” ");
INSERT INTO wmt_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Japirlyinya manya Jesusju, “Yanungurla nyakulurla, nyarrjangu manta miyi martalany kanarlanywarntiwu yungupurru.” Nyangungurla palurla jularni Jesusku, “Miyi kurriny kurriny kayanjaa kapijarra kurriny marnalu nyanya.” ");
INSERT INTO wmt_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Nyanartijangka piyirnwarnti nukarnini manya jinjinyinya Jesusju, “Yutantilu yukanga wurrkalla tukuwarlany tukuwarlany.” ");
INSERT INTO wmt_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Kajalurnijaa wartangurni palu yutantinya kirri, nganimpirriwarlany nganimpirriwarlany palu kirrarnani. ");
INSERT INTO wmt_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Miyiwarntijaa kapijarra manya warntarni Jesusju. Millu kankarral nyanya, Ngarpuwula parla ngarntikanya Jesusju, miyila manya jungani Jesusju. Yinya manya mapirrikarrajiwarnti. Marni manyanangu, “Yungkalunya.” Yarntarni kapi manyanangu jungani. ");
INSERT INTO wmt_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ngarni palu nukarnirlurni, kinkijartijarrinyala palu. ");
INSERT INTO wmt_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Nyanartijangka miyijaa kapi jakarrngarnujangka palu warntarni mapirrikarrajiwarntirlu, ngurtiwarntirla purlkawarntirla 12ja palu takurrpinya. ");
INSERT INTO wmt_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Yangka piyirn palu nguja nyanartikarra paja 5 jawujun. ");
INSERT INTO wmt_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Nyanartijangka piyirnwarntiwu mapirrikarrajiwarntiwu manyanangu marni Jesusju, “Kajalu manta yanku ngapanga purlkanga ngurtijarti ngapakarrajijarti. Ngurrakarti Pijayirtakarti kakanikakani manta yanku.” Yarntarni kanarlanywarnti piyirnwarnti nukarnini manya yiparni. Pujurni palu tikitikiyani pulparral ngapangajirtarlal ngurrawarntikarti. ");
INSERT INTO wmt_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Yiparnurlakanungurla pamarrkartila yani nyantu Jesus. Nyanayirla parla purayimarnani Ngarpuwu, Ngarpuwu parla japirryungani. ");
INSERT INTO wmt_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Wali mungajarrinyala manyanangurla mapirrikarrajiwarntiwu. Kaparn muntanga palu karrinyani ngurtijarti, Jesuspala pamarra warrarni kirrarnani. ");
INSERT INTO wmt_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Pamarrngurni manya nyanya Jesusju wampalmarnanujangka. Kayan ngartalu tirrinyyantarla ngurtijarti. Walypangu manya lamakujirni. Nyanartijangka munganga jamurn yangka rarrpajarrinyani kakarra, Jesuspala manyanangurla pirriyanani mapirrikarrajiwarntirla. Waangani manya wartangurni. Kankarninyirra yanani ngapangal, kula nguwangalparni. ");
INSERT INTO wmt_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Nyanya palu ngapangal yananujangka. “Warawu,” marni palu. Kula palu pirlarni nyanya. ");
INSERT INTO wmt_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Nyangungurla palu rayinjarrinya. Partalurnila manyanangu marni Jesusju, “Ngajirta nganta rayinjarri. Ngaju marna Jesus. Purnkujarrilu.” ");
INSERT INTO wmt_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Nyanartijangka Jesus manyanangurla takurryani ngurtinga mapirrikarrajiwarntirla, lamajarrinyala walypa, purrpurrmarnila palurla. ");
INSERT INTO wmt_vpl VALUES ("MK6_53a","071_6_53a","MRK","6","53a","53a","Nyanartijangka juturni palu yanani ngapangal, pirriyanila palu rirringki. ");
INSERT INTO wmt_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesus yani tawunjangka yini parla Tayiya. Tayiyajangka yani pa kayirrara Jayitankarti. Jayitanjangka yani Jesus wamarn kakarrangu. Tikapalijjangka pirriyani ngapanga purlkanga yininga Kalalirla. ");
INSERT INTO wmt_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Nganpayi palu kanya piyirnwarntirlu Jesuskarti pina rukjarti jalany kuta. Ngajirta pa wangki manyjarla, ngajirta pa wangki pinakarrinyantarla. Yapajangkarni pa ngunangani pina rukjarti jalany kuta. Wali ngarntimarnanila palunyanta Jesusja piyirnwarntirlu nurrururlu, ngarntimarnani palurlanyanta nganpayiwu palymanupurru. ");
INSERT INTO wmt_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Nyanartijangka Jesusju kanya piyirnwarntijangka palkakarti nganpayi pina rukjarti jalany kuta. Kangungurla manyanta takurryani Jesus kurrapajarra nganpayirla pinajarrarla. Juwajpanila manyanu Jesusju jamarnta kurraparla, kurraparlurnila palymani piyirn jalany. ");
INSERT INTO wmt_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Nyanartijangka Jesus mil kankarraljarrinya, marnila parla Jesusju, “Kirlingirrijarri pinajarra.” ");
INSERT INTO wmt_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Wali partalurni pinajartijarrinya nganpayi nyanarti, yarntala larrakarnjarrinya, marnanila manyanangu larrakarn. ");
INSERT INTO wmt_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Nyanartijangka Jesusju manyanangu marni, “Ngajirta ngantanyanangu piyirnku ngantuwurti jula.” Wali Jesusju nurrurrurlu manyanangu jarrmarni. Nyantuwarntirlu ngajirta palurla mapunikarrarla Jesusku, jutungurni palunyanangu jakuljakuljularni wapalkarrarlu. ");
INSERT INTO wmt_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Purrpurrmarni palurla piyirnwarnti pinakarrinyujangka. Marni palurlanyanu, “Nganpayi minyarti Jesus pa wulyukujirnujuwal. Minyakatanya kirlingirrikujilany pina rukjartiwurti, yarnta piyirnwarnti jalany kutajangka manya juwalkujilany.” ");
INSERT INTO wmt_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jesusjaa piyirnwarnti mapirrikarrajiwarnti palu pirriyani tawunta yininga Pijayirtarla. Kanarlanywarntirlu piyirnwarntirlu palunyanta purpankanya Jesuskarti nganpayi jankajarti. Ngarntimarni palurla piyirnwarntirlu palymanurla wulyukujirnupurru. ");
INSERT INTO wmt_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesusju tawunngurni ngarrpirtimankanya pintirnikarti jankajarti. Juwajpani manyanta milla jankajartirla jamarnta, palymanila Jesusju kurraparlu. Palymanurla parla marni, “Wayila man nyangany nganawurti.” ");
INSERT INTO wmt_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ngalaramarni nyantu nganpayi jankajarti. Marni parla Jesusku, “Piyirnwarnti marnanya nyangany kitpungujangka. Kula manawarntirni purlkawarnti, minyakujala palu piyirnwarnti.” ");
INSERT INTO wmt_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yarntarni pa palymani mil kurraparlu Jesusju, warrpunyanyala jankajawurlu, milpala lirrjinjarrinya. ");
INSERT INTO wmt_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Nyanartijangka Jesusju nganpayi yiparni ngurrakarti nyantukurakarti. Marni parla, “Ngajirta ngan tikiyanta tawunkarti.” ");
INSERT INTO wmt_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Jesusjaa murrkurn piyirnwarnti mapirrikarrajiwarnti kankarral pamarra palu parayani jintanga Pita Jayimjijaa Jun. Jesus karrkin kurnakwantinya, kanarlanyparnijarrinyala. ");
INSERT INTO wmt_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Mana wirrimpurru nyantukura palypalymanani parpjartijinyangu. Kayan ngarta ngantunguwurti lukurrpungka nyanartijilinywurra parpjartiwurra. ");
INSERT INTO wmt_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Nyanartijangkarlu nyanya palupinya mapirrikarrajiwarntirlu karrinyujangka Mujijjaa Yilayija. Wangkijarti palupinya nyanya, wangki pilanyanta marnani Jesusja. Nyangungurla palu rayinjarrinya mapirrikarrajiwarnti. ");
INSERT INTO wmt_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Pita ngajirta parla pinarri ngunarla wangkiwu marnupurru, yangkala parla paparrmarni Jesusku, “Purlka.” Turtuk parlipa nguniny minyayirla. Yutukarrku marnanyirrangulu wurriny minyayirla kayan nyuntuwu, kayan Mujijku, kayanwarlany Yilayijawu.” ");
INSERT INTO wmt_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Nyanartijangka pirriyanila yurnturr, kutantinyala manyanangurla wangarr. Kaninykaninyngurni yurnturrngurni palu pinakarrinya lin Ngarpukura marnujangka. Marni manyanangu Ngarpungu, “Minyarti paji walaku ngajuwu, wulyu marna kangany muntanga. Pinakarrilunyanta nyantunga.” ");
INSERT INTO wmt_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Jamurn palu pinakarrinya lin, warrpkarra nyanyala palurla mapirrikarrajiwarntirlu, jartila palupilangulu nyanya. Jesusmipala palu nyanya, wirlmarni pila kurrinywarlany nganpayijarra yinijarra Yilayijajaa Mujij nyanayirlarni. ");
INSERT INTO wmt_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Nyanartijangka jupantinyanila palu Jesusjaa mapirrikarrajiwarnti kanimpal tikirr. Marnila manyanangu Jesusju, “Ngajirta ngantanyanangu jula piyirnku ngantuwurti wangki nyangujangka. Mularnpungku mantanyanangu kajirna pirlajangka wanjijarriwu. Nyanartijarra mantanyanangu julawu piyirnku walimpa.” Jarrmarni manyanangu Jesusju. ");
INSERT INTO wmt_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Wali mularnpunganila palunyanangu nyanarti wangki kanarlanywarntiwu pamarra nyangujangka, yangkala japirlyungani palunyanu mapirrikarrajiwarntirlu, “Nyapartukarra wangki minyarti manyanu jularnani pirlajangka pa wanjijarriwu. Ngurrpa marnalurla.” ");
INSERT INTO wmt_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Wali nyanartijangka palu turtuyani piyirnwarnti yiniwarnti Pitajaa Jayimjijaa Junjaa Jesus pamarrngurni kaninyparral. Pirriyani palunyanangurla kanarlanywarntirla mapirrikarrajiwarntiwarlanyja. Kajalu palu karrinyani mungkurr mapirrikarrajiwarntijaa piyirnwarnti kurayipwarnti. Piyirnwarntiwarlany paja mapirri palu karrinyani. Wali nyanya palunya Jesus mapirrirlu. Kurayipwarntirlu palunya japirlyungani mapirrikarrajiwarntiwarlany yapapurru wulyukujirnupurru. ");
INSERT INTO wmt_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Nyanartijangka Jesus palu nyanya piyirnwarntirlu. Wali ngarrurtajarrinyala palu Jesus nyangujangka, pupurula palanta laparni Jesuskarti, jamurn palu nyanya. Marni palurla, “Ngurt marnangulurla nguniny nyuntunga.” ");
INSERT INTO wmt_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jesusju manya pinakarrinyani marnujangka yangka kurayipwarntirlu palunya japirlyungani mapirrikarrajiwarnti mayangu kajaluwarlany wangki. Nyanartila manya japirlyinya Jesusju nukarnini, “Ngana wangki mantarlanyanu marnana. Julajilu.” ");
INSERT INTO wmt_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Nganpayirlu layingu manyanta jangkumani, “Yu, julawu marnangu. Pirrikanya marnangu nyuntuwu minyarti parri walaku ngajukura. Nyakarla man nyuntungu, minyakujala man yap yani, yangka marnangurla wartapuran pirriyani. Minyarti parri ngajirta wangki manyja, lirra pa nguniny numjarti. Pirlangu pa patanyjakujilany. ");
INSERT INTO wmt_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Pirlangu pa tartpartalany, palypungany manyanta nguwanga, nyanayirla manyanu nartwarntalany. Pirlangu pa rukukarralany ngayila. Kayan ngarta ranganyja parri nyanarti. Lirra manyanu kinyirrkarra pajarralany. Jamarntala manyanta pirriyanany parringa. Kayanmirri kayanmirri pa kujartijarrilany, nyanartijangka marnanyanangurla kanya parri mapirrikarrajiwarntikarti nyuntukurawarntikarti. Jarti marnanya japirlyinya pirla jurramanupurru. Jarti palu ngunyipinya pirla parringajangka.” Kujarti parla marni nganpayirlu nyanawurlu ngarpunyankurarlu Jesusku. ");
INSERT INTO wmt_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Nyanartijangka Jesusju manyanangu marni piyirnwarntiwu nukarniwu, “Nyurrawarnti manta Ngarpu mapunjingajirtawarnti. Kayan nganta mapunikarra mapunjinyangu. Warrarni manta mapunikarralany kaparnwarlanyparni. Jarlujangka kartarna ngunangani marnanyirrangurla. Larrkikanani marnanyirrangurla wangki Ngarpukura. Nyapartujangkarlu pajantarla nganga pinakarrinyani.” Nyanartijangka manyanangu marni Jesusju, “Kaj. Parri warntajilu.” ");
INSERT INTO wmt_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Kanyala palanta Jesuskarti parri nyanarti. Wali pirlangu parlipinya Jesus. Jamurn nyanya Jesus pirlangu palytarrapinyala parri nguwangkurra kanimpal. Wantinyala parri yangkala witawitakarninyirra nguwanga kaniny, jamarntala manyanta pirriyani lirrangurni. ");
INSERT INTO wmt_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesusju pa japirlyinya ngarpunyankura parrikura. “Nyangurlakarrajangka kujartijarrinyani parri.” Ngarpungu nyantukurarlula manyanta jangkumani, “Yarr pa lamparnjangkarni kujartijarrinyani. ");
INSERT INTO wmt_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Yangka paji tarrapungani yapa ngajukura, warlunga pulukkujirni pirlangu. Yarntarni ngapanga pulukkujirnani. Kunyungurla pajarla kulmanku pirlangu.” Yarntarni parla marni piyirntu, “Kunyungurla man pirla jurramanujuwal, kunyungurla ngajirtaparta. Puju man nyunturni pirla jurramanujuwal, wali nyanarti. Puju manpangu yawiyijarrilany, wali pirla jurramantanyanta ngajukurarlajangka parringajangka.” ");
INSERT INTO wmt_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Nyanartijangka Jesusju parla marni, “Nganajangkarlu pajan japirlyungany kujarti, kunyungurla marna pirla jurramanujuwal. Mapunparni marnanyirrangu kujarti nguniny ngaju. Puju manta mapunikarrku ngananguwurti, wali nyanarti, ngajungu marnanya marlamanku. Marlamanujuwal marna ngaju puju piyirntu mapunikarralany.” ");
INSERT INTO wmt_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Wali partalurnila manyanta jangkumani piyirntu, “Yu. Mapunikarralanyjal marnanta. Pinayungku pajan, mapunikarrkujinyangu marnangurla nyuntunga.” ");
INSERT INTO wmt_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Nyanartijangka warriyanani palunyanangurla yalartiwarntingurni, jarlula palu pajajarrinyani piyirn. Jesusjula manya nyanya. Nyanartijangka pa warntajpani pirla. “Jarntakpanyjanyanta parringajangka nyuntu pirla. Nyuntuwu marnangu marnana pirlawu. Nyuntu man wangkingajirtakujirnujuwaljaa wangartakujirnujuwal. Ngajirta ngan yarntarni tikiyanta minyartikarti parrikarti. Ngunyipungany marnanta parringajangka minyartijangka pirla.” ");
INSERT INTO wmt_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Nyanartijangka pirla pa papajani mayajinyangu. Parrila pilpilmarni pawujangkala. Nyanartijangka jarntakparnila manyanta pirla parringajangka. Wali wawuljarrinyala pa nyanarti parri yangkala palurla marni kanarlanywarntirlu, “Wali pa pujujarrinya nyanarti parri.” ");
INSERT INTO wmt_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Nyanartijangka ngarrpirtimani parri Jesusju, karrinyukujirnila. Parrila karrinyangurra. ");
INSERT INTO wmt_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Nyanartijangka palu yani ngurrakarti mayarurla kaninykaniny. Japirlyinyala palurlanyanta parriwu ranyjingurni, “Nyapartujangkarlu marnalu pirla jarti jurramani. Ngajirta manpangurla mapunikarrarla pirlangu.” ");
INSERT INTO wmt_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesusju manyanangu marni, “Puju mantanyanta ngarntimanyjarlangurra jutungu, wali nyanarti. Ngarpungu manya pinakarriwujaa marlamanku. Nyanartila manta jurramanku pirla minyartijiliny parringajangkajiliny.” ");
INSERT INTO wmt_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Walimpa kanarlanywarnti piyirnwarnti palunyanta pirriyani Jesuskarti. Yapawarnti palunya kanya Jesuspurru palymanupurru. Wali mapirrikarrajiwarntirlu palunyanangu jarrmarni piyirnwarntiwu nyanartiwarntiwu. “Ngajirta ngantanyanta kanganta yapawarnti Jesuskarti.” ");
INSERT INTO wmt_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jesusju manya pinakarrinya mapirrikarrajiwarnti. Kulijarrinyala manyanangurla mapirrikarrajiwarntiwu tumaj palunya lamakujirnani yapawarnti. Nyantungula manyanangu marni Jesusju, “Ngajirta. Yara pajilurla yankurni ngajukarti yapawarnti. Ngajirta ngantanya lamakuji. Yankurnijalurla ngajungawu yapawarnti. Pinakarrilany pajalu wangki ngajukura yapawarntirlu. Mapunikarralanypala palunyanta Kutta, yangkala manyanangu Kut kajalkajal nguniny yapawarntiwu. ");
INSERT INTO wmt_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Kujartikarra pajanta pinakarriwu nyurrawarntirlu wangki ngajukura mapunikanupurru. Mapunikarrkula mantanyanta Kutta yapajilinyju. Nyanartijangkala kajalkajalparni manyirrangu ngunawu Kut nukarniwu,” marni manyanangu kujarti Jesusju. ");
INSERT INTO wmt_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Nyanartijangka Jesusju manyanangu warrpajparni yapawarntiwu kirrarnungurni. Nyanartijangka palunyanta pirripirriyani. Jatpanurla manya kirrarnukujirnani nyantukurarla jinkarrirla kayanngurla kayanngurla. Nyanartijangkala manya palymanani kurraparlu jurluwarnti kayanngurla kayanngurla ngarntimanukarrarlu. Palymanukarrarlurni parla Ngarpu japirlyungani ngarrurtakujirnupurru yapawarntiwu. ");
INSERT INTO wmt_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Nyanartijangka karlarrara palu yanani Jesusjaa piyirnwarnti mapirrikarrajiwarnti, kanarlanywarnti piyirnwarnti paja mapirrirni. Mayarukarti palu yanani Jurujulumkarti, yangka layi mayaru kaparn karrinyani yini parla Jariku. Wurnarni palu tirrinyyanani mayarurla nyanayirla. Ngajirta palu lamajarrirla. Karlarrara lanirni palu yani. Wali kajalurni pa kirrarnani mayarungurni pakul layi jankajarti. Kakarrangu palunyanta jamurnparni yanani Jesusngurra warntarrirla rirringkirla. Wali kirrarnani nganpayi nyanarti yini Parramayaj. Ngarpu parla nyanartiwu yini parla Timayaj. Ngajirta parla warrkammarnantarla pamarrku jankajawurlu, yarr pa kirrarnani. Kirrarnungurni manyanangurla ngarntimarnani piyirnwarntirla pamarr yungupurru. Pamarr palurla yungani piyirntu tirrinytirrinyyanujangkarlu. ");
INSERT INTO wmt_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Wali jularni palurla nyanartiwarntirlu piyirnwarntirlu yangka palunyanta Jesusju mapirri yanani. Marni palurla, “Kangana marnapanya Jesusju Najuritkarrajirlu.” Nyanartijangka wangki nyanarti takijularnujangka pa jankajawurlu nginyjirrikani. Papajanila parla Jesusku, “Jesus, Tayipitkura, yawiyijarriji yarrwurti.” Minyarti nganpayi Tayipit parla kilakinyankura Jesuskura jarluwarlanyjangka. ");
INSERT INTO wmt_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Jarti palu kanarlanywarntirlu marrkukani. Jarti palurla jarrmarni jankajartiwu. Ngajirta manyanangurla mapunikarrarla jankajawurlu. Juturni parla pawumarnani Jesusku. Marni parla jankajawurlu, “Jesus, Tayipitkura, yawiyijarriji yarrwurti.” ");
INSERT INTO wmt_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Wali Jesuspala lamajarrinya, nyanartijangka ngalaramarnila. Parlipinyala Jesusju jankajarti kirrarnujangka. Marnila manyanangu Jesusju piyirnwarntiwu, “Purpantajilu nganpayi nyanarti.” Nyanartijangka yani palunyanta, marni palurla. “Pa. Turtapungka. Purnkujarri. Ngajirta ngan rayinjarri. Jesusju mangu malany. Nyaku manta.” ");
INSERT INTO wmt_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Jamurn palurla marni piyirnwarntirlu jankajartiwu, tarrapungurlakani parlanyanu pirlangkirr nyantukura. Partalurnila piwu turtapinya. Turtapungurla yani manyanta Jesuskarti. ");
INSERT INTO wmt_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesusju pa japirlyinya jankajarti, “Nyapartukujiwu marnangurla.” Jankajawurlu parla marni Jesusku purlkawu, “Ngajirta. Mil pajan wulyukujiwu.” ");
INSERT INTO wmt_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesusjula parla marni jankajartiwu, “Kaj, yanta. Nyuntu man wulyujarrinya. Mapunikani pajan ngaju yangkala man wulyujarrinya.” Nyanartijangkala partalurni manya nyanya piyirnwarnti pujurni nganpayirlu. Nguwa mapirri nyanya. Nyanartijangkala Jesuspala wajilpinya wurnarni.");
INSERT INTO wmt_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1"," Wali mayarungurni Jurujulumngurni kakarrara pila ngunangani kurrinywarlany mayarujarra lamparnjarra yinijarra Pipayijijaa Pijani. Pamarra pila ngunangani kakarrangukakarrangujarti rirringkirla. Pamarr nyanarti yini parla Yalapjarti. Pirriyani palu ngurrajarrarla Jesusjaa mapirrikarrajiwarntijaa kanarlanywarnti piyirnwarnti. Yanani palu Jurujulumkarti. Kaparn palu jatparamarni warntarrirla mayarujarrarla. Nyanayirla pilangu marni nganpayijarrawu mapirrikarrajijarrawu Jesusju wangki takurryanupurru mayarurla. ");
INSERT INTO wmt_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Marni pilangu Jesusju, “Yantapila nyanawurlurra mayarurlurra warntarrirlalparni. Yanungurla manpila parlipungku tangki. Karrpirnujangka karrinyana. Nyanarti pa ngurrpangurrpa, ngajirta parla pinarri jarnakangupurru. Wali kurtajpankula manpila. Tikirrkangku pajinpila mirnu.” ");
INSERT INTO wmt_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Kujarti pilangu marnani Jesusju, “Puju manpilangulu malku ngananguwurti, ‘Nganapurru manpila kurtajpanany nyanarti tangki,’ wali julawu manpilanyanangu, ‘Ngajirta. Kangku pajarrarla majawu nyantukurawu. Warrkamjangkarlu pa partalurni tikirryipawu.’” Kujarti pilangu marnani Jesusju mapirrikarrajijarrawu wangki pikawurra. ");
INSERT INTO wmt_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Wali nyanartijangka jakarni pila wangkijarti Jesuskurajarti warntarrirlal, pirriyanila pila ngurranga. Parlipinyala pila tangki nyanarti. Jarlu palu karrpirni mananga. Karrinyani pa warntarrirla marnparni mayarurla kiyitta. Wali jamurn pila kurtajpani tangki, ");
INSERT INTO wmt_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","japirlyinya palupinya piyirnwarntirlu karrinyujangkawarntirlu, “Nganapurru manpila kurtajpanany tangki nyanarti.” ");
INSERT INTO wmt_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Jangkumanila pilanya, “Ngajirta. Kangku pajarrarla majawu nyantukurawu. Warrkamjangkarlu pa tikirryipawu partalurni.” Marnila pilangulu karrinyujangkawarntirlu, “Kaj, kangkapila.” ");
INSERT INTO wmt_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Nyanartijangka tikiyanila pila, kanya pilanyanta tangki Jesuskarti. Jamurn pila pirriyani tangkijarti, wurnarni palu kurtajkurtajpani karrkintajangka mana pirlangkirrjilinyparni mapirrikarrajiwarntirlujaa kanarlanywarntirlu. Palpungala palunyanta pulpulpinya tangkinga pikawurra Jesus kirrarnupurru. Jesuspala parayani, kirrarnanila jarnaka tangkinga. ");
INSERT INTO wmt_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Nyanartijangka kanarlanywarntirlu piyirnwarntirlu palu kurtajpanani pulpungupurru nguwangal warntarrirlal, yangkala tangki yanani puwullal pulpungujangkarlal. Kanarlanywarntirlu palu junganani manajangka jaljarr yangkala palu warntarrirlal tarrapungani jaljarr. Tangki manyanta yanku puwullal warntarrirlal. Kujarti palu ngunangani piyirnwarnti Juwujwarnti yangka palunya piyirn kajalkajalkujirnani. Kujarti palunyanangu pulpungani. ");
INSERT INTO wmt_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Wali kajalurni palu yanani warntarrirlal piyirnwarntiwarlany. Jesus pa yanani kaparnwarlany, kanarlanywarnti wartangurni palu yanani. Piyirnwarnti pujurni palu pawupawukarra yanani ngarrurta. Parrayiparrayi jularnani palurla, “Nyuntu man purlka Ngarpu. Wirriya marnalu nguniny. Minyarti Jesus manpanya yinya takingu, yangkala marnalunyanta nyantunga ngurtnguniny.” ");
INSERT INTO wmt_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Wali nyanartijangka layimirri Jesus pa kirrarnani mayarurla Timpulla, tirrinyyanani palu nganpayiwarntijaa marninwarnti. Yutukanani palurla pamarr Ngarpuwu, ngurtinga palu pamarrpurrurla takurrpungani wurnangu. Nyanganila manya Jesusju kirrarnungurni. Wali kanarlanywarntirlu purlkajartiwarntirlu pamarrjartiwarntirlu palu takurrpungani pamarr purlka. ");
INSERT INTO wmt_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Nyanartijangka layingu kalkarrarlu takurrpinya pamarrjarra kurriny kurnkurnjarra. Ngajirta pamarr purlka martarla kalkarrarlu nyanawurlu. ");
INSERT INTO wmt_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jesusjula manya nganpayiwarnti mapirrikarrajiwarnti marurrpinya. Marnila manyanangu Jesusju, “Mapunparni kalkarrarlu minyawurlu purlka takurrpinya. Kanarlanywarntirlu nukarnirlu palu lamparn takurrpinya. ");
INSERT INTO wmt_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Yangkartiwarntirlu pamarrjartiwarntirlu palu yutukani purlkajawurlu, pamarr purlka palu kirli martarnani. Marnintu minyawurlu yutukani lamparnjawurlu, pujurni pa yutukani pamarr nyantukura. Yungungurla pa pamarrngajirta nguniny, pamarr ngajirta pa martarla miyiwu warntarnupurru.”");
INSERT INTO wmt_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Wali pinalkarrapurru pinyalu ngarnani miyijaa kuyi piyirnwarntirlu pujungurni Juwujwarntirlu. Minyarti kuyi pa kukunja lamparn yarnta miyi pa pulawa yiyijngajirta. Kujarti palu pinapinakarrinyani nyapartukarra jarlu Ngarpungu manya kanya Yijipjangka. Kumantawarlanyja pa ngarnuwu miyijaa kuyi pinalkarrapurru. Wali nganpayiwarnti kurayipwarntijaa puriswarnti palunyanta mulkarra ngunangani Jesusja warntarnurla pungupurru, ranyjingu palu warntarla Jesus. ");
INSERT INTO wmt_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Marnani palu, “Kayan ngarlipa Jesus warnta tampi miyingajaa kuyinga pinalkarrapurrurla. Piyirnwarnti ngarlipangulu kulijarri, pungka ngarlipanyalu.” ");
INSERT INTO wmt_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Walimpa yani Jutaj Yijkarriyat yangkartiwarntikarti piyirnwarntikarti puriswarntikarti. Yani pa Jutaj. Jesus manyanangurla pirtinyikarrku pungupurru. Jutaj minyarti pa nganpayi Jesuskurajangka mapirrikarrajiwarntijangka. Wangki manyanangu jularni piyirnwarntiwu puriswarntiwu, yangkala wirriyajarrinya palu Jutajkurajangka wangkijangka. ");
INSERT INTO wmt_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Wangki manyanangu jularni. Jurrmartakani palu. Marni palurla Jutajku, “Puju marnanpangu Jesus pirtinyikarrku, pamarr marnantalu yungku.” Nyanartijangka kujalarnipurru pirtinyikanupurru Jesus pa jarranyangani Jutajju. ");
INSERT INTO wmt_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Wali jamurnjamurnjarrinyani parla kuyiwujaa miyiwu. Kukunjawarnti lamparnwarnti palunya pungani. Jesuspala palu japirlyinya mapirrikarrajiwarntirlu, “Wanyjurla marnalu pikakujiwu kuyijaa miyi.” ");
INSERT INTO wmt_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Jesusjula pilangu jularni nganpayijarrawu, “Yantapila tawunkarti. Pirriyankula manpilarla layiwu nganpayiwu, ngapa pa kangana pikala. Puju manpila parlipungku, mapirrirnila manta yanku kirninyja. ");
INSERT INTO wmt_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Puju yangka mayarurla takurr yanku pikalajarti, wali japirlyungku manpila nganpayiwarlany nyanartikarraji mayarukarraji. Kujarti manpila japirlyungku, ‘Minyarti wangki pa pinayungujuwalkura. Malany mangu, wanyjarrarla marnalu ngalku kuyijaa miyi pinalkarrapurru ngajungujaa mapirrikarrajiwarntirlu.’” ");
INSERT INTO wmt_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Jesusju pilangu juturni marni, “Minyartijangka wangkijangka manypinya kangku mayarurlurra kaninykaniny. Nyanayirlajal manpila parlipungku pikakujirnujangka. Wali nyanayirla marnanpangupila kuyijaa miyi pikakujiwu.” Kujarti pinya jinjinyinya Jesusju nganpayijarra mapirrikarrajijarra, yiparnila pinya Jesusju wangkijarti. ");
INSERT INTO wmt_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Wali nyanartijangka jakarni pila nganpayijarra. Yani pila tawunkarti. Jirrkirljinyangu pilangu jarlu marni Jesusju. Kujartirnila pila parlipinya jirrkirlparni. Pikakujirnila pila kuyijaa miyi. ");
INSERT INTO wmt_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Karuwarrarla rarrpangarni palu yani Jesusjaa mapirrikarrajiwarnti ngarnupurru. ");
INSERT INTO wmt_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Yangka palu kirrarnungurni ngarnani, wali Jesusju manyanangu marni, “Layingujal paja pirtinyikarrku pungupurru minyayirlajangkarlu ngarnujangkarlu.” ");
INSERT INTO wmt_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Yawiyijarrinyala palu. Layingu parla marni, “Kayan ngarnanta ngajungu pirtinyikarra. Kanarlanywarntirlu mantalu pirtinyikarrku.” Nyanartijangka palurla kujarti marni nukarnirlu. Kayanngurla kayanngurla palurla marni. ");
INSERT INTO wmt_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Wali marnila manyanangu Jesusju, “Layingu paja pirtinyikarrku, minyayirla parlipangurla kirralany mapirri kayanta. Ngurtinga pulayitta pajarla jurrpkujilany miyi.” ");
INSERT INTO wmt_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Yangka palu warrarni miyi ngarnani, Jesusju miyi warntarni pulawa yiyijngajirta. Warntarnurla parla marni Ngarpuwu. Miyi junganujangka manya yinya piyirnwarnti, marnila manyanangu Jesusju, “Warnta. Minyarti miyi paji karrkin ngajuwu.” ");
INSERT INTO wmt_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Yarntarni Jesusju pakirti warntarni. Yarntarni parla Ngarpuwu marni wurupurru. Nyanartijangka manya yinya, ngarnila palu pakirtijangka nukarnirlu. ");
INSERT INTO wmt_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Jesusju manyanangu marni, “Minyarti wuru paji nungu ngajuwu jurrmartajangka Ngarpukurajangka. Purtantiwu manyirrangu pajawu piyirnku ngajukurajangka nungu. ");
INSERT INTO wmt_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Mapunparni. Kayan ngarna wuru linyngurru kujartijiliny yarnta nganyja minyayirla. Yarntawarlanyja marna ngalku kanarlanyparni Ngarpungajangka.” ");
INSERT INTO wmt_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Wali yinparni palu juju. Turtangurla yanila palu kakarrara pamarrkarti. Pamarr nyanarti parla yini Yalapjarti. ");
INSERT INTO wmt_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jesusju manyanangu marni wurnangu, “Wanyjarrkujal pajanta. Laparnkarrakangku manta.” Yarntarni manyanangu marni kurrumparlajangka Jesusju, “Kujartila pa nguniny kurrumparla Ngarpukurarla. Ngarpungu pa pungku ngampurrji, kukunjawarntila palu lurrplurrp yanku. ");
INSERT INTO wmt_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Yangka paja wanjikujiwu pirlajangka, yankula marnanyirrangu kajalurni Kalalikarti. Wartangurni pajinta pirriyanku Kalalirla.” ");
INSERT INTO wmt_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pitangu parla marni Jesusku, “Kayan ngarnanta wanyjarra ngajungu. Kunyungurla mantalu kanarlanywarntirlu wanyjarrku nukarnirlu, kayan ngarnanta ngajungu wanyjarra.” ");
INSERT INTO wmt_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesusju parla marni Pitawu, “Mapunjinyangu marnangu julalany. Wali pajan nginyjirrikarrku pukanyja jalarra, yangkala pajan rayintu murrkurnmirri kanginypungku. Nyanartijangkarlu pawul man pinakarrku kurrinymirri.” ");
INSERT INTO wmt_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pitangu manyanta nurrurrurlu jangkumani, “Pujuwurti manyanangurla pirlajarriwu nyuntungarni, wali kayan ngarnanta rayintu kanginypungka. Nginyjirrikanurla kayan ngarnanta kanginypungka ngajungu.” Kujarti Pitajilinyju palurla Jesusku marni piyirnwarntirlu nukarnirlu. ");
INSERT INTO wmt_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Nyanartijangka pirriyani palunyanta wurrkalkarti yinikarti Kijiminikarti mapirrikarrajiwarntijaa Jesus. Marni manyanangu Jesusju, “Kirranyjalu minyayirla. Purayimalku marna. Wangki marnarla malku Ngarpuwu.” ");
INSERT INTO wmt_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Wanyjanila manya wartangurni kanarlanywarnti. Minyarti murrkurn manya kanya Pitajaa Jayimjijaa Jun. Jesuspala yawiyijinyangujarrinyajaa karrartajarrinya. ");
INSERT INTO wmt_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Marni manyanangu, “Munta marna yakurrjarrinya. Jamurn marna pirlajarrirla yawiyijangka. Minyayirla jurumantajilu, warrpunyangantalu.” ");
INSERT INTO wmt_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Jesus yanila manyanangurla nganpayiwarntingurni, parntawantinyala nguwanga, purayimarnanila. Ngarntimanani manyanta Jesusju Ngarpunga, “Ngarpu. Ngungkupungana marnanyanu munta kaninykaniny, wirriyangajirta marna yanupurru. Ngajirta mangu nganawurti nyuntuwu tanyji, nganawurti ngajirta mangu majajarri. Warntawu pajanurla minyarti yawiyi ngajungajangka, puju man nyunturni wulyumalany.” ");
INSERT INTO wmt_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Nyanartijangka Jesus manyanangurla tikiyani nganpayiwarntikarti murrkurnkarti. Nyantuwarnti manyan palu yukarnani kajaluwarlany. Marni parla Pitawu, “Jayimin. Manyanjarrinya ngan. Ngajirta pajin warrpunyangantarla parnkingu. Partalurni ngan manyanjarrinya.” ");
INSERT INTO wmt_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Yarntarni Jesus yani purayimarnukarti. Purayimarni pa wangki kirlirni. ");
INSERT INTO wmt_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Yarntarni manyanangurla tikiyani murrkurnkarti. Yarntarni manya parlipinya manyanjangka. Mil purtuly palu ngunangani manyanjartijinyangu. Kurntayijarrinyala palu, ngajirtala palu Jesus jangkumantarla. ");
INSERT INTO wmt_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Yarntarni manyanangurla pirriyani yangkartiwarntirlarni purayimarnujangka. Yarntarni manya manyanjinyangu nyangurramarni. Marni manyanangu, “Warrarni manta manyan yukarnana. Wali manta yukarnani rawa. Jamurnparni paji kutajarrinya, pirtinyikarrku paja. Yakurrwarntirlu piyirnwarntirlu pajalu tartpartawu. ");
INSERT INTO wmt_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Pa. Turtangkalu. Yankurlipa. Nganpayi yangkarti paji pirriyani, pirtinyikarrkula paja.” ");
INSERT INTO wmt_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Nyanartijangka Jutaj manyanta pirriyani Jesusja wangkingarni. Jutaj yangkarti mapirri manyanangurla nguja miyinga mapirrikarrajiwarntirla. Purlkawarntirlu palunyanta Jutajja yiparni kanarlanywarnti piyirnwarnti kuturujartiwarntijaa nayipjartiwarnti purpanupurru. Minyartiwarnti purlkawarnti palu nguja puriswarntijaa kurayipwarntijaa piyirnku majawarnti. ");
INSERT INTO wmt_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Wali jarlu manya lirrkarnpinya Jutajju. Marni manyanangu, “Puju marna ngukupajarrku nganpayi yangkarti, wali nyanarti nyantu. Wartangurni manta tarrpartawu. Ngajirta nganta yartajpanta, nurrurrurlu manta tarrpartawu.” Wali Jutajju manyanangurla jarlu wangki pikakujirni. ");
INSERT INTO wmt_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Partalurni manyanta Jutaj yanungurla pirriyani Jesusja, marnila parla Jutajju, “Purlka.” Jutajjula ngukupajani. ");
INSERT INTO wmt_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Nyanartijangka palu Jesus warntarnurla tarrpartarni. ");
INSERT INTO wmt_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Karrinyujangkarlurnila layingu piyirntu manyanu ruwarramani nayip juwal, junganila marnparni nganpayi karrinyujangkawarlany. Pina rulany jungani. Nyanarti piyirn pina junganujangka parlanyanu martarnani warrkampurru purlkangu Purisju. ");
INSERT INTO wmt_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesusju manyanangu marni, “Nayipjartiwarnti juwaljartiwarnti pajantarla pirriyani ngajunga kuturujartiwarnti. Pirriyani pajantarla warntarnupurrujaa tarrpartarnupurru. Ngaju marna ngajirta ngurriji. Nyapartujangkarlu pajanta warntawu nayipjawurlujaa kuturujawurlu. ");
INSERT INTO wmt_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nira marna ngunangani Timpulla. Pinayungani marnanya kumantawarlany kumantawarlany, yangkala pajanta ngajirta warntarla. Nyanartikarra marna palkangarni nguja. Wali wangki nguniny ngirrpirirla kurrumparla, nyanayirlalparni kirlingal wangkijilinyjal pajanta warntalany. Jamulu marnanyanu pikayungku wangkijangkarlaljal.” ");
INSERT INTO wmt_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Nyanartijangka palu murtarni laparnkarranya maya nukarnini mapirrikarrajiwarnti yap nyangurla. Wanyjani palu Jesusmipa karrinyujangka. ");
INSERT INTO wmt_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Pingkayirlu nganpayirlu layingu Jesus jartamani. Piyirnwarntirlu palu tarrpartarni nyantu kangupurru. Pingkayi nyanarti pa palyajarti. Palyamipa pa kangani ngilykinga karrpirnujangka, palyajartirnila palu tarrpartarni. ");
INSERT INTO wmt_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Yulajpani palunyanta palya piyirnwarntirlu, laparnkarranyala pupuru pingkayi kurtangarri rayin. ");
INSERT INTO wmt_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Nyanartijangka Jesus palunyanta kanya nganpayikarti purlkakarti Puriskarti. Yijingkanya palunyanta. Nyantuwarnti palu kirninyjajarrinya Juwujwarntiwarlany. Puriswarntijaa piyirnku majawarntijaa kurayipwarnti palu kirninyjajarrinya. ");
INSERT INTO wmt_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Wartangurni yanani juturni marringurni Pita. Purlkakurakarti mayarukarti manya wajilpungani wartangurni, kitangarni manyanangurla pirriyani wartangurni mayarurla purlkakurarla. Warlunga manyanangurla kirniny yani. Makurru kirrarnani. ");
INSERT INTO wmt_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Wali jarti palu muwupunganijaa karlayilanani wangkiwu piyirnwarntirlu purlkawarntirlu. Ngajirta palu wangki parlipungkarla ngirtilykarra jularnupurrujaa ngirtilykarra jularnujuwal. Jesus ngulikanurla pungupurru palu parlipungkarla. Ngajirta palu parlipungkarla, jarti palunyanu japirlyinya purlkawarntirlu. ");
INSERT INTO wmt_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ngajirtala palu yirrijiwarntirlu jirrkirlikarrarla. Ngangamarnila palu wangki. Wali ngurrujarra ngurrujarra palunyanangu marni purlkawarntiwu. ");
INSERT INTO wmt_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Wangkiwarlany palu yirrijiwarntirluwarlany warntarnkanya. Turtapungurla palu marni. ");
INSERT INTO wmt_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Nganpayi minyarti marnalu pinakarrinya. Kujarti pa marni, ‘Mayaru minyarti Timpul marna wajapungku yangka piyirntu palu ngartakpani. Nyanartijangkarlu kumantawarlanyja marna mayaruwarlany ngartakpanku yangka piyirntu ngajirta ngartakpanta, wali nyanarti.” ’ Kujartirni palunyanangu minyartiwarntirlu yirrijirlu marni. ");
INSERT INTO wmt_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Wali minyartiwarntirluwurti palunyanangu ngurrujarra ngurrujarrarni marni. ");
INSERT INTO wmt_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Nyanartijangka manyanangurla purlka nganpayi Puris turtapinya, japirlyinyala Jesus purlkangu nyanawurlu, “Pinakarrilany nganunya nyuntungu nyapartukarra mantalu ngirtilykarra jularnana. Wayila. Jangkumanku nganunya. Nyapartukarra mantalu ngirtilykarra jularnana.” ");
INSERT INTO wmt_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Nyantu kulkururni karrinyani Jesus. Yarntarni parla japirlyinya purlkangu nganpayirlu, “Nyuntu ngan nganpayi Kurayij. Kutkura walaku ngartan nyuntu.” ");
INSERT INTO wmt_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","“Yuwayi,” marni parla Jesusju. “Nyaku pajanta kirrarnujangka. Kirralku marnanyanta mayajartirla Ngarpunga mayakarti. Yurnturra pajanta nyaku. Yurnturra marna pirriyanku kankarnumarrangu.” ");
INSERT INTO wmt_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Wali kuluwuj manyanu larrmani purlkangu nyanawurlu kulijawurlu. Marnila manyanangu piyirnwarntiwu, “Wali pawu. Kayan ngarlipanyanangu yarnta muwupungka jakuljularnupurruwarntiwu piyirnwarntiwu. ");
INSERT INTO wmt_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Wanyjarrkurlipanya. Pinakarrinya nganta wangki Jesuskura yakurr. Wayila. Nyapartukarra manta pinakarrilany.” Wali ngulikani palu pirla pungupurru piyirnwarntirlu Jesus. ");
INSERT INTO wmt_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Wali nyanartijangkala palu tarrpartarni. Juwajpanani palunyanta karrkinwarntirla. Kutikani palunyanta janginyja, pinyala palu kurraparlu ngangangapururla. Japirlyinyala palurla, “Nganangu manta pinya kurraparlu piyirntu. Manyjarnanypangu. Nganangu manta pinya.” Tarrpartarnujuwalwarntirlula palu kanya, pinyawarlanyparni palu kanarlanywarntirlu. ");
INSERT INTO wmt_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita warrarni kirrarnani warlunga. Mangala pirriyani warlukarti, parlipinyala Pita. Manga nyanarti pa warrkammayin nyanartikarraji. Warrkammarnani parla purlkawu. Purlka yangkarti palu jularnani nganpayi Puris purlka. ");
INSERT INTO wmt_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Nginyjirringinyjirrikanani mangangu warlunga kirrarnujangka Pita. Marni parla Pitawu, “Nyuntu man mapirrikarrajijangka Jesuskurajangka. Nyuntu mapirri manunyanta ngunangani nganpayirla Najuritkarrajirla.” ");
INSERT INTO wmt_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","“Ngajirta,” marni parla mangawu. “Ngajirta marnarla pinarri ngaju. Ngurrpa marnarla. Ngana partajin jularnana.” Kujarti Pitangu Jesus kanginypinya, pakulyanila pa warlungurni kiyitkarti. Wali pawulpala papajani. ");
INSERT INTO wmt_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Yarntarni pa Pita nyanya, marnila manyanangu mangangu karrinyujangkawarntiwu. “Jesusku parla nyantu mapirri.” Jularnani manyanangu mangangu pajawarlanyku. Yarntarni Jesus kanginypinya Pitangu. ");
INSERT INTO wmt_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Nyanartijangka piyirnwarntirlu karrinyujangkawarntirlu palurla Pitawu marni, “Nyuntujal man Jesusjangka mapirrikarrajijangka, tumaj man nyuntu Kalalijangka Jesusjiliny,” marni palurla. ");
INSERT INTO wmt_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Jularnila manyanu mapunjilinyparni. Marni manyanangu, “Ngarpungu paji pinarri ngajuwu. Mapunparni marna malany. Ngurrpa marnarla nyanartiwu nganpayiwu.” ");
INSERT INTO wmt_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Jamurn Pita wangki marni, nyanartikarrarnila papajani pawul. Jarlurni pa papajani layimirri. Wali Pitangu pinapinakarrinya wangki Jesuskurajangka jarlujangka. Jesusju parla jarlu marni Pitawu, “Nginyjirrikarrku pajan, yangkala pajan rayintu murrkurnmirri kanginypungku. Nyanartijangkarlu pawul man pinakarrku kurrinymirri.” Pinapinakarrinyurla pa luyurrjarrinya, lunganila Pita. ");
INSERT INTO wmt_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Jamurn purangu turtapinya, purlkawarnti palu kirrarnani piyirnwarnti. Puriswarnti kajalkajalwarnti, kurayipwarnti, purlkawarnti Juwujkurajangkawarntijaa wangki yirrikanujuwalwarnti palu kayantajarrinyurla yirrikanani. Nyapartukujiwu palu Jesus. Nyanartijangka karrpirnila palu Jesus, kanyala palu purlkawarlanykarti yinikarti Payilitkarti. Payilit yangkarti manyanangu maja ngunangani piyirnwarntiwu Jurujulumjangkawarntiwu. ");
INSERT INTO wmt_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Wali Payilittu parla Jesus japirlyinya, “Nyuntu nganunyanangu maja Juwujwarntikurajangka.” Jangkumanila parla Jesusju, “Yuwayi, kujarti man malany nyuntungu.” ");
INSERT INTO wmt_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Nyanartijangka ngirtilykarra palurla marnani Jesusku piyirnwarntirlu puriswarntirlu. Wangkiwarnti yakurrwarnti palurla pirripirrikangani. ");
INSERT INTO wmt_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Yarntarni parla Payilittu japirlyinya, “Jangkumanumulu ngan karrinyana. Pinakarrilany manunya nyapartukarra mantalu ngirtilykarra jularnana.” ");
INSERT INTO wmt_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ngajirta pa Jesusju yarnta jangkumantarla, kulkuru pa ngunangani. Payilit parla wampalmarnila kulkurujangkawu Jesusku. ");
INSERT INTO wmt_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","10","Nyanartijangka Juwujwarntirlu palu japirlyinya nganpayi Payilit. “Yulajpanku marnanypangu nganpayi nurtungajangka jayillajangka.” Japirlyinyala manya Payilittu, “Yulajpanku ngarnanyirrangu nganpayi Juwujwarntikurajangka maja, nyantu ngantarla ngurtpalany.” Wali Payilit pinarri manyanangu ngunangani Juwujwarntiwu yurruljangkawu. Yurruljangkarlu palu Jesus tarrpartarni. Wali minyarti pa nyantuwarntikurarlal palu ngunangani Juwujwarnti. Miyi palu ngarnani pinalkarrapurru. Juwujwarntirlu palu japirlyungani miyikarramipa kapuman, “Nyangurla man yulajpanku nganpayi layi jayillajangka.” Nirawarlany nirawarlany miyikarra palu japirlyungani nganpayi Payilit. Yulajpanurlapala yiparnani nganpayi layi jayillajangka. Nyanartiwarnti nganpayiwarnti Juwujwarnti murrkurn palurla jarlu kulijarrinya kapumanku, yangkala pinya palunya piyirnwarnti pirlawurra. Nyanartijangkala palunya takurrpinya jayilla. Nganpayi yini Purapij mapirri palu takurrpinya jayilla kulipariwarntirlu. ");
INSERT INTO wmt_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Wali puriswarntirlu purlkawarntirlu palunyanangu piyirnwarntiwu wangki jirrkirlkujirnani. Lirrkarnpungani palunya, “Kujarti mantarla malku. Kujarti manta japirlyungku Payilit. Layiwu mantarla japirlyungku Purapijku, yulajpankula jayillajangka Payilittu,” marni palunyanangu. ");
INSERT INTO wmt_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Yarntarni manya japirlyinya Payilittu, “Nyapartukarra manta malany. Nyapartukujiwu marna yangkarti yangka manta julalany Juwujwarntikurajangka maja. Nyapartukarra manta malany nyurrawarnti.” ");
INSERT INTO wmt_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Pawupawumarnanila palurla Juwujwarntirlu, “Mananga tarnikarralu. Pirlajarriwu pa manangarni.” ");
INSERT INTO wmt_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Marnila manyanangu Payilittu, “Ngana parla yakurr minyartiwu nganpayiwu. Nganangurni manta pungku.” Yarntarni palu maya papajanani. Pawupawumarnani palu, “Mananga tarnikarralu. Pirlajarriwu pa manangarni kankarni.” ");
INSERT INTO wmt_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Yulajpanila nganpayi Purapij Payilittu jayillajangka piyirnwarnti wirriyakujirnupurru. Wirriyakujirla manya nyanartiwarnti. Nyanartijangka manya yinya Jesus wipjawurlu pungupurru. Wijkarra pinya palu Jesus. Nyanartijangka manya yiparni mananga tarnikanupurru Payilittu. ");
INSERT INTO wmt_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Wali kulipariwarntirlu palu kanya Jesus mayarukarti kaninykaniny kanarlanywarntikarti. Kanarlanywarntiwarlany kulipariwarntiwarlany palu ngunangani mayarurla. ");
INSERT INTO wmt_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Kurtajpani palunyanta kuluwuj ngilykingajangka, yutukanila palunyanta kuluwujwarlany pirljijiliny. Yarntarni janngujiliny palu ngartakpani mana jirijarti jirijarti pampilyijiliny. Jatkajatka palunyanta tarrjakkujirni jurlunga jirijirijarti. ");
INSERT INTO wmt_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Marnani palurla majajilinyku, yangkala palurla warralpungani jingkirrkarra. Kujarti palurla marnani jingkirrkarra, “Nyuntu manunyanangu maja Juwujwarntikurajangka.” ");
INSERT INTO wmt_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Yarntarni manajawurlu palu pungani jurlu, yarntarni palunyanta mirtijurrurnjurrurn wantinyani jingkirrkarra purlkanga, yarntarni palunyanta juwajpungani. ");
INSERT INTO wmt_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Wali jingkirrkangurla palu pujujarrinya. Nyanartijangka palunyanta kurtajpani kuluwuj mana pirljijiliny ngilykingajangka, yarntarni palunyanta yutukani kuluwuj nyantukura. Nyanartijangkarlu palu wurnakujirni tarnikanupurru mananga kankarni. ");
INSERT INTO wmt_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Wali nganpayi layi pirriyani marrijangka Jayimin Jarinikarraji. Wali jinjinyinyala palurla nyanartiwarntirlu kulipariwarntirlu. Marni palurla, “Kangkarla mana Jesusku tarnikanupurru.” Walirnila parla kanya Jayimintu. ");
INSERT INTO wmt_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Kanyala palunyanta pamarrkarti yinikarti Kulkutakarti. ");
INSERT INTO wmt_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Pamarr nyanarti pa kujijiliny jurlujiliny. Wuru mirrijinjarti palurla kanarlanywarntirlu kanya. Yijingkanya palunyanta Jesusja. Ngajirtala nganyjarla Jesusju. ");
INSERT INTO wmt_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Tarnikanila palu mananga. Mana jirijarti palunyanta parrpurupinya. Yangka purangu kankarnijarrinya, nyanartikarra palu tarnikani. Wali mana nyanarti kuluwuj nyanarti palurla rijimanani ngilykingajangka kulipariwarntirlu. Rijimanani palurla wanyjarrarlu nganpayirlu kangku. Manajawurlu kartjilinyjawurlu palurla rijimanani. ");
INSERT INTO wmt_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Kujarti palu lani kurrumparla wangki Jesus ngulikanupurru. “Juwujwarntikurajangka manyanangu maja.” ");
INSERT INTO wmt_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Jesus palu yutukani kaparn mananga. Kanarlany palu yutukani mayakarti ngurriji. Kanarlany palu yutukani jampukarti ngurrijiwarlany. Tarnikani palunya murrkurn. ");
INSERT INTO wmt_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Nyanartiwarntirlu kanarlanywarntirlu palurla jingkirti warralpungani. Marnani palurla, “Nyuntu man yangkarti Timpul wajapungujuwaljaa kumantawarlanyja ngartakpanujuwal. ");
INSERT INTO wmt_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Tikirrkujinyanu pirlajangka, yulajpantanyanu manangajangka.” ");
INSERT INTO wmt_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Yarntarni kanarlanywarntirlu kurayipwarntirlujaa puriswarntirlu palurla jingkirti warralpungani Jesusku. Nyantuwarntirlu rantangangurni palurlanyanu marnani jingkirtikarrarlu, “Walirni pirlajangka manya wanjikujirni piyirnwarntiwarlany, kayan nganyanu nyantungu wanjikuji.” ");
INSERT INTO wmt_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Nyanartijangkarlu marnila palurla Jesusku, “Yangkajal manunyanu yulajpantarlangurra purlkangu. Nyuntungurni manunyanu julalany maja Juwujwarntikurajangka yini Kurayij. Puju manunyanu yulajpanku, nyanarti marnangulu mapunikarrku nyangungurla.” Wali ngurrijijarrarlu mapirrirni pilarla manajarrangurni jingkirti warralpungani. ");
INSERT INTO wmt_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Jamurn purangu kankarnimarrangujarrinya, ruklaparnila munga, nukarni mungajarrinya. Wali pa pukanyjajilinyjarrinya. Wali karuwarrarlurrala pa purangu tikirr parralani. ");
INSERT INTO wmt_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Yangka karuwarrajarrinya, Jesuspala maya papajani, “Kut ngajukura. Nganajangkarlu pajan wanyjani.” ");
INSERT INTO wmt_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Karrinyujangkawarntirlu palu pinakarrinya. “Pinakarrilu,” marni palu, “Papajanana parla Yilayijawu.” ");
INSERT INTO wmt_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Nyanartijangka nganpayi yani, warntarni mana karrpirnujangka palya, yangkala jurrpkujirni ngapanga yininga pinikarla. Palya manyanta karrpirni mananga juwalla. Wali kangungurla manyanta yijingkanya Jesusja lirranga. Marni manyanangu jingkirrkarra, “Warra. Jarranyakurlipa. Kunyungurla Yilayija pirriyanku, yulajpankula manyanta manangajangka.” ");
INSERT INTO wmt_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jesus pa papajani maya, papajanungurlala pa pirlajarrinya. ");
INSERT INTO wmt_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Wali mana karrpirnujangka pa ngunangani palyajiliny mayarurla Timpulla. Rukjarti pa ngunangani. Wali yangka Jesus pirlajarrinya, larrlaparnila mana nyanarti kankarnimarrangungurni kanimparral. ");
INSERT INTO wmt_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Layi nganpayi purlka manyanangu kulipariwarntiwu maja. Langkarnijarti pa karrinyani. Nyangani Jesus kitangarni pirlajarrinya. Pirlajarrinyujangkarla marni, “Mapunparni pa minyarti nganpayi ngunangani Kutkura walaku.” ");
INSERT INTO wmt_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Marninwarnti palu marri karrinyani. Marringurni palunya nyangani. Yinijartiwarnti minyartiwarnti palu karrinyani Mayiri Miktilinjaa Jalayimijaa Mayiri Jayimjiwu parla ngamaji. ");
INSERT INTO wmt_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Marninwarntirlu kanarlanywarntirlu mapirri palunya nyangani. ");
INSERT INTO wmt_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Nira palu Juwujwarnti ngunangani, kamparnani palu karuwarrarla pikawurra. Kumantawarlanyja Jarritirla palu ngarnani miyi. Warrkamngajirta palu ngunangani. Wali karuwarrarla yangkartirla pa yani Payilitkarti Jawujap Yaramatiyakarraji. Nganpayi Jawujap pa purlka Juwujwarntikurajangka. Purnkujarrinya pa. Yanungurla purnkungu japirlyinya Jawujapju Payilit. Marni parla, “Jesus ngarna kangku pirla najikarti.” ");
INSERT INTO wmt_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Payilittu pa pinapinakarrinya, “Kala jarlu ngarta pirlajarrinya.” Nyanartijangkarlu Payilittu parla yiparni wangki purlkawu kulipariwu, pirriyanila manyanta Payilitta kulipari nyanarti. Payilittu parla japirlyinya purlka. “Wayila pirlajarrinya ngarta.” ");
INSERT INTO wmt_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","“Yu,” marni parla purlkangu kuliparirlu. Payilittula parla marni Jawujapku, “Yuwayi. Warnta.” ");
INSERT INTO wmt_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","47","Nyanartijangka yani, warntarnila parla Jawujapju japalyarr parpjarti wulyu. Nyanartijangka manakartila yani, manangajangkala kurtajpani Jesus. Japalyarrjawurlu pa karrpirni. Karrpirnurla kanya parla najikarti, yutukanila kaninykaniny. Pamarr manyanta rukukani. Kurrinyju marninjarrarlu pila yanungurla nyanya naji. Minyartijarrarlu yinijarrarlu pila nyanya Mayiri Miktilintujaa Mayirirlu Jayimjikurarlu ngamajirlu. Najinga pa yutukani Jesus. Kaninyjarti rukukani. Jarlurni pikakujirni pamarr pirlapurru naji. ");
INSERT INTO wmt_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Nyanartijangka kumantala palu turtapinya wiyikja. Jamurn purangu pirmarnani, marninwarnti palu rakarrarlarni yani najikarti pirlapurrukarti. ");
INSERT INTO wmt_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Wurnanga wurnanga palurlanyanu marnani marninwarntirlu, “Nganangu parlipangu pamarr rirripkangku. Pamarr manyanta ruknguniny kirlingirrirla najinga.” ");
INSERT INTO wmt_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Pamarr nyanarti pa purlkajinyangu. Warrpunyanya palurla najiwu. Nyanya palu pamarrngajirta, kirlingirrila palu nyanya. Karrinyani pa pamarr nyanarti marnparni rirripkangujangka. ");
INSERT INTO wmt_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Wali tartayani palu najinga marninwarnti, parlipinyala palu nganpayi layi kirrarnujangka, nganpayi pingkayi parpjartijarti mana juwaljarti kuluwuj kirrarninyirra. Karrartajarrinyala palu marninwarnti. ");
INSERT INTO wmt_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Marni manyanangu pingkayirlu, “Ngajirta nganta karrartajarri. Jesusku mantarla muwupungana Najuritkarrajiwu. Yangkarti palu jarlu mananga tarnikani. Yangka pa turtapinya, ngajirta nguna minyayirla. Nyakalu. Minyayirla palu yutukani.” ");
INSERT INTO wmt_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Yarntarni manyanangu marni pingkayirlu, “Tikiyanku manta, malku mantanyanangu mapirrikarrajiwarntiwujaa Pitawu mapirrirni. Kujarti mantanyanangu malku, ‘Yanku manta Kalalikarti wartangurni, kajalurni pa yanana Jesus, nyakula manta Jesus Kalalirla. Minyarti wangki manyirrangu jarlu marni Jesusju.’” ");
INSERT INTO wmt_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Wali jamurn palu marninwarnti tirrinyyani najijangka, nyanartijangkala palu laparnkarranya pupuru rayin karrarta. Rayin palu laparni, ngajirta palunyanangu jularla piyirnwarntiwu kanarlanywarntiwu. ");
INSERT INTO wmt_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Jarlu pa ngunangani nganpayi Yarrit. Nyantu manyanangu purlka ngunangani king Jutiyajangkawarntiwu. Nyanartikarrarnila ngunangani nganpayi Jakarayi. Nyantu pa puris Ngarpukura. Kanarlanywarnti palu ngunangani puriswarntiwarlany. Nyantuwarntikura warrkam pa ngunangani Ngarpukura ngirrpiri. Warrkammarnani palu mayarurla Timpulla. Minyarti Jakarayi pa ngunangani Payijajarti wangarr. Kujarti palunyanu jularnani kilakiwarntikurajaa jamirtiwarntikura jarlujangka wangarr. Wali Jakarayirlu parlanyanu martarnani kartu yini parla Lijipit. Kurntal parla yinya puriswarlanyjurni lamparrnyankurarlu nganpayi Jakarayi. ");
INSERT INTO wmt_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Nyanartijarra jamirlangu pila wulyujinyangu ngunangani. Ngarpungu pinya nyangani wulyu jirrkirl. Nyantujarrarlu pila pinakarrinyani Mujijkura luwu jarlujangka jutungurni. Ngajirta pilanyanta rukanyjarla. Nyanartijangkala pila mapunikanani. ");
INSERT INTO wmt_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Lijipittu ngajirta yapa martarla. Yarr pila kirrarnani yapangajirtajarti. Purrkujaa parnanyjarrinyala pila. ");
INSERT INTO wmt_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Layimirri Jakarayijaa puriswarntiwarlany palu warrkammarnani mayarurla Timpulla Payijakarrajartiwarnti. Kumantawarlany kumantawarlany palu warrkammarnani. ");
INSERT INTO wmt_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Puriswarntirlu palurlanyanu yirrikanungurla kurajpinya nganpayi Jakarayi. Marni palurla, “Nyuntu manurla takurryanku Timpulla Ngarpuwu. Pirninpaljiliny manurla warlunga yutukarrku.” Wali nira palurlanyanu puriswarntirlu layi kurajpungani kujarti yitilalwarlany yitilalwarlany warrkampurru. Wali takurryanila mayarurla kaninykaniny Jakarayi. Kanya parla pirninpaljiliny warlunga yutukanupurru pamarra paljarra. Lurnturumarnankula parla Ngarpuwu ngunyjurr. Purayijilinyparni manyanta tirrinyyanku Ngarpukarti kankarral. ");
INSERT INTO wmt_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Nyanartikarrarni palu piyirnwarntirlu pajangu japirlyungani Ngarpu karrinyungurni palkangurni. Kujartikarra palu nira purayimarnani ngunyjurrjawurlujaa lirrangu. Nukarnirlurrarnila kayantajarrinyurla manyanangurla tirrinyyanku wangki Ngarpukarti ngunyjurrjilinyparni Jakarayikurajangkajaa karrinyujangkawarntikura. ");
INSERT INTO wmt_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Jamurn parla Jakarayirlu pirninpaljiliny yutukarrarla kaninykaniny, yinjilpala nyanya Ngarpukura kurlilanyjarti karrinyujangka. ");
INSERT INTO wmt_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Pilpilmarnila karrarta Jakarayi nyangujangka. ");
INSERT INTO wmt_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Marni parla yinjillu, “Jakarayi. Ngajirta ngan karrartajarri. Wangkijarti marnangu pirriyani. Ngarpukura marnangu julawu. Pinakarrinya manta japirlyungujangka Ngarpungu, nyanartijangka mangu yawiyijarrinya. Kartungu nyuntukurarlu mangu martawu Lijipittu walaku. Yinila man julawu Jun. ");
INSERT INTO wmt_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Wirriyajarriwula manurla nyanartingurni. Yarnta kanarlanywarnti mapirri palurla wirriyajarriwu yangka pa yapa palkangawantiwu. ");
INSERT INTO wmt_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Nyanartijangka yinjillu parla marnani Jakarayiwu wangki pika, nyapartukarra pa ngunanganku nyantukura walaku. Marni parla Jakarayiwu, “Walimpa yangka yapa purlkajarriwu, nganpayi wulyu pa nyanganku Ngarpungu. Ngajirta ngan yungka ngapa wayinjaa kanarlanywurti ngapawarlany kulipari nyuntukura walaku. Muntangajangkarla manyanta Pirlurr Ngarpukurajangka takurryanungurla ngunanganku yapanga. ");
INSERT INTO wmt_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Yarntarni marnangu julawu walimpapurru pikawurra wangkiwarlany. Nyuntukurarlu walakurlu manyanangu jularnanku Ngarpukurajangka wangki piyirnwarntiwu pajawu Juwujwarntiwu. Tikirrkujiwula manya Ngarpukarti. Ngarpula manyanangu ngunanganku maja. ");
INSERT INTO wmt_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Nyuntukura walaku manyanangurla kajalurni yanku, wartangurnila manyanta kanarlany pirriyanku. Wali jarluwarlany nguja Ngarpukura puraput Yilayija. Nyantungu manyanangu jularnani piyirnwarntiwu purnkungu mayajawurlu Ngarpukurajawurlu. Wali narangalparni manyanangu jularnanku nyuntukurarlu walakurlu Yilayijajilinyju purnkungu.” Yarntarni parla yinjillu marni, “Wali nyuntukurarlu walakurlu manya lirrkarnpunganku piyirnwarnti. Nyanartijangka palunyanta tikiyanku Ngarpukarti, yarnta palunyanangu nganpayiwarntirlu yawiyijarriwu walakuwarntiwu. Wulyuwulyula palu ngunawu. Yarntarni marnangu julawu. Nyuntukurarlu walakurlu manyanangu jularnanku piyirnwarntiwu Ngarpu panypungujuwalwarntiwu. Kurnakkujiwu manya wangkijawurlu. Pinarrijartila palu ngunawu mapunjiwarntijiliny. Wali kujartikarra manyanangu nyuntukurarlu walakurlu pikakujiwu piyirnwarnti. Wartangurniwarlany manyanangurla pirriyanku purlka.” Wali lamajarrinyala yinjil wangkijangka. ");
INSERT INTO wmt_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Nyanartijangka Jakarayirlu parla marni, “Nyapartukarrarlu marnanta mapunikarrku. Ngurrpa marnarla wangkiwu nyuntukurawu. Kayan ngajarra yapa marta purrkungujaa parnanyju.” ");
INSERT INTO wmt_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Yinjillu parlanyanu jularni, “Ngaju marna yini Kayipil. Ngarpu paji maja. Nira marna nyantu mapunikarralany. Wali nyantungu paja yiparni nyuntukarti wangkijarti wulyujarti. ");
INSERT INTO wmt_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Wali wangki minyarti marnangu takijularni, ngajirta pajan mapunikarrarla. Wangkingajirtajartila man ngunawu. Walimpa man yarntarni malku, yapaliny palkangajarriwu.” Wali lamajarrinya yinjil wangkijangka. ");
INSERT INTO wmt_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Wali piyirnwarntirlu palurla palkanga jurumanani Jakarayiwu japirlyungujangkarlu. Marnani palurlanyanu, “Nyangurla parlipangurla nganpayi Jakarayi pirriyanku. Kaninykaniny pa rawajinyangu karrinyana.” ");
INSERT INTO wmt_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Wali Jakarayi manyanangurla pirriyani kaninykaninyngurni palkakarti. Jarti parlanyanu kurlpinya marnupurru wangkiwu. Kurraparlu manyanangu jirnapungani, “Kayan ngarna manyja, lirra ngajukura patanyjajarrinya.” Nyanartiwarntirlu palurlanyanu marni, “Nganaparta nyanya kaninykaniny minyajal kulkuru pirriyani. Kunyungurla pa winkirrjangka.” ");
INSERT INTO wmt_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Wali nyanartijangka Jakarayi pa warrarni warrkammarnani mayarurla Ngarpukurarla kulkururlurni kumantawarlany kumantawarlany kitangarni pujumani. Nyanartijangka wurnala tikiyani ngurrakarti. ");
INSERT INTO wmt_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Kirrarnanila pila lama nyanayirla. Walimpa muntajartijarrinyala Lijipit. Nyanartijangka kaninykaninymipala kirrarnani ngurranga yakarnwarntirla murrkurnta 5ja. Ngajirta kitpungantarla palkangal. ");
INSERT INTO wmt_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Lijipittu parlanyanu marnani, “Ngarpungu paji walimpawarlany yawiyijarrinya parnanyku, nyanartila paji yiparni yapa. Wali wulyula marna nguniny wirriya. Jarlu marna kurntayikarra kirrarnani yapangajirtajarti, jalarra ngajirta marna kurntayikarra kirranyja. Wirriya marna nguniny.” Wali kujartikarra palu marninwarnti ngunangani Juwujwarnti jarlu. Puju palu yapa ngajirta martarnantarla, wali kurntayijarrinyani palu. ");
INSERT INTO wmt_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","Walimpa yangka Lijipit warrarni kirrarnani muntajarti, Ngarpungu manyanta yinjil yiparni marninkarti wangkijarti Mayirikarti. Marnin nyanarti pa kirrarnani mayarurla Najuritta Kalalirla. Ngajirtarni palunyanta ngurrangakujirla ngumparnarla, warrarni parla purnta ngunangani nganpayiwu Jawujapku. Nganpayi Tayipit jarlujangka kilaki parla Jawujapkura jirnajangka. Wali Mayiri parla purnta ngunangani warrapurru Jawujapku. ");
INSERT INTO wmt_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Wali pirriyani parla Mayirikarti yinjil kankarnumarrangu. Ngarpungu parla yiparni Mayirikarti yinjil nyanarti yini parla Kayipil. Marnila parla Mayiriwu, “Yu, Ngarpu mangu wirriya nguniny. Nyantu mantarla purlka nguniny nyuntunga.” ");
INSERT INTO wmt_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Marnin nyanarti pa tuputupu ngunangani munta kaninykaniny wangkijangka. Pinapinakarrinya pa, “Nyapartukarra paji kujarti marni yinjillu.” ");
INSERT INTO wmt_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Yinjillu parla marni, “Ngajirta ngan karrartajarri Mayiri. Ngarpungu manta kurajpinya, tumaj mangu wirriya nguniny. ");
INSERT INTO wmt_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nyuntungu man martawu yapa. Yapa pa nyanarti ngunawu parla Ngarpuwu, Kutkura walaku. Nyuntungu man martawu, yinila man julawu Jesus. ");
INSERT INTO wmt_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Nyantu pa purlka ngunawu. Julawu palu Ngarpukura walaku kajalkajalkura. Ngarpungu pa majakujiwu kingkujiwu Tayipitjiliny nyantukurajiliny kilakijiliny yangka manyanangu Juwujwarntiwu ngunangani king jarluwarlany. Nyanartijilinywarlanyparnila Ngarpungu majakujiwu. ");
INSERT INTO wmt_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","King manyanangu ngunanganku Juwujwarntiwu. Kujawurlurra manyanangu ngunangurla ngunawu purlka.” ");
INSERT INTO wmt_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Wali nyanartijangka nyantungula parla marnintu marni, “Ngajirta paja nganpayirlu kangkarla, nyapartukarra marna minyarti yapa martawu ngumparnangajirtajawurlu.” ");
INSERT INTO wmt_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Marnila parla yinjillu, “Ngajirta. Tartayanku mangurla Pirlurr Ngarpukurajangka, yangkala man yapa nyanarti martawu ngirrpiri. Yapa palu julawu Kutkura walaku. ");
INSERT INTO wmt_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","37","Nyuntukura jarntujinyangu jalarra kirrarnana Lijipit muntajarti parnany. Walaku pa martarnana muntanga jarlujangka yakarnwarntirla 6ja. Marnani palu kanarlanywarnti kayan ngarta yapa marta. Wali pa Ngarpu wulyujinyangu yungujuwal. Waliwurti parla yarr yinya yapa.” ");
INSERT INTO wmt_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Marnila parla Mayirirlu, “Yu. Ngarpuwu marnarla purlkawu mapunikarralany jalarra wangkingarni. Wali pirriyanku pajirla Pirlurr Ngarpukurajangka, jamulu takurryankujirla jalarra.” Nyanartijangka yinjillu wanyjani Mayiri. ");
INSERT INTO wmt_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Nyanartijangka wurnala jakarni Mayiri wartangurni kurlirra. Jarntukarti manyanta yani Lijipitkarti. Pamarrwarntirla Jutiyarla pa kirrarnani kurlirra. ");
INSERT INTO wmt_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Lanirni pa yani kitangarni manyanta pirriyani ngurranga Lijipitkurarla. Takurryanila, marnila parla parnanyku, “Yu, pirriyani marnangu najanu.” ");
INSERT INTO wmt_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Jamurn pa wangki pinakarrinya Lijipittu, yapa nyantukura jarntakparni kaninykaniny muntangajangka wirriya. Nyanartikarrarnila manyanta Pirlurr Ngarpukurajangka takurryani Lijipitta. ");
INSERT INTO wmt_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Nyanartijangka parla Lijipittu marni Mayiriwu mayangu wirriyarlu, “Nyuntu manta Ngarpungu witparni kurajpinya kanarlanywarntingurni marninwarntingurni layimipa. Nyanarti yapa yangka man walimpa martawu Kuttu parla wulyumalku. Marulu parla Kutku ngunawu parri nyanarti.” ");
INSERT INTO wmt_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Yarntarni parla marni Lijipittu, “Nyuntu man kurajpungujangka wulyu marnin. Ngamaji manurla ngunawu purlkakurawu Kutkurawu. Wali pirriyani pajin, wirriyakujirnila pajan ngaju. ");
INSERT INTO wmt_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Yangka pajin marni pirriyanujangkarlu, wali ngungkupinya marnanyanu yapa jarntakparnujangka muntangajangka. Kunyungurla pajirla wirriya jarntakparni. ");
INSERT INTO wmt_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Yangka yinjillu mangu marni Ngarpukurajangka wangki yapa martarnupurru, wali murtarnila manurla mapunikani wangkijangkarla takijularnujangkarla. Nyanartijangka manta wirriyakujirnila Ngarpungu.” ");
INSERT INTO wmt_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Nyanartijangka Mayirirlu parla parrayiparrayi jularnani. Kujarti parla marni, “Ngajungu marna Ngarpu kajalkajalkujilany. ");
INSERT INTO wmt_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Wirriya marna nguniny Ngarpungurni wanjikujirnujuwalngurni. ");
INSERT INTO wmt_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Nyangungurla paja jarluwarlany junpinya, ngajirta purlka, yarr warrkammayin. Wali julawu pajalu piyirnwarntirlu wirriya, nyanartijangka jirnanyunguwarntirlu pajangu mapirrirni pajalu jularnanku wirriya, ");
INSERT INTO wmt_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","nyapartukarra paja nyantungu kurajpinya minyartipurru lamparnpurru martarnupurru. Nyantu pa mapun ngirrpiri Kut.” ");
INSERT INTO wmt_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Yarntarni parla jularni Mayirirlu, “Ngarpu manyanangu yawiyi nguniny piyirnwarntiwu yangka palurla Ngarpuwu mapunikarralany, yarnta manyanangu jirnanyunguwarntiwu yawiyi nguniny. ");
INSERT INTO wmt_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ngarpu pa mayapari purlka. Kajalkajaljuwalwarntirlu piyirnwarntirlu palu jarti kurlpungani, nyantu pa marrirni mayapari. ");
INSERT INTO wmt_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Purlkawarnti manya kaninykujirnani, warrkammayinkujirnani manya. Yarnta warrkammayinwarnti manya kankarnikujirnani, kajalkajalkujirnani manya Ngarpungu.” ");
INSERT INTO wmt_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Yarntarni parla jularni Mayirirlu, “Yangka palu ngunangani marranyanjarti marlaljarti, Ngarpungu manya yinya wulyuwarnti, wali kinkijartila palu nguniny ngurt. Yangka palu kanarlanywarnti ngunangani pajajarti, Ngarpungu manyanangurla warntarni, wali marlaljartila manya wanyjani. ");
INSERT INTO wmt_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Jarlu parlipangu kilakiwarntiwu ngalimpakurawarntiwu kajalunypawarntiwu takijularni marlamanupurru Ngarpungu, walimpawarlany manya mapunparni marlamani Juwujwarnti. ");
INSERT INTO wmt_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ayiparan pa ngampurrikanani, yawiyijarrinyani parla. Yarnta yapa jirnanyunguwarnti Ayiparankarrajangkawarnti manya marlamanani yawiyirlu. Kujawurlurrarni manya marlamananku, kayan ngarta pujujarri.” ");
INSERT INTO wmt_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Wali Mayiri lamajarrinya wangkijangka. Nyanartijangka manyanta Mayiri kirrarnani Lijipitta yakarnwarnti murrkurn. Nyanartijangka walimpa kayili tikiyani ngurrakarti nyantukurakarti. ");
INSERT INTO wmt_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Wali Lijipittu nyanartikarrarni martarni parri wartangurni. ");
INSERT INTO wmt_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Nyanartijangka piyirnwarnti marnpajangkawarnti jarntuwarnti Lijipitkurawarnti mapirrirni palurla wirriyajarrinya, tumaj palu pinakarrinya wangki nyapartukarra Ngarpungu parla yawiyijinyangujarrinya Lijipitku parnanyku. ");
INSERT INTO wmt_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Jamurn palkangajarrinya nyanarti yapa, wali ngarrjarni nguja ngurrawarnti 8. Wali nyanartikarra palu jarntuwarntirlu pirriyani piyirnkujirnupurru. Juwujwarntikura yurru manyanangu nguja kujarti. Yarnta palunya nira yini jularnani nyanartikarrarni. Minyarti parri Lijipitkura palu piyirnwarntirlu jularla yini Jakarayi yangka parla ngarpunyankura ngunangani yinijarti kayanparni. Yini palu jularla ngarpunyankurajiliny. ");
INSERT INTO wmt_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Yarnta ngamajinyankurarlu manyanangu jarrmarni. “Ngajirta,” marni manyanangu, “Yini manta julawu Jun.” ");
INSERT INTO wmt_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Nyanartiwarntirlu palurla marni, “Ngajirta manpila jarntu martarla yini Junjarti. Kanarlanyparni parlipa yiniwarnti nguniny.” ");
INSERT INTO wmt_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Nyanartijangka purrku palurla japirryinya Jakarayi. Warrarni pa ngunangani wangkingajirtajarti. Marni palurla kurraparlu, “Ngana yini marnalu julawu parri nyuntukura.” ");
INSERT INTO wmt_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Jakarayirlula manyanangu marni kurraparlu, “Mana partanpartan kangkajilu, yini marnanyirrangu lanku.” Wali lanila mananga kujartikarra, “Yini pa ngunawu Jun.” Jartijinyangula palu pinapinakarrinya, “Nganajangkarlu pa yini kujarti kurajpinya.” ");
INSERT INTO wmt_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Nyanartikarrarni wangkijartijarrinya Jakarayi kulkuru ngunangujangka. Ngarpula kajalkajalkujirni wurnarni. ");
INSERT INTO wmt_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Wali nyanartijangka karrartajarrinya palu piyirnwarnti nyanartikarrajiwarnti marnpajangkawarnti. Jakuljakuljularnanila palunyanangu wangki kanarlanywarntiwu Jutiyajangkawarntiwu. ");
INSERT INTO wmt_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Nyanartiwarntirlu pinakarrinyujangkawarntirlu palunyanu japirryungani, “Nganajiliny parta ngunawu minyarti parri Jakarayikura.” Tumaj palu nyanya nyanarti yapa mayajarti Ngarpukurajarti. ");
INSERT INTO wmt_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Nyanartijangka manyanangu kapumantu purlkangu Jija Wukajajju manyanangu marni pajawu piyirnku, “Wurna manta yanku nyurrawarntikurakarti ngurrara. Yini mantanyanu yutukarrku pajangu piyirntu. Yini manya nyaku kapumantu.” ");
INSERT INTO wmt_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Marni manyanangu nukarniwu piyirnwarntiwu wapalkarrawu. Wali ngurrarawarntirlurra palu yanani kujangkurrajarra. ");
INSERT INTO wmt_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Wali Najuritjangka Kalalijangka pila yani Pajilimkarti Jutiyakarti ngurrara nyantukura Jawujapkura. Pajilim pa Tayipitkura ngurrara jarlujangka kajaluwarlanyjangka. Yarntarni Jawujap pa nyanartikarrajiwarlanyparni Tayipitjiliny wartangurniwarlany kirlingalparni ngunangani, yanila Jawujap Pajilimkarti. ");
INSERT INTO wmt_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Purpankanya parlanyanu marnin purntajangka yini parla Mayiri, muntajartirni kanya Jawujapju. Yani pila, yini pilanyanu yutukarrku kapumanta. ");
INSERT INTO wmt_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Pirriyani pilanyanta Pajilimja. Wali kutajarrinya parla yapa martarnupurru. Nyanayirlala manyanu tarlkujirni yapangu purlumankurarla yartta. ");
INSERT INTO wmt_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Nyanartikarra pa tipani piyirntu pajangu mayaru purlka piyirnpurru yukarnupurru wurnakartirlu, yangkala pila yukarnani purlumankurarla. Wali nyanartijangka Mayirirlu martarni yapa walunyungu. Lamparntu manyanu tarlkujirni Pajilimja. Wali ngamajirlu Mayirirlu parla pulpinya palya, yutukani lamparn Jesus, nyanayirla mirurrumanurla pajkarrpirni palyajawurlu. Kujarti palunya ngamajirlu nira yapa karrpirnani. Takurrpinyala ngurtinga, kaninykaninypala ngunangani ngurtinga nurlunga. Yangka palu ngarnani kuyiwarntirlu jarntuwarntirlu miyi, nyanayirla pa yutukani lamparn Jesus Mayirirlu. ");
INSERT INTO wmt_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Wali nyanartijangkarla kukunjawarnti palurlanyanu ngampurrikanani marnparni palkanga piyirnwarntirlu pukanyja. ");
INSERT INTO wmt_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Pirriyani manyanangurla yinjil purlkakurajangka Ngarpukurajangka. Parralani manya tilingu purlkakurarlu Ngarpukurarlu mayangu. Karrartajarrinyala palu. Rayin purlka palu ngujangurra. ");
INSERT INTO wmt_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Nyanartijangka marni manyanangu nyanawurlu yinjillu nyanartiwarntiwu piyirnwarntiwu, “Ngajirta nganta karrartajarri. Wulyu wangki marnanyirrangu pirrikangany. Minyarti wangki marnanyirrangu julawu. Piyirnwarnti paja palu wirriyajarriwu wangkijangka minyartijangka.” ");
INSERT INTO wmt_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","12","Marnila manyanangu, “Jalarra pa yapa palkangawantinya Pajilimja Tayipitkurarla ngurrararla. Piyirn manya tikirrkujiwu yakurrjangka. Nyanarti yapa pa purlka Kurayij. Nginyjirrikarrkula manta yapa nyanarti. Parlipungku manta yukarnana pa ngurtinga. Yangka palu kuyiwarntirlu jarntuwarntirlu miyi ngalany, nyanayirla pa jalarra yukarnana palyajarti pajpajkarrpirnujangka.” ");
INSERT INTO wmt_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Wali pirriyanila palu partalurni pajajinyangu yinjilwarnti kankarnimarrangu. Nyanartijangkarlu palu yinparni juju, kajalkajalkujirni palu Ngarpu Kut. ");
INSERT INTO wmt_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Marni palu, “Mapunparni pa wulyu Ngarpu kankarnijangka kajalkajalkujirnupurru, nyantu yini Kut. Yangka manyanangu piyirnwarntiwu ngurtnguniny, wali nyanarti, kirtilypala palu nguniny nyantuwarnti.” ");
INSERT INTO wmt_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Tikiyanila palu yinjilwarnti kankarral. Jamurn palunya wanyjani, kankarral palu tikiyani. Marnila palurlanyanu piyirnwarntirlu ngampurrjiwarntirlu wartangurni. “Pa. Yankurlipa Pajilimkarti. Nyaku parlipa yapa. Ngarpungu purlkangu parla marni yinjilku, nyanartijangka wangkijarti parlipangu pirriyani. Pinajularni parlipangu yapa.” ");
INSERT INTO wmt_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Nyanartijangka partalurni palu yani, pirriyani pilangulurla Mayirirlajaa Jawujapja jampirlangurla. Nyanganila palu yapa yukarnujangka. Kuyiwarntikurarla jarntuwarntikurarla ngurtinga yukarnani, nira palunya yungani miyi, nyanayirlarnila yukarnani. ");
INSERT INTO wmt_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Yapa palu nyanya ngampurrjiwarntirlu. Nyanartijangkala palunyanangu piyirnwarntiwu jakuljularnani nyangungurla, nyapartukarra manyanangu jarlu jularnani nyangungurla, nyapartukarra manyanangu jarlu jularni yinjillu yapa nyanarti. ");
INSERT INTO wmt_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Kanarlanywarntirlu palunyanangu purrpurrmarni ngampurrjiwarntikurawu wangkiwu. Jularnani palunyanangu ngampurrjiwarntirlu yinjilkura wangki. ");
INSERT INTO wmt_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Yangkala Mayirirlu pa pinapinakarrinyani wutangu. Wangki ngampurrjiwarntikura pa muntanga tarrpartarnani jutungu. Ngajirta manyanta rukanyjarla. ");
INSERT INTO wmt_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Wali nyanartijangka ngampurrjiwarnti palu tikiyani kukunjawarntikarti. Ngarrurtajarrinya palu. Yinparni palu juju, ngarrurtawurra palu yinparni. Kajalkajalkujirnani palu Ngarpu. Takingu manyanangu marni yinjillu, nyanartijangkala palu ngarrurtarlula yinparnanijaa jularnani. ");
INSERT INTO wmt_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Yitilalwarlany yitilalwarlany palu Juwujwarnti yanani Jurujulumkarti kuyijaa miyi yiyijngajirta ngarnupurru pinalkarrapurru. Jarluwarlany manya Ngarpungu wanji yinya Mujijngurra Yijipja. Kakarrala manya kanya Kayinankarti. Nyanartipurru palu Juwujwarnti yanani Jurujulumkarti pinalkarrapurru. Mayirijaa Jawujap mapirrirni pila yanani. ");
INSERT INTO wmt_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yangka Jesus purlkajarrinya yitilalwarnti 12 ngarrja, nyanartikarra pilarla kanya Jurujulumkarti miyiwujaa kuyiwu ngarnupurru Ngarpuwu pinalkarrapurru. ");
INSERT INTO wmt_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","44","Wali kirrarnanila palu Jurujulumja. Yangka palu pujujarrinya miyi ngarnujangkajaa kuyi ngarnujangka, wali piyirnwarnti palu tikiyani kayili Mayirijaa Jawujap mapirrirni. Kula manyanangurla Jesus mapirrirni yani. Nyantu pila wanyjani nyanayirlarni lama mayarurla Jurujulumja. Wali nyantujarramipala pila yanani kayiliwarlany. Yananyjangkala pilangurla karuwarrajarrinya. Nyanartijangka kaparnpala pilarla jartijarti nyanyangurra yapawu Jesusku. Wali jarntuwarntirla wurnajartiwarntirla pilarla jarti wamarn muwupungani. Murlanyanangurla nyanartiwarntirlarni yanani. ");
INSERT INTO wmt_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","46","Nyantuwarntirlu pilangulu jirnapinya. Wali yarntarni pila tikiyani kurlirra Jurujulumkarti tikirrparni. Wamarn muwupunganila pilarla mayaruwarntirlal puranguwarnti murrkurn. Walimpawarlany pila parlipinya mayarurla Timpulla. Kirrarnani manyanangurla wangkikarra Juwujwarntirla purlkawarntirla pinangurruwarntirla. Nyanartiwarntirlu palurlanyanu jularnani, Jesusju manya pinakarrinyani. Nyanartijangkarlu japirrjapirryungani manya tikirrparni tikirrparni Jesusju. ");
INSERT INTO wmt_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Wali pinakarrinyurla palurlanyanu marni piyirnwarntirlu, “Minyarti parri pa pinarrijartijinyangu. Wangkiwarntiwu parla nukarniwurni pinarrijarrilany.” ");
INSERT INTO wmt_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Mayirijaa Jawujap pilarla karrpirlmarni. Purrkuwarntirlaliny manyanangurla kirrarnani Jesus. Mayirirlu parla Jesusku marni, “Nganajangka mantarrangurla yap yanungurla kirrarni. Minya pajarrarnangu wamarn muwupungani karrartarlu mayaruwarlany mayaruwarlany. Nyuntu man lamajarrinya minyayirla. Marringurni pajarrarnangu nyirrwiri tikiyani.” ");
INSERT INTO wmt_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Wali parringu pilangu marni, “Nganajangkarlu pajinpila wamarnwamarn muwupungani. Pinarri nganpilarla minyayirla Timpulla marna kirrarnana. Wangki ngajukurajangka Ngarpukurajangka marnarla pinarrijarrinyana.” ");
INSERT INTO wmt_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Nyantujarrarlu ngajirta pilarla nginyjirrikanantarla nyapartukarra pilangu jularnani. ");
INSERT INTO wmt_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Wali nyanartijangka pilangurla Jesus yani kayili. Pirriyanila palu mayarurla Najuritta, nyanartijangka palu kirrarnani. Nganawurti pilarla jinjinyungani, nyantungu pilangurla mapunikanani walakurlu Jesusju. Wali Mayirirlu pinapinakarrinya yangkartijangka wangkijangka yangka pilarla Jurujulumja marni Jesusju. ");
INSERT INTO wmt_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Wali Jesus karrkin purlkajarrinya. Milyilyirlu mapirri jirrkirl pinakarrinyani. Kuttu parla wirriyajarrinya, yarnta kanarlanywarnti piyirnwarnti palurla wirriyajarrinya nyangujangka. ");
INSERT INTO wmt_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Marnani manyanangu Juntu wulyu wangki piyirnwarntiwu warriyanujangkawarntiwu, yarnta kanarlany mapirrirni wangkiwarntiwarlany manyanangu jularnani. Lirrkarnpungani manya kurnakwantinyupurru. ");
INSERT INTO wmt_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Wali layimirri nganpayiwu parla jirrkirl marni Juntu purlkawu Yarritku. Marni parla, “Nyuntu man ngurriji. Ngurru manurla kartu warntarni papajikurajangka nyuntukurajangka. Yarnta man yakurrjinyangu ngunangani.” ");
INSERT INTO wmt_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Nyanartijangka kulijarrinya parla Yarrittu, jayilla yutukani Jun. ");
INSERT INTO wmt_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesusju manya mimijartiwarnti wulyukujirnani, jankajartiwarntijaa kirrarnumartajangkawarnti. Yarnta manyanangu jularnani Ngarpukura wangki purnkungu. Wali yitilalwarnti nguja 30, nyanartikarra manyanangurla warrkammarnani purnkungu. Wali piyirnwarntirlu palu ngurrpangu jularnani Jawujapkura walaku Jesus. Kilakiwarnti palurla kujarti kajalurnijangkawarnti. Jawujapkura ngarpu parla yini Yilayi, ");
INSERT INTO wmt_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Yilayikura ngarpu parla yini Matat, Matatkura ngarpu parla yini Lipayi, Lipayikura ngarpu parla yini Milki, Milkikura ngarpu parla yini Janayi, Janayikura ngarpu parla Jawujapwarlany, ");
INSERT INTO wmt_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Jawujapkura ngarpu parla yini Matatayij, Matatayijkura ngarpu parla yini Ramas, Ramaskura ngarpu parla yini Niyam, Niyamkura ngarpu parla yini Yijili, Yijilikura ngarpu parla yini Nakayi, ");
INSERT INTO wmt_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nakayikura ngarpu parla yini Mayat, Mayatkura ngarpu parla Matatayijwarlany, Matatayijkura ngarpu parla yini Jimiyan, Jimiyankura ngarpu parla yini Jawujik, Jawujikkura ngarpu parla yini Jawuta, ");
INSERT INTO wmt_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Jawutakura ngarpu parla yini Juwanan, Juwanankura ngarpu parla yini Rija, Rijakura ngarpu parla yini Jarapapil, Jarapapilkura ngarpu parla yini Jiyaljiyal, Jiyaljiyalkura ngarpu parla yini Niri, ");
INSERT INTO wmt_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nirikura ngarpu parla Milkiwarlany, Milkikura ngarpu parla yini Ratiyi, Ratiyikura ngarpu parla yini Kujam, Kujamkura ngarpu parla yini Yilmatam, Yilmatamkura ngarpu parla yini Yiya, ");
INSERT INTO wmt_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Yiyakura ngarpu parla yini Jajuwa, Jajuwakura ngarpu parla yini Yaliyija, Yaliyijakura ngarpu parla yini Jaram, Jaramkura ngarpu parla Matatwarlany, Matatkura ngarpu parla Lipayiwarlany, ");
INSERT INTO wmt_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lipayikura ngarpu parla yini Jimiyin, Jimiyinkura ngarpu parla yini Juta, Jutakura ngarpu parla Jawujapwarlany, Jawujapkura ngarpu parla yini Janam, Janamkura ngarpu parla yini Yilayakim, ");
INSERT INTO wmt_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Yilayakimkura ngarpu parla yini Miliya, Miliyakura ngarpu parla yini Mina, Minakura ngarpu parla yini Mataja, Matajakura ngarpu parla yini Nayijin, Nayijinkura ngarpu parla yini Tayipit, ");
INSERT INTO wmt_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Tayipitkura ngarpu parla yini Jisi, Jisikura ngarpu parla yini Wupit, Wupitkura ngarpu parla yini Puwaj, Puwajkura ngarpu parla yini Jala, Jalakura ngarpu parla yini Najan, ");
INSERT INTO wmt_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Najankura ngarpu parla yini Minatap, Minatapkura ngarpu parla yini Yatmin, Yatminkura ngarpu parla yini Yaniyi, Yaniyikura ngarpu parla yini Yajuran, Yajurankura ngarpu parla yini Parij, Parijkura ngarpu parla Jutawarlany, ");
INSERT INTO wmt_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Jutakura ngarpu parla yini Jayikap, Jayikapkura ngarpu parla yini Asik, Asikkura ngarpu parla yini Ayiparan, Ayiparankura ngarpu parla yini Tira, Tirakura ngarpu parla yini Niyuwu, ");
INSERT INTO wmt_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Niyuwukura ngarpu parla yini Jaruk, Jarukkura ngarpu parla yini Riyiwu, Riyiwukura ngarpu parla yini Pilik, Pilikkura ngarpu parla yini Yipa, Yipakura ngarpu parla yini Jiyila, ");
INSERT INTO wmt_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Jiyilakura ngarpu parla yini Kayinan, Kayinankura ngarpu parla yini Pajkit, Pajkitkura ngarpu parla yini Jiyim, Jiyimkura ngarpu parla yini Nawa, Nawakura ngarpu parla yini Lamik, ");
INSERT INTO wmt_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamikkura ngarpu parla yini Tujala, Tujalakura ngarpu parla yini Yinak, Yinakkura ngarpu parla yini Jarat, Jaratkura ngarpu parla yini Malaliyal, Malaliyalkura ngarpu parla Kayinanwarlany, ");
INSERT INTO wmt_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kayinankura ngarpu parla yini Yinaj, Yinajkura ngarpu parla yini Jaaj, Jaajkura ngarpu parla yini Ratam, Ratamkura ngarpu parla Kut. ");
INSERT INTO wmt_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Nyanartijangka Jesus pa ngunangani mayarurla tawunta. Nganpayi layi pa ngunangani mimijarti putajilinyjarti. Wali Jesus nyanya nganpayirlu mimijawurlu, yanila manyanta Jesuskarti. Nyanayirla manyanta parntawantinya jinanga Jesusja ngarntimarnupurru. Nira palu kujartikarra ngunangani nyanartiwarnti Juwujwarnti parntawantinyani palunyanangurla piyirnwarntirla purlkawarntirla ngarntimarnupurru nurrurrurlu. Wali nurrurrurlu parla ngarntimarnani Jesus nganpayirlu mimijawurlu. Marnani parla, “Purlka. Puju man wirriya nguniny wulyukujirnupurru, wali wulyukujija nyuntungu.” ");
INSERT INTO wmt_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Nyanartijangkala palymani nganpayi mimijarti kurraparlu jutinyngurni. Marnila parla Jesusju, “Wirriyajal marna nguniny wulyukujirnupurru. Wulyukujiwujal marnanta.” Partalurni wulyujarrinya, mimingajirtajartijarrinya. ");
INSERT INTO wmt_vpl VALUES ("LK5_14a","072_5_14a","LUK","5","14a","14a","Jesusju parla jarrmarni, “Ngajirta nganyanangu ngantuwurti jakuljula.” ");
INSERT INTO wmt_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Walirni palunyanangu jakuljakuljularnani wangki Jesus wulyukujirnujuwal mimijangka. Nyanartijangka palunyanta pirriyanani piyirnwarnti pajajinyangu, Yanani palunyanta Jesuskarti pinakarrinyupurrujaa wulyukujirnupurru mimijangka, yangkala pajajinyangu palanta pirriyanani. Ngajirta parla Jesusju Ngarpuwu marnantarla, tumaj piyirnwarntirlu pajangu palurla japirlyungani nira wulyukujirnupurru, yarnta nyantukura wangki pinakarrinyupurru. ");
INSERT INTO wmt_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Wali piyirnwarntingurni manyanangurla turtangkarrakangani Jesus jintangarlurra pintirnikarti. Japirlyunganila parla Ngarpuwu pintirningurni Jesusju. ");
INSERT INTO wmt_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Nyanartijangka Jesus yani kayilungu tawunwarlanykarti yinikarti Nayinkarti. Nyantukura mapirrikarrajiwarntijaa piyirnwarnti paja mapirrirni palunyanta yani. ");
INSERT INTO wmt_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Jamurn palu takurryantarla kiyitta, pirriyanila palu kanarlanywarnti. Piyirn palu layi pirla kangani kalukurla. Nyanarti nganpayi pirla parla layikura marninkura kalkarrakura walaku layirni. Nayinkarrajiwarnti paja palunyanta yanani mapirri. ");
INSERT INTO wmt_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Wali Jesusju nyanya, yawiyijarrinyala parla nyanartiwu marninku. Marni parla, “Ngajirta ngan lungka.” ");
INSERT INTO wmt_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Nyanartijangka Jesusju yanungurla tarrpartarni nyanarti kaluku, lamajarrinyala palu nganpayiwarnti kangujangkawarnti. Jesusjula parla marni piyirnku nyanartiwu pirlawu, “Nganpayi turtangka. Malany marnangu ngajungu.” ");
INSERT INTO wmt_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Nyanartijangka nganpayi nyanarti turtapinya. Kirrarnungurnila wangki marninyirra. Jesusjula parla marni nganpayikurawu nyanartikurawu, “Wanjikujirni marnangu. Tikirrkangku man.” ");
INSERT INTO wmt_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Rayinjarrinya palu nukarni nyanartijangka. Wirriyajarrinyala palu. Ngarpula palu jamalkanya. Marnani palurlanyanu, “Purlka parlipangurla pirriyani Ngarpukura puraput. Ngarpu parlipangu pirriyani wanjikujirnupurru.” ");
INSERT INTO wmt_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Wali wangki parla nyanarti jalyyani Jesusku wamarn mayaruwarlany mayaruwarlany Jutiyapurtarra. ");
INSERT INTO wmt_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Piyirnwarntirlu kanarlanywarntirlu palurla pamarr warntarnani kapumanku piyirnwarntiwarlanyjangka. Kapumantu manya jinjinyungani pamarr warntarnupurru piyirnwarntiwarlanyjangka, nyanartila palurla pamarr warntarnani piyirnwarntiwarlanyjangka yini manyanangu ngunangani takkirlaka. Yarntarni kanarlanywarnti nira palu ngunangani kujartikarra ngarlangalparni Ngarpungajirtajarti, yangkala Juwujwarntirlu palunyanangurla yakurrmarnani. Nyanartiwarnti piyirnwarnti palunyanta yanani Jesuskarti pinakarrinyupurru. ");
INSERT INTO wmt_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Nyanartijangka palu Jesus ngirtilykarra jularnani kurayipwarntirlujaa Parajiwarntirlu. Marnani palurlanyanu, “Jesus manyanangurla wirriya kirralany pamarr warntarnujuwalwarntirlajaa piyirnta ngarlangarlarla. Yarntarni manyanangurla miyi ngalany nyantuwarntirla.” ");
INSERT INTO wmt_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Nyanartijangka wangkila manyanangu marni Jesusju wangki ranyjikarraji kujarti. ");
INSERT INTO wmt_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Kinyin yangka piyirntu manya martalany kukunja paja 100, puju layi yap yanany, wali piyirntu kukunja ngampurrjirlu manya wanyjarralany kukunjawarntiwarlany yukanga palkanga. Nyanartiwarnti 99 palu yukanga karrilany. Nyanartijangka kayanku parla muwupungany yap yanujangkawu, kitangarni parlipungany. ");
INSERT INTO wmt_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Parlipungurla ngarrurtajarrilany parla. Ngamurlamanungurla wanturala kangany tikirr kukunja nyanarti. ");
INSERT INTO wmt_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Kangujangkarlu manyanangu pawumalany jarntuwarntiwu. Malany manyanangu, ‘Pawu. Nyaku mantawu. Parlipinyajal marna minyarti ngangayanujangka.’” ");
INSERT INTO wmt_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nyanartijangka Jesusju manyanangurla larrkkujirnani. Wangki manyanangu marni, “Kujartikarrarni manyirrangu nguniny nyanartijilinyparni kirlingalparni. Puju piyirn kayan yakurrngurni kurnakwantilany, wali nyanarti, Ngarpu parla wirriyajarriwujinyangu. Wulyuwarnti piyirnwarnti manya 99 nyangany wulyu Ngarpungu. Yarnta kaji piyirn yakurrngurni kurnakwantilany, nyanarti parla Ngarpu ngarrurtajarrilany purlkajinyangu wirriya parla nguniny.” ");
INSERT INTO wmt_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Yarntarni manyanangu marnani Jesusju, “Puju marnintu manya martalany pamarrwarnti murrkurn yangka parlanyanu marulu martalany 10 jilpa, wali nyanarti. Puju manyanta wilantilany, wali marulu parla muwupungany. Turlkujilanypala tili, tilijawurlu rarrpalany ngurra nyantukura. Wamarn warrilany parla maruluwu kitangarni parlipungany. ");
INSERT INTO wmt_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Parlipungurla manyanangu papajarralany jarntuwarntiwu, ‘Pawu. Nyaku mantawu. Parlipinyajal marna yangkarti marulu wilantinyujangka.’” ");
INSERT INTO wmt_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Larrkkujirnanila manyanangurla Jesusju. Marni manyanangu, “Kujartikarrarni manyirrangu nguniny nyanartijilinyparni kirlingalparni. Nyanartiwu kayanku palurla wirriyajarrilany yinjilwarnti Ngarpu mapirrirni, puju palu nyangany piyirn kayan yakurrngurni kurnakwantinyujangka.” ");
INSERT INTO wmt_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yarntarni manyanangu marnani Jesusju, “Kayan ngarpungu pinya martarnani kurriny walakujarra. ");
INSERT INTO wmt_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Jirnajangkarlu manyanta ngarntimarni ngarpunga. “Ngarpu, jalarra pajan yungku nyuntukura pamarrjaa manawarnti munyaljangka, yangka pajin yutukani walimpapurru munyal.” Wali ngurrujarrakujirni pilangu walakunyankurajarrawu munyaljangka pamarrwarntijaa manawarnti. Jarlu pilangu yutukani munyal ngarpunyankurarlu. Warntarla pila manawarntijaa pamarrwarnti munyaljangkawarnti, yangka pilangu ngarpunyankura pirlajarrirla. Walirni wanjingarni manyanta japirlyinya ngarpunyankurarla. ");
INSERT INTO wmt_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Nyanawurlu nganpayirlu jirnajangkarlu manya marurrpinya pamarrwarntijaa manawarnti munyaljangkawarnti, wurnapurru parlanyanu. Nyanartijangkarla murrkurn ngurrawarnti kumantawarlanyja jakarnkarrakanyala wurna ngarpukurangurni ngurrangurni. Yap yani pa nyanarti nganpayi marri. Marrijinyangu yap yani, ngajirta marnpa. Nyanayirla ngurranga marriwarlany manyanangurla pirriyani purlkanga tawunta. Nyanayirla warntarnani parlanyanu pamarrjawurlu wulywulyuwarntijaa yakurrwarnti. Nyanartijangkala yarnta manya yungani piyirnwarnti pamarr pinakarrinyumulu. Ngarlangaljinyangu ngunangani. ");
INSERT INTO wmt_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Pujumani parlanyanu nyantukura pamarr. Warpinykujirni parlanyanu kitangarni parlanyanu pujumani pamarr nyantukura. Marlalpala nguja pamarrngajirta. Ngajirta manyanangu ngapa pirriyantarla piyirnku nyanartiwu pajawu. Ngajirta manyanangu turtapungkarla miyi. Piyirn nyanarti palu paja kirrarnani miyingajirtajarti. Ngapa ngajirta manyanangu pirriyantarla yitilal. Marlal nguja nyanarti nganpayi miyingajirtajarti marranyanjarti. Munyal ngajirta parlanyanu jarlu yutukarrarla pamarr nyanawurlu nganpayirlu. Pujumani palunyanu pamarr nyantukura munyaljangka. ");
INSERT INTO wmt_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Nyanartijangka nganpayi walimpa marranyanjarti manyanta yani purlkakarti nyanartikarrajikarti linti. Warrkampurru parla japirlyinya. Wali yinyala parla warrkam pikipikiwarnti. Ngampurrikanani manya pikipikiwarnti nyanawurlu nganpayirlu. ");
INSERT INTO wmt_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Nyanartijangka miyi ngarla manyanangurla ngarnantarla marranyanjawurlu pikipikiwarntirla jamurn. Ngajirta parla ngananguwurti yungkarla miyi piyirntu. ");
INSERT INTO wmt_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Wali nyanarti nganpayi pinarrijartijarrinya. Pinapinakarrinyani. Marni parlanyanu marranyantu, “Paja palunyanta warrkammayin nguniny ngajukurarla ngarpunga. Martalany palu miyi pajajinyangu. Ngaju marna minyayirla nguniny purlka marranyan. Yangkartiwarntirlu palu ngalany miyi kinkiwurra, yangkajal manyanangu paja miyi nguniny. ");
INSERT INTO wmt_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Yanku marnanyanta ngajukurakarti ngarpukarti. Tikiyanku marnanyanta, malkula marnarla, ‘Ngarpu, yawiyijarrilany marnangu. Mapunparni marnanta wanyjani. Yarnta marnarla yawiyijarrilany Kutku. ");
INSERT INTO wmt_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ngajirta marnangu turtuk nguna walaku nyuntukura jularnupurru. Yarr marnangu ngunawu warrkammayin. Nyuntuwu marnangu warrkammalkula tikiyanungurla.’” Kujartikarra parlanyanu wangki pikakujirnani nganpayirlu nyanawurlu. Pinapinakarrinya parlanyanu kujartirni nyantukura ngarpu wartangurni. Warrarni pa marrirni kirrarnani. ");
INSERT INTO wmt_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Nyanartijangka tikiyanila manyanta nyantukurakarti ngarpukarti. Marringurnila pa nginyjirrikani ngarpunyankurarlu walaku nyantukura. Luyurrmarni parla ngarpunyankurarlu, marringurniliny nginyjirrikani. Nyanartijangkala parla laparni langkarni ngarpunyankura, ngamurlamanila. Linyala manyanta ngarpunyankura. ");
INSERT INTO wmt_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Marnila parla ngarpuwu walakurlu, “Ngarpu, yawiyijarrilany marnangu. Mapunparni marnanta wanyjani. Yarnta marnarla yawiyijarrilany Kutku. Ngajirta marnangu turtuk nguna walaku nyuntukura jularnupurru.” ");
INSERT INTO wmt_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ngajirtala mapunikarrarla ngarpunyankurarlu. Jinjinyinya manya warrkammayinwarnti nyantungu. Marnila manyanangu warrkammayinwarntiwu, “Partalu pirrikangkalurla kuluwujjaa ringjaa yakapiri, yangka marnanya munyal martalany. Yungku marnarla kuluwuj wulyu, yutukarrku manyanu ngajukurarlu piyirntu. Kurraparla manyanu tarrjakkujiwu ring. Yakapiri marnarla yungku, jinanga manyanu karrpiwu.” ");
INSERT INTO wmt_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Yarntarni manyanangu marni, “Warntalu kuyi nyanarti purlumanu ngajukura jirajartijinyangu. Pungkalu. Kuyijaa miyi purlka parlipa ngalku nukarnirlu. Wirriyajarriwu parliparla ngajukurawu walakuwu. ");
INSERT INTO wmt_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kula pirlajarrinyani walaku ngajukura, minyakujala wanji tikirrwantinya. Jarlu pa ngangayaniliny jalarra marna parlipinya tikiyanujangka.” Nyanartijangkarlu palu ngarnani kuyijaa miyi, nyanartila palu wirriyajarrinyani. ");
INSERT INTO wmt_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Wali nyanawurlu nganpayirlu papanyankurarlu wartangurni warrkammarnani yanungurla mayarungurni ruwangu. Nyanartijangkarlu warrkamjangkarlu tikirrwantinya nyanarti nganpayi, pinakarrinyala manya wangki marnujangka. Paja palu marnani wirriya. ");
INSERT INTO wmt_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Papajani parla warrkammayinku. Marni parla, “Nyapartujangka palu wirriya marnana nyanartiwarnti piyirnwarnti.” ");
INSERT INTO wmt_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Jangkumanila manyanta nyanawurlu warrkammayintu. Marni parla, “Ngajirta. Nyuntukura ngajajipurru pirriyani, yangka jarluwarlany yap yani. Wanjila wulyu pirriyani. Kula ngangayanirni, minyakujala wanjirni tikirrwantinya yara. Ngarpujipurrula parla wirriya nguniny walakuwu nyantukurawu. Nyanartijangkala ngarpujipurrurlu parla pinya kuyi nyanarti jirajartijinyangu purlumanu.” ");
INSERT INTO wmt_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Nyanartijangka nyantu pa kulijarrinya nganpayi kajalurnijangka. Jutparnila karrinyani. Ngajirta manyanangurla kirninyyantarla piyirnwarntikarti. Ngarpunyankura parla langkarni yani. Jarti pa purpani nyanartikarti piyirnwarntikarti. ");
INSERT INTO wmt_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Marnila parla ngarpunyankurawu, “Ngajirta. Nira marnangu warrkammarnani nyuntuwu. Ngajirta marnangurla panypungantarla. Mapunikanani marnangu. Wulyuwulyu marnangu warrkammarnani nira. Ngajirta pajan kujarti yungantarla kuyi nanikutwurti lamparnwurti wirriyakujirnupurru kujartijilinypurru. Puju marnanyanangurla ngajungu nganyjarla jirajarti kuyi, nyanartila marna wirriyajarrirla, nyanarti wali. ");
INSERT INTO wmt_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Minyarti mankurla jalarra pinya nyanarti jirajarti purlumanu nyuntukurawu walakuwu tikirrwantinyujangkawu. Yangka mantarrangu yutukani munyal, nyanartila manya nyantungu warntarnkarrakanya munyaljangka pamarrwarntijaa manawarnti. Wanyjanurlakani manta wurnangu. Nyanartijangkarlu nyuntukurarlu walakurlu mangu tarrapungurlakani pamarrwarntijaa manawarnti. Nyuntukura walaku pa marninjuwal ngunangani. Nyanartijangka marlalpala mangurla tikirrwantinya nyuntukarti ngarpukarti, nyanartila manurla pinya kuyi nyanarti purlumanu jirajarti nyantuwumipa, ngajirta ngajuwu, nyantuwumipa.” ");
INSERT INTO wmt_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ngarpungula parla marni walakuwu nyantukurawu, “Ngajajipurru pa yani, kanyala parlanyanu pamarrwarntijaa manawarnti pujurni munyaljangka. Nyuntungu ngajirta pajan wanyjarrarla. Nira pajanurla nguniny ngajunga, yangkala pamarrwarntijaa manawarnti pujurni mangu warrarni nguniny minyayirla ngurranga.” ");
INSERT INTO wmt_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Yarntarni parla marni walakuwu nyantukurawu, “Minyarti marnalurla ngajajipurruwu pinya purlumanu jirajarti. Kula walirni pirlajarrinya, minyakujala yararni pirriyani wanjirni. Kula walirni ngangayani, parlipinyala marna tikirrwantinyujangka. Nyanartila marnalurla purlumanu pinya ngajajipurruwu, ngajula marna wirriyajarrinya.” ");
INSERT INTO wmt_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Yangka palu Timpulla karrinyani Jesuskurawarnti mapirrikarrajiwarnti, wali marnani palurlanyanu, “Wulyujinyangu pa minyarti mayaru, yarnta pamarrwarnti wulyuwarnti nganapartu nganapartu, yangka palurla jarlu Ngarpu yinya yiji.” Jesus manyanangu marni, ");
INSERT INTO wmt_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Wali manta nyangany jalarra. Walimpa palunya tarrapungku pamarrwarntijaa mayaru minyarti mapirri. Minyartiwarnti pamarrwarnti palu ngunanganku wantinyujangka.” ");
INSERT INTO wmt_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Wali japirlyinya palurla Jesus, “Pinarriyungujuwal. Nyangurla pa kujartijarriwu. Nyapartukarra marnalu nyaku kutajarrinyujangka, yangka parla kutajarriwu mayaruwu tarrapungupurru.” ");
INSERT INTO wmt_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Wali Jesusju manyanangu marni, “Ngajirta ngantanya wajilpungka kajiyungujuwalwarnti yirrijiwarnti.” Yarntarni manyanangu takijularni Jesusju, “Pirriyanku palu kanarlanywarnti yirrijiwarnti. Julawu palunyanu, ‘Yangkarti marna ngaju yangka pajinta jurumanani.’ Yarntarni manyirrangulu julawu kutajanyupurru. Wali ngajirta ngantanya wajilpungka yangkartiwarnti.” ");
INSERT INTO wmt_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Yarntarni manyanangu Jesusju takijularni, “Kanarlanywarntirlu palunyanu kajalkajalkujiwu wartangurnijangkarlu, yarnta palunyanu piyirnwarntirlu punganku. Wali pinakarrinyanku manta kujarti. Ngajirta nganta rayinkarri. Ngajirta paji kutajarri ngajupurru tikiyanupurru, walimpa pa ngunawu kujartikarra.” ");
INSERT INTO wmt_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Yarntarni manyanangu Jesusju marni, “Piyirnwarntirlu pajangu palunyanu punganku kuli marriwarntijangkarlu mapirrirni, ngajirta murrkurntumipa. ");
INSERT INTO wmt_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Yarnta ririmarnanku nguwa langkirrlaparnupurru, yarnta ngapawu mapirrirni palurla kanarlanywarntirlu jarti jurumanku miyiwu mapirrirni turtapungupurru. Marranyanjarti palu ngunanganku. Yakurrwarnti manyanangurla pirriyanku nganapartu nganapartu. Yarnta yalkirijangka palu nyaku nguwukarrikanupurru karrartakujirnujuwal.” ");
INSERT INTO wmt_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Wali yarntarni manyanangu takijularni Jesusju mapirrikarrajiwarntiwu, “Wali tarrpartawu manyalu pungupurru, yarnta kangku manyalu purlkakarti kuwutkarti. Kuwutjangkarlu manyalu kangku jayilkarti. Nyanartijangka manyalu kangku purlkawarntikarti kingwarntikarti, tumaj pajinta ngajukurawarnti mapunjiwarnti. ");
INSERT INTO wmt_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Wali nyanayirla purlkawarntirla mantanyanangu julawu ngajukurajangka wangki wulyu. ");
INSERT INTO wmt_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","15","Wali ngajirta nganta rayinkarri. Ngajungu marnanya purnkukujiwujaa tanyjikujiwu. Nyanartikarra marnanyirrangu julawu ngajukurajangka wangki nyapartukarra mantanyanangu tikirrjulawu. Ngajirta nganta kajaluwarlany rayin pinakarri. Wali marnanyirrangu julawu wangki, nyanartijangka kayan nganyalu jangkumanta nyanartijangka ngajukurajangka wangki.” ");
INSERT INTO wmt_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Yarntarni manyanangu marni Jesusju, “Kangku manyalu jarntuwarntirlu pungupurru ngamajirlujaa ngarpungu, yarnta papajirlujaa ngajangu mapirrirlu. Pungku manyalu kanarlanywarnti pirlawurra. ");
INSERT INTO wmt_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Yarnta manyirrangulu yakurrmarnanku nukarnirlu piyirnwarntirlu ngajungurni, nyurrawarnti pajinta ngajukurawarnti. ");
INSERT INTO wmt_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Wali ngajungu marnanya martarnanku kurraparla. ");
INSERT INTO wmt_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Lani manta ngunawu ngajukurarlal, yangkala manta pirlurr ngunawu wanji.” ");
INSERT INTO wmt_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Wali yarntarni manyanangu Jesusju takijularni mayaru tarrapungupurru, “Yangka mantanya nyaku marrijangkawarnti palu marnpa pirriyanku kulipariwarnti Juwujngajirtawarnti, mapunparni palu minyarti mayaru tarrapungku Jurujulum timpul mapirrirni. ");
INSERT INTO wmt_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Wali nyanartikarra palu lapalku pamarrwarntikarti marri pungungamarra, mayarujangkawarnti palu lapalku. Ngajirta ngartalu rantangajangkawarnti lapanyja mayarukarti takurr. ");
INSERT INTO wmt_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Puraputwarntirlu palu jarlu lani kujartikarra, puju ngajirta palu mapunikarrarla, pungkula manya Ngarpungu. Jalarra marnanyirrangu jularnana, mapunparni manya pungku Juwujwarntijaa mayaru mapirri. ");
INSERT INTO wmt_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Yangka marninwarnti muntajartiwarntijaa lamparnjartiwarnti, wali yawiyi palurlanyanu ngunawu. ");
INSERT INTO wmt_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Wali kanarlanywarnti Juwujwarnti palunya marrijangkawarntirlu lanku pirlawurra, kanarlanywarnti palunya kangku ngurrujarra ngurrujarra. Jarntuwarntingurni palunya wirrpakangku. Warrkammayinkujiwula palunya Juwujwarnti marrijangkawarntirlu. Mayaru minyarti Jurujulum palu tartalykanyjiwu Juwujngajirtawarntirlu kitangarni manya Ngarpungu lamakujiwu.” ");
INSERT INTO wmt_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Jesusju manyanangu marni mapirrikarrajiwarntiwu yangkartiwarntiwu, “Purangujaa yakarn, wilwarnti palu kanarlanyparnijarriwu. Nginyjirrikarrkula manta. Kaniny nguwanga jawurlata purlkajarriwu, yangka manya takulanku manawarntijaa mayaruwarnti, kaparnpala palu karrinyanku. Pinakarrinyanku palu, rangkurrmarnanku pa jawurlata nyanarti. Purrpurrmalkula palu piyirnwarnti nukarnini wapalkarra, yangka palu nyaku nyanarti ngapa parayanujangka. ");
INSERT INTO wmt_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Yarntarni yalkirikarrajiwarnti purangujaa yakarnjaa wilwarnti palu turtapungku kanarlanykartingurni wapalngurni. Wali nyanartijangka palu piyirnwarnti yalyyanurla wantiwu karrarta purrpurrmarnujangka. Ngurrpangurrparlu palunya nyaku yangkartiwarnti yalkirikarrajiwarnti piyirnwarntirlu.” ");
INSERT INTO wmt_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Wali yarntarni manyanangu Jesusju marni, “Nyanartikarra marna ngajula pirriyanku. Yurnturra marnanyanta kirrarnanku. Wulyu pajalu nyaku pajangu piyirntu mayajarti. ");
INSERT INTO wmt_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Yangkartiwarnti mantanya nyaku yalkirirlajaa jawurlatarla, wali manta nginyjirrikarrku. Mil manta kankarraljarti karriwu purnku. Kurraparla marnanya martawu. Partalurnila marnanyirrangurla rayin pujukujiwu.” ");
INSERT INTO wmt_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","30","Nyanartijangka Jesusju manyanangu warraja marni, “Yangka manta pinakarrilany jiriki kirtirr marnujangka, nginyjirrikarrkula manta ngapa partalurni pirriyanupurru. ");
INSERT INTO wmt_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Nyanartijiliny manta nyaku yalkirijaa jawurlata kanarlanyparnijarriwu pila, nginyjirrikarrkula manta Ngarpu manyirrangu partalurni majajarriwu.” ");
INSERT INTO wmt_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Wali yarntarni manyanangu marni Jesusju, “Mapunparni marnanyirrangu jularnana, yangka manta jalarra wanji nguniny, kujartikarra marnanyirrangu marnani yangkarti jarlu. Kunyungurla manta yirrawarlany kajalurni pirlajarriwu, yirrawarlany manta wanji ngunawu, nyaku manta minyarti. ");
INSERT INTO wmt_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Yalkirijaa nguwa pila pujujarriwu, wali nyanarti jamulu. Kayan ngarta ngajukura wangki pujujarri.” ");
INSERT INTO wmt_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Yarntarni manya lirrkarnpinya, “Kujarti marnanyirrangu marnani, pinalkarra mantarla ngunawu. Ngajirta nganta pinapinakarri jutungu kanarlanywarnti miyijaa ngapa ngarla, pamarrjaa warrkam, yarnta kanarlanywarnti nganapartu nganapartu. Yarr manta ngunawu lani. Puju manta yarr kirrarnanku nganganganga, wali murtarni manyirrangu kanarlanyparnijarriwu yalkirijaa jawurlata, yangka kunyarrjiliny kitpananany manangu kitpanjuwallu. ");
INSERT INTO wmt_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Yangka kunyarrwurti jakalany, wali murtarnila manyanta pajarralany manangu kitpanjuwallu.” Yarntarni Jesusju marni, “Kujartikarra manyanangurla murtarni pirriyanku piyirnwarntirla nukarnirla wapalkarrarla yangka kunyarrjiliny warntalany, yangka marnanyirrangu jarlu jularni. ");
INSERT INTO wmt_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Wali marrki manta ngunawu pika, japirlyunganku mantarla Ngarpu nira yangkartirlamarra. Purnkula manta ngunanganku. Yangka marnanyirrangu pirriyanku, marnpa pajantarla karriwu ngajunga kurntayingajirta, tumaj manta pikajarti kirralany.” ");
INSERT INTO wmt_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Wali nyanartijangka Jesusju manya kumantawarlany kumantawarlany pinarriyungani nyanayirla Timpulla. Yarnta karuwarrawarlany karuwarrawarlany pa jintanga yapyanani pamarrkarti yinikarti Yalipjartikarti. ");
INSERT INTO wmt_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Wali piyirnwarnti nukarnini palurla pirripirriyanani Timpulkarti kumantawarlany kumantawarlany purangu kankarraljarrinyjangkarla pinakarrinyupurru. ");
INSERT INTO wmt_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Wali layiwarlanyju ngurrijirlu parla Jesusku nginarrmarni. Marni parla kujartikarra, “Julalany manyanu Ngarpukurajinyangu yini Kurayij. Nganajangkarlu manyanu tikirrwanjikujirla. Ngajarra mapirrirni mantarranya tikirrwanjikujiwu.” ");
INSERT INTO wmt_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Nyanartijangka ngurrijiwarlanyju parla jarrmarni, “Nganajangka man. Ngarpuwu ngajirta manurla rayinkarri.” Yarntarni parla marni, “Nukarnini parlipanyalu mananga tarnikani nyantu mapirrirni. ");
INSERT INTO wmt_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ngalijarramipa parli yakurr, pirlakujilanypala parlipanyalu tumaj parli ngurrijijarra. Yurru parli jungani ngalijarrarlu. Nyanarti nganpayi kaparnjangka yakurrngajirta. Ngajirta pa yurru jungantarla nyantungu.” ");
INSERT INTO wmt_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Nyanartijangka Jesusku parla marni jarrmarnujuwallu, “Yangka man purlka pirriyanku maja, wali ngajula pajan pinapinakarriwu.” ");
INSERT INTO wmt_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Wali Jesusju parla marni, “Mapunparni pajinurla ngunawu ngajunga kankarni wungkurra jalungurrurla jalarrarni.” ");
INSERT INTO wmt_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Jesusju manya kanya mapirrikarrajiwarnti kurlila mayarukarti Pijanikarti. Nyanayirlarni palu jatparamarni. Nyanartijangka Jesusju kurrapajarra kankarnikujirnurla japirryungani parla Ngarpu, mapirrikarrajiwarntiwu manyanangurla jutujikujirnupurru. ");
INSERT INTO wmt_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Nyanartikarrarnila japirryungujangkarlu manya wanyjani wartangurni. Kankarralpala kanya Ngarpungu yapinkarti. ");
INSERT INTO wmt_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Nyanartijangka mapirrikarrajiwarntirlu palu Jesus kajalkajalkujirni wartangurni kankarralyanujangka. Wali tikiyanila palu kayili Jurujulumkarti wirriyajinyangu. ");
INSERT INTO wmt_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Nyanartijangka nira palu Ngarpu kajalkajalkujirnani mapirrikarrajiwarntirlu mayarurla Timpulla. ");
INSERT INTO wmt_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Jamurn yangka purangu kankarnijarrinyani kumantajarti, Jesuspala yani mayarukarti Timpulkarti. Piyirnwarntila palunyanta paja yani Jesuskarti. Jesuspala manyanangurla yutantinya nyantuwarntirla, pinayinya manya kirrarnungurni. ");
INSERT INTO wmt_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Nyanartijangka marnin palunyanta Jesuskarti kanya piyirnwarntirlu. Minyartiwarnti piyirnwarnti palu kanarlanywarnti tarrukuwu nyantukurawu pinangurru, yini manyanangu kurayip. Kanarlanywarntiwarlany palu tarruku nyantukura tartpartarnujuwal, yini manyanangu Paraji. Wali yangkarti marnin palu warntarni yukarnujangka, kanarlanykurarla ngumparnarla manyanta yukarni. Wali kaparnpala palu marnin karrinyukujirni. Piyirn palunyanta marnparni wamarn karrinya. ");
INSERT INTO wmt_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Marni palurla Jesusku kurayipwarntirlujaa Parajiwarntirlu, “Minyarti marnin marnalu parlipinya kanarlanyjarti ngumparna yukarnani. ");
INSERT INTO wmt_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ngarpukurajangka Mujijju parlipanya jinjinyinya nyantukurarlu tarrukurlu jarlujangkarlal kujartijilinyku pamarrjawurlu pajanuwu pirlawurra. Nyapartu mankurla malku nyuntungu.” ");
INSERT INTO wmt_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Wangki palurla Jesusku kuja marni kajiyungupurru, kajiyungkarla palu Jesus. Jesuspala palu ngirtilykarra jularla. Nyanartijangka mirtijurrurnjurrurn wantinyurla Jesus kulkururlurni wirntipungani nguwanga. ");
INSERT INTO wmt_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Jutungurni palu Jesus japirlyungani kurayipwarntirlujaa Parajiwarntirlu, yangkala manya nyanya kankarral. Marnila manyanangu, “Pamarrjawurlu pa luwawu kajalurni nyanawurlu piyirntu jurnanykarrarlu. Yangka yakurrwurti ngajirta manyanta nguna.” ");
INSERT INTO wmt_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Wali Jesus warrarnila kirrarnani. Kurraparlu wirntipungani nguwanga kulkururlurni. ");
INSERT INTO wmt_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Jamurn palu pinakarrinya nyanarti Jesuskura wangki, wurnarnila palu kurntayikarra tirrinytirrinyyani nukarnini kurayipwarntijaa Parajiwarnti. Kayanngurla kayanngurla palu tirrinytirrinyyani purrkuwarntiliny pingkayiwarnti wartangurni. Jesuspala palu wanyjani kirrarnujangka wartangurni. Kuja manyanta marnin karrinyani linyja. Nyanartiwarnti paja piyirn palu yap yani. ");
INSERT INTO wmt_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jesus ngalaramarnila parla. Kankarral nyanya karrinyujangka. Marni parla marninku, “Marnin. Wanyjurla palu yani yangkartiwarnti, ngananguwurti manta ngulikani kuliparirlu.” ");
INSERT INTO wmt_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Jangkumanila manyanta marnintu, “Ngajirta, marlal.” Jesusju parla marni, “Ngajungu lakarra, ngajirta marnanta ngulikarra. Yanta. Ngajirta ngan yarnta yakurrjarri.” ");
INSERT INTO wmt_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Layi nganpayi yini parla Lajurasjaa rimpinyankurajarra mapirrirni palu ngunangani mayarurla yininga Pijanirla marninjarra yinijarra Mayirijaa Maaja. Nyanartijangka Lajuras wantinya purlka mimi. ");
INSERT INTO wmt_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Layirni Mayiri yamparrajarti yangkarti manyanta Jesusja jinajarrarla purtkujirni wulyu parntimanupurru, yangkala murupinya nyantukurajawurlu purturnjawurlu yamparrajawurlu. Murupinya manyanta jinanga Jesusja jurlungajangkajawurlu rallu. Nyantukurala Mayirikura parla papaji mimi nguja Lajuras. ");
INSERT INTO wmt_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Nyanartijangka pilarla wangki yiparni Jesusku ngapurlunyankurajarrarlu purlkawu, “Nyuntukura mangu mirt mimijarrinya.” ");
INSERT INTO wmt_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jamurn pinakarrinya Jesusju marringurni, marnila manyanangu mapirrikarrajiwarntiwu, “Nganajangka pa yukarnana. Ngajirta pirlajarrinyupurru. Yarr pa yukalany, mimijangka palu nyaku kanarlanywarntirlu pajangu Ngarpukura maya. Nyaku pajalu, ngajungu marna maya martalany, ngaju marna Kutkura walaku. Minyarti nganpayi mimijangka palu wulyula nyaku kanarlanywarntirlu.” ");
INSERT INTO wmt_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesusju manya tapungmanani nyanartiwarnti rimpirlangujarti mapunjinyangu Maajajaa ngajanyankura yarnta Lajuras mapirrirni. ");
INSERT INTO wmt_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Jamulurni manya pinakarrinyurlakani, jularnani palurla Lajuras mimijarrinyujangka, yalayirlarni Jesus kirrarnani lama, kurrinywarlany ngurra yukarni. Ngajirta manyanangurla wurnajarrirla partal. ");
INSERT INTO wmt_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Nyanartijangka kurriny ngurra yukarnkarrakanya. Marni manyanangu Jesusju mapirrikarrajiwarntiwu, “Yankurlipa karla Pijanikarti tikirr Jutiyarlalparni Lajuraskurakarti ngurrakarti.” ");
INSERT INTO wmt_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Mapirrikarrajiwarntirlu palu marrkukani Jesus, “Ngajirta. Jarlurni mantalu pamarrjawurlu luwarla pirlawurra Juwujwarntirlu Pijanirla marnpa. Nyapartu man tikiyanany nyanayirlurra.” ");
INSERT INTO wmt_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","10","Jesusju manyanangurla jangkumani, “Jininyara parlipangu purlka kitpungupurru, kayan ngarlipa takurrkarra wanti pukanyjajilinyparni. Jininyara parlipa kitpungany, purangurlu parlipanya tili yungany. Pukanyja parlipa yanany, nyanarti wantilany parlipa kurrkunga, tumaj tili ngajirta manyanta nguna.” ");
INSERT INTO wmt_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yarntarni manyanangurla marni Jesusju, “Ngalimpakura piyirn Lajuras parlipangu manyan yukalany. Yanungurla marna parnkimanku ngajungu.” ");
INSERT INTO wmt_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Mapirrikarrajiwarntirlu palurla marni, “Purlka. Puju pa manyan yukalany, nyanarti pa wulyu turtangku nyanturni.” ");
INSERT INTO wmt_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Nyanartiwarntirlu palurla marni, kula manyanparni yukarnani, minyangurru manyanangu Jesusju kujawarlanyngurnu jularnani. Ngajirta manyanangu pirlajarrinyujangka jularnantarla jirrkirl. ");
INSERT INTO wmt_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Nyanartijangka manyanangu kalara jularni jirrkirl Lajuras pa pirlajarrinya. ");
INSERT INTO wmt_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Wali marni manyanangu Jesusju, “Lamajarrinya marna minyayirla ngurranga takiwarlanyparni. Ngajirta marnanyanta jarlurni yantarla Lajuraskarti. Jalarra parliparla yanku, yangkala pajanta nyaku nyanayirla ngajukura maya, mapunikarrkula pajintarla. Kujartikarrapurru marnanyirrangu ngarrurta nguniny.” ");
INSERT INTO wmt_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Marnila manyanangu nganpayirlu yiningu Tamijju mapirrikarrajiwarntiwarlanyku, “Yanku parlipanyanta Jesusja Pijanikarti mapirrirni. Puju palu Jesus pungku, wali ngalimpa mapirrirni parlipanyalu pungku.” ");
INSERT INTO wmt_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Nyanartijangka palu yani, pirriyanila palu Pijanirla, jarlungurru palu Lajuras yutukani pirlajarrinyujangka najinga ngurrawarntila murrkurntajaa ngurra kayanta. ");
INSERT INTO wmt_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","19","Wali nyanarti mayaru Pijani marnparni manyanta nguja Jurujulumja karlarrara, yangkala palu Juwujwarntiwarlany Jurujulumkarrajiwarnti yani nyanartikarti mayarukarti Pijanikarti. Wali Mayirijaa Maaja pila ngunangani nyanayirlarni Pijanirla lungujangka pinyalu mapirrikujirnani. Papajiwu pilarla pirlajarrinyujangkawu lungani. ");
INSERT INTO wmt_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Jamurn palurla jularni Maajawu Jesus yanujangka nyantukurakarti ngurrakarti, yanungurla parla japantinya Maajarlu. Mayiri pa lamarni kirrarnani kaninykaniny mayarurla. ");
INSERT INTO wmt_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","22","Maajarlu parla marni Jesusku, “Purlka. Puju man jarlu pirriyantarla, wanjirni pa ngunarla warrarni papaji ngajukura. Wulyukujirlala man nyuntungu, yangka man partalurni pirriyantarla. Yangka mannyanta ngarntikangany Ngarpunga nira, nyanarti wali pinakarrilany mangu. Ngajungu marnarla mapunikarralany, mapunparni mangurla jangkumanany.” ");
INSERT INTO wmt_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesusju parla marni, “Nyuntukura papaji mangu pirlajangka wanjijarriwu.” ");
INSERT INTO wmt_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Maajarlu manyanta jangkumani, “Yuwayi. Ngaju marnarla pinarri, walimpa turtangku. Yangka ngurra kutajarriwu, nyanartikarra palu wanjijarriwu walimpa pirlajangkawarnti jarlujangkawarnti, mapirrirni manyanangurla turtangku papaji ngajukura.” ");
INSERT INTO wmt_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","26","Jesusjula parla marni Maajawu, “Ngaju marna kayan wanji yungujuwal pirlajangkawurti marnarla wanji yungany. Puju ngananguwurti pajirla mapunikarralany piyirntu, nyanarti pa wanji ngunawu. Puju yangka pirlajarriwu, pirlurr pa wanjirni ngunawu. Puju ngananguwurti pajirla wanjingurni mapunikarralany, kayan ngarta pirlurr nyantukura pujujarri.” Japirryinyala parla Jesusju, “Mapunikarralany ngan Maaja.” ");
INSERT INTO wmt_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marnila parla Maajarlu, “Yuwayi. Mapunikarralanyjal marnangurla. Nyuntu man yangkarti Kurayij Kutkura walaku. Pirriyani manpangu Ngarpungurni kankarnimarrangungurni, yangka marnangulu pinalkarra ngunangani jarluwarlanyjangka.” ");
INSERT INTO wmt_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Nyanartijangka wanyjanurlakani Jesus Maajarlu. Kajalkajal pa yani Maaja mayarukarti. Parlipinyala ngajanyankura, yangkartiwarntingurni manyanangurla ngarrpirtimankarranya. Nyantu manyanangurla kirrarnani Jurujulumjangkawarntirla, jularnila parla Jesus pirriyanujangka. Marni parla, “Purlka parlipangu pirriyani pinayungujuwal. Japirlyinya mangu nyuntuwu. Nyaku manta.” ");
INSERT INTO wmt_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","30","Wali partalurni pa Mayiri turtanya wangkingarni, yanila manyanta Jesuskarti warntarrirlal. Jesus pa warrarni karrinyani kirlingarni. ");
INSERT INTO wmt_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Jamurn palu nyanya Mayiri turtangujangka piyirnwarntirlu lungujangkawarntirlu, wajilpinya palu. Kula Mayiri pa yantarla najikarti jintanga. Najinga palunyanta lungkarla nyanayirla, minyangurru manyanta Jesuskarti yani. ");
INSERT INTO wmt_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Wali pirriyani manyanta Jesusja Mayiri. Lapart parntawantinya manyanta jinanga kajalurni. Marnila parla lungukarrarlu, “Purlka. Puju man jarlu pirriyantarla, wanjirni pa ngunarla warrarni papaji ngajukura. Wulyukujirlala man nyuntungu.” ");
INSERT INTO wmt_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Mayarujangkawarntirlu palu pirriwajilpinya wartangurni Mayiri, yangkala palu lungani, Jesusjula manya nyanya lungujangkawarnti. Munta yawiyijarrinyajaa luyurrmarni mapunjinyangu. ");
INSERT INTO wmt_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Japirlyinya manya Jesusju, “Wanyjurla manta yutukani pirla karrkin.” Jangkumanila palunyanta, “Pa. Pinakangku marnangulu.” ");
INSERT INTO wmt_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Wali linyala Jesus. ");
INSERT INTO wmt_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Kanarlanywarntirlu palu Jesus nyanya lungujangka. Marnila palurlanyanu, “Mapunparni kujala tapungmanani nganpayi minyarti pirlajangka.” ");
INSERT INTO wmt_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Wali kanarlanywarntirlu palurlanyanu marni, “Nganpayiwarlany wulyukujirni mil jankajartijangka. Kula Lajuras nyanartijiliny wulyukujirla nganpayijiliny jankajartijiliny.” ");
INSERT INTO wmt_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yarntarni pa luyurrmarni Jesus. Wali yanila najikarti. Jarlu palu yutukani najinga, pamarrpala palunyanta rukukani kirlingirrirla. ");
INSERT INTO wmt_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesusju manya jinjinyinya. “Pamarr nyanarti rirripkangkalunyanta.” Maajarlu parla marni Jesusku Lajuraskurarlu rimpingu, “Jarnngu pa jungkujpalany. Jarlu pa pirlajarrinya ngurrawarnti kurrinykurriny.” ");
INSERT INTO wmt_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesusjula parla marni Maajawu, “Yangkakatarnangu jarlu jularni. Rukarni ngannyanta. Puju pajanurla mapunikarralany, nyaku man Ngarpukurajangka maya.” ");
INSERT INTO wmt_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","42","Mapunparnila palu rirripkanya pamarr nganpayiwarntirlu, Jesusjula kankarral warrpunyanya, Ngarpula parla japirlyinya. Marni parla Ngarpuwu, “Mapunparni marnangurla mapunikarralany. Pinakarrilany pajan nyuntungu, jangkumanany pajanurla. Minyartingurni jalarra pajilurla mapunikarrku piyirntu, nyuntungu pajan yiparni minyartikarti.” ");
INSERT INTO wmt_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Nyanartijangka mayajinyangula papajani, “Lajuras turtangka. Palkangajarri.” ");
INSERT INTO wmt_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Wali mapunparnila pirriyani Lajuras. Warrarni pa pajpajkarrpirnujangka ngujangurra warpiny miljarrajaa jinajarrajaa kurrapajarra nukarnini. Jesusju manyanangu marni, “Yulajpantalanta, wurna pa yanku.” ");
INSERT INTO wmt_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Yangka palu Jesus nyanya wanjikujirnujangka Lajuras, wali pajangu palu mapunikani yangkartiwarntirlu Mayiri palu wajilpungani najikarti lungujangkarlu. Nyanartijangkawarntirlu palu mapunikani yangka Jesusju wulyukujirni nganpayi Lajuras. Nyanyala palu pajangu wanjikujirnujangka. ");
INSERT INTO wmt_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Rakarrarlarni wiyikja pa jakarni Mayiri Miktilin najikarti pirlapurrukarti. Parlipinyala kirlingirri ngaamarnujangka. Nyanarti paljarr purlka rirripkangujangka pa marnparni karrinyani. ");
INSERT INTO wmt_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Wali jamurn nyanya kirlingirri, mayarukartila tikirrlaparni Mayiri. Mapirrikarrajijarrarla pilangurla pirrilaparni. Kanarlany pa mapirrikarraji yini parla Pita, kanarlany pa mapirrikarrajiwarlany yangka Jesusju tapungmanani. Nyanartijarrarla pilangurla Mayiri pirrilaparni. Wali marnila pilangu, “Warawu. Yap kanya palu purlka ngalimpakura najingajangka. Ngurrpa parliparla, wanyjarrarla partalu yutukani.” ");
INSERT INTO wmt_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Wali jamurn pilangu marni Mayiri Miktilintu, wurnarnila pila jakarni najikarti mapirrikarrajijarra. ");
INSERT INTO wmt_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Laparni pila pupuru. Wali nyanarti nganpayi mapirrikarrajiwarlany mayajinyangu manyanta tirrinylaparni Pitanga. Kajalurni wantinyala najinga. Pita pa warrarni laparnani. ");
INSERT INTO wmt_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Wali Jesusku parla kijinyanya mapirrikarrajirlu najingajangkawu. Parlipinyala palya karrkintajangka Jesuskura. Ngajirtarni takurryantarla kaninykaniny. Warrarni pa karrinyani palkanga. ");
INSERT INTO wmt_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Wali nganpayi Jayimin Pita pa wartangurni pirrilaparni. Ngajirta pa lamajarrirla kirlingirrirla. Murtarni manyanta takurryani najinga pirlapurrurla kaninykaniny. Parlipinyala palya karrkintajangka yukarnani. ");
INSERT INTO wmt_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Palyawarlany Jesuskura jurlungajangka parla yukarnani pakulwarlany. Rulumapkujirnurla parla jarlu wanyjani. ");
INSERT INTO wmt_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Wali takurryanila manyanta nganpayi mapirrikarraji wartangurni Pitanga kaninykaniny. Karrkin ngajirtarni parlipungkarla wartangurnijangkarlu. Wali jarti nyangungurla parla mapunikani Jesusku wanjijarrinyujangkawu. Minyajal parla palyamipa yukarnani. ");
INSERT INTO wmt_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Wali jarlu pa wangki lani kurrumparla nganpayirlu puraputtu Jesus tikirrwanjijarrinyupurru. Wali pila pinakarrinya wangki puraputkura. Yarnta ngajirta pila mapun nginyjirrikarrarla yangkarti wangki jarlujangka mapirrikarrajijarrarlu. Nyanartikarramiparni pilarla mapunikani kaji pila palyamipa nyanya. ");
INSERT INTO wmt_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Nyanartijangka tikiyanila pila ngurrakarti. ");
INSERT INTO wmt_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Wali nyanartijangka Mayiri pilangurla wartapuranjarrinya nganpayijarrarla. Karrinyani palkanga najinga marnpa. Lungani. Ngajirtarni takurryantarla kaninykaniny. Lungukarrarlurni parla kijinyangani najinga Jesusku. ");
INSERT INTO wmt_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Nyanyala pinya yinjiljarra kurriny. Kirrarnaninyirra pila kaninykaniny. Kuluwuj parpjarti pila wirrimmartarnani. Kirrarnani pilanyanta manginga nyapartukarra Jesus yukarni. Kanarlany kirrarnani jurlunga. Kanarlany pa jinanga kirrarnani. ");
INSERT INTO wmt_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Wali yinjiljarrarlu pilarla marni Mayiriwu, “Marnin, nganajangka man lungana.” Marnila pilangu Mayirirlu, “Yangka pajilu warntarnkarrakanya ngajukura purlka. Ngajirta marnarla pinarri. Wanyjurla partalu yutukani.” ");
INSERT INTO wmt_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Wali tikirrkurnakwantinyala Mayiri. Parlipinyala Jesus. Wartangurni manyanta karrinyaninyirra. Ngajirtarni pa nginyjirrikarrarla Jesus. Warrarni pa kanginypungani. ");
INSERT INTO wmt_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Nyanartijangka Jesusjula parla marni Mayiriwu, “Marnin, nganajangka man lungana. Ngantuwu mankurla muwupungana.” Mayirirlu nganganyanya. Kularni yangkarti nganpayi warrkammayin nyanartikarraji. Ngajirtarni nginyjirrikarrarla Jesus. Wali Mayirirlu parla marni, “Nyuntungu partan warntarnkanya. Julaji. Wanyjurla man yutukani. Wali nyanartijangka puju pajin julawu, yanungurla marna warntawu.” Kujartikarra parla marni Mayirirlu. ");
INSERT INTO wmt_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Wali Jesusju parla marni Mayiriwu, “Mayiri, nyakaja.” Mayirirlula manyanta warrpunyanya, nginyjirrikanila. Marnila parla Mayirirlu, “Rapuni.” Nyanarti wangki Mayirirlu parla marni Juwujwarntikura. Kayanparni wangki parlipa julalany pinayungujuwal. ");
INSERT INTO wmt_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Nyanartijangka parntawantinya manyanta jinanga Jesusja, tarrpartarnila jina Mayirirlu. Marnila parla Jesusju, “Ngajirta ngajan tarrparta. Warrarni. Ngajirta marnanyanta tikirrwantirla kankarral Ngarpukarti. Yanku manyanangurla mapirrikarrajiwarntikarti ngajukurawarntikarti. Julawula mannyanangu minyarti wangki ngajukurajangka. Kankarral marnanyanta yanku Ngarpungkurra ngajukurarlurra, nyurrawarntiwupurrupurru manyirrangu mapirri.” ");
INSERT INTO wmt_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Wali Mayiri Miktilin mayarukarti yani. Mapirrikarrajiwarntiwu manyanangu jularni. “Ngalimpakura purlka marna nyanya.” Yarntarni Mayirirlu manyanangu marni nyapartukarra parla Jesusju wangki yinya. ");
INSERT INTO wmt_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Karuwarrajarti wiyikja nyanartikarrarni manyanangurla pirriyani Jesus mapirrikarrajiwarntirla mayarurla kaninykaniny. Jarlu palurlanyanu rukukani kiyijawurlu tuwawarnti, yangkala ngartalu pirriyanta Juwujwarnti majawarnti pungujuwalwarnti. Rayinjarrinyani palunyanangurla mapirrikarrajiwarnti Juwujwarntirla. Wali takurryanila manyanangurla Jesus. Takurryanungurla manyanangurla jatparamarni kaparn. Marnila manyanangu, “Pirriyani marnanyirrangurla.” ");
INSERT INTO wmt_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Wali jirrimartarnila manyanangurla Jesusju kurrapajarrajaa ramarra. Nyanyala palu mapirrikarrajiwarntirlu limiwarnti kurrapajarrarlajaa ramarrarla. Nginyjirrikanila palu Jesus. Makijarrinyala palu yangka palu purlka nyanya. ");
INSERT INTO wmt_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Wali jularnila manyanangu Jesusju, “Wirriya nganta nguniny.” “Yu,” marni palurla. Jularnila manyanangu, “Ngajukurarlu Ngarpungu paja yiparni nyurrawarntikarti. Wali kirlingalparni marnanya nyurrawarnti yipalany ngurrawarlany ngurrawarlany. Wangki mantanyanangu takijulawu.” ");
INSERT INTO wmt_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Wali rangmarnungurla manya puwumarni Jesusju mapirrikarrajiwarnti. Marnila manyanangu, “Pirlurr Ngarpukurajangka marnanya yungany. Nyurrawarntirla manyirrangurla ngunawu. ");
INSERT INTO wmt_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Puju mantarla malku piyirnku nganawurti yakurryakurr wajapungupurru, kujartikarra mantarla malku, ‘Ngarpungu mantarla wajapungurla rukarni yakurryakurr nyuntukura.’ Wali mapunparni manyanangurla wajapungurla rukarni Ngarpungu. Yarnta puju mantarla takingu malku piyirnku nganawuwurti, ‘Ngarpungu ngajirta mantarla wajapungurla rukanyjarla yakurryakurr nyuntukura.’ Wali mapunparni Ngarpungu ngajirta wajapungurla rukanyjarla.” ");
INSERT INTO wmt_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Wali nyanartijangka Jesus manyanangurla yap yani mapirrikarrajiwarntingurni. Wartapuranjarrinyala manyanta Jesusja nganpayi mapirrikarraji Tamij. Yiniwarlany parla ngunangani Titimaj. ");
INSERT INTO wmt_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Jamurn pirriyani Tamij, marnila palurla mapirrikarrajiwarntirlu, “Purlka ngalimpakura marnalu nyanya.” Wali Tamijju manyanangurla panypinya. Marni manyanangu, “Yangka kaji marna nyaku kurrapajarra limijarti parnpungujangka, yangka marna kurrapajarra palymanku, nyanartila marnarla mapunikarrku Jesusku wanjijarrinyujangkawu. Yarnta yangka marnanyanta kurrapa takurryanku ramarrarla liminga Jesusja nyanartikarrala marnarla mapunikarrku.” ");
INSERT INTO wmt_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Wali wiyikwarlanyja Jesus manyanangurla pirriyani mapirrikarrajiwarntirla, yangka kaji pujurni palu kirrarnani mayarurla. Rukjarti palurlanyanu martarnani. Tamij manyanangurla mapirri kirrarnani. Takurryanungurla manyanangurla Jesus jatparamarni. Marnila manyanangu, “Yu. Ngaju marnanyirrangurla pirriyani.” Wali yijingkanya manyanu Jesusju. ");
INSERT INTO wmt_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Tamijku parla marni panypungujangkawu, “Palymantaja kurrapajarra. Palymanungurla nyakaja limi. Yarnta talmanungurla takurryantajarla kurrapa ramarrarla. Ngajirta ngajankurla panypunganta. Mapunikarrkuwurti pajankurla.” ");
INSERT INTO wmt_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Wali marni parla Tamijju Jesusku, “Yu. Nginyjirrikarralany marnanta. Purlkajal pajin. Kutjal pajin.” ");
INSERT INTO wmt_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesusjula parla marni Tamijku, “Mapunikani pajanurla nyangujangkarlamipa. Ngajirta pajan mapunikarrarla jarlu. Yangka pajan millu nyanya, wali nyanartila pajan mapunikarralany. Ngarrurtajarrinyala pajin. Karlpurrwarlanyju piyirnwarntirlu pajilu murtarni mapunikarrku nyangungajirtajangkarlu. Kayan ngajalu nyaka millumiparni, yangkala nyantuwarntirlu pajilu mapunikarralanywurti. Wali ngarrurtajinyangu pajilu nguniny.” ");
INSERT INTO wmt_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Wali mapirrikarrajiwarntirlu palu nyanya Jesus wulyukujirnanujuwaljaa jurramanujuwal. Millu palu nyanya warrkamjangka. Ngajirta marna pujurni lantarla minyayirla kurrumparla, nyapartukarra Jesusju wulyukujirnani mimijangkajaa pirla manyanangurla jurramanani. Nira pa warrkammarnani Ngarpukura, ngurrpa kujawurlurra. ");
INSERT INTO wmt_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Minyayirla kurrumparla nyangungurla manta mapunikarrku Jesus. Nginyjirrikarrkula manta Jesus yangkarti yiparnujangka Ngarpukura, yini palu julalany Kurayij. Yarntarni manta nginyjirrikarrku Kutkura walaku. Yangka manta mapunikarrku, wanjila manya yungku kujawurlurra Jesusju. ");
INSERT INTO wmt_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","4","Wali nyanartijangka palu kayirrara yani mapirrikarrajiwarnti Kalalikarti. Wali yiniwarlany parla ngapa nyanarti Tayipiriyij. Mapirrikarrajiwarnti palu yani yinijartiwarnti Jayimin Pitajaa Tamij Titimajjaa Nataniyal. Wali minyarti nganpayi Nataniyal pa tawunjangka Kayinakarrajijaa Kalalikarraji. Mapirrirni pila yani kurriny walakujarra, nganpayiwu Jipitiwu pilarla. Yarnta kurrinywarlany mapirrikarrajijarrawarlany. Wali warriyanungurla palu kirrarnani. Wali nganpayirlu manyanangu marni Jayimin Pitangu mapirrikarrajiwarntiwu, “Kapikarti marna yanku.” Karlpurrwarlanyju palurla marni, “Yanku marnangulurla mapirri.” Wali jakarnila palu pujurni. Yanungurla palu parayani ngurtinga ngapakarrajirla. Jamurn purangu karla takurryanani, nyanartikarra palu jakarni. Wali wamarn ruwarraruwarrakangani palu langkunawurra kapi warntarnupurru, nyanartikarrarni pukanyja purlka kakarrara. Ngajirtarni palu kapi warntarla. Marlalparni. Nyanartijangka Jesusju manyanangurla kalarawantinya yarntarni mapirrikarrajiwarntirla. Jamurn purangu kakarra pirmarnani, nyanartikarra pa Jesus karrinyani ngapanga rirringki. Nyanartiwarntirlu mapirrikarrajiwarntirlu ngajirta palu nginykirrikarrarla. Kula nganpayiwarlanyparni. ");
INSERT INTO wmt_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Japirlyinya manya, “Wayila manta kapi warntarni piyirnwarnti.” Jangkumanila palu, “Marlal. Jarti marnalu ruwarraruwarrakangani.” ");
INSERT INTO wmt_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Marnila manyanangu Jesusju, “Tarrapungkalurla langkunawurra kujangkurra. Nyanartijangka kapila manta warntawu.” Wali tarrapinyala palurla. Kapila palu pajajinyangu warntarni. Nyanartijangka jartila palu jatpanani. Patkanyjirnani manyanangu kapingu pajangu langkunawurra. ");
INSERT INTO wmt_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Wali layingu parla marni Pitawu, “Nyaka. Nyanarti purlka parlipangu karrinyana.” Wali kujarti parla marni yangkartirlu nganpayirlu yangka Jesusju tapungmanani. Wali wangki pinakarrinyurla Pitangu manyanu yutukani mana jaat partalpartal. Jarlu pa warrkammarnani jaatngajirtajawurlu. Nyanartijangka wurnarnila jarntakparni ngapakarti ngurtingurni. ");
INSERT INTO wmt_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ngurti ngapakarraji ngajirta pa marri karrinyantarla. Rirringkirlarni yarr marnparni karrinyani. Kanarlanywarnti mapirrikarrajiwarnti palu wartangurni yani ngurtijartirni rirringkikarti. Langkunawurra palu ruwarrakangani kapiwarntijarti. ");
INSERT INTO wmt_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Nyanartijangka palu jupantinya mapirrikarrajiwarnti. Wurnala palu yani rirringkikarti pulparrkarti. Wali nyanyala palu warlu manyjirnaninyirra. Kapiwarnti palu nyanya pirrkinga, manyjirnani palu warrarni. Rapuwarnti mapirri palu warlunga rirringki yukarnani. ");
INSERT INTO wmt_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Wali Jesusju manya ngarntikanya, “Kapi kangarnilu mirnu ngajukarti yangka manta warntarni.” ");
INSERT INTO wmt_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Wali ngurtikartila tikirrjakarni Jayimin Pita. Kurtajpanila langkunawurra, ruwarrakanyala rirringkikarti kapi pajajarti. Kapiwarnti purlkapurlka pajajinyangu palu ngunangani 153. Yangka kapiwarnti pajajinyangu palunya warntarni, langkunawurra ngajirtarni palu langkirrmantarla kapingu. Wulyuwulyurni pirrikanya. ");
INSERT INTO wmt_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Nyanartijangka Jesusjula manyanangu marni, “Yanarnilu. Jarlu kuyi pukarrjarrinya. Ngalkurlipa.” Wali palu nginyjirrikani. Ngajirta palu yarnta japirlyungkarla, “Ngana man nyuntu.” Mulkarra palanta ngunangani japirlyungupurru tumaj manyanangu purlka. ");
INSERT INTO wmt_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Nyanartijangka rapuwarntila manya warntarni Jesusju, yinyala manya. Yarntarni kapiwarnti manya yinya. ");
INSERT INTO wmt_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Wali nyanartikarra Jesusju manyanu wanjijarrinyujangkarlu kalarakujirnani mapirrikarrajiwarntirla. Jarlu manyanu kalarakujirni kurrinymirri. ");
INSERT INTO wmt_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Nyanartijangka jamurn palu kapi ngarni, wurnajarrinyala palu Jesusjaa mapirrikarrajiwarnti. Wali Jesusju parla japirlyinya Jayimin Pita wurnanga wurnangarni, “Jayimin, Junkura, ngurtpalany ngajin ngajuwu. Kunyungurla ngajirtaparta. Kunyungurla manurla ngurtpalany kapiwu, kapi man warrkammarnanku.” Wali Pitangu jangkumani, “Ngajirta. Pinarri pajin ngajuwu. Wulyumalany marnangu.” Wali Jesusju parla marni, “Ngampurrikarranya ngajukurawarnti piyirnwarnti yangka pajanta waangany.” ");
INSERT INTO wmt_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yarntarni Jesusju japirlyinya, “Jayimin, Junkura, ngurtpalany ngajin ngajuwu.” Marnila parla Pitangu, “Yu. Pinarri pajin ngajuwu, wulyumalany marnangu.” Wali Jesusjula parla marni, “Ngampurrikarranya ngajukurawarnti piyirnwarnti yangka pajanta waangany.” ");
INSERT INTO wmt_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yarntarni Jesusju parla marni Jayiminku, “Jayimin, Junkura, wulyumalany ngajin.” Wali Pita pa yawiyijarrinya kaji Jesusju parla japirlyinya yarntarni kirlingalparni. Marnila parla Jesusku, “Yu, nyuntu man pinarrijinyangu. Wulyumalany marnangu.” Wali Jesusju parla marni, “Ngampurrikarranya ngajukurawarnti piyirnwarnti yangka pajanta waangany.” ");
INSERT INTO wmt_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Wali Jesusju parla takijularni Pitawu, “Minyarti wangki marnangu mapun marnana. Yangka man jarlu ngunangani pingkayi, kuluwuj manyanu yutukanani wurnapurru, nyanartijangka man yanani kujangkurrajarra yangka manurlanyanu kurajpungani nyuntungu. Ngajirta manta ngananguwurti lamakujirnantarla. Yarr man yanani nyuntukurarlal. Kaji yangka man walimpa purrkujarriwu, nyanartikarra manyanu kurrapajarra jirrimartawu. Karrpiwula mantalu rupjawurlu. Wali ruwarra mantalu kangku ngurrakarti kanarlanykarti. Ngajirta mankurla wirriya nguna. Parnkapunganku man nyanarti ngurrara.” ");
INSERT INTO wmt_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Kujartikarra parla Jesusju marni Pitawu. Pinayungani wangki nyapartukarra Pita walimpa pirlajarriwu. Piyirnwarntirlu palu tartpartarnurla pungku pirlawurra. Wali Ngarpula palu kajalkajalkujirnanku piyirnwarntirlu kanarlanywarntirlu tumaj Pitangu Jesuskura wangki mapunikanani yangka parla ngunangani jamurnku pungupurru. Nyanartijangkarlu Jesusju parla Pitawu marni, “Nyuntungu pajan jartamananku.” ");
INSERT INTO wmt_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Wangkiwangkikarra pila yanani Jesusjarra Pita. Wali nyanartijangka ngalaramarnila Pita. Nyanyala nganpayi mapirrikarrajiwarlany wartangurni pilangurla yanani. Yangkarti nganpayi yangka Jesusju tapungmanani. Nyanarti manyanta marnparni kirrarnani Jesusja, yangkartikarra Jesusku parla jamurnjamurnjarrinyani tarrpartarnupurru. Japirlyinyala parla kujartikarra, “Purlka, nganangu piyirntu manta pirtinyikarrku.” Wali nyanartirni mapirrikarraji pilangurla wartangurni yanani. ");
INSERT INTO wmt_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Nyangungurla parla marni Pitangu, “Purlka. Yangkarti pajin jularni ngajuwu pirlajarrinyupurru. Nyapartujarriwu nyanarti yangka parlipangurla wartangurni yanana.” ");
INSERT INTO wmt_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Marnila parla Jesusju, “Kunyungurla nyanarti nganpayi ngunanganku wanji kaji yangka marna tikirrwantiwu. Kunyungurla marna pirriyanku wartangkarra. Wali nyanarti, nyantukura parla wanji, ngajirta nyuntukura. Nyuntungu pajin mapunikarrku ngajuwu.” ");
INSERT INTO wmt_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Yangka Jesusju parla minyarti wangki marni, mapirrikarrajiwarntirlu palurlanyanu marnani, “Nganpayi nyanarti kayan ngarta pirlajarri. Julalany palu, ‘Wanji pa kujawurlurra ngunawu.’” Minyarti wangki palunyanangu marnani piyirnwarlanyku kayanngurla kayanngurla Jesuskurawarntirlu. Wali makarn palunyanangu marnani. Ngajirta palu wangki Jesuskura taki pinakarrinyantarla. Jesusju ngajirta parla manyjarla wangki ngunangupurru kujawurlurra wanji. Marni parla nyantungu kujarti, “Puju marnarla wulyumalany nyanarti wanji ngunangupurru kitangarni marna tikirrwantiwu, wali nyanarti, ngajungu marna kurajpungku, ngajirta nyurrawarntirlu.” ");
INSERT INTO wmt_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Wali nganpayirlu yangka palu marnani wangki wanji ngunangupurru, nyantungu marni minyarti wangki Jesuskurajangka. Yarnta kurrumparla lani. Wangki minyarti lanujangka mapunjinyangu nguniny, ngajirta wapal. Pinarri parliparla mapunku. ");
INSERT INTO wmt_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Jarlu marnangu lani mirlimirliwarlany ngajungu Lukju yiniwu Jiyapulijku, nyapartukarra Jesus kitpungani, Jesusju manyanangu jularnani wangki Ngarpukura. Wali marnangu jularni Jesus nyapartukarra pirlajarrinyajaa nyapartukarra wanjijarrinyajaa nyapartukarra kankarralkujirni Ngarpungu. Wali kurajpinya manya nyanartiwarnti piyirnwarnti pajilwarnti pajajangka mapirrikarrajiwarntijangka. Larrkujirnani manyanangurla Jesusju takingu nyapartukarra palu ngunawu wartangurni. Pirlurru Ngarpukurajangkarlu mayakujirnani Jesus nyanartila manyanangu Jesusju jularnani wangki kurajpungujangkawarntiwu. Yangka manyanangurla piyirnwarntirla larrkujirnani jarlurni Jesusju pikawurra, nyanartijangkala Ngarpungu kankarralkujirni. Yarntarni marnangu tikirrjulawu wangkiwarlany, ngajungu Lukju yangka Jesus wanjijarrinya pirlajangka. ");
INSERT INTO wmt_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Pajangalmirri manyanangurla pirriyanani Jesus yangkarti pirlajangka. Mapunwurrajinyangu palu nyangani karrkin piyirnwarntirlu. Pirripirriyanani manyanangurla warraja mapunwurra, walila palurla mapunikanani. Ngajirta palanta panypungantarla. Pinarrijarrinyala palurla Jesusku, mapunjinyangu kujala wanji. Takijularnani manyanangurla Ngarpu parlipangu purlka nguniny. Wali tikitikiyanani manyanangurla ngurrawarnti 40, kitangarni yapyani walimpawarlany. ");
INSERT INTO wmt_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Yangka manyanangurla Jesus warrarni ngunangani, lamakujirni manya piyirnwarnti nyanartiwarnti. Marni manyanangu Jesusju, “Kirranyjalu lama mayarurla Jurujulumja. Jurumantalurla, pirriyanku manyirrangu Pirlurr Ngarpukurajangka. Jarlu marnanyirrangu jularni, Ngarpungu manyirrangu yipawu Pirlurr nyantukurajangka. Jurumantalurla Jurujulumja.” ");
INSERT INTO wmt_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yarntarni manyanangu marni Jesusju, “Ngapangakujirni manya nganpayirlu Juntu piyirnwarntijaa marninwarnti. Ngapapurula palu nguja piyirn, turtapinyala palu. Nyanartijilinyju manya rukukarrku ngapajilinyju Pirlurru Ngarpukurajangkarlu. Ngarpungu manyirrangu yipawu Pirlurr nyurrawarntiwu, takurryanku manyirrangurla. Ngurrawarntirla murrkurnta manyirrangurla pirriyanku.” ");
INSERT INTO wmt_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Wali nyanartijangka Jesus manyanangurla ngunangani kanarlanywarntirla piyirnwarntirla nyantukurawarntirla pajilwarntirla. Marni palurla Jesusku, “Japirlyungku marnantalu. Nyuntu marnanpangu purlka. Jarlu parlipangulu ngunangani kajalkajalwarnti kilakiwarnti ngalimpakurawarnti. Jalarra marnanpanya nyuntungu kajalkajalkujiwu nganampa jirnajangkawarnti, nyapartukarra parlipangulu ngunangani ngalimpakurawarnti kilakiwarnti jarlu kajaluwarlany.” ");
INSERT INTO wmt_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Wali marrkukani manya wangkijawurlu. Marni manyanangu, “Ngarpu parla pinarri nyantumipa. Kajalkajalkujirnupurru parla nyantu pinarri Ngarpu, nyapartukarra nyantungu kajalkajalkujiwu piyirn. Pinarri parlipangu nyantumipa nyapartukarra parlipa ngunanganku. Kunyungurla parlipanya jalarra kajalkajalkujiwu, kunyungurla walimpa. Ngurrpa mantarla ngunanganku kajalkajalkujirnupurru.” ");
INSERT INTO wmt_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Yarntarni manyanangu marni Jesusju, “Pirriyankujal manyirrangurla nyurrawarntirla Pirlurr Ngarpukurajangka. Takurryankula manyirrangurla, mayakujiwula manya. Nyanartijangka pajinta wangkijarti ngunawu. Jakuljulawu mantanyanangu piyirnwarntiwu kanarlanywarntiwu ngajukurajangka wangkijaa ngaju marnanyirrangurla ngunangani mapirri. Julawu mantanyanangu piyirnku Jurujulumkarrajiwarntiwujaa Jutiyakarrajiwarntiwujaa Jimariyakarrajiwarntiwu. Nyanartijangka wapalkarrawu mayaruwarlany mayaruwarlanyjangkawu marrijangkawarntiwu mapirrirni mantanyanangu julawu.” ");
INSERT INTO wmt_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Wali Jesus lamajarrinya wangkijangka marnujangka, Ngarpungula pa kankarralkujirni nyantukurakarti ngurrakarti yini yapinkarti. Warrpunyangani palu kankarral piyirnwarntirlu Jesus manyanangurla turtangkanya tampirni kankarral. Jesus palu yayikanani, tuwumarnani Jesus kankarral. Ngarpungu kangani. Yurnturr manyanta ruklaparni Jesusja. Yarntawarlany jartila palurla nyanya, yurnturrula pa ranyjikujirni. ");
INSERT INTO wmt_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Wali warrarni palu warrpunyangani yalkirirlurra. Karrinyani palu kankarraljarti mil. Kurriny pila marnpa kalarawantinya murtarni piyirnjarra, parpjarti mana pila wirrimkangani kuluwuj nyanartijarra yinjiljarra. ");
INSERT INTO wmt_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Marnila pilanyanangu piyirnwarntiwu Kalalikarrajiwarntiwu, “Nganapurru manta warrpunyangana, kankarraljarti mil manta karrinyana. Jesus pa jatpanurlakanya Ngarpungu yapinkarti nyurrawarntijangka. Walimpa pirriyanku narangalparni, minyartijiliny yapyani kankarral, narangalparni tikiyanku.” ");
INSERT INTO wmt_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Wali Jurujulumngurni kakarra palu karrinyani pamarra yininga Yalipjartirla. Ngajirta marri, yarr marnpa. Wali wurnajarrinyala palu karla Jurujulumkarti. ");
INSERT INTO wmt_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Pirriyani palu ngurranga Jurujulumja. Takurryananila palu mayarurla nyantuwarntikurarla. Kayanta palu pajilwarnti kirrarnani yinijartiwarnti minyartiwarnti nganpayiwarnti, Pita Jun Jayimji Yanturu Pilip Tamij Paratalamiyu Maju Jayimjiwarlany juku parla Yalpiyajku Jayimin, ngajirta Pita. Jayiminwarlany minyarti. Yinijarra kurriny palu jularni Jayiminjaa Jaluti. Jutaj, ngajirta yangkarti Jutaj. Kanarlany pa Jutajwarlany. Ngarpu nyantukura yini parla Jayimji. ");
INSERT INTO wmt_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Wali japirlyungani palurla Ngarpu. Kayanta palu kirrarnani mayarurla mapirrikarrajiwarnti nganpayiwarnti, yarnta marninwarnti ngamaji Jesuskura mapirrirni yini parla Mayiri, yarnta Jesuskurawarnti ngajawarnti. Wali jutungu palurla japirlyungani Ngarpu. ");
INSERT INTO wmt_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Wali nyanartijangka warryani palu piyirnwarntijaa marninwarnti mayarurlurra Jesuskurawarnti paja. Miyitingja palu kirrarnani paja piyirn 120. Nganpayi Pita pa turtapinya wangkijarti. ");
INSERT INTO wmt_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","17","Marni manyanangu Pitangu, “Ngajukurawarnti jarntuwarnti Jesuskurawarnti, pinakarrilu. Yangkarti nganpayi Jutaj yangka Jesusju kurajpinya warrkampurru nyantukurapurru. Kula warrarni parlipangurla ngunangantarla ngalimparla, yarntala parlipanya wanyjani Jutajju. Nyanartijangkarlula pinakanya manyanangu Jesus tartpartarnupurru, yangkartila palu tartpartarni.” ");
INSERT INTO wmt_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Wali pamarr palurla Jutaj yinya Jesus pinakangupurru. Kanyala parlanyanu pamarr Jutajju, yinyala parla nganpayi. Payamkujirni manyanta ngurra nyanarti, nyantuwula parla nguja Jutajku. Wali nyanartijangkala Jutajju manyanu kurntayi parlipinya. Parayanungurla manyanu tarrjakkujirni rup kangkurlla karrartarlu. Nyanartijangkala pujujarrinya wanji. Wantinyala kaniny pirla. Murtarnila purljukkarni munta, jilpirti pa palkanga nguja. ");
INSERT INTO wmt_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Jurujulumkarrajiwarntirlu palurlanyanu jakulkangani, Jutaj pa pirlajarrinya yangkarti mapirrikarrajijangka. Yini palu jartikanila ngurra Jutajkura yini ngurra pirlajarrinyujangka. ");
INSERT INTO wmt_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","22","Yarntarni manyanangu marni Pitangu, “Yangka parlipa nguja 12 jarlu, kanarlany pa ngangayani Ngarpungurni Jutaj. Kanarlany parlipa warntawu nganpayiwarlany, yarnta parlipa turtukjarriwu, yangka parlipa jarlu nguja. Kujartikarra parlipangu jarlu takijularni kurrumparla. Wali lani layingu nganpayirlu nyapartukarra layi pa pirlajarriwu, wali nyanartijangka palu kurajpungku layiwarlany. Yangka parlipa kurajpungku nganpayi layi nyanartijangka yangka Jesus nyanya wanji turtapungujangka.” Yarntarni manyanangu marni Pitangu pinalkarrarlu warntarnupurru piyirnwarlany, “Ngalimpajiliny 12jiliny parlipa kurajpungku. Wali nganpayirlu Juntu manya ngapangakujirnani piyirnwarnti kajaluwarlany, nyanartijangkala pirriyani Jesus. Mapirrikujirnila parlipanya Jesusju. Jartamani parlipa Jesus ngalimpakura purlka. Nyanartikarra parlipanyanta lapantinya Jesusja, wali kitangarni parlipanya Jesusju wanyjani. Jesus kankarralkujirni Ngarpungu. Wali piyirn parlipa kurajpungku ngalimpajilinyparni yangka parlipangurla kirninyja ngunangani mapirrikarrajiwarntirla. Wali muwupungkurliparla nganpayiwu.” ");
INSERT INTO wmt_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Nyanartijangka kitangarni palupinya parlipinya kurriny nganpayijarra yinijarra Jawujapjaa Majayaj. Marnani palurlanyanu, “Kunyungurla parlipa Jawujap kurajpungku, kunyungurla Majayaj. Wali japirlyungku parliparla Ngarpu. ");
INSERT INTO wmt_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Nyantungu parlipangu takijulawu yinijartijarra. Layi parlipangu kurajpungku Ngarpungu, warrkampala parliparla yungku Jutajkura.” Wali purayimarni palupilangulu. Marni palurla Ngarpuwu, “Nyuntu man pinarri, kayan marnanpangu. Nyuntungu marnanpanya nyangany. Kayan ngarnangulu ranyjiwanti. Minyarti marnantalu japirrmanany nyuntu jarntungurru. Nyuntungu marnanpanya yungku piyirn layi kurajpungurla. Kurrinyku marnantalurla japirlyungany minyartijarrawu nganpayijarrawu yinijarrawu Jawujapkujaa Majayajku. Wanyjarra marnanpanya yungku yinijarti layi nganpayi.” Yarntarni palurla marni Ngarpuwu, “Jarlu pa ngangayani nganpayi Jutaj. Ngurrpa marnalurla wanyjurlaparta nguniny. Kunyungurla manyanu kujikani. Nganpayiwarlanyju kayantu parla kangku warrkam Jutajkura. Wayila marnanpanya yungku nganpayiwarlany warrkammayinwarlany.” ");
INSERT INTO wmt_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Wali nyanartijangka pamarrjarra yinijartijarra palupinya yutukani. Ngarpungu kurajpinya pamarr layi, nyanyala palu Majayajkura pamarr. Nyanartila Ngarpungu kurajpinya nganpayi Majayaj warrkampurru. Wali nganpayi nyanarti manyanangurla kirninyyani mapirrikarrajiwarntikarti pajilwarntikarti. Yarntarni palu ngunangani 12. ");
INSERT INTO wmt_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","2","Nyanartijangka palu Jesuskurawarnti nukarnini kirrarnani kayanta mayarurla kaninykaniny, yangkala manyanangurla kankarnimarrangu pirriyanani wangkirirrijarti walypajilinyparni purlkajilinyparni. Pinakarrinyala palu walypajiliny rangkurrmarnani. ");
INSERT INTO wmt_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Nyanganila palu tili ngalyukngalyukmarnani. Kula warlurni. Wali taawantinyala manyanangurla nukarnila tiliwarnti. Ngurrujarra ngurrujarra manyanangurla tili taawantinya. ");
INSERT INTO wmt_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Pirlurrula Ngarpukurajangkarlu manyanangurla takurryani mapunjinyangu, juntumanila manyanangurla, wangkijartikujirnila manya. Wangkila palu marnani kanarlanywarnti wangkiwarnti. Ngajirta palu wangki marnantarla jarlu yangkartiwarnti wangkiwarnti, jipinywarlany palu marnani wangki. ");
INSERT INTO wmt_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","11","Wali nyanartijangka palunyanangurla warrlaparni, yalartingurni yalartingurni palu pirripirriyani pinakarrinyupurru. Karrartajarrinya palunyanangurla wangkiwarntirla yangka palu paja marnani kujangkurrajarra. Kanarlanywarntirlu palurlanyanu nginyjirrikanani wangkiwarnti marrijangkawarnti. Japirlyungani palurlanyanu nyantuwarntirlu karrartarlu, “Nyangurlajangka wangkiwarnti minyartiwarnti. Nganangu manya pinayinya. Yangkakatarlipa Kalalikarrajimipa. Marrijangkawarntirlu marnalurlanyanu nginyjirrikarralany ngalimpakurawarnti wangkiwarnti jarntuwarnti marnanpangulu marnana. Marnana palu, nyapartukarra Ngarpu nguniny mayapari. Nyanarti palu marnana wangkiwarntiwarlanyngurni.” Nyanartiwarnti nganpayiwarnti palu Juwujwarnti marrijangkajinyangu ngurrawarlany ngurrawarlanyjangka kurlampaljangka kakarrampalkarraji kayirrampaljangka karlampalkarraji. Wali kajalurni palu pirriyani, jirnala palu pinakarrinya wangkiwarnti nyanartiwarnti marnujangkawarnti. ");
INSERT INTO wmt_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Purrpurrmarnila palu, nyanartila palunyanu japirlyungani, “Nyapartujangka palu marnana. Nyapartukarra parlipanyalu pinayungana minyartiwarntirlu piyirnwarntirlu. Minya palu marnana wangkiwarnti paja.” ");
INSERT INTO wmt_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Wali kanarlanywarntirlu palu jingkirti warralpungani, “Yarr palu wangarta marnana ngapajangka.” ");
INSERT INTO wmt_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Wali nyanartijangka Pita turtapinya. Jesuskurawarnti pajilwarnti kanarlanywarnti palu 11 mapirrirni ngunangani. Karrinyungurni manyanangu marnaninyirra Pitangu mayajinyangu. Jirrkirlikanani manyanangu jarrakparnaninyirra. “Piyirnwarnti jarntuwarnti, pinakarrilu. Kanarlanywarnti manta pirriyani marrijangkawarnti, kanarlanywarnti manta Jurujulumkarrajiwarnti. ");
INSERT INTO wmt_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Minyartiwarnti piyirnwarnti ngajirta palu wangarta marnana ngapajangkawarnti. Nyurrawarntirlu mantanya nyangany kularni palu wangartarni malany wangki nyanarti, minyartirni manpangu pirriyani Pirlurr Ngarpukurajangka. Ngapa pa ngarnupurru wangartawurra karuwarrajarti. Ngajirta kujarti. Jalarra parlipangu kumantajarti. ");
INSERT INTO wmt_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","17","Kujarti manta pinakarrilany marnujangka, yangka manyanangu Ngarpungu jarluwarlany marni pikawurra ngalimpakurawarntiwu kilakiwarntiwu, nyanartijangkala puraputtu parlipangu lani kurrumparla ngalimpawu pinalkarrapurru. Ngarpungu manyanangu marni, ‘Yangka ngurra kutajarriwu, kujartikarra marnanyanangu yipawu Pirlurr ngajukurajangka piyirnwarntiwu nukarniwu ngajungu Kuttu. Julawu palunyanangu wangki ngajukura jirnajangkawarntirlu piyirnwarntirlujaa marninwarntirlu. Pingkayiwarntirlu palu nyaku winkirrjilinyparni. Purrkuwarntirlu palu winkirrmananku.’” ");
INSERT INTO wmt_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","24","Yarntarni wangkiwarlany manyanangu marni Pitangu, “Nganpayi yangkarti Jesus Najuritkarraji Kuttu yiparni takingu. Warrkammarnani minyayirla parlipangurla ngalimparla, nyanyala manta nyurrawarntirlu. Nyanya manta yangka warrkammarnani Ngarpukurajawurlu mayangu. Wali pirlakujirni manta nyurrawarntirlu, tumaj ngajirta mantanya lamakujirla nyanartiwarnti kulipariwarnti, nyurrawarntirlu manta Jesus pirtinyikani pungupurru, ngajirta mantanyanangu jarrmarnantarla. Yijingu mantanya martarnani. Wali tarnikanila palu kankarni mananga, wanji pujujarrinya manangarni, yangkala Ngarpungu wanjikujirni. Jarti pa pirlangu tarrpartarni. Yulajpani pa Ngarpungu. Ngarpu parla pinarri nguja jarluwarlany, pungku palu Jesus nyanarti. ");
INSERT INTO wmt_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","32","Mapunparnila yiparni kankarnumarrangu pirlajarrinyupurru. Mapunparni wanjikujirni Jesus Ngarpungu, yangkala marnalu nyanya mapirrikarrajiwarntirlu nganamparlu. Kujarti manyanangu jarluwarlany Kuttu jularni ngalimpakurawarntiwu kilakiwarntiwu, nyapartukarra Jesus pa tikirr wanjikujiwu Ngarpungu. ");
INSERT INTO wmt_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","“Nyanartijangka kajalkajalkujirni Jesus Ngarpungu. Jalarra manyanta Ngarpunga kirralany yapinta mayakarti. Ngarpungu purlkakujirni, kirrarnukujirnila mayakarti, purlkala nguniny Jesus. Nyanartijangka Ngarpungu manyanta yiparni Jesusja Pirlurr nyantukurajangka. Jesusjula manpangu yiparni Pirlurr Ngarpukurajangka. Wali pirriyani manpanyarla Pirlurr Ngarpukurajangka, wangkijartikujirni manpanya. Nyanartijangka marnalu marnaninyirra. Wali nyanartirni wangki manta jalarra pinakarrinya kayanparni nyurrawarntirlu. ");
INSERT INTO wmt_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Jesusjal yangkarti purlka kajalkajal. Kajalkajalkujirni Ngarpungu, yiparni pa nyantukurajangka kajalkajalparnila manta pirlakujirni nyurrawarntirlu.” Wali tarruru manyanangu marnani Pitangu. ");
INSERT INTO wmt_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Wali Pitakurajangka wangkijangka palu purrpurrmarni. Munta palu yakurrjarrinya. Marni palunyanangu Pitawujaa kanarlanywarntiwu pajilwarntiwu. Japirlyinya palunya, “Nyapartujarriwu marnalu.” ");
INSERT INTO wmt_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pitangu manyanangurla jangkumani, “Walijal. Kurnakwantiwujal manta jalarrarni. Ngapangakujiwula marnanyalu. Jesuskurawarnti manta ngunawu, ngapangakujiwu marnanyalu yininga Jesusja. Julawu marnanyalu Jesuskurawarnti. Wajapungkula manyirrangurla yakurryakurrjangka. Rukalkula manyirrangurla yakurra Ngarpungu. Nyanartijangka manya yungkula Pirlurr nyantukurajangka. Takurryankula manyirrangurla Pirlurr Ngarpukurajangka, juntumankula manyirrangurla. Yiji manya Pirlurr yungku, ngajirta purtayan. ");
INSERT INTO wmt_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Jularni parlipangu Ngarpungu jarlu. Yipawu parlipangu yangkarti Pirlurr Ngarpukurajangka Juwujwarntiwu nukarniwujaa yapajirnanyunguwarntiwujaa kanarlanywarntiwu marrijangkawarntiwu, yangka parlipangu kurajpungany Ngarpungu.” ");
INSERT INTO wmt_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Wali ngajirta nyanartimipa wangki, kanarlany wangki mapirri manyanangu jularnani Pitangu, mapunwurrajinyangu pinakarrinyupurru. Lirrkarnpungani manya wangkijawurlu nyanartijawurlu, “Pinakarrilu. Kujikani mantanyanu Juwujwarntirlu Jesus pirlakujirnujangkarlu. Yangkarti manta pinakarriwu yangka mantanyanu kujikani. Wali partalurni manta Ngarpukarti kurnakwantiwu.” ");
INSERT INTO wmt_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Nyanartijangkarlu palu minymani wangki Pitakura pajangujinyangu. Kurnakwantinyala palu Ngarpukarti, ngapangakujirnanila palunya pajilwarntirlu. Ngapangajarrinyala palu paja marninwarntijaa nganpayiwarnti 3 jawujun. Nyanartijangkala palu mapirrijarrinya palunyanangurla mapirrikarrajiwarntirla. ");
INSERT INTO wmt_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ngunangani palu nukarnini, yangkala palunyanangu pinajularnani wangki pajilwarntirlu kanarlanywarntiwu Jesuskurawarntiwu. Pinakarrinyani palu nira. Miyi palu pinalkarrapurru ngarnani mapirrirlu nukarnirlu. Purayimarnani palu. ");
INSERT INTO wmt_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Warrkammarnani palu Ngarpukurajawurlu Pirlurrjawurlu, walila palunya wulyukujirnani mimijartiwarnti pajilwarntirlu. Nyangani palunya pajilwarnti kanarlanywarntirlu pajangu. Walila palu nyangungurla rayinjarrinyani yangka palunya wulyukujirnani mimijartiwarnti pajilwarntirlu. ");
INSERT INTO wmt_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","45","Nyanartijangka nira palu ngunangani mapirri Jesuskurawarnti nukarnini. Wali kanarlanywarnti palu ngunangani pamarr pajajartiwarntijaa mana pajajartiwarnti, yarnta mayarujartiwarnti. Kanarlanywarnti palu lamparnjartiwarnti. Wali purlkajartiwarntirlu palunya jalimkujirnani manawarnti nganapartu nganapartu mayaruwurti. Pamarrpala palu warntarnani. Nyanartijangkala pamarr palunya yungani mayarujangkawarnti lamparnjartiwarntijaa marlaljartiwarnti. ");
INSERT INTO wmt_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Wali warryanani palu mayarurlurra Timpullurra kumantawarlany kumantawarlany. Miyi palurlanyanu ngarnani mapirrirlu ngurrawarlany ngurrawarlany. Ngarrurtarlu palu ngarnani. Yungani palunyanu jangarrarlu miyijaa kuyi. Kujartikarra palu ngunangani. ");
INSERT INTO wmt_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Wirriyarlu palu nira parpayipungani Ngarpu nyantuwarntirlu. Wulyu palu jularnani, “Wulyujinyangu parlipangu ngalimpawu Ngarpu.” Jurujulumjangkawarntirlu palunyanangu wulyumarnani Jesuskurawarntiwu nukarnirlu. Wali kanarlanywarntila manya kurnakkujirnani Ngarpungu, mapunikanurla palunyanangurla kirninyyanila Jesuskurawarntirla. ");
INSERT INTO wmt_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Nyanartijangka Pitajaa Jun pila yani mayarukarti purlkakarti Ngarpukurakarti. Purayimarnukarti pila yani purangurla karlangurla. Nyanartikarra palu nira purayimarnani karuwarrarlurra purangu karlangurla Juwujwarnti. ");
INSERT INTO wmt_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Wali pirriyani pilanyanta nganpayirla kirrarnumartarla. Kirrarnani palkanga kirlingirrirla marnpa. Kirlingirri nyanarti palu Juwujwarntirlu jularnani yini jurnanykarra. Kumantawarlany kumantawarlany pa kirrarnani nganpayi nyanarti kirrarnumarta. Ngarntingarntimarnani manyanangurla pamarr piyirnwarntirla yangka palu tirrinyyanani nyanartipurtarra Ngarpukurakarti mayarukarti purlkakarti. Yawiyijarrinyanila palurla kanarlanywarnti, yunganila palurla pamarr. Wali nganpayi nyanarti pa kirrarnani lama kirrarnumarta warrkamngajirta. Yapajangkarni kirrarnumarta kujartirni ngunangani. Wali jatpankarra kangani palu wurna ngurrakarti tikirr. Yarnta kumantawarlany tikirrparni palu kangani nyanartikartirni mayarukarti jurnanykarrakarti. Ngurruwarlany pa kirrarnumarta. Kumantawarlany kumantawarlany palu jatpankarra kangani, kirrarnukujirnani palu kirlingirrirla ngarntimarnupurru. ");
INSERT INTO wmt_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Wali nyanartipurtarra pila yani nganpayijarra Pitajaa Jun. Ngarntimarni pilangurla, “Yarrwurti yungkajapila pamarr miyipurru.” ");
INSERT INTO wmt_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Wali jatparamani pila kankurnumarrangu. Karrinyungurnu pila nyanyangurra kirrarnujangka. Marnila parla Pitangu, “Kaj. Nyakajarranya.” ");
INSERT INTO wmt_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Wali pinakarrinya pinya nyanawurlu nyirnilyarlu. Marni parlanyanu, “Kunyungurla nganapartajapila yungku wulyu nyantujarrarlu.” ");
INSERT INTO wmt_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Nyanartijangka Pitangu parla marni, “Pamarr ngajirtajarti pajarra. Marlal. Ngajirta pajarra pamarr marta, yarrwurti pajarrarnanta yungku wulyujinyangu, yangkarti Jesuskura maya pajarrarnanta yungku. Yarrwurti turtapungka nyuntu, wurnala man yanku. Jesus Kurayijju manta tanyjikujiwu Najuritkarrajirlu.” ");
INSERT INTO wmt_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Wali Pitangu karrinyungurni ngarrpirtimani mayakartingurni. Ngarrpirtimanurla karrinyukujirni nganpayi nyanarti. Partalurnila jinajarra yarrpangkajarrinya, wali wulyujarrinyala. ");
INSERT INTO wmt_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Jamurn warlarrpirtijarra jina tanyjijarrinya, murtarni jarntakparni kankarral. Karrinyangurrala, kitpinyangurra, wali tirrinyyanila pilangurla nganpayijarrarla mayarurlurra purlkangkurra Ngarpukurarlurra. Rijikarra pa tirrinyyani ngarrurtajarrinyangurra. Ngarpula pa wulyujinyangu parpayipungani, “Ngarpu pa wulyujinyangu. Wulyukujirni paja nyirnilyajangka.” ");
INSERT INTO wmt_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Nyanya palu piyirnwarntirlu nukarnirlu nganpayi nyanarti. Wurnajarti palu nyanyangurra. Parpayipungani manyanangurlanyanu Ngarpuwu. ");
INSERT INTO wmt_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Nginyjirringinyjirrikanani palu yangkarti ngarntimanujuwal. Purrpurrmarni palu, mil palu purlkajarrinya, nyapartujangka yangkakata nira kirrarnani kirrarnu palkanga kirlingirrimartaji jurnanykarrarla. ");
INSERT INTO wmt_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Pirripirriyanani palu purrpurrmarnujangkawarnti marnpangurni yarntarni nyangupurru. Tarrpartarnani pinya nganpayirlu wulyujarrinyujangkarlu Pitajaa Jun. Karrinyani palu nyanayirlarni mayarurla kirlingarni. ");
INSERT INTO wmt_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","13","Yangka manya nyanyangurra Pitangu, kanarlanywarnti pirripirriyanani palunyanangurla, marnila manyanangu Pitangu, “Ngajukurawarnti jarntuwarnti. Nganajangka manta kujarti mil purlkajarrilany. Ngurrpa ngantarla Ngarpukurawu mayawu. Jesusjujal wulyukujirni minyarti. Nganajangkarlu marnanypanyalu nyangany nganampa. Ngurrpangu ngarnanypanyalu nyangany. Ngurrpa ngartantarla wulyukujirnupurru. Ngajirta pajarra ngajarrarlu wulyukujirla yangka pa Jesusju wulyukujirni. Ngajirta pajarra maya marta, yangka pa Jesusju maya martalany. Jesus yangkarti parlanyanu walaku nyantukura kajalkajalkujirni Ngarpungu ngalimpakurarlu, yangkawurti manta pinakanya Jesus tarrpartarnupurrujaa ngulikanupurru. Wali pa Jesus yulajpantarla Payilittu, yangkala mantarla jarrmarni. ");
INSERT INTO wmt_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","“Nyurrawarntirlurni manta ngulikani parntakayanparni. Nyanarti nganpayi Jesus mapunparni nguniny munta kayan parla Ngarpuwu wulyujinyangu. Mapunikani parla Jesusju Kutku. Nyurrawarntirlu manta parnkapungurla ngulikani. Payilittu pa Jesus yulajpantarla, nyurrawarntirlu mantarla japirlyinya nganpayiwarlany yulajpanuwu. Purapij manta yulajpani yangkarti pungujuwal. ");
INSERT INTO wmt_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ngulikani manta Jesus, nyanartila palu tarnikani mananga, yangkala pirlajarrinya nyanarti wanji yungujuwal. Ngarpungula wanjikujirni. Nyanyala marnalu mapirrikarrajiwarntirlu nganamparlu. Jalarrarni marnalu julalany nyanarti wanjikujirnujangka. ");
INSERT INTO wmt_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","“Wali Jesus parlipangu mayapari mapunjinyangu. Nyantukurarlu mayangu Jesuskurarlu pa wurnajartikujirni nganpayi minyarti kirrarnujangka. Mapunikani parla nganpayirlu kirrarnumartarlurni, nyanartijangkarlula karrinyukujirnila Jesusju. Wayila manta nyangana nganpayi minyarti. Mapunikani parla Jesusku. Wali Jesusjula wulyukujirni jalarrarni manta nyangana.” ");
INSERT INTO wmt_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Yarntarni manyanangu marni Pitangu, “Wali ngurrpangurrparlu palu Jesus ngulikani purlkawarntirlu Juwujwarntirlu. Nyurrawarntirlu mapirrirlu manta ngurrpangu ngulikani. Ngajirta mantarla pinarri ngunarla Jesusku. ");
INSERT INTO wmt_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Nyurrawarnti mantarla ngurrpa ngunangani, ngajirta Ngarpu. Nyantungu manyanangu jarluwarlany jularni puraputwarntiwu nyapartukarra manta nyurrawarntirlu Jesus Kurayij pirlakujiwu. ");
INSERT INTO wmt_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Puju manta nguniny kurntayi jalarra, kurntayikarra manta kurnakwantiwu Ngarpukarti. Ngarpungula manyirrangurla wajapungku kurntayijaa yakurryakurr.” ");
INSERT INTO wmt_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","2","Wali kanarlanywarntirlu palurla yakurrmarnani wangkiwu nyanartiwu yinijartiwarntirlu Tajujiwarntirlu. Minyartiwarntirlu Tajujiwarntirlu palu nira pinapinakarrinyani piyirn nganawurti kayan ngarta turtangka pirlajangka marlaljinyangu. Nyanartijangka palupilangurla panypungani Pitangajaa Junta wangkingarni, jularnani pilanyanangu pirlajangka pa Jesus wanjijarrinya. Wali pilanya pinalkarra jularnani, “Mapunwurra marnalu nyanya Jesus turtangujangka, walimpa parlipa kirlingalparni turtangku nyantujiliny pirlajangkawarlanyparni.” Nyanartijangka Pitangu warrarni manyanangu jularnani wangki Juntu mapirrirni, yangkala palu pirriyanani wangkingarni Tajujiwarntijaa puriswarntijaa nganpayi limpajiliny layi. Maja parla mayaruwu purlkawu Ngarpukurawu ngunangani limpajiliny. Wali pirriyani palupilangurla Pitangajaa Junta. Kulijarrinya palu. Yakurrmarnani palupilangu Pitajarrawu Junku marnujangkawu. ");
INSERT INTO wmt_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Tarrpartarnila palupinya piyirnwarntijangka. Karuwarrarla palupinya tarrpartarni, yangkala palupinya yutukani jayilla. Kangkarla palupinya partalurni majawarntikarti japirlyungupurru, yangkala jarlu karuwarrajarrinya. Walila palupinya yutukani jayilla kumantapurru. ");
INSERT INTO wmt_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Wali mapunikanila palu kanarlanywarntirlu pajangu wangki Pitakurajangka jularnujangka, yarnta Junkurajangka, yangkala palu kurnakwantinya Jesuskarti. Wali Jesuskurawarntila palu nyanartikarrarni pajajarrinyajinyangu, 5 jawujunjarrinya palu. ");
INSERT INTO wmt_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Nyanartijangka kumanta pila nyanayirlarni ngunangani jayilla. Martarnani pinya limpangu. Wali Juwujwarnti purlkawarnti majawarntijaa kurayipwarnti palupilangulu warryani japirlyungupurru Jurujulumja. ");
INSERT INTO wmt_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Marni palurla limpawu, “Purpantapinya nyanartijarra nganpayijarra.” Wali pirrikanya pinya Pitajaa Jun limpangu. Marnpa palupinya karrinyukujirni. Japirlyinya palupinya, “Nyapartukarra manpila wulyukujirni nganpayi kirrarnumartajangka. Wanyjarrajangka manpila maya martalany. Ngana yini manpilarla jularni wulyukujirnupurru.” ");
INSERT INTO wmt_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Wali nyanartijangka Pirlurrjawurlu Ngarpukurajangkajawurlu manyanangurla jangkumani Pitangu. Marni manyanangu, ");
INSERT INTO wmt_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","10","“Jarntuwarnti ngajukurawarnti purlkawarnti. Wali japirlyungany mantarranyalu nyurrawarntirlu. Ngajirta marna ngajungu wulyukujirla, yangka pa Jesusju wulyukujirni. Julawu marnanyirrangu minyarti maya pa Jesuskura Najuritkarrajikura. Jesus yangkarti manta pirlakujirni nyurrawarntirlurni, Ngarpungula wanjikujirni. Nyantukura yini pajarra julalany Jesuskura yini wulyukujirnupurru. Jesusju pa wulyukujirni. Jalarrarni manta nyangany nganpayi minyarti karrinyujangka. Jesuskurarlu mayangu pa kirrarnumartajangka karrinyukujirni. ");
INSERT INTO wmt_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Yarnta nyantungurni parlipanya pirlurr wanji yungany kujawurlurra Jesusjumipa. Kayan ngarlipanya ngananguwurti yungka, nyantungumipa kayantu Jesusju. Nyantu pa kayan.” ");
INSERT INTO wmt_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Wali purlkawarnti palu purrpurrmarni tumaj pila jularnani wangkiwarnti purrurtuwarnti. Ngurrpa pilarla kurrumpawu, ngajirta pila pinarrijarrirla kuwulla. Wali nginyjirrikani palupinya minyartijarra pila Jesuskurajarra mapirrikarrajijarra. Jesusju pinya pinarriyinya nukarnini. ");
INSERT INTO wmt_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ngulikanupurru palu nguja. Ngulikarrarla palupinya nganpayijarra yinijarra Pitajaa Jun, yangkala palu nyanya wulyukujirnujangka kirrarnumarta pila wulyukujirni. Mapirri palu karrinyani. Kulkururlu palu pinakarrinyani, yangkala palurla jarti pinakarrinyani wangkiwu marnupurru. ");
INSERT INTO wmt_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Marni palupilangu, “Yantapila palkakarti. Wangki marnalu malku nganampamipa.” Wali tirrinyyani pila. Karrinyani pila palkanga. ");
INSERT INTO wmt_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Japirlyungani palunyanu, “Nyapartukujiwu parlipinya minyartijarra nganpayijarra. Minyajal palupinya nyanya pajangu Jurujulumkarrajiwarntirlu mapirri wulyukujirnujangka. Mapunparni pila wulyukujirni ngurruwarlany kanarlanyparni. Kayan ngarliparla jirnapungka yangka parlipinya tampi nyanya. ");
INSERT INTO wmt_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Jarrmalku parlipilangu minyartijarrawu nganpayijarrawu. Puju ngarlipa yarr kirranyja kulkuru, yangkala ngartapilanyanangu jularnanta Jesus, mapunikarrarla ngartalurla pajangu piyirntu. Minyarti parlipilangu malku, ngajirta ngartapila Jesus jularnanta yarnta. Ngajirta ngartapilanyanta Jesusja yarringarnanta mayanga.” ");
INSERT INTO wmt_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Nyanartijangka tikirrkujirni palupinya. Marni palupilangu, “Wayila manpila lamajarriwu jalarra. Kanarlanywarntiwu ngajirta nganpilanyanangu yarnta Jesus jularnanta. Ngajirta nganpilanya pinarriyunganta Jesuskurajangka wangki. Ngajirta nganpilanyanta Jesusja yarringarnanta mayanga. Wali manypilangurla ngaapalku.” ");
INSERT INTO wmt_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","20","Marnila pilanyanangu, “Nyurrawarnti manta pinangurruwarnti. Kaj nganawu pajarrarla mapunikarrku. Kunyungurla Ngarpuwu, kunyungurla nyurrawarntiwu. Julalu. Wali mapunikarralany pajarrarla Ngarpuwu, tumaj pajarranyanta pinakarrinyani Jesusja wangki marnujangka. Yarnta mapirri pajarranyanta ngunangani Jesusjarni. Nyantungu pajarranya pinarriyungani. Yarnta pajarra nyanya Jesus turtapungujangkajaa mapunikani pajarranyanta. Kayan ngajarrarnanyirrangu mapunikarra nyurrawarnti piyirnwarnti. Ngarpumipa pajarra mapunikarrku.” ");
INSERT INTO wmt_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","Jarrmarni pilangulu purlkawarntirlu. Kulikulijarrinya pilangulu purlkawarntirlu. Mapunikarrarla pilanya nyantuwarnti purlkawarnti. Jarrmarnurla palupinya yulajpani jayillajangka, palkangala pila ngujangurra. Kayan ngalupinya jayilla martarla, tumaj palupilangu piyirnwarntirlu pajangu wulyumarnani Jurujulumkarrajiwarntirlu. Ngarpula palu parpayipungani nukarnirlu nyantujarrangurni. Marnani palu, “Nganpayi nyanarti pa Jesusju wulyukujirni jamurnku purrkuwu yitilalwarnti 40 pa ngunangani.” Nyanartijangka jartila palu purlkawarntirlu pinakarrinya nganangurni palupinya yutukarrarla jayillajaa pungkarla pinyalu kuli. ");
INSERT INTO wmt_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Nyanartijangka yani pilanyanangurla nyantujarrakurarlurra Jesuskurawarntirlurra. Jularnanila pilanyanangu wangki, nyapartukarra palupinya marrkukani. ");
INSERT INTO wmt_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Jamurn palu pinakarrinya nyanarti wangki nyapartukarra palupinya marrkukani, wali purayipurayimarnani palurla Ngarpuwu Jesuskurawarntirlu. Marnani palurla Ngarpuwu, “Nyuntu man purlka, nyuntu man kayan. Jarlu marnanpangu ngartakpani yalkirijaa nguwa, kuyiwarntijaa piyirnwarnti, miyiwarntijaa ngapa. Purlka marnanpangu nyuntu nguniny. ");
INSERT INTO wmt_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","“Nyuntu marnantalu jalarra japirrmanana yangkarti marnapanyalu marrkukani piyirnwarntirlu. Nyuntukurangurni wangkingurni marnapanyalu marrkukani. Wali nyuntungu manyanangu pinarri nyapartukarra marnapangulu marni minyarti. Jarlujangka manurla pinarri ngunangani kuliwu minyartiwu. Jamulu marnapangulu jarrmarni, nganamparlu marnalunyanangu nyuntukura wangki jularnanku jutungurni. Purnkukujirnanpanya, nyuntula marnantalu jularnanku purnkungu. ");
INSERT INTO wmt_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Nyuntungu marnanpanya maya yungku, yangkala marnalunya wulyukujiwu mimijartiwarnti yini Jesus jularnurla. Piyirnwarntirlula palunya nyaku wulyukujirnujangka, malkula palu, ‘Minya kujala mapun Jesus Ngarpukura walaku mayakujirnujuwaljaa wulyukujirnujuwal.’” ");
INSERT INTO wmt_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Yangka palu karrkarni purayimarnujangka, ririmarni mayaru nyanarti. Ririmarninyirra. Yarntarni manyanangurla takurryani Pirlurr Ngarpukurajangka, yangkala manya tipani Pirlurru Ngarpukurajangkarlu. Nyanartijangka jularnani palunyanangu Ngarpukura wangki purnkungu. Ngajirta palu rayinkarrirla. ");
INSERT INTO wmt_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Wali kayanparni palu pinakarrinyani milyilyi kayantajarrinya palu. Kayanparni palu ngunangani. Ngajirta palu ngurrungurru ngunangantarla. Yungani palunyanu manawarnti jangarrarlu. Ngajirta palurlanyanu martarnantarla, ngajirta palurla mururrmarnantarla nyanartiwarntiwu manawarntiwu. Yungani palunyanu Jesuskurawarntirlu. ");
INSERT INTO wmt_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Pajilwarntirlu palunyanangu jularnani piyirnwarntiwu kanarlanywarntiwu nyapartukarra Jesus turtapinyajaa wanjijarrinya. Ngarpungu manya marlamanani Pirlurru Ngarpukurajangkarlu mayakujirnani manya. Ngajirta palunyanangu yakurrmarnantarla Jurujulumkarrajiwarntirlu, wulyumarnani palunyanangu Jesuskurawarntiwu. ");
INSERT INTO wmt_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Wali kanarlanywarnti Jesuskurawarnti palu ngunangani pamarr pajajartiwarntijaa mana pajajartiwarnti, yarnta mayarujartiwarnti. Mayaruwarnti palunya martarnani. Jalimkujirnanila palunyanangurla mayaru, pamarrpala palu warntarnani. Nyanartijangka pamarr palunya yinya mayarujangka pajilwarnti kanarlanywarnti yungupurru marlaljartiwarnti, yungkula palunya pajilwarntirlu. Nyangani palunya marlaljartiwarnti. Parlipungani palunya pajilwarntirlu, “Yu. Minyarti kayan, yungku parliparla.” Yunganila palunya marlaljartiwarnti. Nyanartijangka ngajirta layiwurti marlal ngunarla. Pujurnila palu nguja pamarrjartiwarnti Jesuskurawarnti piyirnjaa marninjaa yapa. ");
INSERT INTO wmt_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","37","Layi nganpayi manyanangurla ngunangani Jesuskurawarntirla yinijarrajarti kurrinyjarti yini Panapajjaa Jawujap yinijarra kurriny pinya martarnani. Pajilwarntirlu palu jularnani Panapaj Wirriyakujirnujuwal. Martarnani pa mayaru Panapajju Wirriyakujirnujuwallu. Jalimkujirnila manyanangurla Panapajju kanarlanywarntirla, pamarrpala warntarni, yinyala manya pajilwarnti pamarr mayarujangka. Kanarlanywarntila palunya yungku pajilwarntirlu marlaljartiwarnti. ");
INSERT INTO wmt_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Nganpayiwarlany ngunangani Yananayaj kanarlanyparni ngajirta Panapajjiliny. Kartujarti pa nyantu yini Jipayira. Jamirlangurlu pila martarnani mayaru kurrinyju. Nyanartijangka jalimkujirnila Yananayajju mayaru manyanangurla kanarlanywarntirla, pamarrpala warntarni mayarujangka. ");
INSERT INTO wmt_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Pamarr nyanarti warntarni mayarujangka. Nyanartijangka kanarlanywarnti pamarr manya yinya pajilwarnti, kanarlanywarnti martarnani parlanyanu nyantungu. Marni manyanangu, “Minyarti marnannya yungana pamarr pujurni,” marni manyanangu pajilwarntiwu Pitawu mapirri, yungkula manya marlaljartiwarnti. Yirri manyanangu marni. Kajiyinya manya pajilwarnti. Ranjikujirni pilarlanyanu kanarlanywarnti pamarr jamirlangurlu. Martarnanila pilarlanyanu pamarr. Ngajirta pa ranji martarla nganpayirlumipa Yananayajju. Kartunyankura mapirrirni parla pinarri nguja nyanartiwu pamarrku ranyjikujirnujangkawu. ");
INSERT INTO wmt_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pitangu parla marni Yananayajku. Taj jularni parla yini. Marni parla, “Nyapartujangkarlu manpanya kajiyinya. Pirla mangurla takurryani, pinakarrinya manyanta pirlanga. Ngajirta man ngunyipungkarla pirla, wulyumarnani mankurla pamarrku nyuntungu. Nyanartijangka pamarr mankurlanyanu ranyjikujirni karlpurrwarlany nyuntungu. Nganajangka marnanpangu marni, ‘Minyarti pamarr marnanya yungana pujurni.’ Nyuntukura pamarr wali. Yangkala man murlanpinya. Ngajirta manpangu manyjarla karlpurrwarlany martarnupurru nyuntungu. Pirlurrku Ngarpukurajangkawu manurla yirri marni.” ");
INSERT INTO wmt_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Yarntarni parla marni Pitangu, “Ngajirta marnantalu japirlyungka pujurni pamarr yungupurru. Minyarti mayaru mangu nyuntukura. Wali mankurlanyanu jalimkujirni. Pamarr mankurlanyanu warntarni, wali nyanarti, martarla mankurlanyanu kalara pamarr kalpurrwarlany. Minya manpangu marni pujurni manpanya yungkarla, kujartikarra manpangu marni kalpurrwarlany mankurlanyanu ranyji martarni. Nganajangkarlu man pirla mapunikani. Mapunparni man kajiyinya Ngarpu. Ngajirta marnanpanya kajiyungkarla piyirnwarnti nganampa. Kajiyinya mankurla Ngarpu.” ");
INSERT INTO wmt_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","6","Jamurn pinakarrinya wangki nyanarti Pitakura, wantinyala murtarni. Pirlajarrinyala. Wali pingkayiwarntirlula palunyanta kutikani, kanyala palu nguwakarti turnmanila palu. Wali jularni palunyanangu nganpayi nyanarti Yananayaj wantinyujangka pirlajarrinyujangka. Pinakarrinyurla palu rayinjarrinyala. ");
INSERT INTO wmt_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Marnin parla kartunyankura ngurrpa ngunangani. Ngajirta yinki, yarr partalurni pirriyanila manyanangurla kayantarni purangurla. Ngurrpa manyanangurla pirriyani pajilwarntikarti. ");
INSERT INTO wmt_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Japirlyinyala Pitangu. Kujartikarra parla marni. “Japirlyungku marnanta. Pujurni ngarnanpanyapila yinya pamarr mayarujangka jalimkujirnujangka.” “Yu,” marni parla marnintu. “Pujurni pajarrarnanya yinya.” ");
INSERT INTO wmt_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Yarntarni Pitangu parla marni, “Nganajangkarlu manpila Pirlurr Ngarpukurajangka kajiyinya. Kula walirni manpila ranyjikujirla pamarr, minyangurru manpinya Pirlurru Ngarpukurajangkarlu nyanya. Wali pirlajarrinya pa nyuntukura ngumparna, turnmani palu pingkayiwarntirlu. Tikirryanana palu jalarra, pinakarrinyana marnanya pingkayiwarnti, nyuntula mantalu warntawu pirlajarrinyujangka jalarra.” ");
INSERT INTO wmt_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Wali murtarnila manyanta wantinya jinanga nganpayirla Pitanga, pirlapalajirnila yukarnani. Pingkayiwarntila palu pirriyani, nyanyala palu marnin. Warntarnkanyala palu pirlajarrinyujangka. Nguwakartila palu kanya turnmanupurru ngumparnarlarni marnparni, turnmanujangkajarrala pila nguja kurrinyparni. ");
INSERT INTO wmt_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Nyanartijangka rayinjarrinyala palu Jesuskurawarnti piyirnwarntijaa kanarlanywarnti mapirri. Pinakarrinya palupinya jamirlangu pirlajarrinyujangka, wali pujurnila palu rayinjarrinya. ");
INSERT INTO wmt_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Nyanartijangka pajilwarntirlu palunya wulyukujirnani mimijartiwarnti piyirnwarnti, yangkala kanarlanywarntirlu palunya nyanya Ngarpukurajartiwarnti mayajartiwarnti. Wangkikarra palu nira kirrarnani mayarurla Timpulla. ");
INSERT INTO wmt_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Kanarlanywarnti piyirnwarnti ngajirta palunyanangurla kirniny yanantarla, tumaj palu karrartajarrinya. Ngajirta palunyanangurla yanantarla kanarlanywarnti, walirni palunyanangu wulyumarnani. ");
INSERT INTO wmt_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Wali kanarlanywarntirlu pajangu palu Jesus mapunikani piyirnwarntirlujaa marninwarntirlu, yarnta palunyanta mapunikanani kujangkurrarni kujangkurrarni pajangu. Mapunikanujangkarlu palunyanangurla mapirrijarrinya Jesuskurawarntirla. ");
INSERT INTO wmt_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Jurujulumjangkawarntirlu palunya kanarlanywarntirlu nyangani pajilwarnti, wulyukujirnani palunya mimijartiwarnti. Nira palu kujartikarra ngunangani. Nyanartijangka jarntuwarntirlu palunya kangani mimijartiwarnti kanarlanywarnti. Warntarrirla marnpa palunya yutukanani. Kangani palunya pirlangkirrjarti, yutukananila palunya pirlangkirrjarti. Jurumanani palurla Pitawu wulyukujirnupurru. Yangka kaji Pita marnpa pirriyanku, wali wangarr manyanta wuwuyanku mimijartirla. Kujarti palu pinapinakarrinyani, puju manyanta Pitakura wangarr ngunarla piyirnta, wulyujarriwula. Yangkala palunya kanya warntarrikarti wangarrpurru wulyukujirnupurru. ");
INSERT INTO wmt_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Yarntarni palunya kangani kanarlanywarnti mimijartiwarnti Jurujulumkarti mayaru lamparnwarntijangka. Jurujulumjarni palunyanta mayaruwarnti wamarn karrinyani lamparnwarnti. Kangani palunya pajangu mimijartiwarntijaa kanarlanywarntirla manyanangurla pirla takurryani. Jarlu manyanangurla takurryani, kanganila palunya jarntuwarntirlu. Wali kanyala palunya Jurujulumkarti wulyukujirnupurru pajilwarntikarti. Mimijartiwarnti palunya wulyukujirnani nukarnini yarnta pirla takurryanujangka palunyanangurla jurramanani. ");
INSERT INTO wmt_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Pinakarrinya palunya, purisju purlkangujaa nyantukurawarntirlu yiniwarntirlu Tajujiwarntirlu. Pinakarrinya palunya pajilwarnti yangka palunya wulyukujirnani mimijartiwarnti. Wali yurrulyjarrinya palunyanangu pajilwarntiwu. Nyanartijangka palu warryani wangki palunyanu yungani. Yurrulyjarrinya palunyanangu. Marnani palurlanyanu, “Yutukarrku parlipanya jayilla.” ");
INSERT INTO wmt_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Wali tarrpartarnila palunya, takurrkujirnila palunya mayarurla jayilla. Rukukani palunya mayarurla kaninykaniny. Kirlingirri palu rukukani tirrinyyanurlamarra. ");
INSERT INTO wmt_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Wali pukanyjajarrinya manyanangu. Pirriyani manyanangu pukanyjajarti yinjil Ngarpukurajangka. Warijpanila manyanangu nyanarti kirlingirri. Ngarrpirtikanyala manya yinjillu palkakarti. Nyanarti kirlingirri palu tirrinyyani. Marni manyanangu yinjillu, ");
INSERT INTO wmt_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Yantalu mayarukarti Timpulkarti. Wangki mantanyanangu julawu Jesuskurarlal yanuwu wanjingal kujawurlurra.” ");
INSERT INTO wmt_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Mapunparnila palu yani Timpulkarti. Mapunikani palu yinjil. Wali kumantajarrinya, rakarrarla palu takurryani mayarurla Timpulla, pinajularnani palunyanangu wangki Jesuskura. Nyanartijangkarlu purlka nganpayi purisjaa kanarlanywarnti nyantukurawarnti piyirnwarnti palu kirrarnani wangkikarra. Yarnta kanarlanywarnti palunya warntarni Juwujwarntikura majawarnti. Nyantuwarnti palu kujartikarra warryanani nira pinapinakarrinyanupurru jirrkirl ngunangupurru. Jirrkirlkujirnani palu wangki. Wali marurrpinyala palunya pajilwarntipurru ngulikanupurru. Kirrarnani palu wangkikarra. Nyanartijangka palunya yiparni limpawarnti jayilkarti pajilwarntikarti purpanupurru, kangkula palunya majawarntikarti wangkipurru. Wali limpawarnti palu yani jayilkarti pajilwarntikarti purpanupurru. ");
INSERT INTO wmt_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Takurryanila palu jayilla, jarti palunyanangu nyanya mayaru. Tikiyanila palu wangkijarti majawarntikarti. ");
INSERT INTO wmt_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Jirnapinyala palunyanangu limpawarntirlu, “Takurryani marnalu yangkartirlarni jayilla. Jarti marnalunyanangu nyanya mayaru, yangkarti palu nguja. Tikiyanila marnalunyirrangu wangkijarti purlkawarntiwu. Jirnapungana marnalunyirrangu jalarra. Parlipinyala marnalu, rukjartirni ngujangurra kirlingirri tuwa jatarni, ngajirta kirlingirrijarrirla. Yarnta marnalunya parlipinya limpawarnti ngampurrjiwarnti. Warrarni palu ngampurrikanani. Kula palu warrarni ngunangani pajilwarnti nyanayirla mayarurla. Wali nyanartijangka marnalu larntakpani kirlingirri, takurryanila marnalu. Jartila marnalunyanangu nyanya pajilwarntiwu marlal. Ngurramipa marnalu nyanya.” Wali kujartikarra palunyanangu jularni majawarntiwu limpawarntirlu. ");
INSERT INTO wmt_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Wali karrartajarrinyala palu purlkawarnti, yarnta nganpayiwarlany maja parla mayaruwu Timpulku. Marnani palurlanyanu purlkawarntirlu, “Nyapartukarra palu pajilwarnti tirrinyyani.” ");
INSERT INTO wmt_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Nyanartijangka layi nganpayi yani Timpulkarti. Parlipinyala manya pajilwarnti. Wangki palunyanangu jularnani Jesuskura kanarlanywarntiwu piyirnwarntiwu mayarurla Ngarpukurarla. Nyanartijangka yanila manyanangurla purlkawarntikarti, jakuljularnila manya pajilwarnti. Marni manyanangu purlkawarntiwu, “Pinakarrilu, kulkurujarrilu. Wangki marnanyirrangu julawu. Yangkartiwarnti nganpayiwarnti yangka palu yap yani jayillajangkawarnti jalarra marnanya parlipinya Ngarpukurarla mayarurla purlkanga. Wangki palunyanangu marnana Jesuskura kanarlanywarntiwu piyirnwarntiwu.” ");
INSERT INTO wmt_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Wali yanila palu maja Timpulpurrujaa limpawarnti nyantukurawarnti, pirriyani palunyanangurla. Warntarnila palunya yuntangu. Tarrpartarnila palunya yuntangu yarr rayinkarrarlu. Rayinkarrinyani palunyanangurla, tumaj palu paja kirrarnani kanarlanywarnti piyirnwarnti. Wulyumarnani palunyanangu pajilwarntiwu, yangkala ngalunya limpawarnti luwarla pamarrjawurlu pirlawurra. ");
INSERT INTO wmt_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Wali limpawarntirlu palunya kanya pajilwarnti purlkawarntikarti. Kaparnpala palunya karrinyukujirni ngulikanupurru. Purlkawarnti palu kirrarnani. ");
INSERT INTO wmt_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Marnila manyanangu purlkangu purisju pajilwarntiwu, “Jarlu marnalunyirrangu jarrmarni, ngajirta nganta Jesuskura wangki jularnanta. Jartirni. Ngajirta manpangulurla mapunikarrarla. Jutungu mantanyanangu jularnani Jesuskura wangki, yangkarti marnalunyirrangu jarti jarrmarni.” Yarntarni manyanangu marni purlkangu purisju, “Jularnani mantanyanangu pujuwurni Jurujulumkarrajiwarntiwu, yangkala palu nukarnirlu pinakarrinyana wangki Jesuskura jularnujangka. Yarnta jakuljularnani marnanpanyalu nganamparlu Jesus pirlakujirnujangka.” ");
INSERT INTO wmt_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Nyanartijangka pajilwarntirlu palunya jangkumani. “Ngajirta. Kayan ngarnalu nganakurawurti mapunikarra piyirnwarntikura. Mapunikarralany marnalu Ngarpukuramiparni wangki. Nyanarti marnalu kayan Ngarpukura mapunikarrku.” ");
INSERT INTO wmt_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","31","Yarntarni palunyanangu marni purlkawarntiwu pajilwarntirlu, “Ngarpu parlipangu jumangkarnijangka jarluwarlanyjangka. Kilakiwarntirlu palu jarlu wajilpungani Ngarpu. Wali Ngarpungu pa Jesus wanjikujirni. Jarlu manta ngulikani Jesus yangkarti, nyanartila palu tarnikani mananga, yangkala pirlajarrinya. Nyanartijangka Ngarpungu ngalimpakurarlu wanjikujirni. Kankarnikujirni Jesus Ngarpungu, kankarnila jalarra kirralany, purlkakujirni Ngarpungu Jesus. Jalarra manpangu nguniny kurnakwantinyujangkawu, yangka nganawurti kurnakwantilany. Wali Ngarpungula parlipangurla wajapungany yakurryakurr Juwujwarntirla nganamparla, yangka parlipa kurnakwantilany. ");
INSERT INTO wmt_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Kujartikarra marnalu julalany Jesuskura wangki nganamparlu pajilwarntirlu yarnta Pirlurru Ngarpukurajangkarlu mapirrirlu. Puju parlipa mapunikarralany Ngarpu, wali Pirlurr Ngarpukurajangka parlipangurla takurryanany, yipalany Ngarpungu, takurryananypala parlipangurla.” ");
INSERT INTO wmt_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Yarnta palunyanangu pajilwarntirlu jularnani jirrkirl janginyjurra palunyanangu jularnani. Wali wirrilyijarrinyala palu, kulijarrinya palu nyanartiwarnti purlkawarnti. Pungkarla palunya pirlawurra pajilwarnti. Wali wangkila palu marnani nyanartiwarnti purlkawarnti pungupurru. Pungkarla palunya pirlawurra pajilwarnti. ");
INSERT INTO wmt_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Wali nganpayi layi yangka manyanangu ngunangani jarlu pinayungujuwal pinangurrujinyangu. Mujijkura wangki jarlujangka manya pinayungani. Paraji pa nyantu, yini parla Kamaliyal. Juwujwarntirlu palurla wulyumarnani nyanartiwu nganpayiwu pujungurni, tumaj pa pinangurrujinyangu. Nyanarti nganpayi turtapinya wangkijarti. Nyanartijangka marnila manyanangu limpawarntiwu, “Kangku mantanya pajilwarnti. Kirralkula palu marri pakul. Ngajirta ngalu pinakarri minyarti wangki.” ");
INSERT INTO wmt_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","39","Jamurn palunya kanya, wali wartangurnila manyanangu jularnani purlkawarntiwu Kamaliyallu, “Kulkurujarrilu ngajukurawarnti. Wangki marnanyirrangu julawu, pinakarrilu. Ngajirta ngantanya partalurni pungka. Kunyungurla manta warrarni pinapinakarrinyanku. Kunyungurla palu minyartiwarnti Ngarpukura. Kunyungurla Ngarpungu manya marlamananyjaa maya manya yungany nyantukura.” Yarntarni manyanangu marni, “Julawu marnanyirrangu nganpayijarra kajalujangkajarra. Pina tikiyantalu. Jarlu nganpayiwarlany pirriyani nganpayi kajalurni. Wali kajalkajalkujirlala manyanu, purlka manyanu jatikarrarla. Jularnani manyanangu piyirnwarntiwu, ‘Ngaju marnanyirrangu maja ngunawu. Ngaju marna wulyujinyangu purlka.’ Wali wajilpinyala palu pajangujinyangu 400tu piyirnwarntirlu. Nyanartijangka nganpayi nyanarti palu pinya kanarlanywarntirlu pirlawurra. Nyanartiwarnti piyirnwarnti ngajirta palu warramarta ngunarla, pulykarra yanila palu kujangkurrajarra. “Nyanartijangka nganpayiwarlanypala pirriyani kanarlany. Wali kajalkajalkujirnila manyanu nyanartirlu nganpayirlu kirlingalparni nyanartijilinyju yangka nganpayiwarlanyju manyanu kajalkajalkujirni, wajilpinyala palu pajangu piyirnwarntirlu. Nyanartijangka pinyala palu kirlingalparni nyanartijilinyparni nganpayiwarlany yangka palu jarlu pinya kajalkajal. Nyanartijangka palu pulykarra yani piyirnwarnti kirlingalparni. Wali nyanartijarrarlu pilanyanu kajalkajalkujirnani nyantujarrarlu. Ngajirta pinya Ngarpungu marlamantarlajaa ngajirta pinya kajalkajalkujirla. “Wali minyartiwarnti pajilwarnti kunyungurla palunyanu kajalkajalkujilanywarlanyparni nyanartijarrajilinyjurni nganpayijarrajilinyjurni. Puju Ngarpungu ngajirta manya marlamanta, pujujarriwula palu nyanartijarrajiliny nganpayijarrajiliny kirlingalparni. Yarnta kunyungurla palu kanarlanyparni nganpayijarrajilinyngajirta. Kunyungurla Ngarpungu manya marlamanany pajilwarnti. Puju Ngarpungu manya marlamananyjaa maya manya yungany Ngarpungu, kayan ngantanya nyurrawarntirlu lamakujijaa kulkurukuji.” Lirrkarnpungani manya Kamaliyallu purlkawarnti, “Warrarni ngajirta ngantanya pungka partalurni. Puju ngantanya pungka, Ngarpungu nganya purntumanta.” Wali mapunikanila palu nyanarti manyanangu jularni wangki Kamaliyallu. Ngajirta palunya pirlawurra pungkarla. ");
INSERT INTO wmt_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Nyanartijangka palunya purpani nyanartiwarnti pajilwarnti palkangajangka. Nyanartijangka palunya jinjinyinya purlkawarntirlu kulipariwarnti wijkarrapungupurru. Wali wijkarrala palunya pinya kulipariwarntirlu. Pinya palunya wipjawurlu. Nyanartijangka yarntarni purlkawarntirlu palunyanangu jarrmarni pajilwarntiwu. Marni palunyanangu, “Ngajirta ngantanyanangu kanarlanywarntiwu Jesus jularnanta.” Yiparnila palunya, ngajirta palunya yarntarni yutukarrarla jayilla. ");
INSERT INTO wmt_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Wali pajilwarntirlu palurlanyanu marnani wurnangu, “Kuttu parlipanya jamulurni puturu nyanya, yangka kanarlanywarntirlu parlipangulu jarrmarni, yarnta kurntayimarni parlipangulurla pajanga milla. Wijkarrala pinya parlipanyalu. Ngajirta parlipanya Ngarpungu purntumantarla. Nyanya parlipanya jirrkirljinyangu parliparla nguniny nyantuwu Jesusku, nyanartila parlipangu pikajarrinya.” Nyanartijangkala palu pajilwarnti nyanartiwarnti wirriyajarrinya. ");
INSERT INTO wmt_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Wali jutungurni palunyanangu jularnani wangki Jesus Kurayijkura wangki wulyu. Kumantawarlany kumantawarlany nira palunyanangu jularnani mayarurla Timpulla ngurrawarntirla piyirnwarntiwujaa marninwarntiwu. ");
INSERT INTO wmt_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Walimpa palu pajajarrinya Jesuskurawarnti. Jurujulumja palu ngunangani. Kanarlanywarnti palu Jurujulumkarrajiwarnti Juwujwarnti, kanarlanywarnti palu marrijangka Juwujwarntiwarlanyparni. Wali kanarlanywarnti Jesuskurawarnti marninwarnti palu kirrarnani marlaljartiwarnti ngumparnangajirtajartiwarntijaa pamarrngajirtajartiwarnti, ngumparna palunyanangu jarlu pirlajarrinya. Nyanartiwarntila palunya yungani pamarrjaa miyiwarnti marlaljartiwarnti marninwarnti. Nira palunya yungani kumantawarlany kumantawarlany Jesuskurawarntirlu. Wali nyanartijangka marrijangkawarntirlu palurlanyanu marnani, “Ngalimpakurawarnti kalkarrawarnti marrijangkawarnti palunya ngajirta ngarrjamarta yunganta. Jurujulumkarrajiwarnti palunya yungany ngarrja.” Jartijarti nyangani palunyanangurla miyiwarntiwujaa pamarrwarntiwu. Marrarnani palunya Jurujulumkarrajiwarnti miyingurnijaa pamarrngurni marrijangkawarntirlu. Nyanartijangka palu ngunangani. Kurninykangani palunyanu kulijangkarlu Jesuskurawarntirlu. Ngajirta palurlanyanu ngarrurta ngunangantarla. ");
INSERT INTO wmt_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","3","Wali nyanartijangka pajilwarntirlu palunya 12ju marurrpinya Jesuskurawarnti pujurni wangkipurru. Pajilwarntirlu palunyanangu jularni kanarlanywarntiwu Jesuskurawarntiwu, “Kurninykangany parlipanyanu, ngajirta palu kalkarrawarntirlu marrijangkawarntirlu marta pamarrjaa miyi ngarrjamarta. Wayila nyapartukarra. Piyirnwarntirlu pajangu manta ngampurrikarrku miyi yungupurrujaa ngampurrikanupurru. Kayan ngarnalu ngampurrikarra nganamparlu pajilwarntirlu. Ngajirta. Kayan ngarnalunyanta rukanyja Ngarpukurarla wangkinga. “Wali warntalunya piyirnwarntiwarlany miyipurru ngampurrikanupurru. Nganampawu manpangu kayanparni wangki Ngarpukura marnalu jularnanku kayan. Kurajpungkalunya nganpayiwarnti pinangurruwarnti 7 yangka manyanangurla jarlu takurryani Pirlurr Ngarpukurajangka. Yangka parlipanyanangu wirriya nguniny pinangurruwarntiwu, nyanartiwarnti mantanya warntawu piyirnwarnti. Nyanartijangkala marnalunya majakujiwu nganamparlu miyipurru yunganupurru. Nyantuwarntirlu palunya kalkarrawarnti yunganku. ");
INSERT INTO wmt_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Nganamparlu marnalunyanangu Jesuskura wangki jularnankujaa purayimarnanku marnalu. Warrkam manpangu nganampakura nyanarti.” ");
INSERT INTO wmt_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Nyanartijangka wangkijangka palu wirriyajarrinya, pajilwarntirlu palunyanangu jularni wangki. Wali wirriyajarrinyala palu Jesuskurawarnti nukarnini. Kurajpinyala palunya nganpayiwarnti 7. Nganpayi layi palu kurajpinya yini parla Tipin. Nyanarti nganpayi mapunikanani, kankarral Ngarpu jirrkirl waangani. Pirlurr Ngarpukurajangka manyanta jarlu takurryani, ngunangani manyanta Pirlurr. Yarnta kanarlany nganpayiwarlany yini parla Pilip, yarnta kanarlany nganpayiwarntiwarlany 5. ");
INSERT INTO wmt_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Kanyala palunya pajilwarntikarti. Wali kurraparlula palunya palymanani jurlu pajilwarntirlu, purayimarnanila palunyanangu nyanartipurru warrkampurru. ");
INSERT INTO wmt_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Wali Jesuskurawarnti palu paja ngunangani Jurujulumja. Kanarlanywarntirlu palu pinakarrinyani wangki Jesuskura, wali mapunikananila palu kujangkurrarni kujangkurrarni. Pajajarrinyala palu piyirn marninjaa nganpayi Jesuskurawarnti. Kanarlanywarntirlu purijwarntirlu mapirri palu pajangu mapunikanani Jesuskura wangki. ");
INSERT INTO wmt_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Nganpayirlu Tipintu mapunikanani, wali Ngarpu manyanta ngunangani, yarnta maya parla yungani nyanartila manya marninjaa nganpayi wulyukujirnani mimijartiwarnti. Kanarlanywarntirlula palu nyangani Ngarpukurajarti mayajarti. ");
INSERT INTO wmt_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Wali jularnani manyanangu Juwujwarntiwarlanyku wangki Jesuskura Tipintu. Ngajirta palu jarlu Jesus mapunikarrarla. Kanarlanywarntirlu kurlirrajangkawarntirlujaa kayilungujangkawarntirlu palunyanta jangkujangkumanani. Langkarnirlu palunyanta jangkujangkumanani. ");
INSERT INTO wmt_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Yarntarni manyanangu jularnani Tipintu mapuntu. Jarti palu wajapungani. Tanyjingurni manyanangu marnani pinangurrurlu. Pirlurru Ngarpukurajangkarlu pinayungani nyanartila manyanangu jularnani. ");
INSERT INTO wmt_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Nyanartijangkala wangki palunyanu yinya kayilungujangkawarntirlujaa kurlirrajangkawarntirlu. Marni palurlanyanu, “Nyapartukarrarlu parlipa Tipin kulkurukujiwu. Yirrijiwarnti parlipanya warntawu.” Wali warntarnila palunya yirrijiwarnti ngirtilykarra jularnupurru. Pamarrpala palunya yinya. Yirri palu julawu Tipin. Jinjinyinya palunya yirrijiwarnti, “Pinajulawula manta Tipin yirriji yirrimarnujuwal. Yirri pinya julalany Mujijjaa Ngarpu. Yakurr pinya julalany yangkartijarra.” ");
INSERT INTO wmt_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Wali kurajpunganila palunyanangu yirrijiwarntirlu. Tipin palu kurajpungani. Yirri palunyanangu jularnani piyirnwarntiwu Jurujulumkarrajiwarntiwu. Yarnta palunyanangu jularnani yirri purlkawarntiwu Juwujkurawarntiwujaa pinangurruwarntiwu kurayipwarntiwu. Kulijarrinyala palu nukarnini. Nyanartijangka palu Tipin tarrpartarni, kanya palu purlkawarntikarti Juwujkurawarntikarti ngulikanupurru. ");
INSERT INTO wmt_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","14","Yirrijiwarnti mapirri palunya kanya purlkawarntikarti. Yarnta palu Tipin pinajularni yirrijiwarntirlu. Jularni palu, “Minyarti nganpayi Tipintu pinya julalany Ngarpujaa Mujij, kaninykujilany pinya. Jesus pa purlka julalany, mayaru Timpul parlipangu jujupurru junganku Jesusju. Julalany parlipangu Jesus pa wangki wajapungujuwal. Mujijkura wangki parlipangu wajapungku Jesusju.” Kujartikarra palu yirrijiwarntirlu marnani. ");
INSERT INTO wmt_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Nyanartijangka purlkawarntirlu palu jutungu nyangani nganpayi Tipin. Janginy palu nyangani kanarlanyparni yinjiljiliny. ");
INSERT INTO wmt_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Japirlyinyala parla Tipin nganpayirlu purlkangu purisju, “Mapun ngantalu julalany.” Wali jularnani manyanangu juwaljinyangu wangki Tipintu. ");
INSERT INTO wmt_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","50","Takijularnani manya nyapartukarra palu kilakirlujaa jamirtirlu Juwujkurawarntirlu wajilpungani Ngarpu. Yarnta manyanangu yiniwarnti jularnani jarlujangkawarnti piyirnwarnti Ayiparanjaa Jawujapjaa Mujij. Tipintu manyanangu marni, “Yuwayi. Yangkarti mapunparni Mujijju manyanangu jularnani Ngarpukura wangkijaa marlamanani manya Mujijju kilakiwarnti ngalimpakurawarnti, yangka palu jarluwarlany Yijipja ngunangani. Kanarlanywarntirlu palurla ngajirta mapunikarrarla Mujijku. Kula Mujij yarrparni, minyangurru Ngarpungurni yiparni. Nyanartijilinyparni manyanangu jularnani Mujijju, nyapartukarra Ngarpungu parlipangu yipawu nganpayiwarlany Mujijjilinyparni. Wali panypinya palunyanta Mujijja kilakiwarnti yarnta Ngarpunga ngajirta palunyanta mapunikarrarla, yangkartijilinyparni yangkarti palu jarlu ngartakani purluman kajalkajalkujirnupurru, yangkala palunyanta purayimarnani purlumanta. Yarintu manya martarnani. Mujij pa warrarni wirlmarnani pamarra Ngarpunga manyanta wangkikarra ngunangani, minya manya kanarlanyju martarnani Yarintu nganpayiwarlanyju. Wali yangkartiwarnti ngalimpakurawarnti palanta Ngarpunga panypungani.” ");
INSERT INTO wmt_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Wali jirrkirl manyanangu marnani Tipintu, “Nyurrawarnti manta jurlu tanyjiwarnti. Ngajirta manta pinakarri. Martalany manta pinajarra, ngajirta manta pinakarrijaa mapunikarra wangki Ngarpukurajangka. Nyurrawarnti manta nguniny kilakiwarntijiliny. Wangki ngajirta manta mapunikarra Pirlurr Ngarpukurajangka. Warrarni manta ngajirta pinakarri. Yangka kilakiwarntijiliny palu nguja jarlu, nyanartijiliny manta nguniny nyurrawarnti.” ");
INSERT INTO wmt_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","53","Wali yarntarni manya Tipintu pinalkarra yungani wangki jarlujangka, yangka puraputwarntirlu palunyanangu jularnani wangki, Jesuspala walimpa pirriyanku. Jesus warrarni pirriyanku Ngarpungurni warrkammayinjiliny. Ngajirta manyanu kajalkajalkujirnantarla Jesusju. Kajalurni palunyanangu puraputwarntirlu jularnani wangki kilakiwarntiwu Juwujwarntiwu nyantukurawarntiwu. Wali kulijarrinyala palunyanangu puraputwarntiwu, yarnta palunyanangu wangki jularnani Jesus pirriyanupurru. Jularnani palunyanangu yangka Jesus wartangurni pirriyanku. Punganila palunya kulijarrinyurla pirlawurra. Pujurni palunya pungani puraputwarnti, yakurrmarnani palunyanangu. Yarntarni manyanangu jirrkirl marnani Tipintu purlkawarntiwu, “Mapunparni palunyanangu jularnani yangkarti jarlu kajaluwarlany, Jesuspala pirriyani mapunparni. Wali nyurrawarntirlu manta pirtinyikanijaa ngulikani pungupurru pirlawurra. Nyanartiwarntijiliny kilakiwarntijiliny manta nyurrawarnti pungujuwal. Kilakiwarntijilinyju manta Jesus pirlakujirni. Ngajirta manta mapunikarrarla Mujijkurajangka wangki. Panypinya mantanyanangurla jirnanyunguwarntirlu wartangurnijangkawarntirlu.” ");
INSERT INTO wmt_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Wali Tipintu manyanangu janginyjurrarni marnani jirrkirlparni purlkawarntiwu. Jirljirljarrinyala palu partalurni. Kulijarrinyala palu. Munta kaninykaniny palu parrparrjarrinya. Kulijarrinya palurla nganpayiwu Tipinku. ");
INSERT INTO wmt_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Nyanartijangka Tipinta manyanta ngunangani Pirlurr Ngarpukurajangka, yarnta kankarral nyanya yalkirirlurra. Ngarpujaa Jesus pinya nyanya nyantungumipa. Ngarpu pa nyanya karntalyjinyangu jiraly palypalymananyjangka. Jesus manyanta marnparni karrinyani Ngarpunga mayakarti. Nyanya pinya Tipintu. ");
INSERT INTO wmt_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Marni manyanangu Tipintu, “Yalkiri marna nyangana, kirlingirrijarrinya. Nyangana marna Jesus. Karrinyana manyanta Ngarpunga marnpa mayakarti. Nyakalu.” ");
INSERT INTO wmt_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Wali pinala palunyanu ruktarrpartarni kurraparlu. Ngajirta ngalu Tipinkura wangki pinakarri. Pawupawukarra palanta pujurni laparnkarrakanya, pinajarra ruk tarrpartanurla Tipinkarti. ");
INSERT INTO wmt_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Tarrpartanila palu nganpayi Tipin, kanyala palu mayarungurni luwarnupurru pamarrjawurlu pirlawurra. Luwarnani palu Tipin pamarrjawurlu. Kuwutwarnti palurlanyanu kurtamani nyantuwarntikura luwarnupurru, yinyala palurla nganpayi yini Juwul. Martarnani manyanangu kuwutwarnti. Nyantu pingkayi ngunangani nyanartikarra. Nyangani manya Juwullu luwarnani palu pamarrjawurlu Tipin. ");
INSERT INTO wmt_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Yangka palu luwarnani, wali nyanartikarrarnila wajawajarlarni purayimarnani parla Tipintu Jesusku. Marni parla, “Purlka Jesus. Pirlurr ngajukura man warntawu.” ");
INSERT INTO wmt_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Mirtijurrurnjurrurnwantinyala. Wali mayangu papajani Tipintu, “Ngarpu. Ngajirta nganyanangu yakurrmanyja, minyarti pajalu luwarnana pirlawurra. Ngajirta nganunya ngulikarra minyartiwarnti piyirnwarnti. Wajapungku manunyanangurla yakurryakurr.” Nyanartijangka marnujangka pa pirlajarrinya nganpayi Tipin. ");
INSERT INTO wmt_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","3","Wali nganpayi yangkartirlu Juwullu pinapinakarrinyani luwarnupurru pirlawurra, yangka palu Tipin luwarni. Wirriya parla nguja luwarnujangkawu Juwul. Kanarlanywarnti Ngarpukurawarnti palurla lungani Tipinku pirlajarrinyujangkawu. Nganpayi Juwul wirriya parla nguja, ngajirta parla lungkarla Tipinku pirlajarrinyujangkawu. Karrkin palu kanya kanarlanywarntirlu Ngarpukurawarntirlu nguwakarti turnmanupurru. Turnmanila palu. Wali nyanartikarrajangka Jesuskurawarnti palunya punganijaa jayilla palunya takurrpungani. Juwullu manyanangu jirlkarrinyani piyirnwarntiwu Jesuskurawarntiwu. Pujukujirla manya Jesuskurawarnti. Ngurrawarlany ngurrawarlanyjangka manya ruwarramanani Jesuskurawarnti Juwullu. Nganpayiwarntijaa marninwarnti manya jayillakujirnani Juwullu. Nyanartikarra Jesuskurawarnti palu pulykarrala yani Jurujulumngurni kujangkurrajarra pungukarrarla. Mayaruwarntikarti palu yanani Jesuskurawarnti pajajinyangu. Kanarlanywarnti palu yani marnpa Jutiyakarti, kanarlanywarnti palu marri yani Jimariyakarti. Pajilwarntimipa palu lama kirrarnani Jurujulumja. Ngajirta palu pajilwarnti pulykarra yanantarla. ");
INSERT INTO wmt_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Yangka palu jarlu pulykarra yani Jesuskurawarnti piyirnwarnti, jularnanila palunyanangu Jesuskura wangki kanarlanywarntiwu piyirnwarntiwu. Paja palu yani pulykarra Jurujulumngurni kujangkurrajarra. ");
INSERT INTO wmt_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Layi nganpayi yangkarti Pilip yani mayarukarti Jimariyakarti. Jularnanila manyanangu Jesus nyapartukarra Ngarpungu kankarningurni yiparni minyartikarti nguwakarti. Jularnani manyanangu Jimariyakarrajiwarntiwu piyirnwarntiwu nganpayirlu Pilipju. ");
INSERT INTO wmt_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","8","Yarnta Pilipju Jesuskurarlu manyanangurla pirlawarnti jurrajurramanani piyirnwarntijangka muntangajangka. Jamurnku jarntakparnuwu muntangurni, mayajinyangula palu papajanani pirlawarnti. Nyanartijangka jarntakparnila palu palkakarti piyirnngurni. Kanarlanywarnti mapirri piyirnwarnti, yangka wurna palu nyikitkarra yanani, yarnta kanarlanywarnti nyirnilyawarnti, nyanartiwarnti manya wurnajartikujirnani Pilipju Jesuskurarlu wurnangajirtajartiwarntirni. Mayakujirnanila manya kujangkurrarni wulyuwurra nyikitkarrayanujangkawarnti. Wali Pilipju manya wulyukujirnani piyirnwarnti. Nyanartiwarntirlu piyirnwarntirlu Jimariyakarrajiwarntirlu palu nukarnirlu pinangakujirnani wangki Pilipkurajangka yangka manyanangu jularnani Jesus Ngarpungu yiparni. Yarnta palu pinangakujirnani, tumaj palu Pilip nyangani wulyukujirnujangkajaa jurrajurramanujangka. Wirriyajarrinyala palu nyanartikarrajiwarnti piyirnwarnti Jimariyakarrajiwarnti. ");
INSERT INTO wmt_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Wali layi nganpayi ngunangani mayarurla nyanayirla yini parla Jayimin. Nira ngunangani maparnjilinyparni. Karrpirlmarnani palurla. Nyangani palu Jimariyakarrajiwarntirlu Jayimin kanarlanyparni maparnjilinyparni karrpirlwurra. Nira manyanu Jayimintu yarringarnani maparnjilinyparni, ");
INSERT INTO wmt_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","yangkala palurlanyanu pinangakujirnani pajangu nyanartikarrajiwarntirlu piyirnwarntirlu nukarnirlurni wapalkarrarlu purlkapurkarlu mapirrirni. Marnani palurlanyanu, “Minyarti nganpayi, purlkajarti maya Ngarpukurajarti. Ngarpujilinyparni pa minyarti.” ");
INSERT INTO wmt_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Minyartirlu nganpayirlu Jayimintu manya jarlujangkarlurni karrpirlkujirnani manya maparnjawurlu. Nyanartijangka palurlanyanu pinangakujirnani wangki Jayiminkura. ");
INSERT INTO wmt_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Wali Pilip yangkarti manyanangurla wartangurni Jurujulumngurni pirriyani. Jayimin nyanarti pa Jimariyakarraji. Jularnani manyanangu nyapartukarra parlipangu ngunawu maja Ngarpu. Yarntarni manyanangu jularnani wulyu wangki Jesus parlipangu pirriyani. Nyanartijangka palanta pajangurni mapunikani marnintujaa nganpayirlu, ngapangakujirnanila manya. ");
INSERT INTO wmt_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Nyanarti nganpayi mapirrirni Jayimin. Nyanarti manyanu maparnjilinyjurni yarringarnani jarlu, nyantungu mapirrirni manyanta mapunikani Jesusja, ngapangakujirni palu nyantu mapirri. Nyanartijangka marnparni wajilpungani Pilip. Mapirrila pila kitpungani. Pilip nyangani Jayimintu kanarlanyparni, karrpirlmarnila parla wulyukujirnanujangkajaa pirla jurrajurramanujangka. ");
INSERT INTO wmt_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Wali kanya palu wangki Jurujulumkarti. Jakuljularnanila palunyanangu Jurujulumkarrajiwarntiwu. Mapunikanila palu Jimariyakarrajiwarntirlu, wangkila palu kurajpungani Ngarpukura Pilipkurajangka. Jurujulumkarrajiwarntirlu palu pinakarrinya pajilwarntirlu, wali yiparnila palpinya Pitajaa Jun nyanartirlurra Jimariyarlurra. ");
INSERT INTO wmt_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","16","Wali jakarni pila Jurujulumngurni kitangarni pilanyanangurla pirriyani Jesuskurawarntirla Jimariyakarrajiwarntirla. Wali jarlu palu mapunikani ngapangajarrinyala Jimariyakarrajiwarnti. Yininga Jesusja palunya ngapangakujirnani. Jularnila palunya Jesuskurawarnti. Nyanarti yarrmiparni. Ngajirta manyanangurla Pirlurr Ngarpukurajangka takurryantarla nyanartikarra. Japirlyinya pilarla Ngarpuwu Pitangujaa Juntu yiparnupurru Pirlurr Ngarpukurajangka nyanartiwarntikarti piyirnwarntikarti, yangkala palu Jesus mapunikanani. ");
INSERT INTO wmt_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Wali purayimarnungurla pilanya jurluwarnti palymanani Jesus mapunikanujangkawarnti. Takurryanila manyanangurla Pirlurr Ngarpukurajangka. ");
INSERT INTO wmt_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Nyanarti nganpayi Jayimin nguja, nyanya pinya Pitajaa Jun palymanujangka. Nginyjirrikanila manyanangurla Pirlurr Ngarpukurajangka takurryanujangka. Wali yijingkanyala pilangurla pamarr Jayimintu. ");
INSERT INTO wmt_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Marni pilangu, “Pamarr marnanypinya yungku. Mayala pajanpila yungku. Puju marnanya ngajungu palymananku kurraparlu jurlu piyirnwarnti kanarlanywarnti, Pirlurr Ngarpukurajangka manyanangurla takurryanku.” ");
INSERT INTO wmt_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pitangu manyanta jangkumani, “Nyuntungu mankurla pinapinakarrilany kula pamarrjawurlurni warntarnuwu Ngarpukurajangka mayajaa Pirlurr Ngarpukurajangka yungku mantanya kanarlanywarnti piyirnwarnti. Pujujarriwujal man. Nyuntujaa pamarr mapirrirni manpila pujujarriwu. ");
INSERT INTO wmt_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ngarpungu manta nyangany, ngajirta mankurla munta kayan nguna Ngarpuwu. Kayan nganpangurla nguna warrkamkarra Ngarpukurarlal. ");
INSERT INTO wmt_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Kurnakwanti jalarra, nyanarti yakurr tarrangka. Ngarpunga ngarntimanyjanyanta yakurr wajapungupurru, tumaj mankurlanyanu pamarrjawurlu payimkujirla Ngarpukurajangka maya.” ");
INSERT INTO wmt_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Yarntarni parla Pitangu marni, “Marrupungurla man makijarrinya muntawarlanyjarrinya. Putangu manta wajukarrpilany.” ");
INSERT INTO wmt_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Marnila pilangu Jayimintu, “Ngajirta. Nyurrajarrarlu ngarntikangkajipilarla Ngarpunga pujukujirnungajirtapurru, yangka pajinpila jularni nyurrajarrarlu, wulyula marna ngunawu.” ");
INSERT INTO wmt_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Wali nyanartijangka pilanyanangu yarntarni jularnani Jesuskura wangkijaa nyapartukarra pinya Jesusju marlamani. Nyanartijangka pila jakarni tikirr Jurujulumkarti Pitajaa Jun. Wurnangu pilanyanangu jularnkarrakangani mayaruwarlany mayaruwarlany kaparnwarnti wulyu wangki Jesuskura. Kujartikarra pilanyanangu jularnani Jimariyakarrajiwarntiwu piyirnwarntiwu. ");
INSERT INTO wmt_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Marni parla Pilipku yinjillu Ngarpukurajangkarlu, “Yanku man jalarra kurlirra walmartakarti. Warntarrirla man pirriyanku. Kirralku man nyanayirla.” ");
INSERT INTO wmt_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Wali jakarni Pilip. Yani pa, kitangarni pirriyani warntarrirla nyanayirla. Wali yarr kutarni jurumani. Nyanya jurtu kakarrangu tuyitarrapinya pakingu. Jamurn marnpajarrinya, Pilipju nyanya nganpayi pakijarti. Nyanarti nganpayi yiningajirtajarti. Ngurrpa parliparla yiniwu. Ngajirta pa Juwuj, nyanarti pa kurlirrajangka marrijangka. Tikiyanani kurlirrara ngurrakarti nyantukurakarti. Wali kapuman pa purlka ngunangani mayarurla nyantukurarla. Kirrarnani palu paja nyanayirla mayarurla. Yarnta marnin purlkajinyangu julalany palu maja kuwin. Yangkarti nganpayi purlka pamarrmayin. Pamarr parla martarnani kuwinku. Wali jarlu pa yangkarti nganpayi kapuman yani kayirrara Jurujulumkarti ruwa mayarukarti Ngarpukurakarti jujupurrukarti. Ngarpu pa mapunikani, ngajirta pa Jesus pinakarrirla. Ngurrpa parla Jesusku. Ngarpuwumiparni parla pinarri ngunangani. Wali Jurujulumjangka pa wurna tikiyanani kurlirrara ngurrarakarti nyantukurakarti pakijarti. Wali kirrarnaninyirra kankarni, kurrumpa nyanyangurra Ngarpukura. Jarti nginyjirringinyjirrikanani yiningajirtajarti. Ngajirta palurla jularla, ngurrpa parla ngunangani. ");
INSERT INTO wmt_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Nyanartijangka parla marni Pilipku Pirlurru Ngarpukurajangkarlu, “Yantanyanta langkarnikarra nganpayi pakijarti. Yananku manyanta marnpa.” ");
INSERT INTO wmt_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Wali Pilip manyanta laparni langkarni. Pilipju pinakarrinyani kulkururlu wangki yangkarti kurrumpajangka, yangka jularnani nganpayirlu kapumantu, nginyjirrikanila wangki Pilipju jarlujangka yangka lani nganpayirlu Yajayarlu. Nyanartijangkarlu parla japirlyinya kapuman Pilipju, “Ngana wangki parlipangu julalany kurrumparla. Wayila. Nginyjirrikarralany ngan.” ");
INSERT INTO wmt_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Wali jangkumanila nganpayirlu pakijawurlu, “Ngajirta. Kayan ngarna nginyjirrikarra wangki minyarti. Puju ngananguwurti paji julawu, wali nyanarti, pinarrila marnarla ngunawu.” Nyanartijangka purlkangu parla marni Pilipku, “Wali parayanta.” Wali parayanila manyanta pakinga. ");
INSERT INTO wmt_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Yangkarti wangki nyangani nganpayirlu purlkangu jarlujangka yangka jarlu lani Yajayarlu. Kujartikarra pa nyangani. Yangka palu kangany kukunja kangkul junganupurru, nyanartijilinyparni palu kanya. Nyantu pa nguja kukunjajiliny kulkuru. Ngajirta pa kukunja papajanujuwal yangka palu kangany ralpungupurru, ngajirta pa nyantu papajarrarla nyanartijilinyparni. Kulkururlurni manyanu pikayinya. ");
INSERT INTO wmt_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Yarnta jingkirti palurla warralpungani. Kulikujirlala palu. Yarnta kurntayikujirla palu jingkirtijangkarlu warralpungujangkarlu. Murtangkurra palu ngulikanani pungupurru. Ngajirta pa ngananguwurti purntumantarla. Nyanartijangka palu pinya, wali pirlajarrinyala. Ngajirta parlanyanu martarla juku nyantukurajinyangu. Ngajirta palanta lurrnyakarla yapawarnti kanarlanywarntirlu piyirntu jirnajangkarlu. ");
INSERT INTO wmt_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Nyanartijangka japirlyinyala kapumantu, “Ngana minyarti kukunjajiliny manyanu julalany. Kunyungurla kanarlanyparta julalany. Julaji. Pinarriyungkaja wangki minyarti.” ");
INSERT INTO wmt_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Jangkumanila Pilipju, “Ngajirta. Minyarti pa nganpayi kukunjajiliny Jesus.” Nyanartijangka Jesuskura wangki parla jularni nukarnini. Wulyu wangki parla tikirrjularni. ");
INSERT INTO wmt_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Wali laparni pila, nyanyala pila ngapa. Marnila parla Pilipku nganpayirlu purlkangu, “Ngapajal minyarti. Minyayirlarni pajan ngapangakujiwu. Wayila. Ngananguwurti paji jarrmalku.” ");
INSERT INTO wmt_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Wali nganpayirlu kapumantu parla warrkammayinku nyantukurawu jularni jatparamarnupurru paki, jatparamanila paki nyanarti. Jupantinyurla pila ngapakarti yani. Wali Pilipju ngapangakujirni nganpayi nyanarti kapuman. ");
INSERT INTO wmt_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","40","Nyanartijangkala pila ngapajangka parayani tikirr. Wali Pirlurru Ngarpukurajangkarlu pa yap kanya Pilip murtarni. Kanya pa kayirrara mayaruwarlanykarti. Ngajirta pa yarntarni nyakarla purlkangu kapumantu. Wali purlka nyantu pa turtangkanya wirriya ngapajangka. Wurnarnila yanani kurlirra nyantukurakarti ngurrakarti wirriyajinyangu. Nyanartijangka Pilip pa nguja kayirrampal. Jularnani manyanangu wamarn Jesuskura wangki kayirrampal piyirnwarntiwu kanarlanywarntiwu. Kayirra mayarukarti Jijirriyakarti wamarn yanani, kitangarni lamajarrinya nyanayirla mayarurla Jijirriyarla. Wali Pilipkura wangki minyartirni kutarni pujujarrinya. Kanarlany wangkiwarlany parlipa nyaku. ");
INSERT INTO wmt_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","2","Wali Juwul yangkarti ngunangani Jurujulumja. Marnani manyanangu Jurujulumkarrajiwarntiwu, “Pungku marnanya nyanartiwarnti piyirnwarnti Jesuskurawarnti.” Ngulikanani manya nyanartiwarnti piyirnwarnti yangka palurla mapunikani Jesusku. Wali mayaruwarlanyja palu ngunangani yininga Majkajja piyirnwarntijaa marninwarnti Jesuskurarlal palu yanani. Juwul pa kayili yanku Majkajkarti. Muwupungku manyanangu Jesuskurawarntiwu piyirnwarntiwu. Warntarnurla jayilla takurrkujirnupurru. Wali purlkakartila pa yani Juwul puriskarti Jurujulumkarrajikarti. Mirlimirli manyanta warntarni yinijarti nyantujarti yini. Kangkula Majkajkarti kayili mirlimirli nyanarti. Kanarlanywarntila manya yungku majawarntiwarlany nyanartikarrajiwarnti Majkajkarrajiwarnti. Mayaruwu palurla maja nguniny Ngarpukurawu mayaruwu jujupurruwu. Mirlimirli nyanarti yinijarti nyantukurajarti yini manya yungku Juwullu. Nyaku palu nyanartiwarntirlu nganpayiwarntirlu majawarntirlu. Wali mapunikarrkula palu. “Mapun pa minyarti nganpayi mirlimirlijarti.” Mirlimirli nyanarti pa karrpirnajiliny. Yipawula ngurrakarti, tarrpartawula manya Jesuskurawarnti marninwarntijaa piyirnwarnti, kangkula manya jayilkarti Jurujulumkarti Juwullu. ");
INSERT INTO wmt_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Wali nyanartijangka Juwul pa yani Jurujulumngurni Majkajkarti mirlimirlijarti. Nyantujaa kanarlanywarnti piyirn jarntuwarnti palu yani. Warntarrirla kaparn parla pirriyani tili kankarnumarrangu yalkiringurni parralani marnparni mayarurla Majkajja. ");
INSERT INTO wmt_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Juwul pa wantinya nguwanga kaninyjinyangu. Wangkimiparni pa pinakarrinya Juwullu. Taj jularni pa. “Juwul. Nganajangka man kujartijarrilany. Munta pajan luyurrkujilany, tumaj manunya pungani piyirnwarnti ngajukurawarnti.” ");
INSERT INTO wmt_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","6","Juwullu parla japirlyinya, “Ngana man nyuntu. Purlka ngan nyuntu.” Wali jangkumani pa lintu, “Ngaju marna yangkarti yini Jesus. Yangkartiwarnti piyirnwarntikura yangkarti manya pungany, ngajula marna luyurrjarrilany. Wali turtangka. Yanta mayarukarti. Jurumantaji mayarurla nyanayirla. Warra marnangu julawu wangki nyapartujarriwu man.” ");
INSERT INTO wmt_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Wali kanarlanywarntirlu nganpayiwarntirlu Juwulkurawarntirlu palu pinakarrinya lin, wali warrpkarra nyanyala palurla jarti. Kulkuru palu karrinya. Walirni nganpayi nyanarti palu nyanya wantinyujangka. ");
INSERT INTO wmt_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Nyanartijangka nganpayi nyanarti Juwul turtapinya nguwajangka. Jarti parla nyanya ngurrawu. Mil jankajarrinya. Nyanartijangka ngarrpirtikanya palu mayarukarti Majkajkarti. Kanya palu nganpayikurakarti ngurrakarti Jutajkurakarti. ");
INSERT INTO wmt_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Kirrarnani nyanayirla ngurrawarntirla murrkurnta jankajartirni. Ngajirta pa ngapa nganyjarla. Jarti palurla yinyangurra ngapa. Yarnta miyijaa kuyi palurla jarti yungani. Ngajirtarni ngarnantarla. Ngurrawarnti murrkurn nguja jankajarti miyingajirtajartijaa kuyingajirtajarti. ");
INSERT INTO wmt_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","12","Wali Juwullu parla purayipurayimarnani Jesusku. Wali nyanartikarra winkirrmanila Ngarpukura nganpayi Yananayaj parla pirriyani. Yanungurla palymani Yananayajju winkirru. Wali warrpunyanyala Juwullu. Ngajirta manyanjinyangu, yarr yangka winkirrjilinyjurni nyanya. Wali yangkarti nganpayi Yananayaj ngunangani Majkajja Jesuskura nganpayi. Nyanartijangka marni parla Yananayajku Jesusju winkirrjilinyjurni ngurrakarti yanuwu Jutajkurakarti. Juwul nyanayirla pa kirrarnani jankajarti. Wali Jesusju winkirrjilinyju yini jularni Yananayaj. Marni parla Yananayajju, “Yu. Ngaju marna.” Marni parla Yananayajku Jesusju, “Yanku man mayarukarti Jutajkurakarti. Parlipungku man nganpayi yini parla Juwul nyanarti Taajijkarraji. Jalarra paji purayimarnana. Winkirra manta nyanya Juwullu. Pirriyani mannyanta palymanupurrujaa wulyukujirnupurru. Nyanarti Jutajkura mayaru Majkajja karrilany warntarrirla jirrkirlla, yini parla warntarriwu jirrkirl. Julalany palu warntarri nyanarti yini jirrkirl.” ");
INSERT INTO wmt_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","14","Jangkumani pa Yananayajju winkirrjilinyju Jesus, “Ngajirta. Pungka ngaja. Nganpayi pa nyanarti kulipari. Jularni pajilu nganpayi nyanarti pungujuwal. Nyuntukurawarnti manya Jurujulumja pungani. Wali nganampakartila yani minyartikarti ngurrakarti pungupurru. Tarrpartawu manpanya Jesuskurawarnti yangka yini marnalu julalany Jesus, jamalkangany marnalu. Nyanartiwarnti manpanya tarrpartawu. Purlkawarntirlu puriswarntirlu palurla yinya mirlimirli warntarnupurru marninjaa nganpayi Jesuskurawarnti. Mirlimirli nyanarti karrpirnajiliny pa martalany. Tarrpartawula manpanya Juwullu Majkajkarrajiwarnti nukarnini.” ");
INSERT INTO wmt_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","16","Yarntarni parla marni Jesusju Yananayajku, “Walirni man yanku. Ngajungu marna kurajpinya nyanarti nganpayi Juwul. Warrkammalku paji. Warra paja julawu Juwujwarntirla, yarnta paja takijulawu Juwujngajirtajartiwarntirla mapirrirni. Juwullu paja julawu purlkawarntirla majawarntirla. Pinayungku marna nyapartukarra paji warrkammalku kuliwurra. Kulijarriwula palurla Juwulku kanarlanywarntirlu ngajungurni takijularnujangkangurni,” marni parla Jesusju Yananayajku. ");
INSERT INTO wmt_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Wali nyanartijangka pa mapunikani. Yani manyanta Yananayaj Juwulkarti. Palymani pa Yananayajju. Marni parla Juwulku jarntujilinyju, “Wayila Juwul. Yara ngan. Pirriyani marnangu. Yiparni paja Jesusju yangkartijangkarlu warntarrijangkarlu. Yiparnila paja palymanupurru, warrpunyakula man yarnta. Pirlurr Ngarpukurajangka mangurla takurryanku.” ");
INSERT INTO wmt_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Nyanartijangka wantinya millajangkajarra. Kanarlanywarntirlu palu nyanya, kula jarrjajarra palu nyanya. Nyanartijangkala mil wulyujarrinya, nyanyala ngurra Juwullu. Wali turtapinya Juwul, ngapakarti palu yani, ngapangakujirnila palu. ");
INSERT INTO wmt_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Wali tikirrjawurlula ngarni miyijaa kuyijaa ngapa, tanyjijarrinyala. Nyanartijangka ngurrawarnti ngarrjarni manyanangurla kirrarnani Jesuskurawarntirla Majkajkarrajiwarntirla. ");
INSERT INTO wmt_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Wurnarni wamarnjularnani manyanangu jujupurruwarntirla Ngarpukurawarntirla. Ngajirta pa yarr kirrarnantarla. Wangki manyanangu jularnani Jesuskura wangki. Jularnani manyanangu kujartikarra, “Jesus pa Ngarpukura walaku.” ");
INSERT INTO wmt_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Nyanartijangka nginyjirrikanila palu. Purrpurrmarni palurla. Nyantuwarntirlula palurlanyanu marnani, “Minyartijal yangkarti Jesuskurawarnti manya jarlu pungani Jurujulumja. Yangka palunyanu Jesus jularnanijaa jamalkangani piyirntujaa marnintu, jarluliny manya pungani. Yangkartikarra pirriyani tarrpartarnupurru piyirnjaa marnin Jesuskurawarnti. Tarrpartarnurla manya kangkarla Jurujulumkarti purlkawarntikarti puriswarntikarti. Nyanayirla manya jayilla yutukarrarla. Wali nyapartujarrinyaparta.” Kujartikarra palurlanyanu marnani. ");
INSERT INTO wmt_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Jakuljularnani manyanangu Juwullu mapuntu Majkajkarrajiwarntiwu, yangkala pajangujinyangu palunyanta pinakarrinyani Juwulla. Wangki manyanangu jularnani Jesuskura wangki nyantuwarntiwu Juwujwarntiwu. Nyantuwarntirlu palunyanta jangkujangkumanani Juwulla. Jatparamarnila palu, nyantungu manyanangu layirni jularnani Jesus pa Ngarpukura walaku. Liyilanani manya Majkajkarrajiwarnti. Marnani palurlanyanu, “Mayajawurlu pa julalany Juwullu mapunparni.” Nyanartijangka palu wutajarrinya Majkajkarrajiwarnti. ");
INSERT INTO wmt_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Walimpa palunyanu wangki yungani Juwujwarntirlu, pungkarla palu Juwul. Yakurrmarnani palurla tumaj Jesuskura wangki jularnani. ");
INSERT INTO wmt_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Wali layiwarlanyju parla pinajularni Juwulku, “Pungku mantalu Juwujwarntirlu. Jurujurumanana mangulu kiyitwarntirla pukanyjajartijaa jininyarajarti. Puju man yanku minyartingurni tawunngurni tarrpyanku manyanangurla. Pungkula mantalu pirlawurra.” Mapunparni palurla nira jurumanani kiyitwarntirla pukanyjajartijaa jininyarajarti pungupurru. ");
INSERT INTO wmt_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Wali Jesuskurawarntirlu palu marlamani nganpayi Juwul, wanyjarrawarntirlu palu waangani mapirrirni Juwul. Ngajirta pa Juwul tirrinyyantarla kiyittal, minya palurlanyanta jurujurumanani nyantuwurni pungupurru. Wali Jesuskurawarntirlu palu karlayilanani marlamanupurru. Kanya palu pukanyjajarti kankarral mayarurlurra. Parayani palu mayarurla jarrngangal kankarral. Nyanartijangka kankarni palu Juwul yutukani ngurtijilinyja yatunga purlkanga. Wali rupjawurlu palu kanimparral yirritikujirnani ngurtijilinyjaa Juwul mapirri. Ranyji palunyanangurla pukanyjajarti pungungamarra turtukujirni wurna yanupurru. Wali wurnarnila yani kurlirrara Jurujulumkarti. ");
INSERT INTO wmt_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Wali pirriyani manyanangurla. Nginyjirrikanila palu Jurujulumkarrajiwarntirlu. Wurnarni manyanangurla pirriyani Jesuskurawarntirla. Rayin nyangani palu, ngajirta palurla wirriya ngunarla. Marni palurlanyanu, “Ngajirta ngarlipa marurrpungka, nyanarti pa yangkarti pungujuwal. Ngajirta pa nyanarti Jesuskura.” ");
INSERT INTO wmt_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Wali nganpayirlu yangkartirlu Panapajju purpankanya Juwul Jesuskurawarntikarti pajilwarntikarti. Wali marnpa manyanangurla pirrikanya nyanarti nganpayi Juwul. Takitakijularni manyanangu Panapajju kujarti, “Minyarti nganpayi Juwul pa Jesusju kurnakkujirni. Warntarrirla manyanta pirriyani Jesus, wali nyanartijangka Jesus pa mapunikani. Purnkungula manyanangu Juwullu jularnani Majkajkarrajiwarntiwu Jesuskura wangki.” ");
INSERT INTO wmt_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Wali nyanarti wangki palurla mapunikani Panapajku Jesuskurawarntirlu Jurujulumkarrajiwarntirlu. Wali wirriyala palurla ngunangani. Kirrarnanila manyanangurla Juwul, mapirrijarrinyala. Wamarn yanani manyanangurla Juwul Jesuskurawarntirla Jurujulumja. Wangki manyanangu jularnani Jesuskura wangki purnkungu. ");
INSERT INTO wmt_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Yarnta manyanangurla Juwujwarntirla kanarlanywarntirla marrijangkawarntirla wangkikarra kirrarnani. Nganpayirlu Juwullu manyanangu Jesuskura wangki jularnani. Jangkujangkumananila palunyanta. Nyanartijangka palurla yakurrmarnani Juwulku wangkijangka. Pinapinakarrinyanila palu, “Nyapartukarra parlipa pungku.” Pikakujirnani palurlanyanu wangki Juwujwarntirlu marrijangkawarntirlu pungupurru Juwul. ");
INSERT INTO wmt_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Wali yangka palu Jesuskurawarntirlu pinakarrinyani wangki Juwujwarntikurajangka, wali wurnala palu warntarnkanya Juwul mayaruwarlanykarti ngapangal rirringki. Minyarti mayaru yini parla Jijirriya. Wali ngapakarrajirla ngurtingakujirni palu Juwul pungukarrarla. Yani pa Juwul kayili Taajijkarti nyantukurarlurra ngurrarakarti. Nyanartijangka tikiyanila palu Jurujulumkarrajiwarnti piyirnwarnti Jesuskurawarnti. ");
INSERT INTO wmt_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Wali nyanartijangka ngajirta manya ngananguwurti pungantarla Jesuskurawarnti. Pajajarrinyanila palu. Kanarlanywarntirlu palu Jesus mapunikanani. Jesuskurawarnti manya marlamanani Pirlurru Ngarpukurajangkarlu. Ngunanganila palu wirriya Jesuskurawarnti, yangkala palu jartamanani Ngarpu. Kajalkajalkujirnani palu Ngarpu. Wali Juwul pa kurnakkujirni Jesusju, ngurtpala palu ngunangani. Jesuskurawarnti palu ngurt ngunangani wamarnkujarra Jutiyakarrajiwarnti kanarlanywarnti Kalalikarrajiwarnti kanarlanywarnti Jimariyakarrajiwarnti. Minyarti pa Juwulkura wangki, yangka pa Jesusju kurnakkujirni Juwul. ");
INSERT INTO wmt_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Wali nganpayi yangkarti Pita Jurujulumngurni jakarni. Wamarn yanani mayaruwarlany mayaruwarlany. Pirriyanila manyanangurla Pita Jesuskurawarntirla mayarurla yininga Litanga. ");
INSERT INTO wmt_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Nyanayirla pa yukarnani mimijarti nganpayi wurnangajirtajarti. Yukarnumipa pa yukarnani kirrarnungajirtajartijaa wurnangajirtajarti. Yitilalwarnti 8 pa yukarnani. ");
INSERT INTO wmt_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Wali minyayirla nganpayirla manyanta marnpa pirriyani nganpayi Pita. Marni parla Pitangu, “Wulyukujiwujal manta Jesus Kurayijju jalarrarni. Turtangka. Rulumapkujirlanyanu pirlangkirr wurnapurru.” Wali partalurnila turtapinya wulyupalajirni. ");
INSERT INTO wmt_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Wali Litakarrajiwarntirlu piyirntu palu parlipinya nganpayi yangkarti jarlu yukarnani yukarnumipa, wurnala kitpungani. Nyanartijangkarlu walila palu kurnakwantinyajaa mapunikani palurla Jesusku, kaji palu nganpayi nyanarti nyanya, wulyula kitpungani mimi purlkajangkajinyangu. Litakarrajiwarntirlujaa pirntirrikarrajiwarntirlu mapirrirlu palu nyanya pirntirri pa Litangurni kayirrara. Nyangungurla palu kurnakwantinya Jesuskarti. Kirrarnanila manyanangurla Pita Litanga. ");
INSERT INTO wmt_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Wali marnin layi kirrarnani mayaruwarlanyja yininga Japanga. Nira manya marlamanani kanarlanywarnti. Mintimmarnani manya palya, mintimmarnurla manya yungani marlaljartiwarnti kujangkurrajarra. Jangarrajinyangu marnin nyanarti, yini parla Tukaj. Jesuskurajarti minyarti marnin. ");
INSERT INTO wmt_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Wali mimila wantinya purlka, pirlajarrinyala. Nyanartijangka ngapajawurlula palu wajimmarni kanarlanywarntirlu piyirnwarntirlu kankalajarra. Yurru manyanangu Juwujwarntikura. Nira palu kujartijarrinyani pirlawarnti palunya wajimmarnani. Wali nyanartijangkarlu palu warntarnkanya, yutukani palu mayarurla kaninykaniny. ");
INSERT INTO wmt_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Wali kanarlanywarntirlu Jesuskurawarntirlu palu pinakarrinya, yangkarti nganpayi Pita nyantu marnparni kirrarnani mayaruwarlanyja yininga Litanga. Marni palurlanyanu, “Purpankurlipa yangkarti nganpayi yini parla Pita.” Yiparni palupinya kurriny nganpayijarra mayarukarti Litakarti Pita purpanupurru. Yanungurla pilanyanta pirriyani Pitanga. Marni pilarla, “Yiparni pajarranyalu Japakarrajirlu Jesuskurawarntirlu nyuntupurru purpanupurru. Yanku manyanangurla Japakarti partalurni.” ");
INSERT INTO wmt_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Wali wurnala turtangkarrakanya. Yanila palu Pitajaa yangkartijarra nganpayijarra mapirri. Pirriyani palunyanangurla Japanga. Pinakanyala pila Pita mayarukarti pirla wanyjarrarla palu yutukani. Jamurn yangka Pita pirriyani takurryani kaninykaniny. Wali langkarnikanila palu kalkarrawarntirlu, ngumparna palunyanangu pirlajarrinya jarlu. Lungukarrarlurni palunyanta yijingkarra martarnani turitiwarntijaa kuluwujwarnti. Kujartikarra palurla marnani nganpayiwu Pitawu, “Minyartijal manpangu ngartakkanani nyanayirlurni pirlangu wanjingurnikarra.” ");
INSERT INTO wmt_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Wali nyanartijangka Pitangu manya puturu yiparni. Yani manyanta kankalajarrakarti. Mirtijurrurn wantinya manyanta partanta pirlanga. Japirlyinyala parlanyanta Ngarpu. Nyanartijangka marnila parla pirlawu nyanartiwu marninku, “Turtangka Tukaj.” Warrpunyanyaliny Pitarnila nyanya, nyanartijangka kirrarnuwantinyala. ");
INSERT INTO wmt_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Wali Pitangula ngarrpirtimani kurrapangurni. Karrinyukujirnila. Papajanila manyanangu Jesuskurawarntiwu, “Mirnu yanarnilu.” Takurryanila palu kalkarrawarntijaa kanarlanywarnti. Nyanyala palu marnin wanjila karrinyani. Marni manyanangu Pitangu, “Kaj nyakalu wanjijarrinyajal.” ");
INSERT INTO wmt_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Japakarrajiwarntirlu palu nyanya marnin nyanarti, yarnta palurlanyanu marnani Pitangu pa wulyukujirni nyanarti marnin. Nyanartijangka palu pajangu mapunikani nyangujangka Japakarrajiwarntirlu. Nyanya palu wanjijarrinya pirlajangka marnin nyanarti Tukaj. ");
INSERT INTO wmt_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Wali ngurrawarnti paja manyanta kirrarnani nganpayirla Jayiminta. Narrukurlangu pila kirrarnani Jayiminjarra. Pita pa yinijarrajarti kurrinyjarti Jayimin Pita. Jayiminwarlanyju Japakarrajirlu pa purlumankura jarrja ngartakkanani nira. ");
INSERT INTO wmt_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Nganpayi layi pa ngunangani mayarurla Jijirriyarla, yini parla Kuniliyaj. Maja manyanangu ngujangurra piyirnwarntiwu pajawu kulipariwarntiwu Yitilikarrajiwarntiwu. Kuniliyaj mapirri pa Yitilikarraji, ngajirta Juwuj. ");
INSERT INTO wmt_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Wali pakulyani nyantukurangurni yurru, Ngarpula mapunikanani. Wulyumarnani parla Ngarpukurawu wangkiwu. Ngarpukura pa ngujangurra nganpayi nyanarti. Ngarpu palu wajilpungani jampirlangurlujaa yapawarntirlu mapirrirni palu wajilpungani Ngarpu. Wulyu pa nyanarti nganpayi pamarr yungujuwal. Pamarrngajirtajarti manya yungani pamarr nyanartikarrajiwarnti Juwujwarnti. Juturni purayipurayimarnani parla Ngarpuwu. ");
INSERT INTO wmt_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Wali karuwarrajarti pa purayimarnani Kuniliyajju. Nyanyala yinjil, marnpa manyanta pirriyani. Ngarpukura yinjil minyarti, pirriyani manyanta wangkijarti. Yinila taj jularni yinjillu nganpayi Kuniliyaj. ");
INSERT INTO wmt_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Nganpayirlu pa warrpunyanya yinijangkala. Warrpunyangurla milpurrupurru purlkajarrinya, rayinjarrinyala pa. Marnila parla yinjilku, “Nganajangka pajin pirriyani.” Jangkumanila yinjillu, “Ngarpungu mangu wirriyajarrinya. Pinakarrinya manta Ngarpungu wangki purayimarnujangkajaa nyangani manta Ngarpungu pamarr mantanya yungany pamarrngajirtajartiwarnti, nyanartila mangu Ngarpu wirriyajarrinya. ");
INSERT INTO wmt_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Wali nyanartijangka parla yinjillu jinjinyinya. Marni parla, “Nganpayiwarnti yipanya kurlirra. Mayaruwarlanykarti palu yanku yinikarti Japakarti. Nganpayi palu parlipungurla purpankangku yini parla Jayimin Pita kurrinyjarti yini. ");
INSERT INTO wmt_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Wali nyanayirla manyanta najanu kirralany Jayimin Pita nganpayiwarlanyja. Purlumankura jarrja pa ngartakkarralany. Jawurlatarla marnpa pila rirringkirla kirralany. Narrukurlangu pila kirralany Jayiminjarra. Wali ruwangu palu purpanku nganpayi kurrinyjarti yini Jayimin Pita.” ");
INSERT INTO wmt_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Nyanartijangka yinjil pa yapyani. Wali papajanila manyanangu Kuniliyajju murrkurnku warrkammayinjarrajaa layi kulipari. Nyanartirlu kuliparirlu pa Ngarpu mapunikanani. ");
INSERT INTO wmt_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Wali jularni manyanangu kujartikarra Kuniliyajju, “Yinjil paji pirriyani. Wangki paji pirrikanya. Kujartikarra paji marni, yipawu marnanya nyurrawarnti kurlila. Ruwangu manta purpanku nganpayi Jayimin Pita. Wali nyanartikarra jakarni palu. ");
INSERT INTO wmt_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Kumantajarrinya manyanangurla kaparnparni. Jamurn palu marnpajarrinya, nyanartikarra Pita parayanungurla kankarni kirrarnani mayarurla. Nyanarti mayaru pa japal kirrarnupurru kankarnumarrangu. Kujartikarrala palurlanyanu ngartakpanani nyantuwarntirlu. Pita pa parayani kankarral mayarurla purayimarnupurru jininyarajarti. ");
INSERT INTO wmt_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Marranyanjarrinya pa Pita. Kanarlanyju warrarni kamparnani miyi. ");
INSERT INTO wmt_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","12","Wali Pitangu nyanartirlu nyanyala yalkiri langkirryani. Nyanartijangka kalukujilinypala nyanya kuyiwarntijarti. Kalukujilinyja manya nyanya kuyiwarnti nganapartu nganapartu yalkirikarrajiwarntijaa nguwakarrajiwarnti. Wali kanarlanywarntiwu kuyiwarntiwu palunyanangu jaminy ngunangani Juwujwarnti. Kanarlanywarnti kuyiwarnti palunya ngarnani. Nyantuwarntikura Juwujwarntikura yurru manyanangu kujartikarra. Jarluwarlany manyanangu jarrmarni Ngarpungu. ");
INSERT INTO wmt_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Wali marnila parla Pitawu Ngarpungu, “Turtangka Pita. Pungku mankurlanyanu kuyi ngarnupurru.” ");
INSERT INTO wmt_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Wali Pitangula manyanta jangkumani, “Ngajirta. Kayan ngarna nganyja. Yapajangkarni marna jaminy kujawurlurra nguniny. Kuyiwarntiwu yakurrwarntiwu marnanyanangu. Kanarlanywarnti kuyiwarntimipa marnanya ngalany wulyuwarntimipa. Kayan ngarna Juwujju nganyja kuyiwarnti yakurrwarnti yangka manpangu jarrmarni jarlu.” ");
INSERT INTO wmt_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Yarntarni parla marni Ngarpungu, “Yangka marna ngajungurni kurnakkujilany jaminyjangkawarnti, wulyula palu ngunawu nukarnini. Ngajirta ngan nyuntungu wanyjarra.” ");
INSERT INTO wmt_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Murrkurnmirri parla kirlingalparni marni Pitawu Ngarpungu, nyanartijangka pa kalukurla kuyiwarnti tikirrkanya kankarralparni. ");
INSERT INTO wmt_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Nyanartijangka Pita pa kirrarnani. Pinapinakarrinyani jutungu, “Nyapartukarra paja jinjinyinya Ngarpungu.” Wali nganpayiwarnti Jijirriyakarrajiwarnti palu pirriyani tawunta yininga Japanga. Nyanayirla pa kirrarnani Pita. Pirriyani palu, yangkala palunya japirlyungani nyanartikarrajiwarnti kujartikarra, “Wanyjurla marnalu parlipungku Jayiminkura mayaru.” Wali jirrkirlikanila palunya. Jularni palunyanangu, yanila palu jirrkirlparni. Pirriyani palu, tuwanga palu karrinyani. Pita pa warrarni kirrarnani kankarnumarrangu ngurrpa. ");
INSERT INTO wmt_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","20","Nyanartijangka marni parla Pirlurru Ngarpukurajangkarlu Pitawu, “Pinakarri. Muwupungana mangulu nganpayiwarntirlu murrkurntu. Turtangka. Jupantiwula man kaninyparral nganpayiwarntirlu murrkurntu mangulu jurumanana kaniny. Yantanyanangurla yarr murtarni. Ngajirta ngan jatparamanyja. Ngajungu marnanya yiparni nyuntukarti.” Wali papajanani palu yangkartiwarntirlu murrkurntu tuwangarni palu karrinyani, “Wayila. Jayimin Pita. Mularti ngan nguniny.” ");
INSERT INTO wmt_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Nyanartijangka Pita pa kankarningurni turtuyani, parlipinyala manya. Marni manyanangu Pitangu, “Ngajujal marna Jayimin Pita. Nganapurru manta pirriyani.” ");
INSERT INTO wmt_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Jangkumani palu, “Yiparni manpanya Kuniliyajju wangkijarti. Nganpayi nyanarti Kuniliyaj manyanangu maja nguniny kulipariwarntiwu. Wulyu pa nyanarti Ngarpukura. Ngajirta pa Juwuj, yangkala palurla Juwujwarntirlu nukarnirlu wulyumalany Kuniliyajku. Wali kumantawarlanyja yinjil manyanta pirriyani Kuniliyajja wangkijarti. Kujartikarra parla marni, yiparnila manpanya purpanupurru nyuntu. Purpanku marnantalu nyuntu. Kangku marnantalu kayili nyantukurakarti mayarukarti Kuniliyajkurakarti. Pinakarrku manta wangki nyuntukura nyapartukarra manurla julawu.” ");
INSERT INTO wmt_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Wali Pitangu manya takurrpinya mayarurla kaninykaniny. Layi ngurra palu yukarni pukanyja. Nyanartijangka kumantajarti palu jakarni Pitajaa Jijirriyakarrajiwarnti. Japajangkawarnti palunyanta mapirrirni yani Pitanga Jesuskurawarnti piyirnwarnti. ");
INSERT INTO wmt_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Yanani palu kayili. Kumantawarlanyja palu pirriyani Jijirriyarla. Wali kajaluwarlany manya marurrpinya piyirnwarnti jarntuwarnti Kuniliyajju. Pinakarriwu palunyanta wangki Jayimin Pitanga nyapartukarra manyanangu julawu. Jarranyangani palurla Pitawu. ");
INSERT INTO wmt_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Nyanartijangka Pita pirriyani. Jamurn takurryantarla, Kuniliyajjula parlipinya. Langkarnikanila Kuniliyajju Pita. Yanungurla manyanta parntawantinya jinanga Pitanga kajalkajalkujirnupurru ngurrpangurrparlu. Kularni Ngarpujilinyparni nyangani Pita Kuniliyajju, yarr pa piyirn. ");
INSERT INTO wmt_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Nyanartijangka Pitangu parla marni, “Turtangka. Karri. Yarr marna piyirn.” Wali karrinyukujirni pa Pitangu Kuniliyaj. ");
INSERT INTO wmt_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Takurryanila pila kaninykaniny mayarurla wangkiwangkikarra. Wali nyanyala manya pajajinyangu piyirnwarnti Pitangu. Kaninykaniny palurla jurumanani Pitawu. ");
INSERT INTO wmt_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Marni manyanangu Pitangu, “Kayan ngarnanyirrangulurla yanta Juwujwarnti. Nyurrawarnti manta kanarlanyparni Juwujngajirtajartiwarnti. Jaminy manpangulurla nguniny nganampawu Juwujwarntiwu. Ngaju marna Juwuj. Kayan ngarnanyirrangulurla najanu yanta mayarurla nyurrawarntikurarla. Nyurrawarnti mantarla pinarri minyartiwu jaminyku. Wali jalarramiparni marnanyirrangurla pirriyani yangka Ngarpungu paji kalarakujirni piyirnwarntiwujaa marninwarntiwu nukarnini palu kayanparni jaminyngajirta. Kurnakkujirni manya Ngarpungu jaminyngajirta ngunangupurru. Kayan ngarnanya kanginypungka kanarlanywarnti Juwujngajirtajartiwarnti jarntu wapalkarra. ");
INSERT INTO wmt_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Walirni marnanyirrangurla pirriyani Juwujngajirtajartiwarntirla. Ngajirta marnanyirrangurla yirrarnmanyjarla. Murtarni marnanyirrangurla lapantinya.” Yarntarni manyanangu marni Pitangu, “Japirlyungku marnanya, nganajangkarlu pajanta ruwangu purpani minyartikarti mayaru.” ");
INSERT INTO wmt_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Wali Kuniliyajju parla marni Pitawu, “Kumantawarlanyja marna purayimarnani mayarurla ngajukurarla. Karuwarrajarti marna purayimarnani jalarrajiliny. Wali nganpayi pajarla marnpa karrinyani langkarni. Kuluwuj nyantukura palypalymarnaninyirra. ");
INSERT INTO wmt_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Yini paja taj jularni. Wali nyanartijangka marnila paji ruwangu purpanupurru nyuntu. Kujartikarra paji marni yinjillu, ‘Ngarpungu mangu wirriyajarrinya. Pinakarrinya manta Ngarpungu wangki purayimarnujangkajaa nyangani manta Ngarpungu pamarr mantanya yungany pamarrngajirtajartiwarnti, nyanartila mangu Ngarpu wirriyajarrinya. ");
INSERT INTO wmt_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Nganpayiwarnti yipanya kurlirra. Mayaruwarlanykarti palu yanku yinikarti Japakarti. Nganpayi palu parlipungurla purpankangku yini parla Jayimin Pita kurrinyjarti yini. Wali nyanayirla manyanta najanu kirralany Jayimin Pita nganpayiwarlanyja. Purlumankura jarrja pa ngartakkarralany. Jawurlatarla marnpa pila rirringkirla kirralany. Narrukurlangu pila kirralany Jayiminjarra. Wali ruwangu palu purpanku nganpayi kurrinyjarti yini Jayimin Pita.’ ");
INSERT INTO wmt_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Wali yangkala marnanya yiparni nyuntupurru purpanupurru, mapunparnila mantalu purpani. Ngajirta manyanangurla yirrarnmanyjarla, minyartila man partalurni pirriyani.” Yarntarni parla marni Kuniliyajju Pitawu, “Jalarra marnalu minyayirla jurumanana nyuntuwu pinakarrinyupurru. Ngarpu marnapangurla nguniny mapirri. Pinakarrkula marnantalu wangki yangka mangu Ngarpungu takijularni, nyapartukarra manpangu takijulawu nganampawu.” Kujartikarra marni parla Kuniliyajju Pitawu. ");
INSERT INTO wmt_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","35","Nyanartijangka jularnani manyanangu wangki Pitangu purlka wangki. Marni manyanangu, “Ngarpungu parlipanya kayanparni nyangany piyirnwarnti nukarnini wangkiwarlany wangkiwarlanyjartiwurti marrijangkawurti wanyjurlawurti palu nguniny. Yangka ngananguwurti pa Ngarpu rayin nyanganyjaa wulyungal yanany, wali nyanarti, Ngarpu parla wirriyajarrilany. Jalarra paja pinarrikujirni Ngarpungu, jarlu ngajirta marna pinakarrinyantarlangurra.” ");
INSERT INTO wmt_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Yarntarni manyanangu marni Pitangu, “Ngarpungu manyanangu yiparni wangki Yijirayilkarrajiwarntiwu. Wangki minyarti wulyujinyangu nyapartukarra Jesus parlipangu pirriyani. Wirriyakujilany parlipanya Jesusju, wirriyala parlipangu nguniny Ngarpu. Purlka parlipangu nguniny wapalkarrawu Jesus Kurayij. ");
INSERT INTO wmt_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Pinarrijal mantarla wangkiwu minyartiwu, yangka manyanangu jakuljularnani Juntu Kalalipurtarra. Walila manya pulukkujirnani ngapanga. Kanarlanywarntiwu piyirnwarntiwu palunyanangu jularnani Jesuskura wangki. Jalyjularnani palunyanangu Jutiyakarrajiwarntiwu. ");
INSERT INTO wmt_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Pinarrijal mantarla Jesusku Najuritkarrajiwu, yangka Pirlurr Ngarpukurajangka manyanta takurryani. Ngarpungu manyanta yiparni. Nyanartijangka Jesus kitpungani wamarn. Wulyukujirnani manya, pirlangu manya tarrpartarnani, wali Jesusjula manyanangurla jurramanani. Yangka manyanta Ngarpu mapirri ngunangani, nyanartila manya wulyukujirnani.” ");
INSERT INTO wmt_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Yarntarni manyanangu marni Pitangu, “Nyangani marnalu nira nyapartukarra Jesus pa ngunanganijaa wulyukujirnani manya mayarurla Jurujulumja, yarnta wamarnkujarra Juwujwarntikurarla ngurranga. Mapunikani marnalurla. Tarnikanila palu mananga pirlawurra. ");
INSERT INTO wmt_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ngurrajarrarla kurrinyja kanarlanyja purangu Ngarpungu pa parnkimani pirlajangka. Ngarpungu manyanangurla kalarakujirni piyirnwarntirla. ");
INSERT INTO wmt_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ngajirta palu nukarnirlu nyakarla, nganamparlumiparni marnalu nyanya. Jarlu manpangu kurajpinya Ngarpungu, Jesus manpangu yipawu nyangupurru. Mapunparnila yiparni nyangupurru. Jesus manpangurla pirriyani turtapungujangka. Wali kapila marnalu ngarni nganamparlujaa Jesusju mapirri marnalu ngarni. ");
INSERT INTO wmt_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Jesusju manpanya jinjinyinya wangki kangupurru takijularnupurru. Piyirnwarntiwujaa marninwarntiwu marnalunyanangu julawu wangki wulyu. Yarnta marnalunyanangu julawu nyapartukarra Ngarpungu pa Jesus kajalkajalkujirni, nyakula parlipanya Jesusju, ngurrujarrakujiwula parlipanya. Kurajpungku parlipanya Jesusju wanjiwarntijaa pirlajangkapurrupurru parlipanya nyaku.” ");
INSERT INTO wmt_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Yarntarni manyanangu marni Pitangu, “Minyarti wangki marna julawu jarlu nganpayirlu puraputtu parlipangu lani kurrumparla yakurryakurr wajapungupurru. Puju ngananguwurti mapunikarralany Jesus, wali yakurryakurr manyanta wajapungku Ngarpungu. Kayan ngarta jutungu pinapinakarri Ngarpungu. Yangka parlipa Jesus yini julalany, nyanartila parlipangurla wajapungany.” ");
INSERT INTO wmt_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Wali nyanartikarra Pitangu manyanangu wangki jularnani. Wali Pirlurr Ngarpukurajangka manyanangurla wuwuyanani kanimpal nukarnilarni pinakarrinyujangkawarntirla, yangka palu wangki pinakarrinya. ");
INSERT INTO wmt_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Wali nyanartikarra wangkiwarlanypala palurlanyanu marnani wangki kanarlanyparni Juwujngajirtajartiwarntirlu, ngajirta nyantuwarntikura wangki, Ngarpungu manya yinya. Ngajirta palurlanyanu nginyjirrikarrarla wangki nyantuwarntikura Juwujngajirtajartiwarntirlu. Yarnta palu Ngarpu kajalkajalkujirnani. Pinakarrinya palu yangkartiwarntirlu Juwujwarntirlu Japakarrajiwarntirlu piyirnwarntirlu Pitangu mapirrirni. Wali nginyjirrikananila palu Juwujwarntirlu Japakarrajiwarntirlu nyapartukarra Ngarpungu manya Pirlurr Ngarpukurajangka yinyangurra yiji, wangkijangkala palu nginyjirrikanani Juwujwarntirlu. Wali karrpirlmarnila palu, tumaj palu Juwujngajirtajartiwarnti, kanarlanyparni palu nyanartiwarnti piyirn. Ngarpungu manya Pirlurr nyantukurajangka yinya Juwujngajirtajartiwarnti. Kula Juwujwarntimipa manya yungani Pirlurr Ngarpukurajangka. Kujartikarra palu pinapinakarrinyani nyantuwarntirlu. Wali nyanartijangka Pitangu manyanangu marni Juwujwarntiwu, ");
INSERT INTO wmt_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Wali minyartiwarnti manya yinya Pirlurr Ngarpukurajangka yangka jarlu parlipanya yinya ngalimpa nyanartijilinyparni.” Wali jularnani manyanangu Pitangu Juwujwarntiwu, “Pulukkujiwu parlipanya ngapanga. Kayan nganyanangu ngananguwurti jarrmanyja.” ");
INSERT INTO wmt_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Pitangu manya jinjinyinya ngapanga pulukkujirnupurru. Yini palu Jesus jularni, nyanartila palunya pulukkujirni ngapanga. Nyanartijangka lamakujirni palu Pita Kuniliyajngurrarlu. Ngunangani manyanangurla ngurrawarnti murrkurn. ");
INSERT INTO wmt_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","3","Wali Pitangu manya wanyjani Kuniliyajngurra, yani manyanangurla Jurujulumkarti. Wali pirriyani manyanangurla, langkarnikanila palu piyirnwarntirlu Juwujwarntirlu Jesuskurawarntirlu. Warntajpani palu. Wali kajalurni palu pinakarrinya warntawarnta. Kunyungurla palunyanangu karlpurrwarlanyju jularni minyarti wangki Pita manyanangurla kirrarnani mapirri Juwujngajirtajartiwarntirla, yarnta manyanangu jularni wangki Ngarpukura, nyanartila palu Juwujngajirtajartiwarntirlu mapunikani. Wali warntajpani palu Pita, marnila palurla Pitawu Juwujwarntirlu, “Nyapartu mannyanangurla kirrarnani Juwujngajirtajartiwarntirla, miyi mannyanangurla ngarnani. Kayan ngarlipanyanangurla nguna Juwujngajirtajartiwarntirla, yurru parlipangu nguniny.” ");
INSERT INTO wmt_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Wali Pitangu manyanu jularni nukarnini. ");
INSERT INTO wmt_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","6","Marni manyanangu, “Kayanmirri marna purayipurayimarnani mayarurla Japanga. Nyanartijangkarlu Ngarpungula paji winkirrjilinyju kanimpalkujirnani kalukujilinyja kuyiwarnti nganapartu nganapartu yalkirikarrajiwarntijaa nguwakarrajiwarnti. Yutukani pajarla marnpa, nyanyala marnanya kuyiwarnti nyanartiwarnti kalukujilinyja. ");
INSERT INTO wmt_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","8","Wali nyanartijangka paji marni Ngarpungu, ‘Turtangka Pita. Pungku mankurlanyanu kuyi ngarnupurru.’ Nyanya marnanya milluliny nyanartiwarnti kuyiwarnti, yakurrwarnti pajilurla jaminy. Wali yingurlmarnila marnanyanangu. ");
INSERT INTO wmt_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Yarntarni paji marni Ngarpungu, ‘Yangka marna ngajungurni kurnakkujilany jaminyjangkawarnti, wulyula palu ngunawu nukarnini. Ngajirta ngan nyuntungu wanyjarra.’ ");
INSERT INTO wmt_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Wali murrkurnmirri paji pirrikanya kalukurla nyanarti kuyiwarnti, nyanartijangka tikirrkanyala kankarral. ");
INSERT INTO wmt_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Wali nyanartikarra pajilurla pirriyani piyirnwarnti murrkurn Jijirriyakarrajiwarnti purpanupurru. ");
INSERT INTO wmt_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Pirlurru Ngarpukurajangkarlu paji jularni, ‘Wurna mannyanangurla yanku mapirri, ngajirta ngan jatparamanyja. Ngajirta ngan lamajarri.’ Wali yani marnanyanangurla nyantuwarntirla murrkurnwarlany murrkurnwarlany mapirrirni pajalurla wurnajarrinya Japakarrajiwarnti piyirnwarnti Jesuskurawarnti, yanila marnalu mayarukarti Kuniliyajkurakarti. Pirriyani marnalunyanangu. ");
INSERT INTO wmt_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","14","Wali Kuniliyajju paji jularni wangkiwarnti yinjil manyanta pirriyani, wali kujartikarra parla marni yinjillu Kuniliyajku, ‘Piyirnwarnti manya yipawu purpanupurru, purpanku palu Jayimin Pita kurlirrajangka Japajangka. Julawu mangu Ngarpukura wangki pirlurr wanjipurru mapunjinyangu.’ Wali takijularni parla yinjillu Kuniliyajku ngajupurru purpanupurru.” ");
INSERT INTO wmt_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","16","Yarntarni manyanangu marni Pitangu, “Jularni marnanyanangu wangki Ngarpukura Kuniliyajngurrawu pujuwurni, Pirlurr Ngarpukurajangkala manyanangurla wuwuyanungurla takurryani. Yangkarti jarlujiliny parlipangurla takurryani ngalimparla. Nyanartijangka marna pinapinakarrinyani Jesuskura wangki. Jarlu parlipangu jularni Jesusju ngalimpawu yangkarti Jun pulukkujirnujuwal. Ngapangakujirnani manya nganpayirlu Juntu piyirnwarnti, ngapapurula palu nguja piyirn, turtapinyala palu. Nyanartijilinyju parlipanya rukukarrku ngapajilinyju Pirlurru Ngarpukurajangkarlu. ");
INSERT INTO wmt_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Wali marna nginyjirrikanila Ngarpungu manya yinya Pirlurr nyantukurajangka kayanparni manyanangurla takurryani Juwujngajirtajartiwarntirla yangkarti parlipangurla takurryani Juwujwarntirla ngalimparla. Kayan ngarna lamakuji Ngarpu, ngaju marna yarr piyirn,” marni manyanangu Pitangu. ");
INSERT INTO wmt_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Wali yangkartiwarnti Juwujwarnti ngajirta palu yarnta warntajpanta. Wali manya kulkurukujirni Pitakurarlu wangkingu. Wali wirriyajarrinyala palurla Ngarpuwu. Marni palu, “Wali pa. Juwujngajirtajartiwarntiwurti manya marlamani. Kurnakwantiwu palu. Kurnakwantinyurla palu mapunikarrku Ngarpu, wanjila palu ngunawu kujawurlurra.” Wali Pitakura wangki minyartirni kutarni pujujarrinya, kanarlany wangkiwarlany parlipa nyaku. ");
INSERT INTO wmt_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Wali nganpayi yangkarti Tipin Jesuskura palu jarlurni luwarni pirlawurra. Wali nyanartikarrajangka Jesuskurawarnti palunya punganijaa jayilla palunya takurrpungani. Jesuskurawarnti palu pulykarrala yani Jurujulumngurni kujangkurrajarra pungukarrarla. Kanarlanywarnti palu yani marri. Mayaruwarntiwarlanykarti palu pulykarra yani yinikarti Yantiyakkartijaa Japurajkarti. Kanarlanywarnti palu yani Puniyijakarti. Wali jularnani palunyanangu Jesuskura wangki mayaruwarlanyja Juwujwarntiwumipa palunyanangu jularnani, ngajirta kanarlanywarntiwu. ");
INSERT INTO wmt_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Kalpurr palu yani nganpayiwarntiwarlany Jesuskurawarnti Japurajkarrajiwarnti Yantiyakkarti. Wali jularnanila palunyanangu Jesuskura wangki Yantiyakkarrajiwarntiwu Juwujwarntiwu, yarntarni palunyanangu jularnani Juwujngajirtajartiwarntiwu. Wali Japurajkarrajiwarntirlu palunyanangu jularnani Yantiyakkarrajiwarntiwu Juwujwarntiwujaa Juwujngajirtajartiwarntiwu. ");
INSERT INTO wmt_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Kurnakwantinyala palu Jesuskarti, mapunikananila palurla piyirnwarntirlu pajangu. Ngarpu manyanangurla mapirrirni ngujangurra Japurajkarrajiwarntirla. Marlamanani manya Ngarpungu, yangkala pajangujinyangu palu mapunikanani mayarurla nyanayirla Yantiyakja. Jesus purlka palu mapunikanani. ");
INSERT INTO wmt_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Wali Yantiyakngurni palu kanarlanywarnti jakarni Jurujulumkarti, jularnanila palunyanangu nyapartukarra palu mapunikanani Yantiyakkarrajiwarntirlu. Wali nyanartijangka yiparnila palu Jesuskurawarntirlu Jurujulumkarrajiwarntirlu layi nganpayi nyangupurrujaa pinakarrinyupurru, nyapartujarrinyani palu Yantiyakja piyirnwarnti Jesuskurawarnti. Yangkarti nganpayi yini parla Panapaj yangka Juwulku parla takitakijularnani. Yiparni palu Panapaj Jesuskurawarntirlu Jurujulumkarrajiwarntirlu. ");
INSERT INTO wmt_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Wali pirriyani manyanangu. Parlipinya manya, wirriyajinyangu palu ngunangani Juwujngajirtajartiwarntijaa Juwujwarnti. Ngarpu manyanangurla ngujangurra. Nganpayi Panapaj pa nyangungurla wirriyajarrinya. Wali lirrkarnpinya manya Panpajju, “Wajilpunganku manta Jesus jirrkirlparni, ngajirta nganta tikiyanta. Janginy kayan manta ngunawu, ngajirta nganta janginy kurrinykurriny nguna.” ");
INSERT INTO wmt_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Minyarti nganpayi Panapaj pa Ngarpukurajinyangu Pirlurrjartijinyangu. Ngarpunga manyanta mapunjinyangurlu mapunikanani. Wulyujinyangu minyarti nganpayi. Pajangu palunyanta Jesusja mapunikanani iyirnwarntirlujaa marninwarntirlu yangka Panapajju manyanangu wangki jularnani. ");
INSERT INTO wmt_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Wali nyanartijangka jakarni Yantiyakngurni Taajijkarti. Pirriyani Taajijja. Wali wamarn muwupungani parla nganpayiwu Juwulku wanyjarrarla ngunangani. ");
INSERT INTO wmt_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Nyanartijangkarlu parlipinyala. Parlipungurla purpankanya Yantiyakkarti. Nyanayirla pila kirrarnani layi yitilal Yantiyakja. Pinarriyungani pilanya Jesuskurawarnti piyirnjaa marnin wangki Ngarpukurajangka. Paja pilanya pinayungani Jesuskurawarnti. Wali nyanartikarra palunya Yantiyakkarrajiwarntirlu parlipungurla yinila palunya jularnani Kirijinwarnti palu nyanartiwarnti piyirnjaa marnin, yangka palu nira kurajpungani Jesus Kurayij. Ngajirta manya jarlu ngananguwurti jularla Kirijin Jesuskurawarnti. ");
INSERT INTO wmt_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Wali yarntarni palu jakarni Jurujulumngurni piyirnwarnti Jesuskurawarnti puraputwarnti. Nira palu yanani wangkijarti Ngarpukurajarti. Ngarpungu manya wangki yungani, nyanartila palunyanangu pinajularnani puraputtu. Pirriyani palu Yantiyakja puraputwarnti. Kirninyjala palu kirrarnani. ");
INSERT INTO wmt_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Wali layi nganpayi puraput yini parla Yakapaj. Turtapinya, karrinyungurnirlu manyanangu jularni. Ngarpukurarlu Pirlurru parla marni kaninykaniny turlpunga kujartikarra, “Layi yitilal parlipa ngunawu pulparr. Ngapa kayan ngarlipangu wanti mayaruwarntiwarlanyja mapirrirni, miyingajirtala parlipa ngunawu nukarnini.” Mapunparnila palu nguja miyingajirtajarti, yarnta ngapa ngajirta manyanangu wantirla miyi turtangupurru. ");
INSERT INTO wmt_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Nyanartijangka Yantiyakkarrajiwarnti Jesuskurawarnti palunyanangu yawiyijarrinya Jurujulumkarrajiwarntiwu, tumaj palu miyingajirtajarti. Wali marni palurlanyanu, “Kala pamarr parlipanyanangu kirninykirninymanurla yipawu Jurujulumkarrajiwarntiwu Jesuskurawarntiwu, miyila palurlanyanu warntawu.” Wali kirninykirninymani palunyanangu. Pamarr ngarrjajartiwarntirlu palu yutukanani pamarr purlka, pamarr lamparnjartiwarntirlu palu lamparn yutukanani. ");
INSERT INTO wmt_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ngarrjajarrinyala pamarr, kanyala pilanyanangu Panapajjujaa Juwullu. Kangungurla pilanya yinya Jurujulumkarrajiwarnti Jesuskurawarnti kajalkajalwarnti piyirnwarnti. ");
INSERT INTO wmt_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Wali nganpayi layi manyanangu ngujangurra yini parla King Yarrit. Purlka manyanangu Juwujwarntiwu nukarniwu kapuman. Yakurrmarnani manyanangu Jesuskurawarntiwu piyirnwarntiwujaa marninwarntiwu. Yiparnila manya kulipariwarnti pungupurru. Kanarlanywarnti Jesuskurawarnti palunya pungani kulipariwarntirlu Yarritkurawarntirlu. ");
INSERT INTO wmt_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Wali layi palu pinya pirlawurra, yini parla Jayimji. Lani palu nayipjawurlu purlkajawurlu pirlawurra. Jayimji parla papaji Junku mapirrikarraji Jesuskura. ");
INSERT INTO wmt_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","4","Wali yangka palu nyanya Juwujwarntirlu kanarlanywarntirlu Jayimji palu pirlawurra lani kulipariwarntirlu, wali nyangungurla palu ngarrurtajarrinya. Wali Yarrittu manya nyanya ngarrurtajinyangu palu nguja. Nyanartijangka Pitangkurrala palunyanta yani limpawarnti. Jinjinyinya manya Yarrittu, “Yantalunyanta. Tarrpartawu manta Pita.” Wali tarrpartarnurla palu kanya, jayilla palu yutukani. Yarrittu manyanu pinapinakarrinyani, “Kumantawarlanyja marnanya warra japirlyungku Juwujwarnti Pitawu ngulikanupurru. Jalarra palu ngarnana miyijaa kuyi pinalkarrapurru Juwujwarntirlu. Kumantawarlanyja marnanya japirlyungku warpinykujirnujangka.” Wali nyanartikarra Pita jayilla kirrarnani. Ngampurrikanani palu limpawarntirlu pajangu. Kalpurrwarlany palu ngampurrjiwarnti yanani paja manyankartijaa miyikarti. Wali manyanjangkawarntirlujaa miyijangkawarntirlu kurrinykurrinyju palu ngampurrikanani Pita. Nyanartijangka palu warrkamjangka yanani manyankartijaa miyikarti. Ngampurrjiwarntiwarlanyju kurrinykurrinyju palu martarnani Pita. Karla takurr kakarrara palu ngampurrikanani. ");
INSERT INTO wmt_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Wali Jesuskurawarntirlu palurla Pitawu purayipurayimarnani. Warryanungurla palurla purayimarnani Pitawu jayillajangkawu nurrururlu. ");
INSERT INTO wmt_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Wali nyanartijangka palu ngarnani Juwujwarntirlu kuyi pinalkarrapurru. Pujukujirni palu. Yarrittu manyanu pinapinakarrinya, “Wali kumanta marna kangku jayillajangka Pita ngulikanupurru.” Nyanartijangka pukanyjajarrinya. Pita pa jayilla ngunangani kaninykaniny mayarurla. Ngampurrjijarrarlu pilanyanu larrpuk karrpirni kurraparlu tanyjijawurlu Pitakurajawurlu. Nyantu pilangurla kaparn kirrarnani. Kanarlany parlanyanta mayakarti, kanarlany parlanyanta jampukarti. Kurrinywarlany pila ngampurrjijarra kirrarnani tuwanga. Pita pa manyanjarrinya. ");
INSERT INTO wmt_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Nyanartijangka pirriyani yinjil Ngarpukurajangka. Parralani manyanangurla tilingu. Nyanartijangka yingkilani yinjillu Pita. Parnkijarrinyala Pita. Wangki yinya yinjillu, “Partal turtangka.” Yulajwantinyala pila tanyjijarra kurrapajangkajarra. ");
INSERT INTO wmt_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Marnila parla yinjillu, “Mana wulyukujirlanyanu wurnapurru. Jinapurru yutukarranyanu kuwut mapirrirni. Wajilpungkaja.” ");
INSERT INTO wmt_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Wali wajilpinyala yinjil Pitangu winkirrjilinyjurni, minyakujalu mapun yanani. ");
INSERT INTO wmt_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Kaninykaniny mayarurla pila tirrinytirrinyyanani, kaninykaniny palu kirrarnani piyirnwarnti ngampurrjiwarnti tukujarra kurriny. Nyantujarra Pitajaa yinjil pilanyanangurla linyjarni tirrinyyanani palkangkurra. Pirriyani pila. Jamurn pila marnpajarrinya kiyitkarti, murtarnila ngurrujarrajarrinya kirlingirrijarrinyala. Purlka nguja tirrinyyanupurru. Ngajirtarni piyirntu yulajpantarla. Nyanarti kiyit pa purlkajinyangu tanyji lakjarti. Wali tirrinyyani pila kiyittal palkangkurra. Warntarrirlal pila yani. Nyanayirlarni parlanyanta wirlmarni yinjil, walila layi Pita yananinyirra. ");
INSERT INTO wmt_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Wali ngungkupinya manyanu Pitangu. Pinapinakarrinyani Pitangu. “Kularni marna winkirrparni yanana, minyakujala mapun. Mapunparni paji yiparni yinjil nyantungu Ngarpungu palkangkurrakujirnupurru. Yarrittu paja jayilla martarnani pungupurru. Kumanta pajalu pungkarla Yarrittujaa Juwujwarntirlu, yangkala paja yinjillu palkangkurrakujirni.” Kujarti pa Pitangu pinapinakarrinyani. ");
INSERT INTO wmt_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Wali nyanartijangka Pita yani mayarurlurra marninkurarlurra yini parla Mayiri. Mayiri parla ngamaji nganpayiwu yiniwu Jun Maakku. Yinijarra kurriny parla minyartiwu nganpayiwu Jun Maakku. Paja palu purayimarnani nyanayirla mayarurla piyirnwarnti Jesuskurawarnti. Purayimarnani palurla Pitawu jayillajangkawu. ");
INSERT INTO wmt_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pita yani nyanartirlurra mayarurlurra. Wali palkangarnila jajarrwantinya tuwanga. Palkangurnila narnarpinyangurra Pitangu tuwa. Palkanga pa karrinyani Pita. Pinakarrinya layingu mangangu warrkammayintu narnarpungujangka. Wali tuwangkurrala yani yulajpanupurru. Nyanarti pa manga yini Ruta. ");
INSERT INTO wmt_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Marni parla Pitangu palkangurni, “Yulajpantaji tuwa.” Pinakarrinyala lin Pitakura kaninykaninyngurni Rutangu. Pita nginyjirrikani, wirriyajarrinyala pa. Ngajirtarni pa Pita nyakarla, linmipa pinakarrinya. Wirriyarni manyanangurla tikirrlaparni. Ngajirta pa tuwa yulajpantarla takurryanupurru. Wali rukjartirni pa wanyjani tuwa nyanarti. Tikirrlaparnurla manyanangu jularni nganpayiwarntiwujaa marninwarntiwu purayimarnujangkawarntiwu. Marni manyanangu, “Pita pa karrinyana palkanga.” ");
INSERT INTO wmt_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Jangkumani palu, “Ngajirta. Pita pa jayilla nguniny. Wangarta man nyuntu.” Yarntarni manyanangu marni mangangu, “Ngajirta. Nyanarti pa Pita karrinyana.” Yarntarni palunyanta jangkumani, “Pita pa nguniny jayilla.” Panypinya palunyanta manganga. Marnila palurlanyanu, “Kunyungurla partarla wangarr karrinyana Pitawu.” ");
INSERT INTO wmt_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Wali jutungurni pa Pitangu palkangurni narnarpungani. Nyanartijangka tuwala palurla walimpa yulajpani. Wali nyanyala palu Pita karrinyujangka. Karrartajarrinyala palu. ");
INSERT INTO wmt_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Kulkurukujirnila manya Pitangu. Takitakijularni manyanangu nyapartukarra palkangkurrakujirni Ngarpungu. Marnila manyanangu, “Julalurla Jayimjiwu Jesusku parla ngaja, yarnta Jesuskurawarntiwu piyirnwarntiwu nukarniwu.” Wali wanyjanurlakanila manya mayaruwarlanykarti yani. ");
INSERT INTO wmt_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Wali kumantajarrinya, ngampurrjiwarnti palu rayinjarrinyani. Kumantajarti palurla karrartakarrartarlu jarti muwumuwupungani Pitawu rayintu. Ngampurrjiwarntimipa palu ngujangurra. Japirljapirlyungani palurlanyanu warntangurnirlu rayintu, “Wanyjurla nganpayi yangkarti Pita.” ");
INSERT INTO wmt_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Wali Yarrittu manya jinjinyinya ngampurrjiwarnti, “Muwupungurla warntalu.” Jarti palurla muwupinya ngajirtajinyangu. Ngajirta palu parlipungkarla. Yangkartiwarnti ngampurrjiwarnti manya Yarrittu japirlyinya yangka palu Pita ngampurrikanani, “Nyapartukarra manta yalayimani. Ngajirta manta ngampurrmantarla marrkingujinyangu.” Wali kulijarrinyala manyanangurla. Nyanartijangka jinjinyinya manya Yarrittu nyantukurawarnti warrkammayinwarnti pungupurru. Nyanartiwarnti ngampurrjiwarnti palunya pinya pirlawurra. Wali nyanartijangka Yarrit pa yani kayili mayaruwarlanykarti Jijirriyakarti. Nyanayirlarni pa kirrarnani. ");
INSERT INTO wmt_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Wali piyirnwarntiwu mayarujarrawarlanyjangkawu manyanangu kuli ngunangani Yarrit kayilungujangkawarntiwu Tayiyajangkawarntiwujaa Jayitanjangkawarntiwu. Kulijawurlu manyanangurla miyi jamungkani. Wali kayantajarrinya palu piyirnwarnti nyanartijarrajangka ngurrajarrajangka. Marnila palurlanyanu, “Yanku parlipanyanta Yarritkarti. Japirlyungku parlipa nganangurni parlipangu kulijarrinya. Wulyuwulyurni parliparla malku, miyila parlipanya yungku.” Wali wurnajarrinya palu Jijirriyakarti. Pirriyani palu. Marnila palurla layiwu warrkammayinku, “Kangku manpanya Yarritkarti. Japirlyungku marnalurla.” Kanya manya Yarritkarti. Japirlyinyala palurla, “Nganapurru manpanya ngunyipinya miyingurni.” Wulyuwulyurni palurla marni miyipurru. Jangkumani manya Yarrittu, “Wali marnanyirrangu malku kumantawarlanyja.” ");
INSERT INTO wmt_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Wali kumanta manyanangu pirriyani yangka manyanangu jularni Yarrittu. Kuluwuj manyanu wulyuwulyujinyangu yutukani Yarrittu, yutantinyala kirrarnupurrurla nyantukurarla. Nyanyala palu piyirnwarntirlu kuluwuj wulyujinyangu jurnanykarra nyantu mapirri. Nyantungu manyanangu wangki marnani. ");
INSERT INTO wmt_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Nyanartijangka piyirntu pajangu palu kajalkajalkujirnani Yarrit. Papajanani palurlanyanu, “Minyarti nganpayi pa Ngarpu. Ngajirta piyirn. Minyarti pa Ngarpujinyangu.” ");
INSERT INTO wmt_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Wali ngurrkuwarlany Yarrit kirrarnani. Ngajirta manyanangurla jarrmanyjarla. Wali Ngarpukurajangkarlu yinjillu mimikujirni nyanarti nganpayi Yarrit. Wantinyala mimi yukarnani. Yinjillu mimikujirni, ngajirta pa Ngarpu kajalkajalkujirnantarla. Nyantungu manyanu kajalkajalkujirni. Walila yinjillu mimikujirni. Kiwilkiwiljilinyju palu ngarni jilpirti, pirlawurra palu ngarni. Wali Yarrit pa pirlajarrinya. ");
INSERT INTO wmt_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Wali Jesuskurawarntirlu palunyanangu jularnani wangki Jesuskura. Pajala palu kurnakwantinya, mapunikanila palurla Jesusku mayarujangkawarntirlu. ");
INSERT INTO wmt_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Nyanartijangka yangka pilanya yungurlakani pamarrwarnti Jurujulumkarrajiwarnti, Yantiyakkarrajiwarntirlu palunyanangu yiparnijangka jarlu. Wali tikirrpala pila jakarni Juwuljaa Panapaj. Layiwarlany pila nganpayiwarlany kanya yangkarti Jun Maak. Kayili palu yani Yantiyakkarti. Pirriyani palu Yantiyakja. Wali nyanayirlarni palu kirrarnani. ");
INSERT INTO wmt_vpl VALUES ("C111_23","076_11_23","1CO","11","23","23","Ngarni palu miyi Jesusjujaa piyirnwarntirlu mapirrikarrajiwarntirlu. Nyanartikarrarni Jutajju Jesus pirtinyikarrku. Wali yangka palu miyi ngarnani, Jesusjula purlkangu miyi warntarni. ");
INSERT INTO wmt_vpl VALUES ("C111_24","076_11_24","1CO","11","24","24","Jamalkanyala parla miyiwu Ngarpu, nyanartijangka junganila. Marnila manyanangu piyirnwarntiwu, “Minyarti miyi pa karrkin ngajukura. Nyurrawarntiwu manyirrangu nguniny yungujangka. Kujartikarra manta jungananku pinalkarrapurru. Ngajula pajanta pinapinakarrinyanku.” Wali miyila palu ngarni Jesusngurrarlu. ");
INSERT INTO wmt_vpl VALUES ("C111_25","076_11_25","1CO","11","25","25","Nyanartijangkarlu narangalparni Jesusju warntarni pakirti wurujarti. Marnila manyanangu, “Minyarti wuru pa jurrmartajangka jalarrajangka. Junpungany pa nungujawurlu ngajukurajawurlu. Yangka manta kujarti ngarnanku pinalkarrawurra, ngajula pajanta pinapinakarrinyanku.” ");
INSERT INTO wmt_vpl VALUES ("C111_26","076_11_26","1CO","11","26","26","Yangka manta ngarnanku minyarti miyijaa minyarti wuru, wali nyanarti, nyakula manyalu nyurrawarnti kanarlanywarntirlu takiwurra. Nyangungurla palurla pinarri ngunawu Jesusku pirlajarrinyujangkawu kitangarni Jesus walimpa tikiyanku. ");
INSERT INTO wmt_vpl VALUES ("C115_20","076_15_20","1CO","15","20","20","Jesus Kurayij parlipangu pirlajarrinya, yutukani palu najinga, turtapinyala. Wanjikujirni pa Ngarpungu mapunparni. Nukarniwu parlipangu jarrkanya Jesusju. Yukalku parlipa narangalparni Jesuskurarlal. Walimpa parlipanya Ngarpungu wanjikujiwu. Yangka palu kajalkajal pirlajarrinya Ngarpukurawarnti piyirnjaa marninjaa yapa, nyanartiwarnti palu manyanjilinyparni yukalany kajalunypawarnti. ");
INSERT INTO wmt_vpl VALUES ("C115_21","076_15_21","1CO","15","21","21","Wali jarluwarlany pa kajalkajal pirlajarrinya nganpayi layi yini parla Ratam. Nyanartijangka layiwarlany nganpayiwarlany pa kajalkajal wanjikujirni Ngarpungu, yini parla Jesus Kurayij. ");
INSERT INTO wmt_vpl VALUES ("C115_22","076_15_22","1CO","15","22","22","Kujartikarra parlipa nukarnini Ratamjiliny pirlajarriwu. Yarntarni Jesus Kurayijjiliny parlipanya Ngarpukurawarnti wanjikujiwu Ngarpungu, yangka parlipa Jesus mapunikarralany. ");
INSERT INTO wmt_vpl VALUES ("C115_23","076_15_23","1CO","15","23","23","Wali nyanturni pa kajalurni wanjijarrinya. Kayan ngalu kanarlanywarnti kajalurni wanjijarri, tumaj Jesus pa kajalkajal. Jarlu pa nyantuliny Ngarpungu wanjikujirni, yarntarni parlipangu jarrkanya ngalimpawu jirnanyunguwu. Walimpa pa tikiyanku purlka nyantu Jesus, tikiyanujangkarlula manya wanjikujiwu Jesuskurawarnti, yangka palu mapunikarralany. ");
INSERT INTO wmt_vpl VALUES ("T11_1","084_1_1","1TI","1","1","2","Minyarti wangki marnangu yiparnana ngajungu yiningu Puwullu nganpayiwu Timitiwu. Nyuntuwu marnangu jarlu jularni Jesus mapunikanupurru. Wali mapunikanila manurla, yangkala marnanta nyangany walakujilinyparni. Wali ngaju marna yangkarti yangka marna jakulkangany piyirnwarntiwu Ngarpukura wangki. Ngarpungujaa Jesus Kurayijju pajapila wangki yinya jarlu, yangka parlipanya warntarni yakurryakurrjangka Ngarpungu. Nyanarti Jesusju parlipanya wanji yungku nirnparni, yangkala parliparla mapunikarralany. Wali mangupilarla ngunawu nyuntunga Timitirla Ngarpujaa Jesus Kurayij. Ngampurrikananku mantapila. Marlamananku mantapila nirangu. Munta mantapila kirtilykujiwu Ngarpungujaa Kurayijju purlkangu. ");
INSERT INTO wmt_vpl VALUES ("T11_3","084_1_3","1TI","1","3","3","Wali marnangu malany nyuntuwu Timitiwu. Lama kirranyja nyanayirla ngurranga yininga Yapisisja. Yangka marna jarlu tirrinyyanani mayaruwarlanykarti karla Majitaniyakarti, wali lirrangu marnanta lirrkarn yinya nyuntu lama kirrarnupurru Yapisisja. Yarntarni marnangu yipalany wangki kurrumparla lama kirrarnupurru. Wali kanarlanywarntirlu piyirnwarntirlu Yapisiskarrajiwarntirlu palunyanangu julalany wangki Ngarpukura, yangkala palu malany mapunngajirta. Ngajirta palunyanangu jirrkirl manyja wangki Ngarpukura. Nyanartijangkarlu manunyanangu jarrmalku. Kulkurukujiwu manunya wampalmarnujangka. Lirrkarnpungana marnanta kujarti jarrmarnupurru. ");
INSERT INTO wmt_vpl VALUES ("T11_4","084_1_4","1TI","1","4","4","Jarrmalku manunyanangu nyanartiwarntiwu piyirnwarntiwu, ngajirta ngalunyanu kajikajiyungka kurrumpajangka. Yarntarni ngajirta ngalunya kurajpungka pirlawarnti jarlujangkawarnti kilakiwarnti wanjiwarntirlu Juwujwarntirlu. Minyartijiliny pa yarr wangki. Yarr palu kirralany nira wangkijarti wapaljarti. Puju palu nira malany yarr wangkimipa, wali kayan ngalu warrkammanyja nyanartiwarntirlu piyirnwarntirlu Ngarpukura. Puju palu Ngarpu mapunikarra, warrkampala palu warrkammanyja Ngarpukura. Wali puju parlipa Ngarpu mapunikarra ngalimparluwurti, wali nyanarti, warrkam parliparla warrkammanyja Ngarpukura. ");
INSERT INTO wmt_vpl VALUES ("T11_5","084_1_5","1TI","1","5","5","Puju manunyanangu jarrmalku, wali tapungmankula palunyanu puju manunyanangu takitakijulawu. Tapungmanku palunyanu piyirnwarntirlu, tumaj manya Ngarpungu lukurrpinya kaninykaniny. Yarntarni yakurryakurrku palurla yakurrmalku. Yarntarni palurla Ngarpuwu mapunikarrku mapunparni. ");
INSERT INTO wmt_vpl VALUES ("T11_6","084_1_6","1TI","1","6","6","Kanarlanywarntirlu palunyanu ngajirta tapungmanta. Nganga palu yanany wangkiwangkikarra, tumaj palu nira pinapinakarrilany wangki wapal. Nganga palu yanany. ");
INSERT INTO wmt_vpl VALUES ("T11_7","084_1_7","1TI","1","7","7","Wali yangkartiwarntirlu palurla wulyumalany wangki jularnupurru takiwurra. Pinayungany palunya wangki Ngarpukura yangka Ngarpungu parla jarlu yinya Mujij, yangkala palunya pinayungany ngurrpangu. Kula palu pinarrirlurni malany pinangurrujilinyparni, minyakujala palunya ngurrpangu pinayungany. ");
INSERT INTO wmt_vpl VALUES ("T11_8","084_1_8","1TI","1","8","10","Wali wangkiwarlany marnangu takijulawu. Jarluwarlany parla Ngarpungu Mujij yinya wangki yini luwu jirrkirlikanupurru piyirnwarnti, tumaj palu yakurryakurrjuwal piyirnwarnti. Kanarlanykanarlany yakurrwarnti palu yanany wapalkarra luwungajirta Mujijkurangajirta. Mapunikarralany palunyanu nyantuwarntirlu ngangamartarlu wapalkarra yanujuwallu. Kanarlanykanarlany palu nguniny munta parntaparnta, Ngarpungajirtarlal palu yanany yakurral. Kanarlanykanarlanyju palurla Ngarpuwu jirnapungany. Kayan ngalu pinakarri Ngarpu. Kanarlanykanarlany palu ngamaji pungujuwaljaa ngarpu pungujuwal. Pungany palurlanyanu ngamajijaa ngarpuwurti pirlawurra. Kanarlanykanarlany palu yarr wapalkarra pungujuwal pirlawurra. Piyirnwarnti kanarlanywarnti palu yakurr nguniny. Kanarlanywarntirlu palunya kartuwarlany warntarnkarrakangany kanarlanykura piyirnkura. Ngurrangurra yungany palunyanu. Yarntarni marnintu palunya warntarnkarrakangany piyirnwarlany. Kartu parla wartangurni kirralany. Yarntarni piyirnjarrarlu pilanyanu kartukujilany nganpayijarrarlu. Kanarlanykanarlany palu ngurru kangany ngurrijirlu piyirnwurti, marninwurti yapawurti. Tarrpartalany palurlanyanu jingnyangupurru. Ngajirta palu yartajpanta. Kanarlanykanarlany palu yirrijiwarnti. Yarntarni palu kanarlanykanarlanyju piyirntu kayanparni ngirtilykarra julalany. Wapaljirlu nganpayirlu kujikarralany nyanarti nganpayi wulyu mapunji. Kula mapun, minyakujala wapal. Kanarlanykanarlany palu yanany yakurrwarlanyjarti Ngarpungajirtajarti. Minyartila manyanangu Mujijkura wangki nukarniwu piyirnwarntiwu. Puju palu yirrikarrkula wangki Mujijkurajangka, wali nyanarti, nginyjirrikarrku palunyanu yakurryakurr nyantuwarntikura. Wali wulyu wangki pa minyarti Mujijkurajangka, yangkala palu kanarlanywarntirlu ngajirta mapunikarra. Yakurral palu yanany narangal. Kanarlanywarntirlu palu mapunikarralany wangki Mujijkurajangka, wulyungal palu yanany. Yarnta kanarlanywarntirlu palu lup pinakarrilany, ngangayananypala palu. Yakurr palu nguniny puturu pinakarrinyujangka. ");
INSERT INTO wmt_vpl VALUES ("T11_11","084_1_11","1TI","1","11","11","Wali julalany marnangu wangki yangka parlipa jarlujangka martalany Ngarpukura. Ngajirta marna manyja ngajukurajangka milyilyijangka. Ngarpungu paja jarlu yinya wangki minyarti nyantungu wulyujinyangurlu wirriyajuwallu. ");
INSERT INTO wmt_vpl VALUES ("T11_12","084_1_12","1TI","1","12","12","Wali, wirriya marna nguniny ngarrurta, tumaj paja wirriyakujirni Jesusju ngalimpakurarlu purlkangu Kurayijju paja ngarrurtakujirni. Warrkam nyantukura paja yinya Jesusju, marlamananywurti paja warrkampurru. Nyanartijangka marlamanujangka marna Jesus jamalkangany. Jarlu paja nyanya Jesusju. Pinapinakarrinya parlanyanu kujarti, “Nganpayirlu minyartirlu Puwullu paji wulyu warrkammalku mapun, walirni pa yakurr nguniny. Kurajpungkula marna warrkampurru.” Wali kurajpinyajal paja nyantukurapurru warrkampurru. Kurajpungujangka marna ngarrurtajarrinya. Wali marna yakurr nguja, yangkala paja warrkam yinya nyantungurni. ");
INSERT INTO wmt_vpl VALUES ("T11_13","084_1_13","1TI","1","13","13","Ngajirta marna jarlu mapunikanantarla Jesus. Nyanarti Jesus marna jarlu jingkirrkangani ngurrpangu. Walirni paji luyurrmarni Jesusju. Yarntarni marnanya pinya piyirnwarnti Jesuskurawarnti mapunikanujangkawarnti. Warrarni marna ngunangani kuliparirni, tumaj marnarla ngurrpa nguja Jesusku. Panypinya marnanyanta Jesusja, yangkala marnanya Jesuskurawarnti pinya ngurrpangu. Yarrwurti paja pungkarla Ngarpungu. Ngajirta. Yararni paji ngujangurra. Luyurrmarnani paji nyantungu Ngarpungu. ");
INSERT INTO wmt_vpl VALUES ("T11_14","084_1_14","1TI","1","14","14","Yawiyijarrinya paji, yangkala paja mapunjinyangu palymani munta kaninykaniny purlkangu ngalimpakurarlu. Kaninykaniny pirlurr paja kurnakkujirni mapunkujirni. Tapungmani paja, Jesus Kurayijjula pajarla yutukani tapungmanupurru piyirnwarntipurru. ");
INSERT INTO wmt_vpl VALUES ("T11_15","084_1_15","1TI","1","15","15","Minyarti mapun. Tarrpartawu parlipa pinangu, mapunikarrkula parlipa wapalkarrarlu nyapartukarra Jesus Kurayij pirriyani kankarnumarrangujangka minyayirla nguwanga tikirrkujirnupurru piyirn yakurrjangka. Wali ngaju marna yakurrjinyangu nguja, yini Puwul. Nyanartiwarntijiliny marna nguja yakurr, ");
INSERT INTO wmt_vpl VALUES ("T11_16","084_1_16","1TI","1","16","16","yangkala paji Ngarpungu luyurrmarnani ngajuwu yakurrku, marlamanila paja. Ngajirta paja pungkarla yakurrjangka. Warrarni paji jurumanani rawa yakurrjinyanguwu, yangkala pajalu nyaku kanarlanywarntirlu takiwurra. Pinarri palurla Ngarpuwu jurumanujuwalku ngunawu. Wali mapunikarrkula palurla Jesusku nyangujangkarlu, wanjila manya yungku kujawurlurra. ");
INSERT INTO wmt_vpl VALUES ("T11_17","084_1_17","1TI","1","17","17","Mapunparni marnangu malany. Yangkarti Ngarpu pa kayan nyantu. Maja parlipangu nguniny ngalimpawu nukarniwu. Jarluwarlanyjangka parlipangu maja nguninyparni kujawulurra ngunawu. Ngajirta pa pujujarri Ngarpu, kujawulurra pa wanji nguniny. Kayan ngarlipa piyirnwarntirlu nyaka nguwakarrajirlu. Jarti parliparla nyangany millu. Ngurt parlipanyanta nguniny yangka parlipangu kajalkajal nguniny nyantu kujawurlurra nirnparni. Yangkajal parlipangu kajalkajal nguniny. Mapunparni nyanarti wangki. ");
INSERT INTO wmt_vpl VALUES ("T11_18","084_1_18","1TI","1","18","18","Yarntarni marnangu malany Timitiwu ngajukurawu walakujilinyku. Nyuntungala mangulurla jakulkanya piyirnwarntirlu Ngarpukura wangki jarntuwarntirlu nyuntukurawarntirlu. Wali wangki minyarti tarrpartarnanku man. Pinapinakarriwu man Ngarpukura wangki jakulkangujangka. Lirrkarnpungana marnanta Timiti. Puju nganawurti mangurla wuwuyanku, wali nganyja manta yangkarti wangki. Warnta nyanarti milyilyirlajangka wangki Ngarpukura yangka mantalu yinya jarntuwarntirlu nyuntukurawarntirlu. Mapunikananku man Timiti Ngarpu mapunwurra. Yakurrmalku manurla yakurryakurrku. ");
INSERT INTO wmt_vpl VALUES ("T11_19","084_1_19","1TI","1","19","19","Wali kanarlanywarntirlu piyirnwarntiwarlanyju palurla ngajirta yakurrmanyja yakurryakurrku. Wirriyajarrilany palurla yakurrku. Ngajirta palu pinapinamanta wulyuwulyu. Jesusku palurla mapunikarralany, yangkala palu rukarnurla tikiyanany. Ngurtijilinyparni palu junglapalany nirnparni. ");
INSERT INTO wmt_vpl VALUES ("T11_20","084_1_20","1TI","1","20","20","Nganpayijarra kurriny pila junglaparni. Ngangayani pila nganpayijarra yinijarra Raminiyasjarra Yaliksanta. Nyantujarra marnapinya ngajungu Puwullu pirtinyikani pirlakarti purlkakarti. Pirla purlka marnarla yinya nganpayijarra yangkartijarra. Kayan ngartapila yarnta jingkirrkangka Ngarpu. ");
INSERT INTO wmt_vpl VALUES ("T12_1","084_2_1","1TI","2","1","1","Wali wangkiwarlany marnangu julalany wangki marrki martarnupurru. Yangka manta yanany jujukarti Ngarpukurakarti, jamalkangku manta Ngarpu yungujuwal. Yarntarni malku mantarla ngarntimankula manta. Japirlyungku manta Ngarpu piyirnwarntiwu nukarniwu. ");
INSERT INTO wmt_vpl VALUES ("T12_2","084_2_2","1TI","2","2","2","Japirlyungku manta purlkawarntiwu kapumanwarntiwu, yarntarni majawarntiwu nukarniwu manta Ngarpu japirlyungku. Nyanartijangkarlu parlipanyalu yirrikijawurlu martawu, ngurtpalkula parlipa. Mapunjinyangu parlipa karriwu layirni, jirrkirljinyangu parlipa ngunawujaa yanku. ");
INSERT INTO wmt_vpl VALUES ("T12_3","084_2_3","1TI","2","3","3","Puju parlipa japirlyungku Ngarpu piyirnwarntiwu, wulyu pa nyanarti mapun. Wirriyajarriwula parlipangu Ngarpu ngalimpakura wanji yungujuwal. ");
INSERT INTO wmt_vpl VALUES ("T12_4","084_2_4","1TI","2","4","4","Ngarpu pa nyantu wirriya nguniny wanji yungupurru. Wali wanji manya nukarnini kurnakkujiwu Ngarpungu nyantungu. Mapunparni manya kurnakkujiwu nukarnini, pinayungkuwurti manya pinarriwurra nukarnini, yangkala kanarlanywarntirlu palurla pinakarrilany. Kanarlanywarntirlu palurla ngajirta pinakarri Ngarpuwu. ");
INSERT INTO wmt_vpl VALUES ("T12_5","084_2_5","1TI","2","5","5","Ngarpu pa nguniny kayan, nyantumipa layi. Wali jarlu parlipanya yakurru ngangakanya Ngarpungurni, nyanartila parlipanyanta marrijarrinya Ngarpungurni. Kayan ngarlipa tikiyanta piyirnmipa. Jesusju parlipanya tikirrkujilany Ngarpukarti nyantumiparlu. Pirriyani parlipangu Ngarpungurni Jesus Kurayij nganpayi tikirrkujirnupurru. Layingumipa parlipanya tikirrkujilany Ngarpukarti Jesusjumipa. Ngajirta ngananguwurti tikirrkuji, marlaljinyangu. Layimipa parlipangu pirriyani Jesusmipa. ");
INSERT INTO wmt_vpl VALUES ("T12_6","084_2_6","1TI","2","6","6","Yangka parla katungkajarrinya Jesuspurru pirriyanupurru, wali yijingkanyala manyanangurlanyanu Jesusju nukarniwu piyirnwarntiwu marninwarntiwu yapawarntiwu. Ngarpungu manya wanji yungku, yangkala Jesus pirriyani, yijingkanyala manyanangurlanyanu takijularnupurru. ");
INSERT INTO wmt_vpl VALUES ("T12_7","084_2_7","1TI","2","7","7","Wali Jesusju manyanangurlanyanu yijingkanya, nyanartila paja ngaju yinya wangki jakuljularnupurru Jesusju. Jakuljulalany marnanyanangu piyirnwarntiwu kanarlanywarntiwu. Ngajirta Juwujwarntiwu, piyirnwarntiwarlanyku marnanyanangu jakuljulalanyjaa pinarriyungany marnanya. Pinarriyungany marnanya Jesus mapunikanupurru, yarnta marnanya pinarriyungany nyapartukarra Ngarpuwu palurla pinarrijarriwu. Mapun marnanyanu julalany, ngajirta yirri, mapunparni marnanyanu julalany jirrkirl. ");
INSERT INTO wmt_vpl VALUES ("T12_8","084_2_8","1TI","2","8","8","Yarntarni wangkiwarlany jujupurru. Lirrkarn marnanya yungany nganpayiwarnti Ngarpukurawarnti. Ngarpuwu palurla manyja nirangu. Yarnta palurla munta kayan nguna Ngarpuwu. Japirlyungku palurla Ngarpu kulimulurlu. Ngajirta ngalu kuli pinapinakarri ranyjingu muntanga kaninykaniny. Mapunjinyangu palu japirlyungku Ngarpu. ");
INSERT INTO wmt_vpl VALUES ("T12_9","084_2_9","1TI","2","9","10","Wali yarntarni marnanyanangu marninwarntiwu malany lirrkarn. Marninwarnti palu ngunawu wulyu. Nira palunya kanarlanywarnti marlamananku. Kujarti palu yanku marninwarnti Ngarpukurawarnti Kutkurawarnti. Karrkinta palu mana kangku turiti wulyu mapuntu, walirni palu ngajirta nira pinapinakarri turitijaa nganapartu nganapartu ngurrkuwurra. Ngarpuliny palu pinakarriwu. Ngajirta ngalu turitimipa warntarnanta pamarrjawurlu purlkapurlkajawurlu. Ngajirta ngalu pujukujirnanta manawarntirlamipa. Ngajirta ngalu marninwarnti manajarti wulyujarti ngurrkujarrinyanta. Wulyu palu yanku marlamanujuwal. ");
INSERT INTO wmt_vpl VALUES ("T12_11","084_2_11","1TI","2","11","13","Yarntarni palu marninwarntirlu kulkururlu pinakarriwu Ngarpukura wangki karrkarnurla. Jarrmalany marnanyanangu marninwarntiwu ngajungu Puwullu, ngajirta ngantanya nganpayi pinayungka wangki. Kirranyjalu kulkuru marninwarnti. Pinakarrilu Ngarpukura wangki. Wali ngajirta ngalunyanu murta kajalkajalkuji marnintu, yangka pa nganpayimipa kajalkajal nguniny, tumaj jarluwarlany nganpayiliny pa Ngarpungu ngartakpani yini Ratam. Nyanartijangkala pa marnin ngartakpani yini Yip jirna. ");
INSERT INTO wmt_vpl VALUES ("T12_14","084_2_14","1TI","2","14","14","Marnin yangkarti parla pirlangu purlkangu kajiyinya, mapunparnila yakurra wantinya, yini parla Yip. Ngajirta nganpayi Ratam parla kajiyungkarla pirlangu. Marninturni parla mapunikani. Wali nyanartikarrala marnanya lirrkarn yungany nyantuwarnti marninwarnti. ");
INSERT INTO wmt_vpl VALUES ("T12_15","084_2_15","1TI","2","15","15","Wali marninwarnti palu nguniny yapa martarnupurru, yangkala palu walirni ngunawu Ngarpukura. Kayan ngumparna parlanyanu martawu. Puju palurla juturni mapunikarralany yapa martarnujuwallu, Ngarpu palu puju wajilpungany marninwarntirlu, wali nyanarti, wanji manya yungku Jesusju. Puju palunya kanarlanywarnti tapungmanany, Jesusju manya yungku wanji kujawurlurra. ");
INSERT INTO wmt_vpl VALUES ("T13_1","084_3_1","1TI","3","1","1","Wali yarntarni, nganpayiwarnti marnanya lirrkarnpungku ngampurrjiwarnti. Yangka nganawurti manyanangu ngunawu purlka ngampurrji kajalkajal Ngarpukurawarntiwu, wali nyanarti wulyu ngunangupurru. Mapunparni minyarti wangki. ");
INSERT INTO wmt_vpl VALUES ("T13_2","084_3_2","1TI","3","2","2","Wali wangki minyarti marnangu malany Puwullu Timitiwu mapirrirni. Kangku man minyartirni wangki, jakulkangku manunyanangurla yangkartiwarntirla piyirnwarntirla ngampurrjiwarntirla, nyapartukarra palu purlka ngunawu nyanartiwarnti piyirnwarnti. Nganpayi Ngarpukura ngampurrji wulyujinyangu pa ngunawu mapunji wapalngajirta. Yarnta pa ngunawu ngapa ngarla ngarnungajirtajuwal. Ngajirta ngarta ngapa nganyja wangartawurra. Yarnta yirrikijarti pa ngunawu. Yarntarni pa kartujarti layijarti ngunawu. Kayanmipa pa kartu martawu. Yarnta jarntukujirnujuwal pa ngunawu, yangka manya jarntukujilany piyirnwarnti kanarlanywarnti nganpayirlu nyanartirlu. Yarnta pa ngunawu pinayungujuwal yangka manya pinarriyungany kanarlanywarnti takiwurra. ");
INSERT INTO wmt_vpl VALUES ("T13_3","084_3_3","1TI","3","3","3","Yarntarni nganpayi ngampurrji pa wulyu ngunawu. Ngajirta ngarta ngapa ngarla ngarnanta wangartawurra. Yarnta ngajirta ngarta pungujuwal nguna kulijuwal. Ngunawu pa kirtily. Kayan ngarta jirljirljarri jingnyangujangkawurti, marlalparni. Jarti palu kuliwu yingkiyingkilanku, warrarni pa nguniny kirtily. Yarnta ngampurrjirlu ngajirta ngartarla pamarrku kurturrkurturrmanyja purlkawu. ");
INSERT INTO wmt_vpl VALUES ("T13_4","084_3_4","1TI","3","4","4","Yarntarni manyanangu ngampurrji maja ngunawu yapawarntiwu nyantukurawarntiwujaa kartuwu nyantukurawu. Nyantukurawarntirlu yapawarntirlu palu pinakarrilany wangki. Pinakarrinyurla mapunikarralanypala ngarpu nyantuwarntikura. Yapawarntirlu ngarpunyankurala palu wulyu julawu mapunji. ");
INSERT INTO wmt_vpl VALUES ("T13_5","084_3_5","1TI","3","5","5","Wali puju manya nyantukurawarnti yapawarnti ngampurrikarralany wulyuwurra kartu mapirri, nyanarti nganpayi manyanangu maja mapunji ngunawu Ngarpukurawarntiwu piyirnwarntiwu. Ngampurrikarrku manya piyirnwarnti Ngarpukurawarnti wulyuwurra. Puju ngajirta manya ngampurrikarra nyantukurawarnti yapawarnti, wali kayan nganyanangu maja nguna Ngarpukurawarntiwu piyirnwarntiwu. Kayan nganya ngampurrikarra piyirnwarntiwurti. ");
INSERT INTO wmt_vpl VALUES ("T13_6","084_3_6","1TI","3","6","6","Yarntarni pa ngampurrji ngunawu nganpayi yangka jarluwarlany mapunikani. Puju jalarrarni mapunikarralany, ngajirta nganta yutukarra purlka ngurrkungamarra. Ngurrkujarrinyanta ngarta, yangkala ngarta ngulikarra ngurrkuji Ngarpungu, nyanartijiliny jarlu ngulikani pirla purlka Ngarpungu. ");
INSERT INTO wmt_vpl VALUES ("T13_7","084_3_7","1TI","3","7","7","Yarntarni pa nganpayi ngampurrji ngunawu kujarti. Puju palu julalany mapunji piyirnwarntirlu Ngarpukurarlujaa rantangakarrajirlu piyirnwarntirlu, wali nyanarti, pinarri palurla mapunjiwu nguniny. Nyanarti nganpayi warntalu ngampurrji manta majakujiwu Ngarpukurawarntiwarlanyju. Puju palu julalany yirriji, rantangakarrajirlu piyirntu, wali nyanarti, ngajirta nganta Ngarpukurawarntirlu warntarnurla majakuji, tumaj ngalu kurntayikuji wangkingu kanarlanywarntirlu. Nyanartijangka pirlangu ngarta tikirrkuji nganpayi nyanarti maja ngampurrji. ");
INSERT INTO wmt_vpl VALUES ("T13_8","084_3_8","1TI","3","8","8","Wali piyirnwarntiwarlany palu nguniny Ngarpukurawarnti marlamanujuwalwarnti. Nyanartiwarnti marnanya lirrkarnpungku. Yanku palu wulyu yirrikijarti. Mapunikarrku palurla Jesuskuliny. Ngajirta ngalurla pamarrku mapunikarra, yangkala ngalu kurakurajarrinyanta nirnparni. Yarnta ngajirta ngalu ngapa purlka nganyja yini wayin, yangkala ngalunyanta rukanyja. ");
INSERT INTO wmt_vpl VALUES ("T13_9","084_3_9","1TI","3","9","9","Kitpanku palu Ngarpukuraliny wangki milyilyirlu, yangka parlipangu Jesusju jakuljularni. Kitpanku palu mapuntujinyangu ngajirta kurrinykurrinyju. ");
INSERT INTO wmt_vpl VALUES ("T13_10","084_3_10","1TI","3","10","10","Wali puju nganpayi nguniny wulyu yangka marnangu marni, wali nyanarti, yirrikarrku manta kurajpungkula mantarlanyanu yirrikanurla nyurrawarntirlu piyirnwarntirlu Ngarpukurawarntirlu, yangkala manta yutukarrku piyirn marlamanujuwal Ngarpukura. ");
INSERT INTO wmt_vpl VALUES ("T13_11","084_3_11","1TI","3","11","11","Yarntarni marninwarntiwurti marnanya lirrkarnpungku. Yanku palu wulyuwarnti mapunjiwarnti. Ngajirta ngalu ngapa nganyja, yangkala ngalu wangartajarri. Yarnta ngajirta ngalunya ranyjingu kurajpunganta nganpayijaa marnin kuliwurra. Yirrikijarti palu ngunawu. Kujarti palu marninwarnti yanku wulyu. ");
INSERT INTO wmt_vpl VALUES ("T13_12","084_3_12","1TI","3","12","12","Wali nganpayi marlamanujuwal pa ngunawu kartujarti layijarti. Kayanmipa pa kartu martawu. Yarntarni manyanangu Ngarpukura marlamanujuwal ngunawu maja yapawarntiwu nyantukurawarntiwujaa kartuwu nyantukurawu. Nyantukurawarntirlu yapawarntirlu palu mapunikarralany ngarpunyankura. ");
INSERT INTO wmt_vpl VALUES ("T13_13","084_3_13","1TI","3","13","13","Yangka nganpayirlu parla warrkammalany mapunjinyangu Ngarpuwu, wali kanarlanywarntirlu palu nyangany warrkammayin wulyu. Malany manyanangu nganpayirlu nyanartirlu Ngarpukura wangki. Purnkungu manyanangu Jesus julalany yangkala palu kanarlanywarntirlu pinakarrilany wangki nyantukura. Pinakarrilany palu mapun. ");
INSERT INTO wmt_vpl VALUES ("T13_14","084_3_14","1TI","3","14","14","Wali Timiti, yanku marnantarla nyuntukarti najanu. Ngungkupungana marna wirriya yanupurru. Kunyungurla marna yanku jalarrarni, kunyungurla marna yanku walimpa. ");
INSERT INTO wmt_vpl VALUES ("T13_15","084_3_15","1TI","3","15","15","Puju marna lama warra kirralku, wali nyanarti. Minyarti man martawu lirrkarn lanujangka ngajukurajangka. Pinarriyungany marnanta yangkarti mirlimirli nyapartukarra parlipa Ngarpukurawarnti ngunawu. Wali Ngarpu ngalimpakura pa wanji nguniny, mapunikarralany parliparla Ngarpuwu. Martalany parlipa Ngarpukura mapun jartamanujuwalwarntirlu nukarnirlu, jakuljulalany parlipanyanangu kanarlanywarntiwu wangki mapun Ngarpukura. ");
INSERT INTO wmt_vpl VALUES ("T13_16","084_3_16","1TI","3","16","16","Ngarpu pa wulyujinyangu mapunparni. Kalarakujirni parlipangurlanyanu Ngarpungu pinarriwurra. Kayan ngarliparla partalurni pinarrijarri Ngarpuwu yangka pa nyantu purrurturlal. Pirriyani parlipangu nguwangkurra Jesus, nganpayirni palu nyanya piyirnwarntirlu, Ngarpungu manyanangurla jakulkanya walaku nyantukura, Yinjilwarntirlu palu nyanya Jesus, Jularni palunyanangu wapalkarra piyirnwarntirlu Jesus, Mapunikanila palu Jesus ngurrawarlany ngurrawarlanyjangkarlu, Tikirrkujirni parlanyanu kankarral Ngarpungu. ");
INSERT INTO wmt_vpl VALUES ("T14_1","084_4_1","1TI","4","1","2","Jarlu parla Pirlurru Ngarpukurarlu marni nganpayiwu layiwu kurrumparla lanupurru nyapartukarra palu piyirnwarnti kanarlanywarnti ngangayanku. Kanarlanywarntirlu mapunikanujangkawarntirlu palunya pinakarriwu pirlawarnti yirrijiwarnti, mapunikarrkula palunya, wajilpungkula palunya pirlawarnti. Wangki nyanarti pirlawarntikura pa wapal. Wali pinakarriwu palu piyirnwarntirlu wangki wapal pirlawarntikura, yangkala palu yakurryakurr nira pinapinakarriwu. Kayan ngalu pirlurru nyaka wulyungal ngunangupurru. Nyanartijangka palunya piyirnwarntiwarlany pinarriyungku wangki wapal. Kujarti parlipa jalarra nyangany. Mapunparni palu kujarti yanany kanarlanywarnti. ");
INSERT INTO wmt_vpl VALUES ("T14_3","084_4_3","1TI","4","3","3","Yangkartiwarntirlu palunya lirrkarnpungany piyirnwarntirlu pirlakurawarntirlu. Jarrmalany palunyanangu kujarti. “Ngajirta ngantanya kartuwarnti warntarnanta. Kirrijirla manta ngunawu yarr, kartumulujaa ngumparnamulu manta yarr ngunawu.” Yarntarni palunyanangu jarrmalany, “Ngajirta ngantanya kuyiwarnti kanarlanywarnti nganyja. Wanyjarrku mantanya kanarlanywarnti. Yarnta miyiwarnti kanarlanywarnti mantanya ngarnanku, miyiwarntiwarlany kanarlanywarnti mantanya wanyjarrku.” Wali nyanarti wangki pa wapal. Pinarri parliparla Ngarpuwu. Mapunparni parlipangu ngartakpani kuyijaa miyi nukarni. Ngarpungu parlipanya yinya nyantungu kuyijaa miyi ngarnupurru. Ngajirta wanyjanupurru. Yangkala parlipanya nukarni ngarnanku Ngarpukurawarntirlu mapunjiwarntirlu jamalkangurla. ");
INSERT INTO wmt_vpl VALUES ("T14_4","084_4_4","1TI","4","4","4","Yangka parliparla Ngarpu jamalkangany miyipurru ngarnupurrujaa kuyipurru ngarnupurru, wali nukarnini parlipanya ngalku. Ngajirta ngarlipanya wanyjarra kanarlanywarnti. Ngarpungu parlipangu miyijaa kuyi ngartakpani. Nukarnini pa ngartakpani wulyu. ");
INSERT INTO wmt_vpl VALUES ("T14_5","084_4_5","1TI","4","5","5","Yangka parliparla Ngarpuwu malany miyipurru ngarnupurrujaa kuyipurru ngarnupurru, wali malany parlipangu Ngarpungu miyi ngarnupurru. Jamalkangany parlipanyanta Ngarpunga. Yangka Ngarpungu parlipangu malany ngarnupurru, wali nyanarti, kayan ngarlipa nganawurti wanyjarra. ");
INSERT INTO wmt_vpl VALUES ("J11_5","092_1_5","1JN","1","5","5","Munga parlipangurla ngarla. Tili parlipangu wulyu parralanujuwal. Wali Ngarpu parlipangu tili parralanujuwal wulyu. Ngajirta manyanta Ngarpunga munga nguna, nyantu pa kayan tili. ");
INSERT INTO wmt_vpl VALUES ("J11_6","092_1_6","1JN","1","6","6","Puju parlipa muntanga martalany yakurr yarnta parlipanyanangu kujartikarra malany, “Ngaju marna yanany Ngarpukurarlal,” nyanarti parlipa yirri malany. Yirrijiwarnti parlipa ngunangana. Ngajirta parlipa mapun. Kula Ngarpukurarlal parlipa yanany tilingal yangkartiwarnti, minyakujala parlipa mungangal yanany Ngarpungajirtajartirlal yakurral. ");
INSERT INTO wmt_vpl VALUES ("J11_7","092_1_7","1JN","1","7","7","Puju parliparla munta kayan nguniny Ngarpuwu, wali nyanarti, tilingal parlipa yanany Ngarpukurarlal. Ngurtpala parlipanyanangurla nguniny piyirnwarntirla. Walaku Ngarpukura Jesus parlipangu jilkarni nungu yakurrjangkawu wajapungupurru. Yangka parlipa ngapajawurlu lukurrpungany nganawurti, nyanartijilinyjawurlu parlipanya lukurrpungany Jesusju nungujawurlu, puju parliparla munta kayan nguniny Ngarpuwu. ");
INSERT INTO wmt_vpl VALUES ("J11_8","092_1_8","1JN","1","8","8","Yarntarni puju parlipanyanu julalany yakurrngajirtajarti, nyanarti pa yirri, kajiyungany parlipanyanu. Puju ngananguwurti manyanu julalany yakurrngajirtajarti, kajiyungany manyanu. ");
INSERT INTO wmt_vpl VALUES ("J11_9","092_1_9","1JN","1","9","9","Puju parliparlanyanu kurntayirlu yakurryakurrjawurlu takijulalany Ngarpuwu, wali nyanarti, wajapungku parlipangurla yakurryakurr Ngarpungu. Rukalanypala parlipangurla yakurra Ngarpungu. Ngarpu pa kayan, ngajirta kajiyungujuwal. Wulyu pa nyanarti Ngarpu. Yangka parlipanyanu takijulalany yakurrjawurlu, mapunparni parlipangurla wajapungany nukarnirla. ");
INSERT INTO wmt_vpl VALUES ("J11_10","092_1_10","1JN","1","10","10","Yarntarni puju parlipanyanu julalany, “Ngaju marna wulyu, ngajirta marna jarlu yakurryakurral yantarla,” wali kujawurlu parlipa Ngarpu yirrijikujilany. Yarnta parlipa ngajirta wangki Ngarpukura mapunikarra. ");
ALTER TABLE wmt_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
