﻿USE sofia;
DROP TABLE IF EXISTS sofia.wlo_vpl;
CREATE TABLE wlo_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES wlo_vpl WRITE;
INSERT INTO wlo_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","I bhaa-bhaana Aulataʼala apadhaangia laiana tee alamu. ");
INSERT INTO wlo_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Alamu indapo akomodele tee akoso. Kalalanda atutubhi uwena andala, tee Rohina Aulataʼala apekapola-polaka i bhawona uwe. ");
INSERT INTO wlo_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Afirimanimo Aulataʼala, \"Membalimo mainawa.\" Kasiimpo kainawa sumai amembalimo. ");
INSERT INTO wlo_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Aulataʼala akamata ande kainawa sumai amalape, kasiimpo kainawa sumai apapogaaia minaaka i kalalanda. ");
INSERT INTO wlo_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Tee Aulataʼala asarongiakea kainawa sumai \"o eo\" tee kalalanda sumai \"o malo.\" Amembalimo konowia tee amembalimo saeona, sumaimo o eo bhaa-bhaana. ");
INSERT INTO wlo_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Afirimanimo Aulataʼala, \"Membalimo potidhaa i tanga-tangana uwe, mamudhaakana apapogaaia o uwe minaaka i uwe mosagaanana. ");
INSERT INTO wlo_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Sabutuna, Aulataʼala apamembalia potidhaa sumai tee incia apapogaaia o uwe modhaangiana i tambena potidhaa sumai minaaka i uwe modhaangiana i bhawona tee amembalimo mboo sumai. ");
INSERT INTO wlo_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Kasiimpo Aulataʼala asarongiakea potidhaa sumai, \"laiana\". Amembalimo konowia tee amembalimo saeona, siitumo o eo rua eona. ");
INSERT INTO wlo_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Afirimanimo Aulataʼala, \"Membalimo bhari-bharia uwe modhaangiana i tambena laiana aporomusaka i saangu tampa, sanampuu atokamatamo tampa momatuuna.\" Tee amembalimo mboo sumai. ");
INSERT INTO wlo_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Kasiimpo Aulataʼala asarongiakea tampa momatuuna sumai \"o tana matuu\", tee romusakana uwe sumai asarongiakea \"o tawo\". Aulataʼala akamatea ande bhari-bharia sumai amalape. ");
INSERT INTO wlo_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Afirimanimo Aulataʼala, \"Amembalimo tana apatuwu manga rumpu mangura, manga penembula mokoompolena, tee sagala giu puuna manga bhake mokohasiliakana bhake mokobhatuna.\" Tee amembalimo mboo sumai. ");
INSERT INTO wlo_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Tana sumai apatuwu manga rumpu mangura, sagala giuna penembula mokoompolena tee sagala giu puuna kau mokohasiliakana bhake mokobhatuna. Aulataʼala akamatea ande bhari-bharia sumai amalape. ");
INSERT INTO wlo_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Amembalimo konowia tee amembalimo saeona, siitumo eo talu eona. ");
INSERT INTO wlo_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Afirimanimo Aulataʼala, \"Amembalimo manga kainawa i laiana to apapogaaia eo minaaka i malo. Amembalimo tanda ipatantuakana henggana, eo, tee tao, ");
INSERT INTO wlo_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","tee mboomo bhari-bharia sumai amembalimo kainawa i laiana to apekainawaaka alamu.\" Tee amembalimo mboo sumai. ");
INSERT INTO wlo_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Sumaimo Aulataʼala apamembalia rua angu kainawa maogena sumai, siitumo kainawa motolabhina kaogena to akuasai eo tee kainawa momaidhiidhina to akuasai malo, tee apamembali uka manga kalipopo. ");
INSERT INTO wlo_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Kasiimpomo, Aulataʼala adhikaia bhari-bharia kainawa sumai i laiana to apekainawaaka alamu, ");
INSERT INTO wlo_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","to akuasai eo tee malo, tee apapogaaia kainawa minaaka i kagalapu tee Aulataʼala akamatea ande bhari-bharia sumai amalape. ");
INSERT INTO wlo_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Amembalimo konowia tee amembalimo saeona, sumaimo eo pata eona. ");
INSERT INTO wlo_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Afirimanimo Aulataʼala, \"Amembalimo i nuncana uwe manga mahaluku modhadhina akaketu-ketu, tee amembalimo manga manu-manu apekapola-polaka i bhawona alamu apekatii-tii i laiana.\" ");
INSERT INTO wlo_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Sumaimo Aulataʼala apadhaangia manga mahaluku momaogena i tawo tee sagala giu mahaluku modhadhina tee mokomingkuna tee mokaketu-ketuna i uwe, mboo sumaimo uka sagala giu manu-manu mokopanina tee Aulataʼala akamatea ande bhari-bharia sumai amalape. ");
INSERT INTO wlo_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Kasiimpomo Aulataʼala abarakatia bhari-bharia sumai tee afirimani, \"Handamo apajulua pekabhari tee arangani kabharina, apoose apabukea uwe i tawo. Manu-manu uka ahandamo kabharina i alamu.\" ");
INSERT INTO wlo_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Amembalimo konowia tee amembalimo saeona siitumo eo lima eona. ");
INSERT INTO wlo_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Afirimanimo Aulataʼala, \"Amembalimo alamu apalimba sagala giu mahaluku modhadhina, kadhambaaka, binata mopondelena tee sagala giu binata momailana.\" Kasiimpomo amembalimo mboo sumai. ");
INSERT INTO wlo_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Aulataʼala apamembalia sagala giu binata momailana, sagala giu binata kadhambaaka, tee sagala giu binata mopondelena i tana, tee Aulataʼala akamatea ande bhari-bharia sumai amalape. ");
INSERT INTO wlo_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Afirimanimo Aulataʼala, \"Maimo, Ingkami bhetapamembalia maanusia mboomo sandarana karomami tee mboomo gambarana Karomami. Maanusia bheakokuasa to manga ikane i tawo tee manu-manu i laiana, to binata kadhambaaka, to bhari-bharia alamu, tee to bhari-bharia binata mopondelena i tana.\" ");
INSERT INTO wlo_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Sumaimo Aulataʼala apadhaangia maanusia sumai mboomo sandarana karona, mboomo sandarana Aulataʼala apadhaangia manga incia, Apadhaangia manga incia umane tee bhawine. ");
INSERT INTO wlo_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Aulataʼala abarakatimo manga incia tee afirimani i manga incia, \"Koana-anamo koopu-opuamo tee ahandamo kabharina. Pabukemea alamu tee mangantaloakea siitu. Kokuasamo to manga ikane i tawo tee manu-manu i laiana, tee bhari-bharia binata mopondelena i tana.\" ");
INSERT INTO wlo_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Afirimanimo Aulataʼala, \"Kamatea, Iaku kudhawuaka ingkomiu bhari-bharia penembula mokoompolena modhaangiana bhari-bharia i alamu tee bhari-bharia puu mokobhakena akobhatu. Siitumo bheamembali kinandemiu. ");
INSERT INTO wlo_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Sainamo to manga sagala binata momailana i alamu, tee sagala manu-manu i laiana, tee sagala binata mopondelena i tana, -- bhari-bharia mokoinyawana kudhawuakea sagala penembula maijo to kinandena.\" Tee amembalimo mboo sumai. ");
INSERT INTO wlo_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Kasiimpo, Aulataʼala akamatea sagala giu ipamembalina, ande bhari-bharia sumai amalape mpuu. Amembalimo konowia tee amembalimo saeona, siitumo eo nama eona. ");
INSERT INTO wlo_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Mboomo sumai apamondoa laiana tee alamu tee sagala antona. ");
INSERT INTO wlo_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","I eo pitu eona Aulataʼala padhamo apamondo karajaana ipewauna, tee aponiuntomo Incia i eo pitu eona minaaka i bhari-bharia karajaa ipewauna. ");
INSERT INTO wlo_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Kasiimpomo, Aulataʼala abarakatimo eo pitu eona sumai tee apekangkilomea, roonamo i eo incia sumaimo Aulataʼala aponiuntomo minaaka i sagala karajaana to apadhaangia dunia ipewauna. ");
INSERT INTO wlo_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Mboomo sumai tulatulana wakutuuna laiana tee alamu apadhaangiaia. Wakutuuna KAWASANA OPU Aulataʼala apadhaangia laiana tee alamu, ");
INSERT INTO wlo_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","bhari-bharia rumpu indapo dhaangia i dunia tee bhari-bharia penembula i tana uka indapo atuwu roonamo KAWASANA OPU Aulataʼala indapo apasapo wao i bhawona dunia tee indapo dhaangia mia to mokarajaana tana sumai. ");
INSERT INTO wlo_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Maka dhaangia o alo apene minaaka i alamu abhaho bhari-bharia bhawona tana. ");
INSERT INTO wlo_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Wakutuu incia sumai KAWASANA OPU Aulataʼala apadhaangia maanusia minaaka i ngawuna tana tee apoinunca tee ngalu modhadhiakana i nuncana angona. Sumaimo, maanusia sumai amembali mahaluku mokoinyawa. ");
INSERT INTO wlo_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Kasiimpo, KAWASANA OPU Aulataʼala, apewau saangu inawu i Eden, weta i timbu. Iwe sumaimo Incia apamboorea maanusia padha ipewauna sumai. ");
INSERT INTO wlo_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Kasiimpo, minaaka i tana, KAWASANA OPU Aulataʼala apatuwu manga giuna puuna kau momakesana kamataana tee momalapena motokandena bhakena, tee uka o puuna kau idhadhiaka i tanga-tangana inawu sumai, tee puuna kau imatauaka to momalapena tee momadhakina. ");
INSERT INTO wlo_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Minaaka i Eden asiwulu saangu umala to apakouweaka inawu sumai, kasiimpomo minaaka i tampa incia sumai umala apogaa amembali pata solo anana umala. ");
INSERT INTO wlo_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Sarona umala mobhaa-bhaana Pison. Umala incia sii asiwulu atipua saangua Tana Hawila, tampana bulawa adhaangia. ");
INSERT INTO wlo_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Bulawa minaaka i tana sumai amalape hasilina. Iwe sumai uka dhaangia garu mawondu tee tundu maali o sarona krisopras. ");
INSERT INTO wlo_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Sarona umala rua anguna sumai Gihon. Umala incia sii asiwulu atipua saangua Tana Kus. ");
INSERT INTO wlo_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Sarona umala talu anguna sumai Tigris. Umala incia sii asiwulu i sawetana timbu Asyur. Umala pata anguna sumai Efrat. ");
INSERT INTO wlo_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","KAWASANA OPU Aulataʼala, aalamo maanusia sumai tee apamboorea i nuncana Inawu Eden to mokarajaana tee modhambaakana inawu sumai. ");
INSERT INTO wlo_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Kasiimpomo KAWASANA OPU Aulataʼala adhawumo parinta i maanusia sumai, firimanina, \"Bhake minaaka bhari-bharia puu i nuncana inawu sii membali ukandea saincamu, ");
INSERT INTO wlo_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","maka bhake minaaka i puu imatauaka to momalapena tee momadhakina siitu bholi ukandea roonamo, i eona ingkoo ukandea, ingkoo dhaanamo umate.\" ");
INSERT INTO wlo_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Kasiimpomo KAWASANA OPU Aulataʼala afirimani, \"Inda malape, maanusia sumai soo samia-miana. Iaku gauku bhekupamembalia samia motulungina incia, mococona tee maanusia sumai.\" ");
INSERT INTO wlo_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Sumaimo KAWASANA OPU Aulataʼala apewau minaaka i tana sagala binata i koo tee sagala manu-manu i antara, aumbaakea bhari-bharia sumai i maanusia to akamata tuaapa maanusia sumai asarongiakea. Opea uka saro idhawuakana maanusia sumai i manga mahaluku modhadhi, siitumo momembalina sarona. ");
INSERT INTO wlo_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Kasiimpomo maanusia sumai asarongiakea sagala kadhambaakana, manu-manu i antara, tee sagala binata i koo. Maka to karona samia maanusia sumai inda apotibhaaka samia motulungia mopokanana tee karona. ");
INSERT INTO wlo_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Sumaimo KAWASANA OPU Aulataʼala apewau maanusia sumai atokole mpuu. Tangasaana incia akole, KAWASANA OPU Aulataʼala aalamo saangu bukuna kara-karana kasiimpomo atutubhia tampa incia sumai tee dagi. ");
INSERT INTO wlo_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Minaaka i bukuna kara-karana ialana minaaka i maanusia sumai, KAWASANA OPU Aulataʼala, apamodele samia bhawine, kasiimpo abhawea i maanusia sumai. ");
INSERT INTO wlo_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Apogaumo maanusia sumai, \"Sii incia, bukuna minaaka i bukuku, dagina minaaka i dagiku. Incia bheasarongiakea bhawine, sababuna incia aalea minaaka i umane.\" ");
INSERT INTO wlo_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Rampaakanamo sumai, samia umane bheabholi amana tee inana to adhadhi apobhawa-bhawa tee bhawinena, sabutuna rua-rua miaia amembali saangu. ");
INSERT INTO wlo_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Maanusia tee bhawinena sumai rua-rua miaia akalealea, maka manga incia inda anamisi kaea. ");
INSERT INTO wlo_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","O ulo satotuuna binata mokoʼakalana minaaka i sagala binata momaila ipamembalina KAWASANA OPU Aulataʼala. Saangu wakutuu aabhakimo o ulo i bhawine sumai, \"Atotuu Aulataʼala afirimani, 'Bholi ukandea bhake minaaka i puu opea uka i nuncana i inawu sii?' \" ");
INSERT INTO wlo_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Apogaumo bhawine sumai i ulo sumai, \"Bhake minaaka i manga puuna kau i nuncana inawu sii membali ingkami takandea, ");
INSERT INTO wlo_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","maka to bhake minaaka i puuna i tanga-tangana inawu sii, Aulataʼala afirimani, 'Bholi ingkomiu ukande bhake sumai tee bholi ingkomiu udhingkua, ara umate.'\" ");
INSERT INTO wlo_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Kasiimpo apogaumo o ulo sumai i bhawine sumai, \"Ingkomiu inda sampeampearo bheumate. ");
INSERT INTO wlo_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Roonamo, Aulataʼala amataua ande i eo ingkomiu ukandeakea matamiu bheatobungkale, tee ingkomiu bheumembali mboomo Aulataʼala, umataua to momalapena tee momadhakina.\" ");
INSERT INTO wlo_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Bhawine sumai akamata ande bhakena puu sumai amalape to atokande tee amakesa kamataana. Tee uka, puu sumai amakesa roonamo aumbaaka akala malape. Sumaimo, aalamea bhake sumai kasiimpo akandea. Sapadhana sumai adhawuakamea uka i umanena mopobhawana, tee umanena uka akandemea. ");
INSERT INTO wlo_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Sanampuu, atobungkalemo matana rua mbalia tee manga incia amataua ande akalealea. Kasiimpomo manga incia atapi-tapi manga tawana puuna ara to apamembalia katutubhina auratina. ");
INSERT INTO wlo_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Kasiimpo manga incia arango ande KAWASANA OPU Aulataʼala alingka i inawu i wakutuuna ngaluna konowia, maka maanusia tee bhawinena sumai abuniakamo karona minaaka i aroana KAWASANA OPU, i tanga-tangana manga puuna i nuncana inawu. ");
INSERT INTO wlo_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Maka KAWASANA OPU Aulataʼala agoraaka maanusia sumai tee aabhamo, \"Iapai ingkoo?\" ");
INSERT INTO wlo_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Lawanina, \"Wakutuuna iaku kurango suaramu i nuncana inawu sii, kumembali kumaeka roonamo kukalealea. Sababuna itu, kuopo.\" ");
INSERT INTO wlo_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Firimanina, \"Incema mopaumbako ande ukalealea? Mboona ukande bhake minaaka i puu mopadhana iparintangiakaku bholi ukandea?\" ");
INSERT INTO wlo_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Alawanimo maanusia sumai, \"Bhawine idhikamu i saripiku, inciamo modhawuakaaku bhakena minaaka i puuna kau, sumaimo kukandea.\" ");
INSERT INTO wlo_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Kasiimpomo KAWASANA OPU Aulataʼala aabhamo i bhawine sumai, \"Opea ipewaumu sii?\" Lawanimo bhawine sumai, \"O ulo sumai mogau-gauaku, sumaimo kukandemea bhake sumai.\" ");
INSERT INTO wlo_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Sabutuna, afirimanimo KAWASANA OPU Aulataʼala i ulo sumai, \"Roonamo ingkoo upewau mboo sumai, kutundako molabhina sagala kadhambaaka tee binata maila. Ingkoo bheupondele tee kompomu, tee ingkoo bheukande ngawuna tana saʼumurua dhadhimu. ");
INSERT INTO wlo_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Iaku bhekupadhaangia pomusuia i tanga-tangana ingkoo tee bhawine sii, i tanga-tangana siwulumu tee siwuluna. Siwuluna bheapahancurua bhaamu, tee ingkoo bheapekambelaia korontunguna.\" ");
INSERT INTO wlo_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Firimanina i bhawine sumai, \"Iaku bhekupekabharia kanarakaamu i wakutuuna ubhawa-bhawa, tee karasaimu ingkoo bheupalaahiriaka anaana. Moomini mboo sumai, ingkoo bheusadia gaumu to umanemu, tee incia bheakokuasa i bhawona ingkoo.\" ");
INSERT INTO wlo_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Kasiimpomo firimanina i Adamu, \"Roonamo uperangoia pogauna bhawinemu tee ukande bhake minaaka puu mopadhana iparintangiakaku i ingkoo, 'Bholi ukandea,' sumaimo atotundamo tana roonamo ingkoo. Tee umarasaiakea ingkoo bheukande hasilina, saʼumurua dhadhimu. ");
INSERT INTO wlo_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Tana bheatuwuaka rumpu mokorui tee kau mokorui to karomu, tee manga penembula i tana bheamembali kinandemu. ");
INSERT INTO wlo_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Tee umarasaiakea ingkoo bheupeelo kinandemu sampe ingkoo umbuli pendua umembali tana, roonamo minaaka iwe siitu ingkoo aalako. Sababuna ingkoo satotuuna o ngawu, tee bheupendua membali ngawu.\" ");
INSERT INTO wlo_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Maanusia sumai asarongiakea bhawinena Hawa sababuna inciamo inana minaaka bhari-bharia modhadhina. ");
INSERT INTO wlo_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","KAWASANA OPU Aulataʼala akarajaa pakea minaaka i kulina binata to maanusia tee bhawinena sumai, kasiimpomo apapakeakea i manga incia. ");
INSERT INTO wlo_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Kasiimpomo afirimanimo KAWASANA OPU Aulataʼala, \"Satotuuna maanusia sumai padhamo amembali mboomo sala saangu minaaka Ingkami, momatauna kalape tee kadhaki. Rampaakanamo sumai, bholi ara incia apaulu limana tee aalea uka bhakena puuna idhadhiaka sumai kasiimpomo akandemea, saanampuu incia dhadhi saʼumurua.\" ");
INSERT INTO wlo_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Sababuna sumai KAWASANA OPU Aulataʼala atumpua alimba minaaka i Inawuna Eden to akarajaa tana, tampa asalana incia aalea. ");
INSERT INTO wlo_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Incia awulu maanusia sumai alimba, kasiimpomo i wetana timbu i Inawuna Eden tee adhikaakea rua mia malaaʼekatina kerub tee samata hancu mokarore-rorena tee mopekapatiina i sagala rope to mojaganina dhala moporopena i puu idhadhiaka sumai. ");
INSERT INTO wlo_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Sapadhana incia sumai, Adamu aposaangu tee Hawa, bhawinena, kasiimpomo abhawa-bhawamo bhawine sumai, tee akoanaakamo Kabil. Hawa apogau, \"Iaku padhamo kupotibhaaka anana umane tee katulungina KAWASANA OPU.\" ");
INSERT INTO wlo_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Sapadhana incia sumai, incia akoanaakamo uka Habil, andina Kabil. Habil amembali samia mojaganina dumba tee bhembe, maka Kabil amembali pande poinawu. ");
INSERT INTO wlo_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Sapadhana pia-pia wakutuu, Kabil abhawa hasilina tana to apasombaaka i KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Habil uka abhawamo pia-pia mbaa anana tumpena minaaka i gulumana bhembe tee dumba tee apasombaaka weta momalapena. KAWASANA OPU asanaa i Habil tee opea ipasombaakana. ");
INSERT INTO wlo_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Maka Incia inda atarima Kabil tee opea ipasombaakana. Kasiimpomo ngangarandana Kabil aʼamara mpuu tee rouna akamburu-mburu. ");
INSERT INTO wlo_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Firimanimo KAWASANA OPU i Kabil, \"Pokia ingkoo uʼamara, tee pokia roumu akamburu-mburu? ");
INSERT INTO wlo_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Ande ingkoo upewau malape, tantumo bheutotarima. Maka ande ingkoo inda upewau malape, dosa aantagiko i matana bhamba. Incia gauna akuasaiko, maka ingkoo tabeana ukuasaia.\" ");
INSERT INTO wlo_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Maka, Kabil apogau i Habil o andina, \"Mai talingkaaka i inawu.\" Wakutuu manga incia dhaangia i inawu, sanampuu Kabil abhebhe Habil o andina, kasiimpomo apekamatea. ");
INSERT INTO wlo_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Sabutuna, afirimanimo KAWASANA OPU i Kabil, \"Iapaimo Habil, andimu?\" Lawanina, \"Iaku inda kumataua! Mboona iaku sii mojaganina andiku?\" ");
INSERT INTO wlo_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Firimanina, \"Opea padha ipewaumu? Raana andimu apekee i Iaku minaaka i tana! ");
INSERT INTO wlo_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Sabutuna sii-sii, kutundako tee kubhanakako maridho minaaka i tana motarimana raana andimu wakutuuna upekamatea. ");
INSERT INTO wlo_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Ande ukarajaa tana, tana sumai indamo bheadhawuko hasili. Ingkoo inda bheukombooresa tee bheumembali samia mopekalingka-lingkana i alamu.\" ");
INSERT INTO wlo_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Pogaumo Kabil i KAWASANA OPU, \"Kahukumuku sumai atolabhi katamona minaaka momembalina itanggoku. ");
INSERT INTO wlo_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Satotuuna, eo sii Ingkoo uwuluaku minaaka i tana sii, maridho minaaka i aroamu. Bhekumembali samia inda mokombooresana tee mopekalingka-lingkana i alamu. Incemapo uka mopokawana tee iaku dhaanamo bheapekamateaku.\" ");
INSERT INTO wlo_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Firimanina KAWASANA OPU i incia, \"Inda mboo sumai! Incema uka mopekamatena Kabil, bheabholosiakea to incia pitu kali lipa.\" Kasiimpomo KAWASANA OPU adhika saangu tanda i Kabil mamudhaakana incia inda apekamatea teemini manga incema mopokawana tee incia. ");
INSERT INTO wlo_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Sabutuna, alingkamo Kabil minaaka i aroana KAWASANA OPU, kasiimpo amboore i Tana Nod, i sawetana timbu Inawu Eden. ");
INSERT INTO wlo_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kabil aposaangu tee bhawinena, kasiimpo abhawa-bhawamo bhawine sumai, tee akoanaakamo Henokh. Kasiimpomo Kabil apabhangu saangu kota tee asarongiakea Henokh, mboomo sarona anana. ");
INSERT INTO wlo_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Henokh akoanaakamo Irad, Irad akoanaakamo Mehuyael, Mehuyael akoanaakamo Metusael, tee Metusael akoanaakamo Lamekh. ");
INSERT INTO wlo_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamekh apodhimbaakea rua mia bhawine, sarona Ada tee Zila. ");
INSERT INTO wlo_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada akoanaakamo Yabal. Incia sumai opuana manga mia momboorena i nuncana kema tee modhambaakana binata. ");
INSERT INTO wlo_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Sarona andina Yabal sumai Yubal. Incia sumai opu-opuana bhari-bharia mia momagasiaakana kecapi tee suli. ");
INSERT INTO wlo_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zila uka akoanaakamo anaana, sarona Tubal-Kain. Incia samia pande tutuki sagala parakakasi minaaka i tambaga tee ase. Andina Tubal-Kain sumai samia bhawine sarona Naama. ");
INSERT INTO wlo_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Apogaumo Lamekh i rua mia bhawinena, \"Ada tee Zila, rangopea ipogauakaku; E manga bhawinena Lamekh, tilikia ibhoasakaku. Iaku padhamo kupekamate samia umane roonamo incia apekambelaaku, samia anana mangura roonamo incia abhebheaku sampe amaranda. ");
INSERT INTO wlo_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Ande Kabil tabeana atobholosiaka pitu kali lipa, sumaimo Lamekh tabeana 77 kali lipa.\" ");
INSERT INTO wlo_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adamu aposaangumo uka tee bhawinena, kasiimpomo bhawine sumai akoanaakamo samia anaana umane tee asarongiakea Set, sababuna onina, \"Aulataʼala padhamo adhawuaka to iaku siwuluna to kabholosina Habil, sababuna Kabil padhamo apekamatea.\" ");
INSERT INTO wlo_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Kasiimpomo to Set uka apalaahirimo samia anaana umane tee incia asarongiakea Enos. I wakutuu incia sumai mia apepuumo adoʼa tee agoraaka sarona KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Siimo tulatulana siwuluna Adamu. I wakutuuna Aulataʼala apadhaangia maanusia, Incia apamembalia mboomo gambarana Aulataʼala. ");
INSERT INTO wlo_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Umane tee bhawine, apadhaangiaia manga. Incia abarakatia manga tee asarongiakea \"Maanusia\" i wakutuuna manga incia apadhaangiaia. ");
INSERT INTO wlo_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Sapadhana Adamu akoʼumuru 130 tao, alaahirimo to incia anana mboomo gambarana karona tee mboomo sandarana karona. Asarongiakea anana sumai Set. ");
INSERT INTO wlo_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Sapadhana Adamu akoanaaka Set, adhadhi 800 tao tee akoanaakamo uka manga anaana umane tee bhawine. ");
INSERT INTO wlo_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Adamu akawamo umuruna 930 tao, kasiimpomo amate. ");
INSERT INTO wlo_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Sapadhana Set akoʼumuru 150 tao, akoanaakamo Enos. ");
INSERT INTO wlo_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Sapadhana Set akoanaaka Enos, adhadhi 807 tao akoanaakamo uka manga anaana umane tee bhawine. ");
INSERT INTO wlo_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Set akawamo umuruna 912 tao, kasiimpomo amate. ");
INSERT INTO wlo_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Sapadhana Enos akoʼumuru 90 tao, alaahirimo Kenan to incia. ");
INSERT INTO wlo_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Sapadhana Enos akoanaaka Kenan, adhadhi 815 tao akoanaakamo uka anaana umane tee bhawine. ");
INSERT INTO wlo_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Enos akawamo umuruna 905 tao, kasiimpomo amate. ");
INSERT INTO wlo_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Sapadhana Kenan akoʼumuru 70 tao, alaahirimo Mahalaleel to incia. ");
INSERT INTO wlo_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Sapadhana Kenan akoanaaka Mahalaleel, adhadhi 840 tao akoanaakamo uka anaana umane tee bhawine. ");
INSERT INTO wlo_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kenan akawamo umuruna 910 tao, kasiimpomo amate. ");
INSERT INTO wlo_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Sapadhana Mahalaleel akoʼumuru 65 tao, alaahirimo Yared to incia. ");
INSERT INTO wlo_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Sapadhana Mahalaleel akoanaaka Yared, adhadhi 830 tao akoanaakamo uka anaana umane tee bhawine. ");
INSERT INTO wlo_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mahalaleel akawamo umuruna 895 tao, kasiimpomo amate. ");
INSERT INTO wlo_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Sapadhana Yared akoʼumuru 162 tao, alaahirimo Idris to incia. ");
INSERT INTO wlo_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Sapadhana Yared akoanaaka Idris, adhadhi 800 tao akoanaakamo uka anaana umane tee bhawine. ");
INSERT INTO wlo_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Yared akawamo umuruna 962 tao, kasiimpomo amate. ");
INSERT INTO wlo_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Sapadhana Idris akoʼumuru 65 tao, alaahirimo Metusalah to incia. ");
INSERT INTO wlo_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Sapadhana Idris akoanaaka Metusalah, incia adhadhi amalape pokaiana tee Aulataʼala kangengena 300 tao, tee akoanaakamo manga anaana umane tee bhawine. ");
INSERT INTO wlo_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Idris akawamo umuruna 365 tao. ");
INSERT INTO wlo_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Idris adhadhi amalape pokaiana tee Aulataʼala, kasiimpomo incia indamo dhaangia roonamo Aulataʼala aangkamea. ");
INSERT INTO wlo_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Sapadhana Metusalah akoʼumuru 187 tao, alaahirimo Lamekh to incia. ");
INSERT INTO wlo_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Sapadhana Metusalah akoanaaka Lamekh, adhadhi 782 tao akoanaakamo uka anaana umane tee bhawine. ");
INSERT INTO wlo_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Metusalah akawamo umuruna 969 tao, kasiimpomo amate. ");
INSERT INTO wlo_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Sapadhana Lamekh akoʼumuru 182 tao, alaahirimo to incia samia anana umane. ");
INSERT INTO wlo_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Incia asarongiakea Nuh, kooni, \"Anaana sii bheamangadhawu kalalesa i ingkita i nuncana karajaata tee kanguleana limata roonamo o tana padhamo itundana KAWASANA OPU.\" ");
INSERT INTO wlo_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Sapadhana Lamekh akoanaaka Nuh, adhadhi 595 tao akoanaakamo uka manga anaana umane tee bhawine. ");
INSERT INTO wlo_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lamekh akawamo umuruna 777 tao, kasiimpomo amate. ");
INSERT INTO wlo_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Sapadhana Nuh akoʼumuru 500 tao, alaahirimo Sem, Ham, tee Yafet to incia. ");
INSERT INTO wlo_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Wakutuuna maanusia apepuu aranganimo kabharina i bhawona alamu, to manga incia alaahirimo manga anaana bhawine, ");
INSERT INTO wlo_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","manga anana Aulataʼala akamatea ande manga anaana bhawine maanusia sumai amakesa mpuu. Kasiimpomo manga incia akawiakamea manga bhawine sumai, incemapo uka ipeeluna manga. ");
INSERT INTO wlo_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Kasiimpomo KAWASANA OPU afirimanimo, \"Rohiku inda bheapobhawa tee maanusia satorosuna, roonamo maanusia sumai afanaa kadhaangiana. Apepuu sii-sii, umuruna manga inda akolabhi 120 tao.\" ");
INSERT INTO wlo_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","I zamani incia sumai dhaangia mia wakinamboro, asarongiakea mia Nefilim i alamu, tee uka i zamanina sapadhana, sumai wakutuu manga mahalukuna Aulataʼala aporomu tee anana bhawine maanusia tee manga bhawine sumai akoanaakamo anana to manga incia. O siimo manga mia momasegana tee pande poewangi i zamani momangengena, manga mia motomatauna sarona. ");
INSERT INTO wlo_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","KAWASANA OPU akamatamea ande kadhakina maanusia amaoge i alamu, tee ande sagala haejatina tee ngangarandana tangkanamo kadhaki sadia. ");
INSERT INTO wlo_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Sumaimo, asosomo incana KAWASANA OPU roonamo Incia padhamo apamembali maanusia i alamu, tee hali incia sumai amandhawuaka incana. ");
INSERT INTO wlo_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Afirimanimo KAWASANA OPU, \"Iaku bhekuhapusuakea maanusia padha ipadhaangiaku sumai minaaka i bhawona alamu -- maanusia, kadhadhi, binata mopondele, tee manu-manu i antara -- sababuna incaku asoso ande Iaku padhamo kupamembalia manga incia.\" ");
INSERT INTO wlo_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Maka o Nuh apotibhaaka rahumati i matana KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Siimo tulatulana Nuh, samia mobanarana tee inda tee kabanciana i tanga-tangana manga mia i zamanina. Nuh adhadhi i nuncana pokaia momalape tee Aulataʼala. ");
INSERT INTO wlo_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nuh akoanaakamo talu mia umane: Sem, Ham, tee Yafet. ");
INSERT INTO wlo_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Tangasaana sumai, alamu amadhakimo i aroana Aulataʼala tee abukeaka tee kakaana inca. ");
INSERT INTO wlo_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Aulataʼala atilikia alamu tee akamata tapanamo kadhakina, roonamo bhari-bharia maanusia dhadhina soomo kadhaki. ");
INSERT INTO wlo_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Sabutuna, afirimanimo Aulataʼala i Nuh, \"Iaku padhamo kubhotukiakea to kupaʼaahiria dhadhina sagala mahaluku, sababuna alamu sii abukeaka kakaana inca roonamo manga incia. Satotuuna, Iaku bhekupabinasea manga incia apobhawa-bhawa tee alamu. ");
INSERT INTO wlo_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Karajaamo to karomu bhangka maoge minaaka i kau gofir. Karajaamo bhangka sumai upeta-petaia tee lempesia tee mina tere, malape minaaka i nunca atawa i sambali. ");
INSERT INTO wlo_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Mboomo sii tabeana ukarajaaia bhangka sumai: 133 metere kaaratena, 22 metere kaewana, tee 13 metere kalangana. ");
INSERT INTO wlo_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Karajaakea bhalona cahea i bhangka sumai tee upamondoa bhangka sumai sakawana satanga metere i labhangana bhawo tee rindina. Pasaakea bhambana i tanga-tanga i sambalina bhangka maoge sumai. Karajaaia bhangka maoge sumai akotingka-tingka: tambe, tanga, tee bhawo. ");
INSERT INTO wlo_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Mataua, Iaku bhekuumbaaka uwena mawa i bhawona alamu to apabinasaaka sagala mahaluku mokoinyawana i kapeona laiana. Bhari-bharia modhaangiana i alamu bheamate. ");
INSERT INTO wlo_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Maka, tee ingkoo Iaku bhekupatotapua pojanjiaku. Ingkoo tee manga anamu, bhawinemu, tee bhawinena manga anamu bheapesua i nuncana bhangka maoge sumai. ");
INSERT INTO wlo_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Minaaka i sagala mahaluku modhadhina, tabeana ubhawea i nuncana bhangka sapasa, umane tee bhawine, mamudhaakana manga incia sadhaadhaa adhadhi apobhawa-bhawa tee ingkoo. ");
INSERT INTO wlo_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Sapasa minaaka i sagala giu manu-manu, sagala giu kadhadhi, tee sagala giu binata mopondelena i alamu bheaumba i ingkoo mamudhaakana manga incia sadhaadhaa adhadhi. ");
INSERT INTO wlo_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ingkoo uka tabeana uromusakea sagala giu kinande tee udhikaia. Siitumo momembalina kinande to ingkomiu tee manga binata.\" ");
INSERT INTO wlo_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nuh akarajaaia bhari-bharia sumai iparintangiakana Aulataʼala i incia, mboomo sumai akarajaaia. ");
INSERT INTO wlo_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Sapadhana bhari-bharia apasiapuakea, KAWASANA OPU afirimanimo i Nuh, \"Kompamo ingkoo tee saangua antona bhanuamu i nuncana bhangka maoge, roonamo ingkoomo ikamataku atotuu i aroaku i tanga-tangana manga mia i zamani incia sii. ");
INSERT INTO wlo_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Minaaka i bhari-bharia binata mohalala aalamo pitu pasa, umane tee bhawine, sainamo minaaka i binata moharamu sapasa, o umane tee bhawine. ");
INSERT INTO wlo_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Alamo uka minaaka i manu-manu i antara pitu pasa, umane tee bhawine, mamudhaakana siwuluna manga sadhaadhaana adhadhi i bhari-bharia bhawona alamu. ");
INSERT INTO wlo_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Roonamo pitu eopo uka Iaku bhekupasapo wao i bhawona alamu 40 eo 40 malo kangengena tee sagala mahaluku padha ipamembaliku sumai bhekuhapusuakea minaaka i bhawona alamu. ");
INSERT INTO wlo_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Kasiimpomo Nuh akarajaamo sagala iparintangiakana KAWASANA OPU i karona. ");
INSERT INTO wlo_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Nuh akoʼumurumo nama atu tao wakutuuna uwena mawa aumba atipua alamu, ");
INSERT INTO wlo_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","tee to apasalaamatiaka karona minaaka i uwena mawa, Nuh apobhawa tee manga anana umane, bhawinena, tee manga ana maniana bhawine akompamo i nuncana bhangka maoge sumai. ");
INSERT INTO wlo_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Minaaka i manga binata mohalalana tee moharamu, manu-manu, tee sagala mopondelena i alamu, ");
INSERT INTO wlo_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","sapasa-sapasa, umane tee bhawine, aumbamo i Nuh i nuncana bhangka maoge, mboomo iparintangiakana Aulataʼala i Nuh. ");
INSERT INTO wlo_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Sapadhana pitu eo, aumbamo uwena mawa atipua alamu. ");
INSERT INTO wlo_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Wakutuuna Nuh akoʼumuru 600 tao, i bula rua mbulana, eo sapulu pitu eona, apidhimo bhari-bharia matana uwe i nuncana tana, tee manga bhambana uwe i laiana uka atobungkale. ");
INSERT INTO wlo_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Wao maranca asapo i bhawona alamu 40 eo 40 malo kangengena. ");
INSERT INTO wlo_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","I eo incia sumai uka Nuh, tee Sem, Ham, tee Yafet, sumaimo manga anana Nuh, bhawinena tee talu mia ana maniana bhawine apesua i nuncana bhangka maoge sumai. ");
INSERT INTO wlo_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Manga incia aose-osea sagala giu binata maila, sagala giu kadhambaaka, sagala giu binata mopondelena i alamu, tee sagala giu manu-manu, siitumo haewani mokopanina. ");
INSERT INTO wlo_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Bhari-bharia aumba i Nuh i nuncana bhangka maoge sumai, sapasa-sapasa minaaka i sagala mahaluku modhadhi tee mokoinyawana. ");
INSERT INTO wlo_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Bhari-bharia moumbana tee mopesuana siitumo o umane tee bhawine minaaka i sagala mahaluku, mboomo iparintangiakana Aulataʼala i Nuh. Kasiimpomo KAWASANA OPU atutubhia bhambana sumai i talikuna Nuh. ");
INSERT INTO wlo_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","40 eo kangengena uwena mawa sumai atipua alamu. O uwe sumai torotorosu apene arangani kabharina saanampuu aangkamo bhangka maoge sumai alanto amalanga minaaka i bhawona alamu. ");
INSERT INTO wlo_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Wakutuuna o uwe ahanda kalangana tee kabharina i bhawona alamu, bhangka maoge sumai akalanto-lanto i bhawona uwe. ");
INSERT INTO wlo_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Tee uwe ahanda amakaa mpuu arangani atipua i bhawona alamu, sabutuna bhari-bharia gunu malanga modhaangiana i saangua kapeona laiana atotutubhi. ");
INSERT INTO wlo_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Uwe sumai torotorosu ahanda o kalangana sakawana atutubhi manga gunu momalanga. Uwena mawa ahanda kalangana pitu metere i bhawona lolona manga gunu sumai. ");
INSERT INTO wlo_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Kasiimpomo abinasamo bhari-bharia mahaluku mokomingkuna i alamu, manu-manu, kadhambaaka, binata maila, tee sagala binata mopondelena, sagala binata maidhiidhina mokaketu-ketuna i alamu, tee bhari-bharia maanusia. ");
INSERT INTO wlo_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Bhari-bharia modhaangiana i tana, tee bhari-bharia mopoinuncana tee ngalu i nuncana angona, amate. ");
INSERT INTO wlo_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Mboo sumaimo Aulataʼala ahapusu sagala mahaluku modhadhi, modhaangiana i bhawona alamu, amalape o maanusia, kadhadhi, tee binata mopondelena tee manu-manu i antara, bhari-bharia ahapusua minaaka i bhawona alamu. Tangkanamo Nuh modhadhina tee bhari-bharia mopobhawana tee incia i nuncana bhangka maoge sumai. ");
INSERT INTO wlo_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","O uwena mawa sumai apatondu alamu 150 eo kangengena. ");
INSERT INTO wlo_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Kasiimpomo Aulataʼala audhanimo Nuh tee sagala binata maila tee sagala kadhambaaka, modhaangiana mopobhawana tee incia i nuncana bhangka maoge sumai. Kasiimpomo Aulataʼala atowiiakea tee ngalu alaloi saangua alamu, sabutuna o uwe sumai apepuumo asapo. ");
INSERT INTO wlo_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Manga matana uwe i nuncana tana tee manga bhambana uwe i laiana atotutubhi, tee wao mosapona minaaka i laiana uka auntomo. ");
INSERT INTO wlo_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","O uwe ahandamo asapo minaaka i bhawona alamu, tee sapadhana 150 eo o uwe sumai uka akuramo. ");
INSERT INTO wlo_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","I nuncana bula pitu mbulana, i eo sapulu pitu eona, atosoremo bhangka maoge sumai i saangu lolona gunu i Tana Ararat. ");
INSERT INTO wlo_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Tangasaana sumai, sampe bula sapulu mbulana o uwe akuramo. I eo bhaa-bhaana i bula sapulu mbulana sumai atokamatamo manga lolona gunu. ");
INSERT INTO wlo_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Sapadhana 40 eo, Nuh abungkalemo manga bhalo-bhalona bhangka maoge ikarajaana. ");
INSERT INTO wlo_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Kasiimpomo apalapa sambaa manu-manu tongkaa. Manu-manu sumai apolakamo alipa mai, sampe o uwe sumai membalimo amatuu minaaka i bhawona alamu. ");
INSERT INTO wlo_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Kasiimpomo apalapa uka sambaa manu-manu jarajara to akamataaka ande o uwe asapomo minaaka i bhawona alamu. ");
INSERT INTO wlo_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Maka, manu-manu jarajara sumai inda apotibhaaka tampa to apasampa aena, roonamo o uwe dhaangiapo atipua saangua bhawona alamu. Manu-manu sumai ambulimo apokawaaka Nuh i bhangka maoge. Nuh uka apaulu limana, aala manu-manu sumai, tee abhawea apesua i nuncana bhangka. ");
INSERT INTO wlo_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Incia aantagi pitu eopo uka, kasiimpomo apalapea uka manu-manu jarajara sumai minaaka i bhangka. ");
INSERT INTO wlo_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Wakutuuna amakasumo konowia, ambulimo manu-manu jarajara sumai apokawaaka Nuh, tee i muncuna dhaangia satake tawana zaitun siimpo mototobhena. Sumaimo, Nuh amataumea ande uwe asapomo minaaka i alamu. ");
INSERT INTO wlo_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Incia aantagia pitu eopo uka, kasiimpomo apalapea pendua manu-manu jarajara sumai, tee sawulingana sii manu-manu sumai indamo ambuli pendua i incia. ");
INSERT INTO wlo_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Wakutuu Nuh akoʼumurua 601 taona, i eo bhaa-bhaana, i bula bhaa-bhaana, o uwe asapomo minaaka i bhawona alamu. Wakutuuna Nuh abungkale padhana bhangka sumai tee akamatamea, atiumbamo o tana i bhawona alamu apepuumo amatuu. ");
INSERT INTO wlo_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Kasiimpomo i eo 27 eona, i bula rua mbulana, alamu atotuu-totuumo amatuu. ");
INSERT INTO wlo_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Afirimanimo Aulataʼala i Nuh, ");
INSERT INTO wlo_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","\"Limbamo minaaka i bhangka maoge siitu, ingkoo tee bhawinemu, manga anamu, tee ana maniamu. ");
INSERT INTO wlo_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Bhawea palimbaia sagala mahaluku mokoinyawana mopobhawana tee ingkoo siitumo manu-manu, haewani tee sagala binata mopondelena i alamu. Taroakamo manga incia apabuke alamu, akoana-anamo, tee ahandamo kabharina i bhawona alamu.\" ");
INSERT INTO wlo_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Saanampuu alimbamo Nuh tee manga anana, bhawinena, tee manga ana maniana. ");
INSERT INTO wlo_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Sagala binata maila, sagala binata mopondelena, sagala manu-manu, siitumo bhari-bharia mokomingkuna i alamu, alimbamo uka minaaka i bhangka maoge sumai sumbesumbere mboomo giuna. ");
INSERT INTO wlo_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Kasiimpomo Nuh abhangumo saangu tampa tunuana kurubani to KAWASANA OPU. Aalea sambaa minaaka i sumbesumbere giuna binata tee manu-manu mohalala, kasiimpomo apasombaakamea kurubani tunuana i bhawona tampana tunuana kurubani sumai. ");
INSERT INTO wlo_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Wakutuuna KAWASANA OPU abhoumo bhouna ipasombaaka momawonduna sumai, afirimanimo KAWASANA OPU i nuncana ngangarandana, \"Iaku indamo pendua bhekutunda alamu sii roonamo maanusia, moomini haejatina ngangarandana maanusia sumai amadhaki minaaka i kakidhisana. Iaku indamo bhekupabinasea sagala modhadhina, mboomo mopadhana kupewaua. ");
INSERT INTO wlo_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Kangengena alamu adhaangia, inda bheaunto-unto henggana pombulaa tee tobhea, kagari tee kasodho, henggana paneeo tee henggana wao, eo tee malo.\" ");
INSERT INTO wlo_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Kasiimpomo Aulataʼala abarakati Nuh tee manga anana tee afirimani i manga incia, \"Koana-anamo koopu-opuamo tee ahandamo kabharina tee pabukemea alamu. ");
INSERT INTO wlo_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Namisi kaeka tee rengku i ingkomiu bheakangkanai sagala binata i alamu, sagala manu-manu i antara, sagala mopondelena i tana, tee sagala ikane i tawo. Bhari-bharia sumai kupasaraakaakea i nuncana limamu. ");
INSERT INTO wlo_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Sagala mokomingkuna, siitumo modhadhina, bheamembali kinandemiu. Bhari-bharia sumai kudhawuaka to ingkomiu, pokana giuna mboomo manga penembula maijo. ");
INSERT INTO wlo_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Maka bholi ukande o dagi mokoraa, roonamo inyawana sumai dhaangia i nuncana raa. ");
INSERT INTO wlo_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Iaku tantumo bhekutuntu kabholosi to raamu, siitumo inyawamu. Iaku bhekutuntu kabholosi minaaka i bhari-bharia binata, tee uka maanusia. Iaku bhekutuntu kabholosi to inyawana maanusia minaaka i limana samaanusiana. ");
INSERT INTO wlo_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Incema mobusakana raana maanusia, raana bheabusakaakea uka maanusia, roonamo Aulataʼala padhamo apamembali maanusia mboomo sandarana karona. ");
INSERT INTO wlo_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Maka ingkomiu, koana-anamo koopu-opuamo tee ahandamo kabharina. Pabukemea alamu tee ahandamo kabharina i bhawona alamu sii.\" ");
INSERT INTO wlo_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Kasiimpomo Aulataʼala afirimanimo pendua i Nuh tee i manga anana mopobhawana tee incia, ");
INSERT INTO wlo_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","\"Satotuuna, Iaku kupatotapuaka pojanjiaku tee ingkomiu tee siwulumiu naile itu, ");
INSERT INTO wlo_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","tee sagala mahaluku mokoinyawa mopobhawana tee ingkomiu, manu-manu, kadhambaaka tee sagala binata maila modhaangiana mopobhawana tee ingkomiu, bhari-bharia molimbana minaaka i bhangka maoge, siitumo sagala binata i alamu. ");
INSERT INTO wlo_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Iaku kupatotapuaka pojanjiaku tee ingkomiu: Indamo bheapendua uka sagala mahaluku apabinasea o uwena mawa, tee indamo bheapendua uka dhaangia uwena mawa to apabinasa alamu.\" ");
INSERT INTO wlo_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Aulataʼala uka afirimani, \"Siimo tandana pojanjiaku ipadhaangiaku i tanga-tangana Iaku tee ingkomiu tee sagala mahaluku modhadhina mopobhawana tee ingkomiu, saangu pojanjia to bhari-bharia siwulumiu torotorosu saʼumurua: ");
INSERT INTO wlo_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Ntorouweku kudhikaia i taʼina ngalu, tee siitumo bheamembali tandana pojanjiana i tanga-tangana Iaku tee alamu. ");
INSERT INTO wlo_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Ande Iaku kuumbaaka taʼina ngalu i bhawona alamu tee ntorouwe sumai atokamata i manga taʼina ngalu, ");
INSERT INTO wlo_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Iaku bhekuudhani pojanjiaku modhaangiana i tanga-tangana Iaku tee ingkomiu tee sagala mahaluku modhadhina, sagala mokoinyawana. Indamo bheapendua uwe amembali uwena mawa to apabinasa sagala mahaluku. ");
INSERT INTO wlo_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Ande ntorouwe sumai dhaangia i taʼina ngalu, siitumo Iaku bhekukamatea tee kuudhani pojanjiaku saʼumurua i tanga-tangana Aulataʼala tee sagala mokoinyawana, siitumo sagala mahaluku modhaangiana i alamu.\" ");
INSERT INTO wlo_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Kasiimpomo Aulataʼala afirimanimo i Nuh, \"Siimo tandana pojanjiaku mopadhana ipatotapuakaku i tanga-tangana Iaku tee sagala mahaluku modhaangiana i alamu.\" ");
INSERT INTO wlo_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Manga anana Nuh molimbana minaaka i bhangka maoge sarona Sem, Ham, tee Yafet. Ham satotuuna o amana Kanaan. ");
INSERT INTO wlo_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Talu miana sii siitumo manga anana Nuh, tee minaaka i manga incia sii amantalemo raʼeatina bhari-bharia alamu. ");
INSERT INTO wlo_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nuh amembali pande poinawu tee inciamo mobhaa-bhaana mokarajaana inawuna angguru. ");
INSERT INTO wlo_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Saangu wakutuu sapadhana Incia asumpu angguru, amalangomo incia tee apotidhole akalealea i nuncana kemana. ");
INSERT INTO wlo_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ham, o amana Kanaan, akamata auratina amana, kasiimpomo apetulatulaakea i rua mia witinaina i sambali. ");
INSERT INTO wlo_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Kasiimpomo Sem tee Yafet aalamo satuwu kae kasiimpo apasampea i awaana manga rua miaia. Sapadhana incia sumai, manga incia asowo i talikuna tee atutubhi auratina amana manga. Rouna manga abhalilia saweta mamudhaakana inda akamata auratina amana manga. ");
INSERT INTO wlo_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Wakutuu Nuh aepemo minaaka i kalangona angguru tee amataua opea mopadhana ipewauna anana kaepuna i incia, ");
INSERT INTO wlo_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","apogaumo incia, \"Kutundakomo Kanaan! Bholiakamo incia amembali bhatua minaaka i tanga-tangana manga bhatua to manga witinaina.\" ");
INSERT INTO wlo_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Pogauna uka, \"Sagala puji to KAWASANA OPU, Aulataʼalana Sem! Bholiakamo Kanaan amembali bhatuana. ");
INSERT INTO wlo_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Sio-siomo Aulataʼala apekalalesaia mbooresana Yafet! Bholiakamo incia amboore i nuncana manga kemana Sem tee bholiakamo Kanaan amembali bhatuana.\" ");
INSERT INTO wlo_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Nuh dhaangiapo adhadhi 350 tao sapadhana uwena mawa sumai. ");
INSERT INTO wlo_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Sumaimo, Nuh akawa umuruna 950 tao, kasiimpomo incia amate. ");
INSERT INTO wlo_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Siimo siwuluna manga anana Nuh, sumai Sem, Ham tee Yafet. Sapadhana uwena mawa sumai, alaahirimo manga anana umane to manga incia. ");
INSERT INTO wlo_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Manga anana Yafet sumai: Gomer, Majuj, Madai, Yawan, Tubal, Mesekh, tee Tiras. ");
INSERT INTO wlo_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Manga anana Gomer sumai: Askenas, Rifat, tee Togarma. ");
INSERT INTO wlo_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Manga anana Yawan sumai: Elisa, Tarsis, Kitim tee Dodanim. ");
INSERT INTO wlo_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","(Minaaka i manga incia siimo apogaa-gaamo manga lipu momboorena i sakaaratea bhiwina tawo. Manga incia adhadhi i tanana karona manga, sumbesumbere tee pogauna manga, kaomu witinaina manga, tee lipuna manga.) ");
INSERT INTO wlo_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Manga anana Ham sumai: Kus, Misraim, Put, tee Kanaan. ");
INSERT INTO wlo_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Manga anana Kus sumai: Seba, Hawila, Sabta, Raema, tee Sabtekha. Manga anana Raema sumai: Syeba tee Dedan. ");
INSERT INTO wlo_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kus dhaangia anana uka sarona Nimrod, momembalina mia mokokuasana bhaa-bhaana i alamu. ");
INSERT INTO wlo_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","O incia samia pande pekaose mobaranina rampaakanamo KAWASANA OPU. Siitumo sababuna, ipogauakana mia, \"Mboomo Nimrod, samia pande pekaose mobaranina rampaakanamo KAWASANA OPU.\" ");
INSERT INTO wlo_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Auwalina pamarintana Nimrod aminaaka i Babel, Erekh, tee Akad, bhari-bharia i Tana Sinear. ");
INSERT INTO wlo_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Minaaka i tana sumai, incia alingka i Asyur, kasiimpo apabhangu kota Niniwe, Rehobot-Ir, Kalah, ");
INSERT INTO wlo_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","tee Resen, i tanga-tangana Niniwe tee Kalah. Bhari-bharia sumai kota maoge. ");
INSERT INTO wlo_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misraim akoanaakamo miana Ludim, miana Anamim, miana Lehabim, miana Naftuhim, ");
INSERT INTO wlo_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","miana Patrusim, miana Kasluhim (minaaka i iwe siimo asalana miana Filistin), tee miana Kaftorim. ");
INSERT INTO wlo_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaan akoanaakamo anana o sarona Sidon, anana tumpena, tee Het. ");
INSERT INTO wlo_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Siwuluna Kanaan mosagaanana sumai miana Yebusi, miana Amori, miana Girgasi, ");
INSERT INTO wlo_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","miana Hewi, miana Arki, miana Sini, ");
INSERT INTO wlo_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","miana Arwadi, miana Semari, tee miana Hamati. Kasiimpomo apogaa-gaamo manga kaomuna miana Kanaan sumai. ");
INSERT INTO wlo_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Potidhaana lipuna miana Kanaan amaewa minaaka i Sidon, aporope i Gerar sakawana i Gaza, kasiimpo aporope i Sodom, Gomora, Adma, tee Zeboim, sakawana i Lasa. ");
INSERT INTO wlo_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Siitumo siwuluna Ham mboomo sumbesumbere kaomuna, pogauna, tanana, tee lipuna. ");
INSERT INTO wlo_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Alaahirimo uka manga anana to Sem, siitumo akana Yafet, o opu-opuana bhari-bharia siwuluna Eber. ");
INSERT INTO wlo_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Manga anana Sem sumai: Elam, Asyur, Arpakhsad, Lud, tee Aram. ");
INSERT INTO wlo_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Manga anana Aram sumai: Us, Hul, Geter, tee Mas. ");
INSERT INTO wlo_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arpakhsad akoanaaka Selah, tee Selah akoanaaka Eber. ");
INSERT INTO wlo_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eber akoanaaka rua mia umane. Sarona samia sumai Peleg, roonamo i zamanina manga kaomu i alamu sii apogaa-gaamo, tee sarona andina sumai Yoktan. ");
INSERT INTO wlo_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yoktan akoanaaka Almodad, Selef, Hazar-Mawet, Yerah, ");
INSERT INTO wlo_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Uzal, Dikla, ");
INSERT INTO wlo_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Syeba, ");
INSERT INTO wlo_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Hawila, tee Yoab. Bhari-bharia siwuluna Yoktan. ");
INSERT INTO wlo_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Tampa mbooresana manga incia amaewa minaaka i Mesa aporope i Sefar, siitumo gunu i sawetana timbu. ");
INSERT INTO wlo_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Siitumo siwuluna Sem mboomo kaomuna, pogauna, tanana, tee lipuna. ");
INSERT INTO wlo_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Jadi, sumaimo kaomuna manga anana Nuh mboomo siwuluna manga incia tee lipuna manga. Minaaka i manga incia sii apogaa-gaamo manga lipu i alamu sapadhana uwena mawa sumai. ");
INSERT INTO wlo_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Wakutuu incia itu, bhari-bharia alamu saangu pogauna tee saangu manga oni. ");
INSERT INTO wlo_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","I wakutuuna manga miana apadhaangia lingkaana i wetana timbu, manga incia apotibhaaka saangu tana rata i Tana Sinear kasiimpomo amboore iwe sumai. ");
INSERT INTO wlo_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Pogauna manga incia samia tee mosagaanana, \"Mai takarajaa bhatu bata tee tatunua sampe amakaa.\" Bhatu bata sumai manga incia apakea mboomo kabholosina bhatu, sainamo mina tere mboomo kabholosina tana reo. ");
INSERT INTO wlo_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Pogauna manga incia uka, \"Mai tabhangu saangu kota tee saangu manara o lolona akawea laiana. Mai tapeelo saro to karota, mamudhaakana ingkita inda tapogaa-gaa i saangua alamu. ");
INSERT INTO wlo_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Kasiimpo aumbamo KAWASANA OPU to akamata kota tee manara ibhanguna maanusia sumai. ");
INSERT INTO wlo_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","KAWASANA OPU afirimanimo, \"Satotuuna, manga incia sii saangu lipu tee saangu pogauna to bhari-bharia. Sii-sii siimpo apepuungia usahana manga. Inda mangengemo uka, manga incia bheakapoia akarajaa opeapo uka peeluana manga. ");
INSERT INTO wlo_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Maimo Ingkita tasapo tee tapakacaua pogauna manga mamudhaakana manga inda amaʼanaia pogauna samia tee sagaanana.\" ");
INSERT INTO wlo_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Mboomo sumai KAWASANA OPU apapogaa-gaaia manga minaaka iwe sumai i saangua bhawona alamu, tee manga incia aunto apabhangu kota sumai. ");
INSERT INTO wlo_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Sumaimo sababuna lipu incia sumai asarongiakea Babel, roonamo iwe sumai KAWASANA OPU apakacaua pogau saangua alamu tee minaaka iwe sumaimo KAWASANA OPU apapogaa-gaaia manga i saangua bhawona alamu. ");
INSERT INTO wlo_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Siimo siwuluna Sem. Wakutuuna Sem akoʼumuru 100 tao, alaahirimo to incia Arpakhsad, rua tao sapadhana uwena mawa. ");
INSERT INTO wlo_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Sem akoʼumuru 500 tao uka sapadhana incia akoanaaka Arpakhsad, tee incia dhaangiapo akoanaaka uka manga anana umane tee bhawine. ");
INSERT INTO wlo_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Sapadhana Arpakhsad akoʼumuru 35 tao, alaahirimo to incia Selah. ");
INSERT INTO wlo_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Arpakhsad akoʼumuru 403 uka sapadhana incia akoanaaka Selah tee incia dhaangiapo akoanaaka uka manga anana umane tee bhawine. ");
INSERT INTO wlo_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sapadhana Selah akoʼumuru 30 tao, alaahirimo to incia Eber. ");
INSERT INTO wlo_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Selah adhadhi 403 tao uka sapadhana incia akoanaaka Eber, tee incia dhaangiapo uka akoanaaka manga anana umane tee bhawine. ");
INSERT INTO wlo_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Sapadhana Eber akoʼumuru 34 tao, alaahirimo to incia Peleg. ");
INSERT INTO wlo_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Eber adhadhi 430 tao uka sapadhana incia akoanaaka Peleg, tee incia dhaangiapo uka akoanaaka manga anana umane tee bhawine. ");
INSERT INTO wlo_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Sapadhana Peleg akoʼumuru 30 tao, alaahirimo to incia Rehu. ");
INSERT INTO wlo_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Peleg adhadhi 209 tao uka sapadhana incia akoanaaka Rehu tee incia dhaangia akoanaaka uka manga anana umane tee bhawine. ");
INSERT INTO wlo_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Sapadhana Rehu akoʼumuru 32 tao, alaahirimo to incia Serug. ");
INSERT INTO wlo_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Rehu adhadhi 207 tao sapadhana incia akoanaaka Serug, tee incia dhaangia akoanaaka uka manga anana umane tee bhawine. ");
INSERT INTO wlo_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Sapadhana Serug akoʼumuru 30 tao, alaahirimo to incia Nahor. ");
INSERT INTO wlo_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Serug adhadhi 200 tao uka sapadhana incia akoanaaka Nahor, tee incia dhaangiapo akoanaaka uka manga anana umane tee bhawine. ");
INSERT INTO wlo_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Sapadhana Nahor akoʼumuru 29 tao, alaahirimo to incia Terah. ");
INSERT INTO wlo_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Nahor adhadhi 119 tao uka sapadhana incia akoanaaka Terah, tee incia dhaangia akoanaaka uka manga anana umane tee bhawine. ");
INSERT INTO wlo_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Sapadhana Terah akoʼumuru 70 tao, alaahirimo to incia talu ana mia umane, siitumo Abram, Nahor tee Haran. ");
INSERT INTO wlo_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Siimo siwuluna Terah. Terah akoanaaka manga anana sumai: Abram, Nahor tee Haran. Kasiimpomo Haran akoanaaka anana, Lut. ");
INSERT INTO wlo_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haran amate aporikana minaaka i Terah, amana, i tana laahiriana, i Ur i Babilonia. ");
INSERT INTO wlo_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Kasiimpomo Abram tee Nahor alosaaka bhawinena. Abram akawi tee Sarai, tee Nahor akawi tee Milka, anana bhawine Haran. Haran sumai amana Milka tee Yiska. ");
INSERT INTO wlo_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarai sumai akomba, inda akoana. ");
INSERT INTO wlo_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Terah alimba minaaka i kota Ur i Babilonia apobhawa-bhawa tee Abram o anana, Lut bin Haran o opuana, tee Sarai o maniana, sumai bhawinena Abram. Manga incia ahaejati alingka i Tana Kanaan, maka wakutuu akawa i Haran, manga incia uka amboore iwe sumai. ");
INSERT INTO wlo_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Terah akawa umuruna 205 tao, kasiimpo amatemo i kota Haran. ");
INSERT INTO wlo_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","KAWASANA OPU afirimani i Abram, \"Lingkamo minaaka i lipumu, minaaka i manga witinaimu, tee minaaka i bhanuana amamu, i lipu bhekususuakako. ");
INSERT INTO wlo_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Iaku bhekupamembaliko saangu lipu momaogena. Iaku bhekubarakatiko tee kupewau saromu amaoge. Ingkoo bheumembali barakati! ");
INSERT INTO wlo_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Iaku bhekubarakatia manga mia moemanina barakati to ingkoo, tee Iaku bhekutunda manga mia motundako. Rampaakanamo ingkoo, bhari-bharia lipu i alamu bheapotibhaaka barakati.\" ");
INSERT INTO wlo_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Sumaimo, Abram alingka, mboomo ifirimaniakana KAWASANA OPU i incia. Lut aose alingka tee incia. Abram akoʼumuru 75 tao i wakutuuna incia alimba minaaka i Haran. ");
INSERT INTO wlo_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abhawea Sarai, bhawinena, tee Lut, pinoanana, tee sagala manga harataana tee manga mia ipotibhaakana i Haran alingka arope i Lipuna Kanaan. Kasiimpo akawamo manga i Tana Kanaan sumai. ");
INSERT INTO wlo_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abram alingka alaloi lipu incia sumai sampe akawa i saangu tampana ibaadati i Sikhem, i puu maoge More. I wakutuu incia sumai miana Kanaan amboore i lipu incia sumai. ");
INSERT INTO wlo_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Kasiimpomo KAWASANA OPU apatiumbamo karona i Abram tee afirimani, \"I siwulumu Iaku bhekudhawuaka lipu sii.\" Saanampuu Abram apabhangumo iwe sumai saangu tampa tunuana kurubani to KAWASANA OPU, mopadhana mopatiumbana karona i incia. ");
INSERT INTO wlo_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Minaaka i iwe sumai incia adhencu i tana gunu i weta timbu kota Bait-El, kasiimpomo apakaromo kemana i tanga-tangana kota Bait-El i weta i bhara tee kota Ai i weta i timbu. Incia apabhangu iwe sumai saangu tampa tunuana kurubani to KAWASANA OPU tee agoraakamo sarona KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Sapadhana incia sumai Abram apalausakamo lingkaana tee abhose arope i Tana Negeb. ");
INSERT INTO wlo_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Kasiimpomo amembalimo kasukara kaara i lipu incia sumai. Abram uka alingka i Mesir to amboore iwe sumai mboomo dhaga, roonamo amakaa mpuu kasukarana kaara i Tana Kanaan. ");
INSERT INTO wlo_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Wakutuuna incia amakasumo apesua i Mesir, incia apogaumo i Sarai, bhawinena, \"Rangoa, kumataua ande ingkoo samia bhawine momakesana rouna. ");
INSERT INTO wlo_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Ancosala ande manga miana Mesir akamatako kasiimpo bheapogau, 'Siitumo bhawinena,' kasiimpomo manga incia bheapekamate iaku tee ataroaka ingkoo udhadhi. ");
INSERT INTO wlo_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Sababuna sumai, pogaumo mboo sii, ande ingkoo andiku, mamudhaakana manga incia apewauaku malape rampaakanamo ingkoo, tee inyawaku asalaamati roonamo ingkoo.\" ");
INSERT INTO wlo_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","I wakutuuna Abram apesuamo i Mesir, manga miana Mesir akamata ande Sarai amakesa mpuu. ");
INSERT INTO wlo_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Manga kapala pagawena maligena Firaun uka akamata Sarai tee apuji-pujimea i aroana Firaun, rampaakanamo itu incia aalea abhawea i maligena Firaun. ");
INSERT INTO wlo_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Sumaimo Firaun apewaumo amalape i Abram rampaakanamo bhawine sumai tee adhawuakea gulumana bhembe, dumba, sapi, keledai umane tee bhawine, unta, tee manga bhatua umane tee bhawine. ");
INSERT INTO wlo_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Maka KAWASANA OPU apasapo hisabu i Firaun tee manga mia i maligena tee katunda momakaana mpuu roonamo Sarai, bhawinena Abram sumai. ");
INSERT INTO wlo_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Kasiimpomo Firaun akembamo Abram tee apogau, \"Ingkoo ugau-gauaku! Pokia inda upaumbaaku ande incia bhawinemu? ");
INSERT INTO wlo_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Pokia ingkoo upogau, 'Incia witinaiku,' sabutuna iaku kualamea to kupamembalia bhawineku? Sii-sii, alea bhawinemu sii tee lingkamo!\" ");
INSERT INTO wlo_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Kasiimpomo Firaun adhawumo parinta i manga miana to apalimba Abram, Sarai bhawinena, tee sagala giu pewauana. ");
INSERT INTO wlo_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Saanampuu alingkamo Abram minaaka i Mesir arope i Tana Negeb apobhawa tee bhawinena tee sagala giu pewauana. Lut uka apobhawa tee incia. ");
INSERT INTO wlo_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram arangkaea mpuu: kadhambaaka, pera, tee bulawana abhari mpuu. ");
INSERT INTO wlo_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Incia apalausakamo lingkaana minaaka i saangu tampa akawa i tampa mosagaanana; minaaka i Tana Negeb aporope i Bait-El, kasiimpo akawa i tanga-tangana Bait-El tee Ai, i tampa i piamo itu incia apakaro kemana ");
INSERT INTO wlo_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","tee i tampa i piamo itu incia apakaro tampa tunuana kurubani. Iwe siitu Abram agoraakamo sarona KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lut, molingkana apobhawa tee Abram, uka dhaangia tee gulumana bhembena, dumba, sapi, tee pia-pia angu kema. ");
INSERT INTO wlo_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Rampaakanamo itu, indamo akawa rumpu i lipu incia sumai to manga incia ambooresia apobhawa-bhawa. Harataana manga abhari, sabutuna manga incia inda amembali amboore apobhawa-bhawa. ");
INSERT INTO wlo_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Kasiimpomo amembalimo posalamaʼana i tanga-tangana manga gembala kadhambaakana Abram tee manga gembala kadhambaakana Lut. (I wakutuu incia sumai manga miana Kanaan tee miana Feris dhaangiapo amboore i lipu incia sumai.) ");
INSERT INTO wlo_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Apogau Abram i Lut, \"Kuemani mpuu bholi amembali posalamaʼana i tanga-tangana iaku tee ingkoo, tee i tanga-tangana gembalaku tee gembalamu, roonamo ingkita sii tapowitinai. ");
INSERT INTO wlo_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Bhari-bharia tana ikamatamu sii amembali upilia to mbooresamu. Maimo ingkita tapogaa. Ande upili umboore i weta kaai, sumaimo bhekulingka i weta kaana. Ande upili i weta kaana, sumaimo bhekulingka i weta kaai.\" ");
INSERT INTO wlo_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lut uka apatinda potontona. Incia akamata ande saangua Mbolonga Yordan sakawana i Zoar akouwe tee amalape, mboomo inawuna KAWASANA OPU, mboomo Tana Mesir. (Siitumo kadhaangiana wakutuuna indapo KAWASANA OPU apabinasa Sodom tee Gomora.) ");
INSERT INTO wlo_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Sababuna itu Lut apili to karona saangua Mbolonga Yordan, kasiimpomo Lut abhose i weta timbu. Mboomo sumai manga incia apogaa samia tee mosagaanana. ");
INSERT INTO wlo_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram amboore i Tana Kanaan, tee Lut amboore i tanga-tangana manga kota i mbolonga sumai. Incia apapinda kemana sampe amakasu i kota Sodom. ");
INSERT INTO wlo_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Teemo uka miana Sodom amadhaki tee akodosa mpuu i aroana KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Sapadhana Lut apogaa tee Abram, afirimanimo KAWASANA OPU i Abram, \"Patindaia potontomu minaaka i tampa kakaroamu itu, tee uilingia i weta napa, salata, timbu, tee bhara, ");
INSERT INTO wlo_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","roonamo bhari-bharia lipu ikamatamu itu bhekudhawuakako tee siwulumu sampe saʼumurua. ");
INSERT INTO wlo_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Iaku bhekupamembalia siwulumu mboomo ngawuna tana kabharina. Apokana tee samia inda amembali agagari ngawuna tana, mboo sumai uka siwulumu inda bheamembali atogagari. ");
INSERT INTO wlo_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Makanumo, lingkaisia lipu sumai apokana kaaratena tee kaewana, roonamo i ingkoomo Iaku bhekudhawuakea.\" ");
INSERT INTO wlo_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Abram uka apadhencua kemana kasiimpo amboore i saripina manga puu maoge i Mamre, inda amaridho minaaka i Hebron. Iwe sumai incia apabhangu saangu tampa tunuana kurubani to KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","I zamani incia sumai, Amrafel rajana Sinear, Ariokh rajana Elasar, Kedorlaomer rajana Elam, tee Tideal rajana Goyim ");
INSERT INTO wlo_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","apadhaangia potimbea abhali Bera rajana Sodom, Birsya rajana Gomora, Syinab rajana Adma, Syeber rajana Zeboim, tee rajana Bela (isarongiaka uka Zoar). ");
INSERT INTO wlo_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Bhari-bharia raja isarongiaka moʼaahirina sii aposaangu tee aromusaka suludaduna manga i Mbolonga Sidim siitumo Tawo Mate. ");
INSERT INTO wlo_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","12 tao kangengena lima mia raja sumai ataʼati i Raja Kedorlaomer, maka i tao 13 taona manga aewangimo raja sumai. ");
INSERT INTO wlo_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","I 14 taona, alingkamo Raja Kedorlaomer apobhawa tee manga raja mopoosena tee incia to apotimbe. Kasiimpo manga incia amangantaloaka manga miana Refaim i Asterot Karnayim, manga miana Zuzim i Ham, manga miana Emim i Syawe-Kiryataim, ");
INSERT INTO wlo_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","tee manga miana Hori i tana gunu manga incia isarongiaka Seir, akawa i El-Paran, i bhiwina tana matuu. ");
INSERT INTO wlo_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Kasiimpo manga ambuli aumbati En-Mispat (isarongiaka uka Kades), tee amangantaloaka saangua lipuna miana Amalek tee uka miana Amori momboorena i Hazezon-Tamar. ");
INSERT INTO wlo_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Kasiimpo alimbamo rajana Sodom, rajana Gomora, rajana Adma, rajana Zeboim, tee rajana Bela (isarongiaka uka Zoar). Manga incia aʼatoro manga suludaduna to apobhali tee manga musuna i Mbolonga Sidim. ");
INSERT INTO wlo_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Iwe sumai manga incia aewangi Kedorlaomer rajana Elam, Tideal rajana Goyim, Amrafel rajana Sinear, tee Ariokh rajana Elasar. Pata mia raja aewangi lima mia raja. ");
INSERT INTO wlo_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Mbolonga Sidim sumai tampa mobukeakana tee sumuna mina tere. Wakutuuna manga rajana Sodom tee Gomora apalaiaka karona, sagaa minaaka i manga incia asindoli iwe sumai, sainamo sagaa modhadhina apalaiaka karona i tana gunu. ");
INSERT INTO wlo_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Manga raja moosena Raja Kedorlaomer arampasi sagala harataa pewauana Sodom tee Gomora tee sagala giuna kinande, kasiimpo alingka. ");
INSERT INTO wlo_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Manga incia uka abhawa Lut, pinoanana Abram, tee harataana pewauana, roonamo incia amboore i Sodom. ");
INSERT INTO wlo_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Kasiimpo sala samia itaangina pata mia raja sumai amembali apalaiaka karona aumba apoaro tee Abram, miana Ibrani sumai, tee apaumbaakea hali incia sumai i incia. I wakutuu incia sumai, Abram amboore i saripina manga puu maoge pewauana Mamre, miana Amori, witinaina Eskol tee Aner, manga sabhangkana aposaangu tee Abram. ");
INSERT INTO wlo_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Wakutuu Abram arango ande pinoanana atotaangi, aromusakamea manga mia iparacaeana, siitumo manga incia molaahirina i bhanuana, 318 mia kabharina, kasiimpo apajeremo musuna akawea i Dan. ");
INSERT INTO wlo_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Abram abage manga bhatuana amembali pia-pia pasukana to abhali musuna i wakutuu malo. Manga incia amangantaloaka musuna tee apajerea akawea i Hoba, i sawetana napa kota Damsyik. ");
INSERT INTO wlo_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Sagala harataa pewauana abhawea apambulia, tee uka Lut, pinoanana, tee harataa pewauana, tee manga bhawine tee manga mia sagaanana. ");
INSERT INTO wlo_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Sapadhana Abram ambuli minaaka i amangantaloaka Raja Kedorlaomer tee manga raja mopobhawana tee incia, sumaimo raja Sodom alimba alingka apakawaakea i Mbolonga Syawe (isarongiaka uka Mbolonga Raja). ");
INSERT INTO wlo_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Kasiimpomo aumbamo uka Malkisedik, rajana Salem, abhawa roti tee angguru. Incia satotuuna o imamuna Aulataʼala Momalanga. ");
INSERT INTO wlo_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Incia aemaniaka barakati to Abram, pogauna, \"Abarakatikomo Abram minaaka i Aulataʼala Momalanga, mopadhaangiana laiana tee alamu. ");
INSERT INTO wlo_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Sagala puji to Aulataʼala Momalanga, mopadhana mopasaraakana manga musumu i nuncana limamu.\" Kasiimpomo Abram adhawuakamo i incia sapersapulu minaaka i sagala harataa pewauana sumai. ");
INSERT INTO wlo_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Apogaumo raja Sodom i Abram, \"Alea to karomu bhari-bharia harataa pewauana sumai, maka dhawuakaaku manga mia lipuku sumai.\" ");
INSERT INTO wlo_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Maka apogau Abram i raja Sodom, \"Iaku padhamo kusumpa i KAWASANA OPU, Aulataʼala Momalangana, Mopadhaangiana laiana tee alamu, ");
INSERT INTO wlo_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","ande iaku inda bhekuala opea-opea minaaka i ingkoo, satake kambari atawa talina sandalimu, mamudhaakana somba ara upogau, 'Iaku sii padhamo kupewau Abram arangkaea.' ");
INSERT INTO wlo_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Iaku inda bhekuala manga opea uka tabeana opea mopadhana ikandena atawa ipakena manga mia mangura mopobhawana tee iaku. Sainamo to manga sabhangkaku Aner, Eskol, tee Mamre, taroakamea manga aala dhawuna sumbesumbere.\" ");
INSERT INTO wlo_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Sapadhana sagala giu kajadia incia sumai, aumbamo Firimanina KAWASANA OPU i Abram i nuncana saangu pokamata, \"Bholi maeka, Abram! Iakumo peulusamu. Fahalamu bheamaoge mpuu.\" ");
INSERT INTO wlo_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Alawanimo Abram, \"E Rajaku KAWASANA OPU, opea o faʼedana ande Ingkoo udhawuaku fahala? Sampe sii-sii iaku indapo tee anaku, tee bhemoalana tinaurakana bhanuaku soomo Eliezer, miana Damsyik sumai.\" ");
INSERT INTO wlo_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Pogaumo Abram uka, \"Satotuuna, Kawasana Opu indapo udhawuaku siwulu, sabutuna bhatua molaahirina i bhanuaku bhemoalana tinaurakaku.\" ");
INSERT INTO wlo_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Maka aumbamo firimanina KAWASANA OPU i incia mboo sii, \"Mencuana mia incia siitu bhemoalana tinaurakamu, tabeana anamu karomu bhemoalana tinaurakamu.\" ");
INSERT INTO wlo_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Kasiimpomo Incia abhawea Abram alimba tee afirimani, \"Potingaramo i laiana tee gagaria manga kalipopo ande ingkoo membali ugagaria.\" Firimanina i incia, \"Mboomo sumai kabharina siwulumu naile itu.\" ");
INSERT INTO wlo_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Kasiimpomo aparacaeamo Abram i KAWASANA OPU, tee hali incia sumai agagariakamea to incia to kabanara. ");
INSERT INTO wlo_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Incia afirimani uka i Abram, \"Iakumo KAWASANA OPU, mobhawana ingkoo ulimba minaaka i Ur di Babilonia to modhawuakana lipu sii i ingkoo to amembali pewauamu.\" ");
INSERT INTO wlo_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Pogaumo Abram, \"\"E Rajaku KAWASANA OPU, tuaapa kumataua ande lipu sii bheamembali pewauaku?\" ");
INSERT INTO wlo_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Firimanina KAWASANA OPU i incia, \"Alamo to Iaku sambaa sapi bhawine akoʼumuru talu tao, sambaa bhembe bhawine akoʼumuru talu tao, sambaa dumba umane akoʼumuru talu tao, sambaa anana manu-manu bhokuru, tee sambaa anana manu-manu jarajara.\" ");
INSERT INTO wlo_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Kasiimpo Abram alingka aalamo bhari-bharia sumai to KAWASANA OPU, awetaia manga kadhambaaka membali rua weta, kasiimpomo adhikaia weta saanguna apoaro tee mosagaanana. Maka manu-manu inda awetaia rua weta. ");
INSERT INTO wlo_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Wakutuu manu-manu bunia asampa i bhawona dagi isumbele sumai, Abram uka asioa. ");
INSERT INTO wlo_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Wakutuuna matanaeo apepuumo asoo, Abram atokole mpuu. Saanampuu kagalapu motomaeka mpuu akumutia. ");
INSERT INTO wlo_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Kasiimpo KAWASANA OPU afirimani i Abram, \"Mataua tee tandaia, ande siwulumu bheamembali dhaga i lipu mencuana lipuna manga. Manga incia bheapabhatuaia tee apanarakaaia 400 tao kangengena. ");
INSERT INTO wlo_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Maka sumaimo, lipu mopabhatuana manga incia bhekuhukumua, tee sapadhana sumai manga incia bhealimba abhawa harataana mobharina. ");
INSERT INTO wlo_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Sainamo dhadhimu bheamembali mboo sii: ingkoo bheumate tee umasanaamo tee bheutokoburu umancuanamo mpuu. ");
INSERT INTO wlo_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Siwulumu bheamboore i lipu sumai sakawana i pata tapina, dhaampomo opua itoputuna bheambuli iwe sii, roonamo dosana miana Amori indapo akawa katamona sabutuna indapo afaraluu kuhukumua.\" ");
INSERT INTO wlo_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Sapadhana matanaeo asoomo tee eo amembalimo agalapu, saanampuu atiumbamo saangu dhalika mokowaa mokoombuna tee oboro mokarore-rorena alalo i tanga-tangana manga kadhodhona dagi sumai. ");
INSERT INTO wlo_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","I eo incia sumai uka KAWASANA OPU apojanjimo tee Abram, firimanina, \"I siwulumu kudhawuakea lipu incia sii, pepuu minaaka i Umala Mesir akawea i umala maoge, sumaimo Umala Efrat, ");
INSERT INTO wlo_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","siitumo tanana miana Keni, miana Kenas, miana Kadmon, ");
INSERT INTO wlo_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","miana Het, miana Feris, miana Refaim, ");
INSERT INTO wlo_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","miana Amori, miana Kanaan, miana Girgasi, tee miana Yebus.\" ");
INSERT INTO wlo_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Sarai, bhawinena Abram, inda uka apalaahiri siwuluna to Abram. Maka incia dhaangia samia bhatua bhawine, miana Mesir, o sarona Hajar. ");
INSERT INTO wlo_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Apogaumo Sarai i Abram, \"Kamatea, KAWASANA OPU padhamo atutubhi kadhumaku to kupalaahiri anaana. Kawimo tee bhatuaku, incema mataua kumembali kupotibhaaka anaana minaaka i incia.\" Abram aperangoia pogauna Sarai. ");
INSERT INTO wlo_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Kasiimpo Sarai, bhawinena Abram, abhawa Hajar, bhatuana, miana Mesir sumai, tee adhawuakamea i Abram, umanena, to apamembalia bhawinena. I wakutuu incia sumai, Abram padhamo amboore i Tana Kanaan sapulu tao kangengena. ");
INSERT INTO wlo_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abram uka aporomu tee Hajar, kasiimpo abhawa-bhawamo bhawine sumai. Wakutuu Hajar amataua ande incia abhawa-bhawa, incia apandaʼente Sarai, opuna. ");
INSERT INTO wlo_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Kasiimpo Sarai apogaumo i Abram, \"Kahina ipotibhaakaku sii satotuuna rampaakanamo ingkoo! Iaku inciamo modhawuko bhatuaku i sangoamu, maka siimpomo mpuu amataua ande incia abhawa-bhawa, incia apandaʼenteakumo. Maasangia KAWASANA OPU amembali Haakimu i tanga-tangaku tee ingkoo, incema mosalana.\" ");
INSERT INTO wlo_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Pogaumo Abram i Sarai, \"Satotuuna, bhatuamu sumai dhaangia i nuncana kuasamu. Pewaumea incia mboomo opea ikamatamu amalape.\" Saanampuu, Sarai apisakimo Hajar; sabutuna apalaiakamea. ");
INSERT INTO wlo_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Kasiimpomo, malaaʼekatina KAWASANA OPU apokawaakea inda maridho minaaka i saangu matana uwe i tana matuu, i saripina dhala moporopena i Syur. ");
INSERT INTO wlo_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Apogaumo, \"E Hajar, bhatuana Sarai, minaaka iapai ingkoo tee bheulingka iapai?\" Alawanimo bhawine sumai, \"Iaku kupalaiaka karoku minaaka i Sarai, opuku.\" ");
INSERT INTO wlo_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Apogaumo malaaʼekatina KAWASANA OPU i incia, \"Mbulimo i opumu tee tungkumo i tambena kuasana.\" ");
INSERT INTO wlo_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Apogaumo uka malaaʼekatina KAWASANA OPU i incia, \"Iaku bhekupewau siwulumu abhari mpuu, sampe indamo atogagari kabharina.\" ");
INSERT INTO wlo_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Sapadhana sumai, malaaʼekatina KAWASANA OPU apogaumo i incia, \"Ingkoo tangasaana ubhawa-bhawa tee ingkoo bheupalaahiri samia anaana umane. Sarongiakea Ismail, roonamo KAWASANA OPU padhamo arangoa pekeena kanarakaamu. ");
INSERT INTO wlo_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Incia bheamembali mia o dhadhina mboomo keledai maila. Limana bheabhali incema-incemapo uka, tee o limana samia-samia bheabhali incia. Incia bheamboore apogera-gera tee bhari-bharia manga witinaina.\" ");
INSERT INTO wlo_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Kasiimpomo Hajar aabha i nuncana ngangarandana, \"Atotuu iaku padhamo kukamata KAWASANA OPU momaheruakaaku?\" Sabutuna sumai, incia asarongiakea KAWASANA OPU mopadhana apogau tee incia mboo sii kooni, \"Ingkoomo Aulataʼala Momaheruakaaku.\" ");
INSERT INTO wlo_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Siitumo sababuna sumu incia sumai asarongiakea Lahai-Roi, o tampana i tanga-tangana Kades tee Bered. ");
INSERT INTO wlo_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Kasiimpo Hajar apalaahiri samia anaana umane to Abram, tee Abram asarongiakea anaana ipalaahirina Hajar sumai Ismail. ");
INSERT INTO wlo_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abram akoʼumurumo 86 tao wakutuuna Hajar apalaahiri Ismail to incia. ");
INSERT INTO wlo_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Wakutuuna Abram akoʼumurumo 99 tao, KAWASANA OPU apatiumbaakamo karona i incia tee afirimani i incia, \"Iakumo Aulataʼala Mokokuasana, dhadhimo i aroaku inda tee momadhakina. ");
INSERT INTO wlo_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Iaku bhekupadhaangia pojanjia tee ingkoo, tee Iaku bhekupewau siwulumu abhari mpuu.\" ");
INSERT INTO wlo_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Saanampuu asujumo Abram. Kasiimpomo Aulataʼala afirimani i incia, ");
INSERT INTO wlo_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","\"Minaaka i Iaku, siimo pojanjiaku tee ingkoo: Ingkoo bheumembali ama to manga lipu bhari. ");
INSERT INTO wlo_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Saromu mencuanamo Abram, tabeana Ibrahim, roonamo Iaku padhamo kupamembaliko ama to bhari lipu. ");
INSERT INTO wlo_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Iaku bhekupamembaliko ukoana-ana koopu-opua abhari mpuu. Minaaka i ingkoo bhekupamembalia manga lipu, tee manga raja bheaumba minaaka i siwulumu. ");
INSERT INTO wlo_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Iaku bhekupasahamea pojanjiaku i tanga-tangata, Iaku tee ingkoo tee siwulumu naile itu, torotorosu amembali saangu pojanjia molagina saʼumurua, siitu ande Iaku bhekumembali Aulataʼalamu tee Aulataʼala siwulumu. ");
INSERT INTO wlo_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","I karomu tee manga siwulumu naile itu bhekudhawuakea lipu sii tampana umboore mboomo dhaga, sumaimo bhari-bharia Tana Kanaan, membali saangu pewauamu saʼumurua. Iaku uka bhekumembali Aulataʼalana manga incia.\" ");
INSERT INTO wlo_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Firimanina Aulataʼala uka i Ibrahim, \"Minaaka i ingkoo, tabeana ukeniakea malape pojanjiaku, malape ingkoo atawa siwulumu naile itu saʼumurua. ");
INSERT INTO wlo_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","O siimo pojanjiaku to ikeniakamu matangka, pojanjia i tanga-tangata, Iaku tee ingkoo tee manga siwulumu naile itu: Bhari-bharia umane i tanga-tangamiu tabeana atotandaki. ");
INSERT INTO wlo_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Ingkomiu tabeana utotandaki, tee incia itu bheamembali tanda pojanjiaku i tanga-tangata, Iaku tee ingkomiu. ");
INSERT INTO wlo_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Satorosuna, bhari-bharia anaana umane mokoʼumuruna walu eo i tanga-tangamiu tabeana utandakia. Adati incia sii atopewau mencuana soo to bhari-bharia umane siwulumiu karomiu, maka uka to manga umane ipalaahirina minaaka i bhatua i bhanuamiu tee uka manga bhatua ialimiu minaaka i mia dhaga tee moomini mencuana siwulumiu. ");
INSERT INTO wlo_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Anaana umane molaahirina i bhanuamiu atawa ialimiu tee doi tabeana utandakia. Mboo siimo pojanjiaku i nuncana karomu bheatandaia pojanjia sii alagi saʼumurua. ");
INSERT INTO wlo_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","O umane inda mototandakina, siitumo inda atodhodho kulina tabeana apabinasea minaaka i tanga-tanga lipuna. Incia amalinguakamea pojanjiaku.\" ");
INSERT INTO wlo_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Kasiimpomo Aulataʼala afirimani i Ibrahim, \"To Sarai, bhawinemu, bholimo usarongiakea pendua tee sarona Sarai, tabeana Sarah, siitumo sarona mobhaauna. ");
INSERT INTO wlo_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Iaku bhekubarakatia, tee alaloi incia uka Iaku bhekudhawuakako samia anaana umane. Iaku bhekubarakatia, tee incia bheamembali inana manga lipu. Manga rajana lipu bheaumba minaaka i siwuluna.\" ");
INSERT INTO wlo_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Kasiimpo asujumo Ibrahim tee apotawa tee apogau i nuncana ngangarandana, \"Buaka amembali samia umane mokoʼumuruna 100 tao akoanaakamo samia anaana? Amembali buaka Sarah, mokoʼumuruna 90 tao, apalaahiri anaana?\" ");
INSERT INTO wlo_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Kasiimpo apogaumo Ibrahim i Aulataʼala, \"A, sio-siomo Ismail alaenga adhadhi i aroamu!\" ");
INSERT INTO wlo_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Firimanina Aulataʼala, \"Satotuuna Sarah, bhawinemu, bheapalaahirimo samia anaana umane to karomu. Usarongiakea incia Ishak. Iaku bhekupasahamea pojanjiaku tee incia amembali saangu pojanjia saʼumurua to siwuluna. ");
INSERT INTO wlo_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Sainamo to Ismail, Iaku padhamo kurangoa iemanimu. Satotuuna, Iaku bhekubarakatia tee kupamembalia akoana-ana koopu-opua tee kupamembalia siwuluna abhari mpuu. Incia bheamembali opuana minaaka i sapulu rua mia raja, tee Iaku bhekupamembalia saangu lipu momaoge. ");
INSERT INTO wlo_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Maka pojanjiaku bhekupatotapuakea tee Ishak, ipalaahirina Sarah to ingkoo i wakutuu mboo sii i tao moumbana.\" ");
INSERT INTO wlo_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Sapadhana afirimani i Ibrahim, Aulataʼala uka abholimea. ");
INSERT INTO wlo_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Kasiimpomo Ibrahim akembamo Ismail, anana, tee bhari-bharia mia molaahirina i bhanuana, tee uka bhari-bharia mia ialina tee doi -- bhari-bharia umane i tanga-tangana antona bhanuana. I eo incia sumai uka, incia adhodhomea kulina to atandaki manga incia, mboomo ifirimaniakana Aulataʼala i incia. ");
INSERT INTO wlo_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Ibrahim akoʼumuru 99 tao i wakutuuna atotandaki, ");
INSERT INTO wlo_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","sainamo Ismail, anana, akoʼumuru 13 tao wakutuuna atotandaki. ");
INSERT INTO wlo_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","I eo incia sumai uka, Ibrahim tee Ismail, anana, atotandaki. ");
INSERT INTO wlo_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Bhari-bharia umane modhaangiana i bhanuana, malape molaahirina i bhanuana atawa ialina tee doi minaaka i mia dhaga, atotandaki apobhawa-bhawa tee incia. ");
INSERT INTO wlo_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","KAWASANA OPU apatiumbaakamo karona i Ibrahim i saripina manga puu maoge Mamre tangasaana incia auncura i bhambana kemana i wakutuuna eo amasodho. ");
INSERT INTO wlo_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Wakutuuna incia aangka rouna tee atilikia, atiumbamo talu mia akakaro apoaro i incia. Asadari hali incia sumai, abuntulimo incia minaaka i bhambana kemana apokawaaka manga incia kasiimpomo asuju tee ahoromatia. ");
INSERT INTO wlo_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Pogauna, \"E manga opuku, ande usaronaka bhatuamiu alaenga, bholi soo ulalo mboo sumai uka. Kuemani manga opuku siipo i bhanuana bhatuamiu. ");
INSERT INTO wlo_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Uwe bheaalaakea sakawana, kasiimpomo manga opu ubhanui aemiu tee aponiunto i tambena puu incia sii. ");
INSERT INTO wlo_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Bhatua uka bhekubhawa saidhe kinande mamudhaakana amatangka pendua bukumiu roonamo manga opu uumbamo usolo bhatuamiu sii. Sapadha incia sumai, siimpomo manga opu upalausakamo lingkaamiu.\" Pogauna manga, \"Malape, pewaumea mboomo ipogauakamu.\" ");
INSERT INTO wlo_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Ibrahim lausakamo apesua i nuncana kema apokawaaka Sarah tee apogau, \"Pekadhei, alamo talu ganta tarigu momalapena! Kusoa tee karajaaia roti malimbu.\" ");
INSERT INTO wlo_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Kasiimpomo Ibrahim abuntuli i tampana gulumana sapina, aalamo sambaa anana sapi momalompona tee momalapena dagina kasiimpo apasaraakaakea i bhatuana, lausaka akarajaaia. ");
INSERT INTO wlo_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Sapadhana incia sumai Ibrahim abhawamo susu mokonte, uwena susu, tee anana sapi mopadhana ikarajaana sumai, kasiimpo apatalea i aroana manga mia sumai. Tangasaana manga moumbana akande i tambena puu sumai, Ibrahim akakaro i saripina to alaiania. ");
INSERT INTO wlo_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Kasiimpomo manga incia aabhamo, \"Iapaimo o Sarah, bhawinemu?\" Lawanina, \"Iwe sumai, i nuncana kema.\" ");
INSERT INTO wlo_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Apogaumo samia minaaka i manga incia, \"Tao iaroa Iaku bhekumbuli pendua i ingkoo, tee i wakutuu incia sumai Sarah, bhawinemu, akoanaakamo samia anaana umane.\" Hali incia sumai arangoa Sarah minaaka i bhambana kema i talikuna Ibrahim. ");
INSERT INTO wlo_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","I wakutuu incia sumai, Ibrahim tee Sarah amancuanamo tee akoʼumurumo mpuu, Sarah uka indamo akawea bulana. ");
INSERT INTO wlo_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Roonamo itu apotawamo Sarah i nuncana ngangarandana tee apogau, \"Mboona bhekubirahi sainamo iaku kumancuanamo tee opuku amancuanamo uka?\" ");
INSERT INTO wlo_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Kasiimpomo afirimanimo KAWASANA OPU i Ibrahim, \"Apokia Sarah apotawa tee apogau, 'Totuu mboona iaku bhekupalaahiri anaana, sainamo iaku kumancuanamo mboo sii?' ");
INSERT INTO wlo_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Dhaangia mboona manga giu inda momembalina to KAWASANA OPU? I wakutuu padhamo ipatotapuaka, siitumo tao iaroa, Iaku bhekumbuli pendua i ingkoo, tee Sarah akoanaakamo samia anaana umane.\" ");
INSERT INTO wlo_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sarah amaeka. Roonamo sumai incia apesapu, pogauna, \"Iaku inda kupotawa.\" Maka Kawasana Opu alawania, \"Inda, ingkoo utotuu upotawa!\" ");
INSERT INTO wlo_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Kasiimpomo manga mia sumai abhose minaaka iwe sumai tee apotonto i weta i Sodom. Ibrahim alingka apoose to abhawa manga incia. ");
INSERT INTO wlo_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","KAWASANA OPU afirimanimo, \"Iaku inda bhekubuniaka opea bheipewauku sii minaaka i Ibrahim, ");
INSERT INTO wlo_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","roonamo incia bheamembali saangu lipu maoge tee amakaa, tee rampaakanamo incia bhari-bharia lipu i alamu bheapotibhaaka barakati. ");
INSERT INTO wlo_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Iaku padhamo kupili incia mamudhaakana aparintangiaka manga anana tee siwuluna to aose dhalana KAWASANA OPU, tee apewau mototuuna tee kaʼadili. Tee ande mboo sumai, Iaku bhekupamandoa opea mopadhana ijanjiakaku i Ibrahim.\" ");
INSERT INTO wlo_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Kasiimpomo KAWASANA OPU afirimani, \"Peencina to Sodom tee Gomora amaoge mpuu, tee dosana manga amatamo mpuu. ");
INSERT INTO wlo_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Iaku bhekuumba to kukamata opea ipewauna manga atotuu apokana tee pekeena mokawana i Iaku atawa inda. Iaku gauku kumataua.\" ");
INSERT INTO wlo_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Kasiimpo, abhalilimo rua mia malaaʼekatina sumai minaaka iwe sumai tee alingka aporope i Sodom, maka Ibrahim dhaangiapo akakaro i aroana KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Kasiimpo Ibrahim aumba apasari tee apogau, \"Pokia buaka Ingkoo bheupabinasa mia mobanara apobhawa tee mia mokodosa? ");
INSERT INTO wlo_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Ande dhaangia 50 mia mobanara i nuncana kota sumai, mboona Ingkoo bheupabinasa tampa incia sumai tee inda uʼamponia roonamo 50 mia mobanara modhaangiana i nuncana? ");
INSERT INTO wlo_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Amaridho mpuu to Kawasana Opu upewau hali incia sumai, upekamate mia mobanara apobhawa tee mia mokodosa, sabutuna ande mboo sumai, mia mobanara sumai upapokanea tee mia mokodosa. Amaridho mpuu to Kawasana Opu upewau hali incia sumai! Amaridho mpuu to Haakimuna saangua alamu inda bheupewau adili!\" ");
INSERT INTO wlo_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Firimanina KAWASANA OPU, \"Ande kupotibhaaka 50 mia mobanara i kota Sodom, sumaimo Iaku bhekuʼamponia saangua tampa incia sumai roonamo manga incia.\" ");
INSERT INTO wlo_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Apogaumo Ibrahim uka, \"Satotuuna iaku kupabaraniaka karoku kupogau i Kawasana Opu, moomini iaku soomo ngawu tee rapu. ");
INSERT INTO wlo_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Ande akura 5 mia minaaka 50 mia mobanara sumai, mboona Ingkoo bheupabinasa bhari-bharia kota sumai?\" Firimanina, \"Ande kupotibhaaka iwe sumai 45 mia, Iaku inda bhekupabinasea.\" ");
INSERT INTO wlo_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ibrahim apogaumo uka i incia, \"Ande upotibhaaka 40 mia iwe sumai?\" Firimanina, \"Roonamo 40 mia sumai, Iaku inda bhekupewaua.\" ");
INSERT INTO wlo_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Apogaumo Ibrahim, \"Bholimo ancosala Kawasana Opu uʼamara ande iaku kupogau uka, tuaapa ande upotibhaaka iwe sumai 30 mia?\" Firimanina, \"Ande kupotibhaaka iwe sumai 30 mia, Iaku inda bhekupewau hali incia sumai.\" ");
INSERT INTO wlo_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Apogaumo Ibrahim, \"Satotuuna iaku kupabaranimo karoku kupogau i Kawasana Opu. Tuaapa ande upotibhaaka iwe sumai 20 mia?\" Firimanina, \"Roonamo 20 miana sumai, Iaku inda bhekupabinasea.\" ");
INSERT INTO wlo_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Apogaumo Ibrahim, \"Bholimo ancosala Kawasana Opu uʼamara ande iaku kupogau sampearo sii uka. Tuaapa ande upotibhaaka iwe sumai 10 mia?\" Firimanina, \"Roonamo 10 miana sumai, Iaku inda bhekupabinasea.\" ");
INSERT INTO wlo_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Sapadhana afirimani i Ibrahim, KAWASANA OPU abholimea tampa incia sumai, kasiimpomo Ibrahim uka ambuli i tampa mbooresana. ");
INSERT INTO wlo_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Rua miaia malaaʼekati sumai akawamo i Sodom i wakutuuna konowia. I wakutuu incia sumai Lut tangasaana akatoro-toro i bhambana lawana Sodom. Wakutuuna Lut akamata manga incia, akakaromo incia alingka apepagoa manga, kasiimpomo asuju. ");
INSERT INTO wlo_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Pogauna, \"Manga opu, kuemani siipo i bhanuana bhatuamiu sii, pomalopo tee bhanuipea aemiu manga opu. Naile saeona manga opu umembali upalausaka lingkaamiu.\" Lawanina manga incia, \"Inda faraluu umaheru, roonamo ingkami bhetapomalo i tanalapa.\" ");
INSERT INTO wlo_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Maka roonamo Lut aemani mpuu, rua miaia sumai asiimo tee apesua i bhanuana. Incia alaiania tee atunu roti inda mokoragi, kasiimpo manga akandemo. ");
INSERT INTO wlo_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Maka indapo manga akole, manga umane minaaka i bhari-bharia tapana kota Sodom, minaaka i momangurana sampe mancuana, aumba alibu bhanua sumai. ");
INSERT INTO wlo_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Manga incia akembamo Lut tee apogau i incia, \"Iapai manga mia moumbana i ingkoo malo sii? Bhawamea manga incia alimba i ingkami, mamudhaakana ingkami taposaangu tee manga incia.\" ");
INSERT INTO wlo_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Kasiimpo alimbamo Lut apokawaaka manga incia i aroana bhamba, maka atutubhimea bhamba sumai i talikuna. ");
INSERT INTO wlo_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Pogauna, \"E witiwitinaiku, bholimo upewau madhakina. ");
INSERT INTO wlo_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Rangoa, iaku dhaangia rua mia anaku kabuabua indapo mina aposaangu tee umane. Bholiakamo kubhawea manga incia alimba i ingkomiu. Pewaumea manga incia mboomo opea ikamatamiu amalape. Tangkanamo, bholi upewau opeopea i manga mia incia sii, sababuna manga incia aumba apeulu i tambena padhana bhanuaku.\" ");
INSERT INTO wlo_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Pogauna manga incia, \"Dhencu pekaridho!\" Pogauna manga incia uka i Lut, \"Mia incia sii inda soo aumba to amboore iwe sii mboomo dhaga, maka incia gauna amembali haakimu uka! Sii-sii, ingkami bhetapewau madhaki to ingkoo atolabhi minaaka i manga incia.\" Kasiimpomo, manga incia apajungku Lut amakaa mpuu, tee aumba apasari to ajumpuraka bhamba. ");
INSERT INTO wlo_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Maka rua miana sumai apaulu limana, ahela Lut apapesuaia i nuncana bhanua, kasiimpomo atutubhia bhamba. ");
INSERT INTO wlo_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Kasiimpomo, manga incia apekawilomea matana manga mia modhaangiana i aroana bhambana bhanua sumai, minaaka i momaidhiidhina sampe momaogena, sabutuna manga amangulemo apomapeelomo bhamba. ");
INSERT INTO wlo_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Pogauna rua miana sumai i Lut, \"Incema uka witinaimu iwe sii? Bhawamea alimba minaaka i tampa incia sii manga maniamu, manga anamu umane, manga anamu bhawine, atawa incema uka witinaimu i kota incia sii, ");
INSERT INTO wlo_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","roonamo ingkami bhetapabinasa tampa incia sii. Satotuuna, mboo sumai kakaana peencina to kota incia sii i aroana KAWASANA OPU, sabutuna KAWASANA OPU alambokomo ingkami to tapabinasea. ");
INSERT INTO wlo_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Saanampuu alimbamo Lut, kasiimpomo apogau i rua miaia calona ana maniana mohaejatina bheakawiaka anana kabuabuana. Pogauna, \"Makanumo, limbamo minaaka i tampa incia sii, roonamo KAWASANA OPU bheapabinasea kota incia sii!\" Maka rua miaia calona ana maniana aabhi Lut mboomo mia mokabhonga. ");
INSERT INTO wlo_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Wakutuu fajara atiumbamo, rua mia malaaʼekati sumai apajungku-jungkumo Lut, pogauna manga, \"Pekadhei! Bhawamea bhawinemu tee rua miaia anamu bhawine modhaangiana iwe sii, mamudhaakana ingkoo inda uose apabinasako roonamo aduruhaka mpuu kota incia sii.\" ");
INSERT INTO wlo_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Maka incia apekanoe-noe. Kasiimpomo rua miana sumai akeni limana Lut, bhawinena, tee rua mia anana bhawine, roonamo KAWASANA OPU amaasi incana i manga incia. Manga incia abhawea i sambali tee arambasakea i sambalina kota. ");
INSERT INTO wlo_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Sapadhana rua miana sumai abhawea manga incia alimba, apogaumo sala samia minaaka i manga incia, \"Palaimo, pasalaamatia inyawamu! Bholi ubhalili i taliku tee bholi uunto iapaipo i mbolonga sii. Palaimo i tana gunu, mamudhaakana ingkoo inda apabinasako.\" ");
INSERT INTO wlo_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Maka pogauna Lut i manga incia, \"Bholimo mboo itu, e opu. ");
INSERT INTO wlo_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Totuumo opu padhamo umaasiakea bhatuamu sii, tee padhamo ususuakea kaasimu momaogena i bhatuamu tee upasalaamatia inyawana bhatuamu. Maka bhatuamu inda akapoia apalai i tana gunu sumai, ancosala bhatuamu aosea balaa sumai, kasiimpo amate. ");
INSERT INTO wlo_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Kamatea, kota iwe sumai amakasu to kulingkaisia. Tee uka kota incia sumai amaidhiidhi. Undaakea bhatuamu apalai iwe sumai mamudhaakana inyawaku asalaamati. Mboona kota incia sumai amaidhiidhi?\" ");
INSERT INTO wlo_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Pogauna i Lut, \"Malapemo, i nuncana hali incia sii uka iemanimu kutarimaia. Iaku inda bhekupabinasea kota isarongimu itu. ");
INSERT INTO wlo_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Palaimo pekadhei iwe sumai, roonamo iaku inda amembali kupewau opeopea ande ingkoo indapo ukawa iwe sumai.\" Siitumo sababuna, kota incia sumai asarongiakea Zoar. ");
INSERT INTO wlo_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Matana eo atiumbamo i bhawona alamu wakutuuna Lut akawamo i Zoar. ");
INSERT INTO wlo_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Kasiimpomo KAWASANA OPU apakowaomea Sodom tee Gomora tee walera tee waa minaaka i KAWASANA OPU, minaaka i laiana. ");
INSERT INTO wlo_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Incia apabinasa manga kota incia sumai, tee uka sakaaratea mbolongana, bhari-bharia raʼeati, tee manga penembula i tana. ");
INSERT INTO wlo_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Maka bhawinena Lut abhalili i talikuna kasiimpo amembalimo ariina gara. ");
INSERT INTO wlo_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Ibrahim abhangu saeona kasiimpo alingka i tampa incia akakaro i aroana KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Incia apotonto i weta i Sodom tee Gomora tee sakaaratea mbolonga sumai. Atiumbamo o ombu i kalangaana minaaka i tana sumai, mboomo o ombu maoge minaaka i busoa. ");
INSERT INTO wlo_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","I wakutuuna Aulataʼala apabinasa manga kota i mbolonga sumai, Incia audhanimo Ibrahim. Sababuna itu, Incia atumpumo Lut alimba minaaka i tanga-tangana kahancuru sumai wakutuu Incia abhanculea manga kota tampana Lut amboore. ");
INSERT INTO wlo_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Kasiimpomo Lut apobhawa tee rua mia anana bhawine alingka minaaka i Zoar tee amboore i tana gunu roonamo incia anamisi kaeka to amboore i Zoar. Incia amboore i nuncana saangu lia apobhawa tee rua mia anana bhawine. ");
INSERT INTO wlo_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","I saangu wakutuu, anana tumpe apogau tee anana kaepu, \"O amata amancuanamo, tee inda dhaangia umane i lipu sii to mokawiakana ingkita, mboomo adatina saangua alamu. ");
INSERT INTO wlo_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Maimo tadhawu o amata asumpu angguru, kasiimpomo takole tee incia, mamudhaakana ingkita amembali tapalausaka siwuluna o amata.\" ");
INSERT INTO wlo_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Saanampuu manga incia adhawuakamo amana asumpu angguru i malo incia sumai. Kasiimpomo apesuamo anana tumpe tee akole tee amana. Maka amana inda asadara, malape anana sumai apotidhole atawa wakutuuna anana sumai abhangu. ");
INSERT INTO wlo_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Samainawana, apogaumo anana tumpe i anana kaepu, \"Rangoa, samaloa iaku kukole tee amata. Mai, tadhawuakea asumpu angguru uka malo incia sii, kasiimpomo upesuamo tee ukole tee incia, mamudhaakana ingkita amembali tapalausaka siwuluna amata.\" ");
INSERT INTO wlo_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Sabutuna manga incia adhawumo amana manga asumpu angguru uka i malo incia sumai, kasiimpomo abhangumo anana kaepu tee akole tee amana. Maka amana inda asadara, malape anana sumai apotidhole atawa anana sumai abhangu. ");
INSERT INTO wlo_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Saanampuu rua mia anana Lut sumai abhawa-bhawamo minaaka i amana manga. ");
INSERT INTO wlo_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Anana tumpe apalaahirimo samia anaana umane asarongiakea Moab. Incia satotuuna opuana siwuluna miana Moab modhaangiana sii-sii. ");
INSERT INTO wlo_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Anana kaepu uka apalaahirimo samia anaana umane asarongiakea Bin-Ami. Incia satotuuna opuana siwuluna miana Amon modhaangiana sii-sii. ");
INSERT INTO wlo_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Kasiimpo Ibrahim abhosemo minaaka iwe sumai aporope i Tana Negeb, kasiimpo amboore i tanga-tangana Kades tee Syur. Incia amboore i Gerar mboomo dhaga. ");
INSERT INTO wlo_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","I Gerar Ibrahim apogau to Sarah, bhawinena, \"Incia witinaiku.\" Rampaakanamo sumai, Abimelekh, rajana Gerar, atumpu mia alingkaisi Sarah. ");
INSERT INTO wlo_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Maka Aulataʼala aumba i Abimelekh i nuncana saangu pongipina i wakutuu malo tee afirimanimo i incia, \"Mataua, ingkoo bheumate roonamo bhawine ilingkaisimu sumai; sababuna incia akoumanemo.\" ");
INSERT INTO wlo_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","I wakutuu incia sumai Abimelekh indapo aposaangu tee Sarah. Saanampuu apogau, \"E Opu, aunda akalamu Ingkoo upekamate miana saangu lipu inda mosalana? ");
INSERT INTO wlo_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Buaka mencuana Ibrahim sumai karona mopogauna i iaku, 'Incia andiku?' Tee bhawine sumai karona uka mopogauna, 'Incia akaku.' Jadi, kupewau hali incia sii tee ngangarandaku morelana tee limaku momangkilona.\" ");
INSERT INTO wlo_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Kasiimpomo, Aulataʼala afirimani i incia i nuncana pongipina sumai, \"Iaku kumataua ande ingkoo upewau hali incia sumai tee arela ngangarandamu. Siitumo sababuna, Iaku kusasiko upewau dosa i Iaku, tee inda kutaroakako udhingku bhawine sumai. ");
INSERT INTO wlo_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Sii-sii, pambulimea o bhawinena mia sumai, roonamo o umanena samia nabii. Incia bheadoʼa to ingkoo mamudhaakana ingkoo sadhaadhaana bheudhadhi. Maka ande ingkoo inda upambulia o bhawinena sumai, mataumea, satotuuna ingkoo tee bhari-bharia mia modhaangiana i karomu bheamate.\" ");
INSERT INTO wlo_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Samainawana, Abimelekh abhangu samalo-malona, kasiimpo akembamo bhari-bharia bhatuana tee apaumbaakea bhari-bharia hali incia sumai i manga incia. Saanampuu, manga incia amembalimo amaeka mpuu. ");
INSERT INTO wlo_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Kasiimpomo Abimelekh akembamo Ibrahim tee apogau i incia, \"Opea padhamo ipewaumu i ingkami? Opea dosaku i ingkoo sampe ingkoo uumbaaka dosa momaoge i karoku tee i pamarintaku? Ingkoo padhamo upewau inda molaengana i iaku.\" ");
INSERT INTO wlo_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Pogauna uka i Ibrahim, \"Opea haejatimu sampe ingkoo upewau mboo sii?\" ");
INSERT INTO wlo_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Alawanimo Ibrahim, \"Iaku kuabhia ande i tampa incia sii inda dhaangia moosena kaadharina Aulataʼala, saanampuu tantumo bheapekamateaku rampaakanamo bhawineku. ");
INSERT INTO wlo_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Tee uka, incia totuu andiku. Incia o anana amaku, tangkanamo mencuana o anana inaku, kasiimpomo incia amembali bhawineku. ");
INSERT INTO wlo_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Jadi, wakutuuna Aulataʼala atumpuaku kupekalingka-lingka kubholi bhanuana amaku, kupogau tee bhawineku, 'Patiumbaakea o kaasimu tee iaku tee akala mboo sii: I tampa iapai uka talingka, pogauakea ande iaku akamu.'\" ");
INSERT INTO wlo_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Kasiimpomo Abimelekh aalamo manga kadhambaakana bhembe, dumba, sapi, tee uka manga bhatua umane tee bhawine, kasiimpomo adhawuakea bhari-bharia sumai i Ibrahim. Incia uka apambulimea Sarah, bhawinena Ibrahim sumai. ");
INSERT INTO wlo_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Apogau Abimelekh, \"Kamatea, lipuku atobungkale to ingkoo. Mbooremo iapai peeluamu.\" ");
INSERT INTO wlo_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Pogauna i Sarah, \"Rangoa, iaku padhamo kudhawuakea 1.000 tibha pera i akamu i aroana matana bhari-bharia mia mopobhawana tee ingkoo, to bukutiina kangkilomu. I nuncana sagala hali, ingkoo inda usala.\" ");
INSERT INTO wlo_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Kasiimpomo Ibrahim aemani doʼa i Aulataʼala, tee Aulataʼala apaunto Abimelekh, bhawinena, tee manga bhatuana bhawine saanampuu manga incia amembali apalaahiri uka. ");
INSERT INTO wlo_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Sababuna sapadhana Abimelekh alingkaisi Sarah, bhawinena Ibrahim, KAWASANA OPU atutubhia kadhumana bhari-bharia bhawine i maligena Abimelekh. ");
INSERT INTO wlo_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","KAWASANA OPU atilikimo Sarah mboo mopadhana ifirimaniakana, tee KAWASANA OPU apewau mboomo ijanjiakana i Sarah. ");
INSERT INTO wlo_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Saanampuu abhawa-bhawamo Sarah, kasiimpo apalaahirimo samia anaana umane to Ibrahim i wakutuu amancuanamo, sumaimo wakutuu padhamo ipatantuakana mboo janjina Aulataʼala i incia. ");
INSERT INTO wlo_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Ibrahim asarongiakea anana siimpo molaahirina sumai Ishak, siitumo anaana ipalaahirina Sarah to incia. ");
INSERT INTO wlo_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Kasiimpo, Ibrahim atandakimo Ishak, anaana sumai wakutuu umuruna walu eo, mboomo iparintangiakana Aulataʼala i incia. ");
INSERT INTO wlo_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Umuruna Ibrahim 100 tao wakutuuna Ishak, o anana, apalaahiria to incia. ");
INSERT INTO wlo_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sarah apogau, \"Aulataʼala padhamo apewau iaku kupotawa. Bhari-bharia mia morangona bheapotawa tee iaku.\" ");
INSERT INTO wlo_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Pogauna uka, \"Incema i piamo itu momembalina mopogauna tee Ibrahim ande o Sarah apadudu anaana? Maka, iaku padhamo kupalaahiri samia anaana umane to incia i wakutuuna amancuanamo.\" ");
INSERT INTO wlo_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Anaana sumai ajulumo amaoge kasiimpo indamo apadudua. Ibrahim apadhaangiamo kariaa maoge i eo incia sumai Ishak indamo apadudua. ");
INSERT INTO wlo_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","I kariaa sumai, Sarah akamata anana Ibrahim ipalaahirina Hajar (bhawine Mesir sumai) tangasaana aele-ele Ishak. ");
INSERT INTO wlo_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Sababuna sumai, apogaumo Sarah tee Ibrahim, \"Padhencua bhatua bhawine sumai tee anana, roonamo anana bhatua bhawine sii inda amembali atarima tinauraka apobhawa tee anaku, Ishak.\" ");
INSERT INTO wlo_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Hali incia sumai amandawuakea mpuu incana Ibrahim, roonamo Ismail o anana uka. ");
INSERT INTO wlo_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Maka o Aulataʼala afirimanimo tee Ibrahim, \"Bholi amandawu incamu roonamo anana sumai tee bhatuamu. Bhari-bharia ipogauakana Sarah tee ingkoo tabeana urangoa, roonamo mominaakana i Ishak bheasarongiakea siwulumu. ");
INSERT INTO wlo_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Moomini, anana minaaka i bhatua bhawine sumai uka bhekupamembalia saangu lipu, roonamo incia uka siwulumu.\" ");
INSERT INTO wlo_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Samainawana Ibrahim abhangumo samalo-malona. Aalamo roti tee kadhu kulina uwe, kasiimpo adhikaia roti tee uwe i awaana Hajar. Incia uka apasaraakaakea anana i incia, kasiimpomo atumpumo bhawine sumai alingka. Saanampuu alingkamo Hajar, apekalingka-lingka i Tana Matuu Bersyeba. ");
INSERT INTO wlo_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Wakutuuna uwe i nuncana kadhu kulina uwe sumai amapupu, apadholemea anana i tambena saangu puu momaidhiidhina. ");
INSERT INTO wlo_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Kasiimpomo incia alingka tee auncura apekaridho apowetaaka kauncuramaka tee anana sumai, kera-kera mboo karidhona anana panana mopepanana, roonamo pogauna, \"Ancosala kukamata anaku amate.\" O inana auncura atangisia tee suara makaa mpuu. ");
INSERT INTO wlo_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Aulataʼala arango suarana ana sumai, kasiimpomo malaaʼekatina Aulataʼala akembamo Hajar minaaka i laiana. Pogauna i incia, \"Dhaangia opea tee ingkoo, Hajar? Bholi maeka, roonamo Aulataʼala arangoa suarana ana sumai minaaka i tampana incia apotidhole. ");
INSERT INTO wlo_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Bhangumo, angkamea anana sumai, tee tondaia, roonamo Iaku bhekupamembalia saangu lipu momaoge.\" ");
INSERT INTO wlo_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Kasiimpomo, Aulataʼala abungkale matana Hajar saanampuu incia akamata saangu sumu. Sumaimo incia alingkamo aantoki kadhu kulina tee uwe, kasiimpomo adhawuaka anana sumai asumpu. ");
INSERT INTO wlo_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Aulataʼala apoose tee anana sumai, tee incia ajulumo amaoge. Incia amboore i tana matuu kasiimpo amembalimo samia pande pana. ");
INSERT INTO wlo_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Tangasaana incia amboore i Tana Matuu Paran, inana aalamo to incia samia bhawine minaaka i Tana Mesir. ");
INSERT INTO wlo_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","I wakutuu incia sumai Abimelekh tee Pikhol, kapalana suludaduna, apogau i Ibrahim mboo sii, \"Aulataʼala abarakati ingkoo i nuncana sagala hali ipewaumu. ");
INSERT INTO wlo_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Sii-sii, sumpamo i iaku iwe sii i aroana Aulataʼala, ande ingkoo inda bheugau-gauaku, manga anaku, manga opuaku, atawa opua isangoaku. Mboomo iaku padhamo kupewauko tee kaasi, pewaua uka mboo sii i iaku tee lipu sii, tampana ingkoo umboore mboomo dhaga.\" ");
INSERT INTO wlo_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Pogaumo Ibrahim, \"Iaku kusumpa.\" ");
INSERT INTO wlo_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Maka, Ibrahim apeenci i Abimelekh to sumu ialana manga bhatuana Abimelekh. ");
INSERT INTO wlo_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Pogaumo Abimelekh, \"Iaku inda kumataua incema mopewauna hali incia siitu. Tee uka, ingkoo inda upaumbaaku. Iaku indapo mina kurangoa, tabeana eo sii.\" ");
INSERT INTO wlo_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Saanampuu, Ibrahim aalamo pia-pia mbaa dumba tee sapi, kasiimpomo adhawuakea i Abimelekh. Sapadhana incia sumai manga incia abhokemo pojanjia. ");
INSERT INTO wlo_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Ibrahim agaatimo pitu mbaa anana dumba bhawine minaaka i gulumana dumba sumai. ");
INSERT INTO wlo_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Aabhamo Abimelekh i Ibrahim, \"Opea haejatimu ugaati pitu mbaa anana dumba bhawine sii?\" ");
INSERT INTO wlo_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Lawanimo, \"Pitu mbaa anana dumba bhawine sii tabeana ualea minaaka i limaku sanampuu ingkoo umembali sakusii ande iakumo moselina sumu sii.\" ");
INSERT INTO wlo_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Sumaimo sababuna tampa incia sumai asarongiakea Bersyeba, roonamo ruamiaia padhamo abhoke sumpana iwe sumai. ");
INSERT INTO wlo_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Sapadhana manga incia abhoke pojanjiana i Bersyeba, amakanumo Abimelekh tee Pikhol, kapalana suludadu, kasiimpomo ambuli i lipuna miana Filistin. ");
INSERT INTO wlo_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Ibrahim apombula sapuu puuna tamariska i Bersyeba, tee agora iwe sumai sarona KAWASANA OPU, Aulataʼala molagina saʼumurua. ");
INSERT INTO wlo_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Tee dhaangiapo amangenge Ibrahim amboore mboomo dhaga i lipuna miana Filistin. ");
INSERT INTO wlo_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Sapadhana manga kajadia incia sumai, Aulataʼala aujimo Ibrahim. Firimanina i incia, \"Ibrahim.\" Lawanina, \"Umbe, Kawasana Opu.\" ");
INSERT INTO wlo_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Firimanina, \"Bhawamea o anamu, anamu samia-miana imaasiakamu, siitumo Ishak, tee lingkamo i Tana Moria. Pasombaakamea incia iwe sumai to kurubani tunua, i bhawona sala saangu gunu bheibhotoakaku to ingkoo.\" ");
INSERT INTO wlo_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Ibrahim uka abhangu samalo-malona. Apasamea kalempesina kauncuramaka i keledaina, kasiimpomo akembamea rua mia bhatuana to apobhawa tee incia, tee uka Ishak, anana. Incia aweta kau to kurubani tunua kasiimpo lausakamo alingka arope i tampa ipogauakana Aulataʼala i incia. ");
INSERT INTO wlo_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","I eo talu eona, wakutuuna Ibrahim apatinda potontona, atokamatamo tampa incia sumai minaaka i karidhoana. ");
INSERT INTO wlo_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Saanampuu apogaumo Ibrahim i manga bhatuana, \"Mbooremo iwe sii tee keledai sii. Iaku tee anaku sii bhetalingka iwe siate. Ingkami bhetasambahea, kasiimpomo tambuli pendua i ingkomiu.\" ");
INSERT INTO wlo_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ibrahim aala kau ibhawana sumai to kurubani tunua tee apasodhaakea i awaana Ishak, anana. Incia samia abhawa waa tee samata piso. Kasiimpo alingkamo rua miaia apobhawa-bhawa. ");
INSERT INTO wlo_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Apogaumo Ishak i Ibrahim, amana, \"Ama.\" Lawanina, \"E, anaku.\" Pogaumo Ishak, \"Iwe sii dhaangia waa tee kau itunu, maka iapaimo anana dumba to ikurubaniaka?\" ");
INSERT INTO wlo_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Alawanimo Ibrahim, \"Aulataʼala karona bhemopasiapuakana to karona anana dumba to kurubani tunua sumai anaku.\" Kasiimpo alingkamo manga rua miaia apobhawa-bhawa. ");
INSERT INTO wlo_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Sakawana manga i tampa ipogauakana Aulataʼala to incia, Ibrahim atapimo saangu tampana tunuana kurubani. Incia aʼatoro kau itunu tee abhoke Ishak, anana. Kasiimpo apadholea i bhawona tunuana kurubani sumai, i bhawona kau itunu. ");
INSERT INTO wlo_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Kasiimpo Ibrahim aala piso to asumbeleaka anana. ");
INSERT INTO wlo_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Maka roonamo malaaʼekatina KAWASANA OPU agora i incia minaaka i laiana, \"Ibrahim! Ibrahim!\" Lawanina, \"Umbe, Opu.\" ");
INSERT INTO wlo_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Firimanina, \"Bholi upacilakea ana sumai tee bholi ukia-kiaia, roonamo sii-sii Iaku kumataua ande ingkoo umaeka i Aulataʼala tee arela totona incamu upasaraaka anamu, anamu samia-miana itu i Iaku.\" ");
INSERT INTO wlo_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Wakutuuna Ibrahim apatinda potontona tee akamatea i talikuna sambaa dumba umane tee tanduna atokai i rumpu mokorui. Ibrahim alingka aala dumba umane sumai, kasiimpo apasombaakea to kurubani tunuana kabholosina anana. ");
INSERT INTO wlo_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Saanampuu Ibrahim asarongiakea tampa incia sumai \"KAWASANA OPU apasiapuakea.\" Sababuna itu sampemo sii-sii mia apogauakea, \"I bhawona gununa KAWASANA OPU, bheapasiapuakea.\" ");
INSERT INTO wlo_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Kamondona rua wulinga malaaʼekatina KAWASANA OPU agoramo i Ibrahim minaaka i laiana, ");
INSERT INTO wlo_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","pogauna, \"To karoku samia Iaku kusumpa, mboo sumaimo firimanina KAWASANA OPU, roonamo ingkoo padhamo upewau mboo sumai, tee arela totona incamu upasaraaka i Iaku anamu, anamu samia-miana itu, ");
INSERT INTO wlo_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","sumaimo dhaanamo Iaku bhekubarakatiko tee dhaanamo Iaku kupekabharia siwulumu mboomo kalipopo i laiana tee mboomo bhone i bhiwina tawo. Siwulumu bheauncuramiki bhambana lawana manga musuna, ");
INSERT INTO wlo_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","tee alaloi siwulumu bhari-bharia lipu i alamu bheapotibhaaka barakati, roonamo ingkoo padhamo uosea pogauku.\" ");
INSERT INTO wlo_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Sapadhana sumai ambulimo Ibrahim i manga bhatuana. Manga incia uka amakanumo kasiimpomo alingka apobhawa-bhawa i Bersyeba. Kasiimpo ambooremo Ibrahim i Bersyeba. ");
INSERT INTO wlo_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Sapadhana incia sumai, Ibrahim apokawaaka lele mboo sumai, \"Mataua, Milka uka padhamo apalaahiri manga anaana umane to Nahor, witinaina opuna. ");
INSERT INTO wlo_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Us, anana tumpena, kasiimpomo Bus, andina, satorosuna Kemuel (amana Aram), ");
INSERT INTO wlo_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kesed, Haso, Pildas, Yidlaf, tee Betuel.\" ");
INSERT INTO wlo_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuel akoanaakamo Ribka. Walu miana sii apalaahiria Milka to Nahor, witinaina Ibrahim. ");
INSERT INTO wlo_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Dhaangia uka mosagaanana minaaka i maruena Nahor akosaro Reuma, alaahiri uka Tebah, Gaham, Tahas, tee Maakha. ");
INSERT INTO wlo_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sarah adhadhi 127 tao. Mboo sumaimo kangengena dhadhina Sarah. ");
INSERT INTO wlo_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Sarah amate i Kiryat-Arba, siitumo Hebron, i Tana Kanaan. Kasiimpomo Ibrahim aumba amaasimo tee atangisi Sarah. ");
INSERT INTO wlo_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Pia-pia wakutuu sapadhana sumai, Ibrahim akakaro minaaka i saripina maeatina bhawinena, kasiimpo apogau tee manga miana Het momboorena i lipu incia sumai. Pogauna, ");
INSERT INTO wlo_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","\"Iaku sii samia dhaga moumbana to kumboore i tanga-tangamiu. Dhawuakaaku saangu tampana koburu i tanamiu sii, mamudhaakana amembali kukoburu bhawineku, momatena.\" ");
INSERT INTO wlo_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Kalawanina bani Het i Ibrahim, ");
INSERT INTO wlo_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","\"Rangopo ingkami, opu. Opu satotuuna samia kapala maoge i tanga-tangana ingkami. Koburumea bhawinemu opu i nuncana sala saangu koburumami momalapena. Inda bheadhaangia moomini samia uka minaaka i ingkami inda modhawuakana tanana koburuna to opu upakea ukoburuaka bhawinemu opu.\" ");
INSERT INTO wlo_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Saanampuu abhangumo Ibrahim, kasiimpomo asuju adhawu horomati i manga miana Het, momboorena i lipu sumai, ");
INSERT INTO wlo_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","tee apogau, \"Ande arela ngangarandamiu kukoburu bhawineku iwe sii, rangoakupo, tulungi uemaniakaaku i Efron bin Zohar, ");
INSERT INTO wlo_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","mamudhaakana incia adhawuakaaku Lia Makhpela, modhaangiana i tapana inawuna. Malapena incia aasoa i iaku tee haragaa molaenga i aroamiu, mamudhaakana amembali pewauaku to koburu.\" ");
INSERT INTO wlo_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","I wakutuu incia sumai Efron auncura i tanga-tangana manga miana Het moporomusakana. Kasiimpomo Efron, alawani Ibrahim i aroana bhari-bharia miana Het moumbana i bhambana lawana kota sumai. Pogauna, ");
INSERT INTO wlo_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","\"Inda, opuku, rangoakupo. Inawu sumai kudhawuaka i opu. Lia modhaangiana i nuncana uka kudhawuaka i opu. I aroana matana manga mia salipuku iaku kudhawuakea i opu. Koburumea bhawinemu opu iwe sumai.\" ");
INSERT INTO wlo_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Kasiimpo asujumo Ibrahim i aroana raʼeatina lipu incia sumai. ");
INSERT INTO wlo_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Wakutuuna manga miana Het arangoa, incia apogaumo i Efron, \"Perangoiakupo! Kuundaakea opea ipodhadhamu sumai. Iaku bhekupomea haragaana inawu sumai tee liana. Tarimaia doina minaaka iaku, mamudhaakana bhekukoburu bhawineku iwe sumai.\" ");
INSERT INTO wlo_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Alawanimo Efron i Ibrahim, ");
INSERT INTO wlo_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","\"Opuku perangoiakupo. Ande mboo itu, tana incia sumai akoharagaa 400 tibha pera, maka opea maʼanana to mia mboo ingkita sii? Koburumea bhawinena opu iwe sumai.\" ");
INSERT INTO wlo_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Ibrahim aosemo pogauna Efron. Incia agagariakamea to Efron o doi pera mboomo kabhari mopadhana isarongiakana Efron i aroana raʼeatina Het sumai, siitumo 400 tibha pera, o katamona mboomo kananea i tanga-tangana manga moparaasona. ");
INSERT INTO wlo_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Mboo sumaimo akalana Ibrahim aali inawuna Efron modhaangiana i Makhpela, i sawetana timbu Mamre, siitumo inawu tee lia modhaangiana i nuncana tee uka bhari-bharia puu i nuncana tidhana inawu sumai. ");
INSERT INTO wlo_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Mboo sumaimo inawu sumai amembali pewauana mosahana Ibrahim. Poali poasona tana incia sumai asakusiiakea manga miana Het moporomusakana i bhambana lawana kota. ");
INSERT INTO wlo_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Sapadhana incia sumai Ibrahim akoburumo Sarah, bhawinena, i nuncana lia i inawu Makhpela, i sawetana timbu Mamre, siitumo Hebron, i Tana Kanaan. ");
INSERT INTO wlo_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Mboo sumaimo inawu tee lia modhaangiana i nuncana amembali pewauana mosahana Ibrahim. Incia aalia minaaka i miana Het to tana koburuna. ");
INSERT INTO wlo_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Ibrahim amancuanamo mpuu tee akoʼumurumo. KAWASANA OPU abarakati Ibrahim i nuncana sagala hali. ");
INSERT INTO wlo_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Apogaumo Ibrahim i bhatuana mokoʼumuruna dhadhina i nuncana bhanuana tee idhawuakana kuasa to sagala giu pewauana, \"Dhikamea o limamu i tambena paaku mamudhaakana kusumpako. ");
INSERT INTO wlo_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Iaku kuemaniko usumpa to KAWASANA OPU, Aulataʼala mokuasaina laiana tee alamu, ande ingkoo inda bheuala samia bhawine to anaku minaaka i tanga-tangana manga ana bhawine Kanaan, moomini kumboore i tanga-tangana manga incia. ");
INSERT INTO wlo_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Maka, ingkoo tabeana ulingka i lipu laahiriaku tee i manga witinaiku to uala samia bhawine to Ishak, anaku.\" ");
INSERT INTO wlo_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Pogauna bhatuana i incia, \"Kuunda, maka ancosala bhawine sumai inda aunda aose iaku i lipu sii. Ande mboo sii, amembali iaku kumbuli to kubhawa anana opu i lipu laahiriana opu sumai?\" ");
INSERT INTO wlo_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Pogauna Ibrahim i incia, \"Udhania, bholi ubhawa anaku ambuli iwe sumako! ");
INSERT INTO wlo_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","KAWASANA OPU, Aulataʼala mokuasaina laiana, aalaakumo minaaka i bhanuana amaku tee minaaka i lipu laahiriaku. Incia uka padhamo afirimani tee asumpa i iaku mboo sii, 'I siwulumu Iaku bhekudhawuaka lipu sii.' Tantumo Incia uka bhealamboko malaaʼekatina alingka i aroamu, mamudhaakana umembali uala samia bhawine to anaku minaaka iwe sumai. ");
INSERT INTO wlo_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Maka ande o bhawine sumai inda aunda aose ingkoo, sumaimo ubebasimo minaaka i sumpamu i iaku. Tangkanamo, bholi ubhawa anaku ambuli iwe sumako.\" ");
INSERT INTO wlo_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Kasiimpomo bhatua sumai adhika limana i tambena paana Ibrahim, opuna, tee asumpa i incia to hali incia sumai. ");
INSERT INTO wlo_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Bhatua sumai aalamo sapulu mbaa unta, kasiimpo alingka tee abhawa pegiu-giu bhara mokoharagaa pewauana opuna. Incia abhose aporope i Aram-Mesopotamia, i kota tampa mbooresana Nahor. ");
INSERT INTO wlo_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Iwe sumai, apauntomo manga untana amakasu i saangu sumu i sambalina kota wakutuuna konowia, wakutuuna manga bhawine alimba to asiwu uwe. ");
INSERT INTO wlo_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Kasiimpomo bhatuana Ibrahim adoʼa, \"E KAWASANA OPU, Aulataʼala isombana opuku Ibrahim, pewaua maasangia iaku kukohasili i eo sii, tee ususuakea kaasimu i opuku. ");
INSERT INTO wlo_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Kamatea, iaku kukakaro amakasu matana uwe sii, tee manga ana bhawine miana kota sii bheaumba to asiwu uwe. ");
INSERT INTO wlo_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Ande iaku kupogau i samia kabuabua, 'Tulungi pasapoa bhosumu tee dhawuaku kusumpu,' tee incia alawani, 'Sumpumo, manga untamu uka bhekudhawua asumpu,' inciamo mia ipatantuakana KAWASANA OPU to bhatuamu Ishak. Tee cara mboo sumaimo iaku bhekumataua ande KAWASANA OPU padhamo asusuakea kaasina i opuku, Ibrahim.\" ");
INSERT INTO wlo_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Indapo apadha incia apogau, saanampuu aumbamo Ribka, tee bhosu i bhawona awaana. Incia anana bhawine Betuel tee Betuel satotuuna anana umanena Milka, siitumo bhawinena Nahor, witinaina Ibrahim. ");
INSERT INTO wlo_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Kabuabua sumai amakesa mpuu rouna, tee indapo amatau umane. Incia asapo i matana uwe sumai aantoki bhosuna, kasiimpo akompa pendua. ");
INSERT INTO wlo_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Saanampuu abuntulimo bhatua sumai apokawaakea tee apogau, \"Tulungi, dhawuaku kusumpu minaaka i bhosumu itu, podho saidhe.\" ");
INSERT INTO wlo_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Lawanina, \"Sumpumo, opuku.\" Lausakamo apasapoa bhosuna i limana, kasiimpomo adawumea asumpu. ");
INSERT INTO wlo_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Sapadhana adhawua asumpu i bhatuana Ibrahim, apogaumo kabuabua sumai, \"Iaku bhekusiwuakea uwe uka to manga untana opu, sampe bhari-bharia atumpu incana asumpu.\" ");
INSERT INTO wlo_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Kasiimpomo lausakamo alalia antona bhosuna i nuncana tampana sumpuana kadhambaakana, kasiimpo abuntulimo uka i matana uwe to asiwu uwe to bhari-bharia untana mia incia sumai. ");
INSERT INTO wlo_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Tangasaana o kabuabua sumai aala uwe to manga untana, bhatua sumai inda tee uuʼuuna soomo atilikia to amataua ande o KAWASANA OPU apewau lingkaana akohasili atawa inda. ");
INSERT INTO wlo_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Sapadhana asumpu manga untana sumai, bhatuana Ibrahim aalamo singkaru bulawa katamona kera-kera lima haramu tee sapasa simbi minaaka i bulawa katamona 115 haramu. ");
INSERT INTO wlo_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Kasiimpo incia aabha, \"Anana incema ingkoo? Pogaumo i iaku. Dhaangia tampa i bhanuana amamu to ingkami tapomalo?\" ");
INSERT INTO wlo_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Alawanimo kabuabua sumai i incia, \"Iaku sii anana Betuel. Betuel satotuuna anana ipalaahirina Milka to Nahor.\" ");
INSERT INTO wlo_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Pogauna kabuabua sumai uka i incia, \"Laena bhae tee kinandena kadhambaaka abhari i ingkami. Tampana pomaloa uka dhaangia.\" ");
INSERT INTO wlo_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Saanampuu asujumo mia sumai asomba KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Pogauna, \"Sagala puji to KAWASANA OPU, Aulataʼalana opuku Ibrahim. Inda mabhotu kaasina molagina to opuku. KAWASANA OPU mosusuakaaku dhala i bhanuana manga witinaina opuku.\" ");
INSERT INTO wlo_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Kabuabua sumai uka abuntulimo tee alingka apaumbaakea saangua bhanuana inana to hali incia sii. ");
INSERT INTO wlo_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Ribka dhaangia samia witinaina umane mokosarona Laban. Abuntulimo Laban arope i matana uwe to apokawaaka mia sumai. ");
INSERT INTO wlo_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Lausakamo sapadhana incia akamata dhali-dhali tee simbi i limana witinaina tee sapadhana incia arango pogauna Ribka, \"Mboo sumaimo pogauna mia sumai i iaku,\" Laban alingka apokawaakea mia incia sumai, atokamata tangasaana akabhale-bhale tee manga untana i saripina matana uwe. ");
INSERT INTO wlo_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Pogauna Laban, \"Maimo, e ingkoo ibarakatina KAWASANA OPU. Pokia ingkoo ukabhale-bhale i sambali? Bhanua padhamo kusiapuakea, tee uka tampa to manga unta sii.\" ");
INSERT INTO wlo_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Saanampuu apesuamo mia sumai i nuncana bhanua, kasiimpomo bhawana manga unta apasapoa, laena bhae tee kinandena kadhambaaka adhawuakea i manga unta sumai. Kasiimpo abhawaakea uwe to abhanuiaka aena bhatuana Ibrahim tee manga mia mopobhawana tee incia. ");
INSERT INTO wlo_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Padha incia sumai, kinande apatalaakamea i aroana manga. Maka mia incia sumai apogau, \"Iaku mendeupo kukande ande indapo kupakawaaka kasamea ibhawaku.\" Lawanimo Laban, \"Pakawaakamea.\" ");
INSERT INTO wlo_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Apogaumo incia, \"Iaku sii bhatuana Ibrahim.\" ");
INSERT INTO wlo_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","KAWASANA OPU abarakati mpuu opuku sumai saanampuu incia amembali arangkaea. KAWASANA OPU adhawuakea gulumana bhembe, dumba, sapi, unta tee keledai, bulawa tee pera, manga bhatua umane tee bhawine. ");
INSERT INTO wlo_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Sarah, bhawinena opuku, apalaahiri samia ana umane i wakutuuna amancuanamo to opuku. I anana sumai, opuku adhawuakea sagala giu pewauana. ");
INSERT INTO wlo_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Kasiimpo opuku atumpuaku kusumpa, pogauna, 'Bholi uala samia bhawine to anaku minaaka i tanga-tangana manga kabuabuana Kanaan, o lipu imbooresaku sii. ");
INSERT INTO wlo_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Maka ingkoo tabeana ulingka i witinaina amaku tee i kaoumuku to uala samia bhawine to anaku.\" ");
INSERT INTO wlo_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Pogauku i opuku, 'Kuunda, maka ancosala bhawine sumai inda aunda aoseaku.' ");
INSERT INTO wlo_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Pogauna i iaku, 'KAWASANA OPU, i aroana iaku kudhadhi, bhealamboko malaaʼekatina apobhawa tee ingkoo tee apamembali lingkaamu akohasili, mamudhaakana ingkoo umembali uala samia bhawine to anaku minaaka i kaoumuku tee minaaka i witinaina amaku. ");
INSERT INTO wlo_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Ande ingkoo ukawamo i kaoumuku, utorambasakamo minaaka i sumpamu i iaku. Moomini manga incia inda adhawuakako bhawine sumai, ingkoo sadhaadhaa utorambasaka minaaka i sumpamu i iaku.' ");
INSERT INTO wlo_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","I eo sii kukawamo i matana uwe sumai. Kasiimpo kupogau, 'E KAWASANA OPU, Aulataʼala ipujina opuku Ibrahim, maasangia upamembalia lingkaaku sii akohasili. ");
INSERT INTO wlo_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Kamatea, iaku kukakaro i saripina matana uwe sii. Ande dhaangia samia kabuabua alimba asiwu uwe, bhekupogau tee incia, \"Tulungiaku dhawuaku kusumpu minaaka i bhosumu itu, podhomo saidhe.\" ");
INSERT INTO wlo_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Ande incia alawaniaku, \"Sumpumo, tee manga untamu uka bhekupasumpua,\" sumaimo bhawine itantuakana KAWASANA OPU to anana opuku.\" ");
INSERT INTO wlo_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Indapo apadha kupogau i nuncana ngangarandaku, saanampuu aumbamo Ribka tee bhosu ibhawona awaana. Incia asapo i matana uwe kasiimpo asiwuakamea uwe. Iaku kupogau tee incia, 'Tulungi dhawuaku kusumpu.' ");
INSERT INTO wlo_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Lausakamo incia apasapoa bhosuna minaaka i awaana tee apogau, 'Sumpumo. Manga untana opuku uka bhekudhawua asumpu.' Kasiimpo kusumpumo, tee manga untaku uka adhawua asumpu. ");
INSERT INTO wlo_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Padha incia sumai kuabhamo i incia, 'Anana incema ingkoo?' Lawanina, 'Anana Betuel. Betuel sumai anana Nahor, ipalaahirina Milka.' Iaku uka kupakanaakea singkaru i angona tee simbi i limana. ");
INSERT INTO wlo_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Kasiimpomo kusuju kusomba tee kupuji KAWASANA OPU, Aulataʼalana opuku Ibrahim motondaaku i dhala mototuu to kuala anana bhawine witinaina opuku to anana. ");
INSERT INTO wlo_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Sii-sii ande ingkomiu bheususuaka kaasimiu molagina i opuku, paumbaaku, mamudhaakana kumataua bhekupewau opea.\" ");
INSERT INTO wlo_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Laban tee Betuel alawanimo, \"Roonamo bhari-bharia sii aminaaka i KAWASANA OPU, ingkami inda amembali tapogauaka opeopea. ");
INSERT INTO wlo_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Kamatea, Ribka dhaangia i aroamu. Bhawamea alingka, inda apokia incia amembali bhawinena anana opumu sumai mboomo ifirimaniakana KAWASANA OPU.\" ");
INSERT INTO wlo_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Sarangona pogau incia sumai, bhatuana Ibrahim asujumo asomba i KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Kasiimpo incia apalimbamo manga bulawana tee pera ajoana, tee uka manga pakeana. Incia adhawuakea bhari-bharia sumai to Ribka tee adhawuakea uka manga bara mokoharagaa i witinaina umane tee inana. ");
INSERT INTO wlo_vpl VALUES ("GN24_54a","002_24_54a","GEN","24","54a","54a","Sapadhana incia sumai, incia apobhawamo tee manga mia akande tee asumpu, kasiimpomo apomalo iwe sumai. ");
INSERT INTO wlo_vpl VALUES ("GN24_54b","002_24_54b","GEN","24","54b","54b","Wakutuuna manga incia abhangu saeona mpuu, apogaumo bhatua sumai, \"Kuposangapo kumbuli i opuku.\" ");
INSERT INTO wlo_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Maka manga umane witinaina Ribka tee inana apogaumo, \"Inda apokia anana bhawine sii amboorepo tee ingkami sakura-kurana sapulu eopo uka, kasiimpo incia amembalimo alingka.\" ");
INSERT INTO wlo_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Apogaumo bhatua sumai i manga incia, \"Bholimo utaangiaku. KAWASANA OPU padhamo apewau lingkaaku akohasili jadi kuposangapo kumbuli i opuku.\" ");
INSERT INTO wlo_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Lawanimo manga, \"Ingkami bhetakemba anana bhawine sumai tee taabhakia lausaka i incia.\" ");
INSERT INTO wlo_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Kasiimpomo manga akembamo Ribka tee aabhakia, \"Uunda buaka ulingka pobhawa tee mia incia sii?\" Lawanina, \"Kuunda.\" ");
INSERT INTO wlo_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Sumaimo manga incia aundaakamo Ribka apobhawa tee mia mopadudua tee modhambaakea wakutuu amaidhiidhi, alingka apobhawa tee bhatuana Ibrahim tee manga miana. ");
INSERT INTO wlo_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Manga incia aemani barakati to Ribka tee apogaumo i incia, \"Witinaimami, sio-siomo siwulumu bheamembali jutana mia, tee sio-siomo siwulumu auncuramiki bhambana lawana manga musuna.\" ");
INSERT INTO wlo_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Kasiimpomo Ribka tee manga bhatuana bhawine amakanumo tee asawimo i manga untana. Manga incia alingka aose bhatuana Ibrahim sumai. ");
INSERT INTO wlo_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Tangasaana incia sumai, Ishak aumba minaaka i wetana sumu Lahai-Roi. Incia amboore i Tana Negeb. ");
INSERT INTO wlo_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Amakasumo konowia, Ishak alimba aʼamala i inawu. Tangasaana aʼamala, incia apatindamo potontona tee atilikia, atiumbamo pia-pia mbaa unta aumba. ");
INSERT INTO wlo_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ribka uka apatindamo potontona, tee wakutuuna incia akamata Ishak, asapomo incia minaaka i untana, ");
INSERT INTO wlo_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","kasiimpomo aabha i bhatua sumai, \"Incema umane motangasaana alingka i inawu sumai apasari i ingkita?\" Alawanimo bhatua sumai, \"Inciamo opuku.\" Kasiimpo Ribka aalamo salendana tee atutubhiaka karona. ");
INSERT INTO wlo_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Bhatua sumai apetulatulaakamea i Ishak sagala hali mopadhana ipewauna. ");
INSERT INTO wlo_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Sapadhana incia sumai, Ishak abhawamo Ribka i nuncana kemana Sarah, inana, tee akawiakamea. Ribka amembalimo bhawinena, tee Ishak amaasiakea. Sumaimo, atolancaumo Ishak samatena inana. ");
INSERT INTO wlo_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Ibrahim aalamo samia bhawine uka sarona Ketura. ");
INSERT INTO wlo_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ketura apalaahirimo to incia Zimran, Yoksan, Medan, Midian, Isbak, tee Suah. ");
INSERT INTO wlo_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yoksan akoanaakamo Syeba tee Dedan. Manga siwuluna Dedan sumai miana Asyur, miana Letus, tee miana Leum. ");
INSERT INTO wlo_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Manga anana Midian sumai Efa, Efer, Henokh, Abida, tee Eldaa. Siitumo bhari-bharia siwuluna Ketura. ");
INSERT INTO wlo_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Ibrahim adhawuakea sagala giu pewauana to Ishak, ");
INSERT INTO wlo_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","maka i manga anana ipotibhaakana minaaka i manga maruena, Ibrahim tangkanamo adhawuaka pia-pia angu kadhawu. Wakutuu incia dhaangiapo adhadhi, manga incia atumpua abholi Ishak, anana, alingka i weta i timbu, i Tana Timbu. ");
INSERT INTO wlo_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Ibrahim akawamo umuruna 175 tao. ");
INSERT INTO wlo_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Sapadhana incia sumai, incia ailamo poinuncana tee amatemo wakutuu amancuanamo, akodhadhimo mpuu, tee bhaana akouwamo, incia aromusakea tee kaomuna i alamuna mia mate. ");
INSERT INTO wlo_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Manga anana, siitumo Ishak tee Ismail, akoburua i nuncana lia Makhpela i inawu Efron bin Zoar, miana Het, modhaangiana i wetana timbu Mamre. ");
INSERT INTO wlo_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Inawu sumai aalia Ibrahim i piamo itu minaaka i miana Het. Iwe sumai Ibrahim akoburua tee Sarah, bhawinena. ");
INSERT INTO wlo_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Samatena Ibrahim, Aulataʼala abarakati Ishak, anana. Ishak amboore i saripina sumu Lahai-Roi. ");
INSERT INTO wlo_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Siimo siwuluna Ismail, anana Ibrahim ipalaahirina Hajar, samia bhawine Mesir momembalina bhatuana Sarah. ");
INSERT INTO wlo_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Siimo sarona manga anana Ismail mboomo tulatulana kalaahiriana: Nebayot, ana tumpena Ismail, kasiimpo Kedar, Adbeel, Mibsam, ");
INSERT INTO wlo_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misma, Duma, Masa, ");
INSERT INTO wlo_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Tema, Yetur, Nafis, tee Kedma. ");
INSERT INTO wlo_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Sumaimo sapulu rua mia anana Ismail tee sumbesumbere amembali raja kaomuna. Manga incia adhawuakea sarona karona to asarongiaka manga kampo tee tampa pakaroana kemana manga. ");
INSERT INTO wlo_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismail akawamo umuruna 137 tao. Sapadhana incia sumai ailamo poinuncana tee amate, kasiimpomo aromusakea tee kaomuna i alamuna mia mate. ");
INSERT INTO wlo_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Manga kaomuna Ismail amboore i lipu minaaka i Hawila sakawana i Syur modhaangiana i sawetana timbuna Mesir arope i Asyur. Maka manga siwuluna Ismail sii inda amembali amboore apomalape. ");
INSERT INTO wlo_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Siimo siwuluna Ishak, anana Ibrahim. Ibrahim akoanaakamo Ishak. ");
INSERT INTO wlo_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Ishak akoʼumurumo 40 tao wakutuu incia akobhawineaka Ribka. Ribka sumai anana Betuel, miana Aram minaaka i Padan-Aram. Ribka uka witinaina bhawine Laban, miana Aram sumai. ");
INSERT INTO wlo_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Ishak adoʼamo i KAWASANA OPU to bhawinena, sababuna bhawinena sumai akomba. KAWASANA OPU atarimaia doʼana, kasiimpomo abhawa-bhawamo Ribka, bhawinena. ");
INSERT INTO wlo_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Maka, manga anana apojujulaka i nuncana kadhumana, saanampuu onina, \"Pokia hali incia sii akangkanaiaku?\" Kasiimpomo alingkamo incia adoʼa i KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Firimanina KAWASANA OPU i incia, \"Rua angu lipu dhaangia i nuncana kadhumamu, tee rua angu lipu bheapogaa minaaka i kadhumamu. Saangu lipu bhealabhi kakaana minaaka i mosagaanana, tee anana tumpena bheapabhatuaia anana kaepu.\" ");
INSERT INTO wlo_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Sakawana eona to apalaahiri, garaaka atotuu dhaangia ana rapi i nuncana kadhumana. ");
INSERT INTO wlo_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Anana bhaa-bhaana alimbamo waranaana maleʼi, saangua badana mboomo juba mokobulu, sababuna itu incia asarongiakea Esau. ");
INSERT INTO wlo_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Kasiimpo alimbamo andina. Limana akeni korontunguna Esau, saanampuu incia asarongiakea Yakub. Ishak akoʼumurumo 60 tao wakutuu manga incia apalaahiria. ");
INSERT INTO wlo_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Rua-rua miaia anana sumai sahandana amaoge. Esau samia momakidhana pekaose tee asanaa amboore i koo, maka Yakub samia motanangina tee asanaa amboore i nuncana kema. ");
INSERT INTO wlo_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Ishak amaasiaka Esau, roonamo incia sadiamo akande hasilina kaosena. Maka Ribka amaasiaka Yakub. ");
INSERT INTO wlo_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Saangu wakutuu, Yakub tangasaana amanasu, aumbamo Esau amaluteakamo kaara minaaka i koo. ");
INSERT INTO wlo_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Pogauna Esau i Yakub, \"Dhawuaku kukande saidhe kacanggore momaleʼina itu, roonamo iaku kumaluteakamo kaara.\" Siitumo sababuna incia asarongiakea Edom. ");
INSERT INTO wlo_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Pogaumo Yakub, \"Asopea porikana i iaku haku katumpeamu.\" ");
INSERT INTO wlo_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Pogaumo Esau, \"Iaku bhekumateakamo kaara. Opea gunana haku katumpea sumai to iaku?\" ");
INSERT INTO wlo_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Pogaumo Yakub, \"Sumpamo porikana i iaku.\" Sabutuna asumpamo i incia tee aasomea haku katumpeana i Yakub. ");
INSERT INTO wlo_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Kasiimpomo Yakub adhawuakamo Esau roti tee kanasuna kacanggore maleʼi sumai. Esau akande tee asumpu, kasiimpo abhangu tee alingka. Mboomo sumai o Esau apandaʼentea haku katumpeana. ");
INSERT INTO wlo_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Pia-pia wakutuu kangengena amembalimo kasukarana kaara i lipu incia sumai, aposala tee kasukarana kaara bhaa-bhaana momembalina i zamanina Ibrahim. Sabutuna, alingkamo Ishak i Gerar to apoaro i Abimelekh, rajana miana Filistin. ");
INSERT INTO wlo_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Kasiimpomo, KAWASANA OPU apatiumbaakamo karona i incia tee afirimanimo, \"Bholimo ulingka i Mesir. Bhekususuakako tampa iapai ingkoo tabeana umboore. ");
INSERT INTO wlo_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Mbooremo i lipu incia sii mboomo dhaga, sumaimo Iaku kupobhawa tee kubarakatiko, roonamo i ingkoo tee i manga siwulumu bhekudhawuakea bhari-bharia lipu incia sii. Iaku bhekupasahamea sumpaku ibhoasakaku i Ibrahim, amamu. ");
INSERT INTO wlo_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Iaku bhekupekabharia siwulumu mboomo kalipopo i laiana. Iaku bhekudhawuakea bhari-bharia lipu sii i manga siwulumu, tee alaloi siwulumu bhari-bharia lipu i alamu bheapotibhaaka barakati, ");
INSERT INTO wlo_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","roonamo Ibrahim padhamo ataʼati firimaniku tee akeniakea matangka pogauku, manga parintaku, manga katotapuku, tee manga hukumuku.\" ");
INSERT INTO wlo_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Sabutuna, ambooremo Ishak i Gerar. ");
INSERT INTO wlo_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Wakutuu manga mia i tampa incia sumai abhaaka to bhawinena, incia alawani, \"Incia witinaiku,\" roonamo incia amaeka apogauaka, \"Incia bhawineku.\" Fikirina, \"Ancosala manga mia i tampa incia sii apekamateaku roonamo Ribka, sababuna amakesa rouna.\" ");
INSERT INTO wlo_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Maka, saangu wakutuu, rajana miana Filistin Abimelekh tangasaana apentiro minaaka i bhalo-bhalo to apekamakamata, saanampuu atokidhamo akamata Ishak tangasaana apoiki apokokopu tee Ribka, bhawinena. Hali incia sumai amembali wakutuuna Ishak amboore iwe sumai pia-pia wakutuu kangengena. ");
INSERT INTO wlo_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Sumaimo, Abimelekh akemba Ishak tee apogau, \"Garaaka incia bhawinemu! Tuaapa membali upogauakea, \"Incia witinaiku?\" Lawanimo Ishak i incia, \"Roonamo fikiriku, 'Ancosala kumate ande dhaangia mia mopeeluna bhawineku.'\" ");
INSERT INTO wlo_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Apogaumo Abimelekh uka, \"Opea mopadhana ipewaumu to ingkami sii? Mamudha mpuu sala samia minaaka i lipu incia sii akole tee bhawinemu. Ande mboo sumai, ingkoo mosababuakana ingkami tasala.\" ");
INSERT INTO wlo_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Kasiimpo Abimelekh adhawumo parintana i saangua lipu sumai, pogauna, \"Incema modhingkuna mia incia sii atawa bhawinena, incia dhaanamo atohukumu mate.\" ");
INSERT INTO wlo_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Ishak ahewimo wine i lipu incia sumai, tee i nuncana tao incia sumai uka incia apotibhaakamo hasili saatu kali lipa, roonamo KAWASANA OPU abarakatia. ");
INSERT INTO wlo_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Mia incia sumai arangkaeamo tee ahanda karangkaeana, sabutuna arangkaeamo mpuu. ");
INSERT INTO wlo_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Incia dhaangia manga gulumana bhembe, dumba, tee sapi, tee bhari bhatua, sabutuna miana Filistin sumai akaura-uramo i incia. ");
INSERT INTO wlo_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Wakutuu Ibrahim, o amana Ishak dhaangia adhadhi, incia tee manga bhatuana aseli pia-pia angu sumu. Maka, amangengemo manga miana Filistin atutubhia bhari-bharia sumu tee kabumbuna tana. ");
INSERT INTO wlo_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Kasiimpomo, Abimelekh apogaumo i Ishak, \"Lingkamo minaaka i ingkami, roonamo sii-sii umembalimo umakaa minaaka i ingkami.\" ");
INSERT INTO wlo_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Sabutuna, alingkamo Ishak minaaka iwe sumai. Apakaromo kemana i Mbolongana Gerar, kasiimpomo amboore iwe sumai. ");
INSERT INTO wlo_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Kasiimpomo Ishak aselia pendua manga sumu iselina i zamanina Ibrahim, amana, roonamo miana Filistin padhamo atutubhia sapadhana matena Ibrahim. Asarongiakea manga sumu sumai mboomo mopadhana asarongiakea amana. ");
INSERT INTO wlo_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Maka roonamo, wakutuu manga bhatuana Ishak aseli mbolonga sumai tee apotibhaaka iwe sumai saangu matana uwe mokalua-luana uwena ");
INSERT INTO wlo_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","apogeramo manga gembalana Gerar tee manga gembalana Ishak. Pogauna manga incia, \"Uwe incia sii pewauamami!\" Sumaimo Ishak asarongiakea sumu incia sumai Esek, roonamo manga mia sumai apogera tee incia. ");
INSERT INTO wlo_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Manga incia aselimo uka sumu mosagaanana, maka manga mia incia sumai apogeraakea uka. Sabutuna Ishak asarongiakea sumu sumai Sitna. ");
INSERT INTO wlo_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Ishak apindamo minaaka iwe sumai kasiimpo aselimo sumu mosagaanana, maka wakutuu incia sii manga mia inda apogeraakea. Jadi incia asarongiakea sumu incia sumai Rehobot, roonamo pogauna, \"Sii-sii KAWASANA OPU mangadhawuaka kalalesa to ingkita, mamudhaakana ingkita membali takoana-ana tee takoopu-opua i lipu incia sii.\" ");
INSERT INTO wlo_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Minaaka iwe sumai incia alingka i Bersyeba. ");
INSERT INTO wlo_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Kasiimpo i wakutuuna malo sumai KAWASANA OPU apatiumbaakamo karona tee afirimani, \"Iakumo Aulataʼalana Ibrahim, amamu. Bholi umaeka roonamo kupobhawa tee ingkoo. Iaku bhekubarakatiko tee kupekabharia siwulumu roonamo Ibrahim, bhatuaku sumai.\" ");
INSERT INTO wlo_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Sapadhana incia sumai, Ishak abhangumo tampana tunuana kurubani iwe sumai tee agoraaka sarona KAWASANA OPU. Incia apakaro kemana iwe sumai, kasiimpo manga bhatuana aseli saangu sumu iwe sumai. ");
INSERT INTO wlo_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Saangu wakutuu aumbamo Abimelekh i incia minaaka i Gerar apobhawa tee Ahuzat, sabhangkana, tee Pikhol, kapala suludaduna. ");
INSERT INTO wlo_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Apogaumo Ishak i manga incia, \"Pokia ingkomiu uumba upokawaakaaku sii-sii, garaaka i piamo itu ingkomiu umusuaku tee upadhencuaku minaaka i lipumiu?\" ");
INSERT INTO wlo_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Lawanimo manga incia, \"Ingkami totuu-totuu padhamo takamatea ande KAWASANA OPU apobhawa tee ingkoo. Jadi, ingkami tafikiri, \"Samalapena dhaangia pojanjia amani i tanga-tangata, sumaimo i tanga-tangamami tee ingkoo. Mai tabhoke pojanjia i tanga-tangata. ");
INSERT INTO wlo_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Janjimo ande ingkoo inda bheupewau madhaki i ingkami, mboomo ingkami i piamo itu inda takia-kiako sainamo sadiamo tapewau malape tee tatumpuko ulingka tee kasanaa. Sii-sii uka KAWASANA OPU abarakatiko.\" ");
INSERT INTO wlo_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Ishak apadhaangiamo kakemba to manga incia, kasiimpo manga akande tee asumpu. ");
INSERT INTO wlo_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Samainawana manga incia abhangumo samalo-malona, kasiimpo asumpamo samia tee mosagaanana. Sapadhana incia sumai, Ishak aundaakamea manga alingka, manga incia uka alingka abholimea tee kasanaa. ");
INSERT INTO wlo_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","I eo incia sumai uka manga bhatuana Ishak aumba apaumbaaka incia to sumu mopadhana iselina manga. Pogauna manga, \"Ingkami tapokawaakamo uwe!\" ");
INSERT INTO wlo_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Ishak asarongiakea sumu sumai Syeba. Siitumo sababuna lipu incia sumai asarongia Bersyeba sampe eo incia sii. ");
INSERT INTO wlo_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Wakutuu Esau akoʼumuru 40 tao incia akobhawineakamo Yudit binti Beeri, miana Het, tee Basmat binti Elon, miana Het. ");
INSERT INTO wlo_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Rua miaia bhawinena sumai aumbaaka kapiina inca i ngangarandana Ishak tee Ribka. ");
INSERT INTO wlo_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Saangu wakutuu, Ishak amancuanamo tee amarawumo matana sabutuna indamo apokamata, agoraakamo Esau, o anana tumpena. Pogauna i incia, \"Anaku.\" Lawanina, \"Umbe, Uma.\" ");
INSERT INTO wlo_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Apogaumo Ishak, \"Perangoiakupo, iaku sii kumancuanamo. Iaku inda kumataua naepia eona mateaku.\" ");
INSERT INTO wlo_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Sii-sii, alamea ewangamu, sumaimo dhingkanana panamu tee matana panamu. Lingkamo i koo tee pekaoseakaaku sambaa binata. ");
INSERT INTO wlo_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Karajaakaaku kinande mambaka, mboomo ipeeluku, kasiimpo bhawaakaaku mamudhaakana bhekukandea tee mamudhaakana kuemaniakako barakati wakutuuna indapo kumate.\" ");
INSERT INTO wlo_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ribka arangoa wakutuu Ishak apogau i Esau, anana. Kasiimpomo, wakutuuna Esau alingka i inawu apeelo sambaa binata to apambulia, ");
INSERT INTO wlo_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","apogaumo Ribka tee Yakub, anana, \"Mataua, padhamo kurangoa amamu apogau tee Esau, akamu. Onina, ");
INSERT INTO wlo_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","'Bhawaakaakumo sambaa binata iosemu tee karajaakaaku kinande momambaka. Bhekukandea, mamudhaakana kuemaniakako barakati i aroana KAWASANA OPU wakutuuna indapo kumate.' ");
INSERT INTO wlo_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Sumaimo sii-sii anaku, rangoa manga pogauku tee pewaua opea iparintangiakaku i ingkoo. ");
INSERT INTO wlo_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Lingkamo i tampana bhembe tee dumbata, alamo to iaku rua mbaa anana bhembe momalape minaaka iwe sumai. Iaku bhekunasua kupamembalia kinande momambaka peeluana amamu. ");
INSERT INTO wlo_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Kasiimpomo ingkoo tabeana bhawea i amamu to akandea, mamudhaakana aemaniakako barakati wakutuuna incia indapo amate.\" ");
INSERT INTO wlo_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Kasiimpo apogaumo Yakub i Ribka, \"E Ina, akaku Esau akobulu badana, sainamo iaku inda akobulu. ");
INSERT INTO wlo_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Ancosala amaku aperereaku, tee bheaabhiaku mboomo samia pande gau-gau, aipomo incia mencuana aemaniakaaku barakati maka atundaaku.\" ");
INSERT INTO wlo_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Maka inana apogau i incia, \"Bholi umaeka anaku, iakumo motanggona katunda sumai. Soo urangomo pogauku, lingkamo alea manga bhembe sumai.\" ");
INSERT INTO wlo_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Sumaimo alingkamo Yakub aala rua mbaa anana bhembe tee abhawea i inana. Kasiimpomo inana anasumo kinande momambaka peeluana amana. ");
INSERT INTO wlo_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Sapadhana incia sumai, Ribka aalamo pakeana momangadana Esau, ana tumpena, idhikana i bhanuana. Kasiimpomo apakanaakea i Yakub, ana kaepuna. ");
INSERT INTO wlo_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Kasiimpomo, abhewengia rua mbalia limana tee kulina anana bhembe i saao tee apewaua mboo sumai uka i weta i bhorokona momararona. ");
INSERT INTO wlo_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Sapadhana incia sumai Ribka akarajaa roti tee kinande momambaka, kasiimpo apasarakaakamea i Yakub. ");
INSERT INTO wlo_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Mboo sumaimo Yakub aumbati amana tee apogau, \"Uma!\" Alawani Ishak, \"Umbe. Incema buaka ingkoo, Esau atawa Yakub?\" ");
INSERT INTO wlo_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Pogauna Yakub i amana, \"Iaku Esau, tumpemu Uma. Iaku padhamo kupewaua mboomo isameaakamu Uma. Bhangumo tee uncuramo, kandemo dagi padha ioseku mamudhaakana uemaniakaaku barakati.\" ");
INSERT INTO wlo_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Kasiimpo Ishak apogaumo i anana sumai, \"Amadhei mpuu ingkoo upotibhaakea, anaku!\" Lawanina, \"Sababuna KAWASANA OPU, Aulataʼalamu, motulungiaku.\" ");
INSERT INTO wlo_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Kasiimpo apogaumo Ishak i Yakub, \"Maimo pekakasu mamudhaakana amembali kuperereko. Atotuu buaka ingkoo Esau?\" ");
INSERT INTO wlo_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yakub apekakasumo i Ishak o amana, kasiimpo amana sumai apereremea tee apogau, \"Suaramu mboomo suarana Yakub, maka limamu mboomo limana Esau.\" ");
INSERT INTO wlo_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Ishak inda amataua, roonamo rua mbalia limana akobulu mboomo limana Esau, akana. Jadi, Ishak bheaemaniakamea barakati to incia. ");
INSERT INTO wlo_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Maka, incia dhaangia aabha, \"Atotuu ingkoo sii anaku Esau?\" Lawanina, \"Umbe.\" ");
INSERT INTO wlo_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Kasiimpo apogaumo Ishak, \"Pekakasua kinande sumai i iaku, mamudhaakana bhekukandea dagi kaose inasumu anaku, mamudhaakana kuemaniakako barakati.\" Jadi apekakasumea kinande sumai i amana, kasiimpomo akandea, abhawaakea uka angguru to incia, kasiimpomo asumpua. ");
INSERT INTO wlo_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Apogaumo Ishak, amana, i incia, \"Maimo pekakasu tee ikiaku, anaku.\" ");
INSERT INTO wlo_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Yakub apekakasu tee aikimo amana. Wakutuuna Ishak abhou pakeana Yakub, aemaniakamea barakati to incia, kooni: \"Satotuuna bhouna anaku sii mboomo bhouna inawu ibarakatina KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Sio-siomo Aulataʼala bheadhawuko alo minaaka i laiana, tee manga tampa mosuburu i alamu, tee gandum tee uwena angguru ataralabhi-labhi. ");
INSERT INTO wlo_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Sio-siomo manga lipu amembali bhatuamu, tee manga lipu asuju i aroamu. Maasangia umembalimo opu to manga witinaimu, tee sio-siomo manga anana inamu asuju i ingkoo. Atotundamo mia motundako, tee abarakatimea mia moemaniakana kabarakati to ingkoo.\" ");
INSERT INTO wlo_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Sapadhana Ishak aemaniaka barakati to Yakub, tee siimpo mpuu Yakub alimba abholi Ishak, amana, aumbamo Esau, akana, minaaka apekaose. ");
INSERT INTO wlo_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Incia uka anasu kinande momambaka, kasiimpo abhawea i amana. Pogauna i amana, \"Bhangumo, Uma, kandemo hasilina kaosena anamu, mamudhaakana uemaniakaaku barakati.\" ");
INSERT INTO wlo_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Aabhamo Ishak, \"Incema buaka ingkoo?\" Lawanina, \"Iaku o ana tumpemu, Esau.\" ");
INSERT INTO wlo_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Sarangona pogau incia sumai, arengkumo Ishak roonamo atokidha mpuu. Pogauna, \"Incema buaka incia, mopekaosena binata i saao, kasiimpo abhawaakaaku? Iaku padhamo kukandea bhari-bharia wakutuuna ingkoo indapo uumba tee padhamo kuemaniakea barakati to incia. Umbe, inciamo mia motobarakati!\" ");
INSERT INTO wlo_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Wakutuuna Esau arango pogauna amana sumai, atangimo incia tee suara makaa tee kaporona inca. Pogauna i amana, \"Emaniakaaku barakati uka to iaku, Uma!\" ");
INSERT INTO wlo_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Pogauna amana, \"Andimu aumbamo tee kagau-gauna tee padhamo aalea barakati to ingkoo.\" ");
INSERT INTO wlo_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Pogaumo Esau, \"Incia alaenga akosaroaka Yakub! Incia padhamo agau-gauaku rua mpearomo. I piamo itu haku katumpeaku aalea, tee kamatea, sii-sii aalea uka barakati to iaku.\" Pogauna uka, \"Buakana Uma indamo udhika barakati mosagaanana to iaku?\" ");
INSERT INTO wlo_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Lawanina Ishak i Esau, \"Satotuuna, padhamo kupatotapuaka incia amembali opumu, tee bhari-bharia witinaina padhamo kudhawuaka i incia amembali bhatuana. Gandum tee uwena angguru padhamo kudhawuaka incia. Jadi, opea uka momembalina kupewau to ingkoo, anaku?\" ");
INSERT INTO wlo_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Pogaumo Esau i amana \"Tangkanamo saangu barakati sumai buaka modhaangiana i ingkoo, Uma? Emaniakaaku barakati uka, Uma!\" Kasiimpo atangimo Esau tee suara makaa. ");
INSERT INTO wlo_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Lawanimo Ishak i incia, \"Satotuuna, tampa mbooresamu bheamaridho minaaka i manga tampa mosuburuna i alamu tee alo mosapona minaaka i laiana i bhawo. ");
INSERT INTO wlo_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Ingkoo bheudhadhi minaaka i hancumu, maka ingkoo bheumembali bhatuana andimu. Maka bheamembali naile itu, ande ingkoo umembali umakaa tee uewa, bheubebasi minaaka i kuasana andimu.\" ");
INSERT INTO wlo_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esau adhika-dhikamo kapiina incana i Yakub roonamo barakati mopadhana iemaniakana amana to incia. Pogaumo Esau i ngangarandana, \"O eona amaku bheamate amakasu tee ingkita bhetasukaramo. Sapadhana incia sumaimo, iaku bhekupekamate Yakub, o andiku.\" ");
INSERT INTO wlo_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Maka dhaangia o mia mopaumbana Ribka tee opea ipogauakana Esau, anana tumpena sumai. Sabutuna atumpumo mia akemba Yakub, anana kaepuna, kasiimpo apogau tee incia, \"Mataumea, akamu Esau ahiburu karona tee ahaejati to apekamateko. ");
INSERT INTO wlo_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Sii-sii, anaku, rangomea pogauku. Palaimo pekadhei i tampana Laban witinaiku, i Haran. ");
INSERT INTO wlo_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Mbooremo tee incia kangengena pia-pia wakutuu, sampe aunto amarana akamu i ingkoo ");
INSERT INTO wlo_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","tee ngangarandana amagari pendua tee amalinguakamea opea mopadhana ipewaumu i incia. Dhaampomo iaku bhekutumpu mia to alingkaisiko minaaka iwe sumako. Iaku kumendeu kukailanga rua mia anaku i nuncana saeo.\" ");
INSERT INTO wlo_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Kasiimpo Ribka apogau i Ishak, \"Iaku kupangantamo kudhadhi roonamo manga bhawinena Esau, miana Het sumai. Ande Yakub uka akobhawineaka samia kabuabua miana Het mboomo manga incia sumai, samia momboorena i tana sii, salabhina uka kumatemo.\" ");
INSERT INTO wlo_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Rampaakanamo sumai, Ishak akembamo Yakub. Incia aemaniakea barakati tee asamea i incia, \"Ingkoo inda umembali ukobhawineaka sala samia minaaka i tanga-tangana bhawine Kanaan. ");
INSERT INTO wlo_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Makanumo, lingkamo i Padan-Aram, i bhanuana Betuel, amana inamu, tee alamo minaaka iwe sumai samia bhawine to ingkoo minaaka i manga anana Laban, witinaina inamu. ");
INSERT INTO wlo_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Sio-siomo Aulataʼala Mokokuasana abarakati ingkoo, apamembali ingkoo koana-ana koopu-opua, tee apekabharia siwulumu, sabutuna ingkoo umembali opuana bhari lipu. ");
INSERT INTO wlo_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Sio-siomo Incia adhawuakako barakatina Ibrahim i ingkoo tee i manga siwulumu, sabutuna ingkoo utarima lipu i tampa ingkoo umboore mboomo dhaga to tinaurakamu, siitumo lipu mopadhana idhawuakana Aulataʼala i Ibrahim.\" ");
INSERT INTO wlo_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Kasiimpo Ishak arambasaka lingkaana Yakub. Kasiimpomo Yusuf alingka i Padan-Aram, i Laban. Laban sumai anana Betuel tee witinaina Ribka, o inana Yakub tee Esau. ");
INSERT INTO wlo_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esau akamatea ande Ishak padhamo aemaniakea barakati to Yakub tee atumpumea alingka i Padan-Aram to aala bhawine minaaka iwe sumai. Esau uka akamatea Ishak asamea i Yusuf wakutuu incia aemaniakea barakati, \"Bholi ukobhawineaka samia kabuabua miana Kanaan,\" ");
INSERT INTO wlo_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","tee ande Yakub ataʼati pogauna amana tee inana, kasiimpo alingka i Padan-Aram. ");
INSERT INTO wlo_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Sabutuna, asadaramo Esau ande Ishak, amana, inda apeelua manga bhawinena miana Kanaan. ");
INSERT INTO wlo_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Rampaakanamo sumai alingkamo Esau i Ismail, kasiimpo aala Mahalat amembali bhawinena i sambalina rua mia bhawinena mosagaanana. Mahalat satotuuna andina Nebayot, anana Ismail bin Ibrahim. ");
INSERT INTO wlo_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yakub abholi Bersyeba tee alingka i Haran. ");
INSERT INTO wlo_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Incia akawa i saangu tampa, kasiimpo akole iwe sumai roonamo matanaeo asoomo. Incia aala saangu bhatu modhaangiana iwe sumai to apamembalia polango, tee akolemo iwe sumai. ");
INSERT INTO wlo_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Kasiimpo incia uka apongipi. Atokamatamo saangu odha atopakakaro i alamu tee lolona akawa i laiana, kasiimpo manga malaaʼekatina Aulataʼala asapo pene i odha sumai. ");
INSERT INTO wlo_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","I nuncana pongipina sumai, Yakub akamatamo KAWASANA OPU akakaro i saripina tee afirimani, \"Iakumo KAWASANA OPU, Aulataʼalana Ibrahim, opuamu, tee Aulataʼalana Ishak. Tana tampa upotidhole sii bhekudhawuaka to ingkoo tee i siwulumu. ");
INSERT INTO wlo_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Siwulumu bheamembali mboomo ngawuna tana kabharina, tee ingkoo bheujulu i bhara, i timbu, i napa, tee i salata. Rampaakanamo ingkoo tee siwulumu bhari-bharia lipu i alamu bheapotibhaaka barakati. ");
INSERT INTO wlo_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Satotuuna Iaku kupobhawa tee ingkoo tee bhekujaganiko iapai uka ulingka. Iaku bhekubhawa ingkoo umbuli i lipu sii, roonamo Iaku inda bhekubholiko sampe Iaku kukarajaaia opea mopadhana ijanjiakaku to ingkoo.\" ");
INSERT INTO wlo_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Kasiimpomo abhangumo Yakub minaaka i kolena, pogauna, \"Satotuuna, KAWASANA OPU aumba i tampa incia sii tee iaku inda kumataua.\" ");
INSERT INTO wlo_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Incia amaekamo kasiimpo apogau, \"Akokabarakati mpuu tampa incia sii! Sii tantumo Baitulla! Sii bhamba lawana sorogaa!\" ");
INSERT INTO wlo_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Samainawana Yakub abhangumo saeona. Aalamea bhatu ipakena to polango, kasiimpo apakaromea amembali saangu tugu. Sapadhana sumai alaliakamea mina i bhawona. ");
INSERT INTO wlo_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Incia asarongiakea tampa incia sumai Bait-El; i piamo itu sarona kota sumai Lus. ");
INSERT INTO wlo_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Kasiimpomo Yakub atolaumo onina, kooni, \"Ande KAWASANA OPU apobhawa tee iaku tee ajaganiaku i dhala ilaloiku sii, adhawuaku kinande to kukandeaka tee pakea to kupakea, ");
INSERT INTO wlo_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","mamudhaakana iaku kumbuli tee kasalaamati i bhanuana amaku, siitumo KAWASANA OPU bheamembali Aulataʼalaku, ");
INSERT INTO wlo_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","tee bhatu ipakaroku mboo tugu sii bheamembali Baitulla. Iaku bhekupasombaaka i Ingkoo sapersapulu minaaka i bhari-bharia idhawuakamu i iaku.\" ");
INSERT INTO wlo_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Sapadhana sumai Yakub abhosemo minaaka iwe sumai tee alingka i Tana Mesopotamia, i weta i timbuna Kanaan, o lipuna inana. ");
INSERT INTO wlo_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Wakutuuna incia akamakamata kadhaangia i saripina, akamatamo dhaangia saangu sumu i tana mokorumpu. I saripina sumu sumai dhaangia talu gulumana bhembe dumba tangasaana apotidhole, roonamo minaaka iwe sumaimo mia kananeana adhawu sumpu kadhambaakana. Dhaangia saangu bhatu maoge motutubhina ngangana sumu sumai. ");
INSERT INTO wlo_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Ande bhari-bharia gulumana kadhambaaka padhamo aromusakea iwe sumai, sumaimo manga mojaganina kadhambaaka bheapadhole bhatu sumai minaaka i ngangana sumu kasiimpo adhawua asumpu gulumana bhembe dumbana manga. Sapadhana sumai, bhatu bheapambulimea uka i ngangana sumu sumai. ");
INSERT INTO wlo_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yakub aabhamo i manga mia incia sumai, \"Manga witinaiku minaaka iapai ingkomiu sii?\" Lawanimo manga incia, \"Ingkami sii taminaaka i Haran.\" ");
INSERT INTO wlo_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Yakub aabha uka i manga incia, \"Buaka ingkomiu umataua o Laban, opuana Nahor? \"Alawanimo manga incia, \"Tamataua.\" ");
INSERT INTO wlo_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Yakub aabhamo uka i manga incia, \"Amalape buaka kadhaangiana?\" Lawanina manga incia, \"Amalape! Kamatea, kabuabua moumbana mowuluna bhembe dumbana sumaimo Rahel, o anana Laban!\" ");
INSERT INTO wlo_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Apogaumo Yakub, \"O eo indapo akonowia, indapo wakutuuna manga kadhambaakamiu uwulua ambuli i kanda. Jadi, dhawua asumpu bhembe dumba sumai, kasiimpomo uwulua pendua to apeelo kinandena.\" ");
INSERT INTO wlo_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Maka alawanimo manga incia, \"Inda. Ingkami inda amembali tadhawua asumpu bhembe dumba ande indapo bhari-bharia gulumana kadhambaaka aporomusaka. Kasiimpo atopadholemo bhatu minaaka i ngangana sumu tee tadhawumea asumpu kadhambaakamami.\" ");
INSERT INTO wlo_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Tangasaana manga incia apogau, aumbamo Rahel abhawa bhembe dumbana amana, roonamo incia mojaganina. ");
INSERT INTO wlo_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Yakub akamata Rahel, anana Laban o witinaina inana, awulu bhembe dumbana amana. Incia apekakasumo i Rahel, kasiimpo apadholemea bhatu minaaka i ngangana sumu sumai, tee adhawumo asumpu bhembe dumbana sumai. ");
INSERT INTO wlo_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Sapadhana sumai, incia aikimo Rahel tee atangi tee suara makaa. ");
INSERT INTO wlo_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Yakub apaumbamo Rahel ande incia o anana Ribka, witinaina amana. Saanampuu abuntulimo Rahel apaumba amana. ");
INSERT INTO wlo_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Sarangona lelena Yakub, pinoanana, sanampuu Laban abuntulimo apokawaakea, asakua tee aikia, kasiimpo abhawea apesua i bhanuana. Yakub apetulatulaakamo bhari-bharia hali momembalina to karona i Laban. ");
INSERT INTO wlo_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Pogaumo Laban i incia, \"Satotuuna ingkoo sadagi saraa tee iaku.\" Sumaimo, ambooremo Yakub tee incia sambula kangengena. ");
INSERT INTO wlo_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Kasiimpomo apogaumo Laban i Yakub \"Inda apesua akala ande ukarajaa i iaku inda tee ponambo soomo rampaakana ingkoo anana witinaiku. Paumbaakaaku opea molaengana to ponambomu.\" ");
INSERT INTO wlo_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Laban dhaangia rua mia anana bhawine; o tumpe sarona Lea tee kaepu sarona Rahel. ");
INSERT INTO wlo_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea akomata makesa, maka Rahel sumai amangada poningkarona tee amakesa rouna. ");
INSERT INTO wlo_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yakub asintai Rahel, sababuna sumai incia apogau, \"Kupeelu kukarajaa to ingkoo pitu tao kangengena to kupotibhaaka Rahel, ana kaepumu sumai.\" ");
INSERT INTO wlo_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Alawanimo Laban, \"Salabhina kudhawuaka incia to ingkoo tee aalea mia mosagaanana. Mbooremo tee iaku.\" ");
INSERT INTO wlo_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Kasiimpomo akarajaamo Yakub pitu tao kangengena to Rahel. Maka pitu tao sumai anamisia kabilanga pia-pia eomea rampaakanamo incia asintai Rahel sumai. ");
INSERT INTO wlo_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Sapadhana sumai apogaumo Yakub i Laban, \"Dhawuakaaku momembalina bhawineku sumai, sababuna henggana wakutuuku akawamo, mamudhaakana iaku bhekukawi tee incia.\" ");
INSERT INTO wlo_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Kasiimpomo Laban akembamo bhari-bharia mia i tampa incia sumai, tee apadhaangia kariaa kawia. ");
INSERT INTO wlo_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Maka wakutuuna malo sumai, Laban aalamo Lea, ana tumpena, mencuana Rahel, kasiimpomo abhawamea i Yakub. Sabutuna, Yakub uka aposaangumo tee incia. ");
INSERT INTO wlo_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Laban adhawuaka uka samia bhatuana bhawine o sarona Zilpa i Lea to apamembalia bhatuana. ");
INSERT INTO wlo_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Maka wakutuuna saeona atiumbamo, garaaka bhawine ikawiakana o Lea, mencuana Rahel! Kasiimpo apogaumo Yakub i Laban, \"Opea ipewaumu to iaku sii? Mboona to kupotibhaaka Rahel iaku kukarajaa to ingkoo? Pokia ingkoo ugau-gauaku?\" ");
INSERT INTO wlo_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Alawanimo Laban, \"Mencuana kananeana mia i tampamami apewau mboo sii: apakawi andina porikana kasiimpo akana. ");
INSERT INTO wlo_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Pamondoa porikana pitu eo kawiamu tee anaku sii. Sapadhana pitu eo sumai, bhekudhawuakako anaku samiana to ponambomu, somanamo ingkoo ukarajaa pitu taopo uka.\" ");
INSERT INTO wlo_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Sumaimo Yakub apewau mboo sumai; incia apamondoa pitu eo kawiana tee Lea, kasiimpomo Laban adhawuaka Rahel, o ana kaepuna sumai, i incia to apamembalia bhawinena. ");
INSERT INTO wlo_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Laban adhawuaka uka samia bhatuana bhawine o sarona Bilha i Rahel to apamembalia bhatuana. ");
INSERT INTO wlo_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yakub aposaangu tee Rahel uka, tee incia alabhi asintai Rahel minaaka i Lea. Mboomo sumai incia akarajaa uka i Laban pitu taopo uka. ");
INSERT INTO wlo_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Wakutuuna KAWASANA OPU akamata, ande Lea inda atosintai, abungkaleakea kadhumana, maka Rahel akomba. ");
INSERT INTO wlo_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lea abhawa-bhawamo, kasiimpo apalaahirimo samia ana umane, tee asarongiakea Ruben, sababuna pogauna, \"Satotuuna, KAWASANA OPU padhamo akamata kanarakaaku; sii-sii tantumo iaku bheasintaiaku umaneku.\" ");
INSERT INTO wlo_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Abhawa-bhawamo uka incia, kasiimpomo apalaahirimo samia anaana umane, sumaimo incia apogau, \"Satotuuna, KAWASANA OPU padhamo arangoa, ande iaku inda kusintaia, kasiimpo adhawuakamea uka ana sii i iaku.\" Sumaimo incia asarongiakea anana sumai Simeon. ");
INSERT INTO wlo_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Abhawa-bhawamo uka incia, kasiimpo apalaahirimo samia ana umane, maka incia apogau, \"Sii-sii incana umaneku bheatobhoke tee iaku, roonamo iaku padhamo kupalaahiri talu mia anana umane to incia.\" Sumaimo sababuna incia asarongiakea anana sumai Lewi. ");
INSERT INTO wlo_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Abhawa-bhawamo uka incia, kasiimpo apalaahirimo samia anana umane, sumaimo incia apogau, \"Sampearo sii bhekupuji i KAWASANA OPU.\" Siitumo sababuna incia asarongiakea anana sumai Yuda. Sapadhana incia sumai incia indamo apalaahiri uka. ");
INSERT INTO wlo_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Wakutuuna Rahel akamata ande incia inda apalaahiri anaana to Yakub, akaura-uramo incia tee akana, kasiimpo apogau i Yakub, \"Dhawuakaaku anaana; ande inda, taroakaakumo kumate.\" ");
INSERT INTO wlo_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Sumaimo Yakub aʼamaramo i Rahel onina, \"Iaku sii buaka Aulataʼala mojoliko ubhawa-bhawa?\" ");
INSERT INTO wlo_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Pogaumo Rahel, \"Siimo Bilha, bhatuaku. Kawiakea mamudhaakana apalaahiri anana kabholosiku mamudhaakana iaku uka amembali kukoana alaloi incia.\" ");
INSERT INTO wlo_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Sumaimo, apasarakaakamo Bilha, bhatuana, i Yakub to apamembalia bhawinena. Yakub uka aporomuakamea. ");
INSERT INTO wlo_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bilha abhawa-bhawamo, kasiimpo apalaahirimo samia anana umane. ");
INSERT INTO wlo_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Kasiimpomo Rahel apogaumo, \"Aulataʼala apewau adili tee iaku, tee aperangoimea iemaniku tee adhawuakaakumo samia anana umane.\" Sababuna sumai incia asarongiakea anaana sumai Dan. ");
INSERT INTO wlo_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Kasiimpomo Bilha, bhawine bhatuana Rahel sumai, abhawa-bhawamo pendua tee apalaahirimo to Yakub anaana umane katutunina tumpe. ");
INSERT INTO wlo_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Apogaumo Rahel, \"Iaku kuposaingimo mpuu tee akaku, tee iakumo mokanana.\" Sumaimo incia asarongiakea anana sumai Naftali. ");
INSERT INTO wlo_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Wakutuuna Lea akamatea ande incia indamo apalaahiri anana, abhawamo Zilpa, bhatuana, kasiimpomo apasarakaakamea i Yakub apamembalia bhawinena. ");
INSERT INTO wlo_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Kasiimpomo Zilpa, bhatuana Lea sumai, apalaahiri samia anana umane to Yakub. ");
INSERT INTO wlo_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Apogaumo Lea: \"Kukodhawua mpuu!\" Sababuna sumai incia asarongiakea anana sumai Gad. ");
INSERT INTO wlo_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Zilpa, bhawine bhatuana Lea, apalaahirimo uka to Yakub samia anana umane katutunina tumpe. ");
INSERT INTO wlo_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Apogaumo Lea, \"Iaku sii kumasanaamo! Tantumo manga bhawine asarongiakaaku kumasanaamo.\" Sababuna incia asarongiakea anana sumai Asyer. ");
INSERT INTO wlo_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Saangu wakutuu i bulaana timpuana gandum, Ruben alingka akambeli-mbeli. Incia apotibhaaka manga bhakena dudaim i inawu, kasiimpo abhawamea i Lea, inana. Apogaumo Rahel i Lea, \"Dhawuakaaku pia-pia angu bhakena dudaim pewauana o anamu sumai. ");
INSERT INTO wlo_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Alawanimo Lea i incia, \"Indapo akawa buaka to ingkoo uala umaneku, sanampuu ingkoo upeelu ualamo uka bhakena dudaimna anaku?\" Apogaumo Rahel, \"Malapemo, taroakamo incia akole tee ingkoo malo sii to kabholosina bhakena dudaimna anamu sumai.\" ");
INSERT INTO wlo_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Tobhele eo, wakutuuna Yakub ambuli minaaka i inawu, alimbamo Lea apepagoa tee apogau, \"Ingkoo tabeana usii i iaku, roonamo padhamo kusewako tee bhakena dudaimna anaku.\" Sababuna, akolemo Yakub tee incia i malo incia sumai. ");
INSERT INTO wlo_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Aulataʼala aperangoia Lea, sabutuna incia abhawa-bhawamo tee apalaahirimo anana umane lima miana to Yakub. ");
INSERT INTO wlo_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Apogaumo Lea, \"Aulataʼala padhamo adhawuaku ponamboku, roonamo iaku padhamo kupasaraakaakea bhatuaku i umaneku.\" Sababuna, incia asarongiakea anana sumai Isakhar. ");
INSERT INTO wlo_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Kasiimpomo Lea abhawa-bhawamo uka tee apalaahirimo anana umane namamiana to Yakub. ");
INSERT INTO wlo_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Lea apogaumo, \"Aulataʼala padhamo adhawuakaaku kadhawu momalape. Tantumo sii-sii umaneku bheaharagaangiaku, roonamo padhamo kupalaahiri nama mia anana umane to incia.\" Sababuna, incia asarongia anana sumai Zebulon. ");
INSERT INTO wlo_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Sapadhana incia sumai, incia apalaahirimo samia anana bhawine tee asarongiakea anana sumai Dina. ");
INSERT INTO wlo_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Kasiimpomo Aulataʼala audhani Rahel; Incia arangomea iemanina tee abungkaleakamea kadhumana. ");
INSERT INTO wlo_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Sabutuna abhawa-bhawamo Rahel tee apalaahirimo samia anana umane. Apogaumo incia, \"Aulataʼala padhamo ahapusu kaeaku.\" ");
INSERT INTO wlo_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Sumaimo incia asarongiakea anana sumai Yusuf, apoose apogau, \"Sio-siomo KAWASANA OPU aranganiaku samiapo uka anana umane.\" ");
INSERT INTO wlo_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Sapadhana Rahel apalaahiri Yusuf, apogaumo Yakub i Laban, \"Undaakaaku kulingka, mamudhaakana kumbuli i lipuku, i tampa laahiriaku. ");
INSERT INTO wlo_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Dhawuakaakumo manga bhawineku tee manga anaku, momembalina ponamboku i Pinoama, tee taroakaakumo kulingka. Pinoama umataua karomu tuaapa iaku padhamo kukarajaa to ingkoo.\" ");
INSERT INTO wlo_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Maka o Laban alawania, \"Ande ingkoo upeelu ususuaka kaasimu to iaku, mbooremo iwe sii! Padhamo kumataua minaaka i pekilala, ande KAWASANA OPU abarakatiaku rampaakanamo ingkoo.\" ");
INSERT INTO wlo_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Pogauna uka, \"Totapuakea saopea ponambomu, iaku bhekudhawuakako.\" ");
INSERT INTO wlo_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Alawanimo Yakub i incia, \"Ingkoo samia umataua tuaapa kukarajaa to ingkoo, tee tuaapa kadhaangiana kadhambaakamu ijaganiku, ");
INSERT INTO wlo_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","sababuna saidhemea kabharina pewauamu wakutuuna indapo kuumba, maka sii-sii ajulumo kabharina. KAWASANA OPU padhamo abarakati Pinoama kangengena kukarajaa iwe sii. Sii-sii, naepia kumembali kukarajaa to manga mia i bhanuaku karoku?\" ");
INSERT INTO wlo_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Aabhamo Laban, \"Opea tabeana idhawuakaku i ingkoo?\" Alawanimo Yakub, \"Pinoama, bholimo udhawuakaaku opeopea. Iaku sadhaadhaana kudhambaaka bhembe dumbamu tee kujagania, ande uundaakea hali incia sii to iaku: ");
INSERT INTO wlo_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Eo sii, bhekudhala kulaloi bhari-bharia bhembe dumbana Pinoama tee kugaatia minaaka iwe sumai sambaa-sambaa anana dumba mokotanda-tandana tee mokobhelombana; sambaa-sambaa anana dumba momaetana tee sambaa-sambaa bhembe mokobhelombana tee mokotanda-tandana. Siitumo bhemomembalina ponamboku. ");
INSERT INTO wlo_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Tee ande mboo sumai, naile naipua Pinoama bheumembali uparikisaaia kajujuruku i nuncana halina ponamboku. Sumaimo iaku tangkanamo bhekuala momaetana tee mokowarawaranaana. Ande dhaangia binata inda mboo sumai, maʼanana padhamo kumanakoa, tee Pinoama bheumataua.\" ");
INSERT INTO wlo_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Alawanimo Laban, \"Umbe, mboomo ipogauakamu itu.\" ");
INSERT INTO wlo_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Maka incia inda aose pojanjiana tee Yakub i saao. Laban alingka agaatia i eo incia sumai manga bhembe umane mokobhelombana tee mokotanda-tandana, bhari-bharia bhembe bhawine mokobhelombana tee mokotanda-tandana, siitumo bhari-bharia mokotandana maputi i badana, tee bhari-bharia dumba momaetana, kasiimpo apasaraakea bhari-bharia sumai i limana manga anana umanena. ");
INSERT INTO wlo_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Kasiimpomo Laban apapogaa manga kadhambaakana sumai talu eo karidhona lingkaana minaaka i Yakub, sainamo Yakub ajagani manga bhembe dumbana Laban mosagaanana, sumaimo inda mokowarawaranaana tee momaputina. ");
INSERT INTO wlo_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Kasiimpomo, Yakub aalamo manga raha maijo minaaka i puuna hawar, puuna badam, tee puuna berangan. Akulasimea sagaa kulina sampe akobhelomba maputi i manga raha sumai. ");
INSERT INTO wlo_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Incia adhikaia manga raha ikulasina sumai i aroana manga bhembe dumba sumai, i nuncana dhingkanana uwe isumpuna, roonamo manga binata sumai sadia akawi ande bheasumpu. ");
INSERT INTO wlo_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Sumaimo, manga bhembe dumba sumai akawi i aroana manga raha mokobhelombana maputi sumai, sabutuna alaahirimo manga anana mokotanda-tandana tee mokobhelombana. ");
INSERT INTO wlo_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Kasiimpomo Yakub agaatimea manga dumba bhemokawina sumai apapoaroa manga bhembe dumbana Laban momaetana tee mokobhelombana. Tee akala mboo sumai, Yakub arangani kabharina kadhambaakana karona tee agaatia minaaka i kadhambaakana Laban. ");
INSERT INTO wlo_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Jadi, sadia ande bheakawi manga bhembe dumba momakaana, Yakub adhikamea manga raha sumai i nuncana dhingkanana uwe isumpuna i aroana bhembe dumba sumai, mamudhaakana manga incia akawi amakasu i manga raha sumai. ");
INSERT INTO wlo_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Maka ande aumba saguluma bhembe dumba momalute, incia inda adhika manga raha sumai i aroana. Tee mboo sumai, manga kadhambaaka momalute amembali pewauana Laban, sainamo kadhambaaka momakaana amembali pewauana Yakub. ");
INSERT INTO wlo_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Sabutuna, ahandamo ajulu karangkaeana Yakub. Incia abhari gulumana bhembe dumbana, unta, tee keledai, tee uka bhatuana umane tee bhawine. ");
INSERT INTO wlo_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Yakub arango manga anana umane Laban apogau mboo sumai, \"Yakub padhamo aalea sagala giu pewauana umata tee minaaka i pewauana umata sumai apotibhaaka bhari-bharia karangkaeana.\" ");
INSERT INTO wlo_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","I sambalina incia sumai, Yakub uka akamata minaaka i rouna tee pemingkuina Laban ande indamo amalape incana tee incia mboomo i piamo itu. ");
INSERT INTO wlo_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","KAWASANA OPU afirimanimo i Yakub, \"Mbulimo i lipuna opu-opuamu tee i manga witinaimu. Iaku bhekupobhawa tee ingkoo tee kutulungiko.\" ");
INSERT INTO wlo_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Kasiimpo Yakub atumpumo mia akemba Rahel tee Lea to aumba i tana mokorumpu, i tampana gulumana bhembe dumbana. ");
INSERT INTO wlo_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Pogauna i manga incia, \"Padhamo kukamatea minaaka i rouna tee pemingkuina amamiu ande indamo amalape incana tee iaku mboomo i piamo itu. Moomini mboo sumai, Aulataʼalana amaku apobhawa tee iaku. ");
INSERT INTO wlo_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Umataua karomiu, ande tee kakaana bukuku padhamo kukarajaa i amamiu. ");
INSERT INTO wlo_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Moomini mboo sumai, amamiu padhamo agau-gauaku. Incia abhaliia o ponamboku sampe sapulu mpearo, maka Aulataʼala inda ataroakea to apewau madhaki i iaku. ");
INSERT INTO wlo_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Ande incia apogau, 'Binata mokotanda-tandana bheamembali ponambomu,' sanampuu bhari-bharia gulumana bhembe dumba sumai apalaahirimo anana mokotanda-tandana. Ande incia apogau, 'Binata mokobhelombana bheamembali ponambomu, jadi bhari-bharia gulumana bhembe dumba sumai apalaahirimo anana mokobhelombana.' ");
INSERT INTO wlo_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Mboo sumaimo, Aulataʼala aalea kadhambaakana amamiu tee adhawuakea i iaku. ");
INSERT INTO wlo_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Saangu wakutuu, i bulaana kawiana bhembe dumba, iaku kupongipi. I nuncana pongipiku sumai, kukamata manga bhembe dumba umane mokawiakana bhembe dumba sumai mokobhelombana, mokotanda-tandana, tee mokolore-lorena. ");
INSERT INTO wlo_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Kasiimpo i nuncana pongipi sumai malaaʼekatina Aulataʼala afirimani i iaku, 'Yakub!' Lawaniku, 'Umbe, Opu.' ");
INSERT INTO wlo_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Firimanina, 'Patindaia potontomu tee kamatea, bhari-bharia bhembe dumba umane mokawiakana bhembe dumba sumai mokobhelombana, mokotanda-tandana, tee mokolore-lorena, roonamo padhamo kukamatea bhari-bharia ipewauna Laban i ingkoo. ");
INSERT INTO wlo_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Iakumo Aulataʼala mopatiumbana Karona i Bait-El. I tampa incia sumai ingkoo ulaliaka mina i saangu tugu bhatu, tee utolau onimu i iaku. Sii-sii, makanumo, limbamo minaaka i lipu incia sii tee mbuli i tana laahiriamu.\" ");
INSERT INTO wlo_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Kasiimpomo alawanimo Rahel tee Lea i incia, \"Ingkami inda tee dhawu atawa tinauraka i nuncana bhanuana amamami! ");
INSERT INTO wlo_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Ingkami iabhina mboo mia dhaga rampaakanamo incia padhamo manga aso tee uka dhawumami apepadhaia. ");
INSERT INTO wlo_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Maka bhari-bharia harataa ialana Aulataʼala minaaka i amamami satotuuna pewauamami tee manga anamami. Sii-sii, pewaumea bhari-bharia ifirimaniakana Aulataʼala i ingkoo.\" ");
INSERT INTO wlo_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Saanampuu amakanumo Yakub, kasiimpo apakompamea manga anana tee manga bhawinena i bhawona unta. ");
INSERT INTO wlo_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Incia abhawamea bhari-bharia kadhambaakana tee bhari-bharia harataa ipokawaakana, siitumo kadhambaaka pewauana mopadhana ipokawaakana i Padan-Aram, mamudhaakana alingka i Ishak, amana, i Tana Kanaan. ");
INSERT INTO wlo_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Rahel dhaangiapo uka amanako manga patu terafim pewauana amana, roonamo i wakutuu incia sumai Laban tangasaana alingka agunti buluna manga dumbana. ");
INSERT INTO wlo_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yakub aʼakalai Laban, miana Aram sumai, tee inda apaumbaakea i incia, ande incia ahaejati apalai. ");
INSERT INTO wlo_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Sumaimo, apalaimo Yakub tee bhari-bharia manga pewauana. Incia apolimba i sawetana Umala Efrat, kasiimpo alingka aporope i Tana Gunu Gilead. ");
INSERT INTO wlo_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","I eo talu eona apakoleleakea i Laban ande Yakub apalaimo. ");
INSERT INTO wlo_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Kasiimpomo Laban akemba manga witinaina umane. Manga incia apajeremo Yakub pitu eo karidhona lingkaana, sabutuna o Laban amembali atutunia i Tana Gunu Gilead. ");
INSERT INTO wlo_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Maka, i malo incia sumai Aulataʼala aumbamo i nuncana saangu pongipina Laban, miana Aram sumai, apoose afirimani i incia, \"Jaga, bholi upogauaka opeopeapo uka i Yakub, malape momalapena atawa momadhakina!\" ");
INSERT INTO wlo_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Kasiimpo akawamo Laban i tampana Yakub. I wakutuu incia sumai Yakub padhamo apakaro kemana i Tana Gunu Gilead. Laban tee manga witinaina uka apakaro kemana i tana gunu sumai. ");
INSERT INTO wlo_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Pogauna Laban i Yakub, \"Opea ipewaumu sii, ingkoo uʼakalaikiaku tee ubhawea manga anaku bhawine mboomo mia itorongku i nuncana potimbea. ");
INSERT INTO wlo_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Pokia ingkoo upalai upobuniaka tee uʼakalaikiaku? Pokia ingkoo inda upaumbaaku, mamudhaakana kumembali kubhawako tee kasanaa, tee kupadhaangia kariaa to lingkaamu tee lagu, ganda, tee gambusu? ");
INSERT INTO wlo_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Ingkoo uka inda udhawuaku kalalesa to kuiki manga opuaku tee manga anaku. Sii-sii bhore mpuu ipewaumu! ");
INSERT INTO wlo_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Dhaangia kakuasa i iaku to kupewau madhaki i ingkoo, maka i malo Aulataʼalana amamu afirimani i iaku, 'Jaga, bholi upogauaka opeopeapo uka i Yakub, malape momalapena atawa momadhakina!' ");
INSERT INTO wlo_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Sii-sii, ande atotuu ingkoo bheulingka roonamo upemelilimo mpuu tee bhanuana amamu, pokia ingkoo umanako manga patu terafimku?\" ");
INSERT INTO wlo_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Alawanimo Yakub i Laban, \"Iaku kumaeka ancosala Pinoama bheuala manga anamu minaaka i iaku. ");
INSERT INTO wlo_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Teemini mboo sumai, incemapo uka ipotibhaakamu mobhawana manga patu terafimmu, incia inda bheatotaroaka adhadhi. Jadi, parakisaamea i aroana manga witinaita ara dhaangia manga pewauamu i iaku, alamea!\" Yakub inda amataua ande Rahel momanakona manga terafim sumai. ");
INSERT INTO wlo_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Sumaimo, apesuamo Laban i nuncana kemana Yakub, kemana Lea, tee kemana rua mia bhatuana bhawine sumai, maka incia inda apotibhaakea. Sapadhana alimba minaaka i kemana Lea, apesuamo incia i nuncana kemana Rahel. ");
INSERT INTO wlo_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Maka o Rahel padhamo aalea porikana terafim sumai, apapesuaia i nuncana kalempesina untana, tee auncuramikia. Laban aparakisaamo saangua kemana Rahel sumai, maka inda uka apotibhaakea. ");
INSERT INTO wlo_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Apogau Rahel i amana, \"Bholimo uʼamara Uma roonamo iaku inda membali kukakaro i aroamu. Iaku tangasaana akawaaku bulaku.\" Laban aparakisaamea mpuu-mpuu uka, maka incia inda apotibhaakea manga terafim sumai. ");
INSERT INTO wlo_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Kasiimpo Yakub aʼamara tee apotagalimo tee Laban. Pogauna i Laban, \"Opea kasalahaku, tee opea dosaku, sampe upajereaku mboo kakaa incia sii? ");
INSERT INTO wlo_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Sapadhana Pinoama uparakisaa bhari-bharia pewauaku, buaka Pinoama upotibhaakea manga pewauamu? Dhikaia iwe sii, i aroana manga witinaiku tee manga witinaimu. Taroakamo manga incia abhotukiaka parakara i tanga-tangata rua mia. ");
INSERT INTO wlo_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Iaku kupobhawa tee Pinoama 20 tao kangengena. Dumba tee bhembemu bhawine inda mina amadhaki alaahiri, tee bhembe dumbamu umane indapo mina kukandea. ");
INSERT INTO wlo_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Indapo mina kubhawaakako kadhambaaka mopadhana ikandena manga binata masega. Iaku samia mobholosia. Kadhambaaka motomanakona i eo atawa o malo uka utuntua minaaka i limaku. ");
INSERT INTO wlo_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Pontanga eo iaku akanaaku kasodhona eo, sainamo malo akanaaku kagari. Mataku sadia inda apopiro. ");
INSERT INTO wlo_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Iaku i bhanuamu 20 tao kangengena. Kukarajaa i pinoama 14 tao to kupotibhaaka rua miaia anamu, tee 6 tao uka to kupotibhaaka gulumana bhembe dumbamu. Kangengena incia sumai, sapulu mpearomo ubhalii ponamboku. ");
INSERT INTO wlo_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Ande Aulataʼalana amaku, siitumo Aulataʼalana Ibrahim imaekana Ishak inda apobhawa tee iaku tee atulungiaku, tantumo sii-sii urambasakaaku kulingka tee ruambalia limaku. Maka roonamo Aulataʼala akamatamea kanarakaaku tee kanguleku, sanampuu Incia audhaniaka Pinoama i malo.\" ");
INSERT INTO wlo_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Lawanina Laban i Yakub, \"Rua mia bhawine sii o anaku tee manga anana sii opuaku, bhembe dumba sii bhembe dumbaku, teemo uka bhari-bharia ikamatamu sii satotuuna pewauaku. Maka indamo amembali kualea pendua manga anaku tee manga anana ipalaahirina manga incia minaaka i ingkoo. ");
INSERT INTO wlo_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Sii-sii, maimo tapojanjiaka, iaku tee ingkoo, tee taroakamo sumai amembali sakusii i tanga-tangata.\" ");
INSERT INTO wlo_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Sanampuu Yakub aalamo saangu bhatu tee apakaromea amembali saangu tugu. ");
INSERT INTO wlo_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Kasiimpomo Yakub apogau i manga witinaina, \"Romusakea manga bhatu.\" Kasiimpomo manga incia aalamo manga bhatu apamembalia kabumbuna bhatu. Sapadhana sumai manga incia akandemo iwe sumai, i saripina kabumbuna bhatu sumai. ");
INSERT INTO wlo_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban asarongiakea kabumbuna bhatu sumai Yegar-Sahaduta, maka Yakub asarongiakea Galed. ");
INSERT INTO wlo_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Apogaumo Laban i Yakub, \"Kabumbuna bhatu incia sii amembali sakusii i tanga-tangata.\" Siitumo sababuna kabumbuna bhatu incia sii asarongiakea Galed, ");
INSERT INTO wlo_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","tee uka Mizpa, sababuna Laban apogau, \"Sio-siomo KAWASANA OPU atiliki pemingkuita, iaku tee ingkoo, wakutuuna ingkita tapomaridho. ");
INSERT INTO wlo_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Jaga ande upanarakaaia manga anaku atawa ukawiaka bhawine mosagaanana. Moomini iaku inda kumataua, maka udhania, Aulataʼala sadia akamata ingkita.\" ");
INSERT INTO wlo_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Kasiimpomo Laban apogau i Yakub, \"Kamatea, siimo kabumbuna bhatu tee siimo tugu mopadhana ipabhanguku i tanga-tangata. ");
INSERT INTO wlo_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Kabumbuna bhatu tee tugu incia siimo sakusii, ande iaku inda bhekulaloi kabumbuna bhatu sii to kukawako tee haejati madhaki, tee ingkoo uka inda bheulaloi kabumbuna bhatu tee tugu sii to ukawaaku tee haejati madhaki. ");
INSERT INTO wlo_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Aulataʼalana Ibrahim, Nahor tee opuopuana manga, maasangia bheamembali haakimu i tanga-tangata.\" Kasiimpo Yakub asumpa to apakawaaka janjina i nuncana sarona Aulataʼala imaekana Ishak, o amana. ");
INSERT INTO wlo_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Sapadhana sumai, Yakub apasombaakamo kurubani isumbelena i gunu sumai tee akemba manga witinaina to akande. Manga incia uka akande tee apomalo i gunu sumai. ");
INSERT INTO wlo_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Samainawana Laban abhangumo. Aikimo manga opuana tee manga anana tee aemaniakamea barakati to manga incia. Sapadhana incia sumai, alingkamo Laban ambuli i tampa mbooresana. ");
INSERT INTO wlo_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yakub apalausakamo lingkaana, kasiimpomo manga malaaʼekatina Aulataʼala aumba apokawaakea. ");
INSERT INTO wlo_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Mboo sumai Yakub akamatea manga, incia apogaumo, \"Siimo satotuuna pokemaana tantarana malaaʼekatina Aulataʼala!\" Siitumo asarongiakamea tampa incia sumai Mahanaim. ");
INSERT INTO wlo_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Sapadhana incia sumai, Yakub alambokomo pia-pia mia tumpuana porikana apokawaaka Esau, o akana, i Tana Seir, i lipu Edom. ");
INSERT INTO wlo_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Kasameana i manga incia, \"Mboo siimo tabeana ingkomiu upogauakea i opuku, Esau: 'Bhatuamu, Yakub, apogau, \"Kangengena sii kumboore i Laban mboo dhaga tee kumboore iwe sumai sampe sii-sii. ");
INSERT INTO wlo_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Iaku dhaangia tee gulumana sapi, keledai, bhembe dumba, manga bhatua umane tee bhawine, tee kulamboko tumpuaku to apaumbaaka hali incia sumai i opuku, mamudhaakana opu umaasiakaaku.\" ");
INSERT INTO wlo_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Kasiimpomo manga tumpuana sumai uka ambuli i Yakub tee apogau, \"Ingkami padhamo tapokawaaka Esau, o akamu, tee incia uka tangasaana alingka to apokawaakako, apoose 400 mia manga umane.\" ");
INSERT INTO wlo_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Sanampuu amaekamo mpuu Yakub sampe amasee poinuncana. Sumaimo incia agaatimea manga mia mopoosena tee uka gulumana bhembe dumbana, sapi tee unta to apamembalia rua rombonga. ");
INSERT INTO wlo_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Sababuna incia afikiri, \"Ande Esau aumbati aewangi sala saangu rombongana, sumaimo rombongana sagaanana bheasalaamati.\" ");
INSERT INTO wlo_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Kasiimpo apogaumo Yakub, \"E Aulataʼala, isombana opuaku Ibrahim tee amaku Ishak, e KAWASANA OPU mopadhana motumpuaku, 'Mbuli pendua i lipumu tee i manga witinaimu tee Iaku bhekupewau malape i ingkoo,' ");
INSERT INTO wlo_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","iaku inda alaenga to kutarima moomini saidhe mpuu minaaka i bhari-bharia kaasimu molagina mopadhana isusuakana KAWASANA OPU i bhatuamu sii. Roonamo wakutuuna kupolimba i Umala Yordan sii i piamo itu tangkanamo katukoku sii ibhawaku, maka sii-sii iaku kumembalimo rua rombonga. ");
INSERT INTO wlo_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Maka, rambasakaaku minaaka i limana Esau, akaku, roonamo kumaeka i incia; ancosala aumba to abhaliaku, tee uka manga bhawineku tee manga anaku. ");
INSERT INTO wlo_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Kuemani bholi umalinguakea opea ijanjiakamu, 'Iaku dhaanamo bhekupewau malape i ingkoo tee kupamembalia siwulumu mboomo bhone i tawo, inda atolentu kabharina.' \" ");
INSERT INTO wlo_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Yakub uka apomalomo iwe sumai. Kasiimpomo aalamo sagaa minaaka i manga harataa pewauana to adhawuaka i Esau, o akana, ");
INSERT INTO wlo_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","siitumo 200 mbaa bhembe bhawine, 20 mbaa bhembe umane, 200 dumba bhawine, tee 20 mbaa dumba umane, ");
INSERT INTO wlo_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","30 mbaa unta bhawine tee manga anana tangasaana apadudua, 40 mbaa sapi bhawine, 10 mbaa sapi umane, 20 mbaa keledai bhawine tee 10 mbaa keledai umane. ");
INSERT INTO wlo_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Apasarakaakamea bhari-bharia sumai i manga bhatuana, sumaimo manga incia ajagani gulumana kadhambaakana sumbe-sumbere. Kasiimpo apogaumo Yakub i manga incia, \"Lingkamo porikanaakaaku maka bholi bhari-bharia apobhawa-bhawa. Dhawua polotaa i tanga-tangana manga gulumana kadhambaaka sumai tee mosagaanana.\" ");
INSERT INTO wlo_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","I bhatua molingkana poriaroa incia asameamo, \"Ande Esau, akaku, apokawaakako, tee aabha, 'Bhatuana incema ingkoo sii? Iapai bheulingka? Pewauana incema manga kadhambaaka i aroamu sii?,' ");
INSERT INTO wlo_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","lawanimo mboo sii, 'Pewauana bhatuamu, Yakub, siimo idhawuakana ilambokona to opuku Esau. Satotuuna, incia samia dhaangia i talikumami.' \" ");
INSERT INTO wlo_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Mboo sumai uka kasameana i bhatuana katutunina mobhaa-bhaana tee moporitalikuna, tee i bhari-bharia mia molingkana moosena gulumana kadhambaaka sumai. Pogauna, \"Mboo sumaimo tabeana ingkoo upogauakea i Esau ande upokawa tee incia. ");
INSERT INTO wlo_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Pogauakea uka, 'Satotuuna, bhatuamu Yakub dhaangia i talikumami.' \" Roonamo Yakub afikiri, \"Iaku gauku apekarunaia incana tee harataa idhawuakaku ibhawana porikana sii, sapadhana sumai, kasiimpomo bhekukamata rouna. Aipomo incia aunda atarimaaku.\" ");
INSERT INTO wlo_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Jadi, kadhawu sumai alambokoakea porikana sainamo incia samia apomalo i pokemaana i malo incia sumai. ");
INSERT INTO wlo_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","I malo incia sumai uka Yakub abhangu. Abhawamea rua miaia bhawinena, rua miaia maruena bhatuana bhawine tee sapulu samiaia anana apolimba alaloi tampa polimbaa Umala Yabok. ");
INSERT INTO wlo_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Sapadhana incia abhawea manga i sawetana, apapolimbamea uka manga harataa pewauana. ");
INSERT INTO wlo_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Sapadhana manga incia apolimba, soomo Yakub modhaangiana samia-miana, kasiimpo samia umane apobhante tee incia sampe abhete matanaeo. ");
INSERT INTO wlo_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Wakutuuna umane sumai akamata ande incia inda amembali atalo Yakub, abhebhemo losuana paana Yakub. Saanampuu losuana paana Yakub sumai atosala rampaakanamo apobhante tee umane i saao. ");
INSERT INTO wlo_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Kasiimpomo apogau umane sumai, \"Taroakaakumo kulingka, roonamo matanaeo bheabhetemo.\" Maka Yakub alawanimo, \"Iaku inda bhekutaroakako ulingka, ande indapo ubarakatiaku.\" ");
INSERT INTO wlo_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Aabhamo umane sumai i incia, \"Incema buaka saromu?\" Alawanimo, \"Yakub.\" ");
INSERT INTO wlo_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Pogauna umane incia sumai, \"Saromu inda bheasarongiakea Yakub, tabeana Israel, roonamo ingkoo padhamo upobhante tee Aulataʼala tee maanusia, tee ingkoo ukohasili.\" ");
INSERT INTO wlo_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Kasiimpomo aemanimo Yakub, \"Paumbaakaakupo saromu.\" Lawanina, \"Pokia uabhaaka saroku?\" Kasiimpomo abarakatimea Yakub iwe sumai. ");
INSERT INTO wlo_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Yakub asarongiakea tampa incia sumai Peniel, roonamo pogauna, \"Iaku padhamo kupotonto rou tee Aulataʼala, maka inyawaku asalaamati!\" ");
INSERT INTO wlo_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Matana eo abhetemo wakutuuna alaloi Peniel, tee incia amakempa roonamo losuana paana sumai atosala. ");
INSERT INTO wlo_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Sababuna sumai, sampemo eo sii miana Israel inda akande uwana losuana paana binata, roonamo i weta iwe sumaimo umane sumai padhamo abhebhe Yakub. ");
INSERT INTO wlo_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Wakutuu Yakub apatinda potontona tee atiliki, atiumbamo Esau aumba apoose 400 mia manga umane. Kasiimpomo abagemea manga anaana i tanga-tangana Lea, Rahel, tee i rua mia bhatua bhawine manga. ");
INSERT INTO wlo_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Incia adhikamea manga bhatua bhawine sumai tee manga anana i aroa, kasiimpo Lea tee manga anana, tee sapadhana incia sumai Rahel tee Yusuf i taliku mpuu. ");
INSERT INTO wlo_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Yakub samia alingka i aroana manga tee asuju ahoromati pitu mpearo, sampe incia apekakasu i akana. ");
INSERT INTO wlo_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Maka Esau abuntuli apokawaakamo Yakub, asakumea, asakulaka bhorokona tee aikia, kasiimpo apotangisimo manga incia. ");
INSERT INTO wlo_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Wakutuuna Esau apatinda potontona, akamatamea manga bhawine tee manga anana i aroana, aabhamo incia, \"Incema buaka manga mia mopoosena tee ingkoo sii?\" Alawani Yakub, \"Manga anana mopadhana idhawuakana Aulataʼala i bhatuamu sii.\" ");
INSERT INTO wlo_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Kasiimpomo manga bhatua bhawine sumai tee manga anana apasari tee asuju ahoromati. ");
INSERT INTO wlo_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Lea tee manga anana uka apekakasumo, kasiimpo asuju ahoromati. Sapadhana sumai apekakasumo uka Yusuf tee Rahel, kasiimpomo asuju ahoromati uka. ");
INSERT INTO wlo_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Aabhamo Esau, \"Opea haejatimu tee bhari-bharia gulumana kadhambaaka ipokawaakaku i saao?\" Alawanimo Yakub, \"Mamudhaakana opu umaasiaka bhatuamu.\" ");
INSERT INTO wlo_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Maka Esau apogaumo, \"Andiku, iaku kukokadhaangiamo. Taroakamo opea modhaangiana i karomu sadhaadhaana amembali pewauamu.\" ");
INSERT INTO wlo_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Apogaumo Yakub, \"Kuemani bholi mboo sumai. Ande opu satotuuna umaasiaka bhatuamu sii, tulungi tarimaia harataa idhawuakaku minaaka i limana bhatuamu sii. Satotuuna to iaku, kukamata rouna opu mboo mpuu kukamata rouna Aulataʼala. Opu upepagoakumo malape. ");
INSERT INTO wlo_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Kuemani tarimaia kadhawuna ibhawaakana i opu sii, roonamo Aulataʼala amalape incana i bhatuamu sabutuna iaku uka kukokadhaangia bhari-bharia sii.\" Yakub aemani mpuu, sampe Esau uka aunda atarimaia. ");
INSERT INTO wlo_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Pogaumo Esau, \"Maimo ingkita tabhose tapalausaka lingkaata; bhekulingka kupoose tee ingkoo.\" ");
INSERT INTO wlo_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Maka Yakub apogau i incia, \"Opuku umataua, manga anaana sii dhaangia amalute, tee uka manga gulumana bhembe dumba tee sapi dhaangiapo apadudua. Ande apasurua alingka tangkanamo saeomea, sumaimo bhari-bharia bhembe dumba sumai bheamate. ");
INSERT INTO wlo_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Jadi, taroakamo opuku ulingka uporikanaaka bhatuamu sii. Bhekujulu tee kupengkaanaka mboomo bhengkalana kadhambaaka modhaangiana i aroana bhatuamu apoose tee bhengkalana manga anaana, sampe kukawa i opuku i Seir.\" ");
INSERT INTO wlo_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Apogaumo Esau, \"Ande mboo itu, taroakamo kubholiaka i ingkoo pia-pia mia minaaka i manga mia mopoosena tee iaku.\" Maka alawanimo Yakub, \"Tarima kaasi, inda afaraluu opuku. Kumasanaa mpuu roonamo umaasiakaaku. Sumaimo podhomo itu.\" ");
INSERT INTO wlo_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Jadi ambulimo Esau i eo incia sumai uka aporope i Seir. ");
INSERT INTO wlo_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Maka Yakub abhose i Sukot. Iwe sumai incia apakaromo saangu bhanua to karona tee wale-wale to kadhambaakana. Siitumo sababuna tampa incia sumai asarongiakea Sukot. ");
INSERT INTO wlo_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","I nuncana lingkaana minaaka i Mesopotamia, Yakub akawamo tee salaamati i Sikhem, i Tana Kanaan, kasiimpo incia apakaro kemana i saripina kota sumai. ");
INSERT INTO wlo_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Kasiimpomo aalimo satidha tana, tampana incia apakaro kemana tee haragaana 100 tibha doi pera minaaka i siwuluna Hemor, o amana Sikhem. ");
INSERT INTO wlo_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Incia apakaromo saangu tampa tunuana kurubani tee asarongiakamea, \"El Elohe Israel,\" mokomaʼanana \"Aulataʼala dhaangiamo Aulataʼalana Israel.\" ");
INSERT INTO wlo_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Saangu wakutuu, Dina, anana bhawine Lea ipalaahirina to Yakub, alingka asolo manga bhawine mangura miana Hewi i lipu incia sumai. ");
INSERT INTO wlo_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Wakutuu Sikhem, o anana Hemor, miana Hewi, rajana lipu sumai, akamata Dina, sumai amanakoa tee asalaikia. ");
INSERT INTO wlo_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Maka incia apeelu Dina, anana Yakub, tee asintai kabuabua sumai. Sabutuna incia uka aʼusaha apaturu incana kabuabua sumai mamudhaakana apeelua uka. ");
INSERT INTO wlo_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Sikhem apogaumo i amana, Hemor, \"Taurakaakamea kabuabua sumai to amembali bhawineku.\" ");
INSERT INTO wlo_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Lele incia sumai atorangomo i Yakub, ande Sikhem asalaiki Dina, o anana. Maka i wakutuu incia sumai, manga anana umane tangasaana i tana mokorumpu apobhawa tee kadhambaakana. Sababuna sumai Yakub apekalino sampe manga incia aumba. ");
INSERT INTO wlo_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Kasiimpomo Hemor, amana Sikhem, alingkamo apokawaaka Yakub to apogau i incia. ");
INSERT INTO wlo_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Tangasaana manga incia apogau, manga anana umane Yakub ambuli minaaka i tana mokorumpu. Wakutuu amataua ande Sikhem padhamo asalaiki andina bhawine manga incia, manga anana Yakub amapii incana tee aʼamaramo mpuu, roonamo Sikhem padhamo apewau kaea mpuu i tanga-tangana miana Israel tee asalaiki anana bhawine Yakub, saangu hali inda alaenga atopewau. ");
INSERT INTO wlo_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Kasiimpomo, wakutuu Yakub tee manga anana umane aporomu-romu bhari-bharia, Hemor apogaumo tee manga incia, \"Anaku Sikhem apeelua mpuu anamu bhawine Dina. Jadi kuemani dhawuakea to amembali bhawinena. ");
INSERT INTO wlo_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Maimo tapoala-alaaka podho-podho ingkita. Dhawuakea manga kabuabuamiu i ingkami, tee alea manga kabuabuamami to ingkomiu. ");
INSERT INTO wlo_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Ingkomiu umembali umbooremo tee ingkami. Pilimo tampana mbooresa ipeelumiu. Ingkomiu ubebasi ukambeli-mbeli iapai-iapaipo i lipu sii tee bheumembali mokotanana iwe sii.\" ");
INSERT INTO wlo_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Kasiimpomo, Sikhem apogau i amana Dina sumai tee i manga witinaina, \"Kuemani ingkomiu amalape incamiu i iaku. Opeapo iemanimiu, bhekudhawuakakomiu. ");
INSERT INTO wlo_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Pasodhakaaku taurakana tee hadia saopeapo uka kabharina. Iaku bhekupomeaia kabharina isarongimiu. Tangkanamo, dhawuakaaku kabuabua sumai to amembali bhawineku.\" ");
INSERT INTO wlo_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Maka, manga anana umane Yakub alawani Sikhem tee Hemor, amana, tee kagau-gauna, sababuna Sikhem padhamo asalaiki Dina, o andina manga. ");
INSERT INTO wlo_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Apogaumo manga incia i rua miaia manga incia sumai, \"Ingkami inda tamembali tapewau mboo sumai, apasarakaaka andimami i umane inda mototandakina, roonamo hali incia sumai saangu kaea to ingkami. ");
INSERT INTO wlo_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Tangkanamo tee sarati incia sii ingkami taundakea opea iemanimiu, siitumo ande ingkomiu amembali apokana mboomo ingkami, sumaimo bhari-bharia umane modhaangiana i tanga-tangamiu tabeana atotandaki. ");
INSERT INTO wlo_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Sapadhana incia sumai, ingkami bhetadhawuaka manga kabuabuamami i ingkomiu tee bhetaala uka manga kabuabuamiu to ingkami, kasiimpo ingkami bhetamboore i tanga-tangamiu. Ande mboo sumai, ingkita bhetamembali saangu lipu. ");
INSERT INTO wlo_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Maka ande ingkomiu inda urango pogaumami tee inda utotandaki, siitumo ingkami bhetabhawa andimami, kasiimpomo talingka.\" ");
INSERT INTO wlo_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Hemor tee Sikhem bin Hemor atarima malape saratina sumai. ");
INSERT INTO wlo_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Anana umane sumai apekadhei apamondo sarati iemanina roonamo incia apeelu mpuu Dina, anana Yakub, tee uka incia satotuuna samia motohoromatina i tanga-tangana saangua kaomuna witinaina. ");
INSERT INTO wlo_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Sanampuu alingkamo Hemor tee Sikhem, anana, i bhambana lawana kotana manga, kasiimpo apogau tee manga miana kota sumai. Pogauna manga incia, ");
INSERT INTO wlo_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","\"Manga mia incia sumai bheapomalapemo tee ingkita. Taroakamo manga incia amboore i lipu sii tee akambeli-mbeli iapaipo peeluana, roonamo kamatea, lipu sii dhaangiapo amaoge to manga incia! Tee mboo sumai ingkita tamembali taala manga kabuabuana to bhawineta, tee manga kabuabuata uka tadhawuaka to manga incia. ");
INSERT INTO wlo_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Maka, tangkanamo tee sarati incia sii manga incia aunda to amboore tee ingkita, sabutuna ingkita amembali saangu lipu, siitumo ande bhari-bharia umane i tanga-tangana ingkita atotandaki mboomo manga incia uka atotandaki. ");
INSERT INTO wlo_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Ande taundakea saratina, dhaampo bhari-bharia kadhambaakana tee harataa pewauana mosagaanana bheamembali pewauata. Ifaraluuna tangkanamo taundakea to atotandaki. Sapadhana incia sumai, manga incia bheamboore tee ingkita i liputa sii.\" ");
INSERT INTO wlo_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Bhari-bharia umane moumbana moporomusaka i bhambana lawana kota sumai aperangoi pogauna Hemor tee Sikhem tee aundaakea. Sumaimo, bhari-bharia umane i kota sumai alausaka atotandaki. ");
INSERT INTO wlo_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","I eo talu eona, wakutuuna manga incia dhaangiapo amapii, rua mia anana Yakub, siitumo Simeon tee Lewi, manga akana Dina, aalamo hancuna sumbesumbere kasiimpo wakutuu apesuaiki kota incia sumai inda tee mojoli-jolia, kasiimpo apekamate bhari-bharia manga umane iwe sumai. ");
INSERT INTO wlo_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Hemor tee Sikhem, anana, manga incia atopekamate uka tee hancu. Manga akana Dina aala andina minaaka i bhanuana Sikhem, kasiimpomo ambuli i tampana pokemaana. ");
INSERT INTO wlo_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Kasiimpo aumbamo manga anana Yakub aumbati manga mia motopekamate sumai kasiimpo arampasi bhari-bharia mokoharagaana i kota sumai. Manga incia apewau mboo sumai to abholosiaka Sikhem mosalaikina andina. ");
INSERT INTO wlo_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Manga incia apomaala kadhambaakana bhembe dumba, sapi, keledai, tee opea uka modhaangiana i nuncana tee i sambalina kota sumai. ");
INSERT INTO wlo_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Manga anana Yakub apomala bhari-bharia harataana raʼeati, atorongku bhari-bharia bhawine tee manga anaana, tee arampasi sagala giu modhaangiana i nuncana manga bhanua. ");
INSERT INTO wlo_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Apogaumo Yakub i Simeon tee Lewi, \"Ingkomiu padhamo upanarakaa iaku tee upekabuto saroku i tanga-tangana raʼeatina lipu sii, siitumo i tanga-tangana miana Kanaan tee miana Feris. Kabharita tangkanamo saidhe. Ande manga incia aposaangu abhali tee aewangi ingkita, sanampuu tabinasa poose tee saangua antona bhanuaku. ");
INSERT INTO wlo_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Maka manga incia alawani, \"Alaenga buaka andimami apewaua mboomo bhawinena dhala?\" ");
INSERT INTO wlo_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Aulataʼala afirimanimo i Yakub, \"Makanumo, penemo i Bait-El tee mbooremo iwe sumai. Karajaamo iwe sumai saangu tampa tunuana kurubani to Aulataʼala, mopadhana mopatiumbaakana karona i ingkoo, wakutuuna ingkoo upalai minaaka i Esau, akamu.\" ");
INSERT INTO wlo_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Kasiimpomo pogauna Yakub i saangua antona bhanuana tee bhari-bharia mia mopobhawana tee incia, \"Bhanakea manga barahalana dhaga modhaangiana i tanga-tangamiu, pekangkiloa karomiu tee bholosimea pakeamiu. ");
INSERT INTO wlo_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Maimo ingkita tamakanuaka tapene i Bait-El. Iwe sumai iaku bhekukarajaa tampa tunuana kurubani to Aulataʼala, molawaniaku i wakutuuna kasekeku tee mopobhawana tee iaku i dhala idhalaikiku.\" ");
INSERT INTO wlo_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Sabutuna, manga incia adhawuakamo i Yakub sagala barahala dhaga pewauana manga tee dhali-dhali modhaangiana i talingana manga, tee Yakub alamui bhari-bharia sumai i tambena puuna kau maoge modhaangiana i saripina Sikhem. ");
INSERT INTO wlo_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Sapadhana incia sumai, alingkamo manga incia. Namisi kaekana maoge mpuu minaaka i Aulataʼala akangkanai manga kota modhaangiana i saripina manga. Sabutuna, manga anana Yakub inda atopajere. ");
INSERT INTO wlo_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Kasiimpomo akawamo Yakub apobhawa tee bhari-bharia mia moosena i Lus, siitumo Bait-El, i Tana Kanaan. ");
INSERT INTO wlo_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Apabhangumea iwe sumai tampa tunuana kurubani tee asarongiakea tampa incia sumai \"El Bait-El\" (maʼanana Aulataʼala Bait-El), roonamo iwe sumaimo Aulataʼala padha apatiumbaaka karona i incia wakutuuna apalai minaaka i akana. ");
INSERT INTO wlo_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Wakutuu incia sumai, Deborah, modhambaakana Ribka, amatemo. Kasiimpo manga incia atokoburu i tambena Bait-El, i tambena saangu puuna kau maoge. Sabutuna puuna kau sumai asarongiakea, \"Puuna Tangia\". ");
INSERT INTO wlo_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Sapadhana Yakub aumba minaaka i Padan-Aram, Aulataʼala apatiumbaakamo karona uka i incia tee abarakatia. ");
INSERT INTO wlo_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Firimanina Aulataʼala i incia, \"Saromu Yakub, maka minaaka sii-sii, ingkoo indamo uka utosarongi Yakub. Saromu bheamembali Israel.\" Sumaimo, Aulataʼala asarongiakea Israel. ");
INSERT INTO wlo_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Firimanina Aulataʼala i incia uka, \"Iakumo Aulataʼala Mokokuasana. Koana-anamo koopu-opuamo tee handamo kabharimu. Saangu lipu, tee uka saangu rombongana bhari lipu bheaminaaka i ingkoo, tee minaaka i siwulumu bheaumba manga raja. ");
INSERT INTO wlo_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Lipu incia sii, idhawuakaku i Ibrahim tee Ishak, bhekudhawuakako. Iaku uka bhekudhawuaka lipu incia sii i siwulumu naile itu.\" ");
INSERT INTO wlo_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Sapadhana incia sumai Aulataʼala abholimo Yakub minaaka i tampana Incia afirimani. ");
INSERT INTO wlo_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","I tampana Aulataʼala afirimania, Yakub aalamo bhatu tee apakaromo saangu tugu. Kasiimpomo i tugu sumai apasombaakea i Aulataʼala alaliakea angguru tee mina zaitun i bhawona. ");
INSERT INTO wlo_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Yakub asarongiakea tampa incia sumai Bait-El, tampa iapai Aulataʼala padhamo afirimania. ");
INSERT INTO wlo_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Sapadhana incia sumai, asapomo manga incia minaaka i Bait-El. Wakutuu manga incia indamo amaridho minaaka i Efrata, akawamo wakutuuna Rahel to akoana tee incia amarasai mpuu akoana. ");
INSERT INTO wlo_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Wakutuuna amarasai mpuu akoana, bhisa koana apogaumo i incia, \"Bholi umaeka, roonamo sii-sii uka upotibhaakamo samia anaana umane.\" ");
INSERT INTO wlo_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Wakutuu incia bheamate, incia asarongiakea anaana sumai Bin-Oni. Maka amana asarongiakea Binyamin. ");
INSERT INTO wlo_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Kasiimpomo Rahel amate, akoburua i bhiwina dhala moporopena i Efrata, sii-sii asarongiakea Bait Lahim. ");
INSERT INTO wlo_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yakub aalamo bhatu tee apakaromo saangu tugu i bhawona koburuna Rahel; sumaimo tuguna koburuna Rahel sampe sii-sii. ");
INSERT INTO wlo_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Sapadhana incia sumai, Israel abhosemo, kasiimpo apakaromea kemana i sawetana Migdal-Eder. ");
INSERT INTO wlo_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Wakutuu Israel amboore i lipu incia sumai, Ruben akole tee Bilha, maruena amana, tee atorangomo hali incia sumai i Israel. 35:22-29 Manga anana umane Yakub kabharina sapulu rua mia. ");
INSERT INTO wlo_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Manga anana minaaka i Lea: siitumo Ruben, anana tumpena Yakub, kasiimpomo Simeon, Lewi, Yuda, Isakhar, tee Zebulon. ");
INSERT INTO wlo_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Manga anana minaaka i Rahel: siitumo Yusuf tee Binyamin. ");
INSERT INTO wlo_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Manga anana minaaka i Bilha, bhatuana Rahel: siitumo Dan tee Naftali. ");
INSERT INTO wlo_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Sainamo manga anana minaaka i Zilpa, bhatuana Lea: siitumo Gad tee Asyer. Siitumo manga anana umane Yakub, ipalaahirina to incia i Padan-Aram. ");
INSERT INTO wlo_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Kasiimpomo akawamo Yakub i tampana Ishak, amana, i Mamre i saripina Kiryat-Arba sumaimo Hebron, tampana Ibrahim tee Ishak amboore mboomo mia dhaga. ");
INSERT INTO wlo_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Ishak akoʼumurumo 180 tao. ");
INSERT INTO wlo_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Kasiimpomo Ishak ailamo poinuncana tee amatemo wakutuu amancuanamo tee akodhadhimo mpuu. Ishak aromusakea tee kaomuna i alamuna mia momate. Sabutuna, Esau tee Yakub, ruamiaia anana sumai akoburu incia. ");
INSERT INTO wlo_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","O siimo siwuluna Esau, isarongiaka uka Edom. ");
INSERT INTO wlo_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau akobhawineakamo manga bhawine Kanaan, siitumo Ada anana Elon miana Het; tee Oholibama, anana Ana, anana Zibeon, miana Hewi; ");
INSERT INTO wlo_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","tee uka Basmat, anana Ismail, andina Nebayot. ");
INSERT INTO wlo_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada apalaahiri Elifas to Esau, tee Basmat apalaahiri Rehuel, ");
INSERT INTO wlo_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","sainamo Oholibama apalaahiri Yeus, Yaelam, tee Korah. Siitumo manga anana Esau, ipalaahirina to incia i Tana Kanaan. ");
INSERT INTO wlo_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esau abhawa manga bhawinena, manga anana umane tee bhawine, tee bhari-bharia mia saangua bhanuana, kadhambaakana, sagala binatana, tee sagala harataa pewauana ipotibhaakana i Tana Kanaan, kasiimpomo alingka incia i lipu momaridhona minaaka i Yakub, andina. ");
INSERT INTO wlo_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Esau apogaa tee Yakub sababuna harataa pewauana manga abhari laulau, sumaimo manga incia inda amembali amboore apobhawa. Tee uka i lipu mbooresana sumai manga inda akawa rumpu to kadhambaakana mobharina mpuu sumai. ");
INSERT INTO wlo_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Sabutuna, Esau isarongiaka Edom sumai ambooremo i Tana Gunu Seir. ");
INSERT INTO wlo_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","O siimo siwuluna Esau, amana kaomuna miana Edom, i Tana Gunu Seir. ");
INSERT INTO wlo_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Sarona manga anana Esau: siitumo Elifas, anana Ada bhawinena Esau, tee Rehuel, anana Basmat bhawinena Esau. ");
INSERT INTO wlo_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Manga anana Elifas: siitumo Teman, Omar, Zefo, Gaetam, tee Kenas. ");
INSERT INTO wlo_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Timna, maruena Elifas anana Esau, apalaahiri Amalek to Elifas. Siitumo siwuluna Ada, bhawinena Esau. ");
INSERT INTO wlo_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Manga anana Rehuel: siitumo Nahat, Zerah, Syama, tee Miza. Siitumo siwuluna Basmat, bhawinena Esau. ");
INSERT INTO wlo_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Oholibama anana Ana binti Zibeon bhawinena Esau, apalaahirimo uka manga anaana to Esau: siitumo Yeus, Yaelam tee Korah. ");
INSERT INTO wlo_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","O siimo manga kapalana kaomuna bani Esau. Siwuluna Elifas, ana tumpena Esau, amembali kapalana kaomuna Teman, kapalana kaomuna Omar, kapalana kaomuna Zefo, kapalana kaomuna Kenas, ");
INSERT INTO wlo_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","kapalana kaomuna Korah, kapalana kaomuna Gaetam, tee kapalana kaomuna Amalek. Siitumo manga kapalana kaomuna Elifas i Tana Edom, tee siitumo siwuluna Ada. ");
INSERT INTO wlo_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Siwuluna Rehuel anana Esau, amembali kapalana kaomuna Nahat, kapalana kaomuna Zerah, kapalana kaomuna Syama, tee kapalana kaomuna Miza. Siitumo manga kapalana kaomuna Rehuel i Tana Edom, tee siitumo siwuluna Basmat, bhawinena Esau. ");
INSERT INTO wlo_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Siwuluna Oholibama, bhawinena Esau, amembali kapalana kaomuna Yeus, kapalana kaomuna Yaelam, tee kapalana kaomuna Korah. Siitumo manga kapalana kaomuna Oholibama binti Ana, bhawinena Esau sumai. ");
INSERT INTO wlo_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Siitumo miana Esau, isarongiaka uka Edom, tee siitumo manga kapalana kaomuna manga. ");
INSERT INTO wlo_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","O siimo manga siwuluna Seir, miana asiliina momboorena i lipu incia sumai isarongiaka miana Hori: siitumo Lotan, Syobal, Zibeon, Ana, ");
INSERT INTO wlo_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Disyon, Ezer, tee Disyan. Siitumo siwuluna Seir momembalina manga kapalana kaomuna miana Hori i Tana Edom. ");
INSERT INTO wlo_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Manga anana Lotan: siitumo Hori tee Heman, sainamo witinaina bhawine Lotan o sarona Timna. ");
INSERT INTO wlo_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Manga anana Syobal: siitumo Alwan, Manahat, Ebal, Syefo, tee Onam. ");
INSERT INTO wlo_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Manga anana Zibeon: siitumo Aya tee Ana. Ana siimo mopokawaakana manga matana uwe masodho i inawu i tana matuu wakutuuna incia ajagani keledaina Zibeon, amana. ");
INSERT INTO wlo_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ana dhaangia samia anana umanena siitumo Disyon, tee samia anana bhawinena siitumo Oholibama. ");
INSERT INTO wlo_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Manga anana Disyon: siitumo Hemdan, Esban, Yitran, tee Keran. ");
INSERT INTO wlo_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Manga anana Ezer: siitumo Bilhan, Zaawan, tee Akan. ");
INSERT INTO wlo_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Manga anana Disyan: siitumo Us tee Aran. ");
INSERT INTO wlo_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Manga kapalana kaomuna miana Hori: siitumo kapalana kaomuna Lotan, kapalana kaomuna Syobal, kapalana kaomuna Zibeon, kapalana kaomuna Ana, ");
INSERT INTO wlo_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","kapalana kaomuna Disyon, kapalana kaomuna Ezer, tee kapalana kaomuna Disyan. Siitumo manga kapalana kaomuna miana Hori; mboo sumaimo manga sarona kaomu i Tana Seir. ");
INSERT INTO wlo_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Siimo manga raja moparintangina i Tana Edom, wakutuuna indapo dhaangia samia raja moparintana i bhawona miana Israel: ");
INSERT INTO wlo_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela bin Beor moparintangina i Edom, tee sarona kotana siitumo Dinhaba. ");
INSERT INTO wlo_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Samatena Bela, Yobab bin Zerah minaaka i Bozra amembali raja mobholosia. ");
INSERT INTO wlo_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Samatena Yobab, Husyam minaaka i lipuna miana Teman, amembali raja mobholosia. ");
INSERT INTO wlo_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Samatena Husyam, Hadad bin Bedad, motalona miana Midian i lipu Moab, amembali raja mobholosia, tee sarona kotana siitumo Awit. ");
INSERT INTO wlo_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Samatena Hadad, Samla minaaka i Masreka amembali raja mobholosia. ");
INSERT INTO wlo_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samatena Samla, Saul minaaka i Rehobot modhaangiana i bhiwina umala, amembali raja mobholosia. ");
INSERT INTO wlo_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Samatena Saul, Baal-Hanan anana Akhbor amembali raja mobholosia. ");
INSERT INTO wlo_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Samatena Baal-Hanan bin Akhbor, Hadar amembali raja mobholosia, tee kotana sarona Pahu. Bhawinena sarona Mehetabeel anana Matred binti Mezahab. ");
INSERT INTO wlo_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Siimo sarona manga kapalana siwuluna Esau mboomo kaomuna tee tampa mbooresana manga, sumbesumbere tee sarona manga: kapalana kaomuna Timna, kapalana kaomuna Alwa, kapalana kaomuna Yetet, ");
INSERT INTO wlo_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","kapalana kaomuna Oholibama, kapalana kaomuna Ela, kapalana kaomuna Pinon, ");
INSERT INTO wlo_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","kapalana kaomuna Kenas, kapalana kaomuna Teman, kapalana kaomuna Mibzar, ");
INSERT INTO wlo_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","kapalana kaomuna Magdiel, tee kapalana kaomuna Iram. Siitumo manga kapalana kaomuna Edom, mboomo tampa mbooresana manga i tana pewauana manga. Siitumo Esau, opuopuana miana Edom. ");
INSERT INTO wlo_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yakub amboore i lipu mbooresana amana amembali dhaga, siitumo i Tana Kanaan. ");
INSERT INTO wlo_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","O siimo tulatulana siwuluna Yakub. Wakutuuna Yusuf dhaangia mangura, 17 tao umuruna, incia amananea awulu kadhambaaka gulumana bhembe dumba apobhawa tee manga witinaina. Incia apoose tee manga anana Bilha tee Zilpa, rua miaia bhawinena amana. Tee Yusuf sadia apakawaaka lele madhaki to manga witinaina i amana. ");
INSERT INTO wlo_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Israel atolabhi kaasina tee Yusuf minaaka i bhari-bharia anana mosagaanana, roonamo Yusuf molaahirina i wakutuuna incia amancuanamo. Incia atumpua mamudhaakana akarajaakamea satuwu juba momakesana mpuu. ");
INSERT INTO wlo_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Wakutuuna manga witinaina akamatea ande amana manga alabhi amaasiaka Yusuf minaaka i bhari-bharia witinaina, sumaimo manga incia uka amarikaia tee inda apogauakea malape. ");
INSERT INTO wlo_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Saangu wakutuu Yusuf apongipi, kasiimpo incia apetulatulaakea o pongipina sumai i manga witinaina. Sabutuna manga witinaina ahandamo amarikaia. ");
INSERT INTO wlo_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Apogaumo Yusuf i manga incia, \"Rangoa pongipiku sii. ");
INSERT INTO wlo_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Kamataana ingkita tangasaana tabhoke manga kancena gandum i inawu. Saanampuu kancena gandumku akakaro amakate kasiimpomo aumbamo manga kancena gandummiu atiingi kancena gandumku tee asuju ahoromati.\" ");
INSERT INTO wlo_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Pogauna manga witinaina i incia, \"Indapo uka gaumu bheumembali raja to ingkami? Ingkoo usombo mpuu-mpuu tee ufikiri bheumangakuasai!\" Jadi, manga incia ahandamo mpuu amarikaia roonamo pongipina tee pogauna sumai. ");
INSERT INTO wlo_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Sapadhana incia sumai, Yusuf apongipimo uka saangu pongipi mosagaanana, kasiimpomo apetulatulaakamea uka i manga witinaina, pogauna, \"Rangoa, kupongipimo uka. Atokamatamo matanaeo, bula, tee sapulu sambaa kalipopo asuju ahoromatiaku.\" ");
INSERT INTO wlo_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Maka wakutuuna Yusuf apetulatulaaka pongipina sumai i amana tee manga witinaina, amana audhaniakea tee apogau, \"Pongipi opea siitu? Indapo uka iaku, inamu, tee manga witinaimu bheaumba asuju tee ahoromatiko?\" ");
INSERT INTO wlo_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Sumaimo manga witinaina akaura-uramo, maka amana adhikaia hali incia sumai i nuncana ngangarandana. ");
INSERT INTO wlo_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Saangu wakutuu manga witinaina Yusuf alingka ajagani gulumana bhembe dumbana amana manga i saripina Sikhem. ");
INSERT INTO wlo_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Kasiimpo Israel apogaumo i Yusuf, \"Manga witinaimu tangasaana ajagani gulumana bhembe dumba i saripina Sikhem. Maipo, bhekutumpuko ulingka upokawaaka manga incia.\" Alawanimo Yusuf, \"Umbe, Uma.\" ");
INSERT INTO wlo_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Apogaumo uka i Yusuf, \"Lingka tee kamatea kadhaangiana manga witinaimu tee bhari-bharia gulumana bhembe dumba. Sapadhana incia sumai, mbulimo tee pakoleleakaaku.\" Kasiimpo atumpumea Yusuf alingka alaloi Mbolongana Hebron. Yusuf uka akawamo i Sikhem. ");
INSERT INTO wlo_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Iwe sumai, incia alipa mai i tana mokorumpu, kasiimpo apokawa tee samia umane moabhana i incia, \"Opea ipeelomu?\" ");
INSERT INTO wlo_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Lawanina, \"Kupeelo manga witinaiku. Tulungi paumbaakaaku iapai manga ajagani kadhambaakana.\" ");
INSERT INTO wlo_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Mia incia sumai apogau, \"Manga incia adhencumo minaaka iwe sii, roonamo kurangoa manga apogau, 'Maimo talingkaaka i Dotan.' Sabutuna alingkamo Yusuf atutunia, kasiimpo apokawaakamo manga witinaina i Dotan. ");
INSERT INTO wlo_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Wakutuuna incia dhaangiapo amaridho, manga witinaina akamatamea. Maka wakutuuna Yusuf indapo amakasumea, manga incia padhamo apomufakati to apekamatea. ");
INSERT INTO wlo_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Apogaumo manga samia tee sagaanana, \"Kamatea pande pongipi aumbamo! ");
INSERT INTO wlo_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Sii-sii, maimo tapekamatea, kasiimpomo tabhanaka maeatina i nuncana sala saangu sumu iwe sii. Kasiimpo tapogauakamo ande incia akandea binata masega. Dhaampo takamatea, opea bhemomembalina tee manga pongipina sumai!\" ");
INSERT INTO wlo_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Maka wakutuuna Ruben arango hali incia sumai, incia aʼusaha apasalaamati Yusuf minaaka i limana manga incia, pogauna, \"Bholi tapekamatea!\" ");
INSERT INTO wlo_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Ruben apogau uka i manga incia, \"Bholi ubusakaakea raa, soo bhanakamo i nuncana sumu modhaangiana i tana matuu sii, maka bholi kia-kiaia.\" Incia ahaejati bheapasalaamatiaka Yusuf minaaka i limana manga witinaina tee apambulia pendua i amana. ");
INSERT INTO wlo_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Jadi, mboo sumai Yusuf akawa i tampana manga witinaina, manga incia arambasakea jubana, siitumo juba momakesana mpuu ipakena sumai. ");
INSERT INTO wlo_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Kasiimpo abhawamo incia tee abhanakea i nuncana saangu sumu inda mokouwena. ");
INSERT INTO wlo_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Sapadhana incia sumai, auncuramo manga to akande. Wakutuuna manga incia apatinda potontona, atiumbamo dhaangia saangu rombongana miana Ismail moumbana minaaka i Gilead. Untana manga incia sumai aulea manga polona kau rampa, mina balsam, tee polona kau mawondu to abhawea i Mesir. ");
INSERT INTO wlo_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Kasiimpomo apogaumo Yuda i manga witinaina, \"Opea labana ingkita tapekamate andita tee tabuniakea raana? ");
INSERT INTO wlo_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Maimo taasoa i miana Ismail sii. Bholi takia-kiaia, roonamo incia sii andita, saraa sadagi tee ingkita.\" Sumaimo, manga witinaina uka aundapia. ");
INSERT INTO wlo_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Wakutuuna manga dhaga miana Midian alalo, Yusuf ahelaia tee aangkea minaaka i nuncana sumu sumai, kasiimpomo aasoa i manga miana Ismail tee haragaana 20 tibha doi pera. Kasiimpomo manga mia sumai abhawamea i Mesir. ");
INSERT INTO wlo_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Wakutuuna Ruben ambuli pendua i sumu sumai, akamatea ande Yusuf indamo dhaangia i nuncana sumu. Lausakamo incia abhenci pakeana rampaakanamo amapii mpuu incana. ");
INSERT INTO wlo_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Incia ambulimo i manga witinaina tee apogau, \"Anana incia sumai indamo dhaangia uka! Opea to ipewauku sii-sii?\" ");
INSERT INTO wlo_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Kasiimpo, manga incia asumbelemo sambaa bhembe umane, kasiimpo aalamo jubana Yusuf tee apalondoa i nuncana raana bhembe. ");
INSERT INTO wlo_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Padha incia sumai, manga incia atumpu samia uka to abhawa juba momakesana mpuu i amana manga tee asamea, \"Ingkami tapotibhaaka juba incia sii. Parakisaaia, buaka sii jubana anana Uma atawa mencuana?\" ");
INSERT INTO wlo_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Yakub aparakisaamea, kasiimpomo apogau, \"Incia sii jubana anaku! Binata masega mokandea! Tantumo Yusuf padhamo apobhembaruakea o binata sumai!\" ");
INSERT INTO wlo_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Kasiimpomo Yakub abhencimo pakeana tee apakanamo kae kasara abhokea i tangana rampaakanamo amapii mpuu incana. Incia atangisia amangenge. ");
INSERT INTO wlo_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Bhari-bharia anana, malape umane atawa bhawine, aʼusahamo awujua, maka incia inda atowuju. Pogauna, \"Inda! Tee kasukaraku iaku bhekusapo kupokawa tee anaku i alamu manga mia momate.\" Mboo sumaimo Yusuf atangisia o amana. ");
INSERT INTO wlo_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Tangasaana incia sumai, i Tana Mesir, Yusuf aasoa o miana Midian i saao i Potifar, samia pagawena maligena Firaun, kapalana mojaganina raja Mesir. ");
INSERT INTO wlo_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Saangu wakutuu i zamani incia sumai, Yuda alingkamo abholi manga witinaina tee asiimo i samia Adulam mokosarona Hira. ");
INSERT INTO wlo_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Iwe sumai Yuda akamatamo samia anana bhawine minaaka i samia miana Kanaan asarongiakea Syua. Kasiimpo Yuda akobhawineakamo bhawine incia sumai tee aporomuakamea. ");
INSERT INTO wlo_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Bhawine sumai abhawa-bhawamo tee apalaahirimo samia ana umane, asarongiakea Er. ");
INSERT INTO wlo_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Kasiimpomo incia abhawa-bhawamo uka tee apalaahirimo samia ana umane asarongiakea Onan. ");
INSERT INTO wlo_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Sapadhana incia sumai, sampearopo uka incia apalaahiri samia ana umane, asarongiakea Syela. Manga incia amboore i Kezib wakutuu anana incia sumai atopalaahiri. ");
INSERT INTO wlo_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Amangenge sapadhana incia sumai, Yuda aalamo samia bhawine to Er, anana tumpe. Sarona bhawine incia sumai o Tamar. ");
INSERT INTO wlo_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Maka Er, ana tumpena Yuda sumai, amadhaki i matana KAWASANA OPU, sabutuna KAWASANA OPU aalamo inyawana. ");
INSERT INTO wlo_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Kasiimpomo Yuda apogau i Onan, \"Umataua adatimami apawaajibuaka samia witinai umane adhawuaka siwulu to witinaina momatena. Sabutuna, kawimo tee bhawinena o akamu, tee poromuakamea sababuna ingkoomo andina momatena, mamudhaakana udhawu siwulu to akamu.\" ");
INSERT INTO wlo_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Maka, Onan amataua ande siwuluna sumai naile itu inda bheamembali pewauana. Jadi sadiamo ande aposaangu tee bhawinena akana sumai, abhanakea o uwena manina i tana. Incia amendeu adhawu siwulu to akana. ");
INSERT INTO wlo_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Opea ipewauna sumai amadhaki i matana KAWASANA OPU, saanampuu KAWASANA OPU aalea uka inyawana. ");
INSERT INTO wlo_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Kasiimpomo Yuda apogaumo i Tamar, ana maniana, \"Mbooremo mboomo iaiaro i bhanuana amamu sampe anaku Syela padhamo akoʼumuru to akawi,\" roonamo fikirina Yuda, \"Ancosala incia uka amate mboomo manga akana.\" Sumaimo, Tamar alingkamo tee amboore i bhanuana amana. ");
INSERT INTO wlo_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Sapadhana pia-pia wakutuu kangengena, amatemo ana bhawinena Syua, bhawinena Yuda. Sapadhana Yuda auntomo kasukarana incana, incia alingkamo i tampana manga mia moguntina buluna manga dumbana i Timna, apobhawa tee Hira, sabhangkana, miana Adulam. ");
INSERT INTO wlo_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Kasiimpo, apakoleleakea i Tamar, \"Mataua, ama maniamu tangasaana alingka aporope i Timna to agunti buluna manga dumbana.\" ");
INSERT INTO wlo_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Sumaimo, Tamar uka aaronia pakea iaiarona, atutubhia rouna tee asalibumbu karona mamudhaakana o mia inda amataua incema incia. Kasiimpomo alingka i kampo Enaim, modhaangiana i dhalana moporopena i Timna. Iwe sumai auncura i bhambana lawana kampo sumai. Hali incia sumai apewaua roonamo incia akamatea ande Syela padhamo akoʼumuru to akawi, maka Tamar inda uka adhawuakea to apamembalia bhawinena. ");
INSERT INTO wlo_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Wakutuuna Yuda akamatea, asarongia ande bhawine incia sumai satotuuna bhawinena dhala, rampaakanamo atutubhia rouna. ");
INSERT INTO wlo_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Kasiimpomo, incia asarimo bhawine incia sumai i saripina dhala tee apogau, \"Maimo iaku gauku kukole tee ingkoo,\" roonamo incia inda amataua ande bhawine incia sumai ana maniana. Pogauna bhawine incia sumai, \"Opea bheudhawuaku ande ukole tee iaku?\" ");
INSERT INTO wlo_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Lawanina, \"Dhaampomo kulambokoakako sambaa anana bhembe minaaka i gulumana bhembe dumbaku.\" Apogaumo bhawine incia sumai, \"Somanamo udhawuaku bara mokoharagaa sampe ulambokoa to iaku.\" ");
INSERT INTO wlo_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Aabhamo, \"Bara mokoharagaa opea tabeana idhawuakaku to ingkoo?\" Lawanimo bhawine sumai, \"Singkaru materaimu, rantemu, tee katuko modhaangiana i limamu itu.\" Sumaimo, adhawuakamea bhari-bharia sumai i incia, kasiimpo aporomuakea. Bhawine incia sumai uka abhawa-bhawamo minaaka i incia. ");
INSERT INTO wlo_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Sapadhana incia sumai, abhangumo bhawine sumai, kasiimpo alingka. Aaronimea katutubhina rouna tee apakanamea pendua pakea iaiarona. ");
INSERT INTO wlo_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Yuda alambokomo anana bhembe ijanjiakana alaloi sabhangkana, miana Adulam sumai, to aalea pendua manga bara mokoharagaa minaaka i limana bhawine sumai. Maka, sabhangkana sumai inda apotibhaaka bhawine sumai. ");
INSERT INTO wlo_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Incia apekaabha-abhamo i manga mia i tampa incia sumai, pogauna, \"Iapaimo bhawine pasunda ibaadati modhaangiana i saripina dhala i Enaim sumai?\" Lawanimo manga, \"Iwe sii inda dhaangia bhawine pasunda ibaadati i saripina dhala.\" ");
INSERT INTO wlo_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Sabutuna, ambulimo incia i Yuda tee apogau, \"Iaku inda kupotibhaakea. Tee uka, manga mia i tampa incia sumai apogau, 'Iwe sii inda dhaangia bhawine pasunda ibaadati.\" ");
INSERT INTO wlo_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Apogaumo Yuda, \"Taroakamo manga bara incia sumai aalea, mamudhaakana ingkita inda amembali giu ipotawaaka. Satotuuna, padhamo kulambokoakea anana bhembe incia sii, maka ingkoo inda upotibhaakea.\" ");
INSERT INTO wlo_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Kera-kera talu mbula sapadhana incia sumai apakoleleakamea i Yuda, \"Tamar, ana maniamu, apasunda. Mataumea, incia uka abhawa-bhawa rampaakanamo pasundana sumai.\" Yuda apogaumo, \"Bhawamea incia iwe sii, taroakamo incia atunua!\" ");
INSERT INTO wlo_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Tangasaana incia apalimbaia, incia atumpumo mia apakawaaka kasamea i ama maniana, \"Minaaka i umane mokobarana siimo kubhawa-bhawa.\" Kasameana uka, \"Parakisaia, incema buaka mokosingkaruna materai, rante tee katuko sii?\" ");
INSERT INTO wlo_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yuda aparakisaamo manga bara incia sumai, kasiimpo apogau, \"Mencuana iaku, maka bhawine incia sumaimo mototuuna, roonamo iaku inda kudhawuakea i Syela, anaku.\" Apepuumo incia sumai, Yuda indamo aporomu tee bhawine incia sumai uka. ");
INSERT INTO wlo_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","I wakutuuna bhawine incia sumai bheapalaahiri, amataua ande anana rapi i nuncana kadhumana. ");
INSERT INTO wlo_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Wakutuuna incia apalaahiri, samia minaaka i manga anana alimba porikana limana. Bhisa koana aalamo saramba kambari maleʼi matuʼa kasiimpomo abhokeaka i limana anana sumai tee apogaumo, \"O siimo molimbana porikana.\" ");
INSERT INTO wlo_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Maka anaana sumai ahelaia pendua limana, kasiimpomo alimbamo o rapina. Pogaumo bhisa sumai, \"Makaa mpuu ingkoo ujumpuraka karomu ulimba!\" Sababuna sumai incia asarongiakea Peres. ");
INSERT INTO wlo_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Padha incia sumai, kasiimpomo alimba o rapina, modhaangiana kambari maleʼi matuʼa i limana, kasiimpomo incia asarongiakea Zerah. ");
INSERT INTO wlo_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Tangasaana incia sumai Yusuf abhawea i Mesir. Kasiimpomo, Potifar, pagawena maligena Firaun tee kapalana mojaganina raja, samia miana Mesir, aali Yusuf minaaka i limana miana Ismail mobhawea iwe sumai. ");
INSERT INTO wlo_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","KAWASANA OPU apoose tee Yusuf sabutuna incia amembali samia mokohasilina i nuncana karajaana. Incia amboore i bhanuana opuna, miana Mesir sumai. ");
INSERT INTO wlo_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Opuna akamatea ande Aulataʼala apoose tee Yusuf tee ande KAWASANA OPU apewaua sagala giu ikarajaana akohasili. ");
INSERT INTO wlo_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Sababuna, incia apeelu Yusuf tee aundaakea to alaiania. Incia uka apatugasiaka Yusuf to moʼatorona bhanuana tee sagala giu pewauana apasarakaakamea i nuncana kuasana Yusuf. ");
INSERT INTO wlo_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Wakutuuna Yusuf apatugasiakea to moʼatorona bhanuana tee sagala pewauana KAWASANA OPU abarakatia antona bhanuana miana Mesir sumai roonamo Yusuf. Kabarakatina KAWASANA OPU ataralabhi-labhi i sagala pewauana, malape modhaangiana i nuncana bhanua atawa modhaangiana i inawu. ");
INSERT INTO wlo_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Sumaimo, incia apasarakaakamea bhari-bharia pewauana i nuncana kuasana Yusuf, tee kahambana Yusuf incia indamo afaraluu afikiriaka opeopeapo uka, sambaliakana kinande to ikandena. Yusuf satotuuna samia amangada poningkarona tee amakesa rouna. ");
INSERT INTO wlo_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Sapadhana pia-pia wakutuu kangengena, bhawinena Potifar, opuna, akamatamo Yusuf tee abirahi, kasiimpo apogau, \"Maimo, kolemo tee iaku.\" ");
INSERT INTO wlo_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Maka, Yusuf amendeu tee apogau i bhawinena opuna sumai, \"Satotuuna, tee kahambaku opuku sumai inda afaraluu afikiriaka opeopeapo uka i bhanua sii. Sagala giu pewauana apasarakaakamea i nuncana kuasaku. ");
INSERT INTO wlo_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","I nuncana bhanua sii inda dhaangia samia uka molabhina kaogena kuasana minaaka i iaku, tee opuku inda ataangi opeopeapo uka minaaka i iaku, tabeana bhawinena opuku. Tuaapa amembali kupewau kadhaki momaogena sii tee kukodosa i aroana Aulataʼala?\" ");
INSERT INTO wlo_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Jadi, moomini incia awuju Yusuf saeo-saeo, Yusuf amendeu aperangoia kawujuna to akole tee incia, tee uka inda aunda apooseakea. ");
INSERT INTO wlo_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Saangu wakutuu, Yusuf apesua i nuncana bhanua to apewau karajaana. Inda samia uka modhaangiana i nuncana bhanua wakutuu incia sumai. ");
INSERT INTO wlo_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Kasiimpo, bhawine incia sumai akenimo jubana Yusuf apoose apogau, \"Maimo, kole tee iaku!\" Maka, Yusuf abholia jubana i limana bhawine sumai, kasiimpomo abuntuli i sambali. ");
INSERT INTO wlo_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Wakutuuna bhawine sumai akamatea ande Yusuf abholi jubana i limana tee abuntuli i sambali, ");
INSERT INTO wlo_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","agoraakamea saangua antona bhanuana. Pogauna i manga incia, \"Kamatea, umaneku abhawamea i ingkita samia Ibrani to amagamagasiaaka ingkita! Incia apesua to akole tee iaku, maka kupekee tee suara makaa. ");
INSERT INTO wlo_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Wakutuu arangoa kupekee tee suara makaa, abholimea jubana i iaku kasiimpomo abuntuli i sambali.\" ");
INSERT INTO wlo_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Bhawine sumai adhika jubana Yusuf i saripina sampe opuna ambuli i bhanua. ");
INSERT INTO wlo_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Kasiimpo, bhawine sumai apetulatulaakamo i Potifar, onina, \"Bhatua Ibrani ibhawamu to ingkita sumai aumba i iaku to amagamagasiaakaaku. ");
INSERT INTO wlo_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Maka, wakutuuna kupekee tee suara makaa, abholimea jubana i iaku, kasiimpo abuntuli i sambali.\" ");
INSERT INTO wlo_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Sapadhana Potifar arango pogau ipakawaakana bhawinena i incia, \"Mboo sumaimo bhatuamu apewauaku,\" sumaimo Potifar aʼamaramo mpuu. ");
INSERT INTO wlo_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Yusuf uka aalamea o opuna, kasiimpo apapesuaia i nuncana katorongku, tampana manga mia itorongkuna raja atotaangi. Sabutuna atorongkumea Yusuf iwe sumai. ");
INSERT INTO wlo_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Maka, KAWASANA OPU apoose tee Yusuf tee asusuakea kaasina to incia. Incia apewau kapalana katorongku sumai amaasiakea o Yusuf. ");
INSERT INTO wlo_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Kasiimpo, kapalana katorongku sumai apasarakaakamea bhari-bharia mototaangina i nuncana katorongku sumai asaronakaakamea i Yusuf. Sagala giu motokarajaana iwe sumai, Yusuf mokarajaaia. ");
INSERT INTO wlo_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Kapalana katorongku sumai indamo afaraluu uka aʼurusu sagala giu mopadhana ikenina Yusuf, sababuna KAWASANA OPU apoose tee Yusuf tee apamembalia opea ikarajaakana akohasili. ");
INSERT INTO wlo_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Pia-pia wakutuu sapadhana manga kajadia incia sumai, mopasiapuakana sumpua tee mopasiapuakana rotina raja Mesir apewau alapaa i opuna manga, rajana Mesir. ");
INSERT INTO wlo_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Sabutuna, aʼamaramo Firaun i ruamiaia pagawena maligena sumai, siitumo i kapalana mopasiapuakana sumpua tee kapalana mopasiapuakana rotina. ");
INSERT INTO wlo_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Incia apapesuamea manga i nuncana katorongku i bhanuana kapalana mokawalana raja, sumaimo i nuncana katorongku tampana Yusuf atotorongku. ");
INSERT INTO wlo_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Kasiimpomo kapalana mojaganina raja apamembali Yusuf bhatuana manga to alaiania. Manga incia atotaangi i nuncana katorongku kangengena pia-pia wakutuu. ");
INSERT INTO wlo_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Saangu wakutuu, i malo mopokana, mopasiapuakana sumpua tee mopasiapuakana rotina raja Mesir mototaangina i nuncana katorongku sumai apongipi. Pongipina manga sumbesumbere aposala maʼanana. ");
INSERT INTO wlo_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Saeona, wakutuuna Yusuf aumba apokawaaka manga incia tee alaiania, mboo mpuu manga tangasaana amarewu incana. ");
INSERT INTO wlo_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Sabutuna, aabhamo Yusuf i manga pagawena maligena Firaun mopobhawa-bhawana tee incia i nuncana katorongku i bhanuana opuna sumai, \"Pokia roumiu amauru o eo sii?\" ");
INSERT INTO wlo_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Manga incia alawanimo, \"Ingkami tapongipi, maka inda dhaangia samia uka momembalina momaʼanaia.\" Yusuf apogaumo i manga incia, \"Maʼanana pongipi asalana minaaka i Aulataʼala! Petulatulaakea o pongipi sumai i iaku.\" ");
INSERT INTO wlo_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Kasiimpomo, kapalana mopasiapuakana sumpua apetulatulaakamo pongipina i Yusuf, pogauna, \"I nuncana pongipiku sumai atokamata saangu puuna angguru i aroaku. ");
INSERT INTO wlo_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Puuna angguru sumai akoraha talu angu. Mboo sumai puuna kau sumai akotuna, kambana lausaka atuwu tee kancena uka apalimba bhakena angguru momasasa. ");
INSERT INTO wlo_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","I wakutuuna incia sumai tondena Firaun dhaangia i limaku. Kasiimpomo manga bhakena angguru sumai kualea tee kupioa i nuncana tondena Firaun. Sapadhana incia sumai, kudhawuaka tonde sumai i limana Firaun.\" ");
INSERT INTO wlo_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Pogauna Yusuf i incia, \"O siimo maʼanana pongipimu: Talu raha sumai maʼanana talu eo. ");
INSERT INTO wlo_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","I nuncana talu eo sii, Firaun bheapekalangako; incia bheapalimbako tee apambuliko i kauncuramakamu. Ingkoo bheumbuli udhawuaka tonde i limana Firaun, mboomo kananea ipewaumu i piamo itu, wakutuuna upasiapuaka sumpuana. ");
INSERT INTO wlo_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Maka udhaniaku ande kadhaangiamu amalapemo naile itu tee upewau iaku tee kaasi. Petulatulaakamea o kadhaangiaku i Firaun tee tulungi palimbaaku minaaka i katorongku sii. ");
INSERT INTO wlo_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Roonamo satotuuna iaku sii amanakoaku minaaka i lipuna miana Ibrani, tee iwe sii uka iaku indapo mina kupewau saangu uka isababuakana iaku alaenga apapesuaaku i nuncana katorongku sii.\" ");
INSERT INTO wlo_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Wakutuuna kapalana mopasiapuakana roti akamata ande maʼanana pongipi sumai amalape, apogaumo incia i Yusuf, \"Iaku uka kupongipi: Atokamata talu bhaki roti i bhawona bhaaku. ");
INSERT INTO wlo_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","I nuncana bhaki moporibhawona dhaangia sagala giu kinandena Firaun ikarajaana mopasiapuakana roti, maka manga manu-manu akandea minaaka i bhaki modhaangiana i bhawona bhaaku sumai.\" ");
INSERT INTO wlo_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Lawanimo Yusuf, \"Siimo maʼanana minaaka i pongipimu: Talu bhaki sumai maʼanana talu eo. ");
INSERT INTO wlo_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","I nuncana talu eo sii, Firaun bheapekalangako, i tampa malanga, tee aloeko i saangu arii, kasiimpo manu-manu bheakande dagina badamu.\" ");
INSERT INTO wlo_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","I eo talu eona, sumaimo eo laahiriana Firaun, Firaun apadhaangiamo kariaa to bhari-bharia pagawena. Incia apekalanga kapalana mopasiapuakana sumpua tee kapalana mopasiapuakana roti i aroana manga pagawena: ");
INSERT INTO wlo_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","incia apambulimo kauncuramakana i kapalana mopasiapuakana sumpua mamudhaakana amembali ambuli pendua adhawuaka tonde i limana Firaun; ");
INSERT INTO wlo_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","maka kapalana mopasiapuakana roti aloemea, mboomo mopadhana imaʼanaiakana Yusuf i manga incia. ");
INSERT INTO wlo_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Teemini mboo sumai, kapalana mopasiapuakana sumpua indamo audhani Yusuf sampeampearo. Incia amalinguakamea. ");
INSERT INTO wlo_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Satolalona rua tao, Firaun apongipi. I nuncana pongipina, incia tangasaana akabhale-bhale i saripina Umala Nil. ");
INSERT INTO wlo_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Saanampuu minaaka i Umala Nil atiumbamo pitu mbaa sapi momakesana modelena tee amalompo badana, kasiimpomo manga sapi sumai apepuumo akande manga rumpu i saripina umala sumai. ");
INSERT INTO wlo_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Padha incia sumai, atiumbamo uka pitu mbaa sapi sagaanana minaaka i Umala Nil, amadhaki modelena tee amangkuru badana, kasiimpo manga sapi sumai akakaro i saripina manga sapi mosagaanana, i saripina Umala Nil sumai. ");
INSERT INTO wlo_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Kasiimpomo, manga sapi momadhakina modelena tee momangkuruna sumai akande pitu mbaa sapi momalapena modelena tee momalompona i saao. Kasiimpo, abhangumo Firaun. ");
INSERT INTO wlo_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Firaun atokolemo pendua tee apongipimo uka to rua mpearo. Atokamatamo pitu kancena gandum momasasana tee momalapena tuwuna i sapale laena. ");
INSERT INTO wlo_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Inda mangenge sapadhana incia sumai, atuwu uka pitu kancena gandum momangkuruna tee amalau rampaakanamo ngaluna timbu. ");
INSERT INTO wlo_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Kasiimpo, pitu kancena momangkuruna sumai adhoku pitu kancena momalompona tee momasasana. Firaun uka abhangumo pendua tee asadaramo ande incia apongipi! ");
INSERT INTO wlo_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Saeona incana alilahomo. Atumpumo mia akembaia bhari-bharia ahalii nujumu i Mesir tee bhari-bharia mia momakidha, kasiimpo apetulatulaakamo pongipina i manga incia. Maka, inda dhaangia samia uka momembalina momaʼanaiakea i Firaun. ");
INSERT INTO wlo_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Kasiimpo, apogaumo kapalana mopasiapuakana sumpua i Firaun, pogauna, \"O eo sii bhatuamu atoudhani alapaaku. ");
INSERT INTO wlo_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","I piamo itu Firaun aʼamara i manga pagawena, kasiimpomo bhatua tee kapalana mopasiapuakana roti apapesuaia i nuncana katorongku i bhanuana kapalana mojaganina raja. ");
INSERT INTO wlo_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","I malo mopokana, ingkami, siitumo bhatua tee sabhangkana bhatua sumai, apongipi. Pongipimami akomaʼanana samia-samia. ");
INSERT INTO wlo_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Iwe sumai ingkami tapobhawa tee samia umane mangura miana Ibrani, bhatuana kapalana mojaganina raja. Kasiimpomo, ingkami tapetulatulaaka pongipimami i incia, tee incia uka amaʼanaiakamea pongipimami samia-samia. ");
INSERT INTO wlo_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Garaaka, atotuu mboomo imaʼanaiakana i ingkami, mboomo sumai momembalina. Bhatua apambulia i kauncuramakana bhatua, tee kapalana mopasiapuakana roti sumai atoloe.\" ");
INSERT INTO wlo_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Sabutuna, Firaun atumpumo mia akemba Yusuf, tee lausakamo incia apalimbaia minaaka i katorongku. Sapadhana apogunti tee abholosi pakeana, apesuamo incia i aroana Firaun. ");
INSERT INTO wlo_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Apogaumo Firaun i Yusuf, \"Iaku kupongipi, maka inda dhaangia samia uka momembalina momaʼanaiakea. Kasiimpo, kurango lele to ingkoo mopogauakana ande wakutuu ingkoo urango saangu pongipi, umembali lausaka umaʼanaiakea.\" ");
INSERT INTO wlo_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Alawanimo Yusuf i Firaun, \"Mencuana bhatua, tabeana Aulataʼala bhemodhawuakana kalawani, to kasanaana Firaun.\" ");
INSERT INTO wlo_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Apogaumo Firaun i Yusuf, \"I nuncana pongipiku sumai, iaku tangasaana kukabhale-bhale i saripina Umala Nil. ");
INSERT INTO wlo_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Saanampuu minaaka i Umala Nil atiumbamo pitu mbaa sapi momakesana modelena tee amalompo badana, kasiimpomo manga sapi sumai apepuumo akande manga rumpu i saripina umala sumai. ");
INSERT INTO wlo_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Sapadhana sumai, atiumbamo uka pitu mbaa sapi mosagaanana, momarusuna, momadhakina mpuu modelena tee amangkuru badana. Indapo mina kukamata o kadhakina sapi incia sumai i saangua Tana Mesir. ");
INSERT INTO wlo_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Kasiimpomo, manga sapi momangkuruna tee momadhakina sumai akande pitu mbaa sapi momalompona mobhaa-bhaana. ");
INSERT INTO wlo_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Sapi-sapi incia sumai uka apesua i nuncana kompona manga. Maka, inda atokamata tandana opea uka ande manga sapi incia sumai padhamo apesua i nuncana kompona manga roonamo modelena manga sadhaadhaana amadhaki mboomo bhaa-bhaana. Kasiimpo, iaku uka kutobhangumo. ");
INSERT INTO wlo_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","I nuncana pongipiku motutuniana atiumba pitu kancena gandum momasasana tee momalapena tuwuna i sapale laena. ");
INSERT INTO wlo_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Sapadhana incia sumai, atuwumo uka pitu kance gandum momatuuna, momangkuruna, tee amalau rampaakanamo ngaluna timbu. ");
INSERT INTO wlo_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Kasiimpo, kance momangkuruna sumai adhoku pitu kance momalapena. Bhari-bharia sii padhamo kupetulatulaakea i manga ahalii nujumu, maka inda dhaangia samia uka momembalina apaumbaakaaku maʼanana.\" ");
INSERT INTO wlo_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Sarangona pongipina sumai, apogaumo Yusuf i Firaun, \"Manga pongipina Firaun sumai apokana. Aulataʼala padhamo apaumbaakea i Firaun opea bheipewauna naile itu. ");
INSERT INTO wlo_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Pitu mbaa sapi momalapena sumai maʼanana pitu tao, tee pitu kance gandum momalapena sumai uka maʼanana pitu tao. Jadi rua angu pongipina sumai apokana. ");
INSERT INTO wlo_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Pitu mbaa sapi momangkuruna tee momadhakina motiumbana, sumaimo maʼanana pitu tao, mboo sumai uka pitu kancena gandum momaapana tee amalau rampaakanamo ngaluna timbu sumai, maʼanana bheakawamo kanarakaa pitu tao kasukarana kaara. ");
INSERT INTO wlo_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","O siimo maʼanana minaaka i bhatuamu ipakawaakaku i saao to Firaun, siitumo ande Aulataʼala padhamo apakawaakea i Firaun opea bheipewauna naile itu. ");
INSERT INTO wlo_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Satotuuna, bheaumba pitu tao tee hasilina motaralabhi-labhina momaogena i saangua Tana Mesir, ");
INSERT INTO wlo_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","maka padha incia sumai atiumbamo kanarakaa pitu tao kasukarana kaara. Bhari-bharia motaralabhi-labhina dhaangiamo i Tana Mesir bheatomalinguakamo, tee kanarakaa kasukarana kaara sumai bheapepadhai lipu incia sii. ");
INSERT INTO wlo_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Motaralabhi-labhina padhamo anamisia i lipu incia sii indamo bheaudhania uka roonamo kanarakaa kasukarana kaara moumbana sapadhana incia sumai amakaa mpuu. ");
INSERT INTO wlo_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Pongipina sumai apenduangia sampe rua mpearo i Firaun. Maʼanana satotuuna ande hali incia sumai padhamo apatotapuakea Aulataʼala tee Incia bhealausaka apewaua. ");
INSERT INTO wlo_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Sabutuna, salabhina Firaun apeelo samia momakidhana tee mokohikimatina sii-sii, tee aangkea to moparintangina Tana Mesir. ");
INSERT INTO wlo_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Kasiimpomo, salabhina ande Firaun apatotapuakamo manga gubernuru i bhawona lipu sii to alaaka 20 parasee minaaka i hasilina Tana Mesir i nuncana pitu tao motaralabhi-labhina. ");
INSERT INTO wlo_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Manga incia tabeana aromusakea bhari-bharia giuna kinande i nuncana tao-tao malape moumbana sii tee aromusakea gandum i tambena kuasana Firaun mboomo giuna kinande i manga kota, tee ajagania. ");
INSERT INTO wlo_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Giuna kinande sumai bheamembali apasandataakea to lipu sii i nuncana pitu tao kanarakaa kasukarana kaara bhemoumbana i Tana Mesir, mamudhaakana lipu sii inda abinasa roonamo kasukarana kaara sumai.\" ");
INSERT INTO wlo_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Haejatina sumai amalape to Firaun tee bhari-bharia pagawena. ");
INSERT INTO wlo_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Kasiimpomo apogaumo Firaun i manga pagawena, \"Tapotibhaaka ingkita tapokawaaka mia mboo sii, mobukena tee Rohina Aulataʼala?\" ");
INSERT INTO wlo_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Kasiimpomo Firaun apogaumo i Yusuf, \"Roonamo Aulataʼala padhamo apatiumbaakako bhari-bharia hali incia sii, tantumo inda dhaangia mia momakidhana tee mokohikimatina mboomo ingkoo. ");
INSERT INTO wlo_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Bheuparintangi i maligeku, tee bhari-bharia raʼeatiku tabeana atungku i pamarintamu. Tangkanamo mahakota incia sii mopamembalina iaku atolabhi kaogena minaaka ingkoo.\" ");
INSERT INTO wlo_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Apogaumo Firaun uka i Yusuf, \"Tee mboo sii kuangkako to moparintangina bhari-bharia Tana Mesir.\" ");
INSERT INTO wlo_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Kasiimpomo Firaun ahobutimo singkaru minaaka i limana tee apakanaakea i limana Yusuf. Apakanaakea uka pakea minaaka i kae moʼalusuna i Yusuf, tee apasaakea rante bulawa i bhorokona. ");
INSERT INTO wlo_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Atumpumea mia sumai apakompaia Yusuf i bhawona karetana moruanguna, tee i aroana Yusuf dhaangia samia to agoramo, \"Sujumo!\" Mboo sumaimo Yusuf adhawuakea kakuasa i bhawona saangua Tana Mesir. ");
INSERT INTO wlo_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Firaun apogaumo i Yusuf, \"Iakumo Firaun, maka ande inda uundaakea, inda samia uka amembali apewau sala saangu i saangua Tana Mesir sii.\" ");
INSERT INTO wlo_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Firaun adhawuakea sarona Mesir Zafnat-Paaneah i Yusuf, tee adhawuakea i incia Asnat, anana Potifera, imamu i On, to amembali bhawinena. Mboo sumaimo Yusuf amembalimo mokokuasana i bhawona saangua Tana Mesir. ");
INSERT INTO wlo_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Yusuf akoʼumurumo 30 tao wakutuu incia akakaro i aroana Firaun, raja Mesir. Kasiimpomo Yusuf alingka minaaka i aroana Firaun tee ambelikia saangua Tana Mesir. ");
INSERT INTO wlo_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Kangengena pitu tao tee hasilina taralabhi-labhi sumai, lipu incia sumai akohasiliaka timpua sabuke-bukena. ");
INSERT INTO wlo_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Yusuf aromusakea bhari-bharia giuna kinande i nuncana pitu tao ataralabhi-labhi i Tana Mesir sumai, tee aromusakea i kota-kota. I sumbesumbere kota aromusakea giuna kinande, hasilina minaaka i manga inawu atiingia kota sumai. ");
INSERT INTO wlo_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Mboo sumaimo Yusuf aromusaka gandum mboomo kabharina bhone i tawo, abhari mpuu, sabutuna auntomo agagari saopea kabharina. ");
INSERT INTO wlo_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Indapo aumba tao kaarana, o Asnat (anana Potifera, imamu i On) apalaahiriakana to Yusuf, umanena, rua mia anana umane. ");
INSERT INTO wlo_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yusuf asarongiakea anana tumpena Manasye, roonamo pogauna, \"Aulataʼala padhamo apewau kumalinguakea sagala kasukaraku tee bhanuana amaku.\" ");
INSERT INTO wlo_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Sainamo anaana katutunina tumpe asarongiakea Efraim, roonamo pogauna, \"Aulataʼala padhamo adhawuakaaku anana i lipu kasukaraku.\" ");
INSERT INTO wlo_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Kasiimpomo akoʼaahirimo pitu tao ataralabhi-labhi i Tana Mesir sumai, ");
INSERT INTO wlo_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","tee apepuumo aumba pitu tao kasukara kaara, mboomo padhana ipogauakana Yusuf. Kasukara kaara akanea bhari-bharia lipu, maka i saangua Tana Mesir sumai dhaangia kinande. ");
INSERT INTO wlo_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Wakutuuna kaara akana uka bhari-bharia raʼeatina Tana Mesir, agoramo manga incia i Firaun aemani kinande. Kasiimpomo apogaumo Firaun i manga incia bhari-bharia miana Mesir sumai, \"Lingkamo i Yusuf. Pewaumo opea ipogauakana i ingkomiu.\" ");
INSERT INTO wlo_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Kanarakaa kasukarana kaara sumai akanea saangua bhawona alamu. Yusuf abungkalea bhari-bharia manga kampiri kasiimpomo aasoa gandum to miana Mesir, roonamo ahanda mpuu kasukarana kaara sumai i Tana Mesir. ");
INSERT INTO wlo_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Manga mia minaaka i saangua alamu uka aumba i Mesir to aali gandum minaaka i Yusuf, roonamo ahanda mpuu kaara sumai i saangua alamu. ");
INSERT INTO wlo_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Yakub arangomo lele ande i Mesir dhaangia gandum. Sumaimo, apogaumo Yakub i manga anana, \"Pokia ingkomiu soo upotonto-tonto?\" ");
INSERT INTO wlo_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Apogaumo uka, \"Iaku kurango ande i Mesir dhaangia gandum. Lingkamo iwe sumai tee ualiaka gandum to ingkita minaaka iwe sumai, mamudhaakana ingkita amembali tadhadhi tee inda tamate.\" ");
INSERT INTO wlo_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Sabutuna, alingkamo sapulu mia witinaina Yusuf i Mesir to aaliaka gandum. ");
INSERT INTO wlo_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Sainamo Binyamin, andina Yusuf, inda aundaakea alingka tee manga akana sababuna fikirina Yakub, \"Ancosala acilaka.\" ");
INSERT INTO wlo_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Jadi, manga anana Israel dhaangia i tanga-tangana manga mia moposaumbana to aaliaka gandum, roonamo balaa kasukarana kaara sumai uka akangkanai Tana Kanaan. ");
INSERT INTO wlo_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Yusuf amembalimo mokokuasana i lipu incia sumai tee inciamo moasona gandum i bhari-bharia raʼeatina lipu incia sumai. Jadi, sakawana manga witinaina Yusuf iwe sumai, asujumo manga tee ahoromatia. ");
INSERT INTO wlo_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Wakutuuna Yusuf akamata manga witinaina, incia lausaka atandaia. Maka, incia dhaangiapo abuniaka karona amembali mboomo samia dhaga tee aʼamaraiki manga incia. Aabhamo i manga incia, \"Minaaka iapai ingkomiu?\" Lawanimo manga, \"Minaaka i Tana Kanaan, ingkami taumba bhetaali giuna kinande.\" ");
INSERT INTO wlo_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Moomini Yusuf amataua manga witinaina, manga incia inda amataua. ");
INSERT INTO wlo_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Saanampuu atoudhanimo Yusuf tee manga pongipina i piamo itu to manga incia. Kasiimpo, apogaumo i manga incia, \"Ingkomiu sii mata-mata! Ingkomiu uumba to umata-matai kakurangana lipu sii.\" ");
INSERT INTO wlo_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Alawanimo manga i Yusuf, \"Mencuana, opuku. Manga bhatuamu sii taumba to taali giuna kinande. ");
INSERT INTO wlo_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Ingkami bhari-bharia sii manga anana minaaka i saama, tee ingkami sii mia mojujuru. Manga bhatuamu sii mencuana mata-mata. ");
INSERT INTO wlo_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Maka Yusuf apogau i manga incia, \"Inda! Ingkomiu uumba to umata-matai kakurangana lipu sii!\" ");
INSERT INTO wlo_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Alawani manga, \"Manga bhatuamu sii sapulu rua mia tapowitinai, anana minaaka i saama momboorena i Tana Kanaan. Andiku kaepu dhaangia apobhawa tee amamami sii-sii, sainamo samiana uka indamo dhaangia.\" ");
INSERT INTO wlo_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Apogaumo Yusuf i manga incia, \"Mboomo mopadhana ipogauakaku i saao, ingkomiu sii mata-mata! ");
INSERT INTO wlo_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","To dhadhina Firaun kuposumpa, ingkomiu tabeana utouji mboo sumai: ingkomiu inda umembali ulingka minaaka iwe sii, tabeana ande andimiu kaepu aumba iwe sii. ");
INSERT INTO wlo_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Tumpumo samia minaaka i tanga-tangamiu ulingkaisi andimiu, tee mosagaanana atotaangi iwe sii. Tee mboo sumai, pogaumiu amembali atouji ande atotuu. Ande inda, siitumo to dhadhina Firaun, tantumo ingkomiu sii mata-mata!\" ");
INSERT INTO wlo_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Kasiimpomo, apapesuamea manga incia i nuncana katorongku talu eo kangengena. ");
INSERT INTO wlo_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","I eo talu eona, apogaumo Yusuf i manga incia, \"Iaku mia momaekana i Aulataʼala. Pewaumea hali incia sii, mamudhaakana ingkomiu sadhaadhaana bheudhadhi: ");
INSERT INTO wlo_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Ande ingkomiu totuu mia mojujuru, taroakea samia minaaka i ingkomiu powitinai amboore atotaangi i katorongku, sainamo mosagaanana alingka abhawa gandum to witinaimiu tangasaana moamaara. ");
INSERT INTO wlo_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Sapadhana incia sumai, bhawamea andimiu kaepu sumai i iaku, mamudhaakana pogaumiu akobukutii atotuu tee ingkomiu inda bheumate.\" Manga incia uka aundaakea. ");
INSERT INTO wlo_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Pogauna manga samia tee mosagaanana, \"Satotuuna, ingkita tatanggo dosata i andita. Ingkita takamatea tapanamo mpuu kanarakaana incana wakutuu incia aemani kaasita, maka ingkita inda taperangoia. Siitumo sababuna kaseke incia sii manga kangkanai.\" ");
INSERT INTO wlo_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Kasiimpo, Ruben alawani manga incia, \"I piamo itu padhamo kupaumbakomiu, 'Bholi upewau dosa i anana incia siitu!' Maka, ingkomiu inda urangoa! Sii-sii kamatea, o raana atuntua minaaka i ingkita.\" ");
INSERT INTO wlo_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Manga incia inda amataua ande Yusuf amaʼanaia pogauna manga, roonamo kangengena incia sumai dhaangia samia pande pogau i tanga-tangana manga incia. ");
INSERT INTO wlo_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Sabutuna adhencumo Yusuf minaaka i manga incia, kasiimpo atangi. Sapadhana incia sumai ambulimo pendua kasiimpo apogau tee manga witinaina. Incia aalamo Simeon minaaka i tanga-tangana manga witinaina, kasiimpo arantea i aroana manga witinaina. ");
INSERT INTO wlo_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Sapadhana incia sumai, Yusuf adhawu parinta mamudhaakana manga kadhuna manga aantokiakea gandum, tee doina manga apambuliakea i nuncana kadhuna manga samia-samia. Padha incia sumai, incia uka aparintangi mamudhaakana manga witinaina adhawua bhaku to lingkaana. Sabutuna, mboo sumaimo apewaua. ");
INSERT INTO wlo_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Manga witinaina auleamo manga keledaina tee gandumna, kasiimpo alingka minaaka iwe sumai. ");
INSERT INTO wlo_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Wakutuuna sala samia minaaka i manga incia abungkale kadhuna to adhawuaka akande keledaina i tampana apomalo, akamatamea doina i ngangana kadhuna. ");
INSERT INTO wlo_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Apogaumo i manga witinaina, \"Doiku apambulia! Kamatea, dhaangia i nuncana kadhuku!\" Sabutuna, atokidhamo manga witinaina Yusuf tee apotonto-tontomo samia tee mosagaanana tee arengkumo, kasiimpo apogau, \"Opea kera-kera ipewauna Aulataʼala to ingkita?\" ");
INSERT INTO wlo_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Sakawana manga i tampana Yakub, o amana manga, i Tana Kanaan, manga incia apetulatulaakamea i amana sagala giu momembalina i manga incia. Pogauna manga incia, ");
INSERT INTO wlo_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","\"Mia momembalina opu i lipu incia sumai apogau tee aʼamaraiki ingkami. Afikiria ingkami sii manga mia motangasaana amata-matai lipu incia sumai. ");
INSERT INTO wlo_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Ingkami talawanimo, 'Ingkami sii mia mojujuru, mencuana mata-mata. ");
INSERT INTO wlo_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Ingkami sii sapulu rua mia tapowitinai, manga anana minaaka i saama. Samia indamo dhaangia, tee kaepu sii-sii apobhawa tee amamami i Tana Kanaan.' ");
INSERT INTO wlo_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Maka, o mia momembalina opu i lipu incia sumai apogau i ingkami, 'I nuncana hali incia sii iaku bhekumataua, buaka ingkomiu sii mia mojujuru: Bholimea samia witinaimiu i iaku, kasiimpomo alamo kinande to witinaimiu motangasaana amaara tee lingkamo. ");
INSERT INTO wlo_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Kasiimpomo, bhawamea andimiu kaepu i iaku, mamudhaakana kumataua ande ingkomiu mencuana mata-mata tabeana mia mojujuru. Sapadhana incia sumai bhekupambulia witinaimiu i ingkomiu, tee ingkomiu uka amembali upodhaga i lipu incia sii.' \" ");
INSERT INTO wlo_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Wakutuuna manga incia gauna apokosoa kadhuna, atokamatamo kadhu-kadhuna doina manga sumbe-sumbere dhaangia i nuncana kadhuna. Akamata kadhu-kadhuna doi sumai, manga incia tee uka amana manga aposamaekamo. ");
INSERT INTO wlo_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Kasiimpomo, Yakub, amana manga, apogaumo i manga incia, \"Ingkomiu upewauaku kukailanga manga anaku. Yusuf indamo dhaangia, tee uka Simeon. Sii-sii, Binyamin uka gaumu bheualea. Iakumo motanggoa bhari-bharia sii!\" ");
INSERT INTO wlo_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Kasiimpomo Ruben apogaumo i amana, \"Pekamatemea rua miaia anaku umane, ande iaku inda kubhawea kupambulia i Uma. Pasaraakaakea incia i limaku, sumaimo bhekubhawea kupambulia i Uma.\" ");
INSERT INTO wlo_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Maka Yakub alawanimo, \"Anaku sumai inda membali alingka apobhawa tee ingkomiu roonamo akana amatemo, tee incia soo samia-miana modhadhina. Ande Binyamin akangkanaia cilaka i nuncana lingkaamiu bheulingkaisi, sumaimo ingkomiu bheupamembali iaku mokouwana sii kusapo i alamu manga mia momate rampaakanamo amaasimo incaku.\" ");
INSERT INTO wlo_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Kanarakaa kasukarana kaara torotorosu amakaa i lipu incia sumai. ");
INSERT INTO wlo_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Jadi, wakutuuna gandum ibhawana manga incia minaaka i Mesir atopadhamo atokande, apogaumo amana manga, \"Lingkamo uka, alikita saidhe giuna kinande to ingkita.\" ");
INSERT INTO wlo_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Maka alawanimo Yuda i incia, \"Mia sumai ampuu-mpuu audhaniaka ingkami, 'Ingkomiu indamo umembali ukamata rouku pendua, tabeana andimiu dhaangia apobhawa tee ingkomiu.' ");
INSERT INTO wlo_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Ande Ama uundaakea andimami alingka apobhawa tee ingkami, dhaampomo ingkami bhetalingka taali giuna kinande to Ama. ");
INSERT INTO wlo_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Maka ande Ama inda uundaaka andimami alingka apobhawa tee ingkami, sumaimo ingkami inda bhetalingka, roonamo mia sumai padhamo apogau i ingkami, 'Ingkomiu inda umembali ukamata rouku pendua, tabeana o andimiu apobhawa tee ingkomiu.\" ");
INSERT INTO wlo_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Kasiimpo apogaumo Israel, \"Pokia ingkomiu upekarasaiaku tee upaumbaakea i mia incia sumai ande dhaangiapo tee andimiu samia?\" ");
INSERT INTO wlo_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Alawanimo manga, \"Mia incia sumai atorotorosu aabha to ingkami tee manga witinaita. Incia aabha, 'Dhaangiapo adhadhi o amamiu? Dhaangiapo uka witinaimiu?' sabutuna ingkami talawania mboomo ipogauakamami sumai. Tuaapa tamataua ande incia bheapogauaka, 'Bhawea andimiu iwe sii.'?\" ");
INSERT INTO wlo_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Kasiimpo apogaumo uka Yuda i Israel, amana, \"Uundaakamea anaana sumai alingka tee ingkami. Ingkami bhetalausaka talingka mamudhaakana ingkita, siitumo o Ama, ingkami, tee manga anaanamami, amembali sadhaadhaana tadhadhi tee inda tamate. ");
INSERT INTO wlo_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Iakumo mojaminina incia. Ama umembali utuntua minaaka i iaku. Ande iaku inda kubhawea pendua i Ama tee kupasaraakea i Ama, siitumo iaku bhemotanggona dosa i Ama saʼumurua dhadhiku. ");
INSERT INTO wlo_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Ande ingkami inda tapekanoenoe, tantumo sii-sii ingkami tambulimo to rua mpearona.\" ");
INSERT INTO wlo_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Kasiimpo, apogaumo Israel, amana manga, i manga incia, \"Ande atotuu tabeana mboo sumai, pewaumea hali incia sii: Bhawamea hasilina lipu sii momalapena i nuncana manga tampana bhakumiu, tee bhawamea i mia incia sumai kadhawumiu mboomo saidhe balsam, saidhe golana uwani, manga rampa, polona kau mawondu, bhakena bheau, tee bhakena badam. ");
INSERT INTO wlo_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Tee uka bhawamo doi rua kali lipa kabharina: o doi i ipambulina i piamo itu i ngangana kadhumiu samia-samia tabeana ingkomiu ubhawea pendua. Aipomo miana Mesir asala dhika i nuncana kadhumiu. ");
INSERT INTO wlo_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Bhawea uka andimiu, tee lausakamo umbuli pendua i mia incia sumai. ");
INSERT INTO wlo_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Sio-siomo Aulataʼala Mokokuasana adhawuko rahumati i aroana mia incia sumai sanampuu incia arambasakea witinaimiu mosagaanana sumai tee uka Binyamin. Maka ande iaku, tabeana bhekukailanga manga anaku, bholiakamo iaku kukailangaaka.\" ");
INSERT INTO wlo_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Kasiimpomo, manga incia apasiapuakamea manga bara to idhawuakana. Manga incia abhawamo doi rua kali lipa kabharina, tee uka Binyamin, kasiimpo alingkamo i Mesir. Sakawana iwe sumai, akakaromo manga incia i aroana Yusuf. ");
INSERT INTO wlo_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Wakutuuna Yusuf akamata Binyamin apobhawa tee manga witinaina, apogaumo incia i bhatuana, \"Bhawea manga mia incia sii i nuncana bhanua. Sumbelemo sambaa binata tee patalaakea kinande, roonamo manga mia incia sii bheakande tee iaku pontanga eo sii.\" ");
INSERT INTO wlo_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Mia incia sumai apewaumea parintana Yusuf, kasiimpo abhawamea manga incia apesua i bhanuana Yusuf. ");
INSERT INTO wlo_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Manga incia amaekamo sababuna manga apapesuaia i nuncana bhanua Yusuf. Apogaumo manga incia, \"Ingkita amangapapesua roonamo parakarana doi ipambulina i nuncana kadhuta i piamo itu. Incia gauna bhearaeaka ingkita, arako ingkita, amangapamembali bhatuana, tee aala manga keledaita.\" ");
INSERT INTO wlo_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Sababuna itu manga incia asarimo moʼatorona bhanuana Yusuf sumai tee apogaumo i aroana bhambana bhanua. ");
INSERT INTO wlo_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Apogaumo manga, \"Umbe Opu, i piamo itu totuu ingkami taumba to taali giuna kinande. ");
INSERT INTO wlo_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","I wakutuu ingkami takawa i tampana pomaloa tee tabungkale kadhumami, garaaka dhaangia tee doina sumbesumbere dhaangia i ngangana kadhu, mboomo kabharina ingkami tabaiarea. Maka sii-sii, ingkami tapambulia pendua, ");
INSERT INTO wlo_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","tee ingkami uka tabhawa doi sagaanana to taaliaka giuna kinande. Ingkami inda tamataua incema mopapesuana doi sumai i nuncana kadhumami.\" ");
INSERT INTO wlo_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Apogaumo mia sumai, \"Tanangipo bholi umaeka! Aulataʼalamiu tee Aulataʼalana amamiu padhamo adhawuakakomiu harataa i nuncana kadhumiu. Doimiu i piamo itu padhamo kutarimaia.\" Kasiimpomo, incia apalimbamo Simeon tee abhawea i manga incia. ");
INSERT INTO wlo_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Sapadhana incia sumai, incia abhawamea manga apesua i nuncana bhanuana Yusuf, kasiimpo adhawua uwe manga mamudhaakana abhanui aena kasiimpomo adhawua akande manga keledaina. ");
INSERT INTO wlo_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Manga incia apasiapuakamo idhawuakana manga tee aantagi o umbaana Yusuf i pontanga eo roonamo manga incia arango ande manga incia bheapatalaakea kinande iwe sumai. ");
INSERT INTO wlo_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Wakutuuna Yusuf ambuli i bhanuana, manga incia uka apasaraakea i Yusuf manga idhawuakana ibhawana apapesuaia i bhanuana, kasiimpo asuju i aroana ahoromatia. ");
INSERT INTO wlo_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Yusuf aabhaakamo kadhaangiana manga incia, kasiimpo aabha, \"Tuaapa kadhaangiana amamiu, mancuana ipetulatulaakamiu itu? Dhaangiapo adhadhi?\" ");
INSERT INTO wlo_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Lawanimo manga, \"Bhatuamu, o amamami, amalape tee dhaangiapo adhadhi.\" Kasiimpo, manga incia asujumo manga tee ahoromatia. ");
INSERT INTO wlo_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Yusuf apotonto i manga incia, kasiimpo akamatamo Binyamin, andina, witinaina saina tee incia. Incia aabha, \"Siimo andimiu kaepu, ipetulatulaakamiu i iaku? Sio-siomo Aulataʼala amaasi incana i ingkoo, anaku!\" ");
INSERT INTO wlo_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Yusuf uka lausakamo adhencu apeelo tampa to atangi, roonamo apemelili mpuu tee andina. Incia apesua i nuncana kolemana tee atangi iwe sumai. ");
INSERT INTO wlo_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Sapadhana incia sumai abhanuimo rouna kasiimpo alimba. Apoose abuniakea incana satotuuna, incia apogau, \"Patalamo kinande.\" ");
INSERT INTO wlo_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Kinande uka atopatalamo, to Yusuf agaatiakea, to manga witinaina agaatiakea uka, to manga miana Mesir mokandena mopobhawana tee incia uka agaatiakea. Manga incia akande mboo sumai rampaakanamo miana Mesir inda amembali akande sameja tee miana Ibrani, sababuna hali incia sumai saangu kahina to miana Mesir. ");
INSERT INTO wlo_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Manga witinaina Yusuf apauncuraia i aroana mboomo laahiriana samia-samia, minaaka i tumpe sampe i kaepu. Manga incia uka aposapotontomo tee amente. ");
INSERT INTO wlo_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Kasiimpomo, sagaa kinande minaaka i aroana Yusuf apataalakea i aroana manga incia sumbesumbere, maka dhawuna to Binyamin apataalakea lima mpearo kabharina minaaka i dhawuna to bhari-bharia mosagaanana. Manga incia uka asumpu tee asanaa-sanaamo tee Yusuf. ");
INSERT INTO wlo_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Sapadhana incia sumai Yusuf adhawumo parintana i moʼatorona bhanuana, pogauna, \"Antokiakea giuna kinande i nuncana kadhuna manga mia sumai kabharina kapoolina ibhawana, tee dhikaia doina manga sumbesumbere i ngangana kadhuna. ");
INSERT INTO wlo_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Kasiimpo, dhikaia tondeku, siitumo tonde pera sumai, i ngangana kadhuna mia momangurana mpuu, tee uka doina gandumna.\" Mia sumai uka apewaumea opea ipogauakana Yusuf. ");
INSERT INTO wlo_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Saeona mpuu, sabhetena matanaeo, manga incia aundaakamea alingka apobhawa tee manga keledaina. ");
INSERT INTO wlo_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Indapo amangenge alimba minaaka i kota, Yusuf apogaumo i moʼatorona bhanuana, \"Pekadheimo pajerea manga mia sumai, tee wakutuuna upokawaakamea, pogaumo i manga incia, \"Pokia ingkomiu ubholosi kalape tee kadhaki? ");
INSERT INTO wlo_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Tonde incia sii satotuuna tampana sumpuana opuku, kananeana apakea to apekilala. Kadhaki ipewaumiu sii.\" ");
INSERT INTO wlo_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Sumaimo aosemea manga mia sumai, kasiimpo apogauakamea i manga witinaina pogauna Yusuf i saao. ");
INSERT INTO wlo_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Alawanimo manga, \"Pokia opuku ubhoasaka manga pogau mboo sumai? Haramu to manga bhatuamu sii to apewau hali mboo sumai! ");
INSERT INTO wlo_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Sainamo doi ipotibhaakamami i ngangana kadhumami i piamo itu uka padhamo tapambulia pendua i opu minaaka i Tana Kanaan. Indapo uka ingkami tamanako pera atawa bulawa minaaka i bhanuana opuku!\" ");
INSERT INTO wlo_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Incema i tanga-tangana manga bhatuamu sii ipotibhaakana modhikana bara sumai, taroakamo atohukumu mate, tee taroakamo ingkami tamembali bhatuana opuku.\" ");
INSERT INTO wlo_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Alawanimo mia sumai, \"Umbe, kutarimaia ipogauakamiu. Incema ipotibhaakaku adhika bara incia sumai incia bheamembali bhatuaku, maka mosagaanana abebasi minaaka i kasalahana.\" ");
INSERT INTO wlo_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Lausakamo manga sumbesumbere apasapoa kadhuna i tana kasiimpomo abungkalea. ");
INSERT INTO wlo_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Mia incia sumai uka aparakisaamea, apepuu i momatuʼana sampe i momangurana, aahirina, tonde sumai apotibhaakea i nuncana kadhuna Binyamin. ");
INSERT INTO wlo_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Sanampuu, manga incia abhencimo pakeana roonamo amaasimo mpuu incana. Kasiimpo sumbesumbere apakompamea pendua manga kadhuna i keledaina, tee ambuli i kota. ");
INSERT INTO wlo_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Wakutuuna Yuda tee manga witinaina apesua i bhanuana Yusuf, Yusuf dhaangiapo iwe sumai. Manga incia uka asujumo i aroana. ");
INSERT INTO wlo_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Pogaumo Yusuf i manga incia, \"Pewau opea ikarajaamiu sii? Inda umataua buaka ande mia mboomo iaku sii amembali apekilala?\" ");
INSERT INTO wlo_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Alawanimo Yuda, \"Opea bhemomembalina ipogauakamami i opuku? Tuaapa ingkami bhetapogau? Tuaapa bhetapatotuu karomami? Aulataʼala padhamo apakamataakea kasalahana manga bhatuamu sii. Sii-sii, taroakamo ingkami tamembali bhatuana opuku, malape ingkami atawa incia, motopokawaakana tondena opuku i nuncana kadhuna.\" ");
INSERT INTO wlo_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Maka alawanimo Yusuf, \"Haramu to iaku kupewau mboo sii! Mia motopokawaakana mobhawana tonde sumai siitumo to momembalina bhatuaku. Sainamo ingkomiu mosagaanana, mbulimo tee kasanaa i amamiu.\" ");
INSERT INTO wlo_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Kasiimpomo aumbamo Yuda apekakasu Yusuf tee apogau, \"E opuku, undaakea bhatuamu sii apakawaaka sanganga pogau i opuku. Bholi uʼamara i bhatuamu sii roonamo opuku apokana tee Firaun karona. ");
INSERT INTO wlo_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","I piamo itu opuku aabha i manga bhatuana opuku sii, 'Buaka ingkomiu dhaangiapo tee amamiu atawa witinaimiu uka?' ");
INSERT INTO wlo_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Ingkami talawanimo i opuku, \"Ingkami dhaangiapo tee amamami amancuanamo. Dhaangia uka samia o anana momangurana, molaahirina i wakutuuna amancuanamo. O akana amatemo, tee minaaka i manga anana inana tangkanamo incia momboorena, roonamo sumai amana amaasiakea.\" ");
INSERT INTO wlo_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Kasiimpo, opuku apogau i manga bhatuamu sii, \"Bhawea incia i iaku, mamudhaakana iaku amembali kukamatea.' ");
INSERT INTO wlo_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Talawanimo ingkami i opuku, 'Anana umane sumai inda membali abholi amana, roonamo ande incia abholia, tantumo amana bheamate.' ");
INSERT INTO wlo_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Maka opuku apogau i manga bhatuamu sii, 'Ande andimiu kaepu sumai inda aumba tee ingkomiu, sumaimo indamo amembali ukamata rouku pendua.' ");
INSERT INTO wlo_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Jadi, wakutuuna ingkami tambuli i bhatuamu, siitumo o amana bhatuamu, ingkami tapaumbaakea pogauna opuku. ");
INSERT INTO wlo_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Saangu wakutuu amamami apogaumo, 'Mbulimo, alimo saidhe giuna kinande to ingkita.' ");
INSERT INTO wlo_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Maka ingkami tapogau i incia, 'Ingkami inda membali talingka. Ande andimami kaepu aose apobhawa tee ingkami, dhaampomo ingkami bhetalingka, roonamo inda membali takamata rouna mia incia sumai ande andimami kaepu inda apobhawa tee ingkami.\" ");
INSERT INTO wlo_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Kasiimpomo bhatuamu, siitumo o amamami, apogau tee ingkami, \"Ingkoo umataua ande bhawineku padhamo apalaahiri to iaku rua mia anana. ");
INSERT INTO wlo_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Samiana abholiakumo. Fikiriku, \"Dhaanamo incia akandea binata masega,\" tee sampe sii-sii iaku totuumo indamo bhekukamatea. ");
INSERT INTO wlo_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Ande ingkomiu ualea uka anaana sii minaaka i iaku kasiimpo acilaka, sumaimo ingkomiu bheupewauaku mokouwana sii asukara mpuu sampe kusapo i alamuna koburu.' ");
INSERT INTO wlo_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Yuda apogaumo uka, \"Amamami tangkanamo membali adhadhi ande Binyamin adhadhi. Ande anana sumai inda ambuli tee ingkami, dhaanamo o amamami bheamate roonamo indamo akamatea pendua anana sumai. Tee ande mboo sumai, ingkami tasala roonamo bheasababuaka amamami momancuana mpuu asukara tee kaporona inca sabutuna incia bheasapo i alamuna koburu. ");
INSERT INTO wlo_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Maka, bhatuamu padhamo atanggo ana umane sii i aroana amaku tee kupogau, 'Ande iaku inda kubhawea pendua i amaku, taroakamo iaku motanggona dosana i amaku saʼumurua.' ");
INSERT INTO wlo_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Sumaimo sii-sii, taroakamo bhatuamu amboore abholosi ana umane sii to amembali bhatuamu opuku, tee taroakamo ana umane sii ambuli tee manga witinaina. ");
INSERT INTO wlo_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Roonamo tuaapa amembali kumbuli i amaku ande ana umane sii inda apobhawa tee iaku? Iaku inda kukapoia kukamata balaa bhemokangkanaina amaku.\" ");
INSERT INTO wlo_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","I wakutuu incia sumai Yusuf indamo apooli ataangi incana i aroana bhari-bharia mia mokakarona i saripina. Sababuna sumai incia agoramo, \"Tumpumea bhari-bharia mia alimba abholiaku!\" Sumaimo inda samia uka mopobhawana tee incia wakutuuna apapematauaka karona i manga witinaina. ");
INSERT INTO wlo_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Kasiimpo incia atangimo tee suara makaa, sabutuna arangoa manga miana Mesir tee saangua maligena Firaun. ");
INSERT INTO wlo_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Apogaumo Yusuf i manga witinaina, \"Iakumo Yusuf! Dhaangiapo adhadhi buaka o amata?\" Maka manga witinaina inda alawania, roonamo manga incia arengku i aroana. ");
INSERT INTO wlo_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Apogaumo uka Yusuf i manga witinaina, \"Mai, pasari i iaku.\" Kasiimpo manga incia asarimea. Apogaumo Yusuf, \"Iakumo Yusuf, witinaimu, iasomiu i Mesir. ");
INSERT INTO wlo_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Bholi usukara incamiu atawa usosoi karomiu roonamo ingkomiu padhamo uasoaku. Satotuuna karona Aulataʼala mobhawana iaku iwe sii kuporikanaaka ingkomiu to mopasalaamatina inyawana mia bhari. ");
INSERT INTO wlo_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Siimpo rua tao kasukarana kaara akana lipu sii, tee dhaangiapo lima tao uka manga mia inda bheabhingkuni atawa atimpu. ");
INSERT INTO wlo_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Sumaimo Aulataʼala alambokoakumo kuporikanaaka ingkomiu to mojaminina mamudhaakana dhaangia siwulumiu i alamu tee mamudhaakana sadhaadhaana udhadhi alaloi saangu cara kasalaamati maoge.\" ");
INSERT INTO wlo_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","\"Jadi, mencuana ingkomiu mosababuakana iaku dhaangia iwe sii, maka Aulataʼala. Incia mopamembaliaku ama to Firaun tee opu i saangua maligena, tee uka mokokuasana i saangua Tana Mesir. ");
INSERT INTO wlo_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Lausakamo umbuli i ama tee pogauakea i incia, 'Mboo sii pogauna anamu Yusuf, \"Aulataʼala padhamo pamembaliaku opu i saangua Mesir. Umbamo i iaku, bholi upekanoenoe! ");
INSERT INTO wlo_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Ama bheumboore i Tana Gosyen, amakasu tee iaku, manga anamu tee manga opuamu, bhembe dumba tee sapina Ama tee sagala giu pewauamu. ");
INSERT INTO wlo_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Iaku bhekupadhaangiaakea ifaraluumu Ama iwe sumai, roonamo dhaangiapo lima tao kasukarana kaara sii. Ancosala ingkomiu unarakaa umisikini.\" ' \" ");
INSERT INTO wlo_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","\"Satotuuna, karomu mokamatea, mboo sumai uka kamatea Binyamin andiku, ande karoku mopogauakea i ingkoo. ");
INSERT INTO wlo_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Sababuna sumai paumbaakamea i ama sagala kamuliangiku i Mesir tee sagala giu mopadhana ikamatamiu, kasiimpomo bhawamea lausaka ama iwe sii.\" ");
INSERT INTO wlo_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Kasiimpomo Yusuf asakumo bhorokona Binyamin, andina tee atangi. Binyamin uka atangimo i awaana. ");
INSERT INTO wlo_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Yusuf aikimo bhari-bharia witinaina tee atangi aposakulaka manga. Sapadhana incia sumai kasiimpomo manga witinaina apogapogaumo tee incia. ");
INSERT INTO wlo_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Wakutuuna atorangomo lele i maligena Firaun ande manga witinaina Yusuf aumba, hali incia sumai apepagoa malape Firaun tee manga pagawena. ");
INSERT INTO wlo_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Apogaumo Firaun i Yusuf, \"Pogauakea i manga witinaimu, 'Pewaua hali incia sii: Uleamea manga binatamiu tee lingkamo, umbuli i Tana Kanaan. ");
INSERT INTO wlo_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Lingkaisiamea amamiu tee witinaimiu, kasiimpo uumbamo i iaku. Iaku bhekudhawuakakomiu tana momalapena mpuu i Tana Mesir, tee ingkomiu bheunamisi kalapena lipu sii.' ");
INSERT INTO wlo_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Kuparintangiakako uka to upogauakea i manga incia, 'Pewaua hali incia sii: Bhawea pia-pia angu kareta minaaka i Tana Mesir to manga anamu tee manga bhawinemu. Lingkaisimea amamiu tee uumbamo iwe sii. ");
INSERT INTO wlo_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Bholi umeri bholi manga arataamiu, roonamo opea momalapena i saangua Tana Mesir uka bheamembali pewauamiu.\"' ");
INSERT INTO wlo_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Sanampuu manga anana Israel uka apewau mboo sumai. Yusuf adhawuakea i manga incia pia-pia angu kareta apokana tee parintana Firaun, tee bhaku to lingkaana. ");
INSERT INTO wlo_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Mencuana soo sumai, adhawua uka satuwu pakea kabholosi to manga incia samia-samia, maka Binyamin adhawua 300 tibha doi pera tee lima tuwu pakea kabholosi. ");
INSERT INTO wlo_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Sainamo to amana alambokoakea sapulu mbaa keledai umane mouleana manga harataa momalapena minaaka i Mesir, tee sapulu mbaa keledai bhawine to mouleana gandum, roti, tee kinande to amana kangengena i dhala. ");
INSERT INTO wlo_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Kasiimpo Yusuf aʼantara manga witinaina. Wakutuuna alingkamo manga, incia aposameamo, \"Bholi upotagatagali i dhala!\" ");
INSERT INTO wlo_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Sanampuu alingkamo manga incia minaaka i Mesir, kasiimpo akawamo i Tana Kanaan, i tampana Yakub, o amana manga. ");
INSERT INTO wlo_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Manga incia apaumbaakamea i incia, \"Yusuf dhaangiapo adhadhi! O inciamo mokokuasana i saangua Tana Mesir!\" Maka Yakub soo atonto bhanga roonamo inda aparacaea i manga incia. ");
INSERT INTO wlo_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Maka, wakutuuna manga incia apakawaakea bhari-bharia pogau ibhoasakana Yusuf i manga incia, tee sakamatana manga kareta ilambokona Yusuf to aule manga incia, kasiimpomo adhadhi incana o amana manga sumai abhangumo pendua. ");
INSERT INTO wlo_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Pogauna Israel, \"Podhomo itu! Anaku Yusuf dhaangia adhadhi. Gauku bhekulingka kukamata incia wakutuu indapo kumate.\" ");
INSERT INTO wlo_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Sumaimo, abhosemo Israel tee sagala giu pewauana. Wakutuuna incia akawa i Bersyeba, incia apasombaakamo kurubani motosumbele i Aulataʼalana Ishak, o amana. ");
INSERT INTO wlo_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Kasiimpomo, afirimanimo Aulataʼala i Israel i nuncana pokamatana i malo, \"Yakub, Yakub.\" Lawanina, \"Sii iaku, Kawasana Opu.\" ");
INSERT INTO wlo_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Firimanina, \"Iakumo Aulataʼala, Aulataʼalana amamu. Bholi umaeka ulingka i Mesir, roonamo Iaku bhekupamembaliko saangu lipu maoge iwe sumai. ");
INSERT INTO wlo_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Iaku bhekupoose tee ingkoo i Mesir, Iaku uka dhaanamo kubhawako umbuli pendua. Ingkoo bheupotidhole i saangoana Yusuf wakutuu ajalamu akawa.\" ");
INSERT INTO wlo_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Kasiimpomo, abhosemo Yakub minaaka i Bersyeba. Manga anana Israel abhawa amana, manga anana, manga bhawinena tee uka manga kareta ilambokona Firaun to aule manga incia. ");
INSERT INTO wlo_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Manga incia uka abhawa kadhambaakana tee harataa mopadhana ipokawaakana i Tana Kanaan, kasiimpo abhose i Mesir. Yakub abhawa bhari-bharia siwuluna, siitumo ");
INSERT INTO wlo_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","bhari-bharia manga anana opuopuana umane tee bhawine. ");
INSERT INTO wlo_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","O siimo manga sarona siwuluna Israel moumbana i Mesir, siitumo Yakub tee siwuluna. Anana Yakub tumpena siitumo Ruben. ");
INSERT INTO wlo_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Manga anana Ruben: siitumo Henokh, Palu, Hezron, tee Karmi. ");
INSERT INTO wlo_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Manga anana Simeon: siitumo Yemuel, Yamin, Ohad, Yakhin, Zohar, tee Saul, anana samia bhawinena Kanaan. ");
INSERT INTO wlo_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Manga anana Lewi: siitumo Gerson, Kehat tee Merari. ");
INSERT INTO wlo_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Manga anana Yuda: siitumo Er, Onan, Syela, Peres, tee Zerah. Maka Er tee Onan amatemo i Tana Kanaan. Manga anana Peres: siitumo Hezron tee Hamul. ");
INSERT INTO wlo_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Manga anana Isakhar: siitumo Tola, Pua, Ayub, tee Simron. ");
INSERT INTO wlo_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Manga anana Zebulon: siitumo Sered, Elon, tee Yahleel. ");
INSERT INTO wlo_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Manga incia sii satotuuna siwuluna Lea, mopalaahirina manga anana umane to Yakub i Padan-Aram, tee uka Dina, anana bhawine. Jadi, bhari-bharia siwuluna Yakub minaaka i Lea, malape umane atawa bhawine, kabharina 33 mia. ");
INSERT INTO wlo_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Manga anana Gad: siitumo Zifyon, Hagi, Syuni, Ezbon, Eri, Arodi, tee Areli. ");
INSERT INTO wlo_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Manga anana Asyer: siitumo Yimna, Yiswa, Yiswi, Beria, tee Sera, witinai bhawinena manga. Manga anana Beria: siitumo Heber tee Malkiel. ");
INSERT INTO wlo_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Manga incia sii satotuuna siwuluna Zilpa, bhatua bhawine idhawuakana Laban i Lea, o anana. Jadi bhari-bharia siwuluna Yakub mominaakana i Zilpa sumai kabharina 16 mia. ");
INSERT INTO wlo_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Manga anana Rahel, bhawinena Yakub: siitumo Yusuf tee Binyamin. ");
INSERT INTO wlo_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Sainamo manga anana Yusuf: siitumo Manasye tee Efraim, ipalaahirina i Mesir minaaka i Asnat binti Potifera, Imamu i On. ");
INSERT INTO wlo_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Manga anana Binyamin: siitumo Bela, Bekher, Asybel, Gera, Naaman, Ehi, Ros, Mupim, Hupim, tee Ared. ");
INSERT INTO wlo_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Manga incia sii satotuuna siwuluna Yakub mominaakana i Rahel, kabharina 14 mia. ");
INSERT INTO wlo_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Anana Dan: siitumo Husyim. ");
INSERT INTO wlo_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Manga anana Naftali: siitumo Yahzeel, Guni, Yezer, tee Syilem. ");
INSERT INTO wlo_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Manga incia sumai satotuuna siwuluna Bilha, bhatua bhawine idhawuakana Laban i Rahel, o anana. Jadi, bhari-bharia siwuluna Yakub mominaakana i Bilha kabharina pitu mia. ");
INSERT INTO wlo_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Kabharina mia moumbana i Mesir apobhawa tee Yakub, siitumo siwuluna, inda atolentu manga bhawinena, bhari-bharia 66 mia. ");
INSERT INTO wlo_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Manga anana Yusuf molaahirina to incia i Mesir dhaangia rua mia sabutuna bhari-bharia witinaina Yakub modhaangiana i Mesir wakutuu incia sumai kabharina 70 mia. ");
INSERT INTO wlo_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Yakub atumpumo Yuda aporikanaakea apokawaaka Yusuf to asusuakea dhala aporope i Tana Gosyen. Sakawana manga incia i Tana Gosyen, ");
INSERT INTO wlo_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yusuf akompamo i karetana kasiimpomo alingka to apokawaaka Israel, amana, i Gosyen. Sapokawana manga, Yusuf asakumo bhorokona amana tee atangi amangenge i awaana. ");
INSERT INTO wlo_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Pogauna Israel i Yusuf, \"Sii-sii taroakamo iaku kumate, roonamo iaku padhamo kukamata roumu tee kumataua ande ingkoo dhaangia udhadhi.\" ");
INSERT INTO wlo_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Kasiimpo Yusuf apogau i manga witinaina tee witinaina amana, \"Iaku bhekulingka kupaumba Firaun, 'Manga witinaiku tee witinaina amaku, momboorena i Tana Kanaan, padhamo aumba iaku. ");
INSERT INTO wlo_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Manga incia sumai mojaganina kadhambaaka, roonamo manga incia amananeamo ajagani kadhambaaka. Gulumana bhembe dumba, gulumana sapi, tee sagala giu pewauana abhawea.' ");
INSERT INTO wlo_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Jadi, ande Firaun akemba ingkomiu tee aabha, 'Opea karajaamiu?' ");
INSERT INTO wlo_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Lawanimo, 'Apepuu maidhiidhi, sampemo sii-sii manga bhatuamu ajagani kadhambaaka, mboomo uka opuamami pitu lapina.' Tee mboo sumai ingkomiu amembali umboore i Tana Gosyen, roonamo bhari-bharia mojaganina kadhambaaka satotuuna kahina to miana Mesir.\" ");
INSERT INTO wlo_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Kasiimpomo alingkamo Yusuf apaumba i Firaun, pogauna, \"Amana bhatua tee manga witinaina bhatua tee gulumana manga bhembe dumba, gulumana sapi, tee sagala giu pewauana aumbamo minaaka i Tana Kanaan. Sii-sii manga incia dhaangia i Tana Gosyen.\" ");
INSERT INTO wlo_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Yusuf abhawa lima mia minaaka i tanga-tangana manga witinaina to apokawaaka Firaun. ");
INSERT INTO wlo_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Kasiimpo, Firaun aabhamo i manga witinaina Yusuf sumai, \"Opea karajaamiu?\" Alawanimo manga i Firaun, \"Manga bhatuamu sii mojaganina kadhambaaka, mboomo uka opuamami pitu lapina.\" ");
INSERT INTO wlo_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Pogauna uka manga i Firaun, \"Ingkami taumba to tamboore i lipu incia sii mboomo dhaga, roonamo kasukarana kaara i Tana Kanaan sumai ahandamo mpuu sabutuna indamo dhaangia tana mokorumpu to gulumana bhembe dumba manga bhatuamu sii. Sabutuna, ingkami taemani sii-sii, undaakamea manga bhatuamu sii amboore i Tana Gosyen. ");
INSERT INTO wlo_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Kasiimpo apogau Firaun i Yusuf, \"Amamu tee manga witinaimu aumbamo. ");
INSERT INTO wlo_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Tana Mesir sii pewauamu uka. Papindaia o amamu tee manga witinaimu i tampa mbooresa momalapena mpuu i lipu incia sii. Taroakamo manga incia amboore i Tana Gosyen. Tee ande umataua dhaangia manga mia momakidha aʼurusu binata i tanga-tangana manga incia, patugasia manga amembali moʼurusuna kadhambaakaku.\" ");
INSERT INTO wlo_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Kasiimpomo Yusuf abhawamo Yakub, amana, apokawaaka Firaun, kasiimpo Yakub aemanimo barakati to Firaun. ");
INSERT INTO wlo_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Aabhamo Firaun i Yakub, \"Pia taomo umuruna uma?\" ");
INSERT INTO wlo_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Lawanina Yakub i Firaun, \"Umuruku 130 taomo; kupekalingka-lingkamo mboomo dhaga i dunia sii. Dhadhiku anarakaa mpuu tee amampodho ande tapapokanea tee umuruna opuaku lantapi-lantapi wakutuu manga incia apekalingka-lingka mboomo dhaga uka i dunia sii.\" ");
INSERT INTO wlo_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Sapadhana incia sumai Yakub aemanimo barakati to Firaun, kasiimpomo alimba minaaka i aroana Firaun. ");
INSERT INTO wlo_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Yusuf apasiapuakamo tampa to amana tee manga witinaina to mbooresana. Adhawuakamea i manga incia tana pewauana i lipu momalapena i Mesir, siitumo i Tana Rameses, apokana tee parintana Firaun. ");
INSERT INTO wlo_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Yusuf apadhaangiaia bhari-bharia kinande ifaraluuna amana, manga witinaina, tee saangua miana bhanuana amana, mboomo kabharina manga anana. ");
INSERT INTO wlo_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Saangu wakutuu, indamo dhaangia kinande i saangua lipu sumai roonamo ahandamo mpuu kasukarana kaara. Raʼeatina Tana Mesir tee Tana Kanaan amalute roonamo kasukarana kaara sumai. ");
INSERT INTO wlo_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Yusuf aromusakamo bhari-bharia doi modhaangiana i Mesir tee Kanaan, siitumo doi ipomeaakana manga mia to aali gandum, kasiimpo abhawea doi sumai i maligena Firaun. ");
INSERT INTO wlo_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Sapadhana doi i Tana Mesir tee i Tana Kanaan amapupu, bhari-bharia miana Mesir uka aumbamo i Yusuf tee apogau, \"Mangadhawupo kinande. Pokia ingkami bhetamate i aroana opu? Doimami amapupumo!\" ");
INSERT INTO wlo_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Alawanimo Yusuf, \"Ande doimu amapupumo, pasarakaakamea kadhambaakamu, kasiimpo iaku bhekudhawukomiu kinande to kabholosina kadhambaakamiu.\" ");
INSERT INTO wlo_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Kasiimpo manga abhawamo kadhambaakana i Yusuf, tee Yusuf adhawuakamo i manga incia kinande to kabholosina ajara, bhembe dumba, sapi, tee keledaina manga. I tao incia sumai incia apasiapuakamea kinandena manga to kabholosina bhari-bharia kadhambaakana manga. ");
INSERT INTO wlo_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Satolalona tao incia sumai, manga incia aumbamo uka i Yusuf i tao rua taona apogaumo, \"Inda membali ingkami tabuniaka minaaka i opuku ande doimami amapupumo tee kadhambaakamami amembalimo pewauana opuku. Indamo dhaangia mokobhilaana i aroana opuku, soomo badamami tee tanamami. ");
INSERT INTO wlo_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Pokia ingkami tee uka tanamami tabeana tamate i aroana opu? Manga alamo tee uka tanamami to kabholosina kinande. Taroakamo ingkami tee tanamami amembali bhatuana Firaun. Mangadhawu wine tadhadhiaka mamudhaakana ingkami inda tamate tee tana incia sii inda amatuu. ");
INSERT INTO wlo_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Sabutuna Yusuf aalia bhari-bharia tana i Mesir to Firaun, sababuna miana Mesir aasoa inawuna sumbesumbere. Hali incia sumai apewaua manga roonamo kanarakaa kasukarana kaara sumai akana manga incia. Tee mboo sumai, lipu sumai amembali pewauana Firaun. ");
INSERT INTO wlo_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Sapadhana incia sumai, Yusuf apapinda raʼeatina i manga kota i Mesir, minaaka i tapa sakawana uka i satapana. ");
INSERT INTO wlo_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Maka incia inda aali tanana manga imamu roonamo manga imamu tee dhawuna motoka minaaka i Firaun, tee manga incia akande minaaka i dhawuna motoka idhawuakana Firaun i manga incia sumai. Siitumo sababuna, manga incia inda aasoa tanana. ");
INSERT INTO wlo_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Kasiimpomo, Yusuf apogau i raʼeatina, \"I eo sii iaku padhamo kualia karomiu tee tanamiu to Firaun. Siimo wine to ipombulamiu i tana sumai. ");
INSERT INTO wlo_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","I wakutuuna bulaana timpua, ingkomiu tabeana upasaraakaakea saperlima dhawuna i Firaun, sainamo pata dhawuna amembali pewauamiu. Pakemea incia sumai to winena inawumiu, to kinandemiu tee manga incia modhaangiana i bhanuamiu, tee kinandena manga anamiu.\" ");
INSERT INTO wlo_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Alawanimo manga, \"Opu padhamo upasalaamatia dhadhimami! Somanamo opu upeelu, ingkami taunda tamembali bhatuana Firaun.\" ");
INSERT INTO wlo_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Sumaimo, Yusuf apadhaangia saangu hukumu to lipu Mesir sampemo sii-sii hukumu incia sumai dhaangia atopake, siitumo ande saperlima dhawu minaaka i hasilina tana amembali pewauana Firaun. Tangkanamo tanana manga imamu inda momembalina pewauana Firaun. ");
INSERT INTO wlo_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Miana Israel amboore i Tana Mesir, siitumo i Tana Gosyen. Manga incia ambooremo iwe sumai, akoana-anamo, akoopu-opuamo tee ahandamo mpuu kabharina. ");
INSERT INTO wlo_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yakub adhadhi 17 tao kangengena i Tana Mesir. Jadi, Yakub akoʼumurumo 147 tao. ");
INSERT INTO wlo_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Wakutuuna eona matena Israel amakasumo, incia akembamo anana, Yusuf, tee apogau i incia, \"Ande ingkoo umaasiakaaku, dhikaia limamu i tambena paaku tee sumpamo ande ingkoo bheupatiumbaaka kaasimu molagina i iaku. Kuemani bholi ukoburuaku i Mesir. ");
INSERT INTO wlo_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Sumpamo, sapadhana kuporomu tee manga kaomuku i alamuna mia momate, bhawea maeatiku minaaka i Mesir, kasiimpo koburuaku i nuncana liana koburuna opuopuaku i Tana Kanaan.\" Alawanimo Yusuf, \"Bhekupewaua kasameamu sumai, Ama.\" ");
INSERT INTO wlo_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Apogaumo Yakub, \"Sumpamo i iaku.\" Kasiimpomo Yusuf uka asumpamo. Sapadhana incia sumai, Israel asujumo tee asombamo Aulataʼala i weta pobhaana koleana. ");
INSERT INTO wlo_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Pia-pia wakutuu kangengena sapadhana hali incia sumai, sala samia apaumbaakamea i Yusuf, \"Mataua amana opu amapii.\" Sumaimo, abhawamea rua miaia anana, Manasye tee Efraim, apobhawa tee incia. ");
INSERT INTO wlo_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Kasiimpomo, apaumbaakamea i Yakub, \"Anamu Yusuf, aumba asoloko.\" Sumaimo, Israel aʼusaha abhangu, tee auncura i tampana koleana. ");
INSERT INTO wlo_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Apogaumo Yakub i Yusuf, \"Aulataʼala mokokuasana padhamo apatiumbaaka karona i iaku i Lus, i Tana Kanaan. Incia abarakatiaku ");
INSERT INTO wlo_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","tee afirimani i iaku, 'Satotuuna, Iaku bhekupewauko ukoana-anamo, ukoopu-opuamo tee kupekabharia siwulumu. Iaku bhekupamembaliko saangu lipu, tee Iaku bhekudhawuko lipu sii i manga siwulumu naile itu to amembali pewauamu saʼumurua.' ");
INSERT INTO wlo_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Sumaimo sii-sii, pewauakumo ruamiaia anamu molaahirina to ingkoo i Tana Mesir indapo kuumba i ingkoo i Mesir. Efraim tee Manasye bheamembali pewauaku, apokana Ruben tee Simeon. ");
INSERT INTO wlo_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Maka manga anamu molaahirina sapadhana manga incia satotuuna manga anamu. To tinauraka, manga incia bheatarima minaaka i dhawuna ruamiaia o akana manga. ");
INSERT INTO wlo_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Kupewau mboo sii rampaakanamo inamu Rahel. Wakutuuna kumbuli minaaka i Mesopotamia, inamu amatemo i Tana Kanaan, inda amaridho minaaka i Efrata, tee iaku kumaasi mpuu. Iaku kukoburumea iwe sumai, i bhiwina dhala i Efrata.\" (Sii-sii Efrata asarongia Bait Lahim.) ");
INSERT INTO wlo_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Wakutuuna Israel akamata manga anana Yusuf, aabhamo incia, \"Incema buaka manga incia sii?\" ");
INSERT INTO wlo_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Alawanimo Yusuf i amana, \"O siimo manga anaku idhawuakana Aulataʼala i iaku iwe sii.\" Apogaumo Yakub, \"Pekakasumea manga incia i iaku mamudhaakana kuemaniakaea barakati.\" ");
INSERT INTO wlo_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Wakutuu incia sumai ruambalia matana Israel amarawumo roonamo amancuanamo, jadi incia indamo atinda apokamata. Yusuf apekakasuakamea manga anana i Yakub, kasiimpo Yakub aikia tee asakua. ");
INSERT INTO wlo_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Apogaumo Israel i Yusuf, \"Inda kunamu-namua, bhekukamata roumu pendua, maka sii-sii Aulataʼala undakaaku kukamata siwulumu.\" ");
INSERT INTO wlo_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Yusuf ahela manga incia minaaka i saripina toputuna Yakub, kasiimpo incia asujumo tee ahoromati. ");
INSERT INTO wlo_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Sapadhana incia sumai Yusuf akenimea rua miaia, Efraim, akenimea tee limana kaanana, i weta kaaina Israel tee Manasye, akenimea tee lima kaaina i weta kaanana Israel. Kasiimpomo apasarimea manga i Yakub. ");
INSERT INTO wlo_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Maka Israel apaulumo lima kaanana tee adhikamea i bhawona bhaana Efraim, anana kaepu, tee lima kaaina i bhawona bhaana Manasye, anana tumpe. Incia aporadhamii apapokai limana moomini Manasye satotuuna ana tumpena. ");
INSERT INTO wlo_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Kasiimpo incia aemaniakamo barakati to Yusuf, pogauna, \"Manga amaku Ibrahim tee Ishak moporikanaakaaku adhadhi i aroana Aulataʼala. Aulataʼala, mojaganiaku kangengena dhadhiku sampe sii-sii. ");
INSERT INTO wlo_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Inciamo malaaʼekati motolosiaku minaaka i manga balaa, maasangia Aulataʼala abarakati manga anana sii, maasangia adhadhi torosu saroku tee sarona manga Ibrahim tee Ishak roonamo manga anana sii! Maasangia manga incia akoana-ana akoopu-opua, tee akosiwulu abhari i alamu sii.\" ");
INSERT INTO wlo_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Wakutuuna Yusuf akamata ande amana adhika lima kaanana i bhaana Efraim, incia akamata hali incia sumai inda amalape. Kasiimpo incia akenimo limana amana mamudhaakana apapindaia minaaka i bhaana Efraim to adhikaia i bhaana Manasye. ");
INSERT INTO wlo_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Pogauna Yusuf i amana, \"Bholi mboo itu, Ama, roonamo siimo o tumpe, dhikamea lima kaanamu Ama i bhaana.\" ");
INSERT INTO wlo_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Maka o amana amendeu tee apogau, \"Kumataua, o anaku, incia uka bheamembali manga lipu abhari. Moomini mboo sumai, andina bhealabhi kaogena minaaka i incia tee siwuluna bheamembali lipu maoge.\" ");
INSERT INTO wlo_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Yakub aemaniakea barakati to manga incia i eo incia sumai uka, pogauna, \"Tee asarongimo saromu miana Israel posaemaniakamea barakati, mboo sumai, 'Maasangia Aulataʼala apamembaliko mboomo Efraim tee mboomo Manasye!' \" Mboo sumaimo Yakub adhika Efraim porikana minaaka i Manasye. ");
INSERT INTO wlo_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Kasiimpomo Israel apogau i Yusuf, \"Mataumea, ajalaku amakasumo, maka Aulataʼala apoose tee ingkomiu abhawakomiu pendua i lipuna opuamu lantapi lantapina. ");
INSERT INTO wlo_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","To ingkoo kudhawuakako saangu dhawu labhina kaogena to manga witinaimu, siitumo o torukuna gunu mopadhana irampasiku minaaka i limana miana Amori tee hancu tee panaku.\" ");
INSERT INTO wlo_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Kasiimpomo Yakub akembamo manga anana tee apogau, \"Poromusakamo ingkomiu, iaku bhekupaumbaakakomiu opea bhemomembalina to ingkomiu naile itu. ");
INSERT INTO wlo_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Poromusakamo tee rangomea, e manga anana Yakub, Rangomea Israel amamu. ");
INSERT INTO wlo_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben, ingkoomo anaku o tumpe, Kakaaku tee bhakena bhaa-bhaana kuasaku, molabhina motohoromatina, molabhina kakaana. ");
INSERT INTO wlo_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Ingkoo mboomo mawa moluana, inda ukapoia utaangia karomu samia indamo umembali o anana mobhaa-bhaana Sababuna ingkoo padhamo ukompasi kolemaku, kasiimpo upekarombua. Incia padhamo akolemiki bhawineku i kolemaku! ");
INSERT INTO wlo_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeon tee Lewi, o andi tee aka, apake ewanga to apahancuru opeopeapo. ");
INSERT INTO wlo_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Bholi uose ihaejatiakana manga incia, e badaku, Bholi uposaangu tee manga incia, e baatiniku, roonamo aʼamara bheapekamate mia, tee pamuruna manga incia atumpo aena sapi. ");
INSERT INTO wlo_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Maasangia amarana manga incia akanea katunda, roonamo amasega mpuu. Maasangia kasegana manga akanea katunda, roonamo amakaa mpuu. Iaku bhekupapogaa-gaaia manga i tanga-tangana manga anana Yakub, tee kupekantalea manga incia i tanga-tangana manga anana Israel. ");
INSERT INTO wlo_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Yuda, ingkoo bheapujiko manga witinaimu. Limamu bheatalo manga musumu. Tee manga anana amamu bheasuju i ingkoo ");
INSERT INTO wlo_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yuda mboomo sambaa singa mangura, incia ambuli i lia sapadhana apeelo kinandena, incia apangulia kasiimpo akole mboo sambaa singa umane tee mboo sambaa singa bhawine, tee inda samia uka mobaranina mopabhangua. ");
INSERT INTO wlo_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Katuko pamarintana inda bheapinda minaaka i Yuda, tee siwuluna bheaparintangi saʼumurua, sampe aumba incia mokohakuakea, i inciamo manga lipu bheataʼati. ");
INSERT INTO wlo_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Incia abhoke keledaina i puuna angguru, tee anana keledaina i puuna angguru motopilina. Inca atapasi pakeana, tee bhajuna tee uwena bhakena angguru. ");
INSERT INTO wlo_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Matana bhealabhi kaetana minaaka i angguru, tee ngincina bhealabhi kaputina minaaka i uwena susu. ");
INSERT INTO wlo_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zebulon bheamboore i bhiwina tawo. Incia bheamembali labusana manga kapala, tee potidhaana bheakawea i Sidon. ");
INSERT INTO wlo_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isakhar mboomo sambaa keledai momakaana, mopotidholena i tanga-tangana bara momatamona ");
INSERT INTO wlo_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Wakutuuna akamatea ande tampana poniuntoa sumai amalape tee lipu incia sumai apekasanaa, apabhelemea o awaana to asodhaaia kasiimpo amembali bhatuana mokarajaana. ");
INSERT INTO wlo_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan bheaʼadili lipuna mboomo manga kaomu sagaanana i Israel. ");
INSERT INTO wlo_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan bheamembali mboomo ulo i dhala, mokobisa i loro motompana korontunguna ajara, sabutuna mosawikia amandawu apambara. ");
INSERT INTO wlo_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Iaku kuantagi kasalaamati minaaka i Ingkoo e KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gad bheahumbunia parampo, maka o Gad ambuli abhebhe korontunguna manga incia. ");
INSERT INTO wlo_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Asyer, kinandena amambaka ataralabhi-labhi; incia bheapatalaaka kinande momambaka to raja. ");
INSERT INTO wlo_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naftali mboomo sambaa rusa bhawine molapa; incia bheakoʼana manga anana makesa. ");
INSERT INTO wlo_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yusuf mboomo raha abukeaka bhake, rahana abukeaka bhake i saripina matana uwe. Manga rahana atuwu alaloi rindi. ");
INSERT INTO wlo_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Manga pande pana apanarakaaia, ahumbunia tee pana. ");
INSERT INTO wlo_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Maka, o panana sadhaadhaana amatangka, tee ruambalia limana sadhaadhaana amakaa, roonamo kakuasa Momakaana, Aulataʼalana Yakub, roonamo Mojaganina, Gunu Bhatuna Israel, ");
INSERT INTO wlo_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","roonamo Aulataʼalana amamu, bhemotulungiko, tee roonamo Mokokuasana, bhemobarakatiko tee abarakatiko tee kowao minaaka i laiana i bhawo, tee abarakatiko tee uwe minaaka i nuncana tana. Maasangia ingkoo ukosiwulu abhari tee uka manga binata kadhambaakamu akohasiliaka abhari anana. ");
INSERT INTO wlo_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Barakatina amamu alabhia barakatina manga opuaku, akawea tidhana manga gunu i zamani momangengena. Maasangia Aulataʼala adhawuaka manga barakati sii i Yusuf, motoangkana amembali kapala to manga witinaina. ");
INSERT INTO wlo_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Binyamin mboomo sambaa serigala mobheka-bhekana dagi. I wakutuuna malo-malo incia akande kinandena, tee wakutuu atobhele eo incia apodhawu-dhawumo irampasina.\" ");
INSERT INTO wlo_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Siitumo bhari-bharia lipuna Israel, sapulu rua mia kabharina, tee siitumo ipogauakana amana manga wakutuuna aemaniakea barakati to manga incia tee barakati mohususuna to samia-samia. ");
INSERT INTO wlo_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Sapadhana incia sumai, asameamo Yakub i manga incia, \"Indamo amangenge bhearomusakaakumo tee manga kaomuku i alamuna mia mate. Koburuakumo i saripina opuaku lantapi-lantapi i nuncana lia i inawu Efron, miana Het sumai, ");
INSERT INTO wlo_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","siitumo lia i inawu Makhpela, weta i timbu Mamre, i Tana Kanaan. Lia incia sumai aalia Ibrahim tee inawuna minaaka i Efron, miana Het, to apamembalia koburu pewauana. ");
INSERT INTO wlo_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Iwe sumaimo Ibrahim tee Sarah, bhawinena, akoburua, mboo sumai uka Ishak tee Ribka bhawinena. Iwe sumai uka iaku kukoburu Lea. ");
INSERT INTO wlo_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Inawu tee lia modhaangiana i nuncana padhamo atoali minaaka i miana Het.\" ");
INSERT INTO wlo_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Sapadhana Yakub asamea i manga anana, ahelamea ruambalia aena i bhawona kolemana kasiimpomo amate, incia aromusakea tee manga kaomuna i alamuna mia mate. ");
INSERT INTO wlo_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Kasiimpo Yusuf asujumo asaku maeatina amana atangisia tee aikia. ");
INSERT INTO wlo_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Yusuf aparintangimo manga bhatuana, siitumo manga tabi, to arampa-rampaia maeatina amana. Kasiimpomo manga tabi sumai uka arampa-rampaimea maeatina Israel, apokana tee iparintangina Yusuf. ");
INSERT INTO wlo_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Manga incia apewaumea kangenge 40 eo, roonamo mboo sumaimo kangengena wakutuu to arampa-rampaia maeati. Manga miana Mesir atangisimea kangenge 40 eo. ");
INSERT INTO wlo_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Salapana wakutuuna kasukara, apogaumo Yusuf i manga pagawena raja, \"Ande ingkomiu upeelu utulungiaku, tulungi pakawaakaaku i Firaun mboo sii, ");
INSERT INTO wlo_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","'Amaku atumpuakumo kusumpa, pogauna, \"Satotuuna, ajalaku amakasumo. Ingkoo tabeana ukoburuaku i nuncana koburu iseliku to karoku i Tana Kanaan.\" Rampaakanamo itu, sii-sii undakaakumo kulingka kukoburu amaku, sapadhana incia sumai iaku bheambuli.' \" ");
INSERT INTO wlo_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Apogaumo Firaun, \"Lingkamo, koburumea amamu, roonamo padhamo atumpuko usumpa.\" ");
INSERT INTO wlo_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Kasiimpo alingkamo Yusuf to akoburu amana. Bhari-bharia pagawena Firaun alingka apobhawa tee incia, siitumo manga mancuanana maligena Firaun tee bhari-bharia manga mancuana i Tana Mesir, ");
INSERT INTO wlo_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","mboo sumai uka saangua miana bhanuana Yusuf, manga witinaina, tee manga miana bhanuana Yakub. Tangkanamo manga anaana, gulumana bhembe dumba, tee gulumana sapi ibholina manga i Tana Gosyen. ");
INSERT INTO wlo_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Pasuka mokokaretana tee mokoajarana uka aose, sabutuna abhari mpuu mia molingkana i koburu sumai. ");
INSERT INTO wlo_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Kasiimpomo, akawamo manga incia i Goren-Hataad modhaangiana i sawetana Umala Yordan. Iwe sumai manga incia atangi tee suara makaa tee amaasi mpuu. Kasiimpo Yusuf apatotapuakea pitu eo kasukara to amana. ");
INSERT INTO wlo_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Wakutuu raʼeatina lipu sumai, siitumo manga miana Kanaan, akamata kasukara i Goren-Hataad sumai, apogaumo manga incia, \"O sii kasukara momaogena to miana Mesir.\" Siitumo sababuna, tampa i sawetana Umala Yordan sumai asarongiakea Abel-Mizraim. ");
INSERT INTO wlo_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Manga anana Yakub apewaumo mopadhana isameaakana Yakub i manga incia. ");
INSERT INTO wlo_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Manga incia aangkamo maeatina amana i Tana Kanaan, kasiimpo akoburumea i nuncana lia i inawu Makhpela, weta i timbu Mamre, inawu ialina Ibrahim minaaka i Efron, miana Het, to apamembalia koburu pewauana. ");
INSERT INTO wlo_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Sapadhana amana atokoburu, ambulimo Yusuf i Mesir apobhawa tee manga witinaina tee bhari-bharia mia molingkana mopobhawana tee incia to akoburuaka amana. ");
INSERT INTO wlo_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Samatena amana, manga witinaina Yusuf apogau, \"Tuaapa ande Yusuf adhika-dhika incana tee abholosi kadhakita i piamo itu?\" ");
INSERT INTO wlo_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Manga incia atumpumo mia apakawaaka kasamea i Yusuf, \"Wakutuuna o amata indapo amate, ");
INSERT INTO wlo_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","incia atumpu ingkami tapogauakea i ingkoo mboo sii, \"Amponia kasalahana manga witinaimu ipewauna i piamo itu i ingkoo. Jadi sii-sii amponia kasalahana manga bhatuana Aulataʼalana amamu.\" Wakutuuna Yusuf arango kasamea sumai, atangimo incia. ");
INSERT INTO wlo_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Kasiimpo, aumbamo manga witinaina asuju i aroana tee apogau, \"Ingkami taumba to amembali bhatuamu.\" ");
INSERT INTO wlo_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Maka apogaumo Yusuf i manga incia, \"Bholi maeka. Iaku mencuana Aulataʼala, iaku inda amembali kuhukumu ingkomiu. ");
INSERT INTO wlo_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Dhaanamo i piamo itu ingkomiu haejati madhaki i iaku, maka Aulataʼala abhaliia haejatimiu apamembalia haejati malape. Bhari-bharia sumai amembali mamudhaakana abhari mia mosalaamatina, mboomo ipewauna sii-sii. ");
INSERT INTO wlo_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Jadi bholimo maeka, iaku bhekupakawea ifaraluumiu tee manga anamiu.\" Mboo sumaimo Yusuf apekasanaa manga incia tee apaturu ngangarandana tee pogauna. ");
INSERT INTO wlo_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yusuf sadhaadhaana amboore i Mesir tee manga witinaina. Incia adhadhi 110 tao. ");
INSERT INTO wlo_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Yusuf dhaangiapo akamata siwuluna Efraim talu lapina. Incia uka aangkamea manga anana Makhir bin Manasye to apamembalia anana karona. ");
INSERT INTO wlo_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Saangu wakutuu Yusuf apogaumo i manga witinaina, \"Ajalaku amakasumo, maka Aulataʼala dhaanamo bheamaheruakakomiu tee abhawakomiu ulimba minaaka i lipu sii. Incia bheabhawakomiu i lipu mopadhana ijanjiakana i Ibrahim, Ishak, tee Yakub.\" ");
INSERT INTO wlo_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Kasiimpo Yusuf atumpumo manga anana Israel asumpa, \"Aulataʼala dhaanamo bheamaheruakakomiu. I wakutuu incia sumai, ingkomiu tabeana ubhawa manga bukuku minaaka iwe sii.\" ");
INSERT INTO wlo_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Kasiimpomo amatemo Yusuf umuruna 110 tao. Maeatina arampa-rampaia tee adhikaia i nuncana sorongana maeati i Mesir.");
INSERT INTO wlo_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","O siimo sarona manga anana Israel moumbana i Mesir apobhawa tee Yakub. Manga incia aumba tee bhawinena tee manga anana sumbesumbere: ");
INSERT INTO wlo_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruben, Simeon, Lewi tee Yuda, ");
INSERT INTO wlo_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isakhar, Zebulon, Binyamin, ");
INSERT INTO wlo_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, Naftali, Gad, tee Asyer. ");
INSERT INTO wlo_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Bhari-bharia siwuluna umane ipokawaakana Yakub kabharina 70 mia. Maka Yusuf aporikana i Mesir. ");
INSERT INTO wlo_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Kasiimpomo amatemo Yusuf, mboo itu uka bhari-bharia witinaina tee bhari-bharia mia saʼumuru tee incia. ");
INSERT INTO wlo_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Manga miana Israel akoana-anamo koopu-opuamo tee ahandamo kabharina tee amadhei mpuu ajulu torotorosu tee amembali amakaa, sabutuna lipu sumai abukeaka manga incia. ");
INSERT INTO wlo_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Kasiimpomo atoangkamo samia raja bhaau moparintana i Tana Mesir, inda momatauna Yusuf. ");
INSERT INTO wlo_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Incia apogau i raʼeatina, \"Manga miana Israel sumai atomaeka mpuu to ingkita, roonamo manga incia abhari mpuu tee alabhi kakaana minaaka ingkita. ");
INSERT INTO wlo_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Maimo ingkita tapeelo akala to manga incia, mamudhaakana inda arangani kabharina, tee ande dhaangia potimbea ancosala manga incia aposaangu naile itu tee musuta tee manga aewangi ingkita, kasiimpo alingka minaaka i lipu sii.'' ");
INSERT INTO wlo_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Sababuna sumai, raja tee manga pagawena aangka manga miana Mesir mojaganina bhatua to apabhatua manga miana Israel tee karajaa pakisaa. Manga incia tabeana apabhangu kota Pitom tee kota Raamses to tampa adhika gandum tee manga bara sagaanana pewauna raja Mesir. ");
INSERT INTO wlo_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Maka sahandana apabhatuaia, sahandana arangani tee sahandana ajulu kabharina manga, sabutuna miana Mesir amembalimo amaeka i miana Israel sumai. ");
INSERT INTO wlo_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Sabutuna tee kasegana miana Mesir apakisaa miana Israel akarajaa, ");
INSERT INTO wlo_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","tee apewau dhadhina manga incia anarakaa i nuncana kapabhatuana momatamona. Manga incia tabeana akarajaa tana reo tee bhatu bata tee bhari-bharia karajaa i inawu, sumaimo bhari-bharia karajaa tee kasegana apakisaakea i manga incia. ");
INSERT INTO wlo_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Kasiimpomo raja Mesir aparintaakea i manga bhisa koana miana Ibrani, samia sarona Sifra tee mosagaanana sarona o Pua, ");
INSERT INTO wlo_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","pogauna, \"Wakutuuna ingkomiu ubhisaaka bhawine Ibrani tee utulungi manga incia i tampa pakoana, ande ipalaahirina anana umane ingkomiu tabeana upekamatea, maka ande bhawine taroakea incia adhadhi.\" ");
INSERT INTO wlo_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Maka manga bhisa sumai amaeka i Aulataʼala tee inda apewau mboomo opea ipogauakana raja Mesir i manga incia. Manga incia ataroakea adhadhi manga anana umane sumai. ");
INSERT INTO wlo_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Kasiimpomo raja Mesir akembamo manga bhisa pakoana sumai tee aabha i manga incia, \"Pokia ingkomiu upewau hali incia sii, utaroakea adhadhi manga anana umane siimpo molaahirina sumai.\" ");
INSERT INTO wlo_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Alawanimo manga bhisa pakoana sumai, \"Roonamo bhawine Ibrani inda mboomo bhawine Mesir, maka alabhi kakaana. Indapo aumba bhisa pakoana, manga incia padhamo apalaahiri.\" ");
INSERT INTO wlo_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Sumaimo, Aulataʼala apewau malape i manga bhisa pakoana sumai. Miana Israel ahanda kabharina tee amembalimo amakaa mpuu. ");
INSERT INTO wlo_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Tee roonamo manga bhisa pakoana sumai amaeka i Aulataʼala, sumaimo manga incia abarakatia tee adhawua siwulu. ");
INSERT INTO wlo_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Kasiimpo Firaun adhawu parintana i bhari-bharia raʼeatina, kooni, \"Bhari-bharia anaana umane miana Ibrani siimpo molaahirina tabeana atobhanaka i nuncana Umala Nil, maka bhari-bharia anaana bhawine taroakea adhadhi.\" ");
INSERT INTO wlo_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Dhaangia samia umane minaaka i kaomuna Lewi mokobhawineakana samia bhawine kaomuna Lewi. ");
INSERT INTO wlo_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Bhawine sumai abhawa-bhawamo kasiimpo apalaahirimo samia anaana umane. Wakutuuna incia akamatea ande anaana sumai amakesa, inana abuniakamea kangenge talu mbula. ");
INSERT INTO wlo_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Maka rampaakanamo inda amembali abuniakea apekangengea uka, incia aalamo saangu langka minaaka i rumpu pure, alempesiakea gala-gala tee mina tere mamudhaakana uwe inda apesua. Kasiimpomo incia apadhongi anaana sumai i nuncana. Kasiimpomo inana adhikamea langka sumai i tanga-tangana towu lambe i saripina Umala Nil. ");
INSERT INTO wlo_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Akana bhawine anaana sumai akabhale-bhale pekaridho to akamata opea bhemomembalina tee andina. ");
INSERT INTO wlo_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Tangasaana sumai aumbamo anana Firaun o bhawine to apebhaho i Umala Nil, sainamo manga bhatuana akambeli-mbeli i saripina umala. Sanampuu anana Firaun o bhawine sii akamatamo langka molantona i tanga-tangana towu lambe sumai tee atumpumo bhatuana bhawine alingka aalea. ");
INSERT INTO wlo_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Wakutuu abungkalea, incia akamata anaana sumai tangasaana atangi, sabutuna incia amaasimo incana tee apogau, \"Tantumo anaana sii miana Ibrani.\" ");
INSERT INTO wlo_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Kasiimpo aabhamo akana anana sumai i anana bhawine Firaun, \"Uunda mboona kulingka kukembaakako samia bhawine Ibrani to apadudu anana sii to opuku?\" ");
INSERT INTO wlo_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Alawanimo anana bhawine Firaun i incia, \"Lingkamo.\" Kasiimpo alingkamo kabuabua sumai akemba inana anaana sumai. ");
INSERT INTO wlo_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Apogaumo anana bhawine Firaun i ina sumai, \"Bhawamo anaana sii tee padudua to iaku, dhaampo bhekudhawuko ponambo.\" Sumaimo bhawine sumai abhawamea anaana sumai tee apadudua. ");
INSERT INTO wlo_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Wakutuuna anaana sumai apepuumo amaoge, inana apasarakaakamea i anana bhawine Firaun. Kasiimpomo anana Firaun apamembali incia sumai anaana iangkana. Incia asarongiakea anaana sumai Musa, sababuna kooni, \"Kualea minaaka i uwe.\" ");
INSERT INTO wlo_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Saangu eo wakutuuna Musa amaogemo, incia alimba minaaka i malige Firaun apokawaaka manga witinaina Ibrani tee amaheruakea tuaapa miana Mesir apakisaa manga akarajaa momatamona. Kasiimpomo, incia akamatamo samia Mesir abhebhe samia Ibrani tee katukona, siitumo samia salipuna. ");
INSERT INTO wlo_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Musa abhalili i kaai tee i kaana, tee wakutuuna akamatea inda dhaangia mia, incia apekamatemo miana Mesir sumai tee abuniakea maeatina i nuncana bhone. ");
INSERT INTO wlo_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Samainawana, wakutuuna incia alimba uka, apokawaaka rua mia miana Ibrani tangasaana apobusu. Incia aabhamo i mia mosala sumai, \"Pokia ingkoo ubhebhe sabhangkamu?\" ");
INSERT INTO wlo_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Alawanimo mia sumai, \"Incema moangkako membali kapala tee haakimumami? Buaka ingkoo bheupekamateaku uka, mboomo miana Mesir ipekamatemu sumai?\" Kasiimpomo Musa amaekamo tee afikiri, \"Cilakamo! Tantumo ipewauku sumai atomataumo.\" ");
INSERT INTO wlo_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Wakutuuna Firaun arango hali incia sumai, apeelomo akala to apekamate Musa. Maka o Musa apalaiaka karona minaaka i Firaun tee akawamo i Tana Midian, kasiimpo auncura i saripina saangu sumu. ");
INSERT INTO wlo_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","I Tana Midian sumai dhaangia samia imamu akoana pitu mia bhawine. Manga incia aumba to asiwu uwe tee bhosuna kasiimpo aantoki manga dhingkanana mamudhaakana apasumpuaka bhembe dumbana amana. ");
INSERT INTO wlo_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Maka tangasaana asiwu uwe, aumbamo manga gembala apadhencu manga incia. Sumaimo o Musa akakaro atulungi manga incia tee apasumpu bhembe tee dumbana manga. ");
INSERT INTO wlo_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Wakutuuna manga anana sumai ambuli i Rehuel, o amana manga, incia aabha, \"Pokia ingkomiu madhei mpuu umbuli i eo sii?\" ");
INSERT INTO wlo_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Alawanimo manga, \"Dhaangia samia Mesir motulungina ingkami minaaka i manga gembala. Incia malape mpuu, sabutuna asiwu uwe ataralabhi-labhi uka to ingkami tee apasumpu gulumana bhembe dumbata.\" ");
INSERT INTO wlo_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Apogaumo i manga anana, \"Iapai incia? Pokia ingkomiu ubholia mia sumai? Kembaia incia akande.\" ");
INSERT INTO wlo_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Musa aunda amboore i bhanuana mia incia sumai, kasiimpo incia adhawuakea Zipora, anana, i Musa to apamembalia bhawinena. ");
INSERT INTO wlo_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Bhawine sumai apalaahiri samia anaana umane, kasiimpomo Musa asarongiakea Gersom, sababuna kooni, \"Iaku samia dhaga iwe sii.\" ");
INSERT INTO wlo_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Amangenge sapadhana incia sumai amatemo raja Mesir. Maka miana Israel dhaangia apeenci roonamo manga incia apabhatuaia, tee manga incia apekee, sabutuna pekeena aemani tulungi roonamo kapabhatua sumai akawa i Aulataʼala. ");
INSERT INTO wlo_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Aulataʼala arangoa opea ipeenciakana manga tee audhanimo pojanjiana tee Ibrahim, Ishak, tee Yakub. ");
INSERT INTO wlo_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Sumaimo, Aulataʼala akamata manga miana Israel apabhatuaia tee amaheruakea manga incia. ");
INSERT INTO wlo_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","I saangu wakutuu, Musa awulu gulumana bhembe dumbana Yitro, maniana, imamu i Tana Midian. Wakutuuna incia tangasaana awulu kadhambaaka sumai i sawetana i tana matuu, akawamo incia i Gunu Horeb, gununa Aulataʼala. ");
INSERT INTO wlo_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Iwe sumai Malaaʼekatina KAWASANA OPU apatiumba karona i incia i nuncana rorena waa molimbana minaaka i puu mokorui-rui. Musa akamata puu mokorui-rui sumai arore tee anamisi atokidha, sababuna puuna inda amangau. ");
INSERT INTO wlo_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","I nuncana ngangarandana, Musa afikiri, \"Inda amentela mpuu, puuna mokorui-rui sumai inda amangau! Iaku tabeana kukasui puuna mokorui-rui sumai tee kukamatea.\" ");
INSERT INTO wlo_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Wakutuu KAWASANA OPU akamata Musa akasui tampa incia sumai, saanampuu Incia agora minaaka i tanga-tangana puuna mokorui-rui sumai, \"Musa! Musa!\" Lawanina Musa, \"Umbe, iaku iwe sii.\" ");
INSERT INTO wlo_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Kasiimpo Aulataʼala afirimani, \"Bholi pekakasu. Bungkalea sandalimu, sababuna ingkoo ukakaro i tana momangkilo.\" ");
INSERT INTO wlo_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Firimanina uka, \"Iakumo Aulataʼalana amamu tee Aulataʼalana manga mancuanamu Ibrahim, Ishak, tee Yakub.\" Kasiimpomo Musa atutubhimo rouna, roonamo incia amaeka atonto Aulataʼala. ");
INSERT INTO wlo_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Kasiimpo KAWASANA OPU afirimani, \"Iaku padhamo kukamata kanarakaana uumatiku i Mesir, tee kupadhamo kurango manga incia apekee aemani atopabebasi minaaka i manga mia mopisakina manga incia. Satotuuna, kumataua bhari-bharia kanarakaana manga incia. ");
INSERT INTO wlo_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Sababuna sumai, Iaku kuumba to kupabebasi manga incia minaaka i limana miana Mesir tee kubhawea manga incia alimba minaaka i lipu sumai aporope i saangu lipu momaewa, mosuburu motaralabhi-labhina susu tee golana uwanina, tee sii-sii ambooresia miana Kanaan, miana Het, miana Amori, miana Feris, miana Hewi tee miana Yebus. ");
INSERT INTO wlo_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Satotuuna, pekeena miana Israel padhamo kurangoa tee kukamatea tuaapa manga incia apisakia miana Mesir. ");
INSERT INTO wlo_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Sumaimo, kulambokoko sii-sii to upoaroaka tee Firaun mamudhaakana ingkoo umembali ubhawa uumatiku, lipu Israel, alimba minaaka i lipu sumai.\" ");
INSERT INTO wlo_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Maka o Musa apogau i Aulataʼala, \"Incema buaka iaku sii, sabutuna kumembali kupoaro tee Firaun tee kubhawa miana Israel alimba minaaka i Mesir?\" ");
INSERT INTO wlo_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Aulataʼala alawani, \"Satotuuna bhekutulungiko, tee ande o lipu sumai padhamo ubhawea alimba minaaka i Mesir, ingkomiu bheusambahea i Iaku i gunu sii. Sumaimo bukutiina ande Iaku molambokoko.\" ");
INSERT INTO wlo_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Alawanimo Musa, \"Maka, ande iaku kupokawaaka manga miana Israel tee kupogau i manga incia, 'Aulataʼala opu-opuamiu alambokoaku to ingkomiu,' manga incia dhaanamo bheaabha, 'Incema o sarona?' Kasiimpo opea bhemomembalina kulawani i manga incia?\" ");
INSERT INTO wlo_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Firimanina Aulataʼala i Musa, \"Iakumo IAKU DHAANGIA. Siimo tabeana ipogauakamu i miana Israel, 'Incia isarongiaka IAKU DHAANGIA, padhamo alambokoaku to ingkomiu.' ");
INSERT INTO wlo_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Pakoleleakea uka i miana Israel ande Iaku, KAWASANA OPU, Aulataʼalana opuopuana manga incia, siitumo Aulataʼalana Ibrahim, Ishak, tee Yakub. Iakumo KAWASANA OPU, siitumo o saroku to saʼumurua. Siitumo tee saro incia sii, manga mia bheasarongiakaaku saʼumurua.\" ");
INSERT INTO wlo_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","\"Lingkamo tee urombusakea manga mancuana miana Israel, pakoleleakea i manga incia kooni, 'KAWASANA OPU, Aulataʼalana opuopuana manga incia, Aulataʼalana Ibrahim, Ishak tee Yakub, padhamo apatiumbaaka karona i iaku. KAWASANA OPU apogau, \"Iaku totuu-totuu padhamo kuumba i ingkomiu tee padhamo kumaheruakea tuaapa manga miana Mesir apewaukomiu. ");
INSERT INTO wlo_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Tee Iaku padhamo kubhotukiakea to bhekubhawa ingkomiu ulimba minaaka i tampana kanarakaamiu i Mesir, tee kubhawa ingkomiu i saangu lipu mosuburu motaralabhi-labhina susu tee golana uwanina, lipuna miana Kanaan, miana Het, miana Amori, miana Feris, miana Hewi tee miana Yebus.\" ' \" ");
INSERT INTO wlo_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Manga mancuana Israel bhearango manga pogaumu. Kasiimpo ingkoo upobhawa-bhawa tee manga mancuana miana Israel tabeana ulingka upoaro tee rajana Mesir tee upogau i incia, 'KAWASANA OPU, Aulataʼalana miana Ibrani, padhamo aumba apatiumbaaka karona i ingkami. Sii-sii mangaundaakamo talingka karidho talu eo i tana matuu tapasombaaka kurubani to KAWASANA OPU, Aulataʼalamami.\" ");
INSERT INTO wlo_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Kasiimpo Aulataʼala afirimanimo uka, \"Kumataua rajana Mesir inda bhearambasakakomiu ulingka, tabeana ande atopakisaa tee limaku momakaana. ");
INSERT INTO wlo_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Sabutuna, Iaku bhekupaulu limaku momakaa, tee ahisabu Mesir tee manga giu inda momentela bhekupadhaangia i tanga-tangana manga incia. Sapadhana sumai, dhaanamo incia bheaundaaka ingkomiu ulingka. ");
INSERT INTO wlo_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Iaku bhekupekaruna incana miana Mesir to ingkomiu, mamudhaakana manga amaasiakakomiu. Jadi wakutuuna ulingka, ingkomiu inda ulingka tee soomo rua mbalia limamiu. ");
INSERT INTO wlo_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Samia-samia bhawine Israel bheaemani minaaka i sarimbanuana miana Mesir tee minaaka i bhawine Mesir momboorena sabhanua, harataa mokoharagaa, pakea, tee agogona pera tee bulawa. Ingkomiu bheupakea to anaanamiu, malape umane tee bhawine. Tee akala mboo sumai ingkomiu bheurampasi harataana miana Mesir.\" ");
INSERT INTO wlo_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Kasiimpo Musa alawani i KAWASANA OPU, \"Maka, tuaapa ande manga miana Israel inda aunda aparacaea tee inda afaduliakea manga pogauku? Opea tabeana ipewauku ande manga incia apogau KAWASANA OPU inda apatiumbaaka karona i iaku?\" ");
INSERT INTO wlo_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","KAWASANA OPU aabha i Musa, \"Opea i limamu itu?\" Musa alawani, \"Katuko.\" ");
INSERT INTO wlo_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Firimanina KAWASANA OPU, \"Tudhaakea i tana.\" Musa atudhaakamea i tana, kasiimpo katuko sumai amembalimo ulo sabutuna Musa apalai pekaridho. ");
INSERT INTO wlo_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","KAWASANA OPU afirimani i Musa, \"Paulumea limamu tee rakoa lencina.\" Musa apaulumea limana, arakomea, kasiimpo ulo sumai amembalimo katuko pendua i limana. ");
INSERT INTO wlo_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Firimanina KAWASANA OPU, \"Pewaumo mboo sumai mamudhaakana manga miana Israel aparacaea ande Iaku, KAWASANA OPU, Aulataʼalana manga opuopuana, Aulataʼalana Ibrahim, Ishak tee Yakub, padhamo apatiumbaaka karona i ingkoo.\" ");
INSERT INTO wlo_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","KAWASANA OPU afirimanimo uka i Musa, \"Papesuamea o limamu i nuncana bhajumu.\" Musa aose, tee wakutuuna incia apalimba limana, limana sumai amaputimo mpuu roonamo akangkanaia panyaki kuli dhaa. ");
INSERT INTO wlo_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Kasiimpo KAWASANA OPU afirimani, \"Papesuaia limamu pendua i nuncana bhajumu.\" Musa apewau mboo sumai, tee wakutuuna apalimbaia uka, limana sumai auntomo mboomo bhaa-bhaana. ");
INSERT INTO wlo_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Firimanina KAWASANA OPU, \"Ande manga incia inda aparacaeako atawa inda ayaakini sapadhana akamata giu inda momentela tee katukomu, sumaimo manga incia bheaparacaea giu inda momentela sii bheupewaua tee limamu. ");
INSERT INTO wlo_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Maka ande manga incia indapo uka aparacaeako moomini padhamo akamata rua-rua angua giu inda momentela sii, tee manga incia inda afaduliakea manga pogaumu, alamo saidhe o uwe minaaka i Umala Nil tee ulalimea i tana. Kasiimpo uwe sumai bheabhalii amembali raa.\" ");
INSERT INTO wlo_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Maka o Musa apogau i KAWASANA OPU, \"E, Kawasana Opu, iaku mencuana mia momakidhana mopogau, malape i piamo itu atawa sii-sii. Moomini sapadhana Ingkoo upogau tee iaku, kupogau amanoe roonamo amatamo dhelaku tee inda kumakidha kupogau.\" ");
INSERT INTO wlo_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","KAWASANA OPU afirimani i incia, \"Incema buaka modhawuna muncu to maanusia? Incema buaka mopamembalina incia abhea atawa amabhongo? Incema mopamembalina incia apokamata atawa amawilo? Iaku, KAWASANA OPU, mopewauna bhari-bharia sumai! ");
INSERT INTO wlo_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Jadi, lingkamo. Iaku bhekutulungiko upogau tee uadhariaka opea tabeana bheubhoasaka.\" ");
INSERT INTO wlo_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Maka Musa alawani, \"Iaku kuemani mpuu, bholimo ulamboko iaku, e Kawasana Opu, tumpumo mia mosagaanana.\" ");
INSERT INTO wlo_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Sumaimo KAWASANA OPU aʼamara i Musa tee apogau, \"Mencuana ingkoo buaka mokowitinaina mokosarona Harun? Iaku kumataua incia amakidha apogau. Satotuuna, incia i nuncana lingkaana tangasaana arope iwe sii, tee incia bheasanaa apokawa tee ingkoo. ");
INSERT INTO wlo_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Ingkoo tabeana upogau i incia tee upaumbaakea opea tabeana ipogauakana. Iaku bhekutulungi rua miakomiu tee kuadhariaka opea tabeana ipogauakamiu tee ipewaumiu. ");
INSERT INTO wlo_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Incia bheapogau to saromu i manga miana Mesir sumai. Mboomo Aulataʼala, ingkoo bheupaumbaakea opea tabeana ibhoasakana, tee incia bheamembali mopakawaakana pogaumu. ");
INSERT INTO wlo_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Bhawamea katuko sumai, tee upakea to upewau manga giu inda momentela tee katuko sumai. ");
INSERT INTO wlo_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Sapadhana sumai Musa ambulimo i bhanuana Yitro, ama maniana, tee apogau i incia, \"Undakaakumo kumbuli i manga witinaiku i Mesir to kukamata manga incia ara dhaangiapo adhadhi.\" Yitro apogau i Musa, \"Lingkamo tee usalaamati.\" ");
INSERT INTO wlo_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Wakutuuna Musa dhaangiapo i Tana Midian, KAWASANA OPU apogau i incia, \"Mbulimo i Mesir. Bhari-bharia mia mohaejatina to apekamateko amatemo.\" ");
INSERT INTO wlo_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Kasiimpomo Musa akemba bhawinena tee manga anana umane, apakompaia manga i bhawona sambaa keledai kasiimpo ambuli i Tana Mesir. Incia uka abhawa katukona Aulataʼala. ");
INSERT INTO wlo_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","KAWASANA OPU afirimani i Musa, \"Iaku padhamo kudhawuko kuasa to upewau manga giu inda momentela. Jadi ande ingkoo umbuli i Mesir naile itu, pewaumea sagala giu inda muuzizati sumai i aroana Firaun. Maka Iaku bhekupekakaaia incana, mamudhaakana incia inda aundaakea miana lipu sumai alingka. ");
INSERT INTO wlo_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Pogauakamea i Firaun mboo sii, 'KAWASANA OPU aposamea, \"Israel satotuuna o ana tumpeku, ");
INSERT INTO wlo_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","tee kufirimani i ingkoo: Undaakea anaku sumai alingka mamudhaakana incia amembali asambahea i Iaku. Ande ingkoo umendeu, sumaimo Iaku bhekupekamate anamu, siitumo o ana tumpemu.\" ' \" ");
INSERT INTO wlo_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","I saangu tampa pokemaa i nuncana lingkaana sumai, KAWASANA OPU aumbati Musa ahaejati to apekamatea. ");
INSERT INTO wlo_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Maka, Zipora bhawinena, aalamo saangu bhatu matadha to atandaki anana, kasiimpo apadhingkuakea o kuli sumai i aena Musa. Pogauna Zipora, \"Ingkoo umaneku itandaiku tee raa.\" ");
INSERT INTO wlo_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","(Zipora apogauaka giu incia sumai roonamo incia padhamo atandaki ana umanena.) Sabutuna KAWASANA OPU inda asidha apekamate Musa. ");
INSERT INTO wlo_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","KAWASANA OPU afirimanimo i Harun, \"Lingkamo i tana matuu upokawa tee Musa.\" Sumaimo, Harun alingkamo, kasiimpo apokawa tee andina i gununa Aulataʼala, tee aikia. ");
INSERT INTO wlo_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Musa apetulatulaakea i Harun bhari-bharia firimanina KAWASANA OPU itumpuakana i incia to apakawaakea, tee uka bhari-bharia giu inda momentela iparintaakana i incia to apewaua. ");
INSERT INTO wlo_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Kasiimpomo Musa tee Harun alingka i Mesir tee aromusaka bhari-bharia manga mancuanana Israel. ");
INSERT INTO wlo_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Harun apakawaaka i manga incia bhari-bharia ifirimaniakana KAWASANA OPU i Musa, tee Musa akarajaaia bhari-bharia giu inda momentela i aroana manga mia sumai. ");
INSERT INTO wlo_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Sumaimo aparacaeamo manga incia, tee wakutuuna arangoa ande KAWASANA OPU padhamo amaheruakea miana Israel tee akamatea bhari-bharia kanarakaana manga, manga incia asuju asomba. ");
INSERT INTO wlo_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Kasiimpo Musa tee Harun alingka apoaro tee Firaun tee apogau, \"Mboo sii parintana KAWASANA OPU, Aulataʼalana Israel, 'Undaakamea manga miana lipuku alingka mamudhaakana manga incia amembali apadhaangia kariaa to Iaku i tana matuu.' \" ");
INSERT INTO wlo_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Maka o Firaun aabha, \"Incema buaka KAWASANA OPU sumai? Pokia iaku tabeana kufaduliaka Incia tee kuundaaka miana Israel alingka? Iaku inda kupomataua tee KAWASANA OPU sumai, tee miana Israel inda uka kuundaakea alingka.\" ");
INSERT INTO wlo_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Musa tee Harun apogau, \"Aulataʼalana miana Ibrani padhamo apatiumba karona i ingkami. Mangaundaaka ingkami talingka i tana matuu karidho talu eo talingkaisia to tapasombaaka kurubani i KAWASANA OPU, Aulataʼalamami, mamudhaakana Incia inda ahisabu i ingkami tee panyaki imateakamami atawa tee potimbea.\" ");
INSERT INTO wlo_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Maka, pogauna raja Mesir i manga incia, \"Musa tee Harun, pokia ingkomiu ubarani upewau manga mia sumai abholi karajaana manga? Bhari-bharikomiu mbuli karajaa! ");
INSERT INTO wlo_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Kamatea, manga miana Ibrani i lipu sii ahandamo laulau kabharina tee sii-sii gaumiu mamudhaakana manga incia aunto akarajaa!\" ");
INSERT INTO wlo_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Sabutuna, i eo incia sumai uka Firaun aparintangi manga miana Mesir mojaganina bhatua tee manga mandorona miana Israel mboo sii, ");
INSERT INTO wlo_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","\"Bholimo uka udhawua laena gandum i lipu incia sumai to akarajaa bhatu bata. Taroakamo manga incia alingka apeelo samia-samia. ");
INSERT INTO wlo_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Maka tumpumea manga incia akarajaa bhatu bata apokana kabharina minaaka mopadhana, bholi akura. Manga incia amangare uka, siitumo sababuna manga incia torotorosu akagora-gora, 'Mangaundaaka ingkami talingka tasumbele kurubani to Aulataʼalamami.' ");
INSERT INTO wlo_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Pakisaaia manga mia sumai akarajaa pekakaa, mamudhaakana manga incia aʼurusu karajaana tee inda dhaangia o wakutuuna to aperangoi manga tulatula inda mototuu.\" ");
INSERT INTO wlo_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Sumaimo, manga miana Mesir mojaganina bhatua tee manga mandorona miana Israel sumai alimba kasiimpo apogau i manga miana Israel, \"Mboo sii parintana Firaun, 'Iaku inda kudhawu laena gandum pendua i ingkomiu. ");
INSERT INTO wlo_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Ingkomiu tabeana upeelo samia-miamiu iapaipo uka, maka udhania, bhatu bata ikarajaamiu inda amembali akura minaaka mopadhana.' \" ");
INSERT INTO wlo_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Sumaimo alingkamo miana Israel ambeliki saangua Tana Mesir to arombusakaaka laena gandum to abholosi laena gandum idhawuakana miana Mesir i saao. ");
INSERT INTO wlo_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Manga miana Mesir mojaganina bhatua torosu apakisaa tee apogau, \"Saeo-saeo ingkomiu tabeana ukohasiliaka bhatu bata mopokanana kabharina mboomo wakutuu utarima laena bhae.\" ");
INSERT INTO wlo_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Kasiimpo manga mojaganina bhatua sumai abhebhe manga mandorona miana Israel mojaganina mia mokarajaana. Manga incia aabha, \"Pokia sii-sii ingkomiu inda ukohasiliaka bhatu bata mopokanana kabharina mboomo i piamo itu?\" ");
INSERT INTO wlo_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Sapadhana incia sumai, manga mandorona miana Israel alingka apoaro i Firaun tee apeenci, \"Pokia Opuku upewau mboo sii i ingkami? ");
INSERT INTO wlo_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Ingkami inda tatodhawu pendua laena bhae, garaaka ingkami tatoparinta mboo sii, 'Karajaa bhatu bata!' Mataua, sii-sii ingkami tatobhebhe, garaaka manga pagawena Opu mosalana!\" ");
INSERT INTO wlo_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Maka Firaun alawani, \"Ingkomiu dhaanamo umangare, umendeu ukarajaa. Siitumo sababuna ingkomiu uposanga i iaku to ulingka upasombaaka kurubani i KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Sii-sii, lingkamo ukarajaa pendua! Laena bhae inda bhekudhawuakakomiu, maka ingkomiu tabeana ukarajaa bhatu bata mopokanana kabharina.\" ");
INSERT INTO wlo_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Sumaimo manga mandorona miana Israel sumai asadara ande manga incia i nuncana kanarakaa wakutuuna apaumbaakea ande manga miana Israel tabeana akohasiliaka bhatu bata mopokanana kabharina mboomo mopadhana. ");
INSERT INTO wlo_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Wakutuuna manga incia alimba minaaka i malige, manga incia apokawa tee Musa tee Harun tangasaana akabhale-bhale aantagi manga incia. ");
INSERT INTO wlo_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Pogauna manga mandorona sumai, \"Sio-siomo KAWASANA OPU amataua opea ipewaumiu tee bheahukumukomiu! Ingkomiumo mopamembalina ingkami tatobanci i aroana Firaun tee manga pagawena. Pewaumiu apokana tee udhawu samata ewanga i limana manga incia to apekamate ingkami!\" ");
INSERT INTO wlo_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Kasiimpo Musa alingka apokawa tee KAWASANA OPU tee apogau, \"Kawasana Opu, pokia tee kakaana incamu upewau miana Israel mboo sumai? Pokia Ingkoo ulambokoaku iwe sii? ");
INSERT INTO wlo_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Sababuna minaaka bhaa-bhaana kupoaro tee Firaun to kupakawaaka kasameamu, incia asikisaa miana lipu sii. Maka Ingkoo inda upewau opeopea uka to urambasaka manga incia.\" ");
INSERT INTO wlo_vpl VALUES ("EX5_24","003_5_24","EXO","5","24","24","Kasiimpo KAWASANA OPU afirimani i Musa, \"Sii-sii ingkoo bheukamatea tuaapa bhekupewau Firaun, roonamo incia bhekupakisaaia arambasaka lipuku. Satotuuna, Iaku bhekupakisaa Firaun tee limaku momakaana mamudhaakana bheapadhencu manga incia minaaka i lipuna.\" ");
INSERT INTO wlo_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Aulataʼala afirimanimo i Musa, pogauna, \"Iakumo KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Iaku padhamo kupatiumbaaka karoku i Ibrahim, Ishak, tee Yakub mboomo Aulataʼala Mokokuasa, maka Iaku inda kupepematauaka karoku i manga incia tee o saroku KAWASANA OPU.' ");
INSERT INTO wlo_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Iaku uka kupadhaangia pojanjia tee manga incia. Iaku padhamo kujanji bhekudhawuakea Tana Kanaan to manga incia, tampana manga i piamo itu adhadhi mboomo mia dhaga. ");
INSERT INTO wlo_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Sii-sii Iaku padhamo kurangoa pekeena miana Israel rampaakanamo ipabhatuana miana Mesir, tee kuudhania pojanjiaku sumai. ");
INSERT INTO wlo_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Sabutuna, pakoleleakamea i manga miana Israel ande kupogau i manga incia, 'Iakumo KAWASANA OPU, tee Iaku bhekupabebasikomiu minaaka i karajaa rodi tee kurambasakakomiu minaaka i kapabhatuana miana Mesir. Iaku bhekususuakakomiu kuasaku momaogena to kutolosiaka ingkomiu tee kupekandawuakea kahukumu matamo i miana Mesir. ");
INSERT INTO wlo_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Iaku bhekupamembalikomiu uumatiku, tee kumembali Aulataʼalamiu. Sumaimo ingkomiu bheumataua ande Iaku sii KAWASANA OPU, Aulataʼalamiu, morambasakakomiu minaaka i miana Mesir mopabhatuakomiu. ");
INSERT INTO wlo_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Iaku bhekubhawakomiu i lipu ijanjiakaku tee sumpa i Ibrahim, Ishak tee Yakub. Iaku bhekudhawuakakomiu tana sumai to amembali pewauamiu; Iakumo KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Kasiimpomo Musa apakawaaka bhari-bharia kasameana KAWASANA OPU sumai i miana Israel, maka manga incia inda aperangoi Musa, rampaakanamo amate akalana tee roonamo kapabhatua momakaa sumai. ");
INSERT INTO wlo_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Kasiimpomo KAWASANA OPU afirimani i Musa, ");
INSERT INTO wlo_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","\"Lingkamo poaro i Firaun, rajana Mesir, mamudhaakana aundaakea miana Israel abholi lipuna.\" ");
INSERT INTO wlo_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","Maka Musa alawani i KAWASANA OPU, \"Tuaapa amembali Firaun aperangoi mia inda momakidhana mopogau mboomo iaku, sainamo miana Israel uka amendeu aperangoiaku?\" ");
INSERT INTO wlo_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Mboo sumaimo KAWASANA OPU atumpu tee alamboko Musa tee Harun i miana Israel tee i Firaun, rajana Mesir, to abhawa miana Israel alimba minaaka i Tana Mesir. ");
INSERT INTO wlo_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","O siimo manga kapalana kaomuna siwuluna Israel: Manga anana Ruben, anana tumpena Yakub, akoanaaka pata mia anana umane: siitumo Henokh, Palu, Hezron, tee Karmi. Siitumo manga kaomuna Ruben. ");
INSERT INTO wlo_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Simeon akoanaaka nama mia ana umane: siitumo Yemuel, Yamin, Ohad, Yakhin, Zohar tee Saul. Saul sii anana samia bhawine miana Kanaan. Siitumo manga kaomuna Simeon. ");
INSERT INTO wlo_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Lewi akoanaaka talu mia ana umane: siitumo Gerson, Kehat, tee Merari. Siitumo sarona manga anana Lewi tee siwuluna sumbesumbere. Lewi akoʼumuru 137 tao. ");
INSERT INTO wlo_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Manga anana Gerson: siitumo Libni tee Simei mboomo kaomuna manga. ");
INSERT INTO wlo_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Manga anana Kehat: siitumo Amram, Yizhar, Hebron, tee Uziel. Kehat akoʼumuru 133 tao. ");
INSERT INTO wlo_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Manga anana Merari: siitumo Mahli tee Musi. Siitumo manga kaomuna Lewi tee siwuluna sumbesumbere. ");
INSERT INTO wlo_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Amram akobhawineaka Yokhebed, witinaina amana, tee bhawinena sumai akoanaaka Harun tee Musa to incia. Amram akoʼumuru 137 tao. ");
INSERT INTO wlo_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Manga anana Yizhar: siitumo Korah, Nefeg, tee Zikhri. ");
INSERT INTO wlo_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Manga anana Uziel: siitumo Misael, Elsafan tee Sitri. ");
INSERT INTO wlo_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Harun akawi tee Eliseba, anana bhawine o Aminadab, Eliseba uka apowitinai tee Nahason. Eliseba apalaahiri Nadab, Abihu, Eleazar tee Itamar. ");
INSERT INTO wlo_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Manga anana Korah: siitumo Asir, Elkana, tee Abiasaf. Siitumo manga kaomuna Korah. ");
INSERT INTO wlo_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Eleazar, anana umane o Harun, akawi tee sala samia anana Putiel, tee anana manga incia Pinehas. Siitumo bhari-bharia kapalana kaomuna Lewi mboomo siwuluna. ");
INSERT INTO wlo_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Siitumo Harun tee Musa motarimana firimanina KAWASANA OPU mboo sii, \"Bhawea manga miana Israel alimba minaaka i Mesir, sarombonga-sarombonga. ");
INSERT INTO wlo_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Manga incia arua mia apokawaaka rajana Mesir mamudhaakana incia apabebasi miana Israel. ");
INSERT INTO wlo_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Wakutuuna KAWASANA OPU apogau tee Musa i Tana Mesir, ");
INSERT INTO wlo_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","firimanina KAWASANA OPU mboo sii, \"Iakumo KAWASANA OPU. Pakawaakea i Firaun, rajana Mesir, bhari-bharia mopadhana ipogauakaku i ingkoo.\" ");
INSERT INTO wlo_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","Maka, Musa alawani, \"KAWASANA OPU, Ingkoo umataua ande iaku inda kumakidha kupogau. Tuaapa amembali o Firaun aunda aperangoiaku?\" ");
INSERT INTO wlo_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","KAWASANA OPU afirimani i Musa, \"Iaku bhekupamembaliko mboomo Aulataʼala i aroana Firaun, tee witinaimu Harun bheapogau i incia mboomo nabiimu. ");
INSERT INTO wlo_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Pakawaakea i Harun bhari-bharia iparintaakaku i ingkoo. Tumpumea Harun apogauakea i Firaun mamudhaakana incia aundaakea miana Israel abholi Mesir. ");
INSERT INTO wlo_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Maka Iaku bhekupekakaaia incana Firaun tee kupekabari manga tanda inda momentela tee manga muuzizatiku i Tana Mesir. ");
INSERT INTO wlo_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Moomini mboo sumai, Firaun inda bheaperangoikomiu. Sababuna sumai, Iaku bhekudhika limaku i bhawona Mesir tee kupalimba tantaraku, siitumo uumatiku manga miana Israel, minaaka i Tana Mesir tee kahukumu matamo. ");
INSERT INTO wlo_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Jadi miana Mesir bheamataua ande Iaku sii KAWASANA OPU, i wakutuuna kuhukumu manga incia tee kubhawa miana Israel alimba minaaka i lipuna manga incia.\" ");
INSERT INTO wlo_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Mboo sumai uka apewaua Musa tee Harun. Musa tee Harun aose opea iparintaakana KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Musa akoʼumuru 80 tao tee Harun 83 tao wakutuuna manga incia apogau i Firaun. ");
INSERT INTO wlo_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","KAWASANA OPU afirimani i Musa tee Harun mboo sii, ");
INSERT INTO wlo_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","\"Ande o Firaun aemani ingkomiu upewau saangu muuzizati to bukutii ande Aulataʼala alambokokomiu, sumaimo tumpumo Harun, 'Alea katukomu tee utudhaakea i tana i aroana Firaun.' Kasiimpo katuko sumai bheabhalii amembali ulo.\" ");
INSERT INTO wlo_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Sumaimo, alingkamo Musa tee Harun apoaro i Firaun tee manga incia apewau opea iparintaakana KAWASANA OPU. Harun atudhaaka katukona i tana i aroana Firaun tee manga pagawena, kasiimpo katuko sumai abhalii amembali ulo. ");
INSERT INTO wlo_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Kasiimpo, Firaun uka akemba manga mia mokoʼilimuuna tee manga pande sihiri, kasiimpo manga ahalii sihiri apewau mboo sumai uka tee ilimuuna manga. ");
INSERT INTO wlo_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Manga incia atudhaaka katukona samia-samia i tana tee manga katuko sumai abhalii amembali ulo, maka o katukona Harun adhoku katukona manga incia. ");
INSERT INTO wlo_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Moomini mboo sumai, Firaun sadhaadhaa amakaa incana. Incia inda aperangoi pogauna Musa tee Harun, mboomo mopadhana ifirimaniakana KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Kasiimpo KAWASANA OPU afirimani i Musa, \"Incana Firaun amakaa. Incia inda aundaakea miana Israel alingka. ");
INSERT INTO wlo_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Sababuna sumai, lingkamo upokawaaka incia saeona, i wakutuuna incia sadia asapo i Umala Nil. Bhawamo katukomu momembalina abhalii membali ulo sumai tee uantagia umbaana i bhiwina umala. ");
INSERT INTO wlo_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Pogauakamea i Firaun, 'KAWASANA OPU, Aulataʼalana miana Ibrani, molambokoaku to kupakawaaka i ingkoo tee firimanina mboo sii, \"Undaakea uumatiku alingka to asambahea i Iaku i tana matuu.\" Maka sampe sii-sii ingkoo inda uunda uperangoia. ");
INSERT INTO wlo_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Sababuna sumai, KAWASANA OPU apogau mboo sii, \"Minaaka i opea ipewauna naile itu, ingkoo bheumataua ande Iakumo KAWASANA OPU.\" Kamatea, tee katuko incia sii iaku bhekubhebhe bhawona uwena umala, tee o uwena bheabhalii amembali raa. ");
INSERT INTO wlo_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Manga ikane i nuncana umala bheamate, sabutuna umala bheakobhou mabhongko, tee manga miana Mesir bheamarika to asumpu uwena.' \" ");
INSERT INTO wlo_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","KAWASANA OPU afirimani pendua i Musa, \"Tumpumo Harun, 'Alea katukomu tee upaulua limamu i bhawona bhari-bharia uwena miana Mesir, i bhawona manga umala, parigi, kolam, tee lembokana uwe modhaangiana i manga incia, mamudhaakana uwena bheamembali raa, tee i saangua Tana Mesir bheadhaangia tee raa, sampemo uka i nuncana manga dhingkana minaaka i kau atawa i bhatu.\" ");
INSERT INTO wlo_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Musa tee Harun apewau opea iparintaakana KAWASANA OPU. I aroana Firaun tee manga pagawena, Harun aangka katukona tee abhebhe uwena Umala Nil, sabutuna saangua uwena abhalii amembali raa. ");
INSERT INTO wlo_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Manga ikane i nuncana Umala Nil amate tee bhouna amabhongko, sabutuna miana Mesir inda amembali asumpu uwe sumai. I saangua Tana Mesir dhaangia tee raa. ");
INSERT INTO wlo_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Maka manga ahalii ilimuu sihirina Mesir apewau mboo sumai uka tee ilimuu sihirina manga, sabutuna o Firaun sadhaadhaana amakaa incana. Mboomo mopadhana ipogauakana KAWASANA OPU, Firaun inda aunda aperangoi Musa tee Harun. ");
INSERT INTO wlo_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Firaun ambuli i maligena tee inda amaheruakea hali incia sumai saidhe uka. ");
INSERT INTO wlo_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Bhari-bharia miana Mesir aseli bhalo to apeelo uwe isumpu inda maridho minaaka i Umala Nil, roonamo uwena umala sumai inda amembali atosumpu. ");
INSERT INTO wlo_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Mboomo sumai amondo pitu eo sapadhana KAWASANA OPU atunda Umala Nil. ");
INSERT INTO wlo_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Kasiimpo KAWASANA OPU afirimani i Musa, \"Lingkamo upoaro tee Firaun tee upogau mboo sii tee incia, 'Mboo sii firimanina KAWASANA OPU, \"Undaakea uumatiku alingka, mamudhaakana manga incia amembali asambahea i Iaku. ");
INSERT INTO wlo_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Ande ingkoo umendeu utaroakea manga incia abholi Tana Mesir sii, bhekutundaia saangua lipumu sii tee barakaka. ");
INSERT INTO wlo_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Umala Nil bheabukeaka barakaka. Manga barakaka sumai bhealimba minaaka i uwe tee apesua i nuncana maligemu, i nuncana kamaramu tee i kolemamu, i nuncana manga bhanuana pagawemu tee raʼeatimu, tee uka i nuncana tampana tunuana rotimu tee manga tampana dhingkana to kusoana kajalona rotimu. ");
INSERT INTO wlo_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Manga barakaka sumai bheakompasi ingkoo, raʼeatimu, tee manga pagawemu.\" ' \" ");
INSERT INTO wlo_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","KAWASANA OPU afirimani i Musa, \"Tumpumo Harun mboo sii, 'Paulua limamu tee katukomu i bhawona manga umala, manga parigi tee manga tampa lembokana uwe mamudhaakana manga barakaka aposatiumba tee apabuke Tana Mesir. ");
INSERT INTO wlo_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Harun uka apaulu limana i bhawona bhari-bharia uwe i Tana Mesir, kasiimpo atiumbamo manga barakaka apabuke saangua lipu. ");
INSERT INTO wlo_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Maka manga ahalii sihiri apake ilimuuna manga, sabutuna manga incia apewau uka barakaka aposatiumba i saangua Tana Mesir. ");
INSERT INTO wlo_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Kasiimpomo, Firaun akemba Musa tee Harun tee apogau, \"Doʼamo i KAWASANA OPU mamudhaakana Incia apadhencu manga barakaka sii, sumaimo iaku bhekuundaakea manga miana lipumu alingka to apasombaaka kurubani i KAWASANA OPU.\" ");
INSERT INTO wlo_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Alawanimo o Musa, \"Umbe. Soo upeelomo wakutuu naepia bhekudoʼa to ingkoo tee manga pagawemu tee raʼeatimu, mamudhaakana ingkoo bheutopabebasi minaaka i manga barakaka sumai i maligemu tee minaaka i manga bhanuana pagawe tee raʼeatimu. Manga barakaka tangkanamo bheamboore i Umala Nil.\" ");
INSERT INTO wlo_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Alawanimo Firaun, \"Naile.\" Kasiimpo Musa apogau, \"Membalimo mboomo pogaumu itu, mamudhaakana ingkoo bheumataua ande inda dhaangia mosagaanana mboomo KAWASANA OPU, Aulataʼalamami. ");
INSERT INTO wlo_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Incia bheapadhencu manga barakaka minaaka i ingkoo, manga bhanuamu, manga pagawemu, tee raʼeatimu, sabutuna tangkanamo bheamboore i Umala Nil.\" ");
INSERT INTO wlo_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Kasiimpo Musa tee Harun abholi Firaun, tee Musa adoʼa i KAWASANA OPU mamudhaakana apadhencua manga barakaka iumbaakana to Firaun. ");
INSERT INTO wlo_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","KAWASANA OPU arango iemanina Musa, tee manga barakaka modhaangiana i manga bhanua, i manga aroana bhamba tee manga inawu amate bhari-bharia. ");
INSERT INTO wlo_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Miana Mesir arombusaka bangkena manga barakaka sumai sampe akokabumbu, sabutuna saangua lipu akobhou mabhongko. ");
INSERT INTO wlo_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Maka wakutuuna Firaun akamata ande manga barakaka sumai amatemo, amagaagaamo namisina, tee ambuli amakaa incana. Tee mboomo mopadhana ipogauakana KAWASANA OPU, incia inda aunda aperangoi pogauna Musa tee Harun. ");
INSERT INTO wlo_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","KAWASANA OPU afirimani i Musa, \"Tumpumea o Harun mboo sii, 'Paulua katukomu tee ubhebheakea i ngawuna tana, sabutuna ngawu abhalii amembali ngkonunu i saangua Tana Mesir.' \" ");
INSERT INTO wlo_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Kasiimpo manga incia apewau mboo sumai; Harun apaulu limana tee katukona tee abhebheakea i ngawuna tana, sabutuna bhari-bharia ngawu i Mesir abhalii amembali ngkonunu mosampana i maanusia tee binata. ");
INSERT INTO wlo_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Manga ahalii sihiri aʼusaha apake ilimuuna manga to uka apadhaangia manga ngkonunu, maka manga incia inda amembali. Mboo sumaimo manga ngkonunu asampa i maanusia tee binata. ");
INSERT INTO wlo_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Kasiimpo manga ahalii sihiri sumai apogau i Firaun, \"Siimo limana Aulataʼala.\" Maka incana Firaun sadhaadhaa amakaa, mboomo mopadhana ipogauakana KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","KAWASANA OPU afirimani i Musa, \"Lingkamo saeona mpuu tee uantagi Firaun i wakutuuna incia sadia asapo i umala. Pogauakea pogauku sii, 'Mboo siimo firimanina Aulataʼala, \"Undaakamea uumatiku alingka asambahea i Iaku. ");
INSERT INTO wlo_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Ande ingkoo umendeu, siitumo Iaku bhekuumbaaka lale i ingkoo, i manga pagawemu, tee raʼeatimu. Mboo sumai uka manga bhanuana miana Mesir tee saangua lipu mbooresana bheabuke tee lale mosampa. ");
INSERT INTO wlo_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Maka Iaku inda bhekupapokanea tee lipu Gosyen, tampana uumatiku amboore. Iwe sumai inda bheadhaangia tee lale mosampa, mamudhaakana umataua ande Iaku, KAWASANA OPU, mopewauna hali incia sumai. ");
INSERT INTO wlo_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Iaku bhekupewau posalana i tanga-tangana uumatiku tee raʼeatimu. Naile tanda inda momentela sumai bheamembali.\" ' \" ");
INSERT INTO wlo_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","KAWASANA OPU aumbaaka lale mosampa mobharina mpuu i maligena Firaun tee i bhanuana manga pagawena. Saangua lipuna Mesir anarakaa mpuu roonamo manga lale sumai. ");
INSERT INTO wlo_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Kasiimpomo, Firaun akemba Musa tee Harun tee apogau, \"Lingkamo, upasombaaka kurubani i Aulataʼalamiu, maka soo i lipu sii uka.\" ");
INSERT INTO wlo_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Lawanina Musa, \"Inda alaenga ingkami tapewau mboo sumai roonamo miana Mesir bheanamisi amarika mpuu ande akamata ingkami tapasombaaka binata to kurubani sumai i KAWASANA OPU, Aulataʼalamami. Ande tapewau mboo sumai i aroana manga incia, dhaanamo bheamanga tudhaaka bhatu sakawana tamate. ");
INSERT INTO wlo_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Ingkami tabeana talingka i tana matuu karidho talu eo i dhala to tapasombaaka kurubani i KAWASANA OPU Aulataʼalamami, mboomo iparintangiakana i ingkami.\" ");
INSERT INTO wlo_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Firaun afirimani, \"Umbe, kuundaakakomiu ulingka i tana matuu to upasombaaka kurubani i KAWASANA OPU, Aulataʼalamiu, soomana ingkomiu inda ulingka maridho. Udhania, doʼaakaakumo!\" ");
INSERT INTO wlo_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Lawanina Musa, \"Sapadhana kulingka, iaku lausaka kudoʼa i KAWASANA OPU mamudhaakana naile manga lale mosampa sumai bheatopadhencu minaaka i ingkoo, manga pagawemu, tee raʼeatimu. Maka bholimo ugau-gau uka, tee bholi ujoli-joli miana Israel alingka to apasombaaka kurubani i KAWASANA OPU.\" ");
INSERT INTO wlo_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Musa abholi Firaun, kasiimpo adoʼa i KAWASANA OPU, ");
INSERT INTO wlo_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","tee KAWASANA OPU arango doʼana Musa. Manga lale mosampa sumai aposapolakamo abholi Firaun, manga pagawena tee raʼeatina. Inda sambaa uka motobholina. ");
INSERT INTO wlo_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Maka sapadhana incia sumai uka, Firaun sadhaadhaa amakaa incana tee inda aundaakea manga miana Israel sumai alingka. ");
INSERT INTO wlo_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","KAWASANA OPU afirimani i Musa, \"Lingkamo upoaro i Firaun, tee upogau i incia, 'Mboo sii firimanina KAWASANA OPU, Aulataʼalana miana Ibrani, \"Taroakamo uumatiku alingka mamudhaakana manga incia amembali asambahea i Iaku. ");
INSERT INTO wlo_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Ande ingkoo umendeu utaroakea manga incia alingka tee utorosu utaangia, ");
INSERT INTO wlo_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","Iaku bhekuumbaaka kalelei momakaa to bhari-bharia kadhambaakamu, siitumo ajara, keledai, unta, sapi, dumba, tee bhembemu. ");
INSERT INTO wlo_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Iaku bhekupaposala kadhambaakana miana Israel tee kadhambaakana miana Mesir. Minaaka i kadhambaakana miana Israel inda sambaa uka bhemomatena. ");
INSERT INTO wlo_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Iaku, KAWASANA OPU, kupatotapuakea naile to kupewau giu incia sumai.\" ' \" ");
INSERT INTO wlo_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Samainawana KAWASANA OPU apewau mboomo mopadhana ipogauakana. Bhari-bharia kadhambaakana miana Mesir amate, maka minaaka kadhambaakana miana Israel sambaa uka inda dhaangia momatena. ");
INSERT INTO wlo_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Kasiimpo Firaun atumpu manga pagawena alingka i mbooresana miana Israel to aabhaaka opea momembalina. Kasiimpo manga incia apetulatulaakea ande minaaka i kadhambaakana miana Israel inda sambaa uka momatena. Maka o Firaun sadhaadhaa amakaa incana tee amendeu ataroaka miana Israel sumai alingka. ");
INSERT INTO wlo_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","KAWASANA OPU afirimani i Musa tee Harun, \"Alamea pia-pia pundu rapu minaaka i tampa tunuana reo. I aroana Firaun, Musa tabeana akamburaka rapu sumai. ");
INSERT INTO wlo_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Siitumo rapu sumai bheamembali ngawu motutubhina saangua Tana Mesir bhemoumbaakana manga kabhisu momapasa momembalina kambela mokonana i maanusia tee binata.\" ");
INSERT INTO wlo_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Sumaimo Musa tee Harun aala rapu minaaka i tampa tunuana reo, kasiimpo manga akakaro apoaro i Firaun. Musa akamburaka rapu sumai i antara tee atiumbamo manga kabhisu momapasa momembalina kambela mokonana i maanusia tee binata. ");
INSERT INTO wlo_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Manga ahalii sihiri inda amembali akakaro apoaro tee Musa roonamo saangua badana manga abukeaka kabhisu mboomo manga miana Mesir mosagaanana. ");
INSERT INTO wlo_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Maka KAWASANA OPU apekakaa incana Firaun, sabutuna inda aperangoi pogauna Musa tee Harun, mboomo ifirimaniakana KAWASANA OPU i Musa. ");
INSERT INTO wlo_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","KAWASANA OPU afirimani i Musa, \"Lingkamo saeona mpuu uantagi Firaun, tee upogauakea i incia, 'Mboo sii firimanina KAWASANA OPU, Aulataʼalana miana Ibrani, \"Taroakamo uumatiku alingka mamudhaakana manga incia amembali asambahea i Iaku. ");
INSERT INTO wlo_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Roonamo sampearona sii Iaku bhekuumbaaka sagala balaa i karomu samia, manga pagawemu, tee raʼeatimu, mamudhaakana umataua ande inda dhaangia o dhimbaku i saangua alamu sii. ");
INSERT INTO wlo_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Sii-sii, ande kupeelu kupaulu limaku to kupekamateko tee raʼeatimu tee kalelei, dhaanamo ingkomiu ubinasamo. ");
INSERT INTO wlo_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Maka kutaroakako udhadhi, mamudhaakana amembali kususuaka kuasaku i ingkoo tee mamudhaakana saroku atopakoleleaka i saangua alamu. ");
INSERT INTO wlo_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Moomini mboo sumai, ingkoo dhaangiapo uka usombo tee inda uundaakea uumatiku alingka! ");
INSERT INTO wlo_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Satotuuna, naile saeona, i wakutuu mopokana, Iaku bhekuumbaaka waona esi momaranca mpuu, mboomo indapo mina mopadhana momembalina i Mesir minaaka i piamo itu sampe sii-sii. ");
INSERT INTO wlo_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Sababuna sumai, parintaakamea mamudhaakana bhari-bharia kadhambaaka tee sabhara pewauamu modhaangiana i sambali ubhawea i tampa moʼamani. Bhari-bharia mia tee kadhambaaka modhaangiana i sambali ande inda apeulu bheamate akangkanaia waona esi.\" ");
INSERT INTO wlo_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Pia-pia mia i tanga-tangana manga pagawena Firaun amaeka tee firimanina KAWASANA OPU. Manga incia atumpu manga bhatuana tee kadhambaakana apalai apesua i nuncana bhanua mamudhaakana apeulu. ");
INSERT INTO wlo_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Sainamo dhaangia uka manga pagawena inda moperangoina firimanina KAWASANA OPU tee abholi manga bhatuana tee kadhambaakana manga incia i inawu. ");
INSERT INTO wlo_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Kasiimpo KAWASANA OPU afirimani i Musa, \"Angkamea limamu i laiana, tee o waona esi bheasapo i saangua Tana Mesir. Waona esi sumai bheakangkanai maanusia, kadhambaaka tee bhari-bharia penembula i inawu i Tana Mesir.\" ");
INSERT INTO wlo_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Musa aangka katukona i laiana, kasiimpo KAWASANA OPU apasapo guntu tee waona esi, tee waa mokakila-kila i dunia. KAWASANA OPU apatipuaka Tana Mesir tee waona esi. ");
INSERT INTO wlo_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Tee asapomo waona esi, tee waa mokakila-kila i tanga-tangana waona esi sumai, momakaana mpuu i saangua lipuna miana Mesir. Indapo mina adhaangia giu sumai minaaka i auwalina lipuna Mesir. ");
INSERT INTO wlo_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","I saangua lipu waona esi sumai apabinasa bhari-bharia modhaangiana i inawu, malape maanusia atawa kadhambaaka. Bhari-bharia penembula i inawu uka amadhaki tee manga puuna kau apatobhatea. ");
INSERT INTO wlo_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Tangkanamo i Tana Gosyen, tampa mbooresana manga miana Israel, waona esi inda asapo. ");
INSERT INTO wlo_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Kasiimpo, Firaun akemba Musa tee Harun tee apogau \"Sampearo incia sii, kukodosamo. KAWASANA OPU mobanarana, sainamo iaku tee raʼeatiku padhamo kupewau sala. ");
INSERT INTO wlo_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Ingkami indamo tataraia uka guntu inda momentela sii tee waona esi. Doʼamo i KAWASANA OPU. Iaku bhekutaroaka ingkomiu ulingka. Ingkomiu bholimo umboore iwe sii uka.\" ");
INSERT INTO wlo_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Pogauna Musa i Firaun, \"Sakawaku i sambalina kota, iaku bhekuangka limaku to kudoʼa i KAWASANA OPU. Guntu tee waona esi bheaunto, mamudhaakana ingkoo umataua ande alamu sii pewauana KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Maka kumataua ande ingkoo tee manga pagawemu indapo utotuu-totuu umaeka i KAWASANA OPU Aulataʼala.\" ");
INSERT INTO wlo_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","I wakutuu incia sumai, rami tee penembula mokoompole isarongiaka jelai amadhaki tee abinasa, roonamo rami tangasaana akokamba, tee jelai tangasaana amasasa. ");
INSERT INTO wlo_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Maka o gandum tee penembula mokoompole isarongiaka sekoi inda amadhaki roonamo indapo atuwu. ");
INSERT INTO wlo_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Musa alingka i sambalina kota abholi Firaun, kasiimpo incia aangka limana to adoʼa i KAWASANA OPU. Wakutuu incia sumai uka auntomo guntu tee waona esi, tee wao indamo asapo uka. ");
INSERT INTO wlo_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Mboo sumai Firaun akamata ande wao, waona esi, tee guntu auntomo, incia akodosamo uka tee apekakaa incana, tee mboo sumai uka manga pagawena. ");
INSERT INTO wlo_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Mboomo mopadhana ifirimaniakana KAWASANA OPU alaloi Musa, Firaun sadhaadhaa amakaa incana tee inda ataroakea miana Israel alingka. ");
INSERT INTO wlo_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","KAWASANA OPU afirimani i Musa, \"Lingkamo upoaro i Firaun roonamo Iaku padhamo kupekakaaia incana tee incana manga pagawena, mamudhaakana amembali kupadhaangia manga tanda inda momentela i tanga-tangana manga incia, ");
INSERT INTO wlo_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","tee uka mamudhaakana ingkoo umembali upetulatulaakea i manga anamu tee opuamu tuaapa Iaku kumagamagasiaaka miana Mesir tee manga tanda inda momentela ipadhaangiaku i tanga-tangana manga incia. Sumaimo ingkomiu bheumataua ande Iakumo KAWASANA OPU!\" ");
INSERT INTO wlo_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Kasiimpo Musa tee Harun alingka apoaro tee Firaun tee apogau, \"Mboo sii firimanina KAWASANA OPU, Aulataʼalana miana Ibrani, 'Sakawana naepia ingkoo umendeu utungku i aroaku? Taroakamo uumatiku alingka, mamudhaakana manga incia amembali asambahea i Iaku. ");
INSERT INTO wlo_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Sababuna ande ingkoo dhaangiapo uka umendeu, naile bhekuumbaaka manga kabhoro i lipumu. ");
INSERT INTO wlo_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Manga kabhoro mobhari sumai bheatutubhi saangua Tana Mesir, sabutuna ingkomiu inda umembali uka ukamata tana. Manga kabhoro sumai bheakandea bhari-bharia bhilaa modhaangiana minaaka i waona esi sumai, tee uka manga puuna kaumiu. ");
INSERT INTO wlo_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Manga kabhoro bheapabuke maligemu, manga bhanuana pagawemu tee bhanuana bhari-bharia miana Mesir. Balaa sii bhealabhi o kaogena minaaka mopadhana inamisina manga opu-opuamu, apepuu minaaka laahiriana manga incia sakawana sii-sii.' \" Kasiimpo Musa abhalili tee alingka. ");
INSERT INTO wlo_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Kasiimpo manga pagawena Firaun apogau tee incia, \"Sakawana naepia mia sumai bheapanarakaa ingkita? Taroakamo bhari-bharia miana Israel sumai alingka to asambahea i KAWASANA OPU, Aulataʼalana manga. Sadaramo, liputa sii ahancurumo!\" ");
INSERT INTO wlo_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Sabutuna Musa tee Harun atokemba pendua apoaro tee Firaun. Pogauna Firaun i manga incia, \"Lingkamo to usambahea i KAWASANA OPU Aulataʼalamiu. Maka incema-incema uka i tanga-tangamiu bhemolingkana?\" ");
INSERT INTO wlo_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Lawanina Musa, \"Bhari-bharikami bhetalingka, malape manga mia mangura atawa mancuana, tee ingkami bhetabhawa manga anamami, malape umane atawa bhawine, tee bhembe dumba tee sapimami, roonamo ingkami tabeana tapadhaangia kariaa ogena to KAWASANA OPU.\" ");
INSERT INTO wlo_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Maka Firaun apogau i manga incia, \"Iaku inda bhekuundaakakomiu ubhawa manga bhawine tee manga anamiu! Iemanimiu sumai apokanamo tee uharapuaka iaku kuemani i KAWASANA OPU abarakatikomiu. Atindamo to karoku ande ingkomiu uhaejati madhaki! ");
INSERT INTO wlo_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Inda! Tangkanamo manga umane momembalina molingkana mosambahea i KAWASANA OPU, roonamo siitumo iemanimiu!\" Tee manga pogau incia sumai o Musa tee Harun atopadhencu minaaka i aroana Firaun. ");
INSERT INTO wlo_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Kasiimpo KAWASANA OPU afirimani i Musa, \"Aangkea o limamu i bhawona Tana Mesir to aumbaaka manga kabhoro. Manga kabhoro sumai bheakande bhari-bharia penembula bhilaana sapadhana waona esi.\" ");
INSERT INTO wlo_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Musa aangka katukona i bhawona Tana Mesir tee KAWASANA OPU aumbaaka ngalu timbu alaloi i bhawona lipu sumai saeoa tee samaloa. Samainawana, ngalu sumai abhawamo manga kabhoro. ");
INSERT INTO wlo_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Aumbamo kabhoro mobharina mpuu, sabutuna asampa i saangua lipu. Indapo dhaangia kabhoro mobharina mboo sumai, tee sapadhana incia sumai inda bheadhaangia apendua uka. ");
INSERT INTO wlo_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Saangua bhawona tana atutubhia kabhoro sampe amaeta kamataana. Manga incia akande opea uka bhilaana modhaangiana minaaka i waona esi sumai, atolentu tee manga bhakena kau i puuna. I saangua tana Mesir inda dhaangia saangu uka momaijona mokobhilaana i manga puuna kau atawa i penembula. ");
INSERT INTO wlo_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Sumaimo, alausakamo Firaun akemba Musa tee Harun kasiimpo apogau, \"Iaku kukodosamo i KAWASANA OPU, Aulataʼalamiu, tee i ingkomiu. ");
INSERT INTO wlo_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Sii-sii, amponia dosaku to sampearona sii, tee udoʼamo i KAWASANA OPU, Aulataʼalamiu, mamudhaakana incia apekaridhoa minaaka i iaku balaa imateaka sii.\" ");
INSERT INTO wlo_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Kasiimpo Musa abholi Firaun tee adoʼa i KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Sumaimo KAWASANA OPU abhalili ropena ngalu amembali ngaluna bhara momakaana mpuu. Ngalu sumai atowii manga kabhoro tee abhawea atudhaakea i Tawo Towu Lambe. Inda sambaa uka atobholi i saangua tana Mesir. ");
INSERT INTO wlo_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Maka KAWASANA OPU apekakaaia incana Firaun, sabutuna incia inda ataroakea miana Israel alingka. ");
INSERT INTO wlo_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","KAWASANA OPU afirimani i Musa, \"Angkamea o limamu i bhawo, mamudhaakana Mesir atipua kalalanda, sabutuna mia amembali anamisia totuu-totuu kalalanda sumai.\" ");
INSERT INTO wlo_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Musa aangka limana i bhawo, tee kangenge talu eo saangua Tana Mesir atipua kalalanda apoposa. ");
INSERT INTO wlo_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Miana Mesir inda amembali akamata mia mosagaanana, tee kangengena wakutuu incia sumai inda dhaangia samia uka momembalina alimba minaaka i mbooresana. Maka i bhari-bharia bhanuana manga miana Israel sadhaadhaa amainawa. ");
INSERT INTO wlo_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Kasiimpo Firaun akemba Musa tee apogau, \"Lingkamo, sambahea i KAWASANA OPU! Manga mia bhawine tee manga anamiu amembali aose. Maka o gulumana sapi, dumba, tee bhembemiu inda amembali ubhawea.\" ");
INSERT INTO wlo_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Maka Musa alawani, \"Inda amembali mboo sumai! Ingkoo tabeana mangataroaka tabhawa kadhambaakamami to tapasombaaka to kurubani tunua i KAWASANA OPU, Aulataʼalamami. ");
INSERT INTO wlo_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Bhari-bharia kadhambaakamami tabeana tapasombaaka to kurubani tunua i KAWASANA OPU, Aulataʼalamami. Sii-sii ingkami indapo tamataua binata iapai faraluu tapasombaaka i Incia. Dhaampomo takawa i tampana sumai, kasiimpomo uka ingkami bhetamataua kadhambaaka iapai bheipasombaakamami.\" ");
INSERT INTO wlo_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","KAWASANA OPU apekakaaia incana Firaun, sabutuna incia inda aundaakea miana Israel alingka. ");
INSERT INTO wlo_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Pogauna Firaun i Musa, \"Dhencumo minaaka i aroaku! Jaga, bholi ukamata rouku pendua! Sababuna i wakutuu ukamata rouku uka, ingkoo bheumate!\" ");
INSERT INTO wlo_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Alawani Musa, \"Atotuu mboo ipogauakamu itu! Dhaanamo indamo bhekukamata roumu pendua.\" ");
INSERT INTO wlo_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","KAWASANA OPU afirimani i Musa, \"Iaku bhekuumbaaka saangu balaa uka to Firaun tee Tana Mesir. Sapadhana sumai, incia bheataroakakomiu ulingka minaaka iwe sii. Tee wakutuu incia aundaakakomiu ulingka, incia bheampuu-mpuu apadhencukomiu minaaka iwe sii. ");
INSERT INTO wlo_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Sababuna sumai pogaumo tee miana Israel, tumpumea bhari-bharia umane aemani agogo bulawa tee perana minaaka i sarimbanuana manga, tee mboo sumai uka bhari-bharia bhawine.\" ");
INSERT INTO wlo_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Kasiimpo KAWASANA OPU apewau miana Mesir apekarunaia incana mamudhaakana amaasiaka miana Israel. Tee uka Musa amembali mia motohoromatina mpuu malape i manga pagawena Firaun tee uka i raʼeatina Mesir. ");
INSERT INTO wlo_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Apogaumo Musa i Firaun, \"KAWASANA OPU afirimani mboo sii, 'Kera-kera i wakutuu pontanga malo Iaku bhekumbelikia saangua Tana Mesir. ");
INSERT INTO wlo_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Sumaimo bhari-bharia ana umane tumpe i Mesir bheamate, pepuu minaaka i anana Firaun mouncurana i kauncuramakana sakawana i anana bhatua bhawine mogilina gandum. Bhari-bharia kadhambaaka mobhaa-bhaana molaahiri uka bheamate. ");
INSERT INTO wlo_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","I saangua Mesir bheatorango suarana tangi momakaana mpuu, mboomo indapo mina momembalina tee inda bheamembali pendua. ");
INSERT INTO wlo_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Maka sambaa mantoa inda bheabarani amburuti incema uka i tanga-tangana miana Israel, malape i maanusia atawa i binata, mamudhaakana ingkomiu bheumataua ande Iaku, KAWASANA OPU, kupaposalea i tanga-tangana miana Mesir tee miana Israel.' \" ");
INSERT INTO wlo_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Sabutuna Musa apogau, \"Bhari-bharia pagawemu bheaumba tee asuju i aroaku tee aemani, 'Limbamo, ingkoo tee bhari-bharia raʼeatimu moosemu.' Sapadhana incia sumai, iaku bhekulimbamo.\" Kasiimpo tee aʼamara mpuu Musa abholi Firaun. ");
INSERT INTO wlo_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","KAWASANA OPU afirimani i Musa, \"Firaun inda bheaperangoiko, mamudhaakana Iaku ahandamo ajulu manga muuzizati ipewauku i saangua Tana Mesir.\" ");
INSERT INTO wlo_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Musa tee Harun apewaumo bhari-bharia muuzizati sumai i aroana Firaun. Maka KAWASANA OPU apekakaaia incana Firaun, sabutuna incia inda aundaakea miana Israel abholi lipuna. ");
INSERT INTO wlo_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","KAWASANA OPU afirimani i Musa tee Harun i Tana Mesir mboo sii, ");
INSERT INTO wlo_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","\"Bula incia siimo bhemomembalina bula bhaa-bhaana to ingkomiu; siitu bheamembali bula bhaa-bhaana to ingkomiu satao-satao. ");
INSERT INTO wlo_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Pakawaakea parinta incia sii i bhari-bharia uumatina Israel, i tanggala sapulu bula incia sii, bhari-bharia mia kapala rumatangga tabeana aala sambaa anana dumba to asumbelea. ");
INSERT INTO wlo_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Ande manga mia i bhanuana sumai saidhemea to apepadhai sambaa anana dumba, manga incia tabeana apodhawua tee sarimbanuana. Anana dumba sumai tabeana atopili mboomo kabharina mia mokandea tee saopea kabharina dagina. ");
INSERT INTO wlo_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Anana dumba tabeana umane, mokoʼumuruna satao, tee inda dhaangia balacina; umembali upili dumba atawa bhembe. ");
INSERT INTO wlo_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Ingkomiu tabeana udhikaia sakawana tanggala sapulu pata eo bula incia sii. I eo incia sumai, wakutuu magaribimo, bhari-bharia miana Israel tabeana asumbele anana dumbana manga sumai. ");
INSERT INTO wlo_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Saidhe o raana tabeana ajampuakea i rua angua ariina bhamba tee i bhawona bhambana bhanua tampana manga akandea. ");
INSERT INTO wlo_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Malo incia sumai uka o dagina tabeana atotunu tee akandea tee tawana kau mapaʼi tee roti inda mokoragi. ");
INSERT INTO wlo_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Anana dumba sumai tabeana atotunu bhari-bharia. Amondo tee bhaana, aena, tee antona kompona. Bholi dhaangia motokandena mamata atawa aparendea. ");
INSERT INTO wlo_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Bholi ubholia saidhe uka minaaka i dagi sumai sakawana saeona, ande dhaangia tee bhilaana, tabeana atotunu sampe amapupu. ");
INSERT INTO wlo_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","I wakutuuna ukandea ingkomiu tabeana padhamo upobhaju asangka to lingkaamiu tee umakanu to ubhose; uposandali i aemiu tee ukeni katuko i limamiu. Kandemo pekadhei. Siitumo Raraeana Paska to uhoromatiaku, KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","I malo incia sumai Iaku bhekumbelikia saangua Tana Mesir, tee kupekamatea bhari-bharia anana tumpe, malape anana maanusia atawa anana binata. Iaku bhekuhukumu bhari-bharia dewa i Mesir, roonamo Iakumo KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Raa modhaangiana i ariina bhambana bhanuamiu bheamembali tanda to ingkomiu i manga bhanua mbooresamiu. Ande Iaku kukamata raa sumai, bhekulaloikomiu tee inda kupabinasakomiu i wakutuuna kuhukumu Tana Mesir. ");
INSERT INTO wlo_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Eo incia sumai tabeana ingkomiu uudhania eona raraea to uhoromati KAWASANA OPU. Roonamo eo incia sumai amembali katotapu, sumaimo tabeana ingkomiu uraraeaakea satao-satao to saʼumurua.\" ");
INSERT INTO wlo_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","KAWASANA OPU afirimani, \"Pitu eo kangengena ingkomiu ukandemo roti inda mokoragi. I eo bhaa-bhaana, bhari-bharia ragi tabeana atopalimba minaaka i bhanuamiu, sababuna ande kangenge pitu eo sumai dhaangia samia mokandena roti mokoragi, mia incia sumai tabeana atopalimba minaaka i uumatiku Israel. ");
INSERT INTO wlo_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","I eo bhaa-bhaana, tee uka i eo pitu eona, ingkomiu tabeana uporomusaka to usambahea i Iaku. I rua eona sumai ingkomiu apepali to ukarajaa opea-opeapo uka tabeana mofaraluuna to upasiapuaka kinandena bhari-bharia miana antona bhanuamiu. ");
INSERT INTO wlo_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","I eo incia sumai saangua lipumiu kubhawea sarombonga-sarombonga alimba minaaka i Mesir. Roonamo eo incia sumai amembali katotapu, sumaimo tabeana ingkomiu uraraeaakea satao-satao to saʼumurua. ");
INSERT INTO wlo_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","I nuncana bula bhaa-bhaana, i eo sapulu pata eona i bula incia sumai i wakutuuna asoomo eo, ingkomiu ukandemo roti inda mokoragi, sakawana i eo rua pulu saeo i bula incia sumai, i wakutuuna asoomo eo. ");
INSERT INTO wlo_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Pitu eo kangengena inda amembali tee ragi i nuncana bhanuamiu, roonamo incema-incemapo mokandena sagala giu mokoragi, mia sumai tabeana atopalimba minaaka i tanga-tangana uumatiku Israel, malape incia o mia dhaga, atawa incia miana Israel asilii. ");
INSERT INTO wlo_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Opea-opeapo uka mokoragina inda amembali ingkomiu ukandea; ingkomiu ukandemo roti inda mokoragina i bhari-bharia tampa mbooresamiu.\" ");
INSERT INTO wlo_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Musa akemba bhari-bharia manga mancuanana miana Israel tee apogau i manga incia, \"Sumbesumbere kapalana rumatangga tabeana alingka aala tee asumbele sambaa anana dumba to Raraea Paska. ");
INSERT INTO wlo_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Alamo sakabhoke penembula hisop, palondoa i nuncana palangga mokoantoakana raana dumba sumai, kasiimpo jampuakea i rua angua ariina bhambamiu tee i bhawona bhambana bhanuamiu. Sakawana raneeo, bholi samia uka i tanga-tangamiu mobholina bhanua. ");
INSERT INTO wlo_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","I malo sumai, KAWASANA OPU bheambeliki Tana Mesir tee ahisabu miana Mesir. KAWASANA OPU bheakamata raa i rua angua arii tee i bhawona bhambana bhanuamiu, sabutuna Incia soo alalo uka tee inda aundaakea malaaʼekati mohobutina inyawa apesuaiki bhanuamiu to ahisabukomiu.\" ");
INSERT INTO wlo_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","\"Pewaua o giu incia sii sadia tee upamembalia saangu katotapu to karomu tee manga anamu saʼumurua. ");
INSERT INTO wlo_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Ande upadhamo upesuaiki lipu ijanjiakana KAWASANA OPU to ingkomiu, ingkomiu tabeana sadia uudhania ibaadati incia sii. ");
INSERT INTO wlo_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Ande manga anamiu aabha, 'Opea maʼanana sara ibaadati incia sii Ama?' ");
INSERT INTO wlo_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","sumaimo tabeana ulawani, 'Sii kurubani Paska to tahoromatiaka KAWASANA OPU, sababuna bhanuana manga miana Israel i Mesir soo alaloi wakutuuna Incia apekamate manga ana umane tumpe i Mesir, maka ingkami manga taroaka tadhadhi!' \" Sabutuna aʼungkomo manga miana Israel tee asuju asomba. ");
INSERT INTO wlo_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Kasiimpomo manga incia alingka tee apewau opea iparintaakana KAWASANA OPU i Musa tee Harun; mboo sumai manga apewau. ");
INSERT INTO wlo_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","I pontanga malo sumai KAWASANA OPU apekamate bhari-bharia ana umane tumpe miana Mesir, pepuu minaaka i ana tumpena Firaun mouncurana i kauncuramakana sakawana i ana tumpena manga mia mototaangina i katorongku i tambena tana. Bhari-bharia kadhambaaka mobhaa-bhaana molaahiri uka atopekamate. ");
INSERT INTO wlo_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","I malo incia sumai uka, Firaun, manga pagawena, tee bhari-bharia raʼeatina Mesir abhangu. Kasiimpo saangua lipu Mesir atorango suarana tangi momakaana mpuu roonamo inda saangu bhanua uka inda tee momatena. ");
INSERT INTO wlo_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Kasiimpomo i malo incia sumai uka, Firaun akemba Musa tee Harun tee apogau, \"Bhangumo, lingkamo minaaka iwe sii, ingkomiu tee uumatina Israel! Bholimea o lipuku! Sambaheamo i KAWASANA OPU mboomo opea ipogauakamiu. ");
INSERT INTO wlo_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Bhawamea bhari-bharia gulumana sapi, dumba, tee bhembemiu, mboomo opea ipogauakamiu tee lingkamo! Emaniakaaku uka barakati!\" ");
INSERT INTO wlo_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Miana Mesir apajungkuri miana Israel mamudhaakana apekadhei abholi lipu sumai. Pogauna manga incia, \"Bhari-bharikami bhetamate ande ingkomiu inda ulingka!\" ");
INSERT INTO wlo_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Kasiimpomo manga miana Israel aala manga tampana dhingkana to kusoana kajalona roti, wakutuuna indapo atojalo tee ragi, atangea tee kae, tee asodhaia. ");
INSERT INTO wlo_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Manga incia uka padhamo apewau opea ipogauakana Musa, siitumo aemani agogona pera tee bulawa tee pakea minaaka i miana Mesir. ");
INSERT INTO wlo_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","KAWASANA OPU apekaruna incana manga miana Mesir mamudhaakana manga amaasiaka miana Israel, sabutuna manga incia adhawuakea bhari-bharia iemanina miana Israel. Tee cara incia sumai miana Israel arampasi harataana miana Mesir. ");
INSERT INTO wlo_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Miana Israel alingka tee adhala ae minaaka i kota Raamses arope i kota Sukot. Kabharina manga incia kera-kera 600.000 mia umane, inda atolentu tee bhawine tee anaana. ");
INSERT INTO wlo_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Manga incia abhawa bhari gulumana sapi, dumba tee bhembe. Abhari uka mia dhaga minaaka i manga lipu mosagaanana alingka apobhawa tee manga incia. ");
INSERT INTO wlo_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Manga incia atunu roti inda mokoragi minaaka i kajalo ibhawana manga minaaka i Mesir. Manga incia indamo atolala ajaloakea ragi i kajalona rotina manga roonamo manga incia atopadhencu minaaka iwe sumai amadhei mpuu. Sababuna sumai, indamo dhaangia wakutuuna uka to apasiapuaka bhakuna. ");
INSERT INTO wlo_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Miana Israel padhamo amboore i Mesir 430 tao kangengena. ");
INSERT INTO wlo_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","I eo kapadhaana tao i 430 sumai, bhari-bharia rombonga uumatina KAWASANA OPU abholi Tana Mesir. ");
INSERT INTO wlo_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Malo incia sumai KAWASANA OPU torosu ajaga to abhawa manga incia alimba minaaka i Mesir. Sababuna sumai, bhari-bharia siwuluna miana Israel uka tabeana ahoromati KAWASANA OPU tee sadhaadhaa akojaga-jaga i malo mopokana, satao-satao saʼumurua. ");
INSERT INTO wlo_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","KAWASANA OPU afirimani i Musa tee Harun, \"Siimo manga parintana to Raraea Paska. Mia dhaga inda amembali akande dagina dumba ipasombaaka i eona Paska. ");
INSERT INTO wlo_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Maka o bhatua ialimiu amembali aose akande, ande incia padhamo atotandaki, ");
INSERT INTO wlo_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","sainamo mia moumbana atawa o mia iponambo inda amembali aose akande. ");
INSERT INTO wlo_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Bhari-bharia dagina dumba sumai tabeana atokande i nuncana saangu bhanua, tee inda amembali atobhawa i sambali. Bholi ukatuki saangu uka minaaka i manga bukuna. ");
INSERT INTO wlo_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Bhari-bharia uumatina Israel tabeana araraeaakea Raraea Paska sumai. ");
INSERT INTO wlo_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Inda amembali samia umane indapo atotandaki akande kinandena kariaa sumai. Ande o mia dhaga momboorena i tanga-tangamiu gauna bheararaeaaka Paska to ahoromatiaku, KAWASANA OPU, bhari-bharia umane tee ana umane i nuncana bhanuana tabeana atotandaki porikana. Sapadhana sumai, manga incia atoabhi mboomo miana lipuna Israel asilii, tee manga incia amembali aose araraeaaka Paska. ");
INSERT INTO wlo_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Katotapu mopokana atopake to miana Israel asilii tee mia dhaga momboorena i tanga-tangamiu.\" ");
INSERT INTO wlo_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Bhari-bharia miana Israel ataʼati tee apewaua bhari-bharia iparintaakana KAWASANA OPU i Musa tee Harun. ");
INSERT INTO wlo_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","I eo incia sumai KAWASANA OPU abhawa bhari-bharia miana Israel alimba minaaka i Mesir, mboomo manga rombongana. ");
INSERT INTO wlo_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","KAWASANA OPU afirimani i Musa mboo sii, ");
INSERT INTO wlo_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","\"Hususuakaaku bhari-bharia ana umane tumpemiu. Bhari-bharia ana umane tumpe i Israel, tee bhari-bharia kadhambaaka umane molaahirina bhaa-bhaana, o siimo pewauaku.\" ");
INSERT INTO wlo_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Kasiimpo, Musa apogau i miana Israel, \"I eo incia sii KAWASANA OPU apabebasikomiu tee limana momakaana, sabutuna ingkomiu umembali ulimba minaaka i Mesir, tampamiu utopabhatua. Sababuna sumai, udhanimea eo incia sii. Bholimo ukande roti inda mokoragi. ");
INSERT INTO wlo_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Eo sii ingkomiu ulimba, i bula Abib. ");
INSERT INTO wlo_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Tee sumpana KAWASANA OPU ajanjiakea i manga opua lantapi-lantapimu to apasarakaaka i ingkoo lipuna miana Kanaan, Het, Amori, Hewi tee Yebus. Sapadhana KAWASANA OPU abhawako i lipu mosuburu sumai motaralabhi-labhina susu tee golana uwani, satao-satao i nuncana bula Abib, ingkoo tabeana upadhaangia ibaadati incia sii. ");
INSERT INTO wlo_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Kangenge pitu eo tabeana ingkoo ukande roti inda mokoragi, tee i eo pitu eona tabeana upadhaangia raraea to uhoromati KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Kangengena pitu eo inda amembali ukande roti mokoragi; i saangua lipumu inda membali dhaangia tee ragi atawa sagala giu uka mokoragina. ");
INSERT INTO wlo_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","I wakutuu incia sumai, ingkoo tabeana upetulatulaakea i anamu umane ande bhari-bharia sumai upewaua roonamo sagala mopadhana ipewauna KAWASANA OPU to ingkoo i wakutuuna ubholi lipuna Mesir. ");
INSERT INTO wlo_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Raraea sii amembali kaudhania to ingkoo, mboomo tanda ibhoke i limamu atawa i bhawona roumu. Tee mboo sumai, raraea bheaudhaniakako to utorotorosu ubhoasaka tee upengkaadhariaka manga hukumuna KAWASANA OPU, sababuna KAWASANA OPU apalimbako minaaka i Mesir tee limana momakaana. ");
INSERT INTO wlo_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Raraeakamea kariaa sii satao-satao i wakutuu mopadhana itotapuaka.\" ");
INSERT INTO wlo_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Musa apogau i miana Israel, \"KAWASANA OPU bheabhawako i lipu Kanaan ijanjiakana tee sumpa i ingkoo tee manga opua lantapi-lantapimu. Sapadhana tana sumai amembali pewauamu, ");
INSERT INTO wlo_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","sumaimo ingkoo tabeana udhawuaka i KAWASANA OPU bhari-bharia ana umane tumpe tee bhari-bharia kadhambaaka umane mobhaa-bhaana molaahirina. Bhari-bharia sumai pewauana KAWASANA OPU, ");
INSERT INTO wlo_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","maka bhari-bharia anana keledai umane mobhaa-bhaana molaahiri tabeana utolosia minaaka i KAWASANA OPU tee ukurubaniakea sambaa anana dumba to kabholosina. Ande ingkoo umendeu utolosi keledai sumai, bhorokona tabeana ukatukia. Bhari-bharia anamu umane tumpe tabeana utolosia. ");
INSERT INTO wlo_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Ande naile itu anamu aabha opea maʼanana bhari-bharia sumai, ingkoo tabeana ulawani mboo sii, 'Tee kuasa momaogena KAWASANA OPU mangabhawa talimba minaaka i lipu Mesir, tampata tatopabhatua. ");
INSERT INTO wlo_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Wakutuuna Firaun amakaa incana tee inda mangaundaaka talingka, KAWASANA OPU apekamate bhari-bharia ana umane tumpe i Mesir, malape anana maanusia atawa anana binata. Siitumo sababuna ingkita takurubaniakea i KAWASANA OPU bhari-bharia kadhambaaka umane molaahiri bhaa-bhaana, maka ingkita tatolosi manga anata umane tumpe.' ");
INSERT INTO wlo_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Kananea incia sumai amembali kaudhania to ingkoo mboomo tanda ibhoke i limamu atawa i bhawona roumu. Tee mboo sumai ingkoo sadhaadhaa uudhania ande KAWASANA OPU padhamo mangapalimba minaaka i Mesir tee limana momakaana.\" ");
INSERT INTO wlo_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Sapadhana Firaun ataroaka miana Israel alingka, Aulataʼala inda atonda manga incia alalo i dhala moporopena i lipuna miana Filistin, moomini dhala sumai amakasu roonamo Aulataʼala afirimani, \"Tapalaka manga mia sumai asoso ande ahumbunia manga musuna sabutuna manga ambuli pendua i Mesir.\" ");
INSERT INTO wlo_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Jadi Aulataʼala abhawamo manga incia adhala patii alaloi tana matuu i dhala moporopena i Tawo Towu Lambe I wakutuuna abholi Mesir, manga miana Israel sumai akoewanga mboomo mia momakanuna to apotimbe. ");
INSERT INTO wlo_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Musa abhawa manga bukuna Yusuf, sababuna Yusuf padhamo atumpu miana Israel asumpa to apewau mboo sumai. Mboo sii kasameana Yusuf, \"I wakutuuna Aulataʼala amaheruakakomiu, manga bukuku tabeana ubhawea minaaka i tampa incia sii.\" ");
INSERT INTO wlo_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Miana Israel abholi Sukot tee apokema i Etam, i saripina tana matuu. ");
INSERT INTO wlo_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","KAWASANA OPU alingka i aroana manga incia. I wakutuuna eo Incia adhala i aroana manga incia i nuncana ariina taʼina ngalu tee wakutuuna malo Incia aporiaroaaka manga incia i nuncana ariina waa to asuluwi manga incia i dhala. Tee mboo sumai manga incia amembali alingka eo tee malo. ");
INSERT INTO wlo_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Saeoa ariina taʼina ngalu inda adhencu minaaka i aroana lipu sumai, tee samaloa ariina waa sadhaadhaa aporiaroaaka manga incia. ");
INSERT INTO wlo_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Kasiimpo KAWASANA OPU apogau i Musa, ");
INSERT INTO wlo_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","\"Tumpumea miana Israel abhalili i talikuna tee apokema i aroana Pi-Hahirot, i tanga-tangana Migdol tee Tawo Towu Lambe, amakasu tee Baal-Zefon. ");
INSERT INTO wlo_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Sumaimo Firaun bheaabhia, 'Tantumo manga miana Israel tangasaana alipa mai ambeliki lipu sii, sababuna tana matuu ajoli manga incia.' ");
INSERT INTO wlo_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Iaku bhekupekakaa incana Firaun, sabutuna incia apajerekomiu. Maka Iaku bhekususuakakomiu kamuliangiku i Firaun tee bhari-bharia suludaduna, mamudhaakana manga incia bheamataua ande Iakumo KAWASANA OPU.\" Kasiimpo miana Israel apewau mboomo iparintaakana KAWASANA OPU i manga incia. ");
INSERT INTO wlo_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Wakutuuna rajana Mesir arango ande miana Israel apalaimo, sumaimo incia tee manga pagawena abhaliimo fikirina tee apogau, \"Opea ipewauta? Pokia tataroaka manga miana Israel sumai alingka sabutuna ingkita takailanga manga bhatuata?\" ");
INSERT INTO wlo_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Kasiimpo raja atumpu mia to apasiapu kareta potimbea tee suludaduna. ");
INSERT INTO wlo_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Incia alingka tee bhari-bharia kareta potimbea, atolentu tee 600 kareta momalapena motopilina. Saangu-saangu kareta sumai amondo tee samia kapala suludaduna. ");
INSERT INTO wlo_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Tee mboo sumai KAWASANA OPU apekakaa incana Firaun, rajana Mesir sumai, sabutuna incia apajere miana Israel. Maka o miana Israel alingka torosu i lipu sumai i tambena kajaganina KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Bhari-bharia tantarana Mesir, siitumo suludadu mosawina i ajara, kareta potimbea, tee suludaduna modhala aena apajere miana Israel. Tantarana Mesir sumai atutuni tee apotibhaaka miana Israel i tampana pokemaana manga i bhiwina tawo i saripina Pi-Hahirot, i aroana Baal-Zefon. ");
INSERT INTO wlo_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Wakutuuna miana Israel akamata Firaun tee suludaduna amakasumo, manga incia amaeka mpuu tee agora i KAWASANA OPU aemani tulungi. ");
INSERT INTO wlo_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Manga incia apeenci i Musa, \"Buaka i Mesir inda tee koburu, sabutuna ingkoo ubhawa ingkami mamudhaakana tamate i tampa incia sii? Kamatamea rempeina pewaumu sumai! ");
INSERT INTO wlo_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","I piamo itu i Mesir ingkami padhamo tapogauakea ande o giu incia sii bheamembali! Ingkami padhamo tapajungkuko mamudhaakana ingkoo bholi uʼurusu ingkami, maka utaroaka ingkami sadhaadhaa mangapabhatua miana Mesir. Salabhina tamembali bhatua iwe sumako tee tamate i tana matuu sii!\" ");
INSERT INTO wlo_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Musa alawani miana Israel sumai, \"Bholi umaeka! Potaangimo! Ingkomiu bheukamata opea bheipewauna KAWASANA OPU to apasalaamatikomiu i eo sii. Miana Mesir ikamatamiu sii-sii, indamo bheukamatea uka. ");
INSERT INTO wlo_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","KAWASANA OPU bheaewaakakomiu, tee ingkomiu inda afaraluu upewau opeopea uka.\" ");
INSERT INTO wlo_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Pogauna KAWASANA OPU i Musa, \"Pokia ingkoo upekei torosu uemani tulungi? Tumpumea miana Israel mamudhaakana manga incia amakanu abhose. ");
INSERT INTO wlo_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Tee ingkoo, angkamea katukomu, paulu limamu i bhawona tawo, tee wetaia uwena, mamudhaakana miana Israel amembali adhala i tanga-tangana tawo, i tampa momatuu. ");
INSERT INTO wlo_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Maka satotuuna Iaku bhekupekakaa incana miana Mesir, sabutuna manga incia bheaose torosu miana Israel. Iaku bhekususuaka kamuliangiku wakutuuna kumangantaloaka Firaun, tee bhari-bharia tantarana, manga karetana tee mosawikina ajara. ");
INSERT INTO wlo_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Sumaimo miana Mesir bheamataua ande Iakumo KAWASANA OPU, wakutuuna kumangantaloaka Firaun tee manga karetana tee mosawikina ajara mamudhaakana manga mia bheahoromatiaku.\" ");
INSERT INTO wlo_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Kasiimpomo Malaaʼekatina Aulataʼala, modhalana i aroana tantarana Israel, apinda i talikuna. Ariina taʼina ngalu sumai uka akomingkumo minaaka i aroana, aporope i talikuna manga incia, ");
INSERT INTO wlo_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","i tanga-tangana tantarana Mesir tee tantarana Israel. Taʼina ngalu sumai apatiumbamo kalalanda, i saangu tapa tee kainawa i tapa mosagaanana i wakutuu malo, sabutuna tantara saanguna inda amembali apasari i tantara mosagaanana samaloa sumai. ");
INSERT INTO wlo_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Kasiimpo Musa apaulumo limana i bhawona tawo, tee KAWASANA OPU apewau ngaluna timbu momakaana mpuu sabutuna uwena tawo asowo. Samaloa ngalu sumai amakaa mpuu, tee abhaliia o tawo apamembalia tana matuu. ");
INSERT INTO wlo_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Kasiimpo apesuamo miana Israel i tanga-tangana tawo tee adhala i tana momatuu, sainamo o uwena tawo sumai amembali mboomo rindi to manga incia i kaana tee i kaai. ");
INSERT INTO wlo_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Miana Mesir apajere tee aose manga incia i tanga-tangana tawo, bhari-bharia ajarana Firaun, karetana, tee manga mosawikina ajarana. ");
INSERT INTO wlo_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","I wakutuuna ajaga saeona, KAWASANA OPU atonto tantarana miana Mesir minaaka i nuncana ariina waa tee taʼina ngalu, kasiimpo apakacau tantarana miana Mesir. ");
INSERT INTO wlo_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Incia apabhele manga rodana karetana manga sabutuna amatamomo to apajalea. Sakamatana hali incia sumai, miana Mesir apogau samia i mosagaanana, \"Maimo tapalaiaka minaaka i miana Israel, roonamo KAWASANA OPU uka mopoewangina to manga incia abhali miana Mesir.\" ");
INSERT INTO wlo_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","KAWASANA OPU afirimanimo i Musa, \"Paulumea limamu i bhawona tawo, mamudhaakana o uwe ambuli apatondu miana Mesir, karetana, tee manga mosawikina ajarana.\" ");
INSERT INTO wlo_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Musa apaulumo limana i bhawona tawo, kasiimpo amakasumo saeona abhalilimo uwena tawo asiwulu mboomo mobhaa-bhaana. Manga miana Mesir apalai to apasalaamati karona minaaka i uwe sumai, maka KAWASANA OPU apatondua i tanga-tangana tawo. ");
INSERT INTO wlo_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Uwe sumai ambuli i talikuna kasiimpo atutubhi karetana tee mosawikina ajara, siitumo bhari-bharia tantarana Firaun mopajerena miana Israel apesua i tawo. Sabutuna manga incia amate bhari-bharia. ");
INSERT INTO wlo_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Maka, miana Israel adhala i tana momatuu i tanga-tangana tawo, sainamo o uwe sumai amembali mboomo rindi to manga incia i kaana tee i kaaina. ");
INSERT INTO wlo_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Mboo sumaimo KAWASANA OPU apasalaamati miana Israel i eo incia sumai minaaka i limana miana Mesir, tee miana Israel akamata miana Mesir amate atosore i bhiwina tawo. ");
INSERT INTO wlo_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Wakutuuna miana Israel akamata kaogena kuasa isusuakana KAWASANA OPU to miana Mesir, sumaimo amaekamo uumati sumai i KAWASANA OPU. Kasiimpo manga incia uka aparacaeamo i KAWASANA OPU tee i Musa, bhatuana sumai. ");
INSERT INTO wlo_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","I wakutuu incia sumai Musa tee miana Israel alaguaka lagu incia sii to KAWASANA OPU, mboo sii laguna, \"Iaku gauku bhekulagu to KAWASANA OPU, roonamo Incia amalanga atomuliangi, ajara tee mosawikia, atudhaakea i nuncana tawo. ");
INSERT INTO wlo_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","KAWASANA OPU mopekakaaku tee mopamembaliaku kulagu-laguaka kapujia incia sii. Inciamo mopasalaamatiaku. Inciamo Aulataʼalaku, kupujimo Incia, tee Aulataʼala ipasombaakana amaku, tee kupekalangea. ");
INSERT INTO wlo_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","KAWASANA OPU, satotuuna mboomo mia pande potimbe momasega. KAWASANA OPU, sumaimo sarona. ");
INSERT INTO wlo_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Karetana Firaun tee tantarana abhanakea i nuncana Tawo Towu Lambe. Manga kapalana suludaduna momalapena motopilina apatondua i nuncana Tawo Towu Lambe. ");
INSERT INTO wlo_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Andala maoge atutubhi manga incia, manga incia atondu i uwe momandalana mboomo bhatu. ");
INSERT INTO wlo_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Lima kaanamu, e KAWASANA OPU, amulia roonamo kuasamu, lima kaanamu, e KAWASANA OPU, apahancuru musumu. ");
INSERT INTO wlo_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Tee kaogesamu momaogena Upabinasea bhari-bharia mobhanguna to aewangi Ingkoo. Ingkoo urambasaka amaramu mokarore-rorena, mokandena manga incia mboomo katumpuna laena bhae. ");
INSERT INTO wlo_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Tee poinuncana angomu, utowii uwena tawo, sabutuna o uwe sumai akabumbu-bumbu malanga, saangua siwuluakana uwe akakaro makate mboomo rindi, saanampuu andala maoge amembali mboomo bhatu esi i tangana tawo, abhatu tee inda siwulu. ");
INSERT INTO wlo_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Pogauna musu, 'Manga incia bhekupajerea, tee kurakoa. Bhekupalimba hancuku, tee bhekupabinasea. Kasiimpo bhari-bharia harataana manga bhekurampasia, bhekubage-bagea tee kuniʼimatia sampe atumpu incaku.' ");
INSERT INTO wlo_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Maka KAWASANA OPU tee sampearo poinunca lausaka tawo atutubhi manga incia. Manga incia atondumo mboomo timara i nuncana ewona tawo momaoge. ");
INSERT INTO wlo_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Manga dewa iapai mopokanana tee Ingkoo, e KAWASANA OPU Momuliana roonamo kangkilomu? Incema momembalina mopewauna manga giu inda momentela tee apewau hali motomaeka mboomo Ingkoo? ");
INSERT INTO wlo_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Upaulua lima kaanamu, sabutuna o musu atopadha adhokua alamu. ");
INSERT INTO wlo_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Tee kaasimu inda amabhotu, Ingkoo ukapalaikia o lipu mopadhana itolosimu. Tee kuasamu momaogena utondaia i mbooresamu momangkilona. ");
INSERT INTO wlo_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Manga lipu arangoa, manga incia uka arengku, kapii mopeloli asampaiki raʼeatina Tana Filistin. ");
INSERT INTO wlo_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","I wakutuu incia sumai abagoeamo manga kapalana kaomuna Edom, tee manga mia mokokuasana i Moab amembali arengku, bhari-bharia raʼeatina Tana Kanaan amaeka. ");
INSERT INTO wlo_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Manga incia amaeka tee amingkiri, e KAWASANA OPU, wakutuu akamata limamu momakaana. Wakutuuna uumatimu alalo, musu apakukua muncuna mboomo bhatu, sakawana uumatimu mopadhana itolosimu alalomo. ");
INSERT INTO wlo_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","E KAWASANA OPU, Ingkoo ubhawea tee udhikaia uumatimu i tampa ipilimu to mbooresamu. Manga incia amboore i gunumu karomu, i tampana momangkilona ipabhangumu karomu, e Kawasana Opu. ");
INSERT INTO wlo_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","E KAWASANA OPU, Ingkoomo Raja moparintana saʼumurua.\" ");
INSERT INTO wlo_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","I wakutuuna miana Israel apolimba i tawo, manga incia adhala i tanga-tangana tawo momatuu. Maka wakutuuna manga ajara, manga kareta, tee tantara mosawikina ajarana miana Mesir apesua i nuncana tawo, KAWASANA OPU apewau uwena alembo pendua sabutuna manga incia atondu. ");
INSERT INTO wlo_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Kasiimpo Miryam, samia nabii bhawine, akana Harun, aala rebana, tee bhari-bharia bhawine aose abhebhe rebana apoose amanari. ");
INSERT INTO wlo_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miryam alagu to manga incia, \"Lagumo to KAWASANA OPU, sababuna Incia amalanga amulia. Bhari-bharia ajara tee mosawikia atudhaakea i nuncana tawo.\" ");
INSERT INTO wlo_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Kasiimpo Musa abhawa miana Israel minaaka i Tawo Towu Lambe arope i Tana Matuu Syur. Kangenge talu eo manga incia alingka alaloi tana matuu inda apotibhaaka uwe. ");
INSERT INTO wlo_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Manga incia akawamo i Mara, maka inda amembali asumpu uwe i Mara, roonamo amapaʼi namina. Siitumo sababuna tampa incia sumai asarongiakea Mara. ");
INSERT INTO wlo_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Sumaimo manga mia sumai adodo i Musa tee aabha, \"Opea bheisumputa?\" ");
INSERT INTO wlo_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Musa adoʼa mpuu-mpuu i KAWASANA OPU, kasiimpo KAWASANA OPU asusuakea satumpo kau. Musa atudhaaka kau sumai i nuncana uwe, kasiimpo uwe sumai amembali amambaka namina, sabutuna amembali atosumpu. I tampa incia sumai KAWASANA OPU adhawumo sagala katotapu tee tutura i manga incia, tee iwe sumai uka KAWASANA OPU auji manga incia. ");
INSERT INTO wlo_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Firimanina KAWASANA OPU, \"Taʼatiaku mpuu-mpuu, tee upewaumea opea ikamataku amalape, osemea bhari-bharia parintaku tee keniakea sagala katotapuku. Ande ingkoo upewau mboo sumai, inda bhekuhukumuko tee manga panyaki ipakangkanaiakaku i manga miana Mesir. Iakumo KAWASANA OPU mopauntokomu minaaka i panyakimu.\" ");
INSERT INTO wlo_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Sapadhana sumai manga incia akawamo i tampa isarongiaka Elim. Iwe sumai dhaangia sapulu rua angu matana uwe tee pitu pulu puuna horomaa. Kasiimpomo manga incia apokema i saripina uwe sumai. ");
INSERT INTO wlo_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Kasiimpo bhari-bharia miana Israel abhose minaaka i Elim. Sapadhana manga abhose minaaka i Elim, i tanggala 15 malo i bula rua mbulana sapadhana manga incia abholi Mesir, akawamo manga incia i Tana Matuu Sin, i tanga-tangana Elim tee Gunu Sinai. ");
INSERT INTO wlo_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","I tana matuu sumai uumatina Israel bhari-bharia adodo i Musa tee Harun. ");
INSERT INTO wlo_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Pogauna manga incia, \"Salabhina ingkami mangapekamatemo KAWASANA OPU i Mesir. Iwe sumako aipomo ingkami amembali tauncura takande dagi tee roti sakawana tamambosu. Maka ingkomiu ubhawa ingkami iwe sii mamudhaakana bhari-bharikami tamateaka kaara.\" ");
INSERT INTO wlo_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Firimanina KAWASANA OPU i Musa, \"Sii-sii bhekupasapoakakomiu roti motaralabhi-labhina mboomo wao to bhari-bharikomiu. Saeo-saeo uumati sii tabeana alimba minaaka i pokemaa tee arombusaka kinande sumai sakawana to saeoa. Tee cara incia sumai Iaku bhekuuji uumatiku mamudhaakana kumataua ande manga incia ataʼati i manga parintaku atawa inda. ");
INSERT INTO wlo_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","I eo nama eona manga incia tabeana arombusaka kinande sumai rua kali lipa kabharina minaaka i eo mosagaanana.\" ");
INSERT INTO wlo_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Sabutuna apogaumo Musa tee Harun i bhari-bharia miana Israel, \"Wakutuuna asoomo eo sii ingkomiu bheumataua ande KAWASANA OPU mobhawakomiu ulimba minaaka i Mesir. ");
INSERT INTO wlo_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Naile saeona ingkomiu bheukamata cahea kamuliangina KAWASANA OPU roonamo Incia padhamo arangokomiu udodo i Incia. Sababuna, incema buaka ingkami sii, sampemo ingkomiu udodo i ingkami? ");
INSERT INTO wlo_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","KAWASANA OPU bheadhawukomiu dagi i wakutuuna asoomo eo, tee roti i wakutuuna saeona sakawana umambosu, roonamo KAWASANA OPU padhamo arangokomiu upeenci udodo i Incia. Satotuuna, ingkami mencuana incema-incema; peencimiu mencuana tee ingkami, maka tee KAWASANA OPU.\" ");
INSERT INTO wlo_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Kasiimpomo Musa atumpumo Harun to apaumbaaka kasameana incia sii i bhari-bharia miana Israel, \"Maimo, uumba upoaro i KAWASANA OPU, sababuna Incia padhamo arango peencimiu sumai.\" ");
INSERT INTO wlo_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Tangasaana Harun apogau i saangua uumatina Israel, manga incia apotonto i weta i tana matuu. Sanampuu manga incia akamata cahea kamuliangina KAWASANA OPU i nuncana taʼina ngalu. ");
INSERT INTO wlo_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Firimanina KAWASANA OPU i Musa, ");
INSERT INTO wlo_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","\"Iaku padhamo kurango peencina miana Israel. Pogauakamea i manga incia mboo sii, 'I wakutuuna asoomo eo ingkomiu bheukande dagi, tee i wakutuuna saeona bheukande roti sakawana umambosu. Sumaimo, ingkomiu bheumataua ande Iakumo KAWASANA OPU, Aulataʼalamiu.' \" ");
INSERT INTO wlo_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","I wakutuuna asoomo eo, aumbamo manu-manu sonta sampe abhari mpuu sakawana atutubhi saangua pokemaa, tee wakutuuna saeona asapomo o alo i saripina pokemaa. ");
INSERT INTO wlo_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Wakutuuna o alo sumai asoa, atokamatamo i bhawona tana matuu saangu momanipina mboomo ona tee amaʼalusu mboomo o alona esi. ");
INSERT INTO wlo_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Wakutuu miana Israel akamatea, manga incia inda amataua opea sumai. Sabutuna apoabha-abhakimo manga incia samia tee mosagaanana, \"Opea sumai?\" Kasiimpo Musa apogau i manga incia, \"Siitumo roti idhawuakana KAWASANA OPU to kinandemiu. ");
INSERT INTO wlo_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Mboo sii parintana KAWASANA OPU, 'Enemea sumai, sumbesumbere mboo kabharina ifaraluumiu, siitumo rua litere to samia-samia antona bhanua.' \" ");
INSERT INTO wlo_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Miana Israel apewau mboo sumai, maka dhaangia morombusakana abhari tee dhaangia uka morombusakana saidhe. ");
INSERT INTO wlo_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Wakutuuna manga incia agantea tee gomer, garaaka ande o mia morombusakana abhari, inda akolabhi, tee morombusakana saidhe, inda akura. Sumbesumbere arombusaka kabharina to ifaraluuna. ");
INSERT INTO wlo_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Musa apogau i manga incia, \"Incemapo uka inda amembali adhika bhilaana kinande sumai moomini saidhe to naile.\" ");
INSERT INTO wlo_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Maka pia-pia mia i tanga-tangana manga incia inda afaduliakea pogauna Musa tee adhika sagaa minaaka i kinande sumai. Samainawana, kinande sumai akoulo tee akobhou mabhongko. Sumaimo o Musa aʼamaramo i manga incia. ");
INSERT INTO wlo_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Saeo-saeo manga incia arombusakamo kinande sumai mboomo kabhari ifaraluuna manga, tee ande o eo apepuumo amasodho, kinande motobholina i tana sumai arere tee aila. ");
INSERT INTO wlo_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","I eo nama eona, siitumo eona Jumaa, manga incia arombusakamo kinande sumai rua kali lipa kabharina, siitumo pata litere to samia. Bhari-bharia kapalana jamaʼa aumba tee apaumbaakea hali incia sumai i Musa. ");
INSERT INTO wlo_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Pogauna Musa i manga incia, \"Siimo parintana KAWASANA OPU, 'Naile satotuuna eona Sabat, siitumo eona Saputuu, eo ipasombaaka to uhoromati Iaku, KAWASANA OPU. Jadi naile ingkomiu uponiunto saeoa. Sababuna sumai, roti sumai tabeana atonasu eo sii uka, malape atotunu atawa atonasu. Molabhina minaaka i faraluu eo sii, gaatia tee dhikamea bhilaana to naile.' \" ");
INSERT INTO wlo_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Manga incia adhikaia to nailena mboomo iparintaakana Musa, tee bhilaana roti sumai inda akobhou tee inda akoulo. ");
INSERT INTO wlo_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Musa apogau, \"Siimo kinandemiu to eo sii, sababuna eo sii eona Saputuu, eo poniuntoa to tahoromati KAWASANA OPU, tee ingkomiu inda bheupotibhaaka roti sumai moomini saidhe i tana. ");
INSERT INTO wlo_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Nama eo kangengena ingkomiu tabeana uenea, maka i eo pitu eona, siitumo eona Saputuu tee inda dhaangia o roti mosapona i eo incia sumai.\" ");
INSERT INTO wlo_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Maka i eo pitu eona, dhaangiapo uka pia-pia mia miana Israel gauna bhearombusaka roti sumai, maka manga incia inda apotibhaaka opeopea. ");
INSERT INTO wlo_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Kasiimpo KAWASANA OPU afirimani i Musa to apaumbaaka i manga mia incia sumai, \"Sakawana naepia ingkomiu inda utaʼati manga parintaku tee hukumuku? ");
INSERT INTO wlo_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Udhanimea, Iakumo modhawuakakomiu eona Saputuu. Siitumo sababuna i eo nama eona kudhawuakakomiu kinande sakawana to rua eo. I eo pitu eona, bhari-bharia mia tabeana amboore i bhanua, inda amembali alimba.\" ");
INSERT INTO wlo_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Sababuna sumai, manga miana Israel inda akarajaa i eo pitu eona. ");
INSERT INTO wlo_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Roti sumai asarongiakea manna o miana Israel. Bhanguna mboomo manga ompole maidhiidhi mokowaranaana maputi tee o namina mboomo hole-hole motokarajaana minaaka i golana uwani. ");
INSERT INTO wlo_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Musa apaumba manga miana Israel, \"KAWASANA OPU padhamo afirimani mboo sii, 'Alamo tee udhikamo rua litere manna sumai to siwulumiu, mamudhaakana manga incia amembali akamata roti idhawuakaku i ingkomiu i tana matuu, wakutuuna kubhawa ingkomiu ulimba minaaka i Mesir.\" ");
INSERT INTO wlo_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Musa apogau i Harun, \"Alamea saangu bhosu, papesuamea rua litere manna i nuncana tee dhikamea i aroana KAWASANA OPU to adhikaia to siwuluta.\" ");
INSERT INTO wlo_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Sumaimo, Harun adhika bhosu sumai i aroana Soronga Pojanjia to adhikaia pokana mboomo parintana KAWASANA OPU i Musa. ");
INSERT INTO wlo_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Miana Israel akande manna sumai kangengena 40 tao, sakawana manga incia Israel akawa i lipu mbooresana, siitumo i potidhaana Tana Kanaan. ");
INSERT INTO wlo_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Saangu kaganta gomer (2,2 litere) ipakena manga mia i zamani incia sumai to agantaaka manna, antona sapersapulu efa (kera-kera 22 litere). ");
INSERT INTO wlo_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Kasiimpo bhari-bharia uumatina miana Israel abholimo Tana Matuu Sin tee apekapinda-pinda minaaka i saangu tampa arope i tampa mosagaanana mboomo ifirimaniakana KAWASANA OPU. Kasiimpo manga incia apokema i Rafidim, maka iwe sumai inda dhaangia o uwe isumpu. ");
INSERT INTO wlo_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Kasiimpomo uumatina Israel apogera tee Musa tee apogaumo, \"Mangadhawu uwe, mamudhaakana ingkami membali tasumpu.\" Pogaumo Musa i manga incia, \"Pokia ingkomiu upogera tee iaku? Pokia ingkomiu ucobai KAWASANA OPU?\" ");
INSERT INTO wlo_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Maka uumatina sumai amatuu mpuu bhorokona, sabutuna manga incia apeenci tee Musa tee apogau, \"To opea ingkoo utonda ingkami talimba minaaka i Mesir? To upekamate ingkami, manga anamami, kadhambaakamami rampaakanamo katuuna bhorokomami?\" ");
INSERT INTO wlo_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Sanampuu agoramo Musa i KAWASANA OPU, pogauna, \"Opea tabeana ipewauku i uumati sii? Kamatea, manga incia bheatudhaaku tee bhatu.\" ");
INSERT INTO wlo_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Afirimanimo KAWASANA OPU i Musa, \"Lingkamo i aroana uumati sumai tee bhawamea pia-pia mia minaaka i manga mancuanana Israel. Bhawamea katuko ipakemu to ubhebheaka umala Nil, kasiimpo lingkamo. ");
INSERT INTO wlo_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Satotuuna, Iaku bhekukakaro i aroamu, i bhawona bhatu maoge i Gunu Horeb. Ingkoo tabeana ubhebhe bhatu maoge sumai, sabutuna o uwe bhealimba minaaka iwe sumai, sanampuu manga uumati membali asumpu.\" Kasiimpo Musa apewau mboo sumai i aroana manga mancuanana Israel. ");
INSERT INTO wlo_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Incia asarongiakea tampa incia sumai o Masa tee Meriba, roonamo miana Israel padhamo apogera tee roonamo manga incia padhamo acobai KAWASANA OPU tee apogau, \"Dhaangia buaka KAWASANA OPU i tanga-tangata atawa inda?\" ");
INSERT INTO wlo_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Kasiimpo aumbamo miana Amalek, apotimbe aewangi miana Israel i Rafidim. ");
INSERT INTO wlo_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Musa apogau i Yusak, \"Pilimo manga mia to aewangiaka miana Amalek. Naile iaku bhekukabhalebhale i tubuna kabumbu sumai tee kukeni katukona Aulataʼala i limaku.\" ");
INSERT INTO wlo_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Yusak apewau mboomo ipogauakana Musa. Samainawana, incia tee manga mia ipilina alingka to apotimbe aewangi miana Amalek, sainamo Musa, Harun, tee Hur apangara i kabumbu akawea i tubuna. ");
INSERT INTO wlo_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Tee amembalimo mboo sii: ande Musa aangka limana, miana Israel momangantalona. Maka ande Musa apasapo limana, miana Amalek momangantalona. ");
INSERT INTO wlo_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Wakutuuna limana Musa amalutemo, Harun tee Hur aalamo saangu bhatu mamudhaakana Musa amembali auncura, kasiimpo Harun tee Hur akabhale-bhale i kaai tee i kaanana Musa to atuko limana mamudhaakana sadhaadhaana atoangka sampe o matanaeo asoo. ");
INSERT INTO wlo_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Mboo sumaimo Yusak amangantaloaka miana Amalek tee matana ewangana. ");
INSERT INTO wlo_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","KAWASANA OPU afirimanimo i Musa, \"Buria hali incia sii i nuncana saangu kitabi to tanda kaudhania tee pakawaakea i Yusak, ande Iaku bhekuhapusua miana Amalek sampeampearo minaaka i dunia sii sabutuna indamo dhaangia o mia moudhanina.\" ");
INSERT INTO wlo_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Musa apabhangu saangu tampa tunuana kurubani tee asarongiakea, \"KAWASANA OPU sumai tombiku, modhawuaku kamangantalo.\" ");
INSERT INTO wlo_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Incia apogau, \"Angkamea pekalanga tombina KAWASANA OPU! KAWASANA OPU bheapotimbe aewangi miana Amalek to saʼumurua!\" ");
INSERT INTO wlo_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Yitro, imamu i Midian, maniana Musa, arangoa bhari-bharia ipewauna Aulataʼala i Musa tee i Israel, uumatina, ande KAWASANA OPU padhamo abhawa miana Israel alimba minaaka i Mesir. ");
INSERT INTO wlo_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Sumaimo alingkamo Yitro, apokawa tee Musa, abhawa Zipora, bhawinena Musa. Zipora inda apobhawa tee Musa roonamo Musa i piamo itu atumpua ambuli i amana i Midian. ");
INSERT INTO wlo_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","Zipora aumbamo tee rua mia anana umanena. Ana tumpena sarona Gersom, roonamo apogau Musa, \"Iaku padhamo kumembali dhaga i lipuna mia,\" ");
INSERT INTO wlo_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","tee samiana uka sarona Eliezer, sababuna apogau, \"Aulataʼalana amaku satotuuna motulungiaku. Incia apasalaamatiaku minaaka i ewangana Firaun.\" ");
INSERT INTO wlo_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Yitro aumba apobhawa tee bhawinena Musa tee rua mia anana i tana matuu, tampana Musa apokema i saripina Gunu Horeb, gunu ipekangkilona to Aulataʼala. ");
INSERT INTO wlo_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Incia atumpu tumpuana apogauakea i Musa, \"Iaku, maniamu Yitro, kuumba i ingkoo kupobhawa tee bhawinemu tee rua mia anamu.\" ");
INSERT INTO wlo_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Kasiimpo alimbamo Musa apokawaaka maniana. Incia asujumo ahoromati incia tee aikia. Manga incia abhaaka kadhaangiana samia tee sagaanana, kasiimpo apesua i nuncana kema. ");
INSERT INTO wlo_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Musa apetulatulaakamea i maniana bhari-bharia ipewauna KAWASANA OPU i Firaun tee i manga miana Mesir roonamo miana Israel, tee sagala kasukara ipotibhaakana manga i lingkaana tee tuaapa KAWASANA OPU apasalaamati manga incia. ");
INSERT INTO wlo_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Sumaimo akaunde-undemo Yitro arango sagala kalapena ipewauna KAWASANA OPU i miana Israel wakutuu apasalaamati manga incia minaaka i limana miana Mesir. ");
INSERT INTO wlo_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Pogauna Yitro, \"Bhari-bharia kapujia to KAWASANA OPU mopadhana mopasalaamatikomiu minaaka i limana miana Mesir tee limana Firaun. ");
INSERT INTO wlo_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Sii-sii iaku kumataua ande KAWASANA OPU alabhi kaogena minaaka i bhari-bharia dewa, roonamo Incia apewau hali incia sii i manga miana Mesir mosombona i uumatina Israel.\" ");
INSERT INTO wlo_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Kasiimpo Yitro, maniana Musa, apasombaaka kurubani tunua tee pia-pia mbaa kurubani isumbele to asomba i Aulataʼala. Kasiimpo Harun tee bhari-bharia mancuana Israel aumba to akande roti tee maniana Musa i aroana Aulataʼala. ");
INSERT INTO wlo_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Samainawana, auncuramo Musa aʼadili uumati sumai. Uumati sumai akabhale-bhale i aroana Musa saeoa. ");
INSERT INTO wlo_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Wakutuuna maniana Musa akamata bhari-bharia ipewauna i uumati sumai, apogaumo incia, \"Opea uka ipewaumu i uumati sii? Pokia soo samia-miamu mouncurana uʼadili bhari-bharia uumati sumai, sainamo manga incia akabhale-bhale i aroamu saeoa?\" ");
INSERT INTO wlo_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Alawanimo Musa i maniana, \"Sababuna uumati sii aumba i iaku to apeelo isusuakana Aulataʼala. ");
INSERT INTO wlo_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Ande dhaangia mokoparakarana, manga incia aumba i iaku mamudhaakana kubhotukiakea parakarana manga, tee kupakawaakea manga katotapu tee hukumuna Aulataʼala.\" ");
INSERT INTO wlo_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Kasiimpo maniana Musa apogau i incia, \"Inda amalape hali ipewaumu itu. ");
INSERT INTO wlo_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Ande mboo sii torosu, ingkoo tee uumati mopobhawana tee ingkoo sii bheumangule mpuu. Karajaa sii amatamo laulau to ingkoo, tee inda umembali ukarajaaia samia-miamu. ");
INSERT INTO wlo_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Sii-sii, rangomea pogauku. Ande ingkoo uose kaadhariku, Aulataʼala bheatulingiko. Ingkoomo tabeana upoaro i Aulataʼala uwakili uumati sumai tee upakawaakea i Aulataʼala manga parakarana. ");
INSERT INTO wlo_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Adhariakea i manga incia manga katotapu tee hukumuna Aulataʼala. Ingkoo tabeana ususuakea i manga incia dhala molaengana ilaloina, tee manga pewau molaengana ipewauna manga. ");
INSERT INTO wlo_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Tee uka tabeana upeeloa minaaka i bhari-bharia uumati manga mia momakidhana tee momaekana i Aulataʼala, siitumo manga mia iparacaeana raʼeati tee abanci mia modhawuna doi sogo. Aangkea manga incia to raʼeati amembali kapalana to 1.000 mia, kapalana 100 mia, kapalana 50 mia, tee kapalana to 10 mia. ");
INSERT INTO wlo_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Manga incia tabeana aʼadili uumati saeo-saeo itantuaka. Dhaampo, bhari-bharia parakara momaoge tabeana manga incia abhawea i ingkoo, maka bhari-bharia parakara momaidhiidhi, tabeana manga incia aʼadilia karona. Mboo sumaimo karajaamu bheamembali amagaagaa tee manga incia atanggojawapu apobhawa tee ingkoo. ");
INSERT INTO wlo_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Siitumo ipeeluna Aulataʼala to ipewaumu. Ande uose parintana, sumaimo ingkoo bheukapoia upewau karajaamu utanggoa. Saangua lipu sii uka bheambuli i tampana tee kasanaa, roonamo parakarana manga amondomo.\" ");
INSERT INTO wlo_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Musa aperangoi pogauna maniana tee apewaua bhari-bharia ipogauakana. ");
INSERT INTO wlo_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Minaaka i bhari-bharia miana Israel, Musa apili manga mia momakidha tee aangkea manga amembali kapalana to uumati sumai, amembali kapalana 1.000 mia, kapalana 100 mia, kapalana 50 mia, tee kapalana 10 mia. ");
INSERT INTO wlo_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Manga incia aʼadili uumati saeo-saeo. Manga parakara momatamo manga incia abhawea i Musa, maka bhari-bharia parakara momaidhiidhi manga incia aʼadilia karona. ");
INSERT INTO wlo_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Kasiimpo, Musa ataroaka Yitro sumai ambulimo i lipuna. ");
INSERT INTO wlo_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","I eo bhaa-bhaana, i bula talu mbulana sapadhana miana Israel alimba minaaka i Tana Mesir, manga incia akawa i Tana Matuu Sinai. ");
INSERT INTO wlo_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Sapadhana abhose minaaka i Rafidim, akawamo manga incia i Tana Matuu Sinai. Iwe sumai miana Israel apokema i aena Gunu Sinai. ");
INSERT INTO wlo_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Kasiimpo, Musa apangara i gunu sumai to apokawa tee Aulataʼala. KAWASANA OPU akemba Musa minaaka i gunu sumai tee afirimani, \"Mboo siimo tabeana upaumbaakea i miana Israel, siwuluna Yakub, ");
INSERT INTO wlo_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","'Ingkomiu samia padhamo ukamatea opea ipewauku i miana Mesir tee uka padhamo ukamataaku kukapalaikikomiu mamudhaakana uumba i Iaku iwe sii, tee kuangkakomiu mboomo manu-manu rajawali abhawa anana i bhawona panina. ");
INSERT INTO wlo_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Sii-sii, ande ingkomiu umpuu-mpuu uperangoi firimaniku tee ukenia pekatangka pojanjiaku sumaimo ingkomiu bheumembali harataa pewauaku minaaka i sagala lipu, roonamo saangua alamu satotuuna pewauaku. ");
INSERT INTO wlo_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Ingkomiu bheumembali to Iaku pamarintana manga imamu tee lipu momangkilo.' Firimani siimo tabeana upogauakea i miana Israel.\" ");
INSERT INTO wlo_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Kasiimpo ambulimo Musa akemba manga mancuanana lipu tee apetulatulaakamea i manga incia bhari-bharia firimani iparintaakana KAWASANA OPU i incia. ");
INSERT INTO wlo_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Bhari-bharia uumati sumai alawani apobhawa-bhawa, mboo sii, \"Bhari-bharia ifirimaniakana KAWASANA OPU i ingkami bhetapewaua.\" Kasiimpo Musa apakawaakamo kalawanina uumati sumai i KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Firimanina KAWASANA OPU i Musa, \"Satotuuna, Iaku bhekuumba i ingkoo i nuncana taʼina ngalu momakapa, mamudhaakana uumati sumai amembali arangoa ande kufirimani i ingkoo, mamudhaakana manga incia sadia aparacaea i ingkoo.\" Kasiimpo Musa apaumbaakamea pogauna uumati sumai i KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Firimanina KAWASANA OPU i Musa, \"Lingkamo i uumati sumai. Pekangkiloa manga incia i eo sii tee naile. Manga incia tabeana atapasi pakeana. ");
INSERT INTO wlo_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Wakutuuna amakasumo eo talu eona manga incia tabeana amakanumo, roonamo i eo talu eona KAWASANA OPU bheasapo i aroana bhari-bharia uumati sumai i Gunu Sinai. ");
INSERT INTO wlo_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Dhikaakea tidha i sakaaratea i bhiwina gunu sumai to tanda mamudhaakana manga miana lipu inda alalo tee apesombu iwe sumai. Sasia manga miana lipu sumai mboo sii, 'Jaga! Bholi upangara i gunu tee uka bholi udhingku potidaana. Incema-incema modhingkuna gunu sumai tabeana bheahukumu matea. ");
INSERT INTO wlo_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Inda samia uka momembalina modhingkuna mia sumai, ingkomiu tabeana utudhaakea tee bhatu atawa upanea sampe amate. Malape binata atawa maanusia inda bheatotaroaka adhadhi.' Tangkanamo wakutuuna sangkakala akonduu amaarate, kasiimpomo manga incia amembali akasui gunu sumai.\" ");
INSERT INTO wlo_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Kasiimpo asapomo Musa minaaka i gunu apokawaaka uumati sumai. Incia apekangkilo uumati sumai, kasiimpo miana Israel uka atapasi pakeana. ");
INSERT INTO wlo_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Apogau Musa i uumati sumai, \"Makanumo to naipua, bholi poromu tee bhawine.\" ");
INSERT INTO wlo_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","I eo talu eona, i wakutuu malo-malo, dhaangia guntu tee bhibhito. Taʼina ngalu momakapa atiumba i bhawona gunu tee atorangomo nduuna sangkakala momakaana mpuu. Bhari-bharia uumati i pokemaa sumai arengku tee amaeka. ");
INSERT INTO wlo_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Kasiimpomo Musa abhawa uumati sumai alimba minaaka i kema to apokawa tee Aulataʼala, kasiimpo manga incia akakaro i aena gunu sumai. ");
INSERT INTO wlo_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Saangua Gunu Sinai atutubhia ombu roonamo KAWASANA OPU asapo i bhawona gunu sumai i nuncana waa. Ombuna apene mboomo ombuna rapu tampa tunuana reo, tee saangua gunu sumai akolendu amakaa mpuu. ");
INSERT INTO wlo_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Nduuna sangkakala ajulu kangengena ajulu kakaana. Kasiimpo Musa apogaumo, tee Aulataʼala alawania i nuncana guntu. ");
INSERT INTO wlo_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","KAWASANA OPU asapo i bhawona lolona Gunu Sinai, tee akemba Musa mamudhaakana apene i bhawona gunu sumai. Kasiimpo Musa apangara ");
INSERT INTO wlo_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","tee KAWASANA OPU afirimani i Musa, \"Sapomo tee udhaniakea mpuu uumati sumai ande manga incia inda membali apesombu i tidhana gunu sumai to akamata KAWASANA OPU. Ande manga incia apewaua, abhari mia bhemomatena. ");
INSERT INTO wlo_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Tee uka manga imamu mopekakasuna i KAWASANA OPU tabeana apekangkilo karona, mamudhaakana KAWASANA OPU inda ahisabu manga incia.\" ");
INSERT INTO wlo_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Apogau Musa i KAWASANA OPU, \"Uumati sumai inda amembali apene i Gunu Sinai, roonamo Ingkoo samia moudhaniakana ingkami, mboo sumai, 'Dhikaakea tidha i sakaaratea i bhiwina gunu sumai tee uabhia momangkilona.\" ");
INSERT INTO wlo_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Firimanina KAWASANA OPU i incia, \"Lingkamo, sapomo, kasiimpomo penemo uka ingkoo tee Harun. Maka manga imamu tee raʼeati inda amembali apesombu to apene apoaro i KAWASANA OPU, mamudhaakana inda ahisabua.\" ");
INSERT INTO wlo_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Saanampuu asapomo Musa apokawaaka uumati sumai tee apogauaka hali sumai i manga incia. ");
INSERT INTO wlo_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Kasiimpo Aulataʼala apogauaka bhari-bharia firimani incia sii: ");
INSERT INTO wlo_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","\"Iakumo KAWASANA OPU, Aulataʼalamu, mobhawana ingkoo ulimba minaaka i Tana Mesir, i tampa umembali bhatua. ");
INSERT INTO wlo_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Bholi usomba dewa mosagaanana tabeana Iaku. ");
INSERT INTO wlo_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Bholi upewau to karomu patu mopokana tee opea uka modhaangiana i laiana i bhawo, atawa modhaangiana i alamu i tambe, atawa modhaangiana i nuncana uwe i tambena alamu. ");
INSERT INTO wlo_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Bholi usuju usomba atawa usambahea i dewa mosagaanana, roonamo Iaku, KAWASANA OPU, Aulataʼalamu, satotuuna Aulataʼala amendeu atopapokana tee opeapo uka, mobholosiakana kasalahana amana i manga anana, i manga siwuluna talu lapina tee pata lapina minaaka i manga mia mobanciaku, ");
INSERT INTO wlo_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","maka Iaku kususuaka kaasiku molagina i rewu-rewuna siwuluna mia momaasiakana Iaku tee motaʼatina manga parintaku. ");
INSERT INTO wlo_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Bholi usarongi sarona KAWASANA OPU, Aulataʼalamu, sambaraaka roonamo KAWASANA OPU bheahukumua incemapo mopewauna mboo sumai. ");
INSERT INTO wlo_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Udhania to uraraeaaka eona Sabat, siitumo eona Saputuu tee horomatia mboomo eo momangkilo. ");
INSERT INTO wlo_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Kangenge nama eo ingkoo tabeana ukarajaa tee upewau bhari-bharia karajaamu. ");
INSERT INTO wlo_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Maka eo i pitu eona siitumo eo poniuntoa to usambahea i KAWASANA OPU, Aulataʼalamu. I eo incia sumai uka bholi upewau karajaa opeopea, malape ingkoo, anamu umane, anamu bhawine, bhatuamu umane, bhatuamu bhawine, binatamu, atawa o dhaga momboorena tee ingkoo. ");
INSERT INTO wlo_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Roonamo kangengena nama eo KAWASANA OPU apamembali laiana tee alamu, tawo tee bhari-bharia antona, kasiimpomo Incia aponiunto i eo pitu eona. Siitumo sababuna KAWASANA OPU abarakati eona Saputuu tee apamembalia amangkilo. ");
INSERT INTO wlo_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Horomatia amamu tee inamu, mamudhaakana amarambe umurumu i tana idhawuakana KAWASANA OPU, Aulataʼalamu, i ingkoo. ");
INSERT INTO wlo_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Bholi upekamate. ");
INSERT INTO wlo_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Bholi uzina. ");
INSERT INTO wlo_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Bholi umanako. ");
INSERT INTO wlo_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Bholi udhawu sakusii mogau-gau to samaanusiamu. ");
INSERT INTO wlo_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Bholi upeelu bhanuana samaanusiamu; bholi upeelu bhawinena samaanusiamu; bholi upeelu bhatuana umane atawa bhatuana bhawine samaanusiamu, atawa sapina, atawa keledaina, atawa opeopeapo uka modhaangiana i samaanusiamu.\" ");
INSERT INTO wlo_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Bhari-bharia uumati sumai akamata guntu tee bhibhito, nduuna sangkakala tee gunu mokoombu. Wakutuuna uumati sumai akamatea, arengkumo manga roonamo amaekamo, kasiimpo akakaro apekaridho. ");
INSERT INTO wlo_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Manga incia apogau i Musa, \"Ande ingkoo mopogauna i ingkami, ingkami bhetaperangoi parintamu. Maka ande Aulataʼala mopogauna i ingkami, ingkami dhaanamo bhetamate.\" ");
INSERT INTO wlo_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Apogau Musa i uumati sumai, \"Bholi umaeka! Aulataʼala aumbamo to akamata opea ipewaumiu wakutuu Incia dhaangia i tanga-tangamiu. Aulataʼala gauna umaeka i Incia, mamudhaakana ingkomiu inda ukodosa pendua.\" ");
INSERT INTO wlo_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Uumati sumai akakaro apekaridho, maka Musa apekakasu i taʼina ngalu mogalapu mopoposana sumai tampana Aulataʼala aumba. ");
INSERT INTO wlo_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","KAWASANA OPU afirimani i Musa, \"Mboo siimo tabeana upaumbaakea i miana Israel, 'Ingkomiu padhamo usakusiiakea ande Iaku kufirimani i ingkomiu minaaka i laiana. ");
INSERT INTO wlo_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Ingkomiu bholi ukarajaa manga patu barahala minaaka i pera atawa i bulawa to usombaia tabeana Iaku. ");
INSERT INTO wlo_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Maka karajaaia to Iaku saangu tampa tunuana kurubani minaaka i tana tee pasombaakea iwe siitu dumba tee sapimu to kurubani tunua tee kurubani upomalape tee Aulataʼala. I manga tampa ipatantuakaku i ingkoo to tampana sambahea i Iaku, Iaku bhekuumba to kubarakatiko. ");
INSERT INTO wlo_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Ande ingkoo bheukarajaakaaku manga tampa tunuana kurubani minaaka i bhatu, karajaakea minaaka i bhatu inda motopaati. Bholi ukarajaaia minaaka i bhatu motopaati, roonamo ande bhatu sumai upaatia, tampana sambahea sumai indamo amembali atopake to usomba Iaku rampaakanamo unaajisiakea. ");
INSERT INTO wlo_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Bholi kompa i odha i tampana tunuana kurubaniku, mamudhaakana auratimu inda atokamata.\" ");
INSERT INTO wlo_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Kasiimpo KAWASANA OPU apogau i Musa, \"Ingkoo tabeana upatotapua manga hukumu sii to uumatiku: ");
INSERT INTO wlo_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Ande ingkoo uali samia bhatua miana Ibrani, incia tabeana akarajaa to ingkoo kangenge nama tao, maka i tao pitu taona incia tabeana atopabebasi tee inda afaraluu apomea opeopea. ");
INSERT INTO wlo_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Ande bhatua sumai aumba samia-miana, incia tabeana alimba samia-miana uka. Ande bhatua sumai aumba tee bhawinena, bhawinena tabeana alimba uka apobhawa tee incia. ");
INSERT INTO wlo_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Maka ande opuna adhawu bhatua sumai samia bhawine to bhawinena, tee bhawine sumai apalaahiri anaana umane atawa bhawine to umanena, siitumo bhawinena tee manga anana sadhaadhaana amembali pewauana opuna, tee bhatua sumai tabeana alimba samia-miana. ");
INSERT INTO wlo_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Maka ande bhatua sumai ampuu-mpuu apogau, 'Iaku kumaasiaka opuku, bhawineku tee manga anaku. Iaku kumendeu kulimba mboomo mia mobebasi,' ");
INSERT INTO wlo_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","siitumo opuna tabeana abhawea i aroana Aulataʼala, kasiimpomo abhawea i bhamba atawa i ariina bhamba. Opuna tabeana asusu talingana tee kasusu, tee incia bheamembali bhatuana saʼumurua dhadhina. ");
INSERT INTO wlo_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Ande samia ama aaso anana bhawine to amembali bhatua, siitumo anana bhawine sumai inda bheatopabebasi sapadhana nama tao mboomo bhatua umane. ");
INSERT INTO wlo_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Ande opuna inda apeelu bhawine mopadhana ipilina to amembali maruena karona, siitumo incia tabeana aundaakea bhawine sumai atotolosi. Maka opuna inda akohaku aasoa i mia dhaga, roonamo opuna sumai apewau bhatua bhawine sumai inda aʼadili. ");
INSERT INTO wlo_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Ande samia opu apakawi anana umanena tee bhatua bhawine, incia tabeana apewaua bhatua bhawine sumai mboomo anana karona, mencuana mboomo bhatua. ");
INSERT INTO wlo_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Ande incia sumai akawi pendua, incia sadhaadhaana awaajibu to adhawu manga hakuna bhawine i bhawinena bhaa-bhaana mboomo kinande, pakea tee aporomuakea. ");
INSERT INTO wlo_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Ande opuna inda adhawuakea talu giuna sumai i incia, sumaimo incia amembali alimba, tee inda apomea katolosi opeopea.\" ");
INSERT INTO wlo_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","\"Incema uka mobhebhena samaanusiana sampe amate, incia dhaanamo atohukumu mate. ");
INSERT INTO wlo_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Maka ande Iaku Aulataʼala kutaroakea amembali, tee mia incia sumai inda aporadhamiia tee inda ahaejati apekamate samaanusiana, incia amembali apalai i saangu tampa isusuakaku i ingkoo, tee iwe sumai incia apotibhaaka peulusa. ");
INSERT INTO wlo_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Maka ande samia ahaejati apekamate mia mosagaanana, kasiimpo apalai i tampana tunuana kurubaniku to apotibhaaka peulusa, mia sumai tabeana atoala minaaka i tampana tunuana kurubani tee atohukumu mate. ");
INSERT INTO wlo_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Incemapo uka mobhebhena amana atawa inana, incia dhaanamo atohukumu mate. ");
INSERT INTO wlo_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Incemapo uka momanakona mia mosagaanana, moomini mia sumai padhamo aasoa atawa dhaangia ataangia, momanakona sumai tabeana atohukumu mate. ");
INSERT INTO wlo_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Incemapo uka motundana amana atawa inana, tabeana atohukumu mate. ");
INSERT INTO wlo_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Ande dhaangia manga mia mopogerana kasiimpo samia abhebhe mosagaanana tee bhatu atawa abusua tee limana, ande mia ibhebhena sumai inda amate maka apotidhole i kolema roonamo amapii, ");
INSERT INTO wlo_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","kasiimpo mia sumai amembalimo abhangu alingka apake katuko, mia mobhebhea inda bheatohukumu, maka tabeana adhambaaka mia mapii sumai sakawana aunto tee abholosia karugiana kangengena mia sumai inda amembali akarajaa roonamo kapiina. ");
INSERT INTO wlo_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Ande samia abhebhe bhatuana umane atawa bhawine tee katuko, saanampuu bhatua sumai amate i limana, mia sumai dhaanamo atohukumu. ");
INSERT INTO wlo_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Maka ande bhatua sumai dhaangiapo adhadhi saeo rua eo, opu sumai bholi atohukumu, roonamo bhatua sumai pewauana karona. ");
INSERT INTO wlo_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Ande dhaangia pia-pia mia mopobusuna tee inda aporadhamii samia abhebhe samia bhawine mobhawa-bhawana sabutuna anana ibhawa-bhawana amadhakiakea, maka bhawine sumai inda apotibhaaka balaa, sabutuna mia sumai dhaanamo arimbitia kabharina mboomo ituntuna umanena bhawine sumai i incia, tee incia tabeana apomeaia mboomo ibhotukiakana haakimu. ");
INSERT INTO wlo_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Maka ande bhawine sumai apokawaaka balaa, tantumo ingkoo tabeana ubholosia inyawana bhawine sumai tee inyawamu karomu, ");
INSERT INTO wlo_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","mata abholosiakea mata, nginci abholosiakea nginci, lima abholosiakea lima, ae abholosiakea ae, ");
INSERT INTO wlo_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","kambelana kangau abholosiakea kambelana kangau, kambela abholosiakea kambela, wundu abholosiakea wundu. ");
INSERT INTO wlo_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Ande samia abhebhe matana bhatuana umane atawa bhatuana bhawine sabutuna amawilo, sumaimo incia tabeana apabebasia bhatua sumai alingka mboomo mia mobebasi to abholosiaka matana sumai. ");
INSERT INTO wlo_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Ande incia abhebhe bhatuana umane atawa bhawine sampe amandawu ngincina, sumaimo incia tabeana apabebasia bhatua sumai alingka, mboomo mia mobebasi to abholosiaka ngincina sumai. ");
INSERT INTO wlo_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Ande sambaa sapi atanduki samia umane atawa bhawine, sabutuna amate, sapi sumai dhaanamo atudhaakea bhatu sampe amate tee dagina inda membali atokande. Maka mokosapina sumai abebasi minaaka i kasalahana. ");
INSERT INTO wlo_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Maka ande sapi sumai minaaka i piamo itu sadiamo apekatanduki tee mokopewauana padhamo audhaniakea, maka inda ajagania, kasiimpo sapi sumai apekamate samia umane atawa bhawine, sumaimo sapi sumai tabeana atudhaakea bhatu tee mokopewauana uka tabeana atohukumu mate. ");
INSERT INTO wlo_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Maka ande manga witinaina momatena atuntu doina katolosi minaaka i mia mokosapina, sumaimo incia tabeana apomea bhari-bharia doi ituntuna sumai to katolosina inyawana. ");
INSERT INTO wlo_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Ande sapi sumai atanduki samia anana umane atawa atanduki samia anana bhawine, satotuuna mokopewauana tabeana apewaua mboo hukumu sumai uka. ");
INSERT INTO wlo_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Ande sapi sumai atanduki samia bhatua umane atawa bhawine, sumaimo mokopewauana tabeana apomea 30 tibha syikal doi pera i opuna bhatua sumai, tee sapi sumai tabeana atudhaakea bhatu sampe amate. ");
INSERT INTO wlo_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Ande samia abungkale katutubhina sumu, atawa ande samia aseli sumu tee inda atutubhia, kasiimpo sambaa sapi atawa keledai amandawu i nuncana sumu, ");
INSERT INTO wlo_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","sumaimo mokosumuna tabeana apomeaia kabholosina. Tee incia tabeana apomeaia haragaana binata sumai i mokopewauana, sainamo bhangke sumai amembalimo pewauana. ");
INSERT INTO wlo_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Ande sapina mia atanduki sapina mia mosagaanana, sampe amate, sumaimo sapi modhadhina sumai tabeana atoaso, tee doina tabeana atobage rua bagea. Sapi momatena sumai uka tabeana atobage rua bagea. ");
INSERT INTO wlo_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Maka ande atomataumo sapi sumai minaaka i piamo itu amenturumo apekatanduki maka mokopewauana amendeu ajagania, sumaimo incia tabeana apomeaia kabholosina; incia tabeana abholosiakea tee sapi umane modhadhina i mia mokopewauana sapi momatena, sapi abholosi sapi, sainamo bhangke sumai amembali pewauana.\" ");
INSERT INTO wlo_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","\"Ande sala samia amanako sambaa sapi atawa sambaa dumba kasiimpo asumbelea atawa aasoa, sumaimo incia tabeana apomeaia kabholosina, lima mbaa sapi kabholosina sapi sumai tee pata mbaa dumba kabholosina dumba sumai. ");
INSERT INTO wlo_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Ande samia pande manako apotibhaakea tangasaana amanako i nuncana bhanuana mia, kasiimpo abhebhea sampe amate i wakutuuna malo, sumaimo mia mopekamatena sumai inda asala. ");
INSERT INTO wlo_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Maka ande o mia abhebhe mia momanako sumai sakawana amate i wakutuuna sabhetena matanaeo, sumaimo mia mopekamatea sumai aabhia asala. Samia momanakona tabeana abholosi bhari-bharia mopadhana imanakona. Ande incia indamo tee opeopeana uka, incia tabeana atoaso to kabholosina bara imanakona sumai. ");
INSERT INTO wlo_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Ande binata imanakona sumai apokawaakea i limana dhaangiapo adhadhi, malape o sapi atawa keledai atawa dumba, sumaimo incia tabeana apomeaia kabholosina rua kali lipa. ");
INSERT INTO wlo_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Ande samia ajagani kadhambaaka i inawuna atawa inawuna angguru, kasiimpo binatana sumai arambasakea tee akande penembulana apepadhaia i inawuna mia mosagaanana, sumaimo incia tabeana adhawuaka hasilina momalapena minaaka i inawuna karona atawa hasilina momalapena minaaka i inawuna angguruna to apomeaia kabholosina karugiana. ");
INSERT INTO wlo_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Ande waa arore tee adhelapi rumpu mokoruina, saanampuu kabumbuna gandum atawa gandum indapo mototimpuna atawa saangua inawu akandea apepadhaia, sumaimo mia mopakatana waa sumai tabeana apomeaia kabholosina karugiana bhari-bharia. ");
INSERT INTO wlo_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Ande samia adhika doi atawa bara i sabhangkana, kasiimpo doi sumai amanakoa minaaka i bhanuana mia sumai, sabutuna ande momanakona sumai apotibhaakea, incia tabeana apomea kabholosina karugiana rua kali lipa. ");
INSERT INTO wlo_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Ande momanakona sumai inda apotibhaakea, sumaimo mokobhanuana tabeana atobhawa i tampana ibaadati. Iwe sumai incia tabeana amangaku mpuu-mpuu tee asakusiiakea Aulataʼala, ande incia inda amanako bara mokoharagaa pewauana sabhangkana sumai. ");
INSERT INTO wlo_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","I nuncana sagala parakara posala maʼana, malape to sapi atawa keledai atawa dumba atawa pakea atawa bara opeapo uka momambuuna, ande samia mopogauna, 'Sii pewauaku,' sumaimo parakarana rua miana sumai tabeana abhawea i aroana Aulataʼala. Incema ipasalana Aulataʼala tabeana apomea kabholosina karugiana rua kali lipa i sabhangkana. ");
INSERT INTO wlo_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Ande sala samia adhikaia i sabhangkana sambaa keledai atawa sapi atawa bhembe atawa binata mosagaanana, kasiimpo binata sumai amate atawa amambela atawa aalea mia inda dhaangia mokamatea, ");
INSERT INTO wlo_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","sumaimo tabeana aposumpa i tanga-tangana rua miana sumai i aroana KAWASANA OPU. Mia modhambaakana binata sumai tabeana apogau, \"Mencuana iaku momanakona binata kadhambaakana mia sii.\" Mokopewauana tabeana atarimaia sumpa incia sumai, tee sabhangkana sumai inda afaraluu apomea karugiana. ");
INSERT INTO wlo_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Maka ande binata sumai atotuu-totuu amanakoa minaaka i incia sumaimo mia momanakona binata sumai tabeana apomeaia kabholosina karugiana i mokopewauana. ");
INSERT INTO wlo_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Ande binata sumai atotuu-totuu apapakia binata masega, sumaimo incia tabeana abhawea to bukutiina. Incia bholimo apomea kabholosina karugiana to binata ipapakina sumai. ");
INSERT INTO wlo_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Ande samia aadha sambaa binata minaaka i sabhangkana, kasiimpo binata sumai amambela atawa amate, wakutuuna mokopewauana inda dhaangia iwe sumai, sumaimo incia tabeana apomeaia kabholosina karugiana bhari-bharia. ");
INSERT INTO wlo_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Maka ande mokopewauana dhaangia iwe sumai, incia bholimo apomeaia kabholosina karugiana. Ande binata sumai asewaia, karugiana sumai atolentumo tee sewana. ");
INSERT INTO wlo_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Ande sala samia awujumo samia anana kabuabua indapo dhaangia motaurakaakea to akole tee incia, tabeana apomeaia taurakana tee akawiakea. ");
INSERT INTO wlo_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Ande o amana bhawine sumai inda aundaakea sampeampearo o umane sumai akawi tee anana, o umane sumai tabeana apomea doi amondo kabharina mboomo taurakana kabuabua.\" ");
INSERT INTO wlo_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","\"Samia bhawine ahalii sihiri bholi taroakea adhadhi. ");
INSERT INTO wlo_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Incemapo uka moposaanguna tee sambaa binata, incia dhaanamo ahukumu matea. ");
INSERT INTO wlo_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Incema mopasombaakana kurubani i manga dewa mencuana i KAWASANA OPU, incia tabeana atopabinasa.\" ");
INSERT INTO wlo_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","\"Bholi upisaki samia dhaga atawa upewaua inda aʼadili, roonamo ingkomiu uka i piamo itu o dhaga i Tana Mesir. ");
INSERT INTO wlo_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Bholi upisaki samia iaiaro atawa samia anaana maelu. ");
INSERT INTO wlo_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Ande ingkomiu atotuu upisaki manga incia, kasiimpo manga incia agoramo i Iaku, dhaanamo bhekuperangoi gorana manga. ");
INSERT INTO wlo_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Iaku bhekuamara mpuu tee bhekupekamatekomiu tee ewanga, sabutuna manga bhawinemiu amembali iaiaro tee manga anamiu amembali anaana maelu. ");
INSERT INTO wlo_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Ande ingkoo upaadhaaka doi i samia minaaka i uumatiku mokakurangana i tanga-tangamu, bholi upewau mboomo mia pande giwuna dhosa, tee bholi utuntu bungana. ");
INSERT INTO wlo_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Ande ingkoo sampe uala jubana sabhangkamu to upakenia, pambuliakea wakutuuna matanaeo indapo asoo, ");
INSERT INTO wlo_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","roonamo tangkanamo incia sumai katutubhina badana mia misikini to apekasodhoaka badana wakutuuna akole malo. Jadi, ande incia agora i Iaku, Iaku bhekurangoa, roonamo Iaku sii amalape incaku.\" ");
INSERT INTO wlo_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","\"Bholi uhina Aulataʼala tee bholi utundaia samia kapalana lipumu. ");
INSERT INTO wlo_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Bholi umalingu upasombaaka hasilina timpuamu, hasilina uwena anggurumu tee mina zaitunmu. Ingkoo tabeana udhawuakaaku manga anamu umane tumpe i Iaku. ");
INSERT INTO wlo_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Mboo sumai uka tabeana udhawuakaaku manga anana binata molaahirina mobhaa-bhaana minaaka i gulumana sapi, bhembe, tee dumbamu. Kangenge pitu eo manga anana binata sumai tabeana amboore tee inana, maka i eo walu eona ingkoo tabeana upasombaakamea i Iaku. ");
INSERT INTO wlo_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Ingkomiu tabeana umembali uumati momangkilo to Iaku, sababuna sumai bholi ukande dagi ipapakina binata masega. Tudhaakea dagi sumai i mantoa.\" ");
INSERT INTO wlo_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","\"Bholi upetulatulaaka lele gau-gau tee bholi utulungi mia madhaki udhawu sakusii inda mototuu. ");
INSERT INTO wlo_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Bholi uose mia bhari ande apewau madhaki. Ande ingkoo umembali sakusii to saangu parakara, bholi udhawu sakusii gau-gau uose mia bhari to upogauaka inda moʼadilina. ");
INSERT INTO wlo_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Bholi umatamo saweta ande tangkanamo to uewaaka mia roonamo incia amisikini. ");
INSERT INTO wlo_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Ande ingkoo ukamata sapi atawa keledaina musumu asaladhala, tantumo ingkoo tabeana upambulia binata sumai. ");
INSERT INTO wlo_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Ande ingkoo ukamata keledai pewauana mia momarikako amandawu roonamo amatamo bhawana, ingkoo tabeana utulungia apabhangu keledai sumai. Bholi soo ubholia mboo itu. ");
INSERT INTO wlo_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Bholi upewau inda moʼadilina i mia misikini i tanga-tangamiu i nuncana parakarana. ");
INSERT INTO wlo_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Pekaridhoa karomu minaaka i parakara gau-gau. Mia inda mosala tee mia mobanara inda amembali uhukumu matea, roonamo Iaku inda bhekupabanara mia madhaki. ");
INSERT INTO wlo_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Bholi utarima sogo, roonamo sogo apekawilo matana mia mopokamatana tee apekadhaki parakarana mia inda mosala. ");
INSERT INTO wlo_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Samia dhaga bholi upisakia. Ingkomiu samia umataua namisina umembali dhaga, roonamo ingkomiu uka i piamo itu o dhaga i Tana Mesir. ");
INSERT INTO wlo_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Kangengena nama tao ingkoo tabeana uhewi wine i tanamu tee urombusaka hasilina, ");
INSERT INTO wlo_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","maka i tao pitu taona ingkoo tabeana utaroakea tee ubholia mboo sumai, mamudhaakana manga mia misikini i tanga-tangana lipumu amembali akande, tee bhilaana manga incia amembali akandea binata maila. Mboo sumai uka tabeana ukarajaaia to inawuna anggurumu tee inawuna zaitunmu; ande i tao pitu taona sumai utaroakea tee ubholia. ");
INSERT INTO wlo_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Kangengena nama eo ingkoo umembali ukarajaa, maka i eo pitu eona ingkoo tabeana uunto. Tee mboo sumai sapimu tee keledaimu amembali aponiunto tee manga bhatuamu bhawine tee mia dhaga amembali aponiunto. ");
INSERT INTO wlo_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Ingkomiu tabeana utaʼati bhari-bharia hali ifirimaniakaku i ingkomiu. Bholi usarongi tee upuji manga dewa sagaanana.\" ");
INSERT INTO wlo_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","\"Talu mpearo satao ingkoo tabeana upadhaangia raraea to Iaku. ");
INSERT INTO wlo_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Sadiamo raraeaakea Eona Raraea Roti Inda Mokoragi. Kangengena pitu eo ingkoo tabeana ukande roti inda mokoragi, mboomo iparintaakaku i ingkoo, i wakutuu ipatotapuakana i bula Abib, roonamo i nuncana bula incia sumai ingkoo ulimba minaaka i Mesir. Bholi samia uka apoaro i aroaku tee ruambalia limana. ");
INSERT INTO wlo_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Sadiamo raraeaakea Eona Raraea Timpuana Gandum i bulaana timpua, tee upasombaaka bhake bhaa-bhaana ihasiliakana wine ihewimu i inawu. Sadiamo raraeaakea uka Eona Raraea Wale-wale Tawa, wakutuuna ingkoo umboore i wale-wale i kapadhaana tao sapadhana utobhe hasilina timpuamu i inawu. ");
INSERT INTO wlo_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Talu mpearo satao bhari-bharia umane tabeana aumba apoaro i aroana KAWASANA OPU Aulataʼalamu to asambahea. ");
INSERT INTO wlo_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Wakutuu upasombaaka raa minaaka i kurubani motosumbelena to Iaku, bholi upasombaaka uka tee manga kinande opeapo mokoragina. Tabhana kurubani eona raraeaku uka inda amembali akomalo sampe saeona, tabeana atotunu sampe amapupu. ");
INSERT INTO wlo_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Satao-satao ingkoo tabeana ubhawea i bhanuana KAWASANA OPU Aulataʼalamu hasilina timpuamu bhaa-bhaana momalapena. Ingkoo inda umembali unasu dagina anana dumba atawa anana bhembe tee uwena susuna inana.\" ");
INSERT INTO wlo_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","\"Satotuuna, Iaku kulamboko samia malaaʼekati alingka i aroamiu, to ajagani ingkomiu i dhala tee abhawa ingkomiu i tampa mopadhana ipasiapuakaaku. ");
INSERT INTO wlo_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Perangoia tee taʼatia. Bholi utagalia, roonamo kudhika kuasaku i nuncana malaaʼekati sumai. Ande ingkomiu utagalia, incia inda bheaʼamponia kasalahamiu. ");
INSERT INTO wlo_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Maka ande ingkomiu totuu-totuu uperangoia pogauna tee ukarajaaia bhari-bharia ifirimaniakaku, Iaku bhekumembali musu to manga musumiu tee bhali to manga bhalimiu. ");
INSERT INTO wlo_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Roonamo malaaʼekatiku bhealingka i aroamiu tee abhawa ingkomiu i tana miana Amori, miana Het, miana Feris, miana Kanaan, miana Hewi, miana Yebus tee Iaku bhekupabinasea manga. ");
INSERT INTO wlo_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Bholi usuju usomba atawa usambahea i dewana manga incia atawa uose carana manga incia asambahea. Maka ingkomiu tabeana upahancurua sampeampearo bhari-bharia barahala tee ariina barahalana isombana i nuncana ibaadatina manga incia. ");
INSERT INTO wlo_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Usambaheamo i KAWASANA OPU, Aulataʼalamiu, sumaimo Incia bheabarakatia rotimiu tee uwemiu. Iaku bhekupadhencua panyaki minaaka i tanga-tangamiu. ");
INSERT INTO wlo_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Inda bheadhaangia samia bhawine momadhakina kadhumana atawa mokombana i lipumiu. Iaku bhekudhawukomiu umuru marambe. ");
INSERT INTO wlo_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Kamingkiri to Iaku bhekulambokoa aporikanaaka ingkomiu tee Iaku bhekupakacau bhari-bharia lipu iumbatimiu. Iaku bhekupewau bhari-bharia musumiu apalai abholi ingkomiu. ");
INSERT INTO wlo_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Iaku bhekurambasaka towua mopabinasana aporikanaaka ingkomiu to apadhencu miana Hewi, miana Kanaan, tee miana Het minaaka i aroamiu. ");
INSERT INTO wlo_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Iaku inda bhekupadhencu manga incia minaaka i aroamiu i nuncana satao, mamudhaakana lipu sumai bholi amembali amalino mpuu tee manga binata maila bheahanda kabharina, alabhia kabharimiu. ");
INSERT INTO wlo_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Manga incia bhekupadhencua sagaa-sagaa, sampe siwulumiu ahanda kabharina tee lipuna manga incia bheamembali pewauamiu. ");
INSERT INTO wlo_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Iaku bhekutantuaka tidhana lipumiu minaaka i Tawo Towu Lambe sakawana i Tawona Filistin tee minaaka i tana matuu sakawana i Umala Efrat, roonamo Iaku bhekupasaraakaaka raʼeatina lipu sumai i nuncana limamiu, mamudhaakana ingkomiu upadhencu manga incia minaaka i aroamiu. ");
INSERT INTO wlo_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Bholi ubhoke pojanjia tee manga incia atawa tee manga dewana. ");
INSERT INTO wlo_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Bholi utaroakea manga incia amboore i lipumiu, mamudhaakana manga incia bholi apewau ingkomiu ukodosa i Iaku, roonamo ande ingkomiu usambahea i manga dewana manga incia, dhaanamo sumai amembali katapu to ingkomiu.\" ");
INSERT INTO wlo_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Kasiimpomo Incia afirimani i Musa, \"Penemo poaro tee KAWASANA OPU, ingkoo tee Harun, Nadab tee Abihu, tee 70 mia minaaka i tanga-tangana manga mancuanana Israel, kasiimpo usuju usomba minaaka i karidhoana. ");
INSERT INTO wlo_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Tangkanamo Musa momembalina apasari i KAWASANA OPU, maka manga incia sumai inda amembali apasari, tee uumati sumai uka inda membali apene apobhawa tee incia.\" ");
INSERT INTO wlo_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Kasiimpo Musa alingka i uumati sumai tee apaumbaaka i manga incia bhari-bharia firimanina tee ipatotapuakana KAWASANA OPU. Manga incia alawani apobhawa-bhawa, \"Ingkami bhetapewau sagala giu mopadhana iparintaakana KAWASANA OPU.\" ");
INSERT INTO wlo_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Kasiimpo Musa aburi bhari-bharia firimanina KAWASANA OPU sumai. Samainawana incia abhangu malo-malo, kasiimpo apabhangu saangu tampa tunuana kurubani i aena gunu sumai, tee sapulu rua angu arii mopokanana kabharina tee sapulu rua angua lipuna Israel. ");
INSERT INTO wlo_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Incia atumpu pia-pia mia mangura, minaaka i miana Israel, kasiimpo manga incia uka apasombaaka kurubani tunua tee asumbele manga sapi umane to kurubani pomalape i KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Musa aala sagaa minaaka i raa sumai tee alalia i nuncana manga mangko. Sagaa uka minaaka i raa sumai apasikiakea i tampa tunuana kurubani sumai. ");
INSERT INTO wlo_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Kasiimpo incia aala kitabi pojanjia sumai tee abacea i aroana uumati sumai. Kasiimpo manga incia apogau, \"Bhari-bharia firimanina KAWASANA OPU ingkami bhetapewaua tee tataʼatia.\" ");
INSERT INTO wlo_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Kasiimpo Musa aala raa sumai tee apasikiakea i uumati sumai tee apogau, \"Siimo raa pojanjia ibhokena KAWASANA OPU tee ingkomiu apokana tee sagala firimanina sii.\" ");
INSERT INTO wlo_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Kasiimpo apenemo Musa tee Harun, Nadab tee Abihu, tee 70 mia minaaka i tanga-tangana manga mancuanana Israel. ");
INSERT INTO wlo_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Sapenena, manga incia akamata Aulataʼalana miana Israel. I tambena aena atokamata sala saangu ipewauna mboomo lante minaaka i bhatu nilam. Lante sumai akowaranaa kakanda momainawana mboomo laiana. ");
INSERT INTO wlo_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Moomini manga incia atonto Aulataʼala, Incia inda apabinasa manga kapalana miana Israel sumai. Kasiimpo manga incia uka akande tee asumpu. ");
INSERT INTO wlo_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","KAWASANA OPU afirimani i Musa, \"Penemo poaro tee Iaku i bhawona gunu tee umbooremo iwe sumai. Iaku kuburimo hukumu tee parinta i rua angu katongkana bhatu. Bhekudhawuakako rua angu katongkana bhatu sumai mamudhaakana uadhariaka bhari-bharia antona i manga incia.\" ");
INSERT INTO wlo_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Kasiimpo abhangumo Musa tee Yusak bhatuana. Kasiimpo Musa apepuumo apene i gununa Aulataʼala sumai. ");
INSERT INTO wlo_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Musa apogau i manga mancuana miana Israel sumai, \"Manga aantagi iwe sii sampe ingkami tambuli i ingkomiu. Kamatea, Harun tee Hur apobhawa tee ingkomiu. Ande dhaangia mokoparakarana, lingka i manga incia.\" ");
INSERT INTO wlo_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Kasiimpo apenemo Musa i bhawona Gunu Sinai, tee taʼina ngalu atutubhi gunu sumai. ");
INSERT INTO wlo_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Caheana kamuliana umbaana KAWASANA OPU asapo i bhawona Gunu Sinai, tee taʼina ngalu atutubhi gunu sumai kangengena nama eo. I eo pitu eona, KAWASANA OPU akemba Musa minaaka i nuncana taʼina ngalu sumai. ");
INSERT INTO wlo_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Miana Israel asakusiiaka caheana KAWASANA OPU sumai mboomo waa mopekangauna i bhawona gunu sumai. ");
INSERT INTO wlo_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Musa apesua i tanga-tangana taʼina ngalu tee apene i bhawona gunu sumai, kasiimpo amboore iwe sumai kangengena 40 eo 40 malo. ");
INSERT INTO wlo_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","KAWASANA OPU afirimani i Musa mboo sii, ");
INSERT INTO wlo_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","\"Tumpua miana Israel abhawa pasombaa to Iaku. Incema-incema morelana, tabeana abhawa pasombaa. ");
INSERT INTO wlo_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Ingkoo tabeana utarima to pasombaa hususu manga bara mboo sii: bulawa, pera, tee tambaga; ");
INSERT INTO wlo_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","lenan alusu motounte tee manga kambari waranaa kakanda, wungu, tee maleʼi matuʼa tee buluna bhembe, ");
INSERT INTO wlo_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","kulina dumba umane motowaranaai maleʼi, kulina binata moʼalusu, kau minaaka i puuna kau o sarona \"akasia\", ");
INSERT INTO wlo_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","mina to kanturu, manga rampa mawondu to akarajaaka mina idhupai tee dhupa mawondu; ");
INSERT INTO wlo_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","bhatu tundu o sarona \"krisopras\" tee manga giuna bhatu tundu mulia atopasa i bhaju efod tee katutubhina badana Imamu Maoge. ");
INSERT INTO wlo_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Manga incia tabeana akarajaa tampa mangkilo to Iaku, mamudhaakana Iaku kumboore i tanga-tangana manga incia. ");
INSERT INTO wlo_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Kema tee manga kamondona manga incia tabeana ukarajaaia mboomo isusuakaku to ingkoo.\" ");
INSERT INTO wlo_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","\"Manga incia tabeana akarajaa soronga minaaka i kau akasia, kaaratena 110 senti, kaewana 66 senti, tee kalangana 66 senti. ");
INSERT INTO wlo_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Ingkoo tabeana ulapisiakea i nunca tee i sambali tee bulawa asilii. Karajaakea i bhawona simpi bulawa i sakaaratea bhiwina. ");
INSERT INTO wlo_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Ingkoo tabeana urabuakea bulawa to ukarajaa pata angu simbi. Kasiimpo pasea i pata angua singkuna soronga sumai i aena, rua angu simbi i weta i sawetana tee rua angu simbi i weta mosagaanana. ");
INSERT INTO wlo_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Ingkoo tabeana ukarajaa kau kancodhaa minaaka i kau akasia tee ulapisiakea tee bulawa. ");
INSERT INTO wlo_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Papesuaia rua pale kancodhaa sumai i nuncana manga simbi i rua wetaia soronga sumai, mamudhaakana amembali atosodha. ");
INSERT INTO wlo_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Kau kancodhaa sumai tabeana amboore torosu i nuncana simbina soronga sumai, inda amembali atohobuti minaaka i soronga sumai. ");
INSERT INTO wlo_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Dhikaia i nuncana soronga sumai manga katongkana bhatu iburiakana tee hukumu idhawuakaku to ingkoo. ");
INSERT INTO wlo_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Karajaaia katutubhina soronga sumai minaaka i bulawa asilii, kaaratena 110 senti tee kaewana 66 senti. ");
INSERT INTO wlo_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Karajaaia rua angu patu malaaʼekati kerub minaaka i bulawa itutu, tee dhikaakea sumbesumbere patuna malaaʼekati kerub sumai i bhiwina katutubhina soronga sumai. ");
INSERT INTO wlo_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Saangu patu malaaʼekati kerub ukarajaaia i tapa weta i kaai tee saanguna i tapa weta i kaana katutubhina soronga sumai. I rua angua patu sumai tabeana amembali saangu tee katutubhina soronga sumai. ");
INSERT INTO wlo_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Manga patuna malaaʼekati kerub sumai tabeana aposapoaro i bhawona katutubhina soronga sumai, tee rouna manga apotonto i katutubhi sumai. Rua angua panina minaaka i sala saangu patuna malaaʼekati kerub tabeana atobhakesaka i bhawona katutubhina soronga sumai apoaro i manga panina patuna malaaʼekati kerub mosagaanana, sabutuna atutubhi soronga sumai. ");
INSERT INTO wlo_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Dhikaia rua angu katongkana bhatu hukumu bheidhawuakaku i ingkoo sumai i nuncana soronga tee pasaakea katutubhi i bhawona. ");
INSERT INTO wlo_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","I tampa incia sumai Iaku bhekupokawa tee ingkoo, tee minaaka i bhawona katutubhina sorongana bhatu hukumu, i tanga-tangana rua angu kerub sumai, bhekudhawuko manga parintaku to miana Israel.\" ");
INSERT INTO wlo_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","\"Karajaamo saangu meja minaaka i kau akasia kaaratena 88 senti, kaewana 44 senti, tee kalangana 66 senti. ");
INSERT INTO wlo_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Lapisia o meja sumai tee bulawa asilii, tee ukarajaakea simpi bulawa i sakaaratea bhiwina. ");
INSERT INTO wlo_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Karajaakea satibha dhopi kaewana 7,5 senti i sakaaratea meja sumai tee upasaakea i bhiwina minaaka i bulawa i sakaaratea dhopi sumai. ");
INSERT INTO wlo_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Karajaamo pata angu simbi minaaka i bulawa tee pasamea sumai i pata angua tapana aena, i saripina singkuna. ");
INSERT INTO wlo_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Manga simbi sumai to ataangi kancodhaana mamudhaakana meja sumai amembali atosodha. ");
INSERT INTO wlo_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Kauna kancodhaa sumai tabeana atokarajaa minaaka i kau akasia tee alapisia tee bulawa. ");
INSERT INTO wlo_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Karajaamo manga piri tee tampana tunuana dhupa, tee karajaamo uka manga kandea malobu tee manga bhosu to pasombaana uwena angguru. Bhari-bharia kamondona meja sumai tabeana atokarajaa minaaka i bulawa asilii. ");
INSERT INTO wlo_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Tee ingkoo tabeana udhika roti pasombaa sumai i bhawona meja mamudhaakana sadia adhaangia i aroaku.\" ");
INSERT INTO wlo_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Karajaamo padamara minaaka i bulawa asilii. Aena tee laena tabeana atokarajaa minaaka i bulawa itutu, abhelokiakea tee kamba-kamba tee kancena tee kambana; bhari-bharia sumai tabeana amembali asaangu tee aena tee laena. ");
INSERT INTO wlo_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","I laena sumai tabeana atokarajaa nama angu o rahana, talu raha i saweta-saweta. ");
INSERT INTO wlo_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","I saasaangu rahana tabeana atobheloki tee talu angu kamba-kamba badam tee kancena tee kambana. Mboo sumai uka nama angua rahana motuwuna minaaka i laena padamara sumai. ");
INSERT INTO wlo_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Sainamo i laena padamara sumai tabeana dhaangia pata angu kabheloki siitumo kamba-kamba badam amondo tee kancena tee kambana. ");
INSERT INTO wlo_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","I tambena saasaangu rahana sumai tabeana atokarajaaka saangu kance, mboo sumai uka nama angua rahana motiumbana minaaka i laena padamara sumai. ");
INSERT INTO wlo_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Saangua padamara sumai, malape manga kancena tee manga rahana tabeana atokarajaa minaaka i satumpo bulawa asilii itutu. ");
INSERT INTO wlo_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Karajaamo pitu angu padamara i padamara sumai tee upasea sabutuna o caheana atumpu i aroa. ");
INSERT INTO wlo_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Karajaamo kasupina to upekangkiloaka sumbuna padamara tee lonyorona uka minaaka i bulawa asilii. ");
INSERT INTO wlo_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Pakemo 35 kilo bulawa asilii to ukarajaa padamara tee bhari-bharia kamondona sumai. ");
INSERT INTO wlo_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Jagania mamudhaakana padamara sumai atokarajaa mboomo mopadhana kususuakako i bhawona gunu sii.\" ");
INSERT INTO wlo_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","\"Karajaamo Kema Momangkilo to Iaku sapulu tumpo kae corocoro minaaka i lenan alusu motounte tee manga kambari waranaa kakanda, wungu, tee maleʼi matuʼa. Tumpumea samia ahalii asokaia i corocoro sumai tee gambarana manga malaaʼekati kerub. ");
INSERT INTO wlo_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Bhari-bharia kae corocoro tabeana apokana o kaʼukuruna, kaaratena sapulu rua metere tee kaewana rua metere. ");
INSERT INTO wlo_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Ompuakea lima tumpo kae corocoro sabutuna amembali satuwu kae maoge mboomo pangaawa, karajaaia mboo itu uka lima tumpo kae corocoro mosagaanana. ");
INSERT INTO wlo_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Karajaaia manga talina kuncina minaaka i kae kakanda i bhiwina rua tumpoa kae corocoro maoge sumai i weta i sambali, ");
INSERT INTO wlo_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","kabharina 50 talina kuncina i rua tumpoa kae corocoro maoge sumai. Manga talina kunci sumai tabeana aposapoaro. ");
INSERT INTO wlo_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Karajaaia 50 kakai bulawa. Kasiimpo, upapoompua rua tumpoa kae corocoro maoge Kema Momangkilo sumai saangu tee mosagaanana. Rua-rua tumpoa sumai atopapoompu mboosii: 50 kakai bulawa minaaka i satumpo kae upapesuaia i nuncana 50 talina kunci i kae mosagaanana mamudhaakana amembali asaangu. ");
INSERT INTO wlo_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Karajaaia uka sapulu satumpo kae minaaka i buluna bhembe to apamembalia padhana kema to motutubhina Kema Momangkilo. ");
INSERT INTO wlo_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Satumpo-satumpo kae corocoro sumai tabeana apokana, kaaratena sapulu talu metere tee kaewana rua metere. ");
INSERT INTO wlo_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Ompuakea lima tumpo kae corocoro sabutuna amembali kae maoge mboomo pangaawa, tee akarajaakea nama tumpo kae mosagaanana mboo sumai uka. Kaompu i nama anguna tabeana atolupi amembali rua kaompu i aroana kema sumai. ");
INSERT INTO wlo_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Pasaakea 50 talina kunci i bhiwina kae corocoro maoge mobhaa-bhaana tee 50 talina kunci i bhiwina kae corocoro maoge i tapana saanguna. ");
INSERT INTO wlo_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Karajaakea uka 50 kakai minaaka i tambaga, kasiimpo papesuaakea manga kakai sumai i nuncana manga talina kuncina i saao, sabutuna o Kema Momangkilo apoompu amembali asaangu. ");
INSERT INTO wlo_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Taroakea sagaa minaaka i kae corocoro mokolabhina akaloe-loe i talikuna Kema Momangkilo mamudhaakana atutubhia. ");
INSERT INTO wlo_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Sainamo sumbesumbere i bhiwina Kema Momangkilo, siitumo i rua bhiwina tabeana dhaangia tee labhina akaloe-loe kaewana 50 senti mamudhaakana atutubhia. ");
INSERT INTO wlo_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Tee uka, karajaakea padhana katutubhina Kema Momangkilo minaaka i kulina dumba umane motowaranaai maleʼi. Karajaakea uka padha minaaka i kulina lumba-lumba to atutubhiaka katutubhina kema motokarajaana minaaka i kulina dumba umane sumai. ");
INSERT INTO wlo_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Karajaakea manga toora makate minaaka i kau akasia to manga toorana Kema Momangkilo. ");
INSERT INTO wlo_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Sumbesumbere toora kaaratena 4,5 metere tee kaewana 66 senti. ");
INSERT INTO wlo_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Sapale-sapale toora tabeana dhaangia rua angu kapaso, mopapoompuna manga toora saangu tee kalempesina. Karajaakea giu incia sumai to bhari-bharia toorana Kema Momangkilo. ");
INSERT INTO wlo_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Karajaakea 20 pale toora to bhiwina i weta i salatana Kema Momangkilo ");
INSERT INTO wlo_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","tee karajaaia 40 angu kalempesi pera to apasaakea i tambena 20 pale toora sumai to sandina: rua angu kalempesi i tambena bhari-bharia toora, sumbesumbere to rua kapaso i tambena toora sumai. ");
INSERT INTO wlo_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Karajaakea 20 pale toora to weta i napa i Kema Momangkilo, ");
INSERT INTO wlo_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","amondo tee 40 angu kalempesina perana, rua angu kalempesi i tambena sumbesumbere toora. ");
INSERT INTO wlo_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","To weta i talikuna Kema Momangkilo, sumaimo i weta i bhara, karajaakea nama pale toora. ");
INSERT INTO wlo_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Tee mboo sumai uka karajaakea rua pale toora to singkuna Kema Momangkilo i weta i talikuna. ");
INSERT INTO wlo_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Manga toora sumai tabeana upapoompua minaaka i weta i tambe sakawana i bhawo, tee ubhokeakea simbi. Tee mboo sumai uka tabeana ukarajaakea i rua angua singkuna sumai. ");
INSERT INTO wlo_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Jadi, tabeana dhaangia walu pale toora tee 16 angu kalempesina perana, rua angu kalempesi i tambena saangu toora to sandina. ");
INSERT INTO wlo_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Karajaakea uka manga kau lelea minaaka i kau akasia: lima pale to manga toora i weta i sawetana Kema Momangkilo, ");
INSERT INTO wlo_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","lima pale to i weta mosagaanana, tee lima pale to i talikuna Kema Momangkilo, siitumo i weta i bhara. ");
INSERT INTO wlo_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Kau lelea i tanga-tangana toora sumai tabeana atopasa minaaka i tapa saangu akawa i tapa sagaanana, kalangana satanga toorana sumai. ");
INSERT INTO wlo_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Lapisiakea manga toorana tee uka kau leleana Kema Momangkilo tee bulawa, tee karajaakea manga simbi minaaka i bulawa to tampana papesuaana manga kau leleana sumai. ");
INSERT INTO wlo_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Pakaromea Kema Momangkilo sumai mboomo haejati isusuakaku i ingkoo i bhawona gunu sii. ");
INSERT INTO wlo_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Tumpumea manga mia akarajaa corocoro minaaka i kae lenan alusu motounte tee kambari waranaa kakanda, wungu, tee maleʼi matuʼa. Kasiimpo tumpumea samia ahalii asokaia i corocoro sumai tee gambarana manga malaaʼekati kerub. ");
INSERT INTO wlo_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Loeakea corocoro sumai i pata pale ariina minaaka i kau akasia motolapisiakana tee bulawa, tee ipasa tee manga kakai bulawa. Manga ariina sumai tabeana ataangia i bhawona pata kalempesi perana. ");
INSERT INTO wlo_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Loeakea corocoro sumai i kakai, kasiimpo papesuaia Soronga Pojanjia mokoantona katongkana hukumu i talikuna corocoro sumai. Corocoro sumai apapogaa Kamara Momangkilo minaaka i Kamara Momangkilo Mpuu. ");
INSERT INTO wlo_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","I nuncana Kamara Momangkilo Mpuu sumai dhikaia katutubhina Soronga Pojanjia i bhawona sorongana. ");
INSERT INTO wlo_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Dhikaia meja pasombaa i sambalina corocoro sumai, i weta i napa i nuncana Kema Momangkilo. Dhikaia uka padamara i weta i salata i nuncana Kema Momangkilo, apoaro tee meja sumai. ");
INSERT INTO wlo_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Ingkoo tabeana ukarajaakea uka corocoro to bhambana Kema Momangkilo sumai minaaka i kae lenan alusu motounte tee kambari waranaa kakanda, wungu, tee maleʼi matuʼa. Kasiimpo ubhelokiakea kasokai. ");
INSERT INTO wlo_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Kasiimpo, karajaakea lima pale arii minaaka i kau akasia to corocoro sumai tee lapisiakea tee bulawa. Karajaakea uka manga kakaina minaaka i bulawa, tee laliakea lima kalempesi minaaka i tambaga to kataangina manga ariina sumai. ");
INSERT INTO wlo_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Karajaakea tampa tunuana kurubani minaaka i kau akasia modelena patawala pata singku kaaratena 2,2 metere, kaewana 2,2 metere, tee kalangana 1,3 metere. ");
INSERT INTO wlo_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Ingkoo tabeana utumpu mia akarajaakea manga tanduna i pata angua singkuna. Manga tanduna sumai tabeana asaangu o bhanguna tee tampana tunuana kurubani sumai. Bhari-bharia sumai tabeana atolapisiaka tee tambaga. ");
INSERT INTO wlo_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Karajaakea uka manga parakakasi mboo manga kawali tampana rombusakaana ngawuna, manga kagigisina poluka to apekangkilo tampana tunuana kurubani, manga mangkona to alaliaka manga giu isumpu to pasombaana i bhawona tampa tunuana kurubani, manga garupuuna, tee manga poluka to dhingkanana weona waa, bhari-bharia minaaka i tambaga. ");
INSERT INTO wlo_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Karajaakea tarali, siitumo jala-jala minaaka i tambaga to tampana tunuana kurubani sumai. Kasiimpo karajaakea pata angu simbi tambaga tee pasaakamea i pata angua singkuna jala-jala sumai. ");
INSERT INTO wlo_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Pasaakamea jala-jala sumai i tambe i bhiwina tampana tunuana kurubani, pepuu minaaka i weta i tambe, sampe jala-jala sumai satanga kalangana tampana tunuana kurubani sumai. ");
INSERT INTO wlo_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Karajaakamea rua angu kancodhaa minaaka i kau akasia to tampana tunuana kurubani sumai, kasiimpo lapisia tee tambaga. ");
INSERT INTO wlo_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Papesuaia manga kau kancodhaana i nuncana manga simbi i saao mamudhaakana manga kau kancodhaana sumai adhaangia i rua wetaia bhiwina tampana tunuana kurubani sumai wakutuuna manga mia asodhaaia. ");
INSERT INTO wlo_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Tampana tunuana kurubani sumai ukarajaaia minaaka i dhopi, modelena akolonco, mboo haejati isusuakaku to ingkoo i bhawona gunu sumai. ");
INSERT INTO wlo_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","KAWASANA OPU apogau uka, \"Tumpumea manga mia akarajaa corocoro to abulilingiaka tanalapa i saripina Kema Momangkilo. Corocoro sumai tabeana atokarajaa minaaka i kae lenan alusu motounte. Tondongia o bhiwina i weta i salata i tanalapa sumai tee corocoro kaaratena 44 metere. ");
INSERT INTO wlo_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Tabeana dhaangia 20 pale ariina to aloeaka corocoro sumai tee 20 angu kalempesina, bhari-bharia minaaka i tambaga. Sainamo manga kakai i ariina tee manga papokawaana tabeana minaaka i pera. ");
INSERT INTO wlo_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Karajaakea mboo sumai uka i weta i napa i tanalapa sumai. Bhakesakaakea kae corocoro kaaratena 44 metere, loeakea to 20 pale arii tee 20 kalempesina, bhari-bharia minaaka i tambaga, maka manga kakai i arii tee papokawaana tabeana minaaka i pera. ");
INSERT INTO wlo_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Kaewana bhiwina weta i bhara, bhakesakaakea kae corocoro kaaratena 22 metere, aloeaka corocoro sumai i sapulu pale arii tee sapulu angu kalempesina. ");
INSERT INTO wlo_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Kaewana tidhana weta i timbu 22 metere uka. ");
INSERT INTO wlo_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","15","I weta i timbu i tanalapa sumai, i saripina i kaai tee i kaana tampana bhambana lawa, kaaratena corocoro sumbesumbere 6,6 metere. Loeakea sumbesumbere corocoro sumai i talu pale arii i talu angu kalempesina. ");
INSERT INTO wlo_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Sainamo to bhambana lawa i weta i timbu i tanalapa, tumpumea manga miana akarajaakea corocoro kaaratena 9 metere minaaka i kae lenan alusu motounte, itanuna tee kambari waranaa kakanda, wungu, tee maleʼi matuʼa, tee abhelokiakea kasokai. Corocoro sumai tabeana aloeakea i pata pale arii i pata angua kalempesina. ");
INSERT INTO wlo_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Bhari-bharia arii i saangua tanalapa sumai tabeana apapokawea tee manga papokawaana pera. Manga kakaina uka tabeana minaaka i pera to aloeaka corocoro sumai, sainamo manga kalempesina minaaka i tambaga. ");
INSERT INTO wlo_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Kaaratena tanalapa sumai tabeana 44 metere, kaewana 22 metere, tee kalangana 2,2 metere, tee pagalana kae lenan alusu motounte, tee manga kalempesina minaaka i tambaga. ");
INSERT INTO wlo_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Bhari-bharia parakakasina Kema Momangkilo to faraluuna ibaadati, bhari-bharia patona, tee bhari-bharia patona tanalapa sumai, tabeana atokarajaa minaaka i tambaga. ");
INSERT INTO wlo_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","KAWASANA OPU apogau i Musa, \"Parintaakea miana Israel abhawaakako mina zaitun moʼasiliina mpuu to mopekainawana mamudhaakana sulu sadiamo arore torosu. ");
INSERT INTO wlo_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","I nuncana Kema Pokawaana tee Aulataʼala, Harun tee manga anana umane tabeana moʼurusuna sulu sumai i aroana corocoro mopapogaana Tampa Momangkilo minaaka i Tampa Momangkilo Mpuu, i tampana to adhika Soronga Pojanjia. Manga incia atanggojawapu to ajagani manga sulu mamudhaakana sadia arore torosu samalo-samalo iwe sumai, i aroana umbaaku. Manga miana Israel tabeana ataʼatia katotapu incia sii to saʼumurua.\" ");
INSERT INTO wlo_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","KAWASANA OPU adhawu parinta i Musa, \"Tumpumo mia abhawa Harun, tee manga anana umane, Nadab, Abihu, Eleazar, tee Itamar, i ingkoo. Manga incia sii padhamo kupilia minaaka i tanga-tangana miana Israel to amembali manga imamuku molaianiaku. ");
INSERT INTO wlo_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Tumpumea manga mia akarajaa pakea mangada hususu to Harun tee alaenga apakanea to amembali imamu maoge. ");
INSERT INTO wlo_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Iaku padhamo kudhawuaka kaʼahalii i pia-pia mia. Tumpumea manga incia akarajaa pakea to Harun, tee mboo sumai, ingkoo umembali uhususuaka incia to amembali imamu maoge to Iaku. ");
INSERT INTO wlo_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Siimo tabeana o pakea ikarajaana manga incia: katutubhina bada, bhaju efod, juba maarate, bhaju maarate i nunca isokai, surubani, tee kabhokena tanga minaaka i kae maarate. Manga pakea hususu sumai tabeana akarajaaia manga to Harun, o akamu, tee manga anana umane, tabeana apakanea manga i wakutuuna alaianiaku kumembali imamu. ");
INSERT INTO wlo_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","To akarajaa manga pakea sumai, manga incia tabeana apakeakea kambari bulawa tee lenan alusu, tee manga kambari waranaa kakanda, wungu, tee maleʼi matuʼa. ");
INSERT INTO wlo_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Manga incia tabeana akarajaa bhaju efod minaaka i kae lenan alusu motounte. Kasiimpo bhaju efod sumai asokaia tee kambari waranaa bulawa, kakanda, wungu, tee maleʼi matuʼa. ");
INSERT INTO wlo_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","I bhaju efod sumai tabeana asorumbaakea rua tali katutubhina awaa mopoompuna i rua angu tapana mamudhaakana bhaju efod sumai apoompu. ");
INSERT INTO wlo_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Kabhokena bhaju efod itanu tee kabheloki sumai tabeana apokana atokarajaa tee bhaju efod sumai, siitumo minaaka i kambari bulawa, kakanda, wungu, tee maleʼi matuʼa tee lenan alusu motountena kambarina. ");
INSERT INTO wlo_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Alamo rua angu bhatu tundu isarongiaka krisopras tee ubhelokiakea sarona sapulu rua miaia anana Israel i rua angua bhatu sumai. ");
INSERT INTO wlo_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Bhelokiakea nama saro i saangu bhatu tundu, tee nama sarona uka i bhatu tundu mosagaanana, minaaka i sarona tumpe sakawana i sarona kaepu. ");
INSERT INTO wlo_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Bhelokiakea sarona manga anana Israel i rua angua bhatu tundu sumai mboomo pande tundu mobhelokina capu, kasiimpo bhewengiakea bhatu tundu sumai tee kabhoke bulawa. ");
INSERT INTO wlo_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Dhikamea rua angua bhatu tundu sumai i rua angua katutubhina awaana bhaju efod to tundu kaudhania to audhaniaka manga anana Israel. Harun tabeana abhawa sarona manga incia i aroana KAWASANA OPU i rua angua katutubhina awaana to tanda kaudhania. ");
INSERT INTO wlo_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Karajaakea o kabhoke minaaka i bulawa ");
INSERT INTO wlo_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","tee rua ramba rante minaaka i bulawa asilii, apiia mboomo rabuta. Padha incia sumai, rambana rante motopii sumai abhokeakea tee tundu i saao. ");
INSERT INTO wlo_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Karajaaia katutubhina bada to apogauaka kabhotuki, alaloi limana samia ahalii. Katutubhina bada sumai tabeana akarajaaia mboomo giuna bhaju efod, siitumo minaaka i bulawa, kambari waranaa kakanda, wungu, tee maleʼi matuʼa, tee lenan alusu motounte. ");
INSERT INTO wlo_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Modelena tabeana pata wala pata singku, apotapi rua lapi, 22 senti kaaratena tee kaewana. ");
INSERT INTO wlo_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Pasaakea i katutubhina bada sumai pata tala tundu mopojejerena. Tala bhaa-bhaana akarajaaia minaaka i bhatu aki maleʼi, topas, tee zamrud. ");
INSERT INTO wlo_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","I tala rua anguna akarajaaia minaaka i bhatu pirus kakanda, nilam tee yinta. ");
INSERT INTO wlo_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","I tala talu anguna akarajaaia minaaka i bhatu lazuardi, aki maputi, tee bhatu kecubung. ");
INSERT INTO wlo_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Sainamo tala pata anguna akarajaaia minaaka i bhatu tundu pirus, krisopras, tee giok. Bhari-bharia sumai tabeana abhewengiakea tee kabhoke bulawa. ");
INSERT INTO wlo_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Bhari-bharia bhatu tundu sumai tabeana sapulu rua angu mboomo kabharina sarona anana Israel. Saangu-saangu bhatu sumai tabeana abhelokia mboomo capu tee sarona sala saangu minaaka i sapulu rua angu lipu sumai. ");
INSERT INTO wlo_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","To katutubhina bada sumai tumpua o mia akarajaakea uka rua ramba rante bulawa asilii o bhanguna mboomo tali ipii. ");
INSERT INTO wlo_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Karajaakea uka rua angu simbi minaaka i bulawa, kasiimpo pasaakea i rua angua tapana katutubhina bada sumai. ");
INSERT INTO wlo_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Kasiimpo, apaompuakea rua ramba rante bulawa sumai i rua angua simbi sumai. ");
INSERT INTO wlo_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","I rua angua tapana mosagaanana minaaka i rua ramba rante motounte sumai tabeana upasaakea i rua angua simbina kabhokena tundu i saao mamudhaakana rua angua atopasa i manga kabhokena awaana bhaju efod i weta i aroa. ");
INSERT INTO wlo_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Tumpumea manga incia akarajaa uka rua angu simbi bulawa tee apasaakea i rua angua tapana katutubhina bada i kalapina i weta i nunca mopoarona tee bhaju efod. ");
INSERT INTO wlo_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Karajaakea uka rua angu simbi bulawa tee pasaakea i rua angua katutubhina awaana bhaju efod sumai i weta i tambe, i aroana, i saripina kaompuna, i bhawona kabhokena bhaju efod itanu tee kabheloki. ");
INSERT INTO wlo_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Simbi i katutubhina bada sumai tabeana abhokea i simbina bhaju efod tee tali waranaa kakanda, mamudhaakana katutubhina bada sumai sadhaadhaa i bhawona kabhokena bhaju efod itanu tee kabheloki tee inda atorambasaka minaaka i bhaju efod sumai. ");
INSERT INTO wlo_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Wakutuuna Harun apesua i Tampa Momangkilo, incia tabeana abhawa sarona manga lipuna Israel motobheloki i bhawona bhakena, siitumo i bhawona katutubhina badana to apogauaka kabhotuki, mamudhaakana Iaku, KAWASANA OPU, sadia kuudhani uumatiku. ");
INSERT INTO wlo_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Tumpumo mia to adhika Urim tee Tumim i nuncana katutubhina bada, sabutuna Harun sadia abhawea i bhawona bhakena ande incia aumba apoaro i Iaku. Incia bheapake Urim tee Tumim sumai mamudhaakana amataua opea ipeeluku to lipuna Israel.\" ");
INSERT INTO wlo_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","KAWASANA OPU aparinta Musa, \"Tumpumo mia akarajaa juba maarate to apakea Harun i tambena bhaju efod. Manga incia tabeana akarajaaia saangua minaaka i kae waranaa kakanda. ");
INSERT INTO wlo_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Juba sumai tabeana akobhalo i tanga-tangana to apapesuaaka bhaana. Manga incia tabeana asorumba bhiwina kae itanu i bhiwina bhalo sumai, mamudhaakana kaena inda amabhenci. ");
INSERT INTO wlo_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","I saangua tapana i weta i tambena juba sumai karajaakea kabheloki mboomo bhakena dalima minaaka i kambari kakanda, wungu tee maleʼi matuʼa tee nggiri-nggiri bulawa i tanga-tangana i saangu-saangu bhakena dalima sumai. ");
INSERT INTO wlo_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Pasaakamea mboo sii: saangu nggiri-nggiri bulawa, saangu bhakena dalima, kasiimpo saangu nggiri-nggiri bulawa uka apapoosea tee saangu bhakena dalima, mboo sumai tee mosagaanana i tapana juba sumai. ");
INSERT INTO wlo_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Harun tabeana apake juba sumai wakutuuna incia akapalai ibaadati sababuna inciamo Imamu Maoge. Wakutuuna incia apesua i nuncana Tampa Momangkilo to apoaro i Iaku tee wakutuuna incia alimba, manga nggiri-nggiri maidhiidhi i jubana sumai tabeana atorango, mamudhaakana incia inda amate. ");
INSERT INTO wlo_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Ingkoo uka tabeana utumpu mia akarajaa pita minaaka i bulawa asilii tee abhelokiakea tee manga pogau incia sii, \"Mangkilo to KAWASANA OPU\" i bhawona. ");
INSERT INTO wlo_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Ingkoo tabeana uala tali kakanda tee ubhokeakea pita bulawa sii i weta i aroa surubanina Harun. ");
INSERT INTO wlo_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Harun tabeana sadia apakanea i bhawona rouna. Sii bheasusuaka ande incia atanggojawapu to bhari-bharia dosa ipewauna manga lipuna Israel wakutuuna manga incia adhawuaka pasombaa mangkilo to Iaku, tee Iaku bhekutarimaia pasombaana sumai. ");
INSERT INTO wlo_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Tumpumea manga mia apake kambari lenan alusu to atanu bhaju maarate i nunca tee surubanina Harun. Kabhokena tangana tabeana atosokai tee gambara i bhawona. ");
INSERT INTO wlo_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Karajaa uka pia-pia tuwu bhaju maarate i nunca, kabhokena tangana, tee surubani to manga anana umane Harun. Giu incia sii bheapamembali manga incia atohoromati. ");
INSERT INTO wlo_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Bhari-bharia sumai tabeana upakanaakea to Harun tee manga anana. Kasiimpo, tabeana umina-minaikia manga, ulantia, tee upekangkiloa mamudhaakana manga incia amembali imamu tee amembali alaianiaku. ");
INSERT INTO wlo_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Karajaakea sala to manga incia minaaka i kae lenan to atutubhiaka auratina. Sala sumai tabeana o kaaratena minaaka i tanga sakawana i paa. ");
INSERT INTO wlo_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Harun tee manga anana umane tabeana sadia apakea o pakea incia sumai wakutuuna apesua i nuncana Kema Pokawaana tee Aulataʼala atawa aumba i tampana tunuana kurubani to asambahea tee amembali imamu i Tampa Momangkilo, mamudhaakana manga incia inda aumbaaka kasalaha to karona samia, kasiimpo amate. Sumaimo katotapu motopake saʼumurua to incia tee siwuluna naile itu. ");
INSERT INTO wlo_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Siimo tabeana ipewaumu to upekangkiloaka Harun tee manga anana mamudhaakana manga incia akarajaa tugasina to amembali imamu to Iaku. Alamo sambaa sapi umane mangura tee rua mbaa dumba umane inda tee balacina. ");
INSERT INTO wlo_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Alamo roti inda mokoragi, hole-hole inda mokoragi motojalona tee mina zaitun, tee hole-hole manipi inda mokoragi ijampuaka mina zaitun uka. Bhari-bharia sumai tabeana ukarajaaia minaaka i tarigu momalape. ");
INSERT INTO wlo_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Dhikaia bhari-bharia i nuncana bhaki, kasiimpo pasombaakea apobhawa tee sapi umane tee rua mbaa dumba umane sumai. ");
INSERT INTO wlo_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Kasiimpo tumpumea Harun tee manga anana aumba i bhambana Kema Pokawaana tee Aulataʼala tee bhahomea manga tee uwe. ");
INSERT INTO wlo_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Kasiimpo, alamea pakea imamu sumai tee upakanaakea i Harun bhaju maarate i nunca, juba maarate i tambena bhaju efod, bhaju efod, tee katutubhina bada. Bhokea pekatangka bhaju efod sumai i badana tee kabhokena tangana efod. ");
INSERT INTO wlo_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Pakanaakea surubani i bhaana tee bheweiakea pita bulawa mangkilo motobheloki i surubani sumai. ");
INSERT INTO wlo_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Kasiimpo, alamo mina idhupai to ibaadati, laliakea i bhawona bhaana, tee mina-minaikia incia. ");
INSERT INTO wlo_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Sapadhana incia sumai, bhawea manga anana pekakasu tee upakanaakea bhaju maarate i nunca sumai i manga incia. ");
INSERT INTO wlo_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Bhokeakea kabhokena tanga, siitumo i Harun tee manga anana, tee bheweiakea surubani i bhaana manga. Mboomo sumai tabeana ulanti Harun tee manga anana. Manga incia tee manga siwuluna bheamembali imamu molaianiaku to saʼumurua. ");
INSERT INTO wlo_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Sapadhana incia sumai, bhawamea sapi umane i saao i aroana Kema Pokawaana tee Aulataʼala, kasiimpo Harun tee manga anana tabeana adhika limana i bhawona bhaana sapi umane sumai. ");
INSERT INTO wlo_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Sumbelemea sapi umane i aroana KAWASANA OPU, i aroana bhambana Kema Pokawaana tee Aulataʼala. ");
INSERT INTO wlo_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Kasiimpomo, alea sagaa minaaka i raana sapi umane sumai tee ujampuakea tee kauna limamu i manga tanduna i tampana tunuana kurubani. Laliakea bhari-bharia raa bhilaana i weta i tambena tampana tunuana kurubani sumai. ");
INSERT INTO wlo_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Sapadhana incia sumai, alamo bhari-bharia tabhana motutubhina antona kompona, tapana atena, tee rua mbalia bhaana dhadhina tee tabhana, kasiimpo tunua bhari-bharia i bhawona tampana tunuana kurubani. ");
INSERT INTO wlo_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Maka o dagina sapi umane sumai, kulina, tee karombuna tabeana utunua upepadhaaia i sambalina pokemaa. Siitumo kurubani to ahapusuaka dosana manga imamu. ");
INSERT INTO wlo_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Kasiimpomo alamo sambaa minaaka i dumba umane sumai. Harun tee manga anana tabeana adhika limana manga i bhawona bhaana dumba umane sumai. ");
INSERT INTO wlo_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Sumbelea dumba umane sumai, alea raana, tee pasikiakea i pata singkuna tampana tunuana kurubani sumai. ");
INSERT INTO wlo_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Tumpomo dumba umane sumai pamembalia pia-pia katumpo. Bhanuia antona kompona tee aena, kasiimpo dhikaia bhari-bharia sumai i bhawona bhaana tee manga katumpona sagaanana. ");
INSERT INTO wlo_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Tunua bhari-bharia dumba umane sumai i bhawona tampana tunuana kurubani. Siitumo kurubani itunu motopasombaakana i KAWASANA OPU, momawonduna bhouna i aroana KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Sapadhana incia sumai, alamo sambaapo uka dumba umane, kasiimpo Harun tee manga anana tabeana adhika limana i bhawona bhaana dumba umane sumai. ");
INSERT INTO wlo_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Sumbelea dumba umane sumai, alea sagaa minaaka i raana, tee ujampuakea i tawana talinga kaanana Harun tee manga anana, tee uka i ngangaogena lima kaanana manga tee i ngangaogena ae kaanana. Bhilaana raa sumai tabeana upasikiakea i saangua tampana tunuana kurubani. ");
INSERT INTO wlo_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Kasiimpo alamo saidhe o raana minaaka i tampana tunuana kurubani sumai jaloa tee mina idhupai to ibaadati. Kasiimpo pasikiakea i Harun tee manga anana tee pakeana manga incia uka. Tee mboo sumai, Harun, manga anana, tee pakeana bheamembali amangkilo to Iaku. ");
INSERT INTO wlo_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Minaaka i dumba umane sumai alea uka tabhana, lencina momalompona, tabhana motutubhina antona kompona, tapana atena, rua mbalia bhaana dhadhina tee tabhana, tee paa kaanana roonamo dumba sumai satotuuna dumba umane kurubani to lantiana manga imamu. ");
INSERT INTO wlo_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Minaaka i bhaki mokoantona roti inda mokoragi i aroana KAWASANA OPU alamo uka satumpo roti, satumpo hole-hole minaaka i roti motojalona tee mina, tee satumpo hole-hole manipi. ");
INSERT INTO wlo_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Dhikaia bhari-bharia sumai i randana limana Harun tee manga anana. Kasiimpo manga incia tabeana aangkea bhari-bharia kinande sumai i bhawo to asusuakea ande bhari-bharia sumai adhawuakea to Iaku. ");
INSERT INTO wlo_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Kasiimpo alamea bhari-bharia minaaka i limana manga incia tee tunua i bhawona tampana tunuana kurubani, siitumo i bhawona kurubani tunua, to kurubani mototunu, momawonduna bhouna i aroana KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Sapadhana sumai, alamea randana minaaka i dumba umane kurubani lantiana Harun tee ususuakea i aroana KAWASANA OPU to pasombaa isusuakana. Tee siitumo dhawumu to kinandemu. ");
INSERT INTO wlo_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Pekangkiloa randana pasombaa isusuakana tee paana pasombaa hususu isusuakana i saao minaaka i dumba umane kurubani lantiana Harun tee manga anana. ");
INSERT INTO wlo_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Bhari-bharia sumai amembali dhawuna Harun tee manga anana saʼumurua minaaka i miana Israel, roonamo sumai o pasombaa hususu. Sabutuna tabeana amembali pasombaa hususu minaaka i miana Israel ialana minaaka i kurubani pomalapena manga. Siitumo pasombaa isusuaka to KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Pakeana Harun momangkilona sumai tabeana amembali tinaurakana manga siwuluna naile itu. Manga incia tabeana apakea i wakutuuna atominaki tee atolanti. ");
INSERT INTO wlo_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","O anana mobholosia to amembali imamu tabeana apakea kangenge pitu eo wakutuuna incia apesua i nuncana Kema Pokawaana tee Aulataʼala to apadhaangia ibaadati i Tampa Mangkilo. ");
INSERT INTO wlo_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Alamo dumba umane kurubani lantiana Harun i saao tee nasua dagina i saangu tampa momangkilo. ");
INSERT INTO wlo_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Harun tee manga anana tabeana akande dagina dumba umane sumai tee roti modhaangiana i nuncana bhaki sumai i aroana bhambana Kema Pokawaana tee Aulataʼala. ");
INSERT INTO wlo_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Opea mopadhana ipakena to ahapusu dosana i wakutuuna manga incia atolanti tee atopekangkilo tabeana akandea manga. Mia mosagaanana inda amembali akandea roonamo bhari-bharia sumai amangkilo. ");
INSERT INTO wlo_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Ande i dagina kurubani lantia atawa i roti sumai dhaangia tee labhina sakawana saeona, tunua pepadhaaia bhilaana sumai tee bholi ukandea, roonamo bhari-bharia sumai amangkilo. ");
INSERT INTO wlo_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Mboo sumaimo tabeana upewaua to Harun tee manga anana mboomo bhari-bharia iparintaakaku to ingkoo. Pitu eo kangengena tabeana ulanti manga incia. ");
INSERT INTO wlo_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Saeo-saeo sumbelemo sambaa sapi umane amembali kurubani kahapusuna dosa to upadhaangia pomalape. Pekangkiloa uka tampana tunuana kurubani tee padhaangiaia pomalape to tampana sumai, kasiimpo minakia tampana tunuana kurubani sumai mamudhaakana amangkilo. ");
INSERT INTO wlo_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Padhaangiaia pitu eo kangengena, sabutuna o tampana tunuana kurubani sumai bheamembali amangkilo mpuu, tee mboo sumai incema uka modhingkuna tampana tunuana kurubani sumai bheamembali amangkilo.\" ");
INSERT INTO wlo_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","\"Saeo-saeo to saʼumurua ingkoo tabeana upasombaaka rua mbaa anana dumba mokoʼumuruna satao i bhawona tampana tunuana kurubani sumai. ");
INSERT INTO wlo_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Sambaa to pasombaa saeona, tee sambaana uka to pasombaa wakutuu magaribi. ");
INSERT INTO wlo_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","To anana dumba ipasombaaka saeona, tabeana atokurubaniaka tee sakilo tarigu momalapena mpuu ajaloakea tee salitere mina zaitun asilii. Tee uka laliakea salitere uwena angguru. ");
INSERT INTO wlo_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Sainamo to anana dumba pasombaa i wakutuuna magaribi tabeana atokurubaniaka tee cara mopokana, tee tarigu, mina zaitun tee uwena angguruna. Siitumo kurubani itunu motopasombaakana i KAWASANA OPU, momawonduna bhouna i aroana KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Mboo sumai saʼumurua, pasombaakea saeo-saeo kurubani tunua sumai i aroana KAWASANA OPU, i aroana bhambana Kema Pokawaana tee Aulataʼala. Iwe sumai Iaku bhekupokawa tee ingkomiu, mamudhaakana kufirimani i ingkoo. ");
INSERT INTO wlo_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Iwe sumai uka bhekupokawa tee miana Israel tee kamuliangiku bhekupekangkilo tampana sumai. ");
INSERT INTO wlo_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Iaku bhekupekangkilo Kema Pokawaana tee Aulataʼala tee tampana tunuana kurubani sumai. Harun tee manga anana uka bhekupekangkiloa mamudhaakana manga incia amembali akarajaa tugasina imamu to Iaku. ");
INSERT INTO wlo_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Iaku bhekumboore i tanga-tangana miana Israel, tee bhekumembali Aulataʼalana manga. ");
INSERT INTO wlo_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Sumaimo manga incia bheamataua ande Iakumo KAWASANA OPU, Aulataʼalana manga, mobhawana manga incia alimba minaaka i Tana Mesir, mamudhaakana amembali kumboore i tanga-tangana manga incia. Iakumo KAWASANA OPU, Aulataʼalana manga. ");
INSERT INTO wlo_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","\"Karajaaia tampana minaaka i kau akasia to tunuana dhupa. ");
INSERT INTO wlo_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Modelena tampa sumai pata wala pata singku, kaaratena tee kaewana 45 senti, tee kalangana 90 senti. Manga tanduna tabeana amembali asaangu tee tampana tunuana dhupa sumai. ");
INSERT INTO wlo_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Lapisiakea tee bulawa asilii, malape i bhiwina i bhawo, manga bhiwina sakaaratea tee manga tanduna, kasiimpo karajaakea simpina tee bulawa sakaaratea. ");
INSERT INTO wlo_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","I tambena simpi sumai karajaakea sumbe-sumbere rua mata simbi bulawa i rangkana kau i kaai tee i kaana. Rua pale kancodhaana bheapapesuaia i bhalona manga simbi sumai, mamudhaakana tee kancodhaa incia sumai o tampana tunuana dhupa amembali atosodha. ");
INSERT INTO wlo_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Manga kancodhaana tabeana ukarajaaia minaaka i kau akasia tee ulapisiakea bulawa. ");
INSERT INTO wlo_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Dhikaia tampana tunuana dhupa sumai i aroana corocoro i bhawona Soronga Pojanjia, i aroana katutubhina sorongana sumaimo tampana to ahapusuaka dosa modhaangiana i bhawona rua katongkana bhatu mokoantona hukumu sumai, i tampaku bhekupokawaakako. ");
INSERT INTO wlo_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Saeo-saeo, wakutuuna Harun apekangkilo manga padamara, incia tabeana atunu dhupa mawondu i bhawona tampana tunuana dhupa sumai. ");
INSERT INTO wlo_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Harun tabeana atunu dhupa mawondu sumai sampearopo uka i wakutuuna incia atunu manga padamara i wakutuuna asoomo eo. Giu incia sumai tabeana ingkomiu ukarajaaia sadia i aroana KAWASANA OPU saʼumurua. ");
INSERT INTO wlo_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Bholi upasombaaka i bhawona dhupa mosagaanana, kurubani tunua atawa o pasombaa tarigu, tee bholi ulaliaka pasombaa giuna isumpu i bhawona. ");
INSERT INTO wlo_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Satao sampearo o Harun tabeana apadhaangia to ahapusuaka dosana to tampana tunuana dhupa sumai tee raana kurubani mohapusuna dosa mobhawana kalape tee Aulataʼala i manga tanduna. Giu incia sumai tabeana atopewau satao sampearo saʼumurua. Roonamo tampana tunua dhupa sumai satotuuna o bara momangkilo mpuu to KAWASANA OPU.\" ");
INSERT INTO wlo_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","KAWASANA OPU afirimani i Musa, ");
INSERT INTO wlo_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","\"Wakutuuna atopadhaangia gagariana raʼeatina miana Israel, bhari-bharia umane tabeana apomea doina katolosi i Iaku to karona mamudhaakana incia inda akangkanaia balaa wakutuuna gagariana raʼeati sumai atopadhaangia. ");
INSERT INTO wlo_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Bhari-bharia mia motogagari sumai tabeana apomea doi mboomo katamona ipatotapuaka i Kema Momangkilo, siitumo satanga syikal (katamona syikal sumai sapulu haramu). Bhari-bharia mia tabeana apomea mboomo kabharina doi sumai to pasombaa i Iaku. ");
INSERT INTO wlo_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Bhari-bharia mia mokoʼumuruna alabhi 20 tao tabeana atogagari, tee manga incia tabeana apomea mboomo kabharina doi ipasombaaka hususu to KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Wakutuuna ingkomiu udhawu pasombaa hususu sumai i KAWASANA OPU to mohapusuna dosamiu tee Incia, mia morangkaea bholi apasombaaka akolabhi minaaka i satanga syikal sumai tee mia momisikini bholi apasombaaka akura minaaka i kabhari incia sumai. ");
INSERT INTO wlo_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Enea o doi to mohapusuna dosamiu sumai minaaka i miana Israel tee upakea to ibaadati i nuncana Kema Pokawaana tee Aulataʼala mamudhaakana o giu incia sumai amembali tanda kaudhania to i aroaku, ande ingkomiu padhamo upomea doina katolosi to karomiu. ");
INSERT INTO wlo_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","KAWASANA OPU afirimani i Musa, ");
INSERT INTO wlo_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","\"Karajaamo saangu palangga maoge to pekangkiloana lima tee ae tee kalempesina minaaka i tambaga. Dhikaia o palangga sumai i tanga-tangana Kema Pokawaana tee Aulataʼala tee tampana tunuana kurubani, tee laliakea uwe i nuncana. ");
INSERT INTO wlo_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Iwe sumaimo Harun tee manga anana tabeana abhanui limana tee aena manga. ");
INSERT INTO wlo_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Indapo manga incia apesua i nuncana Kema Pokawaana tee Aulataʼala, manga incia tabeana abhanui limana tee aena tee uwe mamudhaakana manga inda amate. Mboomo uka ande manga incia aumba i tampana tunuana kurubani to apadhaangia ibaadati tee atunu kurubani to KAWASANA OPU, ");
INSERT INTO wlo_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","manga incia tabeana abhanui limana tee aena, mamudhaakana manga inda amate. Katotapu incia sumai atopake saʼumurua to Harun tee manga siwuluna.\" ");
INSERT INTO wlo_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","KAWASANA OPU afirimani i Musa, ");
INSERT INTO wlo_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","\"Alamo manga rampa momalapena mpuu: damar mawondu mokouwe nama kilo, kayu manis talu kilo, tee talu kilo kau mawondu. ");
INSERT INTO wlo_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","Alamo uka kayu manis akasia nama kilo, bhari-bharia atotimbangi tee apakeakea timbanga motopakena i nuncana Kema Momangkilo, tee ranganiakea mina zaitun pata litere. ");
INSERT INTO wlo_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Minaaka i bhari-bharia sumai karajaaia mina idhupai momangkilo, siitumo saangu kajalo molaengana ihasiliakana pande rampa. Kajalo incia sumai tabeana amembali mina idhupai momangkilo. ");
INSERT INTO wlo_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Tee kajalo incia sumai uminaikia o Kema Pokawaana tee Aulataʼala tee Soronga Pojanjia, ");
INSERT INTO wlo_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","meja tee sagala parakakasina, padamara tee sagala parakakasina, tampana tunuana dhupa, ");
INSERT INTO wlo_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","tampana pasombaana kurubani tunua tee sagala parakakasina, tee palangga kapebhahoka tee kalempesina. ");
INSERT INTO wlo_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Pekangkiloa bhari-bharia sumai, sakawana amangkilo mpuu. Opeapo uka modhingkua bheamangkilo. ");
INSERT INTO wlo_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Minakia o Harun tee manga anana tee upekangkiloa manga mamudhaakana amembali akarajaa karajaana amembali imamu to Iaku. ");
INSERT INTO wlo_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Pogauakea i miana Israel mboo sii, 'Siimo mina idhupai momangkilo to Iaku i tanga-tangamiu saʼumurua. ");
INSERT INTO wlo_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Bholi ulaliakea o mina sumai i badana mia mosagaanana ande mencuana imamu tee bholi uka ukarajaa mina mopokanana kajalona. Mina sumai amangkilo tee tabeana uabhia o giu momangkilo. ");
INSERT INTO wlo_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Mia mokarajaana kajalona mina mboo sii atawa ajampuakea i mia inda momembalina imamu tabeana atopadhencu minaaka i tanga-tangana lipuna.' \" ");
INSERT INTO wlo_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","KAWASANA OPU afirimani i Musa, \"Alamea manga rampa momawondu, siitumo polona damar mawondu, kulina kamatuu, tee rasamala, tee uka dhupa moʼasilii, sumbesumbere apokana o kabharina. ");
INSERT INTO wlo_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Minaaka i bhari-bharia sumai karajaamo dhupa ijalo mboomo ikarajaana samia pande mojalona manga rampa, kasiimpo garaia. Dhupa sumai tabeana sadhaadhaana aʼasilii tee amangkilo. ");
INSERT INTO wlo_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Tutumea pekaʼalusua sagaa minaaka i dhupa ijalo sumai tee udhikaia i aroana tampana Soronga Pojanjia i nuncana Kema Pokawaana tee Aulataʼala, tampaku bhekupokawa tee ingkoo. Dhupa itutu tee kajalo moʼalusu sumai tabeana uabhia amangkilo mpuu. ");
INSERT INTO wlo_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Bholi sampeampearo ukarajaa kajalona dhupa mboo sumai to karomu samia. Ingkoo tabeana uabhia mboo saangu giu momangkilo to KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Mia mokarajaana dhupa mboo sumai to abhou bhouna, tabeana atopadhencu minaaka i lipuna.\" ");
INSERT INTO wlo_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","KAWASANA OPU afirimani i Musa, ");
INSERT INTO wlo_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","\"Kamatea, Iaku padhamo kukemba Bezaleel bin Uri bin Hur, minaaka i lipu Yuda. ");
INSERT INTO wlo_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Padhamo kudhawua Rohina Aulataʼala, tee hikimati, kakidha, tee ilimuu; ");
INSERT INTO wlo_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","incia amakidha akarajaa pegiu-giu modele minaaka i bulawa, pera tee tambaga; ");
INSERT INTO wlo_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","incia amakidha abheloki bhatu tundu tee atalea. Incia uka amembali abheloki kau, tee apewau sagala giu karajaa mosagaanana. ");
INSERT INTO wlo_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Iaku uka padhamo kupili mia to apobhawa tee incia, siitumo Aholiab bin Ahisamakh minaaka i lipu Dan. Tee Iaku uka padhamo kudhawua hikimati i nuncana ngangarandana bhari-bharia mia ahalii. Manga incia tabeana apewaua bhari-bharia mopadhana iparintaakaku i ingkoo: ");
INSERT INTO wlo_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Kema Pokawaana tee Aulataʼala, Soronga Pojanjia tee katutubhina i bhawona, siitumo tampana to ahapusuaka dosa, tee sagala parakakasina kema sumai, ");
INSERT INTO wlo_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","siitumo meja tee parakakasina, padamara minaaka i bulawa asilii tee sagala parakakasina, tampana tunuana dhupa, ");
INSERT INTO wlo_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","tampana tunuana kurubani tee sagala parakakasina, palanggana kapebhahoka tee kalempesina, ");
INSERT INTO wlo_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","pakea itanu, siitumo pakea momangkilo to Harun tee manga anana wakutuuna manga incia akarajaa tugasina amembali imamu, ");
INSERT INTO wlo_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","mina idhupai, tee dhupa minaaka i manga rampa mawondu to tampa momangkilo. Manga incia tabeana akarajaaia apokana tee bhari-bharia iparintaakaku i ingkoo.\" ");
INSERT INTO wlo_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","KAWASANA OPU afirimani i Musa, ");
INSERT INTO wlo_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","\"Pogauakea i miana Israel, 'Ingkomiu tabeana uudhania eona Saputuu roonamo siitumo tanda kaudhania i tanga-tangaku tee siwulumiu mamudhaakana ingkomiu umataua Iakumo KAWASANA OPU mopekangkilona ingkomiu. ");
INSERT INTO wlo_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Rampaakanamo sumai, udhania eona Saputuu. Roonamo eona Saputuu satotuuna eo momangkilo to ingkomiu. Incema mopekarombua, dhaanamo atohukumu mate roonamo incemapo uka mokarajaana i eo incia sumai tabeana inyawana atopaila minaaka i tanga-tangana lipuna. ");
INSERT INTO wlo_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Dhaangia nama eo to takarajaa, maka i eo pitu eona satotuuna eo poniuntoa. Ande ukarajaa i eona Saputuu tee inda uraraeaakea, ingkomiu bheutohukumu mate. ");
INSERT INTO wlo_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Sababuna sumai miana Israel tabeana audhania eona Saputuu tee araraeaakea bhari-bharia siwuluna mboomo saangu pojanjia saʼumurua. ");
INSERT INTO wlo_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Eona Saputuu amembali tandana kaudhania i tanga-tangaku tee miana Israel to saʼumurua, roonamo KAWASANA OPU apadhaangia laiana tee alamu kangengena nama eo, tee i eo pitu eona Incia auntomo akarajaa to aponiunto.\" ");
INSERT INTO wlo_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Sapadhana KAWASANA OPU afirimani i Musa i Gunu Sinai, Incia adhawuakea rua angu katongkana bhatu motoburiakana tee hukumuna KAWASANA OPU, siitumo katongkana bhatu iburina karona KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Wakutuuna miana Israel akamata ande o Musa indapo asapo minaaka i gunu sumai, aporomusakamo manga alibu Harun tee apogau, \"Maimo, mangakarajaaka saangu dewa bhemoporiaroaakana ingkami roonamo ingkami inda tamataua opea momembalina tee Musa, mia mangakapalaina talimba minaaka i Tana Mesir sumai.\" ");
INSERT INTO wlo_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Kasiimpo Harun apogau i manga incia, \"Aronia manga dhali-dhali bulawa modhaangiana i talingana bhawinemiu, anamiu umane, tee anamiu bhawine. Bhawea bhari-bharia sumai i iaku.\" ");
INSERT INTO wlo_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Sabutuna, bhari-bharia uumati sumai aaronia manga dhali-dhali bulawa modhaangiana i talingana tee abhawea i Harun. ");
INSERT INTO wlo_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Harun atarimamea bhari-bharia minaaka i limana manga incia, kasiimpo arabua i nuncana pasitaka tee amodelengia amembali sambaa patu anana sapi. Kasiimpomo apogaumo manga mia sumai, \"E miana Israel, siimo dewamiu motondakomiu ulimba minaaka i Tana Mesir!\" ");
INSERT INTO wlo_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Wakutuuna Harun akamata giu incia sumai, incia apabhangumo saangu tampa tunuana kurubani i aroana anana sapi sumai, kasiimpo apogau, \"Naile o eona raraea to KAWASANA OPU!\" ");
INSERT INTO wlo_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Samainawana abhangumo manga, kasiimpo apasombaaka kurubani itunu tee abhawa kurubani pomalape tee Aulataʼala. Uumati sumai auncura to akande tee asumpu, kasiimpo akakaro tee akaunde-unde. ");
INSERT INTO wlo_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","KAWASANA OPU afirimani i Musa, \"Lingkamo, sapomo, roonamo lipu ikapalaimu alimba minaaka i Tana Mesir amadhakimo pewauna. ");
INSERT INTO wlo_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Amadhei mpuu manga incia asaladhala minaaka i opea iparintaakaku. Manga incia akarajaamo sambaa patu anana sapi, kasiimpo asuju asombaia tee apasombaaka kurubani i patu ikarajaana sumai tee apogau, 'E miana Israel, siimo dewamiu, mokapalaikomiu ulimba minaaka i Tana Mesir.' \" ");
INSERT INTO wlo_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Afirimanimo uka KAWASANA OPU i Musa, \"Iaku kumataua ande manga miana lipu sumai amentagali. ");
INSERT INTO wlo_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Roonamo sumai, bholi ucoba uhalangiaku. Iaku kuʼamara, sumaimo manga incia bhekupabinasea. Maka ingkoo tee manga siwulumu bhekupamembalikomiu saangu lipu momaoge.\" ");
INSERT INTO wlo_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Maka o Musa aemani kaasina incana KAWASANA OPU, Aulataʼalana, tee apogau, \"E KAWASANA OPU, pokia Ingkoo uʼamara mpuu i uumatimu, mopadhana ipalimbamu minaaka i Tana Mesir tee kuasa momaoge tee limamu momakaana? ");
INSERT INTO wlo_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Pokia Miana Mesir apogau mboo sumai, 'Incia abhawea manga alimba tee haejati madhaki, to apekamate manga incia i gunu tee apepadhaia minaaka i bhawona alamu'? Sio-siomo uuntomo uʼamara tee upanaindaia haejatimu to upabinasa uumatimu. ");
INSERT INTO wlo_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Udhania tee Ibrahim, Ishak, tee Israel, manga bhatuamu, sababuna Ingkoo padhamo usumpa i manga incia to karomu samia tee padhamo ufirimani i manga incia, 'Iaku bhekupekabharia siwulumiu mboomo kalipopo i laiana. Saangua lipu mopadhana ijanjiakaku sii bhekudhawuakea i siwulumiu, tee manga incia bheakotinaurakaakea to saʼumurua.\" ");
INSERT INTO wlo_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Sabutuna o KAWASANA OPU uka apanaindaia haejatina to apabinasa uumatina. ");
INSERT INTO wlo_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Musa abhalili, kasiimpo asapo minaaka i gunu sumai tee rua angua katongkana bhatu hukumuna Aulataʼala i limana. I rua wetaia katongkana bhatu sumai atoburi, i aroa tee i talikuna. ");
INSERT INTO wlo_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Rua angua katongkana bhatu sumai ikarajaana Aulataʼala tee o kaburina satotuuna minaaka i Aulataʼala, atobheloki i katongkana bhatu sumai. ");
INSERT INTO wlo_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Wakutuuna Yusak arango suarana uumatina sumai asambo-sambo, apogaumo incia i Musa, \"Dhaangia tee karobho potimbea i pokemaa.\" ");
INSERT INTO wlo_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Lawanina Musa, \"Mencuana pekeena manga mia mokanana atawa amatalo i potimbea. Maka, iaku kurango manga incia tangasaana alagu-lagu.\" ");
INSERT INTO wlo_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Mboo sumai incia apasari i pokemaa tee akamata anana sapi sumai tee mia momanari, aʼamaramo mpuu o Musa. Incia arambitaka katongkana bhatu sumai minaaka i limana tee apasakia i aena gunu sumai. ");
INSERT INTO wlo_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Kasiimpo aalamo anana sapi ikarajaana sumai, atunua i nuncana waa. Agilia apekaʼalusua mpuu kasiimpo ajaloa tee uwe. Sapadhana incia sumai, atumpumo miana Israel asumpua. ");
INSERT INTO wlo_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Kasiimpo Musa aabha i Harun, \"Opea ipewauna manga incia i ingkoo, sabutuna uumbaaka dosa momaoge to manga incia?\" ");
INSERT INTO wlo_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Lawanina Harun, \"Bholimo uʼamara tee iaku opuku. Ingkoo umataua ande o lipu incia sii amadhaki pewauna. ");
INSERT INTO wlo_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Manga incia apogau tee iaku, 'Mangakarajaakamo saangu dewa bhemoporiaroaakana ingkami. Ingkami inda tamataua opea momembalina tee Musa, mia mopadhana mokapalaina ingkami talimba minaaka i Mesir.' ");
INSERT INTO wlo_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Kasiimpomo kupogau tee manga incia, 'Incema mokobulawana aronimea.' Manga incia uka adhawuakaakumo. Kasiimpo kutudhaakea i nuncana waa. Sapadhana sumai alimbamo o anana sapi sii.\" ");
INSERT INTO wlo_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Musa amataua ande o Harun ataroaka miana Israel mboomo ajara motorambasakana minaaka i kanda, sabutuna manga incia apotawaikia manga musuna. ");
INSERT INTO wlo_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Rampaakanamo sumai, Musa akakaro i bhambana lawana pokemaa sumai tee apogau, \"Incema moewaakana KAWASANA OPU, uumbamo i Iaku!\" Kasiimpo aporomusakamo bhari-bharia miana Lewi i saripina Musa. ");
INSERT INTO wlo_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Pogaumo Musa i manga incia, \"Mboo siimo firimanina KAWASANA OPU, Aulataʼala isombana miana Israel, 'Ingkomiu samia-samia bhokemea ewanga i tangamiu tee ulipa maimo i saangua pokemaa sumai. Pekamatemea manga witinaimiu, manga sabhangkamiu, tee manga sarimbanuamiu.' \" ");
INSERT INTO wlo_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Miana Lewi apewaua opea ipogauakana Musa. I eo incia sumai amatemo kera-kera 3.000 mia minaaka i tanga-tangana lipu sumai. ");
INSERT INTO wlo_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Kasiimpo Musa apogau, \"Eo sii ingkomiu padhamo uhususuaka karomiu to KAWASANA OPU roonamo samia-samia akurubaniakamo o anana tee witinaina. Tee mboo sumai, Incia adhawukomiu barakati i eo sii.\" ");
INSERT INTO wlo_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Samainawana apogaumo Musa i uumatina lipu sumai, \"Ingkomiu upewaumo dosa maoge. Sii-sii, iaku bhekupangara kupoaro i KAWASANA OPU, incema amataua amembali kupotibhaaka opea iemaniku, siitumo Aulataʼala ahapusu dosamiu sumai.\" ");
INSERT INTO wlo_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Kasiimpo alingkamo o Musa apoaro i KAWASANA OPU tee apogau, \"Uumati sii apewaumo dosa ogena. Manga incia padhamo akarajaa to karona barahala minaaka i bulawa. ");
INSERT INTO wlo_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Sii-sii, maasangia Ingkoo uʼamponia o dosana manga. Maka ande inda, uhapusumea o saroku minaaka i nuncana kitabi mokoantona daftarana manga sarona uumatimu.\" ");
INSERT INTO wlo_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Firimanina KAWASANA OPU i Musa, \"Incema mokodosana i Iaku, inciamo ihapusuku minaaka i nuncana kitabiku. ");
INSERT INTO wlo_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Sii-sii, lingkamo. Bhawamea uumati sumai i tampa mopadhana kusarongiakakomiu. Malaaʼekatiku bheatondakomiu, maka saangu wakutuu bheaumba o eona bhekuhukumu uumati incia sumai roonamo dosana manga. ");
INSERT INTO wlo_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Kasiimpo KAWASANA OPU aumbaaka balaa i manga miana lipu sumai roonamo manga incia apakisaa Harun akarajaa patuna sapi bulawa sumai. ");
INSERT INTO wlo_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","KAWASANA OPU afirimani i Musa, \"Lingkamo minaaka iwe sii, kapalaia uumati mopadhana ibhawamu minaaka i Tana Mesir sumai. Ropemo i lipu mopadhana ijanjiakaku i Ibrahim, Yakub, Ishak, tee siwuluna manga. ");
INSERT INTO wlo_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Iaku bhekulamboko samia malaaʼekati adhala i aroamiu tee Iaku bhekupadhencu miana Kanaan, miana Amori, miana Het, miana Feris, miana Hewi tee miana Yebus. ");
INSERT INTO wlo_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Lingkamo i lipu mosuburu motaralabhi-labhina susu tee golana uwani sumai. Iaku samia inda bhekuumba kupobhawa tee ingkomiu mamudhaakana Iaku inda kupabinasakomiu i tangana dhala, roonamo ingkomiu o lipu momentagali.\" ");
INSERT INTO wlo_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Sarangona lele madhaki sii, asukaramo manga miana lipu sumai. Inda samia uka mopakena agogona. ");
INSERT INTO wlo_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Firimanina KAWASANA OPU i Musa, \"Pogauakea i miana Israel, 'Ingkomiu sii uumati momentagali. Ande Iaku kuumba kupobhawa tee ingkomiu sabantaramea, dhaanamo kupepadhaikomiu. Sii-sii, aronimea agogomiu, Iaku bhekubhotukiakea opea bheipewauku to ingkomiu.' \" ");
INSERT INTO wlo_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Sumaimo, apepuu minaaka i Gunu Horeb sumai miana Israel arambasakamo agogona manga. ");
INSERT INTO wlo_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Musa aala saangu kema mboomo kananea ipewauna, kasiimpo apakaroa i sambalina pokemaa, amaridho minaaka i pokemaa tee asarongiakea \"Kema Pokawaana tee Aulataʼala.\" Jadi, incema uka bhemoabhaakana kaadharina KAWASANA OPU, incia alingka i Kema Pokawaana tee Aulataʼala modhaangiana i sambalina pokemaa sumai. ");
INSERT INTO wlo_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Ande o Musa alingka i kema sumai, bhari-bharia uumati aposakakaro, sumbesumbere i bhambana kemana. Manga incia atonto Musa sampe incia apesua i nuncana kema sumai. ");
INSERT INTO wlo_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Sapesuana Musa i nuncana kema sumai, asapomo taʼina ngalu mboomo arii amakate i aroana bhambana kema. Kasiimpomo Aulataʼala afirimani uka i Musa. ");
INSERT INTO wlo_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Wakutuuna bhari-bharia uumatina lipu sumai akamata ande o taʼina ngalu mboomo arii sumai aunto i aroana bhambana kema sumai, sabutuna bhari-bharia manga abhangu asuju to asomba KAWASANA OPU i bhambana kemana samia-samia. ");
INSERT INTO wlo_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Kasiimpo KAWASANA OPU apogau tee Musa minaaka i kakasuana, mboomo samia mopogauna tee sabhangkana. Sapadhana sumai o Musa ambulimo i pokemaa, maka o Yusak anana Nun, samia anaana umane mohambana Musa, inda abholi kema sumai. ");
INSERT INTO wlo_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Musa apogau i KAWASANA OPU, \"Kumataua Ingkoo motumpuaku to kutonda uumatina lipu sii, maka Ingkoo inda upaumbaakaaku o incema bheilambokomu to mopobhawana tee iaku. Maka Ingkoo uka ufirimani, 'Iaku kumataua o saromu tee Iaku kupeeluko.' ");
INSERT INTO wlo_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Sii-sii, ande atotuu Ingkoo umaasiakaaku, paumbaakaaku manga dhalamu to iaku mamudhaakana kumatauko tee Ingkoo usadhaadhaa umaasiakaaku. Udhania ande o lipu sii uumatimu.\" ");
INSERT INTO wlo_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Kasiimpomo KAWASANA OPU afirimani, \"Karoku bhekuporiaroaakako mamudhaakana amembali upotibhaaka kalalesa mamudhaakana awesa o ngangarandamu.\" ");
INSERT INTO wlo_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Pogauna Musa i Incia, \"Ande Ingkoo inda upobhawa tee ingkami, bholimo utumpu ingkami tabholi tampa incia sii. ");
INSERT INTO wlo_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Ande Ingkoo ulingka upobhawa tee ingkami, bhari-bharia mia bheamataua ande Ingkoo umaasiaka uumatimu tee i iaku. O umbaamu i tanga-tangamami siitumo mopamembalina ingkami taposala tee lipu iapaipo i dunia sii. ");
INSERT INTO wlo_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Firimanina KAWASANA OPU i Musa, \"Giu ipogauakamu sii uka bhekupewaua, sababuna kumaasiakako tee kumatau o saromu.\" ");
INSERT INTO wlo_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Pogauna Musa, \"KAWASANA OPU, patokamataakaaku o kamuliangimu.\" ");
INSERT INTO wlo_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Firimanina, \"Iaku bhekulalo i aroamu mamudhaakana ingkoo ukamatea tapanamo kalapeku. Iaku bhekugoraaka saroku momangkilona, siitumo 'KAWASANA OPU.' Iaku bhekupekalape incaku tee kumaasiaka incemapo uka ipiliku.\" ");
INSERT INTO wlo_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Firimanina uka, \"Ingkoo inda umembali utonto rouku, roonamo inda dhaangia o maanusia motontoaku amembali adhadhi.\" ");
INSERT INTO wlo_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Firimanina KAWASANA OPU, \"Dhaangia saangu tampa i saripiku. Ingkoo umembali ukakaro i tampa incia sumai, i bhawona gunu bhatu. ");
INSERT INTO wlo_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Kasiimpo ande o kamuliangiku alalo, Iaku bhekudhikako i nuncana polotaana gunu bhatu sumai tee Iaku bhekututubhiko tee limaku, sampe kulaloiko. ");
INSERT INTO wlo_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Kasiimpo Iaku bhekuhela limaku tee ingkoo bheukamata talikuku, maka o rouku inda bheatokamata.\" ");
INSERT INTO wlo_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","KAWASANA OPU afirimani i Musa, \"Paatia rua angu katongkana bhatu mboomo i piamo itu, Iaku bhekuburiakea i manga katongkana bhatu sumai sagala firimani modhaangiana i katongkana bhatu mobhaa-bhaana mopadhana ipasakimu. ");
INSERT INTO wlo_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Usiapumo wakutuuna indapo abhete matanaeo tee upenemo saeona mpuu i bhawona Gunu Sinai. Kakaromo upoaro i Iaku iwe sumako, i lolona gunu sumai. ");
INSERT INTO wlo_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Inda samia uka amembali apene tee ingkoo tee inda samia uka amembali atokamata i saangua gunu sumai, tee uka gulumana bhembe dumba tee gulumana sapi uka inda amembali akande rumpu i aena gunu sumai.\" ");
INSERT INTO wlo_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Kasiimpo Musa apaati rua angu katongkana bhatu mboomo i piamo itu. Incia abhangu saeona mpuu tee apene i Gunu Sinai, mboomo iparintaakana KAWASANA OPU i Incia, tee abhawa rua angua katongkana bhatu sumai i limana. ");
INSERT INTO wlo_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","KAWASANA OPU uka aumba i nuncana taʼina ngalu, kasiimpo akakaro iwe sumai i saripina Musa tee agoraaka sarona, Iakumo KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Kasiimpo KAWASANA OPU alalo i aroana tee agora, \"Iakumo KAWASANA OPU, Aulataʼala, Iaku amalape incaku tee kubukeaka kaasina inca, inda amasimba kuʼamara. Iaku kumaasiakea mpuu uumatiku tee kurahumatia manga. ");
INSERT INTO wlo_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Kawasana Opu mopotaangiakana kaasina molagina to i rewu-rewu tapina siwuluna, moʼamponina sala, alapaa, tee dosa, maka sampeampearo inda apabebasi mia mosala minaaka i kahukumu, maka abholosiaka kasalahana ama i manga anana tee opuana, i manga siwuluna talu tapina tee pata tapina. ");
INSERT INTO wlo_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Tee alausakamo Musa aʼungko sampe i tana tee asuju asomba. ");
INSERT INTO wlo_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Incia apogau, \"E Kawasana Opu, ande sii-sii Ingkoo umaasiakaaku, sumaimo umbamo sio-siomo Ingkoo upoose tee upobhawa tee ingkami. Inciamo, lipu sii satotuuna lipu momentagali. Moomini mboo sumai, amponia o sala tee dosamami, tee manga tarimamo tamembali pewauamu.\" ");
INSERT INTO wlo_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Firimanina, \"Mataua, Iaku kubhoke saangu pojanjia. I aroana saangua lipumu sii Iaku bhekupewau manga giu inda momentela indapo mina adhaangia i saangua alamu tee i tanga-tangana bhari-bharia lipu. Saangua lipu, i tanga-tangana mbooresamu, bheasakusiiakea ipewauna KAWASANA OPU, roonamo atomaeka mpuu opea bheipewauku tee ingkoo. ");
INSERT INTO wlo_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Kenia pekatangka opea iparintaakaku i ingkoo i eo sii. Satotuuna, Iaku bhekupadhencua minaaka i aroamu o miana Amori, miana Kanaan, miana Het, miana Feris, miana Hewi, tee miana Yebus. ");
INSERT INTO wlo_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Pengkaanaka, bholi upadhaangia pojanjia tee raʼeatina lipu iumbatimiu sumai, roonamo ande upewaua, manga incia bheamembali katapu i tanga-tangamiu, tee ingkomiu bheuose kananeana manga incia. ");
INSERT INTO wlo_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Jadi, bholimo upewau mboo sumai, maka urunggaia manga tampa tunuana kurubanina tee upahancurua o patu barahalana manga, tee upatobhatea manga ariina Asyera o barahalana manga. ");
INSERT INTO wlo_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Ingkoo inda amembali usuju usomba i dewa mosagaanana roonamo KAWASANA OPU o sarona Kauraura, satotuuna Aulataʼala momendeuna motopapokana tee opeapo uka. ");
INSERT INTO wlo_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Bholi upojanji tee miana lipu incia sumai, roonamo wakutuuna manga incia asomba tee adhawuaka kurubani i barahalana, manga incia bheakembakomiu uposaangu, kasiimpo ingkomiu bheuose to ukande kurubani isumbelena manga, ");
INSERT INTO wlo_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","kasiimpo ingkomiu upakawi anamiu umane tee anana bhawine minaaka i anana manga incia, tee manga anana sumai asomba barahalana lipu sumai, iabhiaku apokana tee apewau zinaa, tee apamembali anamiu umane indamo ataʼatiaku tee o anamiu umane asombamo uka barahalana manga incia sumai. ");
INSERT INTO wlo_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Bholi ukarajaa manga barahala motorabu to usombaia. ");
INSERT INTO wlo_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Sadiamo raraeaakea Eona Raraea Roti Inda Mokoragi. Kangengena pitu eo ingkomiu tabeana ukande roti inda mokoragi mboomo i wakutuu ipatotapuaka i nuncana bula Abib, roonamo i nuncana bula Abib sumaimo ingkoo ulimba minaaka i Mesir. ");
INSERT INTO wlo_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Pewauakumo bhari-bharia mobhaa-bhaana molaahirina minaaka i kadhuma, mboo sumai uka bhari-bharia kadhambaakamu umane, mobhaa-bhaana molaahirina minaaka i sapi atawa o dumba. ");
INSERT INTO wlo_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Anana keledai mobhaa-bhaana molaahiri tabeana utolosia tee sambaa anana dumba. Ande inda utolosia, ingkoo tabeana ukatukia bhorokona. Bhari-bharia anamu umane tumpe tabeana utolosia. Bholi samia uka upoaro i aroaku tee ruambalia limamu. ");
INSERT INTO wlo_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Kangengena nama eo ingkoo tabeana ukarajaa, maka i eo pitu eona ingkoo tabeana uponiunto. I bulaana bhingkunia tee i bulana timpua uka ingkoo tabeana uponiunto. ");
INSERT INTO wlo_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Raraeaakea Eona Raraea Pitu Ahadi, siitumo o Eona Raraea tobhea bhaa-bhaana minaaka i timpuana gandum, mboo sumai uka o Eona Raraea Rombusakaana Hasili i pobholosiana tao. ");
INSERT INTO wlo_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Talu mpearo satao bhari-bharia mia o umane i tanga-tangamiu tabeana aumba asomba Iaku, KAWASANA OPU, Aulataʼala Kawasana Opuna miana Israel. ");
INSERT INTO wlo_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Iaku bhekupadhencu manga lipu minaaka i aroamu tee kupekaewa lipumu. Inda samia uka bhemoalana lipumu wakutuuna ingkoo ulingka upoaro i KAWASANA OPU, Aulataʼalamu, talu mpearo satao. ");
INSERT INTO wlo_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Bholi upasombaaka raa minaaka i kurubani motosumbele to Eona Raraeaku tee giu mokoragi. Kurubani motosumbele i Eona Raraea Paska inda membali akobhilaa sakawana saeona. ");
INSERT INTO wlo_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Bhawea momalapena minaaka i tanamu hasilina timpua bhaa-bhaana i nuncana Baitullana KAWASANA OPU, Aulataʼalamu. Bholi unasu anana bhembe tee uwena susuna inana.\" ");
INSERT INTO wlo_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","KAWASANA OPU afirimani i Musa, \"Buria sagala firimani incia sii, roonamo minaaka i firimani incia sii Iaku padhamo kupojanji tee ingkoo tee miana Israel.\" ");
INSERT INTO wlo_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Pata pulu eo pata pulu malo kangengena Musa iwe sumai apobhawa tee KAWASANA OPU, kangenge incia sumai inda akande roti tee inda asumpu uwe. Aulataʼala aburia i bhawona manga katongkana bhatu sumai firimani pojanjiana, sumaimo Sapulu Firimani. ");
INSERT INTO wlo_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Wakutuuna Musa asapo minaaka i Gunu Sinai apoose abhawa rua angu katongkana bhatu hukumuna Aulataʼala i limana, Musa inda amataua ande o rouna akocahea roonamo incia padhamo apogau tee Aulataʼala. ");
INSERT INTO wlo_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Wakutuuna Harun tee miana Israel akamata Musa, atokamatamo i rouna akocahea, sabutuna manga incia amaeka apekakasu i Musa. ");
INSERT INTO wlo_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Maka o Musa agoraakamo manga incia, kasiimpo o Harun tee bhari-bharia kapalana i tanga-tangana jamaʼa sumai apasari i incia. Kasiimpo Musa apogau i manga incia. ");
INSERT INTO wlo_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Sapadhana incia sumai, bhari-bharia miana Israel akasuimo incia, kasiimpomo Musa apakawaakea i manga incia bhari-bharia ifirimaniakana KAWASANA OPU to incia i bhawona Gunu Sinai. ");
INSERT INTO wlo_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Sapadhana apogau i manga incia, Musa atutubhimo rouna. ");
INSERT INTO wlo_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Maka, wakutuuna Musa apoaro i KAWASANA OPU to apogau tee Incia, abungkalemea o katutubhina rouna sumai sampe incia alimba. Salimbana, incia apogaumo tee miana Israel tee opea iparintaakana KAWASANA OPU to incia, ");
INSERT INTO wlo_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","tee o miana Israel akamata rouna Musa akocahea. Kasiimpomo, Musa uka atutubhia pendua o rouna sakawana incia apesua uka to apogau tee KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Musa aromusaka bhari-bharia jamaʼana miana Israel tee apogau i manga incia, \"Siimo manga giu iparintaakana KAWASANA OPU mamudhaakana atopewau. ");
INSERT INTO wlo_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Nama eo kangengena karajaa amembali upewaua, maka i eo pitu eona satotuuna o eo momangkilo to ingkomiu, siitumo eona Saputuu, eo uponiunto saeoa ihususuaka to KAWASANA OPU. Incema uka mokarajaana i eo incia sumai incia tabeana ahukumu matea. ");
INSERT INTO wlo_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Bholi upakata waa i saangua tampana mbooresamiu i eona Saputuu.\" ");
INSERT INTO wlo_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Musa apogau i bhari-bharia jamaʼana miana Israel, \"Siimo giu iparintaakana KAWASANA OPU, ");
INSERT INTO wlo_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Bhawamo pasombaa hususu minaaka i pewauamu to KAWASANA OPU. Incema morelana totona incana tabeana abhawa pasombaa hususu to Aulataʼala, siitumo bulawa, pera tee tambaga, ");
INSERT INTO wlo_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","kambari waranaa kakanda, wungu, tee maleʼi matuʼa, kae lenan alusu, buluna bhembe, ");
INSERT INTO wlo_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","kulina dumba umane motowaranaai maleʼi, kulina lumba-lumba, kau akasia, ");
INSERT INTO wlo_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","mina to kainawa, rampa-rampa to mina idhupai tee dhupa mawondu, ");
INSERT INTO wlo_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","tee bhatu tundu krisopras tee manga tundu mototalana i bhaju efod tee katutubhina bada.\" ");
INSERT INTO wlo_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","\"Bhari-bharia mia moʼahalii i tanga-tangamiu tabeana aumba to akarajaaka bhari-bharia iparintaakana KAWASANA OPU: ");
INSERT INTO wlo_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Kema Momangkilo, kema tee katutubhina, manga kakaina, manga toorana, manga kau leleana, manga ariina bhamba tee manga kalempesina; ");
INSERT INTO wlo_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Soronga Pojanjia tee rua pale kancodhaana, katutubhina sorongana to ahapusuaka dosa, tee corocoro katutubhina; ");
INSERT INTO wlo_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","meja tee rua pale kancodhaana, bhari-bharia parakakasina, tee roti pasombaa; ");
INSERT INTO wlo_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","padamara to kainawa tee parakakasina, suluna, tee mina to kainawa; ");
INSERT INTO wlo_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","tampa tunuana dhupa tee rua pale kancodhaana, mina idhupai tee dhupa mawondu; corocoro to bhambana Kema Momangkilo; ");
INSERT INTO wlo_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","tampana tunuana kurubani tee jala-jala tambagana, rua pale kancodhaana tee bhari-bharia parakakasina, palangga kapebhahoka tee kalempesina; ");
INSERT INTO wlo_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","manga corocoro to abulilingiaka tanalapa i saripina Kema Momangkilo, manga ariina, manga kalempesina, tee corocorona bhambana lawana tanalapa; ");
INSERT INTO wlo_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","manga patona Kema Momangkilo tee patona tanalapa tee manga rabutana; ");
INSERT INTO wlo_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","pakea moʼalusu itanu to apadhaangiaaka ibaadati i tampa momangkilo, pakea momangkilo to imamu Harun, tee pakeana manga anana to akarajaaka tugasina amembali imamu.\" ");
INSERT INTO wlo_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Kasiimpo, alingkamo bhari-bharia jamaʼana miana Israel minaaka i aroana Musa. ");
INSERT INTO wlo_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Sapadhana incia sumai, aumbamo bhari-bharia mia mopeeluna tee morelana totona incana abhawa pasombaa hususu i KAWASANA OPU to akarajaa Kema Pokawaana tee Aulataʼala, to saangua ibaadatina, tee pakea momangkilo. ");
INSERT INTO wlo_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Bhari-bharia morelana totona incana malape umane atawa bhawine aumba abhawa dhali-dhalina ango, dhali-dhalina talinga, singkaru, tee simbina limana, sagala giu bulawa to pasombaa hususu isusuakana i KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Tee uka sumai, bhari-bharia mia mokokambarina waranaa kakanda, wungu, tee maleʼi matuʼa, lenan alusu, buluna bhembe, kulina dumba umane motowaranaai maleʼi, tee kulina lumba-lumba, aumba abhawea. ");
INSERT INTO wlo_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Bhari-bharia mia mopasombaakana pasombaa hususu minaaka i pera atawa o tambaga abhawea i KAWASANA OPU, tee bhari-bharia mia mokokauna akasia aumba uka abhawea to akarajaaka manga bara ibaadati, ");
INSERT INTO wlo_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Bhari-bharia bhawine moʼahaliina mountena kambari tee limana karona, aumba abhawa bara iuntena, siitumo kambari waranaa kakanda, wungu, tee maleʼi matuʼa, tee lenan alusu. ");
INSERT INTO wlo_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Manga incia arela totona incana aunte kambari minaaka i buluna bhembe. ");
INSERT INTO wlo_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Manga kapala abhawa bhatu tundu krisopras tee manga tundu mototalana i bhaju efod tee katutubhina bada, ");
INSERT INTO wlo_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","manga rampa tee mina to kainawa, to mina idhupai tee dhupa mawondu. ");
INSERT INTO wlo_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Bhari-bharia umane tee bhawine morelana totona incana abhawa opeopeapo uka to bhari-bharia karajaa iparintaakana KAWASANA OPU alaloi Musa. Miana Israel aumba abhawea bhari-bharia to pasombaa kadhawu i KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Musa apogau i miana Israel, \"Kamatea, KAWASANA OPU padhamo akemba Bezaleel bin Uri bin Hur, minaaka i lipu Yuda. ");
INSERT INTO wlo_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","KAWASANA OPU padhamo adhawu Rohina Aulataʼala i Bezaleel tee adhawua hikimati, kakidha, tee ilimuu. ");
INSERT INTO wlo_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Mamudhaakana incia amembali akarajaa pegiu-giu modele minaaka i bulawa, pera, tee tambaga, ");
INSERT INTO wlo_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","kabhelokina bhatu tundu to atalea, tee abhelokiakea kau, mamudhaakana incia amembali akarajaaia bhari-bharia ihaejatiakana sumai. ");
INSERT INTO wlo_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","I nuncana ngangarandana, Aulataʼala padhamo arahumatiakea kakidha to aadhariaka manga mia mosagaanana, mboo sumai uka i nuncana ngangarandana Aholiab bin Ahisamakh minaaka i lipu Dan. ");
INSERT INTO wlo_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","KAWASANA OPU uka abarakati manga mia incia sumai tee hikimati to akarajaa bhari-bharia karajaana pande, karajaana moʼahaliina, karajaana mosokaina kambari waranaa kakanda, wungu, tee maleʼi matuʼa, tee kae lenan alusu, tee karajaana pande tanu. Jadi, manga incia satotuuna mokarajaana bhari-bharia giuna ikarajaa. ");
INSERT INTO wlo_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","KAWASANA OPU padhamo adhawu hikimati tee kakidha i Bezaleel, Aholiab, tee bhari-bharia pande mosagaanana. Manga incia bhari-bharia satotuuna manga ahalii ifaraluuna to akarajaa sagala giu karajaa to apabhangu Kema Momangkilo. Manga incia tabeana akarajaaia tee aose opea mopadhana iparintaakana KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Kasiimpomo Musa akemba Bezaleel, Aholiab, tee bhari-bharia moʼahaliina, i nuncana ngangarandana padhamo adhawua KAWASANA OPU tee hikimati, siitumo bhari-bharia mia morelana totona incana to aumba apewau o karajaa sumai. ");
INSERT INTO wlo_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Musa apasaraaka i manga incia bhari-bharia giu mopadhana idhawuakana manga miana Israel sumai to apakaro Kema Momangkilo. Maka manga miana lipu sumai torotorosu arela abhawa kadhawuna manga i Musa saesaeo. ");
INSERT INTO wlo_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Sabutuna aumbamo bhari-bharia ahalii mopewauna bhari-bharia karajaa i Kema Momangkilo sumai, samia-samia minaaka i karajaana. ");
INSERT INTO wlo_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Manga incia apogau i Musa, \"Manga giu ibhawana raʼeati sumai abharimo mpuu. Akolabhimo minaaka i ifaraluumami to takarajaa opea mopadhana iparintaakana KAWASANA OPU.\" ");
INSERT INTO wlo_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Kasiimpo Musa adhawu parinta mamudhaakana apakoleleakea i saangua pokemaa sumai, \"Bholi dhaangia o umane atawa o bhawine mokarajaana opeapo uka to apamembalia pasombaa hususu to Kema Momangkilo.\" Tee mboo sumai, raʼeati asasia to abhawa pasombaa uka. ");
INSERT INTO wlo_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Roonamo kamondo ifaraluuna to apewau bhari-bharia karajaana sumai akawamo, indamo afaraluu atorangani uka. ");
INSERT INTO wlo_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Kasiimpo bhari-bharia ahalii i tanga-tangana manga pande mokarajaana Kema Momangkilo sumai akarajaa sapulu tumpo kae corocoro minaaka i lenan alusu motounte tee kambari waranaa kakanda, wungu, tee maleʼi matuʼa, amondo tee manga kasokaina malaaʼekati kerub, i karajaana samia ahalii. ");
INSERT INTO wlo_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Bhari-bharia kae corocoro apokana kaʼukuruna, kaaratena sapulu rua metere tee kaewana rua metere. ");
INSERT INTO wlo_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Lima tumpo kae sumai apapoompua amembali saangu kae maoge mboomo pangaawa, mboo sumai uka tee lima tumpo kae mosagaanana. ");
INSERT INTO wlo_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Manga incia akarajaa manga talina kuncina minaaka i kae kakanda i bhiwina rua tumpoa kae corocoro maoge sumai i weta i sambali, ");
INSERT INTO wlo_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","50 talina kunci i kae saanguna tee 50 talina kunci i bhiwina kae i rua anguna. Manga talina kunci sumai apapoaroa. ");
INSERT INTO wlo_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Sapadhana sumai, manga incia akarajaa 50 kakai bulawa tee apapoompua i manga kakaina Kema Momangkilo sumai saangu tee mosagaanana tee manga kakai incia sumai sabutuna amembali apaposaangua. ");
INSERT INTO wlo_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Sapadhana incia sumai, manga incia uka akarajaa sapulu satumpo kae minaaka i buluna bhembe to apamembalia padhana to motutubhina Kema Momangkilo. ");
INSERT INTO wlo_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Kaaratena satumpo-satumpo kae sumai apokana o kaogena, siitumo o kaaratena sapulu talu metere tee o kaewana rua metere. ");
INSERT INTO wlo_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Kasiimpo manga incia apapoompuaka lima tumpo kae sumai amembali saangu pangaawa, tee nama tumpo kae mosagaanana amembali saangu pangaawa uka. ");
INSERT INTO wlo_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Manga incia akarajaa 50 talina kunci i bhiwina kae corocoro bhaa-bhaana, tee 50 talina kunci i bhiwina kae corocoro rua anguna. ");
INSERT INTO wlo_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Kasiimpo manga incia akarajaa 50 kakai tambaga to apapompu manga kae sumai amembali asaangu. ");
INSERT INTO wlo_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Sapadhana incia sumai, manga incia akarajaa uka to kema sumai katutubhina minaaka i kulina dumba umane motowaranaai maleʼi, tee katutubhina minaaka i kulina lumba-lumba to atutubhiaka katutubhina kema motokarajaana minaaka i kulina dumba umane sumai. ");
INSERT INTO wlo_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Kasiimpomo minaaka i kau akasia manga incia akarajaa manga toora makate to Kema Momangkilo. ");
INSERT INTO wlo_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Sapale-sapale toora kaaratena 4,5 metere tee kaewana 66 senti. ");
INSERT INTO wlo_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Sapale-sapale toora akarajaakea rua angu kapaso to mopapoompuna manga toora tee rua angu kalempesina. Incia akarajaa mboo sumai to bhari-bharia toorana Kema Momangkilo. ");
INSERT INTO wlo_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","To bhiwina i weta i salata Kema Momangkilo, manga incia akarajaakea 20 toora. ");
INSERT INTO wlo_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Manga incia uka akarajaa 40 kalempesi pera to apasaakea i tambena 20 pale toora sumai, rua kalempesi i tambena sapale-sapale toora, saasaangu to rua angua kapasona. ");
INSERT INTO wlo_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","To Kema Momangkilo i weta i napa akarajaakea 20 pale toora ");
INSERT INTO wlo_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","amondo tee 40 kalempesina perana, rua angu kalempesi i tambena saasaangu toora. ");
INSERT INTO wlo_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","To i weta i talikuna Kema Momangkilo, siitumo i weta i bhara, manga incia akarajaakea nama pale toora. ");
INSERT INTO wlo_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Manga incia uka akarajaakea rua pale toora to i weta i singku i talikuna Kema Momangkilo sumai. ");
INSERT INTO wlo_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Rua palea toora sumai apapoompua minaaka i weta i tambe sakawana i bhawo, tee abhokeakea simbi. Mboo sumaimo rua angua toora to rua angua singkuna sumai akarajaaia manga. ");
INSERT INTO wlo_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Jadi, dhaangia walu pale toora amondo tee 16 kalempesina perana, rua angu kalempesina i tambena saasaangu toora. ");
INSERT INTO wlo_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Manga incia uka akarajaa manga kau lelea minaaka i kau akasia, lima pale to manga toora i weta i sawetana Kema Momangkilo, ");
INSERT INTO wlo_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","lima pale to manga toora i weta i sawetana mosagaanana, tee lima pale kau lelea to manga toora i weta i talikuna Kema Momangkilo, siitumo i weta i bhara. ");
INSERT INTO wlo_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Kau lelea i tanga-tangana toora sumai atopasa minaaka i tapa saangu akawa i tapa sagaanana, kalangana satanga toorana sumai. ");
INSERT INTO wlo_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Kasiimpo manga incia alapisiaka manga toora sumai tee bulawa tee akarajaa manga simbi minaaka i bulawa to tampana papesuaana kau lelea sumai. Manga kau lelea sumai manga incia alapisiakea uka tee bulawa. ");
INSERT INTO wlo_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Sapadhana sumai, manga incia akarajaa corocoro minaaka i kae lenan alusu motountena tee kambari waranaa kakanda, wungu, tee maleʼi matuʼa, asokaia i corocoro sumai tee gambarana manga malaaʼekati kerub, ikarajaana samia ahalii. ");
INSERT INTO wlo_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","To corocoro sumai manga incia akarajaa pata pale arii minaaka i kau akasia motolapisiakana tee bulawa. Manga incia uka akarajaa manga kakai bulawa to arii sumai, tee arabuaka pata kalempesina pera. ");
INSERT INTO wlo_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Kasiimpomo manga incia akarajaa corocorona to bhambana kema sumai minaaka i kae lenan alusu motountena tee kambari waranaa kakanda, wungu, tee maleʼi matuʼa, abhelokiakea kasokai. ");
INSERT INTO wlo_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","To corocorona sumai akarajaakea lima pale arii amondo tee kakaina. Manga incia alapisi lolona tee papokawaana lima pale arii sumai tee bulawa, sainamo lima kalempesina akarajaaia minaaka i tambaga. ");
INSERT INTO wlo_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Bezaleel akarajaa Soronga Pojanjia minaaka i kau akasia, 1,1 metere kaaratena, 66 senti kaewana, tee 66 senti kalangana. ");
INSERT INTO wlo_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Alapisia i nunca tee i sambali tee bulawa asilii, tee akarajaakea i bhawona tee simpi bulawa sakaaratea. ");
INSERT INTO wlo_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Incia arabuakea bulawa to akarajaa pata angu simbi. Kasiimpo apasea i pata angua singkuna soronga sumai i aena, rua angu simbi i weta i sawetana tee rua angu simbi i weta mosagaanana. ");
INSERT INTO wlo_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Kasiimpo, incia akarajaa rua pale kancodhaa minaaka i kau akasia, tee alapisia tee bulawa. ");
INSERT INTO wlo_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Apapesuaia rua pale kancodhaa sumai i nuncana manga simbi i rua wetaia soronga sumai mamudhaakana amembali atosodha. ");
INSERT INTO wlo_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Kasiimpomo, incia akarajaa katutubhina soronga, siitumo tampana to ahapusuaka dosa, minaaka i bulawa asilii, 1,1 metere kaaratena tee kaewana 66 senti. ");
INSERT INTO wlo_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Akarajaakea uka rua angu patu malaaʼekati kerub minaaka i bulawa itutu i rua angua tapana katutubhina sorongana to ahapusuaka dosa. ");
INSERT INTO wlo_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Saangu patu malaaʼekati kerub akarajaaia i tapa weta i kaai tee saanguna i tapa weta i kaana katutubhina soronga sumai. I rua angua patu sumai amembali saangu tee katutubhina soronga sumai. ");
INSERT INTO wlo_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Manga patuna malaaʼekati kerub sumai aposapoaro i bhawona katutubhina soronga sumai, tee rouna manga apotonto i katutubhi sumai. Rua angua panina minaaka i sala saangu patuna malaaʼekati kerub atobhakesaka i bhawona katutubhina soronga sumai apoaro i manga panina patuna malaaʼekati kerub mosagaanana, sabutuna atutubhi soronga sumai. ");
INSERT INTO wlo_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Akarajaakea uka saangu meja minaaka i kau akasia kaaratena 88 senti, kaewana 44 senti, tee kalangana 66 senti. ");
INSERT INTO wlo_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Alapisia o meja sumai tee bulawa asilii, tee akarajaakea simpi bulawa i sakaaratea bhiwina. ");
INSERT INTO wlo_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Sapadhana sumai, akarajaakea satibha dhopi kaewana 7,5 senti i sakaaratea meja sumai tee apasaakea i bhiwina minaaka i bulawa i sakaaratea dhopi sumai. ");
INSERT INTO wlo_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","To meja sumai, akarajaakea pata angu simbi bulawa, tee apasaakea simbi i pata angua tapana aena meja sumai, i saripina singkuna, ");
INSERT INTO wlo_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","aposari tee sakaaratea i bhiwina i saao. Manga simbi sumai to ataangi kancodhaana mamudhaakana meja sumai amembali atosodha. ");
INSERT INTO wlo_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Sapadhana incia sumai, akarajaakea rua pale kancodhaa minaaka i kau akasia tee alapisiakea bulawa mamudhaakana meja sumai amembali atosodha. ");
INSERT INTO wlo_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Akarajaakea uka manga parakakasina motodhikana i bhawona meja, siitumo manga piri tee manga tampana tunuana dhupa, tee karajaamo uka manga kandea malobu tee manga bhosu to pasombaana uwena angguru. Bhari-bharia sumai atokarajaa minaaka i bulawa asilii. ");
INSERT INTO wlo_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Kasiimpomo, akarajaakea padamara minaaka i bulawa asilii. Aena tee laena akarajaaia minaaka i bulawa itutu, abhelokiakea tee kamba-kamba tee kancena tee kambana; bhari-bharia sumai amembali asaangu tee aena tee laena. ");
INSERT INTO wlo_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","I laena sulu sumai atokarajaa nama angu o rahana, talu raha i saweta-saweta. ");
INSERT INTO wlo_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","I saasaangu rahana atobheloki tee talu angu kamba-kamba badam tee kancena tee kambana. Mboo sumai uka nama angua rahana motuwuna minaaka i laena padamara sumai. ");
INSERT INTO wlo_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Sainamo i laena padamara sumai adhaangia pata angu kabheloki siitumo kamba-kamba badam amondo tee kancena tee kambana. ");
INSERT INTO wlo_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","I tambena saasaangu rahana sumai atokarajaaka saangu kance, mboo sumai uka nama angua rahana motiumbana minaaka i laena padamara sumai. ");
INSERT INTO wlo_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Saangua padamara sumai, malape manga kancena tee manga rahana atokarajaa minaaka i satumpo bulawa asilii itutu. ");
INSERT INTO wlo_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Akarajaaia uka pitu angu padamara i padamara sumai tee kasupina to upekangkiloaka sumbuna padamara tee lonyorona uka minaaka i bulawa asilii. ");
INSERT INTO wlo_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Padamara tee bhari-bharia kamondona sumai akarajaaia minaaka i 35 kilo bulawa asilii. ");
INSERT INTO wlo_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Sapadhana incia sumai, Bezaleel akarajaa tampana tunuana dhupa minaaka i kau akasia. Modelena tampa sumai pata wala pata singku, kaaratena tee kaewana 45 senti, tee kalangana 90 senti. Manga tanduna asaangu tee tampana tunuana dhupa sumai. ");
INSERT INTO wlo_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Alapisia bhari-bharia tee bulawa asilii, malape i bhiwina i bhawo, manga bhiwina sakaaratea tee manga tanduna, kasiimpo akarajaakea simpina tee bulawa sakaaratea. ");
INSERT INTO wlo_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","I tambena simpi sumai akarajaakea sumbe-sumbere rua mata simbi bulawa i rangkana kau i kaai tee i kaana. Rua pale kancodhaana bheapapesuaia i bhalona manga simbi sumai, mamudhaakana tee kancodhaa incia sumai o tampana tunuana dhupa amembali atosodha. ");
INSERT INTO wlo_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Sainamo to manga kancodhaana atokarajaa minaaka i kau akasia, kasiimpo alapisia tee bulawa. ");
INSERT INTO wlo_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Akarajaaia uka mina idhupai momangkilo tee dhupa moʼasilii minaaka i manga rampa momawondu, mboomo karajaana samia pande rampa. ");
INSERT INTO wlo_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Bezaleel akarajaa tampa tunuana kurubani minaaka i kau akasia modelena patawala pata singku kaaratena 2,2 metere, kaewana 2,2 metere, tee kalangana 1,3 metere. ");
INSERT INTO wlo_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Akarajaaia manga tanduna i pata angua singkuna, asaangu o bhanguna tee tampana tunuana kurubani sumai, kasiimpo alapisiakea tee tambaga. ");
INSERT INTO wlo_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Incia uka akarajaa bhari-bharia parakakasina tampana tunuana kurubani, siitumo manga kawali tampana rombusakaana ngawuna, manga kagigisina poluka to apekangkilo tampana tunuana kurubani, manga mangkona to alaliaka manga giu isumpu to pasombaana i bhawona tampa tunuana kurubani, manga garupuuna, tee manga poluka to dhingkanana weona waa, bhari-bharia minaaka i tambaga. ");
INSERT INTO wlo_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Kasiimpomo, apasaakea tarali, siitumo jala-jala minaaka i tambaga, i tampana tunuana kurubani sumai i tambe i bhiwina, pepuu minaaka i weta i tambe sampe jala-jala sumai satanga kalangana tampana tunuana kurubani sumai. ");
INSERT INTO wlo_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Akarajaaia pata mata simbi to apasaakea i pata angua singkuna jala-jala tambaga sumai to tampana apapesuaaka rua pale kancodhaana. ");
INSERT INTO wlo_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Kasiimpo, akarajaakea manga kancodhaa minaaka i kau akasia tee alapisiakea tee tambaga. ");
INSERT INTO wlo_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Sapadhana incia sumai, apapesuaakea manga kau kancodhaa sumai i nuncana manga simbi modhaangiana i rua wetaia i tampana tunuana kurubani sumai mamudhaakana amembali atosodha. Tampana tunuana kurubani sumai atokarajaa minaaka i dhopi, modelena akolonco. ");
INSERT INTO wlo_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Bezaleel uka akarajaa palangga maoge tampana uwe to pekangkiloana lima tee ae tee kalempesina minaaka i tambaga. Tambaga sumai apotibhaakea minaaka i manga paiasana bhawine mokarajaana i aroana bhambana Kema Pokawaana tee Aulataʼala. ");
INSERT INTO wlo_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Sapadhana incia sumai Bezaleel akarajaa tanalapa. Atondoa i weta i salata tanalapa sumai tee kae corocoro minaaka i kae lenan alusu motounte, 44 metere kaaratena, ");
INSERT INTO wlo_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","atukoa 20 pale arii tee 20 kalempesi minaaka i tambaga mobulilingiakana tanalapa sumai. Manga kakaina arii sumai tee manga papokawaana atokarajaa minaaka i pera. ");
INSERT INTO wlo_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Mboo sumai uka i weta i napa, kae corocoro kaarate 44 metere atobhakesaka, atukoa 20 pale arii tee 20 angu kalempesi minaaka i tambaga, maka manga kakaina tee papokawaana minaaka i pera. ");
INSERT INTO wlo_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","I weta i bhara abhakesakaakea kae corocoro kaaratena 22 metere, atukoa sapulu pale arii amondo tee sapulu angu kalempesina. Manga kakaina arii sumai tee manga papokawaana atokarajaa minaaka i pera. ");
INSERT INTO wlo_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Kaewana tidhana weta i timbu 22 metere uka. ");
INSERT INTO wlo_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","15","I weta i timbu i tanalapa sumai, i saripina i kaai tee i kaana tampana bhambana lawa, kaaratena corocoro sumbesumbere 6,6 metere. Atoloeaka sumbesumbere corocoro sumai i talu pale arii i talu angu kalempesina, mboo sumai uka i bhiwi mosagaanana. ");
INSERT INTO wlo_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Tee mboo sumai, saangua tanalapa sumai abulilingiakea tee corocoro minaaka i kae lenan alusu motounte. ");
INSERT INTO wlo_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Manga kalempesina ariina atokarajaa minaaka i tambaga, sainamo manga kakai i ariina tee manga papokawaana minaaka i pera. Bhaana saasaangu arii alapisiakea pera, bhari-bharia ariina tanalapa sumai apapokawea tee manga papokawaa minaaka i pera. ");
INSERT INTO wlo_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Corocorona bhambana lawana tanalapa atokarajaa minaaka i kae lenan alusu motountena tee kambari waranaa kakanda, wungu, tee maleʼi matuʼa, abhelokiakea tee kasokai. Kaaratena sio metere, kalanga tee kaewana rua metere, apokana mboomo kaewana kaena corocorona tanalapa sumai. ");
INSERT INTO wlo_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Corocorona bhamba sumai atukoa pata pale arii, amondo tee kalempesina minaaka i tambaga. Manga kakai i ariina tee manga papokawaana atokarajaa minaaka i pera, bhaana ariina uka alapisiakea pera. ");
INSERT INTO wlo_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Bhari-bharia pato to Kema Momangkilo tee saangua patona tanalapa sumai atokarajaa minaaka i tambaga. ");
INSERT INTO wlo_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Siimo daftarana sagala giu ipake to pakaroana Kema Momangkilo tampana dhikaana rua angua katongkana bhatu motoburiakana Sapulu Parintana KAWASANA OPU. Musa atumpu manga miana Lewi aburi bhari-bharia o ponambona pakaroana Kema Momangkilo sumai, tee Itamar anana Harun mojaganina manga miana Lewi mokarajaana sumai. ");
INSERT INTO wlo_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Bezaleel bin Uri bin Hur, minaaka i lipu Yuda, akarajaaia bhari-bharia iparintaakana KAWASANA OPU to Musa. ");
INSERT INTO wlo_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Incia ahambea Aholiab bin Ahisamakh, minaaka i lipu Dan, samia pande tee ahalii, samia pande sokai pegiu-giu waranaa minaaka i kae lenan alusu motountena tee kambari waranaa kakanda, wungu, tee maleʼi matuʼa. ");
INSERT INTO wlo_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Kabharina bhari-bharia bulawa ipake to apakaroaka Kema Momangkilo kabharina 1.000 kilo, atimbangiakea tee timbanga motopake i Kema Momangkilo. ");
INSERT INTO wlo_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Sainamo pera ipotibhaakana minaaka i miana Israel sumai kabharina 3.430 kilo, mboomo timbanga motopake i Kema Momangkilo. ");
INSERT INTO wlo_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Bhari-bharia mia motogagari sumai apomea doi mboomo katamona ipatotapuaka i Kema Momangkilo, siitumo satanga syikal (katamona syikal sumai sapulu haramu). Kabharina mia motogagari dhaangia 603.550 umane, mokoʼumuruna 20 tao labhi. ");
INSERT INTO wlo_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Minaaka i pera sumai, 3.400 kilo atopake to akarajaaka 100 kalempesina ariina Kema Momangkilo tee kalempesina corocorona. Saasaangu kalempesi katamona 34 kilo. ");
INSERT INTO wlo_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Sainamo 30 kilo pera bhilaana atopake to akarajaaka kakaina manga arii, to alapisiaka manga bhaana arii, tee akarajaa manga papokawaana. ");
INSERT INTO wlo_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Tambaga ipasombaaka to KAWASANA OPU sumai o kabharina 2.425 kilo. ");
INSERT INTO wlo_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Minaaka i bhari-bharia sumai atokarajaa manga kalempesina Kema Pokawaana tee Aulataʼala, tampana tunuana kurubani minaaka i tambaga amondo tee jala-jalana, bhari-bharia parakakasina tampana tunuana kurubani, ");
INSERT INTO wlo_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","kalempesina manga ariina corocoro i saripina tanalapa tee ariina bhambana lawana, bhari-bharia patona Kema Momangkilo tee bhari-bharia patona to tanalapa i saripina. ");
INSERT INTO wlo_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Minaaka i kambari waranaa kakanda, wungu tee maleʼi matuʼa, Bezaleel tee Aholiab akarajaa pakea mangada hususu to atopake i wakutuu manga imamu apadhaangia ibaadati i tampa mangkilo. Manga incia uka akarajaa pakea mangkilo to Harun, mboomo iparintaakana KAWASANA OPU to Musa. ");
INSERT INTO wlo_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Manga incia akarajaa bhaju efod minaaka i bulawa, kambari waranaa kakanda, wungu, tee maleʼi matuʼa tee lenan alusu motounte. ");
INSERT INTO wlo_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Tibhana bulawa atorabu amembali amanipi, kasiimpo adhodhoa amembali kambari to asokaia i kambari waranaa kakanda, wungu, tee maleʼi matuʼa tee lenan alusu mboomo ikarajaana samia ahalii. ");
INSERT INTO wlo_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Kasiimpomo akarajaakea rua tali katutubhina awaana mopoompuna i rua angu tapana mamudhaakana bhaju efod sumai apoompu. ");
INSERT INTO wlo_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Kabhokena bhaju efod itanu tee kabheloki sumai apokana o karajaana tee bhaju efod sumai, siitumo minaaka i kae lenan alusu motountena tee kambari waranaa kakanda, wungu, tee maleʼi matuʼa, mboomo iparintaakana KAWASANA OPU to Musa. ");
INSERT INTO wlo_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Manga incia akarajaa uka rua angu bhatu tundu krisopras. Kasiimpo apasea i nuncana manga simpi sumai abhewengiakea tee kabhoke bulawa. Samia pande tundu moʼahalii abhelokiakea o sarona sapulu rua miaia anana Israel i rua angua bhatu sumai, manga sarona atobheloki mboomo capu. ");
INSERT INTO wlo_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Kasiimpo manga incia apasa rua angua bhatu tundu sumai i awaana bhaju efod mamudhaakana o KAWASANA OPU audhani miana Israel. Bhari-bharia sumai apokana tee opea mopadhana iparintaakana KAWASANA OPU to Musa. ");
INSERT INTO wlo_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Sapadhana incia sumai, manga incia akarajaa katutubhina bada alaloi limana samia ahalii. Katutubhina bada sumai atokarajaa mboomo giuna bhaju efod, siitumo minaaka i bulawa, kambari waranaa kakanda, wungu, tee maleʼi matuʼa, tee lenan alusu motounte. ");
INSERT INTO wlo_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Modelena pata wala pata singku, akarajaaia apotapi rua lapi, 22 senti kaaratena tee kaewana. ");
INSERT INTO wlo_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Manga incia apatalaakea pata talana bhatu tundu. Talana bhaa-bhaana atokarajaa minaaka i tundu bhatu aki maleʼi, topas, tee zamrud. ");
INSERT INTO wlo_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Talana rua anguna atokarajaa minaaka i pirus kakanda, nilam, tee yinta. ");
INSERT INTO wlo_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Talana talu anguna atokarajaa minaaka i lazuardi, aki maputi, tee bhatu kecubung. ");
INSERT INTO wlo_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Talana pata anguna atokarajaa minaaka i tundu pirus, krisopras, tee giok. Bhari-bharia sumai abhewengiakea tee kabhoke bulawa. ");
INSERT INTO wlo_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Kabharina bhatu tundu sii sapulu rua angu mboomo kabharina sarona anana Israel. Saangu-saangu bhatu sumai atobheloki mboomo capu tee sarona sala saangu minaaka i sapulu rua angu lipu sumai. ");
INSERT INTO wlo_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Manga incia akarajaa to katutubhina bada sumai manga rambana rante bulawa asilii o bhanguna mboomo tali ipii. ");
INSERT INTO wlo_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Kasiimpo manga incia akarajaa rua ramba kabhoke bulawa tee rua angu simbi bulawa. Rua angua simbi sumai atopasa i rua angua tapana katutubhina bada, ");
INSERT INTO wlo_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","tee i simbi sumai atopaompu tee rua ramba rante bulawa i saao. ");
INSERT INTO wlo_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","I rua angua tapana mosagaanana minaaka i rua ramba rante motounte sumai manga incia apasaakea i rua angua simbina kabhokena tundu i saao mamudhaakana rua angua atopasa i manga kabhokena awaana bhaju efod i weta i aroa. ");
INSERT INTO wlo_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Kasiimpomo manga incia akarajaamo uka rua angu simbi bulawa tee apasaakea i rua angua tapana katutubhina bada i kalapina i weta i nunca mopoarona tee bhaju efod. ");
INSERT INTO wlo_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Sapadhana incia sumai, manga incia uka akarajaa rua angu simbi bulawa mosagaanana tee apasea i weta i tambe minaaka i rua angua kabhoke i awaana bhaju efod i weta i aroa, i saripina kaompuna, i bhawona kabhokena bhaju efod itanu tee kabheloki. ");
INSERT INTO wlo_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Kasiimpomo simbi katutubhina bada sumai manga incia abhokeakea i simbina bhaju efod tee kabhoke kakanda mamudhaakana katutubhina bada sumai sadhaadhaana i bhawona kabhokena bhaju efod itanu tee kabheloki tee sadhaadhaana i bhaju efod sumai, mboomo iparintaakana KAWASANA OPU i Musa. ");
INSERT INTO wlo_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Manga incia uka akarajaa juba maarate to apakea Harun i tambena bhaju efod, atokarajaa saangua minaaka i kae waranaa kakanda, ikarajaana samia pande tanu. ");
INSERT INTO wlo_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Juba sumai akobhalo i tanga-tangana to apapesuaaka bhaana. Manga incia asorumba bhiwina kae itanu i bhiwina bhalo sumai, mamudhaakana kaena inda amabhenci. ");
INSERT INTO wlo_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","I saangua tapana juba weta i tambe manga incia akarajaakea kabheloki mboomo bhakena dalima minaaka i kae lenan alusu motountena tee kambari waranaa kakanda, wungu, tee maleʼi matuʼa. ");
INSERT INTO wlo_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Manga incia uka akarajaa nggiri-nggiri minaaka i bulawa asilii, kasiimpo apasea aololotia tee manga kabhelokina bhakena dalima i saangua tapana juba weta i tambe. ");
INSERT INTO wlo_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Saangu nggiri-nggiri bulawa i tanga-tangana i saangu-saangu bhakena dalima sumai, kasiimpo saangu nggiri-nggiri bulawa uka apapoosea tee saangu bhakena dalima, mboo sumai satorosuna i saangua tapana juba bhemotopakena to padhaangiana ibaadati sumai mboomo iparintaakana KAWASANA OPU i Musa. ");
INSERT INTO wlo_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Sapadhana incia sumai, manga pande tanu akarajaa bhaju minaaka i lenan alusu to Harun tee manga anana, ");
INSERT INTO wlo_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","manga incia uka akarajaa surubani tee manga kampurui momakesa minaaka i kae lenan alusu, manga sala i nunca minaaka i lenan alusu motounte, ");
INSERT INTO wlo_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","tee manga kabhokena tanga minaaka i lenan alusu motounte, kambari waranaa kakanda, wungu, tee maleʼi matuʼa akokabhelokiaka kasokai, mboomo iparintaakana KAWASANA OPU i Musa. ");
INSERT INTO wlo_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Manga incia uka akarajaa pita minaaka i bulawa asilii, siitumo mahakota momangkilo tee abhelokiakea kaburi \"Mangkilo to KAWASANA OPU\". ");
INSERT INTO wlo_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Kabheloki sumai manga incia akarajaakea tali kakanda mamudhaakana amembali atopasa i weta i bhawona surubani, mboomo iparintaakana KAWASANA OPU i Musa. ");
INSERT INTO wlo_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Mboo sumaimo atopamondo sagala karajaana Kema Momangkilo, siitumo Kema Pokawaana tee Aulataʼala. Miana Israel apewaua bhari-bharia apokana tee iparintaakana KAWASANA OPU i Musa. ");
INSERT INTO wlo_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Kasiimpomo, manga incia abhawa Kema Momangkilo sumai i aroana Musa, siitumo: kema tee sagala kamondona, mboomo manga kakaina, manga toorana, manga kau leleana, manga ariina, tee manga kalempesina; ");
INSERT INTO wlo_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","katutubhi minaaka i kulina dumba umane motowaranaai maleʼi, katutubhi minaaka i kulina lumba-lumba, tee corocoro katutubhina; ");
INSERT INTO wlo_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Sorongana Pojanjia tee rua pale kancodhaana tee katutubhina to ahapusuaka dosa; ");
INSERT INTO wlo_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","meja tee bhari-bharia parakakasina tee roti pasombaa; ");
INSERT INTO wlo_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","padamara minaaka i bulawa asilii tee manga padamara (padamara sumai tabeana apotala), bhari-bharia parakakasina, tee mina to kainawa; ");
INSERT INTO wlo_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","tampa tunuana dhupa minaaka i bulawa, mina idhupai, tee dhupa mawondu; corocoro to bhambana kema sumai; ");
INSERT INTO wlo_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","tampa tunuana kurubani minaaka i tambaga tee jala-jala tambagana, rua pale kancodhaana, tee bhari-bharia parakakasina; palangga kapebhahoka tee kalempesina; ");
INSERT INTO wlo_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","corocoro to tanalapa tee manga ariina tee manga kalempesina, corocorona bhambana lawana tanalapa tee manga rabutana tee manga patona, tee bhari-bharia parakakasi to Kema Momangkilo, siitumo Kema Pokawaana tee Aulataʼala, ");
INSERT INTO wlo_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","pakea moʼalusu itanu to apadhaangia ibaadati i Tampa Momangkilo, pakea mangkilo to imamu Harun, tee pakeana manga anana to akarajaa tugasina amembali imamu. ");
INSERT INTO wlo_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Miana Israel apewaumea bhari-bharia karajaa sumai apokana iparintangiakana KAWASANA OPU i Musa. ");
INSERT INTO wlo_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Musa aparakisaaia bhari-bharia karajaa sumai, tee atotuu ande manga incia apewaumea mboomo iparintaakana KAWASANA OPU. Kasiimpo Musa abarakatimo manga incia. ");
INSERT INTO wlo_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","KAWASANA OPU afirimani i Musa, ");
INSERT INTO wlo_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","\"I eo bhaa-bhaana i bula bhaa-bhaana pakaromea o Kema Momangkilo, siitumo Kema Pokawaana tee Aulataʼala. ");
INSERT INTO wlo_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","I nuncana Kema Momangkilo sumai, dhikamea Soronga Pojanjia tee pasaakea corocoro i aroana soronga sumai to katutubhina. ");
INSERT INTO wlo_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Bhawamea o meja i nuncana Kema Momangkilo sumai tee uʼatoroa bhari-bharia kamondona i tampana. Bhawea uka padamara i nuncana kema, kasiimpo pasea manga suluna. ");
INSERT INTO wlo_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Dhikaia o tampana tunuana dhupa minaaka i bulawa i aroana Soronga Pojanjia, tee loeakea corocorona bhambana Kema Momangkilo sumai. ");
INSERT INTO wlo_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Dhikaia tampana tunuana kurubani i aroana bhambana Kema Momangkilo, siitumo Kema Pokawaana tee Aulataʼala. ");
INSERT INTO wlo_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Sapadhana incia sumai, dhikaia palangga kapebhahoka i tanga-tangana Kema Pokawaana tee Aulataʼala tee polotaana tampana tunuana kurubani sumai kasiimpo uantokiakea uwe. ");
INSERT INTO wlo_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Karajaamo tanalapa i saripina tee loeakea corocoro bhambana lawana tanalapa sumai. ");
INSERT INTO wlo_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Alamo mina idhupai, kasiimpo minakia Kema Momangkilo tee bhari-bharia modhaangiana i nuncana. Pekangkiloa kema sumai tee bhari-bharia kamondona sabutuna kema sumai bheamangkilo. ");
INSERT INTO wlo_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Minakia tampana tunuana kurubani tee bhari-bharia kamondona, tee pekangkiloa tampana tunuana kurubani sumai, sabutuna tampana tunuana kurubani sumai bheamangkilo mpuu. ");
INSERT INTO wlo_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Minakia palangga kapebhahoka sumai tee kalempesina, tee pekangkiloa. ");
INSERT INTO wlo_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Bhawea Harun tee manga anana i bhambana Kema Pokawaana tee Aulataʼala, kasiimpo bhahoa manga tee uwe. ");
INSERT INTO wlo_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Pakanaakea pakea momangkilo i Harun. Minakia tee hususuakea mamudhaakana incia akarajaa tugasina amembali imamu. ");
INSERT INTO wlo_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Sapadhana incia sumai, bhawea manga anana, kasiimpo pakanaakea juba i nunca. ");
INSERT INTO wlo_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Minakia manga mboomo uminaki amana mamudhaakana manga incia uka amembali akarajaa tugasina amembali imamu to Iaku. Sabutuna tee mina idhupai sumai manga incia tee siwuluna bheamembali imamu saʼumurua.\" ");
INSERT INTO wlo_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Musa apewaua bhari-bharia apokana tee iparintangiakana KAWASANA OPU i incia. ");
INSERT INTO wlo_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","I tao rua taona, siitumo i eo bhaa-bhaana, i bula bhaa-bhaana, Kema Momangkilo atopakaro. ");
INSERT INTO wlo_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Musa apakaro Kema Momangkilo sumai, apasa manga kalempesina, tee apakakaro manga toorana. Apasea kau leleana tee apakaroa manga ariina. ");
INSERT INTO wlo_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Abhakesakamea padhana kema motutubhina Kema Momangkilo sumai, kasiimpo apasa katutubhina kema i bhawona, mboomo iparintaakana KAWASANA OPU i incia. ");
INSERT INTO wlo_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Sapadhana incia sumai, Musa aalamo rua angu katongkana bhatu hukumuna Aulataʼala sumai tee adhikaia i nuncana Soronga Pojanjia. Apasaakea kau kancodhaa i soronga sumai tee adhikaia katutubhina to ahapusuaka dosa i bhawona soronga sumai. ");
INSERT INTO wlo_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Kasiimpomo, abhawamea soronga sumai i nuncana Kema Momangkilo, aloeakea corocoro katutubhina soronga pojanjia sumai, mboomo iparintaakana KAWASANA OPU i incia. ");
INSERT INTO wlo_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Kasiimpomo Musa adhika meja to pasombaana roti i nuncana Kema Momangkilo i weta i napa, i aroana corocoro sumai. ");
INSERT INTO wlo_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Kasiimpo, adhikamea roti i bhawona meja sumai i aroana KAWASANA OPU mboomo kananea iparintaakana KAWASANA OPU i incia. ");
INSERT INTO wlo_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Apoaro tee meja sumai, adhikaia padamara i nuncana Kema Pokawaana tee Aulataʼala, siitumo i nuncana Kema Momangkilo i weta i salata. ");
INSERT INTO wlo_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Kasiimpomo, apasamea manga sulu i aroana KAWASANA OPU, mboomo iparintaakana KAWASANA OPU i incia. ");
INSERT INTO wlo_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","I nuncana Kema Pokawaana tee Aulataʼala sumai uka, siitumo i aroana corocoro, adhikaia tampana tunuana dhupa minaaka i bulawa. ");
INSERT INTO wlo_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Kasiimpo incia atunu dhupa minaaka i manga rampa mawondu, mboomo iparintaakana KAWASANA OPU i Musa. ");
INSERT INTO wlo_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Sapadhana sumai, Musa aloemea corocorona bhambana Kema Momangkilo. ");
INSERT INTO wlo_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Adhikaia tampana tunuana kurubani i aroana bhambana Kema Momangkilo, siitumo Kema Pokawaana tee Aulataʼala, kasiimpo apasombaakea i bhawona kurubani tunua tee apasombaaka tarigu, mboomo iparintaakana KAWASANA OPU i incia. ");
INSERT INTO wlo_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Incia adhika palangga maoge to pekangkiloa limana tee aena i tanga-tangana Kema Pokawaana tee Aulataʼala tee tampana tunuana kurubani sumai, kasiimpo alaliakea uwe i nuncana palangga maoge sumai. ");
INSERT INTO wlo_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Kasiimpomo, Musa, Harun, tee manga anana Harun abhanui limana tee aena iwe sumai. ");
INSERT INTO wlo_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Ande manga incia apesua i nuncana Kema Pokawaana tee Aulataʼala tee ande manga incia apasari i tampana tunuana kurubani sumai, manga incia tabeana abhanui limana tee aena, mboomo iparintaakana KAWASANA OPU i Musa. ");
INSERT INTO wlo_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Sapadhana incia sumai, Musa apakaro manga ariina tanalapa i saangua Kema Momangkilo tee tampa tunuana kurubani, kasiimpo aloea corocorona bhambana lawana tanalapa sumai. Mboo sumaimo Musa apamondo karajaana. ");
INSERT INTO wlo_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Kasiimpomo, taʼina ngalu atutubhi Kema Pokawaa tee Aulataʼala tee uka kamuliangina KAWASANA OPU apabukemo Kema Momangkilo sumai. ");
INSERT INTO wlo_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Musa inda amembali apesua i nuncana Kema Pokawaana tee Aulataʼala sababuna taʼina ngalu sumai asampa i bhawona tee kamuliangina KAWASANA OPU apabukemo Kema Momangkilo. ");
INSERT INTO wlo_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Ande taʼina ngalu sumai apene minaaka i bhawona Kema Momangkilo, abhosemo miana Israel apalausaka lingkaana manga. ");
INSERT INTO wlo_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Maka, ande taʼina ngalu sumai inda atoangka, manga incia uka inda asidha abhose sampe aantagi taʼina ngalu sumai apene. ");
INSERT INTO wlo_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Taʼina ngaluna KAWASANA OPU sumai dhaangia i bhawona Kema Momangkilo i wakutuuna eo, tee i wakutuuna malo dhaangia cahea i nuncana taʼina ngalu sumai, i aroana bhari-bharia siwuluna Israel amembali akamata taʼina ngalu sumai kangengena lingkaana manga. ");
INSERT INTO wlo_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","2","I zamani i piamo itu wakutuuna lipuna Israel indapo tee rajana, Israel akapalaia manga haakimu. I wakutuu incia sumai, lipu sumai akangkanaia kasukarana kaara. I wakutuu incia sumai dhaangia samia umane o sarona Elimelekh. Incia o miana Efrata, tee amboore i Bait Lahim i lipu Yuda. Roonamo kasukarana kaara sumai, sabutuna incia alingka i lipu Moab apobhawa tee bhawinena, Naomi, tee rua miaia anana umane, siitumo Mahlon tee Kilyon. Kasiimpo manga incia ambooremo iwe sumai. ");
INSERT INTO wlo_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Elimelekh amate, sabutuna soomo Naomi tee rua miaia anana. ");
INSERT INTO wlo_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Kasiimpo rua miaia anana sumai akawi tee manga kabuabua minaaka i Moab, sarona o Orpa tee Rut. Sapulu tao sapadhana incia sumai, ");
INSERT INTO wlo_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","rua miaia anana Naomi sumai amatemo uka, siitumo Mahlon tee Kilyon, sabutuna o Naomi akailanga umanena tee rua miaia anana umane. ");
INSERT INTO wlo_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Sumaimo, asiapumo incia to ambuli minaaka i lipu Moab apobhawa tee rua miaia ana maniana roonamo i lipu Moab incia arango ande KAWASANA OPU padhamo amaheruaka uumatina tee adhawu kinande to manga incia. ");
INSERT INTO wlo_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Manga incia alingka apobhawa-bhawa minaaka i tampana mbooresana i Moab aporope i Tana Yuda. Wakutuuna manga incia i nuncana lingkaana, ");
INSERT INTO wlo_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Naomi apogau i rua miaia ana maniana sumai, \"Lingkamo, mbulimo i bhanuana inamiu samia-samia. Sio-siomo KAWASANA OPU amalape tee ingkomiu mboomo ingkomiu umalape i manga mia momatena sumai tee uka i iaku. ");
INSERT INTO wlo_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Sio-siomo KAWASANA OPU adhawukomiu katoo mamudhaakana ukobhanua pendua tee upotibhaaka peulusa tee umane bhaau.\" Kasiimpo Naomi aiki manga incia. Maka o Orpa tee Rut atangi tee suara makaa, ");
INSERT INTO wlo_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","tee apogau i Naomi, \"Inda, ingkami bhetambuli tee ina tee talingka i lipumu.\" ");
INSERT INTO wlo_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Maka o Naomi apogau, \"Mbulimo, manga anaku, pokia ingkomiu uoseaku? Dhaanamo iaku indamo bhekupalaahiri manga ana umane to upamembalia umanemiu naile itu! ");
INSERT INTO wlo_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Mbulimo, manga anaku. Lingkamo roonamo kumancuanamo mpuu to kukoumane pendua. Ande iaku kupogau, 'Dhaangiapo tee harapuku,' tee o malo sii uka iaku kukoumane, tee kupalaahiri ana umane, ");
INSERT INTO wlo_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","buaka ingkomiu uunda uantagia sakawana manga incia amaoge? Bholi mboo itu manga anaku. Kapaʼi inamisiku sii amatamo mpuu to ingkomiu roonamo KAWASANA OPU ahukumuaku.\" ");
INSERT INTO wlo_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Sabutuna atangimo manga tee suara makaa. Kasiimpo Orpa aiki ina maniana, maka o Rut amendeu apogaa tee asakulaka ina maniana sumai. ");
INSERT INTO wlo_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Apogaumo Naomi i Rut, \"Kamatea, Orpa ambulimo i lipuna tee i dewa isombana, ingkoo uka umbulimo upobhawa tee incia.\" ");
INSERT INTO wlo_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Maka o Rut alawani, \"Ina, bholimo upakisaaku to kubholiko tee kumbuli tee inda kuoseko. Iapaipo ulingka iwe sumai uka iaku bhekulingka, tee iapaipo ubutu iwe sumai uka iaku bhekubutu. Lipumu o lipuku uka tee Aulataʼalamu o Aulataʼalaku uka. ");
INSERT INTO wlo_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Iapaipo uka umate iwe sumai uka iaku bhekumate tee kutokoburu. KAWASANA OPU ahukumuaku amatamo mpuu, ande bhekupogaa tee ina, tangkanamo o mate mangapapogaana!\" ");
INSERT INTO wlo_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Wakutuuna Naomi akamatea ande o Rut atotuu-totuu bheaosea, sabutuna incia indamo apogauaka opeapo uka. ");
INSERT INTO wlo_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Kasiimpo Naomi tee Rut apalausakamo lingkaana sampe manga incia akawa i Bait Lahim. Sakawana iwe sumai, saangua kota atobungke tee manga bhawine sumai aabha, \"Atotuumo mia incia sii Naomi?\" ");
INSERT INTO wlo_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Naomi alawani i manga incia \"Bholi ugoraakaaku Naomi. Sarongiakumo o Mara roonamo Aulataʼala Mokokuasa apamembali dhadhiku amapaʼi. ");
INSERT INTO wlo_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Wakutuuna kulingka minaaka i iwe sii iaku inda kukakuranga, maka sii-sii KAWASANA OPU apambuliaku inda tee opeopeaku. Rampaakanamo sumai ingkomiu bholimo usarongiaku Naomi, roonamo KAWASANA OPU Mokokuasana amembali mobhaliaku tee mopanarakaaku!\" ");
INSERT INTO wlo_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Mboo sumaimo tulatulana wakutuuna Naomi ambuli i Israel minaaka i Moab apobhawa tee Rut ana maniana. Manga incia akawa i Bait Lahim i wakutuuna timpuana penembula mokoompole isarongiaka jelai. ");
INSERT INTO wlo_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Naomi dhaangia tee witinaina minaaka i wetana umanena, samia morangkaeana mpuu tee motohoromatina mopowitinaina tee Elimelekh, sarona o Boas. ");
INSERT INTO wlo_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Rut, miana Moab sumai, apogau i Naomi, \"Ina, taroakamo kulingka i inawu kuene jelai i talikuna mia bhemomaasina incana tee iaku.\" Naomi apogau, \"Lingkamo, anaku.\" ");
INSERT INTO wlo_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Sabutuna alingkamo incia i inawu tee apepuumo aene jelai, i talikuna manga pande tobhe. Inda anamunamua incia adhaangia i inawuna Boas, witinaina Elimelekh sumai. ");
INSERT INTO wlo_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Inda amangenge sapadhana incia sumai, o Boas aumbamo minaaka i Bait Lahim. Incia apogau i manga pande tobhe, \"Sio-siomo KAWASANA OPU atondakomiu.\" Alawanimo manga pande tobhe sumai, \"Sio-siomo KAWASANA OPU abarakatiko opu.\" ");
INSERT INTO wlo_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Kasiimpo Boas aabha i mandorona manga mia motimpuna, \"Kabuabua sumai apowitinai tee incema?\" ");
INSERT INTO wlo_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Mandorona sumai alawani, \"Incia o miana Moab siimpo moumbana mopobhawana tee Naomi minaaka i Tana Moab. ");
INSERT INTO wlo_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Incia aposanga i iaku mamudhaakana kuundaakea aose i talikuna manga pande tobhe to aene jelai momandawu i tanga-tangana manga kampupuna jelai sii. Pepuu saeona incia akarajaa torosu, tee tangkanamo sabantara incia aponiunto i wale-wale.\" ");
INSERT INTO wlo_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Kasiimpo Boas apogau tee Rut, \"Rangoa anaku, bholimo ulingka uene jelai i inawuna mia mosagaanana tee sadiamo upekakasu tee manga bhawine mokarajaana i inawuku. ");
INSERT INTO wlo_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Kamatamea o inawu i tampana manga incia atobhe jelai tee uosemea. Iaku padhamo kuposamea i manga mokarajaana sumai mamudhaakana inda akiakiako. Ande amatuu bhorokomu soo usumpumo uwe i tampa mopadhana isiwuna manga mokarajaana sumai.\" ");
INSERT INTO wlo_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Sumaimo asujumo o Rut ahoromati Boas tee apogau, \"Pokia opu amaasi incamu tee iaku, sabutuna ufaduliakaaku, sainamo iaku sii samia dhaga?\" ");
INSERT INTO wlo_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Alawanimo o Boas, \"Iaku padhamo kurangoa sagala giu ipewaumu i ina maniamu, pepuu samatena umanemu. Ingkoo upogaa tee mancuanamu tee ubholi tana laahiriamu tee umboore iwe sii i lipu indapo imataumu. ");
INSERT INTO wlo_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Sio-siomo KAWASANA OPU abholosi bhari-bharia ipewaumu sumai. Tee sio-siomo KAWASANA OPU Aulataʼalana miana Israel adhawuakako fahala mobhari, roonamo ingkoo padhamo uumba to upeulu i tambena panina Incia!\" ");
INSERT INTO wlo_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Pogauna Rut, \"Tapanamo kalapena incamu i iaku, moomini iaku mencuana sala samia bhatuamu bhawine. Kalapena incamu apaunde-unde ngangarandaku.\" ");
INSERT INTO wlo_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Sakawana wakutuuna to akande, Boas apogau tee Rut, \"Maimo iwe sii. Kandemea o roti sii tee upalondomea o rotimu i nuncana cuka sii.\" Sabutuna auncuramo incia i saripina manga mokarajaana sumai, kasiimpo Boas adhawuakea ompolena jelai mopadhana itunu to incia, tee o Rut akande sakawana amambosu, tee akobhilaa uka. ");
INSERT INTO wlo_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Kasiimpo Rut alingkamo uka aene jelai. Boas asamea i manga mokarajaana, \"Taroakea incia aene jelai moomini i tanga-tangana kampupuna jelai mopadhana motobhoke sumai, bholi umendeusakea. ");
INSERT INTO wlo_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Helaakea uka saidhe-saidhe to incia minaaka i kabhokena jelai sumai mamudhaakana aenea. Bholi uʼamaraikia.\" ");
INSERT INTO wlo_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Mboo sumaimo o Rut aene jelai i inawu sakawana konowia. Kasiimpo abhebhe manga laena jelai mopadhana ienena sumai mamudhaakana atorambasaka manga ompolena minaaka i laena. Jelai irombusakana kera-kera dhaangia 10 kilo. ");
INSERT INTO wlo_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Kasiimpomo incia ambuli i kota tee abhawa hasili ienena sumai tee asusuakea i ina maniana saopea kabharina ienena. Tee incia uka adhawuaka i ina maniana sumai o kinande inda momembalina ipepadhai wakutuuna akandea. ");
INSERT INTO wlo_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Kasiimpo apogaumo ina maniana, \"Iapai uenea tee iapai ukarajaa eo sii? Maasangia o mia mofaduliakako sumai apotibhaaka barakati!\" Kasiimpo Rut apetulatulaakamea i ina maniana tee incema akarajaa, pogauna, \"Eo sii iaku kukarajaa tee mia mokosaroakana Boas.\" ");
INSERT INTO wlo_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Pogauna Naomi i ana maniana, \"Sio-siomo incia abarakatia KAWASANA OPU inda mobhotukina kaasina saʼumurua to mia modhadhi tee uka almarhum umanemu.\" Pogauna Naomi uka i incia, \"Mia incia sumai o witinaita makasu, sala samia mowaajibuna motolosina ingkita.\" ");
INSERT INTO wlo_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Kasiimpomo Rut apogau, \"Incia uka apogau tee iaku, 'Sadiamo i saripina manga bhawine mokarajaana i inawuku sakawana manga incia apadha atimpu inawuku.' \" ");
INSERT INTO wlo_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Lawanina Naomi i Rut, \"Salabhina ingkoo ukarajaa upobhawa tee manga bhawine mokarajaana i inawuna Boas, ancosala dhaangia moganggoko ande ukarajaa i inawuna mia mosagaanana. ");
INSERT INTO wlo_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Rampaakanamo sumai, Rut sadhaadhaana aose manga bhawine mokarajaana i inawuna Boas. Incia aene iwe sumai sakawana apadha o bulana timpua jelai tee gandum, tee kangengena timpua sumai o Rut sadhaadhaana amboore tee ina maniana. ");
INSERT INTO wlo_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Pia-pia wakutuu sapadhana sumai, Naomi apogau i Rut, \"Iaku tabeana kuʼusaha mamudhaakana umembali ukobhanua pendua tee upotibhaaka peulusa tee umasanaa. ");
INSERT INTO wlo_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Buaka o Boas mokobhatuana bhawine iosemu sii-sii mencuana witinaita? Mataua, incia tangasaana atepi jelai malo sii i tampana papogaana ompolena jelai. ");
INSERT INTO wlo_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Sababuna sumai, pebhahomo tee upakemo mina-mina mawondu, pakemea o pakeamu tee ulingkamo i tampana papogaana ompolena jelai, maka bholi amatauko sakawana incia apadha akande tee asumpu. ");
INSERT INTO wlo_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Kamatea iapai o koleana. Ande incia atokolemo, lingkamo iwe sumai tee ubungkalemea o kakumuna, kasiimpo upotidhole i saripina aena. Sapadhana sumai incia bheapaumbaakako opea tabeana ipewaumu.\" ");
INSERT INTO wlo_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Lawanina Rut, \"Iaku bhekupewaua bhari-bharia ipogauakamu.\" ");
INSERT INTO wlo_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Kasiimpo, alingkamo incia i tampana papogaana ompolena jelai, apewaua bhari-bharia isameaakana ina maniana. ");
INSERT INTO wlo_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Sapadhana akande tee asumpu o Boas amasanaamo incana, incia alingka apotidhole i tapana kabumbuna jelai sumai. Kasiimpo Rut apesuamo inda tee uuʼuuna. Abungkalemea o kakumuna Boas, kasiimpo apotidhole iwe sumai. ");
INSERT INTO wlo_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Pontanga malo atokidhamo o Boas, wakutuuna abhalili akamatamo samia bhawine i saripina aena. ");
INSERT INTO wlo_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Incia aabha, \"Incema ingkoo?\" Lawanina, \"Iaku o Rut, bhatuamu. Ingkoo satotuuna o witinai makasu almarhum umaneku, tabeana motolosiaku. Bhakesakea o panimu to apeuluaka bhatuamu sii.\" ");
INSERT INTO wlo_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Kasiimpo Boas alawani \"Sio-siomo KAWASANA OPU abarakatiko anaku! Sii-sii ingkoo ususuakaaku kaasi tee kalapena incamu, alabhi minaaka mopadhana ipewaumu mangengena, roonamo ingkoo inda upeelo mia mangura, malape rangkaea atawa o misikini, maka upiliku. ");
INSERT INTO wlo_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Rampaakanamo sumai, bholi umaeka anaku. Bhari-bharia iemanimu sumai bhekupewaua roonamo bhari-bharia miana kota sii amataua ande ingkoo samia bhawine momalape. ");
INSERT INTO wlo_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Inciamo atotuu, iaku tabeana kutanggojawapuaka dhadhimu, sababuna iaku o witinaimu momakasuna motolosina dhadhimu. Maka dhaangiapo uka samia witinaiku momakasuna to atolosi dhadhimu minaaka i iaku. ");
INSERT INTO wlo_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Malo sii umbooremo iwe sii. Naile saeona bhekuabhaakea ara incia aunda atolosiko atawa inda. Ande incia aunda, taroakamo, maka ande inda aunda, sumaimo iaku kujanji tee KAWASANA OPU moudhanina janjiku, iaku bhekutolosiko. Sii-sii ingkoo pomalomo iwe sii sakawana saeona.\" ");
INSERT INTO wlo_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Sabutuna pomalomo Rut iwe sumai i saripina aena Boas sakawana saeona, kasiimpo abhangumo incia mamudhaakana inda akamatea mia. Roonamo o Boas amendeu ande dhaangia o mia momataua ande o Rut aumba i tampa incia sumai. ");
INSERT INTO wlo_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Apogaumo uka o Boas i Rut, \"Rambasakea o salendamu tee utaanakea iwe sii.\" Sabutuna o Rut arambasakamo salendana tee ataanakamea. Boas alalimo jelai i nuncana salenda sumai kera-kera rua pulu kilo. Kasiimpo incia aangkaakamea i bhawona awaana Rut. Sapadhana incia sumai o Boas alingkamo i kota. ");
INSERT INTO wlo_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Sakawana o Rut i bhanua, ina maniana aabhamo, \"Tuaapa ana?\" Kasiimpo o Rut apetulatulaakamea bhari-bharia ipewauna Boas i incia. ");
INSERT INTO wlo_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","Pogauna uka, \"Incia modhawuaku bhari-bharia jelai sii, tee apogau, 'Bholi umbuli i maniamu ande inda ubhawa opeopea.' \" ");
INSERT INTO wlo_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Kasiimpo apogaumo ina maniana, \"Usabara ntagi anaku, sakawana umataua tuaapa o kapadhaana parakara sii, incia dhaanamo bheaʼurusua o parakara sii eo sii uka.\" ");
INSERT INTO wlo_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Kasiimpo saeona sumai, Boas alingka i tampana poromu-romua amakasu i bhambana lawana kota tee auncura iwe sumai. Inda amangenge alalomo samia umane mokohakuna to motolosina dhadhina Naomi. O malona, Boas apaumba Rut ande o mia incia sii apowitinai makasu tee almarhum Elimelekh minaaka i Boas. Apogaumo o Boas i umane sumai, \"Witinaiku, mai tauncura iwe sii!\" Mia incia sumai asiimo, kasiimpo auncura. ");
INSERT INTO wlo_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Kasiimpo Boas akembamo sapulu mia manga mancuanana Bait Lahim sumai tee apogau, \"Uncuramo iwe sii.\" Sabutuna auncuramo manga. ");
INSERT INTO wlo_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Kasiimpo apogaumo Boas i umane sumai, \"Naomi mombulina minaaka i Tana Moab sumai bheaaso satidha tana pewauana witinaita Elimelekh. ");
INSERT INTO wlo_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Iaku padhamo kufikiria salabhina o giu incia sumai kupaumbaakako. Ande uunda ualia tana sumai, alimea i aroana manga mia mouncurana iwe sii tee i aroana manga mancuanana Bait Lahim sii, maka ande umendeu, paumbaaku mamudhaakana kumataua, roonamo inda dhaangia o mia mokohakuna moalina tana incia sumai ande mencuana ingkita taruamia, sababuna sapadhana ingkoo kasiimpomo iaku.\" Lawanina, \"Iaku kuunda kualia.\" ");
INSERT INTO wlo_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Maka o Boas apogau, \"Wakutuuna uali tana sumai minaaka i limana Naomi, ingkoo uka upotibhaaka Rut, bhawine miana Moab sumai, iaiarona almarhum o anana Naomi. Sababuna o tana sumai tabeana sadhaadhaa amembali pewauana siwuluna almarhum sumai.\" ");
INSERT INTO wlo_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Alawanimo mia incia sumai, \"Ande mboo sumai, inda kukapoia kualia. Sababuna iaku bhekupekadhaki tinaurakaku. Taroakamo ingkoo uali opea mowaajibuna ialimu sumai roonamo iaku inda amembali kualia.\" ");
INSERT INTO wlo_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","I zamani i piamo itu i Israel ande o mia aaso atawa apapobholosi manga pewauana, to apasahaaka hali incia sumai, kananeana o mia arambasaka sandalina kasiimpo adhawuakea i mia moalina atawa mopapobholosina tee pewauana. ");
INSERT INTO wlo_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Kasiimpo o mia sumai apogau tee Boas, \"Ingkoomo moalia,\" mia incia sumai arambasaka sandalina kasiimpo adhawuakea i Boas. ");
INSERT INTO wlo_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Boas apogau i manga mancuanana lipu tee bhari-bharia mia modhaangiana iwe sumai, \"Eo sii ingkomiu umembali sakusii ande iaku padhamo kuali bhari-bharia pewauana Elimelekh tee manga anana, siitumo Kilyon tee Mahlon minaaka i limana Naomi. ");
INSERT INTO wlo_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Tee uka o Rut, bhawine miana Moab iaiarona Mahlon sumai amembalimo bhawineku. Tee mboo sumai o tana sumai sadhaadhaa amembali pewauana almarhum sumai tee siwuluna uka sadhaadhaa amboore iwe sii, mamudhaakana sarona mia incia sumai inda bheaila minaaka i tanga-tangana witinaina tee minaaka i raʼeatina kota sumai. Eo sii bhari-bharikomiu bheumembalimo sakusii.\" ");
INSERT INTO wlo_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Sabutuna bhari-bharia moumbana i bhambana lawana kota tee manga mancuanana lipu sumai apogau, \"Ingkami o sakusiina. Sio-siomo KAWASANA OPU apamembali bhawine bhemopesuana i bhanuamu mboomo Rahel tee Lea mopalaahirina abhari ana to Yakub momembalina siwuluna miana Israel. Maasangia ingkoo utobarakati i tanga-tangana manga miana Efrata tee amatauko mia bhari i Bait Lahim. ");
INSERT INTO wlo_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Sio-siomo manga anaana idhawuakana KAWASANA OPU to ingkoo alaloi bhawine mangura sii bheamembali mboomo siwuluna Peres, anana Tamar tee Yuda.\" ");
INSERT INTO wlo_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Boas aalamo Rut tee apamembalia bhawinena. KAWASANA OPU abarakati Rut sabutuna incia abhawa-bhawamo kasiimpo apalaahiri samia ana umane. ");
INSERT INTO wlo_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Kasiimpo apogaumo manga bhawine i kota sumai i Naomi, \"Atopujimo KAWASANA OPU! Incia adhawukomo samia opua umane mokohakuna to atolosiko tee bheapatorusu saromu. Maasangia anaana sumai amataua mia bhari i Israel! ");
INSERT INTO wlo_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Ana maniamu sumai amaasiakako mpuu. Incia adhawuko alabhi minaaka i opea momembalina idhawuakana pitu mia ana umane. Sii-sii incia adhawuakako uka samia opua umane, to mopadhadhina incamu tee modhambaakako i wakutuu ande umancuanamo.\" ");
INSERT INTO wlo_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Naomi aalamo anaana sumai tee adhikaia i sangoana, kasiimpo adhambaakea tee amaasiakea mpuu. ");
INSERT INTO wlo_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Manga sarimbanuana adhawuakea saro to anaana sumai apoose apogau, \"Naomi apalaahirimo samia ana umane.\" Manga incia asarongiakea Obed. Obed siimo o amana Isai, tee o Isai satotuuna o amana Daud. ");
INSERT INTO wlo_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Siimo siwuluna Peres: Peres akoanaakamo Hezron. ");
INSERT INTO wlo_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Hezron akoanaakamo Ram, Ram akoanaakamo Aminadab, ");
INSERT INTO wlo_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Aminadab akoanaakamo Nahason, Nahason akoanaakamo Salmon, ");
INSERT INTO wlo_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","Salmon akoanaakamo Boas, Boas akoanaakamo Obed, ");
INSERT INTO wlo_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","Obed akoanaakamo Isai tee o Isai akoanaakamo Daud.");
INSERT INTO wlo_vpl VALUES ("ET1_1","018_1_1","EST","1","1","1","Kajadia incia sii adhaangia i zamanina Ahasweros, siitumo Ahasweros momembalina rajana Persia tee Media to 127 angu poropinsi, minaaka i India sakawana i Etiopia. ");
INSERT INTO wlo_vpl VALUES ("ET1_2","018_1_2","EST","1","2","2","I zamani incia sumai, wakutuuna Raja Ahasweros tangasaana amboore tee aparintangi minaaka i malige i nuncana bentena Susan. ");
INSERT INTO wlo_vpl VALUES ("ET1_3","018_1_3","EST","1","3","3","I talu taona pamarintana, raja apadhaangia kariaa to bhari-bharia manga kaogesana tee pagawena. Manga kapalana tantarana Persia tee Media, manga gubernuru, tee manga kaogesana poropinsi aumba i kariaa sumai. ");
INSERT INTO wlo_vpl VALUES ("ET1_4","018_1_4","EST","1","4","4","Nama mbula kangengena o raja apapematauaka karangkaeana maligena, tee uka kaogesana tee kamuliangina pamarintana i manga kakembana kariaa sumai. ");
INSERT INTO wlo_vpl VALUES ("ET1_5","018_1_5","EST","1","5","5","Sapadhana incia sumai o raja apadhaangiamo uka kariaa to bhari-bharia raʼeatina modhaangiana i bentena Susan, malape rangkaea atawa misikini. Kariaa sumai kangengena pitu eo tee apadhaangiaia i tanalapa i aroana malige. ");
INSERT INTO wlo_vpl VALUES ("ET1_6","018_1_6","EST","1","6","6","Tanalapa i aroana malige abhelokiakea tee corocoro minaaka i kae lenan waranaa kakanda tee maputi, abhokeakea tee tali lenan moʼalusu tee i manga simbina apakaiakea pera motopasana i manga ariina bhatu pualam. Manga bhangko bulawa tee pera to manga kakemba adhikaia i bhawona lante. Lante sumai motobhelokina tee pualam maleʼi tee maputi, kulina muntia mokokila, tee bhatu pirus kakanda. ");
INSERT INTO wlo_vpl VALUES ("ET1_7","018_1_7","EST","1","7","7","Giu isumpu apatalaakea i nuncana manga tonde bulawa moposalana saangu tee mosagaanana. Angguru i maligena Susan sumai ataralabhi-labhi apokana mboomo kalapena incana raja. ");
INSERT INTO wlo_vpl VALUES ("ET1_8","018_1_8","EST","1","8","8","Manga kakemba asumpu peepeeluana incana roonamo o raja padhamo aposamea to bhari-bharia manga pagawena i maligena mamudhaakana manga incia aose peeluana samia-samia. ");
INSERT INTO wlo_vpl VALUES ("ET1_9","018_1_9","EST","1","9","9","I wakutuu incia sumai, Ratu Wasti apadhaangia kariaa uka to manga bhawine i nuncana maligena Raja Ahasweros. ");
INSERT INTO wlo_vpl VALUES ("ET1_10","018_1_10","EST","1","10","10","I eo pitu eona, wakutuuna raja akaunde-unde roonamo asumpu angguru, raja akembamo Mehuman, Bizta, Harbona, Bigta, Abagta, Zetar tee Karkas, siitumo pitu mia pagawe hususu molaianina karona, ");
INSERT INTO wlo_vpl VALUES ("ET1_11","018_1_11","EST","1","11","11","to abhawa Ratu Wasti apoaro tee raja tee apake mahakota i bhaana. Raja gauna apatokamataaka kakesana ratu i manga raʼeati tee manga kaogesana roonamo ratu sumai amakesa mpuu. ");
INSERT INTO wlo_vpl VALUES ("ET1_12","018_1_12","EST","1","12","12","Maka o Ratu Wasti amendeu aumba to aose parintana raja ipakawaakana manga pagawe hususu sumai. Sababuna sumai, raja apamuru tee aʼamara mpuu. ");
INSERT INTO wlo_vpl VALUES ("ET1_13","018_1_13","EST","1","13","13","Raja aabha i manga ahalii mofahamuna hukumu tee adati, roonamo raja sadia aabha i manga ahaliina tutura tee hukumu. ");
INSERT INTO wlo_vpl VALUES ("ET1_14","018_1_14","EST","1","14","14","Dhaangia pia-pia mia mopomatauna tee mopomakasuna tee raja siitumo: Karsena, Setar, Admata, Tarsis, Meres, Marsena tee Memukan, siitumo pitu mia o kaogesana Persia tee Media mokokauncuramakana malanga i nuncana pamarintana. ");
INSERT INTO wlo_vpl VALUES ("ET1_15","018_1_15","EST","1","15","15","\"Opea tabeana bheipewauku to Ratu Wasti mboomo opea mopadhana ipatotapuaka i nuncana tutura, roonamo incia inda aose parintaku ipakawaakana manga pagawe hususu sumai?\" ");
INSERT INTO wlo_vpl VALUES ("ET1_16","018_1_16","EST","1","16","16","Kasiimpo Memukan alawani i aroana raja tee manga kaogesa sumai, \"Ratu Wasti inda soo asala tee raja uka, maka tee bhari-bharia kaogesa tee bhari-bharia umane modhaangiana i saangua poropinsina Raja Ahasweros uka! ");
INSERT INTO wlo_vpl VALUES ("ET1_17","018_1_17","EST","1","17","17","Pewauna ratu sumai bheamataua bhari-bharia bhawine, sabutuna manga incia bheapandaʼente umanena tee apogau, 'Raja Ahasweros aparintaakea mamudhaakana Ratu Wasti atobhawa i aroana raja, maka incia amendeu aumba.' ");
INSERT INTO wlo_vpl VALUES ("ET1_18","018_1_18","EST","1","18","18","I eo sii uka bhawinena manga kaogesana Persia tee Media, morangona pewauna Ratu, bheapogau mboo sumai uka i manga kaogesana Raja, sabutuna bheabhari o kahina tee amara. ");
INSERT INTO wlo_vpl VALUES ("ET1_19","018_1_19","EST","1","19","19","Rampaakanamo sumai, ingkami taemani mamudhaakana uala kambotu ande o Ratu Wasti indamo amembali apokawa tee Raja. Kambotu incia sumai tabeana apamembalia saangu tutura i Persia tee i Media, mamudhaakana inda amembali ahobutia pendua. Sapadhana incia sumai, dhawuakamea o kauncuramakana Ratu Wasti i bhawine mosagaanana molabhina kalapena minaaka i incia. ");
INSERT INTO wlo_vpl VALUES ("ET1_20","018_1_20","EST","1","20","20","Ande o kambotuna Raja sumai atoresamo i saangua pamarintana lipu momaoge sumai, sumaimo bhari-bharia bhawine bheahoromati umanena, malape rangkaea atawa misikini.\" ");
INSERT INTO wlo_vpl VALUES ("ET1_21","018_1_21","EST","1","21","21","Raja tee kaogesa asatujui pogauna Memukan, sumaimo o raja alausakamo apewaua. ");
INSERT INTO wlo_vpl VALUES ("ET1_22","018_1_22","EST","1","22","22","Incia alamboko manga sura parinta to bhari-bharia poropinsina pamarintana, antona sura sumai apokana tee pogau tee kaburina manga lipuna sumai sumbesumbere. Parinta incia sumai akooni, \"Bhari-bharia umane tabeana akapalai bhanuana, tee manga mia momboorena i nuncana bhanuana tabeana apake pogauna lipuna umane sumai.\" ");
INSERT INTO wlo_vpl VALUES ("ET2_1","018_2_1","EST","2","1","1","Sapadhana manga kajadia incia sumai, i wakutuuna amarana Raja Ahasweros auntomo, atoudhanimo incia i Wasti, tee opea mopadhana ipewauna tee kambotu mopadhana ialana to Wasti. ");
INSERT INTO wlo_vpl VALUES ("ET2_2","018_2_2","EST","2","2","2","Sumaimo apogaumo manga pagawe molaianina raja, \"Taroakamo tapeeloakea kabuabua momakesana bhanguna to Raja. ");
INSERT INTO wlo_vpl VALUES ("ET2_3","018_2_3","EST","2","3","3","Raja tabeana aangka manga pagawena i bhari-bharia poropinsi i nuncana pamarintana to aromusaka kabuabua momakesana bhanguna. Manga kabuabua sumai ajagania i tampa mohususu to bhawine i malige i nuncana bentena Susan, tee ajagania samia pagawe hususuna Raja mokosarona Hegai. Hegai mojaganina manga bhawinena Raja. Kasiimpo manga incia tabeana adhambaakea tee mina-mina mawondu mamudhaakana amakesa. ");
INSERT INTO wlo_vpl VALUES ("ET2_4","018_2_4","EST","2","4","4","Dhaampomo, o kabuabua momalapena i matana Raja bheamembali ratu to abholosi Wasti.\" Giu incia sumai aabhia amalape tee asatujuia raja, tee apewaumea. ");
INSERT INTO wlo_vpl VALUES ("ET2_5","018_2_5","EST","2","5","5","I wakutuu incia sumai i bentena Susan dhaangia samia o miana Yahudi o sarona Mordekhai bin Yair bin Simei bin Kis. Incia minaaka i kaomuna Binyamin. ");
INSERT INTO wlo_vpl VALUES ("ET2_6","018_2_6","EST","2","6","6","Incia uka amembali mia mototaangi i wakutuuna rajana Babel, Nebukadnezar, atalo Yerusalem. Kasiimpomo Mordekhai atobhawa atobhanaka tee rajana Yuda mokosarona Yekhonya, tee manga mia abhari mototaangina uka. ");
INSERT INTO wlo_vpl VALUES ("ET2_7","018_2_7","EST","2","7","7","Mordekhai apotolidha tee samia kabuabua o sarona Hadasa tee isarongiaka uka Ester. Ester amangada o poningkarona tee amakesa o rouna. Roonamo rua miaia mancuanana Ester amatemo, sumaimo incia apekaoge tee adhambaaka Ester mboomo anana karona. ");
INSERT INTO wlo_vpl VALUES ("ET2_8","018_2_8","EST","2","8","8","Satoresana parintana raja, abhari o kabuabua makesa aromusakea i nuncana bentena Susan, tee ajagania Hegai. Ester uka abhawea apesua i nuncana maligena raja tee ajagania Hegai. ");
INSERT INTO wlo_vpl VALUES ("ET2_9","018_2_9","EST","2","9","9","Hegai akamata Ester tee aabhia mia malape tee amaasiakea. Sabutuna o Hegai alausakamo adhawuakea mina-mina momawondu tee kinande hususu. Hegai adhawuakea uka pitu mia kabuabua motopilina to molaianina i malige hususu to bhawine minaaka i maligena raja. Kasiimpo Ester tee kabuabua molaiania apapindaia i tampa momalape i malige hususu to bhawine. ");
INSERT INTO wlo_vpl VALUES ("ET2_10","018_2_10","EST","2","10","10","Ester inda apaumbaakea o kamiaana, ande incia satotuuna miana Yahudi, roonamo Mordekhai audhaniakea mboo sumai. ");
INSERT INTO wlo_vpl VALUES ("ET2_11","018_2_11","EST","2","11","11","Saeo-saeo Mordekhai akambeli-mbeli i tanalapa i aroana malige mohususu to bhawine to amatauaka kadhaangiana tee opea bhemomembalina tee incia. ");
INSERT INTO wlo_vpl VALUES ("ET2_12","018_2_12","EST","2","12","12","Manga kabuabua sumai tabeana adhawua mina-mina mawondu kangengena sapulu rua mbula mboomo tuturana to manga bhawine. Siitumo kangengena nama mbula mobhaa-bhaana manga incia apake mina damar momawondu tee nama mbulana sapadhana incia sumai manga incia apake mina mawondu irampai. Salapana wakutuuna manga kabuabua idhambaakana sumai aʼaahiri, bhari-bharia apotibhaaka palina to apoaro i Raja Ahasweros. ");
INSERT INTO wlo_vpl VALUES ("ET2_13","018_2_13","EST","2","13","13","Sakawana wakutuuna samia kabuabua apesuamo apoaro tee raja, mboo siimo tuturana: Opeapo uka iemanina tabeana adhawuakea to abhawea minaaka i tampa mohususu to bhawine i nuncana maligena raja. ");
INSERT INTO wlo_vpl VALUES ("ET2_14","018_2_14","EST","2","14","14","Incia bheapesua i wakutuuna soonaeo, kasiimpo naile saeona incia bheambuli i tampa mobhaau mohususu to bhawine mosagaanana ijaganina Saasgas, samia pagawe hususu mojaganina manga gundina raja. Kasiimpo gundina sumai inda bheapesua uka to apoaro tee raja tabeana ande o raja apeelua, sumaimo incia bheakembaia tee bheagoraakea o sarona. ");
INSERT INTO wlo_vpl VALUES ("ET2_15","018_2_15","EST","2","15","15","Sabutuna akawamo palina Ester to apokawa tee raja. Ester satotuuna anana Abihail tee witinaina Mordekhai mopadhana iangkana mboomo o anana karona. Roonamo amakesa, bhari-bharia mokamatea amente. Wakutuuna incia alingka apokawa tee raja, Ester apobhaju mboomo isusuakana tee iadhariakana Hegai, kapalana tampa mohususu to bhawine. ");
INSERT INTO wlo_vpl VALUES ("ET2_16","018_2_16","EST","2","16","16","Kasiimpo Ester abhawea to apoaro tee Raja Ahasweros i nuncana maligena pamarintana i bula i sapulu mbulana, siitumo i bula Tebet, i tao i pitu taona raja aparinta. ");
INSERT INTO wlo_vpl VALUES ("ET2_17","018_2_17","EST","2","17","17","Ester apasanaa tee apaunde-unde raja alabhi minaaka i kabuabua mosagaanana. Sabutuna o raja amaasiakea alabhi minaaka i bhari-bharia kabuabua mosagaanana. Sumaimo raja apakanaakea mahakotana pamarintana i bhaana Ester tee alantia apamembalia ratu to abholosiaka Wasti. ");
INSERT INTO wlo_vpl VALUES ("ET2_18","018_2_18","EST","2","18","18","Sapadhana incia sumai, raja apadhaangiamo kariaa maoge to kaogesana tee pagawena, siitumo kariaa kahoromatina to Ester. Raja uka indamo aemani balasitee i manga poropinsina tee abage-bageakea hadia ataralabhi-labhi, mboomo laengana samia raja. ");
INSERT INTO wlo_vpl VALUES ("ET2_19","018_2_19","EST","2","19","19","I wakutuuna manga kabuabua atoromusaka to rua mpearona, Mordekhai auncura i bhambana lawana maligena raja. ");
INSERT INTO wlo_vpl VALUES ("ET2_20","018_2_20","EST","2","20","20","Ester indapo uka apaumbaakea o kamiaana, mboomo isameaakana Mordekhai to incia. Sababuna o Ester sadhaadhaa aose pogauna Mordekhai mboomo i wakutuuna incia dhaangiapo adhambaakea i piamo itu. ");
INSERT INTO wlo_vpl VALUES ("ET2_21","018_2_21","EST","2","21","21","Wakutuu incia sumai, Mordekhai tangasaana auncura i bhambana lawana maligena raja, rua mia pagawe hususuna raja mojaganina bhambana lawa siitumo, Bigtan tee Teres, ahaejatimo apekamate Raja Ahasweros, roonamo amapii incana. ");
INSERT INTO wlo_vpl VALUES ("ET2_22","018_2_22","EST","2","22","22","Giu incia sumai amataua Mordekhai tee alausaka apaumbaakea i Ester. Kasiimpo Ester apetulatulaakamea i raja tee opea imatauna Mordekhai sumai. ");
INSERT INTO wlo_vpl VALUES ("ET2_23","018_2_23","EST","2","23","23","Wakutuuna giu incia sumai aparakisaaia, garaaka atotuu, sumaimo mia rua miaia sumai uka atoloe i arii sakawana amate. Kasiimpo kajadia incia sumai atoburi i nuncana boku tulatula mangenge i aroana raja. ");
INSERT INTO wlo_vpl VALUES ("ET3_1","018_3_1","EST","3","1","1","Sapadhana manga kajadia incia sumai, Raja Ahasweros aangkamo samia mokosarona Haman bin Hamedata amembali sapatina. Haman bin Hamedata satotuuna minaaka i siwuluna Agag. Raja aangkatakea tee apatotapuakea o kauncuramakana mamudhaakana alabhi kalangana minaaka i bhari-bharia kaogesana raja mosagaanana. ");
INSERT INTO wlo_vpl VALUES ("ET3_2","018_3_2","EST","3","2","2","Bhari-bharia pagawena raja modhaangiana i bhambana lawana malige asuju sakawana i tana tee adhawu horomati i Haman, roonamo mboomo sumai iparintaakana raja to incia. Maka o Mordekhai amendeu asuju tee ahoromatia. ");
INSERT INTO wlo_vpl VALUES ("ET3_3","018_3_3","EST","3","3","3","Manga pagawena raja modhaangiana i bhambana lawana malige uka apogau i Mordekhai, \"Pokia ingkoo inda uose parintana raja to asuju ahoromati Haman?\" ");
INSERT INTO wlo_vpl VALUES ("ET3_4","018_3_4","EST","3","4","4","Saesaeo manga pagawena raja sumai audhaniaka Mordekhai, maka amendeu aperangoia, sabutuna manga incia apetulatulaakamea o hali incia sumai i Haman. Mordekhai padhamo apaumba manga pagawena raja sumai ande incia o miana Yahudi. Sumaimo, manga incia gauna bheakamatea opea ipewauna Haman ande o Mordekhai sadhaadhaa inda aose parintana raja. ");
INSERT INTO wlo_vpl VALUES ("ET3_5","018_3_5","EST","3","5","5","Wakutuuna Haman akamata Mordekhai inda asuju tee ahoromatia, aʼamaramo mpuu incia. ");
INSERT INTO wlo_vpl VALUES ("ET3_6","018_3_6","EST","3","6","6","Sapadhana mia apaumbaakea o kamiaana Mordekhai i incia, sumaimo o Haman ahaejati to apabinasa bhari-bharia miana Yahudi, siitumo mia salipuna Mordekhai, i saangua pamarintana Ahasweros roonamo incia aabhi ahina o karona, ande soo apekamate Mordekhai. ");
INSERT INTO wlo_vpl VALUES ("ET3_7","018_3_7","EST","3","7","7","I bula bhaa-bhaana siitumo i bula Nisan, i tao sapulu rua taona Raja Ahasweros amembali raja, Haman atumpu mia to abhanaka bhatu undi mokosarona \"Pur,\" i aroana. Manga incia aʼundia mamudhaakana apatotapuaka eo tee bula to apewauaka haejatina sumai. Sabutuna apatotapuakamea eo tee bulana, siitumo i eo sapulu talu eona i bula sapulu rua mbulana i nuncana bula Adar. ");
INSERT INTO wlo_vpl VALUES ("ET3_8","018_3_8","EST","3","8","8","Kasiimpo Haman apogaumo i Raja Ahasweros, \"Raja, dhaangia saangu lipu mopogaa-gaana tee amboore i tanga-tangana manga liputa tee i saangua poropinsi i nuncana pamarintamu. Adatina manga incia aposala tee adatina manga lipu mosagaanana tee manga incia inda aose parintana rajana. Jadi, inda alaenga ande utaroaka manga incia apewau saincana. ");
INSERT INTO wlo_vpl VALUES ("ET3_9","018_3_9","EST","3","9","9","Ande ukamatea amalape ifikirimu, salabhina upalimbaakamea sura parinta to upabinasaaka manga incia. Iaku bhekupomea 340.000 kilo pera to manga pagawe moʼurusuna giu incia sumai, mamudhaakana manga pagawe sumai apapesuaia o pera sumai i nuncana dhingkanana doina Raja.\" ");
INSERT INTO wlo_vpl VALUES ("ET3_10","018_3_10","EST","3","10","10","Sarangona giu incia sumai, o raja ahobutimo singkaruna minaaka i kauna limana to apamembalia capu to apasahaaka manga kambotu tee adhawuakea i Haman bin Hamedata, miana Agag, musuna miana Yahudi sumai. ");
INSERT INTO wlo_vpl VALUES ("ET3_11","018_3_11","EST","3","11","11","Pogauna raja i Haman, \"Pera tee lipu sumai kudhawuakako. Upewaumo opea iabhimu amalape to manga incia.\" ");
INSERT INTO wlo_vpl VALUES ("ET3_12","018_3_12","EST","3","12","12","Sabutuna akembamea manga jurutulisina raja i eo sapulu talu eona i bula bhaa-bhaana. Mboomo bhari-bharia iparintaakana Haman, manga incia uka aburi sura to manga wakilina raja, manga gubernuru mokapalaina saasaangu poropinsi tee manga kaogesana saasaangu lipu. Antona sura sumai atoburi i nuncana sumbesumbere pogau tee kaburina manga poropinsi sumai. Sura sumai atoburi tee sarona Raja Ahasweros tee acapuakea tee singkaruna raja. ");
INSERT INTO wlo_vpl VALUES ("ET3_13","018_3_13","EST","3","13","13","Manga sura sumai abhawea tee alambokoa madhei alaloi manga pande angkuna sura i saangua poropinsi. Antona sura sumai satotuuna o parinta to apahancuru, apekamate, tee apabinasa bhari-bharia miana Yahudi minaaka i momangurana sakawana i mancuana, tee uka manga anana tee manga bhawine i nuncana saeo uka, siitumo i eo sapulu talu eona i bula sapulu rua mbulana, i bula Adar, tee arampasi harataa pewauana manga incia. ");
INSERT INTO wlo_vpl VALUES ("ET3_14","018_3_14","EST","3","14","14","Antona sura incia sumai tabeana apamembalia tutura i saasaangu poropinsi tee apakolelea i bhari-bharia lipu mamudhaakana manga incia asiapu ande akawa eo incia sumai. ");
INSERT INTO wlo_vpl VALUES ("ET3_15","018_3_15","EST","3","15","15","Manga pande angkuna sura apoagori alingka abhawa manga sura sumai i bhari-bharia poropinsi mboomo parintana raja, kasiimpo tutura sumai apakoleleakea uka i bentena Susan. Wakutuuna raja tee Haman tangasaana auncura asumpu, abagoeamo miana Kota Susan sarangona lele incia sumai. ");
INSERT INTO wlo_vpl VALUES ("ET4_1","018_4_1","EST","4","1","1","Samatauna bhari-bharia opea momembalina, sumaimo Mordekhai abhenci pakeana, kasiimpo incia akumuti karona tee kae kadhu tee adhika ngawu i bhaana roonamo amaporo. Incia alingka apekatii-tii i kota apoose akakee-kee tee suara makaa tee amaasi. ");
INSERT INTO wlo_vpl VALUES ("ET4_2","018_4_2","EST","4","2","2","Sakawana i aroana bhambana lawana maligena raja, Mordekhai auntomo, roonamo inda amembali o mia apesua i bhambana lawana maligena raja ande apake kae kadhu. ");
INSERT INTO wlo_vpl VALUES ("ET4_3","018_4_3","EST","4","3","3","I saasaangu poropinsi, i tampa iapaipo parinta tee tuturana raja sumai akawa, dhaangia tee kasukara momaoge i tanga-tangana miana Yahudi apoose apoasa, atangi, tee amaasi. Abhari o mia mobhakesakana kae kadhu tee ngawu to kalempesina koleana. ");
INSERT INTO wlo_vpl VALUES ("ET4_4","018_4_4","EST","4","4","4","Wakutuuna manga kabuabua molaianina i malige tee manga pagawe hususuna Ester aumba apaumbaakea opea ipewauna Mordekhai, amarewumo mpuu incana ratu. Incia alamboko pakea i Mordekhai to apakea to kabholosina kae kadhu i badana, maka Mordekhai inda atarimaia. ");
INSERT INTO wlo_vpl VALUES ("ET4_5","018_4_5","EST","4","5","5","Kasiimpomo Ester akemba Hatah, sala samia pagawe hususuna raja isusuna to alaiania. Atumpumea o Hatah to apokawa tee Mordekhai to amatauaka opea momembalina tee opea sababuna. ");
INSERT INTO wlo_vpl VALUES ("ET4_6","018_4_6","EST","4","6","6","Kasiimpo Hatah alingka apokawa tee Mordekhai i tanalapana kota modhaangiana i aroana bhambana lawana maligena raja. ");
INSERT INTO wlo_vpl VALUES ("ET4_7","018_4_7","EST","4","7","7","Mordekhai uka apetulatulaakea i incia sagala giu inamisina tee saopea kabharina pera ijanjiakana Haman to adhawuaka Ahasweros mamudhaakana o raja atumpu apabinasa miana Yahudi. ");
INSERT INTO wlo_vpl VALUES ("ET4_8","018_4_8","EST","4","8","8","Mordekhai uka adhawuaka Hatah o kaburina tutura motopakolelena i Susan mokoantoakana parinta to apabinasaaka miana Yahudi. Mordekhai uka atumpu Hatah to adhawuaka kasamea incia sumai i Ester mamudhaakana o Ester alingka apokawa tee raja to aemani kaasi to lipuna. ");
INSERT INTO wlo_vpl VALUES ("ET4_9","018_4_9","EST","4","9","9","Kasiimpo Hatah alingka apokawa tee Ester to apakawaaka kasameana Mordekhai sumai. ");
INSERT INTO wlo_vpl VALUES ("ET4_10","018_4_10","EST","4","10","10","Kasiimpo Ester atumpu Hatah apakawaaka kasamea incia sii i Mordekhai, ");
INSERT INTO wlo_vpl VALUES ("ET4_11","018_4_11","EST","4","11","11","\"Bhari-bharia pagawena raja tee raʼeati modhaangiana i bhari-bharia poropinsi i nuncana pamarinta sii amataua, tangkanamo saangu o tutura to bhari-bharia umane atawa o bhawine mopesuana mopoarona tee raja i nuncana malige ande o mia sumai inda akembaia raja: sumaimo mia incia sumai bheatohukumu mate. Maka ande o raja apaulu katuko bulawana i mia mopoarona tee incia, sumaimo incia bheasalaamati. Maka iaku talu pulu eomo indapo uka akembaaku kupesua kupoaro tee raja.\" ");
INSERT INTO wlo_vpl VALUES ("ET4_12","018_4_12","EST","4","12","12","Wakutuuna pogauna Ester sumai apaumbaakea i Mordekhai, ");
INSERT INTO wlo_vpl VALUES ("ET4_13","018_4_13","EST","4","13","13","sumaimo Mordekhai atumpu apakawaakea o kasamea incia sii to Ester, \"Bholi ufikiria roonamo udhaangia i nuncana maligena raja, soomo ingkoo moʼamanina minaaka i tanga-tangana bhari-bharia miana Yahudi. ");
INSERT INTO wlo_vpl VALUES ("ET4_14","018_4_14","EST","4","14","14","Ande sii-sii ingkoo inda ukoʼuu, sumaimo o kalalesa tee katulungi bheaumba to miana Yahudi minaaka i tampa mosagaanana, maka ingkoo tee manga witinaimu bheubinasa. Aipomo tee kadhaangia mboo sii mbakanamo ingkoo utopili umembali ratu.\" ");
INSERT INTO wlo_vpl VALUES ("ET4_15","018_4_15","EST","4","15","15","Kasiimpomo Ester alamboko kalawani incia sii i Mordekhai, ");
INSERT INTO wlo_vpl VALUES ("ET4_16","018_4_16","EST","4","16","16","\"Lingkamo romusakamea bhari-bharia miana Yahudi modhaangiana i Susan tee upoasamo tee udoʼamo to iaku. Bholi ukande tee usumpu kangengena talu eo talu malo. Iaku tee manga kabuabua molaianina i maligeku uka bhekupoasa mboo sumai, kasiimpo iaku bhekupesua to kupoaro tee raja moomini o giu incia sumai inda apokana tee tutura. Ande roonamo giu incia sumai iaku bhekubinasa, taroakamo kubinasaaka.\" ");
INSERT INTO wlo_vpl VALUES ("ET4_17","018_4_17","EST","4","17","17","Sabutuna alingkamo Mordekhai tee apewaua bhari-bharia isameaakana Ester to incia. ");
INSERT INTO wlo_vpl VALUES ("ET5_1","018_5_1","EST","5","1","1","I eo talu eona, Ester apakana pakeana ratuna, kasiimpo akabhale-bhale i tanalapa i nuncana malige tee apoaro i maligena raja. Raja tangasaana auncura i bhawona kauncuramakana pamarintana i nuncana malige apoaro tee bhambana lawana malige sumai. ");
INSERT INTO wlo_vpl VALUES ("ET5_2","018_5_2","EST","5","2","2","Wakutuuna raja akamata Ratu Ester akabhale-bhale i tanalapa, Ester abhawa kaasi tee rahumati i matana raja, sabutuna raja apaulu katuko bulawana i incia. Kasiimpo Ester apasari tee adhingku lolona katuko sumai. ");
INSERT INTO wlo_vpl VALUES ("ET5_3","018_5_3","EST","5","3","3","Kasiimpo aabhamo raja, \"Opea ipeelomu, tee opea iemanimu? Moomini uemani samuntanga minaaka i pamarintaku bhekudhawuakako uka.\" ");
INSERT INTO wlo_vpl VALUES ("ET5_4","018_5_4","EST","5","4","4","Ester alawani, \"Ande ufikiria amalape, uumbamo eo sii tee Haman i kariaa ipadhaangiaku to Raja.\" ");
INSERT INTO wlo_vpl VALUES ("ET5_5","018_5_5","EST","5","5","5","Sumaimo raja adhawu parinta, \"Tumpua o Haman aumba madhei, mamudhaakana ingkami tamembali talingka i kariaana Ester.\" Kasiimpo raja tee Haman aumba i kariaa ipadhaangiana Ester. ");
INSERT INTO wlo_vpl VALUES ("ET5_6","018_5_6","EST","5","6","6","Tangasaana asumpu angguru, raja apogau tee Ester, \"Opea ipeelumu? Dhaanamo bhekudhawuakako. Opea iemanimu? Moomini samuntanga minaaka i pamarintaku uka bhekupadhaangiaakako.\" ");
INSERT INTO wlo_vpl VALUES ("ET5_7","018_5_7","EST","5","7","7","Ester alawani, \"Ipeeluku tee iemaniku siitumo, ");
INSERT INTO wlo_vpl VALUES ("ET5_8","018_5_8","EST","5","8","8","ande umaasiakaaku tee ufikiria amalape, tee uperangoi opea iemaniku sumai, maasangia uunda uumba uka pendua i kariaa bheipadhaangiaku to Raja tee Haman. Naile iaku bhekulawania opea bheiemaniku to Raja.\" ");
INSERT INTO wlo_vpl VALUES ("ET5_9","018_5_9","EST","5","9","9","I eo incia sumai uka Haman alimba minaaka i kariaana Ratu Ester akaunde-unde tee amasanaa incana. Maka wakutuuna Haman akamata Mordekhai i bhambana lawana maligena raja inda akakaro atawa asuju ahoromatia, sumaimo incia aʼamaramo mpuu tee incia. ");
INSERT INTO wlo_vpl VALUES ("ET5_10","018_5_10","EST","5","10","10","Moomini mboo sumai, Haman akoʼiimani kasiimpo ambuli i bhanuana. Haman akemba manga sabhangkana tee bhawinena mokosarona Zeres to aumba auncura apobhawa tee incia. ");
INSERT INTO wlo_vpl VALUES ("ET5_11","018_5_11","EST","5","11","11","Kasiimpo Haman apetulatula i manga incia tee asomboaka karangkaeana, kabharina o ana umanena, tee sagala kaogesana idhawuakana raja i incia tee kauncuramakana molabhina kalangana mpuu minaaka i manga kaogesa tee pagawena raja mosagaanana. ");
INSERT INTO wlo_vpl VALUES ("ET5_12","018_5_12","EST","5","12","12","Haman apogau uka, \"Mencuana soo sumai, Ratu Ester inda aundaaka samia uka moumbana apobhawa tee raja i kariaa i padhaangiana sumai tangkanamo iaku. Naile uka akembaaku kupobhawa tee raja. ");
INSERT INTO wlo_vpl VALUES ("ET5_13","018_5_13","EST","5","13","13","Maka bhari-bharia sii inda akoampadhea to iaku, ande dhaangia kukamata Mordekhai, miana Yahudi sumai, auncura i bhambana lawana maligena raja.\" ");
INSERT INTO wlo_vpl VALUES ("ET5_14","018_5_14","EST","5","14","14","Sarangona incia sumai, Zeres tee bhari-bharia sabhangkana apogau tee incia, \"Tumpumo o mia akarajaa arii kalangana 25 metere tee naile saeona apogau tee raja mamudhaakana Mordekhai aloea i arii incia sumai. Sapadhana upewau mboo sumai, amembalimo ulingka i kariaa tee kalalesana ngangarandamu.\" Pogauna manga incia sumai apeelua o Haman. Sababuna atumpumea manga mia akarajaa arii sumai. ");
INSERT INTO wlo_vpl VALUES ("ET6_1","018_6_1","EST","6","1","1","I malo incia sumai uka o raja inda amembali akole. Sababuna sumai incia atumpu mia aalaakea boku mopetulatulaakana kajadiana pamarintana tee abacaakea i aroana. ");
INSERT INTO wlo_vpl VALUES ("ET6_2","018_6_2","EST","6","2","2","I nuncana boku mopetulatulaakana kajadiana pamarintana sumai dhaangia o kaburi ande Mordekhai padhamo alaporoaka Bigtan tee Teres mohaejatina bhemopekamatena Raja Ahasweros. Manga incia sii pagawena hususuna raja mojaganina bhambana lawana malige. ");
INSERT INTO wlo_vpl VALUES ("ET6_3","018_6_3","EST","6","3","3","Raja aabha, \"Kahoromati tee balasina jasa opea mopadhana idhawuakana to Mordekhai pokaina tee giu incia sumai?\" Manga molaianina raja alawani, \"Incia inda atarima opeopea uka.\" ");
INSERT INTO wlo_vpl VALUES ("ET6_4","018_6_4","EST","6","4","4","Kasiimpo apogaumo o raja, \"Incema minaaka i pagaweku modhaangiana i malige sii- sii?\" Wakutuu incia sumai o Haman siimpo mpuu apesua i aroana bhambana malige, incia bheaposanga i raja to aloeaka Mordekhai i arii mopadhana ipakarona sumai. ");
INSERT INTO wlo_vpl VALUES ("ET6_5","018_6_5","EST","6","5","5","Manga molaianina raja sumai alawani, \"Haman dhaangia i malige tee gauna apoaro tee Raja.\" Pogauna raja, \"Tumpua incia apesua.\" ");
INSERT INTO wlo_vpl VALUES ("ET6_6","018_6_6","EST","6","6","6","Sapesuana o Haman, raja apogau, \"Ande o raja gauna ahoromati mia mosagaanana, opea tabeana momalapena ipewau to mia incia sumai?\" Sumaimo o Haman apogau i nuncana ngangarandana, \"Raja bheadhawu kahoromati maoge i incema uka ande mencuana iaku?\" ");
INSERT INTO wlo_vpl VALUES ("ET6_7","018_6_7","EST","6","7","7","Sabutuna alawanimo o Haman, \"Ande umaasiaka tee uhoromati o mia incia sumai, ");
INSERT INTO wlo_vpl VALUES ("ET6_8","018_6_8","EST","6","8","8","tabeana udhawuakea pakea kaogesamu mopadhana ipakemu tee udhawuakea uka o ajara isawikimu motodhikaakana mahakotana pamarintamu i bhaana. ");
INSERT INTO wlo_vpl VALUES ("ET6_9","018_6_9","EST","6","9","9","Kasiimpo pakea kaogesa tee ajara sumai udhawuakea i limana sala samia minaaka i manga kaogesamu, siitumo i manga lalakina lipu sii, kasiimpo parintaakea o lalaki sii apapakeakea pakea kaogesamu i mia imaasiakamu tee ihoromatimu, tee pasawia i ajara. Sapadhana sumai abhawea apekatii-tiiakea i tangana kota, tee o lalaki sii apoose akagora-gora i aroana, \"Kamatea, mboo siimo atopewau o mia ihoromatina raja!\" ");
INSERT INTO wlo_vpl VALUES ("ET6_10","018_6_10","EST","6","10","10","Kasiimpo apogaumo raja i Haman, \"Umbe! Pekadheimo, alamea pakea tee ajara mboomo ipogauakamu sumai. Pewaumo mboo sumai i Mordekhai mouncurana i bhambana lawana maligena raja sumai. Bholi akura sanganga uka minaaka i bhari-bharia ipogauakamu itu.\" ");
INSERT INTO wlo_vpl VALUES ("ET6_11","018_6_11","EST","6","11","11","Kasiimpo o Haman aala pakeana tee ajara sumai kasiimpo apakeakea o pakea sumai i Mordekhai. Mordekhai asawiki ajara, kasiimpo o Haman apekatii-tiiakea i tanalapana kota apoose akagora-gora i aroana, \"Mboo siimo atopewau o mia ihoromatina raja!\" ");
INSERT INTO wlo_vpl VALUES ("ET6_12","018_6_12","EST","6","12","12","Sapadhana sumai, Mordekhai ambuli i bhambana lawana malige. Maka o Haman akaago-ago ambuli i bhanuana tee asukara tee o bhaana asalibumbua roonamo anamisi atohina. ");
INSERT INTO wlo_vpl VALUES ("ET6_13","018_6_13","EST","6","13","13","Haman apetulatulaakea bhari-bharia inamisina i bhawinena, tee i bhari-bharia sabhangkana. Manga mia makidha tee bhawinena apogau tee Haman, \"Siitumo tandana upepuumo umandawu ataloko Mordekhai, miana Yahudi sumai. Ingkoo inda umembali ubhalia, tee dhaanamo atotuu-totuu bheumandawu i aroana.\" ");
INSERT INTO wlo_vpl VALUES ("ET6_14","018_6_14","EST","6","14","14","Tangasaana manga incia dhaangiapo apogau tee Haman, aumbamo manga pagawe hususuna raja. Lausakamo Haman abhawea apekadhei i kariaa ipadhaangiana Ester. ");
INSERT INTO wlo_vpl VALUES ("ET7_1","018_7_1","EST","7","1","1","Sumaimo aumbamo o raja tee Haman i kariaana Ratu Ester to rua mpearona. ");
INSERT INTO wlo_vpl VALUES ("ET7_2","018_7_2","EST","7","2","2","I wakutuuna manga incia asumpu angguru, raja aabha pendua i Ester, \"Opea buaka ipeelumu, e Ratu Ester? Dhaanamo bhekudhawuakako. Opea buaka iemanimu? Moomini uemani samuntanga minaaka i pamarintaku bhekupadhaangiaakako.\" ");
INSERT INTO wlo_vpl VALUES ("ET7_3","018_7_3","EST","7","3","3","Lawanina Ratu Ester, \"Ande umaasiakaaku, tee ande uunda, siitumo kuemani mamudhaakana upasalaamatimea o inyawaku tee lipuku! ");
INSERT INTO wlo_vpl VALUES ("ET7_4","018_7_4","EST","7","4","4","Iaku tee lipuku tatoaso i mia mohaejatina to manga pamofuna, manga pekamatena, tee manga pabinasana. Ande iaku tee miana lipuku tangkanamo tatoaso to tamembali bhatua umane atawa o bhatua bhawine, dhaanamo iaku inda tee uuʼuuku, roonamo inda kulaenga ande kuheruko tee masala mboo sii. ");
INSERT INTO wlo_vpl VALUES ("ET7_5","018_7_5","EST","7","5","5","Aabhamo Raja Ahasweros i Ratu Ester, \"Incema o mia incia sumai tee iapai o mia mohaejatina mopewauna mboo sumai?\" ");
INSERT INTO wlo_vpl VALUES ("ET7_6","018_7_6","EST","7","6","6","Lawanina Ester, \"Bhali tee musu sumai satotuuna o Haman o mia madhaki sii!\" Sabutuna o Haman amaekamo mpuu i aroana raja tee ratu. ");
INSERT INTO wlo_vpl VALUES ("ET7_7","018_7_7","EST","7","7","7","Raja aʼamara mpuu, kasiimpo akakaro abholi kariaana angguru sumai, kasiimpo alingka i tanalapa i saripina malige. Maka o Haman sadhaadhaa i nuncana malige to aemani i Ratu Ester mamudhaakana incia inda atohukumu, roonamo amataua ande o raja bheapatotapuakea kahukumu mate to incia. ");
INSERT INTO wlo_vpl VALUES ("ET7_8","018_7_8","EST","7","8","8","Wakutuuna raja aminaaka i aroana bhambana malige tee ambuli pendua i tampana kariaana angguru sumai, Haman tangasaana atudhaaka karona i bhangko mokokasoro i tampana Ester auncura. Apekeemo raja, \"Buaka ingkoo dhaangiapo uka ubarani uhumbuni ratu i aroaku tee i nuncana maligeku?\" Sapadhana raja apogau mboo sumai, manga mia molaianina Ester atutubhimo bhaana Haman, siitumo tandana incia bheatohukumu mate. ");
INSERT INTO wlo_vpl VALUES ("ET7_9","018_7_9","EST","7","9","9","Kasiimpo apogaumo o Harbona, sala samia minaaka i manga pagawe hususuna raja sumai, \"I bhanuana Haman dhaangia tee ariina kaloe o kalangana rua pulu lima metere. Haman akarajaaia to aloeaka Mordekhai, mia mopadhana mopasalaamatina inyawana Raja tee opea mopadhana ilaporoakana sumai.\" Pogauna raja, 'Loemea i arii sumai.'\" ");
INSERT INTO wlo_vpl VALUES ("ET7_10","018_7_10","EST","7","10","10","Mboo sumaimo o Haman aloea i arii mopadhana ipakarona to Mordekhai. Kasiimpo sapadhana sumai auntomo amarana raja. ");
INSERT INTO wlo_vpl VALUES ("ET8_1","018_8_1","EST","8","1","1","I eo incia sumai Raja Ahasweros adhawuakea bhari-bharia harataa pewauana Haman, musuna miana Yahudi sumai i Ratu Ester. I wakutuu incia sumai, Ester apaumbaakea ande Mordekhai tolidhana. Sarangona sumai, Mordekhai amembali aumba apoaro tee raja. ");
INSERT INTO wlo_vpl VALUES ("ET8_2","018_8_2","EST","8","2","2","Raja arambasaka singkaru mokocapu mopadhana ialana pendua minaaka i Haman, tee adhawuakea i Mordekhai. Ester uka aangka Mordekhai apamembalia moʼurusuna harataana Haman. ");
INSERT INTO wlo_vpl VALUES ("ET8_3","018_8_3","EST","8","3","3","Sapadhana sumai apogaumo uka Ester tee raja apoose asuju i aena. Tee atangi incia aemani kaasi mamudhaakana o raja apanaindaia o haejati madhakina Haman miana Agag sumai, tee uka manga fikiri madhaki mopadhana ipewauna to miana Yahudi. ");
INSERT INTO wlo_vpl VALUES ("ET8_4","018_8_4","EST","8","4","4","Raja apaulu katuko bulawana i Ester, kasiimpo Ester akakaro i aroana raja. ");
INSERT INTO wlo_vpl VALUES ("ET8_5","018_8_5","EST","8","5","5","Incia apogau, \"Raja, ande amalape ufikiria tee ande umaasiakaaku sabutuna o giu incia sii uabhia abanara tee usatujuia, sumaimo taroakamo uburi sura to upambuliaka pendua manga sura mopadhana iburina Haman bin Hamedata, iburina to apabinasaaka miana Yahudi i bhari-bharia poropinsi i saangua pamarintamu. ");
INSERT INTO wlo_vpl VALUES ("ET8_6","018_8_6","EST","8","6","6","Roonamo iaku inda kumembali kukamata balaa bhemokangkanaina lipuku tee inda kumembali kukamata raʼeatiku tee manga witinaiku atopabinasa!\" ");
INSERT INTO wlo_vpl VALUES ("ET8_7","018_8_7","EST","8","7","7","Pogauna Raja Ahasweros i Ratu Ester tee Mordekhai, \"Satotuuna o harataana Haman padhamo kudhawuakako, tee o Haman uka padhamo kuloea i arii roonamo incia gauna apekamate miana Yahudi. ");
INSERT INTO wlo_vpl VALUES ("ET8_8","018_8_8","EST","8","8","8","Ingkoo amembali uburi sura tee opea iabhimu amalape to miana Yahudi tee upakeakea sarona raja. Capumea o sura sumai tee singkaru capuna raja, roonamo o sura motoburiakana sarona raja tee acapuakea tee singkaru capuna raja inda amembali atopambuli pendua.\" ");
INSERT INTO wlo_vpl VALUES ("ET8_9","018_8_9","EST","8","9","9","I wakutuu incia sumai uka, siitumo i eo rua pulu talu eona i bula talu mbulana, siitumo bula Siwan, Mordekhai akemba manga jurutulisina raja. Mboomo bhari-bharia iparintaakana Mordekhai aburimea o sura sumai to miana Yahudi, tee manga wakilina raja, manga gubernuru, tee manga kaogesana poropinsi minaaka i India sakawana i Etiopia, antona sura sumai atoburi i nuncana sumbesumbere pogau tee kaburina manga poropinsi sumai. Incia uka alamboko sura sumai to miana Yahudi i nuncana pogauna tee kaburina. ");
INSERT INTO wlo_vpl VALUES ("ET8_10","018_8_10","EST","8","10","10","Manga sura sumai atoburi apake sarona Raja Ahasweros tee acapua tee singkaru capuna raja, kasiimpo alambokoa madhei alaloi manga pande angkuna sura mosawina i ajara. Ajara isawikina manga siitumo o ajara momadheina buntulina motodhambaakana hususu to raja. ");
INSERT INTO wlo_vpl VALUES ("ET8_11","018_8_11","EST","8","11","11","I nuncana sura sumai o raja aundaaka miana Yahudi modhaangiana i bhari-bharia kota to aporomusaka tee apotaangiaka inyawana, ande dhaangia o mia atawa o tantara mokoewanga mohumbunina manga incia minaaka i lipu atawa o poropinsi iapaipo uka, sumaimo miana Yahudi amembali apotaangiaka karona. Manga incia amembali aewangi manga tantara sumai tee apekamate bhari-bharia bhalina manga, malape manga bhawine atawa manga anaana, tee arampasi harataa pewauana manga mia mopekahumbunina sumai. ");
INSERT INTO wlo_vpl VALUES ("ET8_12","018_8_12","EST","8","12","12","Parinta sumai tabeana apewaua i nuncana saeomea i saangua poropinsina Raja Ahasweros, siitumo i eo sapulu talu eona i bula sapulu rua mbulana, i bula Adar. ");
INSERT INTO wlo_vpl VALUES ("ET8_13","018_8_13","EST","8","13","13","Antona sura parinta sumai apamembalia tutura i saangua poropinsi tee apakoleleakea i bhari-bharia lipu mamudhaakana o miana Yahudi akojaga-jaga ande akawa o eo to manga incia abalasi i manga musuna. ");
INSERT INTO wlo_vpl VALUES ("ET8_14","018_8_14","EST","8","14","14","Sumaimo manga pande angkuna sura mosawina i ajarana raja uka alingka pekadhei tee akaago-ago aose parintana raja sumai. Tee o tutura sumai uka apalimbaia i nuncana bentena Susan. ");
INSERT INTO wlo_vpl VALUES ("ET8_15","018_8_15","EST","8","15","15","Kasiimpo Mordekhai alimba minaaka i malige tee apake pakea kaogesa waranaa kakanda tee maputi, mahakota bulawa momaoge, tee juba minaaka i kae lenan moʼalusu tee kae wungu. Saangua Kota Susan uka asambo-sambo roonamo akaunde-unde. ");
INSERT INTO wlo_vpl VALUES ("ET8_16","018_8_16","EST","8","16","16","Miana Israel amalalesa o ngangarandana, akaunde-unde, amasanaa tee apokawaaka kahoromati. ");
INSERT INTO wlo_vpl VALUES ("ET8_17","018_8_17","EST","8","17","17","I bhari-bharia poropinsi tee i bhari-bharia kota, iapaipo uka o parinta tee tuturana raja sumai akawa, dhaangia tee kaunde-unde tee kasanaa i tanga-tangana miana Yahudi, dhaangia tee kariaa tee moniʼimatina o eo incia sumai. Tee abhari uka o mia minaaka i lipu mosagaanana apogauaka karona ande manga incia amembalimo miana Yahudi, roonamo manga incia amaeka tee miana Yahudi. ");
INSERT INTO wlo_vpl VALUES ("ET9_1","018_9_1","EST","9","1","1","I eo sapulu talu eona i bula sapulu rua mbulana, siitumo bula Adar, parinta tee tuturana raja bheatopewau. I eo incia sumai manga musuna miana Yahudi aabhia amembali akuasai manga incia, garaaka opea inamu-namuna manga musuna sumai inda apokana tee opea momembalina, maka momembalina siitumo miana Yahudi amembali atalo manga incia. ");
INSERT INTO wlo_vpl VALUES ("ET9_2","018_9_2","EST","9","2","2","Miana Yahudi aporomusaka i bhari-bharia kota modhaangiana i saangua pamarintana Raja Ahasweros to apekamate manga mia mohaejatiakana kadhaki to manga incia. Inda samia uka mobaranina mopoarona tee manga incia, roonamo bhari-bharia lipu amembalimo amaeka tee miana Yahudi. ");
INSERT INTO wlo_vpl VALUES ("ET9_3","018_9_3","EST","9","3","3","Tee bhari-bharia kaogesana poropinsi, manga gubernuru, manga wakilina raja, tee manga pagawena pamarinta ahamba miana Yahudi, roonamo manga incia amaeka mpuu tee Mordekhai. ");
INSERT INTO wlo_vpl VALUES ("ET9_4","018_9_4","EST","9","4","4","Kuasana Mordekhai amaoge mpuu i nuncana maligena raja. Sarona atoresa i saangua poropinsi roonamo kuasana ahandamo amaoge. ");
INSERT INTO wlo_vpl VALUES ("ET9_5","018_9_5","EST","9","5","5","Miana Yahudi atalo manga musuna tee hancu, tee apekamate tee apabinasa bhari-bharia musuna. Manga incia apewau saincana i manga mia mobancia. ");
INSERT INTO wlo_vpl VALUES ("ET9_6","018_9_6","EST","9","6","6","I nuncana bentena Susan uka miana Yahudi apekamate tee apabinasa lima atu mia. ");
INSERT INTO wlo_vpl VALUES ("ET9_7","018_9_7","EST","9","7","7","Manga incia uka apekamate Parsandata, Dalfon, Aspata, ");
INSERT INTO wlo_vpl VALUES ("ET9_8","018_9_8","EST","9","8","8","Porata, Adalya, Aridata, ");
INSERT INTO wlo_vpl VALUES ("ET9_9","018_9_9","EST","9","9","9","Parmasta, Arisai, Aridai, tee Waizata, ");
INSERT INTO wlo_vpl VALUES ("ET9_10","018_9_10","EST","9","10","10","siimo sapulu miaia o anana Haman bin Hamedata, musuna miana Yahudi sumai. Maka moomini mboo sumai miana Yahudi inda arampasi harataa pewauana manga incia. ");
INSERT INTO wlo_vpl VALUES ("ET9_11","018_9_11","EST","9","11","11","I eo incia sumai uka o kabharina mia motopekamatena i bentena Susan atopaumbaaka i raja. ");
INSERT INTO wlo_vpl VALUES ("ET9_12","018_9_12","EST","9","12","12","Pogauna raja i Ratu Ester, \"I nuncana bentena Susan uka o miana Yahudi padhamo apekamate tee apabinasa lima atu mia, atolentu uka tee sapulu miaia anana Haman umane. Inda tamataua uka opea ipewauna manga i poropinsi mosagaanana. Sii-sii, opea uka ipeelumu? Dhaanamo kudhawuakako. Opea uka iemanimu? Dhaanamo kupadhaangiakako.\" ");
INSERT INTO wlo_vpl VALUES ("ET9_13","018_9_13","EST","9","13","13","Ester alawani, \"Ande uabhia amalape, taroakamo naile uka o miana Yahudi momboorena i Susan uundaakea apewau mboomo tutura motopewauna i eo sii, tee sapulu miaia anana Haman umane sumai tabeana uloea i arii.\" ");
INSERT INTO wlo_vpl VALUES ("ET9_14","018_9_14","EST","9","14","14","Kasiimpo raja aparintaakea to apewaua mboo sumai, sumaimo tutura sumai apalimbaia i Susan, sabutuna sapulu miaia anana Haman umane atoloe. ");
INSERT INTO wlo_vpl VALUES ("ET9_15","018_9_15","EST","9","15","15","Miana Yahudi momboorena i Susan aporomusaka uka i eo sapulu pata eona i bula Adar, tee apekamate talu atu mia i Susan. Maka moomini mboo sumai, miana Yahudi inda arampasi harataa pewauana manga incia. ");
INSERT INTO wlo_vpl VALUES ("ET9_16","018_9_16","EST","9","16","16","Miana Yahudi mosagaanana momboorena i manga poropinsi i nuncana pamarinta sumai uka aporomusaka tee apotaangiaka inyawana, tee apaʼamani karona manga minaaka i musuna. Manga incia apekamate 75.000 mia. Maka moomini mboo sumai, miana Yahudi inda arampasi harataa pewauana manga incia. ");
INSERT INTO wlo_vpl VALUES ("ET9_17","018_9_17","EST","9","17","17","Eona kajadia incia sumai i eo sapulu talu eona i bula Adar. Manga incia aunto to apekamate incemapo uka i eo sapulu pata eona i bula incia sumai, tee eo incia sumai ahususuakea to eona kariaa tee eona akaunde-unde. ");
INSERT INTO wlo_vpl VALUES ("ET9_18","018_9_18","EST","9","18","18","Maka o miana Yahudi modhaangiana i Susan aporomusaka rua eo: siitumo i eo sapulu talu eona tee eo sapulu pata eona i bula incia sumai. Manga incia siimpomo aunto i eo sapulu lima eona, kasiimpo eo incia sumai manga incia ahususuakea to eona kariaa tee akaunde-unde. ");
INSERT INTO wlo_vpl VALUES ("ET9_19","018_9_19","EST","9","19","19","Rampaakanamo sumai miana Yahudi i karidhoana, siitumo momboorena i kampo, araraeaaka eo sapulu pata eona i bula Adar sumai amembali eona kariaa tee eona kaunde-unde, tee apamembalia eo malape to apodhawu-dhawu hadia kinande. ");
INSERT INTO wlo_vpl VALUES ("ET9_20","018_9_20","EST","9","20","20","Sapadhana sumai Mordekhai aburimo sagala kajadia sumai tee alamboko sura i bhari-bharia miana Yahudi momboorena i saangua pamarintana Raja Ahasweros, malape momakasuna, atawa momaridhona. ");
INSERT INTO wlo_vpl VALUES ("ET9_21","018_9_21","EST","9","21","21","Antona sura sumai satotuuna o parinta to araraeaaka eo sapulu pata eona tee eo sapulu lima eona i nuncana bula Adar sumai satao-satao. ");
INSERT INTO wlo_vpl VALUES ("ET9_22","018_9_22","EST","9","22","22","Sababuna i eo incia siitumo o miana Yahudi aʼamani minaaka i manga musuna, tee i bula incia siitumo o kasukarana manga incia abhalii amembali kasanaa, tee o eo momaporoakana inca amembali eo momalape. Manga incia tabeana apamembali manga eo incia sumai amembali eona kariaa tee eona kaunde-unde, amembali eo to apodhawu-dhawu kinande tee adhawu sadakaa i manga mia momisikini. ");
INSERT INTO wlo_vpl VALUES ("ET9_23","018_9_23","EST","9","23","23","Miana Yahudi ataʼati parintana Mordekhai sumai tee mboo sumaimo kariaa sumai amembali kananea satao-satao. ");
INSERT INTO wlo_vpl VALUES ("ET9_24","018_9_24","EST","9","24","24","Satotuuna o Haman bin Hamedata, miana Agag, musuna miana Yahudi sumai, padhamo ahaejati to apabinasa miana Yahudi. Incia padhamo abhanaka Pur to aʼundi eona momalape to apahancuru tee apabinasaaka manga incia. ");
INSERT INTO wlo_vpl VALUES ("ET9_25","018_9_25","EST","9","25","25","Maka sapadhana o giu incia sumai apakawaakea i raja, siitumo alaloi surana raja, aparintaakea mamudhaakana o haejati madhaki ipewauna Haman to miana Yahudi sumai apambuliakea to karona samia, tee mamudhaakana incia apoose tee manga anana atoloe i arii. ");
INSERT INTO wlo_vpl VALUES ("ET9_26","018_9_26","EST","9","26","26","Rampaakanamo sumai, eo incia sumai asarongiakea \"Purim.\" Purim sumai o asalana minaaka i pogau \"pur,\" maʼanana 'abhanaka dadu.' Miana Yahudi atarima kasameana antona sura sumai amembali katotapu roonamo bhari-bharia opea mopadhana ikamatana pokaiana tee giu incia sumai tee opea mopadhana inamisina manga incia. ");
INSERT INTO wlo_vpl VALUES ("ET9_27","018_9_27","EST","9","27","27","Sumaimo miana Yahudi atarimaia amembali katotapu tee awaajibu to manga incia, to siwuluna, tee bhari-bharia mia moposaanguna tee manga incia, ande manga incia inda bheamalingu to araraeaaka eo i rua eona incia sumai mboomo mopadhana motoburi tee mopadhana ipatotapuaka satao-satao. ");
INSERT INTO wlo_vpl VALUES ("ET9_28","018_9_28","EST","9","28","28","Eo i rua eona sumai bheatoudhani tee araraeaakea bhari-bharia umuru minaaka i siwulu tee leena samia-samia, minaaka i bhari-bharia kota tee poropinsi. Sabutuna o eona Purim sumai inda bheaila minaaka i tanga-tangana miana Yahudi, tee o mia moudhania inda bheatopadha minaaka i tanga-tangana siwuluna manga incia. ");
INSERT INTO wlo_vpl VALUES ("ET9_29","018_9_29","EST","9","29","29","Kasiimpo Ratu Ester binti Abihail aburi sura tee Mordekhai kamondona rua mpearo pokaiana tee raraeana Purim, sura sumai aburia tee bhari-bharia kuasana mamudhaakana apekatangka o antona sura minaaka i Mordekhai. ");
INSERT INTO wlo_vpl VALUES ("ET9_30","018_9_30","EST","9","30","30","Mordekhai alamboko manga sura sumai to bhari-bharia miana Yahudi i 127 poropinsina Raja Ahasweros. I nuncana manga sura sumai manga incia aemani doʼa mamudhaakana manga miana Yahudi sadhaadhaa aʼamani tee amasanaa. ");
INSERT INTO wlo_vpl VALUES ("ET9_31","018_9_31","EST","9","31","31","Antona sura sumai apatotapuaka manga eona Purim sumai i wakutuu mopadhana ipatotapuakana Mordekhai tee Ratu Ester to manga incia, tee tuaapa mopadhana ipatotapuakana to karona samia manga tee siwuluna. Eona Purim sumai apapokanea tee eona raraea mosagaanana wakutuuna miana Yahudi apoasa tee asukara. ");
INSERT INTO wlo_vpl VALUES ("ET9_32","018_9_32","EST","9","32","32","Mboo sumaimo parintana Ester apatotapuaka eona Purim sumai, kasiimpo o hali incia sumai aburia i nuncana kitabi. ");
INSERT INTO wlo_vpl VALUES ("ET10_1","018_10_1","EST","10","1","1","Raja Ahasweros aparinta raʼeatina tabeana apomea balasitee matamo, bhari-bharia lipu modhaangiana i pamarintana, malape i ati atawa i bhiwina tawo tee uka i manga pulo. ");
INSERT INTO wlo_vpl VALUES ("ET10_2","018_10_2","EST","10","2","2","Bhari-bharia ipewauna momaogena, tee kakidhana Raja Ahasweros tee tulatula to kaogesana idhawuakana raja to Mordekhai, bhari-bharia sumai atoburi i nuncana boku mopetulatulaakana manga kajadiana manga raja i Media tee Persia i zamani i piamo itu. ");
INSERT INTO wlo_vpl VALUES ("ET10_3","018_10_3","EST","10","3","3","Mordekhai miana Yahudi sumai atoparacaea i nuncana pamarintana Raja Ahasweros tee atoangka amembali sapati, siitumo o pangkatina raja saidhe alabhi amalanga minaaka i pangkatina Mordekhai. Incia atokailiili tee atohoromati i tanga-tangana miana Yahudi, tee amaasiakea bhari-bharia witinaina roonamo incia abarani apogau mamudhaakana apasalaamati tee apekalape dhadhina manga miana Yahudi tee siwuluna.");
INSERT INTO wlo_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","Amasanaamo mia inda moosena kaadharina mia madhaki, inda aose mia mokodosa tee inda aposabhangka tee manga mia pande pogauakana mia, ");
INSERT INTO wlo_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","maka mopeeluna moosena hukumuna KAWASANA OPU, tee audhania malo tee eo. ");
INSERT INTO wlo_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","Mia incia sumai bheakohasili i nuncana opeapo ikarajaana. Incia mboomo puuna kau ipombula i bhiwina uwe mosiwulu, akobhake wakutuuna akawa bulaana, tee o tawana inda amalau. ");
INSERT INTO wlo_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","Maka o mia madhaki inda mboo sumai. Manga incia mboomo kulina bhae ipolakaakana ngalu. ");
INSERT INTO wlo_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","Sababuna sumai o mia madhaki bheahukumua Aulataʼala wakutuuna atoʼadili, mboomo uka o mia mokodosa inda bheapapesuaia i nuncana uumatina mobanara. ");
INSERT INTO wlo_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","Sababuna o KAWASANA OPU ajagani mia mobanara, maka o mia madhaki bheabinasa. ");
INSERT INTO wlo_vpl VALUES ("PS2_1","020_2_1","PSA","2","1","1","Opea o sababuna manga lipu atobungke, tee manga raʼeatina lipu ahaejatiaka parakara mosia-sia? ");
INSERT INTO wlo_vpl VALUES ("PS2_2","020_2_2","PSA","2","2","2","Manga rajana dunia sii apasiapuaka karona, tee manga mokenina kuasa apomufakatimo gauna aewangi KAWASANA OPU tee raja ipilina. Pogauna manga incia, ");
INSERT INTO wlo_vpl VALUES ("PS2_3","020_2_3","PSA","2","3","3","\"Mai tabhotukia o kabhokena KAWASANA OPU tee raja ipilina, tee tabhanakea o rabutana manga incia minaaka i ingkita!\" ");
INSERT INTO wlo_vpl VALUES ("PS2_4","020_2_4","PSA","2","4","4","Incia mokokauncuramakana i sorogaa apotawa, Kawasana Opu aele-ele manga incia. ");
INSERT INTO wlo_vpl VALUES ("PS2_5","020_2_5","PSA","2","5","5","I wakutuu incia sumai Kawasana Opu bheafirimani i manga incia tee apatokidha manga incia tee pamuruna, ");
INSERT INTO wlo_vpl VALUES ("PS2_6","020_2_6","PSA","2","6","6","\"Iaku padhamo kulanti rajaku i Sion, i gunuku momangkilona sumai.\" ");
INSERT INTO wlo_vpl VALUES ("PS2_7","020_2_7","PSA","2","7","7","Iaku bhekupogauaka opea mopadhana ipatotapuakana KAWASANA OPU. Incia padhamo afirimaniaku, \"Ingkoomo anaku, i eo sii Iaku kupamembaliko anaku. ");
INSERT INTO wlo_vpl VALUES ("PS2_8","020_2_8","PSA","2","8","8","Emanimo i Iaku, Sumaimo bhekudhawuakako manga lipu to amembali tinaurakamu, tee saangua alamu kupamembalia pewauamu. ");
INSERT INTO wlo_vpl VALUES ("PS2_9","020_2_9","PSA","2","9","9","Ingkoo bheupahancuru manga incia tee katuko ase tee upasakia manga mboomo poluka reo.\" ");
INSERT INTO wlo_vpl VALUES ("PS2_10","020_2_10","PSA","2","10","10","Rampaakanamo sumai, e manga raja, pewaumo aarifu! Tarimamo kaadhari, e manga mokuasaina dunia! ");
INSERT INTO wlo_vpl VALUES ("PS2_11","020_2_11","PSA","2","11","11","Sombamo i KAWASANA OPU tee umaekaia, Rengkumo, tee upekatambe karomiu i aroana raja tee kaunde-unde. ");
INSERT INTO wlo_vpl VALUES ("PS2_12","020_2_12","PSA","2","12","12","Sombamo Incia tee kakatena totona incamu mamudhaakana Incia inda apamuru tee apabinasakomiu i dhala roonamo Incia amasimba mpuu aʼamara. Amasanaamo bhari-bharia mia mopeuluna i Incia! ");
INSERT INTO wlo_vpl VALUES ("PS3_1","020_3_1","PSA","3","1","1","Zaburuna Daud, wakutuu incia apalaiaka karona minaaka i anana mokosarona Absalom. ");
INSERT INTO wlo_vpl VALUES ("PS3_2","020_3_2","PSA","3","2","2","E KAWASANA OPU, abhari mpuu o bhaliku! Abhari mpuu moewangiaku! ");
INSERT INTO wlo_vpl VALUES ("PS3_3","020_3_3","PSA","3","3","3","Abhari o mia mopogauakaaku, \"Aulataʼala amendeu atulungia.\" Sela ");
INSERT INTO wlo_vpl VALUES ("PS3_4","020_3_4","PSA","3","4","4","Maka Ingkoo, e KAWASANA OPU, satotuuna o katangkesiku mojaganiaku, Ingkoomo mopamembaliaku kutohoromati tee mopadhadhina incaku pendua. ");
INSERT INTO wlo_vpl VALUES ("PS3_5","020_3_5","PSA","3","5","5","Iaku kugora kuemani tulungi i KAWASANA OPU, tee Incia alawaniaku minaaka i gununa momangkilo. Sela ");
INSERT INTO wlo_vpl VALUES ("PS3_6","020_3_6","PSA","3","6","6","Iaku kupotidhole kukole, kasiimpo alipa o mataku, tee kubhangu roonamo KAWASANA OPU motukoaku. ");
INSERT INTO wlo_vpl VALUES ("PS3_7","020_3_7","PSA","3","7","7","Iaku inda kumaeka tee rewu-rewuna musu bhemolibuaku minaaka i bhari-bharia rope. ");
INSERT INTO wlo_vpl VALUES ("PS3_8","020_3_8","PSA","3","8","8","Bhangumo, KAWASANA OPU, tulungiaku e Aulataʼalaku! Umbe, Ingkoo ubhebhe naunauna bhari-bharia musuku, tee upekakatu ngincina manga mia madhaki. ");
INSERT INTO wlo_vpl VALUES ("PS3_9","020_3_9","PSA","3","9","9","Kasalaamati aumba minaaka i KAWASANA OPU. Barakatimu to uumatimu! Sela ");
INSERT INTO wlo_vpl VALUES ("PS4_1","020_4_1","PSA","4","1","1","To kapalana molaguna. Tee kagasiana gambusu. Zaburuna Daud. ");
INSERT INTO wlo_vpl VALUES ("PS4_2","020_4_2","PSA","4","2","2","E Aulataʼala, Ingkoomo moewaakaaku, lawaniaku wakutuuna kugora. Ingkoo udhawuaku kalalesa wakutuuna kumaseke. Maasiakaaku tee rangomea o doʼaku! ");
INSERT INTO wlo_vpl VALUES ("PS4_3","020_4_3","PSA","4","3","3","E manga mia, saopea uka o kangengena ingkomiu upekarombu kamuliangiku? Saopea uka o kangengena umaasiaka giu mosia-sia tee upeelo giu inda mobanara? Sela ");
INSERT INTO wlo_vpl VALUES ("PS4_4","020_4_4","PSA","4","4","4","Mataua ande o KAWASANA OPU padhamo apili samia mosaalihina to karona, KAWASANA OPU bhearangoa ande kugora i Incia. ");
INSERT INTO wlo_vpl VALUES ("PS4_5","020_4_5","PSA","4","5","5","Wakutuuna uʼamara, bholimo upewau dosa! Pogaumo i nuncana ngangarandamu i kolemamu, tee bholi tee uuʼuumu. Sela ");
INSERT INTO wlo_vpl VALUES ("PS4_6","020_4_6","PSA","4","6","6","Pasombaakamea o kurubani ipatotapuakana to Aulataʼala, tee uparacaeamo i KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("PS4_7","020_4_7","PSA","4","7","7","Abhari o mia mopogauna, \"Incema bhemosusuakana kalape to ingkita?\" E KAWASANA OPU, taroakamo caheana roumu asuluwi ingkami! ");
INSERT INTO wlo_vpl VALUES ("PS4_8","020_4_8","PSA","4","8","8","Ingkoo upewau incaku akaunde-unde alabhi minaaka i kaunde-undena o mia motaralabhi-labhina timpuana gandum tee angguruna. ");
INSERT INTO wlo_vpl VALUES ("PS4_9","020_4_9","PSA","4","9","9","Tee namisi momasanaa bhekupotidhole, kasiimpo kutokole, sababuna tangkanamo Ingkoo KAWASANA OPU, mopewauna dhadhiku aʼamani! ");
INSERT INTO wlo_vpl VALUES ("PS5_1","020_5_1","PSA","5","1","1","To kapalana molaguna. Tee kagasiana suli. Zaburuna Daud. ");
INSERT INTO wlo_vpl VALUES ("PS5_2","020_5_2","PSA","5","2","2","E KAWASANA OPU, rangoa o pogauku, perangoia ipeenciakaku. ");
INSERT INTO wlo_vpl VALUES ("PS5_3","020_5_3","PSA","5","3","3","Rangoa o goraku kuemani tulungi, e Rajaku tee Aulataʼalaku, roonamo i Ingkoomo iaku kudoʼa. ");
INSERT INTO wlo_vpl VALUES ("PS5_4","020_5_4","PSA","5","4","4","E KAWASANA OPU, i wakutuuna raneeo Ingkoo urango doʼaku, i wakutuuna raneeo kuʼatoro pasombaa to Ingkoo tee kuantaantagi kalawanimu. ");
INSERT INTO wlo_vpl VALUES ("PS5_5","020_5_5","PSA","5","5","5","Ingkoo mencuana Aulataʼala momaasiakana pewauna mia mokodosa; mia madhaki inda amembali amboore i aroamu. ");
INSERT INTO wlo_vpl VALUES ("PS5_6","020_5_6","PSA","5","6","6","Mia mosomboakana karona inda uundaakea adhaangia i aroamu. Ingkoo ubanci bhari-bharia mia mopewauna kadhaki. ");
INSERT INTO wlo_vpl VALUES ("PS5_7","020_5_7","PSA","5","7","7","Ingkoo upabinasa manga mia mogau-gau. Umarikaia ukamata pande pekamatena mia tee pande tipu. ");
INSERT INTO wlo_vpl VALUES ("PS5_8","020_5_8","PSA","5","8","8","Maka rampaakanamo kaasimu inda momabhotu, iaku bhekupesua i nuncana bhanuamu, tee kusuju kusomba kupoaro i bhanuamu momangkilo, tee kumaeka i Ingkoo. ");
INSERT INTO wlo_vpl VALUES ("PS5_9","020_5_9","PSA","5","9","9","E KAWASANA OPU, susuakaaku dhalamu mobanara roonamo manga musuku mojoli-joliaku. Pekakatea o dhalamu i aroaku, mamudhaakana kumembali kuose peeluamu. ");
INSERT INTO wlo_vpl VALUES ("PS5_10","020_5_10","PSA","5","10","10","Sababuna pogauna manga incia inda amembali atoparacaea, i nuncana ngangarandana, manga incia gauna apahancuru mia mosagaanana. Goncona manga incia mboomo koburu moponganga, dhela tee kawujuna manga incia amameko. ");
INSERT INTO wlo_vpl VALUES ("PS5_11","020_5_11","PSA","5","11","11","E Aulataʼala, taroakamo manga incia atanggo kasalahana, bheakangkanai i karona opea mopadhana ihaejatiakana to mia. Padhencua manga incia roonamo abhari o kasalahana, tee manga incia adorohaka i Ingkoo. ");
INSERT INTO wlo_vpl VALUES ("PS5_12","020_5_12","PSA","5","12","12","Maka bhari-bharia mia mopeuluna i Ingkoo bheakaunde-unde, manga incia bheasambo-sambo saʼumurua. Jagania manga mia momaasiakana saromu, mamudhaakana manga incia akaunde-unde i nuncana opea ipewaumu. ");
INSERT INTO wlo_vpl VALUES ("PS5_13","020_5_13","PSA","5","13","13","Sababuna Ingkoomo mobarakatina mia mobanara, e KAWASANA OPU, Ingkoo ujagani manga incia tee kaasimu mboomo katangkesi. ");
INSERT INTO wlo_vpl VALUES ("PS6_1","020_6_1","PSA","6","1","1","To kapalana molaguna, tee kagasiana gambusu. Mboomo lagu: I walu anguna. Zaburuna Daud. ");
INSERT INTO wlo_vpl VALUES ("PS6_2","020_6_2","PSA","6","2","2","E KAWASANA OPU, bholi uhukumuaku i nuncana amaramu, tee bholi uwanduaku i nuncana pamurumu. ");
INSERT INTO wlo_vpl VALUES ("PS6_3","020_6_3","PSA","6","3","3","Maasiakaaku, e KAWASANA OPU, sababuna atopadhamo bukuku, pekatangkaaku roonamo bukuku arengku. ");
INSERT INTO wlo_vpl VALUES ("PS6_4","020_6_4","PSA","6","4","4","Amapii incaku. Bholi upekangenge inda ulawaniaku, e KAWASANA OPU! ");
INSERT INTO wlo_vpl VALUES ("PS6_5","020_6_5","PSA","6","5","5","E KAWASANA OPU, mbulimo, tee utulungiaku minaaka i mate! Pasalaamatiaku roonamo kaasimu molagina. ");
INSERT INTO wlo_vpl VALUES ("PS6_6","020_6_6","PSA","6","6","6","Sababuna i alamuna mia mate Ingkoo indamo utoudhani, tee i nuncana koburu indamo dhaangia uka mosukuruna tee Ingkoo. ");
INSERT INTO wlo_vpl VALUES ("PS6_7","020_6_7","PSA","6","7","7","Iaku kumangule roonamo kapeenciku, samalo-samalo loluku apotiburi abhaho kolemaku. ");
INSERT INTO wlo_vpl VALUES ("PS6_8","020_6_8","PSA","6","8","8","Mataku amarea roonamo kaporona inca, tee amarawu roonamo bhari-bharia bhaliku. ");
INSERT INTO wlo_vpl VALUES ("PS6_9","020_6_9","PSA","6","9","9","Dhencumo minaaka i karoku, e manga mia mopewauna kadhaki, roonamo KAWASANA OPU arangoa o tangiku. ");
INSERT INTO wlo_vpl VALUES ("PS6_10","020_6_10","PSA","6","10","10","KAWASANA OPU arangomea iemaniku tee atarimamea o doʼaku. ");
INSERT INTO wlo_vpl VALUES ("PS6_11","020_6_11","PSA","6","11","11","Bhari-bharia musuku bheanamisi kaea tee atokidha mpuu, manga incia asowo tee apokawaaka kaea sakijamata. ");
INSERT INTO wlo_vpl VALUES ("PS7_1","020_7_1","PSA","7","1","1","Lagu kaporona incana Daud, ilaguakana to KAWASANA OPU roonamo Kus, miana Binyamin sumai. ");
INSERT INTO wlo_vpl VALUES ("PS7_2","020_7_2","PSA","7","2","2","E KAWASANA OPU, e Aulataʼalaku, Ingkoomo peulusaku, pasalaamatiaku tee rambasakaaku minaaka i bhari-bharia mia mopajereaku ");
INSERT INTO wlo_vpl VALUES ("PS7_3","020_7_3","PSA","7","3","3","mamudhaakana manga incia inda apapakiaku mboo singa asoroaku tee abheka-bhekaaku wakutuuna inda dhaangia motulungiaku. ");
INSERT INTO wlo_vpl VALUES ("PS7_4","020_7_4","PSA","7","4","4","E KAWASANA OPU, e Aulataʼalaku, ande kupewau giu incia sii: Ande kupewau inda aʼadili i mia mosagaanana, ");
INSERT INTO wlo_vpl VALUES ("PS7_5","020_7_5","PSA","7","5","5","ande kuhianati sabhangkaku, atawa kurampasi musuku inda tee sababuna, ");
INSERT INTO wlo_vpl VALUES ("PS7_6","020_7_6","PSA","7","6","6","taroakamo musuku apajereaku tee arakoaku, kasiimpo alandalandakiaku i tana, tee adhika kamuliangiku i nuncana ngawu. Sela ");
INSERT INTO wlo_vpl VALUES ("PS7_7","020_7_7","PSA","7","7","7","E KAWASANA OPU bhangumo i nuncana pamurumu, kakaromo to uewangiaka manga musuku! Bhangumo to iaku, roonamo Ingkoomo moʼadilina maanusia. ");
INSERT INTO wlo_vpl VALUES ("PS7_8","020_7_8","PSA","7","8","8","Rombusakamea bhari-bharia lipu i saripimu, tee ukapalaimea manga incia i bhawona kauncuramakamu momalanga. ");
INSERT INTO wlo_vpl VALUES ("PS7_9","020_7_9","PSA","7","9","9","KAWASANA OPU moʼadilina parakarana manga lipu. E KAWASANA OPU, dhawuaku kaʼadili, roonamo ipewauku abanara tee amakate totona incaku. ");
INSERT INTO wlo_vpl VALUES ("PS7_10","020_7_10","PSA","7","10","10","Pauntoa o mia mokodosa apewau momadhakina, tee upekatangkea incana mia mosaalihi, sababuna Ingkoo Aulataʼala mobanara, momatauna incana tee baatinina maanusia. ");
INSERT INTO wlo_vpl VALUES ("PS7_11","020_7_11","PSA","7","11","11","Katangkesiku satotuuna o Aulataʼala, mopasalaamatina mia momakatena totona incana. ");
INSERT INTO wlo_vpl VALUES ("PS7_12","020_7_12","PSA","7","12","12","Aulataʼala satotuuna haakimu mobanara, Incia apamuru saesaeo tee mia mopewauna kadhaki. ");
INSERT INTO wlo_vpl VALUES ("PS7_13","020_7_13","PSA","7","13","13","Ande dhaangia o mia inda motoba, sumaimo Kawasana Opu bheawinto hancuna, tee apasiapu panana. ");
INSERT INTO wlo_vpl VALUES ("PS7_14","020_7_14","PSA","7","14","14","Incia apasiapuaka karona tee ewanga motomateaka, tee akarajaa matana pana mokowaa. ");
INSERT INTO wlo_vpl VALUES ("PS7_15","020_7_15","PSA","7","15","15","Satotuuna o mia incia sumai akokadhumaaka kadhaki, incia abhawa kasega i nuncana karona tee apalaahiri gau-gau. ");
INSERT INTO wlo_vpl VALUES ("PS7_16","020_7_16","PSA","7","16","16","Incia aseli kabhalongko to mia mosagaanana, maka o karona mokotibuna. ");
INSERT INTO wlo_vpl VALUES ("PS7_17","020_7_17","PSA","7","17","17","Jadi incia ahukumua kasegana tee haejatina karona, tee o kasega ipewauna bheapanarakaa karona. ");
INSERT INTO wlo_vpl VALUES ("PS7_18","020_7_18","PSA","7","18","18","Iaku bhekusukuru i KAWASANA OPU roonamo Incia aʼadili, tee kulaguaka kapujia to KAWASANA OPU Momalanga. ");
INSERT INTO wlo_vpl VALUES ("PS8_1","020_8_1","PSA","8","1","1","To kapalana molaguna. Mboomo lagu Gitit. Zaburuna Daud. ");
INSERT INTO wlo_vpl VALUES ("PS8_2","020_8_2","PSA","8","2","2","E KAWASANA OPU, e Aulataʼalamami, saromu amulia i saangua alamu! Kaogesana kuasamu alabhi kalangana minaaka i laiana. ");
INSERT INTO wlo_vpl VALUES ("PS8_3","020_8_3","PSA","8","3","3","Minaaka i ngangana manga anaana momaidhiidhi tee anaana modudu uka apuji kamuliangimu. Roonamo Ingkoo padhamo upakaro bente potaangia momatangka sabutuna o ngangana bhari-bharia musu tee bhalimu atosoncongi. ");
INSERT INTO wlo_vpl VALUES ("PS8_4","020_8_4","PSA","8","4","4","Ande kutonto tee kufikiri laiana ipadhaangiamu, bula tee kalipopo idhikamu, ");
INSERT INTO wlo_vpl VALUES ("PS8_5","020_8_5","PSA","8","5","5","incema buaka o maanusia sumai, mbakana uudhania, incema buaka o incia, mbakana udhambaakea? ");
INSERT INTO wlo_vpl VALUES ("PS8_6","020_8_6","PSA","8","6","6","Maka upewau maanusia saidhepo apokana tee Aulataʼala, upakanaakea tee mahakota kamuliangi tee kahoromati. ");
INSERT INTO wlo_vpl VALUES ("PS8_7","020_8_7","PSA","8","7","7","Udhawua kuasa to saangua alamu, bhari-bharia ipadhaangiamu upatungkua i incia: ");
INSERT INTO wlo_vpl VALUES ("PS8_8","020_8_8","PSA","8","8","8","Dumba, sapi tee bhari-bharia binata kadhambaaka, tee manga binata i rumpu; ");
INSERT INTO wlo_vpl VALUES ("PS8_9","020_8_9","PSA","8","9","9","Manu-manu tee manga ikane bhari-bharia mahaluku i nuncana tawo. ");
INSERT INTO wlo_vpl VALUES ("PS8_10","020_8_10","PSA","8","10","10","E KAWASANA OPU, Aulataʼalamami, saromu amulia i saangua alamu! ");
INSERT INTO wlo_vpl VALUES ("PS9_1","020_9_1","PSA","9","1","1","To kapalana molaguna. Mboomo lagu: Matena Samia Ana. Zaburuna Daud. ");
INSERT INTO wlo_vpl VALUES ("PS9_2","020_9_2","PSA","9","2","2","Iaku bhekusukuru i KAWASANA OPU, tee mpuu-mpuuna incaku; iaku bhekupetulatulaaka bhari-bharia ipewaumu inda momentela. ");
INSERT INTO wlo_vpl VALUES ("PS9_3","020_9_3","PSA","9","3","3","Iaku bhekukaunde-unde tee kumasanaa roonamo Ingkoo; iaku bhekulaguaka manga kapujia roonamo saromu, e KAWASANA OPU Momalanga. ");
INSERT INTO wlo_vpl VALUES ("PS9_4","020_9_4","PSA","9","4","4","Wakutuuna manga musuku asowo, manga incia atosunu tee abinasa i aroamu. ");
INSERT INTO wlo_vpl VALUES ("PS9_5","020_9_5","PSA","9","5","5","Ingkoo uewaaka parakaraku tee hakuku. Ingkoo uhaakimu tee kabanara i bhawona kauncuramakamu. ");
INSERT INTO wlo_vpl VALUES ("PS9_6","020_9_6","PSA","9","6","6","Ingkoo padhamo uhaakimu manga lipu tee upabinasa manga mia madhaki, Ingkoo padhamo uhapusua sarona manga incia to saʼumurua. ");
INSERT INTO wlo_vpl VALUES ("PS9_7","020_9_7","PSA","9","7","7","Manga musu amapupumo atopabinasa, manga incia amofu saʼumurua. Kota-kotana manga incia padhamo upahancurua mboomo ngawu atontalesaka, kaudhania to manga incia uka ailamo. ");
INSERT INTO wlo_vpl VALUES ("PS9_8","020_9_8","PSA","9","8","8","Maka, KAWASANA OPU akokuasa saʼumurua. Incia padhamo apatotapuaka kauncuramakana to aʼadili maanusia. ");
INSERT INTO wlo_vpl VALUES ("PS9_9","020_9_9","PSA","9","9","9","Inciamo bhemohaakimuna dunia sii tee kabanara, Incia ahaakimu manga lipu tee kaʼadili. ");
INSERT INTO wlo_vpl VALUES ("PS9_10","020_9_10","PSA","9","10","10","Sumaimo KAWASANA OPU amembali tampana peulusa to mia motopisaki, tampana peulusa i wakutuuna kanarakaa. ");
INSERT INTO wlo_vpl VALUES ("PS9_11","020_9_11","PSA","9","11","11","Manga mia momatauna saromu adhika kaparacaeana i Ingkoo, roonamo Ingkoo inda ubholi mia mopeelona Ingkoo, e KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("PS9_12","020_9_12","PSA","9","12","12","Lagumo tee pujimo KAWASANA OPU moparintana i Sion! Pakoleleakamea manga pewauna i tanga-tangana manga lipu! ");
INSERT INTO wlo_vpl VALUES ("PS9_13","020_9_13","PSA","9","13","13","Sababuna Incia audhani manga mia monarakaa tee inda amalinguaka gorana mia motopisaki; manga pande pekamatena mia bheabalasia tee ahukumua. ");
INSERT INTO wlo_vpl VALUES ("PS9_14","020_9_14","PSA","9","14","14","E KAWASANA OPU, maasiakaaku; kamatea o kanarakaa ipewauna manga mia mobanciaku, e Aulataʼala pasalaamatiaku minaaka i mate, ");
INSERT INTO wlo_vpl VALUES ("PS9_15","020_9_15","PSA","9","15","15","mamudhaakana amembali kupujiko i bhambana kotana Puteri Sion, siitumo i raʼeatina Yerusalem, roonamo upasalaamatiaku. ");
INSERT INTO wlo_vpl VALUES ("PS9_16","020_9_16","PSA","9","16","16","Manga lipu amandawu i nuncana bhalo mopadhana ikarajaana manga incia, Manga incia apesua i nuncana jari ipasana tee ibuniakana karona. ");
INSERT INTO wlo_vpl VALUES ("PS9_17","020_9_17","PSA","9","17","17","KAWASANA OPU apapematauaka karona, tee aʼadili ahaakimu maanusia. Mia madhaki akana i katapu ikarajaana karona. Sela ");
INSERT INTO wlo_vpl VALUES ("PS9_18","020_9_18","PSA","9","18","18","Manga mia madhaki bheambuli i duniana mia mate, siitumo bhari-bharia lipu momalinguakana Aulataʼala. ");
INSERT INTO wlo_vpl VALUES ("PS9_19","020_9_19","PSA","9","19","19","Maka o mia misikini inda sadia bheatomalinguaka, tee inda saʼumurua bheaila opea iharapuna o mia monarakaa. ");
INSERT INTO wlo_vpl VALUES ("PS9_20","020_9_20","PSA","9","20","20","E KAWASANA OPU, bhangumo. Bholi utaroakea o maanusia akana! Taroakamo manga lipu sumai uʼadilia i aroamu. ");
INSERT INTO wlo_vpl VALUES ("PS9_21","020_9_21","PSA","9","21","21","Pekaekaia manga incia, e KAWASANA OPU! Mamudhaakana manga lipu sumai amataua ande manga incia tangkanamo maanusia. Sela ");
INSERT INTO wlo_vpl VALUES ("PS10_1","020_10_1","PSA","10","1","1","E KAWASANA OPU, pokia Ingkoo upekaridho? Pokia Ingkoo ubuniaka karomu i wakutuuna ingkami tamaseke? ");
INSERT INTO wlo_vpl VALUES ("PS10_2","020_10_2","PSA","10","2","2","Mia madhaki mosombo apajere mia motopisaki, taroakamo manga incia akangkanaia katapuna momadhaki ihaejatiakana karona. ");
INSERT INTO wlo_vpl VALUES ("PS10_3","020_10_3","PSA","10","3","3","Roonamo mia madhaki apuji-puji peeluana incana, tee o mia masoʼo apekatunda tee ahina KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("PS10_4","020_10_4","PSA","10","4","4","Mia madhaki apogau tee kasombo, \"Aulataʼala inda bheatuntua.\" I fikirina tangkanamo, \"Inda dhaangia o Aulataʼala!\" ");
INSERT INTO wlo_vpl VALUES ("PS10_5","020_10_5","PSA","10","5","5","Mia madhaki sadia apotibhaaka sagala ipeeluna. Hukumuna Aulataʼala inda dhaangia o maʼanana to incia. Incia apandaʼente bhari-bharia bhalina. ");
INSERT INTO wlo_vpl VALUES ("PS10_6","020_10_6","PSA","10","6","6","Mia mokodosa apogau i nuncana ngangarandana, \"Iaku sadhaadhaa bhekumatangka, tee saʼumurua inda bheakangkanaiaku balaa.\" ");
INSERT INTO wlo_vpl VALUES ("PS10_7","020_10_7","PSA","10","7","7","Ande apogau, o ngangana abukeaka katunda, gau-gau, tee kapisaki. Incia sadia abhoasaka pogau madhaki tee apekabanci. ");
INSERT INTO wlo_vpl VALUES ("PS10_8","020_10_8","PSA","10","8","8","Incia apekantaa i desa-desa, Apekamate mia inda mosala, i tampa momalino. Incia alukuti mia momalute. ");
INSERT INTO wlo_vpl VALUES ("PS10_9","020_10_9","PSA","10","9","9","Incia apekantaa i tampa momalino Mboomo singa i nuncana rumpu. Incia apekantaa to arako mia motopisaki. Arako mia motopisaki tee apapesuaia i nuncana jarina. ");
INSERT INTO wlo_vpl VALUES ("PS10_10","020_10_10","PSA","10","10","10","Incia aʼungko mamudhaakana apekapapaki, kasiimpo tee kakaana bukuna incia apakotibu mia malute sumai. ");
INSERT INTO wlo_vpl VALUES ("PS10_11","020_10_11","PSA","10","11","11","Pogauna i nuncana ngangarandana, \"Aulataʼala inda afaduliakea, Incia apopiro tee sadia inda akamata opeopea uka.\" ");
INSERT INTO wlo_vpl VALUES ("PS10_12","020_10_12","PSA","10","12","12","E KAWASANA OPU, bhangumo. Hukumumea manga mia madhaki! Bholi umalinguaka mia motopisaki. ");
INSERT INTO wlo_vpl VALUES ("PS10_13","020_10_13","PSA","10","13","13","Apokia manga mia madhaki sadia ahina Aulataʼala? Manga incia apogau i nuncana ngangarandana, \"Ingkoo inda bheutuntua!\" ");
INSERT INTO wlo_vpl VALUES ("PS10_14","020_10_14","PSA","10","14","14","Maka Ingkoo dhaanamo ukamatea, roonamo Ingkoomo mokamatana manga mia mosukara tee mia monarakaa, tee uewaaka parakarana manga incia. Mia momalute apasarakaaka karona i Ingkoo, roonamo Ingkoomo motulungina manga ana maelu. ");
INSERT INTO wlo_vpl VALUES ("PS10_15","020_10_15","PSA","10","15","15","Katukimea o takiona mia mokodosa tee mia madhaki, tuntumea o dosana manga incia, sakawana inda upotibhaakea uka. ");
INSERT INTO wlo_vpl VALUES ("PS10_16","020_10_16","PSA","10","16","16","KAWASANA OPU aparinta saʼumurua, manga lipu inda momatauna Incia bheamofu minaaka i lipuna. ");
INSERT INTO wlo_vpl VALUES ("PS10_17","020_10_17","PSA","10","17","17","E KAWASANA OPU, opea ipeeluna manga mia motopisaki uperangoia. Ingkoo bheupekatangka incana manga incia, tee utaaia o talingamu ");
INSERT INTO wlo_vpl VALUES ("PS10_18","020_10_18","PSA","10","18","18","to uewaaka ana maelu tee mia motopisaki mamudhaakana inda dhaangia o maanusia mopekaekana manga incia. ");
INSERT INTO wlo_vpl VALUES ("PS11_1","020_11_1","PSA","11","1","1","To kapalana molaguna. Zaburuna Daud. Iaku kupeulu i KAWASANA OPU; inda tee faʼedana upogau tee iaku, \"Pasalaamatimea o karomu mboomo manu-manu mopolakana i gunu. ");
INSERT INTO wlo_vpl VALUES ("PS11_2","020_11_2","PSA","11","2","2","Roonamo mia madhaki apekangkanamo panana tee apasa matana panana to apana mia momakatena incana i tampa momalalanda. ");
INSERT INTO wlo_vpl VALUES ("PS11_3","020_11_3","PSA","11","3","3","Ande o tuturana raʼeatina atopahancuru, mia mobanara inda amembali apewau opeopea.\" ");
INSERT INTO wlo_vpl VALUES ("PS11_4","020_11_4","PSA","11","4","4","KAWASANA OPU dhaangia i nuncana Baitulla momangkilo, kauncuramakana KAWASANA OPU dhaangia i sorogaa. Incia atiliki maanusia tee amataua sabhara ipewauna manga incia. ");
INSERT INTO wlo_vpl VALUES ("PS11_5","020_11_5","PSA","11","5","5","KAWASANA OPU auji mia mobanara tee mia madhaki, Incia abanci mia mopewauna kasega. ");
INSERT INTO wlo_vpl VALUES ("PS11_6","020_11_6","PSA","11","6","6","Incia bheapadhaangia balaa to mia madhaki tee apasapoakea tee waa morore tee walera, tee ngalu imangauaka siitumo to kahukumuna mia madhaki. ");
INSERT INTO wlo_vpl VALUES ("PS11_7","020_11_7","PSA","11","7","7","Sababuna KAWASANA OPU aʼadili, Incia amaasiaka kabanara. Mia momakatena incana bheakamata tee bheamatau Incia. ");
INSERT INTO wlo_vpl VALUES ("PS12_1","020_12_1","PSA","12","1","1","To kapalana molaguna. Mboomo lagu: I walu anguna. Zaburuna Daud. ");
INSERT INTO wlo_vpl VALUES ("PS12_2","020_12_2","PSA","12","2","2","E KAWASANA OPU, manga tulungipo, sababuna indamo dhaangia mia mosaalihi, manga mia motaʼatina tee Ingkoo indamo dhaangia. ");
INSERT INTO wlo_vpl VALUES ("PS12_3","020_12_3","PSA","12","3","3","Manga incia bhari-bharia aposapopagau-gau, podho-podho manga incia; dhelana manga incia apekapuji, maka o ngangarandana apekatipu. ");
INSERT INTO wlo_vpl VALUES ("PS12_4","020_12_4","PSA","12","4","4","Maasangia o KAWASANA OPU adhodho bhari-bharia bhiwina manga mia momamekona pogauna tee dhelana manga mia mosombo. ");
INSERT INTO wlo_vpl VALUES ("PS12_5","020_12_5","PSA","12","5","5","Manga incia apogau, \"Ingkami takokuasa tee pogau ibhoasakamami! Ingkami tatangkaaka bhiwimami! Inda dhaangia mojoli-jolina ingkami!\" ");
INSERT INTO wlo_vpl VALUES ("PS12_6","020_12_6","PSA","12","6","6","Firimanina KAWASANA OPU, \"Roonamo mia maidhiidhi atopisaki tee mia misikini apeenci roonamo anarakaa, sabutuna sii-sii kuumba kudhawua kaʼamani mboomo ipeeluna manga incia. ");
INSERT INTO wlo_vpl VALUES ("PS12_7","020_12_7","PSA","12","7","7","KAWASANA OPU abhoasaka pogau momangkilo wakutuuna Incia apojanji. Janjina amatangka mpuu, mboomo pera asilii motorabuna pitu mpearo i nuncana waa. ");
INSERT INTO wlo_vpl VALUES ("PS12_8","020_12_8","PSA","12","8","8","E KAWASANA OPU, Ingkoo bheujagani ingkami minaaka i manga mia madhaki sii. Ingkoo ujagani ingkami sadia to saʼumurua. ");
INSERT INTO wlo_vpl VALUES ("PS12_9","020_12_9","PSA","12","9","9","Mia madhaki pekawulu-wulu iapai-iapai tee abarani roonamo kadhakina aabhia atopuji i tanga-tangana anana maanusia. ");
INSERT INTO wlo_vpl VALUES ("PS13_1","020_13_1","PSA","13","1","1","To kapalana molaguna. Zaburuna Daud. ");
INSERT INTO wlo_vpl VALUES ("PS13_2","020_13_2","PSA","13","2","2","Sakawana naepia, e KAWASANA OPU? Saʼumurua buaka Ingkoo umalinguakaaku? Sakawana naepia Ingkoo ubuniaka roumu minaaka i karoku? ");
INSERT INTO wlo_vpl VALUES ("PS13_3","020_13_3","PSA","13","3","3","Sakawana naepia kutanggo kanarakaa i nuncana karoku? Saeoa amaporo incaku. Sakawana naepia akuasaiaku musuku? ");
INSERT INTO wlo_vpl VALUES ("PS13_4","020_13_4","PSA","13","4","4","E KAWASANA OPU, Aulataʼalaku, kamatea tee ulawaniakumo. Pekatangkea o bukuku mamudhaakana inda kumate! ");
INSERT INTO wlo_vpl VALUES ("PS13_5","020_13_5","PSA","13","5","5","Bholi utaroakea o musuku apogau, \"Kutalomea!\" Tee o bhaliku akaunde-unde wakutuuna kusindoli. ");
INSERT INTO wlo_vpl VALUES ("PS13_6","020_13_6","PSA","13","6","6","Maka kuparacaea o kaasimu molagina, Incaku akaunde-unde roonamo upasalaamatiaku. Iaku gauku kulagu to KAWASANA OPU roonamo Incia padhamo apewau kalape tee iaku! ");
INSERT INTO wlo_vpl VALUES ("PS14_1","020_14_1","PSA","14","1","1","To kapalana molaguna. Zaburuna Daud. Mia mokabhongo-bhongo apogau i nuncana ngangarandana, \"Inda dhaangia o Aulataʼala.\" Pewauna manga incia amadhaki tee atomarika, inda dhaangia mopewauna kalape. ");
INSERT INTO wlo_vpl VALUES ("PS14_2","020_14_2","PSA","14","2","2","Minaaka i sorogaa KAWASANA OPU atonto anana maanusia, to akamata ara dhaangia o mia moʼaarifu, mopeelona Aulataʼala. ");
INSERT INTO wlo_vpl VALUES ("PS14_3","020_14_3","PSA","14","3","3","Bhari-bharia mia abholi dhala mobanara tee akarajaa giu momadhaki. Inda dhaangia mopewauna kalape, moomini samia uka. ");
INSERT INTO wlo_vpl VALUES ("PS14_4","020_14_4","PSA","14","4","4","Firimanina Aulataʼala, \"Buaka apesua i akala, ande bhari-bharia mia mopewauna kadhaki inda amatau giu momalape? Manga incia apekaoge karona tee akande uumatiku mboomo akande roti, tee inda adoʼa i Iaku.\" ");
INSERT INTO wlo_vpl VALUES ("PS14_5","020_14_5","PSA","14","5","5","Iwe sumai manga incia bheamaeka mpuu roonamo Aulataʼala atulungi uumatina mobanara. ");
INSERT INTO wlo_vpl VALUES ("PS14_6","020_14_6","PSA","14","6","6","Ingkomiu bheupekaea haejatina mia motopisaki, maka o KAWASANA OPU amembali peulusana manga incia. ");
INSERT INTO wlo_vpl VALUES ("PS14_7","020_14_7","PSA","14","7","7","Maasangia kasalaamati to miana Israel aumba minaaka i Sion, kotana Aulataʼala! Wakutuuna KAWASANA OPU apambuli kadhaangiana uumatina, siwuluna Yakub bheamasanaa o namisina tee o Israel bheakaunde-unde. ");
INSERT INTO wlo_vpl VALUES ("PS15_1","020_15_1","PSA","15","1","1","Zaburuna Daud. E KAWASANA OPU, incema momembalina mobutuna i Kemamu Momangkilo? Incema momembalina momboorena i gunumu momangkilo? ");
INSERT INTO wlo_vpl VALUES ("PS15_2","020_15_2","PSA","15","2","2","Siitumo mia modhadhina inda tee kasalahana, mopewauna kalape, tee mopogauakana mototuuna tee incia apogau tee mpuu-mpuuna incana. ");
INSERT INTO wlo_vpl VALUES ("PS15_3","020_15_3","PSA","15","3","3","Manga incia inda afitanaa tee dhelana, inda apewau kadhaki i sabhangkana, tee inda apekadhaki sarona sarimbanuana. ");
INSERT INTO wlo_vpl VALUES ("PS15_4","020_15_4","PSA","15","4","4","Manga incia inda mohoromatina manga mia inda itarimana Aulataʼala, maka ahoromati mia momaekana KAWASANA OPU, motaʼatina janjina, moomini amarugi. ");
INSERT INTO wlo_vpl VALUES ("PS15_5","020_15_5","PSA","15","5","5","Manga incia apekapaadhaaka doina tee inda aala laba, tee inda atarima kasogo to aewangi mia inda mosala. Mia mopewauna mboo sumai bheamasanaa tee aʼamani saʼumurua. ");
INSERT INTO wlo_vpl VALUES ("PS16_1","020_16_1","PSA","16","1","1","Miktam. Zaburuna Daud. E Aulataʼala, jaganiaku roonamo Ingkoomo peulusaku. ");
INSERT INTO wlo_vpl VALUES ("PS16_2","020_16_2","PSA","16","2","2","Iaku kupogau i KAWASANA OPU, \"Ingkoomo Kawasana Opuku, inda dhaangia momalapena to iaku, tangkanamo Ingkoo.\" ");
INSERT INTO wlo_vpl VALUES ("PS16_3","020_16_3","PSA","16","3","3","Mia momangkilo modhaangiana i alamu, manga inciamo o mia momulia mosadiana ipeeluku. ");
INSERT INTO wlo_vpl VALUES ("PS16_4","020_16_4","PSA","16","4","4","Kanarakaana manga mia mosombana dewa mosagaanana bheahanda kabharina. Iaku inda bhekulali pasombaana raana kurubanina manga incia, atawa uka kusarongi sarona manga dewa mosagaanana i bhiwiku. ");
INSERT INTO wlo_vpl VALUES ("PS16_5","020_16_5","PSA","16","5","5","E KAWASANA OPU, tangkanamo Ingkoo o pusakaku, Ingkoomo motantuakana dhalana dhadhiku, Ingkoomo mokenina katooku. ");
INSERT INTO wlo_vpl VALUES ("PS16_6","020_16_6","PSA","16","6","6","Ingkoomo modhawuaku manga giu momakesa satotuuna kadhawumu sumai mopaunde-undeaku. ");
INSERT INTO wlo_vpl VALUES ("PS16_7","020_16_7","PSA","16","7","7","Iaku kupuji KAWASANA OPU, mopadhana moudhaniakaaku; i wakutuuna malo baatiniku aadhariaku. ");
INSERT INTO wlo_vpl VALUES ("PS16_8","020_16_8","PSA","16","8","8","Iaku sadia kuudhani KAWASANA OPU; Incia dhaangia i saripiku, rampaakanamo sumai kumatangka. ");
INSERT INTO wlo_vpl VALUES ("PS16_9","020_16_9","PSA","16","9","9","Sababuna sumai, incaku amasanaa tee ngangarandaku akaunde-unde, badaku aponiunto tee kuʼamani. ");
INSERT INTO wlo_vpl VALUES ("PS16_10","020_16_10","PSA","16","10","10","Sababuna Ingkoo inda utaroakaaku kumate, mia mosaalihi inda utaroakea abinasa. ");
INSERT INTO wlo_vpl VALUES ("PS16_11","020_16_11","PSA","16","11","11","Upaumbaakaaku dhala moporopena i dhadhi imalapeaka, i aroamu abhari mpuu kasanaa, i lima kaanamu dhaangia kasanaa to saʼumurua. ");
INSERT INTO wlo_vpl VALUES ("PS17_1","020_17_1","PSA","17","1","1","Doʼana Daud. E KAWASANA OPU, maasangia uperangoi parakara mobanara. Tilikia o goraku! Perangoia o doʼaku, molimbana minaaka i bhiwiku mojujuruna sii. ");
INSERT INTO wlo_vpl VALUES ("PS17_2","020_17_2","PSA","17","2","2","Taroakamo kambotuna parakaraku aumba minaaka i Ingkoo, roonamo matamu akamata kabanara. ");
INSERT INTO wlo_vpl VALUES ("PS17_3","020_17_3","PSA","17","3","3","Ande Ingkoo uuji ngangarandaku, tee uumba utilikiaku i wakutuuna amalo, ande uujiaku mboomo mia moujina bulawa, sumaimo Ingkoo inda bheupotibhaaka kadhaki i nuncana karoku. Iaku padhamo kuneati mamudhaakana inda kubhoasaka manga pogau mosala, mboomo ipewauna manga mia mosagaanana. ");
INSERT INTO wlo_vpl VALUES ("PS17_4","020_17_4","PSA","17","4","4","Alaloi firimani ipakawaakamu, iaku padhamo kujagani karoku minaaka i dhalana manga mia mopewauna kasega. ");
INSERT INTO wlo_vpl VALUES ("PS17_5","020_17_5","PSA","17","5","5","Bhengkalaku sadhaadhaa aose dhalamu, tee o aeku inda asindoli. ");
INSERT INTO wlo_vpl VALUES ("PS17_6","020_17_6","PSA","17","6","6","Iaku kugora i Ingkoo roonamo Ingkoo bheulawaniaku, e Aulataʼala. Perangoiaku, rangoa manga pogauku. ");
INSERT INTO wlo_vpl VALUES ("PS17_7","020_17_7","PSA","17","7","7","Susuakaaku o kaasimu molagina inda momentela sumai! Lima kaanamu mopasalaamatina manga mia mopeuluna i Ingkoo minaaka i musuna. ");
INSERT INTO wlo_vpl VALUES ("PS17_8","020_17_8","PSA","17","8","8","Jaganiaku mboomo opea imaasiakamu, jaganiaku mboomo inana manu-manu mojaganina anana i nuncana panina ");
INSERT INTO wlo_vpl VALUES ("PS17_9","020_17_9","PSA","17","9","9","minaaka i mia madhaki bhemopabinasaaku, siitumo manga musu molibuaku to mopekamateaku. ");
INSERT INTO wlo_vpl VALUES ("PS17_10","020_17_10","PSA","17","10","10","Manga incia inda tee kaasina incana, tee abhoasaka pogau mosombo. ");
INSERT INTO wlo_vpl VALUES ("PS17_11","020_17_11","PSA","17","11","11","Sii-sii manga incia aose bhengkalaku to alibuaku, apeelo dhala to arambitakaaku i tana. ");
INSERT INTO wlo_vpl VALUES ("PS17_12","020_17_12","PSA","17","12","12","Manga incia mboomo singa mopapakina kinandena, mboomo singa mangura mopekantaana i tampa momalino. ");
INSERT INTO wlo_vpl VALUES ("PS17_13","020_17_13","PSA","17","13","13","E KAWASANA OPU, bhangumo. Poaroakamea tee upekatalomea manga incia! Pasalaamatiaku tee ewangamu minaaka i manga mia madhaki, ");
INSERT INTO wlo_vpl VALUES ("PS17_14","020_17_14","PSA","17","14","14","e Kawasana Opu, pasalaamatiaku tee limamu minaaka i manga mia madhaki, minaaka i manga mia soo mofaduliakana harataana dunia. Maka pekambosua manga mia imaasiakamu. Maasangia manga anana atumpu incana tee abholi tinaurakana to manga siwuluna. ");
INSERT INTO wlo_vpl VALUES ("PS17_15","020_17_15","PSA","17","15","15","Roonamo kubanara, iaku bhekutonto roumu, tee wakutuuna kubhangu, bheatumpu incaku roonamo kudhaangiapo i saripimu. ");
INSERT INTO wlo_vpl VALUES ("PS18_1","020_18_1","PSA","18","1","1","To kapalana molaguna. Minaaka i bhatuana KAWASANA OPU, siitumo o Daud, mopakawaakana lagu incia sii to KAWASANA OPU, wakutuuna KAWASANA OPU arambasaka Daud minaaka i limana Saul tee minaaka i manga musuna. Incia apogau, ");
INSERT INTO wlo_vpl VALUES ("PS18_2","020_18_2","PSA","18","2","2","\"Iaku kumaasiakako, e KAWASANA OPU, kakaaku! ");
INSERT INTO wlo_vpl VALUES ("PS18_3","020_18_3","PSA","18","3","3","KAWASANA OPU mboomo kabumbuna bhatuku, bente potaangiaku, tee mopabebasiaku. Aulataʼala isombaku mboomo gunu bhatu, tee kupeulu i Incia. Incia o katangkesiku, mopasalaamatiaku minaaka i musuku, tee o tampana peulusaku mamudhaakana sadia kuʼamani. ");
INSERT INTO wlo_vpl VALUES ("PS18_4","020_18_4","PSA","18","4","4","Iaku kugora i KAWASANA OPU molaengana ipuji, tee Incia apasalaamatiaku minaaka i manga musuku. ");
INSERT INTO wlo_vpl VALUES ("PS18_5","020_18_5","PSA","18","5","5","Manga jari imateaka arimpuaku, tee akangkanaiaku uwena mawa maoge mopabinasaaku, ");
INSERT INTO wlo_vpl VALUES ("PS18_6","020_18_6","PSA","18","6","6","Rabutana duniana mia mate arimpuaku, tee manga katapu imateaka atotaa i aroaku. ");
INSERT INTO wlo_vpl VALUES ("PS18_7","020_18_7","PSA","18","7","7","I nuncana kasukara iaku kugora i KAWASANA OPU, tee kupekee kuemani tulungi i Aulataʼalaku. Incia arango suaraku minaaka i Baitullana, tee o pekeeku i Incia akawa i talingana. ");
INSERT INTO wlo_vpl VALUES ("PS18_8","020_18_8","PSA","18","8","8","Sumaimo o alamu akohudha tee akolendu, manga gunu uka atorende tee akohudha roonamo pamuruna Aulataʼala. ");
INSERT INTO wlo_vpl VALUES ("PS18_9","020_18_9","PSA","18","9","9","Ombu alimba minaaka i angona, waa alimba minaaka i ngangana, weona waa akarore-rore. ");
INSERT INTO wlo_vpl VALUES ("PS18_10","020_18_10","PSA","18","10","10","Laiana awetaia, kasiimpo Incia asapo tee taʼina ngalu malalanda i tambena aena. ");
INSERT INTO wlo_vpl VALUES ("PS18_11","020_18_11","PSA","18","11","11","Incia asawi i malaaʼekati kerub kasiimpo apolaka, atinti tee asawi i bhawona ngalu. ");
INSERT INTO wlo_vpl VALUES ("PS18_12","020_18_12","PSA","18","12","12","Incia abuniaka karona tee kalalanda, tampana mbooresana satotuuna o wao momalalanda tee taʼina ngalu momakapa i laiana. ");
INSERT INTO wlo_vpl VALUES ("PS18_13","020_18_13","PSA","18","13","13","Minaaka i cahea i aroana, waona esi tee weona waa alimbamo minaaka i manga taʼina ngaluna. ");
INSERT INTO wlo_vpl VALUES ("PS18_14","020_18_14","PSA","18","14","14","KAWASANA OPU apakoguntu i laiana, tee Aulataʼala Momalanga apaperangoiaka suarana i tanga-tangana waona esi tee weona waa. ");
INSERT INTO wlo_vpl VALUES ("PS18_15","020_18_15","PSA","18","15","15","Incia arambasaka manga panana tee apapogaa-gaa musuna, bhibhito apokilati sabutuna manga incia apalai amantale. ");
INSERT INTO wlo_vpl VALUES ("PS18_16","020_18_16","PSA","18","16","16","Tambena tawo atokamata roonamo tawo amatuu, tee atokamatamo fondasina alamu roonamo kagorampangimu, e KAWASANA OPU, tee roonamo poinuncana angomu. ");
INSERT INTO wlo_vpl VALUES ("PS18_17","020_18_17","PSA","18","17","17","KAWASANA OPU apaulu limana minaaka i kalangaana tee apasalaamatiaku, Incia ahelaaku minaaka i uwena mawa imateaka. ");
INSERT INTO wlo_vpl VALUES ("PS18_18","020_18_18","PSA","18","18","18","Incia apasalaamatiaku minaaka i musuku momakaana tee minaaka i manga mia mobanciaku, roonamo musuku amarasai mpuu kutaloa. ");
INSERT INTO wlo_vpl VALUES ("PS18_19","020_18_19","PSA","18","19","19","Manga incia ahumbuniaku i wakutuuna kusukara, maka KAWASANA OPU motulungiaku, ");
INSERT INTO wlo_vpl VALUES ("PS18_20","020_18_20","PSA","18","20","20","Incia apalimbaaku minaaka i kaseke tee abhawaaku i tampa momalalesa, tee apasalaamatiaku roonamo amaasiakaaku. ");
INSERT INTO wlo_vpl VALUES ("PS18_21","020_18_21","PSA","18","21","21","KAWASANA OPU amalape tee iaku apokana tee kabanaraku, Incia abalasi pewauku, apokana tee kangkilona limaku ");
INSERT INTO wlo_vpl VALUES ("PS18_22","020_18_22","PSA","18","22","22","roonamo iaku sadhaadhaa kutaʼati parintana KAWASANA OPU tee inda kupewau madhaki i Aulataʼalaku. ");
INSERT INTO wlo_vpl VALUES ("PS18_23","020_18_23","PSA","18","23","23","Bhari-bharia hukumuna dhaangia i aroaku, tee iaku inda kupekaridho minaaka i manga katotapuna. ");
INSERT INTO wlo_vpl VALUES ("PS18_24","020_18_24","PSA","18","24","24","Iaku inda kupewau madhaki i incia, tee kujagani karoku minaaka i kasalaha. ");
INSERT INTO wlo_vpl VALUES ("PS18_25","020_18_25","PSA","18","25","25","Sumaimo KAWASANA OPU abalasi pewauku mobanarana roonamo kumangkilo i aroana. ");
INSERT INTO wlo_vpl VALUES ("PS18_26","020_18_26","PSA","18","26","26","I mia motaʼati, Ingkoo ususuakea kaasimu molagina tee i mia momalape, Ingkoo umalape. ");
INSERT INTO wlo_vpl VALUES ("PS18_27","020_18_27","PSA","18","27","27","I mia momangkilo, Ingkoo umangkilo, maka Ingkoo uewangi mia momadhakina incana. ");
INSERT INTO wlo_vpl VALUES ("PS18_28","020_18_28","PSA","18","28","28","Ingkoo mopasalaamatina uumati motopisaki, maka o mia mosombo upekaeaia. ");
INSERT INTO wlo_vpl VALUES ("PS18_29","020_18_29","PSA","18","29","29","Ingkoo mopakatana suluku, KAWASANA OPU, Aulataʼalaku, mosuluwina kalalandaku. ");
INSERT INTO wlo_vpl VALUES ("PS18_30","020_18_30","PSA","18","30","30","Satotuuna roonamo Ingkoo, iaku kumembali kuewangi gorombola musuku tee kumembali kukompasi rindina bentena. ");
INSERT INTO wlo_vpl VALUES ("PS18_31","020_18_31","PSA","18","31","31","Pewauna Aulataʼala sadia amalape, tee firimanina KAWASANA OPU atouji. Incia o katangkesi to bhari-bharia mia tee amasanaamo mia mopeuluna i Incia. ");
INSERT INTO wlo_vpl VALUES ("PS18_32","020_18_32","PSA","18","32","32","Sababuna tangkanamo KAWASANA OPU o Aulataʼalata, soomo Aulataʼala peulusata. ");
INSERT INTO wlo_vpl VALUES ("PS18_33","020_18_33","PSA","18","33","33","Aulataʼala mopekatangkaaku, tee aparatea o dhalaku mamudhaakana kuʼamani. ");
INSERT INTO wlo_vpl VALUES ("PS18_34","020_18_34","PSA","18","34","34","Incia apekatangka aeku mboomo aena rusa mamudhaakana kumadhei kubuntuli, tee ajagani kasalaamatiku i gunu. ");
INSERT INTO wlo_vpl VALUES ("PS18_35","020_18_35","PSA","18","35","35","Incia aadhariakaaku carana potimbe, sabutuna amembali kupaubhe pana tambagaku. ");
INSERT INTO wlo_vpl VALUES ("PS18_36","020_18_36","PSA","18","36","36","Ingkoo katangkesiku tee mopasalaamatiaku, tee kuasamu iaku kuʼamani, tee kalapemu kumembali kumakaa mpuu. ");
INSERT INTO wlo_vpl VALUES ("PS18_37","020_18_37","PSA","18","37","37","Ingkoo upekaewa dhala to bhengkalaku, tee aeku inda asindoli. ");
INSERT INTO wlo_vpl VALUES ("PS18_38","020_18_38","PSA","18","38","38","Iaku kupajere manga musuku, tee kurako manga incia, Iaku inda bhekumbuli ande manga incia inda atopepadhai. ");
INSERT INTO wlo_vpl VALUES ("PS18_39","020_18_39","PSA","18","39","39","Kupahancurua manga sakawana inda amembali abhangu pendua, tee kupatobhatea i aroaku. ");
INSERT INTO wlo_vpl VALUES ("PS18_40","020_18_40","PSA","18","40","40","Ingkoo udhawuaku kakaa to kupotimbe, roonamo Ingkoo iaku amembali kutalo manga musuku. ");
INSERT INTO wlo_vpl VALUES ("PS18_41","020_18_41","PSA","18","41","41","Ingkoo upewau manga musuku apalai minaaka i iaku, manga mia mobanciaku kupabinasea. ");
INSERT INTO wlo_vpl VALUES ("PS18_42","020_18_42","PSA","18","42","42","Manga incia apekee aemani tulungi maka inda dhaangia mopasalaamatia. Manga incia apekee i KAWASANA OPU, maka Incia inda alawani. ");
INSERT INTO wlo_vpl VALUES ("PS18_43","020_18_43","PSA","18","43","43","Kupahancurua manga mboomo ngawu ipolakaakana ngalu, tee kulandakia manga mboomo tomba i dhala. ");
INSERT INTO wlo_vpl VALUES ("PS18_44","020_18_44","PSA","18","44","44","Ingkoo upabebasiaku minaaka i raʼeati modorohaka, Upamembaliaku mokuasaina manga lipu. Tee lipu inda imatauku amembali bhatuaku. ");
INSERT INTO wlo_vpl VALUES ("PS18_45","020_18_45","PSA","18","45","45","Manga incia arango tee ataʼati parintaku. Manga mia dhaga uka asomba tee arengku i aroaku. ");
INSERT INTO wlo_vpl VALUES ("PS18_46","020_18_46","PSA","18","46","46","Manga mia dhaga ailamo kabaranina, tee arengku alimba minaaka i bente potaangiana. ");
INSERT INTO wlo_vpl VALUES ("PS18_47","020_18_47","PSA","18","47","47","Iaku kumataua ande o KAWASANA OPU adhadhi! Bhari-bharia kapujia to peulusaku! Muliangia o Aulataʼala, mopasalaamatiaku! ");
INSERT INTO wlo_vpl VALUES ("PS18_48","020_18_48","PSA","18","48","48","Aulataʼala motulungiaku kutalo manga musuku, tee manga lipu kukuasaia. ");
INSERT INTO wlo_vpl VALUES ("PS18_49","020_18_49","PSA","18","49","49","Incia mopasalaamatiaku minaaka i manga musuku. Satotuuna, Ingkoomo mopekalangaaku minaaka i musu moewangiaku tee upasalaamatiaku minaaka i mia momasega. ");
INSERT INTO wlo_vpl VALUES ("PS18_50","020_18_50","PSA","18","50","50","Sababuna sumai, iaku bhekusukuru i Ingkoo, e KAWASANA OPU, i tanga-tangana manga lipu, tee iaku bhekulaguaka kapujia to saromu. ");
INSERT INTO wlo_vpl VALUES ("PS18_51","020_18_51","PSA","18","51","51","Aulataʼala adhawuaka kasalaamati momaoge to raja ipilina, tee asusuaka kaasina molagina i mia ilantina, siitumo o Daud tee siwuluna to saʼumurua. ");
INSERT INTO wlo_vpl VALUES ("PS19_1","020_19_1","PSA","19","1","1","To kapalana molaguna. Zaburuna Daud. ");
INSERT INTO wlo_vpl VALUES ("PS19_2","020_19_2","PSA","19","2","2","Laiana apetulatulaaka kamuliangina KAWASANA OPU, tee laiana apogauaka ikarajaana. ");
INSERT INTO wlo_vpl VALUES ("PS19_3","020_19_3","PSA","19","3","3","Saesaeo laiana abhoasaka pogauna, tee samalo-samalo uka apakoleleaka ilimuu. ");
INSERT INTO wlo_vpl VALUES ("PS19_4","020_19_4","PSA","19","4","4","Inda tee pogau atawa o bhoasaka, suarana uka inda atorango. ");
INSERT INTO wlo_vpl VALUES ("PS19_5","020_19_5","PSA","19","5","5","Maka o lelena atorango i saangua alamu, tee kasameana sumai akawa i tapana dunia. KAWASANA OPU apadhaangia laiana to mbooresana matanaeo. ");
INSERT INTO wlo_vpl VALUES ("PS19_6","020_19_6","PSA","19","6","6","Kasiimpo matanaeo abhete i wakutuu saeona, mboomo panganti umane molimbana minaaka i kolemana, mboomo samia hiri akaunde-unde wakutuu apepuungi lingkaana. ");
INSERT INTO wlo_vpl VALUES ("PS19_7","020_19_7","PSA","19","7","7","Matanaeo abhete minaaka i tapana laiana, atii akawa i tapa mosagaanana, inda dhaangia molapana minaaka i kasodhona. ");
INSERT INTO wlo_vpl VALUES ("PS19_8","020_19_8","PSA","19","8","8","Hukumuna KAWASANA OPU amondo tee inda tee kakurangana, apadhadhi inca. Tuturana KAWASANA OPU atoparacaea, adhawu hikimati i manga mia inda moʼaarifu. ");
INSERT INTO wlo_vpl VALUES ("PS19_9","020_19_9","PSA","19","9","9","Tuturana KAWASANA OPU sumai abanara, apasanaa ngangaranda. Parintana KAWASANA OPU sumai atinda, amembali kainawa to karota. ");
INSERT INTO wlo_vpl VALUES ("PS19_10","020_19_10","PSA","19","10","10","Namisi kaeka i KAWASANA OPU sumai amangkilo, to saʼumurua. Tuturana KAWASANA OPU sumai atoparacaea tee aʼadili bhari-bharia. ");
INSERT INTO wlo_vpl VALUES ("PS19_11","020_19_11","PSA","19","11","11","Hukumuna KAWASANA OPU alabhi o kaalina minaaka i bulawa asilii, moomini abhari bulawa asilii, alabhi o kamekona minaaka i golana uwani, moomini golana uwani asilii minaaka i bhanuana uwani. ");
INSERT INTO wlo_vpl VALUES ("PS19_12","020_19_12","PSA","19","12","12","Bhari-bharia hukumumu sumai audhaniaka bhatuamu sii; dhaangia o fahala maoge to mia motaʼatina parintamu. ");
INSERT INTO wlo_vpl VALUES ("PS19_13","020_19_13","PSA","19","13","13","Incema buaka momembalina momatauna kasalahana karona? Pekangkiloakumo minaaka i manga dosa motobuniaka. ");
INSERT INTO wlo_vpl VALUES ("PS19_14","020_19_14","PSA","19","14","14","Jaganiaku mamudhaakana inda kupewau dosa iporadhamii, tee bholi utaroakea manga dosa akuasaiaku. Kasiimpo iaku indamo uka kupewau madhaki, tee kumangkilo minaaka i kasalaha momaoge. ");
INSERT INTO wlo_vpl VALUES ("PS19_15","020_19_15","PSA","19","15","15","Maasangia o pogauku tee bhokuna ngangarandaku utarimaia, e KAWASANA OPU, peulusaku tee motolosiaku. ");
INSERT INTO wlo_vpl VALUES ("PS20_1","020_20_1","PSA","20","1","1","To kapalana lagu. Zaburuna Daud. ");
INSERT INTO wlo_vpl VALUES ("PS20_2","020_20_2","PSA","20","2","2","Maasangia KAWASANA OPU alawaniko i wakutuuna kasukara, maasangia Aulataʼala, isombana Yakub ajaganiko! ");
INSERT INTO wlo_vpl VALUES ("PS20_3","020_20_3","PSA","20","3","3","Maasangia Incia atulungiko minaaka i tampa momangkilo, tee atukoko minaaka i Gunu Sion. ");
INSERT INTO wlo_vpl VALUES ("PS20_4","020_20_4","PSA","20","4","4","Maasangia Incia audhani bhari-bharia pasombaamu, tee atarima kurubani tunuamu. Sela ");
INSERT INTO wlo_vpl VALUES ("PS20_5","020_20_5","PSA","20","5","5","Maasangia Incia adhawuko opea ipeelumu, tee apewau bhari-bharia haejatimu akohasili. ");
INSERT INTO wlo_vpl VALUES ("PS20_6","020_20_6","PSA","20","6","6","Ingkami bhetasambo-sambo roonamo Ingkoo ukanamo, tee tapabhale tombi to tapuji Aulataʼalamami. Maasangia KAWASANA OPU adhawuko bhari-bharia iemanimu! ");
INSERT INTO wlo_vpl VALUES ("PS20_7","020_20_7","PSA","20","7","7","Sii-sii iaku kumataua ande o KAWASANA OPU mopasalaamatina raja ilantina. Minaaka i sorogaa momangkilo Incia bhealawani tee kuasana lima kaanana mopasalaamatina. ");
INSERT INTO wlo_vpl VALUES ("PS20_8","020_20_8","PSA","20","8","8","Dhaangia o mia motangkaakana manga kareta potimbeana, dhaangia uka motangkaakana manga ajarana, maka ingkita tatangkaaka sarona KAWASANA OPU, Aulataʼalata. ");
INSERT INTO wlo_vpl VALUES ("PS20_9","020_20_9","PSA","20","9","9","Manga incia atosunu tee amandawu, maka ingkita tabhangu takabhale-bhale tee tamatangka. ");
INSERT INTO wlo_vpl VALUES ("PS20_10","020_20_10","PSA","20","10","10","E KAWASANA OPU, pasalaamatia o raja, manga lawani i wakutuuna ingkami tagora. ");
INSERT INTO wlo_vpl VALUES ("PS21_1","020_21_1","PSA","21","1","1","To kapalana molaguna. Zaburuna Daud. ");
INSERT INTO wlo_vpl VALUES ("PS21_2","020_21_2","PSA","21","2","2","E KAWASANA OPU, raja akaunde-unde roonamo kuasamu tee amaoge mpuu o undena roonamo kasalaamati minaaka i Ingkoo! ");
INSERT INTO wlo_vpl VALUES ("PS21_3","020_21_3","PSA","21","3","3","Ingkoo udhawua opea ipeeluna, tee Ingkoo uundapia iemanina. Sela ");
INSERT INTO wlo_vpl VALUES ("PS21_4","020_21_4","PSA","21","4","4","Satotuuna, Ingkoo upepago incia tee barakati motaralabhi-labhi, Ingkoo upasaakea mahakota minaaka i bulawa asilii i bhaana. ");
INSERT INTO wlo_vpl VALUES ("PS21_5","020_21_5","PSA","21","5","5","Incia aemani dhadhi i karomu, tee Ingkoo udhawuakea umuru marambe to saʼumurua. ");
INSERT INTO wlo_vpl VALUES ("PS21_6","020_21_6","PSA","21","6","6","Amaoge o kamuliangina roonamo kasalaamati minaaka i karomu, kaogesa tee kuasa udhawuakea to incia. ");
INSERT INTO wlo_vpl VALUES ("PS21_7","020_21_7","PSA","21","7","7","Ingkoo udhawuakea barakati to incia saʼumurua, tee upaunde-undea namisina i aroamu. ");
INSERT INTO wlo_vpl VALUES ("PS21_8","020_21_8","PSA","21","8","8","Raja aparacaea i KAWASANA OPU, tee roonamo kaasina molagina Aulataʼala Momalanga, incia inda bheasindoli. ");
INSERT INTO wlo_vpl VALUES ("PS21_9","020_21_9","PSA","21","9","9","Tee kuasamu bheurako bhari-bharia musumu, tee kuasamu karomu bheurako manga mia mobanciko. ");
INSERT INTO wlo_vpl VALUES ("PS21_10","020_21_10","PSA","21","10","10","Ingkoo bheupamembali manga incia mboomo waa mokarore-rore wakutuuna upatiumba karomu. Roonamo tee pamuruna KAWASANA OPU, manga incia bheatopepadhai, tee manga incia bheakandea waa. ");
INSERT INTO wlo_vpl VALUES ("PS21_11","020_21_11","PSA","21","11","11","Bhari-bharia anana tee opuopuana manga incia bheupabinasea minaaka i bhawona alamu, tee o siwuluna manga incia uka minaaka i tanga-tangana anana maanusia. ");
INSERT INTO wlo_vpl VALUES ("PS21_12","020_21_12","PSA","21","12","12","Moomini manga incia ahaejati madhaki to Ingkoo, tee ahaejati bheatipuko, manga incia inda bheamembali. ");
INSERT INTO wlo_vpl VALUES ("PS21_13","020_21_13","PSA","21","13","13","Ingkoo bheupewau manga incia apalaiaka karona wakutuuna uhela matana panamu tee upatotoaka rouna manga incia. ");
INSERT INTO wlo_vpl VALUES ("PS21_14","020_21_14","PSA","21","14","14","E KAWASANA OPU, taroakamo utopekalanga i nuncana kuasamu! Ingkami bhetalaguaka lagu kapujia to kaogesamu. ");
INSERT INTO wlo_vpl VALUES ("PS22_1","020_22_1","PSA","22","1","1","To kapalana molaguna. Mboomo lagu: Rusa i wakutuuna raneeo. Zaburuna Daud. ");
INSERT INTO wlo_vpl VALUES ("PS22_2","020_22_2","PSA","22","2","2","E Aulataʼalaku, e Aulataʼalaku, pokia ubholiaku? Pokia upekaridho, inda utulungiaku tee inda uperangoi goraku? ");
INSERT INTO wlo_vpl VALUES ("PS22_3","020_22_3","PSA","22","3","3","E Aulataʼalaku, i wakutuuna eo iaku kudoʼa, maka Ingkoo inda ulawani, tee malo uka iaku kudoʼa, maka o ngangarandaku inda uka awesa. ");
INSERT INTO wlo_vpl VALUES ("PS22_4","020_22_4","PSA","22","4","4","Garaaka Ingkoo Momangkilona, Ingkoo ukokauncuramaka i bhawona manga kapujiana miana Israel. ");
INSERT INTO wlo_vpl VALUES ("PS22_5","020_22_5","PSA","22","5","5","Opu-opuamami aparacaeako. Manga incia aparacaea, to upasalaamatia. ");
INSERT INTO wlo_vpl VALUES ("PS22_6","020_22_6","PSA","22","6","6","Manga incia agora i Ingkoo, kasiimpo upasalaamatia; manga incia aparacaeako, tee inda upekaeaia. ");
INSERT INTO wlo_vpl VALUES ("PS22_7","020_22_7","PSA","22","7","7","Maka iaku sii mboomo ulo-ulo, mencuanamo mboomo maanusia. Manga maanusia ahinaaku tee mia abhari abanciaku. ");
INSERT INTO wlo_vpl VALUES ("PS22_8","020_22_8","PSA","22","8","8","Bhari-bharia mia mokamataaku aele-eleaku. Manga incia angiripiaku, tee alengko-lengkoakaaku bhaana, ");
INSERT INTO wlo_vpl VALUES ("PS22_9","020_22_9","PSA","22","9","9","\"Incia atangkaaka KAWASANA OPU sumaimo taroakamo Incia mopabebasia! Taroakamo KAWASANA OPU mopasalaamatia roonamo KAWASANA OPU amaasiakea.\" ");
INSERT INTO wlo_vpl VALUES ("PS22_10","020_22_10","PSA","22","10","10","Maka Ingkoomo mopalimbaaku minaaka i nuncana kadhuma, tee ujaganiaku i sangoana inaku. ");
INSERT INTO wlo_vpl VALUES ("PS22_11","020_22_11","PSA","22","11","11","Mancuanaku apasarakaakaaku to Ingkoo pepuu minaaka i nuncana kompona. Apepuu minaaka i nuncana kadhumana inaku, Ingkoomo Aulataʼalaku. ");
INSERT INTO wlo_vpl VALUES ("PS22_12","020_22_12","PSA","22","12","12","Bholi upekaridho, roonamo o balaa amakasumo tee inda dhaangia motulungiaku. ");
INSERT INTO wlo_vpl VALUES ("PS22_13","020_22_13","PSA","22","13","13","Abhari o sapi umane molibutiaku, tee gulumana karambau umane minaaka i Basan alibuaku. ");
INSERT INTO wlo_vpl VALUES ("PS22_14","020_22_14","PSA","22","14","14","Manga binata sumai abungkale ngangana pekaewa i aroaku, mboomo singa mopapakina kinandena tee akomburu. ");
INSERT INTO wlo_vpl VALUES ("PS22_15","020_22_15","PSA","22","15","15","Kakaaku mboomo uwe motolali, bhari-bharia bukuku atorambasaka minaaka i losuaku. Ateku mboomo taru, arere i nuncana badaku. ");
INSERT INTO wlo_vpl VALUES ("PS22_16","020_22_16","PSA","22","16","16","Mbalo-mbalona bhorokoku amatuu mboomo kapasana balanga, tee o dhelaku apika i ngaraku. Ingkoo upewauaku mboomo mia mate. ");
INSERT INTO wlo_vpl VALUES ("PS22_17","020_22_17","PSA","22","17","17","Manga mantoa alibutiaku, tee gulumana mia madhaki alibuaku. Manga incia asula limaku tee aeku. ");
INSERT INTO wlo_vpl VALUES ("PS22_18","020_22_18","PSA","22","18","18","Bhari-bharia bukuku amembali kugagaria, manga incia atontoaku tee akamakamataaku. ");
INSERT INTO wlo_vpl VALUES ("PS22_19","020_22_19","PSA","22","19","19","Manga incia apodhawu-dhawuakea o pakeaku sumai, tee aʼundia. ");
INSERT INTO wlo_vpl VALUES ("PS22_20","020_22_20","PSA","22","20","20","Maka Ingkoo e KAWASANA OPU bholi umaridho minaaka i karoku! Ingkoomo mopekatangkana bukuku, umbamo madhei utulungiaku! ");
INSERT INTO wlo_vpl VALUES ("PS22_21","020_22_21","PSA","22","21","21","Rambasakea o inyawaku minaaka i ewanga, tee upasalaamatiaku minaaka i mantoa mopapakiaku. ");
INSERT INTO wlo_vpl VALUES ("PS22_22","020_22_22","PSA","22","22","22","Rambasakaaku minaaka i ngangana singa tee minaaka i tanduna karambau. Ingkoo padhamo upasalaamatiaku. ");
INSERT INTO wlo_vpl VALUES ("PS22_23","020_22_23","PSA","22","23","23","Iaku bhekupetulatulaaka saromu i manga witinaiku, tee i tanga-tangana jamaʼa bhekupuji-pujiko. ");
INSERT INTO wlo_vpl VALUES ("PS22_24","020_22_24","PSA","22","24","24","Pujimo Incia, e manga mia momaekana i KAWASANA OPU! E bhari-bharia siwuluna Yakub, muliangia o KAWASANA OPU! E bhari-bharia siwuluna Israel, sujumo i Incia! ");
INSERT INTO wlo_vpl VALUES ("PS22_25","020_22_25","PSA","22","25","25","Sababuna Incia inda apandaʼente tee ahina o mia motopisaki, tee inda abuniaka rouna minaaka i mia incia sumai, maka aperangoi o mia motopisaki sumai wakutuuna agora aemani tulungi i Incia. ");
INSERT INTO wlo_vpl VALUES ("PS22_26","020_22_26","PSA","22","26","26","Roonamo Ingkoo, iaku kupuji-pujiko i tanga-tangana jamaʼa mobhari sumai, tee iaku bhekupomea tolauna oniku i aroana manga mia momaekana tee Ingkoo. ");
INSERT INTO wlo_vpl VALUES ("PS22_27","020_22_27","PSA","22","27","27","Iaku bhekukemba manga mia misikini mamudhaakana akande sakawana amambosu; mia mopeelona KAWASANA OPU bheapujia; taroakamo manga incia bhari-bharia amarambe o umuruna! ");
INSERT INTO wlo_vpl VALUES ("PS22_28","020_22_28","PSA","22","28","28","Bhari-bharia lipu i dunia bheaudhania tee ambuli apuji kaogesana KAWASANA OPU. Bhari-bharia siwulu minaaka i manga lipu bheasuju tee asomba i aroana ");
INSERT INTO wlo_vpl VALUES ("PS22_29","020_22_29","PSA","22","29","29","roonamo tangkanamo KAWASANA OPU mokopamarintana, Incia moparintana i bhari-bharia lipu. ");
INSERT INTO wlo_vpl VALUES ("PS22_30","020_22_30","PSA","22","30","30","Bhari-bharia mia morangkaea i dunia sii bheasomba tee asuju i Incia. Bhari-bharia maanusia mofanaa bheasuju i aroana. ");
INSERT INTO wlo_vpl VALUES ("PS22_31","020_22_31","PSA","22","31","31","Manga opu-opuana naile itu bheasomba i Incia tee apetulatulaaka KAWASANA OPU i siwuluna bhemoumbana naile itu. ");
INSERT INTO wlo_vpl VALUES ("PS22_32","020_22_32","PSA","22","32","32","Manga incia bheaumba tee apetulatulaaka kabanara i lipu tee siwulu bhemoumbana naile itu ande o KAWASANA OPU aʼadili tee uumatina. Totuumo, Incia padhamo apewau mboo sumai. ");
INSERT INTO wlo_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","Zaburuna Daud. KAWASANA OPU o gembalaku, iaku inda bhekukakuranga. ");
INSERT INTO wlo_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","Incia ataroakaaku kuponiunto i tana mokorumpu; Incia abhawaaku i bhiwina uwe momalino. ");
INSERT INTO wlo_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","Incia apekatangkaaku, tee atondaaku i dhala mobanara rampaakanamo sifatuna mboomo gembala momalape. ");
INSERT INTO wlo_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","Moomini kudhala i nuncana mbolonga momalalanda mpuu, iaku inda kumaeka balaa roonamo Ingkoo dhaangia i saripiku; Ingkoo ujaganiaku mboomo gembala mojaganina dumbana, tee katuko ibhawamu, kunamisi kutohiburu. ");
INSERT INTO wlo_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","Ingkoo upasiapuakaaku kinande i aroana manga bhaliku. I bhaaku ujampuakea tee mina-mina mawondu; tondeku uantokiakea tee giu isumpu motaralabhi-labhi. ");
INSERT INTO wlo_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","Kalape tee kaasi molagina bheaoseaku saʼumurua dhadhiku, tee iaku bhekumboore i nuncana Bhanuamu saʼumurua. ");
INSERT INTO wlo_vpl VALUES ("PS24_1","020_24_1","PSA","24","1","1","Zaburuna Daud. KAWASANA OPU mokopewauaakana alamu tee bhari-bharia antona, dunia tee bhari-bharia momboorena i nuncana. ");
INSERT INTO wlo_vpl VALUES ("PS24_2","020_24_2","PSA","24","2","2","Incia modhikana kalempesina alamu i bhawona tawo, tee apakaroa i bhawona manga umala. ");
INSERT INTO wlo_vpl VALUES ("PS24_3","020_24_3","PSA","24","3","3","Incema momembalina mopenena i gununa KAWASANA OPU? Tee incema momembalina moumbana i aroana tampa momangkilona? ");
INSERT INTO wlo_vpl VALUES ("PS24_4","020_24_4","PSA","24","4","4","Mia momangkilona limana tee momalapena incana, incia inda adoʼa i manga barahala, tee inda aposumpa gau-gau. ");
INSERT INTO wlo_vpl VALUES ("PS24_5","020_24_5","PSA","24","5","5","Incia bheapotibhaaka barakati minaaka i KAWASANA OPU, tee Aulataʼala mopasalaamatia bheapabanarea. ");
INSERT INTO wlo_vpl VALUES ("PS24_6","020_24_6","PSA","24","6","6","Siimo manga mia mopeelona Aulataʼala, aumba to asomba Ingkoo, Aulataʼalana Yakub. Sela ");
INSERT INTO wlo_vpl VALUES ("PS24_7","020_24_7","PSA","24","7","7","Pobungkalemo pekaewa, e manga bhambana lawa! Toangkamo, e manga bhamba motopakarona minaaka i piamo itu, mamudhaakana Raja Momulia apesua! ");
INSERT INTO wlo_vpl VALUES ("PS24_8","020_24_8","PSA","24","8","8","Incema o Raja Momulia sumai? KAWASANA OPU, momakaana tee mohebana! KAWASANA OPU, mohebana i nuncana potimbea! ");
INSERT INTO wlo_vpl VALUES ("PS24_9","020_24_9","PSA","24","9","9","Pobungkalemo pekaewa, e manga bhambana lawa! Toangkamo, e manga bhamba motopakarona minaaka i piamo itu, mamudhaakana Raja Momulia apesua! ");
INSERT INTO wlo_vpl VALUES ("PS24_10","020_24_10","PSA","24","10","10","\"Incema buaka Raja momulia sumai?\" KAWASANA OPUNA saangua alamu, Incia Raja Momulia! Sela ");
INSERT INTO wlo_vpl VALUES ("PS25_1","020_25_1","PSA","25","1","1","Zaburuna Daud. E KAWASANA OPU, i Ingkoomo kudoʼa! ");
INSERT INTO wlo_vpl VALUES ("PS25_2","020_25_2","PSA","25","2","2","E Aulataʼalaku, i Ingkoomo kuparacaea, maasangia inda kupotibhaaka kaea, tee bholi utaroakea manga musuku apotawaikiaku. ");
INSERT INTO wlo_vpl VALUES ("PS25_3","020_25_3","PSA","25","3","3","Bhari-bharia mia moharapuna i Ingkoo inda bheanamisi kaea, maka manga mia mohianatia inda tee sababuna bheanamisi kaea. ");
INSERT INTO wlo_vpl VALUES ("PS25_4","020_25_4","PSA","25","4","4","E KAWASANA OPU, paumbaakaaku manga dhalamu, adhariakaaku manga parintamu. ");
INSERT INTO wlo_vpl VALUES ("PS25_5","020_25_5","PSA","25","5","5","Bhawaaku kulingka i nuncana kabanaramu tee uadhariaku, roonamo Ingkoomo Aulataʼala mopasalaamatiaku, iaku kuantaantagiko saeoa. ");
INSERT INTO wlo_vpl VALUES ("PS25_6","020_25_6","PSA","25","6","6","E KAWASANA OPU, udhania rahumatimu tee kaasimu molagina roonamo bhari-bharia sumai adhaangiamo minaaka i zamani mangenge. ");
INSERT INTO wlo_vpl VALUES ("PS25_7","020_25_7","PSA","25","7","7","Dosa-dosa wakutuuna amangura dhadhiku, tee manga kasalaha ipewauku bholimo uudhania, tabeana udhaniaku apokana tee kaasimu molagina roonamo kalapena incamu, e KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("PS25_8","020_25_8","PSA","25","8","8","KAWASANA OPU sumai amalape tee amakate totona incana, sababuna Incia asusuaka dhala to manga mia mokodosa. ");
INSERT INTO wlo_vpl VALUES ("PS25_9","020_25_9","PSA","25","9","9","KAWASANA OPU akapalai mia inda mosombo i dhala mobanara, tee manga incia aadhariakea tee opea ipeeluna. ");
INSERT INTO wlo_vpl VALUES ("PS25_10","020_25_10","PSA","25","10","10","Bhari-bharia dhalana KAWASANA OPU abukeaka tee kaasi molagina tee amembali atoparacaea to mia mopengkenina i pojanjiana tee manga kaudhaniana. ");
INSERT INTO wlo_vpl VALUES ("PS25_11","020_25_11","PSA","25","11","11","E KAWASANA OPU, roonamo saromu amponia o kasalahaku moomini amaoge o kasalahaku sumai. ");
INSERT INTO wlo_vpl VALUES ("PS25_12","020_25_12","PSA","25","12","12","Incema mia momaekana i KAWASANA OPU? KAWASANA OPU bheasusuakea dhala to idhalikina. ");
INSERT INTO wlo_vpl VALUES ("PS25_13","020_25_13","PSA","25","13","13","Manga incia bheasadhaadhaa adhadhi amasanaa, tee manga siwuluna mokotinaurakaakana alamu. ");
INSERT INTO wlo_vpl VALUES ("PS25_14","020_25_14","PSA","25","14","14","KAWASANA OPU aposabhangka tee manga mia momaekaia, tee asusuaka o antona pojanjiana to manga incia. ");
INSERT INTO wlo_vpl VALUES ("PS25_15","020_25_15","PSA","25","15","15","Mataku sadhaadhaa atonto KAWASANA OPU, roonamo Incia bheapasalaamatiaku minaaka i balaa. ");
INSERT INTO wlo_vpl VALUES ("PS25_16","020_25_16","PSA","25","16","16","Tontoaku, tee umaasiakaaku, roonamo kumalino tee kutopisaki. ");
INSERT INTO wlo_vpl VALUES ("PS25_17","020_25_17","PSA","25","17","17","Pekalalesaia o ngangarandaku sii minaaka i kasukara, rambasakaaku minaaka i kanarakaaku. ");
INSERT INTO wlo_vpl VALUES ("PS25_18","020_25_18","PSA","25","18","18","Tilikia kanarakaaku tee kasukaraku, tee amponia bhari-bharia dhosaku. ");
INSERT INTO wlo_vpl VALUES ("PS25_19","020_25_19","PSA","25","19","19","Kamatea, tapanamo kabhari o musuku, tee manga incia abanciaku mpuu. ");
INSERT INTO wlo_vpl VALUES ("PS25_20","020_25_20","PSA","25","20","20","Jagania inyawaku tee pasalaamatiaku, bholi utaroakaaku kupotibhaaka kaea roonamo Ingkoo peulusaku. ");
INSERT INTO wlo_vpl VALUES ("PS25_21","020_25_21","PSA","25","21","21","Maasangia o kakatena totona incamu tee kajujurumu ajaganiaku, sababuna kuharapu i Ingkoo. ");
INSERT INTO wlo_vpl VALUES ("PS25_22","020_25_22","PSA","25","22","22","E Aulataʼala, tolosia manga miana Israel minaaka i bhari-bharia kasukarana! ");
INSERT INTO wlo_vpl VALUES ("PS26_1","020_26_1","PSA","26","1","1","Zaburuna Daud. E KAWASANA OPU, ewaakaaku roonamo kudhadhi i nuncana kakatena totona incaku. Iaku kuparacaea i KAWASANA OPU tee inda kusindoli. ");
INSERT INTO wlo_vpl VALUES ("PS26_2","020_26_2","PSA","26","2","2","Parakisaaku, e KAWASANA OPU, tee ucobaaku, ujimea o baatiniku tee ngangarandaku. ");
INSERT INTO wlo_vpl VALUES ("PS26_3","020_26_3","PSA","26","3","3","Satotuuna, kaasimu molagina dhaangia i aroaku, tee kudhadhi i nuncana kabanaramu. ");
INSERT INTO wlo_vpl VALUES ("PS26_4","020_26_4","PSA","26","4","4","Iaku inda kuuncura tee mia pande gau-gau, atawa kuposabhangka tee mia munaafiki. ");
INSERT INTO wlo_vpl VALUES ("PS26_5","020_26_5","PSA","26","5","5","Iaku kubanci poromusakaana mia mopewauna kadhaki, tee kumendeu kuuncura tee mia mokodosa. ");
INSERT INTO wlo_vpl VALUES ("PS26_6","020_26_6","PSA","26","6","6","Iaku kubhanui limaku to tandana inda kusala, kasiimpo kubulilingi tampana tunuana kurubanimu, e KAWASANA OPU, ");
INSERT INTO wlo_vpl VALUES ("PS26_7","020_26_7","PSA","26","7","7","to kulaguaka manga kabhanti kasukuru to Aulataʼala tee suara makaa, tee kupetulatulaaka bhari-bharia pewaumu inda momentela. ");
INSERT INTO wlo_vpl VALUES ("PS26_8","020_26_8","PSA","26","8","8","E KAWASANA OPU, iaku kumaasiakea o bhanua mbooresamu, tampana kamuliangimu amboore. ");
INSERT INTO wlo_vpl VALUES ("PS26_9","020_26_9","PSA","26","9","9","Bholi uala inyawaku mboomo uala inyawana manga mia mokodosa, tee bholi uala dhadhiku mboomo uala dhadhina pande pekamatena mia. ");
INSERT INTO wlo_vpl VALUES ("PS26_10","020_26_10","PSA","26","10","10","I nuncana limana dhaangia tee haejati madhaki, tee i lima kaanana atarima doina kasogo. ");
INSERT INTO wlo_vpl VALUES ("PS26_11","020_26_11","PSA","26","11","11","Maka iaku bhekudhadhi tee kakatena totona incaku. Pasalaamatiaku tee umaasiakaaku. ");
INSERT INTO wlo_vpl VALUES ("PS26_12","020_26_12","PSA","26","12","12","Sii-sii kuʼamanimo minaaka i bhari-bharia balaa, sumaimo iaku bhekupuji KAWASANA OPU i nuncana poromusakaana uumatina. ");
INSERT INTO wlo_vpl VALUES ("PS27_1","020_27_1","PSA","27","1","1","Zaburuna Daud. KAWASANA OPU o kainawa tee kasalaamatiku, tee incema buaka iaku bhekumaeka? KAWASANA OPU o bentena dhadiku, tee incema buaka iaku bhekurengku? ");
INSERT INTO wlo_vpl VALUES ("PS27_2","020_27_2","PSA","27","2","2","Wakutuuna manga parampo aumba alibuaku to akande dagiku, siitumo bhari-bharia bhaliku tee musuku, manga inciamo mosindolina tee momandawuna. ");
INSERT INTO wlo_vpl VALUES ("PS27_3","020_27_3","PSA","27","3","3","Moomini alibuaku rombongana suludadu mobhari, i nuncana ngangarandaku inda kumaeka. Moomini dhaangia tee potimbea to moewangiaku, iaku sadhaadhaa kuparacaea. ");
INSERT INTO wlo_vpl VALUES ("PS27_4","020_27_4","PSA","27","4","4","Tangkanamo saangu iemaniku i KAWASANA OPU, siitumo ipeeluku, mamudhaakana kumboore i nuncana Bhanuana KAWASANA OPU saʼumurua dhadhiku, to kukamataaka kalapena KAWASANA OPU tee kupengkaabha-abha i nuncana Bhanuana Momangkilo. ");
INSERT INTO wlo_vpl VALUES ("PS27_5","020_27_5","PSA","27","5","5","Sababuna i wakutuuna kasukara, KAWASANA OPU bheajaganiaku i tampana peulusana. Incia bheabuniakaaku i nuncana Kemana Momangkilo, tee Incia bheaangkaaku i tampa moʼamani, siitumo i bhawona gunu bhatu. ");
INSERT INTO wlo_vpl VALUES ("PS27_6","020_27_6","PSA","27","6","6","Sumaimo, bhaaku indamo atungku i aroana manga musu molibuaku, tee i nuncana Kemana Momangkilo iaku bhekupasombaaka kurubani isumbele tee kusambo-sambo; iaku bhekulaguaka lagu kapujia to KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("PS27_7","020_27_7","PSA","27","7","7","E KAWASANA OPU, maasangia urangoa o suaraku wakutuuna kugora, maasiakaaku tee ulawaniaku! ");
INSERT INTO wlo_vpl VALUES ("PS27_8","020_27_8","PSA","27","8","8","Totona incaku aose firimanimu, \"Maimo umba uʼibaadati i Iaku.\" Sumaimo, kulausakamo kuumba to kuʼibaadati, e KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("PS27_9","020_27_9","PSA","27","9","9","Bholi ubuniaka karomu wakutuuna kuʼibaadati i Ingkoo. Bholi inda umaheruakea o bhatuamu sii i nuncana pamurumu. Ingkoomo moagoaku, bholi umendeuaku atawa ubholiaku, e Aulataʼala, mopasalaamatiaku! ");
INSERT INTO wlo_vpl VALUES ("PS27_10","020_27_10","PSA","27","10","10","Moomini amaku tee inaku abholiaku, KAWASANA OPU bheapepagoaku mboomo anana karona. ");
INSERT INTO wlo_vpl VALUES ("PS27_11","020_27_11","PSA","27","11","11","E KAWASANA OPU, adhariakaaku opea ipeelumu, tee ususuakaaku dhala momakate, roonamo bhaliku tee musuku. ");
INSERT INTO wlo_vpl VALUES ("PS27_12","020_27_12","PSA","27","12","12","Bholi upasaraakaaku i nawusuuna bhaliku, roonamo manga sakusii gau-gau akakaromo aewangiaku, siitumo manga mia modhadhina tee feʼeli madhaki. ");
INSERT INTO wlo_vpl VALUES ("PS27_13","020_27_13","PSA","27","13","13","Iaku sadhaadhaa kuparacaea ande iaku bhekukamata kalapena KAWASANA OPU, i lipuna manga mia modhadhi. ");
INSERT INTO wlo_vpl VALUES ("PS27_14","020_27_14","PSA","27","14","14","Antagimo KAWASANA OPU! Pekakaaia tee upekatangkea o incamu! Umbe, antagimo KAWASANA OPU! ");
INSERT INTO wlo_vpl VALUES ("PS28_1","020_28_1","PSA","28","1","1","Zaburuna Daud. E KAWASANA OPU, gununa bhatuku, i Ingkoomo kugora! Bholi utaroakaaku, roonamo ande Ingkoo inda umaheruakaaku, iaku mboomo mia mosapona i nuncana liana koburu. ");
INSERT INTO wlo_vpl VALUES ("PS28_2","020_28_2","PSA","28","2","2","Perangoia iemaniku wakutuuna kupekee kuemani tulungi i Ingkoo, wakutuuna kuangka limaku tee kudoʼa kupoaro i tampamu momangkilo mpuu. ");
INSERT INTO wlo_vpl VALUES ("PS28_3","020_28_3","PSA","28","3","3","Ande uhukumuaku bholi upapobhawa-bhawaaku tee mia madhaki, tee bholi upapobhawa-bhawaaku tee manga mia mopewauna madhaki, mopogauna amalape i manga sabhangkana, maka i nuncana ngangarandana abukeaka kadhaki. ");
INSERT INTO wlo_vpl VALUES ("PS28_4","020_28_4","PSA","28","4","4","Hukumua manga incia apokana mboomo pewauna manga incia, apokana mboomo feʼelina manga momadhakina. Hukumua manga incia mboomo opea ipewauna limana, pambuliakea to manga incia opea mopadhana ipewauna. ");
INSERT INTO wlo_vpl VALUES ("PS28_5","020_28_5","PSA","28","5","5","Roonamo manga incia inda afaduliakea o opea ikarajaana KAWASANA OPU, tee uka manga hali maoge mopadhana ipewauna. KAWASANA OPU bheapatobhata manga incia tee inda apabhangua pendua. ");
INSERT INTO wlo_vpl VALUES ("PS28_6","020_28_6","PSA","28","6","6","Atopujimo KAWASANA OPU roonamo Incia padhamo aperangoi o opea iemaniku. ");
INSERT INTO wlo_vpl VALUES ("PS28_7","020_28_7","PSA","28","7","7","KAWASANA OPU o kakaaku tee katangkesiku, totona incaku aparacaea i Incia, tee atulungiaku. Incaku akaunde-unde, tee laguku kusukuru i Incia. ");
INSERT INTO wlo_vpl VALUES ("PS28_8","020_28_8","PSA","28","8","8","KAWASANA OPU satotuuna o kakaana uumatina, Incia o bente kasalaamatina to mia ilantina. ");
INSERT INTO wlo_vpl VALUES ("PS28_9","020_28_9","PSA","28","9","9","Pasalaamatia o uumatimu, barakatia pewauamu karomu. Umembalimo gembalana, tee ubhawea saʼumurua. ");
INSERT INTO wlo_vpl VALUES ("PS29_1","020_29_1","PSA","29","1","1","Zaburuna Daud. Pujimo KAWASANA OPU, e manga mahalukuna sorogaa, pujimo kaogesana tee kuasana. ");
INSERT INTO wlo_vpl VALUES ("PS29_2","020_29_2","PSA","29","2","2","Pujimo sarona KAWASANA OPU momulia tee usombaia upake pakea momangkilo. ");
INSERT INTO wlo_vpl VALUES ("PS29_3","020_29_3","PSA","29","3","3","Wakutuuna KAWASANA OPU apogau, suarana Aulataʼala Momulia atorango angkolele mboomo guntu i tangana andala. ");
INSERT INTO wlo_vpl VALUES ("PS29_4","020_29_4","PSA","29","4","4","Suarana KAWASANA OPU amakaa mpuu, Suarana KAWASANA OPU abukeaka kuasa. ");
INSERT INTO wlo_vpl VALUES ("PS29_5","020_29_5","PSA","29","5","5","Wakutuuna KAWASANA OPU apogau, amembali akatuki manga puuna aras, tee uka amembali apatobhata manga puuna aras motuwuna i Libanon. ");
INSERT INTO wlo_vpl VALUES ("PS29_6","020_29_6","PSA","29","6","6","Incia apewau Gunu Libanon apekatiba-tiba mboomo anana sapi, tee Gunu Siryon mboomo anana karambau. ");
INSERT INTO wlo_vpl VALUES ("PS29_7","020_29_7","PSA","29","7","7","Suarana KAWASANA OPU apewau bherese apokilati. ");
INSERT INTO wlo_vpl VALUES ("PS29_8","020_29_8","PSA","29","8","8","Suarana KAWASANA OPU apamembali tana matuu atorende, KAWASANA OPU apamembali Tana Matuu Kades atorende. ");
INSERT INTO wlo_vpl VALUES ("PS29_9","020_29_9","PSA","29","9","9","Suarana KAWASANA OPU amembali apakoana rusa bhawine mobhawa-bhawa, tee apamembali manga koo amembali amatuu. I nuncana Bhanuana Momangkilona bhari-bharia uumati agora \"Muliangimo KAWASANA OPU!\" ");
INSERT INTO wlo_vpl VALUES ("PS29_10","020_29_10","PSA","29","10","10","KAWASANA OPU akokuasa i bhawona mawa, KAWASANA OPU o raja mokokuasa to saʼumurua. ");
INSERT INTO wlo_vpl VALUES ("PS29_11","020_29_11","PSA","29","11","11","Maasangia KAWASANA OPU adhawu kakaa to uumatina, tee abarakatiakea kasanaa tee kaʼamani to uumatina. ");
INSERT INTO wlo_vpl VALUES ("PS30_1","020_30_1","PSA","30","1","1","Zaburuna Daud to alaguaka wakutuuna lipuna Israel alimbaisi Bhanua Mangkilo. ");
INSERT INTO wlo_vpl VALUES ("PS30_2","020_30_2","PSA","30","2","2","Iaku kupujiko, e KAWASANA OPU, sababuna Ingkoo padhamo upasalaamatiaku tee inda utaroaka musuku asamboakaaku. ");
INSERT INTO wlo_vpl VALUES ("PS30_3","020_30_3","PSA","30","3","3","E KAWASANA OPU, e Aulataʼalaku, iaku kugora i Ingkoo kuemani tulungi tee Ingkoo mopauntona kapiiku. ");
INSERT INTO wlo_vpl VALUES ("PS30_4","020_30_4","PSA","30","4","4","E KAWASANA OPU Ingkoo padhamo uangkaaku minaaka i alamuna koburu, Ingkoo padhamo upotaangiaka dhadhiku sabutuna iaku inda kusapo i liana koburu. ");
INSERT INTO wlo_vpl VALUES ("PS30_5","020_30_5","PSA","30","5","5","E manga mia mosaalihi, laguakamea manga lagu kapujia to KAWASANA OPU, bhoasakamea o kasukuru to sarona momangkilona. ");
INSERT INTO wlo_vpl VALUES ("PS30_6","020_30_6","PSA","30","6","6","Satotuuna o amarana sabantaramea, maka o kalapena saʼumurua. Moomini tatangi samaloa, maka i wakutuuna saeona bhetakaunde-undemo. ");
INSERT INTO wlo_vpl VALUES ("PS30_7","020_30_7","PSA","30","7","7","Roonamo kumasanaa, kupogau, \"Dhadhiku bheaʼamani torosu!\" ");
INSERT INTO wlo_vpl VALUES ("PS30_8","020_30_8","PSA","30","8","8","E KAWASANA OPU, roonamo kalapena incamu, Upamembaliaku mboomo gunu momatangka. Maka wakutuuna ubuniaka roumu, iaku kumaeka. ");
INSERT INTO wlo_vpl VALUES ("PS30_9","020_30_9","PSA","30","9","9","I Ingkoo iaku kugora, e KAWASANA OPU, tee i Aulataʼala kuemani kaasi, ");
INSERT INTO wlo_vpl VALUES ("PS30_10","020_30_10","PSA","30","10","10","\"Opea o faʼedana to Ingkoo ande amabhotu inyawaku tee kupesua i nuncana koburu? Amembali buaka o ngawu asukuru i Ingkoo tee apakoleleaka ande Ingkoo umembali utoparacaea? ");
INSERT INTO wlo_vpl VALUES ("PS30_11","020_30_11","PSA","30","11","11","E KAWASANA OPU, maasangia urangoa tee umaasiakaaku. E KAWASANA OPU, tulungiaku!\" ");
INSERT INTO wlo_vpl VALUES ("PS30_12","020_30_12","PSA","30","12","12","Tangiku ubhaliia amembali manari kaunde-unde, kae kadhu tandana kaporona incaku ualea, tee o tangaku ubhokeakea tee kasanaa. ");
INSERT INTO wlo_vpl VALUES ("PS30_13","020_30_13","PSA","30","13","13","Sabutuna kumembali kulaguaka lagu kapujia to Ingkoo tee inda soo kukatongo-tongo. E KAWASANA OPU, e Aulataʼalaku, iaku gauku kusukuru i Ingkoo to saʼumurua. ");
INSERT INTO wlo_vpl VALUES ("PS31_1","020_31_1","PSA","31","1","1","To kapalana molaguna. Zaburuna Daud. ");
INSERT INTO wlo_vpl VALUES ("PS31_2","020_31_2","PSA","31","2","2","E KAWASANA OPU, Ingkoomo peulusaku, bholi utaroakaaku kutopekaea. Pasalaamatiaku roonamo kaʼadilimu. ");
INSERT INTO wlo_vpl VALUES ("PS31_3","020_31_3","PSA","31","3","3","Perangoiaku, tee rambasakaaku pekadhei! Umembalimo gunu bhatu to tampana peulusaku, mboomo bentena potaangia mopasalaamatiaku. ");
INSERT INTO wlo_vpl VALUES ("PS31_4","020_31_4","PSA","31","4","4","Satotuuna, Ingkoomo gunu bhatuku tee bentena potaangiaku. Rampaakanamo saromu, kapalaikiaku tee utondaaku. ");
INSERT INTO wlo_vpl VALUES ("PS31_5","020_31_5","PSA","31","5","5","Rambasakaaku minaaka i katapu itaana musu to arakoaka iaku roonamo Ingkoomo peulusaku. ");
INSERT INTO wlo_vpl VALUES ("PS31_6","020_31_6","PSA","31","6","6","I nuncana limamu kupasaraakaaka inyawaku. Ingkoo padhamo upasalaamatiaku e KAWASANA OPU, Aulataʼala momembalina motoparacaea. ");
INSERT INTO wlo_vpl VALUES ("PS31_7","020_31_7","PSA","31","7","7","Iaku kubanci manga mia mosombana barahala mosia-sia; maka iaku samia kuparacaea i KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("PS31_8","020_31_8","PSA","31","8","8","Iaku bhekusambo-sambo tee kukaunde-unde roonamo kaasimu molagina, sababuna Ingkoo ukamata kanarakaaku tee umatau kasukaraku. ");
INSERT INTO wlo_vpl VALUES ("PS31_9","020_31_9","PSA","31","9","9","Ingkoo inda upasaraakaaku i limana musu, maka Ingkoo upakakaro aeku i tampa momalalesa. ");
INSERT INTO wlo_vpl VALUES ("PS31_10","020_31_10","PSA","31","10","10","E KAWASANA OPU, maasiakaakupo roonamo iaku i nuncana kasukara, mataku amandala roonamo kutangi, badaku tee inyawaku anarakaa. ");
INSERT INTO wlo_vpl VALUES ("PS31_11","020_31_11","PSA","31","11","11","Dhadhiku atopadha i nuncana kaporona inca, umuruku atopadha roonamo kupeenci; kakaaku aila roonamo kasalahaku, tee manga bukuku amapuromo. ");
INSERT INTO wlo_vpl VALUES ("PS31_12","020_31_12","PSA","31","12","12","I aroana bhari-bharia bhaliku, iaku kumembali giu ipotawaakana manga incia, tee uka manga sarimbanuaku. Iaku kumembali giu imingkiriaka to manga sampomatauku, tee manga mia mokamataaku i dhala apalaiakaaku. ");
INSERT INTO wlo_vpl VALUES ("PS31_13","020_31_13","PSA","31","13","13","Iaku kutomalinguaka mboomo mia mate, iaku kumembali mboomo bara momapasa. ");
INSERT INTO wlo_vpl VALUES ("PS31_14","020_31_14","PSA","31","14","14","Iaku kurango mia abhari apokamuntuiakaku, kamingkiri adhaangia i bhari-bharia rope! Manga incia apomufakati to abhaliaku, tee ahaejati to apekamateaku. ");
INSERT INTO wlo_vpl VALUES ("PS31_15","020_31_15","PSA","31","15","15","Maka iaku kuparacaeako, e KAWASANA OPU, sababuna iaku kupogau, \"Ingkoomo Aulataʼala isombaku!\" ");
INSERT INTO wlo_vpl VALUES ("PS31_16","020_31_16","PSA","31","16","16","Dhadhiku dhaangia i nuncana limamu, rambasakaaku minaaka i limana manga musuku tee minaaka i manga mia mopajereaku. ");
INSERT INTO wlo_vpl VALUES ("PS31_17","020_31_17","PSA","31","17","17","Taroakamo o caheana roumu akangkanai bhatuamu sii, tee upasalaamatiaku roonamo kaasimu molagina. ");
INSERT INTO wlo_vpl VALUES ("PS31_18","020_31_18","PSA","31","18","18","E KAWASANA OPU, bholi utaroakea manga musuku apekaeaaku roonamo iaku kugora i Ingkoo. Taroakamo manga mia madhaki apotibhaaka kaea, tee taroakamo manga incia asapo i duniana mia mate tee inda tee uuʼuuna. ");
INSERT INTO wlo_vpl VALUES ("PS31_19","020_31_19","PSA","31","19","19","Soncongia o muncuna manga pande gau-gau, mohinana tee momangkatuna mia mobanara; manga incia asombo tee apekahina. ");
INSERT INTO wlo_vpl VALUES ("PS31_20","020_31_20","PSA","31","20","20","Tapanamo kabhari o kalapemu mopadhana ipasiapuakamu to manga mia momaekako, tee ipewaumu to manga mia mopeuluna i Ingkoo, i aroana maanusia! ");
INSERT INTO wlo_vpl VALUES ("PS31_21","020_31_21","PSA","31","21","21","Ingkoo ubuniaka manga incia i nuncana peulusana kuasamu minaaka i mia mosahimuakana manga incia. Ingkoo ujagani manga incia i nuncana mbooresamu minaaka i manga mia moraeakana manga incia. ");
INSERT INTO wlo_vpl VALUES ("PS31_22","020_31_22","PSA","31","22","22","Atopujimo KAWASANA OPU roonamo inda amentela mpuu kaasina molagina mopadhana isusuakana to iaku wakutuuna kumaseke mboomo kota motolibu. ");
INSERT INTO wlo_vpl VALUES ("PS31_23","020_31_23","PSA","31","23","23","Roonamo kubingu, kusarongia, \"Kutopadhencumo minaaka i aroamu.\" Maka satotuuna Ingkoo urangoa iemaniku wakutuuna kugora kuemani tulungi i Ingkoo. ");
INSERT INTO wlo_vpl VALUES ("PS31_24","020_31_24","PSA","31","24","24","Maasiakea o KAWASANA OPU, e bhari-bharia mia mosaalihi! KAWASANA OPU ajagani mia motaʼati maka Incia ahukumu totuu-totuu o mia mosombo. ");
INSERT INTO wlo_vpl VALUES ("PS31_25","020_31_25","PSA","31","25","25","Pekakaaia tee upekatangkea o incamu, e bhari-bharia mia moharapuna i KAWASANA OPU! ");
INSERT INTO wlo_vpl VALUES ("PS32_1","020_32_1","PSA","32","1","1","Zaburuna Daud. Laguna kaadhari. Amasanaamo o mia motoʼamponina kasalahana, tee o mia motomaʼafuakana dosana. ");
INSERT INTO wlo_vpl VALUES ("PS32_2","020_32_2","PSA","32","2","2","Amasanaamo o mia mopewauna kasalaha, maka inda alentua o KAWASANA OPU, tee inda amakidha apekagau. ");
INSERT INTO wlo_vpl VALUES ("PS32_3","020_32_3","PSA","32","3","3","Kangengena indapo kuʼakui dosaku, buku-bukuku amalute roonamo kupeenci saeoa. ");
INSERT INTO wlo_vpl VALUES ("PS32_4","020_32_4","PSA","32","4","4","Malo eona Ingkoo upekatamo kahukumuku. Kakaaku atopadha mboomo kamba-kamba momalau roonamo akangkanaia kasodhona matanaeo. Sela ");
INSERT INTO wlo_vpl VALUES ("PS32_5","020_32_5","PSA","32","5","5","Kasiimpo kuʼakuia o dosaku i Ingkoo tee inda kubuniakea o kasalahaku. Kupogau, \"Iaku bhekuʼakuia manga kasalahaku i KAWASANA OPU,\" tee Ingkoo uʼamponi manga kasalahana dosaku. Sela ");
INSERT INTO wlo_vpl VALUES ("PS32_6","020_32_6","PSA","32","6","6","Sababuna sumai bhari-bharia mia mosaalihi tabeana adoʼa i Ingkoo wakutuuna Ingkoo dhaangiapo umembali utopokawaaka. Sumaimo wakutuuna uwena mawa maoge akawa, uwena mawa sumai inda amembali apabinasa incia. ");
INSERT INTO wlo_vpl VALUES ("PS32_7","020_32_7","PSA","32","7","7","Ingkoomo peulusaku, Ingkoo mojaganiaku minaaka i kasukara, Ingkoo modhikana lagu i nuncana ngangarandaku, roonamo padhamo upasalaamatiaku. Sela ");
INSERT INTO wlo_vpl VALUES ("PS32_8","020_32_8","PSA","32","8","8","Iaku bhekuadhariko tee kususuakako dhala molaengana idhalaikimu. Iaku bhekuudhaniakako, tee kujaganiko mamudhaakana sadhaadhaa uʼamani. ");
INSERT INTO wlo_vpl VALUES ("PS32_9","020_32_9","PSA","32","9","9","Bholi mboomo ajara atawa o siwuluna keledai inda tee akalana, tabeana atohelaaka tee kabhokena bhorokona tee rabutana, ande inda mboo sumai, manga incia inda bheaoseko. ");
INSERT INTO wlo_vpl VALUES ("PS32_10","020_32_10","PSA","32","10","10","Abhari o kanarakaa inamisina mia madhaki, maka o mia moparacaeana i KAWASANA OPU ajaganiakea tee kaasina molagina. ");
INSERT INTO wlo_vpl VALUES ("PS32_11","020_32_11","PSA","32","11","11","E manga mia mobanara, masanaamo tee ukaunde-undemo roonamo KAWASANA OPU! Sambo-sambomo, e bhari-bharia mia momakatena incana! ");
INSERT INTO wlo_vpl VALUES ("PS33_1","020_33_1","PSA","33","1","1","Sambo-sambomo rampaakanamo KAWASANA OPU, e manga mia mobanara! Alaengamo mia momakatena incana apuji KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("PS33_2","020_33_2","PSA","33","2","2","Emanimo sukuru i KAWASANA OPU tee umagasiaaka kecapi! Laguakea o lagu kapujia to Incia tee umagasiaakea gambusu sapulu taliana. ");
INSERT INTO wlo_vpl VALUES ("PS33_3","020_33_3","PSA","33","3","3","Laguakea to Incia saangu lagu bhaau! Tikia pekalape o gambusumu, tee usambo-sambomo! ");
INSERT INTO wlo_vpl VALUES ("PS33_4","020_33_4","PSA","33","4","4","Firimanina KAWASANA OPU sumai abanara, tee bhari-bharia ikarajaana abukutiiakea ande Incia amembali atoparacaea. ");
INSERT INTO wlo_vpl VALUES ("PS33_5","020_33_5","PSA","33","5","5","Incia amaasiaka kabanara tee kaʼadili, saangua alamu abukeaka kaasina molagina. ");
INSERT INTO wlo_vpl VALUES ("PS33_6","020_33_6","PSA","33","6","6","Minaaka i firimanina KAWASANA OPU o laiana apamembalia, tee minaaka i poinuncana, bhari-bharia giu i laiana apadhaangiaia. ");
INSERT INTO wlo_vpl VALUES ("PS33_7","020_33_7","PSA","33","7","7","Incia arombusaka uwena tawo mboomo arombusaka uwe i nuncana gusi, tee mboomo andalaoge adhikaia i nuncana bendunga. ");
INSERT INTO wlo_vpl VALUES ("PS33_8","020_33_8","PSA","33","8","8","Taroakamo saangua alamu amaeka i KAWASANA OPU, tee taroakamo bhari-bharia mia i nuncana dunia atungku i Incia. ");
INSERT INTO wlo_vpl VALUES ("PS33_9","020_33_9","PSA","33","9","9","Roonamo Incia afirimani sabutuna bhari-bharia amembali; ande Incia adhawu parinta sabutuna bhari-bharia adhaangia tee amatangka. ");
INSERT INTO wlo_vpl VALUES ("PS33_10","020_33_10","PSA","33","10","10","KAWASANA OPU apabatala opea ifikirina manga lipu, tee apanainda opea ihaejatiakana manga incia. ");
INSERT INTO wlo_vpl VALUES ("PS33_11","020_33_11","PSA","33","11","11","Maka o haejatina KAWASANA OPU sadhaadhaa saʼumurua, tee o isikadina amatangka saʼumurua zamani. ");
INSERT INTO wlo_vpl VALUES ("PS33_12","020_33_12","PSA","33","12","12","Amasanaamo mpuu o lipu mosombana KAWASANA OPU apamembalia Aulataʼalana, amasanaamo mpuu uumati ipilina to mopotibhaakana tinaurakana. ");
INSERT INTO wlo_vpl VALUES ("PS33_13","020_33_13","PSA","33","13","13","KAWASANA OPU apentiro minaaka i sorogaa, tee akamata bhari-bharia maanusia. ");
INSERT INTO wlo_vpl VALUES ("PS33_14","020_33_14","PSA","33","14","14","Minaaka i kauncuramakana, Incia atiliki bhari-bharia momboorena i dunia. ");
INSERT INTO wlo_vpl VALUES ("PS33_15","020_33_15","PSA","33","15","15","KAWASANA OPU mopebhanguina incana bhari-bharia maanusia, KAWASANA OPU mokamatana bhari-bharia ipewauna manga incia. ");
INSERT INTO wlo_vpl VALUES ("PS33_16","020_33_16","PSA","33","16","16","Samia raja inda atopasalaamati minaaka i kabharina suludaduna, samia tantara mobarani inda bheasalaamati minaaka i kakaana. ");
INSERT INTO wlo_vpl VALUES ("PS33_17","020_33_17","PSA","33","17","17","Ajarana potimbea inda amembali atotangkaaka to kasalaamati, Moomini amakaa mpuu, o ajara inda amembali manga pasalaamati. ");
INSERT INTO wlo_vpl VALUES ("PS33_18","020_33_18","PSA","33","18","18","Satotuuna, KAWASANA OPU afaduliaka manga mia momaekaia, tee moharapuakana kaasina molagina ");
INSERT INTO wlo_vpl VALUES ("PS33_19","020_33_19","PSA","33","19","19","to mopasalaamatina manga incia minaaka i mate, tee apakande manga incia i wakutuuna umbaana balaana kaara. ");
INSERT INTO wlo_vpl VALUES ("PS33_20","020_33_20","PSA","33","20","20","Incamami aharapuaka katulungina KAWASANA OPU, Incia motulungina ingkita tee Incia amembali katangkesita. ");
INSERT INTO wlo_vpl VALUES ("PS33_21","020_33_21","PSA","33","21","21","Roonamo Incia o incata akaunde-unde, rampaakanamo ingkita taparacaea i sarona momangkilona. ");
INSERT INTO wlo_vpl VALUES ("PS33_22","020_33_22","PSA","33","22","22","E KAWASANA OPU, taroakamo kaasimu molagina sadhaadhaa to ingkami apokana tee opea mopadhana iharapumami i Ingkoo. ");
INSERT INTO wlo_vpl VALUES ("PS34_1","020_34_1","PSA","34","1","1","Zaburuna Daud, wakutuuna incia apara-para amagila i aroana Abimelekh, sabutuna incia atopadhencu, kasiimpo alingka. ");
INSERT INTO wlo_vpl VALUES ("PS34_2","020_34_2","PSA","34","2","2","Iaku bhekupuji KAWASANA OPU sadia, tee inda kuunto-unto kupuji Incia. ");
INSERT INTO wlo_vpl VALUES ("PS34_3","020_34_3","PSA","34","3","3","Iaku kubangga roonamo opea ipewauna KAWASANA OPU, maasangia manga mia motopisaki arangoa tee akaunde-unde. ");
INSERT INTO wlo_vpl VALUES ("PS34_4","020_34_4","PSA","34","4","4","Maimo tapobhawa-bhawa tamuliangi sarona KAWASANA OPU, tee maimo tapobhawa-bhawaaka tapekalanga sarona! ");
INSERT INTO wlo_vpl VALUES ("PS34_5","020_34_5","PSA","34","5","5","Iaku kudoʼa i KAWASANA OPU, tee Incia alawaniaku, tee arambasakaaku minaaka i bhari-bharia kaekaku. ");
INSERT INTO wlo_vpl VALUES ("PS34_6","020_34_6","PSA","34","6","6","Mia motontona Incia bheakocahea o rouna, tee inda bheamaea. ");
INSERT INTO wlo_vpl VALUES ("PS34_7","020_34_7","PSA","34","7","7","Mia motopisaki sii agora, tee o KAWASANA OPU aperangoia tee apasalaamatia minaaka i bhari-bharia balaa. ");
INSERT INTO wlo_vpl VALUES ("PS34_8","020_34_8","PSA","34","8","8","Malaaʼekatina KAWASANA OPU abulilingi tee ajagani mia momaekaia, tee arambasaka manga incia minaaka i kasukara. ");
INSERT INTO wlo_vpl VALUES ("PS34_9","020_34_9","PSA","34","9","9","Namisimea tee ukamatamea tapanamo kalapena o KAWASANA OPU sumai! Amasanaamo o mia mopeuluna i Incia. ");
INSERT INTO wlo_vpl VALUES ("PS34_10","020_34_10","PSA","34","10","10","Maekamo i KAWASANA OPU, e ingkomiu manga uumatina momangkilo, roonamo inda bheadhaangia ikakurangaakana manga mia momaekana i Incia. ");
INSERT INTO wlo_vpl VALUES ("PS34_11","020_34_11","PSA","34","11","11","Manga singa momangura amalute tee amaara, maka manga mia mopeelona KAWASANA OPU inda bheakakurangaaka manga giu momalape. ");
INSERT INTO wlo_vpl VALUES ("PS34_12","020_34_12","PSA","34","12","12","Maimo e manga anaana, perangoiaku! Iaku bhekuadhariakakomiu umaeka i KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("PS34_13","020_34_13","PSA","34","13","13","Incema mopeeluna dhadhi masanaa, tee mopeeluna umuru marambe, mamudhaakana amembali aniʼimati manga giu malape? ");
INSERT INTO wlo_vpl VALUES ("PS34_14","020_34_14","PSA","34","14","14","Jagania o dhelamu minaaka i momadhakina, tee o bhiwimu minaaka i manga pogau mopekagau. ");
INSERT INTO wlo_vpl VALUES ("PS34_15","020_34_15","PSA","34","15","15","Pekaridho minaaka i giu momadhaki, tee upewaumo manga giu momalape. Peelomo kaʼamani tee kakaana bukumu tee uʼusahamo upomalape. ");
INSERT INTO wlo_vpl VALUES ("PS34_16","020_34_16","PSA","34","16","16","KAWASANA OPU atiliki manga mia mobanara, tee aperangoia ande agora aemani tulungi. ");
INSERT INTO wlo_vpl VALUES ("PS34_17","020_34_17","PSA","34","17","17","KAWASANA OPU amusui manga mia mopewauna kadhaki samatena manga incia, KAWASANA OPU apewau bhari-bharia mia amalinguaka manga mia madhaki sumai. ");
INSERT INTO wlo_vpl VALUES ("PS34_18","020_34_18","PSA","34","18","18","Wakutuuna manga mia mobanara agora, KAWASANA OPU aperangoia, tee arambasakea manga minaaka i bhari-bharia kanarakaana. ");
INSERT INTO wlo_vpl VALUES ("PS34_19","020_34_19","PSA","34","19","19","KAWASANA OPU apomakasu tee manga mia momaidhiidhina incana, Incia apasalaamati mia momatena akalana. ");
INSERT INTO wlo_vpl VALUES ("PS34_20","020_34_20","PSA","34","20","20","Mia mobanara abhari o kanarakaana, maka o KAWASANA OPU arambasakea minaaka i bhari-bharia sumai. ");
INSERT INTO wlo_vpl VALUES ("PS34_21","020_34_21","PSA","34","21","21","KAWASANA OPU ajagani bhari-bharia bukuna, inda saangu uka momakatuna. ");
INSERT INTO wlo_vpl VALUES ("PS34_22","020_34_22","PSA","34","22","22","Giu madhaki bheapekamate mia madhaki, tee o mia mobancina mia mobanara bheatohukumu. ");
INSERT INTO wlo_vpl VALUES ("PS34_23","020_34_23","PSA","34","23","23","KAWASANA OPU apasalaamati manga bhatuana, tee bhari-bharia mia mopeuluna i Incia inda bheatohukumu. ");
INSERT INTO wlo_vpl VALUES ("PS35_1","020_35_1","PSA","35","1","1","Zaburuna Daud. E KAWASANA OPU, upobhaliakea manga mia mobhaliaku, tee upotimbeakea manga mia mopotimbeakaaku. ");
INSERT INTO wlo_vpl VALUES ("PS35_2","020_35_2","PSA","35","2","2","Kenia o katangkesi maidhiidhi tee katangkesi maogemu, tee ubhangumo utulungiaku! ");
INSERT INTO wlo_vpl VALUES ("PS35_3","020_35_3","PSA","35","3","3","Bhindumea o pandanga tee ndamumu to uewangi manga mia mopajereaku! Paumbaaku ande Ingkoomo mopasalaamatiaku! ");
INSERT INTO wlo_vpl VALUES ("PS35_4","020_35_4","PSA","35","4","4","Taroakamo manga mia bhemopekamateaku amaea tee apotibhaaka aebu. Taroakamo manga mia mohaejatiakana kadhaki to iaku asowo tee atopekaea. ");
INSERT INTO wlo_vpl VALUES ("PS35_5","020_35_5","PSA","35","5","5","Taroakamo manga incia mboo kulina bhae ikamburakana ngalu. Taroakamo manga incia apajerea malaaʼekatina KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("PS35_6","020_35_6","PSA","35","6","6","Taroakamo dhalana manga incia amalalanda tee amararo, tee manga incia apajerea malaaʼekatina KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("PS35_7","020_35_7","PSA","35","7","7","Roonamo manga incia ataa katapu to iaku inda tee alasana tee manga incia aseli kabhalongko to arakoaku inda tee sababuna. ");
INSERT INTO wlo_vpl VALUES ("PS35_8","020_35_8","PSA","35","8","8","Taroakamo manga incia abinasa i wakutuu inda inamunamuna, tee taroakamo manga incia apesua i nuncana katapu itaana karona. Taroakamo manga incia akotibu tee abinasa i nuncana. ");
INSERT INTO wlo_vpl VALUES ("PS35_9","020_35_9","PSA","35","9","9","Sumaimo kusambo-sambo roonamo KAWASANA OPU tee kukaunde-unde roonamo Incia apasalaamatiaku. ");
INSERT INTO wlo_vpl VALUES ("PS35_10","020_35_10","PSA","35","10","10","Tee mpuu-mpuuna incaku bhekupogau, \"E KAWASANA OPU, Ingkoo inda tee kadhimbamu! Ingkoo upasalaamati manga mia malute wakutuuna manga mia makaa apisaki manga incia, Ingkoo ujagani manga mia malute tee momisikini minaaka i limana manga mia morampasia.\" ");
INSERT INTO wlo_vpl VALUES ("PS35_11","020_35_11","PSA","35","11","11","Manga mia madhaki adhawu kasakusiina to abhaliaku, tee araeakaaku kupewau manga giu inda imatauku. ");
INSERT INTO wlo_vpl VALUES ("PS35_12","020_35_12","PSA","35","12","12","Kalapeku manga incia abholosia tee kadhaki, ngangarandaku amaasi tee amate o akalaku. ");
INSERT INTO wlo_vpl VALUES ("PS35_13","020_35_13","PSA","35","13","13","Garaaka, wakutuuna manga incia amapii, iaku kupake kae kadhu to tandana ande incaku amaporo. Kusikisaa karoku tee kupoasa, tee kupatungku bhaaku wakutuuna kudoʼa. ");
INSERT INTO wlo_vpl VALUES ("PS35_14","020_35_14","PSA","35","14","14","Mboomo kudoʼaaka sabhangkaku atawa o witinaiku. Iaku kutungku kutangisi manga incia, mboomo mia mosukara motangisina mateana inana. ");
INSERT INTO wlo_vpl VALUES ("PS35_15","020_35_15","PSA","35","15","15","Maka wakutuuna kutosunu, manga incia amasanaa tee aele-eleaku. Manga incia aporomusaka abhaliaku, tee inda aunto-unto afitanaaku. ");
INSERT INTO wlo_vpl VALUES ("PS35_16","020_35_16","PSA","35","16","16","Mboomo manga mia munaafiki, manga incia aele-eleaku torosu tee apakiri-kiriakaaku ngincina. ");
INSERT INTO wlo_vpl VALUES ("PS35_17","020_35_17","PSA","35","17","17","E Kawasana Opu, sakawana naepia Ingkoo soo utonto-tontoaku? Pabebasia o inyawaku minaaka i kahumbunina manga incia, rambasakaaku minaaka i manga musuku mohumbuniaku mboomo manga singa mangura sumai! ");
INSERT INTO wlo_vpl VALUES ("PS35_18","020_35_18","PSA","35","18","18","Sapadhana upasalaamatiaku, iaku bhekusukuru i Ingkoo i tanga-tangana uumatimu, tee bhekupujiko i tanga-tangana mia bhari. ");
INSERT INTO wlo_vpl VALUES ("PS35_19","020_35_19","PSA","35","19","19","Bholi utaroakea manga mia amusuiaku inda tee sababuna akaunde-unde wakutuuna akamataaku kunarakaa, tee bholi utaroakea manga mia abanciaku inda tee sababuna tee apotawaikiaku wakutuuna kusukara. ");
INSERT INTO wlo_vpl VALUES ("PS35_20","020_35_20","PSA","35","20","20","Roonamo mencuana giu pomalape ipogauakana manga incia, maka manga incia apogauaka haejatina to apekagau to abhali manga mia mopomalapena i lipu sii. ");
INSERT INTO wlo_vpl VALUES ("PS35_21","020_35_21","PSA","35","21","21","Manga incia akakee-kee tee ahinaaku kasiimpo apogau, \"Atumpu incamu, ingkami takamatamea ipewaumu!\" ");
INSERT INTO wlo_vpl VALUES ("PS35_22","020_35_22","PSA","35","22","22","E KAWASANA OPU Ingkoo padhamo ukamatea. Bholimo soo utaroaka! E Kawasana Opu, bholimo umaridho minaaka i iaku. ");
INSERT INTO wlo_vpl VALUES ("PS35_23","020_35_23","PSA","35","23","23","Bhangumo uewaaka hakuku, tee parakaraku, e Aulataʼalaku Kawasana Opuku! ");
INSERT INTO wlo_vpl VALUES ("PS35_24","020_35_24","PSA","35","24","24","E KAWASANA OPU, e Aulataʼalaku, adiliaku upapokanea mboomo kabanaramu! Bholi utaroakea manga incia akaunde-unde wakutuuna akamataaku kunarakaa. ");
INSERT INTO wlo_vpl VALUES ("PS35_25","020_35_25","PSA","35","25","25","Bholi utaroakea manga incia apogau i nuncana ngangarandana, \"Atumpu incamu, siitumo ipeelumami!\" Bholi utaroakea manga incia apogau, \"Padhamo tapahancurua!\" ");
INSERT INTO wlo_vpl VALUES ("PS35_26","020_35_26","PSA","35","26","26","Taroakamo manga mia mokaunde-undena mokamataaku wakutuuna kunarakaa amembali amaea tee abingu. Taroakamo manga mia mosomboakana karona amaea tee apotibhaaka aebu. ");
INSERT INTO wlo_vpl VALUES ("PS35_27","020_35_27","PSA","35","27","27","Taroakamo asambo-sambo tee akaunde-unde manga mia gauna bheakamataaku kutopabanara! Taroakamo manga incia bheapogau, \"Tapanamo kaoge o KAWASANA OPU! Incia akaunde-unde ande akamata dhadhina bhatuana amasanaa tee inda akakurangaaka opeopea!\" ");
INSERT INTO wlo_vpl VALUES ("PS35_28","020_35_28","PSA","35","28","28","Sumaimo iaku bhekupakoleleaka kabanaramu, tee kupuji-pujiko saeoa. ");
INSERT INTO wlo_vpl VALUES ("PS36_1","020_36_1","PSA","36","1","1","To kapalana molaguna. Zaburuna Daud, o bhatuana KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("PS36_2","020_36_2","PSA","36","2","2","Dosa apamembali mia madhaki arango pogau inda momalape i nuncana ngangarandana. Mia incia sumai apogau i nuncana ngangarandana, \"Iaku inda kufaraluu kumaeka tee Aulataʼala.\" ");
INSERT INTO wlo_vpl VALUES ("PS36_3","020_36_3","PSA","36","3","3","Roonamo incia awuju karona, tee afikiria ande o mia mosagaanana inda amataua o kasalahana, tee inda dhaangia mobancia. ");
INSERT INTO wlo_vpl VALUES ("PS36_4","020_36_4","PSA","36","4","4","Pogau ibhoasakana satotuuna o kadhaki tee kagau-gau, incia inda aʼaarifu tee inda apewau kalape. ");
INSERT INTO wlo_vpl VALUES ("PS36_5","020_36_5","PSA","36","5","5","Incia ahaejatiaka kadhaki i bhawona kolemana, sadiamo apewau inda momalapena, tee inda amendeu apewau kadhaki. ");
INSERT INTO wlo_vpl VALUES ("PS36_6","020_36_6","PSA","36","6","6","E KAWASANA OPU, kaasimu molagina akawa i laiana, tee kaparacaeamu akawa i taʼina ngalu. ");
INSERT INTO wlo_vpl VALUES ("PS36_7","020_36_7","PSA","36","7","7","Kabanaramu mboomo gunu momakaa, manga kambotumu mboomo andalaogena, E KAWASANA OPU, Ingkoomo modhambaakana maanusia tee binata. ");
INSERT INTO wlo_vpl VALUES ("PS36_8","020_36_8","PSA","36","8","8","Tapanamo kalape o kaasimu molagina, e KAWASANA OPU! Bhari-bharia maanusia ujagania i nuncana peulusana panimu. ");
INSERT INTO wlo_vpl VALUES ("PS36_9","020_36_9","PSA","36","9","9","Manga incia amambosu akande i Bhanuamu, tee atarima manga giu momalape mboomo o umala mosiwulu. ");
INSERT INTO wlo_vpl VALUES ("PS36_10","020_36_10","PSA","36","10","10","Ingkoomo asalana dhadhina bhari-bharia mahaluku, tee kainawamu mosuluwina dhadhimami. ");
INSERT INTO wlo_vpl VALUES ("PS36_11","020_36_11","PSA","36","11","11","Palausakea o kaasimu molagina i mia momatauko, tee kabanaramu i mia momakatena incana. ");
INSERT INTO wlo_vpl VALUES ("PS36_12","020_36_12","PSA","36","12","12","Bholi utaroakaaku ahumbuniaku mia mosombo, atawa apadhencuaku mia madhaki. ");
INSERT INTO wlo_vpl VALUES ("PS36_13","020_36_13","PSA","36","13","13","Kamatea, mia mopewauna kadhaki akotibumo, manga incia apolangkuri tee inda amembali abhangu pendua. ");
INSERT INTO wlo_vpl VALUES ("PS37_1","020_37_1","PSA","37","1","1","Zaburuna Daud. Bholi uʼamara roonamo o mia mopewauna kadhaki, bholi ugigibulu tee pande gau-gau roonamo opea ipotibhaakana, ");
INSERT INTO wlo_vpl VALUES ("PS37_2","020_37_2","PSA","37","2","2","roonamo manga incia bhealausaka amatuu mboomo rumpu, tee amalau mboomo penembula. ");
INSERT INTO wlo_vpl VALUES ("PS37_3","020_37_3","PSA","37","3","3","Paracaeamo i KAWASANA OPU, tee upewaumo momalapena, mbooremo i lipu sumai tee uʼamani. ");
INSERT INTO wlo_vpl VALUES ("PS37_4","020_37_4","PSA","37","4","4","Kaunde-undemo roonamo KAWASANA OPU sumaimo Incia bheadhawuakako opea ipeelumu. ");
INSERT INTO wlo_vpl VALUES ("PS37_5","020_37_5","PSA","37","5","5","Pasaraakaakea o dhadhimu i KAWASANA OPU tee uparacaeamo i Incia, sumaimo Incia bheatulungiko. ");
INSERT INTO wlo_vpl VALUES ("PS37_6","020_37_6","PSA","37","6","6","Incia bheapatiumba kabanaramu mboomo kainawa, tee o kaʼadilimu mboomo caheana matanaeo. ");
INSERT INTO wlo_vpl VALUES ("PS37_7","020_37_7","PSA","37","7","7","Tanangimo, bholi tee uuʼuumu i aroana KAWASANA OPU tee uantagimea. Bholi uʼamara tee mia momalapena dhawuana, atawa tee mia mopekagau. ");
INSERT INTO wlo_vpl VALUES ("PS37_8","020_37_8","PSA","37","8","8","Untomo uʼamara tee ubholimea opea ilumbuakana incamu. Untomo uʼamara, roonamo giu incia sumai bheaumbaaka kadhaki. ");
INSERT INTO wlo_vpl VALUES ("PS37_9","020_37_9","PSA","37","9","9","Satotuuna o mia mopewauna kadhaki bheatopabinasa, maka manga incia moharapuna i KAWASANA OPU bheapotibhaaka tana tinauraka ijanjiakana sumai. ");
INSERT INTO wlo_vpl VALUES ("PS37_10","020_37_10","PSA","37","10","10","Inda amangenge indamo bheadhaangia uka o mia madhaki. Wakutuuna upeeloa i tampana, indamo tee manga incia. ");
INSERT INTO wlo_vpl VALUES ("PS37_11","020_37_11","PSA","37","11","11","Maka o mia mopaporitambena karona bheakotinaurakaaka tana incia sumai, tee akaunde-unde aniʼimati kasanaa motaralabhi-labhi. ");
INSERT INTO wlo_vpl VALUES ("PS37_12","020_37_12","PSA","37","12","12","Mia madhaki ahaejati inda momalape i mia mobanara, tee apakiri-kiriakea tee ngincina. ");
INSERT INTO wlo_vpl VALUES ("PS37_13","020_37_13","PSA","37","13","13","Maka o Aulataʼala apotawaikia roonamo akamatea ande o eona amakasumo. ");
INSERT INTO wlo_vpl VALUES ("PS37_14","020_37_14","PSA","37","14","14","Manga mia madhaki ahela ewangana tee apasiapu panana to apekamate manga mia misikini tee manga mia monarakaa, tee apekamate manga mia momakatena incana. ");
INSERT INTO wlo_vpl VALUES ("PS37_15","020_37_15","PSA","37","15","15","Maka manga incia bheatobhoki badana karona, tee o panana manga incia bheatokatuki. ");
INSERT INTO wlo_vpl VALUES ("PS37_16","020_37_16","PSA","37","16","16","Saidhe o harataana mia mobanara alabhi o kalapena minaaka i mia madhaki mobharina harataana. ");
INSERT INTO wlo_vpl VALUES ("PS37_17","020_37_17","PSA","37","17","17","Roonamo o takiona mia madhaki bheatokatuki, maka o KAWASANA OPU bheajagani mia mobanara. ");
INSERT INTO wlo_vpl VALUES ("PS37_18","020_37_18","PSA","37","18","18","KAWASANA OPU ajagani dhadhina mia inda tee kasalahana, tinaurakana manga incia sadhaadhaa saʼumurua. ");
INSERT INTO wlo_vpl VALUES ("PS37_19","020_37_19","PSA","37","19","19","Manga incia inda bheamaea i wakutuuna kanarakaa, tee i wakutuuna kaara manga incia bheamambosu. ");
INSERT INTO wlo_vpl VALUES ("PS37_20","020_37_20","PSA","37","20","20","Maka o mia madhaki bheabinasa, tee manga musuna KAWASANA OPU bheamofu, mboomo kamba-kamba i tana mokorumpu. Manga incia bheamofu tee atopadha mboomo ombu. ");
INSERT INTO wlo_vpl VALUES ("PS37_21","020_37_21","PSA","37","21","21","Ande dhaangia iadhana mia madhaki, manga incia inda bheapambulia pendua opea iadhana sumai, maka o mia mobanara abukeaka kaasi tee sadia apekadhawu. ");
INSERT INTO wlo_vpl VALUES ("PS37_22","020_37_22","PSA","37","22","22","Satotuuna o mia ibarakatina KAWASANA OPU bheakotinaurakaaka tana ijanjiakana sumai, sainamo o mia itundana bheatopamofu. ");
INSERT INTO wlo_vpl VALUES ("PS37_23","020_37_23","PSA","37","23","23","KAWASANA OPU mosusuakana dhala mobanara, to mia momalapena feʼelina mopasanaana ngangarandana. ");
INSERT INTO wlo_vpl VALUES ("PS37_24","020_37_24","PSA","37","24","24","Moomini asindoli incia inda bheamandawu roonamo KAWASANA OPU atuko limana. ");
INSERT INTO wlo_vpl VALUES ("PS37_25","020_37_25","PSA","37","25","25","Pepuu minaaka kumangura sakawana kumancuana, indapo mina kukamata mia mobanara abholia KAWASANA OPU, atawa o siwuluna amembali pande pengkaemani. ");
INSERT INTO wlo_vpl VALUES ("PS37_26","020_37_26","PSA","37","26","26","Incia abukeaka kaasi tee sadia apekapaadha, tee manga anana amembali barakati to incia. ");
INSERT INTO wlo_vpl VALUES ("PS37_27","020_37_27","PSA","37","27","27","Bholia momadhakina tee upewaumo momalapena, sumaimo ingkoo bheusadhaadhaa umboore to saʼumurua. ");
INSERT INTO wlo_vpl VALUES ("PS37_28","020_37_28","PSA","37","28","28","Roonamo KAWASANA OPU amaasiaka pewau momalape tee moʼadili, tee inda abholi manga mia mosaalihi. Manga incia bheatojagani saʼumurua, maka o siwuluna mia madhaki bheatopamofu. ");
INSERT INTO wlo_vpl VALUES ("PS37_29","020_37_29","PSA","37","29","29","Mia mobanara bheakotinaurakaaka tana ijanjiakana sumai, tee amboore iwe sumai saʼumurua. ");
INSERT INTO wlo_vpl VALUES ("PS37_30","020_37_30","PSA","37","30","30","Mia mobanara o pogauna akohikimati, bhari-bharia ipogauakana aʼadili. ");
INSERT INTO wlo_vpl VALUES ("PS37_31","020_37_31","PSA","37","31","31","Hukumuna Aulataʼalana manga incia adhikaia i nuncana ngangarandana, tee o bhengkalana inda bheasindoli. ");
INSERT INTO wlo_vpl VALUES ("PS37_32","020_37_32","PSA","37","32","32","Mia madhaki amata-matai mia mobanara, tee ahaejati apekamatea. ");
INSERT INTO wlo_vpl VALUES ("PS37_33","020_37_33","PSA","37","33","33","Maka o KAWASANA OPU inda bheataroakea amandawu i limana musuna, atawa ataroakea atohukumu i wakutuuna atoʼadili. ");
INSERT INTO wlo_vpl VALUES ("PS37_34","020_37_34","PSA","37","34","34","Harapumo i KAWASANA OPU tee utaʼatia o parintana, sumaimo Incia bheaangkako to apamembaliko mokotinaurakaakana tana ijanjiakana sumai, tee ingkoo bheukamata manga mia madhaki atopamofu. ");
INSERT INTO wlo_vpl VALUES ("PS37_35","020_37_35","PSA","37","35","35","Saangu wakutuu kukamata mia madhaki mopisakina mia mosagaanana, dhadhina mboomo puuna kau motuwuna ajulu amaoge tee amaowo i lipuna, ");
INSERT INTO wlo_vpl VALUES ("PS37_36","020_37_36","PSA","37","36","36","maka sapadhana sumai incia amofu, tee indamo atokamata. Moomini kupeeloa, indamo kupotibhaakea. ");
INSERT INTO wlo_vpl VALUES ("PS37_37","020_37_37","PSA","37","37","37","Kamatea o mia inda tee kasalahana tee momakatena incana, roonamo manga mia modhadhina mopomalape bheakaunde-unde o siwuluna naile itu. ");
INSERT INTO wlo_vpl VALUES ("PS37_38","020_37_38","PSA","37","38","38","Maka o mia mokodosa bheapabinasea bhari-bharia, tee o siwuluna bheatopamofu. ");
INSERT INTO wlo_vpl VALUES ("PS37_39","020_37_39","PSA","37","39","39","KAWASANA OPU apasalaamati mia mobanara, tee ajagani manga incia i wakutuuna kaseke. ");
INSERT INTO wlo_vpl VALUES ("PS37_40","020_37_40","PSA","37","40","40","KAWASANA OPU atulungi tee apasalaamati manga incia; Incia apasalaamatia minaaka i manga mia madhaki, roonamo manga incia apeulu i KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("PS38_1","020_38_1","PSA","38","1","1","Zaburuna Daud. Zikiri i wakutuuna pasombaana kurubanina kaudhania. ");
INSERT INTO wlo_vpl VALUES ("PS38_2","020_38_2","PSA","38","2","2","E KAWASANA OPU, bholi uhukumuaku i nuncana amaramu, bholi usikisaaku i nuncana pamurumu. ");
INSERT INTO wlo_vpl VALUES ("PS38_3","020_38_3","PSA","38","3","3","Roonamo anana panamu atongke i badaku, tee o limamu amakaa abhebheaku. ");
INSERT INTO wlo_vpl VALUES ("PS38_4","020_38_4","PSA","38","4","4","Inda dhaangia o kalapena namisi i badaku roonamo pamurumu, inda amatangka manga bukuku roonamo dosaku. ");
INSERT INTO wlo_vpl VALUES ("PS38_5","020_38_5","PSA","38","5","5","Manga kasalahaku abhari alaloia o bhaaku, mboomo bhawa momatamo mpuu to iaku. ");
INSERT INTO wlo_vpl VALUES ("PS38_6","020_38_6","PSA","38","6","6","Manga kambelaku akobhou tee amabuto, roonamo o kabhongo-bhongoku. ");
INSERT INTO wlo_vpl VALUES ("PS38_7","020_38_7","PSA","38","7","7","Kapiiku amatamo mpuu, sabutuna inda amembali kukakaro. Saeoa kutangi mboomo mia momaporona incana. ");
INSERT INTO wlo_vpl VALUES ("PS38_8","020_38_8","PSA","38","8","8","Badaku amasodho roonamo amagari buluku, inda dhaangia kalapena namisi i badaku. ");
INSERT INTO wlo_vpl VALUES ("PS38_9","020_38_9","PSA","38","9","9","Tanagaku amapupumo sabutuna inda kunamisi opeopea, iaku kupekidhei roonamo alilaho ngangarandaku. ");
INSERT INTO wlo_vpl VALUES ("PS38_10","020_38_10","PSA","38","10","10","E Kawasana Opu, bhari-bharia pemeliliku atokamata i aroamu, tee peenciku inda kubuniakea minaaka i Ingkoo. ");
INSERT INTO wlo_vpl VALUES ("PS38_11","020_38_11","PSA","38","11","11","Randaku akabhaka-bhaka tee o tanagaku indamo dhaangia, mataku amarawumo. ");
INSERT INTO wlo_vpl VALUES ("PS38_12","020_38_12","PSA","38","12","12","Manga sabhangkaku indamo akasuiaku roonamo panyakiku, witinaiku apekaridho minaaka i iaku. ");
INSERT INTO wlo_vpl VALUES ("PS38_13","020_38_13","PSA","38","13","13","Manga mia bhemopekamateaku ataakaaku katapu, tee manga mia mohaejatiakana kadhaki to iaku apogauaka kahancuru. Manga incia afikiriaka tuaapa carana amembali ahianati mia mosagaanana saeoa. ");
INSERT INTO wlo_vpl VALUES ("PS38_14","020_38_14","PSA","38","14","14","Maka iaku mboomo mia mabhongo inda moporango, mboomo mia mobhea inda momembalina mopogau. ");
INSERT INTO wlo_vpl VALUES ("PS38_15","020_38_15","PSA","38","15","15","Atotuu, iaku mboomo mia inda moporango, rampaakanamo incia sumai inda kutagali. ");
INSERT INTO wlo_vpl VALUES ("PS38_16","020_38_16","PSA","38","16","16","Maka iaku kuharapu i Ingkoo, e KAWASANA OPU. E Kawasana Opu, e Aulataʼalaku, Ingkoomo bhemolawaniaku. ");
INSERT INTO wlo_vpl VALUES ("PS38_17","020_38_17","PSA","38","17","17","Iaku kupogau, \"Ancosala manga incia akaunde-unde akamataaku kusukara, atawa asomboaka karona wakutuuna akamataaku kusindoli.\" ");
INSERT INTO wlo_vpl VALUES ("PS38_18","020_38_18","PSA","38","18","18","Iaku saidhepo kumandawu, tee atorotorosu kunamisi kapii. ");
INSERT INTO wlo_vpl VALUES ("PS38_19","020_38_19","PSA","38","19","19","Iaku kuʼakuia manga kasalahaku, tee kulilaho wakutuuna kufikiri manga dosaku. ");
INSERT INTO wlo_vpl VALUES ("PS38_20","020_38_20","PSA","38","20","20","Manga musuku amakaa tee abhari mpuu, manga incia abanciaku inda tee sababuna. ");
INSERT INTO wlo_vpl VALUES ("PS38_21","020_38_21","PSA","38","21","21","Manga mia abalasi kalapeku tee kadhaki, tee amembali bhaliku garaaka iaku kupewau giu momalape. ");
INSERT INTO wlo_vpl VALUES ("PS38_22","020_38_22","PSA","38","22","22","E KAWASANA OPU, bholi ubholiaku. E Aulataʼalaku, bholi upekaridho minaaka i iaku. ");
INSERT INTO wlo_vpl VALUES ("PS38_23","020_38_23","PSA","38","23","23","Tulungiaku pekadhei, e Kawasana Opu, mopasalaamatiaku. ");
INSERT INTO wlo_vpl VALUES ("PS39_1","020_39_1","PSA","39","1","1","To kapalana molaguna. To Yedutun. Zaburuna Daud. ");
INSERT INTO wlo_vpl VALUES ("PS39_2","020_39_2","PSA","39","2","2","Iaku kupogau, \"Bhekupengkaanaka kujagani karoku mamudhaakana inda kukodosa tee dhelaku. Iaku bhekukoputi muncuku kangengena dhaangia tee mia madhaki i aroaku.\" ");
INSERT INTO wlo_vpl VALUES ("PS39_3","020_39_3","PSA","39","3","3","Iaku inda kupogau sampeampearo; pogau momalape uka inda kubhoasakea, maka o kanarakaaku ahanda amatamo, ");
INSERT INTO wlo_vpl VALUES ("PS39_4","020_39_4","PSA","39","4","4","ngangarandaku alilaho. Ahanda kufikiria, ahanda amasodho ngangarandaku; kasiimpo kupogau, ");
INSERT INTO wlo_vpl VALUES ("PS39_5","020_39_5","PSA","39","5","5","\"E KAWASANA OPU, paumbaakaaku naepia akawa o ajalaku tee dhaangia pia eopo uka o dhadhiku mamudhaakana kumataua ande o umuruku amampodho! ");
INSERT INTO wlo_vpl VALUES ("PS39_6","020_39_6","PSA","39","6","6","Kamatea, tapanamo kampodho o umuru itantuakamu to iaku. Dhadhiku mboomo inda tee maʼanana i matamu. Bhari-bharia maanusia modhaangiana i dunia bheamofu sakijamata mboomo poinunca. Sela ");
INSERT INTO wlo_vpl VALUES ("PS39_7","020_39_7","PSA","39","7","7","Dhadhina maanusia mboomo ngkamia-mia! Ncia-nciamo maanusia moomini apepadhai tanaga, incia arombusaka o harataa wakutuuna dhaangiapo adhadhi, maka samatena, inda amataua incema bhemoniʼimatia.\" ");
INSERT INTO wlo_vpl VALUES ("PS39_8","020_39_8","PSA","39","8","8","\"Sii-sii opea bheiantagiku, e Kawasana Opu? Ingkoomo iharapuku. ");
INSERT INTO wlo_vpl VALUES ("PS39_9","020_39_9","PSA","39","9","9","Rambasakaaku minaaka i bhari-bharia dosaku, tee bholi utaroakaaku aele-eleaku mia mokabhongo-bhongo. ");
INSERT INTO wlo_vpl VALUES ("PS39_10","020_39_10","PSA","39","10","10","Iaku inda kukosuara tee inda kubungkale ngangaku, roonamo Ingkoomo mohukumuaku. ");
INSERT INTO wlo_vpl VALUES ("PS39_11","020_39_11","PSA","39","11","11","Pekaridhoa o limamu to ubhebheaku, sababuna saidhepo kumate roonamo kahukumumu. ");
INSERT INTO wlo_vpl VALUES ("PS39_12","020_39_12","PSA","39","12","12","Ingkoo uadhari maanusia tee kahukumu roonamo kasalahana, Ingkoo mboomo ane upahancuru opea imaasiakamami. Bhari-bharia maanusia tangkanamo mboomo poinunca!\" Sela ");
INSERT INTO wlo_vpl VALUES ("PS39_13","020_39_13","PSA","39","13","13","\"E KAWASANA OPU, perangoia o doʼaku, tee utilikiaku wakutuuna kugora kuemani tulungi. Bholi inda umaheruakea ande kutangi, roonamo iaku sii mboomo samia dhaga moumbana i Ingkoo, mboomo bhari-bharia manga opu-opuaku. ");
INSERT INTO wlo_vpl VALUES ("PS39_14","020_39_14","PSA","39","14","14","Bholi ukamataaku tee pamurumu mamudhaakana amembali kupemboi pendua wakutuuna indapo kumate.\" ");
INSERT INTO wlo_vpl VALUES ("PS40_1","020_40_1","PSA","40","1","1","To kapalana molaguna. Zaburuna Daud. ");
INSERT INTO wlo_vpl VALUES ("PS40_2","020_40_2","PSA","40","2","2","Iaku kuantagi tee kuharapu mpuu katulungina KAWASANA OPU, kasiimpo Incia atilikiaku tee aperangoi goraku. ");
INSERT INTO wlo_vpl VALUES ("PS40_3","020_40_3","PSA","40","3","3","Incia aangkaaku minaaka i bhalona karompa, minaaka i tomba momandala. Incia apaʼamaniaku i bhawona gunu bhatu tee apekatangka bhengkalaku. ");
INSERT INTO wlo_vpl VALUES ("PS40_4","020_40_4","PSA","40","4","4","Incia aadhariakaaku lagu bhaau, lagu kapujia to Aulataʼalata. Abhari o mia bhemokamatea, kasiimpo amaeka tee aparacaea i KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("PS40_5","020_40_5","PSA","40","5","5","Amasanaamo o mia moparacaeana i KAWASANA OPU, incia inda aose mia mosombo, atawa aose mia mosombana barahala. ");
INSERT INTO wlo_vpl VALUES ("PS40_6","020_40_6","PSA","40","6","6","E KAWASANA OPU, e Aulataʼalaku, abhari o giu inda momentela mopadhana ipewaumu tee ihaejatiakamu to ingkami! Inda dhaangia momembalina mopodhimbana tee Ingkoo! Iaku bhekupetulatulaakea tee kubhoasakea, maka abhari laulauna to kugagaria. ");
INSERT INTO wlo_vpl VALUES ("PS40_7","020_40_7","PSA","40","7","7","Ingkoo inda uemani mamudhaakana kudhawuakako kurubani itunu tee pasombaana giuna ikande, maka Ingkoo padhamo ubungkale talingaku. Kurubani itunu tee kurubani kahapusuana dosa inda utuntua. ");
INSERT INTO wlo_vpl VALUES ("PS40_8","020_40_8","PSA","40","8","8","Kasiimpo kupogau, \"Kamatea, iaku kuumba, i nuncana kalulungina kitabi mopadhana motoburi tee momembalina i karoku. ");
INSERT INTO wlo_vpl VALUES ("PS40_9","020_40_9","PSA","40","9","9","Iaku gauku kupewau opea ipeelumu, e Aulataʼalaku, tee o hukumumu dhaangia i nuncana ngangarandaku.\" ");
INSERT INTO wlo_vpl VALUES ("PS40_10","020_40_10","PSA","40","10","10","Iaku padhamo kupakoleleaka kabanara i tampana poromusakaana uumatimu mobharina sumai. Kamatea, iaku inda kutaangi bhiwiku, e KAWASANA OPU, Ingkoo uka umataua! ");
INSERT INTO wlo_vpl VALUES ("PS40_11","020_40_11","PSA","40","11","11","Kabanaramu inda kubuniakea i nuncana ngangarandaku, iaku kupogauaka ande Ingkoo sadia ukeniaka pojanjiamu tee kupogauaka kasalaamati minaaka i Ingkoo. Kaasimu molagina tee kabanaramu inda kurahasiaakea i aroana poromusakaana uumatimu mobhari sumai. ");
INSERT INTO wlo_vpl VALUES ("PS40_12","020_40_12","PSA","40","12","12","E KAWASANA OPU, bholi utaangi rahumatimu to iaku, taroakamo o kaasimu molagina tee kabanaramu sadia ajaganiaku. ");
INSERT INTO wlo_vpl VALUES ("PS40_13","020_40_13","PSA","40","13","13","Roonamo abhari mpuu o balaa molibuaku. Iaku apajereaku manga dosaku tee inda kumembali kupokamata; kabharina alabhia o bulua i bhaaku, sabutuna amateakea akalaku. ");
INSERT INTO wlo_vpl VALUES ("PS40_14","020_40_14","PSA","40","14","14","E KAWASANA OPU, madheimo upasalaamatiaku, e KAWASANA OPU, madheimo utulungiaku! ");
INSERT INTO wlo_vpl VALUES ("PS40_15","020_40_15","PSA","40","15","15","Maasangia manga mia mohaejatina mopekamateaku amaea tee abingu. Maasangia manga mia mohaejatina to mopacilakaaku apalai tee apotibhaaka aebu. ");
INSERT INTO wlo_vpl VALUES ("PS40_16","020_40_16","PSA","40","16","16","Maasangia manga mia moele-eleaku atokidha roonamo manga incia amaea. ");
INSERT INTO wlo_vpl VALUES ("PS40_17","020_40_17","PSA","40","17","17","Taroakamo bhari-bharia mia mopeeloko amasanaa tee akaunde-unde, tee taroakamo bhari-bharia momaasiakana kasalaamati minaaka i Ingkoo sadia apogau, \"Tapanamo kaogena o KAWASANA OPU!\" ");
INSERT INTO wlo_vpl VALUES ("PS40_18","020_40_18","PSA","40","18","18","Iaku sii kunarakaa tee kumisikini, maka o Aulataʼala afaduliakaaku. Ingkoomo motulungiaku tee mopasalaamatiaku, E Aulataʼalaku, bholi upekanoe-noe, pekadheimo utulungiaku. ");
INSERT INTO wlo_vpl VALUES ("PS41_1","020_41_1","PSA","41","1","1","To kapalana molaguna. Zaburuna Daud. ");
INSERT INTO wlo_vpl VALUES ("PS41_2","020_41_2","PSA","41","2","2","Amasanaamo mia mofaduliakana mia misikini! KAWASANA OPU bheapasalaamatia i wakutuuna anarakaa. ");
INSERT INTO wlo_vpl VALUES ("PS41_3","020_41_3","PSA","41","3","3","KAWASANA OPU bheajagania tee adhambaakea. Sabutuna manga mia bheasarongiakea amasanaamo i lipuna mbooresana, tee inda upasaraakaakea i manga musuna. ");
INSERT INTO wlo_vpl VALUES ("PS41_4","020_41_4","PSA","41","4","4","KAWASANA OPU bheatulungia i wakutuuna amapii, tee apauntoa minaaka i kapiina. ");
INSERT INTO wlo_vpl VALUES ("PS41_5","020_41_5","PSA","41","5","5","Iaku kupogau, \"E KAWASANA OPU, maasiakaaku, pauntoa o panyakiku roonamo kukodosamo tee Ingkoo.\" ");
INSERT INTO wlo_vpl VALUES ("PS41_6","020_41_6","PSA","41","6","6","Manga musuku apogauakaaku madhaki, manga incia apogau, \"Naepia incia bheamate mamudhaakana manga mia amalinguakea?\" ");
INSERT INTO wlo_vpl VALUES ("PS41_7","020_41_7","PSA","41","7","7","Manga mia mosoloaku inda amakate o ngangarandana; manga incia apara-para afaduli tee agau-gau. Manga incia apeelo lele madhaki minaaka i iaku, kasiimpo alingka apetulatulaakea i dhala. ");
INSERT INTO wlo_vpl VALUES ("PS41_8","020_41_8","PSA","41","8","8","Bhari-bharia mobanciaku apokamuntuiakaaku, manga incia ahaejatiakaaku tee kadhaki. ");
INSERT INTO wlo_vpl VALUES ("PS41_9","020_41_9","PSA","41","9","9","Pogauna manga incia, \"Kapiina ahanda mpuu, indamo bheamembali atopaunto.\" ");
INSERT INTO wlo_vpl VALUES ("PS41_10","020_41_10","PSA","41","10","10","Sampe moomini o sabhangkaku momakasuna iparacaeaku, mokandena rotiku, ambulimo abhaliaku. ");
INSERT INTO wlo_vpl VALUES ("PS41_11","020_41_11","PSA","41","11","11","Maka Ingkoo, e KAWASANA OPU, susuakaaku o kaasimu, tee pauntoaku minaaka i kapiiku, mamudhaakana amembali kubalasi kadhakina manga musuku. ");
INSERT INTO wlo_vpl VALUES ("PS41_12","020_41_12","PSA","41","12","12","Tee mboo sumai iaku kumataua ande Ingkoo umaasiakaaku roonamo o musuku inda amembali asambo-samboakaaku. ");
INSERT INTO wlo_vpl VALUES ("PS41_13","020_41_13","PSA","41","13","13","Ingkoo utulungiaku roonamo kakatena totona incaku, tee udhikaaku i saripimu saʼumurua. ");
INSERT INTO wlo_vpl VALUES ("PS41_14","020_41_14","PSA","41","14","14","Atopujimo KAWASANA OPU, Aulataʼala isombana miana Israel, sii-sii tee saʼumurua! Aamin! ");
INSERT INTO wlo_vpl VALUES ("PS42_1","020_42_1","PSA","42","1","1","To kapalana molaguna. Lagu kaadharina miana Korah. ");
INSERT INTO wlo_vpl VALUES ("PS42_2","020_42_2","PSA","42","2","2","Mboomo rusa apemeliliaka umala mokouwe, mboo sumai uka iaku kupemeliliaka Ingkoo, e Aulataʼala. ");
INSERT INTO wlo_vpl VALUES ("PS42_3","020_42_3","PSA","42","3","3","Iaku kufaraluu mpuu Aulataʼala, Aulataʼala modhadhi. Naepia amembali kupoaro tee kukamata Aulataʼala? ");
INSERT INTO wlo_vpl VALUES ("PS42_4","020_42_4","PSA","42","4","4","Malo eona kutangi, loluku amembali kinandeku. Saeoa o musuku aele-eleaku tee apogau, \"Iapai o Aulataʼalamu?\" ");
INSERT INTO wlo_vpl VALUES ("PS42_5","020_42_5","PSA","42","5","5","Giumo incia sii iudhaniku, wakutuuna kupetulatulaaka o antona ngangarandaku: Tuaapa i piamo itu kulingka kupobhawa tee mia bhari wakutuu taporope i bhanuana Aulataʼala, kuporiaroaaka dhala poose tasambo-sambo tee tasukuru i nuncana kariaa sumai. ");
INSERT INTO wlo_vpl VALUES ("PS42_6","020_42_6","PSA","42","6","6","Pokia ingkoo umaasi e ngangarandaku, tee ulilaho i nuncana badaku? Harapumo i Aulataʼala roonamo iaku uka bhekupuji Incia tee kasalaamati moumbana minaaka i aroana. ");
INSERT INTO wlo_vpl VALUES ("PS42_7","020_42_7","PSA","42","7","7","E Aulataʼalaku, ngangarandaku ahancuru i nuncana badaku, rampaakanamo sumai iaku bhekuudhaniko minaaka i lipuna Umala Yordan tee Gunu Hermon, tee minaaka i Gunu Mizar. ");
INSERT INTO wlo_vpl VALUES ("PS42_8","020_42_8","PSA","42","8","8","Andalaoge alawani andalaoge mosagaanana tee suarana momakaa o uwe momandawu minaaka i kalangaana. Bhari-bharia ewo tee solomu akangkanaiaku. ");
INSERT INTO wlo_vpl VALUES ("PS42_9","020_42_9","PSA","42","9","9","I wakutuuna aeo KAWASANA OPU aparintaaka kaasina molagina, tee i wakutuuna amalo iaku kulagu, siitumo saangu doʼa to Aulataʼala mopadhadhiaku. ");
INSERT INTO wlo_vpl VALUES ("PS42_10","020_42_10","PSA","42","10","10","Iaku kupogau tee Aulataʼala, gunu bhatuku, \"Pokia umalinguakaaku? Pokia manga musuku apisakiaku sabutuna iaku sadiamo kusukara? ");
INSERT INTO wlo_vpl VALUES ("PS42_11","020_42_11","PSA","42","11","11","Mboomo katobhoki imateaka i nuncana bukuku, manga bhaliku aele-eleaku. Manga incia saeoa aabha, \"Iapai o Aulataʼalamu?\" ");
INSERT INTO wlo_vpl VALUES ("PS42_12","020_42_12","PSA","42","12","12","Pokia ingkoo umaasi, e ngangarandaku, pokia ulilaho i nuncana badaku? Harapumo i Aulataʼala roonamo iaku uka bhekupuji Incia, Aulataʼalaku mopasalaamatiaku. ");
INSERT INTO wlo_vpl VALUES ("PS43_1","020_43_1","PSA","43","1","1","E Aulataʼala, dhawuakumo kaʼadili, tee uewaaka parakaraku i aroana lipu modorohaka. Pabebasiaku minaaka i pande pekagau tee mia madhaki, ");
INSERT INTO wlo_vpl VALUES ("PS43_2","020_43_2","PSA","43","2","2","roonamo Ingkoomo Aulataʼala peulusaku. Pokia Ingkoo umendeuaku? Pokia iaku sadiamo kusukara roonamo kapisakina musu? ");
INSERT INTO wlo_vpl VALUES ("PS43_3","020_43_3","PSA","43","3","3","Lambokoa o kainawamu tee kabanaramu to akapalaikiaku tee abhawaaku i gunumu momangkilo, i tampana mbooresamu. ");
INSERT INTO wlo_vpl VALUES ("PS43_4","020_43_4","PSA","43","4","4","Sumaimo, iaku bhekulingka kuporope i tampa tunuana kurubani to Aulataʼala, iaku bhekupoaro i Aulataʼala, mopasanaaku tee mopaunde-undeaku. Iaku bhekupujiko tee kecapi, e Kawasana Opu, e Aulataʼalaku. ");
INSERT INTO wlo_vpl VALUES ("PS43_5","020_43_5","PSA","43","5","5","Pokia umaasi e ngangarandaku tee pokia ulilaho i nuncana badaku? Uharapumo i Aulataʼala roonamo iaku uka bhekupuji Incia, Aulataʼalaku mopasalaamatiaku. ");
INSERT INTO wlo_vpl VALUES ("PS44_1","020_44_1","PSA","44","1","1","To kapalana molaguna. Zaburuna miana Korah. Laguna kaadhari. ");
INSERT INTO wlo_vpl VALUES ("PS44_2","020_44_2","PSA","44","2","2","E Aulataʼala, ingkami padhamo tarangoa. Opu-opuamami padhamo manga petulatulaaka giu mopadhana ipewaumu i zamanina manga incia, siitumo i zamani mangenge. ");
INSERT INTO wlo_vpl VALUES ("PS44_3","020_44_3","PSA","44","3","3","Ingkoo upadhencu manga lipu mosagaanana tee limamu karomu, kasiimpo upamboore opu-opuamami to kabholosina manga incia. Ingkoo upahancuru manga lipu, maka utaroakea opu-opuamami ajulu o kabharina. ");
INSERT INTO wlo_vpl VALUES ("PS44_4","020_44_4","PSA","44","4","4","Manga incia inda apoewaangiakea to apotibhaaka tana incia sumai, mencuana tee limana manga incia imembaliakana akana, maka tee lima kaanamu tee kuasamu, tee caheana roumu roonamo Ingkoo umaasiaka manga incia. ");
INSERT INTO wlo_vpl VALUES ("PS44_5","020_44_5","PSA","44","5","5","E Aulataʼala, Ingkoomo Rajaku, mopamembalina miana Israel akana. ");
INSERT INTO wlo_vpl VALUES ("PS44_6","020_44_6","PSA","44","6","6","Tee kuasamu ingkami tapadhencu musumami, tee saromu, talandalandaki manga mia bhemoewangina ingkami. ");
INSERT INTO wlo_vpl VALUES ("PS44_7","020_44_7","PSA","44","7","7","Mencuana panaku itangkaakaku, hancuku uka inda apasalaamatiaku. ");
INSERT INTO wlo_vpl VALUES ("PS44_8","020_44_8","PSA","44","8","8","Maka Ingkoomo mopasalaamatina ingkami minaaka i bhalimami, tee upekaea manga mia mobancina ingkami. ");
INSERT INTO wlo_vpl VALUES ("PS44_9","020_44_9","PSA","44","9","9","Roonamo Aulataʼala, ingkami sadia talaguaka lagu kapujia, tee saromu, ingkami bhetasukuru saʼumurua. Sela ");
INSERT INTO wlo_vpl VALUES ("PS44_10","020_44_10","PSA","44","10","10","Maka sii-sii Ingkoo manga bholimo tee manga taroaka tamaea. Ingkoo indamo umaju uka upobhawa tee tantaramami. ");
INSERT INTO wlo_vpl VALUES ("PS44_11","020_44_11","PSA","44","11","11","Ingkoo manga taroaka tapalai minaaka i musumami, tee manga mia mobancina ingkami arampasi harataamami. ");
INSERT INTO wlo_vpl VALUES ("PS44_12","020_44_12","PSA","44","12","12","Ingkoo manga pasarakaaka mboomo dumba isumbele, tee manga papogaa-gaa i lipu mosagaanana. ");
INSERT INTO wlo_vpl VALUES ("PS44_13","020_44_13","PSA","44","13","13","Ingkoo uaso uumatimu inda tee haragaana i musuna to amembali bhatua, tee inda uala laba saidhe uka. ");
INSERT INTO wlo_vpl VALUES ("PS44_14","020_44_14","PSA","44","14","14","Ingkoo utaroaka ingkami mangahina manga lipu sarimbanuamami, tee tamembali kaele-elena manga mia i saripimami. ");
INSERT INTO wlo_vpl VALUES ("PS44_15","020_44_15","PSA","44","15","15","Utaroakea manga lipu apotawaiki ingkami. Manga incia alengko-lengko bhaana to ingkami. ");
INSERT INTO wlo_vpl VALUES ("PS44_16","020_44_16","PSA","44","16","16","Saeoa kutohina, tee kutanggo kaeaku, ");
INSERT INTO wlo_vpl VALUES ("PS44_17","020_44_17","PSA","44","17","17","roonamo kurango kaele-ele tee kahina minaaka i musumami tee manga mia modhikaakana bukuna incana tee ingkami. ");
INSERT INTO wlo_vpl VALUES ("PS44_18","020_44_18","PSA","44","18","18","Bhari-bharia sumai padhamo akangkanai ingkami maka ingkami inda tamalinguakako atawa tahianati janjimu tee ingkami. ");
INSERT INTO wlo_vpl VALUES ("PS44_19","020_44_19","PSA","44","19","19","Incamami inda abhalii minaaka i Ingkoo, tee ingkami inda tabholi o kaadharimu ");
INSERT INTO wlo_vpl VALUES ("PS44_20","020_44_20","PSA","44","20","20","moomini Ingkoo padhamo upahancuru ingkami i tampana serigala, tee udhika ingkami i nuncana kalalanda. ");
INSERT INTO wlo_vpl VALUES ("PS44_21","020_44_21","PSA","44","21","21","Ande ingkami tamalinguaka sarona Aulataʼalamami, atawa tadoʼa tee tasomba i Aulataʼala mosagaanana, ");
INSERT INTO wlo_vpl VALUES ("PS44_22","020_44_22","PSA","44","22","22","Aulataʼala dhaanamo bheamataua, satotuuna Incia amataua o rahasiana ngangarandamami! ");
INSERT INTO wlo_vpl VALUES ("PS44_23","020_44_23","PSA","44","23","23","Saeo-saeo ingkami taaro mate rampaakanamo taose tee tataʼati i Ingkoo, tee ingkami tatoabhi mboomo dumba isumbele. ");
INSERT INTO wlo_vpl VALUES ("PS44_24","020_44_24","PSA","44","24","24","E Aulataʼala, pewaumo. Pokia Ingkoo mboomo ukole? Pewaumo! Bholi manga umendeu saʼumurua. ");
INSERT INTO wlo_vpl VALUES ("PS44_25","020_44_25","PSA","44","25","25","Pokia Ingkoo ubuniaka karomu tee umalinguaka kanarakaa tee kapisakimami? ");
INSERT INTO wlo_vpl VALUES ("PS44_26","020_44_26","PSA","44","26","26","Ingkami takotibu i nuncana ngawu, tee o badamami akumbu i tana. ");
INSERT INTO wlo_vpl VALUES ("PS44_27","020_44_27","PSA","44","27","27","Pewaumo tee tulungimo ingkami! Roonamo kaasimu molagina, manga tolosi! ");
INSERT INTO wlo_vpl VALUES ("PS45_1","020_45_1","PSA","45","1","1","To kapalana molaguna. Aose lagu: Kamba-kamba Bakung. Zaburuna miana Korah. Laguna kaadhari; laguna kaasi. ");
INSERT INTO wlo_vpl VALUES ("PS45_2","020_45_2","PSA","45","2","2","Ngangarandaku abukeaka tee manga lagu makesa. Iaku bhekulaguaka laguku to raja, dhelaku mboomo folupenina samia juru tulisi momakidha. ");
INSERT INTO wlo_vpl VALUES ("PS45_3","020_45_3","PSA","45","3","3","Ingkoo momangadana i tanga-tangana umane, kalapemu atokamata minaaka i pogaumu, sababuna sumai Aulataʼala abarakatiko to saʼumurua. ");
INSERT INTO wlo_vpl VALUES ("PS45_4","020_45_4","PSA","45","4","4","Bhokea o ewangamu i tangamu, e raja mobarani, ingkoo momalangana tee momuliana! ");
INSERT INTO wlo_vpl VALUES ("PS45_5","020_45_5","PSA","45","5","5","I nuncana kamuliangimu sumai usawikimo karetamu tee ukanamo, to kabanara, sifatuna mia inda mosombo, tee kaʼadili! Taroakamo lima kaanamu akarajaa pewauna motomaeka. ");
INSERT INTO wlo_vpl VALUES ("PS45_6","020_45_6","PSA","45","6","6","Anana panamu amatadha, alosa i bhakena manga musumu, manga lipu akotibu i aroamu. ");
INSERT INTO wlo_vpl VALUES ("PS45_7","020_45_7","PSA","45","7","7","Kauncuramakamu, e Aulataʼala, sadhaadhaa torotorosu tee saʼumurua, tee o katukona pamarintamu satotuuna o katukona kabanara. ");
INSERT INTO wlo_vpl VALUES ("PS45_8","020_45_8","PSA","45","8","8","Ingkoo umaasiaka kabanara tee ubanci mia madhaki. Sababuna sumai, Kawasana Opumu, Aulataʼalamu, padhamo alantiko umembali raja tee apasanaako alabhi minaaka i raja mosagaanana. ");
INSERT INTO wlo_vpl VALUES ("PS45_9","020_45_9","PSA","45","9","9","Bhari-bharia pakeamu akobhou mina-mina mawondu mboomo polona damar, garu, tee asana. Ingkoo umasanaa urango suarana kecapi tee gambusu minaaka i maligemu motobhelokiakana gadhi. ");
INSERT INTO wlo_vpl VALUES ("PS45_10","020_45_10","PSA","45","10","10","I tanga-tangana manga bhawine molaianiko dhaangia tee manga bhawine o anana raja. I weta kaanamu akabhale-bhale o ratu mopakena kabheloki bulawa momalape minaaka i Ofir. ");
INSERT INTO wlo_vpl VALUES ("PS45_11","020_45_11","PSA","45","11","11","Perangoiaku pekalape, e kabuabua, kamatea tee utaaia o talingamu! Malinguakamea o lipumu tee bhanuana amamu. ");
INSERT INTO wlo_vpl VALUES ("PS45_12","020_45_12","PSA","45","12","12","Taroakamo o raja apeeluko roonamo umakesa! Incia o opumu, sujumo uhoromatia. ");
INSERT INTO wlo_vpl VALUES ("PS45_13","020_45_13","PSA","45","13","13","Raʼeatina kota Tirus bheabhawaakako pasombaa, tee manga mia morangkaea bheaʼusaha to aala-ala incamu. ");
INSERT INTO wlo_vpl VALUES ("PS45_14","020_45_14","PSA","45","14","14","Anana raja bhemokawina tee rajana Israel apesua i nuncana maligena, pakeana kabuabua sumai abukeaka kasokai bulawa. ");
INSERT INTO wlo_vpl VALUES ("PS45_15","020_45_15","PSA","45","15","15","Incia bheatoʼantara i raja tee pakea motosokai, apoose tee manga sabhangkana, siitumo manga kabuabua molaianina anana raja. ");
INSERT INTO wlo_vpl VALUES ("PS45_16","020_45_16","PSA","45","16","16","Manga incia atoʼantara tee asambo-sambo tee akaunde-unde, manga incia apesua i nuncana maligena raja. ");
INSERT INTO wlo_vpl VALUES ("PS45_17","020_45_17","PSA","45","17","17","E raja, manga anamu bheabholosi opu-opuamu, ingkoo bheuangkea manga to amembali kaogesa i saangua alamu. ");
INSERT INTO wlo_vpl VALUES ("PS45_18","020_45_18","PSA","45","18","18","Iaku bhekupewau saromu amaoge tee bhari-bharia ipewaumu audhania mia sii-sii sakawana i aaherati, sabutuna bhari-bharia lipu bheapuji-pujiko torosu saʼumurua. ");
INSERT INTO wlo_vpl VALUES ("PS46_1","020_46_1","PSA","46","1","1","To kapalana molaguna. Laguna miana Korah; alaguakea tee suara momalanga. ");
INSERT INTO wlo_vpl VALUES ("PS46_2","020_46_2","PSA","46","2","2","Aulataʼala sumai o tampana peulusata tee o kakaata. Incia sadia amakasu to manga tulungi i wakutuuna kaseke. ");
INSERT INTO wlo_vpl VALUES ("PS46_3","020_46_3","PSA","46","3","3","Sumaimo ingkita inda tamaeka, moomini o alamu akolendu, moomini manga gunu atondu i nuncana tawo, ");
INSERT INTO wlo_vpl VALUES ("PS46_4","020_46_4","PSA","46","4","4","tee moomini o tawo akomburu tee akobura tee manga gunu akohudha rampaakanamo akangkanaia ewona tawo sumai. Sela ");
INSERT INTO wlo_vpl VALUES ("PS46_5","020_46_5","PSA","46","5","5","Dhaangia manga siwuluana uwena umala aumbaaka kaunde-unde to raʼeatina kotana Aulataʼala, siitumo o tampa momangkilo, mbooresana Aulataʼala Momalanga. ");
INSERT INTO wlo_vpl VALUES ("PS46_6","020_46_6","PSA","46","6","6","Aulataʼala amboore i tanga-tangana kota sumai, sabutuna o kota sumai inda bheakohudha. Aulataʼala bheatulungia wakutuuna akawa raneeo. ");
INSERT INTO wlo_vpl VALUES ("PS46_7","020_46_7","PSA","46","7","7","Manga raʼeatina lipu atobungke tee manga pamarintana abagoea, rampaakanamo Incia aparangoaka suarana, alamu ahancuru. ");
INSERT INTO wlo_vpl VALUES ("PS46_8","020_46_8","PSA","46","8","8","KAWASANA OPU, kapalana saangua pasukana sorogaa, apoose tee ingkita, Aulataʼala isombana Yakub siitumo o kotana benteta. Sela ");
INSERT INTO wlo_vpl VALUES ("PS46_9","020_46_9","PSA","46","9","9","Mai, kamatea opea ikarajaana KAWASANA OPU, Incia apewau giu inda momentela i alamu! ");
INSERT INTO wlo_vpl VALUES ("PS46_10","020_46_10","PSA","46","10","10","Incia apaunto potimbea i saangua dunia, pana apahancurua tee pandanga akatukia, Incia atunu manga kareta potimbea tee waa. ");
INSERT INTO wlo_vpl VALUES ("PS46_11","020_46_11","PSA","46","11","11","Firimanina, \"Untomo upoewangi, mataumea ande Iaku sii o Aulataʼala! Manga lipu bheapekalangaaku, tee saangua alamu bheamuliangiaku.\" ");
INSERT INTO wlo_vpl VALUES ("PS46_12","020_46_12","PSA","46","12","12","KAWASANA OPU, kapalana saangua pasukana sorogaa, apoose tee ingkita, Aulataʼala isombana Yakub siitumo kotana benteta. Sela ");
INSERT INTO wlo_vpl VALUES ("PS47_1","020_47_1","PSA","47","1","1","To kapalana molaguna. Zaburu minaaka i miana Korah. ");
INSERT INTO wlo_vpl VALUES ("PS47_2","020_47_2","PSA","47","2","2","E bhari-bharia lipu, pujimo Aulataʼala! Bhija-bhijamea o Aulataʼala tee usambo-sambomo. ");
INSERT INTO wlo_vpl VALUES ("PS47_3","020_47_3","PSA","47","3","3","Roonamo KAWASANA OPU Momalanga sumai atomaeka mpuu, Incia o raja maoge mokuasaina saangua alamu. ");
INSERT INTO wlo_vpl VALUES ("PS47_4","020_47_4","PSA","47","4","4","Incia apekatalo manga lipu tee adhawuakea i nuncana kuasata, tee manga lipu adhikaia i tambena aeta. ");
INSERT INTO wlo_vpl VALUES ("PS47_5","020_47_5","PSA","47","5","5","Incia mangapiliaka tana bhemomembalina tinauraka ibanggaakata saʼumurua. Ingkita o siwuluna Yakub, uumati imaasiakana. Sela ");
INSERT INTO wlo_vpl VALUES ("PS47_6","020_47_6","PSA","47","6","6","Wakutuuna Aulataʼala akompa i kauncuramakana, manga mia asambo-sambo tee akaunde-unde, tee atowiiakea sangkakala. ");
INSERT INTO wlo_vpl VALUES ("PS47_7","020_47_7","PSA","47","7","7","Laguakamea o lagu kapujia to Aulataʼala, laguakamea! Laguakamea o lagu kapujia to Rajata, laguakamea! ");
INSERT INTO wlo_vpl VALUES ("PS47_8","020_47_8","PSA","47","8","8","Roonamo Aulataʼala o Rajana saangua alamu, laguakamea o laguna kaadhari! ");
INSERT INTO wlo_vpl VALUES ("PS47_9","020_47_9","PSA","47","9","9","Aulataʼala satotuuna o Rajana bhari-bharia lipu, Incia amboore i bhawona kauncuramakana momangkilo. ");
INSERT INTO wlo_vpl VALUES ("PS47_10","020_47_10","PSA","47","10","10","Manga kapalana lipu aporomusaka to amembali uumatina Aulataʼala isombana Ibrahim. Roonamo bhari-bharia mokuasaina alamu sii atungku i Aulataʼala, Incia atomuliangi mpuu. ");
INSERT INTO wlo_vpl VALUES ("PS48_1","020_48_1","PSA","48","1","1","Zaburuna miana Korah to lagu. ");
INSERT INTO wlo_vpl VALUES ("PS48_2","020_48_2","PSA","48","2","2","Tapanamo kaoge o KAWASANA OPU tee alaenga mpuu atopuji i kotana Aulataʼalata, i gununa momangkilo. ");
INSERT INTO wlo_vpl VALUES ("PS48_3","020_48_3","PSA","48","3","3","Amakesa amalanga, apasanaa mia i saangua alamu, siitumo o gunu Sion i weta i napa, kotana Raja Maoge! ");
INSERT INTO wlo_vpl VALUES ("PS48_4","020_48_4","PSA","48","4","4","I nuncana manga bentena Aulataʼala padhamo apatiumbaaka ande karona satotuuna o bente momakaa. ");
INSERT INTO wlo_vpl VALUES ("PS48_5","020_48_5","PSA","48","5","5","Kamatea, manga raja aporomusaka, manga incia amaju apobhawa-bhawa. ");
INSERT INTO wlo_vpl VALUES ("PS48_6","020_48_6","PSA","48","6","6","Sakamatana kotana Sion, manga incia amente; manga raja atokidha tee apalai roonamo amaeka. ");
INSERT INTO wlo_vpl VALUES ("PS48_7","020_48_7","PSA","48","7","7","Iwe sumai manga incia arengku roonamo amaeka, tee anamisi kapii mboomo bhawine bhemopalaahirina. ");
INSERT INTO wlo_vpl VALUES ("PS48_8","020_48_8","PSA","48","8","8","Tee garura Ingkoo upahancuru manga kapala maoge minaaka i Tarsis. ");
INSERT INTO wlo_vpl VALUES ("PS48_9","020_48_9","PSA","48","9","9","Mboomo mopadhana irangota, mboo siitumo uka ikamatata, i kotana KAWASANA OPUNA saangua alamu, i kotana Aulataʼalata, ipekatangkana Aulataʼala to saʼumurua. Sela ");
INSERT INTO wlo_vpl VALUES ("PS48_10","020_48_10","PSA","48","10","10","E Aulataʼala, ingkami taudhania o kaasimu molagina i nuncana Baitullamu momangkilo. ");
INSERT INTO wlo_vpl VALUES ("PS48_11","020_48_11","PSA","48","11","11","Mboomo saromu, e Aulataʼala, mboo siitumo o mia i saangua alamu amuliangiko. Ingkoo ukokuasa tee uʼadili. ");
INSERT INTO wlo_vpl VALUES ("PS48_12","020_48_12","PSA","48","12","12","Taroakamo raʼeatina Sion akaunde-unde, tee taroakamo manga anana bhawine Yuda asambo-sambo roonamo sadia uʼadili i wakutuuna uhaakimu mia. ");
INSERT INTO wlo_vpl VALUES ("PS48_13","020_48_13","PSA","48","13","13","Lingkamo uumatina Aulataʼala, tiingia o Sion, tee ubulilingia, tee ugagaria manga munarana. ");
INSERT INTO wlo_vpl VALUES ("PS48_14","020_48_14","PSA","48","14","14","Tilikia manga rindina, kamatea o bentena, mamudhaakana amembali upetulatulaakea i manga siwulumu. ");
INSERT INTO wlo_vpl VALUES ("PS48_15","020_48_15","PSA","48","15","15","Satotuuna o siimo Aulataʼala, Aulataʼalata abakaa; Incia bhemokapalaikina ingkita saʼumurua! ");
INSERT INTO wlo_vpl VALUES ("PS49_1","020_49_1","PSA","49","1","1","To kapalana molaguna. Zaburuna miana Korah. ");
INSERT INTO wlo_vpl VALUES ("PS49_2","020_49_2","PSA","49","2","2","Perangoia o giu incia sii, e bhari-bharia lipu, taaia o talingamiu e bhari-bharia raʼeatina dunia, ");
INSERT INTO wlo_vpl VALUES ("PS49_3","020_49_3","PSA","49","3","3","Malape o kaogesa atawa o mia maidhiidhi, mia morangkaea atawa o mia misikini! ");
INSERT INTO wlo_vpl VALUES ("PS49_4","020_49_4","PSA","49","4","4","Ngangaku bheabhoasaka manga pogau imembaliakamiu ubukeaka hikimati, tee ngangarandaku bheafikiri manga giu imembaliakamiu umakidha umaʼanaia. ");
INSERT INTO wlo_vpl VALUES ("PS49_5","020_49_5","PSA","49","5","5","Talingaku bhekubungkalea to kuperangoi manga kabhanti moʼaarifu, poose kumagasiaaka kecapi, bhekubhoasakea maʼanana o taataangkeku. ");
INSERT INTO wlo_vpl VALUES ("PS49_6","020_49_6","PSA","49","6","6","Iaku inda kufaraluu kumaeka i wakutuuna kaseke, wakutuuna kadhakina musuku alibuaku. ");
INSERT INTO wlo_vpl VALUES ("PS49_7","020_49_7","PSA","49","7","7","Manga incia mia motangkaakana harataana tee mosomboakana karangkaeana. ");
INSERT INTO wlo_vpl VALUES ("PS49_8","020_49_8","PSA","49","8","8","Satotuuna, inda samia uka momembalina mopasalaamatina karona samia, atawa apomea katolosina i Aulataʼala to apamembalia kabholosina inyawana ");
INSERT INTO wlo_vpl VALUES ("PS49_9","020_49_9","PSA","49","9","9","roonamo ponambona katolosina inyawana mia amaali mpuu, tee inda bheakawa moomini apomeaia tee opeapo uka ");
INSERT INTO wlo_vpl VALUES ("PS49_10","020_49_10","PSA","49","10","10","mamudhaakana incia amembali adhadhi saʼumurua tee inda bheakamata bhalona koburuna. ");
INSERT INTO wlo_vpl VALUES ("PS49_11","020_49_11","PSA","49","11","11","Maka satotuuna, incia bheakamata mia moʼaarifu uka bheamate, mboo sumai uka tee mia mokabhongo-bhongo tee mia mobhore; manga incia bheabholi harataana to mia mosagaanana. ");
INSERT INTO wlo_vpl VALUES ("PS49_12","020_49_12","PSA","49","12","12","Koburuna manga incia bheamembali bhanuana saʼumurua, mbooresana manga incia asadhaadhaa to saʼumurua, moomini manga incia dhaangia tee tanana karona. ");
INSERT INTO wlo_vpl VALUES ("PS49_13","020_49_13","PSA","49","13","13","Maka o maanusia moomini tee karangkaeana inda bheamembali adhadhi torosu. Maanusia apokana tee binata dhaanamo bheabinasa. ");
INSERT INTO wlo_vpl VALUES ("PS49_14","020_49_14","PSA","49","14","14","Mboo siimo dhawuana mia motangkaakana karona, tee ajalana manga mia momaasiakana pogauna karona. Sela ");
INSERT INTO wlo_vpl VALUES ("PS49_15","020_49_15","PSA","49","15","15","Aulataʼala apatotapuaka manga incia to amate mboomo dumba, manga incia awulua mboomo dumba apesua i bhalona koburu, manga incia bheasapo lausaka i nuncana koburu. Badana manga incia bheamabuto tee ahancuru, amaridho minaaka i bhanuana. ");
INSERT INTO wlo_vpl VALUES ("PS49_16","020_49_16","PSA","49","16","16","Maka o Aulataʼala bheatolosiaku minaaka i duniana mia mate roonamo Incia bheaalaaku minaaka iwe sumai. Sela ");
INSERT INTO wlo_vpl VALUES ("PS49_17","020_49_17","PSA","49","17","17","Bholi umaeka ande o mia mosagaanana amembali arangkaea, tee o harataana ahandamo abhari, ");
INSERT INTO wlo_vpl VALUES ("PS49_18","020_49_18","PSA","49","18","18","roonamo wakutuuna amate, incia inda amembali abhawa opeopeapo uka, tee o harataana inda bheasapo i koburu to apobhawa tee incia. ");
INSERT INTO wlo_vpl VALUES ("PS49_19","020_49_19","PSA","49","19","19","Moomini kangengena dhadhina incia aabhi karona atobarakati tee apuji-pujia mia roonamo akodhawua, ");
INSERT INTO wlo_vpl VALUES ("PS49_20","020_49_20","PSA","49","20","20","incia uka bheatutuni manga opu-opuana, momatena porikana i tampa momalalanda tee iwe sumai, indamo uka bheakamata kainawa pendua. ");
INSERT INTO wlo_vpl VALUES ("PS49_21","020_49_21","PSA","49","21","21","Maanusia morangkaea, maka inda amembali amaʼanai hikimati, amembali tapapokanea tee binata motopabinasa. ");
INSERT INTO wlo_vpl VALUES ("PS50_1","020_50_1","PSA","50","1","1","Zaburuna Asaf. KAWASANA OPU, Aulataʼala Mokokuasana Mpuu, afirimani tee agoraaka saangua alamu minaaka i timbu sakawana i bhara. ");
INSERT INTO wlo_vpl VALUES ("PS50_2","020_50_2","PSA","50","2","2","Minaaka i kota Sion momakesa mpuu, Aulataʼala apatiumba karona mboomo cahea. ");
INSERT INTO wlo_vpl VALUES ("PS50_3","020_50_3","PSA","50","3","3","Aulataʼalata aumba tee inda soo akatongo-tongo; waa imangauaka dhaangia i aroana, tee garura momakaa dhaangia i saripina. ");
INSERT INTO wlo_vpl VALUES ("PS50_4","020_50_4","PSA","50","4","4","Incia agoraaka laiana tee alamu to amembali sakusii wakutuuna aʼadili uumatina. ");
INSERT INTO wlo_vpl VALUES ("PS50_5","020_50_5","PSA","50","5","5","Firimanina, \"Romusakaakaaku bhari-bharia uumatiku mosaalihi i aroaku, siitumo manga incia mopadhana mobokena pojanjia tee Iaku alaloi kurubani isumbele.\" ");
INSERT INTO wlo_vpl VALUES ("PS50_6","020_50_6","PSA","50","6","6","Laiana apakoleleaka kabanarana, roonamo o karona Aulataʼala moʼadilina uumatina. Sela ");
INSERT INTO wlo_vpl VALUES ("PS50_7","020_50_7","PSA","50","7","7","\"Rangoa e uumatiku, Iaku bhekufirimani! E Israel, Iaku bhekumembali sakusii tee opea mopadhana ipewaumu, Iakumo o Kawasana Opu, Aulataʼalamu! ");
INSERT INTO wlo_vpl VALUES ("PS50_8","020_50_8","PSA","50","8","8","Mencuana rampaakanamo kurubani isumbelemu mbakana kuraeakako, atawa o kurubani tunuamu modhaangiana i aroaku. ");
INSERT INTO wlo_vpl VALUES ("PS50_9","020_50_9","PSA","50","9","9","Iaku kumendeu bhekutarima sapi umane minaaka i bhanuamu, atawa o bhembe umane minaaka i kandamu, ");
INSERT INTO wlo_vpl VALUES ("PS50_10","020_50_10","PSA","50","10","10","roonamo bhari-bharia binata maila i koo o pewauaku, tee uka bhari-bharia manga kadhambaaka modhaangiana i rewuna gunu. ");
INSERT INTO wlo_vpl VALUES ("PS50_11","020_50_11","PSA","50","11","11","Iaku kumataua bhari-bharia manu-manu modhaangiana i gunu, tee manga mahaluku modhadhi i nuncana koo o pewauaku. ");
INSERT INTO wlo_vpl VALUES ("PS50_12","020_50_12","PSA","50","12","12","Ande kumaara, inda afaraluu kupaumbaakako, roonamo alamu tee bhari-bharia antona o pewauaku. ");
INSERT INTO wlo_vpl VALUES ("PS50_13","020_50_13","PSA","50","13","13","Iaku inda kukande dagina sapi umane, inda uka kusumpu raana bhembe umane. ");
INSERT INTO wlo_vpl VALUES ("PS50_14","020_50_14","PSA","50","14","14","Sukurumo i Aulataʼala to amembali pasombaamu to Incia, tee upomeaia o tolauna onimu i KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("PS50_15","020_50_15","PSA","50","15","15","Goraakaaku i wakutuuna umaseke, Iaku bhekutulungiko, tee ingkoo bheumuliangiaku.\" ");
INSERT INTO wlo_vpl VALUES ("PS50_16","020_50_16","PSA","50","16","16","Maka to mia madhaki o KAWASANA OPU afirimani, \"Inda tee faʼedana ingkoo usarongi hukumuku, tee upogauaka manga pojanjiaku. ");
INSERT INTO wlo_vpl VALUES ("PS50_17","020_50_17","PSA","50","17","17","Roonamo ingkoo umendeu utoudhaniaka, tee inda umaheruakea uka manga firimaniku. ");
INSERT INTO wlo_vpl VALUES ("PS50_18","020_50_18","PSA","50","18","18","Ande upokawa tee mia manako, ingkoo uposabhangkaakea, tee manga pande zina, ingkoo upooseakea. ");
INSERT INTO wlo_vpl VALUES ("PS50_19","020_50_19","PSA","50","19","19","Muncumu utaroakea abhoasaka manga pogau madhaki, tee o dhelamu sadia apekagau. ");
INSERT INTO wlo_vpl VALUES ("PS50_20","020_50_20","PSA","50","20","20","Ingkoo utorotorosu uraeaka tee upogauaka witinaimu karomu, tee ufitanaaia. ");
INSERT INTO wlo_vpl VALUES ("PS50_21","020_50_21","PSA","50","21","21","Mboo sumaimo ipewaumu, maka Iaku inda tee uuʼuuku, jadi ufikiria ande Iaku sii kupokana tee ingkoo. Maka sii-sii bhekuhukumuko, tee kubhawea o parakara incia sii i aroamu mamudhaakana umaʼanaia. ");
INSERT INTO wlo_vpl VALUES ("PS50_22","020_50_22","PSA","50","22","22","Kamatamea o giu incia sii, e ingkomiu momalinguakana Aulataʼala, kojagamo ancosala Kupabinasakomiu tee inda dhaangia mopasalaamatikomiu. ");
INSERT INTO wlo_vpl VALUES ("PS50_23","020_50_23","PSA","50","23","23","Incema mopasombaakana sukuru i Iaku mboomo kurubani, inciamo amuliangiaku; o mia modhadhina i nuncana kajujuru, Aulataʼala bhekususuakea kasalaamati to incia.\" ");
INSERT INTO wlo_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","To kapalana molaguna. Zaburuna Daud. ");
INSERT INTO wlo_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","I wakutuuna Nabii Natan audhaniaka Raja Daud sapadhana incia apewau zinaa tee Batsyeba. ");
INSERT INTO wlo_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","E Aulataʼala, maasiakaaku roonamo kaasimu molagina. Apokana tee rahumatimu momaoge, hapusumea manga dosaku! ");
INSERT INTO wlo_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","Bhanuia tee pekangkiloa karoku minaaka i kasalahaku, tee pekangkiloaku minaaka i dosaku. ");
INSERT INTO wlo_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","Roonamo kumataua manga kasalahaku, tee dosaku sadia kuudhania. ");
INSERT INTO wlo_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","I Ingkoo, tangkanamo i Ingkoo kukodosa tee kupewau opea iabhimu amadhaki. Sabutuna ubanara i wakutuuna ufirimani ande kusala, tee uʼadili i wakutuuna uhukumuaku. ");
INSERT INTO wlo_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","Satotuuna, kumadhaki pepuu mina kutopalaahiri, tee kukodosa minaaka i nuncana kadhuma. ");
INSERT INTO wlo_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","Satotuuna, Ingkoo upeelu kabanara i nuncana baatini, tee Ingkoo uadhariakaaku hikimati i nuncana ngangarandaku. ");
INSERT INTO wlo_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","Pekangkilomea o dosaku, sumaimo iaku bhekumangkilo, pekangkiloaku sumaimo bhekumembali maputi mpuu. ");
INSERT INTO wlo_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","Taroakamo kurango lele kaunde-unde tee kasanaa, tee taroakamo manga bukuku ipahancurumu sii akaunde-unde pendua. ");
INSERT INTO wlo_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","Tutubhia o roumu tee bholi ukamata manga giu madhaki ipewauku, tee uhapusumea bhari-bharia kasalahaku. ");
INSERT INTO wlo_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","E Aulataʼala, padhaangiakaaku ngangaranda momangkilo, dhikaia o rohi mobhaau tee matangka i nuncana baatiniku. ");
INSERT INTO wlo_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","Bholi ubhanakaaku minaaka i aroamu, tee bholi ualea o rohimu momangkilona. ");
INSERT INTO wlo_vpl VALUES ("PS51_14","020_51_14","PSA","51","14","14","Paunde-undeaku pendua roonamo kasalaamati minaaka i Ingkoo, tee dhawuaku ngangaranda morela to kutaʼati i Ingkoo. ");
INSERT INTO wlo_vpl VALUES ("PS51_15","020_51_15","PSA","51","15","15","Sumaimo, iaku bhekuadhariaka parintamu i manga mia mopewauna kasalaha, tee manga mia mokodosa bheambuli i Ingkoo. ");
INSERT INTO wlo_vpl VALUES ("PS51_16","020_51_16","PSA","51","16","16","Rambasakaaku minaaka i kasalaha roonamo kupekamate mia sagaanana, e Kawasana Opu, e Aulataʼala mopasalaamatiaku, tee bhekulaguaka roonamo kabanaramu. ");
INSERT INTO wlo_vpl VALUES ("PS51_17","020_51_17","PSA","51","17","17","E Aulataʼala, papogauaku, sumaimo iaku bhekupujiko! ");
INSERT INTO wlo_vpl VALUES ("PS51_18","020_51_18","PSA","51","18","18","Sumaimo Ingkoo inda upeelua kurubani isumbele. Moomini iaku kupasombaaka kurubani tunua, Ingkoo inda upeelua. ");
INSERT INTO wlo_vpl VALUES ("PS51_19","020_51_19","PSA","51","19","19","Satotuuna kurubani mopasanaana Aulataʼala sumai o rohi mohancuru. E Aulataʼala, ngangaranda mohancuru tee momapuro inda bheuhinaia. ");
INSERT INTO wlo_vpl VALUES ("PS51_20","020_51_20","PSA","51","20","20","Maasangia Ingkoo usanaa pewau malape i Sion, pakakaroa pendua rindina peulusa i sakaaratea kotana Yerusalem. ");
INSERT INTO wlo_vpl VALUES ("PS51_21","020_51_21","PSA","51","21","21","Sumaimo, bheupeelu utarimaia manga kurubani isumbele molaenga, siitumo kurubani pasombaa itunu tee kurubani pasombaa mototunu saangua, sumaimo mia bheapasombaaka manga sapi umane i bhawona tampana tunuana kurubanimu. ");
INSERT INTO wlo_vpl VALUES ("PS52_1","020_52_1","PSA","52","1","1","To kapalana molaguna. Lagu kaadharina Daud, ");
INSERT INTO wlo_vpl VALUES ("PS52_2","020_52_2","PSA","52","2","2","wakutuuna Doʼeg, miana Edom sumai, aumba apokawa tee Saul tee apaumbaaka ande o Daud akawamo i bhanuana Abimelekh. ");
INSERT INTO wlo_vpl VALUES ("PS52_3","020_52_3","PSA","52","3","3","E mia mobarani, pokia ingkoo usomboaka kadhakimiu? Kaasina Kawasana Opu sadhaadhaana to saʼumurua! ");
INSERT INTO wlo_vpl VALUES ("PS52_4","020_52_4","PSA","52","4","4","Saeo ingkoo uhaejati to upanarakaa mia sagaanana. Pogaumu amatadha mboomo piso motowinto, e mia pande pekagau! ");
INSERT INTO wlo_vpl VALUES ("PS52_5","020_52_5","PSA","52","5","5","Ingkoo ulabhi upeelu momadhakina tee inda upeelu momalapena, labhi upeelu kagau-gau minaaka i upogauaka kabanara. Sela ");
INSERT INTO wlo_vpl VALUES ("PS52_6","020_52_6","PSA","52","6","6","Ingkoo usanaa upekapii incana mia tee manga pogaumu, e pande pekagau! ");
INSERT INTO wlo_vpl VALUES ("PS52_7","020_52_7","PSA","52","7","7","Maka o Aulataʼala bheapahancuruko to saʼumurua. Incia bheasoroko tee apalimbako minaaka i mbooresamu, tee adhikako i nuncana duniana mia mate. Sela ");
INSERT INTO wlo_vpl VALUES ("PS52_8","020_52_8","PSA","52","8","8","Akamata incia sumai, mia mobanara bheamaeka tee amente, kasiimpo apotawaikiko, ");
INSERT INTO wlo_vpl VALUES ("PS52_9","020_52_9","PSA","52","9","9","Manga incia apogau, \"Siitumo mia moindana moemanina peulusa i Kawasana Opu, tabeana soo atangkaaka karangkaeana motaralabhi-labhi, tee apahancuru mia mosagaanana to apekatangka karona.\" ");
INSERT INTO wlo_vpl VALUES ("PS52_10","020_52_10","PSA","52","10","10","Maka, iaku sii mboomo puuna zaitun mosuburu i nuncana bhanuana Aulataʼala. Iaku kuparacaea tee kaasina molagina Aulataʼala to saʼumurua. ");
INSERT INTO wlo_vpl VALUES ("PS52_11","020_52_11","PSA","52","11","11","Iaku sadiamo kusukuru i Ingkoo saʼumurua rampaakanamo opea ipewaumu. Iaku bhekuharapu i saromu i aroana manga mia mosaalihi sababuna saromu amalape. ");
INSERT INTO wlo_vpl VALUES ("PS53_1","020_53_1","PSA","53","1","1","To kapalana molaguna. Mboomo laguna kanarakaa. Lagu kaadharina Daud. ");
INSERT INTO wlo_vpl VALUES ("PS53_2","020_53_2","PSA","53","2","2","Mia mokabhongo-bhongo apogau i nuncana ngangarandana, \"Inda dhaangia o Aulataʼala.\" Pewauna manga incia amadhaki tee atomarika, inda dhaangia mopewauna kalape. ");
INSERT INTO wlo_vpl VALUES ("PS53_3","020_53_3","PSA","53","3","3","Minaaka i sorogaa, Aulataʼala atonto anana maanusia, to akamata ara dhaangia o mia moʼaarifu, mopeelona Aulataʼala. ");
INSERT INTO wlo_vpl VALUES ("PS53_4","020_53_4","PSA","53","4","4","Bhari-bharia mia abholi dhala mobanara tee akarajaa giu momadhaki. Inda dhaangia mopewauna kalape, moomini samia uka. ");
INSERT INTO wlo_vpl VALUES ("PS53_5","020_53_5","PSA","53","5","5","Firimanina Aulataʼala, \"Buaka apesua i akala, ande manga mia mopewauna kadhaki inda amatau giu momalape? Manga incia apekaoge karona tee akande uumatiku mboomo akande roti, tee inda adoʼa i Iaku.\" ");
INSERT INTO wlo_vpl VALUES ("PS53_6","020_53_6","PSA","53","6","6","Maka iwe sumai manga incia bheamaeka mpuu, garaaka inda dhaangia o giu imaeka! Sababuna Aulataʼala apekantale bukuna manga mia moewangiko. Ingkoo bheupekatalo tee upekaea manga incia, sababuna o Aulataʼala amendeu manga incia. ");
INSERT INTO wlo_vpl VALUES ("PS53_7","020_53_7","PSA","53","7","7","Maasangia o kasalaamati to miana Israel aumba minaaka i Sion, kotana Aulataʼala! Wakutuuna Aulataʼala apambuli kadhaangiana uumatina, siwuluna Yakub bheamasanaa o namisina tee o miana Israel bheakaunde-unde. ");
INSERT INTO wlo_vpl VALUES ("PS54_1","020_54_1","PSA","54","1","1","To kapalana molaguna. Tee kagasiana kecapi. Lagu kaadharina Daud ");
INSERT INTO wlo_vpl VALUES ("PS54_2","020_54_2","PSA","54","2","2","wakutuuna miana Zifi aumba apogauaka i Raja Saul, \"Daud apeopo i ingkami.\" ");
INSERT INTO wlo_vpl VALUES ("PS54_3","020_54_3","PSA","54","3","3","E Aulataʼala pasalaamatiaku roonamo saromu, tee adilia parakaraku roonamo kakaamu. ");
INSERT INTO wlo_vpl VALUES ("PS54_4","020_54_4","PSA","54","4","4","Maasangia urangoa doʼaku, e Aulataʼala, rangoa manga pogau ibhoasakaku. ");
INSERT INTO wlo_vpl VALUES ("PS54_5","020_54_5","PSA","54","5","5","Manga mia momalangana incana akakaro aewangiaku, tee manga mia mosombo gauna bheaala inyawaku. Manga incia inda afaduliaka Aulataʼala. Sela ");
INSERT INTO wlo_vpl VALUES ("PS54_6","020_54_6","PSA","54","6","6","Satotuuna Aulataʼala motulungiaku, Kawasana Opu modhambaakaaku. ");
INSERT INTO wlo_vpl VALUES ("PS54_7","020_54_7","PSA","54","7","7","Taroakamo kadhaki ambuli akangkanai manga musuku. Roonamo kaasimu molagina, pabinasamea manga incia! ");
INSERT INTO wlo_vpl VALUES ("PS54_8","020_54_8","PSA","54","8","8","Tee relana totona incaku, iaku bhekupasombaaka kurubani to Ingkoo. Iaku bhekusukuru tee Ingkoo, e KAWASANA OPU, roonamo saromu amalape. ");
INSERT INTO wlo_vpl VALUES ("PS54_9","020_54_9","PSA","54","9","9","Roonamo Ingkoo padhamo urambasakaaku minaaka i sagala kanarakaa, sabutuna kukamata musuku amatalo. ");
INSERT INTO wlo_vpl VALUES ("PS55_1","020_55_1","PSA","55","1","1","To kapalana molaguna. Tee kagasiana kecapi. Lagu kaadharina Daud. ");
INSERT INTO wlo_vpl VALUES ("PS55_2","020_55_2","PSA","55","2","2","E Aulataʼala, perangoia o doʼaku, tee bholi inda ufaduliakea giu iemaniku. ");
INSERT INTO wlo_vpl VALUES ("PS55_3","020_55_3","PSA","55","3","3","Kamataaku tee tulungiaku! Kulilaho tee kupekidhei ");
INSERT INTO wlo_vpl VALUES ("PS55_4","020_55_4","PSA","55","4","4","roonamo kahandana musu tee roonamo kapisakina mia madhaki. Manga incia apanarakaaku, manga incia aʼamaraikiaku tee abanciaku. ");
INSERT INTO wlo_vpl VALUES ("PS55_5","020_55_5","PSA","55","5","5","Ngangarandaku abagoea, kamingkirina mate aoseaku. ");
INSERT INTO wlo_vpl VALUES ("PS55_6","020_55_6","PSA","55","6","6","Iaku kurengku tee kumaeka mpuu, kamingkiri akuasaiaku. ");
INSERT INTO wlo_vpl VALUES ("PS55_7","020_55_7","PSA","55","7","7","Iaku kupogau, \"Ande kukopani mboomo manu-manu jarajara! Iaku bhekupolaka tee kupeelo tampa momalino. ");
INSERT INTO wlo_vpl VALUES ("PS55_8","020_55_8","PSA","55","8","8","Umbe, iaku bhekulingka maridho mpuu, tee kumboore i tana matuu. Sela ");
INSERT INTO wlo_vpl VALUES ("PS55_9","020_55_9","PSA","55","9","9","Iaku bhekupekadhei kupeelo tampa peulusaku minaaka i ngalu makaa tee garura.\" ");
INSERT INTO wlo_vpl VALUES ("PS55_10","020_55_10","PSA","55","10","10","E Kawasana Opu, upabingumea manga musuku tee upapogeso-gesomea pogauna, roonamo kukamata mia apewau kasega tee apogera i nuncana kota. ");
INSERT INTO wlo_vpl VALUES ("PS55_11","020_55_11","PSA","55","11","11","Malo eona manga incia apekatii-tii i bhawona rindina bente motiingina kota, tee i nuncana kota apewau kadhaki tee apanarakaa mia. ");
INSERT INTO wlo_vpl VALUES ("PS55_12","020_55_12","PSA","55","12","12","Manga incia apabinasa mia i tanga-tangana kota, i dhaoa manga incia sadhaadhaa apekapisaki tee apekatipu. ");
INSERT INTO wlo_vpl VALUES ("PS55_13","020_55_13","PSA","55","13","13","Ande o musuku abanciaku, amembali kukapoia, ande o bhaliku ahinaaku amembali kupekaridho. ");
INSERT INTO wlo_vpl VALUES ("PS55_14","020_55_14","PSA","55","14","14","Maka ingkoo mboomo samia witinaiku! Sabhangkaku! Sampomatauku malape! ");
INSERT INTO wlo_vpl VALUES ("PS55_15","020_55_15","PSA","55","15","15","I piamo itu ingkita taposabhangka malape, tee tapobhawa-bhawa talingka i bhanuana Aulataʼala i tanga-tangana mia bhari! ");
INSERT INTO wlo_vpl VALUES ("PS55_16","020_55_16","PSA","55","16","16","Taroakamo manga musuku amate inda atomatau, tee asapo akadhadhi-dhadhi i duniana mia mate, roonamo kadhaki dhaangia i mbooresana tee i tanga-tangana manga incia. ");
INSERT INTO wlo_vpl VALUES ("PS55_17","020_55_17","PSA","55","17","17","Maka iaku bhekugora i Aulataʼala, tee KAWASANA OPU bheapasalaamatiaku. ");
INSERT INTO wlo_vpl VALUES ("PS55_18","020_55_18","PSA","55","18","18","Wakutuuna konowia, saeona, tee pontanga eo, kupeenci tee kupekidhei, tee Incia uka bhearango suaraku. ");
INSERT INTO wlo_vpl VALUES ("PS55_19","020_55_19","PSA","55","19","19","Incia bheatolosiaku minaaka i musu mobhaliaku, roonamo abhari mia moewangiaku. ");
INSERT INTO wlo_vpl VALUES ("PS55_20","020_55_20","PSA","55","20","20","Aulataʼala, mokokauncuramakana pepuu i zamani i piamo itu, bhearangoa doʼaku tee apekatalo manga incia, roonamo manga incia amendeu atoba tee inda amaeka i Aulataʼala. Sela ");
INSERT INTO wlo_vpl VALUES ("PS55_21","020_55_21","PSA","55","21","21","Mia mopadhana kuabhia witinaiku incia sumai apacilaka sabhangkana, tee incia inda akeniakea janjina. ");
INSERT INTO wlo_vpl VALUES ("PS55_22","020_55_22","PSA","55","22","22","Bhoasakana amaʼalusu mpuu to aala-ala inca, maka neatina to apacilaka mia. Pogauna amararo alabhi minaaka i mina, maka satotuuna bhari-bharia sumai mboomo ewanga momatadha. ");
INSERT INTO wlo_vpl VALUES ("PS55_23","020_55_23","PSA","55","23","23","Pasarakaakamea o bhawamu i KAWASANA OPU, sumaimo Incia bheadhambaakako, tee inda bheataroaka mia mobanara abagoea saʼumurua. ");
INSERT INTO wlo_vpl VALUES ("PS55_24","020_55_24","PSA","55","24","24","Maka Ingkoo, e Aulataʼala, bheupapesua manga incia i nuncana kabhalongko momandalana mpuu. Manga pande pekamate tee pande pekagau inda bheakawa samuntanga umuruna. Maka, iaku kuparacaea i Ingkoo. ");
INSERT INTO wlo_vpl VALUES ("PS56_1","020_56_1","PSA","56","1","1","To kapalana molaguna. Mboomo lagu: Manu-manu jarajara mopopoteona i puuna kau tarbantin momaridho. Zaburuna Daud wakutuuna miana Filistin arako incia i Gat. ");
INSERT INTO wlo_vpl VALUES ("PS56_2","020_56_2","PSA","56","2","2","E Kawasana Opu, maasiakaaku roonamo manga mia alanda-landakiaku tee saeoa apisakiaku. ");
INSERT INTO wlo_vpl VALUES ("PS56_3","020_56_3","PSA","56","3","3","Manga musuku sadia alanda-landakiaku, abhari mia moewangiaku, e Aulataʼala Momalanga! ");
INSERT INTO wlo_vpl VALUES ("PS56_4","020_56_4","PSA","56","4","4","I wakutuuna kumaeka, kuparacaea i Ingkoo. ");
INSERT INTO wlo_vpl VALUES ("PS56_5","020_56_5","PSA","56","5","5","Iaku kupuji firimanina Aulataʼala, tee kuparacaea i Aulataʼala, siitumo inda bhekumaeka. Opea momembalina ipewauna maanusia to iaku? Inda dhaangia! ");
INSERT INTO wlo_vpl VALUES ("PS56_6","020_56_6","PSA","56","6","6","Saeoa musuku apatiipambuli pogauku, bhari-bharia haejatina manga incia to iaku amadhaki. ");
INSERT INTO wlo_vpl VALUES ("PS56_7","020_56_7","PSA","56","7","7","Manga incia aporomusaka tee apeopo, alukuti bhengkalaku, tee ahaejati apekamateaku. ");
INSERT INTO wlo_vpl VALUES ("PS56_8","020_56_8","PSA","56","8","8","Balasia manga incia to kadhakina ipewauna; e Kawasana Opu, patobhatamea manga lipu tee amaramu! ");
INSERT INTO wlo_vpl VALUES ("PS56_9","020_56_9","PSA","56","9","9","Ingkoo umataua saopea kabharina kanarakaaku, Udhika loluku i nuncana butolomu. Buaka bhari-bharia dhaangia i nuncana kitabimu? ");
INSERT INTO wlo_vpl VALUES ("PS56_10","020_56_10","PSA","56","10","10","Sumaimo manga musuku bheasowo i wakutuuna kugora. Tee mboo sumai, kumataua ande Aulataʼala aewaakaaku. ");
INSERT INTO wlo_vpl VALUES ("PS56_11","020_56_11","PSA","56","11","11","Iaku kupogauaka kalape to KAWASANA OPU tee kupuji firimanina, roonamo Aulataʼala adhawu janji momalape. ");
INSERT INTO wlo_vpl VALUES ("PS56_12","020_56_12","PSA","56","12","12","Iaku kuparacaea i Incia, siitumo iaku inda bhekumaeka. Opea momembalina ipewauna maanusia to iaku? ");
INSERT INTO wlo_vpl VALUES ("PS56_13","020_56_13","PSA","56","13","13","E Aulataʼala, kuwaajibu bhekupewaua tolauna oniku tee Ingkoo, bhekupasombaaka kurubani kasukuru i Ingkoo. ");
INSERT INTO wlo_vpl VALUES ("PS56_14","020_56_14","PSA","56","14","14","Sababuna Ingkoo upasalaamatiaku minaaka i mate, tee ujaganiaku sabutuna inda kutosunu. Tee mboo sumai, iaku kumembali kulingka i aroana Aulataʼala i nuncana kainawana dhadhi. ");
INSERT INTO wlo_vpl VALUES ("PS57_1","020_57_1","PSA","57","1","1","To kapalana molaguna. Mboomo lagu: Bholi upahancuru. Zaburuna Daud, wakutuuna incia apalaiaka Saul tee aopo i nuncana lia. ");
INSERT INTO wlo_vpl VALUES ("PS57_2","020_57_2","PSA","57","2","2","Maasiakaaku, e Aulataʼala, maasiakaaku, roonamo i Ingkoomo kupeulu. I tambena panimu iaku kupeulu, sakawana garura sumai aunto. ");
INSERT INTO wlo_vpl VALUES ("PS57_3","020_57_3","PSA","57","3","3","Iaku kudoʼa kuemani tulungi i Aulataʼala Momalanga, Aulataʼala apamondo ihaejatiakana to dhadhiku. ");
INSERT INTO wlo_vpl VALUES ("PS57_4","020_57_4","PSA","57","4","4","Maasangia Incia bhealawaniaku minaaka i sorogaa tee apasalaamatiaku, Incia bheapaʼaebu manga mia molanda-landakiaku. Sela Aulataʼala alamboko kaasina molagina tee inda bheamabhotu janjina tee iaku saʼumurua. ");
INSERT INTO wlo_vpl VALUES ("PS57_5","020_57_5","PSA","57","5","5","Iaku kudhaangia i tanga-tangana musu, manga incia mboomo singa mobhembaruna maanusia. Ngincina amatadha mboomo pandanga tee anana pana, tee dhelana mboomo ewanga momatadha. ");
INSERT INTO wlo_vpl VALUES ("PS57_6","020_57_6","PSA","57","6","6","E Aulataʼala, susuakea kaogesamu i laiana tee kamuliangimu i saangua alamu. ");
INSERT INTO wlo_vpl VALUES ("PS57_7","020_57_7","PSA","57","7","7","Manga musuku ataa katapu to iaku, sakawana amate akalaku. Manga incia aseli kabhalongko i aroaku to apacilakaaku, maka o karona manga mokotibuna. Sela ");
INSERT INTO wlo_vpl VALUES ("PS57_8","020_57_8","PSA","57","8","8","Ngangarandaku amatangka, e Aulataʼala, ngangarandaku amatangka. Gauku bhekulaguaka lagu kapujia to Ingkoo. ");
INSERT INTO wlo_vpl VALUES ("PS57_9","020_57_9","PSA","57","9","9","Iaku bhekubhangu tee kumagasiaaka gambusu tee kecapi! Iaku bhekubhangu raneeooge! ");
INSERT INTO wlo_vpl VALUES ("PS57_10","020_57_10","PSA","57","10","10","Iaku bhekusukuru i Ingkoo i tanga-tangana manga lipu, e Kawasana Opu, tee kulaguaka manga lagu kapujia. ");
INSERT INTO wlo_vpl VALUES ("PS57_11","020_57_11","PSA","57","11","11","Sababuna kaasimu molagina amaoge akawa i laiana, tee kabanaramu akawa i taʼina ngalu. ");
INSERT INTO wlo_vpl VALUES ("PS57_12","020_57_12","PSA","57","12","12","E Aulataʼala, susuakea kaogesamu i laiana, tee kamuliangimu i saangua alamu. ");
INSERT INTO wlo_vpl VALUES ("PS58_1","020_58_1","PSA","58","1","1","To kapalana molaguna. Mboomo lagu: Bholi upahancuru. Zaburuna Daud. ");
INSERT INTO wlo_vpl VALUES ("PS58_2","020_58_2","PSA","58","2","2","E manga mia mokokuasa, atotuu buaka udhawu kambotu mobanara? Buaka ujujuru i wakutuuna uʼadili maanusia? ");
INSERT INTO wlo_vpl VALUES ("PS58_3","020_58_3","PSA","58","3","3","Inda, uhaejatiaka momadhakina i nuncana ngangarandamiu, tee upewau kasega tee limamiu i bhawona alamu. ");
INSERT INTO wlo_vpl VALUES ("PS58_4","020_58_4","PSA","58","4","4","Mia madhaki asaladhala pepuu minaaka alaahiri, tee agau-gau minaaka i nuncana kadhuma. ");
INSERT INTO wlo_vpl VALUES ("PS58_5","020_58_5","PSA","58","5","5","Manga incia mboomo ulo mokobisa tee mboomo ulo momabhongo momendeuna morango ");
INSERT INTO wlo_vpl VALUES ("PS58_6","020_58_6","PSA","58","6","6","sabutuna inda arango suarana pande parikana ulo, moomini suarana pande baca doʼa moʼahalii. ");
INSERT INTO wlo_vpl VALUES ("PS58_7","020_58_7","PSA","58","7","7","E Aulataʼala, upahancurumea o ngincina i nuncana ngangana. Hobutimea nginci mantoana manga singa mangura, e KAWASANA OPU! ");
INSERT INTO wlo_vpl VALUES ("PS58_8","020_58_8","PSA","58","8","8","Taroakamo manga incia aila mboomo uwe motobusaka kasiimpo indamo atokamata. Wakutuuna manga incia ahela panana, o panana manga amembalimo amakundu. ");
INSERT INTO wlo_vpl VALUES ("PS58_9","020_58_9","PSA","58","9","9","Taroakamo manga incia mboomo bhiku morere amembali nggalanggala, mboomo rahasia momatena i nuncana kadhuma tee indapo akamata matana eo. ");
INSERT INTO wlo_vpl VALUES ("PS58_10","020_58_10","PSA","58","10","10","Indapo asadaria, manga incia abinasamo, ibaratina mboomo rumpu mokorui momaijo tee indapo amaoge, maka aporikanamo atowiia ngalu tee apolakaakea mboomo penembulana momalau. Amarana Kawasana Opu bheakangkanaia i wakutuuna manga incia dhaangiapo adhadhi. ");
INSERT INTO wlo_vpl VALUES ("PS58_11","020_58_11","PSA","58","11","11","Mia mobanara bheakaunde-unde wakutuuna manga incia akamata kabalasina to mia madhaki, tee abhanui aena tee raana manga incia. ");
INSERT INTO wlo_vpl VALUES ("PS58_12","020_58_12","PSA","58","12","12","Mia bheapogau, \"Totuu dhaangia fahala to mia mobanara! Satotuuna, Aulataʼala modhawuna kaʼadili i alamu!\" ");
INSERT INTO wlo_vpl VALUES ("PS59_1","020_59_1","PSA","59","1","1","To kapalana molaguna. Mboomo lagu: Bholi upahancuru. Zaburuna Daud, siitumo wakutuuna Raja Saul atumpu mia to alibu bhanuana Daud tee ahaejati to apekamatea. ");
INSERT INTO wlo_vpl VALUES ("PS59_2","020_59_2","PSA","59","2","2","E Aulataʼalaku, rambasakaaku minaaka i manga musuku, jaganiaku minaaka i manga mia moewangiaku. ");
INSERT INTO wlo_vpl VALUES ("PS59_3","020_59_3","PSA","59","3","3","Rambasakaaku minaaka i manga mia mopewauna kadhaki, tee pasalaamatiaku minaaka i pande pekamatena mia. ");
INSERT INTO wlo_vpl VALUES ("PS59_4","020_59_4","PSA","59","4","4","Kamatea, manga incia aopo tee aantagiaku kulalo mamudhaakana amembali apekamateaku, manga mia makaa aporomusaka to aewangiaku, garaaka iaku inda kupewau kasalaha, tee uka inda kupewau dosa, e KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("PS59_5","020_59_5","PSA","59","5","5","Moomini inda dhaangia o kasalahaku, manga incia abuntuli tee amakanu aewangiaku. Bhangumo, upokawaakaaku tee ukamata kadhaangiaku! ");
INSERT INTO wlo_vpl VALUES ("PS59_6","020_59_6","PSA","59","6","6","E KAWASANA OPU, Ingkoo Aulataʼalana saangua alamu isombana miana Israel. Maasangia ubhangumo to uhukumu bhari-bharia lipu! Bholi umaasi i bhari-bharia mia mopewauna kadhaki tee pande hianati. Sela ");
INSERT INTO wlo_vpl VALUES ("PS59_7","020_59_7","PSA","59","7","7","I wakutuuna konowia manga incia ambulimo, tee akaolu-olu mboomo mantoa mobulilingina kota. ");
INSERT INTO wlo_vpl VALUES ("PS59_8","020_59_8","PSA","59","8","8","Kamatea, ngangana manga incia apekasindiri! Dhelana manga incia mboomo ewanga momatadha, roonamo manga pande hianati afikiri, \"Inda dhaangia manga rangona!\" ");
INSERT INTO wlo_vpl VALUES ("PS59_9","020_59_9","PSA","59","9","9","Maka Ingkoo, upotawaiki manga incia, e KAWASANA OPU, Ingkoo uele-ele bhari-bharia lipu. ");
INSERT INTO wlo_vpl VALUES ("PS59_10","020_59_10","PSA","59","10","10","E kakaaku, iaku bhekuantagiko; roonamo Ingkoo, e Aulataʼala, satotuuna o kota benteku. ");
INSERT INTO wlo_vpl VALUES ("PS59_11","020_59_11","PSA","59","11","11","Aulataʼala i nuncana kaasi molagina bhemopokawaakaaku, tee bheataroakaaku kukamata manga musuku atotalo. ");
INSERT INTO wlo_vpl VALUES ("PS59_12","020_59_12","PSA","59","12","12","Bholi upekamate manga incia mamudhaakana lipuku inda amalingu; maka tee kuasamu upapogaa-gaaia tee pakotibumea manga incia, e Aulataʼala, peulusamami! ");
INSERT INTO wlo_vpl VALUES ("PS59_13","020_59_13","PSA","59","13","13","Roonamo dosa minaaka i muncuna tee pogau ibhoasakana dhelana, taroakamo manga incia atorako i nuncana kasombona. Roonamo katunda tee kagau-gau ibhoasakana manga incia, ");
INSERT INTO wlo_vpl VALUES ("PS59_14","020_59_14","PSA","59","14","14","pabinasamea i nuncana amaramu; pabinasamea sampe amapupu. Tee mboo sumai, mia bheamataua ande Kawasana Opu aparintangi lipuna Israel, tee uka bhari-bharia lipu i dunia. Sela ");
INSERT INTO wlo_vpl VALUES ("PS59_15","020_59_15","PSA","59","15","15","I wakutuuna konowia manga incia ambulimo, tee akaolu-olu mboomo mantoa atiingi kota. ");
INSERT INTO wlo_vpl VALUES ("PS59_16","020_59_16","PSA","59","16","16","Manga incia apekalingka-lingka apeelo kinandena, tee akaolu-olu ande inda amambosu. ");
INSERT INTO wlo_vpl VALUES ("PS59_17","020_59_17","PSA","59","17","17","Maka iaku bhekulaguaka kuasamu, i saeona iaku bhekusambo-sambo roonamo kaasimu molagina, sababuna Ingkoo mboomo bente mojaganiaku tee tampana peulusaku i wakutuuna kanarakaaku. ");
INSERT INTO wlo_vpl VALUES ("PS59_18","020_59_18","PSA","59","18","18","E kakaaku, i Ingkoomo iaku bhekulaguaka manga lagu kapujia, roonamo Ingkoomo, e Aulataʼala, benteku mojaganiaku, Kawasana Opu momaasiakaaku. ");
INSERT INTO wlo_vpl VALUES ("PS60_1","020_60_1","PSA","60","1","1","To kapalana molaguna. Aose lagu: Kamba Bakung Kasakusii. Zaburuna Daud, to atoadhariaka ");
INSERT INTO wlo_vpl VALUES ("PS60_2","020_60_2","PSA","60","2","2","wakutuuna incia aewangi miana Aram-Naharaim tee miana Aram-Zoba, tee wakutuuna Yoab ambuli sapadhana apekamate 12.000 miana Edom i Mbolongana Asin. ");
INSERT INTO wlo_vpl VALUES ("PS60_3","020_60_3","PSA","60","3","3","E Aulataʼala, Ingkoo padhamo manga mendeu, tee utaroaka manga musu akatuki katangkesimami. Ingkoo uʼamara tee ingkami, maka sii-sii upekalapea pendua kadhaangiamami minaaka i kanarakaa. ");
INSERT INTO wlo_vpl VALUES ("PS60_4","020_60_4","PSA","60","4","4","Ingkoo padhamo ulendu alamu tee upaporuawetaia, tulungi upekalapea pendua manga ngkolelena, roonamo dunia sii atorende. ");
INSERT INTO wlo_vpl VALUES ("PS60_5","020_60_5","PSA","60","5","5","Utaroakea uumatimu anamisi giu momatamo, upasumpu ingkami angguru sakawana tadida. ");
INSERT INTO wlo_vpl VALUES ("PS60_6","020_60_6","PSA","60","6","6","Ingkoo padhamo upabhale tombi to manga mia momaekana tee Ingkoo mamudhaakana manga incia aporomusaka iwe sumai to apeulu minaaka i manga pande pana. Sela ");
INSERT INTO wlo_vpl VALUES ("PS60_7","020_60_7","PSA","60","7","7","Manga pakana tee kuasamu tee uperangoimea o doʼamami, mamudhaakana manga mia imaasiakamu atopasalaamati. ");
INSERT INTO wlo_vpl VALUES ("PS60_8","020_60_8","PSA","60","8","8","Aulataʼala padhamo afirimani i tampana momangkilo, \"Iaku gauku kukaunde-unde, tee kupodhawu-dhawuaka Tana Sikhem, tee kuʼukuru Mbolongana Sukot. ");
INSERT INTO wlo_vpl VALUES ("PS60_9","020_60_9","PSA","60","9","9","Gilead tee Manasye o pewauaku, Efraim mboomo helem minaaka i ase mojaganina bhaaku, tee Yuda katukona pamarintaku. ");
INSERT INTO wlo_vpl VALUES ("PS60_10","020_60_10","PSA","60","10","10","Maka o Tana Moab amembali palangga tampana bhanuiana aeku, tee i bhawona Tana Edom kutudhaaka sandaliku. E Tana Filistin, Iaku kusambo-sambomo roonamo padhamo kutaloko!\" ");
INSERT INTO wlo_vpl VALUES ("PS60_11","020_60_11","PSA","60","11","11","Incema bhemobhawaaku i kota mokobentena makaa sumai? Incema momembalina moʼantaraaku sakawana i Edom? ");
INSERT INTO wlo_vpl VALUES ("PS60_12","020_60_12","PSA","60","12","12","E Aulataʼala, buaka mencuana Ingkoo mangabhanakana? E Aulataʼala, Ingkoo inda umaju upobhawa tee tantaramami to taewangi musu. ");
INSERT INTO wlo_vpl VALUES ("PS60_13","020_60_13","PSA","60","13","13","Manga tulungi minaaka i musu, roonamo o katulungina maanusia inda akoguna. ");
INSERT INTO wlo_vpl VALUES ("PS60_14","020_60_14","PSA","60","14","14","Tapobhawa tee Aulataʼala ingkita tamembali tatalo musuta, sababuna Incia bhemopahancuruna musuta. ");
INSERT INTO wlo_vpl VALUES ("PS61_1","020_61_1","PSA","61","1","1","To kapalana molaguna. Tee kagasiana kecapi. Zaburuna Daud. ");
INSERT INTO wlo_vpl VALUES ("PS61_2","020_61_2","PSA","61","2","2","E Aulataʼala rangoa igoraakaku, perangoia o doʼaku. ");
INSERT INTO wlo_vpl VALUES ("PS61_3","020_61_3","PSA","61","3","3","Minaaka i tapana alamu kugoraakako wakutuuna amate akalaku. Bhawaaku i gunu bhatu molabhina kalangana minaaka i karoku ");
INSERT INTO wlo_vpl VALUES ("PS61_4","020_61_4","PSA","61","4","4","roonamo Ingkoomo peulusaku, munara momakaa to kupeuluaka minaaka i musuku. ");
INSERT INTO wlo_vpl VALUES ("PS61_5","020_61_5","PSA","61","5","5","Taroakamo saʼumurua dhadhiku kumboore i nuncana Kema Momangkilomu, mamudhaakana kuʼamani i nuncana peulusana panimu. Sela ");
INSERT INTO wlo_vpl VALUES ("PS61_6","020_61_6","PSA","61","6","6","Sababuna Ingkoo padhamo urango tolauna oniku, e Aulataʼala, tee padhamo udhawuaku tinauraka idhawuakamu to mia momaekako. ");
INSERT INTO wlo_vpl VALUES ("PS61_7","020_61_7","PSA","61","7","7","Maasangia upekarambe umuruna raja, mamudhaakana incia adhadhi saʼumurua. ");
INSERT INTO wlo_vpl VALUES ("PS61_8","020_61_8","PSA","61","8","8","Maasangia incia amembali raja saʼumurua i aroana Aulataʼala, parintaakamea o kaasimu molagina tee janjimu inda momabhotu to mojagania. ");
INSERT INTO wlo_vpl VALUES ("PS61_9","020_61_9","PSA","61","9","9","Sumaimo iaku sadia bhekulaguaka lagu kapujia to saromu, tee kupomea tolauna oniku saesaeo. ");
INSERT INTO wlo_vpl VALUES ("PS62_1","020_62_1","PSA","62","1","1","To kapalana molaguna. Mboomo: Yedutun. Zaburuna Daud. ");
INSERT INTO wlo_vpl VALUES ("PS62_2","020_62_2","PSA","62","2","2","Tangkanamo i saripina Aulataʼala o namisiku amalimua, minaakamo i Incia o kasalaamatiku. ");
INSERT INTO wlo_vpl VALUES ("PS62_3","020_62_3","PSA","62","3","3","Tangkanamo Incia gunu bhatuku tee mopasalaamatiaku, Incia mboomo kota bente moewaakaaku, iaku inda bhekukohudha sampeampearo. ");
INSERT INTO wlo_vpl VALUES ("PS62_4","020_62_4","PSA","62","4","4","Sakawana naepia ingkomiu uhumbuni mia? E bhari-bharikomiu, buaka ingkomiu bheubhebhe mia ihumbunimiu, mboomo ubhebhe rindi mobhele tee tondo momakasuna motobhata? ");
INSERT INTO wlo_vpl VALUES ("PS62_5","020_62_5","PSA","62","5","5","Manga incia tangkanamo ahaejati to apasabua minaaka i kauncuramakana momalangana, manga incia sadia agau-gau, tee o muncuna manga incia aemani barakati, maka i nuncana ngangarandana apekatunda. Sela ");
INSERT INTO wlo_vpl VALUES ("PS62_6","020_62_6","PSA","62","6","6","E ngangarandaku, tangkanamo i Aulataʼala o namisiku amalimua roonamo tangkanamo Incia iharapuku. ");
INSERT INTO wlo_vpl VALUES ("PS62_7","020_62_7","PSA","62","7","7","Tangkanamo Incia o gunu bhatuku tee mopasalaamatiaku, Incia o benteku, iaku inda bhekukohudha. ");
INSERT INTO wlo_vpl VALUES ("PS62_8","020_62_8","PSA","62","8","8","Aulataʼala modhawuaku kasalaamati tee mopamembaliaku kumulia, Incia o gunu bhatuku momakaa tee o tampana peulusaku. ");
INSERT INTO wlo_vpl VALUES ("PS62_9","020_62_9","PSA","62","9","9","E manga witinai, sadiamo uparacaea i Aulataʼala, palimbamea antona ngangarandamu i aroana, sababuna Incia o tampana peulusata. Sela ");
INSERT INTO wlo_vpl VALUES ("PS62_10","020_62_10","PSA","62","10","10","Mia mohina mboomo sampearo poinunca, tee o mia momulia inda amembali atoparacaea. Atotimbangi manga incia bhari-bharia amagaagaa, alabhi o kagaa-gaana minaaka i ngalu. ");
INSERT INTO wlo_vpl VALUES ("PS62_11","020_62_11","PSA","62","11","11","Bholi uparacaea tee hasili ipotibhaakamiu minaaka i uhanda mia, tee bholi uharapuaka harataa irampasi. Ande o harataamiu ajulu o kabharina, incamu bholi aposaronaka i harataamiu sumai. ");
INSERT INTO wlo_vpl VALUES ("PS62_12","020_62_12","PSA","62","12","12","Sampearo Aulataʼala afirimani, rua giu irangoku, siitumo ande o kuasa minaaka i Aulataʼala, ");
INSERT INTO wlo_vpl VALUES ("PS62_13","020_62_13","PSA","62","13","13","tee minaaka i Ingkoo uka o kaasi molagina, e Kawasana Opu. Roonamo Ingkoo mobalasina bhari-bharia mia apokana mboomo ipewauna. ");
INSERT INTO wlo_vpl VALUES ("PS63_1","020_63_1","PSA","63","1","1","Zaburuna Daud wakutuuna incia adhaangia i Tana Matuuna Yuda. ");
INSERT INTO wlo_vpl VALUES ("PS63_2","020_63_2","PSA","63","2","2","E Aulataʼala, Ingkoomo Aulataʼalaku, iaku kupeeloko, tee gauku kupokawa tee Ingkoo. Saangua badaku apemeliliakako, mboomo mia molingkana i tana matuu mofaraluuna uwe. ");
INSERT INTO wlo_vpl VALUES ("PS63_3","020_63_3","PSA","63","3","3","Mboo sumaimo kutontoko i tampamu momangkilo to kukamataaka kuasamu tee kamuliangimu. ");
INSERT INTO wlo_vpl VALUES ("PS63_4","020_63_4","PSA","63","4","4","Roonamo kaasimu molagina alabhi akoharagaa minaaka i dhadhi, sababuna sumai kupujiko. ");
INSERT INTO wlo_vpl VALUES ("PS63_5","020_63_5","PSA","63","5","5","Mboo sumaimo bhekupujiko saʼumurua dhadhiku, tee kuangka limaku to kumuliangi saromu. ");
INSERT INTO wlo_vpl VALUES ("PS63_6","020_63_6","PSA","63","6","6","Atumpu incaku, mboomo tee kinande momambaka, tee kupujiko tee bhiwiku mokaunde-unde, ");
INSERT INTO wlo_vpl VALUES ("PS63_7","020_63_7","PSA","63","7","7","wakutuu kuudhaniko i kolemaku, tee kufikiriko samaloa. ");
INSERT INTO wlo_vpl VALUES ("PS63_8","020_63_8","PSA","63","8","8","Roonamo Ingkoomo motulungiaku, i tambena panimu iaku kusambo-sambo. ");
INSERT INTO wlo_vpl VALUES ("PS63_9","020_63_9","PSA","63","9","9","Ngangarandaku bheakeniakako pekatangka, lima kaanamu atukoaku. ");
INSERT INTO wlo_vpl VALUES ("PS63_10","020_63_10","PSA","63","10","10","Maka manga mia mohaejatina mopekamateaku bheapesua i tambena tana tee manga mia mate; ");
INSERT INTO wlo_vpl VALUES ("PS63_11","020_63_11","PSA","63","11","11","manga musuku bheatopekamateaka tee hancu, tee amembali kinandena serigala. ");
INSERT INTO wlo_vpl VALUES ("PS63_12","020_63_12","PSA","63","12","12","Maka raja bheakaunde-unde roonamo katulungina Aulataʼala; bhari-bharia mia moposumpana tee Aulataʼala bheabangga, roonamo Incia bheasoncongi ngangana manga pande gau-gau. ");
INSERT INTO wlo_vpl VALUES ("PS64_1","020_64_1","PSA","64","1","1","To kapalana molaguna. Zaburuna Daud. ");
INSERT INTO wlo_vpl VALUES ("PS64_2","020_64_2","PSA","64","2","2","E Aulataʼala, maasangia urango doʼaku i wakutuuna kupeenci, pasalaamatia inyawaku minaaka i kasegana musu. ");
INSERT INTO wlo_vpl VALUES ("PS64_3","020_64_3","PSA","64","3","3","Jaganiaku minaaka i haejati irahasiaakana manga mia madhaki, tee minaaka i isikadina manga mia mopewauna kadhaki. ");
INSERT INTO wlo_vpl VALUES ("PS64_4","020_64_4","PSA","64","4","4","Pogauna manga amatadha mboomo hancu, tee pogau ibhoasakana amapii mboomo anana pana. ");
INSERT INTO wlo_vpl VALUES ("PS64_5","020_64_5","PSA","64","5","5","Manga incia apana manga mia inda mosala minaaka i tampana opoana, sumaimo alausaka apanea inda tee kaekana. ");
INSERT INTO wlo_vpl VALUES ("PS64_6","020_64_6","PSA","64","6","6","Manga incia sadia ahaejatiaka momadhakina, apomufakati to ataa katapu tee apobuniaka, tee apogau i nuncana ngangarandana, \"Inda dhaangia manga kamatana!\" ");
INSERT INTO wlo_vpl VALUES ("PS64_7","020_64_7","PSA","64","7","7","Manga incia ahaejatiaka kadhaki tee apogau, \"Ihaejatiakamami amondomo!\" Manga incia abuniaka opea ihaejatiakana, roonamo ngangarandana maanusia inda amembali amataua mia mosagaanana. ");
INSERT INTO wlo_vpl VALUES ("PS64_8","020_64_8","PSA","64","8","8","Maka Aulataʼala apana manga incia tee saanampuu manga incia amambela. ");
INSERT INTO wlo_vpl VALUES ("PS64_9","020_64_9","PSA","64","9","9","Aulataʼala bheapasindoli manga incia rampaakanamo dhelana; bhari-bharia mia mokamatea bhearengku tee abhibhi. ");
INSERT INTO wlo_vpl VALUES ("PS64_10","020_64_10","PSA","64","10","10","Bhari-bharia mia bheamaeka; manga incia bheapetulatulaaka opea mopadhana ipewauna Aulataʼala, tee bheafikiri opea mopadhana ipewauna. ");
INSERT INTO wlo_vpl VALUES ("PS64_11","020_64_11","PSA","64","11","11","Taroakamo mia mobanara akaunde-unde roonamo KAWASANA OPU tee apeulu i Incia. Taroakamo bhari-bharia mia momakatena incana bheabangga tee Incia! ");
INSERT INTO wlo_vpl VALUES ("PS65_1","020_65_1","PSA","65","1","1","To kapalana molaguna. Zaburuna Daud. Laguna. ");
INSERT INTO wlo_vpl VALUES ("PS65_2","020_65_2","PSA","65","2","2","E Aulataʼala, alaengamo ingkami tapujiko i Sion, tee tapomea o tolauna onimami i Ingkoo. ");
INSERT INTO wlo_vpl VALUES ("PS65_3","020_65_3","PSA","65","3","3","Sababuna Ingkoomo moperangoina doʼa, i Ingkoomo bhari-bharia maanusia bheaumba. ");
INSERT INTO wlo_vpl VALUES ("PS65_4","020_65_4","PSA","65","4","4","Wakutuuna dosamami alabhi o katamona minaaka i kakaamami, Ingkoomo moʼamponina kasalahamami. ");
INSERT INTO wlo_vpl VALUES ("PS65_5","020_65_5","PSA","65","5","5","Amasanaamo mia ipilimu tee ipekakasumu to amboore i aroana Bhanuamu. Bheapatumpu incamami tee bhari-bharia momalapena modhaangiana i Bhanuamu, siitumo i nuncana Baitullamu momangkilo. ");
INSERT INTO wlo_vpl VALUES ("PS65_6","020_65_6","PSA","65","6","6","Tee manga pewaumu moʼadili tee inda momentela Ingkoo ulawani ingkami, e Kawasana Opu, mopasalaamatina ingkami. Ingkoomo iparacaeana saangua alamu tee i tawo momaridho mpuu. ");
INSERT INTO wlo_vpl VALUES ("PS65_7","020_65_7","PSA","65","7","7","Minaaka i kakaamu, upakaro manga gunu; upakanaakea kuasamu momakaana. ");
INSERT INTO wlo_vpl VALUES ("PS65_8","020_65_8","PSA","65","8","8","Ingkoomo mopauntona suarana pamuruna tawo, siitumo suarana pamuruna ewona, tee karobhona manga lipu. ");
INSERT INTO wlo_vpl VALUES ("PS65_9","020_65_9","PSA","65","9","9","Manga mia i saangua alamu amaeka akamata manga tanda inda momentela ipewaumu. Minaaka i timbu sakawana i bhara, upewaua asambo-sambo tee akaunde-unde. ");
INSERT INTO wlo_vpl VALUES ("PS65_10","020_65_10","PSA","65","10","10","Tana sumai udhambaakea tee udhawua wao, Upasuburua sabutuna hasilina abhari mpuu. Umalana Aulataʼala abukeaka tee uwe, tee upasadiaakea gandum to maanusia, mboo sumaimo upatotapuakea. ");
INSERT INTO wlo_vpl VALUES ("PS65_11","020_65_11","PSA","65","11","11","Ingkoo sadia upakouwe tana ibhingkunina, tee uparatea manga tongkana tanana, upekagodhea tee wao, tee ubarakati manga penembulana. ");
INSERT INTO wlo_vpl VALUES ("PS65_12","020_65_12","PSA","65","12","12","Roonamo kalapemu, satao-satao udhawuakea timpua, I iapaipo ubhengkala, ubholi manga giu momalape. ");
INSERT INTO wlo_vpl VALUES ("PS65_13","020_65_13","PSA","65","13","13","Manga rumpu i tana matuu atuwu asuburu, manga gunu akaunde-unde. ");
INSERT INTO wlo_vpl VALUES ("PS65_14","020_65_14","PSA","65","14","14","Manga tana mokorumpu abukeaka gulumana dumba, tee manga mbolonga atipuaka gandum. Bhari-bharia asambo-sambo tee alagu akaunde-unde. ");
INSERT INTO wlo_vpl VALUES ("PS66_1","020_66_1","PSA","66","1","1","To kapalana molaguna. Laguna Zaburu. Sambo-sambomo to Aulataʼala, e saangua alamu! ");
INSERT INTO wlo_vpl VALUES ("PS66_2","020_66_2","PSA","66","2","2","Laguakamo manga lagu kapujia tee umuliangimea o sarona, muliangimea o kapujiana to Incia. ");
INSERT INTO wlo_vpl VALUES ("PS66_3","020_66_3","PSA","66","3","3","Pakawaakea i Aulataʼala, \"Tapanamo atomaeka ipewaumu! Roonamo kuasamu amaoge, sumaimo o musu-musumu atungku tee arengku i aroamu. ");
INSERT INTO wlo_vpl VALUES ("PS66_4","020_66_4","PSA","66","4","4","Saangua dunia asuju asombako. Manga incia apuji-pujiko, tee alaguaka lagu kapujia to saromu.\" Sela ");
INSERT INTO wlo_vpl VALUES ("PS66_5","020_66_5","PSA","66","5","5","Mai, kamatea opea ipewauna Aulataʼala, ipewauna inda momentela to maanusia. ");
INSERT INTO wlo_vpl VALUES ("PS66_6","020_66_6","PSA","66","6","6","Incia abhalii tawo amembali tana matuu, tee manga opu-opuata apolimba i umala tee adhala ae. Siitumo ingkita takaunde-unde roonamo bhari-bharia ipewauna. ");
INSERT INTO wlo_vpl VALUES ("PS66_7","020_66_7","PSA","66","7","7","Incia aparinta tee kakaana to saʼumurua, tee o matana ajagani manga lipu mamudhaakana manga mia mobhalia inda asomboaka karona. Sela ");
INSERT INTO wlo_vpl VALUES ("PS66_8","020_66_8","PSA","66","8","8","Pujimo Aulataʼalamami, e manga lipu, parangoakamea o kapujiamiu i Incia! ");
INSERT INTO wlo_vpl VALUES ("PS66_9","020_66_9","PSA","66","9","9","Incia mojagani inyawamami mamudhaakana inda tamate, tee inda ataroakea o aemami asindoli. ");
INSERT INTO wlo_vpl VALUES ("PS66_10","020_66_10","PSA","66","10","10","E Aulataʼala, Ingkoo padhamo manga uuji, tee manga pekangkilo mboomo mia mopekangkilona pera i nuncana waa. ");
INSERT INTO wlo_vpl VALUES ("PS66_11","020_66_11","PSA","66","11","11","Ingkoo upapesua ingkami i nuncana jari, tee udhika bhawa momatamo i bhawona torukumami. ");
INSERT INTO wlo_vpl VALUES ("PS66_12","020_66_12","PSA","66","12","12","Ingkoo utaroakea manga mia alanda-landaki bhaamami. Ingkami talaloi waa tee mawa, maka Ingkoo ubhawa ingkami i tampa momalape tee momalalesa. ");
INSERT INTO wlo_vpl VALUES ("PS66_13","020_66_13","PSA","66","13","13","Iaku bhekupesua i nuncana bhanuamu tee kubhawa kurubani itunu. Iaku bhekupomea tolauna oniku ");
INSERT INTO wlo_vpl VALUES ("PS66_14","020_66_14","PSA","66","14","14","ibhoasakaku minaaka i ngangaku i wakutuuna kumaseke. ");
INSERT INTO wlo_vpl VALUES ("PS66_15","020_66_15","PSA","66","15","15","Iaku bhekupasombaaka to Ingkoo manga kurubani itunu minaaka i binata momalompo, tee momawonduna bhouna minaaka i dumba umane. Iaku bhekupasombaakako manga sapi umane tee bhembe umane. Sela ");
INSERT INTO wlo_vpl VALUES ("PS66_16","020_66_16","PSA","66","16","16","Mai perangoia, e bhari-bharia mia momaeka i Aulataʼala! Iaku bhekupetulatulaaka opea mopadhana ipewauna to iaku. ");
INSERT INTO wlo_vpl VALUES ("PS66_17","020_66_17","PSA","66","17","17","Tee ngangaku kugoraakea sabutuna o dhelaku alaguaka lagu kapujia to Incia. ");
INSERT INTO wlo_vpl VALUES ("PS66_18","020_66_18","PSA","66","18","18","Ande kumaasiaka giu madhaki i nuncana ngangarandaku, atantumo o Aulataʼala amendeu aperangoiaku. ");
INSERT INTO wlo_vpl VALUES ("PS66_19","020_66_19","PSA","66","19","19","Maka o Aulataʼala aperangoia, Incia amaheruakaaku wakutuuna kudoʼa. ");
INSERT INTO wlo_vpl VALUES ("PS66_20","020_66_20","PSA","66","20","20","Atopujimo o Aulataʼala, moperangoina doʼaku tee inda apekaridhoakaaku o kaasina molagina minaaka i karoku. ");
INSERT INTO wlo_vpl VALUES ("PS67_1","020_67_1","PSA","67","1","1","To kapalana molaguna. Tee kagasiana kecapi. Laguna Zaburu. ");
INSERT INTO wlo_vpl VALUES ("PS67_2","020_67_2","PSA","67","2","2","Maasangia o Aulataʼala manga maasiaka tee manga barakati, maasangia Incia manga kamata tee kalapena incana, Sela ");
INSERT INTO wlo_vpl VALUES ("PS67_3","020_67_3","PSA","67","3","3","tee mboo sumai, maanusia i bhawona alamu sii amataua opea ipeelumu to manga incia, tee bhari-bharia lipu amataua ande Ingkoo mokokuasana to mopasalaamatina manga incia. ");
INSERT INTO wlo_vpl VALUES ("PS67_4","020_67_4","PSA","67","4","4","E Aulataʼala, maasangia manga lipu apujiko, maasangia bhari-bharia lipu apujiko. ");
INSERT INTO wlo_vpl VALUES ("PS67_5","020_67_5","PSA","67","5","5","Maasangia manga lipu akaunde-unde tee asambo-sambo roonamo Ingkoo tee kaʼadili uhaakimu manga lipu, tee utonda bhari-bharia lipu i bhawona alamu. Sela ");
INSERT INTO wlo_vpl VALUES ("PS67_6","020_67_6","PSA","67","6","6","Maasangia manga lipu apujiko, e Aulataʼala, maasangia bhari-bharia lipu apujiko. ");
INSERT INTO wlo_vpl VALUES ("PS67_7","020_67_7","PSA","67","7","7","Alamu padhamo adhawuaka hasilina; Aulataʼala, Aulataʼalata, padhamo abarakati ingkita. ");
INSERT INTO wlo_vpl VALUES ("PS67_8","020_67_8","PSA","67","8","8","Maasangia Aulataʼala manga barakati torosu; maasangia bhari-bharia lipu i bhawona dunia amaekaia. ");
INSERT INTO wlo_vpl VALUES ("PS68_1","020_68_1","PSA","68","1","1","To kapalana molaguna. Zaburuna Daud. Laguna. ");
INSERT INTO wlo_vpl VALUES ("PS68_2","020_68_2","PSA","68","2","2","Taroakamo Aulataʼala akakaro tee apewau musuna apogaa-gaa; taroakamo manga mia mobancia amatalo tee apalai minaaka i aroana. ");
INSERT INTO wlo_vpl VALUES ("PS68_3","020_68_3","PSA","68","3","3","Mboomo ombu aila wakutuuna atowiia ngalu, taroakamo Ingkoo uwulu manga incia. Mboomo taru arere i aroana waa, taroakamo mia madhaki abinasa i aroana Aulataʼala. ");
INSERT INTO wlo_vpl VALUES ("PS68_4","020_68_4","PSA","68","4","4","Maka taroakamo o mia mobanara akaunde-unde, taroakamo manga incia amasanaa i aroana Aulataʼala, tee taroakamo manga incia asambo-sambo tee akaunde-unde. ");
INSERT INTO wlo_vpl VALUES ("PS68_5","020_68_5","PSA","68","5","5","Lagumo to Aulataʼala, laguakamo lagu kapujia to sarona! Pasiapuakea dhala oge to Incia mosawina i taʼina ngalu! Sarona o KAWASANA OPU, kaunde-undemo i aroana! ");
INSERT INTO wlo_vpl VALUES ("PS68_6","020_68_6","PSA","68","6","6","Amana manga ana maelu tee moewaakana manga iaiaro siitumo o Aulataʼala i tampana mbooresana momangkilo. ");
INSERT INTO wlo_vpl VALUES ("PS68_7","020_68_7","PSA","68","7","7","Mia momboorena samia-miana Aulataʼala aposaangua i nuncana saangu bhanua, Incia apabebasi mia mototorongku sabutuna manga incia amasanaamo dhadhina, maka manga mia mobhalia amboore i tana matuu. ");
INSERT INTO wlo_vpl VALUES ("PS68_8","020_68_8","PSA","68","8","8","E Aulataʼala, wakutuuna ukapalai uumatimu wakutuuna apotimbe, tee wakutuuna ulaloi tana matuu, Sela ");
INSERT INTO wlo_vpl VALUES ("PS68_9","020_68_9","PSA","68","9","9","alamu akolendu, tee o laiana apasapo wao, roonamo umbaana Aulataʼala isombana miana Israel, siitumo isarongiakana Aulataʼala i Sinai. ");
INSERT INTO wlo_vpl VALUES ("PS68_10","020_68_10","PSA","68","10","10","E Aulataʼala, amaranca mpuu Ingkoo upasapo wao, tee upasuburu tana tinaurakamu i wakutuuna amatuu; ");
INSERT INTO wlo_vpl VALUES ("PS68_11","020_68_11","PSA","68","11","11","sabutuna o uumatimu ambooresia. E Aulataʼala, tee kalapemu udhawuakea bhari-bharia ifaraluuna mia misikini. ");
INSERT INTO wlo_vpl VALUES ("PS68_12","020_68_12","PSA","68","12","12","Kawasana Opu apakawaaka firimanina, tee rombongana mia bhari mobhawana lele malape sumai. ");
INSERT INTO wlo_vpl VALUES ("PS68_13","020_68_13","PSA","68","13","13","\"Manga raja tee tantarana apalai, umbe, apalaiaka karona!\" Manga bhawine momboorena i nuncana bhanua apodhawu-dhawuaka bara irampasi minaaka i tampana potimbea. ");
INSERT INTO wlo_vpl VALUES ("PS68_14","020_68_14","PSA","68","14","14","Moomini ingkomiu apotidhole i tanga-tangana kandana dumba, bara irampasimiu mboomo panina jarajara ilapisiaka pera, buluna minaaka i bulawa mokokila! ");
INSERT INTO wlo_vpl VALUES ("PS68_15","020_68_15","PSA","68","15","15","Wakutuuna o Kawasana Opu Mokokuasana apapogaa-gaa manga raja iwe sumai, asapomo salju i Gunu Zalmon. ");
INSERT INTO wlo_vpl VALUES ("PS68_16","020_68_16","PSA","68","16","16","Gunu Basan o gunu momakaa. Gunu mobharina tubuna, siitumo o Gunu Basan. ");
INSERT INTO wlo_vpl VALUES ("PS68_17","020_68_17","PSA","68","17","17","E Gunu Basan mobharina tubuna, pokia ingkoo ugigibulu tee Gunu Sion ipilina Aulataʼala to amembali tampana kauncuramakana? Satotuuna o KAWASANA OPU bheamboore iwe sumai saʼumurua! ");
INSERT INTO wlo_vpl VALUES ("PS68_18","020_68_18","PSA","68","18","18","Kawasana Opu aumbamo minaaka i Gunu Sinai tee apesua i tampana momangkilo tee puluna rewu kareta potimbeana, inda atolentu o kabharina. ");
INSERT INTO wlo_vpl VALUES ("PS68_19","020_68_19","PSA","68","19","19","Ingkoo ukompa i tampa momalanga tee ubhawa manga mia mototaangi i talikumu. Ingkoo utarima hadia mobhari minaaka i maanusia, moomini minaaka i manga mia mobhaliko. KAWASANA OPU, Aulataʼala, bheamboore iwe sumai. ");
INSERT INTO wlo_vpl VALUES ("PS68_20","020_68_20","PSA","68","20","20","Atopujimo Kawasana Opu, mosodhana bhawata saesaeo. Incia o Aulataʼala mopasalaamatina ingkita. Sela ");
INSERT INTO wlo_vpl VALUES ("PS68_21","020_68_21","PSA","68","21","21","Aulataʼalata satotuuna o Aulataʼala mopasalaamatina ingkita, tee KAWASANA OPU motulungina ingkita mamudhaakana inda tamate. ");
INSERT INTO wlo_vpl VALUES ("PS68_22","020_68_22","PSA","68","22","22","Maka o Aulataʼala bheapurokoti bhaana musuna, tee kauwana bhaana mokobulua minaaka i manga mia mosadhaadhaana modhadhina i nuncana kasalaha. ");
INSERT INTO wlo_vpl VALUES ("PS68_23","020_68_23","PSA","68","23","23","Kawasana Opu afirimani, \"Iaku bhekubhawea pendua o musumu minaaka i Basan; bhekubhawea pendua manga incia minaaka i tawo momandala ");
INSERT INTO wlo_vpl VALUES ("PS68_24","020_68_24","PSA","68","24","24","mamudhaakana ingkomiu amembali ubhanui aemu tee raana manga incia, tee manga mantoamu amembali apotibhaaka dhawuna tee atumpu incana adhelapia.\" ");
INSERT INTO wlo_vpl VALUES ("PS68_25","020_68_25","PSA","68","25","25","Manga mia padhamo akamatako wakutuuna ambeliakako mboomo raja, e Aulataʼala; ambeliakako o Kawasana Opuku, o Rajaku to ulingka uporope i mbooresamu momangkilo. ");
INSERT INTO wlo_vpl VALUES ("PS68_26","020_68_26","PSA","68","26","26","Manga molaguna adhaangia i aroa, momagasiaakana kecapi i taliku, i tanga-tanga manga kabuabua mobhebhena ganda-ganda. Mboo siimo laguna manga incia, ");
INSERT INTO wlo_vpl VALUES ("PS68_27","020_68_27","PSA","68","27","27","\"Pujimea o Aulataʼala i tanga-tangana uumatina momaoge, Pujimea o KAWASANA OPU, e bhari-bharikomiu siwuluna Israel!\" ");
INSERT INTO wlo_vpl VALUES ("PS68_28","020_68_28","PSA","68","28","28","Bhaa-bhaana o siwuluna Binyamin, momembalina kamia momaidhiidhi mpuu mokapalaina manga incia, kasiimpo aosea manga lakina Yuda i saangu rombongana, kasiimpo manga lakina Zebulon tee lakina Naftali. ");
INSERT INTO wlo_vpl VALUES ("PS68_29","020_68_29","PSA","68","29","29","E Aulataʼala, palimbamea o kakaamu. E Aulataʼala, susuakamea o kakaamu, mboomo mopadhana ipewaumu to ingkami. ");
INSERT INTO wlo_vpl VALUES ("PS68_30","020_68_30","PSA","68","30","30","Rampaakanamo Bhanuamu i Yerusalem, manga raja abhawa pasombaa to Ingkoo. ");
INSERT INTO wlo_vpl VALUES ("PS68_31","020_68_31","PSA","68","31","31","Gorampangia o Mesir, lipu mboomo binata maila i tanga-tangana gelaga, gorampangia o Mesir, lipu mboomo gulumana sapi umane tee manga anana, siitumo manga lipu mokokuasa. Pahancurua manga incia momasoʼoakana pera, papogaa-gaaia manga lipu momaasiakana potimbea. ");
INSERT INTO wlo_vpl VALUES ("PS68_32","020_68_32","PSA","68","32","32","Manga potolowea bheaumba minaaka i Mesir, tee miana Etiopia lausaka bheataanaka limana tee adhawu pasombaana i Aulataʼala. ");
INSERT INTO wlo_vpl VALUES ("PS68_33","020_68_33","PSA","68","33","33","Lagumo to Aulataʼala, e bhari-bharia lipu i dunia sii! Laguakamo lagu kapujia to Kawasana Opu, Sela ");
INSERT INTO wlo_vpl VALUES ("PS68_34","020_68_34","PSA","68","34","34","to Incia mosawina i kareta modhalana i bhawona laiana, siitumo laiana modhaangiana pepuu minaaka i zamani mangenge. Rangoa, Incia apaperangoaka suarana, suarana amakaa tee akoguntu. ");
INSERT INTO wlo_vpl VALUES ("PS68_35","020_68_35","PSA","68","35","35","Akuimea o kuasana Aulataʼala! Kaogena dhaangia i bhawona lipu Israel, kuasana akawea i laiana. ");
INSERT INTO wlo_vpl VALUES ("PS68_36","020_68_36","PSA","68","36","36","E Aulataʼala, Ingkoo inda umentela mpuu wakutuuna ulimba minaaka i tampana mbooresamu momangkilo! Aulataʼala isombana miana Israel adhawuaka kuasana tee kakaana to uumatina. Atopujimo Aulataʼala! ");
INSERT INTO wlo_vpl VALUES ("PS69_1","020_69_1","PSA","69","1","1","To kapalana molaguna. Aose lagu: Kamba-kamba Bakung. Zaburuna Daud. ");
INSERT INTO wlo_vpl VALUES ("PS69_2","020_69_2","PSA","69","2","2","Pasalaamatiaku, e Aulataʼala, roonamo o uwe akawamo i bhorokoku. ");
INSERT INTO wlo_vpl VALUES ("PS69_3","020_69_3","PSA","69","3","3","Iaku kutondu i nuncana tomba momandala, inda dhaangia o tampana polandakaku. Iaku kukotibu i uwe momandala, tee o mawa apaampeaku. ");
INSERT INTO wlo_vpl VALUES ("PS69_4","020_69_4","PSA","69","4","4","Iaku kumangule kugora kuemani tulungi; goncoku amatuu. Mataku amalau kuantagi Aulataʼalaku. ");
INSERT INTO wlo_vpl VALUES ("PS69_5","020_69_5","PSA","69","5","5","Mia mobanciaku inda akoʼalasa, alabhi o kabharina minaaka i bulua i bhaaku. Manga mia mogauna mopabinasaaku abhari mpuu; manga incia amembali musuku inda akosababu. Iaku apakisaaku kubholosi harataa inda irampasiku. ");
INSERT INTO wlo_vpl VALUES ("PS69_6","020_69_6","PSA","69","6","6","E Aulataʼala, Ingkoo umataua o kabhongo-bhongoku, manga kasalahaku inda atobuniaka minaaka i Ingkoo. ");
INSERT INTO wlo_vpl VALUES ("PS69_7","020_69_7","PSA","69","7","7","Bholi utaroakea manga mia motangkaakako apotibhaaka kaea roonamo iaku, e KAWASANA OPU, Aulataʼalana saangua alamu! Bholi utaroakea manga mia mopeeloko apotibhaaka aebu roonamo iaku, e Aulataʼala isombana miana Israel! ");
INSERT INTO wlo_vpl VALUES ("PS69_8","020_69_8","PSA","69","8","8","Rampaakanamo Ingkoo iaku kutohina, tee o kae atutubhi rouku. ");
INSERT INTO wlo_vpl VALUES ("PS69_9","020_69_9","PSA","69","9","9","Iaku mboomo dhaga to manga witinaiku, tee bhari-bharia witinaiku aabhiaku mia moumba. ");
INSERT INTO wlo_vpl VALUES ("PS69_10","020_69_10","PSA","69","10","10","Ngangarandaku akarore-rore to kuewaaka bhanuamu, sabutuna apekangauaku, tee o kahinana manga mia mohinako akangkanaiaku. ");
INSERT INTO wlo_vpl VALUES ("PS69_11","020_69_11","PSA","69","11","11","Wakutuuna kupaporitambe karoku tee kupoasa, iaku kumembali kahinana mia. ");
INSERT INTO wlo_vpl VALUES ("PS69_12","020_69_12","PSA","69","12","12","Wakutuuna kupake kae kadhu to tandana kusukara, rampaakanamo sumai manga incia apotawaikiaku. ");
INSERT INTO wlo_vpl VALUES ("PS69_13","020_69_13","PSA","69","13","13","Iaku kumembali giu ipogauakana manga mia mouncurana i bhambana lawana kota tee apamembaliaku lagu kaele-elena manga pande sumpu. ");
INSERT INTO wlo_vpl VALUES ("PS69_14","020_69_14","PSA","69","14","14","Maka kudoʼa i Ingkoo, e KAWASANA OPU, e Aulataʼala, lawaniaku i wakutuu momalape; lawaniaku roonamo kaasimu molagina motaralabhi-labhi tee roonamo katulungimu momembalina iparacaeaku. ");
INSERT INTO wlo_vpl VALUES ("PS69_15","020_69_15","PSA","69","15","15","Pasalaamatiaku minaaka i nuncana tomba, tee bholi utaroakaaku kutondu. Rambasakaaku minaaka i manga mia mobanciaku tee minaaka i uwe momandala. ");
INSERT INTO wlo_vpl VALUES ("PS69_16","020_69_16","PSA","69","16","16","Bholi utaroakaaku apaampeaku mawa, atawa kutondu i tawo momandala. Bholi utaroakaaku kutokoburu i nuncana bhalo. ");
INSERT INTO wlo_vpl VALUES ("PS69_17","020_69_17","PSA","69","17","17","E KAWASANA OPU, maasangia ulawaniaku roonamo kaasimu molagina amalape, poilimo tee urangoaku rampaakanamo rahumatimu momaoge. ");
INSERT INTO wlo_vpl VALUES ("PS69_18","020_69_18","PSA","69","18","18","Bholi ubuniaka roumu minaaka i bhatuamu roonamo iaku kunarakaa, lawaniakumo pekadhei. ");
INSERT INTO wlo_vpl VALUES ("PS69_19","020_69_19","PSA","69","19","19","Umbamo pasalaamatiaku, pabebasiaku minaaka i manga musuku. ");
INSERT INTO wlo_vpl VALUES ("PS69_20","020_69_20","PSA","69","20","20","Ingkoo umataua tuaapa o musuku aele-eleaku, apekaeaaku tee ahinaaku. Ingkoo ukamatea bhari-bharia musuku. ");
INSERT INTO wlo_vpl VALUES ("PS69_21","020_69_21","PSA","69","21","21","Kahinana sumai apahancuru incaku, sabutuna amate o akalaku. Iaku kuharapu kaasina mia, maka inda dhaangia; iaku kupeelo mia mohiburuaku, maka inda kupotibhaakea. ");
INSERT INTO wlo_vpl VALUES ("PS69_22","020_69_22","PSA","69","22","22","Sampe manga incia uka adhawuaku racu to kukandea, tee wakutuuna amatuu bhorokoku, adhawuaku cuka to kusumpua. ");
INSERT INTO wlo_vpl VALUES ("PS69_23","020_69_23","PSA","69","23","23","Taroakamo kinande i aroana manga incia amembali katapu to karona, tee amembali kapetambo to manga sabhangkana. ");
INSERT INTO wlo_vpl VALUES ("PS69_24","020_69_24","PSA","69","24","24","Taroakamo matana manga incia amarawu mamudhaakana inda amembali apokamata, tee taroakamo o tangana manga incia sadia arengku. ");
INSERT INTO wlo_vpl VALUES ("PS69_25","020_69_25","PSA","69","25","25","Palimbamea pamurumu to manga incia, tee taroakamo o amaramu mokarore-rorena akangkanai manga incia. ");
INSERT INTO wlo_vpl VALUES ("PS69_26","020_69_26","PSA","69","26","26","Taroakamo pokemaana manga incia amembali amalino, tee taroakamo inda samia uka momboorena i kemana manga incia. ");
INSERT INTO wlo_vpl VALUES ("PS69_27","020_69_27","PSA","69","27","27","Roonamo manga incia apajere manga mia mopadhana ibhebhemu, tee apetulatulaaka o kanarakaana manga mia mopadhana ipekambelamu. ");
INSERT INTO wlo_vpl VALUES ("PS69_28","020_69_28","PSA","69","28","28","Taroakamo urangania kabharina kasalahana manga incia, tee manga incia bholi upabanarea. ");
INSERT INTO wlo_vpl VALUES ("PS69_29","020_69_29","PSA","69","29","29","Taroakamo o sarona manga incia uhapusua minaaka i nuncana boku mokoantoakana manga sarona mia momalape, tee o sarona manga incia bholi upapesuaia i nuncana daftarana mia mobanara. ");
INSERT INTO wlo_vpl VALUES ("PS69_30","020_69_30","PSA","69","30","30","Maka iaku sii kunarakaa tee kumapii. E Aulataʼala, tulungiaku tee ujaganiaku. ");
INSERT INTO wlo_vpl VALUES ("PS69_31","020_69_31","PSA","69","31","31","Iaku bhekulagu to kupuji sarona Aulataʼala, tee kusukuru tee kumuliangia. ");
INSERT INTO wlo_vpl VALUES ("PS69_32","020_69_32","PSA","69","32","32","Giu incia sumai alabhi alaenga i matana KAWASANA OPU minaaka i binata pasombaa, tee minaaka i sapi umane maoge mokotandu tee mokokonuku mopoweta. ");
INSERT INTO wlo_vpl VALUES ("PS69_33","020_69_33","PSA","69","33","33","Manga mia monarakaa bheakamatea tee akaunde-unde. Taroakamo incamiu adhadhi pendua, e ingkomiu mopeelona Aulataʼala! ");
INSERT INTO wlo_vpl VALUES ("PS69_34","020_69_34","PSA","69","34","34","KAWASANA OPU aperangoi mia misikini, tee Incia inda apandaʼente uumatina modhaangiana i nuncana katorongku. ");
INSERT INTO wlo_vpl VALUES ("PS69_35","020_69_35","PSA","69","35","35","Taroakamo Incia apujia bhari-bharia modhaangiana i laiana tee i dunia, i tawo tee bhari-bharia mahaluku modhadhina i nuncana tawo ");
INSERT INTO wlo_vpl VALUES ("PS69_36","020_69_36","PSA","69","36","36","roonamo Aulataʼala bheapasalaamati Kota Sion, tee apendua abhangu manga kota i Tana Yuda mamudhaakana manga bhatuana amboore tee akotanaaka lipu incia sumai saʼumurua. ");
INSERT INTO wlo_vpl VALUES ("PS69_37","020_69_37","PSA","69","37","37","Siwuluna minaaka i manga bhatuana bhemokotinaurakaakea, tee manga mia momaasiakana Kawasana Opu bheamboore i nuncana. ");
INSERT INTO wlo_vpl VALUES ("PS70_1","020_70_1","PSA","70","1","1","To kapalana molaguna. Zaburuna Daud. Zikiri i wakutuuna pasombaana kurubanina kaudhania. ");
INSERT INTO wlo_vpl VALUES ("PS70_2","020_70_2","PSA","70","2","2","E Aulataʼala, pasalaamatiaku! E KAWASANA OPU, tulungiaku pekadhei! ");
INSERT INTO wlo_vpl VALUES ("PS70_3","020_70_3","PSA","70","3","3","Taroakamo manga mia mogauna mopekamateaku amaea tee apalai roonamo abingu. Taroakamo manga mia mogauna mopacilakaaku apotibhaaka kahina tee aʼaebu. ");
INSERT INTO wlo_vpl VALUES ("PS70_4","020_70_4","PSA","70","4","4","Taroakamo manga mia mopogauna, \"Namisia, namisia!\" tee mopotawaikiaku abhalili roonamo amaea. ");
INSERT INTO wlo_vpl VALUES ("PS70_5","020_70_5","PSA","70","5","5","Taroakamo bhari-bharia mia mopeeloko asambo-sambo tee akaunde-unde roonamo Ingkoo. Taroakamo manga mia momaasiakana kasalaamati minaaka i Ingkoo sadia apogau, \"Tapanamo kalanga o Aulataʼala!\" ");
INSERT INTO wlo_vpl VALUES ("PS70_6","020_70_6","PSA","70","6","6","Iaku sii kunarakaa tee kumisikini, umbamo pekadhei, e Aulataʼala! Ingkoomo motulungiaku tee mopasalaamatiaku. E KAWASANA OPU bholi upekanoe-noe! ");
INSERT INTO wlo_vpl VALUES ("PS71_1","020_71_1","PSA","71","1","1","E KAWASANA OPU, Ingkoomo o peulusaku, bholi sampeampearo kutopekaea. ");
INSERT INTO wlo_vpl VALUES ("PS71_2","020_71_2","PSA","71","2","2","Rambasakaaku, tee upabebasiaku roonamo Ingkoo ubanara; perangoiaku tee upasalaamatiaku. ");
INSERT INTO wlo_vpl VALUES ("PS71_3","020_71_3","PSA","71","3","3","Membalimo gunu bhatu to tampana mbooresaku sadia momembalina iumbatiku. Ingkoo padhamo udhawu parinta mamudhaakana kutopasalaamati roonamo Ingkoomo gunu bhatu mojaganiaku tee bente potaangiaku. ");
INSERT INTO wlo_vpl VALUES ("PS71_4","020_71_4","PSA","71","4","4","E Aulataʼalaku, pasalaamatiaku minaaka i limana mia madhaki, minaaka i kuasana mia inda moʼadili tee mia masega. ");
INSERT INTO wlo_vpl VALUES ("PS71_5","020_71_5","PSA","71","5","5","Ingkoomo iharapuku, e KAWASANA OPU Aulataʼala, Ingkoomo iparacaeaku minaaka dhaangia kumangura. ");
INSERT INTO wlo_vpl VALUES ("PS71_6","020_71_6","PSA","71","6","6","Ingkoomo o tampana kupasande minaaka i nuncana kadhuma; Ingkoomo mopalimbaaku minaaka i kompona inaku, sumaimo iaku sadia kupujiko. ");
INSERT INTO wlo_vpl VALUES ("PS71_7","020_71_7","PSA","71","7","7","Iaku kumembali mboomo mia ipeelona manga pande pana, maka Ingkoomo o tampana peulusaku momakaa. ");
INSERT INTO wlo_vpl VALUES ("PS71_8","020_71_8","PSA","71","8","8","Ngangaku sadia apujiko, saeoa iaku kumuliangiko. ");
INSERT INTO wlo_vpl VALUES ("PS71_9","020_71_9","PSA","71","9","9","Bholi ubhanakaaku i wakutuuna kumancuana, tee bholi ubholiaku ande atopadhamo kakaaku. ");
INSERT INTO wlo_vpl VALUES ("PS71_10","020_71_10","PSA","71","10","10","Sababuna manga musuku apogauakaaku, tee manga mia mogauna mopekamateaku asahimuakaaku. ");
INSERT INTO wlo_vpl VALUES ("PS71_11","020_71_11","PSA","71","11","11","Pogauna manga incia, \"Aulataʼala padhamo abholi incia! Pajeremea tee urakomea roonamo inda dhaangia bhemorambasakea!\" ");
INSERT INTO wlo_vpl VALUES ("PS71_12","020_71_12","PSA","71","12","12","E Aulataʼala, bholi umaridho minaaka i iaku, e Aulataʼalaku, tulungiaku pekadhei! ");
INSERT INTO wlo_vpl VALUES ("PS71_13","020_71_13","PSA","71","13","13","Taroakamo mia moraeakaaku apotibhaaka kaea tee abinasa. Taroakamo manga mia mogauna mopacilakaaku abukeaka kahina tee aebu. ");
INSERT INTO wlo_vpl VALUES ("PS71_14","020_71_14","PSA","71","14","14","Maka sadia kuharapu, tee iaku ahandamo bhekupujiko. ");
INSERT INTO wlo_vpl VALUES ("PS71_15","020_71_15","PSA","71","15","15","Ngangaku saeoa bhekupetulatulaaka manga pewaumu mobanara, tee kasalaamati inda motolentu minaaka i Ingkoo. ");
INSERT INTO wlo_vpl VALUES ("PS71_16","020_71_16","PSA","71","16","16","Iaku bhekuumba tee kupuji pewauna momakaana KAWASANA OPU Aulataʼala. Iaku bhekumuliangiakea tangkanamo kaʼadilina Karomu samia. ");
INSERT INTO wlo_vpl VALUES ("PS71_17","020_71_17","PSA","71","17","17","E Aulataʼala, minaaka kumangura Ingkoo moadhariaku, tee sakawana sii-sii iaku kupetulatulaaka pewaumu inda momentela. ");
INSERT INTO wlo_vpl VALUES ("PS71_18","020_71_18","PSA","71","18","18","Sampe sakawana kumancuana tee kukouwa uka, e Aulataʼala, bholi ubholiaku, mamudhaakana kumembali kupakoleleaka kuasamu i siwulu sii-sii, tee kaogesamu i bhari-bharia mia bhemoumbana naile itu. ");
INSERT INTO wlo_vpl VALUES ("PS71_19","020_71_19","PSA","71","19","19","E Aulataʼala, kuasamu tee kabanaramu akawea i laiana! Ingkoo padhamo upewau manga giu momaoge, e Aulataʼala, incema mopokanana tee Ingkoo? ");
INSERT INTO wlo_vpl VALUES ("PS71_20","020_71_20","PSA","71","20","20","Ingkoo padhamo utaroakaaku kunamisi bhari kanarakaa tee balaa, Ingkoo uka bheupadhadhiaku pendua. Minaaka i nuncana koburu Ingkoo bheuangkaaku pendua. ");
INSERT INTO wlo_vpl VALUES ("PS71_21","020_71_21","PSA","71","21","21","Ingkoo bheupamembaliaku ajulu kutohoromati, tee uhiburuaku pendua. ");
INSERT INTO wlo_vpl VALUES ("PS71_22","020_71_22","PSA","71","22","22","Iaku bhekupujiko tee gambusu roonamo umembali utoparacaea, e Aulataʼalaku. Tee kecapi Iaku bhekulaguaka lagu kapujia to Ingkoo, e Momangkilona, Aulataʼala isombana miana Israel! ");
INSERT INTO wlo_vpl VALUES ("PS71_23","020_71_23","PSA","71","23","23","Bhiwiku bheasambo-sambo wakutuuna kulaguaka lagu kapujia to Ingkoo, apokana uka mboomo inyawaku mopadhana itolosimu. ");
INSERT INTO wlo_vpl VALUES ("PS71_24","020_71_24","PSA","71","24","24","Dhelaku bheapakoleleaka katulungimu mobanara saeoa, roonamo manga mia mopadhana moʼusahana to mopacilakaaku amembali amaea tee amajule. ");
INSERT INTO wlo_vpl VALUES ("PS72_1","020_72_1","PSA","72","1","1","Zaburuna Sulaiman. E Kawasana Opu, dhawuakea o kaʼadilimu to raja, tee udhawuakea o kabanaramu to anana raja. ");
INSERT INTO wlo_vpl VALUES ("PS72_2","020_72_2","PSA","72","2","2","Maasangia incia aʼadili uumatimu tee kabanara, tee aʼadili apewau mia motopisaki. ");
INSERT INTO wlo_vpl VALUES ("PS72_3","020_72_3","PSA","72","3","3","Maasangia manga gunu aumbaaka kasanaa to raʼeati, tee manga kabumbu ahasiliaka kabanara. ");
INSERT INTO wlo_vpl VALUES ("PS72_4","020_72_4","PSA","72","4","4","Maasangia incia bheaewaaka parakarana manga mia motopisaki i tanga-tangana raʼeati, apasalaamati manga mia misikini tee apahancuru manga pande pisaki. ");
INSERT INTO wlo_vpl VALUES ("PS72_5","020_72_5","PSA","72","5","5","Maasangia manga incia bheamaeka i Ingkoo kangengena dhaangia tee matanaeo tee kangengena dhaangia tee bula, saʼumurua. ");
INSERT INTO wlo_vpl VALUES ("PS72_6","020_72_6","PSA","72","6","6","Maasangia raja incia sumai mboomo uwena wao mosapona i bhawona rumpu mopadhana motoweli, tee mboomo wao maranca mobubusina dunia. ");
INSERT INTO wlo_vpl VALUES ("PS72_7","020_72_7","PSA","72","7","7","Maasangia o kabanara sadhaadhaa aniʼimatia raʼeati kangengena raja dhaangiapo adhadhi, tee o kasanaa ataralabhi-labhi sakawana bula indamo dhaangia. ");
INSERT INTO wlo_vpl VALUES ("PS72_8","020_72_8","PSA","72","8","8","Incia bheakokuasa minaaka i tawo sakawana i tawo, minaaka i Umala Efrat sakawana i tapana dunia. ");
INSERT INTO wlo_vpl VALUES ("PS72_9","020_72_9","PSA","72","9","9","Manga mia momboorena i tana matuu bheatungku i aroana, tee manga musuna adhelapi ngawuna tana. ");
INSERT INTO wlo_vpl VALUES ("PS72_10","020_72_10","PSA","72","10","10","Maasangia manga raja minaaka i Tarsis tee manga raja minaaka i pulo-pulo mosagaanana bheabhawaakea hadia. Maasangia manga raja minaaka i Syeba tee Seba abhawa pasombaa to incia. ");
INSERT INTO wlo_vpl VALUES ("PS72_11","020_72_11","PSA","72","11","11","Maasangia bhari-bharia raja bheasuju i aroana, tee bhari-bharia lipu apabhatua karona i incia. ");
INSERT INTO wlo_vpl VALUES ("PS72_12","020_72_12","PSA","72","12","12","Roonamo incia bhearambasaka mia misikini mogorana i incia, tee atolosi mia motopisaki tee mia inda mototulungi. ");
INSERT INTO wlo_vpl VALUES ("PS72_13","020_72_13","PSA","72","13","13","Incia bheamaasiaka mia misikini tee mia monarakaa, tee apasalaamati inyawana mia inda mokokadhaangia. ");
INSERT INTO wlo_vpl VALUES ("PS72_14","020_72_14","PSA","72","14","14","Tee bheatolosi dhadhina manga incia minaaka i mia masega tee mopisakina manga incia, sababuna o dhadhina manga incia akoharagaa mpuu i matana. ");
INSERT INTO wlo_vpl VALUES ("PS72_15","020_72_15","PSA","72","15","15","Maasangia amarambe o umuruna! Maasangia o bulawa minaaka i Syeba atopasombaaka to incia. Maasangia incia sadia atodoʼaaka, tee saeoa o mia aemaniakea barakati. ");
INSERT INTO wlo_vpl VALUES ("PS72_16","020_72_16","PSA","72","16","16","Maasangia o gandum ataralabhi-labhi i saangua lipu, akawea i lolona gunu. Maasangia o hasilina tanana asuburu mboomo i Libanon, tee o raʼeatina kotana ajulu o kabharina mboomo rumpu i tana lapa. ");
INSERT INTO wlo_vpl VALUES ("PS72_17","020_72_17","PSA","72","17","17","Maasangia o sarona raja atoudhani saʼumurua, maasangia sahandana abhari o mia momatauna sarona, kangengena dhaangiapo tee matanaeo. Maasangia bhari-bharia lipu bheapotibhaaka barakati roonamo incia, tee bhari-bharia lipu asarongiakea amasanaa. ");
INSERT INTO wlo_vpl VALUES ("PS72_18","020_72_18","PSA","72","18","18","Atopujimo KAWASANA OPU, siitumo Aulataʼala isombana miana Israel, mopewauna manga giu inda momentela samia-miana! ");
INSERT INTO wlo_vpl VALUES ("PS72_19","020_72_19","PSA","72","19","19","Atopujimo sarona momuliana saʼumurua! Maasangia saangua alamu abukeaka tee kamuliangina. Aamin, aamin! ");
INSERT INTO wlo_vpl VALUES ("PS72_20","020_72_20","PSA","72","20","20","Mboo siimo kapadhaana doʼana Daud bin Isai. ");
INSERT INTO wlo_vpl VALUES ("PS73_1","020_73_1","PSA","73","1","1","Zaburuna Asaf. Satotuuna o Aulataʼala sumai amalape tee miana Israel, tee mia morelana totona incana. ");
INSERT INTO wlo_vpl VALUES ("PS73_2","020_73_2","PSA","73","2","2","Maka iaku saidhepo kusindoli, tee saidhepo kumanduli, ");
INSERT INTO wlo_vpl VALUES ("PS73_3","020_73_3","PSA","73","3","3","roonamo kugigibulu kukamata mia mosombo wakutuuna kukamata kasanaana tee karangkaeana mia madhaki. ");
INSERT INTO wlo_vpl VALUES ("PS73_4","020_73_4","PSA","73","4","4","Manga incia inda anamisi kapii, badana manga incia amalompo tee amakaa. ");
INSERT INTO wlo_vpl VALUES ("PS73_5","020_73_5","PSA","73","5","5","Manga incia inda anamisi kanarakaa mboomo mia mosagaanana, tee manga incia inda akangkanaia balaa mboomo maanusia mosagaanana. ");
INSERT INTO wlo_vpl VALUES ("PS73_6","020_73_6","PSA","73","6","6","Siitumo o sababuna manga incia aporanteaka tee pewau mosombo, tee kasegana asalibumbuaka karona mboomo juba. ");
INSERT INTO wlo_vpl VALUES ("PS73_7","020_73_7","PSA","73","7","7","Matana manga incia aʼuntu roonamo kaogena bukuna, ngangarandana manga incia abukeaka tee manga haejati madhaki. ");
INSERT INTO wlo_vpl VALUES ("PS73_8","020_73_8","PSA","73","8","8","Manga incia tee kadhakina aele-ele tee apeonii mia mosagaanana, tee kalangana incana manga incia apekapahanda tee apekapisaki. ");
INSERT INTO wlo_vpl VALUES ("PS73_9","020_73_9","PSA","73","9","9","Ngangana manga incia ahina sorogaa, tee dhelana atipua saangua dunia to abhoasaka manga pogau inda mokoguna. ");
INSERT INTO wlo_vpl VALUES ("PS73_10","020_73_10","PSA","73","10","10","Sumaimo manga mia ambuli aose manga incia, tee inda apotibhaaka saangu kasalaha uka minaaka i manga incia. ");
INSERT INTO wlo_vpl VALUES ("PS73_11","020_73_11","PSA","73","11","11","Tee manga mia madhaki apogau, \"Tuaapa o Aulataʼala bheamataua opea ipewaumami? Buaka Incia Momalangana dhaangia tee imatauna?\" ");
INSERT INTO wlo_vpl VALUES ("PS73_12","020_73_12","PSA","73","12","12","Kamatamea, mboo siimo manga mia madhaki: manga incia atanangi torosu tee o harataana ahandamo abhari. ");
INSERT INTO wlo_vpl VALUES ("PS73_13","020_73_13","PSA","73","13","13","Satotuuna asia-siamo kujagani ngangarandaku mamudhaakana amangkilo, tee kubhanui limaku to tandana inda kusala. ");
INSERT INTO wlo_vpl VALUES ("PS73_14","020_73_14","PSA","73","14","14","Roonamo saeoa akangkanaiaku balaa, tee saraneeo-saraneeo kutohukumu. ");
INSERT INTO wlo_vpl VALUES ("PS73_15","020_73_15","PSA","73","15","15","Ande kupogau, \"Iaku gauku kupogau mboo sumai,\" sumaimo iaku kuhianati siwuluna uumatimu. ");
INSERT INTO wlo_vpl VALUES ("PS73_16","020_73_16","PSA","73","16","16","Maka i wakutuuna kuʼusaha to kumaʼanaia, hali incia sumai amarasai mpuu to iaku; ");
INSERT INTO wlo_vpl VALUES ("PS73_17","020_73_17","PSA","73","17","17","siimpo kumataua o kapadhaana dhadhina manga incia wakutuuna kupesua i nuncana bhanuana Aulataʼala. ");
INSERT INTO wlo_vpl VALUES ("PS73_18","020_73_18","PSA","73","18","18","Satotuuna, i tampa momararo udhika manga incia, tee upekandawua manga sakawana abinasa. ");
INSERT INTO wlo_vpl VALUES ("PS73_19","020_73_19","PSA","73","19","19","Manga incia abinasa sakijamata, apaampea sakawana amofu minaaka i kamingkiri. ");
INSERT INTO wlo_vpl VALUES ("PS73_20","020_73_20","PSA","73","20","20","Manga mia madhaki bheaila mboomo pongipi i wakutuuna o mia atobhangu i koleana. E Kawasana Opu, kaudhania to manga incia uhapusua wakutuuna ubhangu. ");
INSERT INTO wlo_vpl VALUES ("PS73_21","020_73_21","PSA","73","21","21","Wakutuuna ngangarandaku amaporo mpuu, tee o baatiniku mboomo isusu-susu, ");
INSERT INTO wlo_vpl VALUES ("PS73_22","020_73_22","PSA","73","22","22","iaku kukabhongo-bhongo tee inda tee imaʼanaiku, i aroamu iaku mboomo binata inda mokoʼakala. ");
INSERT INTO wlo_vpl VALUES ("PS73_23","020_73_23","PSA","73","23","23","Moomini mboo sumai, iaku sadia i saripimu. Ingkoo ukeni lima kaanaku. ");
INSERT INTO wlo_vpl VALUES ("PS73_24","020_73_24","PSA","73","24","24","Ingkoo utondaaku tee naasehatimu, tee utarimaaku tee kahoromati naile itu. ");
INSERT INTO wlo_vpl VALUES ("PS73_25","020_73_25","PSA","73","25","25","Incema motulungiaku i sorogaa ande mencuana Ingkoo? I dunia sii inda dhaangia ipeeluku, ande mencuana Ingkoo. ");
INSERT INTO wlo_vpl VALUES ("PS73_26","020_73_26","PSA","73","26","26","Inyawa tee badaku amembali amofu tee abinasa, maka o Aulataʼala kakaana incaku tee o tinaurakaku saʼumurua. ");
INSERT INTO wlo_vpl VALUES ("PS73_27","020_73_27","PSA","73","27","27","Satotuuna o mia momaridhona minaaka i Ingkoo bheabinasa. Ingkoo bheupabinasa manga mia mohianatiko. ");
INSERT INTO wlo_vpl VALUES ("PS73_28","020_73_28","PSA","73","28","28","Maka to iaku, tapanamo kalape ande kupomakasu tee Aulataʼala, KAWASANA OPU Aulataʼala bhekupamembalia o tampana peulusaku mamudhaakana kumembali kupetulatulaakea bhari-bharia ipewaumu! ");
INSERT INTO wlo_vpl VALUES ("PS74_1","020_74_1","PSA","74","1","1","Lagu kaadharina Asaf. E Aulataʼala, pokia Ingkoo ubhanaka ingkami? Buaka ingkami tatomendeu saʼumurua? Pokia pamurumu akarore-rore tee manga dumba igembalamu? ");
INSERT INTO wlo_vpl VALUES ("PS74_2","020_74_2","PSA","74","2","2","Maasangia uudhania o uumatimu mopadhana ipotibhaakamu i piamo itu, lipu mopadhana itolosimu amembali lipu tinaurakamu. Udhania Gunu Sion, tampa mopadhana iumbatimu to umbooresia. ");
INSERT INTO wlo_vpl VALUES ("PS74_3","020_74_3","PSA","74","3","3","Paporopea bhengkalamu i tampa mohancuru saʼumurua sumai; bhari-bharia bara i nuncana tampa momangkilo padhamo apahancurua musu. ");
INSERT INTO wlo_vpl VALUES ("PS74_4","020_74_4","PSA","74","4","4","Manga bhalimu akakee-kee, \"Takanamo!\" i tampamu momangkilo, tee apakaro manga tombi to tandana ande manga incia akana minaaka i ingkami. ");
INSERT INTO wlo_vpl VALUES ("PS74_5","020_74_5","PSA","74","5","5","Atokamata mboomo mia moangkana ndamuna apekalanga-langea to apale manga puuna kau i koo. ");
INSERT INTO wlo_vpl VALUES ("PS74_6","020_74_6","PSA","74","6","6","Bhari-bharia bara ibheloki andamua tee apalua. ");
INSERT INTO wlo_vpl VALUES ("PS74_7","020_74_7","PSA","74","7","7","Manga incia atunu bhanua ibaadatimu sakawana arata tee tana, tee apanaajisi tampana mbooresamu. ");
INSERT INTO wlo_vpl VALUES ("PS74_8","020_74_8","PSA","74","8","8","I nuncana ngangarandana manga incia apogau, \"Mai tapisakia bhari-bharia!\" Manga incia atunu bhari-bharia tampana ibaadati i lipu sii. ");
INSERT INTO wlo_vpl VALUES ("PS74_9","020_74_9","PSA","74","9","9","Ingkami indamo uka takamata manga tanda inda momentela, samia nabii uka inda dhaangia, inda samia uka i tanga-tangamami momataua sakawana naepia bhari-bharia sii amembali. ");
INSERT INTO wlo_vpl VALUES ("PS74_10","020_74_10","PSA","74","10","10","E Aulataʼala, sakawana naepia manga bhali bheaele-eleko? Buaka saʼumurua o musu bheahina saromu? ");
INSERT INTO wlo_vpl VALUES ("PS74_11","020_74_11","PSA","74","11","11","Pokia Ingkoo uhelaia pendua o lima kaanamu? Pokia Ingkoo soo usaku-saku limamu? Pepadhaimea manga incia! ");
INSERT INTO wlo_vpl VALUES ("PS74_12","020_74_12","PSA","74","12","12","Maka o Aulataʼala o rajaku minaaka i piamo itu. Incia mopasalaamatina ingkami i dunia. ");
INSERT INTO wlo_vpl VALUES ("PS74_13","020_74_13","PSA","74","13","13","Tee kakaamu Ingkoo uweta tawo, tee upasaki bhaana manga Lewiatan i tawo. ");
INSERT INTO wlo_vpl VALUES ("PS74_14","020_74_14","PSA","74","14","14","Ingkoo upekapuro manga bhaana Lewiatan, tee upamembalia kinandena manga binata momboorena i tana matuu. ");
INSERT INTO wlo_vpl VALUES ("PS74_15","020_74_15","PSA","74","15","15","Ingkoo mobungkalena matana uwe tee umala; sainamo manga umala mokouwena torotorosu, upekatuua. ");
INSERT INTO wlo_vpl VALUES ("PS74_16","020_74_16","PSA","74","16","16","Ingkoomo mopadhaangiana eo tee malo, Ingkoomo modhikana matanaeo tee bula. ");
INSERT INTO wlo_vpl VALUES ("PS74_17","020_74_17","PSA","74","17","17","Ingkoo mopatotapuakana bhari-bharia tidhana alamu, Ingkoo mopewauna bulaana paneeo tee bulaana wao. ");
INSERT INTO wlo_vpl VALUES ("PS74_18","020_74_18","PSA","74","18","18","Udhania tuaapa o musumu aele-eleko, e KAWASANA OPU, lipu mokaafiri ahina saromu. ");
INSERT INTO wlo_vpl VALUES ("PS74_19","020_74_19","PSA","74","19","19","Bholi upasaraaka inyawana manu-manu jarajaramu i binata masega, tee bholi umalinguakea to saʼumurua inyawana uumatimu motopisaki. ");
INSERT INTO wlo_vpl VALUES ("PS74_20","020_74_20","PSA","74","20","20","Udhania o pojanjia ipewaumu tee ingkami, roonamo manga tampa malalanda i dunia sii abukeaka tee manga mia mopewauna kasega. ");
INSERT INTO wlo_vpl VALUES ("PS74_21","020_74_21","PSA","74","21","21","Bholi utaroakea o mia motopisaki ambuli atopekaea, maka maasangia o mia monarakaa tee mia misikini bheapuji saromu. ");
INSERT INTO wlo_vpl VALUES ("PS74_22","020_74_22","PSA","74","22","22","E Aulataʼala, bhangumo, ewaakea o parakaramu; udhania ande manga mia mokaafiri ahinako saeoa. ");
INSERT INTO wlo_vpl VALUES ("PS74_23","020_74_23","PSA","74","23","23","Bholi umalinguakea o suarana manga bhalimu, tee o karobhona manga mia moewangiko apene torotorosu. ");
INSERT INTO wlo_vpl VALUES ("PS75_1","020_75_1","PSA","75","1","1","To kapalana molaguna. Zaburuna Asaf to lagu: Bholi Upahancurua. ");
INSERT INTO wlo_vpl VALUES ("PS75_2","020_75_2","PSA","75","2","2","Ingkami tasukuru i Ingkoo, e Aulataʼala; ingkami tasukuru i Ingkoo roonamo umakasu. Manga mia apetulatulaaka bhari-bharia pewaumu inda momentela. ");
INSERT INTO wlo_vpl VALUES ("PS75_3","020_75_3","PSA","75","3","3","\"I wakutuu mopadhana itantuakaku, Iaku bhekuhaakimu tee kaʼadili. ");
INSERT INTO wlo_vpl VALUES ("PS75_4","020_75_4","PSA","75","4","4","I wakutuuna alamu tee bhari-bharia antona atolendu, Iakumo bhemopekatangkana manga ariina. Sela ");
INSERT INTO wlo_vpl VALUES ("PS75_5","020_75_5","PSA","75","5","5","To manga mia mosombo Iaku kupogau, 'Bholi usombo,' kasiimpo to mia madhaki, 'Bholi upepujiaka kakaamu; ");
INSERT INTO wlo_vpl VALUES ("PS75_6","020_75_6","PSA","75","6","6","bholi upepujiaka kakaamu uewangi sorogaa, atawa upogau tee upataja bhorokomu.' \" ");
INSERT INTO wlo_vpl VALUES ("PS75_7","020_75_7","PSA","75","7","7","Roonamo Incia Mokanana minaaka i timbu tee minaaka i bhara, Inciamo Mokanana minaaka i tana matuu sakawana i tana mokogunu. ");
INSERT INTO wlo_vpl VALUES ("PS75_8","020_75_8","PSA","75","8","8","Aulataʼala o haakimu; Incia apaporitambe mia mosala tee apekalanga mia mobanara. ");
INSERT INTO wlo_vpl VALUES ("PS75_9","020_75_9","PSA","75","9","9","Roonamo pamuruna KAWASANA OPU mboomo tonde i limana, akoantoaka uwena angguru mokobura, mobukeakana tee kajalona rampa. Incia bhealali antona, mamudhaakana o kulimpasana bheasumpua tee apepadhaia bhari-bharia mia madhaki i dunia. ");
INSERT INTO wlo_vpl VALUES ("PS75_10","020_75_10","PSA","75","10","10","Maka iaku saʼumurua bhekupakoleleaka giu incia sii, Iaku bhekulaguaka lagu kapujia to Aulataʼala isombana Yakub. ");
INSERT INTO wlo_vpl VALUES ("PS75_11","020_75_11","PSA","75","11","11","Iaku bhekupekakatu bhari-bharia kakaana mia madhaki, maka o kakaana mia mobanara bhekurangania. ");
INSERT INTO wlo_vpl VALUES ("PS76_1","020_76_1","PSA","76","1","1","To kapalana molaguna. Tee atikiakea kecapi. Zaburuna Asaf to lagu. ");
INSERT INTO wlo_vpl VALUES ("PS76_2","020_76_2","PSA","76","2","2","Manga miana Yuda amatau Aulataʼala, sarona amaoge i Israel. ");
INSERT INTO wlo_vpl VALUES ("PS76_3","020_76_3","PSA","76","3","3","Bhanuana i Yerusalem, tee tampana mbooresana i Gunu Sion. ");
INSERT INTO wlo_vpl VALUES ("PS76_4","020_76_4","PSA","76","4","4","Iwe sumakomo Incia akatuki bhari-bharia manga ewangana potimbeana musuna, bhari-bharia panana mokakila-kila, katangkesina, tee hancuna. Sela ");
INSERT INTO wlo_vpl VALUES ("PS76_5","020_76_5","PSA","76","5","5","Ingkoo ukocahea mpuu! Alabhi umulia minaaka i manga gunu modhaangiana i zamani mangenge. ");
INSERT INTO wlo_vpl VALUES ("PS76_6","020_76_6","PSA","76","6","6","Hasilina potimbea padhamo atorampasi minaaka i manga mia mobarani. Manga incia atokole saʼumurua; inda dhaangia minaaka i tantarana sumai momembalina moangkana limana uka. ");
INSERT INTO wlo_vpl VALUES ("PS76_7","020_76_7","PSA","76","7","7","E Aulataʼala isombana Yakub, roonamo kagorampangimu, manga ajara tee mosawikia amalimpu. ");
INSERT INTO wlo_vpl VALUES ("PS76_8","020_76_8","PSA","76","8","8","Atotuu-totuu Ingkoo utomaeka mpuu! Incema momembalina mopotaangina i aroamu wakutuuna upamuru? ");
INSERT INTO wlo_vpl VALUES ("PS76_9","020_76_9","PSA","76","9","9","Minaaka i sorogaa uparangoakea o kambotuna kahukumumu, alamu uka amaeka tee inda tee uuʼuuna ");
INSERT INTO wlo_vpl VALUES ("PS76_10","020_76_10","PSA","76","10","10","wakutuuna Aulataʼala abhangu to apaʼadili tee apasalaamati bhari-bharia mia motopisaki i alamu. Sela ");
INSERT INTO wlo_vpl VALUES ("PS76_11","020_76_11","PSA","76","11","11","Satotuuna o pamurumu tee maanusia imembaliakamu utopuji, tee bhilaana pamurumu sumai upamembalia kabhokena tangamu. ");
INSERT INTO wlo_vpl VALUES ("PS76_12","020_76_12","PSA","76","12","12","Pojanjimo tee upomeamea o tolauna onimu sumai i KAWASANA OPU, Aulataʼalamu! Taroakamo bhari-bharia modhaangiana i saripina abhawa pasombaana to Incia molaengana imaeka. ");
INSERT INTO wlo_vpl VALUES ("PS76_13","020_76_13","PSA","76","13","13","Incia mopekamatena akalana manga mia mokokuasa, tee manga raja i dunia amaeka i aroana. ");
INSERT INTO wlo_vpl VALUES ("PS77_1","020_77_1","PSA","77","1","1","To kapalana molaguna. Zaburuna Asaf to Yedutun. ");
INSERT INTO wlo_vpl VALUES ("PS77_2","020_77_2","PSA","77","2","2","Iaku kugora i Aulataʼala tee suara momandii, i Aulataʼala kugora, mamudhaakana aperangoiaku. ");
INSERT INTO wlo_vpl VALUES ("PS77_3","020_77_3","PSA","77","3","3","I piamo itu, i eona kumaseke kupeelo Kawasana Opu, tee wakutuuna amalo kutanaaka limaku inda kumangumangule; ngangarandaku inda aunda atotautau. ");
INSERT INTO wlo_vpl VALUES ("PS77_4","020_77_4","PSA","77","4","4","Ande kuudhani Aulataʼala, kupekidhei; ande kupeudhaudhani, ahanda amaule ngangarandaku. Sela ");
INSERT INTO wlo_vpl VALUES ("PS77_5","020_77_5","PSA","77","5","5","Ingkoo mopamembalina mataku sadhaadhaa atobungkale; alilaho o namisiku sabutuna inda amembali kupogauaka opeopea. ");
INSERT INTO wlo_vpl VALUES ("PS77_6","020_77_6","PSA","77","6","6","Kufikifikiriaka zamani i piamo itu, tee i tao-tao molapa. ");
INSERT INTO wlo_vpl VALUES ("PS77_7","020_77_7","PSA","77","7","7","Iaku kuudhani laguku i wakutuuna amalo, kupeudhaudhani i nuncana ngangarandaku, tee o rohiku apekaabha-abha, ");
INSERT INTO wlo_vpl VALUES ("PS77_8","020_77_8","PSA","77","8","8","\"Buaka Kawasana Opu bheamanga bholi to saʼumurua? Tee indamo uka manga maasiaka? ");
INSERT INTO wlo_vpl VALUES ("PS77_9","020_77_9","PSA","77","9","9","Buaka atopadhamo o kaasina molagina? Buaka amapupumo janjina saʼumurua? ");
INSERT INTO wlo_vpl VALUES ("PS77_10","020_77_10","PSA","77","10","10","Buaka o Aulataʼala amalingumo to manga maasiaka? Buaka i nuncana pamuruna Incia atutubhi rahumatina? Sela ");
INSERT INTO wlo_vpl VALUES ("PS77_11","020_77_11","PSA","77","11","11","Kasiimpo kupogau, \"Siimo kaporona incaku ande o lima kaanana Momalangana Mpuu indamo ajaganiaku.\" ");
INSERT INTO wlo_vpl VALUES ("PS77_12","020_77_12","PSA","77","12","12","Iaku bhekuudhani opea mopadhana ipewauna KAWASANA OPU. Umbe, iaku bhekuudhani manga giu inda momentela mopadhana ipewaumu i zamani i piamo itu. ");
INSERT INTO wlo_vpl VALUES ("PS77_13","020_77_13","PSA","77","13","13","Iaku bhekuudhaudhania i nuncana ngangarandaku bhari-bharia ikarajaamu, tee kufikifikiria bhari-bharia giu momaoge mopadhana ipewaumu. ");
INSERT INTO wlo_vpl VALUES ("PS77_14","020_77_14","PSA","77","14","14","Dhalamu amangkilo, e Aulataʼala, Dewa iapai momaogena mboo Aulataʼalamami? ");
INSERT INTO wlo_vpl VALUES ("PS77_15","020_77_15","PSA","77","15","15","Ingkoomo Aulataʼala mopewauna giu inda momentela. Ingkoo padhamo ususuaka kuasamu i tanga-tangana manga lipu. ");
INSERT INTO wlo_vpl VALUES ("PS77_16","020_77_16","PSA","77","16","16","Tee limamu utolosi uumatimu, siitumo siwuluna Yakub tee Yusuf. Sela ");
INSERT INTO wlo_vpl VALUES ("PS77_17","020_77_17","PSA","77","17","17","E Aulataʼala, uwe akamatako, uwe akamatako tee amaeka; umbe, andalaoge uka atorende. ");
INSERT INTO wlo_vpl VALUES ("PS77_18","020_77_18","PSA","77","18","18","Taʼina ngalu apasapo wao maranca, tee o laiana uka akanduu-nduu; manga anana panamu akakila-kila. ");
INSERT INTO wlo_vpl VALUES ("PS77_19","020_77_19","PSA","77","19","19","Ruuna guntumu atorango i nuncana tambusisi, tee o bhibhitomu apekainawa dunia. Alamu uka akolendu tee atorende. ");
INSERT INTO wlo_vpl VALUES ("PS77_20","020_77_20","PSA","77","20","20","Dhalamu alaloi tawo, tee udhala upolimba i andalaoge; maka o tandarana aemu inda atokamata. ");
INSERT INTO wlo_vpl VALUES ("PS77_21","020_77_21","PSA","77","21","21","Ingkoo ugembalaaka uumatimu mboomo mia mowuluna gulumana dumba tee upake limana Musa tee Harun to akapalai manga incia. ");
INSERT INTO wlo_vpl VALUES ("PS78_1","020_78_1","PSA","78","1","1","Lagu kaadharina Asaf. E lipuku, rangoa o kaadhariku, taaia o talingamu tee opea ipogauakaku. ");
INSERT INTO wlo_vpl VALUES ("PS78_2","020_78_2","PSA","78","2","2","Iaku bhekubungkale ngangaku to kupakawaaka ibarati, tee bhekupogauaka manga pogau rahasia modhaangiana minaaka i zamani piamo itu, ");
INSERT INTO wlo_vpl VALUES ("PS78_3","020_78_3","PSA","78","3","3","siitumo manga giu mopadhana irangomami tee imataumami, tee mopadhana ipetulatulaakana manga opu-opuamami. ");
INSERT INTO wlo_vpl VALUES ("PS78_4","020_78_4","PSA","78","4","4","Ingkami inda bhetabuniakea minaaka i anaanana manga incia, maka ingkami bhetapetulatulaakea i siwuluna sapadhana ingkami manga kapujia to KAWASANA OPU tee kakaana, tee manga giu inda momentela mopadhana ipewauna. ");
INSERT INTO wlo_vpl VALUES ("PS78_5","020_78_5","PSA","78","5","5","Incia padhamo apakawaaka tuturana to siwuluna Yakub, tee apatotapuaka Hukumuna Taurati i tanga-tangana miana Israel. Incia atumpu manga opu-opuata to aadhariakea i anana manga incia ");
INSERT INTO wlo_vpl VALUES ("PS78_6","020_78_6","PSA","78","6","6","mamudhaakana o siwulu bhemoumbana amataua, siitumo manga anaana bhemolaahirina naile itu. Kasiimpo manga incia uka bheaumba tee apetulatulaakea i anana manga incia. ");
INSERT INTO wlo_vpl VALUES ("PS78_7","020_78_7","PSA","78","7","7","Tee mboo sumai manga incia bheadhika kaparacaeana i Aulataʼala, tee inda amalinguaka opea ipewauna Aulataʼala, maka ataʼatia manga parintana; ");
INSERT INTO wlo_vpl VALUES ("PS78_8","020_78_8","PSA","78","8","8","tee bholi mboomo opu-opuana miana Israel, adorohaka tee aewangiaku, siitumo opu-opuana tee ngangarandana inda atotapu i Aulataʼala, tee manga incia inda ataʼatia. ");
INSERT INTO wlo_vpl VALUES ("PS78_9","020_78_9","PSA","78","9","9","Miana Efraim mokoewangaakana pana sumai, abhalili tee apalai i eona potimbea. ");
INSERT INTO wlo_vpl VALUES ("PS78_10","020_78_10","PSA","78","10","10","Manga incia inda akenia pekatangka o pojanjiana tee Aulataʼala, tee amendeu aose hukumuna. ");
INSERT INTO wlo_vpl VALUES ("PS78_11","020_78_11","PSA","78","11","11","Manga incia amalinguakea opea mopadhana ikarajaana Kawasana Opu tee amalinguaka manga giu inda momentela mopadhana ipakamataakana to manga incia. ");
INSERT INTO wlo_vpl VALUES ("PS78_12","020_78_12","PSA","78","12","12","I aroana opu-opuana manga incia, Aulataʼala apewau giu inda momentela, i atina Zoan i Tana Mesir. ");
INSERT INTO wlo_vpl VALUES ("PS78_13","020_78_13","PSA","78","13","13","Incia aweta tawo tee ataroakea manga incia apolimba, tee o uwe apekakatea mboomo rindi. ");
INSERT INTO wlo_vpl VALUES ("PS78_14","020_78_14","PSA","78","14","14","Wakutuuna pontanga eo manga incia atondaia apapooseakea tee taʼina ngalu, tee wakutuuna malo manga incia apapooseakea tee caheana waa. ");
INSERT INTO wlo_vpl VALUES ("PS78_15","020_78_15","PSA","78","15","15","Incia aweta manga bhatu i tana matuu, tee adhawua manga asumpu ataralabhi-labhi, mboomo minaaka i andalaoge. ");
INSERT INTO wlo_vpl VALUES ("PS78_16","020_78_16","PSA","78","16","16","Incia apalimba uwe minaaka i bhatu, sabutuna o uwe sumai asiwulu mboomo umala. ");
INSERT INTO wlo_vpl VALUES ("PS78_17","020_78_17","PSA","78","17","17","Maka manga incia dhaangiapo uka torotorosu akodosa tee adorohaka i Momalangana i tana matuu. ");
INSERT INTO wlo_vpl VALUES ("PS78_18","020_78_18","PSA","78","18","18","Manga incia acobai Aulataʼala i nuncana ngangarandana tee atuntu kinande ipeeluna apokana tee nawusuuna. ");
INSERT INTO wlo_vpl VALUES ("PS78_19","020_78_19","PSA","78","19","19","Manga incia aewangi Aulataʼala tee apogau, \"Amembali buaka o Aulataʼala apasiapu kinande i tana matuu? ");
INSERT INTO wlo_vpl VALUES ("PS78_20","020_78_20","PSA","78","20","20","Atotuumo ande o bhatu abhebhea sabutuna apidhiaka uwe tee manga umala apasiwulua tee alua, maka amembali buaka Incia manga dhawuaka roti, atawa amembali buaka Incia apasiapu dagi to uumatina?\" ");
INSERT INTO wlo_vpl VALUES ("PS78_21","020_78_21","PSA","78","21","21","Sabutuna o KAWASANA OPU apamuru wakutuuna arango giu incia sumai; waa morore akangkanai uumatina Yakub, tee o pamuruna ahandamo mpuu to miana Israel, ");
INSERT INTO wlo_vpl VALUES ("PS78_22","020_78_22","PSA","78","22","22","roonamo manga incia inda aʼiimani i Aulataʼala tee inda aparacaea ande Incia bhemopasalaamatina manga incia. ");
INSERT INTO wlo_vpl VALUES ("PS78_23","020_78_23","PSA","78","23","23","Maka Incia adhawu parintana to laiana, tee abungkale manga bhambana sorogaa; ");
INSERT INTO wlo_vpl VALUES ("PS78_24","020_78_24","PSA","78","24","24","Incia apasapo waona manna mamudhaakana manga incia amembali akande, tee mboo sumai Incia adhawuaka to manga incia o gandum minaaka i sorogaa. ");
INSERT INTO wlo_vpl VALUES ("PS78_25","020_78_25","PSA","78","25","25","Maanusia akande rotina malaaʼekati; Aulataʼala adhawuaka manga incia kinande motaralabhi-labhi. ");
INSERT INTO wlo_vpl VALUES ("PS78_26","020_78_26","PSA","78","26","26","Incia atowii ngaluna timbu i laiana, tee atowii ngaluna salata tee kuasana; ");
INSERT INTO wlo_vpl VALUES ("PS78_27","020_78_27","PSA","78","27","27","Incia apasapo waona dagi mboomo ngawu o kabharina, tee manu-manu mboomo kabharina bhone i tawo. ");
INSERT INTO wlo_vpl VALUES ("PS78_28","020_78_28","PSA","78","28","28","Incia apakotibu manga manu-manu sumai i tanga-tangana pokemaana, i saripina mbooresana manga incia. ");
INSERT INTO wlo_vpl VALUES ("PS78_29","020_78_29","PSA","78","29","29","Kasiimpo manga incia akande sakawana amambosu mpuu, roonamo Aulataʼala padhamo adhawuakea opea ipeeluna manga incia apokana tee nawusuuna. ");
INSERT INTO wlo_vpl VALUES ("PS78_30","020_78_30","PSA","78","30","30","Maka indapo uka manga incia atumpu incana, siitumo tangasaana o kinande dhaangiapo i nuncana ngangana manga incia, ");
INSERT INTO wlo_vpl VALUES ("PS78_31","020_78_31","PSA","78","31","31","pamuruna Aulataʼala aumba tee abhali manga incia tee ahobuti inyawana manga jampina manga incia, tee apekamate manga ana mangurana Israel. ");
INSERT INTO wlo_vpl VALUES ("PS78_32","020_78_32","PSA","78","32","32","Moomini mboo sumai, manga incia sadhaadhaa akodosa, manga incia inda aparacaea tee manga giu inda momentela mopadhana ipewauna. ");
INSERT INTO wlo_vpl VALUES ("PS78_33","020_78_33","PSA","78","33","33","Rampaakanamo sumai, Kawasana Opu apekamate manga incia mboomo sampearo tahela poinunca, tee o dhadhina manga incia apepadhaia i nuncana balaa motomaeka mokawana inda inamu-namu. ");
INSERT INTO wlo_vpl VALUES ("PS78_34","020_78_34","PSA","78","34","34","Siitumo ande Incia apekamate sagaa minaaka i manga incia, siimpomo manga incia apeeloa; manga incia atobamo tee abhalili apeelo Aulataʼala tee mpuu-mpuuna incana. ");
INSERT INTO wlo_vpl VALUES ("PS78_35","020_78_35","PSA","78","35","35","Manga incia audhania ande o Aulataʼala gunu bhatuna manga incia, tee o Aulataʼala Momalanga motolosina manga incia. ");
INSERT INTO wlo_vpl VALUES ("PS78_36","020_78_36","PSA","78","36","36","Maka manga incia atipu Aulataʼala tee ngangana, tee agau-gaua tee dhelana manga incia. ");
INSERT INTO wlo_vpl VALUES ("PS78_37","020_78_37","PSA","78","37","37","Ngangarandana manga incia inda atotapu i Aulataʼala; manga incia inda akeniaka janjina. ");
INSERT INTO wlo_vpl VALUES ("PS78_38","020_78_38","PSA","78","38","38","Maka roonamo Incia amaasiaka uumatina, sumaimo Aulataʼala aʼamponi kasalahana manga incia tee inda apabinasea. Sampe Incia uka amenturu ataangi amarana, tee inda apalimba pamuruna. ");
INSERT INTO wlo_vpl VALUES ("PS78_39","020_78_39","PSA","78","39","39","Incia amataua ande o maanusia inda abakaa, manga incia mboomo ngalu molalo tee inda ambuli pendua. ");
INSERT INTO wlo_vpl VALUES ("PS78_40","020_78_40","PSA","78","40","40","Manga incia amenturu mpuu adorohaka tee Aulataʼala, tee apekaporo incana i tana matuu. ");
INSERT INTO wlo_vpl VALUES ("PS78_41","020_78_41","PSA","78","41","41","Dhaangia pia mpearo manga incia acobai Aulataʼala, tee apekaporo incana Momangkilona, Aulataʼala isombana miana Israel. ");
INSERT INTO wlo_vpl VALUES ("PS78_42","020_78_42","PSA","78","42","42","Manga incia inda audhania o kuasana, tee inda audhania i wakutuuna Incia atolosi manga incia minaaka i bhalina; ");
INSERT INTO wlo_vpl VALUES ("PS78_43","020_78_43","PSA","78","43","43","i wakutuuna Incia apewau manga tanda inda momentela i Tana Mesir, tee manga muuzizati i atina Zoan. ");
INSERT INTO wlo_vpl VALUES ("PS78_44","020_78_44","PSA","78","44","44","Aulataʼala abhalii manga umala apamembalia raa, mboo sumai uka tee manga siwuluna uwe, sabutuna manga miana Mesir inda amembali asumpua. ");
INSERT INTO wlo_vpl VALUES ("PS78_45","020_78_45","PSA","78","45","45","Incia aumbaaka gulumana lale mosampa to mopepadhaina manga incia, tee aumbaaka barakaka to mopahancuruna manga incia. ");
INSERT INTO wlo_vpl VALUES ("PS78_46","020_78_46","PSA","78","46","46","Incia adhawuaka hasilina timpuana manga incia mamudhaakana akandea o ulo-ulo, tee o hasilina kanguleana bukuna manga incia to akandea kabhoro. ");
INSERT INTO wlo_vpl VALUES ("PS78_47","020_78_47","PSA","78","47","47","Incia apahancuru puuna angguruna manga incia tee wao bhatu, tee manga puuna arana manga incia tee alona esi. ");
INSERT INTO wlo_vpl VALUES ("PS78_48","020_78_48","PSA","78","48","48","Incia ataroaka o gulumana binatana manga incia akangkanaia waona bhatu, tee o gulumana kadhambaakana manga incia akangkanaia bherese. ");
INSERT INTO wlo_vpl VALUES ("PS78_49","020_78_49","PSA","78","49","49","Aulataʼala arambasaka pamuruna mokarore-rore to manga incia; amarana, lumbuna incana, tee kapiina incana, mboomo sarombonga malaaʼekati moumbana to mopacilakana manga incia. ");
INSERT INTO wlo_vpl VALUES ("PS78_50","020_78_50","PSA","78","50","50","Aulataʼala ataroakea o pamuruna akarore-rore, tee inda ajoli-joli manga incia mamudhaakana atopabinasa, maka o inyawana manga incia apasaraakea i panyaki imateaka. ");
INSERT INTO wlo_vpl VALUES ("PS78_51","020_78_51","PSA","78","51","51","Incia apekamate bhari-bharia ana umane tumpe i Mesir, siitumo bhaa-bhaana o kakaana manga incia i pokemaa i Tana Ham. ");
INSERT INTO wlo_vpl VALUES ("PS78_52","020_78_52","PSA","78","52","52","Maka o uumatina karona abhawea alimba mboomo dumba. Incia atonda uumatina i tana matuu mboomo gulumana kadhambaaka. ");
INSERT INTO wlo_vpl VALUES ("PS78_53","020_78_53","PSA","78","53","53","Incia akapalai uumatina sakawana asalaamati, sabutuna o uumatina inda amaeka; sainamo musuna atanggalamu i nuncana tawo. ");
INSERT INTO wlo_vpl VALUES ("PS78_54","020_78_54","PSA","78","54","54","Incia abhawa uumatina sakawana i tanana momangkilo, i gunu incia siimo, mopadhana ipokawaakana tee lima kaanana. ");
INSERT INTO wlo_vpl VALUES ("PS78_55","020_78_55","PSA","78","55","55","Incia uka apadhencu manga lipu mosagaanana minaaka i aroana uumatina, kasiimpo apapodhawu-dhawuakea tee kaʼukuru o lipu tinaurakana sumai to manga incia, tee ataroaka manga lipuna Israel ambooresi kemana manga musuna. ");
INSERT INTO wlo_vpl VALUES ("PS78_56","020_78_56","PSA","78","56","56","Maka manga incia acobai Aulataʼala Momalanga, tee adorohaka i Incia. Manga incia inda aosea o parintana, ");
INSERT INTO wlo_vpl VALUES ("PS78_57","020_78_57","PSA","78","57","57","tee manga incia inda ataʼati tee ahianati pojanjiana tee Aulataʼala mboomo opu-opuana; manga incia inda amembali atotangkaaka mboomo pana mobengko. ");
INSERT INTO wlo_vpl VALUES ("PS78_58","020_78_58","PSA","78","58","58","Manga incia apamembali Aulataʼala aʼamara tee tampana momalanga to apasombaaka kurubani; manga incia apamembali Aulataʼala akaura-ura tee manga patuna dewana. ");
INSERT INTO wlo_vpl VALUES ("PS78_59","020_78_59","PSA","78","59","59","Wakutuuna o Aulataʼala arango giu incia sumai, Incia apamuru, tee amendeu atarima miana Israel sampeampearo! ");
INSERT INTO wlo_vpl VALUES ("PS78_60","020_78_60","PSA","78","60","60","Incia amendeumo amboore i tampana mbooresana i Silo, siitumo o Kema Momangkilo, tampana mbooresana i tanga-tangana maanusia. ");
INSERT INTO wlo_vpl VALUES ("PS78_61","020_78_61","PSA","78","61","61","Incia ataroakea o sorongana pojanjiana atotaangi, tee o tanda kamuliangina amandawu i limana bhali. ");
INSERT INTO wlo_vpl VALUES ("PS78_62","020_78_62","PSA","78","62","62","Incia ataroaka musu apekamate uumatina tee hancu, tee apawoa amarana i uumatina karona. ");
INSERT INTO wlo_vpl VALUES ("PS78_63","020_78_63","PSA","78","63","63","Manga ana umane momangurana manga incia akandea waa sabutuna inda atorango o laguna kawia to manga kabuabua. ");
INSERT INTO wlo_vpl VALUES ("PS78_64","020_78_64","PSA","78","64","64","Manga imamuna manga incia amateaka ewanga, tee manga iaiarona imamu sumai inda atangisi umanena. ");
INSERT INTO wlo_vpl VALUES ("PS78_65","020_78_65","PSA","78","65","65","Kasiimpo abhangumo o KAWASANA OPU mboomo mia siimpo mobhanguna mokole, mboomo jampi asambo-sambo sapadhana asumpu angguru. ");
INSERT INTO wlo_vpl VALUES ("PS78_66","020_78_66","PSA","78","66","66","Incia apewau manga bhalina apalaiaka karona; Incia apewau manga incia amaea saʼumurua. ");
INSERT INTO wlo_vpl VALUES ("PS78_67","020_78_67","PSA","78","67","67","Incia amendeu siwuluna Yusuf tee inda apili sukuna Efraim; ");
INSERT INTO wlo_vpl VALUES ("PS78_68","020_78_68","PSA","78","68","68","maka Incia apili sukuna Yuda, siitumo Gunu Sion imaasiakana. ");
INSERT INTO wlo_vpl VALUES ("PS78_69","020_78_69","PSA","78","69","69","Incia apabhangu tampana momangkilo mboomo kalangana laiana, tee mboomo alamu, momatangka to saʼumurua. ");
INSERT INTO wlo_vpl VALUES ("PS78_70","020_78_70","PSA","78","70","70","Aulataʼala apili Daud, o bhatuana, tee aalea wakutuuna incia tangasaana ajagani gulumana dumba. ");
INSERT INTO wlo_vpl VALUES ("PS78_71","020_78_71","PSA","78","71","71","Aulataʼala aala Daud minaaka i karajaana awulu manga dumba mopadudu sumai tee apamembalia mogembalaakana siwuluna Yakub, siitumo o miana Israel, uumatina tee tinaurakana. ");
INSERT INTO wlo_vpl VALUES ("PS78_72","020_78_72","PSA","78","72","72","Tee karelana totona incana o Daud agembalaaka uumatina, tee kakidhana incia amataua tuaapa o carana akapalai manga incia. ");
INSERT INTO wlo_vpl VALUES ("PS79_1","020_79_1","PSA","79","1","1","Zaburuna Asaf. E Aulataʼala, manga lipu inda momatauko apesuamo i nuncana tana tinaurakamu! Manga incia apanaajisi Bhanuamu Momangkilo; manga incia padhamo apahancuru saangua kota Yerusalem. ");
INSERT INTO wlo_vpl VALUES ("PS79_2","020_79_2","PSA","79","2","2","Manga incia padhamo adhawuaka maeatina manga bhatuamu to kinandena manga manu-manu i laiana, tee o dagina maeatina manga mia mosaalihi to binata maila. ");
INSERT INTO wlo_vpl VALUES ("PS79_3","020_79_3","PSA","79","3","3","Manga incia padhamo alali raana manga mia sumai mboomo uwe i saangua kota Yerusalem, tee inda dhaangia mokoburua. ");
INSERT INTO wlo_vpl VALUES ("PS79_4","020_79_4","PSA","79","4","4","Ingkami tamembalimo kahinana manga sarimbanuamami, tee tamembali kaele-ele tee giu ipogauakana manga mia isaripimami. ");
INSERT INTO wlo_vpl VALUES ("PS79_5","020_79_5","PSA","79","5","5","E KAWASANA OPU, sakawana naepia? Buaka Ingkoo bheupamuru to saʼumurua tee amaramu bhearore mboomo waa roonamo ukaura-ura? ");
INSERT INTO wlo_vpl VALUES ("PS79_6","020_79_6","PSA","79","6","6","Pasapomea o pamurumu i bhawona manga lipu inda momatauko, tee i bhawona manga pamarinta inda mosombako! ");
INSERT INTO wlo_vpl VALUES ("PS79_7","020_79_7","PSA","79","7","7","Sababuna manga incia padhamo apepadhaia uumatimu, siitumo siwuluna Yakub, tee apahancuru mbooresana. ");
INSERT INTO wlo_vpl VALUES ("PS79_8","020_79_8","PSA","79","8","8","Bholi upatanggoaka to ingkami o kasalahana manga opu-opuamami, taroakamo o rahumatimu amadhei akawa i ingkami roonamo amatemo akalamami. ");
INSERT INTO wlo_vpl VALUES ("PS79_9","020_79_9","PSA","79","9","9","Manga tulungimo, e Aulataʼala mopasalaamatina ingkami, to kaogesana saromu. Rampaakanamo saromu, manga rambasaka tee manga amponi minaaka i dosa-dosamami. ");
INSERT INTO wlo_vpl VALUES ("PS79_10","020_79_10","PSA","79","10","10","Bholi utaroakea manga lipu mosagaanana aabha, \"Iapai o Aulataʼalana manga incia?\" Taroakamo ingkami takamatako wakutuuna ubalasi raana manga bhatuamu motopekamatena, mamudhaakana manga lipu amataua. ");
INSERT INTO wlo_vpl VALUES ("PS79_11","020_79_11","PSA","79","11","11","Taroakamo o pekidheina manga mia mototaangi akawa i aroamu; rampaakanamo kaogena kuasamu, taroakamo adhadhiaka manga mia mopadhana itantuaka to atopekamate. ");
INSERT INTO wlo_vpl VALUES ("PS79_12","020_79_12","PSA","79","12","12","Balasia manga lipu i saripimami sumai pitu kali lipa o kahina mboomo mopadhana ipewauna manga incia to Ingkoo, e Kawasana Opu! ");
INSERT INTO wlo_vpl VALUES ("PS79_13","020_79_13","PSA","79","13","13","Sumaimo ingkami o uumatimu, dumba igembalamu sii, bhetasukuru i Ingkoo saʼumurua, tee minaaka i siwulumami sakawana siwulu bhemoumbana bheapetulatulaaka kaogesana saromu. ");
INSERT INTO wlo_vpl VALUES ("PS80_1","020_80_1","PSA","80","1","1","To kapalana molaguna. Aose lagu: Kamba-kamba Bakung. Laguna kasakusii. Zaburuna Asaf. ");
INSERT INTO wlo_vpl VALUES ("PS80_2","020_80_2","PSA","80","2","2","Maasangia urangoa, e Gembalana miana Israel, e Ingkoo mokapalaina siwuluna Yusuf mboomo gulumana dumba! Ingkoo mokokauncuramakana i bhawona manga malaaʼekatina kerub, utiumbamo tee caheamu ");
INSERT INTO wlo_vpl VALUES ("PS80_3","020_80_3","PSA","80","3","3","i aroana Efraim, Binyamin, tee Manasye! Susuakamea o kuasamu tee uumbamo to upasalaamati ingkami! ");
INSERT INTO wlo_vpl VALUES ("PS80_4","020_80_4","PSA","80","4","4","E Aulataʼala, pambulimea pendua o kadhaangiamami; taroakamo o roumu akocahea sabutuna ingkami bhetasalaamati. ");
INSERT INTO wlo_vpl VALUES ("PS80_5","020_80_5","PSA","80","5","5","E KAWASANA OPU, Aulataʼalana saangua alamu, sakawana naepia upamuru, moomini o uumatimu adoʼa? ");
INSERT INTO wlo_vpl VALUES ("PS80_6","020_80_6","PSA","80","6","6","Ingkoo udhawua kaporona inca to kinandena manga incia, tee lolu mobhari to uwe isumpuna. ");
INSERT INTO wlo_vpl VALUES ("PS80_7","020_80_7","PSA","80","7","7","Ingkoo umanga pamembali giu ipotagaliakana manga lipu isaripimami, tee o musumami uka manga ele-ele. ");
INSERT INTO wlo_vpl VALUES ("PS80_8","020_80_8","PSA","80","8","8","E Aulataʼalana saangua alamu, pambulimea pendua o kadhaangiamami, maasangia o roumu akocahea mamudhaakana ingkami tasalaamati. ");
INSERT INTO wlo_vpl VALUES ("PS80_9","020_80_9","PSA","80","9","9","Uumatimu mboomo puuna angguru Ingkoo ubhawea upalimbaia minaaka i Mesir; upadhencu manga lipu mosagaanana, kasiimpo o puuna angguru sumai upombulaia. ");
INSERT INTO wlo_vpl VALUES ("PS80_10","020_80_10","PSA","80","10","10","Ingkoo upekangkiloakea tana to incia, kulesena atuwu tee apabuke saangua lipu. ");
INSERT INTO wlo_vpl VALUES ("PS80_11","020_80_11","PSA","80","11","11","Manga gunu asalibumbuakea tee ngkamia-miana, tee manga rahana atutubhi manga puuna aras momaoge. ");
INSERT INTO wlo_vpl VALUES ("PS80_12","020_80_12","PSA","80","12","12","Manga rangkana adhola sakawana i tawo, tee manga lolona akawa i Umala Efrat. ");
INSERT INTO wlo_vpl VALUES ("PS80_13","020_80_13","PSA","80","13","13","Pokia Ingkoo ubhongka manga tondona sabutuna bhari-bharia mia molalo amembali atobhe bhakena? ");
INSERT INTO wlo_vpl VALUES ("PS80_14","020_80_14","PSA","80","14","14","Bhawu abhembarua, tee bhari-bharia binata maila akandea. ");
INSERT INTO wlo_vpl VALUES ("PS80_15","020_80_15","PSA","80","15","15","E Aulataʼalana saangua alamu, maimo umbuli i uumatimu, tontomea minaaka i sorogaa tee ukamatamea! Maheruakamea o puuna angguru sii, ");
INSERT INTO wlo_vpl VALUES ("PS80_16","020_80_16","PSA","80","16","16","puuna angguru ipombulamu tee kuasamu, tee o tunana ipekatangkamu to karomu. ");
INSERT INTO wlo_vpl VALUES ("PS80_17","020_80_17","PSA","80","17","17","Musu padhamo apale tee atunu puuna angguru sii. Maasangia manga incia abinasa rampaakanamo kagorampangimu. ");
INSERT INTO wlo_vpl VALUES ("PS80_18","020_80_18","PSA","80","18","18","Maka taroakamo limamu adhaangia to mia i weta i kaanamu, siitumo to anana maanusia ipekakaamu to karomu. ");
INSERT INTO wlo_vpl VALUES ("PS80_19","020_80_19","PSA","80","19","19","Tee mboo sumai, ingkami inda bhetasowo minaaka i Ingkoo; jagania o dhadhimami, sumaimo ingkami bhetasombako. ");
INSERT INTO wlo_vpl VALUES ("PS80_20","020_80_20","PSA","80","20","20","E KAWASANA OPU, Aulataʼalana saangua alamu, pambulimea pendua o kadhaangiamami, taroakamo o roumu akocahea mamudhaakana ingkami tasalaamati. ");
INSERT INTO wlo_vpl VALUES ("PS81_1","020_81_1","PSA","81","1","1","To kapalana molaguna. Mboomo lagu Gitit. Zaburuna Asaf. ");
INSERT INTO wlo_vpl VALUES ("PS81_2","020_81_2","PSA","81","2","2","Sambo-sambomo to Kawasana Opu, o kakaata. Sambomo tee ukaunde-undemo to Aulataʼala isombana Yakub. ");
INSERT INTO wlo_vpl VALUES ("PS81_3","020_81_3","PSA","81","3","3","Lagumo tee upakoonimea o ganda-ganda, pakoonimea o kecapi momandii upapooseakea tee suarana gambusu. ");
INSERT INTO wlo_vpl VALUES ("PS81_4","020_81_4","PSA","81","4","4","Towiimea o torompe i bula mobhaau, i wakutuuna kainawana bula, i eona raraeata. ");
INSERT INTO wlo_vpl VALUES ("PS81_5","020_81_5","PSA","81","5","5","Siitumo saangu katotapu to miana Israel, saangu hukumu minaaka i Aulataʼala isombana Yakub. ");
INSERT INTO wlo_vpl VALUES ("PS81_6","020_81_6","PSA","81","6","6","Incia apatotapua amembali saangu kaudhania to siwuluna Yusuf, wakutuuna Incia aewangi Tana Mesir. Iaku kurango suara inda imatauku, ");
INSERT INTO wlo_vpl VALUES ("PS81_7","020_81_7","PSA","81","7","7","\"Iaku padhamo kuangka bhawaamu minaaka i awaamu, tee o limamu kupalapea minaaka i langka kasodhaamu. ");
INSERT INTO wlo_vpl VALUES ("PS81_8","020_81_8","PSA","81","8","8","I nuncana kaseke ingkoo ugora, kasiimpo kurambasakako. Kulawani ingkoo minaaka i tampa rahasiana guntu, tee Iaku padhamo kuuji ingkoo i matana uwe Meriba. Sela ");
INSERT INTO wlo_vpl VALUES ("PS81_9","020_81_9","PSA","81","9","9","E uumatiku, rangoa opea iudhaniakaku! E Israel, ande mpuu ingkoo unda uperangoiaku! ");
INSERT INTO wlo_vpl VALUES ("PS81_10","020_81_10","PSA","81","10","10","Bholi dhaangia i tanga-tangamiu aulataʼala mosagaanana, tee bholimo usomba dewana lipu mosagaanana. ");
INSERT INTO wlo_vpl VALUES ("PS81_11","020_81_11","PSA","81","11","11","Iakumo KAWASANA OPU, Aulataʼalamu, mobhawako ulimba minaaka i tana Mesir. Bungkalea ngangamu pekaewa-ewa, tee bhekuantokia kupabukea.\" ");
INSERT INTO wlo_vpl VALUES ("PS81_12","020_81_12","PSA","81","12","12","\"Maka, o uumatiku amendeu aperangoiaku, Israel amendeu atungku i aroaku. ");
INSERT INTO wlo_vpl VALUES ("PS81_13","020_81_13","PSA","81","13","13","Sababuna sumai, Iaku kutaroaka manga incia amentagali torosu, sabutuna manga incia adhadhi aose haejatina karona. ");
INSERT INTO wlo_vpl VALUES ("PS81_14","020_81_14","PSA","81","14","14","Ande mpuu o uumatiku aunda aperangoiaku, ande mpuu Israel aunda adhadhi mboomo kapeeluku, ");
INSERT INTO wlo_vpl VALUES ("PS81_15","020_81_15","PSA","81","15","15","sumaimo bhekuagoria to kupekatalo musuna manga incia, tee kuewangi bhari-bharia bhalina manga incia. ");
INSERT INTO wlo_vpl VALUES ("PS81_16","020_81_16","PSA","81","16","16","Manga mia mobancina KAWASANA OPU naile itu bheatungku tee arengku i aroana, tee kahukumuna to manga incia bheanamisia saʼumurua. ");
INSERT INTO wlo_vpl VALUES ("PS81_17","020_81_17","PSA","81","17","17","Maka, bhekudhawuakako kinande minaaka i gandum momalapena mpuu, tee uka iaku bhekupekambosuakako golana uwani minaaka gunu bhatu.\" ");
INSERT INTO wlo_vpl VALUES ("PS82_1","020_82_1","PSA","82","1","1","Zaburuna Asaf. Aulataʼala akapalai sidangi i sorogaa. Incia amembali haakimu mobhotukiakana parakara i tanga-tangana manga \"aulataʼala,\" ");
INSERT INTO wlo_vpl VALUES ("PS82_2","020_82_2","PSA","82","2","2","\"Sakawana naepia ingkomiu bheuala kambotu tee cara inda moʼadili tee uewaaka manga mia madhaki? Sela ");
INSERT INTO wlo_vpl VALUES ("PS82_3","020_82_3","PSA","82","3","3","Ewaakamea o hakuna mia momisikini tee ana maelu, dhawuakea kaʼadili to mia motopisaki tee mia inda mokokadhaangia. ");
INSERT INTO wlo_vpl VALUES ("PS82_4","020_82_4","PSA","82","4","4","Pasalaamatia o mia momisikini tee mia monarakaa, rambasakea manga incia minaaka i limana mia madhaki.\" ");
INSERT INTO wlo_vpl VALUES ("PS82_5","020_82_5","PSA","82","5","5","Ingkomiu inda umataua, ingkomiu uka inda umaʼanaia, ingkomiu udhala i nuncana kalalanda; bhari-bharia ariina alamu sii atolendu tee tuturana raʼeati amarungga. ");
INSERT INTO wlo_vpl VALUES ("PS82_6","020_82_6","PSA","82","6","6","Iaku padhamo kufirimani, \"Ingkomiu sii 'manga aulataʼala' tee bhari-bharikomiu sii o anana Momalangana; ");
INSERT INTO wlo_vpl VALUES ("PS82_7","020_82_7","PSA","82","7","7","moomini mboo sumai, ingkomiu bheumate mboomo maanusia, tee mboomo manga kaogesa, ingkomiu uka bheumate.\" ");
INSERT INTO wlo_vpl VALUES ("PS82_8","020_82_8","PSA","82","8","8","E Aulataʼala, kakaromo, adilia o dunia sii; roonamo bhari-bharia lipu satotuuna o pewauamu. ");
INSERT INTO wlo_vpl VALUES ("PS83_1","020_83_1","PSA","83","1","1","Zaburuna Asaf to saangu lagu. ");
INSERT INTO wlo_vpl VALUES ("PS83_2","020_83_2","PSA","83","2","2","E Aulataʼala, bholi inda tee uuʼuumu, bholi ukatongo-tongo tee usaku limamu, e Aulataʼala! ");
INSERT INTO wlo_vpl VALUES ("PS83_3","020_83_3","PSA","83","3","3","Kamatamea, manga musumu apewau karobho, manga mia mobanciko apekalangamo bhaana. ");
INSERT INTO wlo_vpl VALUES ("PS83_4","020_83_4","PSA","83","4","4","Manga incia apadhaangia pomufaakati madhaki to aewangi uumatimu, tee aposaangu to aewangi manga mia ijaganimu. ");
INSERT INTO wlo_vpl VALUES ("PS83_5","020_83_5","PSA","83","5","5","Pogauna manga incia, \"Mai tapabinasea o lipuna Israel, mamudhaakana o sarona Israel inda atoudhani!\" ");
INSERT INTO wlo_vpl VALUES ("PS83_6","020_83_6","PSA","83","6","6","Manga incia aposaangu i nuncana saangu haejati, tee apojanji to aewangiko. ");
INSERT INTO wlo_vpl VALUES ("PS83_7","020_83_7","PSA","83","7","7","Manga incia satotuuna o mia momboorena i pokemaana Edom tee miana Ismail, miana Moab tee miana Hagar, ");
INSERT INTO wlo_vpl VALUES ("PS83_8","020_83_8","PSA","83","8","8","Gebal, Amon, Amalek, Tana Filistin tee raʼeatina Tirus. ");
INSERT INTO wlo_vpl VALUES ("PS83_9","020_83_9","PSA","83","9","9","Tee o Asyur uka aposaangu tee manga incia, amembali motulungina siwuluna Lut. Sela ");
INSERT INTO wlo_vpl VALUES ("PS83_10","020_83_10","PSA","83","10","10","Pewaumea manga incia mboomo ipewaumu i miana Midian, tee mboomo ipewaumu i Sisera tee Yabin i bhiwina Umala Kison, ");
INSERT INTO wlo_vpl VALUES ("PS83_11","020_83_11","PSA","83","11","11","mopadhana ipabinasamu minaaka i nuncana dunia, tee o maeatina amembali karombu to pasuburuana tana. ");
INSERT INTO wlo_vpl VALUES ("PS83_12","020_83_12","PSA","83","12","12","Pamembalia o kaogesana manga incia mboomo Oreb tee Zeb, patungkua o rajana manga incia mboomo Zebah tee Salmuna ");
INSERT INTO wlo_vpl VALUES ("PS83_13","020_83_13","PSA","83","13","13","mopogauna, \"Mai takuasaia o lipu mbooresana Aulataʼala!\" ");
INSERT INTO wlo_vpl VALUES ("PS83_14","020_83_14","PSA","83","14","14","E Aulataʼala, pamembalia manga incia mboomo ngawu mopolaka, mboomo laena bhae ibhaleakana ngalu. ");
INSERT INTO wlo_vpl VALUES ("PS83_15","020_83_15","PSA","83","15","15","Mboomo waa motununa koo, tee mboomo rorena waa mopekangauna manga gunu, ");
INSERT INTO wlo_vpl VALUES ("PS83_16","020_83_16","PSA","83","16","16","pajerea manga incia tee garuramu, tee upekaekaia tee tambusisimu. ");
INSERT INTO wlo_vpl VALUES ("PS83_17","020_83_17","PSA","83","17","17","Taroakamea o rouna manga incia abukeaka aebu tee taroakamo saromu, e KAWASANA OPU, abalasiaka karona. ");
INSERT INTO wlo_vpl VALUES ("PS83_18","020_83_18","PSA","83","18","18","Taroakamo manga incia amaea tee amaidhiidhi incana saʼumurua; taroakamo manga incia anamisi kaea tee amate. ");
INSERT INTO wlo_vpl VALUES ("PS83_19","020_83_19","PSA","83","19","19","Taroakamo manga incia amataua ande tangkanamo Ingkoo mokosarona KAWASANA OPU, Momalangana i saangua dunia. ");
INSERT INTO wlo_vpl VALUES ("PS84_1","020_84_1","PSA","84","1","1","To kapalana molaguna. Mboomo lagu Gitit. Zaburuna miana Korah. ");
INSERT INTO wlo_vpl VALUES ("PS84_2","020_84_2","PSA","84","2","2","Tapanamo kasanaana o tampana mbooresamu, e KAWASANA OPUNA saangua alamu! ");
INSERT INTO wlo_vpl VALUES ("PS84_3","020_84_3","PSA","84","3","3","Incaku apemeliliaka bhanuana KAWASANA OPU, sampemo kumalute roonamo pemeliliku sumai. Saangua badaku tee jiwaku akaunde-unde to Aulataʼala modhadhi. ");
INSERT INTO wlo_vpl VALUES ("PS84_4","020_84_4","PSA","84","4","4","Manu-manu ntomintomi apotibhaaka bhanua to karona, tee o manu-manu walawalangke apotibhaaka saangu poteo, to tampana adhika manga anana i saripina manga tampana tunuana kurubanimu, e KAWASANA OPUNA saangua alamu, e Rajaku tee Aulataʼalaku. ");
INSERT INTO wlo_vpl VALUES ("PS84_5","020_84_5","PSA","84","5","5","Amasanaamo o mia momboorena i Bhanuamu, Manga incia atorotorosu apujiko. Sela ");
INSERT INTO wlo_vpl VALUES ("PS84_6","020_84_6","PSA","84","6","6","Amasanaamo mia mopotibhaakana kakaa minaaka i Ingkoo, tee o ngangarandana apemeliliaka to aziara i Gunu Sion. ");
INSERT INTO wlo_vpl VALUES ("PS84_7","020_84_7","PSA","84","7","7","Wakutuuna manga incia alalo i Mbolonga Baka, tampa incia sumai abhaliia amembali matana uwe. Bulaana wao bhaa-bhaana uka abhari aumbaaka barakati to mbolonga sumai. ");
INSERT INTO wlo_vpl VALUES ("PS84_8","020_84_8","PSA","84","8","8","Samangengena alingka sahandana uka o kakaana, sakawana apoaro tee Aulataʼala mobhawoakana bhari-bharia dewa i Sion. ");
INSERT INTO wlo_vpl VALUES ("PS84_9","020_84_9","PSA","84","9","9","E KAWASANA OPU, Aulataʼalana saangua alamu, perangoia o doʼaku. Tilikimea, e Aulataʼala isombana Yakub! Sela ");
INSERT INTO wlo_vpl VALUES ("PS84_10","020_84_10","PSA","84","10","10","Tontomea o raja mopadhana ipilimu, e Aulataʼala, kamatamea o rouna mia mopadhana ilantimu to katangkesina uumatimu. ");
INSERT INTO wlo_vpl VALUES ("PS84_11","020_84_11","PSA","84","11","11","Roonamo amalape saeo i aroana Bhanuamu minaaka i sarewu eo i tampa mosagaanana. Iaku labhina kumaasiaka kumembali mojaganina Bhanuana Aulataʼalaku minaaka i kumboore i kemana mia madhaki. ");
INSERT INTO wlo_vpl VALUES ("PS84_12","020_84_12","PSA","84","12","12","Roonamo KAWASANA OPU, Aulataʼala satotuuna o matanaeo tee o katangkesita; Incia manga dhawuaka rahumati tee kamuliangi. KAWASANA OPU sadia apewau kalape tee manga mia moosena dhala mobanara. ");
INSERT INTO wlo_vpl VALUES ("PS84_13","020_84_13","PSA","84","13","13","E KAWASANA OPUNA saangua alamu, akaunde-undemo bhari-bharia mia moparacaeako! ");
INSERT INTO wlo_vpl VALUES ("PS85_1","020_85_1","PSA","85","1","1","To kapalana molaguna. Zaburuna miana Korah. ");
INSERT INTO wlo_vpl VALUES ("PS85_2","020_85_2","PSA","85","2","2","E KAWASANA OPU, Ingkoo padhamo upewau malape to lipumu minaaka i piamo itu, Ingkoo padhamo upekalapea pendua o kadhaangiana miana Israel. ");
INSERT INTO wlo_vpl VALUES ("PS85_3","020_85_3","PSA","85","3","3","Ingkoo padhamo uʼamponia o dosana uumatimu, tee ututubhia bhari-bharia dosana manga incia. Sela ");
INSERT INTO wlo_vpl VALUES ("PS85_4","020_85_4","PSA","85","4","4","Bhari-bharia iʼamaraakamu padhamo upauntoa, tee upanaindamea o pamurumu mokarore-rorena sumai. ");
INSERT INTO wlo_vpl VALUES ("PS85_5","020_85_5","PSA","85","5","5","Sii-sii pambulimea pendua o kadhaangiamami mboomo i piamo itu, e Aulataʼala, manga mopasalaamatina, tee upekaridhomea o pamurumu to ingkami. ");
INSERT INTO wlo_vpl VALUES ("PS85_6","020_85_6","PSA","85","6","6","Buaka saʼumurua Ingkoo bheupamuru tee ingkami? Buaka saʼumurua bheutorotorosu uʼamara tee ingkami tee siwulumami? ");
INSERT INTO wlo_vpl VALUES ("PS85_7","020_85_7","PSA","85","7","7","Buaka Ingkoo umendeu manga padhadhi pendua mamudhaakana o uumatimu akaunde-unde rampaakanamo Ingkoo? ");
INSERT INTO wlo_vpl VALUES ("PS85_8","020_85_8","PSA","85","8","8","E KAWASANA OPU, susuakamea o kaasimu molagina to ingkami, tee mangadhawuakamo kasalaamatimu. ");
INSERT INTO wlo_vpl VALUES ("PS85_9","020_85_9","PSA","85","9","9","Iaku gauku kuperangoi opea bheifirimaniakana KAWASANA OPU, siitumo o Aulataʼala, roonamo Incia bheafirimaniaka kasanaa to uumatina tee manga mia mosaalihi. Maka manga incia bholi apendua akabhongo-bhongo. ");
INSERT INTO wlo_vpl VALUES ("PS85_10","020_85_10","PSA","85","10","10","Satotuuna o kasalaamati minaaka i Kawasana Opu amakasu tee manga mia momaekana tee Incia mamudhaakana o kamuliangina amembali amboore i liputa. ");
INSERT INTO wlo_vpl VALUES ("PS85_11","020_85_11","PSA","85","11","11","Kaasi molagina tee pojanjia inda momabhotu bheapokawa, kabanara tee kasanaa bheaposakulaka. ");
INSERT INTO wlo_vpl VALUES ("PS85_12","020_85_12","PSA","85","12","12","Kataʼatina maanusia i Kawasana Opu bheatuwu minaaka i tana, tee o kabanara bheapotonto minaaka i sorogaa. ");
INSERT INTO wlo_vpl VALUES ("PS85_13","020_85_13","PSA","85","13","13","KAWASANA OPU uka bhearahumatiaka kalapena, tee o liputa bheakohasiliaka timpua motaralabhi-labhi. ");
INSERT INTO wlo_vpl VALUES ("PS85_14","020_85_14","PSA","85","14","14","Kabanara bheaporikanaaka dhalana Aulataʼala, tee apasiapuakea dhala to Incia. ");
INSERT INTO wlo_vpl VALUES ("PS86_1","020_86_1","PSA","86","1","1","Doʼana Daud. E KAWASANA OPU, perangoiaku tee ulawaniakumo, roonamo kunarakaa tee kumisikini. ");
INSERT INTO wlo_vpl VALUES ("PS86_2","020_86_2","PSA","86","2","2","Jagania o inyawaku roonamo iaku kutaʼatiko, pasalaamatia o bhatuamu moparacaeana tee Ingkoo. ");
INSERT INTO wlo_vpl VALUES ("PS86_3","020_86_3","PSA","86","3","3","Maasiakaaku, e Kawasana Opuku, roonamo saeoa kudoʼa i Ingkoo. ");
INSERT INTO wlo_vpl VALUES ("PS86_4","020_86_4","PSA","86","4","4","Paunde-undemea o ngangarandana bhatuamu sii, roonamo i Ingkoomo tampaku kusomba, e Kawasana Opu. ");
INSERT INTO wlo_vpl VALUES ("PS86_5","020_86_5","PSA","86","5","5","E Aualataʼala, Ingkoo umalape tee upekaʼamponi, kaasimu molagina ataralabhi-labhi to bhari-bharia mia modoʼana i Ingkoo. ");
INSERT INTO wlo_vpl VALUES ("PS86_6","020_86_6","PSA","86","6","6","E KAWASANA OPU, perangoimea o doʼaku, tee faduliakaaku wakutuuna kuemani tulungi. ");
INSERT INTO wlo_vpl VALUES ("PS86_7","020_86_7","PSA","86","7","7","Wakutuuna kumaseke iaku kugora i Ingkoo roonamo Ingkoo bheutarima doʼaku. ");
INSERT INTO wlo_vpl VALUES ("PS86_8","020_86_8","PSA","86","8","8","Inda dhaangia mopokanana tee Ingkoo i tanga-tangana manga dewa, e Kawasana Opu, tee inda dhaangia mopokanana tee opea ipewaumu. ");
INSERT INTO wlo_vpl VALUES ("PS86_9","020_86_9","PSA","86","9","9","Bhari-bharia lipu ipadhaangiamu bheaumba tee asuju i aroamu, e Kawasana Opu, tee bheamuliangia o saromu. ");
INSERT INTO wlo_vpl VALUES ("PS86_10","020_86_10","PSA","86","10","10","Sababuna Ingkoo umakaa tee upewau manga giu inda momentela. Tangkanamo Ingkoo o Aulataʼala. ");
INSERT INTO wlo_vpl VALUES ("PS86_11","020_86_11","PSA","86","11","11","E KAWASANA OPU, adhariakaaku dhalamu, mamudhaakana kudhadhi kuosea kabanaramu; pekatangkea incaku mamudhaakana kuhoromati saromu. ");
INSERT INTO wlo_vpl VALUES ("PS86_12","020_86_12","PSA","86","12","12","E Aulataʼala, KAWASANA OPU, iaku bhekupujiko tee mpuu-mpuuna incaku, tee bhekumuliangi saromu saʼumurua. ");
INSERT INTO wlo_vpl VALUES ("PS86_13","020_86_13","PSA","86","13","13","Roonamo kaasimu molagina amaoge mpuu to iaku, Ingkoo padhamo upasalaamatiaku minaaka i mate. ");
INSERT INTO wlo_vpl VALUES ("PS86_14","020_86_14","PSA","86","14","14","E Aulataʼala, manga mia mosombo ahumbuniaku; rombongana manga mia masega gauna apekamateaku, tee manga incia inda afaduliakako. ");
INSERT INTO wlo_vpl VALUES ("PS86_15","020_86_15","PSA","86","15","15","Maka Ingkoo e Kawasana Opu, satotuuna o Aulataʼala mobukeakana kaasi, usabara tee ataralabhi-labhi o kaasimu molagina tee pojanjiamu tee iaku inda amabhotu. ");
INSERT INTO wlo_vpl VALUES ("PS86_16","020_86_16","PSA","86","16","16","Tontoaku tee umaasiakaakumo; dhawuakea bhatuamu sii kakaamu tee upasalaamatiaku, roonamo mboomo inaku, iaku uka kulaianiko. ");
INSERT INTO wlo_vpl VALUES ("PS86_17","020_86_17","PSA","86","17","17","Dhawuakaaku saangu tanda ande Ingkoo umalape mamudhaakana manga mia mobanciaku amaea wakutuuna akamatea ande Ingkoo, KAWASANA OPU, motulungiaku tee mopekatangkana incaku. ");
INSERT INTO wlo_vpl VALUES ("PS87_1","020_87_1","PSA","87","1","1","Zaburuna miana Korah, saangu lagu. KAWASANA OPU apakaro kotana i bhawona tubuna gunu momangkilo. ");
INSERT INTO wlo_vpl VALUES ("PS87_2","020_87_2","PSA","87","2","2","KAWASANA OPU amaasiaka bhambana lawana Sion alabhi minaaka i bhari-bharia tampa mosagaanana modhaangiana i Israel, lipuna Yakub. ");
INSERT INTO wlo_vpl VALUES ("PS87_3","020_87_3","PSA","87","3","3","Manga mia apogauakako tee giu momulia, e kotana Aulataʼala. Sela ");
INSERT INTO wlo_vpl VALUES ("PS87_4","020_87_4","PSA","87","4","4","Pogauna Kawasana Opu, \"Iaku bhekusarongi Rahab tee Babel i tanga-tangana lipu momatauaku. Tee uka o Tana Filistin, Tirus tee Etiopia, 'Manga incia sii uka atoabhi amembali raʼeatina Sion.' \" ");
INSERT INTO wlo_vpl VALUES ("PS87_5","020_87_5","PSA","87","5","5","Maka to Sion, manga mia bheapogau, \"Mia incia sii tee mia incia sumai alaahiri i nuncana, tee o Aulataʼala Momalangana sakaro-karona bhemopekatangkea.\" ");
INSERT INTO wlo_vpl VALUES ("PS87_6","020_87_6","PSA","87","6","6","KAWASANA OPU bhealentua wakutuuna daftaraana manga lipu, \"Manga incia sii uka aabhia o raʼeatina Sion.\" Sela ");
INSERT INTO wlo_vpl VALUES ("PS87_7","020_87_7","PSA","87","7","7","Apoose amanari, manga mia bhealagu, \"Minaaka i Sion ingkita tatarima manga giu momalape mboomo mia momboorena i saripina matana uwe.\" ");
INSERT INTO wlo_vpl VALUES ("PS88_1","020_88_1","PSA","88","1","1","Doʼa to kapalana molaguna. Zaburuna miana Korah. Mboomo lagu: Kasukarana Kanarakaa. Lagu kaadharina Heman, miana Ezrahi. ");
INSERT INTO wlo_vpl VALUES ("PS88_2","020_88_2","PSA","88","2","2","E KAWASANA OPU, e Aulataʼala mopasalaamatiaku, iaku kukagora-gora o eo tee malo i aroamu. ");
INSERT INTO wlo_vpl VALUES ("PS88_3","020_88_3","PSA","88","3","3","Taroakamo o doʼaku akawa i aroamu. Maasangia urangoa o goraku. ");
INSERT INTO wlo_vpl VALUES ("PS88_4","020_88_4","PSA","88","4","4","Roonamo abharimo mpuu kunamisi kanarakaa, tee saidhepo kumate. ");
INSERT INTO wlo_vpl VALUES ("PS88_5","020_88_5","PSA","88","5","5","Iaku kutolentu i tanga-tangana mia mopesuana i liana koburu, tee o kakaana bukuku kabilanga atopadhamo. ");
INSERT INTO wlo_vpl VALUES ("PS88_6","020_88_6","PSA","88","6","6","Iaku mboomo mia motobholi i tanga-tangana mia mate, mboomo mia motopekamate ipatidhole i nuncana koburu, tee indamo uudhaniaku uka, roonamo kutorambasakamo minaaka i limamu. ");
INSERT INTO wlo_vpl VALUES ("PS88_7","020_88_7","PSA","88","7","7","Ingkoo udhikaaku i nuncana koburu i tambe mpuu, i tampa momandala tee momalalanda. ");
INSERT INTO wlo_vpl VALUES ("PS88_8","020_88_8","PSA","88","8","8","Pamurumu amatamo mpuu kunamisia, tee utaburiaku mboomo ewona tawo. Sela ");
INSERT INTO wlo_vpl VALUES ("PS88_9","020_88_9","PSA","88","9","9","Ingkoo upekaridhoakaaku manga musirahaku, tee upewaua manga incia amarikaaku. Iaku kumboore i nuncana kurunga tee inda amembali kulimba; ");
INSERT INTO wlo_vpl VALUES ("PS88_10","020_88_10","PSA","88","10","10","mataku amarea roonamo kanarakaa. E KAWASANA OPU, saesaeo iaku kugora i Ingkoo, iaku kutaanaka limaku i Ingkoo. ");
INSERT INTO wlo_vpl VALUES ("PS88_11","020_88_11","PSA","88","11","11","Buaka Ingkoo bheupewau muuzizati to mia mate? Inda! Buaka o rohi bheabhangu to apuji Ingkoo? Inda! Sela ");
INSERT INTO wlo_vpl VALUES ("PS88_12","020_88_12","PSA","88","12","12","Buaka o kaasimu molagina atopakoleleaka i nuncana koburu, tee o lele pojanjiamu inda amabhotu atopakoleleaka i tampana pabinasaana mia? Inda! ");
INSERT INTO wlo_vpl VALUES ("PS88_13","020_88_13","PSA","88","13","13","Dhaangia buaka momatauna muuzizatimu i nuncana kalalanda, tee momatauna kabanaramu i lipu tampana sagala giu atomalinguaka? Inda! ");
INSERT INTO wlo_vpl VALUES ("PS88_14","020_88_14","PSA","88","14","14","Maka iaku kupekee kuemani tulungi i Ingkoo, e KAWASANA OPU, saeona mpuu akawamo o doʼaku i aroamu. ");
INSERT INTO wlo_vpl VALUES ("PS88_15","020_88_15","PSA","88","15","15","E KAWASANA OPU, pokia Ingkoo ubhanakaaku? Pokia ubuniakea o roumu minaaka i karoku? ");
INSERT INTO wlo_vpl VALUES ("PS88_16","020_88_16","PSA","88","16","16","Minaaka dhaangia kumaidhiidhi kunarakaa tee saidhepo kumate, inda kukapoia kutanggo manga kamingkiri iumbaakamu. ");
INSERT INTO wlo_vpl VALUES ("PS88_17","020_88_17","PSA","88","17","17","Pamurumu mokarore-rore akangkanaiaku; kamingkiri ahumbuniaku sakawana kubinasa. ");
INSERT INTO wlo_vpl VALUES ("PS88_18","020_88_18","PSA","88","18","18","Bhari-bharia sumai akangkanaiaku mboomo mawa saeoa tee alibuaku minaaka i bhari-bharia rope. ");
INSERT INTO wlo_vpl VALUES ("PS88_19","020_88_19","PSA","88","19","19","Manga sabhangkaku tee musirahaku upekaridhoakaaku minaaka i karoku; sii-sii o sabhangkaku soomo kalalanda. ");
INSERT INTO wlo_vpl VALUES ("PS89_1","020_89_1","PSA","89","1","1","Lagu kaadharina Etan, miana Ezrahi. ");
INSERT INTO wlo_vpl VALUES ("PS89_2","020_89_2","PSA","89","2","2","Iaku bhekulaguaka lagu kaasina KAWASANA OPU molagina saʼumurua, tee ngangaku bhekupakoleleaka pojanjiamu inda amabhotu saʼumurua zamani. ");
INSERT INTO wlo_vpl VALUES ("PS89_3","020_89_3","PSA","89","3","3","Iaku kupogau, \"Kaasimu molagina amatangka saʼumurua, tee pojanjiamu inda momabhotu upatotapua i laiana.\" ");
INSERT INTO wlo_vpl VALUES ("PS89_4","020_89_4","PSA","89","4","4","Kawasana Opu apogau, \"Iaku padhamo kubhoke pojanjia tee mia ipiliku, Iaku padhamo kupotunda tee Daud, bhatuaku, ");
INSERT INTO wlo_vpl VALUES ("PS89_5","020_89_5","PSA","89","5","5","'Iaku bhekupatotapuaka manga siwulumu saʼumurua, tee kubhangu kauncuramakamu to siwulumu naile itu.' \" Sela ");
INSERT INTO wlo_vpl VALUES ("PS89_6","020_89_6","PSA","89","6","6","E KAWASANA OPU, taroakamo manga mahalukuna sorogaa apuji manga giu inda momentela ipewaumu, tee pojanjiamu inda momabhotu i tanga-tangana rombongana malaaʼekati mangkilo. ");
INSERT INTO wlo_vpl VALUES ("PS89_7","020_89_7","PSA","89","7","7","Incema buaka i laiana momembalina mopodhimbana tee KAWASANA OPU? Incema buaka modhaangiana i tanga-tangana mahalukuna sorogaa momembalina motopapokana tee KAWASANA OPU? ");
INSERT INTO wlo_vpl VALUES ("PS89_8","020_89_8","PSA","89","8","8","Incia o Aulataʼala motohoromati i nuncana majilisina malaaʼekati momangkilo, amaoge tee atomaeka alabhi minaaka i bhari-bharia modhaangiana i saripina. ");
INSERT INTO wlo_vpl VALUES ("PS89_9","020_89_9","PSA","89","9","9","E KAWASANA OPU, Aulataʼalana saangua alamu, incema buaka mopokanana tee ingkoo? Ingkoo umakaa, e KAWASANA OPU, tee sadia ubukeaka pojanjia inda momabhotu. ");
INSERT INTO wlo_vpl VALUES ("PS89_10","020_89_10","PSA","89","10","10","Ingkoo mokuasaina ewona tawo; ande o ewo amalanga, Ingkoo mopekalinoa. ");
INSERT INTO wlo_vpl VALUES ("PS89_11","020_89_11","PSA","89","11","11","Ingkoo mopahancuruna Rahab mboomo maeati; Ingkoo mopapogaa-gaana manga musumu tee kakaamu. ");
INSERT INTO wlo_vpl VALUES ("PS89_12","020_89_12","PSA","89","12","12","Laiana o pewauamu tee o alamu o pewauamu uka. Ingkoo mopadhaangiana dunia tee bhari-bharia antona. ");
INSERT INTO wlo_vpl VALUES ("PS89_13","020_89_13","PSA","89","13","13","Napa tee salata, Ingkoo mopadhaangiaia; Gunu Tabor tee Hermon uka asambo-sambo roonamo saromu. ");
INSERT INTO wlo_vpl VALUES ("PS89_14","020_89_14","PSA","89","14","14","Limamu amaoge, lima kaanamu atopekalanga tee kakaana momulia. ");
INSERT INTO wlo_vpl VALUES ("PS89_15","020_89_15","PSA","89","15","15","Kabanara tee kaʼadili amembali o fondasina kauncuramakamu, kaasi molagina tee pojanjiamu inda momabhotu atokamata i nuncana bhari-bharia pewaumu. ");
INSERT INTO wlo_vpl VALUES ("PS89_16","020_89_16","PSA","89","16","16","Amasanaamo o lipu mosambo-sambona mopujiko, modhadhina i nuncana caheana roumu, e KAWASANA OPU! ");
INSERT INTO wlo_vpl VALUES ("PS89_17","020_89_17","PSA","89","17","17","Roonamo saromu manga incia akaunde-unde saeoa, tee roonamo kabanaramu manga incia apujiko. ");
INSERT INTO wlo_vpl VALUES ("PS89_18","020_89_18","PSA","89","18","18","Ingkoo o kamuliana kakaana manga incia, tee roonamo kalapemu, ingkami tahandamo tamakaa. ");
INSERT INTO wlo_vpl VALUES ("PS89_19","020_89_19","PSA","89","19","19","Katangkesimami o pewauana KAWASANA OPU, siitumo o rajamami pewauana Aulataʼala Momangkilo isombana miana Israel. ");
INSERT INTO wlo_vpl VALUES ("PS89_20","020_89_20","PSA","89","20","20","I piamo itu, i nuncana pokamataana mia Ingkoo ufirimani i manga mia motaʼatiko, mboosii, \"Iaku padhamo kutulungi samia o mia mobarani, Iaku padhamo kupekalanga samia ipiliku minaaka i lipu sumai. ");
INSERT INTO wlo_vpl VALUES ("PS89_21","020_89_21","PSA","89","21","21","Iaku padhamo kupokawaaka Daud, o bhatuaku, tee padhamo kulantia tee mina hususuku momangkilo. ");
INSERT INTO wlo_vpl VALUES ("PS89_22","020_89_22","PSA","89","22","22","Limaku sadhaadhaa bheajagania, sampemo limaku uka bhekupekatangkaakea. ");
INSERT INTO wlo_vpl VALUES ("PS89_23","020_89_23","PSA","89","23","23","Musu inda bheamembali ahumbunia, tee inda bheapisakia mia madhaki. ");
INSERT INTO wlo_vpl VALUES ("PS89_24","020_89_24","PSA","89","24","24","Iaku bhekupahancuru manga bhalina i aroana, tee kupabinasa manga mia mobancia. ");
INSERT INTO wlo_vpl VALUES ("PS89_25","020_89_25","PSA","89","25","25","Pojanjiaku inda bheamabhotu tee kaasiku molagina bheapobhawa tee incia, tee roonamo saroku o bheajulu o kakaana. ");
INSERT INTO wlo_vpl VALUES ("PS89_26","020_89_26","PSA","89","26","26","Iaku bhekupamembali limana akuasai tawo, tee o lima kaanana akuasai manga umala. ");
INSERT INTO wlo_vpl VALUES ("PS89_27","020_89_27","PSA","89","27","27","Incia bheagora i Iaku, 'Ingkoomo o Amaku, Aulataʼalaku, tee gunu bhatu mopasalaamatiaku!' ");
INSERT INTO wlo_vpl VALUES ("PS89_28","020_89_28","PSA","89","28","28","Iaku uka bhekuangkea to amembali ana tumpeku, tee kupamembalia momalangana mpuu minaaka i bhari-bharia manga raja i dunia. ");
INSERT INTO wlo_vpl VALUES ("PS89_29","020_89_29","PSA","89","29","29","To saʼumurua bhekudhambaakea o kaasiku molagina to incia, tee o pojanjiaku tee incia bheasadhaadhaa amatangka. ");
INSERT INTO wlo_vpl VALUES ("PS89_30","020_89_30","PSA","89","30","30","Bhekupewaua o siwuluna adhaangia saʼumurua, tee o kauncuramakana bhekupotaangiakea kangengena laiana dhaangiapo i bhawona dunia. ");
INSERT INTO wlo_vpl VALUES ("PS89_31","020_89_31","PSA","89","31","31","Ande manga anana inda ataʼati tee hukumuku, tee o dhadhina inda aose tuturaku, ");
INSERT INTO wlo_vpl VALUES ("PS89_32","020_89_32","PSA","89","32","32","tee ande manga incia inda aose opea mopadhana ipatotapuakaku, tee inda aose manga parintaku, ");
INSERT INTO wlo_vpl VALUES ("PS89_33","020_89_33","PSA","89","33","33","sumaimo bhekuhukumua manga incia tee kasambina lauro, tee bhekubhebhea roonamo dosana manga incia. ");
INSERT INTO wlo_vpl VALUES ("PS89_34","020_89_34","PSA","89","34","34","Maka Iaku inda bhekubhotukia o kaasiku molagina to incia, tee inda bhekumalinguakea pojanjiaku inda momabhotu. ");
INSERT INTO wlo_vpl VALUES ("PS89_35","020_89_35","PSA","89","35","35","Iaku sadhaadhaa kupamondo pojanjiaku, tee opea mopadhana ifirimaniakaku inda bhekubhaliia. ");
INSERT INTO wlo_vpl VALUES ("PS89_36","020_89_36","PSA","89","36","36","Sampearo to saʼumurua Iaku kusumpa to kangkilona saroku, tee inda bhekugau-gau Daud. ");
INSERT INTO wlo_vpl VALUES ("PS89_37","020_89_37","PSA","89","37","37","Siwuluna bheadhaangia to saʼumurua, tee o kauncuramakana bheasadhaadhaa i aroaku mboomo matanaeo, ");
INSERT INTO wlo_vpl VALUES ("PS89_38","020_89_38","PSA","89","38","38","bheasadhaadhaa saʼumurua mboomo bula, mosakusiiakea minaaka i laiana.\" Sela ");
INSERT INTO wlo_vpl VALUES ("PS89_39","020_89_39","PSA","89","39","39","Maka sii-sii Ingkoo umendeua tee ubholia; Ingkoo upamuru tee mia mopadhana ilantimu. ");
INSERT INTO wlo_vpl VALUES ("PS89_40","020_89_40","PSA","89","40","40","Ingkoo ubhotuki janjimu tee bhatuamu, tee o mahakotana upekarombuakea tee ngawuna tana. ");
INSERT INTO wlo_vpl VALUES ("PS89_41","020_89_41","PSA","89","41","41","Upatobhatea bhari-bharia manga rindina kotana, tee upahancurua manga bentena. ");
INSERT INTO wlo_vpl VALUES ("PS89_42","020_89_42","PSA","89","42","42","Bhari-bharia mia molalo amanako pewauana; incia amembali giuna kaele-ele to manga sarimbanuana. ");
INSERT INTO wlo_vpl VALUES ("PS89_43","020_89_43","PSA","89","43","43","Ingkoo upekalanga lima kaanana manga bhalina, tee bhari-bharia musuna upewaua akaunde-unde. ");
INSERT INTO wlo_vpl VALUES ("PS89_44","020_89_44","PSA","89","44","44","Ingkoo uka upamembali matana ewangana rajamami inda akoampadhea, tee inda utulungia i nuncana potimbea. ");
INSERT INTO wlo_vpl VALUES ("PS89_45","020_89_45","PSA","89","45","45","Upauntoa o kuasana momuliana, tee o kauncuramakana utudhaakea i tana. ");
INSERT INTO wlo_vpl VALUES ("PS89_46","020_89_46","PSA","89","46","46","Upekampodhoa o umuruna rajamami wakutuuna amangura, tee usalibumbungiakea tee kaea. Sela ");
INSERT INTO wlo_vpl VALUES ("PS89_47","020_89_47","PSA","89","47","47","Sakawana naepia uka e KAWASANA OPU? Buaka bheubuniaka karomu saʼumurua? Sakawana naepia o pamurumu akarore-rore mboomo waa? ");
INSERT INTO wlo_vpl VALUES ("PS89_48","020_89_48","PSA","89","48","48","Udhania, tapanamo kampodho o dhadhiku sii, tapanamo sia-siana dhadhina bhari-bharia maanusia ipadhaangiamu! ");
INSERT INTO wlo_vpl VALUES ("PS89_49","020_89_49","PSA","89","49","49","Incema buaka o maanusia momembalina modhadhina torosu tee inda amate? Tee incema momembalina mopasalaamatina inyawana tee alapa minaaka i mate? Sela ");
INSERT INTO wlo_vpl VALUES ("PS89_50","020_89_50","PSA","89","50","50","E Kawasana Opu, i iapai o kaasimu molagina i piamo itu mopadhana ijanjiakamu to Daud tee katunda i nuncana pojanjiamu inda momabhotu? ");
INSERT INTO wlo_vpl VALUES ("PS89_51","020_89_51","PSA","89","51","51","E Kawasana Opu, udhania tuaapa o bhatuamu sii atohina; incaku atanggo kahinana bhari lipu. ");
INSERT INTO wlo_vpl VALUES ("PS89_52","020_89_52","PSA","89","52","52","Manga musumu ahina raja mopadhana ilantimu, e KAWASANA OPU, manga incia aele-elea iapaipo uka o lingkaana. ");
INSERT INTO wlo_vpl VALUES ("PS89_53","020_89_53","PSA","89","53","53","Pujimo KAWASANA OPU to saʼumurua! Aamin, ya aamin! ");
INSERT INTO wlo_vpl VALUES ("PS90_1","020_90_1","PSA","90","1","1","Doʼana Musa, bhatuana Aulataʼala. E Kawasana Opu, Ingkoomo tampamami tapeulu to saʼumurua. ");
INSERT INTO wlo_vpl VALUES ("PS90_2","020_90_2","PSA","90","2","2","Indapo manga gunu atopadhaangia, indapo alamu tee dunia sii upamembalia, Ingkoomo Aulataʼala mobakaa, inda tee auwalina inda tee aahirina. ");
INSERT INTO wlo_vpl VALUES ("PS90_3","020_90_3","PSA","90","3","3","Ingkoo ubhalii maanusia amembali ngawuna tana, firimanimu, \"Mbulimo i asalamu e anana maanusia.\" ");
INSERT INTO wlo_vpl VALUES ("PS90_4","020_90_4","PSA","90","4","4","I nuncana pokamatamu sarewu tao apokana mboomo eo iawi siimpo molapana, atawa mboomo sapalika jagaana malo. ");
INSERT INTO wlo_vpl VALUES ("PS90_5","020_90_5","PSA","90","5","5","Ingkoo upepadhai dhadhimami mboomo tapongipi, mboomo rumpu motuna saeona; ");
INSERT INTO wlo_vpl VALUES ("PS90_6","020_90_6","PSA","90","6","6","wakutuuna saeona o rumpu atuwu tee atuna, maka wakutuuna konowia amalau tee amatuu. ");
INSERT INTO wlo_vpl VALUES ("PS90_7","020_90_7","PSA","90","7","7","Sababuna ingkami tamofu roonamo amaramu, tee ingkami tatokidha roonamo pamurumu. ");
INSERT INTO wlo_vpl VALUES ("PS90_8","020_90_8","PSA","90","8","8","Manga kasalahamami udhikaia i aroamu tee o dosamami motobuniaka atokamata i nuncana caheana roumu. ");
INSERT INTO wlo_vpl VALUES ("PS90_9","020_90_9","PSA","90","9","9","Sababuna bhari-bharia eomami tanamisi pamurumu mokarore-rore, tee talaloi tao-taomami mboomo kadheina tapoinunca. ");
INSERT INTO wlo_vpl VALUES ("PS90_10","020_90_10","PSA","90","10","10","Kangengena dhadhimami tangkanamo pitu pulu tao, atawa ande amakaa o bukumami koroo akawa walu pulu tao, maka manga eo momalape mpuu ipotibhaakamami tangkanamo kasukara tee kanarakaa; dhadhimami amampodho tee amasimba, sapadhana sumai tamofumo. ");
INSERT INTO wlo_vpl VALUES ("PS90_11","020_90_11","PSA","90","11","11","Incema buaka momatauna kaogena amaramu? Pamurumu amaoge mpuu apokana mboomo mia amaekako. ");
INSERT INTO wlo_vpl VALUES ("PS90_12","020_90_12","PSA","90","12","12","Manga adharimo to tagagari eo-eomami momampodhona sii mamudhaakana ingkami tapotibhaaka o ngangaranda moʼaarifu. ");
INSERT INTO wlo_vpl VALUES ("PS90_13","020_90_13","PSA","90","13","13","E KAWASANA OPU, mbulimo. Sakawana naepia Ingkoo uʼamara? Maasiakapea manga bhatuamu. ");
INSERT INTO wlo_vpl VALUES ("PS90_14","020_90_14","PSA","90","14","14","Patumpua o incamami i wakutuuna saeona tee kaasimu molagina mamudhaakana ingkami tasambo-sambo tee takaunde-unde saʼumurua dhadhimami. ");
INSERT INTO wlo_vpl VALUES ("PS90_15","020_90_15","PSA","90","15","15","Pasanaaia o incamami, apokana mboomo upewau eo-eomami i piamo itu asukara, tee apokana tee tao-tao itanggomami wakutuuna tanamisi kanarakaa. ");
INSERT INTO wlo_vpl VALUES ("PS90_16","020_90_16","PSA","90","16","16","Taroakamo opea ipewaumu akamatea manga bhatuamu, tee o kuasamu momulia sumai akamatea anaanamami. ");
INSERT INTO wlo_vpl VALUES ("PS90_17","020_90_17","PSA","90","17","17","Taroakamo kabarakatina Kawasana Opu, Aulataʼalamami, dhaangia to ingkami. Pekatangkea o angkana limamami, mamudhaakana usahamami akohasili! ");
INSERT INTO wlo_vpl VALUES ("PS91_1","020_91_1","PSA","91","1","1","Mia modhadhina i nuncana kajaganina Aulataʼala Momalanga, bheamboore i nuncana peulusana Kawasana Opu Mokokuasa, ");
INSERT INTO wlo_vpl VALUES ("PS91_2","020_91_2","PSA","91","2","2","bheapogau i KAWASANA OPU, \"Ingkoomo o tampana peulusaku tee o bentena potaangiaku; Aulataʼalaku, iparacaeaku.\" ");
INSERT INTO wlo_vpl VALUES ("PS91_3","020_91_3","PSA","91","3","3","Incia bhemorambasakako minaaka i katapu, tee minaaka i panyaki imateaka. ");
INSERT INTO wlo_vpl VALUES ("PS91_4","020_91_4","PSA","91","4","4","Incia bheasalibumbungiakako tee panina, tee ingkoo bheuʼamani i nuncana peulusana. Incia atoparacaea tee bheamembali katangkesi tee o bentemu. ");
INSERT INTO wlo_vpl VALUES ("PS91_5","020_91_5","PSA","91","5","5","Ingkoo inda bheumaeka tee balaa moumbana i wakutuu malo, atawa o kahumbuni inda inamu-namu moumbana i wakutuu eo. ");
INSERT INTO wlo_vpl VALUES ("PS91_6","020_91_6","PSA","91","6","6","Ingkoo inda bheumaeaka tee panyaki imateaka moumbana i nuncana kalalanda, atawa tee kalelei ibinasaaka moumbana i wakutuu pontanga eo. ");
INSERT INTO wlo_vpl VALUES ("PS91_7","020_91_7","PSA","91","7","7","Moomini sarewu mia amate i saripimu, tee sapulu rewu mia amate i weta i kaanamu, maka ingkoo inda bheucilaka. ");
INSERT INTO wlo_vpl VALUES ("PS91_8","020_91_8","PSA","91","8","8","Ingkoo tangkanamo bheutontoa tee matamu karomu, tee ukamatea tuaapa Aulataʼala bheahukumu mia madhaki. ");
INSERT INTO wlo_vpl VALUES ("PS91_9","020_91_9","PSA","91","9","9","Roonamo KAWASANA OPU upamembalia tampana peulusamu, tee Aulataʼala Momalanga upamembalia mbooresamu, ");
INSERT INTO wlo_vpl VALUES ("PS91_10","020_91_10","PSA","91","10","10","siitumo ingkoo inda bheucilaka, tee balaa bheamaridho minaaka i bhanuamu. ");
INSERT INTO wlo_vpl VALUES ("PS91_11","020_91_11","PSA","91","11","11","Roonamo Incia bheatumpu manga malaaʼekatina to apobhawa tee ingkoo, mamudhaakana ajaganiko iapaipo uka o lingkaamu. ");
INSERT INTO wlo_vpl VALUES ("PS91_12","020_91_12","PSA","91","12","12","Manga malaaʼekati sumai bheaangkako tee rua mbalia limana mamudhaakana o aemu inda atosunu i bhatu. ");
INSERT INTO wlo_vpl VALUES ("PS91_13","020_91_13","PSA","91","13","13","Singa tee ulo bheulempagia, singa mangura tee ulo mokobisa bheulanda-landakia. ");
INSERT INTO wlo_vpl VALUES ("PS91_14","020_91_14","PSA","91","14","14","Firimanina Kawasana Opu, \"Roonamo manga mia momaasiakaaku, bhekupasalaamatia; tee Iaku bhekujagani manga mia momatauna saroku. ");
INSERT INTO wlo_vpl VALUES ("PS91_15","020_91_15","PSA","91","15","15","Wakutuuna manga incia agoraakaaku, siitumo Iaku bhekulawania; Iaku bhekupobhawa tee manga incia i nuncana kaseke, tee bhekupasalaamatia tee kumuliangia. ");
INSERT INTO wlo_vpl VALUES ("PS91_16","020_91_16","PSA","91","16","16","Tee umuru marambe bhekupatumpua incana, tee bhekususuakea ande Iaku bhemopasalaamatia.\" ");
INSERT INTO wlo_vpl VALUES ("PS92_1","020_92_1","PSA","92","1","1","Zaburuna saangu lagu to eona Saputuu. ");
INSERT INTO wlo_vpl VALUES ("PS92_2","020_92_2","PSA","92","2","2","Tapanamo kalape tasukuru i KAWASANA OPU tee talaguaka manga lagu kapujia to saromu, e KAWASANA OPU Momalanga; ");
INSERT INTO wlo_vpl VALUES ("PS92_3","020_92_3","PSA","92","3","3","to tapakoleleaka kaasimu molagina i wakutuu saeona tee tuaapa Ingkoo ukeniaka pojanjiamu inda momabhotu i wakutuu malo, ");
INSERT INTO wlo_vpl VALUES ("PS92_4","020_92_4","PSA","92","4","4","poose tatiki gitari sapulu taliana, tee taoseakea gambusu tee kecapi. ");
INSERT INTO wlo_vpl VALUES ("PS92_5","020_92_5","PSA","92","5","5","Roonamo Ingkoo, e KAWASANA OPU, upaunde-undeaku tee opea mopadhana ipewaumu; iaku kusambo-sambo tee opea mopadhana ikarajaamu. ");
INSERT INTO wlo_vpl VALUES ("PS92_6","020_92_6","PSA","92","6","6","Amaoge mpuu bhari-bharia ipewaumu, e KAWASANA OPU, amandala mpuu o fikirimu tee amarasai to tamaʼanaia! ");
INSERT INTO wlo_vpl VALUES ("PS92_7","020_92_7","PSA","92","7","7","Mia mokabhongo-bhongo inda bheamembali amataua, mia mokurana fikirina inda bheamaʼanaia o giu incia sumai: ");
INSERT INTO wlo_vpl VALUES ("PS92_8","020_92_8","PSA","92","8","8","Moomini manga mia madhaki atuwu mboomo rumpu, tee o mia madhaki ahandamo abhari, maka manga incia sadhaadhaa bheatopabinasa saʼumurua. ");
INSERT INTO wlo_vpl VALUES ("PS92_9","020_92_9","PSA","92","9","9","Maka Ingkoo i tampa momalanga saʼumurua e KAWASANA OPU. ");
INSERT INTO wlo_vpl VALUES ("PS92_10","020_92_10","PSA","92","10","10","Roonamo manga musumu, e KAWASANA OPU, roonamo manga musumu bheabinasa; tee bhari-bharia mia madhaki bheupapogaa-gaaia. ");
INSERT INTO wlo_vpl VALUES ("PS92_11","020_92_11","PSA","92","11","11","Maka upamembaliaku kumakaa mboomo karambau, tee ulaliakaaku mina bhaau to ubarakatiaku. ");
INSERT INTO wlo_vpl VALUES ("PS92_12","020_92_12","PSA","92","12","12","Mataku akamatamo kandawuna manga musuku, tee o talingaku arangomo katalona manga mia madhaki mobhaliaku. ");
INSERT INTO wlo_vpl VALUES ("PS92_13","020_92_13","PSA","92","13","13","Mia mobanara bheatuwu tee akobhake torosu mboomo puuna horomaa, tee incia bheamaoge mboomo puuna aras i Libanon. ");
INSERT INTO wlo_vpl VALUES ("PS92_14","020_92_14","PSA","92","14","14","Manga incia mboomo puuna kau ipombula i aroana Bhanuana KAWASANA OPU, tee ajulu o kaogena i aroana Bhanuana Aulataʼalata. ");
INSERT INTO wlo_vpl VALUES ("PS92_15","020_92_15","PSA","92","15","15","Moomini akoʼumurumo dhaangiapo uka akobhake, tee asadhaadhaa asuburu tee amaijo o tawana, ");
INSERT INTO wlo_vpl VALUES ("PS92_16","020_92_16","PSA","92","16","16","manga miana mobanara sumai apakoleleaka ande o KAWASANA OPU sumai abanara. Incia o gunu bhatuku, tee sadia apewau moʼadili. ");
INSERT INTO wlo_vpl VALUES ("PS93_1","020_93_1","PSA","93","1","1","KAWASANA OPU o Raja, Incia abukeaka kamuliangi! KAWASANA OPU abukeaka kuasa, tee apatokamata kakaana. Incia apakakaro dunia tee inda dhaangia momembalina mohudhalia. ");
INSERT INTO wlo_vpl VALUES ("PS93_2","020_93_2","PSA","93","2","2","Kauncuramakamu amatangka minaaka i zamani mangenge, tee Ingkoo udhaangiamo minaaka i dunia indapo dhaangia. ");
INSERT INTO wlo_vpl VALUES ("PS93_3","020_93_3","PSA","93","3","3","Manga umala mokalua-lua ahandamo apekaoge suarana, e KAWASANA OPU, manga umala mokalua-lua ahandamo apekaoge suarana, manga umala mokalua-lua ahandamo apekaoge ruuna ewona. ");
INSERT INTO wlo_vpl VALUES ("PS93_4","020_93_4","PSA","93","4","4","Maka minaaka i suarana uwe momaoge, tee minaaka i ewona tawo momakaa, alabhi amaoge KAWASANA OPU i tampa momalanga. ");
INSERT INTO wlo_vpl VALUES ("PS93_5","020_93_5","PSA","93","5","5","E KAWASANA OPU, hukumumu abakaa saʼumurua, Kangkilo alaenga i nuncana Bhanuamu saʼumurua zamani. ");
INSERT INTO wlo_vpl VALUES ("PS94_1","020_94_1","PSA","94","1","1","E Aulataʼala, Ingkoomo KAWASANA OPU mobalasina kadhaki. Potokamatamea ande Ingkoo mobalasina kadhaki, e Aulataʼala! ");
INSERT INTO wlo_vpl VALUES ("PS94_2","020_94_2","PSA","94","2","2","Maasangia ahukumua, e haakimuna dunia; hukumua manga mia mosombo apokana tee pewauna! ");
INSERT INTO wlo_vpl VALUES ("PS94_3","020_94_3","PSA","94","3","3","Sakawana naepia manga mia madhaki, e KAWASANA OPU, sakawana naepia, manga mia madhaki akaunde-unde? ");
INSERT INTO wlo_vpl VALUES ("PS94_4","020_94_4","PSA","94","4","4","Manga incia ataburaka pogau mosombo minaaka i ngangana, tee bhari-bharia mia mopewauna kadhaki sumai apekalanga karona. ");
INSERT INTO wlo_vpl VALUES ("PS94_5","020_94_5","PSA","94","5","5","Manga incia apisaki uumatimu, e KAWASANA OPU, tee apahancuru tinaurakamu. ");
INSERT INTO wlo_vpl VALUES ("PS94_6","020_94_6","PSA","94","6","6","Manga incia apekamate iaiaro tee mia dhaga, tee apekamate ana maelu. ");
INSERT INTO wlo_vpl VALUES ("PS94_7","020_94_7","PSA","94","7","7","Pogauna manga incia, \"KAWASANA OPU inda akamatea, Aulataʼalana Yakub isombana miana Israel inda atontoa.\" ");
INSERT INTO wlo_vpl VALUES ("PS94_8","020_94_8","PSA","94","8","8","Perangoimea, e manga mia mokabhongo-bhongo i tanga-tangana lipu sii! E manga mia mokabhongo-bhongo, naepia buaka ingkomiu bheumembali uʼaarifu? ");
INSERT INTO wlo_vpl VALUES ("PS94_9","020_94_9","PSA","94","9","9","Incia modhikaakea talinga, inda mungki Incia inda aporango! Incia mopamodelena mata, inda mungki Incia inda apokamata! ");
INSERT INTO wlo_vpl VALUES ("PS94_10","020_94_10","PSA","94","10","10","Incia mosasina manga lipu tee moadharina maanusia, dhaanamo Incia bheahukumua uka! ");
INSERT INTO wlo_vpl VALUES ("PS94_11","020_94_11","PSA","94","11","11","KAWASANA OPU amataua haejatina maanusia, ande bhari-bharia sumai inda tee maʼanana. ");
INSERT INTO wlo_vpl VALUES ("PS94_12","020_94_12","PSA","94","12","12","Masanaamo mia iadharimu, e KAWASANA OPU, tee udhawua kaadhari minaaka i hukumumu; ");
INSERT INTO wlo_vpl VALUES ("PS94_13","020_94_13","PSA","94","13","13","upasanaa incana i wakutuuna kasukara, sakawana mia madhaki apesua i nuncana bhalona katapu. ");
INSERT INTO wlo_vpl VALUES ("PS94_14","020_94_14","PSA","94","14","14","Roonamo KAWASANA OPU inda bheabhanaka uumatina, tee Incia inda bheabholi miana lipuna momembalina tinaurakana; ");
INSERT INTO wlo_vpl VALUES ("PS94_15","020_94_15","PSA","94","15","15","sababuna kaʼadili bheambuli pendua to manga mia mobanara, tee bhari-bharia mia momakatena incana bheaose. ");
INSERT INTO wlo_vpl VALUES ("PS94_16","020_94_16","PSA","94","16","16","Incema buaka moewaakaaku i manga mia madhaki? Incema buaka bhemopoaroakaaku to aewangi manga mia mopewauna kadhaki? ");
INSERT INTO wlo_vpl VALUES ("PS94_17","020_94_17","PSA","94","17","17","Ande mencuana KAWASANA OPU motulungiaku, saidhepo kumate i tampa momalino. ");
INSERT INTO wlo_vpl VALUES ("PS94_18","020_94_18","PSA","94","18","18","Wakutuuna kufikiri, \"Aeku asindoli,\" sumaimo kaasina KAWASANA OPU molagina motukoaku. ");
INSERT INTO wlo_vpl VALUES ("PS94_19","020_94_19","PSA","94","19","19","Wakutuuna abhari fikiriku i nuncana baatiniku, Ingkoo utautauaku, sumaimo kukaunde-unde. ");
INSERT INTO wlo_vpl VALUES ("PS94_20","020_94_20","PSA","94","20","20","Inda mungki Ingkoo uposaangu tee manga kaogesa momadhaki, mopewauna kasalaha alaloi katotapuna inda moʼadilina. ");
INSERT INTO wlo_vpl VALUES ("PS94_21","020_94_21","PSA","94","21","21","Manga incia apomufakati aewangi dhadhina mia mobanara, tee ahukumu mate manga mia inda mosala. ");
INSERT INTO wlo_vpl VALUES ("PS94_22","020_94_22","PSA","94","22","22","Maka KAWASANA OPU mboomo kota bente moewaakaaku, tee Aulataʼala amembali gunu bhatu tampana peulusaku. ");
INSERT INTO wlo_vpl VALUES ("PS94_23","020_94_23","PSA","94","23","23","Incia bheahukumu manga mia madhaki apokana tee pewauna, tee bheapabinasea roonamo dosana. KAWASANA OPU, Aulataʼalata bheapabinasa manga incia. ");
INSERT INTO wlo_vpl VALUES ("PS95_1","020_95_1","PSA","95","1","1","Mai tasambo-samboaka to KAWASANA OPU! Mai tasambo-sambo tee takaunde-unde to gunu bhatu kasalaamatita! ");
INSERT INTO wlo_vpl VALUES ("PS95_2","020_95_2","PSA","95","2","2","Mai tapoaro i aroana tee taemani sukuru, tee tasambo-sambo to Incia tee talaguakea lagu kapujia! ");
INSERT INTO wlo_vpl VALUES ("PS95_3","020_95_3","PSA","95","3","3","Roonamo KAWASANA OPU o Aulataʼala momaoge, tee Incia o Raja momaoge mokuasaina bhari-bharia dewa. ");
INSERT INTO wlo_vpl VALUES ("PS95_4","020_95_4","PSA","95","4","4","Manga tampa momandala mpuu i alamu adhaangia i nuncana limana, tee manga lolona gunu uka o pewauana. ");
INSERT INTO wlo_vpl VALUES ("PS95_5","020_95_5","PSA","95","5","5","Incia mokuasaina tawo, roonamo Incia mopadhaangiaia, tee ati uka, o angkana limana. ");
INSERT INTO wlo_vpl VALUES ("PS95_6","020_95_6","PSA","95","6","6","Mai tasuju tasomba Incia, tasuju i aroana KAWASANA OPU mopadhaangiana ingkita. ");
INSERT INTO wlo_vpl VALUES ("PS95_7","020_95_7","PSA","95","7","7","Roonamo Inciamo o Aulataʼalata, tee ingkita o uumati idhambaakana, tee o gulumana dumba igembalaakana limana. Eo sii ande urango suarana, ");
INSERT INTO wlo_vpl VALUES ("PS95_8","020_95_8","PSA","95","8","8","bholimo umentagali mboomo i Meriba, tee mboomo wakutuuna i Masa, i tana matuu, ");
INSERT INTO wlo_vpl VALUES ("PS95_9","020_95_9","PSA","95","9","9","wakutuuna o opu-opuamiu acobaiaku tee aujiaku moomini manga incia padhamo akamata opea ikarajaaku. ");
INSERT INTO wlo_vpl VALUES ("PS95_10","020_95_10","PSA","95","10","10","Pata pulu tao o kangengena kumarika manga mia incia sumai. Firimaniku, \"Manga incia o lipu mosaladhala, tee inda aose parintaku.\" ");
INSERT INTO wlo_vpl VALUES ("PS95_11","020_95_11","PSA","95","11","11","Rampaakanamo sumai, Iaku kupotunda i nuncana pamuruku, \"Manga incia inda bheapesua i tampana poniuntoa mopadhana ijanjiakaku to manga incia, siitumo i Kanaan.\" ");
INSERT INTO wlo_vpl VALUES ("PS96_1","020_96_1","PSA","96","1","1","Laguakamo lagu bhaau to KAWASANA OPU, Lagumo to KAWASANA OPU, e saangua dunia! ");
INSERT INTO wlo_vpl VALUES ("PS96_2","020_96_2","PSA","96","2","2","Lagumo to KAWASANA OPU tee upujimo sarona! Pakoleleakea saesaeo o kasalaamati minaaka i Incia. ");
INSERT INTO wlo_vpl VALUES ("PS96_3","020_96_3","PSA","96","3","3","Petulatulaakea o kamuliangina i tanga-tangana manga lipu, tee upetulatulaakea manga pewauna inda momentela i bhari-bharia uumatina maanusia. ");
INSERT INTO wlo_vpl VALUES ("PS96_4","020_96_4","PSA","96","4","4","Sababuna o KAWASANA OPU amaoge tee atopuji mpuu. Incia alaenga atomaeka alabhi minaaka i bhari-bharia dewa. ");
INSERT INTO wlo_vpl VA