﻿USE sofia;
DROP TABLE IF EXISTS sofia.wja_vpl;
CREATE TABLE wja_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES wja_vpl WRITE;
INSERT INTO wja_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","21Ti̱na ku̱ci̱ kakaa Yesu Masiya wa, wu twii kaka Dawud, wu yo̱o̱gi̱ kaka Ibrahim. ");
INSERT INTO wja_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ibrahim twii mbaa Icaku, Icaku mbaa Yakubu, Yakubu mbaa Yahuda yi̱ ci̱yamba ya, ");
INSERT INTO wja_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yahuda mbaa Perisa yi̱ Serah wu njaa pmo wii Tamar, Perisa mbaa Esruna, Esruna mbaa Aram. ");
INSERT INTO wja_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram mbaa Amminadab, Amminadab mbaa Nacon, Nacon mbaa Salmon, ");
INSERT INTO wja_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon mbaa Boasa wu njaa yo̱ wii Rahab, Boasa mbaa Obed wu njaa yo̱ wii Rut, Obed mbaa Jesse, ");
INSERT INTO wja_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesse mbaa balaa Dawud. Dawud twii mbaa Solomon, wu njaa yo̱ nang twii nu̱re̱ Uriya, ");
INSERT INTO wja_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon mbaa Rehoboam, Rehoboam mbaa Abija, Abija mbaa Asa, ");
INSERT INTO wja_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa mbaa Jehocapat, Jehocapat mbaa Joram, Joram mbaa, Ussiya, ");
INSERT INTO wja_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ussiya mbaa Jotam, Jotam mbaa Ahas, Ahas mbaa Hesekiya, ");
INSERT INTO wja_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekiya mbaa Manassa, Manassa mbaa Amon, Amon mbaa Josiya ");
INSERT INTO wja_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiya mbaa Jekoniya yi̱ ci̱yamba ya, a jo̱r du nu̱wa ku̱ra pma ke̱wu̱ri̱ Babila. ");
INSERT INTO wja_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Go̱ro̱ ke̱wu̱ri̱ pmai a Babila, Jekoniya mbaa Ceyaltiyal, Ceyaltiyal mbaa, Serubabel, ");
INSERT INTO wja_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabel mbaa Abiud, Abiud mbaa Eliyakim, Eliyakim mbaa Asor, ");
INSERT INTO wja_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asor mbaa Sadok, Sadok mbaa Acim, Acim mbaa Eliyud, ");
INSERT INTO wja_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyud mbaa Eliyasar, Eliyasar mbaa Matan, Matan mbaa Yakubu, ");
INSERT INTO wja_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakubu mbaa Yusupu bwi̱ya Maryamu, wu bi Yesu wu nu̱wa yi̱ri̱ ki̱n Masiya. ");
INSERT INTO wja_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Di̱ngi̱n to̱no̱ toso bo̱nggo̱ Ibrahim be̱e̱ bo̱nggo̱ Dawud twii kakaa kwap su̱r ni̱i̱, pero toso bo̱nggo̱ Dawud be̱e̱ jo̱r du mwatanga Babila twii kakaa kwap su̱r ni̱i̱, pero toso jo̱r mwatangu Babila be̱e̱ jo̱r Masiya twii kakaa kwap su̱r ni̱i̱. ");
INSERT INTO wja_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ti̱na nyinou wu nu̱wa bi Yesu Masiya. Njaa yo̱ Maryam ni̱nga le̱e̱ngi̱ laabwiya yi̱ Yusupu, pu bo̱o̱ de̱ bu yo̱ a nyi̱ngga wo̱o̱ yi̱ rwii a bo̱nggo̱ Bawei du Walwal. ");
INSERT INTO wja_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Anda Yusupu twii ne̱re̱ wu nyaa yaa kasi̱ ba dwiiyanga yo̱ me̱lma cu̱du̱ nu̱wai̱, a kasa ba man yo̱ tukugi. ");
INSERT INTO wja_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Anda pu wo̱o̱ danggu̱ yi̱to̱, bacama Mbaa Wu Gi̱ra a bammanu̱we̱ yo̱ a mi̱ri̱nggi̱ dweendi ki̱n, <<Yusupu bo̱l Dawud, nu̱u̱ yaa gwasi̱ de̱gu̱ Maryam ba yo̱o̱ nu̱re̱ mo̱, di̱ngi̱n tu mi̱ri̱nggi̱ pwii ye̱i̱ to̱o̱ a baa bo̱nggo̱ Bawei du Walwal. ");
INSERT INTO wja_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Yo̱ biru we̱i̱ bwi̱ya, ma je̱e̱ ru we̱i̱ din mi̱n Yesu, di̱ngi̱n yo̱ mi̱ru̱ we̱i̱ nu̱wa ya bo̱nggo̱ we̱le̱mdi̱ pmai.>> ");
INSERT INTO wja_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Mwa mwa to̱o̱ a ni̱ngwa palaka ba twanga tu Mbaa Wu Gi̱ra ce̱ a bo̱nggo̱ banabi̱ ki̱n, ");
INSERT INTO wja_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","<<Bwe̱e̱canga ni̱ng we̱i̱ rwii, pero biru we̱i̱ bwi̱ya, nu̱wa yi̱ri̱ we̱i̱ din ye̱i̱ ki̱n Immanuwel,>> pi̱ti̱ndi̱ ye̱i̱ ki̱n, <<Yamba wo̱o̱ kem yi̱ yo.>> ");
INSERT INTO wja_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Pu Yusupu romwa, a ni̱nga tu bacama Mbaa Wu Gi̱ra sa yo̱, a de̱e̱ Maryam ba yo̱ nu̱re̱ yo̱. ");
INSERT INTO wja_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Anda yaa ku daa yi̱ yo̱, ko̱po̱ jo̱r du bi bo̱l ye̱i̱. Pero a je̱e̱ din ki̱n Yesu. ");
INSERT INTO wja_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Go̱ro̱ pu nu̱wa bi Yesu a Baitalami a si̱ma Yudaya wa a jo̱r du Balaa Hiridus je̱e̱gi̱ lau̱, nu̱wa bu kangga twiyongo do̱no̱me̱ bu so̱m yi̱ri̱ngi̱ a dwii bajwari a baanga Wurcalima ");
INSERT INTO wja_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","a pi̱ra ki̱n, <<Pu nu̱wa bi balaa wu nu̱wa bu Yudaya wa a pi̱i̱yau̱? Yi ko̱ bajwali̱ yo̱ a do̱no̱me̱ yi̱ baanga di̱ngi̱n yi ku̱raman yo̱ si̱ma.>> ");
INSERT INTO wja_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Pu balaa Hiridus nu̱wa yi̱to̱, gaanggu̱ yo̱u̱ bwi̱i̱wa kem yi̱ nu̱wa bu Wurcalima wa mwa mwa. ");
INSERT INTO wja_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","A yi̱we̱ bagi̱raa kuruwa wa yi̱ ku̱lu̱mba te̱e̱ri̱ngi̱ wa, a pi̱ra pma pu nu̱wa bi̱ru̱ we̱i̱ Masiya. ");
INSERT INTO wja_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Pma le̱e̱man yo̱ ki̱n, <<A Baitalami si̱ma Yudaya wa, di̱ngi̱n ti̱na tu balgi̱ mi̱ri̱nggi̱ lakargar banabi̱ ki̱n,>> ");
INSERT INTO wja_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","<<Anda mo̱ Baitalami bu si̱ma Yahuda wa, ma yaa yo̱o̱gi̱ wu banyi̱na mi̱ri̱nggi̱ lau̱ri̱ tu Yahuda, a mi̱ri̱nggi̱ mai balaa twiiwe we̱i̱, wu yo̱o̱ we̱i̱ taage̱ nu̱wa muwa Israila.>> ");
INSERT INTO wja_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Anda Hiridus yi̱we̱ ku̱lu̱mba bwii tukugi ba pi̱ra jo̱r du bajwale wii twiiwe. ");
INSERT INTO wja_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","A tu̱m pma Baitalami a sa pma ki̱n, <<Ambi̱ra bu kasa pu nu̱wa bi bwi̱ya wii. Ka bu nyi̱nggi̱ ba bu sangge̱ palaka mi mwa n angge̱ n ku̱raman yo̱ si̱ma.>> ");
INSERT INTO wja_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Go̱ro̱ pu pma nu̱u̱ balaau, pma taa nyinou, bajwale wu pma ko̱ a do̱no̱me̱ wii a so̱ngma gawu̱r pmai ba ti̱n ti̱yei̱ pu nu̱wa bi bwi̱ya wii. ");
INSERT INTO wja_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Pu pma ko̱ bajwale wii pma twangwa yi̱ bu̱ri̱ de̱gde̱g. ");
INSERT INTO wja_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Pma teendo laa wii a ko̱ bwi̱ya wii kem yi̱ njaa yo̱ Maryam, anda pma kundi kwiyei ku̱raman yo̱ si̱ma. Pero pma pe̱ra swari̱ndi̱ pmai a nyi̱i̱ ni̱i̱ sinariya yi̱ tu̱rale̱ wu teng yi̱ nyinou ku nu̱wa yi̱ri̱ ki̱n mirr. ");
INSERT INTO wja_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Nu̱wa ni̱ngaman pma di̱kace̱ne̱ a mi̱ri̱nggi̱ dweendi ba po̱ng yaa bo̱nggo̱ Hiridus, pma po̱ng nyinou wu kanggu̱ a waatanga bu̱ri̱ si̱ma pma. ");
INSERT INTO wja_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Pu pma mwatangu, bacama Mbaa Wu Gi̱ra baa bo̱nggo̱ Yusupu mi̱ri̱nggu̱ dweendi, a se̱e̱ ki̱n. <<Wuni ma de̱ bwi̱ya wo̱o̱ kem yi̱ njaa yo̱ ma amna Masar. Ma si̱n si̱ye̱i̱ pwii ko̱po̱ jo̱r du sa mi̱nai̱, di̱ngi̱n Hiridus kasi̱ we̱i̱ bwi̱ya wo̱o̱ ba ji yo̱.>> ");
INSERT INTO wja_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Bur a wuni a de̱ bwi̱ya wii yi̱ njaa yo̱ yi̱ ku̱m wii a mwati̱ Masar, ");
INSERT INTO wja_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","a si̱n si̱ye̱i̱ pwii ko̱po̱ jo̱r du Hiridus bwaa. A ni̱ngwa yi̱to̱ palaka ba twanga tu Mbaa Wu Gi̱ra a ce̱ nyan banabi̱ ki̱n, <<N yi̱we̱ bo̱l mi a Masar.>> ");
INSERT INTO wja_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Pu Hiridus ku̱ranga ku̱lu̱mba bwii we̱le̱nga yo̱, a suko kwang kwang, a diina nu̱wa ba laca bako̱r nambi̱rmba bu Baitalami yi̱ go̱ro̱ndi̱ tu wo̱ri̱gi̱ yo̱ bu mi̱la ro̱p yi̱ bu mi̱ldi̱ pmai dwalna wa, cu̱u̱ngi̱ jo̱r du ku̱lu̱mba sa yo̱ labar wii. ");
INSERT INTO wja_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","A jo̱r dwii yi̱ri̱ tu banabi̱ Irmiya ce̱i̱ a twangwa. ");
INSERT INTO wja_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","<<Nu̱wa nu̱u̱ miu a Rama, wiindi yi̱ bwiyang gaanggu̱ wang Rahila wiindi di̱ngi̱n kwaraa ya a kwaa ki̱n nu̱wa ba do̱ro̱mi̱ni̱ ya di̱ngi̱n pma yaa me̱re̱.>> ");
INSERT INTO wja_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Go̱ro̱ pu Hiridus bwaa bacama Mbaa Wu Gi̱ra bammanu̱we̱ Yusupu mi̱ri̱nggi̱ dweendi a Masar ");
INSERT INTO wja_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","a ce̱ ki̱n, <<Wuni ma de̱ bwi̱ya wo̱o̱ kem yi̱ njaa yo̱, ma amna si̱ma Israila, di̱ngi̱n nu̱wa bu kasi̱gu̱ jigu bwi̱ya wo̱o̱ wa, a bwaanga.>> ");
INSERT INTO wja_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Di̱ngi̱n to̱no̱ a wuni, a de̱ bwi̱ya wii kem yi̱ njaa yo̱ a aara si̱ma Israila. ");
INSERT INTO wja_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Anda ku nu̱wa ki̱n Arkilawus je̱e̱gi̱ lau̱ a Yudaya a candu̱ mbaa yo̱ Hiridus, a nu̱u̱ gwasi̱ ba aara pwii. A aara si̱ma Galili yake̱ ku nu̱wa ni̱ngaman yo̱ di̱kace̱ne̱ a dwe̱e̱ndi̱. ");
INSERT INTO wja_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Anda a aara si̱n si̱ye̱i̱ a gwe̱i̱ du nu̱wa yi̱ri̱ ki̱n Nasaret. To̱o̱ a ni̱ngwa yi̱to̱ di̱ngi̱n ba twanga tu banabi̱ndi̱ ce̱ ki̱n, <<Nu̱wa yi̱ru̱ we̱i̱ ki̱n Nasarin.>> ");
INSERT INTO wja_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","A swii daandi Yohanna wu Ni̱ngi̱ Bati̱si̱ma a baa, a wasi̱gu̱ ci̱ye̱i̱ a gu̱lai̱ Yudaya, ");
INSERT INTO wja_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","a ce̱gu̱ ki̱n, <<Bu ni̱nga bwiiwa bo̱nggo̱ we̱le̱mdi̱ mbi̱ri̱, di̱ngi̱n lau̱ ku diyou a ni̱nga ne̱m.>> ");
INSERT INTO wja_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yohanna wii yo̱ wu banabi̱ Icaya ce̱ ci̱ye̱i̱ a dwii ye̱i̱, pu ce̱ ki̱n, <<Miu ku yi̱gu̱ yi̱ru̱ a mi̱ri̱nggi̱ gu̱lai̱, Bu carman nyinou Mbaa Wu Gi̱ra, Bu cu̱rman nyindi ye̱i̱ te̱k!>> ");
INSERT INTO wja_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Se̱e̱ Yohanna me̱ne̱nggi̱ yi̱ ku̱ri̱ nggelai, bo̱gi̱ pi̱i̱ yi̱ bi̱yau̱, je̱e̱ndi̱ ye̱i̱ twii juwai yi̱ niyari. ");
INSERT INTO wja_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Nu̱wa tum a twiyongo Wurcalima, yi̱ Yudaya, yi̱ go̱ro̱ndi̱ mwa mwa tu ne̱m yi̱ you ku Urdun a aanda bo̱nggo̱ yo̱u̱. ");
INSERT INTO wja_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Pma ni̱nggu̱ bwiiwa bo̱nggo̱ we̱le̱mdi̱ pmai, a ni̱ngaman pma bati̱si̱ma a you Urdun. ");
INSERT INTO wja_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Pu Yohanna ko̱ Parisayo yi̱ Sadukayo bagu̱ bo̱nggo̱ yo̱u̱ di̱ngi̱n ba ni̱ngaman pma bati̱si̱ma, a sa pma ki̱n, <<Mba co̱o̱gi̱ndi̱ su bwi̱i̱ wu sambi̱ra ki̱n bu cembir bal Yambai̱ su so̱o̱ baa we̱?>> ");
INSERT INTO wja_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Bu ni̱nga ni̱ngandi̱ tu ju̱ku̱ru̱ we̱i̱ ki̱n bu ni̱nga bwiiwa a bo̱nggo̱ we̱le̱mdi̱ mbi̱ri̱. ");
INSERT INTO wja_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Anda bu danggi̱ ya a gaanggu̱ mbi̱ru̱ mi̱n Ibrahim twii mbaa mbi̱re̱. N wo̱o̱ sagu̱mbi̱ru̱ Yamba wo̱o̱ yi̱ di̱mbi̱re̱ ba waata swari̱ngi̱ ti̱na ba yo̱ kwaraa Ibrahim! ");
INSERT INTO wja_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Nu̱wa gi̱ci̱la ce̱nni̱ nyan cunau a pi̱i̱ sou, kana ko̱no̱ sou ku twiya bu tutwiyari tu nyaayi bu̱ri̱ nu̱wa ba kaca ba manna bwalau. ");
INSERT INTO wja_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","<<N ni̱ngambi̱ri̱ bati̱si̱ma yi̱ gundu ba ju̱ku̱ya ki̱n bu ni̱nga bwiiwa, anda wu kangge̱ wo̱o̱ baa go̱ro̱ mu ni̱nga mbi̱ru̱ we̱i̱ bati̱si̱ma yi̱ Bawei du Walwal yi̱ bwalau. Yo̱ gwalangge̱ yi̱ gi̱ru̱, n yinnibu kana paari̱ ye̱i̱ n de̱. ");
INSERT INTO wja_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Yo̱ tagi̱ kaa te̱na yo̱ ye̱tu̱ we̱i̱ jama ya, pero ba ku̱ranga go̱ma ya, ba te̱na bindou yo̱u̱, anda taaru we̱i̱ pudi ye̱i̱ yi̱ bwalau ku̱ yaa dumdu.>> ");
INSERT INTO wja_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","A dwii jo̱re̱ Yesu du̱we̱ si̱ma Galili a baa you Urdun di̱ngi̱n Yohanna ba ni̱ngaman yo̱ bati̱si̱ma. ");
INSERT INTO wja_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Anda Yohanna kwaa, a se̱e̱ ki̱n, <<A daaya mo̱, ma ni̱ngangi̱n bati̱si̱ma, di̱ngi̱n ca ma bagu̱ bo̱nggo̱ mu?>> ");
INSERT INTO wja_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yesu le̱e̱man yo̱ ki̱n, <<Yama ba ni̱ngwa yi̱to̱. Di̱ngi̱n tagi̱ yi twanga tu Yamba kasi̱.>> Bur Yohanna a le̱e̱. ");
INSERT INTO wja_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Pu nu̱wa ni̱ngaman Yesu bati̱si̱ma, twiigu gundu kwii, ki̱nangu̱, bur diyou wum bu̱ri̱, a ko̱ Bawei Yambai̱ julomanuwe ci̱ka bamolo a ti̱na dwii ye̱i̱. ");
INSERT INTO wja_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Bur miu twiiwe diyou ki̱n, <<Ma Bo̱l mi, wu n kangne̱, n ni̱ngi̱ bu̱ri̱ de̱gde̱g yi̱ mo̱.>> ");
INSERT INTO wja_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","A dwii jo̱re̱ Bawei du Walwal a de̱ Yesu gu̱lai̱ palaka Balaa Buwai ba cu̱u̱ yo̱. ");
INSERT INTO wja_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Go̱ro̱ pu ni̱nga daa kun ni̱i̱ ku̱me̱ yi̱ nyanggu̱ yaa tu je̱i̱, Yesu nu̱u̱ ju̱ne̱. ");
INSERT INTO wja_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Bur Balaa Buwai baa bo̱nggo̱ yo̱u̱ a se̱e̱ ki̱n, <<Ka ma yo̱o̱gi̱ Bo̱l Yamba we̱i̱ diin swari̱ngi̱ to̱o̱ ba waka bu̱ri̱, ba yo̱o̱ ku̱maa.>> ");
INSERT INTO wja_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Anda Yesu le̱e̱man yo̱ ki̱n, <<Lakargar Yamba ce̱ ki̱n, <Ne̱re̱ na yi̱li̱ yi̱ ku̱maa yi̱ wundu, anda yi̱ kana do̱no̱ ci̱ye̱i̱ du baa bo̱nggo̱ Yamba.>>> ");
INSERT INTO wja_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Pero Balaa Buwai a de̱ Yesu Wurcalima, gwe̱i̱ du walwal, a ce̱nna pu de̱ke̱rge̱r Laa Yambau̱, ");
INSERT INTO wja_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","a sa yo̱ ki̱n, <<Ka ma yo̱o̱gi̱ Bo̱l Yamba we̱i̱, yarwe̱ po̱o̱, di̱ngi̱n balgi̱ mi̱ri̱nggi̱ lakargar Yamba ki̱n, <Yamba nyi̱i̱ we̱i̱ bacamandi ye̱i̱ te̱e̱re̱ a dwii mai, pma kangami̱nu̱ we̱i̱ a war pmai, di̱ngi̱n ma buni ya kana namau a swe̱le̱i̱.>>> ");
INSERT INTO wja_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu le̱e̱man yo̱ ki̱n, <<Lakargar Yamba a ce̱ ki̱n, <Ma cu̱u̱ ya Mbaa Wu Gi̱ra Yamba mo̱.>>> ");
INSERT INTO wja_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Bambang Balaa Buwai de̱ Yesu a ci̱ngu̱ ku getengteng a ju̱ku̱ yo̱ lau̱ri̱ tu si̱mai̱ yi̱ yi̱lau̱ yau̱ mwa mwa. ");
INSERT INTO wja_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Balaa Buwai se̱e̱ ki̱n, <<N nyi̱i̱mi̱nu̱ we̱i̱ ti̱na yi̱ri̱ngi̱ mwa mwa ka ma kun kwiyei ma ku̱rangi̱n si̱ma.>> ");
INSERT INTO wja_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yesu le̱e̱man yo̱ ki̱n, <<Mwati̱ po̱o̱ Balaa Buwai! Lakargar Yamba ce̱ ki̱n, <Ma nyi̱i̱ gi̱ru̱ Mbaa Wu Gi̱ra Yamba mo̱, ma ku̱raman yo̱ si̱ma yo̱ wundu.>>> ");
INSERT INTO wja_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Bur Balaa Buwai a du Yesu, anda bacamandi baanga pma kalanga yo̱. ");
INSERT INTO wja_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Pu Yesu nu̱wa ki̱n nu̱wa manni̱ Yohanna a jaru̱m, a aara si̱ma Galili wa. ");
INSERT INTO wja_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Yo̱ yaa ku si̱ si̱ye̱i̱ Nasaret anda a mwati̱ si̱ si̱ye̱i̱ a gwe̱i̱ Kaparnahum, gwe̱i̱ du ne̱m yi̱ kali̱nggu̱ ku Galili, a si̱ma Sabulun yi̱ Naptali. ");
INSERT INTO wja_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","To̱o̱ yi̱ri̱ ni̱ngwa yi̱to̱ palaka ba twanga tu banabi̱ Icaya ce̱i̱. ");
INSERT INTO wja_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","<<Si̱ma Sabulun yi̱ si̱ma Naptali, a nyinou wu aari kali̱nggu̱, ku yero you Urdun, yi̱ Galili, si̱ma nu̱wa bu yaa yo̱o̱gi̱ nu̱wa bu Yudaya wa! ");
INSERT INTO wja_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Nu̱wa bu pi̱si̱ndi̱ pu ri̱m wa kwe̱e̱ we̱i̱ rangu̱ wu gi̱ra̱u̱. Pma bu pi̱si̱ndi̱ si̱ma bu yi̱ ku̱mji̱la bo̱o̱ru̱ wa, Rang swi̱i̱ pma.>> ");
INSERT INTO wja_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Toso dwii jo̱re̱ Yesu toso wasi̱gu̱ ci̱ye̱i̱ ye̱i̱, <<Bu ni̱nga bwiiwa bo̱nggo̱ we̱le̱mdi̱ mbi̱ri̱ di̱ngi̱n lau̱ ku diyou ni̱nga ne̱m!>> ");
INSERT INTO wja_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Pu Yesu wo̱o̱ so̱ngma gi̱ng kali̱nggu̱ ku Galili, a ko̱ nu̱wa ro̱p ci̱yamba bu̱ri̱ twii nu̱wa bu re̱e̱ jindu wa, Simon wu nu̱wa yi̱ri̱ ki̱n Bitrus yi̱ ci̱ya yo̱ Andarawus, a re̱gu̱ jindi a kali̱nggu̱ yi̱ le̱mu̱. ");
INSERT INTO wja_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesu sa pma ki̱n, <<Bambe̱ bu po̱ngge̱, n ju̱ku̱ mbi̱ri̱ we̱i̱ re̱gu̱ nu̱wau̱.>> ");
INSERT INTO wja_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Yo̱ko̱ yo̱ko̱ pma du le̱mdi̱ pmai, a po̱ng yo̱. ");
INSERT INTO wja_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Yo̱ je̱e̱ gawu̱re̱ a ko̱ bu kangga ro̱p ci̱yamba bu̱ri̱, Yakubu yi̱ Yohanna, kwaraa Sabadi wa. Pma mi̱ri̱nggi̱ konggoru kem yi̱ mbaa pmo Sabadi, pma me̱ne̱nggu̱ le̱mdi̱ pmai. Yesu yi̱we̱ pma, ");
INSERT INTO wja_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","pma du̱u̱ konggoru wii mbaa pmo, yo̱ko̱ yo̱ko̱ pma po̱ng yo̱. ");
INSERT INTO wja_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu wo̱ra Galili, a ju̱ku̱gu̱ yi̱ri̱ngi̱ nu̱wa a gi̱ri̱ndi̱ ku̱ri̱ pmai, a wasi̱gu̱ ci̱ye̱i̱ du teng a dwii lau̱ Yambau̱, pero a mi̱ra nu̱wa bu yi̱ buwangi wundu wundu yi̱ bu̱ri̱ wulok wa pma yi̱langa. ");
INSERT INTO wja_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Labar yo̱ wasi̱ bu̱ri̱ si̱ma Siriya wa mwa mwa, di̱ngi̱n to̱no̱ nu̱wa ni̱nga pu de̱mu̱we̱ yo̱ nu̱wa mwa mwa bu yi̱ buwangi wundu wundu wa bu cu̱sanggu̱ bo̱nggo̱ buwangi wundu wundu yi̱ bu bu̱ri̱ mwaanga bu̱ru̱ wa, nu̱wa bu yi̱ wuturindi wa yi̱ bu yi̱ to̱ki̱ wa, yi̱ bu bu̱ri̱ bo̱rgi̱ wa Yesu mi̱ra pma mwa mwa a yi̱langa. ");
INSERT INTO wja_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Nu̱wa tum po̱ng yo̱, toso si̱ma Galili yi̱ si̱ma bu yi̱ Go̱ro̱ndi̱ Kwap wa, yake̱ Wurcalima, yi̱ Yudaya yi̱ si̱ma bu do̱no̱me̱ yi̱ Urdun wa. ");
INSERT INTO wja_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Pu Yesu ko̱ nu̱wa tum ku̱ranga bu̱ri̱ a geero ci̱ngu̱, a si̱n si̱ye̱i̱. Kwati̱mba ya ku̱ranga bu̱ri̱ wo̱ri̱gi̱ yo̱, ");
INSERT INTO wja_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","anda a toso pi̱rgu̱ pmau. ");
INSERT INTO wja_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","<<Wuure bo̱nggo̱ pma bu so̱m dwal pmai du bawei, lau̱ ku diyou kwii ko̱pi̱nau̱! ");
INSERT INTO wja_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Wuure bo̱nggo̱ pma bu yi̱ bwiyanggu gaanggu̱ wa, Yamba di̱ramanu̱ we̱i̱ pma gaanggu̱! ");
INSERT INTO wja_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Wuure bo̱nggo̱ pma bu yi̱ ci̱ngo̱n dwiu wa, pma ki̱nggu̱ we̱i̱ si̱ma! ");
INSERT INTO wja_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Wuure bo̱nggo̱ pma bu nu̱u̱ ju̱n ni̱nggu̱ pi̱su̱ wu nyaau a gawu̱ri̱ Yambai̱, Yamba yami̱nu̱ we̱i̱ pma biiki pmo ge̱kre̱k! ");
INSERT INTO wja_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Wuure bo̱nggo̱ pma bu nu̱u̱ bunam bu kangga, Yamba nu̱u̱ we̱i̱ bunam pmau! ");
INSERT INTO wja_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Wuure bo̱nggo̱ pma bu yi̱ gaanggu̱ walwal, pma kwe̱e̱ we̱i̱ Yamba! ");
INSERT INTO wja_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Wuure bo̱nggo̱ pma bu te̱ci̱ naapu wa, Yamba yi̱ru̱ we̱i̱ pma ki̱n kwaraa ya! ");
INSERT INTO wja_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Wuure bo̱nggo̱ pma bu nu̱wa turongo pma di̱ngi̱n ni̱ngu̱ pi̱su̱ wu nyaau a gawu̱ri̱ Yambai̱, lau̱ ku diyou kwii ko̱ pmau! ");
INSERT INTO wja_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","<<Wuure bo̱nggo̱ mbi̱ru̱ ka nu̱wa rwe̱e̱mbi̱ri̱, turo mbi̱ri̱ pero ci̱ye̱i̱ kana ko̱no̱ duu yi̱ri̱ tu bwi̱i̱ a dwii mbi̱ri̱ ki̱n di̱ngi̱n bu po̱nggu̱ mu. ");
INSERT INTO wja_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Bu ni̱nga bu̱ri̱ de̱gde̱g yi̱ di̱rang gaanggu̱, di̱ngi̱n wo̱ri̱ri̱ mbi̱ri̱ tum a pwii diyou. To̱o̱ tu ni̱ngaman banabi̱ndi̱ su gawu̱ri̱ yi̱ mba. ");
INSERT INTO wja_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","<<Bu yo̱o̱gi̱ bi̱makwanaa nu̱wa mwa mwa. Anda ka bi̱makwanaa cwaani bu̱ri̱ yi̱ teng yo̱u̱, nu̱wa puunu we̱i̱ teng yo̱u̱ kwii nye̱? Yo̱ ni̱nga kwe̱ce̱kwe̱ce̱, bur nu̱wa ba par si̱yau̱ si̱ma ba pe̱e̱nga. ");
INSERT INTO wja_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","<<Bu yo̱o̱gi̱ rangu̱ wu si̱ma mwa mwa. Gwe̱i̱ du mo̱gi̱ dwii ci̱ngu̱ yaa tukuri. ");
INSERT INTO wja_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Yaa ne̱re̱ wu ku̱ci̱n bwalau ke̱ndabwala ba summo yi̱ takale̱, anda nu̱wa ce̱nni̱ pu de̱ke̱rge̱r, di̱ngi̱n ba nyi̱i̱ rangu̱ kana we̱ wu laa wii. ");
INSERT INTO wja_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Yi̱to̱ mwaasi̱ rang mbi̱ru̱ ba swii bu̱ri̱ bo̱nggo̱ nu̱wau̱, palaka ba ko̱ wu̱rangi̱ mbi̱ri̱ tu nyaayi tu bu ni̱ngi̱, ba te̱re̱nga Mbaa mbi̱re̱ wu diyou. ");
INSERT INTO wja_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","<<Bu dangani̱ ya mi̱n n baa palaka n wo̱o̱ si̱ye̱i̱ Te̱e̱re̱ Musa yi̱ yi̱ri̱ng tu banabi̱ndi̱ balai. N baa bu n wo̱o̱ si̱ye̱i̱, anda n twanga. ");
INSERT INTO wja_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","N wo̱o̱ sagu̱mbi̱ru̱ ji̱re̱ ko̱po̱ ka diyou yi̱ si̱ma wo̱o̱ri̱ bu̱ri̱, kana go̱n ci̱ye̱i̱ diino, kana jo̱ku̱gu̱ ku banyi̱nau̱, yaa ku wo̱o̱ we̱i̱ bu̱ri̱ mi̱ri̱nggi̱ Te̱e̱ri̱ngi̱ Yambai̱ ko̱po̱ ka yi̱ri̱ngi̱ to̱o̱ mwa mwa ni̱ngdi̱ bu̱ri̱. ");
INSERT INTO wja_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Di̱ngi̱n to̱no̱ kana we̱ wu paa te̱e̱re̱ diino du banyi̱nai̱ a mi̱ri̱nggi̱ te̱e̱ri̱ngi̱, pero pi̱r bu kangga ba ni̱nga yi̱to̱, yo̱o̱ we̱i̱ wu banyi̱na a lau̱ ku diyou, anda kana we̱ wu po̱nga pero pi̱ryo̱ yo̱o̱ we̱i̱ wu gi̱ra a lau̱ ku diyou. ");
INSERT INTO wja_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","N wo̱o̱ sagu̱mbi̱ru̱ ji̱re̱, ka pi̱su̱ mbi̱r wu nyaau a gawu̱ri̱ Yambau̱ gwala bu ku̱lu̱mba te̱e̱ri̱ngi̱ wa yi̱ Parisayo ne̱, bu te̱mbi̱r lau̱ ku diyou. ");
INSERT INTO wja_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","<<Bu nu̱u̱ tu Yamba sa kakaa yiwa nang ki̱n, <Ma ji̱ri̱ ya ne̱re̱, kana we̱ wu ni̱nga, nu̱wa ni̱ngamanu̱ we̱i̱ yo̱ bali̱.> ");
INSERT INTO wja_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Anda n wo̱o̱ sagu̱mbi̱ru̱ mi̱n: Kana we̱ wu suko yi̱ bago̱n yo̱ nu̱wa ni̱ngamanu̱ we̱i̱ yo̱ bali̱, kana we̱ wu yi̱ bago̱n yo̱ ki̱n, <Ne̱r wu nyo,> nu̱wa de̱r we̱i̱ gawu̱ri̱ bagi̱raa nu̱wa bu Yudaya wa, pero kana we̱ wu yi̱ bago̱n yo̱ ki̱n bapi̱me̱ yannu̱ we̱i̱ par bwalau. ");
INSERT INTO wja_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ka ma wuni nyi̱i̱gu̱ ni̱i̱ Yamba a kwaare̱ anda ma danggi̱ mi̱n bago̱n mo̱ wo̱o̱ yi̱ yi̱ri̱ yi̱ mo̱, ");
INSERT INTO wja_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ma du ni̱i̱ mai a gawu̱ri̱ kwaare̱, ma mwati̱ ma nu̱wanga bago̱n mo̱ anda ma waata ba ma nyi̱i̱ ni̱i̱ mai Yamba. ");
INSERT INTO wja_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","<<Ka bace̱n mo̱ de̱r kwaram mo̱ a gi̱re̱ng balu, kasa bu nu̱wanga jo̱r du bu bo̱o̱ nyinou, pu bo̱ bu laman bu laa balu. Ka yi̱to̱ ne̱ de̱mi̱nu̱ we̱i̱ bo̱nggo̱ ne̱re̱ wu ni̱ng bali̱, wii yo̱ wu de̱mi̱nu̱ we̱i̱ bo̱nggo̱ bagi̱raa, pero nu̱wa manmi̱nu̱ we̱i̱ jaru̱m. ");
INSERT INTO wja_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","N wo̱o̱ sagu̱mbi̱ru̱, yaa ku̱ ma twii we̱i̱ pwii, ko̱po̱ ka mo̱ yar kana ca tu nu̱wa mwar mi̱nai̱. ");
INSERT INTO wja_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","<<Bu nu̱u̱ tu Yamba ce̱ ki̱n, <Ma ni̱ngi̱ ya taari̱.> ");
INSERT INTO wja_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Anda n sagu̱mbi̱ru̱ mi̱n, kana we̱ wu su̱wa nu̱re̱ yi̱ miyam a gaci̱la ni̱nga taari̱ yi̱ yo̱ a gaanggu̱. ");
INSERT INTO wja_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ka nung mo̱ wu je̱u̱ diimini we̱i̱ we̱le̱m we̱i̱, ma yikiyo ma man si̱ye̱i̱! Kujang ma yaa bo̱nggo̱ wu kangge̱ a bu̱ri̱ mai yiku bu̱ri̱ mai mwa mwa nu̱wa manmi̱nu̱ we̱i̱ bwalau ku yaa dumdu. ");
INSERT INTO wja_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ka wai mau wu je̱u̱ diimini we̱i̱ we̱le̱m we̱i̱, ma mwari̱ya ma man si̱ye̱i̱! Kujang ma yaa bo̱nggo̱ wu kangge̱ a bu̱ri̱ mai yiku bu̱ri̱ mai mwa mwa nu̱wa mannu̱ we̱i̱ bwalau ku yaa dumdu. ");
INSERT INTO wja_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","<<Ce̱gi̱ ki̱n, <Kana we̱ ka man nu̱re̱ yo̱ ko̱po̱ ka nyi̱i̱ lakargar jigu laabwiya.> ");
INSERT INTO wja_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Anda yo̱ko̱ n wo̱o̱ sagu̱mbi̱ru̱ mi̱n, kana we̱ wu man nu̱re̱ yo̱, yaa dwii taari̱ ne̱, a diina nu̱re̱ yo̱ ba ni̱nga we̱le̱m taari̱, pero kana we̱ wu yiki nu̱re̱ wu nu̱wa mana a ni̱nga taari̱. ");
INSERT INTO wja_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","<<Pero bu nu̱u̱ tu Yamba sa kakaa yiwa nang ki̱n, <Ma ki̱yani̱ ya we̱ra mo̱, anda ma ni̱nga tu ma we̱ranga gawu̱ri̱ Mbaa Wu Gi̱ra.> ");
INSERT INTO wja_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Yo̱ko̱ n sagu̱mbi̱ru̱, bu ni̱ngi̱ ya we̱ra a dwii kana ca. Bu we̱re̱ni̱ ya yi̱ diyou, di̱ngi̱n twii candu̱ Lau̱ Yambau̱ ");
INSERT INTO wja_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","kana yi̱ si̱ma pu ce̱nni̱ mwar ye̱i̱, kana yi̱ Wurcalima, di̱ngi̱n twii gwe̱i̱ Balaa wu Gi̱ra. ");
INSERT INTO wja_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Bu ni̱ngi̱ ya we̱ra kana yi̱ dwii mai, di̱ngi̱n bu puwi waku̱gu̱ kana ku̱u̱ ku̱ri̱ kiino po̱lo̱ po̱lo̱ kana pitipiti. ");
INSERT INTO wja_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Yama <O̱ng,> mbi̱re̱ ba yo̱o̱ <O̱ng,> pero <<Ang Ang,>> mbi̱r ba yo̱o̱ Ang Ang.> Kana ca tu bu ce̱ ka gwal yi̱to̱ a baa bo̱nggo̱ wu bwi̱i̱ye̱ wii. ");
INSERT INTO wja_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","<<Bu nu̱wa ce̱gi̱ ki̱n, <Nunge nyan nunge, pero nwii nyan nwii.> ");
INSERT INTO wja_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Anda yo̱ko̱ n sagu̱mbi̱ru̱ mi̱n, ma yari ya gerou bo̱nggo̱ ne̱re̱ ni̱ng tu bwi̱i̱. Ka wu kangge̱ kapa mini dwang mo̱ wu je̱u̱ ma wakaman yo̱ wu kanggi̱ wii mwaasi̱. ");
INSERT INTO wja_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ka ne̱re̱ wu kangge̱ kasi̱ de̱r kwaram mo̱ a laa balu palaka ba yi̱ya mi̱n cacuwe mau, ma mu̱rman yo̱ gatangamau mwa. ");
INSERT INTO wja_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ka kana we̱ ki̱ca mi̱n so̱ngma nyan mel wiino ma amna nyan mel ro̱p. ");
INSERT INTO wja_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ka kana we̱ ka senggi yi̱ri̱ bo̱nggo̱ mo̱u̱, ma puwa yo̱, ma jari ya ne̱re̱ wu baa kasi̱gu̱ ci̱ne̱ bo̱nggo̱ mo̱u̱. ");
INSERT INTO wja_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","<<Bu nu̱wa ce̱gi̱ ki̱n, <Ma kangman bapun mo̱, ma kwaa bace̱n mo̱.> ");
INSERT INTO wja_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Anda yo̱ko̱ n sagu̱mbi̱ru̱ mi̱n, bu kangman bace̱mba mba, bu ce̱man pma ku̱ru̱ pma bu turo mbi̱r wa, ");
INSERT INTO wja_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","palaka bu yo̱ kwaraa Mbaa mbi̱r wu diyou. Di̱ngi̱n yo̱ diini nyanggu̱ swiiri ne̱re̱ wu bwi̱i̱ye̱ yi̱ ne̱re̱ wu nyaa, pero diini gundu yar man ne̱re̱ wu ni̱ng pi̱su̱ wu nyaau a gawu̱ri̱ Yambai̱ yi̱ pma bu yaa ni̱ng pi̱su̱ wu nyaau a gawu̱ri̱ Yambai̱. ");
INSERT INTO wja_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ka bu kangman nu̱wa bu kang mbi̱ri̱ wa ti̱bak, wo̱ri̱ri̱ ye̱i̱ ca tu bu ki̱ng we̱i̱? Kana nu̱wa bu yi̱ri̱ janggal wa mwa, ni̱ng yi̱to̱! ");
INSERT INTO wja_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Anda ka bu ci̱r basi̱mba mba ti̱bak, tu bu ni̱nga twe̱e̱ye̱i̱ ca? Kana nu̱wa bu so̱m bu Yamba wa ni̱ng yi̱to̱! ");
INSERT INTO wja_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Tagi̱ bu si̱ya ci̱maci̱ma ci̱ka ku Mbaa mbi̱re̱ wu diyou ci̱maci̱ma. ");
INSERT INTO wja_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","<<Bu ruun tu̱we̱, bu ni̱ngi̱ ya wu̱rangi̱ tu nyaayi mi̱n palaka nu̱wa ba ko̱. Ka bu ni̱ng yi̱to̱ yaa ku bu nyi̱ngu̱ we̱i̱ wo̱ri̱ri̱ bo̱nggo̱ Mbaa mbi̱re̱ wu diyou. ");
INSERT INTO wja_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","<<Di̱ngi̱n yi̱to̱ ka bu nyi̱i̱ yi̱ri̱ ne̱re̱ wu yaa to̱no̱ bu te̱e̱ri̱ ya, ci̱ka ku nu̱wa bu yi̱ batal wa ni̱ngu̱ a mi̱ri̱nggu̱ gi̱ri̱ndi̱ ku̱ri̱ yi̱ nyindi. Pma ni̱ngi̱ yi̱to̱ palaka nu̱wa ba wandi̱ pma. N wo̱o̱ sagu̱mbi̱ru̱ ji̱re̱ pma nyi̱ngga wo̱ri̱ri̱ pmai. ");
INSERT INTO wja_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Anda ka bu kalan ne̱re̱ wu yaa to̱no̱, kana basi̱n mo̱ wu ne̱m ba so̱m ya, ");
INSERT INTO wja_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","palaka ni̱i̱ mai ba yo̱o̱ tukugi. Mbaa mo̱ wu kwe̱e̱yi̱ tu tukugi nyi̱i̱mi̱nu̱ we̱i̱ wo̱ri̱ri̱. ");
INSERT INTO wja_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","<<Ka bu wuni ce̱gu̱ ku̱ru̱ bu ni̱ngi̱ yaa ci̱ka nu̱wa bu yi̱ batal wa! Pma kasi̱ ba ce̱ ku̱ru̱ a pi̱ti̱ndi̱ a gi̱ri̱ndi̱ ku̱ru̱ yi̱ ge̱nge̱lte̱ nyindi, palaka kana we̱ ba ko̱ pma. N wo̱o̱ sagu̱mbi̱ru̱ ji̱re̱, pma gi̱ci̱la nyi̱ngga wo̱ri̱ri̱ pmai mwa mwa. ");
INSERT INTO wja_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Anda mo̱, ka ma wunni ce̱gu̱ ku̱ru̱, ma dimno kane̱, ma laka nyinou, ma ce̱ ku̱ru̱ bo̱nggo̱ Mbaa mo̱ wu nu̱wa yaa kwe̱e̱yi̱. Mbaa mo̱ wu kwe̱e̱yi̱ tu tukugi nyi̱i̱mi̱nu̱ we̱i̱ wo̱ri̱ri̱. ");
INSERT INTO wja_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","<<Ka bu wunni ce̱gu̱ ku̱ru̱ bu ni̱ngi̱ ya pu perenggu, ci̱ka ku nu̱wa bu so̱m bu Yamba wa ni̱ngu̱, pma nu̱u̱ ci̱ka Yamba nu̱u̱ we̱i̱ pma di̱ngi̱n ce̱wi̱ pmai tu co̱ku̱ro̱k. ");
INSERT INTO wja_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Bu ni̱ng ya yi̱to̱ di̱ngi̱n Mbaa mbi̱re̱ a so̱m tu bu kasi̱gi̱ yake̱ pu bo̱ bu senggo bu yo̱. ");
INSERT INTO wja_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ti̱na nyinou wu bu ce̱ we̱i̱ ku̱ru̱: <<Mbaa yire wu wo̱o̱ diyou, nu̱wa ba nyi̱i̱ gi̱ru̱ din mai. ");
INSERT INTO wja_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Lau̱ mo̱u̱ ba baa, dangandi̱ mai ba ni̱ngwa si̱ma, ci̱ka ku ni̱ngu̱ bu̱ru̱ a diyou. ");
INSERT INTO wja_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ma puu yir je̱e̱ndi̱ tu reni. ");
INSERT INTO wja_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ma para sukom we̱le̱m yiru, ci̱ka ku yo mwa yi paraman sukom pma bu we̱le̱ yiru wa. ");
INSERT INTO wja_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ma de̱ yiri ya bo̱nggo̱ miyam, anda ma mi̱ra yiro bo̱nggo̱ wu bwi̱i̱ wii. ");
INSERT INTO wja_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","<<Ka bu par sukom pma bu ni̱nga mbi̱r we̱le̱m wa, Mbaa mbi̱re̱ wu diyou yika mwaasi̱ para mbi̱r we̱i̱ sukom we̱le̱m mbi̱ru̱. ");
INSERT INTO wja_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Anda ka bu kwaa pargu̱ sukom pma bu we̱la mbi̱r wa, yi̱to̱ mwaasi̱ Mbaa mbi̱re̱ yaa ku para mbi̱ru̱ we̱i̱ sukom we̱le̱m mbi̱ru̱. ");
INSERT INTO wja_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","<<Anda ka bu de̱r cooji, bu bwiyani ya gaanggu̱ ci̱ka nu̱wa bu yi̱ batal wa. Pma caari̱ kau palaka kana we̱ ba ko̱ ki̱n pmai de̱gi̱ cooji. N wo̱o̱ sagu̱mbi̱ru̱ ji̱re̱ pma gi̱ci̱la nyi̱ngga wo̱ri̱ri̱ pmai mwa mwa. ");
INSERT INTO wja_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Anda ka ma de̱r cooji ma car kau mau, ma swati̱ dwii mai, ");
INSERT INTO wja_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","di̱ngi̱n nu̱wa ba so̱m ya ki̱n ma de̱gi̱ cooji bu̱ri̱ Mbaa mo̱, wu nu̱wa yaa kwe̱e̱yi̱, yo̱ so̱m we̱i̱. Anda Mbaa mo̱, wu kwe̱e̱yi̱ tu tukugi nyi̱i̱mi̱nu̱ we̱i̱ wo̱ri̱ri̱. ");
INSERT INTO wja_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Ma ruumani ya bu̱ri̱ mbi̱ri̱ gi̱na a si̱ma, pu bo̱bo̱ yi̱ saasa bwi̱yanu̱ we̱i̱, pero kuuwa ki̱nggu̱ we̱i̱ nyinou ba ji̱nda. ");
INSERT INTO wja_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Anda bu ruu man bu̱ri̱ mbi̱ri̱ gi̱na diyou Yambau̱, pu bo̱bo̱ yi̱ saasa na bwiyani, pero kana kuuwa na pu re̱pu̱gu̱ ba ji̱nda. ");
INSERT INTO wja_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Di̱ngi̱n pu gi̱na mo̱ wo̱o̱ mi̱ru̱, gaanggu̱ mo̱u̱ ko̱o̱ pwii. ");
INSERT INTO wja_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","<<Nundi twii ke̱ndabwala bu̱ru̱. Ka nundi mai kundi wang, mwa mwa bu̱ri̱ mai twanggi yi̱ rangu̱. ");
INSERT INTO wja_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Anda ka nundi yaa kundi ne̱, bu̱ri̱ mai mwa mwa si̱ we̱i̱ yi̱ ku̱mji̱la. Di̱ngi̱n to̱no̱ ka rang wu bu̱ri̱ mai twii ku̱mji̱la we̱i̱, ku̱mji̱la wu ma mi̱ri̱ wang! ");
INSERT INTO wja_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","<<Yaa ne̱re̱ wu ku̱ramanu̱ we̱i̱ si̱ma nu̱wa bu gi̱rawa ro̱p, ma kangmanu we̱i̱ wiino, ma kwaa wu kangge̱. Ma ce̱do̱ wu wiino, ma po̱ng wu kangge̱. Yaa ku ma ku̱ramanu̱ we̱i̱ si̱ma Yamba bambang ma ku̱raman si̱ma ke̱ne̱. ");
INSERT INTO wja_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Di̱ngi̱n to̱no̱ n wo̱o̱ sagu̱mbi̱ru̱, bu miyani ya bu̱ri̱ yi̱ pi̱i̱ma mba, yi̱ yi̱ri̱ tu bu je̱e̱ we̱i̱ yi̱ tu bu naa we̱i̱, kana se̱e̱ wu bu te̱e̱ru̱ we̱i̱ a bu̱ri̱. Pi̱i̱ma gwala bu je̱e̱ndi̱ ru? Bu̱ri̱ gwala bu se̱e̱ ru? ");
INSERT INTO wja_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Bu su̱wa yidi, pma yaa pi̱ri̱ yaa kaci̱, pero yaa gamani ba parna bindou, anda Mbaa mbi̱re̱ wu diyou pu pma je̱e̱ndi̱! Bu gwala bu yidi kwaara ru? ");
INSERT INTO wja_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Wii we̱ a cu̱du̱ mbi̱ri̱ di̱ngi̱n miyanggu bu̱ru̱ puu we̱i̱ cwatugu kana daa kiino a mi̱ri̱nggi̱ daa yo̱? ");
INSERT INTO wja_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","<<Anda di̱ngi̱n ca bu miyani bu̱ru̱ di̱ngi̱n se̱e̱? Bu su̱wa pundi tu gu̱lai̱ gi̱ri̱, yaa pu ni̱nggu̱ kana ca di̱ngi̱n bu̱ri̱ pmai, yaa pu ba ni̱nga waandi di̱ngi̱n bu̱ri̱ pmai. ");
INSERT INTO wja_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Anda n wo̱o̱ sagu̱mbi̱ru̱ kana Balaa Solomon yi̱ gi̱r yo̱u̱ mwa ni̱nga bu waandi si̱i̱ yi̱lau̱ ci̱ka to̱no̱. ");
INSERT INTO wja_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ka ce̱mbe̱re̱ Yamba pu ni̱ngaman si̱i̱ tu gu̱lai̱ waandi tu to̱o̱ reni anda pu̱nge̱ nu̱wa parnu we̱i̱ bwalau, dwiyaman mba te̱e̱ mbi̱ru̱ we̱i̱ se̱e̱, mba bu yi̱ dwal le̱e̱gu̱ ji̱re̱. ");
INSERT INTO wja_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","<<Di̱ngi̱n to̱no̱, bu miyani ya bu̱ri̱, bu ce̱gu̱ mi̱n, <Tu yi je̱e̱ we̱i̱ ca? Tu yi naa we̱i̱ ca? Tu yi te̱e̱ru̱ we̱i̱ ca?> ");
INSERT INTO wja_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Nu̱wa bu pma so̱m bu Yamba wa, a kasanggu̱ to̱o̱ yi̱ri̱ngi̱ mwa mwa, Mbaa mbi̱re̱ wu diyou a so̱m biiki mbi̱re̱. ");
INSERT INTO wja_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Anda tu gawu̱ri̱yo̱, bu kasa lau̱ yo̱u̱ yi̱ pi̱su̱ wu nyaau a gawu̱ri̱ ye̱i̱, anda yo̱ nyi̱i̱mbi̱ri̱ we̱i̱ to̱o̱ yi̱ri̱ngi̱ mwa mwa. ");
INSERT INTO wja_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Di̱ngi̱n to̱no̱ bu miyani ya bu̱ri̱ yi̱ punge, punge a yi̱ biiki yo̱. Kana ko̱no̱ nyanggu̱ yi̱ biiki yo̱. ");
INSERT INTO wja_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","<<Bu ni̱ngamani̱ ya bali̱ nu̱wa, palaka Yamba ba ni̱nga mbi̱r ya bali̱, ");
INSERT INTO wja_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","di̱ngi̱n Yamba ni̱ng mbi̱r we̱i̱ bali̱ yi̱to̱ ci̱ka ku bu ni̱ngaman bali̱ nu̱wa. Yi̱ bo̱so̱ro̱ wu bu cu̱u̱man nu̱wa yi̱ to̱no̱, Yamba cu̱u̱ mbi̱ri̱ we̱i̱ yi̱ to̱no̱.>> ");
INSERT INTO wja_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Di̱ngi̱n ca mo̱ su̱u̱gu̱ bo̱si̱yau̱ ku̱ nung bago̱n mo̱u̱, anda ma yaa ko̱gu̱ gulsou wu nung mo̱u̱? ");
INSERT INTO wja_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ni̱ngdu̱ we̱i̱ nye̱ ma sa bago̱n mo̱ mi̱n, <Yama n de̱man bo̱si̱yau̱ ku̱ nung mo̱u̱,> anda mo̱ yi̱ri̱ mai ma wo̱o̱ yi̱ gulsou a nung mo̱? ");
INSERT INTO wja_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Mo̱ wii batal, ma toso de̱manggu̱ gulsou wu nung mo̱u̱ bati̱, palaka mo̱ kwe̱e̱ we̱i̱ si̱ma kundi, ma podoman bago̱n mo̱ bo̱si̱yau̱ ku̱ nung yo̱u̱. ");
INSERT INTO wja_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","<<Bu nyi̱i̱ ya baindi yi̱ri̱ tu walwal. Ma mandi̱ ya si̱ye̱i̱ gi̱si̱ tu yi̱ pi̱rcu̱ a gawu̱r bakambi̱ su lai̱, pma pe̱nu̱ we̱i̱ yi̱ mwari pmai! Anda ba waata bo̱nggo̱ mo̱u̱ ba pwara mi̱na. ");
INSERT INTO wja_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Bu ni̱nga pu celo, nu̱wa nyi̱i̱mbi̱ri̱ we̱i̱. Bu ni̱nga pu kasi̱gu̱, bu nyi̱nggu̱ we̱i̱. Bu ni̱nga pu kupugu, nu̱wa wunmbi̱ru̱ we̱i̱. ");
INSERT INTO wja_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Di̱ngi̱n kana we̱ wu celo, nu̱wa nyi̱i̱ we̱i̱. Kana we̱ wu kasa, nyi̱nggu̱ we̱i̱, pero do̱ng kana we̱ wu kupo, nu̱wa wunmanu we̱i̱ yo̱. ");
INSERT INTO wja_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Mba kwiimba, wii we̱ a cu̱du̱ mbi̱ri̱ wu ka bo̱l yo̱ cel yo̱ ku̱maa, nyi̱i̱ we̱i̱ swe̱l? ");
INSERT INTO wja_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Pero ka cel yo̱ jingne, nyi̱i̱ we̱i̱ co̱o̱gu̱ we̱? ");
INSERT INTO wja_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ka mba bu bwi̱i̱wa bu so̱m nyi̱i̱gu̱ tu nyaayi kwaraa mba we̱i̱, dwiyamin Mbaa mbi̱re̱ wu diyou, yo nyi̱i̱ we̱i̱ yi̱ri̱ngi̱ tu nyaayi nu̱wa bu senggu yo̱ wa! ");
INSERT INTO wja_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Di̱ngi̱n to̱no̱, ci̱ka ku̱ bu kasi̱ nu̱wa ba ni̱ngambi̱ra, yi̱to̱ mwa bu ni̱ngaman pma, to̱o̱ pi̱ti̱ndi̱ te̱e̱ri̱ng Musa yi̱ banabi̱ndi̱. ");
INSERT INTO wja_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","<<Bu tembiro nyinou wu gu̱rci̱k. Di̱ngi̱n nyinou wu le̱pe̱k de̱r ne̱re̱ par bwalau, pero nu̱wa tum teendi. ");
INSERT INTO wja_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Anda nyinou wu banyi̱nau̱ pero gu̱rci̱k twii nyinou wu de̱r ne̱re̱ pi̱i̱ma, anda nu̱wa banyi̱na ti̱bak ki̱nggi̱. ");
INSERT INTO wja_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","<<Bu ruun tu̱we̱ bo̱nggo̱ banabi̱ndi̱ leendi wa. Pma baanga we̱i̱ bo̱nggo̱ mbi̱ru̱ a mi̱ri̱nggi̱ biyau ci̱ka puuri, anda a mi̱ri̱nggi̱ pmai twii geppindi. ");
INSERT INTO wja_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Bu ku̱ranu̱ we̱i̱ pma bo̱nggo̱ tutwiyari pmai. Yaa ku̱ nu̱wa war we̱i̱ tutwiyari inabi a bo̱nggo̱ ku̱ri̱lle̱, yi̱to̱ mwa yi̱ pwaari̱ pwalgu̱ a bo̱nggo̱ sou calau. ");
INSERT INTO wja_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Yi̱to̱ mwaasi̱ yi̱ kana ko̱no̱ sou ku nyaau nyi̱i̱ tutwiyari ye̱i̱, anda sou ku bwi̱u̱ nyi̱i̱ tutwiyari tu bwi̱i̱. ");
INSERT INTO wja_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Sou ku nyaau yaa nyi̱i̱ tutwiyari tu bwi̱i̱. Yi̱to̱ mwa sou ku bwi̱u̱ yaa nyi̱i̱ tutwiyari tu nyaayi. ");
INSERT INTO wja_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kana ko̱no̱ sou ku yaa nyi̱i̱ tutwiyari tu nyaayi nu̱wa kaci̱nu̱ we̱i̱ si̱ma ba manna bwalau. ");
INSERT INTO wja_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Yi̱to̱ mwaasi̱, bu ku̱ranu̱ we̱i̱ pma bo̱nggo̱ tutwiyari pmai. ");
INSERT INTO wja_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","<<Yaa kana we̱ wu yi̱nggi̱ ki̱n, <Mbaa Wu Gi̱ra, Mbaa Wu Gi̱ra,> diiru we̱i̱ lau̱ ku diyou, anda bu̱ri̱ ne̱re̱ wu tu̱m dangandi̱ Mbaa mi wu diyou. ");
INSERT INTO wja_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","A nyanggu̱ balu, nu̱wa tum sanggu̱ we̱i̱ ki̱n, <Mbaa Wu Gi̱ra, Mbaa Wu Gi̱ra, yi ce̱ tu ni̱ngdu̱ we̱i̱ pi̱na yi̱ gawu̱ri̱ a mi̱ri̱nggi̱ din mai, yi̱ din mai yi yikongo wuturindi, yi ni̱nga yi̱ri̱ngi̱ ri̱yandi̱ bu̱ri̱ tum.> ");
INSERT INTO wja_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","N saru we̱i̱ pma ge̱mbe̱l mi̱n, <N ti̱i̱ bu so̱nggu̱mbi̱ru̱. Bu laanga po̱o̱ bo̱nggo̱ mu, mba nu̱wa bu tu̱m tu bwi̱i̱ wa.> ");
INSERT INTO wja_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","<<Di̱ngi̱n to̱no̱ kana we̱ wu nu̱u̱ ci̱ye̱i̱ mi pero ni̱ngi̱ wu̱rai̱ yi̱ to̱no̱ ci̱ka ne̱re̱ wu pwi̱yagi̱ wu mo̱nni̱ laa yo̱u̱ dwii swe̱li̱. ");
INSERT INTO wja_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Pu gundu toso yarugu, youri twanganga, wutur baa a buu laa wii anda yaa ku yarau, di̱ngi̱n nu̱wa man taayau̱ dwii swe̱li̱. ");
INSERT INTO wja_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Anda kana we̱ wu nu̱u̱ ci̱ye̱i̱ mi anda yaa ku ni̱nga wu̱rai̱ yi̱ to̱no̱ ci̱ka ne̱re̱ wu yi̱ cini wu mo̱nni̱ laa yo̱u̱ a swai. ");
INSERT INTO wja_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Pu gundu toso yarugu, youri twanganga, pero wuture ni̱nga, a buu laa wii, a yara, yaranggu̱ yo̱u̱ a ni̱nga wang.>> ");
INSERT INTO wja_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Pu Yesu mata ce̱gu̱ to̱ yi̱ri̱ngi̱, nu̱wa bwii riyanga bu̱ri̱ yi̱ yi̱ri̱ngi̱ tu ju̱ku̱gu̱, ");
INSERT INTO wja_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","di̱ngi̱n a ju̱ku̱gu̱ yi̱ri̱ngi̱ ci̱ka ne̱re̱ wu yi̱ di̱mbi̱re̱, yaa ci̱ka ku̱lu̱mba te̱e̱ri̱ngi̱ pma wa. ");
INSERT INTO wja_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Go̱ro̱ pu Yesu julo ci̱ngu̱ kwii, nu̱wa tum po̱ngwe̱ yo̱. ");
INSERT INTO wja_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ne̱re̱ wu kangge̱ wu yi̱ butangi baa bo̱nggo̱ yo̱u̱ a kun kwiyou a ce̱ ki̱n, <<Mbaa Wu Gi̱ra, ka ma le̱e̱i̱, ma mi̱rangge̱ n yi̱la a bo̱nggo̱ butangi mi.>> ");
INSERT INTO wja_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesu a yaku wai a ce̱rman yo̱, a se̱e̱ ki̱n, <<N le̱e̱, yi̱la!>> Yo̱ko̱ yo̱ko̱ butangi twii a du ne̱re̱ wii.>> ");
INSERT INTO wja_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yesu sa yo̱ ki̱n, <<Ma sari̱ ya kana we̱ to̱o̱ yi̱ri̱. Anda ma amna ma ju̱ku̱ bu̱ri̱ mai kuru Yamba ba su̱wa mi̱na, pero ma nyi̱i̱ ni̱i̱ du Musa ce̱ ki̱n nu̱wa ba nyi̱i̱ya, di̱ngi̱n ni̱nggu̱ walwal. Ma ni̱nga yi̱to̱ di̱ngi̱n nu̱wa ba so̱ma ki̱n ma yi̱la.>> ");
INSERT INTO wja_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Pu Yesu diiro Kaparnahum, kacala Roma wa wu kangge̱ baa ki̱nga yo̱ a senggo yo̱ ki̱n, ");
INSERT INTO wja_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","<<Ne̱re̱ wu gi̱ra, ke̱we̱ mi wo̱o̱ pi̱dau̱ lai̱, bu̱ri̱ ye̱i̱ bo̱rgi̱ a cu̱su̱gu̱ wang.>> ");
INSERT INTO wja_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesu se̱e̱ ki̱n, <<N anggu̱ we̱i̱ n mi̱ra yo̱.>> ");
INSERT INTO wja_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Bagi̱ra kacaraa wii ce̱ ki̱n, <<Ang ang yaa yi̱to̱ Mbaa Wu Gi̱ra, mi yinnibu ma baa laa mu, anda mo̱ ce̱ ci̱ye̱i̱ ti̱bak, ke̱we̱ mi yi̱l we̱i̱. ");
INSERT INTO wja_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Di̱ngi̱n mi mwa n wo̱o̱ ku̱u̱ ne̱re̱ wu kangge̱, pero do̱ng n wo̱o̱ yi̱ kacara ku̱u̱ mu̱, ka n sar wuna mi̱n, <Amna,> yo̱ ba aara, wu kangge̱ do̱ng n se̱e̱ mi̱n, <Bame̱!> bur ba baa, pero ka n sar ke̱we̱ mi mi̱n, <Ni̱nga yi̱ri̱ nyo!> Bur ba ni̱nga.>> ");
INSERT INTO wja_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Pu Yesu nu̱wa yi̱to̱, a riyanga bu̱ri̱, a sa nu̱wa bu po̱nggu̱ yo̱ wa ki̱n, <<N wo̱o̱ sagu̱mbi̱ru̱ ji̱re̱i̱ yaa ku n nyi̱ngga ne̱re̱ wu le̱e̱gu̱ ji̱re̱ ku yi̱ di̱mbi̱re̱ ci̱ka ki̱naa a Israila. ");
INSERT INTO wja_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","N wo̱o̱ sagu̱mbi̱ru̱ nu̱wa tum baanga we̱i̱ bo̱nggo̱ do̱no̱me̱ yi̱ nyambi̱ranggu̱ ba si̱ndi̱ si̱yau̱, a je̱gu̱ a naagu kem yi̱ Ibrahim yi̱ Icaku yi̱ Yakubu a lau̱ ku diyou. ");
INSERT INTO wja_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Anda pma bu daaya ba teendo lau̱ ku diyou nu̱wa parnu we̱i̱ pma ku̱mji̱la, pu pma jii we̱i̱ wiindi yi̱ dumonggu nyi̱yau̱.>> ");
INSERT INTO wja_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Anda Yesu sa bagi̱ra kacaraa wii ki̱n, <<Mwati̱ lai̱, ci̱ka ku ma pu ji̱re̱ ni̱ndu̱ we̱i̱ yi̱to̱.>> Anda ke̱we̱ bagi̱ra kacaraa wii a yi̱la ki̱nangu̱. ");
INSERT INTO wja_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesu aara laa Bitrus, a ki̱ngga sii Bitrus wu nu̱re̱ a pi̱dau̱ yi̱ bu̱ri̱ wulok. ");
INSERT INTO wja_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","A mwaanga wai yau̱, bur bu̱ri̱ wulok swii man yo̱, a wuni, a ni̱ngaman yo̱ je̱e̱ndi̱. ");
INSERT INTO wja_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ku lam nyambi̱ranggu̱ nu̱wa de̱mu̱we̱ Yesu nu̱wa bu yi̱ wuturindi wa tum. Yesu yikongo wuturindi yi̱ ci̱ye̱i̱ ti̱bak, a mi̱ra pma bu yaa cingcing wa pma yi̱langa mwa mwa. ");
INSERT INTO wja_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","To̱o̱ ni̱ngwa yi̱to̱ palaka ba twanga tu banabi̱ Icaya ce̱ ki̱n, <<A de̱ dwal bu̱ri̱ cingcing yiru yi̱ buwangi yiri.>> ");
INSERT INTO wja_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Pu Yesu ku̱ranga ki̱n nu̱wa tum wo̱ra yo̱, a sa kwati̱mba ya ki̱n ba yerongo gi̱ngu̱ kali̱nggi̱ kwii. ");
INSERT INTO wja_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ku̱lu̱m te̱e̱ri̱ngi̱ a baa bo̱nggo̱ yau̱ a ce̱ ki̱n, <<Ku̱lu̱me̱, mi po̱ngmi̱nu̱ we̱i̱ kana pi̱yau̱ pu mo̱ amnu̱ wau.>> ");
INSERT INTO wja_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesu nyi̱i̱ le̱e̱ ki̱n, <<Bapi̱rmi̱si̱ndi̱ bo̱o̱ yi̱ bo̱ri̱ng pmai, yidi mwa yi̱ cwaaringi pmai, anda Bo̱l Ne̱re̱ yaa pu daa mi̱ru̱.>> ");
INSERT INTO wja_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Wu kangge̱ cu̱di̱ kwati̱mba ya a ce̱ ki̱n, <<Mbaa Wu Gi̱ra, du̱ngge̱ bati̱ n angge̱ n tingwe mbaa mi.>> ");
INSERT INTO wja_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yesu se̱e̱ ki̱n, <<Po̱nggu̱we̱ du nu̱wa bu bwanggi̱ wa ba tingi kappi̱ma bu bwaanggi̱ wa.>> ");
INSERT INTO wja_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesu diiro konggoru anda kwati̱mba ya po̱ng yo̱. ");
INSERT INTO wja_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Yaa te̱mandi̱ bur wutur gundu a wunuwe. Gwe̱rai̱ gundi a paringgu gundu a mi̱ri̱nggu̱ konggoru, anda Yesu a diima. ");
INSERT INTO wja_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Kwati̱mba ya aanda bo̱nggo̱ yo̱u̱ a romya pma ce̱ ki̱n, <<Mbaa Wu Gi̱ra, mi̱ra yiro, yi bwanu we̱i̱.>> ");
INSERT INTO wja_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","<<Yesu sa pma ki̱n, <<Di̱ngi̱n ca bu nu̱u̱gu̱ gwasi̱, mba bu le̱e̱gu̱ ji̱re̱ mbi̱ru̱ banyi̱na wa?>> Bur a wuni a ye̱ra wuture yi̱ gwe̱re̱ gundu dwii, bur a si̱n si̱ye̱i̱ to̱k. ");
INSERT INTO wja_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Kana we̱ riyanga bu̱ri̱ ki̱n, <<Ki̱naa ko̱no̱ duu ne̱ru̱? Wu kana wuture yi̱ gwe̱rai̱ gundi ni̱ngi̱ po̱ngo̱ndi̱ yi̱ yo̱!>> ");
INSERT INTO wja_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Pu Yesu aara bo̱nggo̱ si̱ma Gadara a gi̱ng kali̱nggi̱ kwii, a kaanga yi̱ nu̱wa ro̱p bu twiyongo dwiiyongi puringi, nu̱wa bwii yi̱ wuturindi. Pma yi̱ kwe̱i̱ wang di̱ngi̱n to̱no̱ yaa ne̱re̱ wu po̱ng wii nyinou. ");
INSERT INTO wja_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Pma ni̱nga duwai ki̱nangu̱ ki̱n, <<Bo̱l Yamba ma kasi̱gu̱ ca yi̱ yo? Ma baa pi̱na ma turo yiro bo̱ jo̱r lam bu ru?>> ");
INSERT INTO wja_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Kan bakambi̱ su lai̱ so̱o̱ ne̱m yi̱ po̱o̱ wii, a taagu̱ taawu̱. ");
INSERT INTO wja_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Wuturindi swii senggo Yesu ki̱n, <<Ka ma yiki yire ma su̱ka yiro yi teendo mi̱ri̱nggi̱ bakambi̱ su lai̱ swii. ");
INSERT INTO wja_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesu sa pma ki̱n, <<Bu ambi̱ra>> Pma twiyongo, teendo bakambi̱ su lai̱ swii. Mwa mwa kan bakambi̱ swii a mwatanga ki̱lang ki̱lang a julomana ce̱rau̱ a yaramana gundu a bwaamana a mi̱ri̱nggi̱. ");
INSERT INTO wja_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Nu̱wa bu taagu̱ bakambi̱ su laa swii pma ceendo gwe̱i̱, pma nyi̱i̱ nu̱wa labar yi̱ri̱ngi̱ tu ni̱ngwai̱ yi̱ nu̱wa bu yi̱ wuturindi bwii. ");
INSERT INTO wja_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Kana we̱ a mi̱ri̱nggi̱ gwe̱i̱ dwii, a mwati̱ di̱ngi̱n ba kanga yi̱ Yesu, anda pu ko̱ yo̱ a senggo yo̱ ba du si̱ma pma. ");
INSERT INTO wja_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu geero konggoru a waata bu̱ri̱, a yeri bo̱nggo̱ kali̱nggi̱ a aara gwe̱i̱ ye̱i̱. ");
INSERT INTO wja_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Nu̱wa de̱mu̱we̱ yo̱ ne̱re̱ wu bu̱ri̱ bo̱rgi̱ a pi̱dau̱ yu̱u̱. Pu Yesu ko̱ le̱e̱gu̱ ji̱re̱ pmau, a sa ne̱re̱ wu bu̱ri̱ bo̱rgi̱ wii ki̱n, <<Ci̱ko̱ gaanggu̱ bo̱l mi, nu̱wa parami̱n sukom we̱le̱mdi̱ mai.>> ");
INSERT INTO wja_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ku̱lu̱mba te̱e̱ri̱ngi̱ wa bu kangga yanna ce̱gu̱ ci̱ye̱i̱ yi̱ bu̱ri̱ pmai ki̱n, <<Ne̱re̱ wo̱o̱ bwiyanggu din Yambai̱!>> ");
INSERT INTO wja_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesu ku̱ranga tu pma danganggi̱ a ce̱ ki̱n, <<Di̱ngi̱n ca bu danganggu̱ yi̱ri̱ngi̱ tu bwi̱i̱ a gaanggi̱ri̱ mbi̱ri̱ yi̱to̱? ");
INSERT INTO wja_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Tu le̱e̱le̱e̱ to̱no̱, yiku n sa ne̱re̱ wo̱ mi̱n, <N parami̱n sukom we̱le̱m mau,> yi̱ ku n se̱e̱ mi̱n, <Wuni ma ni̱nga so̱ngma>? ");
INSERT INTO wja_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Anda n kasi̱ bu so̱ma mi̱n, Bo̱l Ne̱re̱ wo̱o̱ yi̱ di̱mbi̱re̱ a si̱ma ba para sukom we̱le̱m.>> Anda a sa ne̱re̱ wu bu̱ri̱ bo̱ri̱gi̱ wii ki̱n, <<Wuni, ma de̱ yu̱u̱ mau, ma mwati̱ lai̱.>> ");
INSERT INTO wja_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ne̱re̱ wii wuni, a mwati̱ laa yo̱u̱. ");
INSERT INTO wja_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Pu nu̱wa bu ku̱ranggi̱ bu̱ri̱ ko̱ yo̱, pma nu̱u̱ gwasi̱, pma te̱ranga Yamba di̱ngi̱n wo̱o̱ di̱mbi̱re̱ wu nyi̱i̱ nu̱wa. ");
INSERT INTO wja_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu du po̱o̱ wii, anda pu so̱ngmau̱, a ko̱ ne̱re̱ wu yi̱ri̱ janggal wu din ye̱i̱ Matayo, a pi̱su̱ pu nu̱wa yi̱ri̱ janggal. A se̱e̱ ki̱n, <<Po̱nggu̱we̱.>> Matayo wuni, a po̱ng yo̱. ");
INSERT INTO wja_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Pu Yesu wo̱o̱ je̱gu̱ je̱e̱ndi̱ laa Matayo, nu̱wa bu yi̱ri̱ janggal wa tum yi̱ nu̱wa bu kangga bu yi̱ we̱le̱m wa pma baanga je̱ je̱e̱ndi̱ kem yi̱ yo̱ yi̱ kwati̱mba ya. ");
INSERT INTO wja_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Parisayo bu kangga ku ko̱ yi̱to̱ pma pi̱ra kwati̱mba ya ki̱n, <<Di̱ngi̱n ca ku̱lu̱m mbi̱re̱ a je̱gu̱ je̱e̱ndi̱ yi̱ nu̱wa yi̱r janggal yi̱ bu yi̱ we̱le̱m wa?>> ");
INSERT INTO wja_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Pu Yesu nu̱wa, a sa pma ki̱n, <<Nu̱wa bu cingcing wa yaa kasi̱ ku̱lu̱me̱, bu̱r nu̱wa bu yaa cingcing wa. ");
INSERT INTO wja_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ambi̱ra bu ye̱sa tu lakargar Yamba ce̱i̱, <Tu n kasi̱ twii nu̱wa ba ju̱ki̱ bunam, twii nyi̱i̱gu̱ ni̱i̱ ne̱.> N baa bu di̱ngi̱n nu̱wa bu ni̱ngi̱ pi̱su̱ wu nyaau a gawu̱ri̱ Yambai̱ anda n baa di̱ngi̱n nu̱wa bu yi̱ we̱le̱m wa.>> ");
INSERT INTO wja_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Kwati̱mba Yohanna wu Ni̱ngi̱ Bati̱si̱ma baanga bo̱nggo̱ Yesu a pi̱ra ki̱n, <<Di̱ngi̱n ca yo yi̱ Parisayo yi ni̱ng cooji nyi̱ki̱ri̱k anda kwati̱mba ma yaa ni̱ngi̱?>> ");
INSERT INTO wja_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesu nyi̱i̱ le̱e̱ ki̱n, <<Ni̱ngdu̱we̱ nye̱ basi̱nba laabwiya wa ba de̱ cooji pu bo̱ wo̱o̱ kem yi̱ bwiyaka wu laabwiya we̱yo̱ ru?>> Anda daandi so̱o̱ baayi su nu̱wa de̱manu̱ we̱i̱ bwiyaka wu laabwiya we̱yo̱ a bo̱nggo̱ pmau̱, bur pma ni̱ngi̱ we̱i̱ cooji. ");
INSERT INTO wja_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","<<Yaa wu cwaki̱nu̱ we̱i̱ se̱e̱ wu pu̱ce̱ a dwii wu mi̱lga, ka ni̱ndi̱ yi̱to̱ wu nu̱wa cwaki̱na wii kwaci̱ranu̱ we̱i̱ se̱e̱ wii ba diina ba pwarwa wang. ");
INSERT INTO wja_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Pero yaa ne̱re̱ wu de̱ru̱ we̱i̱ gundu inabi ku pu̱cu̱ ba parna cwe̱i̱ndi̱ bi̱yari̱ tu mi̱lgai̱, ka ni̱ndi̱ yi̱to̱ gundu inabi ku̱ pu̱ci̱ kwii, re̱panu̱ we̱i̱ cwe̱i̱ndi̱ bi̱yari̱ twii, pero gundu inabi kwii ba par si̱yau̱. Anda nu̱wa ba parna a cwe̱i̱ndi̱ bi̱yari̱ tu pu̱ci̱, mwa mwa pmau ba ni̱ngga kundi. ");
INSERT INTO wja_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Pu Yesu wo̱o̱ ce̱gu̱ ti̱na yi̱ri̱ngi̱, ne̱re̱ wu gi̱ra wu gi̱re̱ng ku̱ru̱ a baa bo̱nggo̱ yo̱u̱ a kun kwiyou gawu̱ri̱ ye̱i̱, a ce̱ ki̱n, <<Bwe̱e̱canga mi a bwaa yo̱ko̱ ki̱na, bame̱ ma ce̱nni̱ wai wuni we̱i̱ yi̱ pi̱i̱ma.>> ");
INSERT INTO wja_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yesu wuni a po̱ng yo̱, kem yi̱ kwati̱mba ya. ");
INSERT INTO wja_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Nu̱r wu kangge̱ wu ti̱i̱gu̱ ku̱u̱lu̱ yi̱ buwai pargu̱ si̱ye̱i̱ ti̱i̱mau̱ nyan mi̱ldi̱ kwap su̱r ro̱p, a baa go̱ro̱u̱ Yesu a pilo nyan gatangamau yo̱u̱. ");
INSERT INTO wja_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","A sa bu̱ri̱ ye̱i̱ ki̱n, <<Ka n pili kana gatangamau yo̱u̱, n yi̱lu̱ we̱i̱.>> ");
INSERT INTO wja_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesu waka kau a ko̱ yo̱, a ce̱ ki̱n, <<Bwe̱e̱canga mi ci̱ko̱ gaanggu̱, le̱e̱gu̱ ji̱re̱ mau a mi̱rami̱na.>> A dwii jo̱re̱ nu̱re̱ wii ni̱nga cingcing. ");
INSERT INTO wja_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Pu Yesu lama laa ne̱re̱ wu gi̱ra wu gi̱re̱ng ku̱ru̱, ku ko̱ nu̱wa kwari̱ndi̱ yi̱ bu kangga wuugu bagaati̱ bo̱o̱re̱, ");
INSERT INTO wja_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","a ce̱ ki̱n, Kana we̱ ba twiyo. <<Bwe̱e̱canga wo̱o̱ yaa bwaagi̱, a diima!>> Pma rii yo̱. ");
INSERT INTO wja_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ku nu̱wa yiku nu̱wa bwii twalange̱, Yesu te̱e̱ wai, a wuni. ");
INSERT INTO wja_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Labar yo̱ wasi̱ bu̱ri̱ kana pi̱yau̱ a si̱ma bwii. ");
INSERT INTO wja_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Pu Yesu du po̱o̱ wii, kerma ro̱p po̱ngu̱ yo̱ pma ni̱ngu̱ duwau a ce̱gu̱ ki̱n, <<Bo̱l Dawud, nu̱u̱ bunam yiru!>> ");
INSERT INTO wja_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Pu Yesu diiro laa wu pi̱su̱ mi̱ri̱, kerma bu ro̱p bwii baanga bo̱nggo̱ yo̱u̱ anda a pi̱ra pma ki̱n, <<Bu le̱e̱ ji̱re̱i̱ n puu we̱i̱ kalanggi̱ mbi̱r du?>> Pma le̱e̱man yo̱ ki̱n, <<O̱ng ne̱re̱ wu gi̱ra.>> ");
INSERT INTO wja_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Yesu mwaanga nundu pmai a ce̱ ki̱n, <<Yama ba ni̱ngwa ci̱ka ku̱ bu le̱e̱ ji̱re̱i̱!>> ");
INSERT INTO wja_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Nundi pmai toso ko̱gu̱. Yesu sa pma ki̱n, <<Bu sari ya kana we̱!>> ");
INSERT INTO wja_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Anda pma mwatanga a wasi̱ ci̱ye̱i̱ dwii Yesu kana pi̱yau̱ a si̱ma bwii. ");
INSERT INTO wja_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Pu pma twiyongo, nu̱wa bu kangga de̱e̱ ne̱re̱ wu yaa ce̱ ci̱ye̱i̱ di̱ngi̱n yi̱ wuturindi a bo̱nggo̱ Yesu. ");
INSERT INTO wja_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Anda ku Yesu yiki wutur wii, ne̱re̱ wii toso ce̱gu̱ ci̱ye̱u̱, kana we̱ riyanga bu̱ri̱ pma ce̱ ki̱n, <<Yaa ku yi ti̱i̱ ko̱gu̱ yi̱ri̱ ci̱ka ti̱na a Israila!>> ");
INSERT INTO wja_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Anda Parisayo ce̱ ki̱n, <<Twii bagi̱ra wuturindi a nyi̱i̱ yo̱ di̱mbi̱re̱ ba yiki wuturindi.>> ");
INSERT INTO wja_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu wo̱ra go̱ro̱ndi̱ tu gi̱rai̱ yi̱ tu nyi̱ti̱ti̱. A ju̱ku̱gu̱ yi̱ri̱ngi̱ a gi̱ri̱ndi̱ ku̱ri̱ pmai, a wasi̱gu̱ ci̱ye̱i̱ du teng a dwii lau̱ Yambau̱ pero a mi̱ra nu̱wa tum yi̱ buwangi wundu wundu yi̱ bu̱ri̱ wulok pma yi̱langa. ");
INSERT INTO wja_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ku ko̱ nu̱wa ku̱ranggi̱ bu̱ri̱ tum, a nu̱u̱ bunam pmau di̱ngi̱n pma ti̱i̱gu̱ ku̱u̱lu̱ pero tetenggi, yaa ne̱re̱ wu kalanu̱ we̱i̱ pma, ci̱ka puuri su yaa taage̱. ");
INSERT INTO wja_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","A sa kwati̱mba ya ki̱n, <<Jama bu biya wa a ni̱nga tum, anda nu̱wa bu kaci̱ wa ni̱nga banyi̱na. ");
INSERT INTO wja_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Di̱ngi̱n to̱no̱, bu senggo Ne̱re̱ wu ko̱ndo̱ wa yau̱ ba tu̱mu̱we̱ nu̱wa wu̱ra wa a ko̱ndo̱ yo̱u̱.>> ");
INSERT INTO wja_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu yi̱we̱ kwati̱mba ya kwap su̱r ro̱p pwe̱yau̱ piinou, a nyi̱i̱ pma di̱mbi̱re̱ ba yiki wuturindi pero ba mi̱ra kana ko̱no̱ du buwai. ");
INSERT INTO wja_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ti̱naa dinendi nu̱wa tu̱mandi̱ wa Yesu wa bu kwap su̱r ro̱p wu gawu̱ri̱yo̱ wii Simon, (wu nu̱wa yi̱ri̱ ki̱n Bitrus) yi̱ ci̱ya yo̱ Andarawus, Yakubu bo̱l Sabadi yi̱ ci̱ya yo̱ Yohanna, ");
INSERT INTO wja_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilibus yi̱ Bartalamawus yi̱ Toma yi̱ Matayo wu yi̱ri̱ janggal, yi̱ Yakubu bo̱l Alpayo, yi̱ Tadawus, ");
INSERT INTO wja_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","yi̱ Simon wu yi̱ bwiu di̱ngi̱n si̱ma ya yi̱ Yahuda Iskariyoti wu cuu Yesu. ");
INSERT INTO wja_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Nu̱wa bu kwap su̱r ro̱p bu Yesu tu̱ma bwii a nyi̱i̱ pma di̱kace̱ne̱ ki̱n, <<Bu ambi̱r ya bo̱nggo̱ nu̱wa bu yaa yo̱o̱gi̱ nu̱wa bu Yudaya wa, yi̱ go̱ro̱ndi̱ nu̱wa bu Samariya wa. ");
INSERT INTO wja_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Bu ambi̱ra bo̱nggo̱ nu̱wa bu Israila wa bu li̱yanga ci̱ka puuri su yaa taage̱. ");
INSERT INTO wja_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ambi̱ra bu wasi̱ ci̱ye̱i̱ mi̱n, <Lau̱ ku diyou ni̱nga ne̱m!> ");
INSERT INTO wja_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Bu mi̱ra bu yaa cingcing wa, bu wumongo bu bwaanga wa, bu mi̱ra babutanga, pero bu yikongo wuturindi. Nu̱wa nyi̱i̱mbi̱ra nyo bu nyi̱i̱ya nyo. ");
INSERT INTO wja_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Bu de̱ri̱ ya sinariya yi̱ asurpa, yi̱ kana ke̱ne̱ a swari̱ mbi̱re̱, ");
INSERT INTO wja_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","bu de̱ri̱ ya swari̱ so̱ngmai̱ kana landari̱ ro̱p yi̱ paari̱, yi̱ jwalu di̱ngi̱n ne̱re̱ wu̱rai̱ a yinno nu̱wa ba nyi̱i̱ je̱e̱ndi̱. ");
INSERT INTO wja_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","<<Ka bu tembiro gwe̱i̱ du gi̱rai̱ yi̱ du banyi̱nai̱ bu kasa ne̱re̱ wu yi̱ mbi̱r we̱i̱ bu si̱ndi̱ si̱ye̱i̱ a pwii ko̱po̱ nyanggu̱ ku bu duru we̱i̱ po̱o̱ wii. ");
INSERT INTO wja_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ka bu te̱mbi̱r laa wii bu ci̱ pma. ");
INSERT INTO wja_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ka nu̱wa bu laa wii yo̱o̱ bu nyaa wa, yama pi̱dau̱ gaanggu̱ mbi̱ru̱ ba si̱ya bo̱nggo̱ pmau, ka kwaai yama pi̱dau̱ gaanggu̱ ba waata bu̱ri̱ bo̱nggo̱ mbi̱ru̱. ");
INSERT INTO wja_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Anda kana pi̱yau̱ pu nu̱wa kwaa yi̱gu̱ mbi̱ru̱ pero kwaa ba ka twiyau yi̱ mba, bu kapa gur du mwar mbi̱ri̱, ka bu du̱r gwe̱i̱ dwii. ");
INSERT INTO wja_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","N wo̱o̱ sagu̱mbi̱ru̱ ji̱re̱, a nyanggu̱ balu, Yamba nu̱u̱ we̱i̱ bunam nu̱wa bu Sodom yi̱ Gomora yiku ba nu̱u̱ bunam gwe̱i̱ dwii! ");
INSERT INTO wja_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","N wo̱o̱ tu̱mgu̱ mbi̱ru̱ ci̱ka puuri a cu̱di̱ geppindi. Bu yo̱o̱ pwi̱yangi̱ ci̱ka co̱o̱gi̱ndi̱ pero to̱k ci̱ka bamori. ");
INSERT INTO wja_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Bu si̱ndi̱ si̱ye̱i̱ ci̱pi̱gi̱ bu̱ri̱, nu̱wa re̱mbi̱ru̱ we̱i̱, ba de̱mbi̱ra laa balu pero ba wacambi̱ra we̱i̱ a gi̱ri̱ndi̱ ku̱ru̱. ");
INSERT INTO wja_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Nu̱wa de̱mbi̱ru̱ we̱i̱ gawu̱ri̱ gomnandi yi̱ balamba di̱ngi̱n mi. Anda to̱o̱ yo̱o̱ mbi̱ru̱ we̱i̱ nyinou wu bu wasi̱ri̱ we̱i̱ ci̱ye̱i̱ du teng a dwii mi a bo̱nggo̱ balamba yi̱ nu̱wa bu yaa yo̱o̱gi̱ nu̱wa bu Yudaya wa. ");
INSERT INTO wja_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ka re̱mbi̱ri̱ bo̱nggo̱ balu bu do̱mi̱ ya bu̱ri̱ mi̱n tu bu ce̱ we̱i̱ ca yi̱ kanda ku bu ce̱ wau, ka jo̱ri̱ ye̱i̱ lami̱ Yamba nyi̱i̱mbi̱ri̱ we̱i̱ tu bu ce̱ we̱i̱, ");
INSERT INTO wja_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","di̱ngi̱n bwii mba bu ce̱gu̱ ci̱ye̱i̱ ne̱ anda twii Bawei Mbaa mbi̱ri̱ a ce̱gu̱ ci̱ye̱i̱ a mi̱ri̱nggi̱ mbi̱ru̱. ");
INSERT INTO wja_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","<<Ci̱yate̱ nyi̱i̱ we̱i̱ ci̱ya yo̱ nu̱wa ba jiyo, yi̱to̱ mwa mbaate̱ yi̱ bo̱l yo̱. Kwaraa wunmanu we̱i̱ kwiimba diinu we̱i̱ nu̱wa ba laca pma.>> ");
INSERT INTO wja_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nu̱wa mwa mwa kwaambi̱ri̱ we̱i̱ di̱ngi̱n mi. Anda kana we̱ wu bo̱o̱ gaanggu̱ lam nyanggu̱ ku pungu nyi̱nggu̱ we̱i̱ mi̱rma. ");
INSERT INTO wja_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ka pma turo mbi̱ri̱ di̱na gwe̱i̱ bu cembiro du kanggi̱. N wo̱o̱ sagu̱mbi̱ru̱ ji̱re̱ yaa ku bu mati̱ we̱i̱ wo̱ru̱gu̱ go̱ro̱ndi̱ Israila Bo̱l ne̱re̱ baa we̱i̱. ");
INSERT INTO wja_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","<<Ne̱re̱ wu ti̱langgu̱ yi̱ru̱ yaa gwali̱ ku̱lu̱m yo̱, ke̱we̱ yaa gwali̱ ne̱re̱ wu gi̱ra yo̱. ");
INSERT INTO wja_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Nu̱wa bu ti̱langgu̱ yi̱ri̱ngi̱ wa a daaya ba ni̱nga ci̱ka ku̱lu̱m pmo yi̱to̱ mwa ke̱waa a daaya ba ni̱nga ci̱ka ne̱re̱ wu gi̱ra pmo. Ka nu̱wa yi̱ri̱ ne̱re̱ wu gi̱ra wu laa ki̱n, Baalsabul, gwalanga nu̱wa bu laa wii wa, nu̱wa yi̱ru̱ we̱i̱ pma yi̱ din du gwala do̱o̱! ");
INSERT INTO wja_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","<<Bu nu̱u̱ ya gwasi̱ nu̱wai̱. Yaa yi̱ri̱ tu sumgi tu nu̱wa na wumdi, pero yaa yi̱ri̱ tu tukugi tu nu̱wa na so̱ni̱. ");
INSERT INTO wja_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Yi̱ri̱ tu n sa mbi̱ru̱ ku̱me̱, bu wasi̱ri̱ we̱i̱ yi̱ nyanggu̱. Pero yi̱ri̱ tu bu se̱wai̱ a twe̱e̱ndi̱ mbi̱ri̱, bu te̱e̱ru̱ we̱i̱ dwii kani. ");
INSERT INTO wja_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Bu nu̱u̱ ya gwasi̱ nu̱wa bu ji̱ri̱ bu̱ri̱ wa anda yaa ku puu ji̱gu̱ bawei, waka bu nu̱u̱ gwasi̱ Yambai̱, yo̱ wu puu bwiyanggu mwa mwa bu̱ri̱ yi̱ bawei a pari̱ bwalai. ");
INSERT INTO wja_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Nu̱wa yaa cuuri banyi̱li̱ nyan kobo ro̱p ru? Anda yaa banyi̱li̱ su yari̱ si̱ma yaa kem yi̱ so̱mgu̱ Mbaa mbi̱ru̱. ");
INSERT INTO wja_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Kana ku̱ri̱ mbi̱ri̱ tu dwii a so̱m ku̱ci̱ ye̱i̱. ");
INSERT INTO wja_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Di̱ngi̱n to̱no̱, bu nu̱u̱ ya gwasi̱ di̱ngi̱n bu gwala banyi̱li̱ wang. ");
INSERT INTO wja_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","<<Di̱ngi̱n kana we̱ wu ce̱ cu̱du̱ nu̱wa ki̱n yo̱ wongge, mi mwa n ni̱ngi̱ we̱i̱ yi̱to̱ a gawu̱r Mbaa mi wu diyou. ");
INSERT INTO wja_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Anda kana we̱ wu gwe̱le̱ngge̱ a gawu̱ri̱ nu̱wai̱, mi mwa n gwe̱lu̱ we̱i̱ yo̱ a gawu̱ri̱ Mbaa mi wu diyou. ");
INSERT INTO wja_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Bu dangani̱ ya mi̱n n baa di̱ngi̱n n de̱e̱ pi̱dau̱ gaanggu̱ a si̱ma. Ang ang, n baa bu n de̱e̱ pi̱dau̱ gaanggu̱, anda n de̱e̱ kasi̱gar. ");
INSERT INTO wja_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","N baa n din ce̱re̱ <Cu̱du̱ ne̱re̱ yi̱ mbaa yo̱, bwe̱e̱canga yi̱ njaa yo̱, siite wu nu̱re̱, ni̱ng we̱i̱ ce̱re̱ yi̱ sii yo̱ wu nu̱re̱ ");
INSERT INTO wja_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","bace̱n mo̱ wu bwi̱i̱ye̱ yo̱ we̱i̱ a mi̱ri̱nggi̱ laa mau.> ");
INSERT INTO wja_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","<<Kana we̱ wu kangman mbaa yo̱ yi̱ njaa yo̱ gwalanggi̱ yaa ku yinno yo̱o̱gu̱ kwaa mi, ka kangman bo̱l yo̱ wu nambare̱ yi̱ wu nu̱re̱ gwalanggi̱ yaa ku yinno ba yo̱o̱ kwaa mi. ");
INSERT INTO wja_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Anda kana we̱ wu de̱ bu ye̱u̱ yo̱u̱, ba po̱nggu̱we̱ yinnibu yo̱o̱gu̱ kwaa mi. ");
INSERT INTO wja_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Kana we̱ wu nyi̱ngga pi̱i̱ma ya mandu̱ we̱i̱ si̱yau̱, kana we̱ wu mansi̱ ye̱i̱ pi̱i̱ma ya di̱ngi̱n mi nyi̱nggu̱ we̱i̱. ");
INSERT INTO wja_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","<<Kana we̱ wu yi̱mbi̱ra a yi̱ngge̱, kana we̱ wu yi̱ngge̱ a yi̱ wu tu̱mgu̱we̱. ");
INSERT INTO wja_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Kana we̱ wu yi̱ banabi̱, di̱ngi̱n twii banabi̱, yo̱ yi̱ri̱ we̱i̱ wo̱ri̱ri̱ banabi̱. Pero kana we̱ wu yi̱ ne̱re̱ wu nyaa di̱ngi̱n twii ne̱re̱ wu nyaa yi̱ri̱ we̱i̱ wo̱ri̱ri̱ ne̱re̱ wu nyaa. ");
INSERT INTO wja_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Kana we̱ wu puu gundu naagu wu wiino wu banyi̱na a mi̱ri̱nggi̱ bu yo̱o̱gi̱ kwati̱mba muwa, n wo̱o̱ sagu̱mbi̱ru̱ ji̱re̱, yi̱ru̱ we̱i̱ wo̱ri̱ri̱ ye̱i̱.>> ");
INSERT INTO wja_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Go̱ro̱ pu Yesu mata nyi̱i̱gu̱ kwati̱mba ya di̱kace̱ne̱, a du po̱o̱ wii a mwati̱ go̱ro̱ndi̱ tu ne̱m a wasi̱gu̱ ci̱ye̱u̱ yi̱ ju̱ku̱gu̱ yi̱ri̱ngi̱. ");
INSERT INTO wja_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Pu Yohanna wo̱o̱ jaru̱m a nu̱u̱ yi̱ri̱ngi̱ tu Masiya ni̱nggu̱, a tu̱m kwati̱mba ya, ");
INSERT INTO wja_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ba pi̱ra Yesu ki̱n, <<Wo̱o̱ mo̱ wu bagu̱ wii ru? Yikwii yi yam wu kanggu̱ ru?>> ");
INSERT INTO wja_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesu sa pma ki̱n, <<Bu waatanga bu sa Yohanna yi̱ri̱ngi̱ tu bu nu̱u̱ wai yi̱ yi̱ri̱ngi̱ tu bu ko̱i̱, ");
INSERT INTO wja_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","kerma bo̱o̱ ko̱gu̱ si̱mau̱, gu̱wo̱ngi̱ bo̱o̱ ni̱nggu̱ so̱ngmau̱, babutanga bo̱o̱ yi̱langgu̱, bapi̱mba bo̱o̱ nu̱u̱gu̱ si̱mau̱, nu̱wa bu bwaanggi̱ wa a wunonggu yi̱ pi̱i̱ma, pero nu̱wa bo̱o̱ wasi̱man ci̱ye̱i̱ du teng baku̱u̱lu̱wa. ");
INSERT INTO wja_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Yamba diiman wuure pma bu waatan bu yi̱ go̱ro̱u̱ di̱ngi̱n mi wa.>> ");
INSERT INTO wja_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Pu kwati̱mba Yohanna wa mwatanga, Yesu toso sagu̱ ci̱ye̱i̱ nu̱wa bu ku̱ranggi̱ bu̱ri̱ wa a dwii Yohanna, <<Bu ambi̱ra su̱gu̱ ca a gu̱lai̱? Bu ambi̱ra su̱gu̱ si̱yang tu co̱ku̱ro̱k tu wutur mwangu ru? ");
INSERT INTO wja_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ka yaa yi̱to̱ ne̱ bu twiyongo bu ko̱ ca ki̱? Ne̱re̱ wu pargi̱ se̱e̱ wu nyaa ru? Yaa yi̱to̱ nu̱wa bu pari̱ se̱e̱ wu nyaa bo̱o̱ caame̱ balambai. ");
INSERT INTO wja_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Mi̱n na, bu twiyongo bu ambi̱ra su̱gu̱ cau? Banabi̱ ru? N wo̱o̱ sagu̱mbi̱ru̱, yo̱ a gwala banabi̱. ");
INSERT INTO wja_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Wunaa yo̱ Yohanna wu Lakargar Yamba ce̱ ci̱ye̱i̱ dwii ye̱i̱ ki̱n, <N tu̱mmo̱ we̱i̱ ne̱re̱ tu̱mandi̱ mi gawu̱ri̱yo̱ yi̱ mo̱, wii yo̱ cardu we̱i̱ nyinou di̱ngi̱n bagu̱ mo̱u̱.> ");
INSERT INTO wja_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","N wo̱o̱ sagu̱mbi̱ru̱ ji̱re̱ a mi̱ri̱nggu̱ nu̱wa bu nu̱ru̱mba bi pma wa, yaa wu gwala Yohanna wu Ni̱ng Bati̱si̱ma yi̱ gi̱ru̱. Anda wu banyi̱na a lau̱ ku diyou Yambau̱ a gwala Yohanna yi̱ gi̱ru̱. ");
INSERT INTO wja_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Toso jo̱r du Yohanna wu Ni̱ng Bati̱si̱ma wasi̱ ci̱ye̱i̱, baa di̱na jo̱re̱ lau̱ ku diyou a ti̱i̱ ku̱u̱le̱, nu̱wa bu bwi̱i̱ wa kasa ba je̱e̱ yi̱ di̱mbi̱re̱. ");
INSERT INTO wja_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Mwa mwa banabi̱ndi̱ yi̱ te̱e̱ri̱ngi̱ Musa a ce̱ ci̱ye̱i̱ dwii lau̱ ku diyou ko̱po̱ jo̱r Yohanna, ");
INSERT INTO wja_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ka bu kasi̱ bu yi̱ ci̱ye̱i̱ dwii we̱i̱, Yohanna wo̱o̱ Iliya, wu banabi̱ndi̱ ce̱ bagu̱ yo̱u̱. ");
INSERT INTO wja_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Yama ne̱re̱ wii twendi di̱ngi̱n nu̱u̱gu̱, ba ka twiyau. ");
INSERT INTO wja_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Anda Yesu je̱ gawu̱re̱ yi̱ ci̱ye̱i̱ ki̱n, <<N ci̱pi̱ranu̱ we̱i̱ nu̱wa bu si̱na daandi yi̱ ca? Pma ci̱ka bakwara pi̱si̱ndi̱ nyan lummou. A yi̱yanggu̱ bu̱ri̱ pmai a ce̱gu̱ ki̱n, ");
INSERT INTO wja_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","<Yi wuu mbi̱ri̱ bagaati, bu kwa sigu ko̱lo̱u̱! Yi pi̱i̱ mbi̱ri̱ pi̱i̱ bo̱o̱ri̱, bu kwaa wiye.> ");
INSERT INTO wja_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Pu Yohanna baa yaa je̱e̱ je̱e̱ndi̱, yaa naa gundu inabi, anda bu ce̱gu̱ mi̱n, yo̱ wo̱o̱ yi̱ wuture. ");
INSERT INTO wja_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Bo̱l Ne̱re̱ a ba a je̱gu̱ a naagu, bu ce̱gu̱ mi̱n, <Su̱wa yo̱ wo̱o̱ yi̱ swawu a je̱gu̱, a naagu, yo̱ yo̱o̱gi̱ basi̱n nu̱wa bu yi̱ri̱ janggal wa, yi̱ nu̱wa bu yi̱ we̱le̱m wa.> Anda pwi̱i̱ Yambai̱ ju̱ku̱r ki̱n twii ji̱re̱ a bo̱nggo̱ wu̱rang ye̱i̱. ");
INSERT INTO wja_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Nu̱wa bu go̱ro̱ndi̱ tu Yesu ni̱nga yi̱ri̱ngi̱ ri̱yandi̱ bu̱ri̱ tum dwii yaa ku ni̱nga bwiiwau, di̱ngi̱n to̱no̱ a ye̱re̱nga gwe̱i̱ dwii. ");
INSERT INTO wja_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","<<Ai mba! Nu̱wa bu Korasin. Ai mba! Nu̱wa bu Betsaida! Di̱ngi̱n wu̱rang ri̱yandi̱ bu̱ri̱ tu nu̱wa ni̱nga a mi̱ri̱nggi̱ mbi̱ri̱, ka nu̱wa na ni̱nga a Taya yi̱ Sidon we̱i̱, pma na ni̱nga bwiiwa ki̱lang, na te̱e̱ gusuringi pero na parni̱ buro dwii pmai! ");
INSERT INTO wja_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","N wo̱o̱ sagu̱mbi̱ru̱, a nyanggu̱ balu, Yamba nu̱u̱ we̱i̱ bunam nu̱wa bu Taya yi̱ Sidon yiku ba nu̱u̱ bunam mbi̱ru̱. ");
INSERT INTO wja_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Bi̱ka nu̱wa bu Kaparnahum, bu dangani̱ mi̱n nu̱wa de̱mbi̱ri̱ we̱i̱ diyou ru? Kana banyi̱na, waka nu̱wa julumbiri we̱i̱ Hades! Ka yi̱ri̱ngi̱ ri̱yandi̱ bu̱ri̱ tu nu̱wa ni̱ngai̱ a bo̱nggo̱ mo̱, ka na ni̱ngwa Sodom wai, reni pma na bo̱o̱! ");
INSERT INTO wja_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","N wo̱o̱ sagu̱mbi̱ru̱ a nyanggu̱ balu, Yamba nu̱u̱ we̱i̱ bunam gwe̱i̱ Sodom yiku ba nu̱u̱ bunam mbi̱ru̱. ");
INSERT INTO wja_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","A dwii jo̱re̱ Yesu ce̱ ku̱ru̱ ki̱n, <<Mbaa, mo̱ Mbaa Wu Gi̱ra wu yi̱ diyou yi̱ si̱ma, n wanami̱na, di̱ngi̱n mo̱ tuko ti̱na yi̱ri̱ngi̱ a bo̱nggo̱ pma bu pwi̱yanggi̱ wa yi̱ bu yi̱ so̱mandi̱, anda mo̱ ju̱ku̱ bakwara bu nyi̱ti̱ti̱ wa. ");
INSERT INTO wja_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Yi̱to̱ Mbaa, to̱o̱ yi̱ri̱ngi̱ ni̱ngwa ci̱ka ku̱ mo̱ kasu̱. ");
INSERT INTO wja_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Mbaa mi nyi̱i̱nggi̱ yi̱ri̱ngi̱ mwa mwa. Yaa ne̱re̱ wu so̱m Bwi̱ya wii bu̱r Mbaate̱, pero yaa wu so̱m Mbaate̱ bu̱r Bwi̱ya wii yi̱ bu Bwi̱ya wii kasa ba ju̱ku̱ pma Mbaa yo̱. ");
INSERT INTO wja_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","<<Bambe̱ bo̱nggo̱ mu, mba bu janganga pero de̱e̱gi̱ se̱e̱ ko̱mbu̱ro̱m wa, n nyi̱i̱ mbi̱r we̱i̱ yo̱ro̱nggu̱. ");
INSERT INTO wja_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Bu de̱e̱ sou garama mu pero bu ti̱langa bo̱nggo̱ mu di̱ngi̱n n bu̱bu̱k yi̱ dwii du ci̱nggai̱, pero bu nyi̱nggu̱ we̱i̱ yo̱ro̱nggu̱ bo̱nggo̱ bawei. ");
INSERT INTO wja_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Di̱ngi̱n sou garama mu yaa ko̱mbu̱ro̱m, se̱e̱ wu n ce̱ri̱ mbi̱ri̱ we̱i̱ saki̱rak.>> ");
INSERT INTO wja_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","A dwii jo̱re̱ Yesu so̱ngma a ko̱o̱ndi̱ alkama nyanggu̱ sabadu, kwati̱mba ya nu̱u̱ ju̱ne̱ pma co̱ra alkama a woo. ");
INSERT INTO wja_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ku Parisayo ko̱, pma sa Yesu ki̱n, <<Su̱wa! Kwati̱mba ma ni̱nggu̱ yi̱ri̱ tu te̱e̱ri̱ yiri je̱e̱ ki̱n nu̱wa ba ni̱ng ya nyanggu̱ sabadu!>> ");
INSERT INTO wja_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","A le̱e̱man pma ki̱n, <<Celeke bu tii bu ce̱gu̱ yi̱ri̱ tu Dawud ni̱nga pu yo̱ nu̱u̱ ju̱ne̱ yi̱ basi̱nba so̱ngma ya wa ru? ");
INSERT INTO wja_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Yo̱ diiro Laa Yambau̱, yo̱ yi̱ barauwa ya pma je̱e̱ ku̱maa wu co̱o̱gi̱, kana ku te̱e̱re̱ je̱u̱ pma ba je̱e̱ ya, bu̱r kuruwa Yamba wa ba je̱e̱. ");
INSERT INTO wja_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Pero yaa ku bu tii bu ce̱gu̱ mi̱ri̱nggi̱ te̱e̱re̱ Musa ki̱n kuruwa Yamba wa pma pari̱ te̱e̱re̱ a laa Yambau̱ nyanggu̱ sabadu anda kana yi̱to̱ pma yaa we̱le̱m. ");
INSERT INTO wja_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","N wo̱o̱ sagu̱mbi̱ru̱ wo̱o̱ yi̱ wu kangge̱ a pi̱na wu gwala Laa Yambau̱ yi̱ gi̱ru̱. ");
INSERT INTO wja_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Lakargar Yamba ce̱ ki̱n, <Tu n kasi̱ twii nu̱wa ba ju̱ki̱ bunam, twii nyi̱i̱gu̱ ni̱i̱ ne̱,> ka bu so̱m to̱o̱ yi̱ri̱ngi̱ yaa ku bu ni̱ngamanu̱ we̱i̱ nu̱wa bali̱ mi̱n yi̱ we̱le̱m anda yaa we̱le̱m. ");
INSERT INTO wja_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Di̱ngi̱n Bo̱l Ne̱re̱ twii Mbaa Wu Gi̱ra nyanggu̱ sabadu.>> ");
INSERT INTO wja_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Pu Yesu du po̱o̱ wii, a aara diiro gi̱re̱ng ku̱ru̱ pma, ");
INSERT INTO wja_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","wo̱o̱ yi̱ ne̱re̱ wu wai bo̱rgi̱ pwii. Pma dwaagu ba nyi̱ngga yo̱ yi̱ we̱le̱m. Pma pi̱ra yo̱ ki̱n, <<Te̱e̱re̱ yiri je̱e̱ nu̱wa ba mi̱ri̱ ya ne̱re̱ nyanggu̱ Sabadu ru?>> ");
INSERT INTO wja_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Anda a le̱e̱ man pma ki̱n, <<Yikwii wii we̱ a cu̱du̱ mbi̱ri̱ ka puuri yo̱ yanni̱ bo̱u̱ nyanggu̱ sabadu na taa ba yiki we̱? ");
INSERT INTO wja_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Anda ne̱re̱ gwala bu puure kwaara ru? O̱ng te̱e̱re̱ le̱e̱ ne̱re̱ ba ni̱nga yi̱ri̱ngi̱ tu nyaayi nyanggu̱ sabadu.>> ");
INSERT INTO wja_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Bur a sa ne̱re̱ wii ki̱n, <<Tari̱ wai mo̱u̱.>> Ne̱re̱ wii tari̱ wai yo̱u̱, bur wai yo̱u̱ waata bu̱ri̱ cingcing ci̱ka wu kanggu̱ wii! ");
INSERT INTO wja_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Anda Parisayo a twiyongo twalange̱ palaka ba kasa nyindi su pmai jiru we̱i̱ Yesu. ");
INSERT INTO wja_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesu so̱m tu pma kasi̱gu̱ ni̱nggi̱. Di̱ngi̱n to̱no̱ a du po̱o̱ wii, nu̱wa tum po̱ng yo̱. A mi̱ra pma bu yaa cingcing wa mwa mwa, pma yi̱langa. ");
INSERT INTO wja_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","A nyi̱i̱ pma di̱kace̱ne̱ ki̱n, ba ce̱ ya ka yo̱ we̱ we̱i̱. ");
INSERT INTO wja_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","To̱o̱ a twanga yi̱ri̱ tu banabi̱ Icaya ce̱ a dwii ye̱i̱ ki̱n, ");
INSERT INTO wja_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","<<Su̱wa ke̱we̱ mi wu n se̱ka. Wii yo̱ wu n kangman yo̱, wu di̱rangi̱n gaanggu̱. N diinu we̱i̱ Bawei mi a mi̱ri̱nggi̱ ye̱i̱, anda yo̱ sar we̱i̱ ji̱re̱ nu̱wa bu si̱ma wa. ");
INSERT INTO wja_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Yaa ku ni̱ngu̱ we̱i̱ gwe̱la kana ba wun miu yo̱u̱ a nyindi. ");
INSERT INTO wja_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Yaa ku pe̱nu̱ we̱i̱ bu yaa cingcing wa, kana ba nu̱u̱ bu̱u̱ nu̱wa bu yaa di̱mbi̱re̱ wa, ko̱po̱ ka diini ji̱re̱i̱ je̱ gawu̱re̱. ");
INSERT INTO wja_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Anda mi̱ri̱nggi̱ din ye̱i̱ nu̱wa bu si̱ma wa mannu̱ we̱i̱ ni̱i̱. ");
INSERT INTO wja_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","A dwii jo̱re̱ pma de̱mu̱we̱ Yesu ne̱re̱ wu kangge̱ wu yi̱ wuturindi twii kermo pero yaa ce̱ ci̱ye̱i̱. Yesu mi̱ra ne̱re̱ wii palaka ba ko̱ pero ba nu̱u̱ si̱ma. ");
INSERT INTO wja_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nu̱wa bwii riyanga bu̱ri̱ a pi̱ra ki̱n, <<Yikwii wo̱o̱ Yesu Bo̱l Dawud ru?>> ");
INSERT INTO wja_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Anda ku Parisayo nu̱wa yi̱to̱ pma ce̱ ki̱n, <<Mwe̱le̱, ne̱re̱ wo̱, wo̱o̱ Baalsabul ti̱bak, bagi̱ra wuturindi, a nyi̱i̱ yo̱ di̱mbi̱re̱ ba yiki wuturindi.>> ");
INSERT INTO wja_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Anda Yesu ku̱ranga dangandi̱ pmai, yo̱ sa pma ki̱n, <<Kana ko̱no̱ lau̱ ku̱ cwaanga bu̱ri̱ ro̱p bagu̱ ce̱re̱ yi̱ bu̱ri̱ pmai, ko̱ lau̱ bwi̱i̱ru̱ we̱i̱, yi̱to̱ mwa yi̱ kana do̱no̱ gwe̱i̱ kana laa ka cwaani bu̱ri̱ bagu̱ ce̱re̱ yi̱ bu̱ri̱ pmai wo̱ laa na ti̱n ti̱ye̱i̱. ");
INSERT INTO wja_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Anda ka Balaa Buwai yikir Balaa Buwai, a cwaanga bu̱ri̱ ye̱i̱, a bagu̱ ce̱re̱ yi̱ dwii ye̱i̱. Lau̱ yo̱u̱ ni̱ng we̱i̱ nye̱ ba ti̱n ti̱yau̱? ");
INSERT INTO wja_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ka n yikigu wuturindi yi̱ di̱mbi̱re̱ Baalsabul we̱i̱, nu̱wa mba re̱i̱? Pma yikiri yi̱ di̱mbi̱r we̱? Di̱ngi̱n to̱no̱, pma ni̱ngi̱ mbi̱ru̱ we̱i̱ bali̱. ");
INSERT INTO wja_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Anda ka n yikiri wuturindi yi̱ di̱mbi̱ri̱ Bawei Yamba wai, lau̱ Yambau̱ baa dwii mbi̱ri̱. ");
INSERT INTO wja_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Bang bang, yaa ne̱ru̱ wu puu we̱i̱ dimma laa ne̱re̱ wu yi̱ di̱mbi̱re̱ ba de̱e̱ se̱e̱ yo̱, ko̱po̱ ka twali ne̱ru̱ wu di̱mbi̱r wii bati̱, anda ba puu de̱gu̱ se̱e̱ yo̱. ");
INSERT INTO wja_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ne̱re̱ wu yaa kem yi̱ mi, yo̱ bagu̱ ce̱re̱ yi̱ mi, ne̱re̱ wu kalanggu̱ bu ku̱ranggu̱, yo̱ we̱e̱nggu̱ si̱yau̱. ");
INSERT INTO wja_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","<<Di̱ngi̱n to̱no̱ n sagu̱mbi̱ru̱, Yamba paramanu we̱i̱ sukom we̱le̱mdi̱ nu̱wa yi̱ kana ca tu bwi̱i̱ tu pma ce̱ we̱i̱, anda kana we̱ wu ce̱ ci̱ye̱i̱ du bwi̱i̱ a dwii Bawei du Walwal, Yamba na paraman yo̱ sukom we̱le̱m yo̱u̱. ");
INSERT INTO wja_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Kana we̱ wu ce̱ ci̱ye̱i̱ du bwi̱i̱ a dwii Bo̱l Ne̱re̱ Yamba paramanu we̱i̱ yo̱ sukom we̱le̱m yo̱u̱, anda kana we̱ wu ce̱ ci̱ye̱i̱ du bwi̱i̱ a dwii Bawei du Walwal Yamba na paraman yo̱ sukom we̱le̱m yo̱u̱, kana si̱na daandi kana daandi su baai̱. ");
INSERT INTO wja_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","<<Nu̱wa ku̱ran sou bo̱nggo̱ tutwiyari ye̱i̱. Ka sou kundi tutwiyari ye̱i̱ ni̱ngu̱ we̱i̱ kundi. Ka sou yaa kundi ne̱, tutwiyari ye̱i̱ na ni̱ngi̱ kundi. ");
INSERT INTO wja_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mba co̱o̱gi̱ndi̱ su bwi̱i̱! Ni̱ndu̱ we̱i̱ nye̱ nu̱wa bu bwi̱i̱wa ci̱ka mba ba ce̱ tu kundi? Yi̱ri̱ng tu ne̱re̱ ci̱ye̱i̱ twiiwei mi̱ri̱nggu̱ gaanggu̱ yo̱u̱. ");
INSERT INTO wja_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ne̱re̱ wu nyaa ni̱ng wu̱rang tu nyaayi, di̱ngi̱n wu̱rang tu nyaayi twiiwei mi̱ri̱nggu̱ gaanggu̱ yo̱u̱. Ne̱re̱ wu bwi̱i̱ye̱ ni̱ng wu̱rang tu bwi̱i̱, di̱ngi̱n wu̱rang tu bwi̱i̱ twiiwei mi̱ri̱nggu̱ gaanggu̱ yo̱u̱ ku̱ bwi̱u̱. ");
INSERT INTO wja_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Anda n wo̱o̱ sagu̱mbi̱ru̱, a nyanggu̱ balu nu̱wa nyi̱i̱ we̱i̱ le̱e̱ a dwii kana do̱no̱ ci̱ye̱i̱ du nyoi du pma ce̱i̱. ");
INSERT INTO wja_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Di̱ngi̱n go̱n ci̱ye̱i̱ du bu ce̱i̱ pe̱ra mbi̱r we̱i̱ bo̱nggo̱ bali̱ pero twala mbi̱r we̱i̱ bo̱nggo̱ balu.>> ");
INSERT INTO wja_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Nyanggu̱ ku kanggu̱ ku̱lu̱mba te̱e̱ri̱ngi̱ wa yi̱ Parisayo pma baanga bo̱nggo̱ Yesu a ce̱ ki̱n, <<Ku̱lu̱me̱, yi kasi̱ ma ju̱ku̱ yir somdi yi̱ri̱ ri̱yandi̱ bu̱ri̱.>> ");
INSERT INTO wja_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yesu nyi̱i̱ pma le̱e̱ ki̱n, <<Mba nu̱wa bu bwi̱i̱ wa bu si̱naa daandi wa, bu yaa gwasi̱ Yamba wa, bu kasi̱ yi̱ri̱ somdi ri̱yandi̱ bu̱ri̱, yaa ku n ni̱ngambi̱ri̱ somdi ri̱yandi̱ bu̱ri̱ ka gwal tu banabi̱ Yunana. ");
INSERT INTO wja_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Di̱ngi̱n ci̱ka ku Yunana wo̱o̱ pwii jingne wu dudu yo̱ nyan daa kunong yi̱ ku̱m kunong, yi̱to̱ Bo̱l Ne̱re̱ ni̱ngu̱ we̱i̱ daa kunong mi̱ri̱nggu̱ si̱ma nyanggu̱ yi̱ ku̱me̱. ");
INSERT INTO wja_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nu̱wa bu Ninebe wa baa ti̱ndi̱ ti̱yandi̱ kem yi̱ mba nu̱wa bu si̱na daandi wa a nyanggu̱ ku̱ Yamba ni̱ngamanu̱ we̱i̱ bali̱ nu̱wa, pma sambi̱ri̱ we̱i̱ ki̱n be̱e̱ we̱le̱m, di̱ngi̱n pma ni̱nga bwiiwa a jo̱r du Yunana wasi̱man pma ci̱ye̱i̱ Yambai̱, ne̱re̱ wu gwala Yunana wo̱o̱ pi̱na. ");
INSERT INTO wja_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Balaa wu nu̱re̱ wu si̱ma bu taadi wa, ba ti̱ro̱ ti̱ye̱i̱ kem yi̱ mba nu̱wa bu si̱na daandi a nyanggu̱ ku̱ Yamba ni̱ngamanu̱ we̱i̱ bali̱ nu̱wa, yo̱ sambi̱ri̱ we̱i̱ ki̱n be̱e̱ we̱le̱m, di̱ngi̱n yo̱ du̱we̱ si̱ma ya kwaara di̱ngi̱n ba baa nu̱u̱ pwi̱i̱ Balaa Solomon, anda ne̱re̱ wu gwala Solomon wo̱o̱ pi̱na. ");
INSERT INTO wja_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","<<Ka wutur twii bu̱ri̱ ne̱ri̱, mwatir pu yaa gundu a kasanggu̱ pu yo̱ro̱nu̱. Ka yo̱ ki̱ngga bu ne̱, ");
INSERT INTO wja_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","yo̱ ba ce̱ ki̱n, <N waatu we̱i̱ bu̱ri̱ a laa mu wu n twiiwe mi̱ru̱.> Ka baa ki̱nggi̱ laa wii candi̱gi̱, pero me̱ne̱ngi̱ yaa tu kanggi̱, ");
INSERT INTO wja_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","bur yo̱ ba waata ba de̱ kapi̱na wuturindi a nibiyo su gwala yo̱ yi̱ tu̱we̱ baa ba si̱ndi̱ si̱yau̱ a pwii. Cwata go̱ro̱ yo̱u̱, pi̱su̱ ne̱re̱ wii gwalu we̱i̱ pi̱su̱ yo̱u̱ wu gawu̱ri̱yo̱ yi̱ bwi̱i̱ge̱. Ti̱naa kanda ku ni̱ndi̱ we̱i̱ yi̱ pma nu̱wa bu bwi̱i̱wa bu si̱na daandi wa.>> ");
INSERT INTO wja_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Pu Yesu wo̱o̱ ce̱gu̱ ci̱ye̱i̱ yi̱ nu̱wa tum njaa yo̱ yi̱ ci̱yamba ya bo̱o̱ pi̱ti̱ndi̱ twalange̱, kasi̱ ba sa ci̱ye̱i̱. ");
INSERT INTO wja_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Wu kangge̱ cu̱du̱ pmai sa Yesu ki̱n <<Njaa mo̱ yi̱ ci̱yamba ma bo̱o̱ pi̱ti̱ndi̱ twalange̱ kasi̱gu̱ ba ce̱ ci̱ye̱i̱ yi̱ mo̱.>> ");
INSERT INTO wja_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesu pi̱ra ki̱n, <<Njaa mi wii we̱? Ci̱yamba muwa bwii bu we̱? ");
INSERT INTO wja_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Bur a juka kwati̱mba ya a ce̱ ki̱n, <<Bu su̱wa ti̱na njaa mi yi̱ ci̱yamba muwa. ");
INSERT INTO wja_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Kana we̱ wu tu̱m dangandi̱ Mbaa mi wu diyou twii ci̱ya mi wu nu̱re̱ yi̱ wu nambare̱ yi̱ njaa mi!>> ");
INSERT INTO wja_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","A nyanggu̱ kwii Yesu duu laa wii a mwati̱ a si̱n si̱yau̱ gi̱ng kali̱nggu̱. ");
INSERT INTO wja_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Nu̱wa tum ku̱ranga bu̱ri̱ bo̱nggo̱ yo̱u̱, di̱ngi̱n to̱no̱ a geero konggoru, a si̱n si̱yau̱ pwii. Nu̱wa pma ka pi̱ti̱ndi̱ gi̱ngu̱. ");
INSERT INTO wja_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","A sa pma yi̱ri̱ngi̱ tum yi̱ balanggu̱ ci̱ye̱u̱ ki̱n, <<Bu ka twiyau! Ne̱re̱ wu kangge̱ a de̱ duu aara waci̱gu̱ ko̱ndo̱ yo̱u̱. ");
INSERT INTO wja_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Pu wo̱o̱ waci̱gu̱ duu kwii, go̱ma bu kangga yaramana dwii nyinou, yidi baa kwama. ");
INSERT INTO wja_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Bu kangga yaramana pu yi̱ swari̱ngi̱, pu yi̱ swai banyi̱na. A boro ki̱lang ki̱lang di̱ngi̱n swai dwii yaa tum. ");
INSERT INTO wja_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Anda pu nyanggu̱ biya a ku̱su̱wa di̱ngi̱n yaa swandi. ");
INSERT INTO wja_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Go̱ma bu kangga yaramana pu yi̱ tu̱ri̱, tu̱ri̱ twii gi̱ra, a ki̱canga pma. ");
INSERT INTO wja_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Go̱ma bu kangga do̱ng yaramana si̱ma bu nyaa wa, a biyo a gwala tu nu̱wa waci̱ daa kuno kunong yi̱ kun no̱ko̱no̱, yi̱ wo̱o̱n wo̱o̱n. ");
INSERT INTO wja_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yama ne̱re̱ wii twendi di̱ngi̱n nu̱u̱gu̱, ba ka twiyau.>> ");
INSERT INTO wja_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Kwati̱mba ya baanga pi̱ra yo̱ ki̱n, <<Di̱ngi̱n ca ma ce̱e̱ ci̱ye̱i̱ yi̱ balanggu̱ ci̱ye̱u̱ ka ma pi̱rgu̱ yi̱ri̱ nu̱wa?>> ");
INSERT INTO wja_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesu nyi̱i̱ le̱e̱ ki̱n, <<Mba, Yamba le̱e̱mbi̱ra, bu so̱m tu tukugi tu lau̱ ku diyou, anda bu kangga yaa yi̱to̱. ");
INSERT INTO wja_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kana we̱ wu wo̱o̱ yi̱ to̱no̱ nu̱wa cwatamanu we̱i̱ yo̱ ba ni̱nga tum. Kana we̱ wu yaa yi̱ri̱ do̱ng, kana tu wo̱o̱ yi̱ to̱no̱i̱ nu̱wa yi̱yamanu̱ we̱i̱ yo̱. ");
INSERT INTO wja_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","To̱o̱ tu diinai n ni̱ndi̱ wu̱rai̱ yi̱ ci̱ye̱i̱ du balanggai̱, Di̱ngi̱n pma su̱wi̱, anda pma yaa kwe̱e̱yi̱. Pma nu̱wi̱, anda yaa kar twiyau kana ba ku̱ranga. ");
INSERT INTO wja_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","A twanga tu banabi̱ Icaya ce̱ a dwii pma ki̱n, Bu ni̱ng we̱i̱ pu nu̱u̱gu̱ anda bu ku̱rani̱, Bu ni̱ng we̱i̱ pu su̱u̱gu̱ anda bu kwe̱i̱. ");
INSERT INTO wja_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Di̱ngi̱n nu̱wa bo̱o̱ gaanggi̱ri̱ pmai cingcing pero twendi pmai yaa nu̱u̱ si̱ma, pma lakanga nundu pmai. Ka yi̱to̱ ne̱ pma kwe̱e̱ we̱i̱ si̱ma yi̱ nundi pmai, pero nu̱u̱ we̱i̱ si̱ma yi̱ twendi pmai, ba ku̱ranga yi̱ gaanggi̱ri̱ pmai, ba waatanga bo̱nggo̱ mu palaka n mi̱ra pma.> ");
INSERT INTO wja_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","<<Anda wuure bo̱nggo̱ nundi mbi̱ri̱ di̱ngi̱n bu kwe̱e̱yi̱ pero twendi mbi̱ri̱ nu̱u̱wi̱. ");
INSERT INTO wja_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","N wo̱o̱ sagu̱mbi̱ru̱ ji̱re̱i̱, banabi̱ndi̱ tum yi̱ nu̱wa bu nyaa wa tum kasa ko̱gu̱ yi̱ri̱ngi̱ tu bu ko̱gu̱ ti̱na anda pma ko̱ bu, a kasa pmai nu̱u̱ yi̱ri̱ngi̱ tu bu nu̱u̱gu̱, anda pma nu̱u̱ bu. ");
INSERT INTO wja_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","<<Yo̱ko̱ bu ka twiyau pi̱ti̱ndi̱ ci̱ye̱i̱ du balanggai̱ dwii bajo̱o̱me̱ a pi̱gu̱ yi̱ru̱. ");
INSERT INTO wja_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Go̱ma bu yaramana a nyinou wa twii nu̱wa bu nu̱u̱ ci̱ye̱i̱ lau̱ diyou anda yaa ku ku̱rangau̱ . Bur Balaa Buwai ba a yi̱yaman si̱ye̱i̱ a mi̱ri̱nggi̱ gaanggu̱ pma. ");
INSERT INTO wja_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Go̱ma bu dwii swari̱ngi̱ wa twii nu̱wa bu nu̱u̱ ci̱ye̱i̱ dwii, a yi̱ya yo̱ko̱ yo̱ko̱ yi̱ bu̱ri̱ de̱gde̱g. ");
INSERT INTO wja_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Anda yake̱ ku yaa swandi ko̱, yaa ku si̱ya wang. Pu ku̱u̱lu̱ yi̱ cu̱su̱gu̱ bammanu̱we̱ pma di̱ngi̱n ci̱ye̱i̱ dwii, yo̱ko̱ yo̱ko̱ pma ba yaranga. ");
INSERT INTO wja_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Go̱ma bu yaramana mi̱ri̱nggi̱ tu̱ri̱ wa twii nu̱wa bu nu̱u̱ ci̱ye̱i̱ Yambai̱, anda dangandi̱ se̱e̱ wu si̱ma yi̱ gi̱na a we̱le̱nga, a gwala di̱mbi̱ri̱ ci̱ye̱i̱ dwii a ja ni̱nggu̱ go̱mau̱. ");
INSERT INTO wja_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Go̱ma bu yaramana swai du nyaayi twii nu̱wa bu nu̱u̱ ci̱ye̱i̱ Yambai̱ a ku̱ranga. Wii wu bi go̱ma kuno kunong yi̱ kun no̱ko̱no̱, yi̱ wo̱o̱ndi̱ a gwala ku nu̱wa pi̱yau̱!>> ");
INSERT INTO wja_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu nyi̱i̱ balanggu̱ ci̱ye̱u̱ ku kanggu̱ ki̱n, <<Lau̱ ku diyou ci̱ka bajo̱me̱ wu pi̱i̱ duu ku nyaau a ko̱ndo̱u̱ yo̱u̱. ");
INSERT INTO wja_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Anda ku nu̱wa bo̱o̱ diima yi̱ ku̱me̱, bace̱n yo̱ ba pi̱i̱ ku̱le̱ a mi̱ri̱nggi̱ alkama wii a li̱ya mwati̱. ");
INSERT INTO wja_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Pu gi̱ra̱u̱ a te̱e̱n go̱ma, ku̱le̱ dwii mwaasi̱ a twiyo. ");
INSERT INTO wja_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ke̱waa ne̱re̱ wu ko̱ndo̱u̱ we̱ yo̱u̱ anda sa yo̱ ki̱n, <Ne̱re̱ wu gi̱ra, tu ma pi̱ya twii duu ku nyaau ne̱ ru? Anda na ku̱le̱ wuna twiiwe pi̱yau̱?> ");
INSERT INTO wja_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","<<Bajo̱me̱ wii ce̱ ki̱n, <Twii bace̱nte̱ ni̱nga yi̱to̱!> Pma ce̱ ki̱n, <Yi aanda yi podo ru?> ");
INSERT INTO wja_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","A sa pma ki̱n, <Ka bu ni̱ngi̱ yi̱to̱, bu podo we̱i̱ alkama. ");
INSERT INTO wja_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Bu du pma ba gi̱ranga kem ko̱po̱ nyanggu̱ kaci̱gi̱. N saru we̱i̱ nu̱wa wu̱rai̱ wa a jo̱r kaci̱gi̱ dwii pma ba se̱ka ku̱le̱ wii, ba bwe̱e̱nga gwe̱le̱ndi̱ gwe̱le̱ndi̱ ba taa, ba te̱e̱ni̱ alkama mi a bindou.>>> ");
INSERT INTO wja_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Pero Yesu sa pma balanggu̱ ce̱u̱ du kanggu̱ ki̱n, <<Lau̱ ku diyou ci̱ka go̱n mustad du ne̱re̱ wu kangge̱ de̱ aara pi̱ya a ko̱ndo̱u̱ yo̱u̱. ");
INSERT INTO wja_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Kana ku to̱o̱ go̱n duu du banyi̱nai̱ a mi̱ri̱nggi̱ duu mwa mwa, anda ka gi̱ri̱ gwali̱ kana ko̱no̱ duu wandi̱ ali̱, pero ba yo̱o̱ sou. Yidi baangai̱ ba cwaani cwaaringi pmai a be̱ti̱ndi̱ ye̱i̱.>> ");
INSERT INTO wja_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu pero sagu̱ pma balanggu̱ ce̱u̱ du kanggu̱ ki̱n, <<Lau̱ ku diyou ci̱ka yisti wu nu̱re̱ wu kangge̱ de̱e̱ tuura yi̱ lemine kunong ku miima alkama wa, miima bwii mwa mwa yo̱o̱ yisti.>> ");
INSERT INTO wja_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu ni̱ng wu̱rai̱ yi̱ balanggi̱ ci̱ye̱i̱, pu sagu̱ mwa mwa to̱o̱ yi̱ri̱ngi̱ nu̱wa bu tum bwii. Manggu yaa sar pma ci̱ye̱i̱ ko̱po̱ yi̱ balanggu̱ ci̱ye̱u̱. ");
INSERT INTO wja_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","A twanga tu banabi̱ ci̱ye̱i̱ ki̱n: <<N sa mbi̱ru̱ we̱i̱ ci̱ye̱i̱ yi̱ ci̱ye̱i̱ du balanggai̱. N ye̱sa mbi̱ru̱ we̱i̱ yi̱ri̱ngi̱ tu tukugai yake̱ toson taa ruugu si̱mau̱. ");
INSERT INTO wja_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Bur Yesu du nu̱wa twalange̱, a diiro laa wii. Kwati̱mba ya baanga bo̱nggo̱ yo̱ pma ce̱ ki̱n, <<Kam kam sa yir pi̱ti̱ndi̱ balanggi̱ ci̱ye̱i̱ a dwii ku̱le̱ du ko̱ndo̱u̱ dwii.>> ");
INSERT INTO wja_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesu nyi̱i̱ le̱e̱ ki̱n, <<Bo̱l Ne̱re̱ twii bajo̱me̱, wu pi̱i̱ duu ku nyaa kwii. ");
INSERT INTO wja_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ko̱ndo̱u̱ twii si̱ma, mwa mwa, pero duu ku nyaau kwii twii nu̱wa bu lau̱ ku diyou wa. Ku̱le̱ wii, twii kwaraa Balaa Buwai. ");
INSERT INTO wja_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Bace̱nte̱ wu pi̱i̱ ku̱le̱ mi̱ri̱nggi̱ alkama wii Balaa Buwai. Nyanggu̱ kaci̱gu̱ twii nyanggu̱ ku cwata go̱ro̱u̱, nu̱wa bu kacu̱gu̱ wa twii bacamandi. ");
INSERT INTO wja_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","<<Ci̱ka ku nu̱wa yikiri ku̱le̱ ba taa, ni̱ndu̱ we̱i̱ yi̱to̱ nyanggu̱ ku cwata go̱ro̱u̱. ");
INSERT INTO wja_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Bo̱l Ne̱re̱ tu̱mo̱ we̱i̱ bacamandi, pma de̱manu̱ we̱i̱ kana we̱ wu diini nu̱wa ba ni̱nga we̱le̱m wa, yi̱ wu ni̱ng tu bwi̱i̱ a lau̱ yo̱u̱. ");
INSERT INTO wja_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Pero bacamandi swii parnu we̱i̱ pma par bwalai, pu pma jii we̱i̱ wiindi yi̱ dumonggu nyi̱yau̱. ");
INSERT INTO wja_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Anda nu̱wa bu ni̱ngi̱ pi̱su̱ wu nyaau a gawu̱ri̱ Yambai̱ nyi̱lanu̱ we̱i̱ ci̱ka nyanggu̱ a lau̱ Mbaa pmau. Yama ne̱re̱ wii twendi di̱ngi̱n nu̱u̱gu̱, ba ka twiyau. ");
INSERT INTO wja_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","<<Lau̱ ku diyou ci̱ka gi̱na wu tukugi a ko̱ndo̱u̱. Pu ne̱re̱ wu kanggi̱ ki̱nggau̱ a pero tukugu, a ni̱nga bu̱ri̱ de̱gde̱g a aara cuu kana ca tu wo̱o̱ yi̱ to̱no̱i̱ a te̱n kodou wii. ");
INSERT INTO wja_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","<<Lau̱ ku diyou ci̱ka, ne̱re̱ wu kasanggu̱ gi̱si̱ tu nyaai, ");
INSERT INTO wja_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","anda ku nyi̱ngga gi̱so̱u̱ kiino ku yi̱ pi̱rcu̱ wang, a aara cuu kana ca tu wo̱o̱ yi̱ to̱no̱i̱ a te̱na. ");
INSERT INTO wja_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","<<Mwaasi̱, lau̱ ku diyou ci̱ka, le̱mdi̱ su nu̱wa parna you re̱e̱ kana ko̱no̱ du jindu. ");
INSERT INTO wja_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Pu le̱m wii twangwa, pma yikuwe a gi̱ngu̱ a si̱n si̱yandi̱ a se̱ka jindi su nyaayi a parna taci̱ngi̱ pmai, su yaa kundi a par si̱ye̱i̱. ");
INSERT INTO wja_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ni̱ndu̱ we̱i̱ yi̱to̱ nyanggu̱ ku cwata go̱ro̱u̱. Bacamandi cwanu we̱i̱ nu̱wa bu ni̱ngi̱ pi̱su̱ wu nyaau gawu̱ri̱ Yamba wa yi̱ nu̱wa bu bwi̱i̱ wa. ");
INSERT INTO wja_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Parnu we̱i̱ pma par bwalai pu pma jii we̱i̱ wiindi yi̱ dumonggu nyi̱yau̱. ");
INSERT INTO wja_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesu pi̱ra ki̱n, <<Bu ku̱ranga to̱o̱ yi̱ri̱ngi̱ ru?>> Pma le̱e̱ ki̱n, <<O̱ng.>> ");
INSERT INTO wja_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Anda a sa pma ki̱n, <<To̱o̱ yi̱ri̱ pi̱ti̱ndi̱ twii, kana wo̱no̱ ku̱lu̱m te̱e̱re̱ wu yo̱o̱ bwiyaka wu lau̱ ku diyou, yo̱ ci̱ka ne̱re̱ wu laa wayau, wu yikiwe gi̱na wu pu̱ci̱ yi̱ wu mi̱lgai̱ mi̱ri̱nggi̱ kandi̱ du ruuni se̱e̱ ye̱i̱.>> ");
INSERT INTO wja_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Pu Yesu mata sagu̱ pma ci̱ye̱i̱ du balanggai̱, a du po̱o̱ wii. ");
INSERT INTO wja_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","A waata bu̱ri̱ gwe̱i̱ ye̱i̱. A toso ju̱ku̱gu̱ yi̱ri̱ngi̱ nu̱wa a gi̱re̱ng ku̱ru̱, nu̱wa bu nu̱u̱gu̱ yo̱ wa pma riyanga bu̱ri̱. Pma ni̱nga pi̱ra ki̱n, <<Ne̱re̱ wo̱o̱ nyi̱ngga to̱o̱ so̱mandi̱ yi̱ yi̱ri̱ngi̱ ri̱yandi̱ bu̱ri̱ to̱o̱ pi̱yau̱? ");
INSERT INTO wja_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","To̱o̱ bo̱l kapinta wo̱o̱ ne̱ ru? Njaa yo̱ wii Maryam yi̱ ci̱yamba ya Yakubu yi̱ Yusupu yi̱ Simon yi̱ Yahuda ne̱ ru? ");
INSERT INTO wja_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ci̱yamba ya bu nu̱ru̱mba wa yaa pi̱si̱ndi̱ pi̱na mwa mwa kem yi̱ yo ru? Ne̱re̱ wo̱o̱ nyi̱ngga to̱o̱ yi̱ri̱ngi̱ pi̱yau̱?>> ");
INSERT INTO wja_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Pma bwiyanga gaanggu̱ a kwaa yo̱. Yesu sa pma ki̱n, <<Banabi̱ ki̱nggi̱ nyi̱i̱gu̱ gi̱ru̱ kana pi̱yau̱, anda yaa ki̱nggi̱ gwe̱i̱ ye̱i̱, yi̱ laa yo̱u̱.>> ");
INSERT INTO wja_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Yaa ku ni̱nga yi̱ri̱ngi̱ ri̱yandi̱ bu̱ri̱ tum a pwii, di̱ngi̱n pma le̱e̱ bu ji̱re̱. ");
INSERT INTO wja_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","A dwii jo̱re̱ Hiridus balaa wu Galili, a nu̱u̱ labar Yesu. ");
INSERT INTO wja_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","A sa wula ya ki̱n, <<Wii Yohanna wu Ni̱ngi̱ Bati̱si̱ma, a wuni bo̱o̱re̱, twii to̱no̱ a ni̱nggu̱ to̱o̱ yi̱ri̱ngi̱ ri̱yandi̱ bu̱ri̱.>> ");
INSERT INTO wja_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Di̱ngi̱n co̱nggo̱ yo̱u̱ a din nu̱wa twala Yohanna, cala yi̱ cali a manna jaru̱m. A ni̱nga yi̱to̱ di̱ngi̱n Hirudiya twii nu̱re̱ ci̱ya yo̱ Pilibus, wu yo̱ yiki yo̱. ");
INSERT INTO wja_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Di̱ngi̱n Yohanna ni̱nga pu sagu̱ Hiridus ki̱n, <<Yaa ci̱maci̱ma yi̱ te̱e̱ri̱ Yambai̱ ma yiki nu̱re̱ ci̱ya mo̱!>> ");
INSERT INTO wja_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Hiridus kasa ba ji yo̱, anda a nu̱u̱ gwasi̱ nu̱wa bu Yudaya wa, di̱ngi̱n pma de̱e̱ Yohanna twii banabi̱. ");
INSERT INTO wja_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Nyanggu̱ danggu̱gu̱ yi̱ bir Hiridus bo̱l Hirudiya wu nu̱re̱ sii ko̱lo̱ gawu̱ri̱ ru̱nggu̱wa ya mwa mwa. A bwalaman dwii Hiridus ");
INSERT INTO wja_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","a ni̱ngaman yo̱ alkawal ki̱n, <<N we̱re̱nga n nyi̱i̱mi̱nu̱ we̱i̱ kana ca tu ma senggoi!>> ");
INSERT INTO wja_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Njaa yo̱ saa, ba sa Hiridus ki̱n, <<Nyi̱i̱nggi̱ dwii Yohanna wu Ni̱ngi̱ Bati̱si̱ma yo̱ko̱ yo̱ko̱ a pi̱lai̱!>> ");
INSERT INTO wja_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Balaa gaanggu̱ yo̱u̱ bwiiwa, anda yake̱ ku ni̱nga alkawal yi̱ we̱ra a gawu̱r ru̱nggu̱wa ya a diin nu̱wa nyi̱i̱ tu kasai̱. ");
INSERT INTO wja_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Di̱ngi̱n to̱no̱ a sa nu̱wa ba mwarwe̱ dwii Yohanna wu Ni̱ngi̱ Bati̱si̱ma a jaru̱m. ");
INSERT INTO wja_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Nu̱wa de̱e̱ dwii ye̱i̱ a pi̱lai̱ nu̱wa nyi̱i̱ bwe̱e̱canga wii, a de̱man njaa yo̱. ");
INSERT INTO wja_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Kwati̱mba Yohanna wu Ni̱ngi̱ Bati̱si̱ma wa baanga ba de̱ bu̱ri̱ ye̱i̱ aanda tingo, pma mwatanga sa Yesu. ");
INSERT INTO wja_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Pu Yesu nu̱u̱ labar Yohanna, a geero konggoru, a aara pu yaa nu̱wau̱ yo̱ wundu. Ku nu̱wa nu̱u̱ tu ni̱ngi̱ wa pma twiyo go̱ro̱ndi̱ pma a pe̱e̱ yi̱ mwari po̱ng yo̱. ");
INSERT INTO wja_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesu julo konggoru a ko̱ nu̱wa tum a nu̱u̱ bunam pmau a mi̱ra pma bu yaa cingcing wa pma yi̱langa. ");
INSERT INTO wja_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Pu nyambi̱ranggu̱ ni̱nga kwati̱mba ya baanga bo̱nggo̱ yo̱u̱ a se̱e̱ ki̱n, <<Po̱o̱ wuna ti̱na gu̱lai̱, yo̱ko̱ nyambi̱ranggu̱ ni̱nga. Sa nu̱wa bo̱o̱ ba aanda go̱ro̱ndi̱ tu ne̱m, palaka ba te̱nmanu̱we̱ bu̱ri̱ pmai je̱e̱ndi̱.>> ");
INSERT INTO wja_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesu nyi̱i̱ pma le̱e̱ ki̱n, <Ko̱po̱ ba mwatanga ne̱, anda mba bu nyi̱i̱ pma yi̱ri̱ ba je̱!>> ");
INSERT INTO wja_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Pma se̱e̱ ki̱n, <<Tu yi bo̱o̱ yi̱ to̱no̱i̱ mwa mwa ti̱na ku̱maa nuwo yi̱ jindi ro̱p ti̱bak.>> ");
INSERT INTO wja_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesu sa pma ki̱n, <<Bu de̱ngu̱we̱ pi̱na.>> ");
INSERT INTO wja_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","A sa nu̱wa bwii ba si̱ndi̱ si̱ye̱i̱, a dwii si̱yangi̱. A de̱e̱ ku̱maa wu nuwo wii yi̱ jindi su ro̱p swii, a wun dwii diyou, a ni̱nga wandi̱ma a ge̱le̱nga ku̱maa wii. A nyi̱i̱ kwati̱mba ya ba cwaanga, pma cwaanga nu̱wa bwii. ");
INSERT INTO wja_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Anda mwa mwa pmau je̱ riyanga. Kwati̱mba ya gamanga buburingi tu nyonai, a twanga taci̱ngi̱ kwap su̱r ro̱p. ");
INSERT INTO wja_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ku̱ci̱ nu̱wa bu je̱ je̱e̱ndu̱ wa bwii twii nambi̱rmba tedu nuwo yaa mu̱ri̱nggi̱ nu̱ru̱mba yi̱ bakwara. ");
INSERT INTO wja_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Yo̱ko̱ yo̱ko̱ Yesu sa kwati̱mba ya ba teendo konggoru ba cwiyongo yerou you, pma du yo̱ anda a sa nu̱wa bwii ba mwatanga. ");
INSERT INTO wja_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Pu nu̱wa bwii mwatanga, Yesu geero ci̱ngu̱ yo̱ wundu di̱ngi̱n ba ce̱ ku̱ru̱. Kum ni̱nga wo̱o̱ pwii yo̱ wundu. ");
INSERT INTO wja_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Anda a do̱o̱ jo̱re̱ konggoru wii ni̱nga kwaara yi̱ gi̱ngu̱ yo̱u̱, gwe̱re̱ gundu turonggu pma di̱ngi̱n wuture wii jagu̱ pma so̱ngma. ");
INSERT INTO wja_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Pu kacu ni̱nga, Yesu aara bo̱nggo̱ pmau yi̱ nau a dwii gundi. ");
INSERT INTO wja_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Pu kwati̱mba ya ko̱ yo̱ so̱ngma dwii gundui pma nu̱u̱ gwasi̱, pma ni̱nga duwai ki̱n <<Twii pi̱ti̱ngga!>> Pma nu̱u̱ gwasi̱ wang. ");
INSERT INTO wja_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yo̱ko̱ yo̱ko̱, Yesu sa pma ci̱ye̱i̱ ki̱n, <<Bu bo̱ gaanggu̱, bu nu̱u̱ya gwasi̱, wuna mi!>> ");
INSERT INTO wja_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Anda Bitrus se̱e̱ ki̱n, <<Mbaa Wu Gi̱ra ka wo̱o̱ mo̱ we̱i̱ sangge̱ n baa bo̱nggo̱ mo̱u̱ n ni̱nga so̱ngma gundu.>> ");
INSERT INTO wja_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesu le̱e̱man yo̱ ki̱n. <<Bame̱.>> Bur Bitrus twiyo mi̱ri̱nggi̱ konggoru a yanna so̱ngma a dwii gundu aara bo̱nggo̱ Yesu. ");
INSERT INTO wja_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Anda pu ko̱ wutur gundu wii yi̱ di̱mbi̱re̱ a nu̱u̱ gwasi̱ a toso ji̱mti̱gu̱ a gundu. A ba kwarame̱ ki̱n, <<Mbaa Wu Gi̱ra, mi̱rangge̱.>> ");
INSERT INTO wja_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yesu yaki wai yo̱u̱ a taa yo̱ ce̱ ki̱n, <<Ma yaa le̱e̱gu̱ ji̱re̱u̱. Di̱ngi̱n ca ma cwaanga gaanggi̱r ro̱p?>> ");
INSERT INTO wja_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Pu pma teendo mi̱ri̱nggu̱ konggoru wii, bur wutur wii gwata. ");
INSERT INTO wja_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Nu̱wa bu mi̱ri̱nggi̱ konggoru bwii ku̱raman si̱ma Yesu a ce̱gu̱ ki̱n, <<Manggu ma Bo̱l Yamba.>> ");
INSERT INTO wja_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Pu pma yerongo kali̱nggu̱ kwii, pma julongo a Jenesarata. ");
INSERT INTO wja_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Pu nu̱wa bu gwe̱i̱ dwii ku̱ranga Yesu, pma tu̱mami̱n si̱ma bwii mwa mwa. Pma ni̱nga pu de̱gu̱ nu̱wa bu bu̱ri̱ yaa cingcing wa bo̱nggo̱ Yesu. ");
INSERT INTO wja_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Pma senggo yo̱ ba du nu̱wa bu yaa cingcing wa ba mwaanga nyan landa yo̱u̱, anda kana we̱ wu mwaanga nyan landa yo̱u̱ a yi̱la. ");
INSERT INTO wja_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Parisayo bu kangga kem yi̱ ku̱lu̱mba te̱e̱ri̱ngi̱ wa bu baanga Wurcalima wa, pma baanga bo̱nggo̱ Yesu a pi̱ra ki̱n, ");
INSERT INTO wja_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","<<Di̱ngi̱n ca kwati̱mba ma yaa po̱ng tu kakaa pi̱r ye̱i̱? Pma yaa cardi wari̱ ka wunni je̱gu̱ je̱e̱ndi̱!>> ");
INSERT INTO wja_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesu nyi̱i̱ le̱e̱ ki̱n, <<Di̱ngi̱n ca mba bu par te̱e̱ri̱ Yambai̱ di̱ngi̱n pu po̱ng ni̱ngandi̱ mbi̱ri̱? ");
INSERT INTO wja_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Di̱ngi̱n Yamba ce̱ ki̱n, <Ma nyi̱i̱ gi̱ru̱ mbaa mo̱ yi̱ njaa mo̱,> anda <Kana we̱ wu se̱mtanga mbaa yo̱ yi̱ njaa yo̱, nu̱wa ba jiyo.> ");
INSERT INTO wja_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Anda mba bu ju̱ku̱ri̱ mi̱n ne̱re̱ ba kwaa kalanggu̱ mbaa yo̱ yi̱ njaa yo̱ jo̱r du bo̱o̱ yi̱ biiki, ba ce̱ ki̱n, kana ca tu n wo̱o̱ yi̱ to̱no̱i̱ n nyi̱i̱ Yamba. ");
INSERT INTO wja_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Di̱ngi̱n to̱no̱ bu ju̱ki̱ya mi̱n ne̱re̱ ba nyi̱i̱ ya gi̱ru̱ mbaa yo̱, bu kwaa te̱e̱ri̱ Yambai̱ palaka bu po̱ng ni̱ngandi̱ mbi̱ri̱. ");
INSERT INTO wja_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mbaa bu yi̱ batal wa! Icaya ce̱ ci̱maci̱ma pu ci̱ye̱i̱ du baa bo̱nggo̱ Yambai̱ a dwii mbi̱ri̱, a ce̱ ki̱n, ");
INSERT INTO wja_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","<Nu̱wa bo̱o̱ nyi̱i̱nggi̱ gi̱ru̱ yi̱ nyandi pmai ti̱bak anda gaanggi̱ri̱ pmai kwaara yi̱ mi. ");
INSERT INTO wja_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Pma ku̱rangi̱n si̱ma nyo, yi̱ri̱ngi̱ tu pma ju̱ku̱gu̱, twii te̱e̱ri̱ngi̱ nu̱wa ti̱bak!>>> ");
INSERT INTO wja_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesu yi̱we̱ nu̱wa bu ku̱ranggi̱ bu̱ri̱ wa bwii ba baanga bo̱nggo̱ yo̱u̱, a sa pma ki̱n, <<Bu ka twiyau bu ku̱ranga! ");
INSERT INTO wja_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Yi̱ri̱ngi̱ tu diiri nyan ne̱ru̱ twii tu diini ne̱re̱ ba ni̱nga yaa walwal ne̱ anda yi̱ri̱ngi̱ tu twiiwei nyi̱yau̱ ne̱ru̱ bwiyani ne̱re̱ ba ni̱nga yaa walwal.>> ");
INSERT INTO wja_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Kwati̱mba ya baanga bo̱nggo̱ yo̱ ce̱ ki̱n, <<Ma so̱ma mi̱n tu ma ce̱ to̱o̱ a bwiyaman gaanggu̱ Parisayo ru?>> ");
INSERT INTO wja_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yesu nyi̱i̱ le̱e̱ ki̱n, <<Kana ca tu Mbaa mi wu diyou pi̱ bu, nu̱wa podu we̱i̱. ");
INSERT INTO wja_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Bu du pma, to̱o̱ nu̱wa bu taman jwalu kermo wa, anda kermo yaa taman jwalu kermo, di̱ngi̱n mwa pmau yaraman we̱i̱ bo̱o̱wu̱.>> ");
INSERT INTO wja_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Bitrus ce̱ ki̱n, <<Sa yiri pi̱ti̱ndi̱ balanggu̱ ci̱ye̱i̱ du ma ce̱ do̱o̱.>> ");
INSERT INTO wja_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesu sa pma ki̱n, <<Karai kwii bu ku̱ran bu ru? ");
INSERT INTO wja_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Bu so̱m bu mi̱n kana ca tu diiro nyi̱yau̱ aari pwii pero ba twii bu̱ri̱ du? ");
INSERT INTO wja_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Anda yi̱ri̱ngi̱ tu twiiwe nyi̱yau̱ twiiwe mi̱ri̱nggu̱ gaanggu̱, to̱o̱ tu diini ne̱re̱ ba ni̱nga yaa walwal. ");
INSERT INTO wja_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Di̱ngi̱n a mi̱ri̱nggi̱ gaanggu̱ dangandi̱ tu bwi̱i̱ twiiwei, jigu ne̱ru̱, taari̱, taari̱ yi̱ nu̱ru̱mba bu̱ru̱ wa, kuwi, se̱e̱daki̱ leendi, yi̱ bwiyanggu dinu. ");
INSERT INTO wja_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","To̱o̱ yi̱ri̱ngi̱ diin ne̱re̱ ni̱ng yaa walwal. Anda je̱gu̱ je̱e̱ndi̱ wari̱ yaa cargi, yaa diini ne̱re̱ ba ni̱nga yaa walwal.>> ");
INSERT INTO wja_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu du po̱o̱ wii a mwati̱ si̱ma Taya yi̱ Sidon. ");
INSERT INTO wja_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Nu̱r Kananiya wa wu bo̱nggo̱ndi̱ swii baa bo̱nggo̱ yo̱u̱ a wun miu yi̱ duwai ki̱n, <<Mbaa Wu Gi̱ra, Bo̱l Dawud, nu̱u̱ bunam mu, bwe̱e̱canga mi wo̱o̱ yi̱ wuturindi a cu̱su̱gu̱.>> ");
INSERT INTO wja_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Anda Yesu yaa ku sa yo̱ ci̱ye̱i̱. Kwati̱mba ya baanga bo̱nggo̱ yo̱u̱ senggo a ce̱ ki̱n, <<Ke̱e̱ ba mwati̱! A po̱nggu̱ yiru ni̱nggu̱ duwau!>> ");
INSERT INTO wja_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesu nyi̱i̱ le̱e̱ ki̱n, <<Nu̱wa tu̱mgu̱we̱ bo̱nggo̱ nu̱wa bu Israila yi̱ wundu bu ci̱ka puuri su li̱yangai̱ wa.>> ");
INSERT INTO wja_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Nu̱re̱ wii baa kun kwiyei gawu̱ri̱ ye̱i̱ ce̱ ki̱n, <<Mbaa Wu Gi̱ra kalangge̱.>> ");
INSERT INTO wja_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesu le̱e̱ ki̱n <<Yaa kundi nu̱wa ba de̱ je̱e̱ndi̱ bakwarai ba nyi̱i̱ baindi.>> ");
INSERT INTO wja_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","A nyi̱i̱ le̱e̱ ki̱n, <<Mbaa Wu Gi̱ra, to̱o̱ ji̱re̱, kana baindi je̱e̱ tu ywiyongo bo̱nggo̱ ne̱re̱ yo̱.>> ");
INSERT INTO wja_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yesu nyi̱i̱ le̱e̱ ki̱n, <<Ma yo̱o̱gi̱ nu̱re̱ wu yi̱ le̱e̱gu̱ ji̱rau̱! Nu̱wa ni̱ngami̱nu̱ we̱i̱ tu ma kasu̱gu̱.>> Ki̱nangu̱ kwii bwe̱e̱canga yo̱ yi̱la. ");
INSERT INTO wja_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu du po̱o̱ wii a mwati̱ kali̱nggu̱ ku Galili. A ge̱ro̱ ci̱ngu̱ si̱n si̱ye̱i̱. ");
INSERT INTO wja_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Nu̱wa tum baa bo̱nggo̱ yo̱u̱ de̱e̱ gu̱wo̱ngi̱ yi̱ kermo yi̱ ne̱re̱ wu mwar bo̱rgi̱, yi̱ bapi̱me̱ yi̱ nu̱wa bu bu̱ri̱ pmai yaa cingcing a bo̱nggo̱ Yesu, a mi̱ra pma, pma yi̱langa. ");
INSERT INTO wja_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Nu̱wa bwii riyanga bu̱ri̱ pu pma ko̱ bapi̱me̱ ce̱gu̱ ci̱ye̱u̱, gu̱wo̱ngi̱ a yi̱la, ne̱re̱ wu mwar bo̱rgi̱ a so̱ngma, kermo ko̱gu̱ si̱ma. Bu̱ri̱ pma te̱re̱nga Yamba wu Israila. ");
INSERT INTO wja_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu yi̱we̱ kwati̱mba ya a sa pma ki̱n, <<N nu̱u̱gu̱ bunam nu̱wa bo̱o̱, di̱ngi̱n pma ni̱nga daa kunong kem yi̱ mi anda yi yaa je̱e̱ndi̱ tu yi je̱i̱, n yaa kasi̱ baa mwatanga yi̱ ju̱ne̱, ko̱ mwa ba jaanga so̱ngma nyinou ka wuni mwatangu.>> ");
INSERT INTO wja_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Kwati̱mba ya pi̱ra ki̱n, <<Yi nyi̱ngga we̱i̱ je̱e̱ndi̱ tum pi̱yau̱ pi̱na gu̱lai̱ tu yirmanu we̱i̱ nu̱wa bu tum bo̱o̱?>> ");
INSERT INTO wja_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu pi̱ra pma ki̱n, <<Bu bo̱o̱ yi̱ ku̱maa so̱no̱?>> Pma nyi̱i̱ le̱e̱ ki̱n, <<Yi bo̱o̱ yi̱ ku̱maa a nibiyo yi̱ jindi banyi̱na.>> ");
INSERT INTO wja_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yesu sa nu̱wa bu tum bwii ki̱n ba si̱ndi̱ si̱ye̱ndi̱ si̱ma. ");
INSERT INTO wja_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","A de̱ ku̱maa wu nibiyo wii yi̱ jindi swii a wananga Yamba, a ge̱le̱nga nyi̱i̱ kwati̱mba ya, kwati̱mba ya cwaanga nu̱wa bwii. ");
INSERT INTO wja_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Pma je̱e̱ riyanga mwa mwa. Kwati̱mba ya ku̱ranga bubiringi tu nyonai a twanga taci̱ngi̱ nibiyo. ");
INSERT INTO wja_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ku̱ci̱ nu̱wa bu je̱ je̱e̱ndi̱ wa lam tedu ni̱i̱, yaa mu̱ri̱nggi̱ nu̱ru̱mba yi̱ bakwara. ");
INSERT INTO wja_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Go̱ro̱ pu Yesu tu̱m pma mwatanga, a diiro konggoru a yeri bo̱nggo̱ndi̱ Magadan. ");
INSERT INTO wja_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Parisayo bu kangga yi̱ Sadukayo pma baanga bo̱nggo̱ Yesu palaka ba cu̱u̱ yo̱, pma se̱e̱ ki̱n, <<Ju̱ku̱ yiri somdi yi̱ri̱ ri̱yandi̱ bu̱ri̱, ka ma baa diyou Yamba wai.>> ");
INSERT INTO wja_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Anda Yesu nyi̱i̱ pma le̱e̱ ki̱n, <<Ka nyambi̱ranggu̱ ni̱ngi̱, bu ce̱ mi̱n, <Si̱ma ni̱ngu̱ we̱i̱ teng di̱ngi̱n diyou ni̱nga wing.> ");
INSERT INTO wja_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Pero yi̱ pinu bu ce̱e̱ mi̱n, <Gundu yaru we̱i̱, di̱ngi̱n diyou ni̱ngi̱ wing pero ni̱nga pitipiti!> Bu ku̱rani̱ tu ni̱ngdu̱ we̱i̱ diyou, anda bu jaanga ku̱ranggu̱ tu ni̱ngdu̱ we̱i̱ a daandi su yo̱ko̱i̱. ");
INSERT INTO wja_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Mba nu̱wa bu bwi̱i̱ wa bu si̱naa daandi wa, bu yaa gwasi̱ Yamba wa, bu kasi̱ yi̱ri̱ somdi ri̱yandi̱ bu̱ri̱, yaa ku n ni̱ngambi̱ri̱ somdi ri̱yandi̱ bu̱ri̱ ka gwal tu banabi̱ Yunana.>> Bur Yesu a du pma mwati̱. ");
INSERT INTO wja_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Pu kwati̱mba ya yerongo kali̱nggu̱ kwii, pma mondo ba de̱ ku̱maa. ");
INSERT INTO wja_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesu sa pma ki̱n, <<Bu ruun tu̱we̱, yi̱ yisti Parisayo yi̱ Sadukayo.>> ");
INSERT INTO wja_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Pma toso gwe̱la yi̱ bu̱ri̱ pmai ki̱n, <<A ce̱ yi̱to̱ di̱ngi̱n yi de̱e̱ bu ku̱maa kana banyi̱na.>> ");
INSERT INTO wja_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesu so̱m tu pma ce̱gi̱, di̱ngi̱n to̱no̱ a pi̱ra pma ki̱n, <<Di̱ngi̱n ca bu ni̱nggu̱ gwe̱la yi̱ bu̱ri̱ mbi̱ri̱ mi̱n bu yaa ku̱maa? Le̱e̱gu̱ ji̱rau̱ mbi̱ru̱ banyi̱na! ");
INSERT INTO wja_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Lama yo̱ko̱ bu ku̱ran bu ru? Bu dangga bu yi̱ ku̱maa nuwo wu n je̱e̱ nu̱wa tedu nuwo wo̱ ru? Bu ku̱ranga taci̱ngi̱ twangi so̱no̱? ");
INSERT INTO wja_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ku̱maa nibiyo wu n je̱e̱ nu̱wa tedu ni̱i̱ wo̱o̱ do̱ng de̱i̱? Bu twanga taci̱ngi̱ so̱no̱?>> ");
INSERT INTO wja_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Di̱ngi̱n ca bu yaa ku̱rani̱ mi̱n n yaa ce̱gu̱ ku̱maa? Bu swe̱ra bu̱ri̱ mbi̱ri̱ bo̱nggo̱ yisti Parisayo yi̱ Sadukayo.>> ");
INSERT INTO wja_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Kwati̱mba ya bwii ku̱ranga ki̱n yaa ce̱gu̱ ki̱n ba swe̱ra bu̱ri̱ pmai bo̱nggo̱ yisti wu mi̱ri̱nggi̱ ku̱maa anda bo̱nggo̱ yi̱ri̱ngi̱ tu Parisayo yi̱ Sadukayo ju̱ku̱ri̱. ");
INSERT INTO wja_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Pu Yesu mwati̱ gwe̱i̱ Kaisariya du Pilipi, a pi̱ra kwati̱mba ya ki̱n, <<Nu̱wa ci̱ye̱i̱ ki̱n Bo̱l Ne̱re̱ we̱?>> ");
INSERT INTO wja_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Pma le̱e̱ ki̱n <<Bu kangga ce̱e̱ ki̱n ma yo̱o̱gi̱ Yohanna wu Ni̱ngi̱ Bati̱si̱ma, bu kangga ki̱n ma Iliya, bu kangga ki̱n ma Irmiya yikwii ma wu wiino mi̱ri̱nggi̱ banabi̱ndi̱.>> ");
INSERT INTO wja_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","A pi̱ra pma ki̱n <<Anda mba, bu ce̱ mi̱n, mi we̱?>> ");
INSERT INTO wja_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Bitrus le̱e̱ ki̱n, <<Ma Masiya, Bo̱l Yamba wu yi̱ pi̱i̱ma.>> ");
INSERT INTO wja_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesu le̱e̱man yo̱ ki̱n, <<Ma yo̱o̱gi̱ wu yi̱ wuure Simon bo̱l Yunana, di̱ngi̱n wo̱o̱ ji̱re̱ yaa ku baa bo̱nggo̱ ne̱ru̱. Mbaa mi wu diyou a ju̱ku̱ mi̱na. ");
INSERT INTO wja_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Yo̱ko̱ n sagu̱ mo̱u̱, ma Bitrus, (pi̱ti̱ndi̱ ye̱i̱ twii swe̱li̱.) Ma yo̱o̱gi̱ swe̱li̱ du n mo̱ru̱ we̱i̱ ikkilisiya mi, kana bo̱o̱re̱ na gwali̱. ");
INSERT INTO wja_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","N nyi̱i̱mi̱nu̱ we̱i̱ tu wundi nyinoi lau̱ ku diyou, kana ca tu ma kwe̱e̱ a si̱ma, a kwauwa a diyou, tu ma pe̱ra a si̱ma, a pe̱rwa a diyou.>> ");
INSERT INTO wja_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Go̱ro̱ yi̱to̱ Yesu sa kwati̱mba ya ki̱n, ba sari̱ ya kana we̱ ki̱n yo̱ Masiya. ");
INSERT INTO wja_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","A toso dwii jo̱re̱ Yesu toso sagu̱ kwati̱mba ya dak ki̱n, <<Tagi̱ n angge̱ Wurcalima n tii ku̱u̱le̱ wundu wundu bo̱nggo̱ bagi̱raa Yudaya wa yi̱ bagi̱raa kuruwa wa yi̱ ku̱lu̱mba te̱e̱ri̱ngi̱ wa. Tagi̱ nu̱wa jinggu we̱i̱, anda nyanggu̱ ku kunong, yo̱ wuni we̱i̱ yi̱ pi̱i̱ma.>> ");
INSERT INTO wja_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Bitrus wu̱u̱ yo̱ bo̱nggo̱ a toso ye̱re̱nggu̱ ki̱n, <<Mbaa Wu Gi̱ra! To̱o̱ na ni̱ndi̱ yi̱ mo̱!>> ");
INSERT INTO wja_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yesu waka kau sa Bitrus ki̱n, <<Lamana bo̱nggo̱ mu Balaa buwai! Ma yo̱o̱gi̱ swe̱li̱ pu̱ti̱, to̱o̱ dangandi̱ baa bu bo̱nggo̱ Yambau̱, anda bo̱nggo̱ ne̱ru̱.>> ");
INSERT INTO wja_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Yesu sa kwati̱mba ya ki̱n, <<Kana we̱ ka kasi̱ ba po̱ngge̱, tagi̱ ba kwaa bu̱ri̱ ye̱i̱, ba de̱ ye̱u̱ yo̱u̱ ba po̱ngge̱. ");
INSERT INTO wja_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kana we̱ wu kasi̱ ba mi̱ra pi̱i̱ma ya mandu̱ we̱i̱ si̱yau̱, anda kana we̱ wu mansi̱ ye̱i̱ pi̱i̱ma ya di̱ngi̱n mi nyi̱nggu̱ we̱i̱. ");
INSERT INTO wja_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Tu ne̱re̱ pulu we̱i̱ ca ka nyi̱nggi̱ yi̱ri̱ngi̱ tu si̱ma mwa mwa anda nyi̱ngga bu pi̱i̱ma ne̱? Tu ne̱re̱ nyi̱i̱ we̱i̱ ca ba waka pi̱i̱ma ya. ");
INSERT INTO wja_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Di̱ngi̱n Bo̱l Ne̱re̱ baa we̱i̱ yi̱ yi̱lau̱ Mbaa yo̱ yi̱ bacamandi ye̱i̱, pero nyi̱i̱ we̱i̱ kana we̱ wo̱ri̱ri̱ ci̱maci̱ma yi̱ yi̱ri̱ tu ni̱ngai̱. ");
INSERT INTO wja_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","N wo̱o̱ sagu̱mbi̱ru̱ ji̱re̱ bu kangga bo̱o̱ pi̱ti̱ndi̱ pi̱na, yaa ku bwaanu wau ko̱po̱ ka kwe̱e̱ Bo̱l Ne̱re̱ bagu̱ yi̱ lau̱ yo̱u̱. ");
INSERT INTO wja_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Go̱ro̱ daa no̱ko̱no̱ Yesu de̱ Bitrus yi̱ Yakubu yi̱ ci̱ya yo̱ Yohanna a geendo ci̱ngu̱ ku getenteng pma yi̱ wundu pmau. ");
INSERT INTO wja_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Pu pma bo̱o̱ pwii Yesu wakuwa, kau yo̱u̱ a nyi̱langgu̱ ci̱ka nyanggu̱, se̱e̱ yo̱ ni̱nga po̱pu̱lo̱k rang. ");
INSERT INTO wja_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Bur kwati̱mba Yesu wa bu kunong wa bwii ko̱ Iliya yi̱ Musa baanga toso ce̱gu̱ ci̱ye̱i̱ yi̱ Yesu. ");
INSERT INTO wja_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Bitrus sa Yesu ki̱n, <<Mbaa Wu Gi̱ra a ni̱nga yiro kundi ku̱ yi bo̱o̱ pi̱na! Ka ma le̱i̱ n me̱ne̱nu̱ we̱i̱ cukuringi kunong, diino di̱ngi̱n mo̱, diino di̱ngi̱n Musa, diino di̱ngi̱n Iliya.>> ");
INSERT INTO wja_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pu wo̱o̱ ce̱gu̱ ci̱ye̱i̱, bu̱ri̱ tinene du nyi̱lani̱ baa summo pma, pero miu twiiwe tinene dwii ki̱n, <<Ti̱na Bo̱l mi wu n kangni̱, wu di̱rangi̱n gaanggu̱. Bu nu̱u̱ yo̱!>> ");
INSERT INTO wja_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Pu kwati̱mba ya bwii nu̱u̱ miu kwii pma nu̱u̱ gwasi̱ wang pma gonjo kau si̱ma. ");
INSERT INTO wja_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yesu baa bo̱nggo̱ pmau a mwaanga pma a ce̱ ki̱n, <<Bu wunongo, Bu nu̱u̱ yaa gwasi̱!>> ");
INSERT INTO wja_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Pu pma wun dwiiyongi pma ko̱ bu kana we̱ bur Yesu. ");
INSERT INTO wja_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Pu pma julonggu ci̱ngu̱ kwii Yesu sa pma ki̱n, <<Bu sar ya kana we̱ tu bu ko̱i̱ ko̱po̱ ka Bo̱l Ne̱re̱ wuni bo̱o̱re̱.>> ");
INSERT INTO wja_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Kwati̱mba ya pi̱ra yo̱ ki̱n, <<Di̱ngi̱n ca ku̱lu̱mba te̱e̱ri̱ngi̱ wa ce̱ ki̱n tagi̱ ko̱po̱ ka Iliya waatai bati̱ anda Masiya ba baa?>> ");
INSERT INTO wja_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesu nyi̱i̱ le̱e̱ ki̱n, <<Manggu Iliya baa we̱i̱, pero waata we̱i̱ kana ca mwa mwa. ");
INSERT INTO wja_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Anda n wo̱o̱ sagu̱mbi̱ru̱ Iliya gi̱ci̱la baa, nu̱wa yaa ku ku̱ranga yo̱, pma ni̱ngaman yo̱ kana ca tu pma kasai̱. Yi̱to̱ mwaa Bo̱l Ne̱re̱ aari ti̱i̱gu̱ ku̱u̱lu̱ a wari̱ pmai.>> ");
INSERT INTO wja_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Bu̱ri̱ kwati̱mba ya ku̱ranga ki̱n a ce̱gu̱ ci̱ye̱i̱ dwii Yohanna wu Ni̱ng Bati̱si̱ma. ");
INSERT INTO wja_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Pu pma waatanga bu̱ri̱ bo̱nggo̱ nu̱wau̱, ne̱re̱ wu kangge̱ baa bo̱nggo̱ Yesu, a kun kwiyou bo̱nggo̱ yo̱u̱. ");
INSERT INTO wja_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","A ce̱ ki̱n, Mbaa Wu Gi̱ra, nu̱u̱ bunam bo̱l mu! Yi̱ to̱ki̱ pero a ti̱i̱gu̱ ku̱u̱li̱ wang, sii yari̱nggu̱ bwalau yi̱ gundu. ");
INSERT INTO wja_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","N de̱mu̱we̱ kwati̱mba ma anda pma jaanga mi̱rgu̱.>> ");
INSERT INTO wja_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesu nyi̱i̱ pma le̱e̱ ki̱n, <<Mba nu̱wa bu yaa le̱e̱gu̱ ji̱re̱ wa yi̱ nu̱wa bu bwi̱i̱wa! N si̱nggu̱ we̱i̱ si̱ye̱i̱ yi̱ mba ko̱po̱ pe̱ne̱? N tari̱ we̱i̱ kanadi yi̱ mba ko̱po̱ pe̱ne̱? Bu nyi̱i̱ngu̱ we̱i̱ bwi̱ya wo̱o̱ pi̱na!>> ");
INSERT INTO wja_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yesu ye̱ra wutur wii, a twiyo bu̱ri̱ bwi̱ya wii swii ki̱nangu̱ a yi̱la. ");
INSERT INTO wja_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Bur kwati̱mba Yesu baanga wu̱lak pi̱ra yo̱ ki̱n, <<Di̱ngi̱n ca yi jaanga yikugu wutur wii?>> ");
INSERT INTO wja_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesu nyi̱i̱ le̱e̱ ki̱n, <<Di̱ngi̱n le̱e̱gu̱ ji̱re̱ mbi̱ru̱ banyi̱na, n sagu̱mbi̱ru̱ ji̱re̱ ka bu bo̱o̱ yi̱ le̱e̱gu̱ ji̱re̱ banyi̱na ci̱ka go̱n mustad, bu saru we̱i̱ ci̱ngu̱ ki̱na mi̱n, <Mwati̱ pi̱na ma amna pwii!> Mwati̱r we̱i̱. Yaa tu bu puu ni̱nggi̱. ");
INSERT INTO wja_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ko̱o̱ duu wutur yaa twii ko̱po̱ yi̱ ku̱ru̱ yi̱ cooji.>> ");
INSERT INTO wja_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Pu mwa mwa kwati̱mba ya ku̱ranga bu̱ri̱ Galili, Yesu sa pma ki̱n, <<Nu̱wa curu we̱i̱ Bo̱l Ne̱re̱ a war nu̱wai̱. ");
INSERT INTO wja_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Nu̱wa jiru we̱i̱, anda go̱ro̱ daa kunong wunu we̱i̱ bo̱o̱re̱.>> Anda kwati̱mba bwiyanga gaanggu̱ wang. ");
INSERT INTO wja_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Pu Yesu yi̱ kwati̱mba ya baanga Kaparnahum, nu̱wa bu yi̱ri̱ janggal Laa Yambau̱ baanga bo̱nggo̱ Bitrus pi̱ra ki̱n, <<Ku̱lu̱m mbi̱r yar janggal wu Laa Yambau̱ ru?>> ");
INSERT INTO wja_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Bitrus le̱e̱ ki̱n, <<O̱ng.>> Pu Bitrus waata mi̱ri̱nggi̱ lai̱, Yesu ni̱nga pi̱ra ki̱n., <<Wu yar janggal balamba we̱? Nu̱wa bu si̱ma bwii ru? Ru̱nggu̱wa ru? Ma ce̱ mi̱n ca Bitrus?>> ");
INSERT INTO wja_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Bitrus nyi̱i̱ le̱e̱ ki̱n, <<Tu yar Ru̱nggu̱wa.>> Yesu le̱e̱ ki̱n, <<Kundi, ma ce̱gu̱ mi̱n nu̱wa bu si̱ma bo̱o̱ pma yaa yari. ");
INSERT INTO wja_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Anda n yaa kasi̱ yi we̱laman nu̱wa bo̱o̱. Di̱ngi̱n to̱no̱ mwati̱ you ma manni̱ godim. Ma wu̱we̱, jinde wu ma taa, a nyi̱yau̱ yau̱ ma nyi̱nggu̱ we̱i̱ ke̱ne̱ du yinno yagu janggal, ma de̱e̱, ma ya pma janggal yire.>> ");
INSERT INTO wja_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","A dwii jo̱re̱ kwati̱mba Yesu wa baanga bo̱nggo̱ yo̱u̱ a pi̱rgu̱ ki̱n, <<Wu gwala yi̱ gi̱ra we̱ a lau̱ ku diyou?>> ");
INSERT INTO wja_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesu yi̱we̱ babwiya wu banyi̱na a ruwo cu̱di̱ pma ");
INSERT INTO wja_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","a ce̱ ki̱n, <<N wo̱o̱ sagu̱mbi̱ru̱ ji̱re̱ ko̱po̱ ka bu waka bu̱ri̱ bu yo̱o̱ ci̱ka babwiya wu banyi̱na, ka yi̱to̱ ne̱, yaa wu diru we̱i̱ lau̱ ku diyou. ");
INSERT INTO wja_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Di̱ngi̱n to̱no̱ kana we̱ wu cingo dwii ye̱i̱ ci̱ka babwiya wu banyi̱na, yo̱o̱ we̱i̱ wu gwala yi̱ gi̱ra a lau̱ ku diyou. ");
INSERT INTO wja_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Kana we̱ wu yi̱ babwiya banyi̱na ci̱ka wuna di̱ngi̱n din mi, a yi̱ngge̱. ");
INSERT INTO wja_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","<<Anda kana we̱ wu diini wu wiino mi̱ri̱nggi̱ bu nyi̱ti̱ti̱, bu puu ji̱re̱ yi̱ mi wa ba yaranga a we̱le̱m, kujang nu̱wa ba kwangman yo̱ ni̱i̱ du duuyi a kwii ba manna mi̱ri̱nggi̱ kali̱nggu̱ ba bwaa. ");
INSERT INTO wja_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","To̱o̱ yi̱ri̱ bunam a si̱ma, di̱ngi̱n nyindi we̱le̱m tagi̱ ba baa, anda yo̱o̱ we̱i̱ yi̱ri̱ bunam a bo̱nggo̱ ne̱re̱ wu de̱ yari. ");
INSERT INTO wja_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","<<Ka wai mau yi̱ naa mau diiminu we̱i̱ we̱le̱m wai, ma mwar ya, ma man si̱ye̱i̱! Kujang ma nyi̱ngga pi̱i̱ma bu yaa mati̱gu̱ wa, yaa wari yi̱ mwari yi̱ ku nu̱wa manu we̱i̱ mwa mwa wari mai yi̱ mwar mai mi̱ri̱nggu̱ bwalau ku yaa dumdu. ");
INSERT INTO wja_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ka nung mo̱ diimini we̱i̱ we̱le̱m wai, podo ma man si̱ye̱i̱! Kujang ma nyi̱ngga pi̱i̱ma yi̱ nung wiino yi̱ ku nu̱wa manmi̱nu̱ we̱i̱ yi̱ nundi ro̱p a bwalau ku yaa dumdu. ");
INSERT INTO wja_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","<<Su̱wa kii, bu cedi ya kana we̱ cu̱du̱ bu nyi̱ti̱ti̱ bo̱o̱. N wo̱o̱ sagu̱mbi̱ru̱ bacamandi pmai su diyou kana pe̱ne̱ pe̱ne̱ bo̱o̱ gawu̱ri̱ Mbaa mi wu diyou. ");
INSERT INTO wja_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Bo̱l Ne̱re̱ baa di̱ngi̱n ba mi̱ra pma bu li̱yanggi̱ wa. ");
INSERT INTO wja_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Bu dangani̱ mi̱n? Ka ne̱re̱ wu kangge̱ wo̱o̱ yi̱ puuri wo̱o̱n anda wu wiino li̱yari̱, na du̱r su kun to̱ro̱ su̱r to̱ro̱ swii a taagu̱ taawu̱ a ci̱ngu̱, ba mwati̱ ba kasanga puure wu wiino wu li̱ya wii ru? ");
INSERT INTO wja_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ka nyi̱ngai̱, n sagu̱mbi̱ru̱ ji̱re̱ ni̱nggu̱ we̱i̱ bu̱ri̱ de̱gde̱g a dwii puure wiino wii gwalu we̱i̱ su kun to̱ro̱ su̱r to̱ro̱ su li̱yani̱ bu swii. ");
INSERT INTO wja_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Yi̱to̱ mwaasi̱, Mbaa mbi̱re̱ wu diyou yaa kasi̱ kana wiino mi̱ri̱nggi̱ bu nyi̱ti̱ti̱ bo̱o̱ ba li̱yanga. ");
INSERT INTO wja_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ka bago̱n mo̱ ni̱ngami̱n we̱le̱m, ma amna bo̱nggo̱ yo̱u̱ ma ju̱ku̱ yo̱ li̱yari̱ ye̱i̱, dwii mbi̱r ro̱p ti̱bak. Ka kar twiyau ma mi̱ra bago̱n mo̱. ");
INSERT INTO wja_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Anda ka, ka bu twiyau ne̱ ma de̱ ne̱re̱ wiino kana nu̱wa ro̱p kem yi̱ mo̱, palaka kana ca tu ma se̱e̱ ba yo̱o̱ ji̱re̱ a cu̱du̱ nu̱wa ro̱p kana kunong bu twii se̱e̱daki̱ bwii. ");
INSERT INTO wja_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Pero ka kwa kagu twiyau ma de̱e̱ bo̱nggo̱ ikkilisiya, ka kwaa kagu twiyau ikkilisiya, bu de̱e̱ twii ne̱re̱ wu so̱m bu Yamba yi̱ ne̱re̱ wu yi̱ri̱ janggal. ");
INSERT INTO wja_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","<<Pero n wo̱o̱ sagu̱mbi̱ru̱ ji̱re̱ kana ca tu bu kwe̱e̱ a si̱ma a kwauwa a diyou tu bu pe̱ra a si̱ma a pe̱rwa a diyou. ");
INSERT INTO wja_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","<<Bambang n cwatugu sagu̱mbi̱ru̱, kana pe̱ne̱ pe̱ne̱ ka nu̱wa ro̱p cu̱du̱ mbi̱ri̱ ne̱ci̱ dwii a pi̱naa si̱ma, ce̱ ku̱ru̱ a dwii kana ca Mbaa mi wu diyou ni̱nga mbi̱ru̱ we̱i̱. ");
INSERT INTO wja_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Di̱ngi̱n pu nu̱wa ro̱p kana kunong ku̱ranga bu̱ri̱ yi̱ din mi, n wo̱o̱ kem yi̱ pma.>> ");
INSERT INTO wja_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Bur Bitrus baa bo̱nggo̱ Yesu a pi̱ra ki̱n, <<Mbaa Wu gi̱ra, n paramanu we̱i̱ bago̱n mi sukom daa so̱no̱, ka ni̱nga ngin we̱le̱m? Daa nibiyo ru? ");
INSERT INTO wja_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesu nyi̱i̱ le̱e̱ ki̱n, <<Yaa yi̱to̱, yaa daa nibiyo, anda kun nibiyo daa nibiyo. ");
INSERT INTO wja_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Di̱ngi̱n to̱no̱ lau̱ ku diyou ci̱ka balaa wu kangge̱ wu kasi̱ ba su̱wa gi̱na yo̱ wu bo̱nggo̱ ke̱waa ya. ");
INSERT INTO wja_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Pu toso su̱gu̱, nu̱wa de̱mu̱we̱ yo̱ ke̱we̱ yo̱ wu po̱ng tale̱nti̱ tedu kwap. ");
INSERT INTO wja_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ke̱we̱ wii yaa ku pu bu yagu ci̱n dwii, di̱ngi̱n to̱no̱ ne̱re̱ wu gi̱ra yo̱ wii a diina nu̱wa ba te̱e̱ ba cuu yo̱ kem yi̱ nu̱ru̱ yo̱ yi̱ kwaraya yi̱ mwa mwa yi̱ri̱ngi̱ tu wo̱o̱ yi̱ to̱no̱i̱ ba ya ci̱ne̱ dwii. ");
INSERT INTO wja_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ke̱we̱ wii a yara kun kwiyou yi̱ dinendi a gawu̱ri̱ balaa a ce̱ ki̱n, <Ni̱nga kanadi yi̱ mi, n senggu mau, n yami̱nu̱ we̱i̱ kana ca!> ");
INSERT INTO wja_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ne̱re̱ wu gi̱ra yo̱ wii nu̱u̱ bunam yo̱u̱, a duu ci̱n dwii, a dwiya mwati̱. ");
INSERT INTO wja_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Bur ne̱re̱ wii baa kaanga yi̱ basi̱n wu̱rai̱ yo̱ wu kangge̱ wu po̱ng yo̱ dinari wo̱o̱n. A te̱e̱ kwi̱i̱ a ce̱gu̱ ki̱n, <Yangge̱ ci̱ne̱ mi!> ");
INSERT INTO wja_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Basi̱n wu̱rai̱ yo̱ a kun kwiyou yi̱ dinendi a gawu̱ri̱ ye̱i̱ a senggo ki̱n, <Ni̱nga kanadi yi̱ mi, n yami̱nu̱ we̱i̱!> ");
INSERT INTO wja_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Anda a kwaa, waka a de̱e̱ manna jaru̱m ko̱po̱ ku ya yo̱ ci̱ne̱ ye̱i̱. ");
INSERT INTO wja_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ku ke̱waa bu kangga bwii ko̱ tu ni̱ng wai gaanggi̱r pmai bwiiwa, pma aanda sa ne̱re̱ wu gi̱ra pma kana ca tu ni̱ng wai. ");
INSERT INTO wja_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ne̱re̱ wu gi̱ra wii yi̱we̱ ke̱we̱ wii a se̱e̱ ki̱n, <Ma ke̱we̱ wu yi̱ tu̱we̱, n yapa mi̱n cine mai̱ mwa mwa, di̱ngi̱n ma sengangge. ");
INSERT INTO wja_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Daabu na ma nu̱u̱ bunam bago̱n mo̱ ke̱we̱ ci̱ka ku n nu̱u̱ bunam mau ru?> ");
INSERT INTO wja_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ne̱re̱ wu gi̱ra yo̱ wii suko wang, a manni̱ ke̱we̱ wii jaru̱m, nu̱wa ba turongo ko̱po̱ ka yar ci̱ne̱ dwii mwa mwa.>> ");
INSERT INTO wja_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","<<To̱o̱ tu n Mbaa mi wu diyou ni̱nga manu we̱i̱ kana wo̱no̱ mbi̱re̱ ko̱po̱ ka bu paraman sukom kambaa yi̱ gaanggu̱ kiino. ");
INSERT INTO wja_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Pu Yesu mata ce̱gu̱ to̱o̱ yi̱ri̱ngi̱, a du Galili mwati̱ si̱ma Yudaya bo̱nggo̱ wu kangge̱ wu you ku Urdun. ");
INSERT INTO wja_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Nu̱wa tum po̱ng yo̱ pwii a mi̱ra pma yi̱langa. ");
INSERT INTO wja_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Parisayo bu kangga baanga bo̱nggo̱ yo̱u̱ ba cu̱u̱ yo̱, pma pi̱ra ki̱n, <<Te̱e̱re̱ le̱e̱ ki̱n ne̱re̱ ba ji laabwiya nu̱re̱ yo̱ dwii kana ca ru?>> ");
INSERT INTO wja_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","A nyi̱i̱ le̱e̱ ki̱n, <<Bu ce̱ bu tu balgi̱ ru? <Yake̱ toson taawu̱ Yamba ruu pma nambare̱ yi̱ nu̱re̱,> ");
INSERT INTO wja_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","pero a ce̱ ki̱n, <Di̱ngi̱n to̱no̱ ne̱re̱ du̱r we̱i̱ mbaa yo̱ yi̱ njaa yo̱ ba ne̱ca bu̱ri̱ yi̱ nu̱re̱ yo̱ pma bu ro̱p bo̱o̱ yo̱o̱ we̱i̱ bu̱ri̱ kiino.> ");
INSERT INTO wja_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Pma yaa ro̱p me̱re̱ anda bu̱ri̱ wiino. Di̱ngi̱n to̱no̱ tu Yamba ne̱ca ne̱re̱ ba cwaani ya.>> ");
INSERT INTO wja_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Pma pi̱ra ki̱n, <<Di̱ngi̱n ca Musa sa pma ki̱n ne̱re̱ ba nyi̱i̱ nu̱re̱ yo̱ lakargar jigu laabwiya anda ba mana?>> ");
INSERT INTO wja_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesu nyi̱i̱ le̱e̱ ki̱n, <<Musa le̱e̱mbi̱ra bu ji laabwiya nu̱ru̱mba mba di̱ngi̱n gaanggi̱r mbi̱ri̱ cingcing. Anda gwak yaa yi̱to̱ yake̱ taa yo̱u̱. ");
INSERT INTO wja_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","N wo̱o̱ sagu̱mbi̱ru̱ mi̱n, kana we̱ wu man nu̱re̱ yo̱ ka yaa dwii taari̱ ne̱, ka yikir nu̱re̱ wu kangge̱ a ni̱nggu̱ taari̱ yi̱ yo̱.>> ");
INSERT INTO wja_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Kwati̱mba ya se̱e̱ ki̱n, <<Ka cu̱du̱ nu̱re̱ yi̱ bwi̱yate̱ yi̱to̱ we̱i̱, kujang ne̱re̱ ba ni̱ngi̱ yaa laabwiya.>> ");
INSERT INTO wja_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesu sa pma ki̱n, <<Yaa kana we̱ wu le̱e̱ we̱i̱ yi̱ do̱o̱ ci̱ye̱i̱, ko̱po̱ pma bu Yamba kalanga pma wa. ");
INSERT INTO wja_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Bu kangga ni̱nga bu laabwiya di̱ngi̱n twii po̱le̱, nu̱wa bi pma yi twii, bu kangga nu̱wa diin pma, pero bu kangga di̱ngi̱n lau̱ ku diyou. Anda kana we̱ wu le̱e̱ we̱i̱ yi̱ do̱ ci̱ye̱i̱, ba le̱e̱ yi̱ to̱no̱.>> ");
INSERT INTO wja_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Nu̱wa bu kangga de̱e̱ bakwaraa bu nyi̱ti̱ti̱ wa bo̱nggo̱ Yesu ba ce̱rman pma wari ba ce̱man pma ku̱ru̱. Anda kwati̱mba ya ye̱ra pma bu de̱e̱ bwii. ");
INSERT INTO wja_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yesu ce̱ ki̱n, <<Bu du bakwaraa bu nyi̱ti̱ti̱ wa ba baanga bo̱nggo̱ mu bu jari ya pma, di̱ngi̱n lau̱ ku diyou kwii ku pma bu ci̱ka bakwaraa wa.>> ");
INSERT INTO wja_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Pu ce̱rman pma wari, a mwati̱. ");
INSERT INTO wja_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ne̱re̱ wu kangge̱ baa bo̱nggo̱ Yesu a pi̱ra ki̱n, <<Ku̱lu̱me̱, tu nyaayi ye̱i̱ ca tu ni̱ngu̱ we̱i̱ palaka n nyi̱ngga pi̱i̱ma bu yaa mati̱gu̱ wa?>> ");
INSERT INTO wja_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesu nyi̱i̱ le̱e̱ ki̱n, <<Di̱ngi̱n ca ma pi̱rangge̱ tu nyaayi? Wu nyaa wiino ti̱bak, ka ma kasi̱ pi̱i̱ma bu yaa mati̱gu̱, ma ni̱nga po̱ngo̱ndi̱ yi̱ te̱e̱ri̱ngi̱.>> ");
INSERT INTO wja_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ne̱re̱ wii pi̱ra ki̱n, <<Twii, to̱no̱?>> Yesu nyi̱i̱ le̱e̱ ki̱n, <<Ma ji̱ri̱ ya ne̱re̱, ma ni̱ngi̱ ya taari̱, ma ni̱ngi̱ ya kuwii, ma nyi̱i̱ ya se̱e̱daki̱ leendi, ");
INSERT INTO wja_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ma nyi̱i̱ gi̱ru̱ mbaa mo̱ yi̱ njaa mo̱, pero ma kangman bapun mo̱ ci̱ka bu̱ri̱ mai.>> ");
INSERT INTO wja_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ne̱re̱ wii ce̱ ki̱n, <<N po̱ng to̱o̱ te̱e̱ri̱ngi̱ mwa mwa, tu nyona ca?>> ");
INSERT INTO wja_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu nyi̱i̱ le̱e̱ ki̱n, <<Ka ma kasi̱ ma yo̱o̱ ne̱re̱ wu twanga we̱i̱, mwati̱ ma cuu gi̱na mo̱ ma cwaanga baku̱u̱lu̱wa, ma nyi̱nggu̱ we̱i̱ gi̱na a pwii diyou Yambau̱. Anda ma baa ma po̱nggu̱we̱.>> ");
INSERT INTO wja_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Pu bwiyaka wii nu̱wa yi̱to̱, a mwati̱ yi̱ bwiyang gaanggu̱, di̱ngi̱n yi̱ gi̱na wang. ");
INSERT INTO wja_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yesu sa kwati̱mba ya ki̱n, <<N sagu̱mbu̱ru̱ ji̱re̱, ni̱ng we̱i̱ bu̱u̱ wang ne̱re̱ wu yi̱ gi̱na ba diiro lau̱ ku diyou. ");
INSERT INTO wja_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Pero n sagu̱mbu̱ru̱, ni̱ng we̱i̱ le̱e̱le̱e̱ nggela ba diiro bo̱u̱ li̱ppi̱rau̱, yi̱ ku̱ bagi̱na ba diiro lau̱ Yambau̱.>> ");
INSERT INTO wja_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Pu kwati̱mba ya nu̱wa yi̱to̱, pma riyanga bu̱ri̱ wang pero a pi̱ra ki̱n, <<Ka yi̱to̱ we̱i̱ wu nyi̱nggu̱ we̱i̱ mi̱rma we̱?>> ");
INSERT INTO wja_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesu su̱wa pma a ce̱ ki̱n, <<To̱o̱ gwala di̱mbi̱ri̱ ne̱ri̱, anda yaa tu gwala di̱mbi̱ri̱ Yambai̱.>> ");
INSERT INTO wja_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Bitrus le̱e̱ ki̱n, <<Yi du kana ca yi po̱ngmi̱na. Tu yi ki̱nggu̱ we̱i̱ ca?>> ");
INSERT INTO wja_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu sa pma ki̱n, <<N sagu̱mbu̱ru̱ ji̱re̱i̱, jo̱r du kana ca waatu̱ we̱i̱ bu̱ri̱ pu̱ci̱, pero pu Bo̱l Ne̱re̱ si̱i̱nu̱ we̱i̱ candu̱ lau̱ yo̱u̱ ku yi̱ yi̱lau̱, mba bu po̱nggu̱ wa bu si̱i̱nu̱ we̱i̱ canni̱ndi̱ lau̱ri̱ kwap su̱r ro̱p bu ni̱ngamanu̱ we̱i̱ bali̱ duuri kwap su̱r ro̱p tu Israila. ");
INSERT INTO wja_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Anda kana we̱ wu du laandi kana ci̱yamba bu nambi̱rmba kana nu̱ru̱mba wa, kana mbaate̱ kana njaate̱ kana kwaraa kana ko̱o̱ndi̱ di̱ngi̱n mi nyi̱nggu̱ we̱i̱ tum yo̱u̱ daa wo̱o̱n pero nyi̱nggu̱ we̱i̱ pi̱i̱ma bu yaa mati̱gu̱ wa. ");
INSERT INTO wja_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Anda nu̱wa tum bu gawu̱ri̱yo̱ wa, yo̱o̱ we̱i̱ bu go̱ro̱yo̱ wa, pero nu̱wa tum bu go̱ro̱yo̱ wa yo̱o̱ we̱i̱ bu gawu̱ri̱yo̱ wa. ");
INSERT INTO wja_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","<<Lau̱ ku diyou ci̱ka ne̱re̱ wu yi̱ ko̱ndo̱u̱ wu twiyo yi̱ pinu ki̱lang a nyi̱i̱ nu̱wa wu̱rai̱ a ko̱ndo̱u̱ yo̱u̱. ");
INSERT INTO wja_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","A nu̱wanga yaru̱ we̱i̱ pma dinari a nyanggu̱, a te̱ni̱ pma ko̱ndo̱u̱ yo̱u̱. ");
INSERT INTO wja_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","<<Ku jo̱r du to̱ro̱ ni̱nga a twiyo a ko̱ bu kangga pi̱si̱ndi̱ lummo yaa tu ni̱nggi̱. ");
INSERT INTO wja_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","A sa pma, <Mba mwa bu ambi̱ra bu ni̱nga wu̱rai̱ a ko̱ndo̱u̱ mu, n ya mbi̱ru̱ we̱i̱ tu daayai.> ");
INSERT INTO wja_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Di̱ngi̱n to̱no̱ pma aanda ba ni̱nga wu̱rai̱ a ko̱ndo̱u̱ wii. <<Yo̱ pero mwati̱ yi̱ cu̱di̱ nyanggu̱ yi̱ jo̱r du kunong do̱ng, a ni̱nga ci̱ka ku co̱nggo̱ nu̱wanga. ");
INSERT INTO wja_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Pu jo̱r du nu̱wo̱ wu nyambi̱ranggu̱ ni̱ngau̱, pero a twiyo a nyi̱ngga bu kangga pi̱ti̱ndi̱. A pi̱ra pma ki̱n, <Di̱ngi̱n ca bu pi̱ti̱ndi̱ pi̱na yaa tu bu ni̱nggi̱ nyanggu̱ mwa mwa?> ");
INSERT INTO wja_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","<<Pma nyi̱i̱ le̱e̱ ki̱n, <Yaa ne̱re̱ wu de̱e̱ yiro wu̱rai̱.> <<A sa pma ki̱n, <Mba mwaasi̱ bu ambi̱ra bu ni̱nga wu̱rai̱ a ko̱ndo̱u̱ mu.> ");
INSERT INTO wja_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","<<Pu nyambi̱ranggu̱ ni̱ngau̱ ne̱re̱ wu ko̱ndo̱u̱ we̱yo̱u̱ yi̱we̱ ne̱re̱ wu su̱gu̱ ko̱ndo̱u̱ a se̱e̱ ki̱n, ba yi̱we̱ nu̱wa bu ni̱nggu̱ wu̱rai̱ bwi̱i̱, toso bu baa yi̱ go̱ro̱u̱ wa a be̱e̱ bu gawu̱ri̱yo̱ wa.> ");
INSERT INTO wja_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","<<Nu̱wa bu toso wu̱rai̱ jo̱r du nu̱wo̱ wu nyambi̱ranggu̱ pma baanga nu̱wa nyi̱i̱ pma dinari. ");
INSERT INTO wja_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Di̱ngi̱n to̱no̱ bu nu̱wa nyi̱i̱ wu̱rai̱ gawu̱ri̱yo̱ wa, pma baanga dangani̱ ki̱n nu̱wa yaru we̱i̱ pma tum gwala we̱i̱ bu go̱ro̱yo̱ wa. Anda kana wo̱no̱ pmo nu̱wa nyi̱i̱ dinari. ");
INSERT INTO wja_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Pu nu̱wa nyi̱i̱ pma nyi̱na, pma toso jangga ce̱u̱ bo̱nggo̱ ne̱re̱ wu si̱ma bo̱o̱ ya. ");
INSERT INTO wja_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Pma ce̱ ki̱n, nu̱wa bu baa yi̱ go̱ro̱ bo̱o̱ pma ni̱nga wu̱rai̱ nyan jo̱r du wiino anda bu ya yiro kiino yi̱ pma yo bu yar nyanggu̱ wu̱rai̱ wa.> ");
INSERT INTO wja_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","<<A sa wu kanggi̱ pma ki̱n, <Basi̱n mi, yaa ku n ni̱nga dwal ji̱re̱. Ma le̱e̱ bu mi̱n ma ni̱nggu̱ we̱i̱ wu̱rai̱ nyan dinari ru? ");
INSERT INTO wja_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ma yi̱ tu nu̱wa ya mi̱na ma mwatanga. N kasi̱ n ya ne̱re̱ wu baa yi̱ go̱ro̱ yi̱to̱ mwaasi̱ ci̱ka ku n ya mi̱na. ");
INSERT INTO wja_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","N puu ni̱nggu̱ tu n kasi̱ yi̱ ke̱n mi ru? Ma ni̱nggu̱ bwiu di̱ngi̱n mi ni̱i̱ ru? ");
INSERT INTO wja_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","<<Di̱ngi̱n to̱no̱, nu̱wa bu go̱ro̱yo̱ wa, yo̱o̱ we̱i̱ bu gawu̱ri̱yo̱ wa, pero nu̱wa bu gawu̱ri̱yo̱ wa yo̱o̱ we̱i̱ bu go̱ro̱yo̱ wa.>> ");
INSERT INTO wja_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Pu Yesu wo̱o̱ mwatugu Wurcalima, a de̱ kwati̱mba ya bu kwap su̱r ro̱p bwii a bo̱nggo̱ a sa pma ki̱n, ");
INSERT INTO wja_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","<<Yi mwatangu Wurcalima anda nu̱wa cuuru we̱i̱ Bo̱l Ne̱re̱ bo̱nggo̱ bagi̱raa kuruwa yi̱ ku̱lu̱mba te̱e̱ri̱ngi̱ wa. Pma mwarmanu̱ we̱i̱ yo̱ bal bo̱o̱ri̱, ");
INSERT INTO wja_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ba nyi̱i̱ yo̱ war nu̱wa bu yaa yo̱o̱gi̱ nu̱wa bu Yudaya wa, pma ni̱ngamanu̱ we̱i̱ yo̱ nyasi̱, waci̱ru̱ we̱i̱ pero pi̱i̱ni̱ we̱i̱ ye̱u̱. Nyanggu̱ ku kunong wuni we̱i̱ yi̱ pi̱i̱ma.>> ");
INSERT INTO wja_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Go̱ro̱ yi̱to̱ njaa kwaraa Sabadi baa gawu̱r Yesu kem yi̱ kwaraa ya a kun kwiyei a senggo yo̱ ba ni̱ngaman yo̱ yi̱ri̱ tu kanggi̱. ");
INSERT INTO wja_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesu pi̱ra ki̱n, <<Tu ma kasi̱gu̱ ca?>> A se̱e̱ ki̱n, <<Ma nyi̱i̱ kwaraa muwa bu ro̱p bi̱naa pi̱su̱ wu nyaayi a lau̱ mau, wu wiino a wai mau wu je̱u̱ wu kangge̱ a wai mau wu miyu.>> ");
INSERT INTO wja_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesu sa pma ki̱n, <<Bu so̱m bu tu bu senggu. Bu puu we̱i̱ ti̱i̱gu̱ ku̱u̱le̱ wu n ti̱i̱ we̱i̱ ru?>> Pma le̱e̱man yo̱ ki̱n, <<Yi puu we̱i̱.>> ");
INSERT INTO wja_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesu sa pma ki̱n, <<Bu ti̱i̱ we̱i̱ ku̱u̱le̱ wu n ti̱i̱ we̱i̱. Anda n yaa di̱mbi̱re̱ n se̱ka wu si̱nu̱ we̱i̱ wai wu je̱u̱ mu kana wai wu miyu mu. So̱o̱ pi̱si̱ndi̱ ko̱po̱ bu Mbaa mi me̱ne̱man pma wa.>> ");
INSERT INTO wja_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ku kwati̱mba bu kwap bwii nu̱wa yi̱to̱ pma sukongo yi̱ ci̱yamba bu ro̱p bwii. ");
INSERT INTO wja_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yesu yi̱we̱ pma mwa mwa a ce̱ ki̱n, <<Bu so̱ma nu̱wa bu je̱e̱gi̱ lau̱ dwii nu̱wa bu yaa yo̱o̱gi̱ nu̱wa bu Yudaya wa ju̱ku̱r nu̱wa pma lau̱ pero bagi̱raa pma je̱e̱ lau̱ dwii pmai.>> ");
INSERT INTO wja_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Anda yaa yi̱to̱ yi̱ mba. Wu kasi̱ ba yo̱ wu gi̱ra a cu̱di̱ mbi̱ri̱, ba yo̱o̱ ke̱we̱ mbi̱re̱. ");
INSERT INTO wja_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Kana we̱ wu kasi̱ ba yo̱o̱ wu gawu̱ri̱yo̱ tagi̱ ba yo̱o̱ ke̱we̱ mbi̱re̱, ");
INSERT INTO wja_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ci̱ka ku Bo̱l Ne̱re̱ baa bu nu̱wa ba yo̱o̱ ke̱waa ya anda a baa ba yo̱o̱ ke̱we̱ nu̱wa pero ba nyi̱i̱ pi̱i̱ma ya, palaka ba mi̱ra nu̱wa tum. ");
INSERT INTO wja_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Pu Yesu yi̱ kwati̱mba ya dugu Yeriko, nu̱wa tum po̱ng pma. ");
INSERT INTO wja_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Kerma ro̱p pi̱si̱ndi̱ gi̱ngu̱ nyinou, pu nu̱wa ki̱n Yesu cwiigu, pma ni̱nga duwai ki̱n, <<Mbaa Wu Gi̱ra, Bo̱l Dawud, nu̱u̱ bunam yiru!>> ");
INSERT INTO wja_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Nu̱wa bu ku̱ranggi̱ bu̱ri̱ bwii a ye̱ra pma ba si̱n si̱ye̱ndi̱ to̱k, anda pma cwata duwai ki̱n, <<Mbaa Wu Gi̱ra, Bo̱l Dawud nu̱u̱ bunam mu. ");
INSERT INTO wja_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesu a ti̱n ti̱yau̱ a yi̱ pma, a sa pma ki̱n, <<Tu bu kasi̱ n ni̱ngambi̱ra ca?>> ");
INSERT INTO wja_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Pma le̱e̱man yo̱ ki̱n, <<Mbaa Wu Gi̱ra yi kasi̱ yi ko̱ si̱ma.>> ");
INSERT INTO wja_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesu nu̱u̱ bunam pmau, a mwaanga nundi pmai. Yo̱ko̱ yo̱ko̱ pma ko̱ si̱ma, pma po̱ng yo̱. ");
INSERT INTO wja_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Pu Yesu yi̱ kwati̱mbaya ni̱nga ne̱m Wurcalima pma baanga gwe̱i̱ Betpaji a dwii Cing Souri Setun, Yesu tum kwati̱mba ya ro̱p, ");
INSERT INTO wja_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","a sa pma ki̱n, <<Bu ambi̱ra gwe̱i̱ du gawu̱ri̱ mbi̱ri̱, ka bu tengma bu kwe̱e̱ we̱i̱ bako̱ro̱ twalgi pwii, yi̱ twiyaa yo̱ bo̱nggo̱ yo̱u̱. Bu pe̱ra bu de̱nggu̱we̱. ");
INSERT INTO wja_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ka kana we̱ sambi̱r ci̱ye̱i̱, bu se̱e̱ mi̱n, <Mbaa Wu Gi̱ra kasi̱gu̱,> dumbiri we̱i̱ bu de̱e̱ yo̱ko̱ yo̱ko̱. ");
INSERT INTO wja_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","To̱o̱ yi̱ri̱ngi̱ ni̱ngwa, palaka ba twanga tu banabi̱ ce̱i̱, ");
INSERT INTO wja_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","<<Bu sa nu̱wa bu Wurcalima mi̱n, <Bu ko̱, balaa mbi̱re̱ baaggu yi̱ dwii du ci̱nggai̱ geenggi a dwii bako̱ro̱, a dwii twiyaa bako̱ro̱.>>> ");
INSERT INTO wja_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Kwati̱mba ya bwii mwatanga ni̱nga ci̱ka ku Yesu sa pma. ");
INSERT INTO wja_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Pma de̱e̱ bako̱ro̱ yi̱ twiyaa bako̱ro̱, pma ke̱naman gatanggamandi pmai dwii bako̱ri̱ swii, Yesu si̱i̱na dwii gatanggamandi twii. ");
INSERT INTO wja_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Nu̱wa tum ni̱nga pu ke̱ne̱nggu̱ gatanggamandi pmai a nyinou a gawu̱ri̱ ye̱i̱, anda bu kangga pma kaca ye̱ndi̱ souri a ke̱namana nyinou. ");
INSERT INTO wja_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Nu̱wa tum bu gawu̱ri̱ ye̱i̱ wa yi̱ bu po̱nggu̱ yo̱ go̱ro̱ wa, pma ni̱nggu̱ duwai ki̱n, <<Yi te̱ranga bo̱l Dawud! Wuure bo̱nggo̱ yo̱ wu bagu̱ mi̱ri̱nggi̱ din Mbaa Wu Gi̱rai̱. Yi te̱ranga Yamba wu wo̱o̱ diyou.>> ");
INSERT INTO wja_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Pu Yesu diiro Wurcalima, mwa mwa gwe̱i̱ dwii pi̱ro̱, a ni̱nggu̱ pi̱ra ki̱n, <<Wo̱o̱ we̱?>> ");
INSERT INTO wja_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Nu̱wa bu tum bwii nyi̱i̱ le̱e̱ ki̱n, <<Wo̱o̱ Yesu banabi̱ wu baa Nasaret du Galili.>> ");
INSERT INTO wja_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu diiro Laa Yambau̱ a ke̱ke̱nga nu̱wa bu cuugu yi̱ te̱nggu̱ yi̱ri̱ngi̱ wa a pwii. A su̱kaman si̱yau̱ tebur nu̱wa bu waki̱ ke̱n wa, yi̱ pi̱si̱ndi̱ nu̱wa bu cuugu bamori Masar wa. ");
INSERT INTO wja_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","A sa pma ki̱n, <<Balgi̱, laa mu nu̱wa yi̱ri̱ we̱i̱ ki̱n, laa ku̱ru̱, anda mba bu de̱e̱ bu yo̱o̱ laa kuuwau.>> ");
INSERT INTO wja_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Kermo yi̱ gu̱wo̱ngi̱ baanga bo̱nggo̱ yo̱ a laa Yambau̱, a mi̱ra pma yi̱langa. ");
INSERT INTO wja_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Pu bagi̱ra kuruwa yi̱ ku̱lu̱mba te̱e̱ri̱ngi̱ wa ko̱ yi̱ri̱ngi̱ ri̱yandi̱ bu̱ri̱ tu ni̱ngai̱ pero nu̱u̱ tu bakwara bu ni̱nggu̱ bu̱ri̱ de̱gde̱g a mi̱ri̱nggi̱ laa Yambau̱ ce̱gu̱ ki̱n, <<Yi te̱ranga Bo̱l Dawud, Hossana!>> Pma sukongo. ");
INSERT INTO wja_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Pma pi̱ra ki̱n, <<Ma nu̱gu̱ tu bakwara bo̱o̱ ce̱gu̱ ri̱?>> Yesu nyi̱i̱ le̱e̱ ki̱n, <<O̱ng, yaa ku bu ce̱ mi̱ri̱nggu̱ lakargar ru? <Wii mo̱ ma ju̱ku̱ bakwaraa bu nyi̱ti̱ti̱ wa yi̱ bweegaa ba te̱ra mi̱na.>>> ");
INSERT INTO wja_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","A du pma mwati̱ gwe̱i̱ Betani a daa pwii. ");
INSERT INTO wja_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Yi̱ pinu ki̱lang, pu waati̱gu̱ gwe̱i̱ Yesu nu̱u̱ ju̱ne̱. ");
INSERT INTO wja_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","A ko̱ sou pwalgu̱ ku kanggu̱ a nyinou a aara bo̱nggo̱ yo̱u̱ anda yaa tu nyi̱nggai̱ bur wandi̱. Bur a ce̱ ki̱n, <<Yama ma peri ya twiyagu me̱re̱!>> Bu̱ri̱ sou kwii ku̱su̱wa ki̱nangu̱. ");
INSERT INTO wja_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Pu kwati̱mba ya ko̱ yi̱to̱ pma ri̱yanga bu̱ri̱. Pma ni̱nga pi̱ra ki̱n, <<A ni̱ngwa nye̱ sou pwalgu̱ ko̱o̱ ku̱su̱wa ki̱ne̱ngu̱ yi̱to̱? ");
INSERT INTO wja_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesu nyi̱i̱ pma le̱e̱ ki̱n, <<N wo̱o̱ sagu̱mbi̱ru̱ ji̱re̱i̱, ka bu le̱e̱ ji̱re̱, bu ni̱nga bu gaanggi̱r ro̱p ne̱, bu ni̱ng we̱i̱ tu ni̱ngwa yi̱ sou pwalgu̱ ko̱o̱, anda bu̱ri̱ to̱o̱ yi̱ wundu ne̱, bu saru we̱i̱ ci̱ngu̱ ki̱na mi̱n, <Mwati̱, ma manni̱ bu̱ri̱ mai kali̱nggu̱,> ni̱ngdu̱ we̱i̱. ");
INSERT INTO wja_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ka bu le̱e̱ ji̱re̱, kana ca tu bu senggo mi̱ri̱nggu̱ ku̱ru̱ bu ki̱nggu̱ we̱i̱. ");
INSERT INTO wja_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu diiro laa Yambau̱, pu wo̱o̱ ju̱ku̱gu̱ yi̱ri̱ngi̱ nu̱wa, bagi̱raa kuruwa wa yi̱ bagi̱raa nu̱wa wa a baanga bo̱nggo̱ yo̱u̱, pma pi̱ra ki̱n, <<Ma ni̱nggu̱ to̱o̱ yi̱ri̱ngi̱ yi̱ di̱mbi̱re̱ we̱? Pero wu nyi̱i̱mi̱n wo̱o̱ di̱mbi̱re̱ we̱? ");
INSERT INTO wja_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesu nyi̱i̱ pma le̱e̱ ki̱n, <<Mi mwa n pi̱rambi̱ri̱ we̱i̱ pi̱ra wiino, ka bu nyi̱i̱nggi̱ le̱e̱ n sambi̱ri̱ we̱i̱, ka ni̱nggu̱ ti̱na yi̱ri̱ngi̱ yi̱ di̱mbi̱re̱ we̱ we̱i̱. ");
INSERT INTO wja_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Di̱mbi̱re̱ wu Yohanna Ni̱ngi̱ Bati̱si̱ma yi̱ to̱no̱, a baa pi̱yau̱, a baa diyou ru? A baa bo̱nggo̱ ne̱re̱ ru?>> Pma ni̱nga pu dangandi̱ a cu̱du̱ pmai ki̱n, <<Ka yi ce̱ mi̱n, a baa diyou, pi̱rayi̱ri̱ we̱i̱ ki̱n, <Di̱ngi̱n ca bu kwaa le̱e̱gu̱ ji̱re̱ yi̱ yo̱?> ");
INSERT INTO wja_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Anda ka yi ce̱ mi̱n, <A baa bo̱nggo̱ ne̱ru̱,> yi nu̱gu̱ gwasi̱ nu̱wa di̱ngi̱n pma mwa mwa le̱e̱ ki̱n Yohanna twii banabi̱.>> ");
INSERT INTO wja_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Di̱ngi̱n to̱no̱ pma nyi̱i̱ le̱e̱ Yesu ki̱n, <<Yi so̱m bu.>> A sa pma ki̱n, <<Mi mwa n sambi̱re̱ ka n ni̱nggu̱ to̱o̱ wo̱o̱ yi̱ di̱mbi̱re̱ we̱ we̱i̱.>> ");
INSERT INTO wja_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","<<Bu danggu̱ we̱i̱ mi̱n ca, a dwii ci̱ye̱i̱ di̱na? Wo̱o̱ yi̱ ne̱re̱ wu yi̱ ba kwaraa ro̱p. A aara bo̱nggo̱ wu gawu̱ri̱yo̱ a se̱e̱ ki̱n, <Amna ma ni̱nga wu̱rai̱ a ko̱ndo̱u̱.> ");
INSERT INTO wja_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","A nyi̱i̱ le̱e̱ ki̱n, <N anggi̱.> Anda cwata go̱ro̱u̱ a waka dangandi̱ ye̱i̱ a aara. ");
INSERT INTO wja_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","<<Mbaate̱ wii aara bo̱nggo̱ wu kanggi̱ wii a se̱e̱ ci̱ka ku co̱nggo̱ ce̱u̱, a le̱e̱ man yo̱ ki̱n, <N anggu we̱i̱ mbaa,> anda yaa ku aarau. ");
INSERT INTO wja_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","<<Wu ni̱nga tu mbaa pma kasi̱gu̱ we̱ cu̱du̱ pmai?>> Pma nyi̱i̱ le̱e̱ ki̱n, <<Wu gawu̱ri̱yo̱ wii.>> Yesu sa pma ki̱n, <<N wo̱o̱ sagu̱mbi̱ru̱ ji̱re̱ nu̱wa bu yi̱ri̱ janggal yi̱ karmaji̱ndi̱ gi̱ci̱la mbi̱r we̱i̱ tengma lau̱ Yambau̱. ");
INSERT INTO wja_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Di̱ngi̱n Yohanna baa ba ju̱ku̱ mbi̱r nyinou ni̱nggu̱ pi̱su̱ wu nyaau a gawu̱ri̱ Yambai̱, bu kwaa le̱e̱gu̱ ji̱re̱, anda nu̱wa bu yi̱ri̱ janggal wa yi̱ karmaji̱ndi̱ pma le̱e̱. Pero kana pu bu ko̱ to̱o̱ yi̱ri̱ngi̱ bu kwaanga bwiiwa yi̱ le̱e̱gu̱ ji̱re̱ yi̱ yo̱. ");
INSERT INTO wja_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","<<Bu ka twiyau ci̱ye̱i̱ du balanggai̱ du kanggi̱. Wo̱o̱ yi̱ ne̱re̱ wu kangge̱ wu yi̱ ko̱ndo̱u̱, a ruu souri inabi. A wo̱ra yi̱ garu. A wul bo̱u̱ dudu a swe̱li̱ du karkar pu nu̱wa yamnu we̱i̱ gundu inabi pero a mo̱o̱ cire. Bur a du̱u̱ bajo̱mba bu kangga a ni̱nga so̱ngma. ");
INSERT INTO wja_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Pu jo̱r wagu̱ inabi ni̱ngau̱, a tu̱m ke̱waa ya a bo̱nggo̱ bajo̱mba bwii, ba yi̱mu̱we̱ yo̱ tutwiyari inabi. ");
INSERT INTO wja_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Bajo̱mba bwii ta ke̱waa bwii, pma buwanga wiino, a ji wu kangge̱ pero bacanga wu kunong. ");
INSERT INTO wja_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Bambang a tu̱m ke̱waa bu kangga bo̱nggo̱ pmau gwala bu gawu̱ri̱yo̱ wa, bajo̱mba bwii ni̱nga ci̱ka ku co̱nggo̱ ni̱ngau̱, ");
INSERT INTO wja_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Cwata go̱ro̱u̱ a tu̱m bo̱l yo̱ bo̱nggo̱ pmau. A ce̱ ki̱n, <Pma nyi̱i̱ we̱i̱ gi̱ru̱ yake̱ ku twii bo̱l mi ko̱.> ");
INSERT INTO wja_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","<<Pu bajo̱mba bwii ko̱ bwi̱ya wii bagu̱, sa bu̱ri̱ pmai ki̱n, <Su̱wa ne̱re̱ wu ko̱ndo̱u̱ wuna yo̱o̱ we̱i̱ weyau wo̱o̱ baayi, yama yi jiyo palaka gina yo̱ ba yo̱o̱ woyire.> ");
INSERT INTO wja_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Di̱ngi̱n to̱no̱ pma ta yo̱, a baci̱we̱ si̱ye̱i̱ go̱ro̱ ko̱ndo̱u̱ wii, a jiyo. ");
INSERT INTO wja_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Di̱ngi̱n yi̱to̱ ka ne̱re̱ wu ko̱ndo̱u̱ wayau̱ baayi, ni̱ngu̱ we̱i̱ nye̱ yi̱ bajo̱mba bwii?>> ");
INSERT INTO wja_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Pma ce̱ ki̱n, <<Ne̱re̱ wii baa lacu̱we̱i̱ bajo̱mba bu bwiiwa bwii yi̱ bo̱o̱ri̱ du yi̱ buwi, ba nyi̱i̱ ko̱ndo̱u̱ wii bajo̱mba bu kangga bu nyi̱i̱ we̱i̱ yo̱ tutwiyari ko̱ndo̱u̱ wa ka jo̱r wagu̱ ni̱ngi̱.>> ");
INSERT INTO wja_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesu sa pma ki̱n, <<Bu ce̱ bu mi̱ri̱nggu̱ Lakargar Yamba ru? <Swe̱li̱ du mwe̱e̱mba kwaanga, a yo̱o̱ swe̱li̱ du nyaayi du mwe̱e̱mba ce̱nna ge̱nge̱lte̱. To̱o̱ ni̱nggu̱ Mbaa Wu Gi̱ra, to̱o̱ yi̱ri̱ngi̱ ri̱yandi̱ bu̱ri̱ a nundi yiri.> ");
INSERT INTO wja_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Di̱ngi̱n to̱no̱, n sagu̱mbi̱ru̱ nu̱wa de̱manu̱ we̱i̱ lau̱ Yambau̱ bo̱nggo̱ mbi̱ru̱, ba nyi̱i̱ nu̱wa bu twiya we̱i̱ tutwiyari ye̱i̱. ");
INSERT INTO wja_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Kana we̱ wu yaramana swe̱le̱ dwii re̱pu̱ru̱ we̱i̱ cuk cuk, pero ka swe̱le̱ dwii yarman kana we̱, ko̱o̱ we̱i̱ pwangge̱ li̱ngli̱ng ci̱ka miima.>> ");
INSERT INTO wja_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Pu bagi̱raa kuruwa yi̱ Parisayo nu̱u̱ ci̱ye̱i̱ du balanggai̱ du Yesu ce̱i̱, pma ku̱ranga ki̱n a ce̱gu̱ pma. ");
INSERT INTO wja_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Pma kasa ba ta yo̱, anda pma nu̱u̱ gwasi̱ nu̱wa di̱ngi̱n pma de̱e̱ twii banabi̱. ");
INSERT INTO wja_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu sa pma ci̱ye̱i̱ du balanggai̱ do̱ng ki̱n, ");
INSERT INTO wja_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","<<Lau̱ ku diyou ci̱ka balaa wu ni̱nga waandi laabwiya bo̱l yo̱. ");
INSERT INTO wja_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","A tu̱m ke̱waa ya ba sa ci̱ye̱i̱ nu̱wa bu yo̱ yi̱we̱ wa ba baanga waandi swii anda pma kwaanga baaggu. ");
INSERT INTO wja_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","<<A pero tu̱m ke̱waa bu kangga a ce̱ ki̱n, Bu sa pma bu nu̱wa sa pma ci̱ye̱i̱ wa mi̱n n mata me̱ne̱nggu̱ je̱e̱ndi̱. N laca go̱mto̱ro̱ngi̱ yi̱ tanggi mi su mwalanggi̱, kana ca me̱ne̱nggi̱. Bambe̱ waandi laabwiya.> ");
INSERT INTO wja_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","<<Anda pma yaa ku ka twiyau, pma mwatanga, bu kangga aanda ko̱ndo̱u̱, bu kangga aanda lummo. ");
INSERT INTO wja_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Bu kangga taa ke̱waa bwii a turongo pma, a laca pma. ");
INSERT INTO wja_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Balaa wii suko wang. A tu̱m kacara ya laca nu̱wa bu laca ke̱waa bwii, a taa gwe̱i̱ dwii mwa mwa. ");
INSERT INTO wja_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","<<Pero a sa ke̱waa ya bu tu̱ma bwii ki̱n, <Waandi laabwiya si̱na ci̱pi̱gi̱ anda nu̱wa bu n gi̱ci̱la n tu̱m man pma wa pma yinnibu ba baanga. ");
INSERT INTO wja_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ambi̱ra nyindi su mi̱ri̱nggi̱ gwe̱i̱ bu sa ci̱ye̱i̱ kana we̱ wu bu nyi̱ngga ba baa waandi si̱na.> ");
INSERT INTO wja_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Di̱ngi̱n to̱no̱ ke̱waa bwii mwati̱ a po̱nggu̱ nyindi a ku̱ranga nu̱wa mwa mwa bu nyi̱ngga wa, bu nyaa wa yi̱ bu bwi̱i̱ wa, laa laabwiya twangwa yi̱ ru̱nggu̱wa. ");
INSERT INTO wja_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","<<Pu balaa diiro ba ko̱ ru̱nggu̱wa, a ko̱ ne̱re̱ wu kangge̱ wu yaa se̱e̱ laabwiya. ");
INSERT INTO wja_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","A pi̱ra ki̱n, <Basi̱nte̱, a ni̱ng we̱i̱ nye̱ ma dimmuwe pi̱na yaa se̱e̱ laabwiya?> Ne̱re̱ wii yaa pu̱u̱na. ");
INSERT INTO wja_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","<<Balaa wii sa ke̱waa ya bu su̱gu̱ pma bwii ki̱n, <Twala wari yi̱ mwari ma yikiyo twalange̱ ma manna pu yi̱ ku̱mji̱la, pma jii we̱i̱ wiindi yi̱ dumonggu nyi̱yau̱.> ");
INSERT INTO wja_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","<<Nu̱wa bu nu̱wa yi̱yanga wa tum, anda bu nu̱wa se̱ka wa banyi̱na.>> ");
INSERT INTO wja_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Bu̱ri̱ Parisayo twiyongo twalange̱ a kasa nyindi, ba ciman Yesu tandau a bo̱nggo̱ ce̱u̱ ye̱i̱. ");
INSERT INTO wja_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Pma suka kwati̱mba pma kem yi̱ nu̱wa Hiridus wa pma ce̱ ki̱n, <<Ku̱lu̱me̱, yi so̱ma mai ji̱re̱. Pero ma ju̱ku̱r nyinou Yambau̱ yi̱ ji̱re̱, ma yaa se̱ki̱ nu̱wa, ma de̱ nu̱wa mwa mwa wai̱yo̱u̱ wiino.>> ");
INSERT INTO wja_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Yo̱ko̱ sa yiro, a ko̱gu̱ mo̱u̱ ci̱maci̱ma yi ya janggal Balaa Kaisar ru, ba yari̱ ya ru?>> ");
INSERT INTO wja_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yesu so̱m dangandi̱ pmai tu bwi̱i̱, a ce̱ ki̱n, <<Mba nu̱wa bu yi̱ batal wa, di̱ngi̱n ca bu kasi̱ bu ciingin mu tandau? ");
INSERT INTO wja_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Bu ju̱ku̱nggi̱ ke̱n du nu̱wa yari̱ janggal dwii.>> Pma de̱ nyi̱i̱ya, ");
INSERT INTO wja_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","a ce̱ ki̱n, <<Wekilei yi̱ din di̱naa du we̱i̱? ");
INSERT INTO wja_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Pma ce̱ ki̱n, <<Do̱o̱ du Balaa Kaisar.>> A sa pma ki̱n, <<Bu nyi̱i̱ Balaa Kaisar tu yo̱o̱gi̱ tu Balaa Kaisar, pero bu nyi̱i̱ Yamba tu yo̱o̱gi̱ tu Yambai̱.>> ");
INSERT INTO wja_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Pu pma nu̱wa yi̱to̱ pma ri̱yanga bu̱ri̱. Di̱ngi̱n to̱no̱ pma mwatanga. ");
INSERT INTO wja_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","A dwii nyanggi̱ Sadukayo pma bu ce̱ ki̱n, wunonggu bo̱o̱ru̱ ya, pma baanga bo̱nggo̱ yo̱u̱ yi̱ pi̱ra. ");
INSERT INTO wja_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Pma ce̱ ki̱n, <<Ku̱lu̱me̱, Musa sa yiro ki̱n ka ne̱re̱ bo̱o̱ri̱ yaa kwaraa ne̱, tagi̱ ci̱ya yo̱ ba yiki wu̱tu̱ko̱lo̱ wii palaka ba bi̱man kwaraa ci̱ya yo̱. ");
INSERT INTO wja_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Bo̱o̱ yi̱ nu̱wa bu kangga nibiyo twii ci̱yamba bu̱ri̱ a cu̱du̱ yi̱ri̱. Wu gi̱ra pmo ni̱nga laabwiya a bwaa, yake̱ ku yaa kwaraa a du nu̱re̱ yo̱ ci̱ya yo̱. ");
INSERT INTO wja_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Yi̱to̱ mwaasi̱ a ni̱ngi̱ wa yi̱ wu ro̱p yi̱ kunong be̱ wu nibiyo ye̱i̱. ");
INSERT INTO wja_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Cwata go̱ro̱u̱ yo̱u̱, nu̱re̱ wii bwaa. ");
INSERT INTO wja_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Yo̱ko̱ sa yiro, yake̱ ku ni̱ng pma mwa mwa pmau nibiyo ko̱, a nyanggu̱ wunggu bo̱o̱re̱, yo̱o̱ we̱i̱ nu̱re̱ we̱?>> ");
INSERT INTO wja_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesu nyi̱i̱ le̱e̱ ki̱n, <<Bu li̱yanga di̱ngi̱n bu so̱m bu tu De̱mte̱e̱re̱ ci̱ye̱i̱, pero bu so̱m bu di̱mbi̱r Yamba. ");
INSERT INTO wja_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Nyanggu̱ wunonggi bo̱o̱re̱, nu̱wa na ni̱ngi̱ laabwiya, kana ba nyi̱i̱ laabwiya, pma yo̱o̱ we̱i̱ ci̱ka bacamandi a diyou Yambau̱. ");
INSERT INTO wja_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Anda dwii wunggu bo̱o̱re̱, bu ce̱ bu tu Yamba sambi̱ra ru? Yamba sambi̱ra ki̱n, ");
INSERT INTO wja_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","<Mi n Yamba wu Ibrahim, Yamba wu Icaku, Yamba wu Yakubu.> Yo̱ yaa yo̱o̱gi̱ Yamba wu nu̱wa bu bwaanggi̱ wa, yo̱ yo̱o̱gi̱ Yamba nu̱wa bu yi̱ pi̱i̱ma wa.>> ");
INSERT INTO wja_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Pu nu̱wa tum nu̱wa yi̱to̱ pma ri̱yanga bu̱ri̱ yi̱ yi̱ri̱ngi̱ tu ju̱ku̱ya. ");
INSERT INTO wja_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Pu Parisayo nu̱wa ki̱n Yesu diini Sadukayo si̱ndi̱ si̱ye̱i̱ to̱k, pma ku̱ranga bu̱ri̱. ");
INSERT INTO wja_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Wu wiino pmo wu so̱m te̱e̱ri̱ngi̱ wang, a cu̱u̱ yo yi̱ wuna pi̱ra. ");
INSERT INTO wja_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","<<Ku̱lu̱me̱, mi̱ri̱nggi̱ te̱e̱ri̱ngi̱ du gwala yi̱ gi̱ru̱ do̱no̱?>> ");
INSERT INTO wja_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesu nyi̱i̱ le̱e̱ ki̱n, <<Ma kangman Mbaa Wu Gi̱ra Yamba mo̱ yi̱ gaanggu̱ mo̱u̱ mwa mwa, yi̱ bawei mai mwa mwa yi̱ dangandi̱ mai mwa mwa. ");
INSERT INTO wja_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","To̱o̱ te̱e̱re̱ du gawu̱ri̱yo̱ yi̱ du gwala yi̱ gi̱ru̱. ");
INSERT INTO wja_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Du ro̱p ye̱i̱ ci̱ka do̱o̱ mwaasi̱, <Ma kangman bapun mo̱ ci̱ka bu̱ri̱ mai. ");
INSERT INTO wja_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Te̱e̱ri̱ngi̱ yi̱ yi̱ri̱ngi̱ tu banabi̱ndi̱ ju̱ku̱ri̱ mwa mwa daangi̱ laa te̱e̱ri̱ngi̱ tu ro̱p to̱o̱. ");
INSERT INTO wja_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Pu bo̱o̱ Parisayo bo̱o̱ ku̱ranggi̱ bu̱ru̱, Yesu pi̱ra pma ki̱n, ");
INSERT INTO wja_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","<<Bu dangani̱ ca dwii Masiya? Yo̱o̱gi̱ bo̱l we̱?>> Pma nyi̱i̱ le̱e̱ ki̱n, <<To̱o̱ bo̱l Dawud.>> ");
INSERT INTO wja_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","A sa pma ki̱n, <<Di̱ngi̱n ca ki̱, Dawud ce̱ ci̱ye̱i̱ yi̱ di̱mbi̱re̱ Bawei du Walwal, a yi̱gu̱ Masiya ki̱n Mbaa Wu Gi̱ra? Di̱ngi̱n a ce̱ ki̱n, ");
INSERT INTO wja_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","<<Mbaa Wu Gi̱ra sa Mbaa Wu Gi̱ra mi <Si̱n si̱ye̱i̱ wai mu wu je̱u̱ ko̱po̱ ka n diini bace̱mba ma ku̱u̱ mo̱u̱.>>> ");
INSERT INTO wja_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ka Dawud yi̱ Masiya ki̱n, Mbaa Wu Gi̱ra wai, <<A ni̱ngwa nye̱ ba yo̱o̱ bo̱l yo̱?>> ");
INSERT INTO wja_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Yaa wu pu̱n ci̱ye̱i̱, yake̱ kwii nyanggu̱ yaa wu pero ni̱nggu̱ ma yo̱ pi̱randi̱. ");
INSERT INTO wja_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Yesu sa nu̱wa tum yi̱ kwati̱mba ya ki̱n, ");
INSERT INTO wja_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","<<Ku̱lu̱mba te̱e̱ri̱ngi̱ wa yi̱ Parisayo bwii pma bu ju̱ku̱ri̱ pi̱ti̱ndi̱ te̱e̱ri̱ngi̱ Musa. ");
INSERT INTO wja_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Di̱ngi̱n to̱no̱ bu ni̱nga po̱ngo̱ndi̱ yi̱ kana ca tu sa mbi̱rai̱, bu ni̱ngi̱ ya tu pma ni̱nggi̱, di̱ngi̱n pma yaa po̱ngi̱ tu pma wasi̱gi̱. ");
INSERT INTO wja_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Pma de̱r se̱e̱ wu ko̱mbu̱ro̱m ba ce̱rman nu̱wa, anda pma yi̱ri̱ pmai yaa le̱e̱ mwanggu̱ yi̱ wai. ");
INSERT INTO wja_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Pma ni̱ngi̱ kana ca palaka nu̱wa ba ko̱. Pma bali̱ ci̱ye̱i̱ Yambai̱ ba cwaki̱ balayandi gembirendi yi̱ to̱no̱ ba bo̱ngna dwii, pero cwaki̱ nyandi gatanggamandi pmai co̱ku̱ro̱ndi̱. ");
INSERT INTO wja_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Pma kasi̱ pi̱si̱ndi̱ bagi̱rai̱ a jo̱r waandi, yi̱ pi̱si̱ndi̱ su kundi wang a gi̱ri̱ndi̱ ku̱ru̱. ");
INSERT INTO wja_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Pma kasi̱ nu̱wa ba ci̱ pma a lummondi pero nu̱wa ba yi̱ pma ki̱n ku̱lu̱mba. ");
INSERT INTO wja_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","<<Anda mba, bu le̱e̱ ya nu̱wa ba yi̱ mbi̱ra ki̱n, <Ku̱lu̱me̱,> di̱ngi̱n bu bo̱o̱ ku̱lu̱m wiino ti̱bak pero bu yo̱o̱gi̱ ci̱yamba bu̱ri̱. ");
INSERT INTO wja_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Pero bu yi̱rya kana we̱ a si̱ma mi̱n, <<Mbaa,> di̱ngi̱n bu bo̱o̱ yi̱ Mbaate̱ wiino ti̱bak a diyou. ");
INSERT INTO wja_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Kana mba, bu le̱e̱ ya nu̱wa ba yi̱ mbi̱ra ki̱n, <Ku̱lu̱me̱,> di̱ngi̱n bu wo̱o̱ yi̱ ku̱lu̱m wiino ti̱bak, wii Masiya. ");
INSERT INTO wja_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Wu gwala yi̱ gi̱ra cu̱du̱ mbi̱ri̱ ba yo̱ ke̱we̱. ");
INSERT INTO wja_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Di̱ngi̱n kana we̱ wu wun dwii ye̱i̱ nu̱wa cingo we̱i̱ anda kana we̱ wu cingo dwii ye̱i̱ nu̱wa nyi̱i̱ we̱i̱ gi̱ru̱. ");
INSERT INTO wja_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","<<Bu yo̱o̱gi̱ yi̱ri̱ bunam, mba ku̱lu̱mba te̱e̱ri̱ngi̱ wa yi̱ Parisayo, mba bu yi̱ batal wa! Bu laka nyinou lau̱ ku diyou a bo̱nggo̱ nu̱wau̱, mba yir mbi̱ri̱ do̱ng bu teembiri bu pero bu du pma bu teendu we̱i̱ wa ba teendo.  ");
INSERT INTO wja_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Bu yo̱o̱gi̱ yi̱ri̱ bunam, mba ku̱lu̱mba te̱e̱ri̱ngi̱ wa yi̱ Parisayo, mba bu yi̱ batal wa! Bu ni̱ngaman wu̱tu̱ko̱la lelu, ba yi̱ se̱e̱ wu laandi pmai, pero ce̱ ku̱ru̱ co̱ku̱ro̱k ci̱ka nu̱wa bu nyaa wa. Bo̱o̱ nu̱wa tii we̱i̱ ku̱u̱lu̱ wang. ");
INSERT INTO wja_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","<<Bu yo̱o̱gi̱ yi̱ri̱ bunam, mba ku̱lu̱mba te̱e̱ri̱ngi̱ wa yi̱ Parisayo mba bu batal wa, bu ke̱re̱ni̱ kana pi̱yau̱ a si̱ma yi̱ you ku piu palaka bu wuu ne̱re̱ wiino ba po̱ng mbi̱ra, pero ka baayi, bu di̱na ba yo̱ bo̱l bwalau gwala mbi̱ra daa ro̱p. ");
INSERT INTO wja_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","<<Bu yo̱o̱gi̱ yi̱ri̱ bunam, mba kerma bu taagu̱ nu̱wa wa! Bu ce̱ mi̱n, <Kana we̱ ka we̱re̱ni̱ yi̱ laa Yambau̱ to̱o̱ yi̱ri̱ tu kanggi̱ ne̱ anda ka kana we̱ we̱re̱ni̱ yi̱ sinariya wu laa Yambau̱, ti̱i̱ni̱ we̱ra yo̱.> ");
INSERT INTO wja_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mba bacinba kerma wa, tu gwala yi̱ gi̱ru̱ to̱no̱? Sinariya ru, laa Yambau̱ yo̱ wu diini sinariya ba ni̱nga walwal ru? ");
INSERT INTO wja_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Bambang bu ce̱ mi̱n, <Kana we̱ wu we̱re̱nga yi̱ kwaare̱ Yamba to̱o̱ yi̱ri̱ tu kanggi̱ ne̱, anda kana we̱ wu we̱re̱nga yi̱ ni̱i̱ du mi̱ri̱, ti̱i̱ni̱ we̱ra yo̱.> ");
INSERT INTO wja_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mba nu̱wa bu yo̱o̱gi̱ kerma, tu gwala yi̱ gi̱ru̱ to̱no̱? Ni̱i̱ ru, kwaare̱ du diini ni̱i̱ ba ni̱nga walwal ru? ");
INSERT INTO wja_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Di̱ngi̱n to̱no̱ kana we̱ wu we̱re̱nga yi̱ kwaare̱ we̱re̱nga yi̱ kana ca tu mi̱ri̱. ");
INSERT INTO wja_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Kana we̱ wu we̱re̱nga yi̱ laa Yambau̱ a we̱re̱nga yi̱ to̱no̱ yi̱ wu si̱i̱ mi̱ri̱. ");
INSERT INTO wja_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Kana we̱ wu we̱re̱nga yi̱ diyou Yambau̱ a we̱re̱nga yi̱ candu̱ Lau̱ Yambau̱ yi̱ wu si̱i̱ni̱ mi̱ri̱. ");
INSERT INTO wja_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","<<Bu yo̱o̱gi̱ yi̱ri̱ bunam, mba ku̱lu̱mba te̱e̱ri̱ngi̱ wa yi̱ Parisayo mba bu batal wa. Bu nyi̱i̱ tiino mi̱ri̱nggi̱ kwap wu se̱e̱ ali̱ mbi̱re̱, baabu, dauri, yi̱ waasa yi̱ bunggul, anda bu kwaa tu gwala yi̱ kundi yo̱u̱, bu tu̱mgu̱ ji̱re̱i̱ yi̱ bunam yi̱ ni̱nggu̱ yi̱ri̱ngi̱ ci̱maci̱ma. To̱o̱ tu daa ye̱i̱ na bu ni̱nga, bu du̱r ya tu co̱nggo̱i̱. ");
INSERT INTO wja_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Mba kerma bu taagu̱ nu̱wa wa, bu tosi gundu di̱ngi̱n bu yiki gu̱mpi̱ su ki̱ti̱ndi̱ anda bu mi̱i̱ nggela. ");
INSERT INTO wja_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","<<Bu yo̱o̱gi̱ yi̱ri̱ bunam, mba ku̱lu̱mba te̱e̱ri̱ngi̱ wa yi̱ Parisayo, mba bu batal wa. Bu cardi go̱ro̱ kaagu̱ yi̱ go̱ro̱u̱ panane̱ anda mi̱ri̱nggi̱ ye̱i̱ twangi yi̱ yawo yi̱ ni̱nggu̱ tu gaanggu̱ mo̱u̱ kasi̱. ");
INSERT INTO wja_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Kerma Parisayo wa! Bu car mi̱ri̱nggi̱ kaage̱ yi̱ panane̱ bati, palaka go̱ro̱ yo̱u̱ ba ni̱ngi̱ we̱i̱ walwal mwaasi̱. ");
INSERT INTO wja_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","<<Bu yo̱o̱gi̱ yi̱ri̱ bunam, mba ku̱lu̱mba te̱e̱ri̱ngi̱ wa yi̱ Parisayo mba bu batal wa! Bu ci̱ka purongi tu nu̱wa banni to̱ne̱ du po̱pu̱lo̱k, ko̱gu̱ yo̱u̱ kundi a twalange̱ anda mi̱ri̱nggi̱ ye̱i̱ twanggi yi̱ kuri nu̱wa bu bwaanga wa, pero kana ca yaa walwal. ");
INSERT INTO wja_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Bu yi̱to̱, a twalanga bu ci̱ka nu̱wa bu ni̱nggu̱ pi̱su̱ wu nyaau wa bo̱nggo̱ nu̱wau̱ anda mi̱ri̱nggi̱ mbi̱ri̱ twanggi yi̱ batal yi̱ tu̱we̱. ");
INSERT INTO wja_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","<<Bu yo̱o̱gi̱ yi̱ri̱ bunam, mba ku̱lu̱mba te̱e̱ri̱ngi̱ wa yi̱ Parisayo mba bu batal wa, bu mwe̱e̱n dwiiyongi puringi banabi̱ndi̱, pero bu ye̱ki̱ri̱ purongi nu̱wa bu nyaa wa. ");
INSERT INTO wja_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Pero bu ce̱ mi̱n, <Ka na yi bo̱o̱ jo̱r kwiimba yuwa we̱i̱, na yaa ku yi ne̱cu̱ we̱i̱ dwii yi̱ pma yi laca banabi̱ndi̱.> ");
INSERT INTO wja_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Yi̱to̱ mwa bu ju̱ku̱ya mi̱n bu yo̱o̱gi̱ kakaa pma bu laca banabi̱ndi̱ wa. ");
INSERT INTO wja_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Bu je̱e̱ gawu̱re̱ bu twanga wu̱rai̱ du kakaa mba toso. ");
INSERT INTO wja_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","<<Mba co̱o̱gi̱ndi̱, mba kwaraa bage̱ci̱ wa! Ni̱ndu̱ we̱i̱ nye̱ bu ce̱ mbi̱r bali̱ par bwalai? ");
INSERT INTO wja_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Di̱ngi̱n to̱no̱, n wo̱o̱ tum mbi̱r banabi̱ndi̱ yi̱ nu̱wa bu pwi̱yanggi̱ wa yi̱ ku̱lu̱mba. Bu jiru we̱i̱ bu kangga, bu pi̱i̱ni̱ bu kangga ye̱u̱, bu wacanu̱ we̱i̱ bu kangga a gi̱ri̱ndi̱ ku̱ru̱ pero bu ke̱ke̱nu̱ we̱i̱ pma gwe̱i̱ yi̱ gwe̱i̱. ");
INSERT INTO wja_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Nu̱wa ni̱nga mbi̱ru̱ we̱i̱ bali̱ dwii ti̱i̱ma nu̱wa bu ni̱ng pi̱su̱ wu nyaa a gawu̱ri̱ Yamba bu nu̱wa par si̱ye̱i̱ a si̱ma, toso dwii ti̱i̱ma Abila ne̱re̱ wu ni̱nga pi̱su̱ wu nyaau be̱e̱ bu Sakariya bo̱l Berekaya wu bu jiyo cu̱du̱ laa Yambau̱ yi̱ kwaare̱. ");
INSERT INTO wja_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","N wo̱o̱ sagu̱mbi̱ru̱ ji̱re̱ mwa mwa to̱o̱ yi̱ri̱ngi̱ julo we̱i̱ dwii nu̱wa bu si̱naa daandi wa. ");
INSERT INTO wja_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","<<Aing! Wurcalima! Mba bu laci banabi̱ndi̱ wa, pero bu bacanga nu̱wa bu Yamba tu̱mu̱we̱ bo̱nggo̱ mbi̱ru̱ wa! Daa so̱no̱ n kasi̱ n ku̱ra mbi̱ra ci̱ka ku̱ cwiyo ku̱ran kwaraa ya mi̱ri̱nggi̱ ko̱ngo̱ndi̱ ye̱i̱, anda bu kwaanga! ");
INSERT INTO wja_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Su̱wa, nu̱wa duu mbi̱ri̱ laa mbi̱ru̱ ko̱ni̱! ");
INSERT INTO wja_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","N wo̱o̱ sagu̱mbi̱ru̱, bu peri ko̱gu̱ mu̱, ko̱po̱ nyanggu̱ ku̱ bu ce̱ mi̱n, <Wuure, a bo̱nggo̱ yo̱, wu bagu̱ a mi̱ri̱nggi̱ din Mbaa Wu Gi̱ra!> >> ");
INSERT INTO wja_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu du laa Yambau̱, a mwatugu, kwati̱mba ya baanga bo̱nggo̱ yo̱u̱ pma ju̱ku̱gu̱ yo̱ mwe̱e̱ndi̱ twii. ");
INSERT INTO wja_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","A sa pma ki̱n, <<Bu ko̱gu̱ ti̱na yi̱ri̱ngi̱ mwa mwa, n sagu̱mbi̱ru̱ ji̱re̱ Yaa swe̱li̱ du nu̱wa duru we̱i̱ a dwii bago̱n yo̱, kana do̱no̱ nu̱wa kwiyanu we̱i̱.>> ");
INSERT INTO wja_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Pu bo̱o̱ Yesu wo̱o̱ pi̱su̱ dwii Ci̱ngu̱ Souri Setun, kwati̱mba ya baanga bo̱nggo̱ yo̱u̱ wu̱lak pma ce̱ ki̱n, <<Sayiro, to̱o̱ yi̱ri̱ ni̱ngdu̱ we̱i̱ pe̱ne̱ pero somdi bagu̱ mai ca, yi̱ daandi su cwata go̱ro̱i̱?>> ");
INSERT INTO wja_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesu nyi̱i̱ le̱e̱ ki̱n, <<Bu ruun tu̱we̱ kana we̱ ba ciye mbi̱ri̱ ya. ");
INSERT INTO wja_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Di̱ngi̱n nu̱wa tum baanga we̱i̱ yi̱ din mi, a ce̱gu̱ ki̱n, <N yo̱o̱gi̱ Masiya,> pero pma ciyonu we̱i̱ nu̱wa tum. ");
INSERT INTO wja_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ka bu nu̱u̱ ce̱wi̱ kwai wundu wundu, anda bu nu̱u̱ ya gwasi̱, tagi̱ to̱o̱ yi̱ri̱ngi̱ ba ni̱ngi̱ wa, anda bo̱o̱ nyanggu̱ ku cwata go̱ro̱u̱ baa bu. ");
INSERT INTO wja_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Si̱ma wunmanu we̱i̱ si̱ma, lau̱ wunmanu we̱i̱ lau̱. Ju̱ne̱ yari we̱i̱ pero si̱ma si̱ktu̱ we̱i̱ bu̱ri̱ pe̱ndi̱ wundu wundu. ");
INSERT INTO wja_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","To̱o̱ mwa mwa to̱o̱ toson taa ku̱u̱lu̱. ");
INSERT INTO wja_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","<<Nu̱wa diinu we̱i̱ nu̱wa ba pumbiri ku̱u̱le̱, pero ba lacambi̱ra, bambam nu̱wa bu si̱ma mwa mwa kwaambi̱ri̱ we̱i̱ di̱ngi̱n mi. ");
INSERT INTO wja_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","A dwii jo̱re̱ nu̱wa tum yaranu̱ we̱i̱ mi̱ri̱nggi̱ le̱e̱gu̱ ji̱re̱i̱, cuuru we̱i̱ bu̱ri̱ pmai pero kwaa we̱i̱ bu̱ri̱. ");
INSERT INTO wja_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Pero banabi̱ndi̱ leendi twiyongo we̱i̱ tum, pero ciyonu we̱i̱ nu̱wa tum. ");
INSERT INTO wja_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Tu̱we̱ cwatu we̱i̱ bu̱ri̱ di̱ngi̱n to̱no̱ kangam nu̱wa tum ni̱ngu̱ we̱i̱ yu̱tu̱tu̱. ");
INSERT INTO wja_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Anda kana we̱ wu bo̱o̱ gaanggu̱ lam nyanggu̱ ku pungu nyi̱i̱nggu̱ we̱i̱ mi̱rma. ");
INSERT INTO wja_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Anda ko̱po̱ ka nu̱wa wasi̱r ci̱ye̱i̱ du teng du lau̱ Yambau̱ kana pi̱yau̱ a si̱ma mwa mwa di̱ngi̱n nu̱wa mwa mwa ba nu̱wa, anda nyanggu̱ cwata go̱ro̱ baa. ");
INSERT INTO wja_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","<<Ka bu kwe̱yi̱ yi̱ri̱ngi̱ pu̱si̱ twii tu de̱e̱ se̱ntanggi̱, pi̱ti̱ndi̱ pu walwal a Laa Yambau̱ ci̱ka tu banabi̱ Daniel bala ki̱n, yama kana we̱ wu ce̱gu̱ di̱naa ci̱ye̱i̱ ba ku̱ranga to̱o̱. ");
INSERT INTO wja_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","A dwii jo̱re̱, yama pma bu mi̱ri̱nggi̱ Yudaya wa ba ceendo cingiri. ");
INSERT INTO wja_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Kana we̱ wu dwii kani ba julo ya di̱ngi̱n ba de̱e̱ kana ca a lai̱. ");
INSERT INTO wja_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Kana we̱ wu wo̱o̱ ko̱ndo̱u̱ ba waata ya lai̱ de̱gu̱ gatangamau. ");
INSERT INTO wja_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","A kwii nyanggu̱, nu̱ru̱mba bu yi̱ rwiiyengi wa yi̱ bu pu̱u̱gu̱ nyi̱i̱ kwaraa wa, ni̱ngamanu̱ we̱i̱ pma yi̱ buu. ");
INSERT INTO wja_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Bu ce̱ ku̱ru̱ cuu mbi̱ru̱ ba yo̱o̱ ya yi̱ jundu kana nyanggu̱ Sabadu. ");
INSERT INTO wja_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Di̱ngi̱n a dwii jo̱re̱ nu̱wa ti̱i̱ we̱i̱ ku̱u̱lu̱ wang, wu bo̱o̱ nu̱wa ti̱i̱ bu ti̱i̱gu̱ yake̱ toson taa si̱mau̱ ko̱po̱ yo̱ko̱, pero yaa ku perdu we̱i̱. ");
INSERT INTO wja_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ka na nu̱wa gwandi̱la bu daandi swii ne̱ yaa wu yi̱lu̱ we̱i̱, anda di̱ngi̱n pma bu Yamba se̱ka wa, nu̱wa gwandi̱la daandi swii. ");
INSERT INTO wja_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","A dwii jo̱re̱ kana we̱ ka ce̱e̱ ki̱n, <Ko̱, Masiya yo̱ wuna!> kana ce̱ ki̱n, <Yo̱ wii!> bu le̱e̱ ya ji̱re̱ yi̱ to̱no̱. ");
INSERT INTO wja_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Di̱ngi̱n Masiya wu leendi yi̱ banabi̱ndi̱ leendi twiyongo we̱i̱, pero ni̱nggu̱ we̱i̱ yi̱ri̱ngi̱ ri̱yandi̱ bu̱ri̱ ba we̱le̱nga kana bu nu̱wa Yamba se̱ka pma wa, ka pma puu we̱i̱ wai. ");
INSERT INTO wja_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Bu su̱wa, n sambi̱ra ki̱lang, bo̱o̱ jo̱r ni̱nga bu. ");
INSERT INTO wja_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","<<Di̱ngi̱n to̱no̱ kana we̱ wu sambi̱ra ki̱n, <Yo̱ wii a gu̱lai̱,> bu twiyoni ya, kana ce̱ ki̱n, <Yo̱ wuna mi̱ri̱nggi̱ kani̱,> bu le̱e̱ ya ji̱re̱ yi̱ to̱no̱. ");
INSERT INTO wja_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Di̱ngi̱n ci̱ka ku nyi̱l gundu nyi̱ldi̱ do̱no̱me̱ nu̱wa kwe̱i̱ nyambi̱ranggu̱, yi̱to̱ yi̱ bagu̱ Bo̱l Ne̱re̱. ");
INSERT INTO wja_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Pu ko̱mdi̱ so̱o̱ mi̱ru̱, baperi ku̱rani̱ bu̱ri̱ pwii. ");
INSERT INTO wja_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","<<Go̱ro̱ ku̱u̱li̱ wu daandi swii, a ki̱nangu̱, <Nyanggu̱ yo̱ we̱i̱ ku̱mji̱la, pero pwalau na swiiri bu̱ri̱, bajwari yaranga we̱i̱ diyou, pero yi̱ri̱ngi̱ tu diyou si̱ktu̱ we̱i̱ bu̱ri̱.> ");
INSERT INTO wja_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","<<A dwii jo̱re̱ somdi Bo̱l Ne̱re̱ twii we̱i̱ a diyou, pero mwa mwa duuri tu si̱ma bwi̱yanu̱ we̱i̱ gaanggu̱, ka pma kwe̱e̱ we̱i̱ Bo̱l Ne̱re̱ bagu̱ mi̱ri̱nggu̱ tinendi a diyou yi̱ di̱mbi̱re̱ yi̱ yi̱lau̱ wang. ");
INSERT INTO wja_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Yo̱ diinu we̱i̱ nu̱wa ba wuu jume yi̱ mi̱u̱ ba tu̱mmu̱ we̱i̱ bacamandi ye̱i̱, kana pi̱yau̱ ba ku̱ranga bu yo̱ se̱ka wa a mi̱ri̱nggi̱ ke̱ngandi̱ ni̱i̱ su si̱mai̱. ");
INSERT INTO wja_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","<<Yo̱ko̱ n kasi̱ bu ti̱langa to̱o̱ yi̱ri̱ bo̱nggo̱ sou pwalgu̱. Ka bu kwe̱e̱ tosi bulugu, wandi̱ ye̱i̱ to̱ri̱ bu so̱ma mi̱n jundu ni̱nga ne̱m. ");
INSERT INTO wja_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Yi̱to̱ mwaasi̱, ka bu kwe̱e̱ to̱o̱ yi̱ri̱ngi̱ mwa mwa, bu so̱ma mi̱n a ni̱nga ne̱m, wo̱o̱ nyinou. ");
INSERT INTO wja_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","N wo̱o̱ sagu̱mbi̱ru̱ ji̱re̱ nu̱wa bu si̱na daandi wa pma na bwaani̱ ko̱po̱ ka yi̱ri̱ngi̱ to̱o̱ mwa mwa ni̱ngdi̱ bu̱ri̱. ");
INSERT INTO wja_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Diyou yi̱ si̱ma wo̱ru̱ we̱i̱ anda ci̱ye̱i̱ mi yaa ku̱ wo̱ru̱ we̱i̱ kana banyi̱na. ");
INSERT INTO wja_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","<<Yaa wu so̱m nyanggu̱ kwii kana jo̱r ye̱i̱, kana bacamandi su diyou, kana Bwi̱ya, bu̱ri̱ Mbaate̱. ");
INSERT INTO wja_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ci̱ka ku ni̱ngi̱ wa a daandi Nuhu, yi̱to̱ mwaasi̱ ni̱ndu̱ we̱i̱ a jo̱r bagu̱ Bo̱l Ne̱re̱. ");
INSERT INTO wja_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ci̱ka ku ni̱ngi̱ wa kami̱n daandi su jame̱ de̱e̱, nu̱wa je̱gu̱ yi̱ naagu, nu̱wa ni̱nggu̱ laabwiya yi̱ nyi̱i̱gu̱ laabwiya ko̱po̱ nyanggu̱ ku Nuhu diiro konggoru. ");
INSERT INTO wja_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Yaa ku pma so̱m tu ni̱ndu̱ we̱i̱, ko̱po̱ ku jame̱ baa de̱e̱ pma. Yo̱o̱ we̱i̱ yi̱to̱ a jo̱r du Bo̱l Ne̱re̱ baa we̱i̱. ");
INSERT INTO wja_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Nu̱wa ki̱nggu̱ we̱i̱ nu̱wa ro̱p ko̱ndo̱u̱ nu̱wa de̱ru̱ we̱i̱ wiino, ba du wu wiino. ");
INSERT INTO wja_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Nu̱wa nyi̱nggu̱ we̱i̱ nu̱ru̱mba ro̱p ko̱gu̱ yi̱ri̱ ni̱i̱ nu̱wa de̱ru̱ we̱i̱ wiino ba du wu wiino. ");
INSERT INTO wja_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","<<Di̱ngi̱n to̱no̱, bu ni̱nga pu swe̱ri̱gu̱ di̱ngi̱n bu so̱m bu nyanggu̱ ku Mbaa Wu Gi̱ra mbi̱ri̱ baa we̱i̱. ");
INSERT INTO wja_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Anda n kasi̱ bu ku̱ranga mi̱n, ka ne̱re̱ wu laa wayau̱, na so̱m jo̱r du kuwe baa we̱i̱ yi̱ ku̱me̱ na swe̱ru̱ we̱i̱, yaa ku duru we̱i̱ kuwe ba diiwe laa yo̱u̱. ");
INSERT INTO wja_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Di̱ngi̱n to̱no̱ bu si̱ya ci̱pi̱gi̱ bu̱ri̱, di̱ngi̱n Bo̱l Ne̱re̱ baa we̱i̱ a jo̱r du bu yaa te̱mandi̱. ");
INSERT INTO wja_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","<<Wii ke̱we̱ yo̱ we̱ wu yi̱ ji̱re̱ yi̱ pwi̱i̱, wu ne̱re̱ wu gi̱ra yo̱ diin yo̱ ba su̱wa ke̱waa bu laa yo̱u̱ wa, ba nyi̱i̱ pma je̱e̱ndi̱ pmai ci̱maci̱ma a jo̱r du daa ye̱i̱? ");
INSERT INTO wja_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Wuure bo̱nggo̱ wo̱o̱ ne̱re̱, wu ne̱re̱ wu gi̱ra yo̱ ka waatai ba ki̱nggi̱ we̱i̱ a ni̱nggu̱ wu̱rai̱ ye̱i̱ ci̱maci̱ma. ");
INSERT INTO wja_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","N wo̱o̱ sagu̱mbi̱ru̱ ji̱re̱, yo̱ cernu we̱i̱ ne̱re̱ wii a dwii gi̱na yo̱ mwa mwa. ");
INSERT INTO wja_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ka ci̱ka ke̱we̱ wii yi̱ tu̱we̱ we̱i̱ pero sar bu̱ri̱ ye̱i̱ ki̱n, <Ne̱re̱ wu gi̱ra mi daawe̱ tum,> ");
INSERT INTO wja_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","pero tosi buwanggu kapi̱ma ke̱waa, pero yo̱ wun je̱gu̱ a naagu kem yi̱ ba naamba nyi̱nma. ");
INSERT INTO wja_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ne̱re̱ wu gi̱ra ke̱we̱ wii waata we̱i̱ a jo̱r du ne̱re̱ wii te̱man bu, pero a jo̱r du yo̱ so̱m bu, ");
INSERT INTO wja_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","baa pu̱u̱ we̱i̱ ku̱u̱le̱ wang, ba ne̱ca yo̱ yi̱ nu̱wa bu yi̱ batal wa, pu ji we̱i̱ wiindi yi̱ dumonggu nyi̱yau̱. ");
INSERT INTO wja_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","<<A dwii jo̱re̱, lau̱ diyou ni̱ngi̱ we̱i̱ ci̱ka bako̱rcanga kwap bu de̱e̱ pi̱ti̱lari̱ pmai aanda di̱ngi̱n ba te̱re̱nga bwiyakaa wu laabwiya wa yo̱. ");
INSERT INTO wja_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Bu nuwo wa twii bacinba anda bu nuwo wa pwi̱yanggi̱. ");
INSERT INTO wja_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Bacinba bwii de̱e̱ pi̱ti̱lari̱ pmai yaa nunggu. ");
INSERT INTO wja_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Bu pwi̱yanggi̱ bwii pma de̱e̱ nunggu a pi̱ti̱lari̱ pmai yi̱ cwe̱i̱ndi̱ pmai. ");
INSERT INTO wja_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Bwiyakaa wii si̱i̱we̱ yaa ku baa ki̱lang, mwa mwa pmau toso jusonggu dimau. ");
INSERT INTO wja_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","<<Yi̱ cu̱du̱ kumdi, nu̱wa nu̱u̱ duwai ki̱n, <Bwiyakaa laabwiya yo̱ wuna bu twiyongo bu de̱ rau.> ");
INSERT INTO wja_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","<<Bu̱ri̱ bako̱rcanga bwii wunongo, a me̱ne̱nga pi̱ti̱lari̱ pmai. ");
INSERT INTO wja_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Bacinba bwii sa bu pwi̱yanggi̱ bwii ki̱n, <Bu pu yir nunggu mbi̱ru̱ pi̱ti̱lari̱ yiri a bwanggu.> ");
INSERT INTO wja_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","<<Pma nyi̱i̱ le̱e̱ ki̱n, <Ang ang yaa ku yiri yiri we̱i̱ kem yi̱ mbaa, kujang bu ambi̱ra bu te̱nmanu̱we̱ bu̱ri̱ mbi̱ri̱ bo̱nggo̱ nu̱wa bu cuugu wa.> ");
INSERT INTO wja_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","<<Anda pu pma mwatanga te̱nggu̱ nunggu, bwiyakaa laabwiya lamuwe. Bako̱rcanga bu ci̱pi̱gi̱ bu̱ri̱ wa bwii de̱ rau kem yi̱ yo̱ a waandi laabwiya. Pero nu̱wa laka nyinou. ");
INSERT INTO wja_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Go̱ro̱u̱ yo̱u̱, bu kangga bwii baanga, pma ce̱ ki̱n, <Ne̱re̱ wu gi̱ra, Ne̱re̱ wu gi̱ra, wun yiri nyinou!> ");
INSERT INTO wja_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","<<A nyi̱i̱ le̱e̱ ki̱n, <N wo̱o̱ sagu̱mbi̱ru̱ ji̱re̱ n so̱mmbi̱ru̱ bu.> ");
INSERT INTO wja_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","<<Di̱ngi̱n to̱no̱ bu ci̱pa bu̱ri̱, di̱ngi̱n bu so̱m bu nyanggi̱ ye̱i̱ kana jo̱r ye̱i̱. ");
INSERT INTO wja_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","<<Bambang, ci̱ka ne̱re̱ wu kangge̱ wu ni̱nggu̱ so̱ngmau̱, a yi̱we̱ ke̱waa ya nyi̱i̱ pma gi̱na yo̱ ba su̱wa yi̱ to̱no̱. ");
INSERT INTO wja_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Wu wiino a nyi̱i̱ ke̱n tale̱nti̱ nuwo, wu kangge̱ tale̱nti̱ ro̱p, pero wu kangge̱ tale̱nti̱ wiino, kana wo̱no̱ cu̱u̱nggi̱ di̱mbi̱r yo̱, a ni̱nga so̱ngma ya. ");
INSERT INTO wja_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ne̱re̱ wu nu̱wa nyi̱i̱ tale̱nti̱ nuwo, a mwati̱ yo̱ko̱ yo̱ko̱ a ni̱nga duu yi̱ to̱no̱ a nyi̱ngga cwata tale̱nti̱ nuwo wu kangge̱. ");
INSERT INTO wja_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Yi̱to̱ mwaasi̱, wu nu̱wa nyi̱i̱ tale̱nti̱ ro̱p a nyi̱ngga cwata tale̱nti̱ ro̱p wu kangge̱. ");
INSERT INTO wja_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Anda wu nu̱wa nyi̱i̱ tale̱nti̱ wiino wii a mwati̱ wul bo̱u̱ a si̱ma ting ke̱n ne̱re̱ wu gi̱ra yo̱. ");
INSERT INTO wja_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","<<Go̱ro̱ daandi tum ne̱re̱ wu gi̱ra ke̱waa bwii waata bu̱ri̱ so̱ngma ya a kasa ba su̱wa gi̱na yo̱ wu bo̱nggo̱ ke̱waa ya. ");
INSERT INTO wja_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ne̱re̱ wu nu̱wa nyi̱i̱ tale̱nti̱ nuwo a de̱e̱ tale̱nti̱ wu kangge̱ a nuwo a ce̱ ki̱n, <Ne̱re̱ wu gi̱ra, ma nyi̱i̱ngge̱ tale̱nti̱ nuwo ko̱, n nyi̱ngga cwata wu kangge̱ nuwo.> ");
INSERT INTO wja_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","<<Ne̱re̱ wu gi̱ra yo̱ se̱e̱ ki̱n, <Wusa, ma yo̱o̱gi̱ ke̱we̱ wu nyaa wu yi̱ ji̱re̱i̱! Ma ni̱nga ji̱re̱i̱ dwii yi̱ri̱ngi̱ banyi̱na, n diiminu we̱i̱ su̱gu̱ yi̱ri̱ngi̱ tu tum. Bame̱ ma ni̱nga bu̱ri̱ de̱gde̱g kem yi̱ ne̱re̱ wu gi̱ra mo̱!> ");
INSERT INTO wja_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","<<Ne̱re̱ wu tale̱nti̱ ro̱p wii mwaasi̱ a baa a ce̱ ki̱n, <Ne̱re̱ wu gi̱ra ma nyi̱i̱ngge̱ tale̱nti̱ ro̱p n nyi̱ngga cwata tale̱nti̱ ro̱p.> ");
INSERT INTO wja_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","<<Ne̱re̱ wu gi̱ra yo̱ nyi̱i̱ le̱e̱ ki̱n, <Wusa, ma yo̱o̱gi̱ ke̱we̱ wu nyaa wu yi̱ ji̱re̱i̱! Ma ni̱nga ji̱re̱i̱ dwii yi̱ri̱ngi̱ banyi̱na, n diiminu we̱i̱ su̱gu̱ yi̱ri̱ngi̱ tu tum. Bame̱ ma ni̱nga bu̱ri̱ de̱gde̱g kem yi̱ ne̱re̱ wu gi̱ra mo̱!> ");
INSERT INTO wja_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","<<Bur ne̱re̱ wu yi̱ tale̱nti̱ wiino wii baa, a ce̱ ki̱n, <Ne̱re̱ wu gi̱ra n so̱ma ma yo̱o̱gi̱ du̱u̱ ne̱re̱ ku̱ ni̱ngandi̱ ye̱i̱ yi̱ bu̱u̱, ma kaci pu ma pi̱ bu, pero ma ku̱rani̱ pu ma wasi̱ bu go̱ma.> ");
INSERT INTO wja_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Di̱ngi̱n to̱no̱ n nu̱u̱ gwasi̱, n mwati̱ngge̱, n tuko tale̱nti̱ mo̱ mi̱ri̱nggi̱ si̱ma. Ko̱! Yi̱ri̱ mai yo̱ ti̱na.> ");
INSERT INTO wja_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","<<Ne̱re̱ wu gi̱ra yo̱ nyi̱i̱ le̱e̱ ki̱n, <Mo̱, ke̱we̱ wu yi̱ tu̱we̱ yi̱ ku̱u̱le̱! Ma so̱ma mi̱n n kaci pu n pi̱ bu pero n ku̱rani̱ pu n wasi̱ bu go̱ma? ");
INSERT INTO wja_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Na ni̱nga kundi, na ma ruu ke̱n mi a betal ke̱ne̱, palaka ka n waata bu̱ri̱ n nyi̱ngga a cwata bu̱ri̱. ");
INSERT INTO wja_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Bu yi̱ tale̱nti̱ wo̱o̱ bo̱nggo̱ yo̱u̱ bu nyi̱i̱ wu yi̱ tale̱nti̱ kwap. ");
INSERT INTO wja_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Di̱ngi̱n kana we̱ wu wo̱o̱ yi̱ to̱no̱ nu̱wa cwatamanu we̱i̱ yo̱, ba ni̱nga tum. Kana we̱ wu yaa to̱no̱ kana tu yi̱ to̱no̱i̱ nu̱wa yi̱yamanu̱ we̱i̱ yo̱. ");
INSERT INTO wja_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Bu manni̱ wo̱o̱ ke̱we̱ wu bwi̱i̱ wo̱o̱ twalange̱, mi̱ri̱nggi̱ ku̱me̱, pu ni̱ngu̱ we̱i̱ pu windi yi̱ dumonggu nyi̱yau̱.> ");
INSERT INTO wja_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","<<A jo̱r du Bo̱l Ne̱re̱ baa we̱i̱ yi̱ yi̱lau̱ yo̱u̱, kem yi̱ bacamandi ye̱i̱ mwa mwa, yo̱ si̱nu̱ we̱i̱ candu̱ lau̱ yo̱u̱ wu yi̱ yi̱lau̱. ");
INSERT INTO wja_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Nu̱wa bu si̱ma mwa mwa ku̱ranu̱ we̱i̱ bu̱ri̱ gawu̱ri̱ ye̱i̱, yo̱ ke̱nu̱ we̱i̱ nu̱wa wundu wundu, ci̱ka ku taage̱ kari̱ puuri bo̱nggo̱ kwamali. ");
INSERT INTO wja_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Yo̱ ruu we̱i̱ puuri a wai yo̱u̱ wu je̱u̱, kwamali a wai yo̱u̱ wu miu. ");
INSERT INTO wja_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","<<A dwii jo̱re̱ Balaa wii sar we̱i̱ pma bu wai yo̱u̱ wu je̱u̱ ki̱n, <Bambe̱, mba bu yi̱ wuuri wa bo̱nggo̱ Mbaa mi, bu je̱ lau̱ ku nu̱wa ruwo di̱ngi̱n mba yake̱ taawu̱ si̱ma. ");
INSERT INTO wja_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Di̱ngi̱n n nu̱u̱ ju̱ne̱ bu nyi̱i̱nggi̱ je̱e̱ndi̱, n nu̱u̱ jii bu pu̱nggu̱ gundu, n yo̱o̱ ru̱ngge̱ bu julunggi bu, ");
INSERT INTO wja_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","n yaa se̱e̱ bu pari̱ngi̱n se̱e̱, n yaa cingcing bu su̱wangge̱, n wo̱o̱ jaru̱m bu kacanggu̱we̱.> ");
INSERT INTO wja_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","<<Nu̱wa bu ni̱ng pi̱su̱ wu nyaa wa bwii le̱e̱ we̱i̱ ki̱n, <Mbaa Wu Gi̱ra, yi ko̱ mi̱na pe̱ne̱ yi̱ ju̱ne̱ yi̱ je̱e̱ mi̱na, yi̱ jii yi pu̱u̱ mi̱n gundu ma naa? ");
INSERT INTO wja_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Yi ko̱ mi̱na pe̱ne̱ ma ru̱ngge̱, yi yi̱ mi̱na, pero ma yaa se̱e̱, yi pari̱ mi̱n se̱e̱? ");
INSERT INTO wja_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Yi ko̱ mi̱na pe̱ne̱ yaa cingcing kana a jaru̱m yi kaca mi̱na?> ");
INSERT INTO wja_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","<<Balaa wii nyi̱i̱ we̱i̱ le̱e̱ ki̱n, <N wo̱o̱ sagu̱mbi̱ru̱ ji̱re̱, kana ca tu bu ni̱ngaman wu wiino wu banyi̱na a cu̱du̱ ci̱yamba muwa bi̱na, bu ni̱ngangi̱na.> ");
INSERT INTO wja_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","<<Pero sa ru we̱i̱ pma bu wai yo̱u̱ wu miu ki̱n, <Bu lamanga po̱o̱ bo̱nggo̱ mu, mba bu se̱ntanggi̱ wa, bu tembiro bwalau ku yaa dumdu, ku nu̱wa me̱ne̱nga di̱ngi̱n balaa buwai wa kem yi̱ bacamandi ye̱i̱. ");
INSERT INTO wja_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Di̱ngi̱n n nu̱u̱ ju̱ne̱ yaa ku bu nyi̱i̱nggi̱ je̱e̱ndi̱, n nu̱u̱ jii yaa ku bu pu̱nggu̱ gundu. ");
INSERT INTO wja_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","N ru̱ngge̱ yaa ku bu julungge, n yaa se̱e̱ yaa ku bu pari̱ngi̱n se̱e̱, n yaa cingcing pero n wo̱o̱ jaru̱m yaa ku bu su̱wangge̱.> ");
INSERT INTO wja_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","<<Pma mwaasi̱ nyi̱i̱ we̱i̱ le̱e̱ ki̱n, <Mbaa Wu Gi̱ra, yi ko̱ mi̱na pe̱ne̱ yi̱ ju̱ne̱, yi̱ jii, ma ru̱ngge̱, ma yaa se̱e̱, ma yaa cingcing pero ma jaru̱m anda yi kala mi̱n bu?> ");
INSERT INTO wja_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","<<Yo̱ nyi̱i̱ we̱i̱ le̱e̱ ki̱n, <N wo̱o̱ sagu̱mbi̱ru̱ ji̱re̱, kana ca tu bu ni̱ngaman bu wu wiino wu banyi̱na a cu̱du̱ pmai, bu ni̱ngangi̱n bu.> ");
INSERT INTO wja_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","<<Nu̱wa bwii teendu we̱i̱ ku̱u̱le̱ wu yaa mati̱gu̱ anda nu̱wa bu ni̱ng pi̱su̱ wu nyaau a gawu̱ri̱ Yamba wa, aandi we̱i̱ pu yi̱ pi̱i̱ma bu yaa mati̱gu̱ wa.>> ");
INSERT INTO wja_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Pu Yesu mata ce̱gu̱ to̱o̱ yi̱ri̱ngi̱ mwa mwa, a sa kwati̱mba ya ki̱n, ");
INSERT INTO wja_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","<<Bu so̱ma mi̱n Waandi Yerigu a du daa ro̱p, nu̱wa nyi̱i̱ we̱i̱ Bo̱l Ne̱re̱ nu̱wa ba pi̱i̱na ye̱u̱.>> ");
INSERT INTO wja_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","A dwii jo̱re̱ bagi̱raa kuruwa yi̱ bagi̱raa nu̱wa wa, pma ku̱ranga bu̱ri̱ caame̱ bagi̱ra kuruwa, wu dini ye̱i̱ Kayapa, ");
INSERT INTO wja_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","pma ci̱pa bu̱ri̱ di̱ngi̱n ba taa Yesu tukugi ba ji yo̱. ");
INSERT INTO wja_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Anda pma ce̱ ki̱n, <<Yaa jo̱r Waandi Yerigi, daakal nu̱wa ba wun kwai.>> ");
INSERT INTO wja_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Pu Yesu wo̱o̱ Betani a mi̱ri̱nggi̱ laa Simon wu wo̱o̱ yi̱ butangi nang, ");
INSERT INTO wja_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","nu̱re̱ wu kangge̱ baa yi̱ kukulo wu yi̱ nunggu ku yi̱ pi̱rcu̱ wang ku run teng, a parman yo̱ dwii pu wo̱o̱ je̱gu̱ je̱e̱ndi̱. ");
INSERT INTO wja_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Pu kwati̱mba ya ko̱ to̱o̱ yi̱to̱, pma bwiyanga gaanggu̱, pma ce̱ ki̱n, <<Wo̱o̱ kwala yo̱ ca? ");
INSERT INTO wja_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Nunggu ko̱o̱ nu̱wa na cuu yo̱ yi̱ ke̱n tum ba nyi̱i̱ baku̱u̱lu̱wa.>> ");
INSERT INTO wja_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesu so̱m tu pma ce̱gu̱, a sa pma ki̱n, <<Di̱ngi̱n ca bu do̱ma yi̱ nu̱re̱ wo̱o̱ a dwii yi̱ri̱ tu nyaayi tu ni̱ngangi̱nai̱? ");
INSERT INTO wja_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Bu bo̱o̱ yi̱ baku̱u̱lu̱wa kem yi̱ mba kana pe̱ne̱, anda yaa ku n si̱i̱ we̱i̱ kem yi̱ mba kana pe̱ne̱. ");
INSERT INTO wja_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Pari̱nggu̱ nunggu ku run teng ku pari̱ngi̱na bu̱ri̱ ko̱o̱, a ci̱pi̱gu̱ mu bo̱nggo̱ bo̱o̱re̱. ");
INSERT INTO wja_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","N wo̱o̱ sagu̱mbi̱ru̱ ji̱re̱, kana pi̱yau̱ pu nu̱wa wasi̱ru̱ we̱i̱ ci̱ye̱i̱ du teng di̱na a si̱ma mwa mwa, nu̱wa ce̱ we̱i̱ tu ni̱ngai̱ di̱ngi̱n danggi̱gu̱ yi̱ yo̱.>> ");
INSERT INTO wja_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","A dwii jo̱re̱ wu wiino cu̱du̱ bu kwati̱mba ya bu kwap su̱r ro̱p bwii, wu dini ye̱i̱ Yahuda Iskariyoti a aara bo̱nggo̱ bagi̱raa kuruwa wa, ");
INSERT INTO wja_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","a sa pma ki̱n, <<Tu bu nyi̱i̱nggu̱ we̱i̱ ca ka n di̱n yo̱ war mbi̱ri̱?>> Pma ce̱ ke̱n asurpa kuna kunong nyi̱i̱ yo̱. ");
INSERT INTO wja_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Yake̱ do̱o̱ jo̱re̱, Yahuda kasa nyindi su yo̱ cuuru we̱i̱ yo̱. ");
INSERT INTO wja_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","A nyanggu̱ ku gawu̱ri̱yo̱ a Waandi Burodi wu yaa Yisti, kwati̱mba Yesu wa baanga pi̱ra ki̱n, <<Ma kasi̱ yi me̱ne̱nga je̱e̱ndi̱ Waandi Yerigi pi̱yau̱ di̱ngi̱n mo̱?>> ");
INSERT INTO wja_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","A nyi̱i̱ le̱e̱ ki̱n, <<Bu ambi̱ra gwe̱i̱ bo̱nggo̱ ne̱re̱ wu kangge̱ bu se̱e̱ mi̱n, <Ku̱lu̱m ce̱ ki̱n: Jo̱r mi ni̱nga ne̱m. N je̱ we̱i̱ Waandi Yerigi kem yi̱ kwati̱mba mu wa a laa mau.>> ");
INSERT INTO wja_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Kwati̱mba ya bwii ni̱nga ci̱ka ku Yesu sa pma ba ni̱nga, pma me̱ne̱nga Waandi Yerigi. ");
INSERT INTO wja_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Pu nyambi̱ranggu̱ ni̱nga, Yesu si̱ si̱yau̱ aari̱ je̱gu̱ je̱e̱ndi̱ kem yi̱ kwati̱mba ya kwap su̱r ro̱p. ");
INSERT INTO wja_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Pu pma bo̱o̱ je̱gu̱ je̱e̱ndi̱, a ce̱ ki̱n, <<N wo̱o̱ sagu̱mbi̱ru̱ ji̱re̱, wu wiino cu̱du̱ mbi̱ri̱ cuunggu we̱i̱.>> ");
INSERT INTO wja_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Pma bwiyanga gaanggu̱, pma toso sagu̱ yo̱ wiino, wiino ki̱n, <<Mbaa Wu Gi̱ra, wii mi ne̱?>> ");
INSERT INTO wja_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesu nyi̱i̱ le̱e̱ ki̱n, <<Wu diini wai yo̱u̱ mi̱ri̱nggi̱ panane̱ kem yi̱ mi cuunggu we̱i̱. ");
INSERT INTO wja_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Bo̱l Ne̱re̱ bwaaru̱ we̱i̱ ci̱ka ku balgi̱ a dwii ye̱i̱, anda to̱o̱ yi̱ri̱ bunam bo̱nggo̱ ne̱re̱ wu cuu Bo̱l Ne̱re̱, kujang ku nu̱wa na bi bu yo̱.>> ");
INSERT INTO wja_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yahuda wu yo̱ cuuru we̱i̱ yo̱ a ce̱ ki̱n, <<Ku̱lu̱me̱, wii mi ru?>> Yesu nyi̱i̱ le̱e̱ ki̱n, <<O̱ng ma ce̱.>> ");
INSERT INTO wja_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Pu pma bo̱o̱ je̱gu̱ je̱e̱ndi̱, Yesu de̱e̱ ku̱maa, a wananga Yamba, a ge̱le̱nga, a nyi̱i̱ kwati̱mba ya, a ce̱ ki̱n, <<Bu yi̱ya bu je̱e̱, to̱o̱ bu̱ri̱ mi.>> ");
INSERT INTO wja_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Pero a de̱e̱ bo̱so̱ro̱ gundu inabi, a wananga Yamba, a nyi̱i̱ pma, a ce̱ ki̱n, <<Mwa mwa bu naa mi̱ri̱. ");
INSERT INTO wja_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","To̱o̱ ti̱i̱ma muwa, bu twanga tu Yamba kwe̱e̱ yi̱ nu̱wa ya, bu pardu̱ we̱i̱ si̱ye̱i̱ bu̱ri̱ di̱ngi̱n pargu̱ sukom we̱le̱mdi̱ nu̱wa tum. ");
INSERT INTO wja_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","N wo̱o̱ sagu̱mbi̱ru̱, yaa ku n peru we̱i̱ naagu gundu inabi ko̱po̱ kwii nyanggu̱ ku n naa we̱i̱ ku pu̱cu̱ kem yi̱ mba a Lau̱ Mbaa mu.>> ");
INSERT INTO wja_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Go̱ro̱ pu pma pi̱i̱ pi̱i̱ pma mwatanga Ci̱ngu̱ Souri Setun. ");
INSERT INTO wja_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Go̱ro̱ yi̱to̱ Yesu sa pma ki̱n, <<Yi̱ kum wunaa mwa mwa mbi̱ru̱ bu nyi̱nggu̱ we̱i̱ go̱ro̱u̱, di̱ngi̱n balgi̱ mi̱ri̱nggi̱ lakargar Yamba ki̱n, <N buu we̱i̱ taage̱, n jiyo, kan puuri we̱e̱nu̱ we̱i̱. ");
INSERT INTO wja_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Anda go̱ro̱ pu n wuni n cwii we̱i̱ gawu̱r mbi̱ri̱ n anggi̱ Galili.>> ");
INSERT INTO wja_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Bitrus nyi̱i̱ le̱e̱ ki̱n, <<Kana, kana we̱ waatu̱ we̱i̱ bu̱ri̱ yi̱ go̱ro̱u̱ di̱ngi̱n mo̱, mi yaa ku n waatu̱ we̱i̱.>> ");
INSERT INTO wja_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesu se̱e̱ ki̱n, <<Bitrus, n wo̱o̱ sagu̱mo̱u̱ ji̱re̱, a kum wunaa kami̱n ko̱lo̱o̱ ba te̱e̱ te̱e̱re̱ ma gwe̱le̱nggu̱ we̱i̱ daa kunong.>> ");
INSERT INTO wja_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Anda Bitrus ce̱ ki̱n, <<Kana n bo̱o̱ru̱ we̱i̱ kem yi̱ mo̱, yaa ku n gwe̱le̱mi̱nu̱ we̱i̱>> Pero mwa mwa kwati̱mba ya bu kangga bwii mwaasi̱ ce̱ yi̱to̱. ");
INSERT INTO wja_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Go̱ro̱ yi̱to̱ Yesu mwati̱ kem yi̱ kwati̱mba ya a pu nu̱wa yi̱ri̱ ki̱n, Gesimani, a sa pma ki̱n, <<Bu si̱ndi̱ si̱ye̱i̱ pi̱na mi n ko̱ n songge gawu̱re̱ n ce̱ ku̱ru̱.>> ");
INSERT INTO wja_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","A de̱e̱ Bitrus yi̱ kwaraa Sabadi bu ro̱p kem yi̱ yo̱, a toso bwiyang gaanggu̱ yi̱ mi̱yanggu̱ bu̱ru̱. ");
INSERT INTO wja_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","A sa pma ki̱n, <<Bawei mi twangi yi̱ bwiyang gaanggu̱ ci̱ka n bwaa. Bu si̱ndi̱ si̱yandi̱ pi̱na bu si̱ya ci̱pi̱gi̱ bu̱ri̱ kem yi̱ mi.>> ");
INSERT INTO wja_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","A kosuro banyi̱na a yara, a suni kau si̱ma, a ce̱ ku̱ru̱ ki̱n, <<Mbaa mi, ka ni̱ndu̱ wai we̱i̱ mo̱ de̱mangi̱n ki̱na cu̱su̱gu̱. Anda dangandi̱ mi ne̱, anda to̱o̱ mai.>> ");
INSERT INTO wja_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","A waata bo̱nggo̱ kwati̱mba ya baa nyi̱ngga pma diimandi, a pi̱ra Bitrus ki̱n, <<Yaa ku bu puu we̱i̱ bu si̱ya ci̱pi̱gi̱ bu̱ri̱ kem yi̱ mi nyan jo̱r banyi̱na ru? ");
INSERT INTO wja_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Bu si̱ya ci̱pi̱gi̱ bu̱ri̱, bu ce̱ ku̱ru̱ daakal bu yanna miyam. Bawei kasi̱gu̱ anda bu̱ri̱ yaa di̱mbi̱re̱.>> ");
INSERT INTO wja_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","A mwati̱ ku ro̱p a ce̱ ku̱ru̱ ki̱n, <<Mbaa mi, ka yaa ku ni̱ndu̱ we̱i̱ ko̱o̱ cu̱su̱gu̱ ba lamana ko̱po̱ ka n cu̱si̱, yama dangandi̱ mai ba ni̱ngwa.>> ");
INSERT INTO wja_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Pu waatau a nyi̱ngga pma diimandi do̱ng, di̱ngi̱n nundi pma ni̱nga ko̱mbi̱ro̱m. ");
INSERT INTO wja_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","A du pma a waata bu̱ri̱ do̱ng, a ce̱ ku̱ru̱ ku kunong a pero tu co̱nggo̱ ci̱ye̱i̱. ");
INSERT INTO wja_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Pero a waata bu̱ri̱ bo̱nggo̱ kwati̱mba ya a sa pma ki̱n, <<Bo̱o̱ bu bo̱o̱ diimandi ru? Bu yo̱ro̱nggu̱ ru? Su̱wa jo̱r ni̱nga nu̱wa cuu Bo̱l Ne̱re̱ a war nu̱wa bu yi̱ we̱le̱mdi̱ wa. ");
INSERT INTO wja_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Bu wunongo yi mwatanga! Ne̱re̱ wu cuugu mu wii wo̱o̱ bagu̱!>> ");
INSERT INTO wja_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Pu bo̱o̱ Yesu wo̱o̱ ce̱gu̱ ci̱ye̱u̱, Yahuda wu wiino cu̱du̱ bu kwap su̱r ro̱p bwii lamuwe kem yi̱ nu̱wa tum yi̱ do̱mpo̱u̱ri̱ yi̱ gu̱mo̱ngi̱, bu bagi̱raa kuruwa wa yi̱ bagi̱raa nu̱wa wa tu̱mu̱we̱. ");
INSERT INTO wja_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yo̱ wu ne̱re̱ wu cuuru we̱i̱ a ru somdi tu pma ku̱ranu̱ we̱i̱ ki̱n, <<Ne̱re̱ wu ku̱u̱na bu̱ri̱ wii yo̱, bu te̱e̱.>> ");
INSERT INTO wja_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ku pma lama, yo̱ko̱ yo̱ko̱ Yahuda aara bo̱nggo̱ Yesu se̱e̱ ki̱n, <<N ci̱ mi̱na ku̱lu̱me̱,>> pero a ku̱u̱nu̱ yo̱ bu̱ri̱. ");
INSERT INTO wja_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesu nyi̱i̱ le̱e̱ ki̱n, <<Basi̱n mi, ni̱nga tu de̱mu̱we̱.>> Nu̱wa bwii twiyongo parnu̱ wari̱ taa Yesu. ");
INSERT INTO wja_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ku ni̱ngwa yi̱to̱, wu wiino cu̱du̱ barauwa Yesu a yaku wai a podo do̱mpo̱u̱ yo̱u̱ a kaca twiyau ke̱we̱ bagi̱ra kuruwa a mwari̱ya. ");
INSERT INTO wja_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yesu se̱ ki̱n, <<Pu̱n do̱mpo̱u̱ mo̱u̱ mi̱ri̱nggi̱ laa yo̱u̱, di̱ngi̱n wu podo do̱mpo̱u̱ bo̱o̱ri̱ do̱mpo̱u̱. ");
INSERT INTO wja_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ma nu̱u̱ mi̱n n pu yi̱gu̱ Mbaa mi, ba suka bacamandi tum yo̱ko̱ ki̱na ru? ");
INSERT INTO wja_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Anda ka n ni̱ng yi̱to̱, ci̱ye̱i̱ De̱mte̱e̱re̱ du ce̱ ki̱n, tagi̱ ba ni̱ngwa yi̱to̱, ni̱ndu̱ we̱i̱ nye̱ ba twangwa?>> ");
INSERT INTO wja_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","A dwii jo̱re̱ Yesu sa nu̱wa bu tum bwii ki̱n, <<Di̱ngi̱n ca bu baanga yi̱ do̱mpo̱u̱ri̱ yi̱ gu̱mo̱ngi̱ bu tangge̱ ci̱ka n kuwe? Kana ko̱no̱ nyanggu̱ n si̱i̱ laa Yambau̱ n pi̱rgu̱ yi̱ri̱ nu̱wa anda bu tanggu̱ bu. ");
INSERT INTO wja_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Anda to̱o̱ mwa mwa a ni̱ngwa palaka ba twanga tu banabi̱ndi̱ bala ki̱n ni̱ndu̱ we̱i̱.>> Kwati̱mba ya mwa mwa du yo̱ a ceendo. ");
INSERT INTO wja_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Nu̱wa bu ta Yesu wa a de̱e̱ yo̱ bo̱nggo̱ Kayapa kuru wu gi̱ra pu ku̱lu̱mba te̱e̱ri̱ngi̱ wa yi̱ bagi̱raa Yudaya wa ku̱ranga bu̱ri̱. ");
INSERT INTO wja_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Anda Bitrus po̱ng yo̱ gantin, a lama bo̱nggo̱ laa kuru wu gi̱ra . A diiro si̱n si̱ye̱i̱ kem yi̱ nu̱wa bu swe̱ri̱gu̱ yo̱ wa ba ko̱ tu ni̱ndu̱ we̱i̱ bu̱ri̱. ");
INSERT INTO wja_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Bagi̱ra kuruwa yi̱ bagi̱raa nu̱wa bu Yudaya wa mwa mwa pma kasi̱gu̱ se̱e̱daki̱ leendu a dwii Yesu palaka pma ba ji yo̱. ");
INSERT INTO wja_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Anda pma nyi̱ngga bu kana ca, kana ku baleenda twiyongo. Cwata go̱ro̱ yo̱u̱ nu̱wa ro̱p twiyongo, ");
INSERT INTO wja_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","a ce̱ ki̱n, <<Ne̱re̱ wo̱o̱ ce̱ ki̱n, <N puu we̱i̱ bwiyanggu laa Yambau̱ n mwe̱ nyan daa kunong.>>> ");
INSERT INTO wja_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Bur bagi̱ra kuruwa wii wuni a sa Yesu ki̱n, <<Yaa ku ma nyi̱i̱ we̱i̱ le̱e̱ a dwii we̱le̱ce̱u̱ wu nu̱wa bo̱o̱ ce̱gu̱ a dwii ru?>> ");
INSERT INTO wja_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Yesu si̱n si̱ye̱i̱ to̱k. Bagi̱ra kuruwa wii sa yo̱ ki̱n, <<N ne̱ca mi̱na yi̱ Yamba wii yi̱ pi̱i̱ma yi̱ we̱ra sa yiro ka ma Masiya Bo̱l Yamba wai.>> ");
INSERT INTO wja_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu nyi̱i̱ le̱e̱ ki̱n, <<O̱ng ci̱ka ku ma ce̱ ko̱o̱, anda n wo̱o̱ sagu̱mbi̱ru̱ pi̱na yi̱ gawu̱re̱ bu kwe̱e̱ we̱i̱ Bo̱l Ne̱re̱ pi̱su̱ a wai wu je̱u̱ Yambau̱ wu yi̱ Di̱mbi̱re̱ a bagu̱ mi̱ri̱nggu̱ tinendi a diyou.>> ");
INSERT INTO wja_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Bagi̱ra kuruwa wii pwaranga se̱e̱ yo̱ di̱ngi̱n ba ju̱ku̱ bwiyan gaanggu̱ yo̱u̱, a ce̱ ki̱n, <<A ce̱ ce̱wi̱ bwiyangi din Yambai̱! Di̱ngi̱n ca yi kasi̱gu̱ se̱e̱daki̱ wu kangge̱ do̱ng? Su̱wa, yo̱ko̱ bu nu̱u̱ ko̱o̱ bwiyangu din Yambau̱. ");
INSERT INTO wja_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Bu ce̱ mi̱n ca? Pma le̱e̱man yo̱ ki̱n, <<A yinno bo̱o̱re̱!>> ");
INSERT INTO wja_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Bur pma tuuman yo̱ ti̱i̱ma kau, pero cumongo. Bu kangga kapanga yo̱. ");
INSERT INTO wja_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","A ce̱ ki̱n, <<Masiya, ka ma banabi̱ wai, sa yiro, wu buu mi̱na we̱?>> ");
INSERT INTO wja_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Bitrus wo̱o̱ pi̱su̱ mi̱ri̱nggi̱ laa kuru wu bagi̱ra , bur bwe̱e̱canga wu kangge̱ wu twii ke̱we̱ baa bo̱nggo̱ yo̱ ce̱ ki̱n, <<Mo̱ mwaasi̱ ma wo̱o̱ kem yi̱ Yesu ne̱re̱ wu Galili.>> ");
INSERT INTO wja_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Anda a gwe̱la yo̱ a gawu̱ru̱ pmai mwa mwa ki̱n, <<N so̱m bu tu ma ce̱gi̱.>> ");
INSERT INTO wja_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pu twiyo nyinou, bwe̱e̱canga wu kangge̱ wu twii ke̱we̱ ko̱ yo̱, a sa nu̱wa bu pwii bwii ki̱n, <<Wuna ne̱re̱ wo̱o̱ kem yi̱ Yesu wu Nasaret.>> ");
INSERT INTO wja_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","A gwe̱la do̱ng, a we̱re̱nga ce̱ ki̱n, <<N so̱m bu wo̱o̱ ne̱re̱.>> ");
INSERT INTO wja_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Go̱ro̱u̱ banyi̱na pma bu pi̱ti̱ndi̱ pwii bwii aanda bo̱nggo̱ Bitrus a ce̱ ki̱n, <<Manggu, ma wo̱o̱ cu̱du̱ pmai, di̱ngi̱n miu ce̱ mo̱u̱ a ju̱ku̱ya.>> ");
INSERT INTO wja_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","A toso we̱re̱nggu̱ ki̱n, <<Bwi̱i̱ge̱ ba tangge̱ ka n ce̱gu̱ leendi wai, n so̱m bu ne̱re̱ wo̱o̱.>> Ki̱no̱ngu̱ ko̱lo̱o̱ te̱e̱ te̱e̱re̱. ");
INSERT INTO wja_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Bitrus dangga tu Yesu sa yo̱, <<Kami̱n ko̱lo̱o̱ ba te̱e̱ te̱e̱re̱, ma gwe̱le̱nggu̱ we̱i̱ daa kunong mi̱n ma so̱nggu̱ bu.>> A twiyo twalange̱, a ji windi wang. ");
INSERT INTO wja_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Yi̱ pinu ki̱lang, bagi̱raa kuruwa yi̱ bagi̱raa nu̱wa wa mwa mwa pma su̱wa tu pma ni̱ngu̱ we̱i̱ ba ji Yesu. ");
INSERT INTO wja_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Pma twala yo̱, mwatanga yi̱ yo̱ de̱ bo̱nggo̱ Bilatus wu twii gomna. ");
INSERT INTO wja_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Pu Yahuda wu cuu yo̱ ko̱ nu̱wa mwar man Yesu bali̱ bo̱o̱ri̱. A ni̱nga mondo mondo, a puu ke̱n asurpa kuna kunong dwii bagi̱raa kuruwa wa wii yi̱ bagi̱raa nu̱wa bwii. ");
INSERT INTO wja_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","A ce̱ ki̱n, <<N ni̱nga we̱le̱m, n cuu ne̱re̱ wu yaa we̱le̱ce̱u̱.>> Pma ce̱ ki̱n, Do̱ yiri do̱no̱, to̱o̱ biiki mo̱.>> ");
INSERT INTO wja_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yahuda para ke̱n dwii mi̱ri̱nggi̱ laa Yambau̱, a mwati̱ yaka bu̱ri̱ ye̱i̱. ");
INSERT INTO wja_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Bagi̱raa kuruwa wa wii de̱e̱ ke̱n dwii a ce̱ ki̱n, <Te̱e̱ri̱ le̱e̱ bu nu̱wa ba parni̱ do̱o̱ ke̱n a betal, di̱ngi̱n to̱o̱ ke̱n ti̱i̱mai̱.>> ");
INSERT INTO wja_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Pma le̱e̱ ba de̱e̱ ke̱n dwii ba te̱n si̱ma ne̱re̱ wu mwe̱e̱ni̱ dinendi, di̱ngi̱n ba yo̱ pu nu̱wa ting ru̱nggu̱wa. ");
INSERT INTO wja_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Twii to̱no̱ nu̱wa yi̱ri̱ ki̱n, Si̱ma Ti̱i̱ma wa lama yo̱ko̱. ");
INSERT INTO wja_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","To̱o̱ twang tu banabi̱ Irmiya ce̱i̱, <<Pma de̱e̱ asurpa kuna kunong, to̱o̱ duu wu nu̱wa bu Israila wa ru woo ki̱n nu̱wa ba cuu yo̱. ");
INSERT INTO wja_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Pma de̱e̱ te̱n si̱ma ne̱re̱ wu mwe̱e̱ni̱ dinendi ci̱ka ku Mbaa Wu Gi̱ra sangge̱.>> ");
INSERT INTO wja_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesu ti̱n ti̱ye̱i̱ gawu̱r gomna, gomna pi̱ra ki̱n, <<Ma yo̱o̱gi̱ balaa wu Yudaya ru?>> A le̱e̱ ki̱n, <<O̱ng ci̱ka ku ma ce̱ ko̱o̱.>> ");
INSERT INTO wja_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Pu bagi̱raa kuruwa wa yi̱ bagi̱raa nu̱wa wa ce̱ we̱le̱mdi̱ a dwii ye̱i̱, yaa ku nyi̱i̱ le̱e̱. ");
INSERT INTO wja_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Bilatus pi̱ra ki̱n, <<Ma yaa nu̱u̱gu̱ se̱e̱daki̱ wu pma ce̱gu̱ dwii ma ru?>> ");
INSERT INTO wja_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Anda Yesu yaa ku sa pma ci̱ye̱i̱, a dwii ce̱wi̱ tu pma ce̱ dwii ye̱i̱ kana banyi̱na, gomna riyanga bu̱ri̱ wang. ");
INSERT INTO wja_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ci̱ka ku gomna me̱e̱ ni̱ngu̱, kana so̱no̱ Waandi Yerigu yo̱ man ne̱re̱ wiino wu jaru̱m wu nu̱wa kasa. ");
INSERT INTO wja_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","A dwii jo̱re̱ wo̱o̱ ne̱re̱ wu jaru̱m wu nu̱wa so̱ma wang yi̱ ni̱nga wu bwi̱i̱ye̱, dini ye̱i̱ Barabas. ");
INSERT INTO wja_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Di̱ngi̱n to̱no̱ pu nu̱wa ku̱ranga bu̱ri̱, Bilatus pi̱ra pma ki̱n, <<Wu bu kasi̱ n man mbi̱ra we̱ Barabas ru, Yesu wu nu̱wa yi̱ri̱ ki̱n Masiya ru?>> ");
INSERT INTO wja_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Di̱ngi̱n a so̱ma ki̱n pma taa Yesu bo̱nggo̱ yo̱u̱ di̱ngi̱n bwiu. ");
INSERT INTO wja_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pu Bilatus wo̱o̱ pi̱su̱ a pi̱su̱ wu yo̱ ni̱ng balu, nu̱re̱ yo̱ ni̱nga man yo̱ tu̱ne̱ ki̱n, <<Ma ni̱ngamani̱ ya ne̱re̱ wu yaa we̱le̱ce̱u̱ wo̱o̱ kana ca di̱ngi̱n reni n turuwa yi̱ dweendi di̱ngi̱n yo̱.>> ");
INSERT INTO wja_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Anda kuruwa bu bagi̱raa wa yi̱ bagi̱raa nu̱wa wa pma ciyongo nu̱wa ba ce̱ ki̱n nu̱wa ba man Barabas, nu̱wa ba ji Yesu. ");
INSERT INTO wja_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Gomna pi̱ra ki̱n, <<Cu̱du̱ pmai bu ro̱p, n man mbu̱we̱ we̱? Pma nyi̱i̱ le̱e̱ ki̱n, <<Barabas.>> ");
INSERT INTO wja_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Bilatus pi̱ra pma ki̱n, <<N ni̱ng ca yi̱ Yesu wu nu̱wa yi̱ri̱ ki̱n Masiya?>> Mwa mwa pma nyi̱i̱ le̱e̱ ki̱n, <<Pi̱i̱na ye̱u̱ ba bwaa.>> ");
INSERT INTO wja_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Bilatus pi̱ra ki̱n, <<Di̱ngi̱n ca? A ni̱nga we̱le̱ce̱u̱ yo̱u̱ ca?>> Anda nu̱wa bwii cwata kwari̱ndi̱ ki̱n, <<Bu pi̱i̱na ye̱u̱!>> ");
INSERT INTO wja_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pu Bilatus ko̱ yaa tu yo̱ puu we̱i̱, anda pma toso kasi̱gu̱ ruuni, di̱ngi̱n to̱no̱ a de̱e̱ gundu a car wari ye̱i̱ gawu̱r nu̱wa bwii a ce̱ ki̱n, <<N yaa wai dwii bo̱o̱re̱ ne̱re̱ wo̱o̱, yama ti̱i̱ma yo̱u̱ ba si̱ya dwii mbi̱ri̱!>> ");
INSERT INTO wja_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Nu̱wa bwii mwa mwa le̱e̱ ki̱n, <<Yama ti̱i̱ma ya ba si̱ya dwii yiri yi̱ kwaraa yuwa!>> ");
INSERT INTO wja_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","A man manu̱we̱ pma Barabas, a din nu̱wa waci̱ Yesu, a nyi̱i̱ Yesu kacara bu Roma wa ba pi̱i̱na ye̱u̱. ");
INSERT INTO wja_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Kacara Bilatus de̱ Yesu mi̱ri̱nggi̱ caame̱ gomna, pma yi̱we̱ kacara mwa mwa ku̱ranga bu̱ri̱ bo̱nggo̱ yo̱u̱. ");
INSERT INTO wja_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Pma wuroman yo̱ se̱e̱ a te̱e̱man yo̱ gatangamau ku wu̱ci̱ci̱ ci̱ka balaa, ");
INSERT INTO wja_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","pma me̱ne̱nga me̱tu̱wal tu̱ri̱ a diiman yo̱ dwii. Pma de̱e̱ jwalu nyi̱i̱ya a wai wu je̱u̱, pma kun kwiyei gawu̱r ye̱i̱, pma ni̱ngaman yo̱ nyasi̱ ce̱gu̱ ki̱n, <<Bundi, balaa wu Yudaya>> ");
INSERT INTO wja_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Pma tuuman yo̱ ti̱i̱ma, pero pma de̱e̱ jwalu ku wai yo̱ kwii a ni̱nga pu buwanggu dwii. ");
INSERT INTO wja_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Go̱ro̱ pu pma mata ni̱nga man yo̱ nyasi̱, pma te̱e̱man yo̱ se̱e̱ yo̱, pma de̱ yo̱ ba pi̱i̱na ye̱u̱. ");
INSERT INTO wja_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Pu pma twiyonggu, pma kaanga yi̱ ne̱re̱ wu kangge̱ wu gwe̱i̱ Sayirin din ye̱i̱ Simon. Kacara bwii ki̱canga ba de̱ ye̱u̱ wii. ");
INSERT INTO wja_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Pma baanga pu nu̱wa yi̱ri̱ ki̱n, Golgota, pi̱ti̱ndi̱ ye̱i̱ ki̱n, <<Ko̱ko̱ Dwii.>> ");
INSERT INTO wja_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Pma nyi̱i̱ Yesu gundu inabi casi̱nggi̱ tu kwe̱re̱k ba naa, anda go̱ro̱ pu ti̱yau̱, a kwaa naagu. ");
INSERT INTO wja_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Pu pma pi̱i̱na ye̱u̱, pma cwaanga se̱e̱ yo̱ bo̱nggo̱ ke̱e̱gu̱ lato̱mbale̱. ");
INSERT INTO wja_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Pma si̱n si̱ye̱ndi̱, ni̱nga pu swe̱ri̱gu̱ yo̱. ");
INSERT INTO wja_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Nu̱wa bala we̱le̱ce̱u̱ yo̱u̱ a pi̱i̱na dwii ye̱u̱ wii ne̱m yi̱ dwii ye̱i̱ ki̱n, <<Wunaa Yesu, balaa nu̱wa bu Yudaya wa.>> ");
INSERT INTO wja_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Nu̱wa pi̱i̱ni̱ kuuwa ro̱p kem yi̱ yo̱ wu wiino wai yo̱u̱ je̱u̱, wu kangge̱ wai wu miu. ");
INSERT INTO wja_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Nu̱wa bu cwiyongu wa ni̱nga pu rwe̱e̱nggu̱ a ge̱pu̱gu̱ dwii a ni̱nggu̱ yo̱ nyasi̱, ");
INSERT INTO wja_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ce̱gu̱ ki̱n, <<Ma ce̱ mi̱n ma re̱pu̱ we̱i̱ Laa Yambau̱ ma mo̱ru̱ we̱i̱ nyan daa kunong, mi̱ra bu̱ri̱ mai, ma julo ye̱u̱ wo̱o̱, ka ma Bo̱l Yamba wai!>> ");
INSERT INTO wja_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Yi̱to̱ mwaasi̱ yi̱ bagi̱raa kuruwa wa yi̱ ku̱lu̱mba te̱e̱ri̱ngi̱ wa yi̱ bagi̱raa nu̱wa wa pma ni̱nga man yo̱ nyasi̱. ");
INSERT INTO wja_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Pma ce̱gu̱ ki̱n, <<Yo̱ mi̱ra bu kangga anda jaanga mi̱ri̱gu̱ bu̱ri̱ ye̱i̱! Balaa wu Israila! Yama ba julo dwii ye̱u̱ wo̱o̱, yo mwa yi̱ le̱e̱ we̱i̱ ji̱re̱ yi̱ yo̱. ");
INSERT INTO wja_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Yo̱ le̱e̱ ji̱re̱ yi̱ Yamba. Yama Yamba ba mi̱ra yo̱ ka kasi̱ yo̱ we̱i̱, di̱ngi̱n a ce̱ ki̱n, <Yo̱ Bo̱l Yamba>>> ");
INSERT INTO wja_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ban kuuwa bu nu̱wa pi̱i̱na ye̱u̱ kem yi̱ yo̱ wa rwe̱e̱nga yo̱ mwaasi̱. ");
INSERT INTO wja_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Yake̱ cu̱du̱ nyanggi̱, ku̱mji̱la laka si̱ma bwii mwa mwa ko̱po̱ yi̱ nyambi̱ranggu̱ jo̱r du kunong. ");
INSERT INTO wja_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","A jo̱r du kunong Yesu yi̱ yi̱re̱ yi̱ du̱we̱i̱ ki̱n, <<Elo̱i̱, Elo̱i̱, lama sabaktani?>> Pi̱ti̱ndi̱ ye̱i̱ ki̱n, <<Yamba mi, Yamba mi, di̱ngi̱n ca ma manggi̱ si̱ye̱i̱?>> ");
INSERT INTO wja_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Pu pma bu pi̱ti̱ndi̱ pwii wa nu̱wa yi̱to̱ pma ce̱ ki̱n, <<A yi̱gu̱ Iliya.>> ");
INSERT INTO wja_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ki̱no̱ngu̱ wu kangge̱ ceero a diini soso gundu inabi ku jo̱mbu̱ro̱m a diina jwalu a diiman Yesu nyi̱yau̱ ba naa. ");
INSERT INTO wja_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Bu kangga bwii ce̱ ki̱n, <<Bu dwiya po̱o̱ yi ko̱ ka yikwii Iliya ba mi̱ra we̱i̱ yo̱ wai.>> ");
INSERT INTO wja_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Pu Yesu pero yi̱gu̱ yi̱ru̱ yi̱ duwai, pi̱i̱ma ya twiyo. ");
INSERT INTO wja_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","A dwii jo̱re̱ ko̱we̱ wu laa Yambau̱ nge̱re̱nga bu̱ri̱ ro̱p toso diyou be̱e̱ si̱ma. Si̱ma sikto bu̱ri̱ swari̱ngi̱ ge̱le̱nga bu̱ri̱. ");
INSERT INTO wja_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Purongi wumongo bu̱ri̱ nu̱wa bu walwal bu bwaanga wa wunongo yi̱ pi̱i̱ma. ");
INSERT INTO wja_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Pma twiyongo a purongi go̱ro̱ wungu Yesu bo̱o̱re̱, pma mwatanga gwe̱i̱ du walwal, pma ju̱ku̱ bu̱ri̱ pmai nu̱wa tum. ");
INSERT INTO wja_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Pu bagi̱ra kacara yi̱ pma bu kem swe̱ri̱gu̱ Yesu wa ko̱ si̱ma sikto bu̱ri̱ yi̱ mwa mwa tu ni̱ngi̱ wa, pma nu̱u̱ gwasi̱ wang, pma ce̱ ki̱n, <<Manggu to̱o̱ Bo̱l Yamba!>> ");
INSERT INTO wja_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Nu̱ru̱mba tum bo̱o̱ pwii pma su̱gu̱ kwaara. Pma po̱ng Yesu yake̱ Galili pma kalanggu̱ yo̱ wu̱rai̱. ");
INSERT INTO wja_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","A cu̱du̱ bu bo̱o̱ pwii wa, bo̱o̱ yi̱ bu Maryamu wu Magadaliya yi̱ Maryamu njaa Yakubu yi̱ Yusupu yi̱ njaa kwaraa Sabadi wa. ");
INSERT INTO wja_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Pu nyambi̱ranggu̱ ni̱nga ne̱m, bagi̱na wu kangge̱ wu gwe̱i̱ Arimatiya a baa, din ye̱i̱ Yusupu, yo̱ yi̱ri̱ ye̱i̱ wo̱o̱ cu̱du̱ kwati̱mba Yesu wa. ");
INSERT INTO wja_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","A aara bo̱nggo̱ Bilatus, a senggo ko̱mo̱u̱ Yesu, Bilatus sa nu̱wa ba nyi̱i̱ya. ");
INSERT INTO wja_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yusupu diin nu̱wa cikumanuwe yo̱ bu̱ri̱ Yesu a ye̱u̱, a kumbulo yi̱ lawan wu walwal. ");
INSERT INTO wja_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","A diin yo̱ a puri ye̱i̱ du pu̱ci̱ du wu̱li̱ dwii swe̱li̱. A ce̱nni̱ swe̱li̱ du duwi nyan puri dwii a mwati̱. ");
INSERT INTO wja_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maryamu Magadaliya yi̱ Maryamu wu kangge̱ wii pma pi̱si̱ndi̱ puri dwii. ");
INSERT INTO wja_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ku lam pinu nyanggu̱ sabadu, bagi̱raa kuruwa wa yi̱ Parisayo aanda bo̱nggo̱ Bilatus. ");
INSERT INTO wja_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Pma ce̱ ki̱n, <<Ne̱re̱ wu gi̱ra, yi dangga tu ne̱re̱ wu ciyeni nu̱wa wo̱o̱ ce̱i̱ pu bo̱o̱ wo̱o̱ yo̱ pi̱i̱mau̱ ki̱n, <Go̱ro̱ daa kunong n wuni we̱i̱ yi̱ pi̱i̱ma do̱ng.> ");
INSERT INTO wja_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Di̱ngi̱n to̱no̱ diin nu̱wa ba swe̱ra puri dwii nyan daa kunong, dakali, kwati̱mba ya ba ji̱nda bu̱ri̱ ye̱i̱, ba sa nu̱wa ki̱n a wuni bo̱nggo̱ bo̱o̱re̱. Ka ni̱ngdi̱ yi̱to̱ ciyeni tu go̱ro̱ yo̱ gwalu we̱i̱ tu gawu̱ri̱yo̱.>> ");
INSERT INTO wja_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Bilatus nyi̱i̱ le̱e̱ ki̱n, <<Bu de̱e̱ kacara bu swe̱ru̱ we̱i̱ wa bu ambi̱ra puri dwii bu swe̱ra nyan di̱mbi̱ri̱ mbi̱re̱.>> ");
INSERT INTO wja_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Pma aanda puri dwii, pma dii mwali̱nggi̱ dwii swe̱li̱ dwii, diini kacara ba swe̱ra. ");
INSERT INTO wja_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Go̱ro̱ nyanggu̱ Sabadu yi̱ pi̱n ki̱lang a nyanggu̱ Laadi, Maryamu wu gwe̱i̱ Magadaliya yi̱ Maryamu wu kangge̱ wii pma mwatanga ba su̱wa puri dwii. ");
INSERT INTO wja_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Si̱ma sikto bu̱ri̱ wang, di̱ngi̱n bacama Mbaa Wu Gi̱ra a julo diyou Yambau̱, a aara puri dwii, a gumbulo swe̱l dwii a si̱i̱na dwii ye̱i̱. ");
INSERT INTO wja_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","A nyi̱langgu̱, se̱e̱ yo̱ po̱pu̱lo̱k ci̱ka cankar. ");
INSERT INTO wja_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Nu̱wa bu swe̱ri̱gu̱ wa pma nu̱u̱ gwasi̱ ye̱i̱ pma remcuwa yaranga ci̱ka nu̱wa bu bwaanggi̱ wa. ");
INSERT INTO wja_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Bacama wii sa nu̱ru̱mba wii ki̱n, <<Bu nu̱u̱ ya gwasi̱, di̱ngi̱n n so̱ma bu kasi̱gu̱ Yesu wu nu̱wa pi̱i̱na ye̱u̱. ");
INSERT INTO wja_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Yaa po̱o̱, a wuni ci̱ka ku ce̱u̱, bambe̱ bu ko̱ pu nu̱wa ke̱ndau̱. ");
INSERT INTO wja_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Bu ambi̱ra ki̱lang ki̱lang bu sa kwati̱mba ya, <A wuni bo̱nggo̱ bo̱o̱re̱, anda wo̱o̱ so̱ngma Galili a gawu̱r mbi̱ri̱. Bu kwe̱e̱ we̱i̱ yo̱ pwii.> Yo̱ko̱ n sambi̱ra.>> ");
INSERT INTO wja_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Di̱ngi̱n to̱no̱ nu̱ru̱mba bwii yala bu̱ri̱ du̱ puri dwii yi̱ gwasi̱, yi̱ bu̱ri̱ de̱gde̱g, pma ceendo ba sa kwati̱mba ya. ");
INSERT INTO wja_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ki̱nangu̱ kwii Yesu baa bo̱nggo̱ pmau ce̱ ki̱n, <<N ci̱gu̱ mbi̱ru̱.>> Pma baanga bo̱nggo̱ yo̱u̱ kwiino mwar ye̱i̱ a ku̱raman yo̱ si̱ma. ");
INSERT INTO wja_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yesu sa pma ki̱n, <<Bu nu̱u̱ ya gwasi̱, bu ambi̱ra bu sa ci̱yamba muwa ba aanda Galili, pma ko̱nggu̱ we̱i̱ pwii.>> ");
INSERT INTO wja_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Pu nu̱ru̱mba bwii bo̱o̱ nyinou, bu kangga cu̱du̱ nu̱wa bu swe̱ri̱gu̱ puri Yesu wa mwatanga mi̱ri̱nggu̱ gwe̱i̱ a sa bagi̱raa kuruwa wa kana ca tu ni̱ngwa. ");
INSERT INTO wja_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Pu bagi̱raa kuruwa wa kaanga yi̱ bagi̱raa nu̱wa wa, pma sedo pwi̱i̱, pma nyi̱i̱ kacara bwii ke̱n tum. ");
INSERT INTO wja_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Pma ba sa pma ki̱n, <<Bu sa nu̱wa mi̱n, <Kwati̱mba ya baanga yi̱ ku̱me̱ ba ji̱nda yo̱ pu yi bo̱o̱ diimandu.>>> ");
INSERT INTO wja_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ka do̱o̱ ci̱ye̱i̱ lam bo̱nggo̱ gomna, yo nyan dwii yiri yi di̱ramanu̱ we̱i̱ yo̱ gaanggu̱ pero yi yiki mbi̱ri̱ we̱i̱ a ku̱u̱le̱.>> ");
INSERT INTO wja_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Di̱ngi̱n to̱no̱ pma de̱e̱ ke̱n dwii ni̱nga tu nu̱wa sa pmai. Wo̱o̱ labar wasi̱ bu̱ri̱ kwaara bo̱nggo̱ nu̱wa bu Yudaya wa a baa ki̱na nyanggu̱. ");
INSERT INTO wja_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Kwati̱mba ya bu kwap su̱r wiino bwii a aanda Galili, a ci̱ngu̱ ku Yesu sa pmau. ");
INSERT INTO wja_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Pu ko̱ yo̱, pma ku̱raman yo̱ si̱ma anda bu kangga le̱e̱ bu ki̱n wii Yesu. ");
INSERT INTO wja_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesu baa bo̱nggo̱ pmau a ce̱ ki̱n, <<Mwa mwa di̱mbi̱re̱ wu diyou yi̱ si̱ma nu̱wa nyi̱ngge̱ ");
INSERT INTO wja_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Di̱ngi̱n to̱no̱ bu ambi̱ra a kana pi̱yau̱ mi̱ri̱nggi̱ si̱ma bu yi̱we̱ nu̱wa mwa mwa ba yo̱o̱ kwati̱mba muwa, bu ni̱ngaman pma bati̱si̱ma mi̱ri̱nggi̱ din Mbaate̱ yi̱ du Bwi̱ya yi̱ du Bawei du Walwal. ");
INSERT INTO wja_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Bu pi̱r pma ba ni̱nga po̱ngo̱ndi̱ yi̱ kana ca tu n sa mbi̱rai̱. Ji̱re̱, n wo̱o̱ kem yi̱ mba kana pe̱ne̱ pe̱ne̱, ko̱po̱ nyanggu̱ gwatu̱gu̱ si̱mai̱.>> ");
INSERT INTO wja_vpl VALUES ("CL1_1","081_1_1","COL","1","1","1","Wuna lakargar baa bo̱nggo̱ Bulus, ne̱re̱ tu̱mandi̱ Masiya Yesu wu Yamba se̱ka cu̱u̱nggi̱ dangandi̱ ye̱i̱ yi̱ Timoti bago̱n yire. ");
INSERT INTO wja_vpl VALUES ("CL1_2","081_1_2","COL","1","2","2","Yi bo̱o̱ balaman nu̱wa Yamba bu gwe̱i̱ Kolosi wa, ci̱yamba yuwa bu yi̱ ji̱re̱ mi̱ri̱nggi̱ Masiya wa. Yama bo̱o̱ ni̱i̱u̱ yi̱ pi̱dau̱ gaanggu̱ wu Yamba Mbaa yire ba si̱ya kem yi̱ mba. ");
INSERT INTO wja_vpl VALUES ("CL1_3","081_1_3","COL","1","3","3","Kana do̱no̱ jo̱re̱ du yi ce̱gu̱ ku̱ru̱ di̱ngi̱n mba, yi wanan Yamba, Mbaa, Mbaa Wu Gi̱ra Yesu Masiya yire, ");
INSERT INTO wja_vpl VALUES ("CL1_4","081_1_4","COL","1","4","4","di̱ngi̱n yi nu̱u̱ le̱e̱gu̱ ji̱re̱ mbi̱ru̱ mi̱ri̱nggi̱ Masiya Yesu yi̱ kangam wu bu ni̱ngaman nu̱wa Yamba wa mwa mwa. ");
INSERT INTO wja_vpl VALUES ("CL1_5","081_1_5","COL","1","5","5","Bu ni̱nga yi̱to̱ di̱ngi̱n manam ni̱i̱u̱ wu nu̱wa ruu mbi̱ro̱ diyou, bu gaci̱la bu nu̱u̱ labar manam ni̱i̱u̱ a bo̱nggo̱ ci̱ye̱i̱ ji̱re̱i̱, du twii ci̱ye̱i̱ du teng. ");
INSERT INTO wja_vpl VALUES ("CL1_6","081_1_6","COL","1","6","6","Ci̱ye̱i̱ du teng du bambu̱we̱ a je̱gu̱ gawu̱ru̱, a gi̱ru̱ a si̱ma mwa mwa, ci̱ka ku ni̱nggu̱ bu̱ru̱ a cu̱du̱ mbi̱ri̱ yake̱ jo̱r du̱ bu nu̱wa pero bu ku̱ranga bo̱o̱ ni̱i̱ Yambau̱ mi̱ri̱nggi̱ ji̱re̱. ");
INSERT INTO wja_vpl VALUES ("CL1_7","081_1_7","COL","1","7","7","Bu ti̱langa bo̱nggo̱ Abaparas bago̱n wu̱rai̱ yire wu yi kangne̱, wu ni̱ng wu̱rai̱ Masiya yi̱ ji̱re̱i̱ di̱ngi̱n yo. ");
INSERT INTO wja_vpl VALUES ("CL1_8","081_1_8","COL","1","8","8","Yo̱ sa yiri duu kangam ku bu ni̱ngi̱ mi̱ri̱nggi̱ Bawei. ");
INSERT INTO wja_vpl VALUES ("CL1_9","081_1_9","COL","1","9","9","Di̱ngi̱n to̱no̱, yake̱ nyanggu̱ ku yi nu̱u̱ tu bu ni̱ngi̱, yaa ku lara ce̱gu̱ ku̱ru̱ di̱ngi̱n mba palaka Yamba ba twanga mbi̱ra yi̱ so̱mgu̱ tu kasi̱ bu ni̱nga a bo̱nggo̱ so̱mandi̱ yi̱ ku̱randi̱ tu Bawei nyi̱i̱. ");
INSERT INTO wja_vpl VALUES ("CL1_10","081_1_10","COL","1","10","10","Di̱ngi̱n bu ni̱nga pi̱su̱ wu nyaau wu nyi̱i̱ we̱i̱ gi̱ru̱ Mbaa Wu Gi̱ra pero di̱ramanu̱ we̱i̱ yo̱ gaanggu̱, ni̱nga mbi̱re̱ ba ju̱ki̱ kana do̱no̱ wu̱rai̱ du nyaai, yi̱ gi̱ru̱ mi̱ri̱nggi̱ so̱mgu̱ Yambau̱. ");
INSERT INTO wja_vpl VALUES ("CL1_11","081_1_11","COL","1","11","11","Yi bo̱o̱ ce̱gu̱ ku̱ru̱ mi̱n, Yamba ba ci̱ko̱ mbi̱ro̱ yi̱ kana wo̱no̱ di̱mbi̱re̱ cu̱u̱nggi̱ di̱mbi̱re̱ yo̱, wu yi̱ yi̱lau̱, palaka bu nyi̱ngga bo̱gu̱ gaanggu̱ yi̱ kanadi yi̱ di̱rang gaanggu̱. ");
INSERT INTO wja_vpl VALUES ("CL1_12","081_1_12","COL","1","12","12","Pero bu wananga Mbaa yire, yo̱ wu di̱na bu yinno nyi̱nggu̱ ge̱de̱l kem yi̱ nu̱wa Yamba wa bu mi̱ri̱nggi̱ lau̱ ku rang. ");
INSERT INTO wja_vpl VALUES ("CL1_13","081_1_13","COL","1","13","13","Yamba mi̱ra yiro ku̱u̱ lau̱ Balaa Buwai ku ri̱m, a de̱ yiwe ku̱u̱ lau̱ Bo̱l yo̱, wu kangne̱, ");
INSERT INTO wja_vpl VALUES ("CL1_14","081_1_14","COL","1","14","14","Wu waka yiro, pero a par si̱ye̱i̱ sukom we̱le̱m yiru. ");
INSERT INTO wja_vpl VALUES ("CL1_15","081_1_15","COL","1","15","15","Nu̱wa yaa kwe̱i̱ Yamba, anda Masiya wii yo̱ wekilei Yamba wu nu̱wa yaa kwe̱i̱ wii. Wii yo̱ wo̱o̱ yi̱ di̱mbi̱re̱ a dwii tu Yamba ruwo mwa mwa. ");
INSERT INTO wja_vpl VALUES ("CL1_16","081_1_16","COL","1","16","16","Di̱ngi̱n Yamba ruu yi̱ri̱ngi̱ mwa mwa a bo̱nggo̱ yo̱u̱, yi̱ri̱ngi̱ tu diyou yi̱ tu si̱mai̱, tu nu̱wa kwe̱i̱ yi̱ tu nu̱wa yaa kwe̱i̱, kana lau̱ kana di̱mbi̱re̱, kana balamba kana lau̱ri̱, mwa mwa yi̱ri̱ngi̱ Yamba ruwo bo̱nggo̱ yo̱u̱ pero di̱ngi̱n yo̱. ");
INSERT INTO wja_vpl VALUES ("CL1_17","081_1_17","COL","1","17","17","Yo̱ wo̱o̱ pu bo̱o̱ Yamba ruu bu yi̱ri̱ngi̱ mwa mwa, pero yo̱ diini yi̱ri̱ngi̱ mwa mwa yo̱o̱ a pi̱su̱ pmau̱. ");
INSERT INTO wja_vpl VALUES ("CL1_18","081_1_18","COL","1","18","18","Yo̱ yo̱o̱gi̱ dwii bu̱ri̱, wu twii ikkilisiya. Yo̱ to̱o̱ toson taawu̱ kana ca, wii yo̱ wu Yamba wun yo̱ gawu̱ri̱yo̱ a bo̱o̱re̱, palaka a mi̱ri̱nggi̱ kana ca yo̱ ba yo̱ wu gi̱ra. ");
INSERT INTO wja_vpl VALUES ("CL1_19","081_1_19","COL","1","19","19","Yamba kasa kana ku Masiya yo̱o̱ ne̱re̱, yo̱ ci̱maci̱ma yi̱ Yamba a kana wo̱no̱ nyinou mwa, ");
INSERT INTO wja_vpl VALUES ("CL1_20","081_1_20","COL","1","20","20","pero a bo̱nggo̱ Masiya a si̱pa kana ca yi̱ yo̱, kana yi̱ri̱ tu si̱mai̱ yi̱ tu diyou, a de̱ pi̱dau̱ gaanggu̱ bo̱nggo̱ pargu̱ si̱yau̱ ti̱i̱ma ya a dwii ye̱u̱. ");
INSERT INTO wja_vpl VALUES ("CL1_21","081_1_21","COL","1","21","21","Doo, mba bu kwaara yi̱ Yamba, pero bu yo̱o̱gi̱ bace̱mba ya, di̱ngi̱n yi̱ri̱ngi̱ tu bwi̱i̱ tu bu ni̱ngai̱ pero bu danggai̱. ");
INSERT INTO wja_vpl VALUES ("CL1_22","081_1_22","COL","1","22","22","Anda yo̱ko̱ Yamba diini Masiya ba yo̱o̱ yi̱ bu̱ri̱ ci̱ka ne̱re̱ ba bwaa ba si̱pa mbi̱ra yi̱ bu̱ri̱ ye̱i̱, palaka bu ni̱nga walwal a gawu̱ri̱ ye̱i̱, yaa dire pero yaa we̱le̱ce̱u̱. ");
INSERT INTO wja_vpl VALUES ("CL1_23","081_1_23","COL","1","23","23","Anda bu ti̱i̱na le̱e̱gu̱ ji̱re̱i̱ mbu̱ru̱ cingcing, bu laamani̱ ya bo̱nggo̱ manam ni̱i̱ wu bu bo̱o̱ yi̱ to̱no̱ bo̱nggo̱ ci̱ye̱i̱ du teng. To̱o̱ ci̱ye̱i̱ du teng du bu nu̱wa, du nu̱wa wasi̱man kana we̱ a si̱ma, wu mi Bulus n yo̱o̱gi̱ ke̱we̱ n wasi̱ya. ");
INSERT INTO wja_vpl VALUES ("CL1_24","081_1_24","COL","1","24","24","N wo̱o̱ yi̱ bu̱ri̱ de̱gde̱g di̱ngi̱n ku̱u̱le̱ wu n ti̱i̱gu̱ di̱ngi̱n mba, pero n kasi̱ a bu̱ri̱ mi n twanga tu nyonai cu̱u̱nggi̱ ku̱u̱lu̱ Masiya di̱ngi̱n bu̱ri̱ ye̱i̱ su twii ikkilisiya. ");
INSERT INTO wja_vpl VALUES ("CL1_25","081_1_25","COL","1","25","25","Mi n yo̱o̱gi̱ ke̱we̱ ikkilisiya, di̱ngi̱n Yamba nyi̱i̱nggi̱ dingman yo̱ di̱ngi̱n mba, palaka n sambi̱ri̱ ci̱ye̱i̱ Yamba ci̱maci̱ma, ");
INSERT INTO wja_vpl VALUES ("CL1_26","081_1_26","COL","1","26","26","Ci̱ye̱i̱ Yambai̱ du n sagu̱mbi̱ru̱ do̱o̱, to̱o̱ tu tukugai yake̱ ba doo doo, anda yo̱ko̱ Yamba ju̱ki̱ nu̱wa ya. ");
INSERT INTO wja_vpl VALUES ("CL1_27","081_1_27","COL","1","27","27","A bo̱nggo̱ nu̱wa Yamba bwii, Yamba se̱ka ba ju̱ku̱ nyaau ku yi̱ yi̱lau̱ ku tukugau, a mi̱ri̱nggi̱ nu̱wa bu yaa yo̱o̱gi̱ nu̱wa bu Yudaya wa, wii Masiya a pi̱su̱ mi̱ri̱nggi̱ mbi̱ri̱, manam ni̱i̱u̱ wii yi̱lau̱. ");
INSERT INTO wja_vpl VALUES ("CL1_28","081_1_28","COL","1","28","28","Wii yo̱ yi wasi̱gu̱ ci̱ye̱i̱ a dwii ye̱i̱, yi ni̱ngaman kana we̱ di̱kace̱ne̱, ju̱ku̱gu̱ kana we̱ yi̱ so̱mandi̱ yiri mwa mwa, palaka yi de̱ kana we̱ bi̱i̱gi̱ a mi̱ri̱nggi̱ Masiya. ");
INSERT INTO wja_vpl VALUES ("CL1_29","081_1_29","COL","1","29","29","Di̱ngi̱n to̱no̱ n ni̱ngi̱ wu̱rai̱ yi̱ kwasan kwii, yi̱ di̱mbi̱r Masiya wu wu̱rai̱ mi̱ri̱nggi̱ mi. ");
INSERT INTO wja_vpl VALUES ("CL2_1","081_2_1","COL","2","1","1","To̱o̱ tu diina n kasi̱ bu so̱m kwasang kwiiu wu̱rai̱ du n ni̱nga di̱ngi̱n mba, pero yi̱ pma bu Laudikiya wa, yi̱ bu tii bu ko̱gu̱ mu wa. ");
INSERT INTO wja_vpl VALUES ("CL2_2","081_2_2","COL","2","2","2","N ni̱nga yi̱to̱ di̱ngi̱n n kasi̱ pma ba ciko bu̱ri̱ mi̱ri̱nggi̱ gaanggu̱ pero ba ne̱ca dwii mi̱ri̱nggi̱ kangam, palaka pma ba nyi̱ngga wuure, jo̱r du pma ku̱ranga pero pma le̱e̱ yi̱ ji̱re̱, pero ba so̱m tu tukugai tu Yambai̱, wu wii Masiya. ");
INSERT INTO wja_vpl VALUES ("CL2_3","081_2_3","COL","2","3","3","Yo̱ wu mwa mwa nyaau so̱mandi̱ yi ku̱randi̱ tukugi mi̱ri̱nggi̱ ye̱i̱. ");
INSERT INTO wja_vpl VALUES ("CL2_4","081_2_4","COL","2","4","4","N sagu̱mbi̱ru̱ to̱o̱ yi̱ri̱ngi̱ palaka kana we̱ ba we̱le̱ mbi̱r ya yi̱ ce̱wi̱ tu ci̱ka ji̱re̱ anda twii leendi. ");
INSERT INTO wja_vpl VALUES ("CL2_5","081_2_5","COL","2","5","5","Kana pu n yaa kem yi̱ mba mi̱ri̱nggi̱ bu̱ri̱ ne̱, anda n wo̱o̱ kem yi̱ mba mi̱ri̱nggi̱ bawei, pero n wo̱o̱ ni̱ngi̱ bu̱ri̱ de̱gde̱g ku n nu̱u̱ po̱ngo̱ndi̱ mbi̱ri̱ yi̱ pi̱tu̱ mbi̱ru̱ mi̱ri̱nggi̱ le̱e̱gu̱ ji̱re̱ bo̱nggo̱ Masiya. ");
INSERT INTO wja_vpl VALUES ("CL2_6","081_2_6","COL","2","6","6","Yake̱ ku bu le̱e̱ Masiya Yesu to̱o̱ Mbaa Wu Gi̱ra, bu ni̱nga pi̱su̱ naapu yi̱ yo̱ pero bu ni̱nga po̱ngo̱ndi̱ yi̱ yo̱. ");
INSERT INTO wja_vpl VALUES ("CL2_7","081_2_7","COL","2","7","7","Bu ru̱ swandi pero bu mo̱ bu̱ri̱ mi̱ri̱nggi̱ ye̱i̱, yi̱ pi̱tu̱ yi̱ di̱mbi̱re̱ mi̱ri̱nggu̱ le̱e̱gu̱ ji̱re̱ mbi̱ru̱ ci̱ka ku yi ju̱ku̱ mbi̱ra, bu ni̱nga pu wandi̱ma. ");
INSERT INTO wja_vpl VALUES ("CL2_8","081_2_8","COL","2","8","8","Bu ruun tu̱we̱ kana we̱ ba di̱i̱ mbi̱ri̱ ya bu ni̱nga po̱ngo̱ndi̱ yi̱ so̱mandi̱ tu nyoi, tu twii ciyendi yi̱ dangandi̱ nu̱wai̱. Tu pma ju̱ku̱gu̱ twii te̱e̱ri̱ngi̱ tu si̱mai̱ ti̱bak, twii tu Masiya ne̱. ");
INSERT INTO wja_vpl VALUES ("CL2_9","081_2_9","COL","2","9","9","Di̱ngi̱n a mi̱ri̱nggi̱ Masiya, Yamba ju̱ku̱ bu̱ri̱ ye̱i̱ ci̱maci̱ma yi̱ yo̱, ");
INSERT INTO wja_vpl VALUES ("CL2_10","081_2_10","COL","2","10","10","pero a bo̱nggo̱ naapu mbi̱ru̱ yi̱ Masiya, bu yo̱o̱ nu̱wa bu twanggi̱ wa, yo̱ wu je̱e̱gi̱ lau̱ dwii balaamba yi̱ dwii di̱mbi̱re̱ baweingi mwa mwa. ");
INSERT INTO wja_vpl VALUES ("CL2_11","081_2_11","COL","2","11","11","A bo̱nggo̱ naapu mbi̱ru̱ yi̱ yo̱, nu̱wa mwar mbi̱ri̱ gwane̱, twii mwargu̱ gwane̱ ku nu̱wa ni̱ngi̱ yi̱ wai ne̱ anda kwii ku Masiya. Yo̱ de̱ma mbi̱r ni̱ngandi̱ bu̱ri̱. ");
INSERT INTO wja_vpl VALUES ("CL2_12","081_2_12","COL","2","12","12","Jo̱r du nu̱wa ni̱ngambi̱ri̱ batisima a ni̱nga ci̱ka nu̱wa tin mbi̱ro̱ kem yi̱ Masiya, pero a jo̱r du nu̱wa wun mbi̱ro̱ batisima a ni̱nga ci̱ka bu wunongo kem yi̱ Masiya bo̱nggo̱ le̱e̱gu̱ ji̱re̱ mbi̱ru̱ yi̱ di̱mbi̱r Yamba, wu wun Masiya a bo̱o̱re̱. ");
INSERT INTO wja_vpl VALUES ("CL2_13","081_2_13","COL","2","13","13","Nang bu ci̱ka nu̱wa bu bwanggi wa di̱ngi̱n we̱le̱mdi̱ mbi̱ri̱, di̱ngi̱n gaanggu̱ mbi̱ru̱ twanggi̱ yi̱ we̱le̱mdi̱, anda Yamba nyi̱i̱mbi̱ri̱ pi̱i̱ma kem yi̱ Masiya, pero a para sukom we̱le̱mdi̱ yiri mwa mwa. ");
INSERT INTO wja_vpl VALUES ("CL2_14","081_2_14","COL","2","14","14","A de̱man si̱ye̱i̱ bali̱ su dwii yiri di̱ngi̱n dwal po̱ngo̱ndi̱ yi̱ te̱e̱ri̱ngi̱ nu̱wa bu Yudaya wa, Yamba de̱mana bo̱nggo̱ pi̱i̱nggu̱ ye̱u̱. ");
INSERT INTO wja_vpl VALUES ("CL2_15","081_2_15","COL","2","15","15","A gwala di̱mbi̱r baweingi yi̱ wu lau̱ri̱, a dwiiyanga pma me̱lma a gawu̱ri̱ nu̱wai̱, a gwala di̱mbi̱ri̱ pmo a dwii ye̱u̱ wii. ");
INSERT INTO wja_vpl VALUES ("CL2_16","081_2_16","COL","2","16","16","Di̱ngi̱n to̱no̱, bu le̱e̱ ya kana we̱ ba ko̱ mbi̱ra yi̱ we̱le̱m dwii yi̱ri̱ tu bu je̱i̱ kana tu bu nai, kana di̱ngi̱n bu yaa ni̱ngi̱ waandi su pma ni̱ngi̱, kana waandi pwalau ku pu̱cu̱ kana cwaagu̱ nyanggu̱ Sabadu. ");
INSERT INTO wja_vpl VALUES ("CL2_17","081_2_17","COL","2","17","17","To̱o̱ wekilei yi̱ri̱ngi̱ tu to̱o̱ baayi, anda Masiya wii yo̱ wu manggu. ");
INSERT INTO wja_vpl VALUES ("CL2_18","081_2_18","COL","2","18","18","Di̱ngi̱n to̱no̱, bu le̱e̱ ya kana we̱ ba dii mbi̱ra bu ni̱nga cingon dwii wu leendu, yi̱ ku̱raman si̱ma bacamandi, ka bu po̱ng tu pma ju̱ku̱gi̱ yaa ku bu ki̱nggu̱ we̱i̱ wo̱ri̱ri̱ tu Yamba ni̱nga mbi̱r alkawal. pma ce̱gu̱ ki̱n, pma ko̱ somdi a dwii to̱o̱ yi̱ri̱ngi̱ pero gaanggi̱ri̱ pmai tu bwii ciyeni pma ba gi̱ra dwii. ");
INSERT INTO wja_vpl VALUES ("CL2_19","081_2_19","COL","2","19","19","Ko̱o̱ duu nu̱wau̱ yaa naapu yi̱ Masiya, yo̱ wu twii dwii bu̱ri̱. Masiya wii yo̱ ne̱ca bu̱ri̱ swii mwa mwa ba yo̱o̱ tu tiinoi, ci̱ka ku penendi yi̱ ki̱ri̱ ne̱ca bu̱ri̱, ba gi̱ra ci̱ka ku Yamba kasu̱ gi̱ra̱u̱. ");
INSERT INTO wja_vpl VALUES ("CL2_20","081_2_20","COL","2","20","20","Yake̱ ku bwaanga kem yi̱ Masiya a pe̱ra mbi̱ra a bo̱nggo̱ po̱nggu̱ te̱e̱ri̱ng tu si̱mai̱, di̱ngi̱n ca karai kwii bu ni̱nggu̱ pi̱su̱ ci̱ka nu̱wa bu po̱ng te̱e̱ri̱ng tu si̱ma wa, ");
INSERT INTO wja_vpl VALUES ("CL2_21","081_2_21","COL","2","21","21","ci̱ka te̱e̱ri̱ngi̱ tu ce̱ ki̱n, <<Bu tari̱ ya! Bu ti̱i̱ ya! Bu mwani ya!>>? ");
INSERT INTO wja_vpl VALUES ("CL2_22","081_2_22","COL","2","22","22","To̱o̱ yi̱ri̱ngi̱ mwa mwa tagi̱ ba bwiiwa, di̱ngi̱n to̱o̱ te̱e̱ri̱ngi̱, yi̱ yi̱ri̱ngi̱ tu nu̱wa ju̱ku̱ri̱. ");
INSERT INTO wja_vpl VALUES ("CL2_23","081_2_23","COL","2","23","23","Pma dangandi̱ ki̱n to̱o̱ te̱e̱ri̱ngi̱ ju̱ku̱ri̱ pwii, diini pma ba ni̱nga kwasan kwiiu pala ba ju̱ku̱ya ki̱n pmai po̱nggu̱ Yamba ku di̱nggu̱, diini pma cingon dwii ku leendi, diini ba turongo bu̱ri̱ pmai wang, anda yaa di̱mbi̱re̱ ba ja pma tu̱mgu̱ ni̱ngandi̱ bu̱ri̱ tu bwii. ");
INSERT INTO wja_vpl VALUES ("CL3_1","081_3_1","COL","3","1","1","Yake̱ ku bu wunongo kem yi̱ Masiya, bu man ni̱i̱ a yi̱ri̱ngi̱ tu diyou, pu Masiya wo̱o̱ pi̱su̱ a pu yi̱lau̱ pu Yamba mi̱ru̱. ");
INSERT INTO wja_vpl VALUES ("CL3_2","081_3_2","COL","3","2","2","Bu ni̱nga dangandi̱ yi̱ri̱ngi̱ tu diyou, bu ni̱ngi̱ ya a dwii yi̱ri̱ngi̱ tu si̱mai̱. ");
INSERT INTO wja_vpl VALUES ("CL3_3","081_3_3","COL","3","3","3","Di̱ngi̱n bu bwaangi̱ mi̱ri̱nggi̱ ni̱nga bu̱ri̱, anda pi̱i̱ma mba tukugi kem yi̱ Masiya bo̱nggo̱ Yambau̱. ");
INSERT INTO wja_vpl VALUES ("CL3_4","081_3_4","COL","3","4","4","Nyanggu̱ ku Masiya yo̱ wu twii pi̱i̱ma mba baa, mba mwaasi̱ bu baanga we̱i̱ kem yi̱ yo̱ mi̱ri̱nggi̱ yi̱lau̱ yo̱u̱. ");
INSERT INTO wja_vpl VALUES ("CL3_5","081_3_5","COL","3","5","5","Di̱ngi̱n to̱no̱ bu lara kana to̱no̱ wu̱rang bu̱ri̱. Ba bu taari̱, pu̱si̱, miyandi, kasi̱gu̱ yi̱ri̱ngi̱ tu bwi̱i̱, yawo, wu twii ku̱raman si̱ma buwai. ");
INSERT INTO wja_vpl VALUES ("CL3_6","081_3_6","COL","3","6","6","Di̱ngi̱n so̱o̱ we̱le̱mdi̱ sukom Yambau̱ wo̱o̱ baayi dwii nu̱wa bu tu̱m to̱o̱ yi̱ri̱ngi̱ wa. ");
INSERT INTO wja_vpl VALUES ("CL3_7","081_3_7","COL","3","7","7","Nang kwii bu tu̱m to̱o̱ yi̱ri̱ngi̱, pu bu pi̱si̱ndi̱ mi̱ri̱nggi̱ bu̱ri̱. ");
INSERT INTO wja_vpl VALUES ("CL3_8","081_3_8","COL","3","8","8","Anda yo̱ko̱ bu lara to̱o̱ yi̱ri̱ngi̱, ba bu sukom, ce̱ne̱, ce̱re̱, bwiyanggu dinu, yi̱ ce̱wi̱ tu bwi̱i̱ a nyandi mbi̱ri̱. ");
INSERT INTO wja_vpl VALUES ("CL3_9","081_3_9","COL","3","9","9","Bu mwaramani̱ ya leendi bu̱ri̱ mbi̱ri̱, yake̱ ku bu du ni̱nga mbi̱ru̱ wu nang, ");
INSERT INTO wja_vpl VALUES ("CL3_10","081_3_10","COL","3","10","10","bu yo̱o̱ nu̱wa bu pu̱ci̱ wa, bu wakuwa, to̱o̱ bu̱ri̱ su pu̱ci̱ Yamba mwe̱, yo̱ waku̱gu̱ ba yo̱o̱ ci̱ka yo̱, palaka ba diina bu ku̱ranga yo̱ kundi. ");
INSERT INTO wja_vpl VALUES ("CL3_11","081_3_11","COL","3","11","11","yake̱ ku bu yo̱o̱ nu̱wa bu pu̱ci̱ wa, yo̱ko̱ yaa ne̱r wu Yudaya, kana ne̱r wu yaa yo̱o̱gi̱ ne̱r Yudaya, wu mwargi̱ gwane̱ yi̱ wu yaa mwargi̱ gwane̱, ru̱ngge̱, wu yaa pwi̱yagi̱, ke̱we̱ kana wu yaa yo̱o̱gi̱ ke̱we̱, anda Masiya wii yo̱ ne̱ca yiro mwa mwa. ");
INSERT INTO wja_vpl VALUES ("CL3_12","081_3_12","COL","3","12","12","Di̱ngi̱n to̱no̱, mba nu̱wa bu Yamba se̱ka wa, bu walwal bu kangni̱ wa, bu yo̱o̱ nu̱wa bu yi̱ bunam wa, nu̱wa bu yi̱ kalanggu̱ wa, yi̱ ci̱nggi̱ dwii wa, bu̱bu̱k wa pero yi̱ kanadi wa. ");
INSERT INTO wja_vpl VALUES ("CL3_13","081_3_13","COL","3","13","13","Bu ni̱nga kanadi yi̱ kana we̱, pero ka wu kanggi̱ bwi̱i̱ya mbi̱ri̱ gaanggu̱ bu paraman yo̱ sukom, bu par si̱ye̱i̱ sukom ci̱ka ku Mbaa Wu Gi̱ra par si̱ye̱i̱ sukom mbi̱ru̱. ");
INSERT INTO wja_vpl VALUES ("CL3_14","081_3_14","COL","3","14","14","Tu gwala mwa mwa bu ni̱nga kangam, di̱ngi̱n kangam wii yo̱ diini kana we̱ ba te̱ca dwii ku nyaau. ");
INSERT INTO wja_vpl VALUES ("CL3_15","081_3_15","COL","3","15","15","Yama pi̱dau̱ gaanggu̱ wu bo̱nggo̱ Masiya ba je̱e̱ lau̱ a gaanggi̱ri̱ mbi̱ri̱, yake̱ ku bu yo̱o̱gi̱ ne̱r wiino, Yamba yi̱ mbi̱ra di̱ngi̱n pi̱dau̱ gaanggu̱. Bu yo̱o̱ nu̱wa bu yi̱ wandi̱ma wa. ");
INSERT INTO wja_vpl VALUES ("CL3_16","081_3_16","COL","3","16","16","Yama ci̱ye̱i̱ Masiya ba si̱i̱na gaanggu̱ mbi̱ru̱ kana do̱no̱ jo̱re̱, bu pi̱r bu̱ri̱ mbi̱ri̱, bu ni̱ngaman bu̱ri̱ mbi̱ri̱ di̱kace̱ne̱ yi̱ pwii wang, bu pi̱i̱ pi̱i̱ lakargar pi̱i̱yangi̱, yi̱ pi̱i̱yangi̱ te̱re̱nggu̱ Yambai̱, yi̱ pi̱yangi̱ Bawei, yi̱ wandi̱ma bo̱nggo̱ Yamba mi̱ri̱nggi̱ gaanggi̱ri̱ mbi̱ri̱. ");
INSERT INTO wja_vpl VALUES ("CL3_17","081_3_17","COL","3","17","17","Kana ca tu bu ni̱ng we̱i̱ kana bo̱nggo̱ ce̱gu̱ ci̱ye̱i̱ kana bo̱nggo̱ ni̱ngu̱, bu ni̱nga tu nu̱wa bu po̱nggu̱ Mbaa Wu Gi̱ra Yesu ni̱ngi̱, bu wananga Yamba Kwiite a bo̱nggo̱ Masiya. ");
INSERT INTO wja_vpl VALUES ("CL3_18","081_3_18","COL","3","18","18","Nu̱ru̱mba, bu ni̱nga po̱ngo̱ndi̱ yi̱ bwi̱yamba mba ci̱ka ku daaya nu̱wa bu po̱nggu̱wa ba ni̱nga. ");
INSERT INTO wja_vpl VALUES ("CL3_19","081_3_19","COL","3","19","19","Bwiyamba, bu kangman nu̱ru̱mba mba, bu ni̱ngamani̱ ya pma ce̱ne̱. ");
INSERT INTO wja_vpl VALUES ("CL3_20","081_3_20","COL","3","20","20","Kwaraa, bu ni̱nga po̱ngo̱ndi̱ yi̱ kwiimba mba mi̱ri̱nggi̱ kana ca, di̱ngi̱n to̱o̱ tu di̱raman gaanggu̱ Mbaa Wu Gi̱ra. ");
INSERT INTO wja_vpl VALUES ("CL3_21","081_3_21","COL","3","21","21","Kwiimba, bu bwiyamani ya gaanggi̱ri̱ kwaraa mba, dakali gaanggi̱ri̱ pmai ba yara. ");
INSERT INTO wja_vpl VALUES ("CL3_22","081_3_22","COL","3","22","22","Ke̱waa, bu ni̱nga po̱ngo̱ndi̱ yi̱ bagi̱raa mba mi̱ri̱nggi̱ kana ca, bu ni̱ngi̱ ya a nundi pmai ti̱bak, ci̱ka ku nu̱wa bu kangga ni̱ngi̱ di̱ngi̱n nu̱wa ba wandi̱ pma, anda bu ni̱nga yi̱ gaanggu̱ kiino bu nyi̱i̱gu̱ gi̱ru̱ Mbaa Wu Gi̱ra. ");
INSERT INTO wja_vpl VALUES ("CL3_23","081_3_23","COL","3","23","23","Kana ca tu bu ni̱ng we̱i̱, bu ni̱nga yi̱ gaanggu̱ mbi̱ru̱ mwa mwa ci̱ka ku bu ni̱ngaman Mbaa Wu Gi̱ra, anda ne̱ri̱ ne̱, ");
INSERT INTO wja_vpl VALUES ("CL3_24","081_3_24","COL","3","24","24","di̱ngi̱n bu so̱ma bu yi̱ru̱ we̱i̱ wo̱ri̱ri̱ tu Mbaa Wu Gi̱ra ruuman nu̱wa ya. Di̱ngi̱n Mbaa Wu Gi̱ra Masiya wii yo̱ bu ni̱ngaman yo̱ wu̱rai̱. ");
INSERT INTO wja_vpl VALUES ("CL3_25","081_3_25","COL","3","25","25","Kana we̱ wu ni̱nga tu yaa kundi yi̱ru̱ we̱i̱ wo̱ri̱ri̱ tu yaa kundi, Yamba yaa se̱ki̱. ");
INSERT INTO wja_vpl VALUES ("CL4_1","081_4_1","COL","4","1","1","Bagi̱raa, bu ni̱ngaman ke̱waa mba tu daayaci̱maci̱ma, di̱ngi̱n bu so̱ma mi̱n mba mwaasi̱ bagi̱ra mbi̱r wo̱o̱ diyou. ");
INSERT INTO wja_vpl VALUES ("CL4_2","081_4_2","COL","4","2","2","Bu kwasi̱ kwi̱i̱ ce̱gu̱ ku̱ru̱ kem yi̱ ru̱u̱nggu̱ tu̱we̱ yi̱ wandi̱ma. ");
INSERT INTO wja_vpl VALUES ("CL4_3","081_4_3","COL","4","3","3","Pero bu ce̱ yir ku̱ru̱, Yamba ba wun yiri nyinou yi wasi̱ ci̱ye̱i̱ ye̱i̱, palaka yi wasi̱ ci̱ye̱i̱ du tukugai a dwii Kristo du nu̱wa twalangge̱ di̱ngi̱n to̱no̱i̱. ");
INSERT INTO wja_vpl VALUES ("CL4_4","081_4_4","COL","4","4","4","Bu ce̱ ku̱ru̱ n wasi̱ya kundi ci̱ka ku daayau̱ n ni̱nga. ");
INSERT INTO wja_vpl VALUES ("CL4_5","081_4_5","COL","4","5","5","Bu si̱ndi̱ si̱yandi̱ yi̱ pwii cu̱di̱ nu̱wa bu yaa po̱nggu̱ wa, bu ni̱nga wu̱rai̱ yi̱ jo̱re̱ du bu nyi̱ngai̱. ");
INSERT INTO wja_vpl VALUES ("CL4_6","081_4_6","COL","4","6","6","Yama ce̱wi̱ mbi̱ri̱ ba yo̱o̱ tu yi̱ kalanggu̱ pero teng kana do̱no̱ jo̱re̱, palaka bu puu nyi̱i̱gu̱ le̱e̱ wu daaya kana we̱ wu ni̱nga mbi̱r pi̱ra. ");
INSERT INTO wja_vpl VALUES ("CL4_7","081_4_7","COL","4","7","7","Bago̱n yire Tikikus wu yi̱ kangne̱, wu ni̱ngi̱ wu̱rai̱ Masiya yi̱ ji̱re̱ basi̱n wu̱rai̱ yire mi̱ri̱nggi̱ Mbaa Wu Gi̱ra, sa mbi̱ru̱ we̱i̱ kana ca a dwii mi. ");
INSERT INTO wja_vpl VALUES ("CL4_8","081_4_8","COL","4","8","8","N wo̱o̱ tu̱m yo̱ bo̱nggo̱ mbi̱ru̱ palaka ba sa mbi̱r tu yi mi̱ri̱ pero ba ci̱ko̱ gaanggi̱ri̱ mbi̱ra. ");
INSERT INTO wja_vpl VALUES ("CL4_9","081_4_9","COL","4","9","9","Baa we̱i̱ kem yi̱ Onisimus bago̱n yire wu yi kangne̱ wu yi̱ ji̱re̱, yo̱ wu twii bago̱n mbi̱re̱. Pma sa mbi̱ru̱ kana ca tu pi̱nai̱. ");
INSERT INTO wja_vpl VALUES ("CL4_10","081_4_10","COL","4","10","10","Bago̱n mi Aristakus wu wo̱o̱ jaru̱m wo̱o̱ ci̱gu̱ mbi̱ru̱ yi̱ Markus wu kaka pmo kiino yi̱ Barnabas wo̱o̱ ci̱gu̱ mbi̱ru̱ mwaasi̱. Wii yo̱ wu n sa mbi̱r ci̱ye̱i̱ a dwii ye̱i̱ mi̱n, ka baayi bu yi̱ya wari̱ ro̱p. ");
INSERT INTO wja_vpl VALUES ("CL4_11","081_4_11","COL","4","11","11","Jocuwa wu nu̱wa yi̱r ki̱n Yustus wo̱o̱ ci̱gu̱ mbi̱ru̱ mwaasi̱. Bo̱o̱ nu̱wa bu kunong bo̱o̱ a ni̱nggu̱ wu̱rai̱ Lau̱ Yambau̱ kem yi̱ mi a cu̱di̱ nu̱wa Yudaya bu po̱nggu̱ wa, pma ci̱ngo̱ngi̱n gaanggu̱. ");
INSERT INTO wja_vpl VALUES ("CL4_12","081_4_12","COL","4","12","12","Abaparas ke̱we̱ Masiya Yesu yo̱ wu twii bago̱n mbi̱ri̱, wo̱o̱ ci̱gu̱ mbi̱ru̱. Wo̱o̱ ce̱gu̱ ku̱ru̱ yi̱ kwasam kwiiu di̱ngi̱n mba, palaka bu ti̱ndi̱ ti̱ye̱i̱ yi̱ di̱mbi̱re̱ a mi̱ri̱nggi̱ tu Yamba kasi̱ bu ni̱ngai̱ mwa mwa, bu si̱ya twanggi̱ pero bu yo̱o̱ yi̱ ku̱randi̱ tu manggu. ");
INSERT INTO wja_vpl VALUES ("CL4_13","081_4_13","COL","4","13","13","N kasi̱ n sambi̱ra manggu a ni̱nga wu̱rai̱ wang di̱ngi̱n mba yi̱ nu̱wa bu gwe̱i̱ Laudikiya wa yi̱ bu gwe̱i̱ Hirapolis wa. ");
INSERT INTO wja_vpl VALUES ("CL4_14","081_4_14","COL","4","14","14","Luka wu yi̱ kangne̱, ne̱re̱ wu pu nyinou yi̱ Dimas wo̱o̱ ci̱gu̱ mbi̱ru̱. ");
INSERT INTO wja_vpl VALUES ("CL4_15","081_4_15","COL","4","15","15","Bu lam ci̱i̱ma muwa, ci̱yamba bu Laudikiya wa, yi̱ Nimpa yi̱ ikkilisiya wu laa yo̱u̱. ");
INSERT INTO wja_vpl VALUES ("CL4_16","081_4_16","COL","4","16","16","Go̱ro̱ pu bu ce̱ lakargar wo̱o̱ a cu̱di̱ mbi̱ri̱, bu tu̱mman nu̱wa bu po̱nggu̱ bu gwe̱i̱ Laudikiya ba ce̱ mwa, pero bu ce̱ wu nu̱wa tu̱mman nu̱wa bu . ");
INSERT INTO wja_vpl VALUES ("CL4_17","081_4_17","COL","4","17","17","Bu sa Arkipus mi̱n, <<Ba kwasi̱ kwii ma mata wu̱rai̱ du Mbaa Wu Gi̱ra nyi̱i̱ mi̱nai̱>>. ");
INSERT INTO wja_vpl VALUES ("CL4_18","081_4_18","COL","4","18","18","Mi Bulus, n wo̱o̱ bala mbi̱ri̱ bi̱naa ci̱i̱ma yi̱ wai mu, bu dangga mi mi̱ri̱nggi̱ cali, bo̱o̱ ni̱i̱ Yambau̱ ba si̱ya kem yi̱ mba.");
INSERT INTO wja_vpl VALUES ("H11_1","082_1_1","1TH","1","1","1","Wunaa lakargar twiiwe bo̱nggo̱ Bulus yi̱ Silas yi̱ Timoti, aari bo̱nggo̱ nu̱wa bu po̱nggu̱ Yesu wa bu gwe̱i̱ Tasalonika bu Yamba Kwiite yi̱ Mbaa wu Gi̱ra Yesu Masiya. Bo̱o̱ ni̱i̱u̱ yi̱ pi̱dau̱ gaanggu̱ ba si̱ya kem yi̱ mba. ");
INSERT INTO wja_vpl VALUES ("H11_2","082_1_2","1TH","1","2","2","Yi wanan Yamba kana pe̱ne̱ pe̱ne̱ di̱ngi̱n mwa mwa mbi̱ru̱ pero yi bo̱o̱ ce̱ ku̱ru̱ nyi̱ki̱ri̱k di̱ngi̱n mba. ");
INSERT INTO wja_vpl VALUES ("H11_3","082_1_3","1TH","1","3","3","Yi bo̱o̱ danggi̱mbi̱ri̱ a gawu̱ri̱ Yamba yire yi̱ Mbaa yire, wu̱rangi̱ mbi̱ri̱ tu bo̱nggo̱ le̱e̱gu̱ ji̱re̱, yi̱ wu̱rangi̱ kangam mbi̱ru̱ tu bu ni̱nggi̱, yi̱ bo̱gu̱ gaanggu̱ mbi̱ru̱ bo̱nggo̱ manam ni̱i̱u̱ mbi̱ru̱ mi̱ri̱nggi̱ Mbaa Wu Gi̱ra Yesu Masiya. ");
INSERT INTO wja_vpl VALUES ("H11_4","082_1_4","1TH","1","4","4","Ci̱yamba muwa bu Yamba kangman pma wa, yi so̱ma mi̱n Yamba se̱kambi̱ra bu yo̱o̱ nu̱wa ya, ");
INSERT INTO wja_vpl VALUES ("H11_5","082_1_5","1TH","1","5","5","di̱ngi̱n ci̱ye̱i̱ du teng du yi de̱mbu̱we̱ yaa bo̱nggo̱ be̱ne̱ ti̱bak, anda bo̱nggo̱ di̱mbi̱re̱, yi̱ Bawei du Walwal, yi̱ le̱e̱gu̱ mi̱ri̱nggu̱ gaanggu̱ ju̱ngu̱lo̱ng. Bu so̱ma yi̱ duu pi̱su̱ wu yi ni̱nga a cu̱du̱ mbi̱ri̱ di̱ngi̱n mba. ");
INSERT INTO wja_vpl VALUES ("H11_6","082_1_6","1TH","1","6","6","Bu ti̱la yiro yi̱ Mbaa wu̱ Gi̱ra, di̱ngi̱n bu le̱e̱ ci̱ye̱i̱ Yambai̱ mi̱ri̱ngi̱ ti̱i̱gu̱ ku̱u̱le̱ yi̱ bu̱r de̱gde̱g bo̱nggo̱ Bawei du Walwal. ");
INSERT INTO wja_vpl VALUES ("H11_7","082_1_7","1TH","1","7","7","Di̱ngi̱n to̱no̱ bu yo̱o̱ nu̱wa bu, nu̱wa bu le̱e̱ ji̱re̱ wa mwa mwa, ti̱lanu̱ we̱i̱ ni̱nga mbi̱re̱ a si̱ma Makidoniya yi̱ si̱ma Akaya wa. ");
INSERT INTO wja_vpl VALUES ("H11_8","082_1_8","1TH","1","8","8","Ci̱ye̱i̱ Mbaa wu Gi̱ra wasi̱ bu̱ri̱ bo̱nggo̱ mbi̱re̱, yaa Makidoniya yi̱ Akaya yi̱ wundu anda le̱e̱gu̱ ji̱re̱ mbi̱ru̱ bo̱nggo̱ Ci̱ye̱i̱ Mbaa wu Gi̱ra a lama kana pi̱yau̱. Di̱ngi̱n to̱no̱ yaa tu yi ce̱ we̱i̱ a dwii le̱e̱gu̱ ji̱re̱ mbi̱ru̱, ");
INSERT INTO wja_vpl VALUES ("H11_9","082_1_9","1TH","1","9","9","di̱ngi̱n pma ce̱ ci̱ye̱i̱ dwii kanda ku bu yi̱ yiro. Pma sa yiro kanda ku bu le̱e̱ ji̱re̱ yi̱ Yamba, bu kwaa buwangi, bu ku̱raman si̱ma Yamba wu manggu pero yi̱ pi̱i̱ma, ");
INSERT INTO wja_vpl VALUES ("H11_10","082_1_10","1TH","1","10","10","pero bu yamgu Bo̱l yo̱ wu baa we̱i̱ diyou Yambau̱, Yesu wu yo̱ wun yo̱ bo̱o̱re̱, wu mi̱ra yiro bo̱nggo̱ sukom Yamba wu wo̱o̱ bagu̱. ");
INSERT INTO wja_vpl VALUES ("H12_1","082_2_1","1TH","2","1","1","Ci̱yamba, mba yi̱ri̱ mbi̱ri̱ bu so̱ma mi̱n bagu̱ yiru bo̱nggo̱ mbi̱ru̱ yaa ku̱ si̱ya nyo. ");
INSERT INTO wja_vpl VALUES ("H12_2","082_2_2","1TH","2","2","2","Kana ku diwo yo̱u̱, nu̱wa pu yiri ku̱u̱le̱ yi̱ rwe̱e̱ndi̱ a Pilipi ci̱ka ku bu so̱mau̱, yi̱ kalanggu̱ Yamba yire, yi wasi̱mbi̱ri̱ ci̱ye̱i̱ du teng a cu̱du̱ kwaangi̱ wang. ");
INSERT INTO wja_vpl VALUES ("H12_3","082_2_3","1TH","2","3","3","Di̱ngi̱n ci̱ye̱i̱ Yambai̱ du yi wasi̱mbi̱rai̱ yaa mi̱ri̱nggi̱ dwii li̱yari̱, yaa bo̱nggo̱ dangandi̱ yiri tu bwi̱i̱, pero yi yaa ci̱ye̱ngu̱mbi̱ru̱. ");
INSERT INTO wja_vpl VALUES ("H12_4","082_2_4","1TH","2","4","4","Anda yi wasi̱gu̱ ci̱ka nu̱wa bu Yamba le̱e̱ yi̱ pma wa, pero a nyi̱i̱ pma di̱ngi̱man wasi̱gu̱ ci̱ye̱i̱ du teng. Yi yaa kasu̱gu̱ yi di̱raman gaanggu̱ nu̱wa anda yi kasi̱ yi di̱raman gaanggu̱ Yamba, yo̱ wu cu̱u̱ tu gaanggi̱. ");
INSERT INTO wja_vpl VALUES ("H12_5","082_2_5","1TH","2","5","5","Bu so̱ma yaa ku yi ce̱ ci̱ye̱i̱ yi̱ be̱ne̱ du teng, yaa ku yi ce̱ ci̱ye̱i̱ yi tuko yawo yire. Yamba yo̱o̱gi̱ se̱e̱daki̱ yire. ");
INSERT INTO wja_vpl VALUES ("H12_6","082_2_6","1TH","2","6","6","Yi yaa kasu̱gu̱ nu̱wa ba wandiyiro, kana bo̱nggo̱ mbi̱ru̱ kana bo̱nggo̱ we̱u̱, na yi kasu̱gu̱ we̱i̱, na ni̱nga wu̱rai̱ yi̱ gi̱ru̱ yiru ku nu̱wa tu̱mandi̱ bu Masiya wa, na yi kasa kalanggu̱. ");
INSERT INTO wja_vpl VALUES ("H12_7","082_2_7","1TH","2","7","7","Anda yi yo̱o̱ nu̱wa bu yi̱ kanadi wa a bo̱nggo̱ mbi̱ru̱, ci̱ka ku njaate̱ swe̱ri̱ kwaraa ya, yi swe̱rambi̱ra yi̱to̱. ");
INSERT INTO wja_vpl VALUES ("H12_8","082_2_8","1TH","2","8","8","Di̱ngi̱n yi kangmbi̱ri̱ wang, yi ni̱nga bu̱r de̱gde̱g yi wasi̱mbi̱ri̱ ci̱ye̱i̱ du teng du Yambai̱, bur to̱o̱ ne̱ anda yi nyi̱i̱ pi̱i̱ma yuwa di̱ngi̱n mba, di̱ngi̱n bu bo̱o̱ gaanggu̱ yiru. ");
INSERT INTO wja_vpl VALUES ("H12_9","082_2_9","1TH","2","9","9","Ci̱yamba, yi kasi̱ bu dangga yi̱ wu̱rai̱ yi̱ ku̱u̱le̱ wu yi bo̱o̱ ti̱i̱gu̱ ku̱me̱ yi̱ nyanggu̱ di̱ngi̱n wasi̱gu̱ ci̱ye̱i̱ Yambai̱ du teng dakali yi yo̱o̱mbi̱ri̱ dingman. ");
INSERT INTO wja_vpl VALUES ("H12_10","082_2_10","1TH","2","10","10","Bu yo̱o̱gi̱ se̱e̱daki̱, yi̱to̱ mwaasi̱ a bo̱nggo̱ Yambau̱, kanda ku yi ni̱nga pi̱su̱ wu walwal yi̱ tu̱mgu̱ tu nyaayi pero yaa we̱le̱ce̱u̱, a cu̱du̱ mbi̱ri̱ bu le̱e̱ ji̱re̱ wa. ");
INSERT INTO wja_vpl VALUES ("H12_11","082_2_11","1TH","2","11","11","Ci̱ka ku bu so̱mau̱ yi ni̱ngaman kana wo̱no̱ mbi̱re̱ ci̱ka ku kwiite ni̱ngaman kwaraa ya. ");
INSERT INTO wja_vpl VALUES ("H12_12","082_2_12","1TH","2","12","12","Yi ci̱ko̱mbi̱ra, yi do̱rambi̱ri̱ gaanggu̱ pero yi senggombi̱ra bu ni̱nga pi̱su̱ wu daaya gawu̱ri̱ Yambai̱, yo̱ wu yi̱mbi̱ra mi̱ri̱ngi̱ lau̱ yo̱u̱ yi̱ yi̱la yo̱u̱. ");
INSERT INTO wja_vpl VALUES ("H12_13","082_2_13","1TH","2","13","13","Pero yi bo̱o̱ wanani̱ Yamba kana pe̱ne̱, di̱ngi̱n a jo̱r du̱ bu le̱e̱ yi̱ ci̱ye̱i̱ Yambai̱ du bu nu̱u̱gu̱ bo̱nggo̱ yiru do̱o̱, yaa ku̱ bu le̱e̱ ci̱ka to̱o̱ ci̱ye̱i̱ ne̱ri̱, anda bu le̱e̱ manggu to̱o̱ ci̱ye̱i̱ Yambai̱, du di̱nggu̱ du wu̱rai̱ bo̱nggo̱ mba bu le̱e̱ ji̱re̱ wa. ");
INSERT INTO wja_vpl VALUES ("H12_14","082_2_14","1TH","2","14","14","Ci̱yamba, bu yo̱o̱ nu̱wa bu ti̱langgu̱ nu̱wa bu po̱nggu̱ Yamba wa a si̱ma Yudaya wa bu mi̱ri̱nggi̱ Masiya Yesu, bu ti̱i̱ ku̱u̱le̱ a bo̱nggo̱ nu̱wa mba ci̱ka ku̱ nu̱wa bwii ti̱i̱ ku̱u̱le̱ bo̱nggo̱ nu̱wa Yudaya wa. ");
INSERT INTO wja_vpl VALUES ("H12_15","082_2_15","1TH","2","15","15","Pma ji Mbaa Wu gi̱ra Yesu yi̱ banabi̱ndi̱ pero a ke̱e̱ yiro. Pma bwiyaman gaanggu̱ Yamba wang, pma ni̱nggu̱ ce̱re̱ yi̱ kana we̱. ");
INSERT INTO wja_vpl VALUES ("H12_16","082_2_16","1TH","2","16","16","Pma kwasu̱gu̱ kwi̱i̱ ba ja yire ce̱gu̱ ci̱ye̱i̱ yi̱ nu̱wa bu yaa yo̱o̱gi̱ nu̱wa bu Yudaya wa palaka ba yi̱lani̱ya. A bo̱nggo̱ ni̱nggu̱ yi̱to̱ pma gamaman bu̱ri̱ pmai we̱le̱mdi̱. Anda sukom Yambau̱ gi̱ci̱la juluman pma. ");
INSERT INTO wja_vpl VALUES ("H12_17","082_2_17","1TH","2","17","17","Ci̱yamba, jo̱r du̱ yi cwaanga bu̱ri̱ yi̱ mba nyan jo̱re̱ banyi̱na, a bu̱ri̱ ti̱bak anda dangandi̱ yiri to̱o̱ kem yi̱ mba, yi kasi̱gu̱ pero yi kwasi̱gu̱ kwiiu yi ko̱mbi̱ra nunge yi̱ nunge. ");
INSERT INTO wja_vpl VALUES ("H12_18","082_2_18","1TH","2","18","18","Yi kasa bagu̱ bo̱nggo̱ mbi̱ru̱, mi Bulus n ni̱nga pu kasu̱gu̱ bagu̱ yaa daa kiino anda Balaa Buwai laka nyinou. ");
INSERT INTO wja_vpl VALUES ("H12_19","082_2_19","1TH","2","19","19","Di̱ngi̱n manam ni̱i̱ yiru, yi̱ di̱rang gaanggu̱ yiru yi̱ me̱tu̱wal go̱rso̱ndi̱ a bo̱nggo̱ Mbaa wu Gi̱ra Yesu nyanggu̱ ku baa we̱i̱, bwii mba ne̱ ru? ");
INSERT INTO wja_vpl VALUES ("H12_20","082_2_20","1TH","2","20","20","Ku ji̱re̱u̱, go̱rso̱ndi̱ yi̱ di̱rang gaanggu̱ yiru bwii mba. ");
INSERT INTO wja_vpl VALUES ("H13_1","082_3_1","1TH","3","1","1","Di̱ngi̱n to̱no̱ yaa ku yi pu bo̱gu̱ gaanggu̱, yi ko̱ a gwala yi si̱ndi̱ si̱ye̱i̱ a gwe̱i̱ Atina yo wundu yiru. ");
INSERT INTO wja_vpl VALUES ("H13_2","082_3_2","1TH","3","2","2","Yi tu̱m Timoti bago̱n yire yi̱ basi̱n yire a wu̱rai̱ Yambai̱ mi̱ri̱nggi̱ wasu̱gu̱ ci̱ye̱i̱ du teng du Masiya. Yi tu̱ma ba cwatambi̱ri̱ di̱mbi̱re̱ pero ba ci̱ko̱mbi̱ra mi̱ri̱nggi̱ le̱e̱gu̱ ji̱re̱u̱, ");
INSERT INTO wja_vpl VALUES ("H13_3","082_3_3","1TH","3","3","3","palaka kana we̱ gaanggu̱ yo̱u̱ ba yari̱ya di̱ngi̱n ku̱u̱le̱. Anda mba yi̱ri̱ mbi̱ri̱ bu so̱ma mi̱n to̱o̱ tu dwii yiri. ");
INSERT INTO wja_vpl VALUES ("H13_4","082_3_4","1TH","3","4","4","Ku ji̱re̱u̱, pu yi bo̱o̱ kem yi̱ mba, yi gi̱ci̱la yi sambi̱ra mi̱n, yi ti̱i̱ we̱i̱ ku̱u̱le̱. Manggu a ni̱ngwa yitwii ci̱ka ku bu so̱mau̱. ");
INSERT INTO wja_vpl VALUES ("H13_5","082_3_5","1TH","3","5","5","Di̱ngi̱n to̱no̱, n jaanga bo̱gu̱ gaanggu̱ kana banyi̱na, n tu̱ma mi̱n n nu̱u̱ labar le̱e̱gu̱ ji̱re̱ mbi̱ru̱. N nu̱u̱gu̱ gwasu̱ ko̱ mwa Balaa Buwai ba te̱e̱mbi̱ra miyandi, bu yaranga, wu̱rai̱ yiri ba si̱ya nyo. ");
INSERT INTO wja_vpl VALUES ("H13_6","082_3_6","1TH","3","6","6","Anda yo̱ko̱ Timoti waata bu̱ri̱ bo̱nggo̱ mbi̱re̱, a de̱ yiwe ci̱ye̱i̱ du teng dwii le̱e̱gu̱ ji̱re̱u̱ yi̱ kangam mbi̱ru̱. Pero a sayiro ki̱n bu bo̱o̱ yi̱ dangandi̱ tu nyaayi a dwii yiri, pero bu kasi̱ bu ko̱yiro, ci̱ka ku yo mwa yi kasi̱gu̱ yi ko̱mbi̱ra. ");
INSERT INTO wja_vpl VALUES ("H13_7","082_3_7","1TH","3","7","7","Di̱ngi̱n to̱no̱ ci̱yamba, le̱e̱gu̱ ji̱re̱ mbi̱ru̱ a ci̱ko̱yiro mi̱ri̱nggi̱ mwa mwa tu̱ro̱m yi̱ ku̱u̱le̱ wu yi bo̱o̱ mi̱ri̱. ");
INSERT INTO wja_vpl VALUES ("H13_8","082_3_8","1TH","3","8","8","Yo̱ko̱ me̱re̱, yi para bu̱ri̱ yake̱ ku̱ bu ti̱ndi̱ ti̱ye̱i̱ yi̱ di̱mbi̱re̱ mi̱ri̱nggi̱ Mbaa wu Gi̱ra. ");
INSERT INTO wja_vpl VALUES ("H13_9","082_3_9","1TH","3","9","9","Wandi̱ma ya ca bu yi ni̱ngamanu̱ we̱i̱ Yamba, a dwii di̱ran gaanggu̱ yiru a gawu̱ri̱ Yambai̱ di̱ngi̱n mba? ");
INSERT INTO wja_vpl VALUES ("H13_10","082_3_10","1TH","3","10","10","Ku̱me̱ yi̱ nyanggu̱ yi kwasi̱gu̱ kwiiu ce̱gu̱ ku̱ru̱ yi ko̱mbi̱ra kau yi̱ kau, yi kalambi̱ra pu bu dwalanggi̱ mi̱ri̱nggi̱ le̱e̱gu̱ ji̱re̱ mbi̱ru̱. ");
INSERT INTO wja_vpl VALUES ("H13_11","082_3_11","1TH","3","11","11","Yama Yamba Mbaa yire yo̱ yi̱ri̱ ye̱i̱ yi̱ Mbaa Wu Gi̱ra Yesu ba caryiri nyinou yi baanga bo̱nggo̱ mbi̱ru̱. ");
INSERT INTO wja_vpl VALUES ("H13_12","082_3_12","1TH","3","12","12","Yama Mbaa wu Gi̱ra ba cwatambi̱ri̱ kangam wang dwii kana wo̱no̱ mbi̱re̱ yi̱ nu̱wa mwa mwa, ci̱ka ku yi ni̱ngambi̱rau̱. ");
INSERT INTO wja_vpl VALUES ("H13_13","082_3_13","1TH","3","13","13","Yama ba ci̱ko̱ gaanggi̱ri̱ mbi̱ri̱ bu ni̱nga pi̱su̱ wu walwal, bu yo̱o̱ yaa we̱le̱m a gawu̱ri̱ Yamba yire yi̱ Mbaa yire, ko̱po̱ nyanggu̱ ku Mbaa wu Gi̱ra Yesu baa we̱i̱ kem yi̱ mwa mwa nu̱wa bu bwii bo̱ya wa. ");
INSERT INTO wja_vpl VALUES ("H14_1","082_4_1","1TH","4","1","1","Di̱ngi̱n to̱no̱ tu cwata go̱ro̱u̱, ci̱yamba, yi senggumbi̱ru̱ pero yi bo̱o̱ ci̱ku̱gu̱mbi̱ru̱ di̱ngi̱n Mbaa wu Gi̱ra Yesu, bu ni̱nga pi̱su̱ wu nyaau, pi̱su̱ wu di̱ramanu̱ we̱i̱ gaanggu̱ Yamba, ci̱ka ku bu ti̱langa bo̱nggo̱ yiru. Kana ku bu bo̱o̱ ni̱nggu̱ pi̱su̱ yi̱to̱, bu kwasi̱ kwi̱i̱ bu ni̱nga yi̱to̱. ");
INSERT INTO wja_vpl VALUES ("H14_2","082_4_2","1TH","4","2","2","Bu so̱ma ci̱ye̱i̱ du yi sagu̱mbi̱ru̱ a bo̱nggo̱ Mbaa Wu Gi̱ra Yesu. ");
INSERT INTO wja_vpl VALUES ("H14_3","082_4_3","1TH","4","3","3","Yamba kasi̱ bu ni̱nga walwal. Di̱ngi̱n to̱no̱ bu cwaa kana ko̱no̱ duu taari̱. ");
INSERT INTO wja_vpl VALUES ("H14_4","082_4_4","1TH","4","4","4","Kana we̱ ba so̱m kanda ku si̱i̱ we̱i̱ kem yi̱ nu̱r yo̱ walwal yi̱ nyi̱i̱gu̱ gi̱ru̱, ");
INSERT INTO wja_vpl VALUES ("H14_5","082_4_5","1TH","4","5","5","yaa miyandi taari̱ ci̱ka ku nu̱wa bu so̱mbu̱ Yamba wa ni̱ngu̱. ");
INSERT INTO wja_vpl VALUES ("H14_6","082_4_6","1TH","4","6","6","Kana we̱ ba ni̱ngamani̱ya bago̱n yo̱ tu̱we̱, kana ba ni̱ngaman yo̱ yi̱ri̱ ci̱ka to̱o̱. Mbaa wu Gi̱ra ni̱ngamanu̱ we̱i̱ bali̱ nu̱wa bu tu̱m to̱o̱ yi̱ri̱ng, ci̱ka ku̱ yi sambi̱ra gawu̱ri̱yo̱, pero yi ni̱ngambi̱ri̱ di̱kace̱ne̱. ");
INSERT INTO wja_vpl VALUES ("H14_7","082_4_7","1TH","4","7","7","Di̱ngi̱n Yamba yi̱yirubu ki̱n yi ni̱nga pu̱si̱ anda ki̱n yi ni̱nga pi̱su̱ wu walwal. ");
INSERT INTO wja_vpl VALUES ("H14_8","082_4_8","1TH","4","8","8","Di̱ngi̱n to̱no̱, kana we̱ wu kwaa do̱o̱ ci̱ye̱i̱ yaa ku kwaa ne̱re̱ anda a kwaa Yamba, yo̱ wu nyi̱i̱mbi̱r Bawei du Walwal. ");
INSERT INTO wja_vpl VALUES ("H14_9","082_4_9","1TH","4","9","9","Yaa tagi̱ nu̱wa ba balambi̱ri̱ bala a dwii ku bu kangmanu we̱i̱ bu̱ri̱, di̱ngi̱n Yamba ju̱ku̱mbi̱ra ki̱n bu kangman kana wo̱no̱ mbi̱re̱. ");
INSERT INTO wja_vpl VALUES ("H14_10","082_4_10","1TH","4","10","10","Manggu bu ni̱ngaman kangam mwa mwa ki̱yaa nu̱wa bu po̱nggu̱ bu si̱ma Makidoniya wa. Ki̱yaa, yi bo̱o̱ ci̱ku̱gu̱mbi̱ru̱ bu cwata ni̱nggu̱ yi̱to̱. ");
INSERT INTO wja_vpl VALUES ("H14_11","082_4_11","1TH","4","11","11","Bu kwasi̱ kwi̱i̱ bu ni̱nga pi̱su̱ wu daayau̱, bu̱ ni̱nga tu gawu̱ri̱ mbi̱ri̱, bu ni̱nga wu̱rai̱ yi̱ war mbi̱ri̱, ci̱ka ku yi ju̱ku̱mbi̱rau̱. ");
INSERT INTO wja_vpl VALUES ("H14_12","082_4_12","1TH","4","12","12","Ka bu ni̱ng yi̱to̱ bu yo̱ we̱i̱ nu̱wa bu nyaa wa, a bo̱nggo̱ nu̱wa bu yaa po̱nggu̱ wa pero bu daani̱ya laa bo̱nggo̱ kana we̱. ");
INSERT INTO wja_vpl VALUES ("H14_13","082_4_13","1TH","4","13","13","Ci̱yamba, yi yaa kasi̱ bu yo̱o̱ya yaa so̱mandi̱ a dwii pma bu daa diima mi̱ri̱ngi̱ Yesu wa, pma bu bwaanga wa, di̱ngi̱n bu ni̱ngya bwiyang gaanggu̱ ci̱ka nu̱wa bu yaa manam ni̱i̱u̱ wa. ");
INSERT INTO wja_vpl VALUES ("H14_14","082_4_14","1TH","4","14","14","Yake̱ ku yi le̱e̱ ji̱re̱ mi̱n, Yesu bwaa wuni, di̱ngi̱n to̱no̱ yi le̱e̱ ji̱re̱ pma bu daa diima kem yi̱ Yesu wa, Yamba de̱ we̱i̱ pma kem yi̱ Yesu. ");
INSERT INTO wja_vpl VALUES ("H14_15","082_4_15","1TH","4","15","15","Cu̱u̱nggi̱ ci̱ye̱i̱ Mbaa wu Gi̱ra, yo bu yi bo̱o̱ yi̱ pi̱i̱ma wa a jo̱r du̱ Mbaa wu Gi̱ra baa we̱i̱, yaa ku yi gi̱ci̱lu̱ we̱i̱ nu̱wa bu bwaanga wunonggu. ");
INSERT INTO wja_vpl VALUES ("H14_16","082_4_16","1TH","4","16","16","Di̱ngi̱n Mbaa wu Gi̱ra yi̱ri̱ ye̱i̱ julo we̱i̱ a diyou kem yi̱ yi̱re̱ yi̱ du̱we̱i̱ yi̱ mi̱u̱ bacama wu gi̱ra pero yi̱ wuugu jume Yamba. Pma bu bwaanga mi̱ri̱ngi̱ Masiya wunonu we̱i̱ gawu̱ri̱yo̱. ");
INSERT INTO wja_vpl VALUES ("H14_17","082_4_17","1TH","4","17","17","Go̱ro̱ yi̱to̱ yo bu yi bo̱o̱ yi̱ pi̱i̱ma wa a dwii jo̱re̱, nu̱wa de̱ yir we̱i̱ diyou kem yi̱ pma mi̱ri̱ngi̱ tinendi, palaka yi kaanga yi̱ Mbaa Wu Gi̱ra a diyou. Yi si̱ndi̱ si̱ye̱i̱ kem yi̱ Mbaa Wu Gi̱ra kana pe̱ne̱ pe̱ne̱. ");
INSERT INTO wja_vpl VALUES ("H14_18","082_4_18","1TH","4","18","18","Di̱ngi̱n to̱no̱ bu ci̱ko̱ bu̱ri̱ yi̱ do̱o̱ ci̱ye̱i̱. ");
INSERT INTO wja_vpl VALUES ("H15_1","082_5_1","1TH","5","1","1","Ci̱yamba, a dwii jo̱ro̱ndi̱ yi̱ daandi su to̱o̱ yi̱ri̱ngi̱ ni̱ngdu̱ we̱i̱, yaa tagi̱ yi balambi̱ra, ");
INSERT INTO wja_vpl VALUES ("H15_2","082_5_2","1TH","5","2","2","di̱ngi̱n bu so̱ma wang mi̱n, nyanggu̱ Mbaa wu Gi̱ra baa we̱i̱ ci̱ka kuwe yi̱ ku̱me̱. ");
INSERT INTO wja_vpl VALUES ("H15_3","082_5_3","1TH","5","3","3","A jo̱r du̱ nu̱wa bo̱o̱ pi̱si̱ndi̱ pma ce̱gu̱ ki̱n, <<Yi pi̱si̱ndi̱ teng yi̱ pi̱dau̱ gaanggu̱,>> bu̱r bwi̱i̱ge̱ baa yarman pma, ci̱ka ku buu pwii ni̱ngaman nu̱ru̱mba bu yi̱ rwiiyengi wa, yaa ba gwala. ");
INSERT INTO wja_vpl VALUES ("H15_4","082_5_4","1TH","5","4","4","Anda ci̱yamba, bu yaa mi̱ri̱ngi̱ ku̱me̱ yi̱ ku nyanggu̱ ko̱o̱ bambo̱ we̱i̱ ci̱ka kuwe. ");
INSERT INTO wja_vpl VALUES ("H15_5","082_5_5","1TH","5","5","5","Mwa mwa mbi̱ru̱ bu yo̱o̱gi̱ kwaraa pu rangu̱ wa, pero kwaraa nyanggu̱ wa. Yi yaa yo̱o̱gi̱ bu ku̱m wa kana bu rum wa. ");
INSERT INTO wja_vpl VALUES ("H15_6","082_5_6","1TH","5","6","6","Di̱ngi̱n to̱no̱ yi daaya diima ci̱ka bu kangga ni̱ngwa, yi ni̱nga pu swe̱ri̱gu̱ pero yi ta bu̱ri̱. ");
INSERT INTO wja_vpl VALUES ("H15_7","082_5_7","1TH","5","7","7","Pma bu daa diima wa daa yi̱ ku̱me̱, pma bu nyi̱nma ji̱ri̱ wa, ji̱ri̱ yi̱ ku̱me̱. ");
INSERT INTO wja_vpl VALUES ("H15_8","082_5_8","1TH","5","8","8","Anda yake̱ ku yi yo̱o̱gi̱ bu nyanggu̱ wa, yi ta bu̱ri̱, yi te̱e̱ le̱e̱gu̱ ji̱re̱ yi̱ kangam ci̱ka dakilau, pero yi te̱e̱ manam ni̱i̱u̱ wu mi̱rayiri we̱i̱, wu ci̱ka dwari̱ bo̱o̱ ke̱ni̱. ");
INSERT INTO wja_vpl VALUES ("H15_9","082_5_9","1TH","5","9","9","Yamba se̱kayiribu di̱ngi̱n sukom yo̱u̱, anda di̱ngi̱n yi nyi̱ngga mi̱rma bo̱nggo̱ Mbaa Wu Gi̱ra Yesu Masiya. ");
INSERT INTO wja_vpl VALUES ("H15_10","082_5_10","1TH","5","10","10","Yo̱ bwaa di̱ngi̱n yo, palaka kana yi bo̱o̱ yi̱ pi̱i̱ma kana yi daa diima yi si̱i̱ we̱i̱ kem yi̱ yo̱. ");
INSERT INTO wja_vpl VALUES ("H15_11","082_5_11","1TH","5","11","11","Di̱ngi̱n to̱no̱ bu ci̱ko̱ bu̱ri̱ mbi̱ri̱ pero bu mo̱ bu̱ri̱ mbi̱ri̱ ci̱ka ku bu ni̱nggu̱ yo̱ko̱. ");
INSERT INTO wja_vpl VALUES ("H15_12","082_5_12","1TH","5","12","12","Ci̱yamba, yi bo̱o̱ senggumbi̱ru̱, bu nyi̱i̱ gi̱ru̱ bagi̱raa mba bu ni̱nggu̱ wu̱rai̱ a cu̱du̱ mbi̱ri̱, bu taambi̱ri̱ pero nyi̱i̱mbi̱r di̱kaci̱ye̱i̱ a dwii pi̱su̱ nu̱wa bu po̱nggu̱ wa. ");
INSERT INTO wja_vpl VALUES ("H15_13","082_5_13","1TH","5","13","13","Bu nyi̱i̱ pma gi̱ru̱ kundi yi̱ kangam di̱ngi̱n wu̱rai̱ pmai. Bu si̱n si̱ndi̱ye̱i̱ yi̱ pi̱dau̱ gaanggu̱ yi̱ bu̱ru̱ mbi̱ri̱. ");
INSERT INTO wja_vpl VALUES ("H15_14","082_5_14","1TH","5","14","14","Ci̱yamba, yi bo̱o̱ senggumbi̱ru̱, bu ye̱re̱nga nu̱wa bu yaa ni̱ngi̱ wu̱rai̱ wa, bu ci̱ko̱ bu gaanggi̱ri̱ pmai yara wa, bu kalanga bu yaa di̱mbi̱ri̱ wa, bu ni̱nga kanadi yi̱ kana we̱. ");
INSERT INTO wja_vpl VALUES ("H15_15","082_5_15","1TH","5","15","15","Bu le̱e̱ yaa kana we̱ ba ya tu̱we̱ yi̱ tu̱we̱, bu kwasi̱ kwii kana pe̱ne̱ bu ni̱ngaman bur mbi̱ri̱ tu nyaayi yi̱ nu̱wa mwa mwa. ");
INSERT INTO wja_vpl VALUES ("H15_16","082_5_16","1TH","5","16","16","Bu ni̱nga bu̱ri̱ de̱gde̱g kana pe̱ne̱ pe̱ne̱. ");
INSERT INTO wja_vpl VALUES ("H15_17","082_5_17","1TH","5","17","17","Bu ni̱nga pu ce̱gu̱ ku̱ru̱ yaa largu. ");
INSERT INTO wja_vpl VALUES ("H15_18","082_5_18","1TH","5","18","18","Bu wananga Yamba a mi̱ri̱nggi̱ kana ca, di̱ngi̱n to̱o̱ tu Yamba kasi̱ bo̱nggo̱ mbi̱ru̱ a mi̱ri̱nggu̱ Masiya Yesu. ");
INSERT INTO wja_vpl VALUES ("H15_19","082_5_19","1TH","5","19","19","Bu ci̱nge̱ni̱ya ci̱ye̱i̱ Bawei du Walwal. ");
INSERT INTO wja_vpl VALUES ("H15_20","082_5_20","1TH","5","20","20","Bu ce̱di̱ya ce̱wi̱ banabi̱ndi̱, ");
INSERT INTO wja_vpl VALUES ("H15_21","082_5_21","1TH","5","21","21","anda bu cu̱u̱ kana ca, bu ta tu nyaayi, ");
INSERT INTO wja_vpl VALUES ("H15_22","082_5_22","1TH","5","22","22","bu kwaa kana to̱no̱ yi̱ri̱ tu bwi̱i̱. ");
INSERT INTO wja_vpl VALUES ("H15_23","082_5_23","1TH","5","23","23","Yama Yamba, yo̱ yi̱ri̱ ye̱i̱ wu̱ yi̱ pi̱dau̱ gaanggu̱ ba diina bu ni̱nga walwal mwa mwa, pero ba swe̱ra bawei mbi̱ri̱ yi̱ pi̱i̱ma mba yi̱ bu̱ri̱ mbi̱ri̱ yaa we̱le̱m ko̱po̱ jo̱r waati̱gu̱ Mbaa Wu Gi̱ra Yesu Masiya. ");
INSERT INTO wja_vpl VALUES ("H15_24","082_5_24","1TH","5","24","24","Yo̱ wu se̱kambi̱ra a yinno bu nyi̱i̱ ji̱re̱ yi̱ yo̱, pero yo̱ ni̱ng we̱i̱. ");
INSERT INTO wja_vpl VALUES ("H15_25","082_5_25","1TH","5","25","25","Ci̱yamba, bu ce̱ yiri ku̱ru̱. ");
INSERT INTO wja_vpl VALUES ("H15_26","082_5_26","1TH","5","26","26","Bu ci̱ nu̱wa bu po̱nggu̱ mwa mwa yi̱ gaanggu̱ walwal. ");
INSERT INTO wja_vpl VALUES ("H15_27","082_5_27","1TH","5","27","27","N sagu̱mbi̱ru̱ mi̱ri̱nggi̱ din Mbaa Wu Gi̱ra, bu ce̱man ki̱yaa mba mwa mwa lakargar wo̱o̱. ");
INSERT INTO wja_vpl VALUES ("H15_28","082_5_28","1TH","5","28","28","Yama bo̱o̱ ni̱i̱u̱ Mbaa wu Gi̱ra Yesu Masiya yire ba si̱ya kem yi̱ mba.");
INSERT INTO wja_vpl VALUES ("H21_1","083_1_1","2TH","1","1","1","Wunaa lakargar twiiwe bo̱nggo̱ Bulus yi̱ Silas yi̱ Timoti, aari bo̱nggo̱ nu̱wa bu po̱nggu̱ Yesu wa bu gwe̱i̱ Tasalonika bu Yamba Kwiite yi̱ Mbaa wu Gi̱ra Yesu Masiya. ");
INSERT INTO wja_vpl VALUES ("H21_2","083_1_2","2TH","1","2","2","Bo̱o̱ ni̱i̱u̱ yi̱ pi̱dau̱ gaanggu̱ bo̱nggo̱ Yamba Kwiite yi̱ Mbaa wu Gi̱ra Yesu Masiya ba si̱ya kem yi̱ mba. ");
INSERT INTO wja_vpl VALUES ("H21_3","083_1_3","2TH","1","3","3","Ci̱yamba, tagi̱ yi wananga Yamba di̱ngi̱n mba nyi̱ki̱ri̱k, a daaya yi̱to̱, yake̱ ku le̱e̱gu̱ ji̱re̱ mbi̱ru̱ a cwatugu bu̱ru̱ kwang kwang, pero kangam kana wo̱no̱ mbi̱re̱ a cwatugu bu̱ru̱. ");
INSERT INTO wja_vpl VALUES ("H21_4","083_1_4","2TH","1","4","4","Di̱ngi̱n to̱no̱, yo yiri yiri yi ni̱nggu̱ go̱rso̱ndi̱ dwii mbi̱ri̱ a bo̱nggo̱ nu̱wa bu po̱nggu̱ Yamba wa bu kanga di̱ngi̱n bo̱gu̱ gaanggu̱ mbi̱ru̱ mi̱ri̱nggu̱ le̱e̱gu̱ ji̱re̱ mi̱ri̱nggu̱ yi̱ ti̱i̱gu̱ ku̱u̱lu̱ yi̱ tu̱ro̱m wu bu bo̱o̱ mi̱ru̱. ");
INSERT INTO wja_vpl VALUES ("H21_5","083_1_5","2TH","1","5","5","Mwa mwa to̱o̱ ju̱ku̱ya ki̱n bali̱ Yambai̱ ci̱maci̱ma, di̱ngi̱n bu yinno bu si̱ndu̱ we̱i̱ si̱ye̱ndi̱ mi̱ri̱nggu̱ lau̱ Yambau̱, twii to̱no̱ bu ti̱i̱gu̱ ku̱u̱le̱ a dwii lau̱ kwii. ");
INSERT INTO wja_vpl VALUES ("H21_6","083_1_6","2TH","1","6","6","Yake̱ ku Yamba ni̱nga yo̱ ci̱maci̱ma, turonu we̱i̱ pma bu turonggumbi̱ru̱ wa, ");
INSERT INTO wja_vpl VALUES ("H21_7","083_1_7","2TH","1","7","7","anda mba bu nu̱wa turonggumbi̱ru̱ wa, nyi̱i̱mbi̱ru̱ we̱i̱ yo̱ro̱nggu̱ yi̱ yo mwaasi̱. To̱o̱ yi̱ri̱ ni̱ndu̱ we̱i̱ a nyanggu̱ ku Mbaa wu Gi̱ra Yesu waata we̱i̱ diyou ju̱ku̱ru̱ we̱i̱ bu̱ri̱ ye̱i̱ kem yi̱ bacamandi̱ ye̱i̱ su yi̱ di̱mbi̱re̱ mi̱ri̱nggi̱ cile bwalai. ");
INSERT INTO wja_vpl VALUES ("H21_8","083_1_8","2TH","1","8","8","Yo̱ ni̱ngamanu̱ we̱i̱ bali̱ pma bu kwaa Yamba wa yi̱ pma bu kwaa ni̱nggu̱ po̱nggo̱ndi̱ ci̱ye̱i̱ du teng du Mbaa wu Gi̱ra yire Yesu. ");
INSERT INTO wja_vpl VALUES ("H21_9","083_1_9","2TH","1","9","9","Yo̱ mwarmanu̱ we̱i̱ pma bali̱ su bwi̱i̱ kana pe̱ne̱ pe̱ne̱, yo̱ ke̱e̱ we̱i̱ pma gawu̱ri̱ Mbaa wu Gi̱ra pero yi̱ bo̱nggo̱ di̱mbi̱re̱ yo̱ wu yi̱ yi̱lau̱. ");
INSERT INTO wja_vpl VALUES ("H21_10","083_1_10","2TH","1","10","10","A kwii nyanggu̱ baa we̱i̱ di̱ngi̱n nu̱wa ya bu walwal wa ba nyi̱i̱ yo̱ gi̱ru̱, pero pma bu le̱e̱ ji̱re̱ wa bu̱ri̱ baru̱ we̱i̱ pma mwa mwa. To̱o̱ mwa ban mba, di̱ngi̱n bu le̱e̱ ji̱re̱ yi̱ se̱e̱daki̱ yire. ");
INSERT INTO wja_vpl VALUES ("H21_11","083_1_11","2TH","1","11","11","Di̱ngi̱n to̱no̱, yi ce̱mbi̱ri̱ ku̱ru̱ nyi̱ki̱ri̱k mi̱n Yamba yire ba di̱i̱na bu yinno yi̱r ye̱i̱, pero bo̱nggo̱ di̱mbi̱ri̱ yo̱ ba twanga kana to̱no̱ dangandi̱ mbi̱ri̱ di̱ngi̱n tu̱nggu̱ tu nyaayi yi̱ kana do̱no̱ wu̱rai̱ mbi̱ri̱ du̱ twii we̱i̱ bo̱nggo̱ le̱e̱gu̱ ji̱re̱i̱, ");
INSERT INTO wja_vpl VALUES ("H21_12","083_1_12","2TH","1","12","12","palaka nu̱wa ba nyi̱i̱ gi̱ru̱ din Mbaa wu Gi̱ra Yesu Masiya a mi̱ri̱nggi̱ mbi̱ri̱, mba mwaasi̱ nu̱wa ba nyi̱i̱mbi̱ri̱ gi̱ru̱ a mi̱ri̱nggi̱ ye̱i̱, cu̱u̱nggi̱ bo̱o̱ ni̱i̱ Yamba yire yi̱ Mbaa wu Gi̱ra Yesu Masiya. ");
INSERT INTO wja_vpl VALUES ("H22_1","083_2_1","2TH","2","1","1","Ci̱yamba, a dwii waati̱gu̱ Mbaa wu Gi̱ra yire Yesu Masiya yi̱ kanda ku nu̱wa ku̱rayiru we̱i̱ a bo̱nggo̱ yo̱u̱, yi senggumbi̱ru̱, ");
INSERT INTO wja_vpl VALUES ("H22_2","083_2_2","2TH","2","2","2","gaanggu̱ mbi̱ri̱ ba wuniya kana ba mwaanga bu̱ri̱ be̱da be̱da, ka bu nu̱wi̱ ki̱n, nyanggu̱ Mbaa wu Gi̱ra a lammu̱we̱. Ko̱ wu kangge̱ ba ce̱ yi̱to̱ mi̱ri̱nggi̱ bawei, kana mi̱ri̱nggi̱ ce̱wi̱, kana mi̱ri̱ngi̱ lakargar ba ce̱ ki̱n, bwii bu yo yi bala. ");
INSERT INTO wja_vpl VALUES ("H22_3","083_2_3","2TH","2","3","3","Kana we̱ ba ci̱ye̱mbi̱ri̱ya a mi̱ri̱ngi̱ kana so̱no̱ nyindi, di̱ngi̱n nyanggu̱ kwii na baayi ko̱po̱ ka nu̱wa kwaa te̱e̱ri̱ Yamba gawu̱ri̱yo̱, pero ne̱r wu kwaa Yamba wii twiiwe we̱i̱, wu nu̱wa ruuman yo̱ bwi̱i̱ge̱. ");
INSERT INTO wja_vpl VALUES ("H22_4","083_2_4","2TH","2","4","4","Yo̱ kwaa kana ca tu nu̱wa yi̱ri̱ ki̱n yamba, yi̱ kana ca tu nu̱wa ku̱raman yo̱ si̱ma, yo̱ de̱r dwii ye̱i̱ a gwala pma mwa mwa. Yo̱ diiri we̱i̱ Laa Yambau̱ ba si̱n si̱yau̱, ba de̱ bu̱r ye̱i̱ yo̱ yo̱o̱gi̱ Yamba. ");
INSERT INTO wja_vpl VALUES ("H22_5","083_2_5","2TH","2","5","5","Yaa ku bu dangga mi̱n, yi sambi̱ra to̱o̱ yi̱ri̱ngi̱ mwa mwa pu yi bo̱o̱ kem yi̱ mba ru? ");
INSERT INTO wja_vpl VALUES ("H22_6","083_2_6","2TH","2","6","6","Yo̱ko̱ bu so̱m tu jagu̱ yo̱ bagu̱ di̱ngi̱n yo̱ ju̱ku̱ru̱ we̱i̱ bu̱ri̱ ye̱i̱ ka jo̱r ye̱i̱ ni̱nggi̱. ");
INSERT INTO wja_vpl VALUES ("H22_7","083_2_7","2TH","2","7","7","Kana yo̱ko̱ ni̱ngga wu bwi̱i̱ wii to̱o̱ ni̱ngu̱ bu̱ru̱ tukugi, anda yo̱ wu jagu̱ wii, je̱e̱ we̱i̱ gawu̱re̱, ko̱po̱ ka Yamba de̱man yo̱. ");
INSERT INTO wja_vpl VALUES ("H22_8","083_2_8","2TH","2","8","8","Bur ne̱r wu kwaa te̱e̱ri̱ Yambai̱ wii baa we̱i̱ anda Mbaa wu Gi̱ra Yesu bwiyanu̱ we̱i̱ yo̱ yi̱ ce̱wi̱ ye̱i̱ tu nyi̱i̱ya ye̱i̱, ba ji yo̱ bo̱nggo̱ bagu̱ yo̱u̱ a nyanggu̱ waatugu yo̱u̱. ");
INSERT INTO wja_vpl VALUES ("H22_9","083_2_9","2TH","2","9","9","Ne̱r wu kwaa te̱e̱ri̱ Yamba wii baa we̱i̱ yi̱ di̱mbi̱ri̱ wu̱rang Balaa Buwai, wu̱rangi̱ tu gembirendi yi̱ somdi yi̱ yi̱ri̱ngi̱ bagu̱ bu̱ri̱, wundu wundu. ");
INSERT INTO wja_vpl VALUES ("H22_10","083_2_10","2TH","2","10","10","Ni̱ng we̱i̱ wu̱rai̱ yi̱ kana ca tu bwi̱i̱ ba ci̱ye̱ngo̱ nu̱wa bu nyino bo̱o̱ru̱ wa, di̱ngi̱n pma kwaa kangam ji̱re̱ wu mi̱r we̱i̱ pma. ");
INSERT INTO wja_vpl VALUES ("H22_11","083_2_11","2TH","2","11","11","Di̱ngi̱n to̱no̱ Yamba tu̱mu̱we̱ ciyendi kwang kwang palaka pma ba le̱e̱ yi̱ leendi, ");
INSERT INTO wja_vpl VALUES ("H22_12","083_2_12","2TH","2","12","12","di̱ngi̱n nu̱wa ba ni̱ngaman bali̱ pma mwa mwa bu kwaa le̱e̱gu̱ ji̱re̱ yi̱ ji̱re̱ wa, pero pma nu̱u̱ tengu tu̱mgu̱ tu bwi̱i̱. ");
INSERT INTO wja_vpl VALUES ("H22_13","083_2_13","2TH","2","13","13","Ci̱yamba, tagi̱ yi wananga Yamba nyi̱ki̱ri̱k di̱ngi̱n mba bu Mbaa wu Gi̱ra kangman pma wa, di̱ngi̱n Yamba se̱kambi̱ra bu yo̱o̱ bu gawu̱ri̱yo̱ wa, bu nyi̱ngga mi̱rma bo̱nggo̱ Bawei du diini bu ni̱ngi̱ walwal yi̱ le̱e̱gu̱ ji̱re̱ mbi̱ru̱ yi̱ ce̱i̱ du ji̱re̱. ");
INSERT INTO wja_vpl VALUES ("H22_14","083_2_14","2TH","2","14","14","Tu diinai a yi̱mbi̱ra bu nyi̱ngga mi̱rma bo̱nggo̱ ci̱ye̱i̱ du teng du yi sambi̱rai̱, di̱ngi̱n bu nyi̱ngga yi̱lau̱ Mbaa wu Gi̱ra Yesu Masiya. ");
INSERT INTO wja_vpl VALUES ("H22_15","083_2_15","2TH","2","15","15","Di̱ngi̱n to̱no̱, ci̱yamba, bu ti̱ndi̱ ti̱yei̱ yi̱ di̱mbi̱re̱, pero bu ta tu yi ju̱ku̱mbi̱ra bo̱nggo̱ ce̱wi̱ yi̱ bala yiri. ");
INSERT INTO wja_vpl VALUES ("H22_16","083_2_16","2TH","2","16","16","Yama Mbaa wu Gi̱ra Yesu Masiya yo̱ yi̱ri̱ ye̱i̱ yi̱ Yamba Mbaa yire wu kangyiro, cikoyiri gaanggu̱ kana pe̱ne̱ pe̱ne̱ yi̱ manam ni̱i̱u̱ wu nyaau bo̱nggo̱ bo̱o̱ ni̱i̱ yo̱u̱, ");
INSERT INTO wja_vpl VALUES ("H22_17","083_2_17","2TH","2","17","17","ba ciko gaanggu̱ mbi̱ru̱ ba nyi̱i̱mbi̱ri̱ di̱mbi̱re̱ mi̱ri̱nggi̱ wu̱rangi̱ tu nyaayi yi̱ ce̱wi̱ tu nyaayi. ");
INSERT INTO wja_vpl VALUES ("H23_1","083_3_1","2TH","3","1","1","Cwata go̱ro̱i̱ yo̱u̱, ci̱yamba, bu ce̱yiri ku̱ru̱ palaka ci̱ye̱i̱ Mbaa wu Gi̱ra ba wasi̱ bu̱ri̱ ki̱lang ki̱lang pero ba ki̱ngga nyi̱i̱gu̱ gi̱ru̱, ci̱ka ku ki̱nggau̱ a bo̱nggo̱ mbi̱ru̱. ");
INSERT INTO wja_vpl VALUES ("H23_2","083_3_2","2TH","3","2","2","Pero bu ce̱ ku̱ru̱ Yamba ba mi̱rayiro bo̱nggo̱ nu̱wa bu bwi̱i̱wa bu tu̱m tu bwi̱i̱, di̱ngi̱n yaa mwa mwa nu̱wa bu le̱e̱ ji̱re̱ wa. ");
INSERT INTO wja_vpl VALUES ("H23_3","083_3_3","2TH","3","3","3","Mbaa wu Gi̱ra wu yi̱ ji̱re̱, yo̱ nyi̱i̱mbi̱r we̱i̱ di̱mbi̱re̱, swe̱ru̱mbi̱ru̱ we̱i̱ bo̱nggo̱ wu bwi̱i̱ wo̱o̱, Balaa Buwai. ");
INSERT INTO wja_vpl VALUES ("H23_4","083_3_4","2TH","3","4","4","Yi man ni̱i̱ yi̱ Mbaa wu Gi̱ra mi̱n, bu po̱nggu̱ tu yi sambi̱ra, pero bu je̱e̱ we̱i̱ gawu̱re̱ yi̱ po̱nggu̱. ");
INSERT INTO wja_vpl VALUES ("H23_5","083_3_5","2TH","3","5","5","Yama Mbaa wu Gi̱ra ba taa gaangi̱ri̱ mbi̱ri̱ mi̱ri̱nggi̱ kangam Yamba, yi̱ bo̱o̱gu̱ gaanggu̱ ku Masiya. ");
INSERT INTO wja_vpl VALUES ("H23_6","083_3_6","2TH","3","6","6","Ci̱yamba, yi bo̱o̱ sagu̱mbi̱ru̱ ci̱ye̱i̱ mi̱ri̱nggu̱ din Mbaa wu Gi̱ra Yesu Masiya, bu ne̱ci̱ya dwii yi̱ ne̱r wu ce̱ri̱ wari̱, wu yaa po̱nggu̱ tu yi ju̱ku̱mbi̱ra. ");
INSERT INTO wja_vpl VALUES ("H23_7","083_3_7","2TH","3","7","7","Mba mwa yi̱ri̱ mbi̱ri̱ bu so̱ma mi̱n, tagi̱ bu ti̱langa tu yi ni̱ngi̱, jo̱r du̱ yi bo̱o̱ kem yi̱ mba yaa ku yi ce̱ra wari̱. ");
INSERT INTO wja_vpl VALUES ("H23_8","083_3_8","2TH","3","8","8","Yaa ku yi je̱ je̱e̱ndi̱ nyo a bo̱nggo̱ kana we̱, anda yi ni̱nga pu wu̱rai̱ yi̱ cu̱sanggu̱ ku̱me̱ yi̱ nyanggu̱, daakal yi yo̱o̱ di̱ngi̱man a dwii kana wo̱no̱ mbi̱re̱. ");
INSERT INTO wja_vpl VALUES ("H23_9","083_3_9","2TH","3","9","9","Yi puu we̱i̱ yi sambi̱ra bu kalayiro, anda yi kasi̱ bu ti̱langa bo̱nggo̱ yiru. ");
INSERT INTO wja_vpl VALUES ("H23_10","083_3_10","2TH","3","10","10","Kana pu yi bo̱o̱ kem yi sambi̱ra mi̱n, ne̱r wu̱ kwaa wu̱rai̱, bu nyi̱i̱ya je̱e̱ndi̱. ");
INSERT INTO wja_vpl VALUES ("H23_11","083_3_11","2TH","3","11","11","Di̱ngi̱n yi nu̱u̱gu̱ labar ki̱n bu kangga mba yaa le̱e̱ wu̱rai̱, pma yaa ni̱ng kana do̱no̱ wu̱rai̱ bu̱ru̱ jagu̱ nu̱wa ni̱ngu̱ wu̱rai̱ pmai. ");
INSERT INTO wja_vpl VALUES ("H23_12","083_3_12","2TH","3","12","12","Bo̱o̱ nu̱wa, yi bo̱o̱ sagu̱ pma, pero yi ye̱ri̱gu̱ pma mi̱ri̱nggi̱ Mbaa wu Gi̱ra Yesu Masiya ba ki̱ngga pi̱dau̱ gaanggu̱ ba ni̱nga wu̱rai̱, ba je̱e̱ bu̱ri̱ pmai. ");
INSERT INTO wja_vpl VALUES ("H23_13","083_3_13","2TH","3","13","13","Anda mba ci̱yamba, bu janganiya yi̱ ni̱nggu̱ tu nyaayi. ");
INSERT INTO wja_vpl VALUES ("H23_14","083_3_14","2TH","3","14","14","Ka wu kangge̱ mbi̱re̱ kwaa ni̱nggu̱ po̱nggo̱ndi̱ yi̱ tu yi sambi̱ra mi̱ri̱nggi̱ lakargar wunaa, wu yi bo̱o̱ balambi̱re̱, bu ruun tu̱we̱, bu ne̱ci̱ya dwii yi̱ yo̱ palaka ba nu̱u̱ me̱lma. ");
INSERT INTO wja_vpl VALUES ("H23_15","083_3_15","2TH","3","15","15","Anda bu de̱ri̱ya yo̱ ci̱ka bace̱n mbi̱re̱, bu ni̱ngaman yo̱ di̱kace̱ne̱ ci̱ka ci̱yate̱. ");
INSERT INTO wja_vpl VALUES ("H23_16","083_3_16","2TH","3","16","16","Yama Mbaa wu Gi̱ra wu yi̱ pi̱dau̱ gaanggu̱, yo̱ yi̱ri̱ ye̱i̱ ba nyi̱i̱mbi̱ri̱ pi̱dau̱ gaanggu̱ kana do̱no̱ jo̱re̱, yi̱ kana wo̱no̱ ni̱nga. Mbaa wu Gi̱ra ba si̱ya kem yi̱ mba mwa mwa. ");
INSERT INTO wja_vpl VALUES ("H23_17","083_3_17","2TH","3","17","17","Mi Bulus, n wo̱o̱ balambi̱ri̱ bi̱naa ci̱i̱ma yi̱ wai mu. To̱o̱ somdi a dwii kana wo̱no̱ lakargar wu n bala, n bali̱ bala yi̱to̱. ");
INSERT INTO wja_vpl VALUES ("H23_18","083_3_18","2TH","3","18","18","Yama bo̱o̱ ni̱i̱u̱ Mbaa wu Gi̱ra Yesu Masiya yire ba si̱ya kem yi̱ mba mwa mwa.");
INSERT INTO wja_vpl VALUES ("T11_1","084_1_1","1TI","1","1","1","Wuna lakargar baa bo̱nggo̱ Bulus. Yamba ne̱re̱ mi̱rma yire yi̱ Kristo Yesu, wu yi̱ man ni̱i̱ yi̱ yo̱, pma sangge̱ ki̱n n yo̱o̱ ne̱re̱ tu̱mandi̱ Kristo Yesu. ");
INSERT INTO wja_vpl VALUES ("T11_2","084_1_2","1TI","1","2","2","N balami̱n mo̱ Timoti bo̱l mi wu ji̱re̱ mi̱ri̱nggi̱ le̱e̱gu̱ ji̱re̱i̱. Bo̱o̱ ni̱i̱u̱ yi̱ bunam yi̱ pi̱dau̱ gaanggu̱ wu Yamba Kwiite yi̱ Mbaa Wu Gi̱ra Yesu Masiya ba si̱ya kem yi̱ mo̱. ");
INSERT INTO wja_vpl VALUES ("T11_3","084_1_3","1TI","1","3","3","Pu n mwati̱gu̱ Makidoniya, n sami̱na ma si̱n si̱ye̱i̱ a Apisa palaka ma ye̱ra nu̱wa bu ju̱ku̱gu̱ yi̱ri̱ngi̱ tu yaa ci̱maci̱ma yi̱ ci̱ye̱i̱ Yambai̱. ");
INSERT INTO wja_vpl VALUES ("T11_4","084_1_4","1TI","1","4","4","Ma sa pma ba bwiyaniya jo̱r pmai bo̱nggo̱ ba cindi yi̱ dinendi kakaa pma tu yaa mati̱gu̱. To̱o̱ yi̱ri̱ din nu̱wa gwe̱la, yaa kalan nu̱wa ba man ni̱i̱ yi̱ Yamba. ");
INSERT INTO wja_vpl VALUES ("T11_5","084_1_5","1TI","1","5","5","Tu diinai n ni̱ngu̱ wo̱o̱ di̱kace̱ne̱ palaka mwa mwa nu̱wa bu po̱nggu̱ wa ba twangwa yi̱ ni̱nggu̱ kangam wu twiiwe mi̱ri̱nggu̱ gaanggu̱ ku nyaau, yi̱ dangandi̱ tu nyaai, yi̱ manggu ni̱i̱u̱ yi̱ Kristo ku manggu. ");
INSERT INTO wja_vpl VALUES ("T11_6","084_1_6","1TI","1","6","6","Anda nu̱wa bu kangga po̱ro̱nga bo̱nggo̱ to̱o̱ yi̱ri̱ngi̱ tu nyaai mwa mwa pero pma bwiyanga jo̱r pmai bo̱nggo̱ ce̱wi̱ tu yaa dwii. ");
INSERT INTO wja_vpl VALUES ("T11_7","084_1_7","1TI","1","7","7","Pma kasi̱ nu̱wa ba so̱m pma ci̱ka ku̱lu̱mba te̱e̱ri̱ngi̱ Musa wa, anda pma so̱m bu tu pma ce̱gi̱, kana yi̱to̱ pma ce̱ ci̱ye̱i̱ ge̱k. ");
INSERT INTO wja_vpl VALUES ("T11_8","084_1_8","1TI","1","8","8","Yi so̱ma te̱e̱re̱ kundi ka nu̱wa ni̱ndi̱ wu̱rai̱ ci̱maci̱ma yi̱ to̱no̱. ");
INSERT INTO wja_vpl VALUES ("T11_9","084_1_9","1TI","1","9","9","Nu̱wa ni̱ngabu̱ te̱e̱re̱ di̱ngi̱n nu̱wa bu tu̱m tu nyaa wa. Nu̱wa ni̱nga di̱ngi̱n nu̱wa bu yaa po̱ng te̱e̱re̱ wa, pero pma bu so̱m bu Yamba wa pero yi̱ we̱le̱m wa, yi̱ pma bu yaa walwal wa, pero nu̱wa bu yaa gwasi̱ Yamba wa, pma bu laci Mbaa mba pma yi̱ njaa mba pma pero laci̱ nu̱wa bu kangga, ");
INSERT INTO wja_vpl VALUES ("T11_10","084_1_10","1TI","1","10","10","yi̱ bu ni̱ngi̱ taari̱ wa yi̱ bu daayi̱ nambi̱rmba wa, yi̱ bu ji̱nani̱ nu̱wa wa, yi̱ baleenda, yi̱ bu yaa ce̱ ji̱re̱ a kan bali̱ wa. Yi̱ kana ca tu yaa ci̱maci̱ma cima yi̱ yi̱ri̱ tu nu̱wa ju̱ku̱ya, ");
INSERT INTO wja_vpl VALUES ("T11_11","084_1_11","1TI","1","11","11","to̱o̱ baa bo̱nggo̱ Ci̱ye̱i̱ du Teng du Yamba du yi̱ wuure. To̱o̱ Ci̱ye̱i̱ du Teng du nu̱wa nyi̱nggi̱. ");
INSERT INTO wja_vpl VALUES ("T11_12","084_1_12","1TI","1","12","12","N wananga Kristo Yesu Mba Wu gi̱ra yire, yo̱ wu nyi̱i̱ngge̱ di̱mbi̱re̱ n ni̱nga wu̱rai̱ ye̱i̱. Yo̱ ko̱ngge̱ n yinno pero se̱kangge̱ n ni̱nga man yo̱ wu̱rai̱, ");
INSERT INTO wja_vpl VALUES ("T11_13","084_1_13","1TI","1","13","13","kana pu n bwiyanga din Kristo. N rweenga pero n turongo nu̱waya. Anda Yamba nu̱u̱ bunam mu di̱ngi̱n n ni̱nga mi̱ri̱nggi̱ dwal ku̱randi̱ yi̱ le̱e̱gu̱ ji̱rau̱. ");
INSERT INTO wja_vpl VALUES ("T11_14","084_1_14","1TI","1","14","14","Anda Mbaa Wu Gi̱ra wu yi̱ ni̱i̱ yi̱ bo̱o̱ni̱i̱! A twangangge̱ yi̱ le̱e̱gu̱ ji̱rau̱ yi̱ kangam wu bo̱nggo̱ Kristo Yesu. ");
INSERT INTO wja_vpl VALUES ("T11_15","084_1_15","1TI","1","15","15","Ti̱na ci̱ye̱i̱ ji̱re̱i̱, kana we̱ ba ki̱ngga ba yi̱ya, “Kristo Yesu ba mi̱ri̱nggu̱ si̱ma ba mi̱ra nu̱wa bu yi̱ we̱le̱m wa” Anda mi n yo̱o̱gi̱ wu kwe̱ce̱kwe̱ce̱ cu̱du̱ pmai mwa mwa. ");
INSERT INTO wja_vpl VALUES ("T11_16","084_1_16","1TI","1","16","16","Anda Yamba nu̱u̱ bunam mu palaka Kristo Yesu ba ni̱nga wu̱rai̱ yi̱ mi bo̱nggo̱ kanadi yo̱ wu tum a bo̱nggo̱ pma bu yi we̱le̱mdi̱ kwe̱cekwe̱ce̱ wa. Pero do̱ng bu kangga ba ku̱ranga, pma ba pu ji̱re̱i̱, ba nyi̱ngga pi̱i̱ma bu yaa matuguwa. ");
INSERT INTO wja_vpl VALUES ("T11_17","084_1_17","1TI","1","17","17","Mwa mwa gi̱ru̱ yi̱ yi̱lau̱ ko̱o̱ ku Yambau̱ kana pe̱ne̱ pe̱ne̱! Yo̱ yo̱o̱gi̱ balaa wu kana pe̱ne̱ pe̱ne̱, wu nu̱wa yaa kwe̱e̱yi̱, wu yaa bwaari̱, Yo̱ wundu yo̱o̱gi̱ Yamba. Amin. ");
INSERT INTO wja_vpl VALUES ("T11_18","084_1_18","1TI","1","18","18","Timoti, bo̱l mi, ti̱na di̱kace̱ni̱ mi a bo̱nggo̱ mo̱u̱, cu̱u̱nggi̱ ci̱ye̱i̱ banabi̱ du ci̱ye̱i̱ gawu̱ri̱yo̱. Yama ba kala mi̱na ma ni̱nga kwai su nyaai mi̱ri̱nggi̱ kwai Mba Wu gi̱ra. ");
INSERT INTO wja_vpl VALUES ("T11_19","084_1_19","1TI","1","19","19","Ma man ni̱i̱ yi̱ Kristo mi̱ri̱nggi̱ le̱e̱gu̱ ji̱rau̱ mau, yi̱ dangandi̱ tu nyaai. Di̱ngi̱n nu̱wa bu kangga ni̱ng dangandi̱ tu bwi̱i̱ be̱e̱re̱; di̱ngi̱n to̱no̱ le̱e̱gu̱ ji̱rau̱ pmau bwi̱i̱re̱. ");
INSERT INTO wja_vpl VALUES ("T11_20","084_1_20","1TI","1","20","20","Ci̱ka Hamenus yi̱ Aleksanda to̱o̱ yi̱ri̱ pmo. N yiki pma n nyi̱i̱ balaa buwai palaka ba ti̱langa kanda ku na bwiyani din Yambai̱. ");
INSERT INTO wja_vpl VALUES ("T12_1","084_2_1","1TI","2","1","1","N senggo mi̱na, tu gawu̱ri̱yo̱, ma ce̱man ku̱ru̱ nu̱wa mwa mwa. Ma senggo Yamba ba kalanga pma; ma dimino cu̱du̱ pmai yi̱ Yamba; ma wananga Yamba nyan pmo. ");
INSERT INTO wja_vpl VALUES ("T12_2","084_2_2","1TI","2","2","2","Ma ce̱ ku̱ru̱ di̱ngi̱n balamba yi̱ mwa mwa bu yi̱ gi̱ru̱wa palaka yi̱ si̱ya yi̱ pi̱dau̱ gaanggu̱ yi̱ param bu̱ru̱ yi̱ gwasi̱ Yambai̱ yi̱ nyi̱i̱gu̱ gi̱ru̱ a kana wo̱no̱ nyinou. ");
INSERT INTO wja_vpl VALUES ("T12_3","084_2_3","1TI","2","3","3","Yi̱to̱ kundi, pero di̱raman gaanggu̱ Yamba ne̱re̱ mi̱rma yire, ");
INSERT INTO wja_vpl VALUES ("T12_4","084_2_4","1TI","2","4","4","wu kasi̱ kana we̱ ba nyi̱ngga mi̱rma pero ba so̱m ji̱re̱. ");
INSERT INTO wja_vpl VALUES ("T12_5","084_2_5","1TI","2","5","5","Di̱ngi̱n Yamba wiino pero wo̱o̱ yi̱ wu cu̱de̱, yo̱ wundu wu si̱pi̱ naapu yi̱ Yamba yi̱ ne̱re̱, wii Kristo Yesu. ");
INSERT INTO wja_vpl VALUES ("T12_6","084_2_6","1TI","2","6","6","A nyi̱i̱ pi̱i̱maya di̱ngi̱n ba nyi̱ngaman kana we̱ param bu̱ru̱. To̱o̱ ci̱ye̱i̱ du Yamba nyi̱i̱ nu̱wa bu si̱ma wa a jo̱r du dayai. ");
INSERT INTO wja_vpl VALUES ("T12_7","084_2_7","1TI","2","7","7","Anda Yamba se̱ke̱ngge̱, n yo̱o̱ ne̱re̱ wu wasi̱ri̱ ci̱ye̱i̱ yi̱ ne̱re̱ tu̱mandi̱. N ju̱ku̱ nu̱wa bu yaa yo̱o̱gi̱ nu̱wa bu Yudayawa a dwii manam ni̱u̱ yi̱ ji̱re̱. N yaa ce̱gu̱ leendi anda n sagu̱mbi̱ru̱ ji̱re̱. ");
INSERT INTO wja_vpl VALUES ("T12_8","084_2_8","1TI","2","8","8","A kana pi̱yau̱ pu nu̱wa kuru si̱mau̱, n kasi̱ nami̱rmba ba wun war pmai walwal diyou ba ce̱ ku̱ru̱ bo̱nggo̱ Yambau̱, yaa su̱ko̱ndi̱ yi̱ gwe̱la. ");
INSERT INTO wja_vpl VALUES ("T12_9","084_2_9","1TI","2","9","9","Pero n kasi̱ nu̱ru̱mba ba twiyongo yi̱ se̱e̱ wu ci̱maci̱ma cima wu daaya wu nu̱wa nyi̱i̱ gi̱ru̱, ba si̱r ya dwii du yi̱ waandi kwang kwang yi̱ te̱e̱gu̱ sinariya yi̱ gi̱si̱ yi̱ se̱e̱ wu yi̱ pi̱rcu̱. ");
INSERT INTO wja_vpl VALUES ("T12_10","084_2_10","1TI","2","10","10","Anda nu̱ru̱mba bu ce̱ ki̱n pmai nyi̱i̱ gi̱ru̱ Yamba wa, a daaya ba wu̱u̱we̱ nu̱wa bo̱nggo̱ wu̱ran pmai tu nyaai tu pma ni̱nggi̱. ");
INSERT INTO wja_vpl VALUES ("T12_11","084_2_11","1TI","2","11","11","Nu̱ru̱mba ba ti̱langa yi̱ri̱ to̱k yi̱ ci̱nggu̱ dwiiu. ");
INSERT INTO wja_vpl VALUES ("T12_12","084_2_12","1TI","2","12","12","N yaa kasi̱ nu̱ru̱mba ba ju̱ku̱ yi̱ri̱ nambi̱rmba, kana ba je̱e̱ lau̱ dwii pmai. Yama pma ba katwiyou to̱k. ");
INSERT INTO wja_vpl VALUES ("T12_13","084_2_13","1TI","2","13","13","Di̱ngi̱n Yamba ruu Adamu gawu̱ri̱yo̱ anda ba ruu Awau. ");
INSERT INTO wja_vpl VALUES ("T12_14","084_2_14","1TI","2","14","14","Wu Balaa Buwei we̱le̱ngo̱ wii Adamu ne̱, anda wu nu̱wa we̱le̱nga wii Awau, wii yo̱ paa te̱e̱re̱ Yambai̱. ");
INSERT INTO wja_vpl VALUES ("T12_15","084_2_15","1TI","2","15","15","Anda nu̱ru̱mba nyi̱nggu̱ we̱i̱ mi̱rma bo̱nggo̱ bigu kwarau. Ka kwasi̱r kwi̱i̱ le̱e̱gu̱ ji̱rau̱ yi̱ kangam yi̱ pi̱su̱ walwal yi̱ pi̱su̱ wu nyaau. ");
INSERT INTO wja_vpl VALUES ("T13_1","084_3_1","1TI","3","1","1","Ti̱na ce̱du̱ ji̱re̱i̱: “Ka ne̱re̱ kasi̱ ba yo̱o̱ ne̱re̱ wu gi̱ra wu ikkilisiya, a kasa wu̱rai̱ du nyaau.>> ");
INSERT INTO wja_vpl VALUES ("T13_2","084_3_2","1TI","3","2","2","Di̱ngi̱n to̱no̱ ne̱re̱ wu gi̱ra ba yo̱o̱ ne̱re̱ wu yaa cedigi. Ba yo̱o̱ ne̱re̱ wu yi̱ nu̱re̱ wiino, ne̱re̱ wu tagi̱ bu̱ri̱, wu nu̱wa nyi̱i̱ gi̱ru̱, ne̱re̱ wu le̱e̱ ru̱nggu̱wa laa you, ne̱re̱ wu puu ju̱ku̱gu̱ yi̱ri̱. ");
INSERT INTO wja_vpl VALUES ("T13_3","084_3_3","1TI","3","3","3","Ba yo̱o̱ yaa banam nyi̱nma, yi̱ wu ni̱ng ruuni. Ba yo̱o̱ ne̱re̱ wu yi̱ kanadi, wu yaa kwai, wu yaa kangni̱ ke̱ne̱. ");
INSERT INTO wja_vpl VALUES ("T13_4","084_3_4","1TI","3","4","4","Tagi̱ ba yo̱o̱ ne̱re̱ wu pu tagu laa you kundi, kwaaraya nyi̱i̱ gi̱ru̱ a kana to̱no̱ yi̱ri̱ pero ni̱ng po̱ngo̱ndi̱ yi̱ yo̱. ");
INSERT INTO wja_vpl VALUES ("T13_5","084_3_5","1TI","3","5","5","Di̱ngi̱n ka ne̱re̱ puu bu tagu laa yo̱u̱ ne̱, ni̱ndu̱ we̱i̱ nye̱ ba puu tagu ikkilisiya Yamba? ");
INSERT INTO wja_vpl VALUES ("T13_6","084_3_6","1TI","3","6","6","Ne̱re̱ wu gi̱ra ba yo̱o̱ ya ne̱re̱ wu ni̱nga bwiiwa pu̱ci̱, di̱ngi̱n yaa buu ba le̱e̱ dwii, pero nu̱wa ni̱ngamanu̱ we̱i̱ yo̱ bali̱ ci̱ka ku nu̱wa ni̱ngaman Balaa Buwei. ");
INSERT INTO wja_vpl VALUES ("T13_7","084_3_7","1TI","3","7","7","Bambang, nu̱wa bu yaa po̱nggu̱ wa ba ce̱ tu nyaai dwii ye̱i̱ di̱ngi̱n ba nu̱u̱ yaa me̱lma pero ba yanniya tandau Balaa Buwei. ");
INSERT INTO wja_vpl VALUES ("T13_8","084_3_8","1TI","3","8","8","Yi̱to̱ mwaasi̱, nu̱wa bu ni̱ngi̱ wu̱rai̱ a ikkilisiya wa ba yo̱o̱ nu̱wa bu nu̱wa nyi̱i̱ gi̱ru̱ wa, bu yi̱ ji̱re̱ wa. Ba yo̱o̱ ya banaamba nyi̱nma wa, yi̱ yawo̱ kasu̱gu̱ ke̱nu̱. ");
INSERT INTO wja_vpl VALUES ("T13_9","084_3_9","1TI","3","9","9","Pma ba yo̱o̱ nu̱wa bu nyi̱i̱ dwii wu̱rangi̱ le̱e̱gu̱ ji̱re̱ tu nu̱wa so̱mbu̱i̱ pero ba si̱ya yi̱ dangandi̱ tu nyaai. ");
INSERT INTO wja_vpl VALUES ("T13_10","084_3_10","1TI","3","10","10","Nu̱wa ba ye̱sa pma bati̱. Ka yinno wai, pma ba ni̱nga wu̱rai̱. ");
INSERT INTO wja_vpl VALUES ("T13_11","084_3_11","1TI","3","11","11","Yi̱to̱ mwaasi̱ yi̱ nu̱ru̱mba pma, ba yo̱o̱ bu nu̱wa nyi̱i̱ gi̱ru̱wa. Ba yo̱o̱ yaa nu̱ru̱mba bu yi̱ tu ce̱ru̱wa. Pma ba taa dwii pmai, ba tu n ji̱re̱i̱ a kana ca tu pma ni̱ngi̱. ");
INSERT INTO wja_vpl VALUES ("T13_12","084_3_12","1TI","3","12","12","Nu̱wa bu ni̱ngi̱ wu̱rai̱ ikkilisiya wa ba yo̱o̱ ne̱re̱ wu nu̱re̱ wiino pero ba su̱wa kwaraya yi̱ laa yo̱u̱ kundi. ");
INSERT INTO wja_vpl VALUES ("T13_13","084_3_13","1TI","3","13","13","Pma bu ni̱nga wu̱rai̱ pmai kundi, nyi̱nggu̱ we̱i̱ nyi̱gu̱ gi̱ru̱ bo̱nggo̱ bu kangga pero cwatu we̱i̱ le̱e̱gu̱ ji̱rau̱ pmau mi̱ri̱nggi̱ Kristo Yesu. ");
INSERT INTO wja_vpl VALUES ("T13_14","084_3_14","1TI","3","14","14","N man ni̱i̱ n baa we̱i̱ bo̱nggo̱ mo̱u̱ yaa si̱gu̱. N bali̱gu̱ ti̱na yi̱ri̱ngi̱ bo̱nggo̱ mu yo̱ko̱, ");
INSERT INTO wja_vpl VALUES ("T13_15","084_3_15","1TI","3","15","15","di̱ngi̱n ka n liyan bu̱ri̱, bu so̱mu̱ we̱i̱ tu dayai nu̱wa Yambau̱ wa ba ni̱ngai̱ yi̱ bu̱ri̱ pmai. Tinaa nu̱wa Yambau̱ wu yi̱ pi̱i̱ma, yo̱ wu yo̱o̱gi̱ timbau yi̱ taa ji̱rau̱. ");
INSERT INTO wja_vpl VALUES ("T13_16","084_3_16","1TI","3","16","16","Yaa pi̱ra, ti̱na tu tukugai a mi̱ri̱nggu̱ le̱e̱gu̱ ji̱rau̱ yiru: Kristo a baa mi̱ri̱nggi̱ bu̱ri̱ ci̱ka ne̱re̱, anda bawei du walwal ce̱ yi̱to̱ a dwii ye̱i̱. Bacamandi ko̱ yo̱, anda pma wasi̱ ya a duuri. Nu̱wa le̱e̱ ji̱re̱i̱ yi yo̱ a si̱ma mwa mwa, anda nu̱wa de̱e̱ diyou yi̱ yi̱lau̱. ");
INSERT INTO wja_vpl VALUES ("T14_1","084_4_1","1TI","4","1","1","Yo̱ko̱ Bawei Yambai̱ sagu̱ yiru dak ki̱n, daandi su cwata go̱ro̱u̱ bukangga kwaa we̱i̱ manggu ni̱i̱ yi̱ Yesu; pma po̱nggu̱ we̱i̱ bawei leendi yi̱ yi̱ri̱ tu wuturindi pi̱rdi̱. ");
INSERT INTO wja_vpl VALUES ("T14_2","084_4_2","1TI","4","2","2","Nu̱wa bwii twii nu̱wa bu batal wa yi̱ bu mwaran leendu wa, pero dangandi̱ pmai bo̱o̱gi̱. ");
INSERT INTO wja_vpl VALUES ("T14_3","084_4_3","1TI","4","3","3","Pma ce̱ we̱i̱ ki̱n ni̱nggu̱ laabwiya yaa ci̱maci̱ma pero yaa ci̱maci̱ma ma je̱e̱ je̱e̱ndi̱ tu kanggi̱. Anda Yamba ruu to̱o̱ je̱e̱ndi̱ ki̱n nu̱wa bu yi̱ ji̱re̱ wa pero so̱m ji̱re̱ ba je̱e̱ yi̱ wandi̱ma. ");
INSERT INTO wja_vpl VALUES ("T14_4","084_4_4","1TI","4","4","4","Yake̱ ku kana ca tu Yamba ruu wo̱ kundi, yi kwaa ya kana to̱no̱ anda yi yi̱ya yi̱ wandi̱ma. ");
INSERT INTO wja_vpl VALUES ("T14_5","084_4_5","1TI","4","5","5","Di̱ngi̱n yi so̱ma a yo̱o̱ tu nyaai bo̱nggo̱ ci̱ye̱i̱ Yambai̱ yi̱ ku̱ru̱. ");
INSERT INTO wja_vpl VALUES ("T14_6","084_4_6","1TI","4","6","6","Ka ma sar to̱o̱ yi̱ri̱ngi̱ kamba bu nami̱rmba yi̱ bu nu̱ru̱mba wa bu po̱nggu̱, ma yo̱ we̱i̱ ke̱we̱ Kristo Yesu wu nyaa, wu nu̱wa taa yi̱ ce̱wi̱ manam ni̱i̱ yi̱ yi̱ri̱ tu nyaai tu nu̱wa ju̱ku̱mi̱nai̱, ma po̱ngai̱. ");
INSERT INTO wja_vpl VALUES ("T14_7","084_4_7","1TI","4","7","7","Ma liyaniya bu̱ri̱ gwe̱la a dwii yi̱ri̱ tu twii tu Yambai̱ ne̱ yi̱ bacindi nu̱ru̱mba bu ritengi wa. Yi ku ma ni̱ngu̱ we̱i̱ yi̱to̱, ma ye̱ra bu̱ri̱ mai, ma yo ne̱re̱ Yamba. ");
INSERT INTO wja_vpl VALUES ("T14_8","084_4_8","1TI","4","8","8","Turonggu ne̱m bu̱ru̱ kundi banyi̱na, anda po̱ngu̱ ci̱ye̱i̱ Yambai̱ a gwala a kana wo̱no̱ nyinou, di̱ngi̱n a de̱e̱ kalanggu̱ yo̱ko̱ yi̱ pi̱i̱ma bu bo̱o̱ baa wa. ");
INSERT INTO wja_vpl VALUES ("T14_9","084_4_9","1TI","4","9","9","Ti̱na ci̱ye̱i̱ ji̱re̱i̱ du kana we̱ ba yi̱ya. ");
INSERT INTO wja_vpl VALUES ("T14_10","084_4_10","1TI","4","10","10","To̱o̱ tu diinai yi ni̱nggu̱ wu̱rai̱ wang pero yi kwasi̱ri̱ kwi̱i̱, di̱ngi̱n manam ni̱i̱ yiru a bo̱nggo̱ Yamba wii yi̱ pi̱i̱ma. Yo̱ wu twii ne̱re̱ mi̱rma nu̱wa mwa mwa, ci̱ka nu̱wa bu le̱e̱ ji̱re̱ wa. ");
INSERT INTO wja_vpl VALUES ("T14_11","084_4_11","1TI","4","11","11","Ju̱ku̱ to̱o̱ yi̱ri̱ pero ma sa kana we̱ tagi̱ ba ni̱nga. ");
INSERT INTO wja_vpl VALUES ("T14_12","084_4_12","1TI","4","12","12","Ma le̱e̱ yaa nu̱wa ba ce̱do̱ mi̱na di̱ngi̱n ma yaa gi̱rgi̱. Ma yo̱o̱ ne̱re̱ wu nu̱wa bu le̱e̱ ji̱re̱ wa ti̱lanu̱ we̱i̱ mwa mwa a bo̱nggo̱ ce̱u̱ mai yi̱ wu̱rangi̱ mai yi̱ kangam mau yi̱ manam ni̱i̱ mau yi̱ pi̱su̱ walwal. ");
INSERT INTO wja_vpl VALUES ("T14_13","084_4_13","1TI","4","13","13","Ma kwasan kwii ce̱gu̱ ci̱ye̱i̱ Yambai̱ bo̱nggo̱ nu̱wa, yi̱ wasi̱gu̱ ci̱ye̱u̱ pero yi̱ ju̱ku̱gu̱ pmau, ko̱po̱ ka n baayi. ");
INSERT INTO wja_vpl VALUES ("T14_14","084_4_14","1TI","4","14","14","Ma kwaa yaa so̱mandi̱ tu Yamba nyi̱i̱ mi̱na pu bagi̱raa ikkilisiya wa ce̱rmi̱ni̱ war pmai, pma ce̱ ci̱ye̱i̱ Yambai̱ a dwii mai. ");
INSERT INTO wja_vpl VALUES ("T14_15","084_4_15","1TI","4","15","15","Ma ruun tu̱we̱ a to̱o̱ yi̱ri̱ngi̱. Ma diin dwii wu̱rai̱ mai palaka kana we̱ ba ko̱ je̱gu̱ gawu̱ri̱ mau. ");
INSERT INTO wja_vpl VALUES ("T14_16","084_4_16","1TI","4","16","16","Ma su̱wa kanda ku ma ni̱ngu̱ pi̱su̱ mau kundi yi̱ yi̱ri̱ tu ma pirgi. Ma je̱e̱ gawu̱re̱ yi̱ ni̱nggu̱ to̱no̱, di̱ngi̱n ka ma ni̱ngi̱, ma mi̱r we̱i̱ bu̱ri̱ mai yi̱ bu nu̱u̱gu̱ mau wa. ");
INSERT INTO wja_vpl VALUES ("T15_1","084_5_1","1TI","5","1","1","Ma sariya ci̱ye̱i̱ ne̱re̱ wu gi̱ra yi̱ kwai, anda ma kenda man yo̱ mi̱u̱ ci̱ka ku ma sar ci̱ye̱i̱ mba mau. Ma sa ci̱ye̱i̱ nu̱wa bu yaa gi̱rangi̱ wa ci̱ka ku ma sar ci̱yei̱ ci̱yamba ma. ");
INSERT INTO wja_vpl VALUES ("T15_2","084_5_2","1TI","5","2","2","Ma sa ci̱ye̱i̱ nu̱ru̱mba bu gi̱rawa ci̱ka ku ma sar ci̱ye̱i̱ njaa mau, pero ma sa ci̱ye̱i̱ nu̱ru̱mba bu yaa gi̱rangi̱ wa ci̱ka ku ma sar ci̱ye̱i̱ ci̱yamba ma bu nu̱ru̱mba wa. Ma ni̱nga yi̱ gaanggu̱ ku walwal. ");
INSERT INTO wja_vpl VALUES ("T15_3","084_5_3","1TI","5","3","3","Ma su̱wa kana wo̱no̱ wu̱tu̱ko̱lo̱ wu yaa ne̱re̱ wu su yo̱. ");
INSERT INTO wja_vpl VALUES ("T15_4","084_5_4","1TI","5","4","4","Anda ka pma bo̱o̱ yi kwaraa kana kakaa we̱i̱, ba ni̱nga tu Yamba kasi̱ a laandi pmai gawu̱ri̱yo̱ pero pma ba wo̱ra kwiimba pma yi̱ su̱gu̱ pmau. To̱o̱ yi̱ri̱ tu di̱raman gaanggu̱ Yambai̱. ");
INSERT INTO wja_vpl VALUES ("T15_5","084_5_5","1TI","5","5","5","Wu̱tu̱ko̱lo̱ wu ji̱re̱ twii nu̱re̱ wu yo̱ wundu, wu man ni̱i̱ bo̱nggo̱ Yambau̱. Yo̱ ce̱ ku̱ru̱ senggi kalanggu̱ Yambau̱ ku̱me̱ yi̱ nyanggu̱. ");
INSERT INTO wja_vpl VALUES ("T15_6","084_5_6","1TI","5","6","6","Anda wu̱tu̱ko̱lo̱ wu kasi̱ tengu ti̱bak bawei ye̱i̱ bwaagi̱ kana pu yi̱ pi̱i̱mau̱. ");
INSERT INTO wja_vpl VALUES ("T15_7","084_5_7","1TI","5","7","7","Ma sa nu̱wa bu po̱nggu̱wa to̱o̱ yi̱ri̱ngi̱, palaka nu̱wa ba ni̱nga tu daa ye̱i̱. ");
INSERT INTO wja_vpl VALUES ("T15_8","084_5_8","1TI","5","8","8","Anda pma bu yaa su naapu pmau, ya ci̱ka bu laa pmau wa, pma gwe̱la le̱e̱gu̱ ji̱rau̱ pmau. Bo̱o̱ nu̱wa a gwala nu̱wa bu yaa po̱nggu̱wa yi̱ bwi̱i̱ge̱. ");
INSERT INTO wja_vpl VALUES ("T15_9","084_5_9","1TI","5","9","9","Wu̱tu̱ko̱lo̱ wu nu̱wa murnu we̱i̱ ku̱ci̱ bu nu̱wa kalanu̱ we̱i̱ wa balama ci̱ka mi̱la kun no̱ko̱no̱ pero wu ni̱ng bwi̱yate̱ wiino, ");
INSERT INTO wja_vpl VALUES ("T15_10","084_5_10","1TI","5","10","10","Pero nu̱wa so̱ma yi̱ wu̱rangi̱ tu nyaai baabu: Su̱gu̱ bakwaraau, yi̱gu̱ ru̱nggu̱wau̱, cargu mwar nu̱wa bu po̱nggu̱ wa, kalanggu̱ nu̱wa bu ti̱i̱gu̱ ku̱u̱lu̱ wa yi̱ nyi̱i̱gu̱ dwii di̱ngi̱n kana to̱no̱ wu̱rangi̱ tu nyaai. ");
INSERT INTO wja_vpl VALUES ("T15_11","084_5_11","1TI","5","11","11","Wu̱tu̱ko̱la bu nyititiwa, nu̱wa ba ce̱ni̱ yaa ku̱ci̱, di̱ngi̱n miyam pmou cwanu̱ we̱i̱ pma yi̱ Kristo pero pma kasi̱ we̱i̱ pe̱ru̱gu̱ laabwiya. ");
INSERT INTO wja_vpl VALUES ("T15_12","084_5_12","1TI","5","12","12","Pma we̱lu̱ we̱i̱ bo̱nggo̱ de̱gu̱ alkawal pma wu gawu̱ri̱yo̱. ");
INSERT INTO wja_vpl VALUES ("T15_13","084_5_13","1TI","5","13","13","Anda ka nu̱wa din pma ku̱ci̱, pma ni̱ngi̱ we̱i̱ ku̱u̱le̱, pma bwi̱yanu̱ we̱i̱ jo̱r pmai tu ceeri po̱nggu̱ laa yi laa a casi̱ngu̱ bu̱ri̱ mi̱ri̱nggi̱ wu̱rangi̱ nu̱wai̱ a ce̱gu̱ tu daabu pma ba ci̱ye̱i̱. ");
INSERT INTO wja_vpl VALUES ("T15_14","084_5_14","1TI","5","14","14","Di̱ngi̱n to̱no̱ n ni̱nga man di̱kace̱ne̱ wu̱tu̱ko̱la bu nyititiwa ba ni̱nga laabwiya ba bi kwaraa, ba su̱wa kwaraa pma a lai̱. Palaka bace̱mba ba ki̱nggi̱ ya tu ce̱ we̱i̱ dwii pmai. ");
INSERT INTO wja_vpl VALUES ("T15_15","084_5_15","1TI","5","15","15","Di̱ngi̱n bu kangga pma po̱ranga, po̱ng Balaa Buwei. ");
INSERT INTO wja_vpl VALUES ("T15_16","084_5_16","1TI","5","16","16","Ka nu̱re̱ wu po̱nggu̱ wu wo̱o̱ yi̱ wu̱tu̱ko̱la a pu n pmai, ba su̱wa pma. Ba duuriya ikkilisiya, palaka ikkilisiya ba su̱wa wu̱tu̱ko̱la bu ji̱re̱ wa. ");
INSERT INTO wja_vpl VALUES ("T15_17","084_5_17","1TI","5","17","17","Bagi̱raa bu ni̱nga wu̱rai̱ pma kundi nu̱wa ba nyi̱i̱ gi̱ru̱ pero nu̱wa ba ya pma kundi, yaa ci̱ka bu kwasu̱gu̱ kwi̱i̱u̱ bo̱nggo̱ wasi̱gu̱ ci̱ye̱i̱ yi̱ pi̱rgu̱ nu̱wa. ");
INSERT INTO wja_vpl VALUES ("T15_18","084_5_18","1TI","5","18","18","Di̱ngi̱n De̱mte̱e̱re̱ ce̱ ki̱n, “Ma diini ya balantang a nyan go̱nto̱le̱ jo̱r du baci̱gu̱ jamau.>> Pero a bo̱nggo̱ wukange ki̱n, “Pma bu ni̱nga wu̱rai̱ wa a yinno nu̱wa ba ya pma.>> ");
INSERT INTO wja_vpl VALUES ("T15_19","084_5_19","1TI","5","19","19","Ma kari ya twiyau kwarame̱ wu nu̱wa de̱e̱ mo̱ we̱i̱ dwii bagi̱raa, ko̱po̱ ka nu̱wa ro̱p kana kunong ci̱ye̱i̱. ");
INSERT INTO wja_vpl VALUES ("T15_20","084_5_20","1TI","5","20","20","Bagi̱raa bu ni̱nga pu ni̱nggu̱ we̱le̱m wa, nu̱wa ba wun pma gawu̱r nu̱wa bu po̱nggu̱wa; yi̱to̱ yo̱o̱ we̱i̱ di̱kace̱ne̱ bo̱nggo̱ nu̱wa bukangga. ");
INSERT INTO wja_vpl VALUES ("T15_21","084_5_21","1TI","5","21","21","N wo̱o̱ sagu̱ mau a gawu̱ri̱ Yambau̱ yi̱ gawu̱ri̱ Kristo Yesu yi̱ bacamandi su se̱ki̱gai̱, ma po̱ng to̱o̱ te̱e̱ri̱ngi̱ yaa se̱ki̱gu̱ bukangga ba du kangga. ");
INSERT INTO wja_vpl VALUES ("T15_22","084_5_22","1TI","5","22","22","Ma yaliya se̱ki̱gu̱ bagi̱raa bu ikkilisiya wa yi̱ ce̱ri̱nggu̱ pma wari. Ma diini yaa dwii mai we̱le̱m nu̱wa bu kanggau. Ma si̱ya walwal. ");
INSERT INTO wja_vpl VALUES ("T15_23","084_5_23","1TI","5","23","23","Ma naa yaa gundu yi wundu. Ma naa gundu inabi banyi̱na di̱ngi̱n buu pwii mo̱u̱ yi̱ bu̱ri̱ mai su yaa sii cingcing. ");
INSERT INTO wja_vpl VALUES ("T15_24","084_5_24","1TI","5","24","24","Ma so̱ngma mi̱n we̱le̱m nu̱wa bu kangga dak a de̱r pma bali̱ su kanggi̱. Anda we̱le̱mdi̱ nu̱wa bu kangga tu̱ku̱gi̱ ko̱po̱ jo̱r du kanggi̱. ");
INSERT INTO wja_vpl VALUES ("T15_25","084_5_25","1TI","5","25","25","Yi̱to̱ mwaasi̱ wu̱rangi̱ nu̱wa tu nyaai dak, kana wu̱rangi̱ tu nu̱wa ni̱nga tu̱ku̱gi̱ nyanggu̱ ku kanggu̱ twiiwe we̱i̱ dak. ");
INSERT INTO wja_vpl VALUES ("T16_1","084_6_1","1TI","6","1","1","Mwa mwa ke̱waa ba nyi̱i̱ gi̱ru̱ bagi̱raa pma, palaka ba de̱e̱ yaa yi̱ri̱ me̱lmai̱ a dwii din Yambai̱ yi̱ yi̱ri̱ tu yi pi̱ryo̱. ");
INSERT INTO wja_vpl VALUES ("T16_2","084_6_2","1TI","6","2","2","Ka bagi̱raa bwii po̱nggu̱, ke̱we̱ ba kwaa yaa nyi̱i̱gu̱ pma gi̱ru̱ di̱ngi̱n twii kappi̱ma bu po̱nggu̱ wa. Ke̱waa ba ni̱nga wu̱rai̱ yi̱ kwasan kwiu wang di̱ngi̱n ba bagi̱raa pma bwii bu po̱nggu̱ wa pero kangman pma. Timoti, ma ju̱ku̱ to̱o̱ yi̱ri̱ngi̱, ma ciko kana we̱ ba ni̱nga po̱ngo̱ndi̱ yi̱ to̱no̱. ");
INSERT INTO wja_vpl VALUES ("T16_3","084_6_3","1TI","6","3","3","Ka nu̱wa ju̱ku̱r yi̱ri̱ leendi tu yaa ci̱ma ci̱maci̱ma yi̱ ce̱wi̱ tu nyaai tu Mbaa Wu Gi̱ra yi̱re̱ Yesu Kristo yi̱ tu yaa ci̱ma ci̱maci̱ma yi̱ pi̱su̱ wu Yamba kasu̱, ");
INSERT INTO wja_vpl VALUES ("T16_4","084_6_4","1TI","6","4","4","to̱o̱ le̱e̱gu̱ dwii pero yaa tu so̱mai̱. Ko̱ duu ne̱re̱ kasi̱ gwe̱la a dwii ce̱wi̱. To̱o̱ de̱e̱ bwiu yi̱ cwaanggu̱ bu̱ru̱ yi̱ rwe̱e̱ndi̱ pero yi̱ dwal le̱e̱gu̱ yi̱ bu̱ri̱. ");
INSERT INTO wja_vpl VALUES ("T16_5","084_6_5","1TI","6","5","5","Bo̱o̱ nu̱wa pma ni̱ng gwe̱la. Danggandi̱ pmai yaa kundi, pma kwaa ji̱re̱, dangani̱ ki̱n po̱nggu̱ Yamba twii nyo̱no̱u̱ kasi̱gu̱ gi̱nau̱. ");
INSERT INTO wja_vpl VALUES ("T16_6","084_6_6","1TI","6","6","6","Po̱nggu̱ Yambau̱ yi̱ gaanggu̱ leppek yi̱ri̱ ye̱i̱ to̱o̱ gi̱na. ");
INSERT INTO wja_vpl VALUES ("T16_7","084_6_7","1TI","6","7","7","Yi baanga bu si̱ma yi̱ kana ca pero yaa tu yi de̱ru̱ we̱i̱ ka yi wunni dugu. ");
INSERT INTO wja_vpl VALUES ("T16_8","084_6_8","1TI","6","8","8","Anda ka yi bo̱o̱ yi je̱e̱ndi̱ yi se̱e̱, yi ni̱nga gaanggu̱ leppek. ");
INSERT INTO wja_vpl VALUES ("T16_9","084_6_9","1TI","6","9","9","Anda nu̱wa bu kasi̱ gi̱na wang wa yaraman miyandi we̱le̱m yi̱ tandau yi̱ miyandi cini su de̱e̱ cu̱su̱gu̱, ba bwi̱i̱ge̱ piimaya mwa mwa. ");
INSERT INTO wja_vpl VALUES ("T16_10","084_6_10","1TI","6","10","10","Di̱ngi̱n kangam ke̱nu̱ to̱o̱ toson taawu̱ yi̱ri̱ngi̱ tu bwi̱i̱ tum. Anda nu̱wa bu kangga kasi̱gu̱ ke̱nu̱ a din pma po̱ranga bo̱nggo̱ le̱e̱gu̱ ji̱re̱ pero pma ji bu̱ri̱ pmai yi̱ bwiyang gaanggu̱. ");
INSERT INTO wja_vpl VALUES ("T16_11","084_6_11","1TI","6","11","11","Anda mo̱, Timoti, ne̱re̱ Yamba, ma cemin to̱o̱ yi̱ri̱ngi̱ mwa mwa. Ma kwasi̱ kwii tu̱mgu̱ tu nyaai yi̱ pi̱su̱ wu Yamba kasi̱ yi̱ le̱e̱gu̱ ji̱rau̱ yi̱ kangam yi̱ bo̱gu̱ gaanggu̱ yi̱ ci̱ngu̱ dwiu. ");
INSERT INTO wja_vpl VALUES ("T16_12","084_6_12","1TI","6","12","12","Ma ni̱nga kwai su nyaai di̱ngi̱n le̱e̱gu̱ ji̱re̱. Ma taa pi̱i̱ma bu yaa matuguwa, bu Yamba yimina mi̱rwa, pu ma ni̱nga bwiyanga gawu̱ri̱ nu̱wa tum. ");
INSERT INTO wja_vpl VALUES ("T16_13","084_6_13","1TI","6","13","13","N sa mi̱na a gawu̱ri̱ Yambai̱, yo̱ wu nyi̱i̱ pi̱i̱ma yi̱ri̱ngi̱ mwa mwa, yi̱ gawu̱ri̱ Yesu Kristo, wu ce̱ ci̱ye̱i̱ ji̱re̱ a dwii ye̱i̱ a gawu̱ri̱ Bilatus, ");
INSERT INTO wja_vpl VALUES ("T16_14","084_6_14","1TI","6","14","14","ma ni̱nga po̱ngo̱ndi̱ yi̱ to̱o̱ te̱e̱ri̱ngi̱ yaa dire, Ko̱po̱ ka Mba Wu gi̱ra Yesu Kristo waatai. ");
INSERT INTO wja_vpl VALUES ("T16_15","084_6_15","1TI","6","15","15","Yamba wu yi̱ wuure, Yo̱ wu Gi̱ra, balaa balamba yi̱ Mba Wu gi̱ra wu mba wu gi̱randi̱ wu de̱e̱ we̱i̱ Kristo a jo̱r ye̱i̱. ");
INSERT INTO wja_vpl VALUES ("T16_16","084_6_16","1TI","6","16","16","Yo̱ wundu wu yaa bo̱o̱ri̱, wo̱o̱ yi̱ pi̱i̱ma, si̱i̱ rang wu yaa ne̱re̱ wu lam ne̱m, wu yaa ne̱re̱ wu ko̱ pero yaa wu kwe̱e̱ we̱i̱. Gi̱ru̱ yi̱ di̱mbi̱re̱ ko̱ yo̱u̱ kana pe̱ne̱ pe̱ne̱! Amin. ");
INSERT INTO wja_vpl VALUES ("T16_17","084_6_17","1TI","6","17","17","Ma sa pma bu yi̱ gi̱na pi̱naa si̱ma ba le̱e̱ yaa dwii, ba mani ya ni̱i̱ a gi̱na wu yaa si̱i̱. Anda ba man ni̱i̱ a bo̱nggo̱ Yambau̱, wu nyi̱i̱ yi̱ri̱ kana ca di̱ngi̱n nu̱u̱gu̱ tengu yiru. ");
INSERT INTO wja_vpl VALUES ("T16_18","084_6_18","1TI","6","18","18","Ma sa pma ba ni̱nga yi̱ri̱ tu kundi, ba ni̱nga wu̱rangi̱ tu nyaai tum, ba ni̱nga ni̱i̱ pero ba cwaanga yi̱ bu kangga. ");
INSERT INTO wja_vpl VALUES ("T16_19","084_6_19","1TI","6","19","19","Bo̱nggo̱ ni̱nggu̱ yi̱ to̱o̱, pma rumanu we̱i̱ betal bu̱ri̱ pmai̱ wu twii taa pi̱su̱ pmau pi̱na yi̱ gawu̱re̱, di̱ngi̱n pma ba nyi̱nggu̱ we̱i̱ pi̱i̱ma bu manggu wa. ");
INSERT INTO wja_vpl VALUES ("T16_20","084_6_20","1TI","6","20","20","Timoti, ma ni̱ng wu̱rai̱ du Yamba nyi̱mi̱na. Ma de̱man dwii mai bo̱nggo̱ ce̱wi̱ tu nyoi tu yaa walwal yi̱ so̱mandi̱ tu twii leendi ");
INSERT INTO wja_vpl VALUES ("T16_21","084_6_21","1TI","6","21","21","Nu̱wa bu kangga po̱ro̱nga bo̱nggo̱ le̱e̱gu̱ ji̱rau̱ di̱ngi̱n po̱ngi̱ to̱o̱ cini. Bo̱o̱ni̱i̱ Yambau̱ ba si̱ya kem yi̱ mba.");
INSERT INTO wja_vpl VALUES ("T21_1","085_1_1","2TI","1","1","1","Ti̱na lakargar Bulus, Wu Yamba se̱ka cu̱u̱ngi̱ dangandi̱ ye̱i̱ ba yo̱o̱ ne̱re̱ tu̱mandi̱ wu Yesu Masiya. Yamba tu̱ngge̱ n sa nu̱wa ci̱ye̱i̱ pi̱i̱mai̱ bu ni̱nga alkawal wa a bo̱nggo̱ Yesu Masiya. ");
INSERT INTO wja_vpl VALUES ("T21_2","085_1_2","2TI","1","2","2","N balami̱n Timoti bo̱l mi wu n kangne̱. Bo̱o̱ ni̱i̱u̱ yi̱ bunam yi̱ pi̱dau̱ gaanggu̱ wu Yamba Kwiite yi̱ Mbaa Wu Gi̱ra Yesu Masiya ba si̱ya kem yi̱ mo̱. ");
INSERT INTO wja_vpl VALUES ("T21_3","085_1_3","2TI","1","3","3","Timoti, n wanan Yamba di̱ngi̱n mo̱, Yamba wu n ku̱raman yo̱ si̱ma yi dangandi̱ tu nyaai, ci̱ka ku kakaa muwa ni̱ngau̱. Ku̱me̱ yi nyanggu̱, n dangga mi̱ni̱ mi̱ri̱nggu̱ kuru mu kana do̱no̱ jo̱re̱. ");
INSERT INTO wja_vpl VALUES ("T21_4","085_1_4","2TI","1","4","4","N kasi̱ n ko̱mi̱na do̱ng, di̱ngi̱n n danggu̱ gwer me̱rma ma pu yi̱ cwangu bu̱ru̱. Pero n ni̱ngu̱ we̱i̱ bu̱ri̱ de̱gde̱g ka yi kiino do̱ng. ");
INSERT INTO wja_vpl VALUES ("T21_5","085_1_5","2TI","1","5","5","N dangga le̱e̱gu̱ ji̱rau̱ mau ku manggu, ci̱ka ku kaka mo̱ Lowis yi̱ njaa mo̱ Yunis bo̱o̱ yi̱ to̱no̱. Pero n so̱ma ma wo̱o̱ yi̱ ko̱o̱ le̱e̱gu̱ ji̱rau̱. ");
INSERT INTO wja_vpl VALUES ("T21_6","085_1_6","2TI","1","6","6","To̱o̱ tu diinai n dangga mi̱na mi̱n, ma je̱e̱ gawu̱re̱ yi ni̱i̱ du Yamba nyi̱mi̱na a jo̱rdu̱ n ce̱rmi̱n wari̱. ");
INSERT INTO wja_vpl VALUES ("T21_7","085_1_7","2TI","1","7","7","Di̱ngi̱n Yamba nyi̱i̱ yi̱ri̱ bu bawei gwasi̱, a nyi̱i̱ yir du di̱mbi̱ri̱, yi̱ kangam yi̱ tagu dwiu. ");
INSERT INTO wja_vpl VALUES ("T21_8","085_1_8","2TI","1","8","8","Di̱ngi̱n to̱no̱ ma nu̱u̱ yaa me̱lma sagu̱ nu̱wa ci̱ye̱i̱ dwii Mba Wu gi̱ra yire. Pero ma nu̱u̱ yaa me̱lma muwa, kana ku n wo̱o̱ jaru̱m di̱ngi̱n yo̱. Mo̱ mwaasi̱ ma cu̱su̱ we̱i̱ kem yi mi yi di̱mbi̱r wu Yamba nyi̱mi̱na di̱ngi̱n ci̱ye̱i̱ du teng . ");
INSERT INTO wja_vpl VALUES ("T21_9","085_1_9","2TI","1","9","9","Yo̱ mi̱ra yiro yi ni̱nga pi̱su̱ wu walwal. Ni̱nga bu yi̱to̱ di̱ngi̱n wu̱rangi̱ yiri tu nyaii anda to̱o̱ dangandi̱ ye̱i̱ yake̱ toson taayau, palaka ba ju̱ku̱ bo̱o̱ni̱i̱ yo̱u̱ ku bo̱nggo̱ Yesu Masiya. ");
INSERT INTO wja_vpl VALUES ("T21_10","085_1_10","2TI","1","10","10","Anda yo̱ko̱ a ju̱ki̱ yiri to̱o̱ yi̱ri̱ mwa mwa ge̱mbe̱l , bo̱nggo̱ bagu̱ Yesu Masiya, ne̱re̱ mi̱rma yire. A kiyanga di̱mbi̱r bo̱o̱re̱ pero a ju̱ki̱ nyinou pi̱i̱mau̱ bu yaa mati̱r wa a bo̱nggo̱ ci̱ye̱i̱ du teng. ");
INSERT INTO wja_vpl VALUES ("T21_11","085_1_11","2TI","1","11","11","Yamba se̱kangge̱ n yo̱ ne̱re̱ wu wasi̱r ci̱ye̱i̱, yi̱ ne̱re̱ tu̱mandi̱ yi̱ ne̱re̱ wu ju̱ku̱r ci̱ye̱i̱ du teng. ");
INSERT INTO wja_vpl VALUES ("T21_12","085_1_12","2TI","1","12","12","To̱o̱ tu diinai n wo̱o̱ cu̱su̱gu̱ a jaru̱m. Anda n yaa nu̱u̱gu̱ melmau, di̱ngi̱n n so̱m wu n le̱e̱ ji̱re̱ yi̱ yo̱, pero n so̱ma puu we̱i̱ swe̱ri̱gu̱ tu nyi̱i̱nggi̱ ko̱po̱ nyanggu̱ ku yo̱ waata wau. ");
INSERT INTO wja_vpl VALUES ("T21_13","085_1_13","2TI","1","13","13","Ma ti̱na ce̱wi̱ tu nyaai tu ma nu̱wa bo̱nggo̱ mu mwa mwa, ba yo̱o̱ nyinou wu ma po̱ng we̱i̱. Ma si̱ya yi̱ le̱e̱gu̱ ji̱rau̱ yi̱ kangam wu yi̱ bo̱o̱ yi̱ to̱no̱ a bo̱nggo̱ Yesu Masiya. ");
INSERT INTO wja_vpl VALUES ("T21_14","085_1_14","2TI","1","14","14","A bo̱nggo̱ di̱mbi̱r bawei du walwal du wo̱o̱ kem yi̱ yo, ma swe̱ra yi̱ri̱ng tu nu̱wa nyi̱mi̱na kundi. ");
INSERT INTO wja_vpl VALUES ("T21_15","085_1_15","2TI","1","15","15","Ci̱ka ku ma so̱ma, mwa mwa nu̱wa bu po̱nggu̱wa bu si̱ma Asiya a kwaangge̱ ban Pijelus yi̱ Amajenes. ");
INSERT INTO wja_vpl VALUES ("T21_16","085_1_16","2TI","1","16","16","Yama Mba Wu gi̱ra ba nu̱u̱ bunam laa Onisiporus mwa mwa di̱ngi̱n baa su̱wanggi̱ nyikirik pero ci̱ke̱nggi̱. Yaa ku nu̱u̱ me̱lma muwa ki̱n di̱ngi̱n n wo̱o̱ cali̱gi̱ yi̱ cali̱. ");
INSERT INTO wja_vpl VALUES ("T21_17","085_1_17","2TI","1","17","17","Ka ba Roma, kasangi̱ kana pi̱yau̱ ko̱po̱ ka ko̱nggi̱. ");
INSERT INTO wja_vpl VALUES ("T21_18","085_1_18","2TI","1","18","18","Yama Mba Wu gi̱ra ba nu̱u̱ bunam yo̱u̱ nyanggu̱ ku Masiya waata wau, Pero mo̱, ma so̱mgi̱ du kalanggu̱ ku ni̱ngangi̱na a Apisa. ");
INSERT INTO wja_vpl VALUES ("T22_1","085_2_1","2TI","2","1","1","Timoti, bo̱l mi ma ni̱nga di̱mbi̱re̱ bo̱nggo̱ bo̱o̱ni̱i̱ ku Yamba nyi̱i̱ yiro bo̱nggo̱ Yesu Masiya. ");
INSERT INTO wja_vpl VALUES ("T22_2","085_2_2","2TI","2","2","2","Yi̱ri̱ tu ma nu̱u̱ngge̱ pi̱r ye̱i̱ a gawu̱ri̱ nu̱wa tum, ma pi̱ri̱ to̱o̱ yi̱ri̱ nu̱wa bu yi̱ ji̱re̱ wa bu pma ka pi̱rdu̱ we̱i̱ bu kangga. ");
INSERT INTO wja_vpl VALUES ("T22_3","085_2_3","2TI","2","3","3","Ma bo̱ gaanggu̱ bo̱nggo̱ cu̱su̱gu̱ kem yi̱ mi, ci̱ka kacala Yesu Masiya wu nyaa. ");
INSERT INTO wja_vpl VALUES ("T22_4","085_2_4","2TI","2","4","4","Kacara yaa casin bu̱ri̱ nu̱wa, di̱ngi̱n ka pma ni̱ngi̱ yi̱to̱ yaa ku di̱ramanu̱ we̱i̱ gaanggu̱ ne̱re̱ wu gi̱ra pmo wu de̱ pma wu̱rai̱. ");
INSERT INTO wja_vpl VALUES ("T22_5","085_2_5","2TI","2","5","5","Pero nu̱wa bu ni̱ngi̱ kakari̱ curi wa, yaa ku nyi̱nggu̱ we̱i̱ wo̱ri̱ri̱ ko̱po̱ ka po̱ng te̱e̱ri̱ kakari̱. ");
INSERT INTO wja_vpl VALUES ("T22_6","085_2_6","2TI","2","6","6","Pero bajo̱me̱ wu ni̱ng wu̱rai̱ yi̱ kwasankwiu tagi̱ yo̱o̱ we̱i̱ wu gawu̱ri̱yo̱ wu nyi̱nggu̱ we̱i̱ wo̱ri̱ri̱ jangam wu̱rangi̱ ye̱i̱. ");
INSERT INTO wja_vpl VALUES ("T22_7","085_2_7","2TI","2","7","7","Ma ni̱nga dangandi̱ a dwii tu n ce̱gu̱i̱, Mba Wu gi̱ra kalami̱nu̱ we̱i̱ ma ku̱ranga to̱o̱ yi̱ri̱ngi̱ mwa mwa. ");
INSERT INTO wja_vpl VALUES ("T22_8","085_2_8","2TI","2","8","8","Ma si̱ya danggu̱ yi̱ Yesu Masiya, kaka balaa Dawud, wu wuni a bo̱o̱re̱. To̱o̱ ci̱ye̱i̱ du teng du n wasi̱ri̱, ");
INSERT INTO wja_vpl VALUES ("T22_9","085_2_9","2TI","2","9","9","di̱ngi̱n to̱no̱, n cu̱su̱gu̱ pero nu̱wa calange̱ yi̱ cali̱ ci̱ka ne̱re̱ wu we̱lgi̱. Anda nu̱wa na puu cali̱gu̱ ci̱ye̱i̱ Yambai̱. ");
INSERT INTO wja_vpl VALUES ("T22_10","085_2_10","2TI","2","10","10","Di̱ngi̱n to̱no̱ n le̱e̱ n bo̱ gaanggu̱ yi̱ kana ca di̱ngi̱n nu̱wa bu Yamba se̱ka wa palaka ba nyi̱ngga mi̱rma yi yi̱lau̱ ku mi̱ri̱nggu̱ Yesu Masiya. ");
INSERT INTO wja_vpl VALUES ("T22_11","085_2_11","2TI","2","11","11","Ti̱na ci̱ye̱i̱ du ji̱re̱i̱: Ka yi bwaani kem yi̱ yo̱, yi si̱i̱ we̱i̱ kem yi̱ yo̱ mwaasi̱. ");
INSERT INTO wja_vpl VALUES ("T22_12","085_2_12","2TI","2","12","12","-Ka yi bo̱r gaanggu̱ bo̱nggo̱ ti̱i̱gu̱ ku̱u̱lu̱, yi je̱e̱ we̱i̱ lau̱ kem yi̱ yo̱. Ka yi kwa yo̱ yi ka mwa kwa yi̱ri̱ we̱i̱. ");
INSERT INTO wja_vpl VALUES ("T22_13","085_2_13","2TI","2","13","13","Ka yi ni̱ngi̱ dwal ji̱re̱i̱ yo̱ yiri ye̱i̱ sam sam yi̱ ji̱re̱, di̱ngi̱n yo̱ na pu ba kwa bu̱ri̱ ye̱i̱. ");
INSERT INTO wja_vpl VALUES ("T22_14","085_2_14","2TI","2","14","14","Ma dangga kana we̱ yi̱ to̱o̱ yi̱ri̱ngi̱, ma ye̱ra pma a gawu̱ri̱ Yambai̱ ba lara gwe̱la a dwii ce̱wi̱. Di̱ngi̱n ko̱o̱ duu gwe̱la yaa kundi, pero bwiyanni nu̱wa bu pma nu̱u̱gu̱ wa. ");
INSERT INTO wja_vpl VALUES ("T22_15","085_2_15","2TI","2","15","15","Ma ni̱nga wu̱rai̱ yi̱ kwasam kwiu palaka Yamba ba wandi̱ mi̱na. Ma yo̱ ne̱re̱ wu̱rai̱ wu nyaa, wu yaa ku nu̱u̱ we̱i̱ me̱lma, wu ju̱ki̱r ci̱ye̱i̱ ji̱re̱i̱ ci̱maci̱ma cima. ");
INSERT INTO wja_vpl VALUES ("T22_16","085_2_16","2TI","2","16","16","Ma kwaa ce̱wi̱ tu nyoi, yi̱ ce̱wi̱ cini tu cwati ni̱nga wu yaa kundi. ");
INSERT INTO wja_vpl VALUES ("T22_17","085_2_17","2TI","2","17","17","To̱o̱ ce̱wi̱ wasi̱ri̱ si̱yau̱ ci̱ka benteng, Yimenawus yi̱ Pilitus ju̱ku̱ya to̱o̱ yi̱ri̱ngi̱. ");
INSERT INTO wja_vpl VALUES ("T22_18","085_2_18","2TI","2","18","18","Pma du nyinou ji̱rau̱, pma ce̱gu̱ ki̱n wunongu bo̱o̱ru̱ me̱re̱ a cwiiyo; yi̱to̱ a din nu̱wa bu kangga du le̱e̱gu̱ ji̱rau̱. ");
INSERT INTO wja_vpl VALUES ("T22_19","085_2_19","2TI","2","19","19","Anda ji̱re̱i̱ Yamba ti̱ndi̱ ti̱yau̱ ci̱ka swe̱li̱ du taa mwe̱e̱ndi̱, balinggi wuna bala: “MBA WU GI̱RA so̱m bo̱o̱ ya,>> pero “Mwa mwa bu yo̱o̱gi̱ bu MBA WU GI̱RA wa tagi̱ ba kwaa tu bwi̱i̱.>> ");
INSERT INTO wja_vpl VALUES ("T22_20","085_2_20","2TI","2","20","20","A laa wu duwe, se̱e̱ je̱e̱ndi̱ wu kangge̱ me̱ne̱nggi̱ yi sinariya yi̱ asurpa, pero wu kangge̱ me̱ne̱nggi̱ yi̱ souwi yi̱ gari. Se̱e̱ wu yi̱ pi̱rcu̱ nu̱wa ni̱ndi̱ wu̱rai̱ a jo̱ro̱ndi̱ waandi, anda wu yaa pi̱rcu̱ nu̱wa ni̱ndi̱ wu̱rai̱ kana ko̱no̱ nyanggu̱. ");
INSERT INTO wja_vpl VALUES ("T22_21","085_2_21","2TI","2","21","21","Kana we̱ ka cardi bu̱ri̱ ye̱i̱, du̱r to̱o̱ yi̱ri̱ngi̱ tu bwi̱i̱, yo̱o̱ we̱i̱ se̱e̱ wu̱rai̱ wu yi̱ yi̱lau̱. Yo̱ ni̱ngu̱ we̱i̱ walwal, me̱ne̱nggi̱ di̱ngi̱n Ne̱re̱ wu gi̱ra ba ni̱ng kana do̱no̱ wu̱rai̱ du nyaai. ");
INSERT INTO wja_vpl VALUES ("T22_22","085_2_22","2TI","2","22","22","Ma cemin kana to̱no̱ yi̱ri̱ tu de̱e̱ miyam wu bo̱bi̱ri̱. Ma kasa pi̱su̱ wu nyaau a gawu̱ri̱ Yambai̱ yi̱ ji̱re̱ yi̱ kangam yi̱ pi̱dau̱ gaanggu̱. Ma ni̱nga to̱o̱ yi̱ri̱ngi̱ kem yi̱ nu̱wa bu ku̱raman si̱ma Yamba yi̱ gaanggu̱ walwal. ");
INSERT INTO wja_vpl VALUES ("T22_23","085_2_23","2TI","2","23","23","Pero n wo̱o̱ sagu̱ mau ma diini ya dwii mai gwe̱la wu ciniyo wu yaa kundi wu de̱e̱ kwai. ");
INSERT INTO wja_vpl VALUES ("T22_24","085_2_24","2TI","2","24","24","Ke̱we̱ Yamba tagi̱ ba caari̱ ya anda ma ni̱nga man kana we̱ kangam, ma puu pi̱rgu̱ yi̱ri̱ nu̱wa, ma ta kanadi yi nu̱wa. ");
INSERT INTO wja_vpl VALUES ("T22_25","085_2_25","2TI","2","25","25","Ma cingo miu ka ma sagu̱ ci̱ye̱i̱ nu̱wa bu kwaa ji̱re̱ wa. Yikwii Yamba waku we̱i̱ gaanggi̱ri̱ bo̱o̱ nu̱wa, pma ti̱lanu̱ we̱i̱ ji̱re̱. ");
INSERT INTO wja_vpl VALUES ("T22_26","085_2_26","2TI","2","26","26","Pma watanga we̱i̱ mi̱ri̱nggu̱ dangandi̱ pmai, pma gwalu we̱i̱ tandau balaa buwai. Di̱ngi̱n a re̱e̱ pma ke̱wu̱ri̱ ba ni̱nga tu yo̱ kasi̱ pma ba ni̱nga. ");
INSERT INTO wja_vpl VALUES ("T23_1","085_3_1","2TI","3","1","1","Timoti, n kasi̱ ma̱ so̱ma, nyanggu̱ ku cwata go̱ro̱u̱ yo̱o̱ we̱i̱ jo̱r du yi̱ buyi wang. ");
INSERT INTO wja_vpl VALUES ("T23_2","085_3_2","2TI","3","2","2","Nu̱wa kang manu we̱i̱ bu̱ri̱ pmai, ni̱ng we̱i̱ yawo. Pma ni̱ngu̱ we̱i̱ Go̱rso̱ndi̱ yi̱ le̱e̱gu̱ dwii, nu̱wa bu yi̱ ru̱ni̱ wa, yaa po̱ngo̱ndi̱ yi̱ kwiimba pma, yaa wandi̱ma. pero nu̱wa bu yaa gwasi̱ Yamba wa. ");
INSERT INTO wja_vpl VALUES ("T23_3","085_3_3","2TI","3","3","3","Pma yo̱o̱ we̱i̱ yaa kangam, yaa pargu̱ su̱ku̱m, pma bwiyani we̱i̱ dine pero yaa tar dwii. Pma yo̱ we̱i̱ yi̱ tu̱we̱ pero kwaa we̱i̱ yi̱ri̱ tu nyaai. ");
INSERT INTO wja_vpl VALUES ("T23_4","085_3_4","2TI","3","4","4","Pma cuuru we̱i̱ basi̱mba pma, pma ni̱ng yi̱ri̱ yaa dangandi̱, pma twanggi yi̱ le̱e̱gu̱ dwii, pma kasi̱ tengu gwala po̱nggu̱ Yambau̱. ");
INSERT INTO wja_vpl VALUES ("T23_5","085_3_5","2TI","3","5","5","Pma ni̱ngu̱ we̱i̱ ci̱ka pma so̱m Yamba anda pma kwaa di̱mbi̱ri̱ yo̱. Ma ni̱nga kwaraa yi̱ bo̱o̱ nu̱wa! ");
INSERT INTO wja_vpl VALUES ("T23_6","085_3_6","2TI","3","6","6","Pma to̱o̱ nu̱wa bu teendi laandi nu̱wa wa, ba lelengo nu̱ru̱mba bu yaa pwi̱yanggi̱ wa, bu we̱le̱m turonggu pma wa, pero twanggi yi̱ miyandi wundu wundu. ");
INSERT INTO wja_vpl VALUES ("T23_7","085_3_7","2TI","3","7","7","Bo̱o̱ nu̱ru̱mba kana pe̱ne̱ pma po̱nggu̱ yi̱ri̱ tu pu̱ci̱ tu nu̱wa pi̱r pmai, anda pma jaanga so̱mgu̱ ji̱re̱u̱. ");
INSERT INTO wja_vpl VALUES ("T23_8","085_3_8","2TI","3","8","8","Bo̱o̱ ku̱lu̱mba kwaa ji̱re̱ ci̱ka Jannes yi̱ Jambires bu gwe̱la Musa wa. Danggadi̱ pmai yaa kundi, pero yi̱ le̱e̱gu̱ ji̱rau̱ kwii ku nyou. ");
INSERT INTO wja_vpl VALUES ("T23_9","085_3_9","2TI","3","9","9","Anda pma na je̱e̱ gawu̱re̱ a bo̱nggo̱ to̱o̱ yi̱ri̱. Kana we̱ so̱mu̱ we̱i̱ cini pmai ci̱ka ku ni̱ngwa yi̱ bu Jannes yi̱ Jambires . ");
INSERT INTO wja_vpl VALUES ("T23_10","085_3_10","2TI","3","10","10","Anda mo̱, Timoti, Ma so̱m tu n pi̱r ye̱i̱ yi̱ pi̱su̱ wu n ni̱ngau̱, yi̱ yi̱ri̱ tu n manna gawu̱ri̱. Ma so̱m le̱e̱gu̱ ji̱rau̱ mu yi̱ kanadi mi yi̱ kangam mu yi̱ bo̱gu̱ gaanggu̱ mu. ");
INSERT INTO wja_vpl VALUES ("T23_11","085_3_11","2TI","3","11","11","Ma so̱m nyindi su nu̱wa turongge yi̱ ku̱u̱le̱ wu n bo̱o̱ gaanggu̱ mi̱ru̱. Ma so̱m mwa mwa turonggu ku nu̱wa ni̱ngangi̱na a Antakiya, yi̱ Ikoniya, yi̱ Listura anda Yamba mi̱rangge̱. ");
INSERT INTO wja_vpl VALUES ("T23_12","085_3_12","2TI","3","12","12","N sagu̱mo̱u̱ ji̱re̱, kana we̱ wu ka kasi̱ ba ni̱nga pi̱su̱ wu Yamba kasu̱ mi̱ri̱nggi̱ Yesu Masiya tii we̱i̱ ku̱u̱le̱. ");
INSERT INTO wja_vpl VALUES ("T23_13","085_3_13","2TI","3","13","13","Anda nu̱wa bu bwi̱i̱wa yi̱ nu̱wa bu yi̱ lelu wa gwalanu̱ we̱i̱ bwi̱i̱ge̱. Pma ciyonu we̱i̱ nu̱wa bu kangga yi̱ bu̱ri̱ pmai mwaasi̱. ");
INSERT INTO wja_vpl VALUES ("T23_14","085_3_14","2TI","3","14","14","Anda mo̱, ma ti̱na ji̱re̱i̱ yi̱ri̱ngi̱ tu ma ti̱langa. Ma so̱ma to̱o̱ ji̱re̱i̱, di̱ngi̱n ma so̱m pma bu ju̱ku̱ mi̱na wa. ");
INSERT INTO wja_vpl VALUES ("T23_15","085_3_15","2TI","3","15","15","Nu̱wa ju̱ku̱ mi̱n Lakargar Yamba yake̱ pu ma babwi̱yayo̱ pero pma pi̱rmi̱n pwii du diina ma yi̱ mi̱rma bo̱nggo̱ le̱e̱gu̱ ji̱re̱ yi̱ Yesu Masiya. ");
INSERT INTO wja_vpl VALUES ("T23_16","085_3_16","2TI","3","16","16","Mwa mwa Lakargar Yamba to̱o̱ ci̱ye̱i̱ du baa bo̱nggo̱ Yambai̱. Kundi di̱ngi̱n pi̱rgu̱ ji̱re̱, ye̱ra yiri yi̱ ku̱ranga yi̱ri̱ tu yaa kundi, me̱na yiri ka yi̱ ni̱ngi̱ tu yaa kundi, pero ju̱ku̱ yiri pi̱su̱ nyaau a gawu̱ri̱ Yambai̱. ");
INSERT INTO wja_vpl VALUES ("T23_17","085_3_17","2TI","3","17","17","Yamba ni̱ndi̱ wu̱rai̱ yi̱ to̱no̱ ba me̱ne̱nga, ba ci̱pa nu̱wa ya di̱ngi̱n kana do̱no̱ wu̱rangi̱ du nyaai. ");
INSERT INTO wja_vpl VALUES ("T24_1","085_4_1","2TI","4","1","1","N wo̱o̱ sa mi̱n di̱na ci̱ye̱i̱ a gawu̱ri̱ Yambai̱ yi̱ Yesu Masiya, yo̱ wu nyanggu̱ ku punge ni̱ngamanu̱ we̱i̱ bali̱ nu̱wa bu ku̱ri̱i̱ yi̱ bu bwaangii wa ka baa je̱gu̱ lau̱ yau̱, ");
INSERT INTO wja_vpl VALUES ("T24_2","085_4_2","2TI","4","2","2","ma wasi̱ ci̱ye̱i̱ Yambai̱, kana jo̱r do̱o̱ kana yaa ne̱, ma me̱ne̱nga pma, ma ye̱ra pma, ma ci̱ko̱ pma kem yi̱ kanadi wang yi̱ ju̱ku̱gu̱ yi̱ri̱. ");
INSERT INTO wja_vpl VALUES ("T24_3","085_4_3","2TI","4","3","3","Di̱ngi̱n jo̱r do̱o̱ baayi du nu̱wa na kar twiyau kana ca tu cima ci̱maci̱ma tu nu̱wa ju̱ku̱ya. Pma po̱nggu̱ we̱i̱ tu gaanggu̱ pmai pero pma kasi̱ we̱i̱ ku̱lu̱mba bu saru we̱i̱ tu twendi pmai kasi̱ nu̱u̱gi̱. ");
INSERT INTO wja_vpl VALUES ("T24_4","085_4_4","2TI","4","4","4","Pma kwaa we̱i̱ ji̱re̱ anda kasi̱ we̱i̱ nu̱u̱gu̱ bacindi. ");
INSERT INTO wja_vpl VALUES ("T24_5","085_4_5","2TI","4","5","5","Anda mo̱, ma taa dwii mai bo̱nggo̱ kana ca. Ma nu̱u̱ yaa gwasi̱ ti̱gu̱ ku̱u̱lu̱ di̱ngi̱n Mba Wu gi̱ra. Ma ni̱nga sagu̱ nu̱wa ci̱ye̱i̱ du teng, ma ni̱nga kana do̱no̱ wu̱rai̱ du Yamba nyi̱i̱ mi̱nai̱. ");
INSERT INTO wja_vpl VALUES ("T24_6","085_4_6","2TI","4","6","6","Ci̱ka mi kam, n nyi̱i̱ pi̱i̱ma muwa ba yo̱o̱ ni̱i̱ bo̱nggo̱ Yambau̱. Jo̱r bo̱o̱ri̱ mi a ni̱nga ne̱m. ");
INSERT INTO wja_vpl VALUES ("T24_7","085_4_7","2TI","4","7","7","N ni̱nga kwai su nyaai, n mata wu̱rai̱ mi, n taa le̱e̱gu̱ ji̱re̱. ");
INSERT INTO wja_vpl VALUES ("T24_8","085_4_8","2TI","4","8","8","Anda yo̱ko̱ wo̱ri̱ri̱ me̱tu̱wal wu̱rangi̱ tu nyaai wo̱o̱ nyanggu̱ mu, wu Mba Wu gi̱ra, wu ni̱ng bali̱ su ji̱re̱i̱, nyi̱i̱nggu̱ we̱i̱ a nyanggu̱ ku waatau. Anda wo̱ri̱ri̱ twii bu̱ri̱ mi yi̱ wundu ne̱ anda kana we̱ wu yanggu bagu̱ yo̱u̱ wa. ");
INSERT INTO wja_vpl VALUES ("T24_9","085_4_9","2TI","4","9","9","Timoti, kankam kwasi̱ kwi̱i̱ ma bame̱ ki̱lang ki̱lang. ");
INSERT INTO wja_vpl VALUES ("T24_10","085_4_10","2TI","4","10","10","Dimas kwaangge di̱ngi̱n kangman yi̱ri̱ngi̱ tu si̱mai̱, a mwati̱ Tasalonika, Kerisens, a mwati̱ Galatiya pero Titus mwati̱ Dalmatiya. ");
INSERT INTO wja_vpl VALUES ("T24_11","085_4_11","2TI","4","11","11","Wu pi̱na bo̱nggo̱ mu bu̱ri̱ Luka. Ma de̱ngu̱we̱ rau yi̱ Markus ka wunuwe bagu̱ di̱ngi̱n kalanggu̱ we̱i̱ a wu̱rai̱ mi. ");
INSERT INTO wja_vpl VALUES ("T24_12","085_4_12","2TI","4","12","12","N tu̱m Tikikus a Apisa. ");
INSERT INTO wja_vpl VALUES ("T24_13","085_4_13","2TI","4","13","13","Ka ma wunuwe bagu̱ ma de̱ngu̱we̱ landau ko̱ro̱ro̱u̱ mu a bo̱nggo̱ Karpus a Tarwasa. ");
INSERT INTO wja_vpl VALUES ("T24_14","085_4_14","2TI","4","14","14","Aleksanda bakwiiya a ni̱ngangi̱n yi̱ri̱ tu bwi̱i̱ kwang kwang, anda Mbaa Wu Gi̱ra ni̱nga manu we̱i̱ yo̱ bali̱ a dwii yi̱ri̱ tu ni̱ngai̱. ");
INSERT INTO wja_vpl VALUES ("T24_15","085_4_15","2TI","4","15","15","Ma ruun tu̱we̱ a dwii ye̱i̱, di̱ngi̱n yo̱ ni̱ngga ce̱re̱ wang yi̱ kana ca tu yi ci̱ye̱i̱. ");
INSERT INTO wja_vpl VALUES ("T24_16","085_4_16","2TI","4","16","16","Ku gawu̱ri̱yo̱ nu̱wa de̱ngge̱ bo̱nggo̱ nu̱wa baluwa, yaa ne̱re̱ wiino wu baa kem yi̱ mi. Kana we̱ a kwaangge. Yama do̱o̱ bali̱ ba yo̱ yaa a dwii pmai. ");
INSERT INTO wja_vpl VALUES ("T24_17","085_4_17","2TI","4","17","17","Anda Mba Wu gi̱ra kalangge̱ a nyi̱nggi̱ di̱mbi̱re̱ palaka n pu wasi̱ ci̱ye̱i̱ du teng mwa mwa, a bo̱nggo̱ nu̱wa bu yaa yo̱o̱gi̱ nu̱wa bu Yudaya wa ba nu̱wa mwa mwa. Pero a mi̱rangge̱ bo̱nggo̱ bo̱o̱re̱. ");
INSERT INTO wja_vpl VALUES ("T24_18","085_4_18","2TI","4","18","18","Anda Mba Wu gi̱ra yikungu we̱i̱ bo̱nggo̱ yi̱ri̱ tu bwi̱i̱ a de̱ngge̱ lau̱ ku diyou cingcing. Mwa mwa yi̱lau̱ a bo̱nggo̱ Yambau̱ kana pe̱ne̱ pe̱ne̱! Amin. ");
INSERT INTO wja_vpl VALUES ("T24_19","085_4_19","2TI","4","19","19","Ma lam ci̱i̱ma muwa Piriskila yi̱ Akwila yi̱ pma bu pi̱si̱ndi̱ laa Onisibaporus. ");
INSERT INTO wja_vpl VALUES ("T24_20","085_4_20","2TI","4","20","20","Arastus a ti̱n ti̱ye̱i̱ a Korinti, pero n du Tiropimus yaa cingcing a Miletus. ");
INSERT INTO wja_vpl VALUES ("T24_21","085_4_21","2TI","4","21","21","Ma kwasi̱ kwii ma baa bo̱nggo̱ mu bo̱o̱ karang ni̱nga bu. Ebulus a tu̱mu̱we̱ cima ma, pero Pudens yi̱ Linus yi̱ Kilaudiya yi̱ mwa mwa ci̱yamba bu nambi̱rmba yi̱ bu nu̱ru̱mba wa. ");
INSERT INTO wja_vpl VALUES ("T24_22","085_4_22","2TI","4","22","22","Yama Mbaa Wu Gi̱ra ba si̱ya kem yi̱ bawei mai. Pero Yama bo̱o̱ni̱i̱ yo̱u̱ ba si̱ya yi̱ mba mwa mwa.");
INSERT INTO wja_vpl VALUES ("PM1_1","087_1_1","PHM","1","1","1","wunaa lakargar a baa bo̱nggo̱ Bulus, wu nu̱wa manna jaru̱m di̱ngi̱n wasu̱gu̱ ci̱ye̱i̱ du teng a dwii Yesu Kristo, yi bo̱nggo̱ bago̱nyo̱ Timoti. N balgu̱ mau Pilimon, bago̱n wu̱rai̱ yire wu yi̱ kanggi̱, ");
INSERT INTO wja_vpl VALUES ("PM1_2","087_1_2","PHM","1","2","2","yi bago̱n yire wu nu̱re̱ Apiya, pero yi bago̱n yir kacala Arkipus, yi nu̱wa bu po̱nggu̱ bu ku̱rang bu̱ri̱ a laa mau. ");
INSERT INTO wja_vpl VALUES ("PM1_3","087_1_3","PHM","1","3","3","Yama Yamba mbaa yire yi̱ Mbaa Wu Gi̱ra Yesu Kristo ba nyi̱i̱mbi̱r bo̱o̱ ni̱i̱u̱ yi pi̱dau̱ gaanggu̱. ");
INSERT INTO wja_vpl VALUES ("PM1_4","087_1_4","PHM","1","4","4","N wanan Yamba mi kana pe̱ne̱ ka n ce̱gu̱ ku̱ru̱ di̱ngi̱n mbaa, Pilimon. ");
INSERT INTO wja_vpl VALUES ("PM1_5","087_1_5","PHM","1","5","5","Di̱ngi̱n n ni̱nga pu nu̱u̱gu̱ le̱e̱gu̱ ji̱re̱ mbi̱ru̱ a mi̱ri̱nggi̱ Mbaa Wu Gi̱ra Yesu yi kangam mbi̱ru̱ di̱ngi̱n mwa mwa nu̱wa Yamba wa. ");
INSERT INTO wja_vpl VALUES ("PM1_6","087_1_6","PHM","1","6","6","Anda n woo ce̱gu̱ kuru mi̱n bu dinu we̱i̱ mangu̱ wai mbi̱ru̱ ku baa bo̱nggo̱ le̱e̱gu̱ ji̱re̱ mbi̱ru̱ ci̱ka ku bu so̱ma pero bu ti̱langa mwa mwa yi̱ri̱ngi̱ tu nyaa twii bo̱o̱ yi to̱nai̱ bo̱nggo̱ Kristo. ");
INSERT INTO wja_vpl VALUES ("PM1_7","087_1_7","PHM","1","7","7","Kangam mbi̱ru̱ a nyi̱i̱gi̱ bur de̱gde̱g yi̱ ci̱ngu̱ gaanggu̱, ba go̱nmi̱, di̱ngi̱n wu̱rangi̱ mbi̱r tu nyaai a mwaanga gaangi̱r nu̱wa Yamba wa. ");
INSERT INTO wja_vpl VALUES ("PM1_8","087_1_8","PHM","1","8","8","To̱ tu di̱nai̱ n si̱ngu̱ mo̱u̱. N kasi̱gu̱ a mi̱ri̱nggi̱ din Kristo di̱ngi̱n to̱ tu daayai a bo̱nggo̱ mo̱u̱. ");
INSERT INTO wja_vpl VALUES ("PM1_9","087_1_9","PHM","1","9","9","Anda di̱ngi̱n kangam yiru, n gwala ti̱bak n senggo mi̱na. ");
INSERT INTO wja_vpl VALUES ("PM1_10","087_1_10","PHM","1","10","10","N senggo mi̱na ma pi̱r kasu̱gu̱ bo̱l mi,Onisimus. N yo̱o̱ mba yo̱ mi̱ri̱nggi̱ le̱e̱gu̱ ji̱re̱ jo̱r du woo a jaru̱m. ");
INSERT INTO wja_vpl VALUES ("PM1_11","087_1_11","PHM","1","11","11","Onisimus yo̱o̱ bu ne̱r wu nyaa a bo̱nggo̱ mo̱u̱ gaure you, anda yo̱ko̱ ti̱na ne̱r wu nyaa bo̱nggo̱ mi yi̱ mo̱. ");
INSERT INTO wja_vpl VALUES ("PM1_12","087_1_12","PHM","1","12","12","N wo̱o̱ pe̱r sukugu yo̱ a bo̱nggo̱ mo̱u̱, pero kem yi̱ yo̱ wo̱o̱ baayi yi̱ gaanggu̱ mu. ");
INSERT INTO wja_vpl VALUES ("PM1_13","087_1_13","PHM","1","13","13","N kasa n ruwo pi̱na a bo̱nggo̱ mu, kana ku n wo̱o̱ mi̱ri̱nggi̱ cali̱ di̱ngi̱n wasu̱gu̱ ci̱ye̱i̱ do̱ teng, pero na kalanggu̱ we̱i̱ nyan mo̱. ");
INSERT INTO wja_vpl VALUES ("PM1_14","087_1_14","PHM","1","14","14","Anda n kasa bu ni̱ngu̱ kanaca yaa le̱e̱gu̱ mo̱u̱. N kasa mo̱ ma kalangge̱ di̱ngi̱n ma kasa, yaa di̱ngi̱n nu̱wa ki̱ca mi̱na. ");
INSERT INTO wja_vpl VALUES ("PM1_15","087_1_15","PHM","1","15","15","Ma cwaanga bu̱ri̱ yi̱ Onisimus nyan jo̱r banyi̱na, di̱ngi̱n ma ki̱nga yo̱ do̱ng kana pe̱ne̱ pe̱ne̱. ");
INSERT INTO wja_vpl VALUES ("PM1_16","087_1_16","PHM","1","16","16","Yaa ci̱ka ke̱we̱ me̱re̱ a bo̱nggo̱ mo̱u̱. A gwala pi̱tu̱ ke̱we̱, yo̱ yo̱o̱ bago̱n yi̱re̱ mi̱ri̱nggi̱ kangam, cima cima yo̱u̱ a bo̱nggo̱ mu. Yo̱ko̱ ni̱nga we̱i̱ kundi wang a bo̱nggo̱ mo̱u̱, mwa mwa ci̱ka ne̱re̱ yi̱ bago̱n yi̱re̱ a mi̱ri̱nggi̱ Mbaa Wu Gi̱raa. ");
INSERT INTO wja_vpl VALUES ("PM1_17","087_1_17","PHM","1","17","17","Di̱ngi̱n to̱no̱ ka ma ko̱nggi̱ n yo̱o̱gi̱ bago̱n mo̱, ma te̱ranga ci̱ka ku ma te̱ranga wu wai̱. ");
INSERT INTO wja_vpl VALUES ("PM1_18","087_1_18","PHM","1","18","18","Kana na bwiyaman ca a kana wo̱no̱ nyinou pero ma po̱ng kanaca wai, bur ma pi̱rangge̱ mi. ");
INSERT INTO wja_vpl VALUES ("PM1_19","087_1_19","PHM","1","19","19","MI, BULUS N WO̱O̱ BALAMI̱N TI̱NA YI̱ WAI MU: N YAR WAI. PERO YAA KU CE̱I̱ WAU MI̱N MA PO̱NGI̱ PI̱I̱MA MA. ");
INSERT INTO wja_vpl VALUES ("PM1_20","087_1_20","PHM","1","20","20","O̱ng, bago̱n mi, kankam ni̱ngangi̱n ko̱o̱ kalanggu̱ di̱ngi̱n Mbaa Wu Gi̱ra. Nyi̱ngi̱ ko̱o̱ di̱ran gaanggu̱ mi̱ri̱nggi̱ Kristo. ");
INSERT INTO wja_vpl VALUES ("PM1_21","087_1_21","PHM","1","21","21","N wo̱o̱ yi̱ param bu̱ru̱ ku bala wuna lakargar mi̱n ma ni̱ngga tu n senggo mi̱na kana tu gwala to̱ ma. ");
INSERT INTO wja_vpl VALUES ("PM1_22","087_1_22","PHM","1","22","22","Yir tino tu nyonai bago̱n mi me̱ne̱nggi̱ kang ru̱nggu̱wa, di̱ngi̱n n manni̱ mi̱n Yamba nu̱wai̱ ku̱ru̱ mau palaka n waata bu̱ri̱ a bo̱nggo̱ mo̱u̱. /s Cima Bulus bu cwata go̱ro̱ ba ");
INSERT INTO wja_vpl VALUES ("PM1_23","087_1_23","PHM","1","23","23","Ipaparas, bago̱n jaru̱m mi a mi̱ri̱nggi̱ Kristo Yesu, wo̱o̱ tum mi̱ri̱ ci̱ma. ");
INSERT INTO wja_vpl VALUES ("PM1_24","087_1_24","PHM","1","24","24","Yi̱to̱ mwa yi̱ Markus, Aristakus, Dimas yi̱ Luka ba si̱ng wu̱rai̱ mi. ");
INSERT INTO wja_vpl VALUES ("PM1_25","087_1_25","PHM","1","25","25","Yama bo̱o̱ ni̱i̱u̱ ku Mbaa Wu Gi̱ra Yesu Masiya ba si̱ya kem yi̱ bawei mai.");
INSERT INTO wja_vpl VALUES ("JM1_1","089_1_1","JAS","1","1","1","Wuna lakargar a baa bo̱nggo̱ Yakubu, ke̱waa Yamba yi̱ Mbaa Wu Gi̱ra Yesu Kristo. N wo̱o̱ balaman, duuri kwap su̱r ro̱p tu nu̱wa bu Yudaya wa bu po̱nggu̱ wa bu we̱e̱nga a si̱ma mwa mwa. N wo̱o̱ ci̱gu̱ mbi̱ru̱. ");
INSERT INTO wja_vpl VALUES ("JM1_2","089_1_2","JAS","1","2","2","Bu ni̱nga bu̱ri̱ de̱gde̱g ci̱yamba muwa bu nambi̱rmba yi̱ nu̱ru̱mba wa, ka bu te̱mbi̱rii̱ ku̱u̱le̱ wundu wundu bu de̱ to̱o̱ tengu, ");
INSERT INTO wja_vpl VALUES ("JM1_3","089_1_3","JAS","1","3","3","di̱ngi̱n bu so̱ma cu̱u̱gu̱ de̱e̱ gi̱ru̱ a mi̱ri̱nggi̱ bo̱gu̱ gaanggu̱ ");
INSERT INTO wja_vpl VALUES ("JM1_4","089_1_4","JAS","1","4","4","Yama ba gi̱ra, di̱ngi̱n ka bo̱rgu̱ gaanggu̱ matu̱ gi̱ru̱ mwa mwa, yi biyanu we̱i̱, yaa dwal kana ca. ");
INSERT INTO wja_vpl VALUES ("JM1_5","089_1_5","JAS","1","5","5","Ka wu kangge̱ cu̱du̱ mbi̱ri̱ yaa pwii ne̱, ba senggo Yamba yire yo̱ wu yi̱ ni̱i̱ nyi̱i̱mi̱nu̱ we̱i̱ kana we̱ yaa dwali. Yo̱ na ye̱re̱ mi̱ni̱ di̱ngi̱n ma senggo. ");
INSERT INTO wja_vpl VALUES ("JM1_6","089_1_6","JAS","1","6","6","Anda ka ma senggi yo̱, ma man ni̱i̱, bo̱nggo̱ Yamba yo̱ wundu. Ma cwaniya gaanggi̱r ro̱p, di̱ngi̱n ne̱re̱ wu cwaanga gaanggi̱r ro̱p ci̱ka gwe̱rai̱ gundi du wuturi sukugi. ");
INSERT INTO wja_vpl VALUES ("JM1_7","089_1_7","JAS","1","7","7","Ko̱o̱ du nu̱wa ba danggiya ki̱n pmai nyi̱nggu̱ we̱i̱ yi̱ri̱ tu kanggi̱ bo̱nggo̱ Yamba. ");
INSERT INTO wja_vpl VALUES ("JM1_8","089_1_8","JAS","1","8","8","Gaanggi̱r pmai cwanggi̱ ro̱p a bo̱nggo̱ Yambau̱ yi̱ yi̱ri̱ tu si̱ma, pero pma yaa puwii ba ti̱na yi̱ri̱ tino tu ni̱nggi̱. ");
INSERT INTO wja_vpl VALUES ("JM1_9","089_1_9","JAS","1","9","9","Nu̱wa bu pu ji̱re̱ wa kana twii baku̱u̱lu̱wa bo̱o̱ yi̱ yi̱ri̱ tu le̱e̱ we̱i̱ dwii yi̱ to̱no̱ di̱ngi̱n a gawu̱r Yamba pma yi̱ gi̱ru̱. ");
INSERT INTO wja_vpl VALUES ("JM1_10","089_1_10","JAS","1","10","10","Anda pma bu yi̱ gi̱na bu po̱nggu̱ wa ba ni̱nga bu̱ri̱ de̱gde̱g di̱ngi̱n Yamba diina pma cingo dwii. Di̱ngi̱n pma mwati̱r we̱i̱ ci̱ka pundi tu gu̱lai̱. ");
INSERT INTO wja_vpl VALUES ("JM1_11","089_1_11","JAS","1","11","11","Ka nyanggu̱ twiiwe wulok si̱yangi̱ ku̱su̱ri̱, pundi tu nyiititi yu̱yo̱ni̱, yi̱lau̱ yo̱u̱ kwardi. Yi̱to̱ yi̱ bagi̱na, pma kwardu we̱i̱ puu pma bo̱o̱ kasu̱gu̱ gi̱nau̱. ");
INSERT INTO wja_vpl VALUES ("JM1_12","089_1_12","JAS","1","12","12","Yamba diiman wuure pma bu bo̱o̱ gaanggu̱ yi̱ cu̱u̱gu̱. Di̱ngi̱n go̱ro̱ pu mata, yo̱ yiru we̱i̱ me̱tu̱wal pi̱i̱ma wu Yamba ni̱ngaman alkawal pma bu kangman yo̱ wa. ");
INSERT INTO wja_vpl VALUES ("JM1_13","089_1_13","JAS","1","13","13","Anda ma dangga kana nu̱wa cu̱u̱mi̱na, ma ce̱ yaa mi̱n, “Yamba cu̱u̱gu̱ mu” Di̱ngi̱n nu̱wa cu̱u̱ Yamba yi̱ yi̱ri̱ tu bwi̱i̱, yikaa yaa ku cu̱u̱ we̱i̱ kana we̱. ");
INSERT INTO wja_vpl VALUES ("JM1_14","089_1_14","JAS","1","14","14","Cu̱u̱gu̱ baa bo̱nggo̱ miyandi we̱le̱mdi̱ yi̱ri̱ su lamba yi̱ri̱ ba man yi̱ri̱ si̱ye̱i̱. ");
INSERT INTO wja_vpl VALUES ("JM1_15","089_1_15","JAS","1","15","15","Anda ka Miyam de̱r rwii bir we̱le̱m, ka we̱le̱m gi̱ri̱ de̱e̱ bo̱o̱re̱. ");
INSERT INTO wja_vpl VALUES ("JM1_16","089_1_16","JAS","1","16","16","Nu̱wa ba ci̱ye̱ mbi̱rya ci̱yamba muwa bu nu̱rba wa yi̱ bu nambi̱r wa. ");
INSERT INTO wja_vpl VALUES ("JM1_17","089_1_17","JAS","1","17","17","Kana ca tu nyaai yi̱ tu ci̱maci̱ma baa bo̱nggo̱ Yambau̱ Mba yire, yo̱o̱ wu ruu rangdi su diyou. Yo̱ wu yaa waki̱re̱ kana banyi̱na ci̱ka wekilei. ");
INSERT INTO wja_vpl VALUES ("JM1_18","089_1_18","JAS","1","18","18","Yo̱ se̱ka ba bi yiro bo̱nggo̱ ci̱ye̱i̱ du ji̱re̱. Anda yo̱ a cu̱du̱ yi̱ri̱ngi̱ tu ruu wai yi̱ gwalaman yo̱ kana ca. ");
INSERT INTO wja_vpl VALUES ("JM1_19","089_1_19","JAS","1","19","19","Ci̱yamba muwa bu nambi̱rmba wa yi̱ bu nu̱ru̱mba wa bu kangni̱ wa: Kana we̱ ba katwiyau ki̱lang, anda bu yaliya ce̱gu̱ ci̱ye̱u̱, pero bu su̱ku̱ ya ki̱lang. ");
INSERT INTO wja_vpl VALUES ("JM1_20","089_1_20","JAS","1","20","20","Sukom ne̱ru̱ yaa de̱e̱ ni̱nggu̱ tu Yamba kasi̱. ");
INSERT INTO wja_vpl VALUES ("JM1_21","089_1_21","JAS","1","21","21","Ma de̱man ce̱wi̱ yi̱ ni̱ngandi̱ tu bwi̱i̱ mwa mwa, ma le̱e̱ yi̱ ci̱ye̱i̱ ye̱i̱ Yamba du pi̱ya a mi̱ri̱nggu̱ gaanggu̱ mau yi̱ dwii cinggi, di̱ngi̱n yi̱ di̱mbi̱re̱ ba mi̱ra. ");
INSERT INTO wja_vpl VALUES ("JM1_22","089_1_22","JAS","1","22","22","Anda ma kari̱ya twiyau ci̱ye̱i̱ Yambai̱ ti̱bak. Tage̱ ma ni̱nga tu ci̱ye̱i̱. Ka yi̱to̱ ne̱, ma we̱le̱nggu̱ bu̱ri̱ mai. ");
INSERT INTO wja_vpl VALUES ("JM1_23","089_1_23","JAS","1","23","23","Di̱ngi̱n ka ma kar twiyau ma ni̱nga bu po̱ngo̱ndi̱ yi̱ to̱no̱ ne̱, ci̱ka ma su̱wa kau mau a bajwale. ");
INSERT INTO wja_vpl VALUES ("JM1_24","089_1_24","JAS","1","24","24","Ka ma kwe̱e̱ bu̱ri̱ mai, ma mwatimini, yo̱ko̱ yo̱ko̱ ma mondo kanda ku mai to̱no̱u̱. ");
INSERT INTO wja_vpl VALUES ("JM1_25","089_1_25","JAS","1","25","25","Anda ka ma su kundi yi̱ te̱e̱ri̱ Yambai̱ tu nyaai, du nyi̱i̱mi̱nu̱ we̱i̱ paran bu̱ru̱, ka ma je̱e̱ gawu̱re̱ yi̱ tu̱mgu̱ tu ci̱ye̱i̱, ma mondo bu tu ma nu̱wa ne̱, Yamba diiminu we̱i̱ wuure a kana ca tu ma ni̱ng we̱i̱. ");
INSERT INTO wja_vpl VALUES ("JM1_26","089_1_26","JAS","1","26","26","Ka ma ci̱ye̱i̱ mi̱n ma po̱nggu̱ Yamba anda ma yaa tar benmai ne̱, ma we̱le̱nggu̱ bu̱ri̱ mai, po̱nggu̱ Yamba mau nyoo. ");
INSERT INTO wja_vpl VALUES ("JM1_27","089_1_27","JAS","1","27","27","Po̱nggu̱ ku walwal a bo̱nggo̱ Yamba Mba yire twii su̱gu̱ kwaraa bu yaa kwiimba wa yi̱ Wu̱tu̱ko̱la a Mi̱ri̱nggi̱ ku̱u̱lu̱ pmo yi̱ ne̱re̱ ba taa bu̱ri̱ ye̱i̱ bo̱nggo̱ yi̱ri̱ngi̱ tu si̱mai̱ tu bwi̱yanu̱ we̱i̱ yo̱. ");
INSERT INTO wja_vpl VALUES ("JM2_1","089_2_1","JAS","2","1","1","Ci̱yamba muwa bu nambi̱rmba yi̱ nu̱ru̱mba, a pi̱su̱ mbi̱ru̱ wu bu le̱e̱ ji̱re̱ yi̱ Mba Wu gi̱ra Yesu Kristo wu yi̱ yi̱lau̱, ma de̱ri̱ya bu kangga gwal bu kangga. ");
INSERT INTO wja_vpl VALUES ("JM2_2","089_2_2","JAS","2","2","2","Ci̱ka ka ne̱re̱ wu kangge̱ te̱e̱we̱ se̱e̱ wu nyaa yi̱ gi̱latane̱ sinariya baa Ikkilisiya mbi̱re̱, wu kangge̱ yika te̱e̱we̱ gusuringi. ");
INSERT INTO wja_vpl VALUES ("JM2_3","089_2_3","JAS","2","3","3","Ka ma nyi̱i̱ bagina gi̱ru̱ ma sar mi̱n, “Si̱i̱na pi̱su̱ wu nyaau.>> Anda ma sar ba ku̱u̱lu̱ wii mi̱n, “Mo̱ ti̱n ti̱ye̱i̱ po̱o̱, ka yi̱to̱ ne̱, ma si̱na si̱ma a mwar mi.>> ");
INSERT INTO wja_vpl VALUES ("JM2_4","089_2_4","JAS","2","4","4","Ma ju̱ku̱gu̱ bu mi̱n, ma kasi̱ wu kanggi̱ wii gwala wu kangge̱ pero ma mwar bali̱ yi̱ dangandi̱ tu bwi̱i̱ ru? ");
INSERT INTO wja_vpl VALUES ("JM2_5","089_2_5","JAS","2","5","5","Bu katwiyou, ci̱yamba muwa bu nambi̱rmba yi̱ bu nu̱ru̱mba wa. Yamba se̱kabu̱ baku̱u̱lu̱wa bu si̱ma bi̱na ba yo̱o̱ ba nyauwa a le̱e̱gu̱ ji̱re̱ ru? Bwii pma bu je̱e̱ we̱i̱ lau̱ Yambau̱ ku yo̱ ni̱nga alkawal di̱ngi̱n pma bu kangman yo̱ wa ru? ");
INSERT INTO wja_vpl VALUES ("JM2_6","089_2_6","JAS","2","6","6","Anda bu ce̱do̱ baku̱u̱lu̱wa! Anda twii banyauwa turo mbi̱ri̱ pero de̱mbi̱ri̱ laa balu neru? ");
INSERT INTO wja_vpl VALUES ("JM2_7","089_2_7","JAS","2","7","7","Bwii pma bu rweenga Yesu Kristo, yo̱ wu bu le̱e̱ ji̱re̱ yi̱ din ye̱i̱ ne̱ ru? ");
INSERT INTO wja_vpl VALUES ("JM2_8","089_2_8","JAS","2","8","8","O̱ng ji̱re̱, kundi ka bu ni̱ngi̱ po̱ngo̱ndi̱ yi̱ te̱e̱ri̱ Balaa Yamba, du yi ki̱nggai̱ a De̱mte̱e̱re̱: “Ma kangman bapun mo̱ ci̱ka bu̱ri̱ mai.>> ");
INSERT INTO wja_vpl VALUES ("JM2_9","089_2_9","JAS","2","9","9","Ka ma kangman nu̱wa bu kangga gwal bu kangga, ma ni̱nga we̱le̱m. Ma pa te̱e̱re̱. ");
INSERT INTO wja_vpl VALUES ("JM2_10","089_2_10","JAS","2","10","10","Di̱ngi̱n kana we̱ wu po̱ng te̱e̱ri̱ngi̱ mwa mwa anda ki̱yanga dino, a paa te̱e̱ri̱ Yambai̱ mwa mwa. ");
INSERT INTO wja_vpl VALUES ("JM2_11","089_2_11","JAS","2","11","11","Di̱ngi̱n Yamba wu ce̱ ki̱n, “Ma ni̱ngi̱ ya taari̱.>> Pero wii yo̱ ce̱ ki̱n, “Ma jiriya ne̱re̱.>> Di̱ngi̱n to̱no̱ ka ma jir ne̱re̱ anda ma ni̱nga bu taari̱ ne̱, ma pa te̱e̱re̱ mwaasi̱. ");
INSERT INTO wja_vpl VALUES ("JM2_12","089_2_12","JAS","2","12","12","Kana ca tu ma ce̱ yi̱ kana ca tu ma ni̱nga, ma ni̱nga ci̱ka nu̱wa ni̱ngami̱nu̱ we̱i̱ bali̱ yi̱ te̱e̱re̱ du peri ne̱re̱ ge̱se̱le̱. ");
INSERT INTO wja_vpl VALUES ("JM2_13","089_2_13","JAS","2","13","13","Yaa ku nu̱wa nu̱u̱ we̱i̱ bunam pma bu yaa nu̱u̱ bunam nu̱wa bu kangga. Anda ka ma nu̱u̱ bunam, Yamba nu̱u̱ we̱i̱ bunam mau ka wuni ni̱nggu̱ bali̱. ");
INSERT INTO wja_vpl VALUES ("JM2_14","089_2_14","JAS","2","14","14","Kundi yau̱ ca, ci̱yamba muwa bu nambi̱rmbawa yi bu nu̱ru̱mba wa, ka ma ci̱ye̱i̱ mi̱n mai le̱e̱gu̱ ji̱rau̱ anda yaa wu̱rangi̱ ne̱? Ko̱o̱ duu le̱e̱gu̱ ji̱rau̱ puu we̱i̱ mi̱rgu̱ ne̱re̱ du? ");
INSERT INTO wja_vpl VALUES ("JM2_15","089_2_15","JAS","2","15","15","Ci̱ka ma ko̱ ba go̱nmo̱ wu nambare̱ yi nu̱re̱ yaa je̱e̱ndi̱ yaa se̱e̱, ");
INSERT INTO wja_vpl VALUES ("JM2_16","089_2_16","JAS","2","16","16","anda ma se̱ mi̱n “Ma ci̱ laamau. Yama ma cii bu̱ri̱ mai wulok yi̱ se̱e̱, ma je̱ je̱e̱ndi̱ wang.>> Anda ma nyi̱i̱ bu ne̱re̱ wii je̱e̱ndi̱ kana ba nyina kana se̱e̱. To̱o̱ yi̱ri̱ kundi yau̱ ca? ");
INSERT INTO wja_vpl VALUES ("JM2_17","089_2_17","JAS","2","17","17","Di̱ngi̱n to̱no̱, le̱e̱gu̱ ji̱rau̱ ku ya kem yi̱ wu̱rangi̱ bwaagi̱. ");
INSERT INTO wja_vpl VALUES ("JM2_18","089_2_18","JAS","2","18","18","Ne̱re̱ wu kanggi̱ ce̱ we̱i̱ ki̱n, “Ma wo̱o̱ yi̱ le̱e̱gu̱ ji̱rau̱; Mi n ko̱ n wo̱o̱ yi̱ wu̱rangi̱.>> Anda n ce̱gu̱ mi̱n, “Ma ju̱ku̱nggi̱ le̱e̱gu̱ ji̱rau̱ yaa Kem yi̱ wu̱rangi̱. N ju̱ku̱ manu we̱i̱ le̱e̱gu̱ ji̱rau̱ mu bo̱nggo̱ wu̱rangi̱ mi.>> ");
INSERT INTO wja_vpl VALUES ("JM2_19","089_2_19","JAS","2","19","19","Ma ce̱ mi̱n ma yi̱ le̱e̱gu̱ ji̱rau̱, di̱ngi̱n ma pu ji̱re̱i̱ Yamba wiino. Ma ni̱nga kundi! Kana wuturindi pu ji̱re̱i̱ yi̱to̱, bu̱ri̱ pma mi̱ri̱ di̱ngi̱n gwasi̱. ");
INSERT INTO wja_vpl VALUES ("JM2_20","089_2_20","JAS","2","20","20","Mo̱ ba ci̱ne̱! Ma ko̱bu̱ kanda ku le̱e̱gu̱ ji̱rau̱ yaa wu̱rangi̱ to̱o̱ tu nyoi ru? ");
INSERT INTO wja_vpl VALUES ("JM2_21","089_2_21","JAS","2","21","21","Ma so̱m bu mi̱n kakaa yi̱ri̱ Braima Yamba ko̱ yo̱ ne̱re̱ wu nyaa di̱ngi̱n wu̱rangi̱ ye̱i̱ pu nyi̱i̱ bo̱l yo̱ Icaku a kwaare̱ ru? ");
INSERT INTO wja_vpl VALUES ("JM2_22","089_2_22","JAS","2","22","22","Su̱wa, le̱e̱gu̱ ji̱rau̱ yo̱u̱ yi̱ wu̱rangi̱ ye̱i̱ a mwatangu kiino. Wu̱rangi̱ ye̱i̱ a diina le̱e̱gu̱ ji̱re̱ yo̱u̱ twangi. ");
INSERT INTO wja_vpl VALUES ("JM2_23","089_2_23","JAS","2","23","23","Di̱ngi̱n to̱no̱ a ni̱ngwa ci̱ka ku De̱mci̱yei̱ Yamba ce̱u̱: “Ibrahim le̱e̱ ji̱re̱i̱ yi̱ Yamba, anda di̱ngi̱n le̱e̱gu̱ ji̱re̱ yo̱u̱ Yamba ko̱ yo̱ ci̱maci̱ma.. Nu̱wa yi yo̱ ki̱n, basi̱n Yamba.>> ");
INSERT INTO wja_vpl VALUES ("JM2_24","089_2_24","JAS","2","24","24","Ma ko̱gu̱, yi yo̱o̱ nu̱wa bu nyaa wa a gawu̱r Yambai̱ a bo̱nggo̱ wu̱rangi̱ tu yi ni̱ng, yaa bo̱nggo̱ le̱e̱gu̱ ji̱rau̱ yi̱ wundu ti̱bak. ");
INSERT INTO wja_vpl VALUES ("JM2_25","089_2_25","JAS","2","25","25","Yi̱to̱ mwa yi̱ Rahab wu twii karmaji nu̱wa ko̱ yo̱ wu nyaa bo̱nggo̱ wu̱rangi̱ ye̱i̱ pu yo̱ tu̱ko̱ nu̱wa bu nu̱wa tu̱mu̱we̱, a ju̱ki̱ pma nyinou wu kanggu̱ twe̱e̱ ye̱i̱. ");
INSERT INTO wja_vpl VALUES ("JM2_26","089_2_26","JAS","2","26","26","Ci̱ka ku, bu̱ri̱ ka yaa pi̱i̱ma ne̱ bwaagi̱, yi̱to̱ mwa le̱e̱gu̱ ji̱rau̱ ka yaa wu̱rangi̱ ne̱ bwaagi̱. ");
INSERT INTO wja_vpl VALUES ("JM3_1","089_3_1","JAS","3","1","1","Ci̱yamba muwa bu nambi̱rmbawa yi bu nu̱ru̱mba wa, bu duuwa mba ba yo̱o̱ ya ku̱lu̱mba, di̱ngi̱n bu so̱ma yo ku̱lu̱mba nu̱wa ni̱nga yi̱ri̱ we̱i̱ bali̱ su gwala wang. ");
INSERT INTO wja_vpl VALUES ("JM3_2","089_3_2","JAS","3","2","2","Manggu, mwa mwa yi liyani wang. Anda ka ne̱re̱ liyabu bo̱nggo̱ ce̱wi̱ ye̱i̱ ne̱, wo̱o̱ ne̱re̱ ci̱maci̱ma pero puu we̱i̱ tagu̱ bu̱ri̱ ye̱i̱ mwa mwa. ");
INSERT INTO wja_vpl VALUES ("JM3_3","089_3_3","JAS","3","3","3","Yi diini gwe̱rai̱ yi tum yo̱u̱ ba aara kana pi̱yau̱ pu yi kasu̱ yi̱ linjang ba twitwila a nyi̱yau̱ yo̱u̱. ");
INSERT INTO wja_vpl VALUES ("JM3_4","089_3_4","JAS","3","4","4","Su̱wa yi̱ konggorundi su gembirendi mwaasi̱. Pma gemrendi anda wuturi wu yi di̱mbi̱re̱ suki pma, kana yi̱to̱ ne̱re̱ wu ke̱e̱yi̱ ni̱ng wu̱rai̱ yi̱ bo̱o̱ ke̱n ba ke̱e̱yi̱ pu yo̱ kasu̱. ");
INSERT INTO wja_vpl VALUES ("JM3_5","089_3_5","JAS","3","5","5","Yi̱to̱ mwaasi̱ bene to̱o̱ yi̱ri̱ tu banyi̱nai̱, anda ce̱ ce̱wi̱ tu gi̱rdi̱ dwii ne̱re̱ wang. Anda cile bwalai ba nyina diinu we̱i̱ baki̱ du duyi ba taawa. ");
INSERT INTO wja_vpl VALUES ("JM3_6","089_3_6","JAS","3","6","6","Anda be̱ne̱ to̱o̱ bwalau. To̱o̱ tu bwi̱i̱ wang a mi̱ri̱nggi̱ penendi su bu̱ri̱. Puu bwiyanggu bu̱ri̱ ne̱ri̱ mwa mwa. Yo manu we̱i̱ pi̱i̱ma ma mwa mwa bwalau, di̱ngi̱n bwalau yau̱ twiiwe bwalau ku yaa dumdu. ");
INSERT INTO wja_vpl VALUES ("JM3_7","089_3_7","JAS","3","7","7","Nu̱wa pu we̱i̱ taagu̱ kana ko̱no̱ du nemu yi̱ yidi yi̱ yi̱ri̱ tu wurdu pwii si̱mai̱ yi̱ jinde. ");
INSERT INTO wja_vpl VALUES ("JM3_8","089_3_8","JAS","3","8","8","Anda yaa ne̱re̱ wu pu we̱i̱ tagu̱ be̱nu̱. Yaa yo̱ro̱ni̱ yi̱ tu bwi̱i̱, twanggi yi̱ bwaali bo̱o̱re̱. ");
INSERT INTO wja_vpl VALUES ("JM3_9","089_3_9","JAS","3","9","9","Yi te̱ran Mbaa Wu Gi̱ra Yamba yi̱ to̱no̱, jo̱rdi̱ kanggi̱ yi se̱ntani̱ bu kangga bu nu̱wa ruu pma Mi̱ri̱nggi̱ mwe̱e̱ndi̱ Yambai̱. ");
INSERT INTO wja_vpl VALUES ("JM3_10","089_3_10","JAS","3","10","10","Wuure yi̱ se̱ntanggu̱ twii we̱i̱ nyi̱yau̱ wii wiino. Manggu, ci̱yamba muwa nambi̱rmba yi̱ nu̱ru̱mba, to̱o̱ yi̱ri̱ ya ci̱maci̱ma cima. ");
INSERT INTO wja_vpl VALUES ("JM3_11","089_3_11","JAS","3","11","11","Nung bwiyo bwiiwe we̱i̱ gundu ku teng yi̱ ku suluk ru? ");
INSERT INTO wja_vpl VALUES ("JM3_12","089_3_12","JAS","3","12","12","Ci̱yamba muwa, pwalugu puu we̱i̱ twiyagu tutwiyari inabi ru, kana sou inabi puu we̱i̱ ba twiya pwari pwalgu ru? Yaa yi̱to̱, yaa ku ma kelu we̱i̱ gundu ku teng a nung bwiiyo wu suluk. ");
INSERT INTO wja_vpl VALUES ("JM3_13","089_3_13","JAS","3","13","13","Ka ma wo̱o̱ yi̱ pwii yi̱ ku̱randi̱, ma ju̱ku̱ya bo̱nggo̱ pi̱su̱ wu nyaau, ni̱ngu̱ wu̱rangi̱ tu nyaai, yi ci̱nggu̱ dwii ku baayi bo̱nggo̱ pwiiu. ");
INSERT INTO wja_vpl VALUES ("JM3_14","089_3_14","JAS","3","14","14","Anda ka ma wo̱o̱ yi̱ bwiu yi̱ le̱e̱gu̱ dwii a gaanggu̱, ma liponiya ji̱re̱ yi̱ gi̱rgi̱ dwii yi̱ leendi. ");
INSERT INTO wja_vpl VALUES ("JM3_15","089_3_15","JAS","3","15","15","Di̱ngi̱n bwiu yi̱ kasi̱gu̱ bu̱ru̱ to̱o̱ pwii du bo̱nggo̱ Yamba ne̱, yaa bo̱nggo̱ Bawei du Walwal, anda baa si̱ma yi̱ wuturindi. ");
INSERT INTO wja_vpl VALUES ("JM3_16","089_3_16","JAS","3","16","16","Di̱ngi̱n pu bwiu yi̱ le̱e̱gu̱ dwii ko̱o̱ mi̱ru̱, ma nyi̱nggu̱ we̱i̱ gwe̱la yi̱ kana to̱no̱ yi̱ri̱ tu bwi̱i̱. ");
INSERT INTO wja_vpl VALUES ("JM3_17","089_3_17","JAS","3","17","17","Anda pwii du baa diyou walwal, yi̱ pi̱dau̱ gaanggu̱, yi̱ miu bu̱bu̱k kana pe̱ne̱ pe̱ne̱, ni̱ng po̱ngo̱ndi̱, twangi yi̱ bunam yi̱ wu̱rangi̱ tu nyaai, yaa cwaani nu̱wa, kana pe̱ne̱ yi̱ ji̱re̱. ");
INSERT INTO wja_vpl VALUES ("JM3_18","089_3_18","JAS","3","18","18","Pma bu kasi̱ pi̱dau̱ gaanggu̱ wa pi̱ri̱ go̱ma pi̱dau̱ gaanggu̱ wa ba kaca wu̱rangi̱ tu nyaai. ");
INSERT INTO wja_vpl VALUES ("JM4_1","089_4_1","JAS","4","1","1","Tu de̱e̱ gwe̱la ce̱u̱ yi̱ kwai a cu̱du̱ mbi̱ri̱ ca? Yaa baayi bo̱nggo̱ miyam bu̱ru̱ wu bwiu wu wu kwai a gaanggu̱ mbi̱ri̱ ru? ");
INSERT INTO wja_vpl VALUES ("JM4_2","089_4_2","JAS","4","2","2","Bu kasi̱ yi̱ri̱ anda bu yaa ki̱nggi̱, Bu laci̱ nu̱wa pero bu ni̱ng yawo̱, anda bu yaa ki̱nggi̱ tu bu kasi̱gu̱. Bu ni̱ngi̱ gwe̱la yi̱ kwai. Bu yaa ki̱nggi̱ tu bu kasi̱gu̱, di̱ngi̱n bu senggo bu Yamba. ");
INSERT INTO wja_vpl VALUES ("JM4_3","089_4_3","JAS","4","3","3","Ka bu senggi, bu yaa nyi̱nggi̱ di̱ngi̱n dangandi̱ mbi̱ri̱ yaa kundi, bu kasi̱ di̱ngi̱n nu̱u̱gu̱ teng mbi̱ru̱ ti̱bak. ");
INSERT INTO wja_vpl VALUES ("JM4_4","089_4_4","JAS","4","4","4","Mba nu̱wa bu yaa ji̱re̱ wa! Bu so̱m bu mi̱n sirre yi̱ si̱ma diini ne̱re̱ ba yo̱o̱ bace̱n Yamba ru? N sambi̱ra do̱ng: Ka ma kasi̱ ma ni̱nga sirre yi̱ si̱ma we̱i̱, ma kasi̱ ma yo̱o̱ bace̱n Yamba. ");
INSERT INTO wja_vpl VALUES ("JM4_5","089_4_5","JAS","4","5","5","Bu danggi̱ mi̱n De̱mte̱e̱re̱ ce̱gu̱ ki̱n, ca pu ce̱ ki̱n, bawei du Yamba dwii yiroi dwii twanggi yi̱ bwiu? ");
INSERT INTO wja_vpl VALUES ("JM4_6","089_4_6","JAS","4","6","6","Anda Yamba nyi̱i̱ yiru we̱i̱ bo̱ni̱i̱u̱ yo̱u̱ ku tum. Ci̱ka ku De̱mte̱e̱re̱ ce̱ ki̱n, “Yamba kwaa nu̱wa bu yi̱ le̱e̱gu̱ dwii wa anda ni̱ng tu nyaai bo̱nggo̱ pma bu cinggi dwii wa.>> ");
INSERT INTO wja_vpl VALUES ("JM4_7","089_4_7","JAS","4","7","7","Di̱ngi̱n to̱no̱ cingo dwii mai a bo̱nggo̱ Yambau̱. Kwaa Balaa buwai, anda yo̱ ceeru we̱i̱ ba du̱mbi̱ra. ");
INSERT INTO wja_vpl VALUES ("JM4_8","089_4_8","JAS","4","8","8","Bame̱ ne̱m yi̱ Yamba. Yika baa we̱i̱ ne̱m yi̱ mba. Car war mbi̱ri̱, mba bu ni̱ng we̱le̱m wa; bu car gaanggu̱ mbi̱ri̱, mba bu gaanggi̱r mbi̱ri̱ cwanggi̱ bu̱ri̱ wa. ");
INSERT INTO wja_vpl VALUES ("JM4_9","089_4_9","JAS","4","9","9","Bu ni̱nga bwiyan gaanggu̱ bu jii wiindi, yi̱ merma di̱ngi̱n yi̱ri̱ tu bu ni̱ngai̱. Yama ma ni̱nga bwiyang gaanggu̱ yi̱ mondo mondo. Yama ma bwiyanga gaanggu̱ yi̱ ku ma rii we̱i̱ riima, ma ca kau yiku ni̱ngu̱ we̱i̱ bu̱ri̱ de̱gde̱g. ");
INSERT INTO wja_vpl VALUES ("JM4_10","089_4_10","JAS","4","10","10","Cingo dwii mai bo̱nggo̱ Mbaa Wu Gi̱ra, yo̱ wunminu we̱i̱ yi̱ gi̱ru̱. ");
INSERT INTO wja_vpl VALUES ("JM4_11","089_4_11","JAS","4","11","11","Ci̱yamba muwa bu ce̱ ya tu yaa kundi a dwii kamba bu po̱nggu̱wa. Kana we̱ wu ce̱ tu yaa kundi a dwii bago̱n yo̱, kana ka ni̱ngaman yo̱ bali̱, a ce̱ tu yaa kundi a dwii te̱e̱ri̱ Yambai̱ pero a ni̱nga bali̱ dwii ye̱i̱. Ka ma ni̱ng bali̱ a dwii te̱e̱ri̱, ma yaa ni̱nggu̱ bo̱nggo̱ndi̱ yi̱ to̱no̱, ma yo̱o̱ ne̱re̱ wu ni̱ng bali̱ a dwii ye̱i̱. ");
INSERT INTO wja_vpl VALUES ("JM4_12","089_4_12","JAS","4","12","12","Yamba yo̱ wundu wii yo̱ wu nyi̱i̱ te̱e̱re̱, wii yo̱ ni̱ng we̱i̱ bali̱. Wii yo̱ yi̱ wundu yi̱ di̱mbi̱re̱ ba mi̱ra yi ba bwiyanga. Di̱ngi̱n to̱no̱, ma danggandi̱ mi̱n ma we̱ ma ni̱ngaman bali̱ bapumo? ");
INSERT INTO wja_vpl VALUES ("JM4_13","089_4_13","JAS","4","13","13","Bu nu̱wa mbaa bu ce̱ mi̱n, “Kana reni kana punge yi aandu we̱i̱ gwe̱i̱ du kanggi̱ yi si̱ndi̱ si̱ye̱i̱ pwii nyan Mi̱la. Wii ni̱nga lummo yi̱ nyi̱ngga ke̱ne̱.>> ");
INSERT INTO wja_vpl VALUES ("JM4_14","089_4_14","JAS","4","14","14","Ma so̱m bu tu ni̱ndu̱ we̱i̱ punge yi̱ pi̱i̱ma ma ru? Pi̱i̱ma ma ci̱ka mi̱re̱, yo̱ko̱ ma ko̱gu̱ ka yoron ba nyi̱na ma kwe̱e̱yi̱. ");
INSERT INTO wja_vpl VALUES ("JM4_15","089_4_15","JAS","4","15","15","A daaya ma ce̱ mi̱n, “Ka Mbaa Wu Gi̱ra le̱e̱yi̱, n ni̱ng we̱i̱ ti̱naa yi̱ twii.>> ");
INSERT INTO wja_vpl VALUES ("JM4_16","089_4_16","JAS","4","16","16","Anda bu le̱e̱gu̱ dwii yi dangandi̱ mbi̱ri̱. Ko̱o̱ le̱e̱gu̱ dwii to̱o̱ we̱le̱m. ");
INSERT INTO wja_vpl VALUES ("JM4_17","089_4_17","JAS","4","17","17","Kana we̱ wu so̱m tu daayai ba ni̱nga anda ni̱nga bu, a ni̱nga we̱le̱m. ");
INSERT INTO wja_vpl VALUES ("JM5_1","089_5_1","JAS","5","1","1","qBu katwiyou mba bagi̱na: Bu ji wiindi yi̱ kwarendi di̱ngi̱n ti̱i̱gu̱ ku̱u̱lu̱ yi̱ yi̱ri̱ tu bwi̱i̱ tu bu̱ki̱bu̱ki̱ tu to̱o̱ baayi dwii mbi̱ri̱. ");
INSERT INTO wja_vpl VALUES ("JM5_2","089_5_2","JAS","5","2","2","Gi̱na mbi̱ri butu we̱i̱, pero bo̱bo̱o̱ je̱e̱ we̱i̱ se̱e̱ mbi̱ri. ");
INSERT INTO wja_vpl VALUES ("JM5_3","089_5_3","JAS","5","3","3","Asurpa yi sinariya mo̱ a ni̱nga sasa. Sasa wu ni̱nga wii yo̱o̱ we̱i̱ se̱e̱daki̱ a dwii mai, pero wee we̱i̱ ne̱m mo̱ ci̱ka bwalau. Ma ku̱raman bu̱ri̱ mai gi̱na a daandi si̱na su cwata go̱ro̱i̱. ");
INSERT INTO wja_vpl VALUES ("JM5_4","089_5_4","JAS","5","4","4","Katwiyou! Ma nu̱u̱ wii nu̱wa bu ni̱ngami̱n wu̱rai̱ a ko̱ndo̱u̱, ma kwaa yagu pma kundi. Wo̱ri̱ri̱ tu ma kwa yagu̱ pma twii a de̱ kwaran mo̱. Wiindi nu̱wa bu kacamin ko̱ndo̱u̱ bwii a lam bo̱nggo̱ Mba Wu gi̱ra Yamba. ");
INSERT INTO wja_vpl VALUES ("JM5_5","089_5_5","JAS","5","5","5","Ma si̱n si̱ye̱i̱ a si̱ma mi̱ri̱nggu̱ tengu yi̱ ni̱nggu̱ tu gaanggu̱ mo̱ kasi̱. Ma ni̱ngami̱n bu̱ri̱ mai tawu ma duta ma yanggu nyan ku nu̱wa bi̱i̱mi̱nu̱ wau. ");
INSERT INTO wja_vpl VALUES ("JM5_6","089_5_6","JAS","5","6","6","Ma kwaa, ma laca nu̱wa bu yaa we̱le̱m wa, pma bu ce̱bu̱ kana ca a dwii mai. ");
INSERT INTO wja_vpl VALUES ("JM5_7","089_5_7","JAS","5","7","7","Di̱ngi̱n yi̱to̱ bu ni̱nga kanadi ci̱yamba muwa ko̱po̱ jo̱r bagu̱ Mbaa Wu Gi̱ra. Bu su̱wa bajo̱me̱ yo̱ yam ko̱ndo̱ yo̱u̱ ko̱po̱ ka bir dwii kundi. Pero tar kanadi ba yam gundu ku gawu̱ri̱yo̱ yi̱ gundu ku cwata go̱ro̱u̱. ");
INSERT INTO wja_vpl VALUES ("JM5_8","089_5_8","JAS","5","8","8","N ka mwaasi̱ ma ta kanadi. Ma ti̱n ti̱ye̱i̱ yi̱ di̱mbi̱re̱, di̱ngi̱n bagu̱ Mba Wu gi̱ra ni̱nga ne̱m. ");
INSERT INTO wja_vpl VALUES ("JM5_9","089_5_9","JAS","5","9","9","Ci̱yamba, bu ni̱ngaman ya jaanga ce̱u̱ yi̱ bu̱ri̱, dakali nu̱wa ba ni̱nga mbi̱r ya bali̱. Ne̱re̱ wu ni̱ngi̱ bali̱ wo̱o̱ pi̱tu̱ nyinou. ");
INSERT INTO wja_vpl VALUES ("JM5_10","089_5_10","JAS","5","10","10","Ci̱yamba, bu su̱wa cu̱u̱sangu̱ banabi̱ndi̱ su wasi̱ ci̱ye̱i̱ Yambai̱ bu ti̱langa bo̱nggo̱ pmau, di̱ngi̱n pma bo̱ gaanggu̱ a jo̱r ti̱i̱gu̱ ku̱u̱lu̱. ");
INSERT INTO wja_vpl VALUES ("JM5_11","089_5_11","JAS","5","11","11","Yi nyi̱i̱ pma gi̱ru̱ di̱ngi̱n pma bo̱ gaanggu̱ pmau a jo̱r ti̱i̱gu̱ ku̱u̱lu̱. Bu nu̱u̱ labar bo̱gu̱ gaanggu̱ Ayuba a bo̱nggo̱ cu̱su̱gu̱, bu nu̱u̱ tu Mbaa Wu Gi̱ra ni̱ngaman yo̱. Mba Wu gi̱ra nu̱u̱ bunam wang a kalanga. ");
INSERT INTO wja_vpl VALUES ("JM5_12","089_5_12","JAS","5","12","12","Ci̱yamba muwa, tu gwala mwa mwa, bu we̱re̱ni̱ ya kana yi̱ diyou kana yi̱ si̱ma yi̱ kana ca. Yama “O̱ng” mbi̱re̱ ba yo̱o̱ O̱ng pero “Ang Ang” mbi̱r ba yo̱o̱ ang ang, di̱ngi̱n bu yaramani ya bali̱. ");
INSERT INTO wja_vpl VALUES ("JM5_13","089_5_13","JAS","5","13","13","Wo̱o̱ yi̱ wu ti̱i̱gu̱ ku̱u̱lu̱ a mi̱ri̱nggu̱ mi̱r ru? Ba ce̱ kuru. Wo̱o̱ yi̱ wu bu̱ri̱ de̱gde̱g ru? Ba pi̱i̱ pi̱i̱ te̱re̱nggu̱ Yambai̱. ");
INSERT INTO wja_vpl VALUES ("JM5_14","089_5_14","JAS","5","14","14","Wo̱o̱ yi̱ wu bu̱ri̱ yaa cingcing ru? Ba yiyanga kuruwa ba ce̱man yo̱ ku̱ru̱ ba co̱mman yo̱ nunggu yi̱ din Mba Wu gi̱ra. ");
INSERT INTO wja_vpl VALUES ("JM5_15","089_5_15","JAS","5","15","15","Ku̱ru̱ ku yi̱ le̱e̱gu̱ ji̱rau̱ weeni we̱i̱ buwai, pero Mbaa Wu Gi̱ra nyi̱i̱ we̱i̱ bu̱ri̱ cingcing. Ka ni̱nga we̱le̱m wai, paru̱ we̱i̱ sukom we̱le̱m yau̱. ");
INSERT INTO wja_vpl VALUES ("JM5_16","089_5_16","JAS","5","16","16","Bu sa bu̱ri̱ mbi̱ri̱ we̱le̱mdi̱ mbi̱ri̱ pero bu ce̱man bu̱ri̱ mbi̱ri̱ ku̱ru̱ palaka bu yi̱langa. Ku̱ru̱ ne̱re̱ wu po̱ng danggandi̱ Yambai̱ yi̱ di̱mbi̱re̱ pero ni̱ng tu nyaai. ");
INSERT INTO wja_vpl VALUES ("JM5_17","089_5_17","JAS","5","17","17","Iliya twii ne̱re̱ ci̱ka yo, anda ku ce̱ ku̱ru̱ ku ji̱rau̱ ki̱n gundu ba yariya, gundu yarubu nyan mi̱la kunong yi̱ pwalari no̱ko̱no̱. ");
INSERT INTO wja_vpl VALUES ("JM5_18","089_5_18","JAS","5","18","18","Anda ku pero ce̱ ku̱ru̱ do̱ng, diyou wun bu̱ri̱ gundu ni̱nga pu yarugu si̱ma nyi̱i̱ je̱e̱ndi̱. ");
INSERT INTO wja_vpl VALUES ("JM5_19","089_5_19","JAS","5","19","19","Ci̱yamba muwa bu nambi̱rmba wa yi̱ bu nu̱ru̱mba wa, ka wu kangge̱ po̱ri̱ nyinou ji̱rau̱, bu kwasi̱ kwii bu waata yi̱ yo̱ nyinou. ");
INSERT INTO wja_vpl VALUES ("JM5_20","089_5_20","JAS","5","20","20","Bu so̱ma mi̱n kana we̱ ka puuwe ne̱re̱ ni̱nggu̱ we̱le̱m, mi̱r we̱i̱ yo̱ bo̱nggo̱ bo̱o̱re̱, pero a de̱e̱ param sukom bo̱nggo̱ we̱le̱mdi̱ tum.");
INSERT INTO wja_vpl VALUES ("J11_1","092_1_1","1JN","1","1","1","N wo̱o̱ bala mbi̱ri̱ bala a dwii yo̱ wu twii ci̱ye̱i̱ pi̱i̱mai̱, du do̱o̱ yake̱ taa yau̱, wu yi nu̱u̱ yo̱, yi ko̱ yi̱ nundi yiri, yi mwaanga yi̱ wari̱ yiri. ");
INSERT INTO wja_vpl VALUES ("J11_2","092_1_2","1JN","1","2","2","Nu̱wa ju̱ku̱ yiri pi̱i̱ma bwii, yi ko̱ yo̱, di̱ngi̱n to̱no̱ yi nyi̱i̱ se̱e̱daki̱ dwii ye̱i̱, pero yi wasi̱ mbi̱r ci̱ye̱i̱ a dwii pi̱i̱ma bu yaa mati̱rwa, wo̱o̱ kem yi̱ Kwiite, nu̱wa ju̱ku̱yi̱ro̱ yo̱. ");
INSERT INTO wja_vpl VALUES ("J11_3","092_1_3","1JN","1","3","3","Yi wasi̱gu̱ mbi̱ru̱ yi̱ri̱ tu yi ko̱ pero yi nu̱wai̱, di̱ngi̱n yi kasi̱ bu ni̱nga naapu yi̱ yo. Naapu yiru ko̱o̱ kem yi̱ Yamba Kwiite, yi̱ Bo̱l yo̱ Yesu Masiya. ");
INSERT INTO wja_vpl VALUES ("J11_4","092_1_4","1JN","1","4","4","Yi bo̱o̱ bala mbi̱ri̱ ti̱na palaka de̱gde̱g gaanggu̱ yiru ba twangwa. ");
INSERT INTO wja_vpl VALUES ("J11_5","092_1_5","1JN","1","5","5","Ti̱na ci̱ye̱i̱ du yi nu̱wai̱ a bo̱nggo̱ Yesu Masiya yi sagu̱ mbi̱ra mi̱n, Yamba twii rangu̱. Ku̱mji̱la yaa bo̱nggo̱ yo̱ kana banyi̱na. ");
INSERT INTO wja_vpl VALUES ("J11_6","092_1_6","1JN","1","6","6","Ka yi ce̱ mi̱n yi bo̱o̱ yi̱ naapu yi̱ yo̱, anda yi so̱ngma a ku̱mji̱la, yi ce̱gu̱ leendu pero yi yaa tu̱m ji̱re̱ wii. ");
INSERT INTO wja_vpl VALUES ("J11_7","092_1_7","1JN","1","7","7","Anda ka yi ni̱ng so̱ngma mi̱ri̱nggu̱ rangu̱, ci̱ka ku yo̱ mwa a mi̱ri̱nggu̱ rangu̱, yi ni̱nggu̱ naapu yi̱ bu̱ri̱ yiri, pero ti̱i̱ma Yesu Bo̱l yo̱, a car yiro a bo̱nggo̱ we̱le̱mdi̱ yiri mwa mwa. ");
INSERT INTO wja_vpl VALUES ("J11_8","092_1_8","1JN","1","8","8","Ka yi ce̱ mi̱n yi ti̱i̱ bu̱ ni̱nggu̱ we̱le̱m ne̱, yi we̱le̱nggu̱ bu̱ri̱ yiri, yi so̱m bu ji̱re̱. ");
INSERT INTO wja_vpl VALUES ("J11_9","092_1_9","1JN","1","9","9","Anda ka yi sar Yamba we̱le̱mdi̱ yiri, yo̱ wu ci̱maci̱ma pero twang tu yo̱ ce̱i̱, para yiri we̱i̱ sukom we̱le̱mdi̱ yiri, ba car yiro a bo̱nggo̱ wu̱rangi̱ yiri tu bwi̱i̱ mwa mwa. ");
INSERT INTO wja_vpl VALUES ("J11_10","092_1_10","1JN","1","10","10","Ka yi ce̱ mi̱n yi ni̱nga bu we̱le̱m ne̱, yi de̱ Yamba twii ba leendo, pero ci̱ye̱i̱ ye̱i̱ yaa mi̱ri̱nggi̱ yiri. ");
INSERT INTO wja_vpl VALUES ("J12_1","092_2_1","1JN","2","1","1","Mba kwaraa muwa wa, n wo̱o̱ bala mbi̱r ti̱na palaka bu ni̱ng ya we̱le̱m. Anda ka wu kangge̱ ni̱ng we̱le̱m, yi bo̱o̱ yi̱ ne̱re̱ wu kala yiri we̱i̱ a bo̱nggo̱ Kwiite, wii Yesu Masiya wu ci̱maci̱ma. ");
INSERT INTO wja_vpl VALUES ("J12_2","092_2_2","1JN","2","2","2","Yesu yi̱ri̱ ye̱i̱ twii ni̱i̱ du yi ki̱nggi̱ pargu̱ sukom we̱le̱mdi̱, bu̱ri̱ yo ne̱ anda kana wo̱no̱ ne̱re̱ wu si̱ma. ");
INSERT INTO wja_vpl VALUES ("J12_3","092_2_3","1JN","2","3","3","Ka yi ni̱ngi̱ po̱ngo̱ndi̱ yi̱ te̱e̱ri̱ng Yambai̱, to̱o̱ ju̱ku̱yi̱ro̱ ki̱n manggu yi so̱m yo̱. ");
INSERT INTO wja_vpl VALUES ("J12_4","092_2_4","1JN","2","4","4","Kana we̱ wu ce̱ ki̱n, <<N so̱m Yamba,>> anda yaa ni̱ng po̱ngo̱ndi̱ yi̱ te̱e̱ri̱ng Yambai̱, to̱o̱ baleendo, pero so̱m bu ji̱re̱. ");
INSERT INTO wja_vpl VALUES ("J12_5","092_2_5","1JN","2","5","5","Anda ne̱re̱ wu ni̱ng po̱ngo̱ndi̱ yi̱ ci̱ye̱i̱ Yambai̱, wii yo̱ kangman Yamba ci̱maci̱ma. To̱o̱ kanda ku yi so̱m we̱i̱ mi̱n yi bo̱o̱ pi̱su̱ naapu yi̱ yo̱. ");
INSERT INTO wja_vpl VALUES ("J12_6","092_2_6","1JN","2","6","6","Kana we̱ wu ce̱ ki̱n yo̱ wo̱o̱ yi̱ naapu yi̱ Yamba, tagi̱ ba ni̱nga pi̱su̱ ci̱ka ku Yesu Masiya ni̱ngau̱. ");
INSERT INTO wja_vpl VALUES ("J12_7","092_2_7","1JN","2","7","7","Basi̱mba muwa bu n kangni̱ wa, te̱e̱ri̱ du n bala mbi̱ri̱ di̱na, di̱na du pu̱ci̱ ne̱. Ti̱na te̱e̱ri̱ du mi̱lgai̱, du bu bo̱o̱ yi̱ to̱no̱ yake̱ taa yau. Te̱e̱ri̱ du mi̱lga dwii, dwii du bu gaci̱la bu nu̱wai̱. ");
INSERT INTO wja_vpl VALUES ("J12_8","092_2_8","1JN","2","8","8","Anda kana yi̱to̱ te̱e̱ri̱ du n bala mbi̱ri̱ do̱, do̱ du pu̱ci̱, Masiya a ju̱ki̱ya ki̱n te̱e̱ri̱ di̱na to̱o̱ ji̱re̱, mba mwa bu ju̱ki̱ya yi̱to̱. Di̱ngi̱n ku̱mji̱la we̱e̱nggu̱ anda rangu̱ wu manggu a swiigu bu̱ru̱. ");
INSERT INTO wja_vpl VALUES ("J12_9","092_2_9","1JN","2","9","9","Ne̱re̱ wu ce̱ ki̱n yo̱ ni̱ngu̱ pi̱su̱ rangu̱, anda kwaa bago̱n yo̱ wu po̱nggu̱, lama yo̱ko̱ wo̱o̱ ni̱ngu̱ pi̱su̱ a ku̱mji̱la. ");
INSERT INTO wja_vpl VALUES ("J12_10","092_2_10","1JN","2","10","10","Anda ne̱re̱ wu kangman bago̱n yo̱, a ni̱nggu̱ pi̱su̱ wu rang, yaa ku diinu we̱i̱ bu kangga ba ni̱nga we̱le̱m. ");
INSERT INTO wja_vpl VALUES ("J12_11","092_2_11","1JN","2","11","11","Ne̱re̱ wu kwaa bago̱n yo̱ a pi̱su̱ pu ri̱m, pero a so̱ngma a pu ri̱m, so̱m bu pu yo̱ so̱ngmau̱, di̱ngi̱n ku̱mji̱la a diina yo̱o̱ kermo. ");
INSERT INTO wja_vpl VALUES ("J12_12","092_2_12","1JN","2","12","12","N wo̱o̱ bala mbi̱ri̱ mba kwaraa, di̱ngi̱n Yamba gaci̱la para mbi̱r sukom we̱le̱mdi̱ mbi̱ri̱ di̱ngi̱n din Yesu. ");
INSERT INTO wja_vpl VALUES ("J12_13","092_2_13","1JN","2","13","13","N wo̱o̱ bala mbi̱ri̱ mba kwiimba, di̱ngi̱n bu so̱m yo̱ wu yake̱ taa yau̱. N wo̱o̱ bala mbi̱ri̱ mba kwati̱mba, di̱ngi̱n bu gwala di̱mbi̱r Balaa Buwai. N wo̱o̱ bala mbi̱ri̱ mba kwaraa, Di̱ngi̱n bu so̱m Kwiite. ");
INSERT INTO wja_vpl VALUES ("J12_14","092_2_14","1JN","2","14","14","N wo̱o̱ bala mbi̱ri̱ mba kwiimba, di̱ngi̱n bu so̱m yo̱ wu wo̱o̱ yake̱ taa yau̱. N wo̱o̱ bala mbi̱ri̱ mba kwati̱mba di̱ngi̱n bu bo̱o̱ yi̱ di̱mbi̱re̱, pero ci̱ye̱i̱ Yambai̱ do̱o̱ pi̱su̱ a mi̱ri̱nggi̱ gaanggi̱r mbi̱ri̱ pero bu gwala di̱mbi̱r ni̱nga Balaa Buwai. ");
INSERT INTO wja_vpl VALUES ("J12_15","092_2_15","1JN","2","15","15","Bu kangmani̱ ya si̱ma, yi̱ kana yi̱ri̱ngi̱ tu mi̱ri̱nggi̱ ye̱i̱. Kana we̱ wu kangman si̱ma, yaa kangman Kwiite. ");
INSERT INTO wja_vpl VALUES ("J12_16","092_2_16","1JN","2","16","16","Di̱ngi̱n mwa mwa yi̱ri̱ngi̱ tu mi̱ri̱nggi̱ si̱mai̱, ci̱ka bu miyam bu̱ru̱, kana ca tu nundi su̱wi̱ pero kasi̱, yi̱ yi̱ri̱ng tu diin ne̱re̱ le̱e̱ dwii, to̱o̱ yaa baangai bo̱nggo̱ Kwiite anda twiyongoi si̱ma. ");
INSERT INTO wja_vpl VALUES ("J12_17","092_2_17","1JN","2","17","17","Si̱ma yi̱ miyandi ye̱i̱ mwa mwa mati̱r we̱i̱, anda kana we̱ wu ni̱ng tu Yamba kasi̱ si̱i̱ we̱i̱ kana pe̱ne̱ pe̱ne̱. ");
INSERT INTO wja_vpl VALUES ("J12_18","092_2_18","1JN","2","18","18","Kwaraa muwa, ti̱na daandi su cwata go̱ro̱i̱, ci̱ka ku bu gaci̱la bu nu̱wa ki̱n, bace̱n Masiya wo̱o̱ baayi, yo̱ko̱ bace̱mba Masiya tum a gaci̱la baanga. To̱o̱ to̱no̱ yi so̱ma mi̱n yi bo̱o̱ daandi su cwata go̱ro̱i̱. ");
INSERT INTO wja_vpl VALUES ("J12_19","092_2_19","1JN","2","19","19","Pma bu bagu̱ ce̱ri̱ yi̱ Masiya bo̱o̱ cu̱di̱ yiri nang, anda pma twiyongo cu̱di̱ yiri, bwii bo̱yi̱wa ne̱. Kana pma bo̱o̱ bo̱yi̱wa we̱i̱, lama yo̱ko̱ na bo̱o̱ kem yi̱ yo. Anda pma duu yiro, to̱o̱ ju̱ki̱ya ki̱n pma bo̱o̱ bo̱yi̱wa ne̱. ");
INSERT INTO wja_vpl VALUES ("J12_20","092_2_20","1JN","2","20","20","Anda mba, Masiya nyi̱i̱ mbi̱r Bawei du Walwal, di̱ngi̱n to̱no̱ mwa mwa mbi̱ru̱ bu so̱m ji̱re̱. ");
INSERT INTO wja_vpl VALUES ("J12_21","092_2_21","1JN","2","21","21","N bala mbi̱ra di̱ngi̱n bu so̱m bu ji̱re̱ ne̱, anda di̱ngi̱n bu so̱ma, pero bu so̱ma ji̱re̱ yaa bi̱ri̱ leendi. ");
INSERT INTO wja_vpl VALUES ("J12_22","092_2_22","1JN","2","22","22","Wu yi̱ leendi wii we̱? Wii wu kwaa ki̱n Yesu wii Masiya ne̱. Ne̱re̱ wu kwaa Kwiite yi̱ Bwi̱ya, wii yo̱ bace̱n Masiya. ");
INSERT INTO wja_vpl VALUES ("J12_23","092_2_23","1JN","2","23","23","Kana we̱ wu kwaa Bwi̱ya, a kwaa Kwiite. Anda kana we̱ wu le̱e̱ Bwi̱ya, a le̱e̱ Kwiite. ");
INSERT INTO wja_vpl VALUES ("J12_24","092_2_24","1JN","2","24","24","Mba bu du̱ tu bu ti̱langa yake̱ taa yau̱ ba si̱ si̱yau̱ a gaanggu̱ mbi̱ru̱. Ka bu ni̱ng yi̱to̱, bu ni̱ng we̱i̱ naapu kem yi̱ Bwi̱ya yi̱ Kwiite. ");
INSERT INTO wja_vpl VALUES ("J12_25","092_2_25","1JN","2","25","25","A bo̱nggo̱ ko̱o̱ naapu, Masiya ni̱nga yir alkawal yo̱ nyi̱i̱ yir we̱i̱ pi̱i̱ma bu yaa mati̱r wa. ");
INSERT INTO wja_vpl VALUES ("J12_26","092_2_26","1JN","2","26","26","N bala mbi̱ri̱ ti̱na a dwii pma bu kasi̱ ba ciyo mbi̱ra wa. ");
INSERT INTO wja_vpl VALUES ("J12_27","092_2_27","1JN","2","27","27","Anda mba, Masiya a nyi̱i̱ mbi̱r Bawei du Walwal du do̱o̱ mi̱ri̱nggi̱ mbi̱ri̱, di̱ngi̱n to̱no̱ bu kasi̱ ya ku̱lu̱m wu kanggi̱ twe̱e̱ye̱i̱. Di̱ngi̱n Bawei ju̱ku̱ mbi̱r kana ca, yi̱ri̱ngi̱ tu ju̱ku̱ mbi̱ri̱ twii ji̱re̱, twii leendi ne̱, di̱ngi̱n to̱no̱ bu je̱ gawu̱re̱ yi̱ ni̱ngu̱ naapu a mi̱ri̱nggu̱ Masiya. ");
INSERT INTO wja_vpl VALUES ("J12_28","092_2_28","1JN","2","28","28","Kwaraa muwa wa, bu ni̱nga pi̱su̱ naapu kem yi̱ Masiya, palaka yi nu̱u̱ yaa gwasi̱ kana me̱lma a gawu̱ri̱ ye̱i̱ nyanggu̱ ku waata wau. ");
INSERT INTO wja_vpl VALUES ("J12_29","092_2_29","1JN","2","29","29","Ka bu so̱ma mi̱n Masiya ci̱maci̱ma, bu so̱mu̱ we̱i̱ mi̱n kana we̱ wu ni̱ng tu ci̱maci̱ma twii bo̱l Yamba. ");
INSERT INTO wja_vpl VALUES ("J13_1","092_3_1","1JN","3","1","1","Bu su̱wa kanda ku Kwiite kang yiro wang, ku nu̱wa yi̱ yiri ki̱n yi kwaraa Yamba wa. To̱o̱ tu yi yo̱o̱gi̱. To̱o̱ tu diinai nu̱wa bu si̱ma wa so̱m yiri bu, di̱ngi̱n pma so̱m bu yo̱. ");
INSERT INTO wja_vpl VALUES ("J13_2","092_3_2","1JN","3","2","2","Basi̱mba muwa bu n kangni̱ wa, yo̱ko̱ yi yo̱o̱gi̱ kwaraa Yamba wa, bo̱ yi so̱m bu tu yi yo̱o̱ we̱i̱. Anda yi so̱ma mi̱n ka Yesu waatai, yi yo̱o̱ we̱i̱ ci̱ka yo̱, di̱ngi̱n yi kwe̱e̱ we̱i̱ yo̱ ci̱ka ku yo̱ yo̱o̱gi̱. ");
INSERT INTO wja_vpl VALUES ("J13_3","092_3_3","1JN","3","3","3","Kana wo̱no̱ ne̱re̱ wu wo̱o̱ yi̱ ko̱o̱ manam ni̱i̱u̱ yi̱ Yesu Masiya, si̱i̱ walwal ci̱ka ku Masiya walwal. ");
INSERT INTO wja_vpl VALUES ("J13_4","092_3_4","1JN","3","4","4","Kana wo̱no̱ ne̱re̱ wu ni̱ng we̱le̱m a yer te̱e̱ri̱ Yambai̱, di̱ngi̱n we̱le̱m twii yerigu te̱e̱ri̱ Yambai̱. ");
INSERT INTO wja_vpl VALUES ("J13_5","092_3_5","1JN","3","5","5","Bu so̱ma mi̱n Masiya baa di̱ngi̱n ba de̱man si̱yau̱ we̱le̱mdi̱ yiri, pero a bo̱nggo̱ yo̱u̱, yo̱ yaa we̱le̱m. ");
INSERT INTO wja_vpl VALUES ("J13_6","092_3_6","1JN","3","6","6","Di̱ngi̱n to̱no̱ kana wo̱no̱ ne̱re̱ wu pi̱su̱ a mi̱ri̱nggu̱ Yesu Masiya yaa je̱e̱ gawu̱re̱ yi̱ ni̱nggu̱ we̱le̱m. Kana we̱ wu je̱ gawu̱re̱ yi̱ ni̱nggu̱ we̱le̱m yaa ku̱ ti̱i̱ ko̱gu̱ yo̱u̱ pero so̱m bu yo̱. ");
INSERT INTO wja_vpl VALUES ("J13_7","092_3_7","1JN","3","7","7","Kwaraa muwa, kana we̱ ba ciye mbi̱r ya! Kana we̱ wu tu̱m tu ci̱maci̱ma twii ne̱re̱ wu ci̱maci̱ma, ci̱ka ku Yesu Masiya yo̱ ci̱maci̱ma. ");
INSERT INTO wja_vpl VALUES ("J13_8","092_3_8","1JN","3","8","8","Kana we̱ wu je̱ gawu̱re̱ yi̱ ni̱nggu̱ we̱le̱m wii wu Balaa Buwai, di̱ngi̱n Bala Buwai ni̱ng we̱le̱m yake̱ taa yau̱. Bo̱l Yamba baa mi̱ri̱nggi̱ si̱ma di̱ngi̱n ba wo̱o̱ si̱yau̱ wu̱rangi̱ Balaa Buwai. ");
INSERT INTO wja_vpl VALUES ("J13_9","092_3_9","1JN","3","9","9","Kana we̱ wu twii bo̱l Yamba, yaa je̱e̱ gawu̱re̱ yi̱ ni̱nggu̱ we̱le̱m, di̱ngi̱n pi̱i̱ma bu pu̱ci̱ bu Yamba wa bo̱o̱ mi̱ri̱nggu̱ ye̱i̱. Yaa ku je̱e̱ we̱i̱ gawu̱re̱ yi̱ ni̱nggu̱ we̱le̱m di̱ngi̱n yo̱ twii bo̱l Yamba. ");
INSERT INTO wja_vpl VALUES ("J13_10","092_3_10","1JN","3","10","10","Ti̱naa nyindi su nu̱wa ku̱rani̱ kwaraa Yamba yi̱ kwaraa Balaa Buwai wa. Kana we̱ wu ni̱ng yi̱ri̱ tu yaa ci̱maci̱ma, twii bo̱l Yamba ne̱, pero ne̱re̱ wu yaa kangman bago̱n yo̱, twii bo̱l Yamba ne̱. ");
INSERT INTO wja_vpl VALUES ("J13_11","092_3_11","1JN","3","11","11","Ti̱naa ci̱ye̱i̱ du bu nu̱wai̱ yake̱ taa yau̱, yama yi kangman bu̱ri̱. ");
INSERT INTO wja_vpl VALUES ("J13_12","092_3_12","1JN","3","12","12","Yi yo̱o̱ ya ci̱ka Kayinu, yo̱ wii wu Balaa Buwai pero do̱ng a ji bago̱n yo̱ Abila. Di̱ngi̱n ca a ji bago̱n yo̱? A jiyo di̱ngi̱n wu̱rangi̱ ye̱i̱ twii tu bwi̱i̱ anda wu̱rangi̱ bago̱n ye̱i̱ twii tu nyaayi. ");
INSERT INTO wja_vpl VALUES ("J13_13","092_3_13","1JN","3","13","13","Ci̱yamba, bu ri̱yani̱ ya bu̱ri̱ ka nu̱wa bu si̱ma wa kwaambi̱ri̱. ");
INSERT INTO wja_vpl VALUES ("J13_14","092_3_14","1JN","3","14","14","Anda yo, yi so̱ma mi̱n yi yeri bo̱o̱re̱ yi baanga bo̱nggo̱ pi̱i̱ma di̱ngi̱n yi kangman ki̱yaa yuwa. Ne̱re̱ wu yaa kangman kappi̱ma, lama yo̱ko̱ wo̱o̱ ku̱u̱ bo̱o̱ru̱. ");
INSERT INTO wja_vpl VALUES ("J13_15","092_3_15","1JN","3","15","15","Kana we̱ wu kwaa bago̱n yo̱, twii ne̱re̱ wu laci̱ nu̱wa. Pero bu so̱ma mi̱n yaa ne̱re̱ wu laci̱ nu̱wa wu yi̱ pi̱i̱ma bu yaa mati̱r wa. ");
INSERT INTO wja_vpl VALUES ("J13_16","092_3_16","1JN","3","16","16","Ti̱naa nyinou wu yi so̱m kanda ku kangam yi̱ to̱no̱u̱, Yesu nyi̱i̱ pi̱i̱ma ya di̱ngi̱n yo, yi̱to̱ mwa a daaya yi nyi̱i̱ pi̱i̱ma yiwa di̱ngi̱n ki̱yaa yuwa. ");
INSERT INTO wja_vpl VALUES ("J13_17","092_3_17","1JN","3","17","17","Ka ne̱re̱ wu yi̱ gi̱na kwe̱e̱ bago̱n yo̱ yi̱ biiki anda kalan bu ne̱, ba so̱ma ki̱n yo̱ yaa kangam Yambau̱. ");
INSERT INTO wja_vpl VALUES ("J13_18","092_3_18","1JN","3","18","18","Kwaraa muwa yi ju̱ku̱ri̱ ya kangam yi̱ ce̱wi̱ yi̱ be̱n ti̱bak, anda yi ju̱ki̱ kangam a bo̱nggo̱ wu̱rangi̱ yi̱ ji̱re̱. ");
INSERT INTO wja_vpl VALUES ("J13_19","092_3_19","1JN","3","19","19","Ka yi kangman bu̱ri̱ yi so̱ma mi̱n yo yi yo̱o̱gi̱ bu ji̱re̱ wa. Pero yi ti̱ndi̱ we̱i̱ ti̱yau̱ a gawu̱r Yamba yaa gwasi̱. ");
INSERT INTO wja_vpl VALUES ("J13_20","092_3_20","1JN","3","20","20","Kana ka gaanggu̱ yiru nyaa yiri dwii we̱le̱mdi̱ yiri, yi so̱ma mi̱n Yamba a gwala di̱mbi̱r gaanggi̱r yiri pero a so̱m kana ca. ");
INSERT INTO wja_vpl VALUES ("J13_21","092_3_21","1JN","3","21","21","Anda basi̱mba muwa bu n kangni̱ wa, ka gaanggu̱ yiru nyaa yiri bu ne̱, yi ti̱ndi̱ we̱i̱ ti̱ye̱i̱ a gawu̱r Yambai̱ yaa gwasi̱. ");
INSERT INTO wja_vpl VALUES ("J13_22","092_3_22","1JN","3","22","22","Pero kana ca tu yi senggo a bo̱nggo̱ yo̱u̱ yi ki̱nggi̱ we̱i̱, di̱ngi̱n yi ni̱ng po̱ngo̱ndi̱ yi̱ te̱e̱ri̱ng ye̱i̱, pero yi ni̱ng tu di̱raman yo̱ gaanggu̱. ");
INSERT INTO wja_vpl VALUES ("J13_23","092_3_23","1JN","3","23","23","Pero Yamba nyi̱i̱ yir te̱e̱ri̱ ki̱n, yi le̱e̱ ji̱re̱ yi̱ Bo̱l yo̱ Yesu Masiya, pero yi kangman bu̱ri̱ yiri, ci̱ka ku Yesu Masiya sa yiro yi ni̱nga. ");
INSERT INTO wja_vpl VALUES ("J13_24","092_3_24","1JN","3","24","24","Kana we̱ wu ni̱ng po̱ngo̱ndi̱ yi̱ te̱e̱ri̱ng Yambai̱, si̱i̱ kem yi̱ Yamba, Yamba mwa si̱i̱ kem yi̱ yo̱. Bawei du Yamba nyi̱i̱ yiro a diina yi so̱ma mi̱n yo̱ si̱i̱ kem yi̱ yo. ");
INSERT INTO wja_vpl VALUES ("J14_1","092_4_1","1JN","4","1","1","Basi̱mba muwa bu n kangni̱ wa, bu le̱e̱ ya ji̱re̱ yi̱ kana wo̱no̱ wu ce̱ ki̱n yo̱ wo̱o̱ yi̱ Bawei Yambai̱, anda bu cu̱u̱ pma. Yikwii bawei pmai baa bo̱nggo̱ Yamba ru? Di̱ngi̱n banabi̱ndi̱ leendi wa a twiyongo kana pi̱yau̱ a si̱ma. ");
INSERT INTO wja_vpl VALUES ("J14_2","092_4_2","1JN","4","2","2","Ti̱na nyinou wu yi ku̱rani̱ we̱i̱ mi̱n ne̱re̱ wo̱o̱ yi̱ Bawei Yambai̱, kana we̱ wu le̱e̱ ki̱n Yesu Masiya baa mi̱ri̱nggi̱ bu̱ri̱, wo̱o̱ ne̱re̱ wo̱o̱ yi̱ Bawei Yambai̱. ");
INSERT INTO wja_vpl VALUES ("J14_3","092_4_3","1JN","4","3","3","Anda ne̱re̱ wu le̱e̱ bu̱ yi̱to̱ a dwii Yesu, yaa Bawei Yambai̱. Bawei du wo̱o̱ yi̱ to̱no̱i̱ dwii du bace̱n Masiya, bu nu̱wa ki̱n baa we̱i̱, yo̱ko̱ a gaci̱la baa, a mi̱ri̱nggu̱ si̱ma. ");
INSERT INTO wja_vpl VALUES ("J14_4","092_4_4","1JN","4","4","4","Kwaraa muwa, mba bu yo̱o̱gi̱ bu Yamba wa, bu gwala di̱mbi̱re̱ banabi̱ndi̱ leendu wa, di̱ngi̱n Bawei du mi̱ri̱nggi̱ mbi̱ri̱ a gwala bawei du nu̱wa bu si̱ma wa. ");
INSERT INTO wja_vpl VALUES ("J14_5","092_4_5","1JN","4","5","5","Pma bwii bu si̱ma wa, di̱ngi̱n to̱no̱ kana ca tu pma ce̱gu̱ twii tu si̱mai̱, pero nu̱wa bu si̱ma wa nu̱u̱ pma. ");
INSERT INTO wja_vpl VALUES ("J14_6","092_4_6","1JN","4","6","6","Anda yi yo̱o̱gi̱ bu Yamba wa. Kana we̱ wu so̱m Yamba kar twiyau yi̱ yo, anda kana we̱ wu yaa yo̱o̱gi̱ wu Yamba yaa kar twiyau yi̱ yo. A bo̱nggo̱ yi̱to̱ yi so̱m ne̱re̱ wu yi̱ Bawei du ji̱re̱i̱ yi̱ du leendi. ");
INSERT INTO wja_vpl VALUES ("J14_7","092_4_7","1JN","4","7","7","Basi̱mba muwa bu n kangni̱ wa, yi kangman bu̱ri̱, di̱ngi̱n kangam baa bo̱nggo̱ Yambau̱. Kana we̱ wu ju̱ku̱r kangam twii bo̱l Yamba pero a so̱m Yamba. ");
INSERT INTO wja_vpl VALUES ("J14_8","092_4_8","1JN","4","8","8","Kana we̱ wu yaa ju̱ku̱r kangam so̱m bu Yamba, di̱ngi̱n Yamba twii kangam. ");
INSERT INTO wja_vpl VALUES ("J14_9","092_4_9","1JN","4","9","9","Ti̱na kanda ku Yamba ju̱ku̱ yir kangam yo̱u̱, a tu̱mu̱we̱ Bo̱l yo̱ yi̱ wundu a mi̱ri̱nggi̱ si̱ma, palaka yi nyi̱ngga pi̱i̱ma a bo̱nggo̱ yo̱u̱. ");
INSERT INTO wja_vpl VALUES ("J14_10","092_4_10","1JN","4","10","10","Ti̱na kanda ku kangam yi̱ to̱no̱u̱, bwii bu yo yi kangman Yamba ne̱, anda yo̱ kang yiro a tu̱mwe̱ bo̱l yo̱ palaka ba yo̱o̱ ni̱i̱ di̱ngi̱n pargu̱ si̱ye̱i̱ sukom we̱le̱mdi̱ yiri. ");
INSERT INTO wja_vpl VALUES ("J14_11","092_4_11","1JN","4","11","11","Basi̱mba muwa bu n kangni̱ wa, yake̱ ku Yamba kang yiro ko̱, tagi̱ yo mwa yi kangman bu̱ri̱ yiri. ");
INSERT INTO wja_vpl VALUES ("J14_12","092_4_12","1JN","4","12","12","Yaa wu ti̱i̱ ko̱gu̱ Yambau̱, anda ka yi kangman bu̱ri̱, Yamba ni̱nggu̱ naapu yi̱ yo, pero kangam yo̱u̱ twangwa a cu̱di̱ yiri. ");
INSERT INTO wja_vpl VALUES ("J14_13","092_4_13","1JN","4","13","13","Yi so̱ma mi̱n yi ni̱nggu̱ naapu kem yi̱ Yamba, yika pi̱su̱ kem yi̱ yo, di̱ngi̱n yo̱ nyi̱i̱ yiri Bawei ye̱i̱. ");
INSERT INTO wja_vpl VALUES ("J14_14","092_4_14","1JN","4","14","14","Yo yiri yiri, yi ko̱ pero yi nyi̱i̱ se̱e̱daki̱ bu kangga mi̱n Mbaate̱ a tu̱mmu̱we̱ Bo̱l yo̱ ba yo̱o̱ ne̱re̱ wu mi̱r we̱i̱ si̱ma. ");
INSERT INTO wja_vpl VALUES ("J14_15","092_4_15","1JN","4","15","15","Kana we̱ wu ce̱ ki̱n, Yesu twii Bo̱l Yamba, a ni̱nggu̱ naapu kem yi̱ Yamba, yika pi̱su̱ kem yi̱ yo̱. ");
INSERT INTO wja_vpl VALUES ("J14_16","092_4_16","1JN","4","16","16","Yo yir yiri, yi so̱ma pero yi le̱e̱ ji̱re̱ yi̱ kangam Yambau̱ wu ju̱ku̱ yirou. Yamba twii kangam, kana we̱ wu ju̱ku̱r kangam, a ni̱nggu̱ pi̱su̱ naapu kem yi̱ Yamba, Yamba yika kem yi̱ yo̱. ");
INSERT INTO wja_vpl VALUES ("J14_17","092_4_17","1JN","4","17","17","Kangam yo̱o̱ ci̱maci̱ma a cu̱di̱ yiri palaka yi nu̱u̱ ya gwasi̱ a nyanggu̱ ku Yamba ni̱ng we̱i̱ balu, di̱ngi̱n yi ni̱nggu̱ pi̱su̱ naapu yi̱ yo̱ a pi̱na si̱ma bi̱naa, ci̱ka ku Masiya yi̱ to̱no̱u̱. ");
INSERT INTO wja_vpl VALUES ("J14_18","092_4_18","1JN","4","18","18","Kana we̱ wu Yamba kangne̱ yaa gwasi̱ Yamba. Anda kangam wu ci̱maci̱ma ke̱e̱ri̱ si̱yau̱ gwasi̱, di̱ngi̱n ka ne̱r nu̱u̱gu̱ gwasu̱ a gwasu̱gu̱ ti̱i̱gu̱ ku̱u̱lu̱ a nyanggu̱ balu. Ne̱re̱ wu nu̱u̱ gwasi̱ kangam yo̱u̱ yaa ci̱maci̱ma. ");
INSERT INTO wja_vpl VALUES ("J14_19","092_4_19","1JN","4","19","19","Yi ju̱ku̱r kangam di̱ngi̱n Yamba kang yiro gawu̱ri̱yo̱. ");
INSERT INTO wja_vpl VALUES ("J14_20","092_4_20","1JN","4","20","20","Kana we̱ wu ce̱ ki̱n, yo̱ kangman Yamba, anda kwaa bago̱n yo̱ wu po̱nggu̱, yo̱o̱gi̱ baleendo. Di̱ngi̱n kana we̱ wu kangman bu bago̱n yo̱ wu ko̱gu̱, na puu kangman Yamba wu yaa ko̱gu̱. ");
INSERT INTO wja_vpl VALUES ("J14_21","092_4_21","1JN","4","21","21","Te̱e̱ri̱ du Masiya nyi̱i̱ yiro twii, kana we̱ wu kangman Yamba, tagi̱ ba kangman bago̱n yo̱ mwaasi̱. ");
INSERT INTO wja_vpl VALUES ("J15_1","092_5_1","1JN","5","1","1","Kana we̱ wu le̱e̱ ki̱n, Yesu wii Masiya, twii bo̱l Yamba, kana we̱ wu kangman Mbaate̱ kangman Bo̱l yo̱ mwaasi̱. ");
INSERT INTO wja_vpl VALUES ("J15_2","092_5_2","1JN","5","2","2","Ti̱na kanda ku yi so̱ma mi̱n yi kangman kwaraa Yamba wa, a bo̱nggo̱ kangman Yamba yi̱ po̱ngo̱ndi̱ yi̱ te̱e̱ri̱ng ye̱i̱. ");
INSERT INTO wja_vpl VALUES ("J15_3","092_5_3","1JN","5","3","3","Ka yi kangman Yamba yi ni̱ng po̱ngo̱ndi̱ yi̱ te̱e̱ri̱ng ye̱i̱. Pero te̱e̱ri̱ng ye̱i̱ yaa buu. ");
INSERT INTO wja_vpl VALUES ("J15_4","092_5_4","1JN","5","4","4","Kana we̱ wu twii bo̱l Yamba a gwala di̱mbi̱r wu̱rangi̱ tu bwi̱i̱ tu si̱mai̱. Wunaa di̱mbi̱ri̱ wu gwala di̱mbi̱r si̱ma, twii le̱e̱gu̱ ji̱re̱ yiru. ");
INSERT INTO wja_vpl VALUES ("J15_5","092_5_5","1JN","5","5","5","Wu gwalu we̱i̱ di̱mbi̱r si̱ma we̱? Ko̱po̱ ne̱re̱ wu le̱e̱ ji̱re̱ ki̱n, Yesu twii Bo̱l Yamba. ");
INSERT INTO wja_vpl VALUES ("J15_6","092_5_6","1JN","5","6","6","Nu̱wa ju̱ku̱ Yesu Masiya twii Bo̱l Yamba, bo̱nggo̱ bati̱si̱ma yo̱ yi̱ gundu pero yi̱ pargu̱ si̱ye̱i̱ ti̱i̱ma ya a ye̱u̱, yaa bo̱nggo̱ gundu yi̱ wundu ti̱bak, anda kem yi̱ gundu yi̱ ti̱i̱ma. Bawei mwaasi̱ a nyi̱i̱ se̱e̱daki̱ to̱o̱ wo̱o̱ to̱o̱ ji̱re̱, di̱ngi̱n twii Bawei du ji̱re̱. ");
INSERT INTO wja_vpl VALUES ("J15_7","092_5_7","1JN","5","7","7","Wo̱o̱ yi̱ se̱e̱daki̱ndi̱ kunong bu nyi̱i̱ se̱e̱daki̱ ki̱n Yesu twii Bo̱l Yamba. ");
INSERT INTO wja_vpl VALUES ("J15_8","092_5_8","1JN","5","8","8","Bawei, yi̱ gundu, yi̱ ti̱i̱ma pma nyi̱i̱ se̱e̱daki̱ wiino. ");
INSERT INTO wja_vpl VALUES ("J15_9","092_5_9","1JN","5","9","9","Yi le̱e̱ yi̱ se̱e̱daki̱ nu̱wa, anda se̱e̱daki̱ Yamba a gwala mwa mwa, to̱o̱ se̱e̱daki̱ wu Yamba nyi̱i̱ya a dwii Bo̱l ye̱i̱. ");
INSERT INTO wja_vpl VALUES ("J15_10","092_5_10","1JN","5","10","10","Kana we̱ wu le̱e̱ ji̱re̱ yi̱ Bo̱l Yamba wo̱o̱ yi̱ wo̱o̱ se̱e̱daki̱ a mi̱ri̱nggi̱ gaanggu̱ yo̱u̱, anda pma bu le̱e̱ bu ji̱re̱ yi̱ Yamba, a de̱ twii baleendo, di̱ngi̱n yaa ku̱ le̱e̱ ji̱re̱ yi̱ yi̱ri̱ tu Yamba ce̱ a dwii Bo̱l ye̱i̱. ");
INSERT INTO wja_vpl VALUES ("J15_11","092_5_11","1JN","5","11","11","Se̱e̱daki̱ wii ki̱n, Yamba nyi̱i̱ yir pi̱i̱ma bu yaa mati̱rwa, pi̱i̱ma bi̱naa a mi̱ri̱nggi̱ Bo̱l ye̱i̱. ");
INSERT INTO wja_vpl VALUES ("J15_12","092_5_12","1JN","5","12","12","Kana we̱ wu wo̱o̱ yi̱ Bwi̱ya wo̱o̱ yi̱ pi̱i̱ma, anda kana we̱ wu yaa Bo̱l Yamba yaa pi̱i̱ma. ");
INSERT INTO wja_vpl VALUES ("J15_13","092_5_13","1JN","5","13","13","N bala mbi̱ra ti̱na yi̱ri̱, mba bu le̱e̱ ji̱re̱ yi̱ Bo̱l Yamba wa, palaka bu so̱ma mi̱n, bu bo̱o̱ yi̱ pi̱i̱ma bu yaa mati̱rwa. ");
INSERT INTO wja_vpl VALUES ("J15_14","092_5_14","1JN","5","14","14","Yi ti̱n ti̱ye̱ndi̱ a gawu̱r Yamba yaa gwasi̱ di̱ngi̱n yi so̱ma mi̱n nu̱u̱ yiri ka yi senggi kana ca cu̱u̱ngi̱ dangandi̱ ye̱i̱. ");
INSERT INTO wja_vpl VALUES ("J15_15","092_5_15","1JN","5","15","15","Yake̱ ku yi so̱ma mi̱n nu̱u̱ yiri ko̱, yi so̱ma mi̱n yo̱ nyi̱i̱ yir kana ca tu yi senggo. ");
INSERT INTO wja_vpl VALUES ("J15_16","092_5_16","1JN","5","16","16","Ka kana we̱ kwe̱e̱ bago̱n yo̱ ni̱nggu̱ we̱le̱m wu yinnibu bo̱o̱ri̱ ne̱, ba ce̱ ku̱ru̱ a bo̱nggo̱ Yamba pero yo̱ nyi̱i̱ we̱i̱ pi̱i̱ma pma bu ni̱nga we̱le̱m wu yinnibu bo̱o̱ru̱. Anda pma bu we̱le̱m pmau yinno bo̱o̱ru̱, n ce̱ bu mi̱n bu ce̱ ku̱ru̱ di̱ngi̱n ko̱o̱ duu nu̱wau̱. ");
INSERT INTO wja_vpl VALUES ("J15_17","092_5_17","1JN","5","17","17","Ni̱nggu̱ kana ca tu bwi̱i̱ twii we̱le̱m, anda wo̱o̱ yi̱ we̱le̱m wu yinnibu bo̱o̱re̱. ");
INSERT INTO wja_vpl VALUES ("J15_18","092_5_18","1JN","5","18","18","Yi so̱ma mi̱n kana we̱ wu twii bo̱l Yamba, yaa je̱e̱ gawu̱ri̱ yi̱ ni̱nggu̱ we̱le̱m, di̱ngi̱n Bo̱l Yamba swe̱ri̱ pma, palaka Balaa Buwai ba mwani̱ ya yo̱. ");
INSERT INTO wja_vpl VALUES ("J15_19","092_5_19","1JN","5","19","19","Yi so̱ma mi̱n yi kwaraa Yamba wa, kana ku si̱ma bi̱naa a wai Balaa Buwai. ");
INSERT INTO wja_vpl VALUES ("J15_20","092_5_20","1JN","5","20","20","Yi so̱ma mi̱n Bo̱l Yamba a baa a nyi̱i̱ yir so̱mandi̱ di̱ngi̱n yi so̱m Yamba, yo̱ wu twii ji̱re̱. Yo mwa yi bo̱o̱ ni̱ng naapu yi̱ yo̱ wu twii ji̱re̱, pero yi bo̱o̱ ni̱ng naapu yi̱ Bo̱l yo̱ Yesu Masiya. Yo̱ twii Yamba wu ji̱re̱ pero yi̱ pi̱i̱ma bu yaa mati̱rwa. ");
INSERT INTO wja_vpl VALUES ("J15_21","092_5_21","1JN","5","21","21","Kwaraa muwa, bu ta dwii mbi̱ri̱ kundi bu cwaa kana ca tu de̱manu̱ we̱i̱ gaanggu̱ mbi̱ru̱ a bo̱nggo̱ Yambau̱.");
INSERT INTO wja_vpl VALUES ("J21_1","093_1_1","2JN","1","1","1","Wuna lakargar twiiwe bo̱nggo̱ mu ne̱re̱ wu gi̱ra wu ikkilisiya. N balaman nu̱ru̱ wu Yamba se̱ka kem yi̱ kwaraa ya, wu n kangman pma ku manggu. Bu̱ri̱ mi yi̱ wundu ne̱, anda mwaasi̱ yi̱ pma bu so̱m ji̱re̱ wa. ");
INSERT INTO wja_vpl VALUES ("J21_2","093_1_2","2JN","1","2","2","Yi kang mbi̱ri̱ di̱ngi̱n ji̱re̱ wu gaanggu̱ yiru, pero si̱i̱ we̱i̱ kem yi̱ yo kana pe̱ne̱ pe̱ne̱. ");
INSERT INTO wja_vpl VALUES ("J21_3","093_1_3","2JN","1","3","3","Bo̱o̱ ni̱i̱u̱ yi̱ bunam yi̱ pi̱dau̱ gaanggu̱ wu Yamba Kwiite yi̱ Yesu Masiya Bo̱l Yamba ba si̱ya kem yi̱ yo a mi̱ri̱nggi̱ ji̱re̱ yi̱ kangam. ");
INSERT INTO wja_vpl VALUES ("J21_4","093_1_4","2JN","1","4","4","N ni̱nga bu̱ri̱ de̱gde̱g ku n nu̱wa ki̱n kwaraa ma bu kangga bo̱o̱ po̱nggu̱ ji̱re̱, ci̱ka ku Yamba Mbaa yire sa yiro ki̱n yi ni̱ngau̱. ");
INSERT INTO wja_vpl VALUES ("J21_5","093_1_5","2JN","1","5","5","N wo̱o̱ senggu mo̱, nu̱re̱, yi kangman bu̱ri̱ mwa mwa, to̱o̱ te̱e̱ri̱ du pu̱ci̱ ne̱, do̱o̱ du yi bo̱o̱ yi̱ to̱no̱ yake̱ taa yau̱. ");
INSERT INTO wja_vpl VALUES ("J21_6","093_1_6","2JN","1","6","6","Kangam wu ji̱re̱u̱ twii yi ni̱nga tu Yamba ce̱ ki̱n yi ni̱ngai̱. Te̱e̱ri̱ du bu nu̱wa yake̱ taa yau̱, twii bu ni̱nga pi̱su̱ kangam. ");
INSERT INTO wja_vpl VALUES ("J21_7","093_1_7","2JN","1","7","7","N ce̱ yi̱to̱ di̱ngi̱n nu̱wa bu ciyeni nu̱wa tum a twiyongo kana pi̱yau̱ a si̱ma bi̱na. Pma bu le̱e̱ bu ki̱n Yesu Masiya a baa mi̱ri̱nggi̱ bu̱ri̱ ci̱ka ne̱re̱. Ko̱o̱ duu nu̱wau̱ to̱o̱ nu̱wa bu ciyeni nu̱wa wa pero yi̱ bace̱mba Masiya wa. ");
INSERT INTO wja_vpl VALUES ("J21_8","093_1_8","2JN","1","8","8","Bu ruun tu̱we̱, di̱ngi̱n bu bwiyani ya wu̱rai̱ du yi ni̱ngai̱ a bo̱nggo̱ mbi̱ru̱, palaka bu nyi̱ngga wo̱ri̱ri̱ mbi̱ri̱ ci̱maci̱ma. ");
INSERT INTO wja_vpl VALUES ("J21_9","093_1_9","2JN","1","9","9","Kana we̱ wu ti̱i̱ni̱ bu tu Yesu Masiya ju̱ku̱ya anda cwata yi̱ri̱ tu kanggi̱, wo̱o̱ ne̱re̱ yaa Yamba. Anda ne̱re̱ wu ti̱i̱na yi̱ri̱ngi̱ tu Masiya ju̱ku̱ya, wo̱o̱ yi̱ Mbaate̱ yi̱ Bwi̱ya. ");
INSERT INTO wja_vpl VALUES ("J21_10","093_1_10","2JN","1","10","10","Ka ne̱re̱ wu kanggi̱ baa ju̱ku̱gu̱ mbi̱ri̱ yi̱ri̱ngi̱ tu kanggi̱ twe̱e̱ye̱i̱ yi̱ yi̱ri̱ tu Masiya ju̱ku̱ mbi̱rai̱, bu yi̱ri̱ ya pma a laandi mbi̱ri̱, pero bu ci̱ri̱ ya pma. ");
INSERT INTO wja_vpl VALUES ("J21_11","093_1_11","2JN","1","11","11","Kana we̱ wu ci̱ pma a te̱ca dwii yi̱ pma a bo̱nggo̱ ni̱nggu̱ wu̱rangi̱ pmai̱ tu bwi̱i̱. ");
INSERT INTO wja_vpl VALUES ("J21_12","093_1_12","2JN","1","12","12","N wo̱o̱ yi̱ yi̱ri̱ng tum tu n sambi̱ri̱ we̱i̱, anda n yaa kasi̱ n bala mbi̱ra a lakargar ti̱bak. N danggi̱gu̱ n kaca mbu̱we̱, ba yi ce̱ ci̱ye̱i̱ yi̱ nunge yi̱ nunge, palaka bu̱ri̱ de̱gde̱g yiru ba twangwa. ");
INSERT INTO wja_vpl VALUES ("J21_13","093_1_13","2JN","1","13","13","Kwaraa ci̱ya mo̱ wu nu̱re̱ wu Yamba se̱ka bo̱o̱ ci̱gu̱ mo̱u̱.");
INSERT INTO wja_vpl VALUES ("J31_1","094_1_1","3JN","1","1","1","Wuna lakargar twiiwe bo̱nggo̱ mu ne̱re̱ wu gi̱ra wu ikkilisiya. Aari bo̱nggo̱ basi̱n mi Gayus, wu n kangni̱ ku̱ ji̱rau̱. ");
INSERT INTO wja_vpl VALUES ("J31_2","094_1_2","3JN","1","2","2","Basi̱n mi wu n kangni̱, n wo̱o̱ ce̱mi̱n ku̱ru̱ mi̱n kana ca ba aara ci̱maci̱ma pero ma ki̱ngga bu̱ri̱ cingcing, ci̱ka ku ma cingcing a mi̱ri̱nggi̱ bawei. ");
INSERT INTO wja_vpl VALUES ("J31_3","094_1_3","3JN","1","3","3","N ni̱ngga bu̱ri̱ de̱gde̱g wang, pu nu̱wa bu po̱nggu̱ bu kangga baanga sangge̱ ji̱re̱ wu mai to̱no̱, pero yi̱ kanda ku ma wo̱o̱ po̱nggu̱ ji̱re̱ kana pe̱ne̱ pe̱ne̱. ");
INSERT INTO wja_vpl VALUES ("J31_4","094_1_4","3JN","1","4","4","Yaa tu diingini ni̱nggu̱ bu̱ri̱ de̱gde̱g wang, ci̱ka ka n nu̱wi̱ ki̱n kwaraa muwa bo̱o̱ ni̱nggu̱ po̱ngo̱ndi̱ yi̱ ji̱re̱. ");
INSERT INTO wja_vpl VALUES ("J31_5","094_1_5","3JN","1","5","5","Basi̱n mi wu n kangne̱, ma wo̱o̱ yi̱ ji̱re̱ a bo̱nggo̱ wu̱rangi̱ tu ma wo̱o̱ ni̱ngaman ki̱yaa ma bu po̱nggu̱ wa, kana ku pma twii ru̱nggu̱wa. ");
INSERT INTO wja_vpl VALUES ("J31_6","094_1_6","3JN","1","6","6","Pma ba sa ikkilisiya wu pi̱na kangam wu ma ju̱ku̱ pmau. Kamkam ma kalanga pma, ba je̱ gawu̱re̱ yi̱ so̱ngma pma a nyinou wu Yamba nu̱u̱ we̱i̱ teng yo̱u̱. ");
INSERT INTO wja_vpl VALUES ("J31_7","094_1_7","3JN","1","7","7","Di̱ngi̱n pma twiyongo ba wasi̱ din Masiya, pero pma yaa yi̱ri̱ kalanggu̱ a bo̱nggo̱ nu̱wa bu yaa po̱nggu̱ wa. ");
INSERT INTO wja_vpl VALUES ("J31_8","094_1_8","3JN","1","8","8","A daaya yi kalanga ko̱o̱ duu nu̱wau̱, di̱ngi̱n yi te̱ca dwii kem a mi̱ri̱nggi̱ wu̱rai̱ du ji̱re̱i̱. ");
INSERT INTO wja_vpl VALUES ("J31_9","094_1_9","3JN","1","9","9","N balaman ikkilisiya lakargar, anda Diyotiripis a kwaa ba yi̱ ci̱ye̱i̱ yiri di̱ngi̱n yo̱ kasi̱ gi̱ru̱. ");
INSERT INTO wja_vpl VALUES ("J31_10","094_1_10","3JN","1","10","10","Ka n baai̱, baa n puru we̱i̱ tu ni̱nggi̱, yi̱ ce̱wi̱ tu bwi̱i̱ tu leendi tu ce̱i̱ dwii yiri, bur to̱o̱ yi̱ wundu ne̱, bambam a kwaa yi̱gu̱ ki̱yaa bu po̱nggu̱wa bu baanga wa, pero a ja pma bu kasi̱ ba yi̱ pma wa, a ke̱e̱ pma a mi̱ri̱nggu̱ ikkilisiya. ");
INSERT INTO wja_vpl VALUES ("J31_11","094_1_11","3JN","1","11","11","Basi̱n mi wu n kangne̱, ma ti̱lani̱ ya tu bwi̱i̱, anda ma ti̱langa tu nyaai. Kana we̱ wu ni̱ng tu nyaai wii wu Yamba. Anda yo̱ wu ni̱ng tu bwi̱i̱ so̱m bu Yamba kana banyi̱na. ");
INSERT INTO wja_vpl VALUES ("J31_12","094_1_12","3JN","1","12","12","Kana we̱ ce̱e̱ tu nyaai a dwii Demetiriyus, ji̱re̱ yi̱ri̱ ye̱i̱ a nyi̱i̱ se̱e̱daki̱ a dwii ye̱i̱. Yo mwa yi nyi̱i̱ se̱e̱daki̱, pero ma so̱ma mi̱n tu yi ce̱ twii ji̱re̱. ");
INSERT INTO wja_vpl VALUES ("J31_13","094_1_13","3JN","1","13","13","N wo̱o̱ yi̱ yi̱ri̱ng tum tu n sa mi̱ni̱ we̱i̱, anda n yaa kasi̱ n bala mi̱na a lakargar ti̱bak. ");
INSERT INTO wja_vpl VALUES ("J31_14","094_1_14","3JN","1","14","14","N danggi̱gu̱ n kaca muwe pi̱na yi̱ jo̱r banyi̱na, yi ce̱ ci̱ye̱i̱ nunge yi̱ nunge. ");
INSERT INTO wja_vpl VALUES ("J31_15","094_1_15","3JN","1","15","15","Yama pi̱dau̱ gaanggu̱ ba si̱ya kem yi̱ mo̱. Basi̱mba ma mwa mwa bo̱o̱ ci̱gu̱ mo̱u̱. Ma ci̱ basi̱mba yiwu bu po̱o̱ wa kana wo̱no̱ wiino.");
ALTER TABLE wja_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
