﻿USE sofia;
DROP TABLE IF EXISTS sofia.wiv_vpl;
CREATE TABLE wiv_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES wiv_vpl WRITE;
INSERT INTO wiv_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Na hizani habu tubuni Iesus Kristus. A Iesus ia na tubuni Devit, a Devit ia tubuni Abraham. ");
INSERT INTO wiv_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","A Abraham ia tamani Aisak, a Aisak ia tamani Jekop, a Jekop ia tamani Iuda kamani habu tazina, ");
INSERT INTO wiv_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","a Iuda ia tamani Peres hiro a Sera. Tinahiro ia a Tamar, a Peres ia tamani Hesron, a Hesron ia tamani Ram, ");
INSERT INTO wiv_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","a Ram ia tamani Aminadap, a Aminadap ia tamani Nason, a Nason ia tamani Salmon, ");
INSERT INTO wiv_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","a Salmon gona a Rahap, tuhiro a Boas. A Boas gona a Rut, tuhiro a Obet. A Obet ia tamani Jesi. ");
INSERT INTO wiv_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","A Jesi ia tamani King Devit. A Devit ia tamani Solomon. Tinana muga ia na goni Uria. ");
INSERT INTO wiv_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","A Solomon ia tamani Rehoboam, a Rehoboam ia tamani Abiya, a Abiya ia tamani Asa, ");
INSERT INTO wiv_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","a Asa ia tamani Jehosafat, a Jehosafat ia tamani Jehoram, a Jehoram ia tamani Usia, ");
INSERT INTO wiv_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","a Usia ia tamani Jotam, a Jotam ia tamani Ahas, a Ahas ia tamani Hesekia, ");
INSERT INTO wiv_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","a Hesekia ia tamani Manase, a Manase ia tamani Emon, a Emon ia tamani Josaia. ");
INSERT INTO wiv_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","A Josaia ia tamani Jehoiakin kamani habu tazina. Kilangata kua dia te peola vano dia kene karabusianga ni Babilon. ");
INSERT INTO wiv_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Muri na kua dia te vano karabus ni Babilon: A Jehoiakin ia tamani Sealtiel, a Sealtiel ia tamani Serubabel, ");
INSERT INTO wiv_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","a Serubabel ia tamani Abiut, a Abiut ia tamani Eliakim, a Eliakim ia tamani Asor, ");
INSERT INTO wiv_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","a Asor ia tamani Sadok, a Sadok ia tamani Akim, a Akim ia tamani Eliut, ");
INSERT INTO wiv_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","a Eliut ia tamani Eleasar, a Eleasar ia tamani Matan, a Matan ia tamani Jekop, ");
INSERT INTO wiv_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","a Jekop ia tamani Iosep, goni Maria, kua e valohia a Iesus, kua e kohanga ni Kristus. ");
INSERT INTO wiv_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Habu tubuni Abraham e 14 ki vano mule ni Devit, 14 ve ni Devit ki vano mule na taem kena dia te karabus ni Babilon, na karabus ni Babilon ki vano na taem ke Kristus kua ti valohua, dia ve dia ta 14. ");
INSERT INTO wiv_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Belea ke Iesus Kristus ia bele barae: Tinana a Maria e makua kete kabania a Iosep, palaka muri hiro kene mia rua, a Maria kava ia ti kove na vuna na matuhanga kana Vule Tumonga. ");
INSERT INTO wiv_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","A Iosep goni Maria ia e kaka mahoto ki beta ni kulina kete katia a Maria ni puae na matana manumanu, kubarae ki ngoro na kana lohoihoia za kete vati rogonia za. ");
INSERT INTO wiv_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","A Iosep e ba lolohoi vuvu na goloa kua, na engel kana Paraha ia bele vona na manginunginua ki tania, “Iosep tubuni Devit, taua nu kuahi koto pelea a Maria kara go, na vuna kapiru kena na magalina ia e bele na matuhanga kana Vule Tumonga. ");
INSERT INTO wiv_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","A Maria da e valohia kapiru tamohane katiu, da tu kohania hizana ni Iesus, na vuna ia da e vaikoli kara kana manumanu na kadia manaunaua.” ");
INSERT INTO wiv_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Goloaloa laveve kua e bele kete pori matoto na polea kana Paraha kua e tania na havana kana profet ki tani barae, ");
INSERT INTO wiv_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Miu longoria, na tavine tizula kua ma beta ni ngoro kamana tamohane katiu da e magalina ki valohia kapiru tamohane katiu, da e kohanga ia ni Imanuel.” Vuvuna hiza kua e tani barae, “A Vuvu e kamadolu.” ");
INSERT INTO wiv_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Kamana a Iosep ki lama, ia kabania a Maria habuka kua na engel ke Vuvu e tania vona kete katia. ");
INSERT INTO wiv_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Palaka ki beta ni ngoro kamani Maria ia ki vano muri na dama ti valohia na kapiru tamohane. Ia kohania hizana ni Iesus. ");
INSERT INTO wiv_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","A Maria e valohia a Iesus na poloka taon Betlehem ni distrik a Iudea, kilangata kua a Herot e king. Na saveman taza dia ta pe ni Ist, dia ta mai kiri Ierusalem. ");
INSERT INTO wiv_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Dia ka mai huhule kirina dia ka tania, “Kue kapiru kena e valohua kua kete kara King ke vuni Iuda? Hita ta hada kana vitovito na kahita malala rae ni Ist. Hita ka mai hita kata lotu vona.” ");
INSERT INTO wiv_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Tania a King Herot ki longoria polea kua, e vairohia matoto kana lohoihoia, ia mai ve dia manumanu laveve ni Ierusalem dia ta lohoi vuvu ve. ");
INSERT INTO wiv_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ia koi lupunia na hetpris kamahi kamana tisa kamahi kara lo. Ia hulenidia, “Da e valohua a Kristus ni ve matoto?” ");
INSERT INTO wiv_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Dia ta tania, “Na taon a Betlehem na poloka distrik a Iudea, na vuna na profet e vapolungania ki tani barae, ");
INSERT INTO wiv_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Palaka, ho a Betlehem tu malala kote matoto, na garigari ke vuni Iuda, palaka ho da tu dopa ku hizanga na taon laveve kua ni Iudea. Na vuna na poloko, da Paraha katiu e bele kete vamuga ni vatunga dala na kagu manumanu a Israel.’” ");
INSERT INTO wiv_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Pale, a Herot ia kohani rogonia na saveman kamahi kua bukuna palaka kua na voro e zazahe vona, ia hulenidia na dama kakei matoto kua dia ta hada na vitovito e bele vona. ");
INSERT INTO wiv_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Pale, ia geridia vano kiri Betlehem ki tania ni dia, “Miu vano kaze papa kara kapiru kena. Miu kene paria. Miu ta tani hoto kagu. Hau ve kata vano lotu vona.” ");
INSERT INTO wiv_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Dia ta longo hozovia na polea kana king, dia ta vavana. Na vitovito kua dia ta muga hada ni Ist, ia vamuga mule ni dia, ia vano pati na huduna ruma kua na kapiru e ngongoro vona. ");
INSERT INTO wiv_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Kamana dia ka hada na vitovito kua, dia ta hilohilo matoto. ");
INSERT INTO wiv_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Dia ta vano hoho na ruma, dia ta hada na kapiru kamani titinana a Maria. Dia ta padonia tuturudia, bakadia ki ziho kara garigari, dia ta lotu vona. Dia ta vukazia kadia presen kamahi na gol, virauh mai na mir, dia ta vala kana kapiru. ");
INSERT INTO wiv_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Pale, dia ta pe na dala motu, dia kene vamule kara kadia kantri, na vuna a Vuvu ti kalohu hoto kadia na manginunginua habuka beta dia kata vamule ni Herot. ");
INSERT INTO wiv_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Muri na saveman kamahi kua dia te vavana, na engel katiu kana Paraha e bele ni Iosep na manginunginua ki tania vona, “Lama nu pelea kapiru kamani titinana miu na hava vano kiri Isip. Miu mia ra kena, ki mule na dama hau mule ka tania miu ka vamule. Na vuna a Herot da e kaze kara kapiru kete hubi matehia.” ");
INSERT INTO wiv_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Pale, ia lama, pelea kapiru kamani titinana dia kene vavana na marigo kiri Isip. ");
INSERT INTO wiv_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Dia ta mia ni Isip ia ia ki vano a Herot ki mate. Goloa kua e bele kete pori matoto na polea katiu kua a Vuvu e tania na havana kana profet ki tani barae, “Hau ta kohani mulehia tugu ki gotala ni Isip.” ");
INSERT INTO wiv_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Tania a Herot ki lala baraenia habuka na saveman kamahi kua dia te rukia, magalina e halavidi matoto. Ia vala polea matuha matoto na kana soldia kamahi dia kata vaihubi mate kapirupiru tamomohane kua kadia krismas ti rua ki ziho mule, ni Betlehem ia mai ve na palakalaka kua kozoho ve ni Betlehem. Ia e kati baraenia na vuna e haze dangea na taem kua na saveman kamahi kua dia ta tania na vitovito e bele vona. ");
INSERT INTO wiv_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ia ti kubarae kini pori matoto na polea ke profet Jeremaia, kua e tani barae, ");
INSERT INTO wiv_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Halingana kaka katiu e longora ni Rama, na halingana tangia kapou matoto. A Resel e tatangizia habu tutuna ki beta matoto ni kulina kete taloa ni manga, na vuna ti beta habu tutuna.” ");
INSERT INTO wiv_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Muri a Herot ti mate, na engel katiu kana Paraha e bele ni Iosep na manginunginua ni Isip, ");
INSERT INTO wiv_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ki tania, “Madiri nu pelea kapiru kamani titinana miu na vamule vano kiri Israel, nuhu kua dia ta paparakilania dia kata hubi matehia na kapiru, dia te varimateai.” ");
INSERT INTO wiv_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Pale, a Iosep ia di madi, ia pelea kapiru kamani titinana dia kene vamule kiri Israel. ");
INSERT INTO wiv_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Palaka kamana a Iosep ki longoria habuka a Arkelaus ti pelea mudini tamana a Herot kini kara king ni Iudea, a Iosep ia kuahi kete vano kiri Iudea. Pale, na manginunginua katiu ve, ia tanga voa vona kete vano kara provins ni Galili. ");
INSERT INTO wiv_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ia vano kini mia na taon kua e kohanga ni Nasaret. Kubarae nazia kua na profet kamahi dia ta tania varira, ti pori, “Da ia ti kohanga ia na kaka bukuni Nasaret.” ");
INSERT INTO wiv_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Na dama kamahi kua, a Jon Kakanaka Baptais e mai kini kakalohunia na manumanu na poloka deset ni Iudea, ");
INSERT INTO wiv_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ki tatani barae, “Miu pokizia kamiu mogemoge, na kingdom ke Vuvu ti mai kini kozoho!” ");
INSERT INTO wiv_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","A Jon ia na kaka kua a profet Aisaia e popole vona varira ki tani barae, “Na kaka katiu e gogoe na poloka deset ki tatani barae, ‘Vaida dala kara Paraha, katia dala kamahi ni mahoto kirina!’” ");
INSERT INTO wiv_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Zohozohoa ke Jon e katua na vuluka kamel, ki taza lete kua e katua na hulita bulmakau na votaka. Ki lala kete hahania pidogo kamana hani bukuna mugomugo. ");
INSERT INTO wiv_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Manumanu laveve bukuni Ierusalem ni Iudea, ia mai na malala laveve kena ni Iordan dia ta mamai ni Jon. ");
INSERT INTO wiv_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Dia ka tatani kakava kadia manaunaua, ia ki vavazuguvidia na poloka naru a Iordan. ");
INSERT INTO wiv_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Tania a Jon ki hadavia kua a vuni Parisi kamani vuni Sadyusi luba dia te mamai vona kete vazuguvidia, ia tania kiridia, “Miu habu tutuna humata kamahi! Azei ti kalohu hoto kamiu, kua miu kene vavarihavai na magali varitihia ke Vuvu kua ti mamai? ");
INSERT INTO wiv_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Miu katia maki kamahi kua kete vatunga habuka kava miu te vala lamamiu kara kamiu moge zahazaha kamahi. ");
INSERT INTO wiv_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Tabarae miu na lohoia miu na tania da beta miu kata pelea zahatanga na vuna miu ta tania miu na habu tubuni Abraham, na vuna ta tania ni miu, a Vuvu e dangea kete katia vatu kamahi kua dia na kiri habu tubuni Abraham!” ");
INSERT INTO wiv_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Na kira kava ti ngoro na voraka hai kamahi. Hai kena beta ni vua paleka ni kemi kete hanua, da e hurava ki varaganga kara poloka haroho. ");
INSERT INTO wiv_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Hau ta vazuguvimiu na naru kete vatunga habuka miu te pokizia kamiu mogemoge. Palaka muri ni niau kaka katiu da e mai, ia e dopa ki hizanga ni niau, hau beta na kaka pa na dangea kata luga kana sandel. Ia da e vazuguvimiu na Vule Tumonga kamana haroho. ");
INSERT INTO wiv_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ia e mai kamana kana fok kete kizuvia na vit ni varaga zahenia kara kavili, kavili ni pele kakava tahetahena vit na palekangana. Da e tapi lupunia hana palekangana vit na rumaka vit, palaka da e tunia na tahetahena vit na haroho kena beta ni lala kete mamate.” ");
INSERT INTO wiv_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Kilangata kua a Iesus ia mai, e pe ni Galili ki mai ni Jon na naru a Iordan, a Jon kete vazuguvia. ");
INSERT INTO wiv_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Palaka a Jon e parakilania kete katia a Iesus ni pokizia kana lohoihoia, ki tania vona, “Ma ho koto vazuguviau, e kuziha kunu huleniau kata vazuguviho?” ");
INSERT INTO wiv_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","A Iesus ki tania, “Vatahia, kati baraenia kua habuka hau ta tania, tolu kata vaporihia na lohoihoia mahoto, kua a Vuvu e tania tolu kata katia.” Pale, a Jon ia muri na kana lohoihoia. ");
INSERT INTO wiv_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Kamana a Iesus ki vazuguvi hozova, ki vatia naru ki vano madi na hiripa barae, na lagato e ngapa, ia hada na Vule Tumonga ke Vuvu ti tali tadu balika balu kini ziho mia na huduna. ");
INSERT INTO wiv_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Na halinga katiu e pe na lagato ki tania, “Na Tugu matoto kena, e lala kete kuligu matoto kirina ka magali katiu matoto kamana.” ");
INSERT INTO wiv_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Pale, na Vule Tumonga ia pelea a Iesus vano kara poloka deset, a Satan kete pado rukia. ");
INSERT INTO wiv_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","A Iesus ki mahoho na dama e 40, na marigo e 40. Muri na kua ia ti ba vitolonia. ");
INSERT INTO wiv_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Pale, na kakanaka pado rukurukua ia mai bele vona ki tania vona, “Ni ho tuni Vuvu, tania na kedo kamahi kua dia na kara bret.” ");
INSERT INTO wiv_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Palaka a Iesus ki kolia kana polea ki tania, “E vapolu bareanga na poloka buk ke Vuvu, ‘Mara beta kaka ni mahuri na bret za, palaka kaka da e mahuri na polea laveve kena e pe na havani Vuvu.’” ");
INSERT INTO wiv_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Pale, a Satan ia pelea vano kiri Ierusalem, na taon tumonga ke Vuvu ia vamadiria na huduna tempel heta matoto. ");
INSERT INTO wiv_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ia tania vona, “Ni ho Tuni Vuvu, raga ziho kiri heva, na vuna, e vapolu bareanga na poloka buk ke Vuvu, ‘A Vuvu da e geria kana engel kamahi dia ka kodoniho. Da dia ta zikoviho na limadia, ki mara beta nu valitia kabe na kedo.’” ");
INSERT INTO wiv_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","A Iesus ki tania vona, “Na polea kana Paraha e tani barae ve, ‘Tabarae nu papado rukia a Paraha, ka Vuvu.’” ");
INSERT INTO wiv_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","A Satan ia pele mulehia a Iesus vori kara potuna horaha matoto katiu ia vatunga kingdom laveve bukuna garigari vona, kamana kadia goloaloa mata mulimuli kamana kadia glori. ");
INSERT INTO wiv_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ia tani barae ni Iesus, “Nu padonia tuturu, nu lotu ni niau, goloaloa laveve kua da ta vala ni niho.” ");
INSERT INTO wiv_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","A Iesus ki tania kirina, “Kakava ni niau, Satan! Na polea kana Paraha e tani barae, ‘Lotu na Paraha ka Vuvu, ku vora kana za.’” ");
INSERT INTO wiv_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Pale, a Satan ia vatia a Iesus, na engel kamahi dia ta mai kodonia. ");
INSERT INTO wiv_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Kamana a Iesus ki longoria habuka a Jon ti taruha na karabus, ia vamule kiri Galili. ");
INSERT INTO wiv_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","E vatia a Nasaret, ki vano mia ni Kaperneam. Taon kua, ia na hiripa loka a Galili, na garigari ke vuni Sebulun kamani vuni Naptali. ");
INSERT INTO wiv_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","E kati baraenia kete pori matoto na polea ke profet Aisaia kua e tani barae, ");
INSERT INTO wiv_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Garigari ke vuni Sebulun kamana ke vuni Naptali, e ngoro kozoho na hiripa dala kapou kua e ziho kara dazi, na paligena naru a Iordan, ni Galili, malala kana manumanu motu kua beta dia na lala dia kata bilip ni Vuvu, ");
INSERT INTO wiv_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","nuhu kua dia ta lala dia kata mimia na rodo, kava dia te hadavia laet kapou. Nuhu kua dia ta mimia na lirungana matea, laet ti bele ni dia kava.” ");
INSERT INTO wiv_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kilaka kena ki vano, a Iesus ti varivuvu keteni kalohunia polea kana Paraha na manumanu ki tani barae, “Miu pokizia kamiu mogemoge, kava kingdom ke Vuvu ti mai kini kozoho.” ");
INSERT INTO wiv_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Boto katiu a Iesus e vavana na hiripa loka ni Galili, ia hadavia varitazini rua, a Saimon, kua e kohanga ni Pita, kamani tazina a Andru. Hiro ta varagaraga vuho na poloka naru, na vuna hiro ta kakanaka pelepelea na hiha. ");
INSERT INTO wiv_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","A Iesus ki tania ni hiro, “Mo mai muri ni niau, kata vatunga makina pelepelea na kaka ni moro.” ");
INSERT INTO wiv_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Hiro ta zuka tapuni pamuhia kahiro vuho, hiro kene muri vona. ");
INSERT INTO wiv_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","E pe vano pitu ve, ia hadavia varitazini rua ve, a Jems hiro a Jon kamani tamahiro a Sebedi. Hiro na huduna bot kamani tamahiro a Sebedi, dia ta vaihidahida kadia vuho. A Iesus ia kohanihiro ve, ");
INSERT INTO wiv_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","hiro ta zuka tapuni pamuhia a tamahiro kamana bot, hiro kene muri ni Iesus. ");
INSERT INTO wiv_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","A Iesus e vana lobia laveve distrik a Galili, ki vaketekete na poloka haus lotu kamahi ke vuni Iuda, ki kalohunia ni dia na Kalohua Kemi na kingdom ke Vuvu. Ia ki kati kemihi mulehia ve manumanu kua mazahi na livuhadia. ");
INSERT INTO wiv_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Na rereki Iesus kini vana lobia malala laveve na kantri ni Siria, kubarae manumanu dia ta pelea nuhu kua mazahizahi, nuhu kua dia ta hatunia varitihia ve na livuhadia, ia mai nuhu kua na vule zaha e holiholidia, ia mai nuhu kua dia ta lala dia kata dadaedia, ia mai nuhu kua kabedia kamana limadia e matemate, ia ki kati kemihidia laveve. ");
INSERT INTO wiv_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Manumanu luba matoto bukuni Galili, bukuna distrik Dekapolis, ia mai bukuni Ierusalem kamani Iudea, ia mai nuhu na palaka kamahi kua na paligena loka a Iordan, kua dia ta murimuri vona. ");
INSERT INTO wiv_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","A Iesus e hadavia kabuna manumanu kamahi kua, ia vori mia tadu na hiripa potuna. Kana disaipel kamahi dia ta mai vona. ");
INSERT INTO wiv_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Pale, ia varivuvu keteni vaketekete ni dia, ki tani barae, ");
INSERT INTO wiv_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Nuhu kua miu ta hada lala habuka miu ta balakavua matoto na lohoihoia ke Vuvu, ia miu kata hilohilo, na vuna na kingdom ke Vuvu ia e kamiu. ");
INSERT INTO wiv_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Nuhu kua miu ta tatangi, ia miu kata hilohilo, na vuna a Vuvu da e katia magalimiu ki malugunia. ");
INSERT INTO wiv_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Nuhu kua miu ta vavazihoni mulehimiu, ia miu kata hilohilo, a Vuvu da e vala garigari kamiu. ");
INSERT INTO wiv_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Nuhu kua e vivitolonimiu ki mamarahotimiu kara moge kua e mahoto, ia miu kata hilohilo. A Vuvu da e vahotovia kamiu hatuhatua. ");
INSERT INTO wiv_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Nuhu kua miu ta lala miu kata mamaharia manumanu, ia miu kata hilohilo. A Vuvu da e maharimiu. ");
INSERT INTO wiv_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Nuhu kua magalimiu e kavakava matoto ki beta matoto lohoihoia zaha katiu na polokomiu, ia miu kata hilohilo. Da miu ta hadavia a Vuvu. ");
INSERT INTO wiv_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Nuhu kua miu ta lala miu kata talotalo na varihubia kamana varikoria, ia miu kata hilohilo. Da miu ta kohanga miu na habu tutuni Vuvu. ");
INSERT INTO wiv_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Nuhu kua e kati zahata miu, na vuna miu ta lala miu kata vavana na moge kua e mahoto matoto na matani Vuvu, ia miu kata hilohilo. Na kingdom ke Vuvu ia kamiu. ");
INSERT INTO wiv_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Nuhu kua e pole zaha voa kirua miu, ki kati zahata miu, ki vairuku ve voa kirua miu ki tanga polea mata hilehilea kirua miu, na vuna kua miu ta mumuri ni niau, magalimiu kete malugunia miu na hilohilo. ");
INSERT INTO wiv_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Miu hilohilo matoto, kadoamiu kua e gugurimiu na lagato e kapou matoto. Dia ta kati baraenia ni miu na vuna zia, varira dia ta kati baraenia ve na profet kamahi bukuni varira.” ");
INSERT INTO wiv_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Miu na sol kara garigari. Palaka kua ta sol ni vatia milolokana, da kati zinganga ki kara sol mule? Da ti beta keteni kemi kara goloa katiu, da ti varaganga, manumanu kini vavaka taduria. ");
INSERT INTO wiv_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Miu ta habuka laet kara vulovulo. Taon kapou katiu kua ni ngoro na potuna katiu, mara beta ni bata na matadolu. ");
INSERT INTO wiv_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Beta kaka ni lala kete dohotia lam ni taruhia na taura dis. Beta, e taruhia na mudina lam ki hada kara manumanu laveve na poloka ruma. ");
INSERT INTO wiv_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ia e habuka za, katia ka laet ni hada na pidaka manumanu, dia kata hada ka maki pa, dia na vala glori ni Tamamiu kua ia e heta na lagato.” ");
INSERT INTO wiv_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Tabarae miu na lohoia hau ta ziho kata pele kakava lo ke Moses kamana polea kana profet kamahi. Beta, hau ta ziho kata katia kadia polea ni pori. ");
INSERT INTO wiv_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Hau ta tani matotonia ni miu, da garigari kamana lagato hiro ta balavutuka, palaka mara beta leta kote katiu o na vapolupolua pitu, ni balavutuka na poloka lo, ia ki mule na dama kua goloa laveve kua na lo e popole vona ki pori laveve. ");
INSERT INTO wiv_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Kubarae, azei kua tani hada vetania dihura lo pitu ni beta ni muri vona, ia vata kua tani lo kote, kua tani vaketea na manumanu habuka beta dia kata muri vona, ia da beta matoto hizana na kingdom ke Vuvu. Palaka azei kua tani mumuri na polea kamahi na lo ni vavaketea ve na manumanu dia kata mumuri na polealea kamahi na lo, ia da e hada zaheanga ia na kingdom ke Vuvu. ");
INSERT INTO wiv_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ta tania ni miu, ta kamiu moge ni beta ni dopa ni mahoto livutia na moge kamahi kana tisa kamahi kara lo kamana Parisi kamahi, da mara beta matoto miu na hoho na kingdom ke Vuvu.” ");
INSERT INTO wiv_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","A Iesus ki tani barae ve, “Miu ta longoria e tani barae voa na manumanu bukuni varira, ‘Taua miu na hubi matehia kaka. Azei kua e hubi matehia kaka da e koto voa kirua.’ ");
INSERT INTO wiv_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Palaka hau ta tania ni miu azei kua ta magalina ni vavaritihi kiri tazina. Da tu vamadira na kotoa. Azei ve kua tani pole hilenia tazina, da e koto voa kirua na kotoa kapou. Palaka, azei kua tani tania kiri tazina, ‘Longolongo ho!’ Ia ho da tu kara haroho ni hel. ");
INSERT INTO wiv_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Kubarae, kua kunu pelea ka opa vano koto opa vona, kua kunu lohoi paria habuka ka manaunaua katiu vona kamani tazi, ");
INSERT INTO wiv_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","vatia ka opa na mugana altar. Ho tu muga vano ku vahotovia ka manaunaua kamani tazi, ba muri kunu mai vala ka opa. ");
INSERT INTO wiv_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Kua kaka katiu kini koto kiriniho, vahotovi tapunia polea kamana, mo na sekhan kua ma beta mo na vano na kotoa. Ta ni beu, da e peleho vano na Megistret, na Megistret ia valaho vano na polis, dia ta taruhiho na karabus. ");
INSERT INTO wiv_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Hau ta tani matotonia ni niho, mara beta nu gotala mule na karabus, da tu mia, ia ku kade hozovia matoto na naba na moni kua e tanga koto kadea, ba muri kunu gotala.” ");
INSERT INTO wiv_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Miu ta longoria kua e tanga, ‘Taua nu katia makina magali buhua.’ ");
INSERT INTO wiv_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Palaka hau ta tania ni miu azei kua tani hadavia tavine katiu ni ngarea ni kukulina kete balebale kamana, ia kava ti katia makina magali buhua kamana tavine kena na poloki magalina. ");
INSERT INTO wiv_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Kua mata kiri maroro kini katiho kunu katia moge zaha, bara luahia nu varaga. E dopa ki kemi koto vatia dihuri livuha katiu, tabarae ni katiho nu pekato, ni varaganga livuha laveve kara hel. ");
INSERT INTO wiv_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Kua lima kiri maroro kini katiho kunu katia goloa zaha katiu, kiri hutuzia nu varaga. E dopa ki kemi koto vatia dihura livuha katiu, tabarae ni katiho nu pekato, ni varaganga livuha laveve kara hel.” ");
INSERT INTO wiv_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","A Iesus ki tani barae ve, “Miu ta longoria varira e tani barae vonanga, ‘Azei kua kini vamia tapunia gona, ia ma kete vala pepana vamia taputapua ni gona kete lalanga habuka ia ti vatia kava.’ ");
INSERT INTO wiv_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Palaka hau ta tania ni miu, ma tavine e balebale kamana tamohane motu, ku vamia tapunia. Palaka kua tanu vamia tapuni vetania a go, ia kava tu katia kini kara magali buhu. Azei kua e kabania tavine kua e vamia tapuanga, ia e katia makina magali buhua.” ");
INSERT INTO wiv_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Miu ka longoria ve kena e tanga na nuhu bukuni varira, ‘Tabarae miu na mapamapa vairuku. Palaka miu kati matotonia nazia kua kava miu te mapamapa ni Vuvu miu kata katia.’ ");
INSERT INTO wiv_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Palaka hau ta tania ni miu, tabarae matoto miu na mapamapa. Tabarae ve miu na mapamapa na lagato, na vuna na lagato ia na sia king ke Vuvu; ");
INSERT INTO wiv_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","o tabarae nu mapamapa na garigari, na vuna na garigari ia a Vuvu e tataruhia kabena vona; o tabarae nu mapamapa ni Ierusalem, na vuna ia na taon kana King kua e Paraha kana king laveve. ");
INSERT INTO wiv_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Tabarae ve nu mapamapa na baka, na vuna mara beta nu katia vuluku katiu ni vavala o ni halohaloa. ");
INSERT INTO wiv_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Vatia ka ‘Taranga’ ni ma ‘E,’ ka ‘Linganga’ ni ma ‘Betaka.’ Tanu taruhia polea katiu ve kamana, polea kena, e pe na kaka zaha kena.” ");
INSERT INTO wiv_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","A Iesus ki tani barae ve, “Miu ta longoria muga kua e tani barae vonanga, ‘Kua kaka katiu kini goro keuhia matana kaka katiu, ia miu goro keuhia ve matana. Kaka katiu kini hutu pazuhia hazena kaka katiu, ia miu hutu pazuhia ve hazena.’ ");
INSERT INTO wiv_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Palaka kua, ta tania ni miu, tabarae nu kolia goloa zaha kua kaka e katia ni niho. Kua kaka katiu kini zapalania paligeni taviki kiri maroro, vala paligena kiri mauri ve vona ni zapalania. ");
INSERT INTO wiv_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Kua kaka katiu ni koto kiriniho kete pelea ka siot, pele vala ka tarausis ve vona. ");
INSERT INTO wiv_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Kua kaka katiu kini kuza kerekereniho kini tania koto luga kana beke nu vavana kamana na mael katiu, pele luga kana beke ho tu vavana mael rua. ");
INSERT INTO wiv_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Kua kaka katiu kini huleniho kara goloa katiu, vala vona; ta kaka katiu ni huleniho kete pelea ka goloa katiu ba muri ni vala mulehia, taua nu vanga holuholu vona.” ");
INSERT INTO wiv_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","A Iesus ki tani barae ve, “Varira miu ta longoria e tani barae voa, ‘Kete kukulimiu kiri habu kurakuramiu, miu zaha kara hamiu vagi kamahi.’ ");
INSERT INTO wiv_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Palaka ta tania ni miu kua, miu kemi kara hamiu vagi kamahi miu na lotu kara nuhu kua dia ta lala dia kata kati zahatia ni miu. ");
INSERT INTO wiv_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Kete kubarae, miu kata kara habu tutuni Tamamiu kua e heta na lagato. Na vuna a Vuvu e lala kete katia kana voro ni tibaria nuhu zahazaha kamana nuhu kemikemi ve, ki lala kete katia huza, ni huza kara nuhu kua dia ta lala dia kata katia moge kemikemi kamana nuhuta moge zahazaha ve. ");
INSERT INTO wiv_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Miu ta lohoia da a Vuvu e kademiu vona kua tani kukulimiu kara nuhu kua dia ta lala dia kata kukulidia kirimiu za? Nuhuta pelepelea na takis, dia ta lala dia kakatia moge mata barae ve. ");
INSERT INTO wiv_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Kua kunu lala koto polepole kamani habu kurakura za, pele nazia e ba bele vona kena? Nuhu kua beta dia na lala a Vuvu, dia ta lala ve dia kata kakatia maki mata barae ve. ");
INSERT INTO wiv_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Miu, miu kata mahoto matoto, habuka kua a Tamamiu, kua e heta na lagato ia e mahoto matoto.” ");
INSERT INTO wiv_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Miu lohoia tabarae miu na kakatia kamiu moge kemikemi kara manumanu kete hahadavia. Ta miu na kukubarae, da beta a Tamamiu kua na lagato kete kademiu. ");
INSERT INTO wiv_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Kua kunu kodonia kaka katiu kunu vala goloa vona, tabarae nu vilinia tavure nu konakona vona, balika nuhuta vairukua na lotua kua dia ta lala dia kata kakatia na poloka haus lotu ke vuni Iuda, ia mai ve na porota dala kamahi. Dia ta kukubarae manumanu kete vavazahenia hizadia. Hau ta tani matotonia ni miu, kava dia te pelea kadoadia kava. ");
INSERT INTO wiv_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Palaka kua kunu kodonia kaka katiu kunu vala goloa vona, tabarae lima kiri mauri ni lala nazia kua lima kiri maroro e kakatia. ");
INSERT INTO wiv_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Kubarae ka galanga kemi kena tu katia, ia ho za tu lala. Pale, a Kamama kua e lala kete hada nazia kua e lala kete kati paritigianga, da ti kadeho vona.” ");
INSERT INTO wiv_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Kua miu kene lolotu, taua miu na balika manumanuna vairukua na lotua! E lala kete kulidia matoto kua dia kata madi dia na lolotu na poloka haus lotu, ia mai na hiripa daladala kamahi manumanu laveve kete hahadavidia. Hau ta tani matotonia ni miu, kava dia te pele hozovia kadoadia. ");
INSERT INTO wiv_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Palaka kua koto lotu, hoho na poloka ka ruma, ho tu tabaria hatama ho tu lotu ni Kamama, kua beta kaka ni lala kete hahada. Pale, a Kamama, kua e hada nazia kua tu kati paritiginia, ia ti kadeho. ");
INSERT INTO wiv_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Miu kene lolotu tabarae miu na kakatia polea luba luba marata kua beta mining vona, habuka dia nuhu kua beta dia na lala a Vuvu; dia ta lala dia kata kakatia. Dia ta lohoia da a Vuvu e longoridia na kadia lotua malakulaku. ");
INSERT INTO wiv_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Tabarae miu na habuka dia. Tamamiu ia kava ti lala nazia kua e kukulimiu kirina, ba muri miu kene hulenia kirina. ");
INSERT INTO wiv_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Kua miu kene lotu, miu tani barae, ‘Tamahita heta na lagato, paleka hiza kua e tumonga ni vazaheanga. ");
INSERT INTO wiv_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Paleka ka kingdom ni mai, ka lohoihoia laveve hita na mumuri vona ri na garigari balika dia ta mumuri vona heta na lagato. ");
INSERT INTO wiv_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Vala ni hita meni hahita haninga kara dama meni; ");
INSERT INTO wiv_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Lohoi bala kahita moge zahazaha, balika hita ve kua hita ta lolohoi bala moge zaha kaka motu e katia ni hita. ");
INSERT INTO wiv_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Tabarae nu pelehita vano na parakilakilanga kua mara beta hita na madi ni bada vona, palaka pele kakava hita na limana kaka zaha.’ ");
INSERT INTO wiv_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Kua miu kene lohoi bala goloa zaha kua kaka motu e katia ni miu. A Tamamiu na lagato da ia ve e lohoi bala kamiu moge zahazaha. ");
INSERT INTO wiv_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Palaka kua ta beta miu na lohoi bala moge zaha kua kaka motu e katia ni miu, a Tamamiu ve mara beta ni lohoi bala kamiu moge zahazaha.” ");
INSERT INTO wiv_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Kua miu kene mahoho tabarae miu na katia matamiu ni hada zahazaha, habuka nuhuta vairukua na lotua kua dia ta lala dia kata kakatia. Dia ta lala dia kata katia matadia ni hada wari matoto, dia ta lohoia dia kata vatunga manumanu ni hadavia habuka dia ta mamahoho. Hau ta tani matotonia ni miu kava dia te pelea kadoadia kava. ");
INSERT INTO wiv_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Kua miu kene mahoho, miu vazuguvia matamiu miu ta komohia vulukumiu, ");
INSERT INTO wiv_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","kete beta manumanu dia kata lala habuka miu ta mamahoho, palaka a Tamamiu kua mara beta miu na hadavia; ia da e lala. Pale, a Tamamiu kua e hadavia nazia kua miu ta kati paritiginia, ia da ti kademiu.” ");
INSERT INTO wiv_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Tabarae miu na tatapi lupunia kamiu goloaloa mata mulimuli ri na garigari, na vuna da na tumelu kamana ros e vairohia, nuhuta vanahoa ve da dia ta hutu vulahia ka ruma dia ka vanahea. ");
INSERT INTO wiv_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Palaka miu tapi lupunia kamiu goloa mata mulimuli heta na lagato kua beta na tumelu kamana ros kete vairohia. Na nuhuta vanahoa ve mara beta dia na hutu vulahia dia na hoho vanahea. ");
INSERT INTO wiv_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Na vuna, kua ka goloaloa mata mulimuli ni ngongoro ni ve, ia da ka lohoihoia ve e ngongoro ra kena ve.” ");
INSERT INTO wiv_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Matadolu ia na lam kara livuhadolu. Kua matamiu ni kemi, ia da livuhamiu ve e vonu na laet. ");
INSERT INTO wiv_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Palaka kua matamiu ni zaha, livuhamiu laveve da e rodorodoa. Pale, ta laet kena na poloko ni beta ni hahada, ia da ti rodorodoa matoto!” ");
INSERT INTO wiv_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Mara beta kaka katiu ni gala habuka vora kana tubu rua. Da e kulina kara katiu ki beta kete kulina kara ruana, o da e longoria polea kana katiu ki vala lamana kara katiu. Mara beta nu kara vora ke Vuvu nu vora ve na Moni.” ");
INSERT INTO wiv_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Kubarae ka tania ni miu, tabarae miu na lolohoi vuvu na kamiu mianga. Nazia miu kata hania o nazia miu kata hinumia; o kara livuhamiu, kua nazia miu kata zozohoria. Kadolu mianga ia beta ni kara hanihani za o livuhadolu ia beta ni kete vavazohora za. ");
INSERT INTO wiv_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Miu hadavia na manu kamahi na mariaba. Beta dia na lala dia kata vavazo haninga beu, dia na tatapi lupunia haninga na rumaka haninga, palaka Tamamiu kua e heta na lagato ia e vavanganidia. Karae beta miu na dopa hizanga na manu kamahi? ");
INSERT INTO wiv_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Azei ni miu kua e lala kete lolohoi vuvu na kana mianga, e dangea kete vaherea aua katiu ve na kana mahuria? ");
INSERT INTO wiv_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","E kuziha miu ka lolohoi vuvu marata na nazia kua miu kata zozohoria? Miu hadavia na palaua lili, dia ta galulu ziha? Beta dia na lala dia kata gagala o beta dia na lala dia kata kakatia kadia lavalava. ");
INSERT INTO wiv_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Palaka hau ta tania ni miu, a King Solomon kamana kana goloaloa mata mulimuli, beta kana zohozohoa katiu ni mata muli livutia na palaua kamahi kua. ");
INSERT INTO wiv_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Kua a Vuvu ni vavazohori baraenia na raburabu kamahi, kua da meni e mamadi vaila ia varaganga kara haroho kini vu. Miu nuhu kua kamiu bilip e beta ni bada, miu ta lohoia mara beta a Vuvu ni vazohori baraenimiu ve? ");
INSERT INTO wiv_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Tabarae miu na lolohoi vuvu marata, miu na tatani barae, ‘Da tolu ta pelea hadolu haninga kamana hinua kamana kadolu lavalava kamahi ni ve?’ ");
INSERT INTO wiv_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Na vuna nuhu kua beta dia na lala a Vuvu, ia dia ta lala dia kata tututu kara goloaloa kamahi kua. Palaka a Tamamiu kua e heta na lagato, ia e lala ma kete kamiu goloaloa laveve kena vona. ");
INSERT INTO wiv_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Palaka miu muga miu na kaze kara kana kingdom kamana kana moge kua e mahoto, pale, na goloa laveve kena e kukulimiu kirina ia ti valanga ni miu ve. ");
INSERT INTO wiv_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Kubarae taua miu na lolohoi vuvu na dama vaila, dama vaila ia da kana vari mule vona kena. Vatia na goloa zahazaha kara dama katiu ia kete kara dama kena za.” ");
INSERT INTO wiv_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Taua miu na sikelnia kaka, kete beta a Vuvu kete sikelnimiu. ");
INSERT INTO wiv_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Na vuna ta miu na sikel zingania kaka, ia a Vuvu da e sikel baraenimiu ve. Da a Vuvu e sikelnimiu na kamiu lo mule kena miu ta lala miu kata sikelnia kaka motu vona. ");
INSERT INTO wiv_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","E kuziha ku hadavia na havuvuka palang na matani tazi, ki beta nu hadavia na podana hai kena na mata mule? ");
INSERT INTO wiv_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Da bakazi kunu tania ni tazi, ‘Mai na pele kakava havuvuka palang na mata!’ Palaka ho mule na podana hai ia e ngongoro na mata. ");
INSERT INTO wiv_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ho kakanaka vairukua na lotua ho! Muga ku pele kakava podana hai na mata, koto hada vutu, nu pele kakava havuvuka palang na matani tazi. ");
INSERT INTO wiv_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Taua miu na pelea goloa tumonga, miu na vala ni kauaua. Taua miu na vala kamiu tali mata muli na boroboro. Tabarae dia na vaka taduria, dia ta tare poki kirimiu dia ta hanimiu.” ");
INSERT INTO wiv_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Hule kete valanga ni niho; Tutu koto paria; hubihubia doa ia ni vukaza kiriniho. ");
INSERT INTO wiv_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Nuhu laveve kua dia ta hule da dia ta pelea; azei ho tanu tututu da tu paria; azei ho kua nu hubihubia doa, da e vukaza doa voa kiriniho. ");
INSERT INTO wiv_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Azei ni miu, kua a tuna ni hulenia kara bret, da e vala kedo vona? ");
INSERT INTO wiv_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Beu ni hulenia kara hiha da e vala matabunu vona? ");
INSERT INTO wiv_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Pele kua miu, ia vata kua miu ta manumanu zahazaha, miu ta lala miu kata vala goloa kemikemi ni habu tutumiu. Ia pebarae za, a Tamamiu kua na lagato ia da e vala goloa kemikemi na nuhu kua dia ta hulenia kirina! ");
INSERT INTO wiv_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Katia na manumanu nazia kua ho e kukuli dia kata katia ni niho ve. Na vuna ia kena ia na vuvuna lohoihoia kua na lo ke Moses, kamana vaketeketea kamahi kana profet kamahi.” ");
INSERT INTO wiv_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","A Iesus ki tani barae ve, “Miu hoho miu na pe na doa kote, na vuna zia na hatama kara golua ia e kapou, na dala kua e vano kirina, ia e volo papa matoto, manumanu luba dia ka mumuri vona. ");
INSERT INTO wiv_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Palaka na hatama kara mahuria ia e gala kote. Na dala kua e vano kirina e vitiha, manumanu taza za, dia ta paparia.” ");
INSERT INTO wiv_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Miu lohoimiu na profet vairukuruku kamahi, kua dia ta lolohoria hulita sipsip dia ka mamai ni miu, palaka na polokodia matoto ia dia ta habuka kauaua mata varihanihani. ");
INSERT INTO wiv_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Da miu ta hada lala dia na haningana kadia mogemoge kamahi. Miu ta lala, mara beta kaka ni dulea kabule na kariha, o vao na poku. ");
INSERT INTO wiv_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ia e kubarae za, hai kemi, ia e lala kete vua paleka ni kemi, hai zaha, ia e lala kete vua na paleka ni zaha. ");
INSERT INTO wiv_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Na hai kemi mara beta ni taruhia paleka ni zaha, ia mai na hai zaha mara beta ve ni taruhia paleka ni kemi. ");
INSERT INTO wiv_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Hai laveve kena beta ni vua papa, ia kete hurava ni varaganga kara poloka haroho. ");
INSERT INTO wiv_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Kubarae da miu ta hada lala dia na haningana kadia mogemoge kamahi. ");
INSERT INTO wiv_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Beta ni manumanu laveve kua dia ta lala dia kata kokoi baraeniau, ‘Tubu, Tubu,’ dia kata hoho na kingdom ke Vuvu. Palaka nuhu za kua dia ta mumuri matoto na lohoihoia ke Tamagu kua heta na lagato. ");
INSERT INTO wiv_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Na damana kotoa kapou, manumanu luba da dia ta tani barae ni niau, ‘Paraha, Paraha, na hiza hita ta lala hita kata vala polea ke Vuvu na manumanu, na hiza hita ta lala hita kata pele kakava vule zaha, hita ka kakatia ve mirakel luba.’ ");
INSERT INTO wiv_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Hau da ta tania ni dia, ‘Hau beta matoto na lala miu. Miu kakava ni niau, miu ta nuhuta moge zahazaha!’” ");
INSERT INTO wiv_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Kubarae, azei kua tu longoria kagu polea ku muri vona, ia ho tu balika kaka kua kana lohoihoia vona, ki habatia kana ruma na huduna kedo faundesion. ");
INSERT INTO wiv_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Na huza ki mai, na loka ki pado, na kavili ve ki habinia ruma; palaka beta ni tua, na vuna zia faundesion kara ruma kua e ngoro na kedo. ");
INSERT INTO wiv_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Palaka nuhu kua dia ta longoria kagu polea ki beta dia na muri vona dia ta balika kaka kua e beta kana lohoihoia, ki habatia kana ruma na huduna magamaga. ");
INSERT INTO wiv_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Na huza ki mai na loka ki pado, kavili ki habinia ruma, na ruma ia tua. Na ruma da e tua zahazaha matoto.” ");
INSERT INTO wiv_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Kamana a Iesus ki tani hozovia polealea kamahi kua, na kabuna manumanu kapou kua, dia ta zipa zahe matoto na kana vaketeketea, ");
INSERT INTO wiv_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","na vuna beta ni vaketekete balika kadia tisa kamahi kara lo. Ia e vaketekete kamana matuhanga kamana kana save mule. ");
INSERT INTO wiv_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Kamana a Iesus ki pe na hiripa potuna ki ziho mule, na kabuna manumanu kapou dia ta muri vona. ");
INSERT INTO wiv_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Kaka katiu lepra vona, e mai ia padonia tutura na mugani Iesus ki tania, “Tubu, ni kuli, katiau na klin mule.” ");
INSERT INTO wiv_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","A Iesus ia tabe vano, ia vakulia na kaka kua ki tania, “Hau e kuligu. Pele, klin mule.” Na lepra ia kakava pamuhi na livuhana. ");
INSERT INTO wiv_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Pale, a Iesus ia tania vona, “Longoria! Taua matoto nu tania na kaka katiu. Palaka vano, ho tu vatungaho na pris, ho tu katia na opa kena a Moses e tania, koto vatunga na manumanu habuka kava tu kemi kava.” ");
INSERT INTO wiv_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Tania a Iesus ki vano bele ni Kaperneam, na kepten katiu na armi ke vuni Rom, e mai bele ni Iesus ki hule haroinia matoto a Iesus kete kodonia. ");
INSERT INTO wiv_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Ki tani barae ni Iesus, “Paraha, kagu vora e mazahitia ki ngongoro na kagu ruma, livuhana laveve e matemate ki hatunia varitihia kapou matoto.” ");
INSERT INTO wiv_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","A Iesus ki hulenia, “Kata vano na kati kemihia?” ");
INSERT INTO wiv_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Na kepten kara armi kua ki tania, “Tubu. Hau beta na kaka pa ni dangea kua koto mai hoho na kagu ruma. Palaka tania za, kagu vora ni kemi mule. ");
INSERT INTO wiv_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Na vuna hau ve, na opisa taza dia ta dopa paraha ni niau, dia ta hada ni niau, hau ve ta hada na soldia taza ve. Kua na tani barae na kaka kua, ‘Vano!’ ia da e vano; kua na tani barae na kaka kuarina, ‘Mai!’ ia da e mai; kua na tania na kagu vora, ‘Katia goloa kua!’ ia da e katia.” ");
INSERT INTO wiv_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","A Iesus ki longo baraenia kana polea, ki zipa zahe matoto na kana polea. Ia ki tani barae na manumanu kua dia ta mumuri vona, “Hau ta tani matotonia ni miu, ma beta matoto na paria kaka katiu ni Israel kua kana bilip e kapou balika kana kaka kua. ");
INSERT INTO wiv_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Hau ta tania ni miu manumanu luba da dia ta pe na palaka kua ni Ist, dia ka pe na palaka kua ni Wes, dia ka mai mia kamani Abraham, ia mai kamani Aisak hiro a Jekop na hanihania kapou na kingdom ke Vuvu. ");
INSERT INTO wiv_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Palaka nuhu kua ma dia kata mia na poloka kingdom ke Vuvu, da dia te varaga gotalanga, kara poloka rodo, na palaka kena da dia te hahaloho, hazedia kini vuvuluhero.” ");
INSERT INTO wiv_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Pale, a Iesus ia tania na kepten kara soldia kua, “Vano! Nazia kua tu bilip kirina, da ti bele matoto.” Pale, kilangata pamuhi na aua kena matoto, kana vora ia kemi pamuhi. ");
INSERT INTO wiv_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","A Iesus e mai pe hoho na ruma ke Pita, ia hadavia a ravani Pita e mazahitia ki ngongoro. ");
INSERT INTO wiv_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","A Iesus ia vakulia limana, na mazahi kua ia vatia. Pale, ia lama pamuhi kini katia haninga kini vala ni Iesus. ");
INSERT INTO wiv_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ti garavi, manumanu dia ta pelea nuhu kua na vule zaha e hoholiholidia ki mai ni Iesus ia ki pele kakava vule zaha na polokodia, ki kati kemihia manumanu laveve kua e mazahitidia. ");
INSERT INTO wiv_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","A Iesus e katia goloaloa kamahi kua kini pori matoto na polea ke profet Aisaia kua e tani barae, “Ia ti luga kadolu bizea kamahi kini pele kakava kadolu mazahi kamahi.” ");
INSERT INTO wiv_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Kamana a Iesus ki hadavia na kabuna manumanu kua dia ta mamadi lobia, ia geria kana disaipel kamahi dia kata vano kara paligena loka. ");
INSERT INTO wiv_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Pale, na tisa kara lo katiu e mai ni Iesus ki tani barae, “Tisa, hau da ta ma mumuri za ni niho, malala kakei kena tu vano kirina ia hau da ta kamaniho.” ");
INSERT INTO wiv_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","A Iesus ki tani barae vona, “Kaua tegitegi kamahi kadia lovo vona na garigari, na manu kamahi baledia vona, palaka na Tuna Kaka, beta palaka kete vangorea bakana vona.” ");
INSERT INTO wiv_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Na kaka katiu ve, ia na disaipel katiu; e tani barae ni Iesus, “Tubu, vatiau ka vano muga tavunia tamagu.” ");
INSERT INTO wiv_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Palaka a Iesus ki tania vona, “Muri ni niau, vatia nuhu kena dia te varimateai kava, dia na tavunia kadia kaka mate.” ");
INSERT INTO wiv_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","A Iesus e polo na bot, na kana disaipel kamahi dia ta polo ve kamana. ");
INSERT INTO wiv_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Na kavili kapou ia bele valutu kiridia na loka, na dazi kini vevele hoho kara poloka bot. A Iesus ia ti ngoro tudu. ");
INSERT INTO wiv_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Na disaipel kamahi dia ta vano vakongania, dia ka tania, “Paraha, vaikoli kiridolu! Tolu keteni mahitu!” ");
INSERT INTO wiv_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","A Iesus ki tania, “E kuziha miu ka kuahi? Beta matoto kamiu bilip?” Pale, ia madi kini pole kara kavili kamana dazi, ia malugunia pamuhi. ");
INSERT INTO wiv_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Na disaipel kamahi dia ta ridi dia ka hule, “Kaka zia matoto kua? Na kavili kamana dazi ve dia ta longoria kana polea!” ");
INSERT INTO wiv_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Tania a Iesus ki vano bele na paligena loka a Galili, na malala ke vuni Gadara, na kaka rua na vule zaha e holiholihiro. Hiro ta pe na matmat, hiro ka ziho, hiro ta mai ni Iesus. Hiro ta kaka zaha matoto, kubarae ki beta manumanu dia na lala dia kata pepe hutu na palaka kua. ");
INSERT INTO wiv_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Hiro ta goe hiro ka tania, “Tuni Vuvu! Nazia matoto kuli kirina ni hita? Ma beta ni kilaka pitu. Kua tu mai koto nu kati zahatia ni hita, ai?” ");
INSERT INTO wiv_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Na kabuna boroboro kapou matoto, dia ta dudue kozoho ni dia. ");
INSERT INTO wiv_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Na vule zaha kamahi dia ta hule haroinia matoto, dia ka tania, “Kunu pele gotalanihita, gerihita na vano hoho na kabuna boroboro kamahi kuari.” ");
INSERT INTO wiv_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Pale, a Iesus ia tania ni dia, “Miu vano!” Pale, dia ta gotala, dia ta vano hoho na boroboro, na boroboro kamahi kua dia ta rovo kara balibali na hiripa naru dia kene raga kara poloka naru dia kene mahituhitu. ");
INSERT INTO wiv_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Nuhu kua dia ta hahada poto na boroboro dia ta varihavai, dia ta vano mule kara poloka taon, dia kene kalohunia goloaloa laveve kua dia ta hadavia, dia ka tania ve nazia kua e bele na kaka rua kua na vule zaha e holiholihiro. ");
INSERT INTO wiv_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Pale, manumanu laveve na poloka taon dia ta maimai ni Iesus. Tania dia ka hadavia a Iesus, dia ta hule haroinia matoto kete vatia kadia malala. ");
INSERT INTO wiv_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","A Iesus e polo na bot, ia pe poki mule kara paligena loka, ia vano bele na kana taon mule. ");
INSERT INTO wiv_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Manumanu taza dia ta luga kaka katiu na dongi, kabena kamani limana e matemate ki mai ni Iesus. A Iesus ki hadavia habuka kadia bilip vona, ia tania na kaka kua kabena kamani limana e matemate, “Taua nu lohoi vuvu tugu; Ka manaunaua te lohoi bala kava.” ");
INSERT INTO wiv_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Kilaka kua, na tisa kara lo taza dia ta pole ngungu dia ka tani barae, “Kaka kua e lolohoia kete pelea mudini Vuvu kua!” ");
INSERT INTO wiv_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","A Iesus e hada lala kadia lohoihoia, ia tani barae, “Kara zia miu ka ma tataruhia lohoihoia mata hilehilea kena na polokomiu? ");
INSERT INTO wiv_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Polea kakei e malimu dopa kata tania. Kata tani barae, ‘Ka manaunaua ti lohoi balanga,’ o kata tani barae, ‘Madi nu vana?’ ");
INSERT INTO wiv_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Hau da ta vatunga matotonia ni miu habuka, na Tuna Kaka ia kana matuhanga vona na garigari kete lohoi bala manaunaua.” Pale, ia tania na kaka kua kabena kamana limana e matemate, “Madi nu pelea ka dongi nu vano kara ka ruma.” ");
INSERT INTO wiv_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Na kaka kua ia madi kini vano kara kana ruma. ");
INSERT INTO wiv_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Tania na kabuna manumanu kua dia ka hada baraenia, dia ka zipa zahe matoto, dia ka vazahenia a Vuvu, kua ia ti vala matuhanga mata barae kua na manumanu bukuna garigari. ");
INSERT INTO wiv_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","A Iesus e vatia palaka kua, ki vavana vano, ia hadavia na kakanaka pelepelea na takis katiu, hizana a Matyu e mimia na kana opis kara pelepelea na takis. Ia tania vona, “Mai muri ni niau.” Pale, a Matyu ia divurutia kini muri vona. ");
INSERT INTO wiv_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","A Iesus e hanihani na ruma ke Matyu, na nuhuta pelepelea na takis luba ia mai nuhuta moge zahazaha dia ve dia ta mai. Dia ka mia kamani Iesus kamana kana disaipel kamahi. ");
INSERT INTO wiv_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Tania a vuni Parisi dia ka hada baraenia, dia ta hulenia kana disaipel kamahi, “E kuziha kamiu tisa ki hahanihani kamana nuhuta pelepelea na takis kamana nuhuta moge zahazaha?” ");
INSERT INTO wiv_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","A Iesus ki longoria polea kua, ia ki tani barae, “Nuhu kua beta mazahi ni dia, beta dia na lala dia kata vano hada na dokta, betaka, nuhu kua mazahi ni dia za, ia dia ta hahada dokta. ");
INSERT INTO wiv_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Miu vano hada na polea kana Paraha miu na paria na vuvuna polea kua e tani barae, ‘Hau beta ni kuligu kara kamiu opa kamahi kua miu ta vavala ni niau. Hau e kuligu miu kata kati kemihia na manumanu.’ Na vuna hau ta mai kata kohania nuhu kua dia ta manumanu zahazaha, beta ni nuhu kua dia ta mahoto.” ");
INSERT INTO wiv_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Na disaipel kamahi ke Jon dia ta mai ni Iesus dia ka hulenia, “E kuziha kua hita kamani vuni Parisi hita ta lala hita kata mamahoho, palaka ka disaipel kamahi beta dia na lala dia kata mamahoho?” ");
INSERT INTO wiv_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","A Iesus ki tania, “Da na nuhu kua e kohanga dia kara hanihania kapou na lahia dia kata tangi, kua na tamohane kua e ba lahi vahoru e ba mimia kamadia? Mara beu! Na damana vona kua e ba mamai, da ti pele kakavanga na tamohane kua e ba lahi vahoru ni dia, pale, dia te ba tangi dia kene mahoho. ");
INSERT INTO wiv_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Beta manumanu dia na lala dia kata pelea lavalava vahoru dia na turu porotia horupa lavalava bura vona. Tani kubarae, da na lavalava vahoru tani vano ni tania kete viluku pitu, ia katia horupa kena na lavalava bura ia dopa kapou. ");
INSERT INTO wiv_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Beta ve manumanu dia na lala dia kata gorea vaen vahoru na poloka hulita me bura. Ta dia na kubaraenia, da na hulita me bura e tere, na vaen ia maliki, na hulita me kini zaha. Manumanu dia ta lala dia kata gorea vaen vahoru na hulita me vahoru. Pale, na hulita me kamana vaen da beta hiro kata zaha.” ");
INSERT INTO wiv_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","A Iesus e ba popole na polea kua, na paraha ke vuni Iuda katiu e mai vona ia padonia tutura na mugani Iesus ki tania, “Tugu tavine e ba mate kua, palaka mai nu taruhia lima vona, ia ni lama mule.” ");
INSERT INTO wiv_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","A Iesus ia di madi ia vano kamana, kana disaipel kamahi ve dia ta vano kamana. ");
INSERT INTO wiv_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Na tavine katiu na topo e lelele kirina krismas ti 12, e pe na lamani Iesus ki mai, ia vakulia hiripa kana loholohoa. ");
INSERT INTO wiv_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Na vuna ia e lohoi barae, “Kua na vakulia kana loholohoa za, hau da ta kemi.” ");
INSERT INTO wiv_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","A Iesus e tare poki ia hadavia na tavine kua, ia tania, “Tugu taua nu lohoi vuvu. Ka bilip ti katiho kunu kemi.” Pale, na tavine kua ia kemi pamuhi. ");
INSERT INTO wiv_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Tania a Iesus ki vano hoho na ruma kana paraha ke vuni Iuda, ia hada nuhuta vilivilia na flut, na manumanu ve dia ta kakatia valalanga kapou na tangia, ");
INSERT INTO wiv_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","a Iesus ki tania, “Miu kakava. Na kapiru beta ni mate ia e ngongoro za.” Palaka dia ta nongonia. ");
INSERT INTO wiv_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Tania ki geura manumanu dia ka gotalatala na ruma, ia hoho na ruma ia pahoria limana tavine kote kua, na tavine kua ia lama. ");
INSERT INTO wiv_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Na rereka goloa kua a Iesus e katia ki vana lobia malala laveve na palaka kua. ");
INSERT INTO wiv_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","A Iesus e vatia palaka kua, ki vavana vano, na kaka rua matahiro e keu, hiro ta ma mumuri vona, hiro ka kokoi hiro ka tatani barae, “Maharimiro, Tubuni Devit!” ");
INSERT INTO wiv_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","A Iesus e vano ia hoho na ruma, na kaka rua kua matahiro e keu, hiro ta mai vona, a Iesus ia hulenihiro, “Mo ta bilip da ta kati kemihimoro?” Hiro ka tania, “E, Paraha.” ");
INSERT INTO wiv_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","A Iesus ia vakulia matahiro ki tani barae, “Pele muri na kamo bilip ni niau, goloa e kukulimo kirina, da e bele matoto.” ");
INSERT INTO wiv_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Matahiro ia kemi. A Iesus ia tani vatuharia ni hiro, “Tabarae mo na tania na kaka katiu na goloa kua e bele ni moro.” ");
INSERT INTO wiv_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Palaka hiro ta vano hiro ta kalohulohunia na manumanu laveve na malala laveve na palaka kua, na goloa kua a Iesus e katia. ");
INSERT INTO wiv_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Kamana na kaka mata keu rua kua hiro ka vatia ruma hiro ka gotala, manumanu taza dia ta pelea na kaka katiu e manga, na vuna zia na vule zaha e holiholia, ia mai ni Iesus. ");
INSERT INTO wiv_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Kamana ki pele kakavanga na vule zaha kua, na kaka manga kua ia pole. Na kabuna manumanu kua dia ta ridi matoto dia ka tania, “Ma beta goloa katiu mata barae ni hadava ni Israel.” ");
INSERT INTO wiv_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Palaka na Parisi kamahi dia ta tania, “Ia e gagala kamana matuhanga kana paraha ke hanitunitu.” ");
INSERT INTO wiv_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","A Iesus e vana na poloka taon laveve kamana malala kotekote laveve, ki vaketekete na poloka haus lotu kamahi ke vuni Iuda, ki ratahidia na Kalohua Kemi na kingdom ke Vuvu, ki kati kemihia manumanu kua e mazahitidia. ");
INSERT INTO wiv_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ia ki hadavia na kabuna manumanu kamahi, lohora ki zaha ni dia, na vuna dia ta kati zahata, dia ka batola matoto, balika sipsip kamahi kua beta kaka kete hada poto ni dia. ");
INSERT INTO wiv_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Pale, ia tania na kana disaipel kamahi, “Na haninga luba matoto ti matuha na poloka vanua, palaka beta kakanaka galanga ni luba dia kata vai lupunia. ");
INSERT INTO wiv_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Miu hulenia na Paraha kara pelepelea na haninga, ia kete geria manumanuna galanga kara vanua, dia kata vai lupunia haninga.” ");
INSERT INTO wiv_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","A Iesus e kohania kana 12 disaipel kamahi dia ta mai vona, ia vala matuhanga ni dia, dia kata pele kakava vule zaha kamahi dia na kati kemihia manumanu kua e mazahitidia. ");
INSERT INTO wiv_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Na hizana apostel kamahi kua. Muga, a Saimon (kua e kohanga ni Pita) kamani tazina a Andru, ia mai tuni Sebedi karua a Jems hiro tazina a Jon; ");
INSERT INTO wiv_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","A Filip hiro a Bartolomyu; a Tomas mai a Matyu kakanaka pelepelea na takis; a Jems tuni Alfius, ia mai a Tadius; ");
INSERT INTO wiv_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","a Saimon kua bukuna kabu ke vuni Selot, ia mai a Iudas Iskariot kaka kua ba muri kete vala a Iesus na limani vuni Iuda. ");
INSERT INTO wiv_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Dia manumanu 12 kua, a Iesus e geridia ki tani barae ni dia, “Taua miu na vano na nuhu motu kua beta dia na bukuni Iuda o miu na vano hoho na taon katiu ke vuni Samaria. ");
INSERT INTO wiv_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Miu vano na sipsip kua bukuni Israel kua dia te golu. ");
INSERT INTO wiv_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Miu vano miu na vala polea kubarae, ‘Na kingdom ke Vuvu ti kozoho!’ ");
INSERT INTO wiv_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Miu kati kemihia nuhu kua e mazahitidia, valamari mulehia nuhu kua dia te mate, miu kati kemihia nuhu kua lepra ni dia, miu ta pele kakava vule zahazaha kamahi. Hau ta vala vetania matuhanga ni miu, ia miu ve miu vala vetania na manumanu, beta kete kadoa miu vona. ");
INSERT INTO wiv_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Taua miu na gorea gol, beu silva, beu kopa na kamiu poket miu na vavana kamana; ");
INSERT INTO wiv_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","taua miu na pelea beke kara vavananga o kamiu siot ni rua, beta miu kata pelea sandel, o toho. Na vuna kakanaka galanga ia e lala kete vavakodoa. ");
INSERT INTO wiv_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Taon kakei o malala kote katiu miu ta bele vona, miu hada kara kaka katiu kua e kulina kete koi tadurimiu, miu ta mia kamana ki mule na dama kena miu kata vatia malala kena. ");
INSERT INTO wiv_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Miu kene hoho na kana ruma, miu vala kamiu magali kemia vona. ");
INSERT INTO wiv_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kua na manumanu na poloka ruma kena dia na koi tadurimiu, miu vatia kamiu magali kemia ni ngoro kamadia, kua kini beu, miu pele mulehia kamiu magali kemia ni vamule ni miu. ");
INSERT INTO wiv_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Kua tani beta kaka katiu ni koi tadurimiu o ni beta ni longoria kamiu polea, miu vatia malala kena, miu ta pali tubinia havuhavu na kabemiu. ");
INSERT INTO wiv_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ta tani matotonia ni miu, na damana kotoa kapou ke Vuvu, na goloa zaha kua kete bele kiridia, da e kapou livutia kena kete bele ni Sodom hiro a Gomora. ");
INSERT INTO wiv_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Miu longoria, hau ta gerimiu balika sipsip kara pidaka kauaua mata varihanihani. Kubarae, kamiu lohoihoia kete gala taputapu balika matabunu, miu ka valugilugimiu balika balu. ");
INSERT INTO wiv_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Miu lohoimiu ni manumanu; da dia ta paho tadurimiu dia ka koto kirimiu na kadia Pararaha kamahi. Dia ka vihimiu na poloka haus lotu kamahi ke vuni Iuda. ");
INSERT INTO wiv_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Na vuna ni niau za, da dia ta koto kirimiu na kadia gavana kamahi kamana kadia king kamahi. Dia ta kubarae ni miu, miu kata tani kakava na kalohua kemi ni dia, kamana nuhu kua beta dia na lala a Vuvu. ");
INSERT INTO wiv_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Dia kene haba tadurimiu, taua miu na lohoi tori habuka, na polea zia miu kata tania o miu kata tani zingania. Na dama kena, nazia kua miu kata tania, da ti valanga ni miu. ");
INSERT INTO wiv_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Na vuna zia, da ti beta miu keteni popole, na Vule Tumonga ke Tamamiu da ti popole na havamiu. ");
INSERT INTO wiv_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Manumanu da dia ta koto kiri habu tazidia mule kete hubu matoa dia. Habu tamana kapirupiru da dia ta koto kiri habu tutudia mule. Kapirupiru da dia ta tare poki kiri habu tamadia kamani habu titinadia dia ka koto kiridia, dia ka hubu matoa. ");
INSERT INTO wiv_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Na vuna ni niau za, manumanu da dia ta zaha kirimiu, palaka azei ho kua tanu madi ni bada ia ia ki las de, ia da tu mahuri roro. ");
INSERT INTO wiv_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Kini zaha voa kirua miu na palaka katiu, miu hava kara palaka motu katiu. Hau ta tani matotonia ni miu, da beta miu kata vahozovi kemikemihia galanga na taon kamahi ni Israel, na Tuna Kaka ia mai. ");
INSERT INTO wiv_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Kapiru sikul beta ni paraha na kana tisa, beu na vora beta ni paraha na kana tubu. ");
INSERT INTO wiv_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Na kapiru sikul da e hilohilo za kua ia kete balika kana tisa, na vora da e hilohilo za kua kete hizanga balika kana tubu. Manumanu dia ta kohania na tubu kara ruma ni Belsebul, kubarae, da dia ta vala hiza zaha dopa na kana manumanu ve. ");
INSERT INTO wiv_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ki kuza barae taua miu na kuahinidia. Goloa laveve kena e kakarua, da e lalaha karikari kirua, polea laveve kena e lilitingianga da e tani kakavanga, manumanu laveve ki lala. ");
INSERT INTO wiv_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nazia kua ta tania ni miu na rodo, ia miu tani kakava na dama, nazia kua e tani rogoanga na talingamiu za, ia miu madi na huduna ruma kamahi miu na tani kakava. ");
INSERT INTO wiv_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Taua miu na kuahinia nuhu kua dia kata hubi matehimiu, palaka mara beta dia na hubi matehia vulemiu. Palaka miu kuahinia a Vuvu. Ia e dangea kete hubi matehiho ia mai na vule ve na hel. ");
INSERT INTO wiv_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Miu ta lala manumanu dia ta lala dia kata kadea na hila rua na 10 toea za, palaka mara beta hila katiu ni mate veta ni dua kara garigari kua ta beta a Tamamiu ni tania. ");
INSERT INTO wiv_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ia miu ve, na vulukumiu laveve na bakamiu kava ti hazeanga. ");
INSERT INTO wiv_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Kuza barae taua miu na kuahi; miu ta dopa hizanga na manu kotekote kamahi. ");
INSERT INTO wiv_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Azei ho kua tanu tani kakava habuka ho tu bukuna kagu kabu, ia hau ve da ta tani kakava ve ni Tamagu kua na lagato, habuka ho kagu ve. ");
INSERT INTO wiv_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Palaka azei kua tani madi na matana manumanu ni tania habuka beta ni lalau, ia hau ve da ta tania ni Tamagu habuka beta na lala ia ve. ");
INSERT INTO wiv_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Tabarae miu na lohoia hau ta ziho kata katia manumanu dia na magali katiu ri na garigari. Hau beta na ziho kata vala mianga pa, beta hau ta ziho kamana bainat. ");
INSERT INTO wiv_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Hau ta ziho kata katia kaka ni tare poki mule kiri tamana, tavine kete tare poki mule kiri titinana, tavine kete tare poki kiri ravana tavine. ");
INSERT INTO wiv_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Nuhu kua dia kata dopa zaha matoto kiriniho, ia da na nuhu kua na ka ruma mule. ");
INSERT INTO wiv_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Azei kua e dopa ki kulina matoto kiri tamana kamani titinana dopa na kua e kulina kirigu, ia beta ni dangea kete kara kagu disaipel; Azei kua e dopa ki kulidia kiri tuna tamohane kamani tuna tavine dopa na kua e kulina kirigu, ia beta ni dangea kete kara kagu disaipel. ");
INSERT INTO wiv_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Azei kua tanu beta nu pelea ka kruse nu muri ni niau, ia mara beta nu kara kagu disaipel. ");
INSERT INTO wiv_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Azei ho tu lolohoia koto katia nu mia papa, ia da tu paho kavu kara ka mianga pa, palaka azei ho kua tu vati mazukenia ka mianga pa ku muri ni niau, ia da tu paria mianga pa. ");
INSERT INTO wiv_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Azei kua kini koi tadurimiu, ia e habuka e koi taduriau, azei kua tani koi taduriau, ia e habuka e koi taduria Kaka kua e geriau ka mai. ");
INSERT INTO wiv_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Azei kua tani koi taduria na profet katiu na vuvuna kaka kena ia na profet katiu, ia da e kadoa ia na kadoana profet kamahi, azei kua tani koi taduria kaka kua kana moge e mahoto na vuna kaka kena ia na kaka mahoto, ia da e kadoa ia balika kaka kua kana moge e mahoto. ");
INSERT INTO wiv_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Hau ta tani matotonia ni miu, kua kaka katiu ni vala naru kalolo na kaka vetanga katiu kua e bukuna kagu kabuna disaipel, kaka kena mara beta matoto kadoana ni golu.” ");
INSERT INTO wiv_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Kamana a Iesus ki vala hozovia polealea kamahi kua na kana disaipel kamahi, ia vatia palaka kua kini vano kara poloka taon kamahi ni Galili kete vaketekete ni ratarata vona. ");
INSERT INTO wiv_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Kamana a Jon, kua ia na poloka karabus, ki longoria nazia kua a Iesus e kakatia, ia geria kana apostel kamahi dia kata vano ni Iesus, ");
INSERT INTO wiv_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","dia kata huleni baraenia, “Ia ho za na kaka kua kete mai, o hita kata guria kaka katiu motu ve kete mai?” ");
INSERT INTO wiv_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","A Iesus ki kolia kadia hulea ki tani barae, “Miu vamule vano tania ni Jon nazia miu ta longoria miu ka hadavia. ");
INSERT INTO wiv_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Nuhu kua matadia e keu dia ta hada mule, nuhu kua kabedia e matemate dia te vavana, nuhu kua lepra na livuhadia, dia ta kemi mule, nuhu kua talingadia e dotodoto, dia ta longo mule, nuhu kua dia ta varimateai, dia ta valamari muleha na matea, ki mai ve na Kalohua Kemi ti vaketoa ve na nuhu kua beta kadia goloaloa vona. ");
INSERT INTO wiv_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Kaka kua e bilip ni niau ki beta ni lohoi ruarua ni niau, ia kete hilohilo.” ");
INSERT INTO wiv_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Kamana na disaipel kamahi ke Jon dia te vavana vamule, a Iesus ia hulenia na kabuna manumanu na vuna ni Jon, “Nazia miu ta lohoia miu kata hadavia kua miu ta vano ni Jon na deset? Miu kata hadavia na kazeze na kavili e habinia ki mamalolo? ");
INSERT INTO wiv_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Kini beu, pele nazia miu ta vano na deset miu kata hadavia? Na kaka e zozohoria na zohozohoa mata mulimuli? Beta, nuhu kua dia ta zozohoria na zohozohoa mata mulimuli dia ta lala dia kata mimia na ruma kana king kamahi. ");
INSERT INTO wiv_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Pele nazia miu ta vano miu kata hadavia? Miu kata hadavia na profet katiu? E limoha, palaka ia e dopa ki hizanga na profet laveve. ");
INSERT INTO wiv_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ia za ia na kaka kua e vapolunganga na poloka buk ke Vuvu ki tani barae voa kirua, ‘Hau da ta geria kagu vakilalanga ki vamuga ni niho, ia da e vaida na dala kiriniho.’ ");
INSERT INTO wiv_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Hau ta tani matotonia ni miu, a Jon kakanaka baptais e dopa ki hizanga na manumanu laveve kua e valohuadia ri na garigari. Palaka nuhu kua beta dia na dopa hizanga na poloka kingdom ke Vuvu, dia ta dopa hizanga ni Jon. ");
INSERT INTO wiv_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Kilaka kua a Jon kakanaka baptais e varivuvu kete vala polea ke Vuvu ki mai ki mule na taem kua, na kingdom kara lagato ti mai matuha matoto, ia mai ve manumanu taza kamana kadia matuhanga dia ve dia ta paparakilania dia kata radia, dia na hada vona. ");
INSERT INTO wiv_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Na profet laveve kamana lo ke Moses ve e pole na vuna na kingdom ke Vuvu ki mai ki mule na taem ke Jon kakanaka baptais. ");
INSERT INTO wiv_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Kua kini kulimiu miu kata longoria kadia polea, pele a Jon ia a Elaija za kua varira na buk ke Vuvu kua e tania kete mai mule. ");
INSERT INTO wiv_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Azei kua kini talinga vona, pele tabu longo papa. ");
INSERT INTO wiv_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Kata vatunga zingania nuhu bukuna tauna kua? Dia ta baliki kapirupiru kotekote, kua dia ta mimia na palakana maket kamahi, dia ka gogoe kiri habu tamaninikidia dia ka tatani barae, ");
INSERT INTO wiv_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Hita ta vilinia kalou, beta miu na parau. Hita ta habia vuroua, beta miu na tangi.’ ");
INSERT INTO wiv_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ia dia ve ta balika dia, a Jon e mai ki mamahoho, manumanu dia ka tania, ‘Na vule zaha e holiholia.’ ");
INSERT INTO wiv_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Na Tuna Kaka ki mai ki beta ni mamahoho, dia ka tania, ‘Ia na kakanaka hani hamohamoa ki kakanaka spak, ki kikilipia nuhuta pelepelea na takis, kamana nuhuta moge zahazaha.’ Palaka lohoihoia pa ke Vuvu ia e mahoto, na vuna haningana e vatunga kakava, ia e mahoto.” ");
INSERT INTO wiv_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Pale, a Iesus ia pole kara manumanu na taon kamahi kua ia e katia na mirakel kapopou luba ni dia, na vuna beta dia na pokizia magalidia. ");
INSERT INTO wiv_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ki tani barae, “Kaba loho zahanga ni niho, ho Korasin! Kaba loho zahanga ni niho, ho Betsaida! Na vuna na mirakel kamahi kua e katua na polokomiu ni katua ni Tair kamani Saidon, ma varira za dia te puae dia kene pokizia magalidia, dia kene lohoria na beke dia kene bode na habulo. ");
INSERT INTO wiv_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Palaka hau tania ni miu, da e dopa ki kemi ke Tair kamani Saidon na damana kotoa kapou ke Vuvu. Palaka miu da miu ta vairo matoto. ");
INSERT INTO wiv_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Miu vuni Kaperneam miu ta lohoia da miu ta vazaheanga zahe kara lagato, ai? Mara beta matoto, da miu ta varaganga kiri loloni habuna. Ta mirakel kamahi kua e katua na polokomiu, ni katua varira ni Sodom, ma a Sodom e ba vovona kua. ");
INSERT INTO wiv_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Palaka hau ta tania ni miu, da e dopa ki kemi ke Sodom na damana kotoa kapou ke Vuvu. Palaka miu da miu ta vairo matoto.” ");
INSERT INTO wiv_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Kilangata kua a Iesus e tani barae, “Hau ta vazahenia hiza, Tamagu, Paraha kara lagato kamana garigari, na vuna zia ho tu litiginia goloaloa kua na nuhu kua kadia hada lalanga vona kamana nuhu kua bakadia vona. Kunu vatunga kakava ni kapirupiru kotekote. ");
INSERT INTO wiv_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","E limoha, Tamagu, na vuna zia ia kua e kuli matoto kete kubarae. ");
INSERT INTO wiv_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Goloaloa laveve kava Tamagu ti vala ni niau, kata hada vona. Beta kaka katiu ni lala hau azei matoto, a Tamagu za ia e lalau. Beta ve kaka katiu ni lala matotonia Tamagu azei, a Tuna za, ia e lala, ki vatunga Tamana na nuhu kua ia ti makia kete vatunga kakava Tamana ni dia. ");
INSERT INTO wiv_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Miu mai ni niau, miu laveve kua livuhamiu ti buzabuza na lugaluganga na bizea kapopou, miu mai ni niau miu na hivu. ");
INSERT INTO wiv_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Miu pelea kagu polea ni ngoro na polokomiu, miu na muri ni niau, miu kata hivu na goloaloa kua e vavala bizea na vulemiu. Na vuna Hau ta valugulugiau ka lala kata vazihoni mulehiau. ");
INSERT INTO wiv_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Na vuna kagu polea e beta ni vitiha marata, goloa ta vala miu kata luga, beta ni bize.” ");
INSERT INTO wiv_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Na dama, na Sabat katiu, a Iesus e vavana na poloka vanua na vit kamahi. Kana disaipel kamahi e vitolonidia, pale, dia ta duledule na paleka vit dia kene hahania. ");
INSERT INTO wiv_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Tania a vuni Parisi dia ka hada baraenia, dia ta tania ni Iesus, “Hada! Ka disaipel kamahi dia te katia nazia kua e tanga beta kete katua na Sabat.” ");
INSERT INTO wiv_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","A Iesus ki tania ni dia, “Beta za miu na hadavia na poloka buk kana Paraha nazia kua a Devit e katia, kilangata kua ia kamana nuhu kua dia ta mumuri vona dia ta katia kilangata kua e vitolonidia? ");
INSERT INTO wiv_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","A Devit e hoho na poloka ruma ke Vuvu kamana kana manumanu, dia ka hania na bret kena ti vabilasianga ki tabutabua mara beta kaka vetanga ni hania, na pris kamahi za da dia ta hania. ");
INSERT INTO wiv_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","O beta miu na hada kua na poloka buk kara lo kena na Sabat, na pris kamahi dia ta lala dia kata gagala na poloka tempel na Sabat, palaka beta goloa katiu ni zaha vona? ");
INSERT INTO wiv_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Hau ta tania ni miu, goloa kua e dopa ki hizanga na tempel, ia ri. ");
INSERT INTO wiv_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Kua miu na lala matotonia na polea kua na poloka polea kana Paraha kua e tani barae, ‘Hau e kuligu matoto miu kata kati kemihia na manumanu, beta ni kuligu kara kamiu opa kamahi.’ Ma ti beta miu kata padea polea kara nuhu kua beta dia na katia goloa zaha katiu. ");
INSERT INTO wiv_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Na vuna zia, na Tuna Kaka ia na Tubu kara Sabat.” ");
INSERT INTO wiv_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","A Iesus e vatia palaka kua, ia vano hoho na haus lotu ke vuni Iuda, ");
INSERT INTO wiv_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","na poloka haus lotu kua, na kaka katiu limana e mate. Kilangata kua manumanu taza na poloka haus lotu kua ve, e kukulidia dia kata padea polea kiri Iesus, kubarae dia ta hulenia, “E kemi tolu kata kati kemihia kaka na Sabat?” ");
INSERT INTO wiv_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","A Iesus ki tania ni dia, “Kua katiu ni miu kua kana sipsip ni dua kara poloka lovo na Sabat, karae mara beta ni hare gotalani mulehia? ");
INSERT INTO wiv_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Palaka na kaka ia e dopa na sipsip! Kubarae, kadolu lo ia e tania tolu kodonia kaka na Sabat.” ");
INSERT INTO wiv_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Pale, a Iesus ia tania na kaka kua limana e mate, “Vatatahia lima.” Na kaka kua ia vatatahia limana kini kemi pamuhi, balika paligeni limana. ");
INSERT INTO wiv_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Palaka a vuni Parisi dia ta gotala dia kene taru lupunia polea dia kata hubi matehia a Iesus. ");
INSERT INTO wiv_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","A Iesus e lala nazia kua dia ta tatania dia kata katia vona, ia vatia palaka kua; na manumanu luba dia ta muri vona. Ia ki kati kemihia manumanu laveve kua kadia mazahi vona. ");
INSERT INTO wiv_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ki tani vatuharia ni dia beta dia kata kalohulohunia ia. ");
INSERT INTO wiv_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ia e kati baraenia kete pori matoto na polea ke profet Aisaia kua e tani barae, ");
INSERT INTO wiv_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Miu hadavia kagu vora kua hau mule ta makia, hau e kuligu matoto kirina. Da ta vavonuhia na kagu Vule Tumonga, kete tani kakava kagu moge kua e mahoto, ia mai na kagu kot kua e mahoto, na kantri laveve na vulovulo. ");
INSERT INTO wiv_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Mara beta ni vavaigege o ni gogoe kapopou, ki mara beta ni longora halingana na daladala kamahi. ");
INSERT INTO wiv_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Mara beta ni bara putuhia na tabuka kua ti mamalolo keteni putu, ki mara beta ve ni bara matehia lam kua beta ni kakalakala papa. Da e varidi, ia, ia ki katia moge kua e mahoto kamana kot mahoto kua ke Vuvu ki vin. ");
INSERT INTO wiv_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Na hizana za, manumanu na kantri laveve na vulovulo da dia ta vaka maroro vona.” ");
INSERT INTO wiv_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Dia ta pelea kaka katiu na vule zaha e holiholia ki mai vona, matana e keu ki manga ve. A Iesus ia kati kemihia kaka kua, pale, na kaka kua ia hada kini pole. ");
INSERT INTO wiv_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Manumanu laveve dia ta zipa zahe matoto na goloa kua a Iesus e katia, dia ka tani barae, “Karae ia a Tubuni Devit kua?” ");
INSERT INTO wiv_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Palaka a Vuni Parisi dia ta longoria polea kua, dia ta tania, “Ia e pele kakava na vule zaha kamahi na vuna zia na paraha ke hanitunitu a Belsebul e vavala matuhanga vona kete katia.” ");
INSERT INTO wiv_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","A Iesus ia ti hada lala kadia lohoihoia, ia tani barae ni dia, “Kantri kakei kena na manumanu vona dia ta varipe vulavulahi dia ka vavarihubi na pidaka dia mule, da kantri kena e vairo matoto. Taon kakei o kabu katiu dia na varipe vulavulahi, dia na vavarihubi mule, ia mara beta dia na kemi, da dia ta vairo matoto. ");
INSERT INTO wiv_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Kua kabu rua na kingdom ke Satan hiro na vavarihubi mule, ia hada barae, kava dia te varipe vulavulahi kava kena, da pitu papa dia ta vairo. ");
INSERT INTO wiv_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ta hau na pele kakava na vule zaha na hizani Belsebul, pele kamiu manumanu, dia ta pepele kakava na vule zaha na hizani zei? Kubarae, kamiu manumanu mule dia ta vatunga kakava habuka kamiu polea beta ni mahoto. ");
INSERT INTO wiv_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Palaka kua hau na pele kakava vule zaha na matuhanga kana Vule Tumonga ke Vuvu, ia ti vatunga habuka na kingdom ke Vuvu ti bele ni miu kava. ");
INSERT INTO wiv_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Mara beta kaka katiu ni hutu valahia ruma kana kaka babo ni vile hozovia kana goloaloa, ma muga ki rotu taduria kaka babo kua. Pale, ba muri ia ti vanahea goloaloa na kana ruma. ");
INSERT INTO wiv_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Kaka kua tani beta ni mamadi kamaniau, ia e habuka e madi poki kirigu, kaka kua tani beta ni kakamaniau ni vivile lupunia manumanu, ia tu vavaikali manumanu. ");
INSERT INTO wiv_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Kubarae hau ka tania ni miu, moge zaha laveve, o kua tu pole zaha kiri Vuvu, da e lohoi balanga, palaka azei ho kua tanu pole zahatia na Vule Tumonga, ia mara beta matoto ni lohoi balanga ka manaunaua. ");
INSERT INTO wiv_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Azei tani tania polea zaha katiu kara Tuna Kaka, da a Vuvu e lohoi bala kana manaunaua, palaka azei kua tani tania polea zaha katiu kara Vule Tumonga mara beta matoto ni lohoi balanga kana manaunaua meni kua o na taem ba muri ve.” ");
INSERT INTO wiv_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","A Iesus ki tani barae ve, “Kua hai ni kemi, ia da paleka ve e kemi. Kua hai ni zaha, ia da e vua paleka ki zaha; na vuna hai ia e hada lalanga kua na palekangana. ");
INSERT INTO wiv_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Miu matabunu kamahi miu, miu ta manumanu zahazaha ki kubarae, mara beta miu na tania polea kemi katiu. Na vuna nazia kua e vonu na polokomiu, ia, ia kena e gogotala na havamiu. ");
INSERT INTO wiv_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Kaka kemi ia lohoihoia kemi e ngongoro na poloka. Kubarae ki lala kete kakatia moge kemi. Kaka zaha ia na lohoihoia zaha na poloka kubarae ki lala kete kakatia moge zahazaha. ");
INSERT INTO wiv_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Hau ta tani matotonia ni miu, na damana kotoa kapou ke Vuvu, manumanu da dia ta madi dia ka koto kirua taraka polea vetanga kote katiu kena dia ta varaga. ");
INSERT INTO wiv_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Na vuna zia, na kadolu polea za ia da to ta vinim kotoa vona o da to ta karabus vona.” ");
INSERT INTO wiv_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Pale, na tisa kamahi kara lo kamana Parisi taza dia ta tania ni Iesus, “Tisa, katia mirakel kapou katiu kua kete vatunga habuka ka matuhanga ia e pe ni Vuvu.” ");
INSERT INTO wiv_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","A Iesus ki tania, “Manumanu bukuna tauna kua dia ta manumanu zahazaha matoto ki beta ve dia na lala dia kata vala matotonia magalidia ni Vuvu! Miu ta huleniau kara mirakel? Mara beta! Na mirakel katiu papa kena da e valanga ni miu, ia na mirakel ke profet, a Jona. ");
INSERT INTO wiv_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ia habuka kua a Jona e ngoro dama tolu, marigo tolu na poloka hiha kapou, ia da na Tuna Kaka e ngoro dama tolu, marigo tolu na poloka garigari. ");
INSERT INTO wiv_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Na damana kotoa kapou ke Vuvu, a vuni Ninive da dia ta madi dia ka koto kirimiu, na vuna kamana dia ka longoria polea ke Jona; dia ta pokizia magalidia dia ta zuka tapunia kadia moge zahazaha; palaka hau ta tania ni miu, kaka kua e dopa ki hizanga ni Jona, kua ia ri! ");
INSERT INTO wiv_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Na damana kotoa kapou ke Vuvu, da na Kwin bukuni Sheba da e madi ki koto kirimiu, na vuna zia, ia e vavana zau matoto pe na kana kantri ki mai kete longoria na vaketeketea kemi ke King Solomon; hau ka tania ni miu kaka kua e dopa ki hizanga ni Solomon, kua ia ri!” ");
INSERT INTO wiv_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","A Iesus ki tani barae ve, “Kua na vule zaha katiu ni gotala na kaka katiu, da e vavana na palaka kua e vavaha ki beta naru vona ki hahadahada palaka kete hivu vona. Palaka kua tani beta ni paria palaka katiu, ");
INSERT INTO wiv_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","da e pole kazihezihena ki tani barae, ‘Kata vamule vano kara kagu ruma.’ Pale, ia vamule kini paria habuka, na ruma ti kuvua kini puzopuzoa, kini vaida kemukemuha poloka. ");
INSERT INTO wiv_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Pale, ia vano ia kohania ve na vule zaha e 7 ve kua dia ta dopa zaha matoto vona, dia ta mai mia na poloka ruma kua. Pale, na kaka kua da ti dopa kini zaha matoto na vona kena muga. Ia da e kubarae za na nuhu zahazaha bukuna tauna kua.” ");
INSERT INTO wiv_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","A Iesus e ba popole kamana manumanu barae, a titinana kamani habu tazina kamahi dia ta belebele, dia ka varimadiriai na hatama, dia ka huhule kirina dia kata pole kamana. ");
INSERT INTO wiv_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Kaka katiu ia tania vona, “Katiti kamani habu tazi dia ta varimadiriai na hatama, kulidia dia kata pole kamaniho.” ");
INSERT INTO wiv_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","A Iesus ki hulenia, “Azei titinagu, azei habu tazigu?” ");
INSERT INTO wiv_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Pale, ia vatunga vano kara kana disaipel kamahi ia tani barae, “Hadavia! Kuari ia titinagu kamani habu tazigu kuari! ");
INSERT INTO wiv_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Azei kua tani lala kete mumuri na lohoihoia ke Tamagu kua e heta na lagato, ia na tazigu, livukugu, ia mai titinagu.” ");
INSERT INTO wiv_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Na dama kena za a Iesus e vatia na ruma ia gotala kini pozi mia na hiripa loka ni Galili. ");
INSERT INTO wiv_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Na manumanu luba matoto dia ta mai madi lobia, kubarae ia vatia vazalea ia polo na huduna bot katiu ia mia vona, na kabuna manumanu laveve kua, dia ta ma varimadiriai na vazalea. ");
INSERT INTO wiv_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Pale, ia barikikinia polea na goloa luba ki tani barae ni dia, “Na kaka katiu e vano ki muratania na harana vit na poloka hana vanua. ");
INSERT INTO wiv_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Kamana kua e vana ki mumuratania na harana vit, harana vit taza dia ta dua kara dala na manu kamahi dia ta mai hani hozovia. ");
INSERT INTO wiv_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Na harana vit taza e dua kara palaka kedokedora, beta garigari ni kapou marata vona, kubarae ki pizuzu tapu. ");
INSERT INTO wiv_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Palaka kamana na voro ki zahe ia tiba gatovia na haina vit kotekote kamahi kua, dia ta malailai, na vuna beta vorakadia ni hoho ni dopa ziho na poloka garigari. ");
INSERT INTO wiv_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Harana vit taza dia ta dua kara poloka vuvuna mota matangatanga kamahi, na mota matangatanga dia ta tago matehidia. ");
INSERT INTO wiv_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Harana vit taza dia ta dua kara garigari kemi, dia kene vua. Taza dia ta taruhia palekedia 100, taza e 60, taza e 30. ");
INSERT INTO wiv_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Azei talingana vona, kete longoria polea kua.” ");
INSERT INTO wiv_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Kana disaipel kamahi dia ta mai vona, dia ta hulenia, “E kuziha ku babarikikinia polea ku vavala na manumanu?” ");
INSERT INTO wiv_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","A Iesus ia tania, “Hada lalanga na litigitigia kara kingdom ke Vuvu kava ti valanga ni miu, palaka beta ni valanga ni dia. ");
INSERT INTO wiv_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Azei kua kava ti kana goloaloa taza vona, da a Vuvu e vala taza ve vona, pale, kana goloaloa ia dopa luba matoto. Azei kua tani beta matoto kana goloaloa vona, tani kana pitu vona, ia da a Vuvu e pele kakava ve vona kena. ");
INSERT INTO wiv_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ia ki kuza barae, ka babarikikinia polea ni dia. Ia vata matadia e hahada, mara beta dia na hadavia; ia vata talingadia e lolongo, mara beta dia na longoria dia na lohoi lala. ");
INSERT INTO wiv_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Na manumanu kua, na polea katiu ke profet Aisaia kua e tania varira ti pori matoto kiridia. Ia e tani barae, ‘Da miu ta longoria, longoria polea, palaka mara beta miu na longo lala, da miu ta hada hahada, palaka mara beta miu na hada lala. ");
INSERT INTO wiv_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Na vuna magalina manumanu kua kava ti zobo, ti beta dia ne lolongoria goloa katiu na talingadia, dia kene tabaria matadia tabarae matadia ni hada lala goloa, talingadia ve ni longo lala polea, magalidia ve ni lala na vuvuna polea, dia na pokizia magalidia dia na vamule mai ni niau na kati kemihidia.’ ");
INSERT INTO wiv_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Palaka miu, a Vuvu ti kati kemihia matoto na matamiu kamana talingamiu, na vuna matamiu e hahada na talingamiu ve e lolongo. ");
INSERT INTO wiv_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Hau ta tani matotonia ni miu, na profet luba kamana nuhuta moge kua e mahoto, e kulidia matoto dia kata hadavia nazia kua miu ta hahada, palaka beta dia na hadavia. Dia kata longoria ve nazia kua miu ta lolongoria, palaka ki beta dia na longoria.” ");
INSERT INTO wiv_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","A Iesus ki tani barae ve, “Miu tabu longo papa kara vuvuna barikikia na polea na kaka kua e muratania na harana vit. ");
INSERT INTO wiv_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Kua kaka katiu ni longoria na polealea na kingdom ke Vuvu ki beta ni lohoi lala, ia e balika palekana vit kua e huru kara dala, na kaka zaha ki mai, ia radia nazia kua kava ti vazoha na poloki magalina. ");
INSERT INTO wiv_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Na harana vit kena e dua kara palaka kedokedora ia balika na kaka e longoria na polea, kilangata pamuhi ki hilohilo matoto vona. ");
INSERT INTO wiv_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Palaka beta ni taruhia voraka na poloka, beta ni madi ni havarau. Tani paria bizea katiu beu ni kati zahata ia na vuna e bilip na polea ke Vuvu, ia poke tapu. ");
INSERT INTO wiv_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Na harana vit kena e dua kara poloka vuvuna mota matangatanga ia e balika kaka kena e longoria na polea, palaka ki lohoihoi marata na goloaloa bukuna garigari kua kete katia ni mia papa, na goloaloa mata mulimuli bukuna garigari ki rukia, dia ta kari havutia polea ke Vuvu na poloka, kini beta ni vua. ");
INSERT INTO wiv_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Na harana vit kena e dua kara garigari kemi ia e balika na kaka kua e longoria na polea ke Vuvu ki lohoi lala. Kini vua, kini taruhia paleka habuka 100, 60 o 30.” ");
INSERT INTO wiv_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","A Iesus e barikikinia polea katiu ve ni dia ki tani barae, “Na kingdom ke Vuvu ia e balika na kaka e muratania na harana vit kemi na poloka hana vanua. ");
INSERT INTO wiv_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Palaka manumanu dia ta ba varingoroai, hana vagi e mai ia muratania na harana raburabu zaha kara pidaka harana vit kamahi, pale, kini hava. ");
INSERT INTO wiv_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Tania na vit ki galulu ki zahe ki taruhia paleka, dia ta hada na raburabu zaha ve dia ta gagalulu ve kamana. ");
INSERT INTO wiv_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Na kana vora e vano ia tania na tauana vanua, ‘Tubu ho tu vazohia na harana vit kemi na ha vanua. Pele, na raburabu zaha e pe ve ki gagalulu ve na poloka vanua?’ ");
INSERT INTO wiv_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ia ki tania ni dia, ‘Hagu vagi katiu e katia kena.’ Na kana vora ki hulenia, ‘E, kuli hita kata vano vuruvuru?’ ");
INSERT INTO wiv_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ia ki tania, ‘Beu, na vuna ta miu na vuruvuru na raburabu zahazaha kena da miu ta vuru balalania na vit kamana. ");
INSERT INTO wiv_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Vatia hiro ka rua galulu zahe ki mule na damana tolu keteni pelea haninga na vanua. Da hau te tania na nuhu kua dia kata pelea haninga na vanua, dia kata muga vaia na raburabu zahazaha, dia ta kutu lupunia kete tunua; dia ta vai lupunia na vit, dia ta taru lupunia na poloka kagu rumaka vit.’” ");
INSERT INTO wiv_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","A Iesus ki barikikinia polea katiu ve ni dia ki tani barae, “Na kingdom kara lagato ia e balika na harana hamo, kena na kaka e pelea ki vazohia na poloka hana vanua. ");
INSERT INTO wiv_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Na harana hamo ia e dopa ki gala kote na harana hai laveve, palaka kua kini galulu da e dopa ki horaha livutia na hai laveve tu vazohia na poloka vanua. Da e horaha ki kara hai kapou, pale, manu kamahi dia ta mai bale na dangadangana.” ");
INSERT INTO wiv_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","A Iesus e barikikinia polea katiu ve ki tani barae ni dia, “Na kingdom ke Vuvu ia e balika yis kua e pitu papa za, kua na tavine katiu e pelea ki kamo pokizia kamana dram na palaua kapou katiu. Na palaua kini kudu kini kapou matoto.” ");
INSERT INTO wiv_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","A Iesus e barikikinia polea laveve kua ki tatania na goloaloa laveve kua na kabuna manumanu. Beta ni tani kakava polea katiu ni dia beta, polea laveve ia e barikikinia za. ");
INSERT INTO wiv_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ia kati baraenia kini pori matoto na polea kua muga na profet katiu e tania. Na profet kua e tania barae, “Hau da ta barikikinia polea ka pole kamadia vona. Da ta tania ni dia goloaloa kua varira za e paritigi kilaka kua na garigari e bele ki mai ki mule na tauna kua.” ");
INSERT INTO wiv_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Pale, a Iesus ia vatia na kabuna manumanu kamahi, ia vano kara ruma. Kana disaipel kamahi dia ta mai vona dia ka tania, “Tania ni hita na mining na barikikia na polea na raburabu zaha na poloka vanua.” ");
INSERT INTO wiv_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","A Iesus ki tania ni dia, “Na kaka kua e muratania na harana vit kemi, ia na Tuna Kaka. ");
INSERT INTO wiv_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Vanua ia na vulovulo, na harana vit kemi ia e makia na habu tutuna kingdom ke Vuvu. Na raburabu zaha dia ta makia habu tutuni Satan, ");
INSERT INTO wiv_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","na vagi kena e muratania na raburabu zaha ia a Satan za. Na damana pelepelea na haninga ia e makia na las de. Na nuhuta pelepelea na haninga na vanua ia na engel kamahi. ");
INSERT INTO wiv_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Habuka za kua na raburabu zaha kua e vai lupuanga ki tunua na haroho, ia da e kati bareanga ve na las de. ");
INSERT INTO wiv_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Na Tuna Kaka da e geria kana engel kamahi, dia ka vai lupunia, dia ka pele kakava na poloka kana kingdom nazia kua e kakatia manumanu dia ka poke na pekato, ia mai manumanu zahazaha laveve. ");
INSERT INTO wiv_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Da dia ta varagadia kara poloka haroho kapou, na poloka haroho kua da dia ta ma hahaloho, hazedia ki vuvuluhero. ");
INSERT INTO wiv_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Pale, nuhu kua dia ta mumuri na lohoihoia ke Vuvu da dia ta kalageru balika voro na poloka kingdom ke Tamadia. Azei kua talingana vona, kete longoria. ");
INSERT INTO wiv_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Na kingdom ke Vuvu ia e balika na bokis moni kua e litigianga na poloka vanua. Kaka katiu ia paria. Pale, ia kari havuti mulehia, ia hilohilo matoto, ia vano ia salinia kana goloaloa laveve ia pelea monina, kini vano kadea na vanua kua vona.” ");
INSERT INTO wiv_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","A Iesus ki tani barae ve, “Ki vano ve, na kingdom ke Vuvu ia e balika bisnisman katiu kua e kakaze kara tali mata mulimuli. ");
INSERT INTO wiv_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Kamana ki paria katiu kua monina e kapou matoto ia vano, ia salinia kana goloaloa laveve ia pelea monina, ia kadea tali kua vona.” ");
INSERT INTO wiv_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","A Iesus ki tani barae ve, “Ki vano ve, na kingdom ke Vuvu ia e balika vuho kua e vazihoanga kara poloka loka ki vatingovia na hiha luba kua e paramotu, paramotu. ");
INSERT INTO wiv_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Kamana na vuho ki vonu na hiha, pale, na nuhuta puria, dia ta harehia vuho ziho kara vazalea. Pale, dia ta mia dia ta vile palia na hiha kemikemi, dia ta goro na kirei kamahi, palaka na hiha zahazaha dia ta varaga. ");
INSERT INTO wiv_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ia da e balika za kua tani las de. Engel kamahi da dia ta mai, dia ta pele kakava nuhu zahazaha na poloka nuhu kua dia ta lala dia kata mumuri na lohoihoia ke Vuvu, ");
INSERT INTO wiv_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","da dia ta varagadia kara poloka haroho kapou, na poloka haroho kua da dia ta ma hahaloho, hazedia ki vuvuluhero.” ");
INSERT INTO wiv_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","A Iesus ki hulenia kana disaipel kamahi, “Miu ta lohoi lala polealea kamahi kua?” Dia ka tani barae, “E.” ");
INSERT INTO wiv_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","A Iesus ki tani barae, “Pele kubarae, na tisa laveve kara lo, kua kava ti vaketoadia na matotoka polea, na vuna na kingdom ke Vuvu, ia dia ta balika paraha katiu kua e hoho kara poloka rum kua e lala kete tapi lupunia kana goloaloa mata muli vona ki pele gotalania goloa burabura kamana goloaloa vahoruhoru.” ");
INSERT INTO wiv_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Kamana a Iesus ki barikikini hozovia na polealea kamahi, ia vatia palaka kua. ");
INSERT INTO wiv_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Pale, ia vano bele na kana malala mule, kini vavaketea manumanu na poloka haus lotu ke vuni Iuda, dia ka ridi matoto. Dia ka varihulei, “Kaka kua e pelea na lohoihoia kemikemi kua kamana matuhanga kua kete katia na mirakel kamahi kua, ni ve matoto? ");
INSERT INTO wiv_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Karae, beta ni ia na tuni kapenta kua? Karae, beta ni hizani titinana kua a Maria? Karae ve, beta ni habu tazina kua a Jems, a Iosep, a Saimon ia mai a Iudas? ");
INSERT INTO wiv_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Karae, beta ni habu livuka laveve kua dia ta mimia kamadolu? Pele, ia e pelea ni ve matoto na lohoihoia pa kamahi kamana matuhanga laveve kua?” ");
INSERT INTO wiv_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Pale, dia ta pole katia. A Iesus ia tania kiridia, “Na profet da e hada zaheanga na malala laveve, palaka na kana malala mule ia mai na poloka kana ruma mule mara beta ni hada zaheanga.” ");
INSERT INTO wiv_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","A Iesus beta ni katia mirakel ni luba na kana malala mule, na vuvuna beta dia na bilip vona. ");
INSERT INTO wiv_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Kilaka kua a Herot, na gavana ni Galili, ia e longoria na polea laveve na vuna ni Iesus, ");
INSERT INTO wiv_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ia tania na kana voravora kamahi, “Kaka kua, ia a Jon Kakanaka baptais kua ti mahuri mule na matea! Kuza barae ki kana matuhanga vona kete katia na mirakel kamahi.” ");
INSERT INTO wiv_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","A Herot e tatani barae na vuna muga, ia ti haba taduria a Jon kini rotu taduria kini taruhia na karabus na vuvuna ni Herodias, goni tazina, a Filip, ");
INSERT INTO wiv_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","na vuna a Jon ia e tani barae vona, “Beta ni mahoto koto kabania a Herodias!” ");
INSERT INTO wiv_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","A Herot e kulina matoto kete hubi matehia a Jon, palaka ki kuahinia na manumanu, na vuna dia ta hadavia a Jon dia ka tania ia na profet katiu. ");
INSERT INTO wiv_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Na betdei ke Herot ti bele, na tuni Herodias tavine ia parau na matana manumanu laveve kua dia ta lohu. A Herot ki hilohilo matoto vona, ");
INSERT INTO wiv_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","pale, ia mapamapa na tavine kua kete vala vona nazia kua e kulina kirina. ");
INSERT INTO wiv_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Pale, a titinana ia geria, ia tani barae ni Herot, “Taruhia bakani Jon Kakanaka baptais na pelete katiu, ho tu vala ni niau. (Kata lala a Jon ti mate matoto.)” ");
INSERT INTO wiv_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","A King e longoria polea kua ki vari matoto, palaka kava ti mapamapa kamu na matana manumanu laveve kua dia ta lohu na kana betdei, kubarae, ia tania dia ta muri na lohoihoia kana tavine kua; ");
INSERT INTO wiv_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","pale, ia geu dia ta le hutuzia lohori Jon na poloka karabus, ");
INSERT INTO wiv_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","dia ta taruhia bakana na poloka pelete katiu, dia ta vala na tavine kua, ia vano vala ni titinana. ");
INSERT INTO wiv_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Na disaipel kamahi ke Jon dia mai luga podani Jon dia kene vano tavunia. Muri dia ta vano tania ni Iesus. ");
INSERT INTO wiv_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Kamana a Iesus ki longoria goloa kua ti bele ni Jon, ia polo na bot ia vatia palaka kena kini vano kara palaka kua beta kaka vona. Palaka kamana dia ka longoria habuka a Iesus ti polo na bot kini vano, dia ta vatia kadia taon kamahi, dia ta vavana pe na dala dia ta muri vona. ");
INSERT INTO wiv_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","A Iesus ia zipa na bot, tania ki hadavia na kabuna manumanu kapou kua, lohora ki zaha matoto ni dia, ia kati kemihia nuhu kua e mazahitidia. ");
INSERT INTO wiv_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ti garavi matoto, na disaipel kamahi ke Iesus dia ta mai ni Iesus dia ta tani barae, “Na palaka kua e zau matoto na malala, kava keteni marigo; geria manumanu kua dia na vano kara malala kamahi kua kozoho dia na kadokado hadia haninga.” ");
INSERT INTO wiv_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","A Iesus ki tania ni dia, “E kuziha dia kata vano? Miu mule miu vala goloa katiu ni dia, dia na hania.” ");
INSERT INTO wiv_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Na disaipel kamahi dia ka tania, “Na bret e lima kamana hiha rua za kua.” ");
INSERT INTO wiv_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","A Iesus ki tania, “Miu pelea mai ni niau.” ");
INSERT INTO wiv_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","A Iesus ia tania na kabuna manumanu kamahi kua dia ta loli tadu na raburabu. Ia pelea na bret lima kamana hiha rua kua, ia tunga vatada kara lagato, ia hate motunia a Vuvu, ia bara vulahia na bret kamahi kua, ia vala na kana disaipel kamahi dia ta vazenia na manumanu. ");
INSERT INTO wiv_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Dia laveve dia ta hanihani magalidia ki kurukuru. Pale, na disaipel kamahi dia ta pelea kolopi e 12, dia ta gorea na kalangara haninga kua dia ta vatia, kirei laveve kua e vonuvonu. ");
INSERT INTO wiv_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Na naba na manumanu kua dia ta hanihani kilangata e 5,000. Beta ni hazeanga tavivine kamani kapirupiru. ");
INSERT INTO wiv_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Pale, a Iesus ia geria kana disaipel kamahi dia kata polo na bot dia na vamuga vano kara paligena loka. Ia kete mia ki geria manumanu kua dia ka vavana. ");
INSERT INTO wiv_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ti geri hozovia manumanu dia kene vano hozo, ia vori kara potuna kazihena kete lotu. Ti marigo, a Iesus ia kazihena za na palaka kua; ");
INSERT INTO wiv_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","na bot ia kava ti vatia vazalea ti zau matoto, na dazi ki titi hania kadia bot, na vuna na kavili e mai matoto na muga dia. ");
INSERT INTO wiv_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ti kozoho keteni dama a Iesus ia vavana na huduna loka kini zahe ni dia. ");
INSERT INTO wiv_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Tania na disaipel kamahi dia ta hadavia a Iesus kua e vavana na huduna dazi, dia ta kuahi zahazaha matoto, dia ka tani barae, “Na hanitu kuari!” Dia ka kuahi zahazaha matoto dia kene varigigiai. ");
INSERT INTO wiv_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","A Iesus ia baribari tapu ia pole kamadia, ki tani barae, “Miu pahoria magalimiu, hau za kua. Taua miu na kuahi.” ");
INSERT INTO wiv_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","A Pita ki tania, “Paraha, kua kini ho za, pele tania na vana na huduna loka na vano ni niho.” ");
INSERT INTO wiv_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","“Mai,” a Iesus e tania. Pale, a Pita ia zipa na bot, kini vana na huduna naru vano kiri Iesus. ");
INSERT INTO wiv_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Palaka kamana ki hatunia na kavili, ia kuahi kini mamahitu, ia goe kavukavu ki tania, “Paraha kodoniau!” ");
INSERT INTO wiv_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","A Iesus ia tabe vano tapu ia pahoria. Ia ki tania kirina, “E kuziha ku lohoi ruarua? Ka bilip beta ni kapou!” ");
INSERT INTO wiv_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Tania hiro ka polo langa na huduna bot, na kavili ia malugunia. ");
INSERT INTO wiv_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Nuhu kua na huduna bot dia ta lotu vona dia ka tania, “Matoto, matoto ho na Tuni Vuvu!” ");
INSERT INTO wiv_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Dia ta dua hutu na naru, dia ta ziho vaki ni Genesaret. ");
INSERT INTO wiv_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Na manumanu bukuna palaka kua dia ta hada lala a Iesus, dia ta geu kara nuhu kua mazahi ni dia kua na malalala laveve na palaka kua, dia ta vilehidia mai ni Iesus. ");
INSERT INTO wiv_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Dia ka hule haroinia a Iesus habuka kua nuhu kua mazahi ni dia, kua dia na vakulia za kana hiripa klos. Pale, nuhu laveve kua dia ta vakulia kana klos dia ta kemi mule. ");
INSERT INTO wiv_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Na Parisi taza kamana tisa kamahi kara lo taza dia ta pe ni Ierusalem dia ka mai ni Iesus dia ka hulenia, ");
INSERT INTO wiv_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“E kuziha ka disaipel kamahi ki beta dia na mumuri na rovu ke habu tubuhita? Beta dia na lala dia kata vavazuguvia na limadia muga, ba muri dia na hanihani!” ");
INSERT INTO wiv_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","A Iesus ki hulenidia, “E kuziha miu kene vala lamamiu kara lo ke Vuvu, miu kene mumuri na rovu ke habu tubumiu mule? ");
INSERT INTO wiv_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Na vuna a Vuvu e tani barae, ‘Miu hada zahenia habu tamamiu kamani habu titinamiu, kua tanu delahania kamama o katiti, ia ho koto hubu matoa.’ ");
INSERT INTO wiv_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Palaka miu ta tania na manumanu kubarae, kua ni kadia goloa katiu vona kua e dangea dia kata kodonia habu tamadia o habu titinadia vona, palaka kua ta dia na tani barae, ‘Goloa kua te vala ke Vuvu kava kua.’ ");
INSERT INTO wiv_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Pale, da beta ve dia keteni hada zahenia tamadia kamani habu titinadia. Na dala kua za ia miu te vaka katia na lo ke Vuvu, miu kene mumuri na rovu ke habu tubumiu. ");
INSERT INTO wiv_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Miu ta nuhuta vairukua na lotua! A profet Aisaia ia e tani matotonia polea kua e tani barae kirimiu, ");
INSERT INTO wiv_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Manumanu kamahi kua dia ta vavazahenia hizagu na havadia za, palaka magalidia e zau matoto ni niau.’ ");
INSERT INTO wiv_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Dia ta lotu veta za ni niau, palaka dia ka vavaketea kadia lohoihoia mule na manumanu dia ka tania ia kagu lo kena!” ");
INSERT INTO wiv_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","A Iesus ia kohania na manumanu dia ta mai kozoho vona, ia tania ni dia, “Miu longoria miu na longo lala. ");
INSERT INTO wiv_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Goloa kua e hoho na havana kaka beta ni katia kaka ni molumolua, beu, nazia kua e gotala ki pe na havana kaka ia e katia kaka ki molumolua.” ");
INSERT INTO wiv_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Na kana disaipel kamahi dia ta mai vona dia ka hulenia, “Tu lala habuka tu vairohia magali ni vuni Parisi na ka polea kena?” ");
INSERT INTO wiv_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","A Iesus ki tania, “Hai laveve kena a Tamagu heta na lagato e beta ni vazohia, da e dae vuruta. ");
INSERT INTO wiv_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Miu vatidia, matadia e keu, dia ka vavamuga na nuhu kua matadia e keukeu. Kua kaka matana kini keu kua kini vavamuga na ruana katiu kua ia ve e keu, da hiro ta rua dua kara lovo.” ");
INSERT INTO wiv_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","A Pita ki tania, “Tani kakava ni hita na mining na barikikia kena.” ");
INSERT INTO wiv_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","A Iesus ki tania kiridia, “E kuziha, miu ve ma beta za miu na hada lala goloa? ");
INSERT INTO wiv_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ma beta miu na lohoi lala? Goloa laveve kena e hoho na havana kaka, ia e ziho kara paro kapou, ba muri ia kokoanga. ");
INSERT INTO wiv_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Palaka nazia kua e pe na hava ki gotala ia pe na magali, ia na goloa kua e katiho ku molumolua. ");
INSERT INTO wiv_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Na vuna zia, kua na poloki magali, ia na lohoihoia zahazaha kua e katiho ku hubi matea kaka, ku vaitago kamana kaka motu kua beta ni go matoto, ku magali buhu, ku vanaho, ku vavairuku, ku delahania kaka. ");
INSERT INTO wiv_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ia kua goloaloa e katia kaka ki molumolua. Palaka kua ta beta nu vazuguvia lima ku hanihani, ia beta ni katiho nu molumolua kena.” ");
INSERT INTO wiv_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","A Iesus e vatia palaka kua, ia vano kara palaka kua na pidaka taon karua kua, a Tair kamani Saidon. ");
INSERT INTO wiv_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Na tavine katiu bukuni Kenan e mai ni Iesus ia haloho matoto ki tania, “Paraha, Tubuni Devit, mahariau! Na tugu tavine, na vule zaha ti holiholia kini vairohia matoto.” ");
INSERT INTO wiv_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","A Iesus beta ni kolia ni tania polea katiu vona. Pale, na kana disaipel kamahi dia ta ma huhulenia a Iesus dia ka tatania vona, “Geria ni vano! E mumuri ni dolu ki vavalala!” ");
INSERT INTO wiv_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","A Iesus ki tania, “Hau e geura hau kiri vuni Israel, kara sipsip kamahi kua dia te golugolu.” ");
INSERT INTO wiv_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Tania a Iesus ki tani barae, na tavine kua ia mai dua kara kabeni Iesus ki tania, “Paraha kodoniau!” ");
INSERT INTO wiv_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","A Iesus ki tania vona, “E beta ni mahoto kete peola haninga he kapirupiru ni valanga ni kauaua.” ");
INSERT INTO wiv_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Na tavine kua ki tania, “E matoto kena Paraha, palaka na kauaua ve dia ta lala dia kata hahania na momota haninga kua e huru na tebol ke tauadia.” ");
INSERT INTO wiv_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Pale, a Iesus ia tania vona, “Ho tavine kua ka bilip e kapou matoto! Nazia kua e kuli kirina da tu pelea.” Pale, kamana pamuhi za, na tuna tavine kua ia kemi pamuhi. ");
INSERT INTO wiv_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","A Iesus e vatia palaka kua, ia vavana lilia na naru ni Galili. Ia vori na potuna katiu ia mia tadu. ");
INSERT INTO wiv_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Manumanu luba matoto dia ta mai vona, dia ta pelea nuhu kua, kabedia kamana limadia e matemate, nuhu kua matadia e keukeu, nuhu kua manga ia mai dia luba ve kua mazahi ni dia, dia ta vangoredia na kabeni Iesus, a Iesus ia kati kemihidia laveve. ");
INSERT INTO wiv_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Manumanu laveve dia ta zipa zahe matoto, kamana dia ka hadavia nuhu kua, dia ta manga dia te popole, nuhu kua kabedia kamana limadia e matemate, dia te vavana, nuhu kua matadia e keukeu dia te hada; dia ta vazahenia a Vuvu ke vuni Israel. ");
INSERT INTO wiv_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","A Iesus ia kohania kana disaipel kamahi dia ta mai vona, ia tania ni dia, “Lohorogu e zaha na manumanu kua, na vuna dia te mia kamaniau dama ti tolu kava, kini beta hadia haninga dia kata hania. Mara beta na geri vetanidia na vamulemule, kua e vitolonidia. Tabarae matadia ni lolovio dia na poke na dala.” ");
INSERT INTO wiv_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Kana disaipel kamahi dia ka hulenia, “Da tolu ta pele zingania haninga ri kua na palaka kua beta matoto kaka vona, tolu ka vangania manumanu kua e luba marata barae kua vona?” ");
INSERT INTO wiv_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","A Iesus ki hulenidia, “E ziva bret kena ni miu?” Dia ta tania, “E 7, na hiha kotekote taza.” ");
INSERT INTO wiv_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Pale, a Iesus ia tania na manumanu dia ta loli tadu na garigari. ");
INSERT INTO wiv_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ia pelea na bret e 7 kua kamana hiha, ia hate motunia a Vuvu, ia bara vulahia bret, ia vala na kana disaipel kamahi, dia ta vala na manumanu. ");
INSERT INTO wiv_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Manumanu laveve kua dia ta hanihani magalidia ki kurukuru. Na disaipel kamahi dia ta gorea kolopi e 7 na kalangara haninga kua e vatua. ");
INSERT INTO wiv_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Naba na manumanu kua dia ta hanihani kilangata, e 4,000. Beta ni hazeanga tavivine kamani kapirupiru. ");
INSERT INTO wiv_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Pale, a Iesus ia geria manumanu dia ta vamulemule, ia polo na bot, kini vano kara palaka kua kozohotia a Magadan. ");
INSERT INTO wiv_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Vuni Parisi kamani vuni Sadyusi dia ta mai dia kata parakilania a Iesus. Dia ta hulenia kete vatunga na mirakel katiu bukuna lagato, kete vatunga habuka matoto a Vuvu ia e makia. ");
INSERT INTO wiv_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","A Iesus ki tani barae ni dia, “Kua voro kini zuzugu na garavi, miu kene hadavia kua e balanga na mariaba ki hada baritunutunua, ia lala miu kata tani barae, ‘Da vaila e voro ki manilo.’ ");
INSERT INTO wiv_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Kua kini damadama miu kene hadavia na mariaba e baritunutunua ki mariabanga, ia miu ta lala miu kata tani barae, ‘Da e huza kua.’ Miu ta lala miu kata hada lala matotonia na mak kamahi na mariaba, palaka beta matoto miu na hada lala na goloaloa kua e bebele meni. ");
INSERT INTO wiv_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Manumanu bukuna tauna kua, miu ta manumanu zahazaha matoto, ki beta ve miu na lala a Vuvu! Miu ta huleniau kara mirakel? Mara beta miu na hada! Na mirakel katiu papa za kua kete valanga ni miu, ia na mirakel ke Jona!” Pale, ia vati tapunidia kini vano. ");
INSERT INTO wiv_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Tania na disaipel kamahi dia ka pe poki kara paligena loka ni Galili, dia te ba lohoia habuka beta dia na pelea bret katiu. ");
INSERT INTO wiv_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","A Iesus ia tani barae ni dia, “Miu lohoia. Miu lohoimiu na yis ke vuni Parisi kamani vuni Sadyusi.” ");
INSERT INTO wiv_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Na disaipel kamahi dia ka pole na pidaka dia mule, dia ka tani barae, “Ia e tatani barae na vuna beta tolu na pelea bret.” ");
INSERT INTO wiv_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","A Iesus e lohoi lala nazia dia ta tatania, kubarae ia hulenidia, “E kuziha miu ka popole na pidaka miu mule habuka beta miu na pelea bret? ");
INSERT INTO wiv_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ma beta za miu na lohoi lala? Beta miu na lohoia kilaka kua ta bara vulahia bret lima za manumanu kua 5,000 dia ka hania? E ziva kirei miu ta gorea na kalangara haninga? ");
INSERT INTO wiv_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Pele kua na bret e 7 kua manumanu e 4,000 dia ta hania? E ziva kirei na kalangara haninga miu ta gorea? ");
INSERT INTO wiv_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","E kuziha ki beta miu na longo lala habuka beta hau na popole na bret? Miu lohoimiu na yis ke vuni Sadyusi kamani vuni Parisi.” ");
INSERT INTO wiv_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Pale, dia te ba lohoi lala kubarae ia beta ni popole na yis tataruha na bret. Palaka ia e tatania ni dia, dia kata lohoi dia na vaketeketea ke vuni Parisi kamani vuni Sadyusi. ");
INSERT INTO wiv_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","A Iesus ia vano kara palaka katiu kua e kozoho ni Sisaria kamani Filipai, ia hulenia kana disaipel kamahi, “Manumanu dia ta tania na Tuna Kaka ia azei matoto?” ");
INSERT INTO wiv_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Dia ta kolia dia ka tania, “Taza dia ta tania ia a Jon kakanaka Baptais. Taza dia ta tania ia a Elaija. Dia taza dia ta tania ia a Jeremaia o ia katiu ni dia na profet kamahi.” ");
INSERT INTO wiv_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","A Iesus ki hulenidia, “Pele miu mule, miu ta tania hau azei?” ");
INSERT INTO wiv_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","A Saimon Pita ki tania, “Ho a Kristus, na Tuni Vuvu kua e mahuri roro.” ");
INSERT INTO wiv_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","A Iesus ki tania vona, “A Vuvu e kati kemihia matoto ni niho, Saimon tuni Jona! Na vuna mara beta kaka katiu ri na garigari ni vala matotoka polea kena ni niho, polea kena a Tamagu kua e heta na lagato e vala ni niho. ");
INSERT INTO wiv_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Kubarae hau ka tania ni niho, Pita, ho na kedo, na huduna faundesion kedo kua, da ta habatia kagu sios. Na matuhanga kana matea mara beta ni vinim. ");
INSERT INTO wiv_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Hau da ta vala ni niho na ki kara kingdom ke Vuvu, nazia tu tabunia ri na garigari ia da a Vuvu tabunia ve na lagato. Nazia tu tania kete katua na garigari da a Vuvu ve e tania kete katua ve na lagato.” ");
INSERT INTO wiv_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Pale, ia tani vatuharia matoto na kana disaipel kamahi habuka, beta dia kata tania na kaka katiu habuka ia a Kristus. ");
INSERT INTO wiv_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Muri na kua ki vano, a Iesus ia ti vavarivuvu keteni tatani kakava habuka, ia kete vano kiri Ierusalem ni luga bizea luba na limani pararaha ke vuni Iuda, na hetpris kamahi, ia mai na tisa kamahi kara lo. Pale, ia ti hubi matoa, na dama tolu muri da a Vuvu e valamari mulehia. ");
INSERT INTO wiv_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","A Pita ia kohania a Iesus vano kara hiripa, ia pole kirina ki tani barae, “Paraha, mara beta! Goloa kena mara beta ni bele ni niho.” ");
INSERT INTO wiv_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","A Iesus ia tare poki ia tania ni Pita, “Satan, kakava na matagu! Ho kua tu mamadi porotia kagu dala. Beta nu mumuri na lohoihoia ke Vuvu, tu mumuri na lohoihoia kana kaka za.” ");
INSERT INTO wiv_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","A Iesus ki tania na kana disaipel kamahi, “Kua kini kulimiu miu kata kamaniau, ia tabarae miu na taruhia lohoihoia ni miu mule, miu luga kamiu kruse, miu ta muri ni niau. ");
INSERT INTO wiv_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Na vuna, azei kua tani lolohoia kete vavaikoli kara vulena mule, da e paho kavu kirina, palaka azei kua tani vala vulena ni niau, ia da e pelea mulehia. ");
INSERT INTO wiv_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Da e kemi ziha kana kaka kua tani pelea goloaloa laveve ri na vulovulo, palaka vulena ti golu? Da nazia matoto e katia ki pele mulehia vulena vona? ");
INSERT INTO wiv_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Na vuna na Tuna kaka da e mai kamana kana engel kamahi na glori ke Tamana, ia ti kadea kaka katiukatiu muri na kana mogemoge kamahi. ");
INSERT INTO wiv_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Hau ta tani matotonia ni miu, taza ni miu kua miu ta varimadiriai kua, mara beta miu na mate, miu ka hadavia na Tuna Kaka kua ti ziziho balika king.” ");
INSERT INTO wiv_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Dama 6 muri na kua, a Iesus ia pelea a Pita, a Jems ia mai a tazina a Jon, ia vamuga ni dia, dia kene vori kara potuna horaha, beta kaka ni kamadia, dia za. ");
INSERT INTO wiv_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Tania dia ka madi hahada barae, na livuhani Iesus ia pokizia, na damana ia kalageru balika voro, kana zohozohoa ti puzo varitihitihi matoto, balika laet. ");
INSERT INTO wiv_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Pale, na disaipel tolu kua, dia ta hadavia a Moses kamani Elaija hiro ta popole kamani Iesus. ");
INSERT INTO wiv_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","A Pita ia tani barae ni Iesus, “Paraha, e kemi matoto ki hita ri kua kamaniho, kua ni kuli, hau ta habatia kape tolu ri kua, ka katiu, katiu ke Moses, katiu ke Elaija.” ");
INSERT INTO wiv_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","A Pita e ba popole barae, na mariaba e babala matoto, e ziho ia kari havutidia, pale, na halingana kaka katiu e pe na mariaba kua ki tani barae, “Kua ia na Tugu kua e kuligu matoto kirina, hau ta hilohilo matoto vona; miu longo kirina.” ");
INSERT INTO wiv_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Tania na disaipel kamahi kua dia ka longoria polea kua, dia ta kuahi zahazaha matoto dia ka dua, dia ka bula vatudu na garigari, ");
INSERT INTO wiv_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Palaka a Iesus e mai, ia vakulidia, ki tania, “Miu madi, taua miu na kuahi.” ");
INSERT INTO wiv_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Pale, dia ta tada dia ta hadavia habuka, ti beta kaka, a Iesus za. ");
INSERT INTO wiv_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Dia ta vavana dia ka titiro mule na potuna, a Iesus ia tani barae ni dia, “Tabarae, miu na tania na kaka katiu na visen kua, ki vano ki mule na dama kua na Tuna Kaka ki valamari muleha na matea.” ");
INSERT INTO wiv_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Na disaipel kamahi dia ka hulenia, “Pele e kuziha na tisa kamahi kara lo dia ka tania, a Elaija da muga ki mai?” ");
INSERT INTO wiv_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","A Iesus ki tania, “Polea kena e matoto, a Elaija ia kete mai ni vahotovia goloaloa laveve; ");
INSERT INTO wiv_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","palaka ta tania ni miu, a Elaija kava ia ti mai, ki beta dia na hada lala, beta, dia ta muri na kadia lohoihoia mule dia kene kati zahatia vona. Ia da dia ta kati zahati baraenia ve na Tuna Kaka.” ");
INSERT INTO wiv_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Pale, dia ta lohoi lala habuka a Iesus e popole ni Jon kakanaka Baptais. ");
INSERT INTO wiv_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Tania dia ka vamule ziho na kabuna manumanu, na tamohane katiu e mai ni Iesus ia padonia tutura na kabeni Iesus, ");
INSERT INTO wiv_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ia tani barae, “Paraha, maharia tugu tamohane! E lala kete dadaea, ki lala kete bebele zahazaha matoto kirina. Boto luba e lala kete dudua kara haroho o kara poloka naru. ");
INSERT INTO wiv_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Hau ta pelea vano na ka disaipel kamahi, palaka ki mara beta dia na kati kemihia.” ");
INSERT INTO wiv_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","A Iesus ki tania, “Miu manumanu bukuna tauna kua, beta matoto kamiu bilip miu ka katia manumanu dia ka babatola, miu ta lohoia da ta ma mimia ki havarau kamamiu? Kete boto ziva kata ma luluga kamiu bizea? Pelea kapiru kena ni mai.” ");
INSERT INTO wiv_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","A Iesus ia pole kara vule zaha kua, ia gotala na kapiru kua, pale, na kapiru kua ia kemi pamuhi za. ");
INSERT INTO wiv_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Pale, ba muri, na disaipel kamahi dia ta mai kazihedia ni Iesus, dia ta hulenia, “E kuziha ki beta hita na dangea hita kata pele kakava?” ");
INSERT INTO wiv_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","A Iesus ki tania ni dia, “Na vuvuna, beta kamiu bilip. Hau ta tani matotonia ni miu, kua ka bilip ni gala kote habuka harana hamo, ho e dangea koto tani barae na potuna kuari, ‘Vahere ri kua nu vano kiri rae,’ ia da e longoria ka polea. Mara beta goloa katiu ni vitiha ni niho.” ");
INSERT INTO wiv_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Tania na disaipel laveve dia ka mai lohulohu laveve ni Galili, ia tania ni dia, “Na Tuna Kaka da e valanga na limana nuhu ");
INSERT INTO wiv_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","kua dia kata hubi matehia, na dama tolu muri vona, ia mahuri mule.” Pale, kana disaipel kamahi lohorodia ki zaha matoto. ");
INSERT INTO wiv_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Tania dia ka mai bele ni Kaperneam, na nuhuta pelepelea na takis kara tempel dia ta mai ni Pita, dia ta hulenia, “Ka tisa e lala kete kakadea na takis kara tempel?” ");
INSERT INTO wiv_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","A Pita ki tania, “E, ia e lala kete kadea takis.” Tania a Pita ki pe hoho na ruma, a Iesus ia muga pole kamana, ki tania, “Saimon, tu lohoi ziha, na king kamahi bukuna garigari kua dia ta lala dia kata pelea takis ni vuni zei matoto? Na manumanu bukuna kantri mule, o na manumanu motumotu kua beta dia na bukuna kantri kua?” ");
INSERT INTO wiv_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","A Pita ki tania, “Na manumanu motumotu.” A Iesus ki tania, “Pele tani kubarae, beta tolu kata kadea takis, na vuna tolu ta vuvuna malala. ");
INSERT INTO wiv_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Palaka beta ni kulidolu tolu kata vairohia magalina manumanu kua. Vano kara loka, ho tu tapunia ka string. Hare zahenia na hiha kena tu muga ku havilia, ho tu hada na poloki havana, da tu paria na moni, e dangea koto kadea ka takis ia mai ve kagu. Pelea ho tu vala ni dia kara kado takis.” ");
INSERT INTO wiv_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Kilaka kua na disaipel kamahi dia ta mai ni Iesus dia ka hule, “Azei e dopa ki hizanga na poloka kingdom ke Vuvu?” ");
INSERT INTO wiv_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","A Iesus ia kohania kapiru kote katiu mai, ia vamadiria na pidaka dia, ");
INSERT INTO wiv_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ki tani barae, “Ta tani matotonia ni miu, kua ta beta miu na pokizimiu miu na baliki kapirupiru, ia mara beta matoto miu na hoho na kingdom ke Vuvu. ");
INSERT INTO wiv_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Kaka kua kete hizanga na poloka kingdom ke Vuvu, ia kete vazihonia ni balika kapiru kote kua. ");
INSERT INTO wiv_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Azei kua tani koi taduria kapiru kote katiu mata barae kua, ia e koi taduriau ve.” ");
INSERT INTO wiv_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","A Iesus ki tani barae ve, “Palaka kua ta kaka katiu ni katia kapirupiru kamahi kua dia ta bilip ni niau dia na poke na pekato, e dopa ki kemi kete rotua kedo kapou na lohora ni vahituva ia na madoro kapou. ");
INSERT INTO wiv_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kaba loho zahanga na manumanu bukuna garigari! Goloaloa vona kua e lala kete katia manumanu dia na pepekato! Goloaloa kamahi kua da e bebele, palaka da e dopa ki zaha matoto kana kaka kua e katia manumanu dia ka popoke na pekato! ");
INSERT INTO wiv_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Kua lima o kabe kini katiho kunu poke na pekato, le hutuzia nu varaga. E dopa ki kemi kua koto kabe bale o lima bale nu hoho mia papa na mianga pa. Tabarae ni lima ruarua vona o kabe ruarua vona, nu varaganga kara haroho kua beta ni lala kete mamate. ");
INSERT INTO wiv_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Kua mata kini katiho kunu poke na pekato, bara luahia nu varaga; na vuna e dopa ki kemi koto mata bale nu hoho na mianga pa. Tabarae mata ruarua ni ba vovona nu varaganga kara haroho na hel. ");
INSERT INTO wiv_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","Miu lohoia, tabarae miu na lohoia na kapirupiru kamahi kua dia ta goloa vetanga. Na vuna, ta tani matotonia ni miu, kadia engel kamahi dia ta mamadi dama laveve na matani Tamagu kua heta na lagato.” ");
INSERT INTO wiv_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Miu ta lohoi ziha? Ta kaka katiu kana sipsip ni 100, katiu ni dia ni golu, mara beta ni vatia dia 99 kena, na hiripa potuna, ia ni vano kaze kara katiu kena ti golu? ");
INSERT INTO wiv_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Kua ni paria, ta tani matotonia, da e dopa ki hilohilonia na sipsip kua e golu, dopa na kana sipsip 99 kua beta dia na golu. ");
INSERT INTO wiv_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ia e kubarae za, a Tamagu kua e heta na lagato, beta ni kulina katiu na kapirupiru kotekote kua dia kata golu.” ");
INSERT INTO wiv_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Kua tazi kini katia moge zaha katiu ni niho, vano vona, ti mo kazihe mo, ho tu pole kamana ku tani valugia vona na nazia kua e katia ki zaha ni niho. Kua kini hada lala habuka ka polea e matoto, ia kava tu pele mulehia tazi katiu kava kena. ");
INSERT INTO wiv_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Palaka kua kini beta ni kulina kete longoriho, vano pelea kaka katiu beu rua ve hiro kata kamaniho, habuka kete, witnes rua beu tolu dia kata kodoniho na polea. ");
INSERT INTO wiv_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Kua kini vanga holuholu ve ni dia, pele vano tani kakava na sios; kua tani vanga holuholu ve na sios; pele katia vona nazia kua miu ta lala miu kata kakatia na nuhu kua beta dia na lala a Vuvu, o na nuhuta pelepelea na takis. ");
INSERT INTO wiv_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Hau ta tani matotonia ni miu, nazia miu ta tabunia ri na garigari ia da a Vuvu ve e tabunia na lagato. Nazia kua miu ta tania kete katua na garigari da a Vuvu e tania kete katua na lagato. Goloa kua miu ta tabunia ri na garigari da e tabuanga ve na lagato, nazia kua miu ta hulia ri na garigari da e hulua ve na lagato. ");
INSERT INTO wiv_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Kata tania ve pebarae, ta moro rua ri na garigari mo na magali katiu mo kata hulenia a Vuvu kua e heta na lagato kara goloa katiu, ia da e katia. ");
INSERT INTO wiv_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Na vuna kua kaka rua beu tolu dia na lupu na vuna na hizagu, ia hau na pidaka dia.” ");
INSERT INTO wiv_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","A Pita e mai ni Iesus ia hulenia, “Paraha, kete boto ziva kua hau kata lohoi bala na goloa zaha kua a tazigu e katia ni niau? Botona kete 7?” ");
INSERT INTO wiv_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","A Iesus ki tania vona, “Beta ni 7, palaka botona 77. ");
INSERT INTO wiv_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Na vuna zia, na kingdom ke Vuvu ia habuka kua na king katiu e mia ki tania kete vahotovia pepa na dinau kana, kana voravora kamahi. ");
INSERT INTO wiv_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","E ba vavahotohoto barae, na kana vora katiu e peola ki mai vona kua kana dinau e 10 milion kina; ");
INSERT INTO wiv_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","palaka beta na vora kua ni dangea kete kolia na kana dinau, pale, na king kua ia geu dia kata salinia kamani gona, ia mai habu tutu hiro ve, ia mai kana goloaloa laveve, na monidia kete valanga vona ia kete kolia kadia dinau vona. ");
INSERT INTO wiv_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Na vora kua ia dua kara kabena king kua, ki haloho matoto ki tania, ‘Vala taem pitu ve ni niau, da ta kolia kagu dinau laveve ni niho.’ ");
INSERT INTO wiv_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Na king kua lohora e zaha vona, pale, ia tania vona habuka da e lohoi bala kana dinau, pale, ia kini geria na vora kua kini vano. ");
INSERT INTO wiv_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Palaka na vora kua, kamana ki pe gotala, ia pe paria na ruana vora katiu, na vora kua e dinau vona na 10 kina; tania ki hadavia, ia paho kotohia lohora, ia tania vona, ‘Koli tapunia ka dinau!’ ");
INSERT INTO wiv_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Na ruana vora kua e dua kara kabena ki haloho matoto vona ki tania, ‘Vala taem ni niau pitu ve, da ta kolia.’ ");
INSERT INTO wiv_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Palaka kaka kua beta ni kulina. Beta. Ia pelea ruana kua ia vano vahohoria na karabus, ki vano ki mule na dama kua ia kete kolia kana dinau. ");
INSERT INTO wiv_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Na habu tamaninika vora kua, dia ta hada galanga kua e bele, dia ta sore matoto, pale, dia ta vano tania na king na goloa kua e bele. ");
INSERT INTO wiv_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Pale, na king kua ia geu kara vora kua ia vano vona. Tania ki mai bele, na king kua ki tania kirina, ‘Ho tu vora zaha matoto! Hau ta lohoi bala ka dinau kapou ni niau, na vuna tu haloho haroiniau matoto. ");
INSERT INTO wiv_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Mara beta nu maharia rua kena, habuka kua hau ta mahariho?’ ");
INSERT INTO wiv_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Na king magalina e varitihi matoto kirina ia vahohoria na karabus, ki kati zahata matoto vona, ia, ia ki vano ki koli mulehia kana dinau laveve. ");
INSERT INTO wiv_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","A Tamagu ve heta na lagato da e kati baraenia ve ni miu laveve, kua ta beta miu na lohoi bala matoto na poloki magalimiu, na moge zaha kena habu tazimiu dia ta katia ni miu.” ");
INSERT INTO wiv_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Kamana a Iesus ki tani hozovia polea kamahi kua, ia vatia a Galili kini vano kiri Iudea na paligena naru a Iordan. ");
INSERT INTO wiv_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Manumanu luba matoto dia ta muri vona, ia ki pele kakava mazahi kamahi ni dia. ");
INSERT INTO wiv_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Na Parisi taza dia ta mai ni Iesus dia kata pado rukia. Dia ta hulenia, “E mahoto na kadolu lo kua na tamohane katiu, ni lohoia kete vamia tapunia gona, ia vamia tapunia za?” ");
INSERT INTO wiv_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","A Iesus ki kolia kadia hulea ki tania, “Beta miu na hadavia na poloka buk ke Vuvu, kua varivuvuka matoto kua a Vuvu e katia goloaloa laveve, ia e katia tamohane kamana tavine ve? ");
INSERT INTO wiv_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","A Vuvu ki tani barae, ‘Ia vuvuna kua, tamohane ia da e vatia tamana kamani titinana, ki vaidodo kamani gona, livuhahiro kini katiu papa.’ ");
INSERT INTO wiv_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Kini beta hiro ne ma kaka ni rua, beu, hiro te kara kaka katiu papa. Ki kubarae, mara beta matoto kaka ni hutu pahia nazia kua a Vuvu ti vaidodonia kava.” ");
INSERT INTO wiv_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Dia ta hulenia a Iesus, “Pele e kuziha a Moses ki vala lo katiu kubarae, kua tamohane ni beta ni kulina kiri gona, ia da e vala pepana vamia taputapua vona, ia geri kakava?” ");
INSERT INTO wiv_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","A Iesus e tania ni dia, “A Moses e tara ni miu, miu kata vamia taputapu habu gogomiu na vuna, e vitiha matoto kete vaketoa miu. Palaka kua na varivuvuka matoto, kilaka kua a Vuvu e katia goloa laveve, ia beta ni kubarae. ");
INSERT INTO wiv_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Kubarae, hau ka tania ni miu, ma a go e balebale kamana kaka motu ku vamia tapunia, palaka kua tanu vamia tapunia taraka goloa motumotu, nu kabania tavine motu katiu, ia tu katia makina magali buhua kena.” ");
INSERT INTO wiv_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Kana disaipel kamahi dia ta tania vona, “Pele kena tani kuza barae na pidaka tamohane kamani gona tavine, pele vata lahia.” ");
INSERT INTO wiv_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","A Iesus ki tania ni dia, “Beta manumanu laveve ni dangea dia kata pelea polea kua ta vavala. A Vuvu e vala matuhanga na manumanu taza za dia kata pelea. ");
INSERT INTO wiv_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Na vuvuna luba kua e katia ki beta tamomohane taza dia na lalahi, tamomohane taza e valohuadia ki beta keledia, taza dia ta vatomutomuhia keledia, ki mara beta dia na lahi, taza dia ta lohoia beta dia kata lahi, na vuna dia ta lohoia dia kata katia galanga kara kingdom ke Vuvu. Kaka kua e dangea kete pelea polea kua, ia pelea.” ");
INSERT INTO wiv_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Manumanu taza dia ta pelea kapirupiru mai ni Iesus kete taruhia limana na hududia ni lotu kiridia. Palaka kana disaipel kamahi dia ta pole kiridia. ");
INSERT INTO wiv_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Palaka a Iesus ki tania, “Vatia kapiru kotekote dia na mai ni niau, taua miu na taledia, na vuna na kingdom ke Vuvu, ia kana nuhu kamahi kua.” ");
INSERT INTO wiv_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","E bilasnia kapirupiru kua hozo, ia vatia palaka kua kini vavana. ");
INSERT INTO wiv_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Na kaka katiu e mai ni Iesus ki hulenia, “Tisa, goloa pa zia kata katia na pelea mahuri roroa?” ");
INSERT INTO wiv_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","A Iesus ki hulenia, “E kuziha ku huleniau na vuna na moge kua e kemi? Kaka katiu za ia e kemi. Palaka kua kini kuli koto pelea mahuri roroa, ia koto muri na lo laveve ke Vuvu.” ");
INSERT INTO wiv_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Na kaka kua ia hule, “Na lo kakei matoto kena?” A Iesus ki tania vona, “Taua nu hubi matehia kaka, tabarae nu vaitago kamana kaka motu kua beta ni go matoto, tabarae nu vanaho, taua nu vairuku veta kara kaka, ");
INSERT INTO wiv_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","hada zahenia kamama kamani katiti, ia mai kete kuli matoto kara kaka kua e mimia kozohotiho, habuka kua e lala kete kukuli kiriniho mule.” ");
INSERT INTO wiv_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Na tamohane huluvahu kua ki tania, “Lo laveve kena ta lala kata mumuri papa matoto vona. Nazia matoto ma beta na kati kemihia?” ");
INSERT INTO wiv_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","A Iesus ki tania vona, “Kini kuli koto mahoto matoto, vano salinia ka goloaloa laveve nu vala monina na nuhu kua beta matoto kadia goloaloa vona, kete ka goloaloa kemikemi luba vona heta na lagato; pale, ho tu mai muri ni niau.” ");
INSERT INTO wiv_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Tania na tamohane huluvahu kua ki longo baraenia, ia tare poki ia vavana. E wari matoto, na vuna ia e risman matoto. ");
INSERT INTO wiv_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","A Iesus ki tania na kana disaipel kamahi, “Hau ta tani matotonia ni miu, e vitiha matoto na risman kete hoho na kingdom ke Vuvu. ");
INSERT INTO wiv_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kata tani mulehia ve ni miu, beta ni vitiha na kamel kua kete hoho na horupa nil kara samap, palaka na risman, e vitiha matoto kua ia kete hoho na kingdom ke Vuvu.” ");
INSERT INTO wiv_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Kamana na disaipel kamahi dia ka longo baraenia, dia ta ridi matoto dia ka tania, “Pele da azei da ti dangea keteni pelea mahuri roroa kua?” ");
INSERT INTO wiv_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","A Iesus ia hada boroboro ni dia ki tania ni dia, “Na kaka, goloa kua ia e vitiha, palaka ni Vuvu, beta goloa katiu ni vitiha.” ");
INSERT INTO wiv_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","A Pita ki tania, “Hita te vatia goloa laveve hita kene muri ni niho. Nazia da hita ta pelea kua?” ");
INSERT INTO wiv_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","A Iesus ki tania ni dia, “Hau ta tani matotonia ni miu, kua na malala vahoru, kua na Tuna Kaka ti mia na kana sia king kua e vonu na glori, da miu 12 kua, miu ta mumuri ni niau, da miu ta mia na sia king e 12, habuka jas kua kete koto kara zukazuka kua e 12 bukuni Israel. ");
INSERT INTO wiv_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Manumanu laveve kua dia ta zuka tapunia kadia rumaruma, o habu tazidia o livukudia o tamadia o titinadia o habu tutudia o hadia vanua dia ka muri ni niau, da a Vuvu e kadedia boto 100 dopa, na goloaloa kua dia ta zuka tapunia, ia vala ve mahuri roroa ni dia. ");
INSERT INTO wiv_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Palaka manumanu luba kua dia ta hizanga muga, da ti beta hizadia, manumanu luba kua beta dia na hizanga, da hizadia ti papane.” ");
INSERT INTO wiv_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Na kingdom ke Vuvu ia e habuka kua na kaka katiu, e lama na damadama ia vano kete pelea manumanu dia kata gala na hana vanua na vaen. ");
INSERT INTO wiv_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Nuhu kua dia ta tara vona habuka dia kata gala kara 10 Kina na dama katiu, pale, ia geridia dia ta zahe gala. ");
INSERT INTO wiv_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ti kozoho keteni 9 kilok, ia vano paria manumanu taza dia ta madi vetaveta na poloka maket; ");
INSERT INTO wiv_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ia tania ni dia, ‘Miu ve miu vano miu na gala na poloka hagu vanua na vaen, da ta kademiu na kamiu galanga.’ ");
INSERT INTO wiv_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Pale, dia ta vano gala. Na 12 kilok ia mai na 3 kilok ve, ia e kati baraenia ve. ");
INSERT INTO wiv_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ti kozoho kete 5 kilok na garavi, ia vano ia hadavia manumanu taza ve dia ta mamadi vetaveta ve na palakana maket, ia ki hulenidia, ‘E kuziha miu ka mamadi vetaveta na dama ia, ia kini garavi, beta miu na kakatia goloa katiu?’ ");
INSERT INTO wiv_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Dia ta tania vona, ‘Beta kaka katiu ni pelehita kara galanga.’ Ia mai tania ni dia, ‘Miu ve miu vano gala na poloka hagu vanua na vaen.’ ");
INSERT INTO wiv_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ti garavi na tauana vanua na vaen kua, ia tania na kana bosboi, ‘Kohania nuhuta galanga nu kadedia. Varivuvu ku vala moni kana nuhu kena dia ta muri mai, ku zahe ku vahozovia na nuhu kua dia ta muga mai.’ ");
INSERT INTO wiv_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Nuhu kua dia ta mai dia ka gala na 5 kilok, e kadoa dia na 10 kina. ");
INSERT INTO wiv_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Pale, nuhu kua e peloa dia na dama dia ka mai, dia ta lohoia da dia ta pelea moni dopa ki kapou ni dia taza. Palaka katiukatiu ni dia e pelea ve 10 kina. ");
INSERT INTO wiv_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Tania dia ka pelea kadia moni, dia ta pole ngungu kara kaka kua e peledia dia ka mai gala, ");
INSERT INTO wiv_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","dia ka tania, ‘Nuhu kua dia ta muri mai, dia ta gala aua katiu za, hita kua hita ta gala na dama ia ia ki garavi na poloka voro kapou. Ho tu kadedia na moni habuka kua tu kadehita vona.’ ");
INSERT INTO wiv_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Na kaka kua ki tani barae na katiu ni dia, ‘E ho, hau beta na kati zahatia ni niho; ho tu tara koto gala na dama katiu na kadeho na 10 kina. ");
INSERT INTO wiv_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Pelea ka moni nu vano. Hau e kuligu kata kadea kaka kua e muri matoto ki mai na 10 kina ve balika kena ta kadeho vona. ");
INSERT INTO wiv_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","E kagu galanga. Karae mara beta na muri na kagu lohoihoia mule na vala kagu moni na kaka kua e kuligu kata vala vona? Beu, tu hada potiau vona kua ta kemi kiri rua?’” ");
INSERT INTO wiv_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Pale, a Iesus ia tani barae, “Nuhu kua dia ta mumuri da dia te vamuga, nuhu kua dia ta vavamuga, da dia te muri.” ");
INSERT INTO wiv_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","A Iesus e vavana ki zahe kiri Ierusalem, ia kohania kana 12 disaipel kamahi, dia ta mai vona, ia tani barae ni dia, ");
INSERT INTO wiv_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Miu longoria, tolu kata zahe kiri Ierusalem kua. Ta tolu na bele da e paho tadura na Tuna Kaka ki valanga ia na limana hetpris kamahi kamana tisa kamahi kara lo, dia ta koto kirina kete hubu matoa ia, ");
INSERT INTO wiv_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","pale, dia ta vala ia vano na limana nuhu kua beta dia na lala a Vuvu, dia ta nongonia, dia ta vihia, dia ta havenia na kruse ia mate; palaka na dama tolu muri, a Vuvu da e valamari mulehia na matea.” ");
INSERT INTO wiv_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Pale, a goni Sebedi ia pelea tuna rua dia ta mai ni Iesus, ia padonia tutura na mugani Iesus ki hule a Iesus kete kodonia. ");
INSERT INTO wiv_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","A Iesus ki hulenia, “Nazia matoto kuli kirina?” Na tavine kua ki tania, “Mapamapa ni niau habuka na tugu karua kua, ni ba muri kua koto kara king, hiro kata mia kamaniho. Katiu kete mia kara lima kiri maroro, katiu kete mia kara lima kiri mauri.” ");
INSERT INTO wiv_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Palaka a Iesus ki tania ni dia, “Beta miu na lala nazia miu ta huhule kirina. Mo ta dangea mo kata hinu na kap na bizea kua hau kata hinumia?” Hiro ta tania, “E.” ");
INSERT INTO wiv_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","A Iesus ki tania ni hiro, “Da mo ta hinu na kagu kap, palaka kua mo kata mia kiri marorogu o kiri maurigu, ia hau mara beta na katia kena. Palaka kamahi kena, ia kana nuhu kua kava a Tamagu ti makidia kini vaida kadia.” ");
INSERT INTO wiv_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Tania dia disaipel taza kua e 10 dia ka longoria polea kua, magalidia ki varitihi kara varitazini rua kua. ");
INSERT INTO wiv_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Palaka a Iesus ia kohanidia ta mai vona ia tania, “Miu ta lala na king kana nuhu kua beta dia na lala a Vuvu, dia ta lala dia kata bosim matoto kadia manumanu. Kadia pararaha ve dia ta lala dia kata tania na kadia manumanu dia kata muri matoto na kadia polea kamahi. ");
INSERT INTO wiv_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Galanga kua ia beta kete bele na pidaka miu, azei kua e kulina kete kara kamiu paraha, ia kete kara kamiu vora vetanga, ");
INSERT INTO wiv_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","azei kua kini kulina hizana kete dopa ni papane ni miu laveve, ia kete kara kamiu vora vetanga. ");
INSERT INTO wiv_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Habuka kua na Tuna Kaka e ziho beta kete vora vonanga voa, palaka ia kete vora kana manumanu, kete vala kana laep kete kado mulehia manumanu luba na karabus na pekato.” ");
INSERT INTO wiv_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Tania a Iesus kamana kana disaipel kamahi dia ka vatia a Jeriko, na kabuna manumanu kapou dia ta muri vona. ");
INSERT INTO wiv_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Na kaka rua, matahiro e keu, hiro ta mimia na hiripa dala, kamana hiro ka longoria a Iesus kua e vavana hutu, hiro ta goe hiro ka tania, “Paraha, Tubuni Devit, maharimiro!” ");
INSERT INTO wiv_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Na kabuna manumanu kua dia ta harovitinihiro dia ka tania hiro kata zodo, palaka hiro ta dopa matoto hiro ka goe hiro ka tania, “Paraha, Tubuni Devit maharimiro!” ");
INSERT INTO wiv_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","A Iesus ia madi, ia kohanihiro ki hulenihiro, “Nazia matoto kulimoro kata katia ni moro?” ");
INSERT INTO wiv_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Hiro ka tania vona, “Paraha, kulimiro, miro kata hada.” ");
INSERT INTO wiv_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","A Iesus lohora e zaha ni hiro, ia vakulia matahiro. Matahiro ia kemi pamuhi, hiro kene muri vona. ");
INSERT INTO wiv_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","A Iesus kamana kana disaipel kamahi dia ta vavana vano kiri Ierusalem, dia ta bele ni Betfage na potuna a Oliv, pale, a Iesus ia geria kana disaipel rua, ");
INSERT INTO wiv_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ki tania ni hiro, “Mo vamuga vano kara malala kuari na muga dolu, da mo ta paria na donki katiu e rotua ki mamadi, kamani tuna. Hulia mota ni hiro mo ta pelehiro mai ni niau. ");
INSERT INTO wiv_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Kua kaka katiu kini hulenimoro, mo tani barae, ‘Paraha kana galanga ni hiro.’ Da ia e vala mulehi tapunia.” ");
INSERT INTO wiv_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Goloa kua ti bele kete pori matoto na polea kana profet kua e tani barae, ");
INSERT INTO wiv_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Tania na siti ni Saion, ‘Hadavia, kamiu king ti mamai ni miu! Ia ti vazihoni mulehia kini polo na donki, na tuna donki na huluvahuta donki.’” ");
INSERT INTO wiv_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Na disaipel karua hiro ta vano kati muria nazia kua a Iesus e tania ni hiro. ");
INSERT INTO wiv_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Hiro ta pelea na donki kua kamani tuna mai, dia ta voloria na lavalava na huduhiro, a Iesus ia polo mia na huduna. ");
INSERT INTO wiv_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Na kabuna manumanu kapou dia ta voloria na lavalava na dala, taza dia ta bazia na dangadangana hai kamahi, dia ka tapia na dala. ");
INSERT INTO wiv_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Na kabuna manumanu kua dia ta vamuga vona, mai nuhu kua dia ta mumuri vona, dia ta gogoe dia ka tatani barae, “Vazahenia na hizani Tubuni Devit! A Vuvu e kati kemihia matoto na kaka kua e mai na hizana Paraha! Vazahenia hizani Vuvu kua ia e heta matoto!” ");
INSERT INTO wiv_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Tania a Iesus ki hoho ni Ierusalem, na manumanu laveve na poloka siti dia ta rovo tori mai vano dia ka varihulei dia ka tania, “Azei matoto kua?” ");
INSERT INTO wiv_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Na kabuna manumanu kua dia ta kamani Iesus dia ka tania, “A Iesus kua, na profet bukuni Nasaret ni Galili.” ");
INSERT INTO wiv_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","A Iesus e hoho na poloka tempel ki vaka buratania manumanu laveve kena dia ta mamaket, ia mai nuhu kua dia ta vavaikado ve na poloka. E vapopo vatuduhia na tebol kamahi kana nuhu kua dia ta senisnia moni kamahi, ia mai na mianga kana nuhu kua dia ta sasalinia na balu kamahi. ");
INSERT INTO wiv_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ia tania kiridia, “E vapolu bareanga na buk kana Paraha, ‘Kagu ruma ia kete kohanga na rumaka lotua.’ Palaka miu te katia kini kara palakangana paritigia kana nuhuta vanahoa.” ");
INSERT INTO wiv_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Pale, na nuhu kua matadia e keu, ia mai nuhu kua kabedia beu limadia kua e zaha, dia ta mai vona na poloka tempel, ia kati kemihidia. ");
INSERT INTO wiv_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Palaka tania na hetpris kamahi kamana tisa kamahi kara lo dia ka hadavia na goloa kemikemi kua e kakatia, ki mai ve kua na kapirupiru dia ve te gogoe na poloka tempel dia kene tatani barae, “Vazahenia na hizani Tubuni Devit!” magalidia ki zaha matoto. ");
INSERT INTO wiv_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Dia ka hulenia a Iesus, “Ho tu longoria nazia kuari dia ta tatania?” A Iesus ki tania, “E, hau ta longoria kuari, beta miu na hazenia na polea kana Paraha kua e tani barae, ‘Ho tu katia kua kapirupiru kotekote kamana nuhu kua dia ta ba zuzuzu, dia kata vazaheni kemikemihia matoto hiza.’” ");
INSERT INTO wiv_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","A Iesus ia vatidia, ia gotala kini vano kiri Betani kini ngoro vona. ");
INSERT INTO wiv_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Na damadama ti vamule kara taon, ia hatunia ti vitolonia. ");
INSERT INTO wiv_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ia hadavia na haina fik katiu na hiripa dala, ia vano kete pelea paleka ni hania, palaka e vano ia hadavia beta paleka vona, rauna za. Pale, ia tania kara haina fik kua, “Da mara beta ve nu vua!” Pale, na haina fik kua ia malaini pamuhia za. ");
INSERT INTO wiv_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Tania na kana disaipel kamahi dia ka hada baraenia, dia ta lohoi tori matoto, dia ka tani barae, “Na haina fik kua e malaini tapuni zingania kua?” ");
INSERT INTO wiv_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","A Iesus ki tania ni dia, “Hau ta tani matotonia ni miu, kua miu na bilip, ni beta miu na lohoi ruarua. Da e nap miu kata katia nazia kua ta katia na haina fik kua. Ki nap ve miu kata tani barae ve kara potuna kua, ‘Divurutiho nu pozi nu dua kara poloka dazi.’ Pale, ia da e muri za na kamiu polea. ");
INSERT INTO wiv_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Kua nu bilip, ia da tu pelea nazia kua tu lolotu ku huhulenia a Vuvu kirina.” ");
INSERT INTO wiv_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","A Iesus ia vano hoho na poloka tempel, kini vavaketekete na manumanu, na hetpris kamahi kamana pararaha ke vuni Iuda dia ta mai vona, dia ta hulenia, “Tu pelea matuhanga kua ni ve, o azei matoto e vala matuhanga ni niho koto kakatia galangalanga kamahi kua?” ");
INSERT INTO wiv_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","A Iesus ki tania, “Hau ve da ta hulenimiu na hulea katiu. Miu kene kolia ni niau, pele hau da te tania ni miu azei matoto e vala matuhanga ni niau kata kakatia galangalanga kamahi kua. ");
INSERT INTO wiv_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","A Jon, e pelea kana matuhanga kua kete vala baptais na manumanu, ni ve? Kana matuhanga e pelea ni Vuvu o na kaka katiu ri na garigari e vala vona?” Pale, dia ta vaigege na pidaka dia mule dia ka tania, “Kua tolu na tania, bukuna lagato, da e tania, ‘E kuziha ki beta miu na bilip vona?’ ");
INSERT INTO wiv_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Palaka kua ta tolu na tania, ‘Kana matuhanga e mai na kaka bukuna garigari,’ da tolu ta lohoidolu na manumanu, na vuna dia ta bilip za habuka a Jon, ia na profet katiu.” ");
INSERT INTO wiv_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Pale, dia ta tania ni Iesus, “Beta hita na lala.” A Iesus ki tania ni dia, “Hau ve mara beta ve na tania ni miu na matuhanga kua, ta pelea ni ve ka kakatia galangalanga kamahi kua.” ");
INSERT INTO wiv_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","A Iesus ki tani barae ve ni dia, “Miu ta lohoi ziha? Na kaka katiu tuna tamohane rua. Ia vano ni tuna muganga ki tania, Tugu, meni vano gala na poloka vanua na vaen. ");
INSERT INTO wiv_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Na tuna muganga kua ki tani barae, ‘Mara beta na vano.’ Palaka ba muri ia pokizi mulehia kana lohoihoia ia vano. ");
INSERT INTO wiv_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Tamana ia vano ni tuna muria ia tani baraenia ve vona. Ia tara ki tania, ‘Hau da ta vano.’ Palaka kini beta ni vano. ");
INSERT INTO wiv_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Azei ni hiro e muri na lohoihoia ke tamahiro?” Dia ka tania, “Na kapiru muganga.” A Iesus ia tania ni dia, “Hau ta tani matotonia ni miu, nuhuta pelepelea na takis kamana nuhuta magali buhua, dia te vavamuga hohoho na kingdom ke Vuvu ni miu. ");
INSERT INTO wiv_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Na vuna a Jon e mai ki vatunga na dala mahoto ni miu, miu kata muri vona, palaka ki beta miu na vaka maroro vona. Palaka na nuhuta takis kamana nuhuta magali buhua, dia ta bilip ni Jon. Miu ta hadavia, palaka ia beta za miu na pokizia magalimiu miu na bilip vona.” ");
INSERT INTO wiv_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","A Iesus ki tani barae ve ni dia, “Miu longoria barikikia katiu ve kua. Na kaka katiu e vazohia na vanua na vaen katiu. Ia diva lobia, e hovia na palaka kete vaka bebeha na vaen vona, ia habatia na taua katiu, pale, ia vala na manumanu taza dia kata gala bisnis vona, pale, ia vatia kini vano kara kantri motu katiu. ");
INSERT INTO wiv_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ti damana kua keteni duledule voa na paleka vaen ti mai kozoho, ia geria kana voravora dia kata zahe na nuhu kua dia ta gala bisnis na hana vanua na vaen, dia na pelea palekana hana vaen. ");
INSERT INTO wiv_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Na nuhu kua dia ta gala bisnis na hana vanua na vaen, dia ta hubi zahatia kana vora katiu, dia ka hubi matehia katiu, katiu dia ta lubia na kedo. ");
INSERT INTO wiv_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ia geria ve kana voravora taza ve, dopa ki luba na nuhu kena e muga ki geridia, palaka na nuhu kua ia dia ta kubaraenidia ve. ");
INSERT INTO wiv_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Pale, ia tani barae, ‘Kata geria tugu, da dia ta hada zahenia.’ ");
INSERT INTO wiv_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Tania na nuhu kua dia ta gagala bisnis na vanua na vaen kua dia ka hadavia na tuna kaka kua, dia ta varitaninia, ‘Ia kua na kaka kua, da ba muri ki pelea na vanua kua, miu mai tolu na hubi matehia tolu kata pelea hadolu vanua kua.’ ");
INSERT INTO wiv_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Pale, dia ta haba taduria dia ta varaga gotalania na vanua na vaen, dia kene hubi matehia.” ");
INSERT INTO wiv_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","A Iesus ia hulenidia, “Pele, kua ta na tauana vanua na vaen kua ni mai, da e kuzingania na nuhu kua dia ta gala bisnis na hana vanua na vaen?” ");
INSERT INTO wiv_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Dia ka tania vona, “Da e hubi matehia na nuhu zahazaha kena, ia vala na vanua na vaen na nuhu motu, kua dia ta dangea dia kata gala bisnis vona dia na vala dihura haningana vanua ni vamule vona, na damana pelepelea na haninga na vanua.” ");
INSERT INTO wiv_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","A Iesus ki hulenidia, “Ma beta miu na hazenia na poloka buk kana Paraha, kua e tani barae, ‘Na kedo kua na kapenta kamahi dia ta hada vetavetania, dia ka tania beta ni kulidia kirina, ti kara kedo kua dia te muga taruhia kete vatuharia na tempel. A Vuvu mule e katia goloa kua, ki mata muli matoto na matahita.’ ");
INSERT INTO wiv_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Kubarae, hau ka tania ni miu na kingdom ke Vuvu da e radua ni miu ki valanga na manumanu motu kua dia ta dangea dia kata katia haningana ni lohu na kingdom kua. ");
INSERT INTO wiv_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Azei kua tani dua kara huduna kedo kua, da e hutuhutu, kua na kedo kua ve ni dua kara kaka katiu, da e momomo matoto.” ");
INSERT INTO wiv_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Na hetpris kamahi, kamana tisa kamahi kara lo, dia ta longoria na barikikia na polea kua, dia ta lohoi lala habuka a Iesus e popole ni dia. ");
INSERT INTO wiv_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Pale, dia ta parakilania dia kata haba taduria. Palaka dia ta kuahinia na manumanu, na vuna, dia ta hadavia a Iesus dia ka tania ia na profet katiu. ");
INSERT INTO wiv_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","A Iesus ki barikikini mulehia polealea ni dia ki tani barae, ");
INSERT INTO wiv_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Na kingdom ke Vuvu ia e balika king katiu kua e katia hanihania kapou katiu na lahia ke tuna tamohane. ");
INSERT INTO wiv_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ia geria kana voravora dia kata kohania nuhu kua e kalohuanga ni dia, dia kata bele na hanihania kara lahia kua. Palaka nuhu kua dia ta hava dia kata bele na hanihania. ");
INSERT INTO wiv_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ia geri mulehia kana voravora taza ve ki tania ni dia, ‘Miu vano tania na nuhu kua ta kalohunidia dia kata lohu kara hanihania na vuna, te vaida haninga kava, na bulmakau tamomohane ia mai na bulmakau kamahi kua ta vanga kemikemihidia, dia ka buibuia, te hubi matehidia kene vaida kini malimu. Miu mai kara hanihania na lahia.’ ");
INSERT INTO wiv_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Palaka beta dia na longo murimuria koia kua, dia kene vavana, katiu kara hana vanua, katiu ti vano gala na kana bisnis, ");
INSERT INTO wiv_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","dia taza, dia ta haba taduria voravora kana king kua, dia ta kati zahatia ni dia, dia kene hubi matehidia. ");
INSERT INTO wiv_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Na king kua magalina ki varitihi matoto. Ia geria kana soldia kamahi dia ta vano vaihubi mate nuhu kua dia ta hubi matehia kana voravora kamahi. Dia ka tabenia ve kadia taon. ");
INSERT INTO wiv_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Pale, ia tania na kana voravora, ‘Na haninga kara lahia ti malimu kava, palaka nuhu ta vinohunidia, beta dia na hada zaheniau. ");
INSERT INTO wiv_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Kubarae, miu vano na hirihiripa dala kamahi, miu na kohania azei kena miu ta paria kete mai kara hanihania kara lahia.’ ");
INSERT INTO wiv_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Kana vora kamahi dia ta vano kara dala kotekote kamahi, dia ta kohania manumanu laveve kena dia ta paria, kaka kemi beu zaha, ia kohanga za; dia ta lohu, na ruma kini vonu na manumanu kua e kohanga dia ka lohu. ");
INSERT INTO wiv_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Palaka tania na king e mai ki hoho kete hadavia nuhu kua e vinohuanga dia kata lohulohu kara hanihania, ia hada paria na kaka katiu kua beta ni loholoho kara hanihania na lahia. ");
INSERT INTO wiv_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ia hulenia, ‘E ho, tu hoho ziha ri kua, beta nu loholoho kara hanihania na lahia?’ Pale, na kaka kua beta kana polea. ");
INSERT INTO wiv_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Na king ia tania na kana voravora, ‘Rotia limana, kabena miu na varaga gotalania kara poloka rodo, na palaka kena da e haloho hazena ki vuluhero.’” ");
INSERT INTO wiv_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","A Iesus ki tani barae, “Manumanu luba da e vinohuanga dia kata lohu, palaka da taza za e makua dia.” ");
INSERT INTO wiv_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Pale, a vuni Parisi dia ta vano, dia ta taru lupunia polea katiu kua dia kata pado rukia a Iesus vona, kete tani vetania polea katiu, dia kata koto kirina vona. ");
INSERT INTO wiv_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Dia ta geria kadia disaipel taza, kamana manumanu taza ke Herot, dia ta vano ni Iesus dia ka hulenia, “Tisa, hita ta lala habuka tu lala koto tani matotonia polea, ku lala koto vaketea matotoka polea ke Vuvu, ku lala koto vala polea katiu za na manumanu laveve, ia vata kua e paraha o kua beta hizana. ");
INSERT INTO wiv_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ko tania ni hita, ho tu lohoi ziha? Karae e mahoto kete kadoa na takis vano ni Sisar o betaka?” ");
INSERT INTO wiv_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Palaka a Iesus ia ti hada lala kadia vairukua, ia tania ni dia, “Miu ta nuhuta vairukua na lotua, kara zia miu ka paparakilaniau? ");
INSERT INTO wiv_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Miu vatunga ni niau moni kena miu ta lala miu kata kakadea takis vona.” Pale, dia ta vala moni katiu vona. ");
INSERT INTO wiv_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","A Iesus ki hulenidia, “Hanunuki zei na moni kua?” ");
INSERT INTO wiv_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Dia ka tania, “Ke Sisar.” A Iesus ki tania ni dia, “Pele miu vala ni Sisar nazia kua ke Sisar, vala ni Vuvu nazia kua e ke Vuvu.” ");
INSERT INTO wiv_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Kamana dia ka longoria polea kua, dia ta zipa zahe. Pale, dia ta vatia dia kene vano. ");
INSERT INTO wiv_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Kilaka kua ve, a vuni Sadyusi taza, nuhu kua dia ta tania manumanu mara beta ni lama mule na matea, dia ta mai ni Iesus kamana hulea katiu. ");
INSERT INTO wiv_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Dia ka hulenia, “Tisa, a Moses e tania ni hita kubarae ta tamohane ni mate ni beta tuna, tazina da e kabania gaburi tazina. Kua ni taruhia kapirupiru vona, ia kapirupiru kena ia ke tazina kua ti mate. ");
INSERT INTO wiv_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Varira na varitazini e 7. Tazidia muganga e lahi ia mate, ki beta tuna, ia vatia gona ni tazina. ");
INSERT INTO wiv_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Tazina muria ia mai ve kaka kua e muri lamani tazina muria, dia laveve varitazini 7 kua, dia ta kabania tavine kua, palaka beta dia na taruhia kapiru katiu vona. ");
INSERT INTO wiv_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Pale, na tavine kua ia ve e mate. ");
INSERT INTO wiv_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Kua tani ba muri, kua ta manumanu laveve dia na mahuri mule na matea, tavine kua, da ti kara goni zei matoto ni dia varitazini 7 kua?” ");
INSERT INTO wiv_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","A Iesus ki tania ni dia, “Kamiu polea beta ni mahoto na vuna beta miu na lala polea ke Vuvu kamana kana matuhanga. ");
INSERT INTO wiv_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Na dama kua manumanu dia te varimateai dia kata mahuri mule vona, da beta dia kata lahi o kete valahua dia, palaka da dia te habuka engel kamahi na lagato. ");
INSERT INTO wiv_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Kua na polealea na mahuri mulea na matea, beta miu na ridim nazia kua a Vuvu e tania ni miu, ");
INSERT INTO wiv_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","ia e tani barae, ‘Hau a Vuvu ke Abraham, a Vuvu ke Aisak, mai a Vuvu ke Jekop?’ A Vuvu, ia a Vuvu kana nuhu kua dia ta mahuri, beta ni Vuvu kana nuhu kua dia ta varimateai.” ");
INSERT INTO wiv_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Na kabuna manumanu dia ta longoria polea kua, dia ta ridi na kana rataratanga. ");
INSERT INTO wiv_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Tania a vuni Parisi dia ka hada baraenia habuka a Iesus ti dibala a vuni Sadyusi, dia ta lupu dia ta mai ni Iesus. ");
INSERT INTO wiv_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Katiu ni dia, e lala kemikemihia matoto na lo, e hulenia a Iesus na hulea kua kete parakilania, ");
INSERT INTO wiv_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Tisa, lo kakei ia e dopa ki kapou na lo laveve?” ");
INSERT INTO wiv_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","A Iesus ki tania vona, “Ho kete kuli matoto kara ka Paraha ka Vuvu, na poloko laveve, na vule laveve, kamana ka lohoihoia laveve. ");
INSERT INTO wiv_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ia za kua, ia na lo kua e dopa ki kapou na lo laveve. ");
INSERT INTO wiv_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Muri na lo kua, ia e habuka ve, Ho kete kuli matoto kara kaka kua e mia kozo ni niho, habuka kua e kukuli matoto kiriniho mule. ");
INSERT INTO wiv_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Lo rua kua, ia hiro ta vuvuna lo laveve kamana, vuvuna polea laveve kana profet kamahi.” ");
INSERT INTO wiv_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","A vuni Parisi dia ta ba lulupu, ia hulenidia, ");
INSERT INTO wiv_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Miu ta lohoi ziha ni Kristus? Ia na tuni zei?” Dia ta tania, “Na Tubuni Devit.” ");
INSERT INTO wiv_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ia ki hulenidia, “Pele e kuziha na Vule Tumonga ki vala na lohoihoia ni Devit ki kohania ia na ‘Paraha’? Na vuna a Devit ia e tani barae, ");
INSERT INTO wiv_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Na Paraha e tania na kagu Paraha, “Mia kiri maroroni limagu ki mule na dama kua Hau kata taruhia ha vagi kamahi na tauri kabe.” ’ ");
INSERT INTO wiv_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ta Devit ni kohania ia ‘Paraha,’ pele da a Kristus e kara tubuna ziha?” ");
INSERT INTO wiv_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Beta matoto katiu ni dangea kete kolia kana polea, na dama kena ki vano beta ve katiu ni lohoi murimuria kete hulenia na hulea katiu ve. ");
INSERT INTO wiv_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Pale, a Iesus ia tania na kabuna manumanu kamana kana disaipel kamahi, ");
INSERT INTO wiv_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Na tisa kamahi kara lo kamani vuni Parisi kamahi, dia ta pelea mudini Moses. Dia kata vaketehimiu na lo. ");
INSERT INTO wiv_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Kubarae, miu longo kiridia miu ka muri na nazia dia ta tania ni miu, palaka tabarae matoto miu na mumuri na kadia mogemoge kamahi, na vuna dia ta lala dia kata vala polea za, beta dia na lala dia kata mumuri na polea dia ta vavala. ");
INSERT INTO wiv_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Dia ta taza goloa kua e bize matoto dia ka valuga na lohora manumanu, palaka dia mule beta matoto ni kulidia dia kata vazahenia kukudia, dia na kodonidia dia kata luga pitu. ");
INSERT INTO wiv_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Dia ta kakatia goloa laveve kena kete hahadava dia vona. Miu hadavia na lete kua dia ta taza taduria na boks kote kua na dihudihura polea kana Paraha vona na damadia. Dia ta katia ki kapopou. Miu hadavia ve na piramuramuka kadia lavalava kamahi kua dia ta kakaria bakadia vona, dia ta katia ve ki malakulaku. ");
INSERT INTO wiv_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ki lala kete kukulidia kara mianga kena e taruha ke pararaha na palakangana hanihania kapopou kamana mianga kena e kemi matoto na poloka haus lotu kamahi ke vuni Iuda. ");
INSERT INTO wiv_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ki kulidia manumanu kete koi kemikemihidia na poloka maket kamahi, ki kulidia kete kohanga dia na, ‘Tisa.’ ");
INSERT INTO wiv_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Palaka beta kete kohanga miu na ‘Tisa.’ Na vuna miu laveve kua miu ta varitazini kua, kamiu tisa ia katiu papa za. ");
INSERT INTO wiv_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Tabarae, miu na kohania kaka katiu na garigari ni Tamamiu, na vuna Tamamiu katiu papa za, ia heta na lagato. ");
INSERT INTO wiv_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Tabarae ni kohanga ve miu na ‘Tubu,’ na vuna kamiu Tubu ia katiu papa za, a Kristus. ");
INSERT INTO wiv_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Azei na pidaka miu kua e paraha ni miu, ia kete kara kamiu vora. ");
INSERT INTO wiv_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Na vuna azei kua e vavazahezahenia, ia da a Vuvu e vazihonia, azei kua tani vavazihozihonia ia da a Vuvu e vazahenia. ");
INSERT INTO wiv_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","Kaba loho zahanga matoto ni miu, tisa kamahi kara lo kamani vuni Parisi, miu ta nuhuta vairukua na lotua! Miu ta taba porotia na kingdom ke Vuvu kara manumanu. Palaka miu mule beta ve miu na hoho vona, beta ve miu na vatia nuhu kua e kulidia dia kata hoho dia na hoho ve. ");
INSERT INTO wiv_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Miu lohoimiu, tisa kamahi kara lo kamani vuni Parisi, miu ta nuhuta vairukua na lotua! Miu ta sel na huduna dazi, miu ka vavana na garigari kara malala laveve miu kata pelea kaka miu na katia ni kara kamiu disaipel. Kua miu kene pokizia magalina kini kara kamiu disaipel, miu te katia kini ba dopa dangea kete hoho na hel habuka miu. ");
INSERT INTO wiv_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Miu lohoimiu, matamiu e keu, miu ka vavamuga na manumanu! Miu ta tani barae, kua kaka katiu ni mapamapa na tempel, ia beta kete tani matotonia polea kena, kua ni mapamapa na gol kua na tempel, ia da e kati matotonia nazia kena e mapamapa kete katia. ");
INSERT INTO wiv_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mata keukeu kamahi, miu ka longolongo ve! Nazia e dopa ki kapou, na gol o na tempel kua e katia na gol kena ki tumonga? ");
INSERT INTO wiv_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Miu ta tania ve kubarae, ‘Ta katiu ni mapamapa na altar, ia beta kete tani matotonia polea kena, palaka ta katiu ni mapamapa na nazia e taruha na altar ia da e kati matotonia nazia kua e mapamapa kete katia.’ ");
INSERT INTO wiv_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mata keukeu kamahi miu! Nazia ni hiro e dopa ki hizanga, na opa beu na altar kena e katia na opa ki tumonga? ");
INSERT INTO wiv_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","E kubarae ta katiu ni mapamapa na altar, ia e mapamapa ve na goloa laveve kena na huduna altar. ");
INSERT INTO wiv_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Azei kua tani mapamapa na tempel, ia e mapamapa vona, mai ve ni Vuvu kena e mimia na poloka tempel. ");
INSERT INTO wiv_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Azei kena e mapamapa na lagato, ia e mapamapa na sia king ke Vuvu ia mai na kaka kena e mimia na huduna. ");
INSERT INTO wiv_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Miu lohoimiu, tisa kamahi kara lo kamani vuni Parisi, miu ta nuhuta vairukua na lotua! Miu ta lala miu kata taru kakava taits na goloa laveve. Goloa kotekote kua habuka bilingare, malapi, lobo, ia miu ta taru kakava ve. Palaka miu te hada vanonia na goloa kua e dopa ki kapou na poloka lo ke Vuvu. Moge kua e mahoto, mahariharia na kaka, makina tani matotoa na polea. Goloaloa kua ia miu kata kakatia, miu ka paho poto ve na mogemoge taza ve kena kamana. ");
INSERT INTO wiv_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Matamiu e keu, miu ka vavamuga na manumanu! Miu ta lala miu kata hada papa na poloka hamiu sup, miu ka pele kakava na niki kua na poloka hamiu sup. Palaka beta miu na lala miu kata hada vutuhia na kamel kua na poloka sup, miu ka lala miu kata totodokula. ");
INSERT INTO wiv_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Miu lohoimiu, tisa kamahi kara lo kamani vuni Parisi, miu ta nuhuta vairukua na lotua! Miu ta vavazuguvia na hatamara kamiu kap kamana plet, palaka na poloka e vonu na makina vanahoa, kamana makina mata kukua. ");
INSERT INTO wiv_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Matamiu e keu miu vuni Parisi kamahi! Muga miu ka vazuguvia na poloka kap kamana dis, hatamara ve kete puzopuzoa. ");
INSERT INTO wiv_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Miu lohoimiu, miu tisa kamahi kara lo kamani vuni Parisi, miu ta nuhuta vairukua na lotua! Miu ta balika simen na matmat kua e peneanga ki kavukavua, kena e hada papa na hatamara palaka, na poloka e vonu na togana kaka mate kamana goloa laveve kena e molumolua. ");
INSERT INTO wiv_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ia miu ve ta kubarae ve, manumanu dia ta hadavia livuhamiu, dia ka tania miu ta manumanu kemikemi, palaka na polokomiu e vonu na makina vairukua kamana moge zahazaha. ");
INSERT INTO wiv_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Miu lohoimiu, tisa kamahi kara lo kamani vuni Parisi, miu ta nuhuta vairukua na lotua! Miu ta habatia na matmat kana profet kamahi, miu ka vabilasnia na matmat kana nuhu kua dia ta mahoto na matani Vuvu, ");
INSERT INTO wiv_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","miu ka tani barae ve, ‘Hita na paria na tau ke habu tubuhita, mara beta hita na kamadia hita na vaihubi mate na profet kamahi.’ ");
INSERT INTO wiv_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Na kamiu polea mule ti koto kirimiu mule, na vuna miu te tania habuka miu na habu tutuna nuhu kua dia ta vaihubi mate na profet kamahi. ");
INSERT INTO wiv_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Miu ma kakatia, miu na vahozovia nazia kua habu tubumiu e varivuvunia! ");
INSERT INTO wiv_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Matabunu kamahi! Miu ta habu tutuna matabunu! Miu ta lohoia da miu ta hava hutuzia na kotoa kua kete varaganga miu kara hel? ");
INSERT INTO wiv_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Kubarae hau da ta geria na profet kamahi, kamana nuhu kua kadia lohoihoia e kemi kamana tisa kamahi. Taza da miu ta hubi matehidia miu ka nilinidia na kruse; taza da miu ta vaivihi kamadia na poloka kamiu haus lotu kamahi, miu ka vaikali kamadia na taon kamahi. ");
INSERT INTO wiv_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Kubarae a Vuvu da e vala bizea kapou matoto ni miu, taraka manumanu kua e hubu mato vetanga dia varira. Varivuvu na kaka mahoto kua a Abel ki mai ni Sekaraia tuni Berekia, kaka kua miu ta hubi matehi vetania na pidaka rumaka tempel kamana altar. ");
INSERT INTO wiv_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Hau ta tani matotonia ni miu, a Vuvu da e kati zahati matotonia ni miu taraka goloa kua habu tubumiu e katia varira. ");
INSERT INTO wiv_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","O Ierusalem! Ierusalem! Ho tu vaihubi mate na profet kamahi ku lubi mate nuhu kua e geura dia kata mai ni niho. Boto luba te parakilania kata vai lupunia habu tutu dia na mai lupu, habuka toha kua e raragomia habu tutuna na tauri banita, palaka ho beta matoto za ni kuli. ");
INSERT INTO wiv_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Hadavia! A Vuvu ti vatia ka ruma, kini beta kaka na poloka. ");
INSERT INTO wiv_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Kubarae hau ka tania ni niho, mara beta nu hada mulehiau ki mule na dama kua ku tani barae, ‘A Vuvu e kati kemihia matoto na kaka kua e mamai na hizana Paraha.’” ");
INSERT INTO wiv_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","A Iesus ti vatia na tempel kini vavana vano, na kana disaipel kamahi dia ta mai vona dia ta vatunga na ruma kamahi na tempel vona. ");
INSERT INTO wiv_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","A Iesus ki tania ni dia, “Miu ta hada na goloa laveve kua? Hau ta tani matotonia ni miu, da beta kedo katiu kete vatua ni ngoro langalanga ni ruana, kedo laveve kuari, da e varaga tadura.” ");
INSERT INTO wiv_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","A Iesus e mimia na potuna ni Oliv, na kana disaipel kamahi dia ta mai vona. Dia ka tania, “Tania ni hita. Da ngiza matoto goloa kua ki bele, da hita ta hada mak zia kua kete vatunga ka vamulea kamana las de?” ");
INSERT INTO wiv_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","A Iesus ki tania ni dia, “Miu lohoia tabarae kaka katiu ni rukimiu. ");
INSERT INTO wiv_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Na vuna manumanu luba da dia ta mai kamana hizagu, dia ka tania, ‘Hau a Kristus,’ da dia ta rukia manumanu luba. ");
INSERT INTO wiv_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Da miu ta longoria polealea na varihubia kapopou mai ve kavilika polealea na varihubia kapopou, palaka miu hadavia tabarae miu na lohoi toritori. Goloaloa mata barae da e bele, palaka beta ni habuka las de ti mai. ");
INSERT INTO wiv_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Na vuna na kantri kamahi da dia ta varihubi kamana kantri motu, kingdom kamahi da dia ta varihubi kamana kingdom motu. Da vitolo kapou lohu, vuruhe da e bele na malala kamahi. ");
INSERT INTO wiv_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Goloa laveve kua ia e balika na varitihia kua na tavine e muga ki hahatunia ba muri kini valohia kapiru. ");
INSERT INTO wiv_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Pale, miu da ti paho tadura miu kini valanga miu kete kati zahata ni miu, ni hubu matoa miu, kantri laveve da dia ta zaha kirimiu na vuna ni niau. ");
INSERT INTO wiv_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Pale, manumanu luba da dia ta vatia kadia bilip dia ta varihavai, dia ta tilitili tika kiri ruadia, dia ka varizahati, ");
INSERT INTO wiv_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Na profet vairukuruku luba da dia ta mai dia ka rukia manumanu luba. ");
INSERT INTO wiv_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Na vuna moge zahazaha da ti bele kini kapou, manumanu luba da dia te vatia mogepa kemia kara kaka. ");
INSERT INTO wiv_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Palaka ho azei kua tanu madi matuha ki mule na las de, ia da tu mahuri. ");
INSERT INTO wiv_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Na kalohua kemi kua, na vuna na kingdom ke Vuvu, da e vaketoa na poloka malala laveve na garigari manumanu laveve dia kata lala, ba muri las de ia ti bele. ");
INSERT INTO wiv_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Pale, ta miu na hadavia na goloa mata hilehilea matoto kua a profet Daniel e popole vona varira, kua da e katia na tempel ki molumolua, da ti mamadi na palaka tumonga na poloka tempel. Na kaka kua e hahazenia polea kua, ia kete lohoi lala. ");
INSERT INTO wiv_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Nuhu kua dia ta lololi ni Iudea dia kata varihavai kara potuna kamahi. ");
INSERT INTO wiv_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Kua kaka katiu kini mimia na kana huduna ruma, tabarae ni zipa mule kete pelea goloa katiu na kana poloka ruma. ");
INSERT INTO wiv_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Azei kua na hana vanua, tabarae ni lohoia kete vamule kara kana siot na ruma. ");
INSERT INTO wiv_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Da dama kua da e zaha, zaha matoto kiri tavivine kovekove kamani tavivine kua dia ta ba vavazuzu! ");
INSERT INTO wiv_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Miu lotu ni Vuvu habuka na dama kua kete beta kete bele na havara o na Sabat. ");
INSERT INTO wiv_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Na dama kua, da bizea kapou matoto e bele. Na varivuvuka kua na garigari ba vahoru ki mai ki mule meni, beta bizea katiu kua mata barae ni bele. Muri ve da beta ve bizea katiu kua kete dopa livutia kua kete bele. ");
INSERT INTO wiv_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Palaka a Vuvu ti pele kakava dama taza na dama kamahi na bizea kua; kua ni beta ni kubaraenia, mara beta kaka katiu ni mahuri. Na vuna e lohoi na kana manumanu kua e makidia kana, a Vuvu kini pele kakava dama taza. ");
INSERT INTO wiv_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Na dama kamahi kena kua kaka katiu ni tania ni miu, ‘Hadavia a Kristus kua!’ beu ni tania, ‘Kuari ia kuari!’ taua miu na bilip. ");
INSERT INTO wiv_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","A Kristus vairukuruku kamana profet vairukuruku kamahi da dia ta lohu, dia ka katia mirakel kapopou kamana goloa kua ma beta miu na hada muga, dia kata katia manumanu ni beta dia kata ma bilip ni niau, kua ni nap da dia ta rukia ve nuhu kua a Vuvu ti makidia kana. ");
INSERT INTO wiv_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Miu Longoria! Hau kava te muga tani kakava ni miu nazia kua kete bele. ");
INSERT INTO wiv_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ta katiu ni tania ni miu, ‘Kuari ia kuari na poloka deset,’ taua miu vano, beu ni tania, ‘Hadavia, kua ia kua e paparitigi ri.’ Taua miu na bilip ni dia. ");
INSERT INTO wiv_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Na vuna na Tuna Kaka da e bele balika zila, kua e hanimata ki balanga doluria mariaba laveve, ki pe na voro zahe ki ziho kara palaka voro e zuzugu vona. ");
INSERT INTO wiv_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Kua na Tuna Kaka ni bele, da manumanu laveve dia ta hadavia. Balika kua na podana goloa mate katiu ni ngongoro ni huhubi, ia da tolu ta hada lala vona kua na kokoa kamahi dia te totoro lobia. ");
INSERT INTO wiv_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Muri za na dama zaha ti hozo, a Vuvu da e katia na voro ki beta kete ma titiba, na lingabo ki beta kete tiba ve, na vitovito kamahi da dia ta huru na mariaba. Goloaloa matuha na lagato kamahi da dia ta varihunuai. ");
INSERT INTO wiv_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Pale, na mak kana Tuna Kaka da e bele na poloka mariaba, manumanu laveve na garigari da dia ta varihalohoai, kua dia te hada na Tuna Kaka ti pe na mariaba kini ziziho, kamana glori kapou. ");
INSERT INTO wiv_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Da e geria kana engel kamahi dia ka vilinia tavure kapou matoto, dia ka vano kara palaka laveve na garigari dia ka vai lupunia kana manumanu kua ia ti makidia kava na paligena vulovulo ki vano na paligena. ");
INSERT INTO wiv_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Miu pelea na lohoihoia na haina fik. Ta dangana ni pizuzu ni taruhia raurauna, ia da miu te lala na tau kara voro ia ti kozoho. ");
INSERT INTO wiv_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ki vano ve ta miu na hada goloaloa laveve kua, ia da miu te lala na taem ti kozoho, kozoho matoto na hatama. ");
INSERT INTO wiv_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Hau ta tani matotonia ni miu, manumanu laveve bukuna tauna kua mara beta dia na varimateai laveve goloaloa kua ki bele. ");
INSERT INTO wiv_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Lagato kamana garigari da vano ki kakava, palaka kagu polea mara beta matoto ni kakava. ");
INSERT INTO wiv_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Beta matoto katiu ni lala na dama beu na aua kua goloaloa kua kete bele vona, na engel kamahi na lagato o Tuna beta ve ni lala, palaka a Tamagu za ia e lala. ");
INSERT INTO wiv_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Na belea kana Tuna Kaka da bele balika za nazia kua e bele na tau ke Noa. ");
INSERT INTO wiv_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Na dama kamahi kua muga na naru kete pado, manumanu da dia ta hanihani dia ka hihinu, dia ka varikabai, ki mule matoto na dama kena a Noa e hoho na kana vaga, ");
INSERT INTO wiv_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ki beta dia na lala terea nazia kua kete bele. Dia te ridi za na loka ti mai za ia pado katidia laveve. Ia da e bele barae na dama kua na Tuna Kaka kete bele vona. ");
INSERT INTO wiv_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Kaka rua da hiro na hahiro poloka vanua. Katiu da e peloa, ruana da e vatua. ");
INSERT INTO wiv_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Tavine rua da hiro ta kakatia palaua kara bret. Katiu da e peloa, ruana da e vatua. ");
INSERT INTO wiv_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Kubarae ka tania. Miu tatare, na vuna beta miu na lala na dama kakei kamiu Paraha kete mai vona. ");
INSERT INTO wiv_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Palaka miu lohoi lala kua, kua na tauana ruma ni lala matotonia taem zia na marigo na mata vanaho kete mai vona, da e ma ki lalama ki mara beta ni vatia na mata vanaho kua ni hutu valahia kana ruma ni hoho. ");
INSERT INTO wiv_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ia miu ve miu tatare, na vuna beta miu na lala aua kakei matoto na Tuna Kaka kete mai vona. ");
INSERT INTO wiv_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Azei matoto ia na vora kemi kua kana lohoihoia e mahoto? Vora kemi, ia azei kua kana tubu e taruhia ki hada na kana voravora laveve na kana ruma, kete vala hadia haninga na taem matoto. ");
INSERT INTO wiv_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Vora kua da e hilohilo matoto kua kana tubu ni vamule ni paria e kakati kemikemihia kana galanga. ");
INSERT INTO wiv_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Hau ta tani matotonia ni miu, da e taruhia ki hada na kana goloaloa laveve. ");
INSERT INTO wiv_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Palaka ta na vora kua ni beta ni gala papa ni tani barae, ‘Kagu tubu da mara beta ni vamule tapu.’ ");
INSERT INTO wiv_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Pale, ia kini vavaihubi habu tamaninika kini hahanihani ki hihinu kamana nuhuta hinu hamohamoa. ");
INSERT INTO wiv_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Na tubu kana vora kua da e mai na dama katiu kua kana vora e lohoia ki tania da beta kete lohu vona. ");
INSERT INTO wiv_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Kana tubu da e le hutuzia ki momomo ki taruhia na palaka kana nuhuta mata vairukurukua na lotua. Na palaka kena da e haloho hazena ki vuluhero. ");
INSERT INTO wiv_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Na taem kena na kingdom ke Vuvu da e balika tizula e 10, kua dia ta pelea kadia lam dia ka vano dia kata guria tamohane kua e ba lahi vahoru. ");
INSERT INTO wiv_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Dia lima beta dia na lohoi ketekete. Dia lima dia ta lohoi papa. ");
INSERT INTO wiv_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Dia lima kua beta dia na lohoi ketekete dia ta pelea kadia lam palaka beta dia na pelea kadia makolika vel kamadia. ");
INSERT INTO wiv_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Dia lima kua dia ta lohoi papa, dia ta pelea kadia vel na poloka botole kamana kadia lam. ");
INSERT INTO wiv_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Na tamohane kua e ba lahi, beta ni mai tapu. Kubarae tavivine laveve kua, matadia ti tuturuve dia kene varingoroai. ");
INSERT INTO wiv_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ti varivalavala kaka katiu e goe ki tania, ‘Tamohane kua e ba lahi ti mai! Miu mai gotala miu na hadavia!’ ");
INSERT INTO wiv_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Pale, na tizula kamahi kua dia ta lama vaihidahida kadia lam, dia ta dohodoho. ");
INSERT INTO wiv_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Nuhu kua beta dia na lohoi ketekete dia ta hulenia na nuhu kua dia ta lohoi papa, ‘Miu vala kamiu vel pitu ni hita kahita lam keteni varimateai.’ ");
INSERT INTO wiv_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Palaka na nuhu kua dia ta lohoi ketekete dia ka tania, ‘Tauka, da beta kete dangedolu laveve. Miu vano kara stoa miu na kadea kamiu.’ ");
INSERT INTO wiv_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Dia ta ba vavana dia ka vavano dia kata kadea vel, na kaka kua e ba lahi vahoru ti lohu. Dia tizula kua dia ta lohoi ketekete, dia te kamana dia kene hoho kara hanihania kapou kara lahia. Pale, na doa ia taba havuta. ");
INSERT INTO wiv_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Pale, dia tizula kamahi kua dia ta muri mai lohu, dia ka koi dia ka tani barae, ‘Paraha, Paraha, vukazia doa kirihita.’ ");
INSERT INTO wiv_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Palaka ia ki tania ni dia, ‘Mara beta matoto, hau beta na lala miu.’ ");
INSERT INTO wiv_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Kubarae miu mia miu ka tatare, na vuna beta miu na lala na dama o na aua. ");
INSERT INTO wiv_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Mai ve, na kingdom ke Vuvu ia e balika kua na kaka katiu kua kete vavana zau, ia kohania kana voravora ia vala kana goloaloa ni dia; ");
INSERT INTO wiv_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Na katiu e vala 5,000 kina, ni ruana e vala 2,000 kina na toluna e vala 1,000 kina. E vala moni kua, muri na kadia save katiukatiu. Pale, ia vatidia. ");
INSERT INTO wiv_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Na kaka kua e pelea 5,000 kina e vano ki gala bisnis na moni kua, ia pelea 5,000 kina profit ve na huduna. ");
INSERT INTO wiv_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Kaka kua e valanga 2,000 kina vona ia ve e gala bisnis na moni ia katia ve 2,000 kina ve profit na huduna. ");
INSERT INTO wiv_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Palaka na kaka kua e valanga 1,000 kina vona, e vano ia hovia na garigari ia tavunia moni kana, kana tubu vona. ");
INSERT INTO wiv_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Havarau matoto, kadia tubu ia vamule ia huleni mulehia voravora kamahi kua dia kata vala ripot na moni e vala ni dia. ");
INSERT INTO wiv_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Kaka kua e pelea 5,000 kina e pelea ve 5,000 kina profit na huduna ve. Ki tania, ‘Tubu, ho tu vala 5,000 kina. Hadavia, hau te katia 5,000 kina profit ve na huduna.’ ");
INSERT INTO wiv_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Kana tubu ki tania, ‘Kemi matoto, kagu vora kemi ho! Tu hada poto papa ku gala kemikemi na goloa pitu kua e valanga ni niho, da ta taruhiho ku hada na goloa luba. Mai hoho nu mia papa nu hilohilo kamana ka tubu.’ ");
INSERT INTO wiv_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Kaka kua e valanga 2,000 kina vona e mai ve ki tania, ‘Tubu, tu vala 2,000 kina. Hadavia, hau te katia 2,000 kina ve na huduna.’ ");
INSERT INTO wiv_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Kana tubu ki tania, ‘Kemi matoto, kagu vora kemi ho! Tu hada poto papa ku gala kemikemi na goloa pitu kua e valanga ni niho, da ta taruhiho ku hada na goloa luba; mai hoho nu mia papa nu hilohilo kamana ka tubu.’ ");
INSERT INTO wiv_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Pale, na kaka kua e valanga 1,000 kina vona ia ve mai ki tania, ‘Tubu, hau ta lala ho tu mata magali varititihi, tu lala koto vurutia haninga na palaka kua beta nu vazo vona, ku lala koto pelea ve haninga na palaka kua beta nu muratania haninga vona. ");
INSERT INTO wiv_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Kubarae hau ka kuahi, hau ta vano tavunia ka moni na garigari. Ia, pele mulehia ka moni.’ ");
INSERT INTO wiv_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Palaka kana tubu ki tani barae vona, ‘Ho tu vora zaha matoto ku toga mate! Ho tu lala habuka ta lala kata vurutia haninga na palaka kua beta na vazo vona, ka lala ve kata nihabunia ve haninga na palaka kua beta na muratania haninga vona. ");
INSERT INTO wiv_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Pele, ma kava koto nu taruhia kagu moni na benk, kua na vamule hau te pele mulehia kagu moni kamana interes. ");
INSERT INTO wiv_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Miu pelea 1,000 kina kena vona miu na vala na kaka kena kana 10,000 kina vona. ");
INSERT INTO wiv_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Na vuna manumanu laveve kena kadia goloa vona da luba ve e valanga ni dia, kadia goloaloa kini ba dopa luba matoto, palaka kaka kua tani beta matoto kana goloa, kena pitu papa matoto kena vona, ia da e pele kakavanga ve vona. ");
INSERT INTO wiv_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Kua, miu varaga gotalania vora kua beta matoto kana galanga kua kara rodo, kara palaka kua kete hahaloho hazena ni vuvuluhero vona.’ ");
INSERT INTO wiv_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ta Tuna Kaka ni mai kamana kana glori, kamana engel laveve, da e mia na kana sia king na poloka kana glori. ");
INSERT INTO wiv_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Manumanu laveve bukuna kantri laveve da dia ta mai lupu na matana. Pale, da ia ti pahi valahidia ia katia kabuna manumanu rua habuka kakanaka hada potopotoa na sipsip kua e lala kete pahi valahia kabuna sipsip na kabuna me kamahi. ");
INSERT INTO wiv_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Da e taruhia na sipsip kamahi kiri marorona, na me kamahi kiri maurina. ");
INSERT INTO wiv_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Pale na King da ti tania kara nuhu kiri marorona, ‘Miu mai, a Tamagu ti kati kemihia matoto ni miu, miu pelea kamiu na kingdom kua ti vaidanga kamiu varira za, ba muri a Vuvu kini katia vulovulo. ");
INSERT INTO wiv_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Na vuna, kilangata kua e vitoloniau ho tu vala haninga ka hania, e marahotiau ho tu vala naru ka hinumia. Hau ta mata vahorua, palaka ho tu koi taduriau kara ka ruma, ");
INSERT INTO wiv_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","beta loholohoa na livuhagu ku valohoriau, e mazahitiau ho tu hada poto ni niau, hau na poloka karabus ho tu mai balaheau. ");
INSERT INTO wiv_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Nuhu kua dia ta mahoto na matani Vuvu da dia te hule, Paraha, ngiza matoto kua hita ta hada e vitoloniho hita ka vanganiho, o kua e marahotiho hita ka vala naru ku hinumia? ");
INSERT INTO wiv_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ngiza ve kua hita ta hada kua tu mata vahorua hita ka koi taduriho, o kua beta matoto loholohoa na livuha hita ka valohoriho? ");
INSERT INTO wiv_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ngiza matoto kua hita ta hada kua e mazahitiho, beu kua ho na karabus hita ka vano balaheho?’ ");
INSERT INTO wiv_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Na King da e kolia ki tania, ‘Hau ta tani matotonia ni miu, nazia kua tu katia na kagu kaka katiu kua beta matoto ni hada zaheanga, ia tu katia ni niau.’ ");
INSERT INTO wiv_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Pale, da ia e tania kara nuhu kua kiri maurina, ‘Miu kakava ni niau, miu nuhu kua miu te paria zahatanga ke Vuvu, miu vano kara poloka haroho kua e vaidanga ke satan kamana kana engel kamahi! ");
INSERT INTO wiv_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Na vuna e vitoloniau ki beta miu na vala haninga katiu kata hania, e marahotiau ki beta miu na vala naru kata hinumia. ");
INSERT INTO wiv_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ta mata vahorua na ka malala ki beta nu koi taduriau kara ka ruma, beta matoto loholohoa na livuhagu ki beta nu valohoriau, e mazahitiau, ta mia na poloka karabus beta nu balaheau.’ ");
INSERT INTO wiv_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Da dia ve ta kolia dia ka hule, ‘Paraha, ngiza matoto hita ta hadavia e vitoloniho o marahotiho o tu mata vahorua o beta ka zohozohoa o mazahitiho, beu ho na poloka karabus ki beta hita na kodoniho?’ ");
INSERT INTO wiv_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Na King ki tania ni dia, ‘Hau ta tani matotonia ni miu, nazia kena beta nu katia koto kodonia kaka katiu kua beta matoto ni hizanga, ia tu katia ve niau.’ ");
INSERT INTO wiv_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Pale, nuhu kua, da dia te vano dia kene pelea kadoadia, kadoadia ia na zahatanga roroa, palaka nuhu kua dia ta mahoto matoto na matani Vuvu, ia da dia ta pelea mahuri roroa.” ");
INSERT INTO wiv_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Kamana a Iesus ki tani hozovia polea laveve kua, ia tania na kana disaipel kamahi, ");
INSERT INTO wiv_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Miu ta lala habuka, dama rua ba vovona kara hanihania kapou kara Pasova, na Tuna Kaka da ti valanga na limana hana vagi kamahi dia ka havenia na kruse.” ");
INSERT INTO wiv_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Pale, na hetpris kamahi kamana pararaha kamahi ke vuni Iuda dia ta lupu na ruma kapou kana paraha kana hetpris kamahi, hizana a Kaiafas. ");
INSERT INTO wiv_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Dia ka taru lupunia polea habuka dia kata paho taduria a Iesus, dia na hubi matehia, beta manumanu kete lala. ");
INSERT INTO wiv_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Palaka dia ka tania, “Beta tolu kata katia goloa kua na damana lotua kapou. Tabarae manumanu dia na hada magalidia ni varitihi dia na katia varihubia kapou.” ");
INSERT INTO wiv_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","A Iesus ia ni Betani na poloka ruma ke Saimon, kaka kua muga lepra vona, ");
INSERT INTO wiv_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","na tavine katiu e mai kamana Alabasta botole katiu na pefium na poloka. Pefium kua monina e kapou matoto, ia valikiria kara bakani Iesus. Kilaka kua a Iesus e mimia na tebol. ");
INSERT INTO wiv_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Kana disaipel kamahi dia ka hadavia goloa kua magalidia ki varitihi kirina, dia ka tania, “E kuziha ki paralegenia? ");
INSERT INTO wiv_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Na pefium kua ma e salianga kara moni kapou matoto kua, monina ia valanga na nuhu kua beta matoto kadia goloaloa vona.” ");
INSERT INTO wiv_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Palaka a Iesus e lala nazia kua dia ta tatania, kubarae ia tani barae ni dia, “E kuziha miu ka pole tori kara tavine kena? Ia ti katia goloa mata muli katiu ni niau kua. ");
INSERT INTO wiv_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Nuhu kua beta matoto kadia goloaloa vona da dia ta ma mimia kamamiu, palaka hau mara beta na ma mimia kamamiu. ");
INSERT INTO wiv_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ia e valikiria na pefium kua kara livuhagu, kete vaidau kete tavuanga hau. ");
INSERT INTO wiv_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Hau ta tani matotonia ni miu, na palaka laveve kua na garigari, kua manumanu dia ta vavana dia ka vala polea na Kalohua Kemi, ia da dia ta tania ve goloa kua tavine kua e katia, manumanu dia kata lohoia tavine kua na nazia kua ia e katia.” ");
INSERT INTO wiv_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Pale, katiu ni dia na 12 disaipel kamahi, kaka kua e kohanga ni Iudas Iskariot, ia vano na hetpris kamahi, ");
INSERT INTO wiv_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ia hulenidia, “Nazia da miu ta vala ni niau kua ta na vala a Iesus na limamiu?” Pale, dia ta hazenia moni silva e 30, dia ta vala vona. ");
INSERT INTO wiv_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Na dama kena ki vano a Iudas ia ti ma kini hahada dala katiu kua kete volo papa vona, ni vala a Iesus na limadia. ");
INSERT INTO wiv_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Na dama matoto kua na damana hanihania kapou kua kete lohoua na Bret Beta Yis vona, kana disaipel kamahi dia ta mai ni Iesus dia ta hule, “Kuli hita kata vaida hadolu haninga tolu kata hanihani na Pasova ni ve?” ");
INSERT INTO wiv_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ia tania ni dia, “Miu vano hoho na poloka taon kara ruma ke goloa, miu ta tania vona, ‘Na tisa e tania, kana dama e makua ti kozoho. Kata makia dama kua na hanihania kapou kua kara Pasova kamana kagu disaipel kamahi na ka ruma.’” ");
INSERT INTO wiv_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Kana disaipel kamahi dia ta kati muria nazia kua a Iesus e tania ni dia, dia kene vaida haninga kara hanihania kapou na Pasova. ");
INSERT INTO wiv_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ti garavi a Iesus ia mia kamana kana disaipel kamahi na tebol. ");
INSERT INTO wiv_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Dia ta loli dia ka hahanihani barae a Iesus ia tania, “Hau ta tani matotonia ni miu, katiu ni miu da e valau na limana hagu vagi kamahi.” ");
INSERT INTO wiv_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Lohorodia e zaha matoto, kubarae katiu, katiu ni dia ki hule baraenia, “Da hau, ai Paraha?” ");
INSERT INTO wiv_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","A Iesus ki tania ni dia, “Kaka kua e lutia hana bret na poloka dis kamaniau ia da e valau na limana hagu vagi kamahi. ");
INSERT INTO wiv_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Tuna Kaka da e ma ki muri za na nazia e vapolunganga ki popole voa vona. Palaka kaba loho zahanga matoto na kaka kua e vala na Tuna Kaka na limana hana vagi kamahi! E dopa ki kemi kua muga za ni beta ni valohua ia.” ");
INSERT INTO wiv_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Pale, a Iudas, kaka kua kete vala a Iesus na limana hana vagi kamahi, ia hule, “Da hau, ai tisa?” A Iesus ki tania vona, “E, ia ho za.” ");
INSERT INTO wiv_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Dia ta hanihani vano, a Iesus ia pelea bret, ia hate motunia a Vuvu ia bara vulahia, ia vala na kana disaipel kamahi, ki tani barae, “Miu pelea miu na hania; ia kua na livuhagu.” ");
INSERT INTO wiv_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Muri ia pelea kap, ia hate motunia a Vuvu ia vala ni dia, ki tani barae, “Miu hinumia, miu laveve. ");
INSERT INTO wiv_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Kua ia na topogu kara kontrak, kua a Vuvu ti katia kamana kana manumanu. Topogu kua da e valikira, a Vuvu kete lohoi bala manaunaua kamahi. ");
INSERT INTO wiv_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Hau ta tania ni miu, da mara beta ve na hinumia ve vaen ia ki mule na dama kena kata hinu mulehia vaen vahoru kamamiu na kingdom ke Tamagu.” ");
INSERT INTO wiv_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Pale, dia ta habia linge katiu dia kene vano kara potuna a Oliv. ");
INSERT INTO wiv_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","A Iesus ia tani barae ni dia, “Na marigo kua meni da miu laveve miu ta varihavai miu ka hava tapuniau, na vuna e vapolu baraenga na Buk kana Paraha ki tani barae, ‘Hau da ta hubi matehia kakanaka hada potopotoa na sipsip, na sipsip kamahi dia ka zidi barara vetaveta.’ ");
INSERT INTO wiv_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Palaka muri te mahuri mule na matea, da ta vamuga ni miu ka vano kiri Galili.” ");
INSERT INTO wiv_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Palaka a Pita ki tani barae, “Ia vata, kua ta dia laveve dia na varihavai ni niho, hau da mara beta.” ");
INSERT INTO wiv_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","A Iesus ki tania vona, “Hau ta tani matotonia ni niho, meni na marigo kua, ba muri toha kini kakareko, da tu linga botona tolu ku tania beta nu lalau.” ");
INSERT INTO wiv_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Palaka a Pita e tani barae, “Ia vata kua ta dia na tania dia kata hubi matehiau kamaniho, ia mara beta na linga na tania beta na lalaho.” Na disaipel laveve dia ta tani barae laveve. ");
INSERT INTO wiv_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Pale, a Iesus ia vavana kamana kana disaipel kamahi dia ta vano kara palaka katiu kohanga ni Getsemani. Ia tani barae ni dia, “Miu mia ri kua, hau ka vano rae kuari ka lotu.” ");
INSERT INTO wiv_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","E kohania a Pita kamani tuni Sebedi karua dia ka kamana, pale, ia e hatunia habuka na poloka e zobo ki lohoi vuvu matoto. ");
INSERT INTO wiv_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ia mai tania ni dia, “Na vulegu ta hatunia bizea kapou matoto ka hatunia tania katane mate. Miu guru ri kua miu ka ma hahada kamaniau.” ");
INSERT INTO wiv_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","E pe vano zau pitu, ia dua kara garigari ki taruhia damana kara garigari ki lotu ki tani barae, “Tamagu, kua ni kuli, pele kakava kap na bizea kapou kua ni niau! Palaka beta koto muri na kagu lohoihoia, muri na ka lohoihoia mule.” ");
INSERT INTO wiv_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","A Iesus ia vamule vano na kana disaipel kamahi, ia paridia, dia ta ngongoro, ia hulenia a Pita, “E kuziha ki mara beta miu na hada ni aua katiu kamaniau? ");
INSERT INTO wiv_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Miu hada miu na lotu kete beta miu kata poke na parakilakilanga; na vulemiu e kulina kete katia nazia kua a Vuvu e kulina kirina, palaka livuhamiu e beta ni bada miu kata katia.” ");
INSERT INTO wiv_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ia vamule vano boto ruana ve ki lotu ki tani barae, “Tamagu, kua kini mara beta za nu pele kakava na kap kua kara bizea kapou ni niau, kini kuli kata hinumia za, pele muri na ka lohoihoia.” ");
INSERT INTO wiv_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","E vamule mai, ia pari mulehidia ve dia ta ngongoro, na vuna matadia e tuturuve matoto. ");
INSERT INTO wiv_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Kubarae ia vati mulehidia kini vamule vano boto toluna kete lotu, ki tatani mulehia polea muga e tatania. ");
INSERT INTO wiv_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Pale, ia vamule vano na kana disaipel kamahi ki tania kiridia, “Miu ta ba ngongoro miu ka ba hihivu za? Miu hadavia, na aua ti kozoho kava, na Tuna Kaka keteni valanga na limana nuhuta moge zahazaha kamahi. ");
INSERT INTO wiv_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Madi, tolu kata vano! Hadavia kaka kete valau kena ti mai!” ");
INSERT INTO wiv_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","A Iesus e ba popole barae, a Iudas, katiu na kana 12 disaipel kamahi ti bele. Kabuna manumanu kapou matoto dia ta kamana dia ka mai, dia ta pahopaho bainat kamana pakole. Na hetpris kamahi kamana pararaha ke vuni Iuda dia ta geridia, dia ka maimai. ");
INSERT INTO wiv_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Na kaka kua kete vala a Iesus, ia kava ti tania ni dia nazia kete katia. E tani barae ni dia, “Kaka kena hau ta domia ia, ia kena; miu haba taduria.” ");
INSERT INTO wiv_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","A Iudas ia vana mahoto kiri Iesus, ki tania, “Magali kemia ni niho, tisa!” pale, ia domia. ");
INSERT INTO wiv_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","A Iesus ki kolia vona ki tania, “E ho, katia nazia tu mai koto katia.” Pale, manumanu kua dia ta paho taduria a Iesus. ");
INSERT INTO wiv_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Na disaipel ke Iesus katiu e dae gotalania kana bainat, ia bazi hutuzia na talingana vora katiu kana paraha kana hetpris kamahi. ");
INSERT INTO wiv_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","A Iesus ki tania vona, “Taru mulehia ka bainat na mudina, na vuna zia, nuhu laveve kua dia ta vavarihubi na bainat, da dia ta mate ve na bainat. ");
INSERT INTO wiv_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Beta miu na lala habuka kua na koi kiri Tamagu kete kodoniau, ho tu tania mara beta ni geria armi kapou na engel kamahi, kua kadia naba e 72,000, ni ziho kete kodoniau? ");
INSERT INTO wiv_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Palaka da na polea kua e vapolunganga na poloka buk ke Vuvu e pori ziha kua tani kubarae?” ");
INSERT INTO wiv_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Kilangata kua a Iesus e hulenidia, “Miu ta pahopaho bainat kamana pakole miu ka mai kirigu habuka hau ta kaka katiu kua ta vavamuga na manumanu na varihubia kamana vanahoa. Dama laveve hau ta mimia na poloka tempel ka vaketekete na manumanu, palaka beta miu na paho taduriau. ");
INSERT INTO wiv_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Palaka goloa laveve kua ti bele kete pori matoto na nazia kua na profet kamahi dia ta vapolungania varira dia ka tania.” Pale, kana disaipel kamahi dia ta vati tapunia dia kene varihavai. ");
INSERT INTO wiv_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Nuhu kua dia ta haba taduria a Iesus dia ta pelea vano ni Kaiafas, na hetpris, na tisa kamahi kara lo ia mai na pararaha kamahi ke vuni Iuda, kava dia te lupu dia kene lololi. ");
INSERT INTO wiv_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Palaka a Pita ia muri ni Iesus, palaka beta ni kozoho marata ni Iesus, e muri ki zahe hoho matoto na banis na ruma kana hetpris. Ia zahe hoho ia mia kamana gat kamahi, kete hadavia nazia matoto dia kata katia ni Iesus. ");
INSERT INTO wiv_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Na hetpris kamahi kamana kaunsil laveve dia ta kakaze vairukua katiu dia kata koto kiri Iesus vona, dia na hubi matehia. ");
INSERT INTO wiv_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Manumanu luba dia ta zahe dia ka vairuku dia ka padea polea kirina, palaka beta matoto dia na paria goloa katiu e katia ki zaha. Pale, kaka rua hiro ta zahe. ");
INSERT INTO wiv_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Hiro ka tani barae, “Kaka kua e tani barae, ‘Hau e dangea kata robea na tempel ke Vuvu na haba mulehia na dama tolu za.’” ");
INSERT INTO wiv_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Pale, na hetpris e madi ia hulenia a Iesus, “Beta ka koliana polea kuari e varaganga kiriniho?” ");
INSERT INTO wiv_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Palaka a Iesus beta ni makulu ni tania polea katiu. Na hetpris ia tani barae vona, “Hau kata huleniho kua na hizani Vuvu kua e mahuri roro koto tani matotonia. Tania ni hita, ia ho a Kristus, na Tuni Vuvu?” ");
INSERT INTO wiv_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","A Iesus ki tania, “E, ho tu ta tania kena. Palaka kua ta tania ni miu laveve kua. Da ba muri da miu ta hadavia na Tuna Kaka e mimia na marorona Kaka kua e matuha matoto, ki pe na mariaba na lagato ki ziziho.” ");
INSERT INTO wiv_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Pale, na hetpris ia bara terehia kana kolos ia tani barae, “Ia ti delahania a Vuvu kava kua! E kuziha ve tolu kata kaze ve kaka katiu ve kete padea polea kirina? Miu hadavia, kava miu te longoria kana delaha kiri Vuvu. ");
INSERT INTO wiv_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Miu ta lohoi ziha?” Dia ka tania, “Kana manaunaua vona kena, kete hubu matoa.” ");
INSERT INTO wiv_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Pale, dia ta kanizunia matana, dia ka tutuhia. Taza, dia ta zapalania, ");
INSERT INTO wiv_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","dia ka tani barae, Kristus vatunga ni hita habuka ho na profet katiu! Ko tania, azei matoto kua e huhubiho? ");
INSERT INTO wiv_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","A Pita e mimia na hatama na poloka banis na ruma kana hetpris, na tavine vora katiu e mai vona, ia tania, “Ho ve tu kakamani Iesus bukuni Galili.” ");
INSERT INTO wiv_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Palaka ia linga na matadia laveve, ki tania, “Hau beta na lala nazia ho tu popole vona.” ");
INSERT INTO wiv_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pale, ia vana vano kara hatamara geit, na tavine katiu ve e hadavia, ia tania na manumanu kua dia ta vavarimadiriai, “Kaka kua ia e lala kete kakamani Iesus bukuni Nasaret kua.” ");
INSERT INTO wiv_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Palaka a Pita ia linga mule, ki tania, “Hau ta mapamapa, beta matoto na lala na kaka kuari!” ");
INSERT INTO wiv_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Havarau pitu, nuhu dia ta vavarimadiriai na palaka kua, dia ta zahe ni Pita dia ta tania, “Matoto ho katiu ni dia, ka halingana ka pole matotoa e vatunga kakavaho.” ");
INSERT INTO wiv_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","A Pita ki tani barae, “Hau ta mapamapa ka tani matotonia polea. Paleka a Vuvu ni kati zahatia ni niau kua ta na vavairuku! Hau beta matoto na lala kaka kuari!” E tatani barae, na toha ia kakareko. ");
INSERT INTO wiv_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Pale, a Pita ia lohoi mulehia polea kua a Iesus e tania vona, “Ba muri toha kini kakareko, da tu linga ku tania boto tolu habuka beta nu lalau.” Pale, ia gotala kini tangi zahazaha matoto. ");
INSERT INTO wiv_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Damadama matoto, na hetpris laveve kamana pararaha ke vuni Iuda dia ta mai kamana lohoihoia katiu habuka dia kata hubi matehia a Iesus. ");
INSERT INTO wiv_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Dia ta rotia limana karua, dia kene harehia zahe dia ta vala na limani Pailat, na kadia gavana kua bukuni Rom. ");
INSERT INTO wiv_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Tania a Iudas, kaka kua e vala a Iesus, ki hadavi baraenia habuka a Iesus da ti hubu matoa, ia ti hatunia habuka goloa kua e katia beta ni kemi, ia vala mulehia 30 koin moni kua na hetpris kamana pararaha ke vuni Iuda. ");
INSERT INTO wiv_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ia tania ni dia, “Hau kava te katia moge zaha, na vuna te vala vetania kaka kua, beta ni katia goloa zaha katiu, kua keteni hubu matoa.” Dia ka tania vona, “E hita kata kuziha vona kena? Ka galanga, ti ngoro ni niho.” ");
INSERT INTO wiv_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Pale, a Iudas ia varaga taduria na moni silva kua kara poloka tempel, ia vavana. Ia vano ia have kini mate. ");
INSERT INTO wiv_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Na hetpris kamahi dia ta vilehia na moni kamahi kua dia ka tania, “Na moni kua e valanga kete hubu matoa kaka voa vona kua, beta kete taruha kamana monina tempel.” ");
INSERT INTO wiv_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Pale, dia ta varitaninia dia kene kadea na garigari kana kaka kua e lala kete katikati sospen garigari, kete kara matmat kana nuhu kua beta dia na bukuni Israel matoto. ");
INSERT INTO wiv_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Kubarae, na palaka kua ti ma kini kokohanga na Vanua na Topo. Na vuna e kadoa na moni kua e hubi matoa kaka vona. ");
INSERT INTO wiv_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Pale, na polea kua na profet a Jeremaia e tania varira, ia ti pori matoto, e tani barae, “Na Paraha e geriau kata tani barae ni dia: Dia ta pelea na 30 silva moni, na naba na moni kua a vuni Israel dia te makia habuka kete kadoa ia vona, dia ta kadea na garigari kana kaka kua e lala kete katikati sospen garigari.” ");
INSERT INTO wiv_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","A Iesus e madi na matani gavana, ia ki hulenia, “Ia ho na king ke vuni Iuda?” A Iesus ki tania, “Ho tu tatania kena.” ");
INSERT INTO wiv_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Na hetpris kamahi kamana pararaha ke vuni Iuda dia ta padea polea luba kiri Iesus, palaka beta ni kolia kadia polea. ");
INSERT INTO wiv_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","A Pailat ki hulenia, “Beta nu longoria na polea kamahi kuari dia ta papadeho vona?” ");
INSERT INTO wiv_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Palaka a Iesus beta matoto ni kolia kadia polea katiu. Kubarae na gavana kua ki lohoi tori matoto. ");
INSERT INTO wiv_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Na krismas laveve kua damana hanihania kapou kara Pasova, na kadia gavana kua bukuni Rom e lala kete vagotalani mulehia na karabus, kaka katiu kua ta manumanu dia na hulenia kirina. ");
INSERT INTO wiv_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Kilaka kua, na kaka zaha matoto katiu ia e karabus, manumanu laveve dia ta lala kaka kua, hizana a Barabas. ");
INSERT INTO wiv_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Tania na manumanu dia ka zahe lupu, a Pailat ia hulenidia, “Azei ni hiro matoto kulimiu kata vagotalani mulehia? A Barabas, o a Iesus kua e kohanga ni Kristus?” ");
INSERT INTO wiv_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Na vuna ia e lala na pararaha ke vuni Iuda dia ta hahada potia a Iesus, kubarae dia kene haba taduria dia kene vala na limana. ");
INSERT INTO wiv_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","A Pailat e ba mimia na kana mianga kua kete longoria na kotoa vona, a gona ia vala polea katiu zahe vona ki tani barae, “Tabarae nu lohoia koto katia goloa katiu na kaka kena, beta ni katia goloa zaha katiu, na vuna ngina ta manginuvia na kaka kena, ka hatunia bizea kapou matoto na polokogu.” ");
INSERT INTO wiv_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Palaka na hetpris kamahi kamana pararaha kamahi ke vuni Iuda, dia ta varidingania manumanu dia kata hulenia a Pailat kiri Barabas kete vagotalanga, a Iesus kete hubu matoa. ");
INSERT INTO wiv_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","A Pailat ia hulenidia, “Azei matoto ni hiro kulimiu kata vagotalania ni vano ni miu?” Dia ta tania, “A Barabas.” ");
INSERT INTO wiv_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","A Pailat ki hulenidia, “Pele kata kuzingania a Iesus kua e kohanga ni Kristus?” Dia ka lupu laveve dia ka tania, “Nilinia na kruse!” ");
INSERT INTO wiv_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","A Pailat ki hulenidia, “E kuziha, nazia matoto e katia ki zaha?” Palaka dia ta dopa goe dia ka tania, “Nilinia na kruse!” ");
INSERT INTO wiv_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","A Pailat ti hada baraenia beta dia na longoria kana polea, ki vano ve na manumanu kozoho matoto dia keteni katia varihubia kapou, pale, ia pelea naru ia vazuguvia limana na matana manumanu laveve, ki tani barae, “Hau beta na gerimiu miu kata hubi matehia kaka kua. Kana matea ia ti kamiu galanga!” ");
INSERT INTO wiv_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Manumanu laveve kua dia ka tania, “Vatia hita kamani habu tutuhita hita ka papari polea na kana matea!” ");
INSERT INTO wiv_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pale, ia vagotalania a Barabas vano ni dia. Palaka e geu dia ta vihia a Iesus, ia vala na limadia dia kata nilinia na kruse. ");
INSERT INTO wiv_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Na soldia kamahi ke gavana dia ta pelea a Iesus vano hoho kara poloka ruma ke gavana, na kabuna soldia laveve dia ta madi lobia. ");
INSERT INTO wiv_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Dia ta hulia kana loholohoa kakava na livuhana dia ta valohoria na lavalava baritunutunua, kua na king za e lala kete lolohoria. ");
INSERT INTO wiv_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Pale, dia ta viralunia na dangana hai matangatanga kete balika hate kana king, dia ta vakudia vona, dia ta taruhia na dangana hai na limana kiri maroro, dia ta nildaun na mugana dia ka bozubozu vona dia ka tania, “Dama kemi, king ke vuni Iuda!” ");
INSERT INTO wiv_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Dia ta livinia, dia ta pelea na dangana hai dia ka ma huhubia bakana vona. ");
INSERT INTO wiv_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Dia ta hubi hozovia muri dia ta pele kakava na lavalava baritunutunua vona dia ta valohori mulehia na kana loholohoa. Pale, dia ta pelea zahe dia kata havenia na kruse. ");
INSERT INTO wiv_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Dia ta vavana vano dia ta paria kaka katiu bukuni Sairini, hizana a Saimon, dia ta geria kete luga na kruse. ");
INSERT INTO wiv_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Dia ta mai bele na palaka katiu kohanga ni Golgota. Vuvuna polea kua e tani barae: Palakana togana bakana kaka mate. ");
INSERT INTO wiv_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Na palaka kena dia ta vala vaen ni Iesus kete hinumia, dia ta pokizia kamana goloa magolegolea; e parakilania ki naminia, ia hava kete hinumia. ");
INSERT INTO wiv_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Dia ta nilini hozovia a Iesus, muri vona dia ta pilae satu kara kana loholohoa kamahi, dia kene varidangeai vona. ");
INSERT INTO wiv_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Pale, dia kene ma mia hahada poto vona. ");
INSERT INTO wiv_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Monge langa na bakana dia ta taruhia na vapolupolua katiu dia ka tania kirina: A IESUS KUA, NA KING KE VUNI IUDA. ");
INSERT INTO wiv_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Kaka mata vanaho rua hiro ta haveanga ve kamana, katiu kiri maroro katiu kiri mauri. ");
INSERT INTO wiv_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Manumanu dia ka pe hutu vona dia ka tara vilu kirina dia ka hilenia, ");
INSERT INTO wiv_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","dia ka tatania kirina, “Ho kua koto robea na tempel nu haba mulehia na dama tolu, ko vaikoli kiriniho mule! Mai zipa na kruse, kua kini ho na Tuni Vuvu matoto!” ");
INSERT INTO wiv_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Na hetpris kamahi kamana tisa kamahi kara lo ia mai na pararaha ke vuni Iuda ve dia ta hilenia. ");
INSERT INTO wiv_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Dia ka tani barae, “E vaikoli kara nuhu motu, palaka e lokia keteni vaikoli kirina mule! E tania ia na king ke vuni Israel! Pele kete mai zipa na kruse hita kata hadavia hita na bilip vona. ");
INSERT INTO wiv_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ia e vaka maroro ni Vuvu. Ki tania ve ia na Tuni Vuvu. Pele tolu kata hada, kua ni matoto a Vuvu ni kulina kirina, da ti vaikoli kirina.” ");
INSERT INTO wiv_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Na mata vanaho karua kua hiro ta haveanga kamani Iesus, hiro ve ta hilenia a Iesus ve. ");
INSERT INTO wiv_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Na 12 kilok ki vano na 3 kilok, na rodo kapou e kari havutia malala laveve. ");
INSERT INTO wiv_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Kozoho keteni 3 kilok na garavi, a Iesus ia goe ki tania, “Eloi, Eloi lama sabaktani?” Mining na polea kua e tani barae, “Kagu Vuvu, kagu Vuvu, e kuziha kunu vati tapuniau?” ");
INSERT INTO wiv_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Taza ni dia kua dia ta varimadiriai na palaka kena dia ta longoria polea kua, dia ka tania, “E kokoi kiri Elaija.” ");
INSERT INTO wiv_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Kaka katiu ia rovo pamuhi zahe pelea na spans. Ia lutia na vaen e pokiza kamana viniga, ia taruhia spans na dangahai katiu, ia vala ni Iesus kete hinumia. ");
INSERT INTO wiv_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Dia manumanu taza dia ta tania, “Vatia! Tolu kata hadavia a Elaija kete mai ni kodonia.” ");
INSERT INTO wiv_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","A Iesus e dopa ki goe mule ve, pale ia mate. ");
INSERT INTO wiv_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Na taem kena matoto na lavalava na tempel e tere ki pe na huduna ki ziho kara vuvuna. Na garigari ki hunu na kedo kamahi ki vulavula. ");
INSERT INTO wiv_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Na kedo kamahi kua e karua havana matmat kamahi vona e vula na matmat kamahi ki ngapa, na manumanu tumonga ke Vuvu kua dia te varimateai muga dia ta mahurihuri mule na matea. ");
INSERT INTO wiv_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Dia ta gotala na lovo, muri na kua a Iesus ti lama mule na matea dia ta vano hoho kara siti kua e tumonga dia ka bele na manumanu luba. ");
INSERT INTO wiv_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Tania na komada kara armi kamana soldia taza ve kua dia ta mamadi kamana dia ka hada na vuruhe kamana goloaloa laveve kua e bele, dia ka kuahi zahazaha matoto dia ka tania, “Matoto kaka kuari ia na Tuni Vuvu!” ");
INSERT INTO wiv_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Tavivine luba dia ve na palaka kua, dia ta madi zau dia ka hahada. Dia ta pe ni Galili dia ka muri ni Iesus dia kata kodonia na kana galanga. ");
INSERT INTO wiv_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Na pidaki tavivine kua, a Maria bukuni Makdala, a Maria titinani Jems hiro a Iosep, ia mai a goni Sebedi. ");
INSERT INTO wiv_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ti kozoho keteni marigo, na kaka katiu bukuni Arimatea, hizana a Iosep, ia na risman katiu, ia ve na disaipel ke Iesus katiu. ");
INSERT INTO wiv_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","E zahe ni Pailat, ia hulenia kara podani Iesus, pale a Pailat ia geridia, dia kata vala podani Iesus vona. ");
INSERT INTO wiv_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","A Iosep ia pelea podani Iesus, ia kukulia na lavalava vahoru, ");
INSERT INTO wiv_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ia taruhia na poloka kana lovo vahoru kua e hovia na kedo. Ia puke porotia kedo kapou kara hatamara lovo, ia vatia kini vano. ");
INSERT INTO wiv_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Kilaka kua, a Maria bukuni Makdala ia mai a Maria katiu ve hiro ta mimia kozoho na hatamara lovo. ");
INSERT INTO wiv_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ti dama mule, na Sabat, na hetpris kamahi kamani vuni Parisi dia ta zahe hada a Pailat. ");
INSERT INTO wiv_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Dia ka tani barae vona, “Paraha, hita ta lohoia polea kana kaka mata vairukuruku kua katiu, kilaka kua e ba mamahuri ki tatani barae, ‘Muri na dama tolu da ta mahuri mule.’ ");
INSERT INTO wiv_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Kubarae, tani vatuharia polea dia kata hada poto papa na matmat ki mule na dama tolu kua. Tabarae kana disaipel kamahi dia na mai vanahea podana dia na tania na manumanu habuka ia ti mahuri mule na matea. Vairukua kua, da ti dopa kini zaha dopa na vairukua kua bukuni muga.” ");
INSERT INTO wiv_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","A Pailat ia tania, “Miu pelea soldia taza miu na ziho taba porotia lovo ni bada matoto, miu ta geridia dia hada poto na matmat.” ");
INSERT INTO wiv_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Pale, dia ta vano dia ta taruhia tabu na kedo na matmat, kete beta kaka kete mai kozoho na lovo. Dia ta taruhia na gat kamahi ve dia kata hada poto vona. ");
INSERT INTO wiv_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Muri na Sabat, na Sande na dama, a Maria bukuni Makdala kamani Maria katiu ve hiro ta zahe kara lovo na poloka kedo. ");
INSERT INTO wiv_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Na vuruhe kapou ia bele, na vuna zia na engel ke Vuvu e pe na lagato ki ziho, ia vano ia puke kakava na kedo kua e tabara na lovo vona, ia mia langalanga na huduna. ");
INSERT INTO wiv_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Livuhana e kalageru balika hanimata, kana zohozohoa ki puzopuzoa matoto balika snou. ");
INSERT INTO wiv_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Na soldia kamahi dia ta kuahini zahazahatia matoto, livuhadia ki vavani dia ka dua dia ka mate kuzi. ");
INSERT INTO wiv_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Na engel e tania na tavine rua kua, “Taua mo na kuahi, hau ta lala mo ta hahada kiri Iesus, kua e haveanga na kruse. ");
INSERT INTO wiv_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ti beta ia ri kua; ia ti mahuri mule kava, habuka kena e tania. Mai mo na hada mudina kua e ngoro vona. ");
INSERT INTO wiv_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Kua mo vano tapu mo na tania na kana disaipel kamahi, ‘Ia kava ti mahuri mule na matea kini vamuga ni miu vano kiri Galili. Ni Galili ia da miu ta hadavia.’ Tabarae mo na lohoi bala nazia ta tania ni mo.” ");
INSERT INTO wiv_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Pale, na tavine karua kua, hiro ta kuahi hiro ta rovo vatia lovo. Palaka polokohiro e hilohilo matoto, hiro ta rovo hiro kata kalohu na disaipel kamahi ke Iesus. ");
INSERT INTO wiv_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","A Iesus ia bele ni hiro, ki tani barae, “Dama kemi.” Hiro ta paho taduria kabena hiro ta lotu vona. ");
INSERT INTO wiv_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Pale, a Iesus ia tania ni hiro, “Taua mo na kuahi. Mo vano mo na tania ni habu tazigu dia kata vano kiri Galili. Da dia ta hadaviau rae.” ");
INSERT INTO wiv_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Kamana na tavine rua kua hiro ka vavana vano, na soldia taza kua dia ta hada poto na lovo, dia ta vano kara taon dia ta kalohunia goloa laveve na hetpris kamahi. ");
INSERT INTO wiv_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Tania na hetpris kamahi dia ka lupu kamana pararaha ke vuni Iuda dia ta mai kamana lohoihoia katiu, dia ta kadea na soldia kamahi kua na moni kapou matoto, ");
INSERT INTO wiv_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","dia ka tania ni dia, “Miu tania na manumanu kubarae, ‘Hita ta varingoroai, kana disaipel kamahi dia kene mai vanahea na marigo.’ ");
INSERT INTO wiv_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Kua na gavana ni lala horuvia na polea kua, da hita ta madi kamiu hita ka pole kamiu, beta goloa katiu kete katua ni miu.” ");
INSERT INTO wiv_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Pale, na soldia kamahi kua dia ta pelea na moni kua, dia kene katia nazia kua e tanga ni dia. Pale, a vuni Iuda dia kene ma ziuziu na polea kua na gat kamahi dia ta tania, ia ia ki mai na tauna kua. ");
INSERT INTO wiv_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Pale, na kana 11 disaipel kamahi dia ta vano kiri Galili, kara potuna kena a Iesus e tania dia kata kirina. ");
INSERT INTO wiv_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Kamana dia ka hadavia, dia ta lotu vona; taza ni dia, dia ta lohoi ruarua. ");
INSERT INTO wiv_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Pale, a Iesus ia mai ni dia ia tania, “Matuhanga laveve bukuna lagato kamana garigari ti valanga ni niau kava. ");
INSERT INTO wiv_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Kuza barae miu vano na palaka laveve na garigari, miu na katia manumanu dia na kara kagu disaipel. Miu vazuguzugu kamadia na hizani Tamagu na hizani Tuna na hizani Vule Tumonga, ");
INSERT INTO wiv_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","miu ka vaketea ni dia habuka dia kata muri na polea laveve kua hau ta tania miu kata muri vona. Hau da ta ma kamamiu ia ia ki mule na las de.” ");
INSERT INTO wiv_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Kua na varivuvuka Kalohua Kemi ni Iesus Kristus, tuni Vuvu. ");
INSERT INTO wiv_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Varira e vapolunganga na buk ke profet Aisaia ki tani barae voa, “Longoria, da ta geria kagu vakilalanga ki vamuga ni niho, kete vaida ka dala.” ");
INSERT INTO wiv_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Na halinga katiu e gogoe na poloka deset, ki tani barae, “Vaida dala kara Paraha, vahotovia daladala kamahi ni mahoto kirina.” ");
INSERT INTO wiv_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","A Jon e bele kini vavala baptais na poloka deset, ki vaketekete barae, “Miu vala lamamiu kara kamiu moge zahazaha a Vuvu kete lohoi bala kamiu manaunaua kamahi.” ");
INSERT INTO wiv_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Manumanu laveve na provins a Iudea kamani Ierusalem dia ta vano ni Jon, dia ka tani kakava kadia moge zahazaha, kini vavala baptais ni dia na naru a Iordan. ");
INSERT INTO wiv_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","A Jon e zohoria na zohozohoa kua e katua na vuluka kamel, ki taza votaka na lete kua e katua na hulita bulmakau. Ki lala kete hahania na pidogo kamana hani. ");
INSERT INTO wiv_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","E vaketea manumanu ki tani barae, “Kaka katiu kua da e muri ni niau ki mai, e dopa ki hizanga ni niau. Hau beta na kemi na dangea kata tiro vatudu na hulia mota na kana sandel. ");
INSERT INTO wiv_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Hau ta vazuguvimiu na naru, palaka ia da e vazuguvimiu na Vule Tumonga.” ");
INSERT INTO wiv_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Kilaka kua a Iesus e pe ni Nasaret na paligena ni Galili ki mai, a Jon e vala baptais vona na naru a Iordan. ");
INSERT INTO wiv_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Kamana a Iesus ki paka na naru, ia hadavia na lagato e ngapa, na Vule Tumonga e bele balika balu ki tali vatudu kara huduna. ");
INSERT INTO wiv_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Na balunga katiu e pe na lagato ki tani barae, “Ho na Tugu matoto, kua e kuligu matoto kiriniho. Magaligu e lala kete malugunia matoto kiriniho.” ");
INSERT INTO wiv_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Kilaka pamuhi za na Vule Tumonga ia geria kini vano kara poloka deset. ");
INSERT INTO wiv_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","E mia na poloka deset dama e 40, a Satan ki pado rukia. E mia kamana manu havurengo kamahi, na engel kamahi dia ka kokodonia. ");
INSERT INTO wiv_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Muri na taem kua dia te taruhia a Jon na karabus, a Iesus ia vano kiri Galili, kini vavaketekete na Kalohua Kemi ke Vuvu. ");
INSERT INTO wiv_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ki tatani barae, “Na kingdom ke Vuvu ti mai kini kozoho. Miu zuka tapunia kamiu moge zahazaha miu na bilip na Kalohua Kemi!” ");
INSERT INTO wiv_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","A Iesus e vavana na hiripa loka ni Galili, ia hadavia a Saimon kamani tazina a Andru. Hiro ta vavaragaraga vuho na loka, na vuna zia, hiro ta kakanaka pelepelea na hiha. ");
INSERT INTO wiv_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","A Iesus ki tania ni hiro, “Mo mai muri ni niau, na vatunga makina pelepelea na kaka ni moro.” ");
INSERT INTO wiv_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Hiro ta zuka tapuni pamuhia kahiro vuho, hiro kene muri vona. ");
INSERT INTO wiv_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","E vana vano pitu papa ve, ia hadavia a Jems, tuni Sebedi, kamani tazina a Jon na huduna kahiro bot, hiro ta vavahotovia kahiro vuho. ");
INSERT INTO wiv_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ia kohani pamuhi hiro, hiro ta vatia a tamahiro a Sebedi na huduna bot kamana nuhu kua e kadoadia dia kata gala kamana. Hiro kene muri ni Iesus. ");
INSERT INTO wiv_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","A Iesus kamana kana disaipel kamahi dia ta vano lohu ni Kaperneam, na dama na Sabat ti bele, ia vano pamuhi hoho na poloka haus lotu ke vuni Iuda kini vaketekete ni dia. ");
INSERT INTO wiv_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Dia ta ridi matoto na kana vaketeketea. Na vuna beta ni vaketekete balika na tisa kamahi kara lo, beta, ia e vaketekete habuka kaka kua kana naba vona. ");
INSERT INTO wiv_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Pale, na kaka katiu na vule zaha e holiholia, e pe hoho na poloka kadia haus lotu kua, ia goe ki tani barae, ");
INSERT INTO wiv_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Iesus bukuni Nasaret. Nazia koto katia ni hita? Tu mai koto nu vairohihita ai? Hau ta lala ho azei. Ho na Kaka Tumonga ke Vuvu!” ");
INSERT INTO wiv_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","A Iesus ia harovitinia, ki tania, “Tabaria hava nu mai gotala na kaka kena!” ");
INSERT INTO wiv_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Na vule zaha kua ki hununia na kaka kua, ki gigi kapopou matoto, ia gotala na kaka kua. ");
INSERT INTO wiv_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Manumanu laveve dia ta ridi matoto, kubarae dia kene vavarihulei, dia ka tani barae, “Nazia matoto kua? Na vaketeketea vahoru katiu kua! Kaka kua kana naba vona kete geria na vule zaha kamahi, dia na longoria kana polea.” ");
INSERT INTO wiv_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Pale, na rereki Iesus kini vavana lobi tapu na palakalaka laveve ni Galili. ");
INSERT INTO wiv_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","A Iesus kamana kana disaipel kamahi, ia mai a Jems hiro a Jon, dia ta vatia na haus lotu ke vuni Iuda, dia ta vano kara ruma ke Saimon hiro a Andru. ");
INSERT INTO wiv_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","A ravani Saimon tavine, e mazahi zahatia, livuhana e totoba ki ngongoro na dongi, pale, dia ta kalohunia ni Iesus. ");
INSERT INTO wiv_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Pale, a Iesus ia vano pahoria limana, ia valamaria. Na mazahi ia vatia, pale, ia kini vavaida hadia haninga. ");
INSERT INTO wiv_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ti garavi na voro ti zugu, pale, na manumanu dia ta pelea nuhu laveve kua mazahi ni dia ia mai nuhu kua na vule zaha e hoholiholidia dia ta mai ni Iesus. ");
INSERT INTO wiv_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Manumanu laveve bukuna taon kua, dia ta lohu dia ka lupu na hatamara ruma kua. ");
INSERT INTO wiv_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","A Iesus ia kati kemihia nuhu kua mazahi kakeikakei kua ni dia, ki pele gotalania na vule zahazaha kamahi. Ki vatabunia na vule zaha kamahi beta dia kata pole, na vuna zia, dia ta lala a Iesus ia azei matoto. ");
INSERT INTO wiv_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Na damadama matoto na marigorigopa, e lama ia vano kara palaka kua beta kaka vona, ia lotu. ");
INSERT INTO wiv_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","A Saimon kamana dia taza ve dia ta vano dia kata kaze kirina. ");
INSERT INTO wiv_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Kamana dia ka paria, dia ta tania vona, “Manumanu dia ta kakaze kiriniho.” ");
INSERT INTO wiv_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","A Iesus ki tania ni dia, “Maku, tolu kata vano kara malala taza ve kua kozoho, hau kata vaketekete ve ni dia. Ia na vuvuna kua hau ka mai.” ");
INSERT INTO wiv_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Pale, ia vavana lobia palaka laveve ni Galili, ki vaketekete na poloka haus lotu kamahi ke vuni Iuda ki pepele gotalania na vule zaha kamahi. ");
INSERT INTO wiv_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Kaka katiu na lepra vona e mai ni Iesus ki padonia tutura ki halohonia a Iesus ki tania, “Kua ni kuli, katiau na kemi.” ");
INSERT INTO wiv_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","A Iesus lohora e zaha matoto vona, ia tabe vano ia vakulia, ki tania vona, “Hau e kuligu koto kemi.” ");
INSERT INTO wiv_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Kamana pamuhi za na lepra ia kakava na livuhana kaka kua kini kemi. ");
INSERT INTO wiv_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","A Iesus ia geria vano. Ki tani vatuharia polea vona kubarae, ");
INSERT INTO wiv_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Lohoia, tabarae nu kalohunia goloa kua na kaka katiu. Palaka vano ho tu vatungaho na Pris, ho tu vala na opa kua a Moses e tania, koto vatunga habuka kava tu kemi mule kava.” ");
INSERT INTO wiv_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Palaka na kaka kua e vano, ia kini kalohulohunia na goloa kua na manumanu. Kubarae a Iesus kini lokia keteni pe kavakava ni hoho na taon katiu. Kubarae, ia kini ma mimia na palakalaka kamahi kua beta kaka vona. Palaka manumanu dia ta pe na malala laveve dia kene mamai bebele vona. ");
INSERT INTO wiv_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Dama taza kakava a Iesus ia vamule kiri Kaperneam. Pale, na manumanu dia te lala habuka, ia na kana ruma. ");
INSERT INTO wiv_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Pale, na manumanu luba matoto dia ta mai lupu na poloka ruma kua, na ruma kini vonu matoto. Kozoho ve na hatama, ia beta zeleka ve. Pale, ia kini vavaketekete ni dia. ");
INSERT INTO wiv_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Manumanu taza dia ta pelea kaka katiu ki mai limana, kabena e matemate. Kaka garamo dia ta luluga. ");
INSERT INTO wiv_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Palaka na vuna manumanu dia ta vonu matoto na poloka ruma, ki mara beta dia na vano kozoho ni Iesus, dia ta papane langa na huduna ruma, dia ta katia na horupa katiu damukia a Iesus, pale, dia ta vazihonia na dongi kamana kaka kua limana, kabena e matemate. ");
INSERT INTO wiv_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","A Iesus ki hadavia kadia bilip, ia tania na kaka kua limana, kabena e matemate, “Tugu, te lohoi bala ka manaunaua laveve.” ");
INSERT INTO wiv_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Kilangata kua ve na tisa kara lo taza, dia ta lololi ve na ruma. Dia ka lolohoi barae na polokodia mule, ");
INSERT INTO wiv_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“E kuziha kaka kuari ki tani barae kuari? Ia e dedelahania a Vuvu! A Vuvu za ia e dangea kete lohoi bala manaunaua!” ");
INSERT INTO wiv_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","A Iesus ia lala pamuhia kadia lohoihoia, pale, ia hulenidia, “E kuziha miu ka lolohoi barae? ");
INSERT INTO wiv_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Polea kakei e malimu kata tania na kaka kua limana, kabena e matemate kua, ‘Ka manaunaua te lohoi bala,’ o kata tani barae, ‘Madi, nu pelea ka dongi nu vavana’? ");
INSERT INTO wiv_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Palaka hau kata vatunga matotonia ni miu habuka na Tuna Kaka ia kana matuhanga vona ri na garigari, kete lohoi bala manaunaua.” Pale, a Iesus ia tania na kaka kua limana, kabena e matemate, ");
INSERT INTO wiv_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ta tania ni niho, madi nu pelea ka dongi nu vano kara ka ruma.” ");
INSERT INTO wiv_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Na kaka kua ia divurutia ia pelea kana dongi kini gotala, na matadia laveve. Manumanu laveve dia ta zipa zahe dia kene vavazahenia hizani Vuvu, dia kene tatani barae, “Hita ma beta hita na hada goloa katiu kua e mata barae kua!” ");
INSERT INTO wiv_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","A Iesus e vamule kara vazalea na loka ni Galili, na kabuna manumanu dia ta mai vona, ia kini vavaketekete ni dia. ");
INSERT INTO wiv_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","E lilia vazalea ki vano, ia hadavia a Livai tuni Alfius, e mimia na kana opis kara takis. A Iesus ia tania vona, “Ho mai muri ni niau.” A Livai ia di madi kini muri vona. ");
INSERT INTO wiv_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","A Iesus e mia ki hanihani na ruma ke Livai. Na nuhuta pelepelea na takis luba, kamana nuhuta moge zahazaha luba dia ta hanihani kamani Iesus kamana kana disaipel kamahi. Na vuna, dia manumanu mata baraerae kua luba dia ta lala dia kata mumuri ni Iesus. ");
INSERT INTO wiv_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Na tisa kamahi kara lo taza, bukuna kabu ke vuni Parisi, dia ta hada kua a Iesus e hanihani kamana nuhuta moge zahazaha kamana nuhuta pelepelea na takis, dia ta hulenia na kana disaipel kamahi, “E kuziha ki hahanihani kamana nuhuta pelepelea na takis kamana nuhuta moge zahazaha?” ");
INSERT INTO wiv_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Kamana a Iesus ki longoria polea kua, ia tania ni dia, “Nuhu kua beta mazahi ni dia, ia beta dia na lala dia kata vano hada dokta. Palaka nuhu kua mazahi ni dia za, ia dia ta hahada dokta. Hau beta na ziho kata kohania nuhu kua dia ta mahotohoto, palaka kara nuhuta moge zahazaha.” ");
INSERT INTO wiv_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Boto katiu na disaipel kamahi ke Jon kamani vuni Parisi dia ta mamahoho. Manumanu taza dia ta mai hulenia a Iesus, “E kuziha na disaipel kamahi ke Jon kamana disaipel kamahi ke vuni Parisi dia ka mamahoho, ka disaipel kamahi ki beu?” ");
INSERT INTO wiv_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","A Iesus ki tania ni dia, “Da na nuhu kua e vinohuanga dia kara hanihania na lahia, dia ta mahoho ziha kua na kaka kua e ba lahi vahoru e ba kakamadia? Mara beta! Kua ta ia ni ba kakamadia, ia mara beta dia na mahoho. ");
INSERT INTO wiv_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Palaka ba muri kua ta na kaka kua e ba lahi vahoru tani pele kakavanga ni dia, pale, dia te ba mahoho. ");
INSERT INTO wiv_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Beta kaka katiu ni lala kete pelea dihura lavalava vahoru ni turi porotia horupa lavalava bura vona. Ta ni kati baraenia, da na dihura lavalava vahoru da ti dae terehia na lavalava bura kini katia na horupa kena kini dopa kapou. ");
INSERT INTO wiv_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Beta ve kaka ni lala kete valiki hohoria vaen vahoru kara hulita me bura. Kua tani kubaraenia, da na vaen vahoru e tuka terehia na hulita me, pale, na vaen ia mai na hulita me, hiro ta rua vairo. Palaka na vaen vahoru ia kete valiki hohora kara hulita me kua e ba vavahoru.” ");
INSERT INTO wiv_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Na Sabat katiu a Iesus kamana kana disaipel kamahi dia ta turuturu na poloka vanua na Vit, dia ta vavana vano, na disaipel kamahi ke Iesus dia ta duledule na palekana vit. ");
INSERT INTO wiv_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Na Parisi taza dia ta tani barae ni Iesus, “Hadavia, e kuziha dia ka kakatia goloa kua kadolu lo e vatabunia kua beta kete katua na Sabat?” ");
INSERT INTO wiv_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","A Iesus ki tania kiridia, “Tauka beta miu na hazenia ziuziua kua a Devit e katia na dama katiu kilaka kua ia kamana kana manumanu, kua e vitolonidia? ");
INSERT INTO wiv_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Kilaka kua a Abiata ia e hetpris, a Devit e hoho na ruma ke Vuvu, ki hania na bret kua e tabutabua. Kua na pris kamahi za dia ta lala dia kata hahania. Ki vala ve na nuhu kua dia ta lala dia kata kakamana.” ");
INSERT INTO wiv_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Pale, a Iesus ia tani barae ni dia, “A Vuvu e katia Sabat kete kodonia manumanu. Beta ni taruhia manumanu dia kata kokodonia na Sabat. ");
INSERT INTO wiv_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Kubarae, na Tuna Kaka ia na Paraha ve kara Sabat.” ");
INSERT INTO wiv_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Boto katiu ve a Iesus e hoho mule kara poloka haus lotu ke vuni Iuda, na kaka katiu limana e makilokiloa, na poloka haus lotu kua. ");
INSERT INTO wiv_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Manumanu taza dia ta kakazekaze dala kua dia kata koto kiri Iesus vona. Kubarae, dia ta ma babanuzia a Iesus dia kata hada, karae da e kati kemihia kaka kua na Sabat. ");
INSERT INTO wiv_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","A Iesus ki tania na kaka kua limana e makilokiloa, “Mai madi na pidaka manumanu.” ");
INSERT INTO wiv_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Pale, a Iesus ia hulenidia, “Kadolu lo e tania nazia tolu kata katia na Sabat? Tolu kata kati kemihia na kaka o tolu kata kati zahatia vona? Tolu kata vaikoli kara kaka ni beta kete mate o tolu kata hubi matehia kaka?” Palaka beta kaka katiu ni kolia kana polea. ");
INSERT INTO wiv_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","A Iesus ki hada lobi ni dia magalina ki halavidi kiridia, magalina ki zaha ve kiridia na vuna beta ni nap dia kata longoria polea. Pale, ia tania na kaka kua, “Vatatahia lima.” Na kaka kua ki vatatahia limana, na limana ia kemi pamuhi. ");
INSERT INTO wiv_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Pale, na Parisi kamahi dia ta gotala dia kene vano katia na miting katiu kamana nuhu kua dia ta lala dia kata kakamani Herot dia kata paria dala katiu kua dia kata hubi matehia a Iesus. ");
INSERT INTO wiv_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Pale, a Iesus kamana kana disaipel kamahi dia ta vatia malala kena, dia kene vano kara loka a Galili. Na kabuna manumanu luba matoto dia ta muri vona. Dia ta pe ni Galili, dia ka pe ni Iudea, ");
INSERT INTO wiv_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","dia ka pe ni Ierusalem, dia ka pe ni Idumea, dia ka pe na paligena kiri Iordan, dia bukuni Tair kamani Saidon ve. Manumanu laveve kua dia ta mai ni Iesus na vuna dia ta longoria na rereka goloaloa kua e kakatia. ");
INSERT INTO wiv_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Manumanu dia ka luba marata, kubarae ia ki tania na kana disaipel kamahi dia kata vaida na bot katiu, kete polo vona, tabarae manumanu dia na digi taduria. ");
INSERT INTO wiv_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Na vuna ia ti kakati kemihia manumanu luba, kubarae nuhu kua kadia mazahi kamahi vona, dia te vavaridigi dia kata vakulia livuhana. ");
INSERT INTO wiv_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Nuhu kua na vule zaha e holiholidia, kamana dia ka tunga kozo ni Iesus, dia ta dua kara kabeni Iesus dia ka goe dia ka tani barae, “Ho na Tuni Vuvu.” ");
INSERT INTO wiv_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Palaka a Iesus ki tani vatuharia polea ni dia habuka beta dia kata tani kakava na kaka katiu habuka, ia azei matoto. ");
INSERT INTO wiv_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","A Iesus ia vori kara potuna katiu, ia koi palia nuhu kua e kulina dia kata kakamana. Pale, dia ta vano vona. ");
INSERT INTO wiv_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ia makia manumanu e 12, ki kohanidia na kana apostel kamahi. Dia kata kakamana kete gegeridia dia kata vano vavala polea kana Paraha. ");
INSERT INTO wiv_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Kete vala ve matuhanga ni dia, dia kata pele kakava vule zaha kamahi. ");
INSERT INTO wiv_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Kua na nuhu 12 a Iesus e makidia kua: a Saimon (kaka kua a Iesus e vala hiza kua a Pita vona); ");
INSERT INTO wiv_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","a Jems tuni Sebedi kamani tazina a Jon, kaka rua kua a Iesus e vala hiza kua a Boanerges ni hiro (vuvuna hiza kua; na habu tutuna mariaba kua e vurupelele); ");
INSERT INTO wiv_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","a Andru, a Filip, a Bartolomyu, a Matyu, a Tomas, a Jems tuni Alfius, mai a Tadius, a Saimon bukuna kabu kua e kohanga dia ni Selot. ");
INSERT INTO wiv_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Ia mai a Iudas Iskariot kaka kua muri kete vala a Iesus na limana manumanu kua dia kata hubi matehia. ");
INSERT INTO wiv_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","A Iesus ia vamule vano kara ruma, na kabuna manumanu dia ta mai mule ve lupu, pale, a Iesus kamana kana disaipel kamahi ti beta kadia taem kua dia keteni hanihani. ");
INSERT INTO wiv_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Habu vineki Iesus dia ta longoria goloa kamahi kua a Iesus e kakatia, dia ta mai dia kata harehia ni vano. Na vuna dia ta tania ti longolongo. ");
INSERT INTO wiv_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Na tisa kamahi kara lo kua dia ta pe ni Ierusalem dia ka ziho, dia ta tani barae, “A Belsebul e holiholia kuari, ki gagala kamana matuhanga kana paraha ke hanitunitu ki pepele gotalania vule zahazaha kamahi.” ");
INSERT INTO wiv_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Pale, a Iesus ia koi kiridia ki barikikinia polea ni dia ki tani barae, “A Satan da e pele kakava zingania a Satan? ");
INSERT INTO wiv_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kua na manumanu bukuna kingdom katiu dia na varipe vulavulahi, dia na varihubi mule, da na kingdom kena mara beta ni madi ni bada. ");
INSERT INTO wiv_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Kua na kabu katiu dia na varipe vulavulahi dia na vavarihubi na pidaka dia mule, da na kabu kena da beta kete madi ni bada. ");
INSERT INTO wiv_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Kua a Satan kua ni vavarihubi mule kamana mule ni varipe vulavulahi, da mara beta ni mahuri. ");
INSERT INTO wiv_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Mara beta kaka katiu ni hoho veta na ruma kana kaka babo katiu, ni pelea kana goloaloa. Ma muga ki rotu taduria kaka babo kena. Pale, ba muri kini vanahea goloaloa na kana ruma. ");
INSERT INTO wiv_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Hau ta tani matotonia ni miu. Da a Vuvu e lohoi bala manaunaua laveve kamana pole tadutadua kana manumanu laveve kirina. ");
INSERT INTO wiv_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Palaka kaka kua e delahania na Vule Tumonga, ia mara beta matoto a Vuvu ni lohoi bala kana manaunaua. Na pekato kua ia da e ngoro vuvua.” ");
INSERT INTO wiv_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","A Iesus e tani barae na vuna zia, dia ta tatani barae kirina, “Ia na vule zaha vona.” ");
INSERT INTO wiv_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Pale, a titinani Iesus kamani habu tazina dia ta lohu. Dia ka varimadiriai na hatama, dia ta geria kaka katiu ia hoho kete kohania ni gotala. ");
INSERT INTO wiv_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Na kabuna manumanu dia ta mimia lobia, dia ka tania vona, “Longoria, a katiti kamani habu tazi, ia mai habu livuku, dia ta mamadi ni hatama, dia ka huhule kiriniho.” ");
INSERT INTO wiv_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","A Iesus ki hulenidia, “Azei titinagu kamani habu tazigu?” ");
INSERT INTO wiv_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Pale, ia tunga lobi kara manumanu kua dia ta mimia lobia ki tani barae, “Hadavia! Kua habu titinagu kamani habu tazigu kua! ");
INSERT INTO wiv_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Azei kua e lala kete mumuri na lohoihoia ke Tamagu za, ia dia na tazigu, livukugu ia mai na titinagu.” ");
INSERT INTO wiv_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","A Iesus e vaketekete mule ve na hiripa loka a Galili. Na kabuna manumanu kapou matoto dia ta toro havutia, kubarae ia polo na bot katiu ia mia vona. Na bot kua e papati na loka, na kabuna manumanu dia ta varimadiriai na hiripa vazalea. ");
INSERT INTO wiv_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ia ki barikikinia polea luba ki vaketekete ni dia, ki tani barae, ");
INSERT INTO wiv_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Miu longoria! Kaka katiu e zahe kete muratania na harana vit. ");
INSERT INTO wiv_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","E mumuratania na harana vit na vanua, taza dia ta huru kara dala, pale, na manu kamahi dia ta mai hani hozovia. ");
INSERT INTO wiv_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Na vit taza dia ta huru kara palaka kedokedora beta garigari vona. Pebarae ki pizuzu tapu, na vuna beta garigari ni komokomo na palaka kua. ");
INSERT INTO wiv_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Pale, tania na voro ki zahe, ia tiba gatovia na vit kamahi kua, na vuna beta vorakadia ni dopa ni zuku, na vit kamahi kua dia ta varimateai. ");
INSERT INTO wiv_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Vit taza, dia ta huru kara pidaka vuvuna mota matangatanga. Na mota matangatanga ia galulu kini rara havutia vit kamahi, kini mara beta dia ne vua. ");
INSERT INTO wiv_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Harana vit taza dia ta huru kara garigari kemi. Dia ta galulu, dia kene vua. Taza taruhia palekedia e 30. Taza e 60. Taza e 100.” ");
INSERT INTO wiv_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","A Iesus ki tani barae ni dia, “Azei kua ni talingana vona, ia kete longoria polea kua.” ");
INSERT INTO wiv_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ba muri a Iesus ti ia kazihena, na kana 12 disaipel kamana nuhu taza ve dia ta hulenia kete tania ni dia na vuvuna barikikia kamahi kua. ");
INSERT INTO wiv_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","A Iesus ki tania ni dia, “A Vuvu ti vatunga kakava na vuvuna goloaloa kamahi kua e paritigi na poloka kingdom ke Vuvu ni miu. Palaka na nuhu kua na hatama, ia e barikikianga polea laveve ki valanga ni dia. ");
INSERT INTO wiv_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Kete kubarae, ‘Ia vata kua dia ta hahada palaka mara beta dia na hada lala, ia vata kua dia ta lolongo mara beta dia na lohoi lala; kua dia na hada dia na lohoi lala ia da dia te pokizia magalidia a Vuvu kini lohoi bala kadia manaunaua!’” ");
INSERT INTO wiv_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Pale, a Iesus ia hulenidia, “Beta miu na longo lala na barikikia kua, ai? Pele, da miu ta longo lala zingania na barikikia laveve? ");
INSERT INTO wiv_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Na kaka kena e mumuratania na harana vit, ia e vavazohia na polea ke Vuvu. ");
INSERT INTO wiv_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Manumanu taza dia ta balika harana vit kua e dua kara dala, kua na polea e vazoha na polokodia. Kamana dia ka longoria na polea, a Satan ia mai pele kakava pamuhia na polea kena e vazoha na polokodia. ");
INSERT INTO wiv_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Dia taza dia ta balika harana vit kua e huru kara garigari kedokedora. Kamana dia ka longoria na Kalohua Kemi, dia ta pele tapunia dia ka hilohilo matoto vona. ");
INSERT INTO wiv_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Palaka na vuna kua beta vorakadia ni zuku, beta dia na madi ni havarau. Tania na bizea kamahi o kua ti kati zahata voa ni dia na vuna kua dia ta bilip na polea, pale, dia ta poke. ");
INSERT INTO wiv_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Manumanu taza dia ta balika na harana vit kua e huru kara poloka mota matangatanga; ");
INSERT INTO wiv_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","palaka na vuna kua dia ta lolohoi vuvu marata na goloaloa kua bukuna garigari, ia mai na moni kamana goloaloa luba ki rukidia, dia ka mata parania goloaloa taza ve, pale, na goloaloa kua kini rara havutia na polea ke Vuvu, kini beta ni vua. ");
INSERT INTO wiv_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Manumanu taza dia ta balika na harana vit kua e huru kara garigari kemi. Kamana dia ka longoria na polea, dia ta pelea, dia kene vua. Taza palekedia e 30, taza e 60 dia taza e 100.” ");
INSERT INTO wiv_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","A Iesus ki tani barae ve ni dia, “Miu ta lala miu kata pelea lam ni hoho miu na taruhia na taura dis o na taura dongi? Karae beta miu na lala miu kata taruhia na mudina lam? ");
INSERT INTO wiv_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Na vuna, goloaloa laveve kena e litigianga ia da ba muri ki vabeleanga. Goloaloa laveve kena e kakarua, da ba muri ki bele kavakava. ");
INSERT INTO wiv_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kua kaka katiu ni talingana vona kua kete lolongo vona, pele, kete longoria polea kua.” ");
INSERT INTO wiv_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","A Iesus ki tani barae ve ni dia, “Polea kua miu ta longoria, ia miu kata lohoi kemikemihia. Mak kakei kua tu sikelnia kaka vona, ia na mak kena za da a Vuvu e sikelnimiu ve vona.” ");
INSERT INTO wiv_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ia ki tani barae ve ni dia, “Nuhu kua ti kadia goloa vona da e valanga luba ve ni dia; azei kua tani beta kana goloa vona, pitu kena e lohoia e kana vona, ia da e pele kakavanga vona.” ");
INSERT INTO wiv_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","A Iesus ki tani barae ve, “Na kingdom ke Vuvu ia e balika kua na kaka katiu kua e muratania na harana hai na garigari. ");
INSERT INTO wiv_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Na marigo o na dama, kua e ngongoro, o kua e lalama, na harana hai ia e pipizuzu ki gagalulu. Palaka ia beta ni lala e galulu ki paraha ziha. ");
INSERT INTO wiv_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Na garigari mule ia e katia na harana hai ki pizuzu ki galulu. Muga da na raurauna e bele ba muri na palekana, pale na palekana ia ti matuha. ");
INSERT INTO wiv_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ti vano na haningana vit ti matuha, pale, ia kirivia na naep, na vuna na nagi kara pelepelea na haninga ti bele.” ");
INSERT INTO wiv_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ia ki tani barae ve, “Da tolu ta vatunga muria na kingdom ke Vuvu na nazia matoto, o da tolu ta barikikini zingania polea tolu kata vatunga muria na kingdom ke Vuvu vona? ");
INSERT INTO wiv_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ia e balika na harana hamo kua e vazoha na garigari. Ia e dopa ki gala kote matoto na harana haninga laveve. ");
INSERT INTO wiv_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Palaka kua tani vazoha kua ni galulu, da e dopa ki horaha livutia haihai laveve kena na vanua. Da na dangadangana e kapopou, na manu kamahi dia ka mai dia ka bale na lirungata.” ");
INSERT INTO wiv_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","A Iesus e barikikinia polea luba ki vavaketekete na manumanu, e vala polea kua e dangea dia kata lohoi lala. ");
INSERT INTO wiv_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Beta kua boto katiu kete vala polea ni dia ni beta kete barikikinia polea. Palaka kua tani vano ni ia kazihena kamana kana disaipel kamahi za, ia ti tani kavakava na mining na polea laveve. ");
INSERT INTO wiv_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Kilangata kua ti garavi vona, a Iesus ia tania na kana disaipel kamahi, “Tolu kata pe poki vano kara paligena.” ");
INSERT INTO wiv_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Dia ta vatia kabuna manumanu kua, dia ta pelea a Iesus na bot kena a Iesus e polo ki mimia vona dia ta vano. Na bot taza ve dia ta kamadia. ");
INSERT INTO wiv_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Pale, na kavili kapou e rovo, na dazi kini vevele hoho kara kadia bot, pitu papa keteni mahitu. ");
INSERT INTO wiv_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","A Iesus, ia na murina bot, e ngoro ki tadaha na pilo. Dia ta mai vakongania, dia ka tania, “Tisa, beta nu lohoi ni dolu, kua tolu keteni golugolu?” ");
INSERT INTO wiv_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","A Iesus ia lama, ia pole kara kavili, ki tania kara dazi, “Malugunia, zodo nu manilo!” Pale, na kavili ia mate na manilo kini pati matoto. ");
INSERT INTO wiv_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ia ki tania kiridia, “E kuziha miu ka kuahi? Beta matoto za kamiu bilip?” ");
INSERT INTO wiv_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Dia laveve dia ta kuahi matoto, dia ka varihulei, “Kaka kua ia azei matoto? Na kavili kamana dazi dia ta longoria kana polea!” ");
INSERT INTO wiv_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","A Iesus kamana kana disaipel kamahi, dia ta vano bele na paligena loka ni Galili, na distrik kua e kohanga Gerasa. ");
INSERT INTO wiv_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Tania a Iesus ki zipa na bot, na kaka katiu e lala kete mimia na matmat, e ziho ni Iesus. Kaka kua na vule zaha e holiholia, ");
INSERT INTO wiv_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ki lala kete mimia na matmat. Beta kaka katiu ni dangea kete roti taduria. Beta ve na sen ni dangea kete paho taduria. ");
INSERT INTO wiv_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Dama mudomudo, dia ta rotia limana kamana kabena na sen, palaka ia e lala kete rabe hutuzia sen na limana ki hutu pahia ve kena na kabena. Togana motu, kubarae beta kaka katiu ni dangea keteni paho taduria. ");
INSERT INTO wiv_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Marigo, dama ia e lala kete vavana na poloka matmat kamahi ia mai na potupotuna kamahi, ni gigi hania livuhana, ki lala kete dala terehia livuhana na kedokedo. ");
INSERT INTO wiv_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","E madi zau pitu ki hadavia a Iesus, ia rovo ziho; ia padonia tutura na kabeni Iesus. ");
INSERT INTO wiv_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ia goe varitihi matoto ki tania, “Iesus, ho tuni Vuvu, kua e Paraha Kapou Matoto. Nazia kuli kirina ni niau? Na hizani Vuvu ta huleniho, taua nu vala varitihia ni niau!” ");
INSERT INTO wiv_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Kaka kua na vule zaha vona e tatani barae, na vuna a Iesus e tatania kirina, “Ho vule zaha ho, mai gotala na kaka kua!” ");
INSERT INTO wiv_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","A Iesus ki hulenia, “Hiza azei?” Ia ki kolia ki tania, “Hizagu a Armi. Na vuna hita ta luba.” ");
INSERT INTO wiv_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Pale, kini ma kini huhule haroinia a Iesus habuka beta a Iesus kete geri kakava na vule zaha kamahi na distrik kua. ");
INSERT INTO wiv_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Na kabuna boroboro taza dia ta hahanihani na hiripa potuna. ");
INSERT INTO wiv_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Na vule zaha kamahi kua dia ta hule haroinia a Iesus dia ka tani barae, “Gerihita na vano na boroboro kamahi kuari; tania hita na hoho ni dia.” ");
INSERT INTO wiv_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","A Iesus ia tara, na vule zaha kamahi kua, dia ta gotala na kaka kena, dia kene vano hoho na boroboro. Boroboro kamahi kua e kozoho kete 2,000, dia ta rovo varitihi tiro na hiripa potuna kara poloka naru, dia kene mahituhitu. ");
INSERT INTO wiv_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Nuhu kua dia ta hahada poto na boroboro kua, dia ta varihavai vanovano, dia ta tania na manumanu na taon ia mai na palaka laveve. Pale, manumanu dia ta lohu dia kata hadavia nazia kua e bele. ");
INSERT INTO wiv_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Tania na manumanu ki mai ni Iesus, dia ta hadavia na kaka kua muga na vule zahazaha luba matoto kua dia ta holiholia, bakana ti kemi kini zohozoho papa kini mimia. Dia ta hada baraenia, dia ka kuahi. ");
INSERT INTO wiv_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Nuhu kua dia ta hadavia na goloa kua a Iesus e katia, dia te ziuziu na manumanu na goloa kua e bele na kaka kua muga na vule zaha kamahi dia ta holiholia. Dia ka ziuhia ve ni dia na boroboro. ");
INSERT INTO wiv_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Kubarae na manumanu, dia ka hule haroinia matoto a Iesus kete vatia kadia distrik. ");
INSERT INTO wiv_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Tania a Iesus ki polo na bot, na kaka kua muga na vule zaha e holiholia, e hule haroi kete vano kamani Iesus. ");
INSERT INTO wiv_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Palaka a Iesus ia hava, ki tani barae vona, “Vamule vano kara ka malala ni habu ka, nu tania ni dia na goloa laveve kua na Paraha ti katia kete kodoniho, ia mai ve kua ti mahariho.” ");
INSERT INTO wiv_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Pale, na kaka kua ia vatidia kini vano kara palaka kamahi ni Dekapolis kini ziuziu na manumanu na nazia kua a Iesus e katia vona. Manumanu laveve kua dia ta longoria polea kana kaka kua, dia ta zipa zahe matoto. ");
INSERT INTO wiv_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Kilaka kua a Iesus e polo na bot ki pe poki mule kara paligena loka ni Galili. Kabuna manumanu kapou matoto, dia ta mai lupu kamana na vazalea. ");
INSERT INTO wiv_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Pale, na paraha kara haus lotu ke vuni Iuda katiu, hizana a Jairus. E hadavia a Iesus, ia dua kara kabena. ");
INSERT INTO wiv_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ki haloho matoto ni Iesus ki tania, “Tugu kote tavine keteni mate. Mai taruhia lima vona kete kemi ni mahuri mule.” ");
INSERT INTO wiv_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","A Iesus ia vano kamana. Na kabuna manumanu kapou dia ta muri ve ni Iesus, dia ka varidigi lobia. ");
INSERT INTO wiv_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Na pidaka dia, na tavine katiu topo e lelele kirina na krismas ti 12. ");
INSERT INTO wiv_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ti pari maratania bizea kapou na dokta luba. Kini varaga hozovia kana moni laveve ni dia, palaka beta za ni kekemi. Ti dopa kini zaha matoto kana mazahi. ");
INSERT INTO wiv_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Kamana ki longoria na rereki Iesus, ia mai muri ni Iesus na poloka kabuna manumanu, ia vakulia na klos ke Iesus. ");
INSERT INTO wiv_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Na vuna e lohoi barae, “Kua na vakulia za kana zohozohoa, da ta kemi.” ");
INSERT INTO wiv_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Pale, na topo kua e lelele kirina ia koga pamuhi, ia hatunia habuka ti kemi kava. ");
INSERT INTO wiv_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","A Iesus ia hatuni pamuhia habuka kana matuhanga e vatia livuhana. Ia tare poki ki hulenia na kabuna manumanu, “Azei e vakulia kagu zohozohoa?” ");
INSERT INTO wiv_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Kana disaipel kamahi dia ka tania vona, “Tu hada na kabuna manumanu kua dia ta varidigidigi lobiho, e kuziha ku hule barae, ‘Azei e vakuliau?’” ");
INSERT INTO wiv_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Palaka a Iesus ia ma ki hahada lobi kete hada azei matoto e vakulia. ");
INSERT INTO wiv_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Na tavine kua e lala goloa kua e bele vona, ia mai, e kuahi zahazaha matoto kini vanivani, ia mai dua kara kabeni Iesus, ia tani kakava na goloa laveve ni Iesus. ");
INSERT INTO wiv_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","A Iesus ia tania vona, “Tugu, ka bilip ti vamahuriviho. Vano kamana magali kemia. Kava tu kemi.” ");
INSERT INTO wiv_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","A Iesus e ba popole barae, na manumanu taza dia ta pe na ruma ke Jairus, na paraha kara haus lotu ke vuni Iuda, dia ka tania, “Tu tavine ti mate, taua nu ma kaborania na tisa.” ");
INSERT INTO wiv_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Palaka a Iesus beta ni longo murimuria kadia polea, ia tani barae na paraha kara haus lotu ke vuni Iuda kua, “Taua nu kuahi, ma vaka maroro.” ");
INSERT INTO wiv_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","E hava manumanu taza ve kete kamana. E pelea za a Pita, a Jems, a Jon tazini Jems. ");
INSERT INTO wiv_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Dia ta vano bele na ruma kana paraha kara haus lotu ke vuni Iuda kua. A Iesus ki hadavia manumanu kua dia ta katia valalanga kapou. Dia ta tangi dia ka haloho kapopou. ");
INSERT INTO wiv_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ia vana hoho, ia tania kiridia, “Kara zia miu ka vavalala? Nazia miu ta tatangizia? Na kapiru beta ni mate, ia e ngongoro za kuari.” ");
INSERT INTO wiv_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Dia ta nongonia. A Iesus ia geridia laveve dia ta gotalatala. Ia pelea na tamana kapiru kamani tinana, ia mai na kana disaipel tolu kua dia ta kamana. Dia kene hoho kara palaka kua na kapiru e ngongoro vona. ");
INSERT INTO wiv_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","A Iesus ia pahoria limana kapiru ki tania vona, “Talita kum!” (Polea kua mining vona e kubarae, “Tavine kote, hau ta tania ni niho, lama!”) ");
INSERT INTO wiv_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Na tavine kote kua ia lama pamuhi kini vanavana, krismas kana tavine kua e 12. Na goloa kua e katidia, dia ka zipa zahe matoto vona. ");
INSERT INTO wiv_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ia tani vatuharia matoto ni dia, beta dia kata kalohulohunia goloa kua na kaka katiu, pale, ia geridia dia kata vala haninga na tavine kua ni hania. ");
INSERT INTO wiv_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","A Iesus e vatia na malala kua, ia vamule kara kana taon a Nasaret, kamana kana disaipel kamahi. ");
INSERT INTO wiv_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Pale, na Sabat ia vaketekete na poloka haus lotu ke vuni Iuda. Dia luba dia ta longoria kana polea dia ka zipa zahe. Dia ka varihulei, “Kaka kua e pelea ni ve matoto na save kua? Na save zia matoto kua? Ki kati zingania ve na mirakel kamahi kua? ");
INSERT INTO wiv_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Tolu ta lala kaka kua ia na kapenta kua, na tuni Maria. Habu tazina kua a Jems, a Iosep, a Iudas ia mai a Saimon. Habu livuka ve, kua dia ri kua ve kamadolu.” ");
INSERT INTO wiv_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","A Iesus ki tania ni dia, “Na profet e lala kete hahada zaheanga na malala motumotu. Palaka na kana taon mule ia mai na pidaki habu vineka matoto, ia mai na kana ruma mule, ia beta ni lala kete hahada zaheanga.” ");
INSERT INTO wiv_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Pale, a Iesus kini beta ni katia mirakel katiu na malala kua. Palaka e taru langaria limana na huduna manumanu taza za kua na mazahi ni dia, dia ka kemi mule. A Iesus e tara vilu matoto, kua beta dia na bilip vona. Pale, a Iesus kini vavana lobi kini vaketekete na malala kotekote kamahi. ");
INSERT INTO wiv_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ia kohania kana 12 disaipel kamahi dia ta mai vona, ia geridia rua rua, ia vala matuhanga ni dia, dia kata pele kakava vule zaha kamahi. ");
INSERT INTO wiv_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ki tani barae ni dia, “Tabarae miu na pelea goloa katiu kamamiu na kamiu vavananga, miu pelea kamiu toho za. Taua miu na pelea bret, beke, o moni na kamiu poket kamahi. ");
INSERT INTO wiv_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Miu zohoria sandel, palaka tabarae miu na lohoria siot ni rua. ");
INSERT INTO wiv_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Kua kini koi tadura miu na ruma katiu, miu mia na ruma kena ki mule na dama miu ka vatia malala kena. ");
INSERT INTO wiv_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Kua malala katiu kini beta ni koi tadurimiu o ni beta dia na longoria kamiu polea, miu pali tubinia na havuhavu na kabemiu. Dia kata hada lala habuka, beta dia na katia moge pa.” ");
INSERT INTO wiv_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Dia ta vano dia kene vala polea na manumanu, habuka manumanu dia kata zuka tapunia kadia moge zahazaha. ");
INSERT INTO wiv_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Dia ka pele kakava vule zahazaha luba, dia ka bizia oil na bakana manumanu luba kua mazahi ni dia, dia ka kemi mule. ");
INSERT INTO wiv_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","A King Herot ti longoria na rereki Iesus, na vuna na hizani Iesus ti rere kini vana lobia matoto malala. Manumanu taza dia kene tatani barae, “A Jon kakanaka baptais ti lama mule na matea, kubarae ia kini kana matuhanga vona kete kakatia na mirakel kamahi kua.” ");
INSERT INTO wiv_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Dia taza dia ta tania, “Ia a Elaija.” Taza dia ta tania, “Ia na profet katiu, vinaka profet katiu ni dia kua bukuni varira.” ");
INSERT INTO wiv_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Palaka a Herot e longoria polea kamahi kua, ki tania, “A Jon, kaka kua ta le hutuzia lohora, ti valamari muleha na matea!” ");
INSERT INTO wiv_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Na vuna a Herot ia mule e geu dia ka paho taduria a Jon, dia ka rotia dia ka taruhia na karabus. Ia e kubaraenia a Jon, na vuna ni Herodias. A Herodias ia na goni Filip, tazini Herot. A Herot kini kabania. ");
INSERT INTO wiv_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Na vuna a Jon ia ma ki tatania ni Herot kubarae, “E beta ni mahoto koto kabania goni tazi.” ");
INSERT INTO wiv_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Kubarae a Herodias magalina ki varitihi matoto kiri Jon ki kulina matoto kete hubi matehia a Jon palaka, ki mara beta, ");
INSERT INTO wiv_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","na vuna a Herot e lala kete hada zahenia matoto a Jon ki mamadi karikari ke Jon. Na vuna ia e lala habuka a Jon ia na kaka tumonga ki kaka mahoto. Ki lala kete kukulina ve kete lolongoria a Jon kete vavala polea, palaka kua kini lolongoria polea ke Jon e lala kete vavairohia matoto magalina. ");
INSERT INTO wiv_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Pale, na dama katiu kua ti bele kini volo papa kiri Herodias. Na betdei ke Herot, ia katia hanihania kapou matoto ki vangania pararaha na gavman, ia mai na opisa kamahi na armi, ia mai na nuhu kua dia ta risman dia ka hizanga ni Galili. ");
INSERT INTO wiv_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","A tuni Herodias tavine e mai hoho ki paparau, a Herot kamana nuhu kua dia ta hanihani kamana, dia ta matinia matoto. A King ki tania na tavine tizula kua, “Kua ni kuli kara goloa katiu, huleniau, da ta vala za ni niho.” ");
INSERT INTO wiv_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ia ki mapamapa ki tania vona, “Nazia matoto tu huleniau kirina, da ta vala ni niho. Kua ni kuli koto hada na paligena kantri kua hau ta hada vona, ia da ta vala za ni niho.” ");
INSERT INTO wiv_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Pale, na tavine kua ia vano hulenia a titinana ki tani barae, “Nazia da ta hulenia kirina?” A titinana ki tania, “Hulenia kara bakani Jon kakanaka Baptais.” ");
INSERT INTO wiv_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Na tavine kua ia vamule pamuhi na king ia tani barae, “Hau kuligu kua nina za kua, koto tabira bakani Jon kakanaka Baptais na pelete katiu nu vala ni niau.” ");
INSERT INTO wiv_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","A King lohora ki zaha matoto ni Jon, palaka na vuna kava ti mapamapa kamu na matana manumanu kua dia ta lohu kara hanihania, kubarae beta ni hava na hulea kana tavine kua. ");
INSERT INTO wiv_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Pale, ia geri pamuhia na gat katiu kete pelea bakani Jon. Na gat kua ia kara haus karabus, ia le hutuzia bakani Jon; ");
INSERT INTO wiv_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ia tabira na pelete katiu ia vala na tavine kua, na tavine kua ia pelea vano ia vala ni titinana. ");
INSERT INTO wiv_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Kamana na disaipel ke Jon dia ka longoria habuka a Jon ti le hutuza lohora, dia ta vano pelea podana, dia ta vano tavunia. ");
INSERT INTO wiv_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Na apostel kamahi ke Iesus dia ta mai mia lobia dia ka tatania vona na galanga kua dia ta katia, dia ka tania ve vona na polea laveve kua dia ta vala na manumanu. ");
INSERT INTO wiv_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Na manumanu luba dia ka mai dia ka vavano ni dia, ki kubarae dia ka lokia dia kata hanihani, pale, a Iesus ia tani barae ni dia, “Miu mai kamaniau tolu na kara palaka katiu kua kete tolu kazihedolu, tolu na hivu pitu.” ");
INSERT INTO wiv_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Pale, dia ta polo na bot dia kene vano kara palaka kua beta kaka vona. ");
INSERT INTO wiv_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Palaka manumanu luba dia ta hadavidia kua dia ta vavana, dia ka hada lala dia; kubarae dia ta rovo pe na dala. Manumanu kua dia ta pe na taon laveve, dia ka vamuga vano bele na palaka kua a Iesus kamahi dia ta kikirina. ");
INSERT INTO wiv_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Kamana a Iesus ki vaki ki zipa na bot, ki hadavia kabuna manumanu kapou kua, lohora e zaha matoto ni dia, na vuna dia ta balika sipsip kua beta kaka kete hada poto ni dia. Pale, ia kini vaketekete ni dia na goloa luba. ");
INSERT INTO wiv_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ti garavi matoto, pale, kana disaipel kamahi dia ta mai vona dia ta tania vona, “Keteni marigo, palaka kua beta ve malala katiu ni kozoho vona. ");
INSERT INTO wiv_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Geria manumanu kamahi kua dia na vano. Dia kata vano kadea hadia haninga na malala kamahi kua kozoho dia na hania.” ");
INSERT INTO wiv_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Palaka a Iesus e tania, “Miu mule miu vanganidia.” Dia ka tani barae vona, “E kuli hita kata vano varaga 200 kina kara bret, hita na vanganidia vona?” ");
INSERT INTO wiv_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","A Iesus ki hulenidia, “E ziva bret kena ni miu? Miu vano pari vutuhia.” Kamana dia ka hazenia, dia ta tania vona, “Na bret e lima, na hiha e rua.” ");
INSERT INTO wiv_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","A Iesus ia geridia, dia kata tania na manumanu dia na loli na grup kamahi na huduna raburabu. ");
INSERT INTO wiv_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Pale, dia ta loli na grup kamahi. Grup taza e 100 manumanu vona, taza e 50. ");
INSERT INTO wiv_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Pale, ia pelea na bret lima kua kamana hiha rua. Ia tunga zahe kara lagato. Ia hate motunia a Vuvu. Ia bara valahia bret. Pale, ia vala na kana disaipel kamahi. Dia kata vala na manumanu. E vazenia ve na hiha rua kua ni dia ve. ");
INSERT INTO wiv_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Dia laveve dia ta hanihani magalidia ki kurukuru. ");
INSERT INTO wiv_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Na apostel kamahi dia ka gorea na kolopi e 12 ki vonuvonu na kalangara bret kamana hiha kua. ");
INSERT INTO wiv_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Na naba ni tamomohane kua dia ta hanihani e 5,000. ");
INSERT INTO wiv_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","A Iesus ia geria kana disaipel kamahi dia ta baribari polopolo na bot dia kata vamuga vano kara paligena ni Betsaida. Ia kete geri mulehia na kabuna manumanu kapou kua. ");
INSERT INTO wiv_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Kamana ki geria na manumanu dia kene vanovano, ia vori kara potuna kete lotu. ");
INSERT INTO wiv_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ti marigo, na bot kava ti mule na pidaka loka. A Iesus ia e ba vovona kazihena na palaka kua. ");
INSERT INTO wiv_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ia ki hadavia habuka na disaipel kamahi dia te lokia matoto vazulanga, na vuna na kavili e mai matoto na mugadia. Ti kokozoho keteni dama, a Iesus ia vavana na huda loka ia zahe ni dia. E lohoia kete vana hutu ni dia ni vano. ");
INSERT INTO wiv_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Palaka kamana na disaipel kamahi dia ka hadavia kua e vavana na huda loka, dia ta lohoia dia ka tania ia na hanitu. Dia ta varigigiai. ");
INSERT INTO wiv_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Na vuna dia laveve dia ta hadavia dia ka kuahi. Palaka, a Iesus ia pole tapu kamadia, ki tani barae, “Paho taduria hatemiu! Hau kua. Taua miu na kuahi.” ");
INSERT INTO wiv_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Pale, ia polo ni dia na huduna bot, na kavili ia mate. Na disaipel kamahi dia ta lohoi toritori matoto, ");
INSERT INTO wiv_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","na vuna beta ve dia na lohoi lala na mining na mirakel kua e vangania manumanu e 5,000; kadia lohoihoia ma beta ni nap dia kata lohoi lala. ");
INSERT INTO wiv_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Dia ta pe poki kara paligena, dia ta bele ni Genesaret, dia ta pitia bot ia pati. ");
INSERT INTO wiv_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Tania dia ka zipazipa na bot, manumanu dia ta hada lala pamihia a Iesus. ");
INSERT INTO wiv_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Dia ta rovo lobi na malala laveve, dia ta lugaluga nuhu kua e mazahitidia na kadia huda dongi kamahi, dia ta vano kara palaka kua dia ta longoria e tanga a Iesus ia vona. ");
INSERT INTO wiv_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Na malala laveve ia mai na taon kamahi, o na malala kamahi kua na hiripa taon, kua a Iesus e bele vona, manumanu dia ta vangorea nuhu kua mazahi ni dia na palakana lupua. Dia ka hule haroinia a Iesus habuka nuhu kua e mazahitidia, kete nap dia kata vakulia kana hiripa klos. Pale, nuhu laveve kua dia ta vakulia, ia dia ta kemi mule. ");
INSERT INTO wiv_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","A vuni Parisi kamahi kamana tisa kamahi kara lo taza, dia ta pe ni Ierusalem, dia ta mai lupu dia ka mia lobia a Iesus. ");
INSERT INTO wiv_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Dia ka hadavia kana disaipel taza dia ta hahanihani, ki beta dia na muga vazuguvia limadia. ");
INSERT INTO wiv_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Na vuna, a vuni Parisi kamahi kamani vuni Iuda laveve, dia ta lala dia kata mumuri na maki ke habu tubudia, habuka mara beta dia na hanihani veta, ma dia ta muga vazuguvia limadia. ");
INSERT INTO wiv_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Kua dia na pe na maket, dia na vamule, ia mara beta dia na hanihani, ma dia ta muga matu. Dia ka mumuri ve na moge luba kua dia ta pelea ni habu tubudia habuka, na vazuguzugua na kap, sospen, dis ia mai na dongi. ");
INSERT INTO wiv_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Kubarae, a vuni Parisi kamahi kamana tisa kamahi kara lo kamahi, dia ta hulenia a Iesus, “E kuziha ki beta ka disaipel kamahi dia na mumuri na maki ke habu tubudolu? Limadia e molumolua, dia ka hahanihani.” ");
INSERT INTO wiv_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","A Iesus ki kolia kadia polea ki tania, “A profet Aisaia e tani matotonia polea kirimiu, nuhuta vairukua kua, kilaka kua e vapolungania na polea kana Paraha ki tani barae, ");
INSERT INTO wiv_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","‘Manumanu kua dia ta lolotu veta ni niau; palaka dia ka vavaketea na lohoihoia kana kaka vetanga na manumanu, dia ka tania ia na kagu polea. ");
INSERT INTO wiv_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Miu te vala lamamiu kara lo ke Vuvu, miu kene papaho poto na lohoihoia kana kaka vetanga bukuna garigari.’” ");
INSERT INTO wiv_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","A Iesus ki tani barae ve ni dia, “Miu te paria dalangana vona kua, miu kata pala katia na lo ke Vuvu, miu na mumuri na kamiu mogemoge mule. ");
INSERT INTO wiv_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Na vuna a Moses e tani barae, ‘Hada zahenia kamama kamani katiti,’ ia mai, ‘Azei kua tani delahania tamana kamani titinana, ia kete hubu matoa.’ ");
INSERT INTO wiv_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Palaka miu ta vaketea na manumanu kubarae, kua kaka katiu ni kana goloa katiu vona kua e dangea kete kodonia tamana o titinana vona, palaka kua ta ia ni tani barae, ‘Goloa kua e Korban,’ (mining vona kubarae, ia ti vala ke Vuvu), ");
INSERT INTO wiv_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","pale, da ia ti beta ve kete katia goloa katiu kua kete kodonia tamana o titinana. ");
INSERT INTO wiv_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Kubarae, miu te mumuri na mogemoge kamahi kua miu ta pelea ni habu tubumiu, miu kene vaka taduria na polea ke Vuvu. Miu ta lala miu kata kakatia moge luba mata barae kua.” ");
INSERT INTO wiv_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","A Iesus ia kohani mulehia na kabuna manumanu dia ta mai vona ia tani barae, “Miu laveve kua, miu longoria, miu na lohoi lala. ");
INSERT INTO wiv_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Mara beta goloa katiu kua ni pe na hatama ni hoho na poloka kaka ni katia kaka ni molumolua. Palaka, nazia kua e pe na poloka kaka ki gotala, ia e katia kaka ki molumolua.” ");
INSERT INTO wiv_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ba muri a Iesus ti vatia manumanu kini hoho kara ruma, na kana disaipel kamahi dia ta hulenia na mining na barikikia na polea kua. ");
INSERT INTO wiv_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","A Iesus ki tania, “E miu ma beta za miu na lohoi lala? Beta miu na lala kua goloaloa bukuna hatama e hoho na kaka, e beta ni dangea kete katia kaka ni molumolua? ");
INSERT INTO wiv_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Na vuna, na haninga beta ni hoho na lohoihoia kana kaka, beta e hoho na paro kapou, pale, ia kokonia.” (Na polea kua a Iesus e tania, ia ti tania habuka haninga laveve ia e “klin.”) ");
INSERT INTO wiv_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","A Iesus ki tani barae ve, “Nazia kua e pe na poloka kaka ki gotala, ia za e lala kete katia kaka ki molumolua. ");
INSERT INTO wiv_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Na vuna kua na poloka kaka, kua na kana lohoihoia, ia na lohoihoia zahazaha kara, magali buhua, kara mata vanahoa, kara hubi matematea na kaka, vaitagoa kamana gona kaka motu, ");
INSERT INTO wiv_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","mogepa ngaroa, moge zahazaha kamahi, mogepa vairukua, mogepa magali zahanga, mogepa hada potipotia, mogepa varidelaha, mogepa kona zahezahea, ia mai na mogepa bikhet kamana valahanga. ");
INSERT INTO wiv_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Moge zahazaha laveve kua dia ta pe na poloka kaka, dia ka katia kaka ki molumolua.” ");
INSERT INTO wiv_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Pale, a Iesus ia vatia palaka kua ia vano bele na bage kozoho kiri Tair. A Iesus ia hoho na ruma katiu. E beta ni kulina kaka katiu kete lala ia vona. Palaka ki mara beta ni paritigi. ");
INSERT INTO wiv_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Na tavine katiu tuna tavine na vule zaha e holiholia, kamana ki longoria habuka a Iesus ia na ruma kua, ia mai ia dua kara kabeni Iesus. ");
INSERT INTO wiv_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Na tavine kua e bukuni Grik, ki valohua ni Fonisia ni Siria. Ia ki hule haroinia matoto a Iesus kete pele kakava na vule zaha na tuna tavine. ");
INSERT INTO wiv_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Palaka a Iesus ki tania vona, “Muga vatia kapirupiru dia ka hanihani magalidia ni kurukuru, na vuna beta ni mahoto kete peola haninga he kapirupiru ni varaganga he kauaua.” ");
INSERT INTO wiv_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Na tavine kua ki tania, “E limoha, Paraha, palaka na kauaua ve na taura tebol dia ta lala dia kata hahania momota haninga he kapirupiru ve!” ");
INSERT INTO wiv_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","A Iesus ia tania vona, “Na vuna kua tu koli baraenia kagu polea, pele vano; na vule zaha ti vatia tu tavine kava.” ");
INSERT INTO wiv_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Na tavine kua ia vamule kara ruma. Ia hadavia tuna e ngongoro na dongi, na vule zaha ti vatia kava. ");
INSERT INTO wiv_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Pale, a Iesus ia vatia na bage kua kiri Tair. Ia vano pe hutu ni Saidon, ki dopa vano na palaka kamahi kua ni Dekapolis, ia ziho bele na loka a Galili. ");
INSERT INTO wiv_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Manumanu taza, dia ta pelea na kaka katiu ki mai ni Iesus, na talingana e doto, ki manga ve. Dia ta gugia a Iesus kete taru limana na huduna kaka kua. ");
INSERT INTO wiv_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Pale, a Iesus ia pelea kaka kua hiro ta pe kakava, zau pitu na manumanu. A Iesus ia taru kukuna hoho na talingana ruarua. Ba muri ia livi kara kukuna, ia vakulia na lavena kaka kua, ");
INSERT INTO wiv_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ia tunga zahe kara lagato. Ia hivu kanga, ia tania kara kaka kua, “Epata!” Polea kua e tani barae, “Ngapa!” ");
INSERT INTO wiv_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Na talingana kaka kua ia longo. Na lavena ia pakoko, kini pole papa pamuhi. ");
INSERT INTO wiv_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","A Iesus ia tani vatuharia ni dia, habuka beta dia kata kalohunia goloa kua na kaka katiu. A Iesus e bada ki tataledia, palaka dia te dopa kalohunia pare na goloa kua e bele. ");
INSERT INTO wiv_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Manumanu dia ta zipa zahe, dia ka lohoi tori matoto. Dia ka tania, “Goloa laveve kua e katia, ia e kemi za. E kati kemihia nuhu kua talingadia e doto dia ka longo mule, nuhu kua dia ta mangamanga dia ta pole mule!” ");
INSERT INTO wiv_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Na dama katiu ve na kabuna manumanu kapou dia ta mai lupu mule ve. Pale, ti beta haninga dia keteni hania, a Iesus ia kohania kana disaipel kamahi dia ta mai vona ia tani barae ni dia, ");
INSERT INTO wiv_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Lohorogu zaha na manumanu kamahi kua. Kava dia te mia kamaniau dama ti tolu kini beta goloa dia kata hania. ");
INSERT INTO wiv_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ta na geri mulehidia kamana hadia vitolo, da matadia e lolovio na dala dia ta dua, na vuna taza ni dia, dia ta pe zau dia ka mai.” ");
INSERT INTO wiv_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Kana disaipel kamahi dia ka hulenia, “Da tolu ta paria bret ni ve na palaka kua beta kaka vona, tolu ka vanganidia vona?” ");
INSERT INTO wiv_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","A Iesus ki hulenidia, “Bret ziva ni miu?” Dia ta tania, “E 7.” ");
INSERT INTO wiv_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Pale, ia tania na manumanu dia ta loli na garigari. Ia pelea na bret e 7 kua, ia hate motunia a Vuvu. Ia bara vulahia, ia vala na kana disaipel kamahi dia kata vazenia na manumanu; na kana disaipel kamahi dia ta vazenia. ");
INSERT INTO wiv_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Na hiha kote taza ve ni dia. A Iesus ia hate motunia a Vuvu. Ia tania na kana disaipel kamahi dia kata vazenia ve na hiha kamahi kua. ");
INSERT INTO wiv_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Dia ta hania magalidia ki kurukuru. Muri vona na disaipel kamahi dia ta gorea kalangalangara haninga kua na kolopi e 7. ");
INSERT INTO wiv_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","E hada barae manumanu e 4,000 kilangata kua. Pale, a Iesus ia geridia, dia kene vamulemule. ");
INSERT INTO wiv_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ia polo pamuhi na bot kamana kana disaipel kamahi, dia kene vano kara distrik a Dalmanuta. ");
INSERT INTO wiv_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","A vuni Parisi taza dia ta mai ni Iesus, dia kene vavaigege kamana. Dia ka lohoia dia kata pado rukia. Dia ta hulenia kete katia mirakel katiu, kete vatunga habuka a Vuvu e vala matuhanga vona. ");
INSERT INTO wiv_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","A Iesus e hivu kanga na vulena ki tani barae, “Kara zia manumanu na tauna kua dia ka huhule kara mirakel? Hau ta tani matotonia ni miu. Da mara beta matoto dia na hadavia mirakel katiu.” ");
INSERT INTO wiv_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Pale, ia vala lamana ni dia kini polo na bot, kini vano kara paligena loka ni Galili. ");
INSERT INTO wiv_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Na disaipel kamahi dia ta lohoi bala dia kata pelea na bret. Na bret katiu matoto dia ta pelea kamadia na huduna bot. ");
INSERT INTO wiv_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","A Iesus ki tani vatuharia polea ni dia kubarae, “Miu lohoimiu na yis ke vuni Parisi kamana ke Herot.” ");
INSERT INTO wiv_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Pale, na disaipel kamahi dia ta pole na pidaka dia mule dia ka tani barae, “Ia e tatani barae kuari na vuna beta bret ni dolu.” ");
INSERT INTO wiv_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","A Iesus ti lala polea kua dia ta tatania, ia hulenidia, “E kuziha miu ka popole na vuna kua beta bret ni dolu? Ma beta za miu na hada lala? Ma beta za miu na lohoi lala goloa? Bakamiu ba haharodo? ");
INSERT INTO wiv_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Matamiu vona, palaka beta miu na hahada, talingamiu vona, palaka beta miu na lolongo? Miu te lohoi bala? ");
INSERT INTO wiv_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Kilangata kua ta bara vulahia bret lima hana manumanu kua e 5,000, kolopi ziva na kalangara haninga miu ta gorea?” Dia ka tania, “E 12.” ");
INSERT INTO wiv_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Pele kilaka kua ta bara vulahia bret e 7 hana manumanu e 4,000, kolopi ziva na kalangara haninga miu ta gorea?” Dia ka tania, “E 7.” ");
INSERT INTO wiv_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ia ki tania ni dia, “E ki ma beta za miu na lohoi lala?” ");
INSERT INTO wiv_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","A Iesus kamana kana disaipel kamahi dia ta vano bele ni Betsaida, pale, na manumanu taza dia ta pelea na kaka katiu matana e keu, ki mai ni Iesus dia ka huhule haroinia a Iesus kete vakulia. ");
INSERT INTO wiv_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","A Iesus ia pahoria limana kaka kua matana e keu, hiro ta gotala na malala. Pale, ia livi kara matana kaka kua, ia taruhia limana rua na matana, ia hulenia, “Tu hadavia goloa katiu?” ");
INSERT INTO wiv_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Na kaka kua ki tada, ki tania, “Hau ta hadavia manumanu, palaka dia ta hada balika haihai kamahi kua e vavana.” ");
INSERT INTO wiv_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","A Iesus ia taru mulehia limana karua na matana kaka kua. Pale, na matana kaka kua ia kavakava, matana ia kemi, kini hada vutuhia goloaloa laveve. ");
INSERT INTO wiv_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Pale, a Iesus ia geri mulehia kete vamule kara kana ruma, ki tani barae ve vona, “Tabarae nu vano kara malala.” ");
INSERT INTO wiv_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","A Iesus kamana kana disaipel kamahi dia ta vano kara malalala kamahi kua na distrik ni Sisaria Filipai. Dia ta vano na dala ia hulenidia, “Manumanu dia ta tania hau azei matoto?” ");
INSERT INTO wiv_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Dia ka tania vona, “Taza dia ta tania ho a Jon kakanaka Baptais, taza dia ta tania ho a Elaija, taza ve dia ta tania ho katiu ni dia kua na profet kamahi kua bukuni varira.” ");
INSERT INTO wiv_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ia ki hulenidia, “Pele miu mule, miu ta lohoia miu ka tania hau azei matoto?” A Pita ki tania, “Ho a Kristus.” ");
INSERT INTO wiv_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Pale, a Iesus ia tani vatuharia ni dia, habuka tabarae dia na kalohu horu na manumanu habuka ia, a Kristus. ");
INSERT INTO wiv_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Pale, a Iesus ia ti varivuvu keteni tatania na kana disaipel kamahi habuka, na Tuna Kaka da e luga bizea luba, na pararaha ke vuni Iuda, ia mai na hetpris kamahi, ia mai na tisa kamahi kara lo, da dia ta pole katia, dia ka hubi matehia. Muri na dama tolu ia mahuri mule. ");
INSERT INTO wiv_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","A Iesus e pole kavakava matoto na goloa kua. Kubarae a Pita ia pelea a Iesus, vano hiro kazihehiro, ia pole kiri Iesus. ");
INSERT INTO wiv_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Palaka a Iesus e tare poki kara kana disaipel kamahi, ia pole kiri Pita, ki tania, “Satan, vano nu madi na lamagu! Beta nu mumuri na lohoihoia ke Vuvu. Tu mumuri na lohoihoia kana kaka.” ");
INSERT INTO wiv_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Pale, ia kohania na kabuna manumanu, ia mai kana disaipel kamahi ve ki tania, “Azei kua e kulina kete muri ni niau, ia kete vazihoni mulehia, ia luga kana kruse ia muri ni niau. ");
INSERT INTO wiv_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Na vuna azei kua tani lolohoi marata na kana mianga kete kemi, ia da e paho kavu kirina, palaka azei kua tani mazukenia kana mianga pa na vuna ni niau ia mai na vuna na Kalohua Kemi, ia da e mahuri. ");
INSERT INTO wiv_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Da e kemi ziha kana kaka kua tani kana goloaloa kemikemi laveve vona ri na garigari, palaka ia mule ti golu. ");
INSERT INTO wiv_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Nazia matoto da tu vala, kua koto kade mulehia vule vona? ");
INSERT INTO wiv_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Manumanu bukuna tauna kua, dia te zuka tapunia a Vuvu, dia kene kakatia moge zahazaha luba. Kubarae, kua kaka kini puae ni niau ia mai ve na kagu polea na poloka manumanu kua, ia da na Tuna Kaka ve da e puae ve vona kua ta ia ni vamule kamana engel tumonga kamahi na poloka glori ke Tamana.” ");
INSERT INTO wiv_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","A Iesus ia tania ni dia, “Hau ta tani matotonia ni miu, taza ni miu kua miu ta varimadiriai ri kua, da ma beta miu na mate miu ka hadavia na kingdom ke Vuvu kua da e mai kamana matuhanga.” ");
INSERT INTO wiv_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Muri na dama e 6, a Iesus e pelea a Pita, a Jems kamani Jon. Ia vamuga ni dia, dia kene vori kara potuna horaha katiu, dia kazihedia za na palaka kua. Pale, dia ta hahada barae, na livuhani Iesus ia pokizia. ");
INSERT INTO wiv_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Kana zohozohoa ki puzo varitihitihi matoto, balika laet. Mara beta kaka katiu kua na garigari ni nap kete katia lavalava ni hada puzopuzoa barae kua. ");
INSERT INTO wiv_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","A Elaija kamani Moses hiro ta bele valutu, hiro kene popole kamani Iesus. ");
INSERT INTO wiv_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","A Pita ia tani barae ni Iesus, “Tisa, e kemi matoto ki tolu ri kua. Hita kata habatia kape tolu. Katiu ka, katiu ke Moses, mai katiu ke Elaija.” ");
INSERT INTO wiv_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","A Pita beta ni lala nazia kete tania na vuna zia, dia ta kuahi matoto. ");
INSERT INTO wiv_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Pale, na habuhabu ia mai kari havutidia. Na halingana kaka katiu e pe na habuhabu kua ki tani barae, “Na Tugu kena. Kuligu matoto kirina. Miu longo kirina!” ");
INSERT INTO wiv_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Dia ta tunga toritori pamuhi, palaka beta ve dia na hada kaka katiu kamadia, a Iesus za. ");
INSERT INTO wiv_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Dia te titiro mule na potuna, a Iesus ia vala polea matuha ni dia habuka tabarae dia na tania na kaka katiu na goloa kua dia ta hadavia, ki vano ki ba muri na Tuna Kaka ti mahuri mule na matea. ");
INSERT INTO wiv_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Dia ta ma lohoi taduria goloa kua ki ma ngoro kadia za, dia ka varihulei habuka, e tani zingania polea kua, “mahuri mule na matea.” ");
INSERT INTO wiv_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Dia ta hulenia, “E kuziha na tisa kamahi kara lo dia ka tani barae, a Elaija da e vamuga ki mai?” ");
INSERT INTO wiv_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","A Iesus ki tania, “E matoto, da a Elaija e vamuga ki mai kete vahotovia goloa laveve ni malimu. Palaka, e kuziha dia ka vapolu baraenia na polea kana Paraha, habuka na Tuna Kaka da e luga bizea kapou, manumanu dia ka pole zahatia? ");
INSERT INTO wiv_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Palaka ta tania ni miu, A Elaija kava ia ti mai, dia kene katia goloaloa laveve kena dia ta lohoia dia kata katia vona, habuka kua e vapolunganga na poloka buk ke Vuvu ki tanga.” ");
INSERT INTO wiv_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Kamana a Iesus, a Pita, a Jems, a Jon dia ta ziho bele na disaipel taza ve, dia ta hadavia na kabuna manumanu kapou dia ta mamadi lobidia, na tisa kamahi kara lo ke Moses dia ka vaigege kamana disaipel kamahi. ");
INSERT INTO wiv_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Tania na manumanu laveve kua dia ka hadavia a Iesus dia ta ridi, dia ka rovo dia kata hilohilonia. ");
INSERT INTO wiv_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ia hulenidia, “Nazia miu ta vaigege kamadia vona?” ");
INSERT INTO wiv_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Kaka katiu na poloka manumanu kua e tania, “Tisa, hau ta pelea tugu kete mai ni niho, vule katiu e holiholia ki katia kini mangamanga. ");
INSERT INTO wiv_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kua kini bele kirina, e lala kete varaga kara garigari, hivohivo ki gotala na havana, ki tanga tadu bada, ki lala kete dadaea. Ta hulenia ka disaipel kamahi, dia kata pele kakava na vule kua, palaka dia ta lokia.” ");
INSERT INTO wiv_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","A Iesus ki tania, “Miu manumanu na tauna kua beta kamiu bilip. Miu ta lohoia da ta ma mimia ki havarau kamamiu? Hau kata ma kokodonimiu? Miu pelea kapiru kena ni mai.” ");
INSERT INTO wiv_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Dia ta pelea kapiru kua ia mai ni Iesus. Tania na vule zaha kua ki hada a Iesus, ia katia kapiru kua ia daea ia poke kara garigari. Ia kini poke kuku, na hivohivo kini gogotala na havana. ");
INSERT INTO wiv_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","A Iesus ki hulenia tamana kapiru, “Ngiza matoto na goloa kua e bele vona?” Na Tamana kapiru kua ki tania, “Kilaka kua e ba kakapiru za. ");
INSERT INTO wiv_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Boto luba e lala kete varaga kara poloka haroho, o kara poloka naru kete hubi matehia. Kua nu dangea koto kodonia, pele maharihita nu kodonihita.” ");
INSERT INTO wiv_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","A Iesus ki tania, “E kuziha ku tani barae, ‘Kua nu dangea?’ Kua kaka ni bilip, mara beta goloa katiu ni vitiha vona.” ");
INSERT INTO wiv_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Na tamana kapiru ki goe ki tania, “Hau kagu bilip vona, palaka kagu bilip beta ni kapou, kodoniau kagu bilip ni kapou!” ");
INSERT INTO wiv_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","A Iesus ti hadavia habuka manumanu dia te rovorovo mai kozoho pale, ia pole kara vule zaha kua ki tania, “Ho vule kara talinga dotoa kamana mangamanga, mai gotala na kapiru kua beta ve koto hoho mule ve vona.” ");
INSERT INTO wiv_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Na vule zaha kua e gigi, ki dopa katia kapiru kua ki daea ia gotala vona. Pale, na kapiru kua ia ngoro balika kaka kua ti mate, pale, na manumanu dia ta tani barae, “Ti mate!” ");
INSERT INTO wiv_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Palaka a Iesus ia vano pahoria limana, ia vamadiria, pale, na kapiru kua ia madi. ");
INSERT INTO wiv_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Muri vona a Iesus ti hoho na poloka ruma, kana disaipel kamahi dia ta hule rogonia dia ka tani barae, “E kuziha ki mara beta hita na pele kakava na vule zaha kuari?” ");
INSERT INTO wiv_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","A Iesus ki tania ni dia, “Na vule zaha mata barae kuari, e lala kete pele kakavanga na lotua za.” ");
INSERT INTO wiv_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Dia ta vatia na distrik kua, dia kene vano, dia ta livutia a Galili. A Iesus beta ni kulina kaka katiu kete lala dia ni ve, ");
INSERT INTO wiv_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","na vuna e vavaketekete na kana disaipel kamahi. E tani barae ni dia, “Na tuna Kaka da e valanga na limana manumanu. Da dia ta hubi matehia, na dama tolu muri, ia mahuri mule.” ");
INSERT INTO wiv_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Dia beta dia na lohoi lala mining na kana polea kua, dia ka kuahi ve dia kata hulenia ve vona. ");
INSERT INTO wiv_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Dia ta bele ni Kaperneam, dia te hoho na poloka ruma, ia hulenia kana disaipel kamahi, “Nazia miu ta vaigege vona na dala?” ");
INSERT INTO wiv_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Beta dia na makulu na vuna zia, na dala, dia ta vavaigege habuka, azei matoto e paraha ni dia. ");
INSERT INTO wiv_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","A Iesus ki mia tadu, ia koi kara kana 12 disaipel kamahi ia tania ni dia, “Azei kua kini kulina kete madi vamuga, ia kete ziho ni madi muri, ni vora kamiu laveve.” ");
INSERT INTO wiv_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ia pelea kapiru kote katiu, ia vamadiria na pidaka dia, ia pahoria kapiru kua ki tania, ");
INSERT INTO wiv_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Azei kua ni koi taduria kapiru kote katiu kua mata barae kua na hizagu, ia e koi taduriau ve; azei kua tani koi taduriau, ia beta ni koi taduriau za, ia e koi taduria kaka kua e geriau ka mai.” ");
INSERT INTO wiv_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","A Jon e tania vona, “Tisa, hita ta hada kaka katiu e pele kakava na vule zaha na hiza. Hita ka tania vona beta kete ma kakatia, na vuna zia ia beta ni katiu ni dolu.” ");
INSERT INTO wiv_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","A Iesus ki tania ni dia, “Taua miu na talea. Kua kaka katiu kini katia mirakel na hizagu, ia mara beta ni tare poki tapu ni pole zaha kirigu. ");
INSERT INTO wiv_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Na vuna, azei kua tani beta ni mamadi poki kiridolu, ia e kamakamadolu kena. ");
INSERT INTO wiv_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Hau ta tani matotonia ni miu, azei kua kini vala kap na naru ni miu na vuna na hizagu, na vuna kua miu na manumanu ke Kristus. Da kadoana mara beta ni golu. ");
INSERT INTO wiv_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Kua kaka katiu kini katia kapirupiru kotekote kua dia ta bilip ni niau dia na poke na pekato, e dopa ki kemi kete rotua kedo kapou na lohora ni vahituva ia na poloka dazi. ");
INSERT INTO wiv_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Kua lima kini katiho kunu katia pekato, le hutuzia. E dopa ki kemi koto lima bale nu hoho nu pelea mahuria, dopa na kua lima ni ba rurua nu dua kara hel, na palaka kua na haroho beta ni lala kete mamate vona. ");
INSERT INTO wiv_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Kua kabe kini katiho kunu katia pekato, le hutuzia. E dopa ki kemi koto kabe bale nu hoho nu pelea mahuria, dopa na kua kabe ni ba rurua ni varaganga ho kara hel. ");
INSERT INTO wiv_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Kua mata kini katiho kunu poke na pekato, bara luahia nu varaga. E dopa ki kemi koto mata bale nu hoho na kingdom ke Vuvu. Tabarae mata karua ni ba vovona, nu varaganga kara hel. ");
INSERT INTO wiv_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Na palaka kua, ‘na matamata kua e hahania manumanu, beta matamata kamahi kua dia na lala dia kata vavarimateai, ia mai ve na haroho kua e dudulu, beta ni lala kete mamate.’ ");
INSERT INTO wiv_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Manumanu laveve da e taruha haroho na hududia laveve, balika sol kua dia ta lala dia kata taruhia na opa laveve, kete katia ni klin na matani Vuvu. ");
INSERT INTO wiv_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Sol e kemi. Palaka kua milolokana ni hozo, da tu kati zingania ki miloloha mule? Habuka sol kua e lala kete katia na midana goloa ni beta ni zazaha tapu, ia miu ve miu kata balika sol kua e kemi, kete katia mianga pa na pidaka miu.” ");
INSERT INTO wiv_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","A Iesus e vatia na palaka kua, kini kara palaka kamahi kua na provins a Iudea na paligena ni Iordan. Kabuna manumanu kapou ve dia ta lohu mule ve vona, pale, ia vaketekete ni dia, habuka kua ia e lala kete kakatia. ");
INSERT INTO wiv_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","A vuni Parisi taza dia ta mai dia kata pado rukia, dia ta hulenia, “Kadolu lo e tania na tamohane e nap kete vamia tapunia tavine o beta?” ");
INSERT INTO wiv_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","A Iesus ki hulenidia, “A Moses e vala lo zia ni miu?” ");
INSERT INTO wiv_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Dia ta tania, “A Moses ia e tania e nap tamohane kete vapolungania na pepana vamia taputapua, ia vala na tavine, ia vamia tapunia tavine.” ");
INSERT INTO wiv_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","A Iesus ki tania, “A Moses e vapolungania na lo kena kamiu, na vuna e vitiha matoto kete tanga polea miu na longoria. ");
INSERT INTO wiv_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Palaka kua na varivuvuka matoto, kilaka kua a Vuvu e varivuvu ki katia goloa laveve, a Vuvu ia e ‘katihiro tamohane mai tavine.’ ");
INSERT INTO wiv_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Kubarae, na tamohane da e vatia tamana kamani titinana ki vaidodo kamani gona tavine. ");
INSERT INTO wiv_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Livuhahiro kini katiu papa. Ti beta hiro ne ma pali boge, beta, hiro te katiu papa. ");
INSERT INTO wiv_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kubarae goloa kua a Vuvu ti vaidodonia kava, ia mara beta kaka ni pahi valahia.” ");
INSERT INTO wiv_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Dia te vamule na poloka ruma, na disaipel kamahi dia ta hulenia a Iesus na goloa kua. ");
INSERT INTO wiv_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ia ki tania ni dia, “Kaka katiu kua ni vamia tapunia gona, ni kabania tavine motu, ia e katia makina magali buhua. ");
INSERT INTO wiv_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ia kua na tavine ve, ni vamia tapunia gona tamohane ni kabania tamohane motu. Ia e katia makina magali buhua ve.” ");
INSERT INTO wiv_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Manumanu dia ta vala na kapiru kotekote ni Iesus kete taruhia limana na hududia. Palaka na disaipel kamahi dia ta pole kiridia. ");
INSERT INTO wiv_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","A Iesus e hadavia kua dia ta pebarae, poloka ki zaha, ki tania ni dia, “Vatia kapirupiru dia na mai ni niau, taua miu na tataledia, na vuna na kingdom ke Vuvu, ia kana nuhu kua mata barae kua. ");
INSERT INTO wiv_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ta tani matotonia ni miu, azei kua tani beta ni pelea na kingdom ke Vuvu balika kapiru kote, ia mara beta ni hoho vona.” ");
INSERT INTO wiv_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Pale, ia luga kapirupiru kamahi kua kini taruhia limana na hududia, kini hulenia a Vuvu kete kati kemihia ni dia. ");
INSERT INTO wiv_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Tania a Iesus ki vavana, na kaka katiu ia rovo zahe, ia padonia tutura na mugani Iesus ki hulenia, “Tisa kemi, nazia da ta katia kata pelea mahuri roroa?” ");
INSERT INTO wiv_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","A Iesus ki kolia kana polea ki tania, “E kuziha ku kohaniau na tisa kemi? Beta kaka katiu ni kemi, a Vuvu za. ");
INSERT INTO wiv_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ho tu lala na lo, ‘Taua nu hubi matehia kaka, taua nu vaitago kamana gona kaka motu, taua nu vanaho, taua nu vairuku veta kara kaka, taua nu rukia kaka nu vanahea, hada zahenia kamama kamani katiti.’” ");
INSERT INTO wiv_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Na kaka kua ki tania, “Tisa, goloa laveve kena hau ta lala kata mumuri papa matoto vona, kilaka kua ta ba kakapiru za.” ");
INSERT INTO wiv_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","A Iesus ki hada boroboronia, ki kulina kirina. Ia tania vona, “Goloa katiu za ma beta nu katia, vano salinia ka goloaloa laveve, ho tu vala monina na nuhu kua beta kadia goloaloa vona, kete ka goloaloa kemikemi vona heta na lagato. Pale, ho tu mai muri ni niau.” ");
INSERT INTO wiv_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Tania a Iesus ki tani barae kua, na kaka kua ki vari matoto. Poloka ki zobo matoto kini vano, na vuna ia e risman matoto katiu. ");
INSERT INTO wiv_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","A Iesus e tare poki ki tania na kana disaipel kamahi, “E vitiha matoto na risman kete hoho na kingdom ke Vuvu!” ");
INSERT INTO wiv_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Na disaipel kamahi, dia ka lohoi tori matoto na kana polea. Palaka a Iesus ki tani mulehia ve, “Kagu kapirupiru, e vitiha matoto na kaka kua kete hoho na kingdom ke Vuvu! ");
INSERT INTO wiv_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","E malimu matoto kara kamel kete hoho horu na horupa nil kara samap. Palaka na risman ia e vitiha matoto vona kete hoho na kingdom ke Vuvu.” ");
INSERT INTO wiv_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Kana disaipel kamahi dia te ba dopa lohoi tori matoto, dia kene vavarihulei, dia kene tatani barae, “Pele azei da ti nap keteni vaikoli voa kirua kua?” ");
INSERT INTO wiv_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","A Iesus ki hada boroboro ni dia ki tani barae, “Kaka mara beta ni vaikoli mule kirina mule, palaka a Vuvu ia e nap; na vuna a Vuvu e nap kete katia goloa laveve.” ");
INSERT INTO wiv_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","A Pita ki tania vona, “Hita te zuka tapunia goloaloa laveve hita kata muri ni niho!” ");
INSERT INTO wiv_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","A Iesus ki tania vona, “Hau ta tani matotonia ni niho. Nuhu kua dia ta vatia kadia rumaruma, habu tazidia, habu livukudia, habu titinadia, habu tamadia, habu tutudia, hadia vanua, dia kata kodoniau, ia mai na Kalohua Kemi ke Vuvu, ");
INSERT INTO wiv_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","da a Vuvu e kade maratanidia meni kua. Da dia ta pelea 100 ve na huduna na rumaruma, na habu tazidia, habu livukudia, habu titinadia, habu tutudia, hadia vanua kamahi, ia mai ve, da e kati zahata voa ve ni dia, pale, na taem kua e ba mamai, da dia ta pelea mahuri roroa. ");
INSERT INTO wiv_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Palaka nuhu luba kua dia ta vavamuga, da dia te muri. Nuhu kua dia ta mumuri, da dia te vamuga.” ");
INSERT INTO wiv_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","A Iesus kamana kana disaipel kamahi dia ta vavana na dala kiri Ierusalem, a Iesus ki vavamuga ni dia, na disaipel kamahi dia ka lolohoi kuahia; na manumanu kua dia ta mumuri ni dia ve, dia ta kuahi ve. Pale, a Iesus ia pelea kana disaipel kamahi vano ti dia kazihedia, ia tania ni dia na goloa kua kete bele kirina. ");
INSERT INTO wiv_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ia ki tani barae ni dia, “Tolu ta zazahe kiri Ierusalem kua, na Tuna Kaka da e valanga na limana hetpris kamahi kamana tisa kamahi kara lo. Da dia ta koto kirina dia ka tania kete hubu matoa, pale, dia ta vala vano na limana nuhu kua beta dia na lala a Vuvu, ");
INSERT INTO wiv_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","da dia ta katia bozubozua vona dia ka livinia, dia ka vihia. Pale, dia ta hubi matehia. Dama tolu kakava, da ia e mahuri mule.” ");
INSERT INTO wiv_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Pale, a Jems hiro a Jon, na tuni Sebedi karua, hiro ta mai ni Iesus hiro ka tani barae, “Tisa, e kulimiro koto katia goloa katiu kua miro kata huleniho kirina.” ");
INSERT INTO wiv_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","A Iesus ki hulenihiro, “Nazia matoto kulimo kata katia kamoro?” ");
INSERT INTO wiv_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Hiro ta tania, “Kua kunu mia na ka sia king na ka kingdom kua e vonu na glori, kulimiro, katiu ni miro kete mia kiri maroro, katiu kiri mauri.” ");
INSERT INTO wiv_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","A Iesus ki tania, “Beta mo na lala nazia kena mo ta huhule kirina. Mo ta dangea mo kata hinumia na kap na bizea kua kata hinumia? Da mo ta pelea baptais kua habuka kua kete valanga ni niau?” ");
INSERT INTO wiv_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Hiro ka tania, “Miro ta nap.” A Iesus ki tania ni hiro, “Da mo ta hinumia kap kua hau kata hinumia ki valanga ve baptais kua hau kata pelea ve ni moro, ");
INSERT INTO wiv_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","palaka kua mo kata mia kiri marorogu o kiri maurigu, ia beta ni kagu galanga kata makia. Na sia kamahi kena, ia kana nuhu kua a Vuvu ti makidia kava.” ");
INSERT INTO wiv_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Tania na disaipel taza ve kua e 10 dia ka longoria polea kua, magalidia ki varitihi kiri Jems hiro a Jon. ");
INSERT INTO wiv_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","A Iesus ia kohani lupunidia, ki tania ni dia, “Miu ta lala, manumanu bukuna garigari kadia king kamahi, dia ta lala dia kata bosim dia. Kadia pararaha dia ka lala dia kata geridia, dia kata mumuri na kadia polea. ");
INSERT INTO wiv_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Palaka na pidaka miu, ia beta kete kuza barae. Azei ni miu kua ni kulina kete kara kamiu paraha, ia kete kara kamiu vora; ");
INSERT INTO wiv_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","azei kua e kukulina kete vavamuga ni miu ia kete kara kamiu vora laveve. ");
INSERT INTO wiv_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Na vuna na Tuna Kaka beta ni mai kete vovora voa vona; ia e mai kete kodonia manumanu ni vala kana laep kete pele mulehia manumanu luba.” ");
INSERT INTO wiv_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Dia ta bele ni Jeriko. Tania a Iesus kamana kana disaipel kamahi ia mai na kabuna manumanu kapou dia ka vavatia a Jeriko, na kaka katiu matana e keu ki lala kete vavarinongu, hizana a Bartimeus tuni Timeus, e mimia na hiripa dala. ");
INSERT INTO wiv_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Kamana ki longoria habuka a Iesus bukuni Nasaret ti mai kozoho, ia goe ki tania, “Iesus, Tuni Devit, mahariau!” ");
INSERT INTO wiv_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Manumanu luba dia ka harovitinia, dia ka tania vona kete zodo. Palaka ia dopa goe ki tania, “Tuni Devit, mahariau.” ");
INSERT INTO wiv_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","A Iesus ia madi, ia tania, “Kohania ni mai.” Dia ta koi kara kaka kua matana e keu, dia ta tania vona, “Hilohilo! Nu madi! Ti kokoi kiriniho.” ");
INSERT INTO wiv_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","A Bartimeus e varaga taduria kana kale havuhavua, ia di madi ia mai ni Iesus. ");
INSERT INTO wiv_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","A Iesus ia hulenia, “Nazia kuli kata katia ni niho?” Na kaka kua matana e keu ki tania, “Tisa, hau kuligu kata hada.” ");
INSERT INTO wiv_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","A Iesus ia tania, “Vano. Ka bilip kava ti katiho kunu kemi.” Pale, ia hada pamuhi kini muri ni Iesus dia kene lilia dala vano. ");
INSERT INTO wiv_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Dia te vano kokozoho ni Ierusalem, kozoho na taon a Betfage kamani Betani, dia ta bele na potuna a Oliv. A Iesus ia geria kana disaipel rua, ");
INSERT INTO wiv_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ia ta tania ni hiro, “Mo vano kara malala kuari na muga dolu. Ta mo na bele na malala kena, da mo ta paria na donki huluvahu e vututadura. Ma beta kaka katiu ni polo vona varira. Hulia mo ta pelea mai ri kua. ");
INSERT INTO wiv_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Kua kaka katiu kini hulenimoro ni tania, ‘E kuziha mo ka kati baraenia?’ Mo tania vona, ‘Na Paraha kana galangana vona. Da e vala mulehia ki vamule tapu.’” ");
INSERT INTO wiv_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Hiro ta vano hiro ta paria na donki huluvahu e vututadura na hiripa dala, na pe gotalatalanga na malala. Hiro ta hulia. ");
INSERT INTO wiv_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Manumanu taza kua dia vavarimadiriai, dia ta hulenihiro, “Nazia mo ta kakatia, e kuziha mo ka huhulia na donki huluvahu kena?” ");
INSERT INTO wiv_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Hiro ta tania ni dia na polea ke Iesus, pale, dia ta vatihiro, hiro kene vano. ");
INSERT INTO wiv_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Hiro ta pelea na donki huluvahu kua vano ni Iesus, dia ta taruhia kadia zohozohoa na lamana donki, a Iesus ia mia na huduna. ");
INSERT INTO wiv_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Manumanu luba dia ta vozolia kadia zohozohoa na dala, taza dia ta vozolia dangadangana hai, kua dia ta bazia na vanua kamahi. ");
INSERT INTO wiv_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Nuhu kua dia ta vana vamuga ni Iesus, kamana nuhu kua dia ta mumuri dia ta goe dia ka tania, “Hilohilo na Paraha! A Vuvu e kati kemihia matoto na kaka kua e mai na hizana Paraha! ");
INSERT INTO wiv_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Paleka a Vuvu ni kati kemihia matoto na kingdom kua e mamai, da e balika na kingdom kua ke tubudolu a Devit. Vazahenia hizani Vuvu ni zahe heta matoto!” ");
INSERT INTO wiv_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","A Iesus ia hoho ni Ierusalem, ia vano kara tempel. Ki vanavana lobi na poloka tempel, ki hadavia na goloa laveve. Palaka na vuna ti garavi, ia vano kiri Betani kamana kana 12 disaipel kamahi. ");
INSERT INTO wiv_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ti dama, dia te pe ni Betani dia kene vavamule, a Iesus e vitolonia. ");
INSERT INTO wiv_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ia hada zau, ki hadavia na haina fik katiu, raurauna motu vona. Ia vano kete kaze na palekana. Palaka tania ki vano ki hadavia, raurauna vetanga, na vuna ma beta ni na nagi kara fik kete vua. ");
INSERT INTO wiv_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Pale, ia tania kara haina fik kua, “Mara beta ve nu vua kaka katiu ni hania paleke.” Na kana disaipel kamahi, dia ta longoria na polea kua e tania. ");
INSERT INTO wiv_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Kamana dia ka bele ni Ierusalem. A Iesus ia vano hoho kara banis na tempel. Ia vaibura manumanu kua dia ta mamaket na poloka. Ia vapopo vatuduhia na tebol kamahi kana nuhu kua dia ta popokipoki moni, ia mai ve na mianga kana nuhu kua dia ta mamaket na balu kamahi, ");
INSERT INTO wiv_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ki tabunia habuka, beta ve kaka katiu kete luga goloaloa kara maket ni pe hutu mai vano na poloka banis na tempel. ");
INSERT INTO wiv_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Pale, ia vaketekete na manumanu ki tani barae ni dia, “E vapolu baraenga na poloka buk ke Vuvu, ‘Kagu ruma ia kete kohanga na rumaka lotua kana manumanu bukuna kantri laveve, dia kata lohu dia na lolotu ni niau vona.’ Palaka miu te katia kini kara palakana paritigia kana nuhu mata vanahonaho.” ");
INSERT INTO wiv_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Na hetpris kamahi kamana tisa kamahi kara lo dia ta longoria na goloa kua a Iesus e katia, pale, dia te varivuvu dia keteni kaze dala dia keteni hubi matehia a Iesus na vuna dia ta kuahinia. Na vuna manumanu laveve dia ta zipa zahe matoto na kana vaketeketea. ");
INSERT INTO wiv_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Pale, ti garavi matoto, dia ta gotala ni Ierusalem dia kene vano. ");
INSERT INTO wiv_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ti dama ruana vona, a Iesus kamana kana disaipel kamahi dia ta vavana na dala vavano, dia ta hadavia na haina fik, ti malainia laveve ki ziho na voravoraka kamahi ve. ");
INSERT INTO wiv_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","A Pita e lohoi mulehia na polea kua a Iesus e tania kara haina fik kua, ia ki tania ni Iesus, “Tisa, hadavia! Na haina fik kua tu pole kirina ngora, ti malainia!” ");
INSERT INTO wiv_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","A Iesus ki tania ni dia “Miu bilip ni Vuvu. ");
INSERT INTO wiv_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ta tani matotonia ni miu, kua kaka katiu ni tani barae kara potuna kuari, ‘Divurutiho nu pozi nu dua kara dazi.’ Kua ni beta ni lohoi ruarua na poloka mule, palaka e bilip matoto habuka nazia kua e tania da e bele matoto, ia da e bele matoto habuka kena ia e tania. ");
INSERT INTO wiv_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kubarae hau ta tania ni miu, kua kunu lotu kunu hule kara goloa katiu, ia koto bilip habuka kava tu pelea goloa kena tu huhule kirina kava, pale, ia da e bele habuka kena tu tania. ");
INSERT INTO wiv_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Kua kunu madi kunu lolotu, kua kini ka manaunaua vona kamana kaka katiu, ia koto lohoi bala kana manaunaua kiriniho. Pale, a Kamama ve kua ia e heta na lagato ia da ti lohoi bala ve ka manaunaua kamahi.” ");
INSERT INTO wiv_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","A Iesus kamana kana disaipel kamahi, dia ta bele mule ni Ierusalem. A Iesus ki vavanavana na poloka tempel. Na hetpris kamahi, na tisa kamahi kara lo kamana pararaha ke vuni Iuda, dia ta mai vona, ");
INSERT INTO wiv_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","dia ta hulenia, “Tu pelea na naba kamana matuhanga ni ve ku kakatia galanga kua? Azei matoto e vala naba ni niho, ki tania ni niho koto kakatia galanga kua?” ");
INSERT INTO wiv_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","A Iesus ki tania, “Hau ve kata hulenimiu na hulea katiu. Miu na kolia ni niau, hau da ta tania ni miu ve, azei matoto e vala naba ni niau kata katia galanga kamahi kua. ");
INSERT INTO wiv_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Miu tania ni niau! Na baptais kua a Jon e vavala na manumanu, ia na goloa bukuna lagato o kana kaka za?” ");
INSERT INTO wiv_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Pale, dia ta vaigege na pidaka dia mule, dia ka tania, “Ta tolu na tania, ‘E pe na lagato.’ Da ia e hule, ‘E kuziha ki beta miu na bilip vona?’ ");
INSERT INTO wiv_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Palaka ta tolu na tania, ‘E mai na kaka’...” (Dia ta lohoi kuahia na manumanu, na vuna manumanu laveve, dia ta lohoia dia ka tania a Jon ia na profet matoto.) ");
INSERT INTO wiv_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Kubarae dia ta kolia hulea ke Iesus dia ka tania, “Beta hita na lala.” A Iesus ki tania ni dia, “Ia hau ve mara beta na tania ni miu azei matoto e vala naba ni niau ka kakatia na galangalanga kamahi kua.” ");
INSERT INTO wiv_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Pale, a Iesus ia barikikinia polea ki tani barae, “Na kaka katiu e vazohia vanua na vaen. Ia diva lobia, ia hovia na lovo kete vaka bebeha na paleka vaen vona. Ia habatia ve taoa horaha katiu kara hada haroharoa. Pale, ia vala na vanua na vaen kua na manumanu taza dia kata gala bisnis vona. Ia kini vavana kara palaka zau. ");
INSERT INTO wiv_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Na dama kara pelepelea na palekana vaen ti bele, ia geria kana vora katiu kete vano na nuhu kua dia ta gagala bisnis na vanua na vaen kua, kete pelea palekana vaen taza ni dia. ");
INSERT INTO wiv_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Palaka dia ta haba taduria, dia ta hubia, dia kene geri mulehia kamana limana vetanga. ");
INSERT INTO wiv_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Na tauna vanua ia geri mulehia kana vora katiu ve. Dia ta hutu vulahia bakana vora kua, dia ka kuza hilenia. ");
INSERT INTO wiv_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ia geria katiu ve, dia ta hubi matehia. E geria voravora luba; taza dia ta hubidia taza dia ta vaihubi mate. ");
INSERT INTO wiv_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Pale, kaka katiu papa za kua e ba vovona; ia na tuna mule, kua e kulina matoto kirina. Ti beta ve kaka kete geria, ia geria tuna, ki tani barae, ‘Da dia ta hada zahenia tugu.’ ");
INSERT INTO wiv_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Palaka nuhu kua dia ta gagala bisnis na vanua na vaen kua, dia ta varitaninia, ‘Na tuna tauna vanua kua. Mai tolu na hubi matehia, tolu na pelea hadolu, vanua na vaen kua.’ ");
INSERT INTO wiv_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Dia ta haba taduria dia kene hubi matehia, dia ta varaga gotalania na vanua na vaen. ");
INSERT INTO wiv_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Pale, na tauana vanua na vaen kua, da nazia e katia? Da e mai ki hubi matehia na nuhu kua dia ta gala bisnis na vanua, ki vala vanua na vaen kua na manumanu motu. ");
INSERT INTO wiv_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Karae beta miu na hazenia na polea kua na poloka buk kana Paraha kua e tani barae, ‘Na kedo kua na kapenta kamahi dia ta tania e zaha dia kene varaga vetania ia ti kara kedo kemi matoto kua kete ngoro tuka ruma. ");
INSERT INTO wiv_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Na Paraha mule, ia e katia na goloa kua ki bele, hita ka hadavia habuka e mata muli matoto!’” ");
INSERT INTO wiv_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Na pararaha ke vuni Iuda dia ta kaze matoto dala dia kata haba taduria. Na vuna dia ta lala, ia e barikikinia polea kua kiridia. Palaka, dia ka kuahinia na kabuna manumanu kapou kua, kubarae, dia ta vatia dia kene vano. ");
INSERT INTO wiv_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Muri dia ta geria na Parisi taza, kamana nuhu taza bukuna pati ke Herot, dia ta vano ni Iesus. Dia kata hule rukia na polea taza. ");
INSERT INTO wiv_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Dia ta mai vona dia ka tania, “Tisa, hita ta lala habuka, tu lala koto vaketea polea matoto, ki beta nu lala koto kuahinia kaka katiu. Beta ve nu lala koto hada kaka katiu nu tania ia e hizanga dopa na kaka motu, palaka tu lala koto vaketea matotoka lohoihoia ke Vuvu kara manumanu. Tania ni hita, E mahoto tolu kata kadea takis ni vano ni Sisar o beta?” ");
INSERT INTO wiv_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","A Iesus e lala dia ta huhule rukia, ia hulenidia, “E kuziha miu ka papado rukiau? Miu vala moni katiu mai na hadavia.” ");
INSERT INTO wiv_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Dia ta vala na silva moni katiu vona, ia ki hulenidia, “Hanunuki zei, kamana hizani zei kua vona?” Dia ka tania, “Ke Sisar.” ");
INSERT INTO wiv_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","A Iesus ki tania ni dia, “Pele miu vala ni Sisar, nazia kua ke Sisar. Miu vala ni Vuvu, nazia kua ke Vuvu.” Kamana dia ka longoria kana polea, dia ta zipa zahe matoto. ");
INSERT INTO wiv_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","A vuni Sadyusi, nuhu kua dia ta tania habuka mara beta kaka ni mahuri mule na matea. Dia ta mai ni Iesus dia ka tani barae, ");
INSERT INTO wiv_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Tisa, a Moses e vapolungania kahita lo katiu kubarae; Kua tamohane katiu ni kabania tavine katiu, na tamohane kua ni mate, ki beta ni taruhia kapiru na tavine kua, na tazina, da e kabania na tavine kua, kete taruhia kapiru vona. Palaka kapirupiru kua ia e taruhia na tavine kua, ia da e hadava dia habuka dia na habu tutuni tazina kua ti mate. ");
INSERT INTO wiv_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Boto katiu, varitazini e 7; na tazidia muganga e kabania na tavine katiu, pale, ia mate beta ni taruhia na kapiru katiu na tavine kua. ");
INSERT INTO wiv_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Tazina muria ia kabania ve na tavine kua, ia ve e mate beta ni taruhia kapiru katiu na tavine kua. Toludia ve ia e kubarae ve. ");
INSERT INTO wiv_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Dia laveve dia ta kubarae, dia varitazini laveve kua e 7, dia ta kabania na tavine kua dia ka varimateai, beta dia na taruhia kapiru katiu vona. Muri matoto na tavine kua ia mate ve. ");
INSERT INTO wiv_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Kua tani ba muri, kua manumanu laveve dia na mahuri mule na matea, da na tavine kua e goni zei matoto? Dia 7 laveve kua, dia ta kabania na tavine kua.” ");
INSERT INTO wiv_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","A Iesus ki tania ni dia, “Kamiu polea beta ni mahoto! Na vuna beta miu na lala na polea ke Vuvu o na matuhanga ke Vuvu. ");
INSERT INTO wiv_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Na vuna kua ta ba muri manumanu dia na mahuri mule na matea, da beta dia kata lahi o kete valahua dia, na vuna da dia ta balika engel kamahi na lagato. ");
INSERT INTO wiv_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Kua na polealeana mahuri mulea na matea, karae beta miu na hazenia ziuziua kua na buk ke Moses, kua na haroho e dudulu na hai? Na ziuziua, a Vuvu e tani barae ni Moses, ‘Hau ia na Vuvu ke Abraham, na Vuvu ke Aisak, ia mai na Vuvu ke Jekop.’ ");
INSERT INTO wiv_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","A Vuvu ia na Vuvu kana nuhu kua dia ta mahuri, beta ni a Vuvu kana nuhu kua dia te varimateai. Kubarae kamiu polea beta ni mahoto!” ");
INSERT INTO wiv_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Na tisa katiu kara lo kilaka kua ia e mimia ki lolongoridia kua dia ta vavaigege. E longoria habuka a Iesus e koli kemikemihia kadia hulea, kubarae ia mai ni Iesus ki huleni baraenia, “Lo kakei e dopa ki kapou matoto na lo laveve?” ");
INSERT INTO wiv_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","A Iesus ki kolia ki tania, “Na lo kua e dopa ki kapou matoto ia kua, ‘Miu vuni Israel miu longoria! Na Paraha katiu papa, ia na kadolu Vuvu. ");
INSERT INTO wiv_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Kete kulimiu kara Paraha kadolu Vuvu. Kete kulimiu matoto kirina na polokomiu laveve, na vulemiu laveve, na kamiu lohoihoia laveve, ia mai na kamiu matuhanga laveve.’ ");
INSERT INTO wiv_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Na ruana lo ia e kapou barae ve, ‘Kete kuli kara kaka kua e mimia kozoho ni niho habuka kua e lala kete kukuli kiriniho mule.’ Beta lo katiu ni vinim na lo rua kua.” ");
INSERT INTO wiv_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Na kaka kua ki tania, “Tu koli kemikemihia matoto tisa! E matoto habuka kena tu tania, na Paraha katiu papa za ia a Vuvu. Ki beta ve Vuvu katiu ve. ");
INSERT INTO wiv_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Kete kuli ve kiri Vuvu na poloko, na ka lohoihoia ia mai na ka matuhanga laveve; kete kuli ve kara kaka kua e kozohotiho habuka kua e kukuli kiriniho mule. E dopa ki goloa kapou kua tolu kata mumuri na lo karua kua. Beta ni goloa kapou marata kua tolu ta lala tolu kata opa na enimel kamahi ia mai na opa taza ve ni Vuvu.” ");
INSERT INTO wiv_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","A Iesus e hadavia habuka e koli kemikemi kana polea, kubarae ki tani barae vona, “Ho beta nu zau na kingdom ke Vuvu.” Pale, muri na kua, beta ve kaka katiu ni parakilania kete hulenia na hulea katiu ve. ");
INSERT INTO wiv_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Kilaka kua a Iesus e vaketekete na poloka tempel, ia hule barae, “E Kuziha na tisa kamahi kara lo dia ka tania habuka na kaka kua a Vuvu e makia kua kete pele mulehia manumanu, ia da na tubuni Devit katiu? ");
INSERT INTO wiv_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","A Devit mule, na vuna na matuhanga kana Vule Tumonga, ia e tani barae, ‘Na Paraha e tania na kagu Paraha kubarae, mia kiri marorogu ia, ia ki mule na dama kua ka taruhia ha vagi kamahi na tauri kabe.’ A Devit ia mule e kohania ia na ‘Paraha.’ Pele, da ia e tubuni Devit ziha?” Na kabuna manumanu kua dia ta tatabu longo kara polea ke Iesus dia ta hilohilo matoto na kana polea. ");
INSERT INTO wiv_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Kilaka kua, a Iesus e vaketekete ni dia ki tani barae, “Miu lohoimiu na tisa kamahi kara lo. E lala kete kukulidia matoto kua dia kata zohoria kadia kolos malakulaku dia na lobilobi. Ki lala kete kukulidia matoto manumanu kete hahada zahenidia na poloka palakana maket. ");
INSERT INTO wiv_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Dia ka lala dia kata hada palipali kara mianga kua e lala kete tataruha kana nuhu kua dia ta hizanga za, na poloka haus lotu ke vuni Iuda, dia ka lala dia kata hada palipali kara mianga kemikemi na taem kara parti kamahi. ");
INSERT INTO wiv_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Dia ka lala dia kata kukuza kerekerenia tavivine gabugabu kamahi dia na vavanahea kadia rumaruma kamahi. Dia ka lala dia kata vavairuku na matana manumanu na lotua malakulaku. Na taem kara kotoa kapou da dia ta paria zahatanga kapou matoto!” ");
INSERT INTO wiv_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","A Iesus e mimia kozo na bokis kara opa, ia ki babanuzia na manumanu kua dia ta vavaraga hoho kadia moni. Risman luba dia ta varaga hohoria moni kapopou; ");
INSERT INTO wiv_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Pale, na tavine gabu katiu e mai ia gorea na toea rua, nu haze ruania moni kua da e bele 1 toea. ");
INSERT INTO wiv_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","A Iesus ia koi lupunia kana disaipel kamahi ki tani barae ni dia, “Hau ta tani matotonia ni miu, na tavine gabu kuari e taruhia moni kapou matoto livutia manumanu laveve kua dia ta opa. ");
INSERT INTO wiv_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Na vuna, dia taza dia ta opa na kadia dihura kadia goloa mata mulimuli, palaka ia, ia vata kua beta kana goloaloa vona, ia e vala hozohozovia kana moni laveve, e vala moni laveve kena kete kodonia na kana mianga.” ");
INSERT INTO wiv_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Kamana a Iesus ki vatia na tempel, na kana disaipel katiu e tani barae vona, “Tisa, hadavia! Na kedo kapopou kamahi kuari na tempel, kamana rumaruma kamahi vona, dia ta mata mulimuli matoto.” ");
INSERT INTO wiv_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","A Iesus ki tania vona, “Tu hadavia na ruma kapoupou laveve kuari? Da beta kedo katiu kete vatua ni ngoro na mudina; kedo laveve kuari da e varaga tadura.” ");
INSERT INTO wiv_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","A Iesus e mimia na potuna a Oliv, na tempel na paligena, ia na paligena. E mimia kamani Pita, a Jems, a Jon, ia mai a Andru. Dia ta hule rogonia a Iesus dia ka tania, ");
INSERT INTO wiv_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Tania ni hita, da ngiza goloaloa kua ki bele? Da nazia e bele kete vatunga kakava habuka na taem kara goloaloa kamahi kua keteni lohu?” ");
INSERT INTO wiv_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","A Iesus ki tania ni dia, “Miu lohoia. Tabarae kaka katiu ni rukimiu. ");
INSERT INTO wiv_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Manumanu luba da dia ta mai dia ka kohania hizagu, dia ka tania, ‘Hau ia.’ Da dia ta rukia manumanu luba. ");
INSERT INTO wiv_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Tabarae miu na lohoi vuvu kua ta miu na longoria war o na kavilika polealea na war, tabarae miu na kuahi. Goloaloa kamahi kua da dia ta bele, palaka mara beta las de ni lohu tapu. ");
INSERT INTO wiv_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Kantri katiu da e varihubi kamana kantri motu, kingdom katiu da e varihubi kamana kingdom motu. Da vuruhe e kulu na palaka luba, vitolo kapou da e lohu. Goloaloa kua dia ta habuka varitihia kua na tavine e muga ki hahatunia kua kete zuru. ");
INSERT INTO wiv_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Na taem kua, ia miu da miu ta lohoimiu. Da e haba tadura miu ki peola miu vano kara kotoa. Da e hubua miu na poloka haus lotu ke vuni Iuda. Da dia ta lohoia dia kata ditaduria hizagu, kubarae da dia ta vamadirimiu na matana kadia pararaha kamana kadia king kamahi. Pale, miu te ba tani kakava na Kalohua Kemi ni dia. ");
INSERT INTO wiv_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Manumanu na kantri laveve dia kata muga longoria kaka kete kavakavania na Kalohua Kemi ni dia. ");
INSERT INTO wiv_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Kua miu kene paho tadura miu kene koto kirua, tabarae miu na lohoi vuvu habuka, na polea zia miu kata tania. Kua na taem kua kini bele, miu tania nazia kua e tanga ni miu. Na vuna na polea kamahi miu kata tania da beta keteni kamiu polea mule, da na Vule Tumonga ti popole kamiu. ");
INSERT INTO wiv_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Manumanu da dia ta koto kiri habu tazidia mule dia ka hubu matoa, habu tamana kapirupiru da dia ta koto ve kiri habu tutudia ki hubu matoa dia. Kapirupiru ve da dia ta tare poki kiri habu tamadia kamani habu titinadia dia ka koto kiridia ki hubu matoa dia. ");
INSERT INTO wiv_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Manumanu laveve da dia ta zaha kirimiu na vuna ni niau. Palaka azei kua kini madi kini bada ki vano ki mule na las de, ia da e vaikoli voa kirua. ");
INSERT INTO wiv_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Kua miu kene hadavia na goloa zaha matoto kua kini mamadi na palaka kua e vatabuanga vona kete mamadi vona. (Azei kua kini hahazenia polea kua, ia kete lohoi lala na mining na goloa kua!) Pele, nuhu kua ni Iudea, dia kata birika kara potuna kamahi. ");
INSERT INTO wiv_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Azei kua na huduna ruma katiu, tabarae ni lohoia kete zipa o ni hoho kara kana ruma kete pelea goloa katiu ni hava kamana. ");
INSERT INTO wiv_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Azei kua na poloka vanua tabarae ni vamule kara ruma kete pelea kana tale havuhavua. ");
INSERT INTO wiv_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Na dama kamahi kua da e zaha matoto ke tavivine kua dia ta kovekove kamani tavivine kua habu tutudia e ba kotekote! ");
INSERT INTO wiv_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Miu lotu ni Vuvu miu na hulenia habuka goloaloa kua kete beta kete bele na nagi kara magara. ");
INSERT INTO wiv_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Na vuna na bizea kamahi kua kete bele na taem kua, ia da e kapou matoto, kapou livutia bizea laveve. Varivuvu na dama kua a Vuvu e katia na vulovulo ki mai ki mule na tauna kua. Da beta ve bizea katiu kete balika, o kete bele mule ve. ");
INSERT INTO wiv_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Palaka na Paraha ti pele kakava na dama taza na damana goloa zaha kua; kua tani beta ni kati baraenia, mara beta kaka katiu ni mahuri. Na vuna a Vuvu e lohoihoi na kana manumanu kua ia e makia, kubarae ia kini pele kakava dama taza na dama kamahi kua. ");
INSERT INTO wiv_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Na dama kamahi kena, kua ta kaka katiu ni tani barae ni niho, ‘Hadavia, kua a Kristus kua!’ o, ‘Hadavia, kuari ia rae!’ tabarae miu na bilip vona. ");
INSERT INTO wiv_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Na vuna, Kristus vairukuruku kamana profet vairukuruku da dia ta lohulohu. Da dia ta katia mirakel kamahi kamana goloaloa mata holiholi kamahi. Kua tani volo papa kiridia, da dia ta rukia ve nuhu kua a Vuvu ti makidia dia kata kana. ");
INSERT INTO wiv_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kubarae, miu lohoimiu! Hau kava te tani vamuga goloaloa laveve kua ni miu. ");
INSERT INTO wiv_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Na dama kamahi ba muri na taem zaha kua, da na voro beta keteni tiba, na lingabo da beta ve kete tiba, ");
INSERT INTO wiv_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","na vitovito kamahi da dia ta huru na mariaba, na goloa laveve kua e matuha na mariaba da dia hunu mai vano. ");
INSERT INTO wiv_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Pale, na taem kena da manumanu dia te hadavia na Tuna Kaka na huduna mariaba ti ziziho kamana matuhanga kapou kamana balangana kana glori. ");
INSERT INTO wiv_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Da ia ti geria kana engel kamahi kara paligena laveve na garigari. Dia ka vile lupunia na manumanu laveve kua a Vuvu ti makidia kava, na mulemulengana garigari matoto ki zahe heta na mulemulengana mariaba ve. ");
INSERT INTO wiv_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Miu pelea hada lalanga na haina fik. Kamana ti lobulobu, ia miu te hada lala habuka na nagi kara rahi ti kokozoho. ");
INSERT INTO wiv_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ia kubarae za, kua ta goloaloa kamahi kua dia ne bebele, ia da miu te hada lala habuka na taem ti kokozoho, kozoho matoto na kamiu hatama. ");
INSERT INTO wiv_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ta tani matotonia ni miu habuka, na goloaloa laveve kua da e bele ba muri manumanu laveve kua dia ta ba mamahuri dia kene varimateai. ");
INSERT INTO wiv_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Na lagato kamana vulovulo da e balavutuka, palaka kagu polea mara beta ni kakava. ");
INSERT INTO wiv_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Beta matoto kaka katiu ni lala matotonia ngiza matoto o na aua zia o na dama kakei na goloa kua kete bele vona. Na engel kamahi ve na lagato beta dia na lala, na Tuna Kaka ve beta ni lala; a Tamana za ia e lala. ");
INSERT INTO wiv_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Miu tatare, miu ka hahada, na vuna beta miu na lala ngiza matoto na taem kua kete bele. ");
INSERT INTO wiv_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Da e habuka kaka kua e vatia kana ruma ki vavana kara palaka zau ki vatia kana voravora, dia ka hada poto na kana goloaloa. E vala galanga na katiukatiu ni dia ki taruhia ve kaka katiu kete hada poto na geit. ");
INSERT INTO wiv_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Kubarae, miu tatare na vuna beta miu na lala ngiza matoto da na tauana ruma da e lohu mule vona. Da e bele na garavi o na varivalavala, o na toha ti kakareko, o na damadama. ");
INSERT INTO wiv_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Tani bele valutu. Beta kete parimiu miu ta ngongoro. ");
INSERT INTO wiv_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Polea kua ta tatania ni miu, ia e vano ve kara manumanu laveve. Miu tatare!” ");
INSERT INTO wiv_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Na dama rua muga na hanihania kapou kara Pasova kamana Bret Beta Yis vona, na hetpris kamahi kamana tisa kamahi kara lo, dia ta kakaze vairukua katiu, kua dia kata padea a Iesus vona dia na haba taduria a Iesus, dia na hubi matehia. ");
INSERT INTO wiv_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Dia ta tania, “Beta kete na dama na hanihania kapou. Tabarae manumanu dia na lala dia na katia varihubia kapou.” ");
INSERT INTO wiv_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Kilaka kua a Iesus ia ni Betani, na poloka ruma ke Saimon, kaka kua varira lepra vona. A Iesus e mia na tebol ki hanihani, na tavine katiu e mai kamana botole e katua na kedo alabas, e vonu na perpium kua e kadoa na moni kapou matoto. (Na perpium kua e katua na nard.) Ia e hutu vulahia na botole kua, ia valikiria na perpium kara bakani Iesus. ");
INSERT INTO wiv_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Manumanu taza kilaka kua, dia ta hada baraenia, magalidia ki varitihi kara tavine kua, dia ka varihulei, “E kuziha ki paralegenia na perpium kuari? ");
INSERT INTO wiv_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Kua ni vatia tolu na salinia ma tolu ta pelea 300 koin silva vona, tolu ta vala monina na nuhu kua beta kadia goloaloa vona.” ");
INSERT INTO wiv_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","A Iesus ki tani barae, “Miu vatia, e kuziha miu ka kakaborania? Ia ti katia goloa mata muli matoto ni niau kua. ");
INSERT INTO wiv_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Manumanu kua beta kadia goloaloa vona, da dama laveve dia ta ma mimia kamamiu. Palaka hau beta kata ma mimia kamamiu. ");
INSERT INTO wiv_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Tavine kua ia e katia goloa kua ia e nap kete katia. Ia ti valikiri vamugania perpium kara livuhagu, kete vaida livuhagu kara matmat. ");
INSERT INTO wiv_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ta tani matotonia ni miu, na palaka laveve na garigari kua na Kalohua Kemi e vaketoa vona, na goloa kua na tavine kua e katia, ia da e tanga ve, manumanu dia kata lala goloa kua ia e katia.” ");
INSERT INTO wiv_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Pale, a Iudas Iskariot, katiu ni dia na 12 disaipel ke Iesus, ia vavana vano na hetpris kamahi kete vala a Iesus na limadia. ");
INSERT INTO wiv_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Dia ta hilohilo matoto dia kata longoria nazia kua ia kete tania, dia ka mapamapa dia kata vala moni vona. Pale, a Iudas ia kazekaze dala pamuhi kua kete volo papa kirina kete vala a Iesus ni dia. ");
INSERT INTO wiv_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Na varivuvuka dama na hanihania kapou na Bret Beta Yis vona, na dama kua dia ta lala dia kata hubia na sipsip kua dia kata hania na hanihania kapou na Pasova. Na disaipel kamahi ke Iesus dia ta hulenia, “E kuli hita kata vaida hadolu haninga kara Pasova ni ve?” ");
INSERT INTO wiv_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Pale, ia geria kana disaipel rua ki tania ni hiro, “Mo hoho na taon, da mo ta paria kaka katiu e luluga na sospen na naru. Mo muri vona. ");
INSERT INTO wiv_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Mo ta tani barae na tauana ruma kena na kaka kena e hoho vona, ‘Na tisa e hule, “Kue na rum kua ia kamana kana disaipel kamahi dia kata hania Pasova vona?” ’ ");
INSERT INTO wiv_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Da ia e vatunga ni moro na rum kapou katiu na huduna ruma, kava ti vaidanga. Mo vaida hadolu haninga vona.” ");
INSERT INTO wiv_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Na disaipel karua kua, hiro ta vatidia hiro kene vano hoho na siti, hiro ta paria na goloa laveve ia e habuka za kua a Iesus e tania ni hiro. Pale, hiro ta vaida haninga kara Pasova. ");
INSERT INTO wiv_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ti mata kavunu, a Iesus ia bele kamana kana 12 disaipel kamahi. ");
INSERT INTO wiv_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Dia ta mia na tebol dia kene hanihani, a Iesus ia tani barae, “Ta tania matotonia ni miu, kaka katiu ni miu da e valau na hagu vagi kamahi. Ia na kaka katiu kua e hanihani kamaniau kua.” ");
INSERT INTO wiv_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Na disaipel kamahi dia ta longoria polea kua ki vairohia magalidia, kubarae katiukatiu ni dia ki hule, “Karae hau, ai?” ");
INSERT INTO wiv_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","A Iesus ki tani barae ni dia, “Da katiu ni miu kua 12 kua. Kaka kua e lutia hana bret na poloka dis kamaniau. ");
INSERT INTO wiv_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Na Tuna Kaka da e mate habuka kua e vapolunganga na polea kana Paraha ki tanga; palaka kaba loho zahanga na kaka kua e vala na Tuna Kaka na hana vagi kamahi! Ma e dopa ki kemi kete beta kete valohua ia!” ");
INSERT INTO wiv_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Dia ta ba hanihani barae, a Iesus ia pelea na dihura bret pitu, ia lotu ia hate motunia a Vuvu, ia bara vulahia, ia vala na kana disaipel kamahi, ia tani barae, “Miu pelea; na livuhagu kua.” ");
INSERT INTO wiv_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ba muri ia pelea ve na kap, ia hate motunia a Vuvu ia vala ve ni dia; dia laveve dia ka hinu na kap kua. ");
INSERT INTO wiv_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","A Iesus ki tani barae na kana disaipel kamahi, “Kua ia na topogu, kete katia kontrak. Te valikiria kete kodonia manumanu luba. ");
INSERT INTO wiv_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Hau ta tania ni miu, hau mara beta na hinu mulehia na zuruka vaen, ki vano ki mule na dama kua kata hinumia na vaen vahoru na poloka kingdom ke Vuvu.” ");
INSERT INTO wiv_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Pale, kamana dia ka habia linge katiu ki hozo, dia ta gotala dia kene vavana vano kara potuna ni Oliv. ");
INSERT INTO wiv_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","A Iesus ki tania ni dia, “Da miu laveve kua da miu ta zuka tapuniau miu ka varihavai, na vuna na polea kana Paraha e tani barae, ‘A Vuvu da e hubi matehia na kakanaka hada potopotoa na sipsip, na sipsip kamahi dia ta bura katiutiu.’ ");
INSERT INTO wiv_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Palaka da ta mahuri mule, hau ta vamuga ni miu vano kiri Galili.” ");
INSERT INTO wiv_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","A Pita ki tania vona, “Dia taza da dia ta hava tapuniho. Hau kua mara beta matoto na hava tapuniho!” ");
INSERT INTO wiv_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","A Iesus ki tania ni Pita, “Ta tania ni niho, meni na marigo, da ba muri toha kini kakareko boto rua, da tu tania boto tolu habuka beta nu lalau.” ");
INSERT INTO wiv_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","A Pita ki bada ki tatani barae, “Ia vata kua tani tanga kata mate kamaniho, ia mara beta na tania habuka beta na lalaho.” Na disaipel laveve, dia ta tani barae ve. ");
INSERT INTO wiv_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Dia ta vano bele na palaka katiu e kohanga ni Getsemani, pale, a Iesus ia tania na kana disaipel kamahi, “Miu mia ri kua, hau kata lotu.” ");
INSERT INTO wiv_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ia kohania a Pita, a Jems, a Jon, dia ka kamana. A Iesus e hatunia poloka e zobo matoto ki hatu zahatia matoto, ");
INSERT INTO wiv_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ia tania na kana disaipel kamahi, “Na polokogu e zobo matoto, ka hatunia habuka da ta mate. Miu mia ri kua miu ka tatare.” ");
INSERT INTO wiv_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","A Iesus ia pe vano dopa pitu, ia dua kara garigari, ki lotu ki hulenia a Vuvu habuka kua ni kulina, beta bizea kapou kua kete dua taduria. ");
INSERT INTO wiv_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","A Iesus e lotu ki tani barae, “Abba, Tamagu, beta goloa katiu ni vitiha ni niho. Pele kakava na kap na bizea kua ni niau. Palaka, tabarae nu muri na kagu lohoihoia, palaka katia nazia kua tu lohoia koto katia.” ");
INSERT INTO wiv_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Pale, ia vamule ia hadavia na kana disaipel tolu kua dia ta ngongoro. Ia tania kiri Pita, “Saimon, tu ngongoro? Mara beta za nu hada ni aua katiu?” ");
INSERT INTO wiv_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ia tania ni dia, “Miu tatare, miu ka lolotu habuka tabarae miu na poke na parakilakilanga. Na polokomiu e kulina kete kakatia palaka livuhamiu e buzabuza.” ");
INSERT INTO wiv_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ia vamule ve ki lotu mule, ki tania ve polea kua muga ki tania. ");
INSERT INTO wiv_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ia vamule ve ki paria habuka kana disaipel kamahi dia ta ngongoro; matadia e tuturuve matoto. Taem ki valamaridia, beta dia ne lala dia katane tani ziha ni Iesus. ");
INSERT INTO wiv_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Taem ki vamule boto toluna, ia tania kiridia, “Miu ta ba ngongoro, miu ka hihivu? Miu pale ngoroa! Miu hadavia na taem ti mai kava! Hadavia, na Tuna Kaka ti valanga na limana nuhuta moge zahazaha. ");
INSERT INTO wiv_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Miu lama, tolu kata vano! Miu hadavia, na kaka kua kete valau ti mai!” ");
INSERT INTO wiv_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Tania a Iesus ki ba tatani barae, a Iudas, katiu ni dia na 12 disaipel, ti bele kamana kabuna manumanu. Dia ta pahopaho na bainat kamana pakole. Na pararaha kana pris kamahi kamana saveman kamahi kara lo dia ta geridia dia ka maimai. ");
INSERT INTO wiv_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","A Iudas ia kava ti tani mugania ni dia pebarae, “Kaka kena hau ta domia, ia ia kena, miu paho taduria, miu na pelea ni vano.” ");
INSERT INTO wiv_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Tania a Iudas ki mai bele ni Iesus kamahi, ia vano mahoto kiri Iesus ki tani barae, “Tisa!” pale, ia domia a Iesus. ");
INSERT INTO wiv_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Pale, dia ta paho taduria a Iesus dia kene pelea vano. ");
INSERT INTO wiv_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Kaka katiu ni dia kua e madi kozoho e pazuhia kana bainat, ia kadi hutuzia talingana vora kana hetpris. ");
INSERT INTO wiv_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","A Iesus ki hulenia manumanu kua, “Hau ta lala kata vavamuga na varihubia ka mata vanaho, miu ka pelepele bainat kamana pakole kirigu, ai? ");
INSERT INTO wiv_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Dama laveve hau ta kakamamiu, ka vaketekete na poloka tempel, ki beta miu na paho taduriau. Palaka vatahia. Na polea ke Vuvu ia kete pori.” ");
INSERT INTO wiv_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Pale, na kana disaipel kamahi dia ta birika, dia kene hava tapunia. ");
INSERT INTO wiv_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Kilaka kua na kapiru huluvahu katiu, e lohoria na lavalava kavukavua katiu, ki mumuri ni Iesus. Tania na manumanu dia ka paho taduria, ");
INSERT INTO wiv_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ia zuka tapunia kana lavalava kua e lolohoria, ia pupu lavevea kini hava. ");
INSERT INTO wiv_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Dia ta pelea a Iesus kini vano kara ruma kana hetpris, na pararaha kana pris laveve ia mai na pararaha laveve ke vuni Iuda, ia mai na tisa kamahi kara lo ke Moses, dia laveve dia ta mai lupu laveve. ");
INSERT INTO wiv_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","A Pita e muri ni Iesus, palaka ki muri zauzau pitu. Ia vano kini hoho na banis na ruma kana hetpris. Ia mia kamana gat kamahi kini papaniru na haroho. ");
INSERT INTO wiv_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Na pararaha kana pris kamahi kamana kaunsil kamahi dia ta parakilania dia kata paria moge katiu kua a Iesus e katia, kua kete nap dia kata koto kiri Iesus vona, dia na hubi matehia. Palaka ki mara beta dia na paria. ");
INSERT INTO wiv_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Manumanu luba dia ta mai dia ka parakilania dia ka vairuku kirina, palaka kadia polea kini beta ni vavaridamuki. ");
INSERT INTO wiv_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Pale, manumanu taza dia ta di madi dia ta vairuku dia ka tani barae, ");
INSERT INTO wiv_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Hita ta longoria e tani barae, ‘Da ta robea na Tempel kua na manumanu bukuna garigari kua dia ta habatia, dama tolu muri, hau ta haba mulehia katiu, kua mara beta kaka ni habatia.’” ");
INSERT INTO wiv_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Palaka na polea kua dia ta katia ve, ia e batola vetaveta ve, ki beta ni varidamuki ve. ");
INSERT INTO wiv_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Pale, na hetpris e madi na matana kaunsil kamahi ia hulenia a Iesus, “Kava tu longoria na polea laveve kua na manumanu kamahi kua dia ta papadeho vona. Beta ka koliana, ai?” ");
INSERT INTO wiv_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Palaka a Iesus beta ni tania polea katiu. Pale, na hetpris ki huleni mulehia, “Ia ho a Kristus, na Tuni Vuvu kua e heta matoto?” ");
INSERT INTO wiv_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","A Iesus ki tania vona, “Ia hau za, da miu ta hadavia na Tuna Kaka e mimia na maroroni limani Vuvu kua e matuha matoto ki pe na lagato na huduna mariaba ki ziho.” ");
INSERT INTO wiv_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Pale, na hetpris ia dae terehia kana zohozohoa, ki tani barae, “Beta ve tolu kata ma kakaze kaka kua kete kavakavania na moge kana kaka kua. ");
INSERT INTO wiv_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Kava miu te longoria habuka, ti delahania a Vuvu kava. Miu ta lohoi ziha?” Pale, dia laveve dia ta tania habuka kete mate. ");
INSERT INTO wiv_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Pale, taza ni dia, dia ta vuzaria. Dia ta rotu karia matana dia ka tutuhia dia ka tatani barae kirina, “Ko tani lala, azei kua e hubiho?” Pale, na gat kamahi dia ta pelea vano dia kene huhubia. ");
INSERT INTO wiv_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","A Pita ia heva na banis kana hetpris, na tavine vora katiu kana hetpris e pe mai, ");
INSERT INTO wiv_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","tania ki hadavia a Pita kua e papaniru, ia hada nunuzia ki tania, “Ho ve tu kakamani Iesus bukuni Nasaret.” ");
INSERT INTO wiv_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Palaka a Pita e linga ki tania, “Hau beta na lala nazia kena tu popole vona.” A Pita ia di madi ia vano madi na geit, na toha ia kakareko boto katiu. ");
INSERT INTO wiv_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Na tavine vora kua ki hadavia ti vano mamadi ve rae, ia tani mulehia ve na nuhu kua dia ta mamadi kozoho vona, “Kaka kena ia katiu ni dia kena.” ");
INSERT INTO wiv_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","A Pita ia linga mule ve. Ba muri, nuhu kua dia ta mamadi kozoho ni Pita, dia ta tani barae, “E limoha, ho kua, ia ho katiu ni dia, na vuna ho tu bukuni Galili.” ");
INSERT INTO wiv_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","A Pita ki badabada matoto ki tani barae, “Ta mapamapa na hizani Vuvu, hau beta na lala na kaka kuari miu ta popole vona.” ");
INSERT INTO wiv_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Pale, na toha ia kakareko boto ruana. A Pita ia lohoi mulehia na polea, kua a Iesus e tania kirina, “Ba muri toha kini kakareko boto rua, da tu tania boto tolu, habuka beta nu lalau.” Pale, a Pita ia tangi zahazaha matoto. ");
INSERT INTO wiv_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Na damadama matoto na pararaha kana pris kamahi, kamana pararaha ke vuni Iuda, ia mai na tisa kamahi kara lo ke Moses, ia mai na kaunsil laveve, dia ta bele kamana kadia lohoihoia. Pale, dia ta rotia limani Iesus, dia kene pelea zahe vala ni Pailat kadia gavana bukuni Rom. ");
INSERT INTO wiv_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","A Pailat ki hulenia, “Ia ho na king ke vuni Iuda?” A Iesus ki kolia ki tania, “Ho tu tatania kena.” ");
INSERT INTO wiv_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Na hetpris kamahi ve dia ka papadea polea luba kiri Iesus. ");
INSERT INTO wiv_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","A Pailat ki hule mulehia ve, “Mara beta nu kolia kadia polea? Polealea luba kua dia ta papadeho vona.” ");
INSERT INTO wiv_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Palaka beta a Iesus ni makulu ni tania polea katiu. A Pailat ki zipa zahe na kana moge kua. ");
INSERT INTO wiv_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Na Krismas laveve na damana hanihania kapou kua kara Bret Beta Yis vona, a Pailat e lala kete vagotalani mulehia na kaka katiu na karabus. Muri na lohoihoia kana manumanu. ");
INSERT INTO wiv_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Kilaka kua na kaka katiu hizana a Barabas, e karabusianga na vuna kua e kamana manumanu taza dia ka katia varihubia kamani gavman, dia ka hubi matehia kaka. ");
INSERT INTO wiv_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Na manumanu dia ta kabu zahe ni Pailat dia ta hulenia kete vagotalani mulehia na karabusman katiu, habuka kua ia e lala kete kakatia boto laveve. ");
INSERT INTO wiv_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","A Pailat ki hulenidia, “E kulimiu kata vagotalani mulehia na king ke vuni Iuda ni vamule ni miu?” ");
INSERT INTO wiv_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","A Pailat e huleni barae ni dia na vuna ia e lala habuka, na pararaha kana pris kamahi dia ta gala dia ka hahada potia a Iesus, kubarae dia kene pelea zahe vala vona. ");
INSERT INTO wiv_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Palaka na pararaha kana pris kamahi dia ta padea poloka manumanu, dia ta hule varidingania a Pailat kete vagotalani mulehia a Barabas. ");
INSERT INTO wiv_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","A Pailat ki hulenidia, “Pele ki kulimiu kata kuzingania na kaka kua, miu ta kohania na king ke vuni Iuda?” ");
INSERT INTO wiv_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Dia ka goe, dia ka tania, “Havenia na kruse!” ");
INSERT INTO wiv_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","A Pailat ki hulenidia, “E kuziha? Nazia matoto e katia ki zaha?” Palaka dia laveve dia ta dopa goe dia ka tani barae, “Havenia na kruse!” ");
INSERT INTO wiv_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pale, na vuna kua e kulina kete katia poloka manumanu kua ni malugunia, ia vagotalani mulehia a Barabas, ia geu na soldia kamahi dia ta vihia a Iesus. Pale, ia vala a Iesus ni dia, dia kata havenia na kruse. ");
INSERT INTO wiv_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Na soldia kamahi, dia ta pelea a Iesus vano hoho na poloka banis na ruma ke gavman, dia ta kohani lupunia soldia laveve mai. ");
INSERT INTO wiv_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Dia ta vazohoria na kolos baritunutunua katiu, dia ta pelea na mota matangatanga taza, dia ta katia balika hate kana king, pale, dia ta taruhia na bakani Iesus. ");
INSERT INTO wiv_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Pale, dia ka tani barae, “Dama kemi matoto, king ke vuni Iuda!” ");
INSERT INTO wiv_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Dia ta pelea na kabala dia ta hubia bakana vona. Dia ka kanizunia. Dia ka padonia tuturudia na mugani Iesus dia ka katia bozubozua vona, dia ka tania habuka dia ta vala ruru vona. ");
INSERT INTO wiv_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Dia ta bozungani hozovia, dia ta pele kakava na kolos baritunutunua na livuhana, dia ta vazohoria na kana zohozohoa mule. Dia kene pelea vano kete haveanga na kruse. ");
INSERT INTO wiv_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Kaka katiu bukuni Sairini, hizana a Saimon, tamani Aleksander hiro a Rufus, e vavana kete hoho kara poloka taon. Dia ta geu varidingania kete luga na kruse ke Iesus. ");
INSERT INTO wiv_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Dia ta pelea a Iesus vano na palaka kua e kohanga ni Golgota, hiza kua a Golgota, mining vona e tani barae, “Palakana togana bakana kaka mate.” ");
INSERT INTO wiv_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Dia ta vala vaen kua dia ta pokiza kamana marasin ni Iesus. Palaka a Iesus ki beta ni hinumia. ");
INSERT INTO wiv_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Pale, na soldia kamahi dia ta havenia a Iesus na kruse, dia ta vazenia kana loholohoa kamahi, dia ta pilae satu, dia kata hada azei kete vin ni pelea kana loholohoa. ");
INSERT INTO wiv_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Dia ta havenia a Iesus na kruse na 9 kilok na dama. ");
INSERT INTO wiv_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Dia ta vapolungania na polea katiu dia ka taruhia monge langa kara bakana e tani barae, “NA KING KE VUNI IUDA.” ");
INSERT INTO wiv_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Na raskol rua e haveanga hiro kamani Iesus, katiu kiri maroro, katiu kiri mauri. ");
INSERT INTO wiv_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Manumanu dia ka pole habakabaka kirina, dia ka tara vilu, dia ka pole hilenia, dia ka tatani barae kirina, “Uaio, koto robea na tempel nu habati mulehia na dama tolu, te. ");
INSERT INTO wiv_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Pele kua, ko vaikoli kiriniho mule nu mai zipa mule na kruse!” ");
INSERT INTO wiv_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Na pararaha kana pris kamahi ve kamana tisa kamahi kara lo ke Moses, dia ve dia ta pole valabilabi kirina ve dia ka tatani barae, “E lala kete vaikoli kara manumanu motumotu, pele kua ti kuziha kini mara beta ni vaikoli kirina mule! ");
INSERT INTO wiv_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ho a Kristus kua, na king ke vuni Israel. Koto mai zipa na kruse kena, hita kata hadavia, hita na bilip ni niho.” Kaka rua kua e haveanga hiro kamana ve, hiro ta pole zahatia ve. ");
INSERT INTO wiv_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Pale, ti 12 kilok barae, na rodo kapou ia kari havutia malala laveve, ia, ia, ki 3 kilok na garavi. ");
INSERT INTO wiv_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ti 3 kilok na garavi a Iesus ia goe kapopou, ki tani barae, “Eloi, Eloi, lama sabaktani?” Mining na polea kua e kubarae, “Kagu Vuvu, kagu Vuvu, e kuziha kunu vatiau?” ");
INSERT INTO wiv_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Manumanu taza ni dia kua dia ta mamadi kozoho, dia ta longoria na polea kua e tania, dia ka tani barae, “Miu longoria, e kokoi kiri Elaija.” ");
INSERT INTO wiv_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Kaka katiu e rovo ki lutia na spans na vaen makikia, ki taruhia na tabuka ia vala ni Iesus kete hinumia. Pale, ia tani barae, “Guru, tolu kata hadavia a Elaija kete mai ni pelea ni zipa.” ");
INSERT INTO wiv_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","A Iesus ki goe kapou matoto, pale, ia mate. ");
INSERT INTO wiv_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Pale, na lavalava kapou kua e hahave na poloka tempel e tere ki pe na pidaka ki dihu rua, e pe na huduna ki ziho kara kabena. ");
INSERT INTO wiv_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Na kepten kara soldia kamahi e mamadi kozoho ni Iesus, tania ki hadavia na matea ke Iesus, ia ki tania, “E limoha, na kaka kua ia na Tuni Vuvu!” ");
INSERT INTO wiv_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Tavivine taza dia ta madi zau dia ka hahada. A Maria bukuni Makdala, ia mai a Maria titinani Jems tazini Iosep, ia mai a Salome. ");
INSERT INTO wiv_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Kua a Iesus ia ni Galili, ia na tavivine kamahi kua, dia ta mumuri vona, dia ka kokodonia. Tavivine luba kua dia ta kamani Iesus dia ka zahe kiri Ierusalem, ia dia ta mamadi ve, kilaka kua. ");
INSERT INTO wiv_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Ti garavi, a Iosep, bukuni Arimatea e mai. Ia katiu ni dia na kaunsil kamahi, manumanu dia ka lala dia kata hahada zahenia. Ia ki na kaka katiu kua e lala kete guguru kete hadavia na kingdom ke Vuvu. Na dama kua ia na kadia damana vaidahidanga kara Sabat. A Iosep beta ni kuahi, ia zahe madi na matani Pailat ia hulenia kara podani Iesus. ");
INSERT INTO wiv_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","A Pailat e lohoia ki tania a Iesus ma beta ni mate. Kubarae ia koi kara kepten kara armi mai ia hulenia ki tani barae, “E matoto a Iesus ti mate, ai?” ");
INSERT INTO wiv_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Tania na kepten kara armi kua ki tania vona habuka a Iesus ti mate kava, pale, a Pailat ia geria a Iosep kete pelea na podani Iesus. ");
INSERT INTO wiv_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","A Iosep e kadea na lavalava vahoru, ia pelea na podani Iesus zipa, ia kukulia na lavalava kini taruhia na poloka lovo e hovua na kedo. Pale, ia puke porotia na havana lovo na kedo katiu. ");
INSERT INTO wiv_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","A Maria bukuni Makdala, hiro a Maria titinani Iosep, hiro ta hada na palaka kua e vangoroa na podani Iesus vona. ");
INSERT INTO wiv_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Muri na Sabat, a Maria bukuni Makdala, ia mai a Maria titinani Jems, ia mai a Salome, dia ta kadea na wel kamana sanda, dia kata vano taruhia na podani Iesus. ");
INSERT INTO wiv_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Na damadama na Sande, dia ta vano kara matmat. ");
INSERT INTO wiv_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Dia ta vano na dala dia ta varihulei, “Da azei e puke kakava na kedo na hatamara lovo kiridolu?” ");
INSERT INTO wiv_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Palaka tania dia kata tunga zahe, dia ta hadavia na kedo kapou matoto kua, ti puke kakavanga kava na havana lovo. ");
INSERT INTO wiv_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Tania dia ka vano hoho na lovo, dia ta hadavia na tamohane huluvahu katiu e mimia kara paligena kiri maroro. Kana loholohoa e kavukavua ki malaku. Dia ka zipa zahe. ");
INSERT INTO wiv_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ia ki tania ni dia, “Taua miu na zipa zahe. Hau ta lala miu ta hahada kiri Iesus bukuni Nasaret, kua e haveanga na kruse. Ti beta ia ri. Kava ti mahuri mule! Miu hadavia, kua palaka dia ta vangorea vona kua. ");
INSERT INTO wiv_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Palaka miu vano tania na kana disaipel kamahi kamani Pita, ‘Ia ti vamuga ni miu kini vano kiri Galili. Ni Galili, ia da miu ta hadavia, habuka kua e tania ni miu muga.’” ");
INSERT INTO wiv_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Tavivine kamahi kua polokodia e zobo matoto livuhadia ki vavani, dia ta gotala na lovo dia kene varihavai. Beta dia na kalohunia na kaka katiu, na vuna dia ta kuahi. ");
INSERT INTO wiv_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Kilaka kua a Iesus e mahuri mule na damadama na Sande, e muga ki bele ni Maria bukuni Makdala, tavine kua muga a Iesus e pele kakava na vule zaha e 7 vona. ");
INSERT INTO wiv_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Tavine kua ia vano tania na nuhu kua dia ta lala dia kata kakamani Iesus. Dia kua, lohorodia e zaha dia ka tatangi. ");
INSERT INTO wiv_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","A Maria ki tania ni dia habuka, a Iesus ti mahuri mule kava. Ia ki hadavia a Iesus ve, palaka beta dia na bilip vona. ");
INSERT INTO wiv_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Muri na kua, na disaipel rua hiro ta vatia taon hiro ka vavana vano. A Iesus ia bele ni hiro, e hada motumotu. ");
INSERT INTO wiv_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Hiro ka vano kalohunia ve na disaipel taza ve, palaka beta dia na bilip na kahiro polea. ");
INSERT INTO wiv_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ba muri, a Iesus ia bele na kana 11 disaipel kamahi. Kilaka kua na disaipel kamahi dia ta hahanihani. Ia pole kiridia, na vuna kua beta dia na bilip, ki beta ve ni kulidia dia kata bilip na nuhu kua dia ta muga hadavia kilaka kua e mahuri mule. ");
INSERT INTO wiv_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ia tania ni dia, “Miu vano kara palakalaka laveve na vulovulo miu na kalohunia na Kalohua Kemi na manumanu laveve. ");
INSERT INTO wiv_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Azei kua e bilip ki pelea baptais ia da a Vuvu e pele mulehia na matea; azei kua tani beta ni bilip ia da e koto voa kirua. ");
INSERT INTO wiv_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Nuhu kua dia ta bilip da ta vala matuhanga ni dia, dia kata katia mirakel kamahi, na hizagu da dia ta pele kakava vule zaha kamahi, dia ka popole na pole matotoa kua beta dia na lala varira. ");
INSERT INTO wiv_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Da dia ta pahoria matabunu zaha na limadia, kua dia na hinumia na goloa kua posin vona, ia mara beta dia na mate. Da dia ta taruhia limadia na manumanu kua e mazahitidia, dia ka kemi mule.” ");
INSERT INTO wiv_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Na Paraha a Iesus, e pole hozo kamana kana disaipel kamahi, a Vuvu ia pelea kini zahe kara lagato, kini mia na maroroni limani Vuvu. ");
INSERT INTO wiv_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Pale, kana disaipel kamahi dia ta vano dia kene vavala polea kana Paraha na palakalaka laveve. Na Paraha ki gala kamadia ki vatuharia kana polea, kamana mirakel kamahi kua dia ta kakatia. ");
INSERT INTO wiv_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Manumanu luba dia ta parakilania dia kata vapolungania ripot na goloaloa kua ti bele na pidaka dolu. ");
INSERT INTO wiv_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Dia ta vapolungania muri na polea kana nuhu kua dia ta hada goloaloa kua e bele na matadia matoto, dia ka gagala na valavalanga na polea kana Paraha na manumanu. ");
INSERT INTO wiv_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Kubarae, kahita paraha ho, hau mule ka hada papa matoto ka kaze papa kara varivuvuka polea laveve kua. Kubarae hau ka lohoia e kemi kata vapolu kemihia ka, nazia kua e bele na varivuvuka matoto. ");
INSERT INTO wiv_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Koto hazenia polealea kua, nu lala polea kua e tatanga ni niho, e matoto. ");
INSERT INTO wiv_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Kilaka kua a Herot ia e king ni Iudea, na pris katiu, hizana a Sekaraia ia bukuna kabuna pris kamahi kua na laen ke Abiya. A gona a Elisabet, ia tubuni Aron. ");
INSERT INTO wiv_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Hiro ruarua hiro ta mahoto na matani Vuvu. Hiro ka mumuri matoto na polea kamana lo kana Paraha, ki beta ni dangea kaka katiu kete gegehiro na kahiro mianga. ");
INSERT INTO wiv_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Palaka beta tuhiro, na vuna zia a Elisabet e kupi. Hiro kene lapun marata ve. ");
INSERT INTO wiv_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Boto katiu kilaka kua na kabu ke Sekaraia, ti kadia dama kara galanga, a Sekaraia ia e gagala habuka na pris katiu na mugani Vuvu na poloka tempel. ");
INSERT INTO wiv_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Muri na maki ke habu tubudia, kua na pris kamahi kua dia ta lala dia kata mumuri vona, dia ta pilae satu dia kata paria azei ni dia kete tunia virauh. Dia ta makia a Sekeraia kete tunia virauh. Pale, ia kini hoho kara tempel kana Paraha. ");
INSERT INTO wiv_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Kilaka e hoho kete tunia virauh, manumanu luba matoto, dia ta lohu, dia ka lolotu na hatama. ");
INSERT INTO wiv_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Pale, na engel katiu kana Paraha e bele vona, ki madi na marorona palaka kua dia ta lala dia kata tunia virauh kara opa vona. ");
INSERT INTO wiv_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Tania a Sekaraia ki hadavia, ia ridi, ki kuahi matoto. ");
INSERT INTO wiv_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Palaka na engel ki tania vona, “Taua nu kuahi, Sekaraia, ka lotua kava ti longora. Go a Elisabet, da e valohia tu tamohane katiu. Da tu kohania hizana ni Jon. ");
INSERT INTO wiv_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Kapiru kua da tu hilohilo matoto vona. Manumanu luba da dia ta hilohilo matoto kua ta tinana ni valohia. ");
INSERT INTO wiv_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Na vuna zia da ia e paraha katiu na matani Vuvu. Da beta kete hinumia vaen o hinua matuha. Da e ba vovona na magalini titinana ki vonu na Vule Tumonga. ");
INSERT INTO wiv_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Da e pele mulehia lohoihoia kana manumanu luba bukuni Israel dia kata vamule na Paraha kadia Vuvu. ");
INSERT INTO wiv_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Da ia e pe vamuga na Paraha, da e pelea maki ke Elaija kamana kana matuhanga, kete vile lupuni mulehia kapirupiru dia na lupu mule kamani habu tamadia, kete vahotovia lohoihoia kana nuhu kua dia ta talinga zahazaha, dia kata pele mulehia lohoihoia mahoto ke Vuvu, kete vahotovia lohoihoia kana manumanu dia kata muri na Paraha.” ");
INSERT INTO wiv_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","A Sekaraia ki tania na engel, “Da ta lala zingania matoto goloa kua? Hau te lapun zaha matoto, gogu ve ti lapun marata.” ");
INSERT INTO wiv_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Na engel kua ki kolia ki tania, “Hau a Gabriel. Hau ta lala kata mamadi na matani Vuvu, ki geura hau kata kalohunia polea kemi kua ni niho. ");
INSERT INTO wiv_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Kua da hava e zobo ki beta koto pole ki mule na dama goloaloa laveve kua ta tania ki bele matoto. Na vuvuna e beta nu bilip na kagu polea. Kagu polea da pori matoto na dama kena kava ti makua.” ");
INSERT INTO wiv_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Manumanu na hatama, dia te guruguru kiri Sekaraia dia ka lohoi tori, e kuziha kini havarau marata na poloka tempel? ");
INSERT INTO wiv_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Tania ki pe gotala, havana ti zobo, kini mara beta ni pole kamadia. Dia ta lohoi lala habuka ia ti hada na visen katiu na poloka tempel, kuza barae kini beta ni popole kamadia. E pole kamadia na limana za. ");
INSERT INTO wiv_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Tania ki vahozovia kana dama kara galanga na tempel, ia vamule kara kana ruma. ");
INSERT INTO wiv_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Muri na kua, a gona, a Elisabet ia kove, ia ma mia paritigi, lingabo lima. ");
INSERT INTO wiv_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ia tani barae, “Na Paraha ti katia goloa kua ni niau kini vahozovia kagu puaea na pidaka manumanu.” ");
INSERT INTO wiv_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Lingabo 6 vona kena a Elisabet e magalina, a Vuvu ia geria a engel Gabriel kiri Nasaret, na taon katiu ni Galili, ");
INSERT INTO wiv_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","kete vano na tavine tizula katiu kua e ma beta ni ngoro kamana tamohane katiu, e habahabanga kete kabania tamohane katiu, hizana a Iosep, ia zukani Devit. Hizana tizula kua a Maria. ");
INSERT INTO wiv_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Na engel e vano vona ia tani barae vona, “Dama kemi ni niho. Paraha e kamaniho. Paraha ia e dopa ki kulina matoto kiriniho.” ");
INSERT INTO wiv_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","A Maria e lohoi tori matoto na kana polea ki lohoihoi, na polea zia matoto kua. ");
INSERT INTO wiv_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Palaka na engel e tania vona, “Taua nu kuahi, a Vuvu e dopa ki mahariho. ");
INSERT INTO wiv_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Longoria! Da tu kove ku valohia kapiru tamohane katiu. Da tu kohania ni Iesus. ");
INSERT INTO wiv_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Da ia e kara paraha katiu, ki kohanga ia na tuni Vuvu kua ia e heta matoto. Na Paraha, a Vuvu da e vala matuhanga kapou vona baliki tubuna a King Devit. ");
INSERT INTO wiv_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Da e king ki hada na manumanu ke Jekop na dama laveve. Kana kingdom mara beta ni hozo.” ");
INSERT INTO wiv_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","A Maria ki hulenia, “Da e bele ziha? Ma beta na ngoro kamana tamohane katiu.” ");
INSERT INTO wiv_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Na engel ki kolia ki tania, “Na Vule Tumonga da e mai ni niho na matuhanga ke Vuvu da e kari havutiho. Kubarae kapiru kena koto valohia, da e tumonga ki kohanga ia ni tuni Vuvu. ");
INSERT INTO wiv_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Longoria! A vineke a Elisabet kua ia ti lapun matoto palaka da e valohia kapiru katiu, manumanu dia ta tania e kupi palaka kava ti vatia lingabo ti 6. ");
INSERT INTO wiv_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Na vuna zia, beta goloa katiu ni vitiha ni Vuvu.” ");
INSERT INTO wiv_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","A Maria ki tania, “Hau tavine vora ke Vuvu. Ia e dangea kete katia ni niau balika kena tu tania.” Pale, na engel kini vatia. ");
INSERT INTO wiv_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Muri na kua, a Maria e vaida kana goloaloa ia baribari vano kara taon katiu e ngoro na pidaka potuna kamahi ni Iudea. ");
INSERT INTO wiv_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","E bele na ruma ke Sekaraia, ia dama kamani Elisabet. ");
INSERT INTO wiv_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Tania a Elisabet ki longoria damanga ke Maria, na kapiru na poloki magalini Elisabet ia raga, a Elisabet ki vonu na Vule Tumonga. ");
INSERT INTO wiv_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ia goe kapopou ki tania, “Paraha e kati kemihia matoto ni niho na tavivine laveve. Paraha da kati kemihia ve na kapiru kena na magali! ");
INSERT INTO wiv_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Hau azei matoto kua, na tinana kagu Paraha ki mai ki balaheau? ");
INSERT INTO wiv_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Kamana ku dama kamaniau talingagu ki longoria ka damanga, kapiru na poloki magaligu e marapalepalehia ki raga. ");
INSERT INTO wiv_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Paraha da e kati kemihia matoto na tavine kua e bilip na goloa kua na Paraha e tania kete bele vona.” ");
INSERT INTO wiv_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","A Maria ki tani barae, “Vulegu e vazahenia hizana Paraha. ");
INSERT INTO wiv_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Polokogu ki hilohilo ni Vuvu ia kua ti vavaikoli kiriniau. ");
INSERT INTO wiv_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ia ti hada lala habuka kana vora e beta ni hizanga. Meni kua ki vano muri na dama laveve, manumanu laveve da dia ta kohaniau na tavine kua a Vuvu e katia ki hilohilo. ");
INSERT INTO wiv_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Na vuna na goloa kapopou kua a Vuvu kua kana matuhanga e kapou matoto, kua e katia ni niau. Hizana e tumonga. ");
INSERT INTO wiv_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Varira matoto ki mai ki meni kua, kana mahariharia kara manumanu e lala kete vano na nuhu kena dia ta lolohoi kuahia vona. ");
INSERT INTO wiv_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","A Vuvu ti katia goloa kapou matoto na limana ia ti vaka buratania nuhu kua dia ta vazahenidia mule. ");
INSERT INTO wiv_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ia ti pele kakava king luba na kadia sia king, palaka ia e vazahenia nuhu kua dia ta lala dia kata vazihoni mulehidia. ");
INSERT INTO wiv_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","E vangania nuhu kua e vitolonidia kamana goloa kemikemi, palaka ia ki geri kakava nuhu kua dia ta ris, kamana limadia vetanga. ");
INSERT INTO wiv_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Ia ti kodonia kana vora a Israel, ki lohoia kete maharia a Abraham kamani habu tubuna dama laveve, habuka e mapamapa ni habu tamadolu varira.” ");
INSERT INTO wiv_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","A Maria e mia kamani Elisabet lingabo tolu, ba muri kini vamule kara kana malala, a Nasaret. ");
INSERT INTO wiv_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Na dama ke Elisabet keteni valohia tuna ti bele, ia valohia tuna tamohane katiu. ");
INSERT INTO wiv_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Manumanu dia ta mia kozoho vona kamani habu vineka, dia ta longoria habuka Paraha ti maharia matoto. Dia ta hilohilo kamana. ");
INSERT INTO wiv_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Na dama 8 vona, dia ta mai, dia kata vatomutomuhia na kapiru. Dia na kohania ni Sekaraia, muri na hizani tamana. ");
INSERT INTO wiv_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Palaka titinana ia tania, “Beu da ia e kohanga ni Jon.” ");
INSERT INTO wiv_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Dia ka tani barae vona, “Beta vineke katiu ni koi bareanga na hiza kena.” ");
INSERT INTO wiv_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Dia ta pole na limadia kamana tamana kapiru. Dia kata pari vutuhia kana lohoihoia e kulina kete kohania kapiru na hiza zei matoto. ");
INSERT INTO wiv_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ia hule kara slet katiu. Manumanu laveve dia ta zipa zahe kilaka kua ia ti vapolungania hiza kua, “A Jon.” ");
INSERT INTO wiv_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Kilaka pamuhi havana ia ngapa, lavena ia pakoko. Pale, ia kini pole. Kini vavazahenia hizani Vuvu. ");
INSERT INTO wiv_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Manumanu dia ta mia kozoho ni dia, dia ta lohoi kuahia na goloa kua e bele. Na potuna ve ni Iudea laveve, manumanu dia ta popole ve na goloa kua e bele. ");
INSERT INTO wiv_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Manumanu laveve, kua dia ta longoria goloa kua e bele, dia ka lohoi tori vona, dia ka varihulei, “Kapiru kua, da kara kaka zia matoto?” Dia ta tatani barae, na vuna, na matuhanga kana Paraha ia vona. ");
INSERT INTO wiv_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Tamani Jon, a Sekaraia e vonu na Vule Tumonga, ia ki pole na polea ke Vuvu balika profet ki tani barae, ");
INSERT INTO wiv_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Mai tolu na vazahenia hizana Paraha, a Vuvu ke Israel. Na vuna ia ti mai kini kodonidolu kana manumanu kini pele gotalani mulehidolu na karabus. ");
INSERT INTO wiv_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","A Vuvu ti vala kaka matuha katiu kete vaikoli. Ia na tubuna vora ke Vuvu, a Devit. ");
INSERT INTO wiv_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","A Vuvu e tania na havana kana profet tumonga, bukuni varira. ");
INSERT INTO wiv_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Habuka da e vaikoli kiridolu na hadolu vagi kamahi, na limana nuhu laveve kena beta ni kulidia kiridolu, ");
INSERT INTO wiv_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","kete vatunga mahariharia kiri habu tubudolu, ia mai kete lohoi mulehia kana mapamapanga tumonga, varira e katia kamadia. ");
INSERT INTO wiv_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Na mapamapanga kena e katia kamani tubudolu a Abraham, ");
INSERT INTO wiv_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","kete vaikoli kiridolu na limana hadolu vagi. Ni dangea tolu kata gala kana Paraha ni beta tolu kata kuahi. ");
INSERT INTO wiv_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Tolu na gala kana Paraha na maki Tumonga, ia mai maki mahoto na matana Paraha na dama laveve. ");
INSERT INTO wiv_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ho, na tugu, da e kohanga ho na profet katiu ke Vuvu kua e dopa ki heta matoto. Na vuna da ho tu pe vamuga na Paraha koto vaida dala kirina. ");
INSERT INTO wiv_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Koto tania na manumanu habuka a Vuvu da e lohoi bala kadia manaunaua. Na dala kua za ia da e vaikoli kiridia. ");
INSERT INTO wiv_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Na vuna na mahariharia kemi kana kadolu Vuvu, da na balangana kana vaikolia e habuka voro kua e mia zahe, kua e pe na lagato ki balanga dolu nuhu kua tolu ta mimia na rodo kamana lirungana matea, kete vatunga dala tolu kata magali katiu kamani Vuvu.” ");
INSERT INTO wiv_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Pale, na kapiru ia paraha, ki bada na lohoihoia ke Vuvu. E mia na poloka deset ki mule na dama e bele kakava na matani vuni Israel. ");
INSERT INTO wiv_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Kilaka kua a Sisar Ogastus e vala lo katiu habuka kete katua senses ni hazeanga manumanu laveve na malala laveve kena a Rom e hada vona. ");
INSERT INTO wiv_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Senses kua ia varivuvuka senses laveve kete katua na malala laveve kua a Rom e hada ni dia. Kilaka kua a Kwirinius e gavana ni Siria. ");
INSERT INTO wiv_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Manumanu laveve dia ta vano kara kadia taon mule kete vapolunganga hizadia. ");
INSERT INTO wiv_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Pale, a Iosep ia ve vatia a Nasaret ni Galili. Ia vano kiri Iudea, kara taon ke Devit, a Betlehem. Na vuna zia ia na tubuni King Devit. ");
INSERT INTO wiv_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ia e vano kete vapolunganga hizahiro a Maria. A Maria e habahabanga kete kabania a Iosep, kilaka ve a Maria e magalina. ");
INSERT INTO wiv_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Kilaka dia ta ba vovona ni Betlehem na kapiru ti hubia lamani Maria kini hatunia keteni zuru. ");
INSERT INTO wiv_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Pale, ia valohia tuna muganga, tuna tamohane. E kukulia na lavalava, ki vangorea na lagova, na vuna zia beta matoto zeleka na rumaka ngoroa. ");
INSERT INTO wiv_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Kilaka kena na marigo, nuhuta hada potopotoa na sipsip dia ta hada poto na kadia sipsip na hiripa taon. ");
INSERT INTO wiv_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Na engel kana Paraha e bele ni dia kamana glori kana Paraha ki balanga lobidia. Dia ka kuahi matoto. ");
INSERT INTO wiv_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Palaka na engel kua e tania ni dia, “Taua miu na kuahi. Hau ta mai kamana kalohua kemi kara hilohiloa kapou kua kana manumanu laveve. ");
INSERT INTO wiv_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Meni kua na taon ke King Devit kamiu kakanaka vaikolia ti valohua. Ia a Kristus na Paraha! ");
INSERT INTO wiv_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Da miu ta hada lala baraenia. Da miu ta paria kapiru katiu e valohua ki kukula na lavalava ki ngongoro na lagova.” ");
INSERT INTO wiv_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Kamana na engel kua ki tani barae, na engel luba matoto bukuna lagato dia ta bele valutu. Dia ta vazahenia hizani Vuvu, dia ka tania, ");
INSERT INTO wiv_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Glori ni Vuvu kua ia e heta matoto. Na garigari magali kemia na nuhu kena a Vuvu e kulina kiridia.” ");
INSERT INTO wiv_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Kamana na engel kamahi dia ka vatidia, dia ka zahe mule kara lagato, nuhuta hada potopotoa na sipsip dia ta varitaninia, “Tolu kata vano kiri Betlehem. Tolu na hada goloa kua ti bele, kua na Paraha e tania ni dolu.” ");
INSERT INTO wiv_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Pale, dia ta baribari vano, dia ta paria a Maria kamani Iosep, na kapiru e ngongoro na lagova. ");
INSERT INTO wiv_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Kamana dia ka hadavia, dia ta kavakavania na polea kua na engel e tania ni dia na vuna na kapiru kua. ");
INSERT INTO wiv_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Manumanu laveve kua dia ta longoria nuhuta hada potopotoa na sipsip dia ta tania polea kua ni dia. Dia ta ridi matoto. ");
INSERT INTO wiv_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Palaka a Maria ia taruhia goloaloa laveve kua na poloka za ki ma lolohoi nanazia. ");
INSERT INTO wiv_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Nuhuta hada potopotoa na sipsip dia ta vamule. Dia ta habi hilohilo dia ka vala glori, dia ka vazahenia hizani Vuvu na vuna goloaloa kua dia ta longoria dia ka hadavia. Ia e bele habuka kua na engel e tania ni dia. ");
INSERT INTO wiv_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Na dama 8, mahoto na dama kena keteni vatomutomuha, ia kohanga hizana ni Iesus, na hiza kua na engel e vala muga vona, ba muri a titinana kini kovenia. ");
INSERT INTO wiv_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ti dama ke Iosep hiro a Maria hiro keteni vahozovia kahiro mia loloa hiro na vala opa, muri na lo ke Moses kua e tania dia ta katia, dia na klin mule na matana Paraha. A Iosep hiro a Maria hiro ta pelea na kapiru a Iesus vano kiri Ierusalem, hiro kata vala na Paraha, ");
INSERT INTO wiv_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","habuka kua e vapolunganga na lo kana Paraha, ki tani barae, “Kapiru tamohane muganga laveve ia mai manu muganga tamohane laveve ia kete valanga kana Paraha.” ");
INSERT INTO wiv_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Hiro kata vala opa muri na lo kana Paraha kua e tani barae, “Na balu kapou rua o na huluvahuta balu rua.” ");
INSERT INTO wiv_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Kilaka ve kaka katiu ni Ierusalem e kohanga ni Simeon, ia e kaka mahoto ki lala kete muri matoto na lohoihoia ke Vuvu. Ia e gala ki guguru kara kaka kena kete mai ni pele kakava kadia bizea ni Israel. Na Vule Tumonga e kamani Simeon. ");
INSERT INTO wiv_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Na Vule Tumonga kava ti tani kakava ni Simeon habuka, da muga ki hada tuna Paraha a Kristus, ba muri kini mate. ");
INSERT INTO wiv_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Na Vule Tumonga e pelea a Simeon ia hoho kara tempel. Kamana a Maria hiro a Iosep hiro ka pelea kapiru a Iesus ki hoho, hiro kata katia nazia kua na lo ke habu tubudia e tania, ");
INSERT INTO wiv_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","a Simeon ia luga kapiru, ia vazahenia hizani Vuvu ki tania, ");
INSERT INTO wiv_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Paraha, e bele mahoto habuka tu mapamapa ni niau, pale, kua, vatia ka vora ni mate kamana magali kemia. ");
INSERT INTO wiv_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Na vuna zia matagu ti hadavia ka dala kua koto nu vaikoli kara manumanu vona, ");
INSERT INTO wiv_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","kua kava tu vaida na matadia laveve. ");
INSERT INTO wiv_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Na laet kua ia kete vatunga kakava lohoihoia ke Vuvu na manumanu kua beta dia na bukuni Iuda. Mai ve da ia e katia nuhu kua beta dia na bukuni Iuda dia ka vala glori ni Israel.” ");
INSERT INTO wiv_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Na tamana kapiru kamana titinana kapiru, hiro ta lohoi tori na polea ke Simeon kua e tatania kara kapiru. ");
INSERT INTO wiv_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Pale, a Simeon e blesimdia, ia tania ni Maria, “Manumanu luba ni Israel da dia ta pole katia a Iesus, kubarae da a Vuvu e vairohidia. Palaka manumanu taza da dia ta muri vona, kubarae a Vuvu da e vaikoli kiridia. Da ia e habuka mak katiu kua a Vuvu e vala manumanu kete hadavia, palaka manumanu luba da dia ta pole katia a Iesus. ");
INSERT INTO wiv_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ia na maki kua za, ia da manumanu dia ta vatunga kakava kadia lohoihoia kena e ngoro paritigi. Kubarae Maria, nu hada moge kua e katua ni tu da tu sore matoto. Sore tu hatunia, da e varitihi habuka bainat e padeho.” ");
INSERT INTO wiv_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Kilaka ve na profet tavine katiu, hizana a Ana, na tuni Fanuel, ia tubuni Aser, e lapun matoto. Varira e lahi krismas e 7. ");
INSERT INTO wiv_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Pale, gona ia mate, ia kini gabu. Kana krismas ti 84. Ki beta ni lala kete hivu na tempel, dama laveve ia e lolotu barae za, na dama, na marigo, ki tatabunia haninga ki lolotu. ");
INSERT INTO wiv_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Kilaka pamuhi e zahe ni Iosep kamani Maria, ia hate motunia a Vuvu, kini tatani kavakava polea na vuna na kapiru (a Kristus), na nuhu kua dia ta guguru dia ka hahada kara dama kua a Vuvu kete vaikoli kiri Israel vona. ");
INSERT INTO wiv_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Kamana a Iosep hiro a Maria hiro ka kati hozovia goloa laveve kena na lo kana Paraha e tania hiro kata katia, hiro ta vamule kiri Galili kara kahiro taon a Nasaret. ");
INSERT INTO wiv_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Pale, kapiru a Iesus ia paraha. Livuhana ia bada, ki vonu matoto na lohoihoia pa. Na Paraha e kati kemihia matoto vona na dama laveve. ");
INSERT INTO wiv_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Na krismas laveve a vuni Iuda dia ta lala dia kata katia hanihania kapou dia kata lohoi mulehia na taem kua varira matoto a Vuvu e pele mulehidia dia ka gotala ni Isip, kubarae na krismas laveve tamani Iesus kamani titinani Iesus hiro ta lala hiro kata vano kiri Ierusalem kara hanihania kapou kua na Pasova. ");
INSERT INTO wiv_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Kamana krismas ke Iesus ti 12, muri na kadia maki na krismas laveve, dia ta vano kara kadia damana hanihania kapou ni Ierusalem. ");
INSERT INTO wiv_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Na hanihania kapou kua e pelea wik katiu, muri vona a tamani Iesus hiro a tinana, hiro ta vavana vamule. Palaka beta hiro na lala habuka na kapiru a Iesus, e ba vovona ni Ierusalem. ");
INSERT INTO wiv_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Hiro ta lohoia hiro ka tania ia e vavana lupu kamadia. Dia ka vavana dama katiu kakava. Pale, hiro kene ba kaze kirina na pidaki habu vinekedia kamani habu kurakuradia. ");
INSERT INTO wiv_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Beta hiro na paria na pidaka dia, hiro ta vamule kiri Ierusalem, hiro kata kaze kirina. ");
INSERT INTO wiv_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Muri na dama tolu hiro ta paria na poloka tempel e mimia na pidaka tisa kamahi, ki lolongoridia ki hulenidia na hulea taza. ");
INSERT INTO wiv_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Manumanu laveve kua dia ta longoria kana polea, dia ta zipa zahe na kana save kamana kana kolikolia na hulea. ");
INSERT INTO wiv_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Kamana titinana kamani tamana, hiro ka hadavia, hiro ta lohoi toritori matoto. A titinana ki tani barae vona, “Tugu, e kuziha ku kuza barae ni miro? Miro a kamama, miro ta vari matoto miro ka kakaze tori matoto kiriniho.” ");
INSERT INTO wiv_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","A Iesus ki hulenihiro, “E kuziha, mo ka kakaze kirigu? Beta mo na lala, hau kata gala na galanga ke Tamagu?” ");
INSERT INTO wiv_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Palaka beta hiro na longo lala nazia a Iesus e tatania ni hiro. ");
INSERT INTO wiv_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Pale, ia kamahiro ziho kiri Nasaret ki lala kete lolongoria kahiro polea. Palaka a titinana e ma ki tataruhia goloaloa laveve kua na poloki magalina. ");
INSERT INTO wiv_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","A Iesus e paraha zahe kamana lohoihoia kemi. A Vuvu kamana manumanu ve dia ta dopa ki kulidia matoto kirina. ");
INSERT INTO wiv_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ti krismas ti 15 kua na Sisar a Taiberius, e king ni Rom. Kilangata a Pontius Pailat e hada na provins a Iudea, a Herot e hada na provins a Galili, tazini Herot a Filip, e hada na provins a Ituria kamani Trakonitis, a Lisanias e hada na provins a Abilene. ");
INSERT INTO wiv_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Kilaka kua a Anas hiro a Kaiafas hiro ta hetpris, na polea ke Vuvu e bele ni Jon tuni Sekaraia na poloka deset. ");
INSERT INTO wiv_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ia vavana na malala laveve kozoho na naru a Iordan ki vala polea kana Paraha na manumanu, habuka dia kata pokizia magalidia, dia na pelea baptais, a Vuvu ni pele kakava kadia manaunaua. ");
INSERT INTO wiv_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Habuka e vapolunganga na buk ke profet Aisaia ki tanga, “Na halingana kaka katiu e kokoi na poloka deset, ‘Vaida dala kara Paraha, katia dala ni mahoto kirina. ");
INSERT INTO wiv_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Vavonuhia lolona kamahi. Potuna kapopou kamana potuna kotekote kete katua ni mahoto. Dala makilokiloa kete katua ni mahoto. Dala potupotura kete mahoto. ");
INSERT INTO wiv_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Manumanu laveve na garigari dia kata hadavia vaikolia ke Vuvu.’” ");
INSERT INTO wiv_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","A Jon ki tani barae kara kabuna manumanu kua dia ta mamai vona kete vazuguvidia, “Miu habu tutuna humata! Azei ti tani hoto ni miu, miu kene varihavai na magali varitihia ke Vuvu, kua kozoho keteni mai? ");
INSERT INTO wiv_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Miu kene pokizia magalimiu, pele miu ta vatunga moge kemi kamana. Tabarae miu na ta tani barae kirimiu mule, ‘Hita tubuhita a Abraham.’ Hau ta tania ni miu ia vata kua miu ta habu tubuni Abraham, palaka ta beta miu na pokizia magalimiu, ia da miu ta mate. Ta tani matotonia ni miu, a Vuvu e dangea kete katia kedo kamahi kua dia na kara habu tubuni Abraham. ");
INSERT INTO wiv_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Na kira kavanga ti taru kozohota na voraka hai kamahi, hai laveve kena beta ni lala kete vua papa, da e hurava ki varaganga kara haroho.” ");
INSERT INTO wiv_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Manumanu laveve, dia ta hule, “Pele da nazia hita katane katia kua?” ");
INSERT INTO wiv_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","A Jon e kolia ki tania, “Azei kini ka siot rua, da tu vala katiu na kaka kua beta kana vona. Azei ve kini ha haninga vona, koto vazenia ve.” ");
INSERT INTO wiv_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Taza ni dia nuhuta pelepelea na takis, dia ta mai kete vazuguvadia, dia ta hulenia, “Tisa, nazia da hita kata katia?” ");
INSERT INTO wiv_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ia tania ni dia, “Taua miu na vilehi maratania monina takis na manumanu ni livutia mak kena a Sisar e makia, miu kata pelea.” ");
INSERT INTO wiv_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Soldia taza ve dia ta hulenia, “Pele hita? Nazia hita kata katia?” Ia tania ni dia, “Taua miu na ditaduria manumanu miu na vanahedia. Taua miu na vairuku veta kara manumanu. Miu pelea moni e kadoa miu vona za, ia pale.” ");
INSERT INTO wiv_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Manumanu dia te guguru kiri Kristus kua kete mai, dia ka lohoihoi na polokodia mule habuka, karae a Jon ia a Kristus za, kaka kua a Vuvu e makia kete pele mulehidolu? ");
INSERT INTO wiv_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Palaka a Jon ki tania ni dia laveve, “Hau ta vazuguvimiu na naru, palaka kaka katiu e ba mumuri, ia e dopa ki paraha ni niau, hau beta na kaka kemi na dangea kata hulia mota na kana su. Ia da e vazuguvimiu na Vule Tumonga kamana haroho. ");
INSERT INTO wiv_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ti pahoria kana savol kete varaga zahenia vit na kavili kete habi kakava hulita vit. Na paleka vit da e taru hohoria na rumaka vit. Palaka da e tunia na hulita vit na haroho kena beta ni mamate.” ");
INSERT INTO wiv_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Kamana polealea luba ve a Jon e ratarata ki vaketekete na Kalohua Kemi na manumanu. ");
INSERT INTO wiv_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Palaka a Jon e pole kiri Herot, na kaka kua e hada na provins a Galili, taraka kua e kabania a Herodias, goni tazina, ia mai ve taraka goloaloa zahazaha taza ve kua a Herot e kakatia. ");
INSERT INTO wiv_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Kamana goloaloa zahazaha kua a Herot e katia muga, ia ti taru langaria ve goloa zaha matoto na huduna moge zahazaha laveve kena, kua ti pelea ve kini karabusnia ve a Jon. ");
INSERT INTO wiv_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Kilaka kena na manumanu laveve e vazuguvadia, a Iesus ve e vazuguva, ki lolotu, na lagato ia ngapa. ");
INSERT INTO wiv_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Na Vule Tumonga ia tali tadu kara huduna mangana balu, na halinga katiu e pe na lagato ki tania, “Ho tugu, hau e kuligu matoto kiriniho, hau te hate motuniho matoto.” ");
INSERT INTO wiv_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Kilaka kua a Iesus e varivuvunia kana galanga kana krismas e 30. Dia ka lohoia dia ka tania ia na tuni Iosep. A Iosep ia tuni Heli, ");
INSERT INTO wiv_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","A Heli ia tuni Matat, a Matat ia tuni Livai, a Livai ia tuni Melki, a Melki ia tuni Janai, a Janai ia tuni Iosep, ");
INSERT INTO wiv_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Iosep ia tuni Matatias, a Matatias ia tuni Amos, a Amos ia tuni Nahum, a Nahum ia tuni Esli, a Esli ia tuni Nagai, ");
INSERT INTO wiv_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","A Nagai ia tuni Mat, a Mat ia tuni Matatias, a Matatias ia tuni Semen, a Semen ia tuni Josek, a Josek ia tuni Joda, ");
INSERT INTO wiv_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","A Joda ia tuni Joanan, a Joanan ia tuni Resa, a Resa ia tuni Serubabel, a Serubabel ia tuni Sealtiel, a Sealtiel ia tuni Neri, ");
INSERT INTO wiv_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","A Neri ia tuni Melki, a Melki ia tuni Adi, a Adi ia tuni Kosam, a Kosam, ia tuni Elmadam, a Elmadam ia tuni Er, ");
INSERT INTO wiv_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","A Er ia tuni Josua, a Josua ia tuni Elieser, a Elieser ia tuni Jorim, a Jorim ia tuni Matat, a Matat ia tuni Livai, ");
INSERT INTO wiv_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","A Livai ia tuni Simeon, a Simeon ia tuni Iuda, a Iuda ia tuni Iosep, a Iosep ia tuni Jonam, a Jonam, ia tuni Eliakim, ");
INSERT INTO wiv_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","A Eliakim ia tuni Melea, a Melea ia tuni Mena, a Mena ia tuni Matata, a Matata ia tuni Natan, a Natan ia tuni Devit, ");
INSERT INTO wiv_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","A Devit ia tuni Jesi, a Jesi ia tuni Obet, a Obet ia tuni Boas, a Boas ia tuni Salmon, a Salmon ia tuni Nason, ");
INSERT INTO wiv_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","A Nason ia tuni Aminadap, a Aminadap ia tuni Atmin, a Atmin ia tuni Arni, a Arni ia tuni Hesron, a Hesron ia tuni Peres, a Peres ia tuni Iuda, ");
INSERT INTO wiv_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","A Iuda ia tuni Jekop, a Jekop ia tuni Aisak, a Aisak ia tuni Abraham, a Abraham ia tuni Tera, a Tera ia tuni Nahor, ");
INSERT INTO wiv_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","A Nahor ia tuni Seruk, a Seruk ia tuni Reu, a Reu ia tuni Pelek, a Pelek ia tuni Eber, a Eber ia tuni Sela, ");
INSERT INTO wiv_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","A Sela ia tuni Kainan, a Kainan ia tuni Arpaksat, a Arpaksat ia tuni Siem, a Siem ia tuni Noa, a Noa ia tuni Lamek, ");
INSERT INTO wiv_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","A Lamek ia tuni Metusela, a Metusela ia tuni Enok, a Enok ia tuni Jaret, a Jaret ia tuni Mahalalel, a Mahalalel ia tuni Kenan, ");
INSERT INTO wiv_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","A Kenan ia tuni Enos, a Enos ia tuni Set, a Set ia tuni Adam, a Adam ia tuni Vuvu. ");
INSERT INTO wiv_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","A Iesus e vonu na Vule Tumonga kilaka e pe na naru a Iordan ki vamule. Na Vule Tumonga ia pelea vano kara deset. ");
INSERT INTO wiv_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","A Satan ia mai pado rukia na dama e 40. Na dama kamahi kua beta ni hania goloa katiu. Muri na dama kamahi kua, ia ti ba vitoloni matehia matoto. ");
INSERT INTO wiv_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","A Satan ki tania vona, “Ni ho tuni Vuvu matoto, tania na kedo kua ni pokizia ni kara bret.” ");
INSERT INTO wiv_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","A Iesus ia kolia vona ki tania, “E vapolu bareanga na polea kana Paraha, ‘Mara beta kaka ni mahuri na bret za.’” ");
INSERT INTO wiv_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","A Satan ia pelea vori zahe kara potuna, ia vatunga tapunia na kingdom laveve na vulovulo vona. ");
INSERT INTO wiv_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","A Satan ki tania vona, “Da ta vala naba ni niho koto hada na kantri laveve kuari, da hiza e papane matoto, na vuna zia ti valanga ni niau kava. Hau e nap kata vala ni azei kua e kuligu kata vala vona. ");
INSERT INTO wiv_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Nu lotu ni niau, da ta vala goloaloa laveve kuari ni niho.” ");
INSERT INTO wiv_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","A Iesus e kolia vona ki tania, “E vapolu baraenga na polea kana Paraha, ‘Lotu ni Vuvu ka Paraha, ia za da tu vora kana.’” ");
INSERT INTO wiv_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","A Satan ia pelea ve vano kiri Ierusalem, ia vamadiria a Iesus na huduna tempel, ia tania vona, “Kua kini ho tuni Vuvu matoto, raga ri kua; ");
INSERT INTO wiv_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Na vuna e vapolu bareanga, ‘A Vuvu da e geria kana engel kamahi, dia ka hada poto ni niho.’ ");
INSERT INTO wiv_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","E vapolu bareanga ve, ‘Da dia ta zikoviho na limadia ki mara beta nu valitia kabe na kedo.’” ");
INSERT INTO wiv_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","A Iesus e kolia vona ki tania, “Na polea kana Paraha e tani barae, ‘Taua nu parakilania Paraha, ka Vuvu.’” ");
INSERT INTO wiv_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Kamana a Satan ti vahozovia kana parakilakilanga, ia vatia. E guria dama katiu ve kua kete volo papa mule kirina. ");
INSERT INTO wiv_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","A Iesus ia vamule kiri Galili na matuhanga kana Vule Tumonga. Na rereka kini vana lobia na malala laveve ni Galili. ");
INSERT INTO wiv_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ia ki vaketekete na poloka haus lotu ke vuni Iuda, manumanu laveve dia ka kona zahenia. ");
INSERT INTO wiv_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","A Iesus ia vano kiri Nasaret, na palaka kua ia e paraha vona. Na Sabat ia vano kara haus lotu ke vuni Iuda, habuka kua ia e lala kete katia boto laveve. Ia madi kete hazenia na buk. ");
INSERT INTO wiv_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Dia ta vala na buk ke profet Aisaia vona. Ia vukazia na buk ki paria na palaka kena e vapolunganga, polea kua e tani barae, ");
INSERT INTO wiv_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Na Vulena Paraha ti kari havutiau, na vuna zia ia ti makiau kata vaketea na Kalohua Kemi na manumanu kua beta kadia goloaloa vona. Ia e geriau kata tani kakava na nuhu kua dia ta karabus, kete beta dia kata ma karabus. Ia mai ve nuhu kua matadia e keu, dia kata hada mule, kata vaikoli kara nuhu kua manumanu e ditaduridia, dia ka kati zahatia ni dia, ");
INSERT INTO wiv_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","kata tani kakava na nagi kemi kana Paraha.” ");
INSERT INTO wiv_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Pale, ia tabaria na buk, ia vala mulehia na paraha kara lotua ke vuni Iuda, ia ziho mia tadu. Na matana manumanu laveve na poloka haus lotu ke vuni Iuda e ma ki vividohia. ");
INSERT INTO wiv_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Pale, ia varivuvunia kana polea, ki tani barae ni dia, “Meni kua na polea kua ta hazenia, ia ti pori matoto, habuka kua miu ta longoria e hazeanga.” ");
INSERT INTO wiv_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Dia ta matinia matoto kana polea. Dia ka lohoi tori na kana polea mata mulimuli kua e popole vona. Dia ka tania, “Karae kua beta ni a tuni Iosep kua?” ");
INSERT INTO wiv_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","A Iesus ki tania ni dia, “E limoha, da miu ta tani barae kirigu, muri na kamiu polea kua, ‘Dokta kati mulehiho nu kemi! Katia ri na ka taon mule, nazia kua hita ta longoria tu katia ni Kaperneam.’” ");
INSERT INTO wiv_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ia ki tania ni dia, “Ta tani matotonia ni miu, profet na kana malala mule, da beta kete hada zaheanga. ");
INSERT INTO wiv_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","E limoha, tavivine gabugabu luba ni Iudea na taem ke Elaija. Kilaka kena na mariaba e tabara na krismas tolu, lingabo 6, vitolo kapou matoto ki bele na malala laveve. ");
INSERT INTO wiv_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Palaka, beta ni gerua a Elaija ni vano na katiu ni dia, palaka e vano na tavine gabu ni Sarefat, na distrik a Saidon, ia beta ni tavine Iuda. ");
INSERT INTO wiv_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Dia luba ni Israel lepra ni dia, na taem ke profet Elisa, beta katiu ni dia ni katua ni kemi, a Naman za, kaka bukuni Siria e katua ki kemi, ia ve beta ni bukuni Iudea.” ");
INSERT INTO wiv_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Manumanu laveve na poloka haus lotu ke vuni Iuda dia ta longoria polea kua, magalidia ki varitihi matoto kiri Iesus. ");
INSERT INTO wiv_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Dia ta divurutidia, dia ta harehia gotala na taon, dia ta pelea vori kara hiripa potuna, kena kadia taon e katua vona, dia kata bara katia a Iesus kara balibali. ");
INSERT INTO wiv_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Palaka ia vana pe na pidaka dia za kini vano. ");
INSERT INTO wiv_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Pale, ia ziho kiri Kaperneam na taon ni Galili, na Sabat laveve ia e vaketekete na manumanu. ");
INSERT INTO wiv_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Dia ta lohoi tori matoto na kana vaketeketea, na vuna zia kana polea e matuha matoto. ");
INSERT INTO wiv_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Na poloka haus lotu ke vuni Iuda kua ve, na kaka katiu na vule zaha e holiholia ki goe kapopou matoto ki tania, ");
INSERT INTO wiv_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ha! Nazia matoto e kuli kirina ni hita, o Iesus bukuni Nasaret? Tu mai koto vairohihita? Hau ta lala ho azei! Ho na Kaka Tumonga ke Vuvu.” ");
INSERT INTO wiv_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","A Iesus e pole kara vule zaha kua ki tania, “Tabaria hava! Mai gotala vona.” Pale, na vule zaha kua ia varaga taduria na kaka kua na pidaka manumanu laveve kua, ia gotala vona, beta ni vairohia livuhana. ");
INSERT INTO wiv_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Manumanu laveve dia ta lohoi tori, dia ka tania, “Na kaka kua, e pole kara vule zaha kamahi balika kaka kua kana naba vona kamana matuhanga. E pole kara vule zaha kamahi, dia ta gotala na kaka.” ");
INSERT INTO wiv_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Pale, na rereki Iesus ia vana lobia na malala laveve ni Kaperneam. ");
INSERT INTO wiv_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","A Iesus ia vatia na haus lotu ke vuni Iuda. Ia vano kara ruma ke Saimon. A ravani Saimon e mazahitia, livuhana ki totoba matoto, dia ta hulenia a Iesus kete kodonia. ");
INSERT INTO wiv_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","A Iesus ia madi vano kozoho vona, ia pole kara mazahi. Mazahi ia vatia. Pale, ia lama pamuhi kini vanganidia. ");
INSERT INTO wiv_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Na voro keteni zugu, na manumanu dia ta pelea nuhu kua mazahizahi kakeikakei kua na livuhadia ki mai ni Iesus. A Iesus ki taruhia limana na katiukatiu ni dia laveve, dia ka kemikemi mule. ");
INSERT INTO wiv_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ki vano ve na vule zaha kamahi dia ta hava gotala na manumanu luba, dia ka goe dia ka tania, “Ho na tuni Vuvu!” Palaka a Iesus e pole kiridia ki tani vatuharia ni dia, dia kata tabaria havadia, na vuna dia ta lala ia a Kristus. ");
INSERT INTO wiv_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ti dama kakava, ia vatidia ia vano kara palaka katiu kua beta kaka vona. Na manumanu dia ta kakaze kirina, kamana dia ka mai paria na palaka kua ia vona. Dia ta parakilania dia kata talea ni ma mimia kamadia. ");
INSERT INTO wiv_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Palaka a Iesus e tania ni dia, “Hau kata ratarata na Kalohua Kemi na kingdom ke Vuvu na taon taza ve, na vuna zia e geura hau kara galanga kua.” ");
INSERT INTO wiv_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Pale, ia kini ma vaketekete na poloka haus lotu kamahi ke vuni Iuda, ni Iudea. ");
INSERT INTO wiv_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Na dama katiu a Iesus e mamadi na vazalea na loka ni Genesaret. Na kabuna manumanu dia ka varidigi lobia, dia ka lolongoria na polea ke Vuvu. ");
INSERT INTO wiv_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ia hadavia na bot rua na vazalea, palaka nuhuta pelepelea na hiha na huduna, dia te vatia na bot, dia kene vavazuguvia kadia vuho. ");
INSERT INTO wiv_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ia polo na huduna bot katiu. Na bot kua ke Saimon. Ia hulenia kete tule kati gotalania pitu na vazalea. Ia mia na huduna bot kini vaketea manumanu. ");
INSERT INTO wiv_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Kamana ki hozo polea ia tania ni Saimon, “Pe gotala kara madoro pitu nu varaga ka vuho, koto vatingotingo hiha.” ");
INSERT INTO wiv_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","A Saimon ki tania, “Kagu Paraha, hita ta varaga vuho na marigo malaku kua, palaka beta hita na vatingovia hiha katiu, palaka na vuna ho tu tania za kua, da hau te varaga mulehia vuho.” ");
INSERT INTO wiv_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Kamana dia ka kati baraenia dia ta vatingovia na hiha luba matoto, pitu papa kadia vuho kamahi ni teretere. ");
INSERT INTO wiv_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Dia ta tavia habu tamaninikidia na ruana bot dia kata mai kodonidia. Dia ka gorea bot karua kua, hiro kene vonu matoto. Pitu papa za bot karua kua, hiro ne mahitu. ");
INSERT INTO wiv_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Kamana a Saimon Pita ki hada baraenia, ia dua kara kabeni Iesus ki tania, “Paraha, kakava ni niau, na vuna hau ta kaka zaha!” ");
INSERT INTO wiv_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Na vuna a Saimon kamana nuhu kua dia ta pupuri lupu, dia ta tara vilu matoto na vuna na hiha kua dia ta vatingovia. ");
INSERT INTO wiv_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Nuhu kua dia ta kamani Saimon, ia a Jems kamani Jon, tuni Sebedi karua, hiro ve ta gagala lupu kamani Saimon. A Iesus ki tania ni Saimon, “Taua nu kuahi, da meni kua kini ma vano da tu pelepele manumanu.” ");
INSERT INTO wiv_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Pale, dia ta vazula ziho kara vazalea, dia ta zuka tapunia kadia goloaloa laveve, dia kene muri ni Iesus. ");
INSERT INTO wiv_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Dama katiu a Iesus ia na poloka taon katiu, kaka katiu vona na lepra e vonu matoto na livuhana. E hada a Iesus, ia vano padonia tutura, ki taruhia damana ziho kara garigari ki haloho ruru ni Iesus ki tania, “Paraha, ma kuli, ku katiau ka kemi.” ");
INSERT INTO wiv_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","A Iesus ia tabe vano ia vakulia kaka kua ki tania, “Hau kuligu koto kemi.” Pale, kilaka kena za, na lepra ia vatia. ");
INSERT INTO wiv_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","A Iesus ki tani vatuharia vona, “Taua nu tania na kaka katiu, palaka vano nu vatunga livuha na Pris, nu vala na opa kara ka kemia, habuka na lo ke Moses kua e tania. Manumanu dia kata hada lala matoto habuka tu kemi kava.” ");
INSERT INTO wiv_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Palaka na rereki Iesus kava ti vana lobia malala. Na kabuna manumanu, dia ta mai, dia kata longoria kana polea, ki kati kemihidia na kadia mazahi kamahi. ");
INSERT INTO wiv_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Palaka boto luba a Iesus e lala kete vano kazihena kara palaka kamahi kena, beta kaka vona, kete lotu. ");
INSERT INTO wiv_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Na dama katiu a Iesus e vaketekete, na Parisi kamana tisa kamahi kara lo, dia ta mimia kamana. Dia ta pe na malala laveve ni Galili, ni Iudea, ia mai ve ni Ierusalem. Na matuhanga ke Vuvu ia ni Iesus kua kete kati kemihia nuhu kua e mazahitidia. ");
INSERT INTO wiv_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Tamohane taza dia ta luluga na kaka katiu kua togana e matemate na huduna dongi, dia ka parakilania dia kata luga vano hoho dia na vangorea na mugani Iesus. ");
INSERT INTO wiv_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Palaka manumanu e luba ki beta matoto zeleka kua dia kata luga vano ni hoho. Dia ta papane kara huduna ruma, dia ta pahia huduna ruma, dia ta vazihonia ziho kamana kana dongi na pidaki manumanu kara kabeni Iesus. ");
INSERT INTO wiv_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","A Iesus e hadavia kadia bilip ki tania, “Tai, te lohoi bala ka manaunaua.” ");
INSERT INTO wiv_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Na tisa kamahi kara lo kamana Parisi kamahi dia ta varihulei, “Ia azei matoto kua ki pole taduria a Vuvu? Azei e dangea kete lohoi bala manaunaua? A Vuvu za!” ");
INSERT INTO wiv_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","A Iesus kava ti pelea kadia lohoihoia, ia hulenidia, “E kuziha miu ka lohoi barae na polokomiu. ");
INSERT INTO wiv_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Polea kakei e malimu dopa kata tania, ‘Ka manaunaua te lohoi bala’ o kata tania, ‘Madi nu vavana’? ");
INSERT INTO wiv_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Palaka miu kata lala kubarae, na Tuna Kaka kana matuhanga vona ri na garigari kete lohoi bala manaunaua.” Pale, ia tania na kaka kua togana e matemate, “Ta tania ni niho, madi pelea ka dongi nu vano kara ka ruma.” ");
INSERT INTO wiv_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Pale, ia di madi pamuhi na pidaka dia, ia pelea kana dongi kini vazahenia a Vuvu kini vano kara ruma. ");
INSERT INTO wiv_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Manumanu laveve dia ta zipa zahe, dia ka kuahi matoto. Dia ka vazahenia a Vuvu, dia ka tania, “Hita ta ba hadavia na goloa vahoru katiu meni.” ");
INSERT INTO wiv_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Muri na kua, a Iesus ia vano gotala, ia hadavia a Livai, ia na kakanaka pelepelea na takis. E mimia na kana opis kara takis. A Iesus ki tania vona, “Mai muri ni niau.” ");
INSERT INTO wiv_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Pale, a Livai ia vatia kana goloaloa laveve, ia divurutia kini muri ni Iesus. ");
INSERT INTO wiv_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","A Livai ia katia hanihania kapou ni Iesus na poloka kana ruma. Na nuhuta pelepelea na takis luba kamana manumanu taza ve dia ta hanihani kamadia. ");
INSERT INTO wiv_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Palaka na Parisi taza kamana kadia tisa kamahi kara lo, dia ta pole ngungu, dia ka hulenia na disaipel ke Iesus dia ka tania, “E kuziha miu ka hanihani, miu ka hinu kamana nuhuta pelepelea na takis, kamana nuhuta moge zahazaha?” ");
INSERT INTO wiv_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","A Iesus ki kolia kadia polea ki tania, “Nuhu kua beta mazahi ni dia, beta dia na lala dia kata vano hada dokta, palaka nuhu kua mazahi ni dia za, ia dia ta lala dia kata vano hadavia na dokta. ");
INSERT INTO wiv_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Hau beta na mai kata kohania nuhu kua dia ta mahotohoto. Beta, hau ta mai kata kohania nuhuta moge zahazaha, dia kata pokizia magalidia.” ");
INSERT INTO wiv_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Pale, dia ta tania vona, “Na disaipel kamahi ke Jon dia ta lala, dia kata mahoho boto luba, dia na lolotu, na disaipel ke vuni Parisi ve dia ta lala, dia kata gagala barae ve, palaka ka disaipel kamahi, beta dia na lala dia kata mamahoho, dia ta hanihani dia ka hihinu za.” ");
INSERT INTO wiv_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","A Iesus ki tania ni dia, “E dangea miu kata katia manumanu kua e vinohuanga dia kara hanihania na lahia, dia na mahoho, kua na tamohane e ba lahi vahoru kua e ba hanihani kamadia? ");
INSERT INTO wiv_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Palaka na taem vona kua e ba mamai, da ti pele kakavanga tamohane kena e ba lahi vahoru ni dia. Pale, na dama kamahi kena, da dia te ba mahoho.” ");
INSERT INTO wiv_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Pale, ia barikikinia polea kua ki tania ni dia, “Mara beta kaka katiu ni terehia na dihura lavalava vahoru, ni turi porotia na lavalava bura vona. Tani kati baraenia, da e vairohia na lavalava vahoru, ki mara beta ve na lavalava vahoru ni hada balika lavalava bura. ");
INSERT INTO wiv_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Mara beta ve kaka katiu ni valikiria vaen vahoru kara poloka hulita me bura. Tani kati baraenia, na vaen vahoru da ti tuka terehia na hulita me bura, na vaen ia maliki, na hulita me ia vairo. ");
INSERT INTO wiv_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Palaka na vaen vahoru da e valikira kara hulita me vahoru. ");
INSERT INTO wiv_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Kaka kua kava ti hinumia vaen bura, da mara beta ni kulina kete hinumia vaen vahoru. Na vuna da ia e tania, ‘Vaen bura e dopa ki kemi.’” ");
INSERT INTO wiv_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Na Sabat katiu a Iesus e vavana hutu na poloka vanua na vit kamahi, na kana disaipel kamahi dia ka duledule palekana vit, dia ta hirania na hulita vit na limadia kete kakava, dia na hania palekana. ");
INSERT INTO wiv_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Palaka na Parisi taza dia ta tania, “E kuziha miu ka katia nazia kua e vatabuanga na Sabat?” ");
INSERT INTO wiv_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","A Iesus ki kolia ki tania, “Beta miu na hazenia na ziuziua kua ni Devit kamana nuhu kua dia ta kakamana, kilaka kua e vitolonidia? ");
INSERT INTO wiv_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","A Devit e hoho na ruma ke Vuvu ki pelea na bret kua e tabutabua, kua kete vatunganga na matani Vuvu, kua na Pris kamahi za dia ta lala dia kata hahania. A Devit ia pelea, ia hania ki vala ve na nuhu kua dia ta kakamana.” ");
INSERT INTO wiv_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","A Iesus ki tania ni dia, “Na Tuna Kaka ia na Paraha kara Sabat.” ");
INSERT INTO wiv_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Na Sabat katiu ve ia na poloka haus lotu ke vuni Iuda ki vaketekete, na kaka katiu na poloka haus lotu kua, na limana kiri maroro e mate. ");
INSERT INTO wiv_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","A vuni Parisi kamana tisa kamahi kara lo ke Moses, dia ta hada patia a Iesus, karae da e kati kemihia na lima mate kua na Sabat, na vuna zia dia ta kakaze dala dia kata padea polea kirina. ");
INSERT INTO wiv_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Palaka ia ti lala kadia lohoihoia, ia mai tania na kaka lima mate kua, “Mai madi ri kua na mugana.” Pale, kaka kua ia divurutia kini vano madi. ");
INSERT INTO wiv_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","A Iesus ia tania ni dia, “Kata hulenimiu, na lo e tani ziha na Sabat tolu kata katia moge kemi vona o tolu kata katia moge zaha, tolu kata vaikoli kara kaka o tolu kata kirohia?” ");
INSERT INTO wiv_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","A Iesus e hada lobi kiridia laveve ki tania na lima mate kua, “Vatatahia lima.” Na kaka lima mate kua ia muri na kana polea, na limana ia kemi. ");
INSERT INTO wiv_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Palaka magalidia e varitihi matoto, dia kene hubia polea na pidaka dia mule, habuka dia kata kuzingania a Iesus. ");
INSERT INTO wiv_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Na dama katiu, a Iesus e vori kara potuna kete lotu. A Iesus ki lotu ni Vuvu na marigo ia ki dama. ");
INSERT INTO wiv_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Na damadama a Iesus e kohania kana disaipel kamahi, ia makia dia 12, nuhu kua kete kohanidia na apostel kamahi. ");
INSERT INTO wiv_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","A Saimon, a Iesus e vala hiza kua a Pita vona, a Andru tazini Saimon, a Jems, a Jon, a Filip, a Bartolomyu, ");
INSERT INTO wiv_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","a Matyu, a Tomas, a Jems tuni Alfius, a Saimon kua e kohanga ni Selot, ");
INSERT INTO wiv_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","a Iudas tuni Jems, mai a Iudas Iskariot, kaka kua muri kete tilitili tika kiri Iesus. ");
INSERT INTO wiv_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","A Iesus kamana kana disaipel kamahi dia ta tiro mule, dia ta varimadiriai na palaka mahoto. Na kabuna kana disaipel kamahi kamana kabuna manumanu kapou bukuni Iudea, bukuni Ierusalem, mai nuhu bukuna hiripa vazalea ni Tair kamani Saidon, ");
INSERT INTO wiv_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","dia ta mai, dia kata longoria kana polea, ni pele kakava kadia mazahi. Nuhu kua vule zaha e holiholidia, dia ve a Iesus e kati kemihidia ve. ");
INSERT INTO wiv_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Manumanu laveve kua, dia ta paparakilania dia kata vakulia a Iesus, na vuna na matuhanga kapou e pe ni Iesus ki vavano, na matuhanga kua kini kakati kemihidia laveve. ");
INSERT INTO wiv_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","E hada vano kara kana disaipel kamahi ki tani barae, “Miu nuhu kua beta kamiu goloaloa vona, a Vuvu ti kati kemihia matoto ni miu. Na vuna na kingdom ke Vuvu ia e kamiu. ");
INSERT INTO wiv_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","A Vuvu ti kati kemihia ni miu nuhu kua e vivitolonimiu meni, na vuna, da miu ta hanihani magalimiu ki kurukuru. A Vuvu ti kati kemihia matoto ni miu nuhu kua miu ta hahaloho meni, na vuna da miu ta nongo. ");
INSERT INTO wiv_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","A Vuvu ti kati kemihia matoto na nuhu kua beta manumanu ni lala kete kukulidia kirimiu, dia ka pole katimiu, dia ka pole tadurimiu, dia ka tania miu nuhu zahazaha, na vuna zia kua miu te mumuri na Tuna Kaka kava. ");
INSERT INTO wiv_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Na dama kena miu hilohilo, miu na raga kamana hilohiloa, na vuna zia kadoamiu na lagato e kapou matoto. Na vuna, habu tubudia muga dia ta kati baraenia ve na profet kamahi. ");
INSERT INTO wiv_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Kaba loho zahanga ni miu risman kamahi, na vuna kava miu te mia papa ri na garigari. ");
INSERT INTO wiv_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Kaba loho zahanga ni miu nuhu kua magalimiu e lala kete kurukuru meni, na vuna da muri ki vitolonimiu. Nuhu kua miu ta nonongo meni, da muri magalimiu ki zaha, miu ka tangi. ");
INSERT INTO wiv_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Kaba loho zahanga ni miu, ta manumanu laveve ni kona zahenimiu, na vuna ia maki kena varira ni habu tamadia, dia ta kona zahenia na profet vairukuruku kamahi.” ");
INSERT INTO wiv_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","A Iesus ki tani barae ve, “Palaka hau ta tania ni miu nuhu kua miu ta lolongoriau. Kete kulimiu kara hamiu vagi kamahi, kati kemihia na nuhu kua dia ta zazaha kirimiu, ");
INSERT INTO wiv_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","kati kemihia na nuhu kua dia ta baru zahazaha kirimiu, miu lotu miu na hulenia a Vuvu kete kodonia nuhu kua dia ta kati zahatia ni miu. ");
INSERT INTO wiv_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ta katiu ni zapalania taviki, tare poki nu vala paligeni taviki ve vona. Ta katiu ni vanahea ka tale havuhavua vatia ve ni pelea ka singlis. ");
INSERT INTO wiv_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Azei kua e nongiho na goloa katiu, vala vona. Kua kaka katiu ni pelea ka goloa katiu, taua nu huleni mulehia kirina. ");
INSERT INTO wiv_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Nazia kua tu lohoia e kuli kaka motu kete katia ni niho, pele ho kati baraenia ve na kaka motu. ");
INSERT INTO wiv_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ta ni kuli za kara nuhu kua e lala kete kulidia kiri ni niho, tu lohoia da a Vuvu e kadeho vona? Nuhuta moge zahazaha ve, dia ta lala dia kata kukulidia ve kara nuhu kena e lala kete kulidia kiridia. ");
INSERT INTO wiv_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Tanu kati kemihia na nuhu kua dia ta kekemi kiriniho za, tu lohoia da a Vuvu e kadeho vona? Nuhuta moge zahazaha ve, dia ta lala dia kata kemi ve kiri habu tamaninikidia. ");
INSERT INTO wiv_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Tanu vala goloa na nuhu kua tu lohoia da muri dia ka koli mulehia ka goloa, tu lohoia da a Vuvu e kadeho vona? Nuhu kua dia ta zahazaha, dia ta lala dia kata vala goloa na nuhu zahazaha ve, dia ka lala dia kata lohoia kete koli muleha kadia goloa ni damukia matoto nazia kua dia ta vala. ");
INSERT INTO wiv_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Palaka kete kulimiu kara hamiu vagi kamahi, miu kati kemihia ni dia. Miu vala vetania goloa ni dia. Taua miu na lohoia kete kolu muleha ni miu. Pale, kadoamiu ia da e kapou matoto. Pale, da miu te kara habu tutuna Paraha, kua ia e Heta Matoto. Na vuna ia e lala kete kati kemihia na nuhu kua beta dia na lala dia kata hahate motunia, ki lala ve kete kati kemihia ve na manumanu zahazaha. ");
INSERT INTO wiv_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Miu maharia kaka, na vuna Tamamiu ia e kakanaka mahariharia.” ");
INSERT INTO wiv_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","A Iesus ki tani barae ve, “Tabarae, miu na hahada kara goloa zaha na kaka motu, tabarae dia ve na hada ve kara goloa zaha ni miu. Taua nu pole katia kaka nu tania ia e kaka zaha, tabarae dia ve na tani barae ve kiriniho. Lohoi bala maki e katua ni niho, a Vuvu kete lohoi bala ve ka manaunaua. ");
INSERT INTO wiv_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Vala lima na kaka kete valanga goloa ve ni niho. Da e goroa ka beke ki vonu ki pado tadura, ki goroa ve ki vonu kalavuruvuru ki malikiliki, ki taruha na kabe. Na vuna mak kakei tu tovonia rua vona. Ia mak kena za da tu tovoanga vona.” ");
INSERT INTO wiv_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","A Iesus e barikikinia ve polea kua ki tania, “E dangea na kaka matana keu kete vatunga dala ni ruana kena matana e keu ve? Karae mara beta hiro na rua dua hoho kara lovo? ");
INSERT INTO wiv_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Kapiru kua e ba sisikul mara beta ni hada zaheanga dopa na kana tisa. Palaka manumanu laveve kua e sikulni kemikemuha dia da dia ta habuka kadia tisa. ");
INSERT INTO wiv_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","E kuziha ku hada na momota tahetahena so na matani tazi, ki beta nu lohoia na podana hai kena na mata mule? ");
INSERT INTO wiv_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","E kuziha da kunu tani barae ni tazi, ‘Tai, mai na pele kakava momota tahetahe kena na mata.’ Palaka ho mule beta nu hada na podana hai kena na mata mule. Tu lolotu veta, muga ku pele kakava podana hai kena na mata, ku hada vutu, muri kunu pele kakava na momota tahetahe na matani tazi. ");
INSERT INTO wiv_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Hai kemi beta ni vua paleka ni zaha. Hai zaha ve beta ni vua paleka ni kemi. ");
INSERT INTO wiv_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Paleka hai katiukatiu da e vatunga kakava ia bukuna hai kakei. Manumanu beta dia na lala dia kata dulea paleka fik na mota matangatanga, o na paleka vaen na haina moli. ");
INSERT INTO wiv_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Kaka kemi da lohoihoia kemikemi e ngoro na poloki magalina, kubarae da e katia maki kemikemi, palaka na kaka zaha, lohoihoia zahazaha na poloka, kubarae ki katia maki zahazaha. Na vuna lohoihoia kakei, kua tani vonu na magalina kaka, ia za kena da e gogotala na havana. ");
INSERT INTO wiv_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Kara zia miu ka kohani baraeniau, ‘Paraha, Paraha,’ ki beta miu na mumuri na kagu polea? ");
INSERT INTO wiv_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Kata vatunga ni miu kaka kete balika zia, kua tani mai ni niau ni longoria kagu polea ni muri matoto vona. ");
INSERT INTO wiv_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ia e balika kaka kua e habatia na ruma, ki hovia na lovo loloa ki taruhia simen faundesion, ba muri ia ti habatia kana ruma. Ta noro kapou ni pado ni hununia na ruma. Mara beta ni hunu tuahia, na vuna e haba kemukemuha. ");
INSERT INTO wiv_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Palaka azei kua tanu longoria kagu polea ni beta nu muri vona, ia tu balika kaka kua e habatia kana ruma na huduna garigari vetanga, beta ni taruhia simen na garigari. Ta noro ni mai ni hununia na ruma da e tua, ki robea matoto.” ");
INSERT INTO wiv_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Tania a Iesus ki tani hozovia na polea kamahi kua na manumanu, ia vano hoho na taon a Kaperneam. ");
INSERT INTO wiv_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Na kepten kara armi katiu vona, kana vora kena e dopa ki kulina marata kirina, e mazahitia matoto, kozoho keteni mate. ");
INSERT INTO wiv_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Na kepten kara armi kua e longoria kavilika polea ni Iesus, ia geria pararaha taza ke vuni Iuda, dia kata vano ni Iesus, dia na hulenia kete mai ni kati kemihia kana vora. ");
INSERT INTO wiv_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Kamana dia ka mai bele ni Iesus, dia ta hule haroinia matoto, dia ka tania, “E dangea koto kodonia na kepten kara soldia kua, ");
INSERT INTO wiv_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","na vuna ia e kulina matoto kiridolu vuni Iuda, kini habatia kadolu haus lotu katiu.” ");
INSERT INTO wiv_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Pale, ia vano kamadia, ti vano kozoho na ruma, na kepten kara soldia kua e geria habu kana, dia kata tania ni Iesus, “Paraha, tani varaharahaho, na maia. Hau beta na hizanga ni dangea koto mai hoho na kagu ruma. ");
INSERT INTO wiv_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ki kubarae ki beta na hatunia ve na hizanga na dangea kata vano ve ni niho. Palaka tania za, kagu vora ni kemi. ");
INSERT INTO wiv_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Hau ve, hau kagu paraha vona e hada ni niau. Hau ve, hau ta hada na soldia taza ve. Na tania na katiu, kete vano, ia da e vano. Na tania na katiu kete mai, ia da e mai. Na tania na kagu vora kete katia goloa kua, ia da e katia.” ");
INSERT INTO wiv_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Kamana a Iesus ki longori baraenia, ia ridi matoto vona, ki tare poki kara kabuna manumanu kua dia ta mumuri vona, ki tania, “Hau ta tania ni miu, ma beta na paria bilip katiu kua e kapou barae, ni Israel.” ");
INSERT INTO wiv_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Pale, nuhu kua e geura dia, dia ka mai ni Iesus, dia ta vamule vano kara ruma kana kepten kua, dia ta hada kubarae, na vora ti kemi kava. ");
INSERT INTO wiv_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Muri vona a Iesus ia vano kara taon katiu hizana a Nain. Kana disaipel kamahi kamana kabuna manumanu kapou dia ve ta vano kamana. ");
INSERT INTO wiv_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ti kozoho na hatamara taon na kaka mate katiu e luluganga ki gogotala na taon, ia na tuna tavine gabu katiu, gabu kua, ia tuna katiu papa za kua. Kabuna manumanu kapou bukuna taon dia ta kakamana. ");
INSERT INTO wiv_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Kamana na Paraha ki hada na tavine kua, lohora e zaha matoto vona, ia tania vona, “Taua nu tangi.” ");
INSERT INTO wiv_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Pale, a Iesus ia vana vano kozoho, ia vakulia na dongi kana kaka mate kua, na nuhu dia ta luluga na dongi kua, dia ta madi. A Iesus ia tania, “Huluvahu, hau ta tania ni niho, ‘Lama!’” ");
INSERT INTO wiv_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Na kaka mate kua ia lama mia, kini pole. A Iesus ia vala mulehia ni titinana. ");
INSERT INTO wiv_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Dia laveve dia ta kuahi matoto, dia ka vazahenia hizani Vuvu. Dia ka tani barae, “Na profet kapou katiu ti bele na pidaka dolu!” Dia ka tania barae ve, “A Vuvu ti mai keteni kodonia kana manumanu!” ");
INSERT INTO wiv_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Na rereki Iesus ki vavana lobia palaka laveve ni Iudea, mai ve na poloka malala laveve kua e lobia a Iudea. ");
INSERT INTO wiv_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Na disaipel ke Jon dia ta tania ni Jon na goloa laveve kua dia ta longoria dia ka hadavia. ");
INSERT INTO wiv_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","A Jon ia kohania kana disaipel rua, ia gerihiro, hiro kata vano na Paraha a Iesus hiro na hulenia, “Ia ho za na kaka kua kete mai o da hita ta guria katiu motu?” ");
INSERT INTO wiv_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Kamana hiro ka mai ni Iesus, hiro ta tania, “A Jon kakanaka Baptais e gerimiro, miro ka mai ni niho, miro kata huleniho, ‘Ia ho za na kaka kua kete mai o da hita ta guria katiu motu?’” ");
INSERT INTO wiv_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Kilaka kena hiro ta bele, a Iesus e kati kemihia manumanu luba kua mazahi na livuhadia kamana vule zahazaha, ia e kati kemihia nuhu kua matadia e keu dia ka hada mule. ");
INSERT INTO wiv_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Pale, ia kolia kahiro hulea, ki tania, “Mo vamule vano mo na kalohunia ni Jon nazia mo ta hadavia mo ka longoria. Nuhu matadia e keu dia ta hada mule, nuhu kabe mate dia ta vavana mule, nuhu lepra ni dia, dia ta kemi mule, nuhu talingadia e doto dia ta longo mule, nuhu dia ta mate e valamari mulehadia. Na Kalohua Kemi ke Vuvu ti vaketoa na nuhu kua beta kadia goloaloa vona. ");
INSERT INTO wiv_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Na Paraha da e kati kemihia matoto na kaka kua e bilip ni niau ki beta ni lohoi ruarua ni niau.” ");
INSERT INTO wiv_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Muri na kaka rua kua a Jon e geri, hiro te vamule, a Iesus ia hulenia manumanu na vuna ni Jon, “Nazia miu ta lohoia miu kata hadavia kua miu ta vano ni Jon na deset? Miu kata hadavia na raburabu na kavili e habinia ki mamalolo? ");
INSERT INTO wiv_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Pele, nazia miu ta lohoia miu kata hadavia kua miu ta vano ni Jon? Na kaka e zohoria na zohozohoa mata muli? Beta! Nuhu dia ta zohoria na zohozohoa mata mulimuli kamana kadia goloaloa kemikemi dia ta lololi na ruma kana king za. ");
INSERT INTO wiv_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Palaka, nazia miu ta lohoia miu kata hadavia kua miu ta vano ni Jon? Na profet katiu? E matoto, hau ta tania ni miu, ia na profet, e dopa ki hizanga na profet laveve. ");
INSERT INTO wiv_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Varira profet Malakai e vapolungania ki pole ni Jon ki tania, ‘Da hau ta geria kagu vakilalanga kete vamuga ni niho, kete vaida dala kiriniho.’ ");
INSERT INTO wiv_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Hau ta tania ni miu. Na pidaka manumanu laveve kua e valohuadia, beta kaka katiu ni dopa ni hizanga ni Jon. Palaka kaka kua e beta ni dopa ni hizanga na kingdom ke Vuvu e dopa ki paraha vona.” ");
INSERT INTO wiv_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Manumanu laveve, ia mai nuhuta pelepelea na takis, nuhu kua a Jon e vazuguvidia, kamana dia ka longoria polea ke Iesus, dia ta tania habuka maki ke Vuvu ia e mahoto. ");
INSERT INTO wiv_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Palaka na Parisi kamahi kamana tisa kara lo ke Moses, dia ta pala katia lohoihoia kemi ke Vuvu kiridia mule, ki beta ni kulidia a Jon kete vazuguvidia. ");
INSERT INTO wiv_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","A Iesus ia tani barae ve, “Pele, ma nazia, kata tovonia manumanu bukuna tauna kua vona? Dia ta balika zia? ");
INSERT INTO wiv_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Dia ta balika kapirupiru kua dia ta mimia na poloka palakana maket dia ka gogoe kiri habu tamaninikidia, ‘Hita ta vilinia kalou, beta miu na parau. Hita ta habia vuroua, beta miu na tangi.’ ");
INSERT INTO wiv_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","A Jon kakanaka Baptais e mai ki beta ni hania bret, beta ni hinumia vaen, miu ka tania, ‘Ia na vule zaha vona.’ ");
INSERT INTO wiv_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Na Tuna Kaka e mai ki hahania bret ki hihinumia vaen, miu ta tania, ‘Hadavia! Ia na kakanaka hani hamohamoa, ia na kakanaka hinu hamohamoa na vaen, ia na habu tamaninika nuhuta pelepelea na takis kamana nuhuta moge zahazaha!’ ");
INSERT INTO wiv_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Palaka lohoihoia pa kua manumanu dia ta lohoia e mahoto, ia da na haningana da e vatunga kavakava.” ");
INSERT INTO wiv_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Na Parisi katiu, hizana a Saimon e hulenia a Iesus kete vano hanihani kamana na kana ruma. Ia vano kamana. Dia ta mia dia kata hanihani. ");
INSERT INTO wiv_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Na tavine katiu na poloka taon kua kana mogemoge beta ni kemi. Kamana ki longoria a Iesus e hanihani na ruma kana Parisi kua, ia pelea botole e katua na kedo alabas, pefium na poloka. ");
INSERT INTO wiv_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Na tavine kua e madi kozoho na lamani Iesus, kozohotia kabena ki hahaloho, na liuka ki tuturu kara kabeni Iesus. Pale, ia bizia kabeni Iesus na vuluka, kini dodomia kabeni Iesus. Ia valikiria pefium kara kabena karua. ");
INSERT INTO wiv_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Na Parisi kua e kohania a Iesus ki mai kara hanihania e hadavia goloa kua, ia lohoia na poloka mule ki tania, “Kaka kua ni ia profet, ma e lala azei kua e vavakulia, ia na tavine zia. Na tavine kua ia na tavinena moge zahazaha.” ");
INSERT INTO wiv_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","A Iesus e hada lala kana lohoihoia, ia kolia vona ki tania, “Saimon, hau kagu polea katiu kata tania ni niho.” A Saimon ia tania, “Tania ni niau tisa.” ");
INSERT INTO wiv_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“Kaka rua kahiro dinau vona na kakanaka valavalanga na dinau. Katiu e dinau na 500 koin silva. Katiu e dinau na 50 koin silva. ");
INSERT INTO wiv_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Beta hiro na dangea hiro kata kolia kahiro dinau. Pale, ia lohoi bala kahiro dinau. Tu lohoia da azei ni hiro e dopa ki kulina kara kakanaka valavalanga na dinau kua?” ");
INSERT INTO wiv_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","A Saimon e tania, “Tauka, na kaka kana dinau e dopa ki kapou kini lohoi balanga, da e kulina dopa kirina.” A Iesus ki tania, “Ho tu tania ki mahoto matoto.” ");
INSERT INTO wiv_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","A Iesus e tolo kara tavine kua ki tania kiri Saimon, “Tu hada tavine kua? Hau ta mai hoho na ka ruma, beta nu vala naru kara kabegu, palaka ia e vazuguvia kabegu na liuka, ki bizia kabegu na vuluka. ");
INSERT INTO wiv_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ho beta nu domiau, palaka na tavine kua kamana ta mai hoho na ruma, beta ni hivu na domidomia na kabegu. ");
INSERT INTO wiv_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ho beta nu valikiria vel kara bakagu, palaka ia valikiria ki bizia pefium na kabegu. ");
INSERT INTO wiv_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kuza barae ta tania ni niho, kana moge zahazaha laveve te lohoi bala, kubarae ia kini vatunga kana hate motua. Palaka kaka kua beta ni dopa ni zaha ki lohoi balanga kana manaunaua da beta kete vatunga kana hate motua.” ");
INSERT INTO wiv_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Pale, a Iesus ia tania kara tavine kua, “Ka manaunaua laveve kava ti lohoi balanga.” ");
INSERT INTO wiv_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Manumanu taza ve kua dia ta mimia kamana na tebol dia ta varihulei, “Azei matoto kua e dangea kete lohoi bala moge zahazaha kamahi?” ");
INSERT INTO wiv_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","A Iesus ia e tania na tavine kua, “Ka bilip za ti vaikoli kiriniho, vano kamana magali kemia.” ");
INSERT INTO wiv_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Muri na kua, a Iesus ia vano kara taon katiukatiu ki vano ve na malala kotekote kamahi ki tani kakava na Kalohua Kemi na kingdom ke Vuvu. Kana 12 disaipel ve dia ta kamana, ");
INSERT INTO wiv_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","mai na tavivine taza ve, kua muga a Iesus e pele kakava na vule zaha kamahi, kamana mazahi na livuhadia. Hizana tavivine kamahi kua, ia a Maria, hizana katiu ve a Makdala, na tavine kua e pele kakavanga na vule zaha e 7 vona, ");
INSERT INTO wiv_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","a Joanna goni Kusa, a Kusa ia na kaka kua e hada poto na ruma ke Herot; ia mai a Susana kamana tavivine taza ve. Tavivine kua dia ta kodonia, dia ka babada kiri Iesus kamahi na kadia goloaloa mule. ");
INSERT INTO wiv_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Kilaka na kabuna manumanu kapou dia ta lohu, dia kene lupu. Na manumanu bukuna taon kamahi, dia ta mai ni Iesus. Ia barikikinia polea ki tani barae, ");
INSERT INTO wiv_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Kaka katiu e vano kete muratania harana vit. Tania ki muratania na harana vit, taza dia ta dua kara hiripa dala, ia vaka tadura, na manu kamahi dia ta hania taza. ");
INSERT INTO wiv_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Taza dia ta huru kara palaka kedokedora, tania dia ta galulu zahe dia ta mate, na vuna beta dia na paria naru na huduna kedo. ");
INSERT INTO wiv_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Harana vit taza dia ta huru kara poloka mota matangatanga, dia ka lupu galulu zahe, na mota ia rara havutidia. ");
INSERT INTO wiv_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Na harana vit taza ve dia ta dua kara garigari kemi. Dia ta galulu zahe, dia ta vua palekedia e dopa ki luba matoto. Habuka 100 katiukatiu na harana vit katiukatiu kua e muratanga.” E tani hozovia polea kua, ia goe ki tani barae, “Azei ho talinga vona, longoria polea kua.” ");
INSERT INTO wiv_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Na kana disaipel kamahi dia ta hulenia kara vuvuna barikikia kua. ");
INSERT INTO wiv_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ia tania, “Na hada lalanga na litigitigia na kingdom ke Vuvu kava ti valanga ni miu, palaka na manumanu, hau ta barikikinia polea, kete kubarae, ia vata kua dia ta hahada palaka mara beta dia na hadavia. Ia vata kua dia ta lolongoria polea, mara beta dia na lohoi lala. ");
INSERT INTO wiv_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Na vuvuna barikikia kua e kubarae, na harana vit ia na polea ke Vuvu. ");
INSERT INTO wiv_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Na harana vit kua e huru lilia hiripa dala, ia nuhu kua dia ta longoria polea, muri a Satan mai ia pele kakava polea na polokodia, kete beta dia kata bilip, dia na mahuri. ");
INSERT INTO wiv_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Na harana vit kua e huru kara huduna kedokedo, ia nuhu kua dia ta pelea polea dia ka hilohilo vona, palaka beta ni taruhia voraka na polokodia. Dia ta vaka maroro palaka beta ni havarau. Na tau kara parakilakilanga dia ta poke. ");
INSERT INTO wiv_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Na harana vit kena e huru kara poloka mota matangatanga, e makia nuhu kua dia ta longoria polea, palaka kamana dia ka vano na kadia daladala kamahi, dia ta lohoi vuvu na kadia goloaloa kamana kadia mianga kemi, pale, ia tabaria kadia lohoihoia, kubarae ki beta dia ne vua. ");
INSERT INTO wiv_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Na harana vit kena e huru kara garigari pa, ia e makia nuhu kua dia ta longoria polea. Magalidia e kemi ki mahoto. Dia ka paho taduria polea ki bada, dia kene vua.” ");
INSERT INTO wiv_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","A Iesus e tani barae ve, “Beta kaka ni lala kete dohotia lam ni kari havutia na baket o ni taruhia na taura kiri, palaka e taruhia na mudina lam kara manumanu kete hoho, dia kata hada na balangana. ");
INSERT INTO wiv_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Na vuna beta goloa katiu kua e litigianga, kua mara beta ni bele kakava o beta goloa katiu kua e litigianga kua mara beta ni lalanga o ni tanga ni bele, manumanu laveve ni lala. ");
INSERT INTO wiv_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Kubarae da miu ta lohoia, miu kata longo vutuhia polea. Azei ho kua ti ka goloa taza vona da a Vuvu e vala taza ve ni niho. Palaka azei kua tani beta matoto kana goloa vona, da nazia kena e lohoia kana vona, da e pele kakavanga vona.” ");
INSERT INTO wiv_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","A titinani Iesus kamani habu tazina dia ta mai dia kata hadavia, palaka ki mara beta dia na kozoho vona, na vuna, manumanu e luba matoto. ");
INSERT INTO wiv_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Manumanu taza dia ta tania ni Iesus, “Ka titi kamani habu tazi dia ta varimadiriai na hatama, ki kulidia dia kata hadaviho.” ");
INSERT INTO wiv_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","A Iesus e kolia ki tania, “Titinagu kamani habu tazigu ia nuhu kua dia ta longoria polea ke Vuvu dia ka muri vona.” ");
INSERT INTO wiv_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Boto katiu a Iesus e tania na kana disaipel kamahi, “Tolu kata vano kara paligena loka.” Pale, dia ta polo na bot dia kene vano. ");
INSERT INTO wiv_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Dia ta ba sel vano, matani Iesus ia tuturuve kini ngoro. Na kavili kapou ia bele kiridia na huduna loka. Na naru kini vevele hoho kara poloka bot, kozoho dia keteni mahitu. ");
INSERT INTO wiv_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Na disaipel kamahi dia ta vano dia ta vakongania a Iesus, dia ka tania, “Tubu, Tubu, tolu keteni mahitu!” A Iesus e lama ia pole kara kavili kamana dazi kapopou. Pale, ia malugunia kini manilo. ");
INSERT INTO wiv_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ia hulenia kana disaipel kamahi, “Kue kamiu bilip?” Dia ta kuahi dia ka lohoi tori, dia ka varihulei, “Azei matoto kua? E pole kara kavili kamana dazi hiro ka longoria kana polea.” ");
INSERT INTO wiv_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Dia ta vano bele na distrik Gerasa, na paligena ni Galili. ");
INSERT INTO wiv_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Kamana a Iesus ki zipa tadu na vazalea na kaka katiu bukuna taon na vule zaha kamahi dia ta holiholia, e mai ni Iesus. Havarau matoto kaka kua beta ni zozohoria lavalava o ni mimia na ruma, palaka e mimia na lovo kana kaka mate kamahi. ");
INSERT INTO wiv_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Kilaka ki hada a Iesus, ia goe kini dua kara kabeni Iesus, ki goe varitihi matoto, ki tania, “Nazia e kuli kirina ni niau ho Iesus tuni Vuvu kua e heta matoto? Ta hule haroiniho, taua nu vala varitihia ni niau.” ");
INSERT INTO wiv_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Na kaka kua e tatani barae, na vuna a Iesus e vala polea matuha na vule zaha kamahi dia kata gotala vona. Ti boto luba na vule zaha kamahi kua dia ta lala dia kata tuha zahe na poloka. Ia vata kua e rotu tadura kabena kamani limana na sen, dia ka hada poto vona, ia da e rabe hutuzia na sen. Na vule zaha kamahi kua dia ta lala dia kata katia ni rovo vano kara palaka kamahi kua beta kaka vona. ");
INSERT INTO wiv_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","A Iesus ia hulenia, “Hiza azei?” Ia tania, “A Armi.” E tani barae na vuna zia na vule zaha luba matoto na poloka. ");
INSERT INTO wiv_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Na vule zaha kamahi kua dia ta hule haroinia matoto tabarae ni geridia kiri loloni habuna. ");
INSERT INTO wiv_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Na kabuna boroboro taza dia ta hanihani na hiripa potuna. Na vule zaha kamahi kua dia ta hule haroinia a Iesus kete tara ni dia, dia na vano hoho na boroboro. Ia tara ni dia. ");
INSERT INTO wiv_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Na vule zaha kamahi kua dia ta mai gotala na kaka kua, dia kene vano hoho na boroboro kamahi kua. Na kabuna boroboro kua dia ta rovo varitihi ziho kara balibali na hiripa loka dia kene mahituhitu. ");
INSERT INTO wiv_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Nuhu kua dia ta hada poto na boroboro kamahi kua, dia ta hada goloa kua e bele, dia ta rovo vano tania goloa kua na poloka taon kamana malala kozohozoho na hiripa taon. ");
INSERT INTO wiv_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Manumanu dia ta vano gotala dia kata hadavia nazia kua e bele. Dia ta mai bele ni Iesus, dia ta hadavia habuka na kaka kua, na vule zaha ti gotala vona kava, ti zohoria na lavalava kana lohoihoia ti kemi. Ia kini mimia na kabeni Iesus. Pale, dia ta kuahi. ");
INSERT INTO wiv_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Nuhu kua dia ta hadavia matoto goloa kua e bele, dia ta ziuhia na manumanu na goloa kua a Iesus e katia na kaka kua, na vule zaha kini vatia, kua ia kini kemi. ");
INSERT INTO wiv_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Manumanu laveve bukuna palaka laveve na kantri Gerasa dia ta hulenia a Iesus kete vatidia, na vuna zia dia ta kuahi matoto. Pale, ia polo na bot kini vano. ");
INSERT INTO wiv_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Na kaka kua na vule zaha kamahi kua dia te vatia, e hule haroinia a Iesus kete kamani Iesus, palaka a Iesus ia geri mulehia ki tania, ");
INSERT INTO wiv_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Vamule vano kara ka malala nu tania na manumanu na goloa kapou kua a Vuvu ti katia ni niho.” Pale, na kaka kua ia vano kara palaka laveve na poloka taon ia tani kakava na goloa kapou kua a Iesus e katia vona. ");
INSERT INTO wiv_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Kamana a Iesus ki bele mule na paligena loka, na kabuna manumanu dia ta hilohilonia, na vuna zia dia laveve dia ta guguria. ");
INSERT INTO wiv_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Na kaka katiu hizana a Jairus ia na paraha kara haus lotu ke vuni Iuda, e mai ki dua kara kabeni Iesus ki hule haroinia kete kamana vano kara kana ruma, ");
INSERT INTO wiv_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","na vuna tuna keteni mate. Kana krismas e 12. Ia tuna tavine katiu za kua. Tania a Iesus ki vana vano kamani Jairus kara kana ruma, manumanu luba matoto dia ka didigiria. ");
INSERT INTO wiv_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Kilangata kua, na tavine katiu, na topo e lelele kirina, na krismas ti 12, palaka beta kaka katiu ni nap kete katia ni kemi. ");
INSERT INTO wiv_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Na tavine kua e mai zahe kozoho na lamani Iesus, ia vakulia na hiripa kana zohozohoa, kilaka pamuhi za na topo ia koga vona, ia kini kemi. ");
INSERT INTO wiv_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","A Iesus ia hule, “Azei e vakuliau?” Dia laveve dia ta linga, a Pita ki tania, “Tubu manumanu dia ta madi lobiho dia ka didigiriho.” ");
INSERT INTO wiv_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Palaka a Iesus ki tania, “Kaka katiu e vakuliau, hau ta hatunia matuhanga taza e vatiau.” ");
INSERT INTO wiv_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Kamana na tavine kua ti hada baraenia habuka mara beta ni paritigi, ia vanivani, ia mai dua kara kabeni Iesus. Ia tani kakava na matana manumanu laveve e kuziha ki vakulia zohozohoa ke Iesus, kua ia kini kemi pamuhi. ");
INSERT INTO wiv_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","A Iesus ia tania vona, “Tugu, ka bilip ti vaikoli kiriniho. Vano kamana magali kemia.” ");
INSERT INTO wiv_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","A Iesus e ba popole barae, na kaka katiu e pe na ruma ke Jairus, na paraha kara haus lotu ke vuni Iuda kua, ki tania, “Tu ti mate kava, taua nu ma kaborania na tisa.” ");
INSERT INTO wiv_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","A Iesus e longoria polea kua ia tania ni Jairus, “Taua nu kuahi ma vaka maroro za, tu kete kemi.” ");
INSERT INTO wiv_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","E vano bele na ruma ke Jairus, ia vano hoho, beta ni kulina kaka katiu ve kete hoho kamana. Palaka e pelea a Pita, a Jon, a Jems, ia mai na tamana kapiru kamana titinana kapiru za. ");
INSERT INTO wiv_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Manumanu laveve na poloka ruma dia ta tatangi, dia ka parikutu na kapiru kua. A Iesus ki tania, “Miu pale tangia. Kapiru beta ni mate, ia e ngongoro za.” ");
INSERT INTO wiv_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Dia ta nongonia, na vuna dia ta lala kapiru ti mate. ");
INSERT INTO wiv_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Palaka a Iesus ia pahoria limana kapiru kua, ia tania vona, “Tugu, lama!” ");
INSERT INTO wiv_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Pale, na vulena ia vamule, ia divurutia ia madi. A Iesus ia tania ni dia, dia kata vala haninga vona ni hania. ");
INSERT INTO wiv_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Tamana kamani titinana hiro ta ridi, hiro ka lohoi tori matoto, palaka a Iesus ia tani vatuharia ni hiro habuka taua matoto hiro na tania na kaka katiu na goloa kua e bele. ");
INSERT INTO wiv_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","A Iesus e koi lupunia kana 12 apostel kamahi, ia vala naba kamana matuhanga ni dia, dia kata pele kakava vule zaha ni gotala, dia kata kati kemihia ve nuhu kua mazahi ni dia. ");
INSERT INTO wiv_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ia geridia dia kata vano dia na tania na manumanu na vuna na kingdom ke Vuvu. Dia kata kati kemihia ve nuhu kua e mazahitidia. ");
INSERT INTO wiv_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","A Iesus ki tania ni dia, “Beta miu kata pelea goloa katiu na kamiu vavananga, beta miu kata pelea toho, beta beke, beta bret, beta moni, beta ve miu kata pelea kamiu zohozohoa ni rua. ");
INSERT INTO wiv_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ruma kakei miu kene ngoro vona, da miu ta mia vona ki mule na dama miu kata vatia taon kena. ");
INSERT INTO wiv_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Kini beta manumanu dia na kemi kirimiu, dia na koi tadurimiu, miu pali tubinia havuhavu ni huru na kabemiu, kete vatunga habuka kadia moge dia ta katia e beta ni kemi, miu ta vatia kadia taon.” ");
INSERT INTO wiv_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Pale, dia ta vavana, dia ta vano na malala katiukatiu, dia kene tania na manumanu na Kalohua Kemi ke Vuvu, dia ka vamahurivia nuhu kua mazahi ni dia, na palaka laveve. ");
INSERT INTO wiv_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","A Herot Antipas, na gavana kara distrik a Galili, e longoria na goloa laveve kua a Iesus e kakatia, ia kini lohoi tori, na vuna zia, taza dia te tania, a Jon ti mahuri mule na matea, ");
INSERT INTO wiv_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","taza ve, dia ta tania a Elaija ti bele mule, taza ve dia ta tania na profet katiu bukuni varira ti lama mule. ");
INSERT INTO wiv_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","A Herot ki tania, “Hau te le hutuzia kene pele kakava bakani Jon. Pele, azei matoto kua ta longoria na polea kamahi kua vona?” Ia kini paparakilania kete hadavia a Iesus. ");
INSERT INTO wiv_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Kilaka na disaipel kamahi dia ka belebele mule, dia ta tania ni Iesus na goloa laveve kua dia ta katia. A Iesus ia peledia ta kamana, dia kene vano kazihedia kara taon katiu hizana a Betsaida. ");
INSERT INTO wiv_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Palaka na kabuna manumanu kapou matoto, dia te lala ti vano kiri Betsaida, dia ta muri vona. Ia kohanidia kini popole kamadia na vuna na kingdom ke Vuvu, ki kati kemihia ve nuhu kua e mazahitidia. ");
INSERT INTO wiv_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ti garavi matoto, na 12 disaipel kamahi dia ta mai vona, dia ka tania, “Geri kakava manumanu dia na vano kara malalala kamahi kua kozoho, dia na kaze haninga kamana palakana ngoroa, na vuna zia tolu na palaka kua beta kaka vona.” ");
INSERT INTO wiv_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","A Iesus e kolia ki tania, “Miu mule miu vala haninga ni dia.” Dia ka tania, “Na bret e lima kamana hiha rua za kua ni hita. Tauka, e kuli hita kata vano kadea haninga hana kabuna manumanu kua?” ");
INSERT INTO wiv_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","E hada barae manumanu laveve kua e 5,000. Palaka a Iesus ki tania na kana disaipel kamahi, “Tania ni dia, dia na loli tadu habuka, 50-50 na kabu katiukatiu.” ");
INSERT INTO wiv_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Na disaipel kamahi dia ta katia nazia kua a Iesus e tania. Pale, manumanu laveve dia ta loli tadu. ");
INSERT INTO wiv_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ia pelea na bret lima kua kamana hiha rua kua, ia tunga vatada kara lagato, ia hate motunia a Vuvu vona, ia bara vulahia. Pale, ia vala na kana disaipel kamahi, dia kata vazenia na manumanu. ");
INSERT INTO wiv_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Manumanu laveve kua dia ta hanihani magalidia ki kurukuru, na disaipel kamahi dia ka gorea kolopina kalangara haninga e 12. ");
INSERT INTO wiv_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Boto katiu a Iesus e lolotu kazihena, kana disaipel kamahi dia ta mimia kamana, ia hulenidia, “Manumanu dia ta tania hau azei matoto?” ");
INSERT INTO wiv_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Dia ta kolia, dia ka tania, “Taza dia ta tania ho a Jon kakanaka baptais, taza dia ta tania ho a Elaija, taza ve dia ta tania ho na profet katiu ni dia kua bukuni varira ti mahuri mule.” ");
INSERT INTO wiv_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","A Iesus e hulenidia, “Pele, miu mule? Miu ta tania hau azei matoto?” A Pita ki kolia ki tania, “Ho a Kristus, kua a Vuvu e geria.” ");
INSERT INTO wiv_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","A Iesus ia tani vatuharia ni dia, beta dia kata tania na kaka katiu habuka ia a Kristus. ");
INSERT INTO wiv_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ia ki tani barae, “Na Tuna Kaka da e pelea bizea na goloa luba, da pararaha ke vuni Iuda, na hetpris kamahi, kamana tisa kamahi kara lo, da dia ta pole katia. Ki hubu matoa. Ki valamari muleha na dama toluna.” ");
INSERT INTO wiv_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ia ki tania ni dia laveve, “Ta katiu ni kulina kete muri ni niau, kete lohoi bala ia mule, ia luga kana kruse na dama laveve ia muri ni niau. ");
INSERT INTO wiv_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ta azei ni miu tani ma poto na kana mogemoge kamana kana mianga, da e golu, palaka azei tani vatia kana mogemoge kamana kana mianga na vuna na hizagu, da e pele mulehia ki mahuri. ");
INSERT INTO wiv_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Da nazia e kemi kana kaka kua tani kana goloaloa laveve vona ri na garigari, palaka ia mule ni golu o ni dua kara haroho. Da goloaloa laveve kua e kodoni zingania? ");
INSERT INTO wiv_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ta katiu ni puae ni niau kamana kagu polea, na Tuna Kaka ve da e puae vona na dama kua ia kete bele mule kamana kana glori, ia mai ve na glori ke Tamana kamana engel tumonga kamahi. ");
INSERT INTO wiv_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Hau ta tani matotonia ni miu, taza ni miu ri kua da dia ta muga hadavia na kingdom ke Vuvu, ba muri dia kene mate.” ");
INSERT INTO wiv_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Dama 8 muri na polea kua a Iesus e tania, ia pelea a Pita, a Jon mai a Jems, dia kene vori kara potuna katiu dia kata lotu. ");
INSERT INTO wiv_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Kamana ki lolotu barae, na damana ia pokizia kana zohozohoa ve kini kalageru balika balangana hanimata. ");
INSERT INTO wiv_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Kaka rua, a Moses hiro a Elaija, hiro ta pe na lagato, hiro ka popole kamana. ");
INSERT INTO wiv_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Hiro ta bele kamana glori ke Vuvu. Hiro ka popole kamani Iesus na vuna na kana matea, kua kete bele matoto ni Ierusalem. ");
INSERT INTO wiv_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","A Pita kamana hiro rua, dia te ngoro mate, palaka kamana dia ka lama, dia ta hada balangana kana glori kamana kaka rua kua hiro ta mamadi kamana. ");
INSERT INTO wiv_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Kamana hiro ka vatia a Iesus, a Pita ia tania ni Iesus, “Tisa, e kemi kua tolu ta lupu ri kua, vatia hita kata habatia kape tolu, katiu ka, katiu ke Moses, katiu ke Elaija.” A Pita beta ni lohoi lala nazia kua ia e tatania. ");
INSERT INTO wiv_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","A Pita e ba popole barae na mariaba ia mai kari havutidia. Dia ta kuahi matoto kamana kua na mariaba ti kari havutidia. ");
INSERT INTO wiv_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Na polea katiu e pe na mariaba ki tani barae, “Ia na Tugu kua, hau ta makia; miu longo kirina.” ");
INSERT INTO wiv_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Kamana polea kua ti hozo, dia ta hada ti beta kaka kamani Iesus. Pale, na disaipel kamahi beta dia na tania na kaka katiu na goloa kua dia ta hadavia, kilaka kua. Dia ta ma zodo za. ");
INSERT INTO wiv_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Na dama muri vona, kilaka kua dia te tiro mule na potuna, dia ta paria kabuna manumanu kapou matoto dia ta guguridia. ");
INSERT INTO wiv_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Na kaka katiu na poloka manumanu kua e goe ki tania, “Tisa, ta hule haroiniho, hadavia tugu! Na vuna ia tugu katiu papa za kua. ");
INSERT INTO wiv_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Na vule zaha e holiholia ki lala kete katia ni gigi valutu, ki lala kete dua ni daea na hivohivo ni gotala na havana. Na vule zaha beta ni lala kete vavatia. Keteni hubi matehia. ");
INSERT INTO wiv_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Hau te hule haroinia ka disaipel kamahi dia kata pele kakava vule zaha kua, palaka mara beta dia na pele kakava.” ");
INSERT INTO wiv_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","A Iesus ki kolia ki tania, “Miu nuhu kua beta matoto kamiu bilip, kamiu lohoihoia kamana kamiu mogemoge ve beta ni mahoto. Kete boto ziva kata ma luluga kamiu bizea? Pelea tu ni mai.” ");
INSERT INTO wiv_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Na kapiru kua e ba vavana ki mamai, na vule zaha ia varaga kara garigari, na kapiru kua, ia daea. Palaka a Iesus e pole kara vule zaha kua, na kapiru kua ia kemi, a Iesus kini vala mulehia ni tamana. Manumanu laveve kua dia ta hadavia na matuhanga kapou ke Vuvu, dia ka zipa zahe matoto. Kilaka manumanu laveve dia ta ba lohoi toritori na goloa laveve a Iesus e kakatia, ia tania na kana disaipel kamahi, ");
INSERT INTO wiv_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Miu longo kemikemihia nazia hau keteni tania ni miu. Na Tuna Kaka da e tilitili tika voa kirua ki valanga ia na limana manumanu.” ");
INSERT INTO wiv_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Palaka na disaipel kamahi beta dia na lohoi lala na vuvuna polea kua. E litigianga ni dia, kuza barae ki beta dia na lohoi lala, dia ka kuahi ve dia kata hulenia vona. ");
INSERT INTO wiv_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Na disaipel kamahi dia ta vavaigege na pidaka dia mule, azei ni dia da e kara paraha. ");
INSERT INTO wiv_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","A Iesus ti lohoi lala kadia lohoihoia, ia pelea kapiru kote katiu ia vamadiria kozoho vona, ");
INSERT INTO wiv_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ki tania ni dia, “Ho azei kua tanu kati kemihia na kapiru kote kua nu koi taduria na hizagu, ia e habuka tu koi taduriau; azei e koi taduriau, ia e koi taduria kaka kua e geriau ka mai. Na vuna, azei kena beta ni hizanga na pidaka miu laveve, ia da e kara paraha.” ");
INSERT INTO wiv_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","A Jon ia tania, “Tubu, hita ta hada kaka katiu e pele kakava vule zaha kamahi na hiza, hita ka parakilania tania vona beta kete ma kakatia, na vuna beta ia ni katiu ni hita kua hita ta lala hita kata mumuri ni niho.” ");
INSERT INTO wiv_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","A Iesus ki tania, “Taua miu na vatabunia, azei kua tani beta ni madi poki kirimiu, ia e kamakamamiu.” ");
INSERT INTO wiv_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Na dama ti kozoho kirina keteni peola ni zahe kara lagato, a Iesus ia vatuharia kana lohoihoia kini vavana kiri Ierusalem. ");
INSERT INTO wiv_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ia geri mugania nuhu taza dia kata kara havana dia na vamuga vona, dia ta vano hoho na malala katiu ni Samaria dia kata kaze ruma katiu kua dia kata ngoro vona. ");
INSERT INTO wiv_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Palaka na manumanu na malala kua beta dia na koi taduria, beta ni kulidia kete hoho na kadia malala na vuna zia, dia ta lala ia e vavano kiri Ierusalem. ");
INSERT INTO wiv_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Kamana na disaipel karua kua, a Jems hiro a Jon, hiro ka hada baraenia, hiro ta tania, “Paraha, kuli tolu kata koi kara haroho bukuna lagato ni ziho hania manumanu kua?” ");
INSERT INTO wiv_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Palaka a Iesus e tare poki, ia pole kiridia, ");
INSERT INTO wiv_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","dia kene ma vana vano kara ruana malala. ");
INSERT INTO wiv_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","A Iesus kamana kana disaipel kamahi dia ta vavana na dala, na kaka katiu ia tania vona, “Hau da ta ma muri ni niho kara palaka laveve kena koto kirina.” ");
INSERT INTO wiv_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","A Iesus ki kolia ki tania, “Hadora kamahi kadia boronga vona, na manu kamahi na mariaba, baledia vona, palaka na Tuna Kaka beta kana palaka kete vangorea bakana vona.” ");
INSERT INTO wiv_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ia tania kara ruana kaka, “Muri ni niau.” Palaka na kaka kua ki tania, “Paraha, vatiau ka muga vano ka tavunia tamagu.” ");
INSERT INTO wiv_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","A Iesus ki tania vona, “Vatia na nuhu kena dia te varimateai kava, dia na tavunia kadia kaka mate, palaka ho vano nu tani kakava na manumanu na vuna na kingdom ke Vuvu.” ");
INSERT INTO wiv_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Kaka katiu ve ki tania, “Paraha, hau da ta muri ni niho, palaka vatiau ka vano muga tani hoto na habu kagu.” ");
INSERT INTO wiv_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","A Iesus ki kolia vona ki tania, “Ta kaka katiu ni hubia gan na vanua ni tutunga hule, ia beta ni dangea kete katia na galangalanga na kingdom ke Vuvu.” ");
INSERT INTO wiv_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Muri na kua, a Iesus ia makia manumanu e 72, ia geridia rua rua, dia ta vamuga vano kara poloka taon laveve kamana malala laveve kena ia keteni vano kirina. ");
INSERT INTO wiv_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ia ki tania ni dia, “Haninga luba na poloka vanua ti matuha keteni peola, palaka na nuhuta galanga beta ni luba. Kubarae miu hulenia na Paraha kua e hada na pelepelea na haninga kete geria nuhuta galanga dia kata vano kara palakana pelepelea na haninga. ");
INSERT INTO wiv_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Miu vano! Hau ta gerimiu balika tuna sipsip kara pidaka kauaua zahazaha. ");
INSERT INTO wiv_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Taua miu na pelea kamiu hanpaus, kamiu beke, o sadel kara vavananga; taua miu na pole kamana kaka katiu na dala. ");
INSERT INTO wiv_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Miu kene hoho na ruma katiu, miu muga miu ka tania, ‘Magali kemia na ruma kua.’ ");
INSERT INTO wiv_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Tani kaka kemi katiu ra, kamiu magali kemia da e ngoro papa vona; tani beu, da kamiu magali kemia e vamule ni miu. ");
INSERT INTO wiv_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Miu mia na ruma kena, miu ka hania o hinumia nazia dia ta vala ni miu, na vuna ia kena kadoamiu kena. Taua miu na dangea rumaruma. ");
INSERT INTO wiv_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Miu kene hoho na taon dia kene koi tadurimiu, miu hania nazia kena e vakodoa miu vona. ");
INSERT INTO wiv_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Kati kemihia nuhu kena e mazahitidia na palaka kena, miu ka tania ni dia, ‘Na kingdom ke Vuvu kava ti mai kini kozoho ni miu!’ ");
INSERT INTO wiv_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Palaka miu kene hoho na taon kini beta dia na koi tadurimiu, miu vana na pidaka kadia dala na poloka taon, miu ta tani barae, ");
INSERT INTO wiv_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Havuhavu bukuna kamiu taon kua e rako na kabehita, da hita ta pali tubinia kirimiu. Kete vatunga muria habuka na mak zaha katiu kirimiu. Palaka miu lala matotonia habuka, na kingdom ke Vuvu kava ti mai kini kokozoho.’ ");
INSERT INTO wiv_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ta tania ni miu, na dama kena a Vuvu e makia kete koto kara manumanu, bizea kua kete bele na manumanu bukuna taon kena da e dopa ki kapou na bizea kua na nuhu kua bukuni Sodom dia ta luga. ");
INSERT INTO wiv_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Kaba loho zahanga ni niho, ho Korasin! Kaba loho zahanga ni niho, ho Betsaida! Na vuna na mirakel kamahi kua e katua na polokomiu ni katua ni Tair kamani Saidon, ma varira za dia te puae dia kene pokizia magalidia, dia kene zohoria na beke dia kene bode na habulo. ");
INSERT INTO wiv_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Palaka tani damana kotoa da e dopa ki kemi pitu ke Tair hiro a Saidon. Palaka miu, da miu ta vairo matoto. ");
INSERT INTO wiv_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Da, ho Kaperneam, tu lohoia, da a Vuvu e peleho ku zahe kara lagato, ai? Mara beta, da tu ziho kiri loloni habuna. ");
INSERT INTO wiv_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Azei e longoria kamiu polea, ia e habuka e longoria kagu polea; azei tani pole katimiu ia e habuka e pole katiau; palaka azei kua tani pole katiau, ia e habuka e pole katia kaka kua e geriau ka mai.” ");
INSERT INTO wiv_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Manumanu 72 kua dia ta vamule kamana hilohiloa dia ka tania, “Paraha, kua hita ta kohania hiza, na vule zaha kamahi ve dia ta muri na kahita polea.” ");
INSERT INTO wiv_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","A Iesus ki tania ni dia, “Hau ta hada a Satan e dua na lagato balika hanimata. ");
INSERT INTO wiv_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Hau te vala matuhanga ni miu, miu kata vaka langalanga na matabunu kamahi kamana kavelavela kamahi, miu na pele kakava matuhanga kana hamiu vagi. Mara beta goloa katiu ni vairohimiu. ");
INSERT INTO wiv_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Palaka, tabarae miu na hilohilo na vuna kua na vule zaha kamahi, dia ta longoria, dia ka muri na kamiu polea. Palaka miu hilohilo na vuna hizamiu ti vapolunganga na lagato.” ");
INSERT INTO wiv_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Kilaka kena ve na Vule Tumonga e katia a Iesus ki hilohilo matoto, ki tania, “Hau ta vazahenia hiza Tamagu, Paraha kara lagato kamana garigari, na vuna zia ho tu litiginia goloaloa kua na nuhu kua kadia hada lalanga vona kamana nuhu kua bakadia vona. Kunu vatunga kakava ni kapiru kotekote. E limoha Tamagu, na vuna zia ia kua e kuli matoto kete kubarae. ");
INSERT INTO wiv_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Goloaloa laveve kava Tamagu ti vala ni niau, kata hada vona. Beta kaka katiu ni lala hau azei matoto, a Tamagu za ia e lalau. Beta ve kaka katiu ni lala matotonia Tamagu ia azei, a Tuna za, ia e lala, ki vatunga a Tamana na nuhu kua ia ti makia kete vatunga kavakava a Tamana ni dia.” ");
INSERT INTO wiv_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Pale, ia tare poki kara kana disaipel kamahi ia pole kamadia za ki tania, “Kaka kua e hada goloa kua miu ta hahada ia da e hilohilo. ");
INSERT INTO wiv_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Na vuna hau ta tania ni miu profet luba kamana king kamahi e kulidia dia kata hada nazia miu ta hada palaka beta dia na hadavia, dia kata longoria nazia kua miu ta longoria palaka beta dia na longoria.” ");
INSERT INTO wiv_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Na dama katiu na kaka katiu kua e lala kemikemihia na lo e madi kete parakilania a Iesus. Ia hule, “Tisa nazia da ta katia kata pelea mahuri roroa?” ");
INSERT INTO wiv_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","A Iesus e kolia ki hulenia, “Nazia e vapolunganga na poloka lo? Tu hazeni zingania?” ");
INSERT INTO wiv_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ia kolia ki tania, “‘Kete kuli kara Paraha ka Vuvu na poloko laveve kamana ka hatuhatua laveve, na vule, na ka matuhanga laveve, kamana ka lohoihoia laveve, kete kuli matoto kara kaka kua e mimia kozoho ni niho, habuka kua e kuli kiriniho mule.’” ");
INSERT INTO wiv_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","“Ho tu koli mahotovia kena,” a Iesus e tania, “Kati baraenia, ho koto mahuri.” ");
INSERT INTO wiv_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Palaka na tisa kara lo kua e lohoia kete vatunga habuka ia e lala kete muri papa na lo. Pale, ia hulenia a Iesus, “Pele azei ia na kaka kua e kozohotiau?” ");
INSERT INTO wiv_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","A Iesus ia kolia kana polea ki tania, “Kaka katiu e pe ni Ierusalem ki ziziho kiri Jeriko. Na raskol kamahi dia ta haba taduria. Dia ta hulia kana zohozohoa na livuhana. Dia ta hubi zahazahatia matoto, pitu papa za ni mate. Dia ta vatia, dia kene vano. ");
INSERT INTO wiv_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Na pris katiu, ia ve e pe na dala kena ki ziziho, kamana ki hada kaka kua e ngongoro, ia pe hutu, pe na paligena dala. ");
INSERT INTO wiv_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Na Livai katiu ve e pe na dala kua ki ziziho, ia ve e hada kaka kua, ia pe na paligena dala ve. ");
INSERT INTO wiv_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Palaka na kaka katiu bukuni Samaria, e vavana ki ziho na palaka kena na kaka kua vona, tania ki hadavia, na lohora e zaha matoto vona. ");
INSERT INTO wiv_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ia vano vona, ia valikiria vel kamana vaen kara mukuna kamahi. Ia pipizia mukuna kamahi na banis. Pale, ia luga, ia vapolea na kana huduna donki. Ia vapolea vano kara haus pasidia katiu kini hada poto vona. ");
INSERT INTO wiv_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ti dama ia pelea na moni rua ia vala na tauana haus pasidia kena, ia tania vona, ‘Hada poto vona. Moni kua kini hozo, kunu varaga ka moni mule koto hada poto vona, ta na vamule da ta kolia ka moni.’ ");
INSERT INTO wiv_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Azei ni dia tolu kua tu lohoia ia na kaka kua e kozoho na kaka kua e paria zahatanga na limani vuni raskol?” ");
INSERT INTO wiv_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Na kaka kua e lala kemikemihia lo e tania, “Na kaka kena lohora e zaha vona ki kodonia.” A Iesus ia tania vona, “Pele, vano nu kati baraenia.” ");
INSERT INTO wiv_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","A Iesus kamana kana disaipel kamahi dia ta vavana vano, dia ta bele na malala katiu. Na tavine katiu, hizana a Marta ia koi taduridia kara kana ruma. ");
INSERT INTO wiv_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Tazina katiu hizana a Maria, ia mai mia kozoho na kabeni Iesus ki tatabu longo kara polea ke Iesus. ");
INSERT INTO wiv_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Palaka a Marta e lohoi vuvu na galangalanga luba na haninga kua kete katua. Ia vano ni Iesus ia hulenia, “Paraha, beta nu hada ni zaha kua a tazigu ti vatia galangana haninga hau kene kakatia kazihegu? Tania vona ni mai kodoniau!” ");
INSERT INTO wiv_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Na Paraha e kolia vona ki tania, “Marta! Marta! Ho tu lohoi vuvu ka lohoihoia ki vonu na goloa luba marata. ");
INSERT INTO wiv_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ka lohoihoia, ia kete ngoro na goloa katiu za. Goloa kua a Maria e kulina kete pelea ia e dopa ki kemi, ki mara beta ni pele kakavanga vona.” ");
INSERT INTO wiv_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Dama katiu a Iesus e lolotu na palaka katiu. Kamana ki hozo, kana disaipel katiu ia tania vona, “Paraha, vatunga ni hita na polealeana lotua katiu na vuna a Jon e vatunga katiu na kana disaipel kamahi.” ");
INSERT INTO wiv_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","A Iesus ia tania ni dia, “Miu kene lotu da miu ta tani barae, ‘Tamagu paleka hiza ni vazaheanga, ka kingdom ni mai. ");
INSERT INTO wiv_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Vala ni hita hahita haninga kara dama katiukatiu. ");
INSERT INTO wiv_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Lohoi bala kahita manaunaua, na vuna hita ve hita ta lala hita kata lohoi bala goloa zaha kua kaka e katia ni hita. Taua nu pelehita vano hoho na parakilakilanga.’” ");
INSERT INTO wiv_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Pale, ia tania ni dia, “Ta katiu ni miu ni ruana katiu vona, ia ni vano na varivalavala ni tania, ‘Ruagu, kata dinau na bret tolu ni niho, ");
INSERT INTO wiv_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","na vuna ruagu katiu e pe zau ki mai ni niau, ki beta haninga ni niau kata vala vona.’ ");
INSERT INTO wiv_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Kaka na poloka ruma e kolia ki tania, ‘Taua nu kaboraniau. Na hatama ti tabara kava, hita kene varingoroai. Mara beta na lama na vala goloa katiu ni niho!’” ");
INSERT INTO wiv_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","A Iesus ki tania, “Hau ta tania ni miu. Ia vata kua ia e lala habuka kaka kua ia na ruana ki dangea kete vanga holuholu vona, palaka da e lama ki vala nazia e kulina kirina, na vuna e ma ki huhubia kana hatama. ");
INSERT INTO wiv_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Kubarae hau ka tania ni miu: Hule kete valanga ni niho, kaze nu paria, hubia doa ia ni vukaza kiriniho. ");
INSERT INTO wiv_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Na vuna manumanu laveve kua dia ta hule, da dia ta pelea; azei kini kakaze, da e paria; mai azei e hubia na doa, da e vukaza doa kirua. ");
INSERT INTO wiv_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Azei ni miu kua habu tamani kapirupiru, ta tu ni hule kara hiha, da tu vala matabunu vona? ");
INSERT INTO wiv_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O tani huleniho kara koruna toha, da tu vala kavelavela vona? ");
INSERT INTO wiv_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Pele miu, ia vata kua miu ta nuhuta moge zahazaha, palaka miu ta lala miu kata vala goloa kemikemi ni habu tutumiu. Kubarae ia da miu ta lala matotonia kubarae, Tamamiu na lagato da e vala Vule Tumonga na nuhu kua dia ta hulenia kirina!” ");
INSERT INTO wiv_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","A Iesus e pele kakava na vule zaha kena e manga na kaka katiu. Kamana na vule zaha kua ki kakava, na kaka kua muga e manga ia pole. Na kabuna manumanu laveve dia ta zipa zahe. ");
INSERT INTO wiv_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Palaka taza ni dia, dia ta tania, “Ia e pele kakava vule zaha kamahi na matuhanga ke Belsebul, na paraha ke vule zaha kamahi.” ");
INSERT INTO wiv_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Taza dia ta lohoia dia kata parakilania, dia ta hulenia kara mak katiu bukuna lagato. ");
INSERT INTO wiv_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","A Iesus ti lohoi lala kadia lohoihoia, ia ki tania kiridia, “Ta kingdom katiu ni varipe vulavulahi da e hozo, ta famili katiu ni varipe vulavulahi da dia ta hozo. ");
INSERT INTO wiv_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Kua a Satan ni varipe vulavulahi kamana mule, da kana kingdom e hozo. Hau ta tani barae na vuna miu ta tania hau ta pele kakava vule zaha na matuhanga ke Belsebul. ");
INSERT INTO wiv_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ta hau na pele kakava vule zaha na matuhanga ke Belsebul, pele miu, nuhu kua dia ta mumuri ni miu dia ta pele kakava vule zaha na hizani zei? Kubarae da dia ta vatunga habuka kamiu lohoihoia beta ni mahoto. ");
INSERT INTO wiv_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Palaka kua hau na pele kakava vule zaha na matuhanga ke Vuvu, pele na kingdom ke Vuvu kava ti bele ni miu. ");
INSERT INTO wiv_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ta kaka matuha katiu ni madi kamana kana honana varihubia ni hada poto papa na kana ruma mule, kana goloaloa da e ngoro kemikemi. ");
INSERT INTO wiv_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Palaka kua kaka katiu e dopa ki matuha vona ni mai varihubi kamana ni dibala, da e pele kakava na kana honana varihubia kena e vaka maroro vona, ia vanahea kana goloaloa ia vazenia na kana manumanu. ");
INSERT INTO wiv_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Azei ho ta beta nu kodokodoniau ia ho tu madi poki kirigu, ho azei kua ta beta nu lulupunia manumanu kamaniau, ia tu vaikali manumanu. ");
INSERT INTO wiv_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Kua vule zaha katiu ni gotala ni vatia na kaka katiu, da e vano kara deset ki kazekaze palaka kete hivu vona. Palaka kua tani beta ni paria, da e tania, ‘Kata vamule kara ruma kua muga ta vatia.’ ");
INSERT INTO wiv_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","E mai bele ia paria na ruma ti kuvua kini puzopuzoa goloa laveve e ngoro papa. ");
INSERT INTO wiv_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Pale, ia vano pelea ve habu tamaninika 7 kua dia ta dopa zaha matoto vona, dia ta vano hoho na ruma kua, dia kene mia vona. Pale, na kaka kena da ti dopa kini zaha matoto dopa na muga.” ");
INSERT INTO wiv_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","A Iesus e ba popole na goloa kamahi kua, na tavine katiu na poloka kabuna manumanu kua e goe ki tania, “A Vuvu e kati kemihia matoto na tavine kua e valohiho ki vazuziho.” ");
INSERT INTO wiv_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Palaka a Iesus ki tania, “A Vuvu da e dopa ki kati kemihia matoto na nuhu kua dia ta longoria kana polea dia ka muri vona.” ");
INSERT INTO wiv_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Kamana manumanu dia ta lohu luba, a Iesus ia tania, “Manumanu bukuna tauna kua dia ta manumanu zahazaha matoto. Dia ta hule dia kata hada mak katiu bukuna lagato, palaka mara beta katiu ni valanga ni dia, na mak katiu za da e valanga ni dia ia na mak ke Jona. ");
INSERT INTO wiv_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","A Jona e bele balika mak kiri vuni Ninive. Na Tuna Kaka ve da ia ti kara mak kana manumanu bukuna tauna kua. ");
INSERT INTO wiv_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Na damana kotoa kapou ke Vuvu, da Kwin bukuni Saut e madi ki koto kara manumanu bukuna tauna kua; kete vatunga habuka ia e longoria polea ke Vuvu, dia betaka, na vuna ia e pe na malala zau ki mai kete longoria polea kemikemi ke Solomon, palaka kaka katiu kuari na pidaka miu ia e dopa ni Solomon. ");
INSERT INTO wiv_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Manumanu bukuni Ninive, da dia ta madi na damana kotoa kapou ke Vuvu, dia ka koto kara manumanu bukuna tauna kua, na vuna a vuni Ninive, dia ta longoria polea ke Jona, dia ka pokizia magalidia. Palaka Kaka katiu kuari na pidaka miu ia e dopa ni Jona. ");
INSERT INTO wiv_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Mara beta kaka ni dohotia lam ni taru batavia beu ni taruhia na taura dis. Beta! Da e havenia na mudina lam kara manumanu dia kata mai hoho dia ta hadavia balangana lam. ");
INSERT INTO wiv_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Mata ia na lam kara livuha. Kua mata ni kemi, ia livuha laveve da e vonu ve na hadanga. Palaka tani zaha, livuha laveve da e rodorodoa. ");
INSERT INTO wiv_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Hada vutuhia tabarae hadanga kena tu lohoia ia na poloko ni rodorodoa. ");
INSERT INTO wiv_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kuza barae, ta livuha laveve ni vonu na hadanga ni beta pitu ni rodorodoa, da livuha laveve e hada habuka na lam kapou e balanga livuha.” ");
INSERT INTO wiv_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","A Iesus e hozo polea, na Parisi katiu ia hulenia kete vano hanihani kamana. Pale, ia vano kara kana ruma ia mia kamana na tebol. ");
INSERT INTO wiv_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Palaka na Parisi kua e tara vilu, na taem kua e hada a Iesus beta ni muga vazuguvia limana ba muri kini hanihani. ");
INSERT INTO wiv_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Pale, na Paraha ia tania vona, “Miu vuni Parisi miu ta lala miu kata vazuguvia hatamara kap kamana dis, palaka polokomiu e vonu na makina vanahoa kamana moge zahazaha. ");
INSERT INTO wiv_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Miu ta longolongo matoto! Karae beta a Vuvu kua e katia na hatamara ni katia ve poloka? ");
INSERT INTO wiv_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Palaka vala nazia kena na poloka dis na nuhu kua beta kadia goloaloa vona. Pale, na goloa laveve ni puzopuzoa kiriniho. ");
INSERT INTO wiv_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Kaba loho zahanga ni miu vuni Parisi, na vuna zia miu ta vala kamiu taits na kamiu moni kamana hamiu haninga kamana laulaua kamahi, palaka miu ta lohoi vetavetania miu kata katia moge mahoto ki beta ni kukulimiu kiri Vuvu. Miu kata murimuri papa na lo ke Vuvu miu na kakatia moge mahoto, kamana goloaloa laveve kena, ia ni kemi. ");
INSERT INTO wiv_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Kaba loho zahanga ni miu vuni Parisi, na vuna zia e lala kete kulimiu kara mianga kena e taruha ke pararaha na mugana haus lotu kamahi ke vuni Iuda, mai ve e lala kete kulimiu matoto kete hada zaheanga miu na palakana lupua. ");
INSERT INTO wiv_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Kaba loho zahanga ni miu, na vuna zia miu ta balika matmat kamahi kua e paritigi na poloka garigari; manumanu ki beta dia na lala dia ta vaka langalanga ni dia.” ");
INSERT INTO wiv_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Na tisa katiu kara lo e longoria polea kua ki tania, “Tisa, tu tani barae kena, ia tu pole zahatihita ve kena.” ");
INSERT INTO wiv_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","A Iesus ki kolia ki tania, “Kaba loho zahanga ni miu, tisa kara lo kamahi! Na vuna, miu ta valuga manumanu na bizea kapopou ki beta ni nap dia kata luga, ki beta matoto miu na lala miu kata katia goloa katiu kua kete kodonidia. ");
INSERT INTO wiv_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Kaba loho zahanga ni miu! Vuna zia, miu ta katikati matmat mata mulimuli kana profet kamahi bukuni varira, palaka ia habu tubumiu za kua dia ta vaihubi mate kamadia. ");
INSERT INTO wiv_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Na vona kua miu te habahaba kadia matmat, ia ti makia habuka miu ta magali katiu kamadia kua dia ta vaihubi na profet kamahi. ");
INSERT INTO wiv_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Na vuna a Vuvu e lala da e bele barae, kubarae na kana lohoihoia pa, ia ki tani barae, ‘Da ta geria profet kamana apostel kamahi dia ka vano ni dia. Da dia ta hubi matehia taza, dia ka kalingania taza.’ ");
INSERT INTO wiv_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Kubarae nuhu bukuna tauna kua, da dia ta pelea zahatanga taraka kua habu tubudia e vaihubi mate profet kamahi, kilaka kua na taem a Vuvu e katia garigari ki mai ki mule na tauna kua, ");
INSERT INTO wiv_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","varivuvu ni Abel ki mule ni Sekaraia, kaka kua e hubua na pidaka altar kamana tempel. E limoha, ta tania ni miu, manumanu bukuna tauna kua da dia ta pelea zahatanga taraka moge ke habu tubudia. ");
INSERT INTO wiv_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Kaba loho zahanga ni miu, tisa kara lo kamahi! Miu ta pele kakava ki kua kete vukazia doa kara hada lalanga na goloa; palaka miu mule beta miu na hoho vona, miu ta madi porotia dala kara manumanu kua dia ta parakilania dia kata hoho.” ");
INSERT INTO wiv_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Tania a Iesus ki vatia na palaka kua, na Parisi kamahi kamana tisa kamahi kara lo dia ta varivuvu, dia keteni vaigege kamana, na goloa luba, ");
INSERT INTO wiv_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","dia ka parakilania dia kata katia ni tania polea katiu kua e dangea dia kata koto kirina vona. ");
INSERT INTO wiv_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Kilaka ve, na kabuna manumanu luba matoto, dia tausen, tausen luba dia ta mai lupu, kubarae dia kene varidigi, dia ka vavaka taduria kabeni ruadia. A Iesus ia muga pole kamana kana disaipel kamahi, ki tania, “Miu lohoimiu na yis ke vuni Parisi, na kadia mogepa vairukua na lotua. ");
INSERT INTO wiv_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Beta goloa katiu kua e kari havuta, kena beta kete bele kakava, o litigianga kena beta kete lalanga. ");
INSERT INTO wiv_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Nazia miu ta tania na rodo da e longora na dama, nazia miu ta tani rogorogonia na poloka ruma, ia da e goe vonanga na huduna ruma kamahi ki tani kavakavanga. ");
INSERT INTO wiv_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ta tania ni miu, habu kagu, taua miu na kuahinia kaka, kua kete hubi matehimiu, muri vona ki beta ni nap kete katia goloa katiu ve. ");
INSERT INTO wiv_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Palaka kata vatunga azei kua miu kata kuahinia. Miu kuahinia a Vuvu. Kua tani hubi mateho, ia kana matuhanga vona kua kete varagaho ve kara hel. E limoha, ta tania ni miu, miu kuahinia. ");
INSERT INTO wiv_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Karae, beta na hila lima ni salianga kara toea rua? Palaka beta katiu ni dia a Vuvu ni lohoi bala. ");
INSERT INTO wiv_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Matoto, a Vuvu kava ti hazenia vulukumiu laveve na bakamiu. Taua miu na kuahi. Miu ta dopa hizanga na hila kamahi. ");
INSERT INTO wiv_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Hau ta tania ni miu, azei ho tu tani kakava habuka tu lalau na matana manumanu. Na Tuna Kaka ve da e tani kakava habuka ia ve e lalaho na matana engel kamahi ke Vuvu. ");
INSERT INTO wiv_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Kua kaka katiu kini pole katiau kini tania beta ni lalau na matana manumanu, da ia ve beta kete hada lalanga na matana engel kamahi ke Vuvu. ");
INSERT INTO wiv_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Azei ho tu pole zaha kara Tuna Kaka, da e lohoi balanga ka manaunaua, palaka azei ho tu pole zaha kara galanga kana Vule Tumonga mara beta matoto a Vuvu ni lohoi bala ka manaunaua. ");
INSERT INTO wiv_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Tani peola miu vano kara kadia haus lotu ke vuni Iuda kamahi, o ni vano na matana kadia gavman, o na nuhu kua dia ta hahada ni dia. Taua miu na lohoi tori polea zia miu kata koli zingania kadia polea o polea zia miu kata tania. ");
INSERT INTO wiv_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Na taem kena na Vule Tumonga da e vaketehimiu na polea zia kua miu kata tania.” ");
INSERT INTO wiv_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Kaka katiu na pidaka kabuna manumanu e tania ni Iesus, “Tisa, tania ni tazigu ni pahi valahia goloaloa kua a tamamiro ti mate kini vatia kamiro.” ");
INSERT INTO wiv_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","A Iesus ki kolia ki tania, “E ho, azei e makiau kata kara kamo jas o kata pahi valahia kamo goloaloa?” ");
INSERT INTO wiv_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Pale, a Iesus ia tani barae ni dia, “Miu lohoimiu! Miu lohoia tabarae miu na mata parania goloa luba. Ia vata kua ni ka goloaloa ni luba matoto, ia mara beta nu kadea a Vuvu ni katia nu mia ni havarau ri na garigari.” ");
INSERT INTO wiv_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Pale, a Iesus ia barikikinia polea kua ki tani barae, “Haninga na vanua hana risman katiu e bele papa matoto. ");
INSERT INTO wiv_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Na risman kua ia lohoihoi, ‘Nazia matoto kata katia? Beta palaka kata tapia hagu haninga vona.’ ");
INSERT INTO wiv_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Pale, na risman kua ia tani barae, ‘Kata kuza barae. Kata robea kagu rumaka haninga kamahi na habahaba ruma kapopou dopa ni dia. Hau na lupunia hagu harana vit laveve kamana kagu goloa laveve na poloka. ");
INSERT INTO wiv_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Da muri hau ta tani barae kiriniau mule, “Ka goloaloa luba tu tapi lupunia ki dangea kete ngoro krismas luba matoto, kata hivu za, na hanihani, ka hihinu, na hilohilo na kagu mianga.” ’ ");
INSERT INTO wiv_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Palaka da a Vuvu e tania kirina, ‘Tu longolongo matoto! Meni na marigo kua za, da tu mate. Pale, azei da ti papa na goloaloa laveve tu tatapi lupunia?’ ");
INSERT INTO wiv_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Maki kua da e bele barae kara kaka kua e tatapi lupunia kana goloaloa luba ri na garigari, palaka na matani Vuvu ia beta matoto kana goloa vona.” ");
INSERT INTO wiv_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","A Iesus ia tani barae na kana disaipel kamahi, “Kubarae ka tania ni miu, taua miu na lohoi tori na kamiu mianga, nazia miu kata hania, o lohoi na livuhamiu, o nazia miu kata zohoria. ");
INSERT INTO wiv_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Haninga za beta ni dangea kete vala mianga pa, zohozohoa mara beta ni dangea ve kete vala mianga pa. ");
INSERT INTO wiv_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Miu hada na kokoa kamahi. Beta dia na lala dia kata vavazo o pelea haninga na vanua. Beta kadia rum kara haninga o rumaka haninga, palaka a Vuvu ia e vavanganidia. Palaka miu ta dopa matoto na manu kamahi. ");
INSERT INTO wiv_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Azei ni miu kua e lala kete lohoi vuvu, e dangea kete vaherea kana dama na matea? ");
INSERT INTO wiv_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Kua tani beta nu dangea koto katia goloa kote mata barae. E kuziha ku lolohoi vuvu na goloaloa kamahi? ");
INSERT INTO wiv_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Miu hada vutuhia na lili kamahi kua dia ta galulu ziha. Beta dia na lala dia kata gagala o katia lavalava. Palaka ta tania ni miu, a Solomon kamana kana goloaloa mata mulimuli, beta kana zohozohoa katiu ni mata muli livutia na lili kamahi kua. ");
INSERT INTO wiv_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Kua a Vuvu ni lala kete vazoho baraenia raburabu bukuna bira, kua meni e mamadi, vaila ia kiriva kini varaganga kara haroho, pele, miu nuhu kua beta kamiu bilip ni kapou, miu ta lohoia mara beta a Vuvu ni vazoho baraenimiu ve? ");
INSERT INTO wiv_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Tabarae miu na taruhia magalimiu na nazia miu kata hania o hinumia. Taua miu na lohoi vuvu vona. ");
INSERT INTO wiv_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Na vuna manumanu kua beta dia na lala a Vuvu ri na garigari, dia ta lala dia kata rorovo muria goloaloa kamahi kena. Tamamiu ia kava ti lala e ma kete kamiu goloaloa kamahi kena vona. ");
INSERT INTO wiv_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Palaka miu muga kaze kara kana kingdom, ia ni vala goloa laveve kua ni miu ve. ");
INSERT INTO wiv_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Taua miu na kuahi, kabuna sipsip kote, na vuna, Tamamiu kava ti tania kete vala kana kingdom ni miu. ");
INSERT INTO wiv_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Miu salinia kamiu goloaloa laveve miu na vala monina na nuhu kua beta kadia goloaloa vona, kamiu hanpaus na lagato kete vonu na dama laveve. Hanpaus na lagato mara beta ni tere. Kaka mata vanaho ve mara beta ni mai kozoho vona, mai ve mara beta tumelu ni vairohia. ");
INSERT INTO wiv_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Na vuna, ta ka goloa mata muli ni ngoro ni ve, ia magali ve da e ngoro ra kena. ");
INSERT INTO wiv_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Miu zohozoho papa kara galanga, miu na dohotia kamiu lam ni ma kalakala, ");
INSERT INTO wiv_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","balika manumanu kua dia ta guguru kara kadia tubu kete vamule na hanihania kapou kara lahia, kua ia kete mai ni hubia doa, dia na vukazi tapunia doa kirina. ");
INSERT INTO wiv_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Da e kemi kana nuhuta galanga kua kadia tubu e mai ki paria, dia ta ba hahada. Ta tani matotonia ni miu, da e loholoho papa kete vanganidia, da e geridia, dia ka mia na tebol, ki mai vanganidia. ");
INSERT INTO wiv_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Da e kemi kana nuhuta galanga kena, ta kadia tubu ni vamule na varivalavala o na toha ti kakareko boto katiu, ni paridia dia ta ba guguria. ");
INSERT INTO wiv_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Palaka miu lohoi lala goloa kua: Ta tauana ruma ni lala matotonia na aua kena na mata vanaho kete mai vona, mara beta ni vatia kana ruma ni hutu valaha ni hoho voa vona. ");
INSERT INTO wiv_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Miu ve da miu ta tare, na vuna zia Tuna Kaka da e mai na dama katiu kena beta miu na lohoia ia kete mai vona.” ");
INSERT INTO wiv_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","A Pita ki hule, “Paraha, tu barikikinia polea kena kirihita za, beu kara manumanu laveve?” ");
INSERT INTO wiv_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Na Paraha ki tania, “Meneja kakei kua kana lohoihoia e kemi ki lala kete vaka maroro voa vona. Kua kana tubu kini makia kete hada na manumanu na galanga ni vazenia hadia haninga? ");
INSERT INTO wiv_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Da e kemi matoto kana vora kena, kua kana tubu ni vamule ni paria e kakatia kana galanga. ");
INSERT INTO wiv_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ta tani matotonia ni miu, da e taruha ki hada poto na goloaloa laveve kana Tubu. ");
INSERT INTO wiv_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Palaka ta vora kua ni lohoia ni tani mulehia vona, ‘Kagu tubu ti havarau marata ki beta kete mai tapu.’ Pale, ia vaihubi voravora tamomohane, ia mai voravora tavivine ve. Pale, kini hanihani marata kini hihinu kini sipak. ");
INSERT INTO wiv_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Na Tubu kana vora kua da ti mai na dama katiu kua beta na vora kua ni lohoia ia kete bele vona, na aua kua ia beta ni lala. Da Tubu kua e vairohia matoto, ki varaga ia kara palaka kana nuhu kua beta dia na bilip ni Vuvu. ");
INSERT INTO wiv_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Na vora kua kava ti lala na lohoihoia kana, kana Tubu ki beta ni tatare kirina, mai ve ki beta ni katia nazia kua kana tubu e tania kete katia, da e vihu maratanga matoto. ");
INSERT INTO wiv_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Palaka azei kua beta ni lala na lohoihoia kana, kana paraha, ki katia moge kua e dangea kete hubu maratanga vona, mara beta ni vihu maratanga. Manumanu laveve kua a Vuvu e vala goloa luba ni dia, ia da e hule mulehidia kara goloa luba. Kaka kua a Vuvu e vala goloa luba vona kete hada poto vona, ia da e huleni mulehia kara goloa luba.” ");
INSERT INTO wiv_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","A Iesus ki tani barae ve, “Hau ta ziho kata varaga haroho kara vulovulo, ki kuligu matoto ma kete kalakala kua. ");
INSERT INTO wiv_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Palaka kagu baptais katiu ba vovona kata hoho vona, ma beta na hoho vona kua magaligu ki zobo matoto! ");
INSERT INTO wiv_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Miu ta lohoia ta ziho na garigari kata katia manumanu dia na magali katiu? Beta, ta tania ni miu, na vuna ni niau, manumanu da dia ta varipe vulavulahi. ");
INSERT INTO wiv_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kua meni kua ki vano, kua ni dia lima vona na famili katiu, dia ta mimia na ruma katiu, da dia ta varipe vulavulahi, dia tolu da dia ta zaha kirihiro rua, hiro rua, da hiro ta zaha kiridia tolu. ");
INSERT INTO wiv_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Da dia ta varipe vulavulahi. Tamadia da e zaha kiri tuna tamohane, tuna tamohane da e zaha kiri tamana. Titinadia da e zaha kiri tuna tavine, tuna tavine, da e zaha kiri titinana. Titinana tamohane katiu, da e zaha kiri ravana tavine, goni tuna. Goni tuna da e zaha kiri ravana ve.” ");
INSERT INTO wiv_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","A Iesus ki tania kara kabuna manumanu, “Miu kene hadavia mariaba halohaloa ti madi na palaka kena na voro e zuzugu vona, da miu ta tani lala habuka, ‘Da huza kua,’ Pale, matoto za ia da e huza. ");
INSERT INTO wiv_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Miu ta hadavia kavili e pe na Saut ki mai, miu ka tania, ‘Da e banuranga malala,’ ia da e mahoto habuka kena miu ta tania! ");
INSERT INTO wiv_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Miu nuhuta vairukua na lotua miu! Miu ta lala miu kata hada lala miu na tani mahotovia nazia kua e bebele na garigari kamana mariaba. Palaka, e kuziha ki beta miu na dangea miu kata hada lala miu na tani lala nazia kua e bebele na tauna kua? ");
INSERT INTO wiv_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","E kuziha ki beta miu na dangea miu kata sikelni kemikemihia nazia kua e mahoto? ");
INSERT INTO wiv_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Kua kunu vavana vano kamana kaka kua kete koto kiriniho na magistret, parakilania matuha koto vahotovia polea kamana na dala. Tani harehiho vano valaho na jas, jas ni valaho vano na polis, polis ni varagaho kara karabus. ");
INSERT INTO wiv_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Hau ta tania ni niho, da tu ma mia na poloka karabus ia, ia ku vala hozovia moni kena e tanga koto vala.” ");
INSERT INTO wiv_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Kilangata kena manumanu taza, dia ta ziuziu ke Iesus ni vuni Galili taza dia ta kakatia opa, a Pailat ki geria kana soldia kamahi dia ka hubi matehidia, topodia ki taru lupuanga kamana kadia opa. ");
INSERT INTO wiv_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","A Iesus e kolia ki hule, “Miu ta lohoia a vuni Galili kena e hubi matoa dia barae, dia ta dopa dia ka kaka zaha na habu tamaninikidia bukuni Galili? ");
INSERT INTO wiv_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ta tania ni miu, betaka! Palaka kua tani beta miu na pokizia magalimiu, miu na vala lamamiu kara moge zahazaha, miu laveve da miu ta mate barae ve. ");
INSERT INTO wiv_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Beu nuhu 18 kena na taua horaha ni Siloam ni Ierusalem, e tua havutidia, dia ka mate. Ia miu ta lohoia miu ka tania dia ta dopa dia ka kaka zaha na nuhu kua dia ta lololi ni Ierusalem? ");
INSERT INTO wiv_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ta tania ni miu, betaka! Palaka ta beta miu na pokizia magalimiu, miu na vala lamamiu kara moge zahazaha, miu laveve da miu ta mate barae ve.” ");
INSERT INTO wiv_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Pale, ia barikikinia polea kua ki tania, “Kaka katiu e vazohia hana haina fik na poloka vanua na vaen. Boto katiu ia vano kete dulea paleka, palaka beta ni paria paleka katiu. ");
INSERT INTO wiv_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Kubarae ia tania na kaka e hada poto na hana vanua na vaen, ‘Krismas ti tolu te mai kakaze kara palekana hai kua, ki beta na paparia katiu. Huravia ni tua! Kara zia ki vahozovia gris na garigari?’ ");
INSERT INTO wiv_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Na kaka e hada poto na vanua e kolia ki tania, ‘Paraha, vatia ni madi krismas katiu ve, kata hovi lobia na taruhia fertalaisa vona. ");
INSERT INTO wiv_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Kini taruhia palekangana na krismas ruana, kemi matoto! Kini betaka, pale ho tu huravia.’” ");
INSERT INTO wiv_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Na Sabat a Iesus e vaketekete na poloka haus lotu katiu ke vuni Iuda. ");
INSERT INTO wiv_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Kilangata kua, tavine katiu kamadia na haus lotu ke vuni Iuda kua, na vule zaha e katia kini mazahitia na krismas ti 18, lamana kini makilo kini tulu rogorogo, ki mara beta matoto ni madi mahoto. ");
INSERT INTO wiv_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Kamana a Iesus ki hada na tavine kua, ia kohania mai vona ki tania vona, “Vine, te pele kakava ka mazahi kava ni niho.” ");
INSERT INTO wiv_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Pale, a Iesus ia taruhia limana na huduna, kilaka pamuhi na tavine kua ia madi mahoto, kini vazahenia hizani Vuvu. ");
INSERT INTO wiv_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Na paraha kara haus lotu ke vuni Iuda magalina e varitihi kiri Iesus kua ti kati kemihia tavine kua na Sabat. Ia ki tani barae kara manumanu, “Dama e 6 kara galanga. Miu mai na dama kamahi kena ni katu kemuha miu. Beta ni na Sabat.” ");
INSERT INTO wiv_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","A Iesus ia kolia vona ki tania, “Miu ta nuhuta vairukua na lotua! Miu laveve kua beta miu na lala miu kata hulia miu na pelea kamiu bulmakau, kamana donki ni gotala na kadia palakana ngoroa, miu na pelea vano kara palaka naru vona dia kata hinu naru na Sabat? ");
INSERT INTO wiv_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Pele, na tavine kua, ia na tuni Abraham, kua a Satan ti paho taduria na krismas ti 18, karae mara beta ni hulua ia na limani Satan na Sabat?” ");
INSERT INTO wiv_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Kamana ki tani barae, hana vagi kamahi, dia ta puae matoto, palaka manumanu laveve na poloka haus lotu ke vuni Iuda kua, dia ta hilohilo matoto na goloa kemikemi laveve e kakatia. ");
INSERT INTO wiv_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Pale, a Iesus ia hule, “Na kingdom ke Vuvu e balika zia? Nazia da ta vatunga muria vona? ");
INSERT INTO wiv_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Na kingdom ke Vuvu e balika harana hai kua e kohanga na hamo, kena na kaka e pelea ki vazohia na hana vanua. Pale, ia paraha kini kara hai kapou na manu kamahi dia ta mai bale na dangadangana.” ");
INSERT INTO wiv_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ia hule ve, “Nazia da ta vatunga muria na kingdom ke Vuvu vona? ");
INSERT INTO wiv_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Na kingdom ke Vuvu e balika yis. Kua na tavine e taruhia ki kamo pokizia kamana baket na plaua tolu kete katia ni kudu.” ");
INSERT INTO wiv_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Pale, a Iesus ia vana hoho na taon kamana malala kamahi ki vaketekete ki vavano kiri Ierusalem. ");
INSERT INTO wiv_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Kaka katiu e hulenia, “Paraha, da manumanu taza za kena a Vuvu kete pele mulehidia?” Ia tania ni dia, ");
INSERT INTO wiv_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Miu badabada, miu kata hoho na doa kote, na vuna zia, manumanu luba, ta tania ni miu, da dia ta parakilania dia kata hoho, palaka da dia ta lokia. ");
INSERT INTO wiv_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ta tauana ruma ni divurutia ni tabaria doa, da miu ta madi na hatama, miu ka hubia doa, miu ka koi, ‘Paraha, vukazia doa kirihita!’ Palaka da ia kolia ki tania, ‘Beta na lalamiu, miu ta bukuni ve.’ ");
INSERT INTO wiv_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Da miu ta tania, ‘Hita ta lala hita kata hanihani, hita ka hihinu kamaniho, ho tu madi na kahita dala kamahi ku vaketekete!’ ");
INSERT INTO wiv_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Palaka da ia e kolia ki tania, ‘Beta na lalamiu, miu ta bukuni ve. Miu kakava ni niau, miu ta nuhuta moge zahazaha!’ ");
INSERT INTO wiv_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Palaka da miu te hahaloho, hazemiu kini vuluhero kua miu te hada a Abraham, a Aisak, mai a Jekop kamana profet laveve na poloka kingdom ke Vuvu, palaka miu, da ti varaga gotalanga miu. ");
INSERT INTO wiv_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Manumanu da dia ta pe ni Ist, pe ni Wes, pe ni Not ia mai pe ni Saut dia ka pelea kadia palaka na hanihania kapou na poloka kingdom ke Vuvu. ");
INSERT INTO wiv_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Miu longoria, nuhu kua dia ta muri da dia ta vamuga, nuhu kua dia ta vamuga da dia ta muri matoto.” ");
INSERT INTO wiv_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Kilaka kena na Parisi taza dia ta mai ni Iesus dia ta tania vona, “Vatia palaka kua nu vano kara palaka motu, na vuna a Herot e tania kete hubi mateho.” ");
INSERT INTO wiv_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ia kolia ni dia ki tania, “Miu vano tania na kaua tegitegi kena, ‘Hau da ta pele kakava vule zaha kamahi, ka kati kemihia manumanu kua e mazahitidia meni ki vano ki vaila, pale, na dama toluna da hau te vahozovia kagu galanga.’ ");
INSERT INTO wiv_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Palaka, meni, vaila, vaila taua dama da hau ta ma vavana ka vavano; matoto, beta ni mahoto na profet kete mate na palaka motu, da e mate za ni Ierusalem! ");
INSERT INTO wiv_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","O Ierusalem, Ierusalem, ho kua tu lala koto hubi matehia na profet kamahi ku lubi matehia na kedo nuhu e geura dia kata mai ni niho. Ti boto ziva hau te parakilania kata lupunia habu tutu dia na lupu, balika titinana toha kua e lupunia habu tutuna na tauri banita, palaka beta ni kulimiu! ");
INSERT INTO wiv_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Longoria, ba muri da miu ta bura tapunia kamiu malala ki ngoro veta. Hau ta tania ni miu, beta miu kata hadaviau ve ki vano ki mule na dama miu ka tania, ‘A Vuvu da e kati kemihia matoto na kaka kua e mamai na hizana Paraha.’” ");
INSERT INTO wiv_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Dama katiu na Sabat a Iesus e vano kete hanihani na ruma kana paraha ke vuni Parisi katiu. Manumanu laveve vona dia ta ma taruhia matadia vona dia kata hada nazia kete katia. ");
INSERT INTO wiv_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Kaka katiu e mai na mugani Iesus na poloka ruma kena, e hatunia varitihia na mazahi kena e katia kabena kamana limana ki vatavata. ");
INSERT INTO wiv_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","A Iesus ia hulenia na tisa kamahi kara lo kamana Parisi kamahi, “E kemi tolu kata kati kemihia kaka e mazahitia na Sabat o beu?” ");
INSERT INTO wiv_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Palaka beta dia na makulu. Pale, ia pahoria kaka kua, kini kati kemia ia geria kini vano. ");
INSERT INTO wiv_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Pale, ia hulenidia, “Ta katiu ni miu, kua tuna tamohane beu kana bulmakau ni dua hoho kara poloka lovo na Sabat, mara beta kilaka kena za nu harehi mulehia ni gotala?” ");
INSERT INTO wiv_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Palaka beta polea dia kata tania dia na kolia kana hulea vona. ");
INSERT INTO wiv_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Kamana ki hadavia nuhu kua dia ta belebele kara hanihania dia te hada palipali kara palaka kena ke pararaha na tebol, ia barikikinia polea kua ki tania, ");
INSERT INTO wiv_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Ta kaka katiu ni kohaniho koto vano kara hanihania kapou na lahia, taua nu hada palipali kara mianga ni muga, tabarae kaka katiu e dopa ki hizanga ni niho ni kohanga ve kete mai. ");
INSERT INTO wiv_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Pale, da kaka kena e kohanimo, mo ka mai, tani tania ni niho, ‘Vala ka mianga na kaka kena!’ Pale, da ho tu puae kua koto nu vahere ziho nu pelea mianga ni muri matoto. ");
INSERT INTO wiv_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Palaka tani kohanga ho kara hanihania kapou katiu, pelea mianga ni muri, ta tauana hanihania ni mai, da ti tania ni niho, ‘E ho, vahere zahe nu pelea mianga pa na mugana!’ Pale, da tu hada zaheanga na matana nuhu laveve kena miu ta lohulohu lupu kara hanihania. ");
INSERT INTO wiv_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Manumanu laveve kua dia ta vazaheni mulehidia, da dia ta vazihoanga. Azei ho tu vazihoni mulehiho, da tu vazaheanga.” ");
INSERT INTO wiv_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Pale, a Iesus ia tania na tauana haninga kapou kua, “Kunu katia hanihania kapou, taua nu kohania habu kurakura, habu tazi, habu vineke, nuhu kozohozoho ni niho kua kadia goloaloa e luba. Tabarae ba muri dia ve na kohaniho kara kadia hanihania katiu dia ta koli mulehia ha haninga. ");
INSERT INTO wiv_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Kunu katia hanihania, kohania nuhu kua beta kadia goloaloa vona, nuhu kua limadia beu kabedia e zaha, nuhu kua livuhadia e matemate, ia mai nuhu kua matadia e keu, ");
INSERT INTO wiv_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","pale, a Vuvu da ti kati kemihia niho. Mara beta dia na koli mulehia ha haninga, da a Vuvu e koli mulehia ni niho, na dama kena nuhu kua kadia vavananga e mahoto, dia te mahuri mule na matea.” ");
INSERT INTO wiv_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Kaka katiu ni dia kena e mimia kamana na tebol e longo baraenia, ia tania ni Iesus, “A Vuvu da e kati kemihia matoto na nuhu kua dia kata hanihani na hanihania kapou na poloka kingdom ke Vuvu.” ");
INSERT INTO wiv_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","A Iesus ki tania vona, “Kaka katiu e katia hanihania kapou, ki vinohu kara manumanu luba dia kata bele. ");
INSERT INTO wiv_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Na damana hanihania kapou, ia e geria kana vora kete vano tania na nuhu kua e vinohu kirua dia, dia kata bele na hanihania, ni tania ni dia, ‘Miu mai, goloaloa laveve kava ti malimu!’ ");
INSERT INTO wiv_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Palaka dia laveve dia ta vata poroporo, beta dia kata vano. Kaka katiu e muga ki tania, ‘Ta ba kadea na garigari pitu, ka lohoia kata vano na hadavia. Tu hate motu, mara beta na mai!’ ");
INSERT INTO wiv_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ruana ve e tania, ‘Hau ta ba kadea kagu bulmakau kara galanga e 10, kata vano parakilanidia. Tu hate motu, mara beta na mai!’ ");
INSERT INTO wiv_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Tolu hiro ve e tania, ‘Hau ta ba lahi, ki mara beta na mai!’ ");
INSERT INTO wiv_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Na vora kua e vano mule ia tania polealea kua na kana tubu. Na tauana ruma magalina e halavidi matoto, pale, ia tani vatuharia polea na kana vora kamahi, ki tania ni dia, ‘Miu vano kara poloka taon, na daladala kotekote na dala kapopou na taon, miu ta kohania nuhu kua beta kadia goloaloa vona, nuhu kua kabedia kamana limadia e zahazaha, nuhu kua livuhadia e matemate, nuhu kua matadia e keukeu, miu na peledia, dia na mai!’ ");
INSERT INTO wiv_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Kana vora ki tania, ‘Paraha nazia tu tania kava ti katua, palaka zeleka ba vovona!’ ");
INSERT INTO wiv_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Kana tubu ia geri mulehia ve, ‘Vano gotala na taon, nu vano lilia dala kapou kamana hiripa dala kotekote nu madi na lamana manumanu nu peledia na mai hoho, na vuna kagu ruma kete vonu. ");
INSERT INTO wiv_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Hau ta tania ni miu, da beta katiu ni dia kua e vinohuanga dia kata mai kete naminia hagu haninga pitu.’” ");
INSERT INTO wiv_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Manumanu luba dia ta vavana kamani Iesus, ia tare poki kiridia ki tania, ");
INSERT INTO wiv_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ta kaka katiu ni mai ni muri ni niau, ni beta ni vala lamana kiri tinana kamani tamana, gona kamani habu tutuna, habu tazina kamani habu livuka, ia mai ve kirina mule, kaka kena mara beta ni kara kagu disaipel. ");
INSERT INTO wiv_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Azei ta beta ni luga kana kruse ni muri ni niau, mara beta ni kara kagu disaipel. ");
INSERT INTO wiv_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ta katiu ni miu ni kulina kete habatia na taua horaha katiu. Karae, mara beta ni muga ni mia tadu ni lohoi nanazia, ziva matoto da e varaga kirina, ia mai ki hadavia ve kana moni e dangea kete habatia ni vahozovia? ");
INSERT INTO wiv_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Na vuna, tani taruhia faundesion, ni beta ni dangea keteni vahozovia, manumanu da dia na hada baraenia, dia ta pole taduria. ");
INSERT INTO wiv_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Da dia ta tania, ‘Kaka kua, e varivuvunia kete habatia kana taua kini lokia keteni vahozovia.’ ");
INSERT INTO wiv_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","O ta king katiu kua ni kulina kete vano ni varihubi kamana king motu katiu, karae mara beta ni muga mia tadu ni hada vutuhia, karae da e dibala ruana king kena, kua ta ia ni mai kamana 20,000 kete varihubi kamana kana 10,000 manumanu? ");
INSERT INTO wiv_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Kua tani mara beta, da e geria kaka katiu kete kara havana ni parakilania ni tania na ruana king motu kena, kua ta ia ni ba zazau, dia kata paria dala katiu dia kata katia kete beta dia kata varihubi. ");
INSERT INTO wiv_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ia e vinaka za, azei ni miu kua ta beta ni vala lamana kara kana goloaloa laveve, ia mara beta ni kara kagu disaipel. ");
INSERT INTO wiv_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Sol e kemi, palaka kua milokana ni hozo, da e kati zinganga ki pele mulehia milokana? ");
INSERT INTO wiv_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Mara beta ni taruha na garigari na vanua o kamana tahena bulmakau, da e varaga tapuanga. Azei talingana vona, kete longoria polea kua.” ");
INSERT INTO wiv_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Na nuhuta pelepelea na takis kamana nuhuta moge zahazaha dia ta mai madi lobia a Iesus dia kata longoria kana polea. ");
INSERT INTO wiv_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Palaka, a vuni Parisi kamana tisa kamahi kara lo dia ta pole ngungu kirina dia ka tania, “Kaka kua e kabukabu kamana nuhuta moge zahazaha ki hanihani kamadia.” ");
INSERT INTO wiv_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Pale, a Iesus ia barikikinia polea kua, ki tania, ");
INSERT INTO wiv_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Kua katiu ni miu kana sipsip ni 100. Ku ni vano katiu ni dia ia golu. Mara beta ni vatia dia 99 kena, dia na hanihani na palaka kena, ni kaze kara katiu kena ti golu, ia ia ni paria? ");
INSERT INTO wiv_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Kua tani paria da e hilohilo matoto ki luga na lohora, ");
INSERT INTO wiv_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","kini vano kara kana ruma. E lohu, ia e koi lupunia habu tamaninika kamana nuhu kua dia ta mia kozoho vona, ki tania ni dia, ‘Miu hilohilo kamaniau. Hau te pari mulehia kagu sipsip kua e golu!’ ");
INSERT INTO wiv_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Hau ta tania ni miu, da ia vinaka za. Da hilohiloa kapou na lagato na kaka zaha katiu kua e vala lamana kara moge zahazaha dopa na nuhu kena 99 kena dia te lohoia dia te mahoto, ki beta ve dia kata pokizia magalidia.” ");
INSERT INTO wiv_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Ta tavine katiu ni kana 1,000 Kina vona, 100 Kina katiu ni golu, mara beta ni dohotia lam ni kuvia kana ruma kete kaze papa kirina, ia ia ni paria? ");
INSERT INTO wiv_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Tani paria da e koi lupunia habu tamaninika, ia mai nuhu kadia ruma kena e kozoho vona, ki tania ni dia, ‘Miu hilohilo kamaniau, te pari mulehia kagu moni kua e golu.’ ");
INSERT INTO wiv_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ia e pebarae za, ta tania ni miu, da na engel kamahi ke Vuvu da dia ta hilohilo na kaka zaha katiu kena e pokizia magalina ki vala lamana kara moge zahazaha.” ");
INSERT INTO wiv_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","A Iesus ki tania ve, “Kaka katiu tuna tamohane e rua. ");
INSERT INTO wiv_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Tuna muria e tania ni tamana, ‘Tamagu, vala ni niau dihura ka goloaloa kena tu lohoia koto vala kagu!’ Pale, ia pahi valahia kana goloaloa ia vala ni hiro. ");
INSERT INTO wiv_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Beta ni havarau muri na kua, tuna muria kena e pelea kana goloaloa laveve ia vala na manumanu dia ta kadea. E pelea monina kana goloaloa laveve kua e salinia, kini vavana kara malala zau katiu. Na kana mianga na malala kena, e katia makina habakanga luba na kana moni laveve, ia hozo. ");
INSERT INTO wiv_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Tania ki varaga hozovia kana moni, na vitolo kapou ia bele na palaka laveve na kantri kena. Pale, ia paho kavu ti beta goloa vona. ");
INSERT INTO wiv_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Pale, ia vano hulenia kaka bukuna taon kena katiu kete gala kana. Na kaka kua ia geria vano kara banis na boroboro kete hada poto na kana boroboro. ");
INSERT INTO wiv_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","E vitolonia matoto ki kulina kete hania hulita bin kena na boroboro dia ta hahania, palaka beta ni valanga vona. ");
INSERT INTO wiv_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Kana lohoihoia ti vamule, ia tania, ‘Voravora ke tamagu dia ta hania haninga, dia ka vatia kalangara, kuari hau te mate na vitolo! ");
INSERT INTO wiv_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Kata vamule vano ni tamagu na tania vona, “Tamagu, hau te katia moge zaha na matani Vuvu ia mai ve ni niho. ");
INSERT INTO wiv_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Beta hau na dangea koto ma kohaniau na tu. Katiau na kara ka vora vetanga za.” ’ ");
INSERT INTO wiv_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Pale, ia di madi, ia vamule vano bele ni tamana. Palaka e ba zazau za, tamana ki hadavia lohora ki zaha matoto vona. Ia rovo vano ni tuna, ia tago pulia, ia domia. ");
INSERT INTO wiv_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Tuna ia tania vona, ‘Tamagu, ta katia moge zaha na matani Vuvu mai ve ni niho, ti beta ne dangea koto ma kohaniau na tu.’ ");
INSERT INTO wiv_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Palaka a tamana ia tani barae na kana voravora, ‘Baribari! Miu pelea kagu zohozohoa mata muli kena mai miu na vazohoria vona. Miu taruhia ring na kukuna. Miu ta vazohoria na sadel. ");
INSERT INTO wiv_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Miu pelea na tuna bulmakau buibuia matoto kena ni mai, miu na hubi matea. Tolu kata katia hanihania kapou meni tolu na hilohilo. ");
INSERT INTO wiv_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Na vuna tugu tamohane kua, ti mate kini mahuri mule. Ia ti golu kava kini pari muleha!’ Pale, dia kene katia hanihania kapou. ");
INSERT INTO wiv_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Kilaka kena na tazina muganga ia na poloka vanua. Tania e ziho kozoho na ruma, ia longoria halingana gita kamana paraua. ");
INSERT INTO wiv_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ia kohania na vora ke tamana katiu ki hulenia, ‘Nazia e kakatua?’ ");
INSERT INTO wiv_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Na vora kua ki tania, ‘Tazi ti lohu, a kamama kini hubia na tuna bulmakau buibuia katiu, na vuna tazi ti bele mule ni kamama. Beta ni golu.’ ");
INSERT INTO wiv_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Tazina muganga e taroviti matoto ki vanga holuholu kete vano hoho kamadia. Kuza barae tamana ia gotala vona ki bobolia kete hoho kamana. ");
INSERT INTO wiv_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Palaka ia kolia polea ke tamana ki tania, ‘Longoria! Krismas laveve kua ta gagala veta ka, ki beta matoto na vanga holuholu na ka polea. Beta nu vala na me huluvahu katiu ni niau kata hilohilo kamani habu tamaninikigu! ");
INSERT INTO wiv_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Palaka tania tu kena e vahozovia ka goloaloa kamana ka moni na makina magali buhua kamani tavivine ki vamule mai na ruma, ho tu hubia na tuna bulmakau buibuia kena kete hania!’ ");
INSERT INTO wiv_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","A tamana ki tania, ‘Tugu, ho tu mimia kamaniau dama laveve, goloaloa laveve kagu ia ka. ");
INSERT INTO wiv_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Palaka kua, tolu kata hilohilo tolu na hanihani, na vuna tazi kua ia ti mate kava palaka kua ti mahuri mule, e golu muga palaka kua ti pari muleha.’” ");
INSERT INTO wiv_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","A Iesus ki tani barae na kana disaipel kamahi, “Na risman katiu, e taruhia na meneja katiu kete hada poto na kana goloaloa. Palaka nuhu taza dia ta koto kara meneja kua na risman kua, dia ka tania, e beta ni hada poto papa ki varaga vetania kana goloaloa. ");
INSERT INTO wiv_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Na risman kua e kohania na kana meneja ki mai ia hulenia, ‘Nazia kua ta longoria e tatanga kirua ho? Vala ka pepana ripot na ka galangana hada potopotoa mai na hadavia, na vuna da beta koto ma kara kagu meneja!’ ");
INSERT INTO wiv_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Na meneja kua e lohoihoi, ‘Nazia da ta katia kua? Kagu tubu keteni pele kakavau na kagu galanga. Beta na matuha na dangea kata hovia garigari, ta puae ve kata varinongu. ");
INSERT INTO wiv_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Palaka te lala nazia kua kata katia kua tani pele kakavanga hau na kagu galanga ri, manumanu dia kata koi taduriau na kadia rumaruma!’ ");
INSERT INTO wiv_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Pale, ia kohania nuhu kua kadia dinau vona na kana tubu. Ia hulenia katiu muga, ‘E ziva matoto ka dinau na kagu tubu?’ ");
INSERT INTO wiv_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Na kaka kua ia tania, ‘Na dram vel e 100.’ Meneja kua ia tania vona, ‘Ia, pelea ka pepana ka dinau, ho tu vapolungania 50 dram vel tu pelea!’ ");
INSERT INTO wiv_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Muri ia hulenia kaka ruana, ‘E ziva ho tu dinau vona?’ Ia tania, ‘Ta pelea bekena vit e 100.’ Na meneja kua ia tania vona, ‘Ia, pelea ka pepa na ka dinau nu vapolungania tu pelea 80 za bekena vit.’ ");
INSERT INTO wiv_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Na paraha kua e vazahenia kana meneja mata vairukuruku kua na vuna meneja kua ti lohoi papa. Na vuna, manumanu bukuna garigari ri dia ta dopa dia ka lohoi papa kua dia na lohoia dia kata rukia ruadia katiu bukuna garigari. Dopa na nuhu kua dia ta mimia na laet. ");
INSERT INTO wiv_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Hau ta tania ni miu, miu katia pren na kamiu goloaloa kemikemi bukuna garigari. Ba muri ti vano kamiu goloaloa ti hozo, miu kene mate, miu ta kohanga vano kara malalara mahuri roroa. ");
INSERT INTO wiv_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Azei tani vaka maroro vonanga vona kete hada poto na goloa kote, da e vaka maroro voa vona kete hada poto ve na goloaloa kapopou, azei kua tani mata vairukuruku na goloa kotekote da e vairuku ve na goloa kapopou. ");
INSERT INTO wiv_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ta ho tani beta ni vaka maroro voa ni niho koto hada poto na goloaloa kemikemi bukuna garigari, da a Vuvu ve e beta kete vaka maroro ve ni niho kamana goloaloa kemikemi bukuna lagato. ");
INSERT INTO wiv_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Tani beta ni vaka maroro voa ni niho, koto hada poto papa na goloaloa kana kaka motu, da e vaka maroro ziha voa ni niho ki valanga ka goloaloa mule? ");
INSERT INTO wiv_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Beta vora katiu ni dangea kete gala na tubu rua. Da beta kete kulina kara katiu, palaka ki kulina kara ruana, o da e longoria polea kana katiu ki vala lamana kara ruana. Mara beta nu vora ni Vuvu kamani Mammon, vuvu kara moni.” ");
INSERT INTO wiv_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","A vuni Parisi, nuhu kua e kulidia marata kara moni dia ta longoria polea laveve kua a Iesus e tania, dia ta pole habakabaka kirina. ");
INSERT INTO wiv_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","A Iesus ia tania ni dia, “Miu ia manumanu kua, kua e kulimiu manumanu dia kata tania miu nuhu kua miu ta kakatia moge pa za. Palaka a Vuvu e lala magalimiu. Nazia kua manumanu dia ta hada dia ka tania ia goloa matoto, ia a Vuvu e hada ki tania e mavuru matoto. ");
INSERT INTO wiv_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Na polea kamahi na lo kamana polea kana profet kamahi e tani kakavanga ki vano ki mule na taem a Jon ti bele. Pale, muri na kena, na Kalohua Kemi na kingdom ke Vuvu ti tatani kakavanga, manumanu laveve dia ka vavaridi matoto, dia kata hoho vona. ");
INSERT INTO wiv_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","E malimu matoto na lagato kamana garigari kete balavutuka, palaka mara beta matoto na dihura polea pitu na poloka lo ke Vuvu ni golu. ");
INSERT INTO wiv_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Azei kua tani vamia tapunia gona ni kabania tavine motu, ia e katia makina magali buhua, tamohane azei kua tani kabania tavine kua e vamia tapuanga, ia e katia makina magali buhua. ");
INSERT INTO wiv_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Risman katiu e lala kete lolohoria na loholohoa hada papel kamana lavalava kavukavua mata muli matoto ki katia parti ki hanihani na dama laveve. ");
INSERT INTO wiv_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Kozoho na geit na pe hohoa kara kana ruma, na kaka katiu e vangoroa ki vavarinongu moni kamana haninga. Hizana a Lasarus. Livuhana e mukumukua. ");
INSERT INTO wiv_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ki kukulina ma kete vanganga pitu na momota haninga kua e huhuru na tebol kana risman kua. Kauaua dia ta mai ve dia ka dadamea mukuna kamahi. ");
INSERT INTO wiv_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Boto katiu, na kaka mata varinongunongu kua ia mate na engel kamahi ke Vuvu dia ta mai luga zahe kara kitaki Abraham. Na risman kua, ia ve mate kini tavuanga. ");
INSERT INTO wiv_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Na poloka hel, e hatunia varitihia kapou matoto vona, e hada vatada, ia hada a Abraham e zau matoto kamani Lasarus na kitaka. ");
INSERT INTO wiv_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Pale, ia koi kirina ki tania, ‘Tamagu Abraham, mahariau nu geria a Lasarus ni lutia kukuna na naru ni mai taruhia na lavegu ni kalolo pitu, na vuna te hatunia varitihia kapou matoto na poloka haroho kua!’ ");
INSERT INTO wiv_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Palaka a Abraham e kolia ki tania, ‘Tugu, lohoia, kilaka kena tu ba mamahuri, ho tu pelea goloa kemikemi, a Lasarus ia pelea goloa zahazaha. Palaka kua, ia ti katu kemuha vona kini mia papa, e ho kunu hatunia varitihia. ");
INSERT INTO wiv_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ki vano ve, kua na pidaka dolu, na lolona kapou ti taruha kini halaridolu, ki mara beta katiu ri ni dua polo vano ni miu. Mara beta ve katiu ni miu ra ni dua polo ve ni mai ni hita.’ ");
INSERT INTO wiv_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ia kolia ki tania, ‘Pele ta hule haroiniho matoto, Tamagu, geria a Lasarus kara ruma ke tamagu, ");
INSERT INTO wiv_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","na vuna, tazigu e 5. Tania, ni kalohu kadia, tabarae dia ve na mai kara palaka zaha kua ve!’ ");
INSERT INTO wiv_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","A Abraham ki kolia ki tania, ‘A Moses kamana profet kamahi vona. Dia kata longoria kadia polea!’ ");
INSERT INTO wiv_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Na risman kua ki tania, ‘Mara beta tamagu Abraham, palaka kua kaka katiu ni hita kua ti mate, ni vano bele ni dia, da dia ta pokizia magalidia!’ ");
INSERT INTO wiv_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","A Abraham ia tania vona, ‘Ta beta dia na longo kiri Moses kamana profet kamahi, mara beta ve dia na longoria kaka katiu ve, ia vata kua ta ia ni mahuri mule na matea.’” ");
INSERT INTO wiv_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","A Iesus e tania na kana disaipel kamahi, “Goloaloa luba da e bele kete rukia manumanu dia na poke na moge zahazaha. Palaka kaba loho zahanga kara kaka kua e katia moge kua ki bele. ");
INSERT INTO wiv_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","E kemi kete muga rotua kedo kapou na lohora ni vahituva ia na madoro kapou ni mate, tabarae ni katia moge kua ni rukia kapirupiru kara moge zahazaha. ");
INSERT INTO wiv_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Miu lohoimiu. Tazi kini katia moge zaha, pole kirina, kini pokizia kana mogemoge, lohoi bala kana manaunaua. ");
INSERT INTO wiv_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Kua kini kati zahatia ni niho botona 7 na dama katiu, ki lilili kiriniho botona 7 ki ta tania, ‘Tai lohoi bala kagu moge zaha.’ Pele, lohoi bala kana manaunaua.” ");
INSERT INTO wiv_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Na apostel kamahi dia ta tani barae na Paraha, “Katia kahita bilip ni dopa kapou!” ");
INSERT INTO wiv_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","A Iesus ki kolia ki tania ni dia, “Kua kamiu bilip ni gala kote balika harana hamo, miu ta nap miu kata tania na haina Sikamoa kapou, ‘Kuluvuru nu pozi madi na huda dazi.’ Pale, ia da e longoria kamiu polea.” ");
INSERT INTO wiv_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Kua katiu ni miu ni kana vora vona, kua e gagala na vanua o e hahada poto na sipsip kamahi, kua ia ni pe na galanga ni vamule, tu lohoia da e tani barae na kana vora kua, ‘Mai, mai mia nu hanihani?’ ");
INSERT INTO wiv_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Karae mara beta ni tani barae vona, ‘Vano ku matu, ku senis, ho tu hulonia hagu haninga, vaida ku padea ku guriau ka muga hanihani ka hinu, ba muri ho kunu vano hanihani?’ ");
INSERT INTO wiv_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Karae da na tubu kana vora kua e hate motunia na kana galanga? Mara beta! ");
INSERT INTO wiv_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ia miu ve, kua miu kene kati hozovia goloa laveve kua a Vuvu e tania miu kata katia, miu ta tani barae, ‘Hita ta vora vetanga za kua. Hita ta katia kahita galanga za.’” ");
INSERT INTO wiv_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Na vavananga ke Iesus kiri Ierusalem, ia e pe na halara malala na pidaki Samaria kamani Galili. ");
INSERT INTO wiv_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ti kozoho keteni hoho na poloka malala, tamomohane e 10 lepra ni dia, dia ta mai paria na dala. Dia ta madi zau pitu vona. ");
INSERT INTO wiv_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Dia ka goe kapopou matoto dia ka tania, “Iesus, Tubu, maharihita!” ");
INSERT INTO wiv_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Kamana a Iesus ki hadavidia, ia tani barae ni dia, “Miu vano vatunga livuhamiu na pris kamahi.” Tania dia ta ba vavano, kadia mazahi ia kakava na livuhadia. ");
INSERT INTO wiv_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Katiu ni dia tania ki hada na livuhana ti kemi, ia vamule mai, ki goe kapopou ki vazahenia hizani Vuvu. ");
INSERT INTO wiv_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ia dua kara kabeni Iesus ki hate motunia a Iesus. Kaka kua ia e bukuni Samaria. ");
INSERT INTO wiv_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","A Iesus ki hulenia, “Ta lohoia ka tania manumanu e 10 kua dia ta kemi mule. Kue dia taza ve kua 9? ");
INSERT INTO wiv_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","E kuziha, karae ti beta matoto kaka keteni vamule ni vazahenia hizani Vuvu? Kaka kua ia bukuna kabu motu kua!” ");
INSERT INTO wiv_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Pale, a Iesus ia tania vona, “Madi nu vano, ka bilip ti katiho kunu kemi.” ");
INSERT INTO wiv_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Boto katiu a vuni Parisi dia ta hulenia a Iesus, ngiza na kingdom ke Vuvu ki mai. A Iesus e kolia ki tania, “Kua na kingdom ke Vuvu ni mai, mara beta goloa katiu ni bele habuka mak kua na manumanu kete hada papa kirina dia na hadavia. ");
INSERT INTO wiv_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ki mara beta kaka katiu ni tani barae, ‘Hada, kua ia kua,’ o ‘Kuari, ia rae.’ Na vuna na kingdom ke Vuvu ia na polokomiu.” ");
INSERT INTO wiv_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Pale, ia tania na kana disaipel kamahi, “Dama vona kua ti mamai kua da e kukulimiu matoto miu kata hada na dama katiu na dama kamahi kana Tuna Kaka, palaka mara beta miu na hadavia. ");
INSERT INTO wiv_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Da dia ta tania ni miu, ‘Hadavia, kuari ia rae,’ beu ‘kua ia ri.’ Taua miu na rorovo mumuri ni dia. ");
INSERT INTO wiv_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Na vuna na dama kana Tuna Kaka da e bele balika hanimata, ki balanga mariaba laveve na paligena, paligena. ");
INSERT INTO wiv_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Palaka da e muga ki luga bizea kapou, manumanu na tauna kua da dia ta pole katia. ");
INSERT INTO wiv_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Maki kua dia ta katia kilaka na dama ke Noa, ia da dia ta kati baraenia ve na dama kana Tuna Kaka. ");
INSERT INTO wiv_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Manumanu dia ta hanihani, dia ka hihinu, dia ka lalahi, ki zahe ki mule na dama a Noa ki hoho na poloka kana vaga. Pale, na noro e pado ia vairohidia laveve. ");
INSERT INTO wiv_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ia balika na dama ke Lot. Manumanu dia ta hanihani, dia ka hihinu dia ka vavaikado, dia ka salinia goloa, dia ka vavazo haninga, dia ka habahaba ruma. ");
INSERT INTO wiv_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Palaka na dama kena a Lot ki vatia a Sodom na haroho kamana salfa e dua na lagato ziho, ia vairohidia laveve. ");
INSERT INTO wiv_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Da e bele barae ve kua na dama kana Tuna Kaka kete bele. ");
INSERT INTO wiv_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Na dama kena azei e mia na palakana hivua na huduna kana ruma, ni kana goloaloa vona na poloka ruma, taua ni hoho pelea kana goloaloa. Azei ve kena ni gagala na poloka vanua, tabarae ni vamule kara kana ruma kete pelea kana goloa katiu. ");
INSERT INTO wiv_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Miu lohoia nazia kua e bele kiri goni Lot! ");
INSERT INTO wiv_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ta kaka katiu ni lohoia kete poto na kana mianga, da e paho kavu kirina. Azei kua tani zuka tapunia kana mianga ia da e pelea mianga vahoru. ");
INSERT INTO wiv_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Hau ta tania ni miu, na marigo kena na Tuna Kaka kete bele mule vona, kaka rua kua ta hiro na ngongoro rua na dongi katiu; katiu da peola, ruana da e vatua. ");
INSERT INTO wiv_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Tavine rua ta hiro ta hihirania vit kete kara plaua; katiu da e peola, katiu da e vatua.” ");
INSERT INTO wiv_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Kana apostel kamahi dia ta hulenia, “Paraha, ni ve?” A Iesus ki kolia ki tania, “Na palaka kena na poda mate vona, ia na kokoa kamahi da dia ta mai lupu vona.” ");
INSERT INTO wiv_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Pale, a Iesus ia barikikinia polea ki tania na kana disaipel kamahi kete vatunga ni dia, dia kata lotu dama laveve, beta dia kata hivu. ");
INSERT INTO wiv_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ia ki tania, “Na poloka taon katiu na jas katiu e beta ni kuahinia a Vuvu ki beta ve ni lohoihoi marata na manumanu. ");
INSERT INTO wiv_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Na tavine gabu katiu ia ve e mimia na poloka taon kena ve. Boto laveve e mamai na jas kua ki hulenia, ‘Kodoniau nu koto kara hagu vagi.’ ");
INSERT INTO wiv_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Muga na jas kua e vanga holuholu kete kodonia, palaka ba muri ia lohoi barae, ‘Beta na kuahinia a Vuvu, ki beta ve na lohoihoi marata na manumanu, ");
INSERT INTO wiv_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","palaka tavine gabu kua e ma ki mamai rarapaniau, kata hada na kodonia na kana kotoa, na vuna tabarae ni ma mamai ni loloniau na kana polea!’” ");
INSERT INTO wiv_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Na Paraha ia tani barae, “Miu longoria polea kua na jas zaha kua e tania. ");
INSERT INTO wiv_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Karae da beta a Vuvu kete kodonia kana manumanu kua ia ti makia kete kana mule, kua ta dia na halohonia na dama na marigo? Da e kogoinidia, dia ka ma guguru, ai? Mara beta! ");
INSERT INTO wiv_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Hau ta tania ni miu, da e kodoni tapunidia. Palaka, kua na Tuna Kaka ni mai, da e paria bilip vona na manumanu bukuna garigari o beu?” ");
INSERT INTO wiv_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Manumanu taza dia ta lohoia dia ka tania dia ta dopa mahoto. Dia ka hada taduria manumanu laveve. Pale, a Iesus ia barikikinia polea kua kiridia, ");
INSERT INTO wiv_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Tamohane rua hiro ta zahe kara tempel hiro kata lotu, katiu ia na Parisi, katiu na kakanaka pelepelea na takis. ");
INSERT INTO wiv_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Na Parisi kua e madi ki lotu kirina mule, ki tania, ‘Vuvu, hau ta hate motuniho, beta na balika manumanu taza, dia raskol kamahi, nuhu kua kadia moge beta ni mahoto, nuhu kua dia ta pepelea gona kaka motu, o habuka kakanaka pelepelea na takis kuari. ");
INSERT INTO wiv_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Na wik laveve ta lala kata makia botona rua kua kata mahoho vona, ka lala kata vala kagu taits na kagu goloaloa laveve ta pelea!’ ");
INSERT INTO wiv_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Palaka na kakanaka pelepelea na takis e madi zau pitu, ki beta ni tunga vatada kara lagato, palaka e hubia lakalakana ki tania, ‘Vuvu mahariau, hau ta kaka zaha!’” ");
INSERT INTO wiv_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","A Iesus ki tania, “Hau ta tania ni miu, kakanaka pelepelea na takis kua, kilaka e vamule kara kana ruma, ia za ti mahoto na matani Vuvu. Ruana betaka. Na vuna zia manumanu laveve kua dia ta vazaheni mulehia hizadia, da a Vuvu e vazihonidia. Manumanu kua dia ta vazihoni mulehidia a Vuvu da e vazahenidia.” ");
INSERT INTO wiv_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Manumanu dia ta pepelea ve kapirupiru kotekote ki mamai ni Iesus kete blesimdia. Tania na disaipel kamahi dia ka hada baraenia, dia ta pole kiridia. ");
INSERT INTO wiv_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Palaka a Iesus ia kohania kapirupiru mai vona, ia tania, “Miu vatia kapirupiru kotekote dia na mai ni niau. Taua miu na taledia, na vuna kingdom ke Vuvu ia kana nuhu mata baraerae kua. ");
INSERT INTO wiv_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Hau ta tani matotonia ni miu, azei ho kua tani beta nu pelea na kingdom ke Vuvu balika kapiru kote, mara beta matoto nu hoho vona.” ");
INSERT INTO wiv_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Na paraha katiu e hulenia a Iesus, “Tisa kemi, nazia da ta katia kata pelea mahuri roroa?” ");
INSERT INTO wiv_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","A Iesus ki kolia ki tania, “E kuziha ku kohaniau na kaka kemi? Beta katiu ni kemi, a Vuvu katiu papa za ia e kemi. ");
INSERT INTO wiv_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ho tu lala na lo ke Vuvu, ‘Taua nu katia makina magali buhua, taua nu hubi matehia kaka, taua nu vanaho, taua nu vairuku veta kara kaka, hada zahenia kamama kamani katiti.’” ");
INSERT INTO wiv_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Na kaka kua ki tania, “Goloa laveve kena ta lala kata mumuri papa vona, kilaka ta ba kakapiru za.” ");
INSERT INTO wiv_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Kamana a Iesus ki longoria polea kua, ia tania vona, “Goloa katiu ba vovona kua ma beta nu katia. Salinia ka goloaloa laveve, nu vala monina na nuhu kua beta kadia goloaloa vona, ia ni ka goloa kemikemi matoto vona heta na lagato. Pale, ho tu mai muri ni niau.” ");
INSERT INTO wiv_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Palaka kamana e longoria polea kua, lohora e zaha matoto, na vuna ia kaka katiu kua e risman matoto. ");
INSERT INTO wiv_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","A Iesus e hada vano kirina ki tania, “E vitiha matoto kara risman kete hoho na kingdom ke Vuvu! ");
INSERT INTO wiv_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Matoto, e malimu matoto kara kamel kete hoho horu na horupa nil kara samap dopa na risman katiu kete hoho na kingdom ke Vuvu.” ");
INSERT INTO wiv_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Nuhu kua dia ta longoria polea kua dia ta hule, “Pele a vuni ve da a Vuvu da ti vala mahuri roroa ni dia kua?” ");
INSERT INTO wiv_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","A Iesus e kolia ki tania, “Nazia kua mara beta kaka ni dangea kete katia, ia da a Vuvu e katia.” ");
INSERT INTO wiv_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","A Pita ia tania vona, “Hita ta vatia kahita goloaloa laveve hita kene muri ni niho.” ");
INSERT INTO wiv_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","A Iesus ki tania ni dia, “Hau ta tani matotonia ni miu. Manumanu laveve kua dia ta lohoihoi na kingdom ke Vuvu, dia ka vatia kadia ruma, godia, tazidia, tamadia kamani titinadia, ia mai tudia, ");
INSERT INTO wiv_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ia da dia ta ba vovona ri na garigari a Vuvu ki vala goloaloa luba matoto ni dia, livutia kadia goloaloa bukuni muga. Muri da dia ta pelea mahuri roroa.” ");
INSERT INTO wiv_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","A Iesus ia pelea kana 12 disaipel kamahi vano kara hiripa ia tania ni dia, “Tolu kata zahe kiri Ierusalem kua. Goloa laveve na profet kamahi dia ta vapolungania na vuna na Tuna Kaka da e bele matoto. ");
INSERT INTO wiv_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Tuna Kaka da e valanga ki vano na limani vuni Rom. Da dia ta hilenia, dia ka pole taduria, dia ka livinia, dia ka vihia, dia ta hubi matehia. ");
INSERT INTO wiv_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Na dama toluna da e lama mule.” ");
INSERT INTO wiv_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Kana disaipel kamahi beta dia na lohoi lala polea kamahi kua. Na vuvuna polea kua e litigianga ni dia, kuza barae ki beta dia na lohoi lala nazia kua e popole vona. ");
INSERT INTO wiv_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Tania a Iesus e vavana vano kozoho ni Jeriko, na kaka mata keu katiu e mimia na hiripa dala ki vavarinongu. ");
INSERT INTO wiv_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Kamana ki longoria na kabuna manumanu dia ta vavana hutu ia hule kete lala nazia e bebele. ");
INSERT INTO wiv_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Dia ta tania vona, “A Iesus bukuni Nasaret e pepe hutu.” ");
INSERT INTO wiv_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ia goe ki tania, “Iesus, Tuni Devit, mahariau!” ");
INSERT INTO wiv_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Nuhu kua dia ta vavana vamuga na dala dia ta pole kirina, dia ka tania vona kete zodo, palaka ia dopa goe ki tania ve, “Tuni Devit, mahariau!” ");
INSERT INTO wiv_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","A Iesus e madi ia tani vatuharia ni dia, dia kata pelea kaka kua ni mai vona. Tania ki mai kozoho, a Iesus ia hulenia, ");
INSERT INTO wiv_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Nazia kuli kata katia ni niho?” Ia ki tania, “Paraha, kuligu kata hada.” ");
INSERT INTO wiv_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","A Iesus ia tania vona, “Pele hada, ka bilip ti katiho kunu kemi.” ");
INSERT INTO wiv_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Pale, ia hada pamuhi kini muri ni Iesus kini vavazahenia hizani Vuvu. Kamana manumanu laveve kua dia ka hada baraenia, dia ve dia ta hate motunia a Vuvu. ");
INSERT INTO wiv_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","A Iesus e hoho ni Jeriko ki vavana kete vano ni gotala mule na paligena taon. ");
INSERT INTO wiv_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Kaka katiu hizana a Sakius, ia na paraha kana nuhuta pelepelea na takis. Ia ki risman matoto. ");
INSERT INTO wiv_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","E kulina kete hada a Iesus ia e mata zihaziha matoto. Palaka e horihi marata, kubarae ki mara beta ni hadavia a Iesus na vuna manumanu luba dia ta madi havutia. ");
INSERT INTO wiv_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Pale, ia rovo vamuga vano ia papanehia na hai sikamoa katiu kete hadavia a Iesus. Na vuna a Iesus ia e pe damukia hai kena. ");
INSERT INTO wiv_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Tania a Iesus ki vano bele na palaka kena, ia tunga langa, ia tania vona, “Sakius, mai tapu zipa. Hau da ta mia na ka ruma meni.” ");
INSERT INTO wiv_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","A Sakius ia baribari zipa ki hilohilo matoto kini kohania a Iesus vano kara kana ruma. ");
INSERT INTO wiv_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Manumanu laveve dia ta hadavia goloa kua, dia ka pole ngungu vona dia ka tania, “Keteni vano kara ruma kana kakanaka moge zaha.” ");
INSERT INTO wiv_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Dia ta hanihani vano, a Sakius ia madi ia tania na Paraha, “Hadavia Paraha! Meni da ta vala kagu dihura goloaloa na nuhu kua beta kadia goloaloa vona, kene rukia, kene vanahea goloa katiu kana kaka katiu, da ta kolia boto garamo vona.” ");
INSERT INTO wiv_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","A Iesus ia tania vona, “Meni kua na vaikolia ke Vuvu ti mai na ruma kua, na vuna zia kaka kua ve ia na tuni Abraham. ");
INSERT INTO wiv_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Na vuna Tuna kaka ia e mai kete kaze ni vaikoli kara nuhu kua dia te golugolu.” ");
INSERT INTO wiv_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Manumanu dia ta ba tatabu longo kiri Iesus kua e popole, ia barikikinia polea katiu. Na vuna kava ia keteni bele ni Ierusalem, na manumanu dia kene lolohoia habuka, da meni na kingdom ke Vuvu kini bele valutu. ");
INSERT INTO wiv_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ia tania ni dia, “Kaka katiu na zukana king kamahi e vano kara kantri motu katiu kete katua ni kara king, ba muri ni vamule. ");
INSERT INTO wiv_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Keteni vavana, ia kohania kana vora e 10, ia vala moni 1,000 kina 1,000 kina ni dia ki tania, ‘Miu gala bisnis na moni kua.’ ");
INSERT INTO wiv_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Palaka habu kana na kana malala beta ni kulidia kirina. Dia ta geria nuhu taza, dia kata muri vona vano kara malala kena ia e vavano kirina, dia na tania, ‘Beta ni kulihita kaka kena kete kara kahita king.’ ");
INSERT INTO wiv_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Palaka ia ti makua kini kara king kini vamule mai. Ia geu kara kana vora kamahi kua e vala na moni ni dia kete pari vutuhia, dia ta katia profit na moni e vala ni dia o beu. ");
INSERT INTO wiv_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Katiu muga mai ki tania, ‘Paraha, ta gala bisnis na ka 1,000 kina tu vala ni niau ka katia 10,000 kina profit vona’ ");
INSERT INTO wiv_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Kana tubu ki tania, ‘Tu gala papa matoto, kagu vora kemi! Na vuna kava tu vatunga habuka da e vaka maroro vonanga voa ni niho koto katia galanga kote, da ta taruhiho ku hada na taon e 10.’ ");
INSERT INTO wiv_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Na ruana vora mai ki tania, ‘Paraha, ta gala bisnis na ka moni tu vala ni niau ka katia 5,000 kina profit ve na huduna.’ ");
INSERT INTO wiv_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Kana tubu ki tania vona, ‘Da tu hada na taon e lima!’ ");
INSERT INTO wiv_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Toluna vora e mai ki tania, ‘Paraha, ka moni kua. Ta litiginia na taura lavalava. ");
INSERT INTO wiv_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Hau ta kuahiniho, na vuna ho tu kakanaka toraranga. Tu lala koto pele vetania goloa kana kaka motu, ku lala koto vuruti vetania haninga kua kaka motu e vazohia.’ ");
INSERT INTO wiv_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Kana tubu ki tania, ‘Vora zaha, ho! Ka polea mule, ti koto kiriniho! Ho tu lala te habuka, hau ta kakanaka toraranga. Ta lala kata pele vetania goloa kana kaka motu, ka lala kata vuruti vetania haninga kua kaka motu e vazohia. ");
INSERT INTO wiv_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Pele e kuziha ki beta ni kuli koto taruhia na benk ni ngoro na vamule hau ta pele gotalani mulehia na benk kamana interes?’ ");
INSERT INTO wiv_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Pale, ia tania na nuhu kua dia ta madi kozoho vona, ‘Pelea 1,000 kina kena vona, miu ta vala na kaka kena kana moni e 10,000 kina.’ ");
INSERT INTO wiv_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Dia ka tania, ‘Paraha, ia kava ti kana 10,000 kina vona!’ ");
INSERT INTO wiv_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ia ki kolia ki tania, ‘Ta tania ni miu, manumanu kua kadia goloa vona, da e valanga luba ve ni dia. Palaka kaka kena e beta matoto kana goloa vona, pitu kena e vona, da e pele kakavanga. ");
INSERT INTO wiv_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Palaka hagu vagi kamahi kena beta ni kulidia kiriniau kata kara kadia king na hada ni dia, peledia mai ri kua na matagu miu na hubi matehidia.’” ");
INSERT INTO wiv_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","A Iesus e tani hozovia polea kua, ia pe vamuga, kete zahe kiri Ierusalem. ");
INSERT INTO wiv_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ti vano kozoho na malala karua kua a Betfage kamani Betani, na potuna kua e kohanga ni Oliv, ia geria kana disaipel rua, ki tania ni hiro, ");
INSERT INTO wiv_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Mo vamuga vano kara malala kuarina, mo kene bele vona, da mo ta hada na donki huluvahu katiu e rotua ki mamadi, ma beta kaka katiu ni polo vona. Mo hulia, mo ta pelea mai. ");
INSERT INTO wiv_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Kua kaka katiu kini hulenimoro, ‘E kuziha mo ka huhulia donki?’ Mo ta tani barae, ‘Paraha e kulina kete katia galanga katiu vona.’” ");
INSERT INTO wiv_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Na disaipel karua kua e geura hiro ka vamuga, hiro ta paria goloa laveve ia e habuka kua a Iesus e tania ni hiro. ");
INSERT INTO wiv_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Hiro ta ba huhulia na donki, na habu tauana donki dia ta hulenihiro, “E kuziha mo ka huhulia donki?” ");
INSERT INTO wiv_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Hiro ta tania, “Paraha e kulina kete katia galanga katiu vona.” ");
INSERT INTO wiv_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Pale, hiro ta pelea vano ni Iesus, dia ta varaga langaria kadia tale havuhavua na huduna donki, dia ta vapolea a Iesus vona. ");
INSERT INTO wiv_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Tania ki vavana vano, manumanu dia ta voloria kadia tale havuhavua na dala ki dede vona. ");
INSERT INTO wiv_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Tania ki vano ki kozoho na palaka kua na dala keteni tiro na Potuna ni Oliv, na kabuna kana disaipel kamahi dia ta goe kapopou, dia kene vavazahenia hizani Vuvu, dia kene hate motunia na vuna na mirakel kamahi kua muga dia ta hadavia. ");
INSERT INTO wiv_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Dia ta tania, “A Vuvu e kati kemihia matoto na king kua e mai na hizana Paraha! Vazahenia hizani Vuvu ni zahe heta matoto! Na vuna ia ti katia magalidolu kini malugunia.” ");
INSERT INTO wiv_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Na Parisi taza na poloka kabuna manumanu kua, dia ta tania ni Iesus, “Tisa, pole kara ka disaipel kamahi dia na zodo!” ");
INSERT INTO wiv_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","A Iesus ki tania ni dia, “Ta dia na tabaria havadia, na kedo kamahi kua da dia ta goegoe.” ");
INSERT INTO wiv_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Kamana e zahe ki kozoho ni Ierusalem ki hadavia na taon, ia tangizia, ");
INSERT INTO wiv_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ki tania, “Ierusalem, meni kua, e kuligu ma koto lala na goloaloa kua e nap kete katiho koto mia ni malugunia. Palaka kua ti litigianga ni niho, ki mara beta nu hadavia. ");
INSERT INTO wiv_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Na dama katiu kua e ba mamai, ha vagi kamahi da dia ta diva lobia kadia batanga ni niho, dia ka madi lobiho, dia ka pe porotiho na paligena laveve. ");
INSERT INTO wiv_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Da dia ta varaga taduriho, dia ka vaka taduriho, ho kamani habu tutu. Da mara beta dia na vatia kedo katiu ni ngoro langa na huduni ruana. Na vuna zia beta nu na hada lala na dama kua a Vuvu ti mai kete vaikoli kiriniho vona.” ");
INSERT INTO wiv_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Pale, ia vano hoho na poloka tempel, kini kalingania manumanu kua dia ta gagala bisnis vona. ");
INSERT INTO wiv_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ia ki tania kiridia, “E vapolu bareanga na buk ke Vuvu, ‘Kagu ruma ia kara lotua za,’ palaka miu te katia kini kara palakana paritigia kana nuhu mata vanahonaho.” ");
INSERT INTO wiv_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Na dama laveve ia ma ki ratarata manumanu na poloka tempel. Palaka na hetpris kamahi kamana tisa kara lo ia mai nuhu kua dia ta vavamuga na manumanu, dia ta lohoia dia kata hubi matea. ");
INSERT INTO wiv_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Palaka ki mara beta dia na katia goloa katiu vona, na vuna zia manumanu laveve, dia ta tabu longo matoto kara kana polea. ");
INSERT INTO wiv_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Dama katiu a Iesus e raratahia manumanu na hatamara tempel ki vaketekete na Kalohua Kemi ke Vuvu, na hetpris kamahi kamana tisa kamahi kara lo, ia mai dia nuhu kua dia ta vavamuga na galanga na lotua, dia ta lupu, dia ta kabu zahe kirina. ");
INSERT INTO wiv_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Dia ta hulenia, “Ko tania ni hita, azei matoto e vala naba kamana matuhanga ni niho ku kakatia goloaloa kua?” ");
INSERT INTO wiv_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","A Iesus e kolia ki tania, “Hau kata hulenimiu na hulea kua. Miu tania ni niau. ");
INSERT INTO wiv_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Azei matoto e vala naba ni Jon kete vazuguvia manumanu. A Vuvu o kaka katiu?” ");
INSERT INTO wiv_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Dia ta varihulei na pidaka dia mule dia ka tania, “Da tolu ta tani ziha? Ta tolu na tania, ‘E pe ni Vuvu,’ da e tania, ‘Pele e kuziha ki beta miu na bilip vona?’ ");
INSERT INTO wiv_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Palaka ta tolu na tania, ‘E pe na kaka.’ Da manumanu laveve kua, dia ta lubi matehidolu na kedo, na vuna dia te lohoia a Jon ia matoto ia na profet.” ");
INSERT INTO wiv_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Pale, dia ta kolia, dia ka tania, “Beta hita na lala e pe ve ki mai.” ");
INSERT INTO wiv_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","A Iesus ki tania, “Pele hau ve mara beta na tania ni miu azei matoto e vala matuhanga ni niau kata katia goloaloa kua.” ");
INSERT INTO wiv_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Pale, a Iesus ia barikikinia polea kua ki tania, “Kaka katiu e vazohia vanua na vaen katiu. Ia vatia vanua na manumanu taza dia kata gala bisnis vona dia na vala dihura profit vona. Pale, ia vavana kara malala motu, ki mia havarau matoto vona. ");
INSERT INTO wiv_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ti damana keteni duloa na palekana vaen, ia geria kana vora katiu kete vano na nuhu kua dia ta gala bisnis na vanua na vaen, dia na vala na palekana vaen taza vona. Palaka nuhu kua dia ta gala bisnis na vanua na vaen kua, dia ta hubia, dia ta geri mulehia kini vamule vano, kamana limana vetanga. ");
INSERT INTO wiv_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ia geria kana vora katiu ve. Ia ve dia ta hubia dia ka kati zahatia matoto vona, dia ta geri mulehia ve, kamana limana vetanga. ");
INSERT INTO wiv_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ia geria ve tolu hiro, ia ve dia ta hubi maratania dia ka vala muku vona dia ta varaga gotalania na vanua. ");
INSERT INTO wiv_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Pale, na tauna vanua ia tania, ‘Nazia keteni katia kua? Kata geria tugu, kua e kuligu matoto kirina; tauka da dia ta hada zahenia!’ ");
INSERT INTO wiv_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Palaka kamana na manumanu kua dia ta gala bisnis na vanua dia ta hadavia, dia ta varitaninia ni dia mule, ‘Tuna tauna vanua kua. Da ni ba muri da ia e pelea vanua kua. Tolu kata hubi matehia, tolu kata ma pelea vanua na vaen kua hadolu!’ ");
INSERT INTO wiv_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Pale, dia ta pelea gotala na vanua na vaen dia ta hubi matehia. Pele, miu ta lohoia da na tauana vanua na vaen kua e katia nazia na manumanu kua? ");
INSERT INTO wiv_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Da e mai ki hubi matehia na manumanu kua dia ta gala bisnis na vanua na vaen, ki vala na vanua na vaen na manumanu motu!” Kamana manumanu dia ka longoria polea kua, dia ta tania, “Mara beta matoto ni kubarae!” ");
INSERT INTO wiv_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","A Iesus e hada vano mahoto kiridia ki hulenidia, “Pele e kuziha dia ka vapolungania polea kua na buk ke Vuvu dia ka tani barae, ‘Na kedo kua na kapenta kamahi dia te lohoia dia ka tania ti beta galangana dia kene varaga tapunia, ti kara kedo kua ti taruha kini ngoro tuka ruma.’ ");
INSERT INTO wiv_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Manumanu laveve kua dia ta dua kara huduna kedo kua, da dia ta hutuhutu, kua ni dua langalanga kara kaka katiu, da e momomo.” ");
INSERT INTO wiv_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Na tisa kamahi kara lo kamana hetpris kamahi dia ta lohoia dia kata paho taduria dia na koto kirina, na vuna zia dia ta lala ia e barikikinia polea kua kiridia; palaka dia ta kuahinia manumanu. ");
INSERT INTO wiv_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Pale, na hetpris kamana tisa kamahi kara lo dia ta kazekaze dala katiu kua kete katia ni volo papa dia kata koto kirina. Dia ta kadea manumanu taza dia kata vairuku dia na tania e kulidia matoto dia kata longoria kana polea. Dia ta lohoia dia kata rukia ni tania polea katiu kua e dangea dia kata koto kirina na kadia gavana na provins. ");
INSERT INTO wiv_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Nuhu kua dia ta hulenia a Iesus, “Tisa, hita ta lala ka polea e mahoto, ku vaketea polea mahoto na manumanu. Hita ta lala habuka beta nu lala koto hada kaka katiu nu tania ia e dopa ki hizanga na ruana, palaka tu lala koto vaketea matotoka polea na lohoihoia ke Vuvu kara manumanu. ");
INSERT INTO wiv_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Tania ni hita, e mahoto na kadolu lo kua tolu kata kadea na takis ni vano ni Sisar o beta?” ");
INSERT INTO wiv_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Palaka a Iesus kava ti lala dia ta papado rukia na polea. Kubarae ia ki tania ni dia, ");
INSERT INTO wiv_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Miu vatunga silva moni katiu ni niau. Hanunuki zei kamana hizani zei kua vona?” ");
INSERT INTO wiv_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Dia ka tania, “Ke Sisar.” A Iesus ia tania ni dia, “Pele miu vala ni Sisar nazia kua ke Sisar, miu vala ni Vuvu nazia kua ke Vuvu.” ");
INSERT INTO wiv_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Beta dia na dangea dia kata rukia ni tania polea katiu kua dia kata koto kirina vona na pidaka manumanu laveve. Dia ta ridi na polea kua e kolia kadia hulea vona. Pale, beta ve dia na ma hulenia. ");
INSERT INTO wiv_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","A vuni Sadyusi taza, nuhu kua dia ta tania mara beta kaka ni mahuri mule na matea, dia ta mai ni Iesus dia ka tania, ");
INSERT INTO wiv_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Tisa, a Moses e vapolungania na lo ki tani barae, kua kaka katiu ni mate tapunia gona ni beta ni taruhia kapiru katiu vona, tazina kaka kena da e kabania gaburi tazina kete taruhia kapiru vona. Kapirupiru kena kete tapia na gaburi tazina ia da ke tazina kua ti mate. ");
INSERT INTO wiv_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Varitazini taza dia 7. Tazidia muganga e kabania tavine katiu beta ni taruhia kapiru katiu vona, pale, ia mate. ");
INSERT INTO wiv_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Tazina muri lamana e kabania ve tavine kua. ");
INSERT INTO wiv_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Mai ve tazihiro toluna ve e kabania ve tavine kua. Dia varitazini 7 kua laveve, dia ta kabania laveve tavine kua palaka, beta katiu ni dia ni taruhia kapiru vona, dia ka varimateai laveve. ");
INSERT INTO wiv_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Muri, na tavine kua ia ve mate. ");
INSERT INTO wiv_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Kua tani ba muri, kua manumanu dia na mahuri mule na matea, da na tavine kua da ti kara goni zei matoto ni dia? Dia laveve dia ta kabania muga.” ");
INSERT INTO wiv_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Pale, a Iesus ia tani barae, “Manumanu bukuna tauna kua dia ta lala dia kata lalahi. ");
INSERT INTO wiv_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Palaka nuhu kua a Vuvu ti hadavia dia ta kemi na matana kini makidia kini tania dia kata mahuri mule dia na mia kamana ba muri, ia mara beta dia na lahi o valahua dia. ");
INSERT INTO wiv_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Na vuna mara beta ve dia na mate. Da dia te habuka engel kamahi. Dia kene kara habu tutuni Vuvu, na vuna zia a Vuvu ti valamari mulehidia na matea. ");
INSERT INTO wiv_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","A Moses ve ia e vatunga kakava kubarae, nuhu kua dia ta varimateai da dia ta valamari muleha. Na ziuziua kua na haroho e dudulu na huduna hai kote, e pole ki kohania Paraha habuka, ia na Vuvu ke Abraham, ke Aisak, ia mai ve ke Jekop! ");
INSERT INTO wiv_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Beta ia ni a Vuvu kana nuhu kua ti varimateai, beta ia a Vuvu kana nuhu kua dia ta mahuri, na vuna na matani Vuvu manumanu laveve dia ta mahuri.” ");
INSERT INTO wiv_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Tisa kara lo taza dia ta tani barae, “Tisa, tu koli kemikemihia matoto.” ");
INSERT INTO wiv_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Pale, beta ve katiu ni dia ve ni parakilania kete hulenia na hulea katiu ve. ");
INSERT INTO wiv_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Pale, a Iesus ia hulenidia, “Ti kuziha dia kene tania a Kristus ia na tuni Devit? ");
INSERT INTO wiv_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","A Devit mule ia e tani kakava na poloka Buk Song, ‘Paraha e tania na kagu Paraha, “Mia kiri marorogu, ");
INSERT INTO wiv_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ki mule na dama hau ka taruhia ha vagi kamahi na tauri kabe ku vaka taduridia.” ’ ");
INSERT INTO wiv_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","A Devit e kohania kaka kua na kana Paraha. Pele da e kara tuna ziha?” ");
INSERT INTO wiv_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Manumanu laveve dia ta ba lolongoria a Iesus kua e vavala polea, ia ki tani barae na kana disaipel kamahi, ");
INSERT INTO wiv_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Miu lohoia na tisa kara lo kamahi. E kulidia dia kata zohoria loholohoa malakulaku dia na vavana. Ki kulidia matoto manumanu kete hada zahenidia na poloka palakana lupua; dia ka hada palipali kara mianga kena e taruha ke pararaha na poloka haus lotu ke vuni Iuda kamana mianga pa ve na parti kamahi. ");
INSERT INTO wiv_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Dia ka lala dia kata rukirukia gabugabu dia na vavanahedia, dia ka vavalabi na lotua malakulaku. Na taem kara kotoa, da dia ta pelea zahatanga matoto.” ");
INSERT INTO wiv_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","A Iesus e tunga zahe ia hada nuhu kua dia ta risman dia ta tataruhia kadia opa na poloka bokis kara opa na poloka tempel. ");
INSERT INTO wiv_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ia hada ve na tavine gabu katiu kua beta kana goloaloa vona e gorea na toea kote rua. ");
INSERT INTO wiv_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ia tania, “Hau tania ni miu, tavine gabu kuari kua beta kana goloaloa vona, e gorea moni ki kapou dopa ni dia laveve. ");
INSERT INTO wiv_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Manumanu laveve kuari dia ta opa na dihura kadia goloaloa kua e luba, palaka ia e vala hozovia goloa laveve kua kete kodonia na kana mianga.” ");
INSERT INTO wiv_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Kana disaipel taza dia ta hada na tempel dia ka popole vona, kua na kedo mata mulimuli kua e habata vona kamana presen kamahi kua manumanu dia ta opa vona dia ka bilasnia na tempel vona. Palaka a Iesus e tania, ");
INSERT INTO wiv_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Nazia kua miu ta hada ri kua, damana vona kua kete mai, kua beta kedo katiu kete vatua ni ngoro langa na ruana. Kedo laveve kua da e varaga tadura.” ");
INSERT INTO wiv_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Dia ka hule, “Tisa, da ngiza goloa kamahi kena ki bele? Mak zia da e bele kete makia damana goloaloa kena keteni bele vona?” ");
INSERT INTO wiv_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","A Iesus ia tania, “Miu lohoimiu tabarae, miu na rukua. Manumanu luba da dia ta mai na hizagu, dia ka tania, ‘Hau a Kristus kua.’ Da dia ta tani barae ve, ‘Dama ti kozoho!’ Palaka, taua miu na muri ni dia. ");
INSERT INTO wiv_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Tabarae miu na kuahi kua miu kene longoria nius na war o manumanu bukuna kantri katiu dia ta varihubi mule kamana kadia gavman. Goloaloa kamahi kena da dia ta muga bele, palaka beta ni habuka las de ti kozoho.” ");
INSERT INTO wiv_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","A Iesus ki tani barae ve, “Kantri taza da dia ta varihubi kamana kantri motu, kingdom taza da dia ta varihubi kamana kingdom motu. ");
INSERT INTO wiv_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Vuruhe kapopou matoto da dia ta bele na malala luba, vitolo kapou da e bele na malala luba, mazahi kapou da e lohu na manumanu ki dua polea na manumanu na malala luba na garigari, goloaloa mata holiholi da e bele na mariaba, kua miu na hadavia da miu ta kuahi zahazaha matoto. ");
INSERT INTO wiv_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Palaka ba muri na goloaloa kua kini bele, da muga dia ka paho tadurimiu, dia ka kati zahatia ni miu. Da dia ta pelemiu ka vano na poloka haus lotu ke vuni Iuda, dia ka karabusnimiu, dia ka koto kirimiu na kadia king kamahi kamana kadia gavana kamahi, na vuna kua miu ta mumuri ni niau. ");
INSERT INTO wiv_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Na taem kena da ti volo papa kirimiu, miu keteni tani kakava na Kalohua Kemi ni dia. ");
INSERT INTO wiv_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Kubarae, tabarae miu na muga lolohoi vuvu na polea kakei kua miu kata tania kua miu kata kolia kadia polea vona. ");
INSERT INTO wiv_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Hau da ta vala polea kamana lohoihoia pa ni miu, kena beta hamiu vagi katiu ni dangea kete kolia o vanga holia. ");
INSERT INTO wiv_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Habu titinamiu kamani habu tamamiu, habu tazimiu, habu vinekemiu kamani habu kurakuramiu, da dia ta tilitili tika kirimiu, manumanu dia ta hubi matehia taza ni miu. ");
INSERT INTO wiv_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Manumanu laveve da beta kete kulidia matoto kirimiu na vuna miu ta bilip ni niau. ");
INSERT INTO wiv_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Palaka mara beta vulukumiu katiu na bakamiu ni golu. ");
INSERT INTO wiv_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Miu madi bada, miu kata pelea mahuri roroa. ");
INSERT INTO wiv_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ta miu na hadavia na armi kamahi dia te madi lobia a Ierusalem, da miu te lala baraenia a Ierusalem keteni vairoha. ");
INSERT INTO wiv_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Pale, nuhu kena ni Iudea, dia kata varihavai kara potuna kamahi, nuhu na poloka taon dia kata varihavai dia na gotala, nuhu na hatamara taon beta dia kata hoho mule. ");
INSERT INTO wiv_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Na vuna ia ti na damana kena a Vuvu keteni kolia moge zahazaha kana manumanu habuka kua e vapolunganga na polea ke Vuvu. ");
INSERT INTO wiv_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Da e kaba loho zahanga matoto ni tavivine kua dia ta kovekove kamana tavivine kua dia ta ba vavazuzu habu tutudia! Na vuna zia, damana bizea kapou da bele na garigari, a Vuvu da e vadua langaria kana magali varitihia kara manumanu kua. ");
INSERT INTO wiv_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Taza da e hubu matoa dia na bainat, dia taza da dia ta peola habuka karabus dia ka vano kara malala motumotu. A Ierusalem, da manumanu kua beta dia na lala a Vuvu, da dia ta vaka taduria ki mule na dama kena a Vuvu e makia. ");
INSERT INTO wiv_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Da na mak luba da e bele na matana voro, na lingabo, kamana vitovito kamahi. Na vulovulo kantri kamahi da dia ta kuahi matoto kua dia ta longoria halingana dazi kapopou kua e popole. ");
INSERT INTO wiv_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Manumanu da matadia e lobi, dia ka poke veta za na kuahia na vuna na goloa kua keteni bele na garigari, goloaloa laveve heta na mariaba da e hunuanga. ");
INSERT INTO wiv_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Na dama kena, da dia ta hada Tuna Kaka ti pe na mariaba kini ziho kamana matuhanga ia mai kamana glori kapou. ");
INSERT INTO wiv_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ta goloaloa kua ni varivuvu keteni bebele, miu madi, miu ta valangatia bakamiu, na vuna na dama kua a Vuvu kete vaikoli kirimiu vona ti mai kozoho.” ");
INSERT INTO wiv_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","A Iesus ia barikikinia polea kua, “Miu hadavia na haina fik kamana haihai laveve. ");
INSERT INTO wiv_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ta miu na hadavia kua dia te lobulobu, da miu ta lohoi lala na nagi kara voro ti kozoho. ");
INSERT INTO wiv_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ia balika za, ta miu na hada goloaloa kamahi kua ti bebele, ia da miu ta lala na kingdom ke Vuvu ti mai kini kozoho. ");
INSERT INTO wiv_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Hau ta tani matotonia ni miu, nuhu bukuna tauna kua da beta dia kata varimateai, goloaloa kua ki bele matoto. ");
INSERT INTO wiv_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Lagato kamana garigari da hiro ta vano hiro ka hozo, palaka kagu polea mara beta ni kakava.” ");
INSERT INTO wiv_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Miu lohoimiu, tabarae miu na vatia kamiu hatuhatua ni harehimiu, miu na hanihani, miu na hihinu marata, miu na sisipak, miu na lohoi marata na kamiu mianga. Tabarae dama kua ni bele ni paho taduri valutuhimiu balika hoa. ");
INSERT INTO wiv_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Na vuna zia dama kua da e bele na manumanu laveve na malala laveve na garigari. ");
INSERT INTO wiv_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Dama laveve miu ma tatare, miu ka lolotu miu kata matuha, miu na hava hutu na goloaloa kua kete bele, kete dangea miu kata madi na matana Tuna Kaka.” ");
INSERT INTO wiv_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Dama laveve a Iesus e vaketekete na poloka tempel. Ti marigo ia e lala kete vano gotala ni mia dama na potuna ni Oliv. ");
INSERT INTO wiv_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Manumanu laveve dia ta mamai vona na damadama dia kata longoria kana polea na poloka tempel. ");
INSERT INTO wiv_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Na damana hanihania kapou na bret beta yis vona, kua e kohanga na Pasova, ti mai kozoho. ");
INSERT INTO wiv_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Na hetpris kamahi kamana tisa kara lo dia ta kakaze dala dia kata hubi matehia a Iesus, na vuna dia ta kuahinia na manumanu. ");
INSERT INTO wiv_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Pale, a Satan ia holiholia a Iudas, hizana katiu ve a Iskariot, ia katiu ni dia na 12 disaipel ke Iesus. ");
INSERT INTO wiv_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","A Iudas e vano na hetpris kamahi kamana kepten kamahi kara gat kara tempel. Dia ta pole lupu, dia kata paria dala katiu kua a Iudas kete vala a Iesus na limadia. ");
INSERT INTO wiv_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Dia ta hilohilo matoto vona, dia ta taru lupunia polea dia kata vala moni ni Iudas. ");
INSERT INTO wiv_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","A Iudas ia tara na kadia polea. Pale, kini vano kini guria boto katiu kua kete beta matoto kaka kete hadavia, ia ni vala a Iesus na limadia. ");
INSERT INTO wiv_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Na damana haninga kapou na bret beta yis vona ti bele. Na dama kua dia ta lala dia kata hubia na tuna sipsip kara Pasova ve. ");
INSERT INTO wiv_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","A Iesus ia geria a Pita hiro a Jon ki tani barae ni hiro, “Mo vano mo na vaida hadolu haninga tolu kata hania na Pasova.” ");
INSERT INTO wiv_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Hiro ta hule, “Kuli miro kata vaida hadolu haninga ni ve?” ");
INSERT INTO wiv_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ia tania ni hiro, “Mo na hoho na taon kapou a Ierusalem, da mo ta paria kaka katiu e luluga na baket na naru. Mo muri vona vano hoho na ruma kena ia e hoho vona, ");
INSERT INTO wiv_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Mo ta tania na tauana ruma, ‘Na tisa e hule, kue na rum kua ia kete hania Pasova kamana kana disaipel kamahi vona?’ ");
INSERT INTO wiv_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ia da e vatunga rum kapou katiu e ngoro langa. Goloaloa laveve kara mianga, kamana tebol kamahi ve vona. Mo vaida goloa laveve ra.” ");
INSERT INTO wiv_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Hiro ta vano hiro ta paria goloaloa laveve e habuka kena a Iesus e tania ni hiro. Pale, hiro ta vaida haninga kara Pasova. ");
INSERT INTO wiv_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Kamana na taem kara hahania ti bele a Iesus ia mia kamana kana apostel kamahi na tebol. ");
INSERT INTO wiv_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","A Iesus ki tania ni dia, “Hau ta guguria matoto dama kua meni, kata hania Pasova kamamiu. Ba muri kene luga bizea. ");
INSERT INTO wiv_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Na vuna ta tania ni miu, da beta kata hania Pasova ve ki vano ki mule na dama kua na goloa kua kete pori matoto na kingdom ke Vuvu.” ");
INSERT INTO wiv_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Pale, ia pelea na kap na vaen, ia hate motunia tamana ki tania ni dia, “Miu pelea kap na vaen kua, miu na hinumia. ");
INSERT INTO wiv_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Na vuna ta tania ni miu mara beta ve na hinumia ve na zuruka palekana haina vaen ki mule na dama na kingdom ke Vuvu ki bele.” ");
INSERT INTO wiv_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Muri ia pelea na bret, ia hate motunia Tamana, ia bara vulahia bret, ia vala ni dia, ki tania, “Kua ia na livuhagu ti valanga kete kodonimiu. Miu kati baraenia. Miu kata lohoi mulehiau vona.” ");
INSERT INTO wiv_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Muri na hanihania ia e kubaraenia ve. E pelea na kap, ia tani barae, “Na kap na topogu kua, ia na mak kara kontrak vahoru kamana manumanu, kua ti valikira kete kodonimiu. ");
INSERT INTO wiv_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Palaka na limana kaka kua kete valau na limana vagi kamahi, ia ri kua kamaniau na tebol. ");
INSERT INTO wiv_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Na vuna na Tuna Kaka da e muri za na dala kua kava a Vuvu ti tania varira kete bele kirina, palaka kaba loho zahanga matoto na kaka kua kete vala na Tuna Kaka na vagi kamahi.” ");
INSERT INTO wiv_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Pale, na disaipel kamahi dia ta varihulei habuka azei matoto ni dia, da e katia goloa kua. ");
INSERT INTO wiv_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Mai ve dia ta vaigege na pidaka dia mule, kua azei ni dia kete kara kadia paraha. ");
INSERT INTO wiv_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","A Iesus ia tania ni dia, “Na king kamahi bukuna garigari, dia ta lala dia kata bosim kadia manumanu. Dia ka lala dia kata kona zaheni mulehidia habuka dia ta lala dia kata hada poto papa na kadia manumanu. ");
INSERT INTO wiv_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Palaka miu beta miu kata habuka dia. Beta, azei e paraha na pidaka miu, ia kete balika kapiru. Azei e hada ni miu ia kete vora kamiu. ");
INSERT INTO wiv_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Azei e dopa ki paraha, kaka kena e mimia na tebol o kaka kena e padopado haninga? Karae beta ni na kaka kena e mimia na tebol? Palaka hau na pidaka miu, hau ta balika kaka kena e padopado haninga. ");
INSERT INTO wiv_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Miu ta lala miu kata mamadi kamaniau na bizea laveve kua e mamai kirigu. ");
INSERT INTO wiv_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Kubarae, habuka kua Tamagu e vala na kingdom katiu ni niau kata hada vona, hau ve da ta vala ni miu na kingdom katiu miu kata hada ve vona, ");
INSERT INTO wiv_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","kubarae da miu ta hanihani miu ka hinu na kagu tebol na poloka kagu kingdom, miu ka mia na sia king kamahi, miu ka hada na zukazuka kena e 12 ni Israel. ");
INSERT INTO wiv_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Saimon, Saimon. A Satan kava ti hule kete parakilanimiu, kete vahere kakava kaka zaha na kaka kemi. ");
INSERT INTO wiv_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Palaka kava te lotu ka, Saimon, kara ka bilip kete bada. Pale, kua kunu tare poki kunu vamule ni niau, ho tu vatuharia habu tazi.” ");
INSERT INTO wiv_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Palaka a Saimon ki tania, “Paraha, hau ta tare za kata vano kamaniho na karabus na mate.” ");
INSERT INTO wiv_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","A Iesus e kolia vona ki tania, “Hau ta tania ni niho, Pita, meni kua da toha ba muri ki kakareko, da tu muga ku tania boto tolu habuka beta nu lalau.” ");
INSERT INTO wiv_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Pale, a Iesus ia hulenidia, “Kilaka kua hau ta gerimiu ki beta miu na pelea kamiu hanpaus, kamiu beke o kamiu sandel, miu ta sot na goloa katiu?” Dia ka tania, “Betaka!” ");
INSERT INTO wiv_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","A Iesus ki tania ni dia, “Palaka kua kini kamiu hanpaus vona, miu pelea kamana kamiu beke, azei kua beta kana bainat, kete salinia kana kale havuhavua ni kadea katiu. ");
INSERT INTO wiv_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Na vuna e vapolu bareanga na poloka buk ke Vuvu, ‘Dia ta hadavia, dia ka tania: Ia ve ia na raskol katiu.’ Hau ta tania ni miu, goloa kua da ti kati matotoanga ni niau, na vuna nazia e vapolunganga na poloka buk ke Vuvu ki tanga kete bele ni niau, ia keteni bele.” ");
INSERT INTO wiv_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Na disaipel kamahi dia ta tania, “Tubu, hadavia bainat rua kua!” A Iesus ki tania, “Miu pale!” ");
INSERT INTO wiv_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","A Iesus ia vatia taon, ia gotala, kini vano kara potuna ni Oliv, habuka e lala kete katia dama laveve. Kana disaipel kamahi dia ta muri vona. ");
INSERT INTO wiv_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Kamana ki bele na palaka kua, ia tania ni dia, “Miu lotu kete beta miu kata poke na parakilakilanga.” ");
INSERT INTO wiv_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Pale, ia vatidia ia vano zau pitu, habuka 30 mita zau ni dia. Pale, ia padonia tutura kini lotu. ");
INSERT INTO wiv_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ki tania, “Tamagu, kua ni kuli, pele kakava kap na bizea kua ni niau. Palaka, tabarae nu muri na kagu lohoihoia, palaka katia nazia kua e kuli koto katia.” ");
INSERT INTO wiv_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Na engel katiu bukuna lagato e bele vona, ia vatuharia. ");
INSERT INTO wiv_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","A Iesus e hatunia na poloka e dopa ki bize matoto, ia dopa lotu matuha matoto. Pale, na rorongo kua e noro na livuhana ki dua kara garigari, e hada balika topo. ");
INSERT INTO wiv_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","E lotu hozo ki madi, ia vano na kana disaipel kamahi, ki hadavidia dia te varingoroai, na vuna livuhadia e buzabuza na vari. ");
INSERT INTO wiv_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ia ki tania kiridia, “E kuziha miu ka ngongoro? Miu lama, miu na lotu! Tabarae, miu na poke na parakilakilanga.” ");
INSERT INTO wiv_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","A Iesus e ba popole barae, na kabuna manumanu taza dia ta mai, a Iudas, katiu ni dia kua na 12 disaipel ke Iesus, e vamuga ni dia, dia ka mamai. Ia mai kozoho ni Iesus ia domia a Iesus. ");
INSERT INTO wiv_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Palaka a Iesus ia tania vona, “Iudas, koto nu vala na Tuna Kaka na ka domidomia ai?” ");
INSERT INTO wiv_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Kamana nuhu kua dia ta kakamani Iesus dia ka hadavia goloa kua keteni bele, dia ta hulenia, “Tubu, hita kata varihubi kamadia kamana kahita bainat kamahi kua?” ");
INSERT INTO wiv_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Pale, katiu ni dia ia bazi hutuzia na maroroni talingana vora kana kadia hetpris. ");
INSERT INTO wiv_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Palaka a Iesus ki tania, “Miu pale!” Pale, ia vakulia talingana kaka kua e bazua kini kemi mule. ");
INSERT INTO wiv_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Pale, a Iesus ia tania kara nuhu kua dia ta mai kirina, dia hetpris kamahi kamana sekuriti opisa kamahi kara tempel, ia mai dia pararaha kara haus lotu ke vuni Iuda, e tani barae, “Miu ta lohoia hau na raskol katiu, miu ka pepelea na bainat kamana pakole kirigu?” ");
INSERT INTO wiv_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ta lala kata mimia kamamiu na dama laveve na poloka tempel, beta miu na parakilania miu kata paho taduriau. Palaka ti kamiu aua kua, kamana matuhanga kara rodo. ");
INSERT INTO wiv_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Pale, dia ta haba taduria dia kene pelea vano, kara ruma kana hetpris. A Pita e titihedia ki mumuri zau pitu. ");
INSERT INTO wiv_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Nuhu taza dia ta dohotia haroho na hatamara ruma kana hetpris dia ka loli lobia. A Pita e mai, ia mia kamadia. ");
INSERT INTO wiv_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Na tavine vora katiu e hadavia a Pita na kitaka haroho, ia hada boroboronia, ki tania, “Kaka kua ia e lala kete kakamani Iesus kua.” ");
INSERT INTO wiv_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Palaka a Pita e linga matoto ki tania, “Ae, hau beta na lala kaka kena.” ");
INSERT INTO wiv_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Havarau pitu papa ve kaka katiu ve ia hadavia ki tania, “Ho ve katiu ni dia te?” Palaka a Pita ia tania, “Ae, hau betaka!” ");
INSERT INTO wiv_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Na aua katiu ve muri vona, na kaka katiu ve ia hadavia ia goe ki tania, “Matoto, matoto, kaka kua ia e lala kete kakamana, na vuna ia bukuni Galili.” ");
INSERT INTO wiv_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Palaka a Pita ki tania, “Ae, hau beta na lala nazia ho tu popole vona.” Kamana ki ba popole barae, na toha ia kakareko. ");
INSERT INTO wiv_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","A Tubu a Iesus e tunga poki ia hada boroboronia a Pita. A Pita ia lohoi mulehia na polea kana Tubu, kua muga e tani barae vona, “Meni, muri toha kini kakareko, da tu tania boto tolu beta nu lalau.” ");
INSERT INTO wiv_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pale, a Pita ia vano gotala kini tangi zahazaha matoto. ");
INSERT INTO wiv_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Nuhu kua dia ta paho taduria a Iesus, dia ta hilenia a Iesus, dia kene huhubia; ");
INSERT INTO wiv_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Dia ta rotu karia matana na lavalava dia ta hulenia, “Ko tani lala! Azei matoto kua e huhubiho?” ");
INSERT INTO wiv_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Dia ta tania polea zahazaha taza ve kirina, dia ka hilenia. ");
INSERT INTO wiv_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Tania ki dama, dia pararaha kamahi kamana hetpris kamahi, kamana tisa kamahi kara lo, dia ta mai lupu. Pale, dia ta pelea a Iesus vano ni dia. ");
INSERT INTO wiv_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Dia ta hulenia, “Tania ni hita, ia ho a Kristus?” Ia ki kolia ki tania, “Kua na tania ni miu, mara beta miu na bilip ni niau. ");
INSERT INTO wiv_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ta hau na hulenimiu na hulea katiu, mara beta miu na kolia. ");
INSERT INTO wiv_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Palaka da meni kua ki vano, na Tuna Kaka da e vamianga na maroroni Vuvu kamana kana matuhanga.” ");
INSERT INTO wiv_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Dia laveve dia ka tania, “Pele ho na Tuni Vuvu, ai?” Ia ki kolia ki tania, “Miu mule miu ta tania kena.” ");
INSERT INTO wiv_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Pale, dia ta tania, “Beta ve tolu kata hulenia kaka katiu ve kara kana polea katiu! Kava tolu mule te longoria matoto nazia e tania.” ");
INSERT INTO wiv_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Pale, na kaunsil kamahi kamana manumanu laveve dia ta madi laveve dia ta vamuga a Iesus zahe ni Pailat. ");
INSERT INTO wiv_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Dia ta koto kirina, dia ka tania, “Hita ta paria kaka kua e vairohia lohoihoia kana kahita manumanu. Ki tania ni dia, beta dia kata kadea takis vano ni Sisar. Ia ki tania ve ia a Kristus, na king.” ");
INSERT INTO wiv_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pale, a Pailat ia hulenia a Iesus, “Ia ho na king ke vuni Iuda, ai?” A Iesus ki kolia ki tania, “Ho mule tu tania kena.” ");
INSERT INTO wiv_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pale, a Pailat ia tania na hetpris kamahi kamana kabuna manumanu, “Hau beta na paria goloa zaha katiu kaka kua e katia kata koto kirina vona.” ");
INSERT INTO wiv_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Palaka dia ta ma varidi dia ka tania, “E lala kete papadea magalina manumanu laveve ni Iudea na kana vaketeketea, dia kata varihubi kamani gavman. E varivuvu ni Galili kua kini mai bele ri kua.” ");
INSERT INTO wiv_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","A Pailat ki longo baraenia ia hule, “Kaka kua ia bukuni Galili, ai?” ");
INSERT INTO wiv_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Kamana a Pailat ki longo baraenia habuka a Iesus ia e bukuna palaka kena a Herot e hada vona, ia geria vano ni Herot. Kilaka kua a Herot, ia ve ia ni Ierusalem. ");
INSERT INTO wiv_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","A Herot e hilohilo matoto, kilaka kua ti hada a Iesus, na vuna e longoria rereka ki kukulina matoto kete hadavia muga za. E lohoia a Iesus kete katia mirakel katiu ia ni hadavia. ");
INSERT INTO wiv_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Kubarae a Herot ki hulenia a Iesus na hulea luba, palaka a Iesus beta ni kolia kana hulea. ");
INSERT INTO wiv_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Na hetpris kamahi kamana tisa kamahi kara lo dia ta madi zahe dia ka matuha matoto dia ka papadea polea kirina. ");
INSERT INTO wiv_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","A Herot kamana kana soldia kamahi dia ta hilenia dia ka pole vamelimeli kirina. Dia ta vazohoria na zohozohoa mata muli katiu, dia ta geri mulehia vano ni Pailat. ");
INSERT INTO wiv_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Kilaka pamuhi za kena, a Herot hiro a Pailat hiro ta poroman, muga vona, hiro ta lala hiro ta vavarizahati. ");
INSERT INTO wiv_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pale, a Pailat ia koi lupunia na hetpris kamahi, kamana pararaha kamahi, ia mai na manumanu, dia ta mai lupu, ");
INSERT INTO wiv_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ia tania ni dia, “Miu ta pelea kaka kua ki mai ni niau miu ka tania ia e papadea magalina manumanu, dia kata varihubi kamani gavman. Palaka kava te hulenia na matamiu laveve kene paria habuka beta ni katia goloa katiu kena miu ta papadea vona. ");
INSERT INTO wiv_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","A Herot ve e paria habuka beta ni katia goloa katiu, na vuna ia e geri mulehia kini vamule ni dolu. Kaka kua beta ni katia goloa katiu kua e dangea kete hubi matoa vona. ");
INSERT INTO wiv_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Kubarae, da ta tania dia ka vihia za, hau ta vatia ia vano.” ");
INSERT INTO wiv_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Manumanu laveve dia ta lupu goe dia ka tania, “Hubi matehia! Vagotalania a Barabas ni mai ni hita!” ");
INSERT INTO wiv_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","A Barabas e vahohora na karabus na vuna kua e vamuga na varihubia kamani gavman na poloka taon ki hubi matehia ve kaka. ");
INSERT INTO wiv_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","A Pailat e kulina matoto kete vatia a Iesus ni vano, kubarae ia huleni mulehidia, habuka a Iesus kete gotala mule. ");
INSERT INTO wiv_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Palaka dia ta dopa goe dia ka tania, “Havenia na kruse! Havenia na kruse!” ");
INSERT INTO wiv_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","A Pailat ia hulenidia ve boto toluna, “E kuziha matoto? Maki zaha zia kaka kua e katia? Hau beta na paria vuvuna katiu kua ma ia kete mate vona. Kubarae kata geu dia na vihia za hau ta vatia ia vano.” ");
INSERT INTO wiv_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Palaka manumanu dia ta ma vavaridi, dia ka goe kapopou dia ka tatania habuka kete haveanga ia na kruse. Kubarae kadia goea ia katia a Pailat ia pokizia kana lohoihoia. ");
INSERT INTO wiv_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pale, a Pailat ia tara na kadia hulea. ");
INSERT INTO wiv_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ia vagotalani mulehia na kaka kua dia ta huhule kirina, kaka kua e taruha na karabus taraka kua e kakatia varihubia kamani gavman na poloka taon ki hubi matehia ve kaka. Ia vala a Iesus vano na limadia, dia kata katia nazia kua e kukulidia dia kata katia vona. ");
INSERT INTO wiv_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Na soldia kamahi dia ta pelea a Iesus vano, dia ta vano na dala, dia ta haba taduria a Saimon, kaka kua ia bukuni Sairini, ia e pe na hatamara taon ki mai kete hoho na taon, dia ta valuga na kruse, dia ta geria ia luga kini muri ni Iesus. ");
INSERT INTO wiv_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Kabuna manumanu kapou matoto dia ta mumuri vona. Na tavivine taza na poloka manumanu kua dia ta huhubia kadia kuku, dia ka tatangizia. ");
INSERT INTO wiv_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","A Iesus ia tare poki ki tania ni dia, “Tavivine bukuni Ierusalem, taua miu na tangiziau; miu tangizimiu mule kamani habu tutumiu. ");
INSERT INTO wiv_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Na vuna damana vona kua ti mamai kua da manumanu dia ta tani barae, ‘Miu hilohilo, miu tavivine kua miu ta kupi, ki beta miu na valohia kapiru katiu, ki beta ve miu na vazuzia kapiru katiu!’ ");
INSERT INTO wiv_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Na dama kena da manumanu dia ta tania kara potuna kamahi, ‘Dua langalanga kirihita!’ Dia ka tania ve kara potuna kotekote kamahi, ‘Kari havutihita!’ ");
INSERT INTO wiv_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Na vuna kua, dia na katia goloaloa kamahi kua kara hai kua e ba puripuria, da e kuziha kua ta na hai ni vano ni koga.” ");
INSERT INTO wiv_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Tamohane rua, hiro na raskol, hiro ve ta peloa kamani Iesus hiro kata hubi matoa kamana. ");
INSERT INTO wiv_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Kamana dia ka vano bele na palaka kua e kohanga na “Togana Bakana Kaka Mate,” dia ta havenia a Iesus na kruse, kamana mata vanaho karua kua, katiu na paligena kiri maroro, katiu na paligena kiri mauri. ");
INSERT INTO wiv_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","A Iesus ia tania, “Tamagu, lohoi bala kadia manaunaua, beta dia na lala nazia dia ta kakatia.” Pale, dia ta pilae satu kara kana zohozohoa kamahi. Dia kene varidangeai vona. ");
INSERT INTO wiv_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Manumanu dia ta madi dia ka lalavu, kadia pararaha dia ka pole valabilabi kirina, dia ka tania, “E kodonia nuhu motumotu; ko vatia ni kodoni mulehia, kua ta ia ni matoto ia a Kristus, kua a Vuvu e makia.” ");
INSERT INTO wiv_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Na soldia kamahi dia ta mai zahe ve pole valabilabi kirina. Dia ta vala na vaen viniga vona, ");
INSERT INTO wiv_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","dia ka tania, “Kini ho king ke vuni Iuda vaikoli kiriniho mule.” ");
INSERT INTO wiv_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","E vapolunganga notis katiu ki taruha na kruse monge langa vona, e tani barae: KAKA KUA IA NA KING KE VUNI IUDA. ");
INSERT INTO wiv_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Na raskol katiu kena e hahave kamani Iesus e pole habakabaka ki tania kiri Iesus, “Beta ni ho a Kristus? Vaikoli kiriniho mule, ku vaikoli ve kirimiro!” ");
INSERT INTO wiv_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Palaka ruana raskol kua ia pole kirina, ki tania, “Beta nu kuahinia a Vuvu? Toro ve da to ta mate balika ia. ");
INSERT INTO wiv_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","To kata mate kua, ia e mahoto na vuna to ta pelea kadoana kado moge zahazaha. Palaka kaka kua beta ni katia goloa katiu ni zaha.” ");
INSERT INTO wiv_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Pale, ia tania, “Iesus, lohoiau, kua kunu kara king.” ");
INSERT INTO wiv_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","A Iesus ia kolia vona ki tania, “Hau ta tani matotonia ni niho, meni kua da ho tu kamaniau ni Paradiso.” ");
INSERT INTO wiv_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ti 12 kilok barae, pale, na rodo kapou ia kari havutia malala laveve ki vano ki mule na 3 kilok, ");
INSERT INTO wiv_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","voro beta ni tiba. Na lavalava kena e hahave na poloka tempel ia tere ki dihu rua. ");
INSERT INTO wiv_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","A Iesus ia goe kapou matoto ki tania, “Tamagu te taruhia vulegu na lima.” Kamana ki tani barae, ia mate. ");
INSERT INTO wiv_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Na kepten kara soldia kamahi e hadavia nazia kua e bele, ia vazahenia hizani Vuvu ki tania, “E limoha kaka kuari ia kaka mahoto katiu!” ");
INSERT INTO wiv_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Manumanu laveve kua dia ta lohu, kamana dia ka hadavia goloa kua e bele, dia ta hubia kadia kuku, dia kene vamulemule. ");
INSERT INTO wiv_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Palaka nuhu kua dia ta lala kemikemihia a Iesus, kamana tavivine kua dia ta muri vona za ni Galili dia ka mai, dia ta madi zau pitu dia ka hahada. ");
INSERT INTO wiv_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Kaka katiu hizana a Iosep, ia na kaunsil katiu. E kaka kemi matoto, ia ki kaka mahoto. ");
INSERT INTO wiv_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ia beta ni magali katiu kamana kadia lohoihoia kua dia ta katia. Ia e bukuna taon a Arimatea, ni Iudea. Ki lala kete guguru kara kingdom ke Vuvu. ");
INSERT INTO wiv_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ia zahe bele ni Pailat ia hulenia kara podani Iesus. ");
INSERT INTO wiv_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pale, ia pelea zipa na kruse, ia kukulia na lavalava kavukavua, ia vano taruhia na poloka lovo e katua na poloka kedo, lovo kua ma beta ni tavuanga kaka katiu vona. ");
INSERT INTO wiv_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ia na Praide kua, damana vaihidahidanga na goloa kara Sabat. Kozoho Sabat keteni varivuvu. ");
INSERT INTO wiv_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Tavivine kua dia ta kamani Iesus dia ka pe ni Galili za dia ka mai, dia ta muri ni Iosep vano dia ka hadavia na lovo, dia ka hada ve na palaka kua a Iesus e vangoroa vona. ");
INSERT INTO wiv_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Pale, dia ta vamule kara kadia ruma, dia ta vaida pefium kamana goloa taza ve kua e hubi papa. Palaka, ti Sabat kubarae beta dia na gala vona, habuka na lo e tania. ");
INSERT INTO wiv_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Na Sande na damadama matoto, na tavivine kamahi kua dia ta vamule kara matmat kamana pefium kamahi kua dia ta vaida. ");
INSERT INTO wiv_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Dia ta hada na kedo kua e tabara havana lovo vona ti puke kakavanga, ");
INSERT INTO wiv_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","pale, dia ta hoho, palaka beta dia na paria na podana Paraha, a Iesus. ");
INSERT INTO wiv_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Dia ta ba madi dia ka lohoi tori barae, na kaka rua, kahiro zohozohoa e hada balika balangana voro, hiro ta bele valutu, hiro ta madi kamadia. ");
INSERT INTO wiv_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Tavivine kamahi kua dia ta kuahi zahazaha matoto dia ka tiro vatudu kara garigari, palaka na tamohane karua kua hiro ta hulenidia, “E kuziha miu ka hahada kara kaka kua e mahuri na poloka matmat? ");
INSERT INTO wiv_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Beta ia ri kua; kava ti mahuri mule! Miu ta lohoia kua e tania ni miu muga, kilangata kua e mimia kamamiu ni Galili? ");
INSERT INTO wiv_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Tuna Kaka da e valanga na limana nuhu zahazaha, ki haveanga ia na kruse, na dama toluna vona da e mahuri mule.’” ");
INSERT INTO wiv_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Pale, dia te ba lohoi mulehia kana polea. ");
INSERT INTO wiv_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Kamana dia ta pe na matmat dia ka vamule, dia ta tania goloa laveve kua na kana 11 disaipel kamahi, ia mai dia laveve kua dia ta lala dia kata kakamani Iesus. ");
INSERT INTO wiv_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Hizana tavivine kamahi kua ia, a Maria Makdalena, a Joana, a Maria titinani Jems, ia mai tavivine laveve kua dia ta kakamadia, ia dia kua dia ta kalohunia goloa kua na apostel kamahi. ");
INSERT INTO wiv_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Palaka na apostel kamahi beta dia na bilipim tavivine kamahi kua, dia ta lohoia dia ka tania dia ta tani vetania polea. ");
INSERT INTO wiv_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Palaka a Pita, e di madi ia rovo vano kara matmat. E tiro vatudu ia tunga hoho, ia hada na lavalava kamahi kua e kukula a Iesus vona, dia te ngoro vetaveta, ia vamule vano, ki lolohoi toritori na goloa kua ti bele. ");
INSERT INTO wiv_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Kilangata kua ve na tamaninikidia rua hiro ta vavano kara malala kote katiu kohanga ni Emaus, e hada barae, e 7 mael, kua tanu pe ni Ierusalem nu vano kirina. ");
INSERT INTO wiv_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Hiro ka popole na goloa laveve kua e bele. ");
INSERT INTO wiv_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Kamana hiro ka popole na goloaloa kamahi kua, a Iesus mule ia mai bele kini vavana kamahiro; ");
INSERT INTO wiv_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","hiro ta hadavia palaka beta hiro na hada lala. ");
INSERT INTO wiv_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","A Iesus ia hulenihiro, “Nazia mo ta rua vavana mo ka popole vona?” Hiro ta madi, matahiro e vari matoto. ");
INSERT INTO wiv_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Katiu ni hiro, hizana a Kleopas, e hulenia a Iesus, “Ho tu ba bele ni Ierusalem? Beta nu lala nazia kua e bebele na dama kamahi kua?” ");
INSERT INTO wiv_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ia hule, “Na goloa zia?” Hiro ta tania, “Na vuna ni Iesus bukuni Nasaret. Ia na profet katiu, kana polea matuhara vona ki katia galanga matuha na matani Vuvu kamana manumanu. ");
INSERT INTO wiv_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Na hetpris kamahi kamana kahita pararaha dia ta koto kirina na gavana kete tania dia na hubi matehia, pale, dia kene havenia na kruse; ");
INSERT INTO wiv_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","palaka hita ta vaka maroro habuka, da ia ti na kaka kua kete pele mulehia a vuni Israel. Ki vano ve, kua ti dama toluna vona kua, muri na goloaloa laveve kua e bele. ");
INSERT INTO wiv_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ki vano ve, kahita tavivine taza dia ta katihita, hita ka lohoi tori. Dia ta vano kara matmat na damadama, ");
INSERT INTO wiv_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","palaka beta dia na paria podana. Dia ta mai mule tania ni hita habuka, dia ta hada na visen na engel kamahi. Na engel kamahi dia ka tania ni dia habuka ia ti mahuri mule. ");
INSERT INTO wiv_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Pale, tamaninikihita taza dia ta vano kara matmat, dia ta paria ia e habuka kua za na tavivine kua dia ta tania, palaka beta dia na hadavia a Iesus.” ");
INSERT INTO wiv_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","A Iesus ia tania kirihiro, “Beta kamiu lohoihoia, ki beta ve miu na lala miu kata bilipim tapu polea kua na profet kamahi dia ta tatania varira! ");
INSERT INTO wiv_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Karae beta a Kristus kete pelea bizea kamahi kua ba muri a Vuvu kini vala naba kapou matoto vona kamana glori na lagato?” ");
INSERT INTO wiv_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Pale, a Iesus ia tani kemikemihia ni hiro na vuvuna polea kamahi kua na poloka buk ke Moses, ia mai ve kua na buk kana profet kamahi kua dia ta vapolungania dia ka popole vona mule. ");
INSERT INTO wiv_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Kamana dia ka vano kozoho na malala kua dia ta vavano kirina, a Iesus ia ma vana habuka kete ma ni pe liuliu. ");
INSERT INTO wiv_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Palaka hiro ta bada matoto hiro ka talea hiro ka tani barae, “Mai kamamiro, na vuna ti garavi kava, keteni marigo kua.” Pale, ia vano kamahiro kara kahiro ruma. ");
INSERT INTO wiv_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Tania ki mia kamahiro na tebol kete hanihani, ia pelea na bret, ia hate motunia tamana, ia bara vulahia ia vala ni hiro. ");
INSERT INTO wiv_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Pale, matahiro ia ti vutu hiro te ba hada lala, a Iesus ia balavutuka ni hiro. ");
INSERT INTO wiv_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Hiro ka tania kirihiro mule, “Te, kua to ka hatunia e habuka haroho e dudulu na polokodoro, kua kilangata na dala, kua e tatani kavakava na polealea kua e vapolunganga na poloka buk ke Vuvu.” ");
INSERT INTO wiv_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Pale, hiro ta di madi, hiro ta vamule kiri Ierusalem. Hiro ta paria na 11 disaipel kamahi kamana nuhu kena dia ta kakamadia, dia ta lololi lupu. ");
INSERT INTO wiv_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Na apostel kamahi dia ta tania ni hiro, “E matoto! Na Tubu ti mahuri mule kava. E bele ve ni Saimon.” ");
INSERT INTO wiv_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Pale, hiro ve hiro ta kalohunia nazia kua e bele ni hiro na dala, kua hiro kene hada lala vona, kua ia ti bara vulahia na bret. ");
INSERT INTO wiv_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Kamana dia ka ba popole barae na goloa kua, a Iesus ia bele valutu ia madi na pidaka dia ki tania ni dia, “Magali kemia ni miu.” ");
INSERT INTO wiv_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Palaka dia ta ridi dia ka kuahi, dia ta hada dia ka lohoia dia ka tania ia na hanitu katiu. ");
INSERT INTO wiv_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ia ki tania kiridia, “E kuziha miu ka ridi, miu ka lohoi toritori? E kuziha miu ka lohoi ruarua? ");
INSERT INTO wiv_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Miu hadavia limagu kamana kabegu. Hau za kua! Miu vakuliau miu na hatunia; hanitu beta midana kamani togana, balika kua miu ta hada ni niau.” ");
INSERT INTO wiv_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","E tani hozovia polea kua, ia vatunga limana kamana kabena ni dia. ");
INSERT INTO wiv_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Dia ta hilohilo matoto palaka ma beta dia na bilip, dia ka ba lohoi toritori, ia hulenidia, “Goloa katiu vona miu kata hania kua?” ");
INSERT INTO wiv_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Dia ta vala na dihura hiha tunua vona, ");
INSERT INTO wiv_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ia pelea kini hania na matadia laveve. ");
INSERT INTO wiv_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Pale, ia tania ni dia, “Kua ia na goloa ta ba vovona kamamiu ka tatania ni miu kua. Goloa laveve muga dia ta vapolungania kiriniau na poloka lo ke Moses, na poloka buk kana profet kamahi ia mai na poloka Buk Song, goloaloa laveve kena e vapolunganga ia kete pori matoto.” ");
INSERT INTO wiv_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Pale, ia kodonidia, damadia kini kavakava, dia kene lohoi lala na vuvuna polea na poloka buk ke Vuvu. ");
INSERT INTO wiv_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ia tani barae ni dia, “E vapolu baraenga na poloka buk ke Vuvu: A Kristus da e luga bizea kapou, na dama toluna vona, ia mahuri mule na matea. ");
INSERT INTO wiv_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Na hizana, da dia ta tani kakava na manumanu laveve na garigari, dia kata pokizia magalidia, a Vuvu ni lohoi bala kadia manaunaua. Da e varivuvuanga ni Ierusalem. ");
INSERT INTO wiv_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Miu mule miu ta hada na matamiu matoto goloaloa laveve kua e bele. ");
INSERT INTO wiv_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Hau da ta geria na Vule Tumonga ki ziho ni miu. Habuka kua a Tamagu ti mapamapa ni miu varira. Palaka, miu ma mia ni Ierusalem ki vano ki mule na dama kua miu kata pelea matuhanga kua kete pe na lagato ni ziho.” ");
INSERT INTO wiv_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Pale, a Iesus ia peledia vano gotala ni Ierusalem kiri Betani, ia vazahenia limana ia hulenia a Vuvu kete kati kemihia ni dia. ");
INSERT INTO wiv_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Kamana ki ba blesimdia barae, a Vuvu ia pelea zahe kara lagato. ");
INSERT INTO wiv_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Dia ta lotu vona. Dia ta hilohilo matoto dia kene vamule kiri Ierusalem. ");
INSERT INTO wiv_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Dama laveve dia ta ma mia na poloka tempel, dia ka vavazahenia hizani Vuvu. ");
INSERT INTO wiv_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Na varivuvuka matoto kua ma beta goloa katiu ni bele, na Polea kava ia ti bele, na Polea ia e kamani Vuvu, na Polea ia a Vuvu. ");
INSERT INTO wiv_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Na varivuvuka matoto, ia e kamani Vuvu. ");
INSERT INTO wiv_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","A Vuvu e katia goloaloa laveve vona, ni beta ia, mara beta goloa katiu kua ti bele kava, ni bele. ");
INSERT INTO wiv_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Na mahuria ia vona. Na mahuria kua ia na laet kana manumanu laveve. ");
INSERT INTO wiv_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Na laet kua e hada na poloka rodo, palaka na rodo e hada, ki beta ni lohoi lala. ");
INSERT INTO wiv_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Na kaka katiu a Vuvu e geria hizana a Jon. ");
INSERT INTO wiv_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ia e mai kete tania na manumanu na vuna na laet kua, manumanu laveve dia kata bilip na laet kua. ");
INSERT INTO wiv_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ia mule beta ia ni na laet, palaka ia e geura kete mai ni vatuharia polea na laet. ");
INSERT INTO wiv_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Na laet kua ia na laet matoto kua e lala kete vala hadanga na manumanu laveve, ia keteni ziho kara vulovulo. ");
INSERT INTO wiv_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Palaka na Polea kua ia ri na vulovulo, na vulovulo ve ia e katua na Polea kua, palaka vulovulo beta ni hada lala. ");
INSERT INTO wiv_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Na Polea kua e ziho na kana malala mule, palaka kana manumanu mule beta dia na pelea. ");
INSERT INTO wiv_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Palaka manumanu laveve kua dia ta pelea, dia ka bilip ve na hizana, ia e vala na matuhanga ni dia, dia kata kara habu tutuni Vuvu. ");
INSERT INTO wiv_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Kapirupiru kua, beta dia na kara tuni Vuvu na vuna na toponi habu tamadia kamani habu titinadia, o na hatuhatua kara livuha o na lohoihoia kana kaka katiu, beta, a Vuvu mule e katidia dia ka kara tuna. ");
INSERT INTO wiv_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Na Polea ti bele kini kara tinoni, kini mia na pidaka dolu. Hita ta hadavia kana glori. Na glori kua e valanga vona habuka ia na Tuni Vuvu katiu papa za. Ia e vonu na mahariharia kamana polea matoto. ");
INSERT INTO wiv_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","A Jon ia ti kavakavania kaka kua. Ia e goe ki tani barae, “Ia kua na kaka kua, kua ta tani barae vona, ‘Azei kua e muri ni niau, ia e dopa ki hizanga, na vuna ia e muga ni niau.’” ");
INSERT INTO wiv_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Na kana mahariharia e vonu matoto. Na vuna na kana mahariharia kapou kua, ia ti kati kemikemihia matoto ni dolu. ");
INSERT INTO wiv_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Na vuna na lo, ia e valanga ni Moses. Palaka na mahariharia kamana polea matoto ia e pe ni Iesus Kristus ki mai. ");
INSERT INTO wiv_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Beta kaka katiu ni hadavia a Vuvu, a Tuni Vuvu, kua e lala kete mimia na kitaki Tamana, ia ti katia tolu kene lala a Vuvu. ");
INSERT INTO wiv_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Kua na polea ke Jon kua, kilaka a vuni Iuda dia ta geria na pris kamahi kamana Livai kamahi dia ka vano vona, dia ka huleni baraenia, “Ho azei?” ");
INSERT INTO wiv_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","A Jon beta ni lingania polea, ia e tani kakava polea ki tani barae, “Beta ni hau a Kristus.” ");
INSERT INTO wiv_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Dia ka hulenia, “Pele ho azei? Ho a Elaija?” Ia ki tania, “Beta.” Dia ka hulenia ve, “Pele ho na profet kua hita ta guruguru kirina?” Ia ki tania, “Beu.” ");
INSERT INTO wiv_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Dia ka hulenia, “Pele ho azei matoto? Koli kemihia polea katiu ni hita, hita kata vano tania na nuhu kua dia ta gerihita, hita ka mai. Ho tu tani ziha matoto ni niho mule?” ");
INSERT INTO wiv_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","A Jon ki tania ni dia, “Hau na halingana kaka kua e gogoe na poloka deset, ‘Miu vahotovia dala kana Paraha ni mahoto.’” Habuka kua a profet Aisaia e tania. ");
INSERT INTO wiv_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","A vuni Parisi dia ta geria manumanu taza ve dia ka mai, ");
INSERT INTO wiv_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","dia ka hulenia a Jon, “Beta ni ho a Kristus, beta ni ho a Elaija, o na profet katiu. E kara zia ku vazuguzugu?” ");
INSERT INTO wiv_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","A Jon ki kolia ki tania, “Hau ta vazuguzugu na naru. Palaka kaka katiu kena e mamadi na pidaka miu, beta miu na lala. ");
INSERT INTO wiv_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ia e muri ni niau, hau beta na kemi na dangea kata hulia na sandel na kabena.” ");
INSERT INTO wiv_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Goloaloa kamahi kua e bele ni Betani na paligena naru a Iordan, na palaka kua a Jon e vavala baptais vona. ");
INSERT INTO wiv_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Na dama muri vona, a Jon e hadavia a Iesus e vavana ki mamai kete mai vona, ia tani barae, “Miu hadavia, na Tuna sipsip ke Vuvu, kua kete pele kakava na moge zahazaha kana manumanu laveve na garigari. ");
INSERT INTO wiv_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ia na kakanaka za kua kilaka ta popole vona ka tani barae, ‘Na kaka katiu kua e ba mumuri ni niau, ia e dopa ki hizanga ni niau, na vuna ia e muga za ki mimia, ba muri hau kene valohua.’ ");
INSERT INTO wiv_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Hau mule beta na lala ia, palaka ia na vuvuna kua hau te bele kene vavala baptais na naru, kete katia, ia ni bele kakava ni vuni Israel.” ");
INSERT INTO wiv_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Pale, a Jon ia tani kakava baraenia, “Hau ta hadavia na Vule Tumonga e pe na lagato vinaka balu ki ziho mia na huduna. ");
INSERT INTO wiv_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Hau mara beta na hada lala, palaka kaka kua e geriau kata vazuguzugu na naru, ia e tani barae ni niau: Azei kua kunu hadavia na Vule Tumonga e ziho na huduna, ia kaka kena da e vavala baptais na Vule Tumonga. ");
INSERT INTO wiv_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Hau kava te hadavia kene tani kakava ni miu habuka ia, ia na tuni Vuvu.” ");
INSERT INTO wiv_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Na dama muri vona a Jon e mamadi kamana kana disaipel rua; ");
INSERT INTO wiv_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","kamana ki hadavia a Iesus e vana hutu, ia tania ni hiro, “Hadavia, na Tuna sipsip ke Vuvu kuari.” ");
INSERT INTO wiv_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Kamana kana disaipel karua hiro ka longoria ki tani barae, hiro ta muri ni Iesus. ");
INSERT INTO wiv_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","A Iesus ki tare poki, ki hadavihiro kua hiro ta mumuri, ia hulenihiro, “Nazia kulimoro kirina?” Hiro ka tania, “Rabai (mining na polea kua ‘Rabai’ ia ‘Tisa’), tu ngongoro ni ve?” ");
INSERT INTO wiv_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ia ki tania ni hiro, “Mo mai mo na hadavia.” Pale, hiro ta vano hadavia ruma kua e lala kete ngongoro vona, kilangata kua hiro ta ma mia kamana, na vuna ti 4 kilok na garavi. ");
INSERT INTO wiv_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","A Andru, tazini Saimon Pita, ia katiu ni hiro kua e longoria, nazia kua a Jon e tania, ia kini muri ni Iesus. ");
INSERT INTO wiv_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ia vano ia kaze pamuhi kiri tazina a Saimon, ia tania vona, “Hita te paria na Mesias kava.” (Ia Kristus.) ");
INSERT INTO wiv_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ia kohania vano ni Iesus. A Iesus ki hadavia, ia tania, “Ho a Saimon, tuni Jon te, pele da tu kohanga ni Kepas.” (Hiza kua a Kepas ia a Pita za, mining vona e tani barae, “Kedo.”) ");
INSERT INTO wiv_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ti dama mule ve, a Iesus ia lohoia kete vano kiri Galili. Ia vano paria a Filip ia tania vona, “Mai muri ni niau.” ");
INSERT INTO wiv_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","A Filip ia bukuna taon a Betsaida, ia na taon ke Andru kamani Pita ve. ");
INSERT INTO wiv_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","A Filip e vano paria a Nataniel ia tania vona, “Hita te paria na kaka kua a Moses e vapolungania na buk kara lo ki popole vona ia mai kua na profet kamahi ve kua dia ta vapolupolu dia ka popole vona. Ia a Iesus tuni Iosep, bukuni Nasaret.” ");
INSERT INTO wiv_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","A Nataniel ki tani barae vona, “Nasaret? E dangea goloa kemi katiu kete bele ra kena?” A Filip ki tania vona, “Mai ho tu hadavia.” ");
INSERT INTO wiv_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Kamana a Iesus ki hadavia a Nataniel kua e vana ki mamai, ia tani barae, “Ia kua na kaka Israel matoto kua. Beta ni lala kete vavairuku!” ");
INSERT INTO wiv_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","A Nataniel ki hulenia, “Ho tu lala zinganiau?” A Iesus ki tania vona, “Ba muri a Filip kini kohaniho, hau kava te hadaviho kena tu mimia na vuvuna haina fik.” ");
INSERT INTO wiv_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","A Nataniel ki tania, “Rabai, ho na tuni Vuvu, ho na King ke Israel.” ");
INSERT INTO wiv_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","A Iesus ki tania vona, “Tu bilip na vuna zia te tania ni niho kua ta hadaviho na taura haina fik. Ta tania ni niho, da tu hadavia goloa kapoupou dopa na kua.” ");
INSERT INTO wiv_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","A Iesus e tani barae ve vona, “Ta tani matotonia ni miu, da miu ta hadavia lagato e ngapa. Miu ka hadavia na engel kamahi ke Vuvu dia ta ziziho dia ka zazahe na huduna Tuna Kaka.” ");
INSERT INTO wiv_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ti dama tolu muri na kua, na lahia katiu e bele na taon a Kana, ni Galili. A titinani Iesus a Maria, ia kilangata ia ve na lupua kara lahia kua. ");
INSERT INTO wiv_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","A Iesus kamana kana disaipel kamahi dia ve ta kohanga kara lupua na lahia kua. ");
INSERT INTO wiv_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Kilaka kua dia ta hinu vano, hadia vaen ia hozo. A tinani Iesus ia pole kamani Iesus ki tania vona, “Hadia vaen ti hozo.” ");
INSERT INTO wiv_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","A Iesus ki tania, “Titinagu, beta ni kagu galanga o beta ve ni ka galanga kena. Kagu dama ma beta ni mai.” ");
INSERT INTO wiv_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","A tinana ki tania na voravora kara ruma kua, “Nazia kua ia kini tania ni miu, miu kakatia za.” ");
INSERT INTO wiv_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Na ruma kua, na sospen e 6 e katua na kedo, katiukatiu na sospen kua e dangea kete valikira 20 o 30 galen na naru kara poloka. Dia ta lala dia kata mamatu na naru kua, muri na kadia moge a vuni Iuda, kua kete katia dia na klin. ");
INSERT INTO wiv_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","A Iesus ki tania na voravora kamahi kua, “Miu hituhitu naru, miu na valikiliki kara poloka sospen kamahi kena.” Pale, dia ta hituhitu naru kara poloka sospen kamahi kua, ki vonu kalavuruvuru matoto. ");
INSERT INTO wiv_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ia ki tania ni dia, “Miu hituvia taza, miu na vano vala na kaka kua e hada na hanihania kua.” Pale, dia ta hituvia dia ta pelea vano. ");
INSERT INTO wiv_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Kamana na kaka kua e hada na hanihania kua ki hinumia na naru kua, kava ti kara vaen, palaka ki beta ni lala na vaen kua e pe ve. Palaka na voravora kua dia ta hituvia naru dia ta lala. Na kaka kua e hada na hanihania kua, ia kohania na tamohane kua e ba lahi, ");
INSERT INTO wiv_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ki tania vona, “Manumanu laveve dia ta lala dia kata muga vanginuvia manumanu na vaen kua e dopa ki kemi, ba muri manumanu ti spak, dia te ba vanginuvia manumanu na vaen kua beta ni dopa ni kemi. Palaka ho, ho tu taruhia vaen kua e kemi kiri muri, kua kunu ba vala na manumanu.” ");
INSERT INTO wiv_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","A Iesus e katia na mirakel kua ni Kana ni Galili, ia na varivuvuka kana mirakel kamahi laveve kua ba muri kini kakatia. Kilangata ia ti vatunga kakava kana glori; kana disaipel kamahi dia kene bilip vona. ");
INSERT INTO wiv_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ba muri na kua, ia ziho kiri Kaperneam kamani titinana ia mai habu tazina kamana kana disaipel kamahi. Dia ta mia dama taza na taon kua. ");
INSERT INTO wiv_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ti kozoho kara damana hanihania kapou na Pasova, a Iesus ia zahe kiri Ierusalem. ");
INSERT INTO wiv_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","E zahe na poloka tempel ia hadavia manumanu kua dia ta salinia bulmakau, sipsip ia mai balu kamahi ve, taza ve dia ta lololi dia ka pokipoki moni. ");
INSERT INTO wiv_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Pale, ia katia nivihi katiu na baklaen, ia vaibura kamadia, kamana kadia sipsip kamana bulmakau kamahi dia ta gotalatala na tempel; ia valiki taduria moni kana nuhu kua dia ta pokipoki moni ki vapopo vatuduhia kadia tebol kamahi ve. ");
INSERT INTO wiv_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ki tania na nuhu kua dia ta salinia na balu kamahi, “Miu vilehia goloaloa kamahi kena miu na gotalatala ri kua! Taua miu na kakatia ruma ke Tamagu ni kara rumaka maket!” ");
INSERT INTO wiv_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Kana disaipel kamahi dia ta lohoi mulehia habuka e vapolu baraenga na polea ke Vuvu, “Hau e kuligu matoto kara ka ruma, hatuhatua kua, e habuka haroho kua e dudulu na polokogu.” ");
INSERT INTO wiv_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","A vuni Iuda dia ta tania kirina, “Na mirakel zia da tu katia hita kata lala habuka a Vuvu e vala naba ni niho koto katia goloa kua tu ba katia?” ");
INSERT INTO wiv_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","A Iesus ki kolia ki tania, “Miu robea tempel kua, na dama tolu za, da ta vamadiri mulehia.” ");
INSERT INTO wiv_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","A vuni Iuda dia ka tania, “E pelea krismas e 46 kete habata tempel kua. Ho da tu vamadiri mulehia na dama tolu za?” ");
INSERT INTO wiv_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Palaka a Iesus ia beta ni popole na tempel, e popole na livuhana. ");
INSERT INTO wiv_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ba muri kua ia ti mahuri mule na matea, na kana disaipel kamahi dia te lohoi mulehia kana polea kua e tania; dia te bilip na polea kana Paraha ia mai na polea ke Iesus kua e tatania ni dia. ");
INSERT INTO wiv_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Kilaka kua, a Iesus ia ni Ierusalem na hanihania kapou kara Pasova, manumanu luba dia ta bilip vona, kilaka kua dia ta hada na mirakel kua ia e kakatia. ");
INSERT INTO wiv_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Palaka a Iesus beta ni vaka maroro ni dia, na vuna ia e lala kemikemihia manumanu laveve. ");
INSERT INTO wiv_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ki mara beta kaka katiu ni tania vona na moge kana manumanu. Ia mule kava ti lala kemikemihia poloka manumanu laveve. ");
INSERT INTO wiv_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Kaka katiu hizana a Nikodemus, ia na paraha katiu ke vuni Iuda. Ia ve e bukuna kabu ke vuni Parisi. ");
INSERT INTO wiv_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","E mai ni Iesus na marigo ki tania, “Tisa, hita ta lala ho na tisa tu pe ni Vuvu ku mai. Mara beta kaka katiu ni katia mirakel kamahi kua ho tu kakatia kua ni beta a Vuvu ni kakamana.” ");
INSERT INTO wiv_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","A Iesus ki kolia kana polea ki tania, “Ta tani matotonia ni niho. Mara beta kaka ni hadavia kingdom ke Vuvu kua tani beta ni valohu muleha.” ");
INSERT INTO wiv_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","A Nikodemus ki tania, “Da e valohu mulehi zihanga kaka kua ti lapun kava? E dangea kete hoho mule boto ruana na magalini titinana ni valohi mulehia?” ");
INSERT INTO wiv_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","A Iesus ki tania vona, “Ta tani matotonia ni niho. Mara beta kaka katiu ni hoho na kingdom ke Vuvu kua ta ia ni beta ni valohua ia na naru kamana Vule Tumonga. ");
INSERT INTO wiv_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Na kaka e pelea livuhana ni tamana kamani titinana. Palaka na Vule Tumonga ia e katia vuledolu ki mahuri. ");
INSERT INTO wiv_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Taua nu lohoi tori na polea kua ta tania, ‘Ho ma koto valohu muleha.’ ");
INSERT INTO wiv_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Na kavili e lala kete hahabi vano kara palaka kena ia e kulina kete vano kirina. Da tu longoria halingana, palaka mara beta nu lala e pe ve ki mai o kete kiri ve. Manumanu laveve kua e valohuadia na Vule Tumonga, ia da dia ta kubarae ve.” ");
INSERT INTO wiv_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","A Nikodemus ki hule, “Da e bele ziha kena?” ");
INSERT INTO wiv_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","A Iesus ki tania vona, “Ho na tisa ke vuni Israel, ki beta za nu lohoi lala goloa kamahi kua? ");
INSERT INTO wiv_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Hau ta tani matotonia ni niho. Hita ta popole na goloa kua hita ta lala, hita ka tatani kakava na goloa kua hita ta hadavia, palaka beta miu na pelea polea kua hita ta tatania. ");
INSERT INTO wiv_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ho beta nu bilip kua hau ta tatania ni niho na goloaloa bukuna garigari, pele da tu bilip ziha kua na tania ni niho na goloaloa bukuna lagato? ");
INSERT INTO wiv_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ma beta kaka katiu ni zahe na lagato, a Tuna Kaka za, kua ia e pe heta na lagato ki ziho. ");
INSERT INTO wiv_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ia e habuka za kua a Moses e vazahenia na matabunu kua e katua na bras na poloka deset, ia na Tuna Kaka ia kete vazahe bareanga ve. ");
INSERT INTO wiv_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Azei kua ni bilip vona, ia da e pelea mahuri roroa. ");
INSERT INTO wiv_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Na vuna a Vuvu e kulina matoto kara manumanu laveve na vulovulo, kubarae ia kini vala Tuna kua e katiu papa matoto, kua azei ho nu bilip vona, ia mara beta nu mate, palaka da tu pelea mahuri roroa. ");
INSERT INTO wiv_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Na vuna zia, a Vuvu beta ni geria Tuna ni ziho kara vulovulo kete koto kara manumanu, palaka kete pele mulehia manumanu na kadia manaunaua. ");
INSERT INTO wiv_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Azei kua e bilip vona, ia mara beta a Vuvu ni koto kirina, palaka azei kua beta ni bilip ni Iesus, ia kava ti koto kirua, na vuna ia beta ni bilip na hizani Tuni Vuvu kua ia e katiu papa. ");
INSERT INTO wiv_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","A Vuvu ia ti madi na lohoihoia kua kini koto kara manumanu; habuka na laet kava ti ziho na garigari, palaka manumanu, dia e kulidia matoto kara rodo, na vuna dia ta nuhuta moge zahazaha. ");
INSERT INTO wiv_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Na vuna manumanu laveve kua dia ta kakatia moge zahazaha ia beta matoto ni kulidia kara laet, ki mara beta dia na mai na laet, dia ta kuahi tabarae kadia mogemoge ni hada kavakavanga. ");
INSERT INTO wiv_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Palaka nuhu kua dia ta lala dia kata katia moge kua e matoto ki mahoto, ia dia ta lala dia kata mai madi kakava na laet. Manumanu laveve dia kata hada habuka ia e katia kana galanga na matuhanga ke Vuvu.” ");
INSERT INTO wiv_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Muri na kua, a Iesus kamana kana disaipel kamahi dia ta vano kara provins a Iudea ki mia kamadia dia ka vavala baptais na manumanu. ");
INSERT INTO wiv_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Kilaka kua a Jon ve ia e valavala baptais na manumanu ni Aenon kozoho ni Salim, na vuna zia naru motu vona, manumanu dia ka mamai, kete valanga baptais ni dia. ");
INSERT INTO wiv_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Kilangata kua a Jon ma beta ni karabusianga. ");
INSERT INTO wiv_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Na disaipel kamahi ke Jon, dia ta vaigege kamana kaka Iuda katiu na vuna na kadia makina matua kua kete katidia dia na klin mule na matani Vuvu. ");
INSERT INTO wiv_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Dia ta mai ni Jon. Dia ka tania vona, “Tisa, kaka kena kilangata e kamaniho na paligena rae na hiripa ni Iordan, kaka kena tu popole vona. Kuari ia ti vavala baptais na manumanu, e na manumanu laveve kini vavano vona.” ");
INSERT INTO wiv_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","A Jon ki tania, “Kua ni beta a Vuvu kua e heta na lagato ni vala goloa katiu na kaka katiu, ia mara beta kaka kena ni pelea goloa katiu. ");
INSERT INTO wiv_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Miu mule miu ta longoria kua ta tania muga habuka, hau beta na Kristus, palaka hau ta geura ka vamuga vona. ");
INSERT INTO wiv_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Kua kaka katiu kini kabania tavine katiu, ia tavine kena ia kana. Na ruana tamohane kua e ba lahi vahoru, da e madiri ki tabu longo; kua tani longoria balungana ruana kua, ia da ti hilohilo. Kubarae, hau ta hilohilo matoto kua. ");
INSERT INTO wiv_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Da ia hizana keteni papane, hau keteni ziziho mule. ");
INSERT INTO wiv_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Na kaka kua e pe heta ki ziho, ia e dopa ki hizanga na manumanu laveve; na kaka kua e bukuna garigari ia e bukuna garigari; ia ki popole na goloaloa bukuna garigari. Palaka na kaka kua e pe na lagato ki ziho, ia e dopa ki hizanga na manumanu laveve. ");
INSERT INTO wiv_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ia e popole na nazia kua ia e hadavia na matana matoto ki longoria matoto na talingana, palaka beta kaka katiu ni pelea kana polea ni tania e matoto. ");
INSERT INTO wiv_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Palaka azei kua e longoria kana polea ki tania e limoha ki vaka maroro vona, ia e habuka e tania a Vuvu ia e lala kete tani matotonia polea. ");
INSERT INTO wiv_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Na vuna zia na kaka kua a Vuvu e geria ki mai, ia e popole na polea ke Vuvu, na vuna a Vuvu ti vavonuhia na kana Vule Tumonga. ");
INSERT INTO wiv_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","A Tamana e kulina matoto kiri Tuna kini taruhia goloaloa laveve na limana. ");
INSERT INTO wiv_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Azei kua tanu bilip ni Tuna ia da tu mahuri roro, palaka azei ho kua nu pole katia mara beta nu hada mahuri roroa, na vuna zia magali varitihia ke Vuvu ia da ma ki ma ngongoro ni niho.” ");
INSERT INTO wiv_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","A vuni Parisi dia te longoria habuka a Iesus ti vala baptais na disaipel, kini livutia naba na manumanu kua a Jon e vala baptais ni dia. ");
INSERT INTO wiv_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Palaka a Iesus ia mule beta ni vala baptais na kaka katiu, kana disaipel kamahi za dia ta vala baptais. ");
INSERT INTO wiv_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Kamana a Iesus ki longoria polea kua, ia vatia a Iudea kini vano kiri Galili. ");
INSERT INTO wiv_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Na dala kua ia e pe vona, ia da e vano ki pe na pidaki Samaria. ");
INSERT INTO wiv_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Pale, ia vano bele na taon katiu ni Samaria, hizana a Sikar, kozoho na garigari kua a Jekop e vala ni tuna tamohane, a Iosep. ");
INSERT INTO wiv_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Na naru katiu varira a Jekop e hovia, ia na palaka kua nina ve. A Iesus e vavana na dala malaku ki buzabuza livuhana. Kubarae ia mia tadu na kitaka naru kua. ");
INSERT INTO wiv_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Na tavine Samaria katiu ti mai kete hituvia naru. A Iesus ia tania vona, “Vala naru pitu ka hinu.” ");
INSERT INTO wiv_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Kana disaipel kamahi dia te vano kara taon dia kata kadea haninga. ");
INSERT INTO wiv_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Na tavine Samaria kua ki tani barae vona, “Ho na Iuda kena hau na tavine Samaria. E kuziha ku huleniau kata vala naru nu hinu?” (Ia e tani barae na vuna a vuni Iuda kamani vuni Samaria, beta dia na lala dia kata lulupu o dia na hahanihani lupu.) ");
INSERT INTO wiv_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","A Iesus ki tania vona, “Kua ho nu lala na presen ke Vuvu, nu lala ve kaka kua e huhuleniho kara naru, ma tu hulenia, kini vala naru kua e lala kete katia manumanu dia na mahuri.” ");
INSERT INTO wiv_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Na tavine kua ki tani barae, “Mane, ho beta ka baket koto hituvia naru vona. Na naru ve e loloa marata. Da tu pelea naru kena kete katia manumanu dia na mahuri ni ve? ");
INSERT INTO wiv_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","A tubudolu a Jekop e hovia naru kua ki vala kahita. Ia e hinu vona, habu tutuna ve, ia mai kana bulmakau kamana kana sipsip kamahi ve. E ho tu tatania habuka ho tu dopa ku paraha ni Jekop?” ");
INSERT INTO wiv_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","A Iesus ki tania vona, “Manumanu laveve kua dia ta hinumia naru kua da e marahoti mulehidia. ");
INSERT INTO wiv_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Palaka azei tani hinumia na naru kua hau kata vala vona, da mara beta ni marahotia ve. Na naru kua hau kata vala ni dia da e kara naru kua e papado dama laveve ki vala mahuria ni dia, ki vala ve mahuri roroa ni dia.” ");
INSERT INTO wiv_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Na tavine kua ki tania vona, “Mane, vala naru kena ni niau kete beta kete ma marahotiau, kete beta ve kata ma mai ri kua na hitu naru.” ");
INSERT INTO wiv_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","A Iesus ki tania vona, “Vano kohania a go, mo ta vamule mai ri.” ");
INSERT INTO wiv_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Na tavine kua ki tania, “Hau beta gogu.” A Iesus ki tania vona, “Ho tu tani matotonia kena, kua tu tania beta a go. ");
INSERT INTO wiv_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ka polea e matoto, na vuna ho muga kava tu kabania tamohane ti lima kava. Na tamohane kua tu mimia kamana, beta ve ni go matoto.” ");
INSERT INTO wiv_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Na tavine kua ki tania vona, “Mane, hau te hadavia habuka ho na profet katiu. ");
INSERT INTO wiv_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Habu tamahita dia ta lala dia kata lolotu na potuna kua, palaka miu a vuni Iuda, miu ta tania na palaka kua kete lotu voa ni Vuvu, ia ni Ierusalem.” ");
INSERT INTO wiv_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","A Iesus ki tania vona, “Vine, bilip na kagu polea, na dama vona kua ti mamai, kua da ti mara beta manumanu dia na ma lolotu za ni Vuvu na potuna kua o ni Ierusalem za. ");
INSERT INTO wiv_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Miu vuni Samaria beta miu na lala azei matoto miu ta lolotu vona; palaka hita a vuni Iuda, hita ta lala azei hita ta lolotu vona. Na vuna zia a Vuvu ia ti tania da na vaikolia ia da e pe ni vuni Iuda. ");
INSERT INTO wiv_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Palaka na dama vona kua ti mamai, kua kava kini mai, kua da na manumanu ke Vuvu da dia ta lotu ni Vuvu na matuhanga kana Vule Tumonga, kamana moge kua e matoto. Na Vuna a Vuvu ia e kakaze kara nuhu mata barae kua dia kata lotu vona. ");
INSERT INTO wiv_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","A Vuvu ia na Vule, nuhu kua dia kata lotu vona, ia da dia ta lotu vona na matuhanga kana Vule Tumonga kamana moge kua e matoto.” ");
INSERT INTO wiv_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Na tavine kua ki tania, “Hau ta lala habuka a Mesias (kohanga ni Kristus) da e mai. Kua ia ni mai, ia da ti tani kakava goloa laveve ni hita.” ");
INSERT INTO wiv_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","A Iesus ki tania vona, “Hau kua kaka ta popole kamaniho, ia hau kaka kena za tu tatania.” ");
INSERT INTO wiv_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Hiro ta ba popole barae, na disaipel kamahi ke Iesus dia te pe na taon dia kene vamule. Dia ta ridi vona kua ia e popole kamana tavine katiu, palaka beta dia na hulenia tavine kua habuka e “kulina kara zia” o dia na hulenia a Iesus habuka “e popole kamana kara zia.” ");
INSERT INTO wiv_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Pale, na tavine kua ia vatia kana baket, ia vamule kara taon, ia tani barae na manumanu, ");
INSERT INTO wiv_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Miu mai miu na hada kaka katiu, ia e tani kakava kagu mogemoge laveve kua ta kakatia varira. Karae ia a Kristus?” ");
INSERT INTO wiv_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Pale, manumanu dia ta kamana tavine kua dia ta mai ni Iesus. ");
INSERT INTO wiv_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Kana disaipel kamahi dia ka tatania ni Iesus, “Pelea haninga katiu ku hania.” ");
INSERT INTO wiv_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Palaka a Iesus ki tania ni dia, “Hau, hagu haninga vona kata hania kua beta miu na lala.” ");
INSERT INTO wiv_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Na kana disaipel kamahi dia ta varihulei ni dia mule, dia ka tania, “Karae, kaka katiu ti vala haninga vona kava?” ");
INSERT INTO wiv_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","A Iesus ki tania ni dia, “Hagu haninga ia kata muri na lohoihoia kana kaka kua e geriau ka mai, kata vahozovia ve kana galanga. ");
INSERT INTO wiv_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Miu ta lala miu kata tani barae, ‘Lingabo garamo ba vovona, ba muri tolu kene pelea haninga na vanua.’ Ta tania ni miu, miu vukazia matamiu, miu na hadavia vanua kamahi, haninga kamahi ti matuha kava. Ma keteni peola haninga voa vona! ");
INSERT INTO wiv_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Na vuna na kaka kua e pelepele haninga na vanua ia ti kakadoa kava, ia kini nihabuhabu na palekana haninga kara mahuri roroa, kubarae na kaka kua e vazohia haninga kamana kaka kua e pelepele haninga, da hiro ta rua hilohilo. ");
INSERT INTO wiv_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Kubarae na polea kua ia e matoto kua e tani barae, ‘Kaka katiu da e vazohia haninga, kaka motu da e pelea haninga na vanua.’ ");
INSERT INTO wiv_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Hau ta gerimiu, miu kata pelea haninga na vanua kua beta miu na gala vona miu na vazohia. Manumanu motu dia ta galamia vanua dia ka vazohia, miu ta pelea haningana kadia galanga za.” ");
INSERT INTO wiv_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","A vuni Samaria luba bukuna taon kua dia ta bilip ni Iesus, na vuna na polea kana tavine kua za, kua e tani barae ni dia, “Ia ti tania ni niau na goloaloa laveve kena varira ta kakatia.” ");
INSERT INTO wiv_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Kubarae, tania a vuni Samaria dia ka mai ni Iesus, dia ta hule haroinia kete mia pitu kamadia; pale a Iesus ia mia dama rua kamadia. ");
INSERT INTO wiv_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Manumanu luba dia ta longoria polea ke Iesus dia ka bilip ve. ");
INSERT INTO wiv_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Dia ka tania na tavine kua, “Hita te bilip vona kua, beta ni habuka hita ta longoria ka polea za, beta, hita mule hita te longoria kua ia ti pole, hita kene lala matotonia habuka ia ia za na kaka kua kete vaikoli kara manumanu na vulovulo.” ");
INSERT INTO wiv_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Muri na dama rua kua, a Iesus ia vatia a vuni Samaria kini vavana kiri Galili. ");
INSERT INTO wiv_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Na vuna a Iesus mule ia ti tani kakava habuka, na profet kamahi beta ni lala kete hada zaheanga dia na kadia malala mule. ");
INSERT INTO wiv_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Kamana ki bele ni Galili, na manumanu bukuni Galili dia ta koi taduria, na vuna dia ta vano ve na hanihania kapou kara Pasova ni Ierusalem, dia ka hadavia goloa laveve kena ia e katia kilangata. ");
INSERT INTO wiv_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Pale, a Iesus ia vano kara taon a Kana kua ni Galili, kua muga e pokizia naru ki kara vaen vona. Na Opisa katiu kana King, ia e bukuni Kaperneam ia ve ni Kana kilangata kua. Tuna e mazahitia ki ngongoro na kana ruma ni Kaperneam. ");
INSERT INTO wiv_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Kamana kaka kua e longoria habuka a Iesus ti pe ni Iudea kini vamule ni Galili, ia vano vona ki hulenia kete vano ni kati kemihia a tuna, na vuna a tuna keteni mate. ");
INSERT INTO wiv_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","A Iesus ki tania kirina, “Kua ni beta miu na hada mirakel kamahi, ia da mara beta miu na bilip.” ");
INSERT INTO wiv_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Na Opisa kua ki tania, “Paraha, mai kamaniau to na ziho, tabarae tugu ni mate.” ");
INSERT INTO wiv_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","A Iesus ki tania vona, “Vano; a tu da e mahuri.” Na kaka kua e bilip na polea ke Iesus ia vavana mule kara kana malala. ");
INSERT INTO wiv_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","E ba vovona na dala, kana voravora dia ka mai paria na dala dia ka tania vona habuka a tuna ti kemi mule. ");
INSERT INTO wiv_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ia hulenidia, “na taem zia matoto ia e kemi.” Dia ka tania vona, “Na 1.00 kilok matoto na mazahi e vatia.” ");
INSERT INTO wiv_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Pale, na tamana kapiru kua ia lohoi mulehia habuka, ia na taem kena mahoto kena a Iesus e tani barae vona, “A tu da e mahuri mule.” Pale, ia kamana manumanu laveve kena na kana ruma, dia ta bilip ni Iesus. ");
INSERT INTO wiv_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ia ruana mirakel a Iesus e katia kua kilaka kua e pe ni Iudea ki vamule ni Galili. ");
INSERT INTO wiv_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Muri na kua, a Iesus ia zahe kara hanihania kapou katiu ke vuni Iuda ni Ierusalem. ");
INSERT INTO wiv_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ni Ierusalem, kozoho kua na geit e kohanga na geit kana sipsip, ia na naru katiu e kohanga ni Betesda, na varanda lima e katua na hiripa naru kua, ");
INSERT INTO wiv_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","na huduna varanda kua, manumanu luba kua e mazahitidia, ia mai kua nuhu kua matadia e keu, ia mai nuhu kua kabedia e zaha, ia mai nuhu kua togadia laveve e matemate ki beta ni dangea dia kata vavana. ");
INSERT INTO wiv_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Kaka katiu na huduna varanda kua, kana mazahi ti ngoro vona na krismas ti 38. ");
INSERT INTO wiv_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Kamana a Iesus ki hadavia na kaka kua e ngongoro, ia ve ki lala habuka kaka kua kana mazahi ti ngoro havarau ngata motu. Ia hulenia, “E kuli koto kemi mule?” ");
INSERT INTO wiv_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Na kaka kua ki tania, “Paraha, beta kaka katiu ri kua kete taru hohoriau na naru, kua ta na engel ke Vuvu ni vakulia ni makulukulu. Ta na parakilania kata hoho, kava kaka motu katiu ti hoho muga ni niau.” ");
INSERT INTO wiv_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","A Iesus ki tania vona, “Madi! Pelea ka dongi, nu vavana.” ");
INSERT INTO wiv_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Na kaka kua ia kemi pamuhi za, pale, ia pelea kana dongi kini vavana. Kilaka kua ia na Sabat kua na goloa kua e bele vona. ");
INSERT INTO wiv_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Na pararaha ke vuni Iuda kamahi dia ta hadavia kaka kua e katu kemuha e luluga kana dongi, dia ka tani barae vona, “Meni na Sabat kua, beta nu lala kadolu lo e tabunia kaka kete luga kana dongi na dama kua?” ");
INSERT INTO wiv_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Palaka ia ki tania ni dia, “Na kaka kua e katiau ka kemi e tani barae ni niau, ‘Luga ka dongi nu vavana.’” ");
INSERT INTO wiv_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Dia ka hulenia, “Azei matoto kua e geriho koto katia goloa kua?” ");
INSERT INTO wiv_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Palaka na kaka kua e katua kini kemi mule, beta ni lala azei kua e katia kini kemi, na vuna kilangata kua, na manumanu luba kubarae, a Iesus kini pe zelezelehia manumanu kua kini vano. ");
INSERT INTO wiv_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ba muri a Iesus ia paria kaka kua na poloka tempel ia tania vona, “Hada, kava tu kemi mule. Taua nu ma kakatia moge zahazaha tabarae goloa katiu dopa ki zaha ni bele kiriniho.” ");
INSERT INTO wiv_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Na kaka kua ia vano kini tania ni vuni Iuda habuka ia a Iesus za kua e katia kini kemi. ");
INSERT INTO wiv_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Pale, na vuna a Iesus e kakatia goloaloa kua na Sabat, a vuni Iuda kamahi dia te gala dia kene zazaha kiri Iesus. ");
INSERT INTO wiv_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","A Iesus ki tania kiridia, “A Tamagu ia gagala na kana galanga dama laveve, kubarae hau ve hau ta gagala.” ");
INSERT INTO wiv_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ia vuvuna kua a vuni Iuda dia kene ba dopa parakilania dia keteni hubi matehia; na vuna zia, beta ni habuka e vaka taduria na kadia lo kara Sabat za, ia ti tatania habuka ia na tuni Vuvu ve, kini katia kini habuka ia ti habuki Vuvu matoto. ");
INSERT INTO wiv_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","A Iesus ki kolia kadia polea ki tania, “Hau ta tani matotonia ni miu, Tuna kaka mara beta ni kati vetania goloa katiu na kana lohoihoia mule; ia e katia goloa za kua a Tamana e lala kete kakatia, na vuna zia goloa laveve kena a Tamana e lala kete kakatia, ia a Tuna ve e lala kete kakatia. ");
INSERT INTO wiv_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Na vuna, a Tamana e kulina matoto kiri Tuna ki vatunga goloaloa laveve kena ia e lala kete kakatia ni Tuna. Da e vatunga goloaloa kapopou dopa vona kete katia, ta miu na hadavia da miu ta ridi matoto vona. ");
INSERT INTO wiv_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Balika kua a Tamana e valamari mulehia kaka kua ti mate kava ki vala mahuria vona, ia a Tuna ve ia da e vala mahuri roroa ni azei kua ia e kulina kete vala vona. ");
INSERT INTO wiv_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ki vano ve, a Tamana ti beta ni kokoto kara manumanu, palaka ti vala matuhanga laveve ni Tuna kete koto kara manumanu. ");
INSERT INTO wiv_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Kubarae manumanu laveve kete hada zahenia a Tuna, habuka kua dia ta hahada zahenia a Tamana. Azei kua ta beta ni hada zahenia Tuna ia habuka, beta ni hada zahenia a Tamana kua e geria ki ziho. ");
INSERT INTO wiv_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Hau ta tani matotonia polea ni miu, azei kua e longoria kagu polea ki bilip ni Tamagu kua e geriau ka ziho ia e pelea mahuri roroa. Da beta kete madi na kotoa; ia kava ti hava hutu na matea kini pelea mahuria. ");
INSERT INTO wiv_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Hau ta tani matotonia ni miu, damana vona kua e mamai, e kua kava ti mai, kua da nuhu kua dia te varimateai kava da dia ta longoria na halingani Tuni Vuvu. Nuhu kua dia ta longoria halingana da dia ta mahuri. ");
INSERT INTO wiv_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Habuki Tamana kua ia vuvuna mahuria vona, ia ti vala ve matuhanga ve ni Tuna kua kete kara vuvuna mahuri roroa. ");
INSERT INTO wiv_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ia kini vala matuhanga ve vona kete koto kara manumanu, na vuna ia na Tuna Kaka. ");
INSERT INTO wiv_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Tabarae miu na lohoi toritori na polea kua, na vuna zia damana vona kua e ba mamai kua nuhu kua dia ta ngongoro na poloka matmat da dia ta longoria halingana, ");
INSERT INTO wiv_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","dia ta lamalama, nuhu kua dia ta kakatia moge pa, da dia ta lama dia ka mahuri, nuhu kua dia ta katia moge zahazaha, da dia ta lama dia ka koto kirua, a jas ki geu dia ka vairoha. ");
INSERT INTO wiv_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Hau kazihegu mara beta na katia goloa katiu; hau ta sikelnia kotoa habuka kua hau ta longoria e tanga ni niau, na kagu sikel ia e mahoto, na vuna beta na parakilania kata vazahenia hizagu mule, beta, kata vazahenia kaka kua e geriau ka mai. ");
INSERT INTO wiv_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Kua na popole kagu mule, kagu polea beta ni matoto. ");
INSERT INTO wiv_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Palaka kaka motu katiu e popole na kagu moge, e ka lala kana polea kua kirigu ia e matoto. ");
INSERT INTO wiv_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Kava miu te geria manumanu dia kene vano hulenia a Jon e ia kini tani kakava ni miu na kagu galanga, ia mai na kagu moge kamahi. ");
INSERT INTO wiv_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Palaka hau beta na vaka maroro na polea kana kaka bukuna vulovulo kua kete kodoniau; palaka hau ta tatani barae, habuka beta miu kata golu. ");
INSERT INTO wiv_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","A Jon ia na lam kua muga ki vala balangana ni miu, e miu ka hilohilo na balangana kana lam. ");
INSERT INTO wiv_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Kagu polea kamana kagu galanga e dopa ki kapou na kana. Na vuna na galanga kua a Tamagu e vala ni niau kua kata vahozovia, ia ia za kua ta gagala vona, galanga kua ta kakatia ia e tani kakava habuka a Tamagu e geriau ka mai. ");
INSERT INTO wiv_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","A Tamagu kua e geriau ka mai, ia mule e popole ni niau. Ma beta miu na longoria halingana ki ma beta ve miu na hadavia matana, ");
INSERT INTO wiv_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ki beta ve kana polea ni ngoro na polokomiu, na vuna beta miu na bilip na kaka kua e geriau ka mai. ");
INSERT INTO wiv_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Miu ta lala miu kata ridim kemikemihia matoto polea na buk kana Paraha na vuna miu ta lohoia ia da miu ta pelea mahuri roroa vona. Na polea kamahi kena na polea kana Paraha ia e popole ni niau, ");
INSERT INTO wiv_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","palaka beta matoto ni kulimiu miu kata mai ni niau miu na pelea mahuria. ");
INSERT INTO wiv_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Hau beta na tania miu kata vazahenia hizagu, ");
INSERT INTO wiv_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","palaka hau ta lala kemikemihimiu. Hau ta lala kemikemihia polokomiu habuka beta ni lala kete kukulimiu kiri Vuvu. ");
INSERT INTO wiv_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Hau ta mai na hizani Tamagu, palaka beta miu na longoria kagu polea; palaka kua kaka katiu ni mai na hizana mule, ia da miu ta pele taputapunia kana polea. ");
INSERT INTO wiv_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Kua ta miu na kokona zaheni mulehimiu, ni beta miu na vatia a Vuvu ni kokona zahenimiu. Da miu ta bilip ziha ni niau? ");
INSERT INTO wiv_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Palaka tabarae miu na tania habuka hau da ta kokoto kirimiu, kaka kete koto kirimiu ia a Moses, kaka kua miu ta lohoia miu ka tania da ia e kodonimiu. ");
INSERT INTO wiv_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kua miu na vaka maroro ni Moses, ia da miu ta vaka maroro ve ni niau, na vuna zia, a Moses ia e vapolupolu ki popole ni niau. ");
INSERT INTO wiv_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Palaka na vuna beta miu na bilip na polea kua ia e vapolungania, da miu ta bilip ziha na kagu polea?” ");
INSERT INTO wiv_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Muri na kua, a Iesus ia vano kara paligena loka a Galili (loka kua hizana katiu ve a Taiberias), ");
INSERT INTO wiv_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","na kabuna manumanu kapou dia ta muri vona, na vuna dia ta hadavia mirakel kamahi kua e lala kete kakati kemihia manumanu dia ka kekemi mule. ");
INSERT INTO wiv_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","A Iesus kamana kana disaipel kamahi dia ta vori zahe kara potuna dia ta mia tadu. ");
INSERT INTO wiv_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Na damana hanihania kapou kara Pasova ti kozoho. ");
INSERT INTO wiv_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","A Iesus ki hada na kabuna manumanu kapou dia ta lolohu dia kata mai vona, ia hulenia a Filip, “Da tolu ta kadea bret ni ve, manumanu laveve kua dia kata hania?” ");
INSERT INTO wiv_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","A Iesus kava ti lala nazia da e katia. E hule barae za kete parakilania a Filip. ");
INSERT INTO wiv_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","A Filip ki tania, “Kua tolu na varaga 200 Kina kara bret, ia mara beta ve ni dangea manumanu laveve kuari.” ");
INSERT INTO wiv_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Kana disaipel katiu, a Andru, tazini Saimon Pita, ia tani barae ni Iesus, ");
INSERT INTO wiv_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Kapiru tamohane katiu kua hana bret e lima kamana hana hiha kote rua, palaka da mara beta ve ni dangea na manumanu luba kua.” ");
INSERT INTO wiv_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","A Iesus ia tania, “Miu tania na manumanu, dia na loli tadu.” Na palaka kua e kemi kete mia vonanga voa, kubarae na kabuna manumanu kua dia ta loli tadu: kua e hazeanga tamomohane za, kadia naba e bele 5,000. ");
INSERT INTO wiv_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","A Iesus ia pelea na bret lima kua, ia hate motunia a Vuvu, ia vazenia na manumanu kua dia ta lololi. E kati baraenia ve na hiha rua kua. Azei kua e kulina kete hania ni kapou, ia pepelea za. ");
INSERT INTO wiv_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Dia ta hania magalidia kini kurukuru, a Iesus ia tania na kana disaipel kamahi, “Miu vilehia kalangara haninga laveve. Taua miu na paralegenia.” ");
INSERT INTO wiv_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Pale, dia ta vilehia kalangara bret lima kua e vatua, dia ka gorea kolopina e 12. ");
INSERT INTO wiv_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Kamana na manumanu kua dia ka hada na mirakel kua a Iesus e katia, dia ta tani barae, “Matoto, kaka kua ia na profet kua e tanga kua kete ziho kara garigari.” ");
INSERT INTO wiv_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","A Iesus ti pelea kadia lohoihoia habuka dia kata paho taduria, dia na katia ni kara kadia king. Pale, ia vatia palaka kua kini zahe kazihena kara potuna. ");
INSERT INTO wiv_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Keteni garavi kana disaipel kamahi dia ta pozi kara vazalea na loka, ");
INSERT INTO wiv_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","dia ta polo na bot, dia kene vazula vamule kara paligena loka, dia kata vano kiri Kaperneam. Ti marigo palaka a Iesus ia ma beta za ni bele ni dia. ");
INSERT INTO wiv_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Na kavili kapou ki rorovo, na dazi ki kudukudu. ");
INSERT INTO wiv_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Kava dia te vazula e hada barae, 5 o 6 kilomita kava, pale, dia ta hada a Iesus ti vavana na huduna dazi kini zazahe kara bot, dia ka kuahi matoto. ");
INSERT INTO wiv_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Palaka a Iesus ia tania ni dia, “Taua miu na kuahi. Hau kua.” ");
INSERT INTO wiv_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Pale, polokodia ia kemi, dia ta vapolea na huduna bot, baribari tapu za na bot ia vaki na palaka kua dia ta kikirina. ");
INSERT INTO wiv_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Dama muri vona na kabuna manumanu kua dia ta lololi na paligena loka, dia ta hada na bot katiu za kua e papati kilangata, na disaipel kamahi za dia ka polo na bot kua. A Iesus ki beta ni polo kamadia vona. Dia ta vatia a Iesus dia ka vazula vano. ");
INSERT INTO wiv_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Na bot taza, bukuni Taiberias, dia ta mai pati tadu, kozoho na palaka kua manumanu dia ta hania na bret kua a Iesus e hate motunia Tamana ki vala ni dia. ");
INSERT INTO wiv_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Kamana na manumanu dia ka hada kavu kiri Iesus kamana kana disaipel kamahi, dia ta polopolo ve na bot ke vuni Taiberias dia kene vano kiri Kaperneam, dia kata kaze kirina. ");
INSERT INTO wiv_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Kamana dia ka paria a Iesus na paligena loka, dia ta hulenia, “Tisa, ngiza tu bele ri kua?” ");
INSERT INTO wiv_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","A Iesus ki tani barae ni dia, “Hau ta tania matotonia ni miu, beta miu na hahada kiriniau, na vuna miu ta hada lala na mirakel kamahi ta katia, beu, miu ta hahada kirigu na vuna na bret kena miu ta hania magalimiu ki kurukuru matoto vona. ");
INSERT INTO wiv_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Taua miu na gagala kara haninga kua e lala kete zaha, palaka miu gala kara haninga kena beta ni lala kete zazaha, kua kete vala mahuri roroa. Ia na haninga kua, kua na Tuna Kaka da e vala ni miu. Na vuna a Vuvu a Tamana ti vala naba vona kete kati baraenia.” ");
INSERT INTO wiv_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Dia ta hulenia a Iesus, “Nazia matoto hita kata katia, ni dangea hita kata katia na galanga kua a Vuvu e kulina hita kata gala vona?” ");
INSERT INTO wiv_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","A Iesus ki tania ni dia, “Na galanga ke Vuvu ia kua: Miu bilip na kaka kua ia e geria ki mai.” ");
INSERT INTO wiv_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Pale, dia ta hule baraenia, “Na mirakel zia da tu katia hita kata hada hita na bilip ni niho? Nazia matoto da tu katia? ");
INSERT INTO wiv_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Habu tubuhita dia ta hania na mana na poloka deset; habuka kua e vapolunganga na polea kana Paraha ki tanga, ‘Ia e vala bret bukuna lagato dia ka hania.’” ");
INSERT INTO wiv_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","A Iesus ki tania ni dia, “Hau ta tani matotonia ni miu, beta ni a Moses kena e vala ni miu na bret bukuna lagato, palaka a Tamagu kena e vala na matotoka bret bukuna lagato ni miu. ");
INSERT INTO wiv_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Na vuna na bret matoto he Vuvu, ia ia za kua ti pe na lagato kini ziho kini vala mahuria na vulovulo.” ");
INSERT INTO wiv_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Dia ka tania, “Paraha, meni kua ki ma vavano, vala ni hita na bret kena.” ");
INSERT INTO wiv_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Pale, a Iesus ia tani kakava ni dia, “Hau za ia na bret kara mahuri roroa. Kaka kua tu mai ni niau, ia mara beta ni vitoloniho. Kaka kua tu bilip ni niau, ia mara beta ni marahotiho. ");
INSERT INTO wiv_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Palaka habuka kua ta tania ni miu, miu te hadaviau kava palaka beta miu na bilip. ");
INSERT INTO wiv_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Manumanu laveve kena a Tamagu ti vala ni niau, ia da dia ta mai ni niau, azei kua e mai, ia mara beta na geri mulehia ni vamule. ");
INSERT INTO wiv_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Na vuna hau ta pe na lagato ka ziho, beta ni kata muri na kagu lohoihoia mule, palaka kata muri na lohoihoia ke Tamagu, kua e geriau ka ziho. ");
INSERT INTO wiv_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ia ki kana lohoihoia ve kete beta kata vatia katiu ni dia kua ia ti vala ni niau kava, ni golu, palaka kata valamari mulehidia laveve na las de. ");
INSERT INTO wiv_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Na vuna lohoihoia ke Tamagu ia e tani barae, manumanu laveve kena dia ta hada na Tuna Kaka dia ka bilip vona, ia da dia ta pelea mahuri roroa, da hau ta valamari mulehidia na las de.” ");
INSERT INTO wiv_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Na manumanu dia ta pole ngungu kirina, na vuna kua ia e tani barae, “Hau na bret kua e pe na lagato ki ziho.” ");
INSERT INTO wiv_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Dia ka tani barae ve, “Karae beta ni ia a Iesus, tuni Iosep, kena tamana kamani titinana tolu ta lala? E kuziha ki tania, ‘Hau ta pe na lagato ka ziho’?” ");
INSERT INTO wiv_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","A Iesus e kolia kadia polea ki tania, “Miu vata pole toria na pidaka miu. ");
INSERT INTO wiv_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Mara beta kaka ni mai veta ni niau, na kana lohoihoia mule, ma a Tamagu kua e geriau ka ziho, e geria ki mai ni niau hau te valamari mulehia na las de. ");
INSERT INTO wiv_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Na polea kua e vapolunganga varira na poloka buk kana profet kamahi, e tani barae, ‘Da a Vuvu e vaketekete ni dia laveve.’ Manumanu laveve kena dia ta longoria polea ke Tamagu dia ka muri vona, ia da dia ta mai ni niau. ");
INSERT INTO wiv_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Polea kua, beta na tania habuka kaka katiu ti hada a Tamagu, beu. Kaka kua e pe ni Vuvu za ia za, ia e hada a Tamagu. ");
INSERT INTO wiv_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Hau ta tani matotonia ni miu, azei ho tu bilip, kava tu pelea mahuri roroa. ");
INSERT INTO wiv_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Hau ia na bret kara mahuria. ");
INSERT INTO wiv_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Habu tubumiu dia ta hania mana na poloka deset, palaka dia ta varimateai. ");
INSERT INTO wiv_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Palaka na bret kua e pe na lagato ki ziho, kua kaka nu hania, ia mara beta nu mate. ");
INSERT INTO wiv_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Hau na bret kua e mahuri kua e pe na lagato ki ziho. Kua nu hania bret kua, da tu mahuri roro. Na bret kua kata vala ia na midagu, kua kata vala kua manumanu laveve dia na mahuri vona.” ");
INSERT INTO wiv_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","A vuni Iuda dia ta longoria polea kua, dia ta varikori na pidaka dia mule dia ka tania, “Da kaka kuarina e vala zingania midana tolu ka hania?” ");
INSERT INTO wiv_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","A Iesus ki tania ni dia, “Ta tani matotonia polea ni miu, kua ni beta miu na hania midana Tuna Kaka, miu na hinumia topona, ia da beta mahuria na polokomiu. ");
INSERT INTO wiv_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Azei ho tu hania midagu ku hinumia topogu ia tu pelea mahuri roroa, hau da ta valamari mulehia na matea na las de. ");
INSERT INTO wiv_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Na vuna midagu ia haninga matoto, topogu ia hinua matoto. ");
INSERT INTO wiv_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Azei kua e hania midagu ki hinumia topogu, ia dia na polokogu, hau ve na polokodia. ");
INSERT INTO wiv_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Na Tamagu kua e mahuri ia e geriau, kubarae hau ka mahuri na vuna ia e mahuri. Ia e habuka za, azei ho tu haniau, ia da tu mahuri na vuna ni niau za. ");
INSERT INTO wiv_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ia na bret kua za kua e pe na lagato ki ziho, beta ni balika bret kena habu tubumiu dia ta hania, ki beta dia na mahuri roro. Palaka nuhu kua dia ta hania bret kua, ia da dia ta mahuri roro.” ");
INSERT INTO wiv_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","A Iesus e tatania polealea kamahi kua kilaka kua e vaketekete na poloka haus lotu ke vuni Iuda ni Kaperneam. ");
INSERT INTO wiv_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Kana disaipel luba dia ta longoria kana polea kua, dia ka tania, “Polea kua e matuha marata; da tolu ta pele zingania polea kua?” ");
INSERT INTO wiv_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ia ti hatu lala habuka na kana disaipel kamahi dia ta popole ngungu na goloa kua, ia hulenidia, “E kuziha, polea kua ti katimiu miu ka lohoia miu keteni varihavai ni niau? ");
INSERT INTO wiv_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Pele, da miu ta kuziha kua ta miu na hadavia na Tuna Kaka kua tani zahe mule kara palaka kua e pe vona ki ziho? ");
INSERT INTO wiv_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Na Vule Tumonga, ia e lala kete vala mahuria; kamiu matuhanga mule mara beta ni kodonimiu pitu. Na polea kua hau ta vavala ia da e vala na Vule Tumonga kamana mahuria ni miu. ");
INSERT INTO wiv_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Palaka taza ni miu kua, beta dia na bilip.” A Iesus e tani barae kua na vuna ia kava ti lala mugania azei kua da beta kete bilip, ia mai na kaka kua kete vala ia na limani vuni Iuda. ");
INSERT INTO wiv_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ia ki tani barae ve, “Ia vuvuna kua ka tani barae, mara beta kaka ni mai veta ni niau. Ma a Tamagu e geria, ia ki mai ni niau.” ");
INSERT INTO wiv_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Muri na kua ki vano, kana disaipel luba dia ta varihavai vona kini beta ve dia ne ma mumuri vona. ");
INSERT INTO wiv_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","A Iesus ki hulenia kana 12 disaipel kamahi, “Miu ve kulimiu miu kata varihavai ni niau?” ");
INSERT INTO wiv_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","A Saimon Pita ki tani barae, “Paraha, hita kata vano ni zei ve? Na polea kua e vavala na mahuria na manumanu, ia ni niho. ");
INSERT INTO wiv_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Hita ta bilip hita ka lala habuka ho na Kaka Tumonga ke Vuvu.” ");
INSERT INTO wiv_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","A Iesus ki tania ni dia, “Hau ta makia miu 12, te? Palaka katiu ni miu ia na satan.” ");
INSERT INTO wiv_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","A Iesus ia e popole ni Iudas tuni Saimon Iskariot, kua ia e katiu ni dia na 12 disaipel kamahi, kua ia ba muri kete vala a Iesus na limani vuni Iuda. ");
INSERT INTO wiv_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Muri na kua, a Iesus ia ma ki ma vavana lobia a Galili za; e beta ni kulina kete vano lolobi ni Iudea na vuna a vuni Iuda dia ta tatare kirina dia kata hubi matehia. ");
INSERT INTO wiv_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Na Damana Lupua kapou kara Kape ke vuni Iuda ti kokozoho, (na dama kua dia ta lala dia kata katia kape kotekote na huduna ruma dia na ngongoro vona lingabo katiu), ");
INSERT INTO wiv_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","a habu tazini Iesus dia ta tania kirina, “Vatia palaka kua nu vano kiri Iudea, ka disaipel kamahi dia kata hada ve na mirakel kamahi kua tu kakatia. ");
INSERT INTO wiv_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Beta kaka ni lala kete lilitiginia galanga kua ia e kulina kete hahada zaheanga vona. Na vuna kua ho tu kakatia galangalanga kamahi kua, pele vano nu vatunga kakavaho na manumanu laveve dia kata hadavia.” ");
INSERT INTO wiv_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","A habu tazini Iesus dia ta tani barae kirina na vuna, beta dia na bilip vona. ");
INSERT INTO wiv_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","A Iesus ki tani barae ni dia, “Kagu dama ma beta ni mai. Miu dama laveve ia kamiu dama. ");
INSERT INTO wiv_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Manumanu na garigari mara beta dia na zaha kirimiu, palaka da dia ta zaha kirigu na vuna hau ta gala ka tatani kakava kadia moge zahazaha. ");
INSERT INTO wiv_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Miu vano kara Damana Lupua kapou kara Kape. Hau mara beta na zahe tapu kara Dama kena, na vuna kagu dama ma beta ni mai.” ");
INSERT INTO wiv_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","A Iesus e tania polea kua, pale kini ma mia ni Galili. ");
INSERT INTO wiv_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Palaka, muri habu tazina ti vavana laveve kara Lupua Kapou kua kara Kape, ia ve ia muri kini zahe, e pe paritigitigi ki muri. ");
INSERT INTO wiv_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","A vuni Iuda dia ta kakaze kirina na Lupua Kapou kara Kape kua, dia ka varihulei dia ka tania, “Kue ia ni ve?” ");
INSERT INTO wiv_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Na poloka kabuna manumanu kapou kua dia ta popole ngungu za vona. Taza dia ta tania, “Ia na kaka pa.” Taza dia ta kolia dia ka tania, “Beta, ia e gala ki rurukia manumanu.” ");
INSERT INTO wiv_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Palaka dia ta kuahinia na pararaha ke vuni Iuda ki beta dia na pole kapou na kadia lohoihoia. ");
INSERT INTO wiv_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ti vano na pidaka dama na Lupua Kapou kara Kape, pale a Iesus ia zahe hoho na poloka tempel kini vavaketea manumanu. ");
INSERT INTO wiv_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Na pararaha kamahi ke vuni Iuda dia ta ridi matoto na kana vaketeketea, dia ka tania, “E pele zingania save kua, beta za ni sikul pitu.” ");
INSERT INTO wiv_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","A Iesus ki kolia kadia polea ki tania, “Polea kamahi kua hau ta vavala, beta ni kagu, palaka kana kaka kua e geriau ka mai; ");
INSERT INTO wiv_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Azei kua e kulina matoto kete muri na lohoihoia ke Vuvu, ia da e pari vutuvutuhia habuka kagu vaketeketea e pe ni Vuvu, o hau mule ta tatania na kagu lohoihoia mule. ");
INSERT INTO wiv_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Kaka kua e katia polea na kana lohoihoia mule, ia e paparakilania kete pelea hiza kapou, palaka kaka kua e kulina kete vala hiza kapou na kaka kua e geria ki mai, ia e lala kete tatani matotonia polea, ki mara beta nu paria vairukua vona. ");
INSERT INTO wiv_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","A Moses e vala lo ni miu, te? Palaka beta katiu ni miu ni mumuri na lo ke Moses. E kuziha miu ka paparakilania miu kata hubi matehiau?” ");
INSERT INTO wiv_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Na kabuna manumanu kapou kua dia ka tania, “Ho tauka na hanitu e hoholiholiho, azei e paparakilania kete hubi matehiho?” ");
INSERT INTO wiv_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","A Iesus ki kolia ki tania ni dia, “Hau ta katia na mirakel katiu, miu ka ridi laveve vona. ");
INSERT INTO wiv_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","A Moses e vatunga makina vatomutomua ni miu, (palaka beta ni a Moses, habu tubumiu) miu ka vavatomutomu na Sabat. ");
INSERT INTO wiv_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Miu ta muri na lo ke Moses miu ka vatomutomuhia kapiru na Sabat, pele e kuziha magalimiu ki varitihi kirigu kua ta kati kemihi mulehia kaka na Sabat? ");
INSERT INTO wiv_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Tabarae miu na hadavia kaka e mata zihaziha miu na sikelnia, Miu sikelnia goloa laveve kamana hatuhatua kua e mahoto.” ");
INSERT INTO wiv_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Manumanu taza bukuni Ierusalem dia ta tani barae, “Ia kua na kaka kua na kadolu pararaha dia ta paparakilania dia kata hubi matehia kua? ");
INSERT INTO wiv_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Kua ia kua, ti popole na pidaka manumanu, ki beta dia na tatania polea katiu kirina. Karae dia te hada lala habuka ia a Kristus? ");
INSERT INTO wiv_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Palaka tolu ta lala kaka kuari ia bukuni ve. Palaka a Kristus kua ni bele, ia mara beta tolu na lala ia e bukuni ve.” ");
INSERT INTO wiv_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Kilangata kua e vavaketekete na poloka tempel, e pole kapopou ki tania, “Miu ta lala matotoniau, miu ka lala hau ta bukuni ve, te? Hau beta na mai veta na kagu lohoihoia mule, palaka kaka kua e geriau ka mai ia e lala kete tani matotonia polea, ki beta miu na lala kaka kua. ");
INSERT INTO wiv_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Palaka hau ta lala ia, na vuna hau ta pe vona, ia ki geriau ka mai.” ");
INSERT INTO wiv_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Pale, dia ta parakilania dia kata haba taduria dia na karabusnia, palaka beta kaka katiu ni paho taduria, na vuna kana dama ma beta ni lohu. ");
INSERT INTO wiv_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Manumanu luba na poloka kabu kapou kua dia ta bilip vona, dia ka tania, “Kua a Kristus ni mai karae da e dopa ki katia na mirakel kapopou dopa na kaka kua e kakatia?” ");
INSERT INTO wiv_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Na Parisi kamahi dia ta longoria na kabuna manumanu kua dia ta popole barae ni Iesus, dia kamana hetpris kamahi, dia ta geria gat kara tempel taza dia kata haba taduria a Iesus. ");
INSERT INTO wiv_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","A Iesus ki tania ni dia, “Hau da ta mia kamamiu pitu papa ve, ba muri hau ta vatimiu kene zahe mule na kaka kua e geriau; ");
INSERT INTO wiv_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","da miu ta kaze kirigu, palaka mara beta miu na pariau; malala kua hau kata kirina, ia mara beta miu na vano vona.” ");
INSERT INTO wiv_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Pararaha ke vuni Iuda dia ta varihulei mule, “Kaka kua e lohoia kete kiri ve ki mara beta tolu na paria? Karae kete vano mia kamana kadolu manumanu kua dia te popole Grik, ni vaketekete ni dia? ");
INSERT INTO wiv_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","E tani ziha vona kua e tani barae, ‘Da miu ta kaze kiriniau, palaka mara beta miu na pariau, ki mara beta ve tolu na vano na palaka kua ia kete kirina’?” ");
INSERT INTO wiv_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Na dama kua dia keteni vahozovia na hanihania kara kadia damana lotua kua, na dama kua, ia kadia dama kapou matoto kua, a Iesus ia madi ia tani barae, “Azei ni miu kua ni marahotia, mai ni niau nu hinu. ");
INSERT INTO wiv_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","E habuka kua na polea kana Paraha e tania, ‘Azei ho kua nu bilip ni niau, ia da na naru kua kara mahuri roroa e pado gotala na poloko.’” ");
INSERT INTO wiv_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","A Iesus ia e popole na Vule Tumonga, kua nuhu kua dia na bilip vona, ia da dia ta pelea. Palaka kilangata kua, ma beta na Vule Tumonga ni valanga ni ziho, na vuna a Iesus ma beta ni valamari muleha ia na matea ni pelea glori. ");
INSERT INTO wiv_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Manumanu taza dia ta longoria kua e tani barae, dia ka tania, “Matoto, kaka kua ia na profet kua a Vuvu e tania kete vala ni ziho.” ");
INSERT INTO wiv_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Dia taza dia ta tania, “Ia na kaka kua a Vuvu e makia kete pele mulehia kana manumanu na garigari.” Palaka taza ni dia, dia ta tania, “Beta! Kaka kua a Vuvu e makia, kete pele mulehia kana manumanu mara beta ni bukuni Galili. ");
INSERT INTO wiv_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Na polea kana Paraha e tania habuka na kaka kua a Vuvu e makia kete pele mulehia kana manumanu, ia da na vidiriki Devit katiu, da ki valohua ni Betlehem, na taon kua a Devit e mimia vona varira.” ");
INSERT INTO wiv_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Pale, manumanu dia ta vaigege dia kene varipe vulavulahi. ");
INSERT INTO wiv_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Dia taza e kulidia dia kata paho taduria a Iesus dia na karabusnia, palaka ki beta dia na katia goloa katiu vona. ");
INSERT INTO wiv_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Na gat kamahi kara tempel dia ta vamule, na hetpris kamahi kamani vuni Parisi kamahi dia ta hulenidia, “E kuziha kini beta miu na pelea ni mai?” ");
INSERT INTO wiv_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Na gat kamahi kua dia ta tania, “Beta hita na longoria kaka katiu muga ni lala kete popole habuka kaka kua!” ");
INSERT INTO wiv_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Na Parisi kamahi dia ka tania kiridia, “Ti rukimiu ve? ");
INSERT INTO wiv_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Miu ta hadavia katiu ni hita kua na Pararaha ke vuni Iuda beu katiu ni hita kua a vuni Parisi e bilip vona? ");
INSERT INTO wiv_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Manumanu kena dia ta bilip vona, ia nuhu kena beta dia na lala na lo kana Paraha. Manumanu kamahi kena a Vuvu kava ti tania habuka da dia ta golugolu.” ");
INSERT INTO wiv_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","A Nikodemus, ia ve na Parisi katiu, ia na kaka kua muga e vano ni Iesus, ia e tani barae ni dia, ");
INSERT INTO wiv_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Kadolu lo e tania mara beta tolu na karabusni vetania kaka. Ma tolu ta muga longoria kotoa tolu ka pari vutuhia nazia e katia ki zaha, tolu ka karabusnia.” ");
INSERT INTO wiv_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Dia ka tania kiri Nikodemus, “Tauka, ho ve tu bukuni Galili, ai? Hada papa na poloka buk ke Vuvu nu hadavia habuka, ma beta profet katiu ni pe ni Galili ni mai!” ");
INSERT INTO wiv_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Pale, dia kene pe katiutiu kara kadia rumaruma. ");
INSERT INTO wiv_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","A Iesus ia vano kara potuna ni Oliv. ");
INSERT INTO wiv_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Na damadama matoto ia vamule kara tempel, manumanu laveve dia ta mai mia lobia ia mia tadu kini vaketekete ni dia. ");
INSERT INTO wiv_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Na tisa kamahi kara lo kamani vuni Parisi dia ta pelea na tavine lahia katiu dia ta kaze paria e balebale kamana tamohane motu katiu, dia ta mai vamadiria na matana manumanu, ");
INSERT INTO wiv_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","dia ta hulenia a Iesus, “Tisa, tavine kua e kaze parua e balebale kamana tamohane katiu. ");
INSERT INTO wiv_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Na poloka lo ke Moses e tania habuka tolu kata lubi matehia na kedo, na tavine kua e katia galanga kua. E ho ku lohoi ziha?” ");
INSERT INTO wiv_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Dia ta hule rukia a Iesus na hulea kua dia kata parakilania, habuka kete tania polea katiu kua kete dangea dia kata koto kirina vona. Palaka a Iesus ia tiro vatudu ia vapolupolu na garigari na kukuna. ");
INSERT INTO wiv_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Dia ta ma huhule varidingania, ia madi ia tania ni dia, “Azei ni miu kua kini beta ni lala kete kakatia moge zaha katiu, kete muga vozongania hana kedo na tavine kua.” ");
INSERT INTO wiv_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Pale, ia tiro vatudu mule kini vapolupolu mule na garigari. ");
INSERT INTO wiv_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Dia ta longo baraenia, dia ta pe katiutiu laveve, kadia pararaha dia ta muga varihavai, dia te vati tapunia tavine kena kini ma mamadi kamani Iesus. ");
INSERT INTO wiv_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","A Iesus ki tada vatada ki hulenia tavine kua, “Tavine, kue dia te kiri ve? Ti beta kaka kete koto kiriniho?” ");
INSERT INTO wiv_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ia ki tania, “Paraha, ti beta dia.” A Iesus ki tania vona, “Hau ve beta na koto kiriniho; vano, palaka taua nu ma kakatia moge zahazaha.” ");
INSERT INTO wiv_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","A Iesus e pole mule kamana manumanu ki tania, “Hau ia na laet kara garigari. Azei kua tani mumuri ni niau ia e hada na laet ki mara beta matoto ni vavana ve na rodo, palaka da e pelea na laet kara mahuria.” ");
INSERT INTO wiv_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Na Parisi kamahi dia ka tania kirina, “Ho mule tu gala ku popole ni niho mule, kubarae ka polea beta ni matoto.” ");
INSERT INTO wiv_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","A Iesus ki tani barae ni dia, “Kua hau na popole ni niau mule, ia hau ta tani matotonia polea, na vuna hau ta lala hau ta pe ve ka mai, hau ka lala na palaka kua hau kata vamule kirina. Palaka miu beta miu na lala hau ta pe ve ka mai, ki beta ve miu na lala da ta kiri ve. ");
INSERT INTO wiv_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Miu ta sikelnia kaka na maki kua bukuna garigari, palaka hau beta na lala kata sikelnia moge kana kaka katiu. ");
INSERT INTO wiv_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Palaka kua hau na sikelnia kaka, kagu polea ia e mahoto, beta ni hau kazihegu kena ta sikelnia kaka, palaka na kaka kua e geriau ka mai, ia ve e kamakamaniau. ");
INSERT INTO wiv_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Na poloka kamiu lo mule, e vapolu bareanga; kua na witnes ni rua, kahiro polea ni katiu za, ia habuka polea kena hiro ta tania ia e matoto. ");
INSERT INTO wiv_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Hau mule ta lala kata popole na kagu galanga kamana kagu moge, a Tamagu kua e geriau ka mai, ia ve e popole na kagu galanga kamana kagu moge.” ");
INSERT INTO wiv_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Dia ka hulenia, “Kue a Kamama ni ve?” A Iesus ki tania ni dia, “Beta miu na lalau ki beta ve miu na lala a Tamagu; kua miu na lalau, ma miu te lala a Tamagu ve.” ");
INSERT INTO wiv_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","A Iesus e vaketea manumanu na poloka tempel kozoho na palaka kua e tataruha opa vona ki tatania polealea kamahi kua. Beta katiu ni haba taduria, na vuna kana dama ma beta ni mai. ");
INSERT INTO wiv_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","A Iesus ki tani barae ni dia, “Hau da ta kakava ri, da miu ta kaze kavu kiriniau, miu ka varimateai na hamiu pekato. Malala kua hau kata kirina ia mara beta miu na bele vona.” ");
INSERT INTO wiv_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","A vuni Iuda dia ka tania, “Karae kete hubi matehi mulehia, kuari e tani barae, ‘Malala kua hau kata kirina ia mara beta miu na bele vona’?” ");
INSERT INTO wiv_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","A Iesus ki tania ni dia, “Miu ta bukuna malala kua e ngoro tadu, hau ta bukuna malala kua e heta. Miu ta bukuni ri na vulovulo, palaka hau beta na bukuna vulovulo kua. ");
INSERT INTO wiv_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ia ki kubarae hau ka tania; da miu ta varimateai na hamiu pekato. Da miu ta varimateai na hamiu pekato kua tani beta miu na bilip habuka hau ia hau za.” ");
INSERT INTO wiv_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Dia ka hulenia, “Ho azei matoto?” A Iesus ki tania ni dia, “Hau kava muga te tania ni miu hau azei matoto. ");
INSERT INTO wiv_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Hau kagu polea luba vona kata vala kirimiu, goloa luba kata sikelnimiu vona, palaka kaka kua e geriau ka mai, kana moge ia e matoto laveve. Hau ta tatania na manumanu na nazia kua hau ta longoria ia e tania.” ");
INSERT INTO wiv_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Dia beta dia na longo lala habuka a Iesus e popole ni Tamana. ");
INSERT INTO wiv_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Kubarae, a Iesus ki tania ni dia, “Na dama kua miu te vazahenia na Tuna Kaka, ia da miu te ba lala habuka Hau ia Hau za; miu kene ba lala ve habuka hau beta na kakatia goloa katiu na kagu lohoihoia mule, palaka ta katia goloa za kua a Tamagu e tania ni niau.” ");
INSERT INTO wiv_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Azei kua e geriau ka mai, beta ni vati vetaniau, ia e kakamaniau na dama laveve. Na vuna ia e lala habuka ta lala kata kakatia goloa kua e muri matoto na kana lohoihoia. ");
INSERT INTO wiv_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Manumanu luba kua dia ta longoria a Iesus e popole barae, dia ta bilip vona. ");
INSERT INTO wiv_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","A Iesus ia tania ni vuni Iuda kua dia ta bilip vona, “Kua miu na ma paho poto na kagu polea, ia miu ta kagu disaipel matoto, ");
INSERT INTO wiv_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","da miu kene lala matotoka polea, na matotoka polea da ti pele gotalani mulehimiu na karabus.” ");
INSERT INTO wiv_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Dia ta kolia vona dia ka tania, “Hita habu tubuni Abraham kua, ki beta boto katiu hita na kara vora vetanga kana kaka katiu. E kuziha ku tania, hita kata gotala mule na karabus?” ");
INSERT INTO wiv_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","A Iesus ki tania ni dia, “Matoto, matoto ta tania ni miu, manumanu laveve kua miu ta kakatia moge zahazaha, ia miu ta vora vetanga kana moge zahazaha. ");
INSERT INTO wiv_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Na vora vetanga beta ni lala kete ma mimia na ruma kena ia e vovora vona, palaka na tuna kaka kua ia bukuna ruma kena, ia da e ma ki mimia vona. ");
INSERT INTO wiv_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Kubarae, kua ta na Tuna ni pele gotalani mulehiho na karabus, ia da tu gotala liuliu. ");
INSERT INTO wiv_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Hau ta lala miu ta habu tubuni Abraham. Palaka miu ta paparakilania miu kata hubi matehiau, na vuna kagu polea beta ni paria palaka vona kete ngoro na polokomiu. ");
INSERT INTO wiv_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Hau ta popole na goloa kua hau ta hada ni Tamagu, miu ta kakatia goloa kua miu ta longoria ni tamamiu.” ");
INSERT INTO wiv_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Dia ka tania, “A Abraham ia tubuhita.” A Iesus ki tania, “Kua ni matoto miu na habu tubuni Abraham, ma miu te kakatia nazia kua a Abraham e lala kete kakatia. ");
INSERT INTO wiv_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Hau kua, hau ta tatania matotoka polea hau ta longoria ni Vuvu, palaka miu ta paparakilania miu kata hubi matehiau; a Abraham mara beta ni katia galanga mata barae kua. ");
INSERT INTO wiv_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Miu ta mumuri na galanga ke tamamiu.” Dia ka tania vona, “Hita beta hita na tuna dala, hita tamahita a Vuvu katiu papa.” ");
INSERT INTO wiv_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","A Iesus ki tania ni dia, “Kua a Vuvu ni tamamiu matoto, da ti kulimiu kirigu, na vuna hau ta pe ni Vuvu kua ka lohu ri. Beta na mai na kagu lohoihoia mule, betaka, a Vuvu e geriau ka mai. ");
INSERT INTO wiv_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","E kuziha ki beta miu na longo lala polea kua hau ta tatania? Na vuvuna kubarae, beta ni kulimiu miu kata longoria kagu polea. ");
INSERT INTO wiv_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Miu ta habu tutuni tamamiu kua, a Satan, miu ka lala miu kata kakatia nazia kua ia e lala kete kukulina kirina. Na vuna na varivuvuka za, ia na kakanaka hubi matematea na kaka, ki beta ni lala kete muri na maki kua e matoto, na vuna beta matotoka polea ni ngoro na poloka. Vairukua; ia kana polea matoto kena. Na vuna ia kakanaka vairukua ki vuvuna mata vairukurukua laveve. ");
INSERT INTO wiv_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Palaka hau kua ta tatani matotonia polea ni miu, beta miu na bilip ni niau. ");
INSERT INTO wiv_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Azei ni miu kua e dangea kete tania habuka ta lala kata kakatia pekato? Kua hau na tatani matotonia polea, e kuziha ki beta miu na bilip ni niau? ");
INSERT INTO wiv_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Habu tutuni Vuvu, ia dia ta lala dia kata longoria polea ke Vuvu. Na vuvuna kua beta miu na longoria polea ke Vuvu, ia na vuna beta miu na ke Vuvu matoto.” ");
INSERT INTO wiv_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","A vuni Iuda dia ka tania, “E beta ni matoto kua hita ta tania kua ho tu bukuni Samaria, na hanitu ki holiholiho?” ");
INSERT INTO wiv_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","A Iesus ki tania ni dia, “Hau beta na hanitu ni hoholiholiau, palaka hau ta vavazahenia hizani Tamagu, palaka miu ta popole taduriau. ");
INSERT INTO wiv_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Hau ki beta na kakaze kete vazaheanga hizagu. Palaka na kaka katiu ia e kulina kete vazahenia hizagu, ia za ia da e lala habuka kagu polea e matoto o betaka. ");
INSERT INTO wiv_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Hau ta tani matotonia ni miu: Azei ho kua nu paho poto na kagu vaketeketea ia da mara beta nu mate.” ");
INSERT INTO wiv_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","A vuni Iuda dia ka tania kirina, “Kua hita te hada vutuvutuhia habuka ho na hanitu na poloko. A Abraham ia e mate, na profet kamahi ve dia ve ta mate, e ho ku tani barae, ‘Kua kaka katiu ni paho poto na kagu polea, ia mara beta ni mate.’ ");
INSERT INTO wiv_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","E kuziha? A Abraham, ia e mate; e ho tu dopa ku hizanga ni Abraham? Na profet kamahi dia ta varimateai! Ho tu tania ho azei matoto?” ");
INSERT INTO wiv_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","A Iesus ki tania ni dia, “Kua na kokona zaheni mulehiau, kagu kona zahezahea ia beta ni matoto, palaka a Tamagu, kaka kua miu ta tania ia na kamiu Vuvu, ia, ia kua ia e kokona zahenia hizagu. ");
INSERT INTO wiv_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Palaka miu beta matoto miu na lala. Hau ta lala ia. Kua na tania beta na lala ia, ia da te mata vairukuruku habuka miu; palaka hau matoto ta lala ia ka paho poto na kana polea. ");
INSERT INTO wiv_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","A tubumiu a Abraham ia hilohilo matoto kilaka kua ia lolohoia kete hadavia kagu dama, kamana ki hadavia ia hilohilo.” ");
INSERT INTO wiv_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Dia ka tania kirina, “Ma beta ka krismas ni 50 pitu, ku tania tu hadavia a Abraham?” ");
INSERT INTO wiv_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","A Iesus ki tania ni dia, “Hau ta tani matotonia ni miu, ma beta a Abraham ni valohua hau muga za ta mimia.” ");
INSERT INTO wiv_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Pale, dia ta vilehia kedo dia kata vozohia vona, palaka ia vana paritigitigi ni dia kini vatia kadia tempel. ");
INSERT INTO wiv_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","A Iesus e vavana ki vano, ia hadavia na kaka katiu matana e keu. A titinana e valohia ki keu matana. ");
INSERT INTO wiv_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Kana disaipel kamahi dia ka hulenia, “Tisa, azei matoto e katia pekato, kuari ia kini valohua matana kini keu. Ia o tamana kamani titinana?” ");
INSERT INTO wiv_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","A Iesus ki tania ni dia, “Beta ni a tamana kamani titinana o kaka kuari ni katia pekato, palaka matana e keu manumanu dia kata hadavia matoto na matadia habuka a Vuvu kete gala vona. ");
INSERT INTO wiv_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","E ba dadama, ia tolu kata katia galanga kana kaka kua e geriau ka mai. Ta marigo ni mai, da beta kaka kete gala. ");
INSERT INTO wiv_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Kua ta ba vovona ri na vulovulo, ia hau na laet kara vulovulo.” ");
INSERT INTO wiv_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","E tani hozovia polea kua, ia livi kara garigari ia kamo pokizia kamana livoroka, ia taruhia na matana kaka kua. ");
INSERT INTO wiv_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ia tania vona, “Vano nu matu na poloka naru a Siloam.” (Mining na polea kua, a “Siloam” e tani barae, “E geura.”) Pale, na kaka kua ia vano matu, ia vamule, matana ti kemi ia kini hada. ");
INSERT INTO wiv_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Nuhu kua dia ta lala dia kata mimia kozoho na kaka kua, ia mai nuhu kua dia ta lala dia kata hadavia kua kete vavarinongu muga, dia ta hule, “Ia na kaka kua matana e keu ki lala kete mia ni vavarinongu kua?” ");
INSERT INTO wiv_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Taza dia ta tania, “Ia, ia za.” Taza dia ta tania, “Beu, kaka kuari ia e hada balika ia.” Palaka na kaka kua ki tania, “Beu ia hau za kua.” ");
INSERT INTO wiv_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Dia ka hulenia, “Pele ti kuziha mata kini kemi?” ");
INSERT INTO wiv_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ia ki tania, “Na kaka dia ta kohania a Iesus e katia tamotamo ki taruhia na matagu, ia geriau kata vano matu ni Siloam. Pale hau ta vano matu, kua matagu kini kemi kene hada.” ");
INSERT INTO wiv_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Dia ka hulenia, “Kue kaka kena kue?” Ia ki tania, “Hau beta na lala.” ");
INSERT INTO wiv_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Dia ta pelea na kaka kua muga matana e keu, kini zahe ni vuni Parisi. ");
INSERT INTO wiv_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Na dama kua a Iesus e katia na tamotamo ki kati kemihia na matana kaka kua, ia na Sabat. ");
INSERT INTO wiv_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","A vuni Parisi dia ta hulenia ve e kuziha matana kini kemi. Ia tania, “E taruhia na tamotamo na matagu hau ta vano matu, kua hau kene hada.” ");
INSERT INTO wiv_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Na Parisi taza dia ta tania, “Kaka kua beta ni pe ni Vuvu, na vuna beta ni lala kete mumuri na lo kara Sabat.” Palaka taza dia ka tania, “Kua ni ia kakanaka moge zahazaha, da e kati zingania na mirakel kamahi kua?” Pale, dia ta pole varivaigegeai dia kene varipe vulavulahi. ");
INSERT INTO wiv_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Dia ta hule mulehia kaka kua muga matana e keu, “Ho tu lohoi ziha vona? Na vuna ia e kati kemihia mata?” Na kaka kua ki tania, “Ia na profet.” ");
INSERT INTO wiv_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","A vuni Iuda beta dia na bilip habuka na kaka kua ia ia za kua muga matana e keu, kua kini kemi mule. Dia ta geu kiri tamana kamani titinana, ");
INSERT INTO wiv_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","dia ta hulenihiro, “Kaka kua ia tumoro kua? Ia za kua mo ta tania e valohua matana ki keu? E ziha kua meni ia kini hada?” ");
INSERT INTO wiv_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Tamana kamani titinana hiro ta tania, “Miro ta lala kaka kua ia na tu miro, miro ka lala ve e valohua matana ki keu; ");
INSERT INTO wiv_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Palaka kua ia ti hahada, ia beta miro na lala, ki beta ve miro na lala azei e katia ki kemi. Ia ti paraha kena, miu hulenia ia da e tania.” ");
INSERT INTO wiv_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Na tamana kamana titinana kaka kua, hiro ta kuahinia a vuni Iuda, kubarae hiro ka tani barae. Na vuna a vuni Iuda kava dia te taru lupunia polea kubarae; azei kua ni tania habuka a Iesus ia a Kristus za, ia da e rausianga ki beta kete ma lolotu kamadia na kadia haus lotu. ");
INSERT INTO wiv_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Kuza barae hiro ka tania, “Ia ti paraha kena; miu hulenia.” ");
INSERT INTO wiv_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Dia ta koi mulehia na kaka kua muga matana e keu, dia ka tani barae vona, “Vazahenia hizani Vuvu, Hita ta lala habuka kaka kua e kati kemihiho ia na kakanaka pekato.” ");
INSERT INTO wiv_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Na kaka kua ki tania ni dia, “Kua ia ni na kakanaka pekato, ia hau beta kata lala kena; palaka goloa hau ta lala ia kua: Muga hau ta keu, palaka kua hau te hada.” ");
INSERT INTO wiv_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Dia ka hulenia, “E kuzinganiho matoto? E kati zingania mata ki kemi?” ");
INSERT INTO wiv_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ia ki tania, “Hau kava te tania ni miu, miu beta ni kulimiu miu kata longoria. E kuziha ki kulimiu kata tani mulehia ve ni miu? Tauka e kulimiu miu kata kara kana disaipel kamahi ve?” ");
INSERT INTO wiv_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","A vuni Parisi dia ta pole zahatia matoto dia ka tania, “Ho na disaipel kana kaka kena! Hita na disaipel ke Moses kua! ");
INSERT INTO wiv_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Hita ta lala a Vuvu e pole kamani Moses, palaka na kaka kena, beta hita na lala ia pe ve ki mai kena!” ");
INSERT INTO wiv_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Na kaka kua ki tania, “Hau beta na longo lala polea kena miu ta tatania! Miu ta tania beta miu na lala ia e pe ve ki mai, palaka kua ia e katia matagu kini kemi. ");
INSERT INTO wiv_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tolu ta lala habuka a Vuvu beta ni lala kete longoria nuhuta pekato; palaka a Vuvu e lala kete lolongo kara nuhu kua dia ta lala dia kata kukuahinia dia ka kakatia nazia kua ia e lala kete kukulina kirina. ");
INSERT INTO wiv_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Kilaka kua a Vuvu e kati varivuvungania garigari ki mai, beta ni longora kaka katiu ni katia kaka kua e valohua matana ki keu, ni kemi mule. ");
INSERT INTO wiv_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ta kaka kua ni beta ni pe ni Vuvu, mara beta ni katia goloa katiu.” ");
INSERT INTO wiv_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Dia ka tania kirina, “Ho tu valohua ku paraha kamana pekato. Kua tu parakilania koto nu sikulnihita, ai?” Dia ta rausnia kete beta kete ma hoho mule ni lolotu na kadia haus lotu. ");
INSERT INTO wiv_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","A Iesus ki longoria habuka dia te rausnia kaka kua na kadia haus lotu, ia paria kaka kua ia hulenia, “Tu bilip na Tuna Kaka?” ");
INSERT INTO wiv_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Na kaka kua ki hule, “Paraha, Tuna Kaka ia azei matoto? Tania ni niau hau kata bilip vona.” ");
INSERT INTO wiv_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","A Iesus ki tania vona, “Ho kava tu hadavia, kua ia za kua e popole kamaniho.” ");
INSERT INTO wiv_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Pale, na kaka kua ia tania, “Paraha, hau ta bilip!” Ia padonia tutura karua na kabeni Iesus kini lotu vona. ");
INSERT INTO wiv_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","A Iesus ki tania, “Hau ta ziho kara vulovulo kata sikelnia manumanu, kata katia, manumanu kua dia ta keu dia kata hada mule, nuhu kua matadia e hahada dia kata keu.” ");
INSERT INTO wiv_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Na Parisi taza dia ta mamadi kozoho kamana dia ka longoria polea kua a Iesus e tania, dia ta tani barae, “E kuziha ku tania matahita e keu?” ");
INSERT INTO wiv_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","A Iesus ki tania ni dia, “Kua matamiu ni keu, ia mara beta miu na katia moge zahazaha. Palaka kua miu te tania matamiu e hahada, kubarae kamiu moge zahazaha ia e ba vovona.” ");
INSERT INTO wiv_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","A Iesus e tani barae, “Hau ta tani matotonia ni miu, kaka kua tani beta ni pe na doa kara banis na sipsip ni hoho, palaka kua ni papane ni pe na palaka katiu ni hoho kara poloka banis, kaka kena, ia na raskol ki mata vanaho. ");
INSERT INTO wiv_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Palaka na kaka kua e pe na doa kara geit ki hoho, ia na kakanaka hada potopotoa matoto na sipsip kamahi kena. ");
INSERT INTO wiv_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Na kaka kua e hada poto na geit, da e vukazia na doa kara kakanaka hada potopotoa na sipsip kua. Na sipsip kamahi dia ta longo lala kana koia. Ia da e kohania hizana sipsip katiukatiu, ki peledia, dia ta gotalatala. ");
INSERT INTO wiv_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Tani pelea kana sipsip laveve dia na gotalatala, ia vamuga ni dia, na sipsip kamahi dia ta muri vona, na vuna dia ta longo lala kana koia. ");
INSERT INTO wiv_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Mara beta dia na muri veta na kaka motu katiu; da dia ta varihavai vona na vuna beta dia na longo lala koia kana kaka motu.” ");
INSERT INTO wiv_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","A Iesus e barikikinia polea kua ni dia, palaka beta dia na longo lala nazia ia e popole vona. ");
INSERT INTO wiv_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","A Iesus ia tani mulehia ni dia, “Hau ta tani matotonia ni miu, hau ia na doa kana sipsip. ");
INSERT INTO wiv_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Manumanu laveve kena dia ta muga dia ka mai ni niau, ia dia na raskol kamahi, dia ka mata vanaho, palaka na sipsip kamahi beta dia na longoria kadia polea. ");
INSERT INTO wiv_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Hau ta habuka na doa kara geit kua na sipsip e hoho ki pe vona; nuhu kua dia ta pe ni niau dia ka hoho, ia da a Vuvu e vaikoli kiridia, da dia ta hoho dia ka gotala dia ka paria na raburabu pa, kua dia kata hania. ");
INSERT INTO wiv_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Na kakanaka vanahoa e mai za kete vanahea ni vairohia ni hubi matehia na sipsip kamahi. Hau ta mai dia kata pelea mahuria, dia na pelea mahuria ni vonu matoto ni dia. ");
INSERT INTO wiv_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Hau na kaka kemi kara hada potopotoa na sipsip. Kaka kemi kara hada potopotoa na sipsip, ia da e mate kara kana sipsip kamahi. ");
INSERT INTO wiv_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ta kaka kua ni beta ni ia na tauana sipsip, ni kadoa ia za kete hada poto na sipsip kamahi za, kua ni hadavia na kaua varihanihani ni mai, ia da e hava tapunia na sipsip kamahi; pale, na kaua varihanihani kua ia mai vaihani na sipsip kamahi kua, dia ta bura katiutiu. ");
INSERT INTO wiv_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Na kaka kua e kadoa kete hahada poto na sipsip kamahi, e hava na vuna ia e gagala kara moni za, ki mara beta ni lohoi kara sipsip kamahi. ");
INSERT INTO wiv_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Hau na kaka kemi kara hada potopotoa na sipsip; hau ta lala sipsip kua e kagu, dia ve dia ka lalau, ");
INSERT INTO wiv_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","habuka kua a Tamagu ia e lalau, hau ve ka lala a Tamagu; hau ka vati mazukenia livuhagu kara kagu sipsip kamahi. ");
INSERT INTO wiv_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Kagu sipsip taza ve kua beta dia na bukuna kagu kabuna sipsip kamahi kua, ia dia ve kata peledia ve, dia ve da dia ta longoria kagu koia. Dia kata mai lupu dia na kara kabuna sipsip katiu za, na kakanaka hada potopotoa na sipsip ni katiu papa. ");
INSERT INTO wiv_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","A Tamagu e kulina matoto kirigu, na vuna hau te longoria kana polea kua da katane mate, palaka da ta mahuri mule. ");
INSERT INTO wiv_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Mara beta kaka katiu ni hubi matehi vetaniau, hau ta vala mazukeni mulehiau na kagu lohoihoia mule. Hau kagu matuhanga vona kata vala mazukenia, kagu matuhanga vona kata pele mulehia; a Tamagu ia e geriau kata kati baraenia.” ");
INSERT INTO wiv_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","A vuni Iuda kamana dia ka longoria polea kua, dia ta varipe vulavulahi mule ve. ");
INSERT INTO wiv_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Dia luba dia ta tania kiri Iesus, “Ia na hanitu e holiholia, ki vavalaha; e kuziha miu ka lolongo kara kana polea?” ");
INSERT INTO wiv_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Palaka taza ni dia, dia ka tania, “Polea kua beta ni kana kaka kua vule zaha na poloka kua. Kua kaka ni vule zaha na poloka, e dangea kete kati kemihia kaka kua matana e keu?” ");
INSERT INTO wiv_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Kilangata kua, na lotua kapou katiu e bele ni Ierusalem. Dia kata makia dama kua dia ta makia na Tempel kini kara ruma ke Vuvu za. Na taem kua ia na nagi kara magara. ");
INSERT INTO wiv_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Pale, a Iesus ki vanavana na poloka banis na Tempel, na varanda ke Solomon. ");
INSERT INTO wiv_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","A vuni Iuda dia ta mai madi lobia, dia ka hulenia, “Da ngiza matoto kunu tani kakava ni hita? Tani matotonia polea ni hita. Ia ho za a Kristus?” ");
INSERT INTO wiv_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","A Iesus ki tania ni dia, “Hau kava te tania ni miu, palaka beta ni kulimiu miu kata bilip. Na galanga kamahi kua ta kakatia na hizani Tamagu, ia e vavatunga kakavau ni miu; ");
INSERT INTO wiv_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","palaka ia beta za miu na bilip, na vuna beta miu na bukuna kagu kabuna sipsip kamahi. ");
INSERT INTO wiv_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Kagu sipsip kamahi dia ta longo lalau, hau ka lala dia ve, dia ka mumuri ni niau. ");
INSERT INTO wiv_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Hau ta vala ni dia mianga kara mahuri roroa, ki mara beta dia na golu; mara beta matoto kaka katiu ni pele kakava dia na limagu. ");
INSERT INTO wiv_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","A Tamagu kua e valadia ni niau, ia e dopa ki hizanga, ki mara beta matoto kaka katiu ni pele kakava katiu ni dia, na limani Tamagu. ");
INSERT INTO wiv_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Hau kamani Tamagu ia miro ta katiu za.” ");
INSERT INTO wiv_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","A vuni Iuda dia ta pelepele mule kedo dia kata vozohia. ");
INSERT INTO wiv_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","A Iesus ki hulenidia, “Hau ta vatunga na matamiu laveve na galanga kemikemi kua a Tamagu e vala ni niau kata katia. Galanga kakei ni dia kua ta kati zahatia, miu ka hada ki zaha, miu kata vozohiau taraka?” ");
INSERT INTO wiv_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Dia ka tania vona, “Beta hita na tania hita kata vozohiho taraka galanga kamahi kena tu katia, palaka taraka kua tu dedelahania a Vuvu. Na vuna, ho tu kaka habuka hita kua za, ku tania ho a Vuvu.” ");
INSERT INTO wiv_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","A Iesus ki tania, “Karae beta ni vapolunganga na kamiu lo ni tanga kua a Vuvu e tani barae, ‘Miu na vuvu kamahi.’ ");
INSERT INTO wiv_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Tolu ta lala nazia kua na polea ke Vuvu e tania, ia e matoto dama laveve ki mara beta kaka katiu ni pokizia; a Vuvu ia ki kohania na nuhu kua e vala kana polea ni dia, na vuvu kamahi. ");
INSERT INTO wiv_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Palaka hau a Vuvu mule e makiau ki geriau ka ziho kara vulovulo. E kuziha kua hau ta tania hau na Tuni Vuvu, miu ka tania hau ta dedelahania a Vuvu? ");
INSERT INTO wiv_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Kua tani beta na gagala na galanga kua a Tamagu e tania kata katia, pele taua miu na bilip ni niau. ");
INSERT INTO wiv_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Palaka kua hau na kakatia kana galanga, ia vata kua beta miu na bilip ni niau, palaka miu kata bilip na kagu mirakel kamahi, miu kata lala matotonia habuka a Tamagu ia na polokogu, hau ve na poloki Tamagu.” ");
INSERT INTO wiv_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Dia ta parakilani mulehia dia kata haba taduria, palaka ia hava hutu ni dia. ");
INSERT INTO wiv_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Pale, a Iesus ia vamule, ia pe poki na naru a Iordan, ia vano kara palaka kua a Jon kakanaka baptais muga e vavala baptais na manumanu vona, kini mia vona. ");
INSERT INTO wiv_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Manumanu luba dia ta mai vona, dia ka tania, “A Jon beta ni katia mirakel kamahi, palaka goloa laveve kua e tania na vuna na kaka kua, e matoto.” ");
INSERT INTO wiv_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Pale, manumanu luba dia ta bilip vona. ");
INSERT INTO wiv_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Kaka katiu hizana a Lasarus e mazahitia. Ia e bukuni Betani na malala ke Maria kamani tazina a Marta. ");
INSERT INTO wiv_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","A Maria ia livuki Lasarus, kua e mazahitia ki ngongoro, ia tavinena za kua da ba muri kini valikiria na perpium kara kabena Paraha ki bizia na vuluka. ");
INSERT INTO wiv_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Varitazini karua kua hiro ta tulenia polea ki vano ni Iesus hiro ka tania, “Paraha, kaka kua e kuli matoto kirina e mazahitia.” ");
INSERT INTO wiv_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Kamana a Iesus ki longoria polea kua ia tania, “Mazahi kua mara beta ni mate vona. Beu, ia kete katia manumanu dia na hada na matuhanga ke Vuvu dia na vazahenia hizana. Na dala kua za tuni Vuvu ve da e pelea hiza kapou.” ");
INSERT INTO wiv_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","A Iesus e lala kete kulina matoto kiri Marta hiro a tazina ia mai ve livukuhiro kua a Lasarus. ");
INSERT INTO wiv_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Kamana ki longoria habuka a Lasarus e mazahitia, ia beta ni vano tapu, e mia dama rua ve na palaka kua e mimia vona. ");
INSERT INTO wiv_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Muri na dama rua kua, ia tania na kana disaipel kamahi, “Tolu kata vamule vano kiri Iudea.” ");
INSERT INTO wiv_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Kana disaipel kamahi dia ta tania, “Tisa, ba ngora za kua a vuni Iuda ra kena dia ta parakilania dia kata vozohiho, e kuziha kena koto nu vamule vano kiri rae?” ");
INSERT INTO wiv_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","A Iesus ki kolia kadia polea ki tania, “Dama katiukatiu, ia aua e 12 vona, te? Kubarae kua kaka katiu ni vavana na dama, ia mara beta ni tupa, na vuna zia ia e hahada na hadanga kara vulovulo. ");
INSERT INTO wiv_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Palaka kua kaka ni vavana na marigo da e tupa na vuna beta hadanga vona kete hada.” ");
INSERT INTO wiv_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Kamana ki tani hozovia polea kua ia tania ni dia, “Kadolu kaka a Lasarus ti ngoro, palaka hau kata vano na vakongania ni lama.” ");
INSERT INTO wiv_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Kana disaipel kamahi dia ta longoria polea kua dia ka tania, “Paraha, pele kini ngongoro, tauka da e kemi mule.” ");
INSERT INTO wiv_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","A Iesus ia e tatania habuka a Lasarus ti mate, palaka kana disaipel kamahi dia ta lohoia dia ka tania e tania a Lasarus e ngongoro za. ");
INSERT INTO wiv_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Pale, a Iesus ia tani kakava ni dia ki tania, “A Lasarus ti mate, ");
INSERT INTO wiv_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","palaka e kemi ki beta hau kamana ki mate, na vuna ta lohoihoi ni miu, miu kata bilip. Palaka, miu mai tolu kata vano vona.” ");
INSERT INTO wiv_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","A Tomas, ruani hizana kua a Didimus, ia e tani barae ni habu tamaninika na disaipel kamahi, “Mai tolu kata vano kamana, tolu na mate kamana.” ");
INSERT INTO wiv_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","E vano bele ni Betani, ia ti paria habuka a Lasarus kava ti ngoro na poloka lovo dama ti garamo kava. ");
INSERT INTO wiv_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Na malala kua a Betani, ia e kozoho ni Ierusalem, e hada barae e 3 kilomita za, ");
INSERT INTO wiv_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","a vuni Iuda luba dia ta mai ni Marta hiro a Maria, dia ka mia kamahiro, dia kata katia magalihiro ni kemi, na vuna na matea ke livukuhiro, a Lasarus. ");
INSERT INTO wiv_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Tania a Marta ki longoria kua ti tanga habuka a Iesus e mamai, ia vatia a Maria na kahiro ruma, ia vavana vano ki paria a Iesus na dala. ");
INSERT INTO wiv_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","A Marta ki tania ni Iesus, “Paraha, ni ho ri kua, mara beta livukugu ni mate. ");
INSERT INTO wiv_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Palaka meni kua hau ta lala habuka kua nu hulenia a Vuvu kara goloa katiu, a Vuvu da e vala ni niho.” ");
INSERT INTO wiv_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","A Iesus ia tania vona, “Livuku da e mahuri mule.” ");
INSERT INTO wiv_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","A Marta ki tania, “Hau ta lala da e mahuri mule na Las De kamana manumanu laveve kua dia te varimateai kava.” ");
INSERT INTO wiv_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","A Iesus ki tania vona, “Mahuri mulea ia ni niau. Laep ia ni niau; azei ho tanu bilip ni niau, ia vata kua tu mate kava, ia da tu mahuri, ");
INSERT INTO wiv_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","azei kua e ba mamahuri ki bilip ni niau, ia mara beta ni mate. Tu bilip na polea kua?” ");
INSERT INTO wiv_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","A Marta ki tania, “E, hau ta bilip habuka ho a Kristus, na Tuni Vuvu, kua a Vuvu e geria kete ziho ni pele mulehia manumanu na garigari.” ");
INSERT INTO wiv_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Kamana a Marta ki tani hozovia na polea kua ia vamule vano kara ruma ia kohania tazina a Maria, ia tani vilagea vona, “A tisa ia ri kua ki huhule kiriniho.” ");
INSERT INTO wiv_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","A Maria e longoria polea kua, ia di madi ia baribari vano ni Iesus. ");
INSERT INTO wiv_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","A Iesus ia ma beta ni hoho na malala, e ba vovona na palaka kua a Marta e paria vona. ");
INSERT INTO wiv_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","A vuni Iuda kua dia ta mimia kamani Maria dia ka lololo kamana, dia ta hada kua a Maria e divurutia ki madi ki gotala, dia ta muri vona. Dia ta lohoia dia ka tania a Maria kete vano kara matmat ni tangi. ");
INSERT INTO wiv_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Kamana e vano ki bele na palaka kena a Iesus vona ki hadavia, ia dua kara kabena ki tania, “Paraha, ni ho ri kua mara beta livukugu ni mate.” ");
INSERT INTO wiv_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Kamana a Iesus ki hadavia e tatangi, ki hadavia ve nuhu kua dia ta kamana dia ta tatangi ve, lohora ki zaha matoto, ia ve kini tania keteni tatangi ve. ");
INSERT INTO wiv_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ia hulenidia, “Miu ta tavunia ni ve?” Dia ka tania, “Paraha, mai nu hadavia.” ");
INSERT INTO wiv_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","A Iesus ia tangi. ");
INSERT INTO wiv_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","A vuni Iuda dia ka hadavia dia ka tania, “Hadavia, e kulina matoto kirina!” ");
INSERT INTO wiv_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Palaka taza ni dia, dia ta tania, “E lala kete kati kemihia nuhu kua matadia e keu, te! E kuziha ki beta ni kulina kete kodonia kaka kua, kua ia kini mate?” ");
INSERT INTO wiv_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","A Iesus magalina e zobo matoto, ia vano kara matmat. Na lovo kua, e hovua na hiripa kedo, ki taba porota hatamara na kedo. ");
INSERT INTO wiv_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","A Iesus ki tania ni dia, “Miu puke kakava kedo.” A Marta, livuka kaka kua e mate ia tania, “Paraha, da bavuka e hubi kiridolu, na vuna ia ti ngoro na poloka lovo dama ti garamo.” ");
INSERT INTO wiv_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","A Iesus ki tania kirina, “Beta na tania ni niho, kua nu bilip, da tu hada na matuhanga ke Vuvu?” ");
INSERT INTO wiv_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Pale, dia ta puke kakava na kedo. A Iesus ia hada vatada ki tani barae, “Tamagu, hau ta hate motuniho na vuna kava tu longoriau. ");
INSERT INTO wiv_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Hau ta lala dama laveve ho tu lala koto lolongoriau, palaka hau ta tani barae kua, na vuna manumanu kua dia ta tatabu longo kua, dia kata bilip habuka ho tu geriau ka mai.” ");
INSERT INTO wiv_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Kamana ki tani hozovia polea kua, ia goe ki tania, “Lasarus, mai gotala!” ");
INSERT INTO wiv_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Na kaka mate ia mai gotala, kamana lavalava kua e kukula livuhana kamana bakana vona. A Iesus ia tania ni dia, “Miu pele kakava lavalava na livuhana, miu ta vatia ia vano.” ");
INSERT INTO wiv_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Kubarae a vuni Iuda luba kua dia ta mai dia kata balahea a Maria, dia ka hadavia goloa kua a Iesus e katia, dia ta bilip vona. ");
INSERT INTO wiv_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Palaka, taza ni dia, dia ta vamule vano dia ta tania ni vuni Parisi na goloa kua a Iesus e katia. ");
INSERT INTO wiv_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Pale, na hetpris kamahi kamana Parisi kamahi dia ta lupu kamana kaunsil kamahi. Dia ta tani barae, “Tolu kata kuziha matoto? Miu hadavia mirakel kamahi kua na kaka kua e kakatia. ");
INSERT INTO wiv_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ta tolu na ma vatia ni ma kukubarae, manumanu laveve da dia te bilip vona, a vuni Rom dia ta mai vairohia kadolu tempel kamana kadolu kantri!” ");
INSERT INTO wiv_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Palaka kaka katiu ni dia, hizana a Kaiafas, ia na hetpris kara krismas kua, ia tani barae, “Miu beta matoto miu na lala goloa katiu! ");
INSERT INTO wiv_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Beta miu na lohoi lala habuka e dopa ki kemi kadolu kua na kaka katiu za kete pelea mudina manumanu laveve ni mate, tabarae manumanu laveve na kantri kua ni vairohadia.” ");
INSERT INTO wiv_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Beta ni na vuna na kana lohoihoia mule ki tania polea kua, palaka ia e habuka ia na hetpris kilaka kua, ia ki tatani mugania polea habuka, a Iesus kete mate kiri vuni Iuda laveve. ");
INSERT INTO wiv_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Palaka beta ni kete mate kiri vuni Iuda za, beta, da e mate kete lupuni mulehia ve habu tutuni Vuvu kua dia ta zidi barara vetaveta na malalala motumotu, dia kata mai lupu mule dia na bele kabu katiu za. ");
INSERT INTO wiv_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Kilangata pamuhi dia ta taru lupunia polea dia kata kazekaze dala dia kata hubi matehia a Iesus. ");
INSERT INTO wiv_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Kuza barae a Iesus kini beta ni ma vana kavakava na pidaki vuni Iuda. Ia vatia a Iudea ia vano kara malala katiu kozoho na deset, kara taon katiu e kohanga a Efraim, ia kamana kana disaipel kamahi, dia ta loli vona. ");
INSERT INTO wiv_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Pale, na dama kara hanihania kapou na Pasova ti kokozoho, kubarae manumanu luba dia kene vati mugania kadia malalala dia kene zazahe kiri Ierusalem, dia kata katia maki kua dia ta lala dia kata kakatia, dia kata klin mule na matani Vuvu. Ba muri na hanihania kapou kara Pasova kini lohu. ");
INSERT INTO wiv_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Dia ka hahada kiri Iesus, kilaka kua dia ta lupu na poloka tempel, dia ka vavarihulei, “Miu ta lohoi ziha, karae da beta kete mai na hanihania kapou?” ");
INSERT INTO wiv_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Na hetpris kamahi kamadia vuni Parisi kamahi, kava dia te vala polea matuha pebarae, azei kini lala kamuzia a Iesus ni ve matoto, kete kalohunia dia kata paho taduria. ");
INSERT INTO wiv_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Dama 6 muga na damana hanihania kapou kara Pasova, a Iesus ia zahe bele ni Betani. Betani ia na malala ke Lasarus, kaka kua a Iesus e valamari mulehia na matea. ");
INSERT INTO wiv_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Dia ta katia hanihania kapou ni Iesus. A Marta ia tabirabira hadia haninga, a Lasarus ia e kamana nuhu kua dia ta mimia kamani Iesus na tebol. ");
INSERT INTO wiv_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Pale, a Maria ia pelea na botole kapou na perpium e hubi papa e kadoa na moni kapou matoto. Ia mai valikiria kara kabeni Iesus ia bizia na vuluka. Na bavuka perpium kua ki hubi na poloka ruma. ");
INSERT INTO wiv_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Na disaipel ke Iesus katiu, hizana a Iudas Iskariot, kaka kua ba muri kete vala a Iesus na limani vuni Iuda, e tani barae, ");
INSERT INTO wiv_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“E kuziha ki beta ni vatia tolu na salinia na perpium kua tolu na pelea 300 Kina vona tolu na vala monina kana nuhu kua beta kadia goloaloa vona?” ");
INSERT INTO wiv_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","A Iudas e tani barae, beta ni habuka e lohoihoi na nuhu kua beta kadia goloaloa vona, palaka ia na mata vanaho katiu. Ia e lala kete hahada poto na kadia hanpaus kara moni, ki lala kete vavanaho na poloka. ");
INSERT INTO wiv_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Palaka a Iesus ki tania, “Miu vatia tavine kua. Miu vatia ni paho poto na kana perpium kete kara dama kua kete tavuanga hau. ");
INSERT INTO wiv_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Manumanu kua beta kadia goloaloa vona, da dia ta ma mimia kamamiu, palaka hau mara beta na ma mimia kamamiu.” ");
INSERT INTO wiv_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Na kabuna manumanu luba bukuni Iuda dia te lala habuka a Iesus ia ni Betani dia ta lohu, beta ni habuka dia kata hada a Iesus za, palaka dia kata hadavia a Lasarus ve, kaka kua a Iesus e valamari mulehia na matea. ");
INSERT INTO wiv_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Kubarae na hetpris kamahi dia ta taru lupunia kadia polea dia kata hubi matehia ve a Lasarus, ");
INSERT INTO wiv_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","na vuvuna kua na goloa kua a Iesus e katia ni Lasarus, kubarae a vuni Iuda luba dia te vatia na hetpris kamahi kua dia kene bilip ni Iesus. ");
INSERT INTO wiv_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ti dama mule, na kabuna manumanu kapou, kua dia ta lohu kara hanihania kapou na Pasova, dia ta longoria habuka a Iesus ti zazahe kiri Ierusalem. ");
INSERT INTO wiv_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Dia ta vilehia na dangana baibai dia kene vana tarengania, dia ka gogoe dia ka tatania, “Hosana! Paleka a Vuvu ni kati kemihia matoto na kaka kua e mamai na hizana Paraha! Vuvu, kati kemihia matoto na King ke vuni Israel!” ");
INSERT INTO wiv_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","A Iesus ia pelea na donki katiu ia polo vona, balika za kua e vapolunganga na poloka buk ke Vuvu, ki tanga, ");
INSERT INTO wiv_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Manumanu bukuna taon kapou a Saion, taua miu na kuahi. Hadavia kamiu King kua ti mamai e mimia na huduna donki huluvahu ki mamai.” ");
INSERT INTO wiv_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Kilangata kua kana disaipel kamahi beta dia na lohoi lala goloa kamahi kua. Muri na kua a Vuvu ti valamari mulehia a Iesus kini vala glori vona, dia te lohoi mulehia na polea kua e vapolunganga ki tanga habuka; da dia ta kati baraenia ni Iesus. ");
INSERT INTO wiv_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Nuhu kua dia ta kamani Iesus kilangata kua a Iesus e koi kiri Lasarus ki valamari mulehia na matea, dia kava dia te tania goloa kua kini vana lobia manumanu laveve. ");
INSERT INTO wiv_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Na vuna manumanu dia te longoria na goloa kua a Iesus e katia, kubarae dia kene pe tarengania a Iesus dia kata zahe vona. ");
INSERT INTO wiv_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","A vuni Parisi dia ka pole mai vano na pidaka dia mule dia ka tania, “Miu hadavia, goloa laveve kena tolu ta tatania tolu kata katia vona, ia da ti mara beta! Manumanu laveve na vulovulo dia te mumuri vona.” ");
INSERT INTO wiv_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","A vuni Grik taza dia ta bele ni Ierusalem kilangata kua kara hanihania kapou na Pasova. ");
INSERT INTO wiv_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Dia ta mai bele ni Filip, a Filip ia bukuni Betsaida ni Galili, dia ta tani barae, Filip, “Kulihita hita kata hada a Iesus.” ");
INSERT INTO wiv_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","A Filip ia vano tania ni Andru; hiro ta rua vano tania ni Iesus. ");
INSERT INTO wiv_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","A Iesus ki tania, “Na dama kua e makua kana Tuna Kaka keteni pelea glori kava ti bele. ");
INSERT INTO wiv_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Hau ta tani matotonia ni miu, ta harana vit ni beta ni dua kara garigari ni mate, da ia e ma ki kara harana vit za, palaka kua tani dua ni mate, ia da ti galulu kini vua kini taruhia paleka luba matoto. ");
INSERT INTO wiv_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Nuhu kua dia ta lala kete kukulidia matoto kara kadia mianga, da dia ta paho kavu kirina; nuhu kua beta dia na lala dia kata lolohoi marata na kadia mianga pa, ia da dia ta paho poto vona kara mahuri roroa. ");
INSERT INTO wiv_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Azei kua e kulina kete vora kagu, ia kete muri ni niau, malala kakei ta kirina, ia kagu vora ve ia da e kamaniau. Pale, a Tamagu ia da ti hada zahenia azei ho kua tu vovora kagu.” ");
INSERT INTO wiv_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Kua, magaligu e zobo matoto. Palaka kata tani ziha? Kata tani barae, ‘Tamagu, pele kakava goloa kua keteni bele ni niau?’ Beta, ia na vuvuna za kua hau ta mai. ");
INSERT INTO wiv_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tamagu katia hiza ni dopa vazaheanga!” Pale, halingana kaka katiu e pe na lagato ki tania, “Hau kava te vala glori na hizagu, hau da ta vazaheni mulehia ve.” ");
INSERT INTO wiv_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Na kabuna manumanu kua dia ta varimadiriai dia ta longoria halingana kaka kua. Taza dia ka tania na mariaba e vulukururu. Taza dia ta tania na engel katiu e pole kamani Iesus. ");
INSERT INTO wiv_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","A Iesus ki tania ni dia, “Na halinga kua miu ta longoria, ia e mai kete kodonimiu, beta ni mai kagu. ");
INSERT INTO wiv_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Kua ti damana a Vuvu keteni koto kara manumanu na vulovulo; na paraha kua e lala kete hahada na vulovulo da ti kali kakavanga; ");
INSERT INTO wiv_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","palaka hau, ta na vazaheanga, da ta harehia manumanu laveve dia ka mai ni niau.” ");
INSERT INTO wiv_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","E tania polea kua kete vatunga kua ia da e mate ziha. ");
INSERT INTO wiv_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Na kabuna manumanu kua dia ka tania, “Kadolu lo e tania, habuka a Kristus da e mahuri roro. E kuziha ku tania habuka, ‘Na Tuna Kaka da e vazaheanga ki zahe’? Azei matoto ia na ‘Tuna Kaka’?” ");
INSERT INTO wiv_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Pale, a Iesus ia tania ni dia, “Na Laet da e kamamiu ki vano pitu papa ve. Miu vavana kua miu ta ba hahada na balangana, kete beta rodo kete kari havutimiu; na vuna zia, na kaka kua e vavana na rodo, beta ni lala ia e kikirive. ");
INSERT INTO wiv_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Kua na Laet e ba kakamamiu, miu bilip vona, miu na kara habu tutuna Laet.” Kamana a Iesus ki tani hozovia polea kua, ia vavana kini paritigi ni dia. ");
INSERT INTO wiv_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","A Iesus e katia mirakel luba matoto na matani vuni Iuda, palaka beta za dia na bilip vona. ");
INSERT INTO wiv_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Kubarae, na polea ke profet Aisaia ti pori matoto: ia e tani barae, “Paraha, azei e bilip na polea kua hita ta vavala? Azei e hadavia na Paraha kua e vatunga kakava kana matuhanga vona?” ");
INSERT INTO wiv_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Kubarae, ki mara beta dia na bilip. Na vuna polea ke Aisaia katiu ve kua e tani barae, ");
INSERT INTO wiv_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“A Vuvu ti bara keuhia matadia, kini tabaria kadia lohoihoia, kete beta dia kata hada, kete beta ve dia kata lohoi lala, kete beta dia kata tare poki dia na vamule ni Vuvu ia ni kati kemihidia.” ");
INSERT INTO wiv_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","A Aisaia ia e tani barae na vuna ia kava ti hada na glori ke Iesus, ia ki popole vona. ");
INSERT INTO wiv_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Palaka, na pararaha ke vuni Iuda luba dia ta bilip ni Iesus, palaka dia ta kuahinia a vuni Parisi, ki beta dia na tani kakava kadia bilip. Dia ta kuahi tabarae dia na tabunidia, ni beta dia kata ma hoho na poloka haus lotu ke vuni Iuda. ");
INSERT INTO wiv_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Na vuna e kulidia manumanu kete vazahenia hizadia, beta ni kulidia a Vuvu kete vazahenia hizadia. ");
INSERT INTO wiv_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","A Iesus ia pole kapopou ki tania, “Azei ho tu bilip ni niau, ia ho tu bilip ve na Kaka kua e geriau ka mai. ");
INSERT INTO wiv_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Azei e hadaviau, ia kava ti hadavia Kaka kua e geriau. ");
INSERT INTO wiv_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Hau ta ziho na vulovulo habuka laet, kua kaka ni bilip ni niau, ia mara beta ni ma mimia rodo. ");
INSERT INTO wiv_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Azei ho tu longoria kagu polea kamahi ki beta nu muri vona, mara beta na koto kiriniho, na vuna beta na geura kata koto kara manumanu na vulovulo, hau ta ziho kata vaikoli kara manumanu. ");
INSERT INTO wiv_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Nuhu kua dia ta pole katiau ki beta dia na pelea kagu polea, kakanaka vona da e koto kiridia. Na polea laveve kua ta vavala, ia da e koto kiridia na las de. ");
INSERT INTO wiv_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Na vuna hau beta na tatani vetania polea kamahi kua na kagu lohoihoia mule, palaka a Tamagu ia e tani vatuharia polea kakei ni niau kata tania, hau ka tatania. ");
INSERT INTO wiv_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Hau ka lala polea ke Tamagu ia e lala kete vala mahuri roroa. Kubarae nazia kua hau ta tatania, ia a Tamagu e geriau kata tania.” ");
INSERT INTO wiv_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Na dama muga vona, ba muri na dama na hanihania kapou kara Pasova kini bele, a Iesus ia ti lala kana dama ti kozoho keteni vatia vulovulo ni zahe mule ni Tamana. E kulina matoto kara habu kana kua ri na vulovulo, ki vatunga matotonia habuka, e kulina matoto kiridia, ia ia ki vano ki mate. ");
INSERT INTO wiv_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Dia ta hanihani na garavi, a Satan ia kava ti vala lohoihoia ni Iudas Iskariot tuni Saimon, kete vala a Iesus. ");
INSERT INTO wiv_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","A Iesus ia ti lala habuka a Tamana ia ti taruhia matuhanga laveve na limana kete katia goloa laveve. Ia ki lala ve habuka ia e pe ni Vuvu ki ziho, kua keteni vamule ni Vuvu. ");
INSERT INTO wiv_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Pale, a Iesus ia madi ia vatia tebol, ia hulia kana zohozohoa kiri hatama ia taza taol na votaka, ");
INSERT INTO wiv_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","ia valikiria naru kara poloka dis katiu. Ia vazuguvia kabena kana disaipel kamahi ki bizia kabedia na taol kena e taza na votaka. ");
INSERT INTO wiv_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","A Iesus ia mai ni Saimon Pita, a Saimon Pita ia hulenia, “Paraha, koto nu vazuguvia kabegu?” ");
INSERT INTO wiv_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","A Iesus ki tania, “Kua, mara beta nu lohoi lala nazia hau ta kakatia, palaka muri da tu lohoi lala.” ");
INSERT INTO wiv_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","A Pita ia tania, “Mara beu, mara beta nu vazuguvia kabegu.” A Iesus ki tania, “Tani beta na vazuguviho, ia da beta koto ma kakamaniau.” ");
INSERT INTO wiv_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","A Saimon Pita ki tania, “Pele kini kuza barae beta koto vazuguvia kabegu za, vazuguvia ve limagu kamana bakagu!” ");
INSERT INTO wiv_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","A Iesus ia kolia kana polea ki tania, “Kaka kava ti matu beta kete matu mule ve, da e vazuguvia za kabena; livuhana laveve kava ti puzopuzoa. Miu te puzopuzoa kava, palaka beta ni miu laveve.” ");
INSERT INTO wiv_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","A Iesus ia kava ti lala azei da e vala ia na limani vuni Iuda ia kubarae, ki tani barae, “Beta miu laveve miu na puzopuzoa.” ");
INSERT INTO wiv_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Kamana ti vazugu hozovia kabedia, ia loho mulehia kana zohozohoa kini vano mia mule na mudina. Ia hulenidia, “Miu ta hada lala nazia kua ta katia ni miu? ");
INSERT INTO wiv_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Miu ta kohaniau na ‘Tisa’ kamana ‘Paraha’ ia e mahoto, hau kamiu tisa kamana kamiu Paraha. ");
INSERT INTO wiv_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Hau, kamiu Paraha kamiu tisa, ta vazuguvia kabemiu kua, miu ve miu vazuguvia kabeni habu kurakuramiu. ");
INSERT INTO wiv_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Hau kavanga te vatunga ni miu, nazia kua miu kata kakatia, miu kata muri ni niau miu na katia nazia kua ta katia ni miu. ");
INSERT INTO wiv_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Hau ta tani matotonia ni miu, beta vora katiu ni paraha na kana tubu, beu kakanaka vakilalanga ni paraha na kaka kua e geria. ");
INSERT INTO wiv_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Kua kava miu te lala goloa kua. Da miu ta dopa hilohilo matoto kua ta miu na kakatia galangalanga kamahi kua. ");
INSERT INTO wiv_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Beta hau na tatania kirimiu laveve; hau ta lala nuhu kua hau te makidia. Palaka na polea kana Paraha ia kete pori; kua e tani barae, ‘Na kaka kua e varipirupiru kamaniau ti tare poki kirigu.’ ");
INSERT INTO wiv_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Hau kava te muga tania ni miu, kua kini bele, ia da miu te bilip habuka, Hau ia Hau za. ");
INSERT INTO wiv_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Hau ta tani matotonia ni miu, azei tani kulina kara kaka kua Hau ta geria, ia e kulina kirigu; azei tani kulina kirigu ia e kulina ve kara Kaka kua e geriau ka ziho.” ");
INSERT INTO wiv_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Kamana e tani hozovia polea kua, magalina e zobo matoto ia tani kakava baraenia, “Hau ta tani matotonia ni miu, kaka katiu ni miu da e valau na limana hagu vagi kamahi.” ");
INSERT INTO wiv_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Kana disaipel kamahi dia ta varihada boroi mata, beta dia na lala e tania kiri zei ni dia. ");
INSERT INTO wiv_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Katiu ni dia kua a Iesus e kulina marata kirina, e mia kozohotia. ");
INSERT INTO wiv_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Kubarae a Saimon Pita ia mata katia ki tania vona, “Hulenia azei matoto kena e popole vona.” ");
INSERT INTO wiv_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Na disaipel kua ia vahere vano kozoho ni Iesus ia hulenia, “Paraha, azei matoto?” ");
INSERT INTO wiv_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","A Iesus ki tania vona, “Azei kua ta na lutia na dihura bret na poloka sup na vala vona, ia kakanaka kena.” Pale, ia lutia na dihura bret kua ia vala ni Iudas Iskariot tuni Saimon. ");
INSERT INTO wiv_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Kamana a Iudas ki pelea na bret, a Satan ia holiholi pamuhia. A Iesus ia tania vona, “Nazia koto katia, kati tapunia.” ");
INSERT INTO wiv_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Palaka beta katiu ni dia na hanihania kua ni lohoi lala e kuziha a Iesus ki tania polea kua kiri Iudas. ");
INSERT INTO wiv_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Na vuna kua a Iudas ia e lala kete hada poto na kadia moni, na disaipel taza dia ta lohoia dia ka tania a Iesus e gegeria kete vano kadea haninga kara hanihania kapou kara Pasova, o kete vala goloa taza na nuhu kua beta kadia goloaloa vona. ");
INSERT INTO wiv_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","A Iudas e hani hozovia na bret, ia gotala. Ti marigo kava. ");
INSERT INTO wiv_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Tania a Iudas ti gotala kini vano, a Iesus ia tani barae, “Meni kua na Tuna Kaka ti pelea hiza kapou matoto. A Vuvu da e pelea hiza kapou matoto na Tuna Kaka. ");
INSERT INTO wiv_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ta a Vuvu ni pelea glori na Tuna Kaka, a Vuvu da e vatunga kakava na glori kana Tuna Kaka na poloki Vuvu mule. A Vuvu da e vala tapunia glori vona. ");
INSERT INTO wiv_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Habu tutugu da beta kata mia ni havarau kamamiu. Da miu ta hada kiriniau, balika za kena hau ta tania ni vuni Iuda, kua ve te tania ni miu: Malala kata kirina, mara beta miu na bele vona. ");
INSERT INTO wiv_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Kata vala lo vahoru ni miu: Kete kulimiu kara manumanu. Habuka kua e kuligu kirimiu, ia miu ve kete kulimiu kara manumanu.” ");
INSERT INTO wiv_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ta miu na katia balika kua hau ta tania ni miu, manumanu laveve da dia ta hada lala habuka miu na kagu disaipel kamahi. ");
INSERT INTO wiv_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","A Saimon Pita ia hulenia, “Paraha, koto kiri ve?” A Iesus ia tania, “Malala kata kirina mara beta nu muri ni niau vano kirina kua, palaka da ba muri kunu muri ni niau.” ");
INSERT INTO wiv_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","A Pita ia hule, “Paraha, e kuziha ki mara beta na muri ni niho kua? Hau da ta vala livuhagu laveve kata kodoniho.” ");
INSERT INTO wiv_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","A Iesus ki hulenia, “Tu matoto da tu vala livuha laveve koto kodoniau? Hau ta tani matotonia ni niho, ba muri na toha kini kakareko da muga ku tania botona tolu, habuka beta nu lalau!” ");
INSERT INTO wiv_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","A Iesus e tani barae, “Tabarae magalimiu ni zaha miu na lohoi vuvu, miu bilip ni Vuvu, miu bilip ve ni niau. ");
INSERT INTO wiv_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Na ruma ke Tamagu, rum luba matoto vona; hau kata zahe na vaida kamiu. Kua ni beta rum kamahi vona, mara beta na tania ni miu. ");
INSERT INTO wiv_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Kua ta na zahe na vaida kamiu palaka, hau da ta vamule kata pelemiu, miu na mai ni niau, miu kata mia ve na palaka kua hau ta mimia vona. ");
INSERT INTO wiv_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Miu ka lala na dala kua miu kata pe vona miu na zahe kara palaka kua hau kata kirina.” ");
INSERT INTO wiv_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","A Tomas ki tania, “Paraha, hita beta hita na lala na palaka kua koto kirina, da hita ta lala zingania dala kirina?” ");
INSERT INTO wiv_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","A Iesus ki tania vona, “Hau ia na dala, hau ve na matotoka, hau ia na mianga pa, mara beta kaka ni pe na dala motu ni bele ni Tamagu, ma e pe ni niau ki bele vona. ");
INSERT INTO wiv_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Kua miu na lala kemikemihiau matoto, ia da miu te lala ve a Tamagu. Meni kua ki vano, ia miu te lala ia kava, miu kene hadavia ve kava.” ");
INSERT INTO wiv_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","A Filip ki tania vona, “Paraha, vatunga Tamadolu ni hita za, ia pale.” ");
INSERT INTO wiv_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","A Iesus ki kolia vona ki tania, “Hau te mia ti havarau kava kamamiu ki ma beta za nu lalau, ai Filip? Azei kua ti hadaviau ia kava ti hada a Tamagu; e kuziha kua ku tani barae, ‘Vatunga a Tamadolu ni hita’? ");
INSERT INTO wiv_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Beta nu bilip, Filip, habuka hau na poloki Tamagu, ia ve ia na polokogu? Na polea kamahi kua ta vavala ni miu ia beta ni kagu polea mule, palaka ke Tamagu kua ia na polokogu ki gagala na kana galanga. ");
INSERT INTO wiv_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Miu kata bilip ni niau kua hau ia na poloki Tamagu a Tamagu ve ia na polokogu; o kua ni beu, pele miu kata bilip ni niau na vuna kua miu ta hahada na mirakel kamahi kua ta kakatia. ");
INSERT INTO wiv_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Hau ta tani matotonia ni miu, azei kua e bilip ni niau, ia da e katia ve goloa kua ta kakatia; E limoha! Da e katia goloa kapou dopa na goloaloa kua ta kakatia, na vuna Hau da ta zahe ni Tamagu. ");
INSERT INTO wiv_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Hau da ta katia goloa laveve kena miu ta kohania hizagu miu ka hule kirina. Kata vatunga kakava na glori ke Tamagu. ");
INSERT INTO wiv_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Kua miu na hule kara goloa katiu na hizagu, da ta katia za. ");
INSERT INTO wiv_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Kua ni kulimiu matoto kirigu, da miu te paho poto na kagu polea kamahi. ");
INSERT INTO wiv_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Hau da te hulenia a Tamagu, ia da ia ti vala na Kaka kua kete kodonimiu, kua kete mia kamamiu na dama laveve, ");
INSERT INTO wiv_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","ia na Vule kua e lala kete vatunga kavakava na matotoka polea. Na manumanu bukuna vulovulo mara beta dia na koi taduria, na vuna mara beta dia na hadavia. Ki mara beta ve dia na lala. Palaka miu ta lala na Vule kua, na vuna ia e kamamiu ki mimia na polokomiu. ");
INSERT INTO wiv_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Mara beta na vati vetanimiu habuka kaka kua beta tamana kamani titinana. Hau da ta vamule ni miu. ");
INSERT INTO wiv_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Palaka kua, da pitu papa, manumanu bukuna vulovulo ki beta dia kata hadaviau ve, palaka miu da miu ta hadaviau, na vuna kua hau ta mahuri, ia miu ve da miu ta mahuri. ");
INSERT INTO wiv_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Na dama kena da miu te lala habuka hau ia na poloki tamagu, e miu na polokogu, e hau na polokomiu. ");
INSERT INTO wiv_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Azei kua e pelea kagu polea kamahi ki muri vona, ia kaka kena e kulina kirigu; kaka kua e kulina kirigu ia da a Tamagu e kulina ve kirina, hau da e kuligu ve kirina ka vatunga kakavau ve vona.” ");
INSERT INTO wiv_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","A Iudas (beta ni a Iskariot) e hulenia, “Paraha, e kuziha kua kunu lohoia koto nu vatunga kakavaho ni hita ki beta koto vatunga kakavaho na manumanu na vulovulo?” ");
INSERT INTO wiv_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","A Iesus ki tania vona, “Kua kaka katiu ni kulina matoto kirigu, ia da e paho poto na kagu polea, a Tamagu ia da ti kulina kirina, da miro ta mai vona miro kene mia kamana. ");
INSERT INTO wiv_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Kaka kua beta ni kulina kirigu ia mara beta ni paho poto na kagu polea; na polea kua miu ta lolongoria ia beta ni kagu mule, beu, ke Tamagu kua e geriau ka mai. ");
INSERT INTO wiv_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Goloaloa laveve kua ta tatania ni miu, kua ta ba vovona kamamiu. ");
INSERT INTO wiv_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Na kaka kua kete kodonimiu, na Vule Tumonga, kua a Tamagu kete geria na hizagu, ia da e vaketekete ni miu na goloa laveve, ki katia ve miu ka lohoi mulehia polealea laveve kua kava te tania ni miu. ");
INSERT INTO wiv_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Mianga pa kamana magali malugu ta vatia kamamiu, kagu magali malugu te vala ni miu, magali malugu kua beta ni habuka kua nuhu bukuna vulovulo dia ta vavala ni miu. Tabarae miu na lolohoi vuvu, tabarae ve miu na kukuahi. ");
INSERT INTO wiv_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Miu te longoria kava te tania ni miu, ‘Hau da ta vatimiu, palaka da ta vamule ni miu.’ Kua ni kulimiu matoto kirigu, da miu te hihilohilo, na vuna hau kata zahe ni Tamagu, na vuna a Tamagu ia e dopa ki paraha ni niau. ");
INSERT INTO wiv_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Te muga kene tatania ni miu kua, ba muri goloaloa kua kini bebele, kua kini pori matoto, da miu te bilip. ");
INSERT INTO wiv_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Mara beta ne ma popole marata kamamiu, na vuna zia na kaka kua e king kara vulovulo ti mamai. Palaka beta kana matuhanga ni dangea kete ditaduriau; ");
INSERT INTO wiv_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","palaka na manumanu bukuna vulovulo dia kata lala matotonia habuka hau e kuligu kiri Tamagu, kubarae hau ka kakatia goloa laveve kua e tania kata katia. Miu mai, tolu kata kakava ri.” ");
INSERT INTO wiv_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Hau ia na haina vaen matoto, a Tamagu ia na kakanaka hada potopotoa na vanua na vaen. ");
INSERT INTO wiv_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","E lala kete bazi kakava na dangangu laveve kena beta ni lala kete vuvua. Ki lala kete zahiria na dangangu laveve kena e lala kete vuvua, kete kavakava ni dopa vua. ");
INSERT INTO wiv_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Miu kava na polea kua ta vavala ni miu ti katimiu miu kene klin. ");
INSERT INTO wiv_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Miu bada ma popoto ni niau, hau kata ma poto ni miu. Habuka dangana hai kua mara beta ia mule ni vua, ma e ba vaidodo kamana hai na vaen ki vua, ia miu ve mara beta miu na vua, ma miu ta vaidodo kamaniau, miu ka vua. ");
INSERT INTO wiv_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Hau ia na haina vaen, miu na dangadangana. Azei ho kua tanu ma bada ni niau, hau na bada ni niho, ia ho kaka kena da tu vua marata, na vuna mara beta matoto nu katia goloa katiu kua tani beta nu vaidodo kamaniau. ");
INSERT INTO wiv_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Kua kaka katiu ni beta ni ma vavaidodo kamaniau, ia da e varaga kakavanga balika dangana hai ia vavaha ia mate, pale dia ta vai lupuanga, dia ta varaganga kara haroho, dia ta tunua. ");
INSERT INTO wiv_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Kua miu na ma badabada ni niau, kagu polea ni ma ngongoro ni miu, miu hule kara nazia kua e kulimiu kirina, ia da e valanga za ni miu. ");
INSERT INTO wiv_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Na vuna Tamagu ia kete pelea glori vona, kua ta miu na vuvua marata, na dala kua za ia da miu ta vatunga kakava habuka miu kagu disaipel kamahi. ");
INSERT INTO wiv_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Hau e kuligu matoto kirimiu habuka kua a Tamagu e kulina kirigu, kubarae kete ma kukulimiu kirigu. ");
INSERT INTO wiv_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Kua miu na pelea kagu polea, miu na muri matoto vona, da hau e ma ki kukuligu kirimiu, habuka kua hau ta poto bada na polea ke Tamagu, kua ia kini ma kini kukulina kirigu. ");
INSERT INTO wiv_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Goloaloa kua te tania ni miu kava, kara kagu hilohiloa kete ma ngongoro na polokomiu, miu na dopa hilohilo. ");
INSERT INTO wiv_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Hau tatani vatuharia kua: kete kulimiu matoto kara kaka, habuka kua e kuligu matoto kirimiu. ");
INSERT INTO wiv_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Dala katiu za kua koto vatunga habuka e kuli matoto kiri habu kurakura, ia kua koto mate kadia. ");
INSERT INTO wiv_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Kua miu na katia nazia kua ta tania miu kata katia, ia miu na habu kurakuragu kena. ");
INSERT INTO wiv_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ti beta ne ma kokohanimiu na kagu voravora, na vuna na vora beta ni lala nazia kua kana tubu e kakatia, palaka hau te kohanimiu habu kurakuragu, na vuna goloaloa laveve kua ta longoria ni Tamagu hau te tani kakava ni miu kava miu kene lala. ");
INSERT INTO wiv_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Beta miu na makiau, beta, hau ta have palimiu, ka makimiu, miu kata vano miu na vua, miu na taruhia palekemiu kua e lala kete ngoro ni havarau. Pale, nazia kua miu ta kohania hizagu miu ka hulenia a Tamagu kirina, ia da e vavala za ni miu. ");
INSERT INTO wiv_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Goloa kua ta tani vatuharia ni miu, ia kete kulimiu matoto kara kaka. ");
INSERT INTO wiv_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Kua manumanu ni zazaha kirimiu, miu lohoia za habuka dia ta muga dia ka zaha kirigu. ");
INSERT INTO wiv_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Kua miu na ba bukuna vulovulo, da e kulidia matoto kirimiu, palaka hau te makimiu na pidaka manumanu laveve bukuna vulovulo, kini beta miu ne ma bukuna vulovulo, kubarae da manumanu dia ta zaha kirimiu. ");
INSERT INTO wiv_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Miu lohoia polea kua ta tania ni miu, ‘Vora beta ni dopa hizanga na kana tubu.’ Kua dia na zaha kirigu, da dia ta zaha ve kirimiu; kua dia na poto na kagu polea, ia da dia ta poto na kamiu polea ve. ");
INSERT INTO wiv_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Palaka goloaloa laveve kua da dia ta katia ni miu na vuvuna ni niau, na vuvuna beta dia na lala kaka kua e geriau ka mai. ");
INSERT INTO wiv_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Kua ni beta na mai na vala polea ni dia, da ti beta kadia manaunaua; palaka kua, ti beta matoto kadia vata karikaria. ");
INSERT INTO wiv_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Azei kua tani beta ni kulina matoto kirigu, ia beta ve ni kulina matoto kiri Tamagu. ");
INSERT INTO wiv_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Kua ni beta na mia na pidaka dia na kakatia galanga kapopou kua beta ve kaka katiu ni kakatia muga, da ti beta kadia manaunaua; palaka kua kava dia te hadavia na mirakel kamahi kua, palaka ki beta ni kulidia matoto kirimiro a Tamagu. ");
INSERT INTO wiv_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ia da ti pori matoto na polea kua e vapolunganga na poloka kadia lo, ‘Dia ta zaha veta kirigu beta matoto vuvuna.’ ");
INSERT INTO wiv_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Palaka na kaka kua kete kodonimiu kua e mimia kamani Tamagu, kua hau kata geria ni mai ni miu, ia na Vule Tumonga kua kara matotoka polea za, kua da e pe ni Tamagu ki mai, ia da e popole na vuna ni niau. ");
INSERT INTO wiv_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Da miu ve ta popole ni niau, na vuna kilaka kua ta varivuvunia kagu galangalanga, ia miu ta kakamaniau. ");
INSERT INTO wiv_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Hau te tania goloa laveve kua ni miu kete katimiu kete beta miu kata poke. ");
INSERT INTO wiv_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Da dia ta tabunimiu na kadia haus lotu kamahi ke vuni Iuda; damana vona kua e ba mamai kua ta kaka kua ni hubi matehimiu, da dia ta lohoia dia ka tania habuka, dia ta kakatia galanga ke Vuvu. ");
INSERT INTO wiv_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Da dia ta katia maki kua na vuvuna beta dia na lala a Tamagu, ki beta dia na lalau ve. Palaka hau ta tatania goloaloa kua ni miu, kete kubarae, kua na damana kua dia kata katia goloaloa kua kini bele, ia da miu te lohoi mulehia habuka ta tani mugania ni miu kava. Beta na tania goloaloa kua ni miu muga, na vuna hau ta ba kakamamiu. ");
INSERT INTO wiv_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Palaka kua hau keteni zahe na kaka kua e geriau ka ziho; ki beta kaka katiu ni miu kua ni huleni baraeniau, ‘Koto kiri ve?’ ");
INSERT INTO wiv_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Palaka na vuvuna kua hau te tania goloaloa kua ni miu, lohoromiu kini zaha. ");
INSERT INTO wiv_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Palaka hau ta tani matotonia polea kua: ia kara kamiu kemia kua hau kata vavana, na vuvuna kua tani beta na vavana, na Kaka kua kete kodonimiu mara beta ni mai ni miu; palaka kua ta na vano, ia da ta geria ki mai ni miu. ");
INSERT INTO wiv_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Kua ta ia ni mai, da ia e vatunga kakava na manumanu na vulovulo dia kata hada lala kadia manaunaua kamahi, ia mai dia kata hada lala moge ke Vuvu kua e mahoto ia mai na kotoa ke Vuvu ve. ");
INSERT INTO wiv_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Da ia vatunga kakava manaunaua ke manumanu, na vuvuna beta dia na bilip ni niau; ");
INSERT INTO wiv_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","da ia e vatunga kakava nazia kua e mahoto, na vuna hau da te zahe ni Tamagu, ki beta ve miu keteni hadavi mulehiau; ");
INSERT INTO wiv_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","da ia e vatunga kakava ve na kotoa ke Vuvu, na vuna zia, na paraha kara vulovulo kua, kava ti koto kirua. ");
INSERT INTO wiv_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Polealea luba kua e ba vovona kua kata tania ni miu, palaka mara beta miu na pelea laveve kua ta na tania ni miu. ");
INSERT INTO wiv_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Palaka kua ta na Vule Tumonga ni mai, da ia e vatunga kemikemihia na polea kua e matoto, na vuna ia mara beta ni tani vetania polea katiu na kana lohoihoia mule, palaka na polea laveve kena e longoria ni Vuvu ia da e pole vona, ia da e tania ni miu nazia kua ba muri kete bele. ");
INSERT INTO wiv_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ia da e vala glori ni niau, na vuna ia da e pelea kagu polea ki tani kavakavania ni miu. ");
INSERT INTO wiv_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Goloaloa laveve kena ke Tamagu ia kagu, kubarae ka tani barae ni miu, ia da e pelea kagu polea ki kavakavania ni miu.” ");
INSERT INTO wiv_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","A Iesus e tania, “Da pitu papa, ki beta miu kata hadaviau ve; palaka pitu papa ve miu ta hadavi mulehiau.” ");
INSERT INTO wiv_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Kana disaipel taza dia ta varihulei, “E tani zingania kua e tani barae ni dolu, ‘Da pitu papa ki beta miu kata hadaviau ve,’ ki tani barae ve, ‘Da pitu papa ve miu ka hadavi mulehiau,’ ki tani barae ve, ‘na vuvuna hau kata zahe ni Tamagu’?” ");
INSERT INTO wiv_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Dia ka tani barae, “E tani ziha vona kua e tani barae ‘da pitu papa’? Beta tolu na longo lala kua e tani barae.” ");
INSERT INTO wiv_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","A Iesus e lala habuka e kulidia dia kata hulenia vona na polea kua, kubarae ia ki tani barae ni dia, “Miu ta varihulei na polea kua ta tania, habuka kua, ‘Da pitu papa ki beta miu kata ma hadaviau, ki vano ve da pitu papa miu ka hadavi mulehiau’? ");
INSERT INTO wiv_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Matoto, matoto, Hau ta tania ni miu, da miu ta haloho, miu ka tangi, palaka na manumanu bukuna garigari da dia ta hilohilo, da miu ta tangi palaka kamiu tangia da e pokizia miu ka hilohilo. ");
INSERT INTO wiv_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Kua tavine katiu kua ni kakapupu kua kete zuru, da e hatunia varitihia, palaka kua tani vano ni valohia tuna, da e lohoi bala laveve varitihia kena, na vuvuna da ti hilohilo matoto na kapiru vahoru ti valohua. ");
INSERT INTO wiv_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Da ia e kubarae ve kirimiu, kua da miu ta tangi, palaka da ta hadavi mulehimiu pale, magalimiu ia ti hilohilo, hilohiloa kua mara beta kaka katiu ni pele kakava ni miu. ");
INSERT INTO wiv_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Na dama kena da beta miu kata huleniau kara goloa katiu, palaka miu hulenia Tamagu. Matoto, matoto, hau ta tania ni miu, kua miu na hulenia Tamagu kara goloa katiu na hizagu, da ia e vala ni miu. ");
INSERT INTO wiv_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Kua ki mai, mai kua, ma beta miu na hule kara goloa katiu na hizagu; kua miu hule miu na pelea, miu kata dopa hilohilo matoto.” ");
INSERT INTO wiv_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","A Iesus ki tani barae ve, “Hau ta barikikinia polea ka tatania goloaloa kamahi kua ni miu, palaka na dama vona kua e ba mamai kua da beta kata barikikinia polea, palaka da ta pole kavakava na polea, kua kata pole na vuna ni Tamagu ni miu. ");
INSERT INTO wiv_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Na dama kena da miu ta hule kara goloa na hizagu. Beta na tania habuka hau kata nongunongu kamiu ni Tamagu; ");
INSERT INTO wiv_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","na vuna zia a Tamagu ia mule, e kulina matoto kirimiu, na vuna miu ti kulimiu kirigu miu kene bilip habuka, hau ta pe ni Tamagu ka mai. ");
INSERT INTO wiv_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Hau ta pe ni Tamagu ka ziho kara vulovulo; kua keteni vatia vulovulo ne vamule ni Tamagu.” ");
INSERT INTO wiv_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Pale, na kana disaipel kamahi dia ta tani barae, “Kua tu ba pole kavakava. ");
INSERT INTO wiv_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Kua hita te ba lala habuka ho tu lala goloaloa laveve ki mara beta ve kaka katiu ni huleniho na goloa katiu. Kua ti katia hita kene bilip habuka ho tu pe ni Vuvu.” ");
INSERT INTO wiv_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","A Iesus ki tania, “Kua miu te bilip, ai? ");
INSERT INTO wiv_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Palaka damana vona kua e ba mamai, e kua kava ti mai, kua da miu ta varihavai katiutiu, kara kamiu rumaruma kamahi, hau da miu te hava tapuniau kini hau kazihegu za. Palaka da beta kete hau kazihegu, a Tamagu ia da e kakamaniau. ");
INSERT INTO wiv_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Hau te tania goloaloa kua ni miu, kete kubarae, magalimiu da e malugunia kua ta miu na poto bada ni niau. Na vulovulo da beta miu kata paria mianga pa. Palaka miu hilohilo! Hau kava te vaka taduria na matuhanga kara vulovulo.” ");
INSERT INTO wiv_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Kamana a Iesus ki tani barae, ia tunga vatada kara lagato ia lotu barae, “Tamagu na dama ti bele kava. Vala glori ni Tu, a Tu kete vala glori ni niho. ");
INSERT INTO wiv_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Na vuna ho tu vala matuhanga vona kete hada na manumanu laveve, kete dangea kete vala mahuri roroa na nuhu kua ho mule tu vala vona. ");
INSERT INTO wiv_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Kua na mahuri rororoa ia e kubarae; dia kata lalaho habuka ho katiu papa za ia a Vuvu matoto, dia kata lala a Iesus Kristus, kaka kua tu geria ki ziho. ");
INSERT INTO wiv_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Kava te vatunga ka glori ri na garigari; Te vahozovia kava galanga kua tu vala ni niau kata katia. ");
INSERT INTO wiv_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Pale kua, Tamagu, vala glori ni niau kua ta mamadi na mata, na kagu glori bukuni muga kua ta ba mimia kamaniho muga kua ma beta na vulovulo ni katua. ");
INSERT INTO wiv_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Kava te vatungaho na nuhu kua tu haze palidia na pidaka manumanu na vulovulo, ku vala ni niau. Dia ka, tu vala ni niau dia kene longoria dia kene muri na ka polea. ");
INSERT INTO wiv_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Kua dia te lala habuka goloa laveve kua tu vala ni niau, ia e mai ni niho. ");
INSERT INTO wiv_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Na vuna hau ta vala polea kena tu vala ni niau ni dia, dia kene pelea. Dia te lala matotonia habuka hau ta pe ni niho ka mai, e dia kene bilip habuka ho tu geriau ka mai. ");
INSERT INTO wiv_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Hau ta lolotu kadia. Beta na lolotu kara manumanu na vulovulo, palaka kara nuhu kua tu vala ni niau, na vuna zia, dia ka. ");
INSERT INTO wiv_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Kagu manumanu laveve ia ka. Ka manumanu laveve ia kagu. Hau te pelea glori na vuna ni dia. ");
INSERT INTO wiv_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Hau mara beta na ma mimia ri na vulovulo, palaka da dia ta ba vovona ri na vulovulo, e hau kua keteni zahe ni niho. Tamagu Tumonga, kari havutidia na hiza, na hiza kua tu vala ni niau, dia kata katiu za, habuka kua to ta katiu papa za. ");
INSERT INTO wiv_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Kua ta ba kakamadia, hau ka hada poto ni dia, na vona na hiza kua tu vala ni niau. Beta katiu ni dia ni golu, palaka kaka katiu za kua kete golu, ia da e golu, habuka na polea kana Paraha ia kete pori matoto. ");
INSERT INTO wiv_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Hau kua da pitu papa kene zahe ni niho, palaka ta tatania polealea kuari na vulovulo na vuna kagu hilohiloa kete vonu matoto na polokodia. ");
INSERT INTO wiv_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Hau te vala ka polea ni dia kubarae manumanu kini beta ni kulidia kiridia, na vuvuna, dia ti beta dia na ma bukuna garigari, habuka kua hau ve beta na bukuna garigari. ");
INSERT INTO wiv_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Hau ta huleniho habuka beta ni habuka koto pele kakava dia na vulovulo, palaka koto vabatavidia ni Satan. ");
INSERT INTO wiv_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Beta dia na bukuna vulovulo, habuka kua hau beta ve na bukuna vulovulo. ");
INSERT INTO wiv_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Katidia na Tumonga na matotoka polea; ka polea ia na matotoka polea. ");
INSERT INTO wiv_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Habuka kua tu geriau kara vulovulo, ia hau ve te geridia ve dia kata vano na manumanu na vulovulo. ");
INSERT INTO wiv_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Hau ta lohoihoi ni dia kubarae, hau kene vala mulehiau ni niho, habuka dia ve dia kata vala mulehidia matoto ni niho. ");
INSERT INTO wiv_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Beta na lolotu kadia za. Ta lotu ve kana nuhu kua dia kata bilip ni niau na vuna kua dia ta longoria kadia polea. ");
INSERT INTO wiv_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Hau ta lotu habuka dia kata lupu dia na katiu papa. Tamagu! Habuka kua ho na polokogu hau ve na poloko, paleka dia ve dia na mia na polokodoro, manumanu na vulovulo dia kata bilip habuka ho tu geriau. ");
INSERT INTO wiv_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Hau te vala glori kena tu vala ni niau ni dia, dia kata lupu dia na madi katiu, habuka kua to ta katiu papa: ");
INSERT INTO wiv_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Hau na polokodia, ho na polokogu. Paleka dia na lupu dia na katiu papa matoto dia kata vatunga na manumanu na vulovulo habuka ho tu geriau ka ziho, ki kuli ve kiridia habuka kua e kuli kiriniau. ");
INSERT INTO wiv_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Tamagu, hau e kuligu habuka nuhu kua tu vala ni niau dia kata kamaniau na palaka kua hau kata kirina, dia kata hada kagu glori, na glori kua tu vala ni niau na vuna ho e kuli kiriniau muga za, ba muri kunu katia goloaloa laveve. ");
INSERT INTO wiv_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tamagu kua tu mahoto matoto! Manumanu na vulovulo beta dia na lalaho, palaka hau ta lalaho, nuhu kua tu vala ni niau, dia ve dia ta lala habuka ho tu geriau ka ziho. ");
INSERT INTO wiv_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Hau kava te vatunga kakava ni dia habuka ho azei matoto. Da ta ma ka vavatunga kakavaho ni dia, na maki kua tu vatunga ni niau, habuka kua e kuli matoto kirigu, ia kete vano ve ni dia, hau ve kata mia na polokodia.” ");
INSERT INTO wiv_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Kamana a Iesus ki tani hozovia polealea kamahi kua, ia vavana kamana kana disaipel kamahi dia ta turu poki na naru a Kidron, dia ta vano bele dia ta hoho na vanua na oliv katiu. ");
INSERT INTO wiv_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","A Iudas, na kaka kua kete vala a Iesus na limani vuni Iuda, ia e lala palaka kua, na vuna zia boto luba a Iesus ia e lala kete lulupu kamana kana disaipel kamahi vona na palaka kua. ");
INSERT INTO wiv_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Pale, a Iudas ia vatunga dala na soldia taza bukuni Rom, ia mai na gat kara tempel kua na hetpris kamahi kamana Parisi kamahi dia ta geridia; dia ta pahopaho lam kamana zulu, ia mai na honana varihubia ve. ");
INSERT INTO wiv_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","A Iesus ia kava ti lala nazia kua keteni bele vona, ia vano ia hulenidia, “Azei matoto miu ta kakaze kirina?” ");
INSERT INTO wiv_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Dia ka kolia dia ka tania, “A Iesus bukuni Nasaret.” A Iesus ki tania, “Kua hau kua.” A Iudas kaka kua kete vala a Iesus na limadia, ia ve e kamadia. ");
INSERT INTO wiv_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Kamana a Iesus ki tani barae, “Kua hau kua,” dia ta vahere mule dia ka varipokeai kara garigari. ");
INSERT INTO wiv_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ia ki huleni mulehidia ve, “Azei miu ta kakaze kirina?” Dia ka tania, “A Iesus bukuni Nasaret.” ");
INSERT INTO wiv_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Kava te tania ni miu, kua hau kua, miu kene kakaze kirigu za, pele miu vatia kagu disaipel kamahi dia na vano. ");
INSERT INTO wiv_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","E tani baraenia, kete pori kana polea kua varira e tani barae, “Tamagu nuhu kua tu vala ni niau, beta katiu ni dia ni golu.” ");
INSERT INTO wiv_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","A Pita ia kana bainat vona, ia pelea ia bazia talingana vora kana hetpris katiu, na talingana kiri maroro. Hizana vora kua a Malkus. ");
INSERT INTO wiv_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","A Iesus ki pole kiri Pita ki tani barae, “Taru mulehia ka bainat na mudina! E kuziha, tu lohoia mara beta na hinu na kap kua a Tamagu ti vala ni niau?” ");
INSERT INTO wiv_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Pale, na soldia kamahi kua kamana kadia komada ia mai na gat kamahi kara tempel dia ta paho taduria a Iesus, dia ta rotu taduria limana karua. ");
INSERT INTO wiv_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Dia ta pelea zahe ni Anas, ia na ravani Kaiafas, a Kaiafas ia na hetpris kilangata kua. ");
INSERT INTO wiv_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","A Kaiafas ia kua e tania ni vuni Iuda muga kubarae, “E kemi kaka katiu za kete mate kara manumanu laveve.” ");
INSERT INTO wiv_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","A Saimon Pita kamana disaipel katiu ve hiro ta muri ni Iesus. Na disaipel kua, na hetpris e lala, kubarae ia kini kamani Iesus kini hoho kara poloka banis na ruma kana hetpris. ");
INSERT INTO wiv_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Palaka a Pita ma kini ma guguru na hatama. Na disaipel kua na hetpris e lala, ia e vamule gotala ia pole kamana tavine kua e hahada poto na geit, ia kohania Pita hiro kene hoho. ");
INSERT INTO wiv_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Na tavine kua e hahada poto na geit, kamana ki hada a Pita, ia hulenia, “Beta ho ni kana disaipel katiu?” A Pita ki tania, “Hau beta.” ");
INSERT INTO wiv_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Magara motu, kubarae na voravora kamana opisa kara tempel dia ta madi lobia haroho katiu dia ka papaniru. A Pita ve e mamadi kamadia ki papaniru. ");
INSERT INTO wiv_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Na hetpris ia ti huhulenia a Iesus kara kana disaipel kamahi ki mai ve ki hulenia ve na vaketeketea zia kua e lala kete vaketekete vona. ");
INSERT INTO wiv_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","A Iesus ki kolia vona ki tania, “Hau ta lala kata pole kavakava na matana manumanu laveve, ta vaketekete na poloka haus lotu kamahi ke vuni Iuda ia mai na poloka tempel, kua a vuni Iuda laveve dia ta lala dia kata lulupu vona. Beta na tani paritiginia polea katiu. ");
INSERT INTO wiv_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","E kuziha ku huhuleniau? Hulenia manumanu kua, dia ta lala dia kata lolongoriau ta popole. Dia ta lala nazia hau ta lala kata tatania.” ");
INSERT INTO wiv_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Kamana a Iesus ki tani barae, na opisa kara gat kara tempel katiu ia zapalania a Iesus. Ki tani barae, “E kuziha ku koli baraenia polea kana hetpris?” ");
INSERT INTO wiv_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","A Iesus ki tania, “Kua na tania polea katiu kua beta ni matoto, ho tu tania, palaka kua ta tani matotonia polea kua, e kuziha ku hubiau?” ");
INSERT INTO wiv_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Pale, a Anas ia geri polea a Iesus vano ni Kaiafas. Na mota ia ba vovona na limani Iesus kua. ");
INSERT INTO wiv_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","A Pita e madi ki papaniru, dia ta hulenia, “Ho beta ho ni kana disaipel katiu, ai?” Palaka a Pita ia linga ki tani barae, “Hau beu.” ");
INSERT INTO wiv_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Na vora katiu kana hetpris, ia na vineka kua a Pita e bazi hutuzia talingana na vanua, ia hulenia, “Tania ta hadaviho kamana na poloka vanua?” ");
INSERT INTO wiv_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","A Pita ia linga mule ve, kamana ki lilinga barae, na toha ia kakareko. ");
INSERT INTO wiv_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Pale, a vuni Iuda dia ta pelea a Iesus na ruma ke Kaiafas dia kene pelea zahe kara ruma kana kadia gavana. Dia ta kukuza barae, ia ti dama kakava, kubarae a vuni Iuda beta dia na hoho na ruma ke gavana. Dia ta lohoia tabarae dia na hoho na ruma ke gavana dia na molumolua na matani Vuvu, ni mara beta dia na hania haninga kara Pasova. ");
INSERT INTO wiv_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Kubarae a Pailat ia mai gotala ni dia ki hulenidia, “Nazia matoto kaka kua e katia ki zaha miu kata koto kirina vona?” ");
INSERT INTO wiv_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Dia ta kolia dia ka tania, “Ni beta ia ni na kaka zaha katiu, mara beta hita na pelea ni mai ni niho.” ");
INSERT INTO wiv_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","A Pailat ki tania, “Pele miu pelea miu na koto kirina na kamiu lo mule.” Dia ka kolia ve dia ka tania ni Pailat, “Na kamiu lo a vuni Rom e tabunihita, hita kata hubi matehia kaka.” ");
INSERT INTO wiv_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Goloaloa kua e bele, kete pori na polea ke Iesus kua e tania muga na vuna kua ia da e mate ziha. ");
INSERT INTO wiv_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","A Pailat ia hoho mule kara kana poloka ruma ia hulenia a Iesus, “Ia ho na king ke vuni Iuda?” ");
INSERT INTO wiv_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","A Iesus ki hulenia, “Ho mule tu lohoia ku tania polea kena o manumanu taza dia ta popole na vuna ni niau, dia ka tatania ni niho?” ");
INSERT INTO wiv_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","A Pailat ki kolia vona ki tania, “Tu lohoia ku tania hau na Iuda katiu, ai? Ka manumanu mule kamana kamiu hetpris kamahi kua dia ta peleho dia ka valaho ni niau. Nazia matoto tu katia ki zaha?” ");
INSERT INTO wiv_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","A Iesus ki tania, “Kagu kingdom beta ni bukuna garigari kua. Kua ni bukuni ri, kagu voravora da dia ta varihubi tarakagu ki mara beta kaka katiu ni peleau ni valau na limani vuni Iuda. Palaka kua kagu kingdom ia bukuna palaka motu.” ");
INSERT INTO wiv_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","A Pailat ki tania, “Pele ho na king katiu te!” A Iesus ki tania, “Ho tu tani matotonia kena tu tania hau na king katiu. Ia na vuvuna za kua ki valohua hau, kata vala matotoka polea, manumanu dia na longoria. Manumanu laveve kua dia ta lala dia kata mumuri na matotoka polea ia dia ta lala dia kata longoria kagu polea.” A Pailat ki hulenia, “Matotoka polea ia nazia matoto?” A Pailat ia gotala mule ni vuni Iuda ki tania, “Hau beta na paria goloa katiu ni katia ni zaha kua kete dangea kata koto kirina vona. ");
INSERT INTO wiv_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Palaka muri na kamiu maki kua, e lala kata vagotalani mulehia na karabus katiu, na dama laveve kara Pasova. E kulimiu kata vagotalani mulehia ‘na king ke vuni Iuda kua’?” ");
INSERT INTO wiv_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Dia ta goe dia ka tania, “Beta! Ia vata! Vagotalani mulehia a Barabas!” (A Barabas ia kakanaka varihubia ki mata vanaho ve.) ");
INSERT INTO wiv_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pale, a Pailat ia geu dia ta vihia a Iesus. ");
INSERT INTO wiv_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Na soldia kamahi dia ta pelea mota matangatanga dia ta vaia kara hate katiu, dia ta taruhia na bakana. Dia ta vazohoria na kolos baritunutunua katiu ");
INSERT INTO wiv_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","dia ta ma zazahe ni Iesus, dia ka tatani barae, “King ke vuni Iuda, hita ta vazahenia hiza!” Dia ka zazapalania. ");
INSERT INTO wiv_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Boto katiu ve a Pailat ia gotala mule ki tania ni vuni Iuda, “Miu hada, hau kata pelea ni gotala mule ni mai ni miu, miu kata lala habuka beta na paria goloa katiu ni dangea kata koto kirina vona.” ");
INSERT INTO wiv_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Pale, a Iesus ia mai gotala, na hate kua e katua na mota matangatanga kamana kolos baritunutunua, ia e ba vovona na livuhana, a Pailat ki tania ni dia, “Hadavia! Kua ia kua!” ");
INSERT INTO wiv_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Tania na hetpris kamahi kamana gat kamahi kara tempel dia ka hadavia Iesus, dia ta goe dia ka tani barae, “Nilnia na kruse! Nilnia na kruse!” Palaka a Pailat ki tania, “Miu mule miu pelea miu na nilnia na kruse. Hau beta na paria goloa katiu ni katia ni zaha kete dangea kata koto kirina vona.” ");
INSERT INTO wiv_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","A vuni Iuda dia ta ma vavaridi dia ka tatania, “Hita kahita lo vona, kua e tania kaka kena ia kete mate, na vuna zia ia e tania ia na Tuni Vuvu.” ");
INSERT INTO wiv_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Kamana a Pailat ki longo baraenia, ia ti dopa kini kuahi matoto, ");
INSERT INTO wiv_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","pale, ia hoho mule kara kana poloka ruma. Ia hulenia a Iesus, “Ho tu bukuni ve?” Palaka a Iesus beta ni kolia kana polea. ");
INSERT INTO wiv_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","A Pailat ki tania vona, “E kuziha ki beta ni kuli koto kolia kagu polea? Beta nu lala habuka hau kagu matuhanga vona kua kata vagotalani mulehiho o kata nilniho na kruse?” ");
INSERT INTO wiv_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","A Iesus ki kolia vona ki tania, “Ni beta kua a Vuvu heta ni vala matuhanga ni niho, ia da mara beta nu katia goloa katiu ni niau. Kubarae, kaka kua e valau ni niho, ia e katia moge zaha matoto, kapou dopa ni niho.” ");
INSERT INTO wiv_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pale, muri na kua, a Pailat ia e parakilania ve kete vatia a Iesus ni vano gotala, palaka a vuni Iuda dia ta ma gogoe dia ka tatania, “Kua nu vagotalania kaka kena, ia ho beta nu kaka ke Sisar. Azei kua e tania ia na king, ia hana vagi a Sisar.” ");
INSERT INTO wiv_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Tania a Pailat ki longo baraenia, ia pelea a Iesus ia gotala, ia mia na sia kua kara Jas na palaka kua e kohanga na “Dala tukanga na kedo,” na pole matotoa Hibru dia ta kohania ni Gabata. ");
INSERT INTO wiv_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Na dama kua ia na dama kua dia ta vaihidahida kara hanihania kapou kara Pasova, ti 12 kilok barae. A Pailat ia tania kiri vuni Iuda, “Ia, kamiu king kua!” ");
INSERT INTO wiv_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Palaka dia ta goe dia ka tania, “Pelea nu vano! Pelea nu vano! Nilnia na kruse!” A Pailat ki hulenidia, “Kata nilnia kamiu king na kruse ai?” Na hetpris kamahi dia ka tania, “Hita beta kahita king katiu ve, a Sisar za ia kahita king.” ");
INSERT INTO wiv_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Pale, a Pailat ia vala a Iesus na limadia dia kata nilnia na kruse. Pale dia ta pelea a Iesus kini vano. ");
INSERT INTO wiv_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","A Iesus ia luga kana kruse, dia ta gotala vano kara palaka katiu kua e kohanga na togana bakana kaka. (Na pole matotoa a Hibru, dia ta kohania ni Golgota.) ");
INSERT INTO wiv_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Pale, na palaka kua dia ta nilnia a Iesus na kruse, na kaka rua ve hiro ta nilianga ve kamana, katiu kiri maroro, katiu kiri mauri, a Iesus na pidaka hiro. ");
INSERT INTO wiv_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","A Pailat ia vapolungania polea katiu ia geridia, dia ta taruhia na kruse. Na polea kua e tani barae: IESUS BUKUNI NASARET, KING KE VUNI IUDA. ");
INSERT INTO wiv_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Na palaka kua e kozoho na taon kapou, kubarae a vuni Iuda luba dia ta mai dia ka hazenia polea kua, na vuna e vapolunganga na pole matotoa, a Hibru, polea Latin, ia mai polea Grik. ");
INSERT INTO wiv_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Na hetpris kamahi ke vuni Iuda dia ka hadavia, dia ta tania ni Pailat, “Taua nu vapolu baraenia habuka ia ‘King ke vuni Iuda,’ vapolungani baraenia, ‘Ia e tania ia na king ke vuni Iuda.’” ");
INSERT INTO wiv_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","A Pailat ki tania, “Nazia kava te vapolungania, ia te vapolungania.” ");
INSERT INTO wiv_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Na soldia kamahi dia ta nilini hozovia a Iesus na kruse, dia ta pelea kana loholohoa kamahi, dia kene varidangeai vona. Dia kaka garamo. Dia ta pelea ve kana siot. Na siot kua e katua na lavalava katiu za beta tret vona. ");
INSERT INTO wiv_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Kubarae dia ka tania, taua tolu na terehia, tolu kata pilae satu tolu na hadavia, azei matoto kete pelea kana. Dia ta kubaraenia kini pori matoto polea kana Paraha kua e tani barae, “Dia ta varidangeai na kagu loholohoa kamahi, dia ka pilae satu kara kagu kolos kamahi.” ");
INSERT INTO wiv_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","A Maria titinani Iesus, kamani tazina, ia mai a Maria goni Klopas, ia mai a Maria Makdala, dia ta mamadi kozoho na kruse ke Iesus. ");
INSERT INTO wiv_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Kamana a Iesus ki hadavia a titinana, ia mai na disaipel kua e lala kete kulina matoto kirina, hiro ta mamadi kozoho, ia tania ni titinana, “Tavine, kena Tu kena.” ");
INSERT INTO wiv_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ia tania na disaipel kua, “Kena katiti kena.” Muri na kua, na disaipel kua ia pelea a Maria kini vano kara kana ruma. ");
INSERT INTO wiv_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Pale, a Iesus ti lala habuka kana galanga laveve keteni hozo. Pale, kua kete katia na polea kana Paraha ni pori, a Iesus ia tani barae, “Ti marahotiau.” ");
INSERT INTO wiv_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Na sospen katiu na vaen vona e ngongoro kozoho, dia ta lutia na spans na poloka vaen kua, dia ta rotia na spans na dangana hai kua e kohanga na hisop, dia ta taruhia na humini Iesus kete hinumia. ");
INSERT INTO wiv_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Kamana ki hinu hozo, a Iesus ia tani barae, “Ti hozo.” E tani barae, ia vazihonia bakana ia mate. ");
INSERT INTO wiv_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Kilangata kua ia na dama kua dia ta vavaida kara hanihania kapou kara Sabat, na Sabat kua ia na dama kapou matoto. Kubarae, a vuni Iuda ki beta ni kulidia na podana manumanu kua kete ma varihaveai na kruse na Sabat, dia ta hulenia a Pailat dia kata hutu putuhia kabekabedia dia na pele kakava podadia. ");
INSERT INTO wiv_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Kubarae na soldia kamahi dia ta mai hutu putuhia kabekabena kaka rua kena e haveanga hiro kamani Iesus. ");
INSERT INTO wiv_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Dia ta mai ni Iesus dia ta hada habuka ti mate kava, kubarae beta dia na hutu putuhia kabena karua. ");
INSERT INTO wiv_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Palaka, na soldia katiu e padea na verevereni Iesus na diaro, na topo kamana naru ia galolo vona. ");
INSERT INTO wiv_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Na kaka kua e hada goloa kua e bele, ia ia za kua e ti tani kakava na goloaloa kua. Kana polea ia e matoto. Na vuna zia ia e lala habuka polea kua ia e tatania ia e matoto, ia ki tatani kakava habuka miu ve miu kata bilip. ");
INSERT INTO wiv_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Na goloa kamahi kua e bele kete pori matoto na polea kana Paraha kua e tani barae, “Beta togana katiu na livuhana kete hutu putuha.” ");
INSERT INTO wiv_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Na polea kana Paraha ki tani barae ve, “Da dia ta hadavia na kaka kua dia ta padea na diaro.” ");
INSERT INTO wiv_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ba muri, a Iosep, kaka katiu bukuni Arimatea e mai ia hulenia a Pailat kara podani Iesus. A Iosep ia na disaipel katiu ke Iesus, palaka beta ni tani kakava na manumanu, na vuna zia e kuahinia na pararaha ke vuni Iuda. A Pailat ia tara vona ia mai pelea podani Iesus vano. ");
INSERT INTO wiv_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","A Nikodemus, kaka kua varira e mai ni Iesus na marigo, ia ve e kamani Iosep. E pelea na pefium taza kua e katua na myrrh ki kamopokiza kamana aloes, na bizeka e 30 kilogram. ");
INSERT INTO wiv_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","A Iosep hiro a Nikodemus hiro ta taruhia sanda na podani Iesus, hiro ta kukulia na lavalava, muri na maki ke vuni Iuda kua dia ta lala dia kata kakatia na kaka mate. ");
INSERT INTO wiv_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Na palaka kua e nilianga a Iesus na kruse vona, ia na vanua katiu vona. Na vanua kua na matmat katiu vona, ma beta ni taruha kaka mate katiu vona. ");
INSERT INTO wiv_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Na vuna ti dama kua a vuni Iuda dia ta vavaida kara Sabat, dia ta taruhia na podani Iesus na lovo kua, na vuna, e ngoro kozoho. ");
INSERT INTO wiv_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ti dama na Sande, a Maria Makdala e like na marigorigopa ia vano kara matmat. Tania ki vano, ia hada na kedo kua e karua na matmat vona ti vahere kakavanga na havana matmat. ");
INSERT INTO wiv_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Pale, ia rovo vamule, ia vano tania ni Saimon Pita kamana disaipel katiu ve, na disaipel kua a Iesus e lala kete kulina matoto kirina, ki tania ni hiro, “Dia te pele gotalania a Paraha na poloka matmat, ki beta ve tolu na lala dia te taruhia ni ve.” ");
INSERT INTO wiv_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Pale, a Pita hiro kamana disaipel kua, hiro ta vano kara matmat. ");
INSERT INTO wiv_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Hiro ta rovo vano, na disaipel kua ia kapilia a Pita ia muga vano bele na matmat, ");
INSERT INTO wiv_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","ia tiro vatudu ki hiki hoho, ia hadavia na lavalava kua e karua a Iesus vona e ngongoro, palaka beta ni hoho na poloka lovo. ");
INSERT INTO wiv_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","A Pita e muri ki zahe bele, ia hoho liuliu kara poloka lovo. Ia hada na lavalava kamahi kua e kukula a Iesus vona e ngongoro, ");
INSERT INTO wiv_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","na lavalava kua e kukula bakani Iesus vona, beta ni ngoro kamana lavalava kua e kukula vona, palaka e didua ki ngoro kazihena. ");
INSERT INTO wiv_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Pale, na disaipel kua e rovo muga ki zahe, ia ve hoho ki hada goloaloa kua ia bilip; ");
INSERT INTO wiv_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","na vuna dia ma beta dia na lohoi lala kua na polea ke Vuvu kua e tania da a Iesus e mahuri mule na matea. ");
INSERT INTO wiv_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Pale, na disaipel karua kua hiro ta vamule kara kahiro ruma. ");
INSERT INTO wiv_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Palaka a Maria ia ma ki madi na hatamara lovo ki tatangi. Ia ki tania kete tiro vatudu ni tunga hoho kara poloka matmat; ");
INSERT INTO wiv_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ia hadavia na engel rua, kahiro loholohoa e puzopuzoa matoto, hiro ka mimia na mudina podani Iesus kua muga e vangoroa vona. Katiu e mia kara bakana, katiu kara kabena. ");
INSERT INTO wiv_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Hiro ta hulenia, “Tavine, e kuziha ku tatangi?” Ia ki tania ni hiro, “Hau ta tatangi na vuna dia te pele kakava kagu tubu na poloka lovo, kini beta ne lala dia te taruhia ni ve.” ");
INSERT INTO wiv_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","E tani barae, ia tare poki ia hada a Iesus e mamadi, palaka beta ni hada lala habuka ia a Iesus za. ");
INSERT INTO wiv_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","A Iesus ia hulenia, “Tavine, e kuziha ku tatangi? Azei matoto tu kakaze kirina?” A Maria e lohoia ki tania ia na kaka kua e lala kete hahada poto na matmat, ia tani barae vona, “Paraha, kua kunu luga kunu taru motuzia, ho tu vatunga ni niau, hau kata pelea ni vano.” ");
INSERT INTO wiv_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","A Iesus ia tani barae, “Maria.” A Maria e tare poki kirina ki tani barae na pole matotoa ke vuni Hibru, “Rabonai!” (Mining na polea kua e tani barae, “Tisa.”) ");
INSERT INTO wiv_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","A Iesus ki tani barae vona, “Taua nu pahoriau, na vuna hau ma beta na zahe ni Tamagu; palaka vano ni habu tazigu nu tania ni dia habuka hau keteni vamule na kaka kua ia e Tamagu ki Tamadia ve, kua ia e kagu Vuvu ki kadia Vuvu ve.” ");
INSERT INTO wiv_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","A Maria Makdala e vano ia kalohunia na disaipel kamahi ki tania ve polea kua a Iesus e tania vona kete tania ni dia. ");
INSERT INTO wiv_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Kilangata kua ia na Sande. Ti garavi, na disaipel kamahi dia ta tabataba dia ka mimia na poloka ruma, na vuna dia ta kuahinia a vuni Iuda. Pale, a Iesus ia mai ia madi valutu na pidaka dia ki tani barae ni dia, “Magalimiu kete malugunia.” ");
INSERT INTO wiv_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Kamana ki tani barae, ia vatunga limana kamana vereverena ni dia. Pale, na disaipel kamahi polokodia e hilohilo matoto kamana dia ka hada na Paraha. ");
INSERT INTO wiv_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","A Iesus ki tania ni dia, “Magalimiu kete malugunia! Habuka kua a Tamagu e geriau ka mai, ia hau ve da ta gerimiu ve ka vano.” ");
INSERT INTO wiv_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Kamana ki tani hozovia polea kua, ia vilinia kavilika kiridia, ki tani barae ni dia, “Miu pelea na Vule Tumonga. ");
INSERT INTO wiv_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Kua miu kene lohoi bala manaunaua kana kaka katiu, ia ti lohoi balanga kana manaunaua; kua kini beta miu na lohoi bala manaunaua kana kaka katiu, ia kadia manaunaua ia e ba vovona.” ");
INSERT INTO wiv_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","A Tomas, hizana katiu ve a Didimus. Ia katiu ni dia na 12 disaipel kamahi kua, ia beta ia kilangata kua kamadia, a Iesus ki bele ni dia. ");
INSERT INTO wiv_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Pale, na disaipel kamahi dia ta ziuziu kana dia ka tani barae, “Hita ta hadavia Paraha kava.” Palaka a Tomas ki tania ni dia, “Ma ta hadavia na mudina nil na limana, ka taruhia kukugu na mudina muku kamahi ka taruhia ve limagu na vereverena, hau ka bilip.” ");
INSERT INTO wiv_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Dama polotolu ti kakava, na disaipel kamahi dia ta tabataba ve dia ka lololi na poloka ruma, a Tomas ia ti kamadia kilangata kua. Palaka a Iesus ia bele valutu mule ve na pidaka dia ve, ki tani barae ni dia, “Magalimiu kete malugunia.” ");
INSERT INTO wiv_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ia tani barae ni Tomas, “Mai taruhia kuku ri kua, ku hadavia ve limagu kamahi. Pahoria ve vereveregu. Taua nu lohoi ruarua. Bilip za!” ");
INSERT INTO wiv_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","A Tomas ki tani barae, “Ho kagu Paraha, kagu Vuvu!” ");
INSERT INTO wiv_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","A Iesus ki tani barae vona, “Tu hadaviau kua kunu bilip te? Palaka manumanu kua beta dia na hadaviau dia ka bilip, ia dia kata hilohilo.” ");
INSERT INTO wiv_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Na matana kana disaipel kamahi, a Iesus e katia mirakel luba ve palaka beta ni vapolunganga na buk kua; ");
INSERT INTO wiv_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","palaka kua nina kua, e vapolunganga kamiu, miu kata bilip habuka a Iesus ia a Kristus, na Tuni Vuvu, kua nu bilip vona, ia da tu mahuri roro. ");
INSERT INTO wiv_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Muri na kua a Iesus bele mule na kana disaipel kamahi na loka a Tiberias. Kua ia e bele barae ni dia. ");
INSERT INTO wiv_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","A Saimon Pita, ia mai a Tomas, hizana ruana a Didimus, a Nataniel, kaka kua bukuni Kana ni Galili, ia mai tuni Sebedi karua, ia mai na disaipel rua ve ke Iesus, dia laveve dia ta lololi lupu. ");
INSERT INTO wiv_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Pale, a Pita ia tani barae ni dia, “Hau kata vano kazekaze hiha.” Dia ta tania vona, “Hita ve hita ka vano kamaniho.” Dia ta vano dia ta polo na bot dia kene zahe. Palaka na marigo kapou kua, beta matoto za dia na pelea hiha katiu. ");
INSERT INTO wiv_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Tania voro ti mia zahe, a Iesus ia ti madi na vazalea, palaka na disaipel kamahi beta dia na hada lala habuka ia a Iesus za. ");
INSERT INTO wiv_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ia koi kiridia ki hulenidia, “E miu, miu beta hiha?” Dia ta tania, “Beta matoto.” ");
INSERT INTO wiv_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ia tania ni dia, “Miu varaga kamiu vuho kara paligena kiri marorona bot, da miu ta vatingovia hiha taza.” Pale, dia ta varaga vuho, palaka dia te lokia dia keteni harehi mulehia ni polo, na vuna hiha luba matoto kua ti tingo na vuho. ");
INSERT INTO wiv_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Na disaipel kua a Iesus e lala kete kulina kirina, e tania ni Pita, “A Paraha kuari!” Kamana a Pita ki longo baraenia, ia vivizia na kana kale havuhavua na votaka, (na vuna e hulia kana lavalava dia ka varagaraga vuho) ia dua kara naru kini huzu ziho. ");
INSERT INTO wiv_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Na disaipel taza dia ta vazula muri ziho kara vazalea, dia ta vazula harehia na vuho kua e vonu na hiha. Beta dia na pati zau marata na vazalea, habuka 100 mita za. ");
INSERT INTO wiv_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Dia ta zipazipa na vazalea, dia ta hada haroho katiu, na hiha katiu na huduna kamana bret taza. ");
INSERT INTO wiv_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Pale, a Iesus ia tania ni dia, “Miu pelea hiha taza kena miu ta ba vatingovia na vuho mai.” ");
INSERT INTO wiv_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Pale, a Pita ia polo na bot ia hare voringania na vuho kua e vonu na hiha kapopou, e 150 na naba na hiha laveve kua; na hiha e luba palaka na vuho beta ni tere. ");
INSERT INTO wiv_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","A Iesus ia tania ni dia, “Miu mai miu na hanihani.” Beta disaipel katiu ni vukazia havana ni hulenia, “Ho azei matoto?” Na vuna dia ta lala ia na Paraha za kua. ");
INSERT INTO wiv_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Pale, a Iesus ia vano pelea na bret ia vala ni dia, e vala ve hiha ni dia. ");
INSERT INTO wiv_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ia ti boto toluna vona kua a Iesus e bele na kana disaipel kamahi, muri na kua ia e mahuri mule na matea. ");
INSERT INTO wiv_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Dia ta hanihani hozo, a Iesus ia tani barae ni Saimon Pita, “Saimon tuni Jon, e dopa ki kuli matoto kirigu, livutia kua dia taza kua?” Ia e kolia ki tania, “E, Paraha, ho tu lala habuka hau e kuligu matoto kiriniho.” A Iesus ki tania vona, “Hada poto nu vangania kagu tuna sipsip kamahi.” ");
INSERT INTO wiv_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Boto ruana ve a Iesus ia huleni mulehia ki tania, “Saimon tuni Jon, kuli matoto kirigu?” Ia ki tania, “E, Paraha, ho tu lala hau e kuligu matoto kiriniho.” A Iesus ki tania vona, “Pele hada poto na kagu sipsip kamahi.” ");
INSERT INTO wiv_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Boto toluna a Iesus ia hule mulehia ve, “Saimon, tuni Jon, e kuli matoto kirigu?” A Pita ti hatunia ti beta ni kemi kua a Iesus ti hule mulehi baraenia, “E kuli kirigu?” Pale, ia tani barae, “Paraha ho tu lala goloaloa laveve; ho tu lala habuka hau e kuligu kiriniho!” A Iesus ki tania vona, “Hada poto nu vangania kagu sipsip kamahi. ");
INSERT INTO wiv_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ta tani matotonia ni niho: Kua tu ba huhuluvahu, ia tu lala koto vazohori mulehiho ku vavana kara palaka kua e kuli koto kirina. Palaka kua tanu vano nu lapunu, da tu vatatahia lima kaka motu ki vazohoriho ki peleho ku vano kara palaka kua e beta ni kuli koto vano kirina.” ");
INSERT INTO wiv_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","A Iesus e tatania kua ba muri a Pita kete mate ziha, ni vala glori ni Vuvu. Pale, a Iesus ia tania vona, “Muri ni niau!” ");
INSERT INTO wiv_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","A Pita e tare poki ki hadavia na disaipel kua a Iesus e kulina matoto kirina e mumuri ni hiro, ia na disaipel kua e vahere vano kozoho ni Iesus kilaka kua dia ta hanihani ki huleni baraenia a Iesus, “Azei da e valaho na limana ha vagi kamahi?” ");
INSERT INTO wiv_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Kamana a Pita ki hadavia na disaipel kua, ia hulenia a Iesus, “Paraha, kuari kaka kuari da e kuziha kuari?” ");
INSERT INTO wiv_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","A Iesus ki tania vona, “Kua ni kuligu kete ma mahuri haroniau ia ia ka vamule, ia kuziha? Ka galanga vona? Ho mai muri ni niau!” ");
INSERT INTO wiv_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Kubarae na polea kini mai vano na pidaka dia mule habuka na disaipel kua mara beta ni mate. Palaka a Iesus beta ni tania habuka beta kete mate; ia e tania, “Kua ni kuligu kete ma mahuri haroniau ia ia na vamule, ia kuziha? Ka galanga vona?” ");
INSERT INTO wiv_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ia na disaipel kua za kua e popole na goloaloa kua, ia ve ki vapolu taduria goloaloa kua; tolu ka lala habuka goloaloa laveve kua e tania ia e matoto. ");
INSERT INTO wiv_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Goloaloa luba matoto kua a Iesus e katia. Kua ni vapolu tadura laveve, ta lohoia da beta zeleka na vulovulo kara buk kamahi kua kete vapolunganga vona. ");
INSERT INTO wiv_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tiofilus, na kagu buk muga ta vapolungania ka pole na goloaloa laveve kua a Iesus e varivuvunia kete katia ki vaketea manumanu ve vona. ");
INSERT INTO wiv_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Ki vano ki mule na dama ti peloa ia kini zahe kara lagato. Muga na kua, ia e vaketekete na apostel kamahi, kua ia e makidia, na matuhanga kana Vule Tumonga, ");
INSERT INTO wiv_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","muri na bizea kapou kua ia e luga ki mate, ia e mahuri mule ia bele na kana apostel kamahi ki katia goloa luba matoto kete vatunga ni dia habuka kua e matoto, ia ti mahuri mule. E bele ni dia ki mia kamadia na dama e 40. Ki pole ni dia na vuna na kingdom ke Vuvu. ");
INSERT INTO wiv_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Boto katiu, kilaka kua dia ta hanihani lupu. Ia ki tani vatuharia ni dia ki tania, “Tabarae miu na vatia a Ierusalem, palaka miu guru kara goloa kemi kua a Tamagu ti mapamapa kete vala ni miu, habuka kua varira ta tania ni miu. ");
INSERT INTO wiv_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Na vuna a Jon Kakanaka Baptais e vazuguvia manumanu na naru, palaka da pitu papa miu ka vazuguva na Vule Tumonga.” ");
INSERT INTO wiv_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Pale, dia ka lupu laveve dia ka hulenia, “Paraha, karae kua koto nu vamadiri mulehia na kingdom ke Israel, hita mule ne hada vona?” ");
INSERT INTO wiv_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ia ki kolia ki tani barae ni dia, “Beta ni kamiu galanga kua miu kata lala na taem beu na dama kua a Vuvu ti makia na vuna na kana matuhanga mule. ");
INSERT INTO wiv_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Palaka da miu te pelea na matuhanga kua na Vule Tumonga ni mai ni miu; pale, da miu te vano ni Ierusalem, ia mai na palaka laveve ni Iudea, ia mai ni Samaria ia mai na palaka laveve na vulovulo miu kene tani kakava ni dia na kagu galangalanga kamahi kua miu ta hada ta katia.” ");
INSERT INTO wiv_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","A Iesus e tani hozovia polea kua, ia peloa kini zahe na matadia laveve. Pale, na mariaba ia karia kini beta dia na ma hadavia. ");
INSERT INTO wiv_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Dia ta ba tutunga langa kara mariaba dia ka ba hahada muria a Iesus, kaka rua hiro ta lohoria lavalava puzopuzoa hiro ta bele valutu hiro ta madi kamadia. ");
INSERT INTO wiv_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Hiro ta tania, “Vuni Galili, e kuziha miu ka mamadi tutunga langa kara mariaba? A Vuvu ti pele kakava a Iesus ni miu kini zahe kara lagato. Da e ziho mule habuka kuari miu ta hada e zahe kara lagato vona.” ");
INSERT INTO wiv_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Pale, dia ta pe na potuna kua e kohanga ni Oliv, dia ta vamule kiri Ierusalem. Kua nu vavana nu pe na siti nu vano kara potuna a Oliv, ia e habuka 1 kilomita. ");
INSERT INTO wiv_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Kamana dia ka vano bele, dia ta papane zahe kara rum kua dia ta lala dia kata lololi lupu vona. Nuhu dia ta lohu kilangata kua, ia, a Pita, a Jon, a Jems ia mai a Andru, a Filip hiro a Tomas, a Bartolomyu hiro a Matyu, a Jems tuni Alfius a Saimon kaka kua e bukuna kabu ke Selot, ia mai a Iudas tuni Jems. ");
INSERT INTO wiv_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Nuhu kua dia ta magali katiu dia ka lulupu dia ka lolotu. Ia mai tavivine taza kamani Maria titinani Iesus, kamani habu tazini Iesus, dia ve ta lala dia kata mai lolotu kamadia. ");
INSERT INTO wiv_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Nuhu kua dia ta bilip ni Iesus, kadia naba e 120. A Pita ki di madi na pidaka dia ");
INSERT INTO wiv_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","ki tania, “Habu tazigu, na polea kana Paraha ti bele matoto habuka kua na Vule Tumonga e pole na havani Devit ki pole na vuna ni Iudas, kua ia e vatunga dala na manumanu, dia ka paho taduria a Iesus. ");
INSERT INTO wiv_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Muga, a Iudas ia e katiu ni hita, ki gala lupu kamahita na galanga kana Paraha.” ");
INSERT INTO wiv_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Kamana moni kua e pelea habuka kadoana, kana moge zaha kua e katia. Ia kadea na garigari pitu vona, na garigari kua, ia ti dua vona na magalina kini tere na magalina laveve ki dua gotala kara garigari kua. ");
INSERT INTO wiv_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Manumanu laveve ni Ierusalem dia ta lala na goloa kua e bele, kubarae, dia ta kohania na garigari kua ni Akeldama. Hiza kua a Akeldama, e tani barae, garigarina topo. ");
INSERT INTO wiv_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","A Pita ki tani barae ve, “E vapolunganga na Buk Song, ‘Paleka kana palaka, ni zuka tapuanga. Tabarae, kaka katiu ni vano mia na mudina. Paleka kaka katiu motu ni pelea mudina na kana galanga.’ ");
INSERT INTO wiv_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Kubarae, kua tolu keteni makia kaka katiu na pidaka dolu kua e lala kete kakamadolu na dama laveve. Kilaka kua a Iesus e mai ki vavano kamadolu. ");
INSERT INTO wiv_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Varivuvu na taem kua a Jon e vala baptais na manumanu ki mai na taem kua a Vuvu ti pelea a Iesus ni dolu. Da tolu ta makia katiu ni dia kua e hadavia goloaloa laveve kua, kete katia galanga kamadolu ni tani kakava na mahuri mulea ke Iesus.” ");
INSERT INTO wiv_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pale, dia ta makia kaka rua, a Iosep, kaka kua dia ta kokohania ni Barsabas, hizana katiu ve a Jastus. Kaka katiu ve a Matias. ");
INSERT INTO wiv_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Pale, dia ta lotu dia ka tani barae, “Paraha, ho tu lala poloka manumanu laveve. Vatunga ni hita, azei ni hiro rua kua, ");
INSERT INTO wiv_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","kete pelea mudini Iudas kua ia ti vati tapunia, ia kini vano kara palaka kua ia ti vano kirina.” ");
INSERT INTO wiv_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Pale, dia ta varaga dais. Na naba na dais ia makia a Matias, pale, ia kini makua kini taruha kamadia kua 11 kua dia ta ba vovona. ");
INSERT INTO wiv_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Na damana Pentekos ti bele, na nuhu kua dia ta bilip ni Iesus dia ta lupu na palaka katiu. ");
INSERT INTO wiv_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Na halingana goloa katiu e bele valutu, e vuluvu habuka halingana kavili kapou ki pe na lagato ki vavonuhia na poloka ruma kua dia ta lulupu vona. ");
INSERT INTO wiv_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Dia ta hadavia goloa habuka tabelena haroho e ziho ia pahi valavalahia ia vano mia na bakana katiukatiu ni dia. ");
INSERT INTO wiv_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Dia laveve dia ta vonu na Vule Tumonga dia kene popole na pole matotoa kana manumanu motumotu. Na Vule Tumonga e katidia dia kene dangea dia kata pole barae kua. ");
INSERT INTO wiv_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","A vuni Iuda taza dia ta lohu ni Ierusalem. Dia ta nuhuta lotua ni Vuvu. Dia ta pe na kantri laveve na vulovulo dia ka lohu. ");
INSERT INTO wiv_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Kamana dia ka longoria na halingana goloa kua e bele, dia ta mai lupu. Dia ka zipa zahe matoto, na vuna katiukatiu ni dia ti longo lala habuka na nuhu kua dia ta bilip ni Iesus dia ta popole na kadia pole matotoa kamahi. ");
INSERT INTO wiv_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Dia ka lohoi tori matoto dia ka tani barae, “Manumanu laveve kuari dia ta popole kuari, dia ta bukuni Galili laveve kuari! ");
INSERT INTO wiv_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Pele, e kuziha tolu laveve kua tolu ka longo lala kadolu pole matotoa laveve kuari dia ta popole vona? ");
INSERT INTO wiv_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Tolu kua bukuni Partia, kamani Midia hiro a Elam. Tolu kua bukuni Mesapotamia, bukuna distrik a Iudea kamana provins a Kapadosia, kamana provins a Pontus kamani Esia. ");
INSERT INTO wiv_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Tolu kua bukuni Frigia kamani Pamfilia. Tolu nuhu kua tolu ta lololi ni Isip ia mai na palakalaka kamahi kua ni Libia kozoho ni Sairini, tolu kua bukuna kantri ni Rom. ");
INSERT INTO wiv_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Tolu kua bukuni Iudea matoto, ia mai nuhu kua bukuna malala motu, dia kene mai lolotu kamadolu. Tolu kua bukuni Krit kamana distrik a Arebia, tolu laveve kua tolu ta longo lala dia ta popole matoto kadolu laveve. Dia ka popole na galangalanga kapopou ke Vuvu!” ");
INSERT INTO wiv_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Dia laveve kua dia ta ridi matoto, dia ka lohoi tori, dia ka varihulei, “Goloa kua e bele, ia nazia matoto kua?” ");
INSERT INTO wiv_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Palaka manumanu taza dia ta katia bozubozua ni dia, dia ka tania dia ta hinu maratania vaen, dia ka sisipak. ");
INSERT INTO wiv_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Pale, a Pita ia madi kamana apostel kamahi kua e 11, ia pole kapopou ki tani barae na manumanu, “Habu vinekegu vuni Iuda, ia mai manumanu laveve kua miu ta mimia ni Ierusalem, miu longoriau kata tania ni miu na mining na goloa kua. ");
INSERT INTO wiv_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Manumanu kua, beta dia na sipak habuka kena miu ta tatania kiridia. E ba 9 kilok za na dama kua. ");
INSERT INTO wiv_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Palaka, ia kua nazia a profet Joel e vapolungania varira ki popole vona ki tani barae, ");
INSERT INTO wiv_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘A Vuvu e tani barae, “Kozoho kara las de. Da ta valikiria Vulegu na manumanu laveve. Habu tutumiu tamomohane, habu tutumiu tavivine da dia ta pole na kagu polea, kamiu huluvavahu da dia ta hada visen kamahi, kamiu lapunpun da dia ta pelea manginunginua. ");
INSERT INTO wiv_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Na dama kamahi kena ia da ta valikiria ve Vulegu na kagu voravora tamomohane kamana voravora tavivine, dia ka vala kagu polea balika profet kamahi. ");
INSERT INTO wiv_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Da ta katia mirakel kamahi ki bele heta na mariaba, heva na vulovulo da ta katia goloa kua muga beta miu na lala miu kata hahada. Da topo kamana haroho ia mai hazu kapou da e bele. ");
INSERT INTO wiv_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Na voro da ti beta keteni ma titiba, na lingabo da e pokizia ki baritunutunua balika topo, ba muri dama kapou kana Paraha kini bele, na dama kua na Paraha keteni vatunga kana matuhanga kamana kana glori vona. ");
INSERT INTO wiv_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Pale, azei kua tani kohania hizana Paraha ni halohonia Paraha, ia da e pele mulehidia.” ’ ");
INSERT INTO wiv_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Miu vuni Israel, miu longoria polea kua kata vala ni miu. A Iesus bukuni Nasaret, ia na kaka kua a Vuvu e vala matuhanga vona. Na mirakel kamana goloa kapopou kua a Vuvu e kakatia na limana kaka kua, ia e vatunga kakava habuka ia na kaka kua a Vuvu e makia. Miu mule miu ta lala goloa kua, na vuna e bele matoto ri na pidaka miu. ");
INSERT INTO wiv_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","E muri na lohoihoia ke Vuvu varira za. Kava ti lohoia habuka a Iesus da e valanga na limamiu, pale, miu kamana nuhuta moge zahazaha, miu ta nilinia na kruse. ");
INSERT INTO wiv_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Palaka a Vuvu ki valamari mulehia na matea, ki pele kakava ia na matuhanga kana matea, na vuna zia mara beta matoto matea ni ma kakarabusnia. ");
INSERT INTO wiv_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","A Devit ve e pole vona ki tania, ‘Hau ta hadavia na Paraha e vavamuga ni niau na dama laveve; ia e kozohotiau, ki mara beta na paria zahatanga. ");
INSERT INTO wiv_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","E kubarae ki marapalepalehiau matoto polokogu ki hilohilo matoto. Ka guguria goloaloa kemikemi kua a Vuvu kete katia ni niau. ");
INSERT INTO wiv_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Na vuna mara beta nu zuka tapuniau na malala kana manumanu kua dia te varimateai, mara beta ve nu vatia ka kaka Tumonga ni mavuru na poloka lovo. ");
INSERT INTO wiv_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Kava tu vatunga ni niau na dala kara mahuria, da tu vatiau ka mia kamaniho kete dopa marapalepalehiau.’ Na polea kamahi kua ia ke Devit. ");
INSERT INTO wiv_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Habu tazigu, kata tani vahotovia ni miu, na vuna na tubudolu a Devit kua ti mate kini tavuanga. Kana matmat kua e ngongoro na pidaka dolu varira za ki mai ki mule meni kua. ");
INSERT INTO wiv_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Palaka a Devit ia na profet katiu, ia ki lala a Vuvu e mapamapa habuka a Vuvu da e katia na tubuna katiu ki kara king baliki Devit mule. ");
INSERT INTO wiv_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","A Devit kava ti hadavia nazia kua a Vuvu da e katia ba muri, kubarae ia ki pole na mahuri mulea ke Mesias ki tani barae, ‘Ia beta ni zuka tapuanga ia na poloka lovo. Podana ve ki beta ni mavuru na poloka lovo.’ ");
INSERT INTO wiv_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","A Vuvu e valamari mulehia a Iesus na matea, hita laveve hita ka hadavi matotonia na goloa kua. ");
INSERT INTO wiv_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","A Iesus ti valamari muleha kini vamianga ia na maroroni limani Vuvu, a Tamana kini vala na Vule Tumonga vona vinaka kua e mapamapa kete vala vona. Nazia kua miu ta hada miu ka longoria, ia na kana Vule Tumonga kua, ia ti valikiria kini ziho ni hita. ");
INSERT INTO wiv_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","A Devit beta ni zahe kara lagato habuka kua a Iesus e zahe kara lagato. Palaka ia e tania, ‘Na Paraha e tania na kagu Paraha, “Mia ri kiri marorogu, ");
INSERT INTO wiv_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ki mule na dama kata taruhia ha vagi kamahi na tauri kabe.” ’ ");
INSERT INTO wiv_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Miu vuni Israel laveve miu kata lala kemikemihia habuka a Iesus kua miu ta havenia na kruse, ia, ia za kua a Vuvu e katia kini Paraha kini kara Mesias, na kaka kua kete pele mulehidolu!” ");
INSERT INTO wiv_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Kamana manumanu dia ka longo baraenia polea ke Pita, na polea kua e padea matoto polokodia. Dia ka hulenia a Pita kamana apostel kamahi dia ka tania, “Habu tai, nazia matoto da hita keteni katia kua?” ");
INSERT INTO wiv_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","A Pita ki tania ni dia, “Miu laveve kua miu pokizia magalimiu, miu na pelea baptais na hizani Iesus Kristus. A Vuvu ni lohoi bala kamiu manaunaua. Miu kata pelea na presen kana Vule Tumonga. ");
INSERT INTO wiv_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Varira a Vuvu e mapamapa kete vala Vule Tumonga ni miu kamani habu tutumiu ia mai ve na manumanu laveve dia ta mia zau. Ia mai ve nuhu laveve kua a Vuvu kadolu Paraha kete kohanidia.” ");
INSERT INTO wiv_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","A Pita e vala polea luba ve ni dia ki tani vatuharia ni dia ki tania, “Miu tare poki miu na zuka tapunia kamiu moge zahazaha, tabarae miu na pelea zahatanga kamana nuhuta moge zahazaha bukuna tauna kua.” ");
INSERT INTO wiv_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Polea ke Pita e padea poloka manumanu luba, dia ka pelea baptais. Kilaka kua manumanu e 3,000 ve kua dia te mai ve dia kene kamana nuhu kua dia ta muga dia ka bilip ni Iesus. ");
INSERT INTO wiv_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Dama laveve dia ta mia kamana apostel kamahi dia ka vaketekete ni dia, dia ka hanihani dia ka lolotu lupu. ");
INSERT INTO wiv_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Na apostel kamahi dia ta katia mirakel luba kamana goloaloa kapopou, na manumanu dia ka zipa zahe matoto. ");
INSERT INTO wiv_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Manumanu laveve kua dia ta bilip ni Iesus, dia ta mia magali katiu matoto, dia ka vazenia kadia goloaloa laveve kamani habu tazidia. ");
INSERT INTO wiv_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Kadia garigari, kadia goloaloa da dia ta vala ki kadoa dia ka vazenia monina na nuhu kua beta kadia goloaloa vona. ");
INSERT INTO wiv_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Na dama laveve dia ta lupu na tempel, dia ta lala dia kata lulupu kamani habu tazidia dia na hanihani na kadia rumaruma kamahi, dia ta hanihani kamana magali kemia, kamana hilohiloa, ");
INSERT INTO wiv_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","dia ka vazahenia hizani Vuvu na dama laveve. Manumanu laveve ki kulidia kiridia. Na dama laveve na Paraha kini vavaherea naba na manumanu kua dia ta bilip kini kakapou. ");
INSERT INTO wiv_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Dama katiu, ti taem kara lotua na 3 kilok na garavi, a Pita hiro a Jon hiro ta vavana zahe kara tempel. ");
INSERT INTO wiv_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Na kaka katiu kabena e matemate, ki lala kete luluganga dama laveve ni mamai kara geit kara tempel kua e kohanga ni Mata Muli, ki vatua vona kete vavarinongu na manumanu kua dia ta mai dia ka hohoho kara tempel. Muga za a titinana e valohia, kabena ki matemate. ");
INSERT INTO wiv_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Kamana ki hadavia a Pita hiro a Jon hiro keteni hoho kara tempel, ia hulenihiro kara moni. ");
INSERT INTO wiv_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","A Pita hiro a Jon hiro ta hada boroboronia. Pale, a Pita ia tani barae vona, “Tunga mai kirimiro.” ");
INSERT INTO wiv_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Pale, na kaka kua ia tunga vano kirihiro, e lohoia hiro keteni vala goloa katiu vona. ");
INSERT INTO wiv_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pale, a Pita ia tani barae vona, “Hau beta silva kamana gol, palaka nazia kua ni niau, ia da ta vala ni niho. Na hizani Iesus Kristus bukuni Nasaret, vavana.” ");
INSERT INTO wiv_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Pale, ia pahoria limana kiri maroro ia vamadiria, na kabena karua kamana tutura karua, hiro ta kemi pamuhi. ");
INSERT INTO wiv_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ia divurutia kini vavana. Pale, ia kamahiro hoho kara tempel, ki vavana ki raraga kini vavazahenia a Vuvu. ");
INSERT INTO wiv_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Kamana na manumanu laveve dia ka hadavia kua ia ti vavana kini vavazahenia a Vuvu, ");
INSERT INTO wiv_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","dia ta hada lala pamuhia habuka, ia kakanaka za kua e lala kete mimia na hatamara tempel kua e kohanga ni Mata muli ki lala kete vavarinongu, dia ka zipa zahe matoto na goloa kua ti bele. ");
INSERT INTO wiv_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Na kaka kua mata varinongunongu kua, e ma ki poto bada ni Pita hiro a Jon, na manumanu laveve dia ta ridi matoto na goloa kua dia kene rorovo mamai ni hiro na palaka kua na poloka tempel kua e kohanga na Veranda ke Solomon. ");
INSERT INTO wiv_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Tania a Pita ki hada baraenia ia tania kiridia, “Manumanu bukuni Israel, e kuziha na goloa kua ki hate zagarimiu? Kara zia miu ka hada patimiro? Miu ta lohoia ia na kamiro matuhanga mule o na vuna miro ta kaka kemi matoto na matani Vuvu kua miro kene katia kaka kua kini vavana? ");
INSERT INTO wiv_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Na Vuvu ke Abraham, ke Aisak, ke Jekop ia mai na Vuvu ke habu tubudolu, ia ti vala glori na kana vora a Iesus. Miu ka vala kete hubu matoa, miu ka vala lamamiu kirina, miu ka tania habuka beta ni kulimiu kirina na matani Pailat, a Pailat ia e kulina kete vagotalani mulehia, palaka miu ta hava. ");
INSERT INTO wiv_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Beta ni kulimiu kara Kaka kua e Mahoto Matoto ki Tumonga, miu ka hule kete vagotalanga kakanaka hubi matematea na kaka. ");
INSERT INTO wiv_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Miu te hubi matehia na kaka kua e vala mahuria, palaka a Vuvu ia ti valamari mulehia na matea. Hita ta hada vidovidohia na goloa kua. ");
INSERT INTO wiv_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Na vuna na bilip za na hizani Iesus, ia kua na kaka kua miu ta hada miu ka lala, kua ia ti katua kini kemi. Ia na hizani Iesus za ia mai na bilip kua e pe vona ki mai, ia kua ti katia na kaka kua kini kemi hozohozo, habuka kua miu laveve miu ta hadavia. ");
INSERT INTO wiv_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Kua, habu tazigu, hau ta lala habuka, miu kamana kamiu pararaha miu ta katia goloa kua ni Iesus na vuna beta miu na lohoi vutuhia nazia miu ta kakatia. ");
INSERT INTO wiv_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Palaka a Vuvu ia ti katia kini pori kana polea kua varira za e tani kakava na havana profet kamahi habuka, a Kristus ia da e luga bizea. ");
INSERT INTO wiv_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Miu vala lamamiu kara kamiu moge zahazaha, miu na tare poki, miu na vamule ni Vuvu, a Vuvu kete lavelavehia kamiu manaunaua kamahi. A Paraha kete vala mianga vahoru ni miu, ");
INSERT INTO wiv_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ia ni geria a Kristus, a Iesus ni mai ni miu, ia na kaka kua kava ti makua kamiu. ");
INSERT INTO wiv_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Da e ma ki mia na lagato ki vano ki mule na dama kua a Vuvu ti makia kete katia goloaloa ni vahoru mule, habuka kua varira ia e mapamapa ki tani kakava na havana kana profet tumonga kamahi. ");
INSERT INTO wiv_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Na vuna a Moses e tani barae, ‘A Vuvu kamiu Paraha da e vamadiria na profet katiu balika hau na pidaka miu mule; miu tabu longo kara polea laveve kena e tania ni miu. ");
INSERT INTO wiv_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Azei kua ta beta ni longoria kana polea, da a Vuvu e vahere kakava na kana manumanu ki hubi matehia.’ ");
INSERT INTO wiv_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","E matoto, na profet laveve, varivuvu ni Samuel ki mai na profet kamahi kua dia ta muri ni Samuel, dia ve dia ta tani kakava nazia kua da e bele na dama kamahi kua meni. ");
INSERT INTO wiv_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Miu na mapamapanga kua a Vuvu e katia ki vala na kana profet kamahi, ia kamiu, na kontrak kua a Vuvu e katia kamani habu tubumiu ia e kamiu ve. Habuka kua ia e tani barae ni Abraham, ‘Ni habu kapupu, hau da ta kati kemihia matoto na manumanu laveve na vulovulo.’ ");
INSERT INTO wiv_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Pale, kilaka kua a Vuvu ti makia kana vora, ia muga ki geria ki mai ni miu kete kati kemihia ni miu. Ia e kati kemihia ni miu na vuna kua ia ti katia katiukatiu ni miu kete vala lamana kara kana moge zahazaha.” ");
INSERT INTO wiv_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Na Pris kamahi kamana kepten kara gat kamahi kara tempel ia mai a vuni Sadyusi ni Ierusalem dia ta zahe bele ni Pita hiro a Jon kilaka kua hiro ta ba popole kamana manumanu. ");
INSERT INTO wiv_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Polokodia e zaha kara apostel karua kua na vuna hiro ta vavaketea na manumanu habuka a Iesus ti mahuri mule na matea, ia ki vatunga habuka nuhu kua dia te mate da dia ta mahuri mule. ");
INSERT INTO wiv_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Dia ta paho taduria a Pita hiro a Jon, palaka na vuna ti garavi kava, dia ta taruhihiro na karabus. Dia ta guria kete dama mule. ");
INSERT INTO wiv_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Palaka manumanu luba kua dia ta longoria na polea kua, dia ta bilip na polea kua; pale, naba kana manumanu kua dia ta bilip ti bele 5,000. ");
INSERT INTO wiv_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ti dama, na pararaha ke vuni Iuda, kamana kadia kaunsil kamahi ia mai na tisa kamahi kara lo dia ta lohu dia ka lupu ni Ierusalem. ");
INSERT INTO wiv_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Dia ta lupu kamana hetpris a Anas, ia mai a Kaiafas, ia mai a Jon, a Aleksander ia mai tamomohane taza ve kua dia ta bukuna kabu kana hetpris. ");
INSERT INTO wiv_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Dia ta pelea na apostel karua kua, hiro ta madi na matadia, dia ta huleni barae ni hiro, “Mo ta kati zingania goloa kua? Na matuhanga zia ni moro o na hizani zei matoto mo ta gagala vona?” ");
INSERT INTO wiv_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Pale, a Pita, ki vonu na Vule Tumonga, ia tani barae ni dia, “Kaunsil kamahi kamana pararaha ke manumanu! ");
INSERT INTO wiv_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Ta miro ni huhuleanga miro meni na goloa kemi kua e katua na kaka kabe matemate kua, e ia kini kemi ziha, ");
INSERT INTO wiv_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","pele miu, ia mai manumanu laveve ni Israel miu kata lala habuka, na kaka kua e mamadi na matamiu, ia ti kemi hozohozo na vuna na matuhanga kana hizani Iesus Kristus bukuni Nasaret, kaka kua miu ta havenia na kruse, a Vuvu kini valamari mulehia na matea. ");
INSERT INTO wiv_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","A Iesus ‘Ia na kedo kua miu nuhu kua miu ta hahabatia ruma miu te pala katia miu kene hada vetavetania, na kedo kua, ia ti kara kedo kua ti mia tuka na ruma.’ ");
INSERT INTO wiv_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Mara beta matoto kaka motu katiu ni pele mulehidolu, na vuna beta ve hiza katiu na lagato o na vulovulo kua ni valanga na manumanu kua kete vaikoli kiridia voa vona.” ");
INSERT INTO wiv_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Na kaunsil kamahi kua dia ta zipa zahe matoto kua dia ta hadavia a Pita hiro a Jon kua habuka beta hiro na kuahi pitu, ki vano ve hiro ta kaka vetanga za ki beta hiro na sikul ve. Palaka dia te hada lala habuka kaka rua kua, hiro ta lala hiro kata kakamani Iesus. ");
INSERT INTO wiv_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Palaka na vuna kua dia ta hada na kaka kua e katua ki kemi kua e mamadi kamahiro, kubarae ki beta kadia polea dia kata tania. ");
INSERT INTO wiv_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Kubarae, dia ta geridia dia ta vatia na rum kaunsil. Pale, dia kene popole na pidaka dia mule. ");
INSERT INTO wiv_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Dia ka varihulei, “Tolu kata kuzingania na kaka rua kua? Manumanu laveve ni Ierusalem dia te lala na mirakel kapou kua hiro ta katia, ki mara beta ve tolu na tania habuka e beta ni matoto. ");
INSERT INTO wiv_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Palaka kua, tolu kata katia na rereka goloa kua kete beta kete ma vavana lobia manumanu, ia tolu kata tani vatuharia na kaka rua kua, habuka beta ve hiro kata ma popole kamana kaka katiu ve na hizani Iesus.” ");
INSERT INTO wiv_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Pale, dia ta kohani mulehihiro, hiro ta mai hoho dia ta tani vatuharia ni hiro habuka beta matoto hiro kata pole o vaketekete ve na hizani Iesus. ");
INSERT INTO wiv_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Palaka a Pita hiro a Jon hiro ta kolia kadia polea hiro ka tania, “Miu mule miu sikelnia, habuka e mahoto na matani Vuvu kua hita kata longoria kamiu polea o hita kata longoria polea ke Vuvu. ");
INSERT INTO wiv_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Na vuna miro, miro ta lokia miro kata tabaria havamiro na nazia kua miro ta hadavia miro ka longoria.” ");
INSERT INTO wiv_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Pale, na kaunsil kamahi dia ta dopa ve tani vatuharia ve polea dia ka vakuahini hiro pale, dia ta vatihiro, hiro ta gotala mule. E beta dia na lala nazia dia kata katia ni hiro, na vuna manumanu dia te vavazahenia a Vuvu na nazia kua ti bele. ");
INSERT INTO wiv_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Na kaka kua e katua ki kemi kana krismas ti livutia 40. ");
INSERT INTO wiv_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Kamana ki vagotalani muleha a Pita hiro a Jon, hiro ta vamule vano na kadia manumanu kua dia ta lulupu, hiro ta tania ni dia na polea kua na hetpris kamana kadia pararaha ke vuni Iuda kua dia ta tania ni hiro. ");
INSERT INTO wiv_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Tania dia ka longo baraenia, dia ta lupu laveve dia ta lotu ni Vuvu dia ka tani barae, “Paraha kahita Tubu ho, ia ho kua tu katia na lagato kamana vulovulo kamana dazi kamana goloaloa laveve na poloka. ");
INSERT INTO wiv_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Varira na Vule Tumonga e vala ka polea katiu na tubuhita a Devit ka vora ia ki tani barae, ‘E kuziha, na kantri kamahi magalidia ki halavidi marata; E kuziha manumanu ki tataru lupuni vetania kadia polea kara moge zahazaha? ");
INSERT INTO wiv_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Na king kamahi kara vulovulo dia ta madi lupu dia ka vavaida kara varihubia. Kadia pararaha kamahi dia ka lohu lupu dia kata varihubi kamana Paraha ia mai kamana kana kaka kua ia ti makia kete pele mulehia kana manumanu.’ ");
INSERT INTO wiv_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","E matoto, a Herot hiro a Pontius Pailat hiro ta lupu kamana nuhu kua beta dia na lala a Vuvu kamana manumanu bukuni Israel dia ka taru lupunia kadia polea dia kata hubia a Iesus, ka vora Tumonga, kaka kua tu makia. ");
INSERT INTO wiv_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Dia ta lupu dia kata katia nazia kua ho kua muga za na ka matuhanga kamana ka lohoihoia kava tu lohoia kete bele barae. ");
INSERT INTO wiv_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Pale kua, Paraha, tabarae nu taruhia ka lohoihoia na kadia polea kamahi kua dia ta vavakuahini hita vona, palaka katia hita ka voravora, polokohita kete tutu kete beta hita kata kuahi, hita na vala ka polea. ");
INSERT INTO wiv_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Tabenia lima nu kati kemihia manumanu nu katia mirakel kapopou na hizana ka vora Tumonga a Iesus.” ");
INSERT INTO wiv_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Dia ta lotu hozo, na palaka kua dia ta lulupu vona, e hunu. Na Vule Tumonga ki vavonuhidia laveve kini beta kuahia na polokodia, dia kene vavala polea ke Vuvu. ");
INSERT INTO wiv_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Manumanu laveve kua dia ta bilip ni Iesus, dia ta taru lupunia kadia lohoihoia kamana magalidia ki katiu papa za. Beta katiu ni dia ni mata kuku o ni bihei na kana goloaloa. Dia ta varikodongi na kadia goloaloa laveve na pidaka dia mule. ");
INSERT INTO wiv_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Na apostel kamahi dia ka tatani kakava na polea kua habuka, na Paraha a Iesus, ia ti mahuri mule na matea. Dia ta vavala polea kua kamana matuhanga kapou. A Vuvu kini kakati kemihia matoto na manumanu laveve. ");
INSERT INTO wiv_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Na pidaka dia mule beta katiu ni sot na goloa katiu. Nuhu kua kadia garigari vona o kadia ruma vona, dia ta salinia goloaloa kua, dia ka vilehia monina goloaloa kua, ");
INSERT INTO wiv_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","dia ka vala na apostel kamahi; pale, na apostel kamahi dia ta vazenia moni kua na nuhu kua dia ta sot na goloaloa. ");
INSERT INTO wiv_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Pale, a Iosep, ia kaka bukuna kabu ke Livai kamahi ki valohua ni Saiprus, ia kua na apostel kamahi dia te kohania ni Barnabas (na hiza kua mining vona e tani barae, “Na kaka kua e lala kete vavabadangania kaka”), ");
INSERT INTO wiv_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ia e salinia kana garigari katiu ki pelea monina ki mai, ia vala moni laveve kua na apostel kamahi. ");
INSERT INTO wiv_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Palaka na kaka katiu hizana a Ananias, ia kamani gona a Safaira hiro ve hiro ta salinia kahiro garigari pitu. ");
INSERT INTO wiv_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","A Ananias ia lohoia kete paho taduria dihura monina garigari kua, a gona tavine ki magali katiu kamana habuka hiro kata paho taduria dihura moni kua, pale, a Ananias ia pelea na dihura moni kua ia vano taruhia na kabena apostel kamahi. ");
INSERT INTO wiv_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","A Pita ia hulenia, “Ananias, e kuziha ku vatia a Satan ki vavonuhia poloko kunu rukia na Vule Tumonga, kunu paho taduria dihura moni kua tu salinia ka garigari ku pelea? ");
INSERT INTO wiv_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Na garigari muga ia e ka, ba muri kunu salinia, kamana ku salinia, na monina ia e ka ve. Pele e kuziha kunu lohoia koto nu katia na goloa kua tu katia? Beta nu rukia manumanu, palaka tu rukia a Vuvu!” ");
INSERT INTO wiv_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Tania a Ananias ki longoria na polea kua, ia dua ia mate pamuhi. Manumanu laveve dia ka kuahi zahazaha matoto kilaka kua dia ta longoria goloa kua e bele. ");
INSERT INTO wiv_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Pale, na tamomohane huluvavahu, dia ta hoho, dia ta kukulia podana, dia ta luga gotala, dia kene tavunia. ");
INSERT INTO wiv_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Muri na aua tolu a gona tavine ia mai ve hoho, beta ni lala nazia kua kava ti bele. ");
INSERT INTO wiv_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","A Pita ia hulenia, “Tania ni niau, ia kua na moni laveve na garigari kua mo a go mo ta pelea na garigari kua mo ta salinia mo ka pelea?” Na tavine kua ki tania, “E, ia na moni laveve kena.” ");
INSERT INTO wiv_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","A Pita ki tania kirina, “E kuziha mo ka taru ruania kamo lohoihoia mo kata parakilania na Vulena Paraha? Hadavia! Na nuhu kua dia ta tavunia a go, kena dia na hatama, da dia ta lugaho ve kua ki gotala!” ");
INSERT INTO wiv_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Na tavine kua ia dua pamuhi kozohotia na kabeni Pita, ia mate. Na tamomohane huluvavahu kamahi kua dia ta mai hoho dia ka hada habuka, ia ti mate kava, dia ta luga ve gotala, dia ta tavunia na kitaki gona. ");
INSERT INTO wiv_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Kuahia kapou ki bele na manumanu laveve kua dia ta bilip ni Iesus ia mai ve na manumanu laveve kua dia ta longoria na rereka goloa kua e bele. ");
INSERT INTO wiv_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Na apostel kamahi dia ka katia na mirakel luba na pidaka manumanu. Na manumanu laveve kua dia ta bilip ni Iesus, dia ta lulupu na Veranda ke Solomon. ");
INSERT INTO wiv_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Nuhu kua beta dia na bilip ni Iesus, beta dia na parakilania dia kata hoho kamadia, palaka dia ta hada zahenidia matoto. ");
INSERT INTO wiv_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Palaka manumanu luba, luluba, kua dia te bilip na Paraha dia kene mai hoho kamadia, tavivine ia mai tamomohane ve. ");
INSERT INTO wiv_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Na vuna kua na apostel kamahi dia te kakatia na mirakel kamahi kua, manumanu dia kene pelea nuhu kua mazahi ni dia, dia kene vangoredia na daladala kamahi na huduna dongi kamahi kamana mat, habuka kua ta a Pita ni pe hutu, hanunuka za kete vano kara nuhu kua e mazahitidia. ");
INSERT INTO wiv_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Na kabuna manumanu dia kene pe na taon kamahi kua e lobia a Ierusalem, dia ta vilehia nuhu kua e mazahitidia ia mai nuhu kua na hanitu e hoholiholidia; dia ka katu kemuha laveve. ");
INSERT INTO wiv_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Pale, na hetpris kamana nuhu kua dia ta lala dia kata kakamana, dia ta bukuna kabu ke vuni Sadyusi, magalidia e zaha matoto kara apostel kamahi, kubarae dia te lohoia dia kata katia goloa katiu na apostel kamahi. ");
INSERT INTO wiv_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Dia ta paho taduria na apostel kamahi dia kene taruhidia na karabus kamana nuhu zahazaha. ");
INSERT INTO wiv_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Palaka na marigo na engel kana Paraha e vukazia na geit kara haus karabus, ia vagotalani mulehia na apostel kamahi, ia tani barae ni dia, ");
INSERT INTO wiv_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Miu vano miu na madi na poloka tempel, miu na tani kakava na manumanu na daladalangana mianga vahoru kua.” ");
INSERT INTO wiv_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ti dama, na apostel kamahi dia ta muri na polea kana engel kua, dia ta hoho na poloka tempel, dia ta vala polea na manumanu. Tania na hetpris kamana nuhu kua dia ta lala dia kata kakamana dia ka lohu, dia ta koi lupunia na kaunsil kamahi kamana pararaha ke vuni Israel, dia ta mai lohu, pale, dia ta geu kete peloa na apostel kamahi na karabus. ");
INSERT INTO wiv_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Palaka na opisa kamahi, tania dia ka vano bele na karabus, beta dia na paria na apostel kamahi na karabus. Dia ta vamule tania ni dia. Dia ka tani barae, ");
INSERT INTO wiv_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Hita ta vano na haus karabus, hita ta hada na doa kara karabus e tabara ki lokoanga, na gat kamahi dia ka vavarimadiriai na hatama, palaka tania hita ka vukazia na geit, beta hita na paria kaka katiu na poloka!” ");
INSERT INTO wiv_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Na hetpris kamahi kamana komada kara gat kamahi dia ta longoria na polea kua, dia ka lohoi toritori matoto, kua ti kubarae, nazia da ti bele kua. ");
INSERT INTO wiv_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Pale, na kaka katiu e mai hoho ia tania ni dia, “Miu hadavia! Nuhu kua miu ta taruhidia na karabus, kuari dia ta mamadi na poloka tempel dia ka vavaketekete na manumanu.” ");
INSERT INTO wiv_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Pale, na kepten kara gat kamahi ia pelea na gat kamahi dia ta vano pelea na apostel kamahi. Beta dia na katia goloa katiu ni dia, dia ta koi valugidia za, na vuna dia ta kuahinia na manumanu ta dia na vaivozo kamadia na kedo. ");
INSERT INTO wiv_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Dia ta pelea na apostel kamahi dia ta mai hoho, dia ta vamadiridia na matana kaunsil kamahi, pale, na hetpris ia hulenidia. ");
INSERT INTO wiv_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Ia ki tani barae ni dia, “Hita ta vatabunimiu matoto beta miu kata vaketekete na hizana kaka kua. Palaka miu te ba vavonuhia matoto a Ierusalem na kamiu vaketeketea kua, miu kene papadehita na matea kana kaka kena!” ");
INSERT INTO wiv_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","A Pita ia mai na apostel kamahi dia ka kolia kana polea dia ka tania, “Hita da hita ta longoria hita ka muri na polea ke Vuvu za, beta hita kata muri na polea kana kaka vetanga. ");
INSERT INTO wiv_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","A Vuvu ke habu tubudolu ia e valamari mulehia a Iesus na matea, kaka kua miu ta havenia na huda hai miu ka hubi matehia. ");
INSERT INTO wiv_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","A Vuvu ki valamari mulehia na matea ki vamiania kiri marorona ki makia kete kara kaka kua kete vamuga ni vatunga dala ni pele mulehia a Israel, kete katia dia na zuka tapunia kadia moge zahazaha, ia ni lohoi bala kadia manaunaua. ");
INSERT INTO wiv_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Hita ta hadavia goloaloa kamahi kua na matahita matoto, hita kamana Vule Tumonga. Na Vule Tumonga, ia a Vuvu da e vala vetania na nuhu kua dia ta lala dia kata lolongoria dia na mumuri na kana polea.” ");
INSERT INTO wiv_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Kamana na kaunsil kamahi dia ka longoria na polealea kamahi kua, magalidia ki varitihi matoto, dia kene tania dia keteni hubi matehidia. ");
INSERT INTO wiv_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Palaka na Parisi katiu hizana a Gamaliel, ia na tisa katiu kara lo, manumanu laveve dia ka lala dia kata hahada zahenia, ia di madi na pidaka kaunsil kamahi ia geu dia kata pelea na apostel kamahi kua dia na gotala guru na hatama. ");
INSERT INTO wiv_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ia tani barae na kaunsil kamahi, “Habu tazigu vuni Israel, miu lohoi papa ba muri miu ka katia goloa katiu na manumanu kuari. ");
INSERT INTO wiv_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Miu ta lohoia a Teudas, kua e bele muga, ki vavazahezahenia hizana mule, pale, manumanu tauka e 400 dia ta muri vona. Palaka ia hubu matoa, pale, manumanu kua dia ta lala dia kata mumuri vona, dia ta bura katiutiu, pale, dia ta balavutuka. ");
INSERT INTO wiv_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ba muri vona, a Iudas na kaka bukuni Galili katiu, e lohu na taem kara senses; ia ki harehia kabuna manumanu kapou dia ka mumuri vona, palaka ia ve e hubu matoa, nuhu kua dia ta mumuri vona dia ta bura katiutiu. ");
INSERT INTO wiv_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ki kubarae, ka tania ni miu, tabarae miu na katia goloa katiu na manumanu kua. Miu vatidia na vano! Kua nazia kua dia ta lolohoia dia kata kakatia ni bele na lohoihoia kana kaka vetanga bukuna vulovulo ia da beta kete ma vavano. ");
INSERT INTO wiv_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Palaka kua ta na lohoihoia kua tani pe ni Vuvu, ia mara beta matoto miu na taledia dia na longo; da miu te vavarihubi kamani Vuvu.” Kana polea e pokizia kadia lohoihoia. ");
INSERT INTO wiv_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Pale, dia ta koi kara apostel kamahi hoho, dia ta geu ia vihua dia. Pale, dia ta tani vatuharia ni dia habuka beta ve dia kata ma popole na hizani Iesus, pale, dia ta vatidia dia ta vano. ");
INSERT INTO wiv_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Na apostel kamahi dia ta vatia na lupua kana kaunsil kamahi kua, dia ka hilohilo matoto na vuna dia ta hatunia e goloa kapou matoto kua dia ta luga bizea kamana puaea na hizani Iesus. ");
INSERT INTO wiv_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Na dama laveve, na poloka tempel ia mai na ruma katiukatiu, beta dia na lala dia kata tabaria havadia na vaketeketea kamana rataratanga na Kalohua Kemi kua habuka, a Iesus, ia a Kristus za. ");
INSERT INTO wiv_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Kilaka kua, kamana na naba kana Kristen kamahi ti luluba, na Kristen kamahi kua dia ta lala dia kata popole matoto ke vuni Grik, dia ta vaigege kamana Kristen kamahi kua dia ta lala dia kata popole matoto na polea Aram. Nuhu kua dia ta lala dia kata popole matoto ke vuni Grik dia ta padea polea kiridia, dia ka tania habuka, taem dia ta vazenia haninga, beta dia na lala dia kata vavala haninga na kadia tavivine gabugabu. ");
INSERT INTO wiv_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Pale, na 12 apostel kamahi dia ta koi lupunia na disaipel laveve, dia ta tani barae, “E beta ni kemi kua tolu kata vatia galangana valavalanga na polea ke Vuvu tolu na hahada ve na galangana vazea na haninga. ");
INSERT INTO wiv_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Habu tai, miu makia manumanu e 7 na pidaka miu, nuhu kua miu ta lala habuka dia ta vonu na Vule Tumonga kamana lohoihoia pa. Tolu kata vala galangana vazea na haninga ni dia. ");
INSERT INTO wiv_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Hita, beta hita kata katia galanga motu katiu ve. Kahita galanga ia hita kata lolotu za kamana valavalanga na polea kana Paraha.” ");
INSERT INTO wiv_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Manumanu laveve dia ta tania na lohoihoia kua e kemi. Dia ta makia, a Stiven, kaka kua kana bilip e kapou matoto ki vonu ve na Vule Tumonga; ia mai a Filip, a Prokorus, a Nikanor, a Timon, a Parmenas, ia mai a Nikolas bukuni Antiok, beta ia ni na Iuda katiu, palaka e lolotu na lotua ke vuni Iuda, palaka kua ti kara Kristen katiu. ");
INSERT INTO wiv_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Dia ta pelea nuhu kua vano na apostel kamahi, na apostel kamahi dia ta taruhia limadia na hududia dia ta lotu kiridia. ");
INSERT INTO wiv_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Pale, na polea ke Vuvu kini vavana lobia malala. Dama laveve na naba kana disaipel kamahi ni Ierusalem ti luluba taputapu matoto, ia mai ve na kabuna pris kapou, dia ve te muri na polea ke Vuvu dia kene bilip ve. ");
INSERT INTO wiv_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","A Stiven, ia e vonu matoto na mahariharia kamana matuhanga ke Vuvu, ki lala kete katia mirakel kapopou na pidaka manumanu. ");
INSERT INTO wiv_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Palaka manumanu taza dia ta di madi kiri Stiven dia ta vaigege kamana. Nuhu kua, dia ta bukuna haus lotu katiu ke vuni Iuda kua e kohanga na haus lotu kana nuhu kua ti beta dia ne ma vovora vetanga. Nuhu kua dia a vuni Iuda bukuni Sairini kamani Aleksandria ia mai na provins karua kua a Silisia kamani Esia. Nuhu kua dia ta vaigege kamani Stiven, ");
INSERT INTO wiv_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","palaka ki mara beta dia na dibala na vuna na Vule Tumonga e vala lohoihoia kemi matoto ni Stiven ia ki popole. ");
INSERT INTO wiv_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Kubarae dia ta vano rogo za na manumanu taza dia ta pado rukidia dia kata varaga baraenia polea, dia kata tani barae, “Hita ta longoria a Stiven e dedelahania a Moses kamani Vuvu.” ");
INSERT INTO wiv_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Dia ta katia vairukua kua, dia kene katia manumanu kamana pararaha ke vuni Iuda ia mai na saveman kara lo dia ta di madi kiri Stiven dia ta paho taduria, dia ta pelea zahe dia ta vamadiria na matani vuni kaunsil kamahi. ");
INSERT INTO wiv_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Dia ta pelea manumanu taza dia kata vairuku kirina, nuhu kua dia ta tani barae, “Hita ta longoria habuka kaka kua dama laveve e lala kete dedelahania na ruma ke Vuvu kamana lo ke Vuvu. ");
INSERT INTO wiv_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Hita ta longoria e tani barae habuka na kaka kua a Iesus bukuni Nasaret da e robea na palaka kua ki pokizia ve na kastam kamahi kua a Moses e vala ki ziho ni dolu.” ");
INSERT INTO wiv_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Manumanu laveve kua dia ta mimia na poloka lupua kana kaunsil kamahi kua, dia ta hada boroboronia a Stiven, dia ka hadavia damana e babala balika engel katiu. ");
INSERT INTO wiv_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Na hetpris ia hulenia a Stiven, “Na polea kamahi kua dia ta papadeho vona, e matoto?” ");
INSERT INTO wiv_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","A Stiven ki kolia kana hulea ki tani barae, “Habu tazigu kamani habu tamagu, miu longoriau! Na glori ke Vuvu e bele ni tubudolu a Abraham kilangata kua ia e ba vovona ni Mesapotamia, muri kini vano mia ni Haran. ");
INSERT INTO wiv_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","A Vuvu ki tani barae vona, ‘Vatia ka kantri kamana ka manumanu nu vano kara garigari katiu kua hau kata vatunga ni niho.’ ");
INSERT INTO wiv_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Pale, ia vatia na garigari ke vuni Kaldia ki vano mia ni Haran. Muri a tamana ti mate, a Vuvu ia geria ia mai kara garigari kua miu ta mimia vona meni. ");
INSERT INTO wiv_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Na palaka kua beta matoto ni vala kana goloa katiu vona, beta ve ni vala dihura garigari pitu vona. Palaka a Vuvu e mapamapa vona ki tania vona habuka da ia kamani habu tubuna ba muri, da dia ta pelea garigari kua ki kadia, kilaka kua a Abraham ma beta tuna vona. ");
INSERT INTO wiv_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","A Vuvu ki tani barae vona, ‘Habu kapupu, da dia ta mia na kantri kana manumanu motu, da dia ta karabusianga dia ka kara vora vetanga ki katu zahata ni dia voa na krismas e 400.’ ");
INSERT INTO wiv_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","A Vuvu ki tani barae ve vona, ‘Palaka da ta koto kara manumanu na kantri kena dia ta vora vetanga vona, ba muri hau da ta pele mulehidia dia ta gotala na kantri kena, dia ta mai lotu ni niau na malala kua.’ ");
INSERT INTO wiv_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Pale, a Vuvu ia tania ni Abraham habuka kete vavatomutomu kapirupiru tamomohane kete makia habuka ia e katia kontrak kamani Vuvu. Pale, kamana a Aisak tuni Abraham ti valohua, ia guru habuka wik katiu ti kakava, ia vatomutomuhia. A Aisak, tuna a Jekop, a Jekop habu tutuna e 12 kua dia na habu tubudolu kua. ");
INSERT INTO wiv_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Palaka na vuna kua habu tubudolu dia ta hahada potia a Iosep, dia ta salinia a Iosep habuka vora vetanga na manumanu taza. Nuhu kua dia ta pelea kini vano kiri Isip. Palaka a Vuvu beta ni vati vetania a Iosep. ");
INSERT INTO wiv_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Ia kini vaikoli kirina kini vahozovia kana bizea laveve. Ia vala lohoihoia kemi matoto ni Iosep kubarae ki katia na king ke vuni Isip ki kulina matoto kiri Iosep, kubarae ia taruhia a Iosep ia kara Praim Minista ni Isip ki hada na kantri a Isip laveve ia mai ve e hada ve na ruma kapou kana king. ");
INSERT INTO wiv_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Pale na vitolo kapou ia bele na malala laveve ni Isip kamani Kenan, vitolo kapou matoto ki bele kiri habu tubudolu, dia ka luga bizea kapou matoto. ");
INSERT INTO wiv_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Kamana a Jekop ki longoria habuka na plaua vona rae ni Isip, ia geria habu tubudolu dia kata vano kiri Isip. Kilaka kua, ia dia te varivuvunia kadia vanoa kiri Isip. ");
INSERT INTO wiv_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Dia te vamule boto ruana ve, ia a Iosep ti kalohulohunia ni dia habuka ia azei matoto, pale, a king kini lala horuhoru na famili ke Iosep. ");
INSERT INTO wiv_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Muri na kua a Iosep ia geu kiri tamana a Jekop, kamana kana famili laveve, kadia naba e 75. ");
INSERT INTO wiv_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Pale, a Jekop ia ziho kiri Isip. A Jekop kamani habu tubudolu, dia ta varimateai ni Isip. ");
INSERT INTO wiv_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Podadia laveve e pele muleha ki mai tavuanga na taon a Sekem na poloka matmat kena a Abraham e kadea ni habu tutuni Hamor na moni silva. ");
INSERT INTO wiv_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Tania na dama kua a Vuvu keteni vaporihia kana kontrak kua ia e katia kamani Abraham ti kokozoho, na naba na kana manumanu ve ni Isip dia te luluba matoto ve. ");
INSERT INTO wiv_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Pale, ba muri na kaka motu katiu ti kara king ni Isip, kini beta ni lala a Iosep. ");
INSERT INTO wiv_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","King kua e kati zahatia matoto na kadolu manumanu ki ditaduria matoto habu tubudolu, na vuna e geridia dia kata varaga habu tutudia kua dia ba valohulohu dia na vali matehidia. ");
INSERT INTO wiv_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Kilaka kena ve a Moses ia e valohua ve, ki kapiru mata muli, a Vuvu ki kulina kirina. Dia ka hada poto vona na poloka ruma ke tamana na lingabo tolu. ");
INSERT INTO wiv_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ba muri dia ta taru gotalania, na tuni king tavine ia pelea kini pata kara tuna. ");
INSERT INTO wiv_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Dia ka sikulnia a Moses na save laveve ke vuni Isip ia ki lala kete kakatia galanga kapopou ki lala kete vala polea matuha. ");
INSERT INTO wiv_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Tania kana krismas ti vano kini 40, ia lohoia kete balahea kana manumanu a vuni Israel. ");
INSERT INTO wiv_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ia hadavia katiu ni dia na kaka bukuni Isip e huhubia, ia vano kodonia vineka kua, ia hubi matehia na kaka bukuni Isip kua. ");
INSERT INTO wiv_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","A Moses e katia goloa kua ki lohoia habuka kana manumanu dia kata lohoi lala habuka a Vuvu e geria kete vaikoli kiridia, palaka kana manumanu beta dia na hada lala. ");
INSERT INTO wiv_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ti dama mule, a Moses e pe paria na kaka Israel rua hiro ta vavarihubi. Ia parakilania kete talotalo ki tani barae ni hiro, ‘Mo ta varitazini kua; e kuziha mo kene vavarihubi mule?’ ");
INSERT INTO wiv_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Palaka na kaka kua e huhubia ruana kua, e bara katia a Moses ki tani barae kirina, ‘Azei ti taruhiho kunu kara kahita paraha koto popole ni hita? ");
INSERT INTO wiv_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Koto hubi matehiau habuka kua tu hubi matehia na kaka Isip kena ngora?’ ");
INSERT INTO wiv_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Tania a Moses ki longo baraenia, ia hava kiri Midian, kini mia balika kaka karukaruanga ia lahi kini taruhia tuna rua. ");
INSERT INTO wiv_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Krismas e 40 vano ki kakava, na engel ia bele ni Moses na poloka haroho e kalakala na hai kote na poloka deset kozoho na potuna a Sainai. ");
INSERT INTO wiv_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Kamana a Moses ki hadavia na goloa kua, ia ki lohoi tori matoto na goloa kua e hadavia. Tania ki vahere vano kozoho kete hada kemikemihia, ia longoria na Paraha e tani barae, ");
INSERT INTO wiv_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Hau na Vuvu ke habu kapupu, na Vuvu ke Abraham, kamani Aisak hiro a Jekop.’ A Moses ki kuahi matoto livuhana ki vavani, ki kuahi keteni vahada matana. ");
INSERT INTO wiv_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Pale, na Paraha ia tania vona, ‘Hulia ka sadel; na palaka kena tu mamadi vona, ia ti garigari tumonga. ");
INSERT INTO wiv_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Hau kava te hadavia na moge zahazaha kua e kakatua na kagu manumanu ni Isip. Kava te longoria kadia halohoa kene ziho kata vagotalani mulehidia na karabus. Mai, kata geri mulehiho nu vano kiri Isip.’ ");
INSERT INTO wiv_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","A Moses kua hau ta popole vona, ia ia za kua dia ta pole katia dia ka tani barae kirina, ‘Azei ti taruhiho kunu kara kahita paraha koto popole ni hita?’ Ia za a Vuvu ti geria kete kara kadia paraha ni hada ni dia ni peledia dia na gotala na karabus. Na engel kua e bele vona na haroho kua e kalakala na hai kote, ia e kodonia. ");
INSERT INTO wiv_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ia peledia gotala ni Isip ki katia mirakel kapopou luba ni Isip, ia mai ni Retsi, ia mai na krismas e 40 na poloka deset. ");
INSERT INTO wiv_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ia a Moses ngana za kua e tani barae ni vuni Israel, ‘A Vuvu da e geria kana profet katiu balika hau, da e makia na pidaka miu mule.’ ");
INSERT INTO wiv_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ia, ia za kua e kamana manumanu bukuni Israel dia ka lupu na poloka deset. Ia e kamani habu tubudolu kamana engel kua e pole kamana na potuna Sainai, a Vuvu ki vala vona na polea kua kete vala mahuria, ia kete vala polea kua ni mai ni dolu. ");
INSERT INTO wiv_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Palaka habu tubudolu beta matoto ni kulidia dia kata longoria kana polea. Dia te pala katia dia kene vala lamadia kirina, kini kukulidia dia keteni vavamule kiri Isip. ");
INSERT INTO wiv_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Dia ta tania ni Aron, ‘Katia kahita vuvu katiu kua kete vavamuga ni hita. Na vuna ti beta hita ne lala nazia ti bele kiri Moses, na kaka kua e pelehita ka gotala ni Isip!’ ");
INSERT INTO wiv_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Kilangata kena ia kua dia te katia hanunuka bulmakau kote. Dia ta vala opa na hanunuka bulmakau kua dia kene paparau dia kene vavazahenia na hizana goloa kua dia mule ta katia. ");
INSERT INTO wiv_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Palaka a Vuvu ia vala lamana kiridia kini zuka tapunidia dia kene lolotu na voro kamana lingabo ia mai na vitovito kamahi ve. Kubarae na polea kua e vapolunganga na poloka buk kana profet kamahi ia e tani barae, ‘Miu vuni Israel kilaka kua miu ta mia krismas e 40 na poloka deset, miu ka hubi matehia na bulmakau kamana sipsip miu ka opa vona, miu ta vavala opa kamahi kena ni niau, ai? Beta matoto! ");
INSERT INTO wiv_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Miu, na haus sel kena miu ta luluga miu ka lolotu vona, beta ni kagu, ia na haus sel kana vuvu a Molek. Miu ka luluga ve na hanunuka vitovito, kana kamiu vuvu vairukuruku kua a Refan. Ia na hanunukudia kena miu te katia miu kene lolotu ni dia. Kubarae, Hau da ta vaikali kamamiu ka gerimiu miu ka vano mia na garigari kua e pe livutia a Babilon.’ ");
INSERT INTO wiv_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Kilaka kua habu tubudolu kua dia ta mimia na poloka deset, ia na kadia haus sel ke Vuvu vona. Na haus sel kua, ia e vatunga habuka a Vuvu e mimia kamadia. Kilaka kua dia ta habatia na haus sel kua, dia ta haba muria matoto na hanunuka ruma kua a Vuvu e vatunga ni Moses. ");
INSERT INTO wiv_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ba muri, habu tubudolu dia ta pelea na haus sel kua kamadia, a Josua ki vamuga ni dia, dia ka pelea garigari kana manumanu motu. A Vuvu e vaibura manumanu bukuna kantri kamahi kua dia ka pelea. Dia ka vamadiria na haus sel kua na garigari kua ki maimai ki paria na taem ke Devit, ");
INSERT INTO wiv_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","na kaka kua a Vuvu e lala kete kekemi matoto kirina. A Devit ia ki hulenia a Vuvu habuka kete longo ia ni habatia na ruma kemi katiu kua na habu tubuni Jekop dia kata lolotu ni Vuvu vona. ");
INSERT INTO wiv_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Palaka ba muri a Solomon ia ti habatia na ruma ke Vuvu. ");
INSERT INTO wiv_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Palaka, a Vuvu kua ia e heta matoto beta ni lala kete mimia na ruma kua manumanu dia ta hahabatia. Habuka kua na polea kana profet e tania, ");
INSERT INTO wiv_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Na lagato ia na kagu sia king, na vulovulo ia na palaka ta tataruhia kabegu vona. Kubarae, na ruma zia da miu ta habatia kagu? Na palaka kakei hau kata hivu vona? ");
INSERT INTO wiv_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Karae beta hau mule na katia goloa laveve kua?’” ");
INSERT INTO wiv_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","A Stiven ki tani barae na kaunsil kamahi kua, “Miu manumanu kua miu ta manumanuna bikhet. Polokomiu kamana kamiu lohoihoia ti zobo habuka nuhu kua beta dia na lala a Vuvu. Talingamiu ti zobo kini beta miu ne lala miu kata lolongoria na polea ke Vuvu. Dama laveve miu ta gala miu ka papala katia na polea kana Vule Tumonga, habuki habu tubumiu kua varira. ");
INSERT INTO wiv_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Profet kakei varira kua beta habu tubumiu dia na gala zahazaha vona? Beta matoto! Dia ta hubi matehia nuhu kua dia tatani kakava habuka, Na Kakanaka Moge Mahoto da e mai. Na kaka kua ia kava ti mai, miu mule miu kene taruhia na limana hana vagi kamahi miu kene hubi matehia. ");
INSERT INTO wiv_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Miu kua, miu ta pelea na lo na limana engel kamahi, palaka beta miu na mumuri na lo kena.” ");
INSERT INTO wiv_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Kamana na kaunsil kamahi dia ka longo baraenia polea ke Stiven, magalidia ki varithi matoto kirina dia ka hara taduria hazedia kirina. ");
INSERT INTO wiv_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Palaka a Stiven, e vonu na Vule Tumonga, ia tunga vatada kara lagato ia hadavia na glori ke Vuvu, ki hadavia ve a Iesus e mamadi na maroroni limani Vuvu. ");
INSERT INTO wiv_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","A Stiven ki tani barae, “Hadavia, ta hada na lagato e ngapa na Tuna Kaka ki mamadi na maroroni limani Vuvu.” ");
INSERT INTO wiv_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Tania ki tani barae, dia ta goe kapopou matoto dia ka taba porotia talingadia, dia ta rovo vano kirina, ");
INSERT INTO wiv_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","dia ta paho taduria dia ta harehia gotala na taon dia ta lubia na kedo. Na manumanu kua muga dia ta papadea polea kiri Stiven, dia ta taruhia kadia kolos kamahi kozoho na kabena kaka huluvahu katiu hizana a Sol. ");
INSERT INTO wiv_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Dia ta lulubia, a Stiven ia ki lolotu ki tatani barae, “Paraha, Iesus, pelea vulegu.” ");
INSERT INTO wiv_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Pale, ia dua padonia tutura ki goe kapou matoto ki tani barae, “Paraha, tabarae nu kolia moge zaha kua dia ta katia.” Kamana ki tani barae, ia mate. ");
INSERT INTO wiv_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","A Sol ki hadavia goloa kua dia ta katia ni Stiven magalina ki malugunia matoto. Kilaka pamuhi kua dia ta lubi matehia a Stiven, dia ta kati zahatia matoto na manumanu bukuna sios ni Ierusalem dia ka vaikali kamadia dia kene varihavai kara palakalaka laveve na distrik ni Iudea kamani Samaria. Palaka na apostel kamahi dia ta ma mimia ni Ierusalem. ");
INSERT INTO wiv_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Manumanu taza kua dia ta lala dia kata mumuri papa na lohoihoia kua a Vuvu e lala kete kukulina kirina, dia ta tavunia a Stiven dia ka tangi matehia matoto a Stiven. ");
INSERT INTO wiv_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Palaka a Sol ia ti gala kini vavairohia manumanu na sios. E hohoria ruma katiukatiu, ki hare gotalania tamomohane ia mai tavivine ve ki taruhidia na karabus. ");
INSERT INTO wiv_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Nuhu kua dia ta bura katiutiu kara malala laveve, dia te kakalohunia na Kalohua Kemi na palaka laveve kena dia ta bele vona. ");
INSERT INTO wiv_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","A Filip ia e ziho kara taon katiu ni Samaria ki tani kakava na hizani Kristus vona. ");
INSERT INTO wiv_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Tania na kabuna manumanu dia ka longoria polea ke Filip, dia ka hadavia na mirakel kamahi kua ia e kakatia, dia ka tabu longo papa matoto kara kana polea. ");
INSERT INTO wiv_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Vule zaha kamahi dia ta gigi hania livuhadia dia ka gogotala na manumanu luba, nuhu livuhadia kamana kabedia e matemate dia ta kemikemi mule, nuhu kua palaka katiu na livuhadia e zaha ia dia ta kemikemi mule ve. ");
INSERT INTO wiv_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Kubarae manumanu na poloka taon kua dia ka hilohilo matoto. ");
INSERT INTO wiv_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Na kaka katiu na taon kua hizana a Saimon. Ia e lai muli ki lala kete kakatia haihaia ki lala kete kokoli ki lala kete kakatia goloa luba, manumanu ni Samaria dia ka lala dia kata hadavia dia ka lala dia kata kukuahinia. Ia ki lala kete vavazahezahenia hizana, ");
INSERT INTO wiv_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","manumanu laveve, nuhu kua dia ta hizanga ia mai manumanu vetavetanga, dia ta lala dia kata hahada zahenia dia ka tatani barae kirina, “Kaka kuari ia na matuhanga ke Vuvu kua e kohanga na matuhanga kapou, ia na kaka kua.” ");
INSERT INTO wiv_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Dia ka lala dia kata mumuri na kana polea na vuna ia e lala kete kakatia goloaloa kamahi kua beta dia na lala dia kata hahadavia varira ki bebele dia ka lala dia kata zizipa zahe vona. ");
INSERT INTO wiv_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Palaka kamana dia ka bilip na polea ke Filip kua ia e kakalohunia na Kalohua Kemi na kingdom ke Vuvu ia mai na hizani Iesus Kristus, dia ta pelea baptais, dia tamomohane kamani tavivine ve. ");
INSERT INTO wiv_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","A Saimon ve ia e bilip kini pelea baptais. Ia kini mumuri ni Filip kara palaka laveve a Filip e vano kirina. Ia ki hadavia na mirakel kapopou kua a Filip e kakatia ia ki zipa zahe matoto. ");
INSERT INTO wiv_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Tania na apostel kamahi ni Ierusalem dia ka longoria habuka na manumanu ni Samaria dia te pelea na polea ke Vuvu, dia ta geria a Pita hiro a Jon vano ni dia. ");
INSERT INTO wiv_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Hiro ta vano bele, hiro ta lotu kiridia habuka dia kata pelea na Vule Tumonga, ");
INSERT INTO wiv_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","na vuna na Vule Tumonga ma beta ni mai na katiu ni dia; muga dia ta pelea baptais na hizana Paraha a Iesus za. ");
INSERT INTO wiv_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Pale, a Pita hiro a Jon hiro ta taruhia limahiro ni dia, dia ta pelea na Vule Tumonga. ");
INSERT INTO wiv_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Tania a Saimon ki hadavia na apostel karua kua hiro ta taruhia limahiro na manumanu dia ka pelea na Vule Tumonga, ia pelea moni mai kete vala ni hiro, ");
INSERT INTO wiv_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ki tania, “Mo vala ve ni niau na matuhanga kena. Hau ve kata taruhia limagu na manumanu ve dia na pelea na Vule Tumonga.” ");
INSERT INTO wiv_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","A Pita ki tani barae vona, “Paleka ho kamana ka moni mo na paria zahatanga, na vuna tu lohoia da tu kadea na presen ke Vuvu na moni? ");
INSERT INTO wiv_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Beta magali ni mahoto na matani Vuvu. Kubarae ki mara beta nu mia kamahita na poloka galanga ke Vuvu kua hita ta kakatia. ");
INSERT INTO wiv_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Pokizia magali nu vala lama kara ka lohoihoia zaha kena tu kakatia. Lotu na Paraha nu hulenia kete lohoi bala na lohoihoia zaha kena na poloko. ");
INSERT INTO wiv_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Na vuna hau ta hadavia habuka poloko e vonu matoto na lohoi zahazahanga, na moge zahazaha ki karabusniho ve.” ");
INSERT INTO wiv_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Pale, a Saimon ia tania, “Mo lotu kirigu na Paraha, kete beta goloa zaha kena mo ta tatania kete bele kirigu.” ");
INSERT INTO wiv_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pale, na apostel karua kua hiro ta tania na polea kana Paraha ni dia, hiro ka tania ve na goloa kua na Paraha e katia ni hiro. Pale, a Pita hiro a Jon hiro ta vavana vamule kiri Ierusalem, kilaka kua hiro ta vavana hiro ka vavamule, hiro ta kalohunia na Kalohua Kemi na malala luba ni Samaria. ");
INSERT INTO wiv_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Na engel kana Paraha katiu e tani barae ni Filip, “Vano na dala na bagena tolo kiri saut, na dala na poloka deset, kena e pe ni Ierusalem ki ziho kiri Gasa.” ");
INSERT INTO wiv_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Pale, a Filip ia divurutia kini vavana, e vavana vano, ia paria na kaka katiu bukuni Itiopia, kaka kua ia na paraha katiu na gavman ke Kandasi na Kwin kiri Itiopia ki hada na moni laveve kana Kwin kua. E vatomutomuha ve kelena kaka kua. Kaka kua ki zahe kiri Ierusalem kete lotu. ");
INSERT INTO wiv_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Na kana vamulea ia e mimia na huduna kana karis, ki hahazenia na buk ke profet Aisaia. ");
INSERT INTO wiv_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Na Vule Tumonga ki tani barae ni Filip, “Vano ho tu vana kozohotia na karis kuari.” ");
INSERT INTO wiv_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Pale, a Filip ia rovo zahe na kitaka karis kua ia longoria na kaka kua e hazenia na buk ke profet Aisaia, ia hulenia, “Tu lohoi lala nazia kena tu hahazenia?” ");
INSERT INTO wiv_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Na kaka kua ki tani barae, “Kata lala zingania, kua ta beta kaka katiu ni vaketekete ni niau vona?” Pale, ia hulenia a Filip kete polo ni mia kamana na huduna karis. ");
INSERT INTO wiv_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Na kaka kua e hazenia na polea kua e vapolunganga na poloka buk Ke Vuvu kua e tani barae, “E vamurua balika sipsip kua kete hubu matoa, habuka tuna sipsip kua kete titira vuluka, ki beta ni vukazia havana ni pole o ni haloho. ");
INSERT INTO wiv_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Dia ta hilenia matoto dia ka vansaet kirina na kotoa, kubarae ki beta vidirika kua manumanu kete tani polea ni dia na goloa kua e bele vona, beta. Dia ta hubi matehia, kini beta ni ma mimia na vulovulo.” ");
INSERT INTO wiv_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Na kaka kua ki hulenia a Filip, “Tania ni niau, azei matoto kua na profet e popole vona, e popole vona mule o e popole na kaka motu katiu?” ");
INSERT INTO wiv_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Pale, a Filip ia vaketekete na kaka kua. Muga ki tani kakava na mining na polea kua na kaka kua e hahazenia. Ba muri ia tani kakava ve na Kalohua Kemi na vuna ni Iesus. ");
INSERT INTO wiv_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Dia ta lilia dala ziho, dia ta bele na naru katiu. Na kaka kua ia tania, “Hadavia, naru kua. Mara beta nu vala baptais ni niau ri kua, beu nazia ba vovona kata katia?” ");
INSERT INTO wiv_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Pale, ia tania na nuhu kua dia ta rorovongania kana karis dia ta pati. Pale, hiro a Filip hiro ta ziho kara naru a Filip ia vala baptais vona. ");
INSERT INTO wiv_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Dia ta vatia na naru dia ka vamule, na Vule Tumonga kana Paraha ia pelea a Filip, na kaka kua kini beta ni hadavia ve a Filip. Palaka ia e hilohilo matoto kini vavazahenia a Vuvu kini vano kara kana malala. ");
INSERT INTO wiv_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","A Filip ti ridi ti bele ni Asdot, pale, ia kini vavana lobia malala kua kini vavaketekete na Kalohua Kemi na taon kamahi ia, ia ki bele ni Sisaria. ");
INSERT INTO wiv_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Kilaka kua ve, a Sol ia ba vavakuahinia na disaipel kamahi kana Paraha ki tatania habuka kete vaihubi mate kamadia. Pale, ia zahe bele na hetpris, ");
INSERT INTO wiv_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ia hulenia kete vapolungania na pas katiu kete pelea ni vano na haus lotu kamahi ke vuni Iuda ni Damaskus, na leta kua kete tania habuka kua, a Sol ni paria kaka katiu kua e mumuri na dala ke Iesus, ia da e paho taduria ki pelea ki zahe kiri Ierusalem kete karabusnidia. ");
INSERT INTO wiv_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Pale, ia vatia a Ierusalem ia vavana kiri Damaskus. Tania e vano ki kokozoho ni Damaskus, na laet kapou matoto katiu bukuna lagato e valutuhia ki balanga lobia. ");
INSERT INTO wiv_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ia dua kara garigari ki longoria na halinga katiu e tani barae vona, “Sol, Sol, e kuziha ku vavairohiau?” ");
INSERT INTO wiv_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","A Sol ki hule, “Paraha, Ho azei?” Na halinga kua ki tani barae, “Hau a Iesus, kaka kua tu gala ku kakati zahatia vona. ");
INSERT INTO wiv_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Kua madi ho tu vano hoho na poloka taon kapou. Da kaka katiu e tania ni niho nazia koto katia.” ");
INSERT INTO wiv_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Manumanu kua dia ta vavana lupu kamani Sol, dia ta ma madi beta katiu ni dia ni pole; dia ta longoria na halinga kua, palaka beta dia na hada kaka katiu. ");
INSERT INTO wiv_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","A Sol ia lama na garigari, palaka tania e vukazia matana ti mara beta ni hada goloa katiu. Kubarae dia kene pahoria limana dia kene pelea ziho kiri Damaskus. ");
INSERT INTO wiv_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Na dama tolu matana e keu, ki beta ni hanihani beu hinumia goloa katiu. ");
INSERT INTO wiv_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Na disaipel katiu ni Damaskus hizana a Ananias. E manginunginu ki hadavia na Paraha e koi kirina ki tani barae, “Ananias!” A Ananias ki tara ki tani barae, “Hau kua Paraha!” ");
INSERT INTO wiv_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Na Paraha ki tani barae vona, “Vano kara ruma ke Iudas na palaka kua e kohanga na ‘Dala mahoto’ ho tu hule kara kaka katiu bukuni Tarsus hizana a Sol, ia me e lolotu ki mimia. ");
INSERT INTO wiv_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Na manginunginua kava ti hadavia habuka kaka katiu hizana a Ananias da e mai vona ki taruhia limana vona matana ki kemi mule.” ");
INSERT INTO wiv_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","A Ananias ki tania, “Paraha, hau te longoria na polea luba na kaka kena kamana kana galanga zahazaha laveve kua e kakatia na ka manumanu ni Ierusalem. ");
INSERT INTO wiv_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ia e mai ri kua kamana pas kana hetpris kua e vala matuhanga vona kete paho taduria manumanu laveve kua dia ta lala dia kata lolotu na hiza.” ");
INSERT INTO wiv_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Palaka na Paraha ki tania ni Ananias, “Vano! Na Kaka kena te makia kete katia kagu galanga. Te makia kete vano na manumanu motu kamana king kamahi ia mai ni vuni Israel ve, kete tani kakava hizagu ni dia. ");
INSERT INTO wiv_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Hau kata vatunga vona na bizea kua ia kete luga, kua ta ia ni tatani kakava hizagu na manumanu.” ");
INSERT INTO wiv_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Pale, a Ananias ia vavana vano ia hoho na ruma kua. Ia taruhia limana na huduni Sol, ia tani barae, “Tai Sol, na Paraha a Iesus, kaka kua e bele ni niho na dala kua tu pe vona ku mamai, ia e geriau kata mai ni niho koto hada mule na Vule Tumonga kete vonu ve ni niho.” ");
INSERT INTO wiv_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Na goloa katiu balika kovuka hiha ia dua na matana karua, pale, matana ia kemi mule. Ia madi ia pelea baptais, ba muri ia hanihani livuhana kini bada mule. A Sol e mia dama taza kamana disaipel kamahi ni Damaskus. ");
INSERT INTO wiv_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ba muri vona, ia vano pamuhi za kara haus lotu kamahi ke vuni Iuda kini vavaketekete ni dia, habuka a Iesus ia na Tuni Vuvu. ");
INSERT INTO wiv_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Manumanu laveve kua dia ta longoria dia ta ridi matoto dia ka varihulei, “Karae beta ni ia na kaka kua e lala kete gagala zahazaha matoto na manumanu ke Iesus ni Ierusalem? Karae beta ni mai ri kua, kete paho taduridia ni karabusnidia, ni peledia vano na kadia hetpris?” ");
INSERT INTO wiv_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Palaka a Sol ia ti dopa kini matuha matoto, ia ki vakete kemikemihia matoto ni vuni Iuda ni Damaskus ki vatunga kavakava habuka a Iesus, ia na kaka kua a Vuvu e makia kete pele mulehia kana manumanu. A vuni Iuda dia ka longoria kana polea ki mara beta dia na gegea kana polea. ");
INSERT INTO wiv_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Muri na dama luba ti kakava, a vuni Iuda dia ta lupu dia ta taru lupunia kadia polea dia kata hubi matehia a Sol, ");
INSERT INTO wiv_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","palaka a Sol ti lala horuhoruvia kadia polea. Dama, marigo dia ta ma tatarengania na geit kamahi kara taon dia kata hubi matehia. ");
INSERT INTO wiv_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Palaka na marigo na disaipel kamahi ke Sol, dia ta pelea zahe kara huduna banis kua e lobia na taon dia ta vamiania na poloka kolopi kapou katiu, dia ta vazihonia ziho na paligena banis kara hatamara taon. ");
INSERT INTO wiv_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","A Sol ia vamule kiri Ierusalem, ia parakilania kete lupu kamana disaipel kamahi, palaka dia ta kuahinia, beta dia na bilip habuka ia matoto ti kara disaipel katiu. ");
INSERT INTO wiv_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Palaka a Barnabas ia pelea a Sol vano na apostel kamahi. Ia tania ni dia na goloa kua e bele ni Sol kilaka kua ia e vavana kiri Damaskus, ia ki hadavia Paraha, na Paraha ki pole kamana. A Barnabas ki tania ve na apostel kamahi ve kua a Sol e bada matoto kete tani kakava na hizani Iesus ni Damaskus. ");
INSERT INTO wiv_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Pale, a Sol ia mia kamadia kini vana vetaveta ni Ierusalem, kini beta ni kuahi kete tani kakava hizana Paraha. ");
INSERT INTO wiv_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","E pole ki vaigege kamani vuni Iuda kua dia ta lala dia kata popole Grik, palaka dia ta tania dia kata hubi matehia. ");
INSERT INTO wiv_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Tania na habu tazina na Paraha dia ka lala horuhoruvia goloa kua, dia ta pelea ziho kiri Sisaria dia ta geria ia vano kiri Tarsus. ");
INSERT INTO wiv_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Kubarae na sios laveve ni Iudea, ni Galili ia mai ni Samaria dia ta mia valugu, na vuna ti beta kaka ni ma vavairohidia. Kubarae na sios kini bada, na Vule Tumonga e vabadangania na sios, manumanu luba kini mai hoho na sios, dia ka lala dia kata hahada zahenia na Paraha. ");
INSERT INTO wiv_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","A Pita e vavana lobia na palaka laveve, ia vano kete balahea na manumanu ke Vuvu ni Lida. ");
INSERT INTO wiv_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ni Lida ia paria na kaka katiu hizana a Ainias, na togana e matemate ki ngongoro za na kiri na krismas e 8. ");
INSERT INTO wiv_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","A Pita ki kohania ki tani barae, “Ainias, a Iesus Kristus ti kati kemihiho. Madi nu didia ka dongi.” Kamana a Pita ki tani barae vona, a Ainias ia divurutia ia madi pamuhi. ");
INSERT INTO wiv_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Manumanu laveve kua dia ta mimia ni Lida ia mai ni Saron dia ta hadavia na goloa kua e bele na kaka kua, dia ka bilip laveve na Paraha, dia ka pokizia magalidia. ");
INSERT INTO wiv_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ni Jopa, na disaipel katiu vona hizana a Tabita, na polea Grik dia ta kohania ni Dokas. Tavine kua dama laveve e lala kete kokodonia ki lala kete kakati kemihia na nuhu kua beta kadia goloaloa vona. ");
INSERT INTO wiv_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Kilaka kua e mazahitia, ia mate, dia ta vazuguvia podana dia ta vangorea na rum ngoro langa na poloka ruma. ");
INSERT INTO wiv_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Malala kua a Lida, ia kozoho ni Jopa; na disaipel kamahi dia ta longoria habuka a Pita ia ni Lida, dia ta geria tamohane rua hiro ta vano virivirinia hiro ka tani barae, “Baribari nu mai kamamiro, taua nu kogoi!” ");
INSERT INTO wiv_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","A Pita ia vano kamahiro, dia ta kohania hoho ia papane kara rum na huduna ruma. Na gabugabu laveve dia ta madi lobia a Pita, dia ka tatangi dia ka vavatunga ni Pita na zohozohoa laveve kua a Dokas e katikati kilaka kua ia e ba mamahuri ki ba mimia kamadia. ");
INSERT INTO wiv_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","A Pita ia geridia laveve dia kata gotala na rum; pale, ia padonia tutura ia lotu. Pale, ia tare vano kara podana tavine kua, ia tani barae, “Tabita, lama.” Na tavine kua ia vahada matana, tania ki hadavia a Pita, ia lama ia mia. ");
INSERT INTO wiv_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","A Pita ia pahoria limana ia vamadiria. Pale, ia koi kara nuhu kua dia ta bilip ni Iesus kamana tavivine gabugabu kamahi kua, ia vatunga ni dia habuka a Tabita ti mahuri mule. ");
INSERT INTO wiv_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Manumanu laveve ni Jopa dia ta lala laveve na goloa kua e bele, kubarae manumanu luba dia kene bilip na Paraha. ");
INSERT INTO wiv_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","A Pita ki mia havarau pitu ni Jopa kamana kaka katiu hizana a Saimon. Kaka kua e lala kete pelea na hulita bulmakau kamahi ki lala kete vavaida kua kete kakatua goloa luba vona. ");
INSERT INTO wiv_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Na taon kapou a Sisaria na kaka katiu hizana a Kornilius, na kepten kua e hada na 100 soldia kamahi. Ia e bukuna kabuna soldia kamahi kua e kohanga dia na soldia bukuni Itali. ");
INSERT INTO wiv_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","A Kornilius kamana kana famili laveve dia ta nuhuta lotua matoto, dia ka lala dia kata mumuri papa na lohoihoia ke Vuvu, dia ka lala dia kata kokodonia nuhu kua beta kadia goloaloa vona. ");
INSERT INTO wiv_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Na dama katiu na 3 kilok na garavi e hada na visen katiu. E hada matotonia na engel katiu ke Vuvu, e bele vona ki tani barae vona, “Kornilius!” ");
INSERT INTO wiv_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","A Kornilius ki hadavia ki kuahi matoto. Ia ki hulenia, “Paraha, tu tani ziha?” Na engel ki tani barae, “A Vuvu ti longoria ka lotua ki lohoia ve ka galanga kua tu lala koto vavala goloaloa na manumanu kua beta kadia goloaloa vona, a Vuvu ki kulina matoto kara ka moge kua. ");
INSERT INTO wiv_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Kua geria manumanu taza dia na vano kara taon a Jopa dia na kohania kaka katiu hizana a Saimon, hizana katiu ve, a Pita. ");
INSERT INTO wiv_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ia me mimia kamani Saimon, na kaka kua e lala kete pelea na hulita bulmakau kamahi ki lala kete vavaida kua kete kakatua goloa luba vona, kana ruma e kozoho na vazalea.” ");
INSERT INTO wiv_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Tania na engel kua e popole kamana ki vatia, a Kornilius ia kohania kana vora rua kamana kana soldia katiu. Na soldia kua ia na kakanaka lotua ia ki lala kete kakamani Kornilius na dama laveve. ");
INSERT INTO wiv_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ia tania ni dia na goloa laveve kua e bele vona, pale, ia geridia kiri Jopa. ");
INSERT INTO wiv_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Nuhu kua a Kornilius e geridia dia ka vavana, dia ta vano dia ka ngoro na dala ki dama, dia ta vavana mule ti habuka ti belo barae dia te kokozoho na taon kapou, ia na taem kua matoto, a Pita ve ia papane kara huduna ruma kete lotu. ");
INSERT INTO wiv_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Pale, ia hatunia ti vitolonia, ki kulina ma kete hania goloa katiu, pale, tania dia ka ba vavaida haninga barae kete hania, ia hadavia na visen katiu. ");
INSERT INTO wiv_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","E hadavia na lagato e vukaza ia hadavia na goloa katiu balika bolana lavalava kapou. Na goloa katiu ki zazaraha na hirihiripa lavalava kua ki vazihonia ki ziziho. ");
INSERT INTO wiv_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Na huduna lavalava kua na enimel laveve kua kabedia e garamo, ia mai na goloaloa kamahi kua na taloa, na matabunu, na vuha kamahi kamana manu kamahi kua dia ta lala dia kata bebe na mariaba. ");
INSERT INTO wiv_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Pale, na halingana kaka katiu ia tani barae vona, “Pita, lama, hubi matehia nu hania.” ");
INSERT INTO wiv_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","A Pita ki tania, “Paraha, mara beta matoto! Hau ma beta matoto na hania goloa katiu kua e beta ni klin na mata, kua ku tabunihita ve vona beta hita kata hahania.” ");
INSERT INTO wiv_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Na halingana kaka kua ki pole mule ve ki tani barae vona, “Goloa kua a Vuvu ti katia kini klin, tabarae nu tania e beta ni kemi.” ");
INSERT INTO wiv_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Na poloka visen kua, na goloa kua e bele boto tolu, pale, na lavalava kua ia harehi mulehi tapuanga ia zahe kara lagato. ");
INSERT INTO wiv_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","A Pita ki ba lolohoi nanazia na visen kua kete paria na mining vona, na manumanu kua a Kornilius e geridia, dia te hule kara ruma ke Saimon, kini vatunganga ruma ke Saimon ni dia, dia kene mai madi na hatama, na geit. ");
INSERT INTO wiv_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Dia ta koi, dia ka hule, habuka a Saimon Pita ia e mimia na ruma kua o beta. ");
INSERT INTO wiv_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","A Pita ia e ba lohoihoi na visen kua, na Vule Tumonga ia tania vona, “Saimon, manumanu tolu dia ta kakaze kiriniho. ");
INSERT INTO wiv_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Madi nu zipa ziho ni dia. Ho tu kamadia, tabarae nu lohoi ruarua, na vuna Hau ta geridia.” ");
INSERT INTO wiv_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","A Pita ia zipa ziho ia hulenidia, “Hau na kaka miu ta hahada kirina kua. E kuziha miu ka mai?” ");
INSERT INTO wiv_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Dia ka tani barae, “A Kornilius kahita kepten kara 100 soldia, e gerihita, hita ka mai. Ia na kaka pa ki mahoto na matani Vuvu, manumanu laveve bukuni Iuda dia ka lala dia kata hahada zahenia. Na engel tumonga katiu e tania vona habuka kete koi kiriniho nu vano kara kana ruma kete longoria nazia koto tania vona.” ");
INSERT INTO wiv_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Pale, a Pita ia koi taduridia kara ruma, ia hada poto ni dia. Ti dama, ia kamadia dia kene lupu vano, manumanu taza bukuni Jopa kua dia ta bilip ni Iesus, dia ta kamadia ve. ");
INSERT INTO wiv_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","A Pita kamana nuhu kua dia ta vavana vano dia ka ngoro na dala ki dama dia ta vano bele ni Sisaria. A Kornilius e lala habuka da dia ta lohu kubarae ia kini koi lupunia habu vineka laveve kamani habu kurakurana dia kene lohu laveve. ");
INSERT INTO wiv_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Tania a Pita ki pe hoho na ruma, a Kornilius ia dua kara kabeni Pita ki ruru matoto vona. ");
INSERT INTO wiv_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","A Pita ia pahoria ia vamadiria, ki tani barae vona, “Madiri, hau ve na kaka vetanga za kua.” ");
INSERT INTO wiv_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","A Pita ki popole kamani Kornilius, hiro kene vavana hoho kara poloka ruma, ia hadavia na kabuna manumanu kapou na poloka ruma. ");
INSERT INTO wiv_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ia tania ni dia, “Miu ta lala laveve habuka kahita lo e vatabunihita a vuni Iuda habuka beta hita kata vano babalahea o mimia lupu kamana manumanu kua beta dia na lala a Vuvu. Palaka a Vuvu ti vatunga ni niau habuka beta kata hadavia kaka katiu na tania habuka beta ia ni klin o a Vuvu e tabuniau beta kata kakamana. ");
INSERT INTO wiv_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Kubarae, tania ka geu kirua, hau ta vavana pamuhi za, beta na hava. Kubarae kata hulenimiu, nazia matoto miu ta geu kirigu vona?” ");
INSERT INTO wiv_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","A Kornilius ki tania, “Na dama tolu ti vano na taem kua nina matoto hau ta lolotu, na 3 kilok na poloka kagu ruma, hau ta hadavia na kaka katiu e madi na mugagu, na livuhana kamana kana loholohoa e kalageru, ");
INSERT INTO wiv_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ia ki tani barae ni niau, ‘Kornilius, a Vuvu ti longoria ka lotua ki lohoia ve ka galanga kua tu lala koto vavala goloaloa na manumanu kua beta kadia goloaloa vona. ");
INSERT INTO wiv_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Vala polea vano kiri Saimon Pita ni Jopa. Ia me mimia kamani Saimon, kaka kua e lala kete pelea na hulita bulmakau kamahi ki lala kete vavaida kua kete kakatua goloa luba vona, kana ruma e kozoho na vazalea.’ ");
INSERT INTO wiv_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Pale, hau ta geu pamuhi kiriniho, hau ka hate motuniho kua tu mai. Meni kua, kua hita ta lupu laveve na matani Vuvu, hita kata longoria nazia matoto na Paraha e geriho koto tania ni hita.” ");
INSERT INTO wiv_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pale, a Pita ia pole ki tani barae, “Meni kua hau te hada lala matotonia pebarae, a Vuvu beta ni lala kete kukulina pati kara manumanu taza za, ");
INSERT INTO wiv_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","beta, a Vuvu ia e lala kete kukulina kara manumanu na poloka kantri laveve kua dia ta kukuahinia dia ka mumuri na lohoihoia kua e mahoto. ");
INSERT INTO wiv_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Miu ta lala na polea kua a Vuvu e vala ki mai ni hita manumanu bukuni Israel. Na Kalohua Kemi kua, a Vuvu ia e tania habuka a Iesus Kristus, ia na Paraha kana manumanu laveve, a Iesus ki lala kete kakatidolu tolu na mia papa kamani Vuvu. ");
INSERT INTO wiv_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Miu ta lala nazia kua e bele na malala laveve ni Iudea, varivuvu ni Galili, muri na vaketeketea ke Jon kua ia e tania habuka manumanu dia kata pelea baptais, ");
INSERT INTO wiv_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","miu ka longoria ve kua a Vuvu ti makia a Iesus bukuni Nasaret, ki vavonuhia na Vule Tumonga ki vala matuhanga kapou matoto vona. A Iesus ki vavana ki kati kemihia na manumanu ki pele gotalania vule zaha na manumanu kua a Satan e holiholidia, na vuna a Vuvu ia e kakamana. ");
INSERT INTO wiv_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Hita ka hadavia matoto na matahita goloa laveve kena ia e kakatia na kantri ke vuni Iuda ia mai ni Ierusalem. Dia ta havenia na hai dia ka hubi matehia, ");
INSERT INTO wiv_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","palaka a Vuvu ia valamari mulehia na matea muri na dama tolu, ki vatunga kavakava na manumanu dia ka hadavia. ");
INSERT INTO wiv_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Beta manumanu laveve dia na hadavia, palaka hita nuhu kua muga a Vuvu ti makihita hita kata hadavia hita na tani kakava. Pale, kilaka kua ia e mahuri mule, hita ta hanihani hita ka hinu kamana. ");
INSERT INTO wiv_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ia ki tani vatuharia ni hita habuka hita kata tani kakava kana polea na manumanu, hita kata kavakavania habuka ia, a Vuvu e makia kete kara jas ni longoria kotoa kana manumanu kua dia ta ba mamahuri ia mai nuhu dia te varimateai kava. ");
INSERT INTO wiv_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Na profet laveve dia ta tani kakava polea ni Iesus dia ka tani barae, na hizana kaka kua nina za, ia da a Vuvu e lohoi bala manaunaua kana manumanu laveve kua dia ta bilip vona.” ");
INSERT INTO wiv_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","A Pita e ba popole na polea kamahi kua, na Vule Tumonga ia vonu na manumanu laveve kua dia ta lolongoria kana polea. ");
INSERT INTO wiv_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Na disaipel kamahi kua bukuni vuni Iuda kua dia ta kamani Pita dia ka mai, dia ta zipa zahe matoto habuka a Vuvu ti vala ve na presen kana Vule Tumonga na manumanu kua beta dia na bukuni Iuda, ");
INSERT INTO wiv_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","na vuna dia te longoria habuka kua dia te popole na pole matotoa kana manumanu motumotu, dia kene vavazahenia a Vuvu. Pale, a Pita ia tani barae, ");
INSERT INTO wiv_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Manumanu kua dia te pelea na Vule Tumonga balika tolu, azei da ti vatabunidia kete beta dia kata pelea baptais na naru habuka tolu ta pelea baptais?” ");
INSERT INTO wiv_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Pale, a Pita ia geu dia ta vala baptais ni dia na hizani Iesus Kristus. Pale, na manumanu dia ta baptais hozo, dia ta hulenia a Pita kete mia dama taza ve kamadia. ");
INSERT INTO wiv_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Na apostel kamahi ia mai nuhu kua dia ta bilip ni Iudea dia te longoria habuka nuhu kua beta dia na lala a Vuvu, dia te pelea ve na polea ke Vuvu. ");
INSERT INTO wiv_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Kubarae, a Pita ia vamule zahe ni Ierusalem, na disaipel kamahi kua dia ta ba babada na makina vatomutomua dia ta pole kirina, ");
INSERT INTO wiv_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","dia ka tania, “Ho kua tu vano hoho na ruma kana nuhu kua beta ni vatomutomuhadia, ku hanihani kamadia.” ");
INSERT INTO wiv_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Pale, a Pita ia tania ni dia na goloa laveve kua e bele vona. Ia e tani barae, ");
INSERT INTO wiv_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Hau ta mimia na taon kapou a Jopa ka lolotu, hau ta hadavia na visen katiu, ta hadavia, na goloa katiu e balika lavalava kapou matoto katiu e ziziho, na goloa katiu ki pahoria na hirihiripa lavalava kua ki vazihoanga na lagato ki ziziho, na goloa kua ki ziho ni niau. ");
INSERT INTO wiv_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ka tunga papa kara poloka lavalava kua, hau ta hadavia na enimel kamahi kua manumanu dia ta lala dia kata hahada poto vona ia mai na enimel kamahi kua bukuna mugomugo, ia mai na goloaloa kamahi kua na taloa, na matabunu, na vuha kamahi kamana manu kamahi kua dia ta lala dia kata bebe na mariaba. ");
INSERT INTO wiv_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Hau ka longoria na halingana kaka katiu e tani barae ni niau, ‘Pita, madiri, nu hubi matehia nu hania.’ ");
INSERT INTO wiv_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Hau ka tani barae, ‘Paraha, mara beta matoto! Hau ma beta matoto na hania goloa katiu kua e beta ni klin na mata, kua ku tabunihita ve vona beta hita kata hania.’ ");
INSERT INTO wiv_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Na halingana kaka kua na lagato e pole mule ve ki tani barae ni niau, ‘Goloa kua a Vuvu ti katia kini klin, tabarae nu tania e beta ni kemi.’ ");
INSERT INTO wiv_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","E boto tolu goloa kua e bele, ba muri ia hare muleha lavalava kua zahe mule kara lagato. ");
INSERT INTO wiv_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Kamana na goloa kua e bebele ni niau, na kaka tolu e geura dia, dia ka pe ni Sisaria dia ka mai dia kata hada kirigu, dia te bele na ruma kua hau ta mimia vona. ");
INSERT INTO wiv_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Na Vule Tumonga ki tania ni niau habuka beta kata lohoi ruarua habuka kua kata kamadia. Habu tazidolu bukuni Jopa kua dia ta bilip ni Iesus, dia e 6, kua dia ta kamaniau hita ka lupu vano hoho na ruma kana kaka kua. ");
INSERT INTO wiv_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Na kaka kua ki tania ni hita kua habuka kua ia e hadavia na engel e bele vona na kana ruma ki tani barae vona, ‘Geu kiri Saimon kaka kua e kohanga ve ni Pita ni Jopa ni mai. ");
INSERT INTO wiv_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ia da e vala ni miu na Kalohua kua kete katia a Vuvu ni vaikoli kiriniho kamana manumanu laveve na ka ruma.’ ");
INSERT INTO wiv_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Tania ka ba varivuvunia kagu polea barae, na Vule Tumonga ia vavonuhidia balika za kua e bele varivuvu ni dolu. ");
INSERT INTO wiv_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Pale, hau te lohoi mulehia na polea kana Paraha kua ia e tani barae, ‘A Jon ia e vala baptais ni miu na naru, palaka miu da miu ta pelea baptais na Vule Tumonga.’ ");
INSERT INTO wiv_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Kubarae, kua a Vuvu ni vala presen kana Vule Tumonga ni dia habuka kua ia e vala ni dolu, nuhu kua tolu ta bilip ni Iesus Kristus, hau azei kua kata tania habuka a Vuvu beta kete katia goloa kua?” ");
INSERT INTO wiv_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Kamana dia ka longoria na polea ke Pita, pale, beta ve dia na ma popole. Beta, dia te vazahenia a Vuvu, dia ka tani barae, “Kua tolu te lala, a Vuvu ti vatia manumanu kua beta dia na lala a Vuvu, dia kene pokizia magalidia dia kene tare poki dia kene zuka tapunia kadia moge zahazaha, dia kene pelea mahuria.” ");
INSERT INTO wiv_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Nuhu kua dia ta varihavai kilaka kua e hubu matoa a Stiven dia ka bura katiukatiu, dia ta varihavai dia ka bele ni Fonisia, ia mai na ailan a Saiprus kamani Antiok dia kene kakalohunia na Kalohua Kemi ni Iesus ni vuni Iuda za kua dia ta lololi na palakalaka kamahi kua. ");
INSERT INTO wiv_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Palaka, taza ni dia, nuhu kua bukuni Saiprus kamana taon a Sairini, dia ta vano kiri Antiok dia kene popole ve kamana nuhu kua beta dia na lala a Vuvu, dia kene tatania ni dia na Kalohua Kemi na Paraha a Iesus. ");
INSERT INTO wiv_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Dia ta vano kamana matuhanga kana Paraha, kubarae manumanu luba dia ka bilip dia kene kara disaipel kana Paraha. ");
INSERT INTO wiv_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Tania dia manumanu na sios ni Ierusalem dia ka longoria polea na goloa kua, dia ta geria a Barnabas kiri Antiok. ");
INSERT INTO wiv_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","A Barnabas ki bele ni Antiok ki hadavia habuka e limoha a Vuvu ti kati kemihia matoto ni dia, kubarae ia kini hilohilo, kini vabadanganidia, dia kata muri papa na Paraha dama laveve. ");
INSERT INTO wiv_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","A Barnabas ia na kaka mata muli, ki vonu na Vule Tumonga kana bilip ki matuha matoto, kubarae manumanu luba matoto dia kene mai hoho na kabu kana Paraha. ");
INSERT INTO wiv_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ba muri na kua a Barnabas ia vano kiri Tarsus kete kaze kiri Sol, ");
INSERT INTO wiv_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","e paria a Sol, ia kohania hiro ta vamule kiri Antiok. A Barnabas hiro a Sol hiro ta mia krismas katiu hiro ka gala kamana sios ni Antiok hiro ka vaketekete na manumanu luba matoto. Na disaipel kamahi, e muga ki valanga na hiza kua “Kristen” ni dia ni Antiok. ");
INSERT INTO wiv_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Kilaka kua ve na profet taza dia ta pe ni Ierusalem dia ka ziho kiri Antiok. ");
INSERT INTO wiv_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Katiu ni dia hizana a Agabus, ia e madi kamana matuhanga kana Vule Tumonga, ia tania habuka, da na vitolo kapou e bele na palaka laveve na garigari. (Na vitolo kapou kua ki bele na taem kua a Sisar Klodus e king.) ");
INSERT INTO wiv_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Kubarae na disaipel kamahi, katiukatiu ni dia, e vala moni kua ia e dangea kete vala, dia kata kodonia nuhu kua ni Iudea; ");
INSERT INTO wiv_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","dia ta vilehia moni kua, dia ta vala polea ni Barnabas hiro a Sol hiro kata zahe vala. ");
INSERT INTO wiv_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Kilaka kena, ia kua a King Herot e paho taduria nuhuta lotua taza. E lohoia kete kati zahatia ni dia. ");
INSERT INTO wiv_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ki geu ve dia ka hubi matehia a Jems, tazini Jon na bainat. ");
INSERT INTO wiv_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Kamana ki hadavia habuka a vuni Iuda dia ta magali katiu kamana, ia kaze ve kiri Pita ia haba taduria. Goloa kua e bele matoto na kadia dama kapou na Bret Beta Yis. ");
INSERT INTO wiv_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","E haba taduria, pale, ia vahohoria na karabus, ia vala a Pita na limana kabuna soldia e garamo. Garamo, garamo na kabu katiu. A Herot e lohoia kete pelea ni gotala ni hulehulenia, muri na kadia dama na Pasova. ");
INSERT INTO wiv_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","A Pita ia ma mia na poloka karabus, palaka manumanu na lotua dia ta ma bada lotu ni Vuvu kete kodonia. ");
INSERT INTO wiv_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Na marigo muga na dama kua a Herot e makia kete hulehulenia a Pita, a Pita ia e ngongoro na pidaka soldia rua, e rotua na sen rua, na gat kamahi dia ka mamadi na hatamara haus karabus. ");
INSERT INTO wiv_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Na engel katiu kana Paraha ia e bele valutu, na laet kapou ki balanga poloka haus karabus kua. Na engel kua ia pahoria hiripi Pita ia vakongania ki tania, “Baribari, madi tapu.” Pale, na sen rua kua ia pahu na limana karua kini dua. ");
INSERT INTO wiv_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Pale, na engel ia tania vona, “Taza ho na ka lete ho tu lohoria ka su.” A Pita ia katia. Na engel ki tani barae ve, “Kukuliho na ka kale havuhavua ho tu muri ni niau.” ");
INSERT INTO wiv_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","A Pita ia muri vona gotala na haus karabus, palaka ki beta ni lohoi vutuhia habuka na goloa kua na engel e kakatia e matoto, na vuna e lohoia ki tania e manginunginu. ");
INSERT INTO wiv_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Hiro ka pe hutu na kabuna gat katiu hiro ka vano pe hutu ve na ruana kabuna gat taza ve pale, hiro ta vano bele na geit kara karabus kua e katua na ain, kua e tare gotala kara dala kua e vano kara taon. Na geit kua ia mule e ngapa, hiro ta gotala, tania hiro ta pe vano na dala katiu, pale, na engel ia zuka tapunia. ");
INSERT INTO wiv_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Pale, a Pita ia ti ba lohoi vutuhia kini tania, “Kua, te lala matotonia habuka na Paraha e geria kana engel kete pele mulehiau na limani Herot ia mai na goloa kua a vuni Iuda dia ta lohoia dia kata katia ni niau.” ");
INSERT INTO wiv_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Kamana ki lohoi vutuhia goloa kua e bele vona, ia vano kara ruma ke Maria titinani Jon, a Jon hizana katiu ve a Mak, manumanu luba dia ta lupu vona dia ka lolotu. ");
INSERT INTO wiv_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","A Pita ia mai hubia na doa kapou na hatama, na tavine vora katiu hizana a Roda ia mai kete vukazia na doa. ");
INSERT INTO wiv_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Tania ki longo lala a Pita, ia ki hilohilo matoto kini beta ni vukazia na doa ia rovo vamule vano, ia tania ni dia, “A Pita kuari na hatama!” ");
INSERT INTO wiv_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Dia ka tania kirina, “Ho tauka tu batola.” Palaka ti bada kini tatania, dia ta tani barae, “Tauka na kana engel kena.” ");
INSERT INTO wiv_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Palaka a Pita ia ma huhubia na doa, tania dia ka vukazia na doa dia ka hadavia, dia ta lohoi tori matoto. ");
INSERT INTO wiv_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pale, a Pita ia pole na limana za ki vatunga habuka dia kata zodo, pale, ia tania ni dia na goloa kua na Paraha e katia vona ki pele gotalani mulehia na haus karabus. Ki tani barae ni dia, “Miu kalohu hoto ke Jems kamana habu tazidolu taza ve.” Pale, ia vatidia kini vano kara palaka motu katiu. ");
INSERT INTO wiv_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ti dama, na soldia kamahi dia ta kuahi dia ka lohoi tori habuka, a Pita ti kiri ve matoto. ");
INSERT INTO wiv_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","A Herot ia geu dia ta hada kirina, palaka beta dia na paria. Pale, a Herot ia hulehulenia na soldia kamahi, pale, ia geu dia ta vaihubi mate kamadia. Pale, a Herot ia vatia Iudea kini ziho kiri Sisaria kete mia vona. ");
INSERT INTO wiv_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","A Herot e vavarikori kamani vuni Tair kamani vuni Saidon. Kubarae dia ta lupu, dia ta zahe, dia kata pole kamana. Dia ta muga, dia ka tani hoto ke Blastus, ia na kaka kua e hahada na goloaloa kana king, dia ta hulenia kara magali kemia. Na vuna dia ta mimia za na haninga kua na king e vavala ni dia. ");
INSERT INTO wiv_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Na dama kua dia ta makia dia kata hada a Herot vona, ia e zohozoho ki mimia na kana sia king, ki popole kamana manumanu. ");
INSERT INTO wiv_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Na manumanu dia ka goe dia ka tani barae, “Na halingani vuvu kua, beta ni kana tinoni.” ");
INSERT INTO wiv_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Kamana pamuhi za, na vuna kua a Herot beta ni hahate motunia a Vuvu, na engel kana Paraha ia katia ia mazahitia ia ngoro, na matamata kamahi dia ta hania ia mate. ");
INSERT INTO wiv_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Palaka na polea ke Vuvu ti dopa kini kakapou kini vana lobia palakalaka. ");
INSERT INTO wiv_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Tania a Barnabas kamani Sol hiro ka vahozovia kahiro galanga ni Ierusalem, hiro ta vamule kiri Antiok, hiro ta pelea a Jon, kaka kua e kohanga ve ni Mak ki kamahiro. ");
INSERT INTO wiv_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Manumanu ke Vuvu ni Antiok, taza ni dia na profet ia mai taza ni dia na tisa. Hizadia a Barnabas, ia mai a Simeon hizana katiu ve a Niger, ia mai a Lusius bukuna taon a Sairini, ia mai a Sol, ia mai a Manain (kaka kua, e vanga ruanga kamani Herot na nabawan king, ki paraha). ");
INSERT INTO wiv_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Kamana dia ta lolotu dia ka mamahoho, na Vule Tumonga ia tania, “Miu maki kakava kagu a Barnabas hiro a Sol kara galanga kua hau ta kohanihiro kirina.” ");
INSERT INTO wiv_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Pale, muri na kadia lotua, dia ta taru langaria limadia ni hiro dia ta gerihiro vano. ");
INSERT INTO wiv_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Hiro rua kua, na Vule Tumonga ia gerihiro ziho kiri Selusia, hiro ta polo na vaga vano kara ailan Saiprus. ");
INSERT INTO wiv_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Tania hiro ta vano bele ni Salamis, hiro ta tani kakava na polea ke Vuvu na poloka haus lotu kamahi ke vuni Iuda. A Jon ia e kamahiro za kete kokodonihiro. ");
INSERT INTO wiv_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Hiro ka vana lobia na malala laveve na ailan kua, hiro ta vano bele na malala katiu hizana Pafos. Na palaka kua dia ta paria na kaka Iuda katiu, ia na profet vairukuruku katiu, ki kakanaka taetaea kamana muli, hizana a Barjisas. ");
INSERT INTO wiv_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ia e lala kete mimia kamana gavana kara ailan kua, a Sergius Paulus. Gavana kua ia kaka katiu kua kana lohoihoia vona, ia ki geu kiri Barnabas hiro a Sol, na vuna e kulina kete longoria na polea ke Vuvu. ");
INSERT INTO wiv_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Na kaka lai muli kua, na pole matotoa Grik, dia ta lala dia kata kokohania, ni Elimas, e gegea a Pol hiro a Barnabas, ki parakilania kete katia na gavana kua kete beta kete bilip. ");
INSERT INTO wiv_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Pale, a Sol, hizana katiu ve a Pol, e vonu na Vule Tumonga, ia hada boroboronia a Elimas ia tania, ");
INSERT INTO wiv_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Ho tuna hanitu, ku vagi kana goloa laveve kua e mahoto! Ho tu vonu matoto na mogepa ngaroa kamana vairukua. Mara beta nu tabaria hava kua tu paparakilania koto pokizia na moge mahoto laveve ke Vuvu ni kara vairukua? ");
INSERT INTO wiv_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Kua na limana Paraha ti hubiho. Da tu keu, ki havarau pitu da beta koto hadavia na matana voro.” Kamana a Pol ki tatani barae, na goloa katiu balika habuhabu, e rodorodoa matoto, ia kari havuti pamuhia na matani Elimas, pale, ia kini babakaka kini huhule tori kaka kete pahoria ni vatunga dala vona. ");
INSERT INTO wiv_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Tania na gavana kua, ki hadavia na goloa kua e bele, ia bilip pamuhi, na vuna polea kana Paraha e padea matoto poloka. ");
INSERT INTO wiv_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","A Pol kamana nuhu kua dia ta kakamana dia ta vatia Pafos, dia ta polo na vaga vano bele ni Perga, na provins Pamfilia, dia ta bele vona, a Jon ia vatidia ia vamule kiri Ierusalem. ");
INSERT INTO wiv_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Dia ta vatia a Perga dia ta ma pe liuliu zahe ni Antiok na distrik Pisidia. Na Sabat dia ta hoho na haus lotu ke vuni Iuda dia ta mia. ");
INSERT INTO wiv_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Dia ta ridim na lo kamana buk profet hozo, na nuhu kua dia ta hahada na haus lotu ke vuni Iuda dia ta hulenidia dia ka tania, “Habu tai miu ta hate motu, kua ni kamiu polea vona miu kata vabadangania manumanu vona, miu ta pole.” ");
INSERT INTO wiv_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","A Pol ia madi ia talea manumanu na limana, ia tani barae, “Manumanu bukuni Israel ia mai miu manumanu motu kua beta miu na Iuda matoto, palaka kua miu te lolotu ve ni Vuvu, miu longoriau! ");
INSERT INTO wiv_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","A Vuvu, ke vuni Israel e makia habu tubuhita; ki vatuharidia kilaka kua dia ta vovora ni Isip, na vuna na kana matuhanga kapou, ia ki pele mulehidia, dia ka gotala ni Isip, ");
INSERT INTO wiv_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","ia ki hada poto ni dia na poloka deset na krismas e 40, ");
INSERT INTO wiv_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","a Vuvu ki vairohia na zukazuka e 7 na kantri Kenan, ia vala na garigari na kana manumanu, dia kata pelea kadia garigari kua. ");
INSERT INTO wiv_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Goloaloa kua e bele, kozo kete pelea krismas e 450. Muri vona, a Vuvu ia makia jas kamahi dia kata vahotovia kadia mianga ki mule na taem a Samuel ti kara profet. ");
INSERT INTO wiv_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Pale, dia ta hule kara king, a Vuvu ia vala a Sol tuni Kis, na zukani Benjamin, ki hada ni dia na krismas e 40. ");
INSERT INTO wiv_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","A Vuvu ia pele kakava a Sol ia makia a Devit kini king. Ia ki tani kakava vona ki tania, ‘Hau te paria a Devit tuni Jesi, na kaka kua e mumuri matoto na polokogu, ia da e muri matoto na goloa laveve kena e kuligu kata katia.’ ");
INSERT INTO wiv_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ia na zukani Devit za kua a Vuvu ti vala na kakanaka vaikolia a Iesus, habuka kua e mapamapa ni dia. ");
INSERT INTO wiv_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Muga na belea ke Iesus, a Jon ia e ratarata na manumanu dia kata pokizia magalidia dia na pelea baptais. ");
INSERT INTO wiv_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ti kozoho a Jon keteni vahozovia kana galanga ia ki hulenidia ki tania, ‘Miu ta lohoia hau azei matoto? Beta ni hau na kaka kena. Beu, palaka ia e ba mumuri ni niau, hau ki beta na kaka pa na dangea kata hulia motana kana sandel.’ ");
INSERT INTO wiv_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Habu tazigu, habu tubuni Abraham, ia mai miu nuhu motumotu kua miu ta bilip ni Vuvu, e valanga na polea na pele mulemulea kua ni dolu. ");
INSERT INTO wiv_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Na manumanu bukuni Ierusalem ia mai kadia pararaha kamahi, beta dia na hada lala a Iesus, dia ka hubi matehia, kini pori matoto na polea kua na poloka buk na profet kamahi, kua dia ta hahazenia na Sabat laveve. ");
INSERT INTO wiv_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Beta dia na paria vuvuna goloa zaha katiu kua kete nap kete mate vona, palaka dia ta hulenia a Pailat kete hubi matehia. ");
INSERT INTO wiv_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Kamana dia ka katia goloa laveve kua e vapolunganga ki tanga kete katua vona, dia ta pelea zipa na kruse, dia ta tavunia na poloka lovo. ");
INSERT INTO wiv_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Palaka a Vuvu ia valamaria na matea, ");
INSERT INTO wiv_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","na dama luba, nuhu kua dia ta kamana dia ka pe ni Galili dia ka zahe kiri Ierusalem, dia ta hadavia. Ia dia te tatani kakava na polea ke Iesus na kadolu manumanu. ");
INSERT INTO wiv_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Hita ka tatania ni miu na Kalohua Kemi: Goloa kua a Vuvu e mapamapa ni habu tubudolu, ");
INSERT INTO wiv_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ti pori matoto ni dolu, habu tubudia, kua e valamari mulehia a Iesus. Habuka kua e vapolunganga na ruana sapta na poloka buk song ki tanga: ‘Ho na Tugu, meni Hau te kara Kamama.’ ");
INSERT INTO wiv_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","E matoto kua a Vuvu e valamaria na matea, ki mara beta ve ni mavuru na poloka lovo, habuka kua e tanga na polea kua, ‘Da ta kati kemihia matoto ni miu ka vala goloa kemikemi matoto ni miu, habuka kua varira ta mapamapa ni Devit. Na goloa kua, da e bele matoto habuka kua ta tania.’ ");
INSERT INTO wiv_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Na polea katiu ve e vapolunganga ki tani barae ve voa, ‘Mara beta nu vatia ka Kaka Tumonga ni mavuru na poloka lovo.’ ");
INSERT INTO wiv_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Kilaka kua na taem ke Devit, ia e katia galanga laveve ke Vuvu, ia mate, kini tavuanga kamani habu tubuna, na podana kini mavuru na poloka lovo. ");
INSERT INTO wiv_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Palaka na Kaka kua a Vuvu e valamaria na matea, beta ni mavuru na poloka lovo. ");
INSERT INTO wiv_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Ki kubarae, habu tazigu, hau e kuligu miu kata lala kubarae, ia ni Iesus za kua na makina lohoi balabalanga na manaunaua kamahi, ti kavakavanga ni miu. ");
INSERT INTO wiv_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Ni Iesus za manumanu laveve kua dia ta bilip ia dia te mahoto matoto na goloa laveve kena na lo ke Moses e tania mara beta nu mahoto vona. ");
INSERT INTO wiv_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Miu lohoia tabarae na polea kua na profet kamahi dia ta tania ni bele ni miu, ");
INSERT INTO wiv_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Hada, miu nuhuta pole valabilabia kara polea ke Vuvu, da miu ta lohoi toritori, miu ka golugolu, na vuna Hau da ta katia goloa katiu na kamiu taem kua, ki mara beta miu na bilip vona, ia vata kua ta kaka katiu ni tania ni miu.’” ");
INSERT INTO wiv_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Tania a Pol hiro a Barnabas hiro ta vatia na haus lotu ke vuni Iuda, na manumanu dia ta koi tadurihiro, dia ka tania, “Na Sabat muri mo kata pole dopa na polea kua meni mo ta popole vona.” ");
INSERT INTO wiv_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Kamana dia ka hozo, a vuni Iuda luba kamana manumanu motumotu bukuna kabu motu, palaka dia kene mumuri na makina lotua ke vuni Iuda, dia ta muri ni Pol hiro a Barnabas, hiro ta pole kamadia, hiro ka vabadanganidia, dia kata ma bada na mahariharia ke Vuvu. ");
INSERT INTO wiv_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Na Sabat muri, kozoho kete manumanu laveve na taon kapou kua dia ta mai lupu dia kata longoria na polea ke Vuvu. ");
INSERT INTO wiv_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Tania a vuni Iuda dia ka hadavia na kabuna manumanu kua, magalidia ki zaha matoto, pale, dia kene pole zahatia na polea kua a Pol e tatania. ");
INSERT INTO wiv_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Palaka, a Pol hiro a Barnabas, hiro ta dopa pole hiro ka tani barae, “Miro kata muga vala polea ke Vuvu ni miu. Palaka na vuna kua miu te pala katia na polea kua, ia ti balika miu te tania, ‘Hita beta ni kulihita hita kata mahuri roro.’ Ki kubarae, miro da miro te vano na nuhu kua beta dia na lala a Vuvu. ");
INSERT INTO wiv_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Na vuna na Paraha e tani vatuharia ni miro kubarae, ‘Hau te katiho kunu kara laet kara nuhu kua beta dia na lala a Vuvu, kete nap koto kodonia na manumanu laveve na vulovulo, kata pele mulehidia.’” ");
INSERT INTO wiv_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Kamana nuhu kua beta dia na Iuda, dia ka longoria na polea kua, dia ta hilohilo dia ka vavazahenia na polea kana Paraha; ia mai nuhu laveve kua a Vuvu ti makidia kava dia kata pelea mahuri roroa, dia ta bilip ve. ");
INSERT INTO wiv_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Na polea kana Paraha ki vana lobia na malala laveve na distrik kua. ");
INSERT INTO wiv_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Palaka a vuni Iuda dia ta pado pokipokizia magalini tavivine kua dia ta hizanga na taon kua, dia ka lala dia kata lolotu kamadia, ia mai pararaha kara taon kua. Pale, dia ta kavunia manumanu dia kata zaha kiri Pol hiro Barnabas, dia kene kalinganihiro na distrik kua. ");
INSERT INTO wiv_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Hiro ta pali tubinia na havuhavu na kabehiro, hiro kata vatunga kakava habuka moge dia ta katia ni hiro beta ni kemi, pale, hiro kene vano kiri Aikoniam. ");
INSERT INTO wiv_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Na disaipel kamahi dia kene vonu matoto na hilohiloa kamana Vule Tumonga. ");
INSERT INTO wiv_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ni Aikoniam, a Pol hiro a Barnabas hiro ta vano kara haus lotu ke vuni Iuda habuka kua hiro ta katia ni Antiok. Hiro ka vala polea vona, hiro ta vala kemikemihia matoto polea, kubarae a vuni Iuda luba matoto kamana nuhu kua beta dia na lala a Vuvu luba ve, dia ta bilip. ");
INSERT INTO wiv_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Palaka a vuni Iuda kua beta ni kulidia dia kata bilip, dia ta pado pokipokizia lohoihoia kana nuhu kua beta dia na lala a Vuvu, dia kene katidia dia kene zazaha kara nuhu kua dia ta bilip. ");
INSERT INTO wiv_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Palaka, a Pol hiro a Barnabas hiro ta mia havarau ni Aikoniam. Beta hiro na kuahi hiro kata tani kakava na polea na mahariharia kana Paraha. Na Paraha ve ki vala na matuhanga ni hiro, hiro kata katia na mirakel kapopou. Na Paraha ia ti kubaraenia, ia kini vatunga kavakava na manumanu habuka, polea kua hiro ta vavala, ia e limoha. ");
INSERT INTO wiv_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Na manumanu bukuna taon kua dia kene varipe vulavulahi, dia taza dia te kamakamani vuni Iuda, dia taza dia te kamakamana apostel karua. ");
INSERT INTO wiv_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Pale, a vuni Iuda kamana nuhu kua beta dia na lala a Vuvu, dia ta taru lupunia kadia polea kamana kadia pararaha, dia kata hubihiro, dia na lubi matehihiro na kedo. ");
INSERT INTO wiv_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Palaka hiro ta lala horuhoruvia na goloa kua, hiro ta hava vano kara taon karua kua a Listra hiro a Derbe na distrik a Likonia. Hiro ta vano ve na malala kamahi kua e kozoho na taon karua kua, ");
INSERT INTO wiv_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","hiro kene kakalohunia na Kalohua Kemi na palaka kamahi kua. ");
INSERT INTO wiv_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Na malala kua a Listra, na kaka katiu kabena e matemate, e valohua kabena ki matemate, ki beta ni vavana. ");
INSERT INTO wiv_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ia mia ki lolongoria a Pol kua e popole. A Pol ia tunga vano matoto kirina, ki hadavia habuka kaka kua e bilip ki dangea kete kemi mule. ");
INSERT INTO wiv_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Kubarae, a Pol ia goe ki tani barae, “Madi na kabe karua!” Tania a Pol ki tani barae, na kaka kua ia divurutia ia madi kini vanavana. ");
INSERT INTO wiv_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Kamana na kabuna manumanu kua dia ka hadavia na goloa kua a Pol e katia, dia ta goe na kadia pole matotoa a vuni Likonia, dia ka tani barae, “Na vuvu kamahi dia te bagobago dia kene kara kaka dia kene ziho ni dolu.” ");
INSERT INTO wiv_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","A Barnabas dia te kohania ni vuvu Sus, a Pol dia te kohania ni vuvu Hermes, na vuna a Pol, ia na kaka kua e kara havahiro ki popole kahiro. ");
INSERT INTO wiv_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Na haus lotu kua dia ta lala dia kata lolotu na kadia vuvu a Sus vona, ia e madi kozoho na hatama na banis kua e lobia na taon. Na pris kara haus lotu kua, ia pelea na bulmakau kamahi kamana palaua taza dia ta turia dia ka kutu lupunia, dia ta pelea mai kara hatamara geit na taon kua, na vuna na manumanu dia te lohoia dia keteni vala opa ni vano ni Barnabas hiro a Pol. ");
INSERT INTO wiv_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Palaka tania na apostel karua kua a Barnabas hiro a Pol, hiro ka lala paria na goloa kua dia paparakilania dia kata katia, hiro ta bara terehia kahiro zohozohoa hiro ta rovo vano gotala na kabuna manumanu kua, hiro ka goe hiro ka tani barae, ");
INSERT INTO wiv_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“E miu, miu ta kukuziha kua? Miro na kaka vetanga za kua balika miu. Miro ka pelea na Kalohua Kemi ki mai ni miu, miro ka tatania ni miu habuka miu kata vala lamamiu kara goloa vetanga kena miu ta lolotu vona, miu na tare poki miu vano ni Vuvu kua e mahuri. Ia kua e katia na lagato kamana garigari kamana dazi ia mai na goloaloa laveve na poloka. ");
INSERT INTO wiv_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Muga, a Vuvu ia e hada vetania za manumanu dia ka kakatia goloa za na kadia lohoihoia. ");
INSERT INTO wiv_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Palaka beta ni habuka ni paritigi matoto ni miu, ni beta miu na lala ia. Ia e lala kete vatunga kakava kana kemia kirimiu, ki lala kete vavala huza ni pe na lagato ni ziho ni miu, ki lala kete katia haninga na vanua ni bele papa matoto. Ia ki lala kete vavala haninga kapopou ni miu ki katia polokomiu ki hihilohilo matoto.” ");
INSERT INTO wiv_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Hiro ta tani barae ni dia, palaka manumanu dia ta bada matoto za dia kata vala opa ni hiro, palaka ki betaka. ");
INSERT INTO wiv_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Pale, a vuni Iuda taza dia ta pe ni Antiok kamani Aikoniam dia ka mai, dia ta pado pokipokizia na magalina kabuna manumanu kua, dia ta lubia a Pol na kedo, dia ta harehia gotala na taon dia ta zuka tapunia vona, dia ta lohoia dia ka tania ti mate. ");
INSERT INTO wiv_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Palaka tania na disaipel kamahi dia ka mai madi lobia, ia madi kini vamule vano hoho kara poloka taon. Ti dama mule, hiro a Barnabas hiro ta vavana kiri Derbe. ");
INSERT INTO wiv_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Hiro ta tani kakava na Kalohua Kemi na poloka taon kapou kua, hiro ka katia manumanu luba kini kara disaipel. Pale, hiro ta vamule, kiri Listra, hiro ka vano ve ni Aikoniam, kamani Antiok, ");
INSERT INTO wiv_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","hiro ka vabadangania na disaipel kamahi, hiro ka tania ni dia habuka dia kata madi bada na kadia bilip. Hiro ka tani barae ve ni dia, “E kulidolu tolu kata hoho na kingdom ke Vuvu, palaka da muga tolu ka luga bizea luba.” ");
INSERT INTO wiv_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","A Pol hiro a Barnabas hiro ta makia manumanu taza na sios katiukatiu kua dia kata vavamuga na sios kamahi kua, dia ta mahoho dia ka lotu, dia ta vala manumanu kua na Paraha. ");
INSERT INTO wiv_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pale, muri vona, a Pol hiro a Barnabas hiro ta vavana pe na pidaka distrik a Pisidia, hiro ta vano bele na provins a Pamfilia. ");
INSERT INTO wiv_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Hiro ta vala polea ke Vuvu na taon ni Perga, ba muri hiro ta ziho kiri Atalia. ");
INSERT INTO wiv_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Hiro ta vatia a Atalia hiro ta polo na vaga dia ta sel vamule kiri Antiok. A Antiok, ia na palaka kua muga na Kristen kamahi dia ta taruhia limadia ni hiro, dia ka gerihiro, hiro kata katia galanga kua hiro te vahozovia kava, kua hiro kene vamule. ");
INSERT INTO wiv_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Hiro ta bele ni Antiok, hiro ta lupunia na manumanu laveve na sios, hiro ka kalohunia na goloa laveve kua a Vuvu e katia na limahiro. Hiro ta tani barae, “A Vuvu ti vukazia na dala kara nuhu kua beta dia na lala a Vuvu, dia kata bilip ve.” ");
INSERT INTO wiv_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Hiro ta mia havarau kamana disaipel kamahi ni Antiok. ");
INSERT INTO wiv_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Manumanu taza dia ta pe ni Iudea dia ka ziho kiri Antiok, dia kene vaketekete barae na Kristen kamahi, “Ta beta ni vatomutomuhamiu, habuka kua a Moses e vatunga ni hita a vuni Iuda, ia mara beta a Vuvu ni pele mulehimiu.” ");
INSERT INTO wiv_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","A Pol hiro a Barnabas hiro ka longoria na polea kua, hiro ta katia vaigegea kapou matoto kamadia. Pale, na Kristen kamahi dia ta makia a Pol hiro a Barnabas kamana manumanu taza ve, dia kata zahe kiri Ierusalem dia kata hada na apostel kamahi, dia na hule vutuhidia na polea kua. ");
INSERT INTO wiv_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Na sios ia geridia, dia kene vavana, dia ta vavana zahe dia ka pe na pidaka distrik karua kua a Fonisia kamani Samaria, dia ka kalohunia na Kristen kamahi habuka, nuhu kua beta dia na lala a Vuvu, dia te bilip ve. Na kalohua kua, e katia na Kristen kamahi na malala karua kua, dia ka hilohilo. ");
INSERT INTO wiv_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Kamana dia te zahe bele ni Ierusalem, manumanu laveve na sios kamana apostel kamahi ia mai kadia pararaha kua dia vavamuga na sios, dia ta hilohilonidia, pale, a Pol hiro a Barnabas, hiro ta kalohunia goloa laveve kua a Vuvu e katia na limahiro. ");
INSERT INTO wiv_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Palaka na Kristen taza dia ta bukuna kabu ke vuni Parisi dia ta madi dia ka tani barae, “Nuhu kua beta dia na lala a Vuvu, palaka kua dia kene bilip, ia kete vatomutomuhadia, miu tania ni dia ve habuka, dia kata muri na lo ke Moses.” ");
INSERT INTO wiv_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Na apostel kamahi kamana pararaha kara sios, dia ta lupu dia kata pole na lohoihoia kua. ");
INSERT INTO wiv_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Dia ta pole mai vano na goloa kua, pale, a Pita ia di madi ia tani barae ni dia, “Habu tai, miu ta lala habuka a Vuvu ia ti vazenia galanga ni dolu, ia kini makiau kata kalohunia na Kalohua Kemi na nuhu kua beta dia na lala a Vuvu, habuka dia kata longoria dia na bilip. ");
INSERT INTO wiv_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","A Vuvu ia e lala poloka manumanu laveve, kini vatunga habuka ia e kulina kiridia ia kini vala na Vule Tumonga ni dia, habuka kua e katia ni dolu. Na moge kua a Vuvu e katia, ia ti vatunga habuka, ia e kulina kete peledia ve. ");
INSERT INTO wiv_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","A Vuvu ki beta ni hada pali kiridolu za, beta, moge kua e katia ni dolu, ia e katia ve ni dia. Kamana dia te bilip, a Vuvu ia ti katidia dia kene klin na matana. ");
INSERT INTO wiv_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ki kubarae, e kuziha miu kene paparakilania ve a Vuvu? Tabarae miu na vavadua langaria ve bizea kua ve kiridia. Muga habu tubudolu ia mai kua tolu ve, tolu ta lolokia bizea kua. ");
INSERT INTO wiv_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Tolu ta bilip habuka ia na mahariharia kana Paraha a Iesus Kristus za kua a Vuvu ti pele mulehidolu vona, balika kua ia e pele mulehia ve na manumanu kamahi kena vona.” ");
INSERT INTO wiv_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Pale, tania a Pita ki pole hozo, beta kaka katiu na poloka miting kua ni tania ve polea katiu. Dia te tabu longo kiri Barnabas hiro a Pol kua hiro te tatania ni dia na mirakel kapopou kua a Vuvu e kakatia na limahiro na pidaka nuhu kua beta dia na lala a Vuvu. ");
INSERT INTO wiv_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Hiro ta pole hozo, a Jems ia madi ia tani barae, “Habu tazigu, miu tabu longo kiriniau. ");
INSERT INTO wiv_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","A Saimon ia e tatani mulehia kua muga a Vuvu e vatunga kavakava kana hatuhatua kara nuhu kua beta dia na lala a Vuvu, ia kini peledia, dia kene kara kana manumanu. ");
INSERT INTO wiv_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Na polea kana profet kamahi ve ia e tani barae ve. Dia ta vapolu baraenia, ");
INSERT INTO wiv_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Muri na kua da ta vamule ka habati mulehia na haus sel ke Devit kua ti tua. Hau da ta vahotovi mulehia goloa laveve kena e zaha na ruma, hau da ta vamadiri mulehia, ");
INSERT INTO wiv_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","te kati baraenia, da manumanu laveve na vulovulo dia kene kaze kirigu, ia mai nuhu kua beta dia na lala a Vuvu, hau te makidia, dia kene kagu.’ Polea kua ia kana Paraha. ");
INSERT INTO wiv_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Varira za ia ti lalanga habuka na Paraha ia e tania goloa kua da e kubarae. ");
INSERT INTO wiv_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Ki kuza barae, kagu lohoihoia e pebarae, taua ve tolu na katia ve ni vitiha kara nuhu kua beta dia na lala a Vuvu, palaka kua dia te tare poki dia kene vano ni Vuvu. ");
INSERT INTO wiv_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Palaka tolu kata vapolungania pas katiu ni vano ni dia, tolu na vatabunidia za habuka tabarae dia na hahania haninga kua manumanu dia ta vala habuka opa na vuvu vairukuruku, tabarae ve dia na kakatia makina magali buhua. Tabarae dia na hania na enimel kua e vutu kotoha lohora ki mate, na vuna beta dia kata hania enimel kua topo e ba vovona na poloka. ");
INSERT INTO wiv_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Tolu ta lala habuka varira za, ki mai, mai meni kua, manumanu dia ta lala dia kata vavala na polea ke Moses na taon laveve na poloka haus lotu ke vuni Iuda na Sabat laveve.” ");
INSERT INTO wiv_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Pale, na apostel kamahi kamana pararaha kua dia ta hahada na sios, ia mai na manumanu laveve na sios, dia ta taru lupunia kadia polea dia kata makia kaka rua hiro kata kamani Pol hiro a Barnabas dia na vano kiri Antiok. Dia ta makia a Iudas (hizana katiu ve a Barsabas) hiro a Sailas, hiro ve na paraha kara sios. ");
INSERT INTO wiv_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Dia ta vala pas katiu ni dia. Na pas kua e tani barae: Dama kemi ni miu laveve, nuhu kua beta miu na lala a Vuvu, palaka kua miu te bilip ni Iesus na taon kua a Antiok, ia mai na provins karua kua a Siria kamani Silisia. Hita habu tazimiu na apostel kamahi kamana pararaha kara sios, hita ta vala pas kua ki vano ni miu. ");
INSERT INTO wiv_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Hita te longoria kava habuka kahita manumanu taza dia ta vano ni miu, dia kene vavairohia kamiu lohoihoia na polea kamahi kua dia ta tatania ni miu. Palaka ki beta hita na geridia. ");
INSERT INTO wiv_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Kubarae hita kene taru lupunia kahita lohoihoia hita kata geria kaka rua hiro kata kamani tazidolu rua kua a Barnabas hiro a Pol, kua e kulihita matoto kirihiro, ");
INSERT INTO wiv_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","kaka rua kua hiro ta vala livuhahiro, ki beta hiro na lala hiro kata kuahi kua hiro kata tatani kakava na hizana kadolu Paraha a Iesus Kristus. ");
INSERT INTO wiv_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ki kubarae hita ka geria a Iudas kamani Sailas hiro kata pole, miu na longoria matoto na havahiro, habuka hiro kata vatuharia kahita polealea kua hita ta vapolungania. ");
INSERT INTO wiv_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Hita kamana Vule Tumonga hita ta magali katiu, habuka kete beta hita kata vala bizea ni miu. E kulihita za miu kata muri za na goloaloa kua za: ");
INSERT INTO wiv_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Taua matoto miu na hania haninga kua e opa voa vona na vuvu vairukuruku, ia mai ve tabarae miu na hania na enimel kua topo ba vovona vona, tabarae miu na hania midana enimel kua e vutu kotoha lohora ki mate, tabarae matoto miu na kakatia mogepa magali buhua laveve. Kua ta miu na muri papa na lohoihoia kamahi kua, ia da e kemi matoto. Paleka miu na mia pa. ");
INSERT INTO wiv_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Pale, na manumanu na sios dia ta geria dia garamo kua, dia ta ziho kiri Antiok, dia ta koi lupunia na sios dia ta vala pas kua ni dia. ");
INSERT INTO wiv_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Na manumanu dia ka ridim pas kua dia ka hilohilo matoto na polea kemi kua e vabadanganidia. ");
INSERT INTO wiv_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","A Iudas hiro a Sailas, hiro na profet ve. Kubarae hiro ka vala polea kemikemi na Kristen kamahi, hiro ka vabadanganidia. ");
INSERT INTO wiv_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","34","Hiro ta mia havarau pitu ni Antiok, ba muri na Kristen kamahi dia ta geri mulehihiro kamana magali kemia hiro kata vamule na nuhu kua e gerihiro, hiro ka mai ni dia. ");
INSERT INTO wiv_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","A Pol hiro a Barnabas hiro ta ma mia ni Antiok. Hiro ka gala kamana manumanu luba ve, dia kene vavala polea kana Paraha dia kene vavaketekete na manumanu na polea ke Vuvu. ");
INSERT INTO wiv_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Dama taza muri a Pol ia tania ni Barnabas, “Mai to kata vamule balahea habu tazidolu na taon laveve kua muga to ta vala polea kana Paraha vona, to na hadavidia, dia ta gagala ziha.” ");
INSERT INTO wiv_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","A Barnabas e kulina kete kohania a Jon, kua hizana katiu ve a Mak, kete kamahiro, ");
INSERT INTO wiv_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","palaka a Pol e lohoia beta ni kemi marata kete kamahiro, na vuna muga a Mak e hava tapunihiro ni Pamfilia kini beta ni ma gagala kamahiro. ");
INSERT INTO wiv_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Hiro ta vaigege vano hiro ta varipe vulavulahi. Pale, a Barnabas ia kohania a Mak, hiro kene polo na vaga zahe kara ailan a Saiprus, ");
INSERT INTO wiv_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","palaka a Pol ia kohania a Sailas kete kamana. Hiro keteni vavana, na Kristen kamahi, dia ta tani barae ni hiro, “Na mahariharia ke Vuvu e kamamo.” ");
INSERT INTO wiv_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","A Pol ki vavana vano ni Siria kamani Silisia, ki vabadangania sios laveve na palakalaka kamahi kua. ");
INSERT INTO wiv_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","A Pol e mai bele ni Derbe ki vano ve ni Listra. Na taon kua, na disaipel katiu hizana a Timoti ia e mimia vona. Titinana ia na tavine Iuda katiu ki bilip ve ni Iesus, palaka tamana bukuni Grik. ");
INSERT INTO wiv_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Na Kristen laveve ni Listra kamani Aikoniam dia ta lala dia kata mamatinia matoto na mogemoge ke Timoti. ");
INSERT INTO wiv_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","A Pol e kulina kete kohania a Timoti ni kamana, kubarae ia pelea a Timoti ia vatomutomuhia. E vatomutomuhia, na vuna e lohoi ni vuni Iuda kua na malala kamahi kua, na vuna dia ta lala laveve habuka a Timoti tamana ia na Grik katiu. ");
INSERT INTO wiv_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Kua dia ta vavana vano na taon katiukatiu, ia dia ta vala na polea kua na apostel kamahi kamana pararaha kua dia ta hahada na sios ni Ierusalem dia ta vala ki vano na manumanu dia kata muri vona. ");
INSERT INTO wiv_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Kubarae na bilip kana manumanu na sios kini bada, na naba na manumanu na sios kini dopa kakapou na dama laveve. ");
INSERT INTO wiv_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","A Pol kamana nuhu kua dia ta kakamana, dia ta pe na pidaki Frigia kamani Galesia, palaka na Vule Tumonga ki vatabunidia kini beta dia na vala polea kana Paraha na provins ni Esia. ");
INSERT INTO wiv_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Dia ta bele na distrik a Misia, dia ta parakilania dia kata vavana vano hoho na provins a Bitinia, palaka na Vuleni Iesus e taledia. ");
INSERT INTO wiv_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Kubarae dia kene pe hutu ni Misia dia kene vano kara taon a Troas. ");
INSERT INTO wiv_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Na marigo a Pol ia manginuvia na kaka katiu bukuni Masedonia, e madi ki gugugia ki tatani barae vona, “Mai zahe kiri Masedonia nu kodonihita.” ");
INSERT INTO wiv_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Muri na manginunginua kua ke Pol, hita ta vaihidahida pamuhi hita katane vavana kiri Masedonia, na vuna hita te lala matotonia habuka a Vuvu ti koi kirihita hita kata kalohunia na Kalohua Kemi ni dia. ");
INSERT INTO wiv_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Hita ta polo na vaga ni Troas hita ta sel vano mahoto kara ailan a Samotres, dama ruana hita ta sel vano kiri Neapolis. ");
INSERT INTO wiv_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Hita ta vatia a Neapolis hita ta sel vano kiri Filipai, na siti kua, a vuni Rom dia ta katia dia ka mimia vona muga, ia ki taon kapou na distrik a Masedonia. Hita ka mia dama taza vona. ");
INSERT INTO wiv_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Na Sabat hita ta gotala na geit na taon, hita ta ziho kara naru katiu. Hita ta lohoia hita kata paria palaka katiu kua manumanu dia ta lala dia kata lupu vona dia na lolotu. Hita ta mia tadu, hita ta pole kamana tavivine taza kua dia ta lulupu na palaka kua. ");
INSERT INTO wiv_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Tavine katiu na pidaki tavivine kua dia ta tatabu longo kirihita, hizana a Lidia, ia e lala kete gala bisnis ni sasalinia lavalava baritunutunua, ia ki bukuna taon a Taiataira, ia ki lala kete lolotu ni Vuvu. Na Paraha ki pokizia magalina ki tabu longo papa matoto kara polea ke Pol. ");
INSERT INTO wiv_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Muri na kua, a Lidia kamana kana manumanu laveve na kana ruma dia te pelea baptais, ia koi tadurihita kara kana ruma ki tani barae, “Kua miu kene hadaviau habuka hau na kaka katiu kua te bilip matoto na Paraha, miu ta mai mia na kagu ruma.” Ia ki bada matoto hita kata kamana, kubarae hita ta vano kara kana ruma. ");
INSERT INTO wiv_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Boto katiu hita ta vavano kara palaka kua muga hita ta vano hita kata lotu vona, na tavine vora vetanga katiu ia parihita na dala. Na tavine kua, na vule zaha katiu e holiholia ki lala kete tatani mugania goloa kua ba muri kete bele. Kubarae na kana tubu kamahi dia ta lala dia kata pepelea moni kapou matoto na kana galanga kua e lala kete kakatia. ");
INSERT INTO wiv_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Na tavine kua ia muri ni Pol, ia mai ve ni hita, ki goe ki tatani barae, “Manumanu kua dia na voravora ke Vuvu kua e Heta Matoto, dia ka kakalohunia ni miu na dala kua a Vuvu kete pele mulehimiu vona.” ");
INSERT INTO wiv_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Na dama luba na tavine kua ia ma ki kukubarae ni hita. Pale, a Pol ia ti beta ni kulina keteni ma lolongoria tavine kua, kubarae, ia tare poki kirina ia tania kara vule zaha kua, “Hau ta tania ni niho, na hizani Iesus Kristus, mai nu gotala na tavine kua.” Pale, na vule zaha kua ia gotala pamuhi za vona. ");
INSERT INTO wiv_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Pale, na tubutubu kana tavine kua dia te hadavia habuka da ti beta ve dala dia keteni pelea moni kua, kubarae dia ta paho taduria a Pol hiro a Sailas, dia ta harehihiro vano kara palakana lupua na maket dia kata koto kirihiro na kadia pararaha. ");
INSERT INTO wiv_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Dia ta pelehiro vano na magistret dia ka tani barae, “Kaka rua kua hiro ta bukuni Iuda, hiro ta gala hiro ka vavairohia kadolu mianga na taon kua. ");
INSERT INTO wiv_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Hiro ka gala hiro ka vavaketekete na manumanu dia kata mumuri na mogemoge kua e tabu na kadolu lo a vuni Rom.” ");
INSERT INTO wiv_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Na kabuna manumanu kua dia ta lalavu, dia ta padea ve polea kiri Pol hiro a Sailas. Kubarae kadia magistret kamahi dia ta dae terehia kahiro zohozohoa kamahi na livuhahiro, dia ta geu ia hubua hiro na kabala. ");
INSERT INTO wiv_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Dia ta hubi zahatihiro matoto, pale, dia ta taruhihiro na karabus, dia ta tani vatuharia polea na woda kete hada poto papa ni hiro. ");
INSERT INTO wiv_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Tania na woda kua ki longoria na polea kua habuka kete hada poto papa ni hiro, ia taruhihiro na rum kua e ngoro hoho dopa na poloka haus karabus, ia lokonia kabehiro na palang. ");
INSERT INTO wiv_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ti varivalavala a Pol hiro a Sailas hiro ta lolotu hiro ka hahabia linge kiri Vuvu, dia karabus taza ve kua na poloka haus karabus dia ka lolongohiro kua hiro ta kukubarae. ");
INSERT INTO wiv_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Pale, na vuruhe kapou matoto ia kulu valutu, ki hununia na huduhudu laveve na haus karabus kua, na doa laveve na haus karabus kua ki varingapai na sen laveve kua e lokoanga na karabus kamahi vona ki pahupahu. ");
INSERT INTO wiv_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Na woda kua ia lama, tania ki hadavia habuka na doa laveve na haus karabus kua ti ngapa laveve, ia dae pazuhia kana bainat keteni pade mulehia vona ni mate na vuna e lohoia ki tania na karabus laveve dia te varihavai. ");
INSERT INTO wiv_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Palaka, a Pol ia goe hania ki tani barae, “Taua nu kerohiho! Hita laveve kua hita ta ba vovona!” ");
INSERT INTO wiv_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Pale, na woda kua, ia koi kara hadanga, ia rovo hoho, ia vano dua kara kabeni Pol hiro a Sailas, kini vavani. ");
INSERT INTO wiv_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Pale, ia pelea a Pol hiro a Sailas hiro ta na gotala na karabus ia hulenihiro, “Paraha karua, nazia kata katia a Vuvu kete pele mulehiau?” ");
INSERT INTO wiv_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Hiro ka tania vona, “Bilip na Paraha a Iesus, a Vuvu kete pele mulehiho, ho kamana ka manumanu laveve na ka ruma.” ");
INSERT INTO wiv_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Pale, hiro ta vala polea kana Paraha vona ia mai na kana manumanu laveve na kana ruma. ");
INSERT INTO wiv_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Kilaka pamuhi na marigo kua za, na woda kua ia vazuguvia muku kamahi na livuhahiro, pale, ia kamana kana manumanu laveve na kana ruma dia ta pelea baptais. ");
INSERT INTO wiv_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Na woda kua ia pelehiro vano kara kana ruma, ia vala haninga ni hiro, pale, ia kamana kana manumanu laveve na kana ruma dia te hilohilo matoto, na vuna kua dia te bilip ni Vuvu. ");
INSERT INTO wiv_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Tania ti dama, na magistret kamahi dia ta geria na polis kamahi dia ta mai dia ta tania na woda kua dia ka tani barae vona, “Na magistret kamahi dia ta tania koto vagotalani mulehia kaka rua kena.” ");
INSERT INTO wiv_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Pale, na woda kua ia vano tania ni Pol, “Na magistret kamahi dia te geu kata vagotalani moro. Kubarae mo mai gotala mo ta vano kamana magali kemia.” ");
INSERT INTO wiv_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Palaka a Pol ki tania na polis kamahi kua, “Miro na sitisen ke Rom kua, ki beta dia na pari vutuhia habuka miro ta katia goloa zaha katiu o beta, dia ka hubi vetanimiro na matana manumanu laveve, dia ka varaga hohorimiro kara karabus. E kua dia keteni pele gotalani paritigitigi ni miro? Mara beta! Dia mule da dia ta mai dia ka vagotalani miro.” ");
INSERT INTO wiv_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Na polis kamahi dia ta zahe tania polea ke Pol na magistret kamahi, tania dia ka lala habuka a Pol hiro a Sailas hiro na sitisen ke Rom ve, dia ta kuahi. ");
INSERT INTO wiv_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Dia ta mai dia ta pole paipai matoto, dia ta pelehiro gotala dia ta hulenihiro hiro kata vatia kadia taon. ");
INSERT INTO wiv_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","A Pol hiro a Sailas hiro ta gotala na karabus, hiro ta vano kara ruma ke Lidia, hiro ta lupunia na Kristen kamahi hiro ta vabadanganidia. Pale, hiro ta vavana. ");
INSERT INTO wiv_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","A Pol kamana nuhu kua dia ta kakamana, dia ta vano ni Amfipolis, dia ta vatia dia ta vano bele ni Apolonia. Dia ta vatia na taon kua dia ta vano bele ni Tesalonaika. Ni Tesalonaika, ia na haus lotu ke vuni Iuda katiu vona. ");
INSERT INTO wiv_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","A Pol ia vano hoho na haus lotu ke vuni Iuda kua, habuka kua ia e lala kete kakatia, pale, na Sabat tolu balavu e pole kamadia ki vatunga kavakava na polea kamahi kua na poloka buk ke Vuvu, ");
INSERT INTO wiv_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ki tani kemikemihia ni dia ki vatunga kavakava ve habuka a Kristus ia da e luga bizea ki mahuri mule na matea, ia ki tani barae ve ni dia, “A Iesus kua hau ta vavala kana polea ni miu, ia, ia za kua a Vuvu ti makia kete pele mulehia kana manumanu.” ");
INSERT INTO wiv_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","A vuni Iuda taza dia ta bilip dia kene muri ni Pol hiro a Sailas. Ia mai ve a vuni Grik kua dia ta lala dia kata lolotu ve ni Vuvu, kadia manumanu luba dia ta muri ve ni hiro, ia mai tavivine luba kua dia ta hizanga na taon kua ve dia ta muri ni hiro. ");
INSERT INTO wiv_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Palaka a vuni Iuda dia te hahada potihiro, pale, dia ta pelea na raskol taza kua dia ta lala dia kata lobi vetaveta na palakana maket. Dia ta koi lupunia manumanu luba matoto, pale, dia ta padea magalina manumanu kua, dia ta rovo vano kara ruma ke Jeson dia ta hutu vulahia kana doa na ruma dia ta kaze kiri Pol hiro a Sailas, dia kata harehihiro dia na vala hiro na manumanu. ");
INSERT INTO wiv_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Tania ki beta dia na paria a Pol hiro a Sailas, dia ta harehia a Jeson kamana Kristen taza ve, dia ta peledia vano na kadia pararaha kara taon kua, dia ka goe dia ka tani barae, “Nuhu kua dia ta lobia malala laveve na vulovulo dia ka kakatia moge zahazaha ki lolohu, kua dia te mai ve ri kua. ");
INSERT INTO wiv_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","A Jeson ia ti koi taduridia kara kana ruma. Nuhu kua beta dia na lala dia kata mumuri na lo ke Sisar, dia ka lala dia kata tatania habuka na king motu katiu vona, hizana a Iesus.” ");
INSERT INTO wiv_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Manumanu bukuna taon kua, ia mai na kadia pararaha ve, tania dia ka longoria na polea kua, dia ka pole tori matoto. ");
INSERT INTO wiv_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Pale, na kadia pararaha dia ta tania a Jeson kamana Kristen taza ve dia kata kadea kotoa kua, pale, dia ta vatidia dia kene vano. ");
INSERT INTO wiv_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Tania ki marigo havu, na Kristen kamahi dia ta geria a Pol hiro a Sailas hiro ta vano kiri Berea. Tania hiro ka vano bele, hiro ta vano kara haus lotu ke vuni Iuda. ");
INSERT INTO wiv_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","A vuni Iuda kua ni Berea, dia ta manumanu kemikemi, kadia moge e dopa ki kemi livutia na moge ke vuni Tesalonaika, na vuna dia ta longoria na polea ke Pol ki kulidia matoto kirina. Dama laveve dia ta lala dia kata hahazenia na polea kana Paraha dia kata lala matotonia habuka na polea ke Pol e matoto o beta. ");
INSERT INTO wiv_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","A vuni Iuda luba dia ka bilip, ia mai ve a vuni Grik luba kua dia ta hizanga, tavivine kamani tamomohane kamana. ");
INSERT INTO wiv_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Tania a vuni Iuda kua ni Tesalonaika dia ka lala paria habuka a Pol ia ti kakalohunia na polea ke Vuvu ni Berea, dia ta vano kiri Berea ve, dia ta padea ve magalina manumanu ve vona dia kene vairohia lohoihoia kana manumanu. ");
INSERT INTO wiv_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Kubarae na Kristen kamahi dia ta geri tapunia a Pol pozi kara vazalea. Palaka a Sailas hiro a Timoti hiro ta ma mia ni Berea. ");
INSERT INTO wiv_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Tamomohane kua dia ta guria a Pol, dia ta vano dia ka vatia ni Atens. A Pol ia vinohunia ni dia, dia kata tania ni Sailas hiro a Timoti hiro kata baribari tapu muri vona. ");
INSERT INTO wiv_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Kilangata kua a Pol ia ni Atens ki guguria a Sailas hiro a Timoti, ia ki hadavia habuka na poloka taon kua, na stetiu kamana hanunuka kadia vuvu vairukuruku vonu matoto vona, kubarae ki sore matoto ni dia. ");
INSERT INTO wiv_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Kubarae ia vano na poloka haus lotu ke vuni Iuda ki hubia polea kamani vuni Iuda ia mai nuhu kua bukuna malala motu dia kene lolotu ni Vuvu. Ia ki vano ve na palakana maket dama laveve ki popole kamana nuhu kua dia ta lohu na maket. ");
INSERT INTO wiv_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Na saveman taza bukuna kabu ke vuni Epikurian ia mai na kabu ke vuni Stoik, nuhu kua dia ta vaigege kamana. Taza dia ta tani barae, “Na kaka gama havana kuari, e paparakilania kete tani ziha matoto kua?” Taza dia ta tani barae, “E hada barae, ia e parakilania kete vaketekete ni dolu na vuvu bukuna malala motu katiu kua.” Dia ta tatani barae kirina na vuna ia e vavaketekete na vuna ni Iesus ia mai na mogepa mahuri mulea na matea. ");
INSERT INTO wiv_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Pale, dia ta kohania a Pol dia ta pelea zahe na kaunsil kamahi kua dia ta lulupu na potuna a Areopagus, dia ta tani barae vona, “Ko tania ni hita na vaketeketea vahoru kua tu vaketekete vona. ");
INSERT INTO wiv_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ho tu popole na lohoihoia taza kua beta hita na lolongoria varira, ki kulihita hita kata lala na mining na polea kamahi kena.” ");
INSERT INTO wiv_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","A vuni Atens laveve kamana nuhu bukuna malala motu kua dia te mai dia kene lololi na taon a Atens, beta dia na lala dia kata kakatia galanga katiu. Beta. Boto laveve e kulidia matoto dia kata mia dia na longoria lohoihoia vahoru, dia ka lala dia kata popole na pidaka dia mule na polea vahoru katiu kua dia ta ba longoria. ");
INSERT INTO wiv_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Kubarae a Pol ia madi na pidaka kadia kaunsil kamahi na potuna a Areopagus, ia tani barae, “Manumanu bukuni Atens! Hau ta hadavia habuka miu ta manumanuna lotua matoto. ");
INSERT INTO wiv_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Na vuna kua ta vavanavana, ia ta hahadavia na goloaloa kua miu ta lala miu kata lolotu vona, ka hada ve na altar katiu kua miu ta vapolungania polea katiu vona kua e tani barae, ‘Na altar kua ia kana Vuvu kua Beta ni Lalanga.’ Kubarae na Vuvu kena beta miu na lala, miu ka lolotu veta vona, ia ia kua hau ta tatani kakava kana polea ni miu. ");
INSERT INTO wiv_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","A Vuvu kua e katia garigari kamana goloaloa laveve na poloka, ia na Paraha kara lagato kamana vulovulo ki beta ni lala kete mimia na poloka tempel kamahi kua manumanu dia ta hahabatia. ");
INSERT INTO wiv_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ki mara beta kaka katiu ni katia goloa katiu ni vala vona kete kodonia, na vuna ia beta ni lala kete sot na goloa katiu, na vuna ia mule ia e vala laep kamana kavili kamana goloaloa laveve na manumanu laveve. ");
INSERT INTO wiv_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","A Vuvu ki katia kaka katiu, na kaka kua ia ti kara tubuna manumanu laveve kua na kantri laveve, kua dia te mia vavonuhia na vulovulo, ia ki makia dama kua dia kata mia vona ia ki makia ve halahalara kadia garigari kamahi. ");
INSERT INTO wiv_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","A Vuvu e katia goloa kua habuka manumanu dia kata kaze kirina, dia na paria tauka, dia na vano vona. Palaka a Vuvu ia beta ni mia zau ni dolu laveve kua. ");
INSERT INTO wiv_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","‘Na vuna ia e lala kete vala laep ni dolu ia ki vala ve na matuhanga ni dolu tolu ka matuha kua tolu ka vavana.’ Habuka kamiu saveman kamahi, kua dia ta tania muga, ‘Tolu kua ia e limoha tolu ia na habu tutuna.’ ");
INSERT INTO wiv_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Ki kubarae tolu kua ia na habu tutuni Vuvu, kubarae, tabarae tolu na lohoia tolu na tania a Vuvu ia balika gol o silva o kedo, o na hanunu katiu kua e kadiva o katua na lima o na kadolu save mule. ");
INSERT INTO wiv_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Varira manumanu beta dia na lala a Vuvu, kubarae ia ki hada vano ni dia za dia ka kakatia goloaloa kua na kadia lohoihoia mule. Palaka kua, ia ti tani vatuharia polea habuka manumanu laveve dia kata zuka tapunia kadia moge zahazaha dia na tare poki dia na vamule vona. ");
INSERT INTO wiv_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Na vuna ia kava ti makia na damana kua ia kete koto kara manumanu laveve na vulovulo muri na kana moge kua e mahoto, ia kava ti makia kaka kua kete longoria kotoa. Ia ti vatunga kakava na manumanu laveve habuka ia ti makia na kaka kua, kilaka kua e valamari mulehia na matea.” ");
INSERT INTO wiv_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Tania dia ka longoria na polea na mahuri mulea na matea kua, taza ni dia, dia ta katia bozubozua vona, palaka dia taza dia ta tania, “E kulihita hita kata longo mulehiho koto pole mule na polea kena.” ");
INSERT INTO wiv_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Pale, a Pol ia vatia na kaunsil kamahi kua. ");
INSERT INTO wiv_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Manumanu taza dia ta muri ni Pol dia kene bilip. Katiu ni dia ia a Dionisius, ia na kaunsil katiu, ia mai na tavine katiu hizana a Damaris, ia mai manumanu taza ve. ");
INSERT INTO wiv_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Muri vona, a Pol ia vatia a Atens kini vano kiri Korin. ");
INSERT INTO wiv_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ia paria na kaka Iuda katiu hizana a Akwila, e valohua ia ni Pontus, ki ba pe Itali kamani gona a Prisila hiro ka mai mia ni Korin, na vuna a Sisar a Klaudius ti vala polea matuha matoto habuka a vuni Iuda laveve dia kata vatia a Rom dia na vano kara palaka motu. A Pol ia vano kete hadavihiro, ");
INSERT INTO wiv_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","kini mia kini gagala kamahiro na vuna ia e lala kete turuturu kadis habuka hiro, dia ka sasalinia dia ka pepelea moni vona. ");
INSERT INTO wiv_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Na Sabat laveve ia e lala kete hoho na haus lotu ke vuni Iuda, ki popole kamadia. E paparakilania kete katia a vuni Iuda ia mai a vuni Grik ve dia kata bilip ni Iesus. ");
INSERT INTO wiv_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Tania a Sailas hiro a Timoti hiro ka pe ni Masedonia hiro ka lohu, pale, a Pol ia dama laveve ti ma kini vavala na polea ke Vuvu, ki tatania ni vuni Iuda habuka a Iesus, ia na kaka kua a Vuvu e makia kete pele mulehia kana manumanu vona. ");
INSERT INTO wiv_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Palaka a vuni Iuda beta ni kulidia dia kata longoria kana polea dia kene vavaraga polea mata hilehilea kirina, a Pol ia pali tubinia na havuhavu na kana zohozohoa kamahi ki tani barae kiridia, “Kua ta miu na golugolu, ia ti ngoro ni miu mule! Hau mara beta na paria polea vona. Kua meni kua kini ma vavano, hau da te vano na nuhu kua beta dia na lala a Vuvu kene vala polea ni dia.” ");
INSERT INTO wiv_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Pale, a Pol ia vatia na haus lotu ke vuni Iuda kua, kini vano ngongoro na ruma ke Titius Jastus, ia beta ni na Iuda katiu, palaka e lala kete lolotu ni Vuvu, kana ruma ki madi kozoho matoto na haus lotu ke vuni Iuda kua. ");
INSERT INTO wiv_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","A Krispus, ia na kadia paraha kara haus lotu ke vuni Iuda kua, ia ki bilip na Paraha, ia kamana kana famili laveve; ia mai dia luba ve ni Korin dia ta longoria polea ke Vuvu, dia ka bilip, dia kene pelea baptais. ");
INSERT INTO wiv_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Na marigo katiu, a Pol e hadavia na visen katiu, ki hadavia na Paraha e tani barae vona, “Tabarae nu kuahi; tani kakava polea, taua nu tabaria hava. ");
INSERT INTO wiv_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Na vuna Hau ta kamaniho. Mara beta kaka katiu ni di madi kiriniho kete kati zahatia ni niho, na vuna kagu manumanu luba na poloka taon kapou kua.” ");
INSERT INTO wiv_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Pale, a Pol ia mia krismas katiu lingabo e 6, ki vavaketekete na manumanu na polea ke Vuvu. ");
INSERT INTO wiv_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Palaka tania a Galio, na kaka bukuni Rom ti kara kadia gavana na provins a Akaia, a vuni Iuda dia ta lupu dia ta di madi kiri Pol, dia ta paho taduria, dia ta pelea zahe koto kirina, dia ka tani barae, ");
INSERT INTO wiv_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","“Kaka kua e paparakilania kete pokizia lohoihoia kana manumanu dia kata lotu ni Vuvu na dala motu katiu kua beta ni mahoto na lo.” ");
INSERT INTO wiv_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","A Pol ki tania keteni pole, palaka a Galio ia tania kiri vuni Iuda, “Kua kaka kua tani beta ni mumuri papa na lo ke gavman o kua ni katia moge zaha matoto katiu, ia da e vuvuna vona kata mia na longoria kamiu kotoa. ");
INSERT INTO wiv_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Palaka na vuna kua miu ta vavaigege na vuna na kamiu hizahiza kamahi kamana kamiu lo mule, ia miu mule miu vano miu ka vavahotovia na pidaka miu mule. Hau mara beta na longoria kotoa na goloaloa kamahi kena!” ");
INSERT INTO wiv_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Pale, ia vaikali kamadia dia ta gotalatala na rumaka kotoa. ");
INSERT INTO wiv_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","A vuni Iuda, dia ta tare poki kiri Sostenes, na paraha kara haus lotu ke vuni Iuda, dia ta hubia na hatamara haus kot. Palaka a Galio beta ni longo murimuridia. ");
INSERT INTO wiv_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","A Pol e mia kamana Kristen kamahi ni Korin dama luba pitu. Pale, ia vatidia kini kamani Prisila hiro a Akwila dia kene polo na bot dia kene sel vano kiri Siria. Kilaka kua dia ta ba vovona ni Senkria, a Pol ia titiria vuluka laveve kini gorugorua, na vuna e katia na promis katiu ni Vuvu. ");
INSERT INTO wiv_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Dia ta vano bele ni Efesus, a Pol ia vatia a Prisila kamani Akwila vona. Pale, ia vano kazihena kara haus lotu ke vuni Iuda kini popole kamani vuni Iuda. ");
INSERT INTO wiv_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Na manumanu dia ka hulenia kete mia pitu kamadia, palaka beta ni kulina. ");
INSERT INTO wiv_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Palaka kamana e vavana e tani barae ni dia, “Kua a Vuvu ni kulina, hau da ta vamule ni miu.” Pale, ia polo na vaga kini vatia a Efesus. ");
INSERT INTO wiv_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Dia ta sel vano bele ni Sisaria, a Pol ia zahe ni Ierusalem ki hadavia manumanu na sios, pale, kini vavana kiri Antiok. ");
INSERT INTO wiv_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Ki mia havarau pitu ni Antiok, ba muri ia vatidia kini vavana kara malala kamahi kua na distrik a Galesia kamani Frigia, ki vabadangania na Kristen kamahi na palakalaka kamahi kua. ");
INSERT INTO wiv_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Kilaka kua na kaka katiu bukuni Iuda, hizana a Apolos, ia ki valohua ni Aleksandria kini mai mimia ni Efesus. E lala kemikemihia matoto na polea kamahi na poloka buk ke Vuvu, ki kakanaka polea ki lala kete vala kemikemihia matoto polea. ");
INSERT INTO wiv_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","E sikul kemukemuha matoto na Dala kana Paraha, ki kulina matoto kete sikulnia manumanu, ki lala kete tani vahotovia na galangalanga kua a Iesus e katia. Ki lala za na baptais kua a Jon e vavala. ");
INSERT INTO wiv_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ia vano hoho na poloka haus lotu ke vuni Iuda kini vavala polea, beta ni kuahi. Tania a Prisila hiro a Akwila hiro ka longoria kana polea, hiro ta kohania kara kahiro ruma, hiro ta dopa tani ketea ve vona na Dala kana Paraha. ");
INSERT INTO wiv_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","A Apolos ti kulina keteni vano kiri Akaia, pale, na Kristen kamahi ni Efesus dia ta kodonia dia ta vapolungania na pas katiu vano na Kristen kamahi ni Akaia dia ka tania ni dia habuka dia kata koi taduria. Tania ki vano bele, ia ki kodoni kemikemihia matoto manumanu kua a Vuvu ti maharidia dia kene bilip ni Iesus. ");
INSERT INTO wiv_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Na vuna e bada ki vaigege kamani vuni Iuda, ki lala kete didi taduridia na matana manumanu, ki vatunga kavakava ni dia na poloka buk ke Vuvu habuka, a Iesus ia na kaka kua a Vuvu e geria kete pele mulehia kana manumanu. ");
INSERT INTO wiv_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Kilangata kua a Apolos ia ni Korin, a Pol ia e ba lolobia na malalala kamahi kua na potupotuna, ba muri ia mai bele ni Efesus. Ia paria na disaipel taza vona. ");
INSERT INTO wiv_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Ia huleni barae ni dia, “Kilaka kua miu ta bilip varivuvu, miu ta pelea na Vule Tumonga?” Dia ka tania vona, “Beta, ki beta ve hita na lala habuka na Vule Tumonga vona.” ");
INSERT INTO wiv_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","A Pol ia hulenidia, “Pele miu ta pelea baptais kakei?” Dia ka tania, “Na baptais ke Jon.” ");
INSERT INTO wiv_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","A Pol ia tania ni dia, “Na baptais ke Jon, ia na baptais kua e makia habuka miu te zuka tapunia kamiu moge zahazaha, a Jon ki tatania na manumanu habuka dia kata bilip na kaka kua e ba mumuri vona, kaka kua, ia a Iesus.” ");
INSERT INTO wiv_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Tania dia ka longoria na polea kua, dia ta pelea baptais na hizana Paraha a Iesus. ");
INSERT INTO wiv_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Tania a Pol ki taruhia limana na hududia, na Vule Tumonga ia mai ni dia, dia kene popole matoto na pole matotoa kana manumanu motu, dia kene tatani kakava na polea ke Vuvu. ");
INSERT INTO wiv_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Nuhu kua dia e 12. ");
INSERT INTO wiv_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pale, a Pol beta ni kuahi, ia vano hoho na haus lotu ke vuni Iuda, ki vala polea vona na lingabo e tolu. Ki tani kemikemihia matoto na Kalohua Kemi, ki padea poloka manumanu na vuna na goloaloa kua bukuna kingdom ke Vuvu. ");
INSERT INTO wiv_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Palaka manumanu taza ni dia beta matoto ni kulidia dia kata longoria kana polea, ki beta ni kulidia dia kata bilip, dia ka pole zahatia na Dala kana Paraha na matana manumanu. Kubarae a Pol ia vatia na haus lotu ke vuni Iuda kua, ia pelea na nuhu kua dia ta bilip kamana. Dama laveve ki vavala polea kana Paraha ni dia na haus sikul ke Tiranes. ");
INSERT INTO wiv_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Krismas e rua a Pol e gala barae kua. Kubarae a vuni Iuda laveve kamana nuhu kua beta dia na lala a Vuvu ve kua dia ta mimia na provins a Esia, dia laveve dia ta longoria na polea kana Paraha. ");
INSERT INTO wiv_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Na limani Pol a Vuvu e katia na mirakel kapopou luba, ");
INSERT INTO wiv_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","manumanu dia ka lala dia kata pepelea na hegesip beu tuhutuhura lavalava barae, dia ka vakulia livuhani Pol vona, dia ka pelea goloaloa kamahi kua dia ka vano bizia livuhana nuhu kua e mazahitidia, dia ka kemikemi mule. Na vule zahazaha kua e hoholiholidia ve dia ta gotalatala ve ni dia. ");
INSERT INTO wiv_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","A vuni Iuda taza, dia ta lala dia kata lobi dia na pepele kakava na vule zaha na manumanu. Dia ve dia ta parakilania dia kata kohania hizana Paraha a Iesus, dia na pele kakava vule zaha vona na nuhu kua na vule zaha e holiholidia. Dia ta lala dia kata tatani barae, “Na hizani Iesus, kaka kua a Pol e lala kete vavaketekete vona, ta tania ni ho mai nu gotala na kaka kua.” ");
INSERT INTO wiv_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Kaka katiu hizana a Skeva, ia hetpris ke vuni Iuda, ia na habu tutuna e 7 kua dia ta lala dia kata kakatia na moge kua. ");
INSERT INTO wiv_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Boto katiu na vule zaha ia tania kiridia, “A Iesus, hau ta lala, a Pol ia hau ta lala ve, pele miu a vuni ve matoto kua?” ");
INSERT INTO wiv_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Pale, na kaka kua na vule zaha na poloka ia divurutia ia raga taduridia, ia vaihubi kamadia. E hubi zahazahatidia matoto, ki dae tere kadia zohozohoa kamahi, dia ka pupu lavevea, dia ka rovo gotalatala na ruma. ");
INSERT INTO wiv_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Tania a vuni Iuda kamana nuhu kua beta dia na vuni Iuda matoto kua dia ta mimia ni Efesus, dia ka longoria na rereka goloa kua e bele, kuahia kapou ki bele ni dia, dia ka vazahenia matoto na hizana Paraha a Iesus. ");
INSERT INTO wiv_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Nuhu laveve kua dia ta bilip dia ta mai, dia ka tani kakava kadia moge zahazaha laveve kua muga dia ta lala dia kata kakatia, na matana manumanu laveve. ");
INSERT INTO wiv_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Dia luba kua dia ta lala dia kata tataetae dia ka lai muli, dia ta vilehia kadia buk laveve na taetaea dia ka tunia na matana manumanu laveve. Kua ni salianga buk kamahi kua, da monina e bele 50,000 moni silva. ");
INSERT INTO wiv_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Pale, na polea kana Paraha kini gala matuha matoto na poloka manumanu, dia kene lobia palakalaka kamahi dia kene vavala polea kana Paraha. ");
INSERT INTO wiv_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Muri na goloa laveve kua e bele, a Pol ia lohoia kete zahe kiri Ierusalem. E lohoia kete vavana ki vano ni Masedonia ki vano ve ni Akaia ba muri kini vano bele ni Ierusalem. Ia ki tani barae, “Ba muri na kua, da ta vano ve ni Rom.” ");
INSERT INTO wiv_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ia geria kana kaka rua kua hiro ta lala hiro kata kokodonia, a Timoti hiro a Erastus, hiro kata muga vano kiri Masedonia, ia ki mia pitu ni Esia. ");
INSERT INTO wiv_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Kilaka kua ia na manumanu taza dia te varivuvu dia keteni pole zaha kara Dala kana Paraha dia kene katia varikoria kapou. ");
INSERT INTO wiv_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Kaka katiu hizana a Demitrius, ia e lala kete katikati na haus lotu kotekote, na hanunuka haus lotu kana kadia vuvu tavine a Artemis, na silva. Manumanu kua dia ta gagala kana dia ka katikati na hanunuka haus lotu kua, dia ta lala dia kata pepele maratania moni na galanga kua. ");
INSERT INTO wiv_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Kubarae, na kaka kua ia koi lupunia manumanu laveve kua dia ta gagala kana, kamana nuhu motumotu ve kua dia ta lala dia kata katikati ve na hanunuka haus lotu kana vuvu tavine kua, ia ki tani barae ni dia, “E miu, miu ta lala, tolu ta lala tolu kata pepelea moni kapopou na kadolu bisnis kua. ");
INSERT INTO wiv_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Miu ta hadavia miu ka longoria nazia na kaka kua e kohanga ni Pol e kakatia? Ia ti pado pokizia poloka manumanu luba matoto ri ni Efesus, ia mai ve na palaka laveve na provins a Esia. Ia e tatania habuka na vuvu kua tolu manumanu mule tolu ta lala tolu kata kakatikati na limadolu mule, e beta ni na vuvu matoto. ");
INSERT INTO wiv_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Ki vano ve, beta ni habuka kadolu bisnis kamahi za kua da e varipokeai, palaka na tempel kana kadolu vuvu tavine kapou matoto kua a Artemis, da ti kara goloa vetanga. Ia mai na kadolu vuvu tavine kua ve, da ti beta keteni ma lolotu voa vonanga na palakalaka laveve kua na provins a Esia, ia mai na malala laveve na vulovulo. Da ti beta keteni hada lalanga habuka ia na vuvu matoto.” ");
INSERT INTO wiv_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Kamana na manumanu dia ka longoria na polea kua, magalidia ki varitihi matoto dia ta goe kapopou dia ka tatani barae, “A Artemis kahita vuvu tavine bukuni Efesus, ia e hizanga matoto!” ");
INSERT INTO wiv_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Kubarae na manumanu dia ka goe mai vano na poloka taon. Dia ta di madi dia ta paho taduria a Gaius kamani Aristarkus, kaka rua kua hiro ta kamani Pol dia ka pe ni Masedonia dia ka mai, dia ka rovo kamahiro dia ka vano hoho kara palaka kua dia ta lala dia kata lulupu vona. ");
INSERT INTO wiv_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","A Pol ki parakilania kete vano bele na kabuna manumanu kua, palaka kana disaipel kamahi dia ta talea. ");
INSERT INTO wiv_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Na manumanu taza ve na poloka gavman ni Esia, dia ta lala dia kata kakamakamani Pol, dia ta vala polea ki vano vona ve habuka kete beta kete zahe bele na manumanu na palakana lupua kua. ");
INSERT INTO wiv_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Na manumanu kua dia ta mai dia ka lohu, beta dia na lala vutuhia e kuziha dia ka lohulohu, kubarae, taza dia ka gogoe dia ka tatania goloa katiu, taza kadia ki momotu za. Manumanu luba beta dia na lala e kuziha dia ka mai belebele. ");
INSERT INTO wiv_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","A vuni Iuda dia ta bara katia a Aleksander zahe kara mugana, manumanu taza na kabu kua dia ta tania habuka a Aleksander kete pole dia na longoria. Ia pole na limana ki tania dia kata zodo, dia na longoria kete pole. ");
INSERT INTO wiv_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Palaka tania dia ka hada lala a Aleksander dia ka lala ve habuka ia na Iuda katiu, dia ta goe havutia, dia kene ma gogoe dia kene tatani barae, “Kadolu vuvu tavine a Artemis a vuni Efesus ia e paraha buli matoto!” Na aua rua dia ta goe dia ka ma tatani barae. ");
INSERT INTO wiv_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Na kuskus kamahi kara taon kua dia ta talea na kabuna manumanu kua dia ka tani barae ni dia, “Manumanu bukuni Efesus, karae beta manumanu laveve na vulovulo dia na lala habuka na taon kua a Efesus ia na taon kua e hahada poto na tempel kana vuvu kapou matoto kua a Artemis, kamana hanunuka kua e dua na lagato ki ziho? ");
INSERT INTO wiv_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Ki kuza barae, beta ni paritigi goloa kua, ki mara beta kaka katiu ni tania beta ni matoto. Kubarae miu tabaria havamiu. Tabarae ni hurihurimiu miu kata katia goloa katiu