﻿USE sofia;
DROP TABLE IF EXISTS sofia.wiu_vpl;
CREATE TABLE wiu_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES wiu_vpl WRITE;
INSERT INTO wiu_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ipa Yesu Keraisu one kaua-mikiti opia tagama nekenemo. Yesu onepa Depidi-loeke tagene ago. Depidi onepa Eberame-loeke tagene ago. ");
INSERT INTO wiu_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Eberame onepa Aisakene etene. Aisake onepa Yekobene etene. Yekobe onepa Yudaneka Yudane wamene-mikitaneka etene. ");
INSERT INTO wiu_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda onepa eya agota Peresi Siratane etene. Einagotapa nine Temayo opianeya. Peresi onepa Eserono etene. Eserono onepa Ramene etene. ");
INSERT INTO wiu_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Rame onepa Aminadapene etene. Aminadape onepa Nasonono etene. Nasono onepa Salomonono etene. ");
INSERT INTO wiu_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salomono onepa Boasine etene. Boasi onepa nine Reapeyo opianeya. Boasi onepa Obedene etene. Obede onepa nine Ruseyo opianeya. Obede onepa Yesine etene. ");
INSERT INTO wiu_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yesi onepa ali atoa lukoa meane tobou ago Depidine etene. Depidi onepa Solomonono etene. Solomono one ninepa namolo Yuraiane natonoke Depidiyo motaneya. ");
INSERT INTO wiu_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomono onepa Riaboamene etene. Riaboame onepa Abaisane etene. Abaisa onepa Esane etene. ");
INSERT INTO wiu_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Esa onepa Yosopasene etene. Yosopase onepa Yoramene etene. Yorame onepa Usaiane etene. ");
INSERT INTO wiu_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usaia onepa Yosamene etene. Yosame onepa Easine etene. Easi onepa Esekaiane etene. ");
INSERT INTO wiu_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esekaia onepa Manasane etene. Manasa onepa Emosine etene. Emosi onepa Yosaiane etene. ");
INSERT INTO wiu_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosaia onepa Yekonaiane etene ni Yekonaiane wamene-mikitane etene. Einapetepa Iserele yene mone Babilone take aua nidikoa pekeneya. ");
INSERT INTO wiu_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Nititikaneyake Yekonaiayo Sialetiele opianeya. Sialetiele onepa Serababelene etene. ");
INSERT INTO wiu_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serababele onepa Abiudene etene. Abiude onepa Elaiakemene etene. Elaiakeme onepa Esone etene. ");
INSERT INTO wiu_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Eso onepa Sedokene etene. Sedoke onepa Ekimene etene. Ekime onepa Eliudene etene. ");
INSERT INTO wiu_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliude onepa Eleasane etene. Eleasa onepa Masanene etene. Masane onepa Yekobene etene. ");
INSERT INTO wiu_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yekobe onepa Yosepene etene. Yosepe onepa Mariane ana. Mariayo Yesu opianeya. Yesu einagopa Keraisu wa ibini akene ago. ");
INSERT INTO wiu_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Nipa Eberameke titimoa Depidike tugoapa opia tagama nekene ali-kitipa ali leme kakoa (14) ibini akene ali-kama wia mekaneya. Ni Depidike titimoa Yu yene Babilone take aua nidikoa pekene-pete tugoa opia tagama nekene ali-kitipa nika ali leme kakoa (14) ibini akene ali-kama wia mekaneya. Wa Yu yene Babilone take aua nidikoa pekene-pete titimoa Keraisuke tugoa opia tagama nekene ali-kitika ali leme kakoa (14) ibini akene ali-kama wia mekaneya. ");
INSERT INTO wiu_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesu Keraisu opikilepa eya taneya. One nine Maria Yosepene tu pia kakene atoa Yosepeke wete poameneyake one mati kakedeka. Enipa Epetane Yominiyo taneya. ");
INSERT INTO wiu_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Mati kakeneya mekale enekome one poatekago Yosepe wene ki̱yo akene ago tokome i atoa ya takamouno, ne wakuno, pa wane wetekakeneka ali atoane lene yoto wetekamou wa wene pia meaneya. ");
INSERT INTO wiu_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Nitoa mekaka Ali Munono edelo ago Yosepe pule pitikata nokome okome Depidike tagene ago Yosepe Maria neke natono moa latikade piti moamea. Mati kakenepa Epetane Yominiyo taneya tokolo ni uku. ");
INSERT INTO wiu_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Mariayo ali mati opikale one ibini Yesu wa oade toko. One yatenepa kini tokoi poaneleme kiwi moa labaneya kakoita toa moo tokolo tekene ni uku wa edelo agome oa pekeneya. ");
INSERT INTO wiu_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Enipa Ali Muno agono agale to̱awea akane agome papete wia mekapiane toa taatekamotoa enika enile tootapeneya. ");
INSERT INTO wiu_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ali poamene tuatoa mati kakeneya mea ali mati opikale Imanuele wa ibini oi wa wia mekapianeya. Imanuele wapa Akolali toto-pala opia meko wa ekete oko. ");
INSERT INTO wiu_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yosepe pule pitikata kamoa pokome Ali Munono edelo agome tamene wa okana toa tokome natono Maria enemotaneya. ");
INSERT INTO wiu_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Nitoapa mati wete opiameneyakepa koua piameneya. Nitoa mekale ali mati opikale Yesu wa ibini akeneya. ");
INSERT INTO wiu_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesu opikilepa tobou ago Erodeyo Yudea ta talo toa meka-pete eni ta keneke piko Beseleme take opianeya. Nititikaneyake a tibuke tagoi yakome tokale enoai tane ago-mene lou witia noko lono ta tetemada kawa Yerusaleme take nekete ekete ");
INSERT INTO wiu_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Yu yenane tobou meateko ago eni mati opikilepa maida taneya-pe. Eni mati opianeya tadeko wa wene tomotoa tokome weneya tagoi pade witia nome kakale enekoya tekete one pikota wadini tukuadete noko wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Nimo okoli yatekete Yerusaleme take ako tobou ago Erodeyoka ete ali atoa peyameka ekete ekee enidopa edemo iki patu wa wene keda taneya kakeneya. ");
INSERT INTO wiu_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Nitoapa one mekuta Akolalike lodo yoai tane ali-kitika kini totono pine to̱a olaukane ali-kitika kiwi peya noe wa Erodeyo kayo oa motokome okome Keraisu wa papete ibini oa piane ago mani take opianeya pioo-pe-kale ekete ");
INSERT INTO wiu_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","one opiateko tapa Yudea ta keneke piko Beseleme ta. Enikepa Akolaline agale to̱awea akane ago padame eya wa wia mekapianeya. ");
INSERT INTO wiu_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Yudea ta keneke piko Beseleme ta nepa de ta deyake Yudea ta keneke eni pitikalimepa nepa paya tetepo takameamele toamoo. Wida neeke ta̱wateko ago pade ako odene meko tobou agomepa sipi sipi kai talo tou toa anu Iserele yene peya talo takoa kawoo wa einagome wia mekapianeya wa e ali-kitame Erode-pala akeneya. ");
INSERT INTO wiu_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Nimo okoli yakatekoapa wene muno kakeneya meane ali-mene one kidene mekuta noe wa agale poti lukatekoa oa wetekakale nokoli okome wini tagoipa manipete titia witia noka-pe wa yakatekoa okome ");
INSERT INTO wiu_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","wini matipa tuku-kama tokoa kawatino, poe. Noanuka eni mati pikota neuwe tukupiane kei piouno, enamutuketepa wete no oto onoatino, poe wa Beseleme take wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Nitikale yakamotekete pokoli lou witia noka lono titia kakale enekoina tagoi namolo kawa pekeneya. Namolo kawa pome eni mati meka yapu pitia tibuke yateta pome kapaneya. ");
INSERT INTO wiu_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Yateta pome kakale einali-mene mati meka yapu pote enekoli eni mati nine Maria-pala mekale enekete wadini tukupia kei pia kakeneya. Nitoapa kini kamo taneya kake ua nootokaneya ya̱wa moa mati metekilepa golo kue yomo page ka̱lono taneyata mekala taneya. ");
INSERT INTO wiu_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Nitimotekete kini take wakapea peketepa Erode mekata koekoa padeka lono katekoa pekeneya. Nipa kini pitikoita Akolaliyo pule metekanakale toa nitaneya. ");
INSERT INTO wiu_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nititikaneyake Ali Munoyo moa wetekane edelo agome Yosepe pitikata pule menokome okome tobou ago Erodeyo wini mati wiademe tuku toa kakono, wete kamoa wini mati nina-pala aua Idipi take to̱a poe. Oto wakapea ipete noe wane okou-peteka eida nepia meatino poe wa pekeneya. ");
INSERT INTO wiu_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Nitikale Yosepeyo eni mati nina-pala aua likonu kamomotokome pitoa pome Idipi take pome mepaneya. ");
INSERT INTO wiu_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Mekomepa Erode tukaleka pa eida meaneya. Enipa Ali Munagome one agale to̱awea akane ago imo akamene wa akene toa taatekaneya. Eya wa akeneya. Anu mana Idipi take meaneya kayo oane mou. ");
INSERT INTO wiu_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Eni wene muno meane ali-mename Erode yotokatekoa kini take wakapea pekedekoli yatekome Erode kotimi yotaneya kaka matiyame eya taneya. One poyo ali-kiti Beseleme take moa wetekakome okome Beseleme takeka eni ta unukoa piko takeka meki mati-kiti mali takuta ponamene mati peya wia tukakapoe wa wetekaneya. Nipa eni wene muno meane ali-menamepa tagoi ipete witaka wa okoina wene tokome taneya. ");
INSERT INTO wiu_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Nipa Akolaline agale akane ago Yeremaiayo papete oa piane toa taatekaneya. Eya wa oa pianeya. ");
INSERT INTO wiu_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Rama take padame komo okomokale yakaneya. Nipa tumai mekome komo ka̱ oa kakeneya. One mati-kitike Resele komo ka̱ oa kakeneya tokome padameka one eni ela oyake teigakamele toameneya. Nipa one mati peya tuutapeneya tokome taneya wa Yeremaiayo oa piane toa taatekaneya. ");
INSERT INTO wiu_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Erode tuutukaneyake Ali Munono edelo ago pade Yosepe pitikata Idipi take nome pule menokome okome ");
INSERT INTO wiu_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","wini mati wiadete tuku tokoa kakoina ali-kitipa tuutapeneyano, wini mati nina kini Iserele take wa aua poano, wete kamoa pono wa pule mea pekeneya. ");
INSERT INTO wiu_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Nitikale kamomotokome eni mati nina kini Iserele take koua wakapea pekeneya. ");
INSERT INTO wiu_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Koua poademe pokome yatekale tobou ago Erode luku manago Akeleasi mekome Yudea ta yopia meko wa okoimo kugu yakatekoa eni take wakapea pome mepamene piti tokale Galili take pome mepaneya. Nipa edelo ago padame Yosepe pitikata pule metekome okana toa ");
INSERT INTO wiu_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Galili ta keneke piko Nasarese take pome mepaneya. Nipa Akolaline agale akane ali-kitamepa i to̱aweane uku matipa Nasarese take ago wa ibini oi wa oa piane toa taatekaneya. ");
INSERT INTO wiu_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Enipetepa ue motokama yakene Yone Yudea ta pikoka ali piamene lono taatekoa nokome eya wa mo wima yakeneya. ");
INSERT INTO wiu_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Akolali a tibu meko agome ali atoa keleyo talo toateko tigotokono, kini tokoi poanele tewitikoa wawe wa mo wima yakeneya. ");
INSERT INTO wiu_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Nipa Akolaline agale akane ago Aisaiayo papete eya wa wia mekapiane toa Yone taatekaneya. Ali piamene ta ludu panagome eya wa mo wima yawoo. Ali Muno noateko ka nodokakapia one yawateko ka-kitika ki̱yotokakapia toatino toe wa taatekoa nokome oo wa Aisaiayo Yoneke oa pianeya. ");
INSERT INTO wiu_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yone einago taatekoa nokome kamelo kai pineme latiane mamina kawa one matiuka pitimekawe kai kepeneme latiane matiu kawa taneya. One nakene neepa apio-pala koeyapo ego ueta-kama nokala taneya. ");
INSERT INTO wiu_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Nitane ago yakadete eya yene Yerusaleme takeka Yudea ta keneke piko ta-kitikeka Yodane ue liti piko ta-kitikeka mekoi-kiti one mekata nokala taneya. ");
INSERT INTO wiu_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Nitoapa kini tokoi poanele i i wa to̱awea ootapekoli nipa ue moe wa Yodane uele kakome ue motokakala taneya. ");
INSERT INTO wiu_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","8","Einata einapete Parisi ali-kitameka Sadusi ali-kitameka ue moadete nokoli enekome okome beita, kipa kayane yagono-mikiti. Akolaliyo kibu moateko tigotoma nokono petoatino oto ita poe wapa teyo pubu okolo niki-pe. Kini namolonakaledo tewitikoa wakedekolipa nipa ali atoame enemotono, epetanele toma pamene. ");
INSERT INTO wiu_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Eya wa wameamene. Kipa Eberamene kaua-mikiti mekono, Akolaliyo edoa kibu momotoa-pe wa wameamene. Akolaliyo i piko kue wane-kiti moa Eberamene mana-mikiti oyake latikakamele toko. Nitamele tokono, kipa Eberamene kaua-mikiti meko wa edoa mate agale oadete-pe. ");
INSERT INTO wiu_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Yomo-kiti ku̱ tuameadekale pinagome tue moa ka̱wa toele pitikoo. Kipa tueme ka̱wa pitikateko tigotokolo tekene ni uku. ");
INSERT INTO wiu_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Noanumepa kini namolonakale tewitikoa wamotoane tekene pa ue motokaku. No litimotokakome ele kule telekole toa no moa patukako ago noademe toko. Nopa pa ago tekene one kawa yeneka oyake pikoa katekamele toamoko. Einago nokome ali atoa pa ue motokameneya Epetane Yomini-pala toeta motokademe toko. ");
INSERT INTO wiu_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Witi ku̱ takoa motokagome-kiti one tapepora moa nokome witi ku̱ witikatekoapa yaku pupulegeme popokoa aua pomotoa tokome pokotoa ate pitikakala too. Nitoapa ku̱ pitoa auma kakale witi ku̱ lobutua piko yapu keneke moa pitikoai too. Ni yaku koukoa moapa nokoa-kama kako toe mine pitikoai too wa Yoneyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","14","Yesu Galili ta tewitikoa Yodane ue yotoko lono Yone mekata nekeneya. Yoneyo ue motokamotoa tokome ni nekeneya. Nitikale ue motokamademe wakome okome uepa neme no motokamedekono, anume ne edoane ue motokamotoa-pe wa okale okome ");
INSERT INTO wiu_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","mena, opipa ue motokoa wane i nukuna. Akolaliyo ta wa okale-kama tamedekolo tekene ni uku-kale okome nipa nitouno ta wa ue motokaneya. ");
INSERT INTO wiu_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Nitikale Yodane ue matanu pogatekoa pokome enekale eina eina tibu patetepikale Epetane Yomini ini weuwe keneya a tibu mea nome oneke pitanokale enaneya. ");
INSERT INTO wiu_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Nitikale a tibuke agale ludu nokome okome wini agopa anu kolotini ago, anu managono, one tokoleke kolotine meku wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Nititikaneyake Epetane Yominiyo Yesu ali piamene take koua pokomepa Setanuyo likoa enemotoa tokome aua pome mekapaneya. ");
INSERT INTO wiu_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Nitaneyake ta pataka padeka noi kakoa (40) ponoka toa nee nakileka toameneya kobu tokale meaneya. ");
INSERT INTO wiu_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Kobu tokale meaneya Yesu likoa enatekago nokome okome ne Akolaline mana tadekalepa nipa ika i piko kue-kitipa neke noateko palawe wane-kiti latiano ta wa likoa enekome okale okome ");
INSERT INTO wiu_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","eya wa wia mekaneya pikono, yaka. Mea kawadetepa pa nee-kama moa noameneya Akolaliyo oka toa-kama yakoa moamene wa wia mekaneya piko wa Yesuyo okale ");
INSERT INTO wiu_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Akolaline Yerusaleme take aua pome tobou losu yapu muno waneke moa kakakome okome ");
INSERT INTO wiu_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ne Akolaline mana tadekalepa ita kawa keika tiga-na. Neekepa Akolaline bokuke eya wa wia mekaneya pikolo tekene ni uku. Akolaliyo ne i agopa wedoa yopia kamene wa one edelo yatene yameoo. Nitikale ne tugoa ogo eya nakaya tokale kini yoname lekamonoi. Enimopa Akolaline bokuke wia mekaneya pikono, nepala padeleka toamoono, tigaketika wa Setanuyo likoa enekome okale okome ");
INSERT INTO wiu_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Akolaline bokuke eya waka wia mekaneya piko. Neke Ali Muno Akolali likoa enameamene wa wia mekaneyano, wini okole toamou wa wakeneya. ");
INSERT INTO wiu_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Nitaneyake Setanuyo Yesu aka mati kakene tono tobouke moa aua pome kakapaneya. Nitoapa ako tobou ali-kitame yopiane ta piko peya ni eni ta-kitike koniyoya peya yametekome okome ");
INSERT INTO wiu_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","anu kawane pitalogake no kowitikalepa nipa eni ta piko peya ne ako odene tobou ago meke talo toa wane yametapeouno ta-kale okome ");
INSERT INTO wiu_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Setanu ne ete pa. Akolaline bokuke eya waka wia mekaneya pikono, yaka. Neke Ali Muno Akolali einagoke odene nate wene pianeya mea kowitamene. Losule tikilepa onekele odene takoa tamene wa Yesuyo okale ");
INSERT INTO wiu_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Setanuyo Yesu tewitikoa pokale edelo ali-kiti one mekata note auapenaneya. ");
INSERT INTO wiu_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","13","Wa naniko Yone po yapu pitikaneya wa okoimo kugu yakamotokome Yesu Galili take wakapea pome mepaneya. Nitoapa eida me me toomotokome Kapaneame take pome mepaneya. Eni taapa Galili ue matanuke latiane ta. Sebulane Napesalai tata keneke piko Kapaneame eni take pome mepaneya. ");
INSERT INTO wiu_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Nipa Akolaline agale akane ago Aisaiayo papete eya wa oa piane toa taatekoa taneya. ");
INSERT INTO wiu_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","16","Sebulane ti-pala Napesalai tita kipala eya wane ukuno yakamene. Kini wini Galili mine lonoka Yodane ue lonoka mone yatene awia note mekala tokoiyake eya wane uku-ye. Wini take yomiyomu keneke mekete enekoli pa̱ tokaya tubeya wane witakale enoi. Yomiyomu katoganeya tuadete meou toa pa meki-kiti wida mekika pa̱ pitatapeademe toko wa Aisaiayo Akolaline bokuke papete wia mekaneya. ");
INSERT INTO wiu_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Eni agale taatekoapa enipete titimoa Yesuyo mo wima yakome okome Akolaliyo kiwi talo tokole keleyo witateko tigotoma nokono, kini namolo wene wia wamene wa oma yakeneya. ");
INSERT INTO wiu_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesu Galili ue mine matanu ludu kokotoma ponokome enekale ali takuta odene wamename mou tagi toa kakoli enaneya. Panago Saimone one pade ibini Pita wa akene ago wamene Aderutame kini tanele tekete mou tagi toa kakoli ");
INSERT INTO wiu_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","enekome okome mou tagi toa kawou toa ali atoa motokakete toatikile olaukouno, no litima noe wa okale ");
INSERT INTO wiu_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","eina eina kini tagi ka eida tewitikalogoa litima pekeneya. ");
INSERT INTO wiu_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Nitaneyake Yesu kutu pokome enekale odene wamena Yame Yoneta etene Sebedi toa ue dipike mekoli enaneya. Einagota kiniketai-pala ue dipike mekete tagi ka pilianeka lipua mekoli enekome okome yukuyagota wete noe-ye wa kayo oma ponokale ");
INSERT INTO wiu_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","eina eina einata kiniketai ue dipike memotoa Yesu litima pekeneya. ");
INSERT INTO wiu_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu Galili ta ludu pima yakomepa losu yapu kaka toa pome olaukoa ni Akolaliyo ali atoa talo tokole i i wa kini wene epetekanemo oma pome ni eya kuya kini tane yene peya latekatapea taneya. ");
INSERT INTO wiu_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","One eni toma yakenemo Siria ta ludu oa puputikatapeneya tokale dikane notokane yene taneya meane ali atoa one mekata note koukoai taneya. Nipa yeneme tukete tete mokoa kakene-kiti ni ipono awitaneya meane-kiti ni leau akeneya meane-kiti ni kawa yonota wia mekaneya meane-kiti enika eni ali atoa kini oya-laweme Yesu kakata aua nokala tokoli latekoa wetekakala taneya. ");
INSERT INTO wiu_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Nitaneyake ta piko peya Galili ta Dekapolise ta Yerusaleme ta Yudea ta Yodane ue lou witia noko lono piko ta enika eni ta ludu pitane ali atoame one litima penaneya. ");
INSERT INTO wiu_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","2","Eida oboa kakoi-kiti enemotokome Yesu tono pade lewia aya waneke pome mepoka. Nitikata one oyali-lawe note mekoli one tepene meaneya ya̱wa eya wa olaukoa meka. ");
INSERT INTO wiu_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Kini weneme Akolalinele nateleka takamele toamoko wa oneke-kama wene tuganeya meki-kiti kolotine meati wane uku. Akolaliyo one pawe toa talo toko taapa kinino, noe wa kiwi yameoo tokolo tekene ni uku. ");
INSERT INTO wiu_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Komo oa tumai keneya meki-kiti kolotine meati wane uku. Akolaliyo kini eni ela teigoo tokolo tekene ni uku. ");
INSERT INTO wiu_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ni poti wene pianeya mea utanele-kama toa meki-kiti kolotine meati wane uku. Ta piko peyapa kini wa Akolaliyo kiwi yameoo tokolo tekene ni uku. ");
INSERT INTO wiu_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ue nodome-kiti tuaneya meou toa Akolaline ki̱yo akene peku-kama noadiya wa wene pia meki-kiti kolotine meati wane uku. Akolaliyo one eni peku lawetekale noa tagatapeoi tokolo tekene ni uku. ");
INSERT INTO wiu_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ete ali atoa kibu moameneya yono lukoa meki-kiti kolotine meati wane uku. Akolaliyo kiwika kibu moameneya yono lukoa meoo tokolo tekene ni uku. ");
INSERT INTO wiu_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Kini tepene poane wene takoa koikatapeneya meki-kiti kolotine meati wane uku. Eni ali atoame Akolaline lene timini enoi tokolo tekene ni uku. ");
INSERT INTO wiu_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Poi ete oto wa te̱itakutukoa meki-kiti wini poi wia pitikoe wa moa kawikama piki-kiti kolotine meati wane uku. Akolaliyo kipa one mana kono-mikiti wa oo tokolo tekene ni uku. ");
INSERT INTO wiu_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Akolalinele takama yawou wa ki̱yo akenele toma pikileke tete moma piki-kiti kipa kolotine meati wane uku. Akolaliyo one pawe toa talo toko taapa kinino, noe wa kiwi yameoo tokolo tekene ni uku. ");
INSERT INTO wiu_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","12","Anukule takama yakike ete ali-kitame tea agale oa tete mea i yene kime poanele tiki wa kapene agale oa tikilika kolotine meati wane uku. Nitikikepa a tibu pine epetaneya-kama enatikiyano, nitoa kamotono, ke wa kolotine meati wane uku. E yename kiwi tete eni metekipa nipa kini kaua-mikitame papete Akolaline agale to̱awea akane ali-kiti tete mema nekete tane toa totoka opi nitikino, ke wa kolotine meati wane ni uku wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Kipa ali atoane nee eyake takoa nakina to wane adeka piane uku. Too pade me pokome meke toamokolopa edoa wa meke takamotoa-pe. One me pekeneya tokome toatekale piamokale pinagome akolono paka ka̱ua mitapeoo. Nitaneya pikale tokome ali atoame kautoa witia wawei. ");
INSERT INTO wiu_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Anu oya-lawe kimepa ta piko peya meki-kiti pa̱ takatikiya wane adeka piane uku. Ali atoame tono toboukedo ta latikolipa nipa keleyo eni latianeya kawoo. ");
INSERT INTO wiu_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Panagome-kiti one labo tole udukakomepa okolo petene moa kautalogakoya mena. Nitameneya ali atoa yapu mekita pa̱ keleyo toa kamotoa tokome labo piatikita moa piko. ");
INSERT INTO wiu_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Eina toa yete pade ali atoa pa̱ takama pamene. Kini Akolalinele epetekoa takama pikile enekete a tibuke meko Atai Akolali-pala ke wa oa one kei pia tomotono, nitamene wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Mosesene totonoka Akolaline agale to̱awea akane ali-kitane agaleka no i agome katekoa wawademe noko wa wene piameamene. Enile toadene nokouya mena. Kini oa pianele taatekoane toadene ni nuku. ");
INSERT INTO wiu_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nipa eya wa wene taneya meamene. Tibu itonota wete takoa poameneyake eni totono wia mekane toa etene nateya bi mekamu tane-kitika pake katekapitikoa wawameneya pa pia kawoo. Nipa Akolaliyo papete wene toopianele peya wete taatekameneyake pa pia kawoo. ");
INSERT INTO wiu_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Eni totono piko toa natele deyaka katekapitikakome litia toameamene wa olaukako agopa nipa Akolaliyo ali atoa talo tokome dikako ago etene keku ago tetepo takoo-mo. Wa eni totono piko toa natele deyaka katekameneya peya litia tootapekome ete ali atoa kimeka litia tootapeamene wa olaukako agopa nipa Akolaliyo ali atoa talo tokome dikako ago etene ako ago tetepo takoo-mo. ");
INSERT INTO wiu_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Akolalinele takaku wa wene piketeke kini totono pine to̱a olaukaki ali-kitameka Parisi ali-kitameka onekele takakete tiki toado moa patukameketepa Akolaliyo talo toko take edoa pote mepadete-pe. ");
INSERT INTO wiu_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Yete pade ali atoa wia tukameamene, ni panagome panagodo wia tukakalepa kini take koiso yatekaka ago mekata lia aua pamene wa papete olaukama nekeneya-mo. ");
INSERT INTO wiu_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Noanume eya wane wini ukuna-ye. Panagome one oya ago-pala kotimi yotokalepa nipa koiso yatekakago mekata lia aua pamene. Wa panagome pade ago-pala nepa lu̱ oko ago wa-kitido tedu metekalepa nipa tube koisoke Kanosolo ali-kiti mekoita lia aua pamene. Wa panagome panago-pala nepa nego noma yako ago wa poanemo okomepa nipa tukome poane take toe mine mekota poo. ");
INSERT INTO wiu_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Nekeya pade Akolalike lodo yoai tiki walaike eida aua poke meade kakedo panagome nepala pademo oatekamo nami kakono wene tekepa eya topamene. ");
INSERT INTO wiu_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Nekeya eida tewitikalogoa einakago mekata peke odene weneta piata wa amene. Odene weneta piitakutukoapa wakapea noke nekeya Akolalike lodo yonamene. ");
INSERT INTO wiu_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Panagome-kiti i ago neme poanele tokanano, neke eina tokanakale koiso pitia yatekagome pitia yatekamotono, nee noo wa enemotokale opiado pekepa eya wa oa tamene. I ago ame koiso wamatono, odene weneta piata wa oa enamene. Nitameneya eniledo toamokalepa nipa einagome koiso yatekakago mekata lia aua poo. Nitikale koiso yakatekoapa ne i ago po yapu pitikapoano pa wa poyo ago moa metekale moa pitikapoo. ");
INSERT INTO wiu_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nitikale neke take oto noateka kuedo odene tuane kue waneka katepitoa toamokalepa eida pa pia kawoo. ");
INSERT INTO wiu_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Mone padane atoa koua piameamene wa papete olaukama nekeneya-mo. ");
INSERT INTO wiu_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Opi noanume eya wane wini ukuna-ye. Panagome pade atoa pa one leneme enetekoa ei einatoa kouane piadiya wa wene pikopa nipa wete eni koua pitane tetepo takakome toko. ");
INSERT INTO wiu_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Neke nimini yono lono kako leneme pinali ne toa potokakolopa wete to̱a wamene. Neke leneta takuta kakeneya poane take moa pitikaneya mekaya tokale neke eni poane lene wete to̱a wamene. ");
INSERT INTO wiu_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Neke nimini yoname pinali ne toa potokakolopa nipa eni yono te̱ia wamene. Neke yonota takuta kakeneya poane take moa pitikaneya mekayano, neke eni poane yono wete te̱ia wamene. ");
INSERT INTO wiu_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Neke atoa wawadepa nipa namolo takoa ne wakene wakuna wa pipia wia meetekoapa pa wa wetekamene wa papete olaukama nekeneya-mo. ");
INSERT INTO wiu_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Opa noanume eya wane wini ukuna-ye. Atoame eko ali kode noameneyake aname pa wado wakomepa poanele eni toko. One atoa pade alike edoa pomotoa-pe. Atoa pade alikedo pokomepa poanele onemeka toko. Nipa one aname tokoleke atoameka poanele eni toko. Eko agome wakene atoado panagome motokomepa nipa mone moamateko atoa eni motoko. ");
INSERT INTO wiu_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Eya wa papete olaukama nekeneya-mo. Padele-kiti toade iya ti̱a eya ti̱a wa neke oka toapa kotu kakoa tamene. Padeleka wene kayapea katekameamene. Ali Muno ti̱a waka neke oka toa-kama tamene wa papete olaukama nekeneya-mo. ");
INSERT INTO wiu_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Opipa noanume eya waneka ukuna-ye. Padele toadepa iya ti̱a eya ti̱a wa ikile toameamene. Padele toadepa tibu ti̱a wa wameamene. Tibupa Akolaliyo ali atoa talo toa one mekoya tokolo tekene ni uku. ");
INSERT INTO wiu_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Padele-kiti toadepa itono ti̱a wa wameamene. Itonopa Akolali one kawa pogakoa mekoya tokolo ni uku. Yerusaleme ta ti̱a waka wameamene. Eni taapa ako odene meko tobou agono ta tokolo tekene ni uku. ");
INSERT INTO wiu_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Wa padele-kiti toadepa neke tobou ti̱a wa wameamene. Neke toboukepa yo̱e pineka liane pine odeneka witakoa tamele toamoko. ");
INSERT INTO wiu_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Nipa padele tou wa ekepa e̱e tou wa oa, toamadepa e̱'e toamou wa oa tamene. Pademo kibutukakutukoa eya ti̱a kuya ti̱a wa okapa nipa Setanuyo wene meteka toa eke too. ");
INSERT INTO wiu_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Panagome eko aline lene kiime eya wia togakalepa one lene kiime eya topo takoa wia togamene wa papete edikoa olaukama nekeneya-mo. ");
INSERT INTO wiu_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Opipa noanume eya wane wini ukuna-ye. Nepala padele toa potokakago-pala ete poaneleme topo takameamene. Nitameneya panagome neke nimini yono lono waneke witikalepa ewa yono lono wanekeka wia wa yameamene. ");
INSERT INTO wiu_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ni panagome-kiti neke tigini mamina mou wado ne koisoke lia aua pokalepa nipa tokoo kako maminaka moa wa meamene. ");
INSERT INTO wiu_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Panagome one kopapu neme aukoa noo wa dekoa moa aukoa kilomita odeneke lia aua pome kakome ne wakapea pa wa wetekakaleka one kopapu-pala kilomita takutake aua pome pikapamene. ");
INSERT INTO wiu_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Panagome nekeya pade mano wa oikiledo tokalepa nipa eni oikaya meamene. Wa panagome nekeke padeya-kitido nami kakoa moademe okalepa e̱'e, meamouno pa wa pade wameamene. ");
INSERT INTO wiu_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Papetepa eya wa olaukama nekeneya-mo. Neke oya ali atoake wene mekoa meamene. Ni nepala poi te̱iane yene-pala kotimi luaneya meamene wa olaukama nekeneya-mo. ");
INSERT INTO wiu_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Opipa noanume eya wane wini ukuna-ye. Kipala poi te̱iane ali atoake wedoa wene mekoa meamene-ye. Ni kipala toa potokoa tete mea tiki-kitipa Akolali neme auapea ta wa kini kowitikamene. ");
INSERT INTO wiu_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Nipa a tibuke meko Atai Akolaliyo kipa one mana kono-mikiti tetepo takoa yopimotono, nitamene. Akolali einagome ta piko peyake pitiki peya pewe witikome eya toma poko. Epetanele toma piki-kitika poanele toma piki-kitika kini kini mekika ta epetekoa patamotoa toko. Ni ki̱yo akenele toma yaki yeneka ki̱yo wamenele toma yaki yeneka kini kini mekika ta nomotoa toko. Nitikono, eko pade ali atoa mama moa auapeamene. ");
INSERT INTO wiu_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kiwike wene mekoa meki-kiti takoa wene mekoa mekilipa nipa Akolaliyo kiwi edoa kei pimotoa-pe. Beita, takesi kue motokama yaki ali-kitika edikoa ete oto wene mekanali yoma yaki. Poane ali-kitameke nitiki. ");
INSERT INTO wiu_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ete yene enoa wawake kini oya-lawe odene ke wa yono mokala teketepa nipa ete yename tiki toa moa patukakete epetekoa tiki-pe. E̱'e mena. Akolaline peku noamiki yenameka edikakala tiki. ");
INSERT INTO wiu_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Kiniketai a tibuke meko agome ele kule tikilepa epetekoa toateko kotuke-kama toko toa toma pamene. Nipa kipala poanele tiki ali atoakeka wene mekoa meamene wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yete pade ali atoa auapekilepa ali atoane lene yoto kakete toameamene. Ete-kitame kiwi kei pimotoa tekete Akolalinele edikoa takakilipa nipa kiniketai a tibuke mekome ke wa epetanele edoa topo takamotoa-pe. ");
INSERT INTO wiu_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ponopeneya meki-kitido nekeya pade tatia metekepa bera eya wiameamene. Nipa i agome ilepa i tokono enatoe wa yete pade ali atoame ne kei pia ka̱ omotoa toameamene. Wene takuta pianeya meki-kitame kini losu yapu-kitikeka ka katepa luduka ali atoane lene yoto pote kakete nile-kala tiki. Nitikala tikino, a tibuke enileke kini pine edoa enemotoa-pe. Itonokepa ali atoame kiwi kei wete pikoiya tokome wa a tibuke pade pine enamoi. Enipa etene nimini uku. ");
INSERT INTO wiu_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Nekeya pade ponopeneya meki-kitido tatia metekepa pa neke lukoa meamene. Ile tokou wa to̱awea wameamene. ");
INSERT INTO wiu_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Nitikale neketai Akolali padele padele paigakoa tikile eneko ago tokome neke eni tokanakale keleyo topo takoa ke wa ne kei pioo wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Akolali kowitikoa kakepa eya ali-kitame kowitikete tiki toa toameamene. Wene takuta pianeya meki ali-kitame kini losu yapu-kitikeka ka katepa luduka pote kakete keleyo kowitikala tiki. Enipa yete pade ali atoame enoa kiwi kei pimotoa tiki. Enilekepa a tibuke pine edoa enemotoa-pe. Itonokepa ali atoame kiwi kei wete pikoiya tokome wa a tibuke pade pine enamoi. Enipa etene nimini uku. ");
INSERT INTO wiu_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Akolali kowitikepa akolono ali atoane lene yoto kake kowitameamene. Nitameneya neke yapu luku kago ketemoa meke paigakoa poti kowitoa meamene. Nitikale neketai Akolaliyo neke tokanakale keleyo topo takoa ke wa ne kei pioo. Ali atoame padele padele peya paigakoa tikile eneko ago tokome nitoo. ");
INSERT INTO wiu_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Nitoa kowitoa mekepa Akolaline peku noamiki yename tiki toa kowitameamene. Dikane yename Akolali kowitiketepa agale kutu pa wapi kakakutukoa likoa pia kowitikala tiki. Nipa Akolaliyo yatekome kolotini nakale kini kowitikoimo etene yakoa too wa wene pikete tiki. ");
INSERT INTO wiu_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Kime pade nitameamene. Kime wete kowitameneyake kinekitai Akolaliyo kini kowitikete oatikimo i i wa wene toopia mekome tokome kini eni wene moademe toko. ");
INSERT INTO wiu_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","One nitane agono, eya wa kowitikala tamene. Toneketai a tibuke mea kakago neke ibinipa ali atoame paya tetepo takameneya kei pimotono ta. ");
INSERT INTO wiu_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Neke ali atoa pawe toa talo toano ta. Neme ta wa okole-kama a tibuke meki-kitame litia tiki toa itonoke meki ali atoameka edikoa litia tomotono ta. ");
INSERT INTO wiu_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Tone opi noateko neepa neme moa lawetamene. ");
INSERT INTO wiu_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Tone tokoo poaneleke po letu mekakana keetapeamene. Nipa toto-pala poanele tokoi yene kini eni tokoi poaneleke totome po letu mekakoona keetapekete toko toa nitamene. ");
INSERT INTO wiu_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Padele padeleme toto etepea liamomotono, yopikoa kamene. Poanele-kama tokagoke toto toa moamene wa Akolali kowitikala tamene. ");
INSERT INTO wiu_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ete-kitame kipala poanele tokoike po letu mekakoina keetapea ete wa nami wia kibu moamokolipa kiniketai a tibuke mekome kini poanele toma yakoinake po letu mekakana keetapeapa nami wia kibu moamoo. ");
INSERT INTO wiu_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ete-kitame kipala poanele tokoike po letu mekakoina keamoa ete wa nami wia kibu motokolipa kiniketai Akolaliyo kini poanele tokoinake po letu mekakana keamoa nami wia kibu moo. ");
INSERT INTO wiu_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Akolali kowitoane meou wa nee wawa pa meketepa eya ali-kitame tiki toa toameamene. Wene takuta pianeya meki ali-kitame ne wawa pa mekilepa kobu lene kakene tetepo takoa tiki. Enipa ete-kitame ataiya i agome Akolalinele wedoa takama pokona wa kei pia ka̱ omotoa tiki. Nitikino, Akolaliyo kiwi kei edoa pimotoa-pe. Ete-kitame kiwi kei wete pikoiya tokome oneme pade kiwi kei piamoo. Enipa etene nimini uku. ");
INSERT INTO wiu_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Kime Akolali kowitadete nee wawa pa meketepa kini pine tapalome liitapea petome lomukaketikamene. ");
INSERT INTO wiu_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ete-kitamepa kini nee wawa pa meadekoile enamomotono, nitamene. Nitikolipa kiniketaiyo ke wa oa kini tokoinakale topo takoa kiwi kei pioo. Onepa ali atoame padele padele paigakoa tikile eneko ago tokome nitoo. ");
INSERT INTO wiu_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Itonokepa eya kuya kamoya tuku toa oboa piameamene. Enika eniyapa itonoke pikota ti̱yome te̱ia noa lameka yotokatapea kode agome yapu bulukoa nome kode moa aua pome toko. ");
INSERT INTO wiu_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Kime pade nitameneya, kini kamoya a tibuke pala pitikou toa epetanele toma pamene. Kini eni kamoya a tibukepa ti̱yome te̱ia noamoa lameka yotokatapeamoa kode agome yapu bulukoa nome kode moa pikile-kitika toamoo tokolo uku. ");
INSERT INTO wiu_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kini kamoya piko takepa kini wene piitikaneya yakili tekene ni uku. ");
INSERT INTO wiu_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Labo tole yapu pa̱ takalogou toa kini lenetame tepe kolotini eya pa̱ takalogako. Lenetado epetaneya kakepa nipa tepe kolotinika pa̱ tootapeneya kawoo. ");
INSERT INTO wiu_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Nitameneya leneta poaneyatado kakepa tepe kolotinika yomiyomu tootapeneya kawoo. Neke tepe kolotini pa̱ takatekoyatapa pa̱ toameneya kakepa nipa dika dika toamene yomiyomume agopa takatapeneya kawoo. ");
INSERT INTO wiu_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Panagomedo alita takutanele takakome takakomepa panago-pala kotimi yoa pupu takoa wa padena agoke wene mekoa pupu takoa too. Nipa panagoke wene tugakoa mea pupu takoa wa padena ago paya tetepo takoa pupu takoa too. Nipa Akolalinele takaketepa kamole toamadete wawa onekele odene takama pamene. ");
INSERT INTO wiu_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Wa kini kepene mama moameneya meamene. Nipa noateku neepa edoane moane naku patu, noateku uepa edoane nomoane naku patu, kawateku maminapa edoane topo toane motuku patu wa edikoa wene keda taneya meameamene. Akolaliyo kini yomini tiginita tobou kakoa mama moapa kini noatiki nee mamina eya kekuya tetepo takoa yopiko. Enipa nimini ukutu-pe. ");
INSERT INTO wiu_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ini a tibuke pukaneya yakete tikile enekaketepa eya wa wene taneya meamene. Nipa edikakiya. Nee lene matamoa ipe kakoya nee wakoa moamoa kini noatiki nee moa piatiki yapu eya wiamoa tikiyake kiniketaiyo a tibuke mekome talo toa egeteko. Akolaliyo ini eya kekuya tetepo takoa mama moapa anu oya-lawe kiwi akoya tetepo takoa wedoa mama motoko. ");
INSERT INTO wiu_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Anu oya-lawe kiwi panago tuatekou-pete tuamekene lou pini odeneka pa meou wa tepe ate keti enoai tekeka nitamele toamokale tuateka-petepa wete eni tuoono, ");
INSERT INTO wiu_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","kawateku mamina edoane topo toane motuku patu wa wene keda taneya meameamene. Taage kaluga eya li ludu witakole enekaketepa eya wa wene taneya meamene. Nipa edikakoya. Po itia mamina latiamokoyake wedoa kalaneya witako. ");
INSERT INTO wiu_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ako odene tobou meane ago Solomono einagome mamina epetaneya-kama moa kakome wedoa kalakitikoa kakala taneyake taage kaluga eya kalaneya moa patukamele toameneya. ");
INSERT INTO wiu_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Kaluga taage eya ei li ludu pa tekei witako. Nipa opi tou toa witakoyake podolikama alime wakoa moa toele pitikaki. Edikoa pa tekei witakoloka Akolaliyo talo toa kalotokako. One dikane ago tokome anu oya-lawe kini kawatiki mamina moa meoono, edekolo wene keda taneya meki-pe. Ae, Akolalike inapa wedoa wene tugameneya mekiya tadeko. ");
INSERT INTO wiu_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Nee edoane moane naku patu, ue edoane nomoane naku patu, kawateku mamina edoane moane kaku patu wa enika eniya mama moameamene. ");
INSERT INTO wiu_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Enika eniyapa Akolaline peku noamiki-kitame mama moma yaki. Kime pade nitameamene. Anu oya-lawe kini wenepa a tibuke meko kiniketai Akolaliyo moademe tokoto-mo. ");
INSERT INTO wiu_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Nitademeke one talo toko take wene ki̱yo akeneya mekete toatiki peku tobou kakoa lawetoono, one talo toko take edikoa meadiya wa wene piitikaneya meamene. ");
INSERT INTO wiu_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Nipa podolio edeku patu wa kini kepene mama moameamene. Podolio opita Akolaliyo kiwi talo too tokolo ni uku. Ta pataka abuna keda enamuma pikino, podolio enamuatiki keda pade opi wene toopiameamene wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Yete pade ali atoa kini tanele poanele tadeko wa kikoa akameamene. Akolaliyo kiwika kikoa akayano, toameamene. ");
INSERT INTO wiu_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Yete pade ali atoa edikoa kikoa akakete tiki toa ete wa kikoa akakala toi. ");
INSERT INTO wiu_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","4","Ae, anu oyago neke leneke yomo pudunukau pomotoake wene toameneya mekeke neke oyagono lenekedo kugu deya pekeneya eneke eke neke leneke kugu deya pekeneyano, to̱ane motokada wa-kiti oko. Neke leneke poka yomo pudunukau pinali neke wapa to̱a moamatekoyake oko. Edekolo oko-pe. ");
INSERT INTO wiu_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Wene takuta pianeya meko ago neke leneke pudunukau poka yomo pinali neke wa namolo takoa to̱a moamene. Mootokoapa neke leneme wedoa enamele tokale meke neke oyagono leneke pekene kugu deya to̱a motokamele too. ");
INSERT INTO wiu_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Akolaline takoa pikaneya tue-kiti kakoita moa pitikameamene. Eniledo tokolipa nootokoa kiwika kimeme ti̱awea tadetapeoi. Yobo ma̱yoka kai-kiti kakoita moa piameamene. Eniledo tokolipa paya tetepo takakete kawame kautoa wititapeoi. ");
INSERT INTO wiu_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Akolali kowitikolipa yakoa too. Padeya-kiti tuku tokoa kaketepa enamuoi. Kago wi wi tokolipa pinago nome pekapikale tuapea poi. ");
INSERT INTO wiu_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Edikoa kowitoa kakagomepa nipa one eni kowitikaya moo. Padeya tuku toa kakagomepa nipa one eni tuku tokaya enamuoo. Kago wi wi toa kakagopa nipa pinagome pekapinoo. ");
INSERT INTO wiu_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Neke managome palawe wane pade nouno mano wa-kiti okalepa kue wane pade neme yotokoa moa meoo-pe. ");
INSERT INTO wiu_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ni mou pade nouno mano wa-kiti okalepa lene meaneya ali tania tukako kaya yotokoa moa meoo-pe. Nitamoo-li. ");
INSERT INTO wiu_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Kipa poanele toma yaki-kitameke kini mati-kiti epetaneya-kama wene toa mekala tiki. Epetaneya moa mekala tiki toapa a tibuke meko kiniketaiyo etene moa patukakome anu oya-lawe kiwi epetaneya mati takoa moa mekala too. One mano wa kowitiki ali atoapa nipa mekala too. ");
INSERT INTO wiu_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Eko pade ali atoame neke wene mokala tomotoapa nipa kini weneka neme mokala tamene. Eni ukupa Moseseyo yametane totono pine to̱ane ekene uku. Akolaline agale to̱awea akane ali-kitame wia mekane agaleka pine to̱ane ekene uku. ");
INSERT INTO wiu_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Akolali mekota poatiki ka keteponopa nateya dekatekaneya kakono, eni kago patukoa pamene. Ali atoa pote atupoatiki ka kago keteponopa etene yuane mati piko. Nitaneya tokome ali atoa kainya mati pote weamutuketepa poane take pokala tiki. ");
INSERT INTO wiu_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Mea kama poatiki kaapa nateya deya pia kago-kitika etene dekatekaneya kako. Eni kaapa ali atoa natetekoame tuku toa enamutukala tiki. ");
INSERT INTO wiu_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Pade ali-kitame Akolaline agale akaku wa kiwi pakeke sipi sipi kai tetepo takoa neketeke lene piane yokome keneya kimeme ti̱awea tadekatapekome toko toa kiwi toa potokoa oa yotokoino, lene kia wedoa nepikoa kamene. ");
INSERT INTO wiu_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Nekete tokoile eneketepa nipa ku̱ poaneya eni tukono, Yesuyo oa pikanakago eni nekedeko wa wene toi. No̱yokepa gerepi po ku̱ tuamoa ni aulalukepa yomo piki ku̱ tuamoa too. ");
INSERT INTO wiu_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Yomo epetaneyakepa ku̱ epetekoa tuoo. Yomo poaneyakepa ku̱ potokoa tuoo. ");
INSERT INTO wiu_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Yomo epetaneyake ku̱ poaneya tuamoo. Yomo poaneyakepa ku̱ epetaneya tuamoo. ");
INSERT INTO wiu_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ku̱ epetekoado tuameadekalepa pinagome tue moa ka̱wa poia toe mine pitikoo. ");
INSERT INTO wiu_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Nipa Akolaline agale akaku wa oake kapene wakoa iki-kiti nekete tokoile eneketepa ku̱ poaneya eni tuko wa wene toi. ");
INSERT INTO wiu_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ali Muno Ali Muno wa no kei pia iki peyapa Akolaliyo talo toko take poi wa wene piameamene. Agetai a tibuke mekome ta wa okole-kama yakoa tiki-kiti odene one eni take poi. ");
INSERT INTO wiu_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Wipitia ta pataka-pete ali atoa kainya matiyame no-pala eya wa oi. Ae, Ali Muno neke ibini wedekoanepa neke agale to̱aweane akoane ali atoake awitane ipono-kitika takoane wetekoane ele kule telekole toane tokouna wa nopala oi. ");
INSERT INTO wiu_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Nimo okoli ekene kiwi nateyaka wene toamuku. Poanele toma yakoinakeya-kiti wete poe wane wiane lititapeou wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Kipala i uku agale yakoa tiki-kiti kiwike dikoane adeka piane uku. Wene muno meane agomepa yapu wikome kue yaupea waneke motene pogoa wianeya. ");
INSERT INTO wiu_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Wia peya takaneyake ta lobomoa pitikoa ueka leau akoa yoa pupulege awitikaka matiyameka yapu auameneya pa kawa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Kipala uku agale yateketeke yakoa moamiki-kitike dikoane adeka piane uku. Wene meamene agomepa yapu wikome ue kibike motene pogoa wianeya. ");
INSERT INTO wiu_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Nitaneyake ta lobomoa pitikoa ueka leau akoa yoa pupulege-kitika popokaka matiyame yapu kawa katekoa aua pitikaneya. Bu wa aua pitikaneya wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Nimo ootokaneyake eida oboa kakoi-kitame ekete ");
INSERT INTO wiu_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","i olaukakome okopa Mosesene totono pine to̱a olaukaki yename ikina toa wamokono, agale pinagomepa i okono, yakatoe wa ka̱ oa kakoi. ");
INSERT INTO wiu_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu tono aya wane mea keti toa pokale enekete ali atoa lewi lewita pia litima nokoi. ");
INSERT INTO wiu_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Nitikoika kedi pitane agome Yesu kotukome wadini tukua kowitikome okome Ali Muno ago nemedo no i ago epetekouno wene pikepa nipa oyake epetekoano ta-kale ");
INSERT INTO wiu_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","yoname one mitikatekakome okome nitouno ta. Kedime nakeneya neke eni yene takoa pomotoane uku wa mitikakome okaka eina eina takoa pootapeneya. ");
INSERT INTO wiu_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Nitaneyake Yesuyo okome okome ete ali atoa enekeka ne latekakumo to̱awea ikileka toamea. Nitameneya eya topoano pa. Ne i agopa kedi pitaneya mekanake opi i latoa kakona wa yete pade ali atoame wene tomotoapa nipa Moseseyo tamene wa papete oa pianele topamene. Nipa Akolalike lodo yotokoai toko ago mekota peke padeya lodo yotokatekoya aua poke mepoano pa wa wetekaka. ");
INSERT INTO wiu_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesu Kapaneame take pome kakale Lomane yatene tobou poyo ago pade nokome okome ");
INSERT INTO wiu_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Ali Muno anu pupu ago pade one yapu walaike pa pia kakome muku tamele toamokome tete-pala moa mekono, einago auapea epetekakoano ta wa kowitikale okome ");
INSERT INTO wiu_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","nipa winagopa latekapouno, pata-kale okome ");
INSERT INTO wiu_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","e̱'e mena. Ipa pa ago kakene ukuno, anu yapu ne pata wane edoane kouane pomotoa-pe. Pa ne ita kake einago latoa kamene wa okalepa latoa poono, oano ta. ");
INSERT INTO wiu_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nopa tobou poyo ago padeke lokoane mekene ta wa okole-kama tuku. Nitiku toa nooke lukoa meki poyo ali-kitika anume toe wane ukule-kama yakoa tiki. Panago ne pa wane-kiti ukulupa yakoa poko. Wa panago no mekuta oto noo wane-kiti ukulupa yakoa noko. Anu pupu ago-palaka ile ta wane-kiti ukulupa nipa yakoa ukule takako. Edikoapa anu pupu ago latoa pa wa neme okalepa latoa poo wa tobou poyo agome oka. ");
INSERT INTO wiu_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Nimo okale yatekome Yesu wene kainya pianeya kakome one-pala obomoa nokoina yene-pala okome imopa i okono, yakoe. Mone yatene agomeke ipa oko. Iserele ago odeneka nooke edikoa wene tugoa meadekole enamuku. ");
INSERT INTO wiu_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Kipala i ukuno, yakoe. Mone pade take ali atoa kainya mati lou witia noko lonoka lou pipoko lonoka yeteka yukuka kawa Akolaliyo talo toko take note menokala toi. Nipa eya ali-mene Eberame Aisaketa Yekobe toa toge kikoa mekoita toge nee nopato wa note menokala toi. ");
INSERT INTO wiu_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Kipa Eberame-loeke tagene yeneka Akolaliyo eida pawe toa talo too tokake opi poe wa yomiyomume dika dika toamene take moa pitikakale komo ka̱ta nina toa pitikoa kawamoi wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yesuyo nimo ootokoa tobou poyo ago-pala okome noanume neke pupu ago oyake latekamele toko wa wene teke winipa okono, neke wene moadene tukuno, poano pa wa oka. Poano pa wa okanaka eina eina one pupu ago latoa kakedeka. ");
INSERT INTO wiu_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesu Pitane yapu tuapea pome enekale Pitane natonane nine poto yeneme tuaneya pikale enetekoa ");
INSERT INTO wiu_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","one yono mitikatekakale eina eina one poto yene takoa pokale kamokakome one nee takoa laweteka. ");
INSERT INTO wiu_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Lou pipokaka ipono awitane ali atoa peya mati Yesu mekota kiwi aua poono patoe wa kini oya-mikitame koua nokoli poane ipono-kiti wete takoa poe wa okale takoa pokala tokoi. Eya kuya yene tane-kitika aua nokoli latekakala toka. ");
INSERT INTO wiu_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Enipa Akolaline agale to̱awea akane ago Aisaiayo oa piane toa taatekoa toka. Eya wa oa pianeya. I to̱aweane uku ago taatekoa nokome toto peya eya kuya tane yene takoa wetekakomepa kabe koukoa pinali oneke wa weamutukou toa takoa wetekoo wa Aisaiayo oa pianeya. ");
INSERT INTO wiu_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Wa pade-pete ali atoa peya mati Yesu kakata unukapia kakoli enekome Yesuyo one oyali-lawe-pala okome eka ue matanuke witatono, patoe wa okaka ");
INSERT INTO wiu_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Yu yenane totono pine to̱a olaukakago pade one kakata nokome okome ne pokaka opi litima pou-kale okome ");
INSERT INTO wiu_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","yanai ini eya kini piatiki yene kakoyake no Ali Yatenane Oyago naliyomo mokoane piatekuyaka toamokono, no oyake litia noo-pe wa oka. ");
INSERT INTO wiu_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Nitikale Yesu-pala opia yaka ago padame okome okome ne opii litima noatekuyake agetai tuaneya pikono, oloyo toomotekene ne litima nou-kale okome ");
INSERT INTO wiu_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Akolalinele takamekete tuaneya piou toa pa meki-kitame tuane ali atoa oloyo tomotono, tokamota. Opa nepa no litima noano no wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesu ue dipike pome mekaka one oyali-kitame opia pato wa opia pekete pokoi. ");
INSERT INTO wiu_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Mea poadete pokoika pupulege tadalita kotikatapea u̱u wa noka matiyame ue pewikanokome ekolo lobututapeneyake Yesu pa atu pia kudaka. ");
INSERT INTO wiu_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","One eni pitikaya liti one oya-lawe tegeteka tegeteka toa mekete kamotokakete ekete Ali Muno toto ueme atukamedekono, toa moano, kamoa wa kamotokakoli ");
INSERT INTO wiu_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","kamokakome okome dekolo piti motiki-pe. Inapa nooke wene wedoa tugamekete tadiki wa kamokoa kakome pupulege-pala pewikanoka ue-ta kikoa okale tokoo lapa eyaka waametekoa kilikoa meelogaka. ");
INSERT INTO wiu_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Nitikale enekete wene kainya pianeya mekete ekete pupulege ue minetameka ta wa okole yakoa eni tokono, i ago Yesupa edane ali patu wa ka̱ oa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesu eka ue matanuke katepitoa pome Gadara ta ludu yakaka ipono-kiti awitane alita takutame one kotua nokoi. Nipa tuane yene oloyo toai taneka mea nokoi. Lene pianeyata kakoi matiyamepa eni take yene peya eida poamadete tima tima toa yakeneya. ");
INSERT INTO wiu_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Nitane agotame Yesu kotukete ka̱ telo ootapekete ekete Yesu nepa Akolaline manano, tota-pala edele toade noka-pe. Tota tete meateko oi wete noameneyake papete tete meade noka-pe wa telo ta̱yo ootapea kakoi. ");
INSERT INTO wiu_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Nipetepa eka mati ege egeta kadukoa kakene kai kimi kee noa kakoli ");
INSERT INTO wiu_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","enekete einagotake awitane ipono-kitame Yesu kowitikete ekete toto takoa wetekakalepa kunuka ku kai-kitike awipoono ta wa kowitikoli okome ");
INSERT INTO wiu_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","nipa poe wa okale takoa pootapekete e kai-kitike awipokoi. Nitikoli einaka eina kai-kiti payaneke kawa palake ketipea kiliti pote ue nakoa atutapeneya. ");
INSERT INTO wiu_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Nitikoile enekete einaka eina kai egetekoina yename ekete ekee wa kini ta latia pitikoika pitoa pootapekete ipono awitaneya yakoina agota-pala eniledopa eni toka wa kini leneme enekoinakamo opaneya. ");
INSERT INTO wiu_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Nitikoli yatekete Yesu kotupato wa udamoa pote kotukete ekete tone i ta tewitikoano pa wa kowitoa kakoi. ");
INSERT INTO wiu_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu ue dipike peapetekoa pome mea one Kapaneame take eka matanuke wakapea pome mepoka. ");
INSERT INTO wiu_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","One eida pome mekata pade ali-kitame muku toameneya pa pia kakene ago leyo leyo toa aua note pinokoi. Yesu i agome kini oyago oyake latekamele toko wa wene tadekoile enekome Yesuyo okome anu mana neke toma nokana poaneleke Akolaliyo po letu mekakanapa keetapekuno, wene weye akeneya meamene wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Nimo okale yatekete Mosesene totono pine to̱a olaukane ali padeka-kitame ekete beita, i agome Akolali tekome oko wa wene kibutua kakoli ");
INSERT INTO wiu_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesuyo tetoa enekome okome wene wini poaneya mekino, dekolo tiki-pe. ");
INSERT INTO wiu_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","I ago-pala ukule tamele tadeko wa kime wene tomotoanepa edemo wane omotoa iki-pe. I ago neke toma nokana poaneleke Akolaliyo po letu mekakana keetapeku wane omotoa iki-pe. Wete kamokoa pa wane omotoa iki-pe. ");
INSERT INTO wiu_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","No Ali Yatenane Oyagome itonoke mekene ali atoame toma yakoi poaneleke Akolaliyo po letu mekakana noanume keetapeamele toko wa kime wene tomotoanepa i ago-pala eya wane ukuno, ne aua nokoina leyo-pala aua peke neke yapu poano, kamokoa pa wa Yesuyo einago-pala okale ");
INSERT INTO wiu_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","kamomotokome one yapu pome mepaneya. ");
INSERT INTO wiu_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Nitikale enekete eida oboa kakoi-kiti piti tokale kakete ekete ekee, Akolaliyopa eni telekole toateka peku tone yagono ago i ago lawetaneya tadeko wa Akolali kei pia kakoi. ");
INSERT INTO wiu_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu eni ta tewitikoa pokome enekale eya ago Matiuyo takesi kue motokoai tane yapu keneke mekale enekome okome no pukuka tone patono noo wa oma ponokale Yesu litima poka. ");
INSERT INTO wiu_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","One yapu nee nopatono, pata wa Matiuyo koua pokale Yesu pome mekome nee noa meka. Nitikale takesi kue motokama yakene ali-kitika Mosesene totono litia toamene ali-kitika eida nekete Yesu-palaka one oya ali-kiti-palaka opia mekete nee nakoi. ");
INSERT INTO wiu_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Nitikoli enekete Parisi ali-kiti Yesuno oya-lawe mekoita nekete ekete kini tikisagomepa takesi kue motokama yaki ali-kiti-palaka Mosesene totono litia toamiki yene-palaka opia mekome nee nakono, edekolo tokoto-pe wa onokoi. ");
INSERT INTO wiu_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Nimo akedekoli yatekome Yesuyo okome dokosa agomepa yene toameneya meku wa iki-kiti edoa nome latekanomotoa-pe. Yene taneya meku wa iki-kitipa nipa nome latekanoo. ");
INSERT INTO wiu_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Akolaliyo akenemo one bokuke wia mekanemo ukuno, yakoe. Eya kuya nooke mea lodo yokala tikiyake kote tokolo waku. Anu wenedo kekadetepa ete ali atoa ela moa mama moa tamene wa oka. One eni okamo pine edoa piko patu wa wene kibutukoa meamene. Nipa poanele toamuku wa iki-kiti kini namolo poane wene wia wawe wane oadene nokouya mena. Nitamekene poanele tuku wa iki-kiti odene kini namolo wene wia wawe wane oadene nokou wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Wa naniko ali atoa ue motokama yakene Yonene agale yakane ali-kiti Yesu mekata nekete ekete totomeka Parisi yenameka Akolali wedoa kowitadetepa padepete-kiti nee eya tekei wawa noameneya pa yako. Neke oya ali-kitame enile toamikino, dekolo toamikiti-pe wa okoli okome ");
INSERT INTO wiu_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","panagono atoa motokakita atoa motoko agono oya-lawe one-pala wedikete wediapa nee eya edoa wawa tumai memotoa-pe. Wa naniko ete yename atoa motoko ago padeka aua poatiki wini tigotoma nokona. Enipetepa wene keda taneya mekete nee noameneya wawa pa meoi. ");
INSERT INTO wiu_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Panagome-kiti one mamina namoloya pilikalepa weneya pue moa pilikata lapukoa lipuko patu. E̱'e mena. Eniledo tootokoa uele abe kogalepa weneya pueme ete ete toa edema pokome pilikutu too. ");
INSERT INTO wiu_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ni gerepi po ku̱ ue weneyapa pinagome meme kai kepeneme latiane mete namoloyake peia moamoo. Eniledo tokalepa gerepi po ku̱ ue weneya tokome lako yati kawa mono mono oo. Nitikale mete namoloya tokome pukoa mono mono amele toamokome kaugale gerepi po ku̱ ue pata paka ponoo. Gerepi po ku̱ ue weneyapa nipa kepeneme latiane mete weneyake-kama peia mokala too. Nitikale uepala meteta atuameneya pia kawoo wa Yesuyo oka. (Enipa Akolalinele-pala kini namolole-ta odeneka dekoa toameamene wa okome oka.) ");
INSERT INTO wiu_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesuyo enimo oa kakaka tobou ago pade one kakata nome wadini tukupia kowitikome okome anu kono akoma opi tukano, ne nooke yono pikanokalepa latoa kawoono, kamatokakoano patono ta wa kowitinokale ");
INSERT INTO wiu_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","nipa pata wa litima pokale one oya-laweka koua pokoi. ");
INSERT INTO wiu_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Yesu eni pokaka yene tane atoa pade one mukiti lono lekama nome one tokoo kakene mamina nami mitikatekaneya. Einatoapa kamate yokoa kakome yeneme tukome mea potokane atoa. Mali tuku (12) kakoa ponoka toa edikoa meaneya. ");
INSERT INTO wiu_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Nitane atoa tokome Yesuno kakene mamina namido mitikakenepa latoane pou wa wene pia mitikanokale ");
INSERT INTO wiu_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","peketapea enekome okome anu kono nepa tepe kolotini kilikoa pimotono meamene. Nooke wini wene tugake tokoleme ne latekaneya tokolo uku wa okale einatoa eina eina latoa kaka. ");
INSERT INTO wiu_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Nititikaneyake Yesu tobou agono yapu pome tuapea kakome enekale pade ali-kiti tumai mekete tulutu oa wa pade ali atoame agale kamotokoa oa tokoli yatekome okome ");
INSERT INTO wiu_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","i akoma deya tukome tuaneya menano, pa atu pia mekono, poe wa okale one yau takakoi. ");
INSERT INTO wiu_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Nitikoli poe wa litimotokome eina akoma tuaneya pikata pome kakome yono motokale kamokoa latoa kaka. ");
INSERT INTO wiu_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Nititikaneyake one eni tokamo ta piko peyake oa pupitikatapeneya. ");
INSERT INTO wiu_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu eida tewitikoa yakaka alita takuta leneta lianeya meane agotame Yesu kayo oata litima nekete ekete Depidi-loeke tagene ago tota ela moa epetekoano ta wa kayo oa litima nokoi. ");
INSERT INTO wiu_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Litima nekete one pome meka yapu keneke tuapea note kakoli enekome okome i agota kita anume oyake latekamele toko wa nooke wene tugakete niki-pe-kale ekete Ali Muno neme oyake latekamele tokono wene tekete ni nokoo-koli ");
INSERT INTO wiu_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","kini lene mitikakome okome nooke wene tugakete iki toane nitimotoane uku wa oka. ");
INSERT INTO wiu_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Nimo okaka kini leneta eina eina kikatapeneya kakoli okome kita epetekakumo pade-kiti kotuketeka etene kotukoa wameamene wa agale telekoya oa tagaka. ");
INSERT INTO wiu_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Nitikale yakameneya eni ta piko peyake yakete Yesu einagome tota-pala ilepa i toka wa oa kotukoa yakeneya. ");
INSERT INTO wiu_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Eina leneta liitapeneya mekoinakagota yapu tewitikoa pene ani pokoika pade ali-kitame ipono awitaneya mea agale amele toamene ago-pala Yesu mekata aua nokoi. ");
INSERT INTO wiu_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Nitikoli Yesuyo eni ipono takoa pa wa wetekakale agale amele toamene agome agale witoa oa kaka. Nitikale eida oboa kakoi-kitame ekete tone Iserele take namolo toamokoinakale i agome ile i tokona wa ka̱ oa kakoli ");
INSERT INTO wiu_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Parisi ali-kitame ekete beita, ipa ako odene meko tobou iponane tele patu kautakoa kakome ipono-kiti takoa wetekakala toko wa tea kakete okoi. ");
INSERT INTO wiu_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu ali atoa ta latia pitikoika nateya takeka tubeya takeka yakome kini losu yapu pome olaukakala taneya. Nipa Akolaliyo ali atoa pawe toa talo tokomo kini wene epetekanemo i i wa mo wima pokomepa eya kuya yene tane-kitika kini yene peya latekawineya poka. ");
INSERT INTO wiu_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Nitoapa ali atoa eida kakoi mati egetamene sipi sipi kai keneya wene keda toologaneya pa yawa mekoile enekome ela matiyame tuaneya kaka. ");
INSERT INTO wiu_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Nitoapa agale pedoa okome okome ae ipe nee kakoya wakoa momotoa nodokoa kibutukakoa kakoyake eni ipe ludu wakoa moatiki yene natetekoa kakino, ");
INSERT INTO wiu_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","eya wa kowitamene. Ipe nee kakoya wakoa mou toa neke ali atoa toa motokamotono, pinago neke pupu yene wete takoa moa wetekoano ta wa Akolali kowitamene wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Wa naniko tuku kakoa (12) one oya-lawe one kakuta noe wa Yesuyo kayo oa motokome okome noanu tele patu kautakoa kakete ali atoake awitane ipono takoa wetekoa kini tane yene peya latekoa toma poatino poe wa wetekaka. ");
INSERT INTO wiu_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","One eni oya-lawene ibinipa dikoa. Namolo agopa Saimone one pade ibini Pita wa okala tiki. Ni one wamenago Aderu. Ni Sebedine manata Yame wamenago Yoneta. ");
INSERT INTO wiu_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ni Pilipi-pala Batolomiuta. Ni Tomasi-pala Matiuta. Matiu einagopa takesi kue motokama yakanakago. Ni Alepiasine mana Yame. Ni Tadiasi. ");
INSERT INTO wiu_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Ni Keinane take ago Saimone. Ni Yudase Isekariose einagopa Yesu wimotoa moa meateka ago. ");
INSERT INTO wiu_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","One eni tuku kakoa (12) oyali-kiti eni moa wetekakome okome mone pade yatenane ta ludu yawamoa Sameria yatene kini ta latia pitikoikaka poamoa tamene. ");
INSERT INTO wiu_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Iserele yenepa sipi sipi kai-kiti paka pote kapou toa etepea mekino, kini mekika poatino poe. ");
INSERT INTO wiu_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Nipa Akolaliyo ali atoa keleyo talo toateko tigotoma noko wa mo wima poatino poe. ");
INSERT INTO wiu_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Nitima pekete yene tane ali atoaka latekoa ni tuane yeneka kamotokoa ni kedime nakene yene kedi takoa wetekoa ni ali atoake awitane poane ipono-kitika takoa wetekoa tamene. Kini eni toatiki peku lawetekenepa nami kakamoane pa lawetekuno, ete yene auapekilepa kinike kue eya oia moameneya pa auapekala tamene. ");
INSERT INTO wiu_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Nitiketepa kue utiki kakepa golo kue waneka silepa kue waneka pa tuane kue waneka ua poamoa ");
INSERT INTO wiu_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ni oia moa nee eya uatiki kaka aua poamoa ni tigini maminaka kawa yeneka itika wa padeya lokoa moa aua poameamene wane uku. Pupu agome-kiti panagono pupu takakalepa pupu pine agome nami wia one noateka nee lawetoo tokolo ni uku. ");
INSERT INTO wiu_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Tubeya takeka dee takeka peketepa eya wa yakatekamene. I take Akolaline agale yakoa motane ago mani yapu pitikoto-pe wa yakatekoapa nipa eni yapu mepamene. Nipa yapu yapu yawameneya odene yapu-kama mea kawa pokala tamene. ");
INSERT INTO wiu_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Nipa yapu tuapea peketepa tepe kolotini kilikoa pimotono mea wa okala tamene. ");
INSERT INTO wiu_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Nimo okoli yapu pitikoi yename kiwi makutukoa moteketepa nipa kina eina epetekoa okoina toa epetekoa meoi. Nitameneya makutukoa moamokolipa nipa tokamotono, kina eina oa metekoina agale pedekomepa kiwike oto weamumotamene. ");
INSERT INTO wiu_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Wa pade yapu pitikoi yename kiwi makutukoa moamoa kini agaleka yakoa moamokolipa nipa pubu ou toa kini kawake kakene kege ko̱ketikoa tewitikoa pokala tamene. ");
INSERT INTO wiu_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ae, dikakoi yename tete moatikimo ukuno, yakoe. Akolaliyo ali atoa takoa eneka-petepa Sodome Gomora tatake meane yene kibu motokome dika dika toamene tete meoo. Kiwi makutukoa moamokoi yene kibu motikilepa eni meteka tete moa patukoa tete ako mati meoo wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Opi anu oya-lawe kiwi poe wane wetekakilepa lene pianeya yo tane tue-kiti yakika sipi sipi kai keneya moane wetekou toane tuku. Poanele witakale eneketepa edeku patu wa wedetekoa yako kayame-kiti toko toa wene wedoa tetoa pia tamene. Nitiketeka taba ago ini weuweme-kiti toko toa utanele poti toma pamene. Nipa poane yename kipala eya toa potokakala toi. ");
INSERT INTO wiu_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Pade-kitame kiwi koiso akou wa Kanosolo ali-kiti mekoika lia aua pokala toi. Wa pade-kitame kiwi wiou wa kini losu yapu-kitikeka layo toua wikala toi. ");
INSERT INTO wiu_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ni anukule takama yakoikepa ako odene tobou mekoi ali-kiti mekoikaka kiwike lokoa ta yopia mekoi yene mekoikaka lia aua pote koiso akakala toi. Nitikolipa enika eni tobou mekoi-kitane lenekeka e ku mone pa yatenane lenekeka kakete anukumo i i wa to̱awea akakala toi. ");
INSERT INTO wiu_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Kini eni koisoke lia aua pokoika peketeka edemo uku patu, agale edoane topo takoane uku patu wa wene keda taneya poameamene wane uku. Epetane Yominiyo kini oatikimo i i wa wene taka taka too tokolo ni uku. ");
INSERT INTO wiu_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Nitikala tokale tekete pademo-kiti ikilepa kini weneme titia pade wamoi. Kiniketai Akolaline Yomini kiwike awinokome a wa oka toa okala toi. ");
INSERT INTO wiu_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Enipetepa wamenagome-kiti wamene wia tukamotoa moa meoo. Etename-kiti mana matika wimotoa moa meoo. Mana kono-mikitameka kini etene nine wia tukamotoa moa mekala toi. ");
INSERT INTO wiu_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Anu oya-lawe kipa nopala odene ibini pedane ali atoa tokale tekete ete yene peya kipala kotimi yotaneya meoi. Nitikolika anukule pa takama pote kutu togakolipa Akolaliyo kipa one wa toa moo. ");
INSERT INTO wiu_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Kiwi tete metekolipa kini pitikoina ta wawa to̱a pote padeka pade take mepokala tamene. Nitiketepa kini Iserele ta keneke ali atoa pitikoi toa pade take to̱a pokala toa ete ete toa pote mea togameaneyake no Ali Yatenane Oyago wakapeane nou. ");
INSERT INTO wiu_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Nipa eya wa wene taneya yamene. Sukili matiyame one tikisago moa patukamele toamoa ni pupu takakagome one pupu pinago moa patukamele toamoa toko. ");
INSERT INTO wiu_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Tikisago meko toko toa one sukili matika edikoa meamedeko. Pupu pinago meko toa one pupu takako agoka edikoa meamedeko. Enipa ete-kitame yapu pinago nopa tobou ipono ago Belesebule wa ibini ikino, eni iki toa moa patukoa anu yapulu yene kipa etene tea agale okala toi wane ekene uku wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Eni yename kipala padele toatikilekeka piti moameamene. Ali atoame kaukoa toma yakile peyapa naniko keleyo witatapeoo. Padele padele paigakoa tikiyapa naniko peyame keleyo enetapeoi. ");
INSERT INTO wiu_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Kipala likonu kakene okouna agalepa lou pa̱ke kakete to̱awea ootapeamene. Wa kipala oi oi wa okoi agalepa yapu yalinike lewia kakete i i wa telo to̱awea ootapeamene. ");
INSERT INTO wiu_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Yete pade ali-kitame kiwi wiou wa lama moa lagotoa tukamele tokoyake kini yomini pade oyake wia atukamele toamoko. Nitamele toamokono, ali-kitipa piti moameamene. Akolaliyopa poane take poe wa okomepa nipa kini yomini-pala wia atukakome atukamele toko. Nitikono, Akolali einago odene piti moma pamene. ");
INSERT INTO wiu_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Dee ini deyata takuta tape kogopene topo toa kue motikilepa dedeya tuane kue wane odene mokala tiki. Enipa nimini ukutu pe. Dikane ini odene deyaka tukome itonoke pitakolopa kiniketai Akolaliyo ae, i ini deya eni tukona wa wene taneya meko. ");
INSERT INTO wiu_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ni ago Akolaliyopa anu oya-lawe kini wagoke witako pine kako toa oi moa talo toa kako. ");
INSERT INTO wiu_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ni agome ini deya mamapa moake paya tetepo takakome kipa one kolotini yene wa wedoa mama moa talo toa kakono, ete-kitame kipala padele toatikilekeka piti moameamene wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Panago ali atoane leneke kakome no i agono peku noane tuku wa to̱awea okalepa noanuka a tibuke meko agetaine leneke kakene i agopa anu peku noa tokago wane to̱aweane ou. ");
INSERT INTO wiu_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Wa panago ali atoane leneke kakome no i ago kote tokolo waku wa okalepa eina toane noanuka a tibuke meko agetaine leneke kakene einagopa kote tokolo waku wane waou wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Noanumepa ali atoa poi teigoa wawa poti kilikoa memotoane tekene nekedeku wa wene piameamene. No i nukupa kako poi takoukene ni nokou. ");
INSERT INTO wiu_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nipa panagome one etene-pala padatoame one nine-pala wa padatoame one aline nine one kaue-pala kako poi takoukene keku. ");
INSERT INTO wiu_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Kipala poi te̱ia meki-kitipa kini yapulu yene eni wane ekene uku. ");
INSERT INTO wiu_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Panago one etene ninetake wene wedoa mekoa mekomeke nooke nateya wene mekoa mekomepa nipa nopala oyake oya kakoa litiamele toamoko. Wa panago one mana kono-mikitike wene wedoa mekoa mekomeke nooke nateya wene mekoa mekomepa nipa nopala oyake oya kakoa litiamele toamoko. ");
INSERT INTO wiu_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Wa panagomepa one wiatiki lekane yomo lia aua poamademe wawou toa tokome anukule takama pokome tete-pala moamademe wakomepa nipa no yatene ago wa amele toamoo. ");
INSERT INTO wiu_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Nipa onekele-kama tokome tukaya wa kepene mama motoko agopa one yomini-pala etepea tua poo. Wa padekagome one kepene mama moamoa no i agoke tuou wa wene pikagopa tukomeka wa kamomotokome Akolaline take pome mea kama poo wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Panagome-kiti one yapu kiwi noe wa makutukoa motokomepa nipa nopala dekoa makutukoa motoko. Panagome no makutukoa motokomepa nipa no moa wetekaka ago-pala dekoa makutukoa motoko. ");
INSERT INTO wiu_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Panagome Akolaline agale akaka ago kotukome okome nepa Akolaline agale akako agono, one yapu ne noo wa makutukoa motokalepa nipa one eni tokake Akolaliyo einagoka one agale akako ago tetepo takoa pewe wioo. Wa panagomepa wene ki̱yo akeneya meka ago ponokale enekome okome nepa wene ki̱yo akeneya meko agono, one yapu ne noo wa makutukoa motokalepa nipa one eni tokake Akolaliyo einagoka wene ki̱yo akeneya meka ago tetepo takoa pewe wioo. ");
INSERT INTO wiu_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Wa panagomepa anu oyago pa ponopene ago ponokale enekome okome i ago nepa Yesuno oyagono, ue nomotokapouno, nepia wa mama moa auapekalepa nipa one eni tokake Akolaliyo etene kei pia pewe wia too wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesuyo one tuku kakoa (12) oyali-kiti einaka einamo oa meemotokome Galili take ali atoa pitikoika mo wima pokome Akolalinemo i i wa olaukakala toka. ");
INSERT INTO wiu_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ali atoa ue motokama yakene Yone po yapu pa pia mekomepa Keraisuyo eina toma yakenemo kugu yatekome eya taneya. One oyali padeka-kiti Yesuke moa wetekakome okome Yesu eya wa yakapoatino poe. ");
INSERT INTO wiu_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Nepa i wa ibini oa piane ago taatekoa noko-pe. Panago taatekoa noo tokolo totome nepia kamotoa oko-pe. Oano ta wa yakapoatino poe wa Yesuke moa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Wetekakale yakanokoli okome padele padele tukule kini leneme enoa ni pademo pademo ukumoka kini kaleme yakoa tikino, Yone mekota eya wa wakapea pote akapoatino poe. ");
INSERT INTO wiu_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Leneta lianeya mekoina yene opi leneta kikakaneya yawa ni kawa okeaneya yakoina yene opi wedoa pogoa kautoa pote ni kedime nakeneya mekoina yene kini kedi yene opi takoa pokolo latoa kawa ni kale keneta keteaneya mekoina yene opi kale pekaneya yawa ni tuane yeneka opi kamotokaneya kawa ni ponopene ali atoame Akolalinemo yakakoa meki wa Yone akapamene. ");
INSERT INTO wiu_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Eya waka akapamene. Nooke wene tugoa mea wawamoko agopa kolotine meoo wa akapoatino poe wa Yesuyo eina ali-kiti Yone mekata kutu wa wetekaka. ");
INSERT INTO wiu_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Wetekakale tewitikoa pokoika Yesuyo eida oboa kakoi yene-pala Yoneke okome okome ali atoa piamene take Yone enepeketepa edanele enadete pokoiya-pe. Tauwe wata pupulegeme muku muku toa kakale enepokoiya-pe. E̱'e mena. ");
INSERT INTO wiu_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Nipa edane ago enadete pokoiya-pe. Panago mamina epetaneya kakeneya kakale enepokoiya-pe. E̱'e mena. Mamina epetaneya kaki-kitipa nipa ako tobou ali-kitane yapu-kala meki. ");
INSERT INTO wiu_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Nipa edaneya enadete pokoiya-pe. Akolaline agale akama yakago enadete ni pokoiya-pe. E̱e nimini, Yonepa nitane ago. Akolaline agale papete to̱awea akane ali peya keku kamotoa einago ako kako. ");
INSERT INTO wiu_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yone einagokepa Akolaliyo mana-pala papete akenemo wene takakale panagome eya wia mekapianeya. Ne naniko pomotoane anu agale oa aua yawateko agopa namolo takoane moane wetekou. Nitikolu einago pokome ne poateko ka nodokakapima poo wa wia mekapianeya. Einagale taatekoapa Yone einago eni nekedekona. ");
INSERT INTO wiu_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Kipala i ukumo yakoe. Papete atoa-kitame opiane ali peya keku kamotoa ali atoa ue motokama yakanakago Yone ako kako. Onepa nitane agoke eya waneka uku. Anu uku agale yakoa mootokoa Akolalike lukoa meki-kitipa etene keku ali atoa-kitameka Yone moa patukaki. ");
INSERT INTO wiu_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ali atoa ue motokama yakona Yoneyo Akolalinemo titikome okaka anume opi i olaukakuka ali atoa Akolaliyo talo toko take poadete togo togo oomoata piki. ");
INSERT INTO wiu_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Eya wane ekene uku. Akolaline agale to̱awea akane ali peyamepa Akolaliyo ali atoa pawe toa talo toatekale i i wa wia mekoa tuma-kala nekeneya. Nipa papete Moseseyo one totono i i wa titikome to̱awea akapiane toa lokoa nitaneya. Wipitikome Yoneyoka einakamo to̱awea oma nokona. ");
INSERT INTO wiu_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Nipa Akolaliyo ali atoa pawe toa talo toateka tigotokalepa Ilaida namolo takoa noo wa oa piane toa taatekakome Yonepa eni nokona. E̱e nimini wa wene piketepa yakoa moamene. ");
INSERT INTO wiu_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Nipa yakou wa kale piiyakoa kaki-kiti kime yakoa moamene. ");
INSERT INTO wiu_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","No kaku-pete meki-kiti kini tikile adekapa edoane piane uku patu. Eya adeka piane ukuno, yakoe. Mati-kitame makesike pa ulu toa kakete ");
INSERT INTO wiu_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","eka e mati-kiti-pala eya wa kayo oa kaki. Tiabu toa kawati wa totome tulutu eya pukapekolo yateketeke toamokoi. Nitamokoile enekete toto tumai meou toa komo lo oa kakoloka enika enileka kote tokale tumai meamoukete wakoi wa eka e mati-kiti-pala ulu tootapekete iki wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Nitoapa einagale pine to̱awea okome okome Yone nokome padeya neeka gerepi po ku̱ ueka noameneyake ipono oneke awitaneya tokome ni toko wa pade-kitame tea agale oa kaki. ");
INSERT INTO wiu_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ali Yatenane Oyago noanume pade nitamekene eya kuya neeka gerepi po ku̱ ueka nakule enekete ekete no i agopa nee kitipu kakoa noa gerepi po ku̱ noa kawa toko. Takesi kue motokama yaki ali-kiti-palaka Akolaline agale tagoa toamiki yene-palaka oya patu pia tokono, enoe wa akoa agale iki. Nimo wapa ikiyake pade-kitame ekete mone inapa Akolaline peku noa tadiki wa iki wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Einata einapete Yesuyo Korasine Besaida tatake pitikoi yene kikoa akoa kaka. Nipa ele kule telekole kini leneke lugutukoa toma yakanakale eneketeke kini tokoi poanele tewitikoa wawameneyake ni toka. ");
INSERT INTO wiu_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Nitikome okome ae dika dika toamene tete moino, nepio. Kiwi pakeke ele kule tubele mati toma yakounakale mone Taia Saidone tata ludu toma yaou tokapa nipa kini namolole tewitikoa wakete palu watea kuku yotokatapea toi toka. Etene dikoa toi tokake kime pade nitamokoina. ");
INSERT INTO wiu_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Akolaliyo ali atoa takoa enoa kibu moateka-pete mone Taia Saidone tata pitane ali atoa tete meoo. Ae, eni tete meteka toa moa patukoapa Korasine ta Besaide tata pitiki-kiti kiwi dika dika toamene tete meoono, nepio. ");
INSERT INTO wiu_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ae, wini Kapaneame take pitiki-kiti Akolaliyo kiwi a tibuke moa kamotokoono wene pia meki-pe. Nitameneya kiwi keti toe take poe wa moa pitikoo. Kiwi pakeke ele kule telekole mati toma yakounakale Sodome take tou tokapa kini tane poanele tewitikoa etene waoi toka. Nitoi tokapa Akolaliyo kini Sodome taapa moa agopa takamokale pa pioo toka. ");
INSERT INTO wiu_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Akolaliyopa ali atoa takoa enoa kibu moateka-pete Sodome take meane yene tete meteka toa moa patukakome Kapaneame take pitiki-kiti kiwi dika dika toamene tete meoono, nepio wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Einata einapete Yesuyo okome okome Atai Ali Muno tibu itonota yopikoa kako ago nepala ke wane uku-ye. I uku agalepa pa nana mati keneya meki-kiti i i wa neme wene taka taka tokoyake Akolalinemo kini weneme wene taneya meku wa iki-kiti wene takameke neke luaneya mekono, ke wane ni uku. ");
INSERT INTO wiu_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Atai neke widikakepa neke epene wene-kama piko toa litiapa dikou wa wene toopikanakale taatekoa toko wa Yesuyo Akolali-pala oka. ");
INSERT INTO wiu_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Nimo ootokoa okome Agetaiyo one tele patu kautakoa kama pamene wa one peku no lawetetapeka. Nopa dikane ago wa padameka wene toamikiyake Atai Akolaliyo wenepa toko. Padameka Atai Akolali onepa dikane ago wa wene toamikiyake one mana noanume wenepa tuku. I alimeka i atoameka Akolali wene tomotou wane takoane moane kakaku-kitameka Atai Akolali wene tiki. ");
INSERT INTO wiu_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ae, koome tuaneya mea wene kedame tuaneya mea tiki peya ko memotouno, noanuke-kama noatini noe. ");
INSERT INTO wiu_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Kini keda taneya-kiti aulogoa poatikiya wanepa anume latikaku. Kini kotomaneke kini moa lekoa pikete toatikile olaukouno, moa lekoa piamene. No poti ko akene wene-kama pianeya meku agome eni toatiki peku lawetekolu noa teketepa tepe kolotini kilikoa pimotoa aua pamele too. ");
INSERT INTO wiu_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kini keda taneya-kiti aulogoa poatikiya epetaneya-kama latikoane anu kopapu-kitika yaapeaneya-kama takoane meane tuku wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Einapete Yu yene ko mea pupu toamene-pete pade Yesu panagono witi ipe kouwoto ludu potokakoa one oya-laweme witi ku̱ deya tukaka kotia noma pokoi. Kobu tokale tokome ni tokoi. ");
INSERT INTO wiu_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Nitikoli enekete Parisi yename ekete Yu yene tone ko mea pupu toamateko-pete kekoa wawa toamokole wini tiki wa kikoa okoli okome ");
INSERT INTO wiu_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","tobou ago Depidi einagomeka one-pala to̱a yakene ali-kitameka kobu tokale tanemo oi moamokoiya-pe. Eya taneya. ");
INSERT INTO wiu_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Tobou ago Soloyo Depidi-loe litia aua pokale einago one oya-lawe-pala to̱a yakome kobume tuaneya tokome Akolaline wikakane losu yapu tuapea pokome Akolaline takoa pikane palawe wane-kiti moa nakeneya. Mosesene totono piane toa Akolalike lodo yotokoai tane ali-kitame odene dikane palawe wane-kiti namele taneyake taneya. ");
INSERT INTO wiu_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Akolalike lodo yotokoai tiki ali-kitame ko mea pupu toamatiki-peteka sipi sipi kai tine wia eni pupu tokala tiki. Kini kekanele eni teketeka Akolaline agale tetekamiki. Mosesene bokuke enileke wia mekanemo oi moamokoiya-pe. ");
INSERT INTO wiu_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Tobou losu yapupa ibini akene yapu kakoyake kiwi pakeke kaku ago etene ibini akene agome ukuno, yakoe. ");
INSERT INTO wiu_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Akolaline bokuke agale dikoa wia mekaneyano, yakoe. Akolali noanuke lodo yomotoane wane wamuku. Yete pade ali atoa mama momotoane uku wa Akolaliyo akeneya. Eina agale pine tetoa enoi tokapa anu i oya ali-kitame poanele wini tiki wa kime kikoa wamoi toka. Witi ku̱ deya kotia naketepa Akolaline agale tetekamiki wane uku. ");
INSERT INTO wiu_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Nopa Ali Yatenane Oyagome ali atoa ko mea pupu toamiki-pete mekete toatikile i i wane oyameane talo toane tekene ni uku wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesuyo nimo oomotokome losu yapu pome kapoka. ");
INSERT INTO wiu_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Nitikata yono lokane ago pade eida mekale Parisi yename Yesu pitia yatekete ekete tone ko mea pupu toamateko-pete panagome dikane ago epetekakomepa tone kekanele eni toko-pe wa pitia yatekoi. Nipa Yesu koiso akatekoimo omotadiya wa kakete akeneya. Nitikoli okome ");
INSERT INTO wiu_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","kiwi panago neke sipi sipi kai odene egetekoa mekake koa pokale enekepa edeko patu. Pupu toamateko-peteka patu pitikoa aka moa kakako patu. E̱eno, eina-pete pupu toamateka-peteka aka moa kakoo-li. ");
INSERT INTO wiu_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Akolaliyo sipi sipi kai eya mama moapa kekuya tetepo takoa yopikoyake ali atoa akoya tetepo takoa wedoa mama moa yopiko. Nitikono, ko mea pupu toamateko-petedo i ago epetekakenepa tone kekanele toamuku. Mosesene totono piane toane oyake epetekamele toko wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Nimo ootokoa kakome yono lokane ago-pala okome neke yono kutu lido akoano ta wa okale lido akoa enekale one padeka eina epetane yono-pala odele tootapekale eneka. ");
INSERT INTO wiu_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Nitikale enekete Parisi yename i ago wiato wa akolono to̱a pote one wia tukatekoi oi pedoa pia kakoi. ");
INSERT INTO wiu_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Nitadekoimo yatekome Yesu eni ta tewitikoa pokale ali atoa lewi lewita pia litima nokoi. Eni yene padeka-kiti yene taneya nokoli enekome peya latekoa wetekakala toka. ");
INSERT INTO wiu_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Nipa onepa dikane agome ile toma noko wa pade ali atoa kotuketeka kotukoa wameamene wa wetekakala toka. ");
INSERT INTO wiu_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Nipa Akolaline agale papete to̱awea akane ago Aisaiayo papete oa piane toa taatekoa toka. Akolaliyo manake oka toa Aisaiayo eya wa wia mekaneya. ");
INSERT INTO wiu_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","I agopa anu pupu takamotoane takoane moane kakakuna. Anu i kolotini ago one tokoleke wediane meku. Anu Epetane Yomini oneke awinomotou. Nitikolu tokome einagome i i wa ali atoa ki̱yoke takoane enatekoumo e ku yatene peya-pala akama poo. ");
INSERT INTO wiu_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Nitima yakomepa ete-kiti-pala mokota wamoa ka̱ wamoa too. Ka batete ludu pokomeka agale wametekoa poti yawoo. ");
INSERT INTO wiu_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Tauwe wata tukukaneya kakale enekome oneme pade pilia moamoo. Labo tole wedoa pa̱ toa kamele toameneya kakale enekome ni pade tugamoo. Ponopene ali atoa edikoa mama moma pome wipitikomepa poi moa patukou toa tokome padele padele tane poanele wia atukatapea e ku yatene peya epetekoa talo toa kawoo. ");
INSERT INTO wiu_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","E ku yatene one ibini patu kautakoa kaketepa one nani toatekale nepia mea wedianeya mema poi wa Aisaiayo wia mekapianeya. ");
INSERT INTO wiu_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Einapete pade-kitame ipono awitane ago Yesu kakata moa aua nokoi. Ipono awitaneya tokome leneme enekileka toamoa kabunume agale ikileka toamoa taneyake Yesuyo epetekakale leneta kikoa enoa kabunu pea agale oa toka. ");
INSERT INTO wiu_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nitikale enekete peyame ekete i agopa Depidi-loeke ta̱watekago taatekoa noko patu wa ka̱ oa kakoi. ");
INSERT INTO wiu_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Nimo okoimo yatekete Parisi yename ekete beita, i agopa tobou ipono Belesebule one tele patu kautakoa kakome tokome ipono-kiti takoa wetekakala toko wa okoi. ");
INSERT INTO wiu_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Kini tepene pikoi wene tetoa enekome Yesuyo okome ako odene meko tobou agoke lukoa meki yenedo kako poi toa meketepa nipa wete atutapeoi. Wa pitikalika odene yapu pia meki-kitika kako poi toa meketepa tadoa pootapeoi. ");
INSERT INTO wiu_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Setanuyo edikoa one yagono-mikitido takoa wetekakalepa one yatene edoa mea kamotoa-pe. ");
INSERT INTO wiu_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Noanu Belesebulene tele patu kautakoane kakene ipono-kiti poe wane wetekaku wa ikipa nipa kini totono litia tiki ali-kitame ipono-kiti edoa takoa wetekaki-pe. Te patu kautakoa kakete tiki-pe. Anume takoane wetekakene tukuna toa tikino, kime no ina akoa kakinapa kapene wakoa akediki. ");
INSERT INTO wiu_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Akolaline Epetane Yomini patu kautakoane kakene ipono-kiti takoane wetekakala tukuno, Akolaliyo one ali atoa pawe toa talo tokotapa kiwi pake wini witadeko. ");
INSERT INTO wiu_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Telekagome one yapu pikoya pa yopia mekolopa kode agome yapu bulukoa nome onekeya peya oyake moa pamele toamoko. Nitamele toamokoyake kode ago kotikatapeado nokomepa telekago poome lutua piilogoa onekeya peya oyake kode moa poko. ");
INSERT INTO wiu_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","No-pala lipua meamoko agomepa nipa nopala poi eni teigome toko. No auapeamoa no mekuta ali atoa koukoa mekamoko agomepa nipa ali atoa tadekoa litikome toko. ");
INSERT INTO wiu_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Dikaki-kitikepa eya wane uku. Panagome padele padele poanele toa Akolali tea kawaka wa nanikodo ae inapa poanele tekene tadeku wa wakalepa nipa Akolaliyo eni poanele tokake po letu mekakanapa oyake kekile too. Nitikoyake panagome Epetane Yomininelepa Setanunole tetepo takakalepa one eni poanele tokake po letu mekakanapa Akolaliyo etene kekileka toamoo. ");
INSERT INTO wiu_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Panagome-kiti no Ali Yatenane Oyago tea agale akakalepa Akolaliyo eni poanele tokake po letu mekakana oyake kekile too. Wa panagome Epetane Yomini tea agale akakalepa Akolaliyo one eni poanele tokake po letu mekakana etene kekileka toamoo. Einago pa mekaleka tua pokaleka kekile toamoa kibu moo wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Yomo epetaneyapa ku̱ tua epetekoo. Yomo poaneyapa ku̱ tua potokoo. Yomo-kiti ku̱ tukole eneketepa ipa epetadeko ipa poadeko wa takoa enamele toko. ");
INSERT INTO wiu_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Parisi yene kipa kaya keneya mea poanele toma yakino, pademo epetanemopa edoa oadete-pe. Kini tepene meane toa-kama ya̱wa witakoa okala tiki. ");
INSERT INTO wiu_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Epetane wene piko agomepa one tepene meane toa ya̱wapa epetanemo witakoa okala toko. Poane wene piko agomepa one tepene meane toa ya̱wapa poanemo witakoa okala toko. ");
INSERT INTO wiu_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Nimini ukuno, yakamene. Akolaliyo ali atoa takoa eneka-petepa itonoke mekete paya wene pia pamo okoinakamo peya wedoa pitia yakatekoa kibu mokala too. ");
INSERT INTO wiu_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Nipa itonoke mekete okoinakamo toopitikoapa oa epetekakoi-kiti kibu moamoa ni oa potokakoi-kiti kibu moa toono, pademo pademo ikilepa wedetekoa okala tamene wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Yu yenane totono pine toa̱ olaukane ali-kitameka Parisi ali-kitameka Yesu yatekete ekete Tikisa ago neke tokolepa Akolali patu kautakoa kake tadekalepa padele telekole toano ta-koli okome ");
INSERT INTO wiu_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Akolalinele takamoa poanele toma yakina. Nitikete ekete Akolali patudo kakedekalepa padele telekole toano ta wa no likoa iki. Nitikiyake eya odene tokale enoi. Akolaline agale to̱awea akane ago Yona-pala tubele mati tane toa tokale enoi. ");
INSERT INTO wiu_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yona einagopa ta tebolo-peta patoa lika toa tube mou kimane keneke pa meane toanepa no Ali Yatenane Oyago ta tebolo patamotoane itono keneke piane meou. ");
INSERT INTO wiu_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Yonayo Akolalinemo Ninepa ta ludu mo wima pokale yatekete eni yene Akolalike tepe kolotini pekoa piitapeaneya. Mone pa yenameke nitaneya. Yona keku kamotoane no ako ago nukuyake Yu yene kime pade anu agale yakoa moamiki. Ae, Akolaliyo ali atoa takoa eneka-pete Ninepa yene kamokoa kakete kiwi akoa agale oino, nepiamene. ");
INSERT INTO wiu_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Akolaliyo ali atoa takoa eneka-pete mone Siba take ako meane tobou atoa kamokoa kakome okome Yesu kaka-pete mekoi Yu yene kime toa potokaneya wa kiwi akoa agale oo. Eni atoa mone atoameke Solomonono peku noademe ta padeka mati mea nekeneya. Tobou ago Solomono keku kamotoane no ako ago nukuyake Yu yene kime anu peku noamadete waki wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","44","Iponodo panago takoa pokomepa eya toko. One ko meatekotapa ta pitamene ta ludu tuku toa kawa teko tokolo wako. Nitoa wakomepa one takoane wawane nokounata wa wakapeane pone mepou wa wene piitikoa wakapea pome enepokolo einata do pokoa pia kalotokaneya kakedeko. ");
INSERT INTO wiu_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Nitaneya kakolo enemotokome tuku topokome ipono-kiti tatono kakoa (7) one poanele natele tomotoa poanele pine wia tagoa tiki ipono-kiti enamua einata aua noko. Aua nokolo einakagoke awitikete awitikili tokome one namolo poanele nateleka toa meake wipitikomepa poanele tubele-kama toma yako. No kaku-pete poanele toa meki-kiti kimepa edikama poadete tiki wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesuyo e yene-pala nimo oa kakaka one nine wamene-mikiti one agale akadete koli a note kanokoli ");
INSERT INTO wiu_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","panagome Yesu-pala okome okome neka̱uayoka neke wamene-mikitameka ne agale akadete koli a note kakina-kale okome ");
INSERT INTO wiu_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","aga̱uapa te-pe, anu wamene-mikiti te-lawe-pe wa ootokoa okome ");
INSERT INTO wiu_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","aga̱ua-loe anu wamene-mikitipa ika i mekina wa one oya-mikiti yamemu toka. ");
INSERT INTO wiu_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Nititikoa kakome okome Agetai a tibuke mekome ta wa okole-kama litia tiki-kitipa aga̱ua anu wamene laine-mikiti eni wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Einapetepa Yesu eina yapu akolono wititapea ue mine matanuke pome mepoka. ");
INSERT INTO wiu_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Nitikata ali atoa lewi lewita pia note-kala kakoli tokome ue dipike pogatekoa pome mepoka. Nitoapa e yene ue matanuke ete keneya kamotoa onepa ue dipike mekome ");
INSERT INTO wiu_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","pademo pademo pedoa okomepa eya wa oka. Ipe pinagome-kiti ipe ludu nee lene pitikama pekeneya. ");
INSERT INTO wiu_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Nitima pokale nee lene padekapa ka ludu paka tadoa pitaneya. Nitaneta ini-kiti pitoai toa napekala taneya. ");
INSERT INTO wiu_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ni nee lene padekapa kue pake pake tadoa pitaneya. Tokoo itono nateya deya pianeya tokome wete tumikala taneya. ");
INSERT INTO wiu_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Wa naniko lou tigini kakale wete eni tototokoa tuaneya. Teke itono kekulu wetekameneya tokome loume ni yoa tukatapeneya. ");
INSERT INTO wiu_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ni nee lene padekapa tonipo pake tadoa pitaneya. Nitaneta tonipo eni nee lene-pala odeneka dekoa witakome tukatapeneya. ");
INSERT INTO wiu_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ni nee lene padekapa itono epetaneyake pitakome leau akatapea witakome ku̱ tukala taneya. Ku̱ tukilepa padekapa ku̱ ege takupeta kadukoa (100) tua ni padekapa ege odepeta kadukoa (60) tua ni padekapa timini mukitini togoikoa padeka kapidi kakoa (30) ku̱ tua taneya. ");
INSERT INTO wiu_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Kipala i ukumo yakou wa kale piiyakoa kaki-kiti kime yakoati wane uku wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Nimo ootokoa kakaka one oya-lawe Yesu kakata nekete ekete ali atoa-pala ko ekepa pedoa-kama okono, dekolo widikoa oko-pe-koli okome ");
INSERT INTO wiu_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Akolaliyo one ali atoa pawe toa talo tokolepa papete kaukoa mema nekeneyake opi kiwi keleyo oyameteku. Nitikuyake ete ali atoa-palapa nipa kaukoane meku. ");
INSERT INTO wiu_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Akolaline peku wedoa nako agopa nipa Akolaliyo one pekupa wedoa lawetema pokale noa tagatapeoo. Akolaline peku pa alekoa noma poko agopa nipa one eni lawetane peku nateya deyaka takoa pootapeoo. ");
INSERT INTO wiu_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Dikane yene-pala ko ikilepa pedoane-kama oane meteku. Kini leneme enekile enoa moamoa kini kaleme yatekimo yakoa moamoa anu ukumoka wene toamoa tikili tekene ni tuku. ");
INSERT INTO wiu_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Nipa Aisaiayo eya wa wia mekapiane toa taatekoa tiki. Padele padele kini leneme eneketeke enoa moamoa pademo pademo kini kaleme yateketeke yakoa moamoa toi. ");
INSERT INTO wiu_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","I yene kolotini lupi tootokaneya mea kaleme wedoa yakamele toamokolo mea kini leneta-pala lakaputukoa-kama mea tiki. Enipa leneme enoa moa kaleme yakoa moa tekete inapa Akolaline pekuno, noada wa wene tekete nooke tepe kolotini pekoa piadekolipa anume toane mou tokake kote tokale wakala toi wa Aisaiayo Akolaline agale eni to̱awea oa pianeya. ");
INSERT INTO wiu_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Anu oya-lawe kime pade nitameneya kini leneme enoa moa kini kaleme yakoa moa teketepa kolotine meki. ");
INSERT INTO wiu_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ipa nimini ukuno, yakoe. Padele padele tukulepa kini leneme enoa pademo pademo ukumopa kini kaleme yakoa tikino, kini eni enoa yakoa tikiya-kitipa Akolaline agale to̱awea akane ali-kitameka wene ki̱yo akeneya meane ali-kitameka enoane yakadiya wa nepia meake enoa yakoa toameneya pa mea tuma-kala nekeneya. ");
INSERT INTO wiu_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ina pedoane okouna agale pine to̱aweane ukuno, yakamene. ");
INSERT INTO wiu_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Nee lene padeka ka ludu tadoa pitane adeka pikounapa eya tiki yeneke okouna. Akolaliyo one ali atoa talo tokome tokomo pade-kitame yakoake wene toamikilipa poane ago Setanu nome eni agale kini tepene pitikaneya pikota katekamoa poko. ");
INSERT INTO wiu_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Padeka nee lene kue pake pake pitane adeka pikounapa eya tiki yeneke okouna. Pade ali atoame eni agale yakoapa ke wa wete lukoa wedia meki. ");
INSERT INTO wiu_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Nitiketeke eni agale kini tepene teke wetekameneya tokome Akolalinele pa tekei takaki. Nipa Akolaline agale yakoa tikike ele kuleme ke enekakolo mea ni ete-kitame kipala poi te̱ia mekoli tekete Akolalinele takoake wete tewitikoa waki. ");
INSERT INTO wiu_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Padeka nee lene tonipo pake tadoa pitane adeka pikounapa eya tiki yeneke okouna. Pade ali atoame einagale yakoa moake kini kepene mama moa kini kamoya-kitike wene piitikoa mea tikili enika enileme Akolaline agale moa kautako. Nipa ipe nee kakoya ku̱ tuamou toa pa meki. ");
INSERT INTO wiu_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Padeka nee lene itono epetaneyake pitane adeka pikounapa eya tiki yeneke okouna. Pade-kitame eni agale yakoapa inapa Akolaline peku wa noa tiki. Nitikipa ipe nee kakoya ku̱ tuma pou toa padekapa ku̱ ege takupeta (100) kadukoa tua padekapa ege odepeta kadukoa (50) tua ni padekapa padeka kapidi kakoa (30) tua toko wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesuyo agale pade pedoa okome okome Akolaliyo ali atoa pawe toa talo tokole ooyametekene ukuno, yakamene. Ipe pinagome-kiti one ipe ludu nee lene epetaneya-kama tadekama yakeneya. ");
INSERT INTO wiu_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Nitaneyake ali atoa pitikakoa one-pala poi te̱iane ago ponome ipe ludu ke paya lene tadekamotokome pekeneya. ");
INSERT INTO wiu_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Nitaneyake nee lene tadekaneya kawa tumia witakale ke leneka odeneka tumia witakome witoa ku̱-kitika tukome tukala taneya. ");
INSERT INTO wiu_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Nitikale enekete pinagono pupu yene one mekata nekete ekete kamo koniyali neke ipe ludu nee lene epetaneya-kama tadekama yakanake ke witakala tokono, edoa tokoto patu-koli okome ");
INSERT INTO wiu_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","nopala poi te̱iane agome tokome toka-kale ekete eni keepa totome to̱a pala kakapomotoa oko-pe-koli okome ");
INSERT INTO wiu_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","e̱'e mena. Nitoati wane wamuku. Eni keedo opi to̱a pala kakapeketepa ipe nee kakoya-kitika odeneka to̱a motekete motokayano, ");
INSERT INTO wiu_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","pa odenekata witoa kamotono, wawe. Naniko wakoa momotoa nodokoa kibutukoa kaka-pete eniya wakoa motokatiki ali atoa-pala eya wane ou. Keepa namolo takoa to̱a moa toe mine pitikoai tamene. Nititikoa witi ku̱ wakoa moapa ku̱ pitikoai tikita aua note pitikakoai tamene wane ou wa ipe pinagome akeneya wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesuyo agale pade pedoa okome okome Akolaliyo one ali atoa pawe toa talo tokole ooyametekuno, yakoe. Panagome-kiti kalipe lene deya takoa moa ipeke pitikapaneya. ");
INSERT INTO wiu_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Eni lenepa etene pa nateya wane deyameke eteya yomo moa patukatapea tube mati kako. Nitoa wetini toa kakolo ini-kiti pukaneya note yeneneke pitoai tiki. ");
INSERT INTO wiu_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesuyo nimo ootokoa agale pade pedoa okome okome Akolaliyo ali atoa pawe toa talo tokole ooyametekuno, yakoe. Pade atoame-kiti palawe wane mono mono akateka yisi kugu moa palawe kugu odene bekoke eletekaneya. Nitikalepa palawe kugu keneke alama pokome palawe mono mono akatapeneya wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Eida oboa kakoi yene-pala einaka einamo ikilepa agale pedoa-kama oka. Nipa pademoka keleyo to̱awea wamoka. ");
INSERT INTO wiu_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Nipa Akolaline agale to̱awea akane ago padame papete eya wa wia mekakapiane toa taatekoa toka. Kipala ko ekenepa agale pedoane-kama oane mekala tou. Kipala eni pedoane oatekumopa Atai Akolaliyo tibu itonota latitikoa mekome kaukoa mema nokamo oane meou wa einagome papete wia mekaneya. ");
INSERT INTO wiu_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Nimo oomotokome Yesuyo eida oboa kanokoina yene tewitikoa yapu wa pome mepoka. Nitoa mekale one oya ali-kiti one mekata note yakanekete ekete ipeke ke lene pitikane neme adeka pikanapa pine edoa pikoto patu-koli okome ");
INSERT INTO wiu_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","nee lene epetaneya pitikama pekene agopa no Ali Yatenane Oyagoke ekene okouna. ");
INSERT INTO wiu_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ipe wane oanepa ali atoa meki take ekene okouna. Nee lene epetaneyapa Akolaliyo talo toko ali atoake ekene okouna. Ke lene wane oanepa poane peku laweteko ago Setanuno ali atoake ekene okouna. ");
INSERT INTO wiu_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Poi te̱ia mekome ke lene tadekama yakene agopa Setanuke ekene okouna. Ipe nee kakoya wakoa motokatiki-pete wane ikilepa wipitia ta pataka-peteke ekene okouna. Ipe nee kakoya wakoa motokatiki ali atoa wane oanepa Akolaline edelo ali-kitike ekene okouna. ");
INSERT INTO wiu_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Kee witakoya toe mine pitikoai taneleke ikilepa wipitia ta pataka-pete toatekaleke ekene okouna. ");
INSERT INTO wiu_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","42","Enipetepa anu edelo yene moane oto wetekakolu nekete eya toi. Ali atoane wene moa koiganele peya ni ele kule poanele toma yakoi peya moapa toe noa kakatake pitikoai toi. Nitikoli toe mine mekete kime kolukoa komo ue u̱u keneya ka̱ua oa kawei. ");
INSERT INTO wiu_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Nipetepa epetanele toa meane yenepa kiniketai Akolalike lukoa mekoi take lou tigini pa̱ tootapeneya kako toa kawei. Kipala i ukumo yakou wa kale piiyakoa kaki-kiti kime yakoati wane uku wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Akolaliyo ali atoa pawe toa talo tokole ooyametekuno, yakamene. Kue kake kue peya mati ua kapetekatapeneya potipianeya pikata panago nome enamutukome eya taneya. One kamo toatekuya i piko wa eni kue ka wa potipimotokome yapu wakapea pokome onekeya peya topo toa kue mootapeneya. Nitoapa ta pinago mekata pokome wini itono i kueme topo toane mou wa topo toa motaneya. Nipa kolotine mekome taneya. ");
INSERT INTO wiu_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","46","Akolaliyo ali atoa pawe toa talo tokole ooyametekuno, yakamene. Panagome-kiti yobo ma̱yo tuku toma pokome eteya-kiti takoa waatekoa etene koniyo taneya pade enemotokome yapu wakapea pome eya taneya. Onekeya peya topo toa kue moomotokome eina yobo ma̱yo topo toa mopaneya wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","48","Akolaliyo ali atoa pawe toa talo tokole ooyametekuno, yakamene. Pade-kitame kini mou tagi ka yuane mati moa kusa ue muke pitikoa wa ate moa enekoli eya kuya mou kapea pitakale enekete ue matanuke eka lia aua pote takoa eneki. Takoa enekete ipa epetadekono uada wa moa ipa poadekono wawada wa mitikakala tiki. ");
INSERT INTO wiu_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","50","Edikaki toa wipitia ta pataka-petepa edelo yene nekete eya toi. Epetanele toma yakoi peya kiwi meati wa takoa moa wa poanele toma yakoi peya toe mine moa pitikoai toi. Nitikoli kime kolukoa komo ue u̱u keneya ka̱ua oa kawei. ");
INSERT INTO wiu_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Kipala eni ukumo yakoa wene tootapiki-pe wa okale ekete e̱eno, wene tootapeko-koli okome ");
INSERT INTO wiu_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Mosesene totono pine to̱a olaukaki ali-kitamepa Akolaliyo ali atoa pawe toa talo tokomo kipala i to̱aweane uku toa yakoa moa olaukakilepa nipa eya tou toa tiki. Yapu pinagome-kiti one kamoya eya kuya yapu ua pikanakeya namoloyaka weneyaka moa moke toa meou toa tiki wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesuyo one eni pedoa oka agale oa peya takamotokome ");
INSERT INTO wiu_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","eni ta tewitikoa one pine take wakapea poka. Nitoapa losu yapu pome olaukoa kakale yatekete e yename ekete ipa tene peku nootokoa okoto patu. One telekole toma pokolepa tene tele patu kautakoa kakome tokoto patu wa ka̱ oa kakoi. ");
INSERT INTO wiu_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Nitikete ekete beita, i agopa Yosepe kodou agono mana. One nine Maria i mea one wamene-mikiti Yame Yose Saimone Yudase einago-mene i mea tiki. ");
INSERT INTO wiu_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","One laine-mikitika tone i take mekino, imopa dikane agomeke okono, tene peku nootokoa tokoto patuno, ");
INSERT INTO wiu_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","yakamatoe wa wene poaneya kakete akoa wakoi. Nitikoli okome Akolaline agale to̱awea akako agopa ete yename kei pimotoake one ta pine yenameka one yapu pitiki yenameka one kei piamoa paya tetepo takoa wakala tiki wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Eni oka toapa one eni take yene oneke wene tugameneya. Nitaneyake eida mekome padele telekole kainya toamoka. ");
INSERT INTO wiu_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Yesuyo toma yakenemo kugu yatekome Erodeyo Galili ta yopikoa mekome okome ");
INSERT INTO wiu_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ali atoa ue motokama yakanakago Yonepa eina wia tukamotoane tokounake wa kamomotokome nomepa nipa one tubele mati toateko tele eni luaneya yakome toko wa one pupu yene-pala akeneya. ");
INSERT INTO wiu_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Namolo Erodeyopa one poyo ali-kitame Yone dekoa moa kapa po kakoa po yapu pitikamotoa tikilepa eya atoa Erodiasine wene epetekademe taneya. Erode einagome one kale atoa wamene Pilipi natono one kode motaneyake ");
INSERT INTO wiu_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Yone Erode mekata nokome okome neke kale atoa kode motekepa toto Yu yenane kekanele wini toka wa kikoa akeneya. ");
INSERT INTO wiu_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Kikoa okale Erodeyo Yone einago wia tukamotou wa wene pianeya meake wakeneya. Nipa pa ali atoame i ago Yonepa Akolaline agale to̱awea akako ago tadeko wa one kei piai tokoli tokome kini wene witikaya wa piti motokome wakeneya. ");
INSERT INTO wiu_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Wa naniko Erodeyopa one opiane oi ponokale eya taneya. Oneke lokoa ta yopia meane yeneka one pupu takane yeneka kini toge kikakakuno, toge nee natono noe wa kayo oa motaneya. Nitikale nee mekete nakoika Erodiasine kono kini lene yoto nome kakome tiabu toa kakale enekome Erode wene epetaneya mekome okome ");
INSERT INTO wiu_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","agetai ti̱a, anukuya-kiti pade mano wa oika toane etene meadene tukuno, a̱wa oano ta wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Nitikale nine kakata pokome edeya mano wane ou-pe wa opokale niname akoano pa wa okana toa one koname eya wa onaneya. Ali atoa ue motokama yakanakago Yone kabe teigoa one wago wane okolo kagonoke pia oto memotoa toano ta wa onaneya. ");
INSERT INTO wiu_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Tuatoame nimo okale yatekome Erode wene kedapa taneya mekomeke nitaneya. Nipa one-pala opia mekete toge nee naki ali atoane lene yoto kakene ekene agetai ti̱a wane okouna toane tamedeku wa wene pikome ");
INSERT INTO wiu_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Yone po yapu pitikata kabe teigamotaneya. ");
INSERT INTO wiu_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Nititikoa one wago wane okolo kagonoke pianeya ina wa eina tuatoa metekale moa ninane aua potokaneya. ");
INSERT INTO wiu_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Nitaneyake Yonene oya-mikitame Yonene tigini monote aua pote kota keneke pipaneya. Nitimotekete Yesu opatono, patoe wa Yesu mekata pote opaneya. ");
INSERT INTO wiu_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yone tuka wa onokoli yatekome Yesu ue dipike pogatekoa pome mea ali piamene take kidene eka witimoa poka. Pekedekale yatekete ali atoa kini tube take pitikoika kamomotekete one pome witatekata ka ludu pote teigoa kapokoi. ");
INSERT INTO wiu_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Eida note kakakoa Yesu ue dipike mea nome katepitoa kakome enekome okome ae, elame tuku wa kini yene tane-kiti peya latekakala toka. ");
INSERT INTO wiu_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ta likaka one oyali-kiti Yesu kakata nekete ekete ipa ali piamene taano, ta-pala lima nokono, ali atoa ta latia pitikika i yene kini noatiki nee topo topoatino, poe wa wetekoano ta-koli okome ");
INSERT INTO wiu_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","i yename i ta tewitikoa poatiki toa mena. Anu oya-lawe kini neepa kime motokoa lawetamene-kale ekete ");
INSERT INTO wiu_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","tone palawe wane ko kakoa-pala mou yomo takuta toa odene piko-koli okome ");
INSERT INTO wiu_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","nipa oto nooke aua noo wa oka. ");
INSERT INTO wiu_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Nitoapa i ali atoa poma ludu kilikoa meetapeo wa ootokoa eina ko kakoa (5) palawe wane-pala mou yomo takuta toa moa pikoa kakome tibuke ate nepikakome Akolali-pala ke wa ootokoa popimotoka. Popimotokome one oyali-lawe tatia mekala tokale moomoteketepa e yene tatika tatika topokoli ");
INSERT INTO wiu_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","peyame moa noa tagatapea kitipu mekoi. Nootokaneyake kugu paka pitaneya wekotoa moa ua ka katika tuku kakoa (12) mako puputua moa pikoi. ");
INSERT INTO wiu_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Eni nee nakoina-kiti oi motikilepa mati atoa katekoa oi moamoa ali-kama takoa oi motokolipa ege egeta kadukoa (5,000) nakedekoi. ");
INSERT INTO wiu_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Nitaneyake Yesuyo one oyali-kiti-pala okome okome ue dipike peapetekoa pote eka matanuke mepoatino, poe. I ali atoa kini kini pitikika wetekamotekene nouno, patepoe wa one oyali-kiti wetekaka. ");
INSERT INTO wiu_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Nitoapa eida oboa kakoi-kiti pipoatino, poe wa wetekamotokome Akolali kowitademe kidene witimoa tono tobou ate lewia pome mepaneya. Ta likaka one eida pa kidene meaneya. ");
INSERT INTO wiu_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","25","Yesuyo kowitoa mekakoa one oya-lawe ue dipike mea puku pekete toa ue muke ue ate ketita pewikoa pupulegemeka kiwi nokoina lono kutu wa popokoa aua poademe tokoa kaka. Nitikoa kakale ta patademe tu̱ei teigaka Yesu ue tali ludu kautoa noka. ");
INSERT INTO wiu_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Kautoa nokale enekete ae, yukupa ipono noko patu wa nenei motekete ka̱ oa kakoli okome ");
INSERT INTO wiu_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","no i nukuno, tepe kolotini kilikoa pimotono, piti moameo wa okale ");
INSERT INTO wiu_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pitayo okome Ali Muno nipa ne nekedekalepa no ne kakota ue tali ludu wete noo wa oano ta-kale okome ");
INSERT INTO wiu_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","nipa namene wa okale ue dipi tewitikoa ko̱oketikoa Yesu kakata ue tali ludu kautoa noka. ");
INSERT INTO wiu_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Nokome enekale pupulege popokoa kakale enekome piti tokale tokome ue mine kekulu atukapademe kakome ka̱ okome okome Ali Muno no tuamedekuno, wete toa monoo wa ka̱ oa kaka. ");
INSERT INTO wiu_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ka̱ oa kakaka eina eina Yesuyo yono lido akoa dekoa motokome okome ae, nooke nateya wene tugoa meko ago dekolo pomeme tuaneya noka-pe wa ootokoa ");
INSERT INTO wiu_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","opia pome ue dipike mepoka. Opia pome mekaka eina eina pupulege te̱itatapeka. ");
INSERT INTO wiu_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Nitikale ue dipike mekoi-kitame one kei pikete ekete nepa nimini Akolaline mana tadeko wa wadini tukukoi. ");
INSERT INTO wiu_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ue mine eka matanuke ue dipike mea witapote Genesarese take ko̱oketikakoi. ");
INSERT INTO wiu_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Nitikoli enekete eni take yenamepa Yesu i nokono, noatino noe wa agale yekeika yukukata oa wetekakoli yatekete kini yene tane ali atoa Yesu mekata aua nokala tokoi. ");
INSERT INTO wiu_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Aua note kowitikete ekete i yene tane-kitame neke mamina nami mitikatekamotono ta wa kowitikakoi. Nitikoli one mitikatekakoi peya latoa pokala tokoi. ");
INSERT INTO wiu_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Einata einapete Parisi ali padeka-kiti ni Yu yenane totono pine to̱a olaukane ali-kiti Yerusaleme kawa Yesu kakata note kakete ekete ");
INSERT INTO wiu_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","neke oyali-kitamepa tone kaua-mikitame tamene wa olaukama nekenele toamiki. Nipa kini wene moa koigakoyapa i koguna wa adeka piapa kini nee noadete mekete yono abe kogala tane toa toamikino, dekolo toamikiti patu-koli ");
INSERT INTO wiu_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesuyo okome kini kaua-mikitame titia olaukanele litia toadetepa Akolaliyo tamene wa okale wakete onekele pa lede takama yakino, dekolo tiki pe. ");
INSERT INTO wiu_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Akolaliyopa neketai-pala neka̱uata kei pia mape moamene wa oa eya tamene waka oa taneya. Panagome oneketaika oneka̱uaka tea agale okalepa wia tukamene wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Akolaliyo enimo wa akeneyake panagome-kiti eya wa oko. Ae, agetai agauata kita auapeane padeya meatekuyapa meamuku. Nitikupa enika eniya Akolaline pikakene tekene ni meamuku wa oko. ");
INSERT INTO wiu_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","One etene nineta edikoa paya tetepo takoa auapeamoko agopa kime kei pikete ekete neketai neka̱uata pa memotono, tokamota wa iki. Nipa kini kaua-mikitame toma nekenele litia toadetepa Akolaliyo tamene wa akene agale ete pimotoa waki. ");
INSERT INTO wiu_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ae, wene takuta pianeya meki-kiti kini eni toatekoilekepa Aisaiayo eya wa papete wia mekapianeya. ");
INSERT INTO wiu_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","I to̱aweane uku ali-kiti kini kabunume no kei pikilepa kini tepene paya wene pianeya meketeke tiki. ");
INSERT INTO wiu_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Nitikino, kini kowitikimopa edoane yakamotoa-pe. Kini kaua-mikitame titia olaukanele ile tamene, ile tamene wa olaukama pikino, yakamou wa Akolaliyo oka toa Aisaiayo papete wia mekapianeya. Enipa nimini eni akedeko wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesuyo e yene one kakuta noatino noe wa kayo oa motokome okome kipala i ukumo wedoa yakoa moamene. ");
INSERT INTO wiu_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Panago one kimane keneke aka ketipea noa nokotikako neemepa pinali one wene oyake moa koigamele toamoko. Nitamele toamokoyake one tepene meaneya poane wene atepea kabunuke witako agalemepa pinali one wa moa koigamele toko wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Nimo ootokaneyake one oyali-lawe Yesu kakata nekete ekete neke winimo yatekete Parisi ali-kiti nepala wene poaneya mekino, enipa wene toamoko-pe-koli okome ");
INSERT INTO wiu_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Agetai a tibuke meko agopa oneme matameneya peyapa ipa oneme matamokounakeya wa to̱a mitikakala too. ");
INSERT INTO wiu_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Nitoono, wini Parisi ali-kiti nopala wene poaneya mekete ikimopa oa memotono, tokamota. Wini ali-kitipa leneta lianeya yaki. Dikane agome leneta liane yagono ali lia aua puku pokome toapa nipa takuta kobu kagonoke pitaketeta pitoi wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Nimo okale Pitayo okome ina pedoa okana agalepa pine edoa pikoto patu-kale okome ");
INSERT INTO wiu_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","ete yename anu okounakamo wene toamikino, kimeka wene toamiki-pe. ");
INSERT INTO wiu_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Panago nee eya moa nakolopa kimane keneke ponome tepene ponome me me toa wa te pu latia patukatapekala toko. ");
INSERT INTO wiu_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Nitikoyake poane agale kabunu witakilepa e ku poane wene tepene meaneya ya̱wa witako. Pinali one wene moa koigakilepa eni agaleme tokoya. ");
INSERT INTO wiu_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Nipa tepene meaneya ya̱wa witako toa tokome ali wiane tukou ni mone padane atoa liou ni abeya toane potokou ni mone padane pikoya-kiti kode mou ni kapene agale ou ni panago pa puputuane akou wa wene pia ");
INSERT INTO wiu_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","enika eni poanele aline tepene-kama aloa witakome pinali one wa moa koigako. Anu i oya-laweme yono abe ko̱ameneya witi ku̱ kotia nakipa pinali-kiti kini wa toa potokakiya mena wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesuyo nimo oomotokome eya tata Taia Saidone tata liti piane take wete eni poka. ");
INSERT INTO wiu_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Nitaneyake Kenane take meane atoa pade Yesu kotua kayo oma nokome okome Ali Muno Depidi-loeke tagene ago no ela moa auapeano ta. Anu kono akomake poane ipono awinokome tete motokakoa kakono, yapu noo wa kayo oa litima nokaleka ");
INSERT INTO wiu_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Yesuyo agale wametekoa ka ludu pa pome-kama kaka. Nitikale enekete one oya-lawe Yesuke nekete ekete i atoamepa toto litia kayo oma nokono, pa wa wetekoa ta-koli okome ");
INSERT INTO wiu_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Akolaliyo one pawe toane talo tukuta tewitikoa atua pokoina sipi sipi kaipa oto motokoano, pa wa no wetekaka tokolo tekene Iserele ali atoa odene makutukoane moadene ni nokou wa okale ");
INSERT INTO wiu_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","yatekome o atoame Yesuno kawane mulinita tukupia kowitikome okome Ali Muno no auapeano ta-kale ");
INSERT INTO wiu_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesuyo agale pedoa okome okome tone matiyane nee takoa pikoake wa tone mati wanoa tue-kiti kakoita eni nee moa pitikaketepa poanele eni toko wa oka. ");
INSERT INTO wiu_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Yesuyo nimo okaleka o atoame okome Ali Muno winimopa nimini eke okoyake eya wanedo uku. Yapu pinagono nee walai takaneya pikota kugu deya pedemotokome pitakale tue-kitika oyake namele toko wa o atoame oka. ");
INSERT INTO wiu_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Nitikale okome ae, anu oyatoa nooke winipa wedoa wene tugoa kake okono, no-pala wini kowitike oko toa nitimotoane uku wa okaka eina eina one konopa ipono takoa pokale latoa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu eni ta tewitikoa Galili ue matanu liti kokotoma pome tono pade ate lewia mepoka. ");
INSERT INTO wiu_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","One eni pome mepokata ali atoa lewi lewita pia litima nekete kini yene tane ali atoa-pala aua nokala tokoi. Nipa kawa okeaneya ni leneta lianeya ni agale amele toameneya ni yono totaneya enika eni ali atoa-pala aua note Yesuno kawane piai tokoli latekoa wetekakala toka. ");
INSERT INTO wiu_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Nitikale agale amele toameneya mekoina-kiti agale witoa oa ni kawa yoname wia mekaneya mekoina-kiti epetekaneya mea ni kawa okeaneya mekoina-kiti kawa pogakoa kautoa ni leneta lianeya mekoina-kiti leneta kikakatapeneya yawa tokoli peyame kee wa Iserele yene talo toko ago Akolali kei pia kakoi. ");
INSERT INTO wiu_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","One kakuta noe wa Yesuyo one oyali-kiti kayo oa motokome okome i oboa kaki yene mama moane ela motekene uku. Ta tebolo pataka toa no-pala opia yakete kini noatiki nee peya takatekoa pa kaki. Nee noameneya kini kini yapu tadoa poatino poe wanedo wetekakolupa yapu poadete pekete pake kobume tukete witipitoino, wetekamele toamoko-kale ");
INSERT INTO wiu_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","one oya-laweme ekete i ali atoa kainya mati toko-la. Ipa ali piamene taano, ali atoa peya mati i kakino, kini noatiki nee edoa motokoa lawetemotoa-pe-koli okome ");
INSERT INTO wiu_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","ni kini palawe wane-kiti edela piko-pe-kale ekete tatono kakoa (7) odene piko. Ni de mou deya-meneka piko wa okoli ");
INSERT INTO wiu_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","nipa poma ludu meetapeo wa e ali atoa mekatapeka. ");
INSERT INTO wiu_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Nititikoa eina tatono kakoa (7) palawe waneka mou-meneka moa pikoa kakome Akolali-pala ke wa ootokoa popimotokome one oyali-kiti tatia mekala tokale mootokoa e ali atoa mekoi toa nee pikama yakoi. ");
INSERT INTO wiu_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nitikoli peyame moa noa tagatapea kitipu mekoi. Nootokaneyake nee kugu pika wekotoa moa ka katika tatono kakoa (7) mako puputumoa pikoi. ");
INSERT INTO wiu_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Nipa mati atoa katekoa oi moamoa ali-kama takoa oi motokolipa 4,000 ali-kiti nakedekoi. ");
INSERT INTO wiu_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Nitaneyake Yesuyo eida oboa kakoina-kiti kini kini yapu tadoa poatino poe wa wetekatekoa ue dipike peapetekoa pome mea Magadane take mepoka. ");
INSERT INTO wiu_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Parisi totonoka Sadusi totonoka litia tane ali padeka-kiti Yesu mekata nekete ekete neke toma yakole Akolaline tele patu kautakoa kake tadekalepa nipa a tibuke padele telekole witakamotono ta wa likoa enenokoli okome ");
INSERT INTO wiu_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","ta lima lima tokaka tibu yali yapu kiitapeneya kakale enekete ekete podoliopa tape too tadeko wa ikina. ");
INSERT INTO wiu_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Likonu witia kolopa pilikakome liane wedodo wa kiane wedo latitapekolopa opi pupulege tadalita-pala igi noo tadeko wa ikina. Ae, wene takuta pianeya meki-kiti kipala ukumo yakoe. A tibuke witakolepa ile toatekolo toko wa kime tetoa enekiyake no kaku-pete witakolepa ile toatekolo toko wa tetoa enamiki. ");
INSERT INTO wiu_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Akolalinele takamoa poanele toawineya yakina. Nitikete ekete Akolali patu kakedekalepa padele telekole toano ta wa no likoa eneki. Nitikiyake eya odene tokale enoi. Akolaline agale akane ago Yona-pala padele tubele tane toa tokale enoino, padele pade enamoi wa Yesuyo oa poka. ");
INSERT INTO wiu_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yesuno oya-lawe ue dipike eka matanuke mea peketepa palawe-kiti wene kayapea ua poameneya. ");
INSERT INTO wiu_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Nitaneyake Yesuyo okome okome Parisi ali-kitika Sadusi ali-kitika kini yisi kugu kiwike weamutukayano, wedetekoa yamene-kale ");
INSERT INTO wiu_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","kini kini yakaate tekete ekete tone noateko palawe wane wene kayapea ua noamokoonake ni oko-koli ");
INSERT INTO wiu_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","kini tepene piane wene tetoa enekome okome palawe ua noamokoinakepa edekolo iki-pe. Nooke wedoa wene tugoa meamekete tekete ni iki. ");
INSERT INTO wiu_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Nipa palawe wane ko kakoane (5) moane ege egeta kadukoane (5,000) ali-kiti lawetekolu nootokaneyake kugu pika wekotoa moapa ka katika kainya mati mako puputumoa pikoina wene kayapetapea mekete iki-pe. ");
INSERT INTO wiu_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ni pade-petenaka palawe wane tatono kakoane (7) moane ege egeta kadukoane (4,000) ali-kiti lawetekolu nootokaneyake kugu pika wekotoa moapa ka katika kainya mati mako puputumoa pikoina wene kayapetapea meki-pe. ");
INSERT INTO wiu_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Parisi yene Sadusi yene kini yisi kuguke kipala eina okounapa edoa wene toamokoi-pe. Eina okounapa palawe waneke ekene wamokouna. Dikane aline yisi kugu titi toma pamene wane ekene okou-kale ekete ");
INSERT INTO wiu_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","ae, Parisi totonoka Sadusi totonoka litia toametekoa titi toma poati wa inapa okome akedeko. Kini yisi kuguke okome wameadeko wa okoi. ");
INSERT INTO wiu_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu Sisaria Pilipai take nome mekome one oya-lawe pitia yatekome okome ali atoame no Ali Yatenane Oyagoke ikilepa no te kaku wa ikiti-pe wa okale ekete ");
INSERT INTO wiu_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","padeka-kitame i ago nepa ali atoa ue motokama yakanakago Yone wa oa ni padeka-kitame Yeremaia wa oa ni padeka-kitame Akolaline agale to̱awea akako ago pade wa oa tiki-koli okome ");
INSERT INTO wiu_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","nimo wapa akedikiyake anu oya-lawe kime no te kaku wa iki-pe-kale ");
INSERT INTO wiu_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Pitayo okome nepa pa mea kama noko ago Akolaline mana one wa papete takoa kakapiane ago Keraisu wa oka. ");
INSERT INTO wiu_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Pitayo nimo okale Yesuyo okome Yonene mana Pita nepa kolotine meko ago. Neme wini okopa pa alime wene takaka toa wamokona. Agetai a tibuke meko agome wene takaka tokale ni wene toa oka. ");
INSERT INTO wiu_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Eya waneka uku. Pita nepa kue yaupea wa ibini akene ago. Eni kue yaupea waneke yapu wiou toane anu peku nakoi-kiti moane obokoane talo tou. Nitikolu tuane yene yopia mekoi-kitame anu peku nakoi-kiti moa atukadete wili tokoa kawa teko tokale wawei. ");
INSERT INTO wiu_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ni Akolaliyo talo toko ta kago ketepono peateko kiipa ina wane ne moane meou. Nipa itonokepa ile tamene, ile toameamene wa wene kibututukoa okapa a tibuke meko Akolaline wene pika toa-kama eke too wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Nimo ootokoa okome no Yesupa Akolaliyo takoa moa kakapika ago Keraisu taatekoane nekedeku wa ali atoa enekete to̱awea ikileka toameamene wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Einapete titimoa Yesuyo one tuatekamo to̱awea okome okome Yerusaleme take pone mekolu eya ali-kitame no tete-kala meoi. Kanosolo ali-kitika Akolalike lodo yoai tiki tobou ali-kitika Mosesene totono pine to̱a olaukaki ali-kitika enika eni ali-kitame no wia tukoi. Nitikolika ta tebolo takoa pataka-pete Akolaliyo moa kamotokoo-kale ");
INSERT INTO wiu_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pitayo pata wa Yesu eko keneya aua pome kakome kikoa okome okome Ali Muno nepa Akolaliyo mama moamedekono, eni yename nitamoi-li wa okale ");
INSERT INTO wiu_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yesuyo peketapekome Pita-pala okome i ago Setanu anu mukiti lono kuka poneke kapono, Akolaline wene piko toane litiane takaya tokolo ka ketekake oko. Winipa Akolaline wene piko toa wamoa pa aline wene piko toa okono, wa wa ootokoa ");
INSERT INTO wiu_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","one oya-lawe peya-pala okome no i ago litima nou wa wene piko agopa nekele tewitikoa wamene. Nipa ne wia dekatiki yomo lia aua nou toa tete mokoa kakeka no litima namene. ");
INSERT INTO wiu_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","One kepene mama motokome tukaya wa piti motaneya mekagopa etepea tua poo. One kepene mama moamokome no einagoke oyake tuou wa wene piko agopa toa motaneya mea kama poo. ");
INSERT INTO wiu_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Panagomepa one yomini atukome atumotoake itonoke pia kawa toko peya mootapeadekalepa eniya peya edeya weike moamoo. One yominido atukome atukalepa edeyame oto wa topo toa momotoa-pe. ");
INSERT INTO wiu_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","No Ali Yatenane Oyagopa anu edelo ali-kiti-pala opiane nekenepa Agetai pa̱ teleta tootapeneya meko toane meane nou. Nitikenepa ali atoa peyame epetaneleka poaneleka toma yakoinake nami wiane topo takakala tou. ");
INSERT INTO wiu_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nimini ukuno yakoe. Ita kaki yene padeka-kiti wete tuameneya mekete enekoli no Ali Yatenane Oyago etene ako odene tobou meatekou ago nokolu enoi wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ko melepu kakoa (6) ta patatekaneyake Yesuyo Pita Yameta Yamene wamene ago Yone toa kidene-mene ete witimoa aua pome tono kakene matike lewia pome kapaneya. ");
INSERT INTO wiu_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","O ali-mene aida kakakoa one-pala padele tokome one lene timini lou pa̱ keneya yati yati tootapea one maminaka lou pa̱ keneya ake tootapea taneya. ");
INSERT INTO wiu_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Nitaneya kakata Mosese Ilaidata kotikatapea nekete Yesu-pala ko oa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Nitikoli enekome Pitayo okome Ali Muno kimene ko oa kakita toto-meneka odeneya kakono, epetekono, neme nitika wa okalepa nipa aga yapu tebolo Mosese Ilaidata kini wikakakala too wa okaka ");
INSERT INTO wiu_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","pa̱ tootapeane wedome agopa takoa kauma nekeneya. Nitikaka eni wedo keneke agale ludu nokome okome anu kolotini ago anu manago wini kako. One tokoleke wediane kakuno, one oka toa yakoa tamene wa okale ");
INSERT INTO wiu_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","yatekete one oyali-mene piti mati tokale itonoke ketipea lene timini lono aua pitaloganeya. ");
INSERT INTO wiu_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Aua pitakoita Yesu nokome yoname mitikatekakome okome piti moameneya wete kamokoa kawe wa okale ");
INSERT INTO wiu_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","ate enetekakoli Yesu odene kakedeka. ");
INSERT INTO wiu_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Tono aya wane mea keti toa pekete pake Yesu kakome okome Ali Yatenane Oyago no tukolu wete kamotokameneyakepa kimename opi enekoinakamo pa kini luaneya mema yamene wa okale ekete ");
INSERT INTO wiu_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Yu yene tone totono pine to̱a olaukaki ali-kitame eya wa olaukaki. Keraisu naniko taatekoa nomotoa Ilaida namolo takoa noo wa olaukakiya. Enipa edekolo ikiti-pe wa okoli okome ");
INSERT INTO wiu_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ilaida einago namolo takoa nokome padeya padeya peya nodoka nodoka toono, enipa nimini ikiya wane uku. ");
INSERT INTO wiu_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Nimo wanepa ekeneke eya waneka uku. Ilaida wete wina wakapea noka. Nitikanake ali atoame ina okoinakago i nekedeko wa wene toamekete tokome e ku wene ponoka toa litia tekete one tete mekala tokoi. Edikakoi toa no Ali Yatenane Oyagoka tete motokakala toi wa okale ekete ");
INSERT INTO wiu_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ilaida wa ina okanapa, ali atoa ue motokama yakana Yoneke okome akedeko wa wene tokoi. ");
INSERT INTO wiu_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Tonoke ketipea ko̱a ali atoa oboa kakoi pakeke pote kakoli ali pade Yesu kakata nome wadini tukupia mekome okome ");
INSERT INTO wiu_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Ali Muno ne kowitikumo yakoano ta. Anu mana mati leau okome tete mati mokoa kakomepa padepete-kiti toe mine aua pitakome uele aua pitakome-kala toko. ");
INSERT INTO wiu_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nitikala tokale tekene neke oyali-kiti mekoita latekakoatino toe wane auane nokounake latekakamele toamoka. Anu mana neme elado motekepa latekakoano ta wa kowitikale okome ");
INSERT INTO wiu_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","ae, ipete meki ali atoa kime Akolalinemo yakamoa wene moa koiganeya mea tikino, kini eni poane wene tewitikoa wamotoane edoane nepiane meamou wa ootokoa matiyane etene-pala okome neke mana mati no kakuta aua noo wa okale ");
INSERT INTO wiu_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","aua nokale ipono kikoa okome okome i mati takoa pa wa okale takoa poka. Takoa pokaka eina eina eni mati latoa wene epetekaneya kaka. ");
INSERT INTO wiu_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Nititikaneyake Yesuno oya-lawe one kakata kidene-mene nekete ekete ina ipono totomepa oyake takoa wetekamele toamokano, edekome tokato patu-koli okome ");
INSERT INTO wiu_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","nooke pa nateya wene tugoa mekete tokome takoa wetekamele toamoka. Kalipe lene dedeyameke witakome leau akatapea witako. Akolalineledo edikoa takama peketepa nipa i kako tonoka to̱a yeta kapono wa okoli yeta ponome kaponoo. Nipa padele padele peya kime oyake tamele tokale nitoo wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Yesu one oya-laweka Galili take koukoa mekoi-pete pade one eni oya-lawe-pala okome no Ali Yatenane Oyagopa pade-kitame wimotoa panagome ete moa meoo. ");
INSERT INTO wiu_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Moa metekale wia tukakolika ta tebolo takoa pataka-pete kamoane pou wa Yesuyo okale yatekete wene keda mati toologakale mekoi. ");
INSERT INTO wiu_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesu one oya-lawe-pala Kapaneame take note mekoika tobou losu yapu takesi kue motokama yakene ali-kiti Pita kakata nekete ekete neke tikisa agome tobou losu yapu takesi kue pitikakoya-pe wa okoli okome ");
INSERT INTO wiu_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","e̱eno, Yesuyo nitikoya wa one yapu wakapea pome mekome Yesu-pala agale oademe tokale Yesuyo okome itonoke tobou meki ali-kitame takesi kue moteketepa kini yenaneke motiki-pe. Mone pa yenaneke motiki-pe-kale okome ");
INSERT INTO wiu_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","mone yenaneke odene takesi kue motiki-kale okome winipa nimini oko. Tobou ali-kitane mana-mikitame takesi kue pitikakiya mena. ");
INSERT INTO wiu_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Nipa agetai Akolaline tobou losu yapu takesi kue pitikateku toa menake takesi kue motokama yaki-kitane wene pokaya tokale eya topoano ta. Galili ue mine poke mou tikoa motokoano pa. Tikakale mou eina wete tanikale aka moa pitikoa pakunu lakapea enekale kue lene pade abutaneya enoo. Tone takesi pitikateko kue wini pioono, moa aua poke pitikapamene wa Yesuyo okale Pitayo nitikapoka. ");
INSERT INTO wiu_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Einata einapete Yesuno oya-lawe one kakata nekete ekete Akolaliyo talo toko take ako tobou meateko agopa te-pe wa yakanokoli ");
INSERT INTO wiu_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","3","Yesuyo yatekome de mati deya pade ne noo wa mootokoa kiwi kakoi pakeke kakakome okome kipala i nimini ukumo yakoa moamene. Kini wini wene wia wawa i mati deya keneya meameadekolipa nipa Akolaliyo talo toko take etene poamoi. ");
INSERT INTO wiu_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","I de mati deya nate wene pianeya meko toa meko agopa nipa Akolaliyo talo toko take ako ago meademe toko. ");
INSERT INTO wiu_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Panagome-kiti dikane mati deya nooke toado makutukoa motokomepa nipa nopala eni dekoa makutukoa motokome toko wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Dikane mati nooke wene tuganeya meko mati odeneka padele poanele tomotoa likoa enoa labakagopa Akolaliyo kibu motokome dika dika toamene tete meoo. Ae, eni tete mea kibu moamomotoapa papete mati wete likoa enameneyake panagomedo laukakoa tube kue matiyame einagono kabe kautoa kusa ue muke pitikakale ue nakoa tukalepa nipa epetoo. ");
INSERT INTO wiu_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ele kule poanele witakoleme ali atoa likoa enekala toko. Ae, itonoke enika eni poanele witakile tamele toapa tokoyake padele poanele tomotoa likoa eneko agomepa dika dika toamene tete moo. Nitikaya-nalino, wedoa meamene. ");
INSERT INTO wiu_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Neke yonameka neke kawameka pinali ne toa potokadekalepa teigoa mitikamene. Pinali neke kawaka neke yonoka teigoa mitikoa duku yawa kakeka mea kawateko takedo poke mea kakalepa nipa epetoo. Nitameneya yonotaka kawataka kakeneya toe noa-kala kako takedo moa pitikaneya mekalepa nipa poo. ");
INSERT INTO wiu_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Neke lenemeka ne toa potokadekalepa nipa lene to̱a wamene. Neke lene pade to̱otapeneya yawa kakeka mea kawateko takedo poke mea kakalepa nipa epetoo. Nitameneya leneta takuta kakeneya toe noa-kala kako takedo moa pitikaneya mekalepa nipa poo wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","I de mati deya odeneka paya tetepo takameamene. Kini edelo ali-kitame dikane mati yopikilepa Akolaline leneke-kama kakete tikili ni uku. ");
INSERT INTO wiu_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","12","Panagome one sipi sipi kai ege takupeta kadukoa (100) egetekale-kiti odene katepitoa atupokalepa pinagome edoo-pe. Nipa eya too. Ete sipi sipi kai-kiti tono payaneke eida koukoa kakoika kamotoa eina katepitoa atupokana kai pitia tuku tokoa kawa ");
INSERT INTO wiu_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","enamua motokomepa kolotine oto noo. Nipa atupameneya ege takupeta kadukoa (99) kakene sipi sipi kai-kitike wedikilepa tokomeke one eina tuku toa enamutukana kaike etene wedoa wedikome kolotine meoo. Enipa nimini uku-pe. ");
INSERT INTO wiu_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Eina toa kiniketai Akolali a tibuke mekome one i de mati deya odeneka paka atupokaya tokolo wedoa talo toa kako. ");
INSERT INTO wiu_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Neke oyago padame nepala padele poaneledo tokalepa nipa poti one mekata kidene poke eke ame i poanele neme i tokona wa opamene. Nitikale okome ae, ame nimini oko wa ela motokalepa nipa one-pala wa oya patu pike Akolaline kaake oto moa kakake too. ");
INSERT INTO wiu_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Nitameneya einagome yakamokalepa neke oyali-mene takutaka teboloka yatekanoatino noe wa einago mekata moa aua pamene. ");
INSERT INTO wiu_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Nitikale e ali-mename okoimoka yakamademe wakalepa losu yapu opatono noo wa nepala tokanakamo i i wa to̱awea opamene. Nitikale ali atoame kokotukoa okoi agaleka yakamademe wakalepa nipa Akolalinele takamene agoka takesi kue motokama yako agoka tetepo takoa wamene. ");
INSERT INTO wiu_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Etene nimini ukuno, yakamene. Itonokepa ile tamene, ile toameamene wa kini wene kibututukoa okoi toapa a tibuke meko Akolaline wene pika toa-kama ekete toi. ");
INSERT INTO wiu_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Eya waneka ukuno yakamene. Itonoke meki-kiti takutameka tebolomeka odene wene piitikoa kowitikete okolipa Agetai a tibuke mekome kini kowitikete okoi toa-kama yakoa too. ");
INSERT INTO wiu_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Takutameka tebolomeka anu ibini wedekoa koukoa mekoi toane kiwi pakeke none menokala touno, Agetaiyo kini kowitikoimo etene yakoa too wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pita Yesu kakata nokome okome anu oyagomedo no-pala padele poanele tokala tokalepa edela-peta po letu mekamoane nami wiamoane tomotoa oko-pe. Tatono (7) kakoa-peta patu-kale okome ");
INSERT INTO wiu_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","tatono kakoa-peta wane pade wamuku. Ege kadukaka tatono kakoa-peta (70 x 7) nepala poanele tokala toka toa po letu mekamoa nami wiamoa tamene. ");
INSERT INTO wiu_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Nipa Akolaliyo ali atoa pawe toa talo tokoleke eya wane pedoane uku. Tobou agome-kiti one pupu ali-mene kime wina anuke padeya-kiti nami kakoa motokoinakeya-kiti wa oto anu mouno, noe wa agale oa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","25","Nitikale titikilepa eya taneya. One pupu yene yopiane agome pupu ago pade takoa aua nokale tobou agome okome neme aunake kina kue ege egeta kadukoa (7,000,000 kina) motokana toa oto wa mano-kale okome ae nekena nami wiane meateku kue toamokono, edeku patu-kale okome i agoka one mati atoaka one yapu pikoya-kiti topo takoa auna kueke kue motokoano ta wa one pupu yene yopikane ali-pala akeneya. ");
INSERT INTO wiu_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Nimo okale one eina pupu takakanakago one kawane witipitoa aua pitalogoa kowitikome okome nekena kuekepa kue kotuke oboane meouno wa-ye wa kowitoa kakale ");
INSERT INTO wiu_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","tobou agome ela motokome okome nipa aunake nami kakoa motokana kueke kue moamadene eni wakuno, opa atiki tootapea pa wa one yapu wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Nimo wapa akeneyake one eni pupu takakanakagome akolono wititapea ponokome enekale one odene pupu ago pade ponokale enekome einago tomo po dekamotokome okome aunake ege odepeta kadukoa (50) kina kue nami kakoa motokana wete oto nami wia mano wa okale ");
INSERT INTO wiu_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","30","one eina odene pupu ago one kawane witipitoa pitalogoa kowitikome okome nekena kuekepa kue kotuke oboane meouno, wa-ye wa okaleka e agome okome auna kueke kue wete nami wia oto meamokoyake ne po yapu pa pioo wa po yapu moa pitikapaneya. ");
INSERT INTO wiu_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Nitikale enemotekete ete pade pupu ali-kiti wene keda mati tokale mea tobou ago mekata nekete einagome tokamo dika dika wa to̱awea onaneya. ");
INSERT INTO wiu_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Nitikoli yatekome tobou agome one mekuta ne noo wa einago kayo oa motokome okome nepa lene piane ago tadeko. Aunake kue nami kakoa motokana peya oto wa moameamene wa neme no kowitikale oto moamokouna. ");
INSERT INTO wiu_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Eina anume ne ela motekene tokouna toa nemeka neke odene pupu ago ela motikinakeya, dekale ela moamoka-pe wa kikoa ootokoa kakome ");
INSERT INTO wiu_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","po yapu yopiane ago-pala okome i agome anu kueke kue wete nami wia oto meamokoyake po yapu pa pia kamotono, po yapu pitikakapa. Eida layo toua wikala tamene wa moa metaneya. ");
INSERT INTO wiu_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ae, Agetai a tibuke mekome kipalaka enakale too. Nipa kini oyago padame kipala padele padele poanele tokake po letu mekakoina keetapeamadete wakolipa Akolaliyo nitoo wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","2","Yesuyo enimo oomotokome Galili ta tewitikoa Yodane ue ketoa eka Yudea take pome mepoka. Poademe pokaka ali atoa lewi lewita pia litima nokoli kini tane yene eida latekamu toka. ");
INSERT INTO wiu_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Parisi ali-kitika nekete ekete padele tubelekeka natelekeka panagome one atoa pa wa wakopa nipa tone totono litiapa tamele toa toko-pe wa natemo omotadiya wa kakete okoli okome ");
INSERT INTO wiu_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","namolo namolo Akolaliyo kamate meaneya-kiti titikome latikilepa ali atoata takuta wa-kama latikala taneya. Eni tanemo one bokuke wia mekaneya kime oi moamokoiya-pe. ");
INSERT INTO wiu_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Nitanelekepa alime atoa motokomepa etene nineta tewitikoa one atoa-pala lipua meoo. Nipa namolo letetakutukoata meaneyake naniko odene tigini tetepo taneya mekete liputakutukoata meoi. ");
INSERT INTO wiu_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Nitoa mekoli ipa i ago ipa i atoa wa tutu tutu wa ibini amele toameneya tokome i adona wa odene tetepo takoa oi. Nipa Akolaliyo moa lipukane ali atoata wa padameka moa letekatakutukamele toamoko wa Yesuyo okale ");
INSERT INTO wiu_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Parisi ali-kitame pitia yatekete ekete panagomedo one natono wawademepa namolo takoa opi ne eni wakene wakuna wa edikoa pipia wia meetekoapa opa pa wa wetekamele toko wa Moseseyo akeneya-mo. Enipa edekale akeneya-pe wa okoli okome ");
INSERT INTO wiu_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Moseseyo eni akenepa kini kaua-mikiti kolotini lupi tootapeneya mekoli tokome ni akeneya. Moseseyo nimo ikilepa taneyake Akolaliyo padeya padeya peya titia latikome oa piane toa akeneya mena. ");
INSERT INTO wiu_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Opi noanume eya wane uku. Pade atoa eko ali kode noameneya meaneyake anamedo ne pa wa wetekatekoa pade atoa motokomepa mone koua piamateko atoa eni motokome toko wa Yesuyo okale ");
INSERT INTO wiu_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","one oya ali-laweme ekete ali atoa edikoa meamediki wa neme okopa nipa alime atoa edoa moamoono, atoa moameneya tiobo ago-kama kaketepa nipa epetoo-koli okome ");
INSERT INTO wiu_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","eni ukupa ali peyame oyake litia tamele toamoko. Kipala ukulepa i agome-kiti litia tomotou wa Akolaliyo wene pikalepa nipa oyake litia too. ");
INSERT INTO wiu_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Pade ali-kitipa ninane tepene taneya nekene toa atoake wene kamoamokolo tiobo ali-kiti meki. Wa pade ali-kitipa alime mu motokatapeneya tokome tiobali-kiti meki. Wa ali padeka-kitipa eya kuya peya talo toko ago Akolalinele takama pukuno, atoa mena, moamou wa tiobali-kiti pa meki. Anu i ukule litiane tou wa wene piko agomepa nipa edikoa mema pamene wane uku wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Wa pade-pete pade-kitame kini mati-kitipa Yesuyo yono pia kowitikamotoa aua nokoli one oyali-kitame poe wa kikoa okoli ");
INSERT INTO wiu_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yesuyo okome wini mati-kiti oto nomotono, etoe. Akolaliyo one talo tuku taapa kinino, noe wa yametekilepa dikane mati-kiti yametekono, oto nomotono toe wa okale ");
INSERT INTO wiu_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","nokoli yono pia kowitikamotokome padeka poka. ");
INSERT INTO wiu_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Wa padepete panago Yesu kakata nokome okome Tikisa ago Akolaliyo talo toko take meane kama pouno, padele epetanelepa edele tekene meane kama pomotoa oko-pe wa okale okome ");
INSERT INTO wiu_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","epetanelekepa dekolo no pitia yateko-pe. Epetanele-kama toomoa poko agopa Akolali odene. Meane kama pouno wene pikepa nipa Moseseyo tamene wa oa pianele-kama toma pamene-kale okome ");
INSERT INTO wiu_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","mani agale-kala litiane tomotoa oko-pe-kale okome ali pade wia tukamoa mone padane atoa liamoa monekeya kode moamoa panago-pala pa puputua akoa agale wamoa tamene. ");
INSERT INTO wiu_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ni neketai neka̱uata kei pia mama moa ni pinali neeke wa wene mekoa mama motoko toa yete pade ali atoake wene mekoa mama moamene wa Yesuyo okale ");
INSERT INTO wiu_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","tualime okome neme wini okole-kamapa litiane toma nukuno, edele katekoane toamukutu-pe wa okale okome ");
INSERT INTO wiu_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Akolaliyo wene piko toane kotuke kakoane litiane tou wa neme wene pikepa nipa nekeya peya topo toa kue moamene. Mootokoapa ponopene ali atoa enoa tatia meetapeamene. Nitikepa neke kamoyapa a tibuke auma kakeneya enoo. Nitatekoyano, no litima namene wa okale ");
INSERT INTO wiu_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","yatekome wene keda taneya wawa poka. Nipa uu kamo tane ago tokome taneya. ");
INSERT INTO wiu_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Nitoa pokale Yesuyo one oya-lawe-pala okome ae kamo tane ago Akolaliyo talo toko take pikilepa etene wili tokoa kawapa poko. ");
INSERT INTO wiu_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kamelo kaido noi keneke-kiti patukoa ponokomepa nipa wedoa wili toa kawamoapa patukoa ponoo. Kamo tane ago Akolaliyo talo toko take ponokomepa nipa wili tokoa mati kawapa ponoo. Nipa one eni take pamene poto tube mati toko wa okale ");
INSERT INTO wiu_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","one oya-lawe wene peya mati pianeya kakete ekete ekee, kamo yeneke winimodo nimini akedekalepa nipa Akolaliyopa mainali atoa toa moo tokolo-pe wa okoli ");
INSERT INTO wiu_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesuyo nepikakome okome ali atoame toamatikilepa Akolaliyopa oyake tamele toko. Padele padele peya tamele toko ago tokome kamo agoka one take nomotoa ka patekamele toko-kale ");
INSERT INTO wiu_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pitayo okome ne litima noadetepa tonekeya peya tewitikoa wawa nokoono, neme edeya nami wia meoo-pe-kale okome ");
INSERT INTO wiu_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","itono tibuta takoa pokale eni luku weneya pikalepa pa̱ tootapeane walaike no Ali Yatenane Oyago pone mepou. Nitateku toa anu oya kiwika nooke lokoa tobou ali-kiti meatikiya walai tuku kakoake (12) mekete Iserele yatene tuku kakoa (12) tatite toa takoa enekala toi. ");
INSERT INTO wiu_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Wa panagomedo ipa no Yesuke tuku wa one yapu one etene nineta one laine wamene-mikiti one mati-kiti one ipe one ta eya tewitikoa wakomepa nipa enika eniya lukukepa ege takupeta kadukoa (100) mokala too. Nitoa mea tukale Akolaliyo one talo tuku take mea kama pamene wa moa kakoo. ");
INSERT INTO wiu_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Akolaliyopa ako yene kainya mati keku kakoa wa keku yene kainya mati ako kakoa too wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Yesuyo okome okome Akolaliyo ali atoa pawe toa talo tokole ooyametekuno yakoe. Gerepi po ku̱ ipe pinagome-kiti likonu witiane ipe takatiki ali-kiti enemopou wa mekoika pekeneya. ");
INSERT INTO wiu_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Pokome enekome okome tebolo-wa-kama kue kina mekala touno, anu ipe takapoi-pe wa okale ekete takapouno ta-koli okome nipa takapoatino, poe wa moa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Nititikoa lou pini pogi (9) kakoakeka makesike wa wakapea pome enekale pade ali-kiti loyo mekoli enekome okome ");
INSERT INTO wiu_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","kini moatiki toane kue mekala touno, anu ipe takapoatino, poe wa moa wetekakale takapaneya. ");
INSERT INTO wiu_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Bera-peteka (12 kilokoka) lou aukapokaka (3 kilokokeka) einakale toa pade ali-kiti enekome takoa moa wetekakala taneya. ");
INSERT INTO wiu_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Wa naniko ogopono (5 kilokoke) wa wakapea pokome enekale pade ali-kitika loyo mekoli enekome okome i makesike likonu witia pa loyo meemoa note ta likakino, edekolo pupu toamiki-pe wa okale ekete ");
INSERT INTO wiu_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","pupu yametekago ago nikileka toamoka-koli okome nipa anu gerepi po ku̱ ipe takatiki pupu pikono, takapoatino, poe wa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ta likaka gerepi po ku̱ ipe pinagome eni yene yopikago-pala okome okome anu wini pupu takaki ali-kitipa kue meteke ile tamene. Wipitikene takoane motokouna ali-kiti kue namolo takoa meawineya pamene. Ketekepa namolo takoane motokouna yene mea wipitiamene. Wete kayo oa moa kue metekakala toano ta wa okale ");
INSERT INTO wiu_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","pokome ipe pinagono pupu ogopono titikete takane ali-kiti nokoli kina tebolo-wa-kama metekaneya. ");
INSERT INTO wiu_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Nitima pome wipitikale namolo takoa motokana ali-kitame kue ako mouno wene pia nokoli ipe pupu yopikagome kina tebolo-wa-kama metekaneya. ");
INSERT INTO wiu_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","12","Nitikale motekete ipe pinago-pala ko̱ oa kakete ekete likonu wititapea tape louke pupu takamoa note ta likakoona. Nitikoonake lou pini odeneke pupu nateya takakoina yene-pala totoka odele toa pupu takane tetepo takoa kina tebolo-wa-kama neme meteko-koli ");
INSERT INTO wiu_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","pupu pinagome pupu takane ago pade-pala okome anu oya ne toane potokamukutu-mo. Kina tebolo meouno, anu pupu takapoo-pe-kolu eke e̱eno, nitikouno ta wa neme okana. Enimopa wamokanakamo okotu-pe. ");
INSERT INTO wiu_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kue ne i metekene tuku toanepa keteane moane wetekakounakagoka kina tebolo meadene uku. Neke i kuepa moano ta. ");
INSERT INTO wiu_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Anukuyapa anu wene litiane oyake tatiane meamele toko. Naniko ina nokanakago edikoane pewe witikouna tokolo ni nopalapa wene poaneya kake oko-pe wa ipe pinagome akeneya wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Nimo ootokoa okome wina pedoane okouna toa Akolaliyo naniko nokoi yene namolo kakoa wa namolo nokoi yene naniko kakoa too wa Yesuyo oa poka. ");
INSERT INTO wiu_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu ate Yerusaleme take poademe pokome one tuku kakoa (12) oyali-kiti eko keneya witimoa aua pokome okome kipala i ukumo yakoe. ");
INSERT INTO wiu_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Opa ate Yerusaleme take poadete poko. Pote kakolo no Ali Yatenane Oyago panagome moa eya yenane yonoke Akolalike lodo yoai tiki tobou ali-kitika Mosesene totono pine to̱a olaukaki ali-kitika kini yonoke pioo. ");
INSERT INTO wiu_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Nitikale no wiatekoi oi pedoa piitikoapa mone pa yene kime wia tukakoe wa metekoli motekete tegene matoa po wapime wia yomo lekaneyake wia dekoa toi. Nitikolika ta tebolo takoa pataka-petepa Akolaliyo moa kamotokoo wa Yesuyo oa pika. ");
INSERT INTO wiu_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Yesu Yerusaleme take kutu poademe pokaka Sebedi natono one manata-pala Yesuke nome wadini tukupia kowitikakome okome agale deya ou-kale okome ");
INSERT INTO wiu_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","anume edele takamotoa oko-pe-kale okome ne tobou ago meke talo tokaka i manatame ne auapekete panago neke nimini yono lono mea padena ago neke ewa yono lono mea yopimotoane uku-kale ");
INSERT INTO wiu_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesu eni wamena kakoi lono peketapekome okome wene toameketeke ikino, no noateku tetepa kitameka noukete iki-pe-kale ekete e̱eno, nitato ta-koli okome ");
INSERT INTO wiu_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","no noateku tetepa kitameka eni noateku toa noi. Nitadete tikiyake ali atoa talo toane mekouta eka oka yono lonota kita tatikatakutukoane mekamele toamoko. Eka okata meatiki agotapa Akolaliyo i i wa wete wene toopianeyano, anume oyake oyameamele toamoko wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Nimo wapa akedekoli yatekete o yename eni wamena-pala wene poaneya kakete ko̱ oa kakoli ");
INSERT INTO wiu_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yesuyo one kakuta noe wa kayo oa motokome okome mone pa yatenane tobou ali-kitame kini yene wete toe toe wa tika tika-kama tiki. Kini ibini akene ali-kitameka ali atoa yopia mekilepa kinikile-kama takamotoa tiki. ");
INSERT INTO wiu_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Nitikala tikino, anu oya-lawe kime pade edikameamene. Tobou ago meou wa wene piketepa nipa kinikile toamekete kini oya-mikitanele takama pamene. ");
INSERT INTO wiu_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Nipa ako odene mekene talo tou wa wene piketepa nipa pinagono pupu-kama takamotoa kueme topo toa moa egetane ago keneya meamene. ");
INSERT INTO wiu_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Noanupa Ali Yatenane Oyago taatekoane nekenepa ete yename anukule takamotoane nokouya mena. Nitameneya ete-kitanele takoane ni ali atoa peya mati anu kamateme oto toane moukene ni nokou wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesu one oya-lawe-pala opia pome Yeriko ta tewitikoa pokaka ali atoa lewi lewita pia litima pokoi. ");
INSERT INTO wiu_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Kini ponokoya liti leneta lianeya meane agota batete matanuke eida mekete yatekoli Yesu wini patukakona wa oma ponokoimokamo yatekete kayo oa ekete Depidi-loeke tagene ago Ali Muno neme tota ela moamene-ye wa kayo okolipa ");
INSERT INTO wiu_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Yesu lewi lewita pia litima ponokoi-kitame kikoa ekete ekete agale oyakeno, wawe. Kilikoa meo wa kikoa oma ponokoi. Nitikolika einagotame kayo telo kamotokoa ekete Depidi-loeke tagene ago Ali Muno neme tota ela moamene-ye wa ka̱ata wikoa kakoli ");
INSERT INTO wiu_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesu witimoa kakome okome nipa noe wa okale nokoli okome anume edele takamotoa iki-pe-kale ekete ");
INSERT INTO wiu_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ali Muno tone leneta kikoono, epetekoano ta wa okoli ");
INSERT INTO wiu_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","ela motokome kini leneta mitikatekakale eina eina kikatapeneyata Yesu litimata pokoi. ");
INSERT INTO wiu_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesu one oya-laweka Yerusaleme ta tigotokoa witapadete peketepa Olipe-pini tonoke latiane Betepase take witakete Yesuyo eya toka. One oya ali-kiti takuta moa wetekakome okome ");
INSERT INTO wiu_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","kuka ku take poatino poe. Pote witoa kaalaukete enekoli dogi kai tine-pala eida po kakoa kebetaneya kakoli enoi. Eni dogi kai nina po kotokoa oto aua notokamene. ");
INSERT INTO wiu_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Kotokoa moadete kakoli panagome dekolo motiki-pe wa okalepa eya wa akamene. Ali Munoyo padele toatekole pikolo ni motokoa poko. Opi oto wa wetekademe toko wa akamene wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Enipa Akolaline agale to̱awea akane ago padame eya wa papete oa piane toa taatekamotoa tokoi. ");
INSERT INTO wiu_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","I Saione take meki kono-mikiti kiwi yopia tobou meatekago wini noko. Nokomepa dogi kai tali waneke mekome ua mootokoa patutu ootokaneya mea noko. Nipa dogi kai tine patu mea noko wa padame oa pianeya. ");
INSERT INTO wiu_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","7","Eni oa piane toa taatekakete Yesuno oya alita takutame Yesuyo okalee pote topokoi. Nipa eni dogi kai nina aua neketepa kini kakene mamina petene kotokamoa dogi kai patu tatikakoli Yesu mea poka. ");
INSERT INTO wiu_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Nitikaka ali atoa peya matiyame kini tokoo kakene mamina kotokamoa one mea poatekaka bateteke pia tatikama pokoi. Wa padeka-kitame yomo yenene deya tewia moa batete ludu tatikama pokoi. ");
INSERT INTO wiu_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Nitoa lewi lewita pia pekete namolo kawa pokoi-kitameka ketea kawa nokoi-kitameka agale kamotoka kamotoka toa ke ke wa oawineya pekete ekete Depidi-loeke tagenago i ago kei piatoe. I agopa Ali Muno Akolali patu kautakoa kama nokono, Akolali neme pewe wia yopia kamene. A tibuke meki peya one kei piamene-ye wa kolotine togete oawineya pokoi. ");
INSERT INTO wiu_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Oawineya nomotoa Yesu Yerusaleme ta ata witakalepa ali atoa ete pato oto pato toa kakete ekete i ago te-pe wa ka̱ wikoa kakoli ");
INSERT INTO wiu_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","lewi lewita pia nokoina-kitame ekete i agopa Nasarese Yesu Galili ta keneke piko Nasarese take ago Akolaline agale to̱awea akako ago wa topo takoa okala tokoi. ");
INSERT INTO wiu_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu one pa kutu pokome tobou losu yapu pome kapoka. Pome kakome eya kuya eida-kama topo toa tane ali-kiti wia tikatapeka. Nitoa e ku take latiane kue topo toa Yudea kue lene ete mea tokoi ali-kiti kini walai-kiti moa pekatapea ni ini puluma yoa tane yenane walai-kitika moa pekatapea toka. ");
INSERT INTO wiu_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Nitikome okome anu i yapupa no Akolali ali atoame kowitoai toatiki yapu wa one bokuke wia mekaneyake kimepa kode yename kodeya paigakoa moa potipiai tane kota tetepo takakino, poe wa wia tikatapeka. ");
INSERT INTO wiu_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Yesu losu yapu pa eida kakale leneta liane yeneka kawa okeane yeneka one kakata nokoli epetekatapeka. ");
INSERT INTO wiu_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Yesuyo ele kule telekole tokaka eida tobou losu yapu kakoi mati-kitame ka̱ oa kakete ekete Depidi-loeke tagenago kei piatoe wa ka̱ oa kakoi. Nimo okoli yatekete tekete Akolalike lodo yotokoai tane tobou ali-kitika Yu yenane totono pine to̱a olaukane ali-kitika Yesu-pala wene poaneya kakete ekete ");
INSERT INTO wiu_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","i mati-kitame ka̱ okoa kakimopa yateko-pe wa okoli okome e̱eno yateku. Enikepa Akolaline bokuke eya wa wia mekaneya pikono, yakoe. Akolali ne kei piatiki toa dee mati-kitameka nana mati-kitameka kei pia kamotoa neme toko wa Depidiyo Akolali-pala akeneya. Eni agale tiginipa kime oi moamokoiya-pe wa Yesuyo oomotokome ");
INSERT INTO wiu_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","e yene tewitikoa Besani take pome pipoka. ");
INSERT INTO wiu_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","19","Podolikama likonu witia Yesu Yerusaleme ta wa wakapea poademe pokome pake kobume tukome ete enapekome enekale yomo piki pade batete kebonoke kakale eneka. Nitoa pinele pome enekale tata pitikoa kakomeke ku̱ tumeadeka. Nitadekale eni yomo kikoa okome okome ku̱ pade wa tukilepa toamea wa okale eina eina totoa ala tootapeka. ");
INSERT INTO wiu_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Nitikale enekete one oya-lawe wene kainya pianeya kakete ekete ina yomopa odepeta totoa ala tootapekono, edoa tokoto-pe wa okoli okome ");
INSERT INTO wiu_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","kipala i nimini ukumo yakoe. Poome toameneya mea Akolalike wene tugoa meketepa nipa anume ina yomo-pala tokounakale kimeka oyake tekete eya-kitika tamele too. I kako tono mati-pala ekete ne wete to̱a kusa ue muke kuta poke kapa wa okolika oyake pome kapoo. ");
INSERT INTO wiu_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Eya waneka ukuno yakoe. Akolali kowitiketeka oneme yakoa too wa oneke wene tugoa mea kowitikolipa yakoa too wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu Yerusaleme tobou losu yapu pome olaukoa kakaka Akolalike lodo yotokoai tane tobou ali-kitika Kanosolo ali-kitika Yesu kakata nekete ekete neke tokolepa te patu kautakoa kake toko-pe. Teyo tamene wa okole toko-pe wa yakanokoli okome ");
INSERT INTO wiu_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","kipalaka yakatekumo pikono, yakoe. Oto wa topo takoa okoli yatekenepa nipa noanume toma yakule i ago patu kautakoane kakene tuku wane ouno, yakoe. ");
INSERT INTO wiu_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yoneyo ali atoa ue motokakilepa tene peku noa toka-pe. Akolaline peku patu. Kini kaua-mikitane peku patu. Yakouno, oe-na-kale kini kini yakaate tekete ekete edemo wa ato-pe. Akolaline peku noa toka wado okolopa nipa Yone einagome okagale edeyake yakoa moamokoi-pe wa i agome oono, nimo wamato, ");
INSERT INTO wiu_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Nimo wameneya one kaua-mikitane peku noa toka wado okolopa i ali atoame toto wia tukatikiyano. Yone einagopa Akolaline agale to̱awea akane ago tadeko wa ikiya tokome nitoino, enimoka wamato wa ete Yesu-pala ekete ");
INSERT INTO wiu_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","wene toamokono, Yone einago tene peku noa toka patu-koli okome nipa noanu toma yakulepa i ago patu kautakoane kakene tuku wane wamou wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Kipala eya waneka yatekene ukuno yakamene. Panagono manata takuta kakeneya. Wa padepete namolo ago kakata einago pokome okome opi anu ipe takoano pa-kale okome ");
INSERT INTO wiu_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","no pade poamou wa ootokoake one eni wene wia wawa etenane ipe takapaneya. ");
INSERT INTO wiu_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Nitaneyake etene putunago kakata pokome namolo ago-pala okana toa okale okome e̱eno, nitou ta wa ootokoake etenane ipe takapameneya. ");
INSERT INTO wiu_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Nitikala taneyano, etename okale mainagome yakoa taneya-pe wa Yesuyo okale e yename ekete eina namolo ago wa okoli okome nimini ukuno yakamene. Takesi kue motokama yaki ali-kitika pamoko atoa-kitika Akolaline take pikilepa kiwi naniko nomotoa pokala tiki. ");
INSERT INTO wiu_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Nipa ali atoa ue motokama yakana Yoneyo kiwi wene ki̱yo akeneya mekete toatekoile i i wa yametekanake e̱e nimini wa litiamokoi. Litiamokolika eni pa ali atoamepa one okamopa nimini oko wa yakoa tokoi. Nitikoli eneketeke kini poane wene wia wawamoa Yone einagoke wene tugamoa tokoi wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Agale pade pedoane ukuno, yakoe. Panagome-kiti one ipe tootokoa gerepi po matatapeneya. Nitoa pawe toa unukatekoapa one pupu yename po ku̱ kotia pitikoa kawame kautoa ti̱a lobutatekoi kagono wetia latipianeya. Nitoapa payaponalime ta enapea yopia meateka yapu atepea wipianeya. Nitoapa ali pade-mene one ipe kime yopikakamene wa yamemotokome ta padeka pome mepaneya. ");
INSERT INTO wiu_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Nitaneyake ku̱ putua kibutukakoa kawateka tigotoma nokale one pupu ali pade-mene moa wetekakome okome anu ipe yopikaki-kitame no moateku toapa meadete tikino, motokapoatino poe wa moa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Wetekakale nokoli enekete dekoa motekete panago layo toua wia panago wia tukoa panago kueme ka̱ua tukoa taneya. ");
INSERT INTO wiu_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Nitaneyake pinagome pupu ali kainya mati moa wetekakale nokoli namolo tokoinakale taneya. ");
INSERT INTO wiu_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Nitaneyake wipitikomepa eni ali-kitame one mana kei pia makutukoa moi wa wene pikome mana ago ne pa wa wetekakale nokale enekete oote tekete ekete ");
INSERT INTO wiu_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","pinagono mana ku nokona. Etename one pikoa pokaya-kiti kadimo okome kunagono pikademe tokono, one eni moatekoya-kiti toto moatono, kunu ago wia tukatoe wa ");
INSERT INTO wiu_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","dekoa moa tayo lono aua pote wia tukapaneya. ");
INSERT INTO wiu_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Nitikala taneyake ipe pinagome one ipe yopikaki yene-pala edele tonoo-pe wa Yesuyo okale ");
INSERT INTO wiu_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","one agale yakakoa kakoi-kitame ekete ipe yopia potokane ali-mene dika dika toamene tete mea wia atukoo. Nititikoapa one gerepi po ku̱ moateko toa ki̱yotokoa moke toa meatiki ali pade-mene kime yopikamene wa yameoo-koli okome ");
INSERT INTO wiu_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Akolaline bokuke agale dikoa wia mekaneya pikono, yakoe. Yapu wiane ali-kitame i yomopa poadeko wa paya tetepo takoa wakeneyake padekagome i yomopa yapu pigi wa moa wianeya. Enilepa Ali Muno Akolaliyo taneya tokome ke wa kolotine mekete one kei piato wa panagome wia mekapianeya. Eni wia mekanemopa kime oi moamokoiya-pe. ");
INSERT INTO wiu_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Kipala i ukumo yakoe. Akolaliyo kiwi talo toake wakome kiwi luku one pupu wedoa takatiki yatene moa kakoono, nepio. ");
INSERT INTO wiu_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Eni yomo pigike pitakoi ali atoa ka̱ua kugu wititapeoi. Wa eni yomo pigi panagoke pitakome katua tawele takatapeneya pioo wa Yesuyo okale ");
INSERT INTO wiu_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","yatekete Akolalike lodo yotokoai tane tobou ali-kitameka Parisi ali-kitameka ekete ina okana agale-menepa totoke akedekono, ");
INSERT INTO wiu_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","i ago dekatapea moatiyake toko wa kakete eida oboa kakoi-kiti piti motekete tekete wakoi. E kakoi ali atoame i ago Yesupa Akolaline agale to̱awea akako ago tadeko wa wene tokoli ni piti tokale one dekoa moamokoi. ");
INSERT INTO wiu_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","3","Wa naniko Yesuyo pedoa agale pade-meneka e yene-pala okome okome Akolaliyo ali atoa pawe toa talo tokole ooyametekuno yakoe. Tobou agome-kiti one manane atoa motokakene toge ipete kiouno, namene wa oa metane oi nokale one pupu ali-kiti moa wetekakome okome namene wane okouna ali-kiti enemotokapoe wa wetekaneya. Nitikale pote opokoli peyame ekete kote tokono, noamouno, poe wa waamu taneya. ");
INSERT INTO wiu_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Waamu taneyake pade pupu ali-kiti moa wetekakome okome anu toge tu̱ane pikuno, manane atoa motokadene egetekoane mekou pitimekawe kai eya wete wiane kikakakouno, wete noe wa akapoe wa wetekakale enemotokadete pekeneya. ");
INSERT INTO wiu_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","6","Wete noe wa opokoli yakamene lau lau toa kinikileke etepea pekete eya tokala taneya. Panagome one ipe topome panagome one sisoa yopipome wa pade-kitame tobou agono pupu ali-kiti dekoa moa ya motokoa wia tukoa taneya. ");
INSERT INTO wiu_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Nitaneyake tobou ago timini nakale one poyo ali-kiti moa wetekakome one pupu ali-kiti wia tukane yene wia atukoa kini yapuka yotokapoatino poe wa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Nititikoa one pupu yene-pala okome okome manane atoa motokakene toge wete kiane pikene namene wane agale oane wetekakouna-kiti wawa noamikino, toge nee etene nomotoane wamukuno, kiwi lukupa eya yene enemotokapoe. ");
INSERT INTO wiu_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Batete ludu pote ali atoa kotukete ekete tobou agome manane atoa motokakome toge kikakakono, noe wa akapoe wa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Nitikale batete ludu pote kotukoi peya epetanele tane yeneka poanele tane yeneka noe wa enemoma nokoli notepa tobou agono yapu edeya takatapeneya. ");
INSERT INTO wiu_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Nitoa toge noa mekoli tobou ago nokome enekale panago paya mamina kakeneya meadeka. ");
INSERT INTO wiu_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Nitadekale okome anu oya ali nepala ukumo yaka. Manane atoa motokakene kiku toge noadepa weneya mamina kakeneya namene wane okounake kawameadekono, dekale waka-pe-kale agale wametekoa mekale ");
INSERT INTO wiu_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","tobou agome one pupu yene-pala okome okome i ago kawa yonota lutua yomiyomu wa dika dika toamene take moa pitikakapoe wa akeneya wa Yesuyo oka. Nimo ootokoa okome eidapa ali atoa komo ka̱ta nina toa pitikoa kawamoi. ");
INSERT INTO wiu_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Nipa Akolaliyo ali atoa kainya mati oneke noe wa kayo okomeka pa natetekoa takoa mokala toko wa Yesuyo oa tukaka. ");
INSERT INTO wiu_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Yesuyo nimo okale yatekete Parisi yenamepa Yesuyo natemoka omotoa likoa enatekoi oi pedepiadete wa eko keneya witimoa mepaneya. ");
INSERT INTO wiu_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Nitoapa kini totono yakoa tane ali-kitika Erodeke timini kakoa yakene yeneka Yesu kakata poe wa moa wetekakoli pote lede pitia yatekete ekete Tikisa ago nepa niminimo-kama oko. Nitoa ibini akene yeneka ponopene yeneka takoa enamoapa eni yene peya Akolalinele takama pekete toatikile ki̱yooke-kama olaukama poko. ");
INSERT INTO wiu_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Nepa nitane agono wene tekete imodo pitia yatekono, yakamene. Yu yene tone totono litiapa Lomane ako tobou meko ago Sisane takesi kue pitikamato-pe, Pitikato-pe. Yakoono, oa ta wa okoli ");
INSERT INTO wiu_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","kini poane wene pianeya kakoile tetoa enekome okome wene takuta pianeya kakete iki-kitame nopa edeyake likoa eneki-pe. ");
INSERT INTO wiu_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Takesi pitikatiki kue lene enouno, yameo wa okale panagome moa aua nome yametekale okome ");
INSERT INTO wiu_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","i kue lene tiginikepa padane lene timini-pala ibinita wia mekaneyano, eniyatapa teneta patuno, yakouno, oe-na-kale ");
INSERT INTO wiu_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","peyame ekete tobou ago Sisa one wa okoli okome nipa Sisa meatikiya-kiti ni Sisa takoa mea Akolali meatikiya-kiti ni Akolali takoa mea tamene wa okale yatekete ");
INSERT INTO wiu_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","ekee wa wene kainya pianeya tewitikoa pokoi. ");
INSERT INTO wiu_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Einata einapetepa tuane ali atoa wa kamoamoi wa iki yatene Sadusi yatene Yesu kakata nekete likoa enekete ekete ");
INSERT INTO wiu_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Tikisa ago, Moseseyo eya wa akeneya. Panagono atoame one mati opikameneyakedo einago tukalepa one wamene ago neme moa neke natono latikamene. Nipa tukanakago lukuke kawatiki mati opikamotono, nitamene wa Moseseyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Nipa odene agono mana-mikiti tatono kakoa (7) kakeneya. Namolo agome atoa moapa mati opiameneya mea tuaneya. Tuademe pikome one liti opiane ago-pala kadimo okome okome mati opikamotono, anu atoapa ne moamene wa ootokoa tuaneya. ");
INSERT INTO wiu_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Nitikale moapa mati opiameneya oneka mea tuaneya. Tebolo takane agomeka einatoa moa mati opiameneya tuka. Eni wamene-mikiti peyame einatoa kibutua moma-kala nekeneyake panagonoka eina atoame mati opikameneya. Peyapa tiobo ali mea tukala taneya. ");
INSERT INTO wiu_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Nitikala taneyake wipitikomepa einakatoaka tuaneya. ");
INSERT INTO wiu_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Eni wamene-mikitame einatoa edikoa kibutua moma-kala nekeneya. Nitaneyano, tua pokoi ali atoa Akolaliyo kamotokaka-pete einakatoapa mainagono natono wa tugoa meoo-pe wa Yesu likoa enekoli okome ");
INSERT INTO wiu_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","kini wini ikimopa Akolaline bokuke piko agale-pala one telekole tokoleta wene toamekete iki. Nipa pamo ekete tiki. ");
INSERT INTO wiu_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Tua pokoi ali atoa kamoa pote a tibuke mea kaketepa alime atoa moamoa atoa ali poamoa toi. Nipa a tibuke Akolaline edelo-kiti keneya meoi. ");
INSERT INTO wiu_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ali atoa tuapa wa kamoa pote kakimopa Akolaliyo kipala akedekonake one boku moa oi moamokoiya-pe. ");
INSERT INTO wiu_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Eya wa akeneya. Noanupa Eberame Aisaketa Yekobe toa einago-menane Akolaliyo uku wa akeneyano, onepa tuane ali atoane Akolali mena. Mea kama piki ali atoane Akolaliyo uku wa okome akedeko wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Enimo okale yatekete eida oboa kakoi peyame ekete imopa i olaukoa kakono, yakatoe wa ka̱ oa kakoi. ");
INSERT INTO wiu_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Yesuyo one oka agaleme Sadusi ali-kiti moa kautakale agale ete wa topo takamele toamoko wa akedekoli yakamotekete Parisi ali-kiti Yesu kakata obomoa nokoi. ");
INSERT INTO wiu_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Eni nokoi yene padame Yesu likoa enekome okome ");
INSERT INTO wiu_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","awa, Tikisa ago, yonota tua agalepa e tobou kakoa akene agalepa mani-pe wa oka. Ni agopa Yu yenane totono pine to̱a olaukakago. ");
INSERT INTO wiu_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Nimo okale Yesuyo okome neke Ali Muno Akolalike wedoa wene mekoa mea tikilepa neke tepe kolotinime toa neke yominime toa neke weneme toa tamene. ");
INSERT INTO wiu_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Tobou kakoa akene agalepa enina. ");
INSERT INTO wiu_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Nike lokoapa edikane agale eya wa wia mekaneya piko. Pinali neeke wa wene mekoa mea mama motoko toa yete pade ali atoakeka wene mekoa mea mama moamene wa wia mekaneya piko. ");
INSERT INTO wiu_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Moseseyoka Akolaline agale to̱awea akane ali-kitameka Akolaline agale akoa mema neketepa eni agaleta patu-kama kelekoa oma-kala nekeneya. ");
INSERT INTO wiu_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","42","Parisi ali-kiti eida oboa kakakoa Yesuyo yatekome okome Keraisu wa papete ibini oa piane agopa edane ago wa wene piki-pe. Te-laweke ta̱watekago wa iki-pe wa okale ekete Depidi-loeke ta̱watekago wa okoli okome ");
INSERT INTO wiu_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Depidiyo papete Keraisupa one Ali Muno wa ikilepa Epetane Yominiyo wene takakale eya wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Ali Muno Akolaliyopa anu Ali Muno-pala eya wa oka. Nepala poi te̱ia meki ali-kiti moane kawikoane neke kawane komo pikouno, one nimini yono lono noke nepia menamene wa Akolaliyo oka wa Depidiyo wia mekaneya. ");
INSERT INTO wiu_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Depidiyopa Keraisu einagopa one lukoane meku Ali Muno wa akeneyake Parisi yene kimepa Keraisu einagopa Depidi-loeke ta̱watekago wa ikino, dekolo iki-pe-kale ");
INSERT INTO wiu_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","odenagomeka agale topo takoa wamokoi. Nitoapa einapete titimoa padameka agale pade wa pitia yakoaka enameneya. ");
INSERT INTO wiu_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Nitaneyake Yesuyo e oboa kakoi yene-palaka one oya-lawe-palaka eya wa oka. ");
INSERT INTO wiu_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Mosesene totono pine to̱a olaukaki ali-kitika Parisi ali-kitika Mosesene agale patu kautakoa kama piki. ");
INSERT INTO wiu_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Nitiki yename ile tamene ile tamene wa okoile-kama litia tamene. Nimo ukuyake eya waneka uku. Eni yename ile tamene ile tamene wa olaukaketeke pinali-kiti kini eni ikina toa toamiki. Nitikino, kini tikile litia toameamene. ");
INSERT INTO wiu_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Eni yename padeya padeya keda tokoya ali atoane kotomaneke moa aukou toa kini wene keda takakala tiki. Nitikiyake eni keda nateya deyaka yapetekoa ate motokamiki. ");
INSERT INTO wiu_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Eni yename ele kule tikilepa eko ali atoame kiwi kei pia kamotoa tekete keleyo-kama tiki. Nipa Akolaline agale tigini deya pipiake wia mekatekoa mete kabeke lobutukoa pono yonoke pome dekoa togotoa ni kini tokoo kakene mamina nami-menekeka padeya padeya koniyoya ua tukaketepa ludu takoa-kama ua tukoa tiki. ");
INSERT INTO wiu_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Toge kikoikaka ibini akene yene meatikita meada wa pote mepokala tiki. Losu yapu peketeka tobou ali-kiti meatikita meada wa pote mepokala tiki. ");
INSERT INTO wiu_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Makesikeka ali atoame Tikisago Tikisago ke wa kiwi kei pimotada wa yakala tiki. ");
INSERT INTO wiu_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Nitikino, anu oya-lawe kime pade edikameamene. Kiwi peya wamene-mikiti-kama meki. Kiwi talo tukulu Tikisa ago wa kei pia oatiki agopa odene agodo no i kaku. ");
INSERT INTO wiu_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Kiniketai wa oatiki agopa a tibuke meko Akolalino, itonoke meko ago edikoa atai wa wameamene. ");
INSERT INTO wiu_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ete ali atoame kiwi Ali Muno wa kei piamomotamene. Kini Ali Muno wa oatiki agopa no Keraisu odene. ");
INSERT INTO wiu_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Kiwi panagome one ako ago kawou wado okagopa one oya-mikitanele takama pamene wane uku. ");
INSERT INTO wiu_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Onepa ako ago kaku wa wene pikagopa Akolaliyo keku moa kakoo. Onepa keku ago kaku wa wene pikagopa Akolaliyo ako moa kakoo. ");
INSERT INTO wiu_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Ae, kini totono pine to̱a olaukaki ali-kitika Parisi ali-kitika wene takuta pianeya mekino, Akolaliyo kibu moono, nepio. Kini eya toma yakike ni uku. Akolaliyo talo toko take ali atoa poadete tikili ka wia ketekatapekala tiki. Nipa one take poamouketeke tiki. ");
INSERT INTO wiu_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Ae, kini totono pine to̱a olaukaki ali-kitika Parisi ali-kitika wene takuta pianeya meki. Nipa nepo atoa-kiti oa yotokoa kini yapu eya kode keneya motikiyake eka ali atoame kiwi kei pimotoa lede kowitikete kutupea pa agale likoa pikala tiki. Ae, Akolaliyo kiwi kibu motokomepa dika dika toamene tete meoono, nepio. ");
INSERT INTO wiu_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ae, kini totono pine to̱a olaukaki ali-kitika Parisi-ali-kitika wene takuta pianeya mekino, Akolaliyo kibu moono, nepio. Kini peku lawetatiki agopa tuku toma pato wa ka ludu pote ue dipikeka mea pote tuku toma yaki. Tuku toa enamutuketepa kini peku noa tamene wa lawetekili kini tiki poanele moa patukoa poane take poko. ");
INSERT INTO wiu_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Ae, leneta lianeya mekete ete ali atoa etepea lia aua yaki-kiti Akolaliyo kiwi kibu moono, nepio. Ali atoa olaukaketepa eya wa ikili tekene ni uku. Panagome-kiti okome tobou losu yapu ti̱a ile tou wa ootokoake toamokomepa kini totono tetekakoya mena wa iki. Nipa tobou losu yapu paya tetepo takoa iki. Nitikiyake panagomepa eni tobou losu yapu keneke golo kueme latia pianeya-kiti ti̱a ile tou wa ootokoake toamokomepa kini totono tetekako wa iki. Nipa eniya-kiti tobouya tetepo takoa iki. ");
INSERT INTO wiu_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ae, leneta lianeya mekete tiki. Eniyatapa Akolaliyo maniya tobouya tetepo takako-pe. Tobou losu yapu patu. Tobou losu yapu keneke pianeya tokome one wa takoa motane golo kueme latianeya-kiti patu. ");
INSERT INTO wiu_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ni panagome-kiti Akolalike lodo yoai tiki walai ti̱a ile tou wa ootokoake toamokomepa kini totono tetekakoya mena wa iki. Nitikiyake panagome-kiti eni walaike lodo yotiki melepu ti̱a ile tou wa ootokoake toamokomepa kini totono tetekako wa iki. ");
INSERT INTO wiu_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ae, leneta lianeya mekete iki. Eniyatapa Akolaliyo maniya akoya tetepo takako-pe. Walai patu. Walaike pianeya tokome one wa takoa motane melepu patu. ");
INSERT INTO wiu_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Panagome-kiti Akolalike lodo yoai tiki walai ti̱a ile tou wa okomepa nipa mone eni walaike lodo yotikiya-kitika kikilikoa ti̱a pikome toko. ");
INSERT INTO wiu_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ni tobou losu yapu ti̱a ile tou wa okomepa nipa mone eni yapu keneke meko ago Akolali one-kitika dekoa kikilikoa okome toko. ");
INSERT INTO wiu_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ni tibu ti̱a ile tou wa okomepa nipa Akolaliyo ali atoa talo toa meko walai-pala Akolalita dekoa kikilikoa okome toko. ");
INSERT INTO wiu_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Ae, kini totono pine to̱a olaukaki ali-kitika Parisi ali-kitika wene takuta pianeya mekino, Akolaliyo kiwi kibu moono, nepio. Eya toma yakike ni uku. Kini yamanu ludu witakoya nee deya-kiti pilia moa oi moteketepa yonota tua pikolopa odene katekamoa ipa Akolalineya wa takoa pikakala tiki. Nipa Akolaliyo tobou kakoa yametanele wawa toameketeke tiki. Akolaliyopa eya tamene wa tobou kakoa yametaneya. Ali atoa takoa enekilepa ki̱yoke-kama tamene. Ete ali atoa mama moa auapeamene. Onekele wedoa takama pamene wa tobou kakoa yametaneyano, enika enile tamene. ");
INSERT INTO wiu_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ae, leneta lianeya mekete ali atoa etepea lia aua yaki-kiti eya tou toa pale-kama tiki. Neneku̱ uele tuaneya pikolo enekete moa mitikatekoa nomoa naki. Nitiketeke kamelo kai ue nakakome tuaneya pikolo enekete moa mitikameneya ue nomoa naki. ");
INSERT INTO wiu_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Ae, kini totono pine to̱a olaukaki ali-kitika Parisi ali-kitika wene takuta pianeya mekino, Akolaliyo kibu moono, nepio. Eya toma yakike ni uku. Mete okolo eya lede abe ko̱otapeou toa tekete ekolo pa abe kamotoa tokoo abe ko̱otapekala tiki. Nipa kepeneme epeteku wa oake kini tepenepa lene pia mone panagoneya-kiti moadiya wa enika eni poanele toma yaki. ");
INSERT INTO wiu_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ae, leneta pianeya meki Parisi ali-kiti kini mete abe kogilepa namolo takoa ekolo ko̱otapeamene. Nitikolipa tokoo-kitika abe kawamoo. ");
INSERT INTO wiu_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Ae, kini totono pine to̱a olaukaki ali-kitika Parisi ali-kitika wene takuta pianeya mekino, Akolaliyo kibu moono, nepio. Akolaliyo kipa tuane ali atoa oloyo tane ta tetepo takoa wako. Tokoo kalotokoa pianeyake ekolopa tono koloa kawa kepene meleputa lomukome kego witianeyata koloko. ");
INSERT INTO wiu_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Kini kepeneme ki̱yo akene wene pianeya meane tetepo tokoyake tepene wene takuta pianeya mea e ku poane weneka pianeya mea tiki. ");
INSERT INTO wiu_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Ae, kini totono pine to̱a olaukaki ali-kitika Parisi ali-kitika wene takuta pianeya mekino, Akolaliyo kibu moono, nepio. Eya tikike ni uku. Akolaline agale papete to̱awea akane ali-kiti oloyo taneka nateya yapu deya wikakoa ni wene ki̱yo akeneya meane yene oloyo taneka kalotokoa tiki. ");
INSERT INTO wiu_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Nitikete ekete Akolaline agale to̱awea akane ali-kiti meane-pete toto meoo tokapa nipa tone kaua-mikiti-pala kibutua eni ali-kiti wia tukamoo toka wa ikilika ");
INSERT INTO wiu_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","kipala eya wane uku. Akolaline agale papete to̱awea akane ali-kiti wia tukane yenepa kini kaua-mikiti wa wini ikipa nitane yeneke tagooya wa ekete iki. ");
INSERT INTO wiu_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Pegetoa kini kaua-mikitame toa potokoa nami kakalogane yano opi kime wipitiamene. ");
INSERT INTO wiu_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Kipa kayane yagono-mikiti. Akolaliyo poane take moa pitikademe tokono, manika edoa petoa poadete-pe. ");
INSERT INTO wiu_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Dikane yene kipala eya wane ukuno yakoe. Akolaline agale to̱awea akane ali-kitika wene muno meane ali-kitika one agale pine to̱a olaukakoi ali-kitika wini moane wetekakolu eni yene-pala eya tokala toi. Padeka-kiti yomo lekaneyake wia tukoa ni padeka-kiti kini losu yapu keneke layo toua wia ni kini pitikoika ete takoa litikala toi. ");
INSERT INTO wiu_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Enipa kini kaua-mikitame papete toma nekenele opi wa kimeka tokala toi. Kini kaua-mikitame padele toamene ali-kiti pa puputua wia tukama nekeneya. Titikilepa Keineyo wamene Ebele wia tukaneya. Wipitikilepa pade ali-kitame Berekaiane mana Sekaraia tobou losu yapu keneke wia tukaneya. Nipa eyata pakeke tobou losu yapu olege takoa tipi tane yapu luku-pala lodo yoai tane walaita eniyata pakeke Berekaia wia tukaneya. ");
INSERT INTO wiu_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Kini kaua-mikitame toma-kala nekeneke nami wiapa Akolaliyo kabe koukoa kiwi kibu moono, nepio wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ae, Yerusaleme ta neke wida pitikoi yename Akolaline agale to̱awea akane ali-kiti wia tukama-kala nekeneya. Ni neeke wida Akolaliyo moa wetekane ali-kitika kueme ka̱ua tukakala tane toa opii pa tiki. Nitaneyake ogadame-kiti idini-kiti pawena keneke luumoa pitikou toane tekene neke wida pitikoi yene pawe toane moadene tokounake ko̱ite katite toa wakala tokoina. ");
INSERT INTO wiu_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ae, Yerusaleme ta nepa tumu tokamotoa neke wida pitiki yene to̱a pootapeoi. ");
INSERT INTO wiu_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ae, neme no papete wa enekileka toamoo. Nipa no i agopa Ali Muno patu kautakoa kama nokono, Akolali neme wedoa mekamene-ye wa no wete wa makutukoa moameneyakepa anu lene timini wa pade enamoo wa Yesuyo Yerusaleme ta-pala oka. ");
INSERT INTO wiu_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu tobou losu yapu tewitikoa pokaka one oya-lawe nekete ekete i tobou losu yapu kue pawe keneke ekolo wianeya kako yapu-kiti ena wa okoli okome ");
INSERT INTO wiu_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","wini wianeya kakoya-kiti enekamene. Enika eniya latiane kue odeneka kibutukoa piameneya peya wia tadekatapeneya tumu tokaneya pioo wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesu Olipe-pini tono waneke pome mepoka. One kidene eida paka witimoa mekale one oya ali-kiti nekete ekete neme ina okanakalepa manipete taatekoa toko patu. Wipitia ta patakale ne wakapea noateka tigotokalepa edeya wa adeka pipioo-pe wa okoli okome ");
INSERT INTO wiu_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","5","eni okounakale wete taatekameneyake pade ali-kitame anu ibini lede wedekoa nekete ekete Keraisu taatekoane nukuno, noe wa ali atoa peya mati oa yotokoino, wedoa lene kia nepikoa meamene. ");
INSERT INTO wiu_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Enipetepa u̱u wa poi toa kakoimo yakoa ni pade take poi tago wa okoimo kugu yakoa toino, piti moameamene wane uku. Enilepa taatekoa namolo takoa toatekoyake wipitia ta pade tigotokoa wete patamoo tokolo ni uku. ");
INSERT INTO wiu_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Nipa e ku yatename poi tato wa kamoa poi te̱itakutukakala toi. Ni e ku tobou ali-kitike lukoa mekoi yatene ete oto wa poi toa winali yoi. Eka kuka takeka kobu igi nome momani toa tokala too. ");
INSERT INTO wiu_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Enika enilepa atoame mati opiademe namolo takoa mukiti nako toa keneya too. ");
INSERT INTO wiu_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Enipetepa pade ali-kiti kipala kotimi yotaneya meketepa tete takoa wia tukakoatino toe wa dekoa moa eko yeneke lia aua poi. Nipa nopala odene ibini pedane yene tokale tekete padeka padekata mekoi peya kipala kotimi yoa meoi. ");
INSERT INTO wiu_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Enipetepa ali atoa kainya matiyame Akolalinele takoake wakete panagome panago moa poi te̱iane yenane yonoke pia eka okata kotimi luutakutukoa mema poi. ");
INSERT INTO wiu_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ni ali kainya matiyamepa Akolaline agale akakuno, yakoe wa ali atoa peya mati oa yotokama poi. ");
INSERT INTO wiu_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ele kule poanelepa ate toma ponokale tokome ali atoa kainya mati wene mekanali yoma pokoinakale tewitikoa wakala toi. ");
INSERT INTO wiu_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Nitoa kakolika nooke wene tugoa mea togakoi-kitipa toa motaneya mea kama poi. ");
INSERT INTO wiu_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Papetepa Akolaliyo ali atoa pawe toa talo tokome tokomo ta piko peyake mekoi-kitame yakamotoa oa pupitikatapeoi. Nititikaneyakepa wipitia ta patoo wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Tobou losu yapu olege takoa tipi tane yapu luku kenekepa kitau oko wa okoiya witakale enoi. Nipa Akolaline agale akane ago Danieleyo papete oa piane toa taatekoa tokale enoi wa Yesuyo oka. (I boku wiane mekaku agome eya wane uku. Ina wiane mekakumopa wene taneya meamene.) ");
INSERT INTO wiu_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Yesuyo nimo ootokoa eya wa oka. Enile taatekoa tokale eneketepa eya tamene. Yudea take meki-kitipa nipa tono-kiti pake pake to̱a pitoa pote paigakoa mepamene. ");
INSERT INTO wiu_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Yapu liti ko meapa kini yapu keneke pikoina mopameneya pa pitoa pamene. ");
INSERT INTO wiu_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ipe toa kawapa tigini mamina kotokoa pikana mopameneya pa pitoa pamene. ");
INSERT INTO wiu_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ae, mati kakene atoa-kitika mati adu tanikakoa mekoi atoa-kitika eni tete witaka-pete manika edoa petoa pomotoa-pe. ");
INSERT INTO wiu_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Eni moatekoi tetedo kalepetaka pupu toameneya ko meatekoi-peteka witakalepa manika edoa petoa pomotoa-pe. Dikane-pete witamomotoa ta wa Akolali kowitoa kamene. ");
INSERT INTO wiu_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Dika dika toamene tete eni witakilepa itono tibuta latitikaneyakeka toamokale-kiti too. Eni tete witatekaneyake naniko pade edikanele wa witamoo. ");
INSERT INTO wiu_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Akolaliyo eni tete witama pomotoa yopikoa kaka pakedo teigamoo tokapa ali atoa peya atutapeoi toka. Nitoi tokake one wa takoa motane ali atoa ela motokome tokome pegene kakoa teigoo. ");
INSERT INTO wiu_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Enipetepa pade ali-kiti nekete ekete Keraisu ku nokono enoe, i nokono enoe wado okolipa kapene agale eni ekete toino, yakameamene. ");
INSERT INTO wiu_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kapene yename eya wa wini onoi. Keraisu nuku wa oa Akolaline agale akama nuku wa kiwi oa yotokadete padele padele telekole tokala toi. Nitikete Akolaliyo takoa motane ali atoaka tolopi toadete wili toa kakete oyake nitamele toamokale wakala toi. ");
INSERT INTO wiu_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Enika enile wete taatekameneyake papete i agale eni wene takapikuna. ");
INSERT INTO wiu_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Pade-kitamepa Keraisu enakagopa ali piamene ta ludu yako wa oino, yakoa ponameamene. Ni Keraisu enakagopa yapu luku keika paigakoa meko wado okolipa eni pade yakameamene. ");
INSERT INTO wiu_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","No Ali Yatenane Oyago wakapeane nekenepa katiapale keleyo pi̱atapeko toane keleyo nokolu peyame enekete enetapeoi. ");
INSERT INTO wiu_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ali tuaneya lomua kakata kego naki ini kiti odepeta koukoa note puka puka toa yaita kawei wa Yesu oka. ");
INSERT INTO wiu_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Enika eni tete witoa kawa peya tokale eni eni lou yomiyomu takoa tokene-kitika pa̱ toamoa too. A tibuke tagoi-kiti kotia pitoa too. Ni tibuke tele taneya mekiya moa peteka peteka takoa too. ");
INSERT INTO wiu_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Nitoa kawa wipitikale eni eni Ali Yatenane Oyago noanu adekapa a tibuke witoo. Nitikale ta piko peyake mekoi yatene ali atoa tumai keneya mekete komo ka̱ta pitikoa kawa enekoli no Ali Yatenane Oyago wedo patu meane pa̱ teleta toawineya nokolu enoi. ");
INSERT INTO wiu_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Nika yeteka yukukataka anu papete takoane moopikou-kiti peya odeneka moa obokamotoane tekene edelo ali-kiti moane wetekou. Nitikolupa a tibuke pu̱ wa beta pikoa kakomokale yatekete moa obotapeoi wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Yomo piki witakole wene taneya meamene. Papete yeneneke page ka̱ua luno pitikakolo eneketepa poto toko tokene-mene tigotatekolo toko wa wene tiki. ");
INSERT INTO wiu_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Eina toa anume okounakale-kiti witatapekale eneketepa inakago wakapea noateko eni tigotokona wa wene toi. ");
INSERT INTO wiu_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Etene nimini toatekomo ukuno, yakoe. Ipete meki peya wete tuutapeameneyake kipala ina okounakale-kama taatekoa too. ");
INSERT INTO wiu_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Itono tibuta takoa pootapekolika anu agalepa pa pia-kama kawoono, yakoa moamene wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Enika enile wipitia toatekolepa padameka ipeteka i lou pinika taatekoa too wa wene toamiki. A tibuke meki edelo ali-kitameka wene toamiki. Akolaline mana noanumeka wene toamuku. Atai Akolaliyo odene wene toko. ");
INSERT INTO wiu_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","No Ali Yatenane Oyago wakapeane nokou-petepa Noa einago meane-pete tanele too. ");
INSERT INTO wiu_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Noa meane-petepa ete yene paya nou toa mekete nee ue eyake wene piitikaneya mea alime atoa moa atoa alike pote tokala taneya. Nipa Noa tube ue dipi keneke pome mepokaleka ");
INSERT INTO wiu_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","edikoa paya nou toa meaneya. Nitoa mekoika kotikatapea ue atepea kaugu pokome toa atukatapeneya. Eina toa ali atoa paya nou toa mekakoane no Ali Yatenane Oyago wakapeane nekene kotikatapeane nou. ");
INSERT INTO wiu_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Nipetepa ali takuta ipe toata kakoita panago eida kamotoa Akolaliyo padena ago takoa moa poo. ");
INSERT INTO wiu_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ni atoa takuta odenekata kawa kini witi ku̱ kugutukoa kakoita pade atoa eida pa kamotoa padena atoa takoa moa poo. ");
INSERT INTO wiu_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Nopa kini Ali Muno kotikatapeane wakapeane nouno, wedoa lene kia nepikoa meamene. ");
INSERT INTO wiu_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Eya waneka ukuno, yakamene. Yapu pinagome-kiti onekeya kode monatekago likonu ipete noo wa wene too tokapa yapu bulukoa kode agome onekeya monamomotoa tokome atu piameneya wedoa yopia kawoo toka. ");
INSERT INTO wiu_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Eina toane no Ali Yatenane Oyago kotikatapeane nouno, wedoa lene kia nepikoa meamene wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Tobou agonole-kama wedoa wene toa takako agoke ukuno yakamene. Tobou agome dikane ago-pala eya wa oa too. One ali atoapa neme yopikamene wa oapa kini nee eya noatekoi toa oneme-kama tatia lawetekamotoa moa kakoo. ");
INSERT INTO wiu_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Nitimotokome ta padeka pome mea wakapea nokome enekale oneme tamene wa oa pokanakaledo pa takama pekedekale enekomepa ke wa one kolotini natekoa too. ");
INSERT INTO wiu_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nipa onekeya peya neme-kama yopikamene wa moa kakoo. Enipa niminimo uku. ");
INSERT INTO wiu_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","49","Tobou agonole takoa potokako agomepa nipa eya oa too. Tobou ago wete wakapea noamoo wa oapa one odene pupu yene layo toua wia ni bia ue nokoa pia leau akeneya mekoi ali-kiti-pala opia mekome bia ue eya nokoa pia too. ");
INSERT INTO wiu_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Paya nou toa nitoa mekaka tobou ago kotikatapea nokome ");
INSERT INTO wiu_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","einago dika dika toamene tete meoo. Nitoapa wene takuta pianeya meki yene-pala opia mea kawati wa kiwi pakeke moa mekoo. Eidapa ali atoa komo ka̱ta nina toa pitikoa kawamoi wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","No Ali Muno wakapeane nokou-pete Akolaliyo ali atoa pawe toa talo tokome tokale ooyametekuno, yakamene. Noi kakoa (10) tuatoa-kitame eya taneya. Panagome one tu pia kakene atoa moademe nokale ekete einago kotua patoe wa kini laboke olipe ku̱ page peia kapetekoa aua pokala taneya. ");
INSERT INTO wiu_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","4","Ko kakoa (5) tuatoa yatenamepa aua kelea paya nou toa pa pekete naniko peiatekoi pagepa mete padeke aua poameneyake e pade ko kakoa (5) tuatoa yatenamepa paya nou toameneya naniko peiatekoi pagepa mete pade-mene kapetekoa aua pokala taneya. ");
INSERT INTO wiu_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Einago noateka teigoa pekete kago keteponoke nepia kakoiyake wete noamokale atu togoikoa mea einaka piimu taneya. ");
INSERT INTO wiu_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Pitikakoa likonu panagome kayo oa kakome okome atoa moatekago i nekedekono, kotua wete poe-ye wa kayo oa kakomo yatekete ");
INSERT INTO wiu_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","kamoa kini labo moa nodoka nodoka tokala taneya. ");
INSERT INTO wiu_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Nititikoa ona ko kakoa (5) paya nou toa nokoina tuatoa yatename ekete oya, tone labo pene tu̱ademe tokono, kini olipe ku̱ page pade manoe oikoli ekete mena. ");
INSERT INTO wiu_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Toto peyane labo udukateko toa kotuke aua noamokoo patuno, kini winika tuku toa sisoake olipe ku̱ page topo topoe wa okoi. ");
INSERT INTO wiu_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Poe wa okoli poadete pokoika atoa moatekago nekeneya. Nokale paya nou toameneya nepikoa kakene tuatoa-kiti einagono atoa motokadete toge kikakane yapu one-pala opia pote mepaneya. Nitikoli panago nome kago ketekitikaneya. ");
INSERT INTO wiu_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","12","Nitaneyake ona tuatoa yatene wakapea nekeneya. Nekete ekete kamo koniyali toto i note kakono, kago pekanamene wa kayo okoa kakoli okome kiwi wene toamuku wa pekanameneya wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Nimo ootokoa okome atoa moatekago nokome tane toane noka edikoane kotikatapeane wakapeane nouno, wedoa lene kia nepikoa-kama kamene wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Akolaliyo ali atoa pawe toa talo tokole ooyametekuno, yakamene. Panago ta tetemada poademe kakome one pupu takane ali-mene one kakuta noe wa kayo oa moapa one iya-kiti kime pikoa metekamene wa onekeya tatikamu taneya. ");
INSERT INTO wiu_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Nitikomepa panago ko kakoa tawisini (5,000) kina mea ni panago tatigi kakoa tawisini (2,000) kina mea ni panago odene tawisini (1,000) kina mea taneya. Enipa kini pupu takoukete tele tane kotuke tatikamotokome pekeneya. ");
INSERT INTO wiu_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Pokale ko kakoa tawisini (5,000) kina motokanakagome eni kueme tine pikoapa wa ko kakoa tawisini (5,000) kina tokoo motokaneya. ");
INSERT INTO wiu_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Eina toa tatigi kakoa tawisini (2,000) kina motokanakagome eni kueme tine pikoapa wa tatigi kakoa tawisini (2,000) kina tokoo motokaneya. ");
INSERT INTO wiu_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Odene tawisini (1,000) kina motokanakagomepa nitameneya one eina metekana kue moa pome itono wetia potipipaneya. ");
INSERT INTO wiu_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Kue pinago ta tetemada pome mea kawa oto wa wakapea nokome okome auna kue-kiti pikoa metekakete edele-kala takakoi-pe wa pitia yatekale ");
INSERT INTO wiu_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","ko kakoa tawisini (5,000) kina motokanakagome one namolo motokana toa peya ete meetekoa eina nine kueme tine pikoa motokane ko kakoa tawisini (5,000) kinaka metaneya. Metekome okome Ali Muno nemenapa no ko kakoa tawisini (5,000) kina mea pokana. Wa ko kakoane tawisini (5,000) kina tokoo motokakouno, ina wa metaneya. ");
INSERT INTO wiu_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Nitikale one Ali Munagome motokome okome ouo, anukulepa neme wedoa takadeko. Enilepa nateleke neme wedoa takadekono, opa padele-kiti tubele mati takatekole ne yameou. Opa neke Ali Muno nopala kolotine meatoane uku wa one kei pia kakeneya. ");
INSERT INTO wiu_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Nitaneyake tatigi kakoa tawisini (2,000) kina motokanakago nokome okome Ali Muno nemenapa no tatigi kakoa tawisini (2,000) kina mea pokana. Tatigi kakoane tawisini (2,000) kina tokoo motokakouno, ina wa metaneya. ");
INSERT INTO wiu_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Nitikale okome ouo, anukulepa neme wedoa takadeko. Enilepa nateleke neme wedoa takadekono, opa padele-kiti tubele mati takatekole ne yameou. Opa neke Ali Muno nopala kolotine meatoane uku wa tobou agome one kei pia kakeneya. ");
INSERT INTO wiu_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Nitaneyake odene tawisini (1,000) kina motokanakago nokome okome Ali Muno nekeya kamu tokolo meke eya toko. Panagono ipe neme padeyaka matamokoyake one eni ipe kakoya nee neme wakoa mokala toko. Wa panagome matane yomopa eni yomo ku̱ neme kotia moa nako. ");
INSERT INTO wiu_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nepa dikane agono wene tekene piti tokale mekene nekena kue itono wetiane kaukalogakou. Nekena kue ina wa ete metekale ");
INSERT INTO wiu_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ali Munagome kikoa okome okome nepa kote au keneya moa loyo-kala kako agomeke nooke eya wa ko̱ okana. Panagono ipe padeya matamekeneke one eni ipe kakoya nee wakoane moane wa panagome matane yomopa ku̱ kotiane moane noane tuku wa neme nooke ko̱ okana. ");
INSERT INTO wiu_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","No nitane agono kuepa bage pikapikinakeya, dekale waka-pe. Bage pikapoo tokapa anu kueme tine pikane kue-pala oto mou toka wa kikoa ootokoa kakome ");
INSERT INTO wiu_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","one ete pupu ali-kiti-pala okome one kue moe. Mootokoapa noi kakoa (10,000) kina pikoa kako ago metekapoe wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Nitaneyano, Akolaline peku wedoa nakagopa nipa Akolaliyo one peku wedoa lawetema pokale kamo toma pou toa etene wedoa toma poo. Akolaline peku alekoa noma pokagopa nipa onekeya nateyaka eniya peya Akolaliyo takoa wa mootapeoo. ");
INSERT INTO wiu_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Pupu takoa potokako agopa yomiyomu dika dika toamene take moa pitikamotoane uku. Eidapa kime kolukoa ali atoa komo ka̱ta nina toa pitikoa kawamoi wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","No Ali Yatenane Oyago a tibuke pone meane wakapeane nekenepa nipa anu edelo ali peya-pala opiane pa̱ teleta tootapeneya nou. Nitikene ali atoa talo tekene meatekou walaike yati yati toologane walaike pone mepou. ");
INSERT INTO wiu_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Nitikolu anu leneke ta padeka padekata mekoi yatene peya koukoa note-kama kanoi. Note kanokolipa talo tokagome-kiti sipi sipi kaika meme kaika eka okata takoa moa kakako toane tou. ");
INSERT INTO wiu_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Nipa sipi sipi kai tetepo takakou ali atoa anu nimini yono lono moane kakoane meme kai tetepo takakou ali atoa ewa yono lono moane kakoane tou. ");
INSERT INTO wiu_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Nititikoanepa no Ali Muno nimini yono lono kakoi yene-pala ekene Agetaiyo pewe wia kako-kiti kipa one talo toko take menoatino noe. Eni taapa Akolaliyo itono tibuta latika-peteka kini wa nodokakapianeyano, noatino noe wane ou. ");
INSERT INTO wiu_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Nipa kime eya toma nokoinake ni uku. Kobu tokale mekolu enekete nee moa lawetekoina. Ue nodo tokale mekolu enekete ue nomoa lawetekoina. Mone pade take ago nokounake kini yapu nee noano, noo wa no makutukoa motokoina. ");
INSERT INTO wiu_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Mamina kawameneya mekolu enekete i mamina kawano, ina wa kini mamina metekoina. Yene tokale pikolu mama moa auapenokoina. Po yapu pitikolu weye akadete ugu nokoina wane eni yene-pala ou. ");
INSERT INTO wiu_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","No Ali Muno agome nimo okolu yatekete eni wene ki̱yo akeneya mekoi yename eya wa oi. Ali Muno neme eni oka toapa manipete kobu tokale mekale enekete nee moa lawetekoto-pe. Manipete ue nodo tokale mekale enekete ue nomoa lawetekoto-pe. ");
INSERT INTO wiu_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Manipete mone pade take ago nokale enekete moa makutukoa motokoto-pe. Manipete mamina kawameneya mekale enekete kawateko mamina ina wa metekoto-pe. ");
INSERT INTO wiu_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","40","Yene taneya pikataka po yapu pitikataka manipete ugu nokoto-pe wa yatekoli no Ali Munoyo ekene widikoa anu ponopeneya meane ali atoa auapekoipa nopala eina dekoa auapekoina wane ou. ");
INSERT INTO wiu_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Nititikoane kakene anu ewa yono lono moane kakakouna ali atoa-pala eya wane ou. Akolaliyo wakome wakene yene no tewitikoa poe. Setanuka one edelo ali yateneka pote mepomotoa nodokakapiane toe mine mepoatino poe. Kime eya tokoinake ni uku. ");
INSERT INTO wiu_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","No kobu tokale mekolu eneketeke nee moa lawetamokoina. Ue nodo tokale mekolu eneketeke ue nomoa lawetamokoina. ");
INSERT INTO wiu_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Mone pade take ago patukakolu eneketeke no makutukoa moamokoina. Mamina kawameneya mekolu eneketeke kawatekou mamina moa meamokoina. Yene tokale pikoutaka po yapu pitikoutaka ugu note auapenamokoina wane ou. ");
INSERT INTO wiu_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Nimo okolu ekete ae, Ali Muno manipete ne kobu tokale mekale eneketeke nee wanakoto-pe. Manipete ue nodo tokale mekale eneketeke ue nomoa lawetamokoto-pe. Manipete ne mamina kawameneya mekale eneketeke kawateka mamina ina wa meamokoto-pe. Manipete ne mone pade take ago patukakale eneketeke makutukoa moamokoto-pe. Manipete ne yene taneya pikataka po yapu pitikataka ugu note auapenamokoto-pe wa okoli ekene ");
INSERT INTO wiu_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","anu ponopeneya meane ali atoa auapeamokoipa nipa nopala dekoa eina auapeamokoina wane ou. ");
INSERT INTO wiu_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Nitikoina wane wakou-kiti poane take pote mekete dika dika toamene tete moi. Nitikoiyake wene ki̱yo akeneya mekoi-kiti pa mea kama poi wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","2","Yesuyo einaka einamo oa peya takatekoapa one oya-lawe-pala okome okome edelo ago patukane wa ibini iki toge kikilepa patepeyo toi. Enipa nimini uku-pe. Enipetepa mone pa yename no yomo lekaneyake wia dekoa tukamotoa panagome Ali Yatenane Oyago no moa meoo wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Einapetepa eya yene Akolalike lodo yotokoai tane tobou ali-kitika Yu yenane totono pine to̱a olaukane ali-kitika ete Kanosolo ali-kitika koukoapa ako odene mekome lodo yotokane tobou ago Kayapasene yapu ponete meponaneya. ");
INSERT INTO wiu_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Eida ponete koukoa meketepa Yesu paigakoa moa wiatekoi oi pedoa pikete ekete ");
INSERT INTO wiu_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","pa ali atoa toto-pala wene poa wili walai wa kakayano, tone toge kiko-petepa dekoa moamato wa oa tukaneya. ");
INSERT INTO wiu_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","7","Yesu Besani take kedime nakeneya mekanakago Saimone einagono yapu meka. One eni yapu mekome nee nakaka pade atoame padeya ka̱lono taneyapa epetane kueme latiane mete keneke mekoa aua nome Yesuno wagoke pekoa yotokatapeka. One eni ka̱lono taneya topo toa moapa kue ako mati wetekoa motokaneya. ");
INSERT INTO wiu_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","9","Einatoame tokale enekete Yesuno oya ali-kiti einatoa-pala wene pokete ekete ina pekoa yotokakilepa pale tokanano, edeya weike toka-pe. Inakeyapa totome moa topo too tokapa kue tubeya moa ponopene ali atoa tatikoo toka wa ko̱ oa kakoi. ");
INSERT INTO wiu_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Nimo okoli yatekome Yesuyo okome i atoane wene dekolo potokaki-pe. Einapa anu koniyole mati takakana. ");
INSERT INTO wiu_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ponopene ali atoa enabuna kiwi pakeke mekala tikino, no pade kiwi pakeke pa tekei meku. ");
INSERT INTO wiu_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ina ka̱lono taneya anu tiginike pekoa yotokakanapa no tuaneya piateku tigotokolo tokome nina nodokoa takapikana. ");
INSERT INTO wiu_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nitikana tokolo eya wane uku. Anukumo ta piko peyake oa pupitikama peketepa i atoame i takakanakamoka oa pupitikama poi. Nipa ta piko peyake mekoi yename one wene taneya memotoa nitoi wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","15","Yesuyo nimo okale one tuku kakoa (12) oyali-kiti pade Yudase Isekariose einagopa Akolalike lodo yotokoai tane tobou ali-kiti mekoita pokome okome Yesu einago kini yonoke moane piouno, kue edela meoi-pe-kale ekete nipa silepa kue lene padeka kabe kakoa (30) meoono ta wa okoli ");
INSERT INTO wiu_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","einapete laigoa Yesu moa metekome toatekale wene kibutuma yakeneya. ");
INSERT INTO wiu_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Yu yename mono mono wamene palawe wane-kiti yoatekoi oi nokale Yesuno oya-lawe one mekata nekete ekete edelo ago patukane wa ibini oko toge nee maida nodokoa piatoa-pe wa okoli okome ");
INSERT INTO wiu_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","19","Yerusaleme ta panago wini meoono, eya wa yatekapoatino, poe. No Yesu wipitikene toateku tigotokolo tekene anu oya-lawe-pala opiane mekene toge nee nouno, oyake wida nonou-pe wa yatekapoe wa wetekaka. One eni okana toa pote yatekatekoa kini toge nee eya eida einagono yapu nodokapianeya. ");
INSERT INTO wiu_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","21","Ta likaka Yesu one oya-lawe-pala eida opia mekome toge nee nakome okome etene nimini ukuno yakamene. Kiwi padame no-pala poi te̱iane yenane yonoke moa pioo wa okale ");
INSERT INTO wiu_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","odene odene wa mekoi peyame ete yatekete ekete wini okolepa noanume toatekumo eke oko-pe wa wene keda toologaneya mekete yakakala tokoli okome ");
INSERT INTO wiu_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","nopala odene okolo kagonoke nee moa tadoata nako agopa no moa meateko ago too. ");
INSERT INTO wiu_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Nipa Akolaline bokuke Ali Yatenane Oyago nopala eni toatekamo papete wia mekapiane toane taatekoane tuou. Ae, no witikamotoa moa meatekagome dika dika toamene tete moo. Eni tete moamademe tokome einago opiameneya too tokapa nipa epetoo tokake opa ae wa okale ");
INSERT INTO wiu_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","one moa meatekago Yudaseyo Yesu-pala okome neme wini okagopa no patu-kale okome e̱eno, nimini oko wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Eni nee noa mekete Yesuyo palawe wane moa Akolali-pala ke wa popimotokome one oya-lawe tatikamu tokome okome ipa anu tiginino, moa noe wa moa laweteka. ");
INSERT INTO wiu_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","28","Nititikoapa gerepi po ku̱ ueka meteke mekaneya katekamoa Akolali-pala ke wa ootokoa okome Akolaliyo oi pedoa pikana toane kadimo uku. Ipa anu kamateno, ali atoa peya mati kini toma pokoi poaneleke Akolaliyo po letu mekakana keetapeane agopa takoukenepa anu kamate ponamotouno, kiwi peyame iya moa noe. ");
INSERT INTO wiu_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nimini ukuno, yakamene. Atai Akolaliyo talo toko take kipala opiane mekene gerepi po ku̱ ue weneya wa moane nouno, papete pade wa nakileka toamou wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Nitoapa lo pade oomoteketepa Olipe-pini tonoke pote witapokoi. ");
INSERT INTO wiu_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Olipe-pini tonoke pome mekome Yesuyo okome opi likonu kiwi peyame no wawa tia tadatapeoi. Nipa Akolaline bokuke nopala eni toatekoileke panagome papete eya wa wia mekapiane toa taatekoa toi. No Akolaliyo sipi sipi kai-kiti talo tokago witikolu one sipi sipi kai-kiti tia tadoa pootapeoi wa Akolaliyo oa piane toa panagome wia mekaneya. ");
INSERT INTO wiu_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Eina wia mekapiane toane taatekoane tukolu Akolaliyo moa kamotokakalepa kiwi naniko nomotoane no namolo takoane Galili take pone mepou wa okale ");
INSERT INTO wiu_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pitayo okome i ali peyame ne wawa tia tadatapekolika noanume ne wawane poamou-kale okome ");
INSERT INTO wiu_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","nepala i ukumodo yakamene. Opi likonu ali ogadame ka̱ wete wameneyake neme no i ago wene toamuku wa tebolo-peta oade toko-kale okome ");
INSERT INTO wiu_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","ne witikete nopala dekoa witikolika ne einago wene toamuku wane wawamou wa okale ete peyameka eina okana toa ootapekoi. ");
INSERT INTO wiu_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yesu one oya-lawe-pala Gesemani wa ibini akene take opia pome kakome okome no yeka tutu pone kakene kowitipukuno, ita nepia meamene wa ootokoapa ");
INSERT INTO wiu_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Pita Sebedine manata-pala aua pokome ela matiyame tuaneya tepene-pala mama mati motaneya poka. ");
INSERT INTO wiu_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Pokome okome no wene kedame tukakolo tuadene meku. Mugili-pala topelekono, tone ita opia mekete nepikoa meatoane uku wa oomotokomepa ");
INSERT INTO wiu_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","nami-takakoa eko keneya kidene pome itonoke aua pitalogoa kowitikome okome atai meteke noateku ue enekupa no tete moatekulu tokono, neme ete moa pedekamedekalepa nitikamene. Nipa anu wene pikule toa wane ekene wamukuno, neke wene pikole tou wa kowitimotokome ");
INSERT INTO wiu_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","one oyali-mene mekoita wakapea pokome enekale atu pia meadekoi. Nitadekoli kamotokakome Pita-pala okome lou pini odeneka nopala lene kia nepikamele toamoko-pe. ");
INSERT INTO wiu_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Setanuyo kiwi likoa enekayano, lene kia mekete kowitamene. Lene kiane nepiane meou wa wene pikiyake tigini popeyo noamokolo atu wini pia meadiki wa Yesuyo oomotokome ");
INSERT INTO wiu_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","kutu keneya taku takoapeta pome kowitipokome okome Atai neme no moateku tete ete moa pedekamele toamokalepa nipa eni tete mootapeou wa kowitimotokome ");
INSERT INTO wiu_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","wa wakapea nokome enekale pa atu pia meadekoi. Atume moa ma̱leou takakale pitakoi. ");
INSERT INTO wiu_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Nitadekoli eko keneya wa pokome one namolo kowitikanakamo tebolo takoa kowitimotokome ");
INSERT INTO wiu_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","one oyali-mene mekoita wa wakapea nokome okome pa koome tuaneya mekete atu-kala pia meki-pe. No Ali Yatenane Oyagopa Akolaline agale tagoa toamiki yename wimotoa moa meateko ago ku nokono, ");
INSERT INTO wiu_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","wete kamokoa kawe. Kotua pekete pato wa oka. ");
INSERT INTO wiu_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesuyo nimo oa kakaka one tuku kakoa (12) oyali-kiti pade Yudase wete eina noka. Nokale ali peya mati koukoa kepete tue layo katekamo katekamo toa obomoa nokoi. Nipa Akolalike lodo yotokoai tane tobou ali-kitameka Kanosolo ali-kitameka Yesu einago dekoa motokapoatino poe wa wetekakoli nokoi. ");
INSERT INTO wiu_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","49","Wetekakoli nekete Yudase Yesu kakata wete nome awa Tikisago wa ootokoa Yesu nunu oka. Enipa papete Yesu dekoa monatekoi yene-pala oi pedoa pikana toa toka. Nipa one pone nunu opokou agopa Yesu eni toono, dekatapea moamene wa okana toa toka. ");
INSERT INTO wiu_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Nitikale anu oya edade noko-pe wa Yesuyo okaka Yudase-pala opia nokoi ali-kiti one kakata note dekoa monokoi. ");
INSERT INTO wiu_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Nitikoli Yesuno oyali pade eniya liti kakome panago wiou wa one kepete tue witimoapa panagono kapidi pine takoa pitikaka. Einakagopa ako odene mekome Akolalike lodo yotokane tobou agono pupu ago. ");
INSERT INTO wiu_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Nitikale Yesuyo one oyago kikoa okome okome panagome kepete tue eya moa panago ka̱wa tukakalepa oneka kepete tueme ka̱wa tukoino, neke wini kepete tue wete lua. ");
INSERT INTO wiu_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Opi agetai kowitikene ekene edelo ali ege egeta wakala kadukoa no mekuta moa weteka-ye wanedo kowitikolupa eni eni yakoa wetekoo. Enipa wene toameke ni toka-pe. ");
INSERT INTO wiu_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Nimo wane kowitamele tokoyake Akolaline bokuke papete wia mekapiane toa taatekamedekolo tekene enimo wamadene waku wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Einata einapete Yesuyo e oboa kakoi yene-pala okome kini kepete tue layo tigini-pala nidikoa aua nikino, nopa kode ago tetepo takakete dekoa moadete niki-pe. Ta pataka abuna kiwi kakakoane tobou losu yapu keneke keleyo olaukoane mekounake no eida dekoa monamokoina. Dekale wakoti-pe. ");
INSERT INTO wiu_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Akolaline agale to̱awea akane ali-kitame papete wia mekapiane toa taatekamedekolo ni tiki wa okale one oya-lawe peyame one tia wawa pitoa pootapekoi. ");
INSERT INTO wiu_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","E yename Yesu dekoa moomoteketepa eya agono yapu ako odene mekome Akolalike lodo yotokoai tane tobou ago Kayapase einagono yapu aua pekeneya. Einago Kayapasene yapu eya ali-kiti Yu yenane totono pine to̱a olaukane ali-kitika Kanosolo ali-kitika wete ponete koukoa meponaneya. ");
INSERT INTO wiu_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Kini koukoa meponaneta Yesu aua pokoli Pita kutu mati kawatati toma nome tobou agono kela pawe patukoa einagono pupu takane ali atoa pakeke nome menaneya. Yesu-pala tokale enoa togademe ni noka. ");
INSERT INTO wiu_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Eida Akolalike lodo yotokoai tane tobou ali-kitameka ete Kanosolo ali peyameka Yesu wia tukatekoi oi pedoa pikete ekete eya tato. Yesu i agome padele poanele tokale enekoo wa kapene wakatiki ali-kiti tuku toa moato wa tuku tokoa kawa ");
INSERT INTO wiu_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","moa kakakoli dika dika wa kapene wakaneyake one wia tukatekoile pade piameneya. Nitaneyake alita takuta nekete ekete ");
INSERT INTO wiu_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Akolaline wikakane tobou losu yapu oneme ke̱aweane tadekatekoane wa ta tebolo-peta lia patakale eni-mene moane awitikakoane wa wiou wa okale yatekoo wa okoli ");
INSERT INTO wiu_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","ako odene tobou meane ago kamokakome okome neme okale yatekoinakamo eni akoa ikino, neme pademo topo takoa enike oo-pe wa okale ");
INSERT INTO wiu_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","agale wametekoa pa kakeneya. Nitikale ako tobou agome okome okome pa mea kama pokago Akolaliyo yakakamotono, nepa one mana Keraisu tadekalepa wete a-na wa okale okome ");
INSERT INTO wiu_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","nimini wini oko. Kiwi peya-pala ukuno yakoe. Naniko no Ali Yatenane Oyagopa telekole-kama toko ago Akolaline nimini yono lono kawane tibu wedo patu meane wakapeane nokolu enoi wa okale ");
INSERT INTO wiu_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","ako tobou ago pinali one kakene mamina ti̱awea iyatapekome okome oyakeno, i agome Akolali-pala taumada toa okolo tone kaleme yatekono, i agome toka poanele dika dika wa akoa omotoa pade ali-kiti totome wa tuku toateko toa mena. Akolali-pala taumada toa okale kime yatekoinano, ");
INSERT INTO wiu_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","opa i ago-pala edele tato-pe-kale ekete i ago wia tukamedekona wa topo takoa akeneya. ");
INSERT INTO wiu_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","68","Nititikoa one lene timinike tekelipu toa yotokoa yumili mutoa pia wia taneya. Wa pade ali-kitame kala witikete ekete Keraisu nepa teyo witikato-pe. Yakoono, to̱awea wete a-na wa tea agale oa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Nitoa kakoika Pita akolono pomale meaneya pupu atoa pade Pita mekata nokome okome neka Galili Yesu-pala opia yake toka wa onokale ");
INSERT INTO wiu_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","e yene peya kakakoa okome mena, neke wini oko agale yakamuku wa oomotokome ");
INSERT INTO wiu_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","kago keteponoke pome kakale pupu atoa padame enetekoa eniya liti kakoi yene-pala okome okome i agopa Nasarese Yesu-pala opia yakago-kale ");
INSERT INTO wiu_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pitayo okome agetai ti̱a neme eni okagopa enamuku ago wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Wa nani keneya eniya liti kakoi-kiti one kakata nekete ekete nepa Galili yename iki toa okono, Yesuno oya-lawe-pala opia yakago tadeko-koli okome ");
INSERT INTO wiu_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","kapenedo wakadekolupa Akolaliyo no kibu momotouno, Akolaliyo yakakamotoane nimini ukuno, kini wini iki agopa wene toamuku wa oa kakaka eina eina ali ogada ka̱ oa kaka. ");
INSERT INTO wiu_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Nitikalepa Yesuyo eya wa okana ali ogada ka̱ wameneka neme no einago wene toamuku wa tebolo-peta akoa wawade toko wa okana wene ponokale Pita akolono pome komo ka̱ta pitikoa kapaneya. ");
INSERT INTO wiu_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Podolikama ta patakale Akolalike lodo yotokoai tane tobou ali peyameka ete Kanosolo ali-kitameka Yesu wia tukatekoi oi pedoa piitikoa ");
INSERT INTO wiu_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","one yonoke kapa po kakamotekete ta yopikago Pailase mekata aua pote kakapaneya. ");
INSERT INTO wiu_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","4","Yesu wia tukatekoi oi pedoa piadekoli yatekome one wimotoa moa metekanakago Yudase yaame tukome eya topaneya. Akolalike lodo yotokoai tane tobou ali-kitika ete Kanosolo ali-kitika koukoa mekoita pokome okome padele toamene ago wimotoane pa puputuane moane metekouna. Poanele eni tekene tadekuno, kinike silepa kue lene padeka kapidi kakoane (30) motokouna wa kini einoe wa ete metekale ekete enipa tone pupu menano, neke pupu toko-la wa paya nou toa kakoli ");
INSERT INTO wiu_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","eina kue tobou losu yapu keneke pitikamotokome pome po nopaneya. ");
INSERT INTO wiu_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","7","Nitaneyake Akolalike lodo yotokoai tane tobou ali-kitame eina kue lene wekotoa motekete ekete ipa ali wia tukateko kueno, tone losu pupu toadete oyake moamato wa wene kibututukoa mekete eya taneya. Mete latia tane agome kamo tu̱a moai toake wakenetapa eina kueme topo toa motekete ekete mone pade ta kawa note mea tukoi yene i itonoke oloyo toai tato wa topo toa motaneya. ");
INSERT INTO wiu_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Nitaneya tokome opika eni itonopa lokeyo itono wa ibini ikiya. ");
INSERT INTO wiu_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Enile teketepa Akolaline agale to̱awea akane ago pade Yeremaiayo eya wa papete oa piane toa taatekaneya. I to̱aweane uku agopa Iserele yename silepa kue lene padeka kapidi kakoa (30) wetekoa moato wa oi pedoa pianeya. ");
INSERT INTO wiu_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Eni kuemepa mete latia tane agome kamo tu̱a moai taneta topo toa motaneya. Nipa Ali Muno Akolaliyo nopala oka toa taatekaneya wa Yeremaiayo oa pianeya. ");
INSERT INTO wiu_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesupa ta yopikago Pailase einagono leneke kakale Pailaseyo pitia yatekome okome nepa Yu yene peya lukoa meki tobou ago-pe-kale okome nopa einago wa wini okana wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Nitaneyake Akolalike lodo yotokoai tane tobou ali-kitameka ete Kanosolo ali-kitameka i agome dika dika wa akoa okolika Yesuyo pade agaleka wametekoa pa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","14","Nitikale enekome Pailaseyo okome opa nipa padele padelepa neme tanemo-kala akoa ikino, neke yakoa edemo oo-pe-kale Yesuyo pademoka topo takameneya agale wametekoa pa kakale ta yopikago wene kainya mati pia kakeneya. ");
INSERT INTO wiu_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Edelo ago patukane wa ibini akene toge oi ponokale-kama ta yopikago Pailaseyo eya tokala taneya. Yu yenamepa po yapu pitane ago pade po kotokoa one yapu wetekaka wa takoa okoi agopa Pailaseyo po kotokoa wetekakala taneya. ");
INSERT INTO wiu_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Einapete eya ago Barabasi po yapu pitaneya. One poanele tanemo ta piko peyake oa pupitikatapeneya. ");
INSERT INTO wiu_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ali atoa Pailase mekata koukoa note kakoli Pailaseyo one tanele tokome okome mani ago po kotokoane wetekakamotoa iki-pe. Barabasi-pe, Keraisu wa ibini iki agopa Yesu-pe wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Nipa e yename Yesu-pala aua nikilepa pa puputua wene pokete ni tokoi wa wene tokome akeneya. ");
INSERT INTO wiu_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Nika one koiso yakoa meateka walai witipitoa mekakoa one natoname agale wetekakome okome wini nami kawamene ago-pala padele tikileka toamoa wane uku. Ete pia pulete enekounakaleke nopa lata potokakome wene keda mati tokolo mekene ni uku wa pubu oa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Nitaneyake Akolalike lodo yotokoai tane tobou ali-kitameka ete Kanosolo ali-kitameka e oboa kakoi yene oa kamotokakete ekete Pailase-pala eya atoe. Barabasi po kotokoa wetekakoano, winago Yesu wia tukakamotono ta wa atoe wa oa kamotokaneya. ");
INSERT INTO wiu_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Nitikoli Pailaseyo e yene pitia yatekome okome mainago po kotokoane wetekakamotoa iki-pe-kale ekete Barabasi wa okoli okome ");
INSERT INTO wiu_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Keraisu wa ibini iki ago Yesupa edekamene wa iki-pe-kale ekete winago yomo lekaneyake wia dekakamotono ta-koli okome ");
INSERT INTO wiu_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","one poanele edele taneyake iki-pe-kale agale telo oa kamotokoa kakete ekete winago yomo lekaneyake wia dekakamotoa ta wa awitikoa tika tika taneya. ");
INSERT INTO wiu_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Nitikoli kini eni wene pilikoa kawikamotoa wili toake poi edikoa kamotokakaya wa wakome eya taneya. Kini lene yoto kakome ue nomoa okolo kagonoke pekoa pia yono tadakome okome i nami kawamene ago wia tukatiki pedoa pikile kote tokolo wakene tukuno, enoe. Kini wia tukapoe-kale ekete ");
INSERT INTO wiu_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","totome poanele tadekolopa nipa Akolaliyopa winago kamate yotokake nami wia kibu motikilepa totoka tone mati-kitika oyake kibu moma pomotoa oko wa okoli ");
INSERT INTO wiu_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pailaseyo Barabasi neke yapu pa wa po kotokoa wetekaneya. Nitoapa Yesu po wapime wiamene wa one poyo yene metekale witikoli yomo lekaneyake wia dekapoatino, poe wa nitatekoi poyo ali-kitike metaneya. ");
INSERT INTO wiu_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Poyo ali-kitame Yesu moomotekete Pailaseyo ta talo toa meka yapu aua pote kakapaneya. Nitoapa ete poyo ali-kiti peya one eni kakata koukoa mootokoa eya taneya. ");
INSERT INTO wiu_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","One kakene mamina kotokoa piapa kikome kiane mamina petene pade moa kakaneya. ");
INSERT INTO wiu_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Nititikoa kagani kakene po ludu moa makatikoa one wagoke lobutukakoa ni tauwe wata wakoa moa one nimini yonoke laukakoa neuwe tukupia mekete ekete Yu yene lukoa meki Ali Muno ne mea kamene wa paya tobou ago tetepo takoa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Nitoapa oneke tekelipu toa yotokoa one yonoke laukakoina tauwe wata odomoa one tobou wia taneya. ");
INSERT INTO wiu_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Nititikoa one tokoo kakakoina mamina petene kotokoapa one namolo kakene mamina wa moa kakamotekete yomo lekaneyake wia dekadete aua pekeneya. ");
INSERT INTO wiu_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Poyo yename Yesu-pala eni aua poadete pekete Sairini take ago Saimone kotukete ekete i ago wia dekateko yomopa neme aukoano, noo wa dekoa moa aukaneya. ");
INSERT INTO wiu_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Nitoa pote Gologosa wa ibini akene take witapeneya. (Gologosa tone agaleke eketepa ali wago wa ekete oko.) ");
INSERT INTO wiu_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Gologosa take eni aua pote witakete gerepi po ku̱ ue-pala kou tane yobotonota eletekoa lawetekoli mitua enetekoa noamademe wakeneya. ");
INSERT INTO wiu_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Nitikale yomo lekaneyake wia dekatekoa kakete one kakene mamina-mene tatiato wa tadu tootokoa tatite taneya. ");
INSERT INTO wiu_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Nititikoa witipitoa mekete nepikoa meaneya. ");
INSERT INTO wiu_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Nitaneyake one wago pitia lekane yomo munoke pipiake eya wa wia mekatekoa dekaloganeya. I ago Yesupa Yu yene lukoa meki tobou ago. Enipa Yu yename one koiso akoa akenemo eni wia mekaneya. ");
INSERT INTO wiu_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Yesu wia dekaketepa kode agota takuta eka okata yomo padetake wia dekaneya. Nipa panago Yesuno nimini yono lono wia dekoa padena ago one ewa yono lono wia dekoa taneya. ");
INSERT INTO wiu_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Nitaneyake eida ponokoi-kitame tedu metekete ekete ");
INSERT INTO wiu_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","beita, nepa tone tobou losu yapu odepeta ke̱atapeanepa wa ta tebolo lia patakale eni luku wa wiou wa okanakago pinali neke toa moa-na. Nepa Akolaline mana tadekalepa yomo lekaneya ludu ketipea ko̱a noo-na wa tema ponokala taneya. ");
INSERT INTO wiu_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Eina toa Akolalike lodo yotokoai tane tobou ali-kitameka Mosesene totono pine to̱a olaukane ali-kitameka ete Kanosolo ali-kitameka tea tedu metekete ekete ");
INSERT INTO wiu_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","i agome ete pade ali atoa toa motokoyake pinali one pade wa toa moamele toamoko. Beita, i agopa Iserele yene lukoa meki tobou ago patu. One wia dekane yomo ludu ko̱a nokale eneketepa i agopa Keraisu tadeko wa oneke wene tugoo. ");
INSERT INTO wiu_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","I agomepa Akolalike wene tugoane meku wa okano, Akolaliyo one toane mou wa wene piadekalepa nitoo. Onepa Akolaline mana kaku wa okagopa Akolaliyo toa motokale enato wa tea agale okala taneya. ");
INSERT INTO wiu_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Nimo okoi toa Yesu-pala odeneka wia dekakoina kode agotameka tea agale okala taneya. ");
INSERT INTO wiu_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Lou mataike ponome kakaka (lou pini 12 kilokoke) ta peya likatapeneya. Lou pene webokaka (lou pini 3 kilokokeka) ta pa likoa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Lou pene webokaka (lou pini 3 kilokoke) tadiya Yesuyo kayo telo ootapekome okome Eli Eli lama sabakani wa kayo akeneya. Enipa anu Akolali anu Akolali neme no dekolo tewitikoa wako-pe wa okome akeneya. ");
INSERT INTO wiu_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nimo okale yatekete eniya liti kakoi-kitame ekete enipa Ilaida kayo okome toko-koli ");
INSERT INTO wiu_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","panagome teyapea pome ue takamoateka obi wane mopaneya. Mootokoapa kou tane gerepi po ku̱ uele tadamoa tauwe wata munoke togototokoa aua nokome mitumoa na wa kabunuke pia lete lete taneya. ");
INSERT INTO wiu_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Nitikale ete-kitame ekete winile toameneya wa. Ilaidayo toa monoko patu. Tokale enato wa pa eida nepikoa kakoli ");
INSERT INTO wiu_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesuyo agale wa telo ootapekome one Yomini takoa pomotoa tukome tuaneya. ");
INSERT INTO wiu_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","One eni tukakapa eina eina kuna tobou losu yapu keneke eya mamina Akolali meko lono wa akene yapu luku olege toa ketekalogane mamina petenepa ete oto wa iyawea tukaketikaneya. Itono-pala momani toa kakene kue-kitika ka̱utakutukaneya. ");
INSERT INTO wiu_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Tuane ali atoa oloyo taneka peetapeneya. Peetapekalepa Akolalinele wedoa takama pote tuane yene padeka-kiti kamotokaneya. ");
INSERT INTO wiu_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Wa naniko Yesu kamoa pokale kiwi oloyo taneka tewitikoa Akolaline Yerusaleme take pekete ali atoa kainya mati mekoika pono yamepokala taneya. ");
INSERT INTO wiu_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Tobou poyo agomeka ete poyo ali-menameka pa eida nepikoa kakoli momani toa ele kule toa kakale enekete ekee wa nenei motekete ekete etene i agopa Akolaline mana tadeko wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Pade atoa-kitika kainya mati eka mati kakete enekoa kakeneya. Eni atoa-kitipa Galili ta kawa Yesu auapema nekene atoa. ");
INSERT INTO wiu_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Eni kakoi atoa pakeke eya atoa-mene lukoa kakoi. Padatoa one ibini Magadala Maria. Pade atoaka Maria. Eni Mariapa Yame Yosepetane nine. Ni pade atoaka Sebedi manatane nine. ");
INSERT INTO wiu_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ta likaka kamo ago pade Arimasia take ago Yosepe Pailase mekata pekeneya. Einagoka Yesuno oyago. ");
INSERT INTO wiu_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Einago Pailase mekata pome kowitipokome okome Yesuno tigini moane pipouno, mea ta wa yakapokale Pailaseyo one poyo yene yopikago-pala okome Yesuno tigini i agono motokapoano pa wa okale nitaneya. ");
INSERT INTO wiu_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Nitaneyake Yosepeyo mootokoapa weneya ake tane mamina petene moa tatilogoa Yesuno tigini pia ewetetapeneya. ");
INSERT INTO wiu_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Nititikoapa pala padaneta kokapiane kota keneke moa pipaneya. Pinali one tigini naniko piatekata pene kokoa wetipikanata eni piitikoa kue makai mati uoya koketekoa moa kabunu ketekalogoapa pekeneya. ");
INSERT INTO wiu_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Yesuno tigini eni moa pikalepa Magadala Maria-pala padena Mariata eina kota eko keneya pimotoa meaneya. ");
INSERT INTO wiu_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Toge kiatekoiya nodokane oi nokale podolikama eya ali-kiti Akolalike lodo yotokoai tane tobou ali-kitika Parisi ali-kitika Pailase mekata koukoa pote kakete ekete ");
INSERT INTO wiu_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","eina kapene yotokakanakago wete tuameneya mekome okome one tuaneya pianeke ta tebolo takoa pataka-petepa kamoane pou wa oka. ");
INSERT INTO wiu_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Nimo oka toa lede taatekamotoa tekete one oyali-kitame one tigini kode moa aua pote padeka potipitikoa ekete Yesu einakagopa kamoa pekedeko wa oadete tiki. Nitiketepa einagome ali atoa namolona oa yotokaka toa moa patukoa oa yotokaku pekete toadete tiki. Nitikaya tokolo one tigini pipaneta neke poyo yename ta pataka tebolo-petapa wedoa yopia kamotamene wa Pailase-pala akeneya. ");
INSERT INTO wiu_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Nimo okoli okome one oyali-kiti kota keneke poamomotoa toatiki toa topoatino poe. Poyo ali-kiti-pala aua poe wa okale pote nitipaneya. ");
INSERT INTO wiu_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Nipa kota kabunu ketekalogane kue eka oka kebonoke kalapage kiitikoa kini adeka mekaneya. Nititikoa poyo ali-kiti kime yopikoa kawe wa kakamotekete pekeneya. ");
INSERT INTO wiu_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Yu yene kini ko mea pupu toamatekoi-pete ponokale podolikama ta tu̱ei teigaka Magadala Maria-pala padena Mariatamepa Yesuno tigini pipane kota enepato wa enepaneya. ");
INSERT INTO wiu_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Poadete pokoika momani mati taneya. Nipa Ali Muno Akolaliyo moa wetekane edelo ago a tibu kawa nokome kota kabunu ketekalogane kue moa ete koketekoa kakoa einakeya waneke meaneya. ");
INSERT INTO wiu_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Edelo agono lene timinipa katiapale keneya lou yati yati tootapea, one kakene maminaka kilue kale keneya ake tootapea taneya. ");
INSERT INTO wiu_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Nitane ago enekete kota yopikoa kakene poyo ali-kiti piti mati tokale tekete kolu kolu wa tuatekalime temotele keneya toa pitaloganeya. ");
INSERT INTO wiu_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Wa naniko einatoata nokoli edelo agome okome okome piti moameo wane uku. Yomo lekaneyake wia dekakoina Yesu tuku tonikino wene tekene ni uku. ");
INSERT INTO wiu_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Inakago ita piamokono, onena papete okana toa taatekoapa kamokoa poka. One pianeta luku ino, enoe. ");
INSERT INTO wiu_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Enemoteketepa Yesuno oyali-kiti eya wa wete akapamene. Inakago Yesu wete kamoa pokano, kiwi Galili take naniko ate nomotoa one namolo takoa pokano, aida penekete enoino, eneponamene wa akapamene. Kita-pala oatekumopa ina ukuno, wete akapoe wa okale ");
INSERT INTO wiu_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","akolono wete wititapeketeta piti tokaleka kolotini nakale Yesuno oyali-kiti oadete teyapea pekeneya. Nipa wedia kawa pekeneya. ");
INSERT INTO wiu_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Nitoata pokoli Yesu kotua nokome okome wete kamene-ye wa okale one kakata note pitalogoa one kawata tebea motekete kei pikoli okome ");
INSERT INTO wiu_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","piti moameo. Anu ame-mikiti eya wa akapoe. Ate Galili take note no enenamene wa akapoe wa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Einatoata poadeteta pokoika eina kota yopikoa kakene poyo ali padeka-kiti Yerusaleme ta Akolalike lodo yotokoai tane tobou ali-kiti mekoita pekete kini enekoinakamo peya dika dika wa to̱awea akeneya. ");
INSERT INTO wiu_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Nitikoli eni yene ete Kanosolo ali peya-pala koukoa mekete edato patu wa kini toatekoi oi pedoa piitikoapa poyo ali-kiti kue tubeya moa metekete ekete ");
INSERT INTO wiu_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ali atoa kotukete-kama eya wa okala tamene. Likonu kiwi atu pitikakoa Yesuno oya-lawe note tigini kode moa pekete tokoi wa akamene wa akeneya. Eya waka akeneya. ");
INSERT INTO wiu_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Toto-pala i to̱awea ikimopa ta talo toko ago Pailaseyodo yatekome kiwi wia tukademe tokalepa one wene kekoono, piti moameo wa oa tukaneya. ");
INSERT INTO wiu_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Nitikoli kue moomotekete pote kipala eina okoinakale taneya. Opika einaka einamopa Yu yene mekika oa pupitikaneya. ");
INSERT INTO wiu_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Yesuno tuku melepu kakoa (11) oya ali-kiti one Galili take i tonoke ate kotua namene wa papete oa pikana toa kotua ponete ");
INSERT INTO wiu_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Yesu enekete neuwe tukupia kei pia kakoi. Nitiketeke padeka-kiti poome taneya kakoi. ");
INSERT INTO wiu_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Nitikoli one oya-lawe kakoiya liti nome kakome okome tibu-pala itonota neme-kama yopia kamene wa Akolaliyo no moa kakakano, eya tamene wane uku. ");
INSERT INTO wiu_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","E ku yatene peyame anukumo yakoa momotono, Agetaine ibinika one mana anu ibinika one Epetane Yominine ibinika wedekoa ali atoa ue motokama yamene. ");
INSERT INTO wiu_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Nipa kipala tamene wane olaukakouna toa litia tamene wa olaukama yamene. Itono takoa poateka ta pataka-peteka kiwi yopikoane-kala kama pouno, nitamene. E̱e nimini wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ipa Yesu Keraisuke epetekoa akene agale titiane akakuna. ");
INSERT INTO wiu_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Namolo namolo papete Akolaline agale akane ago pade Aisaiayo eya wa wia mekaneya. Nipa Akolaliyo mana-pala papete oa piane toa wia mekakome okome Ne naniko pomotoane anu agale oa aua yawatekago namolo takoane moane wetekou. Nitikolu pokome ne poateka ka nodokakama poo. ");
INSERT INTO wiu_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Nipa ali piamene ta ludu panagome eya wa mo wima yawoo. Ali Muno noateko ka nodokakapia, one yawateko ka-kitika ki̱yotokakapia toatino toe wa einago taatekoa nokome mo wima yawoo wa Aisaiayo papete wia mekapianeya. ");
INSERT INTO wiu_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Eina wia mekapiane toapa Yone ali piamene ta ludu taatekoa nokome eya wa mo wima nekeneya. Kini tokoi poaneleke Akolaliyo kiwi wiou wa po letu mekakana keetapemotono eni poanele tewitikoa wawa ue moamene wa ali atoa ue motokaneya. ");
INSERT INTO wiu_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Nipa Yudea ta piko peyake Yerusaleme takeka ali atoa peya one mekata note kini tokoi poanele i i wa to̱awea ootapekoli nipa ue moe wa Yodane uele kakome ue motokakala taneya. ");
INSERT INTO wiu_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yone einago taatekoa nokomepa kamelo kai pineme latiane mamina kawa ni pitimekawe kai kepeneme latiane matiu kawa taneya. One nakene neepa apio-pala koyapo ego ueta nakeneya. ");
INSERT INTO wiu_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Nitane agome mo wia kakome okome no litimotokakome ele kule telekole toa no moa patukako ago noademe toko. Nokolopa auapeane one kawa yene kekatukuyake pa ago tekene meamukakene kekamele toamoko. ");
INSERT INTO wiu_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Opii kiwi pa ue motokakene tuku. Einago nokomepa Epetane Yomini motokademe toko wa oma yakeneya. ");
INSERT INTO wiu_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Eina-petepa Yesu Galili ta keneke piko Nasarese ta kawa Yone kakata nokale Yodane uele ue motokaneya. ");
INSERT INTO wiu_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Nitikale Yesu uele kawa aka matanuke pogatekoa pokome enekale eina eina tibu patetepikale Epetane Yomini weuwe keneya tibu mea ketipea nome pinali oneke pitanokale enaneya. ");
INSERT INTO wiu_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Nitikale a tibuke agale ludu nokome okome anu manago nepa anu kolotini ago. Neke tokoleke no kolotine meku wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Nitikale eina eina Epetane Yominiyo Yesu ali piamene take poano pa wa aua pekeneya. ");
INSERT INTO wiu_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Aua pekeneyake lene timini togoikoa padeka noi kakoa (40) ta lia pataka toa Setanu nome likoa enoai taneya. Eidapa yo tane kai eya pakeke pome mekake edelo ali-kiti note auape auape toa kananeya. ");
INSERT INTO wiu_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yone po yapu moa pitikatekaneyake Yesu Galili take pokome eni ta ludu Akolalinemo ali atoane wene epetekakome tanemo i i wa mo wima yakeneya. ");
INSERT INTO wiu_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Nitikome okome eina oa piane agale taatekoa toateko-petepa opi. Akolaliyo kiwi talo tokole keleyo witateko tigotoma nokono, kini namolo poane wene wia wawa kini wene epetekoane uku agaleke wene matoa meamene wa oma yakeneya. ");
INSERT INTO wiu_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Nitoa Galili ue matanu ludu kokotoma ponokome enekale odene wamena Saimone Aderutame kini tanele tekete mou tagi toa kakoli enaneya. ");
INSERT INTO wiu_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Enekome okome mou tagi toa mou toa ali atoa motokakete toatikile olaukouno, no litima noe wa okale ");
INSERT INTO wiu_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","eina eina kini tagi ka tewitikalogoa Yesu litima pekeneya. ");
INSERT INTO wiu_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yesu eniya liti kutu pokome enekale odene wamena Yame Yoneta Sebedine manata ue dipike mekete tagi ka pilianeka lipua mekoli enaneya. ");
INSERT INTO wiu_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Enekome okome yukuyagota wete noe wa kayo oma ponokale eina eina pupu yeneka etene-pala ue dipike memotoa Yesu litima pekeneya. ");
INSERT INTO wiu_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesuyo Kapaneame take pato wa einali-mene-pala opia pome mepaneya. Pome mekomepa ko mea pupu toamene-pete losu yapu pome olaukapaneya. ");
INSERT INTO wiu_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","One eni olaukakale yatekete peyame ekete Mosesene totono pine to̱a olaukaki yename ikina toa i agomepa wamokono, one weneme-kama pademo pademo tititikoa okono, opa agale pinagomepa i okono, yakatoe wa ka̱ oa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Einata einapete poane ipono awitaneya meane ago losu yapu mekome telo okome okome ");
INSERT INTO wiu_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Nasarese Yesu nepa toto mekota edade noka-pe. Toto wiade noka-pe. Nepa Akolaliyo takoa moa kakapiane ago toko-la wa ta̱yo ootapekale kikoa okome okome ");
INSERT INTO wiu_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","agale wia te̱iano, winago tewitikoa wete takoa pa wa okale ");
INSERT INTO wiu_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","einago itonoke aua pitikoa petekakoa kawa ta̱yo telo ootapekome takoa pekeneya. ");
INSERT INTO wiu_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Nitikale enekete e yene ete oto wa yakaate tekete ekete one eni oka agalepa edane agale patuno, one weneme-kama pademo pademo tititikoa okoya tokome ipono-kitameka oneme okole-kama yakoa tiki wa ka̱ oa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Nitaneyake one tanemo Galili ta piko peyake wete oa pupitikatapeneya. ");
INSERT INTO wiu_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Enile toomotokome Yesu losu yapu tewitikoa pome Saimone Aderutane yapu pato wa Yame Yoneta-pala opia pekeneya. ");
INSERT INTO wiu_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Eni yapu pene nome mekaka Saimone natonane nine one kaue poto yene taneya piko wa okoli ");
INSERT INTO wiu_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","einakatue pikata pome yono moa kamotokaneya. Nitikale eina eina poto yene te̱itakale latoa kakome kini nee takoa lawetaneya. ");
INSERT INTO wiu_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Einata einapete lou pene pipaneyake eya kuya yene taneya mea ipono awitaneya mea tane yene peya aua pato wa kini oya-mikitame Yesu mekata aua nekeneya. ");
INSERT INTO wiu_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Eni take pitane ali atoa peya note kago liti kolike apua takoa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Nitikoli enekome eya kuya yene taneya nekene-kiti latekoa ipono-kitika takoa poe wa wetekoa taneya. Nipa ipono-kitame i agopa Yesu toko-la wa wene tokoli tokome agale witoa wameo wa takoa wetekatapeneya. ");
INSERT INTO wiu_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Podolikama ta wete patameneyake Yesu kamomotokome ali piamene take kidene pome kowitipaneya. ");
INSERT INTO wiu_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Nitadekale Saimoneyo tuku topato wa one oyali-kiti-pala opia pome tuku toawineya pekeneya. ");
INSERT INTO wiu_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Nitoa tuku toawineya pote enamutukete ekete nepa kuka ku ali atoa peyame tuku toa kaki-koli okome ");
INSERT INTO wiu_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","ete yeka ta ludu pitiki ali atoaka anu akama yakuna agale oane mema pamedeku. Taatekoane eina agale akadene ni nokouno, tone opia pekete patono noe wa pekeneya. ");
INSERT INTO wiu_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Patono noe wa pokomepa Galili ta ludu losu yapu kaka toa Akolaline agale mo wia akama pome ipono-kitika takoa wetekoa taneya. ");
INSERT INTO wiu_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Kedime nakene ago pade Yesu kakata nome wadini tukupia kowitikome okome nemedo no epetekouno wene pikepa nipa oyake epetekoano ta wa kowitikale ");
INSERT INTO wiu_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","ela motokome yoname mitikatekakome okome nitouno ta. Neke eni yene takoa pomotoane uku wa okaka ");
INSERT INTO wiu_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","eina eina takoa pokale latoa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yesuyo nititikoa kakome pubu okome okome etene pade ali atoa enekeka anume ne latekakumo kotukoa ikileka toamoa. ");
INSERT INTO wiu_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Nitameneya eyaka topamene. Ne i agopa kedi pitaneya mekanake opi i latoa kakona wa yete pade ali atoame wene tomotoapa Moseseyo tamene wa papete oa pianele topamene. Nipa Akolalike lodo yotokoai toko ago mekota peke oneke padeya lodo yotokatekoya aua poke mepoano pa wa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Yesuyo nimo okale yakoake tagatapea ta piko peyake one eni latekakanakamo oa pupitikatapeneya. Nitikale tokome ali atoa pitikoika Yesu keleyo poukome toake ali atoa apua takakaya tokale padeka lono katekoa pome ali piamene ta ludu pima yakeneya. Nitoa pokake ali atoa koukoa one kakata note-kala kakeneya. ");
INSERT INTO wiu_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Yesu eina-meneke yawa mea wa wakapea Kapaneame take nome menaneya. Nitikale Yesu wa wakapea nome one yapu meko wa okoimo kugu ");
INSERT INTO wiu_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","yakatekoa ali atoa koukanokolipa keika yapu luku kawatekoi pakeka piameneya. Akolono kago ludu-kitika nateya pakeka piameneya edeya takatapeneya. Nitaneyake yapu keneke kakome Akolalinemo i i wa oa kakaka ");
INSERT INTO wiu_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ali tuyonome eya ago muku muku toameneya pa pia kakene ago leyo leyo toa aua nekeneya. ");
INSERT INTO wiu_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Nipa yapu edea takatapeneya tokome Yesu kakata pinele aua namele toamokale aka yalini ludu aua penaneya. Nitoa ponete yalini ke̱a po kakoa leyo-pala keti Yesu kaka pitia tewitikaketikaneya. ");
INSERT INTO wiu_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesu i agome kini oyago oyake latekamele toko wa wene tekete tadekoile enekome Yesuyo yene tane ago-pala okome anu mana neke toma noka poaneleke Akolaliyo po letu mekakana keetapekene neke poanele kogakuna wa okale ");
INSERT INTO wiu_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Mosesene totono pine to̱a olaukane ali-kiti eniya liti mekete kini tepene eya wa wene pia meaneya. ");
INSERT INTO wiu_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Imopa i okono, edekolo oko-pe. Ali atoame toma nokoi poaneleke mekane po letu kea wakilepa Akolaliyo odene tokono, i agome Akolali tekome oko wa wene poaneya meaneya. ");
INSERT INTO wiu_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Kini eni wene pikoile tetoa enekome Yesuyo okome wini tepene wene kibutukoa mekipa dekolo tiki-pe. ");
INSERT INTO wiu_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","I ago-pala ukule tamele tadeko wa kime wene tomotoanepa yene tane ago-pala edemo wane omotoa iki-pe. I ago neke toma noka poaneleke Akolaliyo po letu mekakana keetapeku wane omotoa iki-pe. Wete kamoa ne aua nokoina leyo-pala aua pa wane omotoa iki-pe. ");
INSERT INTO wiu_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","11","No Ali Yatenane Oyago itonoke mekenepa ali atoame tokoi poaneleke Akolaliyo po letu mekakana keetapeamele tadeko wa kime wene tomotoanepa yene tane ago-pala eya wane uku. Ne aua nokoina leyo-pala moa aua neke yapu poano, kamokoa pa wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Nimo oka oka e yename nepikoa memotoa einago kamokakome one aukoina leyo-pala moa aua pekeneya. Nitoa pokale enekete ali atoa kakoi peyame ka̱ oa kakete ekete namoloka toamokoinakalepa i tokono enatoe wa Akolali kei pia kakeneya. ");
INSERT INTO wiu_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Nitaneyake Yesu Galili ue mine matanu wa pome kapaneya. One eni kakata ali atoa peya note oboa kakoli Akolaline agale olaukoa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Nititikoa pokome enekale eya ago Lipai Alepiasine mana takesi kue motokoai tane yapu keneke mekale enekome okome no pukuka tone patono noo wa oma ponokale kamomotokome Yesu pokaka litima pekeneya. ");
INSERT INTO wiu_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","One yapu nee natono noo, pata wa Matiuyo koua pokale Yesu pome mekome nee noa meaneya. Nitikale takesi kue motokama yakene ali-kitika Yu yenane totono litia toamene ali-kitika Yesu-palaka one oyali-kiti-palaka eida opia mekete nee noa meaneya. Dikane ali kainya mati one pokaka litima pekeneya. ");
INSERT INTO wiu_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Yesu dikane yene-pala opia mekome nee nakale enekete Parisi ali-kitameka Mosesene totono pine to̱a olaukane ali-kitameka Yesuno oya-mikiti pitia yatekete ekete Yesupa dikane yene-pala opia mekome nee noa mekono, edekolo tokoto-pe wa yakananeya. ");
INSERT INTO wiu_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Nimo akedekoli yatekome Yesuyo okome dokosa agomepa yene toameneya meku wa iki-kiti edoa nome latekamotoa-pe. Yene taneya meku wa iki-kitipa nipa nome latekanoo. Nipa poanele toamuku wa iki yene kini namolo poane wene wia wawe wane oadene nokouya mena. Poanele tuku wa iki-kiti odene auapeadene nekene uku wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Wa padepete ali atoa ue motokama yakene ago Yonene agale litia tane yenameka Parisi ali-kitameka Akolali wedoa kowitadetepa nee eya tekei wawa noamoa pa meaneya. Nitaneyake pade ali-kiti Yesu kakata note yatekete ekete neke agale yakoa nepala opia yaki yenamepa enile toamiki. Edekolo toamikiti-pe wa yakaneya. ");
INSERT INTO wiu_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Nitikoli okome panagono atoa motokakita atoa motokagono oya-mikiti onepala wedikete wediapa nee eya edoa wawa noameneya pa memotoa-pe. ");
INSERT INTO wiu_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Wa naniko ete yename atoa motokago padeka aua poatiki wini tigotoma nokona. Eni toateko oi noka-petepa nee noameneya wawa pa meoi wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Nimo ootokoa kakome pedoa agale pade okome okome panago one mamina namoloya pilikalepa weneya pue moa namoloya eni pilikata lapukoa lipuko patu. Nitamoo-li. Enile tootokoado uele abe kogalepa weneya pueme ete ete toa edema pokome pilikutu too wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Wa agale pade pedoa okome okome gerepi po ku̱ ue weneya mekalepa meme kai tabeme latiane mete namoloyake oyake peia moamoo. Eniyakedo peikalepa gerepi po ku̱ ue weneya tokome lako yati kawa mono mono okome ka̱ua paka yoa pootapeoo. Nipa eni kai tabeme latiane meteka ka̱ua ti̱ ta̱e witapeoo. Pene po ku̱ kotiketepa meteka peneyake ti̱a lobutua piamedeko wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Yu yene kini ko mea pupu toamene-pete pade Yesu panagono witi ipe ludu pokaka one oyali-kiti one-pala opia pekete witi ku̱ deya tukaka pekete kotima pekeneya. ");
INSERT INTO wiu_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Nitikoli enekete Parisi yename Yesu-pala ekete tone ko mea pupu toamateko-pete kekoa wawa toamatekole eni tikino, ku̱ kotia eni pupupa dekolo tikiti-pe-koli okome ");
INSERT INTO wiu_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Depidi one-pala to̱a yakene ali-kitika kobu tokale tanemo oi moamokoiya-pe. Eya taneya. Tobou ago Soloyo Depidi litia aua pokale to̱a yakomepa kobume tuaneya tokome Akolaline wikakane yapuke lobutukoa kapaneya. Nitoapa Akolaline pikane palawe wane moa nootokoa one oyali-kiti i nee noatino noe wa moke toa tatika tatika taneya. Akolalike lodo yotokoai tane ali-kitame odene dikane palawe wane namele taneyake nitaneya. Enipa ako odene mekome Akolalike lodo yotokoai tane tobou ago Abiasa meane-pete kini kekaneleke Depidiyo taneya. ");
INSERT INTO wiu_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yesuyo nimo ootokoa kakome okome Akolaliyo ali atoa auapekomepa ko mea pupu toamatiki-pete pa ko meamene wa oa pianeya. Ko mea pupu toamene-pete padeya padeya kekaneya latikamotoa akeneya mena. ");
INSERT INTO wiu_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","No Ali Yatenane Oyagomepa ali atoa ko mea pupu toamiki-pete mekete toatikileka i i wane oyameane talo toane meku wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Wa pade-pete Yesu losu yapu wa pokome enekale yono lokane ago pade eida mekale enaneya. ");
INSERT INTO wiu_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Nitaneyake pade-kitamepa Yesuyo i ago epetekako patu wa lene wikaneya. Nipa ko mea pupu toamene-pete kini kekanele tomotadiya wa kakete taneya. ");
INSERT INTO wiu_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Nitikoli Yesuyo yono lokane ago-pala okome okome oto noke kanoo wa ootokoa kakome ");
INSERT INTO wiu_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","e yene yatekome okome tone ko mea pupu toamoko-petepa edele tokala tato-pe. Ali atoa-palapa padele padele epetanele tato-pe. Poanele tato-pe. Tuamele toko agopa toa moato-pe. Wia tukato-pe wa okale agale waametekoa pa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Tepe kolotini lupi tootapeneya kakoile enekome kotimi luaneya kawa tepe-pala we tokale kaka. Nitoapa o yene leneme enoa unukamu tootokoa kakome yono lokane ago-pala okome neke yono kutu lido akoano ta wa okale lido akoa enekale one yono epetekakadeka. ");
INSERT INTO wiu_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Nitikale enekete Parisi ali-kiti Erodeke timini kawa yakene yene-pala akolono koukapeketepa Yesu wiato wa one wia tukatekoi oi pedoa pianeya. ");
INSERT INTO wiu_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Nitaneyake one oyali-kiti-pala Galili ue mine pato wa tewitikoa pekeneya. Eni pokaka Galili yene peya mati lewi lewita pia obomoa nekeneya. ");
INSERT INTO wiu_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Nipa Yudea ta piko peyakeka Yerusaleme takeka Idumea ta piko peyakeka Yodane ue eka-lono piko takeka Taia Saidone tata liti enika eni pitane ali atoa Yesu kakata note-kala kakeneya. One toma yakenemo kugu yatekoiya tekete nitaneya. ");
INSERT INTO wiu_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Nitaneyake ali atoata i kakoyame one dekoino, ue dipike pone mepouno, ue dipi nodokakoa oto aua noatino poe wa one oyali-kiti-pala akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Nipa yene tane ali atoa peya mati latekakale enekete ete yename kini tane yene latekamotoa Yesu mitikada wa lekoa apua takatapeneyake ni akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ipono awitaneya meane yeneka nokoli kini eina awitane iponame Yesuno lene timini enekete one kawane aua pitakete ekete nepa Akolaline mana wa okala taneya. ");
INSERT INTO wiu_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Nimo okoli ipono-kiti kikoa okome okome no i agopa dikane ago wa widikoa to̱awea wameo wa kikoa akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Nititikoa tono pade lewia pome kakome one takoa moateka ali-kiti noe wa kayo okale nekeneya. ");
INSERT INTO wiu_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","One-pala opia yawatekoi ali-kiti tuku kakoa (12) one Aposelo ali wa moa kakakilepa Akolalinemo mo wia oawineya pote ali atoake awitane ipono takoa wetekoa tomotoa taneya. Nipa one tele patu kautakoa kakete nitimotoane wetekou wa moa kakaneya. ");
INSERT INTO wiu_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Eya ali-kiti takoa motaneya. Pade Saimone one pade ibini Pita wa oa metaneya. ");
INSERT INTO wiu_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Ni Yame Yoneta Sebedine manata. Yesuyo einagotane ibini pade Boanesisi wa ibini oa metaneya. Boanesisi wapa tono witikagota wa okome akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ni Aderu ni Pilipi ni Batolomiu ni Matiu ni Tomasi ni Alepiasine mana Yame ni Tadiasi ni Kenane take Saimone ");
INSERT INTO wiu_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ni Yudase Isekariose. Yudase einagopa Yesu poi te̱iane yename wimotoa moa meateka ago. ");
INSERT INTO wiu_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","One oya-lawe eni takoa moomotokome Yesu wakapea yapu nome mekale ali atoa wa obomoa note edea takatapeneya. Edeya takatapekoli Yesuka one oya ali-kitika nee noatekoi pake toameneya. ");
INSERT INTO wiu_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Eni tanemo kugu yatekete onekameyo ekete ekee, leau akeneya yakome tokono, enemopato wa Yesu moa pikoa kawadete nekeneya. ");
INSERT INTO wiu_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Mosesene totono pine to̱a olaukane ali-kiti Yerusaleme ta kawa keti note kakete ekete Yesu i agokepa Belesebule awinome mekome toko. Ako odene meko tobou ipono Belesebulene tele patu kautakoa kakome tokome ipono-kiti takoa wetekakala toko wa tea agale akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Nitaneyake Yesuyo ali atoa one kakuta noe wa mootokoapa pedoa agale-mene okome okome Setanu pinali one tiko wa edoa takoa wetekamotoa-pe. ");
INSERT INTO wiu_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Pitikali puutakutukoa meketepa nipa wili walai wa tadatapeoi. ");
INSERT INTO wiu_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Wa odene yapu pitiki-kiti ete oto wa poita toa winali yotoketepa kini eni yapu pa tumu tokaneya pimotoa wawa poi. ");
INSERT INTO wiu_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Edikoapa Setanu one yagono-mikiti-pala poi toa mekomepa nipa one tele tetoa ti̱i ta̱e oa witikatapeneya tokome one yeneka ete toa atuma poi wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Nimo ootokoa kakome pedoa agale pade okome okome telekagome-kiti one yapu pikoya-kiti pa yopia mekalepa kode agome yapu bulukoa nome onekeya oyake moa pamele toamoko. Nitamele toamokoyake kode ago kotikatapeado nokomepa telekago poome lutua piilogoa onekeya peya oyake kode moa poo. ");
INSERT INTO wiu_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ali atoame padele padele poanele toa Akolali tea kawaka wa nanikodo ae, inapa poanele tekene tadeku wa wakolipa nipa Akolaliyo kini eni poanele tokoike po letu mekakanapa keetapea wawa kibu moamoo. ");
INSERT INTO wiu_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Wa panagome Epetane Yominilepa Setanule tetepo takakalepa Akolaliyo one eni poanele tokake po letu mekakanapa keamokome etene kibu moo. Dikane agome toka poanelepa pa pia kakale Akolaliyo kogakileka toamoo wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Enipa Parisi ali-kitame Yesu i agoke poane ipono awinome mekome toko wa okoli tokome ni akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Nimo oa kakaka Yesuno nine wamene-mikitika koli note kakete ekete Yesu oto noo wa akoe wa panago moa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Nitikoli Yesu kakaya liti oboa meane ali atoame ekete neka̱ua neke wamene-mikitika koli a note kakete ne noo wa iki-koli okome ");
INSERT INTO wiu_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","aga̱uapa te-pe, anu wamene-mikitipa te-lawe-pe wa ootokoa kakome ");
INSERT INTO wiu_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","one unukoa mekoina ali atoa enoa unukakome okome agau̱a-loe anu wamene-mikitipa ika i mekina. ");
INSERT INTO wiu_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Akolaliyo ta wa okole-kama litia tiki-kitipa agau̱a anu wamene laine-mikiti enina wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Wa padepete Yesu Galili ue mine matanu pome olaukoa meaneya. Nitaneyake ali atoa lewi lewita pia obomoa note-kala kakoli tokome ue dipike pogatekoa pome mepaneya. Nitoapa e yene ue matanuke ete keneya kamotoa onepa ue dipike mekome ");
INSERT INTO wiu_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","pademo pademo oa metekilepa pedoa agale oa meaneya. ");
INSERT INTO wiu_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Nitoa olaukoa mekome okome kipala i ukumo yakoe. Ipe pinagome-kiti ipe ludu nee lene pitikama pekeneya. ");
INSERT INTO wiu_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Nitima pokale nee lene padekapa ka ludu paka tadoa pitaneya. Nitaneta ini-kiti pukaneya note pitoai toa napekala taneya. ");
INSERT INTO wiu_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ni nee lene padekapa kue pake pake tadoa pitaneya. Tokoo itono nateya deya pianeya tokome wete tumikala taneya. ");
INSERT INTO wiu_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Wa naniko lou tigini kakale wete eni tototokoa tuaneya. Teke itono kekulu wetekameneya tokome loume ni yoa tukatapeneya. ");
INSERT INTO wiu_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ni nee lene padekapa tonipo pake tadoa pitaneya. Nitaneta tonipo eya nee lene-pala odeneka dekoa witakome tukatapeneya. ");
INSERT INTO wiu_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ni nee lene padekapa itono epetaneyake pitakome leau akatapea witakome ku̱ tukala taneya. Ku̱ tukilepa padekapa ku̱ kapidi kakoa kakoa (30) tua ni padekapa ku̱ ege odepeta kadukoa wa tuku melepu kakoa (60) tua ni padekapa ku̱ ege takupeta kadukoa (100) tua tokala taneya. ");
INSERT INTO wiu_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Kipala i ukumo yakou wa kale piiyakoa kaki-kiti kime yakoati wane uku wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Naniko Yesu one kidene mekata one mekoya liti oboa mekete yatekoina yene padeka-kitame one tuku kakoa (12) oyali-kiti-pala note eni pedoa okana agale pine pitia yakananeya. ");
INSERT INTO wiu_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Nitikoli yatekome okome Akolaliyo one ali atoa talo tokolepa papete kaukoa mema nekeneyake opi kiwi keleyo ooyameteku. Nitikuyake ete ali atoa-palapa nipa pedoane agale-kama oane meteku. ");
INSERT INTO wiu_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Nipa Aisaiayo papete wia mekapiane toane taatekoane tuku. Eya wa wia mekapianeya. I to̱aweane uku yenamepa kini leneme enekoile enoa moamoa kini kaleme yatekoimo yakoa moamoa toi. Akolalikedo tepe kolotini pekoa pioi tokapa kini poanele tokoike po letu mekakanapa kea kibu moamoo tokake pa etepea pomotoa wawoo wa Aisaiayo wia mekapianeya wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yesuyo nimo ootokoa kakome okome ina pedoane okouna pine wene toamikino, ete idikoane pedoane oma pokou-kitipa edoa yakoa moadete-pe. ");
INSERT INTO wiu_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ne lene pitikama yako ago adeka pikounapa Akolaline agale oa aua yako agoke okouna. ");
INSERT INTO wiu_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Nee lene padekapa ka ludu tadoa pitane adeka pikounapa eya tiki yeneke okouna. Pade-kitame Akolalinemo yakoa lukakili eina eina Setanu nome katekamoa poko. ");
INSERT INTO wiu_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Nee lene padekapa kue pake pake tadoa pitane adeka pikounapa eya tiki-kitike okouna. Pade-kitame einagale yakoapa eina eina ke wa lukoa wedia meki. ");
INSERT INTO wiu_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Nitiketeke einagale kini tepene teke wetekameneya tokome Akolalinele pa tekei takaki. Wa naniko ele kuleme ke enekakale mea ni ete-kitame kipala poi teigoli mea tekete Akolalinele takoake wete tewitikoa wawei. ");
INSERT INTO wiu_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Padeka nee lene tonipo pake tadoa pitane adeka pikounapa eya tiki-kitike okouna. ");
INSERT INTO wiu_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Pade-kitame einagale yakoa moake kini kepene mama moa kini kamoya-kitike wene pitikakoa mea eya kuya moadiya wa tepi tokale mea tikili enika enileme Akolaline agale moa kautako. Nipa nee lene ku̱ tuamou toa keneya pa meki. ");
INSERT INTO wiu_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Padeka nee lene itono epetaneyake pitane adeka pikounapa eya tiki-kitike okouna. Pade-kitame einagale yakoapa inapa Akolaline peku wa noa tiki. Nitikipa ipe nee kakoya ku̱ tuma pou toa padekapa ku̱ padeka kapidi kakoa (30) tua ni padekapa ku̱ ege odepeta kadukoa (50) tua ni padekapa ku̱ ege takupeta kadukoa (100) tua toko wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Panagome-kiti labo udukoapa okolo moane kaulogou wa yapu aua noko patu. Walai kene kekulu moane piou wa aua noko patu. E̱'e, edikakoya mena. Labo piatekota-kama moa pikala toko. ");
INSERT INTO wiu_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Padele padele kaukoa toma yakolepa naniko keleyo witatekole toko. Padeya padeya paigakoa pikoya-kiti naniko keleyo pikale peyame enetapeoi. ");
INSERT INTO wiu_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kipala i ukumo yakou wa kale piiyakoa kaki-kiti kime yakoati wane uku wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Nimo ootokoa kakome okome kipala i oane metekulu yatekimopa wedoa yakoa moamene. Kime ete metekoi toa eni luku kotuke otoka mokala toi. Nipa ako pade-meneka oto mokala toi. ");
INSERT INTO wiu_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Akolali one i peku wedoa nako agopa nipa Akolaliyo one peku-kama lawetema poo. Akolaline peku alekoa noa toko agopa nipa one eni lawetane peku nateya deyaka takoa pootapeoo wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesuyo nimo ootokoa kakome pedoa agale pade okome okome ");
INSERT INTO wiu_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Akolaliyo one ali atoa talo tokolepa i wane adeka piane uku. Panago ipe ludu one nee lene pitikama yakanata eni nee lene tumia witoa kako. Nipa ta lia patako toa-kama pinago pitikome kamotokome tomotoa toko. Tumia witakole pinago agopa tokolo mekoyake toko. ");
INSERT INTO wiu_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Pinagome nee lene matalogoa paya nou toa mekoyake kadene tumia atepea witama nome tidiyo wia ku̱ tua toko. Enilepa itonome-kama toko. ");
INSERT INTO wiu_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ku̱ tua nodokoa kibutua kakale eina eina pinagome wakoa mootapeoo. Nipa one wakoane momotoa toko wa epei moa nome wakoa mootapeoo wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesuyo nimo ootokoa kakome okome Akolaliyo one ali atoa talo tokolepa edeya wane adeka piku patu. Edemo wane pedoane agale uku patu. ");
INSERT INTO wiu_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Akolaliyo one ali atoa talo tikilepa kalipe lene deya itonoke witako toa toko. Eni lenepa etene nateya wane deya tokome eteya yomo leneme moa patukako. ");
INSERT INTO wiu_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Eni lene deya panagome moa itonoke pitikakolo tumikomepa ate toa eteya yomo moa patukatapeko. Nipa yaita mati eni kakome yenene yeteka yukukata tubeya wetekako. Yenene etene tubeya wetekakolo tokome ini pukaneya note eni yomo todoke yene wiamele toko wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesuyo Akolaline agale i i wa e yene oa metekomepa enika eni pedoa agale okala taneya. Nipa kini yakoa moatekoi kotuke oa mekala taneya. ");
INSERT INTO wiu_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Akolalinemo eni oa metekilepa agale pedoa-kama oa mekala taneya. Nitaneyake one oyali-kiti-palapa kini-mene mekete einaka eina pedoa agale peya pine ina ina wa to̱awea okala taneya. ");
INSERT INTO wiu_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Einapete lou wete pipaneka Yesuyo one oyali-kiti-pala okome okome eka ue mine matanuke witatono patono noe wa eina ue dipike lewia pome mekale ");
INSERT INTO wiu_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","ali atoa matanuke eida koukoa memotoa wawa one oyali-kitika eina ue dipike peapetekoa pote mea Yesu-pala opia mea pekeneya. Mea pokoika ali atoa ue dipi pade-kitike mea opia pekeneya. ");
INSERT INTO wiu_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Mea poadete pokoika pupulege tadalita kotikatapea u̱u wa noka matiyame ue pewikanokome ue dipike patua pitoa atukademe taneya. ");
INSERT INTO wiu_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Atukademe tokaka Yesu ue dipi kuka lono nali yomo mokoa atu pia meaneya. Nitikale one oyali-kitame one kamotokakete ekete Ae, Tikisa ago toto ue nakoono, mama moameke atu pia meko-pe-koli ");
INSERT INTO wiu_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yesu kamokakome pupulege kikoa okome okome kapakoa kawia wa wa okale pupulege teigaloganeya. Ue mineka tooko lapa eyaka waametekoa kilikoa meeloganeya. ");
INSERT INTO wiu_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Nitikale one oyali-kiti-pala okome okome edekolo piti motiki-pe. Kipa nooke wene tugamekete pitipa motiki-pe wa okale ");
INSERT INTO wiu_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","piti tube mati motaneya tokome kini kini oote tekete ekete pupulege ue minetameka oneme okole-kamadopa i tokono, Yesupa edoa ali kakome tokoto patu wa ka̱ oa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesu one oya-lawe-pala ue dipike eni mea pote Galili ue mine eka matanuke Gerasa yatenane take witapaneya. ");
INSERT INTO wiu_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Witapekome ue dipike mea matanuke katepitoa pome ka ludu yakaka poane ipono awitane ago pade one kotua nekeneya. Einagopa tuane ali atoa oloyo toai taneka kawa nekeneya. ");
INSERT INTO wiu_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Einago tuane yene oloyo toai taneka yakene agopa padameka dekoa moa kawikamele toameneya. Kapa poomeka lutua kawikamele toameneya. ");
INSERT INTO wiu_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Kawikoa enekolika kapa tepo mekakakoi kugutukoa tadekatapea pitoa pome ni kapa poo kakakoi kekolokoa pitoa pokala taneya. ");
INSERT INTO wiu_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Likonu loyoka eni ta luduka tono tono wanekeka yakome ka̱ oa tigini-pala aloame koboa taneya. ");
INSERT INTO wiu_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Nitima yawa kawapa padepete padeka mati kakome enekale Yesu nome kakale enekome one kakata teyapea nome wadini tukupia mekome ");
INSERT INTO wiu_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ka̱ telo okome okome ako odene meko Akolaline mana Yesu nepa edade noka-pe. Akolaliyo yakakoane ukuno, no tete meamoano wa-ye wa kowitaneya. ");
INSERT INTO wiu_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Nimo wa kowitikomepa Yesuyo poane ipono ne winago takoa pa wa okale tokome ni akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Nimo okale yatekome okome neke ibini te-pe wa okale okome i agoke toto peya mati awinote mekoya tokome ibinipa ipono ti wa ootokoa ");
INSERT INTO wiu_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","kowitikome okome toto i ta wawa padeka poe wa moa wetekamea wa kowitoa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Nipete einakeya liti tono kebonoke kai peya mati kimi ke noa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Nitikoli tokome ipono-kitame Yesu kowitikete ekete toto kunuka kunu kai-kitike awiponoono, moa wetekoa ta wa kowitaneya. ");
INSERT INTO wiu_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Nipa poe wa Yesuyo okale takoa pootapekete e kai-kitike awipaneya. Nitikoli einaka eina kai tono payaneke kawa palake ketipea kikilikoa pote atukolokapaneya. Nipa ege egeta kadukoa (2,000) tadiya kai ue nakoa tukolokapaneya. ");
INSERT INTO wiu_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Nitikoile enekete kai egetane yene to̱omoa pote ali atoa ta latia pitikoikaka tayo yapu luduka eni tanemo oa pupitikama pekeneya. Nitikoli yatekete edele taneyake ikiti patu wa enadete nekeneya. ");
INSERT INTO wiu_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Yesu kakata eni note enekoli ipono ti awitaneya yakanakago wene ki̱yo akaneya mea pue wa moa kakeneya meadeka. Nitaneya mekale enekete ekee wa piti tokale kakoli ");
INSERT INTO wiu_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","eida kakete enile tokale enekoi yename ete dika dika wa ipono awitaneya meane ago-pala tanemo oa ni kai-kiti-pala tanemoka i i wa to̱awea akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Nitaneyake e yename i take meameneya, wete pade take poano pa wa Yesu kowitaneya. ");
INSERT INTO wiu_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Nitikoli eni ta tewitikoa ue dipike peapetekoa poademe kakaka ipono awitaneya yakanakagome okome nepala odenekata yatono pato wa Yesu kowitikale okome ");
INSERT INTO wiu_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","nitamatono, neke take ali atoa mekika poke mepamene. Nipa no Ali Munoyo ne ela motekene epetekakoumo neke ali atoa to̱awea oma poano pa wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Nitaneyake Dekapolise ta ludu yakome Yesuyo one epetekakanakamo i i wa to̱awea oma yakale yatekete peyame ekee wa wene kainya pianeya kakete ka̱ oa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu ue dipike wa peapetekoa pome mea eka matanuke wakapea pekeneya. Wakapea pome katepitoa kakale ali atoa peya mati one mekata koukoa note kakeneya. ");
INSERT INTO wiu_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Nitoa kakoika losu yapu talo tane ago pade Dairasi wa ibini akene ago nome Yesu enekome one kawane witipitoa kowitikome okome ");
INSERT INTO wiu_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","anu konakoma pene tuademe toko. One latoa yamotono, tuoukome pikota ne noke yono pia epetekakoano ta-kale okome ");
INSERT INTO wiu_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","nitouno patoe wa einago-pala opia pekeneya. Opia poademe pokaka ali atoa lewi lewita pia note apua takama nekeneya. ");
INSERT INTO wiu_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","26","Eni ali atoa pakeke eya atoa mali tuku kakoa (12) ponoka toa kamate yokoa kakome yeneme tuaneya meane atoa litima nekeneya. Einatoa papete dokosa ali-kiti mekoika epetekamotoa pokala taneyake kee-kama enekakale meaneya. Latekamotoa pokala taneyake epetekamele toamokale one kue peya takoa wetekaneyake pa ete toa yene tube toma pekeneya. ");
INSERT INTO wiu_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Nitane atoame Yesu toma yakenemo kugu yakaneya tokome einali atoa pake pake Yesuno mukiti lono lekama nome one tokoo kakene mamina nami mitikananeya. ");
INSERT INTO wiu_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Nipa i agono kakene mamina namido mitikakenepa latoane pou wa wene pikome taneya. ");
INSERT INTO wiu_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Nitoa nome mitikakale eina eina one kamate pegetoa yotokana toa yoameneya kakome eina teigome tadeko wa wene taneya. ");
INSERT INTO wiu_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Nitikale Yesuyo one tele padeke weamutukome tadekono wene tokome eina eina kutu peketapekome ali atoane kabeta pake pitikoa okome okome noanu teyo mitikakato-pe-kale ");
INSERT INTO wiu_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","one oya-laweme ekete ali atoa apua takoa ne unukamoa mitikakoa tikino, edekolo oko-pe wa okoli ");
INSERT INTO wiu_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","one mitikanane tuku toa enademe enapemu taneya. ");
INSERT INTO wiu_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Nitikale einakatoa one epetekakana wene tokome pitime kolu kolu nokale Yesu kakata nokome kawane witipitakome one-pala tokanakamo to̱awea akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Enimo okale Yesuyo okome anu kono nooke wini wene tugake tokoleme ne latekakolo uku. Neke tepe kolotini kilikoa pimotono pa. Neke tane yene teiganeya poano pa wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Nimo oa kakaka tobou agono yapu pitikoi yene pade-mene nekete ekete neke konopa tukome tukano, mone i Tikisa ago polipo takakoa kawamea wa onaneya. ");
INSERT INTO wiu_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Nimo omotoake Yesuyo losu yapu talo tane ago-pala okome okome no i agome neke kono oyake latekamele toko wa piti toameneya meamene wa oomotokome ");
INSERT INTO wiu_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Pita Yameta Yamene wamene ago Yone toa koua pomepa ete yene noameo wa kini-mene pekeneya. ");
INSERT INTO wiu_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Losu yapu talo tane agono yapu eni koua pokome enekale ali atoa ete palo oto palo toa kakete komo ka̱ta pitikoa kakoli enoa yakaneya. ");
INSERT INTO wiu_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Nititikoa yapu tuapea pokome okome dekolo kale kene natekoa komo ka̱ pitikoa kaki-pe. I akoma tukome tuaneya menano, pa atu pia meko wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Nimo okale yatekete e ali atoame one yau takakoli kiwi peya akolono poe wa wia lititapeneya. Nititikoa etene ninetaka one koua nokana ali-meneka patono noe wa einakoma yene taneya piane yapu luku pekeneya. ");
INSERT INTO wiu_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Nitoa pokome akoma-pala okome okome Talisa kumi. Enipa tone agalekepa i akoma deya yakoa wete kamoa wane uku wa okome akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Nimo oka oka kamokoa yakeneya. Mali tuku kakoa (12) penane akomapa Yesuyo eni kamotokaneya. Yesuyo enile tokale enekete one-pala kakene yename ekee wa ka̱ oa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Nitikoli okome anume tukumo ali atoa enekete natemoka to̱awea wameamene. I akoma nee moa lawetoe wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesuyo einakoma latekamotokome one pine take wakapea pome mepaneya. Koua pato wa one oyali-kitika pote mepaneya. ");
INSERT INTO wiu_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Eidapa ko mea pupu toamene-pete Yesu losu yapu pome Akolalinemo olaukoa kakeneya. One eni olaukoa kakome okamo yatekoi-kiti peya matiyame ka̱ oa kakete ekete i agopa teyo olaukaneya-pe. Edane peku nootokoa okoto patu. Namolo enamokoonakale padele padele telekole i agome i toko. ");
INSERT INTO wiu_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Beita, i agopa pa kodou ago. One nine Maria i mea one wamene-mikiti Yame Yosi Yudase Saimone einago-mene i mea tiki. One laine-mikitika tone i take meki wa one-pala wene pokete paya tetepo takoa wakeneya. ");
INSERT INTO wiu_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Nitikoli okome Akolaline agale to̱awea akakagopa ete yename kei pimotoake one ta pine yenameka one kako yenameka one yapu pitiki yenameka paya tetepo takoa wakala tiki wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Nitaneyake eni take mekome padele tubele tamele toameneya. Nilepa tamele toameneyake yene tane ali atoa yono pia latekakilepa pa natetekoa latekaneya. ");
INSERT INTO wiu_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","One take yene oneke wene tugameneya mekoileke Yesu wene kainya pianeya meaneya. Yesuyo one eni ta tewitikoa pome ali atoa pitikoika yakome Akolalinemo olaukama yakeneya. ");
INSERT INTO wiu_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Nitoapa one oyali-kiti tuku kakoa (12) one kakuta koukoa noe wa kayo oa mootokoapa einapete titimoa takuta takuta wa moa padeka padeka wetekakome eya wa akeneya. Noanu tele patu kautakoa kama yakete ali atoake awitane poane ipono takoa wetekakala tamene. ");
INSERT INTO wiu_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Nitima yaketepa palawe wane aua poamoa ka ua poamoa kue lene ua poamoa pa poatino poe. ");
INSERT INTO wiu_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Enika eniya aua poameketeke iti toua moa kawa yene mekoa tamene. Tigini kawatiki mamina takuta aua poamoa odene kawatoa pamene. ");
INSERT INTO wiu_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Nitoa pima yawa pade take pote meketepa yapu yapu yawameneya odene yapu-kama mea kawa pokala tamene. ");
INSERT INTO wiu_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Wa pade yapu pitikoi ali atoame kini yapu noatino noe wa makutukoa moamoa kini agaleka yakoa moamoa tokolipa kini eni yapu tewitikoa pekete kini kawake kakene kege ko̱ketikoa pamene. Akolaliyo kiwi kibu moateko adeka pia nitamene wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Nimo okale e ali-kiti pote ali atoa kini namolole tewitikoa wawe wa mo wima pekeneya. ");
INSERT INTO wiu_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Nitima pekete ali atoake awitane ipono takoa wetekoa eya kuya yene tane ali atoa kainya matike peto pekoa latekoa taneya. ");
INSERT INTO wiu_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Yesuyo toma yakenemo ali atoame otoka otoka tokoimo kugu Erodeyoka yakaneya. Pade-kitame ekete ali atoa ue motokama yakanakago Yone tuaneyake wa kamoa nomepa nipa tubele mati toateko tele eni luaneya yakome toko wa oa ");
INSERT INTO wiu_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","wa pade-kitame ekete e̱'e, mena. I agopa Ilaida wa oa wa pade-kitame ekete i agopa Akolaline agale papete to̱awea akane ago tetepo takoa meko wa oa taneya. ");
INSERT INTO wiu_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Yesuyo toma yakenemo kugu eni yatekome Erodeyo okome ekee, ali atoa ue motokama yakanakago Yonepa kabe teigoa tukamotoane tokounake wa kamoa nokome toko wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Namolo Erodeyopa one poyo ali-kitame Yone dekoa moa kapa po kakoa po yapu pitikamotoa tikilepa eya atoa Erodiasine wene epetekademe taneya. Nipa Yoneyo eya tokale tokome taneya. Erodeyo one kale atoa wamenago Pilipi natono Erodiasi one motaneyake ");
INSERT INTO wiu_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Yoneyo Erode mekata nokala tokome okome neke kale atoa kode motekepa toto Yu yenane kekanele wini toka wa lugutukoa kikoa okala taneya. ");
INSERT INTO wiu_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Nitikale Erodiasi einatoa Yone-pala timini nakale mekome wia tukamotadiya wa wene pikake enapete pade nitamele toameneya. ");
INSERT INTO wiu_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Nipa Erodeyo Yone wia tukamene piti tokale mekome mama moa yopikale tokome nitamele toameneya. Erodeyopa Yone einago epetanele-kama toa wene ki̱yo akeneya mea toko ago wa wene taneya. Eni wene tokome mama moa yopikome one agalepa yakada wa one mekuta ne noo wa motokome yakoai taneya. Nitoa yatekome wene kainya mati pianeya meake wedia yakakoa meaneya. ");
INSERT INTO wiu_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Nitaneyake Erodiasiyo Yone wia tukatekale pa nepikoa meaneya. Nitoa mekakoa Erodeyopa one opiane oi ponokale eya taneya. Oneke timini kakoa yakene yeneka one tobou poyo ali-kitika Galili take ibini akene ali-kitika kini toge kikakakuno toge nee natono noe wa agale oa wetekakale nekeneya. ");
INSERT INTO wiu_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Kini note koukoa mekoita Erodiasine kono nome tiabu toa kakale Erodeyoka one togeke nekene yenameka ke wa wedia meaneya. ");
INSERT INTO wiu_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Erodeyo ke wa wedikome okome agetai ti̱a, anukuya-kiti pade memotono wenedo pikepa nipa iya mano wa oano ta. Anume yopiku ta kounale oto pia yamea wa okaleka oto piane yameou wa Erodeyo okale ");
INSERT INTO wiu_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","akolono nine kakata pokome okome au̱a edeya mano wane ou-pe wa yatekale niname okome poke imo akapa. Ali atoa ue motokama yakanakago Yone kabe teigoa one wago wane okolo kagonoke pia oto memotoa toano ta wa akoano pa wa niname oa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nimo okale teyapea Erode mekata pokome okome ali atoa ue motokama yakanakago Yone kabe teigoa wago wane moa okolo kagonoke pia oto memotoa toano ta wa akaneya. ");
INSERT INTO wiu_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Nimo okale yatekome Erode elapa tube mati toa kakeneya. Nitikomeke one namolona etene ti̱a wa okana agale tetekakomepa one-pala opia mekete toge nee nakoi yenane wene potokamedekale eya taneya. ");
INSERT INTO wiu_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","One poyo ago pade moa wetekakome okome Yone kabe teigoa wago wane aua notokoano pa wa moa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Nitikale pome Yone po yapu pitikata kabe teigoa one wago wane okolo kagonoke pia aua nome eina tuatoa metekaneya. Nitikale moa ninane aua potokaneya. ");
INSERT INTO wiu_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Nitaneyake Yonene totono yakoa one opia yakene yename Yone kabe teiganeya wa okoimo yatekete Yonene tigini monote aua pote kota keneke pipaneya. ");
INSERT INTO wiu_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yesuno oyali-kiti Yesu kakata oto wa wakapea note kini padele padele toma pokoinakamoka agale olaukama pokoinakamoka i i wa oa mekala taneya. ");
INSERT INTO wiu_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Nitikoli okome opi kini pupu ko meatino, ali piamene take patono noe wa akeneya. Nipa kini mekoita ali atoa nekete pekete toa kakoli kini nee toa noatekoile toamokale tokome ni akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Nitoapa ue dipike peapetekoa pote ali piamene take mea pote witapeneya. ");
INSERT INTO wiu_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Nitoa pokoli ali atoa kainya matiyame enekete ekete kunu pikipa Yesu one oya-mikiti-pala poko-la wa kini kini tubeya take pitikoika kawa one pome witatekata ka ludu pote teigoa kapaneya. ");
INSERT INTO wiu_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Teigoa kakakoa Yesu ue dipi mea nome katepitoa kakome enekale einali atoa eida oboa kakedekoi. Einali atoa enekome okome i ali atoa talo tokago kawamokono, egetamene sipi sipi kai keneya meki wa ela motokome pademo pademo oa olaukoa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ta pene lima lima tokaka one kakata one oya-mikiti nekete ekete ipa ali piamene taano, ");
INSERT INTO wiu_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ta-pala lima nokono, ali atoa ta latia pitikika tayo yapu luduka i yene kini noatiki nee topo toa mopamene wa oa wetekoa ta-koli okome ");
INSERT INTO wiu_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","kini noatiki neepa kime motokoa lawetamene-kale ekete neme edemo wa oko-pe. Ege kadukaka kapidi kakoa-peta kadukoa (1,000) kina kueme kini nee motokapote oto wa lawetemotoa oko-pe wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Nimo okoli okome kini palawe wane edela piko patuno, enepoe wa okale pote enoa wakapea nekete ekete palawe ko kakoa-pala (5) de mou yomo deya takuta toa piko-koli okome ");
INSERT INTO wiu_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","40","i ali atoa kiwi peya poma ludu tutu tutu wa payapono pia kilikoa meetapeo wa okale padeka-kiti ege odepeta kadukoa (50) padeya payapono pia mekala toa wa padeka-kiti ege takupeta kadukoa (100) padeya payapono pia mekala taneya. ");
INSERT INTO wiu_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Nitikoli Yesuyo palawe wane ko kakoa (5)-pala de mou yomo takuta toa moa pikoa kakome ate tibuke nepikakome ke wa Akolali-pala ootokoa popimotokome one oya-mikiti metekome okome tatikapoatino poe wa mekala taneya. Wa eina toa de mou yomo takuta popimotokome mekala tokale moomotekete tatika tatika topokoli ");
INSERT INTO wiu_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","peyame moa noa tagatapea kitipu meaneya. ");
INSERT INTO wiu_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Nootokaneyake palawe mou kugu paka pitaneya wekotoa moa ua ka katika tuku kakoa (12) mako puputua moa pianeya. ");
INSERT INTO wiu_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Eni palawe nakoina-kiti ali-kama takoa oi motikilepa ege egeta kadukoa (5,000) nakedekoi. ");
INSERT INTO wiu_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Yesuyo e yene lawetetekoa kakome one oya-mikiti-pala okome okome ue dipike peapetekoa pote eka matanuke Besaida take kiwi namolo takoa mepoatino poe. I ali atoa kini kini pitikika pipoatino poe wane wetekamotekene nouno, patepoe wa one oyali-kiti wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","E oboa kakoi yene pipoatino poe wa wetekatekoapa Akolali kowitademe tono tobouke lewia pome mepaneya. ");
INSERT INTO wiu_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ta likaka Yesuno oyali-kiti ue dipike mea muke pekete kakoli Yesu matanuke kidene kakeneya. ");
INSERT INTO wiu_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Nitoa kakome enekale pupulegeme ue dipi kiwi nokoina lono kutu wa popokoa aua poademe tokoa kakale enaneya. Pa nitikoa kakale ta patademe tu̱ei teigaka Yesu ue tali ludu kautoa nekeneya. ");
INSERT INTO wiu_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Nitoa nome patukademe ponokale eneketepa ipono nokono wene pikete ka̱ oa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Nipa peyame one nokale enekete tekete piti mati motekete akeneya. Nitoa ka̱ oa kakoika okome no i nukuno, tepe kolotini kilikoa pimotono piti moameo wa ootokoa ");
INSERT INTO wiu_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","ue dipike pome kipala opia meaneya. Pome mekale pupulege te̱itatapeka. Nitikale enekete one oya-mikitame ekee wa wene kainya pianeya meaneya. ");
INSERT INTO wiu_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Nipa Yesuyo palawe wane moa tokanakale enoake ile tokanakago wa wene toamekete taneya. ");
INSERT INTO wiu_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ue mine eka matanuke witapote Genesarese take katepitoa kakete ue dipike po kakoa yomoke kebeteloganeya. ");
INSERT INTO wiu_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","55","Nitaneyake eni take yename enakago eni noko wa eni ta ludu yekeika yukukata teyapea oawineya pekete kini yene taneya pikoi-kiti leyo leyo toa one meko wa okoita-kama aua nokala taneya. ");
INSERT INTO wiu_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Nipa Yesu ali atoa pitikoika de takeka tube takeka tayo yapu luduka yakaka kini yene tane ali atoa makesike-kama piponokala taneya. Nitikete ekete i yene tane-kitame neke mamina nami mitikatekamotono ta wa kowitikala taneya. Nitikoli one mitikatekakoi peya latoa pokala taneya. ");
INSERT INTO wiu_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Padepete Parisi ali-kitika Mosesene totono pine to̱a olaukane ali-kitika Yerusaleme ta kawa note Yesu kakata oboa kananeya. ");
INSERT INTO wiu_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Oboa kakete enekoli Yesuno oya-lawe padeka-kiti kini yono abe ko̱ameneya mekete nee nakedekoi. Nipa kini kekanele eni tadekoi. ");
INSERT INTO wiu_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Parisi yenameka ete Yu yene peyameka kini kaua-mikitame toma nekenele tekete kini yono abe ko̱otokoa nee moa naki. Pa moa nakiya mena. ");
INSERT INTO wiu_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Nipa makesi kawa yapu note nee moa noadetepa kiwike kewenoko poanele eni koguna wa yono abe namolo takoa kogala tiki. Kini kapoka nee yoatiki meteka kapame latiane okoloka abe ko̱a enile tokala tiki. Kini kekanele takaya kekatekoa nitikala tiki. ");
INSERT INTO wiu_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Nitikiya tokome Parisi ali-kitameka Mosesene totono pine to̱a olaukane ali-kitameka Yesu yatekete ekete neke oyali-kiti kini yono abe ko̱ameneya nee pa moa nakipa tone kaua-mikitame kekaneya latikanele tekete tikino, edekolo tikiti-pe-koli okome ");
INSERT INTO wiu_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","wene takuta pianeya meki yene kini eni toatekoilekepa Aisaiayo papete eya wa wia mekapianeya. I to̱aweane uku ali-kiti kini kabunume no kei pikilepa kini tepene paya wene pianeya meketeke tiki. ");
INSERT INTO wiu_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Nitikino, kini kowitikoimopa edoane yakamotoa-pe. Kini kaua-mikitame titia olaukanele ile tamene ile tamene wa olaukama pikino, yakamou-li wa Akolaliyo wene takane toa Aisaiayo papete wia mekapianeya. ");
INSERT INTO wiu_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ae, Akolaliyo tamene wa akenemo ete pimotoa wakete kini kaua-mikitame titia olaukanele litia tiki. ");
INSERT INTO wiu_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Nipa kini kaua-mikitame titia tanele litia toadetepa Akolaliyo tamene wa akenele wakete onekele pa lede takama yaki. ");
INSERT INTO wiu_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moseseyo papete eya wa akeneya. Neketai neka̱uata kei pia mape moamene. Panagome nitameneya etene nineta akoa tekalepa einago moa wia tukamene wa Moseseyo akeneya. Nimo wapa akeneyake kime eya wa iki. ");
INSERT INTO wiu_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Panagome-kiti one etene nineta-pala okome okome ae, agetai agauata kita ada atue deyata mekiyake kita auapeane padeya meatekuyapa kobane latikakouya tekene meamele toamoko. (Kobane latikaku wa tone agaleke eketepa nipa Akolaline pikaku wa ekete oko.) ");
INSERT INTO wiu_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Einagome nimo ootokoake naniko einakeya etene nineta meou wa meademe tokale kime ekete kobane latikakanano, meamea wa iki. ");
INSERT INTO wiu_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Nipa Akolaline agale ete pimotoa wawa kini kaua-mikitame toma nekenele litikete ile tamene ile tamene wa olaukoa enile pale tokala tiki wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesuyo eida oboa kakoi yene one kakuta noe wa kayo oa motokome okome kipala i ukumo wedoa yakoa moamene. ");
INSERT INTO wiu_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kimane keneke aka ketipea moa nokotikako neemepa pinali one wene oyake moa koigamele toamoko. Nitamele toamokoyake pinali one tepene meaneya poane wene atepea kabunuke witako agalemepa pinali one wa moa koigamele toko. ");
INSERT INTO wiu_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","(Yakou wa kale piiyakoa meki-kiti kime yakoati wane uku wa Yesuyo akeneya.) ");
INSERT INTO wiu_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Nimo oomotokome yapu pome mepokale one oyali-kiti nekete ekete neke ina pedoa okana agalepa pine edoa pikoto-pe wa yakanokoli okome ");
INSERT INTO wiu_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","ae, ete ali atoame wene toamikino, opika kime wene toamekete iki-pe. Panago one kimane keneke aka ketipea noa nokotikako neemepa pinali one wene oyake moa koigamele toamoko. ");
INSERT INTO wiu_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Nee eya moa nakolopa einagono kimane keneke pome tepene ponome me me toa wa te pu latia patukatapekala toko. Nitikome tokono, one weneke patukoa koigamele toamoko wa Yesuyo akeneya. (Nipa eya kuya nee peya Akolaliyo ali atoame nomotoa-kama latia pikaneyano, odeneyaka kekaneya latikakile toameamene wa okome akeneya.) ");
INSERT INTO wiu_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Nimo ootokoa kakome okome e ku poane wene tepene meaneya ya̱wa kabunu witakolemepa pinali one wene moa koigakoya. ");
INSERT INTO wiu_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Nipa tepene meaneya ya̱wa witako toa tokome pamoko mea ni panagoneya kode moa ni ali wia tukoa ni mone padane atoa lia ");
INSERT INTO wiu_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ni eya kuya tepi moa ni ele kule ko̱ianele toa ni ali atoa oa yotokoa ni abeyale toa ni mone panagoneya po̱i moa ni ete ali atoa-pala akoa agale oa ni ete yene paya tetepo takoa ni ele kule pale toa ");
INSERT INTO wiu_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","enika enilepa aline tepene meaneya ya̱wa witako toa pine yene kiwi moa koigamele toko wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesuyo enimo oomotokome Taia ta liti piane take pekeneya. Nitoapa panagono yapu eida pone paigakoane meouno wene pianeyake oyake nitamele toameneya. ");
INSERT INTO wiu_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Yapu pome mekaka eina eina atoa padame Yesu nome meko wa okoimo yakoa nome one kawane witipitaneya. One konakoma deyake ipono awitaneya tokale ni nekeneya. ");
INSERT INTO wiu_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Einatoapa Geriki yatene atoa Sairoponisia take opianeya. Nitane atoame Yesu kowitikome okome anu konoke awitane ipono neme takoa wetekakoa ta-kale ");
INSERT INTO wiu_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yesuyo pedoa agale ete okome okome nee eya nako-pete-kama mati-kiti namolo takoa nee lawetamedeko. Mati-kitane nee tatia wa padeya tue tine-kiti kakoita pitikakopa nipa poko wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Nimo okaleka wa ete einatoame agale topo takakome okome winimopa nimini okoyake mati-kitame moa noa kugu pikapa nee naki walai keneke tue tine-kiti kakoita pitakale tue tine namele toko wa okale okome ");
INSERT INTO wiu_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","neke wini okomoke eya wane uku. Neke konakomake awitane ipono wete takoa pokome tokano, pa wa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Nitikale one wakapea pokome enekale one akoma walai waneke kilikoa kawia pikale enaneya. Oneke awitane ipono takoa pekedeka. ");
INSERT INTO wiu_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesu Taia ta tewitikoa Galili ue mine wakapea poademe pokomepa Saidone Dekapolisi tata patukoa pekeneya. ");
INSERT INTO wiu_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Nitaneyake pade ali-kitame kale kene ketea agale liyo liyo pitane ago Yesu kakata aua nekete ekete i ago yono pia epetekakoano ta wa kowitinokoli ");
INSERT INTO wiu_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","einago moa ali atoa kakoita wawa one kidene eko aua pekeneya. Nitikome einagono kale kene yono pitikoa tekelipu tootokoa einagono keke mitikakatekaneya. ");
INSERT INTO wiu_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Nitoapa tibu ate enekakome kenemada ootapekome okome Epasa wa akeneya. Epasa wapa wete peetapea wa okome akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Yesuyo Epasa wa okale eina eina einagono kale kene peetapea keke epetekoa tokome one agale yapetekoa witoa akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Nitikale Yesuyo e yene-pala okome ete ali atoa kotukete anume i tukumo to̱awea ikileka toameamene wa akeneya. To̱awea ikileka toameamene wa okala taneyake one eni tanemo oa pupitikama yakeneya. ");
INSERT INTO wiu_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Nipa wene kainya mati pianeya kakete ekete i agome ele kule tikilepa epetanele-kama toko. Kale kene keteaneya meane-kiti epetekakolo agale yakoa ni agale amele toameneya meane-kiti epetekakolo agale oa tiki wa ka̱ oa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Enipete-mene ali atoa peya mati Yesu kakata wa obomoa note kananeya. Kini nee noatekoiya toamokale enekome Yesuyo one oyali-kiti one kakuta noe wa kayo oa motokome okome ");
INSERT INTO wiu_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","i oboa kaki ali atoa mama moane ela motekene uku. Ta tebolo pataka toa no-pala opia yakete kini noatiki nee peya takatekoa pa kaki. ");
INSERT INTO wiu_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Padeka-kiti ta tetemada pia note kaki. Nee noameneya kini kini yapu tadoa poatino poe wanedo wetekakolupa yapu poadete pokoika pake kobume tukete witipitoino wetekamele toamoko-kale ");
INSERT INTO wiu_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","one oyali-kitame ete Yesu-pala agale topo takoa yatekete ekete ipa ali piamene taano, kini noatiki nee edoa motokoa lawetemotoa-pe wa okoli okome ");
INSERT INTO wiu_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","ni kini palawe wane-kiti edela piko-pe-kale ekete tatono kakoa (7) odene piko wa okoli ");
INSERT INTO wiu_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","i poma ludu meetapeo wa e ali atoa mekatapeneya. Nititikoapa tatono kakoa (7) palawe wane moa pikoa kakome Akolali-pala ke wa ootokoa popimotokome one oyali-kiti metekome okome i ali atoa tatikapoe wa mekala taneya. Nitikale mootokoa e ali atoa mekoi toa nee pikama yakeneya. ");
INSERT INTO wiu_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","De mou-meneka moa eina toa Akolali ke wa ootokoa popimotokome metekome okome i mouka tatikapoe wa okale ");
INSERT INTO wiu_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","pikama yakoli noa tagatapea kitipu meaneya. Nitaneyake nee kugu pika wekotoa moa ka katika tatono kakoa (7) mako puputumoa pianeya. ");
INSERT INTO wiu_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Eni nee nakene-kiti oi motokolipa ege egeta kadukoa (4,000) tadiya nakedekoi. ");
INSERT INTO wiu_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Eni ali atoa kini kini yapu yapu tadoa poatino poe wa wetekatekoa one oyali-kiti-pala ue dipike wete eni peapetekoa pome mea Dalamanusa take witoa pekeneya. ");
INSERT INTO wiu_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Einapete Parisi yene padeka-kiti Yesu kakata note one-pala agale ete oto topo takoa oa kakete ekete neke toma yakole Akolaline tele patu kautakoa kake tadekalepa nipa a tibuke padele telekole witakamotono ta wa likoa enaneya. ");
INSERT INTO wiu_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Nitikoli tepe we tokale kakome okome ae, ipete meki yene kimepa no neke tokolepa Akolaline tele patu kautakoa kake tadekalepa nipa padele tubele yamea ta wa ikipa edekolo likoa eneki-pe. Enile pade yameamou wa oomotokome ");
INSERT INTO wiu_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","e yene tewitikoa pome ue dipike wa peapetekoa pome mea eka matanuke witoa pekeneya. ");
INSERT INTO wiu_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Yesu eni mea pokaka one oyali-kitame palawe wane-kitipa wene kayapea ua noameneya tuku toa kakoli odene wane piadeka. ");
INSERT INTO wiu_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Nitadekale Yesuyo one oya-lawe pubu okome okome Parisi ali-kitika Erode einagoka kini yisi kugu kiwike weamuoono, wedoa yamene wa okale ");
INSERT INTO wiu_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","kini kini yakate tekete ekete tone noateko palawe wane-kiti wene kayapea ua noamokoonake ni okome oko wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Nitikoli kini tepene piane wene tetoa enekome okome kini palawe wane ua noamokoinakepa edekolo oa kaki-pe. Anume tokoule enetekoake wene toamekete iki-pe. Kini kolotini lupi tootokaneya meki-pe. ");
INSERT INTO wiu_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Kini lene kamotoake anu tokoule enoa moamokoi-pe. Kini kale kene kamotoake anu okoumo yakoa moamokoi-pe. Nipa anume tokolu kime enekoinakale wene kayapetapea mekete iki-pe. Nipa eya tokouna. ");
INSERT INTO wiu_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Palawe wane ko (5) kakoane moane ali atoa ege egeta kadukoane (5,000) lawetekolu nootokaneyake kugu pika wekotoa moapa ka katika edela mako puputumoa pikoi-pe-kale ekete ka katika tuku (12) kakoa mako puputua pikoo-koli okome ");
INSERT INTO wiu_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","ni pade-petenaka palawe wane tatono (7) kakoane moane lawetekolu ege egeta kadukoa (4,000) ali atoame nootokaneyake kugu pika wekotoa moapa ka katika edela mako puputumoa pikoi-pe-kale ekete ka katika tatono (7) kakoa mako puputua pikoo-koli okome ");
INSERT INTO wiu_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","eina tokoule enetekoake wene toamekete iki-pe. Eina tokouna toane wa tamele tokolo mekene tukutumo wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesuyo Besaida take pato wa one oyali-kiti-pala pome mepaneya. Nitikale pade yename leneta lianeya meane ago oneke aua note kowitikakete ekete i agopa yoname mitikatekoano ta-koli ");
INSERT INTO wiu_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesuyo pata wa einago yono moomotokome eni ta kago ketepono patukoa akolono pekeneya. Nitoapa one leneta tekelipu takatekoa yono pikome okome padeya eneko-pe-kale ");
INSERT INTO wiu_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","ate enekakome okome ali-kiti enekilepa tukuyake yomo-kiti yakene tetepo toko wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Nimo okale einagono lene yono wa pikale wedoa nepikoa pikale one leneta epetekatapekale padeya padeya peya keleyo pikolokakale enaneya. ");
INSERT INTO wiu_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Nitikale Yesuyo okome winika wini ali atoa pitikika poameneya neke yapu patukake poano pa wa oa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Sisaria Pilipai take pato wa Yesu one oya-lawe-pala eni take ali atoa pitikoika poademe pokome okome ali atoame no te kakulu okala tikiti-pe wa yatekale ekete ");
INSERT INTO wiu_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","ali atoa padeka-kitame ne i agopa ue motokama yakanakago Yone wa oa ni pade-kitame ekete ne i agopa Ilaida wa oa ni pade-kitame ekete ne i agopa Akolaline agale to̱awea akako ago pade wa oa tiki-koli okome ");
INSERT INTO wiu_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","nimo wapa akedikiyake anu oya-lawe kime no te kaku wa iki-pe-kale Pitayo ete topo takakome okome nepa Keraisu wa papete takoa kakapiane ago wa okale okome ");
INSERT INTO wiu_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","no Yesupa Keraisu taatekoane nekedeku wa ali atoa kotukete etene to̱awea ikileka toameamene wa oa tukaneya. ");
INSERT INTO wiu_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Nitoapa Yesuyo one tuatekamo i i wa enipete titimoa to̱awea okome okome no Ali Yatenane Oyagome tete-kala moane kawou. Nipa Kanosolo ali-kiti ni Akolalike lodo yotokoai tiki tobou ali-kiti ni Mosesene totono pine to̱a olaukaki ali-kiti enika eni ali-kitame no kote tokale wawa wia tukoi. Nitikolika ta tebolo takoa pataka-pete kamoane pou wa Yesuyo akeneya. Nipa keleyo to̱awea akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Nimo okale Pitayo pata wa Yesu-pala eko keneya aua pome kakome kikoa okale ");
INSERT INTO wiu_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Yesu kutu peketapekome o yene enekome okome i ago Setanu ne anu mukiti lono kuka ponoke kapono, winipa Akolaline wene piko toa wamoa, pa aline wene piko toa okono, wa wa kikoa akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Nimo ootokoa kakome one oya-lawe e oboa kakene yene peya one kakuta noe wa kayo oa motokome okome no i ago litima nou wa wene pikagopa nekele tewitikoa wamene. Nipa ne wia dekatiki yomo-pala aua nou toa keneya tete mokoa kakeka no litima namene. ");
INSERT INTO wiu_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kepene mama motokome tukaya wa piti motoko agopa etepea tua atua poo. One kepene mama moamokome Akolaline epetane agale-pala no i agotake oyake tuou wa wene pikagopa toa motaneya mea kama poo. ");
INSERT INTO wiu_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Panagome-kiti one yomini atukome atumotoake itonoke pia kawa tokoya peya mootapeadekalepa edeya weike moamoo. ");
INSERT INTO wiu_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","One yominido atukome atukalepa edeyame oto wa topo toa momotoa-pe. ");
INSERT INTO wiu_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","No kaku-pete meki yene Akolalinele takamoa poanele toa mekino, kiwi panagome no-pala anu agaleta ya motokome wakalepa no Ali Yatenane Oyagome einagoka ya motekene wawou. Nipa Agetai pa̱ teleta tootapeneya meko toane meane one wene ki̱yo akeneya meki edelo ali-kiti-pala odeneka wakapeane nekene nitou wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesuyo nimo ootokoa kakome okome etene nimini ukuno yakoe. Ita kaki yene kiwi padeka-kiti wete tuameneyake Akolaliyo ali atoa pawe toa talo tokome padele telekole tokale enoi wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ko melepu kakoa (6) ta patatekaneyake Yesuyo Pita Yameta Yone toa kidene-mene ete witimoa aua pome tono kakene matike lewia pome kapaneya. Nitoapa o ali-mene kakakoa one lene timini yono eya yati yati tootapeneya kakeneya. One kakene mamina-pala yati yati toa ake tootapeneya. ");
INSERT INTO wiu_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","One eni mamina ake tootapene toapa padameka mamina abe ko̱aka edikoa ake takamele toameneya. ");
INSERT INTO wiu_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Nitaneya kakata Ilaida Moseseta aida kotikatapea nekete Yesu-pala ko oa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Nitikoli enekome Pitayo okome Tikisa ago kimene ko oa kakita toto-meneka odeneya kakono, ke wa oko. Neme nitika wa okalepa aga yapu tebolo Mosese Ilaidata kini tutu tutu wa wikakoo wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Nipa one oateka agopa tokale tokome pamo eni akeneya. Nipa Yesuno oyali-mene piti tubeya tokale tokome akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Nimo oa kakaka wedome agopa takoa kauma nekeneya. Nitikaka eni wedo keneke agale ludu nokome okome anu mana anu kolotini ago wini kakono, one oka toa yakoa tamene wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Nimo okaka wete enetapekoli eina kakoinakagota kawameadekoi. Kimene-pala Yesu odene einata kakedeka. ");
INSERT INTO wiu_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Wa naniko eni tonoke keti koma nekete pake Yesu kakome okome Ali Yatenane Oyago no tuane kamoameneyakepa kimename opi enekoinakamo pa kini luaneya mema yamene wa Yesuyo oa tukaneya. ");
INSERT INTO wiu_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Nitaneyake eni oa tukakana luaneya yawa meake Yesu one tuaneke wa kamoane pou wa okanapa edeleke okato patu wa ete oto wa pitia yakakala taneya. ");
INSERT INTO wiu_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Nitoapa Yesu yatekete ekete Mosesene totono pine to̱a olaukaki ali-kitame eya wa olaukakala tiki. Keraisu naniko taatekoa nomotoa Ilaida one namolo takoa noo wa ikino, enipa edekolo ikiti-pe-koli okome ");
INSERT INTO wiu_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ilaida einagome padeya padeya peya nodokapiademe namolo takoa noo wa papete wia mekapiane toa eni iki. Nimini ikiyake eya wane ukuno yakamene. Ali Yatenane Oyago einagopa ete yename tete mea paya tetepo takoa wawei wa papete wia mekapianemopa edeyake wia mekaneya-pe wa yakatekoa kakome okome ");
INSERT INTO wiu_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ilaida einago wete wakapea nekeneyake pade ali-kiti kini wene ponoka toa litia tekete one tete mekala taneya. Nipa Akolaline bokuke einagoke papete wia mekapiane toa taatekoa taneya wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yesu one oyali-meneka one ete oya-lawe kakoita keti wakapea pote enekoli ali atoame o yene unukamoa kakoli enaneya. Eni pake Mosesene totono pine to̱a olaukane ali-kitika eida kakete o yene-pala neno oa kakoli enaneya. ");
INSERT INTO wiu_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Yesu eni nokale enekete eina eina e ali atoa peyame ekee wa ka̱ oa teyapea pote makutukoa motaneya. ");
INSERT INTO wiu_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Nitikoli Yesuyo e yene yatekome okome kinipa o yene edeyake agale topo takoa oa kaki-pe-kale ");
INSERT INTO wiu_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","eni pake lukoa kakene ago padame topo takakome okome anu managoke agale wamoko ipono awitaneya tokale neeke auane nou wane ni nokou. ");
INSERT INTO wiu_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Anu manake ipono awinokome-kama itonoke moa aua pitikakala toa kako. Nitikale timini kabunuke lako ka̱ua yotokoa one kime noto noto toa mekome one pakunu tau tokome temotele toa kako. Nitikala tokolo tekene neke i oyali-kitame eni ipono takoa wetekakoe wane auane nokounake takoa wetekaku pekete wili toa wakoi wa okale okome ");
INSERT INTO wiu_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","ae, no kaku-pete meki ali atoa kime Akolalinemo yakoa moamikino, kini eni poane wene tewitikoa wamotoane edoane nepiane meamou. Neke mana mati no kakuta aua noo wa okale ");
INSERT INTO wiu_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","e yename Yesuke aua nokale iponame Yesuno lene timini enekome eina eina mati peteka peteka toa kakale itonoke aua pitalogakome welea mekale timini kabunuke lako ka̱ua yokoa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Nitikale Yesuyo matiyane etene yatekome okome eni ipono manipete titia awinaneya-pe wa okale okome wete dee matike lukakoa taneya. ");
INSERT INTO wiu_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Nipa lugutukoa wia tukademe iponame toe mine aua pitikakome uele pitikakome toa kakoyano, neme oyake tamedekalepa toto ela moa auapeamene wa matiyane etename kowitaneya. ");
INSERT INTO wiu_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Nitikale Yesuyo einagome oka agale to̱opitikakome okome tamedekale wa neme wini okopa nooke wene tugoa mekagomepa padele padeleta tamele tokale too-kale ");
INSERT INTO wiu_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","eina eina matiyane etename telo okome okome neeke wene tugakilepa tekeneke wedoane toamuku. Neeke wedoane wene tugoane memotono auapea ta wa kowitaneya. ");
INSERT INTO wiu_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Nitikale kinita kakoita ali atoa teyapea koukanokoli enekome Yesuyo poane ipono kikoa okome okome kale kene ketekoa agale wamoa toko ipono ne wini mati takoa poke wa pade awinamea wa oa tukale ");
INSERT INTO wiu_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","iponame ka̱ telo ootapekome eni mati itonoke aua pitikoa weletekoa kawa takoa pekeneya. Nitikale eni mati tukome tuane tetepo taneya pa pikale enekete e yene kainya matiyame tuadeko wa okoli ");
INSERT INTO wiu_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Yesuyo mati yono moa kamotokakale kamokoa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yesuyo eni mati latekatekoa yapu nome mekale one oyali kidene-mene ete witimoa kakete ekete totome eni ipono oyake takoa wetekamele toamokano, edekome tokato patu-koli okome ");
INSERT INTO wiu_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","kini weneme dikane ipono takoa wetekamele toamokoyake Akolali kowitoa kaketepa oyake toi wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yesu one oya-laweka eni ta tewitikoa pote Galili ta ludu yakeneya. Nipa Yesuyo one oyali-kiti olaukama pokome tokome take yename polipo takakaya tokale yotokamotokome pekeneya. ");
INSERT INTO wiu_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Nitoa olaukama pokome okome no Ali Yatenane Oyagopa pade ali-kitame wimotoa panagome ete moa meademe toko. Moa metekale wia tukakolika ta tebolo takoa pataka-pete Akolaliyo moa kamotokoo wa okale ");
INSERT INTO wiu_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","yatekete one oyali-kitame wene toameketeke neme wini okopa edemo wa okato-pe wa yakapamene piti tokale pa meaneya. ");
INSERT INTO wiu_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Yesu one oyali-kiti-pala Kapaneame take nome menaneya. Nitoa yapu tuapea nome mekome one oya-lawe yatekome okome kiwi ka ludu yakete edemo oa agale to̱onali yoma yakoi-pe-kale agale waametekoa pa meaneya. ");
INSERT INTO wiu_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Nipa ako tobou meateko agopa mani ago patu wa oa takoa pili pili toma nekeneya tokome agale waametekoa meaneya. ");
INSERT INTO wiu_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Nitikoli Yesu one witipitoa mekome one mekuta noe wa one oyali-kiti motokome okome etene ako ago kawouno wene piko agopa nipa nepa pa keku ago tetepo takoa ete-kitanele takama pamene wa ootokoa mekome ");
INSERT INTO wiu_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","pade mati deya one oyali-lawe kakoi pake moa kakaneya. ");
INSERT INTO wiu_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Nitoa mati tebemotokome okome panagome-kiti noke toa dikane mati deya makutukoa motokomepa nipa nopala eni dekoa makutukoa motokome too. Panagome-kiti no makutukoa motokomepa nipa no moa wetekakago-pala dekoa makutukoa motokome too wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yoneyo Yesu-pala okome okome Tikisa ago anu ukumo ne yaka. Panagome neke ibini wedekoa oapa ali-kitike awitane ipono takoa wetekakala tokale totome enekoo. Einagopa toto-pala opia yakago toamokolo tokome wa pade dikameamene wa kikoa okoo-kale ");
INSERT INTO wiu_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yesuyo okome one tokalepa toma pomotono wa pade edikoa wameamene. Panagome-kiti anu ibini wedekoa eni telekole tootokoapa no akoa agale wamoo. ");
INSERT INTO wiu_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Toto-pala poi te̱iamoko agomepa nipa toto mape wikome too. ");
INSERT INTO wiu_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Kipala nimini ukuno yakoe. Panagome-kiti kiwi Keraisuno ibini pedane yene kakino, ue noomotokapouno nepio wa mama moa nomotokoa lawetekalepa one eni tokake nami noanume wiane pewe wiou wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Dikane mati nooke wene tugoa meko mati etepea pomotoa likoa enoa labakagopa Akolaliyo kibu motokome dika dika toamene tete meoo. Ae, eni tete mea kibu moamomotoapa papete mati wete likoa enameneyake laukakoa tube kue matiyame one kabe kautoa kusa ue muke keti pitikaneya too tokapa epetoo toka. ");
INSERT INTO wiu_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Nipa neke yoname-kiti pinali ne toa potokadekalepa yono te̱itapeamene. Yono duku taneyake mea kawateko take poke mea kakedekalepa nipa epetoo. Nitameneya yonota takuta kakeneya kawa poane take pekedekalepa ae nipa poo. ");
INSERT INTO wiu_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Eidapa toe nokoa-kama kakolo tugoa moamele toamoko. ");
INSERT INTO wiu_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Neke kawameka pinali ne toa potokadekalepa te̱itapea wamene. Neke kawa te̱itapea duku yawa kakeka mea kawateko take poke mea kakedekalepa nipa epetoo. Nitameneya neke kawata takuta kakeneya poane take moa pitikaneya mea kakedekalepa ae, nipa poo. ");
INSERT INTO wiu_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Neke lenemeka pinali ne toa potokadekalepa lene to̱a wamene. Neke lene to̱otapeneya yakeka Akolaliyo talo toko take poke mea kakedekalepa nipa epetoo. Nitameneya neke leneta takuta kakeneya poane take moa pitikaneya mea kakedekalepa ae nipa poo. ");
INSERT INTO wiu_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ae, eni poane takepa toe nokoa-kama kakolo oyake tugoa moamele toamoko. ");
INSERT INTO wiu_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Too eni nakiyapa epetaneya tokolo uku. Too kabuka naki nee-kitike noa puki toa ali-kitikepa dikoa toele tadekoo. ");
INSERT INTO wiu_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Toopa epetaneyake me pokome meke toamokolopa edoa wa meke takamotoa-pe. Kiwi too ka̱lono tou toa keneya ete oto wa odene wene piitikoa meamene wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesuyo nimo oomotokome Galili ta tewitikoa Yudea ta ludu yawa Yodane ue ketoa eka lono piane take pome mepaneya. Eidaka ali atoa one mekata koukoa nokala tokoli Yesuyo one tanele tokome Akolalinemo i i wa olaukoa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Parisi ali-kitika one mekata eida note likoa enekete ekete panagome-kiti one atoa pa wa wakomepa nipa Yu yene tone totono litiapa tamele toa toko-pe wa natemo omotadiya wa kakete okoli okome ");
INSERT INTO wiu_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","nikepa Moseseyopa edele tamene wa akeneya-pe-kale ekete ");
INSERT INTO wiu_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Moseseyo papete one totono yametekome okome padagome one atoa pa wa wawademepa nipa namolo takoa ne wakene wakuna wa edikoa pipia wia meetekoapa pa wa wetekamele toko wa Moseseyo akeneya-koli okome ");
INSERT INTO wiu_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Moseseyo eni akenepa Yu yene kini kaua-mikiti kolotini lupi tootapeneya mekoli tokome ni akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Nimo ikilepa taneyake namolo namolo Akolaliyo kamate meaneya-kiti titikome latikilepa ali atoata takuta wa-kama latikala taneya. ");
INSERT INTO wiu_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Nitanelekepa alime atoa motokomepa nipa etene nineta tewitikoa wawa one atoa-pala lipukoa meoo. ");
INSERT INTO wiu_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Nipa namolo takuta letetakutukoata meaneyake naniko odene tigini tetepo tokale mekete liputakutukoata meoi. Nitoa mekoli ipa i ago ipa i atoa wa tutu tutu wa ibini amele toameneya tokome i adona wa odene tetepo takoa oi. ");
INSERT INTO wiu_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Nipa Akolaliyo moa lipukane ali atoata padameka moa letekatakutukamele toamoko wa Yesuyo oa pekeneya. ");
INSERT INTO wiu_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Nitoa yapu pome mekale one oyali-lawe note yatekete ekete eina agale pinepa edoa pikoto-pe-koli okome ");
INSERT INTO wiu_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","panagome one atoa ne pa wa wetekatekoa pade atoa motokomepa nipa mone koua piamateko atoa motokome toko. Nipa namolo atoa eni toa potokakome toko. ");
INSERT INTO wiu_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Atoameka onekane wawa pome eko alike pokomepa nipa koua piamateko alike eni pokome toko wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Wa padepete pade-kitame kini mati-kiti one yoname mitikakamotoa Yesu kakata aua nokoika one oya-laweme noameo wa kikoa akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Nitikoli enekome Yesu wene pokale okome wini mati-kiti oto nomotono, etoe. Akolaliyo one talo tokotapa kinino, noe wa yametekilepa dikane mati-kiti yametekono, oto nomotono toe. ");
INSERT INTO wiu_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nimini ukuno yakoe. Panagopa mati-kiti Akolalike lukoa mekete tiki toa lukoa meamademe wakomepa nipa Akolaliyo talo toko take oyake pamele toamoo wa ootokoa kakome ");
INSERT INTO wiu_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","eni mati-kiti tebemoa pikoa kakome Akolaliyo pewe wia yopimotoa tokome yono pia kowitikaneya. ");
INSERT INTO wiu_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu poademe tokaka panago teyapea nome wadini tukupia mekome okome epetanele toko Tikisago nepa eya wane yatekene uku. Edele tekene pa meane kama pou-pe-kale okome ");
INSERT INTO wiu_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","nopa epetanele toko ago wapa wini okono, dekolo oko-pe. Epetanele-kama toko agopa Akolali odene kako. Wa pade lokoaka kawamoko. ");
INSERT INTO wiu_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Moseseyo tamene wa papete wia mekanemo neme wene toko. Ali pade wia tukamoa ni mone padane atoa liamoa ni monekeya kode moamoa ni padago-pala pa puputua akoa agale wamoa ni panagoneya oa yotokoa moamoa ni neketai neka̱uata kei pia tamene wa Moseseyo akeneyano, enipa neme wene toko-kale okome ");
INSERT INTO wiu_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Tikisa ago eni akenele-kama tualike laigoane yakoane toma nuku wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Nimo oa kakaka Yesuyo einago nepikakomepa wene einagoke mekakome okome wenepa tadekoyake odenele odene katekoa wene toameadekono, neke pikoya peya topo toa kue mootokoa ponopene ali atoa enoa tatia meetapeamene. Nitikepa neke kamoya a tibuke auma kakeneya enoo. Nitatekoyano, no litima namene wa okale ");
INSERT INTO wiu_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","yatekome wene keda taneya wawa pekeneya. Nipa uu kamo tane ago tokome taneya. ");
INSERT INTO wiu_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Nitikale Yesuyo one oyali-kiti enoa unukakome okome ae, kamo tane yene Akolaliyo talo toko take pikilepa etene wili tokoa kawapa piki wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","One eni oka agalemepa one oyali-kitane wene kainya pikaneya tokome okome ae, anu mati-kiti kipala i ukumo yakoe. Akolaliyo talo toko take pikilepa etene wili wedoa tokoa kawapa poi. ");
INSERT INTO wiu_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kamelo kaido noi keneke-kiti patukoa ponokomepa nipa wedoa wili toa kawamoapa patukoa ponoo. Kamo tane ago Akolaliyo talo take ponokomepa nipa wili tokoa mati kawapa ponoo wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Nimo okale yatekete wene kainya pianeya kakete pitia yatekete ekete kamo yeneke winimodo nimini akedekalepa Akolaliyo mani ali atoa toa moamoo wa okoli ");
INSERT INTO wiu_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","one oya-lawe nepikakome okome ali atoame toamatikilepa Akolaliyo oyake tamele toko. Padele padele peya tamele toko ago tokome kamo tane ali-kitika one take nomotoa ka patekamele toko wa okale ");
INSERT INTO wiu_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pitayo okome ne litima noadetepa tonekeya peya tewitikoa wawa noko-kale okome ");
INSERT INTO wiu_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","nimini ukuno yakoe. Panagome Akolaline epetane agalekeka noanukeka tokome one yapu one etene nineta one laine wamene-mikiti one mati-kiti one toka ipe eya tewitikoa wakomepa ");
INSERT INTO wiu_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","nipa itonoke pa mekome enika eniya lukukepa ege takupeta kadukoa (100) oto mokala too. Nipa yapu nine wamene laine-mikiti mati-kiti ipe eya moapa tete-pala mokoa kawoo. Nitoa mea tukale Akolaliyo one talo tuku take mea-kama kamene wa moa kakoo. ");
INSERT INTO wiu_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Akolaliyopa ako yene kainya mati keku kakoa wa keku yene kainya mati ako kakoa too wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yerusaleme take poadete ka ludu pekete one oya-lawe naniko nomotoa Yesu one namolo kawa pekeneya. Nitoa pokale one oya-lawe wene kainya pianeya litia note ete ali atoa kutu keneya piti taneya litia note taneya. Nitikoli Yesuyo one oyali tuku kakoa (12) eko keneya witimoa aua pome kakome i i wa ete yename one-pala toatekoimo to̱awea akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Nitikome okome kipala i ukumo yakoe. Opa ate Yerusaleme take poadete poko. Pote kakolo no Ali Yatenane Oyago panagome moa eya yenane yonoke Akolalike lodo yotokoai tiki tobou ali-kiti ni Mosesene totono pine to̱a olaukaki ali-kiti kini yonoke pioo. Nitikale no wiatiki oi pedoa piitikoapa mone pa yeneke aua pote mepoi. ");
INSERT INTO wiu_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Nitikoli motekete tegene matoa tekelipu toa yotokoa po wapime wia toi. Nititikoa wia tukakolika ta tebolo takoa patatekaneyake kamoane pou wa Yesuyo oa pianeya. ");
INSERT INTO wiu_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Yesu Yerusaleme take kutu poademe pokaka Sebedine manata Yame Yoneta Yesu kakata note kakete ekete Tikisago totame takamene wa okole neme takoano ta-koli okome ");
INSERT INTO wiu_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","anume edele takamotoa iki-pe-kale ekete ");
INSERT INTO wiu_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","ne pa̱ teleta tootapeneya meke ali atoa pawe toa talo tokaka neeke lokoa totaka panago neke nimini yono lono mea padena ago neke ewa yono lono mea yopioukete oko-koli okome ");
INSERT INTO wiu_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","wene toameketeke iki. Akolaliyo no ne naa wa yametekana ue metepa no tete tubeya moatekou adeka pikano, noanu noateku tetepa kitameka eni noateku toa noukete iki-pe. Noanume ue mou toa tete moateku toa kitameka moukete iki-pe-kale ekete ");
INSERT INTO wiu_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","nitato ta-koli okome noanume noateku uepa kitameka noadete tiki. Noanume ue mou toa tete moateku toa kitameka moadete tiki. ");
INSERT INTO wiu_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Nitadete tikiyake ali atoa talo toane mekouta eka oka yono lonota kita tatikatakutukoane mekamele toamoko. Eka okata meatiki agotapa Akolaliyo i i wa wete wene toopianeyano, anume oyake yameamele toamoko. ");
INSERT INTO wiu_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","E agotame nimo akedekoli yatekete o yene Yame Yoneta-pala wene poaneya kakete ko̱ oa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Nitikoli Yesuyo one kakuta noe wa kayo oa motokome okome mone pa yatenane tobou meki ali-kitame kini ali atoa wete toe toe wa tika tika-kama tiki. Kini ibini akene ali-kitameka ali atoame kinikile-kama takamotoa yopikala tiki. Enipa nimini ukutu-pe. ");
INSERT INTO wiu_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Nitikala tikino, anu oya-lawe kime pade edikameamene. Nitameneya tobou ago meou wado wene piketepa kinikile toamekete kini oya-mikitane pupu takama pamene. ");
INSERT INTO wiu_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Nipa ako odene mekene talo tou wado wene piketepa nipa kueme topo toa moa egetane ago keneya kini oya peyanele takama pamene. ");
INSERT INTO wiu_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","No Ali Yatenane Oyago taatekoane nikilepa ete yename anukule takamotoane nokouya mena. Nitameneya ete-kitanele takoane ni ali atoa peya mati anu kamateme oto toane moadene ni nokou wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yesuyo nimo oomotokome one oyali-kiti-pala Yeriko take pome mepaneya. Wa naniko pato wa eni ta tewitikoa pokale ali atoa iti itita kawa obomoa pekeneya. Kini ponatekoiya liti leneta lianeya meane ago pade meaneya. Einagopa Timiasine mana Batimiasi wa ibini akeneya. Nitane agome ali atoa padeya-kiti manoe-kala oia meaneya. ");
INSERT INTO wiu_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nitoa batete matanuke eida mekome yatekale Nasarese Yesu wini ponokona wa oma ponokoinakamo yatekome telo ootapekome okome Depidi-loeke tagene ago Yesu neme no ela moamene-ye wa kayo oa meaneya. ");
INSERT INTO wiu_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Nimo wa kayo okale e yene kainya matiyame einago kikoa ekete ekete oyakeno, wa wa okoli kayo telo kamotokoa okome okome Depidi-loeke tagene ago no ela moamene-ye wa ka̱ oa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Nitikale Yesuyo yatekome witimoa kakome okome winago oto nomotono, akoe wa okale leneta liane ago kayo oa ekete Yesuyo ne kayo okono, wene weye ootokoa wete kamokoa noo wa kayo okoli ");
INSERT INTO wiu_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","one tokoo kakene pue takatapea ate tigatekoa Yesu kakata nokale ");
INSERT INTO wiu_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesuyo yatekome okome anume edele takamotoa oko-pe-kale okome Ali Muno anu leneta kikakoa wane uku-kale okome ");
INSERT INTO wiu_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","nopa i agome ne oyake latekamele toko wa nooke wene tugoa mekolemepa neke leneta epetekakono, opi poano pa wa okale eina eina lene kikatapeneya Yesu pokaka litima pekeneya. ");
INSERT INTO wiu_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yesu one oya-laweka Yerusaleme take tigotokoa witapadete peketepa Olipe-pini tonoke latiane Besepase Besani tatake witakete Yesuyo eya taneya. ");
INSERT INTO wiu_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","One oyali-kiti takuta moa wetekakome okome kuka ku take poatino poe. Eni take witoa kaalaukete enekoli dogi kai tine eida po kakoa kebetaneya kakale enoi. Eni dogi kai tine patu panagoka wete mea yawameneyano, po kotokoa oto aua notokamene. ");
INSERT INTO wiu_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Kotokoa moadete kakoli panagome dekolo moadete tiki-pe wa okalepa eya wa akamene. Ali Munoyo padele toatekole pikolo ni motokoa poko. Opi oto wa i wetekademe toko wa akamene wa oa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Nitikale pote enekoli dogi kai tine yapu kago tiginike kebeteloganeya batete muke kakedekale kotokoa motaneya. ");
INSERT INTO wiu_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Nitikoli eniya liti kakene yename enekete ekete mone dekolo kotokoa motiki-pe wa okoli ");
INSERT INTO wiu_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Yesuyo oa wetekakanakamo i i wa okoli nipa nitoe wa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Nitikoli dogi kai aua Yesuke nekete kini tokoo kakene mamina petene kotokamoa dogi kai patu tatikakoli Yesu mea pekeneya. ");
INSERT INTO wiu_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Nitoa mea pokaka ali atoa peya matiyame kini tokoo kakene mamina kotokamoa one mea poatekaka bateteke pia tatikawineya pekeneya. Wa padeka-kitame li ludu pote yomo yenene deya tewia moa batete ludu tatikama pekeneya. ");
INSERT INTO wiu_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Nitikete namolo kawa pokoi-kitameka naniko ketea kawa nokoi-kitameka agale kamotoka kamotoka toa ke ke wa oawineya pekete ekete i agopa Ali Muno patu kautakoa kama nokono, Akolali neme pewe wia yopia kamene. ");
INSERT INTO wiu_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Tone kaua ago Depidiyo papete ali atoa talo tokome tane toa opi enakale wa witademe tokono, Akolali neme yopia kamene. A tibuke meki peya one kei piamene-ye wa kolotine togete oawineya pekeneya. ");
INSERT INTO wiu_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Nitawineya pokoli Yesu Yerusaleme take witakome tobou losu yapu keneke pome kakome eida pia kawa tokoya peya enetapeneya. Nitoapa ta lima nokale tokome one oyali-kiti tuku kakoa-pala (12) pato wa Besani take pome pipaneya. ");
INSERT INTO wiu_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Besani ta piimotekete podolikama pekete Yesu kobu tokale ");
INSERT INTO wiu_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ete enapekome enekale padeka mati yomo piki pade tata pitikaneya kakale enaneya. Nitoapa ku̱ tuaneya patu wa pinele pome enepokale tata pitikoa kakomeke ku̱ tuameadeka. Ku̱ tuamateko-pete tokome taneya. ");
INSERT INTO wiu_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ku̱ tuameneya kakale enekome kikoa okome okome ku̱ wa tukile toamea. Padameka neke ku̱ wa kotia noamoi wa kikoa akeneya. Eni kikoa okaka one oyali-kitame yakakoa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yesuyo yomo piki kikoa oomotokome one oya-lawe-pala Yerusaleme take pome kapaneya. Nitoa tobo losu yapu pome kakomepa eida-kama eya kuya topo toa kue moa tane yene poe wa wia tikatapea ni e ku take latiane kue topo toa Yudea kue lene ete mea tokoi yene kini walai-kiti moa pekatapea ni ini puluma yoa tane yenane walai-kitika moa pekatapea taneya. ");
INSERT INTO wiu_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Nititikoa kakome okome i tobou losu yapu ludu kini topo toatikiya wa pade aua noameo wa agaleme oa ketekaneya. ");
INSERT INTO wiu_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Nititikoa kakome okome anu i yapupa e ku yatename no Akolali kowitoai toatiki yapu wa oi wa papete wia mekapianeyake kimepa kode yename kodeya paigakoa moa piai tane kota tetepo takakino, poe wa wia tikatapeneya. ");
INSERT INTO wiu_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Yesuyo eni tanemo kugu yatekete eya ali-kitame Akolalike lodo yotokoai tane tobou ali-kitameka Mosesene totono pine to̱a olaukane ali-kitameka one katekoa wia tukatekoi oi pedoa wili tokoa kakeneya. Nipa ali atoa peyame Yesu i agome imopa i okono yakato wa ka̱ okala tokoli tokome one piti motekete taneya. ");
INSERT INTO wiu_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Nitaneyake ta likaka Yesu one oyali-kiti-pala Yerusaleme ta tewitikoa pekeneya. ");
INSERT INTO wiu_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Podolikama likonu witia kamomotekete penekete enekoli eina yomo piki totoa ala tootapeneya kakale enaneya. ");
INSERT INTO wiu_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Nitaneya kakale enekome Pitayopa Yesuyo okana wene patukakale okome Tikisa ago neme abelana kikoa okana yomo piki totoa ala tootapeneya kakono, ena wa okale okome ");
INSERT INTO wiu_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Akolalike-kama wene tugoa meamene. ");
INSERT INTO wiu_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ipa nimini ukuno yakoe. Panagome-kiti poome toameneya kakome one kowitikumo taatekoa too wa wene tugoa mekalepa eya too. I kako tono mati ne wete to̱a poke kusa ue mu kuta poke kapa wado okalepa Akolaliyo yakoa too. ");
INSERT INTO wiu_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Nitoa kowitikete-kama Akolaliyo wete yakoa tane tetepo takoa kowitikala tamene. Nitikolipa oneme etene yakoa too. ");
INSERT INTO wiu_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","One kowitoa kaketepa kini a tibuke meko ataiyo kini poanele-kala toma pokoike po letu mekakana kea wakome kibu moamomotono eya tamene. Panagome-kiti nepala padele poanele tokake po letu mekakanapa keane wakene kibu moamou wa nami ete wiameamene wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yesuyo nimo oomotokome one oyali-kiti-pala Yerusaleme take wakapea nome kananeya. Enipete Yesu losu yapu ludu yawa mekaka Akolalike lodo yotokoai tane tobou ali-kitika Mosesene totono pine to̱a olaukane ali-kitika Kanosolo ali-kitika ");
INSERT INTO wiu_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Yesu eni yakata nekete ekete neke tokolepa te patu kautakoa kake toko-pe. Teyo tamene wa okole toko-pe wa yakanokoli okome ");
INSERT INTO wiu_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","kipalaka yakatekumo pikono, yakoe. Oto wa topo takoa okoli yatekenepa nipa anume toma yakulepa i ago patu kautakoane kakene tuku wane to̱aweane ou. ");
INSERT INTO wiu_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yoneyo ali atoa ue motokama yakilepa tene peku noa toka-pe. Akolaline peku patu. One kaua-mikitane peku patu. Yakouno, oe-na-kale ");
INSERT INTO wiu_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","kini kini yakate tekete ekete edemo wa ato-pe. Enipa Akolaline peku wa totome okolopa nipa Yone einagome oka agale edeyake yakoa moamokoi-pe wa oono, nimo wamato. ");
INSERT INTO wiu_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Nitameneya one kaua-mikitane peku noa toka wado okolopa ete ali atoame toto wia tukatikiyano. Yone einagopa Akolaline agale to̱awea akane ago tadeko wa ikiya tokome nitoino, enimo waka wamato wa ete Yesu-pala ekete ");
INSERT INTO wiu_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","totome wene toamokono, tene peku noa toka patu-koli okome nipa anu toma yakulepa i ago patu kautakoane kakene tuku wane wamou wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesuyo agale pade pedoa okome okome panagome-kiti one ipe tootokoa gerepi po matatapeneya. Nitoa pawe toa unukatekoapa one pupu yename po ku̱ kotia pitikoa kawame kautoa ti̱a lobutatekoi kagono wetia latipianeya. Payaponalime ta enapea yopia meateka ludu yapuka atepea wipianeya. Nitoapa ali pade-mene one ipe yopikamene wa yamemotokome ta tetemada pome mepaneya. ");
INSERT INTO wiu_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Nitaneyake ku̱ putua kibutukakoa kaka-pete pinagome eya taneya. One pupu ago pade moa wetekakome okome anu ipe yopikaki ali-mename no moateku toapa meadete tikino, motokapoano pa wa moa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Nitikale nokale enekete one ipe yopikane ali-mename einago layo tiginime moomoa pitikoa pupuli wia padeyaka meameneya pa pomotoa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Nitaneyake pinagome pade pupu ago moa wetekakale nokale enekete wia wago bulukoa ya motokoa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Nitaneyake pinagome wa pade ago moa wetekakale nokale wia tukaneya. Nitaneyake pinagome one pupu ali-kiti wa moa wetekakala tokale einakale toa padeka-kiti layo toua wia padeka-kiti wia tukakala taneya. ");
INSERT INTO wiu_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Pinagome nitima pome wipitikomepa odene ago katekapitikaneya. Einagopa one kolotini ago. One eni mana agopa kei pia makutukoa moi wa wene pikome einago ne pa wa moa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Wetekakale nokale enekete ipe yopikane yename oote tekete ekete pinagono mana ku nokona. Etename one pikoa pokaya-kiti kadimo okome kunu agono pikademe toko. One moatekoya-kiti toto moatono, wia tukatoe wa ");
INSERT INTO wiu_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","dekoa moa wia tukamotekete gerepi po ipe tayo lono lia aua pitikapaneya. ");
INSERT INTO wiu_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Nitikala taneyake ipe pinagome edoo-pe. Nipa eya too. Wakapea nokome one ipe yopikoa potokane ali-mene wia atukatapea kiwi lukuke pade-mene kime yopikamene wa yameademe toko. ");
INSERT INTO wiu_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Akolaline bokuke agale dikoa wia mekaneya pikono, yakoe. Yapu wiane ali-kitame i yomopa poadeko wa paya tetepo takoa wakeneyake padekagome i yomopa yapu pigi wa moa wianeya. ");
INSERT INTO wiu_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Enilepa Ali Muno Akolaliyo taneya tokome ke wa kolotine mea kei piato wa wia mekapianeya. Eni wia mekanemopa kime oi moamokoiya-pe wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yesuyo eni pedoa okamo yatekete ekete pedoa i agome ina okana agalepa totoke akedekono, i ago dekatapea moatikiyake toko wa kakete eida oboa kakoi ali atoa piti motekete tekete wakeneya. ");
INSERT INTO wiu_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Wa naniko Yesu-pala poi te̱iane yename eya taneya. Parisi ali padeka-kiti ni Erodeke timini kakoa yakene ali padeka-kiti moa wetekakete ekete Yesuyo natemoka omotono, likoa enepoatino poe wa moa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Nitikoli pote lede pitia yatekete ekete Tikisa ago nepa niminimo-kama oko. Nitoapa ibini akene yeneka ponopene yeneka takoa enameke Akolalinele takama pekete toatikile ki̱yoke-kama olaukako. Nepa nitane agono wene tekete imodo pitia yatekono, yakamene. Yu yene tone totono litiapa Lomane yatenane ako tobou ago Sisa one takesi kue pitikamato-pe, pitikato-pe wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Nitikolipa wene takuta pianeya kakete akediki wa wene tokome okome kime nopa edeyake likoa eneki-pe. Kue lene pade enouno, aua noe wa okale ");
INSERT INTO wiu_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","aua note metekoli moa enekome okome i kue lene tiginikepa padane lene timini-pala ibinita wia mekaneyano, eniyatapa teneta patuno, yakouno oe-na-kale ekete tobou ago Sisa one wa okoli okome ");
INSERT INTO wiu_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","ni tadekopa Sisa meatikiya-kiti ni Sisa takoa mea, Akolali meatikiya-kiti ni Akolali takoa mea tamene wa Yesuyo okale yatekete ekee wa one eni okamoke wene kainya pianeya kakeneya. ");
INSERT INTO wiu_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sadusi totono litiane ali padeka-kiti Yesu kakata nikilepa agale palene yakadete nekeneya. Eni yene kini totono piane toa litiapa tuane ali atoa kamoamoi wa iki. ");
INSERT INTO wiu_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Nitane ali-kiti Yesu kakata nekete likoa enekete ekete Tikisago nepala i okomo yakamene. Moseseyo one totono wia mekakome okome panagono atoame mati opikameneyakedo einago tukalepa one wamene ago neme moa neke natono latikamene. Nipa tukanakago lukuke kawatiki mati-kiti opikamotono, nitamene wa Moseseyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Odene aline mana-mikiti tatono kakoa (7) kakeneya. Namolo agome atoa moapa mati opiameneya mea tuaneya. ");
INSERT INTO wiu_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Nitaneyake one liti taku takoa opiane agome einatoa moapa mati opiameneya mea tuaneya. Nitaneyake tebolo takoa opiane agomeka einatoa moa mati opiameneya mea tuaneya. ");
INSERT INTO wiu_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Eni wamene ali tatono kakoame (7) einatoa kibutua moma-kala nekeneyake panagonoka einatoame mati opikameneya. Nipa tiobali mea tukala taneya. Nitikala taneyake wipitikome einatoaka tuaneya. ");
INSERT INTO wiu_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Eni wamene-mikitame einatoa edikoa kibutua moma-kala nekeneyano, tua pokoi ali atoa Akolaliyo moa kamotokaka-pete einakatoapa mani agono natono wa tugoa meoo-pe wa likoa enaneya. ");
INSERT INTO wiu_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Nimo oa likoa enekoli okome kini wini ikimopa Akolaline bokuke piko agale-pala one telekoleta wene toamekete ni iki. Enipa nimini ukutu-pe. ");
INSERT INTO wiu_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Tuane ali atoa kamoa pote a tibuke mea kaketepa alime atoa moamoa atoa alike poamoa toi. Nipa a tibuke Akolaline edelo-kiti keneya meoi. ");
INSERT INTO wiu_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ali atoa tuapa kamoa pote mea kakimopa Moseseyo one bokuke wia mekaneya. Nipa itipono oa kakene yomo deyake Akolaline agale ludu nokome akenemo eya wa wia mekaneya. Noanupa Eberame Aisaketa Yekobe toa einago-menane Akolaliyo uku wa Akolaliyo oka toa wia mekaneya. Eni wia mekanemopa kime oi moamokoiya-pe. ");
INSERT INTO wiu_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Moseseyo enimo wia mekaneyano, onepa tuane ali atoane Akolali mena. Mea kama piki ali atoane Akolaliyo uku wa okome akedeko. Sadusi ali-kiti kime ali atoa tuapa wa kamoa pote mea kawamiki wa ikipa nipa ae Akolalinemo etene agopa motekete iki wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Nitoa agale topo takoa kakoika Mosesene totono pine to̱a olaukane ago pade nome yakakoa kakeneya. Nitoa yatekale Yesuyo eni Sadusi ali-kiti-pala agale muno kakoa oa metekale yatekome okome yonota tua agalepa e tobou kakoa akene agalepa mani-pe wa wa okale okome ");
INSERT INTO wiu_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","tobou kakoa akene agalepa dikoa piko. Iserele yatene anu ukumo yakoe. Tone Ali Muno Akolali wa oateko agopa Ali Muno odene meko. Oneke lokoa dikane ago pade kawamoko. ");
INSERT INTO wiu_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Nitane ago kini Ali Muno Akolalike wedoa wene mekoa tikilepa neke tepe kolotinime toa neke yominime toa neke weneme toa neke teleme toa tamene. ");
INSERT INTO wiu_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Nike lokoa tobou kakoa akenepa dikoa piko. Pinali neeke wa wene mekoa mea mama motoko toapa yete pade ali atoakeka wene mekoa mea mama moamene. Eni agaletamepa keku agale peya moa patukaneya wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Nimo okale einagome okome neme wini okopa nimini eke okono, Akolali wa oateko agopa one odene meko. Ni oneke lokoa dikane ago pade meamoko. ");
INSERT INTO wiu_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Tone Akolalike wene mekoa tikilepa nipa tone tepe kolotinime toa tone weneme toa tone teleme toa tagatapeamedeko. Ni pinali tone wa wene mekoa mea mama motoko toapa yete pade ali atoakeka wedoa wene mekoa mea mama moamedeko. Eni totonota litia teketepa nipa sipi sipi kai eya Akolalike mea lodo yotikina toa moa patukoa epetanele-kama eni tiki wa einagome akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Nitoa wene muno meaneya kakome okale yatekome Yesuyo okome nepa Akolaliyo ali atoa pawe toa talo tokota dekama nekedeko wa Yesuyo akeneya. Yesuyo nimo ootokaneyake padameka agale pade wa pitia yakoaka enameneya. ");
INSERT INTO wiu_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesu tobou losu yapu kakome olaukakome okome Mosesene totono pine to̱a olaukaki ali-kitame Keraisu wa papete ibini oa piane agoke eketepa onepa Depidi-loeke ta̱wateko ago wapa olaukakala tikino, edekolo iki-pe. ");
INSERT INTO wiu_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Depidiyo papete Keraisuke okomepa einagopa one Ali Muno wa akeneya. Eni akenepa Epetane Yominiyo wene takakale Depidiyo eya wa wia mekaneya. Ali Muno Akolaliyo anu Ali Muno ago-pala eya wa akeneya. Nepala poi te̱ia meki-kiti moane kawikoane neke kawane komo pikouno, anu nimini yono lono noke nepia menamene wa Akolaliyo Keraisu-pala akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Depidiyo enimo wia mekakome Keraisu einagopa one lukoane meku Ali Muno wa akeneyake kimepa Keraisupa Depidike ta̱wateko ago wa ikino, edekolo iki-pe wa Yesuyo akeneya. Yesuyo nimo oa kakalepa one kakata iti itita oboa kakoi peyame ke wa yakakoa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Nitimotoa olaukakome okome Mosesene totono pine to̱a olaukaki ali-kitame toma yakile titi toma pamene. Kini ludu mamina epetaneya wititapea kakeneya yawa ni makesike ali atoame ke wa walikitikakete yono momotada wa yawa tiki. ");
INSERT INTO wiu_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Losu yapukeka tobou ali-kiti meatikita meada wa pote mepokala tiki. Toge kikakaka ibini akene yene meatikita meada wa pote mepokala tiki. ");
INSERT INTO wiu_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ni nepo atoa-kiti oa yotokoa kini yapu eya kode moa ni eka ali atoame kiwi kei pimotoa lede kowitikete kutupea pa agale likoa pikala tiki. Ae, dikaki yene Akolaliyo kibu motokomepa dika dika toamene tete meoo wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Wa padepete Yesu tobou losu yapu keneke kue pitikoai tokoi mete liti pome witipitoa mekome enekale ali atoame kue pitikakala tokoli enekoa meaneya. Nitoa enekoa mekaka kamo tane yene peya mati note kue ako mati pitikanokala taneyake ");
INSERT INTO wiu_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ponopeneya meane nepo atoa pade nome dee kue waneta pitikananeya. Eni dee kue waneta koukoapa tuane kue odene latiko. ");
INSERT INTO wiu_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","44","Nitikale enekome Yesuyo one oyali-kiti noe wa kayo oa motokome okome nimini ukuno yakoe. I kamo ali atoa peyamepa kinikiya tubeya pa pimotoa keku-mene odene moa pitikakala tokoi. Nitikoiyake i atoamepa onekeya nateya deyake one piko toa eni moa pitikatapeka. One nee eya topo toa moateka kue peya eni pitikakome tokome e yene peya moa patukaka wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu tobou losu yapu kawa akolono witakaka one oyali padame okome okome i tobou losu yapu-kitipa koniyoya kue epetaneyame koniyo takoa wianeya kakono ena wa wedia kakome okale okome ");
INSERT INTO wiu_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","i tube yapu-kiti wedoa enekamene. Eniya-kiti latiane kue wili walai akatapeneya pioo. Nipa odeneka kibutukoa piameneya peya wia tadekaneya pa tumu tokaneya pioo wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesu tobou losu yapu eka waneke kamotoa Olipe-pini tono waneke pome mepaneya. One kidene eida paka witimoa mekale Pita Yameta Yone Aderuta einago-mene note kakete ekete ");
INSERT INTO wiu_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","neme okanakalepa manipete taatekoa toko patu. Enika enile toateka tigotokalepa edeya wa adeka pipioo-pe-koli okome ");
INSERT INTO wiu_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","6","ina okounakale wete taatekameneyake pade ali-kitame anu ibini lede wedekoa nekete ekete Keraisu taatekoane nukuno, noe wa ali atoa peya mati oa yotokoino, wedoa lene kia nepikoa meamene. ");
INSERT INTO wiu_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Nitoa nepikoa mekoi-petepa kini ta ludu u̱u wa poi toa kakoimo yakoa ni pade take poi tago wa okoimo kugu yakoa toino, piti moameamene wane uku. Enilepa taatekoa namolo takoa toatekoyake wipitia ta pade tigotokoa wete patamoo tokolo ni uku. ");
INSERT INTO wiu_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ni e ku yatename poi tato wa kamoa poi te̱itakutukakala toi. Ni e ku tobou ali-kitike lukoa mekoi yatene ete oto wa poi toa winali yoi. Eka kuka takeka momani mati toa kobu igi-pala nokala too. Enika enilepa atoame mati opiademe namolo takoa mukiti nako toa keneya too. ");
INSERT INTO wiu_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Pade ali-kitame kiwi koiso akou wa Kanosolo ali-kiti koukoa mekoika lia aua pokala toi. Wa pade ali-kitame kiwi wiou wa kini losu yapukeka layo toua wieino, lene kia nepikoa meamene. Ni ako odene tobou mekoi ali-kiti mekoika ni kiwike lokoa ta yopia mekoi-kiti mekoika lia aua pote koiso akakala toi. Nitikolipa kini lene yoto kakete anukumo to̱awea akakala toi. ");
INSERT INTO wiu_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Nipa wipitia ta wete patameneyake namolo takoa e ku yatene pitikoi toa anukumo oa pupitikatapeoi. ");
INSERT INTO wiu_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Kini eni koisoke lia aua pokoika edemo uku patu wa tepene li̱ li̱ wa kamotoa meameamene. Enipetepa Akolaliyo wene takaka toa okala toi. Nipa pademo pademo ikilepa kini weneme titia pade wamoi. Epetane Yomini kiwike awinokome a wa oka toa okala toi. ");
INSERT INTO wiu_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Enipetepa wamenagome-kiti wamene wia tukamotoa moa meoo. Etename-kiti one matika wimotoa moa meoo. Wa mana kono-mikitame kini etene nineka wia tukamotoa moa mekala toi. ");
INSERT INTO wiu_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Anu oya-lawe kiwi no-pala odene ibini pedane yene tokale tekete ete yene peya kipala kotimi yoa meoi. Enika eni ke enekakale meake nooke wene tugoa mea togakoi-kitipa Akolaliyo toa moo wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Kitau oko wa okoiya one kawamatekata moa kakaneya enoino nepio wa Yesuyo pubu oa pianeya. (I boku wiane mekaku agome eya wane uku. Ina wiane mekakumopa oi moteketepa pine to̱a wene taneya meati wane uku.) Yesuyo eni oa pianele taatekoa tokale eneketepa eya tamene. Yudea take mekoi-kiti tono pake pake to̱a pitoa pote paigakoa mepamene. ");
INSERT INTO wiu_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Yapu liti koo meapa kini yapu pikoina mopameneya pa pitoa pamene. ");
INSERT INTO wiu_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ipe-kiti toa kawapa tigini mamina kotokoa pikoina mopameneya pa pitoa pamene. ");
INSERT INTO wiu_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ae, mati kakene atoa-kitika mati adu tanikakoa mekoi atoa-kitika tete eni witakale manika edoa petoa pomotoa-pe. ");
INSERT INTO wiu_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Eni tetepa kalapetaka witamomotoa ta wa Akolali kowitima pamene. ");
INSERT INTO wiu_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Eni tete mati witakilepa itono tibuta latitikaneyakeka toamokale-kiti too. Eni tete witatekaneyake naniko pade edikanele wa witamoo. ");
INSERT INTO wiu_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Akolaliyo eni tete witama pomotoa yopikoa kaka pakedo teigamoo tokapa ali atoa peya atuoi toka. Nitoi tokake one wa takoa motoka ali atoa ela motokome tokome pegene kakoa teigoo. ");
INSERT INTO wiu_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Enipetepa pade ali-kiti nekete ekete Keraisu ku nokono enoe, i nokono enoe wado okolipa yakameamene. ");
INSERT INTO wiu_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kapene yename eya wa wini oi. Keraisu nuku wa oa Akolaline agale akama nuku wa oa toi. Nitoa kiwi oa yotokadetepa padele padele telekole tokala toi. Nipa Akolaliyo takoa motane ali atoaka tolopi toa paka aua poadete wili toa kakete oyake nitamele toamokale wakala toi. ");
INSERT INTO wiu_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Nitoino, enika enile wete taatekameneyake papete i agale eni wene takapikuna. Lene kia wedoa nepikoa meamene. ");
INSERT INTO wiu_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Enika eni tete witoa kawa peya tokale taatekoa eya too. Lou yomiyomu takoa tokene-kitika pa̱ toamoa too. ");
INSERT INTO wiu_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","A tibukeka tagoi-kiti kotia pitoa too. Ni tele taneya tibuke mekoiya peya moa peteka peteka taneya tokome ete oto wa yawa kawei, ");
INSERT INTO wiu_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Nitoa kawa wipitikale enekoli nopa Ali Yatenane Oyago wedo patu meane pa̱ teleta toawineya noadene nokolu enoi. ");
INSERT INTO wiu_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Nitaneya wakapeane nekenepa lou witia noko lonoka lou pipoko lonoka yeteka yukukataka anu papete takoane moopikou-kiti peya odeneya moa obokamotoane tekene edelo ali-kiti moane wetekou. ");
INSERT INTO wiu_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Yomo piki witakole wene taneya meamene. Papete yeneneke page ka̱ua luno pitikakolo eneketepa poto toko tokene-mene tigotatekolo toko wa wene toi. ");
INSERT INTO wiu_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Eina toa anume okounakale-kiti witatapekale eneketepa inakago wakapea noateko eni tigotokona wa wene toi. ");
INSERT INTO wiu_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Etene nimini toatekomo ukuno yakoe. Ipete meki-kiti peya wete tuutapeameneyake kipala ina okounakale-kama taatekoa too. ");
INSERT INTO wiu_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Itono tibuta takoa pootapekolika anu agalepa pa pia-kama kawoo wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Enika enile toatekolepa ipete taatekoa too wa padameka wene toamiki. A tibuke meki edelo ali-kitameka wene toamiki. Akolaline mana noanumeka wene toamuku. Atai Akolaliyo odene wene toko. ");
INSERT INTO wiu_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Enika enile toateko-pete agopa tokolo mekino, wedoa lene kia nepikoa-kama meamene. ");
INSERT INTO wiu_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Kipala ina okouna toane opika pedoane agale ukuno, yakoe. Panago ta tetemada poademe one yapu kakome eya toko. One pupu takaki ali-mene pupu tutu tutu wa takamotoa tatikamu toko. Nitoapa kagoke payaponali kako agoka wedoa nepikamene wa kakamotokome poko. ");
INSERT INTO wiu_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Yapu pinago kotikatapea wakapea noademe tokono, payaponali kako ago toko toa wedoa lene kia nepikamene. Piadete mekika noko patu. Tube likonu noko patu. Titia ogada ka̱ oko-pete noko patu. Likonu kama witia noko patu. ");
INSERT INTO wiu_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Atu pia mekakoa kotikatapea nokayano, wedoa nepikoa kamene. ");
INSERT INTO wiu_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Kipala i ukumopa ali atoa peya-pala kikilikoane ukuno, wedoa lene kia nepikamene wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Yu yenamepa kini kaua-mikiti Idipi take mekakoa edelo ago patukoa wia tukamenele oi pikoa meketepa malike-kama toge kima nekeneya. Eni toge kia mono mono akamene palawe wane-kiti yoa noatekoi oi tigotokoa nekeneya. Eni toatekoi ta takupeta pa ete pikale Akolalike lodo yotokoai tane tobou ali-kitameka Mosesene totono pine to̱a olaukane ali-kitameka Yesu wiadete edoa yotokoa dekoa moato patu wa wili tokoa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Nitikete ekete toge kikoo-petepa dekoa moamato. Pa ali atoame toto-pala wene poa wili walai wa kaweino, enipete dekoa moamato wa oa tukaneya. ");
INSERT INTO wiu_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Wa pade-pete Yesu Besani take kedime nakeneya mekanakago Saimone einagono yapu meaneya. Eida mekome nee nakaka atoa padame padeya ka̱lono taneya alabase kueme latiane mete keneke mekoa aua nekeneya. Eniyapa nado wa ibini akeneya. Kue ako mati wetekoa mootokoa aua nome mete ka̱utukoa ka̱lono taneya Yesuno wagoke pekoa yotokatapeneya. ");
INSERT INTO wiu_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Nitikale enekete pade kakoi-kiti wene poaneya kakete oote tekete ekete ina pekoa yotokakilepa pale tokano, edeya weike toka-pe. ");
INSERT INTO wiu_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Inakeyapa totome topo toa kue moo tokapa nipa kina kue ege kadukaka ko melepume kakoa (300) moa ponopene ali atoa tatikoo toka wa einatoa-pala poanemo oa kakoli ");
INSERT INTO wiu_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","yatekome Yesuyo okome i atoane wene dekolo potokaki-pe. Oyakeno, wawe. Einapa anu koniyole takakana. ");
INSERT INTO wiu_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ponopene ali atoa enabuna kiwi pakeke mekala tikino, kini wene witikolo-kama oyake auapeamele toko. Noanupa kiwi pakeke pa tekei meku. ");
INSERT INTO wiu_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","I atoame nopala padele epetekoa toatekale eni tokona. Ina ka̱lono taneya anu tiginike pekoa yotokakanapa no tuaneya piateku tigotokolo tokome nina nodokoa takapikana. ");
INSERT INTO wiu_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nitikakona tokolo eya wane uku. Anukumo ta piko peyake oa aua yakoi-kitame oa pupitikama peketepa i atoame ina takakamo-kitika oa pupitikoi. Nipa ta piko peyake mekoi-kitame one wene taneya memotoa nitoi wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Nititikaneyake Yesuno tuku kakoa (12) oyali-kiti panago Yudase Isekariose einagome eya taneya. Akolalike lodo yotokoai tane tobou ali-kiti mekoita pokome okome Yesu einago kini yonoke moane piou wa opaneya. ");
INSERT INTO wiu_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Nimo okale yatekete wedia mekete ekete nipa ne kue meoono, nitoa ta wa okoli einapete laigoa Yesu moa metekome toatekale wene kibutuma yakeneya. ");
INSERT INTO wiu_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Yu yename mono mono akamene pa palawe wane-kiti yoa toge kikilepa namolo ta pataka-pete eina togeke wia kiatekoi sipi sipi kai tine-pala moa wia kikala taneya. Enile toatekoi-petepa Yesuno oyali-kiti Yesuke nekete ekete edelo ago patukane wa ibini oko toge nee maida nodokoa piatoa-pe wa okoli okome ");
INSERT INTO wiu_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Yerusaleme pekete enekoli ali pade one wagoke ue mete kakalogoa aua nome kotukale enoino, einago litima pamene. ");
INSERT INTO wiu_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Litia peketepa one tuapea poka yapu pinago-pala eya wa akamene. Tikisa agome i toge kia noatekoyapa one oya-lawe-pala opiane mekene nouno, neke ugu yene note meatiki lono yamea ta wa akamene. ");
INSERT INTO wiu_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Nimo okoli yatekome pinagome ako yuane yapu yametekome toto meateko walai-kiti-pala nodokapianeya yameoono, eida pote kakete tone toge kia noatekoya nodokamene. Nodokapoatino poe wa Yesuyo one oyali takuta takoa moa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Nitikale Yerusaleme take pekete enekoli Yesuyo eina okanakale nimini tadeka. Nitadekale einata kini toge kia noatekoiya nodokaneya. ");
INSERT INTO wiu_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Nititikaneyake ta likaka Yesu one ete oya-kiti-pala eida nome menaneya. ");
INSERT INTO wiu_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Nitoapa eina nee noa mekete Yesuyo okome etene nimini ukuno yakamene. Anu oya-lawe nopala opia mekete nee naki-kiti kiwi padame no-pala poi te̱iane yenane yonoke moa pioo wa okale ");
INSERT INTO wiu_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","odene odene wa mekoi peyame Yesu ete yatekete ekete Ali Muno wini okolepa noanume toatekumo eke oko-pe wa wene keda toologaneya mekete yakakala tokoli okome ");
INSERT INTO wiu_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","anu tuku kakoa (12) oya-lawe kiwi panago no-pala opia mekome odene okolo kagonoke nee moa tadoata nako agopa no moa meatekago too. ");
INSERT INTO wiu_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Nipa Akolaline bokuke Ali Yatenane Oyago nopala eni toatekamo papete wia mekapiane toane taatekoane tuou. Ae, no witikamotoa moa meateko agomepa dika dika toamene tete moono, eni tete moamademe tokome einago opiameneya too tokapa nipa epetoo tokake opa ae wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Eni nee noa mekete Yesuyo palawe wane moa Akolali-pala ke wa popimotokome tatikamu tokome okome ipa anu tiginino, moa namene wa moa lawetaneya. ");
INSERT INTO wiu_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Nititikoa gerepi po ku̱ ueka meteke mekaneya katekamoa Akolali-pala ke wa oa one oyali-kiti metekale peyame moa yumoa nakeneya. ");
INSERT INTO wiu_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nitikoli okome Akolaliyo ali atoame wenele toatekoi totono oi pedoa pikana toane kadimo oane piku. Ipa anu kamate. Ali atoa peya matike tukene anu kamate ponomotou. ");
INSERT INTO wiu_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Kipala imopa etene nimini ukuno yakoe. Akolaliyo talo toko take kipala opiane mekene gerepi po ku̱ ue weneya wa moane nou. Nitatekuyake papete pade wa nakileka toamou wa oa ");
INSERT INTO wiu_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","peya takakome eni ketea lo pade oomoteketepa Olipe-pini tono waneke pote witapaneya. ");
INSERT INTO wiu_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesuyo Olipe-pini tonoke pome mekome okome kiwi peyame no wawa tia tadatapeoi. Nipa Akolaline bokuke nopala toatekoileke panagome papete eya wa wia mekapiane toa taatekoa nitoi. Akolali noanume sipi sipi kai-kiti talo toko ago witikolu one sipi sipi kai tadoa pootapeoi wa wia mekaneya. ");
INSERT INTO wiu_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Eina wia mekapiane toane taatekoane tukoluka Akolaliyo moa kamotokoo. Nitikale kamoane kiwi naniko nomotoane no namolo takoane Galili take pone mepou wa okale ");
INSERT INTO wiu_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pitayo okome i ali peyame ne tia tadatapekolika noanume ne tiane padeka poamou-kale okome ");
INSERT INTO wiu_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","nepala i ukumodo yakamene. Opi likonu ali ogadame ka̱ takupeta wete wameneyake neme no i ago wene toamuku wa tebolo-peta akoa wawade toko-kale okome ");
INSERT INTO wiu_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","ne witikete nopala dekoa witikolika ne einago wene toamuku wane wawamou wa Pitayo okale ete peyameka oneme eina okana toa okala taneya. ");
INSERT INTO wiu_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Nimo okoli Yesuyo patoe wa Gesemani take pome mepaneya. Nitoa mekome Yesuyo one oyali-kiti-pala okome no yeka tutu pone kakene kowitipukuno, ita meamene wa ootokoapa ");
INSERT INTO wiu_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Yame Yoneta Pita toa aua pokome ela matiyame tuaneya tepene-pala mama mati motaneya pekeneya. ");
INSERT INTO wiu_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Nitaneya kakome okome no wene keda mati tokolo tuadene meku. Mugili-pala topelekono, ita nepikoa meamene wa oomotokome ");
INSERT INTO wiu_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","nami-takakoa eko keneya kidene pome itonoke aua pitalogoa kowitaneya. Nipa onepala toatekale katekakamotoa kowitaneya. ");
INSERT INTO wiu_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Nitoa kowitikome okome Atai padele padele peya neme tamele toko. Meteke no noateku ue enekupa no tete moatekulu enipa tokono, ete pedekakamene. Nimo wane kowitikuyake anu wene pikule toa wane ekene wamuku. Neke wene pikole tou wa kowitimotokome ");
INSERT INTO wiu_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","one oyali-mene mekoita wakapea nokome enekale atu pia meadekoi. Nitadekoli Pita yatekome okome atu pia meko-pe. Pa nateya opia me me teke nepikamele toamoko-pe. ");
INSERT INTO wiu_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Setanuyo kiwi likoa enekoyano, wedoa lene kia mekete kowitamene. Lene kiane nepiane meou wa wene pikiyake tiginipa popeyo noamokolo atu wini pia meadiki wa Yesuyo oomotokome ");
INSERT INTO wiu_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","kutu keneya wa pome kowitikome one namolona okana toa lokoa kowitaneya. ");
INSERT INTO wiu_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Nitoa kowitimotokome wa wakapea nokome enekale pa atu pia meadekoi. Atume moa ma̱leou takakale pitaneya. Nitoa atu kiyo kiyo kamokakete one-pala oatekoi agopa tokale meaneya. ");
INSERT INTO wiu_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Nitaneyake eina toa pome mea tebolo takoa wakapea nokome enekome okome kiwi pa koome tuaneya mekete atu-kala pia meki-pe. Opi oyakeno. No Ali Yatenane Oyagopa Akolaline agale tagoa toamiki yename witikamotoa moa meateko ago ku nokono, ");
INSERT INTO wiu_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","wete kamokoa kawe. Kotua pekete pato wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesuyo enimo oa kakaka one tuku kakoa (12) oya ali-kiti pade Yudase wete eni nekeneya. Nokale ali peya mati koukoa kepete tue layo katekamo katekamo toa obomoa nekeneya. Nipa eya ali-kiti Akolalike lodo yotokoai tane tobou ali-kiti ni Mosesene totono pine to̱a olaukane ali-kiti ni ete tobou ali-kiti enika eni ali peyame Yesu dekoa motokapoatino poe wa wetekakoli nekeneya. ");
INSERT INTO wiu_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","45","Wetekakoli neketepa Yudase Yesu kakata wete nome awa, Tikisago wa ootokoa Yesu nunu akeneya. Enipa papete Yesu dekoa monatekoi yene-pala oi pedoa pikana toa nitaneya. Nipa one pone nunu opokou agopa Yesu eni toono, dekatapea moa tapu toa aua pamene wa oi pedoa pikana toa taneya. ");
INSERT INTO wiu_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Nitikale Yudase-pala opia nekene ali-kitame Yesu dekoa monaneya. ");
INSERT INTO wiu_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Nitikoli one kakaya liti kakene oyago padame panago wiou wa one kepete tue witimoapa panagono kapidi pine takoa pitikaneya. Einakagopa ako odene mekome Akolalike lodo yotokoai tane tobou agono pupu ago. ");
INSERT INTO wiu_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Nitaneyake Yesuyo e yene-pala okome kini kepete tue lua note layo tigini-pala nidikoa aua nikino, kode ago tetepo takakete no dekoa moadete niki-pe. ");
INSERT INTO wiu_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ta pataka abuna tobou losu yapuke kiwi kakakoane keleyo pone olaukoane kakounake no eida dekoa moamokoina. Dekale wakoti-pe. Akolaline bokuke nooke papete wia mekapianele taatekoa toono, toe wa okale ");
INSERT INTO wiu_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","one oya-lawe peyame one tia wawa pitoa pootapeneya. ");
INSERT INTO wiu_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Nitikoli tuali pade odene pue petene ewetetapea kakeneya Yesu aua pokoika litima pekeneya. Nitikale pade-kitame dekatapekoli ");
INSERT INTO wiu_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","one pue laukalogakome pa pitoa pekeneya. ");
INSERT INTO wiu_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","E yename Yesu dekoa moomoteketepa ako odene mekome Akolalike lodo yotokoai tane tobou agono yapu aua pekeneya. Einagono yapupa eya ali-kiti Akolalike lodo yotokoai tane tobou ali-kiti ni Kanosolo ali-kiti ni Mosesene totono pine to̱a olaukane ali-kiti eida wete ponete koukoa meponaneya. ");
INSERT INTO wiu_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Yesu einagono yapuke aua pokoli Pita kutu mati kawatati toma nome tobou agono kela pawe patukoa one pupu takane yene pakeke nome menaneya. Nome mekome yono toe yame yame toa meaneya. ");
INSERT INTO wiu_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Nitikakoa Akolalike lodo yotokoai tane tobou ali-kitameka ete Kanosolo ali peyameka Yesu wia tukatekoile wili toa kawa tuku taneyake one koiso akoa wia tukatekoile pade toameneya. ");
INSERT INTO wiu_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Nipa ali kainya matiyame dika dika wa kapene wakakete eketeke odenemo wameneya. ");
INSERT INTO wiu_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Nitaneyake pade ali-kiti kamokoa kakete kapene wakakete ekete ");
INSERT INTO wiu_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","i agome eya wa okale yatekoo. I kako tobou losu yapu alime wianeya ke̱aweane tadekatapeou. Wa ta tebolo-peta lia patakale eni pana-mene moomoane alime yono petekoa wiamene yapu awitikakoane wa wiou wa oka wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Nimo waka eketeke padame pade oa padame pade oa odene kotu kakameneya. ");
INSERT INTO wiu_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Nitikoli ako tobou meane ago kamokoa e yenane lene yoto kakome Yesu pitia yatekome okome neme okale yatekoinakamo eni akoa ikino, neme pademo topo takoa enike oo-pe wa okale ");
INSERT INTO wiu_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Yesuyo agale wametekoa pa kakeneya. Nitikale ako tobou meane agome wa pitia yatekome okome nepa Keraisu toto Yu yatename kei-kama piateko ago Akolaline mana-pe-kale okome ");
INSERT INTO wiu_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","e̱eno, nopa einago. Ni naniko Ali Yatenane Oyago nopa telekole-kama toko ago Akolaline nimini yono lono kawane tibu wedo patu meane wakapeane nokolu enoi wa okale ");
INSERT INTO wiu_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","ako tobou ago pinali one kakene mamina ti̱awea iyatapekome okome okome oyakeno, i agome tane poanele i i wa to̱awea omotoa wa pade ali-kiti totome wa tuku toa moa kakateko toa mena. ");
INSERT INTO wiu_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","I agome Akolali taumada toa okale kime yatekoinano, edele tato-pe-kale peyame ekete i ago wia tukamedekona wa ootapeneya. ");
INSERT INTO wiu_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Nititikoa pade-kitame Yesuke tekelipu toa yotokoa one leneta yoname ketekakoa kawa yumili mutua pia witikete ekete nepa teyo witikato-pe wa tea agale akeneya. Nitoapa i ago moe wa tobou agono poyo ali-kiti metekoli motekete kala wikala taneya. ");
INSERT INTO wiu_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","E yename ako yapu nitoa kamotoa Pita akolono tobou agono yapu pomale pa eida meaneya. Eidapa tobou agono pupu takane atoa pade nokome enekale ");
INSERT INTO wiu_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pitayo one yono toe yame yame toa mekale enekome okome neka i Nasarese Yesu-pala opia yake toka-kale okome ");
INSERT INTO wiu_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","mena, neke wini oko agale yakamekene wene toamuku wa oomotokome kago keteponoke pome kapaneya. ");
INSERT INTO wiu_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Pome kapokale eina pupu takane atoa wa nokome Pita enekome eniya liti kakoi yene-pala okome i agoka Yesuno oyali tadeko wa okale ");
INSERT INTO wiu_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","eina toa Pitayo okome no pade one oyago mena wa akeneya. Wa naniko keneya eniya liti kakoi-kitame Pita-pala ekete nepa Galili take agono, Yesuno oya-lawe-pala opia yakago tadeko wa okoli okome ");
INSERT INTO wiu_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","kapene wakadekolupa Akolaliyo no kibu momotouno, Akolaliyo yakakoane etene nimini ukuno, kini wini iki agopa wene toamuku wa oa kakaka ");
INSERT INTO wiu_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","eina eina taku takoa ali ogadame ka̱ oa kakeneya. Nitikalepa Yesuyo eya wa okana ali ogadame taku takoa ka̱ wete wamokaka no i ago wene toamuku wa neme no tebolo-peta akoa wawade toko wa Yesuyo okana one wene ponokale akolono pome komo ka̱ta pitikoa kapaneya. ");
INSERT INTO wiu_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Podolikama ta pene patakaka Akolalike lodo yotokoai tane tobou ali-kitika Kanosolo ali-kitika Mosesene totono pine to̱a olaukane ali-kitika eni yene peyame Yesu wia tukatekoi oi pedoa pia meaneya. Nititikoa one yonoke po kakamotekete Pailase mekata koiso akakamotoa aua pote kakapaneya. ");
INSERT INTO wiu_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Nitikoli Pailaseyo Yesu yatekome okome nepa Yu yene peya lukoa meki ako tobou ago-pe-kale okome nopa einago wa wini okana wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Nitaneyake Akolalike lodo yotokoai tane tobou ali-kitame Yesu i agome dika dika wa akoa okala tokoli ");
INSERT INTO wiu_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pailaseyo Yesu wa yatekome okome opa nipa padele padelepa neme tanemo-kala akoa ikino, neke yakoa edemo oo-pe-kale ");
INSERT INTO wiu_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Yesuyo agale wametekoa pa kakale Pailase wene kainya pia kakeneya. ");
INSERT INTO wiu_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Edelo ago patukane wa ibini akene toge oi ponokale-kama Pailaseyo eya tokala taneya. Yu yenamepa po yapu pitane ago pade po kotokoa one yapu wetekaka wa takoa okoi agopa moa wetekakala taneya. ");
INSERT INTO wiu_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Eina toge kiane-pete Yu ali-kiti po yapu moa pitikaneya meanepa Lomane yene-pala poi kamotokoa pade ali atoa witaneyake ni moa pitikaneya meaneya. Nitane ago pade Barabasi po yapu eida moa pitikaneya. ");
INSERT INTO wiu_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Yu yene Pailase mekata obomoa note kakete ekete eina tokala tokana toa opika nitoa ta wa koukoa note onaneya. ");
INSERT INTO wiu_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Nitikoli okome Yu yene kiwi peya lukoa meki ago po kotokoane wetekakamotoa iki-pe wa yakaneya. ");
INSERT INTO wiu_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Nipa e yename Yesu aua nikilepa pa puputua wene pokete ni tokoi wa wene tokome akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Nitaneyake Akolalike lodo yotokoai tane tobou ali-kitamepa eida oboa kakene ali atoa oa kamotokakete ekete Pailase-pala eya wa atoe. Barabasi einago po kotokoa wetekaka wa atoe wa oa kamotokaneya. ");
INSERT INTO wiu_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Nimo wa kayo okala tokoli Pailaseyo okome kiwi Yu yene peya lukoa meki agopa edekamene wa iki-pe wa okale ");
INSERT INTO wiu_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","winago yomo lekaneyake wia dekakamotono ta wa kayo oa kakoli okome ");
INSERT INTO wiu_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","one poanele edele taneyake iki-pe-kale agale telo oa kamotokoa kakete ekete winago yomo lekaneyake wia dekakamotono ta wa awitikoa tika tika taneya. ");
INSERT INTO wiu_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Nitikoli Pailaseyo e yenane wene epetekademe tokome Barabasi moa po kotokoa wetekakaneya. Nititikoapa Yesu po wapime wiamene wa one poyo yene moa metekale witikoli yomo lekaneyake wia dekakoatino toe wa nitatekoi poyo yene moa metaneya. ");
INSERT INTO wiu_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Nitikale poyo yename Yesu moomotekete tobou ago Pailaseyo ta talo tokome meka yapuke aua pote kakapaneya. Nitoapa ete poyo ali peya koukoa mootokoa eya taneya. ");
INSERT INTO wiu_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Kikome kiane mamina petene pade moa kakaneya. Nititikoa kagani kakene po ludu moa makatikoa one wagoke lobutukaneya. ");
INSERT INTO wiu_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Nitoa lobutukakoa yono wia pitikakete ekete Yu yene lukoa meki Ali Muno ne mea kamene-ye wa taumada toa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Nitoapa tauwe wata wakoa moa one tobou wane wia oneke tekelipu toa yotokakala taneya. ");
INSERT INTO wiu_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Edikoa paya tobou ago tetepo takatekoapa one tokoo kakakoina mamina petene kotokoa one namolo kakene mamina petene wa moa kakamotekete yomo lekaneyake wia dekadete aua pekeneya. ");
INSERT INTO wiu_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Yesu-pala eni aua pokoika Sairini take ago Saimone tayo lono kawa nokome kotukale enekete ekete i ago wia dekateko yomopa neme aukoano noo wa dekoa moa aukaneya. Saimone einagopa wamenata Alekesada Rupusitane etene. ");
INSERT INTO wiu_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Nitoa aua pekete Gologosa wa ibini akene take witapaneya. Gologosa tone agaleke eketepa ali wago wa ekete oo. ");
INSERT INTO wiu_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Nitaneta Yesu-pala aua pote witakete gerepi po ku̱ ue-pala mire yobotonota eletekoa lawetekoli noamademe wakeneya. ");
INSERT INTO wiu_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Nitikale yomo lekaneyake wia dekatekoa kakete ekete one kakene mamina-mene tatiato wa poyo ali-mename tadu tootokoa tatite taneya. ");
INSERT INTO wiu_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Einata einapete lou pini pogi kakoake (9 kilokoke) Yesu wia dekaloganeya. ");
INSERT INTO wiu_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","One eni wia dekalogane yomo munokepa pipia eya wa wia mekatekoa dekaloganeya. I agopa Yu yene lukoa meki tobou ago. Nipa one koiso akoa akenemo eni wia mekatekoa dekaloganeya. ");
INSERT INTO wiu_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Yesu eni wia dekaketepa kode agota takuta eka okata yomo padetake wia dekakala taneya. Nipa panago Yesuno nimini yono lono wia dekoa padena ago one ewa yono lono wia dekoa taneya. ");
INSERT INTO wiu_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","29","Nititikaneyake eida ponokoi-kitame tedu metekete ekete beita, nepa tone tobou losu yapu odepeta ke̱atapeanepa wa ta tebolo lia patakale eni luku wa wiou wa okanakagono, ");
INSERT INTO wiu_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","pinali neke toa moano, yomo lekaneya ludu ketipea ko̱a noo-na wa tema ponokala taneya. ");
INSERT INTO wiu_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Eina toa Akolalike lodo yotokoai tane tobou ali-kitameka Mosesene totono pine to̱a olaukane ali-kitameka dikoa tedu mea oote tekete ekete i agome ete pade ali atoa toa motokoyake pinali one pade wa toa moamele toamoko. ");
INSERT INTO wiu_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Beita, Keraisu Iserele yene lukoa meki tobou ago one wia dekane yomo ludu ko̱a nokale eneketepa i agopa Keraisu tadeko wa totome wene too wa tea agale okala taneya. Yesu-pala odeneka wia dekane kode agotameka edikoa tea agale okala taneya. ");
INSERT INTO wiu_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Lou mataike ponome kakaka (lou pini 12 kilokoke) ta peya likatapeneya. Lou pene webokaka (lou pini 3 kilokoke) pa ta likoa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Einapete lou pene webokaka (lou pini 3 kilokoke) Yesuyo telo kayo okome okome Eloi Eloi lama sabakani wa kayo akeneya. Enipa anu Akolali anu Akolali neme no dekolo tewitikoa wako-pe wa tone agaleke ekete oko. ");
INSERT INTO wiu_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Nimo okale yatekete eniya liti kakoi-kitame ekete enipa Ilaida kayo okome toko wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Nitoa yakatekoa panagome okome ue nodome tukome ni oko wa teyapea pome ue takamoateka obi wane pade mopaneya. Mootokoapa kou tane gerepi po ku̱ uele tadamoa tauwe wata munoke togototokoa aua nome kakome mitumoa na wa kabunuke pia lete lete tokome okome Ilaidayo i ago kiitapea monoko patuno, tokale enato wa nepikoa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Nitoa nepikoa kakoli Yesu telo ootapekomepa tukome tuaneya. ");
INSERT INTO wiu_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","One tukakapa eina eina kuna tobou losu yapu keneke eya mamina petene Akolali meko lono wa akene yapu luku olege toa ketekalogane mamina petenepa ete oto wa iyawea tukaketikaneya. ");
INSERT INTO wiu_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Nika Yesu lene timini takoa piane lono kakene tobou poyo agome Yesu tukome tokale enekome okome ae i agopa nimini Akolaline mana tadeko wa enekoa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Pade atoa-kitika eka mati kakete enekoa kakeneya. Eni kakoi atoa-kiti pakeke eya atoa-mene kakeneya. Pade Magadala Maria. Ni padena Maria onepa Yame Yosepetane nine. Pade atoa one ibinipa Salomi. ");
INSERT INTO wiu_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Einatoa-menepa Yesu Galili ta ludu pima yakaka one auapema yakeneya. Yerusaleme take Yesu-pala opia note kanane atoa-kitika eida nepikoa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Ta likaka ibini akene Kanosolo ago Arimasia take ago Yosepe Pailase mekata pekeneya. Einagomepa Akolaliyo ali atoa keleyo talo toatekale nepia meaneya. Ni agopa podolikama ko mea pupu toamateka-pete tokale tokome Pailase mekata atiki toa pokome Yesuno tigini moane pipouno, mea ta wa opaneya. ");
INSERT INTO wiu_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Nimo Yesu wete tuameneyake oko wa Pailaseyo wene pikome one tobou poyo ago ne noo wa kayo oa motokome okome Yesu winakago tukome tuka-pe-kale okome ");
INSERT INTO wiu_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","wete tukome tuka wa okale okome nipa mopoano pa wa Yosepe yametaneya. ");
INSERT INTO wiu_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Nitikale pome mootokoapa ake tane mamina petene moa tatilogoa Yesuno tigini pia ewetetapeneya. Nitimotokome aua pomepa pala padaneta kokapiane kota keneke pipaneya. Nitaneta Yesuno tigini piitikoa kue makai uoya koketekoa moa kabunu ketekalogoa pekeneya. ");
INSERT INTO wiu_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Yesu eni moa pipokata eya atoatame Magadala Maria Yosesene nine Mariatame enaneya. ");
INSERT INTO wiu_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Yu yene kini eina ko mea pupu toamatekoi-pete ponotekeneyake lou pipokaka eya atoa-mene Magadala Maria Yamene nine Mariata Salomi toa Yesuno tiginike pekoa yotokoa ka̱lono takatekoiya topo toa motokapianeya. ");
INSERT INTO wiu_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Nitaneyake podolikama egeme ta tu̱ei teigaka kamomoteketepa Yesuno tigini moa pipane kotake pekeneya. ");
INSERT INTO wiu_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Poadete pekete kini-mene oote tekete ekete eina ketekalogane kue teyo ete koketekoa moa pikako patu wa oma pekeneya. ");
INSERT INTO wiu_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Nitoa pekete enekoli paka koketekaneya kakale enaneya. Eina kota kabunu ketekalogane kuepa yau petene makai wane uoya. ");
INSERT INTO wiu_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Yesuno tigini pipane kota keneke eida tuapea pekete enekoli tuali pade ake tane mamina kakeneya nimini yono lono mekale enekete ekee wa piti tokale kakeneya. ");
INSERT INTO wiu_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Nitikoli einagome okome piti moameo. Eina wia dekakoina Nasarese Yesu kime tuku tonadikiyake inakago ita piamokono, wete kamokoa poka. One pianeta luku ino enoe wa yametaneya. ");
INSERT INTO wiu_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Nitikome okome Yesuno oyali-kitika Pitaka yakamotono imo wa akapamene. Inakago wete kamoa poka. Kiwi Galili take naniko nomotoa one namolo takoa pokono, eni take penekete enoi. Yesuyo kipala namolo okana toa Galili take peketepa enoino, poatino poe wa akapamene wa edelo agome einatoa-mene-pala akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Nimo okale eina kota keneke kawa akolono pitoa pekeneya. Kolu kolume tua wene-pala kainya pianeya tokome taneya. Nitoa piti tokale tekete pade ali atoa eneketeka to̱awea wametekaneya. ");
INSERT INTO wiu_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Egeme ta pataka-pete lou witia nokaka Yesu kamoa pekeneya. Kamoa pokome one lene timini Magadala Maria namolo takoa yametaneya. Namolopa einatoake tatono kakoa (7) ipono awitaneyake Yesuyo takoa wetekakaneya. ");
INSERT INTO wiu_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Einatoame Yesu enemotokomepa one-pala opia yakene ali-kiti komo oa tumai mekoita pome opaneya. ");
INSERT INTO wiu_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Yesu kamokoa yakole enoane nuku wa eni opokaleka nimini okono wene piamekete pa tumai meaneya. ");
INSERT INTO wiu_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Wa padepete ali takuta padeka lono kebono takoa piane take poadete pokoli Yesu padele tootapeane tigini kakeneya nokome one lene timini yametaneya. ");
INSERT INTO wiu_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Nitikale enemotekete wa wakapea ete yene mekoita pote ile enekoo wa opokoli enika yakoa moameneya. ");
INSERT INTO wiu_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Wa naniko one oyali-kiti tuku melepu kakoa (11) yene oboa mekete ne nakoita nokome one lene timini yamenaneya. Nitinokomepa one wete tuameneyake mekome okanakamo yakoa moamokoli tokome kikoa akeneya. One tuake kamoa nokale enemotekete to̱awea onokala tane-kitame okoimoka kolotini lupi tootokaneya mea yakamokoli tokome nika kikoa akeneya. ");
INSERT INTO wiu_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Nititikoa kakome okome ali atoa ta piko peyake pitiki toa anukumo oa pupitikakapoatino poe. ");
INSERT INTO wiu_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Anukumo yakoa mootokoa ue motokoi yenepa Akolaliyo toa mokala too. Nitameneya anukumo yakoa moamokoi yenepa nipa Akolaliyo kibu mootokoa wawoo. ");
INSERT INTO wiu_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Anukumo yakoa motokoi yenamepa Akolaline tele patu kautakoa kakete tadiki wa ete-kitame wene tomotoa eya telekole toma poi. No ibini wedekoa ipono-kiti takoa wetekoa ni weneya agaleke pademo pademo oa ");
INSERT INTO wiu_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ni ali tania tukakoya kaya katekamoake tuamoa ni ali tukakoya ue moa noake tuamoa toi. Ni eya kuya yene taneya mekoi-kitika yono pikoli latoa pokala toi wa Yesuyo oa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ali Muno Yesuyo one oyali-kiti-pala eni ko ootokoa kakale Akolaliyo one tibuke atepea aua pokale pome Akolaline nimini yono lono mepaneya. ");
INSERT INTO wiu_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Nitaneyake one oya-laweme Yesunomo ta piko peyake oa pupitikama pekeneya. Nipa Ali Muno agome auapea yopia kakale ele kule telekole-pala toma yakeneya. Nitikoli enekete ali atoame inapa nimini akediki wa Yesunomo yakoa mokala taneya. ");
INSERT INTO wiu_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Kamo koni ali Tiopilasi neke i boku wiane mekakakuno, yakamene. Padele padele toto pakeke Akolaliyo taatekoa tanemo pade ali-kitame dika dika wa wete wia mekoa enekala taneya. ");
INSERT INTO wiu_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Nipa Yesuyo tititikakome toma yakale enema yakene-kitame Yesunomo toto olaukama yakete okoi toa wia mekakala taneya. ");
INSERT INTO wiu_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Noanumeka enika enile-kama titianeta laigoane wedetekoane pitiane yakama nokouya tekene neke takoane i i wane wiane mekakene uku. ");
INSERT INTO wiu_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Pade-kitame ne wete olaukakoimo-kiti etene inapa nimini akedeki wa neme wene toa wane ni tuku. ");
INSERT INTO wiu_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Erodeyo Yudea ta yopia meane-pete Akolalike lodo yotokoai tane ago pade Sekaraia Abaia ti yatene ago eida eni take meaneya. One natonopa Eronoke tagene atoa Elisabesi wa ibini akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Sekaraia adona Akolaline leneke wene ki̱yo akeneya meapa Yu yenane totonoka Ali Munoyo ile tamene ile tamene wa yametane agaleka tagameneya mea epetekaneya. ");
INSERT INTO wiu_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Tiobali atoata tokome Elisabesiyo mati opiamele toamokale ada atueta pa meaneya. ");
INSERT INTO wiu_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Wa padepete Akolalike lodo yotokoai tane yatene-kiti tutu tutu wa yotokama nekene toa Abaia time lodo yoa meatekoi oi nokale one time tadu toa enetekoa ekete opi i ago neke-peteno, lodo yotokapa wa takakoli Sekaraia tobou losu yapuke pome lodo yotokapaneya. ");
INSERT INTO wiu_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Einata einapete palima keneya padeya Akolalike ka̱lono takoa lodo yotane-pete ali atoa akolono oboa nekete Akolali kowitoa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","12","Nitikakoa Akolaliyo moa wetekane edelo agopa Akolalike palima keneya padeya lodo yotokoai taneta nimini yono lono eida nome kakale Sekaraiayo enekome wene kainya pianeya tokome pitime tuaneya kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Nitaneyake edelo agome okome okome piti moamea. Neme kowitike okamo Akolaliyo yateka tokolo neke atue deya Elisabesiyo neke mati opikademe tokono, eni mati opikalepa Yone wa ibini amene. ");
INSERT INTO wiu_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Eni mati opikete wene yapekale kolotine meoi. Ete ali atoa peya matiyameka ke wa wedikoa meoi. ");
INSERT INTO wiu_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Eni mati tubetoa kakomepa Akolaline leneke ibini akene ago kawademe toko. Nitikagome gerepi po ku̱ ueka leau akateko ueka nakile toamoo. One ninane tepene meaneya Epetane Yomini oneke awinokome tepene lobutua tagatapeoo. ");
INSERT INTO wiu_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Iserele yatene ali atoa peya mati kini Ali Muno Akolali tewitikoa wawa pekene-kiti einagome oto toa moo. ");
INSERT INTO wiu_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Nipa telekago Akolaline agale papete to̱awea akane ago Ilaidayo tele tane toa too. Nitoa etene mana-mikitipa odene wene pikoa ni Akolaline agale tagoa toamiki yenepa wene ki̱yo akeneya meki-kiti mea tiki toa nimini peku noa tomotoa too. Enipa Ali Muno ago noatekoya tokolo ali atoame nepia memotoa tokome edikoa nodokakama yawoo wa edelo agome akeneya ");
INSERT INTO wiu_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","19","Nimo okale Sekaraiayo okome nopa ada toane koto kakou ago, anu natonoka atue deya mekono, neme wini okopa nimini toatekomo okono edoane wene tuku patu-kale okome nopa Geberiele Akolali-pala opiane-kama kaku agome uku. Akolaliyo i epetane agale no neme to̱awea akapa wa neeke wetekakolo nekene uku. ");
INSERT INTO wiu_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Eni to̱aweane ukule taatekateko oi ponoka-pete nimini taatekoa toatekoyake neme yakoa moamoko. Nitikoya teke enile wete taatekoa toameneyakepa neke kekeme agale amele toamokale agale wametekoa pa meoo wa edelo ago Geberieleyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Nitikakoa ali atoame Sekaraia akolono witoa nomotoa nepia kakeneya. Nipa einago edekolo wete noamoko patu wa nepia kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Wa naniko einago akolono witoa nokome ali atoa-pala agale amele toamokale pa kakeneya. Nitoa yoname agale adeka pia oa kakale enekete tobou losu yapu kakome pulete keneya padele enadeko wa enoa wene taneya. ");
INSERT INTO wiu_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Sekaraiayo tobou losu yapu Akolaline pupu takoa mea peya takateka oi ponokale one yapu wakapea pome mepaneya. ");
INSERT INTO wiu_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Wakapea pome mea natono koua pitikale mati kakeneya. Elisabesi mati kakeneya meapa tokene ko kakoa (5) ponomotoa witimoa one yapu eida pa meaneya. ");
INSERT INTO wiu_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Nitoa mekome okome namolopa no tiobo atoa meane tekene yame tuaneya mekouyano, opipa Akolaliyo no auapekolo tekene eni ya teigoane waku wa Elisabesiyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabesi one mati kakeneya meaneyake ko melepu (6) tokene nome kakaka Akolaliyo edelo ago Geberiele Galili ta keneke piane Nasarese take poano pa wa moa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Nipa ali poameneya tuatoa mekata eni wetekaneya. Eina atoapa Depidike tagene ago Yosepeyo moademe tu pia kakene atoa one ibinipa Maria. ");
INSERT INTO wiu_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Einatoa mekata edelo ago nokome okome kamo koni atoa Akolaliyo pewe wia kakene atoa Ali Muno agome ne auapea yopiko wa okale ");
INSERT INTO wiu_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","yatekome one eni oka agaleke wene kainya pianeya kakome no-pala ina okana agalepa edemo wa okato patu wa wene kibutua kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Nitoa kakaka edelo agome okome okome anu oyatoa Maria piti moamea. Akolaliyo ne pewe wia kakono, piti moamea. ");
INSERT INTO wiu_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ne mati kakeneya meade toko. Neke eni opika matipa Yesu wa ibini oa piamene. ");
INSERT INTO wiu_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Eni matipa ibini akene ago kawoo. Ako odene meko Akolaline mana wa peyame ibini oi. Ali Muno Akolaliyo neke kaua ago Depidiyo talo tane taapa ne tobou ago meke yopia-kala mea wa eni mati yameoo. ");
INSERT INTO wiu_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Nitoa yametekale Yekobeke ta̱ma nokoi-kiti yopia-kala kama pokomepa wipitiameneya pa talo toa-kala kama poo wa edelo agome akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","35","Nitikale okome nopa ali poameneya mekuno, mati edoane opimotoa-pe wa okale okome Epetane Yomini neeke awinademe toko. Nipa ako odene meko Akolali one telekoleme ne kaunoademe toko. Nitikale tokome neme opikateka matipa Akolaline mana wa peyame ibini oi. ");
INSERT INTO wiu_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Neke wamene atoa Elisabesika mati kakeneya meko. One atue deyameke mati kakeneya meko. Namolo tiobo atoa-kala akeneyake opipa mati kakeneya meko. Nipa tokene ko melepu kakoa ponomotoa mati kakeneya meko. ");
INSERT INTO wiu_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Enilepa Akolaliyo padele padeleta peya tamele toko agome ni toko-kale okome ");
INSERT INTO wiu_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","nopa Akolaline pupu takaku atoano, neme wini okolepa nimini taatekoa tomotoane uku wa okale edelago tewitikoa pekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","Einapetepa Mariayo Sekaraiane yapu pou wa one yapu Yudea take tono tonota kakeneka wete pekeneya. Nitoa one yapu tuapea pokome Elisabesi-pala ke wa oa tebea motaneya. ");
INSERT INTO wiu_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Nimo okale Elisabesiyo yatekaka eina eina Elisabesine tepene kakene mati tepene peloa toa kakale Epetane Yomini Elisabesike awia tagatapeneya. ");
INSERT INTO wiu_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","43","Nitikale Elisabesiyo telo okome okome ete atoa peya pa memotoa Akolaliyo ne takoa pewe wia kako. Neke opiateko matika pewe wia kawademe toko. Ae, anu Ali Muno agono nine nepa anu yapu opi noke kako. Ne dikane atoa no pa atoa mekuta edekolo noko-pe. ");
INSERT INTO wiu_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Neme no tebemoa kake okamo yakakakounaka eina eina anu tepene kakene mati wedikome tokome peloa toa kaka. ");
INSERT INTO wiu_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ali Muno agome oa wetekapiane agale yakoa motoko atoa nepa kolotine meoo. Nepala eina oa pianele nimini taatekoa too wa yakoa moteke tokale tekene ni uku wa Elisabesiyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Nimo okale Mariayo eya wa lo oa kakeneya. Anu tepene meaneya ya̱wane Ali Muno kei pikene uku. ");
INSERT INTO wiu_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","48","Anu yomini-pala kolotine mekene no toa motokago Akolali-pala ke wane oane meku. Ni edoa-mo. One pupu takaku atoa pa ponopeneya mekuyake takoa moa pewe wia kako. Nitikono, opi titimoa ali atoa opia tagama pokoi peyame i atoa nopa Akolaliyo pewe wia kakene atoa wa no kei pia oi. ");
INSERT INTO wiu_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Telekago Akolaliyo padele padele tubele mati toa no auapekala toka. Onepa ki̱yo akenele-kama toko agono, one ibinipa paya tetepo takamikiya. ");
INSERT INTO wiu_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ali atoa oneke nate wene pianeya mea opia tagama piki toa oneme ela moa yopia meko. ");
INSERT INTO wiu_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Akolaliyo ele kule telekole-kama toma nekeneya. Nipa pine yene kini wa kei pia mate agale okoi-kitipa wia tadekatapeneya. ");
INSERT INTO wiu_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ni eka kuka take mea telekole toa yopiane tobou ali-kitipa keku mekoa ponopene ali atoa ako moa kakoa taneya. ");
INSERT INTO wiu_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ni kobume tuaneya meane-kiti nee epetaneya lawetaneyake kamo tane ali atoa wanakome poe wa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Kiwi yatene ela moane auapeou wa oa pikana toa wene taneya mekome onekele takama nekene Iserele yatene auapea yopia kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Nipa tone kaua-mikiti-pala oa pikana toa eni taatekoa taneya. Enipa Eberameka oneke ta̱ma pokoi yeneka kiwi peya ela moane auapeane-kala kama pou wa oa pikana toa taatekoa taneya wa Mariayo lo oa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Tokene tebolo tadiya ponomotoa Maria Elisabesine yapu pa eida meaneya. Nitoa meemotokome one yapu wakapea pome mepaneya. ");
INSERT INTO wiu_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabesi one mati opiateka oi nokale ali mati opianeya. ");
INSERT INTO wiu_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Nitaneyake Ali Muno agome Elisabesi ela mati motokome mati opimotoa tanemo yatekete one oya yene one yatene ali atoa peya wedia meaneya. ");
INSERT INTO wiu_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","63","Wa ta pataka ketepo (8) kakoake eina matiyane kepene teigakoli enadete nekene yename one etenane ibini Sekaraia wa ibini ato wa okoli niname okome e̱'e mena. Yone wa ibini ato-kale ekete kita yatene ago Yone wa ibini akene ago odeneka kawamokono, Yone wa ibini okopa edekolo oko-pe wa akeneya. Nitoapa matiyane etene-pala yoname adeka pia pitia yatekete ekete i matipa te wa ibini oo-pe-koli agale wiane mekatekuya manoe wa yoname adeka pia moa witikome i mati one ibinipa Yone toko-la wa wia mekakale enekete wene kainya pianeya kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","One ibinipa Yone toko-la wa wia mekakaka eina eina one kabunu yapekome kekeme agale amele tokale Akolali kei pia kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Nitikalepa eni take meane yene peya piti tokale meaneya. Nitaneyake eni tanemo Yudea tono pake pake piane ta ludu oa pupitikatapeneya. ");
INSERT INTO wiu_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Einaka einamo yakane-kitame wene kibutua mekete ekete i matipa tubetoa kakomepa edoa kako patu wa wene kibutua meaneya. Ali Munono yono tatono piadeko wa wene tekete ni akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Nitaneyake Sekaraia Epetane Yomini oneke awia tagatapeneya kakome Akolaliyo taatekoa toatekamo eya wa oa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Toto Iserele yatene yopiko ago Ali Muno Akolali kei piato. Kiwi auapeou wa one ali atoa toto oto toa motaneyano, nitato. ");
INSERT INTO wiu_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Nipa kei yene toto toa mopamene wa telekole-kama tokago moa kakakomepa onekele papete takane ago Depidi-loeke tagene ago eni moa kakaneya. ");
INSERT INTO wiu_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Nipa namolo namolo papete one agale to̱awea akane ali-kiti-pala dikou dikou wa oa pikana toa to̱awea akanele eni taatekoa taneya. ");
INSERT INTO wiu_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Nipa kiwi yatene-pala poi te̱ia mekoi-kitika kipala kotimi wene lua mekoi-kitika ete pedeka pedeka toane kiwi toane mou wa oa pikana toa taatekakome einago moa kakaneya. ");
INSERT INTO wiu_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Nile tikilepa tone kaua-mikiti ela moane yopiou wa oa pikana toa taatekoa taneya. Ni neeke ta̱ma pokoi yene auapekene dikou dikou wa Eberame-pala papete oa pikana toa wene kayapeameneya mea taatekoa taneya. ");
INSERT INTO wiu_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Toto eni auapeatekamopa tone kaua ago Eberame-pala oa togotopianeya. Nipa kipala poi te̱ia mekoi-kitike kiwi toane motokolu onekelepa atiki toa takama pomotou wa oa togotaneya. ");
INSERT INTO wiu_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Nipa oneke ta̱ma pokoi yene toto mea epetekateko toa mea ni wene ki̱yo akaneya mea tomotoa tokome nitaneya. Enipa one leneke-kama mea kama pekete tomotou wa Akolaliyo toto auapeatekamo Eberame-pala papete oa togotopianeya. ");
INSERT INTO wiu_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Nitaneyano, anu i mati deya nepa ako odene meko Akolaline agale akako ago wa peyame oi. Ali Muno noateka ka nodokakapikilepa one naniko nomotoa ne namolo takoa peke nodokakapima poo. ");
INSERT INTO wiu_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Nipa ali atoa Akolaliyo kiwi toa motikilepa kini poanele toma yakoinake po letu mekakana keetapea too wa neme wene takama-kala poo. ");
INSERT INTO wiu_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Tone Akolaliyo one ali atoa ela moa poti ko akene wene-kama pianeya mea tokome toto toa moateko ago a tibu mea noateko ta patakademe toko. ");
INSERT INTO wiu_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Yomiyomu keneke meemotekete tua poateko-kiti totoke pa̱ eni takalogakilepa tepe kolotini kilikoa pimotoa meateko ka yamea too wa Sekaraiayo lo oa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Eni mati tubetema pokome tigini kawa yomini-pala tele taneya meaneya. Nipa Iserele yenane leneke kakome Akolaline agale akateka oi wete noameneyake ali piamene ta ludu pima yakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Einaka einapete ako odene meane tobou ago Sisa Ogasasiyo eya taneya. Ta piko peyake pitiki ali atoane ibini bokuke wia mekoatino toe wa oneke lokoa ta talo tane yeneke agale oa wetekamu taneya. ");
INSERT INTO wiu_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ali atoa mekoi toa oi eni motikilepa eya ago Kuwiriniusiyo Siria ta talo toa meane-pete titia taneya. ");
INSERT INTO wiu_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Nitane-pete ali atoa kini kini opiane take-kama ibini oa pipokala taneya. ");
INSERT INTO wiu_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yosepe einagoka nitaneya. Nipa Galili ta keneke piane Nasarese ta kawa Yudea ta keneke Beseleme wa ibini akene take pekeneya. Depidi-loeke ta̱ma nekene ago tokome Depidi opiane Beseleme take ibini eni oa pipaneya. ");
INSERT INTO wiu_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","One moademe tu pia kakene atoa Maria-pala opia pome nitaneya. One eni atoapa mati kakeneya mepaneya. ");
INSERT INTO wiu_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Eni takepa one mati opiateka oi nokale ali mati opia pianeya. ");
INSERT INTO wiu_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","One namolo mati eni opikome mamina ludume togototapea pitimekawe kai eya nee pikoai taneya waneke moa pianeya. Nipa ali atoa dekoa piai tane yapu edea takatapeneya tokome eida paka lono mea mati opia pianeya. ");
INSERT INTO wiu_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Einaka einata ta likale sipi sipi kai talo tane ali pade-kitame kini sipi sipi kai li ludu talo toa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Nitikakoa Ali Munoyo moa wetekane edelago kiwi kakoiya liti kotikatapea nome kakale Ali Muno agono pa̱ toologaneya. Nitaneyake pitime tuaneya kakoli okome ");
INSERT INTO wiu_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","ali atoa peya wedikateko agale oane metekuno, piti moameo. ");
INSERT INTO wiu_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Opi Depidi opiane takepa kiwi toa moateko ago opianeya piko. Ali Muno Keraisu wa oatiki agoke uku. ");
INSERT INTO wiu_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ena mati ino enoe wa wene tomotoane tekene one adeka i oane meteku. Mamina ludume togotane matipa pitimekawe kai eya nee pikoai taneya waneke wini pioono, enoatino poe wa edelo agome akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Nitikaka eina eina edelo ago kakata one a tibuke meane yagono-mikiti kotikatapea obomoa note kaatapea Akolali kei pikete ekete ");
INSERT INTO wiu_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","ako tibuke pa̱ tootapeneya meko Akolali-pala ke wa one kei piato. Itonokepa one wa takoa motokome pewe wia yopikolo meki-kiti poi wia pitikaneya mekino, ke wa oa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Nimo oomotekete edelo yatene a tibuke wakapea pekeneya. Nitaneyake sipi sipi kai talo tane ali-kitame oote tekete ekete Ali Munoyo ina wetekakale nome okanakale Beseleme take enepatoe wa ");
INSERT INTO wiu_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","teyapea pote enekoli Maria Yosepeta eida kakoli enaneya. Eina matika pitimekawe kai nee pikoai taneya waneke pikale enaneya. ");
INSERT INTO wiu_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nitoa enemoteketepa edelo agome kiwi-pala eina matike to̱awea onokanakamo i i wa oa pupitikama pekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Kini eni oa pupitikanemo yatekoi peyame i ikino yakatoe wa wene kainya pianeya yakakoa meaneya. ");
INSERT INTO wiu_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Nitaneyake Mariayo einaka einamo one lukoa mekome enilepa edele toatekolo toko wa wene kibutukoa meaneya. ");
INSERT INTO wiu_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Sipi sipi kai talo tane ali-kiti kini kawa nokoina lono wakapea pikilepa Akolali-pala ke wa oa one kei piawineya pekeneya. Nipa edelo agome kiwi-pala eina to̱awea onokanakale peya taatekatapeadekale ni taneya. ");
INSERT INTO wiu_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ta pataka ketepo (8) kakoakepa matiyane kepene teigamotoa aua poatekoi oi nokale Yesu wa ibini akeneya. Nipa Maria mati wete kawameneyake edelo ago nokome ibini to̱awea oa pikana toa taatekoa nitaneya. ");
INSERT INTO wiu_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Moseseyo one totono yametekome tamene wa akene toa eya taneya. Mariayo mati pene opimoa tokome enipete-mene mati pikoa pia pa witimoa meaneya. Nitoa mea teigakomepa Maria Yosepetame eni mati Akolaline takoa meadete Yerusaleme take aua pekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Nipa namolo takoa opiane ali mati Akolaline takoa meamene wa Ali Muno agono totono wia mekaneya piane toa litia taneya. ");
INSERT INTO wiu_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Nitoa aua pote metekete Akolalike padeya mea lodo yotaneya. Nipa ini takuta mayapu takutaka puluma inideya takutaka mea lodo yamene wa Ali Muno agono totono wia mekaneya piane toa nitaneya. ");
INSERT INTO wiu_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Yerusaleme take eya ago Simione meaneya. Einagopa wene ki̱yo akatapeneya mekome Akolalinele-kama takoa meaneya. Nitoa mekomepa Iserele yene ela moa auapeatekago taatekoa nomotoa nepia meaneya. Nitane agoke Epetane Yomini awinaneya. ");
INSERT INTO wiu_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Awinome mekome okome Ali Muno agome moa kakapiane ago Keraisu taatekoa nokale ne tuameneya mea enoano, poti nepia meamene wa papete wene takapianeya. ");
INSERT INTO wiu_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","One eni papete okana toa taatekakome Epetane Yominiyo tobou losu yapu poano pa wa Simione wetekakale pokome enekale Maria ana Yosepetame Mosesene totono piane toa tekete mati Yesu Akolaline takoa meadete ");
INSERT INTO wiu_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","aua nokoli enaneya. Enetekoa moa tebemoa kakome Akolali kei pia kakome okome ");
INSERT INTO wiu_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Ali Muno ago neme no-pala papete oa pikanakale opi taatekoa tokono, nekele takama nuku ago nopa tepe mataketikaneya tuane pou-ta-la. ");
INSERT INTO wiu_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","31","E ku yatene kakakoa ali atoa toa moade nodokakole anu leneme i enekene tekene ni uku. ");
INSERT INTO wiu_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ali Muno neke toma pokolepa i matiyame e ku mone yatene i i wa pa̱ takalogou toa wene takakala too. Nitikale eni yename ke ke wa Iserele yene kei pia kakala toi wa Simioneyo Akolali kei pia kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Nimo okale yatekete etene nineta wene kainya pianeya kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Nitaneya kakoli Simioneyo kini kowitikakome okome i ali atoata i mati toa pewe-kama wia kamene wa Akolali kowititikoa Maria-pala eya wa akeneya. I matiyamepa Iserele yene padeka-kiti ka̱ia logamotoa toa ni padeka-kiti ate kamotokoa too. Akolaliyo one yatene nani toa moateka adeka pikome i mati moa kakapianeyake padeka-kitame one akoa wawei. ");
INSERT INTO wiu_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Nitaneyake ali atoa peya mati kini tepene pikoi wene keleyo witoo. Neepa kepete tueme lagotaneya meou toa wene kedame tuaneya meoo wa Simioneyo Maria-pala akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Akolaline agale pine wene toa to̱awea akane atoa pade Aana wa ibini akene atoa Yerusaleme take eida meaneya. Einatoapa Aasa ti ago Panuelene kono. ");
INSERT INTO wiu_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Einatoa mali tatono (7) kakoa ponomotoa ana-pala meaneya. Wa naniko ana tukale nepo atoa mekome tobou losu yapuke-kama pome mekala taneya. Nipa ta ete likoa oto likoa Akolalinele takoa mekome nee tekei wawa Akolali kowitikala taneya. Eina atoapa mali ege odepeta kadukoa wa pagini kakoa (84) ponomotoa mea kakene atoa. ");
INSERT INTO wiu_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Einata einapete einatoa nokome Akolali-pala ke wa oa kakeneya. Nitoapa Akolaliyo Yerusaleme yene oto toa moatekale nepia meane ali atoa-pala eni mati koo oa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ali Muno agono totono pianele toa peya takamotekete Maria ana Yosepetame mati-pala aua kini Galili ta keneke piane Nasarese take wakapea pote mepaneya. ");
INSERT INTO wiu_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Eidapa eni mati tubetoa kakeneya. Nipa tigini kawa wene muno mea tagatapeneya mea tokale Akolaliyo pewe wima pekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Edelo ago patukane wa ibini akene toge oi penane toa-kama Yesuno etene nineta Yerusaleme take eni toge lobutupokala taneya. ");
INSERT INTO wiu_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yesu opitikaneyake mali tuku kakoa (12) ponokale eni malikeka einakale toa one-pala Yerusaleme take aua pote toge lobutupaneya. ");
INSERT INTO wiu_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Nitoa mea togamotekete kini take wakapea poadete pekeneya. Wakapea pomotoa mana Yesuyo kita wameneya Yerusaleme take pa eida meaneya. ");
INSERT INTO wiu_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Etene ninetamepa Yesu kita-pala opia yakoina-kiti pake lukoa nokono wene pia pote ta likakete kini oya-mikiti kini yatene ali atoa pake tuku tokoa kaketeke enameneya. ");
INSERT INTO wiu_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Nitimotekete Yerusaleme take wakapea pote tuku topokete ");
INSERT INTO wiu_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","ta pataka teboloke tuku tokoa kakeneya. Nitoa tobou losu yapu pote enekoli Akolaline agale olaukane ali-kiti pakeke lukoa mekale enaneya. Nipa eni ali-kitame okoimo yakakoa mea pademo pademo pitia yakoa mea tokale enaneya. ");
INSERT INTO wiu_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","One eni oka agale yakane yene peyame ekete pademo pademota i wene toa togatapekono, one topo takoa oko agale yakatoe wa ka̱ oa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Eida nitoa meadekale enekete etene nineta wene kainya mati pianeya kakete niname okome anu mati neketai totame ne mama motekete tuku tokoa kakono, dekolo tota wameneya widikoa pa ita meke toka-pe-kale okome ");
INSERT INTO wiu_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","dekale tuku toa kakoiya-pe. Agetainele one yapu kene mekene takamedekuno, ");
INSERT INTO wiu_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","enipa wene toamekete iki-pe-kale one eni oka agale edoa okoto patu wa wene toameneya. ");
INSERT INTO wiu_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Yesu etene nineta-pala wakapea Nasarese take nome mekome kitame okoile-kama litia taneya. Nitima nekenemo-kama Maria pa one luaneya mekome wene kibutukoa meaneya. ");
INSERT INTO wiu_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesu eida tubetema pikilepa tigini kawa wene muno meaneya mea taneya. Nitawineya pokale enekete Akolalika ali atoaka oneke wene mekoa meaneya. ");
INSERT INTO wiu_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Sekaraiane mana Yone ali piamene take meaneya Akolaliyo i ago neke toatekole toano ta wa oi metane-petepa eya tobou ali-kitame Yu yene talo toa meaneya. Ako odene tobou meane ago Taibiriase Sisayo e ku yatene peya talo toa mekale mali wagene melepu (15) kakoakepa oneke lokoa eya ali-mene ta tutu tutu wa yopia mekala taneya. Podiase Pailaseyo Yudea ta yopia ni Erodeyo Galili ta yopia ni one wamene ago Pilipiyo Ituria Terakonaise tata yopia ni Laiseniasiyo Abilini ta yopia mea taneya. Nitikala tokoika Anasi-pala Kayapasitapa ako odene mekete Akolalike lodo yotokoai taneya. ");
INSERT INTO wiu_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Eni malikepa Yone one mekata tewitikoa pokome Yodane ue liti piane ta ludu eya wa mo wima yakeneya. Kini tokoi poaneleke Akolaliyo kiwi wiou wa po letu mekakana keetapemotono kini poanele tewitikoa wawa ue moamene wa oma yakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Nipa Akolaline agale to̱awea akane ago pade Aisaiayo papete wia mekapiane toa taatekoa nokome akeneya. Aisaiayo eya wa wia mekapianeya. Ali piamene ta ludu panagome eya wa mo wima yawoo. Ali Muno ago wini noono, one noateko ka nodokakamene. One yawateko ka-kitika ki̱yotokakapiamene wa taatekoa nokome oo. ");
INSERT INTO wiu_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tubeya kako tono-kitika dee tono-kitika kilikoa odene kotu kakatapeneya kawoo. Eni pake kagono pikokaka ogotapeneya pioo. Ka ko̱ianeya pikokaka ki̱yo akatapeneya pia ka poaneya pikokaka epetetapeneya pia too. ");
INSERT INTO wiu_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Nipa Akolaliyo ali atoa toa motokome tokale peyame enoi wa Aisaiayo papete wia mekapianeya. ");
INSERT INTO wiu_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ali atoame ue moadete one mekata-kama obomoa nokoli Yoneyo enekome okome beita, kayane yagono-mikiti kipa Akolaliyo kibu moateko tigotoma nokono petoatino, oto ita poe wapa teyo pubu okolo niki-pe. ");
INSERT INTO wiu_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Kini namolonakale tewitikoa wakedekolipa ete-kitame enemotono, epetanele toma pamene. Nipa eya wa wameamene. Kipa Eberamene kaua-mikiti mekono, Akolaliyo kiwi edoa kibu momotoa-pe wa wameamene. Akolaliyo i piko kue wane-kiti moa Eberamene kaua-mikiti oyake latikakamele toko. Nitamele tokono, kipa Eberamene kaua-mikiti kako wa edoa mate agale oadete-pe. ");
INSERT INTO wiu_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Yomo-kiti ku̱ tuameadekale enekomepa pinagome tue moa ka̱wa toele pitikoo. Kipa tueme ka̱wa pitikateko tigotokolo tekene ni uku wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Yesuyo nimo okale ekete ae, totome edeko patu-koli okome ");
INSERT INTO wiu_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","panago neke tigini mamina takuta-kiti pikalepa nipa ponopenago pade pa kakale enekepa pade tatia einago meamene. Ni panago neke noateko nee pikalepa nipa panago nee toameneya pa mekale enekepa neke nee tatia meamene wa Yoneyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Nitikale takesi kue motokama yakene ali padeka-kitika Yone mekata ue moadete nekete ekete Tikisago totomepa edeko patu-koli okome ");
INSERT INTO wiu_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","ali atoa-kitaneke takesi kue moteketepa takesi kue moatiki kotuke-kama moamene. Ako pade oa yotokoa moameamene wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Poyo ali-kitameka Yone pitia yatekete ekete totome edoo-pe-koli okome ali atoa-kitaneke kue odoa moamoa yete pade ali atoa-pala pa akoa agale wamoa tamene. Ni kini poyo pupu tokoike kue moteketepa ko̱ wameneya moateku toane i oyake motukuno, ke wa moamene wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Nitaneyake peyame one wipitikome toatekale nepia kakeneya. Nipa wene kainya pianeya kakete ekete i ago Akolalinele takamotoa moa kakapiane ago Keraisu taatekoa noko patu wa wene kibutua meaneya. ");
INSERT INTO wiu_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Nitikoli okome noanumepa kiwi pa ue motokakala tukuyake no keku kamotoa panagomepa ele kule telekole toa noademe toko. Nokolopa auapeane one kawa yene kekatukuyake no pa ago tekene oyake kekamele toamoko. Einago nokome ali atoa pa ue motokamokome Epetane Yomini-pala toeta motokademe toko. ");
INSERT INTO wiu_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Einago nokome eya tou toa ali atoa takoa moo. Witi ku̱ takoa motokagome-kiti one tapepora katekamoa nokome witi ku̱ kugu witikatekoapa yaku pupulegeme popokoa aua pomotoa ate tibu pokotoa pitikakala too. Nitoapa ku̱ one kakata wa pitoa auma kakale witi ku̱ lobutua piko yapu keneke moa pitikoai too. Nititikoa yakupa koukoa moa pa nokoa-kama kako toe mine aua pitikoai too wa Yoneyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Nitikomepa emo kumota oa metekome ali atoane wene epetekateko toa Akolalinemo edikoa oa mekala taneya. ");
INSERT INTO wiu_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Wa naniko Galili ta yopiane ago Erodeyo wamene Pilipi natono Erodiasi kode moa one natono latikaneya. Nitaneyake Yoneyo Erode kikoa okalepa ");
INSERT INTO wiu_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","poanele ate toawineya pome wipitikome Yone po yapu moa pitikaneya. ");
INSERT INTO wiu_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Yoneyo ali atoa peya ue motokatekaneyake Yesuka nokome ue motaneya. Ue mootokoa Akolali kowitoa kakaka tibu peaneya pikale eya taneya. ");
INSERT INTO wiu_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Epetane Yomini ini weuwe tetepo takatapea nome oneke pitoa awinokale a tibuke agale ludu nokome okome i ago neepa anu mana anu kolotini ali. Neke tokoleke kolotine meku wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesuyo Akolalinemo olaukama yakilepa mali padeka kapidi tadiya kakoa (30) penaneyake titikome taneya. Yesu einagopa Yosepene mana wa ali atoame wene pianeya. Yosepa onepa Ilaine mana. ");
INSERT INTO wiu_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Ilai onepa Masatene mana. Masate onepa Lipaine mana. Lipai onepa Melekaine mana. Melekai onepa Yanaine mana. Yanai onepa Yosepene mana. ");
INSERT INTO wiu_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yosepe onepa Matataiasine mana. Matataiasi onepa Emosine mana. Emosi onepa Neamene mana. Neame onepa Eselaine mana. Eselai onepa Nakaine mana. ");
INSERT INTO wiu_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nakai onepa Measine mana. Measi onepa Matataiasine mana. Matataiasi onepa Semene mana. Semene onepa Yosekene mana. Yoseke onepa Yodane mana. ");
INSERT INTO wiu_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda onepa Yoanane mana. Yoana onepa Resane mana. Resa onepa Serabapelene mana. Serabapele onepa Sialetielene mana. Sialetiele onepa Neraine mana. ");
INSERT INTO wiu_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nerai onepa Melekaine mana. Melekai onepa Edaine mana. Edai onepa Kosamene mana. Kosame onepa Elemadamene mana. Elemadame onepa Erene mana. ");
INSERT INTO wiu_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ere onepa Yosuane mana. Yosua onepa Eliesane mana. Eliesa onepa Yorimene mana. Yorime onepa Masatene mana. Masate onepa Lipaine mana. ");
INSERT INTO wiu_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lipai onepa Simionene mana. Simione onepa Yudane mana. Yuda onepa Yosepene mana. Yosepe onepa Yonamene mana. Yoname onepa Elaiakimene mana. ");
INSERT INTO wiu_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elaiakime onepa Meliane mana. Melia onepa Menane mana. Mena onepa Matasane mana. Matasa onepa Nesanene mana. Nesane onepa Depidine mana. ");
INSERT INTO wiu_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Depidi onepa Yesine mana. Yesi onepa Obedene mana. Obede onepa Boasine mana. Boasi onepa Salemonene mana. Salemone onepa Nasonene mana. ");
INSERT INTO wiu_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasone onepa Aminadapene mana. Aminadape onepa Ademinene mana. Ademine onepa Anaine mana. Anai onepa Eseronene mana. Eserone onepa Peresine mana. Peresi onepa Yudane mana. ");
INSERT INTO wiu_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yuda onepa Yekobene mana. Yekobe onepa Aisakene mana. Aisake onepa Eberamene mana. Eberame onepa Tirane mana. Tira onepa Neono mana. ");
INSERT INTO wiu_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Neo onepa Serakene mana. Serake onepa Reuno mana. Reu onepa Pelekene mana. Peleke onepa Ebene mana. Ebe onepa Selane mana. ");
INSERT INTO wiu_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela onepa Kenanene mana. Kenane onepa Apakesadene mana. Apakesade onepa Siemene mana. Sieme onepa Noane mana. Noa onepa Lameka mana. ");
INSERT INTO wiu_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lameke onepa Metusalane mana. Metusala onepa Inokene mana. Inoke onepa Yaredene mana. Yarede onepa Malalene mana. Malale onepa Kenanene mana. ");
INSERT INTO wiu_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenane onepa Inosono mana. Inoso onepa Setene mana. Sete onepa Adamene mana. Adame onepa Akolaline mana. ");
INSERT INTO wiu_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesupa Epetane Yomini oneke awia tagatapeneya mea Yodane ue tewitikoa pekeneya. Nipa Epetane Yominiyo Yesu ali piamene ta ludu aua yakaka ta pataka padeka noi kakoa (40) ponaka toa eida pima yakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Eida pima yakaka Setanu nokome likoa enekala taneya. Enipete-menepa nee nakileka toametekoa enika pima yawa wipitikomepa one kobume tuaneya meaneya. ");
INSERT INTO wiu_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Kobu tokale meaneya Setanuyo nokome likoa enekome okome ne Akolaline mana tadekalepa nipa i piko kue wanepa neke noateko palawe wane latiano ta-kale okome ");
INSERT INTO wiu_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Akolaline bokuke eya wa wia mekaneya pikono yaka. Mea kawadetepa pa nee-kama moa noameamene wa wia mekaneyano, wini okole toamou wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","6","Nitaneyake Setanuyo Yesu tube tono tobouke moa aua pokome kakapaneya. Nitoapa ako tobou ali-kitame yopiane ta piko peya odepeta yametapekome okome eni ta piko peya ni eni ta-kitike koniyoya peya ne ako odene tobou ago meke talo toa wane ne yametapeou. Enika eniya peyapa noanume yopiane memotoa yametaneyano, anu wene litikene takoane moane yameateku ago oyake yameou. ");
INSERT INTO wiu_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Anu kawane witipitake kowitikalepa enika eniya peya ne yameouno ta wa likoa enekale okome ");
INSERT INTO wiu_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Akolaline bokuke eya waka wia mekaneya pikono, yaka. Neke Ali Muno Akolalike odene nate wene piitikoa kowitamene. Losule tikilepa onekele odene takoa tamene wa wia mekaneya pikono, wini okole toamou wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Nitikale Yesu Yerusaleme take aua pome tobou losu yapu munoke moa kakakome okome ne Akolaline mana tadekalepa nipa ita kawa keti tiga-na. ");
INSERT INTO wiu_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Neekepa Akolaline bokuke eya wa wia mekaneya pikolo tekene ni uku. Akolaliyo ne i agopa wedoa yopia kamene wa one edelo yatene yameoo. ");
INSERT INTO wiu_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Nitikale ne tugoa ogo eya nakaya tokale kini yoname lekanamoi. Enimopa Akolaline bokuke wia mekaneya pikono, nepala padeleka toamoono, tigaketika. ");
INSERT INTO wiu_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Setanuyo nimo okale Yesuyo okome neke Ali Muno Akolali likoa enameamene wa wia mekaneya pikono, wini okole toamou wa wakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Nitaneyake Setanuyo padele padele ta-la wa likoa enoai toa teko tokale naniko wa likoane enou wa tewitikoa pekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesu Galili take wakapeane pou wa Epetane Yominine tele patu kautakoa kakome pekeneya. Nitaneyake one toma pekenemo eni ta piko peyake oa pupitikaneya. ");
INSERT INTO wiu_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nipa losu yapu kaka toa Akolalinemo olaukama pokaka peyame imopa i okono yakatoe wa one kei pia kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yesu one tubetekane take Nasarese take pome mepaneya. Eida koo mea pupu toamene-pete one tanele tokome losu yapu pome Akolaline agale oi moademe kamokakale ");
INSERT INTO wiu_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","panagome Aisaiayo wia mekane boku ina wa moa metaneya. Nitikale moa eya agale wia mekaneta tuku toa lewea enekome oi motokome okome ");
INSERT INTO wiu_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Ali Muno Agono Yomini nooke awinoka. Nipa eya toma pomotoa no moa kakakome toka. One epetane agale ponopeneya-kiti oane meane ni poo yapu pitiki-kiti kini yapu pamele tokono poe wane oane ni leneta lianeya meki-kiti kini lenetame enamele tokono enoe wane oane ni wene moa kautakaneya meki-kiti wene yapetekakuno poe wane oane ");
INSERT INTO wiu_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ni Ali Muno agome one ali atoa toa moateka oi meane tomotoa no moa kakapika wa papete wia mekanemo Yesuyo oi moa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Eni oi mootokoa kakome Yesuyo boku ewetetekoa losu yapu yopiane ago ete wa metekome witipitoa meaneya. Nitikaka losu yapu mekoi peyame one nepikoa pianeya. ");
INSERT INTO wiu_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Nitikoli okome wini oi moane metekounakale opi taatekako. Kime yakakoa mekika taatekako wa okale ");
INSERT INTO wiu_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","peyame koniyo agalepa ina to̱awea oko wa one kei pia kakeneya. Nitoa wene kainya pianeya kakete ekete i agopa Yosepene mana agomeke imopa i oko-la wa oa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Nitikoli okome kini pedoa ikina agale no-pala to̱opitikakete eya wa oi. Dokosago pinali neke wa latekamene wa oa ni eya waka oa toi. Kapaneame take neme toma pekenemo totome yakakole-kiti neke pine take ikaka toa ta wa no-pala oi. ");
INSERT INTO wiu_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Nitoino, kipala i ukumo yakoe. Akolaline agale to̱awea akakagopa one take yename one makutukoa motikileka toamiki. ");
INSERT INTO wiu_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Nimini ukuno yakoe. Akolaline agale akane ago Ilaida Iserele take mekakoa mali teboloke ta pitamoa wa mali tuyono takaka tiginalo ta wete pitameneyake kobu igi mati nokoa kakeneya. Nitane-pete Iserele take nepo atoa peya mati meaneya. ");
INSERT INTO wiu_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Einapete Akolaliyo Iserele nepo meane atoa-kiti pa memotoa Ilaida pa wa wetekakomepa mone Saidone ta liti piane Sarepase take meane nepo atoa odene auapeano pa wa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","One agale akane ago Ilaida Iserele take mekakoa one eni take kedime nakene ali atoa kainya mati meaneya. Nitaneyake Ilaidayo one ta pine yene odeneka latekameneyake mone Siria take ago Nemane latekaneya wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","30","Nitikale losu yapu mekoi peyame kiwi yatene Iserele yatene paya tetepo takakome oko wa Yesu-pala kotimi luaneya mea kamomotekete tayo lono wia lititapeneya. Kini ta liti tono tobouke pala padaneta pedekoa keti pitikatoe wa lia aua pekeneyake kiwi pake pa patukoa pekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Nitimotokome Galili ta pikoka Kapaneame take keti ko̱a pome mepaneya. Eida mekomepa ko mea pupu toamene-pete Akolalinemo i i wa eni yene olaukoa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Nitikale ekete agale pinagome i okono yakatoe wa ka̱ oa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Einata einapete poane ipono awitaneya meane ago losu yapu mekome agale telo okome okome ");
INSERT INTO wiu_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Nasarese Yesu nepa toto mekota edade noka-pe. Toto wiade noka-pe. Nepa Akolaliyo one wa takoa moa kakapiane ago toko-la wa ta̱yo ootapekale Yesuyo ipono kikoa okome okome agale wia te̱iano, ");
INSERT INTO wiu_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","wini ago tewitikoa wete takoa pa-kale einago ali atoa pake moa pitikatekoa wa padele toameneya takoa pekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nitikale enekete peyame oote tekete ekete one oko agalepa edane agale patu. Agale pinagome i okono, Akolaline tele patu kautakoa kakomepa takoa poe wa okolo ipono-kitameka yakoa takoa pokala tiki wa ka̱ oa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Nitaneyake one tanemo ta piko peyake oa pupitikatapeneya. ");
INSERT INTO wiu_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","39","Yesu eina losu yapu tewitikoa pome Saimonane yapu tuapea pome mepaneya. Eidapa Saimonane kaue one natonane nine poto yene tane matiyame tuaneya pianeya. Nitaneyake Yesu i atoa neme latekamene wa kowitikakoli one pianeta pome poto tane yene kikoa okome okome takoa pa-kale takoa pokale eina eina kamokakome kini nee takoa lawetaneya. ");
INSERT INTO wiu_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Lou pipokaka eya kuya yene tane ali atoa kini oya-laweme Yesu mekata aua nidikoa pokala tokoli yono pia latekamu taneya. ");
INSERT INTO wiu_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ipono-kitika ali atoa peya mati takoa pote kayo oa ekete nepa Keraisu Akolaline mana toko-la wa takoa pokoli agale wameneya poe wa Yesuyo kikoa akeneya. Nipa i agopa Keraisu tadeko wa wene tekete okoli ni akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","43","Ta patakale Yesu ali piamene take kidenali witimoa pekeneya. Nitaneyake ali atoame tuku tokoa kawa one mekata note kakete ekete tone pitiko ta tewitikoa poamea wa kowitoa wili toa kakoli okome Akolaliyo ali atoa talo tokome tokomo eni epetane ko ete yeka ye ta ludu pitiki ali atoaka oane mema pamedeku. Taatekoane einagale akamotoa ni moa wetekaneya tokolo tuku wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Nitoapa Yudea ta ludu kutu pima yakome losu yapu kaka toa Akolalinemo oa mema pekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Wa padepete Yesu Genesarete ue mine matanu pome kakata ali atoamepa Akolalinemo olaukakomo yakatoe wa apua takatapeneya. ");
INSERT INTO wiu_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","3","Nitikoli enekale ue dipi takuta ue mine matanu liti pianeya enaneya. Nipa pine yename eina ue dipita pa pimotoa mou tagi ka abe ko̱a kakoli enetekoa ue dipi padeke pogatekoa pome mepaneya. Nitoapa i ue dipi ue talike ete keneya modono takoa piano ta wa okale pinago Pita nokome modono takoa pikale mekome olaukoa meaneya. ");
INSERT INTO wiu_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Nitoa olaukatekoa mekome Saimone-pala okome mou tagi tatono, ue muke pote tagi ka pitikapoe-kale okome ");
INSERT INTO wiu_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","mou tagi toa ta patakakoonake mou odeneka motikile toamokoo. Moamokoyake ta wa okalepa nitou wa ");
INSERT INTO wiu_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","one oya-lawe-pala mea pome tagi ka wa pitikapaneya. Nititikoa mou kobeyo kobeyota tagi kake moa ua ue dipike oto lia kakoika mou kedame ka piliamele tokale enekete ");
INSERT INTO wiu_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","padena ue dipike mea nekene oya-lawe auapenoe wa lene lagatikamotaneya. Nitikoli nekete tagi ka poti limo limo toa motokoli kini ue dipita moume edea takatapeneya. ");
INSERT INTO wiu_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Edea takatapea ue kekulu atukademe tokale enekome Saimone Pita Yesuno kawane witipitakome okome Ali Muno nopa poanele tuku agono, no tewitikoa poano pa wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Nipa mou kobeyo kobeyota tagi kake moa utukete tekete Pita one-pala opia mea nekene ali-kitika wene kainya pianeya meaneyake ni akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Sebedine manata Yame Yoneta Saimone-pala kibutua mou tagi tokala tane agotaka wene kainya pia kakeneya. Nitikoli enekome Yesuyo Saimone-pala okome piti moamea. Opi titimoa mou tagi tou toa ali atoa moma poade toko wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Nitikale ue dipita mou-pala ue mine matanuke lia aua nekete kinikiya peya tewitikalogoa Yesu-pala opia pekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ali atoa pitikoi ta pade pome mekaka kedi pitane ago pade Yesu kotuaneya. Kotua enekome aua pitalogoa kowitikome okome Ali Muno neme no epetekouno wene pikepa nipa oyake epetekoano ta-kale ");
INSERT INTO wiu_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","yoname one mitikatekakome okome nitouno ta. Kedime nakeneya neke yene takoa pomotoane uku wa okaka eina eina one kedime nakene yene takoa pootapeneya. ");
INSERT INTO wiu_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Nitaneyake Yesuyo okome okome pade ali atoa enekeka anume ne latekakumo to̱awea wamea. Nitameneya eyaka tamene. Ne i agopa kedi pitaneya mekanake opi i latoa kakona wa yete pade ali atoame wene tomotoapa Moseseyo tamene wa papete oa pianele topamene. Nipa Akolalike lodo yotokako ago mekota peke padeya Akolalike lodo yotokatekoya mepamene wa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Nimo wa oa wetekakaleka one tanemo ta piko peyake oa pupitikatapeneyake one agale yakapato wa ali atoa kini tane yene-pala latekamotoa one pome meane toa obonokala taneya. ");
INSERT INTO wiu_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Nitaneyake Yesu ali piamene ta-kitike lugutukoa pokome Akolali kowitikala taneya. ");
INSERT INTO wiu_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Wa padepete Yesuyo olaukoa kakaka Parisi ali-kitika Mosesene totono pine to̱a olaukane ali-kitika eida meaneya. Nipa Galili Yudea tata piko peya kawa Yerusalemeka kawa note menaneya. E yene mekakoa Yesu Ali Munono tele patu kautakoa kakome yene tane ali atoa latekakala taneya. ");
INSERT INTO wiu_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Nitikaka muku muku toameneya pa pia kakene ago pade one oya-laweme leyo leyo toa aua nekete yapu keneke Yesuno kawane moa piadete tuku toa wili toa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Nitaneyake ali atoa edea takatapeneya tokome pake piameadekale yapu yalinike leyo leyo toa lewia aua pote kakeneya. Nitoapa yalini ke̱atapea kene pikatekoa einakago leyoke pikoa leyo nami-meneke poo kakoa ali atoa pake Yesu kaka pitia tukaketikaneya. ");
INSERT INTO wiu_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesu i agome kini oyago oyake latekamele toko wa wene tekete tadekoile enekome yene tane ago-pala okome okome anu oya neke padele padele poanele toma nokake mekane po letu keetapeku wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Nitikale yatekete Mosesene totono pine to̱a olaukane ali-kitameka Parisi ali-kitameka eya wa wene pia kakeneya. Ali atoa kini padele padele poanele toma nokoike mekane po letu keetapekilepa Akolaliyo-kama tokono, beita i agome Akolali latitapea one paya tetepo takakome oko wa wene kibutua kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Kini eni wene pikoile tetoa enekome Yesuyo okome wini tepene wene kibutukoa mekipa dekolo tiki-pe. ");
INSERT INTO wiu_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","I ago-pala edemo wane omotoa iki-pe. Neke padele padele poanele toma nokake mekane po letu keetapeku wane omotoa iki-pe. Wete kamokoa pa wane omotoa iki-pe. ");
INSERT INTO wiu_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","No Ali Yatenane oyago itonoke mekenepa ali atoame poanele toma pokoike mekane po letu keetapeane wamele tadeko wa kime wene tomotoanepa i ago-pala eya wane uku. Ne aua nokoina leyo-pala moa aua neke yapu poano, kamokoa pa wa eni pa pia kakene ago-pala okale ");
INSERT INTO wiu_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","eina eina e yenane leneke kamokakome one eina aua nokoina leyo katekamoa Akolali kei pima pome one yapu mepaneya. ");
INSERT INTO wiu_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Nitikale enekete peyame ekete ekee, namolona enamokoonakale ilepa i tokono, enatoe wa Akolalike nate wene pia kei pia kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Nitaneyake Yesu eida tewitikoa pokome enekale eya ago Lipai wa ibini akene agopa takesi kue motokoai tane yapu mekale enaneya. Enekome okome no pukuka tone patono noo wa oma ponokale ");
INSERT INTO wiu_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","onekeya peya tewitikalogoa wawa Yesu pokaka litima pekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lipaiyo one yapu Yesuno toge mati kikakakale ali peya mati nekete kita-pala opia mekete nee nakeneya. Takesi kue motokama yakene ali-kitika ete ali-kitika note mekete nakoli enekete ");
INSERT INTO wiu_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Parisi yenameka Mosesene totono pine to̱a olaukane ali-kitameka Yesuno oya ali-kiti-pala eya wa ko̱ oa kakeneya. Takesi kue motokama yaki yene tone totono litia toamiki yeneka toge nee wini opia mekete nakino, dekolo tikiti-pe wa ko̱a oa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Nitikoli yatekome Yesuyo e yene-pala okome okome dokosa agomepa yene toameneya meku wa iki-kiti edoa nome latekanomotoa-pe. Yene taneya piku wa iki-kitipa nipa nome latekanoo. ");
INSERT INTO wiu_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nipa poanele toamuku wa iki-kiti kini namolo wene wia wawe wane oane auapeadene nokouya mena. Poanele tuku wa iki-kiti odene kini namolo wene wia wawe wane oane auapeadene nokou wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Yesuyo nimo okale e yename ekete Yonene agale litia tiki-kitame padepete-kiti Akolali wedoa kowitadetepa nee eya tekei wawa noameneya pa mekala tiki. Parisi ali-kitameka dikakiyake neke oya-mikitame toamikino, dekolo toamikiti-pe wa okoli okome ");
INSERT INTO wiu_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","panagono atoa motokakili atoa motoko agono oya-lawe one-pala wedikete wediapa nee eya edoa wawa noameneya pa memotoa-pe. ");
INSERT INTO wiu_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Wa naniko ete yename atoa motokago padeka aua poatiki wini tigotoma nokona. Nipetepa wene keda taneya mekete nee wawa noameneya pa meoi wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Nimo ootokoa agale pade pedoa okome okome namolo pue pilikalepa panagome wene pue petene moa pade wane pilimoa namolo pue pilikata lapukoa lipuko patu. E̱'e mena. Eniledo tokalepa wene pue pilianeya piake eni wene pueke pilimotane wanepa namolo pue-pala odele taneya piamoo wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Gerepi po ku̱ ue weneya mekalepa pinagome meme kai kepeneme latiane mete namoloyake oyake pe̱ia moamoo. Eniyakedo peikalepa gerepi po ku̱ ue weneya tokome lako yati kawa mono mono okome ka̱ua paka yoa pootapeoo. Nipa meme kai kepeneme latiane mete namoloya tokome oyake pukoa mono mono amele toamokale kaugale gerepi po ku̱ ue pata paka ponoo. ");
INSERT INTO wiu_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Nitameneya gerepi po ku̱ ue weneya mekalepa nipa meme kai kepeneme latiane mete weneyake-kama pe̱ia mokala too. ");
INSERT INTO wiu_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Panagome-kiti gerepi po ku̱ uepa mete keneke mea kakene mati moa nakomepa iyapa mea kakeneya tokome etene meke toko wa nako. Nootokoapa gerepi po ku̱ ue weneya noamademe wakala too wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ko mea pupu toamene-pete pade Yesu witi ku̱ ipe ludu pokaka one oya-laweme witi ku̱ deya kotia moa yoname puputua yaku takoa pukapea noma pekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Nitikoli enekete Parisi ali-kitame ekete Yu yene tone ko mea pupu toamateko-pete kekoa wawa toamatekole wini tikino, ku̱ kotia eni pupupa dekolo tikiti-pe-koli okome ");
INSERT INTO wiu_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","tobou ago Depidiyoka one-pala to̱a yakene ali-kitameka kobu tokale tanemo oi moamokoiya-pe. ");
INSERT INTO wiu_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Eya taneya. Depidi kobume tuaneya meaneya tokome Akolaline wikakane losu yapu tuapea pokome Akolaline pikane palawe wane-kiti moa nakeneya. Nootokoa one-pala to̱a yakene-kiti-pala i nee noatino noe wa tatikoa metaneya. Nipa Akolalike lodo yotokoai tane ali-kitame odene dikane palawe wane namele taneyake taneya. ");
INSERT INTO wiu_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","No Ali Yatenane Oyagomepa ali atoa ko mea pupu toamiki-pete mekete toatikile i i wane oyameane talo toane tuku wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ko mea pupu toamene-pete pade Yesu losu yapuke pokome Akolalinemo olaukoa kakeneya. Eidapa nimini yono lokane ago pade meaneya. ");
INSERT INTO wiu_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Nitane ago mekale enekete Mosesene totono pine to̱a olaukane ali-kitameka Parisi ali-kitameka Yesuyo i ago epetekako patu wa lene wikaneya. Nipa kini pupu toameneya koo meko-pete kekanele tomotadiya wa kakete lene wikaneya. ");
INSERT INTO wiu_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Nitikoli kini tepene pikoi wene tetoa enekome yono lokane ago-pala okome tone lene yoto noke kanoo wa okale kamokakome kini leneke nome kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","10","Nome kakale okome kipala i ukumo yakoe. Tone ko mea pupu toamoko-petepa edele tokala tato-pe. Ali atoa-palapa padele padele epetanele tato-pe, poanele tato-pe. Tuamele toko agopa toa moato-pe, wia tukato-pe wa e yene leneme enoa unukamu tootokoa kakome okome neke yono kutu lido akoano ta wa okale lido akoa enekale one yono epetekatapeneya. ");
INSERT INTO wiu_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Nitaneyake e yename Yesu-pala kotimi wene mati luaneya kakete one-pala toatekoi oi pedoa pia kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Enipete-mene Yesu tono tobouke Akolali kowitipou wa pome mekome kowitoa ta patakaneya. ");
INSERT INTO wiu_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ta patakale one agale yakoa motane yene one mekuta ate kanoatino noe wa kayo oa mootokoa mekome ali tuku kakoa (12) one wa takoa moa one Aposelo ali wa ibini oa metaneya. ");
INSERT INTO wiu_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Eya ali-kiti takoa motaneya. Saimone einago motokome one pade ibini Pita wa oa metaneya. One wamene ago Aderu moa ni Yame Yoneta ni Pilipi Batolomiuta ");
INSERT INTO wiu_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ni Matiu Tomasita Alepiasine mana Yame toa moa ni Saimone one pade ibini Selote ago moa ");
INSERT INTO wiu_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ni Yamene wamene ago Yudase moa ni Yudase Isekariose one wia tukamotoa moa meateka ago moa taneya. Mootokoapa one Aposelo ali-kiti wa ibini oa metaneya. ");
INSERT INTO wiu_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesu one eni Aposelo ali-kiti-pala keti ko̱a pokome kotu kakoa piane take kakeneya. Eidapa one agale yakoa motane yene peya mati ete ali atoa peya mati-pala oboa kakeneya. Nipa Yudea ta piko peya Yerusaleme taka kusa ue matanuke piko Taia Saidone tataka kawa one agale yakadete note oboa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Kini tane yene-pala latekamotoa note kakeneya. Poane ipono awitaneya mekete tete mokoa kakene-kitika nokoli kini ipono takoa poe wa latekakala taneya. ");
INSERT INTO wiu_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","One telepa ali atoake weamutukakala tokome latekamu tokale tekete peyame one mitikada wa wili toa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Einata einapete Yesuyo one oyali-kiti nepikakome okome kiwi ponopeneya pa meki-kiti kolotine meati wane uku. Akolaliyo one pawe toa talo toko eni taapa kinino noe wa kiwi yameoo tokolo tekene ni uku. ");
INSERT INTO wiu_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Opi kobume tuaneya meki-kitika kolotine meati wane uku. Wipitikete ulu yau toa meoi tokolo tekene ni uku. ");
INSERT INTO wiu_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ete yename kipala kotimi wene luaneya mea ete pilia kawa tea agale oa tikilika kolotine meati wane uku. Nipa no Ali Yatenane Oyagono agale kime litia tikile enekete i ali atoa kime poanele-kama tiki wa kiwi paya tetepo takoa wakilika kolotine meati wane uku. ");
INSERT INTO wiu_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Eni yename nitikolika a tibuke pine epetaneya-kama enatikiyano, nitoa kamotono ke wa kolotine mea tigawineya yamene. E yename kipala enika enile teketepa nipa kini kaua-mikitame papete Akolaline agale to̱awea akane ali-kiti-pala toma nekenele tekete toi. ");
INSERT INTO wiu_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ae, kamo tiki-kiti Akolaliyo kiwi kibu moono, nepiamene. Itonoke kini moatekoiya wete mootapeneya tokome a tibuke wedianeya mea kawamoi. ");
INSERT INTO wiu_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ae, opi nee noa tagatapeneya meki-kiti wipitiketepa kobume tuaneya meoi. Ae, opi paya nou toa ulu yau toa yaki-kiti wipitiketepa tumai mea komo ka̱ta pitikoa kawei. ");
INSERT INTO wiu_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ae, ali atoa peyame kiwi kei pikili yakakoa kakete eya wa wene tamene. Papete Akolaline agale akama nuku wa oake agale oa yotokane ali-kitipa kini kaua-mikitame ke wa kei pikala taneya. ");
INSERT INTO wiu_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Anu agale yakoa tiki-kiti kini mekete toatikimo ukuno yakoe. Kipala poi te̱iane yeneke wene mekoa meamene. Kipala kotimi wene luaneya meki-kiti auapekala tamene. ");
INSERT INTO wiu_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Kiwi tea agale iki yene-pala agale epetekoa topo takoa oa ni kiwi tete mekala tiki-kitane kowitikakala tamene. ");
INSERT INTO wiu_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Panagome-kiti neke nimini yono-lono wane witikalepa ewa yono lono waneka wia wa yameamene. Ni panagome-kiti neke tokoo mamina petene odomoa pokalepa tigini maminaka moa wa meamene. ");
INSERT INTO wiu_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Panagome-kiti nekeya pade mano wa oikiledo tokalepa nipa one eni oikoya meamene. Ni panagome-kiti nekeya pade mano wa wameneya pa moa pokaleka oto wa moameamene. ");
INSERT INTO wiu_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Eko pade ali atoame neke wene momotoapa nipa kini weneka moamene. ");
INSERT INTO wiu_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Kiwike wene mekoa meki yene takoa kini kolotine yene wa ete oto wa wene mekanali yotikilipa Akolaliyo kiwi edoa kei pimotoa-pe. Akolaline agale tagoa toamiki yeneka ete oto wa wene mekanali yokala tiki. ");
INSERT INTO wiu_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ni kipala epetanele tiki yene takoa ete wa epetanele topo takakilipa Akolaliyo kiwi edoa kei pimotoa-pe. Akolaline agale tagoa toamiki yenameka edikakala tiki. ");
INSERT INTO wiu_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","I agome onekeya nani oto memotoane tuku wa nekeya pade nami kakoa metekolopa Akolaliyo ne edoa kei pimotoa-pe. Akolaline agale tagoa toamiki yenameka edikoa padeya padeya ete oto wa mea nami kakanali yokala tiki. ");
INSERT INTO wiu_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Kime pade nitameamene. Kipala poi te̱iane yeneke wene mekoa auapekala tamene. Kinikiya pade tatia meteketepa nani oto memotoane tuku wa nami kakakileka toameamene. Pa metekete meamene. Nitikolipa ako odene meko Akolaliyopa kipa one mana kono-mikiti mekete ni tikino, ke wa kiwi pewe-kama wioo. Nipa panagoneya moapa ke wa wameneya pa motiki yeneka poanele tiki yeneka ela moa auapeko ago tokome nitoo. ");
INSERT INTO wiu_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Kiniketai Akolaliyo ali atoa edikoa ela moa auapeko toa yete pade ali atoa ela moa auapekala tamene. ");
INSERT INTO wiu_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Yete pade ali atoa kini tanele poanele tadeko wa kikoa akameamene. Nitikalepa Akolaliyo neeka edikoa kikoa akamoo. Yete pade ali atoa akoa agale wamokalepa Akolaliyo neka akoa agale wamoo. Yete pade ali atoame nepala poanele tokoike mekakana po letu neme keetapekalepa nipa Akolaliyo neke poanele tokake po letu mekakana keetapekala too. ");
INSERT INTO wiu_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Nekeya nami kakameneya pa metekalepa nipa Akolaliyo topo takoa yano kakoa meoo. Nipa neke meteka toa yete pade ali-kitame ako-kama tetekoa keda takoa ete mekala toi. Neme meteka toa Akolaliyo ete wa topo takoa mekala too. Nitoono, nekeya keda takoa-kama mekala tamene wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Nimo ootokoa agale pade pedoa okome okome leneta lianeya meane ago padame leneta lianeya meane ago pade moa aua yamele toko-pe. E̱'e mena. Tugama yakeneya tokome einagota odeneka kobuke pitaketeta pitoi. ");
INSERT INTO wiu_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Sukili matiyame-kiti one tikisago moa patukamele toamoko. Nitamele toamokoyake tikisagome padele padeleta olaukatapekalepa oyagome adekake kakoa tamele too. ");
INSERT INTO wiu_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","42","Anu oyago neke leneke yomo pudunukau pomotoake neme wene toamokoyake neke oyagono lenekedo kugu deya pekeneya eneke eya wa-kiti oko. Neke leneke kugu deya pekeneyano to̱ane motokada wa-kiti oko. Dekolo oko-pe. Wene takuta pianeya meko ago neke leneke pudunukau pekene yomo pinali neke wa namolo takoa to̱a moamene. Mootokoapa neke leneme wedoa enamele tokolo meke neke oyagono lene pekene kugu deya oyake to̱a motokamele toko. ");
INSERT INTO wiu_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Yomo epetaneyapa nipa one ku̱ poaneya tuamoo. Wa yomo poaneyapa nipa one ku̱ epetaneya tuamoo. ");
INSERT INTO wiu_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Yomo-kiti ku̱ tukole eneketepa ipa epetadeko ipa poadeka wa takoa enamele toko. No̱yokepa yomo piki ku̱ kotia moamele toamoa ni tonipo pookepa gerepi po ku̱ kotia moamele toamoa toko. ");
INSERT INTO wiu_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Epetane agomepa one tepene epetane wene piane toa ya̱wapa epetanemo witakoa oko. Poane agomepa one tepene poane wene piane toa ya̱wapa poanemo witakoa oko. Enipa tepene piko toa kabunumepa witakoa okala toko. ");
INSERT INTO wiu_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Nopa Ali Muno Ali Muno wa okala tikino. Kipala tamene wane ukule litia toameketeke ikino, Ali Muno wapa dekolo iki-pe. ");
INSERT INTO wiu_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nooke tegetekoa mea anu agale yakoa toko agomepa nipa eya tane agome tane toa toko. ");
INSERT INTO wiu_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Panagome-kiti yapu epetekoa wikilepa itono wetiketikoa kue yaupea mati piadekata kue petene wane-kiti moa kibutukoa pia eni waneke yapu wianeya. Nitaneyake ta loboa pitikoa ue leau akoa yoa yapuke pewikapokomeke muku muku takoa kilikoa aua pamele toameneya. Kue yaupea matike wianeya tokome pa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Anu agale yatekomeke litia toamoko agomepa nipa eya tane agome tane toa toko. Panagome-kiti yapu wikilepa ue kibi wetiketikoa kue yaupea enamoa pa kibike tokoo yapu wianeya. Nitaneyake ta loboa pitikoa ue leau akoa yoa pewikapokome yapu odepeta kilikoa aua pekeneya. Bu wa wia tadekoa kikilikoa aua pootapeneya wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ali atoame yakakoa Yesuyo enika enimo oa peya takamotokome Kapaneame take pome mepaneya. ");
INSERT INTO wiu_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Eidapa tobou poyo ago pade meaneya. Einagono pupu ago pade one kolotini ali tuademe yene taneya pianeya. ");
INSERT INTO wiu_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Yesu nome meko wa okoimo yakatekoapa poyo agome eya taneya. Yu yatene tobou ali pade-mene moa wetekakome okome anu pupu ago latekakoano noo wa kowitikapoe wa Yesuke moa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Nitikale nekete ekete tobou poyo agome toto yateneke wene mekoa mekome tone losu yapu pade wikakakano, one auapekilepa tamele tokono, one pupu ago latekakoano noo wa kowitikakoli okome ");
INSERT INTO wiu_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","nitouno patoe wa opia pekeneya. Nitoa tigotokakoa pome kakale tobou agome one oya ali-mene moa wetekakome okome eya akapoatino poe. Ali Muno no pa ago mekuno, anu yapu ne noo wane edoane omoto-pe. Tokamota. ");
INSERT INTO wiu_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ne kakota widaka noamouno wene pikene ukuno, nepa pa wida kake wete latoa kamene wado okalepa anu pupu ago latoa kawoono, nitoano ta. ");
INSERT INTO wiu_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nopa tobou ago padeke lokoane mekene ta wa okole-kama tuku. Ni nooke lukoa meki poyo ali-kitamepa toe wane ukule-kama yakoa tiki. Panago ne pa wane-kiti ukulupa yakoa poko. Wa panago no mekuta oto noo wane-kiti ukulupa yakoa noko. Anu pupu ago-pala ile ta wane-kiti ukulupa yakoa ukule toko. Edikoapa anu pupu ago latoa ka wa okalepa latoa kawoo wa Yesu akapoe wa poyo agome one oyali-mene moa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Nitikale note akanokoli yatekome Yesu wene kainya pianeya kakome one-pala obomoa nokoina yene-pala ete peketapekome okome imopa i akedekono yakoe. Mone agomeke ipa akedeko. Iserele ago odeneka nooke edikoa wene tugoa meadekole enamuku wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Nimo okale yakamotekete eina oa wetekakale nekene ali-kiti tobou agono yapu wakapea pote enekoli pupu ago latoa kakedeka. ");
INSERT INTO wiu_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Naniko keneya Yesu Neeni take poademe pokale one oya-lawemeka ete yene peya matiyameka one-pala opia pekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Eni ta pawe kago keteponoke tigotokoa witanokaka pade-kitame tuane ago oloyo topadete akolono leyo leyo toa aua pekeneya. Aua pokoli take yene peya matiyame tuane agono nine-pala opia pekeneya. Eina tuane agopa nepo meane atoane loma mati. ");
INSERT INTO wiu_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Leyo leyo toa aua pokoli enekome Yesuyo einatoa ela motokome okome komo wamea wa ootokoa ");
INSERT INTO wiu_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","tuane ago auane eina leyo pome mitikakale leyo aua pekene ali-kiti witimoa kakoli okome tuali wete kamokoa wane uku wa okale ");
INSERT INTO wiu_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","kamokoa mekome agale oa meaneya. Nitikale Yesuyo nine-pala okome neke mana ina wa metaneya. ");
INSERT INTO wiu_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Nitikale enekete e yene peya tepene piti lobutukale kakete Akolali kei pikete ekete toto pake Akolaline agale akakago tubele mati toko ago i nokono, Akolali one yatene toto mekota ugu nokono, ke wa oa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Nitaneyake Yesuyo eni tanemopa Yudea takeka eni ta unukoa piane ta-kitikeka oa pupitikatapeneya. ");
INSERT INTO wiu_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yonene agale yakoa motane yename Yesuyo eni tanemo-kama i i wa Yone akanokoli ");
INSERT INTO wiu_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","one oyali takuta noe wa Yoneyo kayo oa mootokoa Ali Muno Yesuke wetekakome okome nepa i wa ibini oa piane ago taatekoa noko-pe. Panago taatekoa noo tokolo totome nepia kamotoa oko-pe. Oano ta wa akapoatino poe wa wetekakale ");
INSERT INTO wiu_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","nekete ekete ali atoa ue motokama yako Yoneyo eya akapoatino poe wa wetekakale nokoo. Nepa eina noatekago taatekoa noko-pe. Einagale taatekoa panago noo tokolo totome nepia kamotoa oko-pe wa akapoatino poe wa Yoneyo wetekakale nokoo wa akananeya. ");
INSERT INTO wiu_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Nitikoli einata einapete Yesuyo eya kuya yene tane ali atoa kini tanele-kiti latekoa ni kiwike awitane ipono-kitika takoa poe wa wetekoa ni leneta lianeya meane-kitika leneta kikakoa enika enile toa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Nitoapa einagota-pala okome Yone mekata wakapea pekete kini enoa yakoa tokoinakale i i wa akamene. Leneta lianeya mekoina-kiti lene kikatapeneya yawa ni kawa okeaneya yakoina-kiti pogoa kautoa pote ni kedime nakeneya mekoina yene kini kedi yene takoa pokolo latoa kawa ni kale keneta keteaneya mekoina-kiti kale pekaneya yawa ni tuane yene kamotokaneya kawa ni ponopene ali atoame Akolalinemo yakakoa mea tiki wa Yone akapamene. ");
INSERT INTO wiu_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","No i agoke wene tugoa mea wawamoko ago kolotine meoo waka akapamene wa Yesuyo einagota Yone mekata kutu wa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Yoneyo moa wetekane agota wakapea pokoli Yesuyo eida oboa kakoi yene-pala Yoneke okome okome kime ali piamene take Yone enepeketepa edanele enadete pokoiya-pe. Tauwe wata pupulegeme muku muku toa kakale enepokoiya-pe. E̱'e mena. ");
INSERT INTO wiu_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Nipa edane ago enadete pokoiya-pe. Panago mamina epetaneya kakeneya kakale enepokoiya-pe. E̱'e mena. Mamina epetaneya-kama kawa kamoya moologoa tiki-kiti ako tobou ali-kitane yapu-kala meki. ");
INSERT INTO wiu_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Nipa edaneya enadete pokoiya-pe. Akolaline agale akama yakago enadete pokoiya-pe. E̱eno, Yonepa nitane ago. Akolaline agale papete to̱awea akane ali peya keku kamotoa Yone einago ako ago kako. ");
INSERT INTO wiu_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Yone einagokepa Akolaliyo mana-pala papete akenemo wene takakale panagome Akolaline bokuke eya wa wia mekapianeya. Ne naniko pomotoane anu agale oa aua yawateko agopa namolo takoane moane wetekou. Nitikolu einago pokome ne poateka ka nodokakapima poo wa panagome wia mekapianeya. ");
INSERT INTO wiu_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Kipala i ukumo yakoe. Papete atoame opiane ali peya keku kamotoa Yone einagopa ako kako. Onepa nitane agoke eya wane uku. Anu uku agale yakoa mootokoa Akolalike lukoa meki-kitipa keku ali atoameke Yone moa patukako wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Yesuyo okamo eni yatekete ali atoa peyameka takesi kue motokama yakene ali-kitameka e̱e nimini okono, Akolaliyo ki̱yoke-kama tokono, ke wa Akolali kei pia kakeneya. Yoneyo kiwi ue motokaneyake ni akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Parisi ali-kitameka Mosesene totono pine to̱a olaukane ali-kitameka nitameneya. Nipa Akolaliyo kini toatekoile wene toopiane toa toamadete wakeneya. Yoneyo kiwi ue motokameneya tokome nitaneya. ");
INSERT INTO wiu_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Nitaneyake Yesuyo eya wa akeneya. No kaku-pete meki-kitipa kini tikileke ikilepa edeya adeka piane uku patu. Eya adeka piane ukuno, yakoe. ");
INSERT INTO wiu_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Mati-kiti makesike ulu toonali yotokete padeka-kitame eka e mati-kiti-pala kayo ekete ekete tiabu toa kawati wa totome tulutu eya pukapekokolo yateketeke toamokoi. Nitamokoile enekete toto tumai meou toa komo lo oa kakoloka enika enileka kote tokale tumai meamadete wakoi wa ulu tootapekete akeneya wa Yesuyo pedoa agale akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Nitoapa pine to̱awea okome okome Yone einago nokome padeya neeka gerepi po ku̱ ueka noameneyake ipono oneke awitaneya tokome ni toko wa kime tea agale oa kakoi. ");
INSERT INTO wiu_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","No Ali Yatenane Oyago eya kuya neeka gerepi po ku̱ ueka nakule enekete ekete no i agopa nee kitipu kakoa noa gerepi po ku̱ ue noa pia toko. Takesi kue motokama yaki ali-kiti-palaka Akolaline agale tagoa toamiki yene-palaka no i agome oya patu piko wa kime akoa agale iki. ");
INSERT INTO wiu_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Nimo wapa ikiyake tone agale yakoa motiki peyame ekete mone inapa Akolaline peku noa tadiki wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Parisi ago padame Yesu one yapu nee noano noo wa okale nipa pata wa einagono yapu pome mekome nee nakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Eni takepa poanele toa meane atoa pade meaneya. Yesu Parisi agono yapu ponome mekome nee nako wa akenemo yatekome padeya ka̱lono taneya aua Yesu mekata nekeneya. Nipa alabase wa akene kueme latiane mete keneke mekoa aua nekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Nitoapa Yesuno mukiti lono nome kakome komo oa kakeneya. Yesuno kawatake komo loboa pitikakome tege takaneyake one ludukiya witane pineme kawake pitane komo ko̱a one kawata nunu oa eina ka̱lono taneya pekoa yotokoa taneya. ");
INSERT INTO wiu_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Nitikale enekome one yapu meatono noo wa Yesu-pala akene Parisi ago tepene wene kibutukome okome i agodo Akolaline agale akako ago meadekalepa nipa i one kawata mitikamotoko atoapa poanele toa meane atoa wa wene too wa wene kibutukoa meaneya. ");
INSERT INTO wiu_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Nitikale Yesuyo einago-pala okome okome Saimone nepala agale ouno, yakamene wa okale okome Tikisago nipa yakouno, amene-kale okome ");
INSERT INTO wiu_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","ali takutame odenagonoke kue nami kakoa oia motaneya. Nipa panagome kina egeme kadukoa (50) nami kakoa oia motaneya. Ni padena agome kina noime kadukoa (500) nami kakoa oia motaneya. ");
INSERT INTO wiu_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Wa naniko einagota kini eni nami wiatekoi oi nokale kue toamokale enekome pinagome onena kue oto wa moamou wa kinike eina kue oto moameneya. Nile tokalekepa panago kue pinalike wene mekoa keneya memotoa padena ago oneke wedoa wene mekoa meaneyano, kue pinalike wedoa wene mekoa mekago mani ago-pe wa pitia yatekale ");
INSERT INTO wiu_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Saimoneyo okome kue tubeya nami kakoa oia motokagopa pinalime oto wa tubeya moameneyano, einago tadia pinalike wedoa wene mekoa meaneya wa okale okome wini okopa nimini oko wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Yesuyo nimo ootokoa einatoa lono peketapekome Saimone-pala okome i atoa i mekono ena. Nopa neke yapu tuapeane ugu nokouna-pete anu kawake kakene kege ko̱atekouna uepa pelesi kagonoke neme pekoa pikamokana. Nitamokanake i atoamepa anu kawake kakene kege one komo ueme tege takoa one pineme kogoa tokana. ");
INSERT INTO wiu_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Nemepa no nunu wamokanake i atoamepa neke yapu nokounata titimoa anu kawata pa nunu okoa meko. ");
INSERT INTO wiu_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Nemepa anu wagoke welo eya pekoa yotokamokanake i atoamepa anu kawatake padeya ka̱lono taneya pekoa yotokatapeka. ");
INSERT INTO wiu_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Nitikakano, nepala ukumo yakamene. I atoa one i wene wedoa mekoa mekome tokolepa one poanele padele padele toma nokake mekane po letu wete kekamu taneya tokome ni toko. Wa panago one poanele natele tuku wa wene piko agopa one poanele tokake mekane po letu keaneya mekomepa nipa one eni po letu kekane agoke wene wedoa mekamoko wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Nimo ootokoa Yesuyo einatoa-pala okome neke poanele toma nokake mekane po letu kekamu taneya wa okale ");
INSERT INTO wiu_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","one-pala opia mekoi-kitame oote tekete ekete i agomepa i atoame poanele toma nokake mekane po letu kekamu tuku wa okome okopa edane ago mekome oko patu-koli ");
INSERT INTO wiu_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yesuyo einatoa-pala okome nooke wini wene tugoa meke tokolekepa ne toa motaneya mekono, tepe kolotini mataketikaneya poano pa wa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Naniko keneya Yesu ali atoa pitikoika tubeya takeka nateya takeka kutu pima yakomepa Akolaliyo ali atoa talo tokome tokomo kini wene epetekanemo i i wa mo wima yakeneya. Nitima pokaka one oya-lawe tuku kakoa (12) ali-kitame koua pekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Pade atoa-meneka koua yakeneya. Einatoa-kitipa namolo ipono awitaneya mea eya kuya yene taneya mea taneyake Yesuyo kini tane yene latekoa ipono-pala takoa poe wa latekaneya. Pade atoapa Maria one pade ibini Magadala. Einatoake ipono tatono kakoa (7) awitaneyake Yesuyo takoa poe wa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Pade atoapa Yoana. Einatoapa eyago Kuusa natono. Einagopa ako tobou meane ago Erode onekeya-kiti yopikoa kakene ago. Pade atoapa Susana. Einatoameka pade atoa-kitameka Yesu one oya-laweka auapeatono pato wa opia yakete kinikiya tatia auapema yakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ali atoa peya mati Yesu kakata obonaneya. Nipa ta pitikoi peya kawa obomoa note kakala taneya. ");
INSERT INTO wiu_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Nitaneyake Yesuyo agale pade pedoa okome okome ipe pinagome ipe ludu nee lene pitikama pekeneya. Nitima pokaka nee lene padekapa ka ludu paka tadoa pitaneya. Nitaneta ali atoame kawame kautoa kugutukaneya pikata ini pitoa note napekala taneya. ");
INSERT INTO wiu_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ni nee lene padekapa kue yaupea patu paka tadoa pitaneya. Nitaneta tumiake itono kau tootapeaneta tokome wete eni tototokoa tuaneya. ");
INSERT INTO wiu_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ni nee lene padekapa tonipo pake tadoa pitaneya. Nitaneta tonipo nee lene-pala odeneka dekoa witakome tukatapeneya. ");
INSERT INTO wiu_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ni nee lene padekapa itono epetaneyake pitakome leau akatapea witakome ku̱ tukilepa ege kadukaka tatigime kadukoa (100) tukala taneya wa Yesuyo akeneya. Nimo ootokoa telo mati okome okome kipala ukumo yakou wa kale piiyakoa kaki-kiti kime yakoati wane uku wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Nitaneyake Yesuno oya-laweme neke ina pedoa okana agale pine edoa piko-pe wa pitia yatekoli okome ");
INSERT INTO wiu_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Akolaliyo one ali atoa talo tokome tokolepa papete kaukoa mema nokoyake opi kiwi keleyo oyameteku. Nitikuyake ete ali atoa-palapa pedoane agale-kama oane meteku. Enipa kini leneme enekile enoa moamoa kaleme yatekimo yakoa moamoa tomotoane tekene ni tuku wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ina pedoane okouna agale pine dikoa pikono, yakoe. Ipe nee lenepa Akolaline agale toko-la. ");
INSERT INTO wiu_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Nee lene ka ludu tadoa pitane adeka pikounapa eya tiki yeneke okouna. Akolaline agale yakatekoa pa mekilika Setanu nokome einagale kini tepene meaneya katekamoa poko. Nipa einagale yakoa motikili Akolaliyo toa motokaya tokolo ni katekamoa poko. ");
INSERT INTO wiu_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Padeka nee lene kue yaupea patu tadoa pitane adeka pikounapa eya tiki yeneke okouna. Pade ali atoame eina agale yakoapa ke wa lukoa wedia meki. Nitiketeke einagale kini tepene teke wetekameneya tokome Akolalinele pa tekei takoa meki. Wa naniko kiwi etepea pomotoa ele kuleme likolopa Akolalinele takoake tewitikoa waki. ");
INSERT INTO wiu_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Padeka nee lene tonipo pake tadoa pitane adeka pikounapa eya tiki yeneke okouna. Pade-kitame einagale yakoa motikiyake kinikiya mama moa ni kini kamoya-kitike wene piitikoa mea enika enile tikileme Akolaline agale moa kautako. Nitane yene tokome ku̱ tuamou toa etepea yaki. ");
INSERT INTO wiu_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Padeka nee lene itono epetaneyake pitane adeka pikounapa eya tiki yeneke okouna. Pade-kitame einagale yatekilepa wene epetaneya mea yakoa motiki. Nipa ipe kakoya nee ku̱ wedoa tuou toa Akolalinele takoa togaki wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Panagome-kiti labo toele udukoa yapu aua nokomepa eya toamoko. Okolo moa kaulogamoa ni walai kenekeka piamoa toko. Nitameneya ali atoa yapu tuapea nikita pa̱ keleyo witamotoa tokome labo piatikiya waneke-kama udukoa piko. ");
INSERT INTO wiu_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Padele padele kaukoa toma yakolepa naniko keleyo witatekole toko. Padeya padeya paigakoa pikoya-kiti naniko keleyo pikale peyame enetapeoi. ");
INSERT INTO wiu_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Nipa Akolaline agale paya nou toa yatekayano, wedoa yakoa moamene. Akolali one i peku wedoa nako agopa nipa Akolaliyo one pekupa wedoa lawetema poo. One peku alekoa nakagopa nipa one alekoa nakene pekupa wene toane noane tuku wa wene pikoyake Akolaliyo agopa takoa atukoo wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Einapetepa Yesuno nine wamene-mikitika nokoli ali atoame edea takatapeneya tokome one kakata lekoa poatekoi kene piameadeka. ");
INSERT INTO wiu_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Nitoa pa kakoli enekome panagome neka̱ua nekameyo-mikiti ne enadete akolono note kakina wa okale okome ");
INSERT INTO wiu_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Akolaline agale yakoa tiki ali atoapa aga̱uaka anu wamene-mikitika eni wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Padepetepa Yesu one oyali-kiti-pala ue dipike peapetekoa pome mepokome okome ue mine eka matanuke mea patoe wa okale mea pekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Mea pokoika Yesu mea atu pitaneya. Atu eni pitikakoa ue mine pupulege tadalita u̱u oa ketipea awitikanokome ue-pala pewikanokome ue dipi patua pitoa atukademe taneya. ");
INSERT INTO wiu_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Nitademe tokale one oyali-kiti one pitikaya liti tegeteka tegeteka toa mekete kamotokakete ekete Ali Muno Ali Muno toto ueme atukamedekono, kamoa wa okoli kamokakome pupulege-pala pewikakoa kakene ueta kikoa okome okome kapakoa wa wa okaka teigalogakome tooko lapa eyaka wametekoa kilikoa meelogaka. ");
INSERT INTO wiu_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Nitoa te̱itatapekale one oya-lawe kikoa okome okome nooke wedoa wene tugamekete tadiki wa okale oote tekete ekete pupulege ue minetameka i agome ta wa okole eni yakoa tokono, Yesupa edoa ali kakome tokoto patu wa piti tokale ka̱ oa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Galili ue mine eka matanuke ue dipike eni mea pote Gegesa yenane take witapaneya. ");
INSERT INTO wiu_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Galili ta-pala eni tata eni ue mineme oto piitakutukaneya. Yesu eni ta matanuke katepitakaka ipono awitane ago pade ali atoa pitikoika kawa kotua nekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Einagopa koto mamina kawamoa yapu kilikoa piamoa taneya. Nipa ali atoa oloyo toai taneka pa yakeneya. Ni ago Yesu kotukome one kawane pitakome ka̱ telo okome okome ako odene meko Akolaline mana Yesu nepa nopala edele toade noka-pe. No tete meamoano, wa-ye wa kowitaneya. ");
INSERT INTO wiu_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Nipa Yesuyo poane ipono ne winago takoa pa wa okale tokome kowitaneya. Eni ipono einagoke lugutukoa awinokale ete ali-kitame dekoa moa kapa po kakoa kapa tepo mekoa tokala taneya. Nitikolika kugutukoa tadekatapekale iponame einago ali piamene ta ludu leau akoa aua yakala taneya. ");
INSERT INTO wiu_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Nitane ago Yesuyo yatekome okome neke ibini te-pe wa okale okome anu ibinipa pitikali wa akeneya. Nipa oneke ipono peya mati awikolokaneya tokome ni akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Nitaneyake ipono-kitame Yesu kowitikete ekete ge̱yo nine piane koa keneke wetekamea wa kowitaneya. ");
INSERT INTO wiu_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Nipete einakeya liti tono kebonoke kai peya mati kimi ke noa kakeneya. Nitaneyake ipono-kitame kowitikete ekete toto opi kunuka kunu kaike awiponoono, wetekoa ta-koli okome ");
INSERT INTO wiu_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","nipa poe wa okale takoa pootapekete e kai-kitike awipaneya. Nitikoli einaka eina kai tono payaneke kawa palake ketipea kikilikoa pote atutapeneya. ");
INSERT INTO wiu_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Nitikoile enekete einaka eina kai egetane yene pitoa pootapekete ali atoa ta latia pitikoikaka tayo yapu luduka eni tanemo oa pupitikama pekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Nitikoli yatekete edele taneyake ikiti patu wa enadete nekeneya. Nitoa Yesu kakata note enekoli ipono takoa pootapeane ago mamina kakeneya Yesuno kawane wene ki̱yo akaneya mekale enekete ekee wa piti mati tokale kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Nitikoli eida kakete enile tokale enane yename ete dika dika wa Yesuyo ipono awitaneya yakanakago latekanemo to̱awea akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Nitikoli yatekete eni Gegesa take mekoi peyame kini ta tewitikoa pa wa Yesu kowitoa kakeneya. Nipa tepene piti lobutukale kakete ni akeneya. Nitikoli ue dipike peapetekoa poademe kakaka ");
INSERT INTO wiu_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","ipono takoa pootapeneya mekagome Yesu ne-pala odenekata yatono pato wa kowitikale okome nitamatono, ");
INSERT INTO wiu_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","neke yapu poano pa. Akolaliyo ne-pala tokamo tubele eni tokana ali atoa eneke to̱awea oano pa wa wetekakale ali atoa ta latia pitikoika pokome Yesuyo tubele toa one latekoa tanemo i i wa oa pupitikama pekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesu Galili ue mine oka lono wakapea nokale ali atoame ke wa wedia makutukoa motaneya. Nipa peyame one nomotoa nepia kakete ni taneya. ");
INSERT INTO wiu_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Nitoa kakoika Dairasi wa ibini akene ago losu yapu yopikago nokome Yesuno kawane witipitakome one yapu wete noo wa kowitoa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","One konakoma one odene opiane kono tuademe yene taneya pikale ni akeneya. One kono opitikaneyake mali tuku kakoa (12) tadiya ponokale tuatoa meaneya. Einagome ne noo wa kowitikale nitouno patoe wa Yesu poademe pokale ali atoame Yesu apua takoa unukamoa pekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","E ali atoa pakeke eya atoaka mali tuku kakoa (12) ponoka toa kamate yokoa kakene atoaka Yesu litima nekeneya. Papete einatoa dokosa ali mekoika latekamotoa pokala taneyake padameka one latekakile toameneya. ");
INSERT INTO wiu_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Nitaneyake einatoa Yesuno mukiti lono lekama nokome one tokoo kakene mamina nami mitikatekaneya. Nitikale eina eina one kamate pegetoa yotokana toa yoameneya teitatapeneya. ");
INSERT INTO wiu_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Nitikale Yesuyo noanu teyo mitikakato-pe wa okale peyame no mena wa okoli Pitayo okome Ali Muno ali atoa apua takoa ne unukamoa mitikakoa tikino, dekolo oko-pe-kale okome ");
INSERT INTO wiu_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","padame no mitikakile toka. Anu tele padeke weamutukome tadekolo ni uku wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Nitikale inakeya teitakale akedekono, i ago mitikakoule one-pala kaukoane meamele toamoko wa einatoa kolu kolu nokale Yesuke nokome kawane witipitaneya. Nitikome e yene kakakoa eya takamotoane yoname mitikatekakou wa one mitikatekakale eina eina latekakanakamo to̱awea okale okome ");
INSERT INTO wiu_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","anu kono nooke wini wene tugoa meke tokoleme ne latekakolo uku. Neke tepe kolotini kilikoa pimotono pa wa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesuyo nimo oa kakaka tobou agono yapu pitikakago pade nokome okome neke konakoma tukome tukano, mone i tikisa ago polipo takakoa kawamea wa okale yatekome ");
INSERT INTO wiu_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesuyo tobou ago-pala okome okome no i agome neke kono oyake latekamele toko wa piti toameneya mekalepa latoa kawoo wa oomotokome ");
INSERT INTO wiu_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","yapu pome kakome okome Pita Yoneta Yame toa akomane etene ninetaka no-pala opia namene. Ete yene akolono meati wa tuapea pekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Nitaneta tumaike nekene ali atoa peya tuatoake komo ka̱ta pitikoa kakeneya. Nitikoli enekome Yesuyo okome i akoma tukome tuaneya menano, pa atu pia mekono, komo wameo wa okale ");
INSERT INTO wiu_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","peyame i akoma etene tukome tukano wene tekete tokome Yesu yau takaneya. ");
INSERT INTO wiu_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Nitimotoake eina akoma tukome tuaneya pianeta pokome one yono mootokoa kayo okome okome anu akoma wete kamoa wa okaka ");
INSERT INTO wiu_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","one yomini wakapea nokale wete kamokoa kakeneya. Nitoa kakale okome one nee wete takoa lawetoe wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nitaneyake etene nineta wene kainya pianeya kakoli okome anume i tukumo to̱awea wamea. Pa kini lukoa meati wa oa tukaneya. ");
INSERT INTO wiu_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesuyo one oya-lawe tuku kakoa (12) one kakuta oboa noe wa kayo oa motokome okome noanu tele patu kautakoa kakete eya toma poatino poe. Ali atoake awitane ipono takoa poe wa wetekatapea kini tane yene latekoa toma poatino poe wa moa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Nipa Akolaliyo ali atoa pawe toa talo tokome tokomo i i wa oa aua yawa kini tane yene latekoa tomotoa wetekakome okome ");
INSERT INTO wiu_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","kiwi eni peketepa pa pima yamene. Nipa iti toua moamoa ka ua poamoa palawe waneka kueka ua poamoa tamene. Kini tigini mamina odene kakeneya pekete pade-pala aua poamoa tamene. ");
INSERT INTO wiu_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nitoa pima yawa ta padeka pote meketepa yapu yapu yawameneya eida odene yapu-kama mea kawa pokala tamene. ");
INSERT INTO wiu_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Nitima yakoli pade yapu pitikoi-kitame kini yapu noe wa makutukoa moamokolipa nipa kini yapu tewitikoapa Akolaliyo kiwi kote motokolo tuku wa kini kawake kakene kege ko̱ketikoa tewitikoa pokala tamene wa Yesuyo wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Nitaneyake ali atoa ta latia pitikoika pima yakete Akolalinemo i i wa mo wia kawa kini tane yene latekoa toawineya pekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Tobou ago Erodeyo enika enile tanemo-kama yakatekoapa wene kainya pianeya meaneya. Yesukepa pade-kitame ekete ali atoa ue motokama yakana Yone tukome tuaneyake wa kamoa noko wa oa, ");
INSERT INTO wiu_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","wa pade-kitame ekete Ilaida taatekoa noko wa oa wa pade-kitame ekete Akolaline agale papete akane ago tukome tuaneyake kamoa noko wa agale oa takoa pilia kakeneya. Nimo okoimo yakatekoa Erode wene kainya pianeya meaneya. ");
INSERT INTO wiu_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Nitikome okome Yone kabe teigamotoane tokounano, i tanemo-kama yateku agopa te patu wa Yesuno lene timini enademe akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Yesuno Aposelo ali tuku kakoa (12) Yesu mekata wakapea nekete kini toma yakoinakamo i i wa ootapekoli okome nipa padeka poti witimotekete patono noe wa Besaida wa ibini akene take aua pekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Nitaneyake Besaida take pekete tiki wa akenemo yakamotekete ali atoa one eni mekata litia nokoli oneme makutukoa motaneya. Nitoapa Akolaliyo ali atoa talo tokome tokomo i i wa to̱awea oa kini tane yene latekoa taneya. ");
INSERT INTO wiu_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Lou eni pene pipademe tokaka one oya-lawe tuku kakoa (12) one kakata eida nekete ekete ipa ali atoa piamene taano, ali atoa ta latia pitikika tayo yapu luduka pote nee topo toa pipoatino poe wa wetekamene-koli okome ");
INSERT INTO wiu_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","nitamouno, kini noatiki neepa kime motokoa lawetamene-kale ekete tone neepa palawe wane ko kakoa-pala mou yomo takuta toa eni-mene odene pikono, i ali atoa adekoa noatiki toa totome nee edoa topo toa motokapomotoa-pe wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Nipa e yene kakene toa oi motokoli ali ege egeta kadukoa (5,000) tadiya kakedekoli ni akeneya. Nitaneyake i yene ege kadukako toa-kama (50) payapono pia mekala tomotono toe wa Yesuyo okale ");
INSERT INTO wiu_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","e yene peya edikoa kilikoa mekatapeneya. ");
INSERT INTO wiu_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Nitikoli palawe wane ko kakoa-pala mou yomo takuta toa moa pikoa kakome ate tibuke nepikakome Akolali-pala ke wa ootokoa popimotokome i ali atoa tatikoatino poe wa one oya-lawe mekala taneya. ");
INSERT INTO wiu_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Metekale moa tatika tatika topokoli peyame moa noa tagatapea kitipu meaneya. Nitaneyake kugu paka pitaneya wekotoa moa ua ka katika tuku kakoa (12) mako puputua moa pianeya. ");
INSERT INTO wiu_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Wa padepete Yesu witimotokome pome mekome kowitikata one oya-lawe one-pala eida opia mekoli pitia yatekome okome ali atoame no te kaku wa ikiti-pe wa okale ekete ");
INSERT INTO wiu_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","pade-kitame ne einagopa ali atoa ue motokama yakanakago Yone wa oa ni pade-kitame ne einagopa Ilaida wa oa ni pade-kitame ne einagopa Akolaline agale papete to̱awea akane ago tuutukaneyake wa kamoa nokome toko wa iki wa okoli okome ");
INSERT INTO wiu_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","nimo wapa akedikiyake kime no te kaku wa iki-pe-kale Pitayo okome nepa Keraisu Akolaliyo one wa papete takoa kakapiane ago wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Nitaneyake Yesuyo okome okome Pitayo ina okamo odene ago-palaka to̱awea wameamene wa ootokoa okome ");
INSERT INTO wiu_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","no Ali Yatenane Oyagome tete-kala moane kawou. Nipa Kanosolo ali-kitika Akolalike lodo yotokoai tiki tobou ali-kitika Mosesene totono pine to̱a olaukoa tiki ali-kitika enika eni ali peyame no kote tokale wawa wia tukoi. Nitikolika ta tebolo takoa pataka-pete Akolaliyo moa kamotokoo wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Nimo ootokoa e yene peya-pala okome no i ago litima nou wa wene pikagopa nekele tewitikoa wamene. Nipa ne wia dekatiki yomo aua nou toa tete mokoa kakeka no litima namene. ");
INSERT INTO wiu_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","One kepene mama motokome tukaya wa piti motoko agopa etepea tua poo. Nitameneya no einagoke toane tuou wa one kepene mama moamoko agopa pa mea kama poo. ");
INSERT INTO wiu_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Panagome-kiti one yomini atukome atumotoake itonoke pia kawa tokoya peyado mootapeadekalepa edeya weike moamoo. ");
INSERT INTO wiu_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Panagome noka anu olaukakou agaleka ya motokome wakalepa nipa no Ali Yatenane Oyago telekole toane wakapeane nekene oneka ya moane waou. Agetaika one wene ki̱yo akeneya meki edelo ali-kitika pa̱ teleta tootapeneya meki toane meane wakapeane nekene nitou wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nimo ootokoa okome ita kaki-kiti padeka-kiti wete tuameneya mekete Akolaliyo ali atoa pawe toa talo tokole enoi wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesuyo einaka einamo ootokaneyake ta pataka ketepo kakoa (8) tadia ponokale paka witimotokome pome tono tobouke Akolali kowitademe ate lewia pekeneya. Nipa Pita Yameta Yone toa aua pekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Aida kowitoa kakaka one lene timini padele tootapea one kakene maminaka yati yati toa ake tootapea taneya. ");
INSERT INTO wiu_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Nitaneya kakata ali takuta Mosese Ilaidata kotikatapea nekete one-pala ko oa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Nipa pa̱ teleta tootapeneyata kaketepa oneke papete oa piane toa taatekakome Yerusaleme take pokome tuateka ko oa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Nitoa kakoika Pita one oyagotaka pia kadukatapea mea kamokoa enekoli Yesu pa̱ tootapeneya kakenele enoa one-pala opia kakene agotaka enoa taneya. ");
INSERT INTO wiu_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Einagotame Yesu tewitikoa poadete pokoika Pitayo okome Ali Muno kiwi ko oa kakita toto odeneya kakono, epetekono, neme nitika wa okalepa nipa aga yapu tebolo Mosese kita Ilaida toa kini wikakakala too wa akeneya. Enipa wene bebo akatapeneya kakome wene toamokome akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Enimo oa kakaka wedome agopa takoa kauma nokale Pita one oyalitaka piti tokale kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Nitoa piti tokale kakoika wedo keneke agale ludu nokome okome wini agopa anu mana anu takoane kakapikou agono, one oka toa yakoa tamene wa okale ");
INSERT INTO wiu_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","yakoa enekoli Yesu odene kakedeka. Nitaneyake kini eni enekoinakamo enipete-mene pa kini luaneya mea odenago-pala i i wa to̱awea ikileka toameneya. ");
INSERT INTO wiu_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Podolikama eni tono tobou wane ko̱a pokoli ali atoa peya mati obomoa Yesu kotunaneya. ");
INSERT INTO wiu_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Nitoa oboa kakoita panagome kayo okome okome Tikisago, anu manago i pikono, ena. Onepa anu odene opikouna agono, enoa latekakamene. ");
INSERT INTO wiu_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Oneke ipono awinokolo ka̱ wa telo ootapekala toko. Nitane ipono awinokome peteka peteka tokolo timini kabunuke lako ka̱ua yotokoa kakala toko. Nipa mati tewitikoa poamademe wakala toa dika dika toamene tete mekala toko. ");
INSERT INTO wiu_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nitikala tokolo tekene neke oya-laweme eni ipono takoa wetekakoe wane auane nokounake takoa wetekaku pekete wili toa wakoi wa etename akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Nitikale yatekome Yesuyo okome ae ipete meki-kiti kime Akolalinele takamoa wene moa koiganeya mea tikino, kini eni poane wene tewitikoa wamotoane edoane nepiane meamou wa ootokoa matiyane etene-pala okome neke mana mati no kakuta aua noo wa okale ");
INSERT INTO wiu_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","manago noka noka ipono awinokome itonoke telo moa pitikoa peteka peteka takaneya. Nitoa kakaka takoa pa wa Yesuyo ipono takoa wetekakome mati latekaneya. Nitoapa neke mati ino moa wa etene metaneya. ");
INSERT INTO wiu_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Nitaneyake Akolaline tele patu kautakoa kakome tokale enekoi peyame ilepa i tokono enatoe wa ka̱ oa kakeneya. Yesuyo padele padele tokaleke e ali atoa peya wene kainya pianeya kakete ka̱ oa kakoika Yesuyo one oya-lawe-pala okome ");
INSERT INTO wiu_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","kiwi-pala i ukumo wedoa yakoa moa wene taneya meati. No Ali Yatenane Oyalipa pade ali-kitame wimotoa panagome ete moa meademe toko wa okale ");
INSERT INTO wiu_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","yateketeke kini wene agopa takatapeneya tokome wene toameneya. Nika neme wini okopa edemo wa eke oko-pe wa yakamene piti tokale meaneya. ");
INSERT INTO wiu_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Yesuno oya-laweme kiwi kako-kitipa mainago ako tobou meateko ago-pe wa oa takoa pili pili toa kakoika ");
INSERT INTO wiu_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","kini tepene pikoi wene tetoa enekome mati pade motokome one kakaya liti kakakome okome ");
INSERT INTO wiu_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","panagome-kiti dikane de mati deya nooke toa makutukoa motokomepa nipa no eni dekoa makutukoa motoko. Ni panagome-kiti no makutukoa motokomepa nipa no moa wetekaka ago dekoa makutukoa motoko. Anu oya-lawe kiwi keku agopa Akolaliyo ako ago tetepo takoa meko wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yoneyo Yesu-pala okome okome Ali Muno anu ukumo yakamene. Panagome neke ibini wedekoapa ali atoake awitane ipono-kiti takoa wetekakala tokale totome enekoo. Einago toto-pala opia yako ago toamokolo tokome wa pade dikamea wa kikoa okoo-kale okome ");
INSERT INTO wiu_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","toa kamotono, wa pade edikoa kikoa wameamene. Kiwi-pala poi te̱iamoko agopa kiwi-pala oya kakoa auapeko ago eni wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Akolaliyo Yesu a tibuke aua poateka tigotokale Yerusaleme poada wa pitimoa pekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Nitoa poademe pokome ali pade-mene patepoe wa wetekakale pote Sameria yenane ta padeke Yesu noatekale nodokakadete pekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Nitikoli eni take yename ekete einago Yesu mone Yerusaleme take poademe pokono, Yu ago tadekono, makutukoa moamato wa wakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Nitikoli enekete one oyalita Yame Yonetame ekete Ali Muno toe a tibuke itipono akeneya pitakome i yene wia nootapemotono ta wa totame Akolali kowitikamotoa oko-pe wa okoli ");
INSERT INTO wiu_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yesuyo ete peketapekome wawe wa einagota kikoa oomotokome ");
INSERT INTO wiu_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","one oya-mikiti-pala pade take pekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Yesu one oya-laweka ka ludu kutu potokakoa panagome Yesu-pala okome okome ne pokoka litima pou-kale okome ");
INSERT INTO wiu_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","yanai ini eya kini piatiki yene pikoyake Ali Yatenane Oyago pade no naliyomo mokoane piatekuyaka toamoko wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Wa panago-pala one pukuka litima namene-kale okome agetai tuaneya pikono, oloyo toomotekene nee litima nou-kale okome ");
INSERT INTO wiu_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Akolalinele takamekete tuaneya piou toa pa meki-kitame tuane ali atoa oloyo tomotono, tokamota. Akolaliyo ali atoa pawe toa talo tokomo oa pupitikapoano pa wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Wa panagome okome Ali Muno ne pokoka litima noadene tukuno, nitadeneke namolo takoane anu yapu pitiki-kiti tebeane lionate opou-kale okome ");
INSERT INTO wiu_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","panago one nokana lono kabe takakoa pou toa tokome one namolo tokanakaleke wene piitikaneya mekomepa nipa Akolaliyo talo toko take pamele toamoko wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Wa naniko Ali Munoyo one oya-lawe ege odepeta kadukoa wa lene kolo kakoa (72) ali-kiti takuta takuta wa takoa moa wetekakala taneya. Ali atoa ta latia pitikika tayo yapu luduka one nani noateku toa kiwi namolo takoa pima yawatino poe wa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Wetekakome okome ipe nee kakoya wakoa momotoa nodokoa kibutukakoa kakoyake eni ipe ludu wakoa moatiki yene natetekoa kakino, Akolali eya wa kowitikamene. Ipe nee kakoya wakoa mou toa neke ali atoa motokamotono, neke pupu yene wete takoa moa wetekoano ta wa Akolali kowitamene. ");
INSERT INTO wiu_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Poatino poe wane wetekakilepa lene pianeya yo tane tue-kiti yakika sipi sipi kai tine moane wetekou toane tukuno, eya toma pamene. ");
INSERT INTO wiu_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Kue ka ua poamoa ni padeya-kiti uatiki kaka ua poamoa ni kawa yeneka mekoa poamoa tamene. Pake pake ali atoa kotuketeka ko wameneya pa ponokala tamene. ");
INSERT INTO wiu_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Yapu pade tuapea peketepa i yapu pitiki-kiti tepe kolotini mataketikoa meamene wa namolo takoa amene. ");
INSERT INTO wiu_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Nitoa ootokoa kakete enekoli wene ko akeneya mekago meadekalepa kini okoi agale einagoke weamutukome one tepe kolotini mataketikoa mekoo. Dikane ago pade eida meameadekalepa nipa kini oa metekoi agale pedekome pinali-kiti kiwike weamuoo. ");
INSERT INTO wiu_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Panagono yapu tuapea peketepa pa eida-kama meamene. Nee ue eya takoa metekoiya moa namene. Ni edoa-mo. Panagome-kiti panagono pupu takakolopa one eni pupuke kue eya moateko toa pupu pinagome meamedekolo ni ukuno, yapu yapu pima yawameamene. ");
INSERT INTO wiu_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ali atoa ta latia pitikoika pokoli makutukoa motekete ue nee eya takoa lawetekoli padeya kekaneya latikameneya peya moa namene. ");
INSERT INTO wiu_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Nitoapa yene taneya pikoi-kiti kini tane yene latekoapa eya wa oa tamene. Akolaliyo ali atoa pawe toa talo toateko tigotokama noko wa amene. ");
INSERT INTO wiu_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Wa ta padeka pokoli makutukoa moamokolipa nipa kini yapu ludu patukakete ekete ");
INSERT INTO wiu_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","kini ta ludu piko doo tone kawake kakeneya opi tadekakilepa kiwi pubu ekete tokono, eya wa wene taneya meati. Akolaliyo ali atoa pawe toa talo toateko tigotoma noko wa eni yene tewitikoa pamene. ");
INSERT INTO wiu_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ae, wipitia ta pataka-pete Akolaliyo ali atoa takoa enoa kibu motokomepa kiwi makutukoa moamokoi yene dika dika toamene tete meoo. Nipa Sodome take yename poanele tubele-kama tokoike nami wia tete meteka toa moa patukoa tete ako mati meoo wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ae, Korasine ta-pala Besaida tata pitiki yene kiwi pubu ukumo yakoe. Kiwi pakeke ele kule tubele mati toma yakounakale mone Taia Saidone tata ludu toma yawou tokapa nipa kini namolole tewitikoa wakete palu watea kuku yotokatapea toi toka. Mone yenameke dikoa wete toi tokake kime pade nitamokoina. ");
INSERT INTO wiu_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Akolaliyo ali atoa takoa enoa kibu motoka-petepa mone Taia Saidone tata pitane ali atoa tete meoo. Ae, eni tete meteka toa moa patukoapa Korasine Besaide tata pitiki yene kiwi dika dika toamene tete meoono, nepiamene. ");
INSERT INTO wiu_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ae, wini Kapaneame take pitiki yenepa Akolaliyo kiwi a tibuke moa kamotokoono wene pianeya meki-pe. Akolaliyo nitameneya poane take poe wa kiwi moa pitikoo. ");
INSERT INTO wiu_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Anu oya-lawe kini agale yateki yenamepa anu agale-pala dekoa yateki. Kini agale yakamoa kiwi waki yenamepa anu agale-pala dekoa yakamoa no waki. Anu agale yakamoa no waki yenamepa no moa wetekaka agono agale-pala dekoa yakamoa one waki wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Yesuyo ege odepeta kadukoa wa lene kolo kakoa (72) moa wetekane ali-kiti one mekata wedianeya wakapea nekete ekete Ali Muno neke ibini wedekoa ta wa okoole poane ipono-kitameka yakoa tokoi-koli okome ");
INSERT INTO wiu_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Setanu a tibu kawa pitakitikakale enekou. Nipa katiapale tane tetepo tootapekome pitakale enekou. ");
INSERT INTO wiu_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Yakoe. Ali tania tukako kaya-kitika ka̱ala-kitika wia kautakoa ni kiwi-pala poi te̱iane ago Setanuno tele moa kawikoa toino, anu tele patu kautakoa kakete nitoi wane eni toatekoi tele lukakouna. Nitikounano, padameka kiwi toa potokamele toamoo. ");
INSERT INTO wiu_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Takoa poe wa ikili ipono-kitame yakoa tikike wedia kawameamene. Nitameneya, Akolali a tibuke mekome kini ibini one bokuke wia mekaneyano, kee wa wedoa wedia kamene wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Einata einapete Yesu Epetane Yomini patu kautakoa kakome wedikome okome Atai Ali Muno itono tibuta yopia kako ago nepala ke wane uku-ye. I uku agalepa pa nana mati keneya meki-kiti i i wa neme wene taka taka tokoyake itono peku wene toa naki-kiti wene takameke pa neke luaneya mekono, ke wane ni uku. Atai, neke widikakepa neke epene wene-kama piko toa litiapa dikou wa wene toopikanakale taatekoa toko wa Yesuyo Akolali-pala akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Nimo ootokoa okome Agetaiyo one tele patu kautakoa kama pamene wa one peku no lawetetapeka. Nopa dikane ago wa padameka wene toamikiyake Atai Akolaliyo wenepa toko. Atai Akolali onepa dikane ago wa padameka wene toamikiyake one mana noanume wene tuku. I alime i atoame Agetai wene tomotou wane takoane moane kakaku-kitameka Atai Akolali wene tiki wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Nimo ootokoa kakomepa ete-kitame yakamomotoa one oya-lawe kakoi lono ete peketapekome okome kime i enoa kakile-kiti enoa motiki ali atoapa kolotine meoi. ");
INSERT INTO wiu_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Kipala i ukumo yakoe. Kini leneme enoa kaleme yakoa tikiya-kiti ali kainya matiyame enoane yakoane toadiya wa papete nepia meaneya. Nipa Akolaline agale to̱awea akane ali-kiti ni ako meane tobou ali kainya matiyame nepia meake enoa yakoa toameneya mea pa tuma-kala nekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Mosesene totono pine to̱a olaukoa tane ago pade Yesu kakata nokomepa i agopa wene meane ago patu wa pitia yatekome okome Tikisago, edele tekene meane kama pou-pe-kale okome ");
INSERT INTO wiu_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","neme wini okolekepa Moseseno totonoke edemo wa wia mekaneya-pe. Eni agale oi motikilepa edemo wa wia mekanemo oi motoko-pe-kale okome ");
INSERT INTO wiu_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","neke Ali Muno Akolalike wedoa wene mekoa meamene. Nipa neke tepe kolotinime toa neke yominime toa neke teleme toa neke weneme toa tamene. Ni pinali neke wa wene mekoa mama motoko toapa yete pade ali atoakeka wene mekoa mama moamene wa wia mekaneya piko wa okale okome ");
INSERT INTO wiu_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","neme wini okopa nimini eke okono, wini okana toa toma pekepa nipa mea kama poo wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Yesuyo nimo okale one wene muno meaneya mekome akene tetepo takamotoa okome okome Moseseyo yete pade ali atoake wene mekoa mama moamene wapa edane ali atoake okome akeneya-pe wa okale Yesuyo eya wa pedoa agale akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Panago-kiti Yerusaleme ta piimotokome Yeriko take keti poademe pekeneya. Poademe pokomepa ali wia kinikiya odomoa pokala tane ali-kiti kotukale one mamina eya odoa moa layo toua witaneya. Nitikete einago tuademe pimotoa pekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","One eni tuademe pikata Akolalike lodo yotokoai tane ago pade ka ludu naniko nokome enetekoake pa pimotoa eka kebonoke kokotokoa patukoa pekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Wa naniko Lipai yatene ago pade einata einago tuademe pikata nokome enetekoake eina toa pa pimotoa eka kebonoke kokotokoa patukoa pekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Nitikala taneyake mone Sameria take ago ka ludu nome enekale einago tuademe pikale enetekoapa ela moa ");
INSERT INTO wiu_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","pinele pome one witaneka peto-pala gerepi po ku̱ ueta pekoa yotokatapea togotokaneya. Nititikoa one dogi kai tali waneke mekoa ali atoa dekoa piai tane yapuke aua pome pikoa meaneya. ");
INSERT INTO wiu_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Nitoapa podolikama tewitikoa poademe kakome eni yapu talo tane ago kina takuta metekome okome i ago pikoa meano ta. Nee ue eya lawetekoya-kiti i kueme topo toa motokakale adameadekalepa nipa oto wakapeane nekene nami wiane kue pade meou wa pekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Eni witane ago tuademe pikata ali tebolo nokala taneyano, odene agome einagopa one oyago tetepo takaneyano, mani ago-pe-kale okome ");
INSERT INTO wiu_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","one ela moa auapeka agopa einago eni wa okale okome nipa one eni tane toa toomoa pamene wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesuyo pato wa one oya-lawe-pala kutu pome ali atoa ta latia pitikoi take witapaneya. Nitikale atoa pade Maasa wa ibini akene atoame one yapu ne noo wa makutukoa motaneya. ");
INSERT INTO wiu_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Nitaneyake eina atoane wamene atoa Maria wa ibini akene atoa Yesuno kawane nome mekomepa one olaukoa oka agale yakakoa meaneya. ");
INSERT INTO wiu_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Nitoa mekaka Maasa one pupu nami namita kakale tokome tepe we taneya mea Yesu mekata nokome okome anu wamene atoame anu kidene nee eya takoane pupu tomotoa wawa i nome mekono, neme no ela motekepa nipa no neke wamene atoa auapeano pa wa wetekamene wa okale okome ");
INSERT INTO wiu_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","ae, anu oyatoa Maasa ne-pala ukumo yakamene. Pa pupu toatekoya-kala tokoa kake teke wene keda taneya mea tepe-pala we tokolo winipa oko. ");
INSERT INTO wiu_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Padele epetaneledo katekoa neme toameadeko. Enilepa Mariayo anu i laweteku peku noada wa yakakoa meko. One i yakoa motokoya padame katekoa moamele toamoko wa Yesuyo Maasa-pala akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Wa padepete Yesu padeka kowitoa meaneya. Kowititikoa mekale one oyago pade nokome okome Yoneyo one ue motokane yene kowitikete toatekoile olaukane toa toto olaukoa ta-kale okome ");
INSERT INTO wiu_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Akolali kowitiketepa eya wa kowitikala tamene. Atai, neke ibinipa ali atoame paya tetepo takameneya kei pimotono ta. Neke ali atoa pawe toa talo toano ta. ");
INSERT INTO wiu_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ta patako toa-kama tone noateko nee moa lawetekala tamene. ");
INSERT INTO wiu_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Tone tokoo poaneleke po letu mekakana keetapeamene. Toto-pala poanele tokoi yene peya kini eni tokoi poaneleke totome po letu mekakoo toa keetapekete tekete ni oko. Padele padeleme toto etepea liamomotono, yopikoa kamene wa Akolali kowitikala tamene wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Yesuyo enimo ootokoa okome anu oya-lawe kiwi panago tube likonu ta likale-kiti neke oyagono yapu peke eke anu oyago pade padeka poademe anu yapu dekoa pinoko. Nitikoyake one lawetateku nee piamokono, palawe wane tebolo nami kakoane mouno mea ta wa neme kowitikale okome ");
INSERT INTO wiu_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","anu kago keteaneya kako. Anu mati-kitika no-pala atu pia mekino, kamoane meamele toamokono, teko takamea wa-kiti oo. ");
INSERT INTO wiu_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nimo okaleka mano wa neme oai toa kakale enekome kamoa nokome neke moateko toa-kama moa menoo. Nipa ne i agopa one oyago kakono, moane menada wa moa menokoya mena. Pa neme mano wa oai toa kakaleke nitoo. ");
INSERT INTO wiu_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Nipa kipala eya wane ukuno yakoe. Akolali kowitoa kakolipa yakoa too. Padeya-kiti tuku toa kaketepa enamuoi. Kago wi wi toa kakolipa pinagome kago pekanokale tuapea poi wane uku. ");
INSERT INTO wiu_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Eni uku toa kowitoa kaka agomepa nipa one eni kowitikaya moo. Padeya tuku toa kaka agomepa nipa one eni tuku tokaya enamuoo. Kago wi wi toa kaka agopa nipa pinagome pekanoo. ");
INSERT INTO wiu_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Anu oya-lawe kiwi panago neke mana agome mou pade nouno mea ta wa-kiti okalepa ali tania tukako kaya pade neme yotokoa meoo-pe. ");
INSERT INTO wiu_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ogada mu nouno mano wa-kiti okalepa ka̱ala pade yotokoa meoo-pe. Nitamoo. ");
INSERT INTO wiu_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Kiwi poanele-kala tiki-kitameke kini mati-kiti epetaneya takoa mekala tiki. Epetaneya takoa moa mekala tiki toa moa patukakome a tibuke meko kiniketaiyopa one Epetane Yomini kiwi meoo. Nipa one kowitikoi ali atoake awipoano pa wa moa wetekoo wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Wa padepete Yesuyo panagoke awitane ipono takoa pa wa wetekaneya. Agale amele toamene ipono eni takoa wetekaneyake eina agale wamene agome agale titia okale yatekete e ali atoa wene kainya pianeya kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Nitikete padeka-kitame ekete beita ipa ako odene meko tobou ipono Belesebulene tele patu kautakoa kakome ipono-kiti takoa wetekako wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Wa padeka-kitame likoa enekete ekete neke tokolepa Akolali patu kautakoa kake tadekalepa a tibuke padele tubele witakamotono ta wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Nitikoli kini tepene pikoi wene tetoa enekome okome ako odene meko tobou agoke lukoa meki yenedo kako poi toa meketepa wete atutapeoi. Odene yapu keneke pitiki-kitika ete oto wa puutakutukoa meketepa nipa yapu-kiti kilia tadatapeou toa tadoa pootapeoi. ");
INSERT INTO wiu_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Edikoapa Setanuno yatene puutakutukoa meketepa edoa mea kamotoa-pe. Mea kawamoi. Noanupa eni tobou ipono Belesebulene tele patu kautakoane kakene ipono takoa poe wane wetekakala tuku wa wini iki. ");
INSERT INTO wiu_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Noanupa Belesebulene tele patu kautakakene ipono-kiti wetekaku wa ikino, kini totono litia tiki ali-kitame ipono-kiti takoa wetekaketepa te patu kautakoa kakete tiki-pe. Anume takoane wetekakene tukuna toa tikino, kime no ina akoa kakinapa kapene wakoa akediki. ");
INSERT INTO wiu_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Akolali patu kautakoane kakene ipono-kiti takoa poe wane wetekakala tukuno, Akolaliyo one ali atoa pawe toa talo tokotapa kiwi pake wini witadeko. ");
INSERT INTO wiu_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Telekagome tue poyo dolo eya mana patu pikoa mekome yapu yopikalepa onekeya peyapa kode moameneya pa eida pia kawoo. ");
INSERT INTO wiu_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Wa one tele moa patukoa tele tube mati tane ago nokome einago moa kautakome eya too. Einagome one tue poyo eya ika iyamepa ete yene wiane litiou wa pikoa kakanakeya-kiti odoa moa onekeya-pala kode moa aua pokome one yene tatia meetapeoo. ");
INSERT INTO wiu_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","No-pala lipua meamoko agomepa nipa no-pala poi eni teigome toko. No auapeamoa no mekuta ali atoa koukoa mekamoko agomepa nipa ali atoa tadekoa litikome toko wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ipono pade panago takoa pokomepa eya toko. One koo meatekota ta pitamene ta ludu tuku toa kawa teko tokolo wako. Nitoa wakomepa one takoane wawane nokounata wakapeane pone mepou wa wene piitikoa ");
INSERT INTO wiu_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","wakapea pome enepokolo einata do pokoa kalotokaneya kakedeko. ");
INSERT INTO wiu_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Nitaneya kakolo enemotokome tuku topokome ipono-kiti tatono kakoa (7) one poanele natele tomotoa poanele pine wia tagoa tiki ipono-kiti enamua einata aua noko. Aua nokolo einakagoke awitikete awitikili tokome one namolo poanele nateleka toa meake wipitikomepa poanele tubele-kama toma yako wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesuyo enimo ootokoa kakale atoa pade ali atoa oboa kakoita kakome kayo okome okome i ago ne opia pikoa mea adu tanikakoa meane atoapa kolotine meko-kale okome ");
INSERT INTO wiu_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","winipa nimini okoyake kolotine wedoa meki-kitipa Akolaline agale yakatekoa toma yaki-kiti eni wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ali atoa Yesu kakata note-kala apua takoa kakoli enekome okome ipete kaki yename poanele wedoa toma yakina. Nipa no i ago Akolali patu kakedekalepa padele tubele mati witakamotono ta wa likoa enekina. Nitikiyake Yona einago-pala tubele mati tane toa tokale enoi. Padele pade enamoi. ");
INSERT INTO wiu_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Akolaliyopa i ago Yona one patu kautakoa kakedeko wa Ninepa yename wene tomotoapa Yona einago-pala padele tubele mati taneya. Eina toa Akolaliyopa one patu kautakoane kakedeku wa ipete kaki yename wene tomotoapa Yona-pala tokanakale no Ali Yatenane Oyago-palaka padele tubele mati toono, nepiamene. ");
INSERT INTO wiu_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ae, Akolaliyo ali atoa takoa eneka-pete Siba take ako meane tobou atoa kamokoa kakome okome Yesu kaka-pete mekoi Yu yene kime toa potokaneya wa kiwi akoa agale oo. Ni edoa-mo. Eina atoa mone atoameke Solomonono peku noademe ta padeka mati mea nekeneya. Nitaneyano, kipala ukumo yakoe. Tobou ago Solomono keku kamotoane no ako ago nukuyake kime pade anu peku noamadete waki. ");
INSERT INTO wiu_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ae, Akolaliyo ali atoa takoa eneka-pete Ninepa take yeneka kamokoa kakete ekete Yesu kaka-pete mekoi Yu yene kime toa potokaneya wa kiwi akoa agale oi. Ni edoa-mo. Yonayo Akolaline agale Ninepa ta ludu mo wima pokale yatekete eni yene Akolalike tepe kolotini pekoa piitapeneya. Mone yenameke nitaneya. Nitaneyano, kipala ukumo yakoe. Yona einago keku kamotoane no ako ago nukuyake Yu yene kime pade anu peku noamadete waki wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Panagome-kiti one labo udukakomepa nipa bokosi wane keneke potipiamoa okolo petene moa pekoa kautamoa tokome eya toko. Labo piatiki walaike-kama moa piko. Nipa ali atoa yapu tuapea nekete eni pa̱pa keleyo toa kakale enemotoa ni toko. ");
INSERT INTO wiu_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Eina toa labo toele yapu pa̱ takalogou toa kini lenetame tepe kolotini eya pa̱ takalogako. Lenetado epetaneya kakepa nipa tepe kolotini pa̱ takatapeneya kawoo. Ae, neke leneta poaneyatado kakepa nipa tepe kolotini yomiyomume agopa takatapeneya kawoo. ");
INSERT INTO wiu_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Tepe kolotini pa̱ takatapeneya meku wa oake yomiyomu keneke mekaya tokale wedoa meamene. ");
INSERT INTO wiu_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Yomiyomu dedeyaka toameneya tepe kolotini pa̱ takatapeneya mekopa nipa labome pa̱ takalogou toa ne pa̱ takatapeneya kawoo wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesuyo nimo oa kakaka Parisi ago padame one yapu nee noano noo wa okale nipa pata wa pokome nee mekome nakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Nee noa mekale Parisi agome enekale one yono uele tadameneya pa mekome nakale enekome wene kainya pianeya meaneya. ");
INSERT INTO wiu_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Nitaneyake Ali Muno agome okome ne-pala ukumo yakamene. Parisi ali-kiti kini mete okolo eya abe kogilepa ekolo abe pa kamotoa lede tokoo abe ko̱otapekala tiki. Nipa kepeneme epeteku wa oake kini tepene panagoneya moadiya wa tepi moa enika eni poanele toma yaki. ");
INSERT INTO wiu_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ae, paya nou toa mekete tiki. Akolaliyo tokoo pikoya-kiti latikilepa ekolo pikoya-kitika latikome latia pianeya. Nitaneyano, tokoo ekoloka abe ko̱otapeamediki. Enipa nimini uku-pe. ");
INSERT INTO wiu_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Kini mete okolo kagono keneke pianeya-kiti tatikoa ponopene ali atoa meteketepa nipa kini mete okolo eya abe ko̱otapeneya piou toa mea epetekoino, nitamene. ");
INSERT INTO wiu_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ae, Parisi ali-kiti kime dika dika toamene tete moino, nepiamene. Ni edoa-mo. Kini yamanu ludu witakoya nee deya-kiti pilia moa oi moteketepa yonota tua pikolopa odene katekamoa ipa Akolalineya wa takoa pikakala tiki. Ae, ali atoame tanele ki̱yotokoa takoa enoa Akolalike wene mekoa mea enika enile tobou kakoa tamedikiyake toamekete pa natele tokala tiki. ");
INSERT INTO wiu_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ae, Parisi ali-kiti kime dika dika toamene tete moino, nepiamene. Ni edoa-mo. Losu yapu peketeka ibini akene yene meatikita meada wa pote mepokala tiki. Makesikeka ali atoame Tikisa ago Tikisa ago ke wa kiwi kei pimotada wa yakala tiki. ");
INSERT INTO wiu_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ae, Parisi ali-kiti kime dika dika toamene tete moino, nepiamene. Ni edoa-mo. Kipa tuane yene oloyo toai taneka tetepo taneya meki. Nitimotoake ali atoame enameneya paya nou toa teteponokala tiki wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Nitaneyake Mosesene totono pine to̱a olaukane ago padame Yesu-pala okome Tikisa ago winipa anu yagono-mikiti-pala dekoa akake oko-kale okome ");
INSERT INTO wiu_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ae, Mosesene totono pine to̱a olaukaki ali-kiti kime dika dika toamene tete moino, nepiamene. Ni edoa-mo. Ali atoa padeya padeya keda tokoya kini kotomaneke moa aukou toa kini wene keda takakala tiki. Nitikiyake eni keda nateya deyaka yapetekoa ate motokamiki. ");
INSERT INTO wiu_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ae, dika dika toamene tete moino, nepiamene. Ni edoa-mo. Akolaline agale papete to̱wea akane ali-kiti oloyo taneka kalotokoa yapu deya wikakakala tiki. Kini kaua-mikitame eni ali-kiti wia tukama nekeneyake tiki. ");
INSERT INTO wiu_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Nipa kini kaua-mikitame tanelepa epetanele tane tetepo takoa tiki. Kini kaua-mikitamepa Akolaline agale to̱awea akane ali-kiti wia tukama nekeneya. Kimepa eni ali-kiti oloyo taneka kalotokoa pikala tiki. ");
INSERT INTO wiu_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Kime nitoi wa Akolali wene muno meaneya mekome eya wa oa pianeya. One agale akatiki ali-kitika one agale oa aua yawatiki Aposelo ali-kitika kiwi mekoika moane wetekakala tou. Nitikolu nokoli enekete Yu yene kime padeka-kiti wia tukoa wa padeka-kiti tete mekala toi wa oa pianeya. ");
INSERT INTO wiu_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Namolo namolo titimoa kini kaua-mikitame one agale akane ali peya wia tukama-kala nekeneya. Eni wia tukama nekeneke nami papete wiameneyake opi kabe koukoa nami wiapa ipete kaki-kiti kiwi Akolaliyo kibu moono, nepiamene. ");
INSERT INTO wiu_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Titikilepa wamene agome Ebele wia tukaneya. Wipitikilepa tobou losu yapu keneke Sekaraia wia tukaneya. Nipa eyata pake Akolalike lodo yoai tane walai-pala tobou losu yapu olege takoa tipi tane yapu lukuta eniyata pake Sekaraia wia tukaneya. Eni ali-kiti wia tukama nekeneke nami papete wiameneyake opi kabe koukoa nami wiapa ipete kaki-kiti Akolaliyo kibu moademe toko. ");
INSERT INTO wiu_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ae, Mosesene totono pine to̱a olaukaki ali-kiti kime dika dika toamene tete moino, nepiamene. Akolaliyo talo toko take one peku nopadete ali atoa kago ketepono patukoa ponadete tokoiyake eni kago peatekoi kii kime to̱a pokoina. Nipa kiwi patukoa poamadete wakoiyake ete ali atoa patukoa ponomotoa papukamokoina wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Nimo oomotokome pokale Mosesene totono pine toa olaukane ali-kitika Parisi ali-kitika one-pala timini luaneya i i wa pitia yakoai toma pekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Nipa natemoka omotadiya wa kakete one likoa enoai toma pekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Eina ali atoa ege egeta kadukoa apua takakete ete oto wa muku muku toa kakoli enekome Yesuyo one oya-lawe-pala okome Parisi ali-kiti kini yisi kugu kiwike weamutukaya kekatekoa yamene wane uku. Enipa wene takuta pianeya mekike ekene uku. ");
INSERT INTO wiu_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Padele padele kaukoa toma yakenele peya naniko keleyo witatapeoo. Padeya padeya paigakoa pianeya-kitika naniko keleyo pikale peyame enetapeoi. ");
INSERT INTO wiu_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Nipa likonu kakete okoi agalepa ali atoa lou pa̱ke kakete yakatapeoi. Ekolo kini yapu keneke kago keteketikoa kakete oi oi wa okoi toa pade-kiti yapu yalini lewia kakete i i wa to̱awea ootapeoi. ");
INSERT INTO wiu_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Anu oya-lawe kiwi-pala i ukumo yakoe. Yete pade ali-kitame kiwi wiou wa lama moa lagotoa tukatekoapa wa naniko kiwi-pala padeleka tamele toamoo. Dikaki ali-kiti piti moameamene. ");
INSERT INTO wiu_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Kini piti moatiki agopa eya ago. Akolaliyo panago wia tukatekoa poane take pa wa moa pitikamele tokono, Akolali einago piti moamene wane uku. ");
INSERT INTO wiu_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Dee ini deya ko kakoa (5) topo toa kue motikilepa dedeya tuane kue takuta odene mokala tiki. Enipa nimini ukutu-pe. Dikane ini deyapa dedeyaka Akolaliyo odeneka katekameneya peya talo toa kako. ");
INSERT INTO wiu_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ni ago Akolaliyo anu oya-lawe kini wagoke witako pineka kako toa oi moa talo toa kako. Ni agome ini deya-kiti mamapa moake paya tetepo takakome kipa one kolotini yene wa wedoa mama moa talo toa kakono, ete-kitame kipala padele toatikilekeka piti moameamene wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Kiwi-pala i ukumo yakoe. Panago ali atoane leneke kakome no i agono peku noane tuku wa to̱awea okalepa eina toane no Ali Yatenane Oyago Akolaline edelo ali-kitane leneke kakene einagopa anu peku noa tokago wane to̱aweane ou. ");
INSERT INTO wiu_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Wa panago ali atoane leneke kakome no i ago kote tokolo waku wa okalepa eina toane no Ali Yatenane Oyago Akolaline edelo ali-kitane leneke kakene einagopa kote tokolo waku wane waou. ");
INSERT INTO wiu_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Panagome-kiti no Ali Yatenane Oyago tea agale akakalepa one eni poanele tokake po letu mekakana Akolaliyo oyake kekile too. Wa panagomedo one Epetane Yomini tea agale akakalepa nipa one eni poanele tokake po letu mekakana Akolaliyo kekile toamoa etene kibu moo. ");
INSERT INTO wiu_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Anu oya-lawe kipa ete-kitame kini losu yapukeka tobou ali-kiti mekoikaka Kanosolo ali-kiti mekoikaka lia aua poi. Nitikoli peketeka edemo uku patu, edemo topo takoane uku patu wa tepene li̱ li̱ wa kamotoa meameamene wane uku. ");
INSERT INTO wiu_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Nitikoi-petepa Epetane Yominiyo kini oatiki toa i i wa wene taka taka too tokolo tekene ni uku wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ali atoa kabeta pake kakome panagome Yesu-pala okome Tikisa ago, agetaiyo kadimo okana toa anu wamene agome toameneya toneketaineya tatia no meamokono, neketaiyo kadimo okana toa ta wa neme akamene wa okale ");
INSERT INTO wiu_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesuyo kikoa okome okome kini koiso yatekamene wa no teyo moa kakaneya-pe. Kinikiya tatikatakutukamene wa no teyo takoa motaneya-pe. Padame pade mena wa Yesuyo ootokoa kakome okome ");
INSERT INTO wiu_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","padeya padeya moadiya wa tepi motokayano, wedoa yamene. Panagome-kiti one kamoya moa auma kakakomepa one eniya patu edoa kautakoa mea kamotoa-pe wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Nimo ootokoa kakome agale pade pedoa okome okome kamo tokago pade one ipe nee kakoya witakome leau akatapeneya. ");
INSERT INTO wiu_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Nitaneyake one nee kakoya wakoa moa lobutua piatekata toamokale tokome edeku patu wa wene kibutukoa mekome okome ");
INSERT INTO wiu_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","ile tou. Namolo yapu-mene ke̱aweane eni-mene moomoane awitikakoane liapeane wiou. Nititikoanepa witi ku̱ anukuya eya kuya peya lobutuane piane tagatapeou. ");
INSERT INTO wiu_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Nitikene ekene anukuya tubeya eni pikuno, mali peya mati ponomotoane eniya patu kautakoane kama puku. Opi poti kilikoane mekene nee ue eya noane piane wediane meou wane ou wa kamo agome akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Nimo akeneyake Akolaliyo one-pala okome paya nou toa meke wini okono, opii ta likale tuke tuoono, neke nodokapike lobutukapianeya teyo moa noo-pe. Pinago ne noamoo wa Akolaliyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Nipa panagome one kamoya moa auma kakakomeke Akolalinele takamokalepa Akolaliyo one peku alekoa nakene ago tetepo takoa waoo wane ekene uku wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yesuyo one oya-lawe-pala okome okome kini kepene mama moameamene. Nipa noateku neepa edoane moane naku patu, kawateku maminapa edoane tatepe toane motuku patu wa edikoa wene keda taneya meameamene. ");
INSERT INTO wiu_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Akolaliyo kini tigini yominita tobou kakoa mama moapa kini noatiki nee mamina eya kekuya tetepo takoa yopiko. ");
INSERT INTO wiu_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ini pukaneya yakete tikile enekoapa eya wa wene taneya meamene. Nipa edikakiya. Nee lene matamoa ipe kakoya nee wakoa moamoa kini nee moa piatiki yapu eya wiamoa tikiyake Akolaliyo talo toa egeteko. Akolaliyo ini eya kekuya tetepo takoa mama moapa anu oya-lawe kiwi akoya tetepo takoa wedoa mama motoko. ");
INSERT INTO wiu_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Anu oya-lawe kiwi panago tukina toane tuamekene lou pini odeneka pa meou wa tepe ate keti enoai tekeka padele tamele toamokolo tukina toa tuoo. ");
INSERT INTO wiu_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Natele eni tamele toamokono, eteleke edoa mama moamoo. ");
INSERT INTO wiu_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Taage kaluga eya witakole enekoapa eya wa wene taneya meamene. Nipa edikakoya. Po itia mamina latia toamokoyake wedoa kalaneya witako. Ako odene meane tobou ago Solomonoyo mamina epetaneya-kama moa kakome wedoa kalakitikoa kakala taneyake tage kaluga eya kalaneya moa patukamele toameneya. ");
INSERT INTO wiu_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Taage kaluga eya ei li ludu pa tekei witako. Nipa opi tou toa tekei witakoyake podolikama alime wakoa moa toele pitikako. Edikoa pa tekei witakoloka Akolaliyo talo toa kalotokako. One dikane ago tokome kini kawatiki mamina moa meoono, dekolo wene keda taneya meki. Ae, Akolalike inapa wedoa wene tugameneya mekiya tadiki. ");
INSERT INTO wiu_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Nee eya edoane moane naku patu, ue eya edoane nomoane naku patu wa enika eniya mama moameamene. Nipa wene keda taneya meameamene. ");
INSERT INTO wiu_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ta piko peyake mone yatene ali atoame enika eniya mama moma yakino, kime pade nitameamene. Anu oya-lawe kini wenepa kiniketai Akolaliyo moademe tokoto-mo. ");
INSERT INTO wiu_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Nipa one talo toko take mekene toateku peku noada wa wene piitikaneya meamene. Nitoa mekolipa kini noatekoi nee mamina eyaka Akolaliyo motokoa meoo wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Anu oya-lawe kipa sipi sipi kai keneya natetekoa mekino, kiniketai Akolaliyo one talo toko taapa kinino noe wa yameademe okono, one epene wene piko toa litia tokome tokono, piti tokolo meameamene wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Kinikiya peya topo toa kue moa ponopene yene tatia meetapeamene. Kini kue uatiki kapa kego noamateko ka-kama takoa moamene. Nipa kini kamoya a tibuke auma kakou toa epetanele toma pamene. Kini eni kamoya a tibukepa kode agome kode moamoa ti̱yome te̱ia noamoa toko. ");
INSERT INTO wiu_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Eni ukupa, ali atoa kini kamoya piko takepa wene piitikaneya yakili tekene ni uku. Nipa kini kamoya a tibuke auma kakane tetepo takoa meamene wane ekene uku. ");
INSERT INTO wiu_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Tobou agonole takada wa matiu deka deka toa kawa labo-pala udukoa wedoa nodokoa kamene. ");
INSERT INTO wiu_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Nipa eya yename tiki toa tamene. Tobou ago pade panagono atoa motokakete toge kikoita lobutupome mea wakapea nomotoa one pupu yename wedoa nepikoa kaki. Nipa one nokome kago wi wi tokoka eni eni kago pekapadete nepikoa kaki. ");
INSERT INTO wiu_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Atu piameneya wedoa nepikoa kakili enekome tobou agome eya toademe toko. One pupu mamina moa kakome nee noatino noe wa kayo oa moa mekatapekome kini nee takoa lawetademe toko. Nipa ke wa kini kolotini natekademe toko. ");
INSERT INTO wiu_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Likonu toe lene taku takoa motiki-peteka tebolo takoa motiki-peteka tobou ago nokome enekolo wedoa nepikoa kakili enekome ke wa kini kolotini natekademe toko. ");
INSERT INTO wiu_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Enikepa eya waneka ukuno, yakamene. Yapu pinagome-kiti onekeya kode moa poatekago ipete noo wa wene too tokapa yapu bulukoa onekeya-kiti kode motokaya tokale lene kia wedoa nepikoa kawoo toka. ");
INSERT INTO wiu_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Eina toane no Ali Yatenane Oyago kotikatapeane nouno, wedoa nepikoa kamene wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Yesuyo nimo okale Pitayo okome Ali Muno neme wini pedoa oko agalepa neke oya tone takoa oa meteko patu. Ali atoa peya kikilikoa oa meteko patu wa okale Ali Muno agome okome ");
INSERT INTO wiu_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","tobou agonole-kama wedoa wene toa takako agoke ukuno, yakamene. Tobou agome dikane ago-pala eya wa oa too. One ali atoa neme yopikamene wa oapa kini nee eya noatekoi toa oneme-kama tatia lawetekamotoa moa kakoo. ");
INSERT INTO wiu_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Nitimotokome ta padeka pome mea wakapea nokome enekale tamene wa oa pokanakaledo pa takama pekedekale enekomepa ke wa one kolotini natekoo. ");
INSERT INTO wiu_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nipa onekeya peya neme-kama yopikamene wa moa kakoo. Enipa nimini uku. ");
INSERT INTO wiu_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","One pupu takakagomedo onekele takoa potokakomepa eya tadiya too. Tobou ago wete wakapea noamoo wa tobou agono pupu takakoi ali atoa layo toua wia nee bia ueka nokoa pia leau oa yawa too. ");
INSERT INTO wiu_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Paya nou toa nitoa mekaka tobou ago wakapea kotikatapea nokome einago dika dika toamene tete meoo. Nipa tobou agonole takoa potokane yene pitikoika moa kakoo. ");
INSERT INTO wiu_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Tobou agono wene pikale wene tokomeke nodokoa meamoa one okaleka toamoka agopa tobou agome kibu motokome layo toua wedoa wikala too. ");
INSERT INTO wiu_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","One wene pikale wene toamoka agome padele kibu moatekale tokalepa tobou agome kibu motokome layo toua wedoa wiamoo. Nipa Akolaliyo padele padele toatekale yametekagomepa one eni yametekanakale wedoa toma pamedeko. Pade-kitame kinikiya keda takoa metekoli motokagomepa one eni motokana toa ete wa metekome etene ako meamedeko. Nipa ako mano wa okoli ako-kama meamedeko wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Itono ludu toe pitikadene nekene uku. Ae, toe wete udukamotadiyano wene pikene uku. ");
INSERT INTO wiu_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ue mou toane dika dika toamene tete moadene meku. Ae, enile wete taatekameneyake wene keda mati taneya meku. ");
INSERT INTO wiu_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Noanumepa ali atoa poi teigoa wawa poti kilikoa memotoane nekedeku wa wene piki-pe. Nopa nitateku ago mena. Ali atoa puutakutukoa memotoane tekene ni nokou. ");
INSERT INTO wiu_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Opi titimoa odene yapu pitiki ali atoa ko kakoa (5) tadiya puutakutukoapa takutame pade wene pia tebolome pade wene pia puutakutukoa meoi. ");
INSERT INTO wiu_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Etena-kiti etene pade wene pia mana pade wene pia ete oto wa letetakutukoa mea ni nina-kiti nine pade wene pia kono pade wene pia letetakutukoa mea ni atoa-pala anane nine one kaua atoata ete oto wa letetakutukoa mea tokala toi. Ali atoa nitoa memotoane ni nuku wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesuyo eida oboa kakene ali atoa-pala eya waka akeneya. Lou pipoko lono wedo witoa nokolo eneketepa ta eni noo tadeko wa ikina. Nimo ikina toa taatekoa ta eni noko. ");
INSERT INTO wiu_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ni pupulege keika lono titimoa nokolo eneketepa nipa poto tubeya too tadeko wa ikina. Eni ikina toa taatekoa poto eni toko. ");
INSERT INTO wiu_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ae, wene takuta pianeya meki yene kipala i ukumo yakoe. Itonokeka a tibukeka padele witakole eneketepa ile taatekoa toatekolo toko wa kime tetoa eneki. Nitikiyake ipete kiwi pakeke witakolepa ile taatekoa toatekolo toko wa tetoa enamiki wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Ipa poanele tadeko ipa epetanele tadeko wa kini weneme dekolo takoa enamiki-pe. ");
INSERT INTO wiu_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Panagome-kiti i ago neme poanele tokanano, pata wa koiso yatekakago mekata aua pokalepa eya tamene. I ago ame koiso wamatono, odene weneta piata wa oa enamene. Nitameneya eniledo toamokalepa koiso pitia yatekakago mekata lia aua pokale pitia yatekatekoa one poyo ago metekale moa ne po yapu pitikoo. ");
INSERT INTO wiu_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nitikale neke take oto noateka kuedo odene tuane kue waneka katekoa wete meameneyake nepa eida pa pioo wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Einata einapete Galili yene-pala tanemopa eida kakoi ali padeka-kitame Yesu-pala to̱awea akeneya. Nipa Galili yename kini sipi sipi kai wia Akolalike lodo yoa kakakoa Pailaseyo wia tukapoatino poe wa one poyo ali-kiti moa wetekanemo i i wa to̱awea akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Nitikoli yatekome Yesuyo okome Galili takepa ete yename poanele tane toa moa patukoa o yename poanele tubele taneya tokome tete mati ni motaneyano wene piki-pe. ");
INSERT INTO wiu_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Kipala i ukumo yakoe. Kini namololedo tewitikoa Akolalike tepe kolotini pekoa pia toameketepa kimeka dika dika toamene tete moa tuei. ");
INSERT INTO wiu_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Siloame takepa ludu yapu ta enapeatekoiya yapu kilikome tanemo yakamokoiya-pe. Kalabe kakoa (18) ali atoa eni kilikome witaneya. Yerusaleme takepa ete yename poanele tane toa moa patukoa o yename poanele tubele taneya tokome ni kilikome witaneyano wene piki-pe. ");
INSERT INTO wiu_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Kini namolole tewitikoa Akolalike tepe kolotini pekoa pia toameketepa kimeka dika dika toamene tete moa tuei wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","7","Yesuyo nimo ootokoa kakome agale pade pedoa okome okome ipe pinago pade one gerepi po ipe pakeke yomo piki pade eida mataneya kakeneya. Ku̱ wete tuko patu wa enepokale ku̱ tuameadeka. Nitadekale ipe talo takaka ago-pala okome mali tebolo ponokale-kama ku̱ tuko patu wane enenokala tokounake ku̱ wete tuamokala tokono, dekolo ipe pakeke pa kamotoa toko-pe. Wete ka̱wa pitikamene wa okale ");
INSERT INTO wiu_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","talo agome okome Ali Muno opa ka̱wa pitikamato. Tokene tuku kakoa (12) ponomotoane wedoane lati lati toane kai te tagolota moane pitikoai tou. ");
INSERT INTO wiu_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Nitikoludo ku̱ tukale enekepa pa kamota. Nitameneya ku̱ tuamokalepa nipa ka̱wa pitikato wa talo agome akeneya wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ko mea pupu toamene-pete pade Yesu losu yapu pade pome olaukapaneya. ");
INSERT INTO wiu_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Eida atoa pade meaneya. Einatoapa ipono awitaneya tokome mali kalabe kakoa (18) ponoka toa mukiti tukuaneya ki̱yotokakamele toameneya meaneya. ");
INSERT INTO wiu_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Einatoa enekome Yesuyo nee noo wa kayo oa motokome okome anu oyatoa neke taneya mea kakene yenepa opi takoa pokolo uku wa ");
INSERT INTO wiu_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","one yono einatoake pikale eina eina mukiti ki̱yotokakaneya kawa Akolali kei pia kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Nitikale enekome losu yapu yopikagomepa i ago Yesuyo tone ko mea pupu toamateko-peteka i atoa eni latekako wa wene poaneya meaneya. Nitoapa e yene-pala okome okome tone pupu tikilepa ko melepu (6) kakoa-peta-kama tokoyano, enipete-kama oyake latekamotoa namele tokono, tatono takoa (7) ta patako-petepa tone pupu toamateko-pete nitamele toamoko wa wene pokome okale ");
INSERT INTO wiu_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ali Munagome eni yene peya kikilikoa okome okome winipa wene takuta pianeya meki. Tone ko mea pupu toamateko-peteka kini pitimekawe kai dogi kai eya kolago taneta akolono ue mekoka ue nomotoa aua pokala tiki. ");
INSERT INTO wiu_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","I atoapa Eberameke taagene atoa mali kalabe kakoa (18) ponoka toa eina yene taneya mea kamotoa Setanuyo moa labakaneya. Nitaneyano, tone pupu toamateko-peteka one pa pia kakene yene dekolo takoane wetekamotoa wamiki-pe wa okale ");
INSERT INTO wiu_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","one-pala wene poaneya meane-kiti yaame tuaneya kakeneya. Nitaneyake ete peyame one tubele toma pekeneleke ke wa wedia kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesu pa eida kakome okome Akolaliyo one ali atoa pawe toa talo tikilepa edoa toko patu. Edeya wane adeka piane uku patu. ");
INSERT INTO wiu_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Kalipe lene deya panagome-kiti yamanu moa pitikakalepa tumia witakome wetini tootapeneya kaka. Nitaneya kakalepa ini pukaneya note yeneneke yene wikala taneya wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesuyo eya waka akeneya. Akolaliyo ali atoa pawe toa talo tokolepa edeya wane adeka piane uku patu. ");
INSERT INTO wiu_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Pade atoame-kiti yisi kugu deya moa palawe kugu odene bekoke pitikoa eletekaneya. Nitikalepa palawe kugu keneke alama pokome eina palawe mono mono akatapeneya wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu Yerusaleme poademe pokome pitikali pitikoikaka ali atoa natetekoa pitikoikaka pima pekeneya. Nipa Akolalinemo i i wa olaukama pekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Nitima pokaka panago oneke nokome okome Ali Muno eya wane ne yatekene ukuno, yakamene. Akolaliyo ali atoa toa motikilepa natetekoa toa motoko patu-kale okome ");
INSERT INTO wiu_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Akolali mekota poatiki ka keteponopa kago nateya edetekaneya kakono, eni kago keneke patukoa ponadetepa wili toa kamene wane uku. Ali atoa peya matiyame patukoa ponadete wili toa kawa teko tokale wakala toi tokolo ni uku. ");
INSERT INTO wiu_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Yapu pinago kamoa pokome kago ketepono loko pitikoo. Nitikale kago keteaneya kakale ali atoa kiwi eida note akolono kago koloikoa kakete ekete Ali Muno Ali Muno i kago wete pekanamene wa okoli okome manika kawa niki-pe. Kiwi wene toamuku wa oo. ");
INSERT INTO wiu_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Nitikale ekete nepala odeneya opia mekete nee ue eya nakoonano, nepa tone yapu ludu noke olaukanokala tokonano, wene toamuku wapa dekolo oko-pe wa okolika yapu pinagome okome ");
INSERT INTO wiu_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","kiwi kawa nikita wene toamukuno, poanele-kala toa kaki-kiti no wete tewitikoa poe wa wia lititapeoo wa oo. ");
INSERT INTO wiu_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Eidapa komome kabe kawamokale komo ka̱ta pitikoa kawei. Nipa Eberame-loe Aisake-loe Yekobe-loe Akolaline agale to̱awea akane ali-kiti eni yene peya Akolaliyo talo toko ta eida e kaki wa enoa kagoke poadete note kakolika wa kiwi etepea wia lititapeoo. ");
INSERT INTO wiu_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Yu yene kipa oyake patukoa ponamele toamokaleka e ku mone yatene-kitipa lou witia noko lonoka lou pipoko lonoka yekeika yukukataka kawa note eni kago keneke patukoa ponete Akolaliyo talo toko take toge lobutukala toi. ");
INSERT INTO wiu_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ali atoa padeka-kiti ketea kawake wa namolo ponete kaponoi. Wa padeka-kiti namolo kawake wa ketea kawa ponete kaponoi wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Einata eina-pete Parisi ali padeka-kiti Yesu eni kakata nekete ekete ako tobou ago Erodeyo ne wia tukademe okono, i ta wete tewitikoa pa-koli okome ");
INSERT INTO wiu_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","wini agale oa yotokako agokepa agale pade oane wetekakuno, akapoe. Opi podoliyotapa ali atoake awitane ipono takoane wetekoane yene tane ali atoa latekoane toane wa ta tebolopeta patakale anu toatekoule peya takoane wipitiou. ");
INSERT INTO wiu_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Nipa opi podoliyota eko patepeyo-kitika enile toma pekene Yerusaleme take pamedeku. Ni edoa-mo. Akolaline agale papete to̱awea akane ali peya Yerusaleme ta eida-kama wia tukakala taneyano, noka eida tuadene eni pukuna. ");
INSERT INTO wiu_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ae, Yerusaleme ta neke wida pitikoi yenamepa Akolaline agale to̱awea akane ali-kiti wia tukama-kala nekeneya. Ni Akolaliyo neeke wida moa wetekane ali-kitika kueme ka̱ua tukakala tane toa opii pa tiki. Nitaneyake ogadame idini-kiti pawena keneke lumoa pitikou toane tekene neke wida meki yene pawe toane moadene tokounake ko̱ite katite toa wakala tokoina. ");
INSERT INTO wiu_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ae, Yerusaleme ta nepa pa tumu tokamotoa neke wida pitiki yene to̱a pootapeadete tiki. Ae, no papete wa enekileka toamoo. Nipa no i agopa Ali Muno patu kautakoa kama nokono, Akolali neme wedoa mekamene-ye wa no wete wa makutukoa moameneyake anu lene timini wa pade enamoo wa Yesuyo Yerusaleme ta-pala akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Yu yene ko mea pupu toamene-pete Yesu ibini akene Parisi ago padane yapu nee noademe pome mepaneya. Nitikale eida oboa meane yename lene tuaneyame wia meaneya. ");
INSERT INTO wiu_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Eidapa tigini yoa lobutukatapeneya meane ago Yesuno leneke nome kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Nitikale enekome Yesuyo Mosesene totono pine to̱a olaukane ali-kitika Parisi ali-kitika pitia yatekome okome Mosesene totono litiapa tone ko mea pupu toamateko-pete yene tane-kiti oyake latekamele toko patu-kale ");
INSERT INTO wiu_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","agale waametekoa pa mekoli yoname moa latekakome opi poano pa wa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Nititikoa okome kiwi panago one pitimekawe kai dogi kai eya koa pokalepa pinagome edoo-pe. Ko mea pupu toamateka-peteka eni eni pokome one kai ate lia motokomepa pupu eni tokome too. Enipa nimini uku-pe-kale ");
INSERT INTO wiu_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","agale topo takamele toameneya. ");
INSERT INTO wiu_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Wa padepete Yesuyo agale pade pedoa akeneya. Nipa toge nee nonamene wa agale oa wetekaneyake nekene ali-kitame ibini akene yene meatekoi walai tuku toa pote mepokoile enekome tokome ni akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Nitikome okome panagome manane atoa motokakomepa toge kikakakuno noe wa agale oa wetekakale nekepa ibini akene ago meateka walai poke mepameamene. Ni edoa-mo. Ne keku kamotoa ako tobou meka agopa toge yopikagome ne noo wa agale oa wetekakale noka patu. ");
INSERT INTO wiu_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ako ago nekedekale toge yopikagome ne poke mekata nokome okome i ago ako ago meatekota ne wini mekono, i ago wida memotono, ne pa wa okalepa nepa yaame tuaneya poke etene keku ago meatekata mepoo. ");
INSERT INTO wiu_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Wa tobou agome ne no wa agale oa wetekakale nekepa keku ago meatekata mepamene. Nitikalepa toge yopikagome ne mekata nokome okome anu oya ne ako walaike no mekuya liti menamene wa oo. Nipa ne-pala eida odeneya mekete nee nakoi peya mekakoa yopikagome ne kei pioo. ");
INSERT INTO wiu_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Nipa pinali one wa ako ago tetepo takakalepa Akolaliyo one keku ago tetepo takoo. Pinali one wa keku ago tetepo takakalepa Akolaliyo ako ago tetepo takoo. ");
INSERT INTO wiu_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yesuyo nimo ootokoa mekomepa ne noo wa agale oa wetekakanakago-pala okome toge kikepa neke oya-laweka nekameyo-mikitika neke take kamo yeneka toge kikakakuno, noe wa kayo oa moameamene. Ni edoa-mo. Enika eni yenamepa naniko toge kikakakuno, noo wa neke nami wiei. ");
INSERT INTO wiu_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Toge kikepa ponopeneya mea yono poaneya mea kawa okeaneya mea leneta lianeya mea tiki-kiti noe wa kayo oa moamene. ");
INSERT INTO wiu_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Dikane yename neke nami wia lawetatikiya toamokale tokome neke nami wiamele toamoo. Nitamele toamokaleka Akolaliyo ke wa neke nami wioo. Nipa wene ki̱yo akeneya meane yene moa kamotokaka-pete ke wa neke nami witikale kolotine meoo wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Yesuyo nimo okale yatekome one-pala eida opia mekome nee naka ago padame okome Akolaliyo talo toko take mekete nee nakoi yenepa kolotine meoi-kale ");
INSERT INTO wiu_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesuyo agale pedoa okome okome panagome-kiti toge mati kikakouno, ipete noe wa ali atoa peya matike agale oa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Eni oi ponokale tobou agome pupu ago-pala okome namene wane agale oane wetekakouna-kiti nee nodokoa pikono, noe wa akapoano pa wa moa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Nitikale peyame namele toamoko wa waamu taneya. Panagome okome itono pade pene topo toane motukuno, enepadene noamukuno, ela toko wa wakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Wa panagome okome kogono pitimekawe kai yonota tuane (10) pene topo toane motukuno, eni kai toane enepadene wida noamukuno, ela toko wa wakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Wa panagome okome anu atoa pene motukuno, namele toamoko wa wakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Peyame nitoa wakoli pupu ago tobou agoke wakapea nokome eina wakete akenemo i i wa to̱awea onaneya. Nitikale yapu pinago kotimi wene mati luaneya mekome pupu ago-pala okome tone pitiko ta piko peyake batete luduka ka luduka wete pa. Nipa ponopeneya mea yono poaneya mea lene lianeya mea kawa okeaneya mea tiki-kiti enemopoano pa wa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Nitikale enemoa aua nokome okome Ali Muno neke okale toane enemoane nokounake ali atoa meatikita pa pikono, deku patu-kale okome ");
INSERT INTO wiu_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","ta kebonokeka tayo tayotaka pa pitiki ali atoa noe wa tika tika toa aua noo. Anu yapu edea takatapemotoane ukuno, enemopa. ");
INSERT INTO wiu_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Eina namolo takoane noe wane oane agale wetekakolu wakoina-kiti anu toge nee nomotoane wamuku wa tobou agome akeneya wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Yesu pokaka ali atoa obomoa litima nokoli Yesu ete peketapea kakome okome ");
INSERT INTO wiu_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","panagome-kiti etene nineta mati atoa wamene laine-mikiti kote motane tetepo takameneya tewitikoa wawamokomepa no oyake litia namele toamoko. One kepene mama moa tuamene piti motaneya mekomepa no oyake litia namele toamoko. ");
INSERT INTO wiu_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ni one wia dekatiki yomo-pala aua poamademe wawou toa anukule takama pokome tete-pala moamademe wakomepa nipa no oyake litia namele toamoko. ");
INSERT INTO wiu_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Kiwi panagome one ta enapeateko yapu ludu yapu wiademe-kiti eni yapu wiane peya takateku kue oyake piko patu wa wene kibutukapia meoo. ");
INSERT INTO wiu_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Eniledo toamokomepa nipa itono pedoa yapu wete wia peya takameneyake one kue pootapeoo. Nitikale enekete ete peyame ekete ");
INSERT INTO wiu_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","i agome one yapu titia eina wikanake oyake wia peya takamele toamokolo pa pegene kakalogoa wako wa ya motokoa oi. ");
INSERT INTO wiu_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ni tobou ago padame eko tobou agono yatene-pala poi toademe-kiti namolo takoa eya too. Eko yatene wia litikome toateka oi pedoa pia mekomepa one yatene natetekoameke eni yatene pitikali oyake kutu litiku patu wa wene kibutukoa meoo. ");
INSERT INTO wiu_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Pitikali oyake kutu litiamele toamoko wa wene pikomepa eya too. Pitikali ta padeka mati nome dekakoa pitikota one oyago-mene moa wetekakomepa poi pia enepamene wa moa wetekoo. ");
INSERT INTO wiu_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Eina toa kinikiya peya tewitikoane waou wa wene kibutua meameketepa no oyake litia namele toamoko wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Kusa eni nakiyapa epetaneya tokolo uku. Nitaneyake me pekene kusapa edoa wa meke takamotoa-pe. ");
INSERT INTO wiu_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Dikane kusapa ipe luduka nee yabunu kai te eya pitikoai tikitaka moa mitikatekole toamokolo pinagome paka miitapeko. Kale piiyakoa kaki-kiti kipala i ukumo yakoa moamene wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Takesi kue motokama yakene ali-kiti Mosesene totono tagoa toamene yene peyame Yesuyo okamo yakadete one mekata obonokala taneya. ");
INSERT INTO wiu_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Nitikoli Parisi ali-kitameka Mosesene totono pine to̱a olaukane ali-kitameka Yesu akoa lubulubu pikakete ekete i agomepa Mosesene totono tagoa toamiki yene makutukoa moa odeneya opia mekome nee nako wa okoli ");
INSERT INTO wiu_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yesuyo eya wa pedoa agale akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Kiwi panagome sipi sipi kai ege takupeta kadukoa (100) egetekale-kiti odenedo katepitoa pokalepa pinagome ete (99) sipi sipi kai ali piamene take koukoa kakoika pa kamotoa eina katepitoa atupokana kai pitia tuku toma poo. ");
INSERT INTO wiu_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Nitoa enamua motokome wedia kawa kotomaneke wia apulogoa wakapea noo. ");
INSERT INTO wiu_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Yapu eni nome kakome one oya-lawe one yapu liti mekoi peya kayo oa motokome okome auna katepitoa atupokana sipi sipi kai enamuane moane nekene ukuno, wedikete wediatono noe wa kayo oo. Enipa nimini uku-pe. ");
INSERT INTO wiu_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Eina toa Mosesene totono tagoa toamene ago odenemeka one namolole poanele tewitikoa wakalepa a tibuke mekoi peya wedia kawei. Nipa pade ali-kiti ege takupeta kadukoa (99) kini namolole poanele wete tewitikoa wakeneya tekete wene ki̱yo akeneya mekoi yeneke wedekilepa teketeke einago odene agoke wedoa wedikete kolotine meoi wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Pade atoame-kiti one kue lene yonota tua pikoyake wa pade odeneka atukolopa nipa eya toko. One labo udukoa yapu do wedoa pokama pokome tuku toa kawa enamua motoko. ");
INSERT INTO wiu_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Enamua motokome one oya-lawe one yapu liti meki peya-pala okome auna atuane kue lene enamuane motukuno, wedikete wediatono noe wa kayo oa motoko. ");
INSERT INTO wiu_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Eina toapa Mosesene totono tagoa toamokome etepea pome atupoka ago odeneka one namolole poanele tewitikoa wakalepa Akolaline edelo ali-kitame ke wa wedoa wedia kawei wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesuyo eya waka pedoa akeneya. Panagono manata takuta kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Padepete putunagome etene-pala okome atai neme kadimo oa no tatikoa meatekoya-kiti opi mouno, wete tatikoa meano ta-kale etename tatikoa metaneya. ");
INSERT INTO wiu_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Nitaneyake ta pade-mene lia patakale putunagome onekeya peya moa ta tetemada pome mepaneya. Nitoa pale toa mekome onekeya peya paka wetekamu taneya. ");
INSERT INTO wiu_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Wetekamu taneya pa mekale one eida mekata kobu igi mati witaneya. Nitaneyake kobume tuaneya mekome tokome ");
INSERT INTO wiu_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","ta pinago pade mekata pokome okome neke takateku pupu pade piko-pe wa yakapokale tayo lono one kai kakane lono one kai egetekapa wa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Eida egetekakoa mekata kobume tukomepa kai naki neepa nou wa wene pianeyake padameka one noatekaya lawetekile toameneya. ");
INSERT INTO wiu_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Nitaneyake one poane wene wia wakome okome Agetaine pupu takaki yene peya nee noa kitipu-kama mekiyake nopa nee noamoane kobume tuaneya i mekuno, ");
INSERT INTO wiu_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","agetai mekota wete wakapeane poada. Pekene ekene atai, Akolaline leneke kakene poanele tokou. Ne-palaka poanele eina tokou. ");
INSERT INTO wiu_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nopa dikane agono, neke mana wa neme amele toamokono, neke pupu ago tetepo takoa pa pupu yameano ta wane opou wa ");
INSERT INTO wiu_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","kamomotokome oneketai mekata poademe pekeneya. Nitoa noademe nokale etename enekome elame tuku wa teyapea pome kotua tebea nunu oa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Nitikale mana agome okome Akolaline leneke poanele tokou. Nepalaka poanele eina tokouno, nopa neke mana wa neme amele toamokono, pa pupu ago tetepo takoa pupu pade yamea ta wa kowitaneya. ");
INSERT INTO wiu_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","24","Nitikaleka etename pupu yene-pala okome manago atupane ago i nokono, tuaneyano wene pikounake i nome kakono, one kawateko mamina epetane mati wete moa kakakoa one yonoke makai wane moa mekakoa kawa yeneka moa mekakoa toe. Togeke wiadete la̱motoa egetekoona pitimekawe kai tine wete moa wia kikakamene. Toge kia wedikete wediatoe wa okale toge nodokoa pia wedia kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Nitoa kakakoa namolo ago ipe toa kawa wakapea nome yapu liti kakome yatekale tulutu oa kawa pitikoa wedia kakoimo yakaneya. ");
INSERT INTO wiu_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Nitoa yatekome one pupu ago pade ne noo wa kayo oa motokome okome i yatekumopa edele tekete ikiti-pe-kale okome ");
INSERT INTO wiu_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","neke wamene opi noka. Nitikale neketaiyo one tuamoa padeleka toameneyano ke wa wedia kakomepa tone togeke kiadete la̱motoa egetekoona pitimekawe kai tine wia kikakakome toko wa okale ");
INSERT INTO wiu_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","yatekome kotimi wene luaneya kakome kini wedia kakoita poamademe wakale etene ako lono one kakata pokome ne noo wa kowitikale ");
INSERT INTO wiu_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","okome atai, mali peya mati ponomotoane neke agale odepetaka tagameneya meane neke pupu pa takoane kakou. Nitikouyake meme kai tine i metekuno, neke oya-lawe-pala wia kia noa wedia kawati wa odeneka meamokana. ");
INSERT INTO wiu_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Nitamokanake neke mana putunago wakapea nokalepa togeke kiadete la̱motoa egetekoona pitimekawe kai tine wia toge kikakaka. Neke kamoya-kiti moa pokome pamoko atoa-pala opia mekome paka wetekamu taneyake toka-kale ");
INSERT INTO wiu_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","etename okome tota odeneyata mea kakoona. Anukuya peyapa nekeno, dekolo wene poaneya kake oko-pe. ");
INSERT INTO wiu_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Neke wamene ago tuane tetepo taneyake opi i noko. Atua pekeneyano wene pikounake opi i eneku. Nikepa ke wa wedia mekilepa tamele toko wa etename akeneya wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesuyo one oya-lawe-pala eya waka pedoa akeneya. Kamo agome-kiti onekeya neme yopikamene wa panago moa kakaneya. Nitikale yopikoa meaneyake pade-kitame ekete winagome nekeya-kiti paka wetekamu toa talo toa potokakako wa to̱awea onokoli ");
INSERT INTO wiu_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","kamo agome ne noo wa yopikaka ago kayo oa motokome okome neme toa potokanemo-kiti onikino, anukuya-kiti neme yopikake oi pima neke tadekale enouno, eni wia pika boku aua namene. Anukuya-kiti neme wa oyake yopikamele toamokolo uku wa kamo agome akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Nitaneyake one toateka wene kibutua mekome okome kamo agome no ne pa wa wetekademe toko. Itono wetiane ipe enika eni pupu toateku tele meamoko. Eko pade ali-kitaneya oiane moamene ya motukuno, deku patu. ");
INSERT INTO wiu_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Kamo agome pa wa wetekakale pa pima yakenepa ali atoame kini yapu ne noo wa no makutukoa momotoane tekene ile tou wa wene kibutukapianeya. ");
INSERT INTO wiu_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Nititikoapa one Ali Muno agonoke padeya-kiti nami kakoa motane yene peya odene odene wa kayo oa mokala taneya. Nitoapa panago-pala okome neme tobou agono nami wia ete meatekoyapa edela piko-pe-kale okome ");
INSERT INTO wiu_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","olipe yomo ku̱ uepa mete keneke mekoane ege takupeta kadukoane (100) nami wiane meamedeku wa okale okome eina ete meateko oipa bokuke wiane mekakouna pade pilia wawa koikoa eni lukuke ege odepeta kadukoa (50) oi wia mekamene wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Nitoapa padago-pala okome tobou agono nami wia ete meatekoyapa edela piko-pe wa yatekale okome witi ku̱ kake uane kite toane ege kadukaka kapidime kadukoane (1000) nami wiane ete meamedeku wa okale okome eni oipa bokuke wiane mekakouna pade pilia wawa koikoa eni lukuke ege kadukaka wageneme kadukoa kakoa (800) oi wia mekamene wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Einagome dikoa toa potokakaleka tobou agome okome pinali neke kepene mama moteke toatekale wedoa wene kibutukapiadeko wa one kei pianeya wa Yesuyo akeneya. Nimo ootokoa okome itono peku noa tiki-kitame kini yagono-mikiti-pala toatikile wedoa wene toa tikilepa pa̱ keneke Akolalinele takama yaki-kiti moa patukoa tiki wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yesuyo nimo ootokoa okome kini kamo tikilepa yete pade ali atoa-pala tatiane oya kakoane tou wa tamene. Nipa eni kamoya wetekamu tootokoa pa mekepa mea kawateko take namene wa makutukoa momotoa teke nitamene. ");
INSERT INTO wiu_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Panagome-kiti one natele toatekale epetekoa tokomepa nipa tubele toatekaleka epetekoa too. One natele toatekale toa potokakomepa nipa tubele toatekaleka toa potokoo. ");
INSERT INTO wiu_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Nipa itonoke kamoya-kitipa kime pikoa mea potokadekolipa nipa one epetaneya pia kawateko kamoya talo takamene wa teyo edoa memotoa-pe. ");
INSERT INTO wiu_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Panagoneya talo takoa potokadekalepa nipa one kamoya pade ne pa metekene metekuno, moa ta wa teyo edoa memotoa-pe. ");
INSERT INTO wiu_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Panagome yono tatikatakutukoa ali takutane pupu oyake takamele toamoko. Nitoado tokomepa panago-pala kotimi wene luaneya mekome wa padena agoke wene mekoa mekome pupu takakala too. Ni panagoke wene tugoa mekome wa padena ago paya tetepo takoa too. Nipa Akolalinele takakilepa kamolekeka wene piitikaneya mea tamele toamoko wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Yesuyo nimo okale Parisi ali-kitame yakakoa kaketeke tea agale oa kakeneya. Nipa kini kueke-kama wene piitikaneya mekete ni taneya. ");
INSERT INTO wiu_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Nitikoli okome ali atoame kiwi kei pimotoa tekete kini leneke wene ki̱yo akeneya meane tetepo takoa mekilika Akolaliyo kini wini tepene piko wene tetoa eneko. Ali atoame tobou kakoa kei pikiya-kitipa Akolaliyo kote motuku wa kotimi wene luaneya meko. ");
INSERT INTO wiu_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Papete Moseseyo one totono i i wa yamea wia mekaneya. Akolaline agale to̱awea akane ali-kitameka one agale i i wa to̱awea akama nekeneya. Wa naniko Yone taatekoa nekene-pete titimoa weneya totono Akolaliyo ali atoa talo tokome tokomo kini wene epetekakomo oa aua yakili e ku ali atoa Akolalike lukoa meadete togo togo oa kakili uku. ");
INSERT INTO wiu_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Nimopa wane ekeneke eya waneka uku. Itono tibuta oyake takoa pamele tokoyake Mosesene totono pademoka katekamele toamoko. ");
INSERT INTO wiu_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Panagome one natono wawa eko pade atoa motokomepa nipa mone moamateko atoa eni motoko. Aname wakene atoa panagomedo motokomepa nika mone moamateko atoa eni motoko wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yesuyo agale pade pedoa okome okome kamo ago pade ta pataka abuna kamokakome kudulu pagene mamina eya kawa nee epetaneya-kama noa taneya. ");
INSERT INTO wiu_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Einagono kago keteponoke ponopene ago pade one ibini Lasarusi tono pageneya nome piai taneya. ");
INSERT INTO wiu_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Nipa kobume tuaneya mekome kamo agono walai keneke pitaka nee kugu noadiyano wene pia taneya. Nitikata tue-kiti nekete one tono li abetoai taneya. ");
INSERT INTO wiu_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ponopene ago nitoa pa mea tukale edelo ali-kitame a tibuke moa aua pote Eberamene yono kounoke kakapaneya. Kamo agoka tukale oloyo taneya. ");
INSERT INTO wiu_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Nitaneyake poane take pome mekome dika dika toamene tete mokoa kakome ate enapekome enekale ta padeka mati Lasarusi Eberamene yono kounoke kakale enekome kayo okome okome ");
INSERT INTO wiu_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","atai Eberame noanu ela moamene-ye. Toe itipono okoa kakota i kakene tete dika dika toamene mokoane kakuno, winago Lasarusi one kadapi yono munoke ue takamoa anu keke ko akakanomono, pa wa oto wetekamene-ye wa kayo okale ");
INSERT INTO wiu_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Eberameyo okome anu mana ne itonoke mekepa epetaneya-kama motokana. I ago Lasarusi nitameneya edawe mekana. Opa i ago wedia mekoyake nepa tete mokoa wini kako. ");
INSERT INTO wiu_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Nika ne-pala toto-pala kobu tubeyame pilikaneya mekono, ika meko-kiti winika nouno wene piketeka winika namele toamoa winika meki-kiti oto namele toamoko-kale ");
INSERT INTO wiu_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","yatekome kamo agome okome winimopa nimini okoyake eya tamene wane ne kowitikene uku-ye. Agetaine yapu anukameyo-mikiti ko kakoa (5) mekete tikino, no tete i mokoane kakuta note menokayano, wini ago Lasarusi eni yeneke wetekakamene-ye. Nipa kini tiki poanele tewitikoa wawati wa pubu akapomotono ta wa kowitikaneya. ");
INSERT INTO wiu_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Nitikale Eberameyo okome Mosesene totonoka Akolaline agale papete to̱awea akane ali-kitane agaleka pa kini oi momotono ta-kale okome ");
INSERT INTO wiu_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","ae, atai Eberame anukameyo-mikitame enimo oi moamoi-li. Tukome tuane agodo kamomotokome kini mekoita pome pubu opokalepa kini poanele tewitikoa waweino, wini ago wetekakoa ta-kale okome ");
INSERT INTO wiu_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Moseseyoka Akolaline agale papete to̱awea akane ali-kitameka wia mekane agale yakoa moameketepa nipa tukome tuane ago kamomotokome mekoita pokome okamoka etene yakamoi wa Eberameyo akeneya wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesuyo one oya-lawe-pala okome okome ali atoame poanele tomotoa padele padele witakala too. Ae, poanele tomotoa likoa enekoi yename tete mokoa kawei. ");
INSERT INTO wiu_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","I mati deya-kiti odeneka padame likoa enekalepa nipa Akolaliyo kibu motokome dika dika toamene tete meoo. Ae, eni tete mea kibu moamomotoapa papete mati wete likoa enameneyake pade alimedo laukakoa tube kue matiyame one kabe kautoa kusa ue muke keti pitikakalepa epetoo. ");
INSERT INTO wiu_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Kipalaka enile takayano, wedoa meamene. Neke oyago padame ne-pala padele poanele tokalepa kikoa oa moamene. Nitikale one poane wene wia wakalepa nipa one poanele tokanake po letu mekakana keetapeamene. ");
INSERT INTO wiu_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Nipa ta pataka abuna tatono (7) kakoapeta poanele ne-pala one tokala toake wa tatono (7) kakoapeta ne-pala poanele eina tekene tadeku wa one poane wene wia wakala tokalepa one poanele tokala tokanake po letu mekakana kekala tamene wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Yesuno oyali-kitame one-pala ekete Ali Muno Akolalinele akole-kama takama poono, mane mane oano ta-koli ");
INSERT INTO wiu_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ali Muno agome okome kalipe lenepa dedeyameke witakome leau akatapea witako. Akolalinele edikoado takama peketepa nipa i kako yomo sikamine yomo teke to̱omoa poke kusa ue muke kapa wa okale to̱omoa poo wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Kiwi padago neke pupu takako agomepa neke ipe takoaka neke kai egetekoaka toa peya takamotokome neke yapu wakapea nokale eneke nee wete nonamene wa neme oo-pe. ");
INSERT INTO wiu_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","E̱'e mena. Eya wa oo. Nee ue eya nouno, mamina pade moa kawa nee takoa lawetoano ta. Nee nootokoane mekolu neke nee ue eya noano ta wa neme oo. ");
INSERT INTO wiu_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Enile tamene wa okale einagome yakoa tokalepa ke wane uku wa neme oo-pe. E̱'e mena. ");
INSERT INTO wiu_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Akolalinele dikoa takamene. Oneme tamene wa oka toa-kama yakoa teketepa one-pala eya wa amene. Tone toatekole pa eina tokoono, toto pa yene-pala ke wa edoa oade-pe wa amene wa Yesuyo one oya-lawe-pala akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesu Yerusaleme take poademe pokome Galili Sameria tata otoke pake yakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Nitoapa ali atoa pitikoi ta pade pome kakaka kedime nakene ali noi kakoa (10) one kotuadete eka mati witimoa kakete ");
INSERT INTO wiu_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","kayo telo ekete ekete Tikisa ago Yesu toto ela moamene-ye wa kayo oa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Nitikoli enekome okome Akolalike lodo yotokoai tiki ali mekita pekete kini lene timini yameatino poe wa wetekakale poadete pokoika eina kedime nakene yene takoa pootapeadeka. ");
INSERT INTO wiu_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Takoa pekedekale enekome odene ago Yesu kakata wakapea nekeneya. Nipa Akolali kei telo oa pima nokome ");
INSERT INTO wiu_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Yesuno kawane aua pitakome ke wa akeneya. Einagopa mone Sameria take agomeke nitaneya. ");
INSERT INTO wiu_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Nitaneyake Yesuyo okome kiwi kedime nakene ali noi (10) kakoapa kiwi peya latamokoi-pe. Latekakilepa taneyano, eina pogi kakoa (9) ali-kiti edekoti-pe. ");
INSERT INTO wiu_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ae, e ali-kiti Akolali kei pinamikiyake o ago odene mone agomeke Akolali ke wa one kei pinoko wa Yesuyo ootokoa einago-pala okome ");
INSERT INTO wiu_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","kamokoa pa. Nooke wini wene tugoa mekoleme ne eni latekaneya tokolo uku wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Parisi ali-kitamepa Akolaliyo ali atoa pawe toa talo tikilepa manipete too-pe wa yatekoli okome Akolaliyo eni talo tokoyapa kini leneme enemotoa keleyo witamoo. ");
INSERT INTO wiu_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","One talo tokoyapa ku witakono enoe, e witakono enoe wa padameka wamoi. Akolaliyo talo tokoyapa kiwi pakeke wete witaneya tokolo ni uku wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Nimo ootokoa one oya-lawe-pala okome no Ali Yatenane Oyago wakapeane none meatekou ta pataka odene enadiya wa kime wene pia meketeke wa pade enamoi. ");
INSERT INTO wiu_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Enipetepa pade-kitame winago oto noademe ku nokono, enoe wa oa, wa pade-kitame e nokono enoe wa oa toino, eni yene litia poameamene. ");
INSERT INTO wiu_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","No Ali yatenane Oyago wakapeane nekenepa katiapale a tibu eka kukata keleyo pi̱atapeko toane pa̱ tootapeneya nokolu peyame enekete enoi. ");
INSERT INTO wiu_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Nitatekuyake namolo takoanepa tete-kala mokoane kawou. Nitimotoa no kaku-pete meki-kitame no tewitikoa wawadete tiki. ");
INSERT INTO wiu_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","27","Eya ago Noa meane-pete ete mekoi peya paya nou toa mekete gerepi po ku̱ ue eyake wene piitikaneya mekete alime atoa moa atoa alike pote tokala taneya. Nipa Noa one tube ue dipi keneke pome mepokaleka edikoa paya nou toa meaneya. Nitoa mekoika ue mea tagatapekome eni yene wia atukatapeneya. Eina toa ali atoa paya nou toa mekakoane no Ali Yatenane Oyago wakapeane nekene kotikatapeane nou. ");
INSERT INTO wiu_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Eyago Loto meane-peteka ete mekoi peyame nee noa eya kuya topo toa moa ipe lene matoa yapu wia enika enile toma nekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Nitoa mekoika Loto one Sodome ta tewitikoa pokale eina eina Akolaliyo tibuke toe-pala itipono okoa kakene kuguta pitikoa wia atukatapeneya. ");
INSERT INTO wiu_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","No Ali Yatenane Oyago wakapeane nokou-pete mekoi ali atoameka einago Loto meane-pete tanele pa enile tokoa kawei. ");
INSERT INTO wiu_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Enipetepa panago neke pikoya-kiti yapu keneke pimotoa yapu liti koo meapa nipa mopada wa yapu keneke poameamene. Eida mea pitoa pamene. Panago neke ipe toa kawapa wa yapu wakapea poameamene. Eida kawa pitoa pamene. ");
INSERT INTO wiu_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Loto einagono natono-pala tanele kipalaka takayano, kakoika wete tewitikoa pitoa pamene. ");
INSERT INTO wiu_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Nipa onekele-kama tokome tukaya wa piti tokolo kepene mama motoko agopa one yomini-pala etepea tua poo. Wa padekagome one kepene mama moamokome tukaya wa piti moamoko agopa tukomeka Akolaline take mea kama poo. ");
INSERT INTO wiu_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Eya waneka ukuno yakamene. Enipetepa adona odene walaike atuta pitikoita-kiti pade eida pimotoa Akolaliyo padena takoa moa poo. ");
INSERT INTO wiu_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Atoa takuta kini witi ku̱ kugutukoata kakoita-kiti padatoa eida pa kamotoa Akolaliyo padena atoa takoa moa poo wa Yesuyo okale ");
INSERT INTO wiu_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","ekete Ali Muno neme wini okotapa manika patu wa okoli okome ali tuaneya lomua kakota kego naki ini-kiti odepeta koukoa note puka puka toa yaita kawei wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yesuyo agale pade pedoa ikilepa Akolaliyo yakoa toatekole nepia mea wawamekete one kowitoai toatiki adeka pikome eya wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Pitikali ta latia pitikoi take koiso yakateka ago pade eida meaneya. Einagopa Akolaliyoka ali atoameka one akakaya wa piti moameneya atiki toa meaneya. ");
INSERT INTO wiu_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Eni take nepo meane atoa pade einago mekata nokome okome panagome no-pala poi te̱ia mea toa potokakono, no auapea anu koiso yatekoano ta wa kowitoai taneya. ");
INSERT INTO wiu_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Nitikale pade-mene yakameneya meake wa naniko wene kibututukoa mekome okome Akolaliyoka ali atoameka no akakaya wane piti moameneya atiki toane mekuyake ");
INSERT INTO wiu_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","i atoamepa no teko takakoa kakono, no mekuta-kama one koiso yatekoano ta wa kowitoa-kala kakayano, auapeane one koiso yatekada wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ali Muno agome nimo ootokoa kakome okome koiso yatekakagome okomo yakamene. Wene ki̱yo wameneya mekomeke okono. ");
INSERT INTO wiu_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Akolaliyopa one wa takoa motane-kitame ete pia oto pia one kowitoai toa kakolipa kini koiso yatekamoo-pe. Koiso yatekatekoa wete auapeamoo-pe. ");
INSERT INTO wiu_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Kini koiso wete yatekoa auapekala too. Nitatekoyake no Ali Yatenane Oyago wakapeane nekene enekolu ali atoa nooke wene tugoa meadekoli enou-pe wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yesuyo agale pade pedoa ikilepa pade ali atoa wene ki̱yo akeneya meku wa kini wa kei piketeke ete-kiti paya tetepo takoa meaneleke eya wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Eyagotame Parisi ali takesi kue motokama yakene agotame Akolali kowitadete tobou losu yapu pekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Pote kakete Parisi agome one one kakome mate agale keneya oa one tepene kowitikome okome Akolali ne-pala i ukumo yakamene. Ete-kitame pade ali-kitaneya oa yotokoa moa ele kule poanele toa atoa lia moa nitoa tikiyano, noanumepa nile toamuku. Kuna agopa takesi kue motokama yako ago ku kakono, nopa einago keneya menano, ne-pala ke wane uku. ");
INSERT INTO wiu_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ta patako tatono kakoa (7) ponoko toane-kama takupeta nee wawane pa mekala tuku. Anu motukuya peya yonota tuane pikala toane pade katekoane moane neke pikakala tuku wa kowitoa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Takesi kue motokama yaka agome nitamokome ete witimoa kakeneya. Nitoa ate tibuke nepikamene ya tokale kakome one palanu wi wi toa kakome okome ae, poanele-kala tuku agome ukuno, Akolali no ela moamene-ye wa kowitoa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Nitoa kowitane agopa Akolaliyo poanele toamene ago tetepo takaneyake yapu pekeneya. Padena ago mena. Nipa pinali one wa kei piko agopa Akolaliyo keku ago tetepo takoo. Wa pinali one wa paya tetepo takako agopa Akolaliyo kei pioo wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Wa pade-pete pade-kitame kini de mati deya-kitika yoname mitikakamotoa Yesu kakata aua nokoli one oya-laweme noameo wa kikoa okoli ");
INSERT INTO wiu_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Yesuyo okome wini mati-kiti oto nomotono, etoe. Akolaliyo one talo tuku taapa kinino noe wa yametekilepa dikane mati-kiti yametekono, oto nomotono toe. ");
INSERT INTO wiu_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nimini ukuno yakoe. Panagopa mati deya-kiti Akolalike lukoa mekete tiki toa lukoa meamademe wakomepa nipa Akolaliyo talo toko take oyake pamele toamoko wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Tobou ago padame Yesu yatekome okome epetanele toko Tikisa ago, edele tekene meane kama pou-pe wa okale okome ");
INSERT INTO wiu_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","nopa epetanele toko ago wapa wini okono, edekolo oko-pe. Epetanele-kama toko agopa Akolali odene kako. Wa pade lokoaka kawamoko. ");
INSERT INTO wiu_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Moseseyo tamene wa papete wia mekanemo neme wene toko. Eya wa wia mekaneya. Mone padane atoa lia moamoa ni ali wia tukamoa ni monekeya kode moamoa ni panago-pala pa puputua akoa agale wamoa ni neketai neka̱uata kei pia mama moa tamene wa Moseseyo akeneya wa okale okome ");
INSERT INTO wiu_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","eni akenele-kama tualike laigoane yakoane toma nuku-kale okome ");
INSERT INTO wiu_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","wenepa eni tadekoyake odeneledo katekoa toameadeko. Neke pikoya peya topo toa kue mootokoa ponopene ali atoa tatia meetapeamene. Nitikepa neke kamo toatekoyapa a tibuke auma kakeneya enoo. Nitatekoyano, no litima namene wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nimo okale yatekomepa uu kamo tane ago tokome wene keda taneya kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Nitikale enekome Yesuyo okome ae kamo tiki yene Akolaliyo talo toko take pamene poto tube mati toko. ");
INSERT INTO wiu_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kamelo kaido noi keneke-kiti patukoa ponokomepa nipa wedoa wili toa kawamoapa patukoa ponoo. Kamo tane ago Akolaliyo talo toko take ponokomepa nipa wili tokoa mati kawapa ponoo. Nipa one take pamene poto mati toko wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","27","Nimo okale yatekoi-kitame ekete kamo yeneke winimodo nimini akedekalepa nipa Akolaliyo mainali atoa toa moo tokolo-pe wa okoli okome ali atoame toamatikilepa Akolaliyo oyake tamele toko-kale ");
INSERT INTO wiu_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pitayo okome totomepa tone yapu tewitikoa wawa ne litima noko-kale okome ");
INSERT INTO wiu_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","nimini ukuno yakoe. Panagomepa Akolaliyo ali atoa pawe toa talo tokomo oa mema poademe tokome one yapu one natono onekameyo-mikiti one etene nineta one mati-kiti tewitikoa wakomepa ");
INSERT INTO wiu_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","nipa itonoke enika eniya luku ako-kitika mokala too. Nitoa mea tukale Akolaliyo one talo tuku take mea kama pamene wa moa kakoo wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesuyo pato wa one oya-lawe-pala eko keneya aua pokome okome kipala i ukumo yakoe. Opa toto ate Yerusaleme take poadete poko. Pote kakolopa Akolaline agale papete to̱awea akane ali-kitame no Ali Yatenane Oyagoke wia mekapiane toa-kama aida taatekoo. ");
INSERT INTO wiu_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Nipa ete Yu yename no dekoa moa mone yenane yonoke moa pikoli paya tetepo takoa tea kawa tekelipu toa yotokoa ");
INSERT INTO wiu_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","po wapime wia toi. Nitoa wia tukolika ta tebolo takoa pataka-pete kamoane pou-kale ");
INSERT INTO wiu_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","one oya-laweme nateya weneka toameneya. Nipa eni okamo kaukoa keneya okale tokome eina agale pine agopa tokale meaneya. ");
INSERT INTO wiu_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesu Yeriko ta tigotokakoa witapademe nokaka leneta liane ago pade eida one ponatekaya liti kue eya oia moa meaneya. ");
INSERT INTO wiu_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Nitoa mekome yatekale ali atoa peya obomoa ponokoimokamo yatekome okome ipa edele tikiti-pe-kale ekete ");
INSERT INTO wiu_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Nasarese Yesupa wini ponoko-koli kayo okome okome ");
INSERT INTO wiu_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Depidi-laweke taagene ago Nasarese Yesu neme no ela moamene-ye wa ka̱ wikoa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Nitikale namolo kawa penane-kitame kikoa ekete ekete oyakeno, wa wa okolika kayo telo kamotokoa okome okome Depidi-laweke taagene ago no ela moamene-ye wa kayo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Nitikale yatekome Yesu witimoa kakome okome winago no kakuta aua noe wa okale one kakaya liti pinele nome kakale Yesuyo yatekome okome ");
INSERT INTO wiu_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","anume edele takamotoa oko-pe-kale okome Ali Muno anu leneta kikakoa wane uku-kale okome ");
INSERT INTO wiu_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","nooke wene tugoa mekolemepa neke leneta epetekakono, neke leneta kikoa yeka ete ena wa okale ");
INSERT INTO wiu_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","eina eina one leneta kikatapeneya. Nitaneyake Akolali kei pia kawa Yesu litima pekeneya. Enile tokale enekete peyame Akolali-pala ke wa kei pia kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu Yeriko ta nome patukoa ponokaka ");
INSERT INTO wiu_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","uu kamo ago Sakiasi eida nepia kakeneya. Einagopa takesi kue motokama yakene yene yopiane ago. ");
INSERT INTO wiu_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Yesu edane ago patu wa nepia kakale ali atoame Yesu ponatekaka apua takoa edetapeneya. Nitaneyake totono ago tokome one lekoa pokome kawateka kene piameadeka. ");
INSERT INTO wiu_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Nitadekale teigoa teyapea pome Yesu ponatekaya liti kakene yomo sikamo yomoke lewia pome nepia meaneya. Nipa Yesu enademe taneya. ");
INSERT INTO wiu_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Eida nepia mekata Yesu nokome lene ate pitikoa enekome okome Sakiasi neke yapu opi no pipato. Wini yomo ko̱a wete noo-kale ");
INSERT INTO wiu_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","nipa pata wa ko̱a nome one yapu wedia aua pekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Nitikale enekete e yene peyame Yesu oa lubu lubu pikakete ekete poanele toko agono yapu eni pome pipoko wa ko̱ oa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Nitaneyake Sakiasi one yapu nome kakome Yesu-pala okome Ali Muno anukuya peya tatitakutukoane padekapa ponopeneya-kiti meou. Wa namolopa pade ali-kitaneke kini kue oane yotokoane kode keneya motadekolupa nipa pine yene kini nami wianepa eni oane yotokoane motokouna toane tuyonopeta kadukoane ete mekala tou-kale okome ");
INSERT INTO wiu_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","opi neke yapu pitiki-kiti Akolaliyo toa motoko wa ootokoa okome i agopa etepea pekene agoke Akolaliyo oneka Eberame-laweke taagene ago wa toa motoko. ");
INSERT INTO wiu_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Nipa no Ali Yatenane Oyagome paka etepea pekene yene tuku tou wane toane moadene nokou wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","E yename einaka einamo yakakoa kakoika Yesuyo agale pade pedoa akeneya. Nipa one Yerusaleme take tigotokakoa witanokono, Akolaliyo ali atoa pawe toa talo tokoyapa itonoke opii witako wa e yename wene pikoli tokome ni akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Nitikome okome tobou ago pade ta tetemada meane yename kini ako tobou ago moa kakamotoa poademe eya taneya. ");
INSERT INTO wiu_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","One pupu ali-kiti noi kakoa (10) noe wa kayo oa motokome kini kini kakoi toa kina kapidi kakoa (20) tatikoa mekala taneya. Metekome okome oto noadene pukuno, i kueme tine pikoa motokamene wa meemotokome pekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Nitaneyake one eina take mekoi yename one-pala kotimi wene luaneya mekete pade ali-kiti moa wetekakete ekete winagome toto talo tamene kote tokolo wako wa akapoe wa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Wa naniko ete take mekoi-kitame einago kiwi yopiateko ago ne mea wa moa kakatekaneyake one ta pine lono wakapea nekeneya. Nokome pupu ago pade-pala okome kue metekouna ali-kiti enemotokapa. Auna kueme tine pikoa motokakoimo yakouno, enemotokapa wa moa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Nitikale namolo ago nokome okome Ali Muno nemena mea pokana kina kapidi kakoa (20) kina moane tine pikoanepa ege kadukaka kadapime kadukoane (200) kina motokakouno, ina wa metekale okome ");
INSERT INTO wiu_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","epetekoa neme eni tadeko. Eni pupupa nateleke neme wedoa tadekono, pupu pade tubele yameou. Pitikali ta latia pitikika noi kakoa (10) ta-kiti ne tobou ago mea yopikamene wa yametaneya. ");
INSERT INTO wiu_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Wa taku takoa noka ago nokome okome Ali Muno nemena mea pokana kina kapidi kakoa (20) kina moane tine pikoanepa ege kadukaka tatigime kadukoane (100) kina motokakouno, ina wa metekale okome ");
INSERT INTO wiu_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","nipa pitikali ta latia pitikika ko kakoa (5) ta-kiti ne tobou ago mea yopikamene wa yametaneya. ");
INSERT INTO wiu_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Wa panago nokome okome Ali Muno nemena mea pokana kina kapidi kakoa (20) kina mootokoane mamina moane togotoane potipikakou. ");
INSERT INTO wiu_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nepa telekago teke padeya-kitipa nekeya menake pa neme mokala toko. Panagono ipe neme padeyaka matamokoyake noa meko. Nepa dikane agono wene tekene piti tokale mekene neke kue pa potipikakouno, ina wa metekale ");
INSERT INTO wiu_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ali Muno agome okome nepa poanele toko agomeke oko. No telekago padeya-kiti anukuya menake mokala toane ni panagono ipe padeyaka matamukuyake noane meku wa nooke winipa ko̱ okono, neme wini oko toane padele telekole toane ne kibu mouno, nepia. ");
INSERT INTO wiu_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ne meane pokouna kuepa bage edekale moa pikamoka-pe. Bage pikoo tokapa anu kueme tine pikane kue-pala oto mou tokake nitameke padeleka toameneya pa potipiadeko wa kikoa akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Nitoapa eida yakakoa kakoi yene-pala okome winagonoke one kina kabidi kakoa (20) pikoa kako kina moe. Mootokoapa kina ege kadukaka kadapime kadukoa (200) kina pikoa kako ago metekapoe-kale ekete ");
INSERT INTO wiu_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","ouo, oyagome one kina ege kadukaka kadapime kadukoa (200) kina pikoa kakoyake okoto-pe wa okoli okome ");
INSERT INTO wiu_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","kipala i ukumo yakoe. Akolaline peku wedoa nakagopa nipa Akolaliyo one peku wedoa lawetema pokale kamo toma pou toa wedoa toma poo. One peku alekoa noma pokagopa nipa onekeya nateyaka eniya peya Akolaliyo takoa wa mootapeoo. ");
INSERT INTO wiu_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Kiwi talo tamene kote motoko wa no-pala poi te̱ia mekete wakoina yene wete dekoa motokapoe. No kakakoa wia tukoatino, dekoa motokapoe wa tobou agome akeneya wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesuyo nimo omotokome one oya-lawe-pala patono noe wa Yerusaleme take ate witapademe pekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Nitoa pome Olipe-pini wa ibini akene tonoke latiane tata Besepase Besani tatake tigotokakoa witapademe kakome one oyalita takuta moa wetekakome okome ");
INSERT INTO wiu_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","kuka ku take poatino poe. Pote witoa kaalaukete enekoli dogi kai tine po kakoa kebetaneya kakale enoi. One patu panagoka wete mea yawameneyano, po kotokoa oto aua notokamene. ");
INSERT INTO wiu_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Kotokoa moadete tokoli enekome panagome okome dekolo kotokoa motiki-pe wa okalepa eya wa akamene. Ali Munoyo padele toatekole pikolo ni motokoa poko wa akamene wa Yesuyo oa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Nitikale pote enekoli Ali Muno agome okanakale tadeka. ");
INSERT INTO wiu_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Nipa po kotokamotokoika pine yene nekete ekete i dogi kai tinepa edeyake po kotokoa motiki-pe-koli ekete ");
INSERT INTO wiu_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ali Muno agome padele toatekole pikolo ni toko wa moa pekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Nitoa Yesuke aua nekete kini tokoo kakene mamina petene kotokamoa tali waneke tatikoa Yesu mekoa aua pekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Nitikoli mea pokaka kini mamina kotokoa one eni mea poatekaka pia tatikakawineya pekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Nitaneyake Olipe-pini togoikoa ketipea ko̱a poademe tigotokoa kakata one agale wete yakoa motane yene one-pala obomoa pote eida titimoa Akolali kei telo pima pekeneya. Nipa Yesuyo telekole toma pokale enekoinakalekeka ke wa Akolali kei pima pekete ekete ");
INSERT INTO wiu_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ali Muno patu kautakoa kako tobou ago i nokono, Akolali neme pewe wia yopiamene-ye. A tibuke meki-kiti tepe mataneya mekete tikino, Akolali kei piatoe wa oma pekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Nitaneyake e yene pakeke obomoa nekene Parisi ali padeka-kitame one-pala ekete neke oya-mikiti wawe wa oa kawikamene-koli okome ");
INSERT INTO wiu_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","kipala i ukumo yakoe. I yenedo kawia mekolipa nipa i piko kue wane-kitameka ke wa wedia kayo oi wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Nitoapa Yesu Yerusaleme tigotokoa nome enetapekome komo loboa pitikoa kakome okome ");
INSERT INTO wiu_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ae, opika kini tepe mataneya poatiki kaapa kini leneme keleyo pikolo enemotadiyano wene pikuyake opa kauaneya tokome oyake enamele toamoko. ");
INSERT INTO wiu_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ae, Yerusaleme ta nepala poi te̱ia mekoi-kiti wini nekete kobu moa unukatakutukoa dekali toa meoi. ");
INSERT INTO wiu_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Nitoapa neeka neke wida pitikoi peyaka moa ka̱ua kugu witikoi. Nipa neke yapu pawe eya latia kakene kue peya ke̱awea tadekamu toi. Ae, Akolaliyo kiwi auapeademe wida nekedeko wa wene toamokoli tokome nitoi wa Yesuyo komo oa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Nimo oomotokome Yesu Yerusaleme take tobou losu yapu pome kakome eya kuya eida-kama padeya padeya topo toai tane ali-kiti wia tikatapekome okome ");
INSERT INTO wiu_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","anu i yapupa no Akolali ali atoame kowitoai toatiki yapu wa wia mekaneyake kimepa kode yename kodeya paigakoa moa piai tane kota tetepo takakino, poe wa wia tikatapeneya. ");
INSERT INTO wiu_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ta pataka abuna Yesu tobou losu yapu pome olaukakala taneya. Nitaneyake Akolalike lodo yotokoai tane tobou ali-kitika Mosesene totono pine to̱a olaukane ali-kitika ete tobou yene-pala koukoa mekete one katekoa wia tukatekoi oi pedoa pia kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Nitikolika ali atoa peyame one oko agale yakatoe wa yakakoa kakeneya tokome one wia tukatekoile toamokale wakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Wa pade-pete Yesu tobou losu yapu pokome ali atoa olaukoa ni Akolalinemo kini wene epetekanemo i i wa mo wia kawa tokale Akolalike lodo yotokoai tane tobou ali-kitika Mosesene totono pine to̱a olaukane ali-kitika one kakata nekete ekete ");
INSERT INTO wiu_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ne tokolepa te patu kautakoa kake toko-pe. Teyo ta wa okole toko-pe wa pitia yatekoli okome ");
INSERT INTO wiu_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","kipalaka yakatekumo pikono, yakoe. ");
INSERT INTO wiu_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yoneyopa ali atoa ue motokama yakilepa tene peku noa toka-pe. Akolaline peku patu. One kaua-mikitane peku patu. Yakouno, oe-na-kale ");
INSERT INTO wiu_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","kini kini yakaate tekete ekete Akolaline peku noa toka wado okolopa nipa einagome oka agale edeyake yakoa moamokoi-pe wa oono, nimo wamato. ");
INSERT INTO wiu_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Nitameneya one kaua-mikitane peku noa toka wado okolopa ali atoame kue katekamoa pitikoa wia tukoi. Ali atoame Yone einagopa Akolaline agale akakago wa wene pikete tekete nitoino, ");
INSERT INTO wiu_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","enimoka wamato wa ete Yesu-pala ekete Yoneyo mainaline peku noa toka patu. Wene toamoko-koli okome ");
INSERT INTO wiu_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","nipa noanu toma yakulepa i ago patu kautakoane kakene tuku wane kipala to̱aweane wamou wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yesuyo e yene-pala agale pade pedoa okome okome panagome one ipe toa gerepi po matatekoapa one ipe kime yopikamene wa pade ali-mene yamemotokome ta padeka pokome eida mea kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Wa naniko eina ipe gerepi po ku̱ putua kibutukakoa kaka-pete eya taneya. One pupu ago pade moa wetekakome one ipe yopikaki ali-mename one moateku toapa moke toa memotono pa wa wetekaneya. Nitikale nokale one ipe yopikane ali-mename layo tiginame moomoa pitikoa pupuli wia padeyaka meameneya pa pomotoa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Nitaneyake pinagome pade pupu ago moa wetekale einagoka layome wia kawa ya motokatekoa pa pomotoa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Nitaneyake pinagome tebolo takoa ago moa wetekaneyake einagopa wia kamate ponokoa paka lono moa pitikaneya. ");
INSERT INTO wiu_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Nitaneyake ipe pine agome edeku patu wa wene kibututukoa kakome okome anu kolotini ago anu mana moane wetekou. Einagodo nokale eneketepa one kei pia makutukoa moi wa moa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Nitikale nokale one ipe yopikane ali-mename oote tekete ekete pinagono mana ku nokona. Etename one pikoa pokaya-kiti kadimo okome kunu agono pine pikademe tokono, one moatekoya-kiti toto moatono, one wia tukatoe wa ");
INSERT INTO wiu_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","tayo lono aua pote wia tukapaneya. Nitikala taneyake ipe pinagome eni yene-pala edele tonoo-pe. ");
INSERT INTO wiu_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Nipa eya too. Wakapea nokome one ipe yopikoa potokane ali-mene wia tukatapea kiwi luku pade-mene kime yopikamene wa yameo wa Yesuyo okale e yename ekete ae wini okole Akolaliyo taatekoa toamomotamene wa okoli ");
INSERT INTO wiu_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","leneme nepikoa pikome okome Akolaline bokuke eya wa wia mekanemo pine edoa piko-pe. I yomopa poadeko wa yapu wiane yename paya tetepo takoa wakeneyake panagome i yomopa yapu pigi wa moa wianeya wa panagome wia mekaneya. ");
INSERT INTO wiu_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Eni yomo pigike pitakoi ali atoa ka̱ua kugu witikatapeneya piei. Wa eni yomo pigi panagoke pitakome katua tawele takatapeoo wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Yesuyo nimo okale yatekete Mosesene totono pine to̱a olaukane ali-kitameka Akolalike lodo yotokoai tane tobou ali-kitameka ekete i agome ina pedoa okana agalepa totoke akedekono, dekatapea moatoe wa einapete einata one moadete wili toa kakeneya. Nitiketeke e kakoi yene piti motekete tokome wakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Nitoapa eya toatekoi oi pedoa pia taneya. Ta yopia meko agome koiso pitia yakakamotono, i ago moa meato wa pade ali-kiti Yesu kakata moa wetekakoli nekete one oka agale yakoa motane tetepo takoapa natemo omotadiya wa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Nitikete ekete neme mane oa olaukoa tikilepa ki̱yoke-kama toko. Nipa ali atoa peya midi pikoapa Akolalinele takama pekete toatikile ki̱yoke-kama olaukako. Nepa nitane agono wene tekete ido pitia yakoono, yaka. ");
INSERT INTO wiu_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Tone totono litiapa ako odene tobou meko ago Sisane takesi kue pitikamato-pe, pitikato-pe. Yakoono oa ta-koli ");
INSERT INTO wiu_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","one eni labatekoi wene pikoile tetoa enekome okome ");
INSERT INTO wiu_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","kue lene pade enouno, yameo wa okale yametekoli okome i kue lene tiginikepa padane lene timini-pala agaleta wia mekaneyano, eniyatapa teneta patu wa okale ekete ");
INSERT INTO wiu_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","tobou ago Sisa one wa okoli okome nipa Sisa meatikiyapa one takoa mea, Akolali meatikiyapa ni Akolali takoa mea tamene wa okale yateketepa ");
INSERT INTO wiu_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","ali atoa kakakoa i agome natemo omotato wa kamele toameadeko wa one eni okamoke wene kainya pianeya tekete agale wametekoa wakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sadusi totono litiane ali padeka-kiti Yesu kakata nikilepa agale palene yakadete nekeneya. Eni yene kini totono litiapa tuane ali atoa wa kamoamoi wa iki. Nitane ali-kiti Yesu kakata nekete likoa enekete ekete ");
INSERT INTO wiu_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Tikisa ago, Moseseyo one totono wia mekakome okome panagono atoame one mati opikameneyakedo einago tukalepa one wamene ago neme moa neke natono latikamene. Nipa tukanakago lukuke kawatiki mati-kiti opikamotono, nitamene wa Moseseyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Nipa odene aline mana-mikiti tatono kakoa (7) kakeneya. Namolo agome one atoa moapa mati opiameneya one mea tuaneya. ");
INSERT INTO wiu_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Nitikale one liti taku takoa opiane agome einatoa moapa mati opiameneya mea tuaneya. ");
INSERT INTO wiu_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Tebolo takoa opiane agomeka einatoa moapa mati opiameneya mea tuaneya. Eni wamene tatono kakoame (7) einatoa kibutua moma-kala nekeneyake panagonoka einatoame mati opikameneya. Peya tiobali mea tukala taneya. ");
INSERT INTO wiu_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Nitikala taneyake wipitikomepa einakatoaka tuaneya. ");
INSERT INTO wiu_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Eina wamene-mikitame einatoa edikoa kibutua moma-kala nekeneyano, tuane ali atoa Akolaliyo moa kamotokaka-pete einakatoapa mainagono natono wa tugoa meoo-pe wa likoa enekoli okome ");
INSERT INTO wiu_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","opi meki-kitipa alime atoa moa atoa alike pote edikatakutukakala toa meki. ");
INSERT INTO wiu_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Nitikiyake tua potepa weneya take mea kawatiki-kiti eida mea kaketepa alime atoa moamoa atoa alike poamoa toi. ");
INSERT INTO wiu_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Eidapa edelo yene keneya mea kawei. Nipa tukolipa Akolaliyo moa kamotokakale one mana kono-mikiti mea kawei. Nitoa mea kakete wa tukile toamoi. ");
INSERT INTO wiu_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Tuane ali atoa Akolaliyo moa kamotokakamo Moseseyoka wia mekaneya. Nipa itipono oa kakene yomo deyake Akolaline agale ludu nokome akenemo wia mekakomepa Ali Muno agoke eya wa wia mekaneya. Ali Muno einagopa Eberame Aisaketa Yekobe toa einago-menane Akolali wa wia mekaneyano, ");
INSERT INTO wiu_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","onepa tuane ali atoane Akolali mena. Mea kama piki ali atoane Akolali wa okome akedeko. Ali atoa one patu-kama kautakoa kakete mea kama piki wa Yesuyo okale ");
INSERT INTO wiu_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Mosesene totono pine to̱a olaukane ali padeka-kitame ekete Tikisa ago, agale muno kakoa wini okana wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Nipa one-pala agale pade wa pitia yakamene piti tokale akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Nitaneyake Yesuyo e yene-pala okome Keraisu wa papete ibini akene agoke ikilepa Depidi-loeke ta̱wateko ago wa ikino, dekolo iki-pe. ");
INSERT INTO wiu_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Papete Depidiyo Akolaline bokuke lo agale pade wia mekakomepa Keraisuke eya wa wia mekaneya. Ali Muno Akolaliyo no lukoane meku Ali Muno-pala eya wa oka. Ne-pala poi te̱ia meki-kiti moane kawikoane neke kawane komo pikouno, nepia meamene wa Akolaliyo oka wa Depidiyo wia mekaneya. ");
INSERT INTO wiu_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Nipa Depidiyo Keraisu einagopa one lukoane meku Ali Muno wa akeneyake kimepa Keraisupa Depidi-loeke ta̱wateko ago wa ikino, dekolo iki-pe wa Yesuyo e ali-kiti-pala akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Nitaneyake ali atoa peyame yakakoa kamotoa Yesuyo one oyali-kiti-pala okome ");
INSERT INTO wiu_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Mosesene totono pine to̱a olaukaki ali-kitame toma yakile titi toma yamene. Eni yenepa kini ludu mamina epetaneya wititapea kakeneya yawa ni makesike ali atoame ke wa walikitikakete yono momotada wa yawa ni losu yapukeka tobou ali-kiti meatikita meada wa mepokala tiki. Toge kikoikaka ibini akene yene meatikita meada wa mepokala tiki. ");
INSERT INTO wiu_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ni nepo atoa-kiti oa yotokoa kini yapu eya kode keneya motikiyake eka ali atoame kiwi kei pimotoa lede kowitikete kutupea pa agale likoa pikala tiki. Ae, Akolaliyo dikaki yene kibu motokomepa dika dika toamene tete meoo wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesu kabe togapia ate enekale tobou losu yapu keneke kue pitikoai tokoita tobou yene nekete kue eya pitikakala tokoli enaneya. ");
INSERT INTO wiu_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Nitaneyake nepo atoa pade ponopene atoa nome tuane kueta takuta pitikananeya. ");
INSERT INTO wiu_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","4","Nitikale enekome okome nimini ukuno yakoe. I kamo yene peyamepa kinikiya tubeya pa pimotoa keku-mene odene moa pitikakala tokoina. I atoamepa onekeyapa nateya deyake one piko toa eni moa pitikatapeka. One nee eya topo toa moateka kue eni pitikakome tokome e yene peya moa patukaka wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Pade-kitame tobou losu yapuke ekete ipa todolo yapu. Kue epetaneyameka Akolaline takoa metaneyameka koniyo takoa wianeya kakono, enoe wa okoli ");
INSERT INTO wiu_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Yesuyo okome kime i enekoa kakiya-kitipa eni wiane kue odeneka kibutukoa piameneya peya wia tadekatapeneya pa tumu tokaneya pioo wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Yesuyo nimo okale eida kakoi-kitame ekete Tikisa ago neme ina okanakalepa manipete taatekoa toko patu. Enile toatekale tigotoma nokale edeya wa adeka piipioo-pe wa okoli okome ");
INSERT INTO wiu_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","ina okounakale wete taatekoa toameneyakepa pade-kitame anu ibini lede wedekoa nekete ekete Keraisu taatekoane nukuno, noe wa oa ni pade-kitame enile taatekoa toateko tigotokoa nokono, noe wa kiwi oa yotokoino, wedoa lene kia nepikete yakoa poameamene. ");
INSERT INTO wiu_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Nipa kini ta ludu u̱u wa poi toa kakoimo yakoa ni pade take poi tago wa okoimo kugu yakoa toino, piti moameamene. Enilepa taatekoa namolo takoa toatekoyake wipitia ta pade tigotokoa wete patamoo tokolo ni uku wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Nimo ootokoa okome e ku yatename poi tato wa kamoa poi te̱itakutukakala toi. Ni e ku tobou agoke lukoa meki yatene ete oto wa poi toa winali yoi. ");
INSERT INTO wiu_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Momani-kala tube mati toa eka kuka takeka kobu igi nome poane yene igi nome tokala too. A tibukeka ali atoa piti takatekole-kiti witoa ni Akolaliyo one toateka adeka piipikomepa padele padele tubele mati witakakala too. ");
INSERT INTO wiu_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Enilepa wete taatekoa toameneyake ete-kitame kiwi dekoa moa tete mekala toi. Nipa kini losu yapuka po yapuka lia aua pokala toi. Ni ako odene tobou mekoi ali-kiti mekoika eni ali-kitike lokoa ta yopikoi ali-kiti mekoika lia aua pote koiso akakala toi. Anukule takama pokoileke nitoi. ");
INSERT INTO wiu_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Nitikoi-petepa kini lene yoto kakete anukumo i i wa to̱awea akakala toi. ");
INSERT INTO wiu_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Nipa edemo wane uku patu wa kini wa kei piatekoimo wene kibutukapiameamene. ");
INSERT INTO wiu_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Noanumepa kiwi wene taka taka tokolu tokome agale muno kakoa okoli kipala poi teigoi yename moa kautakamele toamoa agaleka topo takamele toamoa too. ");
INSERT INTO wiu_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Kiniketai kinika̱ua kinikameyo kiwi-pala po piane yene kini oya-mikiti enika eni yene peyameka ete ali-kitane yonoke kiwi moa pikala toi. Nitima pekete kiwi padeka-kiti wia tukakakileka toi. ");
INSERT INTO wiu_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Nipa kipa no-pala odene ibini pedane ali atoa tokome ete yene peya kiwi-pala kotimi yoa meoi. ");
INSERT INTO wiu_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Nitiketeke kiwi-pala padeleka tamele toamokale tobou witako pine odeneka toa potokamele toamoo. ");
INSERT INTO wiu_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Eni ke enekakale meake nooke wene tugoa mea togaketepa kini wa toa moino, poapeneya kamene wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Poyo yatene Yerusaleme take obomoa note dekali toa unukatapea kakoli eneketepa Yerusaleme ta wia tadekatapeneya tumu tokateko oi tigotokoa nekedeko wa wene toi. ");
INSERT INTO wiu_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Nitikoi-petepa Yudea ta ludu pitikoi-kitipa nipa tono pake pake to̱a pitoa pote paigakoa mepamene. Yerusaleme pitikoi-kitipa nipa kini eni ta wete to̱a pitoa pamene. Tayo kakoi-kitipa nipa Yerusaleme take pitoa poameneya paka lono pitoa pamene wane uku. ");
INSERT INTO wiu_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Enipetepa Akolaliyo ali atoa kibu motikilepa one bokuke papete wia mekapiane toa-kama taatekoa too tokolo ni uku. ");
INSERT INTO wiu_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ae, mati kakene atoa-kitika mati adu tanikakoa mekoi atoa-kitika eni tete witaka-pete manika edoa petoa pomotoa-pe. Ae, enipetepa itonoke dika dika toamene tete witoo. Akolaliyoka one Yu yatene-pala kotimi wene luaneya meoo. ");
INSERT INTO wiu_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Nitaneyake kipala poi te̱iane yename kiwi padeka-kitipa tueme ka̱wa tukoa ni padeka-kitipa e ku yatenane ta piko peyake tadekamu toa aua pootapeoi. Yerusaleme taapa mone pa yatene-kitame kautoa wia tadekatapekoli pa tumu tokaneya pioo. Nipa Akolaliyo eni mone yatene-kiti kiwika wiou wa moa atukateka oi ponokaleka pa tumu tokaneya pioo wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Nitaneyake a tibukepa lou tokene tagoi moa padele padele tokale eneketepa ae ile toatekolo toko wa enekala toi. Kusa ue mekokaka u̱u okoa kawa pewikoa kawoo. Itonokeka e ku yatene tepe we tokale wene kainya pianeya meoi. ");
INSERT INTO wiu_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Nipa itonoke padele padele wipitikome toademe tokale nepia meketepa pitime tukete pitakala toi. A tibuke tele taneya mekiya peteka peteka tokale enekete nitoi. ");
INSERT INTO wiu_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Enika enile toka-petepa no Ali Yatenane Oyago wedo patu meane pa̱ teleta toawineya noadene nokolu enoi. ");
INSERT INTO wiu_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Enika enile titia witakale eneketepa nipa Akolaliyo kiwi toa moateko oi tigotokama noademe toko wa wene weye akeneya meamene wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yesuyo agale pade pedoa okome okome yomo piki eteya yomoka witakoleke ukunu, yakamene. ");
INSERT INTO wiu_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Luno pitikakolo eneketepa poto toko tokene-mene tigotatekolo toko wa kime wene tiki. ");
INSERT INTO wiu_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Eina toa anume ina okounakale-kiti witakale eneketepa Akolaliyo ali atoa pawe toa talo toateko eni tigotokona wa wene toi. ");
INSERT INTO wiu_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Etene nimini toatekomo ukuno, yakamene. Ipete meki-kiti peya wete tuutapeameneyake kiwi-pala ina okounakale peya taatekoa too. ");
INSERT INTO wiu_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Nipa itono tibuta takoa pootapekolika anu agalepa pa pia-kama kawoo wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Ina okounakale pubu wameneya odepeta wako pitigatapekome toko toa taatekoa toademe tokono, wedoa meamene. Nipa pale paleta toa ni bia ue nokoa pia ni kini toatekoile nami namita kakale wene keda taneya mekayano, wedoa meamene. ");
INSERT INTO wiu_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Enika enile taatekoa tokomepa ali atoa ta piko peyake pitikoi toa taatekoa too. ");
INSERT INTO wiu_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Enika enile-kama taatekoa toka-pete no Ali Yatenane Oyago kakouta katepitoa note kanadetepa lene tuaneyame wia mea Akolali kowitima pamene. Nipa katepitoa noatekoi tele lukamotoa kowitamene wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ta pataka abuna Yesu tobou losu yapu pome olaukapokala taneya. Nitimotokome likonupa Olipe-pini wa ibini akene tonoke ete wa pome pipokala taneya. ");
INSERT INTO wiu_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Nitaneyake one eni olaukakome oka agale yakadetepa ali atoa peya likonu witia tobou losu yapu-kama note obonokala taneya. ");
INSERT INTO wiu_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Edelo ago patukane wa ibini akene toge kikete pa palawe yisi kugu pitikamoa yotane palawe yoa noatekoi oi tigotokoa nekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Nitaneyake Akolalike lodo yotokoai tane tobou ali-kitameka Mosesene totono pine to̱a olaukane ali-kitameka Yesu edoa katekoa wiato wa wili tokoa kakeneya. Nipa ete ali atoa piti motekete taneya. ");
INSERT INTO wiu_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Yesu-pala tuku kakoa (12) opia yakene ali-kiti pade Yudase einagoke Setanu awinaneya. Einagopa one pade ibini Isekariose. ");
INSERT INTO wiu_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Einagopa Akolalike lodo yotokoai tane tobou ali-kitika tobou losu yapu talo tane tobou ali-kitika koukoa mekoita pokomepa Yesu kini yonoke moa piateka oi pedoa pianeya. ");
INSERT INTO wiu_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Nitaneyake wedia mekete ekete nipa nee kue meoo-koli okome ");
INSERT INTO wiu_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","nitikouno toe wa tewitikoa pokomepa Yesu moa metekome toatekale wene kibutuma yakeneya. Nipa ali atoane kabeta pake kawamokale nitou wa wene kibutuma yakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Yu yename yisi kugu pitikameneya pa palawe wane-kiti yoa toge kikilepa sipi sipi kai tine-pala moa wia kikala taneya. Nipa edelo ago Idipi ta patukakale Akolaliyo Iserele yene toa motane oi wedekoa nitaneya. ");
INSERT INTO wiu_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Eni sipi sipi kai wiateka oi nokale Yesuyo Pita Yoneta moa wetekakome okome edelo ago patukane toge kiatono, eni toge nee wete nodokakapoatino, poe wa wetekakale ekete ");
INSERT INTO wiu_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","eni toge nee manika nodokatoa-pe wa okoli okome ");
INSERT INTO wiu_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yerusaleme take pote kaalaukete enekoli ali pade one wagoke ue mete kakalogoa aua nome kotukale enoino, einago litima pote one tuapea poka yapu tuapea pamene. ");
INSERT INTO wiu_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Tuapea pote yapu pinago enekete ekete Tikisa agome okome one oya-lawe-pala opiane mekene toge nee nouno, neke ugu yene note meai tiki yapu luku yameano ta wa oka wa akamene. ");
INSERT INTO wiu_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Kitame nimo okoli yatekome pinagome ako yuane yapu luku yametekilepa toto meateko walai eya nodokapianeya yameoono, eidapa tone toge nee eya nodokakoatino, poe wa Yesuyo one oyali-kiti takuta moa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Nitikale pote enekoli Yesuyo eina okanakale tadeka. Nitadekale einata kini toge kia noatekoiya nodokaneya. ");
INSERT INTO wiu_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Nee noatekoi-petepa Yesu nokome one Aposelo ali-kiti-pala walai waneke lewitoa meaneya. ");
INSERT INTO wiu_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Nitoa mekome okome anu moatekou tete wete moamekenepa edelo ago patukane toge kiko-pete kipala opiane mekene nee noadiyano wene-kama piane mekou. ");
INSERT INTO wiu_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Edelo ago patukane toge nee nakilepa Akolaliyo talo toko take mekene toateku adeka pikene tuku. Papete wa pade noamadeneke tuku wa ootokoa ");
INSERT INTO wiu_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","gerepi po ku̱ ue mete mekaneya katekamoa Akolali-pala ke wa ootokoa okome kiwi peya tatia noatino noe. ");
INSERT INTO wiu_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nipa gerepi po ku̱ uepa Akolaliyo talo toko ta wete witameneyake papete wa pade noamou wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ni palawe waneka moa Akolali-pala ke wa ootokoa popimotokome tatia metekome okome ipa anu tiginino, kiwike toane i metekuno, moa noe. Noe wane metekilepa i mekete toko toapa no wene taneya mea toma pamene wane meteku wa metaneya. ");
INSERT INTO wiu_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Nitaneyake nee nootokoa mekete eina toa Yesuyo okome i gerepi po ku̱ ue meteke mekaneya noe wane metekilepa kiwike toane anu kamate ponateko adeka piane meteku. Nipa Akolaliyo oi pedoa pikana toane tekene kini wenele litia toatiki totono kadimo oane yametekene uku. ");
INSERT INTO wiu_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Nimo wanepa ukuyake eya waneka ukuno, yakoe. Mone yename no wia tukamotoa moa meateko agopa one yono i walaike anu yono-pala odeneka pianeya. ");
INSERT INTO wiu_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","No tukilepa Akolaliyo papete wene toopikana toane taatekoane tuou. Ae, no wimotoa moa meateko agome dika dika toamene tete moo-kale ");
INSERT INTO wiu_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","one oya-lawe ete oto wa yakaate tekete ekete ina okanapa mainagome toademe tokolo oko patu wa oote toa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Yesuno oya-laweme agale oa takoa pili pili toa kakete ekete totopa mainago ako ago meko patu wa togo togo oa kakoli ");
INSERT INTO wiu_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesuyo okome mone pa yatenane tobou ali-kitame kiwike lukoa meki-kiti pupu toe toe wa tika tika tiki. Nitikilipa kiwike lukoa meki-kitame kipa toto auapeki yeneno, ke wa kiwi kei piki. ");
INSERT INTO wiu_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Anu oya-lawe kime pade edikameamene. Nitameneya ako ago nepa pene ago tetepo takoa meamene. Tobou ago nepa pa pupu ago tetepo takoa meamene. ");
INSERT INTO wiu_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ali takutapa panago nee mekome nomotoa padena agome one nee takoa lawetekolo-kiti ako agopa mani ago-pe. Nee mekome nako agopa ako ago eni. Noanupa kini pupu ago mekene uku. ");
INSERT INTO wiu_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ke enekakale mema yakouka anu oya-lawe kime no kagekama yakoinano, ");
INSERT INTO wiu_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Agetaiyo no ne tobou ago mea wa ali atoa yopiane meatekou ta yameteka toane tekene kime ali atoa yopia meatiki ta opi yametekene uku. ");
INSERT INTO wiu_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Nipa anu talo toateku ta no-pala opia mekete nee ue eya nomotoane nitiku. Eni uku toapa tobou ali meatekoi walai-kitike eida mekete Iserele yatene tuku kakoa (12) tatite toa takoa enoa akakala toi wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Saimone Saimone ne-pala ukumo yakamene. Ali-kitame witi ku̱ yaku-pala eletekoa pianeya peteka peteka tiki toa Setanuyo ne i agopa edikoane toadene mano wa Akolalineke oia motokome akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Nitaneyake Akolalinele takama pokeke tewitikoa wakaya tokale neke kowitikakene uku. Wa naniko pale toake eni wene wia wakepa neke oya-lawene wene weye akakala tamene-kale okome ");
INSERT INTO wiu_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ali Muno ne po yapu pitikakolika wia tukakolika noka po yapu pitikoa wia tukoa tomotoane uku-kale okome ");
INSERT INTO wiu_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","ne-pala i ukumodo yakamene. Opi ali ogada ta patameneka wete ka̱ wameneyake nemepa no i ago wene toamuku wa tebolo-peta akoa wakala too wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yesuyo nimo ootokoa okome namolopa Akolalinemo oa pupitikapekete kue ka nee uatekoi kaka uameneya kawa yeneka mekameneya pa toma poe wane wetekakounake pa pima yakoi-pe-kale ekete e̱'e mena-koli okome ");
INSERT INTO wiu_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","opidopa kini kue uatiki kaka nee eya uatiki kaka pikolopa nipa moa aua pamene. Tue pade toamokolopa nipa tokoo kakene mamina takoa topo toa moa lua pamene. Ni edoa-mo. ");
INSERT INTO wiu_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ete-kitame i agopa Akolaline totono tagoa toamoko ago wa akoa wawei wa wia mekapiane agalepa nooke tugoa taatekamedeko. No toatekoumo wia mekapiane agale taatekateko tigotoma noko wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Nitikale ekete Ali Muno tue takuta i pikono, ena-koli okome nipa oyake toko wa pekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesuyo nimo oomotokome one tanele tokome Olipe-pini tonoke pekeneya. Eni pokaka one oya-lawe litima pekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Nitoa eida pome kakome kipala okome kiwi likoa enekaya wa Akolali kowitoa kamene wa ootokoapa ");
INSERT INTO wiu_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","alime kue mitapeko kotuke keneya pome neuwe tukupia kowitoa meaneya. Nitoa kowitikome okome ");
INSERT INTO wiu_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","meteke no noateku ue enekupa no tete mati moatekulu enipa tokono, Atai neme ete wia pedekamedekalepa nitikamene. Nipa anu wene pikule toa wane ekene wamukuno, neke wene pikole tou wa Yesuyo kowitoa meaneya. ");
INSERT INTO wiu_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Nitoa kowitoa mekaka edelo ago pade one weye akademe tibu kawa nekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Nitaneyake tepe we toka matiyame wedoa kowitoa mekale poliga kamate wane keneya pilipita pilipita toa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nitoa kowitatekoa kamomotokome one oya-lawe mekoita wakapea pokome enekale elame tuaneya tokome atu pia meadekoi. ");
INSERT INTO wiu_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Nitadekoli okome dekolo atu pia meki-pe. Setanuyo kiwi likoa enekaya wa kamokoa kowitoa kamene wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesuyo nimo oa kakaka ali peya mati obomoa nekeneya. Yesuno oyago pade Yudaseyo eni yene lia aua nokome Yesu nunu oademe pinele nekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Nitoa nunu oademe tokale Yesuyo okome no Ali Yatenane Oyagopa pa yename motokamotoa nunu eke toko-pe wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Nitaneyake Yesu-pala toadete tokoile enekete one oya-laweme ekete tone tueme wia litiato-pe wa oa ");
INSERT INTO wiu_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","one oyago padame panagono kapidi pine takoa pitikaneya. Nipa Akolalike lodo yotokoai tane ako tobou agono pupu ago nimini yono lono kakene kapidi pine takoa pitikaneya. ");
INSERT INTO wiu_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Nitikale enekome Yesuyo okome oyakeno wa wa einagono kapidi luku mitikatekoa ete wa kakakaneya. ");
INSERT INTO wiu_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Nititikoapa Akolalike lodo yotokoai tane tobou ali-kitika tobou losu yapu talo tane tobou ali-kitika Kanosolo ali-kitika one eni dekoa moadete nekene yene-pala okome kini tue lua layo tigini-pala nidikoa aua nikino, nopa ali wia kode moa toko ago tetepo takoa tiki-pe. ");
INSERT INTO wiu_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ta pataka abuna tobou losu yapu keneke kiwi kakakoane eida-kama pone olaukakounake dekoa moamokoina. Opi i dekoa monikilepa yomiyomu yopikago patu kautakete toatiki-pete tokome ni tiki wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Nitaneyake eni yename Yesu dekoa moapa ako odene mekome Akolalike lodo yotokoai tane tobou agono yapu aua pekeneya. Aua pokoika Pita kutu mati kawati toma nekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Eina tobou agono yapu pawe keneke pade-kitame pomale toe yoa payapono pia unukoa meaneya. Pita oneka eni yene pake pome lukoa mepaneya. ");
INSERT INTO wiu_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Nitaneyake tobou agono pupu atoa padame enekale Pita toe pa̱ake mekale leneme nepikoa pikome okome i agoka Yesu kuyago-pala opia pima yakome taneya wa okale okome ");
INSERT INTO wiu_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","anuyatoa, no winago wene toamuku wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Naniko keneya panagome Pita enekome okome neka Yesuno oyago-kale okome e̱'e, nopa one oyago mena wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Lou pini odene tadiya ponotekaneyake padekagome okome i agopa Galili agono, Yesu kuyago-pala opia pima yakeneya tadeko-kale okome ");
INSERT INTO wiu_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","winipa pa okono, neme wini oka agale agopa tokolo meku wa oa kakaka eina eina ali ogada ka̱ oa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Nitikale Ali Muno ago Pita kakata peketapekome nepikoa pianeya. Nitikalepa Ali Muno agome eya wa okana opi ali ogada ka̱ wameneka neme no einago wene toamuku wa tebolo-peta akoa waoo wa okana wene ponokale ");
INSERT INTO wiu_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","akolono pokome komo ka̱ta pitikoa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Yesu eida yopia kakene ali-kitame one tegene matoa layo toua wikala taneya. ");
INSERT INTO wiu_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Mamina nateyaka moa one lene timini mutuapa one wane kapidi eyake kala dekoa witikete ekete ne teyo witikato-pe wa wikala taneya. ");
INSERT INTO wiu_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Nitoa pademo pademoka oa potokoa tea agale okoa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ta patakaka Yu yenane Kanosolo ali peya Kanosolo yapu koukoa meponaneya. Nipa Akolalike lodo yotokoai tane tobou ali-kitika Mosesene totono pine to̱a olaukane ali-kitika eida koukakoita pade ali-kitame Yesu-pala aua note kakakoli ekete ");
INSERT INTO wiu_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","nepa Keraisu wa papete ibini oa piane ago tadekalepa wete a-na wa okoli okome e̱eno, nopa einago wane okoluka kime yakoa moamoi. ");
INSERT INTO wiu_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Noanumedo kiwi agale palene yatekolupa agale topo takoa wamoi. ");
INSERT INTO wiu_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Nopa einago tadeko wa yakoa moamokolika opi titimoane no Ali Yatenane Oyagopa telekole-kama toko Akolaline nimini yono lono meane kama poukene tuku wa okale peyame ekete ");
INSERT INTO wiu_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","nipa Akolaline mana kaku wa eke oko-pe-koli okome nopa einago wa wini ekete iki-kale ekete ");
INSERT INTO wiu_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","one koiso akoa oatekomopa pinali one kabunume ina okanano, one pademo okamoka wa pade yakateko toa mena. Oyake yatekoona wa oa tukaneya. ");
INSERT INTO wiu_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Nimo ootokoa eni yene peya kamomotekete Yesu Pailase mekata lia aua pote kakapaneya. ");
INSERT INTO wiu_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Nitikete one akakete ekete i agome Yu ali atoa peya paka paleke lia motokome eya wa okale yatekoo. Tobou ago Sisane takesi kue pitikameo wa oa ni onepa ako tobou meateku ago Keraisu taatekoane nuku waka oa potokakale yatekoo wa Yesu akakete okoli ");
INSERT INTO wiu_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pailaseyo Yesu yatekome okome nepa Yu yene peya lukoa meki tobou ago-pe wa okale okome nopa einago wa wini okana wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Nitikale Pailaseyo Akolalike lodo yotokoai tane tobou ali-kiti ni eida oboa kakoi peya-pala okome i agome padele poaneleka toameadeko wa okale ");
INSERT INTO wiu_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","e yename Yesu wedoa akakete ekete Yudea ta piko peyake i agome i i wa olaukoa ali atoa oa kamotokama yako. Nipa kebono ta Galili take laigoa tone i Yerusaleme take tugoa nitiko wa one akoa akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","E yename Galili ta ibini okoli yatekome Pailaseyo okome i agopa Galili ago-pe wa yakaneya. ");
INSERT INTO wiu_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Nitoapa Yesupa Erodeyo talo toko take meane ago tadeko wa wene tokome i ago Erode neme pitia yakakamene wa one Yerusaleme take ugu nome mekata moa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Nitaneyake Erodeyo i agopa Yesu toko-la wa wedia kakeneya. Nipa Yesuyo tubele toma yakenemo yakatekoapa one mekuta padele tubele nokome tokale onemeka enadiya wa nepia meapa opi nekedeko wa wedia kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Nitikome pitia yakoai tokale Yesuyo agaleka wametekoa pa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Nitoa kakaka Akolalike lodo yotokoai tane tobou ali-kitameka Mosesene totono pine to̱a olaukane ali-kitameka dika dika wa one wedoa akoa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Erodeyoka one poyo ali-kitameka one paya tetepo takoa tegene matoa taneya. Nitaneyake mamina epetane mati moa kakoapa Pailase mekota aua poe wa kutu wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Einapetepa Pailase Erodeta oya kakoa liputakutukaneya. Namolopa poi te̱ia meetakutukoake nitaneya. ");
INSERT INTO wiu_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Nitaneyake Pailaseyo Akolalike lodo yotokoai tane tobou ali-kitika Kanosolo ali-kitika one mekuta noatino noe wa kayo oa motokome okome ");
INSERT INTO wiu_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","i agopa no mekuta lia aua nekete ekete i agomepa Lomane yateneke lukoa meamato wa kiwi Yu yatene oa kamotokama yako wa akoa okoina. Kiwi kakakoane one pitiane yatekeneka kini akoa okoina toa padeleka toameadeko. ");
INSERT INTO wiu_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Erodeyoka one pitia yakatekoapa one koiso akatekale piameadekale oto wetekakona. ");
INSERT INTO wiu_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Yakoe. One wia tukatekole piameadekono, eya tatoane uku. Poyo agome po wapime wikala tomotoane tootokoane po kotokoane wetekou wa Pailaseyo okale ");
INSERT INTO wiu_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","kini kabunu koukotukoa kayo ekete ekete winago wia tukakamotono ta. Eyago Barabasi po kotokoa oto wetekaka-ye wa ka̱ telo okoa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabasi einagopa Lomane tobou agome po yapu pitikakilepa Yerusaleme take Lomane yene-pala poi kamotokoa ali wia tukoa taneyake pitikaneya. ");
INSERT INTO wiu_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Nitane ago po kotokoa oto wetekaka-ye wa kayo okolika Pailaseyo Yesu po kotokoane wetekou wa wene pikome kini wene wia wamotoa oa enekale ");
INSERT INTO wiu_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ete wa kayo ekete winagopa yomo lekaneyake wia dekakamotoa wia dekakamotoa wa kayo okala tokoli ");
INSERT INTO wiu_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pailaseyo tebolo takakome okome i agome padele poaneleka toamedekono, one wiane tukatekule piamoko. One poanele edele taneyake iki-pe. Pa po wapime poyo agome wikala tomotoane tootokoane po kotokoane wetekou wa okale ");
INSERT INTO wiu_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","agale telo oa kamotokakoa kakeneya. Nipa one wia dekakamotoa tika tika tekete nenome moa patukakoli ");
INSERT INTO wiu_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pailaseyo nitikou toe wa eya taneya. ");
INSERT INTO wiu_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Eyago Lomane yene-pala poi kamotokoa ali wia tukoa taneyake po yapu moa pitikane ago Barabasi po kotokoa wetekaneya. Nipa e Yu yenane wene litia taneya. Nitoapa i ago Yesupa moa kini wene litia topoe wa Yu yene moa metaneya. ");
INSERT INTO wiu_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Nitikale aua pokoika Sairini take ago Saimone tayo lono kawa nome kotukale dekoa motaneya. Nipa one mukitike eina lekane yomo aukakete ekete Yesu i ago namolo kawa pomotono, iyapa neme lia aua notokamene wa dekoa moa aukaneya. ");
INSERT INTO wiu_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Yesu eni pokaka ali atoa obomoa litima nekeneya. Nipa atoa-kitika one elame tukete komo ka̱ta oawineya litima nekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Nitikoli peketapekome okome Yerusaleme atoa-kiti nooke pade komo wameamene. Nitameneya kini mati-kitikeka pinatoa-kiti kiwikeka komo oa kamene. ");
INSERT INTO wiu_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ae, dika dika toamene tete moatiki tigotoma noko. Enipetepa eya wa oi. Kini mati-kitame eni tete motokaya tokale mati opiamoa adu tanikakoa meamoa pa tioboya meki atoa-kiti kolotine meamele toko wa oi. ");
INSERT INTO wiu_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Nitoa tube tono-pala kayo oa ekete kilikete toto wio-ye wa oa ni de tono-pala kayo oa ekete kilikete toto kauta-ye wa kayo oa toi. ");
INSERT INTO wiu_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ae, yomo weneyake dikoa tikino, kau toa tuaneya kakalepa edele toi-pe wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Yesu wia tukadete aua peketepa poanele tane agotaka wia tukadete aua pekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Nitoa ali wago wa ibini akeneta tugoa kakete Yesu eida yomo lekaneyake wia dekaneya. Poanele tane agotaka yomo padetake wia dekaneya. Nipa panago one nimini yono lono wia dekoa padena ago one ewa yono lono wia dekoa taneya. ");
INSERT INTO wiu_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Nitoa kakoli Yesuyo kowitikome okome Atai wene toamekete tikino, kini i tikike po letu mekoa kibu moameamene wa kowitikaneya. Nitaneyake poyo ali-kitame one mamina-mene tatiato wa tadu toa tatite taneya. ");
INSERT INTO wiu_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Pa ali atoa eida kakete nepikoa kamotoa tobou ali-kitame tegene matakete ekete i agome ete ali atoa toa motaneyake i dekaneya kako. I agopa Akolaliyo one wa takoa moa kakapiane ago Keraisu tadekalepa nipa pinali one wa toa moono, tokale enato wa tea agale oa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Poyo ali-kitameka one tegene matakoa pinele nekete kou tane gerepi po ku̱ ue ne na wa metekete ekete ");
INSERT INTO wiu_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","nepa Yu yene peya lukoa meki tobou ago tadekalepa pinali neke wa toa moa-na wa ya motokakete akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Yesu eni wia dekakete one wago pitia lekane yomo munoke pipia eya wa wia mekoa dekaloganeya. I agopa Yu yene peya lukoa meki tobou ago wa wia mekoa dekaloganeya. ");
INSERT INTO wiu_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","One-pala odeneka wia dekane ago poanele tane ago padame Yesu-pala oa potokakome okome nepa Keraisu patu. Nepa einago tadekalepa pinali neke wa toa motekepa totaka toa moa-na wa oa potokaneya. ");
INSERT INTO wiu_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Nitikaleka padena agome o ago kikoa okome nepa i ago-pala wia tukatekoi oi pedoa pia wia dekaneyano, Akolali piti moameke oko-pe. ");
INSERT INTO wiu_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Totapa tone tokoo poaneleke nami wia kibu motaneyano, i agome padeleka toameneyake pa wia dekaneya kakono, dekolo oa potokako-pe wa kikoa ootokoa ");
INSERT INTO wiu_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Yesu-pala okome Ali Muno neke talo toko take poke mekepa no wene taneya meamene-kale okome ");
INSERT INTO wiu_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","nimini ukuno, yaka. Opi nepa no-pala ali atoa mea epetekaki take Paradaise take odeneka meoo wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Einapete lou matai ponome kakaka (lou pini 12 kilokoke) tadiya ta lia kadukaneya. Lou pene webokaka (lou pini 3 kilokoke) ta pa likatapeneya. Lou pa̱ toameneya tokome taneya. ");
INSERT INTO wiu_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Kuna tobou losu yapukeka eya mamina Akolali meko lono wa akene luku olege toa ketekalogane mamina ete oto iyawea tukaketikaneya. ");
INSERT INTO wiu_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Nitikaka Yesuyo telo ootapekome okome Atai anu yominipa takoa pomotoane ukuno, neme moa ta wa ootokoa tukome tuaneya. ");
INSERT INTO wiu_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Enile tokale enekome tobou poyo agome okome i agopa nami kawamene ago tadeko wa Akolali kei pia kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Einali-mene wia dekakete tokoile enadete obomoa nekene yename enika enile tokale enemotekete kini kini yapu yapu wakapea pekeneya. Nipa tepe we tokale kini palanu wi wi toma pekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Yesuno oya-lawe peyaka one-pala Galili ta kawa Yerusaleme take opia nekene atoa-kitika eka mati kakete enika enile tokale enekoa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Panago Arimasia take ago Yosepe Kanosolo agomeke ete Kanosolo ali-kitame Yesu wia dekatekoi oi pedoa pianele litia toameneya. Einago wene ki̱yo akeneya mekome epetanele-kama tane ago tokome Akolaliyo ali atoa pawe toa talo tokale nepia meaneya. ");
INSERT INTO wiu_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Einagome Pailaseke pokome okome Yesuno tigini mouno, mea ta wa opokale ");
INSERT INTO wiu_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","nipa mopoano pa wa yametekale pokome to̱a motaneya. Nitoapa ake tane mamina petene moa tatilogoa Yesuno tigini pia ewetetapeneya. Nitimotokome pome pala padaneta kokapiane kota keneke moa pipaneya. Nipa tuane ago odeneka wete moa pipameneta eni moa pipaneya. ");
INSERT INTO wiu_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Yu yene ko mea pupu toamatekoi oi tigotokale nodokoa meane-pete enile taneya. ");
INSERT INTO wiu_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Yesuno tigini eni moa pipokalepa eya atoa-kiti Yesu-pala Galili ta kawa Yerusaleme take opia nekene atoa-kitame einago Yosepe litima pekeneya. Nitaneyake eni kota keneke one tigini pikome tokale enemotekete ");
INSERT INTO wiu_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Yerusaleme take wakapea pekete one tigini ka̱lono takatekoiya nodokoa pianeya. Nitoapa Mosesene totono piane toa tekete ko mea pupu toamene-pete yapu pa ko meaneya. ");
INSERT INTO wiu_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Egeme ta tu̱ei teigaka einatoa-mename eina ka̱lono taneya ete pia nodokoa pianeyapa aua pato wa Yesuno tigini pipaneta pekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Nitoa pekete enekoli one pipaneta kota kabunu ketekalogane kue ete koketekaneya kakedeka. ");
INSERT INTO wiu_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Nitoa tuapea pote kakete enekoli Ali Muno Yesuno tigini piameadeka. ");
INSERT INTO wiu_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Nitoa wene kainya pianeya kakoika alita takuta mamina yati yati tane mati kakeneya kotikatapea kini kakoiya liti note kananeya. ");
INSERT INTO wiu_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Nitikoli enekete piti moa keti walikoa kakoika einagotame ekete i kota kenekepa tuane ali atoa piai toatikiyano, yomini meane ago dekolo oto tuku toa niki-pe. ");
INSERT INTO wiu_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Kime tuku toniki agopa wete kamoa poka. One Galili take kakome kipala okana agale wene kayapeaneya tokome ni niki-pe. ");
INSERT INTO wiu_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Eya wa okana. Panagome Ali Yatenane Oyago moa poane ali-kitane yonoke pikale yomo lekaneyake wia dekoi. Nitikolika ta pataka teboloke piane kamoane pou wa okana wa einagotame okoli ");
INSERT INTO wiu_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","e winimopa nimini akediki wa one eina okana wene kibutukete akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Nitoapa Yesu pipaneta tewitikoa one tuku melepu kakoa (11) oyali mekoita pekete kini enoa yatekoinakamo i i wa one oya-lawe-palaka ete yene-palaka to̱awea akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Nipa Yesuno Aposelo ali mekoita pote to̱awea opikilepa eya atoa-mene Magadala Maria Yoanata Yamene nine Maria toa ni kiwi-pala opia pekene atoa-kiti enika eni atoa-kitame to̱awea opaneya. ");
INSERT INTO wiu_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Nitikoli yatekete pamo akene tetepo tokale yakoa moameneya. ");
INSERT INTO wiu_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Nitaneyake Pita kamomotokome Yesu pipaneta teyapea pome kota kabunuke kakome watekoa enekale tigini togotane mamina odene pa pikale enaneya. Nitoapa edele taneya patu wa wene kibutuma pome wakapea pekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Einapetepa Yesuno oyata takuta Emease take poadete pekeneya. Emease ta Yerusaleme tata pake tuku melepu kakoa (11) kilomita tadiya pianeya. ");
INSERT INTO wiu_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Emease take eni poadete pekete Yerusaleme take tanemo koota oma pekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Nitoa koota oma pokoika Yesuyo moa tikitikamotokome opia pokale ");
INSERT INTO wiu_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","one lene timini agopa motekete pade eina opia pokono wene pia pekeneya. Nipa padeleme kini leneta likatapeane tetepo taneya pekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Nitikoli opia pokome okome koota wini oma pikimopa edemota iki-pe-kale weneta keda taneya witimoa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Nitoa kakete panago Keliopasi wa ibini akene agome okome okome Yerusaleme meki peyame wene tomotoake neme odene abela ikonota tanemo wene toameke oko-pe-kale ete kita-pala okome ");
INSERT INTO wiu_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","edemoke iki-pe-kale ekete Nasarese Yesuke oko. Einago Akolaline agale akakagome Akolaline lenekeka ali atoane lenekeka padele padele toa pademo pademo oa tikilepa telekole-kama toa toka. ");
INSERT INTO wiu_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Nitima yakanake Akolalike lodo yotokoai tiki tobou ali-kitameka tone ete tobou ali-kitameka eya tokoi. Einagopa mone agome wia tukateka koisoke aua pokoi. Nipa yomo lekaneyake wia dekamotoa wakoi. ");
INSERT INTO wiu_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Inakagopa toto Iserele yene oto toa moatekago taatekoa nokono wene pikoonake wia dekakoi. Eyakeka wene keda taneya meko. Einago wia dekatekaneyake ta patako tebolo eni patukakona. ");
INSERT INTO wiu_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Nika ta tu̱ei teigaka tone oyatoa padeka-kitame one pipaneta enepokoli one tigini piameadeka. Piameadekale enemotekete toto mekoota wakapea nekete tone wene kainya pikakete ekete pulete keneya enekolo one pipaneta edelo ago takuta eida kakoli enekoo. Enekolo ekete inakago kamoa poka wa okoi wa einatoa-kiti toto mekoota note onokoi. ");
INSERT INTO wiu_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Nitikoli tone oya-lawe pade-mene one pipaneta pekete enekoli einatoa-kitame okoina toa tadekale eneketeke Yesu pade enameneya wa einagotame Yesu-pala akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Nimo okoli kita-pala okome okome ae, kolotini lupi toa paya wene pianeya mekete iki. Akolaline agale papete to̱awea akane ali-kitame Keraisuke wia mekapianemo lugutukoa oi mokala teketeke yakoa moamekete tadiki. ");
INSERT INTO wiu_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Keraisuyo eni tete moa meemotokome one pa̱ teleta tootapeneya mekanata wakapea poo wa wene toamokoi-pe wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Nimo ootokoapa Moseseyoka Akolaline agale papete to̱awea akane ali-kitameka wia mekanemoke titimoa Keraisuke oa piane agale peya pine i i wa to̱a kibutukakutu toa ootapeneya. ");
INSERT INTO wiu_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Nitoa oma pomepa one oyata pote piatekoita tigotokale patukoa poademe keneya tokale ekete ");
INSERT INTO wiu_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ta lima nokome lou-pala pipademe tokono, tone piatono noo wa kowitikoli nipa piatoe wa yapu tuapea pekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Nitoapa one oyata-pala walaike opia mekome palawe wane moa Akolali-pala ke wa ootokoa popimoa metekale ");
INSERT INTO wiu_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","eina eina kini leneta kikatapeneya i agopa Yesu tadeko wa wene tokoli agopa takatapea pekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Nitaneyake oyagota ootakutukakete ekete ataiyo inakago tota-pala ka ludu ko oma nokome Akolaline bokuke wia mekane agale pine to̱a kibutukakutu toa ootapekale kolotine yakama nokoo wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Nitoa eina eina kamomotekete Yerusaleme wakapea pekete enekoli Yesuno tuku melepu kakoa (11) ali-kiti ete ali atoa-pala koukoa mekoli enaneya. ");
INSERT INTO wiu_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Nitikoli ekete Ali Muno Saimone Pita mekata ponokome lene timini yametaneyano, one tuake wete kamotadeko wa e yename kita-pala akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Nitikolipa Yesu ka ludu opia nokome akenemoka palawe wane popimoa metekale i agopa Yesu tadeko wa kitame wene tanemoka i i wa to̱awea akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Kitame nimo oa kakoika Yesu kiwi pakeke nome kakome okome tepe kolotini mataketikoa meamene wa okale ");
INSERT INTO wiu_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","ekee, yomini pade nome kako wa piti moa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Nitoa kakoli okome tepene li̱ li̱ wa kawa pome taneya mea tikino, dekolo tiki-pe. ");
INSERT INTO wiu_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Noanu i kakuno, anu yono kawata enoe. No yominido tokolopa nipa melepu tono eya kakeneya kawamuku wa ootokoa ");
INSERT INTO wiu_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","one yono kawata enoe wa yametaneya. ");
INSERT INTO wiu_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Nitikale wedoa wedia kakete i agopa Yesu tadeko wa wene toake kamoa noamene tetepo takoa wene kainya pia kakoli enekome okome no noatekuya pade piko-pe-kale ");
INSERT INTO wiu_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","yotane mou kugu moa metekoli ");
INSERT INTO wiu_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","kiwi kakakoa moa nakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Nootokoa kakome okome no wete tuamekene kipala opiane yakene eya wane okouna wene takakene ukuno yakoe. Moseseyo one totono yamea ni Akolaline agale to̱awea akane ali-kitame agale wia mekoa ni Depidi-loeme lo agale wene kibututukoa wia mekoa tanepa no nekene toatekoumo i i wa wia mekapikala taneya. Nooke eni wia mekapiane toa-kama taatekoa too wane okouna wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Nitoapa Akolaline bokuke oneke wia mekapiane agalepa ipa iyake akeneya, ipa iyake akeneya wa wene takatapeneya. ");
INSERT INTO wiu_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Nitikome okome eya wa papete wia mekapianeya. Keraisu taatekoa nome tete moa mea tukomeke ta pataka teboloke kamoa poo. ");
INSERT INTO wiu_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","E ku yatene-kitameka kini tokoi poanele tewitikoa wakolipa eni poaneleke po letu mekakana Akolaliyo keetapea agopa takatapeo. One eni toatekamopa Yerusaleme take titimoa ta piko peyake i i wa Keraisuno ibini wedekoa oa pupitikoi wa wia mekapianeya. ");
INSERT INTO wiu_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Eni papete wia mekapiane toane taatekoane toma nokoule anu oya-lawe kime enekoinano, i i wa oawineya pamene. ");
INSERT INTO wiu_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Agetaiyo i ago moane wetekou wa papete oa pika ago kiwike awinomotou. Einago a tibu mea kiwike awinokome tele lukademe tokono, Yerusaleme take nepia meamene wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Nitimotokome Yesuyo one oya-lawe-pala Besani take aua pokome one yono ate kamotokoa kakome Akolaliyo i yene pewe wia ta wa kowitoa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Nitoa kawa tewitikoa pokale Akolaliyo moa a tibuke aua pekeneya. ");
INSERT INTO wiu_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Aua pekeneyake one oya-lawe neuwe tukupia one kei pia kaamotekete Yerusaleme take wedianeya wakapea pote mepaneya. ");
INSERT INTO wiu_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Nitaneyake tobou losu yapuke-kama oboa mea Akolali-pala ke wa oa one kei piai toa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Namolo namolo titikome padeya deyaka wete latia piameneyake panago pa mea kakeneya. Einago one ibinipa Akolaline Agale. Akolaline Agalepa Akolali-pala opia-kama meaneya. Akolaline Agalepa oneka Akolali. ");
INSERT INTO wiu_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Namolo namolo einagopa Akolali-pala odeneka meaneya. ");
INSERT INTO wiu_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Padeya padeya peya Akolaline Agaleyo Akolali patu kautakoa kakome latianeya. Padeyaka one weneme titia alaneya mena. Akolaline Agaleyo-kama latikala taneya. ");
INSERT INTO wiu_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Padeya padeya peya alama nikilepa Akolaline Agale patu-kama kautakoa kakete alama nekeneya. Eniya peya alakakagome ali atoa pa̱ takoa meko. ");
INSERT INTO wiu_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Yomiyomu keneke eni pa̱ tokoa kakolopa yomiyomume moa atukamele toamoko. ");
INSERT INTO wiu_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Panagopa Akolaliyo moa wetekakale taatekoa nekeneya. Einago one ibinipa Yone. ");
INSERT INTO wiu_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Einago taatekoa nokomepa eni toko pa̱ ko oademe noka. Nipa ali atoa peyame eni oka yakoa motekete Akolaline Agaleke wene tugamotoa tokome one ko oma noka. ");
INSERT INTO wiu_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Einagopa pa̱ pinago mena. Pa̱ pinago ko oademe taatekoa noka. ");
INSERT INTO wiu_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Pa̱ pine agome ali atoa peya pa̱ takalogakoya. Yone meane-pete eni pa̱pa itonoke noademe nekeneya. ");
INSERT INTO wiu_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Einago itonoke taatekoa nokalepa einago i nekedeko wa ali atoame one wene toamokoi. Akolali patu kautakoa kakome itono eya latia pianeyake one latikanakeya-kitame one wene toamokoi. ");
INSERT INTO wiu_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","One yatene mekoika eni nokoyake one yename one makutukoa moamokoi. ");
INSERT INTO wiu_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Nitaneyake one makutukoa motokoi-kiti kipa Akolaline mana kono-mikiti meamele toko wa moa kakapika. Nipa one ibinike wene tugoa mekoi-kiti nitika. ");
INSERT INTO wiu_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Akolaliyo one mati-kiti opiou toa eni yenepa one mana kono-mikiti moa latikakilepa one tanele tokome toko. Nipa ali atoame mati opikete tiki toa mena. One eni mana kono-mikiti itono alike tageneya mena. Kiniketaipa Akolali one. ");
INSERT INTO wiu_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Akolaline Agale einagopa ali latia toto pake pa tekei nome meka. Eni nokomepa pewe wia tagatapeneya mea nimini peku-pala nootapeneya mea toka. Nome mekale enekolo pa̱ teleta tootapeneya mekale totome enekoo. Nipa oneketaiyo one mana odene ago eni peku lawetekale noa toma yakale enekoo. ");
INSERT INTO wiu_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yoneyo one ko oai toka. Nitoa kayo oma yakome okome no namolo takoa opianago kakuluka no moa patukademe toko. No wete opiameneyake one wete mea kama nekene ago tokome no moa patukademe toko. One naniko taatekoa nokagomeke no moa patukademe toko wane okounakagopa einago eni wa Yoneyo kayo oma yakeneya. ");
INSERT INTO wiu_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Akolaline Agaleyo etenane peku toto peya lawetekilepa pewe wima nokome toka. ");
INSERT INTO wiu_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ali atoame papete litia toatekoi totono Moseseyo i i wa yametaneya. Nitaneyake Yesu Keraisu etenane peku nootokoa taatekoa nokomepa ali atoa toto pewe-kama wia niminimo-kama oa tokome wenele litia toateko totono yameteka. ");
INSERT INTO wiu_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Padameka Akolaline lene timini enameneyake Akolaline mana odene ago one yono kounoke kakago nokome etenanemo i i wa to̱awea oka. ");
INSERT INTO wiu_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yerusaleme tobou Yu yename eya ali-kiti Akolalike lodo yotokoai tane ali-kitika Lipai yatene ali-kitika takoa moa Yone kakata poe wa wetekaneya. Nipa ne ali te-pe wa pitia yakoatino poe wa moa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Nitikoli pitia yakanokoli Yoneyo agale kauameneya to̱atapea okome okome nopa Keraisu mena-kale ekete ");
INSERT INTO wiu_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","nipa nepa ali te-pe. Nepa Ilaida-pe-koli okome e̱'e mena wa okale ekete nipa nepa Akolaline agale to̱awea akamotoa totome nepia meko ago-pe wa okoli okome e̱'e mena wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Nimo okale e yename ekete toto moa wetekakoi-kiti kakita pekete oateko toa oa mano. Nepa te-pe. Ne edane ago wa yakoai tokoli okome ");
INSERT INTO wiu_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Akolaline agale papete to̱awea akane ago Aisaiayo eya wa oa piane toane taatekoane nuku. Ali piamene ta ludu panagome eya wa mo wima yawoo. Ali Muno noateko ka nodokakapia one yawateko ka-kitika ki̱yotokakapia toatino toe wa taatekoa nokome oo wa Aisaiayo papete oa piane toane taatekoane tuku wa Yoneyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","One eni pitia yakanane yenepa Parisi ali-kitame moa wetekane yene. ");
INSERT INTO wiu_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Eni yename Yone eya waka pitia yakaneya. Nipa nepa Keraisu mena Ilaida mena Akolaline agale to̱awea akatekago mena wa ekeke ali atoa ue motokakono, edekolo toko-pe-koli okome ");
INSERT INTO wiu_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","noanume kiwi pa ue motokakuno, kiwi pakeke panago taatekoa nome kakoyake kime agopa motiki. ");
INSERT INTO wiu_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Nopa namolo takoa opianeyake moa patukatekagoke uku. One auapeane one kawa yene kekatukuyake pa keku ago tekene kekamele toamoko wa Yoneyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Enilepa Yodane ue eko matanuke Besani take Yoneyo ali atoa ue motokoai tane take taneya. ");
INSERT INTO wiu_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Podolikama Yone eida kakome enekale Yesu noademe nokale enekome okome Akolaline sipi sipi kai tinepa ita noademe ku nokono, enoe. Ali atoame toma yakoi poanele kogoa mitapeatekago enina. ");
INSERT INTO wiu_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","No namolo takoa opianago kakuluka one wete mea kama nekene ago tokome no moa patukademe toko wane okounakagopa einago eni. One naniko taatekoa nokagomeke no moa patukademe toko. ");
INSERT INTO wiu_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Noanumepa one agopa motokou. Nitikouyake Iserele yename one nokale enekete einago i nekedeko wa wene tomotoane tekene ali atoa ue motokama nuku wa Yoneyo oka. ");
INSERT INTO wiu_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Nitoa Yesuke okome okome Yodane uele kakene enekolu Epetane Yomini ini weuwe keneya a tibu mea ketipea nome oneke awinome mekale enekou. ");
INSERT INTO wiu_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Einago papete agopa motokounake Akolaliyo ali atoa ue motokapamene wa no takoa moa wetekakagome no wene takapikome okome Epetane Yomini panagoke awinome mekale enade toko. Epetane Yomini ali atoake awinomotoa einagome too wa Akolaliyo nopala oka. ");
INSERT INTO wiu_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Akolaliyo eina okanakale taatekoa tokale enekouya tekene einagopa Akolaline mana tadeko wane to̱aweane ukuna-ye wa Yoneyo oka. ");
INSERT INTO wiu_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Podolikama Yone one oyali takuta-pala opia kakome enekale Yesu ponokale enekome okome ");
INSERT INTO wiu_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Akolaline Sipi Sipi Kai Tine ku ponokona wa okale ");
INSERT INTO wiu_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","yatekete one oyagota Yone tewitikoa pote Yesu litima pokoi. ");
INSERT INTO wiu_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Nitikoli Yesuyo ete peketapekome enekale einagota one litima nokoli enekome okome edeya tuku toma niki-pe-kale ekete Labai nepa manika mekato-pe wa yatekoi. (Labai wapa Tikisa ago wa ekete akeneya.) ");
INSERT INTO wiu_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Einagotame nimo okoli okome nipa enenoe-kale one meka yapu pote enepaneya. Nipa lou wegoukaka (4 kilokoke) tadiya tokale eida mea pitaneya. ");
INSERT INTO wiu_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Yoneyo okale yakamotekete Yesu litima pokoi agota pade Saimone Pitane wamenago Aderu. ");
INSERT INTO wiu_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Einagome wamene Saimone tuku toa enamutukome okome Mesaia wa papete ibini oa piane agopa wete enekoo wa opoka. (Mesaia Geriki agaleke eketepa Keraisu wa oi.) ");
INSERT INTO wiu_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Aderuyo Saimone Yesuke aua nokale Yesuyo enekome okome nepa Yonene mana Saimone. Opii titimoa nepa Sipasi wa ibini ato wa Yesuyo oka. (Sipasi Geriki agaleke eketepa Pita wa oi. Nipa kakene kue wa ekete oi.) ");
INSERT INTO wiu_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Podolikama Yesu Galili take pouno wene pia poademe pokome Pilipi kotukome okome no pukuka patono no wa enemoma poka. ");
INSERT INTO wiu_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilipi onepa wamena Aderu Pitata-pala Besaida take odene-mene meane ago. ");
INSERT INTO wiu_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Einago Pilipiyo eyago Nataniele enemotokome okome Moseseyo one totono wia mekakomeka Akolaline agale papete to̱awea akane ali-kitame kini boku-mene wia mekaketeka Mesaia taatekoa noatekamo dekoa wia mekaneya. I wa papete wia mekapiane ago totome enekoo. Einagopa Nasarese Yesu Yosepene mana tadeko wa Pilipiyo okale ");
INSERT INTO wiu_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanieleyo okome Nasarese take padele epetanele edoa witamotoa-pe wa okale okome nipa einago enoano noo wa Pilipiyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Nimo okale yakamotokome noademe nokale Yesuyo enekome Natanieleke okome etene Iserele ago ku nokona. Pademoka oa yotokamene ago eni wa oka. ");
INSERT INTO wiu_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nitikale Natanieleyo Yesu yatekome okome neme nopa edoa wene toko-pe-kale okome Pilipiyo ne no wa pade wete wamokake neke take yomo piki todoke mekale no ita mekene enekou wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nitikale okome Tikisa ago nepa Akolaline mana toto Iserele yene lukoa meateko ago toko-la wa okale okome ");
INSERT INTO wiu_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","nepa neke take yomo piki todoke mekale ita mekene enekou wane okounake nooke wene tugako-pe. Ina okounapa pa nami wane okouna. Nanikodopa padele telekole i moa patukatekole-kiti enade toko wa ootokoa okome ");
INSERT INTO wiu_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","kipala nimini ukuno yakoe. A tibu peaneya pikaya keneke edelo ali-kiti no Ali Yatenane Oyago mekouta keti nekete ate pekete toa kakoile enoi wa Yesuyo oa pika. ");
INSERT INTO wiu_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ta takupeta patatekaneyake Galili ta keneke piko Kena take panagono atoa motokakoita Yesuno nineka eida pome mepaneya. ");
INSERT INTO wiu_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Einata einapetepa Yesu neke oya-lawe-pala namene wa agale oa wetekakoli oneka noka. ");
INSERT INTO wiu_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Nome mekaka e yename gerepi po ku̱ ue napetapeneyake niname Yesu-pala okome kini noatiki gerepi po ku̱ ue piamoko-kale okome ");
INSERT INTO wiu_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","anu oyatoa anukule toateku-petepa opi menano, anu toatekule neme witakoa akamea wa okale ");
INSERT INTO wiu_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","niname yapu pupu takane yene-pala okome okome oneme toe wa okole-kama tamene wa oka. ");
INSERT INTO wiu_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Yu yene kini tanele teketepa aline wene moa koigakoya i koguna wa adeka pikete nee eya noadete mekete yono abe kogakiya. Nitimotoapa yapu yename kamo itonome toa latiane mete uoya ko melepu (6) kakoa moa pianeya. Tone derame meteke panagome-kiti ue nomoa eni mete odeneke pekoai tokomepa ko melepu (6) kakoa-peta nomoa pekakalepa nipa adoo. ");
INSERT INTO wiu_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesuyo yapu pupu yene-pala okome okome ue nomoa i mete-kiti wete kapetekoe-kale ue nomoa pekoai toa kapetekaneya. ");
INSERT INTO wiu_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Nitikoli okome eni mete keneke meko ue pade nomoa moa toge kimotoa yopikago mekota aua poe-kale ue nomoa moa aua potokakoi. ");
INSERT INTO wiu_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Nitikoli yopikagome moa yuumoa nakome okome ekee ipa epetane gerepi po ku̱ ue tadeko wa nakomeke nomotokoika wene toamoka. Wene toamokaleka eina ue nomotokoi yename wene tokoi. Nitaneyake toge yopikagome atoa motokago ne noo wa okale nokale okome ");
INSERT INTO wiu_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","tone toge kikoa mekete-kama gerepi po ku̱ ue epetane mati namolo takoa moa laweteko. Nitikolo ali atoa noa tagoa kitipu mekoli pa gerepi po ku̱ ue moa laweteko. Neme pade nitamoko. Nipa neke gerepi po ku̱ ue epetane mati pa pikoa mea opii moa laweteko wa toge yopikagome oka. ");
INSERT INTO wiu_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yesuyo enile tokapa ele kule telekole pene toademe enileme titika. Nipa Galili pikoka Kena take toka. One eni toka telekole eni eneketepa one tuku (12) kakoa oya-lawe oneke wene tugakoi. ");
INSERT INTO wiu_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Nititikaneyake Yesu Kena ta tewitikoa pokome one nine wamene-mikiti one oya-lawe-pala Kapaneame take pa tekei pome mepoka. ");
INSERT INTO wiu_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Edelo ago patukane wa ibini akene toge kiatekoi tigotokale Yesu Yerusaleme take ate pome mepoka. ");
INSERT INTO wiu_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Nitoapa tobou losu yapu pokome enekale pade-kitame pitimekawe kai sipi sipi kai ini puluma eya topo toa mea pade-kitame kini kue piane leyo waneke kue topo toa mea tokoli eneka. ");
INSERT INTO wiu_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Enetekoa po wapi moa eina ali-kiti kini sipi sipi kai pitimekawe kai-pala akolono wia tikatapeka. Nitoapa kue topo toa kakene yene kini kue piane leyo-kiti moa pekatapea kini kueka wia tadekatapea toka. ");
INSERT INTO wiu_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Nitoapa ini puluma topo tane yene kikoa okome okome Agetaine yapupa kini makesi yapu tetepo takameo. Wini ini puluma-pala wete aua poe wa wia tikatapeka. ");
INSERT INTO wiu_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Nitikale eneketepa Akolali neke yapu mama moane talo tukuleke tete moane tuadene meku wa papete wia mekapiane toa eni taatekoa tadeko wa one oya-laweme wene tokoi. ");
INSERT INTO wiu_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Yesuyo enile tokale enekete e Yu yename ekete neme wini tokolepa Akolali patu kautakoa kake tadekalepa padele telekole toano ta-koli okome ");
INSERT INTO wiu_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","i tobou losu yapu ke̱awea tadekatapekolipa ta tebolo-peta lia patakale eni-mene moane awitikakoane wa wiou-kale ekete ");
INSERT INTO wiu_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","i tobou losu yapupa wia mekoli ege odepeta kadukoa (46) mali penaneyake nemepa ta tebolo-peta lia patakale oyake moa awitikakoa wa wioo-pe wa okoi. ");
INSERT INTO wiu_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Yesuyo eni okapa pinali one tigini-pala toatekoileke okome oka. ");
INSERT INTO wiu_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Yesu tuaneyake Akolaliyo moa kamotokakalepa one oya-lawemepa einapa enike akedeko wa wene tokoi. Nitiketepa eina papete wia mekapiane agaleka Yesuyo eina okana agaleka etene taatekaneya tadeko wa wene tokoi. ");
INSERT INTO wiu_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Edelo ago patukane wa ibini akene toge kia mekoi-pete Yesu Yerusaleme take nome mekome padele padele telekole tokale enekete ali atoa kainya mati oneke wene tugakoi. ");
INSERT INTO wiu_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Nitikolika ali atoa peyane tepene piane wene tetoa enekome tokome e yene-pala oya patu piamoka. ");
INSERT INTO wiu_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Nipa kini tepene piane wene tetoa enekago tokome i ago-kiti one tepene ede wene piko-pe wa ete-kiti pitia yatekileka toamoka. ");
INSERT INTO wiu_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Parisi ago pade Nikodimasi wa ibini akene agopa Kanosolo ago meaneya. ");
INSERT INTO wiu_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ta lianeya keneke einago Yesu mekata nokome okome Tikisago Akolaliyodo auapeamokalepa padele padele telekole neme tokolepa padameka oyake toamoino, nepa Akolali mekota kawa noke olaukakago tadeko-kale okome ");
INSERT INTO wiu_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","nimini ukuno yakamene. Panago wa lokoa opiamene agopa Akolaliyo talo toko ta oyake enepamoo-kale Nikodimasiyo okome ");
INSERT INTO wiu_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","ali wetini tane agopa niname edoa wa lokoa opimotoa-pe. Niname wa opimotoa tokome wetini ago one ninane tepene oyake pamele toko wa eke oko-pe-kale Yesuyo okome ");
INSERT INTO wiu_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","etene nimini ukuno yakamene. Panagome ue moamoa Akolaline Yomini awiameneya pa mekomepa nipa Akolaliyo talo toko take pamele toamoko. ");
INSERT INTO wiu_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ali atoame mati opikilepa pa kini kotu pia-kama tiki. Epetane Yominiyo Akolaline mati-kiti opikakilepa one kotu pia-kama toko. ");
INSERT INTO wiu_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ne wa lokoa opimotoane uku wane ukunake wene kainya piameamene. ");
INSERT INTO wiu_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Pupulege popokakomepa one weneme-kama titia popokako. Nitoa popokakome ee okamo yateketeke titia nokota enamoa pokota enamoa tiki. Enipa Epetane Yominiyo Akolaline mati opikakome toko adeka eni pikene uku wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nimo okale Nikodimasiyo okome neme wini okopa edoa tomotoa oko-pe-kale okome ");
INSERT INTO wiu_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","neka Iserele yenane totono olaukoa tokagomeke i ukumo wene toamoko-pe. ");
INSERT INTO wiu_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Etene nimini ukuno yakamene. Enipa tone wene tokomo oa mea tone leneme enekoya to̱awea oa tokoyake ali atoa kime yakoa moamiki. ");
INSERT INTO wiu_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Itonole tikile-kitike oane metekumopa kime yakoa moamikino, a tibuke tikile-kitike oane metekoumopa edoa yakoa moadete-pe. ");
INSERT INTO wiu_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Padameka a tibu enepikile toameneya. No Ali Yatenane Oyago a tibu kawane ketipeane nuku agome odene aida mekene enekoumo to̱aweane uku. ");
INSERT INTO wiu_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Moseseyo ali piamene take kaya yomini latia yomo ludu munoke dekoa moa kakaneya. Moseseyo eni tane toa pade ali-kitame no Ali Yatenane Oyago dikoa yomo luduke dekoa kamotokoi. ");
INSERT INTO wiu_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Nipa nooke wene tugoa mekoi peya pa mea-kala kama pomotoa nitoi. ");
INSERT INTO wiu_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Akolaliyopa ta piko peyake pitiki-kiti one kolotini yene wa wene mekoa mekome tokome one mana odene agopa ali atoake tumotoa moa wetekaneya. Nipa manake wene tugoa mekoi-kiti tuapa atuameneya mea-kala kama pomotoa tokome taneya. ");
INSERT INTO wiu_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Moa wetekakomepa kini tanele poanele tadikino, poane take poe wa koiso akamotoa wetekaneya mena. Toa momotoa tokome ni moa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Manake wene tugoa meki-kiti koiso akoa kibu moamatekoyake manake wene tugamiki yenepa poane take wetekou wa koiso wete akoa pianeya. Nipa one mana odene agono ibinike wene tugamadete wakili tokome toko. ");
INSERT INTO wiu_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Nipa pa̱ pinago kiwi mekoika nekeneyake poanele pa toma pou wa wene pianeya mekete eni pa̱ wawa yomiyomuke wene mekoa mekino, kiwi kibu moatekulepa eni wa kini koiso wete akoa pianeya. ");
INSERT INTO wiu_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Poanele toma yaki-kitame eni pa̱pa kote moa waki. Nitoapa kini poanele keleyo witakaya tokolo pa̱ keneke witoa noamokala tiki. ");
INSERT INTO wiu_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Nitikiyake nimini peku noa tiki yenepa eni pa̱ keneke witoa nokala tiki. Nipa kini tikilepa Akolali patu kautakoa kakete tadiki wa ete-kitame wene tomotoa tiki wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Nititikaneyake Yesupa Yudea take pato wa one oya-lawe-pala opia pome eida tayo lono mea kakome ali atoa ue motokakala toka. ");
INSERT INTO wiu_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Nitikakoa Yonepa Salime ta liti piane Inone take mekome ali atoa ue motokakala taneya. Nipa eni ta ludu ue kainya yotokale tokome taneya. Eidapa ali atoa nekete kiwi ue motokoano ta-koli ue motokakala taneya. ");
INSERT INTO wiu_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Enilepa Yone po yapu wete moa pitikameneyake taneya. ");
INSERT INTO wiu_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Yu yename kini losule tekete abe koganelekepa Yoneyo okagale yakane ali padeka-kitame pade Yu ago-pala ete taka oto taka toa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Nitoapa Yone kakata nekete ekete Tikisa ago nepala Yodane ue eka lono opia kakanakago neme onekemo akakagome ali atoa ue motokakala toko. Nitikolo peyame ne tewitikoa one kakota-kama pokala tiki-koli okome ");
INSERT INTO wiu_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","panagome Akolalinele takakilepa a tibuke meko Akolaliyo one peku lawetekolo nakomepa oyake toko. Pa one weneme tokoya mena. ");
INSERT INTO wiu_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nopa Keraisu wa papete ibini oa piane ago taatekoane noamuku. One naniko nomotoa Akolaliyo no namolo takoa wetekakolo nuku wane kipala okouna. Enipa nimini ukutu-pe. ");
INSERT INTO wiu_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Atoa tu pikagopa atoa moatekago eni. Einatoa motokolopa one oya patu piane agome one kakoya liti kakome one okagale yatekome wedia kako. Opa no einago keneya wediane kolotini to̱ane kaku. ");
INSERT INTO wiu_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ali atoame anu oyago Yesuno ibini kamotoka kamotoka tekete anu ibini etepea wene kayapema pamediki wa Yoneyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Yoneyo nimo ootokoa kakome okome a tibu kawa noko agome ete yene peya moa patukoapa etene ako ago kako. Itonoke alane agopa pa itono peku noa tokome one kaua-mikitame olaukama nekenemo oa mekala toko. A tibu kawa nokagomepa ete yene peya moa patukoa etene ako ago kako. ");
INSERT INTO wiu_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","A tibuke mekome yakoa enoa tokaya-kiti i i wa to̱awea onaneyake padameka yakoa moamiki. ");
INSERT INTO wiu_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Nitikiyake one to̱awea okomo yakoa motiki-kitame yatekete ekete Akolalipa niminimo-kama oko ago tadeko wa iki. ");
INSERT INTO wiu_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Nipa Akolaliyo moa wetekakale nokagome Akolaline agale-kama akakolo yatekete ni iki. Akolaliyo one Epetane Yomini einagoke awia tagatapemotoa metekome metaneya. ");
INSERT INTO wiu_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Nitoapa einago one mana agoke wene mekoa mea tokome padeya padeya peya one yonoke moa pianeya. ");
INSERT INTO wiu_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","One manake wene tugoa meki-kiti pa mea kama poadete tiki. One mana kote moa waki-kitame mea kama poatiki ta enamekete pa etepea tua poadete tiki. Nitiki yene-pala Akolaliyo kotimi yoa meko. ");
INSERT INTO wiu_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","2","Ali atoa ue motokakilepa Yesuno oya-laweme tokoiyake Yesuyo pade nitamoka. Yesuyo nitamokoyake pade-kitame ekete Yesuyo ali atoa ue motokakilepa Yone moa patukoa toko wa okoi. Kini eni okoimo kugu Parisi ali-kitame yakadekoli ");
INSERT INTO wiu_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Yesuyo one oya-lawe-pala Yudea ta tewitikoa Galili take wakapea poademe poka. ");
INSERT INTO wiu_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Galili take eni poademe Sameria ta patukoa pamedeka. ");
INSERT INTO wiu_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Nitoa pokome Sameria ta keneke piko Saika take pome kaka. Namolo namolo Saika ta liti Yekobeyo one itono pade oto pia mana Yosepe yametaneya. ");
INSERT INTO wiu_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Eni yametane taapa Yekobeyo oloyo pade eida moa ue mekaneya. Nitaneta Yesu ka ludu noka matiyame koome tukome eina oloyo kabunuke ko mepoka. Nipa lou matai ponome kakaka (lou pini 12 kilokoke) tadiya eida pome ko mepoka. ");
INSERT INTO wiu_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Eida mekakoa one oya-laweme nee topo toa moadetepa ali atoa pitikoika kutu pokoi. Nitikolipa Sameria atoa padame ue nomoademe nokale Yesuyo okome ue nouno, mano wa okale okome ");
INSERT INTO wiu_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","nepa Yu agomeke no Sameria atoa ue nouno, mano wa wini okono, dekolo oko-pe wa akeneya. Nipa Yu yene Sameria yenetapa etene pilia kakeneya tokome ni akeneya. ");
INSERT INTO wiu_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Nitikale Yesuyo okome Akolaliyo ne moa meatekoya wene toamoa ni ue nouno, nomoa mano wa okago wene toamoa toko. Eni wene too tokapa nipa noateku ue pade nouno, nomoa mano wa neme noanu-palaka oo toka. Nimo oo tokapa lene to̱a yoa-kala kawateko ue meou toka-kale okome ");
INSERT INTO wiu_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","kamo koniyali i oloyopa keti kokaketikaneya mati pikono, ita ue nomoateko mete pade ne toamokono, yoa-kala kawateko uepa neme edoa nomoa no meteko patu. ");
INSERT INTO wiu_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","I oloyopa tone kauago Yekobeyo papete moa pikaneya. Nitaneyake onemeka one mana-mikitameka one egetaneya-kitameka i oloyoke-kama ue nonokala taneya. Yekobeyo enile taneyake neme pade ue meou wa wini okopa tone kauago Yekobeyo tane toa moa patukake oko-pe-kale Yesuyo okome ");
INSERT INTO wiu_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","i oloyo moa mekane uepa padame nomoa nakomepa wa nodo tokala too. Nitatekoyake noanume meateku ue nakomepa wa ue nodo toamoo. ");
INSERT INTO wiu_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Noanume meateku uepa ali atoane tepene ue lene peleou toa yoa-kala kawoo. Nipa kiwi mea kama pomotoa too wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Nimo okale einatoame okome kamo koniyali wini oko uepa no nouno, mea ta. Eni ue nakolupa wa nodo toamokale mekene i ue nomoai toamou-kale okome ");
INSERT INTO wiu_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","nekane oto noo wa kayo oano pa. One-pala oto neke namene-kale okome ");
INSERT INTO wiu_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","anukane pade kawamoko-kale okome winipa nimini oko. ");
INSERT INTO wiu_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Neke ali ko kakoake pokala toka. Opi poke mekagopa nekane mena. Enipa nimini oko-kale okome ");
INSERT INTO wiu_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","kamo koniyali winimopa nimini okono, nepa Akolaline agale to̱awea akakago tadekono, eya wane ne yatekene uku. ");
INSERT INTO wiu_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Tone kaua-mikitame yete tono waneke-kama Akolali kei pia kowitoai toma nekeneya. Nitaneyake Yu yene kime ekete toto peyame Akolali kei pia kowitikilepa Yerusaleme take-kama tamedeko wapa iki-kale okome ");
INSERT INTO wiu_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","anu oyatoa nepala ukumo yakoa moamene. Naniko Agetai kei pia kowitikilepa yete tonokeka Yerusaleme takeka kowitamekete kini kini mekika tokala toi. ");
INSERT INTO wiu_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Sameria yene kipa kini kei pia kowitikiyapa agopa tokolo pa etepea kowitoa meki. Akolaliyo ali atoa toa motikilepa toto Yu yene pake titia toko. Nitikono, toto Yu yenepa tone kei pia kowitikoyapa i wa wene toko. ");
INSERT INTO wiu_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Nitikoyake eya toatiki etene tigotoma noko. Agetai kei pia kowitikete toatiki toa kowitiki yenepa Akolali weneke luaneya mekete nimini peku noa tekete tepene kowitikala toadete tiki. Akolaliyo dikaki-kitame one kei pia kowitimotoa okono, nitadete tiki. ");
INSERT INTO wiu_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Akolali onepa yomini-kama toko. Onepa nitane agono, one kei pia kowitiki yenepa Akolali weneke luaneya mekete nimini peku noa tekete tepene kowitikala tamediki wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Nitikale einatoame okome eyago Mesaia noademe tokono wene tuku. Einago nokomepa Akolalinemo-kama toto-pala to̱awea akoo-kale okome ");
INSERT INTO wiu_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","neta kakome ko oa kakagopa einago eni wa Yesuyo akeneya. Einatoame Mesaia wapa Keraisuke okome akeneya. ");
INSERT INTO wiu_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Einata einapete one oya-lawe wakapea nekete enekoli Yesuyo mone atoa-pala ko oa kakedeka. Nitadekale wene kainya mati pianeya kaketeke edeya moade oko-pe. I atoa-pala dekolo ko oko-pe wa Yesu yakamokoi. ");
INSERT INTO wiu_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Nitaneyake einatoame one ue mete eida piilogoa one yene pitikoika wakapea poka. Pome kakome one yene-pala okome ");
INSERT INTO wiu_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","noanume toma nokoule-kama to̱awea okagopa ku mekome toko. Einagopa Keraisu wa papete ibini oa piane ago patuno, enoatino noe wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Nitikale yakamotekete Yesuke noadete nekeneya. ");
INSERT INTO wiu_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Noadete nokoika Yesuno oya-laweme one tika tika toa kakete ekete Tikisa ago neke nee pade moa na-koli okome ");
INSERT INTO wiu_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","no noateku neepa pade pikoyake kime pade wene toamiki-kale ");
INSERT INTO wiu_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","one oya-lawe yakaate tekete ekete padame one nee pade wete moa lawetaneya patu-koli okome ");
INSERT INTO wiu_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","no moa wetekakago one wene pikole toane oneme tamene wa okole-kama toane peya takakupa anu noateku nee eni. ");
INSERT INTO wiu_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Kime eya wa pedoa agale ikina. Tokene tuyono patukakalepa ipe ludu kakoya nee wakoa moa yapu ludu piato wa ikino, noanume ukumodo yakoe. Ipe kakoya-kitipa wakoa moateko toa opii nodokoa kibutua kakono, enoe. ");
INSERT INTO wiu_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Wakoa motokako agomepa nipa mea kama poatikiya eni wakoa moma poko. Wakoa motokama pokoka pinagome ke wa nami wia pupu poi motoko. Nipa matakago-pala wakoa motokakagota wedikete wedia meki. ");
INSERT INTO wiu_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Kini pedoa agale ikina toapa panagome ipe matama pekeneka padame wakoa motokama poko. ");
INSERT INTO wiu_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nipa poliga yoameneya ipe matama poamenekeka eniya wakoa motokama poati wane kiwi wetekakouna. Ete-kitame poliga yoa ipe eida matama pekeneka eni yene luku pekete eni yenaneya wakoa motokama piki wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Einatoa pitika take yenepa Yesuke wete noameneyake kainya mati oneke wene tuganeya. Nipa noanume toma nokoule-kama kuyagome to̱awea oka wa einatoame okale yatekete tekete Yesuke wene tuganeya. ");
INSERT INTO wiu_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Nitimotekete Yesu mekata nekete kowitikete ekete toto pitiko take noke meano, noo-koli pokomepa ta taku-peta patamotoa eida mea kaka. ");
INSERT INTO wiu_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Nitoa mekome okale yatekete eni yene padeka-kitika oneke wene tugakoi. ");
INSERT INTO wiu_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Nitikete einatoa-pala ekete namolopa nemena i agome tokale kotukoa onokanakedo oneke wene tugakoo. Opipa i ago toto pake kakome agale oa metekolo yatekete tekete oneke wene wedoa tugako. I agopa ali atoa toa moatekago tadeko wa okoi. ");
INSERT INTO wiu_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ta taku-peta patatekaneyake Yesuyo eni ta tewitikoa Galili take pome mepoka. ");
INSERT INTO wiu_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yesu eni pokapa eya wa okanake poka. Akolaline agale to̱awea akakagopa one take yename paya tetepo takoa wakiya wa okana. ");
INSERT INTO wiu_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Galili nome mekale eina yename one makutukoa motokoi. Nipa edelo ago patukane wa ibini akene toge kia mekoi-pete Yesu Yerusaleme take pome mekome telekole tokanakale-kama enekoiya tokome ke wa makutukoa motokoi. Nipa kiwika eina toge lobutupekete one telekole tokoinakale enekoiya tekete one makutukoa motokoi. ");
INSERT INTO wiu_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yesu Galili ta ludu pima yakome Kena take pome mepoka. Nipa pa ue moa gerepi po ku̱ ue latikana take wa pome mepoka. Nitikata ta talo tokagoke lukoa meane tobou ago pade one mana Kapaneame take yene pimotoa wawa Yesu kotua noka. ");
INSERT INTO wiu_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Nipa Yesu Yudea ta kawa Galili take nome kako wa okoimo yatekoya tokome noka. Yesu kakata eni nokomepa one mana pene tuademe pikono, Kapaneame take poke epetekakoano poa ta wa kowitikakale okome ");
INSERT INTO wiu_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Agetaine peku noane tukule padele telekole toane kini wene kainya pikakule enameketepa nipa nooke wene tugakile toamoi-kale ");
INSERT INTO wiu_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","tobou agome okome kamo koniyali oto lukakoa tukayano, wete pata wa kowitikale okome ");
INSERT INTO wiu_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","neke mana tuamoono, poano pa wa okale einagome Yesuyo nimini oko wa wene tokome one take wakapea poka. ");
INSERT INTO wiu_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Poademe pokale one pupu yene kotua nekete ekete neke manapa tuameneya pene latoa meko wa onaneya. ");
INSERT INTO wiu_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Nitikoli manipete lataka-pe wa okale ekete abela lou matai tetekakale (lou pini 1 kilokoke) one poto yene te̱itaka-koli ");
INSERT INTO wiu_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","etename wene moa pitikakome abelana Yesuyo neke mati tuamoo wa okale eina eina latakome tadeko wa wene taneya. Nitaneyake einago one yapu pitikoi peya-pala Yesuke wene tuganeya. ");
INSERT INTO wiu_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yesuyo ele kule telekole tikilepa Yudea ta tewitikoa Galili take pome mekome telekole taku takoa eida tokome enile toka. ");
INSERT INTO wiu_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Nititikaneyake Yu yene kini losule tekete toge kia mekoi-pete Yesu Yerusaleme ate wakapea poka. ");
INSERT INTO wiu_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Yerusaleme take sipi sipi kai wa ibini akene kago pikane lono ue mine pade meaneya. Eni ue mine matanuke ali atoa todo takatekoya ko kakoa wianeya kakeneya. Eni ue minepa Iberu agaleke Beteseda wa ibini iki. ");
INSERT INTO wiu_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Eni todo takatekoya keneke eya ali atoa leneta lianeya kawa okeaneya tau tootokaneya piane ali atoa oboai taneya. Nipa ue bua bua wa ka̱umotoa nepia meai taneya. ");
INSERT INTO wiu_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Padepete-kiti Akolaline edelo ago ue muke ketipea nokale ue bua bua okala toka. Nitikalepa uele namolo takoa pome pitikagopa one tanele epetekakale latoa pekeneya. ");
INSERT INTO wiu_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Nitanetapa panago tau tootokaneya pia mekale mali padeka tuku kakoa (38) penaneya. ");
INSERT INTO wiu_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Einago pikata Yesu nokome enekale eida tau tootokaneya pia kakeneyano wene tokome yatekome okome nepa latoa poade oko-pe-kale okome ");
INSERT INTO wiu_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","kamo koniyali nopa eni ue bua bua okoka auapea aua poatekago toamokolo pa piane meku. Eni ue muke ketipeane poadene wili toane mekulu panago namolo takoa patukakala toko-kale okome ");
INSERT INTO wiu_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","wete kamokoa neke tatia pitikoya-pala moa aua pa wa okale ");
INSERT INTO wiu_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","eina eina latoa kamokakome one tatia pitikaya-pala moa aua poka. Yu yene kini ko mea pupu toamatekoi-petepa enile toka. ");
INSERT INTO wiu_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Nitikale e Yu yename eina latoa poka ago-pala ekete opi Yu yene tone ko mea pupu toamateko-pete kekaneya latikakole toa neke tatia pitikoya-pala aua ponokopa tone kekanele wini toko-koli okome ");
INSERT INTO wiu_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","no epetekoa wetekakagome neke tatia pitikoya-pala moa aua pa wa okolo tuku-kale ekete ");
INSERT INTO wiu_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","eni neke tatia pitikoya-pala aua pa wa okagopa te-pe wa yakaneya. ");
INSERT INTO wiu_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Nitikolipa eina latane agome one epetekakanakago agopa motaneya. Nipa ali atoa kabeta pake Yesu wete witimotokome pokale tokome ni agopa motaneya. ");
INSERT INTO wiu_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Naniko Yesuyo einago tobou losu yapu kakale kotukome okome anu oyali nepa opi latoa kakono, neke namolona tane yene moa patukoa naniko wa ke tubeya enekakayano, neke toma poka poanele-kiti wake wamene wa okale ");
INSERT INTO wiu_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","yakamotokome eina Yu yene mekoita pokomepa one latekakagopa Yesu tadeko wa opaneya. ");
INSERT INTO wiu_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Yesuyo enika enile tikilepa Yu yene kini ko mea pupu toamatekoi-peteka tokale tokome enipete titimoa one tete meai tokoi. ");
INSERT INTO wiu_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Nitikolipa Yesuyo okome Agetaiyopa i pupu-kama toko. Noka one peku noane pupu-kama tuku wa oka. ");
INSERT INTO wiu_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Nimo okamoke Yu yename Yesu wia tukadete wedoa wili toa kakeneya. Nipa kini ko mea pupu toamateko-pete kekaneya latikakole pupu eni tokono, Akolalipa oneketai waka oa tokono, onepa Akolali-pala midi piane tetepo takakome oko wa ni wioukete taneya. ");
INSERT INTO wiu_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Nitaneyake Yesuyo okome nimini ukuno yakoe. Padeleka noanu weneme titiane toamuku. Agetaiyo tokole enoane kotukoane tuku. Nipa Agetaiyo peku lawetekolo one mana noanume noane tuku. ");
INSERT INTO wiu_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Agetaiyo nopa one kolotini ago one mana wa nooke wene mekoa mea tokome one peku lawetoa tagako. Agetaiyo eni yametekana toa moa patukakome padele padele telekole toatekoule yameoo. Nipa kini wene kainya pianeya memotoa tokome nitoo. ");
INSERT INTO wiu_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Agetaiyo tua pekene ali atoa mea kama poati wa moa kamotokako toane one mana noanumeka ali atoa anu weneme takoane motekene mea kama pomotoane tuku. ");
INSERT INTO wiu_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Agetaiyo ali atoa kini toma yakoile pitia enoapa poane takeka epetane takeka takoa wetekakoya mena. Nitameneya kini toma yakoile neme pitia enoapa poane takeka epetane takeka takoa wetekakamene wa Agetaiyo no moa kakapika. ");
INSERT INTO wiu_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Nipa ali atoamepa one kei piai tiki toa one mana noka kei piai tomotoa tokome toka. One mana no kei piamiki ali atoamepa Agetai no moa wetekakago kei piamekete tiki. ");
INSERT INTO wiu_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Etene nimini ukuno yakoe. Anu agale yakoa motekete no moa wetekakagoke wene tugoa meki-kitipa mea kama piki. Nipa kini poanele-kala toma yakike nami wiane kibu moamukulupa poane ali atoa tua pote atuatiki ta tewitikoa mea kama piki. ");
INSERT INTO wiu_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Etene nimini ukuno, yakoe. Tua pekene ali atoame Akolaline mana noanu tobotobo yakakoa kawatiki tigotoma nome dekanoko. Enilepa wete taatekoa toko. Nitikono, anu tobotobo yatekoi-kiti kamomotekete mea kama poi. ");
INSERT INTO wiu_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Agetai one weneme mea kama noko agomepa one mana noanuka anu weneme meane kama nomotoa toka. ");
INSERT INTO wiu_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Nipa no nepa Ali Yatenane Oyagono, one patu kautakoa kake ali atoa takoa enamene wa moa kakapika. ");
INSERT INTO wiu_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","I ukulu yatekimoke wene kainya piameamene. Nimini taatekoa toatekomo ukuno, yakamene. Oloyo tane yene peyame Ali Yatenane Oyago anu tobotobo yakamotekete ");
INSERT INTO wiu_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","kiwi oloyo taneka tewitikoa kamoa poi. Nipa epetanele toma yawa tukoi yene kamoapa mea kama poi. Poanele toma yawa tukoi yene kamoa pokolipa kini poanele-kala toma yakoike nami wiane koiso akoane kibu mou. ");
INSERT INTO wiu_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Noanu weneme padeleka titiane toamuku. Nipa ali atoa takoane enekilepa Akolaliyo olaukakome oko toane tuku. Nilepa anu wene litiane toamuku. No moa wetekakagono wene pikole-kama tou wane tuku. Nitikuno, kini koiso yakoane ile tadiki wane ikilepa ki̱yoke-kama tuku. ");
INSERT INTO wiu_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Pinali anu wa keido pikenepa nimini ekene wamou. ");
INSERT INTO wiu_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Panagomepa no kei pikoya. Einagome anukumo to̱awea akedekopa nimini akedekono wene tuku. ");
INSERT INTO wiu_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Pitia yakatekoi yene Yone kakata kime moa wetekakoli nokoli Yoneyo anukumo to̱awea akedeko wane uku. ");
INSERT INTO wiu_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Nimo ukuyake padameka no auapea kei piatiki toa mena. Kipa nooke wene tugakoli toane moada wane wene piane tekene Yoneyo anukumo to̱awea akedekomo wene takakene ukuna. ");
INSERT INTO wiu_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yone einagomepa labo keneya ali atoa pa̱ takalogakoya. Nitane tokale kime one pa̱ke wedia meato wa oneke tegetekapote me me tokoina. ");
INSERT INTO wiu_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Yone einagome anukumo to̱awea ikilepa pa nami deya akeneya. Agetaiyo tamene wa no yametekana toane toma yakilepa nipa ali atoame no i agopa Agetaiyo moa wetekakago tadeko wa wene tomotoane tuku. ");
INSERT INTO wiu_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Agetai no moa wetekakagomeka anukumo to̱awea okoya. Kime Agetaine agale yatekileka toamoa one lene timini-pala enekileka toamoa tiki. ");
INSERT INTO wiu_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Agetaiyo moa wetekakago nooke wene tugamekete tekete one agale kime yakoa luamele toamoko. ");
INSERT INTO wiu_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mea kama poatekomo Akolaline bokuke e wia mekaneya pikono, oi moato wa kime one boku lewea tuku tokala tiki. Ae, Akolaline bokuke wia mekane yename no ko-kama akeneyake kime no wene toamiki. ");
INSERT INTO wiu_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Nipa mea kama poono wene piketeke nooke noamadete wakala tiki. ");
INSERT INTO wiu_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Ali atoame no kei piamikilika kei pikilika nitoa kamotoane pa atiki toane meku. ");
INSERT INTO wiu_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Kini tepene piko wene keleyo tetoane enekulu Akolalike wene mekoa meameadiki. ");
INSERT INTO wiu_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Agetai patu kautakoane kakene nukuluka kime no makutukoa moamikino, oneke wene mekoa meameadiki. Ae, panago one wenemedo kiwi mekoita wini nokalepa ke wa makutukoa moi. ");
INSERT INTO wiu_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Akolali wa oko agopa odene ago kako. Einagome kiwi kei piamikilika tokamota wa paya nou toa mekete kini kini ete oto wa kei pinali yokala tiki. Nitikino, nooke edoa wene tugadete-pe. ");
INSERT INTO wiu_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Kini poanele-kala toma yakoilepa Agetai-pala i i wane kiwi akoane wamouno, no i agome kiwi akoane ou wa wene piameamene. Mosese einagopa kiwi mape moatekago wa wene pianeya mekiyake einagome kiwi akoa agale oo. ");
INSERT INTO wiu_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Moseseyo one boku-meneke no ko oa wia mekaneya. One wia mekanemo kime yakoa moi tokapa nipa anume ukumoka yakoa moi tokake ");
INSERT INTO wiu_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Moseseyo nooke wia mekapianemo yakoa moamikino, anume ukumo edoa yakoa moadete-pe wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Nititikaneyake Yesu Galili ue mine eka matanuke ue dipike mea pome mepoka. Eni Galili ue minepa Taibiriase waka ibini akeneya. ");
INSERT INTO wiu_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Yesu eni pokalepa ali atoa peya matiyame one litima nokoi. Nipa one padele padele telekole tokome yene tane-kiti epetekakale enekoiya tekete litima nokoi. ");
INSERT INTO wiu_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Nitaneyake Yesu tono padeke ate lewia pokomepa one tuku kakoa (12) oya-lawe-pala aida witipitoa meka. ");
INSERT INTO wiu_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Edelo ago patukane wa ibini akene toge kiatekoi tigotokale enile toka. ");
INSERT INTO wiu_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesu aida mekome kabe togapia enekale ali atoa obomoa noadete nokoli enekome Pilipi-pala okome i yene lawetateko neepa manika topo toa motokoo-pe wa yateka. ");
INSERT INTO wiu_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Nipa nee moa lawetateka wene tokomeke pa Pilipiyo oatekamo yakademe oka. ");
INSERT INTO wiu_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Nitikale Pilipiyo okome ege kadukaka kadapime kadukoa (200) kinado wetekoa palawe wane-kiti motokakolopa adamoo-kale ");
INSERT INTO wiu_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","yatekome Yesuno oyago pade Aderu Saimone Pitane wamenago einagome okome ");
INSERT INTO wiu_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","i kako matiyamepa bali palawe wane ko kakoa-pala (5) mou yomo takuta toa pikoa kako. Eniya-mene moa lawetekoloka adamoo. I ali atoa kainya mati mekino, tokamato wa oka. ");
INSERT INTO wiu_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Eidapa poma piitapeneya. Ali atoa peya pomale meetapemotono toe wa Yesuyo okale mekatapekoi. Nitaneyake ali-kiti mekoi toa oi moteketepa ege egeta kadukoa (5,000) tadiya meadekoi. ");
INSERT INTO wiu_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yesuyo eina palawe wane-mene e matiyaneke moa Akolali-pala ke wa oa popimotokome poma ludu meetapekoi yene tatikatapeka. Mou yomotaka moa einakale tokale peyame noa tagatapea kitipu mekoi. ");
INSERT INTO wiu_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Peyame noa tagatapea kitipu mekoli enekome Yesuyo one oya-lawe-pala okome padeyaka kateaneya pikayano, nee kugu piko wekotoa moa pikoe-kale ");
INSERT INTO wiu_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","wekotoa mootapekoi. Nipa bali palawe wane namolo ko (5) kakoa moa lawetekoyake kugu wekotoa moa ua ka katika tuku kakoa (12) mako puputua moa pikoi. ");
INSERT INTO wiu_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Yesuyo eni telekole tokale enekete peyame ekete i agopa Akolaline agale to̱awea akademe noateko ago tadeko wa okoi. ");
INSERT INTO wiu_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Nitaneyake kini Ali Muno kakadete one dekoa monoino wene tokome tonoke wa witimotokome kidene poka. ");
INSERT INTO wiu_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ta likaka one oya-lawe ue mineke ketipea pekete ");
INSERT INTO wiu_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ue dipike pogatekoa pote mea Kapaneame take poadete pokoi. Ta wete likaka Yesu noameneyake ");
INSERT INTO wiu_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","pupulege mati nokome ue pewikamoa pitikaka. ");
INSERT INTO wiu_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Nitoa kakaka one oya-lawe ue dipike mea kilomita ko melepu (6) tadiya ponokolipa Yesu ue tali ludu tigotokakoa nokale enekete nenei motokoli okome ");
INSERT INTO wiu_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","no nukuno, piti moameo-kale ekete ");
INSERT INTO wiu_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","nipa ue dipike noke meno-koli nome mekale eina eina ue dipi kini mea poatekoita wete eina witapoka. ");
INSERT INTO wiu_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Podolikama oka matanuke kakoina yename eya wa wene taneya. Ete piapa ue dipi odene ika lono nome pika. Yesupa one oya-lawe-pala eni ue dipike opia mea poameneyano, kini-mene kidene mea pekete tadiki wa wene taneya. ");
INSERT INTO wiu_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Eni wene taneya kakoika ue dipi-kiti Taibiriase ta pia nekeneya. Nipa Ali Munagome palawe moa ke wa lawetekale ali atoame nakoinata liti nekeneya. ");
INSERT INTO wiu_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Nitaneyake Yesu one oya-laweka meameadekoli enekete Yesu tuku topato wa eni ue dipi-kitike pogatekoa pote mea Kapaneame take pekeneya. ");
INSERT INTO wiu_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Eni yename Yesu eka matanuke tuku toa kawa enekete ekete Tikisa ago ika manipete noka-pe-koli okome ");
INSERT INTO wiu_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","etene nimini ukuno yakoe. Kime no tuku toma nikipa, no einagome telekole tokale enekoonakale Akolaline tele patu kautakoa kakome tadeko wa no tuku toma nikiya mena. Pa palawe wane lawetekolu noa tagakoinake ni tuku toma niki. ");
INSERT INTO wiu_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Pa lomuateko nee-kama pupu toa moato wa wene piameamene. Nitamoano, pia kawateko neeka moa nato wa eniya neeke wene piitikaneya meamene. No Ali Yatenane Oyagome lawetateku pekuke uku. Eni pekupa one patu kautakoa kake lawetamene wa Atai Akolaliyo no moa kakapika tokolo ni uku wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Nimo okale ekete kime Akolalinele edoa takako patu-koli okome ");
INSERT INTO wiu_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Akolaliyo moa wetekakale nokou ago nooke wene tugoa meketepa nipa one wene pika toa tekete toi-kale ekete ");
INSERT INTO wiu_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","neke peku pine enoono, padele telekole toa yameano ta. Neeke wene tugamotoapa edele toa yameteko-pe. ");
INSERT INTO wiu_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Tone kaua-mikiti ali piamene ta ludu pima yaketepa maana nee moa noma yakeneya. Nipa Moseseyo a tibu pia nekene nee lawetekale noma yakeneya. Eni tanemopa Akolaline bokuke wia mekaneya piko-koli okome ");
INSERT INTO wiu_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","nimini ukuno yakoe. Eina tibu pia nekene nee lawetane agopa Mosese mena. Tibu nee eteneyapa Agetaiyo lawetekoya. ");
INSERT INTO wiu_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Akolaliyo laweteko neepa a tibu mea ketipea nokome ali atoa mea kama pomotoa tokago eni wa okale ekete ");
INSERT INTO wiu_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","kamo koniyali wini nee-kama lawetekala toano ta-koli okome ");
INSERT INTO wiu_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","ali atoa mea kama pomotoa toko neepa no. Nooke nokagopa kobu tokale mekileka toamoo. Nooke wene tugoa mekagopa ue nodo tokale mekileka toamoo. ");
INSERT INTO wiu_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ae, kime no enekala toake wene tugamiki. Nipa kipala okouna toa tekete no wene tugamiki. ");
INSERT INTO wiu_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Agetaiyo takoa moa nooke wetekaka peya nooke noi. Nitoa nokoli odene agoka wiane litiamou. Ni edoa-mo. ");
INSERT INTO wiu_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","A tibu meane ketipeane nekenepa anu wene litiane tou wane nokouya mena. No moa wetekakagono wene pika toane litiane tou wane ni nokou. ");
INSERT INTO wiu_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","No moa wetekakagome no pa wa wetekakomepa oneme takoa no moa meteka yene odeneka katekameneya peya yopima pone togamotono wene pikome wetekaka. Nipa eni yene peya wipitia ta patakale kamotokamene wa wetekaka. ");
INSERT INTO wiu_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Agetaiyo no pa wa eni wetekakilepa one mana no enekete wene tugakoi peya mea kama pomotoa tokome toka. Wipitia ta pataka-pete eni yene moane kamotokou wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","A tibu pia nekene neepa one wa Yesuyo okale yatekete tekete Yu yename Yesu akoa ko̱ oa kakete ekete ");
INSERT INTO wiu_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","beita, i agopa Yosepene mana Yesu. One nine etenetapa totome wene tokono, one a tibu meane ketipeane nuku wapa edekolo oko patu wa ko̱ oa kakoli okome ");
INSERT INTO wiu_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","kini kini oa meki ko̱-pala ete tewitikoa wawe. ");
INSERT INTO wiu_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Panago nooke tegetekoa nikilepa one weneme tamele toamoko. Agetaiyo nooke oto limo limo tokolopa nipa namele toko. Nitikolopa wipitia ta patakale takoane kamotokou. ");
INSERT INTO wiu_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Akolaline agale to̱awea akane ali-kitame eya wa wia mekapianeya. Ali atoa peya Akolaliyo mane mane oa olaukoo. Eni wia mekapiane toa Akolaliyo olaukane toa yakoa lukoi peya nooke noi wane uku. ");
INSERT INTO wiu_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Enipa panagome Agetaine lene timini enaneya wane ekene wamuku. Akolali-pala kawane nuku ago no odene Agetaine lene timini enoane nuku. ");
INSERT INTO wiu_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Etene nimini ukuno, yakoe. Nooke wene tugoa meki peya mea kama poadete tiki. ");
INSERT INTO wiu_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ali atoa mea kama pomotoa toko neepa no. ");
INSERT INTO wiu_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Kini kaua-mikiti ali piamene ta ludu pima yakete maana nee moa nakeneya. Eni nee moa noake tukala taneya. ");
INSERT INTO wiu_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","A tibu pia nekene neepa dikaneya. Panagome eni nee moa nakomepa nipa tukile toamoo. ");
INSERT INTO wiu_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Pa pia kama poko nee wane ukupa a tibu meane nuku ago nooke uku. Eni nee moa naki peyapa mea kama poadete tiki. Nee na wane meateku neepa anu tigini. Enipa itonoke meki-kiti mea kama pomotoane meadene tuku wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Nimo okale e Yu yename ete taka oto taka toa kakete ekete i agome one tigini toto edoa lawetademe okoto patu wa ko̱ oa kakoli okome ");
INSERT INTO wiu_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","etene nimini ukuno yakoe. Ali Yatenane Oyago noanu tigini kamateta moa noameneya meketepa nipa kini weneme oyake mea kama poamoi. ");
INSERT INTO wiu_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Anu tigini kamateta noai toko agopa mea kama poatekago eni. Dikane ali atoapa wipitia ta patakale takoane kamotokou. ");
INSERT INTO wiu_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Anu tiginipa ali atoame noatiki nee eteneya. Anu kamatepa ali atoame noatiki ue eteneya. ");
INSERT INTO wiu_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Anu tigini kamateta noai tokagopa no-pala lipukoa meko. Noka one-pala lipukoane meku. ");
INSERT INTO wiu_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Mea kama noko ago agetaiyo no moa wetekakolo nekene one patu kautakoanepa meane kama puku. Nitiku toa no noai tiki-kitipa no patu kautakoapa mea kama poadete tiki. ");
INSERT INTO wiu_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","A tibu mea ketipea nekene palawe wanepa enina. Eni palawepa kini kaua-mikitame nakene maana nee keneya mena. Eni nee noai toake tukala taneya. I nee noai tiki-kitipa mea kama poadete tiki wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesuyo einaka einamo oa olaukakilepa Kapaneame take losu yapu keneke kakome toka. ");
INSERT INTO wiu_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Yesuno agale wete yakoa motane yene peya matiyame einagale yatekete ekete i olaukoa oko agale litia tamene poto tokono, teyo edoa yakoa tomotoa-pe wa okoi. ");
INSERT INTO wiu_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Nimo ko̱ oa kakedekoli Yesuyo tetoa enekome e yene-pala okome anu uku agalekepa wene poaneya mekete iki-pe. ");
INSERT INTO wiu_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ali Yatenane Oyago no kawane nokouna lono wakapeane atepeane pokolu eneketepa ede wene pioi-mo. ");
INSERT INTO wiu_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Mea kama pomotoapa Epetane Yominiyo toko. Tigini tele takateko peku-kama nakagopa mea kama pamele toamoko. Ina agale oane metekilepa Yomini patu kautakoa kakete mea kama poatikimo oane metekouna. ");
INSERT INTO wiu_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ae, eni uku agale yateketeke kiwi padeka-kiti nooke wene tugoa meamiki wa Yesuyo oka. Nipa namolo papete oneke wene tugamokoi yeneka one wia tukamotoa meatekagoka i i wa wene toopia mekome tokome ni oka. ");
INSERT INTO wiu_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Nitikome okome Akolaliyo ka patekoa nooke wetekako yene odene nooke namele toko wane okounapa enike ekene okouna wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Enipete titimoa Yesuno agale yakoa motane yene kainya matiyame Yesu tewitikoa wawa one-pala wa lokoa yawamokoi. ");
INSERT INTO wiu_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Nitikolipa Yesuyo one tuku kakoa (12) oya-lawe-pala okome kimeka no tewitikoa wawa poadete iki-pe-kale ");
INSERT INTO wiu_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Saimone Pitayo okome Ali Muno ne wawa peketepa toto teeke pomotoa-pe. Mea kama poateko agale pinagopa ne odene toko-la. ");
INSERT INTO wiu_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nepa Akolaliyo onekemo-kama akamotoa takoa moa kakapiane ago tadeko wa totome wene toko-kale okome ");
INSERT INTO wiu_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","kiwi tuku kakoa (12) ali-kitipa anume takoane motokounake kiwi panagopa iponane peku nakago wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Eni okapa Saimonane mana Yudase Isekarioseke okome oka. Nipa Yesuyo one oya-lawe tuku kakoa (12) takoa motokome einagoka motaneyake mone yename one wia tukamotoa einagome moa meoo tokale oka. ");
INSERT INTO wiu_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Nititikaneyake Yu yename one wia tukadete tokoli tokome Yesu Yudea ta ludu yawamademe Galili ta ludu pima yaka. ");
INSERT INTO wiu_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Einapetepa Yu yene kini losule tekete aga kelekoa yapu wia toge kiatekoi tigotokalepa ");
INSERT INTO wiu_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Yesuno wamene-mikitame one-pala ekete tone Galili ta tewitikoa Yudea take poano pa. Neme toma yakolepa neke agale yakoa tiki yename enemotono pa. ");
INSERT INTO wiu_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Panagome-kiti ibini akene ago meou wa wene pikomepa one toma yakole kebono take yawa paigakoa keneya toamokono, neke ile toma yakepa ta piko peyake keleyo toma poano pa wa Yesu-pala akeneya. ");
INSERT INTO wiu_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Nipa one wamene-mikitika oneke wene tugamekete okoi. ");
INSERT INTO wiu_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Nitikoli okome kini toatikilepa kini wene litiapa ipeteka kupeteka tamele tokolo tikino, no pade nitamuku. Anu toatekule taatekoane tuku-petepa opi mena. ");
INSERT INTO wiu_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Itono peku noai tiki-kitame kipala kotimi yoa meamele toamoko. Anumepa eni yene kini tikilepa poanele-kama tiki wane akoane ukulu tokome nopala kotimi yoa meki. ");
INSERT INTO wiu_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","A Yerusaleme togeke kini poe. No pade poamuku. Anu toatekule taatekoane tuku-petepa opi menano, poamuku wa Yesuyo ootokoa ");
INSERT INTO wiu_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","one Galili take pa eida meka. ");
INSERT INTO wiu_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","One wamene-mikiti wete pote toge lobutupokoli Yesu oneka pokome keleyo poameneya paigakoa keneya poka. ");
INSERT INTO wiu_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Nitaneyake tobou meane Yu yename toge kikoa mekete Yesu tuku toa kakete ekete Yesupa edekato-pe wa oa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Nitikolipa pa ali atoa kini kini oboa kakete ekote ekota oi oi wa kakete pade-kitame ekete Yesu einagopa epetanele tokago wa oa wa pade-kitame ekete einagome ali atoa oa yotokakome toko wa oa taneya. ");
INSERT INTO wiu_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Nimo oa kaketeke kini tobou ali-kiti piti motekete tekete Yesu ko keleyo witoa akaya wa mama moa meaneya. ");
INSERT INTO wiu_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Toge kia meane tiginalo tadiya Yesu tobou losu yapu pokome olaukoa kaka. ");
INSERT INTO wiu_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Nitikale yatekete e Yu yename ka̱ oa kakete ekete i agopa tone totono pine to̱a olaukaki ali-kitame olaukameneyake imopa i okono, edoa wene toa okoto patu-kale Yesuyo okome ");
INSERT INTO wiu_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","anu olaukoane ukumopa anu weneme pade titiane wamuku. No moa wetekakagome akoano ta wa okomo-kama oane mekala tuku. ");
INSERT INTO wiu_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","One wene pikole toada wa tiki-kitamepa anu olaukakumopa anu weneme titiane olaukadekoluka Akolaliyo akoano ta wa okomo olaukadekoluka oyake takoa enamele too. ");
INSERT INTO wiu_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Padago one weneme pademo pademo titia okomepa ali atoame one kei pimotoa tokome ni oko. Ali atoame one moa wetekakago kei pimotou wa wene pia oko agomepa pademoka kapene yokamoa niminimo-kama oa mekala toko. ");
INSERT INTO wiu_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moseseyo one totono yametaneyake kiwi padameka litia toamiki. Eni totonodo litikete toi tokapa no wia tukadete wili toamoi tookano, dekolo tiki-pe wa Yesuyo okale ");
INSERT INTO wiu_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","peyame ekete nepa teyo wia tukademe wili toa kako-pe. Beita, neeke ipono awinome mekolo teke ni oko-koli okome ");
INSERT INTO wiu_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","tone ko mea pupu toamateko-peteka padele telekole toane pade ago epetekakoule kime enekoina tekete wene kainya pianeya ko̱ oa kaki. ");
INSERT INTO wiu_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moseseyo eya wa akeneyake tiki. Kini ali mati opiketepa one kepene teigamotamene wa oa pianeya. Eni oa piane toa litiapa ali matiyane kepene teigatiki oi ponokolopa kini ko mea pupu toamatiki-peteka teigakina. Nipa Moseseyo one kaua-mikitame tanele litia tokome akene toa tikina. ");
INSERT INTO wiu_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Nipa Moseseyo akenele tetekamedekolo kini ko mea pupu toamatiki-peteka ali matiyane kepene teigakete pupupa eni tikina. Nitikinano, opi kini ko mea pupu toamatiki-peteka ali pade pupu toane epetekakolu tekete nopala kotimi yoa mekino, dekolo tiki-pe. ");
INSERT INTO wiu_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Padame tanemo pine enameneya kaketepa pa akoa agale wameamene. Pine pitia yakatapea ki̱yoke-kama to̱a okala tamene wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Einapete Yerusaleme yene padeka-kitame ekete Yesu i agopa tobou ali-kitame wia tukadete wili toa kaki ago patu. ");
INSERT INTO wiu_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ekee, i keleyo nome kakome okoyake pademoka topo toa ikile toamikino, tone tobou ali-kitame i agopa Keraisu wa papete ibini oa piane ago taatekoa nekedeko wa wene tiki patu. ");
INSERT INTO wiu_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Beita, i ago one tobotoi ta totome wene toko. Keraisudo taatekoa nokalepa one tobotoi ta i wa padameka wene toamoi wa okoi. ");
INSERT INTO wiu_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Nitaneyake Yesu tobou losu yapu eida pa olaukoa kakome agale telo okome okome kime nopa i ago wa wene toa ni no kawane nokouna ta i waka wene toa iki. Eni wenepa tikiyake anu weneme nokouya mena. No moa oto wetekaka agome niminimo-kama okoyake kime pade one wene toamiki. ");
INSERT INTO wiu_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Wene toamikiyake one wenepa anume tuku. Einago mekota kawane nuku. No ne pa wa oneme no oto wetekakono, einago wenepa tuku-kale ");
INSERT INTO wiu_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","one dekoa moadete wili toa kakoiyake one moatekoi-pete wete taatekameneya tokome one dekoa moamokoi. ");
INSERT INTO wiu_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Nitikolika eida oboa kakoi-kiti kainya mati Yesuke wene tugakete ekete Keraisu taatekoa nokomepa i agome telekole tokole moa patukademe toko patu. E̱'e mena wa oneke wene tugakoi. ");
INSERT INTO wiu_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Eida oboa kakoi yename Yesuke einaka einamo oi oi wa okoli Parisi yename yakaneya. Nitaneyake Akolalike lodo yotokoai tane tobou ali-kitame Parisi yenameka tobou losu yapu yopiane poyo ali-kiti Yesu einago dekoa motokapoe wa moa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Wetekakoli nokoli Yesuyo okome kipala opiane me me tootokoanepa wakapeane no moa wetekakagoke pou. ");
INSERT INTO wiu_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Pokolupa kime no tukupa teketeke oyake enamoi. No pone kawatekutapa kiwi oyake noamoi. ");
INSERT INTO wiu_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Yesuyo nimo okale e Yu yene kini kini yakate tekete ekete totome tuku toa enamateko takepa maida poademe oko patu. Toto yatene ali atoa Geriki take to̱a pote mekika i agoka pokome Geriki agale yakoa iki yene olaukapademe okome okoto patu. ");
INSERT INTO wiu_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","I agomepa one tuku tekete enamoi wa oa one pone kawateku takeka kiwi noamoi wa toto-pala oa tokono, edemo okome okoto patu wa oa kakoi. ");
INSERT INTO wiu_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Toge kikoa mea wipititapeane-pete Yu yename kini tobou kakoa kiatekoi toge eni kia peya takakoi. Nitikolipa Yesu oneka nome kakome agale telo okome okome ue nodome tuki-kitipa ue noukete nooke note nonamene-ye. ");
INSERT INTO wiu_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Akolaline bokuke papete wia mekapiane toapa nooke wene tugoa meki-kiti kini tepenepa ue lene to̱a ue-kiti yokoa kama poo wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Nipa oneke wene tugoa mekoi-kitike pene awinome meateka Yominike okome oka. Einapetepa Yesu one pa̱ teleta tootapeneya mekana take wete wa moa kakameneya tokome Epetane Yomini ali atoake wete awinome meameneya. ");
INSERT INTO wiu_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Yesuyo eni oka agale yakane yene padeka-kitame ekete i agopa Akolaline agale to̱awea akatekago taatekoa nekedeko wa oa ");
INSERT INTO wiu_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","wa padeka-kitame ipa Keraisu wa papete ibini oa piane ago taatekoa nekedeko wa oa taneya. Nitaneyake padeka-kitame ekete Keraisu wa papete ibini oa piane agopa Galili ta edoa taatekoa nomotoa-pe. ");
INSERT INTO wiu_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","One noatekalekepa panagome Akolaline bokuke eya wa wia mekapianeya. Keraisu einagopa Depidi-loeke ta̱wa noo wa oa Depidi meane Beseleme take taatekoa noo wa wia mekapianeya. Enipa totome nimini okoto-pe wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Nipa Yesuke e ali atoa ete oto wa puutakutukoa agale to̱a kakoi. ");
INSERT INTO wiu_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Nitoapa padeka-kitame one dekoa moadete okoiyake padameka dekoa moamokoi. ");
INSERT INTO wiu_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Tobou losu yapu yopiane poyo ali-kitipa Akolalike lodo yotokoai tane tobou ali-kiti Parisi ali-kitika koukoa mekoita wakapea nokoli ekete Yesu einagopa dekolo aua noamiki-pe wa okoli ekete ");
INSERT INTO wiu_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","namolo okoli yakamokoonakamo einagome oa kaka tokolo dekoa moadete poteke wawa noko-koli ");
INSERT INTO wiu_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Parisi yename ekete einagome kiwika oa yotokakome toka patu. ");
INSERT INTO wiu_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Tobou ali-kiti toto odene agoka oneke wene tugamoko. ");
INSERT INTO wiu_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Beita, i oboa kaki ali atoame einagono agale yakoa motikilepa Mosesene totono wene toamekete tiki. Akolaliyo dikane ali atoa poane take pomotoa wako wa Parisi yename akeneya. ");
INSERT INTO wiu_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nimo okoli kini yagono ago pade Nikodimasi namolo Yesu mekata pekene agome e yene eya wa yakaneya. ");
INSERT INTO wiu_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Tone totono litiapa panagono koiso akakete eya toamoko-pe. Pinali one kei pikome okomo wete yakameneyake neke tanele ile tadeko wa totome akoa agale oko patu. E̱'e mena wa Nikodimasiyo okale ");
INSERT INTO wiu_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","e yename ekete neka Galili ago kake teke ni oko-pe. Akolaline boku moa lewea oi moamene. Nitikepa Akolaline agale to̱awea akane ago odeneka Galili take taatekoa noameadeko wa wene too wa oomotekete ");
INSERT INTO wiu_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","kini kini yapu yapu tadoa pootapeneya. ");
INSERT INTO wiu_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Nitaneyake Yesu Olipe-pini tonoke pome ate lewia mepoka. ");
INSERT INTO wiu_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Wa podolikama likonu witia tobou losu yapuke pome kapokale ali atoa peya one kakata obomoa note kakoli witipitoa mekome olaukoa meka. ");
INSERT INTO wiu_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Nitoa mekaka Mosesene totono pine to̱a olaukane ali-kitame Parisi ali-kitameka atoa pade Yesuke lia aua nokoi. Nipa motane atoa eko alike pokome koua pitikale enemotekete aua nekete e yenane lene yoto moa kakakoi. ");
INSERT INTO wiu_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Nitikete ekete Tikisa ago i atoame eko alike pome koua pitikale totome enekoo. ");
INSERT INTO wiu_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moseseyo one totono yametekomepa dikane atoa kueme ka̱ua wia tukakala tamene wa akeneyano, opi neme edemo oo-pe wa yatekoi. ");
INSERT INTO wiu_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Nipa Yesu natemo omotadiya wa kakete pa likoa enekete okoi. Nitikoli Yesu one keti itonoke waliketikakome kadapi yoname olea adekoa meka. ");
INSERT INTO wiu_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Nitoa mekale e yene pa eida kakete yaka yaka tokoli Yesu mukiti ki̱yotokakome okome kiwi pake poanele toamoko ago kako patuno, einatoa kue moa pitikoa witikilepa einagome titia tomotoane uku wa ootokoa ");
INSERT INTO wiu_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","wa keti itonoke walikitikakome olea adekoa meka. ");
INSERT INTO wiu_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Nitikale e yene odene odene wa katepita katepita toa pekete ada-kiti namolo kakoa pokala tokoi. Nipa Yesu einatoa-pala pa kamotoa pootapekoi. ");
INSERT INTO wiu_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Nitikoli Yesu wa mukiti ki̱yotokakome enekale einatoa odene kakedekale enekome okome ne akoa okoina yenepa dekoti-pe. Ne poanele tadekono, kibu mou wameneya wakoti-pe-kale okome ");
INSERT INTO wiu_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","kamo koniyali padameka no akoa wamokoi-kale okome noanumeka ne poanele tadeko wane akoane wamuku. Neke poanele tokole wake wawano pa wa oka. ");
INSERT INTO wiu_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Nititikoa Yesuyo e yene-pala agale pade okome okome nopa itonoke meki-kiti pa̱ takakuya. No litima niki-kitipa yomiyomu keneke yawamekete ali atoa mea kama pomotoa toko pa̱ keneke yawa meoi-kale ");
INSERT INTO wiu_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","e Parisi ali-kitame ekete pinali neke wa kei pikopa winipa pa oko-koli okome ");
INSERT INTO wiu_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","pinali anu wa kei pikeneka nimini uku wane uku. Noanu kawane nokounata wa pone kawatekuta pinali anu wene tekene ni uku. Nitikuyake no kawane nokounata wa pone kawatekuta kime pade wene toamiki. ");
INSERT INTO wiu_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Kimepa panagome tanemo pitia yakatekoa ile tadeko wa akoa ikilepa kini kaua-mikitame toma nekenele tiki. No pade nitamekene ali atoame tanele ile tadiki wane akoane wamuku. ");
INSERT INTO wiu_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ali atoa kini tanele pitiane yakatekoane ile tadiki wanedo akoane ekenepa pine to̱ane ou. No moa wetekakago Agetaiyo no auapekala tokolo tekene ni uku. ");
INSERT INTO wiu_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Kini totono wia mekane bokuke eya wa wia mekanemo kiwi wene takakene uku. Takutamedo padele tokale enoa nekete i i wa odene kotuta kakoa eketepa nimini ekete oi. ");
INSERT INTO wiu_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nipa pinali anu wa kei piane uku. Agetai no moa wetekakagomeka no kei pia toko. Agetai totame odene kotuta kakoa oko wa Yesuyo okale ekete ");
INSERT INTO wiu_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","neketai edekato-pe-koli okome kime no pade wene toamoa Agetaika wene toamoa tiki. Kime no wene toi tokapa Agetaika wene toi toka wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesuyo nimo ikilepa tobou losu yapu keneke losu kue pitikoai tane mete pianeya liti kakome olaukoa oka. Nitikalepa padameka one dekoa moamokoi. Nipa one moatekoi oi wete ponameneya tokome dekoa moamele toameneya. ");
INSERT INTO wiu_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesuyo eya waka oka. No ita tewitikoane puku. Pokolupa kime no tuku toa teko tokale wakete kini poanele pa etepea toma pote tukala toi. No poatekuka kiwi pade namele toamoko wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Nimo okale e Yu yene oote tekete ekete i agome one poatekuka toto pade namele toamoko wa okopa pinali one wa wia tukatekomo okome oko patu-koli okome ");
INSERT INTO wiu_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","kipa kini pine taapa keti itono lono. Noanu pine taapa ate tibu lono. Kipa kinikaua-mikitane peku noa tiki. Noanupa eni peku noane toamuku. ");
INSERT INTO wiu_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Kini poanele pa etepea toma pote tuoi wane okouna toa taatekoa tuutapeoi. Nipa nopa i ago tadeko wa wene toameketepa nitoi wa oka. ");
INSERT INTO wiu_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Nimo okale ekete nipa nepa ali te-pe-koli okome namolo titikene nopa i ago wane okala tokounapa einago eni. ");
INSERT INTO wiu_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Kini toma yakoinakale pitiane yakatekoane ile tadiki wane akoane oatekumo-kiti ete pa piko. Nitikoyake anu weneme pademoka wamuku. No moa wetekakagome pine to̱a yameteka toane itonoke meki yene-pala to̱aweane oadene tuku. Einagomepa niminimo-kama okolo uku wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Nitikalepa oneketaike okono wene toamokoli okome ");
INSERT INTO wiu_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","no Ali Yatenane Oyago moa yomoke wia dekoa ate kamotokatekoa kakete ae no i agopa eina noatekago tadeko wa wene toa eya waka wene toa toi. No einagome padeleka one weneme toamokome oneketaiyo olaukakana toa-kama oa mekala tokome tadeko wa wene toi. ");
INSERT INTO wiu_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","No moa wetekakagopa nopala odenekata yako. One wedia memotoane toateku toane-kama tukulu tokome toko. Nipa nepa egetiniya yamene wa no tewitikamoko. ");
INSERT INTO wiu_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yesuyo nimo oa kakaka e yene kainya mati oneke wene tugakoi. ");
INSERT INTO wiu_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yesuyo oneke wene tugakoi yene-pala okome anume oane meteku agale yakoa teketepa nipa anu oya-mikiti etene meoi. ");
INSERT INTO wiu_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Nipa anu agale pine i i wa wene tootapea mekete tekete namolo egetiniya meake peku mati-kiti latioi. ");
INSERT INTO wiu_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Yesuyo nimo okale ekete totopa Eberameke tagene yene. Mone padane yapuke egetiniya mekileka toamoko. Nitikono, toto egetiniya-kiti namolo meake peku mati-kiti latioi wapa dekolo oko-pe-koli okome ");
INSERT INTO wiu_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","nimini ukuno yakoe. Poanele toma yaki-kitipa kini poanele tikileme pine yene kiwi moa kautako. Nitikolo egetiniya meane tetepo taneya meki. ");
INSERT INTO wiu_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Egetini ago pade one egetekagono yapu eida mea kawamokoyake yapu pinagono mana eida-kama mea kako. ");
INSERT INTO wiu_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","No yapu pinagono managome kiwi egetiniya-kiti peku lawetekolupa nipa etene peku mati-kiti latioi. ");
INSERT INTO wiu_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Kipa Eberameke ta̱ma nekeneyano wene tuku. Eberameke tagene yenameke no wia tukadete tiki. Nipa anu oane meteku agale kini tepene alateko pake piamokolo ni tiki. ");
INSERT INTO wiu_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nopa Agetai-pala opiane kakene enoane yakoane tokou toane ukuno, kipa kiniketaiyo peku lawetekale noa toma yaki wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Nimo okale one-pala topo takakete ekete toneketaipa Eberame-koli okome kipa nimini Eberameke tagene yene kawei tokapa nipa Eberameyo toma yakenele toi tokake ");
INSERT INTO wiu_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","no wia tukadete iki. Nipa Akolaliyo one nimini peku lawetekome oka toane niminimo-kama oane meteku agoke wia tukadete iki. Eberameyo niminimo akene ali-pala enile toameneya. ");
INSERT INTO wiu_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ae, kiniketaine peku noa tiki wa Yesuyo okale ekete toneketaipa Akolali. Panago mena. Toto pade pakeleya-kiti mena-koli okome ");
INSERT INTO wiu_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","kiniketaido Akolali too tokapa nooke wene mekoa meoi toka. Nipa Akolaline yono kounoke kawane nokolu tokome nitoi toka. No nikilepa anu weneme noamokou. Akolaliyo pa wa wetekakale nokou. ");
INSERT INTO wiu_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","No nitane ago anu oane meteku agale dekolo wene toamiki-pe. Anu oane metekumo yakoa moamele toamokolo ni wene toamiki. ");
INSERT INTO wiu_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Kipa kiniketai Setanuno mana-mikiti. Kiniketaine wene pikole-kama toada wa wene pia meki. Tititikakome einagome ali wia atukama nekeneya. Einagopa nimini patu kautakoa kawamoko. Nimini peku nakileka toamoko. Onepa kapene wakoa oko ago. Oneke-kama kapene wakoa iki agale alama noko. Nitikono, kapene wakoa ikilepa one tepene meane toa-kama ya̱wa oko. ");
INSERT INTO wiu_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Noanumepa niminimo-kama ukulu tekete no i agome nimini oko wa nooke wene tugamiki. ");
INSERT INTO wiu_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","No i agome poanele tokale enekou wa teyo oo tokolo-pe. Padameka wamoi-li. Nipa niminimo-kama ukulupa ipa nimini oko wa dekolo wamiki-pe. ");
INSERT INTO wiu_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Akolaline mati-kitame one agale yakama piki. Kipa Akolaline mati-kiti mena. Nitikono, one agale yakamiki wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Nitikale e Yu yename ekete nepa mone Sameria take agono, neeke ipono awinome mekale wini oko. Enipa totome nimini okoto-pe-koli okome ");
INSERT INTO wiu_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","nooke ipono awinamoko. Noanumepa Agetai kei piane ukuyake kimepa no taumada toa iki. ");
INSERT INTO wiu_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nitikipa no kei piati wane none wamuku. Panagome pade no kei piai toko. Einagopa peyame tikile pitia yakoa kini tanele ile tadiki wa pine to̱a akako. ");
INSERT INTO wiu_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Etene nimini ukuno yakoe. Anu uku agale yakoa tiki-kitipa tua pote atuameneya pa mea kama poadete tiki-kale ");
INSERT INTO wiu_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","e Yu yename ekete neeke ipono awitadekono wene totome toko. Neke agale yakoa tiki-kiti tua pote atuameneya pa mea kama poadete tiki wapa oko. Beita, Eberameka tua Akolaline agale papete to̱awea akane ali-kitika tuma-kala note taneyake oko. ");
INSERT INTO wiu_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Tone kaua Eberame wete tuaneyano, one kakene toa ne moa patukoa ako kake oko-pe. Akolaline agale papete to̱awea akane ali-kitika tuutapeneyake oko. Ne ali latike oko-pe-koli okome ");
INSERT INTO wiu_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","pinali anu wa keido pikenepa nipa pata pamo ekene tou. No kei piai toko agopa Agetai. Einagopa kini Akolali wa ikiyake ");
INSERT INTO wiu_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","one wene toamiki. Nitikiyake one wenepa anume tuku. Onedo wene toamuku wane ou tokapa nipa kime kapene wakoa iki toane ekene tou tokake one wene toane oneme okole-kama yakoane tuku. ");
INSERT INTO wiu_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","No nokoule enademe tokome kini kaua Eberame wedia kolotine meaneya. Nokoule enekome wene yaapeneya meaneya wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Nitikale e yename ekete nepa opitikaneyake mali ege odepetaka kadukoa (50) wete ponameneyake okono, Eberamepa neme edoa enoa oko-pe-koli okome ");
INSERT INTO wiu_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","etene nimini ukuno yakoe. Eberamepa wete opiameneyake no pa meane kama nuku wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Nimo okale e Yu yename i ago wiato wa kue katekamotokoli Yesu paigakoa keneya pome tobou losu yapu wawa poka. ");
INSERT INTO wiu_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesu kutu ponokomepa leneta lianeya opiane ago pade enema ponoka. ");
INSERT INTO wiu_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Einagopa Yesuno oya-laweme enekete ekete Tikisa ago i ago leneta lianeya mekopa dekale taneya patu. Etene niname poanele tokoli taneya patu. Pinali one poanele tokale taneya patu-koli okome ");
INSERT INTO wiu_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","etene ninameka einagomeka poanele pade toamokoiyake Akolaline telekole winagoke witakale enekamotoa ni taneya. ");
INSERT INTO wiu_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Lou pa kakolopa no moa wetekakagono pupu totome takama pamedeko. Ta likalepa padameka one pupu oyake takamele toamoo. ");
INSERT INTO wiu_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Itonoke pa yawane mekenepa ali atoa peya pa̱ takama pukuya wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Nimo ootokoa itonoke tekelipu tooketikoa tekelipu kakene itono wane moa kege latia einagono lenetake yotokaka. ");
INSERT INTO wiu_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Nitikome okome ne ue Siloame mineke poke kege koba wa wetekakale pokome leneke kakene kege ko̱omotokome leneta kikatapeneya wakapea nekeneya. (Tone agaleke Siloame wapa moa wetekaneya wa ekete oo.) ");
INSERT INTO wiu_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Nitikale one yenameka one namolo padeya-kiti oia moa mekale enekoina ali atoameka einago enekete ekete i agopa ina namolo padeya-kiti oia moa mekanakago patu wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Nitikoli padekame ekete e̱eno, einakago i noko-koli wa padekame ekete einakago mena, one keneya ago i noko-koli einagome okome no einago i nuku-kale ekete ");
INSERT INTO wiu_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","neke leneta edoa epetekaneya-pe wa okoli okome ");
INSERT INTO wiu_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Yesu wa ibini iki agome itono wane moa kege latia anu lenetake yotokoa wetekakome okome ue Siloame mineke poke kege koba wa wetekaka. Nitikale pone kege kogulu anu leneta kikatapeneya wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Nitikale ekete einagopa manika kako-pe-koli okome agopa tokono, manika patu wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","E yename leneta lianeya mekanakago Parisi ali-kitike aua pekeneya. ");
INSERT INTO wiu_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Yesuyo itono moa kege latia einagono leneta epetekakilepa Yu yenane ko mea pupu toamatekoi-pete toka. ");
INSERT INTO wiu_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Einago nokale enekete Parisi yename one leneta edoa epetekaka-pe wa yatekoli okome anu lenetake kege yotokakale kege ko̱otokoanepa opi enamele toko-kale ");
INSERT INTO wiu_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Parisi ali padeka-kitame ekete tone ko mea pupu toamateko-pete kekanele eni tokano, einagopa Akolaliyo moa wetekakago mena-koli padeka-kitame ekete enika eni telekole tokolepa poanele tokagome edoa tomotoa-pe wa akeneya. Nitoapa ete oto wa puutakutukoa agale to̱a kakoi. ");
INSERT INTO wiu_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Nitoa leneta lianeya mekanakago wa yatekete ekete einagonomo neme edemo wa akako-pe wa yatekoli okome einagopa Akolaline agale akako ago toko-la wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Leneta lianeya opianeyake opi enamele toko wa einagome okaleka e Yu yename yakoa moamadete wakoi. Nitoapa einagono etene nineta noe wa agale oa wetekakoli nokoli yatekete ekete ");
INSERT INTO wiu_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","i agopa kini mana-pe. Kitame opia pitikaketepa leneta lianeya opikoiya-pe. Opi wa edoa lene epetekaneya meko-pe-koli ekete ");
INSERT INTO wiu_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","winagopa tone mana. One leneta lianeya opikooya. Enido wene tokoyake ");
INSERT INTO wiu_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","one leneta epetekanele wene toamoa one leneta epetekane agoka wene toamoa toko. Winago wetinagoke taneyano, one-pala tanemopa one oademe tokono, kini pitia yakoe wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Nipa Yu yenane tobou ali-kiti piti motekete akeneya. Eni tobou yename wetena oi pedoa pikete ekete Yesu einagopa Keraisu wa papete ibini oa piane ago taatekoa nekedeko wa okoi-kitipa losu yapuke wa noamomotato wa oi pedoa pianeya. ");
INSERT INTO wiu_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Nitaneyake einagono etene ninetame ekete one wetinagono, one pitia yakoe wa etene niname akeneya. ");
INSERT INTO wiu_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Nitikoli wa lokoa Parisi ali-kitamepa leneta lianeya opianeya mekanakago ne no wa kayo oa motekete ekete Akolaliyo yakakoa nimini oano ta. Neke leneta epetekakagopa poanele tokagono wene totome toko-koli okome ");
INSERT INTO wiu_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","one poanele tokago patu. No wene toamuku. Eni wenepa toamukuyake namolo leneta lianeya mekounake opi leneta epetekakaneya kakuno wene tuku-kale ekete ");
INSERT INTO wiu_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","oneme edele toka-pe. Neke leneta edele toa epetekaka-pe wa yatekoli okome ");
INSERT INTO wiu_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","anumena namolo okouna yakamoake wa dekolo yateki-pe. Kimeka one agale litia too wa wene pikete iki-pe wa okale ");
INSERT INTO wiu_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","poanemo oa kakete ekete nepa eni pa agono agale litia tokoyake totomepa Mosesene totono litia toko. ");
INSERT INTO wiu_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Akolaliyo Mosese-pala ko oa kakeneyano wene totome tokoyake eni pa agopa one kawa noko lonoka totome wene toamoko-koli okome ");
INSERT INTO wiu_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","ae, kime einago akakipa no wene kainya pikoa kakina. Einagome anu leneta epetekakaleka one kawa nekene lono pade wene toamekete iki. ");
INSERT INTO wiu_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Akolaliyopa poanele toma yaki-kitame kowitoa ikimo yakoa toamoko. Nitikoyake one wene pikole toada wa oneke nate wene pia kowitiki-kiti kini kowitoa ikimo yakoa toko wa totome wene toko. ");
INSERT INTO wiu_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Itono tibuta latiane-peteka opika leneta lianeya opiane agono lene epetekakaneya wa akenemo padameka yakameneya. Namolo yakamokoonakale einagome titia toko. ");
INSERT INTO wiu_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Einagopa Akolaliyo moa wetekamoo tokapa enilepa oyake toamoo toka wa ena leneta lianeya mekanakagome okale ");
INSERT INTO wiu_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","e yename agale topo takakete ekete nepa poaneleke alaneyake toto moa olaukade oko-pe wa ootokoa einago dekoa moa losu yapu akolono pitikapaneya. ");
INSERT INTO wiu_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Einago losu yapu akolono moa pitikaneya wa okoimo Yesuyo yakatekoa pome kotukome okome nepa Ali Yatenane Oyagoke wene tugako-pe-kale okome ");
INSERT INTO wiu_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","kamo koniyali winagoke wene tugoane meouno, one te-pe wa yatekale okome ");
INSERT INTO wiu_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","einagopa neme wete enekona. Opi neta ko oa kako-kale okome ");
INSERT INTO wiu_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ali Muno neeke wene tugaku wa neuwe tukupia one kei pia kaka. ");
INSERT INTO wiu_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Nitikale Yesuyo okome itonoke nikilepa ali atoa takoane enoane akadene nokou. Nipa leneta lianeya meki-kiti epetekoane ni leneta kianeya meki-kiti leneta likoane toadene tekene nokou wa oka. ");
INSERT INTO wiu_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Yesuyo nimo okale yatekete one-pala eida opia kakoi Parisi ali-kitame ekete tone lenetaka lianeya kakolo oko-pe-koli okome ");
INSERT INTO wiu_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","kini lenetado lianeya kaketepa nipa kini tiki poanele wene toamekete tiki. Eniledo wene toamekete tikilipa koiso akoane oateku pade piamoko. Leneta liameneya mekete oyake enamele toko wa ikili yatekene tekene kini poanele tanepa wene teketeke tadikino, koiso akoane oateku pade pa piko wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesuyo okome okome etene nimini ukuno yakoe. Panagopa sipi sipi kai-kiti kolago taneya kakita kago pikaneta noameneya eko pata paigakoa lewia nokomepa nipa sipi sipi kai-kiti kode mou wa wene pia noko. ");
INSERT INTO wiu_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Kago pikaneta noko agopa sipi sipi kai-kiti talo tokago eni. ");
INSERT INTO wiu_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Einago nokolo kagoke payaponago kako agome kago pekakolo lobutunoko. Nitoa lobutua kakome okolo sipi sipi kai-kitame yakakoa mekili kini ibini odene odene wa oa moa akolono aua poko. ");
INSERT INTO wiu_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Nitoa peya akolono aua pomepa one namolo kawa pokolo one sipi sipi-kiti kawatuku pitoa pokala tiki. Nipa talo tokagono tobotobo yatekete tekete one pokoka litima piki. ");
INSERT INTO wiu_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Nitikiyake mone pade ago nokolopa litima poameneya paka pitoa piki. Nipa mone pade ali-kitane tobotobo wene toamekete tekete pitoa piki wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesuyo nimo pedoa okalepa e yename ike oko wa wene tokoiya mena. ");
INSERT INTO wiu_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Nitoa agopa moa mekoli Yesuyo lokoa okome okome etene nimini ukuno yakoe. Sipi sipi kai-kiti kolago taneya kakita lobutatiki kago keteponopa no. ");
INSERT INTO wiu_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","No wete noameneyake pade ali-kiti nikilepa sipi sipi kai-kiti kode moato wa noai taneya. Nitaneyake sipi sipi kai-kitame kini agale yakameneya. ");
INSERT INTO wiu_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Sipi sipi kai-kiti kolago taneya kakita lobutatiki kago keteponopa no. Ali atoa anu kawane eni note lobutunokoli pawe toane mou. Nitikolupa akolono wititapekete pote nee noa yawa kawa oto wa lobutunokala toi. ");
INSERT INTO wiu_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Kode ago nokomepa eya kuya kode moa ali wia atukoa enika enile-kama toademe noko. Nitikoyake noanu nekenepa ali atoa mea kama pomotoane tekene nokou. Nipa pewe wia tagatapeneya mea kama pomotoane tekene nokou. ");
INSERT INTO wiu_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Nopa sipi sipi kai talo toane epetekaku ago. Talo toa epetekakagopa sipi sipi kai-kitike tuademe toko. ");
INSERT INTO wiu_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ipa kue moadene tuku wa talo tokagomepa eya toko. I sipi sipi kai-kitipa one mena wa talo toa mekome enekolo lene piane tue tubeyame sipi sipi kai-kiti wia noademe nokolo enekomepa sipi sipi kai-kiti tewitikalogoa pitoa poko. Nitoa pitoa pokolopa tueme sipi sipi kai-kiti deka deka toa wia noa tadekatapeko. ");
INSERT INTO wiu_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Einagopa kueke-kama wene piitikaneya mea talo tokome tokome sipi sipi kai-kiti mama moameneya pitoa poko. ");
INSERT INTO wiu_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Nopa sipi sipi kai talo toane epetekaku ago. Anu sipi sipi kai-kiti wene taneya meku. Anu sipi sipi kai-kitame no wene taneya meki. ");
INSERT INTO wiu_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Nipa Agetaita tone wene toko toa anu sipi sipi kai-kiti tone tone wene toa meko. Nitoanepa anu sipi sipi kai-kiti talo toane meane tuou. ");
INSERT INTO wiu_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Anu sipi sipi kai padeka-kiti anu kolago tukuta wete koukoa note kawamiki. Eni sipi sipi kai-kitika oto auane namedeku. Nitikolupa anu agale yakakoa meoi. Nipa kiwi talo tuku ago nooke-kama lukoa meoi. ");
INSERT INTO wiu_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Agetaiyo no wene taneya mekilepa eya toatekuleke toko. Kamoane poadene tekene anu sipi sipi kai-kiti talo toane meane tuou. ");
INSERT INTO wiu_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Padameka no oyake wia tukamatikiyake pinali anu weneme tuou. Tukileka kamoane pikileka anu weneme tuku. Nipa Agetaiyo ta wa oka tokolo tuku wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Yesuyo eni okagaleke e Yu yene ete oto wa puutakutukoa agale to̱a kakoi. ");
INSERT INTO wiu_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Nitoa kainya matiyame ekete oneke ipono awinome mekome leau akakolo ni okono, one okomo yakamatoe wa okoli ");
INSERT INTO wiu_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","pade-kitame ekete ipono awitane agomepa enika eni agale oyake amele toamoko. Leneta liane agopa iponame one leneta edoa kikakamotoa-pe wa okoi. ");
INSERT INTO wiu_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Yu yename tobou losu yapu kago peane oi pikoa mekete toge kia meaneya. Niti tane tokene-mene pakeke nitaneya. ");
INSERT INTO wiu_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Eni toge kia mekoi-pete Yesu tobou losu yapu nokomepa Solomono wa yomini kayo oa ibini akene lono eida yawa meka. ");
INSERT INTO wiu_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Nitikaka Yu yene Yesu kakata koukoa nekete ekete neme toto wene kainya pikoa-kala mekona, nepa Keraisu wa papete ibini oa piane ago tadekalepa wete to̱awea a-na wa okoli okome ");
INSERT INTO wiu_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","namolo to̱aweane okounake nooke wene tugoa meamiki. Agetai patu kautakoane kakene toma yakule kini leneme enekipa nopa einakago tadeko wa kime wene tomotoane tukuyake ");
INSERT INTO wiu_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","nooke wene tugoa meamiki. Kipa anu sipi sipi kai-kiti toamekete tekete ni wene tugoa meamiki. ");
INSERT INTO wiu_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Anu sipi sipi kai-kitamepa anu tobotobo yatekala tiki. Nitikino, anu sipi sipi kai-kiti i i wane wene taneya meku. Nitikulu tokome no litima niki. ");
INSERT INTO wiu_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Anu eni sipi sipi kai-kiti atua poameneya mea kama pomotoane tuku. Nitikuno, padameka anu yono tatonoke odoa moamele toamoko. ");
INSERT INTO wiu_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Eni yene nekeno, talo toano ta wa no metekago Agetaiyo ete yene peya moa patukoa ako kako. Nitane agono yono tatonoke padameka sipi sipi kai-kiti odoa moamele toamoko. ");
INSERT INTO wiu_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Agetaita tone odene wene pia liputakutukoa meko wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Yesuyo nimo okale yatekete e Yu yename i ago wiatoe wa kue wa katekamotokoi. ");
INSERT INTO wiu_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Nitikoli okome Agetai patu kautakoane kakene ele kule epetekoane tikilepa kiwi kakakoane tokounano, edele tokounakaleke no wia tukadete kue katekamotiki-pe-kale ekete ");
INSERT INTO wiu_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","neke epetekoa tokanakaleke pade ne wiadete kue katekamotokoya mena. Nepa pa agomeke Akolali latike okanano, Akolali-pala tea agale eina okanakamoke ne wiadete toko-koli okome ");
INSERT INTO wiu_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","kipa Akolaline yagono-mikiti wane okou wa Akolaliyo akenemo one bokuke wia mekaneya piko. Enipa nimini ukutu-pe. ");
INSERT INTO wiu_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","One agale oa metekale yakane yenepa Akolaline yagono-mikiti wa eni wia mekaneya piko. One bokuke wia mekane agalepa niminimo-kama wia mekane agaleno, padame pademoka oyake katekoa wawamele toamoko. ");
INSERT INTO wiu_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Akolaline mana kaku wane ukulu kime ekete enipa Akolali paya tetepo takake oko wa iki. Nipa Agetaiyo onekele-kama takamotoa takoa moa wetekakale nokou agoke ikino, dekolo iki-pe. ");
INSERT INTO wiu_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Agetaiyo ta wa okale-kitido tagoane toameadekolupa nipa nooke wene tugameamene wane uku. ");
INSERT INTO wiu_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Nipa oneme ta wa okole-kama takama yakeneke uku. Enipa nimini oko wa anu uku agale yakoa moameketeka anu toma yakule-kitike wene tugoa meamene. Nitoa wene tugoa meketepa nipa Akolali noo-pala lipua mekolo nopa one-pala lipuane mekuno wenepa toi wa Yesuyo okale ");
INSERT INTO wiu_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","e Yu yename one wa dekoa moadete wili toa kakoli paka petoa poka. ");
INSERT INTO wiu_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Nitoapa wakapea pome Yodane ue ketoa Yoneyo pegetoa ali atoa ue motokoa kakana lono enika pome mepoka. ");
INSERT INTO wiu_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","One eni pome mepokata ali atoa peya mati nekete ekete Yone einagomepa ipa Akolaline tele patu kautakoane kakene tuku wa padele telekole toamokanake i agonokemo akakana-kama nimini akedeko wa okoi. ");
INSERT INTO wiu_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Nitoapa e ali atoa kainya mati einata einapete Yesuke wene tugakoi. ");
INSERT INTO wiu_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Besani take eya ago Lasarusi one lainatoata Maria Masata-pala meaneya. Einagopa eida yene pia meaneya. ");
INSERT INTO wiu_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Eina yene tane agono lainatoa Masayo padeya ka̱lono taneya Yesuke pekoa yotokatekoa one kawata pinatoa one pineme kogane atoa. ");
INSERT INTO wiu_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Laine ago yeneme tuupitakale one lainatoatame Yesuke agale oa wetekakete ekete Ali Muno neke oya patu piane ago opi yene pia meko wa agale oa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Einago tuko wa akedekoli yatekome Yesuyo okome yene taneya piake tuamoo. One yene tokopa ali atoame Akolali kei pimotoa tokome toko. Ni Akolaline mana no one patu kautakoane kakene tokoule enekete noka kei pimotoa tokome toko. ");
INSERT INTO wiu_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesuyo Masa wamena lainago Lasarusi toa wene mekoa meaneya. ");
INSERT INTO wiu_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Nitaneyake Lasarusi yene pia meko wa akedekoli yatekome one mekata ta takupeta patamotoa pa eida meka. ");
INSERT INTO wiu_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Nititikoa one oya-lawe-pala okome Yudea take wakapea pato-kale ekete ");
INSERT INTO wiu_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","ekee, Tikisa ago nepa ikonona pakedopa ne wiadete Yu yename kue katekamotokoina take wa poade oko-pe-koli okome ");
INSERT INTO wiu_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","e̱eno, pou toe. Ta pataka abuna lou nome kakome yateta matai teteponome wa keika ponome kakala toko. Nipa lou pini tuku kakoa (12) ponokala toko. Enipa nimini ukutu-pe. Panago loyo yawa mekomepa lou pa̱ enoa yakome tugala toamoko. ");
INSERT INTO wiu_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Nitameneya yomiyomu keneke yawa mekomepa one poka ka ludu pa̱ takatekoya toamokolo tokome tugala toko wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Nimo ootokoa kakome okome tone oyago Lasarusipa pa atu pitikome tokono, kamotokapuku-kale ");
INSERT INTO wiu_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","one oya-laweme ekete atu pia meapa one weneme latoa poademe toko wa okoi. ");
INSERT INTO wiu_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Nipa Lasarusi tukome toka wa Yesuyo okome okoyake o yename wene toamekete okoi. ");
INSERT INTO wiu_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Nitikoli Yesuyo keleyo okome okome Lasarusi tukome toka. ");
INSERT INTO wiu_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","No ita nepiane mekakoa einago tukome tokano, ke wane wediane meku. Nipa kiwi nooke wedoa wene tugamotoane tekene wete poameneya nepiane mekuno, opi one tuaneya pikota pato wa okale ");
INSERT INTO wiu_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","eya ago Tomasi one pade ibini Didimasi wa okala tane agome one oya-lawe-pala okome Besani take Yesu-pala tukete tupatono, one-pala opia patoe wa oka. ");
INSERT INTO wiu_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yesu Besani take pome kakome yatekale Lasarusine tigini kota keneke moa piitikaneyake ta tuyono-peta lia patakala toka wa okoimo yateka. ");
INSERT INTO wiu_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Besani taapa Yerusaleme ta liti piane ta. Eni taata pake kilomita tebolo tadiya pianeya. ");
INSERT INTO wiu_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Masa Mariatane lainago tukome tuaneyake ete Yu yene kainya matiyame kini wene epetekadete Besani take tumai menaneya. ");
INSERT INTO wiu_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Yesu noko wa okoimo yakamotokome Masa pome Yesu kotupaneya. Nipa Maria yapu memotoa wawa pome kotupaneya. ");
INSERT INTO wiu_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Nitoa kotua enekome okome Ali Muno nedo ita wete noke meoo tokapa anu anai ago tuamoo toka. ");
INSERT INTO wiu_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","One tuaneya pikoyake neme oa kowitikole-kama Akolaliyo yakoa tokono wene tuku wa Masayo okale okome ");
INSERT INTO wiu_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","neke anai tuake kamoa poo-kale ");
INSERT INTO wiu_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","einatoame okome nimini wini oko. Wipitia ta pataka-pete Akolaliyo tuane ali atoa moa kamotokakalepa anu anai agoka kamoa poo wane wene tuku-kale okome ");
INSERT INTO wiu_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","nopa tuane ali atoa moane kamotokakuya. Ali atoa mea kama pikilepa no patu-kama mea kama piki. Nooke wene tuganeya meki-kiti tuake mea kama poadete tiki. ");
INSERT INTO wiu_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Nooke wene tugoa mea no patu kautakoa kakete mea kama piki-kitipa tua atukileka toamoi. Ina okouna agalepa no i agome nimini oko wa wene toko-pe wa okale okome ");
INSERT INTO wiu_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","e̱eno, winimopa nimini oko. Ali Muno, nepa Keraisu wa papete ibini oa piane ago. Akolaline mana noo wa oa piane ago ne taatekoa nekedeko wa Masayo oka. ");
INSERT INTO wiu_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Nimo oomotokome Masa wakapea wamenatoa Maria mekata ete keneya kakome oi oi ootokoa okome Tikisa ago wete nokome ne noo wa akapa wa wetekakolo nuku wa okaka ");
INSERT INTO wiu_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maria wete kamokoa Yesu mekata noka. ");
INSERT INTO wiu_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yesu Besani take wete nome kawameneya Masayo one kotua enepokata eida pa meka. ");
INSERT INTO wiu_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Maria wete kamokoa pokale enekete one wene epetekadete tumai menane yename pato wa litima nokoi. Nipa laine ago pipane kotake komo opademe toko wa wene pia nokoi. ");
INSERT INTO wiu_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maria Yesu mekata eni nokome one kawane aua pitakome okome Ali Muno anu anai agopa wete tuameneyake nedo ita noke meoo tokapa tuamoo toka wa oka. ");
INSERT INTO wiu_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Nimo ootokoa komo oa kawa ni one-pala opia nokoi Yu yeneka komo oa kawa tokoli enekome Yesu tepe we tokome wene keda mati taneya kakome okome ");
INSERT INTO wiu_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","one tigini maida pipokoi-pe wa okale ekete Ali Muno ne noke enenoo-koli ");
INSERT INTO wiu_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesu komo loboa pitikaka. ");
INSERT INTO wiu_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Nitikale enekete e Yu yename ekete i agopa Lasarusike wedoa wene mekoa meaneya tadekono, enoe wa okoi. ");
INSERT INTO wiu_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Nitoapa padeka-kitame ekete i agomepa eina leneta lianeya meane agono leneta epetekakanano, ina Lasarusi wete tuameneyake noo tokapa oyake tuamomotoo toka wa okoi. ");
INSERT INTO wiu_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesu wa ela mati tokale Lasarusi pipaneta poka. One eni pipaneta kota kabunupa kue makai matiyame ketekaloganeya. ");
INSERT INTO wiu_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yesu eida pome kakome okome kue ete moa pedeka wa okale tuane agono laine Masayo okome Ali Muno einago tuutukaneyake ta tuyono-peta lia patakala taneyano, kotimi too wa okale okome ");
INSERT INTO wiu_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","dekolo oko-pe. Nepa nooke wene tugoa mekepa Akolaliyo padele telekole tokale enoo wane okouna wene kayapeaneya kake oko-pe wa okale ");
INSERT INTO wiu_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","pade-kitame kue ete moa pedekakoi. Nitikoli Yesuyo a tibu enekakome okome Atai anume kowitoane ukule neme wete yakoa tokono, ke wane uku. ");
INSERT INTO wiu_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Anu kowitikule-kama neme yakoa tokono wene tekene uku. Nipa ina ikilepa no i agopa neme moa wetekakale nekedeko wa i oboa kaki yename wene tomotoane tekene uku wa Yesuyo ootokoa ");
INSERT INTO wiu_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","kayo telo okome okome Lasarusi wete kamokoa noo wa okale ");
INSERT INTO wiu_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","tuane agopa one kawa yonota pueme togotapeneya kawa one lene timini pade mamina tigini pa̱atapeneya kawa taneya kamokoa noka. Nitikale Yesuyo e yene-pala okome pa pomotono, togotane pue kekatapeo wa oka. ");
INSERT INTO wiu_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Maria mekata ugu nekene Yu yene kainya matiyame Yesuyo eni tokale enekete tekete oneke wene tugakoi. ");
INSERT INTO wiu_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Nitikolika padeka-kiti Parisi ali-kiti mekoika pekete Yesuyo tokamo i i wa kotukapaneya. ");
INSERT INTO wiu_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Nitikoli yatekete eni Parisi ali-kitameka Akolalike lodo yotokoai tane tobou ali-kitameka ete Kanosolo ali-kiti peya koukoa noe wa agale oa wetekakoli nokoli ekete edele tato patu. Einago Yesuyo telekole toma yakono, ");
INSERT INTO wiu_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","enile toma yamotoa totomedo wakolopa ali atoa peya oneke wene tugoai toi. Nitikolipa Lomane yatename tone tobou losu yapu toto yatene peya-pala wia tadekatapeoi wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Nitikoli Kanosolo ago pade Kayapasi eni malike ako odene mekome Akolalike lodo yotokoai tane tobou agome okome kime nimo ikilepa nateya weneka toamekete iki. ");
INSERT INTO wiu_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","I agodo ali atoa peyake tumotokolopa nipa epetoo. Nitamokolopa Lomane yename toto yatene wia atukakolipa nipa poo wa Kayapasiyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Nimo ikilepa one weneme titia wameneya. Eni malike ako odene mekome Akolalike lodo yotokoai tane tobou ago tokome Akolaliyo wene takane toa oa pianeya. Nipa Yesu Yu yateneke tuatekamo eni oa pianeya. ");
INSERT INTO wiu_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ni Yu yateneke odene tuameneya, Akolaline mana kono-mikiti e ku yatene ta piko peyake pilikolokaneya mekoika Yesuyo toa motokome odeneka koukoa mekatekamoka oa pianeya. ");
INSERT INTO wiu_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Nitaneyake enipete titimoa Kanosolo ali-kitame Yesu wia tukatekoi oi pedoa pima pekeneya. ");
INSERT INTO wiu_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Nitaneyake Yesu Yu yene pakeke keleyo yawameneya ali piamene ta liti Epereime wa ibini akene take pome mepaneya. Nipa one tuku kakoa (12) oya-lawe-pala opia pome mepoka. ");
INSERT INTO wiu_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Einapete edelo ago patukane wa ibini akene toge kiatekoi tigotokale tekete Yu yene kini kini pitikoika kawa a Yerusaleme take penekete eya taneya. Kini losule tekete tigini yono mamina mete eya uele tadakala taneya. Nipa kini wene moa koigakoyapa i koguna wa adeka pikete taneya. ");
INSERT INTO wiu_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","57","Papete eya yene Akolalike lodo yotokoai tane tobou ali-kitameka Parisi yenameka ekete Yesu nome mekata eneketepa toto Kanosolo ali-kiti onamene wa oa tukaneya. One dekoa moadete ni akeneya. Nitaneyake ali atoame Yesu tuku toa kawapa tobou losu yapu pote kakete kini kini yakate tekete ekete ede wene piko-pe. Yesu einagopa togeke noamoko patu, noko patu wa okala taneya. ");
INSERT INTO wiu_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Edelo ago patukane wa ibini akene toge kiatekoi ta pataka ko melepu (6) kakoa ete pimotoa Yesu Besani take Lasarusi mekata pome mepoka. Lasarusi einagopa tuaneyake Yesuyo moa kamotokane ago. ");
INSERT INTO wiu_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Lasarusi mekata Yesuno nee takaketepa Masayo eni nee moa Yesu one oya-laweka lawetekala toka. Lasarusi oneka Yesu-pala nee pikane walaike odeneka opia meka. ");
INSERT INTO wiu_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Eida mekakoa Mariayo padeya ka̱lono taneya mete keneke mekoa aua noka. Eniya motokakome kue peya mati wetekoa motokaneya. Einakeya aua nome Yesuno kawatake pekoa yotokatekoa one pineme kogaka. Nitoa mekale yapu mekoi peyake einakeya ka̱lono tootapeka. ");
INSERT INTO wiu_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Nitaneyake Yesuno oyago pade Yudase Isekariose Yesu wimotoa moa meatekago ko̱ okome okome ");
INSERT INTO wiu_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","ina ka̱lono taneya ete wa topo teketepa kina ege kadukaka ko melepume kadukoa (300) moa ponopene yene tatikoa meamedekoyake i atoame paka pale tadeko wa oka. ");
INSERT INTO wiu_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Nipa ponopene yene mama moamokomeke oka. Yesu one tuku kakoa (12) oya-lawene kue ka Yudaseyo ukoa yakome eni kue kode noma yakeneyame oka. ");
INSERT INTO wiu_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yudaseyo ko̱ oa kakale Yesuyo okome oyakeno wa. Anu tigini kota keneke moa piei tokolo i atoame enakeya pa pikoa kamotono, wa ");
INSERT INTO wiu_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ponopene yenepa enabuna kiwi pakeke mekala tikino, noanupa kiwi pakeke pa tekei mekuno, i atoame enilepa toa kamotamene wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Yesu Besani take nome meko wa okoimo yakamotekete Yu yene peya mati eida obomoa nokoi. Eni nikilepa Yesu odene enadete nokoiya mena. Tuaneyake Yesuyo moa kamotokakanakago Lasarusika enadete nokoi. ");
INSERT INTO wiu_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Nitaneyake Akolalike lodo yotokoai tane tobou ali-kitame Lasarusi oneka wia tukatekoi oi pedoa pianeya. ");
INSERT INTO wiu_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Nipa Lasarusi einagokepa Yu yene kainya matiyame kiwi tewitikoa wawa Yesuke wene tugoa mea litikoli tekete taneya. ");
INSERT INTO wiu_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Podolikama Yesu Yerusaleme wini noademe noko wa okoimo yakamotekete eina toge lobutunekene yene pote ");
INSERT INTO wiu_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","yo tali tewia moa aua Yesu nokaka kotua nokoi. Nitoa kayo oma nekete ekete Akolali kei piatoe. Ali Muno patu kautakoa kama noko ago i noko. I agopa toto Iserele yene lukoa meko agono, Akolali neme pewe wia yopiamene wa kayo oma nokoi. ");
INSERT INTO wiu_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesu eni nikilepa Akolaline bokuke papete oa piane toa taatekakome dogi kai tine pade enoa moa one patu mea noka. ");
INSERT INTO wiu_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Eina papete oa piane agalepa dikoa wia mekaneya piko. Saione take pitiki yene kipala ukuno, yakoe. Opi kiwi lukoa meatekago dogi kai tine patu mea wini nokono, piti moameo wa wia mekaneya piko. ");
INSERT INTO wiu_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Eina papete wia mekapiane toa Yesuyo taatekoa tokale eneketeke one tuku kakoa (12) oya-laweme wene toamokoi. Wa naniko Yesu tukale Akolaliyo moa kamotokatekoa a tibuke one pa̱ teleta tootapeneya mekanata ate aua pome mekakaleka eina oa piane agale wa wene moa pitikoa wene tokoi. Nipa Yesuke dogi kai moa aua nokolo mea pokanapa Akolaline bokuke oneke oa pianele eni taatekakoona wa wene tokoi. ");
INSERT INTO wiu_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Yesupa Lasarusi kota keneke pipaneta pokome ne noo wa kayo oa kamotokakale odeneya kakete enekoi-kitame kini eina enekoinakamo ta piko peyake oa pupitikatapeneya. ");
INSERT INTO wiu_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Nitaneyake Yesuyo eni telekole tokamo yatekoiya tekete Yerusaleme noademe nokata ali atoame patoe wa obomoa kotua pokoi. ");
INSERT INTO wiu_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Nitikoli enekete Parisi ali-kiti kini kini oote tekete ekete ta piko peyake pitiki-kiti one pokoka litikala tikino, totome i ago oyake katekamele toamoko wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Akolali kei pia kowitadete Yerusaleme take toge lobutunokoi yene padeka-kitipa Geriki agale yakoa akene yene. ");
INSERT INTO wiu_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Eni yenepa eya ago Galili ta keneke piko Besaida take opiane ago Pilipi kakata nekete ekete kamo koniyali totopa Yesu enadete oko wa onokoi. ");
INSERT INTO wiu_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Nimo okoli Pilipi pome Ederu opokale Aderu Pilipita pote Yesu opokoi. ");
INSERT INTO wiu_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Nitikoli Yesuyo okome okome Agetaiyo no Ali Yatenane Oyago pa̱ teleta tootapeneya mekounata ate moa kakateko-pete opi toko-la. ");
INSERT INTO wiu_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nimini ukuno yakoe. Witi ku̱ wane deya yapu tateke-kiti kidene pa pikomepa nipa kidene eni pa pioo. Nitatekoyake itonokedo padame moa pitikakalepa keti lomukome ate witoa ku̱ peya mati tukala too. ");
INSERT INTO wiu_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","One kepene mama motokome tukaya wa piti motaneya mekagopa etepea tua poo. Nitameneya one kepene mama moamoko agopa Akolaliyo toa motokale a tibuke mea kama poo. ");
INSERT INTO wiu_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Anu pupu takama poko agopa no litima namene wane uku. Anu pupu takama yako agopa nopala odenekata yatoane ni uku. Anukule takama yaki-kitipa Akolaliyo kiwi kei pia kawoo. ");
INSERT INTO wiu_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Opi anu wene keda tane matiyame kakene ukuno, edemo wane uku patu. Tete metekoi-pete Agetai neme eni tete ete moa pedekamene wane uku patu. O'o mena. Eni tete moadene nokouya tekene enimo wamou. ");
INSERT INTO wiu_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Atai ne pa̱ teleta tootapeneya meke peku laweteka toane tokoule ali atoame enekete ne kei pimotono ta wa Yesuyo okale a tibuke agale ludu nokome okome nitimotoane wete tokouyano, wa lokoane toadene tuku wa oka. ");
INSERT INTO wiu_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Nitikale eida kakoi yene padeka-kitame yatekete ekete tono tadiya witiko-koli padeka-kitame ekete e̱'e mena. Edelo agome tadiya onepala ko okome toka wa okoiyake ");
INSERT INTO wiu_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yesuyo okome einagale ikilepa noanume yakamotoa tokome wamokanano, kime yakamotoa tokome okana-la. ");
INSERT INTO wiu_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Akolaliyo itonoke meki-kiti takoa enoa akateko-petepa opi toko. Itono yopia mekago Setanu Akolaliyo wia litiademe toko. ");
INSERT INTO wiu_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","No dekoa moa ate kamotokakolipa ali atoa peya noanuke limo limo toane mou wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yesuyo nimo ikilepa one tukome toatekaleke okome oka. ");
INSERT INTO wiu_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Nitikale e yename agale topo takakete ekete tone totono bokuke eya wa wia mekanemo oi motekete oko. Mesaia einago taatekoa nokomepa pa mea kama poo wa wia mekapianemo oi motokoo. Nitikoono, Ali Yatenane Oyago yomoke wia dekoa kamotokoi wa wini okopa edemo wa eke oko-pe. Ali Yatenane Oyago te-pe wa yatekoli ");
INSERT INTO wiu_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yesuyo okome kiwi pakeke pa̱pa me me tootokoa poademe toko. Eni pa̱ tokoa kakoka pa yawa-kala kamene. Pa yawa kakoika ta likaya tokolo uku. Yomiyomu keneke yaki-kitipa ka yomiyomume agopa takatapekolo tugama yakili tekene ni uku. ");
INSERT INTO wiu_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Kiwi pakeke pa̱ pa tokoa kakono, eni pa̱ke wene tugoa meamene. Nitiketepa eni pa̱ne mana kono-mikiti latioi wa Yesuyo oka. Yesuyo enimo oomotokome eni yene tewitikoa wawa paigakoa mepoka. ");
INSERT INTO wiu_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","E yene kakakoa Yesuyo enika eni telekole toma yakaleka e yene oneke wene tugamokoi. ");
INSERT INTO wiu_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Nipa Akolaline agale to̱awea akane ago Aisaiayo papete oa piane toa taatekoa tokoi. Eya wa oa pianeya. Ae, Ali Muno totome oa metekoo agale teyo yakoa motaneya patu. Ali Munagome padele padele telekole yametekale teyo enoa motaneya patu wa enilepa wete tane tetepo takoa oa pianeya. ");
INSERT INTO wiu_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Aisaiayo eya waka oa pianeya tokome e yene oneke wene tugamele toamokale pa mekoi. ");
INSERT INTO wiu_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Akolaliyo kini leneta likoa kolotini lupi takoa taneya. Nipa enekoiya enoa moamoa yatekoiya yakoa moamoa tomotoa ni taneya. Enipa oneme uku agale yatekete tekete oneke tepe kolotini pekoa pikete ekete kiwi latekoano ta wa akaya tokolo tuku wa Akolaliyo okolo uku wa Aisaiayo papete wia mekapianeya. ");
INSERT INTO wiu_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Nipa Yesuyo etenane peku noa padele padele telekole tokale Aisaiayo papete enepikome tokome Yesunomo eni wia mekaneya. ");
INSERT INTO wiu_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Asaiayo nimo papete oa pianeyake Yu yenane tobou ali-kiti kainya mati Yesuke wene tuganeya. Nitiketeke eya taneya. Parisi ali-kitame kini losu yapu-kiti oto wa noameamene wa wia litikaya tokale kini Yesuke wene tugakoinakamo witakoa wameneya. ");
INSERT INTO wiu_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Nipa ali atoame kiwi kei pimotadiyano wene wedoa pianeyake Akolaliyo kiwi kei pimotadiyano wene wedoa piameneya. Nitikete kini Yesuke wene tugakoinakamo to̱awea wameneya pa kini luaneya meaneya. ");
INSERT INTO wiu_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yesuyo kayo telo okome okome panago nooke wene tugakomepa nipa no moa wetekaka agokeka wene tugakome toko. ");
INSERT INTO wiu_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Panagome no enekomepa nipa no moa wetekaka ago eni enekome toko. ");
INSERT INTO wiu_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","No itonoke pa̱ tootapeneya nikilepa nooke wene tugoa meki-kiti yomiyomu keneke pa yawa meamomotoane tekene tokou. ");
INSERT INTO wiu_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Anu agale yatekomeke toamokagopa one koiso akoane kibu moamou. Itonoke nikilepa ali atoa takoane enoane akadene nokouya mena. Ali atoa toane moadene tekene ni nokou. ");
INSERT INTO wiu_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","No wawa anu agale yakamoko agopa one koiso akoa ikilepa eyame toademe toko. Wipitia ta pataka-pete anume okouna agalemepa einago koiso akoa oademe toko. ");
INSERT INTO wiu_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Anu oane metekouna agalepa anu weneme titiane wamokouna. No moa wetekakago Agetaiyo anume ekene toatekou toa imo amene, imo amene wa mane oa olaukoa toka. ");
INSERT INTO wiu_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Agetaiyo one totono litia tamene wa ikilepa ali atoa mea kama pomotoa tokome ni oko. Nitikono, agale oane metekilepa oneme amene wa oka toane-kama uku wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Edelo ago patukane wa ibini akene toge podolikama kiadete Yu yename nodokoa meaneya. Nitaneyake Yesu i ta tewitikoane Agetaike poateku tigotoko wa wene taneya meaneya. Eni wene tokome one oya-lawe itonoke mekika kiwike tuou wa wene mekoa meateka kotuke kakoa wene mekoa mea togaka. ");
INSERT INTO wiu_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ta likale Yesu one oya-lawe-pala opia mekome nee nakaka Setanu Saimonane mana Yudase Isekarioseke wete awinome meaneya. Awinome mekome Yesu mone yenane yonoke moa piateka wene moa pitikaneya. ");
INSERT INTO wiu_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Nitaneyake Yesuyopa oneketaiyo padeya padeya peya one yonoke moa piadeko wa wene toa ni Akolali-pala kawane none wa oneke wakapeane puku waka wene toa tokome eya toka. ");
INSERT INTO wiu_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Nee takoa piane walai liti mea kamokakome one tokoo kakene mamina kotokoa pia mamina pade moa tene lutulogoa eya toka. ");
INSERT INTO wiu_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ue nomoa okolo kagonoke pekoa pia one oya-lawene kawake kakene kege kogoa one tene lutane maminame ue kogama poka. ");
INSERT INTO wiu_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Nitoa kogama pome Saimone Pita mekata tugakale Pitayo okome nepa Ali Muno agomeke anu kawake kakene kege kogade toko-pe-kale okome ");
INSERT INTO wiu_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","i takakulepa opi wene toameke okoyake naniko wene toade toko-kale Pitayo okome ");
INSERT INTO wiu_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","nopa pa alino, kawake kakene kege kogamoano, kogamea wa okale okome neke kawake kakene kege kogamokolupa nipa nepa anu oyali toamoo-kale ");
INSERT INTO wiu_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Saimone Pitayo okome Ali Muno nipa anu kawake odene kogameneya, yono wagokeka takake takoa ta-kale okome ");
INSERT INTO wiu_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","panago kege ko̱omotokome one yapu pokomepa one kawake kakene kege odene wa ko̱amedeko. Opi kiwi kege kogatapeneya mekiyake odene agodo abe kogameneya meko wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Nipa one wimotoa moa meatekago i wa wene toopikome tokome odenagodo kege kogameneya meko wa oka. ");
INSERT INTO wiu_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Nitoapa Yesuyo one kotokoa pikana mamina wa moa kawa one mea nokana walai waneke pome mepoka. Nitikome okome kini ina takakoulepa pine i wa wene tiki-pe. ");
INSERT INTO wiu_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Kime nopa Tikisa ago wa oa Ali Muno wa oa tiki. Enipa oa epetekakili uku. Nopa edikane agono, nimini ekete iki. ");
INSERT INTO wiu_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Nopa kini Ali Muno wa oa kini Tikisa ago wa oa tiki agomeke kini kawake kakene kege kogakouna. Nitikouna toa kini kinika kawake kakene kege ete oto wa kogakala tamene wane uku. ");
INSERT INTO wiu_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Kinikile takakounapa nipa kinikile dikoa ete oto wa takakete toatikile adeka piane metekene tokouna. ");
INSERT INTO wiu_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nimini ukuno yakoe. Pupu agome-kiti one tobou ago oyake moa patukamele toamoko. Panagono agale aua yatekako agomeka one moa wetekako ago oyake moa patukamele toamoko. ");
INSERT INTO wiu_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ina okounakale opi wene taneya meki. Eni wene taneya mekete litia tokolipa Akolaliyo pewe witikale kolotine meoino, wedoa litia tamene wane uku. ");
INSERT INTO wiu_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Enipa kiwi peyake ekene wamuku. Kipa anume takoane motokou-kiti kini tepene piki wene tetoane enoane tekene ni uku. Nipa Akolaline bokuke eya wa papete wia mekapianemo taatekoo tokolo ni uku. Nopala opia mekome nee nakagomepa no ne wiou wa kawa tapia witiko wa wia mekapianeya. ");
INSERT INTO wiu_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Enilepa wete taatekameneyake uku. Wa naniko taatekakale enekete ekete ina okana agalepa opi eni taatekakono, onepa i ago wa okana nimini akedeka wa wene toi. ");
INSERT INTO wiu_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Etene nimini ukuno yakoe. Anume moane wetekakolu nokago makutukoa moteketepa nipa nopala dekoa eni makutukoa motekete toi. No makutukoa moteketepa nipa no moa wetekakago-pala dekoa makutukoa motekete toi wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesuyo nimo ootokoa one wa ela mati tokale kakome okome etene nimini ukuno yakoe. Kiwi padame no mone yenane yonoke moa pioo wa okale ");
INSERT INTO wiu_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","one oya-lawe kini kini enete tekete onepa teyo moa piatekoyake oko patu wa okoi. ");
INSERT INTO wiu_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Einata Yesuno oyali pade Yesuno kotomaneke lewikoa meka. Einagopa Yesuno kolotini ago. ");
INSERT INTO wiu_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Einagopa Saimone Pitayo lene lagatikamotokome okome enipa teeke oko-pe wa neme yakoa a wa okale ");
INSERT INTO wiu_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","einago Yesuno kotomaneke lewikoa mekome okome Ali Muno neme teeke oko-pe-kale okome ");
INSERT INTO wiu_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","i nee kugu moane okolo kagonoke uele pitikatekoane laweteku agopa einago eni wa ootokoa moa uele pitikatekoa Saimonane mana Yudase Isekariose ne na wa meteka. ");
INSERT INTO wiu_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Nitikale motokaka Setanu Yudaseke awinaneya. Nitikale Yesuyo okome neke toatekole wete ta wa oka. ");
INSERT INTO wiu_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nitikalepa Yesu-pala walaike opia mekoi-kiti padameka inapa ike oka wa wene toamokoi. ");
INSERT INTO wiu_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Nipa Yudase kini kue ka ukoa yaka ago tokale kini toge kia noateko nee topo toa motokapa wa Yesuyo okoto patu. Ponopene yene auapea padeya-kiti mepa wa okoto patu wa wene pikoi. ");
INSERT INTO wiu_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Nitaneyake Yudaseyo eina nee kugu moa noomotokome wete wititapekome poka. Ta eina lia tagatapeneya. ");
INSERT INTO wiu_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yudase pootokaneyake Yesuyo okome Ali Yatenane Oyago no wipitiane tukule enekete kei piatiki-pete opi toko-la. Ni Akolaline peku noane wipitiane tukule ali atoame enekete Akolalika kei pikala toi. ");
INSERT INTO wiu_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Enilepa pa̱ teleta tootapeneya meko Akolali patu kautakoane kakene tukupa nipa Akolaliyo one pa̱ teleta tootapeneya meku peku noa ta wa no lawetademe toko. Enilepa opii toko. ");
INSERT INTO wiu_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Anu mati deya-kiti kipala me me tootokoane puku. Pokolupa kime no tuku toa kawa teko tokale wawei. Yu yene-pala okouna kipala opi lokoane uku. No poatekuka kiwi oyake namele toamoko. ");
INSERT INTO wiu_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Namele toamokoyake kini wenele toatiki totono opi oane metekuno, yakoe. Kiwike wene mekoane mekene tuku toa kini kinika edikoa wene mekanali yoma pamene. ");
INSERT INTO wiu_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Kini kini wene mekanali yoma pokoile eneketepa peyame no inakagono agale litima tikina wa wene toi. ");
INSERT INTO wiu_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Saimone Pitayo Yesu-pala okome Ali Muno nepa manika poade oko-pe-kale okome no pukuka opi pade ne oyake litia noamoo. Nanikodopa oyake litia noade toko-kale okome ");
INSERT INTO wiu_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ali Muno opi anume ne litiane toamuku wapa dekolo oko-pe. Neeke toane oyake tuadene uku-kale okome ");
INSERT INTO wiu_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","nooke toapa nimini tuade oko-pe. Etene nimini ukuno yaka. Ali ogadame ka̱ wameneka no wini agopa enamuku ago wa no tebolo-peta akoa waoo wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Wene keda taneya meameamene. Akolalike wene tugoa meapa nookeka wene tugoa meamene. ");
INSERT INTO wiu_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Agetaine yapukepa yapu luku peya mati piko. Nile toamokome too tokapa nipa yapu luku peya piamoko wane ou tokake nopa kiwi note meatikita nodokakadene puku. ");
INSERT INTO wiu_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","No pone kini meatikita nodokakatekoanepa wakapeane nekene anu yapu noe wane enemonou. Nipa no mekouta nopala meatoane mou. ");
INSERT INTO wiu_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","No eni take poateku ka kime wene tiki wa Yesuyo okale ");
INSERT INTO wiu_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomasiyo okome Ali Muno ne poke meateko taapa i wa totome wene toamokono, ne poateko ka totome edoa wene tomotoa-pe wa okale okome ");
INSERT INTO wiu_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Agetaike poatiki kaapa no. Akolaline nimini pekupa no. Ali atoa mea kama pikilepa no patu-kama kautakoa kakete tiki. Agetaike ponadetepa padameka no koekoa ponamoino, no yoto pitia namene. ");
INSERT INTO wiu_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nodo wene tekete toi tokapa nipa Agetaika wene toi toka. Nitoi tokake opi titimoa Agetai wene toa one lene timini enoa tiki wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Yesuyo nimo okale Pilipiyo okome Ali Muno neme Atai wa oko agopa yameano ta. Yametekalepa wene keaneya meoo-kale okome ");
INSERT INTO wiu_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","kipala kotona opiane yawane kakounake Pilipi neme no wene toameke oko-pe. Kime no eneketepa nipa Agetaika eni dekoa eneki. Neketai yamea ta wapa edekolo oko-pe. ");
INSERT INTO wiu_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Nopa Agetai-pala lipuane meku. Agetaipa nopala lipua meko. I ukumopa no i agome nimini oko wa wene toamiki-pe. Kipala oane meteku agalepa anu weneme titiane wamuku. Agetai nopala lipua mekome onekele toma pokome oko toane uku. ");
INSERT INTO wiu_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Agetai nopala lipua meko. Nopa Agetai-pala lipuane meku. Eni ukupa no i agome nimini oko wa wene toati wane uku. Kipala i ukumo yakoake no wene toameketeka Akolalinele takama yakuleke nooke wene tugamene. ");
INSERT INTO wiu_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Etene nimini ukuno, yakoe. Nooke wene tugoa meki-kitipa anume toma yakule-kiti kimeka toi. Nipa Agetai mekota pokolu tokome anu toma yakou toa moa patukoa padele padele tubele-kiti toma poi. ");
INSERT INTO wiu_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Anu ibini wedekoa kowitikoile-kama yakoane tou. Nipa agetai patu kautakoane kakene auapekolu tekete ali atoame kee wa one kei pimotoane tekene tou. ");
INSERT INTO wiu_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Anu ibini wedekoa kowitikoile etene yakoane tou wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Yesuyo nimo ootokoa kakome okome kiwi nooke wene mekoa meketepa nipa anume tamene wane okoule-kiti yakoa toi. ");
INSERT INTO wiu_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nitikolipa kini kowitikakolu Agetaiyopa kiwi auapeateka Epetane Yomini kipala opia meemoa pomotoa wetekoo. Niminimo-kama oko Yominike uku. ");
INSERT INTO wiu_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Itono peku noai tiki yename eni Yomini enamoa wene toamoa tekete oyake makutukoa moamele toamokolo pa meki. Nitikiyake anu oya-lawe kime eni Epetane Yomini wene tiki. Kipala opia yawa kiwike awinome mea tokolo tekete ni wene tiki. ");
INSERT INTO wiu_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Kiwi egetiniya kamotoane tewitikoane poamou. Nitamekene kiwi oto wa enemonou. ");
INSERT INTO wiu_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Nani keneya itono peku noai tiki yename anu lene timini wa enamatikiyake anu oya-lawe kime wa enoi. No meane kama pokolu tokome kiwika dikoa mea kama poi. ");
INSERT INTO wiu_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Kipala ina ukule taatekaka-petepa no inakago oneketai-pala lipua meko wa wene toa ni kiwi nopala lipua meko wa wene toa ni no inakago kipala lipua meko wa wene toa toi. ");
INSERT INTO wiu_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Anume tamene wane uku toa yakoa toma poko agopa nooke wene mekoa meko ago eni. Nooke wene mekoa mekagokepa Agetai wene mekoa meoo. Noanuka einagoke wene mekoane meane anu pono yamekala tou wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Nimo okale Yudaseyo yatekome okome Ali Muno itono peku noai tiki yene katekoane kiwi odene pono yamenokala tou wapa edekolo oko-pe wa oka. Einagopa Yudase Isekariose mena. ");
INSERT INTO wiu_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yudaseyo enimo okale Yesuyo okome nooke wene mekoa meko agomepa anume oane meteku agale yakoa too. Nitikalepa Agetai einagoke wene mekoa meoo. Einagokepa Agetai tota note awia menoo. ");
INSERT INTO wiu_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Nooke wene mekoa meamiki yenamepa anume uku agale yakoa toamiki. Eni ukumo yatikinapa anu weneme titiane wamuku. No moa wetekakagome amene wa okamo-kama okala tuku. ");
INSERT INTO wiu_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ina okounapa kipala pa opiane mekene ukuna. ");
INSERT INTO wiu_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Kiwi auapeateko agopa Agetaiyo moa wetekakilepa no patu kautakoa kakome auapemotoa wetekoo. Nitikale awinome mekomepa pademo pademo peya olaukoa ni kipala okouna peya i i wa wene taka taka too. ");
INSERT INTO wiu_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Tepe kolotini mataketikaneya meatiki peku lawetoane puku. Nipa no kilikoane meku toa kiwika kilikoa meamene wane puku. Kini kaua-mikitame pa itono peku lawetane toane lawetamukuno, wene keda taneya meamoa piti wia mitapeamene. ");
INSERT INTO wiu_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Oto wakapeane noadeneke kiwi tewitikoane puku wane okolu kime yatekoina. Nitikoinano, kiwi nooke wene mekoa meadekolipa nipa no i ago one etene mekota pome kapademe oko wa wedia meoi. Nipa oneketai one moa patukoa ako odene meko ago mekota eni pome kapademe toko wa wedia meoi. ");
INSERT INTO wiu_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Kipala ina ukule-kiti wete taatekameneyake opi oane piku. Nipa taatekakale eneketepa enapa i tadeko wa nooke wedoa wene tugamotoane tekene ni uku. ");
INSERT INTO wiu_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Kipala ko okoane piamele toamokolo uku. Itono yopikago Setanu noademe nokolo tekene ni uku. Setanu einago nokoyake oneme no yopiatekole pade toamokolo uku. ");
INSERT INTO wiu_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Eya waneka uku. Ta piko peya pitiki-kitame eya wa wene tomotou. No i ago oneketaike wene mekoa mekono, oneme tamene wa okole-kama toa togako wa wene tomotou. Opi kamoa ika tewitikoa patoane uku wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yesuyo eya wa pedoa okome oka. Etene gerepi po pinepa no. Agetai onepa gerepi po ipe talo toa lati lati tokago. ");
INSERT INTO wiu_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Nooke agetamu toa tatia piko gerepi po yenene ku̱ tuamokolopa talo tokagome te̱ia mitikakala toko. Tatia piko gerepi po yenene ku̱ tukolopa ku̱ wedoa tuma pomotoa tokome a̱eyo wia kakoya te̱ia lati lati toko. ");
INSERT INTO wiu_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Anume oane metekouna agalemepa kini tokoi poanelepa a̱eyo wia kakoya te̱ia waou toa kogoa kiwi wete epetekaneya. ");
INSERT INTO wiu_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Kipa nopala lipua mekolipa nopa kiwi-pala lipuane meou. Po yenenedo pine-pala lipua meamokomepa nipa one weneme ku̱ tuamele toamoo. Kiwika dikoa nopala lipua meameketepa nipa ku̱ tuamele toamokale pa meoi. ");
INSERT INTO wiu_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Gerepi po pinepa no. Kipa po yenene-kiti. Panago nopala lipua mekolo wa no onepala lipuane mekulupa nipa toneta liputakutukoa mekolo einago ku̱ wedoa tuma poo. No ete kamotoa wawa kini tutu wa meketepa kini weneme padeleka toamoi. ");
INSERT INTO wiu_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Talo agome pa yenene te̱ia yawe pitikakolo ala toa kau tootapeko. Nitikolo oboa pia toele pitikakolo toeme napetapeko. Nopala lipua meake wako ago-pala enakale too. ");
INSERT INTO wiu_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Nopala lipua mea kiwi olaukakouna tepene moa mekoa tokolipa kini wene litia kowitikoile-kama Akolaliyo yakoa too. ");
INSERT INTO wiu_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Kipa ku̱ wedoa tuou toa mea epetekakolipa ete-kitame no inakagono peku kime nakedikino, ke wa Agetai kei pikala toi. ");
INSERT INTO wiu_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Agetai nooke wene mekoa meko toane kiwike wene mekoane meku. Kiwike wene mekoane mekene pawe toane talo toa memotoa tekete nopala lipua meamene. ");
INSERT INTO wiu_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Agetaiyo ta wa oko toane takama yakilepa agetai nooke wene mekoa mekome pawe toa talo toa memotoane tuku. Ena toa noanume tamene wane uku toa kime takama yaketepa nipa kiwike wene mekoane mekene pawe toane talo toane memotoa tekete toi. ");
INSERT INTO wiu_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Kipala i ukupa no wediane meku toa eni yano kakoa kiwi wedia mea kadukama pomotoane tekene ni uku. ");
INSERT INTO wiu_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Eya tamene wane uku. Kiwike wene mekoane meku toa kini kini wene mekanali yoma pamene. ");
INSERT INTO wiu_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Panago one oya-laweke wene wedoa mekoa mekomepa nipa one oya wateaneya kamotoa oneka wiamene wa ketekako. Eni wene mekoa mekome tokolepa padameka oyake moa patukamele toamoko. ");
INSERT INTO wiu_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Anume tamene wane uku toa teketepa nipa anu oya-lawe kakete tiki. ");
INSERT INTO wiu_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Opi titimoane kipa anu pupu yene wane wamuku. Pupu agomepa one pupu pinagonole takakilepa pinagono tepene piko wene tetoa enamokome tokolo tekene ni uku. Opi kipa anu oya-lawe wane uku. Nipa Agetaiyo no peku laweteka toane kiwi lawetekouna tekene ni uku. ");
INSERT INTO wiu_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Kipa kini weneme no takoa moa litikoina mena. Noanume kiwi takoane motokouna. Nipa kawa kawateko ku̱ wedoa tuma pomotoane tekene takoane motokouna. Ku̱ wedoa tuma pokolipa nipa anu ibini wedekoa kowitikoile-kama Agetaiyo yakoa too. ");
INSERT INTO wiu_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Kipala ina okounapa kini kini wene mekanali yoma pamene wane ekene okouna. ");
INSERT INTO wiu_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Itono peku noai tiki-kitame kipala kotimi yoa meadekolipa nipa nopala namolo kotimi yoa mekoina toa tiki wa wene taneya meamene. ");
INSERT INTO wiu_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Anu oya-lawe kime itono peku noai tekete toi tokapa eni yename kipa kini yagono-mikiti wa kiwike wene mekoa meoi toka. Nitoi tokake kipa kini yagono-mikiti mena wa kotimi yoa meki. Nipa eni yene pa kamotoane wawane anu oya-lawe kipa anu wane takoane motokouya tokome kipala kotimi yoa meki. ");
INSERT INTO wiu_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nitikino, kipala papete eya wane okouna wene taneya meamene. Pupu agome-kiti one yopikago oyake moa patukamele toamoko wane okouna. Nipa pade ali atoame noodo tete meteketepa naniko kiwika dikoa tete mekala toi. Ni anu agaledo litia teketepa kini agaleka yakoa moi wane okouna. ");
INSERT INTO wiu_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Kipa anu oya-lawe tokale tekete kipala kotimi yoa mea tete mekala toi. Enipa no moa wetekakago wene toameneya mekete ni toi. ");
INSERT INTO wiu_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","No none eni yene-pala ko wamou tokapa nipa i yename poanele tikilepa wene toamekete tokoino, nami wiane kibu moateku toa mena wane ou toka. Nitou tokake no none olaukakoumo yatekoiya tekete ae poanele tikilepa wene toamekete tokoo wa kini wa kei piamele toamoko. ");
INSERT INTO wiu_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Dikane yename nota kotimi yoa meketepa nipa Agetai-pala dekoa kotimi yoa meki. ");
INSERT INTO wiu_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Kiwi pakeke padame namolo toamokoinakale ele kule telekole toamou tokapa nipa kini poanele tikilepa wene toamekete tokoino, nami wiane kibu moateku toa mena wane ou toka. Nitou tokake ele kule telekole tokoule eneketeke Agetai tota-pala kotimi yoa meki. ");
INSERT INTO wiu_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Nipa nopala kotimi yoa mekilepa pa puputua tiki wa kini totono bokuke papete wia mekapiane toa taatekoa tiki. ");
INSERT INTO wiu_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Kiwi mama moa auapeateko Epetane Yomini Agetai-pala opia mea kako ago taatekoa nokome no ko oademe toko. Niminimo-kama oko Yominike uku. Eni Yomini anu oya-lawe kiwike awinome memotoane wetekakolu Agetai mekata mea noo. ");
INSERT INTO wiu_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Anu oya-lawe kimeka no ko oma poi. Nipa Akolalinele titiane takakouna-pete laigoa nopala opia yakoina tekete ni toi wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Yesuyo nimo ootokoa kakome okome kipala ina okounapa nooke wene tugoa meake tewitikoa wakaya tokale okouna. ");
INSERT INTO wiu_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Yu yename kini losu yapu-kiti oto wa noameamene wa kiwi wia litikala toi. Wa naniko kiwi wia tukaketepa kini Akolalinele takaku wa wene pia wia tukakala toi. ");
INSERT INTO wiu_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Nipa Agetai tota wene toamekete tekete nitoi. ");
INSERT INTO wiu_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Eni toatekoile taatekoa tokoli eneketepa ena okana eni taatekako wa wene tomotoane tekene ni papete oane piku. Akolalinele titiane takakouna-pete enimo wamokouna. Nipa kipala pa opiane meadene mekene tekene wamokouna. ");
INSERT INTO wiu_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Papete wamokounake no moa wetekakago mekota wakapeane poateku tigotokolo tekene enimopa opi to̱aweane uku. Nitikuyake ne manika poade-pe wa padameka wamiki. ");
INSERT INTO wiu_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Enimo ukulu yatekete kini wene keda mati taneya kaki. ");
INSERT INTO wiu_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Nimini ukuno yakoe. Kiwi tewitikoane pikilepa kiwi auapeou wane tuku. Kiwido tewitikoane poamokolupa nipa kiwi mama moa auapeatekago noamoo. Kiwi tewitikoane pekenepa nipa kiwi mama moa auapeateko ago kiwike awinomotoane moane wetekou. ");
INSERT INTO wiu_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Nitikolu nokomepa Epetane Yominiyo eya too. Itono peku noai tiki-kitame kini tikile epetekoa tokoo wa wene pikoinake poanele tekete tadeko wa wene tomotoa too. Ni ki̱yotokoa mekete toatekoleka ni Akolaliyo ali atoa takoa enatekoleka kime wene toko wa wene pikoinake wene toamekete tadeko wa wene tomotoa too. ");
INSERT INTO wiu_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Nipa no Keraisuke wene tugamadete waketepa epetekoa tokoo wa wene pikoinake ae poanele tekete tadeko wa itono peku noai tiki yename wene tomotoa too. ");
INSERT INTO wiu_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ni no inakago wene ki̱yo wameneya meane ago tetepo takakilepa paya wene pia tekete tadeko waka wene tomotoa too. Nipa Agetai mekata wa ate wakapeane pokolu tokome anu oya-lawe kime anu lene timini wa enamoi tokolo tokome nitoo. ");
INSERT INTO wiu_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ni no koiso akoa eketepa epetekoa tokoo wa wene pikoinake Akolaliyo itono yopia mekago Setanuka koiso wete akoa okome tadeko wa itono peku noai tiki yename wene tomotoa too. ");
INSERT INTO wiu_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Kipala pademo pademota oane meatekuyake opi kime oyake yakoa moamele toamoko. ");
INSERT INTO wiu_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Niminimo-kama oko Epetane Yomini nokome niminimo-kama i i wa wene taka taka too. Nipa one weneme pademoka titia wameneya one yatekamo-kama to̱awea oo. Padele padele nani toatikileka i i wa to̱awea oo. ");
INSERT INTO wiu_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Nitoapa no nakouna peku kime noa tomotoa tikilepa ali atoame no kei pimotoa tokome too. ");
INSERT INTO wiu_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","No nakouna peku kimeka noa tomotoa Epetane Yominiyo too wane okouna. Nipa Agetaiyo onekeya peya nekeno yopiamene wa one peku no lawetekale tekene ni okou wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Yesuyo nimo ootokoa kakome okome one lene timini enamatiki tigotoko. Wa nani keneya one lene timini kime wa enoi wa okale ");
INSERT INTO wiu_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","one oya-lawe padeka-kiti kini kini yakaate tekete ekete one enamatiki tigotoko wa oa wa nani keneya one lene timini kime wa enoi wa oa toka. Oneketaike puku waka okanano, edemo wa okome okoto patu wa ootokoa ekete ");
INSERT INTO wiu_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","tigotoko wapa edemo wa okome oko patuno, totome wene toamoko wa okoi. ");
INSERT INTO wiu_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","One oya-laweme one pitia yakadete okoli Yesuyo enekome okome no enamatiki tigotoko wane oane wa nani keneya anu lene timini kime wa enoi wane oane tokounapa edemo wane ekene uku patu wa kini kini yakate tekete ikino, ");
INSERT INTO wiu_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","nimini ukuno yakoe. Kiwi komo ue u̱u keneya ka̱ua okoa kamotoake ete yene wedia meoi. Nitikolika kiwi wene keda taneya meake wa naniko kolotine meoi. ");
INSERT INTO wiu_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Atoame-kiti one mati pene opiademe welea mekome wene keda taneya meko. Nitoake naniko one mati opia pikomepa mati opiane pikuno wene tokome wene yaapekale meoo. Nipa one namolo motokana tete wene kayapetapea wedia meoo. ");
INSERT INTO wiu_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Kiwi mekete tikileke mati kakene atoa adeka pikene uku. Opi wene keda taneya mekiyake wa kotuane enekolupa wene yaapekale kolotine meoi. Wene yaapekale eni mekoile padameka oyake kautoa agopa takamoi. ");
INSERT INTO wiu_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Kipala ina ukule taatekoa toka-petepa kime no padelekeka pitia yakatiki toa mena. Etene nimini ukuno yakoe. Anu ibini wedekoa kowitikoile-kama Agetaiyo yakoa too. ");
INSERT INTO wiu_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Papete padeya mano wa anu ibini wedekoa kowitikileka toamokoinano, opi titimoa padeya mano wa anu ibini wedekoa kowitikolipa Akolaliyo yakoa too. Wedia meatiki kotuke kakoa wedia meadetepa dikoa kowitikala tamene wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Yesuyo nimo ootokoa kakome okome ina okounapa pedoane agale-kama okounano, naniko pedoane agale teigoane wakenepa Agetai ko keleyo to̱aweane ou. ");
INSERT INTO wiu_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Enipetepa Agetai kowitikilepa anu ibini wedekoa kowitikala toi. Nitikolipa Atai kini kowitikile yakoa ta wane wamou. ");
INSERT INTO wiu_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Agetai kiwike wene mekoa mea tokome one weneme kini kowitikoile yakoa too. Nipa anu oya-lawe kiwi nooke wene mekoa mea ni no i ago etene Akolali-pala opia-kama mea nekedeko wa kime wene toa tikili tokome kiwike wene mekoa meko. Nitikono, kini kowitikoile yakoa too. ");
INSERT INTO wiu_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Agetai mekata meane itonoke nokou. Opi itono tewitikoane Agetai mekota wakapeane puku wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Yesuyo nimo okale one oyali-kitame ekete opi pedoa agale wamokono, enipa keleyo to̱awea oko. ");
INSERT INTO wiu_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Padeya padeya peya neme wene tootapekono, tone pitia yakatekomo ne wete yakamokoyake neke weneme to̱awea okono, nepa Akolali-pala opia-kama mea nekedeko-koli okome ");
INSERT INTO wiu_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","ina okounapa no i agome nimini oko wa nooke wene tugakete iki patuno, ");
INSERT INTO wiu_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","pade-kitame kiwi moa tadekakolipa no kidene kamotoa kini kini yapu yapu tadoa pootapeoi. Eni toatiki tigotoma noko. Kime no tewitikoa wakolika Agetai nota opia meoono, anu kidene kawamou. ");
INSERT INTO wiu_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ina okouna oane pikilepa kiwi nopala lipua mekete kilikoa memotoane tekene okou. Itonoke meketepa ke enekakale mea tete-kala moma yawei. Nitatikiyake itono peku noai tiki-kiti noanume wete moane kautakouyano, piti moameneya atiki toa meamene wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesuyo nimo ootokoa tibuke atepea enekakome okome Atai enapetepa opino. Ne pa̱ teleta tootapeneya meke peku lawetekale noane toane wipitiatekule ali atoame enekete no kei pimotono ta. Nipa ali atoamepa nepa dikane ago tadeko wa neka kei pimotono ta wane uku. ");
INSERT INTO wiu_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Atai, ali atoa peya nooke-kama lukoa memotoa teke no moa kakaka tokolo ni uku. Nipa neme takoa moa no metekanakeya peya noanu ne patu mea kama pomotono ta wa no moa kakaka. ");
INSERT INTO wiu_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Atai nepa nimini Akolali. Neke yagono ago pade kakileka toamoko. Neme moa wetekakago Yesu Keraisu no i kakene uku. Ali atoa mea kama pikilepa Atai tota wene taneya mekete tiki. ");
INSERT INTO wiu_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Neke pa̱ teleta tootapeneya meke peku laweteka toane noane tekenepa nipa ali atoame nepa dikane ago tadeko wa ne kei pimotoane tekene tokou. Ni neke takatekoule i i wa neme yametekana toane peya takakene uku. ");
INSERT INTO wiu_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Atai itono tibuta wete latiameneyake nepala opiane meane kakolu ne pa̱ teleta tootapeneya meke peku lawetekale noane tokouna. Opi ne patu kautakoane kakene enakale wa toane meouno ta. ");
INSERT INTO wiu_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Itono peku noai tiki-kiti katekoa wawa neme takoa moa no metekana ali-kiti-pala neke ibini i wane to̱aweane okou. I ali-kitipa nekeke neme no moa metekale neke agale yakoa litikoi. ");
INSERT INTO wiu_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Yakoa litikete tekete opi eya wa wene tiki. Neme no lawetekana peku peya neeke-kama titiadeko wa wene tiki. ");
INSERT INTO wiu_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Neme no mane oa olaukakana toane i ali-kiti-pala i i wane to̱aweane okolu yakoa motokoi. Nitoapa no nepala opiane meane kawane nekedeku wa wene toa ni nemepa no moa wetekadeko waka wene toa tiki. ");
INSERT INTO wiu_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","I ali-kitane kowitikakene uku. Nipa neme takoa moa no metekana ali-kitane kowitikakene uku. I ali-kitipa neke tokolo ni uku. Nitikuyake pa itono peku noai tiki yenane kowitikakene wamuku. ");
INSERT INTO wiu_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Anukuya-kama neke. Nekeya-kama anu. Anu peku lawetekulu i ali-kitame noa tikilepa ete ali atoame no kei pimotoa tiki. ");
INSERT INTO wiu_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Opi i ali-kiti itonoke pa mekete kamotoane tewitikoane neeke nuku. Atai nepa epetanele-kama tokagono, neme takoa moa no metekana yene neke ibini kautakoa kawa kamotono, pawe toa talo toa kamene. Nipa toneta odene wene piitikoa mekete toko toa anu oya-laweka edikoa odene wene piitikoa memotono ta. ");
INSERT INTO wiu_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Neme takoa moa no metekana oya-lawe-pala opiane yakenepa neke ibini kautakoa kawa kamotoane talo toane mekou. Eni yene talo toma nekenepa atuatekago odene katekaku. Enipa neke bokuke padame papete wia mekapiane toa taatekamotoa einago katea poka. ");
INSERT INTO wiu_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Opi neeke nuku. Anu oyali-kitipa no wediane meku toa kotuke kakoa wedia memotoane tekene itonoke pa mekenepa imo to̱aweane uku. ");
INSERT INTO wiu_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Neme oa metekana agalepa anu oya-lawe-pala to̱aweane akakou. Nitikouyake itono peku noai tiki-kitame i yenepa kini yagono-mikiti mena wa kotimi yoa meki. Nipa noanume itono peku noane toamuku toa anu oya-mikitameka noa toamikili tekete kipala kotimi yoa meki. ");
INSERT INTO wiu_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Nitikili tekene anu oya-lawene kowitikakilepa itonoke meaneya moa a tibuke kakoano ta wane kowitikamukuno, Setanuyo toa potokademe tokale pawe toa talo tamene wane ni kowitikaku. ");
INSERT INTO wiu_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Noanupa itono peku noane toamuku toa anu oya-mikitameka noa toamiki. ");
INSERT INTO wiu_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Neke agalepa nimini pekuno, anu oya-mikitipa takoa moano ta. Nipa neke nimini peku laweteke nitoano ta. ");
INSERT INTO wiu_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Atai nekele takamotoane itonoke moa wetekakana toanepa anu oya-laweme neke agale oa pupitikakamotoane moane wetekakou. ");
INSERT INTO wiu_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Anu oya-mikiti auapeadenepa Atai nekele-kama takou wane ne patu kautakoane kaku. Nipa anu oya-mikitame neke nimini peku noa nekele-kama takama pomotoane tekene tuku. ");
INSERT INTO wiu_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Anu oyali-kitane odene kowitikakene wamuku. Anu oya-mikitame neke agale oa mema pokoli yakoa moa nooke wene tugakoi peyane kowitikakene uku. ");
INSERT INTO wiu_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Eni yene peya odene wene-kama piitikoa memotono ta. Atai toneta liputakutukoa meko toa eni yene peya tota-pala lipua memotamene. Nipa itono peku noai tiki-kitame no inakago neme moa wetekadeko wa wene tomotono nitamene. ");
INSERT INTO wiu_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ne pa̱ teleta tootapeneya meke peku lawetekana toane anu oya-mikiti lawetekala tokou. Nipa toneta odene wene piitakutukoa meko toa kini kinika odene wene piitakutukoa memotoane tekene tokou. ");
INSERT INTO wiu_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Edikoa mekolipa nipa nopa kipala lipuane mekolu nepa nopala lipua meoo. Anu oya-mikiti kini kini odene wene piitakutukoa meatiki kotuke kakoa memotono ta. Nitoa mekoile enekete itono peku noai tiki-kitame eya wa wene toi. Neme no inakago moa wetekadeko wa wene toa ni ne nooke wedoa wene mekoa meko toane anu oya-lawekeka wene mekoane meku waka wene toi. ");
INSERT INTO wiu_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Atai neme takoa moa no metekana-kitipa no wida none meatekuta nopala opia memotoane uku. Itono tibuta wete latiameneyake ne nooke wene mekoa mea teke neke peku lawetekana. Eni peku noane pa̱ teleta tootapeneya meane tokouna toane wida wa meane tokolu anu oya-mikitame enemotoane uku. ");
INSERT INTO wiu_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Atai nepa wene ki̱yo akeneya-kama meko. Itono peku noai tiki-kitame nepa dikane ago wa wene toamikiyake noanume wene tuku. Anu i oya-lawemepa ne dikane agome no moa wetekadekono wenepa tiki. ");
INSERT INTO wiu_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ne ko i i wane anu i oyali-kiti-pala to̱aweane okala tokou. Nitikouno, wa to̱aweane oma pou. Enipa ne nooke wene mekoa meko toa anu oya-mikiti kini kini wene mekanali yoma pomotoane tekene tou. Nipa nopa kipala lipuane meadene tou wa Yesuyo Akolali-pala oka. ");
INSERT INTO wiu_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesuyo Akolali-pala einaka einamo oomotokome pome one oya-lawe-pala Kiderone wa ibini akene ue ketoa poka. Ketoa pome one oyali-kiti-pala yomo olipe ipeke mepoka. ");
INSERT INTO wiu_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yesupa one oya-lawe-pala eni ipeke lugutukoa koukoa mepokale tokome one wiateka oi pedoa pianago Yudaseyo kini eni pokoita wene taneya. ");
INSERT INTO wiu_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Eni wene tokome Yudase eida nikilepa poyo ali-kiti-palaka tobou losu yapu talo tane ali-kiti-palaka koua noka. Nipa Akolalike lodo yotokoai tane tobou ali-kitameka Parisi ali-kitameka moa wetekaneyake nokoi. Neketepa peti tole labota udukoa kibutua lama eya-pala aua nidikoa nokoi. ");
INSERT INTO wiu_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Nitaneyake Yesuyopa onepala toatekoile peya wene toopianeya tokome eni yene kotua pokome yatekome okome te tuku toniki-pe-kale ekete ");
INSERT INTO wiu_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Nasarese Yesu wa okoli okome ni agopa no toko-la wa oka. Eni nokoi yene pakeke Yesu wimotoa moa meatekago Yudase oneka kaka. ");
INSERT INTO wiu_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yesuyopa ni agopa no toko-la wa okaka e yene kutu witimotekete itono aua pitakolokakoi. ");
INSERT INTO wiu_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Nitikoli Yesuyo wa lokoa yatekome okome te tuku toniki-pe-kale ekete Nasarese Yesu-koli okome ");
INSERT INTO wiu_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","ni agopa no toko-la wane okounano, kime no dekoa moadete tuku tonadekolipa nipa anu oyali-kiti pa pomotono toe wa oka. ");
INSERT INTO wiu_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Eni okapa Atai neme moa no metekana yene peya talo toane odeneka katekakile toamuku wa papete oa pikana toa taatekamotoa ni oka. ");
INSERT INTO wiu_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Saimone Pitayo one kepete tue luaneya kakome padago wiou wa witimoa kagome nimini yono lono kapidi pine takoa pitikaka. Einagopa ako odene mekome Akolalike lodo yotokoai tane tobou agono pupu ago. Einago one ibinipa Malakasi. ");
INSERT INTO wiu_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Einagono kapidi pine takoa pitikakale Yesuyo Pita-pala okome neke kepete tue wa ete lua. Agetaiyo no noatekou ue mete keneke mekoa metekilepa no tete moatekolu toka. Eni tete edoane momotoa wamoko-pe wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Poyo yeneka kini tobou agoka tobou losu yapu talo tane ali-kitika enika eni yene peyame Yesu dekoa moa yonotake kapa po kakamotekete ");
INSERT INTO wiu_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Anasi mekata namolo takoa aua pokoi. Anasi onepa Kayapasine natonane etene. Eni malikepa einago Kayapasi ako odene tobou ago mekome Akolalike lodo yotokoai taneya. ");
INSERT INTO wiu_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayapasi einagome Yesu tuatekamo ete Yu yene-pala papete oa pikome okome ali atoa peyake odenagodo tukalepa nipa epetoo wa akene ago. ");
INSERT INTO wiu_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Eya agota Saimone Pita-pala Yesuno pade oyagotapa Yesu aua pokoika litima nokoi. Ako odene mekome Akolalike lodo yotokoai tane tobou agomepa Pita-pala opia noka ago wene tokale tokome einagome Yesu koua ako tobou agono yapu pomale pome mepoka. ");
INSERT INTO wiu_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Nitikalepa Pita akolono kago keteponoke pa nepia kaka. Nepia kakalepa ako tobou agome wene tane ago akolono pokome kago ketepono yopia kaka atoa-pala agale ootokoa Pita enemoa yapu keneke aua noka. ");
INSERT INTO wiu_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Nitikale eina kago yopia kaka atoame Pita-pala okome neka einagono oyali-pe-kale Pitayo okome e̱'e mena wa oka. ");
INSERT INTO wiu_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Niti tokale tokome tobou losu yapu talo tane ali-kitameka poyo yenameka totoi moa koukoa toe yokoa kakete kini yono toe yame yame toa kakoi. Nitikoita Pitaka niti paletoa kaka. ");
INSERT INTO wiu_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ako odene mekome Akolalike lodo yotokoai tane tobou agome Yesu one oya ali-kitikeka one olaukanemo-kitikeka pitia yakoai tokale ");
INSERT INTO wiu_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesuyo okome ali atoane lene makono-kama kakenepa olaukakala tokou. Nipa sinokoke losu yapu-kitikeka Yu yene peyame oboai tiki tobou losukeka kakene olaukakala tokou. Nitoanepa pademoka paigakoane wamokouna. ");
INSERT INTO wiu_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Nitikounano, no edekolo pitia yateko-pe. Anu agale yatekoina yename anu olaukakouna wene tekete tikino, eni yene pitia yaka wa oka. ");
INSERT INTO wiu_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yesuyo nimo okaka one kakaya liti kaka poyago padame Yesu yoname witikome okome tobou ago-pala widikoa wamea wa kikoa okale ");
INSERT INTO wiu_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","okome oane potokadekolupa anu oane potokakoumo i wa a-na. Oane potokameneya nimini akedekolupa no edekale witikato-pe wa oka. ");
INSERT INTO wiu_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Nitikalepa Anasiyo i ago Yesu ako tobou ago Kayapasike aua poe wa one poyo ali-kitike moa metekale kapa po pa kakeneya aua pokoi. ");
INSERT INTO wiu_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Pita one yono toe poto yame yame toa kakaka padame yatekome okome neka einakagono oyali-pe wa okoli okome e̱'e, no mena wa oka. ");
INSERT INTO wiu_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Nitaneyake ako odene mekome Akolalike lodo yotokoai tane tobou agono pupu ago pade Pitayo kapidi pine takoa pitikane agono wamenago einagome Pita enekome okome nepa einakago-pala ena ipe kakale enekouno, nimini ukutu-pe-kale ");
INSERT INTO wiu_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pitayo wa lokoa mena wa okaka eina eina ali ogada ka̱ oa kaka. ");
INSERT INTO wiu_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Yu yename Kayapasine yapu tewitikoa pote kini ta talo toa meane ago Pailasene yapu Yesu-pala aua pokoi. Nipa likonu witia pokoi. Nitoapa edelo ago patukane wa ibini akene toge nee noadete mekete tekete mone Lomane tobou agono yapu poamadete wakoi. Nipa kini kekanele tekete toge nee noamokaya tokale mone yatene agono yapu poamadete wakoi. ");
INSERT INTO wiu_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Nitikolipa Pailase eni Yu yene kakoita akolono pokome okome edeya namike i ago koiso akoa iki-pe-kale ekete ");
INSERT INTO wiu_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","i agopa poane ago toamoo tokapa nipa ne kakota aua noamoo toka-koli ");
INSERT INTO wiu_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pailaseyo okome kini totono piko toa kini pitia yakoatino, aua poe-kale ekete toto Yu yename ali pade oyake pitia yateketeka wia tukamelepa toamoko wa okoi. ");
INSERT INTO wiu_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Nimo ikilepa Yesuyo one tukene toatekoule i wa oa pika taatekamotoa tokoi. ");
INSERT INTO wiu_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Nitikoli Pailase one yapu keneke wakapea pokome Yesu ne noo wa kayo oa motokome okome nepa Yu yene peya lukoa meki tobou ago-pe wa yatekale okome ");
INSERT INTO wiu_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","winimopa neke weneme titia yateke oko-pe. Ete-kitame no ko okoimo yakoa teke pitia yateko-pe-kale ");
INSERT INTO wiu_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pailaseyo okome nopa Yu ago wene pike oko-pe. Beita, neke Yu yenameka Akolalike lodo yotokoai tiki tobou ali-kitameka ne dekoa moa nooke aua nikino, neme edele tokake tikiti-pe-kale okome ");
INSERT INTO wiu_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","noanume itono talo tukuya mena. Noanumedo itono talo tekene tou tokapa Yu yename no dekoa moamomotoa tekete anu oya-laweme poi kamotokoi toka. Nitoi tokake pade ta talo tukuya tokolo poi kamotokamiki-kale ");
INSERT INTO wiu_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pailaseyo okome nipa nepa ako tobou ago wa eke oko-pe-kale okome nopa ako tobou ago wa neme wini okona. Nopa ako tobou ago memotoa ni opianeya. Ni nimini peku lawetadene tekene itonoke opiane mati latitapeane nokou. Nimini peku noai tiki-kitame anu agale yakoa motiki wa okale Pailaseyo okome ");
INSERT INTO wiu_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","nimini peku wapa edemo wa eke okoto patu. Pailaseyo Yesu-pala nimo ootokoapa Yu yene kakoita akolono wakapea pokome okome i agopa one wiane tukatekule pade piameadekono, ");
INSERT INTO wiu_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","eya wane uku. Malike-kama edelo ago patukane wa ibini akene toge kikoi-pete kini totono litiane po yapu pitane ago pade po kotokoane wetekakala tukuna. Opi kiwi Yu yenane ako tobou ago po kotokoane wetekamotoa iki-pe wa Pailaseyo okale ");
INSERT INTO wiu_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","e Yu yename ete wa kayo telo ekete ekete winago menano, Barabasi moa wetekaka-ye wa kayo okoi. Barabasi einagopa poi kamotokane ago. ");
INSERT INTO wiu_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Nitaneyake Pailaseyopa i ago po wapime wiamene wa one poyo ali-kiti Yesu moa meteka. ");
INSERT INTO wiu_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Metekale one poyo yename kagani kakene po ludu moa makatikoa one wago lobutukakoa ni kikome kiane mamina petene moa kakoa tokoi. ");
INSERT INTO wiu_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Nitoapa one kakata nekete ekete Yu yenane ako tobou ago nepa kawa kamene-ye wa one kabunu kugutukoa wikala tokoi. ");
INSERT INTO wiu_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Nititikaneyake Pailase Yu yene oboa kakoita akolono wa wakapea pokome okome i agopa wiane tukatekule piameadekolo tekene kiwi kakita oto auane nukuno, enoe wa oka. ");
INSERT INTO wiu_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Nitikale Yesu one wago kagani kakene po makai lobutukaneya kawa ni kikome kiane mamina petene kawa taneya akolono witoa noka. Nitikale Pailaseyo e Yu yene-pala okome einakago ino, enoe wa oka. ");
INSERT INTO wiu_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Yesu eida nome kakale enekete Akolalike lodo yotokoai tane tobou ali-kitameka tobou losu yapu talo tane ali-kitameka kayo ekete ekete winago yomo lekaneyake wia dekaka-ye wia dekaka-ye wa kayo okala toa kakoi. Nitikoli Pailaseyo okome one wiane tukatekule piamokono, kini moa yomo lekaneyake wia dekapoe wa okale ");
INSERT INTO wiu_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","e Yu yename ekete i agopa Akolaline mana kaku wa oka. Nimo ikilepa toto Yu yenane totono paya tetepo takakome tokano, tone eni totono litiapa dikane ago wia tukamedeko wa Pailase-pala okoi. ");
INSERT INTO wiu_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Nimo okoli yatekome Pailase pitime tuane matiyame ");
INSERT INTO wiu_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","wa wakapea yapu keneke Yesu kakata nokome okome ne manika kawa noka-pe-kale Yesuyo agale wametekoa pa kaka. ");
INSERT INTO wiu_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Nitoa kakale Pailase okome ne po kotokoane wetekamele toko. Ni yomo lekaneyake wia dekamotoane moane meamele toko. Nepala eni toateku wene toameke teke agale wametekako-pe wa okale okome ");
INSERT INTO wiu_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Akolaliyodo neme enile tomotoa wamokalepa neme nopala padeleka toatekale toamoo. Nikepa wia tukakamotoa no neeke moa wetekakago Kayapasi one eni poanele tokoleme neke i poanele tokole moa patukako wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Nimo okale yakatekoapa Pailaseyo i agopa po kotokoane wetekamedekuno, edoane tuku patu wa wene kibutukoa meka. Nitikale e Yu yename kayo ekete ekete nemedo winago po kotokoa wetekakepa nepa Ali Muno Sisane oyali toamoko. Ako tobou ago meku wa okagopa Sisa luku tobou ago kawou wa okome oko. Nimo okagopa agopa Sisa-pala poi te̱iane ago tadeko wa okoi. ");
INSERT INTO wiu_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Nimo okoli yakatekoa Pailaseyo Yesu akolono aua pokomepa koiso yopikome meateka walaike witipitoa meka. One eni pome mekatapa kue yaupea tatianeya piko poma wa ibini ikiya. Iberu agalekepa eni pomapa Gabasa wa ikiya. ");
INSERT INTO wiu_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Einapetepa edelo ago patukane wa ibini akene toge podolikama kiadete nodokoa meane-pete. Nitane-pete lou matai pene teteponademe tokaka Pailaseyo e Yu yene-pala okome kiwi Yu yenane ako tobou ago ino enoe wa okale ");
INSERT INTO wiu_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","kayo ekete ekete winago aua pa. Yomo lekaneyake wia dekakoano, witika-ye wa kayo okala tokoi. Nitikoli Pailaseyo okome kini ako tobou ago yomo lekaneyake wiane dekakamotoa iki-pe-kale Akolalike lodo yotokoai tane tobou ali-kitame ekete tone ako tobou agopa Sisa odene. Winago mena-koli ");
INSERT INTO wiu_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","yatekome Pailaseyo Yesu yomo lekaneyake wia dekamotoa moa meteka. Nitikale poyo yename Yesu dekoa moa aua pokoli ");
INSERT INTO wiu_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yesuyo one lekane yomo moa aulogoa ali tobou wa ibini akene take poka. Eni ta ibini Iberu agaleke eketepa Gologosa wa ikiya. ");
INSERT INTO wiu_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Eidapa Yesu yomo lekaneyake wia dekaketepa pade alitaka eka okata yomo padetake wia dekakakala tokoi. ");
INSERT INTO wiu_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Nititikaneyake yomo lekaneya munoke dekatekoi pipia Pailaseyo eya wa wia mekaneya. I ago Nasarese Yesupa Yu yenane ako tobou ago wa wia mekaneya. ");
INSERT INTO wiu_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Nipa Iberu agaleke Latine agaleke Geriki agalekeka eina odenemo-kama wia mekaneya. Yesu wia dekanetapa Yerusaleme ta liti piane ta tokome ali atoa peyame einagale enema ponokala tokoi. ");
INSERT INTO wiu_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Nitikoli enekete Akolalike lodo yotokoai tane tobou ali-kitame Pailase-pala ekete i agopa Yu yenane ako tobou ago wa neme wia mekamikinakeya. Eya wa wia mekoano ta. I agome okome onepa Yu yenane ako tobou ago kaku wa oka wa wia mekoano ta-koli okome ");
INSERT INTO wiu_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","eni wiane mekakouna pa taneya kamota wa oka. ");
INSERT INTO wiu_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","E poyo ali-kitame Yesu yomo lekaneyake wia dekatekoa kakete one kakeneya-kiti moa kini-mene kakoi toa tuyonome tatite toa kakoi. Nipa one mamina pade petene mati ete pimotoa tokoi. Eni mamina petenepa lipukile toameneya pa odene petene mati. ");
INSERT INTO wiu_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Odene petene mati tokome poyo ali-mename oote-mene tekete ekete i mamina petene pilite toamatono, tadu toa enatoe wa okoi. Nipa eya wa papete wia mekapiane toa taatekakoi. Anu kakuya-kiti moa tatite toa anu mamina petenepa tadu toa moa tokoi wa panagome wia mekapianeya. Eina wia mekapiane toa poyo ali-mename taatekoa tokoi. ");
INSERT INTO wiu_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Yesu wia dekaneya kaka yomo liti one nine eida kaka. One ninane wamenatoa Kelopasine natono Maria ni Magadala Mariataka eida kakoi. ");
INSERT INTO wiu_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","One kolotini oyago one nine kakaya liti kakale enekome Yesuyo nine-pala okome anuyatoa neke mana wini wa oa ");
INSERT INTO wiu_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ni one oyali-pala okome neka̱ua wini wa oa toka. Nimo oka-pete titimoa one oyagome einatoa-pala one yapu aua pome mekoa talo toa meka. ");
INSERT INTO wiu_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yesuyo nimo ootokoapa padele padele one toatekule toane peya takaku wa wene tokome eya toka. Akolaline bokuke oneke wia mekapiane toa taatekamotoa tokome okome ue nodome tuku wa oka. ");
INSERT INTO wiu_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Eidapa mete pade kou tane gerepi po ku̱ ue kapetaneya pianeya tokome pade ali-mename ue takamoatekoi obi wane moa eni gerepi po ku̱ uele tadamoa yomo isope luduke kakamoa one kabunuke udakoa lawetekoi. ");
INSERT INTO wiu_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Nitikoli Yesuyo mitumotokome okome opa anu toatekule toane peya takaku wa ootokoa one kabe waliketikakome one yomini takoa pomotoa tukome tuka. ");
INSERT INTO wiu_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Einapetepa edelo ago patukane wa ibini akene toge kiadete nodokoa meane-pete Yu yename Pailase mekata pekete ekete eni wia dekane ali-menane kawa pedoa tukoa yomo lekaneyake kitapea momotono ta wa akeneya. Nipa podolikama ko mea pupu toamatekoi-pete ibini akene ta pataka-pete tokome einago-mene yomo lekaneyake pa dekaneya kakoli enekaya kekatekoa ni akeneya. ");
INSERT INTO wiu_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Nitaneyake Pailaseyo moa wetekane poyo ali-mene neketepa Yesu-pala odeneka wia dekane alitane kawata pedekaneya. ");
INSERT INTO wiu_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Nitoapa Yesu wia dekaneya kakata pekete enekoli one wete tuadekale enekete one kawata pedekamokoi. ");
INSERT INTO wiu_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Pedekamekete poyo ago padame one lama moa Yesuno modono lagotoka. Nitikaka eina eina kamate ueta odeneka ponoka. ");
INSERT INTO wiu_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","(Enile tokale enekagomepa one eni enekana to̱awea oka. One to̱awea okamo einapa nimini uku wa einagome wene taneya meko. Kiwika Yesuke wene tugamotoa tokome ni oko.) ");
INSERT INTO wiu_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Enika enile tikilepa Akolaline bokuke papete eya wa wia mekapiane toa taatekamotoa taneya. I to̱aweane uku agopa one tono odeneka pedekamoi wa wia mekapianeya. ");
INSERT INTO wiu_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Enilekepa Akolaline bokuke eya waka wia mekaneya piko. Kini lamame wia lagotokoinakagopa nepikoa piei. ");
INSERT INTO wiu_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Nitaneyake Arimasia take meane ago Yosepe einago Pailase mekata pokome Yesuno tigini mou ta wa kowitipaneya. Eni Yosepepa Yesuno agale litikomeke ete Yu yene piti moa mekome tokome Yesu litiku wa to̱awea wameneya. Einago Yosepeyo Yesuno tigini mou ta wa kowitikale Pailaseyo nipa mopa wa yametekale pokome to̱a moa aua pekeneya. ");
INSERT INTO wiu_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nitoa aua pokaka Nikodimasi koua pekeneya. Einagopa ta lianeya keneke Yesu enepane ago. Einagome Yesuno tigini ka̱lono takatekaya de yomota mire alouta page-pala aua pekeneya. Nipa keda tube mati taneya padeka kapidi kakoa (30) kilo moa aua pekeneya. ");
INSERT INTO wiu_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Nitoa pekete einagotame ake tane mamina yagalogoa kakete Yesuno tigini to̱a moa pianeya. Nitoapa eina ka̱lono taneyata pekoa yotokoa ewetoa togotaneya. Nipa Yu yename tanele taneya. ");
INSERT INTO wiu_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Yesu wia dekaneya kakeneka yamanu pade pianeya. Eidapa tuane ali atoa piai toatekoi kota pene kokapianeyake tuane ago odeneka wete pipameneya. ");
INSERT INTO wiu_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ko mea pupu toamatekoi nodokoa meane-pete tokome Yosepe Nikodimasitame ekete kitau oono, Yesuno tigini wete pipata wa eni kotake moa pipaneya. Nipa one wia dekaneya liti piane kota tokome taneya. ");
INSERT INTO wiu_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Egeme ta pa lianeya keneke Magadala Maria Yesuno tigini pipane kotake nekeneya. Nokome enekale kota kabunu ketekalogane kue petene ete koketekoa piadekale ");
INSERT INTO wiu_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","enemotokome wa wakapea eyagota Pita-pala Yesuno kolotini oyagota mekoita teyapea pokome okome tone Ali Munono tigini kota keneke pianeta pade-kitame moa aua pekete tokoi. One aua pote pipokoika toto agopa toko wa Mariayo opoka. ");
INSERT INTO wiu_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Nitikale Pita-pala Yesuno pade oyagota Yesu piane kotake teyapea pokoi. ");
INSERT INTO wiu_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","5","Nitoa teyapeata pekete padena agome Pita moa patukoa namolo kakoa pome kota kabunuke kakome watekoa eneka. Enekale Yesuno tigini togotane ake tane pue pa pikale enekomeke kota keneke tuapea poamoka. ");
INSERT INTO wiu_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Nitaneyake Pita one naniko nome kota keneke wete tuapea pokome enekale ena ake tane pue eneka. ");
INSERT INTO wiu_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Wago togotane pueka eneka. Enekale tigini togotane pue-pala odeneka piameneya eko keneya ewetaneya pikale eneka. ");
INSERT INTO wiu_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Nititikaneyake kotake namolo kakoa nome kakagoka tuapea pome enekome ipa Yesu kamoa pokome tadeko wa wene toka. ");
INSERT INTO wiu_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Nipa ipa Akolaline bokuke wia mekapiane toa taatekoa tokome tadeko wa einagotame wete wene toamokoiyake toka. ");
INSERT INTO wiu_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Nitoapa Yesuno oyagota kini yapu wakapea pokoi. ");
INSERT INTO wiu_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Nitikakoa Maria ako lono kota kabunu liti pa kakome komo oa watekoa enekale ");
INSERT INTO wiu_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","edelo ago takuta ake tane pue kakeneya mekoli enaneya. Nipa panago Yesuno wago piane luku mea padena ago one kawata piane luku mea tokoli enaneya. ");
INSERT INTO wiu_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Enoa kakale edelo agotame Maria-pala ekete anuyatoa ne komo edekolo oko-pe-koli okome pade-kitame anu Ali Muno moa pekediki. Nitadikiyake one moa pote pipokoika agopa tokolo komo oane kaku wa ootokoa ");
INSERT INTO wiu_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","peketapekome enekale Yesu kakale enaneya. Enekile tokomeke Yesu kakono wene toameneya. ");
INSERT INTO wiu_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Nitikale Yesuyo okome anuyatoa ne komo edekolo oko-pe. Te tuku toko-pe wa okale einatoame i agopa yamanu tokago wa wene pikome okome anuyali nemedo Yesu moa padeka pipadekalepa one moa pikatapa i wa oano ta. One tigini mopouno, yamea ta-kale ");
INSERT INTO wiu_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesuyo okome Maria wa okale peketapekome Labonai wa akeneya. Nipa Iberu agaleke akeneya. Labonai wapa Tikisago wa okome akeneya. ");
INSERT INTO wiu_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Nimo okale Yesuyo okome Agetai mekota wete atepeane poamukuno, adekoa tebekoa kakono, wa. Nitamoano, anu wamene-mikiti mekita eya wa akapoano pa. Agetai kiniketai mekota atepeane wakapeane puku. Anu Akolalike kini Akolalike ate wakapeane puku wa akapoano pa wa oa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Nitikale Maria Yesuno oya-mikiti mekoita pokome okome Ali Muno enoane nuku wa ootokoa kakome okome i ukumopa Yesuyo no enekome okamo uku wa oka. ");
INSERT INTO wiu_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Eina ta pataka-pete egeme ta lianeya keneke Yesuno oyali-kitame ete Yu yene piti motaneya mekete tekete odene yapu keneke kago loko tooketikoa odeneya oboa mekoi. Nitoa mekoika Yesu kiwi pakeke nome kakome okome kilikaketikoa meamene wa ootokoa ");
INSERT INTO wiu_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","one modono one yono tatonotaka enoe wa yameteka. Nitikale one oya-laweme kini Ali Muno enekete kolotini naka matiyame wedia mekoi. ");
INSERT INTO wiu_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Wedia mekoli Yesuyo wa lokoa okome okome kilikaketikoa meamene. Agetaiyo onekele takamotoa no moa wetekaka toane noanume kiwi dikoa Akolaline agale oa pupitikakamene wane wetekaku wa oka. ");
INSERT INTO wiu_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Nimo ootokoa one oyali-kiti mekoi patu poome pukapekome okome Epetane Yomini kiwike awinome memotoane tuku. ");
INSERT INTO wiu_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Nitikuno, ali atoa padekapa kini poanele tokoike Akolaliyo po letu mekakana keetapemotoane uku wa kime takoa okolipa nipa po letu keetapekale nami kawameneya meoi. Wa ali atoa padekapa kini poanele tokoike Akolaliyo po letu mekakana keemotoane wamuku wa kime takoa okolipa po letu keamokale nami kakeneya meoi wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Yesu one oyali-kiti pakeke eni nokalepa one oyago pade Tomasi katekoa meamoka. Einago one pade ibinipa Didimasi. Didimasi wapa wamene-pala odeneka opiane ago wa ekete ikiya. ");
INSERT INTO wiu_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Einago naniko nokale o ali-kitame ekete tone Ali Muno enekoo-koli okome one yono tatonoke pitime wianeta kodo enamoane eni lukuke yono pitikamoane lama lagotane lukukeka yono pitikamoane tokouya tekene Ali Muno kamotadeko wane wamou. Eniledo tekenepa kamotadeko wane ou wa Tomasiyo oka. ");
INSERT INTO wiu_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Wa ta pataka tatono kakoa (7) ponotekaneyake eina toa Yesuno oyali-kiti eni yapu keneke odeneya oboa mekoi. Nipetepa Tomasika eni pakeke meka. Nitoa kago loko tooketikoa mekolika Yesu one oyali-kiti pakeke nome kakome okome kilikaketikoa meamene wa ootokoa kakome ");
INSERT INTO wiu_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Tomasi-pala okome neke kadapi yono i pia anu yono tatono enoa ta. Anu modonokeka neke yono pitikoa ena. Nipa poome toameneya nooke wene tugoa meamene wa okale okome ");
INSERT INTO wiu_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","nipa nepa anu Ali Muno, nepa anu Akolali wa okale ");
INSERT INTO wiu_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesuyo okome Tomasi neme no i eneke teke no i ago kamotadeko wa wini oko. Anu lene timini enameketeke no einago tuake wa kamotadeko wa nooke wene tugoa mekoi-kitipa etene wedia meoi wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesuyo one oyali-kiti kakakoa padele padele telekole toma pokanakamo peya i bokuke wiane mekamele toamokolo padele-kiti tokamo katekoane wiane mekamuku. ");
INSERT INTO wiu_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Nipa i boku wiane mekakilepa Yesu onepa Keraisu wa papete ibini oa piane agono, onepa Akolaline Mana tadeko wa kime wene tomotoane tekene tuku. Nika one ibini patu kautakoa kakete mea kama pomotoane tekene tuku. ");
INSERT INTO wiu_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Naniko Yesu Taibiriase ue mine matanu one oyali-kiti mekoita nokome pono wa yameteka. Nipa enile taneya. ");
INSERT INTO wiu_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Eya ali-kiti Saimone Pita ni wamene-pala odeneka opiane ago Tomasi ni Galili ta keneke piane Kena take ago Nataniele ni Sebedine manata ni Yesuno oyali padeta eida odeneya oboa mekoi. ");
INSERT INTO wiu_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Eida mekome Saimone Pitayo o yene-pala okome nopa mou tagi topada wa okale ekete nipa pato wa ue dipike peapetekoa pote mea ue muke mou tagi topokoi. Nitoapa padeyaka moameneya pa tagi toa ta patakakoi. ");
INSERT INTO wiu_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Nitikolipa ta pene patakaka Yesu ue mine matanuke nome kakalepa one oyali-kitame yuku agopa Yesu wa wene toamokoi. ");
INSERT INTO wiu_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Nitikoli Yesuyo kayo okome okome anu oya-mikiti mou pade motokoi-pe wa okale ekete e̱'e, mena wa okoli okome ");
INSERT INTO wiu_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","kini tagi ka moa nimini yono lono moa pitikoa enoe wa okale eina okana lono moa pitikakoi. Nitoapa mou kedame wa oto lia moamele toameneya. ");
INSERT INTO wiu_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Enile tokalepa Yesuno kolotini agome Pita-pala okome ipa Ali Muno wa oka. Ipa Ali Muno wa okale yatekome Saimone Pita one mamina-mene kotokoa pianeya tokome one tokoo kawateka mamina wa moa kawa uele tigapitaka. ");
INSERT INTO wiu_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Nitikale o yename ue dipike mea tagi ka moume kapetaneya lia aua matanuke nokoi. Nipa ue mine matanu ete keneya (90 mita) pimotoa ue dipike mea pekete uele pitikapokoi tagi ka lia aua nokoi. ");
INSERT INTO wiu_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Nitoa matanuke katepitoa kakete enekoli palawe wane-kiti mou yomo-kitika toe totoike yotaneya pikale enekoi. ");
INSERT INTO wiu_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Nitikoli Yesuyo one oyali-kiti-pala okome kini tagi toa motokoi mou pade-mene takoa aua noe wa okale ");
INSERT INTO wiu_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Saimone Pita ue dipike pome kakome tagi ka tube moume kapea pitaneya lia aua matanuke noka. Eni mou oi moapa ege tebolo-peta kadukoa (153) mou utadeka. Mou kainya matiyame kapetaneyake tagi ka piliameneya. ");
INSERT INTO wiu_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Nitaneyake Yesuyo kiwi-pala okome nee nonoe wa okale peyame ne te-pe wa yakamene piti moa kakoi. Nipa i agopa Ali Muno wa wene tekete ne te-pe wa yakamokoi. ");
INSERT INTO wiu_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Nitikoli Yesu toele nee pikata pokome palawe wane-kiti moa tatikoa mouka moa tatikoa toka. ");
INSERT INTO wiu_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Nipa Yesu tukale moa kamotokatekaneyake one oyali-kiti pono tebolo takoa yametekilepa enile tokome toka. ");
INSERT INTO wiu_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Nee nootokoa mekoli Yesuyo Saimone Pita-pala okome Yonene mana Saimone i yene nooke wene mekoa meki toa neme moa patukoa nooke wedoa wene mekoa meko-pe wa yateka. Nitikale okome Ali Muno neeke wene mekoane mekuno neme wene toko-kale okome nipa anu sipi sipi kai tine-kiti egetekamene wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Nitoa wa lokakome okome Yonene mana Saimone ne nooke wene mekoa meko-pe wa okale okome Ali Muno no neeke wene mekoane mekuno neme wene toko wa okale Yesuyo okome anu sipi sipi kai-kiti egetekamene wa oka. ");
INSERT INTO wiu_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Nitoapa tebolo takakome okome Yonene mana Saimone ne nooke wene mekoa meko-pe wa yateka. Yesuyopa ne nooke wene mekoa meko-pe wa tebolo takakome okamoke Pita wene keda taneya kakome okome Ali Muno neme pademo pademo peya wene tootapekono, neeke wene mekoane mekuno weneka toko-kale okome anu sipi sipi kai-kiti egetekamene. ");
INSERT INTO wiu_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nimini ukuno yakamene. Ne tuali mekepa neke matio moa kaamotekepa neke wene ponoka toa yakala toka. Nitikala tokoyake ne ada mekepa neke yonota lido ootapea kakale panagome lutua tau toologoo. Nititikoapa ne poamateka lono moa aua poo wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Eni okapa ali atoame Akolali kei pimotoa tokome Pita tukome toatekaleke okome oka. Nimo ootokoa kakome okome no litima namene wa oka. ");
INSERT INTO wiu_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Yesuyo nimo okale Pita peketapekome enekale Yesuno kolotini agome litima nokale eneka. Einagopa Yesuno ete oyali-kiti-pala opia nee noa mekome Yesuke ete lewikakome okome Ali Muno ne wimotoa moa meatekago te-pe wa yatekanakago. ");
INSERT INTO wiu_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Einago enekomepa Pitayo Yesu yatekome okome i ago-palapa edele toko patu wa okale ");
INSERT INTO wiu_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesuyo okome wakapeane nokoluka i agodo pa mea kamotou wane wene toopikolupa neke pupu menano, no litima namene wa Yesuyo oka. ");
INSERT INTO wiu_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Yesuyo nimo okamokepa one agale yakoa motane yene pitikoika eya wa oa pupitikaneya. Einagopa tuamoo wa oa pupitikaneya. Yesuyo nimo pade wa wamokake taneya. Eya wa oka. Wakapeane nokoluka i agodo pa mea kamotou wane wene toopikolupa neke pupu mena wa Yesuyo Pita-pala oka. ");
INSERT INTO wiu_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Einago Yesuno oyagome enika enimo peya i i wa to̱awea oa i bokuke koukoa wia mekoa toka. One eni to̱awea okamopa niminimo-kama akedekono wene totome toko. ");
INSERT INTO wiu_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesuyo padele padeleta toma yakamo peyado bokuke wia mekaketepa boku peya mati wia mekama poo. Nitikolopa eni boku-kitame itono edea takatapeoono wene piku wa i boku wia mekakago no i mekene uku. ");
INSERT INTO wiu_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Anu oyali Tiopilasi, Yesuyo titikome tane-pala wipitikome taneta ni titikome olaukane-pala wipitikome olaukaneta i i wane neke namolo bokuke kabe koukoane wiane mekakakou. ");
INSERT INTO wiu_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Nipa Akolaliyo a tibu pene ate moa aua poameneyake Epetane Yomini patu kautakoa kakomepa one takoa motane Aposelo ali-kiti tamene wa oa tanemoka wiane mekatapekou. ");
INSERT INTO wiu_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Yesuyo tete-kala mootokoa tukale moa kamotokatekaneyake one tuake kamotadeko wa one Aposelo ali-kitame wene tomotoa tokome ele kule toa pono yametekala taneya. Nipa ta pataka padeka noi kakoa (40) ponoka toapa Akolaliyo ali atoa pawe toa talo toko ko-pala oa mekala taneya. ");
INSERT INTO wiu_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","5","Wa padepete one oya-lawe-pala opia mekome nee noa mekome okome Yerusaleme ta tewitikoa poameamene. Agetaiyo kiwi auapeou wa okanakale taatekoa tomotoa eida nepia meamene. Yoneyopa ali atoa pa ue motokama yakoyake Agetaiyopa one Epetane Yomini kiwike awinomotoa moa wetekoo. Kiwike noo wane oane pikolu yatekoina ago awinoateko tigotokono, Yerusaleme tewitikoa poameneya eida nepia meamene wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Wa naniko odeneya koukoa mekete one yatekete ekete Ali Muno tone takepa mone yene yopinaneyano, i taapa pine yene tone yopiatono, mone yene neme litia wetekoa eni luku Yu yene totome yopimono wene piko-pe wa yatekoli okome ");
INSERT INTO wiu_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","padele padele witateko oipa Agetaiyo one wene litia oi pedoa pikala toko. One eni pedoa piko toa kime oyake wene toamiki. ");
INSERT INTO wiu_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Eni wene toamikiyake Epetane Yomini kiwike awinome meoo. Nitikalepa one tele patu kautakoa kakete eya toma yawei. Anume toma yakoule kime enekoinapa ta piko peyake oa pupitikama yawei. Nipa Yerusaleme Yudea Sameria yeka yukuka takeka nitoi wa Yesuyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Nimo okalepa o yename enekakoa Yesu a tibuke moa aua pekeneya. Nipa enekoa kakoli wedome agopa takaneya. ");
INSERT INTO wiu_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Nitaneyake a tibuke nepikoa pikoli ali takuta ake tane mamina kakeneya kiwi kakoiya liti kotikatapea note kananeya. ");
INSERT INTO wiu_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Nitikete ekete kiwi Galili yene a tibu dekolo pa nepikoa piki-pe. Ina Yesupa ate tibu moa aua pokanakago tibuke pokana toa dikoa wakapea nokale enoi wa edelo agotame akeneya. ");
INSERT INTO wiu_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Nitaneyake Yesuno oya-lawe Olipe-pini tono keti toa Yerusaleme take wakapea pekeneya. Olipe-pini tono Yerusaleme tata pake odene (1) kilomita pianeya. ");
INSERT INTO wiu_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Yesuno oya-mikiti Yerusaleme take eni peketepa ako yapu kini oboai tane yapu pote mepaneya. Eidapa eya ali-kiti oboa meaneya. Pita Yoneta mea ni Yame Aderuta mea ni Pilipi Tomasita mea ni Batolomiu Matiuta mea ni Alepiasine mana Yame mea ni Saimone one pade ibini Selote wa ibini akene ago mea ni Yamene mana Yudase mea taneya. ");
INSERT INTO wiu_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Eni ali peya lugutukoa odeneya oboa mekete Akolali kowitikala taneya. Nipa Yesuno nine Maria ni pade atoa-kiti ni Yesuno wamene-mikiti eni yene-pala koukoa mekete kowitikala taneya. ");
INSERT INTO wiu_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Einapetepa eni yene ege takupeta kadukoa wa lene kolo kakoa (120) ali atoa koukoa mekoita kini lene makono Pita kamokoa kakome okome ");
INSERT INTO wiu_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","anukameyo kipala ukumo yakamene. Papete Epetane Yominiyo wene takakale Depidiyopa Yudaseyo toatekamo Akolaline bokuke wia mekapianeya. Yesu wimotoa moa metekanakagoke uku. Einago Yudaseke papete wia mekapiane toa taatekamedekale taatekoa toka. ");
INSERT INTO wiu_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yudase einagopa Yesuyo onekele takamotoa takoa motokale toto-pala opia yakona wa Pitayo akeneya. ");
INSERT INTO wiu_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Yudasepa one toka poaneleke kue mootokoapa itono pade topo toa motaneya. Nitoapa aka mati kawa pitakale tepe kolotini to̱okolokaneya. ");
INSERT INTO wiu_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Eni tanemo Yerusaleme take mekoi peyame yakatapeneya tokome eni itonopa Akeledama wa ibini akeneya. Akeledama wapa lokeyo itono wa ekete akeneya.) ");
INSERT INTO wiu_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Enilekepa Pitayo okome okome lo akene bokuke eya wa wia mekaneya piko. Einagono itonopa tumu tokaneya pimotono, odenagoka eida meamomotono toe wa wia mekapianeya. Eya waka wia mekapianeya. Einago pupu luku panagome tomotato wa wia mekapianeya. ");
INSERT INTO wiu_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Eni wia mekapiane toa taatekoa taneyano, einago luku eya ago moa kakato. Ali Muno Yesu toto-pala opia yaka toa-kama kagekama yakanakago pade takoa moa kakato. ");
INSERT INTO wiu_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Nipa Yoneyo ali atoa ue motokama yakale laigoa toto-pala opia yawa ni Akolaliyo Yesu tibuke ate aua pokaleka pa kagekama yawa tokanakago pade Yudase luku moa kakatoane uku. Yesu tukale Akolaliyo moa kamotokakale enekoonakamopa dikane ago pade toto-pala yakome oma pomotoane tekene ni uku wa Pitayo akeneya. ");
INSERT INTO wiu_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Nitikale nitato toe wa ootokoa ali takutane ibini takoa akeneya. Panagopa Yosepe, Basabasi waka ibini akeneya. One pade ibinipa Yasasi. Padena agopa Mataiasi. ");
INSERT INTO wiu_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Einagotane ibini takoa oa Akolali kowitikete ekete Ali Muno ali peyane tepene wene pikolepa neme lekoa enamele tokono, neme takoa motokagopa i wa totome wene tomotono ta. ");
INSERT INTO wiu_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Yudase one poatekata poademepa Aposelo ago mea Yesunole takoake wakanano, one luku panagome Yesunole takakome memotoono, neme mainago takoa motoko-pe wa kowitoa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Nitoapa einagono ibini moadete gutu lua kea mea Mataiasine ibini i tadeko wa enoa einago moa kakaneya. Nipa ali tuku melepu kakoa (11) ali-kitipa Aposelo ali-kiti wa akene toa einagoka Aposelo ali wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pedikose wa ibini akene ta patakalepa Yesuno oya-mikiti peya odeneka oboa meaneya. ");
INSERT INTO wiu_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Nitikoika a tibuke pupulege mati u̱u oa kawa nekene tetepo tootapekome eni yene odeneya koukoa mekoi yapu lobutua tagatapeneya. ");
INSERT INTO wiu_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Nitikale eni yene ete oto enete tokoli toe itipono keneya kini kini tobouke tete tete toa pitakolokakale enaneya. ");
INSERT INTO wiu_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Epetane Yomini kiwike awia tagatapekome wene taka taka tokale ta padeka padeka yakoa akene agale-kitike pademo pademo oa kakala taneya. ");
INSERT INTO wiu_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Einata einapete ta piko peyake mea Akolalinele wedoa takama yakene Yu yene Yerusaleme take toge kikoa mekoika note oboa meaneya. ");
INSERT INTO wiu_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Eni u̱u okamo yatekete eni Yu yene eida eni u̱u okata obomoa pote kapaneya. Pote kakete yatekoli Yesuno oya-mikitame e yene kini kini take mekete yakoa akene agale-kitike Akolalinemo oa kakoli yatekete wene kainya pianeya kakeneya. ");
INSERT INTO wiu_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Nitoa ka̱ oa kakete ekete i yene peyapa pa Galili yenameke ikino, ");
INSERT INTO wiu_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","tone tone ta-kitike mekete yakoa oko agale-kitikepa okala tikili totome yateko. Edoa wene toa iki patu. ");
INSERT INTO wiu_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Totopa eya ta-kitike kawa nokoya wa kini kini ta ibini takoa okala taneya. Pasia ni Midia ni Ilame ni Mesopotemia ni Yudea ni Kapadosia ni Podase ni Esia ");
INSERT INTO wiu_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","11","ni Perisia ni Pabilia ni Idipi ni Sairini ta liti piko Libia ni Lome enika eni ta kawa nokoo. Toto padeka-kiti etene Yu yene mea ni padeka-kiti namolo pa yateneke Yu yene-pala lipua mea tokoo. Ni toto padeka-kiti Keriti Arebia tata kawa noko. Totopa ta piko peyake tutu tutu wa kawa noko. Opi tone yakoa oko agale-kitike i yename Akolaliyo tubele toma pokomo i i wa mo wia kakili totome yateko. ");
INSERT INTO wiu_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Nitoa wene kainya pianeya kakete kini kini yakaate tekete ekete opi-la, edele toatekolo iki-pe wa ka̱ oa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Nitikolipa padeka-kitame tea agale kikoa ekete beita ipa gerepi po ku̱ ue noa pia tekete leau oa kakete iki wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","E yename enimo okoli Pita one tuku melepu kakoa (11) oya-mikiti-pala kamokoa kakome telo okome okome no yatene Yu ali-kiti ni i Yerusaleme take pitiki peya kime yatekimopa pine to̱aweane ukuno, wedoa yakoe. ");
INSERT INTO wiu_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Totome gerepi po ku̱ ue nokoa pia tekete leau oa kaki wa kime ikino, opi lou pini 9 kilokokepa totome gerepi po ku̱ ue sisoake edoa moa nokoa pimotoa-pe. ");
INSERT INTO wiu_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Totome pade nitamokoo. Ipa eya ago Yoeleyo papete oa piane toa taatekoa toko. Eya wa oa pianeya. ");
INSERT INTO wiu_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","No Akolaliyopa wipitia ta patateka tigotokale toatekoumo ukuno yakoe. Ali atoa peyake anu Epetane Yomini moane wetekakolu kini tepene lobutua tagatapeoo. Nitikalepa kini mana kono-mikitamepa anu agale to̱awea akoi. Kini tuali-kitamepa pulete keneya padele padele yametekoule enoi. Kini ada yatename pule pitikoita pule enekala toi. ");
INSERT INTO wiu_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Enipete-menepa anu Epetane Yomini anu pupu yeneke moane wetekakolu ali-kitikeka atoa-kitikeka awia tagatapekale anu agale oa pupitikakama poi. ");
INSERT INTO wiu_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","A tibukepa ele kule tubele witakoane itonokepa padele padele telekole witakoane tekene anu tele pine yametekala tou. Nitikolupa kamate yokoa kawa toe nokoa kawa lodome eya kuya peya agopa takoa too. ");
INSERT INTO wiu_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ni lou moa yomiyomu takatapeoo. Tokeneka kamate pagene tetepo taneya kawoo. Nipa Ali Muno pa̱ teleta tootapeneya noateka tigotokale enika enile too. ");
INSERT INTO wiu_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Nitikalepa Ali Muno wa-ye wa kowitikoi peya Akolaliyo toa moo wa Yoeleyo wia mekaneya. ");
INSERT INTO wiu_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Pitayo nimo ootokoa okome Iserele yene kipala i ukumo yakoe. Kiwi pakeke ele kule telekole toma yakanakago Nasarese Yesuke uku. Einagome Akolaline peku noa tadeko wa kime wene tomotoa tokome Akolali patu kautakoa kakome enika enile toma yakana. ");
INSERT INTO wiu_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Akolaliyo papete wene toopiane toa taatekoa tekete Iserele yene kime one-pala eya tokoina. Poane peku nakene yename yomo lekaneyake wia dekakamotoa moa metekoina. ");
INSERT INTO wiu_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Nitikoinake Akolaliyo moa kamotokaka. Nipa wakome labakaneya kawou toa Yesu tuane ali atoa tete mokoa kaki take pome mepaneyake Akolaliyo toa motoka. Eida labaneya kamele toamokale tokome toka. ");
INSERT INTO wiu_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Enilekepa Depidiyo Akolaline bokuke papete eya wa wia mekapianeya. Ali Muno Akolalipa anu lene timini takakoane pikou lono-kama kakale enekou. Anu nimini yono lono kakome no yopikolo tokome padelemeka no toa potokamele toamoko. ");
INSERT INTO wiu_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Nitikono, kolotini nakolo wediane meane ke wane uku. Nipa tukile toatekuyake Akolaliyo toatekole nepiane meane wediane mekene uku. ");
INSERT INTO wiu_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Tuane ali atoa pote meki take anu yomini mea kamotoa neme wawamoo tokolo tekene ni uku. Nipa nekele-kama takamotoa takoa motokago noanu tigini lomumotoa wawamoo. ");
INSERT INTO wiu_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Pa meane kama poateku kaapa i wa neme no wete yamepikana. Nopala odenekata opia yakilepa nipa wediane meane tagamotoa teke too wa Depidiyo papete wia mekapianeya. ");
INSERT INTO wiu_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Pitayo nimo ootokoa okome anukameyo tone kaua Depidi-loeke eya wane ukuno, yakoe. Einago tua pokale oloyo taneya. One oloyo tane lukupa tone take pa pia kakeneya. ");
INSERT INTO wiu_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Einagomepa Akolaliyo toatekamo papete to̱awea wia mekapikala taneya. Nitane ago-pala Akolaliyo eya wa akeneya. Neeke ta̱wateka ago pade ne luku ako odene mekome ali atoa pawe toa talo toa kawoo wa oa togotaneya. Akolaliyo nitoo wa Depidiyo wene tokome eya taneya. ");
INSERT INTO wiu_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Akolaliyo toatekale papete enepikomepa Keraisu moa kamotokatekamoke eya wa wia mekapianeya. Einagopa tua pekene ali atoa pitikoika mea kamotoa Akolaliyo wawamoka. One tigini lomumotoa wawamokome moa kamotokaka wa Depidiyo wia mekapianeya. Nipa enile wete tane tetepo takoa wia mekapianeya. ");
INSERT INTO wiu_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Eni wia mekapiane toa Akolaliyo taatekakomepa ina Yesu wete moa kamotokaka. Enipa toto peyame leneme enekoomo uku. ");
INSERT INTO wiu_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Einagopa Akolaline nimini yono lono ate moa kakaneya kakome opi eya toka. Oneketaiyo one Epetane Yomini ne meou wa papete oa togotopikana toa taatekoa metekale moapa one Epetane Yomini toto mea tagatapeka. Nitikale tone tepene lobutua tagatapekolo tokome totome imo oa ika ile tokolo kime yakoa enoa tiki. ");
INSERT INTO wiu_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Depidi-loe a tibuke wete poameneyake eya wa akeneya. Ali Muno Akolaliyo anu Ali Muno-pala eya wa oka. Nepala poi te̱ia meki yenepa moane kawikoane neke kawane komo pikouno, anu nimini yono lono nooke menamene wa oka wa Depidiyo wia mekapianeya. ");
INSERT INTO wiu_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Iserele yene kiwi peya-pala eya wane ukuno, yakoa moe wane uku. Ina Yesu kime lekane yomoke wia dekakoinapa Akolaliyo moa Ali Muno wa oa Keraisu wa oa kakaka wa Pitayo akeneya. ");
INSERT INTO wiu_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Pitayo nimo okale yatekete e Yu yene tepe tebemo tebemo toa kakeneya. Nitoapa Pita-pala ete Aposelo ali-kiti-palaka ekete ame-loe poanele eni tekete tadeko. Tone toatekole agopa tokono, edele tomotoa iki-pe wa okoli okome ");
INSERT INTO wiu_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","kini poanele toma yakoinake Akolaliyo po letu mekakanapa keetapea poanele wia mitikakamotono, kini poanele tewitikoa Yesu Keraisu patu kautakoa kakete ue moamene. Nitikolipa Akolaliyo one Epetane Yomini metekale kiwike awinoo. ");
INSERT INTO wiu_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Akolaliyo one Epetane Yomini meou wa papete oa togotokomepa kiwika kini mana kono-mikitika ta tetemada pitikoi yeneka metekene meou wa oa pianeya. Nipa tone Ali Muno Akolaliyo one takoa moa kayo oateko yene peya one Epetane Yomini meademe oko wa Pitayo e Yu yene-pala akeneya. ");
INSERT INTO wiu_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Nitoapa e yene mama motokome pademo pademo okome okome i take poane peku lawetane yenepa kini poanele toma yakoike Akolaliyo kibu moono, eni poanele tokoi yene-pala odeneka dekoa kibu motokaya tokolo pilia wawati wa Pitayo pubu oa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Enika enimo oa kakale ali atoa kainya matiyame yakoa moa ue motaneya. Nipa eina ta pataka-pete ege egeta kadukoa (3,000) ali atoa tadiya Yesuno yatene-pala lipuaneya. ");
INSERT INTO wiu_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Eni yenamepa Aposelo ali-kitame olaukane toa litima pekete odene wene piitikoa koukoa mekala taneya. Nitoapa palawe wane popimoa moke toa noa Akolali kowitoa tokala taneya. ");
INSERT INTO wiu_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Aposelo ali-kitame telekole toma yakoile enekete peyame ka̱ oa kakete ekete Yesuno tele patu kautakoa kakete tadiki wa okala taneya. ");
INSERT INTO wiu_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Yesunomo yakoa motokoi peyapa odeneya koukoa mea kinikiya ete oto wa tatikamu taneya. ");
INSERT INTO wiu_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Nipa kini oya-lawe padeya toamokale enekete kini itono eya topo toa kue moa moke toa mekala taneya. ");
INSERT INTO wiu_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Nitima pekete ta pataka abuna tobou losu yapuke obopokala taneya. Nitimotekete kini yapu-kiti obopekete palawe wane popimoa moke toa nokala taneya. Nipa kolotini nakale odene wene-kama pianeya mekete taneya. ");
INSERT INTO wiu_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Nitoa mea Akolali kei pia kakoli enekete ete peyame ke ke wa kiwi pewe wiai taneya. Nitikakoa Ali Munoyo ta pataka abuna ali atoa toa moma pokomepa one yatene-pala moa lipukoai taneya. ");
INSERT INTO wiu_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Wa pade-pete lou wegoukaka (lou pini 3 kilokoke) Pita Yoneta tobou losu yapu pekeneya. Nipa Yu yene tobou losu yapu pote kowitoai tane-pete pekeneya. ");
INSERT INTO wiu_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Nitoata pekete enekoli kawata lepo taneya opiane agopa one oya ali-mename tobou losu yapu kago ludu mekadete leyo leyo toa aua ponokoli enaneya. Ta pataka abuna koniyo kago wa ibini akene kagoke tuapea tobou losu yapu ponokoi yenaneke kue oia mokala tomotoa eida aua pote mekoai taneya. ");
INSERT INTO wiu_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Eina mekoai taneta Pita Yoneta tobou losu yapu lobutadete tokoli enekome einagome kue mano wa okale ");
INSERT INTO wiu_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pita Yonetame einago nepikakete Pitayo okome tota nepikamene wa okale ");
INSERT INTO wiu_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","padeya mouno wene pikome nepikaneya. ");
INSERT INTO wiu_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Nitikale Pitayo okome silepa kue golo kueka toamokoyake padeledo ne auapeane touno, ");
INSERT INTO wiu_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Nasarese Yesu Keraisu patu kautakoane kakene ukuno, kamokoa pa wa ootokoa one nimini yono moa katekamotokale eina eina one kawata one kawa lamenetaka tele tootapeka. ");
INSERT INTO wiu_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Nitikale tigoa kamokoa kakome opi yamele toko wa yakeneya. Nitoa Pita Yoneta-pala tobou losu yapu opia pome Akolali kei pia tigawineya pekeneya. ");
INSERT INTO wiu_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","10","Nitima pokale enekete peyame ekete ekee i agopa tobou losu yapu koniyo kagoke-kama mekome kue oia mekanakagono, ke ke wa one-pala tokanakaleke ka̱ oa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Pita Yonetame latekakoinakagomepa einagota yono mokoa kakaka ali atoa wapokamoa pote unukamoa kakeneya. Nipa Solomono wa yomini kayo oa ibini akene lono ka̱ akeneya teyapea pote kakeneya. ");
INSERT INTO wiu_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Nitikoli enekome Pitayo e yene-pala okome Iserele yene anu oya-lawe edekolo wene kainya pianeya kakete tota lene wikoa kaki-pe. Totame Akolalinele wedoa takama yakete tekete i agopa tone teleme kamotokakoono wene pikete tiki-pe. Tone teleme pade latekamele toamokoyake ");
INSERT INTO wiu_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Akolaliyo latekaneya. Nipa one patu-kama kautakoa kako ago Yesupa ali atoame kei pimotoa tokome taneya. Tone kaua-mene Eberame Yekobeta Aisake toa yopikoa kako Akolalike uku. Eni Yesupa Pailaseyo pitia yakakamotoa kime aua pote mepokoina. Nitikoli pitia yakatekoa i ago po kotokoane wetekou wa okake Yu yene kini Yesu tumotono wene pikete wakoina. ");
INSERT INTO wiu_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Nipa Akolaliyo one wa takoa moa kakapikago Yesu wene ki̱yo akeneya-kama mekago eni wakoina. Nitoapa ali-kiti wia tukakala tane ago Barabasi po kotokoa wetekaka-ye wa okoina. ");
INSERT INTO wiu_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Nitoapa ali atoa poome mekoa wene takoa latikagopa kime wia tukakoli tua pokanake Akolaliyo moa kamotokakale kamoa poka. Enipa Yone totame enekoomo uku. ");
INSERT INTO wiu_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ina kawata lepo taneya mekanakago kime i enoa wene tiki agopa Yesuno ibinike wene tuganeya tokome weye akatapeneya. Nipa Yesuno ibini wedekoa one patu kautakoa kakete latekatapeneya kime eni enekina. ");
INSERT INTO wiu_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Ame-loe Yesu einakago wia tukakoinapa kimeka kini tobou ali-kitameka wene toamekete tokoinano wene tekene uku. ");
INSERT INTO wiu_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Einapa Akolaliyo wene takane toa one agale to̱awea akane ali-kitamepa Keraisuyo tete moa tuatekamo papete wia mekapikala taneyano, kime Yesu wia tukakilepa Akolaliyo papete wene toopiane toa taatekakete tadiki. ");
INSERT INTO wiu_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Nipa kini toma yakoi poanele Akolaliyo moa kogamotono, kini namolo poane wene wia wawe. ");
INSERT INTO wiu_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Nitikolipa Ali Munoyo kiwi weye akoa pewe wia too. Nitoapa kiwi auapeou wa one takoa moa kakapikanakago eina Yesu wa lokoa oto wetekoo. ");
INSERT INTO wiu_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Nitatekoyake papete Keraisu a tibuke nepia meoo. Nipa Akolaliyo one agale papete to̱awea akane ali-kiti wene takakana toa taatekakome one namolo latikanakeya peya weneya latimotoa Keraisu a tibuke nepia meoo. ");
INSERT INTO wiu_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moseseyo einago Keraisuke papete eya wa oa pianeya. Kini Ali Muno Akolaliyo one agale to̱aweane akamotoa no moa kakakana toa naniko kini wamene ago pade one agale to̱awea akamotoa moa kakoo. Nitoono, einago taatekoa nokome toe wa okale-kama tamene. ");
INSERT INTO wiu_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","One nokome oka toa yakoa moamokagopa Akolaliyo one yatene pakeke katekoa atukoo wa Moseseyo oa pianeya wa Pitayo e Yu yene pubu okome akeneya. ");
INSERT INTO wiu_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Nimo ootokoa kakome okome totome ipete taatekoa toatekoomopa eya ago Samueleyoka to̱awea oa pianeya. One eina to̱awea oa piane toa Akolaline agale to̱awea akane ali peya lokama nekete akeneya. ");
INSERT INTO wiu_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Kini papete to̱awea akapianele ni Akolaliyo kiwi yatene auapeou wa kini kaua-mikiti-pala papete oa togotaneleka kime pikoa kakete opi taatekakolo enoa yakoa tiki. Enipa Eberame neeke ta̱amoa pokoi ali atoake tekene e ku yatene ta piko peyake ta̱ma pote mekoika talo toane pewe wiou wa Akolaliyo Eberame-pala oa togotopiane toa taatekoa tokoleke uku. ");
INSERT INTO wiu_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Akolaliyo papete oa togotopikana toa taatekakomepa onekele-kama takama pokago kiwike namolo takoa moa wetekakana. Nipa kini toma yaki poanele tewitikoa wawe wa kiwi pewe wia kamotoa moa wetekakana wa Pitayo akeneya. ");
INSERT INTO wiu_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pita Yonetame e Yu yene-pala pa ko oa kakoika Akolalike lodo yotokoai tane ali-kitika tobou losu yapu talo tane yene yopikagoka Sadusi yeneka einagota kakoita nekeneya. ");
INSERT INTO wiu_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Nipa Yesu tua pokome wa kamoa pokale tokome ali atoaka tua potepa wa kamoa poi wa einagotame olaukanemoke kotimi yoa tekete nekeneya. ");
INSERT INTO wiu_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Nitoa einagota dekoa motekete ekete opi ta wete likono, kini koiso podolio akato wa po yapu pitikapaneya. ");
INSERT INTO wiu_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Nitaneyake einagotame okoimo yakane yene peya matiyame kini okoimo yakoa motaneya. Nitaneyake Yesunomo wete yakoa motane yene-pala eni yene kibutukoa oi moapa ali-kama takoa oi motokoli ege egeta wakala kadukoa (5,000) kakedekoi. ");
INSERT INTO wiu_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Podolikama Akolalike lodo yotokoai tane ako tobou ali-kiti Kanosolo ali-kiti Yu yenane totono pine to̱a olaukane ali-kiti enika eni ali peya Yerusaleme take odeneka koukoa meaneya. ");
INSERT INTO wiu_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ako odene mekome Akolalike lodo yotokoai tane tobou ago Anasika one wamene-mikitika Kaiapasika Yone Alesadataka eida koukoa meaneya. ");
INSERT INTO wiu_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Eni yename Pita Yoneta kini lene yoto moa kakoa pitia yatekete ekete kitame abela tokoinakalepa tene tele patu kautakoa kakete tokoiya-mo. Tene ibini wedekoa epetekakoiya-mo wa okoli ");
INSERT INTO wiu_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Pita one tepene Epetane Yomini lobutua tagatapeneya kakome okome tobou ali-kiti Kanosolo ali-kiti kipala i ukumo yakoe. ");
INSERT INTO wiu_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Kawata lepo taneya mekanakagopa Yone totame auapea epetekakoopa edoa epetekakoiya-mo wa kime tota pitia yatekino, ");
INSERT INTO wiu_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","kipalaka Iserele yene peya-palaka eya wane ukuno, yakamene. Kime yomo lekaneyake wia dekakoli tuaneyake Akolaliyo moa kamotokane ago Yesu Keraisuno ibini wedekaneya tokome i ago kini leneke latekatapeneya kako. ");
INSERT INTO wiu_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yesu einagokepa Akolaline bokuke eya wa wia mekaneya pikono, yakoe. I yomopa poadeko wa yapu wiane yene kime paya tetepo takoa wakeneyake panagome i yomopa yapu pigi wa moa wianeya wa wia mekaneya piko. ");
INSERT INTO wiu_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ta piko peya pitiki ali atoa toa motokagopa einago odene. Pade lokoaka mena. Kiwi toa momotoa one ibini wedekoa oatiki agopa einago odene wa Akolaliyo one ibinipa Yesu wa akeneya wa Pitayo akeneya. ");
INSERT INTO wiu_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Nimo okale yatekete e yene oote tekete ekete i agotapa pa agotano, mane mane pine pitia yakoa luamene agotameke piti toamokolo kakete imopa i ikino, einakago Yesu-pala opia yakoi agota tadeko wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Nitoapa einagotame latekane ago kita-pala opia kakale enekete tekete pademoka ete topo takoa wameneya. ");
INSERT INTO wiu_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Nitoapa einagota Kanosolo yapu meaneya moa akolono wetekatekoa pedoa pikete ekete ");
INSERT INTO wiu_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","i agota-pala edele tato patu. Padele telekole ina tokoi. Ae, kini ina tokoimopa Yerusaleme take pitiki peyame yakatapekete tikino, kauatiyake oyake kauamele toamokono, ");
INSERT INTO wiu_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","eya tato. Kini ina tokoinakamo ta peyake oa pupitikaya tokolo einakago Yesuno ibini patu kautakoa kakete odene agoka wa pade olaukameamene wa ato wa oa tukaneya. ");
INSERT INTO wiu_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Nitoapa oto noe wa Pita Yoneta kayo oa motekete ekete einakagono ibini patu kautakoa kakete pademoka wa pade olaukoa wameamene-koli ");
INSERT INTO wiu_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pita Yonetame ekete Akolaline leneke kawapa totame edele tomotoa iki-pe. Kini wene litia tomotoa iki-pe. Akolaline wene litia tomotoa iki-pe. Kini takoa oe-na. ");
INSERT INTO wiu_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Totame pade tone leneme enoa kaleme yakoa tokoomo kauameneya to̱awea oo wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Nitikoli Kanosolo ali-kitame einagota wa kikoa ootokoapa poe wa wetekaneya. Nipa edele toa kibu moo wa wene kibutua mekoiyake ete ali atoa peyame einagotame tokoinakaleke Akolali kei pia kakoli tokome kibu moamele toameneya pa poe wa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Mali padeka noi kakoa (40) ponoka toa pa lepo taneya meane agoke latekakoiya tokome ete peyame ke wa Akolali kei pia kakeneya. ");
INSERT INTO wiu_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Kanosolo ali-kitame kita wete poe wa wetekakoli Pita Yoneta kini oya-mikiti mekoita pata wa pekete Akolalike lodo yotokoai tane tobou ali-kitameka Kanosolo ali-kitameka kita kikoa okoinakamo to̱awea opaneya. ");
INSERT INTO wiu_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Nitikoli yatekete kabunu kokotukoa ekete tone Ali Muno Akolali tibuka itonoka kusa ueka enika eniyake meki peya neme latikoya. ");
INSERT INTO wiu_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Nitikago neme to̱awea okana toa Epetane Yominiyo wene takakale tone kaua ago Depidi-loe nekele takama pokagome eya wa wia mekapianeya. E ku yatenepa tepene poto witoa kotimi yotaneya mea tikilepa edekolo tiki-pe. Ali atoamepa pata pale toatiki oi pedoa pikilepa edekolo tiki-pe. ");
INSERT INTO wiu_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ta piko peya ako tobou meki-kitame poi kamotokoa ni kiwike lokoa tobou meki-kitameka Ali Muno-pala one Keraisu-palaka poi topato wa poi kibutuai toniki wa Depidiyo wia mekapianeya. ");
INSERT INTO wiu_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Eina wia mekapiane toa etene taatekadeko. Nipa nekele takama pomotoa takoa moa kakapikago Yesu itonoke nokale Erode Podiase Pailaseta pa yatene-kiti-pala Iserele yatene-palaka koukoa mekete one wia tukatekoi oi pedoa pikoina. Tone i Yerusaleme take koukalogoa nitikoina. ");
INSERT INTO wiu_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Enile tokoinapa Akolali ne tele tootapeneya meke wene toopikanakale taatekoa tokoina. ");
INSERT INTO wiu_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Eni yename toto tete meatekoi agale a̱moa okoinano, neke pupu yene toto piti moameneya kakete nekemo atiki toa akoono, auapeano ta. ");
INSERT INTO wiu_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Nipa nekele takama pomotoa moa kakanakago Yesu one ibini patu kautakoa kakete yene tane ali atoa latekoa ele kule telekole toma poono, auapeano ta wa kowitoa meaneya. ");
INSERT INTO wiu_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Nitoa kowititikoa mekoli kiwi oboa mekoi yapu muku muku tootapekale Epetane Yomini kiwike awia tagatapeneya. Nitikale peyame Akolaline agale i i wa piti moameneya kakete to̱awea akaneya. ");
INSERT INTO wiu_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Yesunomo yakoa motane yene peya odene wene-kama pianeya meapa kinikiya-kiti anukuya mati wa wamato, odeneya pikoa mekete moke tato wa tatikala taneya. ");
INSERT INTO wiu_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Aposelo ali-kitamepa padele padele telekole toma yakete Ali Muno Yesu tua pokale Akolaliyo moa kamotokanemo wedoa oma yakoli Akolaliyo pewe-kama wia yopia kakeneya. ");
INSERT INTO wiu_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Nitaneyake Yesuno ali atoa ponopeneya mekileka toameneya. Nipa itono pine yenameka yapu pine yenameka kini itono yapu eya topo toa kue moomotekete ");
INSERT INTO wiu_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Aposelo ali-kitike aua pokala tokolipa padeya toameneya pa mekoi ali atoa moke toa tatikakala taneya. ");
INSERT INTO wiu_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Saiperase take Lipai yatene ago Yosepeyo einakale taneya. Einagopa Aposelo ali-kitame Banabasi wa ibini akeneya. (Banabasi wapa ali atoa wene weye akakago wa ekete akeneya.) ");
INSERT INTO wiu_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Einagome one itono pade topo toa kue moomotokome Aposelo ali-kiti mekoita aua pome meetapeneya. ");
INSERT INTO wiu_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Pade ago Ananaiasiyo one natono Sapaiara-pala oi pedoa pikana toa tokome itono pade topo toa kue moapa kue padeka te̱ia moa one wa pa pikoa pianeya. ");
INSERT INTO wiu_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Nitoapa keku kue Aposelo ali-kiti mekoita aua pome mepaneya. Nipa kue peya aua nome metane tetepo takoa taneya. ");
INSERT INTO wiu_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Nitikale Pitayo okome Epetane Yomini-pala kapene wakake kue padeka te̱ia moa pikoa piake peya iya auane nuku wa wini okopa Setanuyo eni poane wene edekale moa lukamotoa toka-pe. ");
INSERT INTO wiu_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Eni itono wete topo toameneka nekeya-kama pianeya. Nipa eni itonome topo toa motoka kue peya pa pikoane meada wa wene pioo tokapa itonoka kueka nekeya-kama tokome oyake pikoa kawoo toka. Neke kapene wakateka oipa edeyake pedoa pikato-pe. Neme kapene wakoa ikilepa pa ali-kiti toto-pala wamoka. Akolali-palapa oka wa Pitayo okale ");
INSERT INTO wiu_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","yatekome eina eina one kakata aua witipitakome tuaneya. Nitaneyake einago-pala tanemo yatekoi peyame ekee wa piti tuuloganeya meaneya. ");
INSERT INTO wiu_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Nitaneyake tuali-kiti nekete tukanakago katekamoa maminame ewetemotekete aua pote oloyo topaneya. ");
INSERT INTO wiu_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Lou pini tebolo tadiya ponotokaneyake natonoka onekane-pala tanemo yakameneya atiki toa nekeneya. ");
INSERT INTO wiu_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Nokale Pitayo yatekome okome kini itonome topo toa motokoi kuepa nekaneyo kotu kakoa aua noka-pe-kale okome e̱eno, eni kue peya aua nokome toka-kale okome ");
INSERT INTO wiu_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Epetane Yomini-pala kapene wakoa enatekoi oipa edeyake pedoa pikoti-pe. Nekane oloyo topokoina tuali-kiti wakapea note a kago ludu kakete ikino, yaka. Neeka dikoa aua pote oloyo topoi wa okale ");
INSERT INTO wiu_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","eina eina natonoka one kakata aua witipitakome tuaneya. Nitaneyake eina tuali-kiti nekete ina atoaka tuadeko wa moa aua pote odene oloyoke lewitikatakutukoa pipaneya. ");
INSERT INTO wiu_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Nitaneyake Yesunomo yakoa motane yename ete ali atoa peyameka enimo yatekete ekee wa pitime tuuloganeya meaneya. ");
INSERT INTO wiu_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Aposelo ali-kitame padele padele telekole toma yakilepa Akolaline tele patu kautakoa kakete tadiki wa ali atoame ka̱ oa kamotoa taneya. Yesunomo yakoa motane yene peyapa tobou losu yapu keneke Solomono wa yomini kayo oa ibini akene lono oboai taneya. ");
INSERT INTO wiu_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ete yename eni yene-pala lipua meadete piti moteketeke ke ke wa kiwi kei pikala taneya. ");
INSERT INTO wiu_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Nitoapa pade ali atoa Ali Muno agoke wene tugaketepa one agale yakoa motane yene-pala lipuai lipuai taneya. ");
INSERT INTO wiu_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Enika enile tanelekepa ali atoame kini yene pitane-kiti moa akolono aua pote ka ludu tomo tatia mekakala taneya. Nipa Pita one yomini takoa ponokale latoa poi wa moa mekakala taneya. ");
INSERT INTO wiu_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Yerusaleme ta liti piane take pitikoi ali atoameka yene pitane-kitika ipono awitaneya mekete tete mokoa kakene-kitika koukotukoa aua nokoli peya epetekatapeneya. ");
INSERT INTO wiu_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Aposelo ali-kitame nitima yakoileke ako odene mekome Akolalike lodo yotokoai tane tobou agomeka one Sadusi oyali-kitameka eya taneya. Ali atoame kiwi tewitikoa Aposelo ali-kiti litiei wa wene poaneya mekete tekete ");
INSERT INTO wiu_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Aposelo ali-kiti dekoa moa po yapu pitikapaneya. ");
INSERT INTO wiu_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Nitaneyake likonu Ali Munoyo moa wetekane edelo ago nokome po yapu kago pea Aposelo ali-kiti akolono aua pokome okome ");
INSERT INTO wiu_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","ali atoa mea kama poatiki totono wenele toatikimo-kama tobou losu yapu pote olaukapamene wa oa pekeneya. ");
INSERT INTO wiu_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Nitikale ta pene patakaka edelo agome oka toa tekete tobou losu yapu pote olaukoa kakeneya. Nitaneyake ako odene mekome Akolalike lodo yotokoai tane tobou agomeka one oya-mikitameka ete Kanosolo ali peya koukoa noe wa moa obokaneya. Iserele Kanosolo ali peya eni koukoa mekete ekete po yapu pitiki Aposelo ali-kiti enemotokapoe wa poyo ali-kiti moa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Nitikoli pekete enekoli po yapu meameadekoli enekete wakapea nekete ekete po yapu kago loko pitikoa keteaneya kakale enekoo. ");
INSERT INTO wiu_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Ni kago yopia kakoina ali-kitame e kago akolono nepikoa kakoli enekoo. Nitoa kago pea enekolo padeka meameadeka wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Nitikoli tobou losu yapu talo tane ali-kiti yopikagomeka Akolalike lodo yotokoai tane tobou ali-kitameka edoa pokoti patu wa wene kibutukoa mekoika ");
INSERT INTO wiu_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","pade ago nokome okome kime moa po yapu pitikakoina ali-kitipa tobou losu yapu kunu kakete ali atoa olaukoa kakina wa onaneya. ");
INSERT INTO wiu_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Nitikale tobou losu yapu talo tane ago one poyo ali-kiti-pala opia pokome Aposelo ali-kiti moa Kanosolo yapu aua nekeneya. Nipa ali atoame kue katekamoa witikaya wa piti motekete tekete poti moa aua nekeneya. ");
INSERT INTO wiu_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Aua note Kanosolo ali-kitane lene yoto moa kakakoli eyago ako odene mekome Akolalike lodo yotokoai tane tobou agome okome ");
INSERT INTO wiu_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Yesunomo wa pade olaukameamene wa totome oa tukakoonake onekemo Yerusaleme take oa pupitikatapeadiki. Nipa Yesu wia tukanepa toto aukakala toa ni iki wa okale ");
INSERT INTO wiu_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pita-loeme ete Aposelo ali-kitameka ekete tone Akolaliyo ta wa okole-kama litia toono, pa ali-kitane wene litiamoo. ");
INSERT INTO wiu_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Tone kaua-mikiti yopikago Akolaliyopa Yesu tuaneya pikata moa kamotokaka. Kime yomo lekaneyake wia dekoa tukakolika moa kamotokaka. ");
INSERT INTO wiu_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Nitoapa ali atoa toa momotoa tokome oneke lokoa Ali Muno latikoa one nimini yono kounoke moa kakaneya. Enipa Iserele yename poanele toma yakoike po letu mekakouna keetapeane waou wa taneya. Nipa tepe kolotini pekoa pikolipa nitou wa taneya. ");
INSERT INTO wiu_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Kipala i okopa Aposelo ali-kiti tone leneme enekoomo oko. Epetane Yominiyoka enimopa wene takakala toko. Akolaliyo one agale litia tiki yeneke awia memotoa wetekane Yominike oko wa Aposelo ali-kitame akeneya. ");
INSERT INTO wiu_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Aposelo ali-kitame enimo okoli yatekete e Kanosolo ali-kiti kotimi wene mati luaneya tekete kiwi wia tukadete akeneyake ");
INSERT INTO wiu_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Kanosolo ago pade Gamaliele wa ibini akene agome eya taneya. Einagopa Parisi ago Mosesene totono pine to̱a olaukakago ete peyame kei piane ago kamokakome okome i ali-kiti akolono tekei meati wa moa wetekoe wa okale ");
INSERT INTO wiu_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","wetekakoli okome Iserele ali-kiti kipala i ukumo yakoe. Ina ali-kiti-pala toateko oipa poti pedoa piato. Kini toma yakilepa kinikile tiki patu, Akolalinele takaki patu. ");
INSERT INTO wiu_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Namolo eya ago Tiudasiyo tube ago i kakuno, noe wa poi kamotokakale ege kadukaka ketepome kadukoa kakoa (400) ali-kiti one lono takoa pokoi. Nitikolipa poi keneke poyo yename einago wia tukakete one agale litia tane ali-kitika wia tadekatapekoi. ");
INSERT INTO wiu_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Naniko Galili Yudaseyo eya toka. Ali atoame takesi kue pitikamotoa kini ibini bokuke wia mekane-pete Yudase kote tokale okome itapa tepe kikono, poada wa ete takoa pokome ali atoaka wia lokoa iyawea aua poka. Nitikale poyo yename einago wia tukakete one agale litia tane yeneka wia tadekatapekoi. ");
INSERT INTO wiu_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","I Aposelo ali-kitipa kini tikile pa kini weneme tadekolipa wete edikoa tadatapeoino, toa kamotono toe. ");
INSERT INTO wiu_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Kini tikilepa Akolali patu kautakoa kakete tadekolipa kime oyake ketekamele toamoo. Nipa Akolali-palaka dekoa poi teigete toi wa Gamelieleyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Nimo okale yatekete ete Kanosolo ali-kitame ekete nitoono ta wa eina Aposelo ali-kiti noe wa kayo oa motekete eya taneya. Layo tiginame wiati wa poyo ali-kiti metekoli witikoli wa motekete ekete Yesuno ibini patu kautakoa kakete onekemo wa pade wameamene wa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Nitikoli Kanosolo ali-kiti mekoita tewitikoa pekete wedikete ekete eina witikoinapa Yesuno ibini wedekoa onekele takakoonakaleke totome oyake ya momotoa Akolaliyo ni tadeko wa pekeneya. ");
INSERT INTO wiu_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Nititikaneyake ta pataka abuna tobou losu yapuka kini kini yapu luduka obopokala tekete Keraisu Yesunomo one epetane ko i i wa oma yakeneya. ");
INSERT INTO wiu_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Einapete-mene ali atoa kainya matiyame Yesunomo yakoa mootokoa one yatene-pala lipuai lipuai taneya. Yesuno yatene eni tubetema pekene-pete Geriki agale yakoa akene Yu yename Iberu agale yakoa akene Yu yene-pala ko̱ oa kakete ekete ta patako abuna nee eya tatia meteketepa tone nepo atoa wanakala tiki wa wene pokete akeneya. ");
INSERT INTO wiu_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Nitaneyake Aposelo ali-kitame Yesuno agale yakoa motane yene peya noe wa moa obokoa mekete ekete toto Aposelo ali-kitame kini nee eya tatikadetepa Akolalinemo olaukoa wamele toamokono, ");
INSERT INTO wiu_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","nee eya tatikamotoapa kini oyali-kiti tatono kakoa (7) takoa moamene. Nipa Epetane Yomini awia tagatapeneya mea epetane peku noa tikileke ete-kitame kei piki ali-kiti takoa moamene. Nitikolipa toto luku kakete nee eya tatikamene wa totome moa kakatekoapa ");
INSERT INTO wiu_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","eni pa pupu wa toameneya Akolali kowitoa mea Yesunomo oma yawa too wa Aposelo-kitame akeneya. ");
INSERT INTO wiu_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Nitikoli peyame ke wa wedia mekete nee eya tatikatekoi ali-kiti tatono kakoa (7) takoa motaneya. Einali-kiti dikoa. Panago Sitipene einagopa Yesuke wedoa wene tugoa meane ago. Eingoke Epetane Yomini awia tagatapeneya. Ni Pilipi ni Perokorasi ni Naikena ni Taimone ni Pamena ni Nikolasi. Nikolasi einagopa Adioke take pa yatene ago meake Yu yene-pala lipuaneya. ");
INSERT INTO wiu_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ete yename o ali-kiti takoa mootokoa Aposelo ali-kiti mekoita aua pokoli Aposelo ali-kitame Akolali kowitoa yono pianeya. ");
INSERT INTO wiu_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Nitaneyake Akolaline agale oa pupitikatapeneya. Yerusaleme ali atoa peya matiyame Yesunomo yakoa mootokoa one yatene-pala lipuai toa kakeneya. Akolalike lodo yotokoai tane ali kainya matiyameka Yesuke wene tugoa mea onekele takama pekeneya. ");
INSERT INTO wiu_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Sitipene einagopa Akolaliyo pewe wia tagatapekale one tele patu kautakoa kakome telekole toma yakale enekete ali atoame ekete padameka toamatikilepa i tokono, enatoe wa ka̱ oa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Nitaneyake Libetine wa ibini akene losu oboai tane ali-kiti Sitipene-pala wene poaneya mekete one-pala agale to̱onali yoa kakeneya. Eni losu oboai tane Yu ali-kitipa eya ta-mene Sairini Alesaderia Silisia Esia enika eni ta kawa nekeneya. ");
INSERT INTO wiu_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Eni yename Sitipene moa patukadete wili toa kawa teko tokale wakeneya. Nipa Epetane Yominiyo wene takakale agale muno pewe kakoa oa kakale tokome one moa patukamele toameneya. ");
INSERT INTO wiu_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Nitoapa kapene wakoa oatekoi ali-kiti tuku toa kawa motekete kue laukakete ekete i agomepa Mosese Akolalitake poane agale okale kime yatekoo wa akoa amene wa kue metaneya. ");
INSERT INTO wiu_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Nitikolipa eina kapene wakoa agale okoli yatekete ali atoaka tobou ali-kitika Mosesene totono pine to̱a olaukane ali-kitika wene pokete kamotokoa Sitipene kakata pote dekoa moomotekete Kanosolo ali-kiti koukoa mekoita aua pekeneya. ");
INSERT INTO wiu_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Nitoapa eina kapene wakoa oatekoi ali-kiti Kanosolo ali-kitane lene yoto moa kakakoli kapene wakakete ekete i agomepa tone Akolaline takoa wikakakoona tobou losu yapukeka Mosesene totonokeka poane agale oma yako. ");
INSERT INTO wiu_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Eya waka okale yatekoo. Nasarese Yesuyopa tone tobou losu yapu ke̱awea tadekatapea ni toto Yu yename litia toateko totono Moseseyo yametane totono katekoa weneya totono yamea too wa i agome okale yatekoo wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Nitaneyake Kanosolo yapu mekoi peyame Sitipene nepikakoli one lene timinipa edelo agono lene timini tetepo tootapekale enaneya. ");
INSERT INTO wiu_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","I agome dika dika wa kapene wakoa okoli yatekome eya ago ako odene mekome Akolalike lodo yotokoai tane tobou agome Sitipene yatekome okome i yename neke tanemo-kala ikino, nimini ikiti-pe-kale Sitipeneyo okome ");
INSERT INTO wiu_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","atai ame-lawe agale pade oane metekuno, yakoe. Tone kauago Eberame Arane take wete to̱a pome mepameneyake one opiane ta Mesopotemia ta pa eida mekalepa pa̱ teleta tootapeneya meko Akolali pono yamenokome okome ");
INSERT INTO wiu_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ne yemeateku take mepoano, nekameyo-mikiti tewitikoa neke ta-pala to̱ano pa wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Nitaneyake one Kaledia ta to̱a pome Arane take mepaneya. Oneketai eida mea tukalepa Akolaliyo wini ta to̱ano pa wa okale tewitikoa kiwi i pitiki take nome menaneya. ");
INSERT INTO wiu_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Einata einapete Akolaliyo one itono nateya dedeyaka yameameneyake okome naniko neeka neeke ta̱amoa pokoi yeneka eni take meo wane mekoane yameou wa Akolaliyo oa pianeya. Eberameyo one mati odeneka wete opiameneyake ni akeneya. ");
INSERT INTO wiu_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Nitikome okome neeke ta̱amoa pokoi yenepa mone take pote mepokoli eni ta pine yename kinikile-kama takamotoa kiwi tika tika toa tete mea toi. Nitikoli mali ketepome kadukoa (400) ponoka toa pa edikoa meku pekete toi. ");
INSERT INTO wiu_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Nitoa mekoli enekene kiwi yopikoa potokakoi yene kibu motokakolupa neeke ta̱ma pokoi yename eni mone ta tewitikoa oto wakapea note mekete anukule takama yawei wa Akolaliyo Eberame-pala oa pianeya. ");
INSERT INTO wiu_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Nitoapa ne yatene auapeouno, dikamene wa oa togotokome one eina auapekome toateka adeka pikome ali yatene kepene teigakete toatekoile yametaneya. Nitaneyake Eberameyo Aisake opia pikome ketepo kakoa (8) ta pataka-pete matiyane kepene teiganeya. Aisakeyoka mana Yekobe opia pikome einakale taneya. Yekobeyoka one ali mati tuku kakoa (12) opikome-kama einakale tokala taneya. ");
INSERT INTO wiu_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Wa naniko tone kaua-mikiti Yosepe-pala wene poaneya mekete eya taneya. Idipi take panagono pupu-kama takamotoa dekoa moa topo toa kue motaneya. Nitaneyake Akolaliyo einago Yosepe mama moa yopikoa kakome ");
INSERT INTO wiu_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","tete motane-pete-kama toa mokala taneya. Nitoapa Idipi ako odene meane tobou ago Perouyo i ago Yosepe wene muno kakene ago tadeko wa wene tomotoa tokome one peku lawetekala taneya. One eni peku noa toma yakale enekome Perouyo one Idipi ta one yapulu yene peya neme yopikoa kamene wa oneke lokoa tobou ago moa mekaneya. ");
INSERT INTO wiu_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Wa naniko Idipi Kenane tatake kobu igi noka matiyame ali atoa kobume tukete welea meaneya. Tone kaua-mikitameka kini noatekoi neepa piamokale tuku tokoa kawa teko tokale wakeneya. ");
INSERT INTO wiu_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Nitoa mekete Idipi take nee pade piko wa okoimo kugu yatekome Yekobeyo one mana-mikiti Idipi take noatekoo nee topo toa mopoatino poe wa wetekakalepa tone kaua-mikiti enipete titimoa Idipi take pekeneya. ");
INSERT INTO wiu_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Wa taku takoapeta Idipi take pokoli Yosepeyo one Yosepe kaku wa one ibini to̱awea akeneya. Nititikaneyake Idipi ako meane tobou agome inapa Yosepe yatene nekete tadiki wa wene taneya. ");
INSERT INTO wiu_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Nitaneyake Yosepeyo etene Yekobe laine wamene-mikiti peya noatino noe wa agale oa wetekakale keti note menaneya. Eina yene kakoi toa oi motokolipa ege odepeta kadukoa wa timini mukitini patukoa padeka pagini (75) kakoa ali atoa kakedekoi. ");
INSERT INTO wiu_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yekobe Idipi take eida nome mea tuaneya. One mana-mikitika eida mea tukala taneya. ");
INSERT INTO wiu_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Tone kaua-mikiti eida mea tukala taneyake kini tigini leyo leyo toa ta pine lono Sekeme take aua pote tuane ali atoa piai tane kotake pipokala taneya. Eina kotapa Eberameyo Emono mana-mikitaneke kueme topo toa motaneya. ");
INSERT INTO wiu_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Akolaliyo Eberame-pala neeke ta̱wateko yatene auapekene ile tou wa papete oa piane agale wete taatekameneyake tone kaua-mikiti Idipi take eida ta̱amoata nekeneya. Wa naniko one einagale taatekateka tigotokalepa ");
INSERT INTO wiu_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Yosepe wene toamene tobou agome Idipi ta yopia meaneya. ");
INSERT INTO wiu_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Einagome toto yatene oa yotokoa talo toa potokaneya. Nipa kini mati-kitipa tumotono, opitikoa paka lono pote pipokala toe wa tone kaua-mikiti tete motokoa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Einapetepa pade adoname koniyo mati Mosese opikete akolono pipameneya kini yapu tokene teboloke pa ukoa mekete adu lawetaneya. ");
INSERT INTO wiu_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Wa naniko akolono moa pikoli Idipi ako tobou agono koname enamutukome one mana mati latikoa tubetekaneya. ");
INSERT INTO wiu_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Nitikalepa Idipi take mane luane-kitame kini peku-mene ya̱amoa lawetekoli noa tokome agale muno kakoa oa padele padeleta wene toa toma pekeneya. ");
INSERT INTO wiu_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Mali timini mukitini patukoa padeka noi kakoa (40) ponokale Mosese one Iserele yeneke ugu pou wa wene pia meaneya. ");
INSERT INTO wiu_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Nitoapa ugu pokome enekale Idipi agome Iserele ago witikale enekome Iserele ago auapekome Idipi ago kibu motokoa wia tukaneya. ");
INSERT INTO wiu_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Nipa one yenamepa no i agome kiwi toa momotoa Akolaliyo moa kakapiadeko wa wene tikino wene pikome taneya. Eni wene pikanake one yatename wene taneya mena. ");
INSERT INTO wiu_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Wa podolikama Mosese eida wakapea pome enekale Iserele agota takuta poita tootakutukoa kakoli enekome okome anu oyata kita wameneta edeyake tete meetakutukoa kaki-pe wa kawikoa enaneya. ");
INSERT INTO wiu_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Nimo okale tete metane agome Mosese-pala wene pokome ete pedekakome okome tota yopia ka wa teyo okale teke toko-pe. ");
INSERT INTO wiu_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Neme abela Idipi ago pade wia tukadeko toa noka opi wia tukade oko-pe wa okale ");
INSERT INTO wiu_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Moseseyopa abelana tokounakamo peyame yakatapeadiki wa piti tokale Idipi ta to̱a pekeneya. Nitoapa Midiane take to̱a pome mekome one matita takuta eida opia kakaneya. ");
INSERT INTO wiu_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Mali lene timini togoikoa padeka noi kakoa (40) ponokale eya taneya. Mosese Kati Sainai tono liti ali piamene take pome meane-pete de yomo deyake toe itipono okoa kaka pakeke edelo ago pade pono yamenokale ");
INSERT INTO wiu_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","enekome wene kainya pianeya tokome pinele pome enepaneya. Nitoa pome yatekale Akolaliyo agale okale yakaneya. ");
INSERT INTO wiu_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Yakakoa kakale Akolaliyo okome okome neke kaua ali-mene Eberame-loe Aisake-loe Yekobe-loe einago-mene yopiane kaku Akolali no i kakuna wa okale yatekome tokome enamene piti tokale kolu kolu moa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Nitoa kakale okome ne wini kakotapa tipi tanetano, neke kawa yene kotokoa pia. ");
INSERT INTO wiu_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Eya wane ukuno, yaka. Anu yatene Idipi take tete moa kakili enoane komoka oa kakili yakoane tekene toane moadene i nukuno, opi nepa Idipi take wakapea poano pa wane ne moane wetekada wa Akolaliyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Mosese einagopa one yatename wakete ekete toto yopia koiso akoa ta wa teyo okale teke toko-pe wa wakene ago. Ni agome toto yatene toa moa talo tomotoa tokome Akolaliyo takoa moa Idipi take eni wetekaneya. Einapa Akolaliyo one edelo ago Mosese kakota imo akapa wa oka toa pome yomo deyake toe itipono okoa kaka pakeke kakome akaneya. ");
INSERT INTO wiu_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Nitaneyake padele padele telekole ali atoa wene kainya pikanele toma pokome one yatene Idipi ta tewitikoa aua pokome Kiane Ue ketoa ali piamene take aua pekeneya. Nitoa ali piamene ta ludu aua yakilepa mali lene timini togoikoa padeka noi kakoa (40) ponoka toa padele padele telekole toma yakome taneya. ");
INSERT INTO wiu_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Mosese einagomepa Iserele yene-pala papete oa pikome okome Akolaliyo no takoa moa kakakana toa tokome kiwi pakeke meka ago pade one agale akamotoa takoa moa kakoo wa oa pianeya. ");
INSERT INTO wiu_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Mosese einagopa ali piamene take ali atoa-pala koua meaneya. Ni Kati Sainai tonoke agale akanane edelo ago-pala opia kakeneya. Ni tone kaua-mikiti-pala koua meaneya. Ni ne yatename yakamotono ta wa Akolaliyo toto mea kama pomotoa toko agale i i wa Mosese yametaneya. ");
INSERT INTO wiu_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Mosese nitane agoke tone kaua-mikitame one agale litia toameneya. Nipa kini wenepa Idipi take pianeya mekete one wakeneya. ");
INSERT INTO wiu_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Nitoapa Erone-pala ko̱ oa kakete ekete toto Idipi ta tewitikoa aua yakanakago Mosesepa Sainai tonoke kawa kakono, one-pala tokale agopa tokono, tuko patu, tuamoko patu. Tone kowitateko gode-kiti latikoano ta. Nipa i ta ludu namolo kakoa toto aua yawatiki gode-kiti adeka pia yomini latikoano ta wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Einapetepa eina yename pitimekawe kai tine yomini latia kakakete Akolali tetepo takoa padeya-kiti aua note mea lodo yoai taneya. Nipa kini yoname latikoinakeyake ke ke wa wedia kakeneya. ");
INSERT INTO wiu_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Nitaneyake Akolali mukiti yamea mekomepa eina yename a tibuke kakene lou tokene eya etepea kowitima pomotoa wakeneya. Einapa Akolaline agale akane ago padame eya wa wia mekane toa taneya. Iserele yene kipala ukumo yakoe. Mali lene timini togoikoa padeka noi (40) kakoake ali piamene ta ludu pima yakete kini pitimekawe kai sipi sipi kai eya wia lodo yoma pokoi. Eni lodopa nooke yotokoiya mena. ");
INSERT INTO wiu_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Moloko einagono mamina yapu latia aua yakete eina yapu keneke lodo yoai tokoi. Ni kini kowitiko ago Lepane one tagoi tibuke a kakona wa one tagoi adeka pia yomini latia aua yakoi. Moloko Lepaneta kowitato wa kini yominike lodo yoma yakoinano, kini ta pine lono ete takoane lititapeane Babilone take ete moane wetekou wa Akolaline agale akane ago padame wia mekaneya. ");
INSERT INTO wiu_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Tone kaua-mikiti ali piamene ta ludu pima yakete meme kai kepeneme latiane yapu-pala aua yakeneya. Nipa Akolaliyo Mosese kotua ko oai tane yapu-pala aua yakeneya. Eina yapupa Akolaliyo Mosese-pala adeka pia akene toa latianeya. ");
INSERT INTO wiu_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Eina yapu-pala aua yawa tua pekete kini mana-mikiti laukoa pekeneya. Wa naniko Akolaliyo Kenane take pitane yatene-kiti ete takoa lititapekale tone kaua-mikiti tobou ago Yosua-pala Kenane take pote awia meketepa eina yapu-pala aua pote kakapaneya. Nitoapa kini mana-mikiti eida opia kakoa tuma note wipitiketepa Depidi opiane-peteka eina yapupa eida pikoa kama pekeneya. ");
INSERT INTO wiu_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Einago Depidi Akolaliyo pewe wia yopikale okome ne meateko yapu oyake wikakou-pe wa yatekale ");
INSERT INTO wiu_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Akolaliyo neme mena wa akeneyake mana Solomono one luku tobou ago mekome wikakaneya. ");
INSERT INTO wiu_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Nitaneyake Ali Muno Akolalipa alime wikakane yapu mekilepa toamoko. Enikepa Akolaline agale akane ago padame Akolaliyo okamo wia mekakome okome ");
INSERT INTO wiu_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Tibupa anu tene pogakoane mekuya. Itonopa anu kawa pogakoane mekuya. Anu edeya yapu wikakadete iki-pe. Alime wikakane yapu kenekepa no edoane memotoa-pe. ");
INSERT INTO wiu_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Tibu itono enika eniya peya anume-kama latiane pikouya. Eina akenepa Akolaliyo papete akenemo uku wa Sitipeneyo oa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Nimo ootokoa Sitipeneyo e Kanosolo ali-kiti-pala okome kepene teigamene pa yatene meki toa kini kabe ko akameneya meki. Nipa kini kaua-mikitame tane toa kimeka Epetane Yomini ete pedekakala tiki. ");
INSERT INTO wiu_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Kini kaua-mikitame Akolaline agale akane ali peya padeka katekameneya tete mema-kala nekeneya. Ni wene ki̱yo akeneya-kama meko ago noatekamo to̱awea oa piane ali-kitika wia tukama-kala nekeneya. Einago taatekoa nokalepa one wia tukakoe wa mone yenane yonoke kime moa pikoina. ");
INSERT INTO wiu_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Akolaline totonopa one edelo ali-kitame papete to̱awea akoa metaneyake kime pikoa kaketeke litia toamekete enile tokoina wa Sitipeneyo oa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Sitipeneyo nimo okale yatekete e Kanosolo ali-kiti kotimi yotokoi matiyame one-pala eei wa kime kolukoa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Nitikolika Sitipenepa oneke Epetane Yomini awia tagatapeneya kakome tibu ate nepikakale Akolali tele pa̱ta tootapeneya kakale enoa ni Yesuka one nimini yono kounoke kakale enoa taneya. ");
INSERT INTO wiu_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Nitikome okome tibu kene peaneya pikolo enoane ni Ali Yatenane Oyago Akolaline nimini yono kounoke kakolo enoane tukuno, enoe-kale ");
INSERT INTO wiu_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","e yename agale ta̱yo ootapea kini kale kene yoname ketekoa one unukamoa dekoa motaneya. ");
INSERT INTO wiu_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Nitoapa Yerusaleme ta kago ketepono patukoa lia pitikakete kueme ka̱ua wia tukaneya. Nipa i ago Sitipeneyo Akolali taumada toa okale yatekoo wa akoa akene ali-kitame one wia tukadete kakete kini tokoo kakene mamina kotokoa pala pitikaneya. Nipa tuali pade Solo wa ibini akene agono kawane pala pitikaneya. ");
INSERT INTO wiu_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Nitikakoa Sitipeneyo kowitikome okome Ali Muno Yesu neeke nukuno, anu yomini moa ta wa kowititikoa ");
INSERT INTO wiu_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","neuwe tukuketikakome agale telo okome okome Ali Muno i yene kini i poanele tikileke nami wia kibu motokameamene wa ootokoa atu piou toa tukome tuaneya. Eni yename Sitipene wia tukamotoa kakome eyago Solo kipala odene wene-mene pia kakeneya. ");
INSERT INTO wiu_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sitipene wia tukane ta pataka-pete eina eina titimoa ete yenamepa Yerusaleme take Yesunomo yakoa motane-kiti dika dika toamene tete meai taneya. Nitaneyake Yerusaleme ta to̱a Yudea Sameria tata piko peyake tadoa pekeneya. Nitaneyake Aposelo ali-kiti to̱a poamekete pa eida meaneya. ");
INSERT INTO wiu_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Nitikakoa Yesunole wedoa takama yakene ali padeka-kitame Sitipenene tigini moa aua kotake pipekete oneke komo ka̱ta pitikoa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Solo einagome Yesunomo yakoa motane yene wiane atukou wa wene pikome kini kini yapu yapu mekoi toa tuku toma pome enamutukome akolono lia pitikoa alika atoaka po yapu pitikakala taneya. ");
INSERT INTO wiu_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Yesunomo yakoa motane yenepa Yerusaleme ta to̱a ta piko peyake tadoa pekete Yesunomo mo wima pekeneya. ");
INSERT INTO wiu_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Pilipi oneka Sameria take pokome Keraisunomo i i wa mo wia kakeneya. ");
INSERT INTO wiu_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","One eni okamo yakoa one telekole tokale enoa tekete ali atoame one oka agale wedoa yakakoa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Einata einapete ali atoake awitane ipono-kiti ka̱ akeneya takoa pokala taneya. Ni kawa yono tau taneya meane-kiti ni kawa okeaneya meane-kiti kainya mati epetekatapeneya. ");
INSERT INTO wiu_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Nitaneyake Sameria take pitikoi ali atoa wedia kakala taneya. ");
INSERT INTO wiu_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Sameria takepa Saimone wa ibini akene ago meaneya. Einago koto mati otoi ago mekome taneleme ali atoa wene kainya pikakala taneya. Einagopa ibini akene ago kaku wa mate okala taneya. ");
INSERT INTO wiu_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","One nitane ago tokale kamo yene ponopene yene peyame ekete i agopa Akolali keneyano, Akolaline tele patu kautakoa kako wa one okagale-kama wedoa yakakoa kakala taneya. ");
INSERT INTO wiu_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Nipa koto mati otoi ago mekome taneleme kini wene kainya pikaneya tokome one agale wedoa yakakala taneya. ");
INSERT INTO wiu_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Wa naniko Pilipi eida nome mekome eya epetane ko Akolaliyo ali atoa talo tokome toko ko ni Yesu Keraisuno ibini oa mekala taneya. Nitikale yakoa motekete ali atoa peyame ue mokala taneya. ");
INSERT INTO wiu_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Saimone einagomeka Pilipiyo okamo yakoa moa ue mootokoapa Pilipi pokaka litima pekeneya. Litima pome enekale padele padele telekole toa ali atoa wene kainya pikoa tokale enekome wene kainya pianeya meaneya. ");
INSERT INTO wiu_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Aposelo ali-kitipa Yerusaleme take eida pa meketepa Sameria yename Akolaline agale yakoa motokoi wa akedekoimo yakatekoa Pita Yoneta takoa moa Sameria take poatino poe wa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Wetekakoli note meketepa Epetane Yomini eni yeneke awinome memotoa kowitikaneya. ");
INSERT INTO wiu_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Nipa papete eina yename Yesuno ibini wedekoa ue motaneyake Epetane Yomini kiwike wete awinameneya tokome ni kowitikaneya. ");
INSERT INTO wiu_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Nitoa kini mataike yono pikoli Epetane Yomini awinaneya. ");
INSERT INTO wiu_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Aposelo agotame eni yenane mataike yono pikoli Epetane Yomini awitikale enetekoa Saimoneyo einagota kue metekome okome ");
INSERT INTO wiu_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","kitame wini telekole tiki toane toada. Nipa anume takoane mataike yono pikou-kitike Epetane Yomini awinomotouno, yameatino toe wa kue metaneya. ");
INSERT INTO wiu_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Nitikale Pitayo okome neke kue-pala aua iponane poane take pamene wane uku. Epetane Yomini Akolaliyo nami kakameneya pa mekala tokoyake neke kueme topo toane mou wa neme wene pika tokolo ni uku. ");
INSERT INTO wiu_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Akolaline leneke wene ki̱yo wameneya kake tokanano, Akolaline pupu tota-pala odeneka takama yamele toamoko. ");
INSERT INTO wiu_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Wini poanele tokake Akolaliyo po letu mekakana oneme kea mitikademe toko patu. Kea mitikakamotoa toa enoano, neke wini poane wene wia wawa one kowitamene. ");
INSERT INTO wiu_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ae, neke tepene poane wene mati alatapekome nime ne labakome tadeko wa Pitayo okale okome ");
INSERT INTO wiu_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","poanele tekene tadekuno, neke wini okole-kiti nopala takayano, Ali Muno kowitikamene wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Nitaneyake Pita Yonetamepa Keraisuyo toma yakale enekoinakamoka Ali Munono agaleka mo wima yawa peya takamotekete eni ta tewitikoa Yerusaleme take wakapea poadete pekeneya. Nitoa Sameria ta ludu pekete ali atoa pitikoika Yesunomo oa mekutu toma pekeneya. ");
INSERT INTO wiu_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Wa naniko Pilipi Sameria take eida pa mekakoa Ali Muno agono edelo ago Pilipi mekata nokome okome wete kamokoa pa. Yerusaleme take titimoa Gasa take keita witane bateteke pamene wa wetekaneya. Eni batetepa ali piamene ta ludu pianeya. ");
INSERT INTO wiu_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Edelagome oka toa tokome Pilipi kamomotokome eni bateteke poademe pokome Isiopia take ago kotuaneya. Einagopa ibini akene tiobago. Isiopia take ako odene meane tobou atoa Kadesike lokoa tobou ago mekome einatoane kamoya peya yopikoa kakeneya. Einagome Akolali kowitademe Yerusaleme take pome mepaneya. ");
INSERT INTO wiu_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Pome mea kowitimotokome Isiopia take wakapea poademe pekeneya. Nipa osi kaime lia aua pokaya waneke mea poademe pokomepa Akolaline agale akane ago Aisaiayo wia mekane boku lewea oi moma pekeneya. ");
INSERT INTO wiu_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Nitikaka Epetane Yominiyo Pilipi-pala okome eni osi kaime lia aua pokoya waneke mea ponokago kotua pamene wa okale ");
INSERT INTO wiu_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","teyapea kotua pokome yatekale einagome Akolaline agale akane ago Aisaiayo wia mekane agale oi moa mekale yakaneya. Yatekome okome neme wini oi motoko agalepa wene toko-pe-kale okome ");
INSERT INTO wiu_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","eni agale pine to̱awea oateko ago pade enamukuyano, edoane wene tuku patu wa ootokoa mekome okome nopala odeneya mea patono, lewia meno wa okale nitaneya. ");
INSERT INTO wiu_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Nitoa mea enekale einagome oi moma pome tugane agalepa dikoa wia mekaneya enaneya. I to̱aweane uku agopa padame sipi sipi kai wiademe lia aua pou toa pade ali-kitame one wiadete lia aua pekeneya. Sipi sipi kai tine pine pitukoa kakili agale wametekaneya pa kako toa einagoka agale wametekaneya pa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Einago koiso akoa ya motokakoli padameka one kei piameneya. Itonoke mea togameneya pa tekei mekale po tewitikale pekeneyano, oneke ta̱ma pokoi yene i i wa teyo to̱awea omotoa-pe. Eni akenelepa wete tane tetepo takoa Aisaiayo papete wia mekapianeya. ");
INSERT INTO wiu_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Einagalepa tobou agome oi moa mekome tokome Pilipi-pala okome Akolaline agale akane agome teeke akeneya patu. Pinali oneke akeneya patu. Panagoke akeneya patu wane ne yatekene uku-kale ");
INSERT INTO wiu_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Pilipiyopa einagome eina oi moma pome tugakata titimoapa Yesu ko oa meaneya. ");
INSERT INTO wiu_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Nitoa batete ludu opia mea potepa ue meaneya liti witakete tobou agome Pilipi-pala okome ue i meadekono, ue mouno, anume ue momotoa padeleme ketekako patu-kale okome ");
INSERT INTO wiu_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","poome toameneya Yesuke wene tugoa mekepa oyake moamele toko-kale okome e̱eno, Yesu Keraisu onepa Akolaline mana wane wene tuku wa ootokoa ");
INSERT INTO wiu_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","osi kai yopikago-pala okome no ponene meouno, osi kai witimoa kamotono ta wa akeneya. Nitoapa eniya waneke mea katepitoa Pilipi-pala uele keti pome kakale Pilipiyo ue motokaneya. ");
INSERT INTO wiu_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ue motokakale Isiopia ago Pilipita ue matanuke ate pogatekoa pote kakoika eina eina Epetane Yominiyo Pilipi takoa moa aua pekeneya. Nitikalepa tobou agome Pilipi wa pade enameneya one ta pine lono wedianeya pekeneya. ");
INSERT INTO wiu_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Nitaneyake Pilipi Asedose take witakome eida titimoa pima yakomepa pitikali latia pitikoi ta piko peyake Yesunomo oa mekutu toma pome Sisaria take tugapaneya. ");
INSERT INTO wiu_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Sitipene tuutukaneyake Ali Munono agale yakoa motane yene keteane wiou wa Solo kotimi yoa meaneya. Nitoapa ako odene mekome Akolalike lodo yotokoai tane tobou ago mekata pokome eya wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Damasikase takepa Keraisunole takama piki yene tuku toane enamutukene ali-kitika atoa-kitika po kakoane oto Yerusaleme take liimoane auane nouno, enile toateku pipia pade eni take losu yapu yopikali-kiti yamepouno, pipia wia meano ta wa opaneya. ");
INSERT INTO wiu_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Nitoa pipia moomotokome Damasikase take poademe tigotokakoa pokata odepeta a tibu laigoa to̱awineya noka pa̱me one payapono pia unukakale ");
INSERT INTO wiu_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","itonoke aua pitalogakale agale ludu nokome okome Solo Solo nepa no edekolo tete mekala toko-pe wa okale yatekome okome ");
INSERT INTO wiu_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ali Muno nepa te kake oko-pe-kale okome neme tete mekala toko ago Yesu kakene ukuno, ");
INSERT INTO wiu_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Damasikase take wete poke mepamene. Poke mekalepa neke toatekale panago nome to̱awea onoono, wete kamoa pa wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Nimo okaka Solo-pala opia nekene ali-kiti witimoa kakete agale wametekoa pa nepia kakeneya. Agalepa eina okake alika enaneya mena. ");
INSERT INTO wiu_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Nitaneyake Solo kamokakome lene kikoa enoake one leneta liitapeneya tadekale enamele toamokale tokome one oya-laweme yono moa aua Damasikase take pekeneya. ");
INSERT INTO wiu_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Nitikoli nome mekale ta tebolo-peta lia patakale padeka enameneya ue neeka wawa pa meaneya. ");
INSERT INTO wiu_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damasikase takepa Yesunomo yakoa motane ago pade Ananaiasi one eida mekata Ali Munoyo pule menokome okome i ago Ananaiasi wa okale okome nopa i kakuno, yakouno oano ta-kale okome ");
INSERT INTO wiu_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","eya yapu ki̱yo akeneya piko wa ibini akene batete kebonoke kako yapu Yudasene yapu poke eya wa yakapamene. Tasase take Solo neke i yapu nome meko-pe wa yakapa. Solo einago eni yapu mekome no kowitoa mekome tokono, one mekata wete kamokoa poano pa. ");
INSERT INTO wiu_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Solo einagome one pulete enekale panago one ibini Ananaiasi nepa one mekata nokome one lene wa kikoa enekamotoa yono piademe nokale enekano, one lene kikakapamene wa Ali Muno agoyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Nimo okale okome ekee Solo einagome Yerusaleme take neke agale yakoa motane yene dika dika toamene tete motokama yako wa akedekoimo yatekou. ");
INSERT INTO wiu_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ika Damasikase takeka ne kowitoai tiki yene peya po kakoa po yapu pitikamotoapa Akolalike lodo yotokoai tiki tobou ali-kitame one pipia pade wia metekoli eni pipia-pala oto aua nekedeko wa okale ");
INSERT INTO wiu_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ali Munoyo okome wete poano pa. Einagopa noanume takoane motokou ago. Ni agome e ku pa yateneka kini ako tobou ali-kitika anu Iserele yeneka enika eni yene pitiki toa anu ibini i wa to̱awea oma pomotoane tekene takoane motokou. ");
INSERT INTO wiu_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Nipa nooke toa dika dika toamene tete moma poatekoya one ooyamepiadene tukuno, one mekota wete pa wa Ali Muno agome okale ");
INSERT INTO wiu_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","yakamotokome pome one meka yapu keneke tuapea pome Solo enekome yono pikome okome ame Solo Damasikase take noade nokale ne pono yameteka ago Ali Muno Yesuyo wetekakolo nuku. Nipa neke leneta wa kikoa enoa Epetane Yomini awia tagatapeneya mea tomotoane nuku wa okale ");
INSERT INTO wiu_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","eina eina Solo one lene kidonome keneya ketekalogane toe takoa pitakale lene kikoa enaneya. Nitoa kamokakome ue motaneya. ");
INSERT INTO wiu_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Nititikoa nee pade moa nakale popeyo nekeneya. Soloyo Damasikase take ta pataka-mene Yesuno agale yakoa motane yene-pala opia meaneya. ");
INSERT INTO wiu_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Nitoapa Damasikase losu yapu kako toa Yesu onepa Akolaline mana wa oma-kala yakeneya. ");
INSERT INTO wiu_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","One eni okamo yatekoi peyame ekete ekee i agopa Yerusaleme take Yesu kowitoai tokoi yene wia atukakanakago patu. Ikaka edikaki yene po kakamotokome Akolalike lodo yotokoai tiki tobou ali-kiti mekita liimoa aua poademe nokagomeke imopa i oko wa ka̱ oa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Nitaneyake Solo Akolaline tele patu wedoa kautakoa kama pokome okome Yesu einakago onepa eina papete Keraisu wa ibini oa piane ago tadeko wa onekemo pine to̱awea oa kakale Damasikase take Yu yename one-pala agale topo takoa amele toameneya. ");
INSERT INTO wiu_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","24","Soloyo Damasikase take nitoa mekale eina Yu yename one wia tukatekoi oi pedoa piitikoa Damasikase ta kago keteponoke ta ete patakakete oto likakete toa poi piai taneya. Nitaneyake panagomepa Yu yename ne wiadete tiki wa Solo mekata pome pubu opokale ");
INSERT INTO wiu_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","likonu one oya-laweme Solo moa pawe tobou waneke pote kakete tube ka keneke uuketikoa makoke po kakoa widoa keneke akolono pomotoa keti tukaketikaneya. ");
INSERT INTO wiu_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Nitaneyake Solo Yerusaleme take pokome Yesuno agale yakoa motane yene-pala lipuademe wili toa mekale peyame i agopa Yesuno agale yakoa motokago mena wa piti motekete one wakeneya. ");
INSERT INTO wiu_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Nitaneyake Banabasiyo one-pala oya kakatekoa Aposelo ali-kitike aua pokome okome i agopa Damasikase take poademe pokome Ali Muno Yesu enekale Yesuyo one-pala ko oa kakeneya. Wa naniko Damasikase take pome mekome Yesu patu kautakoa kakome onekemo atiki toa to̱awea akeneya wa Banabasiyo Solo kei pia kakeneya. ");
INSERT INTO wiu_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Nitaneyake Solo Yerusaleme take eni yene-pala ete oto wa opia yakome Ali Muno patu kautakoa kakome onekemo atiki toa to̱awea oma yakeneya. ");
INSERT INTO wiu_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Nitoa Geriki agale yakoa akene Yu yene-pala agale topo takoa okale eni yename one wiadete tuku toa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","One wia tukatekoi oi pedoa pikoimo yakatekoa one oya-laweme Solo moa Sisaria take nabisike wetekapekete ekete neke Tasase take wakapea poano pa wa ue dipike mekoa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Nitaneyake enipete-mene Yesuno ali atoa Yudea Galili Sameria ta-meneke mekete tete moameneya poti kilikoa meaneya. Nipa Epetane Yominiyo auapekale Akolalike nate wene pianeya mea onekele wedoa takama yakeneya. Nitaneyake ete ali atoa Yesuke wene tugoa mea kipala lipuai lipuai taneya. ");
INSERT INTO wiu_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pita ta piko peya pima yakome padepete Yesuno ali atoa Lida take mekoika ugu pome mepaneya. ");
INSERT INTO wiu_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Pome mekome enekale eya ago Iniasi yono kawata tau toomotaneya pikale enaneya. Einagopa mali ketepo kakoa (8) ponoka toa-kama pa dikaneya walaike pia kakeneya. ");
INSERT INTO wiu_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pitayo einago enekome okome i ago Iniasi nepa Yesu Keraisuyo latekakono, neke yene pitike tatikoa pitikoya wete moa ewetoano, kamoa wa okaka eina eina kamokoa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Nitaneyake Lida Sarone tatake pitikoi peyame eina latoa pokago enoai tekete tepe kolotini pekoa pia Yesuke wene tuganeya. ");
INSERT INTO wiu_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Einapete Dopa take Yesuno agale yakoa motane atoa Tabisa wa ibini akene atoa tuaneya. Tabisa Geriki agaleke eketepa Dokasi wa ibini ikiya. Einatoapa epetanele-kama toa ali atoa auapekala tane atoa. ");
INSERT INTO wiu_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Einatoa yene pia mea tukale one oya-laweme ueme abe kogatekoa ako yapu moa pipaneya. ");
INSERT INTO wiu_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lida taapa Dopa ta namike pikale tokome Yesuno agale yakoa motane yename ekete Pita Lida take ponome mekome tokono, wida meameneya tone Dopa take wete noo wa Pita enemopoe wa ali takuta moa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Nitikoli pekete ne noo wa kowitikoli nipa patoe wa Pita einagota-pala opia pekeneya. Nitoa tumai yapu nokale einagotame ako yapu aua pokoli nepo meane atoa-kitame Pita unukamoa kakete kini tigini mamina eya pikoa kakete ekete ika iyapa i tuane atoame tone takoa mekala toka wa Pita yamea kakete komo oa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Nitikoli Pitayo peya akolono moa wetekatekoa neuwe tukua Akolali kowitaneya. Nitoa peketapekome tuane atoa enekakome okome Tabisa wete kamoa wa okaka leneta kikatapeneya. Nitoa Pita enekome kamokoa meaneya. ");
INSERT INTO wiu_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Nitikale one yono moa katekamotokome nepo meane atoa-kitika ete Yesuno agale yakoa motane-kitika noe wa kayo oa motokome einatoa i latoa kakona wa yametaneya. ");
INSERT INTO wiu_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Nitaneyake Pitayo tanemo Dopa take oa pupitikaneyake eni take mekoi peya mati Ali Munoke wene tuganeya. ");
INSERT INTO wiu_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pita onepa Dopa take eida pa mea kakeneya. Nipa kai kepeneme padeya padeya latia tane ago Saimonane yapu meaneya. ");
INSERT INTO wiu_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Sisaria takepa Koniliasi wa ibini akene ago meaneya. Einagomepa Itali wa ibini akene poyo yatene yopia meaneya. ");
INSERT INTO wiu_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Einagomeka one yapu meane ali atoameka Akolalinele takama pote oneke nate wene pia lukoa meaneya. Nitane ago tokome onekeya-kiti ponopene Yu yene tatikoa mekala toa Akolali kowitoai toa taneya. ");
INSERT INTO wiu_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Wa padepete lou wegoukakaka (lou pini teboloke) tadiya pule pitikome enekale Akolaline edelo ago pade nokale enaneya. Edelo ago eni nokome okome i ago Koniliasi wa okale ");
INSERT INTO wiu_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","piti tokale nepikoa pikome okome Ali Muno edade noke kake oko-pe-kale okome Akolaliyopa neke kowitike okamo yakoa nekeya-kiti tatia metekale enoa tokome ne wene taneya mekono, ");
INSERT INTO wiu_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Saimone Pita enemotokapoe wa neke pupu ali pade-mene Dopa take moa wetekamene. ");
INSERT INTO wiu_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Einagopa kai kepeneme padeya padeya latia toko ago Saimonane yapu tube kusa ue liti mekome tokono, nitamene wa edelo agome akeneya. ");
INSERT INTO wiu_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Nimo oomotokome pokale Koniliasiyo eya taneya. One pupu ali takuta ni oneke lukoa meane poyo ago pade Akolalinele wedoa takama yakene ago einago-mene noe wa kayo oa motokome ");
INSERT INTO wiu_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","one pulete enekanakamo-kama to̱awea okome okome Dopa take Pita enemotokapoatino poe wa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Podolikama einago-mene Dopa take tigotokakoa nokoika Pitayo Akolali kowitademe one meka yapu yalini waneke ate lewia pome mepaneya. Nipa lou mataike ponome kakale taneya. ");
INSERT INTO wiu_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Nitoa mekome kobu tokale nee noademe akeneya. Nitane-pete yapu pine yename nee noatekoi nodokakete kakoika ");
INSERT INTO wiu_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Pita pule pitikome enekale tibu peaneya pikata mamina petene nami-meneke po kakoa itonoke tukaketikakale enaneya. ");
INSERT INTO wiu_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Eni mamina kagonoke eya kuya kai kaya ini lobutaneya pikale enekakoa ");
INSERT INTO wiu_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","agale ludu nokome okome Pita ne wete kamoa eniya-kiti moa wia namene wa okale okome ");
INSERT INTO wiu_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ali Muno wini okolepa toamou. Neme yametekoya-kitipa toto Yu yename kekaneya latikoa noamokoya-kiti toko-la. Enika eniya pade wete noamokouya tekene noamou-kale ");
INSERT INTO wiu_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","agale ludu wa nokome okome ika iya nomotoane latikakou wa Akolaliyo yametekaya-kitipa neke kekaneya wa wamea. Eniyapa moa na wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Enilepa tebolopeta tokala taneya. Nititikaneyake eina mamina petene a tibuke wete katekamotaneya. ");
INSERT INTO wiu_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Nitikale Pita atu kamokoa mekome eni pulete enekuyapa edoa tokoto patu wa wene kibutua mekaka Koniliasiyo moa wetekane ali-mename Saimone one yapu manika kako-pe wa pitia yakatekoa one meka yapu kago keteponoke note kananeya. ");
INSERT INTO wiu_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Nitoa kayo ekete ekete Saimone one pade ibini Pita wa iki ago wida meko-pe wa yakaneya. ");
INSERT INTO wiu_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Nimo kayo ekete kakoika Pitayo one pulete enekanakale wene kibutua mekale Epetane Yominiyo one-pala okome ali tebolome ne tuku toma note kei kagoke kakete tikino, ");
INSERT INTO wiu_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","wete kamoa kotua pa. Poome toameneya eni ali-mene-pala opia pamene. Anume oto wetekakolu tokome ni nikino, opia pamene wa okalepa ");
INSERT INTO wiu_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Koniliasiyo moa wetekane ali-mene kakoita pokome okome kime tuku toniki agopa no i kakuno, edekolo tuku toniki-pe-kale ekete ");
INSERT INTO wiu_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","poyo yatene tobou ago Koniliasiyo poe wa wetekakale nokoo. Einagome epetanele-kama toa Akolalike poti wene pia lukoa mekagopa Yu yene peyame one kei piai tiki. One mekata Akolaliyo one edelo ago pade wetekakale nokome okome Pita oto nomotono ta. One nokome okamo neme yakamotoane ukuno, one mekota neke pupu ali pade-mene wetekamene wa edelo agome Koniliasi-pala oka toa toto ni nokoo-koli okome ");
INSERT INTO wiu_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","nipa i yapu piatono noe wa makutukoa motaneya. Pimotokome podolikama Pita einago-mene-pala opia pekeneya. Dopa take Yesuno agale yakoa motane ali pade-kitika kipala opia pekeneya. ");
INSERT INTO wiu_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Pita eni yene-pala Sisaria take noademe nokale Koniliasiyo one wamene laine-mikiti one oya-lawe enika eni ali atoa obokoa yapu nepia meaneya. ");
INSERT INTO wiu_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Nitaneyake Pita one yapu eida tuapea noademe nokaka Koniliasi kotua pokome Pitane kawane keti pekoa pitakome ke wa one kei pianeya. ");
INSERT INTO wiu_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Nitikale Pitayo one yono moa katekamotokome okome noka pa agono, winile toameano, kamokoa ka wa moa katekamotaneya. ");
INSERT INTO wiu_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Nititikoa one-pala ko oma pome yapu pokome enekale ali atoa peya mati eida oboa mekoli enaneya. ");
INSERT INTO wiu_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Enekome okome no Yu yatene tone kaua-mikitame kitau laukane toa pa yatene ali-pala opia poamoa yapu-kitika ugu poamoa toko. Eni kitau noanumeka laukoane mekouyake Akolaliyo pule metekome okome odene agoka pa yatene ago wa wamoa kitau laukameamene wa oka. ");
INSERT INTO wiu_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Nitikale tekene Koniliasiyo moa wetekane ali-mene no mekouta nokoli ko̱amoane wete oto nukuno, no enemonomotoa einago-mene edekale moa wetekakoiya-pe wa Pitayo yatekale ");
INSERT INTO wiu_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Koniliasiyo okome eko ikouna ipetepa lou pini teboloke Akolali kowitoane mekolu panago yati yati tane mamina kakeneya anu lene timini lono kotikatapea nome kaka. ");
INSERT INTO wiu_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Nitikome okome Akolaliyopa no neke kowitoai teke okamo yakoa nekeya-kiti tatia ponopene ali atoa mea tokale enoa tokome ne wene taneya mekono, eya toano ta. ");
INSERT INTO wiu_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Dopa take Saimone one pade ibini Pita wa iki ago eya agono yapu pitimekawe kai eya kepeneme padeya padeya latia toko ago Saimone one yapu tube kusa ue matanu liti ponome mekome tokono, einago enemopoe wa neke pupu ali pade-mene moa wetekamene wa edelagome okale ");
INSERT INTO wiu_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","eina eina ne oto nomotoane anu pupu ali pade-mene moane neeke wetekakou. Ne epetekoa teke opi nokono, ke wane uku. Akolaliyo neme a wa oka toa yakoono, Akolaline leneke toto peya i oboa mekono, wete a wa Koniliasiyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","35","Koniliasiyo nimo okale Pitayo okome papetepa Akolaliyo no Yu yatene odene one wa takoa moa yopikoa mekono wene pianeya mekou. Opa e ku pa yatene oneke nate wene pianeya lukoa mekete ki̱yo akenele toma yaki peyaka Akolaliyo one wa pawe toa talo toko wane wene tuku. ");
INSERT INTO wiu_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","One agalepa Iserele yene mekoika oa memotoa Akolaliyo Yesu Keraisu moa wetekaneya. Nitikale nokome Akolali-pala poi teigoa wawa odene wene pianeya meatekoimo i i wa oawineya yakeneya. No Yu yatene e ku pa yatene peyaka yopia meko Ali Muno Keraisu Yesuyo nitaneya. ");
INSERT INTO wiu_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Kipala i uku agalepa Yudea ta piko peyake oa pupitikanemo kimeka yatekete tokoi. Yoneyo ali atoame ue moatekoimo oma yawa ue motokatekaneyake Galili take titimoa oa pupitikanemoke uku. ");
INSERT INTO wiu_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Enipa Akolaliyo Nasarese Yesuke Epetane Yomini moa awitikoa tele lukoa tokale ele kule epetanele toa ni Setanuyo moa kautane yene peya latekama yawa taneya. Akolaliyo one auapekala tokale nitaneya. ");
INSERT INTO wiu_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Yu yatenane ta piko peyake Yerusaleme takeka Yesuyo padele padele toma yakale-kama tone leneme enekooya tekete dika dika wa to̱awea amele tokolo uku. Yesuyo nitaneyake tobou ali-kitame dekoa moa yomo lekaneyake wia tukakoi. ");
INSERT INTO wiu_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Nitikolipa ta tebolo takoa pataka-pete Akolaliyo Yesu moa kamotokatekoapa ali atoa mekoika pono yamepomotoa taneya. ");
INSERT INTO wiu_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Nitaneyake ali atoa peya pono yametaneya mena. One toma yakale enemotoa Akolaliyo takoa kakapikana yene odene pono yametekala toka. Nipa one kamoa pootokaneyake onepala opia mekete nee ueka nokala tokoo yene toto odene pono yametekala toka. ");
INSERT INTO wiu_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Nitikome okome onekemo ali atoa-pala i i wa akama yamene. Ni wipitia ta pataka-petepa ali atoa peya tua pokoi-kitika yomini meaneya mekoi-kitika kini koiso akoane omotoa Akolaliyo one moa kakapika wa akama pamene wa pono yamenokome oka. ");
INSERT INTO wiu_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Einagokepa Akolaline agale papete to̱awea akane ali peyame eya wa ekete akeneya. Oneke wene tugoa mekoi peyapa Akolaliyo kini poanele toma yakoike po letu mekakana keetapea mitikoo. Nipa Yesuno ibinike tokome nitoo wa Pitayo akeneya. ");
INSERT INTO wiu_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pitayo nimo oa kakaka one agale yakakoa mekoi peyake Epetane Yomini awinaneya. ");
INSERT INTO wiu_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Nitikale enekete eya yene Yesuke wene tuganeya mea Pita-pala opia nekene Yu ali-kiti wene kainya pianeya. Nipa Akolaliyopa Epetane Yomini kiwike namolo awitikakana toa i pa yatenekeka awitikadeko wa wene kainya pianeya kakete akeneya. ");
INSERT INTO wiu_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Eni yename agopa tane agaleke Akolali kei pia kakoli yatekete tekete ni akeneya. ");
INSERT INTO wiu_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Nitikoli Pitayo okome Epetane Yominipa totoke namolo awinokana toa i pa yatenekeka awinadekono, ue motokameo wa teyo omotoa-pe. ");
INSERT INTO wiu_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Yesu wedekoa ue moamene wa okome eni yene ue motokaneya. Nitikale Koniliasiyo one yenameka ue mootokoapa kipala opia mea kamene wa Pita kowitikoli tokome ta pataka pade-meneke eida pa meaneya. ");
INSERT INTO wiu_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Mone pa yenameka Akolaline agale yakoa motiki wa akedekoimopa Aposelo ali-kitame yakaneya. Yude ta piko peyake Yesuke wene tugoa meane yene peyameka yakatapeneya. ");
INSERT INTO wiu_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Wa naniko Pita Yerusaleme take ate wakapea nome mekale eina ali padeka-kitame one kikoa akeneya. Nipa Akolaline mati-kiti latiadetepa ali mati yatene kepene teigamedeko wa akene yename Pita kikoa ekete ekete ");
INSERT INTO wiu_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","nepa kepene teigamene pa yatene agono yapu poke one yene-pala opia meke nee nakeneya. ");
INSERT INTO wiu_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Nitikoli Pita one yakome tokanakamo titikome toka-pala wipitikome tokata eya wa to̱awea akeneya. ");
INSERT INTO wiu_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Dopa take Akolali kowitoane mekene pulete keneya enekolu a tibuke padeya mamina petene nami-meneke po kakoa no pitikou pitia ketipea tukaketikakale enekou. ");
INSERT INTO wiu_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Leneme nepikoane pikolu eya kuya yo tane kai eteya egetamene kai kaya ini enika eniya peya lobutua pianeya enekou. ");
INSERT INTO wiu_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Nitoane yatekolu agale ludu nokome okome Pita ne wete kamoa eniya-kiti moa wia na wa okale ");
INSERT INTO wiu_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","yatekene ekene Ali Muno wini okolepa toamou-li. Neme no yametekoya-kitipa toto Yu yename kekaneya latikoa noamokoya-kiti. Enika eniya pade wete noamokouya tekene noamou-kolu ");
INSERT INTO wiu_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","agale ludu wa nokome okome Akolaliyo nomotoa latikaneya-kitipa neke kekaneya tokolo noamuku wa wamea wa oka. ");
INSERT INTO wiu_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Enilepa tebolopeta tokala taneya. Nititikaneyake eni mamina petene a tibuke ate katekamotaneya. ");
INSERT INTO wiu_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Nitikale eina eina ali tebolo no mekou yapu kotikatapea note kakoi. No enemonomotoa moa wetekaneyake Sisaria ta kawa nokoi. ");
INSERT INTO wiu_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Nitikoli Epetane Yominiyo nopala okome poome toameneya wini ali-mene-pala opia pamene wa okale opiane pokou. Nitikolupa Yesuke wene tugoa mekoi ali ko melepu (6) kakoa nopala Siseria take opia pokoi. Einali-kiti i note kaki. Toto peya pote Koniliasine yapu tuapea pokolo ");
INSERT INTO wiu_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Koniliasiyo one pulete enekana toa kekome okome edelo ago pade one yapu nome kakome okome Saimone one pade ibini Pita wa iki agopa Dopa take mekome tokono, enemotokapoe wa neke pupu ali pade-mene moa wetekamene. ");
INSERT INTO wiu_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Einago nome mekomepa neeka neke yapu pitiki-kitika toa moateko agale oa meoo wa edelo agome oka toa Koniliasiyo nopala oka. ");
INSERT INTO wiu_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Nitikale agale titikene okouka Epetane Yomini eni yeneke awia tagatapeka. Nipa totoke namolo awinokana toa toka. ");
INSERT INTO wiu_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Nitikale enekene inapa Yesuyo namolo wa oa pikanakale taatekoa tadeko wane wene tokou. Nipa Yoneyo ali atoa ue motokaneyake oneme ue motokou toane Epetane Yomini kiwike awitikou wa oa pikana wene tokou. ");
INSERT INTO wiu_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Nipa Yesuke wene tugakoo-kiti totoke Akolaliyo one Epetane Yomini awitikakilepa nami kakameneya tokana toa eni pa yenekeka awitikakano, ipa Akolaliyo tadekono, one wene pika toane tagamedekale eni yene ue motokakou wa Pitayo e yene-pala akeneya. ");
INSERT INTO wiu_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Nimo okale yatekete e yename Pita wa kikoa wameneya Akolali kei pikete ekete pa yatene ali atoaka mea kama poadetepa oneke tepe kolotini pekoa pimotoa tadeko wa Akolali kei pia kakeneya. ");
INSERT INTO wiu_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Yu yename Sitipene wia tukatekoa ete ali atoa tete motokakala tokolipa Yesuke wene tugoa meane-kiti Yerusaleme ta to̱a Pinisia Saiperase Adioke ta-meneke tadoa pekete Yu yene takoa Yesunomo oa mekala taneya. ");
INSERT INTO wiu_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Eni yene padeka-kiti Saiperase Sairini tatake opiane ali-kiti Adioke take pote mekete Ali Muno Yesunomo pa yatene ali atoa-palaka oa mekala taneya. ");
INSERT INTO wiu_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Nipa Ali Munoyo auapea yopikale oa mekala tokoli eni pa yatene ali atoa peya matiyame yakoa motekete oneke tepe kolotini pekoa pia lukoa meaneya. ");
INSERT INTO wiu_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Nitaneyake Yerusaleme take Yesuke wene tugoa meane-kitamepa eni tanemo yatekete tekete Banabasi takoa moa Adioke take poano pa wa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Nitaneyake Banabasi Adioke take nome mekome enekale Akolaliyo eni yene pewe witikome tadekale enekome wedia mekome okome Ali Munagole wedoa takama pamene wa kini wene weye akakala taneya. ");
INSERT INTO wiu_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banabasi einagopa epene wene pianeya meane ago. Epetane Yomini oneke awia tagatapeneya tokome Yesunole wedoa takama yakeneya. Nitane ago Adioke take eida mekakoa eni yene peya mati Ali Muno-pala lipukala taneya. ");
INSERT INTO wiu_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Wa padepete Banabasiyo Solo enemopou wa Tasase take tuku topaneya. ");
INSERT INTO wiu_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Tuku toa kawa enamutukome Adioke take pata wa wakapea aua pekeneya. Nitoa Adioke take poteta mekete odene malike Yesuke wene tugoa meane yene-pala obokala taneya. Obokala tekete ali atoa peya mati olaukoa kakeneya. Yesuke wene tugoa mekoi-kitipa Keraisuno ali atoa wa ibini ikilepa eida Adioke take titia taneya. ");
INSERT INTO wiu_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Einapete pake Akolaline agale akane ali pade-kiti Yerusaleme kawa Adioke take keti note menaneya. ");
INSERT INTO wiu_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Note meketepa eya ago Agabasiyo okome ta piko peyake kobu igi mati noo wa oa pianeya. Nipa Epetane Yominiyo wene takaka toa akeneya. (Eni kobu igi mati taatekakilepa Lomane ako tobou ago Kelodiasiyo ta piko peya yopia meane-pete taneya.) ");
INSERT INTO wiu_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Agabasiyo nimo okale yatekete Yesuke wene tugoa mekoi peyame kini Yudea take meki oya-mikiti auapeato wa padeya-kiti kini pikoi toa takoa oboa pikakala taneya. ");
INSERT INTO wiu_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Nitatekoa Banabasi Solota metekete ekete Yudea take Yesuke wene tugoa meki yene yopiki ali-kiti metekapoatino poe wa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Eina-pete laigoa tobou ago Erodeyo Yesuke wene tugoa mekoi yene padeka-kiti tete motokakala taneya. ");
INSERT INTO wiu_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Nitikomepa one poyo ali-kitame Yonene wamene ago Yame kabe teigamotoa taneya. ");
INSERT INTO wiu_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Nitikale tokome Yesuke wene tugamene Yu yene wedia mekoli enekome ena toane Pitaka mou wa one poyo ali-kitame dekoa motokamotoa moa wetekaneya. Enilepa Yu yename mono mono akamene palawe yoa nakene wa ibini akene toge kia mekoi-pete taneya. ");
INSERT INTO wiu_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Nitikale Pita dekoa moa aua note po yapu pitikakoli one poyo ali-kiti tuyono tuyono wa yopikakala tomotaneya. Nipa Yu yename eni toge kia nootokoa mekoika Pita moane eni Yu yenane lene yoto kakoane pitiane yakou wa Erodeyo wene pikome taneya. ");
INSERT INTO wiu_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Nitikale Pita po yapu eida pia mekalepa Yesuke wene tugoa mekoi-kitame Pitane kowitikoai taneya. ");
INSERT INTO wiu_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Erodeyo podolikama Pita moane pitiane yakou wa wene pia pitikakoa Pita po yapu pitikome atu pitikata poyo ago takuta one kouna takoa dekamoa pitaneya. Nipa kapa pota takuta kakoa kebetoa pitikaneya. Akolono kago keteponokeka poyo ali pade-kiti eida kakete yopikoa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Nitikakoa Ali Muno agono edelo ago Pita pitikata kotikatapea nome kakale one po yapu pitikata pa̱ toa kakeneya. Nitaneyake edelo agome Pitane podene wia kamotokakome okome wete kamokoa kamene wa okaka one yonoke kakane kapa pota kotokoa pitaneya. ");
INSERT INTO wiu_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Nitikale edelo agome okome neke matiu moa kawa neke kawa yeneka moa mekoa ta wa okale nitaneya. Nitikale okome neke tokoo mamina peteneka lobutukoano, no pukuka namene wa oa pekeneya. ");
INSERT INTO wiu_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Nitikale Pitayo litima pokomeke edelo agome tokalepa niminile toko wa wene toameneya. Nipa ipa pulete tukutu patu wa wene pia pekeneya. ");
INSERT INTO wiu_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Nitoa edelo ago Pitata poyo ali tuyonome yopia kakoi kago patukoa penaneya. Wa eina toa poyo ali tuyonomeka pade kago yopia kakoita patukoa ponetekoa kapame latiane kago keteponoke tugoa kapaneya. Nitikoli ena kago one weneme pekale akolono witoata pekeneya. Nitoa batete ludu pote ka katepake edelo agome Pita tewitikoa pekeneya. ");
INSERT INTO wiu_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Pokalepa Pita one-pala tokale niminile tadeko wa wene tokome okome Erodeyoka Yesuke wene tugamene Yu yenameka no i ago tete meou wa wene pokoinake Akolaliyopa one edelo ago moa wetekakale toa motokome tadeko wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Nitoa eni wene kibututukoapa Yone one pade ibini Make einagono nine Mariane yapu pekeneya. Eni yapu keneke ali atoa peya mati oboa mekete Pitane kowitikoa meaneya. ");
INSERT INTO wiu_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pita eni yapu kagoke pome kakome wi wi tokale yatekome yapu pupu atoa pade Rodayo kago pekademe nome yatekale ");
INSERT INTO wiu_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Pitayo okomokale yatekome wedikome tokome kago pekameneya yapu kouna lono teyapea pokome okome Pita kago kene akolono ku nome kakome toko-kale ekete ");
INSERT INTO wiu_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","leau eke oko-koli okome e̱'e mena. Pita kagoke ku kakome toko wa okala tokale ekete ni tadekopa Pita one edelo ago latia nome kakome toko wa wene toamekete akeneya. ");
INSERT INTO wiu_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Nitikakoa Pitayo akolono kago wi wi toa kakale note kago peetapekete enekete ekete ekee inapa Pita tadeko wa ka̱ oa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Nitikoli Pita yoname kawikatekoa kakomepa Ali Munoyo edelo ago moa wetekakale po yapu nome akolono aua pokanakamo i i wa to̱awea akeneya. Nimo ootokoa kakome okome kipala i ukumo Yameka anu ete oya-mikitika mekoika to̱awea akapoe wa oomotokome padeya pekeneya. ");
INSERT INTO wiu_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Podolikama pene ta patakaka poyo yename ekete ekee inakago Pita manika pokome pokato patu wa poome kau kau yakeneya. ");
INSERT INTO wiu_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Erodeyopa einago wete tuku topoe wa okale tuku tokoa kawa teko tokale wakoli eya taneya. Ete piapa Pita yopia kakoina poyo ali-kiti pitia yakatekoapa einago yopia potokadeki wa ootokoa kakome i poyo ali-kiti wia tukoe wa ete poyo ali-kiti moa metaneya. Nitimotokome Erode Yudea ta tewitikoa Sisaria take keti pome mepaneya. ");
INSERT INTO wiu_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Erodeyopa Taia Saidone tatake pitikoi yene-pala kotimi yoa meaneya. Nitikalepa eni yene koukoa nekete one pitika yapu luku talo tokago Bilasasiyo kiwi auapemotoa oya kakatekoa Erode mekata nekete ekete tone noateko neepa neke take-kama topo toa monokala tokono, odene wene piato wa kowitaneya. ");
INSERT INTO wiu_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Nitaneyake ipete wa namene wa oi metekana-pete eni yene wa nokoli Erodeyo tobou ago kawateka mamina-mene moa kawa tobou ago meateka walaike pome mekome eni yene-pala agale oa metaneya. ");
INSERT INTO wiu_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Nitikale yatekete kayo ekete ekete inapa alime oko toa mena. Akolaliyo oko toa eni okono, yakatoe wa kayo oa kakoli ");
INSERT INTO wiu_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","eina eina Akolaline edelo ago padame one winaneya. Erodeyopa ipa Akolaliyo wene takako toane uku wa Akolali kei piamokale tokome taneya. Nitikalepa pukiname tepe noa te̱ianeyake tukome tuaneya. ");
INSERT INTO wiu_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Nitaneyake Akolaline agale ta piko peyake oa pupitikama pekeneya tokome ali atoame yakoa moma-kala pekeneya. ");
INSERT INTO wiu_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Banabasi Solotame Yerusaleme pekete tatikoa metekatekoiya-kiti tatikoa meemotekete Adioke take wakapea pekeneya. Nipa Yone one pade ibini Make einago-pala aua pekeneya. ");
INSERT INTO wiu_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Adioke take losu yapu oboai toa Akolalinele takakoi-kitipa padekame one agale to̱awea akoa padekame onekemo pine to̱a olaukoa taneya. Eya yename nitoa meaneya. Banabasi ni Simione ni Lusiasi ni Maneyene ni Solo. Simione one pade ibini Naisa wa akeneya. Lusiasi onepa Sairini take ago. Maneyene einagopa Erode-pala tau takoa egetane ago. Eni Erodepa tubetoa wetini toa kakome Galili ta yopia kakeneya. ");
INSERT INTO wiu_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Eni yename Akolalinele takoa mekete nee wawa mekoika eya taneya. Epetane Yominiyo kiwi wene takakome okome Banabasi Solotame anu pade pupu takamotoane kayo okouno, anu eni pupu takamotoa einagota moa kakamene wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Nitikale eni yename nee wawa kowititikoapa nitato wa yono pia wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Epetane Yominiyo okana toa tekete wetekakakoli Banabasi Solota Selusia take keti pote pipaneya. Piimoteketepa tube ue dipike peapetekoa mea Saiperase take pote mepaneya. ");
INSERT INTO wiu_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Saiperase ta keneke piko Salamise take pote mekete Yu yenane losu yapu kaka toa Akolalinemo oa mekutu toma pokoli tuali Yone opia pokome auapema pekeneya. ");
INSERT INTO wiu_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Saiperase ta ludu pima yawa eka matanu lono Pepose take pekete otoi ago pade Ba-Yesu wa ibini akene ago kotuaneya. Einago Yu yatene agomepa Akolaline agale akama yakuna wa oa meake otoi ago mekome ali atoa oa yotokakala taneya. ");
INSERT INTO wiu_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Einagopa Saiperase ta yopia kakago Sesiasi Polasi-pala opia-kama yakene ago. Eni ta yopikago Sesiasi Polasi wene muno meane ago tokome Akolaline agale yakademe okome Banabasi Solota oto nomotoa wa agale oa wetekakale nekeneya. ");
INSERT INTO wiu_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Nitikoli tobou agome kini agale yakoa motokaya tokale Elimasi wa ibini akene agome kita-pala neno oa kakeneya. (Einago Geriki agaleke Elimasi wa ibini ikilepa otoi ago wa ekete iki.) ");
INSERT INTO wiu_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Nitikale Solo one pade ibini Polo wa akene agome eya taneya. Epetane Yomini oneke awia tagatapekale kakome eina otoi ago nepikakome okome ");
INSERT INTO wiu_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","nepa nipa Setanuno peku noa tokagono, padele padele ki̱yo akenele-kiti moa agopa takade wili tokoa kawa poanele-kama toa ali atoa oa yotokoa toko. Akolaliyo nimini akene agale pamo tetepo takoa koigaku peke toapa manipete wako patu. ");
INSERT INTO wiu_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Akolaliyo ne kibu moono, nepia. Opii-mene neke leneta liitapeneya yake lou pa̱ka enameneya pa yawa meoo wa Poloyo okale eina eina one lene libu takatapekome yomiyomume agopa takaneya. Nitikale one yono moa aua yawatekago tuku toa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Nitikale enekome ta yopikagome okome Ali Muno agonomo i agotame olaukoa kakipa etene nimini akediki wa wene kainya pianeya kakome yakoa motaneya. ");
INSERT INTO wiu_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Nitaneyake Poloyoka one oya-mikitameka Pepose ta tewitikoa ue dipike peapetekoa mea pote Pabilia ta keneke piko Peka take witapeneya. Eidapa Yoneyo o yene tewitikoa Yerusaleme take wa wakapea pekeneya. ");
INSERT INTO wiu_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Nitaneyake o yename Peka ta tewitikoa Pisidia ta keneke piko Adioke take pote mepaneya. Eidapa ko mea pupu toamene-pete losu yapu tuapea pote witipitoa meaneya. ");
INSERT INTO wiu_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Nitoa mekoli Mosesene agale tiginika Akolaline agale papete to̱awea akane ali-kitame akene agale tiginika oi moa peya takakete losu yapu talo tane ali-kitame eya taneya. Agale wetekakete ekete oya-lawe i oboa meki ali atoa auapeatiki agale oa meadete eketepa yakamotono oe wa akeneya. ");
INSERT INTO wiu_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Nitikoli Polo kamokoa kakome yono pitikakome okome Iserele ali-kitika Akolalike nate wene pia one kowitoai tiki pa yatene ali-kitika kiwi peya-pala i ukuno yakoe. ");
INSERT INTO wiu_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Iserele yenane Akokaliyo tone kaua-mikitipa one wa takoa motaneya. Nitaneyake mone Idipi take pote mea kakoli pewe wia kakale eida pitikali opia tagatapeneya. Wa naniko Akolaliyo padele padele telekole toa eni ta tewitikoa aua pekeneya. ");
INSERT INTO wiu_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Nipa mali padeka noi kakoa (40) ponoka toa-kama tone kaua-mikiti mama moa ali piamene take egetoa aua yakeneya. ");
INSERT INTO wiu_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Nitimotokome Kenane ta ludu pitane yatene tatono kakoa (7) yatene wia atukoa eni yatenane ta tone kaua-mikiti kini wa yametaneya. ");
INSERT INTO wiu_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Nipa mali ege kadukaka pogime kadukoa (450) mali ponoka toa edikoa pewe wia yopia kakeneya. Nititikaneyake kini tanele takoa enoa akatekoi ali-kiti Akolaliyo moa kakama pome wipitikomepa one agale akane ago Samuele moa kakaneya. ");
INSERT INTO wiu_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Nititikaneyake tone kaua-mikitamepa kini Ali Muno meatekago neme takoa moa kakakamene wa Akolali kowitoai tokoli Bedamine yatene ago Kisene mana Solo takoa moa kakakaneya. Nitaneyake mali padeka noi kakoa (40) ponoka toa Solo einago Ali Muno mekome talo toa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Akolaliyo einago Solo katekatekoa one luku Depidi kini Ali Muno moa kakakaneya. Nitoapa Depidi kei pikome okome i agopa Yesine mana Depidi nota odene wene pianeya yakagono, anu wene pikule-kama too wa one kei pianeya. ");
INSERT INTO wiu_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Wa wipitikome toto Yu yatene toa momotoa tikilepa einago Depidike tagakago Yesu moa kakaneya. Nipa kiwi yatene auapekene dikou wa papete oa pikana toa taatekoa taneya. ");
INSERT INTO wiu_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Yesu wete taatekoa noameneyake Yone namolo takoa nokome Iserele yene peya kini namolo poane wene wia wawa tepe kolotini pekoa piatino, ue moamene wa mo wima yakeneya. ");
INSERT INTO wiu_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","One eni pupu toa peya takateka tigotokale kakome okome nopa edane ago kakuno wene piki-pe. Papete oa piane toa taatekoa noatekagopa no mena. Nopa einago menake one naniko nomotoane no namolo takoane nuku. Einago nokolopa one auapekilepa toatekuyake pa ago tekene one kawa yeneka oyake kekamele toamoko wa Yoneyo oka. ");
INSERT INTO wiu_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Anu oya-mikiti Eberameke tagene yeneka Akolalike nate wene pia kowitoai tiki mone yeneka Akolaliyo ali atoa toa moateka agale oa wetekakilepa totoke oa wetekaneya. ");
INSERT INTO wiu_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Yesu taatekoa nokale Yerusaleme take pitikoi yenameka kini tobou ali-kitameka einago eni nekedeko wa wene toameneya. One wene toamekete koiso akakoipa nipa oneke papete oa piane toa taatekoa taneya. Einapa kini ko mea pupu toamiki-pete-kama Akolaline bokuke oneke wia mekane agale oi mokala tikiyake taneya. Nipa Akolaline agale papete to̱awea akane ali-kitame oneke papete wia mekapiane agale oi mokala tikiyake nitaneya. ");
INSERT INTO wiu_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Einagopa Pailase mekata aua pekete i ago wia tukakoano ta wa akeneya. Nipa one wia tukatekoi nami kawameadekaleka pa puputua taneya. ");
INSERT INTO wiu_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Nitoapa Akolaline bokuke oneke papete wia mekapianele-kama toa peya takatekoapa one tigini yomo lekaneyake wia dekaneya to̱a moapa tukoi-kiti piadete kokapiane kotake moa pipaneya. ");
INSERT INTO wiu_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Nitaneyake one eni tuaneya pikata Akolaliyo moa kamotokaneya. ");
INSERT INTO wiu_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Nititikaneyake eya yene Galili ta laigoa onepala opia yawa Yerusaleme take pokoina oya-lawe pono yametekala taneya. Nipa ta kainya mati pataka toa tokala taneya. Nitikale enekoiya tekete one eni oya-laweme toto Iserele yatene-pala dika dika wa to̱awea oma yaki. ");
INSERT INTO wiu_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Einapa Yesunomo kini wene epetekateko ko totome eya wa to̱awea oko. Akolaliyo kiwi yatene auapekene dikou wa tone kaua-mikiti-pala papete oa pikana toa taatekoa tokomepa kiwike tagene yene toto kako-pete Yesu tukale moa kamotokaneya. Eni toatekalekepa Akolaline bokuke taku takoa samo lo agale eya wa wia mekaneya piko. Nepa anu mana. Opi nopa neketai latiane meku wa Akolaliyo mana-pala akene toa wia mekaneya piko. ");
INSERT INTO wiu_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Akolaliyopa one tukale moa kamotokakale tigini wa lomuamatekaleke eya wa akeneya. Auapekene dikou wane Depidi-pala ki̱yo akenele toatekoumo oane pikouna toane ne auapekene taatekoane tou wa Akolaliyo mana-pala akeneya. ");
INSERT INTO wiu_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Enilekepa panagome Akolaline bokuke eya waka papete wia mekaneya. Nekele-kama takama pomotoa takoa motokago tukalepa lomumotoa neme wawamoo wa wia mekapianeya. ");
INSERT INTO wiu_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Depidiyo Iserele yene yopia mekome Akokalinele takoa peya takatekoa tua pekeneya. Nitaneyake one kaua-mikiti oloyo toai tanetake one yename oneka oloyo tokolipa one tigini eida lomuaneya. ");
INSERT INTO wiu_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Depidipa nitaneyake Akolaliyo moa kamotokane agopa lomukile toameneya. ");
INSERT INTO wiu_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Nipa anu oya-lawe kiwi eya wane wene takakene uku. Einago Yesuyo tokalekepa Akolaliyo kini poanele toma yakoike po letu mekakana keetapea mitikoo wa totome kipala to̱awea oko. ");
INSERT INTO wiu_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Akolaline leneke poanele toamene yene meadete Mosesene totono litia tootapeato wa kime wili toa kawa teko tokolo tetekoa poanele pa tiki. Nitikiyake Yesuke wene tugoa meki peyapa Akolaliyo poanele toamene yene tetepo takoa wene keaneya meko. Yesu tukaleke ni toko. ");
INSERT INTO wiu_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Akolaline agale papete to̱awea akane ali-kitame pubu akene toa kipala takayano, wedoa meamene. Akolaliyo akene toa eya wa pubu akeneya. ");
INSERT INTO wiu_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Tedu mea ya takoa tiki-kiti kipala eya wane uku. Anume tukule enoa ka̱ oa tuati. Kiwi meki-petepa padameka namolo toamokoinakale toadene tekene ni uku. Enilepa i i wa panagome to̱awea okaleka kime yakoa moamoi wa akeneya wa Poloyo e yene-pala oa kakeneya. ");
INSERT INTO wiu_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Nitaneyake Polo Banabasitame eni losu yapu tewitikoa poadete kakoika e yename ekete ye pupu toamatiki-pete wakapea note enika enimo wa oa menamene wa kowitaneya. ");
INSERT INTO wiu_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Nitoapa kini losule toa peya takatekoa padeka-kiti Yu ali-kitameka Yu yene-pala lipuane pa yatene ali-kitameka Polo Banabasita litia pekeneya. Litia nokoli e yene-pala ko oma pekete ekete Akolaliyo kiwi pewe wima pomotono, onekele wedoa takamoa pamene wa oma pekeneya. ");
INSERT INTO wiu_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Wa ye ko mea pupu toamatekoi-petepa eni take pitane ali atoa pa natetekoa kamotoa ete peyame Ali Munagonomo yakadete koukoa nekeneya. ");
INSERT INTO wiu_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Koukoa note kakoli enekete Yu yene wene mati poologaneya kakete Polo-pala neno oa tea agale oa taneya. ");
INSERT INTO wiu_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Nitikolika Polo Banabasitame piti moameneya kakete ekete Akolalinemo oa metekilepa Yu yene kipala namolo takoa ato wa totome oa metekoyake kote tokolo waki. Nipa kipa Akolaline take mea kamele toamene tetepo takakete ikili tokome kiwi tewitikoa wawa mone pa yeneke poo. ");
INSERT INTO wiu_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Tone Ali Muno agome tamene wa oka toa toadete toko. Eya wa oka. E ku mone pa yatene-kiti pa̱ takalogamene wane kiwi moane kakapikouna. Nipa e ku yatene ta piko peya pitiki toa pekete kiwi toane motukumo oa pupitikakamotoane tekene tokouna wa Ali Muno agome oka wa Poloyo akeneya. ");
INSERT INTO wiu_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Nimo okale yatekete e pa yatene ali atoame ke wa Ali Munono agale kei pia kakeneya. Nitaneyake Akolaliyo mea kama pomotoa takoa moopiane ali atoa peyame Yesunomo yakoa motaneya. ");
INSERT INTO wiu_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ali Munono agale eni ta piko peyake oa pupitikatapeneya. ");
INSERT INTO wiu_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Nitaneyake Yu yenamepa Polo Banabasitane agale yakamatoe wa Akolalinele takama yakene ibini akene atoa-kitika eni take tobou meane ali-kitika oa kamotokama yakeneya. Nitoapa einagota tete meetekoa kini ta tewitikoa poe wa tikatapeneya. ");
INSERT INTO wiu_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Nitikoli einagotame kiwika tewitikoa wako wa kini kawake kakene kege tadamotekete Aikoniame take pote mepaneya. ");
INSERT INTO wiu_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Nitaneyake Yesunomo yakoa motane yename ke wa wedia meaneya. Nipa Epetane Yomini kiwike awia tagatapeneya kolotine meaneya. ");
INSERT INTO wiu_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Adioke take tokoinakale Aikoniame takeka wa einakale taneya. Polo Banabasita Yu yenane losu yapu pote kakete Akolaline agale wedoa oa metekoli yatekete Yu yeneka mone pa yeneka peya matiyame e̱e, nimini iki wa