﻿USE sofia;
DROP TABLE IF EXISTS sofia.wim_vpl;
CREATE TABLE wim_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES wim_vpl WRITE;
INSERT INTO wim_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Namp inangan wuut mangk nungantam Jesus Christ.antamana. Nil Jesus.ana wuut mangk David alantaman wampa. Nil David.ana wuut mangk Abraham alantaman wampa. ");
INSERT INTO wim_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Nil Abraham.an piip nungantam Isaac.antama; nil Isaac.an piip nungantam Jacob.antama; nil Jacob.an piip nungantam Judah alantaman aꞌ putha kuunch nungantam yot al-alantamana, piip niliya. ");
INSERT INTO wim_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Nil Judah.an piip pulantam Perez aꞌ Zerah. Kaath pulantaman Tamar. Nil Perez.ana piip nungantam Hezron.antam; nil Hezron.ana piip nungantam Ram alantama; ");
INSERT INTO wim_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","nil Ram.ana piip nungantam Amminadab alantamana; nil Amminadab.ana piip nungantam Nahshon alantaman; nil Nahshon.ana piip nungantam Salmon alantaman; ");
INSERT INTO wim_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","nil Salmon.ana piip nungantam Boaz alantamana, kaath nungantamana nampa, Rahab. Nil Boaz.ana piip nungantam Obed alantaman; aꞌ puth kaath nungantamana Ruth. Nil Obed.ana piip nungantam Jesse.antama; ");
INSERT INTO wim_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","nil Jesse.ana piip nungantam King David.antama. Nil David.ana piip nungantam Solomon.antama; kaath nungantamana, Bathsheba, nil kaꞌathaman wanch thum nungantam Uriah alantamana. ");
INSERT INTO wim_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Nil Solomon.ana piip nungantam Rehoboam alantamana; nil Rehoboam.ana piip nungantam Abijah alantamana; nil Abihaj.ana piip nungantam Asa alantaman. ");
INSERT INTO wim_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Nil Asa.aniya piip nungantam Jehoshaphat alantamana; nil Jehoshaphat.ana piip nungantam Jehoram alantamana; nil Jehoram.ana piip nungantam Uzziah alantamana; ");
INSERT INTO wim_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","nil Uzziah.ana piip nungantam Jotham alantamana; nil Jotham.ana piip nungantam Ahaz.antam; nil Ahaz.ana piip Hezekiah.antam; ");
INSERT INTO wim_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","nil Hezekiah.ana piip nungantam Manasseh.antama; nil Manasseh.ana piip nungantam Amon alantamana; nil Amon.ana piip nungantam Josiah alantamana; ");
INSERT INTO wim_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","nil Josiah.ana piip nungantam Jehoiachin alantamana aꞌ puth kuunch nungantam al-alantaman. Aak an-aniyangan than pam wayanang soldiers al-alangan Israelites anangan kenthin thanang aak thanttam anpalana, aꞌ aak Babylon aakanakan kalin thanang ngula. ");
INSERT INTO wim_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Than kanan kalin thanang aak Babylon.akan-a, nil Jehoiachin.ana piip nungantam anan wun Shealtiel alantaman; nil Shealtiel.ana piip nungantama Zerubbabel alantaman. ");
INSERT INTO wim_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Nil Zerubbabel.ana piip nungantam Abiud.antama, nil Abiud.ana piip nungantam Eliakim alantam; nil Eliakim.ana piip nungantam, Azor.antama; ");
INSERT INTO wim_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","nil Azor.ana piip nungantam Zadok alantamana; nil Zadok.ana piip nungantam Achim alantamana; nil Achim.ana piip nungantam Eliud.antam; ");
INSERT INTO wim_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","nil Eliud.ana piip nungantam Eleazar.antam; nil Eleazar.ana piip nungantam Matthan alantaman; ");
INSERT INTO wim_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","nil Matthan.ana piip nungantam Jacob.antama; nil Jacob.ana piip nungantam Joseph.antama; nil Joseph.ana, pam anan Mary.an ngentan, kaath Jesus.antaman — nil Jesus inana Messiah.an waaꞌ-waaꞌin nunang, puth nil God.angan kaaꞌngak ngampangan kuchow nunangan aak iikanakan. ");
INSERT INTO wim_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Namp inanganiy wuut mangk Jesus.antamana. Aak anpalmana nil Abraham.an wun-a, aak-aakanakaman nil David ngulan wuna, wuut mangk fourteen anangaman iiyin. Aꞌ aak anpalmana nil David ngulan wuna, aak-aakanakaman than pam wanch Israelites.an kalin thanang aak Babylon.akana, aniy-a, wuut mangk fourteen puungk wiy ngul wun-wunin nungantamana aꞌ aak an-aniyangan-a, aak-aakanakaman nil Jesus Christ.an aak-ngeey ngula, wuut mangk fourteen puungk wiy anangan ngul wunin nungantamana. Aꞌ niliya thaaꞌ-koyyuw ngul wamp-wamp wuut mangk yot al-alantamanweya. ");
INSERT INTO wim_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Wik kath inan nil Jesus.an aak-ngeeya. Nil kaath nungantaman Mary.an-a, pam kaaꞌngakin nunang Joseph.ana, puth pulana karpam keꞌam yippak wun-wunpul yaꞌa. Aak an-aniyangan nil Mary.an iimpanang ngul iiy-iiy. Aꞌ nil Joseph.angan thiichan nil iimpanangan iiy-iiy, nilan ngaantam-ngeeya keꞌ pam thonantang wuna, puth yaꞌa, nil Ngeen-Wiy Min God.antamangan kuchant puk manyana — nil nanpalan iimpanang ngul iiy-iiya. ");
INSERT INTO wim_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Puth nil Joseph.ana keꞌam yippak ngaantam-ngeey nil Ngeen-Wiy Min God.antamangan kuchant. Nil pam inman Joseph.ana nil pam min-minam paththam iiy-iiy, pam way yaꞌa, nilan ngaantam-ngeey nungantakaman, “Ngay wiyantan kaangk keꞌ waaꞌāng, ngay keꞌ pench-wayathing nunang meeꞌ yotantangan. Ngay maꞌ-mupam anman too wantāng nunanga,” nilan yimanang ngaantam-ngeey nungantakaman. ");
INSERT INTO wim_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Amanamaniya nil Joseph.ana weep thayan ngul wun-wun, aꞌ pith-pith ngul. Nilana yimanang pitha nil ngaantiyongk God.antam inpal kenyan uk nungant aꞌ thaw nungant, “Ayyang Joseph-ang, kampan David.antam-ang, nint winynyang keꞌ moꞌān a! Nint Mary.ana ngentān nunang aꞌ kalān nunang aak nungkaramaka. Nil Ngeen-Wiy Min God.antaman wamp nunganta keꞌ-paal nil iimpanangan iiy-iiyana. Pam wiyantam yaꞌa, puk many Ngeen-Wiy God.antama, nil kucha. ");
INSERT INTO wim_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Yaa, nint kan in ngeey a! Nil wanch ilangaman Mary.angana puk wuut many kalow. Nintaniya namp inan theeꞌān nungant Jesusa, puth nil thonamang ilangaman pam wanch nungantam anangan ngul kaaꞌ-piichanathow thanang way thanttam amanamana.” ");
INSERT INTO wim_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","23","Aak keenkanamana nil God.an thaw nungant Isaiah.antan, “Wanch koman thonam pik keꞌananga ngul iimpanang iiyow aꞌ puk wuut many ngul kalow. Thananiya namp inan theeꞌayn nungant Immanuel. Namp inaniya wik ngamparamangan thawanamp yimananga, ‘Nil God inman ngamparanga.’ Nil pam prophet Isaiah alangan keenkanaman wik inangan lat ngench thayanangan umpa, wik inanganiy-a, kan-kanam ngul wampin.” ");
INSERT INTO wim_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Aꞌ nil Joseph.ana kan-ngul ek weepamana, aꞌ Mary.ana kal nunang aawuch nungantamakan, keꞌ wik anman nil ngaantiyongkan thaw nungant. ");
INSERT INTO wim_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Mary.ang pul Joseph.angana karp keꞌam yippak wunpul yaꞌa. Puk many kanan aak-ngeey-a, pulana karp ngul wunpul. Nil Joseph.angan-a, namp inan theeꞌ nungant puk wuut many alantana Jesusa. ");
INSERT INTO wim_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Nil Jesus.ana aak Bethlehem.angan aak-ngeey, aak angman Judea.angan. Nil Herod.ana pam wuut piꞌan King aak wak-wak, nil an-aniyangan meeꞌ-pench puk many Jesus.ana. Ngul yaam keꞌanama, pam koꞌalam pal kaaw ukin um kuuw aak Jerusalem.akan, pam inanganiya work thantweya thunp anangan thath-thathin. ");
INSERT INTO wim_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Aꞌ than pam anangamana engkin pam wanchantana, “Puk manyan wanttin meeꞌ-pench e? Nil ngulan pam wuut piꞌan King iiyow Jews.antana? Puth ngananiya thunp wuut piꞌan thathan nungantamana anpal kaaw mata. Nganan keꞌ-paal pal wampan thaaꞌ-kuumpān nunang puk manyana.” ");
INSERT INTO wim_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Nil King Herod.angan wik inan ngeey-a, aniy-a, ngangk way-wayam paththam wunant, aꞌ putha pam wanch aak Jerusalem.angan wun-wunina, than yimanangwey ngangk way wun thanta. ");
INSERT INTO wim_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Nil puth King Herod.angan pam priests anangan churchan piꞌ-piꞌinana, yalmath thanang aꞌ puth pam piꞌan anangan wik thayan anangan thaaꞌ-aath-aathin thanangana, niliya thanang thamp yalmath aꞌ engk thantwey, “Nil Christ.ana aak wantting meeꞌ-penchow e?” ");
INSERT INTO wim_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Thanan thawin nunganta, “Aak town angman Bethlehem.ang meeꞌ-penchow aak ingman Judea.angana puth nil Micah alangan wik God.antam inangan keenkanamana ump lat ngench thayan angan: ");
INSERT INTO wim_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Aak Bethlehem.ang aak angman Judea.anga aak manya, puth aak ananiy-a, wuut piꞌan paththam ngul wunow, puth aak anpalaniya moom piꞌan paththam ngul wampowa, aꞌ nilan min-minam piꞌow pam wanch ngatharam Jews anangan.’” ");
INSERT INTO wim_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Aꞌ nil King Herod alangan pam koꞌalam anangan pokkapang ump thanang nil yipam engkow thant aak ngeenan thathin thunp piꞌanan mata. Aꞌ thanan waaꞌin nungant. ");
INSERT INTO wim_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Amanamaniya, nil kan kuch thanang aak Bethlehem.akan. Aꞌ nil thaw thant, “Niiy kan iiyāna, aꞌ min-minam wenkān puk many alantan. Niiy kanan uwān puk manyan-a, palam iiyān ngathar, aꞌ waaꞌān, ngay yipam iiyāng thamp, thaaꞌ-kuumpāng nunang puk manyaniya.” ");
INSERT INTO wim_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Aꞌ than kan-ngul iiyin, than thunp wuut piꞌanan thathin, thunp thonam anman than kaꞌathaman thathin mal kaaw angman wun. Anpalaniya thunp wuut piꞌanan umputh moꞌ woyan meenathow thant, aꞌ popam ngul wun aak angman puk manyan wun. Than pam koꞌalam anangana ngangk min wun thant, thunpan thathin nunang popam ngulan wuna. ");
INSERT INTO wim_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Than kanan wampin-a, than pek ngoonchin aꞌ puk manyan thathin nunang aꞌ putha kaath-kunchan thathin nunang thamp Mary.an. Thanana pungkang thuchin um nungant puk many alantan, aꞌ thaaꞌ-kuumpin nunang. Amanamaniya, than yuk bags thanttamana thapathin, yuk way min yipam theeꞌayn puk many alantan — yuk golda, putha opar awal min anangan theeꞌin nungant, frankincense aꞌ puth-a, myrrh. ");
INSERT INTO wim_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Anpalaniya, nil God.angan pithangan wik thayanath thanang koyam keꞌ iiyayn King Herod alantan. Aꞌ than koyam ngul iiyin aak thanttamakan woyan thonangan ngul wakin aakakana. ");
INSERT INTO wim_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Than pam koꞌalam al-alangan aak kanan wantin-a, ngaantiyongk piip God.antaman inpal kenyan uk, aꞌ Joseph.antan pithang thawant, “Nint erkam ekāna, aꞌ maꞌ-kaath-pukana kalān pulang aak Egypt aakanakan. Puth nil King Herod.ana kan-ngul thawow thant soldiers al-alantan puk many nalantana wenk-wenkayn ngula thanan yipam mulathayn nunanga. Aꞌ niiyiya aak Egypt angman wun-wunāna, ngay palaman ngul wampāng nungk wik thampana waaꞌāng yipam aak Egypt.an wantān ngula.” ");
INSERT INTO wim_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Nil Joseph.ana erkam wur ek, aꞌ puk many putha kaath-kunchana kal pulang. Than aak ngutang anman wantin, aꞌ kan-ngul iiyin aak Egypt.akana. ");
INSERT INTO wim_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Angman ngul wun-wunin, ngul-ngulaniya King Herod.an utham ngul. Nil Joseph.angan kal nunang Jesus.an aak Egypt.akan-a, inan yipam meenathow ngampar nil prophet Hosea.angan lat ngench thayanangan ump nungantaman aak keenkanaman-a, an kan-kanam paththam nilan waaꞌ-waaꞌ, wik God.antam inangan, “Ngay nhengk ngatharaman palam umpang nunang aak Egypt anpalana.” ");
INSERT INTO wim_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Aꞌ pam piꞌan Herod alangan kan ngaantam-ngeey than pam koꞌalam anangan wampin aak Bethlehem.akan-a, thananiya woyan thon ngul wakin koyaman iiyin aak thanttamakana. Nil ngaantam-ngeey nungantakamana, “An ngayang yaan muukamathinweya,” aꞌ nilana man kul paththam wamp-wampant pam piꞌan Herod alantan. Nilana ngaantam-ngeey ngul than pam koꞌalam al-alangana aak kaꞌatham anpalana wik anan waaꞌ-waaꞌin nunganta thunp alantamana. Nilaniya meeꞌmiy ngul weena kaap kuchamang kanan want-a, than thunpan an-aniyangan thath-thathin ngula, keꞌ-paal nilan thaw thant pam soldiers al-alantana, “Ayyang, puk wuut manyiy maꞌmangkam ananganiy-a, niiy mul-mulathān thanang, puk many chil piꞌan kaap kuchamangan want thananganwey-a, aꞌ putha puk wuut manyiy thaaꞌ-paapiy anangan mul-mulathān thanang thampa aak Bethlehem anpalmana puth-a, aak thinthan than-thantana.” ");
INSERT INTO wim_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Aak way inan wamp-a, inan meenath ngampar nil prophet Jeremiah.angan keenkanaman lat ngench thayanangan ump-a, aniya kan-kanam paththamwey ump, wik inangan: ");
INSERT INTO wim_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Pam wanch yotam anangana othamayan peey-peeyantan nath-nathaniya wuut manyiy thanttam al-alantamana aak Ramah.ang angan. Than puth kan-kanam ngangkan way-wayam paththam wunan thant kaath piipantaniy. Aꞌ wanch aak Israel punchananiya peey-peeyantan puk wuut thanttamantamana. Ngangk minan weeꞌangam yump-yumpiy thanang wanch yotam ananganweya? An yaꞌangam, ngangk min keꞌ wuniy thant, yaꞌa, puth puk wuut manyiy yotaman thanttamana mul wun-wunin ngula.” ");
INSERT INTO wim_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ngul-ngulana nil pam wuut piꞌan Herod.an kan-ngul utham. Aꞌ nil ngaantiyongkan inpal kenyan uk ngul piip God.angan kuchan. Nil wamp nungant Joseph.antan, ");
INSERT INTO wim_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","aꞌ pithang thawant, “Ayyang, eka! Nint kan kalān pulang maꞌ-kaath-pukana aꞌ koyam iiyān aak Israel.akana. Than Herod weeꞌanangan keꞌ mulathiythan nunang puk manyan-a, an puth yaꞌ, an nil kanam uthama, Herod.ana.” ");
INSERT INTO wim_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Aꞌ Joseph.ana ek ngul, aꞌ kal pulang maꞌ-kaath-pukana, koyam iiyin aak Israel.akana. ");
INSERT INTO wim_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Aꞌ nil Joseph.angan wik many ngeey puk nhengk nungantam Herod.antamana, namp nungantaniya Archelaus puth nil ngul pam wuut piꞌanan iiy-iiy thant aak Judea.akan. Nil puth Joseph.an winynyang moꞌ aꞌ kaangk keꞌ aak Judea.akan iiyowwey. Aꞌ nil ngaantiyongkan inpal keny uk, aꞌ putham ngul wampant, aꞌ pithang thawant Joseph.antan, “Niiy mal kungkam iiyāna aak Galilee aakanakana.” ");
INSERT INTO wim_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Aꞌ than kan-ngul iiyin aak Galilee aakanakan, aꞌ wampin ngul aak town Nazareth.angan, yaa, puth angman ngul wun-wuninwey. Nil Joseph.ana aak angman ngul wun-wun aak Nazareth.ang-a, inaniy meenathan ngamparaniy pam prophetsangan lat ngench thayanangan umpin keenkanaman-a, an kan-kanam waaꞌin nunang puk many Jesus.ana. Than wik inangan umpina, “Thanan waaꞌayn nunang pam aak Nazareth punchana.” ");
INSERT INTO wim_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Anpal ngulana, nil pam John.an aak pintalangan iiy-iiy aak Judea.angan, kan-ngul waaꞌ-waaꞌ wik God.antaman, pam John anman nilan pam wanch yotan kootra ngakangan kuungk-kuungk thanang. ");
INSERT INTO wim_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Nil thaw-thaw thant, “Way niiyan yumpaniya niiy kan-ngul wantān a! Niiy palaman God.antan weentānwey a! Aak thinth kan-ngul wampan nil God.angan maꞌ nungantangan piꞌ-piꞌow thanang pam wanch anangan.” ");
INSERT INTO wim_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Aak keenkanama, nil pam prophet Isaiah.angan pam John.an inman waaꞌ-waaꞌ nunang, lat ngench thayanangan. Nil wik inangan waaꞌ: “Nil pam thonam iiy-iiyow aak pintalangana aꞌ wik inangan pech-pechow, ‘Niiy woyan min-minam kan yumpān nungant Lord.antana, koochanam yumpān nunganta nil yipam iiy-iiyowa.’” ");
INSERT INTO wim_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ngook nil John.angan ngooncha, minh camel thuuꞌam, aꞌ ompaman kath nungantakamana minh peꞌanangweya. Nilaniya may at mungk, aꞌ puth-a, minh pongkok mungk. ");
INSERT INTO wim_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Pam wanch yot wampin nungant John.antan, aak Judea.am nath-nathpalan wampin, aak Jerusalem anpalan thak wampina, aꞌ putha pam wanch aak thinth punth Jordan.am anpalan wampin woꞌuwaynam anpalan wampin aꞌ wonk palam anpalan wampin. ");
INSERT INTO wim_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Than waaꞌin thanttakaman John.antan way thanan yump-yumpin, aꞌ putha nil kootra ngakang kuungk-kuungk thanang ngul punth Jordan.ang angmana. ");
INSERT INTO wim_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Aꞌ pam piꞌ-piꞌanam yot wampin nungant John.antan kootra kuungkow thanang thamp, pam Pharisees aꞌ Sadducees waaꞌantan thanang. Nil John.an thaw thant, “Niiy thuuk inangana pal ngathar ngul wampaniy ey? Niiyang weeꞌang wik thayanath appenchān nungantam God.antaman e? nil puth man kul paththam wamp nungant niiyantakana! Puth aakan kan-ngul wampan nilan um nungantangan thanathow ngampangana puth mepow ngampanga. ");
INSERT INTO wim_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Niiy kan min yumpān a! Niiyaniya meenathān niiyantakamana niiyan kan-ngul wantan way niiyan yump-yumpana. ");
INSERT INTO wim_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Niiy ngaantam-ngeeyaniy nil Abraham.an wuut mangk ngamparam putha, nil keꞌ-paal piip God.ana man kulan keꞌ wampiy nungant ngamparakan ey? An yimanangan keꞌ ngaantam-ngeeyāmpa! Puth inan ngeeyāna: kaangk nilwey-a, piip God.angan kunttow inangan epankathiy puk Abraham.antakanweya. ");
INSERT INTO wim_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Nil God.angan pam wanch thanathow ngampang-a, nil keꞌ pam yuk thayan maꞌang kal-kalow yimanangan, keꞌ yukan ump-umpiy thananga. Yuk anangan may min keꞌaman kalan-a, ananganiya, nil thayanang thalokang umpow, aꞌ keekathow thanang, aꞌ amanamaniy-a, piw theeꞌow thanang thumang ngula. In ngeeyān a! Than weeꞌ-weeꞌanangan wayan yump-yumpantan-a, than keꞌ yuk way anangan may keꞌaman kal-kalana. ");
INSERT INTO wim_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ngayana niiyang kootra ngakang thonakam kuungk-kuungkanga, yipmam meenathāng thant wiyantan niiy koyam kanam weentan God.antan, aꞌ wayan kanam wantan. Puth pam thonangan ngul wampow mangk ngatharangana, puth nilaniya Ngeen-Wiy Min God.antaman ngul kuchow niiyant nil keꞌ thum yimanangan niiyant, ngangkangan ngoonchow. Puth nilaniy ep-paththam pam wuut piꞌan paththama, ngay yaꞌa, ngay pam manyweya. Ngay thaꞌ murruk nungantaman maꞌang kaling ey? yaꞌa, ngay puth pam many. ");
INSERT INTO wim_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Nil pam inmana an keꞌ pam gardener yimanangan wampow nil yuk nungantaman maꞌang kal-kalow yipmam wookan yaarkathow may min amanaman, aꞌ nil yipmam may min anangan yalmathow aak nungantamakana, wook way anangana, nil thumang kiingkow thanang, thum keꞌaman uthaman, angan pench-penchow,” nil John.an wik yimanangan thaw thant. ");
INSERT INTO wim_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Aak an-aniyangan, nil Jesus.ana aak Galilee amanam iiy aak punth Jordan.akan, nil John.angan kootra ngakang kuungkowan. ");
INSERT INTO wim_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Puth nil John.an thaw nungant, “Appang, ngay keꞌa! Nint ngayang paththam kootra kuungkāna, puth yaꞌ ey? Nint pal ngathar wampan ey? ngay kootra kuungkāng nintang ey?” ");
INSERT INTO wim_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Puth nil Jesus.an thaw nungant, “Nint kuungkān ngayang, mak yimanangan wunow, puth nil God.angan kaangka ngal yimanangan yumpāla.” ");
INSERT INTO wim_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yaa, puth nilana kootra ngakang kuungk nunang, Jesus.an. Aꞌ nil kanan kootra ngakangan kuungk nunang-a, nil Jesus.aniya ngakam pent, aꞌ in kenya yuwan yaꞌ ik, aꞌ nil Jesus.angan Ngeen-Wiy Min God.antaman thath nunang pal kenya uk-uk nungant keꞌ minh kolat yimanangan wamp nungant. ");
INSERT INTO wim_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Aꞌ wik inpal kenyan thaw, “Nint nhengk ngatharam a! Ngay kaangk paththam wunang nungkar. Ngay ngangk min-minam paththam wunang nungkaramana.” ");
INSERT INTO wim_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Nil John.angan kanan kootra kuungk nunang Jesus.an-a, nil Ngeen-Wiy God.antam alangana kal nunang Jesus.an aak pintalaka, nil yipmam oony way piꞌan alangan thaachow nunang, wayan yumpow. ");
INSERT INTO wim_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Nil Jesus.an aak pintalang angman wun-wun kinchang aꞌ ngutang kinch forty aakanakamwey puth nil may keꞌanam thamp wun-wun yaam, meech ngul wun-wun. ");
INSERT INTO wim_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Amanamaniya, nil oony way piꞌanan wamp nungant Jesus.antan, aꞌ thawant, “Nint nath kan-kanamwey nhengk God.antaman-a, yaa, nint kunttow inangan epankathān thanang may breadakana.” ");
INSERT INTO wim_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Puth nil Jesus.an thaw nungant, “Ngay keꞌa! Kan in ngeeyāna! Puth wik inangan lat ngench thayanangan thawana, ‘Pam wanch al-alangan mak wik ngeeyayn God.antamana, wik yot anangan nilan thaw. Than mayam thonakamana keꞌ mungk-mungkiythana, an than minam keꞌ wuniythan, yaꞌa. Than wik God.antamana mak ngeey-ngeeyayna!’” ");
INSERT INTO wim_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Amanamaniya, nil oony way alangan Jesus.an aak Jerusalem.ak kal nunang aawuch ngench thayan aakanakan, aꞌ keny kech kal nunang. ");
INSERT INTO wim_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Aꞌ oony way piꞌanan thaw nungant Jesus.antan, “Nint nathwey kan-kanam puk nhengk God.antaman-a, yaa, nint inpalman chang peyān a! aakanakam pek aakaka! puth wik inangan lat ngench thayanangan thawana: ‘God.angan ngaantiyongk nungantam anangan ngul kuchow thanang yipmam maꞌang mamayn nintang nint keꞌ yipam mulakaman keekān yaꞌa, thaꞌ nungkaraman thaka keꞌ thuthin kunttowangan yaꞌa.’” ");
INSERT INTO wim_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Puth Jesus.an thaw nungant, “Ngay keꞌa! Puth wik inangan lat ngench thayanangan thawan thampa, ‘Niiy keꞌ paathān piip God niiyantamana, yaꞌa!’” ");
INSERT INTO wim_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Anpalaniya, oony way alangana keny yoyk piꞌan achantangak matath nunang Jesus.an, aꞌ maanyan aak umyompanaman meenathan nungant. Aak pal-puy min-miniy a! ");
INSERT INTO wim_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Aꞌ nil oony wayan thaw nungant Jesus.antan, “Nintwey pungkangan thuchin ngatharan-a, aꞌ thaaꞌ-kuumpin ngayanganwey-a, ngay nungk kan-kanam theeꞌāng aak maꞌmangkam umyompanamana.” ");
INSERT INTO wim_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Puth nil Jesus.an thaw nungant, oony way piꞌan alantan, “Ngay keꞌa! In ngeeyāna! Puth wik inangan lat ngench thayanangan thawana, ‘Niiy piip God anman thonakam thaaꞌ-kuumpān nunang, wiyan yaꞌa, aꞌ woyan God.antam wakān ngangk min yumpān nunang.’ Nint puy kan iiyāna! Satana!” Jesus.an thaw. ");
INSERT INTO wim_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Amanamaniya, nil oony way piꞌananiya, kan-ngul iiy, Jesus.ana want nunang, aꞌ ngaantiyongk yot ngul wampin nungant, aꞌ maꞌ-aathin nunang ngul. ");
INSERT INTO wim_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Nil Jesus.angan wik thooꞌ ngeey John.antam than aak jailang thenchin nunang, aꞌ anpalan-a, nil Jesus.ana aak Galilee aakanakan iiy. ");
INSERT INTO wim_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nil aak Nazareth.angan keꞌam wuna, nil puth aak Capernaum aakanakan iiy, aꞌ angan wun, aak town ngak kookam piꞌan thinth, Galilee.anga, aak angmana Zebulona aꞌ puth Naphtali.antang thinth. ");
INSERT INTO wim_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Nil Jesus.an aak angman iiy-iiy-a, an nil meenath ngampar nil Isaiah.angan keenkanaman lat ngench thayanangan ump-a, aniya kan-kanam paththamwey ump, wik inangan: ");
INSERT INTO wim_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Aak Zebulon.ana aꞌ puth-a, aak Naphtali.ana ngak kookam Galilee thintha, aak woyanang ngak kookamakan wunana, aꞌ puth aak wonk kaawangk punth Jordan.aman-a, aꞌ putha wonk kungkangk aak Galilee.aman-a, aak thanttam than pam wanch yot Jews yaꞌ al-alantamana than angan wun-wuntana — ");
INSERT INTO wim_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","aak angan-a, than pam wanch keꞌ aak ngaaꞌ nyimangan wun-wuntana, keꞌ pam wanch mulan wun-wuntana, than puth ngoongk-ngoongkam nunang piip God.ana. Yimanang ngulan-a, than nganth piꞌan paththam thath-thathayn ngul, park-parkow ngul thanttangan, puth nil God.angan-a, woyan nungantam kan-ngul meenathow thant.” ");
INSERT INTO wim_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Aak an-aniyangan ngulan-a, nil Jesus.angan kan-ngul thaaꞌ-aath-aath thananga, wik min nungantam anangan waaꞌ-waaꞌ thant pam wanchantana, “Niiy wayan yaam keꞌ iiy-iiyāna, niiyana woyan min God.antam anman iiy-iiyān ngula. Puth aak anan ngul wampow nil God.angan maꞌ nungantangan pam wanch yot ngulan piꞌ-piꞌow.” ");
INSERT INTO wim_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Anpalan-a, nil Jesus.ana iiy-iiy thomp wonk wak-waka kookam piꞌan Galilee angan. Aꞌ nil pam kucham thath pulang pul kuunchama, minh ngaꞌan mam-mamanpul yuk punththamanangana, namp pulantiya Simona namp thoniy nunganta Peter, putha kuunch nungantam anan namp-a, Andrewa. Pulaniya minh ngaꞌ mam-mampul aꞌ punththaman theeꞌ-theeꞌpul ngak kookamanga. ");
INSERT INTO wim_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesus.an thaw pulant, “Nip pal iiyow ngatharanga! Nipaniya iiy-iiyowa minh ngaꞌ wiy-wiyam ananganiya mam-mamow ngula ngatharweya, puth inpalman ngula ngay maꞌ-aathāng nipang pam wanchantan iiy-iiyowa aꞌ pal ngathar wampathow thanangweya.” ");
INSERT INTO wim_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Pulaniya erkam paththam wantpul punththaman pulantamana aꞌ iiypul ngul Jesus.antangana. ");
INSERT INTO wim_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Aꞌ nilana puyamam iiy-iiy thomp wonk wak-wak aꞌ pul kuuncham ngul thath pulang, namp pulantiya James-a, putha Johna, puk nhengk nungantam pam Zebedee alantamana. Pulaniya chukkun pulantamang angana putha piip pulantaman angman thampwey, thanana min-min yumpin yuk punththamanan thanan yipam minh ngaꞌak ngul iiyayn. Aꞌ nil Jesus.angana ump pulanga, ");
INSERT INTO wim_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","aꞌ yaam keꞌanamana pulana chukkun thanttaman too wantpul ngul putha piip pulantaman thampwey wantpula, aꞌ iiypul ngul Jesus.antanga. ");
INSERT INTO wim_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Nil puth Jesus.an aak pal-puy Galilee wakan iiy-iiy, nil aak church thon-thonangan thaaꞌ-aath-aath thanang, aꞌ wik min God.antaman waaꞌ-waaꞌ thant nil God.angan kan-ngul maꞌ nungantangan piꞌ-piꞌow thanang pam wanchana. Than pam wanch kemp weech-weech thanangan-a, aꞌ wench thampan-a, nil miyalath thanangwey. ");
INSERT INTO wim_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Wik thooꞌ pent Jesus.antaman, aak pal-puy aak umyompanam Syria.angana — amanamana than pam wanchangan ngul pam wanch way alpan anangan wampathin nungant — than wiy anangana, oony way piꞌ-piꞌin ngangkangan; puth than wiy anangana thay-thayanamin, than puth wiy ananganiy-a, kunp wun-wunin, makaran yal-yalamina — aꞌ nil Jesus.angana maꞌmangkaman miyalath thanang. ");
INSERT INTO wim_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Nil Jesus.an aak wanttinakan iiy-a, than pam wanch yotangan-a, anman monkan-wak-wakin nunang — than pam wanch aak Galilee.aman-a, aak piꞌ-piꞌanam ten anpalan-a, aꞌ Jerusalem anpalan-a, puth aak umyompanam Judea.am anpalan, aꞌ puth-a, punth Jordan woꞌuwayn anpalan thampa iiy-iiyin nungant, palam-puyam monkan-wak-wakin nunang. ");
INSERT INTO wim_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Nil Jesus.angan pam wanch yot anangan thath thanang-a, nil aak achantang angan mat, aꞌ angman nyiin ngul. Pam wanch wiy anangan thintham wampin nungant, than puth kaangk wik nungantaman ngeeyayn, ");
INSERT INTO wim_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","aꞌ nil Jesus.angana kan-ngul thaaꞌ-aath-aath thanang, ");
INSERT INTO wim_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Niiy wiyiya niiyantakaman meeꞌmiy niiy min yaꞌa, niiy puth niiyamana min keꞌ iiyina. Yaa, an puth niiyaniya ngangk minangam ngul iiy-iiyānweya. Nil puth God.angan ngul kalow niiyang aak nungantamakan, angman wunān nungantanga. ");
INSERT INTO wim_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Niiy wiyiya ngangk way iiy-iiyaniya. Yaa, an puth niiyaniya ngangk minangam ngul iiy-iiyān; nil puth piip God.angan ngul ngangk thayanathow niiyang. ");
INSERT INTO wim_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Niiy wiyiya thaaꞌ mochan iiy-iiyaniya, ulp-ulpanang keꞌ iiy-iiyaniywey. Yaa, an puth niiyaniya ngangk minangam ngul iiy-iiyān niiy putha ngul uwān anana ngeenana kaaꞌngak niiyang piip God.angana. ");
INSERT INTO wim_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Niiy wiyiya kaangk paththam min-minam iiyān meeꞌ piip God.antangan. Yaa, an puth niiyaniya ngangk minangam ngul iiy-iiyāna, nil puth God.angan ngul maꞌ-aath-aathow niiyang, niiy yipam nunang anman wik ngeey-ngeeyāna. ");
INSERT INTO wim_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Niiy wiy il-ilangan ngangk mamaniy thanang, pam wanch anangan aak wayan wampan thant. Yaa, an puth niiyan ngangk minangam ngul iiy-iiyāna, nil puth piip God.angana niiyang ngangk mamow thampa. ");
INSERT INTO wim_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Niiy wiyiya ep-paththam ngangk min paththam iiy-iiyaniya, way keꞌam piꞌ-piꞌaniy ngangkang yaꞌa, yaa, an puth niiyaniya ngangk minangam paththam ngul iiy-iiyāna, aꞌ puth niiyan in kenyan piip God.an ngul thathān nunang. ");
INSERT INTO wim_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Niiy wiyiya kaangk nochathān thanang pam wanch wiy anangan yipmam ngangk minangam iiyaynweya. Yaa, an puth niiyiya ngangk minangam ngul iiy-iiyāna, nil puth piip God.angana waaꞌow niiyang puk nungantamweya. ");
INSERT INTO wim_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","11","“Niiy wiyiya woyan piip God.antaman wak-wakaniya. Niiyiy putha min anman iiy-iiyaniy meeꞌ God.antangan. Pam wanch wiyangan keꞌ-paal thaaꞌ-thengkathantan niiyang, way yumpantan niiyant, aak-yaꞌang kulak wenkantan niiyant. Nungkway than wiyangan wik aak-yaꞌangan waaꞌ-waaꞌayn niiyangan-a, aꞌ way thakan aak-yaꞌangan yumpayn niiyantan-a, aꞌ piikayn thak niiyangan aak-yaꞌangan-a, niiyan ngangk minangam anman iiy-iiyāna! Aꞌ ngulana, nil God.angan aak nungantamak kalow niiyang, an kan-kanama. ");
INSERT INTO wim_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Pam wanch keenkana, yimanang kuyam wayan yump-yumpin thant, pam prophets al-alantan. Nil puth piip God.angan aak nungantamak kal thanang, pam prophets ananganiya. Yaa, ngangk way keꞌ wunow niiyant, niiy ngangk minangam iiy-iiyāna! Puth nil piip God.angan-a, ngangk min ngul yumpow niiyang aak nungantang angman wunāna. ");
INSERT INTO wim_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“In ngeeyāna! Niiyaniya, keꞌ nguntham yimanangan thant pam wanchantan. Ngunthamaniy-a, mina minhakana. Puth nguntham nath way ngulan wunow-a, niiy ngul ngunthaman wanttak koyaman minan yumpāna? An yaꞌa! An yaꞌ-ngul, min puthaman keꞌ yumpinweya, yaꞌa. Ngunthamana an way theeꞌin ngul, than pam wanchangana thaꞌang maakiythan ngula, puth waya. ");
INSERT INTO wim_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Thon inan waaꞌāng niiyanta: niiyaniya keꞌ nganth yimanangan iiy-iiyān thant pam wanchantan. Aak piꞌanwey kaachiythan aak achantang angan-a, an keꞌ wuthanangan wuniy, yaꞌa, an yotanganiy-a, nganthaniy-a, thath-thathiythan. ");
INSERT INTO wim_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Aꞌ nil pamang nath lamp pathathiywey-a, an nganthan yuk paathangan keꞌ kangiy nganthana, yaꞌa. An nil pam alangan keny achantang waanchan thanan yipam nganthangan aakan thathayn. ");
INSERT INTO wim_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Yaa, in aak yimanangan wunana: niiy min-minam anman iiy-iiyān meeꞌ thanttang pam wanchantangana. Than niiyangan thathaynwey-a, minan iiy-iiyān-a, yaa, niiyaniya keꞌ nganth yimanangan thant aꞌ thanana ngaantam-ngeeyayn nil God.an piꞌan min-minam paththam. ");
INSERT INTO wim_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Ngay kan wik inan waaꞌāng niiyant wik thayan God.antam Moses.angan umpa, puth pam prophets al-alangan umpin thampa. Niiyan nath ngaantam-ngeeyaniy ngay puth inpal keny ukanga ngay keꞌ wik thanttaman ngay wayathing ey? an yaꞌa. Ngayiy wampang ngay yipam wik thanttaman maꞌmangkaman piꞌānga. ");
INSERT INTO wim_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Puth wik thayan God.antam anangan nathpalman kaꞌathaman wun-wun, aꞌ ngulakam wun-wunow thampa. Ngayan keꞌ puth epankathing wik thonamana yaꞌa, wik maꞌmangkaman ngulakam wun-wunayn aak-aakanakaman aak inan minchowana. ");
INSERT INTO wim_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Than weeꞌ-weeꞌanangan wik thayan God.antaman keꞌ ngeeyayn-a, aꞌ thawayn wiy al-alantan wik inangan keꞌ ngeeyān-a, than pam piꞌan keꞌ iiyiythan God.antang yaꞌa. Nungkway than wik thonam anman pipayn-a, pam piꞌan keꞌ iiyiythan nungantangana. Puth weeꞌ-weeꞌanangan wik thayan God.antaman ngeeyayn-a, aꞌ thawayn wiy al-alantan wik inangan ngeeyān-a, thananiya, ep pam piꞌan iiyayn God.antang. ");
INSERT INTO wim_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Kan in ngeeyiya ngula: than Pharisees-a, puth pam teachers wik thayan inangan thaaꞌ-aath-aathantana, ngul than wik inangan minam ngeeyantan ey? yaꞌa! Thanan wiy-wiy ngeey-ngeeyantan, maꞌ-yotamana, yaꞌa. Puth niiy kaangk aak God.antamang wunān ngulakaman-a, niiyiya wik God.antam kan-kanam ngeey-ngeeyān anmana. ");
INSERT INTO wim_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Niiyiya min-minam paththam iiyāna. Aak keenkanama, wuut mangk ngamparamangan wik thayan inan wantin ngampar, ‘Niiy keꞌ mulathān pam wanchana. Nil pam thonamangwey mulathiy pam thonan-a, nil puth pam ananiya courtak iiyow, than pam piꞌ-piꞌanam al-alangan um thanttang thanathayn nunanga.’ ");
INSERT INTO wim_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Puth ngay wik inan waaꞌāng niiyant: pamwey nath man kul wampiy nungant pam thon alantan-a, nilan putha courtak iiyow. Nil pamangwey nath wik wayanang thak thaw-thawiy waaꞌ-waaꞌiy pam thonan-a, nilan putha courtak iiyow thampa, aꞌ pam piꞌan alangan um nungantang thanathow nunang. Pamwey nath thawiy pam thon alantan, ‘Nint ina kuchek waap keꞌ kuꞌantam yimanangan kal-kalangan ey?’, nil piip God.angan nath aak way aakanakan kuchow nunang, aꞌ thum karkanangan pench-penchow nunanga. ");
INSERT INTO wim_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“In ngeeyiya: niiy kaangk nath minh maꞌangan wampathin aawuch ngench thayan aakanakan nil God.an yipam ngangk min wunowanta. Niiy nathwey iiyān aawuch ngench thayanakan-a, aꞌ amanamaniya, niiyan nath ngaantam-ngeeyin ngul niiyan wayan yumpan pam thon alantan. ");
INSERT INTO wim_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Yaa, niiyaniya minh angman too wantān aawuch ngench thayanang angman, aꞌ niiyaniya koyam yuurpam ngul iiyān pam alantan aꞌ thawān nungant, ‘Ayyang, ngay way yumpang nungkara. Nintang keꞌ kon-ngathiy ey? ngayan way yumpang nungkar anpalan ey?’ Pam anman nath thawiy nungkara, ‘Eeꞌa, kan kon-ngathow ngalangweya,’ yaa, niiyaniya koyam iiyān aawuch ngench thayanakan, aꞌ God.antan kan-ngul theeꞌān minh niiyan wampathan nungant. ");
INSERT INTO wim_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Pam thonam nathwey thawiy niiyanta, ‘Ngay nintang kalāng courtaka, puth nint wukal ngatharam keꞌam koyaman theeꞌan ngath.’ Yaa, niiy puth yaamana keꞌ kuupān, niiy koyaman erkamwey theeꞌān nungant, yipam nilana ngangk min wunowantwey. Niiyaniya putha courtakan keꞌ-ngul iiyin yaꞌa. Niiy courtakwey iiyin-a, nil maꞌam theeꞌiy niiyang magistrate alantan, aꞌ nil magistrate alangan maꞌam theeꞌiy niiyang policemen al-alantan, thanan putha jailang thenchiythan niiyangweya. ");
INSERT INTO wim_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Niiyana angman wun-wunin jailangan. An puth niiyangan keꞌ yippak kuchiythan aak jailam anpalana. Niiy wukal piꞌanan theeꞌinan-a, an ep jailaman pentin ngul. ");
INSERT INTO wim_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Thon in ngeeyāna: aak keenkanama, wuut mangk ngamparamang wik thayan inan wantin ngampara, ‘Niiy maarich keꞌ keeꞌāna.’ ");
INSERT INTO wim_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Puth ngay wik inan waaꞌāng niiyanta, nil nathwey pamang wanch meeꞌ yenchang thath-thathiy-a, aꞌ ngaantam-ngeeyiy nungantakam, ‘Ngay kaangk wunāng wanch alantan-a,’ an nil way yumpan, an nil keꞌ maarich keeꞌ-keeꞌan wanch alantan, ngangkang angman piꞌ-piꞌan nunanga. ");
INSERT INTO wim_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Nip nathwey meeꞌ thathwiwwey-a, kaangk maarich keeꞌow-a, aꞌ amanamaniya nip wayan yumpiw ngula, yaa, niiy meeꞌ thiith niiyantamana thapathāna, niiy yipam way anangan keꞌ-ngul yumpāna. Nungkway niiy aak God.antamakan meeꞌ keꞌanangan iiyinwey-a, yaa, an kana! Puth in ngeeyāna: nil God.ang aak way angan theeꞌiy niiyang kemp yotaman-a, an way niiyanta. ");
INSERT INTO wim_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Aꞌ niiy wayan yumpin-a, maꞌ malang niiyantamangan-a, yaa, niiy maꞌ mal niiyantamana thalokang umpāna, niiy keꞌ yipam way anangan yump-yumpāna. Nungkway niiy aak God.antamakan maꞌ keꞌanang iiyinwey-a, yaa, an kana! Puth in ngeeyāna: niiy nath aak wayakan iiyin-a, an puth way-wayam paththam niiyanta. ");
INSERT INTO wim_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Thon ina: keenkanama wuut mangk ngamparamang thamp wik thayan inan wantin ngampara, ‘Nil nath pam thum nungantamangan wanch-kunchan wantiy nunang aak umpuyangaman-a, nil lat many theeꞌow nungant wanch alantan wantowanana.’ ");
INSERT INTO wim_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Puth ngay wik inan waaꞌāng niiyant: pul maꞌ pam wanch ngangk minangaman piꞌwiwpula, keꞌan wantwiwpula. Nathwey wanch maarich keꞌ keeꞌanam-a, nil pam thum nungantam alangan too wantiy nunang aak yaꞌanganwey-a, an way yimanangana. An keꞌ nil thaachan nunang wanch nungantaman pam thon ngul nath ngentiya. Nil nath thonangan ngentiy-a, pulana way yumpanpul, maarich keeꞌanpul karpamaniya. ");
INSERT INTO wim_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Thon ina: keenkanama wuut mangk ngamparamang wik thayan inan tham wantin ngampara, ‘Niiy kan-kanam thawān, keꞌ wik uuyamān yaꞌa. Niiy nath thawinwey pam thon alantan, “Ngay kan-kanam thawanga, ngay keꞌ muukamathing nintang, puth piip God.angan thathan ngayanga.” Yaa, niiy wik keꞌ pipāna, anman yumpān keꞌ niiyan wik thawana.’ ");
INSERT INTO wim_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Puth ngay wik inman waaꞌāng niiyant: niiy kan-kanamwey thawin-a, wik engkanang thawāna: ‘Eeꞌa’ or ‘Yaꞌa’ thawān yimanangana, niiy namp keꞌ wich-wichān ‘Piip in kenyana.’ An waya! ");
INSERT INTO wim_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","36","Namp wiy anangan keꞌ wichāna: aak in kenya, or aak in pek, or aak Jerusalem, or kuchek niiyantam thakan. Puth piip God.an aak in kenyan wunan, puth aak ingan thamp wunan, aꞌ nil maꞌmangkam yump. Puth niiy piꞌan yaꞌa. Niiy yangan wuut aꞌ yangan ngotanan keꞌ yumpin thant pam wanchantan, yaꞌ paththam. ");
INSERT INTO wim_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Yaa, niiy anman thawān, ‘Eeꞌa’ or ‘Yaꞌa,’ anman kan. Wik wiy anangan puth oony way piꞌan alantaman. Too wantān thanang. ");
INSERT INTO wim_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Aak keenkanama wuut mangk ngamparamang wik inan thamp wantin ngampara, ‘Pamang nathwey meeꞌ-ath pichathiy pam thon alantaman-a, yaa, niiyaniya puth-puthangkan meeꞌ-ath pichathān nunang. Nil pam thonamang nathwey koonh pam thon alantam pipiywey-a, yaa, niiyaniya koonh pipān nunang puthangkana.’ ");
INSERT INTO wim_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Puth ngay wik inan waaꞌāng niiyanta: nil thonam nath wayamiy niiyant-a, kul uwiy niiyant aak-yaꞌangan-a, yaa, niiyana ngangk keꞌ peeyān nungant keꞌ maꞌ piikanakaman moꞌān nunganta. Nil weeꞌang nathwey piikow niiyang-a, niiy puthangkan keꞌ piikān nunang, nil puthaman mak piikow niiyang. ");
INSERT INTO wim_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Thon inana: nil weeꞌang nathwey kaliy niiyang courtakan-a, aꞌ thaachiy niiyang shirt niiyantaman theeꞌin nungant-a, yaa, niiy theeꞌān nungant, aꞌ nil coatakwey thamp thawow niiyant-a, keꞌ wayathān nunang, niiy paththam theeꞌān nungant. ");
INSERT INTO wim_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Thon inana: nathwey pam soldier thonamang thaachiy niiyang way min nungantaman kalān nungantana mile thonamakan-a, niiy kalān, puth chip-chipam keꞌ wantān way min anangan, niiyiya puy-puyam kalān nungant miles kuchamak ngula. ");
INSERT INTO wim_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Thon inana: nil pamwey nath thawiy niiyant mayak thakwey-a, niiyiya keꞌ weekāna, theeꞌān nungant. Pamwey nath thawiy niiyant, ‘Niiy way min niiyantam nanangan pal theeꞌān ngathara ngay kan yaan piꞌāng niiyantam, ngay koyam ngul theeꞌāng niiyant.’ Yaa, niiyana theeꞌān nungant yaan piꞌow niiyantamanweya. ");
INSERT INTO wim_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Aak keenkanamana, wuut mangk ngamparamang wik inangan wantin ngampar, ‘Niiyiya ngangk minangam iiyān thant kampan niiyantam al-alantana, puth than weeꞌ-weeꞌanangan niiyangan thaampantan-a, ngangk kulangam ep kalān thanang.’ ");
INSERT INTO wim_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Puth ngay wik inan waaꞌāng niiyant: than weeꞌ-weeꞌananganweya meeꞌ kulangam kaliythan niiyang-a, niiyaniya ep ngangk minangam anman iiy-iiyān thantana. Than weeꞌ-weeꞌananganweya way anman yump-yumpiythan niiyantan-a, an niiyaniya min iiyān thant puth meeꞌ-wuthanamān piip God.ant nil yipam minam piꞌow thanang. ");
INSERT INTO wim_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Niiy yimanaman wun-wunin minam anmanwey-a, yaa, niiyiy putha piip God.an monkan-wak-wakaniy nunanga. Nil puth God.an minam anman murkanim iiy-iiyan ngampar yotantakama. Nil ngak kuch-kuchan inpal kenyan ngampar putha nil kinchan yumpan minam parkow ngampar yotantakam, pam wanch min-miniyan wuntana, aꞌ putha, pam wanch way-wayanangan wuntan aak world inganiy. ");
INSERT INTO wim_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","“Niiy nathwey kaangk wunaniy thonakamana pam wanch al-alantan kaangkan wuntan niiyantana. Ngul nil piip God.an ngangk min wunow niiyantam anpalan ey? An yaꞌ ey! Puth pam wanch maꞌ-kuchan al-alangan ngurp thanttamakan aꞌ kampan thanttamakan kaangk wuntan thant. ");
INSERT INTO wim_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Niiyiya nath kampan niiyantam al-alantan thonakam thawin thant, pam wanch wiyantan keꞌ thawin thant ey? Ngul in min ey? An yaꞌa. Puth pam wanch al-alangan piip God.an keꞌaman yippak thiichin nunanga, thananiya kampan thanttamakan aꞌ putha ngurp thanttamakan wik thawantan thant. ");
INSERT INTO wim_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Niiyiya putha, ngangk minangam iiy-iiyān pam wanch yotantan, keꞌ piip God.an min-minam paththam iiy-iiyan aak in kenyan heavenangan. ");
INSERT INTO wim_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“In ngeeyāna: niiy minan yumpān-a, niiyana meeꞌ yotantangan keꞌ yumpān minana yipam pam wanchangan thathayn niiyanga, aꞌ thaaꞌ-kuumpayn niiyang, an yimanangan yaꞌa. Niiy nath yaan muuk-muukamaniywey-a, an nil piip niiyantaman in kenyan wunan-a, ngangk min keꞌ wuniy niiyantamana yaꞌa, aꞌ min keꞌ iiyiy niiyant, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Pam wanch wiyanganiya wukal theeꞌantan thant pam wanch al-alantan than meechana, wukal keꞌanangan wun-wuntanweya, than yipam pam wanch wiyangan thathayn thanang, aꞌ thaaꞌ-kuumpayn thanang. An puth min yimanangan yaꞌa, than yaan theeꞌantan, yipam pam wanchangan ulpathayn thanang. Yaa, pam wanchangan ngul thaaꞌ-kuumpayn thanang, puth thanam thonakama, nil puth piip God.angan yaꞌa, keꞌ thaaꞌ-kuumpiy thanang, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Puth niiyiya, niiy wukalan theeꞌān thant pam wanch al-alantan wukal keꞌanangan wuntanwey-a, niiy ulp-ulpanangan keꞌ theeꞌān yipam kampan niiyantamang thathayn aꞌ thaaꞌ-kuumpayn niiyang. ");
INSERT INTO wim_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Nungkway pam wanchangan keꞌ thathiythan niiyang-a, nil piip God.angan ep thathan niiyang, aꞌ nilan thawan nil anana min-minam paththama, aꞌ ngangk min thamp wunan nunganta. ");
INSERT INTO wim_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Pam wanch wiyiy kaangk aak churchangan thanayn meeꞌ yotantang, wiyiya aak yoon engkanang thanayn, aꞌ meeꞌ-wuthanamayn God.antan yipam pam wanch yotangan thathayn thanang. In ngeeyiya: pam wanchangan ngul thaaꞌ-kuumpayn thanang, puth thanam thonakama, nil puth piip God.angan keꞌ thaaꞌ-kuumpiy thanang, yaꞌa pam yim-yimananganiya. ");
INSERT INTO wim_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Puth niiyiya, niiy piip God.antan thawān-a, niiy puy iiyān pokkapang aak enyanang thawān nungant. Niiy puth keꞌ thathin nunang God.an yaꞌa, niiy meeꞌ-wuthanamān nungantana, an epa. Nil piip God.angan ngul thathow niiyang aak angana, aꞌ nil putha thaaꞌ-kuumpow niiyang aꞌ ngangk min wunow nungant niiyantamana. ");
INSERT INTO wim_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","8","“Pam wanch wiyangan keꞌam thiichantan nunang God.an. Than kaangk yaam thaw-thawayn oony piꞌan thanttam al-alantan, aꞌ than kaangk wik wolmp anman piꞌ-piꞌayn yipam oony piꞌan thanttam al-alangana wik ngeeyayn thananga. Puth niiyiya, niiy piip God.antan wik thawān-a, niiy yimanangan keꞌ iiyān yaꞌa. Piip niiyantam God.ana, nil kana meeꞌmiy niiyang. Niiy keꞌaman yippak thawaniy nungantan-a, nil kanam thiich niiyang niiy ngeen nathan ngaantam-ngeeyaniy putha niiy ngeenakan thamp kaangk thawān nungantan. ");
INSERT INTO wim_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Niiy kaangkwey thawān God.antan-a, niiyiy wik yimanangan thawān nungant: ‘Piip nganttam in kenyana, ngan kaangk pam wanch maꞌmangkaman thawayn nungk nint wuut piꞌan, minam paththam a! ");
INSERT INTO wim_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ngan kaangk nint moom wuut piꞌan iiyān ngant pam wanch yotamantana, ngan yipam maꞌ nungkarang wunāna, maꞌ wiyantang yaꞌa. Ngan kaangk pam wanch maꞌmangkamangan wik nungkaraman ngeeyayn, aꞌ woyan min koochanam nungkaram anman wak-wakayn, keꞌ than ngaantiyongk al-alangan wik nungkaraman ngeeyantan aak in kenyan. ");
INSERT INTO wim_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Piip-ang, kinch inana nganangan maꞌangam piꞌān ngan yipam may minh thakan uwāna. ");
INSERT INTO wim_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Nint nganang ngangk mamān aꞌ putha kon-ngathow nintang way yot anangan nganan yump-yumpan, puth ngan ngangk maman thanang, kan kon-ngathan nganang way thanan yumpin ngant. ");
INSERT INTO wim_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Nint weekān nganang oony way alantaman, aꞌ kalān nganang woyan way anpalan ngan yipam way keꞌ yumpān. Yey, piipa, anman kan.’” ");
INSERT INTO wim_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Aꞌ nil Jesus.an thaw thant ngul, “Niiyang way anangan kon-ngathow niiyang than wiyangan yump-yumpin niiyant-a, yaa, nil puth piip ngamparam God.angan-a, keꞌ-ngul ngaantam-ngeeyow way niiyan yump-yumpana. ");
INSERT INTO wim_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Niiyang keꞌwey kon-ngathow than niiyantan way yump-yumpin-a, yaa, piip ngatharam ilang kenyana keꞌ kon-ngathow nunang way niiyan yump-yumpan yaꞌa. ");
INSERT INTO wim_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Kan in ngeeyiya: wiyiya may wantaniy, keꞌ mungkaniy yaꞌa, putha keꞌam ngaantam-ngeeyaniy may mungkanakan niiy yipam piip God anman ngaantam-ngeeyān nunanga. Pam wanch wiyangan may keꞌ mungkantanan-a, ngangk way iiy-iiyantan, kaaꞌwaliya wiy-wiyam iiy-iiyantan. Than kaangk yimanaman iiy-iiyayn than pam wanch wiyangan yipam thathayn thanang than mayan keꞌam ngaantam-ngeeyantan, keꞌam mungkantan. Than pam wanchangan nath thaaꞌ-kuumpiythan thanang, nil puth God.angan yaꞌa keꞌ thaaꞌ-kuumpiy thananga. ");
INSERT INTO wim_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Puth niiy mayan wantaniy-a, niiy muunchāna, kaaꞌwal pungwuna, aꞌ putha yangan umpwun combang, ");
INSERT INTO wim_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","than wiyangan keꞌ yipam meeꞌmiy wunayn niiy mayan want-wantaniya. Niiy puth keꞌ thathin nunang piip God.an yaꞌa, puth nil God.angan ep thathan niiyang, aꞌ putha nilan thaaꞌ-kuumpow niiyang aꞌ thawow niiyant nan mina. ");
INSERT INTO wim_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Niiy wukal-weenth keꞌ iiyāna, way min min-miniy al-alangan keꞌ ngangk mungkow niiyang, niiy way min yot keꞌ yalmathān aak imanaman. Way min nanangan yaam keꞌ wunayn yaꞌa; an wayamayn ngul. Wiyiya yuk way cockroaches al-alangan mungkantan, ngoꞌarang thak wayathan yuk way min anangan. Wiyiya, pam maꞌ-kuchanang maayantan niiyantam. ");
INSERT INTO wim_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","21","Niiy nath kaangkwey wukala putha way min yotan yalmathān niiyantakaman aak inganiy-a, an puth niiy yuk way min anman ngaantam-ngeeyaniy thonakama. Puth inan waya paththama! Niiy nath kaangk God.an-a, an niiy ngaantam-ngeeyaniy nunang, ngangkang piꞌ-piꞌaniy nunang. Anpalaniy-a, nil ngul kalow niiyang aak min nungantamakan. Aak in kenyan nungantamana an ep keꞌ wayamiy yaꞌa, an min-minam anman wun-wunow aak umpuyam. Pamangan keꞌ maayiythan way min aak God.antam anpalan, an yaꞌ, puth yuk cockroachesang thakan keꞌ wayathiythana yaꞌa, minam anman wun-wunayn ngulakama. ");
INSERT INTO wim_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","23","“Meeꞌ niiyantam anangan-a, keꞌ nganth yimanangan kemp niiyantamakan. Niiywey meeꞌ minangaman iiy-iiyinwey-a, an keꞌ niiy nganth piꞌanang yimanangan iiy-iiyaniy. Niiy nath meeꞌ way thampangan-a, an keꞌ niiy aak ngaaꞌang yimanangan iiy-iiyaniy. Nil piip God.ana keꞌ nganthan yimanangan wampan niiyant, niiy yipam woyan nungantam thiichān. Yaa, niiy kan-kanam woyan min paththam wak-wakāna, niiy keꞌ yipam keꞌ aak ngaaꞌangan iiy-iiyāna.” ");
INSERT INTO wim_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Nil Jesus.ana wik inangan thaw thant ngul, “Niiy woyan kuchaman karpam keꞌ wak-wakin pulang, yaꞌa; aꞌ niiya moom kuchamanta keꞌ work iiy-iiyin yaꞌa, moom thonamantan ep work iiyān. Niiyan puth nath moom kuchamantan work iiy-iiyin-a, yaa, niiyan puth thonaman-a, ngangk-wayangam kalin nunang, aꞌ way waaꞌin nunang, puth niiy moom thon an ep min waaꞌin nunang aꞌ kaangk wunin nungant thamp. In aak yimanangan wunana: niiy nathwey kaangk wunin God.antan-a, niiy wukal-weenth keꞌ iiyina. ");
INSERT INTO wim_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Ngay inan waaꞌāng niiyantan: niiy yaam keꞌ ngaantam-ngeeyān may-a, putha way min anangan thakan, aꞌ yaam keꞌ ngaantam-ngeeyān niiy ngul want-wanttakan minam piꞌ-piꞌān niiyantakaman. Niiy ngul aak ingan wunaniy may mungkanakan thonakam ey? aꞌ putha ngook min-miniy ngoonchanakan ey? Yaꞌa! ");
INSERT INTO wim_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Niiy minh panch anangan thathāna. Ngul than may kaanch anangan kaampantan thanam ey? Yaꞌa! Aꞌ than may kaanch anangan yal-yalmathantan aꞌ aawuchang ngul piꞌ-piꞌantan ey? An yaꞌa! Nil piip niiyantamang God.angan min-minam piꞌ-piꞌan thanang. Nil niiyantan ep-paththam kaangk wunan, puth minh panch al-alantan yaꞌa, chil-chila! Nil niiyang pam-a, wanch-a, puk manyiy tham minam paththam piꞌ-piꞌan niiyanga. ");
INSERT INTO wim_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Kuchek way nath wunowan niiyant mayam thakan-a, ngul niiy yaam man-yethamanan wun-wunān ey? Yaꞌa. ");
INSERT INTO wim_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Inan thamp ngeeyāna: niiy kulich thakan yaam keꞌ ngaantam-ngeeyāna. Niiy thathāna, may kooth aꞌ putha pach yot em-emantana. Ngul than pach yot al-alangana kulich thanttakam wak-wakantan ey? yaꞌa, than keꞌam wakantan. ");
INSERT INTO wim_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Thon in ngaantam-ngeeyān pam King Solomon.ana, nilaniya maꞌmangkiya ngook min-minam anangan ngoonch-ngoonch. Than pach anangan ach-umpanam min paththam aa, puth ngook King Solomon.antamana, an chil min a! ");
INSERT INTO wim_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Aꞌ putha wak thakan emantan-a, an ach-umpan thama. An yaan thonakam wunan wak erpan, kan-ngulana, kathaman ngul aꞌ ngamp thumang ngul kiingkanamp. Nungkway wakan yaam keꞌam wunan-a, nil God.angan min ach-umpanam yumpan, aꞌ minam piꞌ-piꞌan. Ngul nil niiyangan thamp minam keꞌ piꞌ-piꞌow niiyang ey? In ngeeyiya: nil niiyang min-minam paththam piꞌ-piꞌana, pach-a, puth wak anangan chil-chil piꞌ-piꞌan thanang. Niiyiy puth min-minam keꞌam ngaantam-ngeeyaniy nunang God.an nil minaman piꞌ-piꞌan niiyang. Niiyana min-minam ngaantam-ngeeyān piip God.an nil maꞌ-kaaꞌ-minangaman piꞌ-piꞌan niiyang. ");
INSERT INTO wim_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Kuchek way keꞌ wunow niiyant puth keꞌ ngaantam-ngeey-ngeeyān may wanttinpalan uwāna, aꞌ putha ngak-a, way min thakan wanttinpalan uwāna. ");
INSERT INTO wim_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Puth pam wanch anangan than keꞌaman thiichin nunang God.ana than ngaantam-ngeey-ngeeyantan may thakan wanttinpalan uwayna. Nil puth piip nungkaram God.angan ilang kenyan kan meeꞌmiy niiyang may-a, putha ngakan kaangk mungkānweya, aꞌ puth way min thakan kaangk piꞌān niiyantakamweya. ");
INSERT INTO wim_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Yaa, niiyiy putha punch-aakam theeꞌwun maꞌ God.antang, niiy min anman yump-yumpān wiyantan nil piip God.an yipam ngangk min wunowanta, aꞌ nilaniya maꞌ-aath-aathow niiyang mayan uwān, ngakan putha way min kulich thakan uwāna. ");
INSERT INTO wim_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Niiy yimanangan keꞌ ngaantam-ngeey-ngeeyāna, ‘Ngaaꞌthamana, aak way nath ngul wampow ngampar.’ Kuchek way puth keꞌ wunow niiyant amanaman a! An yaꞌa. Aak way nath kinch inman nath wampiy niiyant. Niiy inan ep ngaantam-ngeeyān niiy want-wanttakan kinch inmana aak wayan thaampāna, anman thonakam, an anman kana! ");
INSERT INTO wim_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Niiy keꞌ waaꞌ-waaꞌān thanang pam wanch anangan, aꞌ anpalana nil God.angan keꞌ yipam niiyangan waaꞌ-waaꞌow. ");
INSERT INTO wim_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Niiy nathwey waaꞌān wiy anangan-a, yaa, an nil God.angan ep waaꞌow niiyang keꞌ niiyan waaꞌaniy thanang. ");
INSERT INTO wim_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Niiy pam wanch ngeenak waaꞌaniy thanang e? puth niiy keꞌam ngaantam-ngeeyaniy niiyantakaman way niiyan iiyaniy e? Niiy kampan niiyantaman ngeenak thathaniy nunang keꞌ meeꞌ wook many piꞌ-piꞌan meeꞌ nungantamangan e? puth niiyaniya epa keꞌ yuk piꞌan paththam piꞌ-piꞌaniy meeꞌ niiyantamangweya, puth niiy keꞌam thathana. ");
INSERT INTO wim_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Niiy puth want-wanttakan thawin kampan niiyantamantana, ‘Nint nan meeꞌ wook thamp iiy-iiyangana, kan nint pal iiya! Ngay wookan wichāng meeꞌ nungkaram nanpalana.’ ");
INSERT INTO wim_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","In ngeeyāna: an waya! Niiy kaꞌathamana yuk piꞌan wichān meeꞌ niiyantam nanpalana, yaa, niiy minam ngul yipam thathān wookan wichān meeꞌ niiyantam nanpalana. ");
INSERT INTO wim_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Niiy keꞌ theeꞌāna ngeen nathan yuk way min ngench thayan God.antamana kuꞌ al-alantana, puth thananiy-a, weentiythan ngula aꞌ wakiythana, puth-a, pathiythan niiyang. Aꞌ putha niiyaniya yuk pearls niiyantamana keꞌ theeꞌān minh nhinthan al-alantan, an than thaꞌangam maak-maakiythana. ");
INSERT INTO wim_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","8","“Nil weeꞌ-nathan engkiy nungant God.antan maꞌ-aathow nunang-a, an nil God.angan maꞌ-aathow nunang. Nil weeꞌ-nathan woyan God.antamak wenk-wenkiy-a, an nil God.angan ngul meenathow nungant. Nil weeꞌ-nathan meeꞌ-wuthanamiy nungantan-a, nil God.angan ngul ngeeyow nunang. Yaa, niiy engk-engkān nungant maꞌ-aath-aathow niiyang, aꞌ woyan nungantamak wenk-wenkān, aꞌ putha meeꞌ-wuth-wuthanamān nungant. ");
INSERT INTO wim_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Than puk niiyantamwey thawiythan niiyanta may palowakan-a, ngul niiy kunttow theeꞌin thant ey? puk niiyantamakan ey? yaꞌa, an may min theeꞌin thantweya. ");
INSERT INTO wim_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Aꞌ thon inana, than puk niiyantamwey thawiythan niiyant minh ngaꞌakan-a, ngul niiy thuuk ngotan theeꞌin thant ey? yaꞌa. ");
INSERT INTO wim_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nungkway niiy way iiy-iiyaniy-a, niiy min-minam piꞌ-piꞌaniy thanang puk niiyantam anangan. Puth niiy kan ngaantam-ngeeyān nunang piip God.ana. Nil ep min-minam paththam iiy-iiyan. Niiy weeꞌ-weeꞌanangan thawin nungant God.antan-a, nilana min-minam paththam piꞌ-piꞌow niiyang. ");
INSERT INTO wim_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Nil pam Moses alangan putha pam prophets al-alangan wik min yot wantin ngampar wik min God.antam anangan. Ngay puth wik thanttam koochanathāng niiyant — in ngeeyāna: keꞌ niiyan kaangk pam wanch wiyangan min iiyayn niiyantan-a, niiy yimanangan min iiyān thant. ");
INSERT INTO wim_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","“Aꞌ puth ngay inan thamp waaꞌāng niiyant. Niiy thaaꞌ gate.an uwāna woyan aakanakan wunan aak God.antamakana. Thaaꞌ gate inan aꞌ puth woyan God.antamakan wunana, an piꞌan weꞌar yaꞌa, an many ulathana. Puth thaaꞌ gate thonana, woyan thon aakanakan wunana aak wayakana, an ep piꞌan weꞌar, aꞌ puth woyanan weꞌar thamp. Pam wanch yot-yotam al-alangan thaaꞌ gate weꞌaran uwantan, aꞌ woyan weꞌaran wakantan. Puth pam wanch koꞌalamang thaaꞌ gate manyan uwantan aꞌ woyan manyan ngul wakantan, aak God.antamakan. ");
INSERT INTO wim_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Pam wiy anangan thaw-thawantan niiyant keꞌ wik God.antam waaꞌantan, an yaꞌ paththam, wik uuy-uuyamantan. Niiy wik thanttamana erkam keꞌ ngeeyāna. Thanana pam way paththam keꞌ kuꞌ kulliy yimanangan puth than yaan muuk-muukamathantan niiyanga, than keꞌ kuꞌ maal yimanangan wampantan niiyant yipam wayathayn niiyang, meeꞌ wichayn niiyang woyan God.antam anpalan woyan way aakanakan. ");
INSERT INTO wim_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","An puth niiy want-wanttak thiichin thanang wayanang anangana? Niiy puth ngul thathān thanang wayan yump-yumpantan. Aꞌ inan thamp ngeeyāna: ngamp may menchan yukangwey thathimp-a, yaa, ngampaniya puth meeꞌmiy yukan nath mina, nath yaꞌa. Ngamp may kom keꞌ thuthimp yuk waakam anpalana; aꞌ puth ngamp may kaangk anangan keꞌ thuthimp yuk keekachthiy anpalana. ");
INSERT INTO wim_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","18","Yuk minwey thanan-a, an may way keꞌ kaliya, yaꞌa, an may min anman kal-kalan. Puth yuk thoniya kan-ngul nathwey kathaman-a, may min keꞌ-ngul emiy yukang angan yaꞌa, an may way thonakam ep kalana. ");
INSERT INTO wim_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Yukang may min keꞌwey kaliy-a, pamangan yukan thalokang umpantan, aꞌ thumang ngul kiingkantan. ");
INSERT INTO wim_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Yaa, niiy puth pam anangan thathān thanang. Ngul an than min yumpantan ey? An yaꞌa, an way yumpantan. Niiy meeꞌmiy ngul iiyān than weeꞌ-weeꞌanangan wayan iiy-iiyantan-a, than al-alangan wik God.antam minam keꞌ waaꞌantan niiyant, yaꞌa, an thanama wik uuy-uuyamantan thonakama.” ");
INSERT INTO wim_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Aꞌ Jesus inan thaw thant, “Than pam wanch yotan yaan thaw-thawantan ngathara, ‘Nintiya moom ngatharama!’ Puth thananiy-a, maꞌ God.antang keꞌ iiyiythan keꞌ puk nungantam anangan, yaꞌa. Puth pam wanch al-alangan than wik God.antaman minaman ngeey-ngeeyantan-a, an epa maꞌ nungantangan iiyayn ngulakam. ");
INSERT INTO wim_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ngul-ngulaniya, nil piip God.angan pam wanch maꞌmangkam ngul thanathow thanang um nungantang, aꞌ pam wanch yotan ngul thawayn ngathar, ‘Ayyang, moom ngatharam-ang, ngay namp nungkaraman wichanganan-a, aꞌ amanama, wik nungkaram minam ngayan waaꞌ-waaꞌangan thant pam wanchantan, aꞌ puth-a, ngay namp nungkaraman wichanganan-a, aꞌ amanama, ngay oony way anangan pentathangan thanttam pam wanchantaman, aꞌ ngay work piꞌan thamp yump-yumpangan.’ ");
INSERT INTO wim_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Aꞌ puth-a, ngay inan ngul thawāng thant pam wanchantan, ‘Niiyiya pam wanch ngatharam yaꞌa, ngay keꞌ meeꞌmiy niiyang, yaꞌa. Niiyiya pam wanch waya! puy kech iiyān aak ngatharam inpalan.’ ");
INSERT INTO wim_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Ngay wik kath inan waaꞌāng aawuch kuchamantama. Than pam wanch weeꞌ-weeꞌanangana wik ngatharaman ngeeyayn-a, aꞌ puth-a, ngangkangan piꞌ-piꞌayn ngul-a, an keꞌ than pam anan kuchek waap min yimanangana, nil aawuch aak minang thayanangan kaach nungantakamana. ");
INSERT INTO wim_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ngul-ngulaniya, ngak kaap wuut piꞌan ngulan wamp-wamp, aꞌ ngak yeeꞌ piꞌan uk-uk, aakan ngakangan yaꞌ maay, aꞌ putha wunt wuut piꞌan wunp-wunp. Puth aawuchana keꞌam keek yaꞌa. Anman thayanam than-than, nil puth pam alangan aawuch nungantaman aak minang thayanang kaach. ");
INSERT INTO wim_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Puth than pam wanch weeꞌ-weeꞌanangan wik ngatharaman ngeeyayn-a, puth kaangk keꞌ ngangkangan piꞌ-piꞌayn-a, an keꞌ than pam anan kuchek wayan yimanangan, nil aawuch aak wayangan kaach, chil michanganwey. ");
INSERT INTO wim_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ngul-ngulaniya, ngak kaap wuut piꞌan ngulan wamp-wamp, aꞌ ngak yeeꞌ piꞌan ngulan uk-uk, aakan ngakangan yaꞌ maay, aꞌ putha wunt wuut piꞌan thamp wunp-wunp. An puth aawuch nungantamana yaam keꞌam than, yaꞌa, erkam muutathiy keek, pum!!! — nhanth thuthanakam keek.” ");
INSERT INTO wim_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Nil Jesus.an kanan wik inangan thaw-a, than pam wanch yot anangan thaaꞌam ikin, ");
INSERT INTO wim_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","nilan puth wik keꞌ pam wiy al-alangan wik Moses.antaman waaꞌ-waaꞌin, an yimanangan nil keꞌam waaꞌa, yaꞌa. Puth nil Jesus.angana wik waaꞌ-waaꞌ keꞌ pam God.angan kuch nunang, wik min anman waaꞌ-waaꞌ thant. ");
INSERT INTO wim_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Aꞌ nil Jesus.ana uk ngul aak yoykam anpal kenyana. Than pam wanch yotang monkan-wakin nunang. ");
INSERT INTO wim_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Nil pam thonam angman wun-wuna, pam inmaniy-a, wenchangam makin nunangwey iiy-iiywey, kemp wakanangan. Nil Jesus alantan wampweya, pamaniya aꞌ pungkang thuchant aꞌ thawant, “Ayyang, Moom-ang! Nint kaangk nathweya min yumpin ngayangan-a, ngay puth kan meeꞌmiy nintangana nint minam ngul yumpin ngayanga.” ");
INSERT INTO wim_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Aꞌ nil Jesus.angana maꞌ ongkarama, aꞌ paman mam nunang aꞌ thaw nungant, “Ngay kaangka inman miyalathāng nintangweya, nint kemp min ngul iiy-iiyāna!” Aꞌ wenchan erkam wuthanam nungant, yaꞌ-ngul ween. ");
INSERT INTO wim_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Anpalaniy-a, nil Jesus.an wik thaaꞌ-thayanam thawant, “In ngeeya! Nint keꞌ waaꞌān thant wiy al-alantan ngayan nintangan miyalathanga. Nint kan erkam iiyān pam priest alantan, nil yipam thathow nintang kemp min ngulweya, wenchana yaꞌ-ngul utham. Anpalan-a, nint minh thakan kalān aawuch ngench thayanakana, aꞌ angan thaaꞌ-kuumpān nunang, piip God.an. Puth wik Moses.angan anman waaꞌ. Anpalan-a, pam wanch yotang ngul thathayn, aꞌ thiichayn nintang kemp min wench keꞌanang ngulana.” ");
INSERT INTO wim_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Aꞌ nil Jesus.an iiy-iiy aak-aakanakan aak nampa Capernaum.ak. Nil pam inan moom thanttama Roman soldiers al-alantaman umang wampant aꞌ thaaꞌ-mamanang thaw nungant maꞌ-aathow nunanganweya. ");
INSERT INTO wim_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Aꞌ nilan thaw nungant, “Ayyang, nil pam anana work ngatharang iiy-iiyan-a, nil weech-weechan nunang wurpang anman wun-wunan aak nungantamang anman, way-wayama. Nilana keꞌ yuupamiya, yaꞌa, way-wayam paththam wun-wunana, thaaꞌ-eench-eenchanweya.” ");
INSERT INTO wim_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Nil Jesus.an thaw nungant, “Ngay puy iiyānga aꞌ miyalathāng nunang.” ");
INSERT INTO wim_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Nil pam anan moom soldiersantamana thaw nungant Jesus.antan, “Yaꞌa! Nintan puth keꞌ iiyin aꞌ keꞌ ngoonchin pek aawuch ngatharamanga. Ngay ngul-nyaaꞌ wunanga, puth ngay pam min yaꞌa, nintan epa pam min-minam paththama. Nint puth wik thonakaman thawāna, aꞌ nil pamana koyam ngul miyal weenow. ");
INSERT INTO wim_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ngay yimananga moom piꞌanant work iiy-iiyangan. Work ngeenan theeꞌan ngathara yumpāngan-a, aniy-a, ngay yumpanga. Aꞌ ngay moom yimanangana keꞌ nint yimanangan iiy-iiyangan, ngay puth soldiers piꞌ-piꞌang thanang. Ngaywey thawing pam thonamant, ‘Nint iiyāna,’ an nilana iiyan paththam. Ngaywey thawing pam thon alantan, ‘Nint pal iiyāna,’ nil putha pal erkam iiyan ngathar. Ngaywey thawing pam thonamant, ‘Nint in yumpāna,’ aꞌ nil yumpan.” ");
INSERT INTO wim_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ngul nil Jesus.angan wik inangan ngeeyan-a, nilana thaaꞌam ik aꞌ nil thaw thant, pam wanch yotamantana nunangan monkan-wak-wakin, “Ngay inan waaꞌang niiyanta, pam ngay yimanangan keꞌam ngeeyanga keꞌ pam inana. Nil ngayang kan-kanam ngangkang piꞌ-piꞌ ngayanga. Aak umyompanam aak Israel.ang ngay yimanang keꞌam ngeeyang keꞌ pam inana. ");
INSERT INTO wim_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ngay in waaꞌang niiyanta, aak min-minam paththam ngul wampowa nil piip God.angan pam wanch puk maꞌ nungantangan piꞌ-piꞌow thanang. Aak an-aniyangan-a, than pam wanch puk thaaꞌ-wantanam ngul wamp-wampayn, aak kungk anpalan-a, puth aak yiip anpalan-a, puth aak kaaw anpalana, aꞌ puth aak kuuw anpalan wamp-wampayn aꞌ nyiin-nyiinayn thanttang angman Abrahama aꞌ Isaaca putha Jacob weeꞌanang thanttang. ");
INSERT INTO wim_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Nil piip God.angan kaangk thamp pam wanch wiy ananganiya pam wanch nungantam iiyayna, thanana puth kaangk keꞌ ngaantam-ngeeyayn nunangana. Nil God.ang kaangk maꞌangam piꞌow thanang, puth yaꞌa, nil puth kuchow thanang aak wayakan iiyayna aak ngaaꞌ aakanakana. Yaa, thananiy putha peey-peeyayna aꞌ koonh thanttakaman karr-karr path-pathwaynweya.” ");
INSERT INTO wim_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Aꞌ anpalana nil Jesus.an thaw pam moom soldier alantan, “Nint koyam kan-ngul iiyānweya aak nungkaramaka aꞌ pam work nungkarangan iiy-iiyan-a, an ngul miyalamowweya. Nint kan-kanam ngayangan ngaantam-ngeeyana ngayan miyalathāng nunangana, aꞌ putha ngay ngul miyalathāng nunang nungkarweya.” Aꞌ yaam keꞌanaman-a, nil pam workan iiy-iiy nungant-a, kanam miyal ngul weena. ");
INSERT INTO wim_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Amanamaniy-a, nil Jesus.an aawuch Peter.antamak iiy ngula, aꞌ nil thath nunang piny-kench nungantam Peter alantamana aak angman wurpang wun-wun weech-weechanweya nguntham piꞌanang uwan, kemp nungantamana karkan paththam weena. ");
INSERT INTO wim_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Aꞌ nil Jesus.angan maꞌ mam nunangweya, aꞌ an paththama nil erkam miyal ngul weena, kemp karkanamana an yaꞌ-ngul, kanam minchant. Aꞌ nilana ek-a, may ngul aath nunang Jesus.ana. ");
INSERT INTO wim_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Kinch-wayang ngulana, than pam wanchangana alpan yot anangan wamp-wampathin nungant, puth-a, than ananganweya oony way ngangkangan piꞌ-piꞌinana. Nil Jesus.ana wik thaw thanta, oony way al-alantana aꞌ kenth ngul thanang oony way anangan ngangk pam wanchantam anpalan. Than puth wiy anangan weech-weech thanangan-a, nil miyalath thanang. ");
INSERT INTO wim_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Nil Jesus.angan oony way thakan kenth thanttaman-a, puth-a, aniy-a, alpan anangan miyalath thanangan-a, nil meenath ngampar wik nil Isaiah.angan keenkanaman waaꞌ-waaꞌ ngampar, lat ngench thayanangana an kan-kanam waaꞌ nunanga wik inana, “Nilam thonakam maꞌ-aath-aathan ngampang, miyalathan ngampang weechan ngampangan yot umyompanamana!” ");
INSERT INTO wim_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Nil Jesus.angan pam wanch yotan thath thanang weentanaman than-thanin nungantangan-a, nil thaw thant ngurp nungantam al-alantan aak anan kan-ngul wantayn aak woꞌuwayn aakanakan moꞌaynweya. ");
INSERT INTO wim_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Aꞌ nil pam piꞌan thonam wamp nungant Jesus.antan, aꞌ thaw nungant, “Ayyang Moom-ang, ngay nintang monkan-wakāng, nint wanttinakan iiyān-a, ngay angman iiy-iiyāng nungkarangweya.” ");
INSERT INTO wim_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Nil puth Jesus.an thaw nungant, “Than kuꞌngekanam anangana yuk olotang pek-pekam wuntan, aꞌ putha minh panch yotam anangan than wurp thanttamang weep wuntan, puth nil pam anan nil God.angan kuch nunang-a, an nil aak aawuch keꞌanang weepan wunowweya.” ");
INSERT INTO wim_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Inana pam thonangan ngul, ngurp Jesus.antam thonamana, thaw nungant, “Moom-ang, nint kuchān ngayanga ngay kan piip ngatharaman awarang kaampāng nunangwey.” ");
INSERT INTO wim_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Aꞌ nil Jesus.an thaw nungant, “Nint ngayang monkan-wakāna, nint pam mulana too wantān, than-nungk kampan wiy al-alangan-a, ngul kaampaynweya, than wiy al-alangan wik God.antamana keꞌam ngaantam-ngeeyantan.” ");
INSERT INTO wim_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Aꞌ amanamaniya nil Jesus.ana chukkunang pey puth ngurp nungantam anangan thamp peyin wonk woꞌuwayn aakanakan moꞌin ngul. ");
INSERT INTO wim_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Aꞌ than ngak um-menhang ngulan-a, wunt wuut piꞌan paththam ngul wunp-wunp aꞌ yeelal piꞌan ek-ekin, ngakana chukkunang angan pey-pey aꞌ thananiya warꞌam thuchin. Puth nil Jesus.an-a, weep thayan wun-wun. ");
INSERT INTO wim_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Aꞌ thanan iiyin nungant aꞌ weepaman ekathin nunang Jesus.an aꞌ thawin nungant, “Ayyang Lord-ang, nint kaaꞌ-piichanathān ngamparakamana, ngamp ngul thuchampa!” ");
INSERT INTO wim_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Puth nilan thaw thant, “Niiy ngul ngeenam winynyang moꞌaniy e? niiy pam inanganiya ngangkangan keꞌam piꞌ-piꞌaniy ngayanganiy ey?” Aꞌ kanan wik thaw-a, nil ek ngul, aꞌ wik thayanam thaw pulant wuntantana putha yeelalantana; wuntana keꞌam ngul wunp, aak enyan ngul wun-wun, aꞌ puth yeelalana pekam thuch aꞌ popam ngul wun-wunwey. ");
INSERT INTO wim_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Than pam anangana thaaꞌam ikin aꞌ thawin thanttakaman, “Apey, nil ngul in wanttake? In nil pam wiy-wiyam ey? Pul wuntang aꞌ yeelalangan wik thonam anman ngeeypul nunang. Wuntana yaꞌ-ngul enyanam wun aꞌ yeelalana yaꞌ-ngul pekam thucha.” ");
INSERT INTO wim_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Aꞌ nil Jesus.an iiy aak Gadara aakanakana puth ananiy aak-a, wonk woꞌuwayna. Puth pul pam kucham anganiy wun-wunpul aak awar kunttowangana puth aak anganiya than pam wanch mul anangan kaamp-kaampin thananga. Aꞌ pulana oony way ngangkangan piꞌ-piꞌpul aꞌ kulliy thamp weenpulweya aꞌ pam wanch anangan keꞌam iiy-iiyin woyan aakanak wakana, yaꞌa, an than ngangk winynyang paththam moꞌ-moꞌin pulantaman. Aꞌ pam kucham anangana kan-ngul pentpul yoon awaramana. ");
INSERT INTO wim_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Aꞌ yaam keꞌanamana pulaniya Jesus thathpul nunang aꞌ wik othamayan pechpul nungant, “Ayyang! Puk nhengk God.antam-ang! Nint pal ngeenak wampan ngant e? Nint nganang wayathān ey? Aak inan yippaka keꞌam wampa, nint keꞌ wayathin ngananga erkamana.” ");
INSERT INTO wim_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Aak kech keꞌanamana, minh nhinthan yota may mungk-mungkin. ");
INSERT INTO wim_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Aꞌ than oony yot anangana thaaꞌ-mamanang thawin nungant Jesus.antan, “Kaangk nintwey kenthān ngananganiy-a, nintaniya kenthān nganang minh nhinthan al-alantang ngoonchānweya.” ");
INSERT INTO wim_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Aꞌ nil Jesus.an thaw thant, “Niiy kan iiyāna!” Amanamaniy-a, oony way yot anangana pol-pol pentin pam kucham al-alantaman aꞌ minh nhinthanantangan wupam ngoonch-ngoonchin ngul. Aꞌ than yotam anangan minh nhinthanana kamp othamayan moꞌ-moꞌin kaaꞌ um pek keekin ngakangana aꞌ mul wunin ngul, aꞌ puth thuchin ngul aak umpuyama. ");
INSERT INTO wim_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Aꞌ than pam anangan minh nhinthanan piꞌ-piꞌin-a, than kamp pek moꞌin aak town aakanakan. Aꞌ waaꞌin thant yotamantan nil Jesus.angan want-wanttakan yumpa, kenth thanang oony way yot anangan pam kucham al-alantaman pulantam amanamana oony way anangana ngoonchin ngul minh nhinthanantangana. ");
INSERT INTO wim_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Puth anpalana, than pam wanch yotam anangan aak townam anpalana umang iiy-iiyin nungant Jesus.antan; aꞌ thanan thathin nunang Jesus.an-a, than puth thaaꞌ-mamanang thawin nungant aak thanttaman kan-ngul wantow. ");
INSERT INTO wim_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Anpalana, nil Jesus.an kan-ngul chukkunangan chang pey aꞌ koyam moꞌ woꞌuwaynaka aꞌ wamp aak town nungantamakan. ");
INSERT INTO wim_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Aꞌ pam koꞌalamang pam kunpwey wampathin nungant Jesus.antan, nil pam alpanan pengkarang wun-wunwey, makar yaꞌ yalamant keꞌ-paal nilan keꞌam iiy-iiy. Nil puth Jesus.ang anan thathan-a, nilan kan meeꞌmiy thanang pam koꞌalam ananganiya than kan-kanam paththam minam ngaantam-ngeeyin nunang nil ngul miyalathow nunang pam alpananweya, aꞌ nil Jesus.an thaw ngul pam kunp alantanwey, “Ayyang, nhengk ngatharam-ang! Nint keꞌ winynyang moꞌāna! Way nintan yump-yumpan-a, an yaꞌ-ngula, ngay keꞌ-ngul ngaantam-ngeeyāng yaꞌa!” ");
INSERT INTO wim_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Aꞌ anpalana, than pam piꞌ-piꞌanam wiy anangan wik thayan thaaꞌan-aath-aathin thanangan-a, thanan thawin thanttakaman, “Nil pam ilangan-a, keꞌ God.an waaꞌ-waaꞌan nungantakamana!” ");
INSERT INTO wim_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Nil puth Jesus.angan kanam thiich thanang than want-wanttakan ngaantam-ngeeyin putha thaw-thawinana, aꞌ nil thaw thant, “Niiy ngul wanttake? kuchek wayam niiyant ey? way anman ngaantam-ngeeyaniy ey? ");
INSERT INTO wim_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ayyang, in ngeeyāna! Ngay nyiingkan yimanangan thawang pam alpan alantan, ‘Ngay keꞌ-ngul ngaantam-ngeeyāng way nintan yump-yumpana.’ Yaa, niiy wanttak ngaantam-ngeeyaniya? An work piꞌan paththam ey? Nath yaꞌa, nath work many way-wayang, engkanang ey? Ngay nath wik yimanangan thawing alpan alantana, ‘Kan eka! aꞌ iiyān ngula!’ An work piꞌan paththam ey? Nath yaꞌa, nath work many way-wayang engkanang ey? ");
INSERT INTO wim_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Yaa, ngay in kan meenathāng niiyant nil God.angan kuch ngayang, yipmam ngay thawāng thant pam wanchant, ‘Ngay keꞌ-ngul ngaantam-ngeeyāng way niiyan yump-yumpan.’ Ngay puth pam inman nil God.angan kuch.” Anpalana, nil Jesus.an thaw pam alpan alantan, “Ngay inan thawāng nungka, kan ekāna aꞌ yuk pengkar nungkaram nanan-a, maayān, aꞌ kan-ngul iiyān aak nungkaramaka!” ");
INSERT INTO wim_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Aꞌ nil paththam alpanana erkam ek, aꞌ than ngul, aꞌ kan-ngul iiy aak nungantamakanwey. ");
INSERT INTO wim_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Than pam wanchangan thathinan-a, than winynyang ngul moꞌin. Aꞌ thananiya thaaꞌ-kuumpin nunang piip God.an nil puth work piꞌan inan want maꞌ nungantang Jesus.antangana. ");
INSERT INTO wim_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Aꞌ nil Jesus.angan-a, aak anan kan-ngul want, aꞌ iiy-iiy ngul, aꞌ nil pam inan thath nunang nilaniya wukal tax anangan yal-yalmath pam piꞌan alantan. Nilana office angman nyiin-nyiin. Namp nungantiy-a, Matthew. Aꞌ nil Jesus.an thaw nungant, “Ayyang, nint ngayang monkan-wakāna.” Aꞌ nil Matthew.ana erkam paththam ek-a, aꞌ monkan-wakan Jesus.ana. ");
INSERT INTO wim_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Anpalaniy-a, nil Jesus.angan may mungk nungantang, Matthew.antang aawucha. Pam wanch yot wampin, wiy anangan-a, keꞌ Matthew yimanangana wukal tax anangan yal-yalmathin pam piꞌan alantana, wiy anangan-a, pam wanch kaangk-keꞌanang ananganweya. Than thampa karpam nyiinina, aꞌ may mungkin thanttang, Jesus.antang, aꞌ ngurp nungantam al-alantangan. ");
INSERT INTO wim_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Than puungk wiy Pharisees al-alangan thathinan-a, than thawin ngurp Jesus.antam al-alantan, “Nil moom niiyantam alangan ngeenak mungkan thanttang pam way il-ilantangan e?” ");
INSERT INTO wim_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Nil Jesus.angan ngeey thanangan-a, nilan thaw thant, “Than pam wanch keꞌaman weechan thanang-a, an keꞌam iiyantan nooyananta, yaꞌa. Pam wanch weechanan-a, an ep iiyantan nooyananta. ");
INSERT INTO wim_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Niiy iiyāna aꞌ wik God.antam inangan ngaantam-ngeey-ngeeyāna wanttakan waaꞌan lat ngench thayanangana, wik inangan, ‘Ngay keꞌ kaangk minhan mulathantan thumang ngulan kiingkantan ngathara yaꞌa, ngay inan ep-paththam kaangka, niiy ngangk minangam iiy-iiyān niiyantakamana aꞌ ngangk mam-mamwunweya niiyantakamana.’ Ngay keꞌam wampanga yipmam pam wanch anangan umpāng thanang than minan waaꞌwuntan, yaꞌa. Ngayan ep wampanga yipam pam wanch way anangan umpāng thanang thanan yipam ngayang monkan-wakayn.” ");
INSERT INTO wim_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Anpalan-a, than ngurp John.antam anangan wampin nungant Jesus.antan aꞌ thawin, “Ayyang, nint kan waaꞌān nganta! An wanttake? Ngan-a, puth Pharisees anangana maꞌ-yotam may keꞌam mungk-mungkanana, puth ngurp nungkaram anangana yaꞌa than ep-paththam may mungkantan, than kaangk may anman mungk-mungkayn. An ngul wanttake?” ");
INSERT INTO wim_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Nil puth Jesus.an thaw thant, “Niiy kan wik kath inan ngeeyāna! Pul pam wanch nath ngentwiwpul-a, thanan nath may piꞌan yumpayn wedding party aakanakan. Ngul than pam wanch kampan pulantam anangana ngangk way wunow thant ey? mayan keꞌ mungkayn ey? An yaꞌa, nil pam kompan wanchan ngentow-a, nil angman thintham iiy-iiyow thanttang, aꞌ thananiya ngangk min wunayn, aꞌ may karpam mungkayn. Puth aakan ngul wampowa, than pam wiyangan pam kompan nath kalayn nunang aak thonaka, kampan nungantam al-alangan keꞌ-ngul thathayn nunang. Puth aak an-aniyangan-a, than may thanttaman too ngul wantayn.” ");
INSERT INTO wim_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Nil wik kath inan ngul waaꞌ thant, “Nil wanchang kulich kath ikanam piꞌ-piꞌiywey-a, an ngul nilan ngook nyiingkanam manyan ikathiy ey? aꞌ ngook ikanam kathangan-a, angan wakiy ey? An yaꞌa, puth ngook nyiingkanamana an manyam kenyam yalamiy, aꞌ puth-putham ngul ikiy yuutamp piꞌan ngul wuniya.” ");
INSERT INTO wim_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Anpalaniya nil Jesus.angan wik kath thon ngul waaꞌ thant, wik kath minh peꞌan sheepantaman puth aak thant yimanangan wunana than wine yeech-yeechin minh peꞌan sheepantamang, keꞌ ngaꞌalangk yimanangan. Aꞌ nil Jesus.an thaw ngul, “Than pamangan wine nyiingkanaman peꞌan kath al-alantangan keꞌam yeechantan. Than peꞌan kathang angman yeechiythanwey-a, puth peꞌanan ikiy aꞌ wine.an yaꞌ-ngul wuniy, peꞌanan way paththam ngul wuniy. Than pamangan wine nyiingkanaman peꞌan nyiingkanamang yeechayn, yipam minam wunow wine.aniy aꞌ puth peꞌan thampa minam wunow.” ");
INSERT INTO wim_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Aꞌ nil Jesus wikan yippak thaw-thaw thantan-a, nil pam piꞌan Jews.antam angman wamp nungant, aꞌ pungkang thuchant um nungantang aꞌ thawant, “Ayyang, puk wanch ngatharamana nyiingk uthama. Nint pal erkam iiyāna aꞌ maꞌ wunpān nungant nil yipam koyam man-yethamowa!” ");
INSERT INTO wim_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Aꞌ anpalan-a, nil Jesus.an ek ngul, aꞌ karpam iiypul ngula. Puth-a, ngurp nungantam anangana iiyin thamp nungantang. ");
INSERT INTO wim_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Nil wanch thonam angmana, nil wewmangan want-want nunang kaap twelve.akamana. Nilan puth koy-koyyuw iiy Jesus.antang, aꞌ thaw nungantakaman, “Ngay ngook nungantam inan maꞌang mamānga, ngay yipam miyal ngul weenānga.” Aꞌ nil ngook nungantaman mam ngul. ");
INSERT INTO wim_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Nil Jesus.an weent aꞌ thath nunang. Aꞌ nilan thawant, “Ayyang, puk ngatharam-ang, nint ngangk thayanam iiyāna! Keꞌ winynyang moꞌāna! Nint kan-kanam ngaantam-ngeeyan ngayanga puth ngay ngul miyalathāng nintang. Puth amanaman-a, ngay kan-kanam miyalathāng nintang.” Aꞌ nil wanchan miyal paththam ngul weena, keꞌ-ngulan wewmangan want nunang, yaꞌ-ngul. ");
INSERT INTO wim_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Anpalana, nil Jesus.an aawuch pam piꞌan alantaman ngul wampa aꞌ pek ngul ngoonch. Aꞌ nil thath thanang pam wiy anangan angman than-thanin yukan keeꞌ-keeꞌathin puk mulantamana, aꞌ nil pam wanch yot anangan thath thanang peey-peeyin, ");
INSERT INTO wim_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","aꞌ nil thaw thant, “Ayyang, niiyalang, niiy yotam kan yoon pentāna! Nil puk wanch many inan keꞌam uthama, yaꞌa, nil weep thayan thonakam wun-wunana.” Puth than pam wanchangan thaaꞌ-thengkathin nunang Jesus.an. ");
INSERT INTO wim_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Nil kanan kenth thanang pam wanch anangan-a, nil aak pek ngoonch puk wanch many alantan puk wanch mulan wun-wun ang pekana, aꞌ maꞌ mam nunang. Nil puk wanchana, ek ngula. ");
INSERT INTO wim_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Aꞌ thanan aak angman aꞌ aak thon-thonangan wik thooꞌ weꞌarathin nungantam palam-puyam puth nilan puk wanch manyan ekath nunang mulamana. ");
INSERT INTO wim_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Nil Jesus.angana aak anana want ngul. Nil kanan iiy-iiy woyan wakanan-a, pam kuchamwey meeꞌ koꞌanchwey monkan-wak-wakpul nunang. Pulana pech-pechpulweya, “Ayey! kampan David.antam ey! Nint nganangan keꞌ ngangk mamin ey?” ");
INSERT INTO wim_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Nil Jesus.ana aawuchangan ngoonch, puth pulaniya angman wamppul nungant. Aꞌ nil Jesus.ana thaw pulant, “Nip ngul kan-kanam ngayanganiy ngaantam-ngeeyanip ey? ngay meeꞌ min yumpāng nipang ey?” Pulaniy thawpul, “Eeꞌa, mooma.” ");
INSERT INTO wim_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Nil puth Jesus.angan-a, meeꞌ pulantamana maꞌang mam, aꞌ thaw ngul pulant, “Ngay nipang inman meeꞌ min yumpānga, nip puth ngayangana kan-kanam ngaantam-ngeeyanipa.” ");
INSERT INTO wim_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Aꞌ nil Jesus.angana meeꞌ min yump pulang, aꞌ wik thayan thaw pulant, “Nip keꞌ waaꞌow ngayanga ngay meeꞌ minan yumpang nipanga.” ");
INSERT INTO wim_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Puth pulaniya aak anan wantpul, aꞌ aak anman weent-weentpula aak thon-thonangana, wikana pal-puy waaꞌ-waaꞌpul aak anganiy Jesus.antamana. ");
INSERT INTO wim_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Than pam al-alangan aak kanan want-wantin-a, pam wanch wiyangan-a, pam thonam wampathin nunang Jesus.antan, nil puth wik keꞌam thaw-thawa, nil oony way ngangkang piꞌ-piꞌ. ");
INSERT INTO wim_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Nil puth Jesus.angan-a, oony wayan-a, kenth nunang pam alantamana. Amanamaniya, nil pamana wik ngul thaw. Than pam wanch anangan-a, meeꞌam ikin, aꞌ thawin ngul, “Ngan keenkana yimanangan keꞌam thathan aak Israel.angana, yaꞌa! In-ngulan thathana!” ");
INSERT INTO wim_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Puth than pam Pharisees anangan thawin, “Nil oony piꞌan paththam alangan maꞌ-aath-aathan nunang, keꞌ-paal nil oony way anangan kenthan thanang pam wanchantamana.” ");
INSERT INTO wim_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Nil Jesus.ana aak pal-puyamim iiy-iiy, aak thon-thonan towns-a, villages thampan uw-uw. Aꞌ kan-ngul pam wanch thaaꞌ-aath-aath thanang aak churches Jews.antamang angana. Aꞌ wik min anangan waaꞌ-waaꞌ thant aakan wampow nil God.angana maꞌ nungantangan pam wanch yotan piꞌ-piꞌow thananga. Aꞌ nil pam wanch yota miyal-miyalath thanang weechan thanangana, puth keꞌan ngeeyina, putha maꞌan yalamin, puth koꞌanch anangan-a, puth kuchek wayangan uw-uw thananga, wench thak keꞌ penchiy wun yimanangana, puth maꞌ punth makaran yalamin thakan. ");
INSERT INTO wim_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Than pam wanch yot anangana angman wamp-wampin nungant Jesus.antan, nil puth ngangk mam thanang, thanan puthwey kemp waya, wiy ananganiya kuchek way iiy-iiyin, ngangk way thakan iiy-iiyina, keꞌ minh sheep than-thanam yimanangan iiy-iiyantan, thaaꞌ-weep-weepantan keꞌ moom keꞌanang yimanangana. ");
INSERT INTO wim_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Aꞌ nilan puth thaw thant, ngurp nungantam al-alantan, “Pam wanch yotamang wik min ngatharamaniya kaangk ngeeyaynweya, puth niiyiya koꞌalamangweya il-ilangaman wik minaniya waaꞌ-waaꞌān thant. Than pam wanch yotam anangana keꞌ may menchan yukaman uk-ukantana, puth than pam koꞌalam anangaman work iiy-iiyantan, may menchan anangan yipam yalmathayn. ");
INSERT INTO wim_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Yaa, niiy meeꞌ-wuthanamāna piip God.antana, aꞌ engkān nungant pam wanch yot kuchow thananga than yipam wik ngatharamana waaꞌ-waaꞌayn thant.” ");
INSERT INTO wim_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Aꞌ nil Jesus.angana pam ngurp nungantam twelve anangan karpam yalmath thanang. Nilan thaw thant, “Ngay inan thawāng niiyant — ngay maꞌkunch yumpāng niiyanga, aꞌ maꞌ-aathāng niiyang niiyaniya yipam oony way anangan pam wanchantaman kenthān thanang; aꞌ putha pam wancha weechan thanangan-a, niiyaniya miyalathān thanang.” ");
INSERT INTO wim_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Pam ngurp twelve nungantam ananganiya, nil apostles waaꞌ thanang nil ngulan kuchow thanang wik min nungantaman waaꞌ-waaꞌayn pam wanchantan. Pamiya namp inangan nilan miꞌ thanang: Simona (ngul-ngulana Jesus.angana namp thon ngul theeꞌ nungant, namp inan theeꞌanta, Peter); aꞌ putha kuunch nungantam Andrewa, putha pul kuuncham James-a, aꞌ Johna, nhengk nungantam, Zebedee alantamana; ");
INSERT INTO wim_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","aꞌ putha Philip-a, aꞌ Bartholomew; putha Thomas, aꞌ putha Matthew, pam nilan wukalan yal-yalmath pam piꞌan alantana; aꞌ putha James-a, nhengk nungantam Alphaeus.antama, putha Thaddeusa; ");
INSERT INTO wim_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","aꞌ putha Simona thanan waaꞌ-waaꞌin nunang Patriot, nil puth aak nungantamakana kaangk wun paththama, aꞌ putha Judas Iscariot. Nil pam ilangaman ngulaniya maꞌaman theeꞌow nunang Jesus.an pam soldiers al-alantan mulathayn nunangana. ");
INSERT INTO wim_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","6","Aꞌ nil Jesus.an thaw thant pam ngurp nungantam twelve al-alantan, “Niiy paththam aakanakan iiyāna pam wanch Jews al-alantan aꞌ wik min God.antamana waaꞌ-waaꞌān thant. Niiyiya aak thanttam Jews yaꞌ al-alantamakan keꞌ iiyāna aꞌ putha aak Samaria.akana niiy keꞌ iiyān, yaꞌa. Niiy pam wanch Jews anman uwān thanang, puth thanan keꞌ minh sheep yimanangan yaarkamin nungantam piip God.antamana, thaaꞌ-weep-weepantan nungantam. ");
INSERT INTO wim_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Niiy iiyān thant paththama aꞌ wikan waaꞌān thant, aakana thinth ngul kan wamp-wampana nil piip God.angana pam wanch yota maꞌ nungantangan piꞌ-piꞌow thananga. ");
INSERT INTO wim_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Pam wanch way alpan anangana miyalathān thanang; aꞌ pam wanch mulamana, niiy ekathān thanang; puth pam wanch anangan wenchangaman mak thanangwey-a, niiyiya minam yumpān thananga, aꞌ putha oony way ngangkanganwey piꞌ-piꞌantan-a, niiy kenthān thanttamana. Nil puth piip God.angana ngangk minangam maꞌ-aath-aathan niiyang, yipam work piꞌanan iiy-iiyān nunganta, nil wukalakana keꞌam thawan niiyanta theeꞌān nungantan, yaꞌa. Niiyiy putha yimanaman pam wanch anangan maꞌ-aath-aathān thanang, wukalakan niiy keꞌ thawān thantana. ");
INSERT INTO wim_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Aꞌ niiyaniya wukal keꞌ kalān pocketangan, ");
INSERT INTO wim_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","aꞌ niiy bag manyana keꞌ kalān may kalanakana. Aꞌ putha niiy keꞌ kalān shirt kuchamana, thonam anman ep-paththamweya. Aꞌ putha thaꞌ murrukana kucham anman thaꞌangaman ngoonchāna, anman thonakama, wiy thampana keꞌ kalān, yaꞌa, aꞌ putha yuk pil thookana thonam anman maꞌangan kalāna. Puth pam wanch anangan niiyan maꞌan-aathan thanang-a, an thaniya may thakan ngul aathayn niiyanga, niiyan puth work inan nungant iiy-iiyaniy piip God.antana. ");
INSERT INTO wim_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“In ngeeyiy a! Niiy aak townak kanan ngoonchān-a, niiy aak pal-puy thathāna nil weeꞌang nathwey ngangk minangam umang wakow niiyangana. Niiyana aak angman wunān aawuch nungantamanga, aawuch anpalman niiyaniy iiyāna aak thonakana. ");
INSERT INTO wim_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Niiy aawuch thon-thonangan wampān thant-a, niiy wik inangan thawān thanta, ‘Ngay kaangk God.ana min-minam paththam iiy-iiyow niiyant.’ ");
INSERT INTO wim_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Than pam wanch anangan aawuch angan wuntana nath ngangk minangaman iiyayn niiyantan-a, yaa, nil God.ana min iiyow thant keꞌ niiyaman thawan thant. Than keꞌwey ngangk minangaman iiyayn niiyantan-a, yaa, nil puth piip God.ana min keꞌ iiyiy thant, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","“Niiy nathwey aak town thonak ngulan wampān-a, aꞌ than umang keꞌwey wakayn niiyangan-a, aꞌ putha than kaangk keꞌan wik ngeeyayn niiyangan-a, yaa, niiyaniya aak anana too wantāna, aꞌ thaꞌ wookana wunyathān thantana anpalana than kaangk keꞌan wik niiyantaman ngeeyayn. ");
INSERT INTO wim_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Puth in ngeeyāna: aak keenkanamana aak Sodom amanamana puth aak Gomorrah amanamana pam wanch anangana way-wayam paththam iiy-iiyin. Puth ngay inan kan-kanam waaꞌāng niiyant: ngul-ngulana, aak anan wampow nil God.angana umangam thanathow ngampang-a, nilan pam wanch aak Sodom aꞌ Gomorrah anpalmana wayanang waaꞌow thanang aꞌ aak wayak kuchow thanang, puth pam wanch anangaman than kaangk keꞌan niiyang-a, nilana waaꞌow thanang pam wanch anangan way-wayam paththama, aꞌ putha kuchow thanang aak wayakana. ");
INSERT INTO wim_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Thon in kan waaꞌāng niiyant: ngay inana kuchāng niiyang pam wanch way-wayam paththam al-alantan. Puth niiyaniya maal anman iiy-iiyān thanttangana, keꞌ minh sheep anman, kulliy yaꞌa; than pam wanch ananganiy-a, kulliy weenayn niiyant, keꞌ kuꞌ kulliy yimanangana. Niiyiya kuchek waap min-minam paththam iiy-iiyāna, aꞌ putha kulwey iiy-iiyān keꞌ minh panch kolat yimananganweya. ");
INSERT INTO wim_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Yaa, niiyaniya meeꞌ yanth-yanth iiyāna pam wanch way al-alantaman than puth ngul mamin niiyang, aꞌ courtak kaliythan niiyang, aꞌ puth piikiythan niiyang aak churches Jews.antamang angana. ");
INSERT INTO wim_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Niiy puth ngayangweya monkan-wak-wakaniy thanan puth nanpalan mamayn niiyang aꞌ umang thanathayn niiyang pam moom piꞌ-piꞌanam al-alantang. Niiyan paththama wik min God.antaman waaꞌān thant aꞌ putha pam wanch Jews yaꞌana al-alantan thamp waaꞌān thant. ");
INSERT INTO wim_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Than umangan thanathayn niiyang pam moom piꞌ-piꞌanam al-alantangan-a, niiyaniy kuchek keꞌ wayamāna, puth niiyana keꞌ ngaantam-ngeeyān niiyantakama, ‘Ngay wik ngeen thawāng e? ngay want-wanttaka wik min thawāng e?’ Yaꞌa, niiy keꞌ ngaantam-ngeeyān yimananganiya, nil piip God.angana ngul waaꞌow niiyant niiy wik ngeenan thawān thant. ");
INSERT INTO wim_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Niiy puth wik niiy-niiyaman keꞌ thawina kuchek waap niiyantam anpalan, yaꞌa; nil Ngeen-Wiy Min piip God.antam alangana ngul waaꞌow niiyant niiy wik want-wanttakan thawān thantana. ");
INSERT INTO wim_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Aak an-aniyangan-a, pam wiy al-alangan-a, pam kuunch thanttam anangan maꞌam theeꞌayn thananga pam wiyangan mulathayn thanang; putha piipiy wiyanganiya maꞌam theeꞌayn puk thanttam anangan wiyangan mulathayn thanang; aꞌ puk nhengk wiy al-alangana kaath piip thanttam ngangk-wayangam kalayn thanang aꞌ maꞌam theeꞌayn thanang wiyangan yipam mulathayn thanang. ");
INSERT INTO wim_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Pam wanch yotangan ngangk-wayangam kal-kalayn niiyang, puth anpalan niiy ngayangan monkan-wak-wakaniya. Nil weeꞌanganweya keꞌ-ngoongkam anman monkanan-wak-wakow ngayanga, keꞌan eenchow-a, nilaniya ngangk aak umpuyam wunow piip God.antangan. ");
INSERT INTO wim_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Thanwey aak thonamang ngangk-wayangam kaliythan niiyangwey-a, nathwey yukang thak piikiythan niiyang-a, yaa, niiyana aak thonak erkam iiyāna ngula. Kan in ngeeyāna; niiyaniya wik min God.antamana pal-puy waaꞌ-waaꞌān aak town thon-thonangana aak Israel.angana. Work niiyantam keꞌan yippak minchow-a, ngay inman pam nil God.angan kaꞌathaman kuchany-a, ngay palam ngul wampānga. ");
INSERT INTO wim_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Aꞌ ngay in thampan waaꞌāng niiyant: pam teacherana pam piꞌan iiy-iiyana; puth pam nungantam anangana nilan piꞌ-piꞌan maꞌ nungantangana, than pam piꞌan yaꞌa. An aak yimanangana, nil pam moomana pam piꞌan iiy-iiyan; pam workan iiy-iiyantan nungantan-a, an than pam piꞌan yaꞌa. ");
INSERT INTO wim_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Than pam wanchangan nath ngangk-wayangam kal-kaliythan nunang teacheranwey-a, aꞌ puth way yumpiythan nungant-a, an thanana pam wanch nungantam al-alantan thamp way yumpiythan. Than nathweya pam mooman ngangk-wayangam kal-kaliythan nunang-a, putha way yumpiythan nungant-a, thananiya pam workan iiy-iiyantan nungantana thanang thamp ngangk-wayangam kal-kaliythana putha way thamp yumpiythan thanta. Aakan yimanangan wunow niiyant pam wanch ngurp ngatharam il-ilantan way thamp yump-yumpayn niiyantweya. Than nath way inangan yumpayn niiyantan-a, yaa, an puth kanweya, niiyan ngangk wayaniya keꞌ iiyāna, niiywey ngangk thayanam anman iiy-iiyāna, an puth waya kaꞌathamana ngathar yumpin — niiyantan-a, yimanangan yump-yumpayn. Pam wanch wiyanganiya Beelzebula waaꞌ-waaꞌantan ngayang, ngay keꞌ moom piꞌan oony way al-alantamana — yaa, thananiya wik way-wayam paththam waaꞌ-waaꞌayn niiyanga akayn niiyang nenchayn niiyang thaka. ");
INSERT INTO wim_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Yaa, niiy puth keꞌ winynyang moꞌān pam wanch al-alantamana. Than pam wanchangan wik thaaꞌ-mupaman piꞌ-piꞌayn thanttakamanwey-a, ngul-ngulana, maꞌmangkamangan ngul thiichayn wik thanttamana. Than wik ngeenan yump-yumpayn thaaꞌ-mupaman-a, ngul-ngulaniya than maꞌmangkamangana ngul ngeeyayna wik ananganiya than keꞌ thenchwiythan, yaꞌa. Than wiyiya, ep wik min thaw-thawantan thaaꞌ-mupaman, ngul-ngulaniy-a, an than maꞌmangkamangana ngeeyayn ngula. ");
INSERT INTO wim_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Yaa, ngurp ngatharam-ang, ngay puth kanam wik waaꞌ-waaꞌang niiyant ngamp aak pok-pokkapangan iiy-iiyanampa, ngampaniy putha wik anangana maꞌ-mupam piꞌ-piꞌanamp ngamparakama, puth ngul-ngulaniya niiyana meeꞌ yotantang aak engkanang thaaꞌ-aath-aathān thanang, pam wanch anangan, wik min ngatharaman koochanathān thant. ");
INSERT INTO wim_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Niiy keꞌ winynyang moꞌāna pam wanch al-alantaman mulathayn niiyangana; than kemp thonakam mulathiythan, ngangk niiyantamana, an yaꞌa, keꞌ mulathiythan. Niiy nungantam piip God.antaman ep winynyang moꞌāna, nil aak wayakan nath kuchiy niiyang aak umpuyamana, kemp maꞌmangkamana putha ngangk niiyantam thampana theeꞌiy niiyang aak wayang angana thumang pench-penchinweya. ");
INSERT INTO wim_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Puth niiy kan wik inan ngeeyāna: niiy minh panch kucham sparrows nath piiyina wukal manyanga, keꞌ two centsang yimanangana. Nil puth piip God.angana maꞌangam piꞌ-piꞌan thanang minh panch many pattakam anangana. Nil minh panch many sparrowa thonamweya aakangan keekiya aꞌ mul ngulan wuniy aakang-a, an nil thathan piip God.angana, puth nilan kan aak miꞌant minh panch manyan uthamowana. ");
INSERT INTO wim_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Aꞌ putha nil niiyang thamp thathana, nil meeꞌmiya yangan ngeen-ngeenan piꞌ-piꞌaniy kuchek niiyantamangan. ");
INSERT INTO wim_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Yaa, niiyana keꞌ ngangk winynyangan moꞌān, nil God.an ngangk niiyantakam anmana, nil niiyantan ep-paththam kaangk wunan, puth minh panch yot al-alantan yaꞌa, chil-chil!” ");
INSERT INTO wim_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Aꞌ nil Jesus.an thaw ngul, “Ngay thon inan thawāng niiyant. Nil pamwey nath thawiy meeꞌ yotantangana, ‘Nil Jesus.an moom ngathara, ngay pam nungantam inan iiy-iiyanga.’ Aak anan wampow nil piip God.angana pam wanch umangan thanathow thanangan-a, ngayan puth thawāngant piip ngatharamant God in kenyan wunan, ‘Nil pam ilangan keꞌ-ngoongkam ngayangaman monkan-wak-wak, nil pam ngatharamweya.’ ");
INSERT INTO wim_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Puth nil pamwey thawiya meeꞌ yotantangan-a, ‘Nil Jesus.an moom ngatharam yaꞌa, ngayan puth keꞌam iiy-iiyang nungantangana’ — yaa, aak anan wampow nil God.angan pam wanch umangan thanathow thanang-a, ngayan puth thawāng piip God.antan, ‘Nil ngayang keꞌam monkan-wak-wakanya, yaꞌa, nil pam ngatharam yaꞌa.’ ");
INSERT INTO wim_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Niiyan nath yimanang ngaantam-ngeeyaniy niiyantakam, keꞌ ngay aak iikanakan ukangana yipam niiy yotaman ngangk minangam iiy-iiyān niiyantakamana, kul keꞌanang wun-wunānweya, karpam anman ngaantam-ngeey-ngeeyān. Puth yaꞌa, an aak yimanangan keꞌ wunow niiyanta. Than pam wanchangan ngul thaampwayn thanttakam aꞌ thaaꞌ-thayanamayn ngatharam peeyanang. Than puungk wiyangana ngayang ngul monkan-wakayna, putha wiyangana, yaꞌa, than thaampayn ngayanga aꞌ kulak wenkayn thant pam wanch al-alantan than ngayangan monkan-wak-wakantan, wiyiya mulathayn thanang thaka. ");
INSERT INTO wim_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Aawuch thonamangan wuntan-a, an ngatharam peeyanang wakwiythana, pul nath maꞌ-piip-nhengkwey thaampwiypul pulantakaman ngatharam peeyananga, aꞌ maꞌ-kaath-puk nath thaampwiypul pulantakaman, nath maꞌ-piny-nhengk yimanangan thaampwiypul pulantakaman ngatharam peeyanang. ");
INSERT INTO wim_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Kampan thanttam al-alangan puy-puyam thaamp-thaampayn thanang ngangk-wayangaman kal-kalayn thanang pam wanch monkanan-wak-wakantan ngayangana. ");
INSERT INTO wim_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Ngay thon inan waaꞌāng niiyant: nil weeꞌ-nathwey kaath piip nungantamak kaangk wunan paththamwey-a, aꞌ ngatharana chil-chilwey kaangk wunow-a, an puth nilana ngurp ngatharam keꞌ iiyow yaꞌa. Aꞌ nil weeꞌ-nathwey puk nungantamakan kaangk wunan paththamwey-a, aꞌ ngatharan chil-chilwey kaangk wunow-a, an nilana ngurp ngatharam keꞌ iiyow, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Nil weeꞌanganweya kaangk monkan-wak-wakow ngayangan-a, nilaniya keꞌ ngaantam-ngeeyow nungantakamana, yaꞌa, nil nungantakaman kon-ngathowana. Pam wanch al-alangan nath mulathayn nunanga, keꞌ ngayangan mulathayn, yuk wuuyanangan waanchayn ngayang. Nungkway than wiyangana nath mulathayn nunang-a, nilana ngayang anman monkan-wak-wakow. ");
INSERT INTO wim_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Nil weeꞌangwey wantow ngayangana pam wanch wiyangan keꞌ yipam mulathayn nunang-a, an nilaniya keꞌ wuniy aak ngatharamangan, yaꞌa, an aak wayang wunowa, puth nil weeꞌangwey anman ngangk-thayanangama monkan-wak-wakow ngayangan-a, nungkway pam wanch wiyangana thaaꞌ-thengkathiythan nunang-a, nath mulathiythan nunang-a, an nil ngangk aak umpuyam ngul wunow aak ngatharamanganweya. ");
INSERT INTO wim_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ngay wik inan thamp thawāng niiyant. Nil weeꞌ-nathweya ngangk minangam iiyow niiyant-a, an nil keꞌ ngathar yimanangan ngangk minangam iiy-iiyan, aꞌ putha nil weeꞌ-nathweya ngangk minangam iiyow ngathar-a, an nil keꞌ piip ngatharam God.antan ngangk minangam iiy-iiyan nungant thampa, nil puth piip ngatharamangana kuch ngayang aak iikanakan. ");
INSERT INTO wim_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Nil paman nathweya wampiy nil yipam wik min God.antaman waaꞌow. Than weeꞌ-weeꞌanangan ngangk minangam iiy-iiyayn nungantan-a, than puth kaangk wik min God.antaman ngeeyayn-a, nil piip God.angana thaaꞌ-kuumpow thanang pam wanch anangan aꞌ putha min iiy-iiyow thanta. Thon ina, than weeꞌ-weeꞌanangan nathweya pam min alantan ngangk minangaman iiy-iiyayn nungantan-a, nil puth pam mina, nil piip God.angana thaaꞌ-kuumpow thanang pam wanch anangan aꞌ nilana min iiy-iiyow thamp thantaniya. ");
INSERT INTO wim_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ngay puth wik inana kan-kanam thawāng niiyant: pam ngurp ngatharam wiy anangana pam piꞌan yaꞌa, thanwey pam manyiya, kaangk-keꞌanang maꞌmangkiy yaꞌweya. Nil weeꞌang nathweya ngak thaaꞌ kucharan theeꞌiy thant-a, puth anpalan than ngayangan monkan-wak-wakantan-a, ngay thaaꞌ-kuumpāng nunang, putha minam piꞌ-piꞌāng nunang.” ");
INSERT INTO wim_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Nil Jesus.angana wik inangan kanan waaꞌ-waaꞌ thant-a, nil aak anana want ngul, aꞌ iiy ngul aak thonak town wakan iiy-iiy wik min God.antaman waaꞌ-waaꞌ thant ngul. ");
INSERT INTO wim_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Aak an-aniyangan-a, nil pam namp Johna, nilana pam wanch kootra ngakangan kuungk-kuungk thanangana, nil aak jailang wun-wun. Nilaniya wik thooꞌ ngeey work wuut piꞌan Jesus Christ.angan yump-yumpa. Nilana pam ngurp nungantam wiy anangan kuch thanang Jesus.antan yipam engkayn nungant. ");
INSERT INTO wim_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Than wampin-a, engkin nungant Jesus.antan, “Ayyang, nint kan waaꞌ nganta! Nint pam anan ey? Nil John.angan waaꞌ-waaꞌ ngant ey? nint wampānan ey? Nint nath yaꞌa! Ngan nath pam thon alantan kuup-kuupān nungant ey?” ");
INSERT INTO wim_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Puth nil Jesus.an thaw thanta, “Niiy koyam iiyāna, aꞌ waaꞌān nungant John.antana niiy puth meeꞌ niiyantamang thath-thathana, putha kon niiyantamang ngeey-ngeeyana: ");
INSERT INTO wim_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","pam wanch meeꞌ koꞌanch anangana koyam meeꞌ min iiy-iiyantan; pam wanch kunpan wunin-a, minam ngul iiy-iiyantan; pam wanch peꞌan wenchathiyana, kempana min ngul ween thant, pam wanch kon wal weenthan iiy-iiyin-a, an yaꞌ-ngul, puth kon minang ngul ngeey-ngeeyantan; pam wanch uthaminan-a, an man-yetham ngul iiy-iiyantan, ngay mulaman ekathang thanang, aꞌ putha ngayana wik min piip God.antam anangan waaꞌ-waaꞌang thant al-alantan, pam wanch wukal keꞌanangan-a, pam wanch kaangk-keꞌanangan-a, puth pam wanch ngangk way thampan iiy-iiyantanweya. ");
INSERT INTO wim_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Aꞌ niiy inan thamp waaꞌān nungant John.antana, ‘Than weeꞌ-weeꞌananganweya kan-kanamana ngaantam-ngeeyantan ngayang nil piip God.angan kuch ngayangan-a, putha keꞌan muukamantan-a, an thananiy-a, ngangk minangam anman iiy-iiyantan.’” ");
INSERT INTO wim_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Aꞌ than ngurp John.antam anangana koyam kan-ngul iiyin. Than aak anana kanan want-wantin-a, nil Jesus.an thaw thant pam wanch yotam al-alantan, John.an waaꞌ nunang, “Niiy ngul aak pintalakan iiy-iiyan John alantan-a, nil keꞌ pam want-wanttaka thathin nunanganiy e? Niiyan ngaantam-ngeeyan nil keꞌ wak wuth yimanangan wuntangan penyan thanang palam-puyaman ey? Yaꞌ ey! An nil pam thayan paththam iiy-iiyana! ");
INSERT INTO wim_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Niiy nath ngaantam-ngeeyana nil nath ngook min paththam ngoonch-ngoonch keꞌ pam maꞌmangkiyang yimanangan ey? — an yaꞌa, ngook min thak keꞌam ngooncha! Puth than pam wanch ngook min paththaman ngoonchantan-a, an thananiya aawuch minang aꞌ wuut piꞌanang wun-wuntana. Puth nil John.an yimanang yaꞌa. ");
INSERT INTO wim_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","10","Yaa, puth niiyan ngeenak iiyan e? thathan nunanganiy e? Niiyan ngaantam-ngeeyana thathin nunangana keꞌ pam prophet yimanangan ey? wik min God.antaman waaꞌ-waaꞌ ey? Eeꞌa, an nil kan-kanama pam prophet paththama, puth nilaniya pam wiy-wiyama, nil puth piip God.angan work piꞌan anan theeꞌ nungant. Nil piip God.ana wik inangan thaw lat ngench thayanangan, pam inman waaꞌ-waaꞌ nunang, John.an, ‘Ngay pam thonam ngul kuchāng wik thamp, umputh iiy-iiyow, pam wanchantan waaꞌ-waaꞌow pam thon alantaman puy-palan wampowa thanan yipam minam iiyayn, way thanttamana kan-ngul yipam wantayn.’ Wik God.antam yimanangan waaꞌ, lat ngench thayanangan. ");
INSERT INTO wim_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ngay niiyant wik inan kan-kanam waaꞌ-waaꞌang: pam John inmana an nil kan-kanam paththam pam wuut piꞌan iiy-iiyan, nil keꞌ pam wanch wiy yimanangan yaꞌa pam wanch nathpalman-a, in-inman keꞌam pam piꞌan iiy-iiyantan keꞌ nilan pam piꞌan iiy-iiyan. Puth than weeꞌ-weeꞌanangan maꞌ ngatharang anman iiy-iiyayn-a, aꞌ putha wik ngatharaman ngeey-ngeeyayn-a, nungkway than nath pam many iiy-iiyiythan-a, an nil piip God.angana puy-puyam ngul min-minam piꞌ-piꞌow thanang, aꞌ maꞌ-aath-aathow thanang, keꞌ John.an yimanangan yaꞌa, an chil-chil maꞌ-aath nunangana. ");
INSERT INTO wim_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Aak anpalmana nil John.angan wik min God.antaman waaꞌ-waaꞌ thant pam wanchantan-a, in-inmana than pam wanch yot anangan kaangk paththam maꞌ God.antangan iiyayn — an keꞌ aak yimanangan wunana, — than yot anangan nath-nathpalan yal-yalmathwuntan aawuch God.antamakan, thanan thaꞌ-thaꞌwuntan, than yipam pek aawuchangan ngoonch-ngoonchayn. ");
INSERT INTO wim_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Aak keenkanama nathpalmana nil Moses anan wun-a, nil wik thayan anan waaꞌ thant pam wanchantana, aak-aakanakaman nil John ngulan wun, pam prophets yot al-alangan wik waaꞌ-waaꞌin yimanangana aakan ngul wampowa nil piip God.angan pam wanch yot piꞌ-piꞌow thanang maꞌ nungantangan. ");
INSERT INTO wim_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","“Aꞌ putha thanan thamp waaꞌ-waaꞌin nil pam thonamana keꞌ Elijah yimanangan ngul wampowa. Thanana pam John anan waaꞌ-waaꞌin nunang. Niiyan putha wik inangana kan-kanam ngaantam-ngeeyān, ");
INSERT INTO wim_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","aꞌ konangam piꞌ-piꞌāna!” ");
INSERT INTO wim_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Nil puth Jesus.ana putham ngul thaw thant pam wanchantan, “Than ngul pam wanch inangan want-wanttak iiy-iiyantan e? Than keꞌ puk manyiya yimanangan keeꞌ-keeꞌantan aak yoon angana. ");
INSERT INTO wim_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Puk manyiy puungk wiyiya wik pechantan thant puk manyiy wiy al-alantan, ‘Ngan keeꞌ-keeꞌanan keꞌ maꞌ wanch thuma, aak path-pathan pulant, music keeꞌ-keeꞌathan, puth an yaꞌa, niiy puth nganttang keꞌ keeꞌin, yaꞌa. Aꞌ puth ngananiya pam keꞌ mul wun keeꞌ-keeꞌanan puth niiyana pal keꞌam iiyan ngant, aꞌ keꞌam peeyan nganttangan, yaꞌa.’ ");
INSERT INTO wim_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Puth inan aak yimanangan wunana. Nil pam John ngulan wamp-a, nil puth maꞌ-yotama mayan keꞌam mungk-mungk, aꞌ putha nil ngak wine.ana keꞌam mungk-mungka, yaꞌ anman, puth pam wanch yot anangan thawin, ‘Nilan weenthamana, nil yaakaꞌ oony way ngangkang piꞌ-piꞌana.’ ");
INSERT INTO wim_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Puth ngay ngulan wampang-a, pam inman nil God.angan kuch ngayanga, ngayaniya may min anangan mungk-mungkang putha may wine.ana mungkang. Puth than pam wanch yot anangan thawina, ‘Pam inana thathin a! Nilan may-weentha, may yot mungk-mungkana, putha wine thak yot mungk-mungkana. Puth nilaniya ngurp pam wanch way al-alantamana, than wukalana yal-yalmathantan pam piꞌan alantana aꞌ putha ngurp thanttamang than way yotan yump-yumpantana.’ Thanan yimanangan waaꞌ-waaꞌin ngayangana, puth ngul-ngulamaniya niiy thathāna nil piip God.ana kan-kanam paththam kuchek waap mina.” ");
INSERT INTO wim_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Nil Jesus.angana work piꞌ-piꞌanam yot anman yump-yump meeꞌ thanttang, pam wanchantang aak town thon-thonangan wun-wunin, Chorazin-a, Bethsaida-a, Capernaum-a, town wiy anangan thampana, puth thananiy wayana keꞌam wantin, than anman keꞌ-ngoongkam wayan yump-yumpin. Nil puth Jesus.angan-a, wak thanang, aꞌ thaw thant, ");
INSERT INTO wim_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Niiyalang, pam wanch aak Chorazin punchan aꞌ putha aak Bethsaida punchanan-a, niiy kan in ngeeyān ngayang a! Niiyan kaangk keꞌ ey? wik min God.antaman ngeey-ngeeyān ey? Aak wayan ngul wampow niiyanta. Pam wanch keenkan wun-wunin aak Tyre angan-a, aꞌ aak Sidon.angan-a, thanana way yump-yumpin. Puth thanan nath work wuut piꞌan yimanangan thath-thathiythan keꞌ niiyan thath-thathaniy-a, an thanan puth ngangk way-wayam wuniythan, way thanttaman ngaantam-ngeeyiythana aꞌ woyan way thanttamana wantiythan ngula. ");
INSERT INTO wim_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","“Ngay inan kan-kanam thawang niiyant: ngul-ngulana, nil piip God.angan pam wanch um nungantangan than-thanathow thanang-a, nilana pam wanch aak Tyre aꞌ Sidon punchanana way waaꞌ-waaꞌow thanang, aꞌ aak wayak ngul kuchow thanang. Puth God.angana pam wanch way-wayam paththam waaꞌow niiyang aꞌ kuchow niiyang ngul aak way aakanakan. ");
INSERT INTO wim_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Aꞌ niiy pam wanch aak Capernaum punchanana niiy kan in ngeeyān a! Ngul nil God.angan aak nungantamakan keny kalow niiyang ey? thaaꞌ-kuumpow niiyang ey? An yaꞌa, nil kuchow niiyang aak wayakana, puth niiy thampana kaangk keꞌ wik God.antaman ngeey-ngeeyāna, yaꞌa. Pam wanch keenkan wunin aak Sodom.angan-a, thanana way yump-yumpin. Puth thanan nath work wuut piꞌ-piꞌanaman yimanangan thath-thathiythanwey-a, keꞌ niiyan thath-thathaniy-a, yaa, an puth aak town thanttamana angman yippak wun-wuniya, puth yaꞌa, nil God.ang wayatha. ");
INSERT INTO wim_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ngay in kan-kanam thawang niiyant: ngul-ngulana, nil piip God.angana pam wanch um nungantang than-thanathow thanang-a, nil pam wanch aak Sodom punchanana umpow thanang, aꞌ pam wanch way waaꞌ-waaꞌow thanang, aꞌ aak wayak ngul kuchow thanang. Puth nilana way-wayam paththam waaꞌ-waaꞌow niiyanga, aꞌ kuchow niiyang ngul aak way aakanakan.” Nil Jesus.ana wik yimanangan thaw thant. ");
INSERT INTO wim_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Anpalan-a, nil Jesus.ana God.antan thaw, “Piip-ang, nintiya moom wuut piꞌan paththam aak nang kenyana aꞌ putha aak ing pekana. Ngay thankyou thawang nungkara nintan puth wik engkanang ngul yumpan thantana pam wanch al-alantan than kaꞌatham keꞌaman yippak thiichin nintangana. Puth pam wanch wiy al-alantan-a, nintaniya wik engkanang keꞌam yumpan thantweya thanan puth ngaantam-ngeeywuntana thanttakamana than keꞌ kuchek waap min yimanangan iiy-iiyantan, than keꞌ minaman ngaantam-ngeeyantan nintanganiya, puth yaꞌa. ");
INSERT INTO wim_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Yey, Piip-ang, puth nintan kaangk yimanangan iiy-iiyān pam wanchantan.” ");
INSERT INTO wim_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Aꞌ nil Jesus.an thaw ngul pam wanch al-alantan, “Piip ngatharam God.angan way min maꞌmangkam maꞌ ngatharang want-want thanang. Nil weeꞌang kan-kanam paththam thiichiy ngayang puk nhengk God.antamaniy e? An nilam thonamang anman piip God.angana thiich ngayanga. An puth weeꞌangam kan-kanam thiichiy nunang piip God.ana? puth ngay nhengk nungantam ilangaman ep-paththam thiichang nunang, aꞌ puth pam wanch anangan thana, than ep thiichantan nunangan, ngayaman uwang thanang, wikan waaꞌ-waaꞌang thantana. ");
INSERT INTO wim_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Niiy wiyaniya, kemp way paththam iiyaniy, anhan iiy-iiyaniy, keꞌ yuk anhan pikpungkang yimanangan kathin niiyantang, nath ngangk way paththam iiy-iiyaniy. Niiy pal iiyān ngatha, ngay yipam yuk anhanan maayāng niiyantamana, ngay niiyang yipam ey-a, ngangk min yumpāng niiyanga. ");
INSERT INTO wim_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ngay puth ngangk minangam iiy-iiyang niiyant, keꞌ meek keꞌam iiy-iiyang niiyant, yaꞌa — yaa, puth niiyana wik ngatharaman min-min ngeeyāna aꞌ kuchekangam piꞌ-piꞌāna, anpalana ngay ngangk min ngul yumpāng niiyang. ");
INSERT INTO wim_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Puth niiya ngayangwey wik ngeeyinan-a, ngay min anman iiy-iiyāng niiyanta, putha ngangk thayanathāng niiyang thampa.” ");
INSERT INTO wim_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Anpalaniy-a, yaam keꞌanaman-a, Jesus.an-a, puth ngurp nungantam anangana than woyan wakin, aak may wheatan kaampina. Aak ananiy wuna Saturdaya, aak ngench thayan thant Jews.antama. Aak thanttam yimanangan wuna, than aak Saturday.ana, work keꞌam iiy-iiyin, yaꞌa. Ngurp nungantam Jesus.antam anangan-a, meech iiy-iiyin, than may wheat thuthin mungkaynweya. ");
INSERT INTO wim_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Than pam Pharisees al-alangan thathin thanang aꞌ thanan thawin nungant Jesus.antan, “Ayyang, than pam nal-nalangan may wheatan ngeenak thuth-thuthantan e? Aak in Saturdaya! Aak ngampara wunana ana ngench thayan a! Than wik ngench thayanan pip-pipantan ey?” ");
INSERT INTO wim_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Nil Jesus.ana thaw thant, “Niiy ngul wik inan keꞌam ngeeyan ey? Nil David aꞌ pam nungantam anangan meechan wun-wunin ey? ");
INSERT INTO wim_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Nil David.ana aawuch ngench thayanak iiy, aawuch God.antamak, aꞌ angan ngoonch aꞌ may bread ngench thayanan maay, thanana mungkin ngul. In wik thayan ngamparamana yimanangan wunan thanam thonakama priests al-alangan may bread ngench thayanan mungkayna. Puth nungkway than wik ngench thayanan pipin-a, an than David weeꞌanang al-alangan ep-paththam mungkinweya. ");
INSERT INTO wim_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ngul niiy lat ngenchangan keꞌam thathan ey? Moses.angan ump ey? Saturday thon-thonanganiy-a, than priests al-alangan wik thayanan pip-pipin, than puth aawuch ngench thayanangan work iiy-iiyin. Puth nil piip God keꞌ thaw than wayan iiy-iiyina, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Than workan iiy-iiyin aak ngench thayan angan-a, an work piꞌan paththam iiy-iiyin, puth ngayaniya wuut piꞌan paththama, aawuch ngench thayaniya chil-chila. ");
INSERT INTO wim_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Than wik God.antam inangan umpin lat ngench thayanangan, ‘Ngay keꞌ kaangk minhan mulathantan thumang ngulan kiingkantan ngathar, an yaꞌa, ngay inan ep-paththam kaangk: niiy ngangk minangam iiy-iiyān niiyantakaman.’ Niiy kan-kanam wik inangan ngaantam-ngeeyin-a, niiyiya pam wanch maꞌmalam anangan keꞌ waaꞌān thanang than way keꞌaman yumpin. ");
INSERT INTO wim_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Puth ngayana, pam inmana nil God.angan kuch ngayang niiyantana, ngayam thonakam ep thawanga than pam wanch want-wanttakan iiyayn aak Saturday.ana, puth ngay inana moom piꞌan niiyantama, Saturday.akan thampa.” ");
INSERT INTO wim_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Anpalaniy-a, nil Jesus.angan aak anan want ngul, aꞌ aak church Jews.antamakan iiy. ");
INSERT INTO wim_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Aak angana nil pam inan maꞌ makaran yaꞌ yalam nungant, nilan angman nyiin-nyiin. Than pam wanch wiy anangan angman thamp, thanan kaangk wik aak-yaꞌangan waaꞌ-waaꞌayn nunang wiyantan, than puth engkin nungant, “Ayyang, kan in ngeeyāna, nil wik thayan ngamparaman wanttak thawan e? An ngul min ey? Ngamp pam wanch miyalathāmp thanang aak Saturday.angan ey?” ");
INSERT INTO wim_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Nil Jesus.an thaw thant, “Pam thonamangweya sheepwey piꞌiy-a, minh sheepana keekiy ngul pek awarangana, aak ngenchangana, Saturday.angana. Ngul niiy wanttak yumpin e? An niiy iiyina, aꞌ wichin nunangweya awar anpalana. ");
INSERT INTO wim_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Pam wanchwey kaangkiy iiyanamp meeꞌ God.antangana, minh sheepana yaꞌa! An kana mina pam wanch maꞌ-aathāmp thanang aak Saturday.angana, puth wik lat ngench thayanangana waaꞌan ngampar.” ");
INSERT INTO wim_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Anpalana, nil Jesus.an pam alantan thaw maꞌ makaran yalam nunganta, “Ayyang, nint maꞌan ongkarathāna!” Nil puth pam alangana maꞌan ongkarath, aꞌ maꞌan min ngul wun nungantweya keꞌ maꞌ thonangan anana. ");
INSERT INTO wim_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Anpalana than Pharisees al-alangan churchan wantin aꞌ thanan wik yumpin thanttakaman Jesus.an yipam mulathayn nunang. ");
INSERT INTO wim_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Nil Jesus.angan wik ngeey thanttam thanan wik yumpin thanttakamana than mulathayn nunang, aꞌ anpalana nil aak anan want ngul. Pam wanch thaaꞌ-wantanam al-alangan monkan-wak-wakin nunang. Nil miyalath thanang pam wanch anangan weech-weechan thananga, ");
INSERT INTO wim_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","aꞌ thaaꞌ-thayanam thaw thant keꞌ waaꞌayn nunang wiy al-alantana. ");
INSERT INTO wim_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Nil yimanangan thaw thant nil yipam meenathow ngampar wik Isaiah.antamana an kan-kanam waaꞌ-waaꞌ ngampara, wik inangana aak keenkan ump lat ngench thayanangan, ");
INSERT INTO wim_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Pam inman thonam workan iiy-iiyan ngathar, ngayan miꞌangana. Ngay kaangk paththam wunang nungant, ngangk min paththam wunang nungantamana. Ngay Ngeen-Wiy Min ngatharam kuchāng ngangk nungantangan wunowa. Aꞌ nilana waaꞌow thant ngay kaangk pam wanch kaaꞌ-piichanathāng thanang aak umyompanamana. ");
INSERT INTO wim_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Nil kul keꞌ thawow pam wanchantana, puth-a, wik keꞌ pechow thanta. Nil wik othamayanan woyan wakanana keꞌ thaw-thawow, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Nil minam iiyow thant pam wanch michan iiy-iiyantan, than keꞌaman aak thaamp-thaampantan, nil keꞌ wayathow thanang, yaꞌa. Pam wanch yotangan thathayn nunang nil min-minam paththamana. Nil min anman iiy-iiyow aak-aakanakamana pam wanchangan wik thayan God.antam anangan ngeey-ngeeyaynana. ");
INSERT INTO wim_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Aꞌ pam wanch yot al-alangan aak umyompanamana ngaantam-ngeey-ngeeyayn nunang.” ");
INSERT INTO wim_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Anpalana, pam wanch wiyangan pam meeꞌ koꞌanch wampathin nunang Jesus.antana. Nil pam koꞌanch inana, wik keꞌam thaw-thawa, nil puth oony way ngangkangan piꞌ-piꞌ, oony alangan wik keꞌanang yump nunang. Aꞌ nil Jesus.angan-a, miyalath nunang aꞌ nil paman-a, wik paththam ngul thawa aꞌ meeꞌan ik-a, aak ngul thathweya. ");
INSERT INTO wim_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Than pam wanch yot thaaꞌ-wantanaman-a, meeꞌam ikin nil puth Jesus.angan pamana minam yump nunang. Than puth thawin thanttakaman, “Nil inan nath kampan David.antaman ey? nil God.angan kaaꞌngak ey? kuchowan ey?” ");
INSERT INTO wim_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Than pam Pharisees al-alangan wik anangan ngeeyin thanttaman-a, thanan thawin thantana, “Nil oony way anangan kenthan thanang pam wanch al-alantamana nil puth oony way moom piꞌan alangan, Beelzebul alangan-a, maꞌ-kunch yump-yumpan nunang nil yipam oony wayan kenthow thanang pam wanch al-alantamana.” ");
INSERT INTO wim_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Nil puth Jesus.angan kanam thiich thanang than want-wanttakan ngaantam-ngeeyin nunangana aꞌ nilan thaw thant, “Than kampanam nathwey pek-pekwiythan-a, aꞌ thaamp-thaampwiythan thanttakamwey-a, yaa, thanan aak wayathiythan, minam keꞌ piꞌwiythan thanttakamanwey, yaꞌa, aak thanttamana thayanam keꞌ piꞌiythan, yaꞌa. Than pam wanch aak town thonamangan nath thaamp-thaampwiythan thanttakamanwey-a, an than thampang aak town thanttaman minam keꞌ piꞌiythan, an yaꞌa. ");
INSERT INTO wim_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Nil oony way alangan nathwey oony way wiy anangan piik-piikiy thanang-a, pek-pekwiythan thanttakaman-a, thanan thampang aak thanttaman wayathiythan, thanan puth-a, thaampwuntan ngula, than aak thayanaman keꞌ piꞌiythan, yaꞌa, karangk keꞌ-ngul iiyayn, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Niiyan ngayangan waaꞌaniy keꞌ nil Beelzebul alangan maꞌ-kunch yumpan ngayang yipam oony way anangan kenth-kenthāng thanang pam wanchantamana, an yaꞌa. Puth nil weeꞌanga ngurp niiyantam anangan maꞌ-kunch yumpan thanang oony way anangan yipam kenthayn pam wanchantaman e? Nil oony way piꞌan alangan ey? An yaꞌa, puth than ngurp niiyantam thawayn ngul nil oony way alangan yaꞌa keꞌ maꞌ-kunch yumpan thanang, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Puth ngay inan thawang niiyant: nil Ngeen-Wiy Min God.antam alangan ngayang ep-paththam maꞌ-kunch yumpan ngayang ngay yipam oony way anangan kenth-kenthāng thanang pam wanchantamana. Yaa, puth amanamana, niiy meeꞌmiy ngul aakan kan wamp nungant God.antan meenathow nungamang nil moom piꞌan paththaman. ");
INSERT INTO wim_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Aꞌ puth niiy in thampan ngeeyāna: nath weeꞌangweya aawuchang pek wupam ngoonchiy aawuch pam karangk alantamangan-a, aꞌ maꞌ-kuchathiy way min min-miniy nungantaman-a, yaa, puth nil kaꞌathaman-a, pam karangkana kuuyang kathow nunang, aꞌ nilana kan-ngul ngoonchow aawuch nungantamangana. Nil keꞌwey kuuyangan kathiy nunangan-a, yaa, nil puth pam karangkan kul thawiy nungant aawuchangan keꞌ ngoonchow.” ");
INSERT INTO wim_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Anpalana, nil Jesus.an thaw thant, “Than pam wanch weeꞌ-weeꞌanangan keꞌan iiyiythan ngatharangan-a, an than thaampantan ngayang, kaangk keꞌ ngatharam. Aꞌ than weeꞌ-weeꞌanangan keꞌan maꞌ-aathiythan ngayang pam wanch wiy anangan yipam wampayn nungant piip God.antan-a, an than keꞌ puy-puyam yaark-yaarkathantan thanang piip God.antamana. ");
INSERT INTO wim_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Yaa, ngay puth keꞌ-paal waaꞌang niiyant: way ngeen nathan pam wanchangan yumpiythan-a, thawiythan thakan-a, nil God.an ngul nathwey kon-ngathow nunang, keꞌ-ngulan ngaantam-ngeeyow. Than puth weeꞌ-weeꞌananganweya wik way thakan waaꞌ-waaꞌiythan nunang Ngeen-Wiy Min God.antaman-a, nil piip God.ana keꞌ kon-ngathow nunang than wayan waaꞌ-waaꞌin nunanganiya, an keꞌ kon-ngathiy nunang, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Than wiy al-alangana nath wik way thakan waaꞌiythan ngayangan-a, ngay pam inman nil God.angan kuch ngayang-a, an ep nil nath piip God.angana keꞌ-ngul ngaantam-ngeeyow wik thanan waaꞌ-waaꞌin ngayangana. Than puth weeꞌ-weeꞌanangweya wik way thakan waaꞌ-waaꞌiythan nunanga Ngeen-Wiy Min God.antaman-a, nil puth God.aniya keꞌ kon-ngathiy nunang thanan way waaꞌ-waaꞌin, yaꞌa, anman konangam piꞌ-piꞌow aak umpuyam. ");
INSERT INTO wim_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Niiy may menchan yukangwey thathin-a, yaa, niiyaniya puth meeꞌmiy yukan nath mina, nath yaꞌa. May min-miniyan thathanamp-a, aniya yuk minang kalan. May way anangan thathanamp thanang-a, an yuk wayang kalan. ");
INSERT INTO wim_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Puth niiyaniya way-wayam paththam iiy-iiyaniy keꞌ thuuk yimanangana! Niiy puth wik min ananganiy wanttak thawina, yaꞌa! Ngamp wik ngeen nathan piꞌ-piꞌanamp ngangkanganiy-a, wik ananganiya thaaꞌaman ngul pentow ngampar. ");
INSERT INTO wim_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Pam minan iiy-iiyan-a, nilaniy wik min ngangkangan piꞌ-piꞌan, puth nilaniya wik minan thaw-thawan putha min yump-yumpan. Pam wayan iiy-iiyan-a, nilaniya wik way ngangkangan piꞌ-piꞌan, puth nilaniya wik way thak thaw-thawan, putha way yump-yumpan thampa. ");
INSERT INTO wim_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Ngay inan wik kan-kanam waaꞌ-waaꞌang niiyanta: aak an-aniyangan nil God.angan umangan than-thanathow ngampangan-a, nil mep-mepow ngampang yotaman — anpalmana ngamp wik ulpanangan thaw-thawampa putha wik way thakan thaw-thawamp. ");
INSERT INTO wim_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Puth wik ngamparam anangan thaw-thawanamp-a, an meenathana ngangk yam pekan ngampar want-wanttakan wunan — min natha, nath yaꞌa, way-wayama. Aꞌ puth amanamaniya nil piip God.angana yaarkathow ngampang ngul, puungk wiy ananganiya nil kalow aak nungantamakana, angan wun-wunayn nungantang aak umpuyama, puth puungk wiy ananganiy-a, kuchow thanang.” ");
INSERT INTO wim_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Anpalana, than pam piꞌan anangan wik thayanan thaaꞌ-aath-aathinan-a, aꞌ putha pam piꞌan Pharisees wiy anangan thawin nungant Jesus alantan, “Ayyang, moom-ang, nint work piꞌan meenathān nganta!” ");
INSERT INTO wim_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Nil Jesus.an thaw thant, “Niiy inangan wunaniy-a, way-wayam paththam iiy-iiyaniya, niiy God.an keꞌ ngaantam-ngeey-ngeeyaniy nunangana! Niiy kaangk ngay work piꞌan anman meen-meenathāng niiyantan ey? Niiy work piꞌan thonam thonakam ngul thathāna. Niiy ngul thathāna ngay keꞌ pam Jonah anman. ");
INSERT INTO wim_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Niiy kan ngaantam-ngeeyaniy Jonah.an minh ngaꞌ wuut piꞌanangan lokang thuꞌ nunang, thipang ngulan piꞌ-piꞌ nunanganiya, kinch maꞌ-koꞌalama aꞌ puth-a, aak ngutanganiya maꞌ-koꞌalam thamp piꞌ-piꞌan, minh ngaꞌ alangan. Ngayangiy-a, pam inman nil God.angan kuch ngayang. Ngayan keꞌ yimanangan kinch maꞌ-koꞌalam wunāng aak pek-pekangkana aꞌ aak ngutanganiy-a, yimanang maꞌ-koꞌalam wunānga. ");
INSERT INTO wim_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Aꞌ than pam wanch anangan aak Ninevah.angan wun-wunina, than way waaꞌ-waaꞌayn niiyang, aak an-aniyangan nil God.angan um nungantangan than-thanathow ngampang, puth aak keenkanamana than wik min God.antaman ngeeyin nil pam Jonah alangan waaꞌ-waaꞌ thant aꞌ thanana woyan wayan keꞌ-ngul wakin, yaꞌa. Nil Jonah.angan wik min waaꞌ-waaꞌ thant, puth niiy inangana ep-paththam wik ngatharaman ngeey-ngeeyāna, wik min paththama anangan, puth niiy yaam anman wayan yump-yumpaniy aꞌ keꞌam yippak wayan wantana, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Aꞌ niiy wik kath Queen aak Sheba punchan alantaman kan ngeeyan ey? Yaa, nil Queen inana aak kechak moꞌ aak King Solomon.antamaka, nil yipam wik ngeeyow nunang, puth nil pam piꞌan Solomon.ana kuchek waap min-minam paththam iiy-iiya. Wik nungantaman mina, puth wik inangan ngayan thaw-thawang niiyantana an ep-paththam min-minam paththama. Ngul-ngulaniya, nil piip God.angan umang than-thanathow niiyangan-a, nil Queen aak Sheba punchanana ekow aꞌ way waaꞌow niiyang, puth niiyan wik min-minam ngangkangan keꞌam piꞌ-piꞌaniy, yaꞌa.” ");
INSERT INTO wim_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Aꞌ nil Jesus.angan putham ngul wik kath waaꞌ thant, “Nil oony way alangan paman wantan ngulan-a, an nilaniya aak pal-puy aak way wakan iiy-iiyan, aak min yaꞌa, nilaniy puth aakak wenk-wenkan nil wanttingan wunow. Nil oony way alangan aak keꞌan uwiy nungantakaman-a, ");
INSERT INTO wim_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","nil puth nungantakaman thawiya, ‘Ngay kan koyam iiyāng aak ngatharamaka pam alantangan ngangkang koyam ngoonchāng.’ Nil oony way koyam ngulan wamp nungant-a, nil aak yaꞌ-yaꞌam thathana, nil puth pam alangan Ngeen-Wiy Min God.antaman thaampan nunang yippak, ngangkangan keꞌam yippak ngoonchant. ");
INSERT INTO wim_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Anpalana, nil oony wayan koyam ngul iiyan aꞌ oony seven way-wayam paththaman umpan thanang, aꞌ wampathan thanang yipam wunayn nungantangan thampa. Than oony way yotam ngangkang ngulan ngoonchantan nungantangan-a, nil paman way-wayam paththam ngul iiy-iiyana, keꞌ nil keenkan iiy-iiy, an yaꞌa. Yaa, ngay inan thawang niiyant: pam wanch anangan way-wayaman iiy-iiyantan-a, than thampang way-wayam paththam ngul weemayn keꞌ pam anman ngay nyiingkan waaꞌ-waaꞌang niiyanta.” ");
INSERT INTO wim_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Nil Jesus.ana wikan yippakan thaw-thaw thant pam wanchantan-a, kaath nungantama putha kuunch nungantam anangan wampin aꞌ yoon angman than-thanin aꞌ thawin thanan kaangk wik thawayn nungant Jesus.antan. ");
INSERT INTO wim_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Yaa, nil puth pam thonam anan thaw Jesus.antan, “Ayyang, kaath nungkarama putha kuunch nungkaram nan yoon than-thantan nungkara, than kaangk wik thawayn nungkara.” ");
INSERT INTO wim_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Aꞌ nil puth Jesus.an thaw thant, “Kaath ngatharaman puy weeꞌ e? Puth kuunch ngatharam thamp puy weeꞌ e?” ");
INSERT INTO wim_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Aꞌ nil malang waaꞌ thanang ngurp nungantam anangaman aꞌ thaw ngul, “Ayyang, in ngeeyiy a! aꞌ thathān thampa! Than inangana keꞌ kaath ngatharama putha than keꞌ kuunch ngatharam thampa! ");
INSERT INTO wim_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Nil weeꞌ-weeꞌananganwey natha piip ngatharam in kenyana wik ngeey-ngeeyiythan nunangan-a, an than keꞌ kampan ngatharam yimanangana, kaath-a, kuunch ngatharam yimanangan iiy-iiyantana.” ");
INSERT INTO wim_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Kinch thonamang anman-a, nil Jesus.ang aawuchan want ngul aꞌ kookam piꞌan aakanakan iiy. Nil aakang nyiin ngul yipam pam wanch thaaꞌ-aath-aathow thanang. ");
INSERT INTO wim_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Pam wanch thaaꞌ-wantanaman yalmathwin nungant, wuth-wuthanathin nunang. Nil Jesus.angan-a, chukkun thath, ngak wonkang angman than-than aꞌ nilan aakanakan iiy, aꞌ chukkunangana chang pey, aꞌ ang-ngulan nyiin. Than pam wanch yot anangan-a, thomp wonkang angman than-thanin, aꞌ ngeey-ngeeyin nunang. ");
INSERT INTO wim_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Nil wik kath waaꞌ-waaꞌ thant, nil koochanam keꞌam waaꞌ-waaꞌ thanta, yaꞌa, keꞌ wik kath yimanaman waaꞌ-waaꞌ thant. Nil wik inan waaꞌ thant, “Niiy kan yotamang in ngeeyāna! Nil pam thonam iiy-iiy aꞌ may kaanch manyiy aakangan theeꞌ-theeꞌ thanang pal-puya yipam may anangan emayna. ");
INSERT INTO wim_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Nil may kaanch anangana maꞌang theeꞌ-theeꞌ thanangan-a, wiy anangan-a, woyanang angan keek-keekin. Anpalan-a, minh panch anangana aakang ukin ngul aꞌ mungk-mungkin thanang. ");
INSERT INTO wim_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Puth may kaanch wiy ananganiy-a, aak kunttowthiyang angan keekin, aak ngaanhan manya. Yiikan may kaanch anpalana, erkam pentin, puth aak ngaanhan chil many kenyangkaniya. ");
INSERT INTO wim_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Kinch keny ngulan wun-a, pung karkanang wuk-wuk thanang aꞌ than erkam uthamina, ngeenam putha, yuk thinkan pek kech keꞌam kucha, yaꞌa, aak ngaanhan chil manya, puth-a, aak pekangkaniya kunttowthiya. ");
INSERT INTO wim_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","May kaanch wiy ananganiy-a, aak waakamthiy angan keekin, yiikan anangana aꞌ putha wak wayananganiya than karpam pentin, emin ngul. Kaꞌathamaniy-a, yuk minam emin, amanamaniya, wak way al-alangan mulathin thanang may min anangana. ");
INSERT INTO wim_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Puth may kaanch wiy ananganiy-a, aak ngaanh minang keekin. Than ep minam em-emin, aꞌ ngul-ngulan-a, may yot kalin thanang. Wiyang may kootra chil yot kalina, thirty, wiyangan-a, sixty kalina, wiyangana, may yot kal-kalin thanang, one hundred, thaaꞌ-wantanama. Anman kan.” ");
INSERT INTO wim_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Aꞌ nil Jesus.an thaw thant ngul, “Niiy wik ngatharam kanam ngeeyan ey? Yaa, niiyiya konangam piꞌ-piꞌān thanang.” ");
INSERT INTO wim_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Anpalan-a, than ngurp nungantam anangan wampin nungant Jesus.antan, aꞌ thawin nungant, “Ayyang, nint ngeenam wik kath wuthanang anman waaꞌ-waaꞌangan thant pam wanchantaniya?” ");
INSERT INTO wim_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Nil Jesus.an thaw thant, “Nil God.anganiy-a, kaangk wik nungantaman engkanang wunow niiyant, niiyan yipam meeꞌmiy iiyāna wik ngench nungantam anangana, wik inanganiya: nil pam wanch yot anangan ngul piꞌ-piꞌow ngampang maꞌ nungantanga. Puth ngay pam wanch wiyantan wik engkanang keꞌam thant waaꞌ-waaꞌanga. ");
INSERT INTO wim_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Yaa, niiy inan ngeeyāna: than weeꞌ-weeꞌanangan wik min-minan ngeeyayn ngayang-a, yaa, ngayan ngul maꞌ-aath-aathāng thanang than yipam minam anman ngaantam-ngeeyayn, aꞌ yot-yotam thiichayn. Aꞌ puth thon iniya, than weeꞌ-weeꞌanangan ngaantam-ngeeyiythan thanttakaman thanan keꞌ wik kanam thiichin-a, puth than keꞌaman wik ngeeyiythan ngayang-a, yaa, ngayan puth keꞌ maꞌ-aathing thanang, aꞌ wik anangan-a, kon-ngathow thanang ngula. ");
INSERT INTO wim_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Puth ngay pam wanch wiyantan wik engkanang keꞌam waaꞌang, ngay wik kath wuthanang anman waaꞌ-waaꞌang thanta, yipam thanan thath-thathayn ngayang, aꞌ puth ngeey-ngeeyayn ngayang thonakama, puth yaꞌangam, wik kathaniy-a, wik wuthanang wunow thant, wik God.antaman keꞌ yipam thiichayn, yaꞌ anmana. ");
INSERT INTO wim_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Nil Isaiah.angan thanang waaꞌ-waaꞌa keenkanamana nil puth wik inangan ump lat ngench thayanangana: ‘Pam wanch il-ilangan wikan ngeey-ngeeyayna, puth yaꞌangam, wikaniy-a, wuthanang wun-wunow thant; thananiya thath-thathayn ngayanganiya, puth yaꞌangama, puth than keꞌ thathiythan ngayang, yaꞌ anman, ");
INSERT INTO wim_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","than puth kuchek way thinhan anman iiy-iiyantana, than kon maꞌang ngathwuntana keꞌ yipam wikan ngeeyayn, aꞌ than meeꞌ maꞌang ngathwuntan than keꞌ yipam aak thathayna. Than nath meeꞌan ikiythan-a, an ep-paththam thathiythana. Than kon makan pachathwaynan-a, an epa wik ngeeyiythana aꞌ thiichiythan ngula aꞌ minam ngaantam-ngeeyiythan ngul. Than woyan way anpalan nath weentiythana, aꞌ ngathar ngul wampiythana, aꞌ ngay minam paththam ngul yumpāng thananga.’” ");
INSERT INTO wim_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","17","Aꞌ nil Jesus.an wik inangan ngul thaw thant, “Aak keenkanama, pam prophets yota putha pam wanch God.antam anangan yota thanan kaangk paththam thathayna keꞌ niiy il-ilangan wanttakan thath-thathaniya aꞌ putha thanan kaangk wik ngeeyayn thampanga keꞌ niiy il-ilangan wik wanttakan ngeey-ngeeyaniya, puth yaꞌa, an than keꞌam thathina, puth-a, wik keꞌam ngeey-ngeeyina, yaꞌ anman. Niiyan puth kanam thathana, aꞌ wik kanam ngeeyana, niiyana nanpalan ngangk minangam iiy-iiyaniya.” ");
INSERT INTO wim_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Anpalan-a, nil Jesus.an thaw thant, “Yaa, niiy kan in ngeeyāna! Ngay wik kath inan may kaanch alantaman kan koochanathāng niiyantweya. ");
INSERT INTO wim_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Than pam wanch wiy al-alangan kanaman wik God.antaman ngeeyantan nil pam wanch yot anangan ngul piꞌ-piꞌow ngampang maꞌ nungantang. Puth than wikan min-min keꞌam ngaantam-ngeeyantan. Pam wanch anangan-a, keꞌ may kaanch yimanangan woyanangan keek-keekin. Thananiy-a, oony wayan erkam ngeeyantan nunang, kaangk keꞌ-ngul God.an monkan-wakayn nunang. ");
INSERT INTO wim_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Than pam wanch wiy ananganiy-a, keꞌ may kaanch anangan aak kunttowthiyangan keekinwey. Than il-ilangana wik God.antaman ep ngeeyantana aꞌ ngangk min paththam ngul wun thant. ");
INSERT INTO wim_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Than wiy al-alangan keꞌ-paal way yumpantan thant, aꞌ thaaꞌ-thengkathantan thanang than puth wik God.antaman ngangkangam piꞌ-piꞌantan. Aꞌ thananiy-a, woyan God.antamana erkam ngul wantantan, wik nungantaman kon-ngathan thanang ngula, puth kaꞌathamana thananiy-a, ngangk pal-pekkuwaman thanttamana min-minana keꞌam yippak theeꞌin nungant yaꞌa. ");
INSERT INTO wim_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Pam wanch wiy ananganiy-a, keꞌ may kaanch anangan aak waakamthiy angan keek-keekina. Than il-ilangana wik God.antaman kan ngeeyantan. Puth amanamaniya, than ngaantam-ngeeyantan thanttakaman, than want-wanttakan maꞌmangkiy iiyiythan aꞌ puth want-wanttakan may thakan piiy-piiyayna aꞌ kuchek way wunan thant, puth woyan God.antaman kon-ngathan thanang ngula, anpalan-a, than wayamantana, min keꞌ-ngul yump-yumpantan, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Puth pam wanch wiy ananganiy-a, keꞌ may kaanch anangan aak ngaanh minangan keek-keekina. Than il-ilangan-a, wik God.antaman minam paththam ngeey-ngeeyantan aꞌ ngangkang piꞌ-piꞌantan. Than woyan God.antaman wak-wakantan, aꞌ min yump-yumpantan. Wiyanganiy-a, chil min yump-yumpantan, wiyanganiy-a, min paththam yump-yumpantan, keꞌ may kaanch anangan aak minangan keekin yimanangana, wiyang may kootra chil yot kalin, thirty, wiyangan-a, yot-yotam kalin, sixty, aꞌ puth wiyangan-a, thaaꞌ-wantanam kal-kalin thananga, one hundred!” ");
INSERT INTO wim_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Aꞌ anpalana nil Jesus.angana wik kath thonangan ngul waaꞌ pam wanchantan, “Aakan kan-kanang wampana nil God.angan pam wanch yotam maꞌ nungantangan piꞌ-piꞌowa. Inan wik kath yimanangana. Nil pam thonamangan-a, may kaanch min anangan theeꞌ-theeꞌ garden nungantamang angana. ");
INSERT INTO wim_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Aꞌ amanamaniy-a, aak ngutang ngulan-a, than yotaman weep kan-ngulan wunin-a, nil pam thon anan wampa, ngangk kulangaman kal-kal nunang, pam moomana, aꞌ angan ngoonch aak garden nungantamangana aꞌ kaanch wak way al-alantamana angman theeꞌ-theeꞌ may kaanch min al-alantangan thintha. Amanamaniya nil kan-ngul iiy. ");
INSERT INTO wim_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ngul-ngulana may kaanch min anangana kan-ngul yiikan pent-pentin, aꞌ kan-ngulan emin mayan piꞌayn-a, puth wak wayanang anangana karpam anman pent-pentin, piꞌan ngul em-emina. ");
INSERT INTO wim_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Amanamaniya than pam workan iiy-iiyin nungantan-a, iiyin nungant moom alantan, aꞌ thawin nungant, ‘Ayyang, moom-ang, nint puth may kaanch min-miniy theeꞌan thanang ey! aak garden nungkaram angan ey! Nil ngul wak wayanang anangan wanttinpal wampin e?’ ");
INSERT INTO wim_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Aꞌ pam mooman thaw thant, ‘Pam alangan nath theeꞌa, ngayangan ngangk kulangaman kal-kalan a!’ Thanan puth thawin nungant, ‘Nint kaangk ngana wak way anangan thuthān ey?’ ");
INSERT INTO wim_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Aꞌ nil mooman thaw thant, ‘Yaꞌa, niiy wak way anangan keꞌ thuthān thananga, niiy puth may thamp anangan ngul thuth-thuthan thananga. ");
INSERT INTO wim_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Than mak karpam em-emayna, puth-a, may thampan mak polpeyayna. Aak anan wampow-a, may an-aniyangan thuthān-a, ngayan ngul thawāng thant wak wayanang anangana thuthayn thanang, aꞌ ompam kathayn thananga kuuyang aꞌ thumang kiingkayn ngul. Anpalaniya than may wheat min anangana thuthayn aꞌ kalayn thanang aak store ngatharamakana.’” ");
INSERT INTO wim_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Aꞌ nil Jesus.angan wik kath thon ngul waaꞌ thant, “Aak yimanangan ngulan wunow nil Piip God.angana pam wanch yotaman maꞌ nungantangan piꞌ-piꞌowa. In ngeeyiy a! Nil pam thonamang may kaanch thonam many pattakam kala, aꞌ aak garden nungantamang angan theeꞌa. ");
INSERT INTO wim_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","An kaanch many pattakama, puth amanamaniya puy-puyam ngul em-em piꞌan ngula, anman em-em yuk piꞌanakama, yuk piꞌan ongk ngul thana, aꞌ minh panch nathpalan moꞌ-moꞌin, yuk aakanakana, aꞌ wurp ngul yumpin thanttakamanweya yuk punthang angana.” ");
INSERT INTO wim_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Aꞌ nil Jesus.angan wik kath thon ngul waaꞌ thant, “Aakan kan-kanang wampana nil God.angan pam wanch yotam maꞌ nungantangan piꞌ-piꞌowa. Inan wik kath yimanangana. Nil wanchangana yeast manyam yeecha may flourangana aꞌ mayana piꞌan ngul ulpan.” ");
INSERT INTO wim_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Nil Jesus.angana wik kath yot yimanangan waaꞌ-waaꞌ thant, yipam engkanathow thant, aak God.antamaniya wanttakan wunowa. Aakana yimanangan nil Jesus.angan thaaꞌ-aath-aath pam wanch anangana, wik engkanangana keꞌim waaꞌ thant, yaꞌa, keꞌ wik kath anman waaꞌ-waaꞌ thant. ");
INSERT INTO wim_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","An nil meenath ngampar wik nil prophetangan keenkanam waaꞌ-waaꞌ ngampara, lat ngench thayanangana, an kan-kanam waaꞌ, wik inangan: “Ngay wikan waaꞌang pam wanchantan-a, engkanang keꞌim waaꞌāng thant, ngay keꞌ wik kath anman waaꞌ-waaꞌāng thant. Ngay wik waaꞌāng thanta pam wanchant nil piip God.angan wik maꞌ mupaman piꞌ-piꞌ aak nathpalman aak inan keꞌam yippakan wuna.” ");
INSERT INTO wim_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Nil Jesus.angan kanan want thanang pam wanch yot anangan-a, nil aawuchang pek ngul ngooncha, aꞌ ngurp nungantam anangana wampin nungant aꞌ thawin nungant, “Wik kath nintan waaꞌ-waaꞌan ngant-a, nint min-min engk-engkanang ngul waaꞌān ngantweya wik anangana want-wanttakan wunana, wak wayanangan aak gardenangan em-emina.” ");
INSERT INTO wim_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Nil puth Jesus.an thaw thanta, “Wik kath inana yimanangan wunana: pam thonam alangana gardenangan may kaanch min anangan theeꞌ-theeꞌ-a, an keꞌ ngaya, pam ngay inman nil God.angan kuch ngayangana. ");
INSERT INTO wim_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Garden nungantamaniy-a, an keꞌ aak inman eartha; nil may kaanch min ananganiy-a, an keꞌ pam wanch maꞌ piip God.antangan iiy-iiyantan; nil wak wayanang ananganiya an keꞌ pam wanch anangan maꞌ oony way alantangan iiy-iiyantan. ");
INSERT INTO wim_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Nil pam anana pam mooman ngangk-wayangaman kal-kalan-a, aꞌ puth wak wayanang anangana theeꞌ-theeꞌan thanang-a, pam nilaniya keꞌ oony way piꞌan anman. Than may menchanan yalmathin-a, an keꞌ aak inan kan-ngulan minchowa. Pam workan iiy-iiyin-a, may menchan anangan yalmathinan-a, an keꞌ than ngaantiyongk God.antam anangana. ");
INSERT INTO wim_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Than wak wayanang anangan-a, yalmathin, aꞌ thumang ngul kiingkin thananga. An keꞌ yimanangan wunow aak inan minchowana, ");
INSERT INTO wim_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","puth ngay pam inman nil God.angan kuch ngayang-a, ngaantiyongk ngatharam anangan kuchāng thananga. Than ngulana pam wanch anangan yalmathayn thanang, than wayan yump-yumpina, putha pam wanch wiy anangan meeꞌan wichin thanang wayan yumpanakana. Ngaantiyongk ngatharamangana, kenthayn thanang pam wanch anangan aak God.antam anpalana. ");
INSERT INTO wim_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Aꞌ amanamaniya than ngaantiyongk al-alangana thum karkanang angan theeꞌ-theeꞌayn thanang pench-penchaynweya, thananiya peey-peeyaynweya, koonh thakan path-pathwayna. ");
INSERT INTO wim_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Puth pam wanch God.antam anangana an ep-paththam than aak piip God.antamangana maꞌ nungantang angman wun-wunayn. An thanana park-parkayn keꞌ kinch yimanangan park-parkayna. Yaa, niiyaniya kan min-minam kon wunāna, wik inangan min-minam ngeeyān a!” ");
INSERT INTO wim_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Aꞌ nil Jesus.angana wik kath thonangan ngul waaꞌ thant, “Aakan kan-kanang wampana nil God.angan pam wanch yotam maꞌ nungantangan piꞌ-piꞌow. Inan wik kath yimanangan wunowa. Nil pamangan way min min-miniy uwa, aak paddock meekantamang, aak awarang wun-wun, maꞌ mupama. Nilana ngangk min paththam wun-wuna, aꞌ nilana koyam ngul kaamp way min anangan. Aꞌ koyam ngul iiy aak nungantamakan, way min maꞌmangkam nungantamaniya sellimpung pam wanch wiyantan, aꞌ nilan koyam ngul iiy aak paddock aakanakan, aꞌ wukal theeꞌ aak-kunch alantana, anan yipam piiyow paddock anana nungantakamana, way min min-miniy yipam nungantakaman piꞌ-piꞌow. ");
INSERT INTO wim_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Wik kath thon inana, aakan kan-kanang ngul wampana nil God.angan pam wanch yotam maꞌ nungantangan piꞌ-piꞌow. Inan wik kath yimanangana. Nil pam thonama yuk pearl min aakanakan wenk-wenk. ");
INSERT INTO wim_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Anpalana, nil yuk pearl thonam min-minam paththam thath store.angan wun-wuna aꞌ nilaniya koyam iiy aak nungantamaka, aꞌ way min maꞌmangkam nungantam anangan-a, sellimpung pam wanch wiyantan, nilan koyam yipam yuk pearl min paththamana, nil piiyow nungantakama. ");
INSERT INTO wim_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Aꞌ putha, aakan kan-kanang wampana nil God.angan pam wanch yotam maꞌ nungantangan piꞌ-piꞌow-a, inaniya wik yimanangana wun-wun. Pam wiyangana, yuk punththaman theeꞌin kookam piꞌanang than yipam minh ngaꞌ mamayn aꞌ thananiya minh yot mamin, minh wiy-wiyam thakan mamina. ");
INSERT INTO wim_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Punththamanan anhan ngulan ween-a, minh ngaꞌ yotan puth wipin anpalan-a, thananiya aak uthak ngul kenyam wichinweya. Aꞌ than nyiinin ngul than yipama minh ngaꞌ anangana meen-umpayna — minh ngaꞌ min anangana, yuk bucketangan wunpayn thanang; minh ngaꞌ way anangana, theeꞌayn thanang. ");
INSERT INTO wim_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Aakan putha yimanangan wunow ngampar aak inan kanan minchowa: than ngaantiyongk al-alangana pam wanch way anangana meen-umpayn thanang, aꞌ pokkap wunpayn thanang, aꞌ yaarkathayn thanang pam wanch min al-alantamana, ");
INSERT INTO wim_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","aꞌ thum karkanang ngul theeꞌayn thanang pench-penchayn pam wanch wayanang anangana aꞌ koonh thanttakaman path-pathayn.” ");
INSERT INTO wim_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Aꞌ nilan thaw thant, “Niiy ngul kan ngeeyan ey? wik inangan kan-ngul thiichaniy ey?” Thanan puth thawin nungant, “Eeꞌa, ngan kan-ngul thiichana.” ");
INSERT INTO wim_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Nil puth Jesus.an thaw thant, “Wik inana yimanangan wunanweya: than pam wiy al-alangan wik thayan Moses.antaman thaaꞌ-aath-aathantan niiyang. Than puungk wiy al-alanganiya God.an monkan-wak-wakantan nunang, maꞌ nungantangan iiy-iiyantan. Thananiya keꞌ pam anan aawuch-kunchana, nil pam aawuch-kunch alanganiya way min keenkanaman anangan-a, aꞌ putha way min nyiingkanam anangan piꞌ-piꞌan thanang. Thananiya yimanangana, than putha wik keenkanaman-a, aꞌ puth wik nyiingkanam anangan thaaꞌ-aath-aathantan niiyang — wik keenkanaman nil piip God.angan kaꞌathaman thaaꞌ-aath-aath ngampanga — puth wik nyiingkanam inangana thaaꞌ-aath-aathantan niiyang, an ngayang anman wik waaꞌantan,” wik yimanangan nil Jesus.an thaw thantaniya. ");
INSERT INTO wim_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Anpalaniy-a, nil Jesus.angan wik kath anangan kanan waaꞌ thant-a, nil aak anana kan-ngul wanta, ");
INSERT INTO wim_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","aꞌ nil iiy ngul koyam aak nungantamakan. Aꞌ nil thaaꞌ-aath-aath thanang pam wanch anangan aak church thanttam angan ngul. Than wikan ngeeyin nunang Jesus.an-a, than yot anangana meeꞌam ikin, aꞌ thawin thanttakaman, “Nil pam inana nil wik inangan want-wanttak thiicha? Nil inan wanttinpal kuchek waap minaniy uw a? Aꞌ puth nil work piꞌ-piꞌanam inangan want-wanttak yumpan e? ");
INSERT INTO wim_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Pam nil aawuchan kaach-kaachan yaꞌ ey? Kaath nungantam Mary anana! Nil puth anman ey! Pam kuunch nungantam inangana — James-a, Joseph-a, Judas-a, aꞌ Simona, ");
INSERT INTO wim_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","aꞌ puth wanch kuunch nungantam inangan wuntana! Nil inan wanttinpal kuchek waap minaniy uwa?” ");
INSERT INTO wim_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Than wik yimanangan thawin thanttakaman, than puth kaangk keꞌ wik ngeeyayn nunang Jesus.ana. Aꞌ nil Jesus.an thaw thant, “Nil weeꞌangan nathweya wik God.antaman waaꞌ-waaꞌiy kampan nungantamakaniy-a, than keꞌ kaangkiyathantan nunang aak nungantamangan puth keꞌ wik ngeeyiythan nunang. Nil pam thon aak nathpalan wampiy-a, thanan ep-paththam kaangkiyathantan nunang aꞌ wik nungantaman ngeeyantan.” ");
INSERT INTO wim_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Than pam wanch aak anganan wun-wunin-a, keꞌam ngangk theeꞌin nungant Jesus.antan yaꞌa, nil anpalana work piꞌ-piꞌanam koꞌalam anman meenath thant aak angana, yot yaꞌa. ");
INSERT INTO wim_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Aak an-aniyangana, nil King Herod.ana pam piꞌan iiy-iiy aak Galilee.akan. Aꞌ nil wik thooꞌ ngeey Jesus.antamana putha work piꞌ-piꞌanam nilan yump-yump, ");
INSERT INTO wim_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","aꞌ nil ngaantam-ngeey keꞌ John.an mulaman eka aꞌ nilan thaw thant pam nungantam al-alantan, “Nil pam nanman John.an ey? kuchekan kuungk-kuungk thanang ey? nil mulaman kan ek ey? Nan nilama, nil keꞌ-paal work piꞌan nanangan yump-yumpana! Ngayaniy keꞌ nunang thath-thathanga.” ");
INSERT INTO wim_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Nil puth King Herod alangana kaꞌathangamana wanch pont-kunch maꞌam piiyan Philip.anweya, nil ngul wanch nungantakam maayana, wanchaniy nampa Herodiasa. Nil Johna, nilan pam wanch kootra.an kuungk-kuungk thanang, nil nathpalman thaw-thaw nunganta pam Herod alantan, “In min yaꞌa, nint wanch nalantangan wun-wunangana. An wanch nungkar yaꞌa! Nint wik thayan God.antam pip-pipangana.” Pam Herod alantan-a, man kul paththam wampanta, aꞌ nil pam al-alantan thawa workan iiy-iiyin nungant, “Ayyang, niiy pam nanan John.an mamān nunanga!” Aꞌ thananiya mamin nunang, aꞌ maꞌana kuuyang kathin nunang ngul, aꞌ kalin nunang aak jailak. ");
INSERT INTO wim_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Nil Herod.angana puth kaangk mulathow nunang, puth yaꞌa, nilanwey winynyang moꞌ pam wanch Jews al-alantamana, than puth ngaantam-ngeeyin nil pam anan prophet, wik min God.antaman waaꞌ-waaꞌ. ");
INSERT INTO wim_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Anpalan-a, aakan kan-ngulwey wampant nilanwey aak-ngeey, pam piꞌan Herod.ana, birthday nungantamanwey. Aꞌ thananiya may piꞌan paththam yumpin. Nil puk otham Herodias alantamana, an nil-nilam keeꞌ-keeꞌ meeꞌ yotantangana. Nil Herod.ana ngangk min paththam wun nunganta, ");
INSERT INTO wim_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","aꞌ nilan thaw nungant, “Ngay inan kan-kanam thawang nungkara. Nint ngeenak nathan thawān ngath-a, an ngay theeꞌāng nungka.” ");
INSERT INTO wim_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Aꞌ nil kaath nungantaman thaw nungant puk-kunchantan, “Ayyang, thuw-ang, nint yimanangan thawān nungant Herod.antana, ‘Nint ngatha kuchek John.antaman inman theeꞌān ngathara! aꞌ ikang pal kalayn ngathara!’” ");
INSERT INTO wim_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","King Herod.antan-a, ngangk way wunanta, puth nilan kaangk keꞌ mulathow nunang pam John.ana. Nil putha keꞌ wik pipiw nungantamana wanch koman alantan nilan thaw nungantan kon yotantangana kuchek John.antamakana, yaa, nil Herod.ana thaw thant pam nungantamakan pam John.an mulathayn nunang. ");
INSERT INTO wim_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Than pam anangana iiyin ngul aak jailakan, aꞌ John.ana mulathin nunang, kuchek nungantamana thalokang umpin, ");
INSERT INTO wim_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","aꞌ pal ngul kal-kalin yuk ikang puk wanch koman alantan. Aꞌ wanch koman alanganiya kaath-kunchant ngul kal, kuchekana. ");
INSERT INTO wim_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","John.an kanan mulathin nunang-a, ngurp nungantam anangan ang wampin aak jailakan yipam pam mulana awarang kaampayn nunang; amanamaniya thananiya iiyin ngul aꞌ waaꞌin nungant Jesus.antan. ");
INSERT INTO wim_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Nil Jesus.angan kanan wik thooꞌ ngeey John kanaman mul wun-a, nil aak anan want ngul, aꞌ kan-ngul moꞌ-moꞌ chukkunangana aak thonaka, nil yipam aak enyanang nyiinow nil-nilama. Than puth pam wanch yotangan wik ngeeyin nil aak thonak ngulan iiyowa, yaa, thananiya kan-ngul aak towns thon-thonana want-wantin ngul aꞌ monkanam kuchin nunang, than thaꞌang ngul iiy-iiyin. ");
INSERT INTO wim_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Nil Jesus.ana chang ngul pey chukkunamana aꞌ nil pam wanch yot anangan thath thanang. Nil puth ngangk mam thanang, aꞌ nil miyalath thanang pam wanch weech-weechanan thanangana. ");
INSERT INTO wim_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Kinch-way-wayang ngul-a, ngurp nungantam Jesus.antaman wampin nungant, thawin nunganta, “Ayyang, in kinch-way-wayang ngula, aꞌ aak inan kechweya! Nint pam wanch anangan kuchān thanang than iiyayn aak towns aakanakana, than may yipam piiyayn thanttakamana.” ");
INSERT INTO wim_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Nil Jesus.an thaw thant, “Yaꞌa, ngay kaangk keꞌ kuchāng thanangweya. Niiyama may aathān thanangweya!” ");
INSERT INTO wim_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Thanan puth thawin nungant, “Ngan may many thamp, may bread five.a, aꞌ puth-a, minh ngaꞌ kucham piꞌ-piꞌanan, anman thonakama.” ");
INSERT INTO wim_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Nil Jesus.an thaw thant, “May anangan pal kalān ngathara.” ");
INSERT INTO wim_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Anpalan-a, nil thaw thant pam wanch yot al-alantan aakang nyiinayn, wakang angmana. Aꞌ anpalaniy-a, nil may bread aꞌ minh ngaꞌ anangan maꞌang maay, aꞌ meeꞌ keny thath, aꞌ meeꞌ-wuthanam ngul piip God.anta, thankyou thaw nungant may minh aakanakan. Nil may bread anangan pip-pip thanang aꞌ theeꞌ ngurp nungantam al-alantan ngul than yipam kalayn pam wanch yot al-alantana. ");
INSERT INTO wim_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Than pam wanch maꞌmangkam al-alangan mungk-mungkin ngul, aꞌ thip oth ngul wunin. Aꞌ than ngurp nungantam al-alangana may nhanth anangan yalmathin aꞌ yuk basketang wunpin. May nhanth aꞌ minh ngaꞌ nhanth al-alangan baskets twelve thaaꞌ mul maay. ");
INSERT INTO wim_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Pam anangan than mayan mungkin-a, an yota, thaaꞌ-wantanam, five thousand, aꞌ wanch yot al-alangan aꞌ puk yot al-alangan may minh mungkin thamp. ");
INSERT INTO wim_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Anpalaniy-a, nil Jesus.an thaw thant ngurp nungantam al-alantan chukkunangan chang peyayn aꞌ woꞌuwayn keenk moꞌayn. Than kanan moꞌin-a, nil Jesus.an pam wanch thaaꞌ-wantanam al-alantan thaw thant aak thanttamak kan iiyayn. ");
INSERT INTO wim_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Nil kanan thaw thant-a, nil-nilam ngul iiy pokkapang aak yoykaka nil yipam meeꞌ-wuthanamow piip nungantamakan. Ngaaꞌ kanan ench-a, nilam Jesus.an yoykang angman yippak pokkapang nyiin-nyiin. ");
INSERT INTO wim_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Chukkunana kech ngula ngak kookamangana aꞌ yeelalangana chukkun palam-puyam theeꞌ-theeꞌanweya, aꞌ wuntangan thampa thaamp-thaampana. ");
INSERT INTO wim_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Aak kanan pach-pachaman-a, nil Jesus.an umang iiy thant ngak kenyangka iiy-iiy. ");
INSERT INTO wim_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Than thathin nunangan-a, ngak kenyangkan umang iiy-iiy thantan-a, than ngangk ikin, aꞌ than thawin thanttakaman, “Nanpal oony iiy-iiyan ngampar ey?” aꞌ than othamayan pech-pechin, than puth winynyang moꞌ-moꞌin. ");
INSERT INTO wim_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Nil Jesus.an thaw thant, “Niiy keꞌ winynyang moꞌāna! In ngayam wamp-wampang niiyanta! Niiy ngangk thayanam wunāna!” ");
INSERT INTO wim_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Aꞌ nil Peter.an thaw, “Ayyang, moom-ang, nan nintam kan-kanamwey-a, yaa, nint thawān ngatha umang iiyāng nungkar a! ngak kenyangk angmana iiyāng keꞌ nint nanman iiy-iiyangana.” ");
INSERT INTO wim_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Nil Jesus.an thaw Peter.antan, “Pal iiya!” Yaa, nil Peter.ana chukkunamana uk ngakangan aꞌ iiy-iiy ngak kenyangka um Jesus.ant keꞌ aak eꞌang anman iiy-iiy, keꞌam thucha, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Amanamaniya, nil wunt piꞌanan ngaantam-ngeey, nilana ngangk winynyangwey ngul wunanta, kan-ngul thuch-thuch pekam ngakanganiya, aꞌ nilana erkam pech Jesus.antan, “Ayey! Moom ey! Ngayang kaaꞌ-piichanathāna!” ");
INSERT INTO wim_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Aꞌ nil Jesus.ana erkam maꞌ ongkaramanta, aꞌ mam nunang, Peter.ana. Nilana thaw nunganta Peter.antana, “Nint ngul wanttaka keꞌaman ngaantam-ngeeyan ngayanganiy e? ngay nintangan minaman piꞌing e? Nint wunt wanttak ngaantam-ngeeyan e? nint ngayang keꞌam ngaantam-ngeeyana, yaꞌa.” ");
INSERT INTO wim_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Pul Jesusa puth Peter.ana chukkunang karpam chang peypul, anpalaniya wunt piꞌanana kan-ngul thuch-thuch, yaꞌ-ngul, enyan ngul wuna. ");
INSERT INTO wim_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ngurp nungantam al-alangana thaaꞌ-kuumpin nunang Jesus.ana, aꞌ thanan thawin nungant ngul, “Ayyang, moom-ang, nint in kan-kanam paththama puk nhengk God.antam a!” ");
INSERT INTO wim_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Anpalana, than woꞌuwayn peyin chukkunangana aꞌ aak Gennesaret.akana wampin ngul. ");
INSERT INTO wim_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Than pam wanch than aakan punchanangana thiichin nunangan pam ngurp nilam Jesus.ana, than puth wik kuchin thant pam wanch weechanan thananga aak villages nath-nathan wunin, aꞌ than pam wanch alpan anangan wampathin nungant. ");
INSERT INTO wim_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Than pam wanch anangan thaaꞌ-mamanang thawin nungant, “Ayyang, than alpan al-alangan kulich thaaꞌan nungkaraman keꞌ mamiythan ey? miyal yipam wunayn ey?” Aꞌ than alpan al-alangana kulich thaaꞌan mamin nungantama, an miyal paththam ngul wun-wunina. ");
INSERT INTO wim_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Anpalaniya, than pam puungk wiy Pharisees anangana puth pam teachersa wik thayan paththam Moses.antaman thaaꞌ-aath-aathinan-a, than aak Jerusalem anpalan wampin nungant Jesus.antan, aꞌ mep-mepin nungant, ");
INSERT INTO wim_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Ayyang Jesus-ang, an than ngurp nungkaram al-alangan aak ngamparam wuut mangkangan wantin-a, than kan kumin ey? Than may mungkanakan-a, thanana maꞌ min-min keꞌam pung-pungwuntan, yaꞌa!” ");
INSERT INTO wim_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Nil puth Jesus.an thaw thant, “Niiyaniya, wik thayan God.antaman pip-pipaniy a! Puth niiyan wik thayan wuut mangk niiyantam al-alantaman ep piꞌ-piꞌaniya, piip God.antamana an yaꞌa! ");
INSERT INTO wim_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Nil puth piip God.an thawa, ‘Niiy ngangk minangam iiyān kaath piip niiyantamakana. Niiy wik min thanttaman erkam ngeeyān, aꞌ maꞌ-aathān thanang.’ Aꞌ putha nil wik inangan thamp thawa, ‘Than weeꞌ-weeꞌanangweya kaath piip thanttamakana thaaꞌ poch-pochaman thawayn thant-a, koonhang akayn thanang thakan-a, niiy mulathān thananga.’ ");
INSERT INTO wim_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Niiy kaath piip niiyantaman min-minam piꞌ-piꞌān thananga, may thak aathān thananga, puth yaꞌa, niiyana wik niiyantakaman thaaꞌ-aath-aathwuniya, ‘An min ngampar ngamp wik yimanangan thawimp thantanwey kaath piip ngamparamakana, “Nipala, in ngeeyowa, ngay keꞌ-ngul piꞌing nipanganiya, wukal inangana piꞌ-piꞌāng nungantwey piip God.antan theeꞌāng, work nungantamakana, niparana yaꞌa!” ’ An yaꞌa! Niiy yimanangan keꞌ thawān kaath piip niiyantamakana. Putha niiyiya wik min God.antamana kaangk keꞌ ngeeyāna, niiy nanpalana keꞌ-ngoongkam aak woyan niiyantam anman iiy-iiyaniya! ");
INSERT INTO wim_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Niiy yaan muuk-muukamaniy a! Aak keenkanaman-a, pam Isaiah alangana wik kan-kanam waaꞌ-waaꞌ niiyanganiya. Nil putha piip God.angana wik inangan waaꞌ nungant pam Isaiah alantan: ");
INSERT INTO wim_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Pam wanch than il-ilangan thaaꞌ-kuumpantan ngayangana, puth ngangkaman keꞌ thaaꞌ-kuumpantan ngayang, yaꞌ ey! Than yaan muukamantan meeꞌ yotantangana, than kecham iiy-iiyantan ngatharamaniya.’ ");
INSERT INTO wim_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Than yaan thaaꞌ-kuump-kuumpantan ngayang, puth ngangk pal pekkuwamana, yaꞌa, than puth wik thayan wuut mangk thanttam al-alantaman thaaꞌ-aath-aathantan thanang, puth inangan wik ngatharamana yaꞌa, than thawantan keꞌ wik minan waaꞌantan, nil yaꞌa! Than yaan wik uuy-uuyamantan.” ");
INSERT INTO wim_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Aꞌ nil Jesus.angana pam wanch yot anangana ump thanang nungantang thinth wampayn, aꞌ nil thaw thant ngul, “Niiy wik inangana ngeeyāna! kuchekangan piꞌ-piꞌān a! ");
INSERT INTO wim_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nil pamang nathweya may ngench thayanan mungkiya nil puth God.angana pam wayana keꞌ waaꞌowana may anpalmaniy. Puth nilwey pamang wik way anman ngangkangaman piꞌ-piꞌiy-a, nilaniya wik wayan ngul thawiy, an puth nilana way-wayam paththam ngul weeniya.” ");
INSERT INTO wim_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Amanamaniya than ngurp nungantam anangana wampin nungant aꞌ thawin nungant, “Nint kan meeꞌmiy ey? wik anangan nintan thaw-thawan-a, pam Pharisees anangana nyaaꞌ thawin.” ");
INSERT INTO wim_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Nil puth Jesus.an thaw thanta, “Than pam Pharisees anangan keꞌ yuk yimanangan piip ngatharamang keꞌaman kaampa — nil wayathow thanang ngula, keꞌ yuk aakam yimanangan wichow. ");
INSERT INTO wim_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Niiy kuchek keꞌ wayamān thanttamana. Than keꞌ pam wanch meeꞌ koꞌanch yimanangan, maꞌ punth maman wich-wichwuntan. Pul nathwey pam meeꞌ koꞌanch kuchama, nil thon alangan maꞌ-punth mamanang nath wich-wichiy nunang-a, pulaniy karpam awarang keekiypula.” ");
INSERT INTO wim_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Nil puth Peter.an thaw nungant Jesus.antan, “Nint wik anangan koochanathān nganta.” ");
INSERT INTO wim_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Nil Jesus.an thaw thant, “Niiy ngul kuchek thinhan yippak ey? keꞌ pam wiy anangan ey? ");
INSERT INTO wim_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Niiy keꞌam ey? min-minan ngaantam-ngeeyaniy ey? Wik ngay nyiingkan waaꞌ-waaꞌang niiyant-a, an yimanang wunana. Nil pamangweya mayan mungkan-a, an mayaniy-a, thip nungantamang wunan, amanamaniya may ananganiya pentan ngul nungantam. ");
INSERT INTO wim_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Puth nilwey pamang way anman ngaantam-ngeeyiy-a, nil wik way thakan thawiya, aꞌ puth nilana way-wayam paththam ngul weeniy. ");
INSERT INTO wim_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Puth than pam wanchangana nath way anman ngaantam-ngeeyiythan-a, than puth way ngul yump-yumpantan, thananiy-a, pam wanch mul-mulathantan, putha maarich thak keeꞌ-keeꞌantan, aꞌ pam wanch wiyantamana way min maꞌ-kuch-kuchathantan thanttam ngula, aꞌ putha wik uuy-uuyamantan, aꞌ pam wiy anangan aak-yaꞌang waaꞌ-waaꞌantan thanangweya. ");
INSERT INTO wim_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Nil pam nathweya way yimanangan iiy-iiyiy-a, an nil piip God.angan thath-thathan nunang nil way-wayam ngul iiy-iiyana. Puth nil pamangweya maꞌ keꞌan min-min pungiy nungantakamana may mungkanakan-a, amanamana nil piip God.angan-a, way keꞌ waaꞌiy nunang, yaꞌa,” nil Jesus.an wik yimanangan thaw thant. ");
INSERT INTO wim_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Anpalan-a, nil Jesus.angana aak anana want ngul, aꞌ kan-ngul iiy aak thonak, aak Tyre aꞌ Sidon thinth angana. ");
INSERT INTO wim_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Aꞌ wanch anganwey wun-wuna, aak Canaan anpalan wamp. Nilanweya wamp nungant Jesus.ant aꞌ thawanta, “Ayyang, Lord-ang, nint kampan nungantam wuut mangk David alantamana! Nint ngayang keꞌwey ngangk mamin ey? Puk wanch koman ngatharam ilangana oony way ngangkang piꞌ-piꞌanweya. Oony way alangana kan-kanam way-wayathan nunangwey a!” ");
INSERT INTO wim_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Nil puth Jesus.ana wik keꞌam thaw nungant wanch alantana. Aꞌ ngurp nungantam anangan wampin ngul aꞌ thawin Jesus.antana, “Ayyang, moom-ang, nint wanch nanana puy kan kuchān nunanga! Nil monkan-wak-wakan ngampanga, puth-a, wik wolmp piꞌ-piꞌan thampa!” ");
INSERT INTO wim_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Aꞌ nil Jesus thaw thant, “Nil piip God.angana ngayang kucha thant thonakama pam wanch aak Israel punchan al-alantana. Than keꞌ minh sheepa nathan weꞌaramin piip God.antamana.” ");
INSERT INTO wim_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Nil wanch alangana wik inangan ngeeyan-a, aꞌ nilana wamp Jesus.anta, aꞌ pungkang thuch nungant, aꞌ thaw nungant ngula, “Ayyang, moom-ang, nint ngayang maꞌ-aathāna!” ");
INSERT INTO wim_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Nil puth Jesus.ana thaw nungant, “Ngaywey may puk manyiy anangan maꞌam piiying thanang ey? Kuꞌant theeꞌ-theeꞌing ey? An yaꞌa! An min ngath yaꞌa!” ");
INSERT INTO wim_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Nil puth wanchana thaw nungant Jesus.antana, “An kan-kanama, mooma, wik nintan thawana, puth kuꞌ al-alangana may nhanth anangan mungkantana, table.aman keekantana.” ");
INSERT INTO wim_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Nil puth Jesus.an thaw wanch alantan, “Nint puth kan-kanam minam ngaantam-ngeeyangan ngayang. Yaa, ngay puth puk wanch nungkaramana miyalathāng nunang keꞌ nint anman ngath wik thawana.” Nil Jesus wik thonakaman thaw nungant kaath-kunchantan-a, an-aniyangan-a, puk wanchana miyal ngul ween, kuchek minam ngul, oony wayana kanam pent ngangk nungantam anpalana. ");
INSERT INTO wim_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Anpalan-a, nil Jesus.angana aak anan want ngul aꞌ nil thomp anman wak-waka iiy-iiya kookam Galilee wakanana. ");
INSERT INTO wim_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Pam wanch thaaꞌ-wantanam anangan wampin nungant, than karpam kalin thanang pam wanch weech-weech thanangana, than kunp anangan, aꞌ meeꞌ koꞌanch anangan, aꞌ than makar yalamin anangan aꞌ pam wanch keꞌan thawantan ananganweya, aꞌ pam wanch alpan wiy anangana. Than thaꞌ Jesus.antangan thinth nyiinathin thanang, aꞌ nil miyalath thanang yotam anangan. ");
INSERT INTO wim_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Than pam wanchangan meeꞌam ikin, than puth ngeeyin thanang pam wik keꞌ thawanama wik ngul thaw-thawina, aꞌ puth kunp anangan-a, iiy-iiyin ngul, aꞌ makar yalamin anangan-a, miyal ngul iiy-iiyina, aꞌ koꞌanch anangan-a, aak ngul thath-thathinweya. Thanan-a, thaaꞌ kuump-kuumpin nunang God thanttam pam wanch Israel punchan al-alantaman. ");
INSERT INTO wim_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Nil Jesus.an thaw thant ngurp nungantam al-alantan pal wampayn nungant, aꞌ nil thaw thant, “Ngay ngangk mam-mamang thanang pam wanch inanganiya, puth thananiya maꞌ-koꞌalam ngul aak ingman ngatharangan iiyina, puth thananiya may keꞌanangwey wun-wunin. Ngayan kaangk keꞌ kuchāng thanangwey koyam aakakan iiyayn may keꞌ mungkanamana, thanan nath chip-chipamana ngul thaꞌ-thayan keekina.” ");
INSERT INTO wim_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ngurp nungantam anangan thawin nungant, “Ngamp may yot wanttinpal uwāmp thanta aak ingan pintalangana? ngamp yipama pam wanch yot thaaꞌ-wantanam inangan aathāmp thanangwey e?” ");
INSERT INTO wim_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Nil Jesus.an thaw thant, “Niiy puy may bread ngeen-ngeen piꞌ-piꞌaniy e?” Thanan thawin nungant, “May bread sevena aꞌ puth minh ngaꞌ koꞌalama!” ");
INSERT INTO wim_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Nil puth Jesus.an thaw thant, pam wanch yot al-alantan aakang nyiinayn. ");
INSERT INTO wim_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Nilaniya, may bread seven anangan-a, aꞌ minh ngaꞌ koꞌalam anangan-a, maꞌang maay thanang aꞌ thankyou ngul thaw God.antan. Amanamaniy-a, may minh anangan-a, many-manya nhanthath thananga, aꞌ ngurp nungantamak ngul theeꞌ-theeꞌ pam wanchantan yipam theeꞌ-theeꞌayna. ");
INSERT INTO wim_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Than pam wanch-a, puth-a, puk manyiy yotam al-alangana mungkin aꞌ thip oth ngul wunin. May aꞌ minh kanan minchathin-a, than ngurp nungantam al-alanganiya maya aꞌ minh nhanth ananganiy-a, maay-maayin ngul aꞌ baskets seven ananganiya thaaꞌ mul wunina. ");
INSERT INTO wim_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Pam ananganiy-a, four thousand nil Jesus.angan may aath thanang, aꞌ nil may aath thanang thamp wanch yot anangan aꞌ puk yot anangana. ");
INSERT INTO wim_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Amanamaniya nil Jesus.an thaw thant kan-ngul iiyayn aak thanttamakan, aꞌ nil Jesus.an-a, puth ngurp nungantam anangan chukkunang ngul peyin, aꞌ kan-ngul moꞌ-moꞌin aak namp Magadan aakanakana. ");
INSERT INTO wim_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Anpalaniya, puungk wiya Pharisees anangan-a, puth-a, Sadducees anangan wampin nungant Jesus.antan. Aꞌ thanan thawin nungant work piꞌan yumpow meeꞌ thanttangana nil yipam meenathow thantana nil God.angan maꞌ-kunch yump nunang. Thanan yaan thawin Jesus.antan wik yimanangana, thanan thathayn nil nath work piꞌanan nath yumpowa, nath yaꞌa, keꞌ yumpiy. ");
INSERT INTO wim_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Puth nil Jesus.an thaw thant, “Kinch kanan uk-ukan-a, niiyaniy thawaniya, ‘In epa yuw mina ngotan yaꞌa, ngak keꞌ wampiya, puth yuwan wewm wunana.’ ");
INSERT INTO wim_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Aꞌ ngaaꞌ-ngaaꞌthiyangamana, niiyan thawaniya, ‘In aak ngak ukowa an puth yuwana wiy-wiyam ngul ench, ngotan encha, wuꞌ-wuꞌiy thampa.’ Niiy yuw anman thathaniy thonakama, nath ngak wampowa, nath yaꞌa, puth niiyaniya keꞌ thiichinweya nil piip God.angana yip-yipaman want-wanttakan nil ngulan yumpow, niiyan keꞌ meeꞌmiya, yaꞌa! ");
INSERT INTO wim_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Niiy pam wanch man-yethaman wun-wunaniy puy-puyamana, niiy min yaꞌ paththama, niiy pam wanch way-wayam paththam iiy-iiyaniy, niiy piip God.ana too wantan nunang ey! Niiy ngul ngeenak thaachaniy ngayang ngay work piꞌan yumpāng meeꞌ niiyantamangana? An yaꞌa! Ngay work piꞌan keꞌ yumpāng niiyant, yaꞌa. Niiy inan ep-paththam thathān, ngay keꞌ pam anan Jonaha.” Wik kanan thaw-a, nil Jesus.ana kan-ngul iiy, pam anangana want ngul thanang. ");
INSERT INTO wim_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Than woꞌuwaynakan wampin-a, than ngurp Jesus.antam al-alangan ngaantam-ngeeyin ngula may breadan kan kon-ngath thanang, keꞌaman kalin. ");
INSERT INTO wim_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Nil puth Jesus.an wik thayan thaw thant, “Niiy meeꞌ yanth-yanth iiyān thanttam pam Pharisees al-alantamana aꞌ putha Saducees al-alantamana. Niiy wik way thanttamana keꞌ ngeeyāna, puth wik thanttam ananganiya keꞌ may yeast anangana may breadan ulpathan.” ");
INSERT INTO wim_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Than ngurp nungantam anangan kan-ngul wik thaw-thawin thanttakaman anpalan nil Jesus.an wik thawa, aꞌ thanan thawin, “Ngamp may bread keꞌananga, keꞌ-paal nil wik anangan thawa.” ");
INSERT INTO wim_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Nil Jesus.angan kanam thiich thanang wik thanan thaw-thawin, aꞌ nil thaw thant ngul, “Niiy ngeenak thaw-thawaniy niiyantakamana ngamp may bread keꞌanangan iiyampa? Niiy ngul wanttak ngayangan ngangkangan minam keꞌ piꞌ-piꞌaniy e? ");
INSERT INTO wim_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Niiy ngul keꞌ meeꞌmiy yippak ey? Yaꞌ ey? keꞌ yippak ngaantam-ngeeyaniy ey? Niiy keꞌ konangam piꞌ-piꞌaniy ey? ngay kaꞌathamana may bread five.an many-manyan pip-pipangana aꞌ pam wanch yot five thousand anangan aath-aathang thanang may five manyiy al-alantamana. Niiy yuk baskets ngeen-ngeenang may nhanth ananganiy yal-yalmathana? ");
INSERT INTO wim_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ngul amanamana, ngayan may seven pip-pipangan, aꞌ pam wanch yot four thousand anangan aath-aathang thanang may seven manyiy al-alantamana. Niiy yuk baskets ngeen-ngeenang yal-yalmathan may nhanth ananganiy e? ");
INSERT INTO wim_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Niiy want-wanttak keꞌam ngaantam-ngeeyaniy ngay may bread paththaman keꞌam waaꞌ-waaꞌang niiyanta! Ngay inan ep waaꞌ-waaꞌang niiyant: niiy meeꞌ yanth-yanth iiyān thanttam pam Pharisees al-alantamana aꞌ putha Saducees al-alantamana. Niiy wik way thanttamana keꞌ ngeeyāna, puth wik thanttam ananganiya keꞌ may yeast anangana may breadan ulpathana.” ");
INSERT INTO wim_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Aꞌ than ngurp nungantam al-alangan kan-ngul ngaantam-ngeeyin nil wik thayan keꞌam thaw thantana may yeast anpalana, yaꞌa, puth wik wayanang al-alantaman than Pharisees al-alangana aꞌ puth-a, Saducees al-alangan ngul thaaꞌ-aath-aathin thanang wik way-wayana. ");
INSERT INTO wim_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Anpalan-a, Jesus-a, putha ngurp nungantam anangan kan-ngul aak thonak iiyin, aak town thinth, town alantaniy nampa, Caesarea Philippi. Aꞌ nil Jesus.ana kan-ngul thaw thant ngurp nungantam al-alantan, “Ngay pam inmana nil God.angan kuchanya. Than ngul pam wanchangan keꞌ weeꞌ yimanangan ngaantam-ngeeyantan ngayanganiy e?” ");
INSERT INTO wim_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Than ngurp nungantam anangan thawin nunganta, “Than pam wanch puungk wiyangan waaꞌantan nintang keꞌ John pam anana ngakangan kootra kuungk-kuungkan thanang pam wanchana, puth puungk wiyangiya waaꞌantan nintang nint pam Elijaha, aꞌ wiyangiya keꞌ pam anan Jeremiah waaꞌantan nintang puth wiyiy thawantana nint keꞌ prophet wiy anangana.” ");
INSERT INTO wim_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Aꞌ nil Jesus.ana thant ngul thaw ngurp nungantam al-alantan, “Puth niiyana wanttak ngaantam-ngeeyaniy ngayanganiye? Ngay pam weeꞌ iniye?” ");
INSERT INTO wim_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Aꞌ nil Simon Peter paththam thaw Jesus.antana, “Ayyang, nint in ngeey a! Nintiya Christa, pam ananiya nil God.angan kaaꞌngaka ngulan kuchow ngantana. Nint pam nhengk God.antama, man-yethaman wun-wunan alantamana.” ");
INSERT INTO wim_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Aꞌ nil puth Jesus.an thaw nungant Peter alantan, “Ayyang, Simon-ang! puk nhengk John.antam-ang! nan wik kan-kanam thawan nintaniy ngathara — wik nungkaramana keꞌ kunttow thayan yimanangana. Nil piip God.an ngangk min wunowa. Piip ngatharam ilang kenyana wik anangan kuchekang wunp nungkarang, pam wiyangan keꞌ waaꞌin nungkar yaꞌa. ");
INSERT INTO wim_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ayyang, Peter, kan in ngeeya, ngay kan in waaꞌāng nungkar. Namp nungkaram Peter nanana an keꞌ kunttow thayan paththam anangan yimanangan — wik anangan nintan nyiingkan thawana an keꞌ kunttow thayana. Niiy weeꞌ-weeꞌanangweya ngayangan ngaantam-ngeeyaniy ngay puk nhengk God.antaman-a, an keꞌ niiy kunttow thayanang angan than-thananiya. Niiyana karpam ngul iiy-iiyān pam wanch ngatharamaniya. Pam wanch wayanang al-alangana puth oony way al-alangan keꞌ wayathiythan niiyanga yaꞌa. Nungkway niiy uthamānwey-a, niiyaniya aak angman ngatharang ngul wun-wunān aak umpuyama. ");
INSERT INTO wim_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nintiya Peter-a, pam wanch ngatharam anangan minam piꞌ-piꞌān thananga. An keꞌ ngaya yuk key theeꞌāng nungkar inana aawuch ngatharamakan, nint yipam piꞌ-piꞌān thanang. Nint wik ngeen nathan thawin thant-a, yaa, an min meeꞌ God.antangana. Nint nathweya thawin thant woyan way keꞌan wakayn-a, yaa, nil God.an wik anman thawow. Nint nathwey thawin thant woyan minan wakayn-a, yaa nil God.an wik anman thawow.” ");
INSERT INTO wim_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Aꞌ nil Jesus.an thaw ngurp nungantam al-alantan ngula, “Niiy pam wanch wiyantana wik inaniy keꞌ waaꞌāna, wik thooꞌ keꞌ weꞌarathān ngay pam inmana Messiah.ana, pam anman nil God.angan keenkanamana kaaꞌngak kuchow ngayangan niiyantanweya.” ");
INSERT INTO wim_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Amanaman-a, nil Jesus.angana kan-ngul wik engkanang waaꞌ-waaꞌ thant, ngurp nungantam al-alantan, “Ngay mak Jerusalem.akan iiyāng, aꞌ pam wanch wiyanganiya way-wayam anangan yump-yumpayn ngathara. Than pam piꞌan Jews.antam al-alangan way yumpayn ngathar, than pam manth-thayan al-alangan aꞌ puth than moom priestsantam al-alangana, aꞌ pam piꞌ-piꞌanam wiy al-alangan thampa. Amanamaniy-a, than mulathayn ngayang ngula, puth kinch koꞌalamang ngulan wantow-a, ngaya mulaman koyam ekāng ngula.” ");
INSERT INTO wim_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Aꞌ anpalana nil Peter.angan pokkap kal nunang aꞌ wak-wak nunang Jesus.anweya wik al-alantaman nilan waaꞌ-waaꞌ thant nungamangana. Nil thawant, “An yaꞌa, nil God.angan mak weekow nintanga than keꞌ yipam nintangan mulathayna. Aak way anangan nintan waaꞌan nungkamangan-a, ananganiya keꞌ wampow nungkarana, yaꞌa.” ");
INSERT INTO wim_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Puth nil Jesus.ana weent ngul aꞌ Peter.antan thaw ngul, “Nint puy iiyāna! Petera! Nint wik nanangan thaw-thawangan keꞌ oony way piꞌan Satan anana! Nint keꞌ ngayangan um thaamp-thaampangan keꞌan yumpānga. Nan nint-nint kuchekangan ngaantam-ngeey-ngeeyangana, puth nila piip God.angana yimanangana keꞌam ngaantam-ngeey-ngeeyana, yaꞌa!” ");
INSERT INTO wim_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Aꞌ nil Jesus.an thaw thant ngurp nungantam al-alantan, “Nil weeꞌ-nathweya kaangk ngatharanganiy iiyowwey-a, nilaniya keꞌ ngaantam-ngeeyow nungantakamana, yaꞌa. Pam wanch al-alangan nath mulathayn nunanga, keꞌ ngayangan mulathayn, yuk wuuyanangan waanchayn ngayang. Nungkway than wiyangana nath mulathayn nunang-a, nilana ngayang anman monkan-wak-wakow. ");
INSERT INTO wim_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Nil weeꞌangwey wantow ngayangana pam wanch wiyangan keꞌ yipam mulathayn nunang-a, yaa, nilaniya keꞌ wuniy aak ngatharangana, yaꞌa; puth nil weeꞌanganwey anman ngangk thayanangam monkan-wak-wakow ngayangan-a, nungkway pam wanch wiyangana thaaꞌ-thengkathiythan nunang-a, nath mulathiythan nunang-a, yaa, an nil ngangk aak umpuyam wunow aak ngatharangana. ");
INSERT INTO wim_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Pam wanch wiy anangan maꞌmangkiy iiy-iiyantan, way min yot-yotam piꞌ-piꞌantan aak inganiya. Puth ngay nathwey keꞌ kaling thanang aak ngatharamakanwey-a, an way min yot al-alangan ngangk min yumpiy thanang ey? An yaꞌa! Puth pam wanchanganiya yuk way min thanttam anangan theeꞌiythan nungant piip God.antan ey? nil yipam puthangkan kaliy thananga aak min nungantamakan ey? an yaꞌa! ");
INSERT INTO wim_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ngay pam inman nil God.angan kuchanya. Ngay palaman yaam keꞌanam wampāng thanttang ngaantiyongk ngatharam al-alantangan aak iikanakana. Ngay pam piꞌan paththam wampānga, keꞌ piip ngatharam anman Goda. Aak an-aniyangan-a, piip ngatharamana min iiy-iiyow thant than minaman iiy-iiyantan; aꞌ way iiy-iiyow thant than wayan iiy-iiyantana. ");
INSERT INTO wim_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ngay inan kan-kanam waaꞌāng niiyanta: ngaya wunya niiyantamana pam piꞌan paththam wampānga, moom piꞌan king yimanangan wampāng niiyantana. Puth pam wanch wiy aak inman yippak wunaniy-a, man-yethaman iiy-iiyān aak ngulan wampowa, niiy meeꞌ niiyamana ngul thathānwey ngayanganiya.” ");
INSERT INTO wim_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Aak kinch sixangan want-a, nil Jesus.angan ngurp nungantam koꞌalam kal thanang yoyk achantangaka, than inangana Peter-a, aꞌ pul maꞌ-kuuncham anangan James-a, puth Johna. Thanam anangaman keny matin nungantanga. ");
INSERT INTO wim_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Aꞌ than thathin nunang Jesus.ana, kaaꞌwal-a, aꞌ ngook nungantaman wiy-wiyam ngul weena. Kaaꞌwal nungantamana parka keꞌ kinch yimanangan park-parka, meeꞌan mungk-mungk thananga, aꞌ ngook nungantamana pach-pacham paththam weenanta. ");
INSERT INTO wim_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Anpalaniya, than ngurp nungantam koꞌalam al-alanganiy-a, thathin pulang Moses-a, puth Elijah anana pul angman Jesus.antang, wik thaw-thawpul nungant Jesus.antan. ");
INSERT INTO wim_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Anpalana, nil Peter.an thaw nungant Jesus.antana, “Lord-ang, an ngampar min paththam ngamp ingman wunāmpana! Ngay ngorkal koꞌalam keꞌ yumping niiyant ey? aak ingman ey? thonama nungkara, thonaniya nungant Moses.anta, aꞌ thonaniya nungant Elijah.ant a!” ");
INSERT INTO wim_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Nil Peter.an yippak wikan thaw-thaw-a, yuwana thanttang keny angman parka, aꞌ thanana wik inan ngeeyina, yuw anpalan thaw-thaw, “In puk nhengk ngatharama, ngay kaangk paththam nunanga. Nil ngayang ngangk min yumpana. Niiyana wik ngeey-ngeeyān nunangana!” ");
INSERT INTO wim_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Than ngurp nungantamangana wik ngeeyin-a, thanana winynyangwey moꞌ-moꞌin aꞌ pekam thuchin kaaꞌwal thanttamana pek aakang wunpina. ");
INSERT INTO wim_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Anpalana, nil Jesus.ana wamp thant aꞌ maꞌang mam thanang. Aꞌ nil thaw thant, “Ekāna! Niiy keꞌ winynyang moꞌāna! In ngayama!” ");
INSERT INTO wim_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Puth than ekinan-a, an than Jesus thathin nunang, angman than-thana nilam, pam wiy keꞌam thathin, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Anpalan-a, thanan yoyk achantang anpalan kan-ngul pekam ukin ngul. Aꞌ nil Jesus.an thaw ngul thant, “Niiy wik puy-puyamana keꞌ waaꞌān niiy inan thathanana. Ngul-ngulan-a, ngay mulaman ekāng-a, an ep-paththam niiyana waaꞌān thanta. Ngaya pam inman nil God.angan kuchanya.” ");
INSERT INTO wim_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Anpalmana, than ngurp nungantam al-alangana mepin nunang Jesus.ana, “Ayyang, Lord-ang, than puth pam piꞌan anangan wik thayan anangan thaaꞌ-aath-aathantana, than ngeenak thaw-thawantan e? nil Elijah.ana palam wampowa putha nil pam anan nil God.angan kaaꞌngaka mangk nungantang wampowa?” ");
INSERT INTO wim_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Nil puth Jesus.an thaw, “Pam keꞌ Elijah yimanangana wampowa, pam wanch woyan wayaman koyam epankathow thanang woyan min God.antamakana. ");
INSERT INTO wim_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ngay kan inan waaꞌang niiyant: pam keꞌ Elijah yimanangana in kanam wampa, puth pam wanchangan keꞌam thiichin nunang yaꞌa nil God.angan kuch nunang. Thananiya way yump-yumpin nungant puth thanan kaangk way anangan yumpayn nungantana. Aꞌ puth ngatharana way paththam anangan yump-yumpayn thampa, ngay pam inmana nil God.angan kuchanya.” ");
INSERT INTO wim_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Anpalana, than ngurp nungantam al-alangan kan-ngul min-minam ngul ngaantam-ngeeyin nunangan nil Jesus.angan waaꞌ-waaꞌ thant pam John anana kootra.an ngakangan kuungk-kuungk thanangan. ");
INSERT INTO wim_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Anpalaniya, Jesus.ana aꞌ ngurp nungantam koꞌalam anangana koyam ngul iiyin pam wanch yot al-alantan. Aꞌ nil paman wamp nungant Jesus.antan, aꞌ pungkang nyiin um nunganta, ");
INSERT INTO wim_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","aꞌ thaw nungant, “Ayyang, moom-ang, nintwey keꞌ ngangk mamin puk nhengk ngatharamanwey ey? Nil maꞌ-yotam way-wayam wun-wunan, thay-thayanamana, aꞌ nil maꞌ-yotam ngakang keek-keekan, aꞌ thumang keek-keekan thaka. ");
INSERT INTO wim_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ngay kaꞌathamana kan wampathang nunang ngurp nungkaram al-alantana. Thanan keꞌ miyalathiythan nunang-a, puth yaꞌa.” ");
INSERT INTO wim_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Aꞌ Jesus.an thaw thant ngurp nungantam al-alantan, “Ngay aak nathpalman wun-wunangan niiyantanga, puth yaꞌangam, niiyana ngangkang keꞌam piꞌ-piꞌaniy ngayanga. Niiy nath ngul-ngulan ngangkangan piꞌ-piꞌān ngayangana! Ngay yaam kuup-kuupāng niiyant ey? niiyan yipam min-min ngangkangan piꞌ-piꞌān ngayang ey? Ayyang, puk ngechwiyan pal kalān ngathara!” ");
INSERT INTO wim_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Than puk ngechwiyan wampathin nungant Jesus.antan, aꞌ nil Jesus.an oony way alantan thaw ngangk nungantam anpalan pentowa. Nilan puk ngechwiy alantamana pent ngula aꞌ nil erkam miyal wun. ");
INSERT INTO wim_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Anpalana, than ngurp nungantam anangan wampin nungant Jesus.antan, than-thanam aꞌ aak pokkapangan kan-ngul thawin nungant, “Ngan ngul wanttak e? oony way anangan yaꞌangam kenthan puk ngechwiy alantaman e?” ");
INSERT INTO wim_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Nil puth Jesus.an thaw thant, “Niiy puth ngangkangan keꞌam yippak piꞌ-piꞌaniy ngayanga. ");
INSERT INTO wim_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Niiy nath ngangkang manyam piꞌ-piꞌaniy ngayang-a, keꞌ kaanch manya, niiy nath yoyk alantan thawina, ‘Puyam thuuchāna aak thonaka,’ aꞌ nilana kan-kanam kuunyow aak thonaka. Niiy nath yotam work piꞌ-piꞌanam anangan yumpina.” ");
INSERT INTO wim_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","23","Than ngurp nungantam al-alangan karpam yalmathwin aak Galilee angan, aꞌ nil Jesus.an thaw thant, “Pam way al-alangan kan-ngul maꞌam theeꞌayn ngayang pam wiy al-alantan, thananiya mulathayn ngayang, pam ngay inman nil God.angan kuchanya. Kinch koꞌalamang ngulana wantow ngayang-a, ngayana mulaman ekāng ngula.” Than ngurp nungantam anangana ngangk way paththam ngul weemina. ");
INSERT INTO wim_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Anpalaniy-a, nil Jesus aꞌ than ngurp nungantaman aak Capernaum.ak wampin. Aꞌ anpalana, than pam wiy anangan wampin nungant Peter.ant — than pam inangana wukalan yal-yalmathin thanttam pam wanchantaman aak church Jews.antam aakanakana keꞌ wukal income tax yimanangana. Thanan Peter.ant ngul thawin, “Ayyang, nil moom niiyantamangan wukal taxan theeꞌ-theeꞌan ey? churchakaniy ey?” ");
INSERT INTO wim_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Nil puth Peter.an thaw thant, “Eeꞌa.” Anpalaniya nil Peter.ana pek ngoonch aawuchangana, aꞌ Jesus.an thaw nungant, “Simon-ang, nintan wanttak ngaantam-ngeeyangan e? Nil weeꞌ-weeꞌanangan wukal taxamana payimpungantan thant moom piꞌ-piꞌanam ngamparam al-alantan e? Than pam wanch aak in punchanangan ey? yaꞌ nath, than pam wanchang nath-nathpalan wampantan ey?” ");
INSERT INTO wim_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Nil puth Peter.an thawa, “Than pam wanchang aak nath-nathpalan wampina.” Aꞌ nil puth Jesus.an thaw nunganta, “Yaa, ngul than pam wanch God.antam al-alangan wukal tax payimpungiythan ey? moom al-alantan churchan piꞌ-piꞌantan ey? ");
INSERT INTO wim_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","An yaꞌ yaakaꞌa! Puth an kana, ngamp pam inangan keꞌ man kul yumpāmp thananga. Nint iiyāna, thomp aakanakan, aꞌ kuuy theeꞌāna. Nil minh ngaꞌangan pathow nungk-a, wichāna, aꞌ thaaꞌ nungantamangana nint wukal uwāna, nint yipam wukal taxakan theeꞌān ngalant — moom al-alantan churchan piꞌ-piꞌantan. Kalāna aꞌ tax ngalantamana theeꞌān thantweya.” ");
INSERT INTO wim_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Anpalan-a, than ngurp nungantam Jesus.antam anangana wampin nungant, aꞌ thawin nungant, “Aak ngul-ngulan-a, nil piip God.angan nganang yotaman maꞌ nungantangan ngulan piꞌ-piꞌowa. Aak an-aniyangan-a, nil pam weeꞌ-nath pam piꞌan paththaman iiy-iiyow e?” ");
INSERT INTO wim_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Nil Jesus.angana puk many thonam ump nunang, aꞌ aak um-menhang angman thanath nunang, ");
INSERT INTO wim_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","aꞌ nil thaw thant, “Ayyang, in ngeeyāna: niiy piꞌan keꞌ yumpwuna, yaꞌa, niiy keꞌ puk many inan weenāna, mochanam iiy-iiyāna. Niiy keꞌ nath thaaꞌ mochanan iiy-iiyinwey-a, nil God.angan maꞌ nungantangan keꞌ piꞌiy niiyang yaꞌa. ");
INSERT INTO wim_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Niiy mochanwey nath iiy-iiyina keꞌ puk many inman than-than-a, yaa, niiy ngul-ngulana pam piꞌan iiy-iiyān ngula aak an-aniyangana nil piip God.angan pam wanch yot anangan piꞌ-piꞌow thanang maꞌ nungantangana. ");
INSERT INTO wim_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Aꞌ in ngeeyiya! Nil weeꞌ-weeꞌananganweya puk manya keꞌ inana ngangk minangam piꞌ-piꞌow nunang-a, puth nil ngayangan monkan-wak-wakana, an puth nil alangaman keꞌ ngayang thamp ngangk minangam piꞌ-piꞌana. ");
INSERT INTO wim_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Nil weeꞌang nathwey thaach-thaachiy thanang puk manyiy anangana way yumpanakan-a, an than puk manyiy al-alangan kon-ngathan thanang ngula ngayanganwey-a, an way-wayam wampow nungant pam alantan nilan thaach-thaachan thanangana. Pam wiy al-alangan nathwey kunttow wuut piꞌan manang kathiythan nungant aꞌ anpalaniya woꞌuw um-menhang aakanakan kaliythan nunang-a, aꞌ poo thaꞌiythan nunang ngak thangk aakanak peka, nil yipam aak umpuyam thuchow mulakam-a, an way nungant. Puth nil pam alangan nathwey puk manyiy anangan thaach-thaachiy thanang ngayangan keꞌ-ngulan monkan-wak-wakayn-a, an way-wayam paththam wampow nungantaniya. ");
INSERT INTO wim_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Pam wanch way al-alangan kaangk thaachayn niiyang way yumpanakana, niiy keꞌ-ngul yipam monkan-wakān ngayangana — puth inan way-wayam paththama! Than yotangan keꞌ-ngoongkam anman thaach-thaachayn niiyang way yumpanakana, puth God.angan way-wayam paththam yumpow thant ngulana. ");
INSERT INTO wim_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Niiywey wayan yumpin-a, maꞌ niiyantam nalangan-a, nath thaꞌ niiyantam nalangan-a, niiy maꞌa, nath thaꞌan-a, thalokang umpāna, aꞌ piw theeꞌān, niiy keꞌ yipam way anangan yump-yumpāna. Nungkway niiy aak God.antamakan maꞌ keꞌananga, nath thaꞌ keꞌanang iiy-iiyinwey-a, an kana! Puth in ngeeyāna: niiy nath maꞌ kucham thamp aꞌ thaꞌ kucham thamp aak wayakan iiyin-a, an puth way niiyant, puth aak anana thum pam-wiy-keꞌ uthamanana, anman pench-penchana. ");
INSERT INTO wim_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Niiywey nath way thathin meeꞌ niiyantamangan-a, aꞌ amanamaniya niiy wayan yumpin ngulana, an way-wayam paththam niiyant. Niiy meeꞌ thiith niiyantaman thapathān aꞌ piw theeꞌān niiy yipam way anangan keꞌ-ngul thathān. Nungkway niiy aak God.antamakan meeꞌ keꞌanang iiyinwey-a, yaa, an kana! Puth in ngeeyāna: nil nath piip God.angana thum karkanang angan aak way angan theeꞌiy niiyang meeꞌ kucham thampan-a, an way-wayam paththam ngul niiyantana.” ");
INSERT INTO wim_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Nil Jesus.an wik inangan thamp thaw thant, “Niiy wik inangan ngeeyāna: niiy keꞌ wik way-way thakan thawān thant puk manyiy al-alantan, ngay puth inan waaꞌāng niiyant: ngaantiyongk thanttam in kenyan wun-wuntan, piip ngatharamantanga. ");
INSERT INTO wim_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Pam ngay inman nil piip God.angan kuchanya, aak iikanakan ukang ngay yipam kaaꞌ-piichanathāng thanang pam wanch anangan wayan iiy-iiyantan.” ");
INSERT INTO wim_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Aꞌ nil Jesus.angan wik kath waaꞌ thant, “Niiy kan in ngeeyāna, nil pam thonamang minh sheep yot piꞌ-piꞌiy one hundred. Aꞌ nil sheep thonaman puy-puyam iiy-iiyiya, aꞌ nath ngul appenchiywey nungantam anpalana. Puth nil paman wanttak ngula? sheep thonam alantamana kon-ngathin nunanganwey ey? Ninety-nine sheep thonakam piꞌ-piꞌiy thanangwey ey? An yaꞌa. Nil angman wantiy thanang, sheep ninety-nine anangana, wak mungk-mungkiythana, aꞌ erkam ngul iiyiy wenk-wenkiy sheep thonam alantana. ");
INSERT INTO wim_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nil kanan uwiywey-a, ngangk min-minam paththam wuniywey nunganta sheep thonam alantamana yaꞌan appench. Ngangk min wun nungant minh sheep ninety-nine al-alantaman thamp than keꞌaman appenchin nungantaman puth ngangk min-minam paththam wun nungant sheep thonam alantaman nilan uw ngulana. ");
INSERT INTO wim_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Iniya aakan yimanangan wunan piip God.antana: nil kaangk keꞌa puk manyiy anangan appenchayn nungantamana, keꞌ kech iiy-iiyayn thamp nungantamana aak way aakanakaniya.” ");
INSERT INTO wim_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Aꞌ nilaniya wik inangan thaw ngula, “Nil weeꞌ-nathweya wayan yumpiy nungk-a, nath wik wayanang thak thawiy nungk-a, an nint iiyān nungant aꞌ thawān nungantweya, ‘Nint way yumpan ngathara,’ nipam anman kucham nanangamanwey thawow niparakamana. Nil nintang ep wik ngeeyiywey-a, yaa, nip ngurp min koyam ngul iiyow nipaniya, aꞌ kulana yaꞌ-ngulwey niparana. ");
INSERT INTO wim_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Puth in ngeey a! Nil keꞌwey wik ngeeyow nintangan-a, nintiya pam thon ngul uwān nunang, nathwey kucham uwān pulanga, pul yipam ngeeyowpul nipangana wik nipan thaw-thawow niparakamana. ");
INSERT INTO wim_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Nil pam alangan keꞌwey wik ngeeyow pulang pam kucham anangan-a, aꞌ nintiya pam wanch churchakan-a, nint thant waaꞌān way nilan yump nungkara. Aꞌ nil pam alangan keꞌwey wik ngeeyow thanang pam wanch churchak anangan-a, yaa, nintana puth kan wantānweya, aꞌ nintan ngaantam-ngeeyān nunang nil keꞌ pam anangan piip God.an keꞌaman ngangkangan piꞌ-piꞌantan nunang, nil yaakaꞌ keꞌ pam anangana wukal anangan yal-yalmathantan thanttakamana. ");
INSERT INTO wim_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Ngay puth inan thawāng niiyant: niiy pam wanch God.antam inangan wikan thawin thantan-a, nil piip God.ana wik anman thawow thantaniya. Niiy nathwey thawin thant pam wanch al-alantan woyan way keꞌan wakayn-a, nil puth God.an wik anman thawow thantweya. Niiy nathwey thawin thant woyan minan wakayn-a, nil puth God.an wik anman thawowa thantana. ");
INSERT INTO wim_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Aꞌ ngay in thamp waaꞌāng niiyant: nath pam kuchamwey karpaman meeꞌ-wuthanamiypul aak ingan-a, engk-engkiypul God.antan-a, ngeenak nathanwey engk-engkanpul nungantan-a, aniy-a, nil piip ngatharamang ilang kenyana ngul theeꞌow pulanta. ");
INSERT INTO wim_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Than weeꞌ-weeꞌananganwey-a, nath kuchamwey-a, pam nath koꞌalamweya yalmathwayn thanttakaman-a, than puth ngayangan ngangkangan piꞌ-piꞌantan-a, yaa, ngayiya angman thanttangwey thampa.” ");
INSERT INTO wim_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Nil ngurp Jesus.antam Peter anana wamp nungant aꞌ thawant, “Lord-ang, nil pamangan nath way yump-yumpow ngathar-a, ngay maꞌ ngeen-ngeen ngangk mam-mamāng nunang a? ngay maꞌ sevenakam yaakaꞌ thaw-thawāng nungant ey? ngay keꞌ-ngulan ngaantam-ngeey-ngeeyāng ey? nil ngathar wayan yump-yump ey?” ");
INSERT INTO wim_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Puth Jesus.an thaw nungant, “In ngeeyāna! Maꞌ sevenakam thonakam yaꞌa! An chil-chila! Niiy maꞌ-yotam ngangk minangam iiy-iiyān nungant, maꞌ-yotam keꞌ five hundredakama thawān nungantweya niiy keꞌ-ngulan ngaantam-ngeeyān way nilan yump-yumpa ");
INSERT INTO wim_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","puth aakan yimanang wunan piip God.antamana. Ngay inan waaꞌāng niiyant wik kath pam wuut piꞌan king alantaman. Nil kingan ngaantam-ngeey nungantakaman, ‘Pam wiy al-alangan workan iiy-iiyantan ngatharana thaniya wukal owe.impungantan ngayangana. Ngay kan kuchāng pam piꞌan ngatharaman uwow thanang, aꞌ pal kalow thanang ngathara.’ ");
INSERT INTO wim_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Anpalana, nil pam piꞌana yoon pent, aꞌ pam thonam ngoonchath nunang king alantan puth nil wukal thaꞌiy owe.impungan, keꞌam koyaman theeꞌ nungant king alantan. ");
INSERT INTO wim_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Puth nil pamanwey-a, wukal keꞌanang koyaman erkaman theeꞌowant, an yaꞌ yippaka! Nil puth kingan thaw pam piꞌan alantan, ‘Yaa, kan kuchān nunang, aꞌ sellimpungān nunang, aꞌ wanch nungantam aꞌ puk nungantam anangan thamp, aꞌ way min maꞌmangkam nungantam tham sellimpungān ngay yipam wukal ngatharam koyam uwāng.’ ");
INSERT INTO wim_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ngul nil paman-a, pungkang nyiinant, aꞌ thaaꞌ-mamanang thawant, ‘Nint keꞌ yippak kuupin ngatharwey ey? Ngay wukal maꞌmangkam anangan koyam ngul theeꞌāng nungkara.’ ");
INSERT INTO wim_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Yaa, pam king alangana ngangk mamanwey aꞌ thaw nungant, ‘Yaa, kan a! Ngal keꞌ-ngul ngaantam-ngeeyāl ngula, wukal thaꞌiy ngayan theeꞌang nungkara. Ngay wukal aakanakan keꞌ-ngul thawing nungka, yaꞌa!’ Aꞌ king alangan yoon kan-ngul kuch nunanga. ");
INSERT INTO wim_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Nil paman yoon pent-a, aꞌ pam thonan thath nunang ngul. Nil pam thon ilangan wukal many owe.impungan nunang, pam nil anman king alangan ngangkan mam nunang. Nil pam alangan man mam nunang pam thonan, aꞌ man inth-inth nunangwey, aꞌ thawant, ‘Nint paththam wukal ngathan erkam theeꞌāna wukal ngayan theeꞌang nungkar anpalanweya.’ ");
INSERT INTO wim_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Puth pam thonan pungkang nyiinant aꞌ thaaꞌ-mamanang thaw nungant, ‘Nint keꞌ yippak kuupin ngathar ey? ngay wukal nungk koyam ngul theeꞌāngwey a!’ ");
INSERT INTO wim_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Puth nil paman-a, kaangk keꞌ wik nungantaman ngeeyow. Anpalaniya, nil paman thaw thant, pam thapangumpan al-alantan, ‘Niiyalang, niiy jailang wunpān nunang, angman piꞌ-piꞌān nunang. Nil wukalan koyaman theeꞌow ngatharan-a, an ep pentathān nunang.’ ");
INSERT INTO wim_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Than pam wiy al-alangan anan thathinan-a, ngangk way wunina aꞌ man kul paththam wamp thant pam alantaman, aꞌ than pek ngoonchin king alantan wikan waaꞌin nungant. ");
INSERT INTO wim_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Aꞌ nil king alangan wik kuch pam alantan pekan ngoonchow nungant, pam anman nil nyiingkan ngangkan mam nunanga, aꞌ thawant ngul, ‘In nint pam way paththam a! Ngay nyiingkan ngangk mamang nintang aa? aꞌ puth-a, ngay thawang nungka, “An yaꞌ-ngul. Kan mincha. Ngal keꞌ-ngul ngaantam-ngeeyāl wukal anana, puth nintaniya thaaꞌ-mamanang thaw-thawan ngathana keꞌan wayan yumpāng nungka.” ");
INSERT INTO wim_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Puth nint thampan keꞌ ngangk mamin nunangan ey? pam thon anan ey? In nint pam way paththam a!’ ");
INSERT INTO wim_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Nil kingan man kul wampant aꞌ pamana jailak kuch nunang ngul. Nil kingan thaw thant thapangumpan al-alantana, ‘Nangman piꞌ-piꞌān nunang. Nil wukal punch-aakaman koyam theeꞌow ngathar-a, an ep pentathān nunang aak jailamana.’” ");
INSERT INTO wim_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Nil Jesus.angan wik kath inan kanan minchath-a, nil wik inan ngul thaw, “Than pam wiy al-alangan wayan yumpayn niiyantan-a, niiy ngangk mamān thananga, ngangk minangam thawān thantweya, ‘Ngay keꞌ-ngul ngaantam-ngeeyāng way niiyan yumpan ngathara!’ Niiy keꞌwey thawin-a, yaa, nil piip ngatharam ilang kenyan keꞌ pam king anana yimanangan iiy-iiyow niiyant, kuchow niiyang aak nungantam anpalan aak wayakana.” ");
INSERT INTO wim_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Nil Jesus.an wik anangan kanan thaw-thaw thant-a, nilaniya aak Galilee.ana want ngul, aꞌ chukkunang woꞌuwayn ngul moꞌ punth Jordan.ana aakanak aak Judea.akan. ");
INSERT INTO wim_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Pam wanch yotang monkan-wakin nunang, Jesus.an aꞌ nil puth pam wanch yot alpan anangan miyalath thanang. ");
INSERT INTO wim_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ngul amanamaniy-a, pam Pharisees puungk wiy anangana wampin nungant. Than yaan thawin nungant, nil wik want-wanttakan thawow thanta, “Ayyang, ngul wik thayan ngamparamangan wanttak waaꞌan e? An ngul min ey? pamang wanch thum nungantaman aak-yaꞌangan aak umpuyangaman wantowan ey?” ");
INSERT INTO wim_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Nil puth Jesus.an thaw ngul thant, “Niiy ngul wik anangan keꞌam wichan thanang ey? lat ngench thayan anpalaniy ey? Keenkanama, nil God.angana kucham yump pulanga, pama, aꞌ puth wancha. ");
INSERT INTO wim_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Aꞌ puth nil piip God.aniy thawa, ‘Nil pam alangana kaath piip nungantamana too ngul wantow pulanga, aꞌ pulan wanch-kunchang yipam karpam ngul wun-wunowpula. Pul kucham ananganiya keꞌ thonam ngul weenowpula’ — ");
INSERT INTO wim_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","pulana pok-pokkapang keꞌ wun-wunowpul, yaꞌa, pul keꞌ thonam anman ngul weenowpul. Nil piip God.ana yimanangan thaw, ‘Pam wanch ngentwaynan-a, karpam anman iiy-iiyayna — wiy al-alangan keꞌ wayathayn pulang pam wanch ananganiy, pul thampaniya keꞌ wantwuwpul pulantakaman, pulan ngangk minam piꞌwuwpul pulantakamana.’” ");
INSERT INTO wim_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Anpalaniya than pam Pharisees anangan thawin nungant, “Nil Moses.an wik inangan thaw, ‘Nil nath pam thum nungantamangan wanch-kunchan wantiy nunang aak umpuyangaman-a, nil lat manyan theeꞌow nungant wanch alantanweya nil pam-kunchangan wantow nunangana aꞌ kan-ngul kuchow nunang.’ An puth nil Moses.ana ngeenama wik yimananganiy thaw a?” ");
INSERT INTO wim_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Aꞌ nil Jesus.an thaw ngul, “Nil Moses.ana wik yimanangan thaw, puth niiy pam wayananga, kuchek thayan paththama, yaꞌangam nganiy maꞌ-aath-aathin niiyangana. Aak keenkanaman nil God.ang aak inan yump-a, an aak yimanangan keꞌam yippak wuna. ");
INSERT INTO wim_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Kan in ngeeyiy a! Pul maꞌ wanch pam ngangk minangaman piꞌwiwpula, keꞌ wantwiwpula. Nil pam weeꞌang wanch thum nungantaman nath too wantiy nunang aak-yaꞌanganwey-a, nungkway wanch nil maarich keꞌaman keeꞌ-keeꞌana pam thonantan-a, an way paththam pam alantaniya. Nil pam alangan nath wanch thon ngulan maayiywey-a, yaa, an nilana maarich keeꞌ-keeꞌana, wanch thon ngulan piꞌ-piꞌana, aakan yimanangan wunana.” ");
INSERT INTO wim_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Aꞌ than ngurp nungantam anangan thawin nunganta, “Nint wik thayan paththam thawan thant pam wanch al-alantan. Puth than pam wanchangan keꞌ ngentwayna, than puth ngul want-wantwin thanttakamana.” ");
INSERT INTO wim_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Aꞌ nil Jesus.an thaw ngul, “Yaꞌ ey! An min thant ey! pam wanchangan ngentwaynana! Puth puungk wiy al-alantan-a, an ep, an min thant keꞌaniy ngentwayn, nil puth piip God.ang maꞌ-aath-aathan thanang minaman iiy-iiyayn. ");
INSERT INTO wim_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Than pam puungk wiyangiya than wanch keꞌam maayantana than puth puk keꞌ wunpiythana, puth yeep way thant, anman aak-ngeeyantan. Wiy anangana pam wiy al-alangan wayathin thanang, kemp umpin thanang, than keꞌ yipam pukaniy wunp-wunpayn wanchantan. Puth than puungk wiyiya kan ngaantam-ngeeyantan thanttakam than kaangk keꞌ wanch maayayna than puth work yipam iiyayn God.antan, wik min anangan waaꞌ-waaꞌayn nungantamana pam wanch wiyantan. Nil pamangwey yimananganiy ngaantam-ngeeyan-a, an kana, an min nunganta.” ");
INSERT INTO wim_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Anpalaniy-a, than pam wanch wiyangan-a, puk manyiy thanttaman wampathin Jesus.ant nil yipam maꞌ wunpow thant aꞌ meeꞌ-wuthanamow thant, puth than ngurp nungantamanganiy-a, kenthin thanang kaath piip puk manyiyantam anangana. ");
INSERT INTO wim_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Puth nil Jesus.angan ngeey thanang aꞌ thaw thant ngurp nungantam al-alantan, “Keꞌa! Niiy keꞌ kenthān thanangweya, puk manyiy inanganiy-a, mak wampayn ngathara, puth nil God.angan kaangk maꞌ nungantang piꞌ-piꞌow thanang. Than weeꞌ-weeꞌanangan keꞌ puk manyiy yimanangan ngangk minangaman wampayn nungant God.antan-a, an nil min-minam ngul piꞌow thanang, than maꞌ nungantang ngul wunayn.”. ");
INSERT INTO wim_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Aꞌ nil maꞌ wunp thant, aꞌ kan-ngul iiy. ");
INSERT INTO wim_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Aꞌ anpalana nil pam umang iiy-iiy nungant, aꞌ thawant, “Moom-ang, nint kan inan waaꞌara: ngay want-wanttak min iiyānga, ngay yipam God.antangana aak umpuyangam wunānga?” ");
INSERT INTO wim_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Nil Jesus.an thawant, “Nint ngeenak thawan ngathar nintan want-wanttakan minan iiyāna? An pam thonam thonakam minaniya, nil God anman, wiyiya yaꞌa. Nint nath kaangk God.antang aak umpuyam wunān-a, nint wik thayan God.antaman kan-kanam ngeeyāna!” ");
INSERT INTO wim_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Nil paman thawant Jesus.antan, “Ngay wik thayan want-wanttin ngeey-ngeeyāngana?” Nil Jesus.an thawant, “Niiy paman keꞌ mulathāna; niiy wanch pam thon alantamana keꞌ maarich keeꞌathāna; niiy yuk way min meekantamana keꞌ maꞌ-kuchathāna; niiy pam wanch wiyana wik aak-yaꞌangan keꞌ waaꞌ-waaꞌān thanang; ");
INSERT INTO wim_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","aꞌ puth-a, niiy kaath piip niiyantaman wik ngeeyān thanang; aꞌ puth niiy paththam kaangk wunān pam wanch puk wiyantana. Keꞌ niiyan min-minam piꞌ-piꞌwuniy niiyantakaman-a, yaa, niiyiya yimanangan pam wanch wiy al-alantan ngangk minangam iiy-iiyān thantwey.” ");
INSERT INTO wim_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Nil pam kompan thawant, “Ayyang, aak anpalmana ngay wik ngench thayan inangan ngeey-ngeeyang thanang. Ngay wanttak ngul yumpāng e?” ");
INSERT INTO wim_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Nil puth Jesus.an thawant, “Nint nath kaangk paththam minam iiyānwey-a, nintiy thonakama iiyāna, aꞌ yuk way min nungkaram maꞌmangkaman sellimpungāna, aꞌ wukal thakan theeꞌān thant pam wanch wukal keꞌanang al-alantana. Anpalana, nint ngayang ngul monkan-wak-wakāna. Ngulana, nil God.an min-minam paththam ngul iiyow nungkar aak ing kenyana.” ");
INSERT INTO wim_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Nil pam alangan wik inangan ngeey-a, nil kan-ngul iiy ngangk way-wayam paththam wunanta puth nilan pam maꞌmangkiya. ");
INSERT INTO wim_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Aꞌ anpalana, nil Jesus.an thaw thant ngurp nungantam al-alantan, “Than pam wanch maꞌmangkiy anangan puth want-wanttaka iiy-iiyiythan maꞌ God.antangan e? An yaꞌ yaakaꞌa! Puth wukal aꞌ way min anangan keeꞌ-enchin thanta. ");
INSERT INTO wim_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ngay putham thawang niiyant: nil camelan puth needle yuutampang wanttak ngoonchow e? An yaꞌa! Inan puth yimanangana. Pam wanch maꞌmangkiy anangan puth want-wanttak maꞌ God.antangan iiy-iiyayn e? An yaꞌa, an thayan paththam wunow thantana, than woyan min God.antaman keꞌ nath uwiythan yaꞌa.” ");
INSERT INTO wim_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Than ngurp nungantam anangan-a, thaaꞌam ikin wik Jesus.antam ngeeyin, aꞌ thawin nungant, “Nil God.angan weeꞌ kaaꞌ-piichanathow e? Nath pam wanch yaꞌ yaakaꞌa!” ");
INSERT INTO wim_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Anpalana, nil Jesus.angan oth thath-thath thanang, aꞌ thaw thant, “Pam wanchangan keꞌ kaaꞌ-piichanathwiythan thanttakamana, an yaꞌa. God.ang thonakam epa pam wanchaniy kaaꞌ-piichanathiya, nil piꞌan aꞌ thayanam paththama, nilan ep maꞌ-min-yumpiy way min thon-thon anangana.” ");
INSERT INTO wim_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Anpalana, nil Peter.an thaw Jesus.antana, “In ngeeya, ngan kampan nganttam aꞌ aak nganttam wantan aꞌ nintang ngul monkan-wak-wakanana. Ngan ngeen nath uwāna?” ");
INSERT INTO wim_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Nil Jesus.an thaw thant, “Ngay kan-kanam waaꞌang niiyant. Ngulan-a, nil God.angana aak umyompanamana nyiingkanam yumpow. Aak an-aniyangan-a, ngaya wuny niiyantamana moom piꞌan paththam iiyāng, ngay yipam pam wanch um ngatharang than-thanathāng thanang. Niiy thamana pam moom iiyāna, aꞌ niiyiya um niiyantamang thanathān thanang pam wanch Israel punchan, wuut mangk ngamparam twelve anpalan wampin, keenkan wun-wunina. ");
INSERT INTO wim_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Aꞌ puth wik inan ngeeyān thampa: than pam wanch wiyangan aak thanttam aꞌ kaath piipa, aꞌ kuunch thanttam thakan wantantan aꞌ puk thanttam aꞌ farm thakan wantantan, than yipam work ngatharamakan iiyayn, than puth kaangk paththam wuntan ngathar. Nil God.ana ngangk min paththam ngul iiyow thant pam wanch al-alantan. Thanan pam wanch yot thaaꞌ-wantanam ngurp yumpayn thanang keꞌ kampan thanttam yimanangan, aꞌ nil God.angan aawuch-a, yuk way min yot-yotam theeꞌow thant. Puth ngul-ngulana, than pam wanch anangan nungantangan God.antangan ngul wunayn aak umpuyama.” ");
INSERT INTO wim_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Aꞌ nil Jesus.angan wik thonangan inan thamp waaꞌ thant, “Than pam wanch wiyangan ngaantam-ngeeyantan than keꞌ pam wanch piꞌ-piꞌanam yimanangan iiy-iiyantana, an puth ngulana than pam wanch many ngul iiyayn. Than wiyangan piꞌan keꞌaman ngaantam-ngeeyantan thanttakamana — ngulana, nil God.angan moom piꞌ-piꞌanam yumpow thanang.” ");
INSERT INTO wim_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Nil Jesus.an wik inangan thaw, “Ngul-ngulaniya nil God.angan ngul meenathow nungamang nilan moom wuut piꞌan paththam ngul iiyow aꞌ pam wanch yotaman maꞌ nungantang ngul piꞌ-piꞌow thanang. Aak anan wampowan-a, aniya keꞌ wik kath inman yimanangan wunowa. Nil pam moomang may kaangk yot em-emath. Yaa, nilana ngaaꞌthiyangamana nguch, nilan yipam pam wiy uwow thanang thanan yipam work iiy-iiyayn nungant, may kaangk anangan yipam thuth-thuthayn nungant. ");
INSERT INTO wim_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Nilan thaw thant nil wukal piꞌan ngul theeꞌow thant, forty dollars kinch thonamang anmana, aꞌ nil kan-ngul kuch thanang work iiyayn aak nungantamangan, may kaangk anangan thuth-thuthayn. ");
INSERT INTO wim_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Ngul-ngulaniya, nine oꞌclockana, aak ngaaꞌ-ngaaꞌthiyangamana, nil pam moomana putham ngul iiy aak store.aka, aꞌ pam puungk wiy thath thanang than-thanin work keꞌananga. ");
INSERT INTO wim_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Nilan puth thaw thant, ‘Niiy thamp iiyāna aꞌ work aak ngatharamang angan iiyāna, may kaangk anangan thuth-thuthāna, ngay wukal piꞌan ngul theeꞌāng niiyanta.’ ");
INSERT INTO wim_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Puth than pam anangana iiyin ngul, aꞌ kinch keny ngulan-a, twelve oꞌclockangana, nil mooman putham ngul iiy aꞌ pam puungk wiy ngul uw thanang aꞌ kuch thanang work aakanakan, aꞌ putham ngul iiy kinch-wayangana three oꞌclockangan aꞌ pam wiy ngul uw thanang. ");
INSERT INTO wim_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Kinch-way-wayang ngulana, five oꞌclock thinth ngulana, nil store.akana putham ngul iiy aꞌ pam puungk wiy ngul thath thanang than-thanin angman. Nil pam mooman thaw thant, ‘Niiy kinch ongk ingman ngeenak ngul than-thananiya work keꞌanangan e?’ ");
INSERT INTO wim_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Than pam anangan puth thawin nungant, ‘Puth work weeꞌangam theeꞌiy nganta, yaꞌ ey!’ Nil puth pam mooman thaw thant, ‘Yaa, niiy thamp angan iiyān aak ngatharamaka aꞌ may kaangk anangan thuth-thuthāna.’ Than puth pam anangan iiyin ngul workakan. ");
INSERT INTO wim_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Aak ngaaꞌ ngulan ween-a, nil pam moom anana pam nungantam alantan thaw, ‘Nint pal kan umpān thanang pam wiy anangan workan iiy-iiyin, aꞌ nintaniya wukal kan theeꞌ-theeꞌān thant. Kaꞌathamana thant pam al-alantan theeꞌān than koy-koyyuwan wampin workakana.’ ");
INSERT INTO wim_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ngul anpalaniya nil pam alangan forty dollars theeꞌ-theeꞌ thant pam thon-thonantan than work kinch-way-wayang ngulan iiy-iiyin, five oꞌclockana. ");
INSERT INTO wim_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Than pam anangan work ngaaꞌthiyangaman iiy-iiyin-a, aꞌ putha kinch ongkana work iiy-iiyin-a, thanan ngaantam-ngeeyin thanttakam than keꞌ wukal piꞌan uwayna; puth yaꞌa, nil pam alangan forty dollars anman theeꞌ-theeꞌ thant pam thon-thonantana. ");
INSERT INTO wim_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Than pam al-alangan wukal kanan uwin-a, aꞌ kul thaw-thawin pam moom alantan. ");
INSERT INTO wim_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Thanan thaw-thawin, ‘Than pam inangan workakan kinch-way-wayang ngulan iiy-iiyin ey! Thanan puth work manyam iiyinweya! — puth ngan inangana kinch ongk work ep iiy-iiyan kinch karkanangana — puth nintana wukal many anman theeꞌan ngantana!’ ");
INSERT INTO wim_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Nil puth mooman thaw thant ngul, ‘Niiyalang, ngurp ngatharam-ang, niiy kan in ngeeyāna! Ngay niiyang keꞌam monkan-thench-thenchang niiyanga, yaꞌa. Niiy puth niiyam thawan ngathara workan iiyān ngathar kinch thonamangana forty dollars aakanakana. ");
INSERT INTO wim_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Puth wukal niiyantaman kan kalāna aꞌ kan-ngul iiyān aak niiyantamakana. An ngay ngangk minangam theeꞌ-theeꞌang, wukala, an ngay-ngay wukalan theeꞌang thantana pam al-alantan koy-koyyuwan work iiy-iiyina, keꞌ niiyantan wukal theeꞌang yimanangan. ");
INSERT INTO wim_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ngay wukal ngeen-ngeenan kaangk theeꞌāng pamantan-a, yaa, an ngay-ngay theeꞌang, an puth wukal ngatharama. Niiy ngul meeꞌ-wunaniy ey? ngay minan iiy-iiyang thant ey?’” ");
INSERT INTO wim_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Aꞌ nil Jesus.an thaw ngul, “Wik inanganiya, keꞌ ngay kaꞌathaman thaw-thawangana. Than pam puungk wiyangana ngaantam-ngeeyantan thanttakaman than keꞌ pam piꞌana, puth ngulana nil God.angana pam many ngul yump-yumpow thanang, pam piꞌanana keꞌ-ngul yumpwiythan thanttakaman, an yaꞌ-ngul. Than pam wanch wiyangan keꞌaman ngaantam-ngeeyantan thanttakamana than keꞌ pam wanch piꞌ-piꞌanam-a, yaa, an puth ngul-ngulana nil God.angan-a, keꞌ moom piꞌ-piꞌanam ngul yump-yumpow thananga.” ");
INSERT INTO wim_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Anpalaniy-a, Jesusa aꞌ than ngurp nungantam weeꞌanangana woyan wakan iiy-iiyin aak Jerico.aka. Aꞌ nil Jesus.angan pokkap kal thanang ngurp nungantam twelve anangan, than-thanam yipam wik thawayn woyan wakanan iiy-iiyayna. ");
INSERT INTO wim_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Nilan thaw thant, “In ngeeyiya, ngamp inan yiip ngul iiyāmp aak Jerusalem.aka. Than pam wiy al-alangan mamayn ngayanga, ngay pam inmana nil God.angan kuchanya, aꞌ maꞌam theeꞌayn ngayanga ngula pam piꞌan priests al-alantan aꞌ putha pam al-alantan thampa wik thayanan thaaꞌ-aath-aathantana. Thananiya, karpam yalmathwayn aꞌ thawayn ngayan uthamāngana, ");
INSERT INTO wim_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","aꞌ amanamana, thanan-a, maꞌam theeꞌayn ngayang Jews yaꞌ al-alantan ngula. Than Jews yaꞌ al-alangan thaaꞌ-thengkathayn ngayanga, aꞌ whipang thak piik-piikayn ngayanga, aꞌ amanamana yuk wuuyanangan waanchayn ngayang aꞌ mulathayn ngayangweya, puth aak maꞌ-koꞌalamang ngulan wantow-a, ngay mulamana koyam ngul ekānga, aꞌ man-yetham ngul iiy-iiyānga.” Wik inangan nil Jesus.an thaw thant. ");
INSERT INTO wim_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Anpalaniy-a, nil wanch thum Zebedee.antamana wamp nungant Jesus.antan. Nil nhengk nungantaman karpam kal pulang. Nil pungkang nyiin nungantan, aꞌ thaw nungant, “Ayyang, moom-ang, nint nath eeꞌ thawāna, nath yaꞌa.” ");
INSERT INTO wim_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Nil Jesus.an thawant, “Nint kaangk ngeenak e?” Nil wanchan thawant, “Aak an-aniyangan nint moom piꞌan ngulan iiyān aak ing kenyan-a, nintan nhengk ngatharam keꞌ wunpin pulang nungkarangan nyiiniypul ey? Nil thoniya, maꞌ malang nyiiniya, aꞌ thoniya, maꞌ thakang keꞌ nyiiniy nungkarangan ey?” ");
INSERT INTO wim_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ngul nil Jesus.an thaw nungant, “Nint keꞌ meeꞌmiy nint ngeenakan engk-engkangan e! Ayey, nipalang, than wiyangan way yumpayn ngathara, aꞌ mulathayn ngayanga. Nip ngul kaangk ey? than way nipar thampan yumpayn ey?” Pulan puth thawpul nunganta, “Eeꞌa, ngan kaangk than ngant thamp wayan yumpayna.” ");
INSERT INTO wim_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Aꞌ nil Jesus.an thaw pulant, “Thanan kan-kanam way yumpayn nipara; aꞌ piikayn nipanga aꞌ kul thak thawayn nipar. Puth ngayan keꞌ miꞌing nil weeꞌan nyiinow ngatharang keꞌ moom piꞌan yimanangana. Nilam God.an ngul thawow, nil keenkanaman kanam miꞌa nil weeꞌan nyiinow ngatharangana.” ");
INSERT INTO wim_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Than ngurp nungantam ten al-alangan wik anangan ngeeyin pulantamana pul-kuunchantamana wik Jesus.antan thawpul-a, thanan-a, man kul wampin pulantana. ");
INSERT INTO wim_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Nil puth Jesus.anganiy-a, thanang yotaman karpam ump thanang aꞌ thaw thant, “Niiy meeꞌmiy thanang moom aak thon-thonangan wuntan ey? Than pam wanch anangan maꞌ thayanang piꞌ-piꞌantan thananga, than thawantan thant work thantan iiy-iiyayna. Than keꞌ pam meek piꞌan anman iiy-iiyantan. ");
INSERT INTO wim_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Puth niiyiya, yimanangan keꞌ iiy-iiyān niiy-niiyantakamana. Niiywey nath kaangk pam piꞌ-piꞌanaman iiyānwey-a, yaa, niiyan putha pam wanch wiyan maꞌ-aath-aathān thanang aꞌ minam piꞌ-piꞌān thanang. ");
INSERT INTO wim_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Niiywey nath kaangk pam piꞌ-piꞌanaman iiy-iiyānwey-a, niiyiya puth pam wanch wiy anangan minam paththam piꞌ-piꞌān thanang. ");
INSERT INTO wim_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ngay puth pam inan nil God.angan kuchanya, ngayan puth aak iikanakan ukangana ngayan yipam pam wanch anangan minakam piꞌ-piꞌāng thanang. Niiy woyan ngatharam wak-wakāna. Ngay aak iikanakan keꞌam ukangan than pam wanchangan yipam minam piꞌ-piꞌayn ngayang keꞌ moom yimanangana, yaꞌa. Ngay aak iikanakaniy ukanga yipam chaapar ngatharaman theetathāng pam wanch yotamantana aꞌ kaaꞌ-piichanathāng thanang thamp way thanttam anpalan.” ");
INSERT INTO wim_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Nil Jesus-a, aꞌ ngurp nungantam anangan aak Jericho.ak kan-ngul wantayna. Pam wanch thaaꞌ-wantanam al-alangan monkan-wak-wakin thanangana. ");
INSERT INTO wim_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Aꞌ pul pam koꞌanch kucham anangan woyan wonkang nyiin-nyiinpul. Aꞌ pul wik ngeeypul Jesus.an woyan wakanan iiy-iiy, aꞌ pul kan-ngul pech-pechpul nungant, “Ayyang, Jesus ey! Kampan David.antam ey! Nint nganang keꞌ ngangk mamin ey?” ");
INSERT INTO wim_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Pam wanch yot al-alangan wakin pulang, “Ayyang, nipaley, nip appap nyiinowa!” Aꞌ pul pam anangan puy-puyam othamayan ngul pech-pechpulweya, “Ayyang, kampan David.antam-ang! Nint nganang keꞌ ngangk mamin ey?” ");
INSERT INTO wim_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Nil Jesus.an than aꞌ malang ump pulang aꞌ thaw pulant, “Nip ngeenakwey pechanipa?” ");
INSERT INTO wim_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Pul pam koꞌanch anangan thawpul Jesus.antan, “Ayyang, Moom-ang, ngan kaangk aak thathān ngula meeꞌ nganttamangana!” ");
INSERT INTO wim_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Aꞌ nil Jesus.angan ngangk mam pulang aꞌ meeꞌang maꞌ wunp pulantang, aꞌ yaam keꞌanaman-a, pul meeꞌ min ngul weenpul, aak ngul thathpul, aꞌ Jesus.an monkan-wak-wakpul nunang ngula. ");
INSERT INTO wim_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Than Jesus-a, ngurp nungantam weeꞌanangan kan-ngul iiy-iiyin. Thananiy-a, aak Jerusalem thinth ngul wampin. Aꞌ thanan aak yoyk namp Olives angan wampin ngul. Aꞌ aak yoyk wonkang anganiya, village than, aak namp alantaniya Bethpage. Nil Jesus.angan ngurp nungantam kucham anangana keenk kuch pulang aak village aakanakana. ");
INSERT INTO wim_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Nilan thaw pulanta, “Nip village aakanakan iiyow. Nip angan wampowan-a, nip donkey thathow kuuyang kathin nunang, aꞌ donkey puk many nungantamana anman thamp, than-thanan nungantang. Nip kuuyan thapathowa, aꞌ nip pal kalow pulang ngathara. ");
INSERT INTO wim_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Nil weeꞌan thawow nipar wik yimanangana, ‘Nip donkey nanan ngeenak kalanip nunang e?’ nipan thawow nunganta, ‘Nil moom nganttamangan yaan matowana.’ Anpalan-a, nil pamaniya ngul thawow nipar, ‘Eeꞌwey, nip kalowana!’” ");
INSERT INTO wim_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Nil Jesus.an wik yimanangan thaw-a, an nil meenath ngampar wik than prophetsangan waaꞌ-waaꞌin nunang keenkanam-a, an kan-kanam wampin ngula, wik inangana lat ngench thayanangan umpin: ");
INSERT INTO wim_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Waaꞌān thant pam wanch al-alantan aak Zion.angan wuntana — thathān a! King niiyantaman nanpalan wampan niiyant, donkeyangana! Nil keꞌ pam meek keꞌam wampana, yaꞌa, nil pam mochan wampana, donkey manyang moꞌ-moꞌana.” ");
INSERT INTO wim_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","7","Anpalana, pul ngurp nungantaman kan-ngul iiypul, aꞌ donkey kucham anangan wampathpul nungant Jesus.antan keꞌ wik anman nilan thaw pulant. Anpalana, pulan ngook pulantaman kenyangk wunppul donkeyantanga aꞌ nil Jesus.an kan-ngul pey man-mangk donkey alantangan. ");
INSERT INTO wim_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Aꞌ than pam wanch yotamangana ngook thanttaman woyanang angan wunp-wunpin. Than wiyanganiya yuk punth pip-pipin aꞌ woyanang wunp-wunpin thanang. ");
INSERT INTO wim_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Nil Jesus kan-ngulan nyiin-nyiin man-mangk donkey alantangan-a, than pam wanch yot thaaꞌ-wantanaman umputh iiy-iiyin nunganta, aꞌ than pam wanch wiy ananganiya, kul-kulam iiy-iiyin nungant. Thanan wik pech-pechin, “Yeey! Yeey! Ngamp kampan David.antam inman thaaꞌ-kuump-kuumpāmpan a! Nil God.angan pam inan kuchana, nil mak piꞌanan yumpow nunang a! Ngamp nunang God anman thaaꞌ-kuump-kuumpāmpan a!” ");
INSERT INTO wim_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Than anman yippak iiy-iiyin-a, anpalaniya, nil Jesus.an aak piꞌan Jerusalem.ang kan-ngul ngooncha. Than pam wanch aak anpalmana, thaw-thawin thanttakamana, “Nil ina weeꞌ e?” ");
INSERT INTO wim_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Than wiy anangan thawin thant, “In nil pam propheta, namp Jesus, nil aak Nazareth punchana, aak ananiya aak anman Galilee.angana.” ");
INSERT INTO wim_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Anpalaniy-a, nil Jesus.an aawuch ngench thayanak iiy ngul, aꞌ nil thath thanang pam wanch anangan than minh bullock thak piiy-piiyina aꞌ sellimpung-pungin aawuch ngench thayanang angana. Aꞌ nilan kenth thanang. Nil table thakan wew theeꞌ thanttam pam al-alantaman wukalan piꞌ-piꞌin, aꞌ putha yuk chairs anangana, um pekang theeꞌ ngul pam al-alantamana minh munkiyang anangana sellimpung-punginana. ");
INSERT INTO wim_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Aꞌ puth nilan thaw thant pam wanch al-alantana, “Than keenkanamana wik inangan God.antaman lat ngench thayanangan umpin, ‘Than pam wanch al-alangana aawuch ngench thayan ngatharaman ngulan waaꞌayn aawuchana meeꞌ-wuthanamakana pam wanchantana,’ puth niiy pam wanch il-ilangan aawuch iikanakan yalmathwuniy yipam wukal way min wiyantaman maꞌ-kuchathāna.” ");
INSERT INTO wim_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Aꞌ anpalaniy-a, pam wanch alpan anangana wampin nungant Jesus.antan, aawuch ngench thayanangana, meeꞌ koꞌanch anangan-a, putha pam wanch kunp anangan thamp. Aꞌ nil Jesus.angan miyalath thanang. ");
INSERT INTO wim_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Aꞌ nil work piꞌ-piꞌanam anangan yot yump-yump, aꞌ putha puk manyiy yot anangan aawuch ngench thayanang angan-a, wik othamayan pech-pechina, “Ngamp yotamang pam inan thaaꞌ-kuumpāmp nunang kampan David.antaman a! Nil pam min paththam a!” Than pam piꞌ-piꞌanam priests aꞌ puth pam teachers al-alangan wik thayanan thaaꞌ-aath-aathin-a, oth thath-thathin nunang Jesus.an pam wanchan miyal-miyalath thanangana, aꞌ puk manyiy anangan ngeeyin thanang pech-pechin thakana, aꞌ anpalaniy-a, thantaniy-a, man kul ngul wamp, ");
INSERT INTO wim_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","aꞌ Jesus.ant ngul thawin, “Ayyang, nint kan wik ngeey-ngeeyangan ey? puk manyiy anangan thaw-thawantan ey?” Jesus.an puth thaw thanta, “Eeꞌa, ngay kanam ngeeyang thananga. Niiy ngul keꞌam readimpungan thanang ey? wik anangan God.antaman ey? than lat ngench thayanangan umpin, — wik yimanangan umpin God.antan, ‘Nintiya puk manyiy anangan-a, puth puk manyiy thaaꞌ-paapiy anangan-a, kanam thaaꞌ-aathan thanang minaman thaaꞌ-kuumpayn nintangana.’” ");
INSERT INTO wim_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Aꞌ nil Jesus.angan-a, kan-ngul want thanang, aꞌ nil aak town anpalman iiy, aak Bethany.ak, aꞌ angman paanth. ");
INSERT INTO wim_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Aak ngaaꞌ thonang ngulan-a, than aak Bethany anpalan koyam ngul iiy-iiyin aak Jerusalem.akan-a, aꞌ nil Jesus.ana meech ngul weena. ");
INSERT INTO wim_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Nil yuk koman kecham thath woyan wonkang angan than-than aꞌ nilaniy puth iiy yukan thathow nath may thamp natha, puth yaꞌa, may keꞌam piꞌa, nil yuk anan kangkangam thonakam kang. Aꞌ anpalana, nil Jesus.an yuk kom alantan thaw, “Nint may keꞌ-ngul piꞌāna!” Aꞌ yaam keꞌanam-a, yuk komana akaram ngula. ");
INSERT INTO wim_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Than ngurp nungantam al-alangan inan thathin-a, thanan meeꞌ ikin. Than thawin, “Nil yuk komana wanttakan erkaman akaramweya?” ");
INSERT INTO wim_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Nil Jesus.an thaw thant, “Ngay inan kan-kanam thawang niiyant: niiy nath kan-kanam ngangkang piꞌ-piꞌin ngayangan-a, aꞌ puth keꞌ man-ngeeyin ngayangan-a, yaa, niiy thamp work piꞌ-piꞌanam yump-yumpin keꞌ ngay yimanangan work piꞌan yump-yumpang, yuk kom wayathang thakana. Niiy nath kan-kanam ngangkang piꞌ-piꞌin ngayang-a, yaa, niiy yoyk ilantan thawinweya, ‘Eka! Puy ngakang theeꞌān nungkamanga,’ an nil piip God.angan paththam yumpiya wik niiyan thawana. ");
INSERT INTO wim_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Yaa, ngay inan waaꞌang niiyant: niiywey ngeenak nathanwey thawin God.antan-a, niiy kan-kanam ngaantam-ngeeyān nil theeꞌow niiyant, aꞌ anpalana, nil paththam theeꞌow niiyant.” ");
INSERT INTO wim_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Aꞌ nil Jesus.an koyam wamp thant aawuch ngench thayanakan aꞌ nil thaaꞌ-aath thanang wik min God.antam anangan waaꞌ-waaꞌa. Nil wikan thaw-thaw-a, than moom priestsantam anangan-a, puth than pam wuut manth-thayan anangan wampin nungant, aꞌ thawin nungant, “Nungkar ngul weeꞌ thawa pam wanch inangan thaaꞌ-aath-aathān thanang e? putha alpan anangan miyalathān thanang e? Nintang weeꞌang kuch e?” ");
INSERT INTO wim_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","25","Aꞌ nil Jesus.an thaw thant, “Ngay kan in engkāng niiyanta, aꞌ niiyan ngatha waaꞌān, nil weeꞌ thawant pam John alantan pam wanch kootra ngakangan kuungk-kuungkow thanang e? Nil God thawant ey? Nath yaꞌa, pam wanch thawin nungant ey? Niiy nath waaꞌin ngatharan-a, ngay puthangkan ngul waaꞌāng niiyant nil weeꞌangan kuch ngayangan.” Thananiya kan-ngul thaw-thawin thanttakamana, “Ngamp ngul wanttak thawāmp e? Ngampwey yimanangan thawimp nungantana, ‘Nil God thaw nungant John.antan-a,’ nil puth Jesus.an thawow ngampar, ‘Ngul niiy John.an wanttak keꞌam min-minan ngaantam-ngeeyan nunang wik min God.antaman waaꞌ-waaꞌ niiyantan a?’ ");
INSERT INTO wim_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Puth ngampwey thawimp yimanangana, ‘Pam wanch thawin nungant John.antan-a,’ than pam wanch anangan man kul wampiythan ngampara, puth than pam wanch maꞌmangkamangan kan-kanam ngaantam-ngeeyantan nunang John.an nil prophet wik God.antaman kal-kala.” ");
INSERT INTO wim_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Aꞌ thanan thawin nungant Jesus.antan, “Ngan meeꞌmiy yaꞌa.” Aꞌ nil Jesus.an thaw thant, “Yaa, ngay puthangkana keꞌ waaꞌing niiyant nil weeꞌangan kuch ngayang aak iikanakana yaꞌa.” ");
INSERT INTO wim_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Aꞌ nil Jesus.an thaw thant, “Niiy wik kath inan ngeeyāna. Nil pam thonam puk wuut kucham thamp. Nilan iiy puk kaaꞌ-ngeecham alantana, aꞌ thaw nungant, ‘Ngayantang-ang, nint angan work iiyān garden ngatharamanga, may kaangk anangan minam piꞌ-piꞌān thananga.’ ");
INSERT INTO wim_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Aꞌ nil pam nhengk-kunchan thaw nungant, ‘Yaꞌa, ngay keꞌ kaangk work iiyānga,’ puth ngul-ngulana an ep-paththama nil ngaantam-ngeey workan iiyowa aꞌ nil work ngul iiy-iiy garden angana. ");
INSERT INTO wim_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Aꞌ nil piip nungantamana iiy ngul puk nhengk nungantam thon kuyam alantan aꞌ thaw nungant work iiyow garden angana. Nil puth nhengk-kunch kuyaman thaw piip-kunchantana, ‘Eeꞌ, piip, ngay iiyānga,’ puth nil keꞌam iiy, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Yaa, niiy ngul wanttaka ngaantam-ngeeyaniy e? Nil weeꞌang wik piip-kunchantaman ngeey e?” Thananiy thawina, “Puk kaaꞌ-ngeecham alangana.” Nil puth Jesus.an thaw thant, “Ngay in thawāng niiyanta: pam wanch puungk wiyiya way iiy-iiyin kaꞌathamana — thaniya wukal tax anpalan yal-yalmathinana pam piꞌan alantan, aꞌ thananiy-a, wukal wiy anangan maꞌ-kuchathin thanttakam piꞌ-piꞌina, putha puungk wiyiya maarich keeꞌ-keeꞌinweya. Aꞌ amanamaniya than wik min anangan God.antaman ngeeyina, thananiya maꞌ God.antang ngul iiy-iiyantan, woyan min nungantaman ngul wak-wakantana! Puth niiyaniya yaꞌ paththama, woyan min keꞌam wak-wakaniy yaꞌ anman! ");
INSERT INTO wim_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Pam nil John alangan kootra ngakangan kuungk-kuungk pam wanchan-a, nil wamp niiyant aꞌ waaꞌ-waaꞌ niiyant wik piip God.antamana, putha woyan minan meen-meenath niiyant puth niiyana kaangk keꞌa, niiy man-ngeey-ngeeyan nunang! Than pam wanch anangaman kaꞌathaman wayan iiy-iiyin-a, an than epa wik ngeeyin nunang! Niiy kan thathan thananganiya meeꞌ niiyantamangana, puth yaꞌangama, niiyiya man-ngeey-ngeeyaniy anmana, woyan way anana niiy kaangk keꞌ wantāna!” ");
INSERT INTO wim_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Aꞌ nil Jesus.an thaw ngul, “Ayyang, niiy wik kath thon in ngeeyāna. Nil pam thonam alangana aak piꞌan weꞌar piꞌ-piꞌ aak nungantakamana, aak may kaampanakaniya aꞌ nil may kaangkantam kaanch yot kaamp-kaamp thanang garden nungantamang angana. Aꞌ nilana fence ngul yump, aꞌ anpalaniya nil awar piꞌan weꞌ, may kaangk menchan ngulan weenayn-a, than yipam angan wunpayn thanang aꞌ thaꞌang ngulan maak-maakayn, may kaman yipam pich-pichathayn. Aꞌ amanamaniya nil aawuch achantang ngul kaach than yipam aak thath-thathayn anpal kenyan, than wiyangan keꞌ yipam may kaangk anangan maꞌ-kuchathayn. Anpalaniya, nilan thaw pam wiyantan aak gardenan thath-thathayn, minam piꞌ-piꞌayn nungantwey. Aꞌ nilan thaw thant, ‘May kaangk nanangan kanan menchan weenayn-a, niiyaniya yaarkathān thanang niiyantakamana, aꞌ aathwun, puth puungk wiyiya ngathar piꞌāna.’ Aꞌ nil moom anan-a, kan-ngul iiy aak thonaka. ");
INSERT INTO wim_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Ngul-ngulana, aakan kan-ngul wamp thant may kaangk menchan anangan yalmathayna. Nil moom alangan pam nungantam anangan kuch thanang, aak nungantamakan, may kaangk anangan uwayn nungant. ");
INSERT INTO wim_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Than aak angan kanan wampin-a, than pam al-alangan garden nungantaman piꞌ-piꞌin-a, than kaaꞌ-umangam pam anangan mamin thanangwey, pam thonaman-a, piik-piikin nunangwey, nil pam thonaniya mulathin nunangweya, nil pam thon ananweya kunttowang piik-piikin nunang mulakamweya. ");
INSERT INTO wim_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","“Ngul-ngulana nil moom alangan pam nungantam wiy anangan chil yot ngul kuch thananga. Aꞌ putham ngul way anman yump-yumpin thantweya, thanang thamp pam puungk wiy anangan piik-piikin thanangweya, puth puungk wiy anangan mul-mulathin thananga. ");
INSERT INTO wim_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Nil moomang anan ngeey-a, nil pam nhengk nungantam ngul kuch, nil puth thaw, ‘Than pam al-alangan ngul ngaantam-ngeeyayna puk nhengk ngatharamana, nil puth pam piꞌan thama, keꞌ piikiythan nunanga.’ ");
INSERT INTO wim_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Puth than pam al-alangan thathin nunangan wamp-wamp thantan-a, thanan thawin thanttakamana, ‘Ayyang, nanpalan weeꞌ wampanwey ngampara? puk nhengk moomantam ey? Ngamp mulathāmp nunang, aꞌ ngampan aak garden inan ngamparakam ngul piꞌāmp a!’ ");
INSERT INTO wim_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Aꞌ thanana purpam mamin nunang, aꞌ aak gardenam anpalan-a, yoon piw theeꞌin nunang aꞌ mulathin nunang.” ");
INSERT INTO wim_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Aꞌ nil Jesus.an thaw ngul thant, “Niiy ngul wanttak ngaantam-ngeeyaniy wik kath inaniy e? Nil mooman wampowan-a, an ngul nil want-wanttak yumpow thant pam al-alantan garden nungantaman piꞌ-piꞌin e?” ");
INSERT INTO wim_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Thanan puth thawin nungant, “An nil mulathow thanang paththam pam way anangana, aꞌ nilana pam wiyant ngul thawow aak garden nungantaman piꞌ-piꞌayna. Nilaniya pam min-miniy anangan miꞌow thanang than yipam may kaangk menchan wiy anangan theeꞌayn nungant.” ");
INSERT INTO wim_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Aꞌ nil Jesus.an thaw ngul thant, “Niiy ngul lat ngench thayan anpalan keꞌam wichan ey? wik inangan ey? ‘Than pamang aawuchan kaachantan-a, wiyiya than nath yuk pal pekkuwan aawuchantangan wunpantan-a, an piw theeꞌantan, puth thana ngaantam-ngeeyantan keꞌ yuk way yimananga. Puth yaꞌa, yuk pal pekkuwan aawuchantangana an min paththama, aawuchan thayanam yipam thanow. An puth keꞌ yimanangan pam wanch wiy al-alangan kaangk keꞌ ngayang, monkanam iiyantan ngatharamana. Puth ngayan keꞌ yuk pal pekkuwan wunan aawuchantangana anana thanan piw theeꞌina. Puth ngul-ngulana nil piip God.angan pam wuut piꞌan paththam yumpow ngayanga — ina min paththam wunowa!’” ");
INSERT INTO wim_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Aꞌ nil Jesus.an thaw ngul, “Yaa, ngay inan thawang niiyanta — niiy nath ngaantam-ngeeyaniy niiyantakam niiy keꞌ pam wanch God.antam ey? niiy ngul maꞌ nungantang wun-wunaniy ey? An yaꞌa, nil God.angan too wantow niiyang. Nil God.angan wiy anangan maꞌ yalmathow thanang maꞌ nungantangan yipam iiy-iiyayn, aꞌ woyan min yipam nungantaman wak-wakayn, nil anangan maꞌ nungantangan piꞌ-piꞌow thananga.” ");
INSERT INTO wim_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Than pam piꞌan priests al-alangan putha Pharisees al-alangan wik kath inan kan ngeeyin nil Jesus.angan waaꞌ-waaꞌ thant pam wanchantan, than puth kanwey thiichin nil thanangan waaꞌ-waaꞌ thant yotantan, ");
INSERT INTO wim_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","puth thanana thawin thanttakamana thanan mamayn nunangweya. Puth yaꞌa, thanan winynyang moꞌin, an puth pam wanch yotangana ngaantam-ngeeyin nil Jesus.ana pam prophet paththam iiy-iiya. ");
INSERT INTO wim_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Aꞌ nil Jesus.anganiya putham ngul wik kath waaꞌ-waaꞌ thant, pam wanchantan, nil wik engk-engkanang keꞌam waaꞌ thant, yaꞌa, nil keꞌ wik kath anman waaꞌ-waaꞌ thant. ");
INSERT INTO wim_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Nil thaw thant, “Aak ngulan wampowa nil God.angan pam wanch yotaman piꞌ-piꞌow thanang maꞌ nungantanga. Wik inangan waaꞌ-waaꞌānga, aakana yimanangan wunow. Aak keenkanama, pam nil piꞌan, kinga, — yaa, niliya may piꞌan yump puk nhengk nungantamangana wanch ngentowa. ");
INSERT INTO wim_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Aꞌ nil pam piꞌan alangana pam workan iiy-iiyin nungantana kuch thanang pam wanch wiy anangan pal umpayn thanang may piꞌanakana. Than puth yaꞌangam thaw-thawin thant, thanan kaangk keꞌ iiyayn thanttang mayakana. ");
INSERT INTO wim_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Yaa, pam piꞌan alanganiya pam wiy ngul kuch thanang, mayakan pal umpayn thanang. Wikana yimanangan kuch, ‘May piꞌan ngatharamana an kanam yumpina. Minh bullocks min-miniy anangana kanam ump-umpin thananga — may-a, minh-a, an anman wun-wuntan ngamp mungkāmp ngula. Niiy pal erkam yotam wampān a!’ ");
INSERT INTO wim_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Puth pam anangan thampanga yaꞌangam thaw-thawin thant, puth pam wanch anangana kaangk keꞌ may piꞌanakan wampayn, than keꞌ-ngoongkam work iiy-iiyin; pam thonamiya koyam iiy farm nungantamakan; nil pam thonaniya, koyam iiy store nungantamakan, ");
INSERT INTO wim_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","puth puungk wiyangiya, pam workan iiy-iiyin pam piꞌan alantana, maꞌ mamin thanang, aꞌ thep-thepin thanang, aꞌ mulathin thanang. ");
INSERT INTO wim_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Nil pam moom piꞌanana man kul paththam wamp nunganta, aꞌ nil pam soldiers nungantam anangan kuch thanang, aꞌ thanana mul-mulathin thanang puthangkana, aꞌ town umyompanam thanttamana thumang kiingkin ngul. ");
INSERT INTO wim_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Aꞌ nil king alangana pam workan iiy-iiyin nungant puungk wiy anangan ump thanang, aꞌ thaw thant, ‘May piꞌan ngatharamana an kanam may minh menchan anman wun-wunana, puth pam wanch anangana ngay kaꞌathaman wik kuchang thantan-a, than pal keꞌam wampin mayakana, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Yaa, niiyiya, woyan piꞌan wakan iiy-iiyāna, pam wanch yot-yotam pal umpān thanang mayakan wampayna, niiy puyan thathān thanang pam wanch-a, pal umpān thanang may piꞌan ngatharamakana.’ ");
INSERT INTO wim_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Aꞌ pam work nungantan iiy-iiyinwey-a, thananiya woyan aakanakan pentin ngul aꞌ pam wanch yot-yotam ngul yal-yalmathin thanang, puungk wiyaniyweya pam wanch wayanang; puungk wiyaniyweya ep pam wanch mina. Aawuch pam piꞌan alantamaniya, pam wanchangama thaaꞌ-thupam ngathina. ");
INSERT INTO wim_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Nil pam piꞌanana pek aawuchang ngooncha pam wanch anangan thathow thananga. Aꞌ nil pam thonam thathana nil ngook min keꞌam ngooncha. ");
INSERT INTO wim_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Aꞌ nilan thaw nungant, ‘Ayyang, ngurp ngatharam-ang, nint ngul in wanttak ngoonchan e? Ngook min-minam keꞌam ngoonchan ey?’ Puth nil pam ananweya wik keꞌam thawa yaꞌa, popam anman nyiin-nyiin. ");
INSERT INTO wim_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Aꞌ pam piꞌan anan thaw pam al-alantan workan iiy-iiyin nungantana, ‘Ayyang! Niiy thaꞌana puth maꞌana kuuyang kathān nunanga pam inan a! aꞌ puy yoon aakang theeꞌān nunang, aak ngaaꞌanga, nil angan peey-peeyowa, koonh thakan path-pathow nungamanganweya.’” ");
INSERT INTO wim_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Aꞌ nil Jesus ngulan thawa, “Wik kath anana yimanangan wunana, nil God.angana pam wanch yot-yotam umpow thanang, puth pam wanch koꞌalam thonakam miꞌow thanang.” ");
INSERT INTO wim_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Anpalan-a, than pam Pharisees anangan kan-ngul iiyin, aꞌ karpam wik yump-yumpin. Aꞌ thawin, “Ngamp mepāmp nunang, yaan paathāmp nunang nil nath Jesus.ana wik want-wanttakan thawow ngampar.” ");
INSERT INTO wim_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Thananiya, pam thanttam wiy anangana kuchin thanang, putha pam Herod.antam wiy anangana kuchin aꞌ than karpam iiyin nungant Jesus.antana, aꞌ thawin nungant, “Ayyang, moom-ang, ngan kan meeꞌmiy nint wik kan-kanam anangan thaw-thawangana, puth woyan min God.antaman kan-kanam thaaꞌ-aath-aathangan nganang. Nungkway than pam wanch wiyangan ngangk-wayangaman kal-kaliythan nintangan-a, puth nintana keꞌam yaaman ngaantam-ngeeyangana, yaꞌa nint kon uth anman iiy-iiyangana. Puth nint pam piꞌan al-alantaman keꞌam winynyang moꞌangan yaꞌa, nint keꞌ-ngoongkam wik kan-kanam anman waaꞌ-waaꞌangan pam wanchantan. ");
INSERT INTO wim_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Yaa, nint kan wik inan waaꞌān nganta nint wanttakan ngaantam-ngeeyangana. An ngul kan-kanam ey? ngan wukal theeꞌin ey? keꞌ income tax yimanangan ey? pam moom piꞌan alantan ey? aak Rome.angan wun-wunan ey? nath yaꞌa, keꞌ theeꞌān nungant ey?” ");
INSERT INTO wim_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Aꞌ nil puth Jesus.angana kanam thiich thanang pam anangan than pam min yaꞌa, than pam ngangk way-wayam paththam, than yaan paath-paathin nunang, nil puth thaw thant, “Niiy pam inanganiya way-wayam paththam a! Niiy yaan muuk-muukamaniya niiy keꞌ pam min iiy-iiyaniya, an yaꞌa! Niiy ngul ngeenak thaachaniy ngayang a? ngay yipam wik way-way thamp thawāng niiyantan ey? an yaꞌa! ");
INSERT INTO wim_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Niiy wukal niiyantam puyan piꞌaniya niiy meenathān ngathar a! Wukal taxakana!” Thanana wukal anana wampathin nungant Jesus.antan, ");
INSERT INTO wim_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","aꞌ nil puth Jesus.an thaw thant, “Wukal ilangan kaaꞌwal weeꞌantam piꞌan a? puth namp thampana weeꞌantam wukal ilantangan wunan a?” ");
INSERT INTO wim_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Than pam anangan thawin nungant Jesus.antan, “Pam moom piꞌan alantaman aak Rome.angan wun-wunana.” Nil Jesus.an thaw thanta, “Yaa, wukal inana pam piꞌan alantana niiy koyaman theeꞌān nunganta. Nil piip God.angana ngampangan yumpa, ngampaniy-a, ngangk ngamparamana koyam theeꞌāmp nunganta.” ");
INSERT INTO wim_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Than pam Pharisees al-alangan wik inangan ngeeyinan-a, thanan thaaꞌam ikina aꞌ thananiya wantin nunang ngul Jesus.an aꞌ kan-ngul iiyin. ");
INSERT INTO wim_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Aak an-aniyangan-a, pam puungk wiy Sadducees anangana wampin nungant Jesus.antan. Than Sadducees il-ilangana, than ngaantam-ngeeyin pam wanch mulan wuntana, than koyaman keꞌ ekiythana. ");
INSERT INTO wim_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Than thawin nungant, “Pam Moses keenkanamana yimanangan thawa, ‘Nil pamweya puk keꞌanangan uthamiy-a, yaa, nil pont nungantam alangan wanch wukalongkana nil ngul maayow nunanga, pul yipam puk uwowpula, thanan yipam ngaantam-ngeeyayna puk anangana keꞌ pam mul alantamana.’ ");
INSERT INTO wim_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Puth nint kan wik kath inan ngeeyān a! Aak keenkanamana, than maꞌ-kuuncham pam seven wun-wunin aak inganiy. Wuny thanttamangan kaꞌatham wanch maay — ngul-ngulaniy-a, nil puk keꞌananga anman uthama. Yaa, pont nungantamang ngul wanch wukalongkan maayana. ");
INSERT INTO wim_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Aꞌ nil thampana puk keꞌanang uthamweya. Pam kuunch nungantam thon alangan ngul maay nunanga wanch wukalongkana, aꞌ nil yimanang puk keꞌanang thamp uthama. Pam kuunch nungantam maꞌmangkam al-alangan maay-maayin nunang, wanch wukalongkana, aꞌ than maꞌmangkamana puk keꞌanang anman uth-uthamina. ");
INSERT INTO wim_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ngul-ngulaniya, wanch wukalongkan utham ngula. ");
INSERT INTO wim_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Yaa, kan in ngeeyiy a! Aak ngulan wampowan-a, than pam wanch mulaman koyaman ngulan ekayn-a, man-yetham ngulan iiyayn-a, nil wanch wukalongkana wanch thum weeꞌantam ngul iiyow e? Puth nil wanch alangana pam maꞌ-kuuncham seven anangaman maay thanang a!” ");
INSERT INTO wim_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Aꞌ nil Jesus.an thaw thant ngul, “Niiy wik way-way thawaniy a! An puth niiy keꞌam wik min God.antam anangana min-minaman ngaantam-ngeeyaniya, wik lat ngench thayanangana aꞌ putha niiy min-minam keꞌam thiichaniy nil piip God.ana pam wuut piꞌan paththamana! ");
INSERT INTO wim_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Than pam wanch yotamana mulaman ekayn-a, aꞌ man-yetham koyam ngulan iiy-iiyayn-a, an thananiya keꞌ ngaantiyongk anman iiy-iiyayn ing kenyana, keꞌ-ngul ngentwayn yaꞌa. ");
INSERT INTO wim_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Niiyiy wik anman thaw-thawaniy than pam wanch mulaman keꞌ yaakaꞌ ekayna. Niiy ngul wik God.antaman kanam thathan ey? lat ngench thayanangan ey? ");
INSERT INTO wim_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Nilaniya wik inangan thaw, ‘Ngayiya God inman thanttam pam Abraham-a, puth Isaaca, aꞌ Jacob weeꞌanang al-alantamana.’ Nil God.ana God thanttam pam wanch man-yethaman iiy-iiyantan, pam wanch mul al-alantaman yaꞌa.” ");
INSERT INTO wim_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Than pam wanch yotamangan wik inan ngeeyin-a, thananiya thaaꞌam ikin. ");
INSERT INTO wim_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Anpalan-a, than Pharisees al-alangan ngeeyin nil Jesus.ana meeꞌangam thaw thantana Saducees al-alantana aꞌ thananiya popam ngul nyiin-nyiinin, koyaman keꞌam ngul thawin nungantana. Aꞌ than Pharisees anangan yalmathwin thanttakam, ");
INSERT INTO wim_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","aꞌ nil pam thonam thanttam Jesus.ant iiy yipam paathow nunang nil wik wanttakan thawow. Nil pam inmana, wik thayanan thaaꞌan-aath-aatha. ");
INSERT INTO wim_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Nilan puth thaw nungant Jesus.ant, “Ayyang, Moom-ang, lat ngench thayanangan-a, wik thayan God.antaman yot ngampar ngeeyanakana! Nint keꞌ miꞌin wik thayan thonam min paththaman ey?” ");
INSERT INTO wim_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Nil Jesus.an thawant, “‘Niiy kaangk paththam piip God ngamparamantan wunāna, nil puth moom piꞌan niiyantaman, niiy pam wanch min koochanam iiyān nungant, man-kuchaman yaꞌa, aꞌ wik nungantaman ngangkangam piꞌ-piꞌān, wik maꞌmangkam anangan ngeeyāna.’ ");
INSERT INTO wim_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Wik inangan kan-kanam min paththaman niiyantan ngeeyanakana. ");
INSERT INTO wim_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Aꞌ thon inan ngeeyāna, ‘Niiy paththam kaangk wunān pam wanch puk wiyantana. Keꞌ niiyan min-minam piꞌ-piꞌwuniy niiyantakaman-a, yaa, niiyiya yimanangan pam wanch wiy al-alantan ngangk minangam iiy-iiyān thant.’ Wik thayan kucham inangan karp wunanpul, an min-minam paththama! ");
INSERT INTO wim_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Wik thayan kucham pul inangan ngayan waaꞌ-waaꞌangan-a, keꞌ wik anman Moses.angan puth prophets al-alangan keenkan umpin lat ngench thayanangan. Wik anangan-a, karp anman, keꞌ wik thonam ngampar, yipam ngamp min-min ngul iiyāmp God.ant, aꞌ woyan nungantaman min-min wakāmp a!” ");
INSERT INTO wim_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ngul-ngulaniya, than pam Pharisees puungk wiy anangana karpam yalmathwin thanttakam aꞌ Jesus.ant wampin ngul. Nilan thaw thant, ");
INSERT INTO wim_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ngul niiy wanttak ngaantam-ngeeyaniy a? Nil wuut mangk Messiah.antaman weeꞌ e? Pam alantaman nil God.angan kaaꞌngak kuchowan ngamparana?” Thanan puth thawin nungant, “Pam David.ana wuut mangk nungantamaniya.” ");
INSERT INTO wim_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Nil puth Jesus.an thaw thant, “Yaa, nil puth Ngeen-Wiy Min God.antamana ngeenak thaw nungant David.antan nil Christ.an moom nungantaman waaꞌowan a? ");
INSERT INTO wim_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Nil puth David.angan wik inangana lat ngench thayanangan umpa, ‘Nil Lord God.ana moom ngatharamant thawa, “Nintaniya moom piꞌan ngatharang iiy-iiyāna; aꞌ ngay ngul maalathāng thanang than nintangan ngangk-wayangaman kal-kalayn. Nintaniya moom karangk paththam iiy-iiyān thantana.” ’ ");
INSERT INTO wim_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Wik iniya wuut mangk David.angan waaꞌ. Niliya Christ.ana moom nungantam waaꞌ nunang. An-ngul nil wanttak David.ana wuut mangk nungantaman ween e?” ");
INSERT INTO wim_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Puth than Pharisees anangan popam anman than-thanin, keꞌam wik thawin Jesus.antana, yaꞌa, puth thanan wik want-wanttak thawiythan nungant koyamaniy e? Aak anpalman ngulan-a, thananiya winynyang ngul moꞌ-moꞌin Jesus.antamana, thananiya keꞌ-ngul wikak thakan engkin nungant, yaꞌ anman. ");
INSERT INTO wim_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Aꞌ nil Jesus.an thaw pam wanchantan putha ngurp nungantam al-alantan, ");
INSERT INTO wim_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Than pam Pharisees anangana putha pam teachers wik thayan anangan thaaꞌ-aath-aathantanan-a, — work thantaniy-a, wik engkanangan waaꞌ-waaꞌayn, wik thayan Moses.antam anangana. ");
INSERT INTO wim_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Wik ngeen nathanwey thawayn niiyantan-a, niiyaniya ngeeyān thanang puth niiyaniya keꞌ yumpān keꞌ thanan woyan wayan wak-wakantan, way thakan yump-yumpantan, puth thananiya keꞌam wik thayan thanttamaniya ngeey-ngeeyantan, yaꞌa, an than wik thayanan pip-pipantan. ");
INSERT INTO wim_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","An keꞌ than yuk anhan kath-kathantana pam wanch wiyantangan, pikpungkangan wunp-wunpantan thanta, thananiy puth purꞌ-purꞌ iiy-iiyantan ngula, aꞌ than pam Pharisees weeꞌanangana kaangk keꞌ maꞌ-aathayn thananganweya, thanan kaangk keꞌ way min wiy anangan maayayn thanttaman. ");
INSERT INTO wim_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Puth thananiya kaangk pam wanch wiyangana thanang anman thath-thathayna, aꞌ ngaantam-ngeeyayn thanang than keꞌ pam min yimanangana, puth yaꞌa, than min yaꞌa. Thananiya wik God.antaman lat piꞌanang umpantan aꞌ yuk box manyang thenchantan ngul, aꞌ kuuyang kathantan, box manyana, aꞌ ngul-ngangkang thanttamangan kathantan ngul, puth maꞌ punthang thakan, than yipam pam wanch wiyangan thath-thathayn thananga. Aꞌ putha ngook min ongk thamp ngoonchantan, fringe thampweya, yipam pam wanch yotangana thathayn thanang. ");
INSERT INTO wim_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","“Than may piꞌanakan iiyayn-a, thanan kaangk aak min-minangam nyiinayna. Aꞌ putha, than churchakan iiyayn-a, thanan kaangk umputh anman nyiin-nyiinayna, than yipam pam wanchangan thathayn thananga. ");
INSERT INTO wim_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Putha thanan kaangka pam wanch anangan umang iiyayn thant aak town wakanana, keꞌ pam wuut piꞌ-piꞌanam yimanangan umang iiyayn thant, aꞌ putha thana kaangka pam wanchangan teacher waaꞌayn thananga. ");
INSERT INTO wim_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Puth niiya wiyantan keꞌ thawān thant teacheran waaꞌayn niiyanga, niiy puth maꞌmangkamana karpama iiy-iiyaniy pich-pichama keꞌ niiy kuunch yimanangana; niiyaniya teacher thonam anman niiyant. ");
INSERT INTO wim_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Puth niiyiya pam wiy anangana piip keꞌ waaꞌān thananga, niiyantaniya piip thonam anman, in kenyan wun-wunana. ");
INSERT INTO wim_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Aꞌ putha pam wanch wiyangana keꞌ waaꞌayn niiyang moomana, puth niiyantaniya moom thonam anman thonakama, ngay Christa. ");
INSERT INTO wim_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nil weeꞌ-nathweya kaangk keꞌ pam piꞌan yimanangan iiyow-a, yaa, nilaniy putha pam wanch wiy anangan maꞌ-aath-aathow thanangwey, minam piꞌ-piꞌow thananganiya. ");
INSERT INTO wim_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Nil weeꞌangweya pam piꞌan yumpiy nungamangan-a, ngul-ngulaniya nil pam many ngul weenowa. Nil weeꞌ-nathweya ulp-ulpanangan keꞌaman iiy-iiyan-a, pam nil mochanana, ngul-ngulaniya nil pam piꞌan paththam ngul iiy-iiyowa.” ");
INSERT INTO wim_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Anpalana, nil Jesus.an thaw thant ngul pam Pharisees al-alantana, puth-a, pam teachers al-alantan thanan wik thayanan thaaꞌ-aath-aathinana, “Niiy kan in ngeeyān a! way ngulan wampow niiyant a! Puth niiya muukamathaniy thanang pam wanch anangan a! Aꞌ niiya pam wanch anangana way-wayathaniy thanang than anangana kaangk maꞌ God.antangan iiyayna, puth niiy wik piip God.antamana way-way thaaꞌ-aath-aathaniy thananga. Aꞌ putha niiy thampaniya woyan min God.antaman keꞌam miꞌana, yaꞌa — an keꞌ niiya thaaꞌ door aawuchan ngathana, than yipam pam wanch wiy anangana keꞌ ngoonchayn aawuchangan, putha niiy thampaniya yoon angman than-thananiy a! ");
INSERT INTO wim_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“An kan-kanam paththam way ngul wampow niiyanta! Niiy puth pam wanch anangan muukamathaniy thananga. Aꞌ putha niiy aak palam-puyam iiy-iiyaniya, wiyiya thaꞌanga, putha wiyiya ngak wakana, niiy yipama wik min God.antaman waaꞌ-waaꞌān wiyantana, puth niiyiya way-way thaaꞌ-aath-aathaniy thanang niiy yipama woyan way aakanakana meeꞌ-wichān thanang keꞌ niiy anman wak-wakaniya. Nil pamang nathweya monkan-wakiy niiyang-a, yaa, an niiy way paththam yump-yumpaniy nunanga, keꞌ niiy yimanangan yaꞌa, niiyiya way chil-chil yump-yumpaniya, puth nil-niiyantan-a, an ep-paththama way-wayam paththam weenow ngula. Aak ngul-ngulan-a, niiy maꞌmangkam ngulan-a, aak way aakanakan iiy-iiyāna. ");
INSERT INTO wim_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","17","“Eeꞌa, an kan-kanam paththam way ngul wampow niiyanta! Niiyaniya way-way thaaꞌ-aath-aathaniy pam wanch anangan, niiy keꞌ pam koꞌanch yimanangana meeꞌ-wich-wichaniy thananga. Pam wanch wiy anangan wik thayanam thawantan, ‘Ngay kan-kanam thawāng nungka, piip in kenya, ngay ngul yumpānga, ngay keꞌ wik uuyaminga, yaꞌa.’ Wiyanganiya ‘piip in keny’ wichantan; wiyanganiya aawuch ngench thayan anan wichantan; puth wiyangan-a, yuk gold anangan wichantan aawuch ngench thayanangan wun-wuntana. Puth wiyanganiy-a, yuk altar anan wichantan aawuch ngench thayanangan than-thanan ana; puth wiyanganiya yuk way min aak yuk altarangan wun-wuntan-a, anangan wichantan. Yaa, niiyaniy thaw-thawaniy thanta, ‘Niiy nath namp aawuch ngenchan wichaniy-a, an kana, niiy mak wikan pipāna. Puth niiy namp yuk gold anangan wichaniy-a, niiy keꞌa wik niiyantaman pipāna, yaꞌa.’ Niiy kuchek waap wayanang iiy-iiyaniya! An keꞌ niiy pam meeꞌ koꞌanch yimanangan iiy-iiyaniya! Yuk gold anangan min paththam meeꞌ niiyantangan ey? ngul aawuch ngench thayana an wanttaka? Min yaꞌ ey? meeꞌ niiyantangan ey? Niiy in ngeeyāna: yuk gold anangan anman wun-wuntan aawuch ngench thayanangana nanpalan yuk gold ananganiy-a, an ngench ngula. ");
INSERT INTO wim_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","“Aꞌ niiy wik inangan thamp thawaniy, ‘Namp yuk altaran wichaniy-a, an kana, niiy mak wikan pipāna. Puth niiya namp yuk way min anangan wich-wichaniy yuk altarangan wun-wuntan-a, niiyana wik niiyantaman keꞌ pipān, yaꞌa.’ ");
INSERT INTO wim_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Niiy kuchek waap wayanang iiy-iiyaniya! An keꞌ niiy pam meeꞌ koꞌanch yimanangan iiy-iiyaniya! Yuk way min anangan aak altarangan wun-wuntan-a, an min paththam meeꞌ niiyantangan ey? yuk altaran ngul wanttaka? Min yaꞌ ey? meeꞌ niiyantangan ey? Niiy in ngeeyāna: yuk way min anman wun-wuntan, yuk altarang angmana nanpalan yuk way min ananganiy-a, an ngench ngula. ");
INSERT INTO wim_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Nil pamangweya namp yuk altaran wichiyan-a, aꞌ putha wik thayanan yumpiy-a, pam thonamantanwey-a, an keꞌ nil way min anangan namp wich-wichan thanang thampa, an puth aak angman wun-wuntan, yuk altarangan. ");
INSERT INTO wim_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Aꞌ puth-a, thon in thampa, nil pamangweya namp aawuch ngench thayanan wichiywey-a, aawuch piip God.antaman-a, an keꞌ nila namp piip God.antaman wichan thampa, nil puth piip God.ana aawuch angman wun-wunan. ");
INSERT INTO wim_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Aꞌ putha nil pamang nathweya namp aak in kenyan wichiywey-a, an keꞌ nil aak God.antaman wich-wichan thamp, aꞌ putha keꞌ nil namp God.antaman wich-wichan thamp, nil puth piip God.ana aak in kenyan wun-wunan. ");
INSERT INTO wim_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“An kan-kanam paththam way wampow niiyanta! Niiy puth pam wanch anangan muukamathaniy thananga. Niiy keꞌ-ngoongkam iiy-iiyaniy wik thayan God.antamakaniya wik min nungantam aakanakan, niiy puth minam keꞌ iiy-iiyaniy pam wanchantan, aꞌ puth niiy keꞌam ngangk mam-mamaniy thanangweya, aꞌ wiyiya niiy wukal thakan maꞌ-kuchathaniy thanttam. Niiy ep yuk way min theeꞌ-theeꞌaniy nungant piip God.antana, wukal wiy niiyantaman churchak kal-kalaniy aꞌ yuk awal min thakan theeꞌ-theeꞌaniy nungant. Niiy kanaka wukal thakan kal-kalaniy churchakana, puth niiyangana keꞌ kon-ngathow ngangk minangam iiy-iiyān pam wanchantaniya aꞌ piip God.ant thampa. ");
INSERT INTO wim_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Niiy keꞌ pam wanch meeꞌ koꞌanch yimanangan iiy-iiyaniya, pam wanch wiy anangan meeꞌ-wich-wichaniy thanang woyan wayakan. An keꞌ aak yimanangana: nil nyeeny nath may ngakangan keekiywey cup niiyantangan-a, an niiy nyeenyan maayaniy, niiy puth kaangk keꞌ may ngak nyeeny thampan mungkāna; puth niiyaniya camelana ep lokang thuꞌin ey? ");
INSERT INTO wim_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“An kan-kanam way paththam wampow niiyanta! Aak niiyant yimanangan wunana: niiyaniya yuk cups-a, plates anangan maꞌ-yotam pung-punganiy ey? aꞌ pach-pachathaniy ey? puth niiy ngangk niiyantaman pach keꞌam piꞌ-piꞌaniy yaꞌa, niiy puth pam yangk moꞌ-moꞌaniy, aꞌ pam wanch wiy anangana way-wayathaniy thanang, piik-piikaniy thanang thaka. ");
INSERT INTO wim_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","In ngeeyiya, an niiy yotamana an keꞌ niiy meeꞌ koꞌanch yimanangan iiy-iiyaniya. Niiy kaꞌathamana ngangk niiyantakaman pach-pachathāna puth anpalana niiyaniya minam ngul iiy-iiyāna. ");
INSERT INTO wim_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“An kan-kanam way paththam wampow niiyanta! Niiy puth pam wanch anangan muukamathaniy thananga! Niiyan keꞌ kunttow gravestone yimanangan iiy-iiyaniya, puth kunttowana ach-umpanang wunan grave kenyangkana, yipam yotangan thathayna, puth pek-pekamana pam mulantaman kaanch wun-wunana, puth kempana way ngul kanan kathama. ");
INSERT INTO wim_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Than wiyangan nath ngaantam-ngeeyantana niiy keꞌ pam wanch min iiy-iiyaniya, puth yaꞌa, ngangk niiyantamana way anman piꞌ-piꞌaniy, puth-a, wik uuy-uuyamaniy thampa.” ");
INSERT INTO wim_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Aꞌ nilana putham ngul thaw thant, “An kan-kanam way paththam wampow niiyanta! Aak keenkanama, wuut mangk niiyantam al-alangan kaangk keꞌ thanang pam prophets anangan, than mulathin thanang. Niiyaniya headstones yumpaniy thant pam prophets al-alantan, pam min al-alantan, aꞌ headstonesana ach-umpanak yumpaniy thant — an niiy yaan yumpaniy thant, yaan muukamaniy keꞌ niiy ngaantam-ngeeyaniy thanangweya, puth yaꞌa. ");
INSERT INTO wim_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Niiyaniy wik yimanangan thawaniya, ‘Ngamp nathwey wuut mangkantang keenkaman an-aniyangan wun-wunimpan thanttangan-a, ngampaniya pam prophets anangana keꞌ mulathimp thanangweya keꞌ thanan mulathin thanangweya.’ ");
INSERT INTO wim_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Yaa, niiyan puth wuut mangk anpalan wampana, pam al-alangana pam prophets anangan mulathin thanang, niiy kampan waaꞌaniy thanang! ");
INSERT INTO wim_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Yaa, niiy way anman yump-yumpaniy keꞌ wuut mangka kampan niiyantam al-alangan ey? Niiy ngulana work thanttaman minch-minchathān ngul ey? ");
INSERT INTO wim_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Niiy pam inanganiy yota, way-wayam paththam iiy-iiyaniy, keꞌ thuuk yimanangana thipangan thuuch-thuuchaniya. Ngul niiy ngaantam-ngeeyaniy ey? keꞌ nil piip God.angan keꞌ kuchiy niiyang ey? aak way aakanakan ey? Puth an yaꞌa! nil kuchow niiyang aak way aakanakan a! ");
INSERT INTO wim_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Puth ngay anpalan niiyant inan waaꞌānga; ngayiya pam prophets anangan ngul kuchāng niiyanta, aꞌ putha pam anangana kuchek waap min anangan iiy-iiyantana; putha pam teachers anangan wik min ngatharaman thaaꞌ-aath-aathayn niiyanga. Puungk wiyaniya, niiy ngul mulathān thanang; aꞌ puungk wiy anangan-a, yuk wuuyanangan waanchān thanangweya mul wunaynweya, aꞌ putha pam puungk wiy anangan-a, niiy piik-piikān thanang aak church niiyantamangana, aꞌ kenth-kenthān thanang ngula aak town amanamana aak thonak ngul iiyayn, nil yimanamanweya kenth-kenthān thanang, palam-puyam iiy-iiyayn aak thon-thonakana. ");
INSERT INTO wim_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","“Aak keenkanamana, wuut mangk niiyantamang pam min anangan mulathin thanang. Kaꞌathamana than pam min Abel anan mulathin nunang. Anpalana than pam God.antam yot anangan mul-mulathin thanang aak-aakanakaman nil Zechariah.an ngul wuna, pam inman nhengk Berechiah.antam. Aꞌ than nunang thamp mulathin, aawuch ngench thayanang angman mulathin nunang, yuk altar thinth minhan kiingk-kiingkin, piip God.antana. ");
INSERT INTO wim_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Puth nil God.anganiya ngul wayathow niiyang pam wanch niiy inangan man-yethaman iiy-iiyaniya, puth wuut mangk niiyantamanga pam God.antam anangan mul-mulathin thanangweya.” ");
INSERT INTO wim_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Amanamana, nil Jesus.angan ngaantam-ngeey thanang pam wanch yot anangan aak Jerusalem.angan wun-wunina, aꞌ nil ngangk way-wayam paththam wun thanttamana aꞌ thaw ngul, “Niiy pam yotam anangan kanam mul-mulathan thanang nil God.angan kuch-kuch niiyanta. Niiyiya kunttowang thak piik-piikan thanang mulakama. Ngay maꞌ-yotam keꞌ maꞌ-yalmathing niiyang ngatharakama, keꞌ minh chookie kaath-kunch alangan maꞌ-yalmathan puk manyiy nungantam anangan aꞌ pek-pekam punth-paamang ngul kang-kangan thanang ngula. Puth niiyiya kaangk keꞌ ngatharama. ");
INSERT INTO wim_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Niiy in ngeeyiya, nil God.angan aak ngench thayan niiyantaman keꞌ-ngul minam piꞌ-piꞌow, an too wantow ngul, keꞌ aak mook yimanangan wunow pam wanch keꞌ-ngul ngoonch-ngoonchayna. ");
INSERT INTO wim_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Puth ngay thampaniya wantāng niiyang ngula, niiy keꞌ-ngul thathān ngayang aak ingana yaꞌa. Ngul-ngulana an ep niiy thathān ngayangweya, amanamana niiy meeꞌmiy ngul weenān pam ngay inmana nil God.angan kuchanya, an puth niiyan thawān ngul, ‘Yaa, ngamp thaaꞌ-kuumpāmp nunang pam inana nil God.angan kuch nunanga.’” ");
INSERT INTO wim_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Anpalana, nil Jesus.angan aawuch ngench thayanan want ngul. Nil kan-ngul iiy-iiy-a, aꞌ ngurp nungantam anangan wampin ngul nungantana aꞌ thawin nungant aawuch ngench thayanan thath-thathow puth aak anan ach-umpan. ");
INSERT INTO wim_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Nil Jesus.an thaw thant, “Eeꞌa, niiy aawuch inanganiya minam thath-thathānweya. Aak ngul-ngulana than pamangan aawuch min-minam anangana ngul wayathayn, aꞌ puth kunttow wuut piꞌ-piꞌanam anangana aakang ngul keek-keekathayna.” ");
INSERT INTO wim_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Aꞌ amanamana, nil Jesus.an aak achantangak ngul iiy, aak namp alantaniya yoyk Olives, aꞌ angman ngul nyiin-nyiin. Aꞌ than ngurp nungantam anangan wampin nungant, thananiya pokkapang ngul thaw-thawin nungantana, “Ayyang, than ngul aawuch ngench thayanan aak ngeen ngul keekathayn e? Nil puth God.angan ngeen meenathow nganta aakaniy-a, thinth ngul wampan nint putham palaman ngul wampānan aꞌ puth aak inan minchowana?” ");
INSERT INTO wim_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Nil puth Jesus.an thaw thant, “Niiy meeꞌ yanth-yanth ngul iiyāna! Than pam wanch wiyangan keꞌ yipam muukamathayn niiyanga! ");
INSERT INTO wim_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Than yot thon-thonam ngul wamp-wampayna, thananiya yaan wik uuy-uuyamayn, muukamayn waaꞌ-waaꞌayn thanttakama, than keꞌ ngay yimanangana, yimanangan thawayn, ‘Ngay pam inan God.angan keenkanam kaaꞌngak kuchowana.’ An yaꞌa. Pam wanchang yotanganiya ep wik ngeeyayn thananga. Puth puungk wiyanganiya ep-paththam, an yaꞌa, keꞌ ngeeyiythan thananganiya, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Niiy wik wolmp ngul ngeeyān kul karkanan pekwayn niiyantang thinth, aꞌ niiyiya wik thooꞌ ngul ngeeyān aak nath-nathan pekwayna. Puth niiyana keꞌ winynyang moꞌāna. Nungkway than nath kul piꞌanan pek-pekwiythan-a, aakan keꞌ yippak minchowa. ");
INSERT INTO wim_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Than moom piꞌan aꞌ pam thanttam aak thon-thonaman anman pek-pekwayna; than pam wiy anangana thaaꞌnganth thon al-alantan ngul iiyayn, aꞌ thananiy pek-pekwayn. Aꞌ yuk earthquake al-alangan aak thonang nath-nathan wuny-wunyathowa. Aꞌ putha aak umyompanamana may keꞌanang thak wun-wunayna. ");
INSERT INTO wim_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","An puth wayan chil-chil yippaka, puth ngul-ngulana anan epa way piꞌan paththam wampow. Aak inana aak yimanangan wunow keꞌ wanchang pukan uwow yimanangana. Kaꞌathamana nila many-many uwana iimpan pek-pekan nunang, amanamana aniya wuut piꞌanang ngul uwan nunang pukan kalowa. Aakana yimanangan wunow.” ");
INSERT INTO wim_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Nil puth Jesus.angan wik thayanath thanang, nilan thaw ngurp nungantam al-alantan, “Anpalaniya, thanan mamayn niiyang aꞌ maꞌam theeꞌayn niiyang pam piꞌ-piꞌanam al-alantan than yipam piik-piikayn niiyang aꞌ mulathayn niiyang. Pam wanch yotangan ngangk-wayangam kal-kalayn niiyang thampa, anpalmana niiya ngayangan monkan-wak-wakaniya. ");
INSERT INTO wim_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Aak an-aniyangan-a, pam wanch yotangan wantayn ngayanga; thananiy-a, theetathwayn than-thanttakamaniya pam wayanang al-alantan aꞌ ngangk-wayangam kal-kalwayn thanttakamana. ");
INSERT INTO wim_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Aꞌ pam yot anangan wampayn ngul, aꞌ muukamathwayn ngul keꞌ than pam God.antama, puth yaꞌa, than puth wik wiy-wiyam waaꞌ-waaꞌayn niiyantana, wik God.antamana an yaꞌa, aꞌ pam wanch yotangan-a, wik way thanttaman ngul ngeeyayn. ");
INSERT INTO wim_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Aak an-aniyangan-a, pam wanch yot anangana an puy-puyam way-wayam paththam ngul iiy-iiyayna, aꞌ puth nanpalana pam wanch ngatharam yot ananganiy-a, keꞌ-ngul ngangk minangaman iiy-iiyayn thanttakamana, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Nil weeꞌanganweya keꞌ-ngoongkam anman monkanan wak-wakow ngayang anman-a, keꞌan eenchow ngatharaman-a, nilaniya ngangk aak umpuyangam wun-wunow piip God.antanga. ");
INSERT INTO wim_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Aꞌ anpalana, pam wanchangan wik min God.antaman waaꞌ-waaꞌayn thant pam wanch al-alantan aak umyompanaman, nath-nathan wun-wuntan, than waaꞌayn thant nil God.an moom piꞌan paththam iiy-iiyan, aꞌ anpalaniya aak inan minchow ngul, yaꞌ-ngul wunow.” ");
INSERT INTO wim_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Nil Jesus.an wik inangan thamp thaw thant, “In ngeeyiya! Ngulana, pam thonamana, way-wayam paththam wampow, aakan wakowa, keꞌ nil pam piꞌan prophet Daniel.angan keenkanaman waaꞌa. Nil pam way alangan-a, yuk way thanathow aak ngenchangana. Niiy min-minam ngaantam-ngeey-ngeeyān wik anangan ngayan waaꞌ-waaꞌangan niiyant. ");
INSERT INTO wim_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Aak inan wampowan-a, niiy aak Judea punchan nanangan-a, nath moꞌān aak yoykaka. ");
INSERT INTO wim_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Niiywey aawuch yoonan nyiin-nyiininwey-a, niiyan putha koyamana pek keꞌ ngoonchān aawuch niiyantamangan, way minan keꞌ maayān thanang — puth niiyana puy-puy ngeetān paththam yoykakana. ");
INSERT INTO wim_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Niiy nathwey aak kangkangan wuninwey-a, niiy aawuchangana koyam keꞌ ngoonchān way min niiyantamakan maayānana, an yaꞌa, too wantān. ");
INSERT INTO wim_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Aak inan ngulan wampow-a, an aak way paththam wun-wunow thant wanch iimpanang al-alantana aꞌ putha wanch pul-many al-alantan maꞌ puk manyangana. ");
INSERT INTO wim_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Niiy meeꞌ-wuthanamān piip God.anta aak inana aak kucharan keꞌ yipam wampowa, puth an min niiyant yaꞌa niiy puy aak thonak moꞌ-moꞌān aak kucharamana. Aꞌ meeꞌ-wuthanamān nungant piip ilant kenyana aak inana aak Saturday.an keꞌ yipam wampowa, ");
INSERT INTO wim_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","an puth aak way-wayam paththam ngul wampowa. Aak keenkanam nathpalman nil God.angan aak inan yump-a, aꞌ aak in-inman ngula, aak kaꞌathaman yimanang keꞌam wamp way-wayam paththamana. Ngul-ngulaniy-a, aak wayan kan-ngulan minchow-a, aak wayan chil-chil ngul wampow. ");
INSERT INTO wim_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Aak wayan wampow-a, an yaamana keꞌ wunow, an erkam ngul minchow aꞌ amanamana nil piip God.angan keꞌ-ngul wayaniy kuch-kuchow, aakan minam ngul wunow. Puth aak yaamwey wayan than-thaniy-a, an puth pam wanch maꞌmangkaman uthamiythan. Nil God.angan ngaantam-ngeey pam wanch nungantam anangan nilan miꞌ thanang, puth anpalana nilan ngaantam-ngeey aak wayan yaam keꞌ wuniy. ");
INSERT INTO wim_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Than pam wanch nath thawiythan niiyant, ‘Niiyalang, pam nilan nanana God.angan kaaꞌngakan ngamparan kuchowana!’ Nath thawiythana, ‘Ayyang, nil anana!’ — puth niiyana keꞌ wik ngeeyān thanttaman. ");
INSERT INTO wim_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Puth pam wiy anangana wampayn aꞌ waaꞌayn thanttakaman than keꞌ pam anan nil God.angan kuchan, wiyangiya keꞌ pam prophets anangan waaꞌwayn thanttakam, puth yaꞌa, than yaan muukamathayn niiyang. Thanan work piꞌ-piꞌanaman ngul yumpayn thanan yipam yaan muukamathayn pam wanch God.antam anangan. ");
INSERT INTO wim_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Niiy wik ngatharaman ngeeyāna! Ngay wik inangan ump-umputh waaꞌ-waaꞌang niiyant, niiyan yipam meeꞌmiy iiy-iiyān ngula. ");
INSERT INTO wim_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Than pam wanch nath thawiythan niiyanta, ‘Niiy kan an thathān nunangweya! Nil puya! aak pintalangan iiy-iiyana!’ puth niiyana aak pintalakana keꞌ iiyānweya. Than nath thawiythan niiyant, ‘Niiy kan in thathiya! Nil aak inan wuthanang ngoonch-ngoonchana.’ Puth niiyana keꞌ wik ngeeyān thanttamana, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ngaya, pam inan nil God.angan kuch ngayang-a, ngay palam erkam ngul wampāng. Ngay erkam keꞌ ngaay yimanangan palaman wampāng aꞌ yuw aak umyompanaman parkow, aak kaaw anpalan-aa, aak kuuw aakanakamana. Pam wanch yotamangan aak umyompanamangan meeꞌ thanttamangan thathayna.” ");
INSERT INTO wim_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Nil puth Jesus.an thaw thant, “Niiy waath anangan thathaniy thanang aak thonamangan yal-yalmathwuntan-a, yaa, niiyan kan meeꞌmiya minh uthama, aakanakan yal-yalmathwuntan. Yaa, niiy yimanangana ngul thiichāna ngay aak ngeen nathan wampāngana pam wanch ngulan than-thanathāng thanang um ngatharangana.” ");
INSERT INTO wim_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Nil Jesus.an wik inangan thamp thaw thant, “Ngul-ngulana aak wayan keꞌ-ngul wun-wunow, yaꞌ-ngul, anpalana, kinchan ngotan ngul wunow, aꞌ putha kepana keꞌ-ngul park-parkow aak ngutangana, an yaꞌ-ngul, thunp anangana keekayn ngul aak anpal kenyan, aꞌ kinch-a, kep-a, aꞌ puth-a, thunp anangan pal-puyan wunayna. ");
INSERT INTO wim_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Than pam wanchangan ngeen nath yaakaꞌ thathayn yuwangan wunow ang kenyana, aꞌ thanana ngul ngaantam-ngeeyayna ngay keꞌ kan-kanang ngul wampānga aꞌ anpalana than ngul thathayn ngayang pal uk-ukāng yuwangana, ngay pam inman God.angan kuchanya. Ngay pam piꞌan thayan paththam ukānga, pam min-minam paththama! Than pam wanch aak umyompanamana thaniya thath-thathayn ngayangan-a, an than peey-peeyayna. ");
INSERT INTO wim_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Nil ngaantiyongk ngatharam alangana trumpet piꞌan ngul wuuꞌ-wuuꞌowa pal-puyana, aꞌ anpalana ngayana kuchāng thanang nath-nathan iiy-iiyayn, kungkam-a, yiipam-a, kaawam-a, aꞌ kuuwam iiyayn, aꞌ thananiya pam wanch God.antam anangan yal-yalmathayn thanang nilan miꞌ thanang, aak thon-thon nath-nathpalan yal-yalmathayn thanang pam wanch anangan.” ");
INSERT INTO wim_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Aꞌ nil Jesus.angan wik kath ngul waaꞌ thant, “Niiy ngaantam-ngeeyāna yuk kom anangan. Yiikanan pentantan kangk nyiingkanaman-a, aniya, niiy meeꞌmiy aak kayamanana kan-kanang wampan. ");
INSERT INTO wim_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Aꞌ niiyana kinch ngulan thath-thathānana ngaaꞌan wunow-a, putha thunp anangan keekayn thakan-a, yaa, niiyana meeꞌmiy weenān aakan thinth ngul kan wampan ngathar ngay palaman wampānga. ");
INSERT INTO wim_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Aꞌ niiy inan thamp ngaantam-ngeeyāna: aak anan wampowan-a, puungk wiy inangan niiya man-yetham yippak iiy-iiyānweya. ");
INSERT INTO wim_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ngul-ngulana aak earth inana putha yuw in kenyan thathanamp an ngul minchowa. Puth wik ngatharamana an keꞌ minchiya, yaꞌa, an anman wun-wunow aak umpuyangama. ");
INSERT INTO wim_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Pam wanch maꞌmangkamana an than keꞌ meeꞌmiy yaꞌa, aak ngeen nathan ngay palaman wampāngana. Ngaantiyongk aak in kenyan wun-wuntan-a, than thamp keꞌ meeꞌmiyweya yaꞌa, aak ngeen nathana, ngay thampana keꞌ meeꞌmiya yaꞌa. Nilam anman thonakam epa piip God.an meeꞌmiya. ");
INSERT INTO wim_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ngay ngulan puthaman palaman wampāngan-a, pam ngay inman nil God.angan kuch ngayang-a, aniy-a, keꞌ keenkanamana aak an-aniyangan nil Noah.an wun-wun-a, aakan yimanangan wunow. Than pam wanch anangan keꞌ-ngoongkam anman iiy-iiyin, keꞌam wik ngeey-ngeeyin yaꞌa, aakan-a, yimanangan wunowana. ");
INSERT INTO wim_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Than yotamangan may yot mungk-mungkin, than ngent-ngentwin thakan, nil yimanaman, aak-aakanakaman Noah weeꞌanangan pek ngulan ngoonchin chukkun wuut piꞌanangana. ");
INSERT INTO wim_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Than keꞌ-ngoongkam anman iiy-iiyin, keꞌam ngaantam-ngeeyin ngeenan wamp-wamp thantana, aꞌ ngak kaap wuut piꞌan paththam wamp thant, aakan luuꞌ pip, ngakanganiya aak umyompanamana. Aꞌ pam-a, wanch-a, puk manyiy maꞌmangkaman keꞌ wook thechath thanang ngak wuut piꞌan alangan, thananiya uthamin ngul ngakang angmanwey. Ngay puthaman palaman wampāngan-a, ngaya pam inman God.angan kuchany-a, aakan yimanangan wunowa. ");
INSERT INTO wim_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Aak an-aniyangan-a, pul pam kucham nath workan karpam iiy-iiyiypul aak paddockanganweya. Nil piip God.angana pam thonam kaliy nunanga, aꞌ nil pam thonaniya angman wantiy nunang. ");
INSERT INTO wim_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Aꞌ wanch kuchamwey nath work karpam iiy-iiyiypul may kaanch anangan nhanth-nhanthathiypul. Nil piip God.angana wanch thonam kaliy nunang, aꞌ an nil wanch thonaniya angman wantiy nunang. ");
INSERT INTO wim_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Yaa, niiyaniya minam anman woyan God.antaman wak-wakāna, niiy keꞌa melan enchāna woyan min anpalana, yaꞌa. Puth niiyaniya keꞌ meeꞌmiyweya yaꞌa aak ngeen nathan ngay Lord niiyantaman palaman wampānga. ");
INSERT INTO wim_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Niiy inan ngaantam-ngeeyāna, niiy nath meeꞌmiyweya aak ngeen nathan paman aawuch niiyantamangan ngoonchiyan-a, way min niiyantaman maꞌ-kuchathiya aawuch niiyantam nanpalan-a, yaa, niiyaniya keꞌ weep wunina, yaꞌa, an meeꞌ pench-penchin anmana aakam paanthiy niiyantana, aꞌ min-min piꞌ-piꞌin way min niiyantamana. ");
INSERT INTO wim_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Puth niiyiya keꞌ meeꞌmiya yaꞌa aak ngeen nathana ngay putham palaman wampāng aak iikanakana, ngay pam inman nil God.angan kuchanya. Niiyiya keꞌ-ngoongkam anman murkanam kuup-kuupān ngathara, maꞌ-min-yumpwuna, ngay ngul maꞌ-pil-wayathing niiyanga.” ");
INSERT INTO wim_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Anpalana, nil Jesus.angana wik kath inan ngul waaꞌ thant, “Ngay wik katha waaꞌāng niiyant pam thonam alantaman workan iiy-iiya moom nungantamakan. Nil pam min paththama, work min iiy-iiy, keꞌam nyiin-nyiin thak. Anpalana, nil moom alangana aak nungantamana kan-ngul wantow, aꞌ nil pam thonam alantan thaw workan iiy-iiy nungantanweya, ‘Ngay kan iiyānga, nintana keꞌ moom piꞌan thanttam yimanangan iiy-iiyān koy-koyyuw ngulana pam wiy al-alantan workan iiy-iiyantana. Ngay iiyāng ngulan-a, nint may aath-aathān thananga, puth minam piꞌ-piꞌān thanangweya.’ ");
INSERT INTO wim_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","47","Aꞌ nil moom piꞌan palam ngul wampiyan-a, nil nathwey paman thathiy nunang work minam anman iiy-iiyan-a, yaa, nil thawiy pam alantan nil aakan piꞌ-piꞌ nungantana, ‘Yaa, nint work minam anman iiy-iiyana ngay nathan iiy-iiyangana. Aak imanam ngulan-a, nintaniya moom piꞌan ngul iiy-iiyāna way min yotam ngatharam inangana maꞌ nungkarang ngul piꞌ-piꞌān thanang.’ Nil pam anan workan iiy-iiy nungantan-a, an nil ngangk min paththam ngul wuniyant. ");
INSERT INTO wim_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","“Nil paman nath min yaꞌ-a, nil nath eenchiy ngulan-a, nil work minan keꞌ-ngulan iiy-iiyiy, yaꞌa, puth nil yaaman keꞌ kuup-kuupiy moom nungantam alantana, nil nath thawiy nungantakamana, ‘Nil moom ngatharamana nath yaam nathaman wun-wunowa.’ ");
INSERT INTO wim_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Yaa, pam alangaman natha pam wanch wiy anangan workan iiy-iiyantan-a, piik-piikiy thanang ngula, aꞌ puth nilan natha kan-ngul may yotam anangan nilam ngul mungk-mungkiya, puth ngak way wine anangan thamp mungk-mungkiy, ngul pam wiy al-alantangan than ngak-mungkanang al-alantanganweya. ");
INSERT INTO wim_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Anpalana, moom piꞌan nungantaman nath palaman wampiyan-a, maꞌ-pil-wayathiy nunang-a, ");
INSERT INTO wim_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","an nil whipangam piik-piikiy nunangana, pamana, aꞌ kuchow nunang ngul aak nungantam anpalana, aak way aakanakan kuchow nunang. Nil pam wanch way paththam al-alantangan ngul wun-wunow than wikan uuy-uuyamantan thakana. Aak angman-a, nil wik peey-peeyow aꞌ koonhan path-pathow nungantakamanweya.” ");
INSERT INTO wim_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Aꞌ anpalan-a, nil Jesus.angan wik kath thon inan waaꞌ thant. Nilaniy thaw thanta, “Niiyalang! Niiy kan in ngeeyiya: aakan kan-kanang wamp-wampana, nil God.angan pam wanch yotamana maꞌ nungantang ngulan piꞌ-piꞌow thananga. Aniy keꞌ wik kathana yimanangana. Nil pamangan wanch thum keꞌ ngul ngentiya. Than pam wanch wiyangan may thakan kanam kiingkin pulanta. Than puk kom-koman ten ananganiya iiyin may piꞌanakana, aꞌ thanan yoon angman kuup-kuupin nungant pam alantan wanchan maayow. ");
INSERT INTO wim_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Than kom-koman five anangana kuchek waap minangam keꞌam iiy-iiyin, yaꞌa. Than kom-koman five wiy anangan ep-paththam kon-enchiy iiy-iiyin. ");
INSERT INTO wim_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Than kom-koman wayanang al-alangan lanterns thanttaman kalin puth than kerosine.ana wiy thamana keꞌam kalin, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Than kom-koman min-miniy al-alangan ep-paththam kerosine kalin lanterns thanttamakana. ");
INSERT INTO wim_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Nil pam komp wanchan ngentowan-a, yaam yippak nath-nathama, puth than kom-koman anangana meeꞌ weep ngul nyiin-nyiinina, aꞌ weep paththam ngul wunin. ");
INSERT INTO wim_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Ngul-ngulana, aak ngaaꞌ-menhangan-a, than pam wanchana kan-ngul paththam wik wolmp ngul piꞌ-piꞌin, pech-pechina, ‘Nil inam a! Nil pam kompana inam wampana! Ngamp umang uwāmp nunanga!’ ");
INSERT INTO wim_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Than kom-koman ten anangana, kan-ngul weepaman ek-ekin, aꞌ lanterns thanttamana min-min pachathin ngul. ");
INSERT INTO wim_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Anpalaniya than kom-koman kuchek waap keꞌanangana thawin ngul thant kom-koman min kon-enchiy al-alantana, ‘Ayyang, niiyalang! Niiy ngant kerosine manyam yaan theeꞌāna, an puth ngul-ngulana lanterns nganttamana uthamayna!’ ");
INSERT INTO wim_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Than kom-koman min anangan thawin thanta, ‘Yaꞌa, ngan kerosine many nganttakam thonakam kalana. Puth lanterns nganttam inangan yaam keꞌanam eꞌa ngul wunina. Niiy store.ak iiyāna aꞌ anpalan wukalang piiyān niiyantakama.’ ");
INSERT INTO wim_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Aꞌ than kom-koman kuchek waap keꞌanang anangana iiyin ngul kerosine.an yipam piiyayn; than kan-ngulan iiyin-a, nil pam anan wanchan ngentowan-a, kul-kulam wamp thant. Than kom-koman kuchek min anangan five kuup-kuupin pam alantakamana, thananiy-a, pek ngoonchin nungantang ngul may piꞌanakana. Aꞌ anpalana, nil pam wanchan ngentow alangana, thaaꞌan kan-ngul ngatha. ");
INSERT INTO wim_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Ngul-ngulaniya, than kom-koman wiy anangan palam kan-ngul wampin. Thanan puth yaꞌangam pech-pechina, ‘Moom-ang! Moom-ang! Nganang puy kan ngoonchath ee!’ ");
INSERT INTO wim_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Puth nil paman thaw thant, ‘Yaꞌa, ngay keꞌ thaaꞌ thaꞌinga, ngay keꞌ meeꞌmiy niiyanga, yaꞌa.’” ");
INSERT INTO wim_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ngul anpalana, nil Jesus.an thaw thant, “Niiyan aak thath-thathān ngathar yimananga, puth niiyana keꞌ meeꞌmiya yaꞌa ngay palaman aak ngeen nathan wampānga.” ");
INSERT INTO wim_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Anpalana, nil Jesus.angan wik kath thonangan ngul waaꞌ thant, “Aakan ngul wampow nil God.angan pam wanch yotam maꞌ nungantang ngulan piꞌ-piꞌow thananga, inaniy wik katha keꞌ yimanangan aakan wunow. Aak keenkanamana, nil pam piꞌanan yaan iiyowweya aak thonakana. Nil kan-ngul iiyowan-a, nil pam workan iiy-iiyin nungant-a, ump thanang aꞌ aak nungantamana aꞌ puth-a, yuk way min nungantam anangana maꞌ thanttang pam al-alantangan wantow. ");
INSERT INTO wim_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Nil pam al-alantan wukal theeꞌ-theeꞌ thant thanan yipam yuk way min anangan piiyayn, aꞌ sellimpungayn ngul, aꞌ thanana wukal piꞌan yipam yumpayn nungant moom alantan. Puth nilana pam workan iiy-iiyin nunganta wiy anangan thanang meeꞌmiy kuchek waap min iiy-iiyina, than wiy anangan yaꞌa. Nil pam moom alangan pam thonamantana five thousand dollars theeꞌa — nil pam thon alantana, kuchek waap chil piꞌan alantana, two thousand dollars theeꞌa, aꞌ pam thon alantan kuchek waap many alantana one thousand dollars theeꞌa. Anpalana nil pamana kan-ngul moꞌ. ");
INSERT INTO wim_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“Nil pam anan five thousand dollars thampana, nilan erkam paththam iiy aꞌ way min min-miniy piiy-piiy aꞌ sellimpung-pung thant wiyantan. Aꞌ nilan yuk way min anangan sellimpung-pung-a, an nilaniya ten thousand dollars ngul yump. ");
INSERT INTO wim_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Nil pam anan yimanangweya two thousand dollars thampana, nil erkam iiy aꞌ yuk way min piiy-piiy aꞌ sellimpung-pung thant pam wiyantan, aꞌ nil pam ilanganiy-a, wukal four thousand dollars ngul yumpa. ");
INSERT INTO wim_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Puth nil pam anan wukal one thousand dollars uw-a, nil iiy aꞌ awar weꞌ aakangan, aꞌ wukal moom nungantam alantamana awarang kaampa. ");
INSERT INTO wim_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Anpalana, nil moom thanttaman kan-ngul wamp. Aꞌ nil pam anangan workan iiy-iiyin nungantana ump thanang, nilan yipam wik ngeeyow thanttam, than wukal ngeen-ngeenan yumpin nungantana. ");
INSERT INTO wim_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Nil pam anana wukal five thousand dollarsan uw-a, kan-ngul wamp aꞌ wukal ten thousand dollarsan theeꞌant pam moom alantan. Nilan thaw moom alantan, ‘Ayyang! moom-ang! Nintan wukal theeꞌan ngathara, five thousand dollarsana. Aꞌ inan thath a! Five thousand dollars thonangan ngul inan uwangan nungkar.’ ");
INSERT INTO wim_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Nil puth mooman thaw nungant, ‘Nint ep pam mina, nint work minam paththam iiy-iiyana. Ngayan puth wukal many theeꞌang nungkweya. Nint puth minam workan iiy-iiyana, aꞌ puth wukal piꞌan yumpana. Puth nanpalana, ngayaniya, work piꞌan ngul theeꞌāng nungkara. Nint pal iiya, aꞌ ingan nyiinān ngatharang, keꞌ ngurp ngatharam yimanangana.’ ");
INSERT INTO wim_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Anpalana nil pam anan two thousand dollarsan uw-a, nil ngul wamp aꞌ thawant, ‘Ayyang, moom-ang, nintan theeꞌan ngath two thousand dollarsana. Aꞌ inan thath a! Two thousand dollars thonangan ngula inan uwangan nungkara.’ ");
INSERT INTO wim_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Nil puth mooman thaw nungant, ‘Yaa.wey, an min paththama, nint puth work minam iiy-iiyana. Ngayan puth wukal many theeꞌang nungkweya, nint puth work minam iiy-iiyana, aꞌ putha wukal piꞌan yumpan thampa. Puth anpalana, ngay work piꞌan theeꞌāng nungkara. Nint pal iiya, aꞌ ngatharang ing nyiināna keꞌ ngurp ngatharam yimanangana.’ ");
INSERT INTO wim_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Anpalana, nil pam anan one thousand dollarsan uw-a, nil ngul ngoonch aꞌ thaw, ‘Ayyang, moom-ang, ngay meeꞌmiy nintang pam way thayaniy paththam iiy-iiyangana, aꞌ putha nintaniya wukal piꞌan ep nungkarakaman uwangan pam wiyantaman thanan work iiy-iiyantana. ");
INSERT INTO wim_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ngayan puth nungkaram winynyang moꞌangana, aꞌ puth wukalan kalangan aꞌ awarang kaampangana. Inan thatha! Wukal nungkaram inana ngayan kaampang awarangan.’ ");
INSERT INTO wim_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Nil puth pam mooman thawant, ‘Nint pam ngangk way paththam iiy-iiyangana! Nintan puth kan thiichana ngayan wukal piꞌanan uw-uwang thanttamana ngatharakamana than pam wiy al-alantaman workan iiy-iiyantana. Nint puth ngeenam wukal ngatharaman awarangan thenchan e? ");
INSERT INTO wim_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Nint wukal bankang wunpina. Nint bankang yaanwey wantin-a, yaam yipam wun-wuniya, nil pam alangana bankan piꞌ-piꞌan-a, wukal one thousand dollarsana aꞌ putha wukal wiy thampan theeꞌiy nungkar ngulweya.’ ");
INSERT INTO wim_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Yaa, pam moom anan thaw pam wiy al-alantan workan iiy-iiyin nungantana, ‘Niiy wukalan maayān nungantamana aꞌ pam alantan theeꞌān ten thousand dollarsan piꞌ-piꞌana. ");
INSERT INTO wim_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Nil pamwey work minam iiy-iiyiywey-a, yaa, ngayan work piꞌan paththam theeꞌāng nunganta. Nil pamweya work minam keꞌan iiy-iiyiywey-a, ngayan puth work keꞌ-ngul theeꞌinganta, yaꞌa. Work nungantaman-a, ngay pam thonant ngul theeꞌānga. ");
INSERT INTO wim_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Niiy puth pam way paththam inana puy yoon kalān nunang aꞌ aak ngaaꞌang puy theeꞌān nunanga, nil yipam angan peey-peeyowa aꞌ putha koonh path-pathow nungantakamana.’” ");
INSERT INTO wim_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Aꞌ anpalana, nil Jesus.an thaw, “Aak ngul-ngulana, ngaya, pam inana nil God.angan kuchanya, ngay palam ngul wampānga, aꞌ ngaantiyongk tham anangan wampathāng thanang. Ngayan moom piꞌan paththam palaman wampāng ");
INSERT INTO wim_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","aꞌ ngay pam wanch thaaꞌ-wantanam anangana um ngatharang thanathāng thanang. Than pam wanch aak nath-nathpalana um ngatharang angman yal-yalmathwayn. Anpalana, ngay meen-umpāng thanang aꞌ aak pok-pokkapang ngul wunp-wunpāng thananga keꞌ shepherdang yimanangan minh sheep anangan meen-umpan thanang minh goats al-alantamana, ");
INSERT INTO wim_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","keꞌ sheep anangana nil maꞌ malangan wunpan thanang, aꞌ goats anangan maꞌ thakangan wunpan thanang. ");
INSERT INTO wim_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Ngul anpalana, ngay pam wanch maꞌ malangan than-thantana thawāng thant, ‘Awey! Niiy pal iiyāna! Nil piip ngatharamanga ngangk min yumpan niiyanga. Aak keenkanamana, nil aak inan yump-a, nil God.angana wik yump nilaman maꞌ nungantangan piꞌ-piꞌow niiyanga aꞌ puth-a, aak nungantamak kalow niiyangana. Puth inpal ngulana, niiyan maꞌ nungantang ngul wun-wunāna. ");
INSERT INTO wim_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ngay meechan wun-wunangan-a, niiy may theeꞌ-theeꞌan ngathara: ngay ngakaman uth-uthamang-a, niiyana ngak uw-uwan ngathar; ngay aak kechaman wamp-wampangan-a, niiy aak niiyantamak kal-kalan ngayang. ");
INSERT INTO wim_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ngay ngook keꞌanangan wun-wunang-a, niiyaniya ngook theeꞌ-theeꞌan ngathara; ngayang weech-weechan-a, niiyana minam piꞌ-piꞌan ngayangana; ngay aak jailangan wun-wunangan-a, niiy uw-uwan ngayangana.’ ");
INSERT INTO wim_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ngul anpalana, than pam wanch min anangan thawayn ngathara, ‘Lord-ang, ngan nintang meechan aak want-wantting thath-thathan e? aꞌ may ngulan theeꞌ-theeꞌan nungkar e? Nganan puth aak want-wantting thath-thathan nintang ngakaman uth-uthaman e? aꞌ ngak ngulan theeꞌ-theeꞌan nungkar e? ");
INSERT INTO wim_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ngan ngul aak want-wantting thath-thathan nintang pam aak kechaman wamp-wampana aꞌ kal-kalan nintang ngul aak nganttamakan e? Ngan nintang aak want-wantting thath-thathan ngook keꞌanangan wun-wunana aꞌ ngananiya ngook nganttam ngulan theeꞌ-theeꞌan nungkar e? ");
INSERT INTO wim_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Nganan puth aak want-wantting thath-thathan nintang weech-weechaniya nintang puth jailangan wun-wunan e? aꞌ nganana uw-uwan nintangwey a?’ ");
INSERT INTO wim_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Aꞌ anpalan ngay ngulan thawāng thanta, ‘Nungkway pam wanch ngatharam wiy anangan kaangk-keꞌananganwey iiy-iiyin-a, niiyiya maꞌ-aath-aathan thanangweya anangan weech-weech thanang thakana. Aniy keꞌa niiy min ngathar iiy-iiyanweya.’ ");
INSERT INTO wim_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ngul anpalana, pam wanch al-alantan thawāng maꞌ thakangan than-thantan, ‘Niiy puyam iiyān a! Piip ngatharamangan aak wayak kuchow niiyanga. Niiy thum pam-wiy-keꞌ uthamana aakanakan iiyāna, angan pench-penchāna. Nil thum anana, keenk wun-wunan oony way piꞌan alantan, aꞌ ngaantiyongk nungantam al-alantan thamp, thanana thumang ngul pench-penchaynweya. ");
INSERT INTO wim_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ngay puth meechan iiy-iiyanganwey-a, niiyana may keꞌam theeꞌ-theeꞌan ngatharweya, yaꞌa; ngay ngakaman uth-uthamang-a, niiy ngak ngathar keꞌam theeꞌ-theeꞌana, yaꞌa; ");
INSERT INTO wim_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ngay aak kechaman wamp-wampang-a, puth niiyiya keꞌam kal-kalan ngayang aak niiyantamakana, yaꞌa. Ngay ngook keꞌanangan iiy-iiyanganwey-a, niiy ngook ngathar keꞌam theeꞌ-theeꞌan, yaꞌa, ngayang weech-weechan-a, aꞌ putha ngay aak jailangan wun-wunanganan-a, puth niiyana keꞌam uw-uwan ngayang, yaꞌa.’ ");
INSERT INTO wim_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ngul anpalana, thanan thawayn ngathar, ‘Lord-ang, ngan nintang aak want-wantting keꞌaman maꞌ-aath-aathan e? Ngan puth nintang aak want-wantting meechan thath-thathan e? aꞌ aak want-wantting thath-thathan nintang ngakaman uth-uthaman a? Aꞌ ngan puth aak want-wantting thath-thathan nintang aak kechaman wamp-wampan a? Aꞌ puth-a, ngan aak want-wantting thath-thathan nintangweya ngook keꞌanangan iiy-iiyan aꞌ nganana ngook keꞌaman theeꞌ-theeꞌan nungk a? Aꞌ nganan puth aak want-wantting thath-thathan nintang weech-weechana, nath aak jailangan wun-wunanan-a, putha nganana keꞌam maꞌ-aath-aathan nintang e?’ ");
INSERT INTO wim_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ngul anpalan-a, ngay ngulan thawāng thanta, ‘Ngay niiyant inan thawāng, niiyaniy-a, keꞌam maꞌ-aath-aathan thanang pam wanch kaangk-keꞌanangan thanweya weech-weechan thanang thakan. Aniya keꞌ ngayanga niiy keꞌaman maꞌ-aath-aathana.’ ");
INSERT INTO wim_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Nil God.angan pam wanch inangan aak wayak aak umpuyam kuchow thanang, puth nil pam wanch min anangan ep kalow thanang nungantangan wun-wunayn aak umpuyaman.” ");
INSERT INTO wim_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Nil Jesus.angan kanan thaaꞌ-aath-aath thanang wik yot anangan-a, nilan thaw ngurp nungantam al-alantan, ");
INSERT INTO wim_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Niiy kan meeꞌmiya, aak maꞌ-kuchamangan-a, anana aak may piꞌanan yumpayn Passover.an waaꞌantana. Aak an-aniyangan-a, pam way al-alangan maꞌam theeꞌayn ngayang pam moom al-alantan thanan yipam nailimpungayn ngayang yuk wuuyanangana, ngaya pam inmana nil God.angan kuchanya.” ");
INSERT INTO wim_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Aꞌ than pam piꞌ-piꞌanam priests anangana aꞌ puth-a, pam wuut manth-thayan Jews.antam anangana than yalmathwin aawuch wuut piꞌanang Caiaphas.antamanga, nilaniya moom piꞌanan priests al-alantaman. ");
INSERT INTO wim_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Aꞌ than wik yumpin thanttakaman Jesus.an meeꞌ thenchanamana mamayn nunang, aꞌ mulathayn nunang thampa. ");
INSERT INTO wim_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Puth thanan thawina, “Ngamp keꞌ yippak mamimp nunanga may piꞌanan mungk-mungkāmpana, an-aniyangan yaꞌa, puth than pam wanch yot anangan ngul kul yumpin ngampar nungantam peeyananga, aꞌ puth wik thaaꞌ pech-pechiythana ngampar kul thampana.” ");
INSERT INTO wim_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Anpalaniy-a, nil Jesus.ana aak Bethany angan wamp, aakiya pam Simon alantangana, nil pam Simon inmana nil kaꞌathamana weech-weech nunang, penchiyangan mak nunang kemp nungantamana. ");
INSERT INTO wim_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Aꞌ nil Jesus.an nyiin ngul may mungkow. Nil mayan yippak mungk-mungk-a, nil wanch thonam wamp nungant, ngaꞌalangk maꞌang kal-kal opar awal min thampa, puth than pam wanchanganiya oparana wukal piꞌanang piiy-piiyin. Nil wanch alangan opar awal min anana kuchek Jesus.antang piꞌanam yeecha. ");
INSERT INTO wim_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Than ngurp nungantam al-alangan wanchan thathin nunangan-a, than man kul paththam wampin nungant, aꞌ thawin ngul, “Nil ngul oparan ngeenak yeech nungantangan e? ");
INSERT INTO wim_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ngampan sellimpungimp oparana, wukal piꞌan yipam uwimpa, aꞌ ngampaniya wukal thant pam wanch wiy al-alantan theeꞌimp thanta than wukal keꞌananga al-alantana.” ");
INSERT INTO wim_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Wik thanan thaw-thawin thanttakaman-a, nil Jesus.angana kanam thiich thanang, aꞌ nilan thaw thant, “Niiy wantān nunangweya! Keꞌ wakān nunanga! Nil wanch ilangana min-minam paththam yump ngathara. ");
INSERT INTO wim_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Than pam wanch wukal keꞌanang anangan-a, than aak ingman wun-wuntan niiyantangweya, puth ngay ep-paththam yaam ingan keꞌ wuning niiyantang aak inganiya, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Wanch ilangana opar awal min-minam paththaman yeech kemp ngatharangan-a, an keꞌ pam mulantang oparan yeechantan yimanangana. An aakan yimanangan wunana, nilaniya oparan ump-umputh yeechan kemp ngatharangana, aꞌ ngul-ngulana ngayaniya uthamāng ngula, aꞌ awarang kaampayn ngayanga. ");
INSERT INTO wim_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Aꞌ ngay inan waaꞌāng niiyant thamp: aak want-wantting nath-nathan pam wanchangan wik min God.antaman waaꞌ-waaꞌaynan-a, thananiya wanch inana waaꞌ-waaꞌayn nunanga nil ilangan min paththaman yump ngathara, than yipam pam wanch wiyangan ngaant-ngaantam-ngeeyayn nunanga.” ");
INSERT INTO wim_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Aꞌ ngurp nungantam thonamana, pam namp nungantiya Judas Iscariota, nil iiya pam moom piꞌ-piꞌanam al-alantan, priests al-alantan, ");
INSERT INTO wim_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","aꞌ thaw thant, “Ayyang, kan in ngeeyiya! Ngaywey maꞌaman theeꞌāng niiyant Jesus.an-a, niiy ngul ngathara ngeen theeꞌān e?” Thananiy kan-ngul wukal thirty.an yal-yalmathin, wukal silver anangan, aꞌ theeꞌin nungant Judas.antan. ");
INSERT INTO wim_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Aꞌ aak amanam ngulana nil Judas.angana ngaantam-ngeey-ngeey, “Ngay Jesus.an want-wanttak theetathāng nunang thantan e?” ");
INSERT INTO wim_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Aak anan may piꞌan mungkanakan kan wamp thant Jews al-alantan, Passover waaꞌantan, than puth may bread morp keꞌanangan mungk-mungkayn. Aak kaꞌathangamaniy-a, than ngurp Jesus.antam anangan thawin nungant, “Ngan aak wanttinak iiyān may minh keenkan yumpān ngamparan e?” ");
INSERT INTO wim_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Nil Jesus.an thaw thant, “Niiy pam thonam alantan iiyān aak town angman, aꞌ thawān nungant, ‘Pam moom nganttaman thawa, “Aakan thinth kan-ngul wampan ngathara ngay uthamāngana. Ngan may piꞌanana aawuch nungkaramang nangman mungkāna.” ’” ");
INSERT INTO wim_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Than ngurp nungantam al-alangan wik Jesus.antaman ngeeyin, aꞌ iiyin ngul, aꞌ may minhan keenk ngul piꞌ-piꞌin thantana. ");
INSERT INTO wim_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Kinch-wayang ngulan-a, nil Jesus aꞌ ngurp nungantam anangan nyiinin ngul mayakana aꞌ mayana kan-ngul mungkin. ");
INSERT INTO wim_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Than mayan yippak mungk-mungkin-a, nil Jesus.an thaw thant, “Ngay niiyant kan-kanam thaw-thawanga: nil pam thonam-a, nil yamam nyiin-nyiinan niiyantangan-a, nil ngayangan theetathow pam way al-alantan.” ");
INSERT INTO wim_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ngurp nungantam al-alantan-a, ngangk way wun thant, aꞌ than thon-thonaman kan-ngul thaw-thawin nungant, “Ayyang, Moom-ang, nint weeꞌ waaꞌ-waaꞌangan e? ngay yaꞌ ey?” ");
INSERT INTO wim_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Nil puth Jesus.an thaw thant, “Nil weeꞌangan may breadan punchathow may kam sauce.ang angman ngatharangan-a, pam nil alangaman theetathow ngayangana. ");
INSERT INTO wim_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ngayaniy-a, pam inman nil God.angan kuch. Ngay ngul uthamāng, lat ngench thayanang waaꞌan. Puth nil pam weeꞌang theetathow ngayanga pam way al-alantan-a, an aak way-wayam paththam wampow nungant! An aak min wuniyanta nil keꞌanwey aak-ngeeyiy aak inganiya.” ");
INSERT INTO wim_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Aꞌ nil Judas.ana, pam nil ngulan theetathow nunang Jesus.ana, nil ngul thaw nungant Jesus.anta, “Ayyang, moom-ang, nint ngayangan waaꞌ-waaꞌangan ey?” Nil Jesus.an thawant, “Nint wik nanman kaniy thawangana.” ");
INSERT INTO wim_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Than mayan yippak mungk-mungkin-a, nil Jesus.angana may bread many maay, aꞌ thankyou thaw God.antana, aꞌ pip-pip ngul breadan aꞌ ngurp nungantam al-alantan kan-ngul theeꞌ-theeꞌ thanta. Nilan thaw thant, “Niiy may bread inan mamāna aꞌ mungkān ngul, may bread inana keꞌ kemp ngatharam yimanangan.” ");
INSERT INTO wim_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Aꞌ anpalaniya nil Jesus.angan cup ngul maay wine thampa, aꞌ nil thankyou thaw God.antan, aꞌ kan-ngul theeꞌ-theeꞌ thant ngurp nungantam al-alantan, aꞌ thaw thant ngul, “Niiy yot il-ilangana may wine inan mungkāna, ");
INSERT INTO wim_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","inana keꞌ chaapar ngatharama yimanangan uk-ukow kemp ngatharam inpalan niiyantana, nil God.angan yipam kaaꞌ-piichanathow niiyang keꞌ nilan keenkanaman kaaꞌngak niiyanga. Wik nilan thaw-a, an kan-kanama. Nil keꞌ-ngul ngaantam-ngeeyow way thanttam pam wanch yotantamana puth ngaya chaapar ngatharam ngulan theetathāng niiyant. ");
INSERT INTO wim_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ngay wik inan waaꞌāng niiyanta: ngay wine inana keꞌ-ngul mungkāng, yaꞌa. Ngul-ngulaniya ngampaniya karpam ngul wunāmp aak piip ngatharamantang God.antang — aꞌ ngayaniya wine nyiingkanam ngulan mungkāng niiyantangana aak ing kenyana.” ");
INSERT INTO wim_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Anpalaniy-a, than aak-pathin ngul piip God.antana, aꞌ yoykak ngul iiyina, yoyk Olives aakanakana. ");
INSERT INTO wim_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Nil Jesus.an thaw thant, “Ngay inan thawang niiyanta. Ngutang inmana, niiy yotamana ngul winynyang moꞌāna aꞌ ngay-ngayam ngul wantānweya, puth lat ngench thayanangana wik inangan waaꞌana, ‘Nil piip God.angan-a, pam moom anana minh sheepan piꞌ-piꞌana, an mulathowan ngula, aꞌ minh sheep yotam nungantam anangan-a, paa weꞌaramayn ngula.’ ");
INSERT INTO wim_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Puth anpalan-a, ngay mulaman kanan ekāng-a, ngay aak Galilee.ak keenk iiyāng. Niiyiya pal ngul iiyāna.” ");
INSERT INTO wim_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Nil Peter.an thawant, “Ayyang, moom-ang, ngay keꞌ wanting nintanga! Than wiy al-alangan nath wantiythan nintangwey-a, puth ngayaniya keꞌ wanting nintanga, yaꞌa!” ");
INSERT INTO wim_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Nil Jesus.an thaw Peter alantan, “Ngay inan kan-kanam thawang nungk, ngutang inman-a, nil minh roosteran keꞌan yippak pechow-a, nint maꞌ-koꞌalamweya an wik uuyamān thanta, nint keꞌ ngayang keꞌan meeꞌmiya.” ");
INSERT INTO wim_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Nil Peter.an wik thayanam thawant, “Yaꞌa! Ngay kan-kanam thaw-thawanga! Nungkway than nath mulathiythan ngayang nungkarang angman-a, ngay keꞌ wik uuyaming thant, yaꞌa.” Than ngurp nungantam wiy anangan wik anman thawin Jesus alantan keꞌ Peter anman thaw. ");
INSERT INTO wim_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Nil Jesus-a, aꞌ puth ngurp nungantam anangan than aak-aakanakan iiyin Gethsemane.aka, aꞌ nil Jesus.an thaw thant, “Niiy ing nyiināna aꞌ kuupān ngathara, ngay puy iiyāng aꞌ meeꞌ-wuthanamānga.” ");
INSERT INTO wim_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Aꞌ nil Peter-a, aꞌ pam kucham anangan nhengk Zebedee alantamana karpam kal thanang, wal kecham iiyin. Aꞌ Jesus.antan-a, ngangk way-wayam paththam ngul wunanta, ");
INSERT INTO wim_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","aꞌ nilan thaw thant, “Ngay ngangk way-wayam paththam ngeechananga keꞌ uth-uthamanak yimanangana. Niiy ingman nyiināna aꞌ aak thath-thathāna.” ");
INSERT INTO wim_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Aꞌ manyam ngul kech keꞌanam iiya, aꞌ aakang ngul wun-wun, meeꞌ-wuth-wuthanama piip nungantamaka, nilana wik inangan thaw God.antana, “Piip-ang, piip ngatharam-ang, nint keꞌ wayathin thanang ey? Keꞌ thawin thant ey? Wayan keꞌ yumpayn ngatharana! Puth ngayan keꞌ thawinga, yaꞌa, nint kaangk natha kuchān ngayangwey-a, yaa, an kana, wayan mak yumpayn ngathara, ngay keꞌ weeking ngatharakamana, yaꞌa.” ");
INSERT INTO wim_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Aꞌ nilana kan-ngul ek, aꞌ koyam ngul iiy ngurp nungantam koꞌalam al-alantan nil karpaman kal thananga, aꞌ thath thanang weepan wun-wunin. Aꞌ nil Peter alantan thaw, “Ayyang, nint keꞌ meeꞌ-thayanamin ey? Meeꞌ weepang pip-pipan nintang ey? Nint aak keꞌ manyam thathin ey? hour thonamakan ey?” ");
INSERT INTO wim_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Aꞌ nil Jesus.an thaw ngul thant, “Niiy aak thath-thathāna. Meeꞌ-wuthanamān God.anta, niiy keꞌ yipam ngeeyān oony wayana, way keꞌ yipam yumpān. Puth niiyan kaangk min iiy-iiyāna, puth thaaꞌ-puyan kan-ngul eenchaniy aꞌ way ngul iiy-iiyaniyweya.” ");
INSERT INTO wim_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Aꞌ nil Jesus.ana putham ngul iiy meeꞌ-wuthanamanak, piip-kunchant God.antan aꞌ nilan thaw, “Nint kaangk natha kuchān ngayanga, than yipam wayan yumpayn ngathara, yaa, an kana, ngay keꞌ weeking ngatharakamana, ngay wik ngeeyāng nintangana.” ");
INSERT INTO wim_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Aꞌ nil palam ngul wamp thant ngurp nungantam al-alantan aꞌ thath thanang weep thayan wun-wunina; thanan yaꞌangam meeꞌan thayanamina, puth yaꞌa, meeꞌ weepang pip-pip thanang. ");
INSERT INTO wim_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Aꞌ nil Jesus.ana putham ngul iiy meeꞌ-wuthanamanak, wik anman thaw God.antan, wik nil kaꞌathaman thaw-thaw nunganta. ");
INSERT INTO wim_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Aꞌ nil koyam ngul wamp thant ngurp nungantam al-alantan aꞌ thaw thant, “Niiy inman ey? weep-weenth ey? Niiy in ngeeyāna! Aak in kanam wamp ngathar thanan kan-ngul maꞌam theeꞌayn ngayangana pam way al-alantana, ngay pam inmana nil God.angan kuchanya! ");
INSERT INTO wim_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Erkam ekiya! Ngamp kan-ngul iiyāmpa! Aꞌ thathiy ee! paman nanpal iiyana nilan maꞌaman theeꞌowanya pam way al-alantana.” ");
INSERT INTO wim_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Nil Jesus.an wikan yippak thaw-thaw-a, nil ngurp nungantam Judas.an wamp. Nilan pam yot anangan karpam kal thanang, than puth pam piꞌan al-alangan kuchin thanang pam piꞌan priests al-alangan-a, aꞌ puth pam wuut manth-thayan al-alangan. Than pam anangan Judas.antang wampin-a, than nhengk-peempan pepana aꞌ yuk muurkan anangan kal-kalin. ");
INSERT INTO wim_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Nil Judas.ana pam anman nil Jesus.an theetathowana, nilan puth keenk-keenk thaw thant, “Ngay pam thonam anan walan piintāng nunangan-a, nil pam anana! Niiy mamān nunanga!” ");
INSERT INTO wim_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Nil Judas.an wamp-a, nil thintham iiy nungant Jesus.ant, aꞌ thawant, “Ayyang, Moom-ang, nint in ey?” Aꞌ wal piint nunang. ");
INSERT INTO wim_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Nil Jesus.an thawant, “Ngurp ngatharam-ang, nint pal ngeenak wampan e?” Aꞌ anpalan-a, than pam yot anangan wampin nungant, aꞌ mamin nunang Jesus.an aꞌ thayanam piꞌ-piꞌin nunang. ");
INSERT INTO wim_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Puth nil pam thonam angman nungantang thinth than-than-a, nilana nhengk-peempan nungantaman erkam paththam wich, aꞌ pam thonam anan kon thonaman-a, thalokang umpan. Pam ananiy-a, kon munth ngul iiy-iiy, nilwey pam work iiy-iiy pam piꞌan alantan, moom priestsantam alantanweya. ");
INSERT INTO wim_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ngul nil Jesus.an thawant, “Nhengk-peempan nungkaraman koyam wunpa! Nil weeꞌangan pam wanch wiy anangan mulathiy thanang nhengk-peempan alangan-a, than wiyangan-a, puthangkana mulathayn nunangan nhengk-peempan alangana. ");
INSERT INTO wim_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Niiy keꞌ meeꞌmiy ey? yaꞌ ey? Ngay nath piip ngatharamantan thawinga maꞌan-aathow ngayangan-a, an nil ngaantiyongk thaaꞌ-wantanam anangan kuchow thanang kaaꞌ-piichanathayn ngayanga! ");
INSERT INTO wim_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Puth yaꞌa, ngay keꞌ thawing nungant. Puth than keenkanaman lat ngench thayanangan umpin ngatharamana ngay uthamāngana. Yaa, an kana, ngay mak uthamānga, inan meenathow niiyant than keenkanamana an kan-kanam paththamwey umpin latangana.” ");
INSERT INTO wim_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ngul nil Jesus.an thaw thant, “Niiy nhengk-peempan pepan aꞌ yuk muurkan thakan kal-kalaniy ngayangan yipam mamān ey? Ngay keꞌ pam way yimanangan ey? Ngay puth aak ingam wunanam ey! Aꞌ ngaaꞌ thon-thonangana aawuch ngench thayanang thaaꞌ-aath-aathangan ey! Puth niiy keꞌam maman ngayang, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Puth niiy way inangan yumpan ngathar-a, inan yipam meenathow niiyant pam wanchantan than keenkamana lat ngench thayanangan umpin ngatharamana an kan-kanam paththamwey umpin latangana.” Anpalan-a, than ngurp nungantam yotam al-alangan-a, wantin nunang, aꞌ yaꞌ-ngul moꞌin nungantam. ");
INSERT INTO wim_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Than pam al-alangan Jesus.an mamin nunangan-a, than kalin nunang ngul aak Caiaphas.antamaka, pam moom piꞌan priests al-alantamana. Than pam piꞌ-piꞌanam anangan wik thayanan thaaꞌ-aath-aathin-a, puth wuut manth-thayan anangana aak angman yalmathwin thanttakamaniya. ");
INSERT INTO wim_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Nil Peter.aniy-a, kecham koy-koyyuw iiy-iiy thanttang, aꞌ nilana aak angman wamp, aak Caiaphas.antam angmana, puth keꞌam ngoonch, yoon angman than-than. Nilan soldiersantang nyiin-nyiin wik ngeeyow thanang than wanttakan wik yumpayn nungant Jesus.antana. ");
INSERT INTO wim_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Than pam moom priests anangana putha pam councillors anangana wenk-wenkin pal-puy pam wanchakan yipam thaachayn thanang wik uuyamanakana, yaan waaꞌayn nunang Jesus.ana. Than kaangk aak-yaꞌangan waaꞌayn nunang aak courtang angana, keꞌ pam way yimanangan waaꞌayn nunang, than yipam kuchayn nunang mul wunowa. ");
INSERT INTO wim_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Than pam wanch yotangan aak-yaꞌangan waaꞌ-waaꞌin nunang, puth thananiya wik thon-thon kuyam waaꞌ-waaꞌin nunang. ");
INSERT INTO wim_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Ngul anpalaniya, pam kucham ngul iiypul aꞌ aak umang angan thanpul Jesus.an waaꞌ-waaꞌpul nunang thant pam piꞌ-piꞌanam al-alantan, wik uuy-uuyampul yaan waaꞌpul nunang Jesus.an, pulan thawpula, “Nil pam inman thaw, ‘Kaangk ngaya aawuch ngench thayan God.antaman wayathing-a, an ngay wayathing, aꞌ kinch maꞌ-koꞌalamang kanan wantowan-a, ngay koyam ngul yumpānga.’” ");
INSERT INTO wim_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Aꞌ nil pam moom priestana wur ek aꞌ thaw ngul Jesus.antan, “Ayyang, nint ngul wanttak thawān e? Ngul nint wik yimanang thawan ey?” ");
INSERT INTO wim_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Puth nil Jesus.ana wik koyaman keꞌam thaw thant, yaꞌa, popam anman than-than. Aꞌ pam moom piꞌan priestana putham ngul thawant Jesus.antan, “Nil God.an man-yethama, nilan ngeey-ngeeyan nintang. Nint kan waaꞌān nganta! Nint kan-kanam thawan ey? Nint ngul pam inan God.angan keenkaman kaaꞌngak ey? kuchowan nintangan ey? nhengk God.antaman ey?” ");
INSERT INTO wim_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Nil Jesus.an thaw nungant, “Nint wik nanan thawan-a, an kan-kanama. Puth ngay niiyant yotamant thawanga: niiy ngul thathān ngayang wuny niiyantam inan, moom piꞌan God.antangan nyiin-nyiināng, ngananiya moom wuut piꞌan paththam nyiin-nyiinān. Aꞌ niiy thamp ngul thathān ngayang palaman uk-ukāng yuwangan aak inpal kenyan.” ");
INSERT INTO wim_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Aꞌ nil moom piꞌan priestsantamana thaaꞌam ik, aꞌ ngook nungantaman ikath, aꞌ nil thaw, “An waya! An kana, ngan wik nungantaman kan ngeeyan. Wiyangan keꞌ waaꞌiythan nunang ngamparaniya, yaꞌa! Niiy nyiingk inan wik kan ngeeyan ey? nil God.an waaꞌan nungamang ey! ");
INSERT INTO wim_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Niiy wanttak ngaantam-ngeeyaniy e?” Thanan puth thawin nungant, “Nilan wik way-wayam paththam thaw, an mak mulathayn nunanga.” ");
INSERT INTO wim_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Aꞌ than thaaꞌ theekang makin nunang kaaꞌwalangan aꞌ piikin nunang. Puungk wiyangan-a, maꞌang piikin nunang, ");
INSERT INTO wim_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","aꞌ thawin nungant, “Ayyang, Christ-ang, nint kan min-minam waaꞌān nganta weeꞌangan piik nintang e?” ");
INSERT INTO wim_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Nil Peter.an aawuch yoon angman nyiin-nyiin, thaaꞌ thinth. Aꞌ nil wanchan wamp, nil workan iiy-iiyan pam piꞌan alantan, moom priestsantamana. Nil wamp nungant Peter.ant aꞌ thaw nungant, “Nint ngurp nungantam, Jesus.antam ey? pam aak Nazareth anpalan ey?” ");
INSERT INTO wim_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Puth nil Peter.an wik uuyam, aꞌ thawant kon yotantangana, “Ngay ngoongk-ngoongkam wik nintan thaw-thawangana.” ");
INSERT INTO wim_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Aꞌ nilan pent ngul, thaaꞌ thinth angman than-thana. Aꞌ wanch thon ngul wamp, nil thampan workan iiy-iiyan pam piꞌan alantan. Nil wanch an-ngulan thaw thant pam al-alantan angman than-thaninana, “Nil pam inaniya ngurp nungantam Jesus.antama, pam aak Nazareth anpalana.” ");
INSERT INTO wim_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Puth nil Peter.an putham wik uuyama, nil thaw thant, “Ngay kan-kanam inaniy thaw-thawang, ngay wik keꞌ uuyaminga, ngay pam anan keꞌ meeꞌmiy nunang yaꞌa.” ");
INSERT INTO wim_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Anpalana, than pam wanch anangan angman than-thaninan-a, wampin nungant Peter alantan, aꞌ thawin nungant, “Nint kan-kanama ngurp nungantama, nint puth thaaꞌnganth nipamweya.” ");
INSERT INTO wim_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Nil puth Peter.an thaw, “Ngay kan-kanam inaniy thaw-thawang niiyant, ngay keꞌ wik uuyaminga, yaꞌa. Ngay nath wik uuyamingan-a, nil God.angan mak wayathow ngayang. Ngay pam anan keꞌ meeꞌmiy yaꞌa!” Anpalan-a, minh roosteran pech-pech ngula, ");
INSERT INTO wim_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","aꞌ konang wamp nungant Peter alantan wik nil Jesus.an thawant, “Ngay inan kan-kanam thawang nungk, ngutang inman-a, nil minh roosteran keꞌan yippak pechow-a, nint maꞌ-koꞌalamana ngul wik uuyamān thantweya pam wanch wiyantan, nint ngayangan keꞌan meeꞌmiy yaꞌa.” Aꞌ Peter.an yoon pent aꞌ nil peey-peey, ngangk way-wayam paththam wunanta. ");
INSERT INTO wim_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Anpalan-a, ngaaꞌ thonan wamp-a, than pam piꞌan anangan ngaaꞌ-ngaaꞌthiyangam yalmathwin, than pam piꞌan priests anangana, aꞌ puth-a, than pam wuut manth-thayan anangana, than wik yumpin thanttakaman Jesus.an mulathayn nunanga. ");
INSERT INTO wim_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Aꞌ than Jesus.an chol many kung-makanang kathin nunang, aꞌ nath puyamam kalin nunang, aꞌ maꞌam theeꞌin nunang pam moom piꞌan alantan Romans al-alantamana, namp nungantiya Pilate. ");
INSERT INTO wim_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Anpalan-a, nil Judas.ana pam nilaman theetath nunang Jesus.ana, nilana wik ngul ngeey thanang than kanan kalin nunang Jesus.an yipam mulathayn nunanga. Aꞌ nilaniya ngul-nyaaꞌ ngul wun aꞌ putha ngangk way thamp wunant, puth nil ngaantam-ngeeya nil way iiy Jesus.antana. Nilana wukal yot koyam kal thant pam piꞌan priests al-alantana aꞌ putha pam wuut manth-thayan al-alantana, ");
INSERT INTO wim_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","aꞌ nil thaw thant, “Ngayana way-wayam paththam yumpanga. Ngayan maꞌam theeꞌang Jesus.an pam way al-alantan mulathayn nunangana, nilana pam min-minam paththama, pam way yaꞌa, way keꞌ yumpanama, yaꞌ anman.” Thanan thawin nunganta, “An kaniy e! An ngul ngant ey! An nungk-nungka!” ");
INSERT INTO wim_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Judas.angana wukal yot anangan aakang theeꞌ aawuch ngench thayanang angmana aꞌ kan-ngul iiy; nil koyam iiy-a, aꞌ man kath nungantakaman kuuyangana aꞌ yukang angman waanch nungantakam aꞌ mul ngul wun. ");
INSERT INTO wim_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Than pam piꞌan priests al-alangana wukalan maayin ngul aꞌ thawin ngul, “Wukal inan Judas.antan theeꞌina, nil yipam pam Jesus.an mul wunow. An puth min ngampara yaꞌa, wukal ingan keꞌ wuniya aawuch ngench thayan God.antamangana, wik thayan ngamparamana yimanangan keꞌam waaꞌana, yaꞌa.” ");
INSERT INTO wim_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Thanana wik karpam ngul thaw-thawina aꞌ wik inan yumpin ngul than aak piiyayn pam thonam alantaman ngaꞌalangkan yump-yumpan, aak ananiy-a, nungantamweya, thanan namp inan waaꞌin nunanga “potter”. Puth thanan ngaantam-ngeeyin ngula than yipam pam wanch thaaꞌnganth thon anangan mulan wun-wunayn-a, aak angan kaamp-kaampayn thananga. ");
INSERT INTO wim_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Puth anpalana, thanan aak anan waaꞌ-waaꞌantana “aak chaapara”, in-inman waaꞌ-waaꞌantan aak ananiya. ");
INSERT INTO wim_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","An puth aak keenkanam anpalan meenath ngampara wik pam thonam anan thaw Jeremiah.ana, nil Jesus.an waaꞌana, an puth kan-kanam ngul wamp. Nil aak keenkanaman umpa lat ngench thayanangana wika inangan umpa, “Than pam wanch yotaman aak Israel.amana thawin thananiya wukal thirty ngul theeꞌayn pam thonaman yipam mul wunow. ");
INSERT INTO wim_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Aꞌ than wiyanganiya wukal thirty.ana palam piiyin thanang aꞌ aak piiyin thanttakamana, aak pam thonam alantamana nil ngaꞌalangkan yump-yumpana, pam potterana. Nil God.ana wik yimanangan thaw ngathar.” Nil Jeremiah.an wik yimanangan keenkanaman thaw. ");
INSERT INTO wim_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Anpalana, than Jesus.an thanathin nunang um pam piꞌantang, nil pam anan Rome punchana, aꞌ nil pam piꞌan alangana mep-mep nunang, “Nint ina moom king Jews al-alantaman ey?” Nil Jesus.an thawant, “Nint wik nanan kan thawan-a, an kan-kanama.” ");
INSERT INTO wim_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Aꞌ than pam piꞌan priests al-alangan aꞌ puth-a, than wuut manth-thayan al-alangan waaꞌ-waaꞌin nunang Jesus.an nil way yot yump-yumpa, puth nil popam anman than-than, keꞌam wik thaw, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Aꞌ nil Pilate.an thawant ngul, “Nint keꞌam ngeeyan thanang ey? waaꞌ-waaꞌantan nintangan ey?” ");
INSERT INTO wim_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Nil puth Jesus.ana wik koyaman keꞌam thawa, yaꞌa, thaaꞌ popam anman piꞌ-piꞌ, nil pam piꞌanan-a, meeꞌam paththam ik. ");
INSERT INTO wim_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Kaap thon-thonangan-a, may piꞌanan yumpantan Passover.an-a, nil pam piꞌan Pilate.angan pam thon-thonam kuch-kuchan thant Jews al-alantan aak jailam anpalan — than weeꞌantan kaangk-a, nil anan kuchow thantana. ");
INSERT INTO wim_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Aak an-aniyangan-a, pam namp Jesus Barabbas aak jailang wun, pam inana, than yotangan meeꞌmiy nunang. ");
INSERT INTO wim_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Aꞌ than pam wanch Jews thaaꞌ-wantanaman yalmathwin aak Pilate.antamakan-a, nilan-a, thaw thant, “Niiy pam want-wanttinan miꞌāna, ngay yipam kuchāng nunang niiyantana? Ngay pam inana Jesus Barabbas kuchāng ey? Nath yaꞌa, ngay pam thon inana Jesus kuchāng niiyantan ey? pam inana than wiyangan waaꞌantan nunang God.angan keenkanaman kaaꞌngak kuchowan nunanga!” ");
INSERT INTO wim_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Nil Pilate.angan meeꞌmiy thanang paththam pam piꞌan Jews al-alantaman puth than meeꞌ-wunin nungantam Jesus.antam thanan keꞌ-paal maꞌam theeꞌin nunang. ");
INSERT INTO wim_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Nil Pilate.angan yippak aak courtakan angman nyiin-nyiina, puth nil wanch thum nungantamangan wik kuch nungant, wik inangan thawa, “Ayyang, nint pam min nanana keꞌ kuchin nunang mulathanakana, yaꞌa, nil pam min paththama, way keꞌ yumpanama! Ngay ngutangan pith-pithangan nunangana, aꞌ ngangk way paththam wunar nungantam anpalana.” ");
INSERT INTO wim_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Puth than pam piꞌan priests al-alangana aꞌ puth-a, wuut manth-thayan al-alangana thaachin thanang pam wanch yot anangan than yipam thawayn nungant Pilate alantana Barabbas.an kuchow thantana, aꞌ Jesus.aniy-a, kuchow nunang mulathanaka. ");
INSERT INTO wim_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Nil Pilate.an putham ngul thaw thant pam wanchantana, “Ngay pam weeꞌ kuchāng niiyanta?” Thanan thawin nungant, “Barabbasa!” ");
INSERT INTO wim_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Nil Pilate.an thaw thant, “Ngul pam inan niiy wiyangan Christ.an waaꞌaniy nunanga, ngay wanttak yumpāng nungantana?” Thanana pech-pechin nungant, “Yuk wuuyanang waanchān nunanga aꞌ mulathān nunanga!” ");
INSERT INTO wim_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Nil puth Pilate.an thaw thant, “Nil way ngeen yump e?” Puth thanan othamayan pech-pechin nungant, “Yuk wuuyanang waanchān nunanga aꞌ mulathān nunanga!” ");
INSERT INTO wim_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Nil Pilate.ang kan-ngul ngaantam-ngeey nil puth yaaman keꞌ thawiy thant pam wanchantana, than ngula kul piꞌan yumpiythana. Yaa, nilana ngak uw, aꞌ maꞌ nungantaman pung ngula meeꞌ yotantangan, aꞌ thaw thant, “Ngay maꞌ punganga, anan meenathāng niiyant ngayana keꞌam kuchang nunang mulathanakana, niiyam ep kuchan nunanga!” ");
INSERT INTO wim_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Than pam wanch thaaꞌ-wantanam anangan thawin nungant, “An kana! Man kul nath wampow nungant God.antan-a, nil mak wayathow nganang aꞌ puk manyiy nganttam inangan thampa, aꞌ kampan nganttam anangan ngulan aak ngeey-ngeey-ngeeyayna.” ");
INSERT INTO wim_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Aꞌ anpalana, nil Pilate.angan Barabbas.an kuch thant aak jailam anpalan. Aꞌ nilan thaw thant soldiers al-alantan puy ngul kalayn nunang Jesus.ana, aꞌ piik-piikayn nunang kuuy alangan, aꞌ nil thaw thant ngul, “Yaa, niiy kalān nunang yuk wuuyanakana, nailang mak pungān nunangweya.” ");
INSERT INTO wim_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Anpalan-a, than soldiers Pilate.antam al-alangana Jesus.an matathin nunang ngul aak aawuch pam piꞌan alantamakana aꞌ pek ngoonchathin nunang, aꞌ than soldiers yotaman angman yalmathwin Jesus.antanga. ");
INSERT INTO wim_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Thanan ngook nungantaman yaꞌ thapathin aꞌ ngook wewm ngoonchathin nunang. ");
INSERT INTO wim_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Anpalana, than yuk olk yumpin yuk waakamama keꞌ crown yimanangan, aꞌ kuchekang ngul wunpin nungantanga, aꞌ than yuk maꞌ malang wunpin nungantang maꞌangan piꞌow, anpalana, thanan pungkang ngul thuchin um nungantang aꞌ thaaꞌ-thengk-thengkathin nunang, thaw-thawin nungant, “Ayyang, nint inan moom piꞌan ey? Jews al-alantaman ey? Nint yaam man-yetham anman wun-wunān ey?” ");
INSERT INTO wim_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Aꞌ thanana thaaꞌ theekang makin nunang, aꞌ yukan-a, maꞌam piiyin nunang aꞌ yuk alangaman kuchek piikin nunang. ");
INSERT INTO wim_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Than kanan thaaꞌ-thengk-thengkathin nunanganwey-a, than ngook keꞌ chaapar yimanangan kemp nungantam anpalan thapathin ngul aꞌ ngook nungantam anman koyam ngoonchathin nunang. Aꞌ anpalana, than yoon kan-ngul kalin nunang, yuk wuuyanangan waanchayn nunang aꞌ mulathayn nunang. ");
INSERT INTO wim_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Than kanan iiy-iiyinan-a, than pam aak Cyrene punchan anana umang uwin nunang, namp nungantiya Simona, aꞌ than thaachin nunang yuk wuuyan Jesus.antaman kalow. ");
INSERT INTO wim_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Aꞌ aak namp Golgotha.ang wampina, wik ngamparamangan waaꞌanampa, “Aak Kuchek Kaancha.” ");
INSERT INTO wim_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Aak ang-ngulaniya, thanan wine opar karangk thamp nenchanathin aꞌ theeꞌin nungant Jesus alantana. Nilan yaan manyam paatha, aꞌ want, keꞌam ngul mungka. ");
INSERT INTO wim_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Anpalan-a, than nailang pung-pungin nunang yuk wuuyanangan, aꞌ waanchin nunang ngul, mul yipam wunow. Aꞌ than pam soldiers al-alangan ngook nungantaman thakan thon-thonam aath-aathwin thanttakamana, than puth yuk dice.ang keeꞌ-keeꞌathin nil yipam weeꞌangan nath uwowana. ");
INSERT INTO wim_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Amanaman-a, thanana angman nyiinin ngul aꞌ thath-thathin nunang. ");
INSERT INTO wim_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Yuk wuuyanang Jesus.antang kenyangkana than wik inangan umpin, waaꞌ-waaꞌin nunang, “Nil pam Jesus inana moom piꞌan king Jews al-alantamana.” ");
INSERT INTO wim_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Than pam soldiers al-alangana pam kucham thamp waanchin pulang Jesus.antang karpam angmana, pulana pam maꞌ-kuchan iiy-iiypul. Nil Jesus.aniy-a, menhang pulantang waanchin nunang, nil pam thonamaniya maꞌ malanga aꞌ nil pam thonaniya maꞌ thakanga. ");
INSERT INTO wim_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Pam wanch wiy anangan woyan wakanan iiy-iiyin-a, kuchek wuny-wunyathin nungant Jesus.antan, aꞌ wik wayanang thak thaw-thawin nungant, ");
INSERT INTO wim_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Ayyang, nint keꞌ aawuch ngench thayan God.antaman wayathin ey? Aꞌ kinch maꞌ-koꞌalamang kanan wantowan-a, keꞌ nint koyam ngul kaachin ey? An yaꞌa! Nint nath kan-kanamweya nhengk God.antaman-a, nint kan nungkarakam kaaꞌ-piichanathāna aꞌ yuk wuuyan nanpalan ukāna!” ");
INSERT INTO wim_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Than pam piꞌan priests al-alangana aꞌ puth than pam piꞌan anangan wik thayanan thaaꞌan-aath-aathina aꞌ puth than wuut manth-thayan anangana, than thampang thaaꞌ-thengkathin nunang Jesus.ana. ");
INSERT INTO wim_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Than thawin thanttakaman, “Nil thanang wiy anangan ep kaaꞌ-piichanathan ey? Nil puth nungamang thamp kaaꞌ-piichanathow ee! Nil kan-kanam moom piꞌan king ey? aak Israel aakanakan ey? Nil nath yuk wuuyanam anpalan ukowa, ngampaniya ngul ngaantam-ngeeyāmp nunangana nil kan-kanam God.angan kuchana. ");
INSERT INTO wim_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Nil God.an ngangkang piꞌ-piꞌan nunang, aꞌ waaꞌan nungamang keꞌ nil nhengk nungantama. Yaa, kan thathāmpa, nil God.angan nath kaaꞌ-piichanathow nunanga, nath yaꞌa.” ");
INSERT INTO wim_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Aꞌ pam kucham anangan-a, yuk wuuyanang angan waanchin pulangan-a, pul thamp thaaꞌ-thengk-thengkathpul nunang Jesus.ana. ");
INSERT INTO wim_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Anpalana kinch keny ngulana, aak pal-puyan ngaaꞌ nyim paththam anman wun-wun three oꞌclockakam. ");
INSERT INTO wim_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Three oꞌclockan wamp-a, nil Jesus.an wik othamayan ngul pecha, wik thaaꞌnganth nungantamang thaw, “Eloi, Eloi, lema sabachthani?” Wik ngamparamang yimanangan thawanamp, “God ngatharam-ang! God ngatharam-ang! Nint ngeenak too wantangan ngayanga?” ");
INSERT INTO wim_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Pam wanch wiy anangan angman than-thaninan-a, ngeeyin nunang, aꞌ thawin thanttakamana, “Ayyang, nilan Elijah alantan pech-pechana!” ");
INSERT INTO wim_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Nil pam thonaman moꞌ aꞌ nil ngook manyana uw, aꞌ may wine pochang angan punchath aꞌ ngook manyan-a, yuk ongkang kath, aꞌ yukana keny ngul maay nunganta, aꞌ thaw nungant Jesus.antan mungkowa. ");
INSERT INTO wim_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Puth than pam wanch wiy anangan thawina, “Ngamp kan kuupāmpa! Nil Elijah.an ngul nath wampowa nil yipam yuk wuuyanam anpalana ukathow nunanga. Ngamp ngul nath thathāmpa!” ");
INSERT INTO wim_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Anpalan-a, nil Jesus.ana wik othamayan pech, aꞌ nil utham ngul, yaꞌ-ngul. ");
INSERT INTO wim_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Aak an-aniyangan-a, ngook keeꞌan kaachin aawuch ngench thayanangan uk-uk-a, ananiya keny anpalana pekakam um-menhang yaꞌ ika. Aakana yaꞌ wunyath, aꞌ kunttow piꞌan anangana ikin thampa. ");
INSERT INTO wim_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Aꞌ awar pam mulantam anangan-a, an thampana yaꞌ ikina, aꞌ pam wanch yot God.antamana kaꞌathaman uthaminan-a, nil ekath thanang, man-yetham koyam ngul weenina. ");
INSERT INTO wim_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Than pam wanch il-ilangan-a, graves thanttaman wantin, aꞌ anpalana nil Jesus.an mulaman kanan ek-a, than pek ngoonchin aak piꞌan ngench thayan Jerusalem.anga. Pam wanch yotangan thathin thanang. ");
INSERT INTO wim_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Pam moom soldiers al-alantamana aꞌ puth-a, soldiers nungantam anangana angman than-thanina, min-min thath-thathin nunang Jesus.ana aꞌ than thathina want-wanttakan wampa nungantaniya, than thathina aakan wunyath earthquake.angana aꞌ thananiy-a, winynyang paththam moꞌina, aꞌ thanan thawin thanttakaman, “Nil pam inana kan-kanam paththam nhengk God.antama!” ");
INSERT INTO wim_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Wanch wiy anangan angman than-thanin, than kecham thath-thathin. Thanan monkan-wak-wakin nunang Jesus.ana aak Galilee anpalan-a, aak Jerusalem aakanakaman aꞌ maꞌ-aath-aathin nunang. ");
INSERT INTO wim_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Wanch than inanganiya; Mary Magdalene, aꞌ puth Mary thonana nila kaath pulantamweya James-a, puth-a, Joseph pulantama, aꞌ puth wanch thona wanch nungantam Zebedee alantamana, aꞌ putha wanch wiy anangan thampa. ");
INSERT INTO wim_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Aak ngutang ngulan-a, nil pam namp Joseph.an wamp, nil pam inana, pam maꞌmangkiy aak Arimathea anpalana. Nil thampana monkan-wak-wak nunang Jesus.ana. ");
INSERT INTO wim_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Nil puth Joseph.ana Pilate alantan wamp, aꞌ thawant, “Ngay pam mulan keꞌ kaling ey?” Aꞌ nil Pilate.an thaw thant pam al-alantan workan iiy-iiyin nungantana pam mulan theeꞌayn nungant Joseph alantana. ");
INSERT INTO wim_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yaa, nil Joseph.angan maay nunang, aꞌ kath nunang ngook ongk nyiingkanamang alangana, ");
INSERT INTO wim_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","aꞌ nil aak awarangan pek ngoonchath nunang — aak awar inaniya keꞌ nungantakama, Joseph alantana, puth niliya pam mul inana Jesus.an thenchana. Than nyiingkwey weꞌ-weꞌin kunttow thayanama. Aꞌ nil kunttow wuut piꞌanana poo thaꞌ thaaꞌang angman yipam wunow. ");
INSERT INTO wim_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Aꞌ Mary Magdalene-a, aꞌ Mary thon anana nyiin-nyiinpul, um grave.akana. ");
INSERT INTO wim_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ngaaꞌ thonang ngulana, aak Saturday.an-a, than pam piꞌ-piꞌanam priests anangana aꞌ putha pam Pharisees anangana Pilate.antang wik thaw-thawin. ");
INSERT INTO wim_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Aꞌ than thawin nungant, “Moom-ang, ngan kan ngaantam-ngeeyanana nil pam anan man-yethaman yippak iiy-iiy-a, nilaniy thawa, ‘Ngay aak awarangan maꞌ-koꞌalam thonakam wunānga, aꞌ anpalana ngayana koyam ngul mulaman ekāng.’ Nil puth Jesus.an yaan wik uuyama. ");
INSERT INTO wim_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Yaa, nintan puth pam soldiers nungkaram al-alantan thawān thanta aak grave.an min-min thath-thathayna aak maꞌ-koꞌalamakana — than ngurp nungantam al-alangan keꞌ yipam pam mulan maayayn nunang, aꞌ waaꞌiythan ngul pam wanch wiyantan, nil mulaman kanam eka. Than wik yimanangan thaw-thawiythanan-a, thananiya puy-puyam wik uuy-uuyamiythana.” ");
INSERT INTO wim_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Nil puth Pilate.an thaw thant, “Niiy soldiers puungk wiy kalān thanang, aꞌ thaaꞌ grave.angana min-min thayanathāna, aꞌ aak grave.an min-minam ngul piꞌāna.” ");
INSERT INTO wim_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Aꞌ than Pilate.ana wantin nunang ngul, aꞌ kan-ngul grave.akan iiyin. Thanan grave thaaꞌan kuuyang kathin aꞌ kuuy anangana nguchamanang mak-makin yipam wiy al-alangan thaaꞌan keꞌ thapathayna — aꞌ thanana soldiers wiy anangan wunpin thanang yipmam grave anan minam piꞌ-piꞌayna. ");
INSERT INTO wim_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Aak Saturday.an kanan minch-a, aak Sunday.akan kan-ngul man than-than aakan paanthowa, pul wanch kuchama Mary Magdalene-a, aꞌ putha wanch thon anana Mary-a, pul iiypul aak awarakan thathowpul. ");
INSERT INTO wim_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Yaam keꞌanamana, aakan yaꞌ wunyatha, aꞌ nil ngaantiyongk God.antam inpal keny uk, aꞌ kunttow piꞌan anan thechath thaaꞌamana, aꞌ kunttow angman nyiin-nyiin ngul. ");
INSERT INTO wim_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Nil ngaantiyongkana keꞌ ngaay yimanangan nyiin-nyiin, ngook nungantaman thampa pach-pachama. ");
INSERT INTO wim_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Puth than pam soldiers anangana ngangk akangam than-thanin aꞌ ngangk winynyang paththam moꞌin, aakangam angman keekin, popam anman wun-wunin keꞌ pam mula. ");
INSERT INTO wim_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Nil ngaantiyongkan thaw wanch kucham al-alantan, “Nip keꞌ winynyang moꞌowa! Ngay kan meeꞌmiy nipanga nip Jesus.anta wenkanipa, pam anman yuk wuuyanangan waanchin nunanga aꞌ mulathin nunangana. ");
INSERT INTO wim_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Nil in yaꞌa; nil kanam mulaman eka keꞌ wik anman nilaman thaw. Nip pal iiyowa aak awar in pekan thathow nilan wun-wuna. ");
INSERT INTO wim_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Yaa, nip erkam koyaman iiyowa aꞌ ngurp nungantam al-alantan waaꞌow thantana, ‘Nil mulaman koyam kanam eka, aꞌ nil inman aak Galilee.akana umputh iiyowa aꞌ niiyana aak angan thathān nunangana. Wik ngayan waaꞌang niiyantan-a, niiyana konangam piꞌ-piꞌāna.’” ");
INSERT INTO wim_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Aꞌ pulana koyam erkam iiypul, winy-winynyang ngeet-ngeetpul aak awar amanamana, aꞌ ngangk minangam kamp moꞌ-moꞌpul pulan yipam wik waaꞌowpul ngurp Jesus.antam al-alantana, nil kanaman ek mulamana. ");
INSERT INTO wim_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Aꞌ yaam keꞌanamana nilam paththam Jesus.ana wamp pulant, aꞌ thaw pulant, “Nip in ey?” Pulana wamppul nungant, aꞌ thaꞌana maꞌang mampul nunang, aꞌ thaaꞌ-kuump-kuumppul nunang. ");
INSERT INTO wim_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Aꞌ nil Jesus.an thaw pulant, “Nip keꞌ winynyang moꞌowa, nip iiyow aꞌ waaꞌow thant kuunch ngatharam al-alantan, aak Galilee.ak iiyayn aꞌ aak angan kaaꞌwalan thathayn ngayanga.” ");
INSERT INTO wim_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Pul wanch anangana kanan iiy-iiypul woyan wakanangan-a, than pam soldiers puungk wiyangana aak awaran piꞌ-piꞌinan-a, koyam ngul iiyin aak townakan, aꞌ wikan waaꞌin thant pam piꞌan priests al-alantan wik maꞌmangkamana than meeꞌ thanaman thath-thathinana. ");
INSERT INTO wim_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Yaa, than pam piꞌan priests anangana aꞌ wuut manth-thayan anangana than yalmathwin aꞌ wik yumpin ngul aꞌ thananiya wukal piꞌan ngul theeꞌin thant pam soldiers al-alantana, ");
INSERT INTO wim_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","aꞌ thawin ngul thanta, “Niiy pam wanchantan waaꞌāna than ngurp nungantam anangan aak awarakan iiyin aak ngutangana, aꞌ pam mul anana maꞌ-kuchathin nunang niiy weep thayanan wun-wunana. ");
INSERT INTO wim_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Nilwey moom piꞌan paththam alangana pam Governor alangana wik imanaman nath ngeeyowan-a, ngan ngul thawān nunganta niiy way keꞌam yumpanweya. Yaa, niiyaniya keꞌa ngangk wayan wunow niiyanta nil wanttakan thawow niiyant pam piꞌan Governor.ana.” ");
INSERT INTO wim_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Yaa, than pam soldiers al-alangan wukalana maꞌang mamin, aꞌ kan-ngul wikan waaꞌ-waaꞌin pam wanch thon-thonantan. Aꞌ aak in-inman Jews wiy al-alangan wik kath inan waaꞌ-waaꞌantan than ngurp nungantam al-alangan pam mul Jesus.ana maꞌ-kuchathin nunanga. ");
INSERT INTO wim_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Aꞌ ngurp Jesus.antam pam eleven anangana aak achantangak iiyin aak Galilee.ang angman, nil Jesus.an kaꞌathaman thaw thant aak-aakanakan iiyayna. ");
INSERT INTO wim_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Aꞌ nilaniya aak angman wamp thantana. Than thathin nunangan-a, thananiy-a, keꞌam min-minan ngaantam-ngeeyin nunangana, yaꞌa, nil keꞌ pam thona aak anganiy than-thana, puth yaꞌa, nilam Jesus a! ");
INSERT INTO wim_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Aꞌ nil Jesus.ana thintham ngul wamp thant aꞌ thaw thant, “Piip ngatharaman thaw ngathara ngay pam moom wuut piꞌan iiyānga pam wanch maꞌmangkamantana aꞌ putha way min maꞌmangkamantana ngay moom thampa, aak inan earthangana wuntana puth aak in kenyan wuntana. ");
INSERT INTO wim_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ngay keꞌ-paal inan thawang niiyanta: niiya aak nath-nathan iiy-iiyān pam wanchantana aꞌ waaꞌ-waaꞌān ngayang thanta, aꞌ thawān thant than ngayang thampan monkan-wak-wakayna. Than kanan ngangk theeꞌ-theeꞌayn ngatharan-a, niiy kootra ngakangan kuungk-kuungkān thanang, puth than pam wanch anangana maꞌ piip God.antang ngul wun-wunayn puth-a, maꞌ ngatharang nhengk-kunchantanga, aꞌ puth-a, maꞌ Ngeen-Wiy Min alantangan ngula. ");
INSERT INTO wim_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Thaaꞌ-aath-aathān thanang wik min anangan ngeey-ngeeyayna aꞌ ngangkangam piꞌ-piꞌayn ngul wik anangan ngayan waaꞌ-waaꞌang niiyantana. Aꞌ ngay niiyantang angman ngul iiy-iiyānga, aak imanaman ngula, aꞌ aak-aakanakaman aak inan minchowana.” ");
INSERT INTO wim_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Inaniya wik min-minam paththam Jesus Christ.antaman, nhengk God.antaman. ");
INSERT INTO wim_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Aak keenkanamana pam Isaiah alangana lat ngench thayanangan ump, nunangan waaꞌa, nil wik yimanangan ump wik God.antam anangana: “Ngay ngul kuchāng wik thooꞌiy ngatharamana keenk iiy-iiyow nungka. An keꞌ nilanweya woyan min-min yumpow nungkar, nilaniya thaaꞌ-aath-aathow pam wancha. ");
INSERT INTO wim_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Aꞌ niliya aak pintalang iiy-iiyow, wik pech-pechow, ‘Niiy woyan min-minam kan yumpān nungant Lord.antana! Koochanam yumpān nunganta!’” Nil pam Isaiah.angan wikana yimanangan ump. ");
INSERT INTO wim_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Anpalan-a, nil pam John.an aak pintalangan iiy-iiy aak Judea.angan, aꞌ nil kan-ngul waaꞌ-waaꞌ wik God.antaman, aꞌ nil puth pam wanch anangan kootra ngakang kuungk-kuungk thanang. Nil thaw thant, “Way niiyan yumpaniya niiy kan-ngul wantāna! Niiy palaman weentān God.antan! Aꞌ ngay anpalana kootra ngakangan kuungk-kuungkāng niiyang, aꞌ nil God.angan keꞌ-ngul ngaantam-ngeeyow way yot niiyan yump-yumpan.” ");
INSERT INTO wim_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Pam wanch yot wampin nungant than yipam wik ngeeyayn nunang, aak Judea amanam aꞌ putha aak Jerusalem amanam wampin nungant. Than waaꞌin thanttakam John.antan way thanan yump-yumpin, aꞌ putha nil kootra kuungk-kuungk thanang ngul punth Jordan.angan. ");
INSERT INTO wim_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ngook nil John.angan ngoonch-a, minh camel thuuꞌam, aꞌ ompam kath nungantakam minh peꞌanang. May at mungk aꞌ minh pongkok mungk. ");
INSERT INTO wim_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Nil thaw thant pam wanchantan, “Pam thonangan ngul wampowa, mangk ngatharangana, puth nilaniya ep-paththama pam wuut piꞌan paththama, ngay yaꞌa, ngay pam many paththam. Ngayana keꞌ pekaman thuchinga, thaꞌ murrukan thapathing thaꞌ nungantam amanamana yaꞌa puth ngay pam piꞌan yaꞌa. ");
INSERT INTO wim_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ngay ngakang thonakam kuchek kuungk-kuungkang niiyang, puth nilaniya Ngeen-Wiy Min God.antaman ngul kuchow niiyant, ngangkangan ngoonchow niiyantangan.” ");
INSERT INTO wim_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ngul-ngulaniya nil Jesus.ana aak Nazareth anpalan wamp aak Galilee.ang anman, ngak punth Jordan aakanakan. Aꞌ nil John.angan kootra ngakangan kuungk nunang ngak punth Jordan angmana. ");
INSERT INTO wim_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Nil Jesus.an ngakaman pent-a, aꞌ nil um keny thath yuwan yaꞌ ik, aꞌ nil Ngeen-Wiy Min God.antaman thath nunang pal kenya uk-uk nungant keꞌ minh kolat yimanangan wamp nungant. ");
INSERT INTO wim_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Aꞌ wik inpal kenyan thaw, “Nint nhengk ngatharama! Ngay kaangk paththam wunang nungkar. Ngay ngangk min-minam paththam wunang nungkar.” ");
INSERT INTO wim_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Aꞌ an paththam yaam keꞌanam Ngeen-Wiy Min God.antam alangan kuch nunang aak pintalakan. ");
INSERT INTO wim_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Nilana yaam wun-wuna, kinchiya forty.akam, aꞌ nil oony wayan wamp-wampant yipam thaachow nunang wayan yumpow. Puth nil keꞌam wik ngeeyan wayan yumpow yaꞌa. Aꞌ putha minh kulliy yot thama angman wun-wunina, puth thana ngaantiyongk anangan wampin nungant aꞌ maꞌ-aathin nunang. ");
INSERT INTO wim_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Than John.an kanan thenchin nunang jailangan-a, nil Jesus.ana aak Galilee.akan iiy, aꞌ wik min God.antaman waaꞌ-waaꞌ thant pam wanchant. ");
INSERT INTO wim_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Nil thaw thant, “Aak nil God.angan miꞌ-a, an kan wampa! Aak anan thinth ngul kan wampana nil God.angan maꞌ nungantangan pam wanch yot ngulan piꞌow. Niiy wayan yaam keꞌ iiy-iiyāna, niiyan woyan min God.antamakan kan weentāna! Aꞌ wik min nungantaman ngangkang piꞌ-piꞌāna!” ");
INSERT INTO wim_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Anpalana, nil Jesus.an iiy-iiy thomp wonk wakan wak-waka kookam piꞌan Galilee angan, nil pam kucham thath pulang maꞌ-kuuncham anangana, namp pulantaniya Simona aꞌ Andrew. Puth pul al-alangan minh ngaꞌ mam-mampul punththamanangan. ");
INSERT INTO wim_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesus.an thaw pulant, “Nip pal ngatharang iiyowa! Nipaniya minh ngaꞌakam iiy-iiyuwwey ey? Puth inpalan ngula, ngay puth thaaꞌ-aath-aathāng nipangweya aꞌ nipaniya iiy-iiyow, pam wanch yota yal-yalmathow thanang ngathara.” ");
INSERT INTO wim_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Pul maꞌ-kuunchamanganiya punththamanan erkam wantpulweya aꞌ puth iiypul ngul Jesus.antangana. ");
INSERT INTO wim_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Aꞌ Jesus.ana thaaꞌ puyam ngul iiy-iiya aꞌ maꞌ-kuuncham thon ngul thath, namp pulantaniya James aꞌ John, pul puk wuut pam namp Zebedee alantaman. Pulaniya chukkun thanttamangan nyiinpul, pulan puth min-minam yumppul punththaman anangan minh ngaꞌakana iiyayn. ");
INSERT INTO wim_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Nil Jesus.angan thath pulang-a, nil ump pulang nungantangan iiyowpul. Pulaniya piip-kunch wantpul nunang aꞌ pam anangan workan iiy-iiyin nungant, than thampang puth chukkunang workan iiy-iiyin. ");
INSERT INTO wim_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Anpalana, nil Jesusa aꞌ putha than ngurp nungantam anangan aak town many Capernaum.ak wampin. Aak Saturday ngulan wun-a, nil Jesus.ana church thanttam Jews al-alantaman angan ngoonch aꞌ kan-ngul wik God.antaman thaaꞌ-aath thanang pam wanch anangan. ");
INSERT INTO wim_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Than pam wanchang wik nungantaman ngeeyin-a, than yotaman thaaꞌam ikin, nilan puth wik keꞌ pam wiy al-alangan wik Moses.antaman waaꞌ-waaꞌin, an yimanangan yaꞌa. Puth nil Jesus.ana wik thaw-thawa keꞌ pam God.angan kuch nunang, wik min anman waaꞌ-waaꞌ thant. ");
INSERT INTO wim_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Yaam keꞌan-a, nil pam oony way ngangkang piꞌ-piꞌ-a, anan ngoonch churchangan aꞌ othamayan paththam pech pam weenth ananiya, ");
INSERT INTO wim_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Ayyang, Jesus-ang! aak Nazareth anpalan wampan ey! Nint pal ngeenak wampan ngant e? Nint yipam nganang pam wanch yotaman mulathān ey? Puth ngay nintang meeꞌmiya — nint in pam ngench thayana, nil God.angan kuch nintang!” ");
INSERT INTO wim_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Nil puth Jesus.angan oony way anan thaaꞌ-thayanam wak nunang, pam alantangan ngangkangan wun-wun, “Nint appapa! Aꞌ pentān nungantam ngula pam nalantamana!” ");
INSERT INTO wim_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Amanaman-a, nil paman kemp akangam than-than, oony way alangan wunyathana. Anpalaniy-a, nil oony wayana othamayan pecha, aꞌ pent ngul pam alantaman. ");
INSERT INTO wim_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Than pam wanch churchangan nyiin-nyiinin-a, an than thaaꞌam ikina, aꞌ than kan-ngul thaw-thawin thanttakamana, “Ayyang, in wanttak e? Nil pam inana wiy-wiyama! nil keꞌ than wiyangan thaaꞌ-aathantan yimanangan yaꞌa! Apey! Nil oony way anangan kenthan thanang, thanan putha wik ngeeyin nunang!” ");
INSERT INTO wim_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Aꞌ anpalaniya than pam wanchangan wik thooꞌ Jesus.antaman puy-puyam weꞌ-weꞌarathin, aak angman pungk-pungkalang Galilee wakan. ");
INSERT INTO wim_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Amanamaniy-a, Jesus-a, aꞌ ngurp nungantam anangan churchaman pentin aꞌ than aawuch Simon.antam pulantam Andrew.antamakan yuurpam iiyin, Jesus-a, James-a, John-a, aꞌ ngurp nungantam wiy anangan thamp. ");
INSERT INTO wim_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Piny-kench Simon alantamana bedang wun-wun, weech-weechan nunang, ngunthamang uwan, kemp nungantamana karkan pey. Nil Jesus.an wamp-a, thanan waaꞌin nungant. ");
INSERT INTO wim_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Anpalaniya, nil Jesus.ana wanch alpan alantan iiya, aꞌ maꞌ maman nunang, aꞌ maꞌ-aath nunang ekow. Aꞌ nil erkam miyal ngul wun, kemp karkanamana yaꞌ-ngula. Anpalana nil may ngul aath-aath thanang. ");
INSERT INTO wim_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ngul-ngulaniy-a, kinchan uk-a, ngaaꞌ kan-ngulan chint-a, pam wanchangan kampan thanttam anangan wamp-wampathin thanang nungant Jesus.antan, puth thanangan weech-weechan aꞌ wiy anangan wampathin nungant than anangan puth oony way ngangkangan piꞌ-piꞌin. ");
INSERT INTO wim_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Pam wanch maꞌmangkam aak town anpalan karpam yalmathwin thanttakam aawuch Simon.antamang angman, yoon than-thanin. ");
INSERT INTO wim_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Nil Jesus.angan pam wanch anangan nguntham wiy-wiyam thakan uwin-a, miyalath thanang, aꞌ nil oony way anangan kenth thanang ngangk pam wanchantam anpalan. Aꞌ nil thaw thant oony way al-alantan appap wunayna, puth thanan kan meeꞌmiy an nil Christ.ana, God.antaman wamp. Puth than oony way anangan nath ngul moꞌin. ");
INSERT INTO wim_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ngaaꞌ thonangana, aak ngaaꞌangan yippakan wun-wun-a, nil Jesus.an ek aꞌ aawuchana want ngul. Nilan aak town anpalan iiy aak enyanakan, aak pam wanch keꞌanangana, aꞌ nil angmana meeꞌ-wuthanama. ");
INSERT INTO wim_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Puth nil Simon Peter.ana, aꞌ ngurp nungantam wiy anangan thanan wenk-wenkin nungant. ");
INSERT INTO wim_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Aꞌ thanan uwin nunang aꞌ thawin nungant, “Ayyang, than pam wanch yotama wenk-wenkantan nungkara!” ");
INSERT INTO wim_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Nil puth Jesus.an thaw thanta, “Ngamp mak iiy-iiyāmp villages thon-thonakana yam-yaman than-thantana. Ngay pam wanch wiy anangan thamp thaaꞌ-aathāng thanang, wik min God.antaman waaꞌāng thant. Ngay puth keꞌ-paal aak iikanakan ukang pal kenyana.” ");
INSERT INTO wim_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Aꞌ anpalana, nil Jesus.an village thon-thonakan iiy-iiy aak Galilee angman. Nil church thon-thonangan wik min God.antaman waaꞌ-waaꞌ thant, aꞌ oony way anangan kenth thanang ngangk pam wanchantam yotam al-alantaman. ");
INSERT INTO wim_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Nil pam thonam aak angman wun-wuna, pam inaniy-a, wenchangam makan iiy-iiy kemp wakanangana. Aꞌ nil Jesus.ant wamp, aꞌ pungkang nyiinant. Nil thaaꞌ-mamanang thaw nungant puth maꞌ-aathow nunang. Nil thawant, “Ayyang, Moom-ang! Nint kaangk nathweya min yumpin ngayangan-a, ngay puth kan meeꞌmiy nintang nint minam yumpin ngayangana.” ");
INSERT INTO wim_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Nil Jesus.angan ngangkwey mam nunang, aꞌ nil maꞌ ongkaram, aꞌ paman mam nunang, aꞌ thaw nungant, “Ngay kaangk inman miyalathāng nintangweya, nint kemp min ngul iiy-iiyāna!” ");
INSERT INTO wim_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Aꞌ wenchan erkam wuthanam nungant, yaꞌ-ngul ween. ");
INSERT INTO wim_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Anpalaniy-a, Jesus.an wik thayan thawant, “In ngeeya! Nint keꞌ waaꞌān thant wiy al-alantan ngayan nintang miyalathangan. Nint kan erkam iiyān pam priest alantan, nil yipam nintang thathow kemp min ngulan, wenchan yaꞌ-ngul weena. Anpalan-a, nint minh thakan kalān aak ngench thayanakan, aꞌ angan thaaꞌ-kuumpān nunang, piip God.an. Puth wik Moses.angan anman waaꞌ. Anpalan-a, pam wanch yotang ngul thathayn, aꞌ thiichayn nintang kemp min, wench keꞌanang ngulana.” Aꞌ nil Jesus.an kanan wik thawant-a, nil kuch nunang ngula. ");
INSERT INTO wim_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Puth nil paman-a, iiya, aꞌ wikan pal-puy waaꞌ-waaꞌ, yotangam ngeeyin wik inan Jesus.antaman. Nil pam alangan wikan puy-puyam ngul waaꞌ, yaa, anpalaniya, nil Jesus.an keꞌam ngul townakan ngoonch, meeꞌ yotantangan. Nil aak enyanang wun-wun, aꞌ pam wanch yot anangan aak nath-nathpalan wampin nungant. ");
INSERT INTO wim_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Nil Jesus.an maꞌ-koꞌalam paanth aak enyanangan, aꞌ koyam ngul wamp aak Capernaum.ak. Than pam wanch al-alangan thathin nunang wampan-a, wik thooꞌ weꞌarathin thanttakam. ");
INSERT INTO wim_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Anpalan-a, pam wanch yot wampin nungant aawuchang nilan wun. Yot anangan aawuchang ngoonchin, aakana thupam ngath ngul. Nil yoonan yim-yimanang yot anangan than-thanin thaaꞌ aawuchang angan. Aꞌ nil Jesus.angan wik minan waaꞌ thant. ");
INSERT INTO wim_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","An-aniyangan-a, pam koꞌalamang pam kunpwey wampathin, nil pam alpanan pengkarang wun-wunwey, makar yaꞌ yalamant, keꞌ-paal nilan keꞌam iiy-iiy. ");
INSERT INTO wim_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Than keꞌ pek kaliythan nunang Jesus.antan-a, puth yaꞌa, puth aak thaaꞌ-thupam ngath, pam wanch yota! Than wanttak ngoonchathiythan nungant Jesus.antana? Aꞌ puth than aawuch keny matathin nunang roofak, aꞌ roof wiyan thapathin pal kenyan nil Jesus.an than-than. Kanan thapathin-a, than pam alpanan pengkarang ukathin nunang Jesus.antan. ");
INSERT INTO wim_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Nil Jesus.angan thath nunang-a, nil kan meeꞌmiy thanang pam koꞌalam ananganiya kan-kanam paththam minam ngaantam-ngeeyin nunang nil ngul miyalathow nunang pam alpanan, aꞌ nil thaw pam alpan alantan, “Ayyang, nhengk ngatharam-ang, way nintan yump-yumpan-a, an yaꞌ-ngula, ngay keꞌ-ngul ngaantam-ngeeyānga, yaꞌa!” ");
INSERT INTO wim_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Than pam piꞌ-piꞌanam wiy anangan wik thayan thaaꞌan-aath-aathin thanangan-a, angman nyiin-nyiinin, thanan ngaantam-ngeeyin thanttakaman, ");
INSERT INTO wim_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Nil inan Jesus.an wanttake? Nil keꞌ God.an waaꞌ-waaꞌan nungantakamana! Nil God thonakaman ep thawiy ngampar nil keꞌ-ngul ngaantam-ngeeyow way ngampan yump-yumpampa, pam wiyan keꞌ thawiythana, nil epa!” ");
INSERT INTO wim_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Nil puth Jesus.angan erkam thiich thanang than want-wanttakan ngaantam-ngeeyin thanttakaman. Nil puth thaw thant, “Niiy ngul ngeenak ngaantam-ngeeyaniy yimanangana? ");
INSERT INTO wim_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ayyang, in ngeeyāna! Ngay nyiingkan yimanangan thawang pam alpan alantan, ‘Ngay keꞌ-ngul ngaantam-ngeeyāng way nintan yump-yumpana.’ Yaa, niiy wanttak ngaantam-ngeeyaniya? An work piꞌan paththam ey? Nath yaꞌa, nath work many way-wayang, engkanang ey? Ngay nath wik inangan thawing alpan alantan, ‘Kan eka! Pengkar nungkaraman maayāna! aꞌ iiyān ngul aak nungkaramakan.’ An work piꞌan paththam ey? Nath yaꞌa, nath work many way-wayang engkanang ey? ");
INSERT INTO wim_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Yaa, ngay in kan meenathāng niiyant nil God.angan kuch ngayang, yipmam ngay thawāng thant pam wanchant, ‘Ngay keꞌ-ngul ngaantam-ngeeyāng way niiyan yump-yumpan. Ngay puth pam inman nil God.angan kuch.’” ");
INSERT INTO wim_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Anpalana, nil Jesus.an thaw pam alpan alantan, “Ngay inan thawāng nungka, kan ekāna aꞌ yuk pengkar nungkaram nanan-a, maayān, aꞌ kan-ngul iiyān aak nungkaramakan!” ");
INSERT INTO wim_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Than yot al-alangan thath-thathin nunang pam alpanan, aꞌ nil paththam erkam ek, than ngul, aꞌ pengkar nungantaman wow maay, aꞌ iiy ngul aak nungantamakan. Than pam wanch yot anangan ngangk ikin thathinan nunang aꞌ thanan thaaꞌ-kuumpin nunang piip God.an. Aꞌ thanan thawin, “Ngan puth keenk work min yimanangan keꞌ thathan, ngan in-ngulan thathana.” ");
INSERT INTO wim_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Amanamaniya, nil Jesus.ang want thanang, aꞌ nilana koyam kan-ngul iiy kookam piꞌan aakanakan, Lake Galilee.an waaꞌantan. Aꞌ pam wanch thaaꞌ-wantanam wampin nungant, aꞌ nil wikan kan-ngul thanang thaaꞌ-aath-aath. ");
INSERT INTO wim_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Aꞌ nilan iiy-iiy-a, pam namp Levi anan thath nunang, pam nilaniy wukalan yal-yalmath Government.antan, nilaniya, office.ang nyiin-nyiin. Pam Levi inana, puk nhengk nungantam, pam namp Alphaeus.antam. Nil Jesus.ana ang wamp nungant, aꞌ thawant, “Awey, nint ngayang monkan-wakāna.” Aꞌ nil Levi.ana erkam ek aꞌ monkan-wak Jesus.an. ");
INSERT INTO wim_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Anpalaniy-a, nil Jesus.angan may mungk nungantang, Levi.antang aawuch. Pam wanch yot wampin, thanan puth monkan-wakin nunang Jesus.an — wiy anangan-a, keꞌ Levi yimanangana wukal yal-yalmathina Government.anta, wiy anangan-a, pam wanch kaangk-keꞌanang anangan. Than tham karpam nyiinina, aꞌ may mungkin thanttang, Jesus.antang, aꞌ ngurp nungantam al-alantang. ");
INSERT INTO wim_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Aꞌ than pam teachers wik thayanan thaaꞌ-aath-aathin Pharisees al-alangan thathin nunang Jesus.an nyiin-nyiin thanttangan, pam wanch kaangk-keꞌanangantang. Aꞌ thanan mepin thanang ngurp Jesus.antam anangan, “Nilan ngul ngeenak may mungkan pam wanch way al-alantanga?” ");
INSERT INTO wim_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Nil Jesus.angan ngeey thanangan-a, nilan thaw thant, “Than pam wanch keꞌaman weechanan thanang-a, an keꞌam iiyantan nooyananta, yaꞌa. Pam wanch weechanan thanang-a, an ep iiyantan nooyanant. An ngayan yimanangana. Ngay keꞌam wampanga yipmam pam wanch anangan umpāng thanang than minan waaꞌwuntan, yaꞌa. Ngayan ep wampanga yipam pam wanch way anangan umpāng thanang thanan yipam ngayang monkan-wakayn.” ");
INSERT INTO wim_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ngaaꞌ thonan-a, than ngurp John.antam anangan aꞌ puth ngurp thanttam Pharisees al-alantamana, thanan kinch ongkan may keꞌam mungkin, meeꞌ-wuth-wuthanamin anman. Aꞌ than pam wanch wiy anangan wampin nungant Jesus.ant aꞌ thawin nungant, “Ayyang, nint kan waaꞌān nganta! An wanttak aa? Than ngurp nungantam John.antamana aꞌ ngurp Pharisees al-alantaman thanana maꞌ-yotam may keꞌ mungkantan. Puth ngurp nungkaram nanangana, than kaangk may anman mungk-mungkayna. An ngeenaka?” Thanan yimanangan thawin. ");
INSERT INTO wim_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Nil puth Jesus.an thaw thant, “Niiy kan wik kath inan ngeeyāna! Pul pam wanch nath ngentuwpul-a, thanan nath may piꞌan yumpayn wedding party aakanakan. Niiy ngul thawin thant ey? pam wanch kampan pulantam anangan may keꞌan mungkayn ey? an yaꞌa, nil pam kompan wanchan ngentow-a, nil angman thintham iiy-iiyow thanttang, aꞌ thananiya karpam may mungkayn. ");
INSERT INTO wim_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Puth aakan ngul wampowa, than pam wiyangan pam kompan nath kalayn nunang aak thonanganakan, kampan nungantam al-alangan keꞌ-ngul thathayn nunang. Puth aak an-aniyangan-a, than may thanttaman too ngul wantayn, aꞌ meeꞌ-wuthanamayn.” ");
INSERT INTO wim_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Nil wik kath inan waaꞌ thant, “Nil wanchang kulich kath ikanam piꞌ-piꞌiywey-a, an ngul nilan ngook nyiingkanam manyan ikathiy ey? Puth ngook kathan ik-a, angan wakiy ey? An yaꞌa, puth ngook nyiingkanam manyam kenyam yalamiy, aꞌ puth-putham ngul ikiy, yuutamp piꞌanana ngul wuniya.” ");
INSERT INTO wim_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Anpalaniya, nil Jesus.angan wik kath thon ngul waaꞌ thant, wik kath minh peꞌan sheepantaman, puth aak thant wun than ngak wine.an yeech-yeechin minh peꞌan sheepantamang keꞌ ngaꞌalangk wun yimanangana. Aꞌ nil Jesus.an thaw ngul, “Than pamangan wine nyiingkanaman peꞌan kath al-alantangan keꞌam yeech-yeechin. Nil peꞌan kathaman angman yeechiywey-a, puth peꞌanan ikiy aꞌ wine.an yaꞌ-ngul wuniy, peꞌanan way paththam ngul wuniy. Nil pamangan wine nyiingkanaman peꞌan nyiingkanamang yeechow yipam minam wunow wine.aniy.” ");
INSERT INTO wim_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Nanpalaniya Jesus-a, ngurp nungantam anangana than woyan wakin, aak may wheatan kaampin. Aak anana Saturday. Aak thanttam Jews.antaman yimanangan wuna, than aak Saturday.ana work keꞌam iiy-iiyin. Than iiy-iiyin-a, than ngurp Jesus.antamangan may wheat thuthin mungkanakan. ");
INSERT INTO wim_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Than pam Pharisees al-alangan thathin thanang aꞌ than thawin nungant Jesus.antan, “Ayyang, than pam nal-nalangan may wheatan ngeenak thuth-thuthantan e? Aak in Saturdaya! Aak ngampar wuna ngench thayanant e! Than wik ngench thayanan pip-pipantan ey?” ");
INSERT INTO wim_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Nil Jesus.ana thaw thant, “Niiy ngul wik inan keꞌam ngeeyan ey? Nil David aꞌ pam nungantam anangan may keꞌanangan wunin ey? an-aniyangan nil Abiathar.an moom piꞌanan churchakan iiy-iiy. Than meech wun-wunina. ");
INSERT INTO wim_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Nil David.ana churchak iiy, aawuch God.antamak, aꞌ angana ngoonch aꞌ may bread ngench thayanan maay, thanana mungkin ngul. In wik thayan ngamparamana yimanangan wunan thanam priests al-alangan thonakaman may breadan mungkayna, — ngul nil David.angana ep mungk ey! aꞌ putha pam nungantam al-alantan theeꞌ thant.” ");
INSERT INTO wim_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Aꞌ nil Jesus.ana putham thaw thant, “Nil God.angan aak Saturday.an yumpa aak min wunow pam wanchantan. Nil keꞌama yump aak Saturday.ana pam wanchangan wik thayan anman ngaantam-ngeeyayn, aakanakan yaꞌa. ");
INSERT INTO wim_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Puth ngayana, pam inan nil God.angan kuch ngayang niiyant, ngayam thonakam ep thawanga than pam wanch want-wanttakan iiyayn aak Saturday.ana, puth ngay inana moom piꞌan niiyantama, Saturday.akan thampa.” ");
INSERT INTO wim_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Anpalaniya, nil Jesus.an koyam ngul iiy aak church Jews.antamakan. Nil aak angmana nil pam inan maꞌ makar yaꞌ yalam nungant, nilan angman nyiin-nyiin. ");
INSERT INTO wim_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Than pam wanch wiyangana Jesus.an thath-thathin nunang nil nath paman maꞌ min yumpowa, nath yaꞌa, puth aak anan Saturday, aak ngench thayan wun thanta. Thanana meeꞌangam kalin nunang, than puth kaangk wik aak-yaꞌangan waaꞌ-waaꞌayn nunang wiyantan. ");
INSERT INTO wim_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Nil puth Jesus.an pam alantan thawa, “Nint pal ingan iiyāna yotangan yipam thathayn nintang.” ");
INSERT INTO wim_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Anpalan-a, nil thaw thant pam wanch al-alantan than churchangan nyiin-nyiinin, “Ayyang, niiyalang! Kan niiy in ngeeyāna, nil wik thayan ngamparaman wanttak thawan e? An ngul kan ey? Ngamp ngul min anman kaangk iiyāmp thant pam wanchantan aak Saturday.angan ey? Yaꞌ nathweyiy-a, ngamp nath kaangk way anman iiy-iiyāmp thantwey ey? Puth ngamp kaangk pam wanch anangan kaaꞌ-piichanathāmp thanang ey? Yaꞌ nathwey-a, ngamp kaangk nath wayathimp thananga.” Puth thanan angman ngul nyiin-nyiinin, popam. ");
INSERT INTO wim_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Nil Jesus.an weent aꞌ pal-puy thath-thath thanang, aꞌ nil man kul wamp thant pam wanch al-alantan puth nilan ngangk way wun thant puth thanan kuchek-thayan anman iiy-iiyin, wik min-minam keꞌam ngeey-ngeeyin nunang. Anpalana, nil pam alantan thaw ngul, “Ayyang, nint maꞌan ongkarathāna!” Nil puth pam alangana maꞌan ongkarath, aꞌ maꞌan minam ngul wun. ");
INSERT INTO wim_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Than puth Pharisees al-alangan churchan erkam wantin aꞌ yalmathwin thanttakam ngurp Herod.antam al-alantangan. Thanan wik yumpin thanttakaman Jesus.an yipam mulathayn nunang. ");
INSERT INTO wim_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Nil Jesus-a, putha ngurp nungantam anangan than kan-ngul iiyin kookam piꞌanak Galilee.aka, aꞌ pam wanch thaaꞌ-wantanamang monkan-wakin nunang — pam wanch aak nath-nathpalan wampin Jesus.antan — aak Galilee.ama, putha aak Judea.ama, ");
INSERT INTO wim_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","aꞌ aak Jerusalem anpalana, putha aak Idumea.ama, putha aak anpalan Jordan River wonk pal kaawangka; aꞌ puth aak towns Tyre-a, Sidon anpalan. Than pam wanch aak anpalman wampin nungant Jesus.antan puth thanan wik thooꞌ ngeeyin nungantam nil miyalath thanang pam wanch yotama. ");
INSERT INTO wim_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Anpalan-a, nil Jesus.angana pam wanch alpan yot anangan miyalath thanang wayaman, aꞌ anpalana than wiy anangan puy-puyam thaꞌ-thaꞌwin nungantang wakan than yipam maꞌang mamayn nunang Jesus.ana aꞌ miyalamayn yipam. Pam wanch thaaꞌ-wantanam aak anganiy a! Jesus.an thaw pam ngurp nungantam al-alantan chukkun pal thinth-thinth wichayn nungant keenk wunowanta nil yipam angan nyiinow thanan keꞌ yipam wuthanathayn nunang. ");
INSERT INTO wim_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Puth pam wanch angan thampa oony way anangan ngangkangan piꞌ-piꞌina. Than Jesus.an thathin nunang-a, thanana umangam aakang keekin nungant aꞌ othamayan pechin nungant, “Nintiya puk nhengk God.antam ey!” ");
INSERT INTO wim_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Puth nil Jesus.an thaaꞌ-thayanam thaw oony al-alantan keꞌan wiy al-alantan waaꞌayn nilana nhengk God.antaman. ");
INSERT INTO wim_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Amanamaniy-a, nil Jesus.ana yoykang mat, aꞌ nil pam wiy anangan miꞌ thanang, aꞌ ump thanang wampayn nungant. ");
INSERT INTO wim_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Than kanan wampin nungant-a, nil Jesus.angan pam al-alantamana pam twelve miꞌ thanang nungantangan iiy-iiyayn, nilan yipmam kuchow thanang work nungantan iiy-iiyayn ngula. Nil thaw thant, “Ngay niiyang kan miꞌangan niiy yipam ngatharangan iiy-iiyān. Ngay niiyang ngul kuchāng wik min ngatharaman waaꞌ-waaꞌān thant pam wanchantan, ");
INSERT INTO wim_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","aꞌ maꞌ-kunch yumpāng niiyang, aꞌ maꞌ-aathāng niiyang, puth niiyaniya yipam oony way anangan pam wanchantaman kenthān thanang.” ");
INSERT INTO wim_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Pamiy namp inangan miꞌ thanang: Simona (ngul-ngulana Jesus.angana namp thon ngul theeꞌ nunganta, Peter); ");
INSERT INTO wim_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","aꞌ putha pul kuuncham James aꞌ John, nhengk nungantam Zebedee.antam (ngul-ngulan Jesus.angana namp thon ngul theeꞌ pulanta, Boanerges, wik yimanangan wun: pam keꞌ ngakan peeyana), ");
INSERT INTO wim_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","aꞌ putha Andrew-a, aꞌ Philip; puth Bartholomew, aꞌ putha Matthew, aꞌ puth Thomas, aꞌ puth James-a, nhengk nungantam Alphaeus.antama, aꞌ putha Thaddeus; aꞌ putha Simona thanan waaꞌ-waaꞌin nunang Patriot, nil puth aak nungantamakana kaangk wun paththama, ");
INSERT INTO wim_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","aꞌ puth Judas Iscariot. Nil pam ilangaman ngulan maꞌangan theeꞌow nunangan Jesus.an pam soldiers al-alantan mulathaynan nunang. ");
INSERT INTO wim_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Amanaman-a, nil Jesus.ana aakak iiy. Aꞌ pam wanch yotangan putham ngul wuthanathin nunang Jesus.ana, puth than yotweya! Nil Jesus-a, putha ngurp nungantam anangan than keꞌ may mungkiythan-a, puth yaꞌa, yot wampin thanta. ");
INSERT INTO wim_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Puth kampan nungantamang wik inan ngeeyinan-a, thananiya iiyin nungant yipam kalayn nunang thanttang, than puth pam wanch anangan thaw-thawina, “An nil weenth-weenthamana!” ");
INSERT INTO wim_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Than pam puungk wiy angman thampa, than anangan teachersa wik thayanan thaaꞌ-aath-aathinana aak Jerusalem anpalan wampina. Thananiy thaw-thawina, “Nil oony way piꞌan ngangkang piꞌ-piꞌan nunang a! Beelzebul.ana!” Puth puungk wiy anangan pam wanch thawina, “Nil oony way piꞌan alangana pam Jesus inan maꞌ nungantang piꞌ-piꞌan nunanga aꞌ maꞌ-kunch yump-yumpan nunang, keꞌ-paal nil oony way anangan kenthan thanang pam wanch al-alantamana.” ");
INSERT INTO wim_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yaa, nil Jesus.angana pam wanch anangan yota ump thanang nungant angan wampayn aꞌ nil wik kath ngul waaꞌ-waaꞌ thanta. Nil puth keꞌam wik engkanangan waaꞌ thant, yaꞌa. Nil wik yimanangan thaw, “Ngaywey nath kan-kanaman iiy-iiying maꞌ oony way alantangan-a, ngayan puth want-wanttaka oony wayan kenthāng nunangane? ");
INSERT INTO wim_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","25","Yaa, kan in ngeeyāna: than kampanam nathwey pek-pekwiythan-a, aꞌ thaamp-thaampwiythan thanttakamwey-a, yaa, than minam keꞌ piꞌwiythan thanttakaman yaꞌa, aak thanttamana thayanam keꞌ piꞌiythan, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Nil oony way alangan nathwey oony way wiy anangan piik-piikiy thanangan-a, pek-pekwiythan thanamana, thanan thampang aak thanttaman wayathiythan, minam keꞌ piꞌiythan, yaꞌa. Thanan puth karangk keꞌ-ngul iiyayn, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Aꞌ putha niiy in thampan ngeeyāna: nath weeꞌweya aawuchang pek wupam ngoonchiy aawuch pam karangk alantamangan-a, aꞌ maꞌ-kuchathiy way min min-miniy nungantaman-a, yaa, puth nil kaꞌathaman-a, pam karangkana kuuyang kathow nunang, aꞌ nilana kan-ngul ngoonchow aawuch nungantamangana. Nil keꞌwey kuuyangan kathiy nunangan-a, yaa, nil puth pam karangkan kul thawiy nungant aawuchangan keꞌan ngoonchow. ");
INSERT INTO wim_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Inan ngaantam-ngeeyāna! Than pam wanch wiy al-alangan nath way yot yumpiythan-a, aꞌ puth wik way thakan waaꞌiythan-a, an ep nath kon-ngathiy nunang piip God.an way thanan yump-yumpin, waaꞌ-waaꞌin thakan. Nungkway than maꞌ-yotaman way yumpiythan, waaꞌiythan thakan-a, nath kon-ngathiy nunang, piip God.an. ");
INSERT INTO wim_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Than puth weeꞌ-weeꞌanangwey wik way thakan waaꞌ-waaꞌiythan nunang Ngeen-Wiy Min God.antaman-a, nil puth God.aniya keꞌ kon-ngathiy nunang thanan way waaꞌ-waaꞌin yaꞌa, anman konangam piꞌ-piꞌow aak umpuyam.” ");
INSERT INTO wim_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","(Nil Jesus.an wik yimanangan thaw puth anpalan than wiy al-alangan waaꞌin nunang nil oony wayan ngangkangan piꞌ-piꞌ nunang.) ");
INSERT INTO wim_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Anpalaniy-a, kaath Jesus.antama puth kuunch nungantam anangan wampin aꞌ yoon angman than-thanin. Than wik kuchin nungant pentow thantana. ");
INSERT INTO wim_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Pam wanch yot anangan thintham nyiinin nungantangan-a, than thawin nungant, “Ayyang, kaath nungkarama puth kuunch nungkaram nan yoon than-thantan nungkara, than kaangk wik thawayn nungkar.” ");
INSERT INTO wim_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Aꞌ nil puth Jesus.an thaw thant, “Kaath ngatharaman puy weeꞌ e? Puth kuunch ngatharam thamp puy weeꞌ e?” ");
INSERT INTO wim_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Aꞌ nil thath thanang pam wanch yot anangan nungantangan nyiinin-a, aꞌ thaw, “Ayyang, in ngeeyiy a! Than inangana keꞌ kaath ngatharama putha than keꞌ kuunch ngatharam thampa! ");
INSERT INTO wim_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Than weeꞌ-weeꞌananganweya natha piip ngatharam in kenyana wik ngeey-ngeeyiythan nunangan-a, an than keꞌ kampan ngatharam yimanangana, kaath-a, kuunch yimanangan iiy-iiyantan.” ");
INSERT INTO wim_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Anpalaniy-a, nil Jesus.an koyam iiy kookam piꞌanakan, Lake Galilee.an, aꞌ aak angan-a, nil putham ngul thaaꞌ-aath-aath thanang pam wanch anangan. Pam wanch thaaꞌ-wantanaman yalmathwin nungant, wuth-wuthanathin nunang. Yaa, nil puth Jesus.angan-a, chukkun thath, ngakangan than-than aꞌ nilan aakanakan iiy, chukkunangan chang pey, aꞌ angan nyiin. Than pam wanch yot anangan-a, thomp wonkangama than-thanin, ngeey-ngeeyin nunang. ");
INSERT INTO wim_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Nil wik kath waaꞌ-waaꞌ thant, nil koochanam keꞌam waaꞌ thant, keꞌ wik kath anman waaꞌ-waaꞌ thant. Nil wik kath inan waaꞌ thant: ");
INSERT INTO wim_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Niiy kan in ngeeyāna: nil pam thonaman iiy-iiy may kaanch manyiy aakangan theeꞌ-theeꞌ thanang palam puyam yipmam may anangan emayn. ");
INSERT INTO wim_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Nil may kaanch anangan maꞌang theeꞌ-theeꞌ thanang-a, wiy anangan-a, woyan wakanang keek-keekin. Anpalan-a, minh panch anangana aakang ukin aꞌ mungk-mungkin thanang. ");
INSERT INTO wim_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Puth may kaanch wiy ananganiy-a, aak kunttowthiyang angan keekin, aak ngaanhan manya. Yiikan anangan-a, erkam pentin, puth aak ngaanhan many kenyangkaniya. ");
INSERT INTO wim_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ngul kinch keny ngulan wun-a, pung karkanang wuk-wuk thanang aꞌ than erkam akaramin, ngeenama, puth yuk thinka pek kech keꞌam kuch, yaꞌa, puth aak ngaanh manya, aak kunttowthiy. ");
INSERT INTO wim_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","May kaanch wiy ananganiy-a, aak waakamthiy angan keekin, yiikan anangana aꞌ putha wak wayananganiya than karpam pentin, emin ngul. Kaꞌathamaniy-a, yuk minam emin, amanamaniya, wak way al-alangan mulathin may min anangana, mayana keꞌ-paal keꞌam kalin. ");
INSERT INTO wim_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Puth may kaanch wiy ananganiy-a, aak minang keekin. Than yiikanana pentin, aꞌ ep minam em-emin, aꞌ ngul-ngulan-a, may yot kalin thanang. Wiyang may kootra chil yot kalin, thirty, wiyangan-a, sixty kalin, wiyangana may yot kalin thanang, one hundred kalina, thaaꞌ-wantanam. Anman kan.” ");
INSERT INTO wim_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Aꞌ nil Jesus.an thaw thant ngul, “Niiy wik ngatharam kanam ngeeyan ey? Yaa, niiyiya konangam piꞌān thanang.” ");
INSERT INTO wim_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ngul-ngulan-a, nil Jesus.an pokkap ngul nyiin. Ngul than wiy anangan wampin nungant, ngurp nungantam anangan-a, aꞌ puth pam wanch wiy anangan thanan wik kath may kaanchantaman ngeeyinana, than anangan wampin. Than engkin nungant wik kathan koochanathow thant. ");
INSERT INTO wim_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yaa, nil Jesus.an thaw thant, “Nil God.anganiy-a, kaangk wik nungantaman engkanang wunow niiyant, niiyan yipam meeꞌmiy wik ngench nungantam anangana, wik inangana: nil pam wanch yot anangan ngul piꞌ-piꞌow ngampang maꞌ nungantang. Puth ngay pam wanch wiy al-alantan wik koochanam keꞌam waaꞌang, ngay wik kath anman waaꞌang thanta, ");
INSERT INTO wim_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","yipam, ‘Thanan thath-thathayn ngayang, aꞌ puth ngeey-ngeeyayn ngayang, puth wik kathaniy-a, wik wuthanang wunow thant, wik God.antaman keꞌ yipam thiichayn, yaꞌa. Than nath wik nungantaman minam ngaantam-ngeeyiythanwey-a, an than woyan way anpalana weentiythana, woyan God.antaman ngul wakiythan, nil yipam keꞌ-ngul ngaantam-ngeeyow way thanan yump-yumpin.’” ");
INSERT INTO wim_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Anpalaniya, nil Jesus.an thaw thant, “Niiy wik kath inan ngayan waaꞌang niiyant engkanang keꞌam ngeeyan ey? yaꞌ ey? Niiy want-wanttak ngul wik kath wiy anangan minam ngul ngeeyāna? ");
INSERT INTO wim_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Yaa, in ngeeyān a! Ngay wik kathan koochanathāng niiyant. Nil pamangan-a, may kaanchan aakang theeꞌ-theeꞌanan-a, an keꞌ nil pam anan wikan waaꞌ-waaꞌan God.antamana. ");
INSERT INTO wim_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Pam wanch wiy al-alangan wik God.antaman ep ngeeyantan, ngul yaam keꞌanangan-a, nil oony wayan wampan thant, thawan thant wik keꞌ ngeeyayn. Ngul thananiy-a, oony wayan ngeeyantan nunang, keꞌ-ngul God.an monkan-wakantan nunang. Inaniya, keꞌ may kaanch anangan woyan wakanangan keekin, aꞌ minh panchangana mungkin thanang. ");
INSERT INTO wim_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Pam wanch wiy ananganiy-a, keꞌ may kaanch anangan aak kunttowthiyangan angan keekinwey. Than il-ilangan wik God.antam ngeeyantan, aꞌ erkam ngangk min wun thant, ");
INSERT INTO wim_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","puth yaana manyamweya, than puth yaam keꞌam ngangkang piꞌ-piꞌantan wik anangan, yaꞌa. Than wiy al-alangan nath way yumpiythan thantweya, nath thaaꞌ-thengkathiythan thanangweya, puth imanama than wik God.antaman ngangkang piꞌ-piꞌantan, thananiy-a, woyan nungantaman erkam wantantan, wik nungantaman kon-ngathan ngul thanang. ");
INSERT INTO wim_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Pam wanch wiy ananganiy-a, keꞌ may kaanch anangan aak waakamthiy angan keek-keekin. Than il-ilangana wik God.antaman ngeeyantan. ");
INSERT INTO wim_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Puth amanamaniya, than ngaantam-ngeeyantan thanttakaman than want-wanttakan maꞌmangkiy iiyiythan aꞌ putha want-wanttakan may thakan piiy-piiyayn, aꞌ kuchek way wunan thant. Aꞌ than thanttakaman ngaantam-ngeeyantan than ngangk min yipam wunayn, maꞌmangkiyan yumpwuntan, puth woyan God.antaman kon-ngathan thanang ngula, ngul anpalaniy-a, than wayamantan, min paththamana keꞌ-ngul yump-yumpantan, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Puth pam wanch wiy ananganiy-a, keꞌ may kaanch anangan aak minangan keek-keekin. Than il-ilangan wik God.antam anangan ep minam paththam ngeeyantan aꞌ ngangkang piꞌ-piꞌantan. Than woyan God.antaman wak-wakantan, aꞌ min yumpantan. Wiyanganiy-a, chil min yumpantan, wiyanganiy-a, min paththam yumpantan, keꞌ may kaanch anangan aak minangan keekin yimanangan, wiyang may kootra chil yot kalin, wiyangan-a, yota, aꞌ puth wiyangan-a, thaaꞌ-wantanaman kal-kalin thanang.” ");
INSERT INTO wim_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Amanamaniya nil Jesus.angan wik inan waaꞌ thant ngul, “Nil pamang nath lantern pathathiywey-a, an nganthan yuk paathangan kangiy ey? Yaꞌa! An keꞌ kangiya! Yaꞌa! Nil nath yuk wurp pek-pekam wunpiy ey? An yaꞌa! An keꞌ wunpiy, yaꞌa. An nil keny achantang waanchana yipam nganthangan aakan thathayn. ");
INSERT INTO wim_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Yaa, in ngeeyāna, ngay inan thawang niiyant: than pam wanchang kaꞌathaman wik mup thanttakaman piꞌ-piꞌiythan-a, ngul-ngulana thananiya wik engkanang ngul pentathayn. An yimananga — wik ngatharam anangan thenchanam wun-wunan yippak wiyantam — ngul-ngulana an ep-paththam than ngul thiichayn. ");
INSERT INTO wim_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Niiyan wik min-minaman ngeey-ngeeyān ngayang ngayan waaꞌ-waaꞌang niiyant.” ");
INSERT INTO wim_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Nil Jesus.an wik inan thamp thaw thant, “Yaa, niiyan wik ngatharaman minam ngeeyāna! Niiy nathiywey way waaꞌin wiy anangan-a, yaa, nil God.angan putha way waaꞌow niiyang keꞌ niiyan waaꞌaniy thanang, an nilana way ep-paththam waaꞌow niiyang. ");
INSERT INTO wim_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Yaa, in ngeeyāna: nil pam alangan wik min-minan ngeeyow ngayang-a, yaa, ngayan ngul maꞌ-aath-aathāng nunang nil yipam minam anman ngaantam-ngeeyow. Aꞌ puth thoniya, nil pamangwey ngaantam-ngeeyiy nungantakaman nilan wik kanaman thiich-a, puth nil keꞌaman wik ngeeyiy ngayang-a, yaa, ngayan puth keꞌ maꞌ-aathing nunang, aꞌ wik anangan-a, kon-ngathow nunang ngula.” ");
INSERT INTO wim_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Nil Jesus.aniya wik thonangan ngul thaw-thaw, “Aakan ngul wampow nil God.angan pam wanch yot piꞌ-piꞌow thanang maꞌ nungantangan. In keꞌ aak yimanangan wunana, keꞌ inana wik kath waaꞌāng niiyant may kaanch alantamana. Nil pamangweya may kaanch cornantama aak gardenang pal-puy theeꞌ-theeꞌ. ");
INSERT INTO wim_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ngaaꞌ thon-thonan weepaman eka, aꞌ nil aak-aakanakaman iiy-iiy gardenak. Aak ngutang ngulan-a, nil weep ngul wun, nil yimanamana. Aak an-aniyangan-a, yiikan anangana pent-pentin ngul aakamana, em-emin-a, piꞌan ngul weenin. Nil puth pamaniya keꞌam meeꞌmiya yiikan anangan want-wanttakan pentin, emin thakana. ");
INSERT INTO wim_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Kaanch manyiy anangana than-thanam ngul pentin aakaman. Aꞌ puy-puyam ngul ongkaman, em-emin ngul, aꞌ may ngul piꞌow, aꞌ may paththam yotam ngul piꞌa. ");
INSERT INTO wim_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","May polpeyan ngulan-a, yaa, nil pamana nhengk-peempan thampana kan-ngul iiy, puth aakan kan wampant mayan umpow thanang mungkanakan.” ");
INSERT INTO wim_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Aꞌ nil Jesus.an thaw, “Aak ngul-ngulan-a, nil God.angan pam wanch yot maꞌ nungantangan piꞌ-piꞌow thanang. Aakan wanttak nath wunowa? ");
INSERT INTO wim_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Yaa, ngay kan wik kath inan waaꞌāng niiyant. Nil pam thonamangan-a, may kaanch thonam many pattakam kal aꞌ garden nungantam angan kaampa. ");
INSERT INTO wim_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Amanamaniya yiikanan ngul penta aꞌ em-em ngul yuk piꞌanakam. Minh panch yota nath-nathpalan moꞌ-moꞌin yuk aakanakamana aꞌ wurp yumpin ngul thanttakaman yuk angman.” ");
INSERT INTO wim_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Nil Jesus.angana wik kath yot yimanangan waaꞌ-waaꞌ thant pam wanchant, wik nungantaman thaaꞌ-aath-aath thanangana. Nilana wik many-many kuyam waaꞌ-waaꞌ thant than yipam pam wanchangana minam ngaantam-ngeeyayn kuchek thanttamangana wik nungantam anangana. ");
INSERT INTO wim_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Nil wik kath anman waaꞌ-waaꞌ thant. Than Jesus-a, ngurp nungantam weeꞌanangana, than-thanam ngulan nyiin-nyiininan-a, an ep-paththam nil wik maꞌmangkam anangan engkanang ngul waaꞌ-waaꞌ thantana. ");
INSERT INTO wim_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Nguta-ngutang ngulana, aak ngaaꞌ ngulan wun-a, nil Jesus.an thaw thant ngurp nungantam al-alantan, “Ayyang, ngamp woꞌuwaynak moꞌāmp a!” ");
INSERT INTO wim_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Yaa, than chukkunang chang peyin, chukkun angman nil Jesus.an keenkan nyiin-nyiin. Chukkun yot thaman ngakang angman than-thanin. Than pam wanch yot anangan want thanang, aꞌ than karpam ngul moꞌin. ");
INSERT INTO wim_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Anpalaniy-a, wunt piꞌan wunp aꞌ yeelal piꞌ-piꞌanam ek-ekin ngul, aꞌ ngakan kan thaaꞌ maay-maay chukkunanganiy. ");
INSERT INTO wim_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Nil Jesus.ana weep thayan wun-wun, kuchek pillow maak-maak, chukkun koy-koyyuw wun-wun. Than ngurp nungantam al-alangan weepam ekathin nunang, aꞌ thawin nungant, “Ayyang, moom-ang! Nint ngul wanttake? keꞌam ngaantam-ngeeyangan ey? ngamp ngul yotam inangan thuchāmpwey ey?” ");
INSERT INTO wim_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Aꞌ nil Jesus.an ek, aꞌ wik piꞌan thaw wunt alantan, “Kana! Appap ngula!” Aꞌ nil yeelal alantan thaw, “Kana! Enyan ngul wunāna!” Ananiy-a, wunt piꞌan yaꞌ-ngul weem, aꞌ yeelal piꞌanaman-a, ngakan enyan ngul ump, yaꞌ-ngul. ");
INSERT INTO wim_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Amanamaniy-a, nil Jesus.an thaw thant ngurp nungantam al-alantana, “Niiy ngul ngeenam winynyang moꞌaniy e? Niiy God.an keꞌam ngangkang piꞌ-piꞌaniy ey?” ");
INSERT INTO wim_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Puth thananiy-a, ngangk ikin, winynyang moꞌin, aꞌ thanan thawin thanttakaman, “Apey, nil ngul in wanttake? In nil pam wiy-wiyam ey? Wunt-a, puth yeelal alantan wik piꞌanan thaw-a, pulan-a, appap paththam wunpul, ana aak yaꞌ-ngul enyan paththam ween.” ");
INSERT INTO wim_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Nil Jesusa puth ngurp nungantam anangana, woꞌuwayn peyin chukkun thanttamang aak Galilee.am anpalan, aak pam wanch Gerasenes al-alantamakan. ");
INSERT INTO wim_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Aak angana nil pam wun oony way ngangkangan piꞌ-piꞌ. ");
INSERT INTO wim_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Nil aak kunttowangan wun aak than pam mul anangan kaamp-kaampin thanang, awar piꞌanangan wun-wun, nil thonakam, pam wiy-wiy yaꞌa, puth nil pam weenth, keꞌ-paal awarangan wun-wun. ");
INSERT INTO wim_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Than pam wiyangan maꞌ-yotam chainsangan maꞌ kathin nunang, puth yaꞌangam, nil chains anangan thuth-thuth, aꞌ than yuk chainsangan thaꞌangan kathin nungantang, puth yaꞌangam, nil yaꞌ nhanthath chainsana. Pam weenth anman an karangk paththam ween, than keꞌ mamiythan nunang nochathiythan nunang-a, popam piꞌiythan nunang-a, puth yaꞌangam ey! ");
INSERT INTO wim_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Kinchanga puth ngutang nil pam weenth anman pal-puy iiy-iiy, graves wakanang iiy-iiy, aꞌ puyam keny ngul yoyk wakanang iiy-iiy. Nil wik othamayan pech-pech aꞌ putha kunttow pepanang thak kemp nungantakaman ump-ump. ");
INSERT INTO wim_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Than Jesus weeꞌanang woꞌuwayn kanan wampin-a, than chukkun amanam ukin. Nil pam weenth alangan kecham thathan Jesus.an, aꞌ nil aak kunttow amanam pent aꞌ umang kamp othamayan moꞌ nungant Jesus.antan, aꞌ pungkang thuch nungant. ");
INSERT INTO wim_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Aꞌ nil Jesus.an thaw oony way alantan, “Nint kan pentān pam ilantamana.” Aꞌ nil pam weenthana wik othamayan pech, “Jesus ey! puk nhengk pam ngench wuut piꞌan alantaman ey! puk nhengk God.antam nintiya! Nint ngul ngeenak wampan ngathar e? Nint keꞌ wayathān ngayang! Nil God.angan ngeeyan ngayang ngay inan thawang nungk,” paman thaw Jesus.antan. ");
INSERT INTO wim_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Aꞌ nil puth Jesus.ana engk nungant pam alantan, “Namp nungkar wanttaka?” Nil paman thaw nungant, “Namp ngathiya, inana Moba, puth ngan yota!” ");
INSERT INTO wim_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Pam weenthana putham thaaꞌ-mamanang thaw-thaw Jesus.antan, “Nint oony way yot anangan keꞌ kuchān thanang aak inpalan.” ");
INSERT INTO wim_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Aꞌ minh nhinthan yot anangan kech keꞌan iiy-iiyin may mungk-mungkin, aak achantang kaaꞌ um pek kech woꞌuwakan. ");
INSERT INTO wim_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Aꞌ than oony way yot anangan thaaꞌ-mamanang thawin nungant Jesus.antan, “Nint nganang ang kuchān minh nhinthanantang ngoonchān thanttanga.” ");
INSERT INTO wim_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Aꞌ nil Jesus.an thaw thant, “Kan iiyāna!” Amanamaniya, oony way yot anangan pol-pol pent-pentin pam alantaman, aꞌ minh nhinthanantangana wupam ngoonch-ngoonchin maꞌmangkamantang minh nhinthan yot thaaꞌ-wantanama two thousanda! Minh nhinthan anangan kamp othamayan moꞌ-moꞌin aꞌ kaaꞌ um pek keekin ngakangan aꞌ mul wunin ngul. ");
INSERT INTO wim_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Aꞌ than pam anangan minh nhinthan anangan piꞌ-piꞌin-a, than kamp moꞌ-moꞌin, wikan pal-puy waaꞌ-waaꞌin pam wanch wiy al-alantan, aak townsang angan wun-wunin aꞌ puth thant aak farmsang angan wun-wunin thamp. Than pam wanchangan aak thanttaman too wantin, aꞌ aak-aakanakaman iiyin Jesus.antan yipam thathayn wanttakan nathan yump. ");
INSERT INTO wim_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Aꞌ than Jesus.antan wampin aꞌ than thathin pam oony way yotan kaꞌathaman ngangkangan piꞌ-piꞌ. Nil angman nyiin-nyiin minam ngul Jesus.antang, ngook thampa, aꞌ kuchek min ngul, keꞌam ngul weenth-weentham yaꞌ-ngul. Than pam wanch yot anangamana winynyang ngul moꞌin. ");
INSERT INTO wim_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Than pam wanch meeꞌmiy al-alangan waaꞌ-waaꞌin thant wiy al-alantan than keꞌaman thathin Jesus.angan oony way yot kuch thanang minh nhinthanantang ngoonchin ngul. ");
INSERT INTO wim_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Aꞌ than yotana kan-ngul thaw-thawin nungant Jesus.antan, “Nint kan-ngul aak inan wantāna.” ");
INSERT INTO wim_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yaa, than Jesus aꞌ putha ngurp nungantam anangan kan-ngul woꞌuwaynakan moꞌin. Nil Jesus.an keꞌ chukkunangan peyiy-a, nil pam anman Jesus.angan miyalath thaaꞌ-mamanang thaw nungant, “Ngayang keꞌ wantāna, ngay puy nungkarang iiyāng woꞌuwaynakan.” ");
INSERT INTO wim_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Puth nil Jesus.an thaw pam alantan, “Yaꞌa, nint pal ngatharang keꞌ iiyān. Nint paththam koyam iiyāna aꞌ waaꞌān thant kampan nungkaramantan, nil piip God.angan miyalath nintang, kuchek wayamana min ngul yump nintang, nil piip God.ana min-minam paththam iiyan nungkara.” ");
INSERT INTO wim_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Aꞌ pamana koyam ngul iiy kampan nungantamak, aꞌ nil aak thon-thonang iiy-iiy aak towns yotang tenang, nil waaꞌ-waaꞌ thant nil Jesus.angan miyalath nunang. Than yotamang wik inan ngeeyina ana than meeꞌam ikin. ");
INSERT INTO wim_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Anpalaniy-a, nil Jesus.an koyam woꞌuwayn moꞌ, thaaꞌ kuuwama. Aꞌ ngul pam wanch yot anangan yalmathwin nungantang. ");
INSERT INTO wim_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Anpalana, nil pam namp Jairus.an wamp, nil pam inman pam piꞌan churchakana. Nilan thath nunang Jesus.an-a, nil pungkang thuchant um nungantang, ");
INSERT INTO wim_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","aꞌ thaaꞌ-mamanang thawant, “Ayyang, puk nhengk ngatharaman way-wayam wun-wunana, wanch manya niliya. Nint keꞌ iiyin nungant ey? maꞌ keꞌ wunpin nungantang ey? keꞌ yipmam uthamowa, puth kemp miyal koyam wunow.” ");
INSERT INTO wim_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Nil Jesus.ana kan-ngul iiy nungantang Jairus.antangan, puth pam wanch yotangan angman wuthanathin nunang, Jesus.ana, pam wanch thaaꞌ-wantanama! ");
INSERT INTO wim_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Nil wanch thonam angmana, nilan wewmang want-want nunang kaap twelve.akam. ");
INSERT INTO wim_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Nilaniya wukal keꞌanang ngul puth nil wukal maꞌmangkam theeꞌ nooyan al-alantan. Puth thananiy wanchana keꞌam miyalathin nunang, yaꞌ, puy-puyam weechan nunang. ");
INSERT INTO wim_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Nila wanch alangan wik thooꞌ kaꞌathaman ngeey Jesus.ana, nil puth koy-koyyuw iiyant Jesus.antan. ");
INSERT INTO wim_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Nil nungantakam ngaantam-ngeey, “Ngay nath ngook nungantaman mamingwey-a, ngay kemp miyal koyam ngul weemānga.” ");
INSERT INTO wim_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Aꞌ nil ngook Jesus.antaman mamantam. Anpalaniya, wewmangan keꞌ-ngul want-wantan. Nilana kemp nungantaman ngeechan keꞌ-ngulan wewmangan want-wantowana, miyal paththam ngeechan ngul. ");
INSERT INTO wim_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","An-aniyangan-a, nil Jesus.angan kemp ngeechan nungamang nilan weeꞌ-nathan miyalathana. Nil erkam weent thant aꞌ thaw thant, “Ayyang, ngook ngatharaman weeꞌang mamar?” ");
INSERT INTO wim_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Than ngurp nungantam anangan thawin nungant, “Ayyang, nint thathān thananga! Inan puth pam wanch yota thaꞌ-thaꞌwuntan nungkarang wakana! Ngul nint wanttak thawan nil weeꞌang mam nintang a?” ");
INSERT INTO wim_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Nil puth Jesus.angan yotantan puyam thath-thath weeꞌang mam nunang. ");
INSERT INTO wim_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Nil wanchana kan ngaantam-ngeey nungantakaman nil Jesus.angan koyaman min kan yump nunang, nil puth winy-winynyang iiy Jesus.antan, aꞌ pungkang thuchant um nungantang, aꞌ waaꞌ nungant nilan kan-kanam ngook nungantaman mam. ");
INSERT INTO wim_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Nil Jesus.ana thawant, “Ayyang, nhengk ngatharam-ang, nint kan-kanam ngaantam-ngeeyan ngayangan, ngayan miyalathāng nintang. Anpalana, ngay kan-kanam puth miyalathang nintang. Nint kan-ngul ngangk minangam iiyān aak nungkaramakan, aꞌ kemp min anman iiyāna.” ");
INSERT INTO wim_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Nil Jesus.an wik inangan thaw-thaw yippak-a, than pam anangan wampin aawuch Jairus.antaman anpalana. Than thawin nungant Jairus.antan, “Puk nhengk nungkaram kanam uthama. Keꞌ thawān Jesus.antan aawuch nungkaramakan iiyowa. Nil aak-yaꞌang ngul iiya, pukan mul ngula.” ");
INSERT INTO wim_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Than nungkway thawin nungant-a, nil Jesus.an keꞌ-ngoongkam iiy-iiy, nil puth Jairus.antan thaw, “Nint keꞌa kuchek wayamāna, nint ngayangam anman ngaantam-ngeeyāna, ngayan ngul miyalathāng nunang.” ");
INSERT INTO wim_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Aꞌ nil Jesus.an iiy ngul Jairus.antang. Nil pam koꞌalam al-alantan thaw thant kuy theeꞌayn nunang; Peter-a, aꞌ puth pul kuuncham, James aꞌ puth John. Nil wiyantan thaw keꞌ iiyayn nungantang. ");
INSERT INTO wim_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Than kanan wampin aawuch Jairus.antam angan-a, nil Jesus.angan wik wolmp ngeey, pam wanch othamayanan peey-peeyin. ");
INSERT INTO wim_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Nil pek ngooncha, aꞌ thaw thant, “Niiy in ngeenak wik wolmp piꞌ-piꞌaniy a? Othamayan peey-peeyaniy thakana? Niiy keꞌa! Nil wanch manyan keꞌ uthama, yaꞌ, nil weep thonakama wun-wunan.” ");
INSERT INTO wim_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Puth pam wanchangan thaaꞌ-thengkathin nunang Jesus.an. Nil puth Jesus.angan-a, kenth thanang, yoon kuch thanang. Nilan kaath-kunch aꞌ piip-kunch aꞌ ngurp nungantam koꞌalam anangaman ep kal thanang pek ngoonchin puk manyan wun-wun. ");
INSERT INTO wim_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Aꞌ nil Jesus.an puk many alantan iiy, aꞌ maꞌ mam nunang, aꞌ thawant wik nungantamangan, “Talitha koum.” Wik ngamparamanganiya, “Ayyang, wanch manya, ngay thawang nungka, ekāna.” ");
INSERT INTO wim_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Aꞌ nil wanch manyana erkam paththam ek, aꞌ kan-ngul iiy-iiy. (Nil puk komanana kaap twelve wun.) Than inan thathin-a, than yaꞌ paththam meeꞌam ikin. ");
INSERT INTO wim_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Nil puth Jesus.an thaaꞌ-thayanam thaw thant, keꞌ waaꞌayn wiyantaniy. Anpalana, nil thaw thant may theeꞌayn nungant. ");
INSERT INTO wim_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Aꞌ nil Jesus.angana aak anana want ngul aꞌ nil iiy ngul koyam aak nungantamakan, ngurp nungantam anangan-a, karpam iiyin nungantangwey. ");
INSERT INTO wim_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Aak Saturday ngulan-a, aak thant ngench thayanan wun-a, nil Jesus.angana kan-ngul thaaꞌ-aath-aath thanang pam wanch anangan aak churchangan. Pam wanch yota angman churchangana, than wikan ngeeyin nunang Jesus.an-a, than yot anangana meeꞌam ikin, aꞌ thawin ngula, “Nil pam inana nil wik inangan want-wanttak thiich e? Nil inan wanttinpal kuchek waap minaniy uw e? Aꞌ puth nil work piꞌ-piꞌanam inangan want-wanttak yumpan e? ");
INSERT INTO wim_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Pam nil aawuchan kaach-kaachan yaꞌ ey? Puk otham Mary.antamaniy ey? Nil puth anman ey! Pam kuunch nungantama inanganante! — James-a, Joseph-a, Judas-a, aꞌ Simon, aꞌ putha wanch kuunch nungantam inangan wuntan e!” Than wik yimanangan thawin, thanan puth kaangk keꞌ wik ngeeyayn nunang Jesus.ana. ");
INSERT INTO wim_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Aꞌ nil Jesus.an thaw thant, “Nil weeꞌangan nathweya wik God.antamana waaꞌ-waaꞌiy kampan nungantamakaniy-a, than anangan keꞌ-keꞌam nungantama, puth keꞌ wik ngeeyiythan pam alantama, pam wanch wiy nath-nathan wuntan-a, than ep wik nungantaman ngeeyantan.” ");
INSERT INTO wim_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Nil Jesus.angana pam wanch alpan koꞌalam al-alantan thonakama maꞌ wunp thant aꞌ miyalath thanang, nil work piꞌ-piꞌanam yota keꞌ yumpiy thant aak angana, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Nil puth meeꞌam ika, than puth pam wanch aak anganan wun-wunin-a, keꞌam ngangk theeꞌin nungant, yaꞌa. Nil Jesus.ana aak angman pal-puyam iiy-iiy, aak village thon-thonan uw, aꞌ kan-ngul pam wanch thaaꞌ-aath-aath thanang. ");
INSERT INTO wim_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Aꞌ nil pam ngurp nungantam twelve anangan karpam yalmath thanang aꞌ thaw thant kuch-kucham iiy-iiyayn pam wanchant, wik minan waaꞌayn thant. Nil thaw thant aꞌ puth thayanam yump thanang yipam oony way anangan kenth-kenthayn pam wanch al-alantaman ngangkangan piꞌ-piꞌinwey. ");
INSERT INTO wim_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Aꞌ nil wik thayan thaw thant, “Niiy maꞌlip iiyāna, yuk pil thook thonakama kalāna. Niiy may breadana keꞌ kalāna, aꞌ niiy bag keꞌ kalān mayakan. Aꞌ niiy wukal keꞌ kalān. ");
INSERT INTO wim_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Niiy thaꞌ murrukana ngoonchāna, aꞌ putha niiy keꞌ kalān ngook kuchamana, thonam anman ep kalāna.” ");
INSERT INTO wim_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Aꞌ nil wik inangan thaw thant, “Niiy nathwey aak townang kanan ngoonchān-a, aꞌ than wiy anangan umang iiy-iiyiythan niiyantwey, aꞌ ngangk minangam ngoonchathiythan niiyangwey aawuch thanttamakan. Yaa, niiyaniy-a, aak angman wunān aawuch thanttamangan aꞌ anpalman ngul iiyān aak thonak ngulana. ");
INSERT INTO wim_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Niiy nathwey aak town thonak ngulan wampān-a, aꞌ than umang keꞌwey iiyiythan niiyantaniy, aꞌ puth than wik kaangk keꞌ ngeeyiythan niiyantam. Yaa, niiyaniya aak anana too wantāna, aꞌ thaꞌ wook wunyathān, puth anpalan than kaangk keꞌ wik niiyantaman ngeeyayn. Than thathayn niiyang yimanangan yumpān-a, thanan nath ngul ngaantam-ngeeyayn thanttakaman than way-wayam paththaman iiy-iiyantan.” Nil Jesus.an wik yimanangan thaw thant ngurp nungantam al-alantan. ");
INSERT INTO wim_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Amanaman-a, than kan-ngul iiyin, aꞌ wik minan kan-ngul thaaꞌ-aath-aathin pam wanchana, woyan wayan keꞌ wakayn, woyan min anana wakayn. ");
INSERT INTO wim_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Aꞌ oony yot anangan kenth-kenthin pam wanchantamwey ngangkangan piꞌ-piꞌin, aꞌ putha yuk olive oilan yeech-yeechin thanttang al-alantangan weech-weech thanangan, aꞌ amanamaniya than miyal ngul wunin. ");
INSERT INTO wim_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Anpalana, nil King Herod.angana wik ngeey Jesus.antamana puth wik thooꞌ kanam weꞌaram nungantam work piꞌ-piꞌanaman nilan yump-yumpan. Pam wanch wiy anangan thaw-thawin, “Nil pam nanman John.an ey? kuchekan kuungk-kuungk thanang ey? Nil mulaman kan ek ey? Nan nilama, nil keꞌ-paal work piꞌan nanangan yump-yumpana! Ngananiya keꞌ nunang thath-thathanana.” ");
INSERT INTO wim_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Puth wiy anangan thawin, “Nilana Elijah paththama!” Aꞌ wiy anangan thawin, “Nilana pam prophet ey? keꞌ pam prophets keenkanaman wunin ey?” ");
INSERT INTO wim_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Nil Herod.ang wik inangan ngeey-a, nil thaw, “Nil pam nanman John.ana! kuchekan kuungk-kuungk thanang! Ngay kaꞌathangaman thawangan thant kuchek nungantaman thalokang umpayn, puth nil mulaman koyam ek ey!” ");
INSERT INTO wim_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Nil puth King Herod.ana kaꞌathangaman thaw thant pam nungantam al-alantan workan iiy-iiyin nungant, “Ayyang, niiy pam nanan John mamān nunanga!” Aꞌ thananiya mamin nunang, aꞌ thap-thapam kathin nunang, aꞌ kalin nunang jailak. Nil Herod.angan puth kaangk keꞌ ngeeyow nunang John.angan wak-wakow nunang wanch nungantam alantaman, nil puth wanch pont-kunchan maꞌam piiyan Philip.anweya, nil ngul wanch nungantakam maayana, wanchaniy nampa Herodiasa. ");
INSERT INTO wim_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Puth nil John.ana nathpalman thaw-thaw nungant, “In min yaꞌa nint wanch nalantangan wun-wunangana. An wanch nungkar yaꞌa! An wanch pont nungkaram alantamana! Nint wik thayan God.antam pip-pipangan ey!” ");
INSERT INTO wim_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Nanpalaniy-a, nil wanch Herodias.angana ngangk-wayang kal-kal nunang, John.an, nil kaangk mulathow nunang, puth yaꞌa, ");
INSERT INTO wim_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","nil puth Herod.an winynyang moꞌ John.antaman, nil meeꞌmiy nunang pam min-minam paththam, nil keꞌ-paal week nunang wiyangan keꞌ yipam mulathayn nunang. Nil ngeey-ngeey nunang wikan waaꞌ-waaꞌ-a, kuchek way wun nungant Herod.antan. Puth nungkway kuchek way wunant-a, nil kaangk ngeeyow nunanga! ");
INSERT INTO wim_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Nil wanch Herodias.angana ngaantam-ngeey nungantakam nil John.an wanttakan mulathow nunang, nil puth kuup-kuup yippaka. Ngul anpalaniya, aakana kan wamp King Herod.antamakan birthday wun. Nil Herod.an thaw thant may piꞌanan yumpayn thant moom piꞌ-piꞌanant al-alantan, Government anangan-a, aꞌ puth thant moom thanttam soldiers al-alantaman, aꞌ puth pam wanch piꞌ-piꞌanam aak Galilee anpalman wampina. ");
INSERT INTO wim_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Aꞌ nil puk otham Herodias alantaman ngoonch-a, nil-nilam keeꞌ-keeꞌ meeꞌ yotantangana. Nil Herod.ana aꞌ pam wanch yotam anangana puth ngangk min wun thanta, nil puth King Herod.an thaw nungant wanch koman alantan, “Ngay inan kan-kanam thawang nungkara. Nint ngeenakan kaangk thawān ngath-a, an ngay theeꞌāng nungkaran.” ");
INSERT INTO wim_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Nil maꞌ-yotam thaw nungant nil kan-kanam kaaꞌngak nunang, “Ngay inan kan-kanam thawang nungkar. Nint ngeenakan kaangk thawān ngath-a, an ngay erkam theeꞌāng nungka. Nintwey thawān ngathwey-a, nint aak wiy anangan ngatharamana kaangk piꞌān thanang-a, an ngay puth theeꞌāng nungk.” ");
INSERT INTO wim_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Nil wanch komanana kaath-kunchant iiy, Herodias alantan, aꞌ thaw nungant, “Ngay puth ngeenak thawāng nunganta?” Nil kaath-kunchan thawant, “Nint thawān nungant kuchek John.antaman theeꞌow nungkara.” ");
INSERT INTO wim_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nil wanch komanan erkam koyam iiyant King Herod alantan aꞌ thawant, “Ayyang, nint ngathar kuchek John.antaman inman theeꞌān ngatha! aꞌ plate.ang pal kalāna!” ");
INSERT INTO wim_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","King Herod.antan-a, ngangk way wunanta, puth nilan kaangk keꞌ mulathow nunang pam John.ana. Nil puth keꞌ wik pipiw wanch koman alantan nilan thaw nungant kon yotantangana kuchek John.antamakana, ");
INSERT INTO wim_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","yaa, nil thaw nungant pam soldierantan kuchek John.antaman pal kalow. Nil pam soldieran iiy aꞌ John.ana mulath nunang, kuchek nungantaman thalokang ump, ");
INSERT INTO wim_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","aꞌ pal ngul kal-kal yuk plate.ang wanch koman alantan. Aꞌ wanch koman alanganiya kaath-kunchant ngul theeꞌ, kuchekana. ");
INSERT INTO wim_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ngurp John.antam al-alangan wik inangan ngeeyin-a, than wampin aak jailakan aꞌ pam mulana maayin nunang, aꞌ awarang kaampin nunang. ");
INSERT INTO wim_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Aꞌ than ngurp nungantam ananganiya palam ngul wampin nungant Jesus.antan, nilaman kuch thanang wik nungantaman weꞌarathayn. Than waaꞌin nungant ngul than ngeen thakan yumpina, aꞌ thaaꞌ-aath-aathinan thanang thampa. ");
INSERT INTO wim_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Puth than pam wanch anangana yota woonch-woonchin thanta. Than Jesus-a, puth ngurp nungantam anangana, than keꞌ may mungkiythan-a, puth yaꞌa, pam wanch yot an-anman kuyam wamp-wampin nungant Jesus.antan. Nil puth Jesus.ana thaw thant ngurp nungantam al-alantan, “Ayyang, ngamp puy iiyāmpa pokkapanga, aak enyanang puy nyiināmpa, niiy yipmam ngangkang theeꞌānweya.” ");
INSERT INTO wim_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Yaa, thananiya kan-ngul moꞌin chukkunangan aak thonakan, than yipam aak enyanang nyiinayn than-thanama. ");
INSERT INTO wim_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Than puth pam wanch yotangan kanam thathin thanang, than meeꞌmiy an thanamana Jesus aꞌ ngurp nungantam anangan moꞌin chukkunangan, than monkanam kuchin thanang aak wanttinakan moꞌin — yaa, thananiya kan-ngul aak village thon-thonana want-wantin ngula, aꞌ kamp-kamp ngul moꞌ-moꞌin aak eꞌ wakana. Aꞌ aakana keenk uwin, pam wanch yot al-alangan aꞌ man umputh ngul kuup-kuupin Jesus weeꞌanangan thant. ");
INSERT INTO wim_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Nil Jesus.ana kanan chang pey chukkunaman-a, aꞌ nil pam wanch yot anangan thath thananga, aꞌ nil puth ngangk mam thanang, thanan puth keꞌ minh sheep yimanangan, than-thanaman iiy-iiyin, keꞌ moom keꞌanang yimanangana. Yaa, nil Jesus.angana kan-ngul yot thaaꞌ-aath-aath thanang, wik min God.antaman. ");
INSERT INTO wim_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kinch-wayang ngulana, ngurp nungantam Jesus.antaman wampin nungant, thawin nunganta, “Ayyang, in kinch-wayang ngula, aꞌ aak inan man-kecha! ");
INSERT INTO wim_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Nint pam wanch anangan kuchān thanang than iiyayn aak farms aakanakan, aꞌ puth villages aakanakan thinth-thinthan than-thantana, aꞌ may piiyayn thanttakaman.” ");
INSERT INTO wim_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Nil Jesus.an thaw thant, “Niiyam may theeꞌān thant.” Than thawin nungant, “In wanttak ee? Ngan two hundred dollars mayak theeꞌān ey? Ngan may yipmam aathān thanang ey?” ");
INSERT INTO wim_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Nil puth Jesus.an thaw thant, “Niiy may bread ngeen-ngeen piꞌ-piꞌaniya? Niiy iiyān, thathāna.” Than iiyin, aꞌ palam wampin waaꞌin nungant, “Ngan may bread five piꞌ-piꞌanan, aꞌ putha minh ngaꞌ kucham tham.” ");
INSERT INTO wim_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Anpalaniy-a, nil Jesus.an thaw thant ngurp nungantam al-alantan, “Niiy thawān thant pungk-pungkalang nyiinayn, wakang angan, wak nyiingkanamang.” ");
INSERT INTO wim_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Aꞌ than pam wanch yot anangan aakang nyiinin ngul, pungk-pungkalangan nyiin-nyiinin, fifty-fifty aꞌ one hundred-one hundred nyiin-nyiinin. ");
INSERT INTO wim_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Aꞌ anpalaniya, nil Jesus.angan-a, may bread aꞌ minh ngaꞌ anangan maꞌang maay, aꞌ meeꞌ keny thath, aꞌ meeꞌ-wuthanam God.ant, thankyou thaw nungant may minh aakanakan. Nil may bread anangan pip-pip thanang, aꞌ theeꞌ ngurp nungantam al-alantan than yipmam kalayn pam wanch yot al-alantan. Aꞌ nil minh ngaꞌ kucham thaman pip-pip aꞌ than theeꞌ-theeꞌin thant. ");
INSERT INTO wim_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Than pam wanch maꞌmangkam al-alangan mungk-mungkin ngul, aꞌ thip oth ngul wunin. ");
INSERT INTO wim_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Aꞌ than ngurp nungantam al-alangana may nhanth anangan yalmathin aꞌ yuk basketang wunpin. May nhanth aꞌ minh ngaꞌ nhanth al-alangan baskets twelve thaaꞌ mul maay. ");
INSERT INTO wim_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Pam anangan than mayan mungkin-a, an yota, thaaꞌ-wantanam, five thousanda! ");
INSERT INTO wim_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Anpalaniy-a, nil Jesus.an thaw thant ngurp nungantam al-alantan chukkunangan chang peyayn aꞌ woꞌuwayn keenk moꞌayn aak Bethsaida aakanakan. Than kanan moꞌin-a, nil Jesus.an pam wanch thaaꞌ-wantanam al-alantan thaw thant aak thanttamak kan iiyayn. ");
INSERT INTO wim_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Nil kanan kuch thanang-a, nil-nilam aak yoykakan iiy, nil yipam meeꞌ-wuthanamow piip nungantamantan. ");
INSERT INTO wim_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Anpalan-a, ngaaꞌ kanan ench-a, ngurp nungantam anangan angman chukkunang kookam piꞌan angman puth nil Jesus.aniy-a, yoykang angman yippak pokkapang nyiin-nyiin. ");
INSERT INTO wim_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Nil thath thanang ench-enchin, wuntan thaamp-thaampin, an puth aak paanthanangan nil Jesus.an umang iiy thant ngul, ngak kenyangkan iiy-iiy. Nil keꞌ waank iiyiy-a, ");
INSERT INTO wim_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","puth thanan thathin nunang ngak kenyangkan iiy-iiy. Than ngaantam-ngeeyin thanttakaman, “An oony ey?” aꞌ than othamayan pech-pechin. ");
INSERT INTO wim_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Than thath-thathin nunangan-a, than yotaman ngangk ikin aꞌ winynyang paththam moꞌin. Nil Jesus.an erkam thaw thant, “Niiy keꞌ winynyang moꞌāna! In ngayam wampang niiyanta! Niiy ngangk thayanam keꞌ iiyin ey?” ");
INSERT INTO wim_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Aꞌ nil chang pey chukkunangan thanttang aꞌ anpalaniya wuntan enyan ngul, kan-ngul wun-wun. Than ngurp nungantam anangan-a, meeꞌam ikin, ");
INSERT INTO wim_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","than puth keꞌam minam ngaantam-ngeeyin nil ngeenam mayan aath-aath thanang pam wanch thaaꞌ-wantanam anangan, five thousand anangan, than puth keꞌ thiichiythana. ");
INSERT INTO wim_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Anpalan-a, than woꞌuwayn peyin chukkunangana aꞌ aak Gennesaret.akan wampin. Chukkun thanttaman-a, angan muuntin. ");
INSERT INTO wim_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Than chukkun kanan wantin-a, pam wanch anangan wampin, thanana thiichin nunang pam ngurp nilam Jesus.ana. ");
INSERT INTO wim_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Aꞌ thananiy pam wanch aak nath-nathpalana kamp moꞌ-moꞌin nungant Jesus.antan; aak want-wanttingan nil-a, wik thooꞌan ngeeyin, aꞌ thanana iiyin nungant, pam wanch alpan anangan thaka pengkarangan wampathin nungant. ");
INSERT INTO wim_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Aak want-wanttinakan iiy-a, aak villagesak nath-a, aak townak natha, aak farmak nath iiy-a, than pam wanchangana pam wanch alpan anangan wampathin thanang nungant, aꞌ wunpin thanang aak weꞌarang angan. Than pam wanch anangan thaaꞌ-mamanang thawin nungant, “Ayyang, than alpan al-alangan kulich thaaꞌan nungkaram keꞌ mamiythan ey? miyal yipam wunayna?” Aꞌ than alpan al-alangan kulich thaaꞌan mamin nungant-a, an miyal paththam wun-wunin. ");
INSERT INTO wim_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Than puungk wiy Pharisees anangan-a, aꞌ putha pam piꞌan wiy anangan thamp than wik thayanan thaaꞌ-aath-aathin thanang, than puth aak Jerusalem anpalan wampin angman yalmathin nungantang Jesus.antangan. ");
INSERT INTO wim_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Than thath-thathin thanang ngurp Jesus.antam wiy anangan may thanttakaman mungk-mungkin, than puth maꞌan minam keꞌam pungin, keꞌ than Pharisees anangan wik thay-thayanam thawin thant maꞌ min-minaman pungayna. ");
INSERT INTO wim_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Than puth Phariseesa puth Jews wiy anangan thama than woyan anman wakin wuut mangk thanttam al-alangana wantina; thananiya maꞌ min-minam kuyam pungin may mungkanakana. ");
INSERT INTO wim_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Puth than nath maywey piiyiythan store.aman-a, kaꞌathamaniya mayan ngakang min-min pungina aꞌ mungkin ngul. Puth wik thayan wiy anangan thak monkan-wak-wakina wuut mangk thanttam al-alangan wantin thant. Thananiya yuk cups, aꞌ pots, aꞌ bowls-a, putha wurp anangan thak min-min kuyam pungina.) ");
INSERT INTO wim_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Yaa, puth than anangan Phariseesa aꞌ pam anangan thana wik thayanan thaaꞌ-aath-aathin thanang, thanan engkin nungant Jesus.antan, “Ayyang, Jesus-ang, an than ngurp nungkaram al-alangan kan kumin ey? aak ngamparam wuut mangk al-alangan wantin ey? Than may mungkanakan-a, thanana maꞌ min-min keꞌam pung-pungantan ey?” ");
INSERT INTO wim_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Nil Jesus.an thaw thant, “Niiy yaan muuk-muukamaniya! Aak keenkanaman-a, pam Isaiah alangana wik kan-kanam waaꞌ-waaꞌ niiyanganiya. Nil putha piip God.angana wik inangan waaꞌ nungant pam Isaiah alantan: ‘Pam wanch than il-ilangan thaaꞌ-kuumpantan ngayangana, puth ngangkaman keꞌ thaaꞌ-kuumpantan ngayang, yaꞌ ey! Than yaan muukamantana, than kecham iiy-iiyantan ngatharamaniya. ");
INSERT INTO wim_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Than aak-yaꞌang thaaꞌ-kuumpantan ngayang, than puth wik thayan pamantamana thaaꞌ-aath-aathantan thanang wik thanaman ngaantam-ngeeyantana, puth wik inangan wik ngatharam yaꞌa, than thawantan keꞌ wik minan waaꞌantan, nil yaꞌa, yaan wik uuy-uuyamantan.’ ");
INSERT INTO wim_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Puth niiyaniya wik thayan God.antamakana man-mangkam theeꞌaniy, niiy keꞌam thak ngeeyaniy yaꞌa, wik pamantamana an ep-paththam niiy konangam piꞌ-piꞌaniya.” ");
INSERT INTO wim_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Nil Jesus.an putham thaw thant, “Niiy wik thayan God.antaman epankathaniya niiy yipam wik thayan niiyantam anman waaꞌ-waaꞌān wiyantana. Niiy keꞌ kuchek waap min ngaantam-ngeeyaniy niiyantakamana, puth yaꞌa. ");
INSERT INTO wim_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Nil puth Moses.an thaw, ‘Niiy ngangk minangam iiyān kaath piip niiyantamakan. Niiy wik thanttaman erkam ngeeyān, aꞌ maꞌ-aathān thanang.’ Aꞌ putha nilana wik inangan thamp thawa, ‘Nil weeꞌ-weeꞌananganweya kaath piip thanttamak thaaꞌ poch-pochaman thawayn thant-a, koonhangan akayn thanang-a, an niiy mulathān thanang.’ ");
INSERT INTO wim_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Niiy kaath piip niiyantaman min-minam piꞌāna, may thak aathān thanang, puth yaꞌa, niiyan thawaniy, ‘An min ngampar wik Corban thawimp thant kaath piip ngamparamakana, wik yimanangan, “Ngay keꞌ-ngul piꞌing nipangana, wukal inangana piꞌ-piꞌānga nungant, piip God.antan theeꞌāng, work nungantamak, nipar yaꞌa!” ’ An yaꞌa! Niiy wik yimanangan keꞌ thawān kaath piip niiyantamakan. ");
INSERT INTO wim_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Niiy wik yimanangan waaꞌ-waaꞌaniy pam wanch wiyantan-a, an puth niiyan wik piip God.antamana thaamp-thaampaniya! Aꞌ puth niiy way maꞌ-yotam yimanangan yump-yumpaniya!” ");
INSERT INTO wim_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Aꞌ nil Jesus.angana pam wanch yot anangana ump thanang nungantangan thinth wampayn, aꞌ nilan thaw thant ngul, “Niiy wik inangan ngeeyāna! kuchekangan piꞌāna! ");
INSERT INTO wim_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nil pamang nathweya may ngench thayanan mungkiy-a, nil puth God.angana pam wayana keꞌ-ngul waaꞌowana may anpalmaniy. Puth nilwey pamang wik way anman ngangkangaman piꞌ-piꞌiy-a, nilaniya wik way ngul thawiy, an puth nilana way paththam ngul weeniya. ");
INSERT INTO wim_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","(Niiy nath kon thampwey-a, niiy wik inan ngeeyāna!)” ");
INSERT INTO wim_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Anpalana, nil Jesus.angan pam wanch yot anangan want thanang aꞌ pek ngoonch aawuchangan. Aꞌ ngurp nungantam anangan engkin nungant wikan koochanathow thant. ");
INSERT INTO wim_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Nil Jesus.an thaw thant, “Niiyant kuchek way ngul wunan ey? keꞌ pam wiy anangan ey? Niiy min-minam keꞌam ngaantam-ngeeyaniy ey? Wik ngay nyiingkan waaꞌ-waaꞌang niiyantan-a, an yimanangan wunan. Nil pamang nathwey may ngench thayan anpalan mungkiy-a, nil puth God.angan pam wayana keꞌ-ngul waaꞌowan may anpalaniy, ");
INSERT INTO wim_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","puth mayaniy-a, ngangk nungantangan keꞌ wunan, yaꞌa, thipangan ep wunan, amanamaniya may ananganiya pentan ngul nungantam.” (Nil Jesus.an wik inangan thaw-a, nil wik inan waaꞌ: may yotam anangan min ngampar mungkanakana, ngench thayan yaꞌa.) ");
INSERT INTO wim_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Aꞌ puth nil Jesus.an wik inangan thamp thaw, “Puth nilwey pamang wik way anman ngangkangaman piꞌ-piꞌiy-a, nilaniya wik way ngul thawiy, an puth nilana way paththam ngul weeniya. ");
INSERT INTO wim_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Puth than pam wanchangana nath way anman ngaantam-ngeeyiythan-a, than puth way wiy-wiyam thakan yump-yumpantan ngula — thananiy-a, pam wanch wiyantama way min maꞌ-kuchathantan thanttakam aꞌ puth pam wanch thak ngulan mulathantan, ");
INSERT INTO wim_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","putha maarich keeꞌantan; aꞌ puth yangk iiyantan, aꞌ puth way wiy anangan yumpantan; than wiy anangan meeꞌ thenchantan; than ngaantam-ngeey-ngeeyantan maarich keeꞌanakan; than wiyantaman meeꞌ-wuntan, aꞌ puth pam wanch wiy anangan aak-yaꞌangan waaꞌantan thanang, aꞌ puth than ulp-ulpanang iiy-iiyantan, aꞌ puth weenth iiy-iiyantan. ");
INSERT INTO wim_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Than way paththam yimanangan iiy-iiyantan puth anpalan than kaꞌathangaman way piꞌ-piꞌin ngangkangan, thananiy-a, way paththam ngul wuniythan.” ");
INSERT INTO wim_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Anpalan-a, nil Jesus.angana aak anan want ngul, aꞌ kan-ngul iiy aak thonak, aak Tyre thinthana. Nil aawuchang pek ngoonch, nil kaangk keꞌ pam wanch wiy al-alangan meeꞌmiy nilan wanttina, an yaꞌangam, wikan pent. ");
INSERT INTO wim_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Wanch thonamangan wik thooꞌan ngeey nungantam aꞌ erkam wamp nungant, puth puk many nungantam alangana oony way piꞌ-piꞌ ngangkangan. Nil kaath-kunchan pungkang nyiin nungant, aꞌ thaaꞌ-mamanang thawant oony wayan kenthowan ngangk puk nungantam anpalan. ");
INSERT INTO wim_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Nil wanch inana, Jew yaꞌa, nil aak Phoenicia angan aak-ngeey, aak Syria angan. ");
INSERT INTO wim_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Nil puth Jesus.an thawant, “Ngay kaꞌatham may aathāng puk manyiy anangan. Ngaywey may puk manyiy anangan maꞌam piiying thanang ey? Kuꞌant theeꞌ-theeꞌing ey? An yaꞌa! An min ngath yaꞌa!” ");
INSERT INTO wim_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Nil puth wanchana thaw nungant Jesus.antana, “Ayyang, moom-ang, puth kuꞌ al-alangan may nhanth anangan mungkantana, table.aman keekina!” ");
INSERT INTO wim_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Nil puth Jesus.an thawant, “Nint wik min thawana. Yaa, nint kan aakak iiyāna, aꞌ nint puk wanch many nungkaraman miyal ngul uwān nunang, kuchek minam ngul, oony wayana kanam pent nungantam.” ");
INSERT INTO wim_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Nil wanchan aak nungantamak iiy, aꞌ puk wanch many nungantaman uw nunang bedang wun-wun; oony wayan kanam pent nungantama, miyal ngul ween. ");
INSERT INTO wim_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Anpalana, nil Jesus.angan aak anan Tyre.ana kan-ngul want, aꞌ puyaman ngul iiy aak Sidon aakanakan, anpalana, aak Decapolis anpalman pent, aak town yot than-thanin, anpalana, nil aak Galilee aakanakan ngul iiya. ");
INSERT INTO wim_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Pam wanch wiyanganiya pam way alpan wampathin nungant, kon-wal weenth pam nilaniyweya, thaaꞌ nganthaliy, nil wik purꞌ-purꞌ thaw-thawa, aꞌ thananiya thaaꞌ-mamanangwey thawin Jesus.antana maꞌ wunpow pam alantangan, miyalathow nunang. ");
INSERT INTO wim_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Nil puth Jesus.angan-a, pam weenthana pokkapang kal nunangweya, pam wiy al-alantamana, aꞌ maꞌ puk nungantaman pam alpan alantangan wunpant konangweya, aꞌ maꞌ thaaꞌ theekang namp, aꞌ thaaꞌnganth anan mamanta. ");
INSERT INTO wim_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Amanamaniya nil Jesus.anganiya um kenya ngul thatha, aꞌ ngangk piꞌan ngul theeꞌ aꞌ thawant pam alantan, wik nungantamangan, “Ephphatha.” Wik ngamparamangan thawanampa yimananga, “Kon thoꞌanamow nungkara!” ");
INSERT INTO wim_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Aꞌ ananiya, yaam keꞌanam paththam-a, wik ngul ngeey-ngeey thanang pam wanch anangan, kon min ngul wunanta, aꞌ puth thaaꞌnganthana yaalꞌathanta, wik ngul minam thaw-thawweya. ");
INSERT INTO wim_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Nil Jesus.angana wik thayanath thanang pam wanch anangan, than angmanan than-thanin, keꞌ wik waaꞌayn thon-thonantan, wik thanttakaman mup-mupam piꞌayna. Nil puth-putham thaw thant, puth yaꞌangama, than puy-puyam waaꞌ-waaꞌin, aꞌ wik thooꞌan yaꞌ weꞌaram. ");
INSERT INTO wim_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Puth than pam wanch yotangan wik anan ngeeyin nungantaman-a, thanan meeꞌam ikin, aꞌ thawin ngul, “Nil pam ilangan Jesus.angan min-minam wanttak yumpan! Nilaniya pam wanch weenth anangan-a, kon minam ngul yump thanang; putha pam wanch keꞌan wik thawantan-a, an thaaꞌnganth yaalꞌath thant a!” Aꞌ thanan thanttakam thawin, “In pam nil-nil ey!” ");
INSERT INTO wim_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Anpalman-a, puungk wiy ngul pam wanch yot wampin nungant ngula. Aꞌ anpalana, may ngul minch thant, pam wanchantan, aꞌ nil Jesus.angan-a, ngurp nungantam anangan ump thanang aꞌ thaw thant, ");
INSERT INTO wim_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ngayang pam wanch il-ilangan ngangk mamantan ngayangweya, puth thananiya maꞌ-koꞌalam ingman ngatharanganim iiy-iiyin — puth thananiya may keꞌanangwey wun-wunin. ");
INSERT INTO wim_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Puth ngaywey kuching thanangwey aakakan iiyayn-a, may keꞌ mungkanam-a, thanan puthweya chip-chipamana ngul thaꞌ-thayan keekiythan, thanan putha wiy anangan pam wancha aak kecham wamp-wampin.” ");
INSERT INTO wim_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ngurp nungantam anangan thawin nungant, “Ngamp may yota puth wanttinpala uwāmp thanta aak ingan pintalangan a? Ngamp yipama pam wanch yot thaaꞌ-wantanam inangan aathāmp thanangwey e?” ");
INSERT INTO wim_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Nil Jesus.an thaw thant, “Niiy puy may bread ngeen-ngeen piꞌ-piꞌaniy e?” Thanan puth thawin nunganta, “May bread sevena!” ");
INSERT INTO wim_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Nil puth Jesus.an thaw thant pam wanch yot al-alantan aakang nyiinayn. Nilaniya may bread seven anangan-a, maꞌang maay, aꞌ thankyou thaw nungant God.antan. Amanamaniy-a, may bread anangan-a, manya-manya nhanthath thanang, aꞌ ngurp nungantamak ngul theeꞌ-theeꞌ pam wanchantan yipam yaarkathayn ngul. ");
INSERT INTO wim_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Thanana minh ngaꞌ manya thampang, koꞌalamwey. Nil Jesus.ana yimanangman thankyou thaw God.antan minhakan, aꞌ nil minhan theeꞌ thant ngurp nungantamakan aꞌ than pam wanch yot al-alantan yaarkathin ngul. ");
INSERT INTO wim_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Than pam wanch-a, aꞌ puka manyiy yotam al-alangan mungkin aꞌ thip oth ngul wunin — pam wanch puk anganiya four thousanda nil Jesus.angana may aath thananga! Maya aꞌ minh kanan minchathin-a, than ngurp nungantam al-alanganiya maya aꞌ minh nhanth ananganiy-a, maay-maayin ngul aꞌ seven baskets anangana thaaꞌ mulakam piimpa. Nil puth Jesus.an-a, pam wanch yot al-alantan thaw thant kan iiyayn koyam aak thanttamakan. ");
INSERT INTO wim_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Aꞌ anpalaniya nil Jesus-a, aꞌ puth ngurp nungantam anangana chukkunang ngul peyin aꞌ kan-ngul moꞌ-moꞌin aak namp Dalmanutha aakanakan. ");
INSERT INTO wim_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Anpalaniy-a, puungk wiy Pharisees anangan wampin nungant Jesus.ant aꞌ than kul thawin nungant. Aꞌ thanan thawin nungant work piꞌanan yumpow meeꞌ thanttangan yipam meenathow thant nil God.angan maꞌ-kunch yump nunang. Thanan puth yaan thawin Jesus.antan wik yimanangan, thanan yipam thathayn nil nath work piꞌan nath yumpow, nath yaꞌa, keꞌ yumpiy. ");
INSERT INTO wim_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Nil puth Jesus.an ngangk piꞌanam theeꞌ, aꞌ thaw thant, “Than ngul pam wanch anangan inangaman wuntan-a, ngeenak thaachantan ngayang ngay work piꞌan meeꞌ thanttangan yumpāng a? An yaꞌa! Ngay work piꞌan keꞌ yumpāng thant. Alangan meenathow thant nil piip God.angan kuch ngayangan, puth ngay keꞌ yumping thant, yaꞌa!” ");
INSERT INTO wim_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Aꞌ nil Jesus.angan kan-ngul want thanang, nil-a, puth ngurp nungantam anangana chukkunangan chang peyin, aꞌ kan-ngul ench-enchin aak woꞌuwaynakan. ");
INSERT INTO wim_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Than ngurp nungantam al-alangan may bread yota keꞌ kalin, yaꞌa, kon-ngath thanang, thananiya may bread thonam anmana kalin. ");
INSERT INTO wim_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Nil puth Jesus.ana wik thayan thaw thant, “Niiy meeꞌ yanth-yanth anman iiyān thanttam pam Pharisees al-alantama aꞌ putha pam Herod alantaman thampa. Niiy wik way thanttaman keꞌ ngeeyāna, puth wik thanttam ananganiya, keꞌ may yeast anangana may breadan ulpathan.” ");
INSERT INTO wim_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Than ngurp nungantam anangan kan-ngul wik thaw-thawin thanttakama, “Ngamp may bread keꞌananga, paal nil wik inangan thawa.” ");
INSERT INTO wim_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Nil Jesus.angan kanam thiich thanang wik thanan thaw-thawin, aꞌ nilan putha thaw thant ngul, “Niiy ngeenak thaw-thawaniy niiyantakamana ngamp keꞌ may bread keꞌanangana! Niiy ngul meeꞌmiy yaꞌ yippak ey? keꞌ yippak ngaantam-ngeeyaniy ey? Niiy kuchek way thinhan yippak iiy-iiyaniy ey? ");
INSERT INTO wim_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Niiy puth meeꞌ thamp iiy-iiyaniya! Niiy ngul keꞌ thathin ey? Aꞌ putha, niiy kon thamp iiy-iiyaniya, niiy ngul keꞌ ngeeyin ey? Niiy keꞌ konangam piꞌ-piꞌaniy ey? ");
INSERT INTO wim_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ngay kaꞌathamana may bread five.an many-many pip-pipangan aꞌ pam wanch yot five thousand anangan aathangan thanang may five manyiy al-alantama. Niiy yuk baskets ngeen-ngeenang may nhanth ananganiy maay-maayana?” Than ngurp nungantam anangan thawin nunganta, “Twelve!” ");
INSERT INTO wim_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Aꞌ nil Jesus.an thaw thant, “Ngul amanamana, ngayan may seven pip-pipangan, aꞌ pam wanch yot four thousand anangan aathangan thanang may seven manyiy al-alantama. Niiy yuk baskets ngeen-ngeenang may nhanth ananganiy maay-maayan a?” Aꞌ than thawin nungant, “Seven a!” ");
INSERT INTO wim_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Aꞌ nil thaw thant, “Niiy min-min yippak keꞌam ngaantam-ngeeyaniy ngayang ey?” ");
INSERT INTO wim_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Amanamaniya, than Jesus aꞌ ngurp nungantam anangan aak Bethsaida aakanakan iiyin ngul. Than pam wanch wiyangana pam koꞌanch wampathin Jesus.antana, aꞌ thanana thaaꞌ-mamanang thaw-thawin nungant maꞌ wunpowant, meeꞌan minam yumpowan. ");
INSERT INTO wim_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Nil puth Jesus.angana pam koꞌanchana maꞌ maman, aak townamana yoon kal nunang. Aꞌ nil thaaꞌ theek ngul theeꞌ meeꞌ pam alantangan aꞌ amanamana maꞌ ngul wunpantang pam alantangan. Aꞌ nil thaw ngul pam alantana, “Nint aak min-min kan thathangan ey?” ");
INSERT INTO wim_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Nil puth pam anana meeꞌ ik, aꞌ pal-puy thath-thath, aꞌ thaw, “Eeꞌa, puth ngay meeꞌ yiil yippaka, ngay manyam thonakam thath-thathang thananga, pam wanch anangan, keꞌ yuk yimanangan thath-thathang thanang iiy-iiyantana!” ");
INSERT INTO wim_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Nil Jesus.angan-a, putham ngul maꞌ nungantaman wunp meeꞌ pam alantangan, aꞌ nil pam alangana oth thath-thath, aꞌ yaam keꞌanama an minam ngul thath-thath, meeꞌ min paththam ngul iiy-iiy, minam thath-thath pam wanch anangan aꞌ yuk way min thakan. ");
INSERT INTO wim_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Nil Jesus.anganiya, koyam kuchan aak nungantamak ngul, aꞌ thawant, “Nint koyam keꞌ-ngul iiyāna, aak Bethsaida aakanakana, puth aak nungkaramak iiyāna.” ");
INSERT INTO wim_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Anpalan-a, Jesus-a, puth ngurp nungantam anangan kan-ngul iiyin aak thonak, aak namp Caesarea Philippi.akan, villages yot anganiy wun-wunin. Than iiy-iiyin yippakan-a, nil thaw thant, “Niiyalang, kan niiy waaꞌiy ngathara. Than ngul pam wanchangan ngayangan keꞌ weeꞌ yimanangan ngaantam-ngeeyantan ngayanganiya?” ");
INSERT INTO wim_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Thanan thawin nungant, “Than pam wanch puungk wiyangan keꞌ John waaꞌantan nintang, pam anana kootra ngakangan kuungk-kuungkan thanang pam wanchana, puth puungk wiyangiy keꞌ pam Elijah waaꞌantan nintang, aꞌ wiyangiy keꞌ pam prophet waaꞌantan nintanga.” ");
INSERT INTO wim_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Aꞌ nil Jesus.an thaw thant ngul ngurp nungantam al-alantan, “Puth niiya ngayangan wanttak ngaantam-ngeeyaniya ngay keꞌ pam weeꞌ iniy e?” Aꞌ nil puth Peter.an thaw nungant Jesus.antan, “Ayyang, nint in ngeeya! Nintiya Christa, pam anan nil God.angan kaaꞌngak ngulan kuchow nganta.” ");
INSERT INTO wim_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Anpalana, nil Jesus.an thaaꞌ-thayanam thaw thant ngurp nungantam al-alantan, “Yaa, puth niiyan wik inana keꞌ waaꞌān paththam thant wiyantana.” ");
INSERT INTO wim_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Amanamana, nil Jesus.angana kan-ngul thaaꞌ-aath-aath thanang ngurp nungantam anangan, “Pam wanch wiyanganiya way-wayam anangan yumpayn ngathara, pam ngay inmana nil God.angan kuch ngayang. Than pam piꞌan Jews.antam al-alangana man-mangkam ngul theeꞌayn ngatharweya, than pam manth-thayan al-alangan aꞌ puth than moom priestsantam al-alangan aꞌ pam piꞌ-piꞌanam wiy al-alangan thampa. Anpalaniy-a, than mulathayn ngayang ngula, puth kinch koꞌalamang ngulan wantow-a, ngaya mulaman koyam ekāng ngula.” ");
INSERT INTO wim_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Nil Jesus.angan wik inangan engk-engkanang ngul waaꞌ-waaꞌ thant ngurp nungantam al-alantan. Aꞌ puth anpalana nil Peter.angan pokkap kal nunang aꞌ wak-wak nunang Jesus.anweya wik al-alantaman nilan waaꞌ-waaꞌ thant nungamangana. ");
INSERT INTO wim_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Puth nil Jesus.ana weent ngul aꞌ thath thananga ngurp nungantam anangana, aꞌ wak nunang Peter.ana, “Nint puy iiyāna! Petera! Nint wik nanangan thaw-thawangan keꞌ oony way piꞌan Satan anana! Nan nint-nint kuchekangan ngaantam-ngeey-ngeeyangana, puth nila piip God.angana yimanangana keꞌam ngaantam-ngeey-ngeeyan, yaꞌa!” ");
INSERT INTO wim_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Aꞌ nil puth Jesus.angana ump thanang ngul ngurp nungantam anangana, putha pam wanch puungk wiy anangana ang wampayn nungant, aꞌ nilan thaw thant, “Nil weeꞌ-nathweya kaangk ngatharanganiy iiyowwey-a, nilaniya keꞌ ngaantam-ngeeyow nungantakamana, yaꞌa. Pam wanch al-alangan nath mulathayn nunanga, keꞌ ngayangan mulathayn, yuk wuuyanangan waanchayn ngayang. Nungkway than wiyangana nath mulathayn nunang-a, nilana ngayang anman monkan-wak-wakow. ");
INSERT INTO wim_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Nil weeꞌangwey wantow ngayangana pam wanch wiyangan keꞌ yipam mulathayn nunang-a, yaa, nilaniya keꞌ wuniy aak ngatharamangan yaꞌa; puth nil weeꞌanganwey anman ngangk thayanangama monkan-wak-wakow ngayangan-a, aꞌ putha wik min ngatharam anangan waaꞌ-waaꞌiy thant wiyantan-a, nungkway pam wanch wiyangana thaaꞌ-thengkathiythan nunang-a, nath mulathiythan nunang-a, yaa, an nil ngangk aak umpuyam puth wunow aak ngatharamangana. ");
INSERT INTO wim_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Pam wanch wiy anangan maꞌmangkiy iiy-iiyantan, way min yot-yotam piꞌ-piꞌantan aak inganiya. Puth ngay nathwey keꞌ kaling thanang aak ngatharamakanwey-a, an way min yot anangan min thant ey? Yaꞌa! Way min yot-yotam al-alangan keꞌ ngangk min yumpiy thanang yaꞌa. ");
INSERT INTO wim_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Than ngul pam wanch al-alanganiya yuk way min thanttaman theeꞌiythan nungant piip God.antaniy ey? an nil yipmam kaliy thanang aak min nungantamakan ey? Yaꞌa!” ");
INSERT INTO wim_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Aꞌ nil Jesus.an wik inangan thamp thaw thanta, “Aak yimanang ngulana, pam wanch way ngul iiy-iiyantan, aꞌ piip God.ana too ngul wantantan nunang. Pam wanch puungk wiy anangana ngul-nyaaꞌ wuntan ngatharam, aꞌ putha wik ngatharam anpalan, ngay pam inman nil God.angan kuchanya. Ngul-ngulana, ngay palaman ngul wampāng thanttang ngaantiyongk al-alantangan aak iikanakaman. Ngay pam piꞌan paththam wampānga, keꞌ piip ngatharam anman God.an — aak an-aniyangana ngayaniya ngul-nyaaꞌ thawāng thanttam pam wanch al-alantaman thamp than ngul-nyaaꞌan wun-wunin ngatharamana.” ");
INSERT INTO wim_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Aꞌ nil thaw thant ngul, “Ngay inan waaꞌāng niiyanta: aakan ngul wampowa nil piip ngatharamangan pam wanch yot anangana maꞌ-thayanam ngul piꞌ-piꞌow thananga. Puth pam wanch wiy aak inman yippak wunaniy-a, man-yetham iiy-iiyān aak ngulan wampowa, niiy meeꞌ niiyamana ngul thathānweya.” ");
INSERT INTO wim_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Aak kinch sixangan want-a, nil Jesus.angan ngurp nungantam koꞌalam kal thanang yoyk achantangak, Peter-a, aꞌ pul maꞌ-kuuncham anangan James aꞌ John. Thanam anangaman keny matin. Than thathin nunang Jesus.an-a, aꞌ kaaꞌwal nungantaman wiy-wiyam ngul ween. ");
INSERT INTO wim_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ngook nungantaman pach-pacham paththam weemant, keꞌ ngamp ngookan punganamp yimanangan yaꞌa, ngook nungantamaniya pach-pacham piꞌa! ");
INSERT INTO wim_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Anpalaniya, than ngurp nungantam koꞌalam al-alanganiy-a, thathin pulang, Moses-a, puth Elijah anana angman Jesus.antang, wik thaw-thawpul nungant. ");
INSERT INTO wim_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Anpalana, nil Peter.an thaw nungant Jesus.antan, “Lord-ang, an ngampar min ngamp aak inganiy wunāmpa! Ngay ngorkal koꞌalam keꞌ yumping niiyant ey? aak ingman ey? Thonama nungkara, aꞌ thonaniya nungant Moses.anta, puth thonaniya nungant Elijah.anta!” ");
INSERT INTO wim_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Than Peter weeꞌanangan winynyang paththam moꞌin, thanan keꞌ ngaantam-ngeeyin wik want-wanttakan thawayn. ");
INSERT INTO wim_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Anpalaniy-a, yuwan thanttang wakan thuuch, aꞌ ngoyngk alangan thanang yaꞌ kang, aꞌ thanan wik inan ngeeyin yuw anpalan, “In puk nhengk ngatharama, ngay nunang kaangk paththama. Niiyiya puth wik anman ngeey-ngeeyān nunangana!” ");
INSERT INTO wim_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Than ngurp Jesus.antam al-alangan-a, erkam pal-puy thath-thathin, puth pam wiy keꞌam thathin, Jesus anman thonakam thanttangana. ");
INSERT INTO wim_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Anpalan-a, thanan yoykam anpalan kan-ngul pek ukin. Aꞌ nil Jesus.an thaw ngul thant, “Niiy wik puy-puyaman keꞌ waaꞌān niiy inan thathanana. Ngul-ngulan-a, ngay mulaman ekāng-a, an ep-paththam niiy waaꞌān thant. Ngaya pam inman nil God.angan kuchanya.” ");
INSERT INTO wim_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Than wik ngeeyin nunang, aꞌ wiyantan putha keꞌam waaꞌin thant aꞌ putha than-thanaman ep thaw-thawin, “Nil wik want-wanttakan thaw-thaw thant, nil keꞌ mulaman ekowa?” ");
INSERT INTO wim_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Anpalan-a, than Jesus.an mepin nunang, “Ayyang, Lord-ang, than puth pam piꞌan anangan wik thayan anangan thaaꞌ-aath-aathantana, than ngeenak thaw-thawantan nil Elijah.an palaman wampow aꞌ putha nil pam nil God.angan kaaꞌngaka mangk nungantangan wampowa?” ");
INSERT INTO wim_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Nil puth Jesus.an thaw thant, “Pam keꞌ Elijah yimanangan wampowa pam wanch woyan wayaman koyam epankathow thanang woyan min God.antamak. Puth lat ngench thayan God.antamangan wik inangan ngeenak waaꞌ, ‘Pam wanch wayanang al-alangan wayan ngul yump-yumpayn ngathara, aꞌ man-mangkaman theeꞌayn ngathar, ngay pam inman God.angan kuchanya.’ ");
INSERT INTO wim_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ngay puth inan thawang niiyant: pam keꞌ Elijah yimanangan kan wampa, puth than pam wanch al-alangan way yumpin nungant, thanan kaangk way anman yump-yumpayn nungant. Lat ngench thayanang wik yimanangan waaꞌan thanan way yumpayn nungant.” ");
INSERT INTO wim_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Aꞌ anpalaniy ngula, nil Jesus aꞌ Petera, aꞌ Jamesa, putha Johna, than koyam ngul iiyin ngurp thanttam wiy al-alantana. Than kanan uwin thanangan-a, thanan pam wanch thaaꞌ-wantanam thathin thanang, ngurp thanttam al-alantangan angman than-thanin thanttanga aꞌ puth than pam piꞌan anangan wik thayanan thaaꞌ-aath-aathin-a, thanan thaaꞌ-thay-thayanamin thanttanga. ");
INSERT INTO wim_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Than pam wanchangan Jesus.an thathin nunang-a, thananiya thaaꞌam ikin, aꞌ thanan umang moꞌin nungant. ");
INSERT INTO wim_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ngul anpalaniya nil Jesus.an thaw ngurp nungantam al-alantan, “Niiy ngeenam thaaꞌ-thay-thayanamaniya thanttangana?” ");
INSERT INTO wim_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Nil pam thonam inan angman than-than pam wanchantangana thaw nungant, “Moom-ang, ngay puk wuut ngatharam inan kalang nungkara, nil puth oony wayan ngangkang piꞌ-piꞌana aꞌ nil keꞌ wik thawiy thampa. ");
INSERT INTO wim_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Nil oony wayan wamp-wampan nungant-a, an aakang unchan nunang, aꞌ nil thaaꞌ theek ukanang wun-wunana, nil koonh thak path-pathan nungamanga, aꞌ kemp maꞌmangkaman thayan ngul weenana. Ngay ngurp nungkaram al-alantan kan thawangan oony wayan kenthayn nunang ngangk nungantam anpalana, puth thanan keꞌ kenthiythan nunang yaꞌa.” ");
INSERT INTO wim_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Nil Jesus.an thaw thant ngul, “Ngay aak nathpalman wun-wunangan niiyantanga, puth yaꞌangama, niiyan puth min-minan keꞌam yippak ngaantam-ngeeyaniy ngayanga, yaꞌa. Ngay yaam kuup-kuupāng niiyant ey? Niiyan min-minan ngaantam-ngeeyān ngayangan ey? Puk ngechwiyan pal kalān ngathara!” ");
INSERT INTO wim_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Than puk ngechwiyan kalin nunang Jesus.ant. Nil oony way alangan Jesus.an thath nunangan-a, nil puk ngechwiyan aakang unch nunang aꞌ nil thay-thayanama ngula, aꞌ aakangan pal-puy theeꞌ-theeꞌ nungamang aꞌ thaaꞌ theek piꞌan uk-uk nungantama. ");
INSERT INTO wim_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Nil Jesus.an piip-kunchant engk, “Aak maꞌ ngeen-ngeen nil yimanangan weena?” Nil puth piip-kunchan thawa, “Aak nathpalmana nil puk manyaman yippakweya. ");
INSERT INTO wim_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Maꞌ-yotaman nil oony way alangan keꞌ mul-mulathanakam nunangweya, nil maꞌ-yotaman thumang thak theeꞌan nunang aꞌ puth ngakang thamp theeꞌan nunanga. Nint keꞌ ngangk mamin nganang e? Nint ep-paththam nath maꞌ-kunch-a, nganang yipam maꞌ-aathānwey-a, maꞌ-aathān nganang paththama!” ");
INSERT INTO wim_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Nil puth Jesus.an thaw nunganta, “Nint ngeenak ngul wik yimanangan thawangan ngathara, ‘Ngay nath ep-paththam ey? maꞌ-kunch ey? maꞌ-aathāng nipangan ey?’ Nil weeꞌang God.an kan-kanam ngaantam-ngeeyan nunanga nil thayan paththaman-a, yaa, nil God.angan ngul yot yump-yumpow nunganta.” ");
INSERT INTO wim_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Nil piip-kunchan erkam paththam pecha, “Ngay kan-kanam God.an ngaantam-ngeeyang nil thayan paththama puth ngay min-minan keꞌam ngaantam-ngeey-ngeeyang nunanga, yaꞌweya. Nint keꞌ maꞌ-aathin ngayang ey? Ngay min-min yipam ngaantam-ngeeyāng nunang God.ana.” ");
INSERT INTO wim_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Nil Jesus.angan thath thanang pam wanch yotangan yaꞌan wuthanathin thanangan, puth nilaniya wik thayanam oony way alantan thawa, “Ayyang, oony way-ang, nint puk ngechwiyan weenth aꞌ puth wik keꞌanang yumpan nunangweya. Ngay wik thayanam inan thawang nungka nint pentān puk nalantamana, aꞌ koyaman keꞌ-ngul ngoonchān nungantanganweya!” ");
INSERT INTO wim_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Nil oony wayan wik othamayan pech aꞌ nil puk ngechwiyan aakang unchanwey aꞌ thay-thayanam ngula, ngul anpalaniya nil oony way alangan yaꞌ-ngul wantan. Nil puk ngechwiyan keꞌ mul yimanang angman wun-wun, aꞌ than yotam anangan thawina, “Nil kanam uthamweya!” ");
INSERT INTO wim_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Nil puth Jesus.angan maꞌ-mamanang ekathan aꞌ nil puk ngechwiyan than ngulweya. ");
INSERT INTO wim_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Than Jesus-a, ngurp nungantam anangana aakak kan-ngul iiyin, aꞌ than pek ngoonchin ngul aawuchangan, than-thanam nyiinin. Aꞌ ngurp nungantam anangana engkin nungant, “Ngan ngul wanttaka oony way anangana yaꞌangam kenthan puk alantamana?” ");
INSERT INTO wim_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Aꞌ nil Jesus.an thaw thant, “Niiy oony way anangan kaangk kenthān thanang pam wanchantaman-a, niiyiya meeꞌ-wuthanamān piip God.ant, nungantakam thonakama. Wiy al-alangan keꞌ maꞌ-aathiythan niiyang kenthanakan thanang, yaꞌa, nilam epa.” ");
INSERT INTO wim_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Aꞌ than Jesus-a, puth ngurp nungantam anangan aak anana wantin ngul, aꞌ iiyin ngul aak Galilee wakan. Nil Jesus.an kaangk than meeꞌ-thenchanam iiyayn, puth nilana kaangk pokkapang thaaꞌ-aathow thanangana. ");
INSERT INTO wim_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Nil wik inangan waaꞌ thanta, “Pam way al-alangana maꞌam theeꞌayn ngayanga pam wiy al-alantan, thananiya mulathayn ngayang, pam ngay inman nil God.angan kuchanya. Kinch koꞌalamangan ngulan wantow ngayang-a, ngayaniya mulaman ekāng ngula.” ");
INSERT INTO wim_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Puth ngurp nungantam al-alanganiya wik kumin nunang wik nilana thaw-thaw thanta, keꞌam thiichin, yaꞌa, puth than keꞌam engkin nungant wik want-wanttakan nilaniy thaw-thawana, puth thanan winynyang moꞌin nungantama. ");
INSERT INTO wim_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Aꞌ than aak Capernaum.akan ngul wampin. Thanana aak aawuchang pek ngoonchin aꞌ nil Jesus.an engk thant ngurp nungantam al-alantan, “Niiy ngeenam thaaꞌ-thayanamaniy woyan wakanana?” ");
INSERT INTO wim_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Puth than wik keꞌam thawin nungant yaꞌa, puth thanan woyan wakanangan thaw-thawin thanttakamana nil weeꞌ-nathana thanttang pam meek piꞌanan iiyow. ");
INSERT INTO wim_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Aꞌ nil Jesus.ana nyiin ngul, aꞌ ngurp nungantam twelve anangana ump thanang ngul angman nyiinayn nungantanga, aꞌ nil thaw thant, “Nil weeꞌ-nathweya pam piꞌan paththaman kaangk iiyow-a, nilaniya keꞌ pam meek keꞌ yumpow nungantakam, yaꞌa, nilaniya pam wanch wiy anangana ngaantam-ngeeyow thanang, aꞌ minam piꞌow thanang, maꞌ-aath-aathow thanangweya.” ");
INSERT INTO wim_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Aꞌ nil Jesus.angan puk many uw aꞌ maꞌ mamanang kal nunang aꞌ aak umang thanath nunang. Nil puk manyan ompam kath nunang, aꞌ thaw thant ngul, ");
INSERT INTO wim_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“In ngeeyiya! Nil weeꞌanganweya puk many inan minaman piꞌow nunang-a, puth nil puk manyan ngathar-a, an nil keꞌ ngayang ngangk minangam piꞌan. Aꞌ putha nil weeꞌ-nathweya ngangk minangam iiyow ngathar-a, an nil keꞌ pam anan piip ngatharam God.anta ngangk minangam iiyan nungant thampa, nil puth piip ngatharamangana kuch ngayang aak iikanakan.” ");
INSERT INTO wim_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Aꞌ nil pam John anan thaw nungant, Jesus.antan, “Ayyang, Moom-ang, ngan pam thonam thathan nunang namp nungkaraman wich, aꞌ anpalana nil oony way anangan kenth thanttam pam wanchantam. Ngan puth thawan nungant, ‘Keꞌ yimanangan thawāna, nil puth pam anman keꞌam iiy-iiyan ngamparangana, yaꞌa.’” ");
INSERT INTO wim_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Aꞌ nil puth Jesus.an thaw thant, “Niiy keꞌ wayathin nunang pam anana. Nil weeꞌang nathweya namp ngatharaman wichow-a, puth anpalana an nil work piꞌan yumpan-a, aak amanam ngulan-a, nil way keꞌ waaꞌiy ngayangan, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Than weeꞌ-weeꞌanangweya keꞌamana um thaampantan ngampangan-a, an puth than keꞌ ngamparang iiy-iiyantan, ngurp ngamparam thana. ");
INSERT INTO wim_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ngay wik inangan kan-kanam waaꞌ-waaꞌang niiyanta: nil weeꞌanganweya ngak aathow niiyang niiyan puth ngayangan monkan-wakaniy-a, yaa, nil puth piip God.an kan-kanam minam paththam iiyow nungant. ");
INSERT INTO wim_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Nil weeꞌang nathwey thaach-thaachiy thanang puk manyiy anangana way yumpanakan-a, an than puk manyiy al-alangan kon-ngathan thanang ngula ngayangwey-a, an way-wayam wampow nungant pam alantan nilan thaach-thaachan thanangana. Pam wiy al-alangan nathwey kunttow wuut piꞌan manang kathiythan nungant aꞌ anpalaniya woꞌuw aakanakan kaliythan nunang-a, aꞌ ngakang pek theeꞌiythan nunang-a, an way nungant. Puth nil pam alangan nathweya puk manyiy anangan thaach-thaachiy thanang ngayangan keꞌ-ngulan monkan-wak-wakayn-a, an way-wayam paththam wampow nungantaniya. ");
INSERT INTO wim_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Niiywey wayan yumpin-a, maꞌ niiyantam nalangan-a, yaa, niiya maꞌ niiyantamana thalokang umpāna! niiy keꞌ yipam way anangan yump-yumpāna. Nungkwaya niiy aak God.antamakan maꞌ keꞌanang iiyinwey-a, yaa, an kan putha! Puth in ngeeyāna: niiy nath maꞌ kucham thamp aak wayakan iiyin-a, an puth way niiyanta, puth aak anana thum pam-wiy-keꞌ uthamanan, anman pench-penchana. ");
INSERT INTO wim_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Niiy thaꞌ-thaꞌang nath uw-uwin thanang kulakwey-a, yaa, thaꞌ niiyantaman thalokang umpān, niiy keꞌ yipam kulakan wenkān. Nungkway niiy aak God.antamakan thaꞌ keꞌanangan iiyinwey-a, yaa, an kan putha! Puth in ngeeyāna: nil God.ang aak way angan theeꞌiy niiyangana thaꞌ kucham thamwey-a, an way niiyanta. ");
INSERT INTO wim_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Niiywey nath way thathin meeꞌ niiyantamangan-a, aꞌ amanamaniya niiy wayan yumpin ngulana, yaa, niiy meeꞌ thiith niiyantamana thapathān, niiy yipam way anangana keꞌ-ngul thathāna. Nungkway niiy aak God.antamakan meeꞌ keꞌanangan iiyinwey-a, yaa, an kan putha! Puth in ngeeyāna: nil God.ang aak way angan theeꞌiy niiyangana meeꞌ kucham thamwey-a, an way niiyanta. ");
INSERT INTO wim_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Aak angman-a, yuk panth-panth yotan wun-wuntan, keꞌan uthamantan, than murkanim pam wanch anangana kemp mungk-mungkantan, putha thum karkanan murkanaman pench-penchan, keꞌan uthamana, yaꞌa.” ");
INSERT INTO wim_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Aꞌ nil Jesus.an thaw thant ngul, “In ngeeyāna! Niiy yuk saltan wunpaniy minhangan-a, an minhana min paththam yumpan mungkanakan; aꞌ putha niiy minh thumangan kiingkaniy-a, an yimanang thamp minhan min yumpan mungkanakaniya. Aꞌ inan ngaantam-ngeeyān thampa: niiywey keꞌ-ngoongkam anman monkan-wak-wakin ngayangan-a, an than pam wanch wiyangana way thakan yumpayn niiyant. Puth niiy nath way inangan thaampinwey-a, an niiyan pam wanch min paththam iiy-iiyin. ");
INSERT INTO wim_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“In thamp ngeeyāna! Saltana mina, minhakana. Puth salt nath way ngulan wunow-a, niiy ngul saltan wanttaka koyaman min yumpāna? An yaꞌa! Puth niiya ngangk minangam iiy-iiyān pam wanch al-alantan, keꞌ pekwuna, puth niiya minam anman iiy-iiyān thon-thonantana, puth amanamana niiyaniya keꞌ salt min yimanangan iiy-iiyāna.” ");
INSERT INTO wim_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ngul anpalaniya, nil Jesus.ang aak anan kan want, aꞌ nil woꞌuwayn pey River Jordan.ak aak Judea aakanakana. Pam wanch yot anangan putham wamp-wampin nungant, aꞌ nil wikan waaꞌ thant, puth aak nungant yimanangan wun. ");
INSERT INTO wim_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Amanamaniya, pam Pharisees wiy anangana wampin nungant. Than yaan thawin nungant nil wik want-wanttakan thawow thant, “Ayyang, ngul wik thayan ngamparamangan wanttak waaꞌan e? An ngul min ey? Pamang wanch thum nungantaman aak umpuyangaman wantowan ey?” ");
INSERT INTO wim_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Nil puth Jesus.an thaw ngul thant, “Nil Moses.angan wik thayan ngeen waaꞌ niiyanta?” ");
INSERT INTO wim_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Thanan thawin nungant, “Nil Moses.an wik inangan thaw, ‘Nil nath pam thum nungantamangan wanch-kunchan wantow nunang aak umpuyangaman-a, nil lat manyan theeꞌow nungant wanch alantan divorce.akan, aꞌ kuchow nunang ngula.’” ");
INSERT INTO wim_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Aꞌ nil Jesus.an thaw ngul, “Nil Moses.ana wik inangan thaw, puth niiy pam wayananga, kuchek thayan paththama, yaꞌangam nganiy maꞌ-aath-aathin niiyanga. ");
INSERT INTO wim_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Nil God.ang aak inan keenkanaman yump-a, anpalana nil kucham yump, pam aꞌ wanch, puth lat ngench thayanangan kan waaꞌ ngampar. ");
INSERT INTO wim_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Nil God.an wik inangan thaw thampa, ‘Nil pam alangana kaath piip nungantam pulang too wantowa, aꞌ pulan wanch-kunchang yipmam karpam ngul wun-wunowpula. Pul kucham ananganiya keꞌ thonam ngul weenowpula — ");
INSERT INTO wim_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","pulana pok-pokkapang keꞌ wun-wunowpul, pul keꞌ thonam anmana ngul weenowpul.’ ");
INSERT INTO wim_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Nil piip God.ana yimanangan thaw, ‘Pam wanch ngentwaynan-a, karpam anman iiy-iiyayna — wiy al-alangan keꞌ wayathayn pulang pam wanch ananganiy, pul thampaniya keꞌ wantwuwpul pulantakam, pulan ngangk minam piꞌwuwpul pulantakam.’” ");
INSERT INTO wim_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Anpalan-a, thanan pek koyam ngulan ngoonchin aawuchangan, aꞌ than ngurp nungantam anangana thawin nungant Jesus.ant wikan koochanathow thant. ");
INSERT INTO wim_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Nil Jesus.an thaw thant, “Nil pam weeꞌang wanch thum nungantaman too wantiy-a, aꞌ wanch thon ngulan maayiywey-a, yaa, an nilana way yumpan wanch thum nungantamant, nil puth maarich keeꞌ-keeꞌana wanch thon ngulan piꞌ-piꞌana. ");
INSERT INTO wim_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Thon inana, nil wanch weeꞌ alangan pam thum nungantaman too wantow-a, aꞌ pam thon ngul maayiywey-a, an nilana way yumpan pam thum nungantamant, nil puth maarich keeꞌ-keeꞌana, pam thon ngulan piꞌ-piꞌana, aakan yimanangan keꞌ wunowa.” Nil Jesus.an yimanangan wik thaw. ");
INSERT INTO wim_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ngul anpalaniy-a, pam wanch wiyangan-a, puk manyiy thanttaman wampathin nungant Jesus.antan nil yipam maꞌ wunpow thant; puth thanan ngurp nungantamanganiy-a, yaꞌ kenthin thanang. ");
INSERT INTO wim_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Nil Jesus.angan kaangk puk manyiy puth thanan wampin nungant, nil keꞌ-paal kaangk keꞌ thathow thanang kenth-kenthayn thanangan, aꞌ nil wak thanang, ngurp nungantam anangan. “Keꞌa! Niiy keꞌ kenthān thanangweya, puk manyiy inanganiya mak wampayn ngathara! puth nil God.angan kaangk maꞌ nungantang piꞌ-piꞌow thanang. Than weeꞌ-weeꞌanangan keꞌ puk manyiy yimanangan ngangk minangaman wampayn nungant God.ant-a, an nil min-minakam ngul piꞌow thanang, than maꞌ nungantang ngul wunayn. ");
INSERT INTO wim_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Than puth weeꞌ-weeꞌanangan keꞌ puk manyiy ngangk minangam keꞌan wampiythan nungant-a, an nil God.angan min-minakam keꞌ piꞌow thanang maꞌ nungantang, yaꞌa.” Jesus.aniy thaw. ");
INSERT INTO wim_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Kan-ngulana, nil puk manyiy anangan maay thanang, aꞌ maꞌ wunp thant aꞌ thaw God.ant, “Nint thath-thathān thanang, min-minam piꞌān thanang, than yipam minaman iiyayna.” ");
INSERT INTO wim_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Nil Jesus putham ngulan woyanang iiy-iiy-a, nil pam umang moꞌ-moꞌ nunganta, aꞌ pungkang nyiinant, aꞌ thaw nungant, “Moom-ang, nint mina. Nint kan inan waaꞌara: ngay want-wanttak iiyānga, ngayan yipam God.antang aak umpuyaman wunāng e?” ");
INSERT INTO wim_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Nil puth Jesus.an thaw nungant, “Nint puth pam min ngeenak waaꞌangan ngayang e? An nilam thonakam God.ana minaniya, wiy anangan yaꞌa. ");
INSERT INTO wim_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Nint puth wik ngench thayan God.antaman meeꞌmiya: niiy pamana keꞌ mulathāna; niiy wanch pam thon alantamana keꞌ maarich keeꞌathāna; niiy yuk way min meekantamana keꞌ maꞌ-kuchathāna; niiy pam wanch wiyana wik aak-yaꞌangan keꞌ waaꞌ-waaꞌān thanang; niiy pam wanch anangana keꞌ meeꞌ-thenchān thananga; aꞌ putha niiy kaath piip niiyantamana wik ngeeyāna thananga.” ");
INSERT INTO wim_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Nil puth paman thaw nungant Jesus.ant, “Moom-ang, aak anpalman ngay yippak puk manyan iiy-iiyangan-a, ngay wik ngench thayan inangan piꞌ-piꞌang thananga.” ");
INSERT INTO wim_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Nil puth Jesus.angan paman oth thath-thathan, nil kaangk paththam wun nungant. Nilan puth thaw nunganta, “Nint inan yumpān thampa. Nint iiyāna, aꞌ yuk way min nungkaram maꞌmangkaman sellingpungāna, aꞌ wukal thakan theeꞌān thant pam wanch wukal keꞌanang al-alantana. Anpalana, nint ngayang ngul monkan-wakāna. Ngulana, nil God.an min-minam paththam ngul iiyow nungkar aak ing kenyana.” ");
INSERT INTO wim_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Nil pam alangan wik inangan ngeey-a, nil kaaꞌwal wiy-wiyam weem, aꞌ ngangk way wunanta, nilan puth pam maꞌmangkiya. ");
INSERT INTO wim_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ngul anpalaniya, nil Jesus.an weent aꞌ ngurp nungantam anangan thath thanang aꞌ thaw thant, “Than pam wanch maꞌmangkiy anangan puth want-wanttak iiy-iiyiythan maꞌ God.antangan e? An yaꞌ yaakaꞌa! Puth wukal aꞌ way min anangan keeꞌ nath enchayn thanta!” ");
INSERT INTO wim_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Than ngurp nungantaman thaaꞌam ikin wik Jesus.antaman ngeeyin, nil puth Jesus.an wik putham ngul thaw, “Niiyalang, ngurp ngatharam-ang, kan in ngeeyāna, than pam wanch puth want-wanttak maꞌ God.antangan iiy-iiyayn e? ");
INSERT INTO wim_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Nil camelan puth needle yuutampang wanttak ngoonchow e? An yaꞌa! Inan puth yimanangana. Pam wanch maꞌmangkiy anangan puth want-wanttak maꞌ God.antangan iiy-iiyayn e? An yaꞌ, an thayan paththam wunow thantana, than woyan min God.antaman keꞌ nath uwiythan, yaꞌa.” ");
INSERT INTO wim_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Thanan wik inan ngeeyin-a, than ngurp nungantam anangan puy-puyam meeꞌam ikin, aꞌ thanan thaw-thawin thanttakaman, “Nil God.angan weeꞌ kaaꞌ-piichanathow e? Nath pam wanch yaꞌ yaakaꞌa!” ");
INSERT INTO wim_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Anpalana, nil Jesus.angan oth thath-thath thanang, aꞌ thaw thant, “Pam wanchangan keꞌ kaaꞌ-piichanathwiythan thanttakamana, an yaꞌa. God.ang thonakam ep pam wanchaniy kaaꞌ-piichanathiya, nil piꞌan aꞌ thayan paththama, nilan ep maꞌ-min yumpiy way min thon-thon anangana.” ");
INSERT INTO wim_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Anpalana, nil Peter.an thaw Jesus.anta, “In ngeeya, ngan kampan nganttam aꞌ aak nganttam wantan aꞌ nintang puth ngul monkan-wak-wakanana.” ");
INSERT INTO wim_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Nil puth Jesus.an thawa, “Eeꞌa, aꞌ ngay nungk inan waaꞌānga: than pam wanch wiyangan aak thanttam aꞌ kaath piipa, aꞌ kuunch thanttam thakan wantantan aꞌ puk thanttam aꞌ farm thakan wantantan, thanan yipam wik God.antaman waaꞌ-waaꞌayn thant pam wanch wiyantana, than puth kaangk paththam wuntan ngathar. ");
INSERT INTO wim_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Nil God.an ngangk min paththam ngul iiyow thant pam wanch al-alantan. Thanan pam wanch yot thaaꞌ-wantanam ngurp yumpayn thanang keꞌ kampan thanttam yimanangan keꞌ yapa, wiila, wunya, nhengka, otham thanttam yimanangana — aꞌ nil God.angan aawuch-a, yuk way min yot-yotam theeꞌow thant, aꞌ puth aak fields thampa. Puth aak an-aniyangana, than pam puungk wiy al-alangan way yumpayn thant thama. Puth ngul-ngulana, than pam wanch anangan nungantang God.antang ngul wunayn aak umpuyam.” ");
INSERT INTO wim_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Nil Jesus.angan wik thonangan inan thamp waaꞌ thant, “Than pam wanch wiyangan ngaantam-ngeeyantan than keꞌ pam wanch piꞌ-piꞌanam yimanangan iiyantana, an puth ngulana than pam wanch many ngul iiyayn. Than wiyangan piꞌan keꞌaman ngaantam-ngeeyantan thanttakamana — ngulana, nil God.angan moom piꞌ-piꞌanam yumpow thanang.” ");
INSERT INTO wim_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Anpalaniy-a, Jesusa aꞌ than ngurp nungantam weeꞌanang woyan wakan iiy-iiyin aak Jerusalem.ak. Nil Jesus.aniya, keenk iiy ngurp nungantam al-alantaman — puth than ngurp nungantam anangan ngangk ikin. Than puth pam wanch anangan kul-kulaman monkan-wak-wakin thanangan-a, winynyang moꞌin. Anpalana, nil Jesus.angan ngurp nungantaman pokkap kiikath thanang aꞌ waaꞌ-waaꞌ thant aak way ngulan wampow nungant. Nilan thaw thant, ");
INSERT INTO wim_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“In ngeeyiya, ngamp inan yiip ngul iiyāmp aak Jerusalem.aka. Than pam wiy al-alangan mamayn ngayanga, ngay pam inana nil God.angan kuchanya, aꞌ pam moom priests al-alantam aꞌ putha pam wuut manth-thayan al-alantakan maꞌam theeꞌayn ngayanga. Thananiya, karpam yalmathwayn aꞌ thawayn ngayan uthamāngana, aꞌ amanama, thanan ngayang Jews yaꞌ al-alantan maꞌam theeꞌayn ngula. ");
INSERT INTO wim_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Than pam Jews yaꞌ al-alangan thaaꞌ-thengkathayn ngayanga, thaaꞌ theekang thak makayn ngayanga, aꞌ whipang thak piikayn ngayanga, aꞌ amanamana mulathayn ngayang ngul, puth aak maꞌ-koꞌalamang ngulan wantow-a, ngay mulamana koyam ngul ekānga, aꞌ anman man-yetham ngul iiy-iiyānga.” Wik inangan nil Jesus.an thaw thant. ");
INSERT INTO wim_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Anpalaniya Jamesa aꞌ Johna, puk nhengk pam Zebedee alantaman, wamppul nungant Jesus.ant, aꞌ thawpul nungant, “Ayyang, Moom-ang, nint nath eeꞌ thawana, nath yaꞌa.” ");
INSERT INTO wim_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Nil puth Jesus.an thaw pulanta, “Nip kaangk ngeenak e?” ");
INSERT INTO wim_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Pulaniy thawpul nunganta, “Aak an-aniyangan nint moom piꞌan ngulan iiyān aak ing kenyan-a, nintan nganang keꞌ wunpin nungkarangan nyiinin ey? Nil thoniya, maꞌ malang nyiiniya, aꞌ thoniya, maꞌ thakang keꞌ nyiiniy nungkarangan ey?” ");
INSERT INTO wim_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ngul nil Jesus.an thaw pulant, “Nip ngul ngeenak yimanangan thawanip e? nip ngatharangan nyiinow e? keꞌ moom piꞌan yimanangan e? Than puth wiyangan way yumpayn ngathara, aꞌ mulathayn ngayanga. Nip ngul kaangk ey? than way nipar thampan yumpayn ey?” ");
INSERT INTO wim_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Pulan puth thawpul nunganta, “Eeꞌa, ngan kaangk than ngant thamp way yumpayna.” Aꞌ nil Jesus.an thaw pulant, “Thanan kan-kanam way yumpayn nipara; aꞌ piikayn nipanga aꞌ kul thak thawayn nipar. ");
INSERT INTO wim_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Puth ngayan keꞌ miꞌing nil weeꞌan nyiinow ngatharang keꞌ moom piꞌan yimanangana. Nilam God.an ngul thawow, nil keenkanaman kan miꞌ nil weeꞌan nyiinow ngatharanga.” ");
INSERT INTO wim_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Than ngurp nungantam ten al-alangan wikan ngeeyin pulantam James-a, John.angan pul Jesus.antan thawpul-a, thanan-a, man kul wampin pulant. ");
INSERT INTO wim_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Nil puth Jesus.anganiy-a, thanang yotaman karpam ump thanang aꞌ thaw thanta, “Niiy meeꞌmiy thanang moom aak thon-thonangan wuntan ey? Than pam wanch anangan maꞌ thayanang piꞌ-piꞌantan thananga, than thawantan thant work thantan iiyayn. Than keꞌ pam meek piꞌan anman iiyantan. ");
INSERT INTO wim_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Puth niiyaniya, yimanangan keꞌ iiyān niiy-niiyantakamana. Niiywey nath kaangk pam piꞌ-piꞌanaman iiyānwey-a, yaa, niiyan putha pam wanch wiyan maꞌ-aath-aathān thanang aꞌ minam piꞌān thanang. ");
INSERT INTO wim_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Niiywey nath kaangk keꞌ moom yimanangan iiyānwey-a, niiyan puth pam wanch wiyan minam paththam piꞌ-piꞌān thanang. ");
INSERT INTO wim_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ngay puth pam inan nil God.angan kuchanya, ngayan puth aak iikanakan ukangana ngayan yipam pam wanch anangan minakam piꞌ-piꞌāng thanang. Ngay aak iikanakan keꞌam ukangan than pam wanchangan yipam minam piꞌ-piꞌayn ngayang keꞌ moom yimanangana, yaꞌa. Ngay aak iikanakaniya ukangana ngay yipam chaapar ngatharam theetathāng pam wanch yotamant aꞌ kaaꞌ-piichanathāng thanang way thanttam anpalan.” ");
INSERT INTO wim_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Anpalaniy-a, than Jesus weeꞌanangan aak Jericho.ak wampin. Aꞌ ngulan-a, Jesus-a, ngurp nungantam anangan aꞌ pam wanch yot anangan thampa than aakan kan-ngulan wantayn-a, ngul nil pam koꞌanchwey woyan wonkang nyiin-nyiin aꞌ thaaꞌ pent-pent mayaka aꞌ wukalakweya. Namp nungantaniy-a, Bartimaeus, nhengk Timaeus.antaman. ");
INSERT INTO wim_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Aꞌ nil wik ngeey Jesus.an woyan wakanan iiy-iiy, pam anman aak Nazareth amanaman. Aꞌ nil kan-ngul pech nungant, “Ayyang, Jesus ey! Kampan David.antam ey! Nint ngayang ngangk keꞌ mamin ey?” ");
INSERT INTO wim_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Pam wanch yot al-alangan wakin nunang, “Ayyang, nint appap nyiina!” Puth nil pamana puy-puyam othamayan ngul pech-pechwey, “Ayyang! Kampan David.antam-ang! Nint ngayang ngangk keꞌ mamin ey?” ");
INSERT INTO wim_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Nil Jesus.an than aꞌ thaw thant, “Thawān nungant pal wampow ngathara.” Than puth umpin nunang pam koꞌanchan, thawin nungant, “Kanweya! Ngangk min wunow nungka! Kan ekāna! Nil thawa nint iiyān nunganta.” ");
INSERT INTO wim_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Aꞌ nil pam koꞌanch alangana coat nungantaman thapath, aꞌ wur ek, aꞌ iiy nungant Jesus.antan. ");
INSERT INTO wim_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Nil Jesus.an thawant, “Nint ngeenaka?” Nil pam koꞌanchan thaw Jesus.antan, “Ayyang, Moom-ang, ngay kaangk aak koyam thathāng ngula!” ");
INSERT INTO wim_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Aꞌ nil Jesus.an thaw nungant, “Kan iiyāna! nint meeꞌ min ngul iiyāna, nint puth kan-kanam ngaantam-ngeeyan ngayang ngay meeꞌ min koyam ngulan yumpāng nintangana.” Anpalana, pam alangan aak ngul thath, aꞌ nilana Jesus.an monkan-wak-wak nunang woyanangan iiy-iiy. ");
INSERT INTO wim_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Than Jesus-a, ngurp nungantam weeꞌanangan kan-ngul iiy-iiyin. Thananiy-a, aak Jerusalem thinth ngul wampin. Aꞌ thanan aak yoyk namp Olives angan wampin ngul. Aꞌ aak yoyk wonkang anganiy-a, village kucham thanpul, aak namp al-alantaniya Bethphage-a, aꞌ Bethany. Nil Jesus.angan ngurp nungantam kucham anangana keenk kuch pulang aak village aakanakan. ");
INSERT INTO wim_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Nilan thaw pulanta, “Nip village aakanakan iiyow. Nip angan wampowan-a, nip donkey many thathow kuuyang kathin nunang, than pam wiyangan keꞌam yippakan matin nunang. Nip kuuyan thapathow, aꞌ nip pal kalow nunang ngathara. ");
INSERT INTO wim_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Nil weeꞌan thawow nipar, ‘Nip donkey many nanan ngeenak kalanip nunang e?’, nipan thawow nunganta, ‘Nil moom nganttamangan yaan matowana.’ Anpalan-a, nil palaman ngul kuchowan nungkar.” ");
INSERT INTO wim_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Anpalan-a, pulan iiypul aꞌ donkey manyan uwpul woyanang angman than-than, kuuyang kathin nunang aawuch thaaꞌang angana. Pul kuuyan yippak thap-thapathpulan-a, ");
INSERT INTO wim_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","than pam wanch wiy anangan thinthan than-thaninan-a, thawin pulant, “Nip donkey many nalantaman kuuyan ngeenak thapathanip a?” ");
INSERT INTO wim_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Pulan thawpul thant keꞌ wik anman nil Jesus.an thaw pulant, aꞌ than pam anangan thawin pulant, “Eeꞌweya, nip kalowana!” ");
INSERT INTO wim_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Anpalan-a, pul donkey manyan wampathpul nunang Jesus.antan, aꞌ ngook pulantaman kenyangk wunppul donkey manyantangan, aꞌ nil Jesus.an kan-ngul pey man-mangk donkey many alantangan. ");
INSERT INTO wim_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Aꞌ than pam wanch yotamangan ngula ngook thanttaman woyanangan wunp-wunpin. Than wiyanganiya yuk punth pip-pipin aꞌ woyanang wunp-wunpin. ");
INSERT INTO wim_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Nil Jesus.an kan-ngulan iiy-iiy-a, than pam wanch yot thaaꞌ-wantanaman umputh iiy-iiyin nungantanga, aꞌ than pam wanch wiy ananganiya, kul-kulam iiy-iiyin nungant. Thanan wik pech-pechin, “Yeey! Yeey! Ngamp nunang God.an thaaꞌ-kuumpāmpana! Nil puth God.ang pam inan kuchana, nil mak piꞌanan yumpow nunanga! ");
INSERT INTO wim_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Nil wuut mangk ngamparam anpalan wamp, King David.antama! Nil King David.an aak ingman yippakan wun-wun-a, nil pam wanch anangan maꞌ nungantangan piꞌ-piꞌ thanang, puth nil pam ilangan yimanangan maꞌang piꞌ-piꞌow ngampangan! Ngamp God.an thaaꞌ-kuump-kuumpāmp nunanga!” ");
INSERT INTO wim_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Anpalan-a, nil Jesus.an aak piꞌan Jerusalem.ang kan-ngul ngooncha, aꞌ nil aawuch ngench thayanang ngoonch, aꞌ pal-puy thath-thath. Puth aakan kinch-wayang ngul wuna, nilan keꞌ-paal aak Bethany aakanakan iiy, than ngurp nungantam anangan karpam iiyin nungantangan. ");
INSERT INTO wim_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Aak ngaaꞌ thonang ngulaniy-a, than aak Bethany anpalan palam wampin, nil Jesus.an meech ngul ween. ");
INSERT INTO wim_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Nil yuk kom kecham thath, yukaniya kangkathiy, aꞌ nilaniy puth iiy yukan thathow nath may thamp, nath yaꞌa; aꞌ nil yuk aakanakan kanan wamp-a, nil yuk anan kangkam thonakam thath, puth aak yimananganiya yuk alangana may keꞌ yippak piꞌiy. ");
INSERT INTO wim_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Anpalaniya, nil Jesus.an yuk kom alantan thaw, “Pam wanchangana may nungkaramana keꞌ-ngul mungkayna, yaꞌa!” Than ngurp nungantam al-alangan wik inangan ngeeyin nunang nilan thaw. ");
INSERT INTO wim_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Anpalaniya, than kan-ngul iiyin aak Jerusalem.akan. Than kan-ngulan wampin-a, nil Jesus.an aawuch ngench thayanak iiy, aꞌ nil thath thanang pam wanch anangan than minh bullocks thak piiy-piiyina aꞌ sellimpung-pungin aawuch ngench thayan angana. Aꞌ nilan kenth thanang. Nil table thakan wew theeꞌ thanttam pam al-alantaman wukalan piꞌ-piꞌin, aꞌ putha yuk chairs anangana, um pekam theeꞌ ngul pam al-alantamana minh munkiyang anangana sellimpung-pungin. ");
INSERT INTO wim_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Aꞌ puth nilan thaw thant pam wanch al-alantan yuk way min may thakan keꞌ kal-kalayn aawuch ngench thayan wakanana. ");
INSERT INTO wim_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Amanamaniya nilan thaaꞌ-aath-aath thanang pam wanch anangan, nil thaw thant, “Than keenkanamana wik inangan God.antamana lat ngench thayanangan umpin, ‘Than aawuch ngench ngatharaman aak pam wanchantan meeꞌ-wuthanamanakan waaꞌayn, than pam wanch yot aak nath-nathan wuntan, angman puth yalmathwayn thanttakaman meeꞌ-wuthanamak,’ puth niiy pam wanch il-ilangan aawuch iikanakan yalmathwuniy yipam wukal way min wiyantaman maꞌ-kuchathāna.” ");
INSERT INTO wim_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Than pam piꞌ-piꞌanam priests aꞌ puth pam teachers anangan wik thayan anangan thaaꞌ-aath-aathinan-a, thanan ngeeyin nunang wik anangan nil Jesus.an thaw-a, thanana kan-ngul ngaantam-ngeeyin thanttakaman Jesus.an mulathayn nunang. Puth thanana winynyang moꞌ-moꞌin nungantam ngeenam putha than pam wanchangan wik nungantam anman kaangk ngeey-ngeeyayn wik min nilan waaꞌ-waaꞌ thant. ");
INSERT INTO wim_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Aak ngaaꞌ ngulan wun-a, Jesus-a, aꞌ putha ngurp nungantam anangan, than aak piꞌan Jerusalem.ana kan wantin. ");
INSERT INTO wim_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ngaaꞌthiyangam ngulaniy-a, than woyan wakanan iiy-iiyin-a, than yuk anman koman thathin kan-ngul utham, yuk punth-a, aꞌ aakanakam pek thaꞌ kumanakam. ");
INSERT INTO wim_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Aꞌ nil Peter.angana erkam ngaantam-ngeey paththam ngeenamana yukan uthama aꞌ thaw ngul Jesus.antan, “Ayyang, Moom-ang, in thath ee! wik nintan thawan yuk ilantana uthamow ngulana, an kan-kanam uthama, yukaniy.” ");
INSERT INTO wim_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","23","Aꞌ nil Jesus.an thaw thant ngul, “Niiy puth kan-kanam ngaantam-ngeeyān God.ana nilana min aꞌ maꞌ-kunch, niiy keꞌ man-ngeeyān nunanga. Niiywey God.an kan-kanamwey ngangkang piꞌ-piꞌin nunang-a, yaa, niiy yoyk ilantan thawinwey, ‘Eka! Puy ngakang theeꞌān nungkamanga,’ an nil God.angan paththam yumpiya wik niiy anangan thawana. ");
INSERT INTO wim_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Yaa, ngay in waaꞌāng niiyant: niiywey ngeenak nathanweya thawin God.antan-a, niiy kan-kanam ngaantam-ngeeyān nil theeꞌow niiyant, aꞌ anpalana, nil paththam theeꞌow niiyant. ");
INSERT INTO wim_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Aꞌ niiy meeꞌan wuthanamān God.antan-a, way anangan kon-ngathow niiyang than wiyangan yump-yumpin niiyant, yaa, nil puth piip ngamparam God.angan-a, keꞌ-ngul ngaantam-ngeeyow way niiyan yump-yumpana. ");
INSERT INTO wim_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Niiyang keꞌwey kon-ngathow than niiyantan way yump-yumpin-a, yaa, piip ngatharam in kenya keꞌ kon-ngathow nunang way niiyan yump-yumpan.” ");
INSERT INTO wim_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Than Jesus weeꞌanangan putham ngul wampin aak Jerusalem.angan. Anpalan-a, nil Jesus.an aawuch ngench thayanangan ngoonch-a, aꞌ pal-puy iiy-iiy, aꞌ than moom priestsantam anangan-a, aꞌ puth than pam teachers anangan wik thayan God.antaman thaaꞌ-aath-aathin thanangan-a, aꞌ puth than pam wuut manth-thayan anangan wampin nungant, ");
INSERT INTO wim_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","aꞌ thawin nungant, “Nungkar ngul weeꞌ thaw work piꞌan anangan yump-yumpān thananga? Nintang weeꞌang kuch e?” ");
INSERT INTO wim_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","30","Aꞌ nil Jesus.an thaw thant, “Ngay kan in engkāng niiyanta, aꞌ niiyan ngatha waaꞌān, nil weeꞌ thawant pam John alantan pam wanch kootr ngakangan kuungk-kuungkow thanang e? Nil God thawant ey? Nath pam wanch thawin nungant ey? Niiy nath waaꞌin ngatharan-a, ngay ngul waaꞌāng niiyant nil weeꞌangan kuch ngayangan.” ");
INSERT INTO wim_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Thananiya kan-ngul thaw-thawin thanttakamana, “Ngamp ngul wanttak thawāmp e? Ngampwey yimanangan thawimp nunganta, ‘Nil God thaw nungant John.antan-a,’ nil puth Jesus.an thawow ngampar, ‘Ngul niiy John.an wanttak keꞌam ngaantam-ngeeyan nunang wik min God.antaman waaꞌ-waaꞌ niiyantan a?’ ");
INSERT INTO wim_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Puth ngampwey thawimp yimanangana, ‘Pam wanch thawin nungant John.antan-a,’ an ngul wanttaka?” Thanan puth winynyang moꞌin pam wanchantam, than pam wanch maꞌmangkamangan puth ngaantam-ngeeyin John.an nil pam prophetan iiy-iiy. ");
INSERT INTO wim_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Aꞌ thanan thawin nungant Jesus.antan, “Ngan meeꞌmiy yaꞌa.” Aꞌ nil Jesus.an thaw thant, “Yaa, ngay puthangkana keꞌ waaꞌing niiyant nil weeꞌangan kuch ngayang aak iikanakana, yaꞌa.” ");
INSERT INTO wim_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Anpalana, nil Jesus.angan wik kath waaꞌ thant, nil koochanam keꞌam thaw thant, nil wik kath anman waaꞌ thant. Aꞌ nil Jesus.an thaw ngul, “Ayyang, niiy wik kath inan ngeeyāna. Nil pam thonam alangana aak piꞌan weꞌar piꞌ-piꞌ nungantakaman, aak may kaampanakan, aꞌ nil may kaangkantam kaanch yot kaamp-kaamp thanang garden nungantamang angana. Aꞌ nilana fence ngul yump, aꞌ anpalaniya nil awar piꞌan weꞌ, may kaangk menchan ngulan weemayn-a, than yipam angan wunpayn thanang aꞌ thaꞌang ngulan maak-maakayn, may kaman yipam pich-pichathayn. Aꞌ amanamaniya nil aawuch achantang ngul kaach than yipam aak thath-thathayn anpal kenyan, than wiyangan keꞌ yipam may kaangk anangan maꞌ-kuchathayn. “Anpalaniya, nilan thaw pam wiyantan aak gardenan thath-thathayn, minam piꞌ-piꞌayn nungantwey. Aꞌ nilan thaw thant, ‘May kaangk nanangan kanan menchan weemayn-a, niiyaniya yaarkathān thanang niiyantakama, puth puungk wiyiya ngathar piꞌāna.’ Aꞌ nil moom anan-a, kan-ngul iiy aak thonaka. ");
INSERT INTO wim_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ngul-ngulana, aakan kan-ngul wamp thant may kaangk menchan anangan yalmathayna. Nil moom alangan pam nungantaman kuch nunang, aak garden nungantakamakan, may kaangk anangan uwow nungant. ");
INSERT INTO wim_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Nil aak angan kanan wamp-a, than pam al-alangan gardenan piꞌ-piꞌin-a, than mamin nunang, aꞌ piik-piikin nunang, aꞌ maꞌ-thaanch koyaman kuchin nunang. ");
INSERT INTO wim_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ngul-ngulana nil moom alangan pam nungantam thonangan ngul kuchan, puth than pam al-alanganiy-a, kuchek piik-piikin nunang, aꞌ way paththam yumpin nungant. ");
INSERT INTO wim_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ngul anpalaniy-a, nil moom alangan pam thonangan ngul kuch nunang, puth than pam al-alangan mulathin nunang. Anpalaniy-a, nil pam wiy anangan kuch thanang, puth thanan way anman yumpin thant yotamant; wiy anangan-a, piik-piikin thanang, aꞌ puth wiy anangan-a, mul-mulathin thanang. ");
INSERT INTO wim_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Nil pam moom alangan pam weeꞌ-nath kuchiy ngula? Nilan pam nungantam yotam anangan kanam kuch thanang, nhengk nungantam thonakaman keꞌam yippak kuchan. Nil kaangk paththam wunant, nhengk-kunchantan puth nil thaw, ‘Than ngul ngaantam-ngeeyayn puk nhengk ngatharamana, nil puth pam piꞌan thama, keꞌ piikiythan nunang,’ aꞌ anpalana, nil kuch nunang. ");
INSERT INTO wim_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Puth than pam al-alangan thathin nunangan wamp-wamp thantan-a, thanan thawin thanttakamana, ‘Ayyang, pam inmana, puk nhengk moomantama! Ngamp mulathāmp nunang, aꞌ ngampan aak garden inan ngamparakam ngul piꞌāmpa!’ ");
INSERT INTO wim_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Aꞌ thanan purpam mamin nunang aꞌ mulathin nunang aꞌ piw theeꞌin nunang yoon aak garden anpalan.” ");
INSERT INTO wim_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Nil Jesus.an engk ngul thant pam wanch al-alantan, “Niiy ngul wanttak ngaantam-ngeeyaniy wik kath inaniye? Nil piip-kunchan wanttak nath yumpow thant pam al-alantana? An nil wampow, aꞌ mulathow thanang, aꞌ nilana pam wiyant ngul thawow aak garden nungantaman piꞌayna.” ");
INSERT INTO wim_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Aꞌ nil Jesus.an thaw ngul thant, “Niiy ngul lat ngench thayan anpalan keꞌam wichan ey? wik inangan ey? ‘Than pamang aawuchan kaachantan-a, wiyiya than nath yuk pal pekkuwan aawuchantangan wunpantan-a, an piw theeꞌantan, puth thanan ngaantam-ngeeyantan keꞌ yuk waya. Puth yaꞌa, yuk pal pekkuwan aawuchantangana an min paththama, aawuchan thayanam yipam thanow. An puth keꞌ yimanangan pam wanch wiy al-alangan kaangk keꞌ ngayang, monkanam iiyantan ngatharam. Puth ngayana keꞌ yuk pal pekkuwan aawuchantangan anman thanan piw theeꞌina. ");
INSERT INTO wim_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Puth ngul-ngulana nil God.angan pam wuut piꞌan paththam yumpow ngayang! Ina min paththam wunowa!’” ");
INSERT INTO wim_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Nil Jesus.angan wik kath inangan waaꞌ-waaꞌ thant-a, than pam piꞌan Jews al-alangana keꞌ mamiythan nunang, puth than meeꞌmiy nil thanangan waaꞌ-waaꞌ, than pench ekin wik kath anpalan. Puth thanan winynyang moꞌin pam wanch yot al-alantaman, than wiy wantin nunang aꞌ puyam iiyin. ");
INSERT INTO wim_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Than pam Pharisees al-alangan aꞌ puth pam Herod.antam al-alangan karpam ngul wik yump-yumpin, aꞌ thawin, “Ngamp putham mepāmp nunanga, yaan paathāmp nunang nil nath Jesus.an wik want-wanttakan thawow ngampar.” Thananiya pam thanttam wiy anangan kuchin nungant. ");
INSERT INTO wim_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Than iiyin nungant Jesus.antana, aꞌ thawin, “Ayyang, moom-ang, ngan kan meeꞌmiy nint wik kan-kanam anangan thaw-thawangana, puth woyan min God.antaman kan-kanam thaaꞌ-aath-aathangan nganang. Nungkway than pam wanch wiyangan ngangk-wayangaman kal-kalantan nintang-a, puth nintana keꞌam ngaantam-ngeeyangan, kon uth anman iiy-iiyangan. Puth nint pam piꞌan al-alantaman keꞌam winynyang moꞌangan yaꞌa, nint keꞌ-ngoongkam wik kan-kanam anman waaꞌ-waaꞌangan pam wanchantan. Yaa, nint puth wik waaꞌān nganta nint wanttakan ngaantam-ngeeyangana. An ngul kan-kanam ey? ngan ngul wukal theeꞌin ey? keꞌ income tax yimanangan ey? pam moom piꞌan alantan ey? aak Rome.angan wunan ey? nath yaꞌa, keꞌ theeꞌin nungant.” ");
INSERT INTO wim_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Aꞌ nil puth Jesus.angan kanam thiich thanang pam anangan than pam min yaꞌa, than yaan paath-paathin nunang, nil puth thaw thant, “Niiy ngul ngeenak thaachaniy ngayanga? ngay yipam way-wayak thawāng niiyant ey? An yaꞌa! Niiy wukal thonam pal kalānar, ngay kan thathānga!” ");
INSERT INTO wim_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Thanan wukal anana wampathin nungant, aꞌ nil puth Jesus.an thaw thant, “Wukal ilangan kaaꞌwal weeꞌantam piꞌan a? puth namp thamp weeꞌantam wukal ilantangan wun a?” Puth than pam anangan thawin nungant Jesus.antan, “Pam moom piꞌan alantaman aak Rome.angan wunana.” ");
INSERT INTO wim_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yaa, nil Jesus.an thaw thant, “Than wukal tax aakanakan thawayn niiyantan-a, pam piꞌ-piꞌanam anangan-a, niiy wukal wiyana koyam theeꞌān thantanweya. Puth nil God.angan ngampangan yumpa, ngampana ngangk ngamparamana koyaman theeꞌāmp nunganta.” Than wik inangan ngeeyinan-a, than thaaꞌam ikin ngul Jesus.antan. ");
INSERT INTO wim_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Anpalan-a, pam puungk wiy Sadducees anangan wampin nungant. Than Sadducees il-ilangana, than ngaantam-ngeeyin pam wanch mulan wuntan-a, keꞌ koyaman keꞌ ekiythan. Than thawin nungant Jesus.antan, ");
INSERT INTO wim_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Ayyang, Moom-ang, pam Moses.ang keenkanamana wik yimanangan ump, ‘Nil pamwey puk keꞌanangan uthamiw-a, yaa, nil pont nungantam alangan wanch wukalongkan maayow nunanga, pul yipam puk uwowpula, thanan yipam ngaantam-ngeeyayna puk anangana keꞌ pam mul alantamana.’ ");
INSERT INTO wim_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Puth nint kan wik kath inan ngeeyāna: aak keenkanamana, than maꞌ-kuuncham pam seven wunina. Wuny thanttamangan kaꞌatham wanch maay — ngul-ngulaniya, nil puk keꞌanang utham ngul. ");
INSERT INTO wim_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Pam kuunch nungantam thon alangan ngul maay nunang wanch wukalongkana, aꞌ nil tham ngul puk keꞌanang utham. Aꞌ pam kuunch nungantam thon alangan ngul maay nunang wanch wukalongkana, aꞌ nil yinang puk keꞌanang tham utham. ");
INSERT INTO wim_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Pam kuunch nungantam maꞌmangkam al-alangan maay-maayin nunang, wanch wukalongkana, aꞌ than maꞌmangkamana puk keꞌanang anman uth-uthamin. Ngul-ngulaniya, wanch wukalongk anman utham. ");
INSERT INTO wim_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Kan in ngeeyiya! Aak ngulan wampowan-a, than pam wanch mulaman koyaman ngulan ekayn-a, man-yetham koyaman iiyayn-a, nil wanch wukalongkana wanch thum pam weeꞌantam ngul iiyowa? Puth nil wanch alangana pam maꞌ-kuuncham seven anangaman maay thananga!” ");
INSERT INTO wim_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Aꞌ nil Jesus.an thaw ngul thant, “Niiy wik way-way thawaniya! An puth niiy keꞌam wik min God.antam anangana min-minam ngaantam-ngeeyaniya, wik lat ngench thayanangana aꞌ putha niiy min-minam keꞌam thiichaniy nil piip God.an pam wuut piꞌan paththamana! ");
INSERT INTO wim_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Than pam wanch yotamana mulaman ekayn-a, aꞌ man-yetham koyam ngulan iiy-iiyayn-a, an thananiya keꞌ ngaantiyongk anman iiy-iiyayn ing kenyana, keꞌ-ngul ngentwayn, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Niiyiy wik anman thaw-thawaniy than pam wanch mulaman keꞌ yaakaꞌ ekayna. Niiy ngul wik kath Moses alantaman kanam ngeeyan ey? lat ngench thayan anpalan ey? nilan thum nganthan thath yuk waakamangan, puth yukana keꞌam pench-pencha. Nil puth God.an wik inangan Moses.antan thaw, ‘Ngayiya God inman, thanttam pam Abraham-a, puth Isaac-a, aꞌ Jacob weeꞌanang al-alantamana.’ ");
INSERT INTO wim_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Nil God.ana God thanttam pam wanch man-yethaman iiy-iiyantan, pam wanch mul al-alantaman yaꞌa. Niiy wik way-way thawaniya!” ");
INSERT INTO wim_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Nil pam thonamaniy-a, angman than-than thanttang, ngeey-ngeey thanang wikan thaw-thawin. Nil pam ilangan-a, pam wanchan thaaꞌ-aath-aath thanang wik ngench thayanan. Nil ngeey nunang Jesus.an wik minan thaw thant Sadducees al-alantan, nil puth iiy nungant aꞌ thawant, “Ayyang, lat ngench thayanangan-a, wik thayan God.antaman yot ngampar ngeeyanakana! Nint keꞌ miꞌin wik thayan thonam min paththaman ey?” ");
INSERT INTO wim_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Nil puth Jesus.an thaw nungant, “Wik inangan kan-kanam min paththam niiyant ngeeyanakan. ‘Niiyala, niiy pam wanch aak Israel.angan wunaniya, kan in ngeeyāna: nil piip God ngamparaman-a, nilam thonam anman moom piꞌan ngamparama, wiy yaꞌa, nilam thonakama. ");
INSERT INTO wim_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Niiy ngangk minangam anman iiy-iiyān nungant, koochanam iiyān, man-kuchaman yaꞌa, aꞌ wik nungantaman ngangkangam piꞌ-piꞌān, wik maꞌmangkam anangan ngeeyāna.’ ");
INSERT INTO wim_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Aꞌ thon inan ngeeyāna: ‘Niiy paththam kaangk wunān pam wanch puk wiyantana. Keꞌ niiyan min-minam piꞌ-piꞌwuniy niiyantakaman-a, yaa, niiyiya yimanangan pam wanch wiy al-alantan ngangk minangam iiy-iiyān thant.’ Wik thayan kucham inangan karp wunanpul, an min-minam paththama!” ");
INSERT INTO wim_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Nil pam alangan wik Jesus.antaman ngeey-ngeey-a, aꞌ thawant Jesus.antan, “Ayyang, Moom-ang, nint minam thawana. Nint kan-kanam thawana nil Lord ngamparaman God thonam anman, nilam thonakaman, wiy yaꞌa; ");
INSERT INTO wim_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","aꞌ ngamp kan-kanam ngangk minangam anman iiy-iiyāmp nunganta, koochanam iiyāmpa, man-kuchaman yaꞌa, aꞌ ngamp wik nungantaman ngangkangama piꞌ-piꞌāmp wik maꞌmangkam anangan ngeeyāmpa! Aꞌ ngamp pam wanch wiy al-alantan kan-kanam kaangk wunāmp thant, aꞌ minam piꞌ-piꞌāmp thanang keꞌ ngamp ngamparakaman piꞌ-piꞌwunamp. Wik kucham inangan kan-kanam min paththam ngampar ngeeyanakan. Ngamp nath minh thonakaman kalimp nungant God alantan-a, altarangan wunpimp nungant-a, puth keꞌwey wik nungantam inangan ngeeyimpwey-a, an way ngampar.” ");
INSERT INTO wim_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Nil Jesus.angan ngeey nunang wik minan thaw-a, nil puth thaw nungant, “Nint wanttaka? Nint kan ngathar ngangk theeꞌān ey? Nint God.antan thinth-thinth kan-ngul wamp-wampangan, nil yipam maꞌ nungantang piꞌow nintang.” Anpalman ngulan-a, thananiya winynyang ngul moꞌ-moꞌin nungantam Jesus.antamana, thananiya keꞌ-ngul wikak thakan engkin nungant, yaꞌ anman. ");
INSERT INTO wim_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Anpalaniy-a, nil Jesus.angan pam wanch thaaꞌ-aath-aath thanang aawuch ngench thayanangan. Nil thaw thant, “Than pam anangan wik ngench thayanan thaaꞌ-aath-aathantan-a, thananiy thawantana nil David.ana wuut mangk nungantamaniya, pam alantaman nil God.angan kaaꞌngak kuchowan ngampar. Than ngeenam yimanangan thawantana? ");
INSERT INTO wim_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Nil puth Ngeen-Wiy Min God.antaman thaw nungant David.ant wik inangan waaꞌowa: ‘Nil Lord God.ana moom ngatharamant thawa: Nintaniya moom piꞌan ngatharang iiy-iiyāna; aꞌ ngay ngul maalathāng thanang than nintangan ngangk-wayangaman kal-kalayn. Nintaniya moom karangk paththam iiy-iiyān thantana.’ ");
INSERT INTO wim_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Wik iniya David.angan waaꞌ. Niliya Christ.ana moom nungantam waaꞌ nunang. Puth nil David.ana wanttak Christ.antaman wuut mangk weem a!” Nil Jesus.angan yimanangan mep thanang. Anpalan-a, pam wanch yotangan ngangk minangam ngeeyin nunang, Jesus.an. ");
INSERT INTO wim_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Nil thaaꞌ-aath-aath thanang, aꞌ thaw thant, “Niiy kan thathān thanang, pam wuut manth-thayan anangana, than min yaꞌa! Thanan keꞌ meek yimanangan kaangk iiy-iiyayn. Than kaangk ngook ongk ngoonch-ngoonchayn, than wiyangan yipam thathayn thanang, aꞌ thanan kaangka pam wanch anangan umang iiyayn thant aak town wakanana. ");
INSERT INTO wim_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Aꞌ putha, than aak churchakan iiyayn-a, thanan kaangk umputh nyiinayna, thanan yipmam pam wanchangan thathayn thanang, aꞌ putha than may party.akan iiyayn-a, thanan kaangk aak min-minangam nyiinayna. ");
INSERT INTO wim_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Than yuk way min wukalongk al-alantaman maayantan thak, puth-a, than aawuch thanttamangana than ngul ngoonchantan, keꞌ aawuch thanttam yimanangan ngula, aꞌ thanana yaam anman meeꞌ-wuthanamantan pam wanchangan yipam ngeeyayn thanang. Nil God.angan kan-kanam paththam wayathow thananga! keꞌ wiy yaꞌa!” ");
INSERT INTO wim_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Anpalan-a, nil Jesus.an aak churchangan nyiin-nyiin, nil yuk ik wukalak thinth angan nyiin-nyiin, thath-thath thanang wukal God.antan wunp-wunpin, pam wanch yotangan. Pam wiyaniy-a, maꞌmangkiy, than ep wukal piꞌan wunp-wunpin meeꞌ yotantang. ");
INSERT INTO wim_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Anpalana, nil wanch wukalongk anan ngoonch, wanch inaniya, nil wukal keꞌanangwey, aꞌ nilan wukal manyiy kucham keꞌ two cents yimanangan ikangan wunp. ");
INSERT INTO wim_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Anpalana, nil Jesus.angan ngurp nungantam anangan ump thanang aꞌ thaw thant, “Niiy kan thathan thanang ey? Than wiyangan ep wukal piꞌ-piꞌanam ikangan wunp-wunpin aa! Nungkway nil wanch wukalongk ilangan wukal many wunp ikangan-a, an min meeꞌ God.antangana, an nil God.angan keꞌ wukal piꞌan thath-thathan meeꞌ nungantangana. ");
INSERT INTO wim_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Than puth wiy ananganiya min yaꞌa, puth nungkway than wukal piꞌanan wunp-wunpin-a, an min yaꞌ meeꞌ God.antangan, puth thanan keꞌ wukal many theeꞌin, thanan puth wukal thaꞌiy thanttakam piꞌ-piꞌantan, maꞌmangkiy iiy-iiyantan. Puth nil wanch wukalongk alanganiy-a, wukal nungantam maꞌmangkam wunp ikangan, wukal anan nil keꞌ may piiyanakan piꞌ-piꞌwey-a, anan wunp.” Wik inan nil Jesus.angan waaꞌ. ");
INSERT INTO wim_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Anpalaniy-a, nil Jesus.angan aawuch ngench thayan kanan want-a, ngurp nungantam thonam anan thaw nungant, “Ayyang, moom-ang, an thath a! Aawuch ngench thayanan min-minam paththam a! aꞌ wuut piꞌan thampa! Puth kunttow anangana achantanga, piꞌan thampa!” ");
INSERT INTO wim_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Nil puth Jesus.an thaw nungant, “Eeꞌa, nint aawuch piꞌ-piꞌanam inangan thath-thathangan ey? Aak ngul-ngulana than pamangan aawuch min-minam anangana ngul wayathayn, aꞌ puth kunttow wuut piꞌ-piꞌanam anangana aakang ngul keek-keekathayn.” ");
INSERT INTO wim_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ngul-ngulana than Jesus weeꞌanangana kaawam ngul iiyin aak achantangak aak namp alantaniya yoyk Olives, aꞌ angman nyiinin um aawuch ngench thayan aakanakan. Peter-a, James-a, John-a, putha Andrew than wampin nungant Jesus.antan aꞌ thanama pokkapang thawin nungant, ");
INSERT INTO wim_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Ayyang, than ngul aawuch ngench thayanan aak ngeen ngul keekathayn a? Nil puth God.angan ngeen meenathow ngant aakan kan-kanangan wampowa?” ");
INSERT INTO wim_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Nil puth Jesus.an thaw thant, “Niiy meeꞌ yanth-yanth ngul iiyān a! Than pam wanch wiyangan keꞌ muukamathayn niiyang a! ");
INSERT INTO wim_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Than yot thon-thonam ngul wamp-wampayna, thananiya yaan wik uuy-uuyamayn, muukamayn than keꞌ ngay yimanangana, waaꞌ-waaꞌayn thanttakama, yimanangan thawayn, ‘Ngay Jesus Christa, God.angan kuchanya,’ puth yaꞌa. Pam wanch wiyanganiya ep wik ngeeyayn thanang. Puth wiyanganiya yaꞌa, wik keꞌ ngeeyiythan thanang yaꞌa. ");
INSERT INTO wim_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Niiy wik wolmp ngul ngeeyān kul karkanan pekwayn niiyantang thinth, aꞌ niiyiya wik thooꞌ ngul ngeeyān aak nath-nathan pekwayn. Puth niiyana keꞌ winynyang moꞌāna. Nungkway than nath kul piꞌanan pek-pekwiythan-a, aakan keꞌ yippak minchowa. ");
INSERT INTO wim_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Than moom piꞌan aꞌ pam thanttam aak thon-thonaman anman pek-pekwayn; than pam wiy anangan thaaꞌnganth thon al-alantan ngul iiyayn aꞌ than pekwayn. Aꞌ aakan thamp nath-nathan wunyathow, earthquake.anga. Aꞌ putha aak puungk wiyangana may keꞌanang wunayn. An puth wayan chil-chil yippaka, puth ngul-ngulana ep way piꞌan paththam wampow. Aak inana aak yimanangan wunow keꞌ wanchang pukan uwow yimanangana. Kaꞌathamana nila many-many uwana iimpan pek-pekanan nunang, amanamana piꞌanang ngul uwan nunang pukan kalow. Aakana yimanangan wunow.” ");
INSERT INTO wim_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Nil puth Jesus.angana wik thayanath thanang, nilan thaw ngurp nungantam al-alantan, “Niiy meeꞌ yanth-yanth iiyān puth thanana mamayn niiyanga aꞌ courtak kalayn niiyang. Thananiya piikayn niiyang churches Jews.antam angana; aꞌ putha than thanathayn niiyang umang pam piꞌ-piꞌanam al-alantangan, puth niiy ngayang monkan-wak-wakaniya anpalana. Than maka puth niiyaniy-a, wik min ngatharaman anman waaꞌ-waaꞌān thanta. ");
INSERT INTO wim_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Pam wanch ngatharamangana wik min ngatharamana waaꞌ-waaꞌayn pam wanch yotantan aak nath-nathan wuntan, yaa, anpalaniya aak inan kan-ngul minchow. ");
INSERT INTO wim_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Than mamayn niiyang-a, aꞌ umang thanathayn niiyang courtangan-a, niiyaniya keꞌ kuchek wayamāna, niiy keꞌ ngaantam-ngeeyāna niiy wanttakan thawāna, yaꞌa. Nil piip God.angan ngul meenathow niiyant niiy wik ngeenan thawān thant. Niiy keꞌ wik kuchek waap niiyantam anpalan thawān yaꞌa; nil Ngeen-Wiy God.antam alangana ngul meenathow niiyant, niiy wik ngeen nathan thawān thant. ");
INSERT INTO wim_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Aak an-aniyangan-a, pam wiy al-alangan-a, pam kuunch thanttam anangan maꞌam theeꞌayn thananga pam wiyangan mulathayn thanang; putha piipiy wiyanganiya maꞌam theeꞌayn puk thanttam anangan wiyangan mulathayn thanang; aꞌ puk nhengk wiy al-alangana kaath piip thanttam ngangk-wayangam kalayn thanang aꞌ maꞌam theeꞌayn thanang wiyangan yipam mulathayn thanang. ");
INSERT INTO wim_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Pam wanch yotangan ngangk-wayangam kal-kalayn niiyang, puth anpalan niiy ngayangan monkan-wak-wakaniya. Nil weeꞌanganweya murkanam anman monkanan-wak-wakow ngayang anman-a, keꞌan eenchow-a, nilaniya ngangk aak umpuyangam wunow piip God.antangan. ");
INSERT INTO wim_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“In ngeeyiya! Ngulan-a, pam thonamana, way-wayam paththam wampow, aakan wakow. Nil yuk way thanathow aak ngenchangana. Niiy min-minam ngaantam-ngeey-ngeeyān wik anangan ngayan waaꞌ-waaꞌangan niiyant. Aak way inan wampowan-a, niiy aak Judea punchan nanangan-a, nath moꞌān aak yoykaka. ");
INSERT INTO wim_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Niiywey aawuch yoonan nyiin-nyiininwey-a, niiyan putha koyamana pek keꞌ ngoonchān aawuch niiyantamangan, way minan keꞌ maayān thanang — an niiyana puy-puyam ngeetān paththam yoykakana. ");
INSERT INTO wim_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Niiy nathwey aak kangkangan wuninwey-a, niiy aawuchangana koyam keꞌ ngoonchān yipam way min niiyantaman maayāna, an yaꞌa. ");
INSERT INTO wim_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Aak inan ngulan wampow-a, an aak way wun-wunow thant wanch iimpanang al-alantana aꞌ putha wanch pul-many al-alantan maꞌ puk manyangana. ");
INSERT INTO wim_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Niiy meeꞌ-wuthanamān piip God.anta aak inana aak kaapan keꞌ yipam wampowa, ");
INSERT INTO wim_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","an puth aak way-wayam paththam wampowa. Aak keenkanam nathpalman nil God.angan aak inan yump-a, aꞌ aak in-inman ngula, aak kaꞌathaman yimanang keꞌam wamp way-wayam paththaman. Ngul-ngulaniy-a, aak wayan kan-ngulan minchow-a, aak wayan chil-chil ngul wampow. ");
INSERT INTO wim_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Aak wayan wampow-a, an yaamana keꞌ wunow an erkama ngul minchow aꞌ amanamana nil piip God.angan keꞌ-ngul wayaniy kuch-kuchow aakan minam ngul wunow. Puth aak yaamwey wayan than-thaniw-a, an puth pam wanch maꞌmangkaman uthamiythan. Nil God.angana ngaantam-ngeey pam wanch nungantam anangan nilan miꞌ thanang, puth anpalana nilan ngaantam-ngeey aak wayan yaam keꞌ wuniy.” ");
INSERT INTO wim_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Aꞌ nil Jesus.an thaw thant, “Than pam wanch nath thawiythan niiyant, ‘Niiyalang, pam nilan nanana God.angan kaaꞌngakan ngamparan kuchowa!’ Nath thawiythana, ‘Ayyang, nil anana!’ — puth niiyana keꞌ wik ngeeyān thanttaman. ");
INSERT INTO wim_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Puth pam wiy anangana wampayn aꞌ waaꞌayn thanttakaman than keꞌ pam anan nil God.angan kuchan, wiyangiya keꞌ pam prophets anangan waaꞌayn thanttakam, puth yaꞌa, than yaan muukamathayn niiyang. Thanan work piꞌ-piꞌanaman ngul yumpayn thanan yipam yaan muukamathayn pam wanch God.antam anangan. ");
INSERT INTO wim_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Niiy meeꞌ yanth-yanth iiyān thanttama. Ngay inan keenk-keenk wik thay-thayanathang niiyang.” ");
INSERT INTO wim_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ngul-ngulana aak wayan keꞌ-ngul than-thanow, an yaꞌ-ngul, anpalana, kinchana ngotan ngul wunow, aꞌ putha kepana keꞌ-ngul park-parkow aak ngutangana, an yaꞌ-ngul, ");
INSERT INTO wim_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","thunp anangana keekayn ngul aak anpal keny, aꞌ kinch-a, kep-a, aꞌ putha thunp anangan pal-puyan wunayn. ");
INSERT INTO wim_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Aꞌ than pam wanchangana ngul thathayn ngayang pal uk-ukāng yuwangana, ngay pam inman God.angan kuchanya. Ngay pam piꞌan aꞌ karangk ukānga, min-minam paththama! ");
INSERT INTO wim_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ngayana ngaantiyongk ngatharam anangan ngul kuchāng thanang nath-nathan iiyayn, kungkam-a, yiipam-a, kaawam-a, kuuwam iiyayn, aꞌ thananiya pam wanch God.antam anangan yalmathayn thanang nilan miꞌ thanang, aak thon-thon nath-nathpalan yalmathayn thanang pam wanch anangan.” ");
INSERT INTO wim_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Aꞌ nil Jesus.angana wik kath ngul waaꞌ thant. Nilan thaw, “Niiy ngaantam-ngeeyāna yuk kom anangan. Yiikanan pentantan kangk nyiingkanaman-a, yaa, niiy meeꞌmiy aak kayamanana kan-kanang wampan. ");
INSERT INTO wim_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Aꞌ niiy kinch ngulan thathān ngaaꞌan wunow-a, putha thunp anangan keekayn thakan-a, yaa, niiyana meeꞌmiy weenān aakan thinth ngul wampan ngathar ngay palaman wampānga. ");
INSERT INTO wim_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Aꞌ niiy inan thamp ngaantam-ngeeyāna: aak anan wampowan-a, puungk wiy inanganiy niiya man-yetham yippak iiy-iiyānweya. ");
INSERT INTO wim_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ngul-ngulana aak inana putha aak in kenyan minchow ngula. Puth wik ngatharamana keꞌ minchow yaꞌa, an anman wunow aak umpuyangam. ");
INSERT INTO wim_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Pam wanch yotama meeꞌmiy yaꞌa, aakan ngeen nathan wampow ngay palaman wampāng. Ngaantiyongk aak in kenyan wuntan-a, than thamp meeꞌmiy yaꞌa, aak ngeen nathana wampow, ngay thama meeꞌmiy yaꞌa. Nilam anman thonakam epa piip God.an meeꞌmiya. ");
INSERT INTO wim_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Yaa, niiyaniya minam anman woyan God.antaman wak-wakāna, mel keꞌ enchān woyan min anpalana, yaꞌa. Puth niiyaniya meeꞌmiy yaꞌa aak ngeen nathan wampow nilam thonakam piip God.an epa meeꞌmiy. ");
INSERT INTO wim_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","36","In keꞌ yimanangan wunowa. Nil pam piꞌanan kan-ngul moꞌow tripaka. Aꞌ nil pam nungantam al-alantan thawan thant, ‘Ayyang, niiyalang, niiy aawucha, way min anangana min-minam piꞌ-piꞌāna ngathara. Ngay work thakan maꞌ niiyantang wantānga.’ Aꞌ nil moom alangana pam thon-thonantana work pok-pokkapang theeꞌan thant, aꞌ nil pam alantan thawan thaaꞌan piꞌ-piꞌan aawuchakana, ‘Nint aawuch inan min-min thath-thathāna, — puth ngathara thamp aak thath-thathān ngay palam ngulan wampānga.’ Nil pam moomana kinch-wayang nath palam wampowa, yaꞌamiya, ngaaꞌ-menhang nath wampowa, yaꞌamiya, aak paanthanang nath wampow, aak paanthanang yaꞌwey-a, kinch kanaman penta, an-aniyangan nath wampow. Than pam nungantam anangan than meeꞌmiy yaꞌa moom thanttaman aak ngeen nathan palaman wampowa, puth nilan thaw, ‘Niiy aak thath-thathān ngathara.’ An puth keꞌ ngay yimanangan wampāng niiyant. Ngay wampāngan-a, an puth ngay ngul maꞌ-pil-wayathang niiyang, ngay nath weepang uwāng niiyang. Puth ngay yimanangan keꞌ uwāng niiyang a! An puth way wuniy niiyanta. Yaa, niiy wik kan ngeeyan ey? Niiy meeꞌmiy yaꞌa ngay aak ngeen nath palaman wampāng, puth ngay inan thawang niiyant niiyaniya min-minam iiy-iiyāna, aꞌ woyan ngatharam anman wak-wakāna. ");
INSERT INTO wim_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ngay niiyant thawangan aꞌ puth thant yotamant tham thawangan: niiy aak thath-thathān ngathar.” ");
INSERT INTO wim_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Aak thinth kan wampan may piꞌan yumpanakan. Kinch kuchamang kanan wantow-a, aak anan-a, may piꞌanan mungkayn Passover.an waaꞌantan, thanan may bread pamp anman mungk-mungkayn, soda keꞌanang. Than pam piꞌan priests anangan aꞌ puth-a, pam anangan wik thayanan thaaꞌan-aath-aathin-a, than wik thawin thanttakaman than want-wanttakan Jesus.an thenchanam mamayn nunang, aꞌ mulathayn nunang thamp. ");
INSERT INTO wim_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Puth thanan thawina, “Ngamp keꞌ mamimp nunang yippak may piꞌanan mungk-mungkanampa, yaꞌa, puth than pam wanch yot anangan ngul kul yumpin ngampar nungantam peeyanang, aꞌ puth wik thaaꞌ pech-pechiythana ngampar kul thampana.” ");
INSERT INTO wim_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Anpalaniy-a, nil Jesus.ana aak Bethany angan wamp, aak pam Simon alantamangan, nil pam Simon inmana nil kaꞌathamana weech-weechan nunang, penchiyang mak nunang. Aꞌ nil Jesus.an nyiin ngul may mungkow. Nil mayan yippak mungk-mungk-a, nil wanch thonam wamp nungant, ngaꞌalangk maꞌang kal-kal opar awal min thampa, puth than pam wanchanganiya oparana wukal piꞌanang piiy-piiyin. Nil wanch alangana opar awal min paththam anangan kal nungant. Aꞌ nil ngaꞌalangk thaaꞌan thaꞌ aꞌ oparana kuchek Jesus.antang piꞌanam yeech. ");
INSERT INTO wim_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Puth than pam wanch wiy al-alangan wanchan thathin nunang-a, aꞌ man kul paththam wamp thant, aꞌ thawin ngul, “Nil ngul oparan ngeenak yeech nungantang e? ");
INSERT INTO wim_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ngampan sellimpungimp oparana, wukal thaꞌiy uwimpa, three hundred dollarsaka, aꞌ ngampaniya wukal thant pam wanch wiy al-alantan theeꞌimpa thant wukal keꞌanang al-alantana.” Aꞌ thanan wanchan wak-wakin nunang. ");
INSERT INTO wim_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Nil puth Jesus.an thaw thant, “Keꞌ wakān nunangweya! Niiy wantān nunangweya! Nil wanch inana min-minam paththam iiyan ngathara. ");
INSERT INTO wim_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Than pam wanch wukal keꞌanang anangan-a, murkanam aak ingman wuntan niiyantang, kaangk niiy nathwey maꞌ-aathān thanang-a, niiy maꞌ-aathān thanangwey, puth ngay ep yaam ingan keꞌ wuning niiyantang aak inganiya, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Nil wanch inana min iiy ngathar. Nil opar awal minan yeech kemp ngatharangan-a, an keꞌ pam mulantangan oparana yeechantana yimanangana. An keꞌ aak yimanangan wuna, nilaniya oparan ump-umputh yeechana kemp ngatharangana, aꞌ ngul-ngulaniya ngayaniya uthamāng ngul, aꞌ kaampayn ngayangan ngul. ");
INSERT INTO wim_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Aꞌ ngay inan waaꞌāng niiyant thamp: aak want-wantting nathana waaꞌayn wik min God.antaman pam wanchantan-a, thananiya wanch inana waaꞌ-waaꞌayn nunanga nil inana min iiy ngathara, than yipam pam wanch wiyangan ngaantam-ngeeyayn nunanga nil minan iiy ngathara.” ");
INSERT INTO wim_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Aꞌ ngurp nungantam thonamana, pam namp nungantaniya, Judas Iscariot, nil iiy pam piꞌan priests al-alantan aꞌ thaw thant nil Jesus.an theetathowan thant. ");
INSERT INTO wim_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ngangk min paththam wun thant wik nungantaman ngeeyin, aꞌ thanan kaaꞌngakin nunang Judas.an than wukalan theeꞌayn nungant. Aꞌ aak amanam ngulana nil Judas.angan ngaantam-ngeey-ngeey, “Ngay Jesus.an want-wanttak theetathāng nunang thantana?” ");
INSERT INTO wim_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Aak anan may piꞌan mungkanakan kan wamp thant Jews al-alantan, Passover.an waaꞌantan. Than aak kaꞌathamaniy-a, minh lambs anangan mulathayn thanang. Anpalana, than mungkayn, aꞌ putha may bread pamp soda keꞌanang mungk-mungkayn. Kaꞌathamaniy-a, than may keꞌaman yippak yumpin-a, than ngurp Jesus.antam anangan thawin nungant, “Ngan aak wanttinak iiyān may minha keenk yumpān ngampara?” ");
INSERT INTO wim_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Nil Jesus.angan pam kucham keenk kuch pulang. Nil thaw pulant, “Ayyang, nip inan ngeeyowa. Nip aak Jerusalem.angan ngoonchow aꞌ anpalana nipiya pam uwow nunang ngak kal-kalana juganga. Nipiy-a, monkan-wakow nunanga. ");
INSERT INTO wim_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Nil aawuch wanttingan ngoonchow-a, nipaniya karpam ngoonchow nungantangana. Aꞌ nipana thawow ngul aawuch-kunch alantan, ‘Ayyang, moom nganttamang wik inan kucha, nint aakan meenathān ngant ngan aak want-wanttingan minh lamban mungkāna puth may bread pamp anangan thamp mungkāna, ngan Jesus-a, aꞌ puth ngurp nganttam wiy al-alangan.’ ");
INSERT INTO wim_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Amanamaniya nil pam alangan keny matathow nipang ngul aꞌ aakana meenathow nipar piꞌan weꞌarana, table-a, puth chairs anangan thama. Nipaniya minh-a, may thakan keenk wunpow thanang table.angan yipam ngampan may mungkāmpa.” ");
INSERT INTO wim_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Aꞌ pam kuchamana iiypul ngul, aak piꞌan Jerusalem.angan ngoonchpul, aꞌ aakana kan-ngul uwpul keꞌ Jesus anman wik thaw. Yaa, pulana may minh keenk ngul piꞌ-piꞌpul thant. ");
INSERT INTO wim_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Aak ngutang ngulan-a, nil Jesus-a, aꞌ ngurp nungantam wiy anangan kan wampin. ");
INSERT INTO wim_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Than table.ang nyiinin aꞌ may mungkin. Than mayan yippak mungk-mungkin-a, nil Jesus.an thaw thant, “Ngay niiyant kan-kanam thaw-thawang; nil pam thonam-a, nil yamam nyiin-nyiinan may mungk-mungkan ngatharangan-a, nil ngayangan theetathow pam way al-alantan.” ");
INSERT INTO wim_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ngurp nungantam al-alantan-a, ngangk way wun thant, aꞌ than thon-thonaman kan-ngul thaw-thawin nungant, “Ayyang, nint weeꞌ waaꞌ-waaꞌangan e? Ngay yaꞌ ey?” ");
INSERT INTO wim_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Nil puth Jesus.an thaw, “Niiy inangan nyiin-nyiinaniy-a, nil thonamang theetathow ngayangana. Nil weeꞌangan may breadan punchathow may kam sauce.angan ngatharanganwey-a, nil pam alangana. ");
INSERT INTO wim_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ngayaniy-a, pam inman nil God.angan kuch. Ngay ngul uthamāng, lat ngench thayanangan waaꞌan. Puth nil pam weeꞌang theetathow ngayanga pam way al-alantan-a, an aak way-wayam paththam wampow nungant! An min wuniy nungant nil keꞌwey aak-ngeeyiy aak inganiy.” ");
INSERT INTO wim_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Than mayan yippak mungk-mungkin-a, nil Jesus.angana may bread many maay, aꞌ thankyou thaw God.antana, aꞌ pip-pip ngul breadan aꞌ ngurp nungantam al-alantan theeꞌ-theeꞌ ngul thant. Nilan thaw thant, “Niiy may bread inan mamāna aꞌ mungkān ngul, may bread inana keꞌ kemp ngatharam yimanangan.” ");
INSERT INTO wim_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Aꞌ anpalaniya nil Jesus.angan cup ngul maay wine thampan, aꞌ nil thankyou thaw God.antan, aꞌ kan-ngul theeꞌ-theeꞌ thant ngurp nungantam al-alantan, aꞌ than yotam al-alangan mungkin. ");
INSERT INTO wim_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nil Jesus.an thaw thant, “Inana keꞌ chaapar ngatharam yimanangan uk-ukow niiyant, nil God.angan yipam kaaꞌ-piichanathow niiyang keꞌ nilan keenkanaman kaaꞌngak niiyang. ");
INSERT INTO wim_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ngay inan waaꞌāng niiyanta: ngay wine inana keꞌ-ngul mungkāng, yaꞌa. Ngul-ngulaniya ngampaniya karpam ngul wunāmp aak piip ngatharamantang God.antangan, aꞌ ngayaniya wine wiy-wiyam ngul mungkāng niiyantangana.” ");
INSERT INTO wim_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Anpalan-a, than aak pathin God.antan, aꞌ kan-ngul iiyin yoyk Olives aakanakan. ");
INSERT INTO wim_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Nil Jesus.an thaw thant, “Ngay inan thawang niiyant. Niiy yotaman ngul moꞌān ngatharam aꞌ too wantān ngayang, puth lat ngench thayanang wik inangan thawan, ‘Nil piip God.angan-a, pam moom minh sheepan piꞌ-piꞌana, anan mulathowan ngula, aꞌ minh sheep yotam nungantam anangan-a, paa weꞌaramayn.’ ");
INSERT INTO wim_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Puth anpalan-a, ngay mulaman kanan ekāng-a, ngay aak Galilee.ak keenk iiyāng. Niiyiya pal ngul iiyān.” ");
INSERT INTO wim_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Nil Peter.an thawant, “Ayyang, ngay keꞌ wantāng nintanga! Than wiy al-alangan nath ep wantayn nintanga, puth ngay keꞌ wanting nintang, yaꞌ paththama!” ");
INSERT INTO wim_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Nil Jesus.an thaw Peter alantan, “Ngay inan kan-kanam thawang nungk, inman ngutangan-a, nil minh rooster maꞌ-kucham keꞌan yippak pechow-a, nint maꞌ-koꞌalaman-a, wik uuyamān thant nint ngayang keꞌan meeꞌmiya.” ");
INSERT INTO wim_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Nil Peter.an wik thayanam thawant, “Yaꞌa, ngay kan-kanam thaw-thawanga! Nungkway than nath mulathiythan ngayang nungkarangan-a, ngay keꞌ wik uuyaming thant, yaꞌa.” Than ngurp nungantam wiy anangan wik anman thawin Jesus alantan keꞌ Peter anman thaw. ");
INSERT INTO wim_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Nil Jesus-a, aꞌ putha ngurp nungantam anangan than aak-aakanakan iiyin Gethsemane.aka, aꞌ nil Jesus.an thaw thant, “Niiy ing nyiināna, aꞌ kuupān ngathara, ngay kan meeꞌ-wuthanamānga.” ");
INSERT INTO wim_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Aꞌ nil Peter-a, James-a, aꞌ putha John karpam kal thanang wal kecham iiyin. Aꞌ Jesus.antan-a, ngangk way-wayam paththam wunanta, ");
INSERT INTO wim_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","aꞌ nilan thaw thant, “Ngayan ngangk way-wayam paththama ngeechanang keꞌ uth-uthamanak yimanangana. Niiy ingman nyiināna aꞌ aak thath-thathāna.” ");
INSERT INTO wim_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Aꞌ manyam ngul kech keꞌanam iiya, aꞌ aakang ngul wun-wun, meeꞌ-wuth-wuthanama piip nungantamak God.anta wayanang anangana nath keꞌ yipam wampow nunganta. ");
INSERT INTO wim_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Nilana wik inangan thaw God.antana, “Piip-ang, piip ngatharam-ang, nintiya wuut piꞌan paththam, maꞌ-kuncha, nintaniya maꞌ-minangam way min thon-thon anangan yumpangana. Ayyang, piipa, nint keꞌ wayathin thanang ey? Keꞌ thawin thant ey? Wayan keꞌ yumpayn ngatharan ey? Puth ngayan keꞌ thawing, yaꞌa, nint kaangk yaakaꞌ kuchān ngayangweya, yaa, puth wayan mak yumpayn ngathara, ngay keꞌ weeking ngatharakamana.” ");
INSERT INTO wim_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Aꞌ nilana kan-ngul ek, aꞌ koyam ngul iiy ngurp nungantam al-alantan, aꞌ thath thanang weepan wun-wunin. Aꞌ nil Peter alantan thaw, “Simon-ang, nint weep wunangan ey? Nint keꞌ meeꞌ-thayanamin ey? Meeꞌ weep pip-pipan nintang ey? Nint aak keꞌ manyam thathin ey? hour thonamak ey?” ");
INSERT INTO wim_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Aꞌ nil Jesus.an thaw ngul thant, “Niiy aak thath-thathāna. Meeꞌ-wuthanamān God.anta, niiy keꞌ yipmam ngeeyān nunang oony wayana, way keꞌ yipam yumpān. Niiyan minaman kaangk iiyāna puth thaaꞌ-puyan kan-ngul eenchaniya aꞌ way iiy-iiyaniya.” ");
INSERT INTO wim_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Aꞌ nil Jesus.ana putham ngul iiy meeꞌ-wuthanamanak, wik anmanim thaw God.antan, wik nil kaꞌathaman thaw nunganta. ");
INSERT INTO wim_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Aꞌ nil palam ngul wamp thant ngurp nungantam al-alantan aꞌ thath thanang weep thayan wun-wunina; thanana meeꞌan yaꞌangam thayanamin, meeꞌ weepang pip-pip thanang. Than wik min-min keꞌam ngaantam-ngeeyin wanttakan wik thawayn nungant. ");
INSERT INTO wim_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Aꞌ nil Jesus.ana putham ngul iiy meeꞌ-wuthanamow piip-kunchantan God.anta. Aꞌ nil koyam wamp thant aꞌ nil putham ngul thath thanang weep thayan anman wun-wunin. Aꞌ nilan thaw thant, “Niiy inman weep-weenthiy ey? Yaa, an kana! Aakan kan wampana ngathar ngay pam inmana nil God.angan kuchanya! Nil pam way alangan kan-ngul maꞌam theeꞌow ngayang pam way al-alantana! ");
INSERT INTO wim_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Erkam ekiya, ngamp kan-ngul iiyāmp a! Aꞌ thathiya, paman inpala nilan maꞌam theeꞌowanya pam way al-alantana.” ");
INSERT INTO wim_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Nil Jesus.an wikan yippak thaw-thaw-a, nil ngurp nungantam Judas.an wamp. Nilan pam yot anangan karpam kal thanang, than puth pam piꞌan al-alangan kuchin thanang, pam piꞌan priests al-alangan-a, aꞌ puth pam piꞌan wiy al-alangan wik thayanan thaaꞌ-aath-aathin-a, aꞌ puth pam wuut manth-thayan al-alangan. Than pam anangan Judas.antang wampin-a, than nhengk-peempan aꞌ yuk muurkan thak kal-kalin. ");
INSERT INTO wim_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Nil Judas.an pam anman nil Jesus.an theetathowana nil puth keenkaman kan thaw thant, “Ngay pam thonaman wal piintāng nunanga, an nilamana! Niiy mamān nunang, aꞌ puy kalān nunang, pam thapangumpan al-alangan yipam maꞌangam piꞌ-piꞌayn nunang.” ");
INSERT INTO wim_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Nil Judas.an wamp-a, nil thintham iiy nungant Jesus.ant, aꞌ thawant, “Ayyang, Moom-ang!” Aꞌ wal piint nunang. ");
INSERT INTO wim_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Puth anpalan-a, than pam yotangan mamin nunang Jesus.an aꞌ thayanam piꞌ-piꞌin nunang. ");
INSERT INTO wim_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Puth nil pam thonaman angman than-than, nil nhengk-peempan nungantaman erkam paththam wich, aꞌ pam thonaman kon thalokang umpan. Pam ananiy-a, kon munth ngul iiy-iiy, nilwey pam work iiy-iiy pam piꞌan alantan, moom priestsantam alantan. ");
INSERT INTO wim_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ngul nil Jesus.an thaw thant, “Niiy nhengk-peempan aꞌ yuk muurkan thakan kalaniy ngayang yipam mamān ey? Ngay keꞌ pam way yimanangan ey? ");
INSERT INTO wim_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ngay puth aak ingam wunanam ey! Aꞌ ngaaꞌ thon-thonangana aawuch ngench thayanang thaaꞌ-aath-aathangan niiyang ey! puth niiy keꞌam maman ngayang yaꞌa. Puth kana, niiy mak mamān ngayanga, inan yipam meenathow niiyant pam wanchantan than keenkanaman lat ngench thayanangan umpin ngatharamana an kan-kanam paththamwey umpin latangana.” ");
INSERT INTO wim_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Anpalan-a, than ngurp nungantam yotam al-alangan-a, wantin nunang, aꞌ yaꞌ moꞌin nungantam. ");
INSERT INTO wim_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Pam komp thonamana koy-koyyuw iiy-iiy thanttang pam wanch yotantang. Nil ngook thonamang kath nungamang. Than keꞌ nunang thampang mamiythan-a, ");
INSERT INTO wim_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","puth nilanweya kamp moꞌ-moꞌ thanttamana, aꞌ maꞌlip moꞌa, puth ngook nungantam lopam thuuchantamwey, aꞌ angman wanta. ");
INSERT INTO wim_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Than pam al-alangan Jesus.an kalin nunang aawuch pam piꞌan alantamakan, moom priestsantam al-alantamakan. Than pam piꞌan priests anangan-a, aꞌ puth pam wuut manth-thayan anangan-a, aꞌ puth than pam piꞌ-piꞌanaman wik thayanan thaaꞌ-aath-aathin-a, aak angman yalmathwin thanttakaman. ");
INSERT INTO wim_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Nil Peter.aniy-a, kecham koy-koyyuw iiy-iiy thanttang, aꞌ nilan aak angan wamp, aak pam piꞌanantam angman, puth keꞌam ngoonch, yoon angman than-than. Nilana soldiersantang nyiin-nyiin, thumang park-park. ");
INSERT INTO wim_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Than pam piꞌan priests anangana puth pam councillors anangana wenk-wenkin pal-puy pam wanchakan than yipam waaꞌayn nunang Jesus.ana, nil keꞌ kan-kanam pam waya, way yot yump-yump meeꞌ thanttangan. Than puth pam piꞌ-piꞌanam al-alangan kaangkweya than pam wanchangan waaꞌayn nunang aak courtang angan, than yipam kuchayn nunang mulan wunow. ");
INSERT INTO wim_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Than pam wanch yotangan aak-yaꞌangan waaꞌ-waaꞌin nunang, an puth than-thanam wik ngunchina, puth thananiya wik thon-thon kuyam waaꞌ-waaꞌin nunangana. ");
INSERT INTO wim_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Anpalaniya, pam wiy anangan thanin, aꞌ wik uuyamin, wik inangan thawin, ");
INSERT INTO wim_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ngan ngeeyan nunang wik inangan thaw, ‘Aawuch ngench thayan God.antaman-a, pamangan kaachin. Ngayaniy-a, ngul wayathāng, aꞌ kinch koꞌalamangan kanan wantow-a, ngay aawuch ngench thayan thonangan ngul kaachāng, pamang keꞌaman kaachin, yaꞌan.’” ");
INSERT INTO wim_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Puth than pam inangan thampang karpam keꞌam thawin, than wik thon-thon waaꞌ-waaꞌin nunang. ");
INSERT INTO wim_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Aꞌ nil pam moom priest al-alantam thanttam-a, wur ek aꞌ thaw ngul Jesus.antan, “Ayyang, than waaꞌ-waaꞌantan nintang, nint wanttak wikaniy ngul thawān e?” ");
INSERT INTO wim_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Puth nil Jesus.ana popam anman than-than, nil wik koyaman keꞌam thaw thant, yaꞌa. Aꞌ pam moom alangan putham ngul mep nunang, “Nint kan waaꞌān nganta! Nint ngul pam inan God.angan keenkaman kaaꞌngak ey? kuchowan nintang ey? Pam nhengk nungantaman God min paththam alantaman ey?” ");
INSERT INTO wim_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Nil Jesus.an thaw nungant, “Eeꞌa, ngay pam inmana. Puth ngay yotamant niiyant thawānga; niiy ngul thathān ngayang, wuny niiyantam inan moom piꞌan God.antangan nyiin-nyiināng. Aꞌ niiy tham ngul thathān ngayang palaman uk-ukāng yuwangan aak inpal kenyana.” ");
INSERT INTO wim_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Aꞌ nil moom priestsantam alangan ngook nungantaman war ikath, aꞌ nil thaw, “Ngan wik way nungantaman kan ngeeyana. Wiyangan keꞌ waaꞌiythan nunang ngamparaniya yaꞌa! ");
INSERT INTO wim_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Niiy nyiingk inan wik kan ngeeyan ey? nil God.an waaꞌan nungamang ey? Niiy wanttak ngaantam-ngeeyaniya?” Than yotaman karpam thawin, “Nilan wik way-wayam paththam thaw, mak mulathayn nunanga.” ");
INSERT INTO wim_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Anpalan-a, than wiy al-alangana thaaꞌ theekang makin nunang, aꞌ than meeꞌan ngook manyang kathin nunang keꞌ yipam aak thathow aꞌ piikin nunang. Than thawin nungant, “Ayyang, nint kan waaꞌān nganta weeꞌangan piik nintanga.” Aꞌ than pam thapangumpan al-alangan kalin nunang aꞌ piik-piikin nunang. ");
INSERT INTO wim_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Nil Peter.an aawuch yoon angman nyiin-nyiin, thaaꞌ thinth. Aꞌ nil wanchan wamp, nil workan iiy-iiy pam piꞌan alantan, moom priests al-alantamakan. ");
INSERT INTO wim_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Nil thath nunang Peter.an thumangan park-park, aꞌ meeꞌ paththam thath nunang aꞌ thaw nungant, “Nint ngurp nungantam, Jesus.antam ey? pam aak Nazareth anpalan ey?” ");
INSERT INTO wim_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Puth nil Peter.an wik uuyam, aꞌ thawant, “Pam weeꞌa? Ngay ngoongk-ngoongkam nunang.” Aꞌ nilan pent ngul, thaaꞌ thinth angman than-thana, aꞌ yaam keꞌanama minh roosteran pech-pech. ");
INSERT INTO wim_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Aꞌ wanch thon ngulan wamp, workan iiy-iiy pam piꞌan alantana, nilana thath nunang angman than-than aꞌ nilan pam wanch wiyantan thaw, “Ayyang, nil pam inman ngurp Jesus.antamana.” ");
INSERT INTO wim_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Puth nil Peter.an putham wik uuyam, “Appang, ngay ngurp nungantam, yaꞌa,” thaw. Aꞌ than pam wanch anangan putham ngul thawin nungant, Peter.antan, “Nint keꞌ wik uuyamāna. Nint kan-kanam ngurp nungantama, puth nint thamp aak Galilee anpalan wampana.” ");
INSERT INTO wim_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Nil puth Peter.an thaw, “Ngay kan-kanam thaw-thawang niiyant, ngay keꞌ wik uuyaminga, yaꞌa. Ngay nath wik uuyamingan-a, nil God.angan mak wayathow ngayang. Ngay pam anan keꞌ meeꞌmiy nunang yaꞌa niiy anan waaꞌ-waaꞌaniy nunang.” ");
INSERT INTO wim_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Anpalan-a, minh roosteran putham pech-pech, aꞌ konang wamp nungant Peter alantan wik nil Jesus.an thawant, “Ngay inan kan-kanam thawang nungk, inman ngutangan-a, nil minh roosteran keꞌan yippak maꞌ-kuchaman pechow-a, nint maꞌ-koꞌalamana, ngul wik uuyamān thantweya pam wanch wiyantana, nint ngayangan keꞌ meeꞌmiy yaꞌa.” Aꞌ Peter.antan ngangk way paththam wun nungant aꞌ nil peey-peey ngul. ");
INSERT INTO wim_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Anpalan-a, ngaaꞌ thonan wamp-a, than pam piꞌan anangan ngaaꞌthiyangam yalmathwin, than pam piꞌan priests anangan, aꞌ puth than pam wuut manth-thayan anangan, aꞌ puth than pam piꞌan anangan wik thayan anangan thaaꞌ-aath-aathin, aꞌ puth than councillors yot anangan. Than wik yumpin thanttakaman. Aꞌ than Jesus.an chol many kung-makanang kathin nunang, aꞌ puy kalin nunang, aꞌ maꞌam theeꞌin nunang pam moom piꞌan Pilate alantan. ");
INSERT INTO wim_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Nil Pilate.an thaw nungant, “Nint ina moom king Jews al-alantaman ey?” Nil Jesus.an thawant, “Nint wik nanan thawangan-a, an kan-kanama.” ");
INSERT INTO wim_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Than pam piꞌan priests al-alangana waaꞌ-waaꞌin nunang Jesus.an keꞌ nil way yot-yotaman yump-yump. ");
INSERT INTO wim_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Aꞌ nil Pilate.an thawant, “Nint koyaman keꞌ wik thawin thant ey? Nint kan ngeey-ngeeyangan thanang waaꞌ-waaꞌantanan nintang aa?” ");
INSERT INTO wim_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Puth nil Jesus.an popam than, koyaman keꞌ wik thaw thant yaꞌa. Nil Pilate.aniy-a, meeꞌam ik. ");
INSERT INTO wim_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kaap thon-thonangan-a, may piꞌanan kiingkantan Passover.an-a, nil Pilate.angan pam thon-thonam kuch-kuch thant Jews al-alantan aak jailam anpalan — than pam weeꞌantan kaangk nil kuchowan-a, yaa, nil Pilate.angan pam ananim kuch thant. ");
INSERT INTO wim_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Aak an-aniyangan-a, pam namp Barabbas aꞌ pam wiy thampan aak jailang wunin, than puth pam piꞌan Government.an thaampin, kul yumpin thant, aꞌ pam wanch wiy anangan mulathin thanang. ");
INSERT INTO wim_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Aꞌ than pam wanch Jews thaaꞌ-wantanaman yalmathwin aak Pilate.antamakan. Thanan thawin Pilate.antan pam thonam kuchow thant jail anpalan. ");
INSERT INTO wim_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Nil puth Pilate.an thaw thant, “Ngay pam inana moom wuut piꞌan niiyantam Jews al-alantaman kuchāng ey?” ");
INSERT INTO wim_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Nil Pilate.angan meeꞌmiy thanang paththam pam piꞌan priests anangan puth than meeꞌ-wunin nungantam Jesus.antam thanan keꞌ-paal maꞌam theeꞌin nunang. ");
INSERT INTO wim_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Puth than pam piꞌan priests al-alangan kul yumpin thant pam wanch yot al-alantan than yipmam thawayn nungant Pilate.ant Barabbas.an kuchow thant. ");
INSERT INTO wim_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Nil Pilate.an thaw thant pam wanchant, “Ngul pam inan wanttake? Niiy puth moom piꞌan niiyantaman waaꞌaniy nunanga!” ");
INSERT INTO wim_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Than pech-pechin nungant, “Yuk wuuyanang waanchān nunanga! Aꞌ mulathān nunanga!” ");
INSERT INTO wim_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Nil puth Pilate.an thaw thant, “Nil way ngeen yumpe?” Puth thanan othamayan pechin nungant, “Yuk wuuyanang waanchān nunanga! Aꞌ mulathān nunanga!” ");
INSERT INTO wim_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Nil Pilate.angan kaangk pam wanch ngangk min yumpow thanang, keꞌ-paal nil Barabbas.an kuch thant aak jail anpalan. Aꞌ nilan thaw thant soldiers al-alantan puy kalayn nunang Jesus.ana, aꞌ piikayn nunang kuuy alangan, aꞌ nil thaw thant ngul, “Yaa, niiy kalān nunang yuk wuuyanakana, nailang mak pungān nunangweya.” ");
INSERT INTO wim_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Anpalana, than soldiers al-alangan Jesus.an matathin nunang aak aawuch pam piꞌan alantamakana aꞌ pek ngoonchathin nunang. Aꞌ than soldiers al-alangan soldiers wiy anangan palam umpin thanang. ");
INSERT INTO wim_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Anpalan-a, than soldiers al-alangan yaan yumpin nunang keꞌ moom king yimanangan, than yipam thaaꞌ-thengkathayn nunang. Than yuk waakamam yumpin nungant keꞌ yuk crown yimanangan kuchekangan ngoonchow aꞌ kuchekangan wunpin nungantang. Aꞌ than ngook ongk keꞌ chaapar yimanang ngoonchathin nunang. ");
INSERT INTO wim_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Aꞌ thanana man-aath-aathin nunang, aꞌ puth salute.impungin nunang. Aꞌ than man-keeꞌanang thaw-thawin nungant, “Ayyang, nint moom piꞌan ey? King Jews al-alantaman ey? Nint king min paththam aa! Nint man-yetham ngul-ngulakam iiy-iiyān ey?” ");
INSERT INTO wim_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Aꞌ than kuchekan piik-piikin nunang yukangan aꞌ thaaꞌ theekang makin nunang, aꞌ yaan pungkang thuchin um nungantang. ");
INSERT INTO wim_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Than kanan thaaꞌ-thengk-thengkathin nunang-a, than ngook keꞌ chaapar yimanangan thapathin nungantam, aꞌ ngook nungantaman koyaman ngoonchathin nunang ngul. Aꞌ anpalana, than yoon kan-ngul kalin nunang yipam nailang pungayn nunang yuk wuuyanangan, mulakaman. ");
INSERT INTO wim_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Than kanan iiy-iiyin-a, than pam namp Simon uwin nunang. Nil aak kangkam wamp aak piꞌanakan, aꞌ than soldiers al-alangana thaachin nunang yuk wuuyan Jesus.antaman kalow. (Nil Simon.ana aak Cyrene punchan, nilana piip pulantam Alexander aꞌ puth Rufus pulantam.) ");
INSERT INTO wim_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Than Jesus.ana kan-ngul kalin nunang aak Golgotha aakanakan, wik ngamparamangan waaꞌanampa, “Aak kuchek kaancha.” ");
INSERT INTO wim_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ang-ngulaniya, thanan wine opar myrrh thamp nenchanathin aꞌ theeꞌin nungant, puth nil Jesus.angan keꞌam mungk yaꞌa. ");
INSERT INTO wim_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Anpalan-a, than nailang pungin nunang yuk wuuyanangan, aꞌ waanchin nunang ngul, mul yipam wunow. Aak an-aniyangan-a, nine oꞌclock ngaaꞌthiyangam wun. Aꞌ than pam soldiers al-alangan ngook nungantam thakan thon-thonam aath-aathwin thanttakam, than puth yuk dice keeꞌ-keeꞌin yipmam weeꞌangan nath uwowa. ");
INSERT INTO wim_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Than lat thampan wunpin yuk wuuyanangana, wik inangan umpin, waaꞌinan nunang: “Nil pam inan moom King Jews.antama.” ");
INSERT INTO wim_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Than pam soldiers al-alangana pam kucham thamp waanchin pulang Jesus.antang mulathayn pulanga, pulan way-wayam iiy-iiypul. Nil Jesus.aniy-a, menhang pulantang waanchin nunang. ");
INSERT INTO wim_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Pam wanch wiy anangan woyan wakanan iiy-iiyin. Thananiy-a, um keny thath-thathin aꞌ kuchek wuny-wunyathin man-aath-aathin nunang Jesus.ana aꞌ wik way-wayak thawin nungant, “Ayyang! Nint keꞌ aawuch ngench thayan God.antaman wayathin ey? Aꞌ kinch koꞌalamang kanan wantow-a, keꞌ koyam ngulan kaachin ey? Puth yaꞌ ey! ");
INSERT INTO wim_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Nint kan yuk wuuyan nanpalan ukāna, aꞌ nungkarakaman kaaꞌ-piichanathāna!” ");
INSERT INTO wim_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Than pam piꞌan priests al-alangana aꞌ puth than pam piꞌan anangan wik thayanan thaaꞌan-aath-aathina, than thampang thaaꞌ-thengkathin nunang Jesus.ana. Than thawin thanttakaman, “Nil thanang wiy ep kaaꞌ-piichanathan ey? nil puth nungamang thamp kaaꞌ-piichanathow ee! ");
INSERT INTO wim_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Nil nath pam inman aak keenkan nil God.angan miꞌana, aak iikanakaniy ukow kaaꞌ-piichanathow ngampanga. Nath nilamwey-a, yaa, puth nila yuk wuuyanam anpalan ukowa! Aꞌ anpalan ngamp yipam kan-kanam ngaantam-ngeeyāmp nunanga!” Aꞌ pul pam kucham anangan-a, karpaman waanchin pulang Jesus.antangan-a, pul thampa wik wayanang thak thaw-thawpul Jesus.antana. ");
INSERT INTO wim_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Anpalana, kinch keny ngulana, aak pal-puyam ngaaꞌ paththam wun, ngaaꞌ anman wun three oꞌclockakam. ");
INSERT INTO wim_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Three oꞌclockan wamp-a, nil Jesus.an wik othamayan pech, wik thaaꞌnganth nungantamang thaw, “Eloi, Eloi, lema sabachthani?” Wik ngamparamang yimanangan thawanamp, “God ngatharam-ang! God ngatharam-ang! Nint ngeenak too wantangan ngayanga?” ");
INSERT INTO wim_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Pam wanch wiy anangan angman than-thanin-a, ngeeyin nunang, aꞌ thawin, “Ayyang! Niiy kan ngeeyān nunanga, nil Elijah alantan pech-pechana!” ");
INSERT INTO wim_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Nil pam thonaman moꞌa aꞌ nil ngook manyan may wine pochangan punchath, aꞌ ngook manyan-a, yuk ongkang kath, aꞌ yuk ongkan keny maay nungant, aꞌ thaaꞌang wunp Jesus.antang. Nil paman thaw, “Kuupāmpa! Nil Elijah.an ngul nath wampow yipam yuk wuuyan anpalan ukathow nunang. Ngamp ngul nath thathāmpa!” ");
INSERT INTO wim_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Anpalan-a, nil Jesus.an wik othamayan pech, aꞌ nil utham ngul, yaꞌ-ngul. ");
INSERT INTO wim_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Aak an-aniyangan-a, ngook keeꞌan kaachin aawuch ngench thayanangan uk-uk-a, keny anpalan-a, pekakam um-menhang yaꞌ ik. ");
INSERT INTO wim_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Pam moom soldiers al-alantamana angman than-than, um nungant Jesus.ant, aꞌ nil thath nunang nil want-wanttak uthaman. Nilan thaw, “Nil pam inana nhengk God.antama, an kan-kanama!” ");
INSERT INTO wim_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Wanch wiy anangan angman than-thanin thamp, kecham thathin, Mary Magdalene, aꞌ putha Mary thonan, nilan kaath-kunch James.antama (James komp alantaman), aꞌ Joseph.antama, aꞌ puth Salome, aꞌ wiy anangan thamp. ");
INSERT INTO wim_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Nil Jesus.an aak Galilee.angan wun-wun-a, thanan monkan-wak-wakin nunang aꞌ maꞌ-aath-aathin nunang. Wanch wiy anangan aak Jerusalem.akan wampin nungantangan, than thampang angman than-thanin, thath-thathin nunang. ");
INSERT INTO wim_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Aak ngutang ngulan-a, nil pam namp Joseph.an wamp, pam aak Arimathea anpalana. ");
INSERT INTO wim_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Nilan pam councillor, aꞌ than yotangan min waaꞌin nunang. Nilana aak min aakanakan kuup-kuup, nil God.angan pam wanch yot anangan maꞌ nungantang ngulan piꞌow thanang. Aak an-aniyangan-a, Friday.an wun puth aak ngench thayan Jews al-alantamana ngaaꞌ thonang ngulan wampow. (Than Fridays.an ep work iiyin, yipam Saturday.ana work keꞌanang nyiinayn.) Nil puth Joseph.ana Pilate.ant wamp nungant, ngangk thayanam, winynyang keꞌam moꞌ, aꞌ thawant, “Ngay pam mulan keꞌ kaling ey?” ");
INSERT INTO wim_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Nil Pilate.angan wik inan ngeey-a, nilana thaaꞌ ik, nil puth Jesus.an kanam utham, erkaman. Nil Pilate.angan pam soldieran ump nunang, aꞌ engk nungant, “Nil Jesus kan-ngul utham ey?” ");
INSERT INTO wim_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Nil pam soldierangan waaꞌant nil Jesus kanaman utham, aꞌ anpalana nil Pilate.an thawant Joseph.ang pam mulan kalowana. ");
INSERT INTO wim_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Nil Joseph.angan ngook ongk min piiy, aꞌ pam mulan ukath nunang yuk wuuyan anpalan, aꞌ kath nunang ngul ngook min ongk alangan, aꞌ nil aak awarangan pek ngoonchath nunang — aak awar inana, than kunttow thayan anpalan yumpin. Aꞌ nil kunttow wuut piꞌanan poo thaꞌ thaaꞌang angman yipam wunow, ananiy-a, thaaꞌ kanam ngath pam mul alantan. ");
INSERT INTO wim_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Pul Mary Magdalene putha, Mary thonana nil kaath nungantam Joseph.antamana, pulan thathpul aak wanttingan wunpin nunang pam mulana. ");
INSERT INTO wim_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Aak Saturday.an kanan minch-a, than wanch koꞌalam anangana, Mary Magdalene-a, putha Mary-a, nilan kaath James.antamana, aꞌ putha Salome, than wanch al-alangan opar awal min anangan kalin, than kempan yipam mamayn nunang Jesus.an opar awal min alangan. ");
INSERT INTO wim_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Aak Sunday ngaaꞌ-ngaaꞌthiyangaman-a, kinchan kan-ngulan mat-mat-a, than wanch koꞌalam anangana kan-ngul iiyin aak awarakan. ");
INSERT INTO wim_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Than woyan wakan kanan iiy-iiyin-a, thanan thaw-thawin thanttakaman, “Nil weeꞌanga kunttow piꞌanan thaaꞌaman thaꞌow ngampara?” ");
INSERT INTO wim_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","(An puth kunttow wuut piꞌan anhan thampa.) Aꞌ than wampin ngulan-a, aꞌ meeꞌ keny thathin aak awar aakanakan, puth awaran thaaꞌ paꞌant thathin. ");
INSERT INTO wim_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Aꞌ thanana aak awarangana pek ngoonchin, aꞌ thathin pam komp nyiin-nyiin malanga. Ngook pach-pacham ngooncha. Puth thananiya ngangk akangam than-thanina, winynyang moꞌin. ");
INSERT INTO wim_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Aꞌ nil pam kompan thaw thant, “Niiy keꞌ winynyang moꞌāna. Ngay kan meeꞌmiya niiy Jesus.antan wenk-wenkaniya, pam aak Nazareth anpalana, than nailangan pungin nunang yuk wuuyanangana. Nil in yaꞌa, nil kanam ek mulamana! In thathiya! Aakan inana pam mul Jesus.an wunpin nunang, in aak yaꞌ-yaꞌam ngula, — ");
INSERT INTO wim_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","yaa, niiy iiyāna aꞌ wik inan waaꞌān ngurp nungantam al-alantana, puth Peter.ant, ‘Nil Jesus.ana keenk iiyowa aak Galilee.akana, niiyaniya aak angan thathān nunanga, keꞌ nilaman thaw niiyanta.’” ");
INSERT INTO wim_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Aꞌ thanana aak awar anpalana pol pentin ngul aꞌ koyam kamp ngul moꞌ-moꞌin, puth thanana ngangk akangam than-thanin, winynyang moꞌ-moꞌin. Thananiya keꞌam wik waaꞌin wiyantan yaꞌa, puth than winynyang moꞌina. ");
INSERT INTO wim_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Anpalan-a, nil Jesus.an mulaman kanaman ek-a, Sunday ngaaꞌthiyangaman-a, nilan Mary Magdalene.ant kaꞌathangam wamp. Wanch ilantaman-a, nil Jesus.angan keenkan oony way seven anangan kenth thanang ngangk nungantam anpalan. ");
INSERT INTO wim_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Nil Mary.an-a, iiy aꞌ ngurp nungantam al-alantan waaꞌ nil Jesus.an kanaman ek. Nil Mary wampan thant-a, nil uw thanang ngangk way paththam nyiin-nyiinin aꞌ peey-peeyin. ");
INSERT INTO wim_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Than ngeeyin nunang waaꞌ thant nil Jesus.an mulaman ek, aꞌ puth nil Mary.angan-a, kan thath nunang, puth thanan keꞌ-ngoongkam nyiinin, wik nungantamana keꞌam min-minan ngaantam-ngeeyina! ");
INSERT INTO wim_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Anpalan-a, nil Jesus.an ngurp nungantam kucham al-alantan wamp pulant. Pul aak kangkakan iiy-iiypulan-a, aꞌ nil Jesus.an wamp pulant, puth kaꞌathangamana pul keꞌam thiichpul nunang, puth ngulan ep thichpul nunang. ");
INSERT INTO wim_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Pul koyaman iiypul ngurp Jesus.antam wiy al-alantan aꞌ waaꞌpul thant puth thanan wik pulantam min-min keꞌam ngaantam-ngeeyina, man-ngeeyin pulanga. ");
INSERT INTO wim_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ngul-ngulana, nil Jesus.an wamp thant ngurp nungantam eleven al-alantan mayan mungk-mungkin. Nil wak-wak thanang, than puth minam keꞌam ngaantam-ngeeyin nunang, aꞌ puth than kuchek thayan iiy-iiyin, kan-kanam keꞌam wik ngeeyin thanttam than wik nunangan waaꞌ-waaꞌin nil koyam kan-ngulan man-yetham ween. ");
INSERT INTO wim_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Nil thaw thant, “Ngay inan thawang niiyanta. Niiy aak nath-nathan iiy-iiyān pam wanchantan, wik min ngatharamana waaꞌ-waaꞌān thant. ");
INSERT INTO wim_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Than weeꞌ-weeꞌanangan ngangkangan piꞌ-piꞌayn ngayangan-a, aꞌ putha than wiy al-alangan kuchekan kuungkayn thanang ngakangan-a, ngay kaaꞌ-piichanathāng thanang way thanttam anpalan. Puth than weeꞌ-weeꞌanangan ngayang ngangkangan keꞌan piꞌ-piꞌayn-a, an ngay wayathāng thanang. ");
INSERT INTO wim_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Than weeꞌ-weeꞌanangan ngangkang piꞌ-piꞌayn ngayangan-a, an ngay maꞌ-kunch ngul yumpāng thanang work piꞌan yipam meenathayn pam wanchanta, aꞌ puth ngay thayan paththam yumpāng thanang than yipam oony way anangan kenthayn thanang ngangk pam wanchantam anpalan, aꞌ puth than thaaꞌnganth wik wiy-wiyam Ngeen-Wiy Min God.antaman thawayn. ");
INSERT INTO wim_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Than nath thuuk maayiythanwey-a, nath yuk opar way mungkiythanwey-a, an than keꞌ uthamiythan yaꞌa, kemp min anman iiyayn; aꞌ puth than maꞌ wunpiythan thanttang pam wanch weechanan thanang-a, an thananiy-a, miyal ngul weeniythan paththama.” ");
INSERT INTO wim_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Nil Lord Jesus.an wik kanan thaw thant-a, nil God.angan keny matath nunang aꞌ nyiinath nunang maꞌ mal nungantang angan. ");
INSERT INTO wim_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Anpalaniy-a, ngurp nungantam anangan-a, aak nath-nathan iiyin, aꞌ wik Christ.antam waaꞌ-waaꞌin thant pam wanch yot al-alantan. Nil Lord.angan ngangk thayanath thanang aꞌ maꞌ-kunch yump thanang work piꞌan yipam meenathayn thant. Than pam wanchangana thathin work piꞌan thanttaman-a, an than ngaantam-ngeeyin wik thanan waaꞌ-waaꞌin-a, an kan-kanamana. ");
INSERT INTO wim_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Dear Theophilus, Ngay lat inan ump-umpang nungk Jesus.an waaꞌāng nungk nil aak inganan wun-wun aak ngamparamangana. Pam wanch wiyangan kan thathin nunang meeꞌ thanttamang aak anpalman kaꞌathaman work iiy-iiy, aꞌ than kaꞌathangaman wik waaꞌ-waaꞌin nungantaman aꞌ puth wik min God.antaman thamp waaꞌ-waaꞌin. Puth nanpalana, than yotangan latang ngul ump-umpin nil Jesus.an want-wanttakan iiy-iiy. ");
INSERT INTO wim_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ngurp min ngatharama, puth ngay thamp latang ump-umpang waaꞌ-waaꞌang nunang nil aak inganan wun-wuna. Ngay kaangk minam umpāng nungkar. Ngay min-min ngeey-ngeeyangan wik wiy al-alangan waaꞌ-waaꞌin nunang Jesus.an. ");
INSERT INTO wim_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ngay puth wik inan kuchang nungka nint yipam meeꞌmiy iiyān nil want-wanttakan iiy-iiy aak ingan, aꞌ nintan yipam ngaantam-ngeeyān than wiyangan wik kan-kanaman nungkar waaꞌin. ");
INSERT INTO wim_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Aak an-aniyangan-a, nil King Herod.angan aak namp Judea.an piꞌ-piꞌ-a, than priests yot iiy-iiyin. Than namp wuut mangk thanttamantang waaꞌwin. Puungk wiyiya Abijah waaꞌwin. Nil pam thonama Abijah.antaman priest thamp iiy-iiy, namp nungantiya Zechariah. Wanch thum nungantam namp Elizabeth, nil piip Elizabeth.antamana priest thamp iiy-iiy. ");
INSERT INTO wim_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Pul minam iiy-iiypul meeꞌ God.antang, aꞌ putha wik God.antamana ngeey-ngeeypul, keꞌam wik pip-pippul, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Puth pulana puk keꞌanang wun-wunpul. Nil Elizabeth.angana puk keꞌam uw, yaꞌ paththam. Puth pulana wuut wanchinth ngul weenpul. ");
INSERT INTO wim_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Aꞌ aakan kanam wamp thant priests al-alantan Abijah alantaman work ngul iiyayn aawuch ngench thayanangan. Nil Zechariah.ana work iiy-iiy thanttang. Aꞌ than nunang miꞌin aak ngenchakan ngoonchow yuk awal min yipam altarangan kiingkow nungant God.antan. Aak thanttaman puth keꞌ yimanangan wun: than yuk dice.ang keeꞌin yipam miꞌayn nil weeꞌan nath pek ngoonchow aak altarakan. ");
INSERT INTO wim_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Nil Zechariah.angana yuk awal minan kiingk-kiingk-a, than pam wanch anangan yoon than-thanin, God.antan meeꞌ-wuth-wuthanamin. ");
INSERT INTO wim_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Aꞌ ngaantiyongk inpal kenyan uk nungant Zechariah.antan, aꞌ angman than-than maꞌ malang yuk altar thinth, angan yuk awal minan pench-pench. ");
INSERT INTO wim_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Nil Zechariah.angan thath nunang-a, nilana ngangk ik aꞌ putha winynyang moꞌ nungantam. ");
INSERT INTO wim_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Puth nil ngaantiyongkan thaw nungant, “Ayyang, Zechariah-ang, nint keꞌ winynyang moꞌāna. In ngeeya: nil piip God.angan prayer nungkaram kanam ngeey. Nil Elizabeth.angana, puk wuut many nungkaram kalowa. Aꞌ puth nintiya namp nungant John theeꞌāna. ");
INSERT INTO wim_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Nil puk many ngulan aak-ngeeyow-a, nip ngangk min ngul wunow aꞌ pam wanch wiy anangan thamp ngangk min wunayn. ");
INSERT INTO wim_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Niliy putha pam piꞌan ngul iiyow meeꞌ God.antangana. Aꞌ putha ngak way karkan, wine thakana keꞌ mungkow yaꞌ paththam. Aak amanamana, nil yippak thipangan wun-wunow kaath-kunchantangan-a, puk inana maꞌ nungantang Ngeen-Wiy Min God.antamang ngul iiyow. ");
INSERT INTO wim_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Anpalana, nil pam ngulan iiyow-a, nil pam wanch Jews yot anangan woyan way anpalan weentathow thanang, than yipam God moom thanttaman monkan-wak-wakayn nunang. ");
INSERT INTO wim_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Nilaniya wik God.antamana waaꞌ-waaꞌow thama keꞌ nil Elijah.angan waaꞌ-waaꞌ aꞌ putha nilana pam piꞌan aꞌ thayan paththam iiy-iiyow keꞌ Elijah anman. Aꞌ putha nil waaꞌow thant piipiy al-alantan than yipam keꞌ-ngul kul uwayn thant puk thanttamakan. Aꞌ nil woyan minak weentathow thanang pam wanch anangan wik min God.antam kaangk keꞌan ngeeyayn. Nil John.ana keenk iiyow, nil Lord.ana koy-koyyuw wampow. Nil John.angan-a, pam wanch maꞌ-aath-aathow thanang. Nil woyan yumpow nungant, Lord.antan, yipam wik ngeeyayn nunang, pam wanch nungantam al-alangan.” ");
INSERT INTO wim_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Aꞌ nil Zechariah.an thaw nungant, “Ngay puth want-wanttak thiiching wik inan kan-kanaman e? Puth ngay in pam wuut ngula, aꞌ putha wanch ngatharamana wanchinth ngul.” ");
INSERT INTO wim_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Aꞌ puth nil ngaantiyongkan thaw nungant, “Ngay in Gabriela, ngay work God.antan iiy-iiyanga; nil kuch ngayang wik min inan waaꞌāng nungk. ");
INSERT INTO wim_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Puth nintiya man-ngeeyan ngayang. Aakan kan-ngulan wampow-a, nil God.angan miꞌ-a, an-aniyangan nint engkanang ngul thathān wik ngatharam anangan kan-kanam a! Puth nint man-ngeeyan ngayang, yaa, inpalmana nintiya keꞌ-ngul wik thaw-thawān yaꞌa, wik keꞌanang iiyāna, aak-aakanakaman puk manyan aak-ngeeyow.” ");
INSERT INTO wim_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Pam wanch anangan yoonan than-thanin-a, an yaam kuup-kuupin Zechariah.antan. Thanan ngaantam-ngeeyin thanttakaman, “Nil ngeenam yaam an pek aawuch ngench thayanangan e?” ");
INSERT INTO wim_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Aꞌ amanamaniya, nilam paththam pent puth nilana keꞌ-ngul wik thaw thant yaꞌa. Yaa, than pam wanch yotamana meeꞌmiy ngul nil ngaantiyongk piip God.antaman angan wamp nungant. Nil Zechariah.angan mal wooꞌ yump thant puth nilan keꞌ-ngul wik thaw, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Anpal ngulana, nil Zechariah.angan work nungantaman kanan minchath aawuch ngench thayanangan-a, nilaniya koyam ngul iiy aak nungantamak. ");
INSERT INTO wim_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","25","Anpalan ngula, nil wanch nungantam Elizabeth.ana iimpanang ngul iiy. Aꞌ nil thaw nungantakaman, “Nil Piip God.ana minam iiyanara. Puth imanam ngulana pam wanchangan keꞌ-ngul thaaꞌ-thengkathayn ngayanga, ngay puth puk tham ngula.” Aꞌ nil aawuch pulantamang angman nyiin-nyiin kep five.akama. ");
INSERT INTO wim_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Aꞌ kep thonang ngulan wantan-a, nil God.angana ngaantiyongk Gabriel anana putham ngul kuch nunang. Nil aak thonak ngul kuch nunang aak namp Nazareth.ak, Galilee.angan. ");
INSERT INTO wim_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Nil Gabriel alangana wik wampath wanch komananta, namp nungantiya Mary, nilana pamantang keꞌaman wun. Nil Mary.ana than kaaꞌngakin nunang pam Joseph.anta ngentow nunangan. Wuut mangk Joseph.antamiya, King David.ana. ");
INSERT INTO wim_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Nil ngaantiyongkan wamp nungant Mary.antan aꞌ thawant, “Ayyang, Mary-ang, nil Lord.ana ngangk min paththam wun nungkara; nil ngangk nungkarangan kan ngoonchow.” ");
INSERT INTO wim_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Nil puth Mary.antan kuchek way wunant aꞌ nil ngaantam-ngeey nungantakamana, “An wik nil wanttak ngul thawar e?” ");
INSERT INTO wim_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Aꞌ nil puth ngaantiyongkan thaw, “Marya, nintiya keꞌ winynyang moꞌāna. Nil piip God.ana min paththam iiy-iiyan nungkara. ");
INSERT INTO wim_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nint iimpanang ngul iiyāna, aꞌ puk many wuut kalān. Puth nintiy namp Jesus theeꞌān nungant. ");
INSERT INTO wim_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Nilan puth nhengk God.antam, moom piꞌan paththam ngamparamana. Nil tham piꞌan paththam iiyowa. Nil piip God.angan-a, pam piꞌan King ngul yumpow nunang keꞌ wuut mangk nungantam David.ana, ");
INSERT INTO wim_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","aꞌ nil moom piꞌan ngul iiyow thant pam wanch Jews al-alantan, aꞌ puth nil pam wanch anangan maꞌ nungantamang piꞌ-piꞌow thanang aak umpuyam.” Nil ngaantiyongkan yimanangan wik thaw nungant, wanch koman Mary.antan. ");
INSERT INTO wim_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Amanamaniya, nil Mary.an thaw nungant ngaantiyongk alantan, “Ngay ngul want-wanttak puk manyan uwāng a? Ngay pamantang keꞌam wunangan, yaꞌ yippaka.” ");
INSERT INTO wim_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Aꞌ ngaantiyongkan thawant, “Nil Ngeen Wiy God.antaman wampow nungkara, aꞌ ngangkang ngoonchow nungkarang. Nil God piꞌan paththamana, ngul wampow nungk, aꞌ puth anpalana nintana puk kalāna, an puth puk many God.antama. Than pam wanchangan ngul waaꞌayn nunang, ‘nhengk God.antama.’ ");
INSERT INTO wim_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Aꞌ putha inan thampa, nil kampan nungkaram Elizabeth.ana iimpanang thamp iiy-iiyana. Nil puth kaꞌathaman puk keꞌam kal, puth nungkway nil wanchinth ngul iiy-iiyan-a, nil God.angan puk kuch Elizabeth pulant Zechariah.angana. In kep six ngul nungant iimpanangan iiy-iiyan. ");
INSERT INTO wim_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Nil God.an piꞌana, maꞌ-kuncha, nil maꞌmangkamana nilam thonamang yump-yumpan.” ");
INSERT INTO wim_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Aꞌ nil Mary.an puth thawant, “Ngay puth maꞌ God.antang ngul iiy-iiyanga. Yaa, wik anangan nintan thawan ngathar-a, an mak wampow ngatha.” Aꞌ amanamaniya, nil ngaantiyongk alangan kan-ngul wantan. ");
INSERT INTO wim_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Anpalana, nil Mary alangan way min nungantam anangan kan-ngul yalmath thanang aꞌ kan erkam iiy Elizabeth.ant. Nil yiip iiy aak town many thonak Judea.angan aak yoykathiyaniya. ");
INSERT INTO wim_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Nil kanan wamp-a, nil aawuch Zechariah.antamak iiy, aꞌ pek ngoonch aꞌ Elizabeth.ant thaw, “Ayyang, ngay in wampang nungk.” ");
INSERT INTO wim_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Nil Elizabeth.angan man awal Mary.antaman ngeey-a, puk many nungantaman thipangan yuupamant. Aꞌ anpalaniya nil Ngeen-Wiy God.antam ngangkang ngoonch nungantang Elizabeth.antang, ");
INSERT INTO wim_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","aꞌ nil paththam othamayan thaw, “Nil God.an min paththam iiy-iiyan nungkara, puth wanch wiyantan yaꞌa. Aꞌ nil minam tham iiy-iiyan puk many nungkaramakan nanan thipangan kal-kalangan. ");
INSERT INTO wim_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nil kaath Lord ngatharamantaman in wamp ngathar. An wanttak a! Nil God.an min ngathara tham iiy ey! ");
INSERT INTO wim_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ngay man awal nintangan ngeeyangan-a, puk many ngatharaman ngangk min wun aꞌ yuup-yuupam ngul. ");
INSERT INTO wim_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nintaniya ngangk minangam iiyāna puth nint wik Lord.antaman minam ngaantam-ngeeyan kan-kanam ngulan wampow nungkara.” ");
INSERT INTO wim_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Aꞌ nil Mary ngul thaw: “Ngay Lord.an thaaꞌ-kuumpāng nunang. ");
INSERT INTO wim_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Nil God.ang ngangk min yumpan ngayang, nil minam piꞌan ngayang. ");
INSERT INTO wim_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Nil kan thath-thathan ngayanga, ngay maꞌ nungantangan iiy-iiyang ngul, ngay wanch piꞌan yaꞌa, ngay wanch many thonakam. Puth aak imanam ngulana, pam wanch yotang waaꞌ-waaꞌayn nil God.an min-minam paththam iiy-iiyan ngathara, ");
INSERT INTO wim_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","nil puth work piꞌan paththam yump ngatha. Nil God.aniya min-minam paththama! ");
INSERT INTO wim_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Niliya min iiy-iiyan thant pam wanch al-alantan than wik nungantam minaman ngeey-ngeeyantan aꞌ thant al-alantan thamp ngul-ngulan aak-ngeeyayn, than wik nungantaman minaman piꞌ-piꞌayn. ");
INSERT INTO wim_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Puth than wiy anangan ulp-ulpanangan iiy-iiyantana keꞌ pam piꞌan yumpwuntan-a, nil meenathan thant nilan thayan, aꞌ pal-puy yaarkathan thanang. ");
INSERT INTO wim_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Wiyiya, nil moom piꞌan anangan kuchan thanang than yipam pam piꞌan keꞌ-ngul iiyayn aꞌ work piꞌan ngul theeꞌan pam wanch al-alantan than pam piꞌanan keꞌaman yumpwuntan. ");
INSERT INTO wim_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Nil may minh min paththamana pam wanch al-alantan theeꞌ-theeꞌan thant meechan wun-wuntan may keꞌanangan, aꞌ putha nil pam wanch maꞌmangkiy anangan maꞌlip kuchan thanang. ");
INSERT INTO wim_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Aꞌ nilan puth maꞌ-aath-aathan thanang pam wanch nungantam anangan, Jews anangan. Puth nil keenkanaman thaw thant Abraham.ant aꞌ wuut mangk ngamparam wiy al-alantan, nil minam piꞌow thanang aꞌ puth kaaꞌ-piichanathow thanang aꞌ puth puk thanttam anangan ngulan aak-ngeey-ngeeyayn. Nunangan puth keꞌam kon-ngathan wik anangan nilan thaw thant, yaꞌa.” Nil wik yimanangan Mary.an thaw. ");
INSERT INTO wim_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Amanamaniy-a, nil Mary.ana angman ngul wun nungantang Elizabeth.antang kep koꞌalamakama aꞌ kan-ngul koyam iiy aak nungantamakan. ");
INSERT INTO wim_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Anpalana, aakan kan-ngul thinth wampant Elizabeth.antan puk manyan kalow aꞌ nil puk wuut many paththam kal. ");
INSERT INTO wim_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Wik thooꞌan yaꞌ weꞌaram nil puk manyan kal. Than kampan nungantam al-alangan, aꞌ puth pam wanch wiy anangan aak thinthan wunin, than thampa wik thooꞌan ngeeyin nil God.an minan iiy-iiy Elizabeth.ant. Thanana puth ngangk min-minam paththam iiy-iiyin aꞌ putha aak nungantamakan wamp-wampin thama. ");
INSERT INTO wim_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Kinch eightang kanan want nunang puk manyan-a, than ngeen-wiy nungantam peꞌanan umpina. Aꞌ pam wanch wiyangana keꞌ namp Zechariah waaꞌiythan nunang piip-kunchantanga, ");
INSERT INTO wim_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","puth nil Elizabeth kaath-kunchan thaw, “Yaꞌa, ngamp nunang John waaꞌāmp.” ");
INSERT INTO wim_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Thanan puth thawin nunganta, “Wanttak a? Ngul kampan nungkaram namp John wuntan ey? Yaꞌa!” ");
INSERT INTO wim_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Aꞌ thanan mal theeꞌin nungant Zechariah.antan, aꞌ engkin nungant namp wanttakan wunow nungant puk nhengk nungantam alantan. Puth Zechariah.ana wik keꞌanang yippak iiy-iiy. ");
INSERT INTO wim_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Aꞌ nil mal anman theeꞌ thant latakan aꞌ nil ump, “Namp nungantiya Johna.” Than puth thaaꞌam ikin. ");
INSERT INTO wim_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Aꞌ nil Zechariah.ana kan-ngul paththam wikan thaw aꞌ nil thaaꞌ-kuumpan nunang God.an. ");
INSERT INTO wim_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Puth than yotana winynyang ngul moꞌin aꞌ popam anman nyiinin. ");
INSERT INTO wim_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Than pam wanch al-alangamana wik thooꞌan puy-puyam ngul weꞌ-weꞌarathin pam wanch yotantan, aak yoykathiy Judea angan. Aꞌ thanan puth thanttakaman ngaantam-ngeeyin, “Puk many inan nil wanttak nath emowa? Nil emowan-a, nil pam piꞌan nath iiyowa.” Than puth kan meeꞌmiy nil God.an nungantang angman iiy-iiy, thayanaman piꞌ-piꞌan. ");
INSERT INTO wim_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Amanamaniya nil Ngeen-Wiy God.antamana ngangkang ngoonch piip-kunchantang Zechariah.antang, aꞌ nil wik God.antaman waaꞌ-waaꞌ thant: ");
INSERT INTO wim_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Ngamp yotamangana thaaꞌ-kuumpāmp nunang God ngamparamana. Nilaniya ngul wampow yipam pam wanch nungantam anangan kaaꞌ-piichanathow thanang way thanttam anpalan, aꞌ anpalaniya ngangk min wunow thant. ");
INSERT INTO wim_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Nil pam ngul kuchow ngampangan kaaꞌ-piichanathow, nil pam thayan paththam. Wuut mangk pam ilantamana, David, nil thamp pam God.antaman. ");
INSERT INTO wim_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","71","Than prophets al-alangan keenkanaman wik God.antaman wantin ngampar. Thanan thawin nil God.angan kan-kanam kaaꞌ-piichanathow ngampang pam wanch al-alantaman thanan kaangk keꞌ ngampangan, aꞌ putha way thakan yumpantan ngampar. ");
INSERT INTO wim_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Nil God.an kan-kanam thaw wuut mangk ngamparam al-alantan nil minan iiyow thant aꞌ ngampar tham. Wik anangan keꞌam kon-ngath nunang nilan thaw thant. ");
INSERT INTO wim_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Nilan kaaꞌngak nunang Abraham.an, nil kaaꞌ-piichanathowan ngampang ngamp yipam keꞌ-ngul winynyang moꞌāmp nungantam God.antaman, aꞌ putha work ngangk minangam iiy-iiyāmp nungant, ");
INSERT INTO wim_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","puth min anman iiy-iiyāmp meeꞌ nungantang ngulakam ngamp man-yetham yippakan iiy-iiyanamp.” ");
INSERT INTO wim_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Aꞌ nil Zechariah.an thaw ngul puk many nungantam alantan John.ant, wik God.antaman waaꞌ nungant: “Nintiya, nhengk ngatharama, nil God wuut piꞌan alangan work piꞌan theeꞌow nungk wik nungantaman yipam waaꞌān pam wanchantan. Nintiy putha keenk ngul iiyān, aꞌ wik waaꞌān thant nil Lord.an ngulan wampow, ");
INSERT INTO wim_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","aꞌ puth waaꞌān thant pam wanch nungantam al-alantan nil ngulan kaaꞌ-piichanathow thanang aꞌ puth way thanttaman ngul kon-ngathow nunangan. ");
INSERT INTO wim_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Puth ngampaniya keꞌ aak ngaaꞌang yimanangan wunanamp, winynyang moꞌanamp, mulan kaangk keꞌ wunāmp. Puth nil God ngamparaman min iiy-iiyan ngampar, nil ngangk mam-maman ngampang, nil puth pamana anpal keny ngul kuchow ngampar. Niliy keꞌ thum nganth yimanangan iiyow ngampara, nil woyan God.antaman meenathow ngampar aꞌ nil maꞌ-aath-aathow ngampang ngamp yipam woyan nungantaman ngangk minangam wak-wakāmp.” Nil Zechariah.an yimanangan thaw. ");
INSERT INTO wim_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Puk wuut many John.ana, piꞌan ngul em aꞌ ngangk minangam God.an monkan-wak-wak nunang. Nil pam ngulan iiy-a, nil kaꞌathaman aak pintalang wun-wun. Anpalana, nil wamp thant pam wanch aak Israel punchan al-alantan yipam wikan waaꞌow thant. ");
INSERT INTO wim_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Aak an-aniyangana, nil moom piꞌan paththam Augustus.an pam Romana, nil thanang pam wanch yotan maꞌ nungantang piꞌ-piꞌ thanang aak nath-nathan wun-wunin. Nilaniya wik kuch thant pam wanch maꞌmangkamantan than yipam iiyayn koyam aak wuut mangk thanttamangan wantina than yipam aak angana namp thanttaman lat piꞌanangan ump-umpayn. Nilan puth kaangk meeꞌmiy iiyow than pam wanch ngeen-ngeenan wunin aak anganiya. ");
INSERT INTO wim_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Aak an-aniyangan thama, nil pam namp Quirinius.an nil moom iiy-iiy aak Syria.akan. ");
INSERT INTO wim_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Puth thanan tham pam wanch maꞌmangkaman iiyayn aak wuut mangk thanttamakan, yipam namp thanttaman latangan umpayn. ");
INSERT INTO wim_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Pul Joseph.angan iiypul aak town Nazareth anpalan, aak inaniya aak Galilee.ang angman aꞌ pul town Bethlehem aakanakan iiypul, aak iniy-a, aak angman Judea.anga. Nil King David.an aak keenkan Bethlehem.ang aak-ngeey. Aꞌ nil puth Joseph.an aakanakan iiy, puth nil King David.an wuut mangk nungantama. ");
INSERT INTO wim_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Nil Joseph.angan wanch thum nungantaman Mary.an tham nungantang kalanwey, pul yipam namp pulantaman umpowpul. Nil puth Mary.an iimpanang iiy-iiy, an-aniyanganwey. ");
INSERT INTO wim_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Pul aak Bethlehem.angan wamppul-a, aakan kanam wampant Mary.antan puk manyan aak-ngeeyowant. ");
INSERT INTO wim_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Puk many kaaꞌ-ngeecham nunganta. Mary.ang pul Joseph.ang keꞌ motel minang wuniypul-a, puth yaꞌa, pam wanchangan aak ngathin, pulaniy iiypul aak-aakanakan minh bullocks thakan wuntan. Anpalaniya, puk manyan meeꞌ-pench, aꞌ kaath-kunchangan Mary.angan ngook ongkang kath nunang aꞌ wunp nunang yuk box wak thampang angan, wak minh bullocksangan mungkantan. ");
INSERT INTO wim_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Aak ngutang angmaniya pam shepherds puungk wiy al-alangan minh sheep anangan piꞌ-piꞌin thanang aak engkanang. ");
INSERT INTO wim_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Aꞌ ngaantiyongk God.antam inpal kenyan uk thant, aak nath-nathana nganthan park-park. Puth than pam shepherds anangan winynyang moꞌin. ");
INSERT INTO wim_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Nil ngaantiyongkana thaw thant, “Niiy keꞌ winynyang moꞌāna! Ngay inan wampang niiyant, wik min thamp waaꞌāng niiyant, amanamana, pam wanch yotamanta ngangk min wunow thant. ");
INSERT INTO wim_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ngutang inmana, aak town David.antamangan, puk many kanam meeꞌ-pench — nil ngulan kaaꞌ-piichanathow niiyang. Niliya Christ, moom piꞌan paththama, pam anman nil God.an thaw nil ngulan kuchow niiyant. ");
INSERT INTO wim_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Niiy inpalan iiyāna, puk manyan uwān nunang ngook ongkang kath nunang, kaath-kunchangan, aꞌ putha yuk box wak thamp minh bullocksantamang angan wun-wunan. Niiy kanan thathān nunang-a, niiy ngul ngaantam-ngeeyān ngay wik kan-kanaman waaꞌang niiyant.” ");
INSERT INTO wim_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Aꞌ yaam keꞌanama, ngaantiyongk yot thaaꞌ-wantanam inpal kenyan ukin ngaantiyongk thonamantang angman, thananiya aak path-pathin thaaꞌ-kuump-kuumpin nunang God.an, aak inan path-pathin: ");
INSERT INTO wim_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ngamp thaaꞌ-kuumpāmp nunang God in kenyan, nil puth piꞌan, min paththam. Than weeꞌ-weeꞌanang min-minam iiy-iiyantan meeꞌ nungantamangan-a, yaa, an than ngangk min wunayna.” ");
INSERT INTO wim_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Anpalana, than ngaantiyongk anangan koyam kanan matin-a, pam shepherds anangan thawin thanttakam, “Ngamp a! Ngamp kan iiyāmp aak Bethlehem.akan. Ngamp kan thathāmp ngeen nathaniya wampa nil Lord God.angan wik waaꞌ ngampar.” ");
INSERT INTO wim_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Than minh sheep anangan too wantin thanang, aꞌ erkam ngeetin aak Bethlehem.akan. Aꞌ than uwin thanang, Marya pul Joseph.anga, aꞌ puth puk many Jesus.an angman wun-wun yuk boxang. ");
INSERT INTO wim_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Than shepherds al-alangan puk manyan kanan thathin nunang-a, thanan puth pam wanch yotantan wikan waaꞌ-waaꞌin nil ngaantiyongkangan wik waaꞌ thant puk many alantaman. ");
INSERT INTO wim_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Than yotangan wik inangan ngeeyinan-a, than thaaꞌam ikin. ");
INSERT INTO wim_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Nil kaath-kunch Mary alangan wik min inangan ngaantam-ngeey-ngeey ngul aꞌ ngangk nungantamang piꞌ-piꞌ. ");
INSERT INTO wim_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Anpalana, than shepherds anangan koyam kan-ngul iiyin, than God.an thaaꞌ-kuump-kuumpin nunang, puth min waaꞌ-waaꞌin nunang, than puth puk manyan meeꞌ thanttamang thathin nunang keꞌ nil ngaantiyongkangan waaꞌ thant. ");
INSERT INTO wim_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Week thonamang kan-ngulan want-a, than ngeen-wiy peꞌan puk many alantaman umpin, nil yipam kompan thamp iiy-iiyow, puth aak thant yimanangan wunana. Aak an-aniyangana thananiya namp theeꞌin nungant, namp Jesus. Namp inman nil ngaantiyongkangan waaꞌ Mary.antan nil iimpanang keꞌan yippak iiy, anan namp waaꞌayn nunang. ");
INSERT INTO wim_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Anpalana, kep thonamang kanan want-a, Mary.ang pul Joseph.ang kan-ngul aak Jerusalem.akan iiypul yipam minh kalowpul aawuch ngench thayanakan, nil kaath-kunch Mary.an yipam ngench keꞌ-ngul wunow. Aꞌ pul puk many Jesus.an kalpul nunang aak ngench thayan aakanakan yipam meenathowpul nunang piip God.antan. Pul puth kaangk wik thayan Moses.antaman piꞌowpul. ");
INSERT INTO wim_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Puth nil Moses.an keenkanaman thaw Jews al-alantan, “Niiy puk wuut kaaꞌ-ngeecham anangan theeꞌān thanang God.antan than yipam work iiyayn nungant.” ");
INSERT INTO wim_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Aꞌ pul minh thak kalpul priest alantan theeꞌowpul nil yipam kiingkow altar angana aawuch ngench thayanangan. Aak thanttam yimanangan wun puth nil Moses.an thaw thant, “Niiy minh kolat kucham nath kalāna, nath minh munkiyang manyiy kucham kalān aawuch ngench thayanakan, yipam kaath puk many alantaman aak ngenchan keꞌ-ngul wunow nungant, kemp min ngul iiy-iiyow.” ");
INSERT INTO wim_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Aak angman Jerusalem.angan, pam wuut manth-thayan iiy-iiy namp nungantiy Simeon. Nil pam min aꞌ nil nathpalman ngaantam-ngeey-ngeey wik God.antam anman. Nil Simeon.ana ngangk minangam kuup-kuup God.ant nil yipam pam wanch Jews anangan kaaꞌ-piichanathow thanang. ");
INSERT INTO wim_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ngeen-Wiy God.antaman ngangk Simeon.antamang angman wun-wun, aꞌ nil keenk thaw Simeon.ant, “Nint yippak keꞌ uthamāna. Nint pam kanan thathān nunang nil God.angan ngulan kuchow niiyantan-a, nint ep ngul uthamāna.” ");
INSERT INTO wim_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Aꞌ ngulan nil putham thaw Simeon.ant, “Yaa, nint kan-ngul iiyān aawuch ngench thayan aakanakan.” Pul Mary aꞌ Joseph.ang kanan wamppul aawuch ngench thayanangan-a, pulaniya angman uwpul nunang Simeon.an aꞌ pul wik inan thawpul nungant God.ant, “Piip Goda, puk nganttam inan. Ngan kaangk nil min-minam em-emow nungkar aꞌ work iiyow nungkar anman.” ");
INSERT INTO wim_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Nil puth Simeon.angan Jesus.an maay nunang, aꞌ thankyou thaw piip God.antan. ");
INSERT INTO wim_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","Nilan thaw: “Lord-ang, nintan nganyangan kaaꞌngakan-a, puk manyana, an kan-kanama, ngay puth meeꞌ ngatharang kan thathang puk wuut inan nintan kuchan pam wanch anangan kaaꞌ-piichanathow. Yaa, ngayan ngangk minangam ngul uthamānga. ");
INSERT INTO wim_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Nint kuchan nunang yipam than yotamangan thathayn puk many inana. ");
INSERT INTO wim_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Nil keꞌ nganth yimanangan iiyow woyan nungkaraman meenathow pam wanch Jews yaꞌ al-alantan, aꞌ thananiya thaaꞌ-kuumpayn thanang Jews anangan, pam wanch nungkaram anangan.” ");
INSERT INTO wim_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Mary.ang pul Joseph.ang wik inangan ngeeypul-a, pulana thaaꞌam ikpul. ");
INSERT INTO wim_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Aꞌ nil Simeon.aniya God.ant thaw minam iiy-iiyow pulant aꞌ anpalaniya nil thaw nungant kaath-kunchak Mary.ant, “God.angan puk many inan miꞌan, nil yipam kaaꞌ-piichanathow thanang Jews wiy anangan, puth wiy anangan-a, than keꞌan ngeeyayn nunang Jesus.an-a, nil God.angan wayathow thanang. God.angan kuch nunang nil yipam meenathow ngampar nil God.an wanttakana. ");
INSERT INTO wim_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Than puth yotanganiya aak-yaꞌangan ngul waaꞌayn nunang Jesus.ana, anpalana, ngampan puth thiichāmp ngula than wanttakan wik thenchanaman ngaantam-ngeeyantan nunang Jesus.ana. Nint inan thathān-a, nint ngangk way wunān keꞌ kekangan chintin nintanga, ngangk nungkaniy-a, wench paththam wunow, puth puk nhengk nungkaramantam.” ");
INSERT INTO wim_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","An-aniyanganiya wanchinth thonam angman aawuch ngench thayanangan iiy-iiy, namp nungantaniya Anna. Piipiy nungantamaniy-a, Phanuel, wuut mangk Asher.antam wamp. Nil Anna alangana wik God.antaman waaꞌ-waaꞌ thant. Nil Anna.ang pul pam-kunchang karp wunpul kaap sevenakaman. Amanamaniya, pam-kunchan utham ngul. Nil wanch-kunch Anna.ana wukalongk ngulakam wuna. Nilaniya aawuch ngench thayanang angman nyiin-nyiin, kinchangan aꞌ ngutangan, meeꞌ-wuth-wuthanam God.anta, aꞌ nil mayan maꞌ-yotam want, nil yipam minam ngaantam-ngeeyow nunang God.an. ");
INSERT INTO wim_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Nil Simeon.an wikan thaw-thaw pulant-a, Mary-a, Joseph pulantan-a, nil Anna.ana wamp thantweya. Nil thath nunang puk manyan Jesus.an-a, nilan thaaꞌ-kuump piip God.aniya. Aꞌ nilana, wik Jesus.antaman waaꞌ thant pam wanch yotantan aak Jerusalem.angan, thananiy-a, kuup-kuupin God.antan paman kuchow nunang kaaꞌ-piichanathow thananganweya. ");
INSERT INTO wim_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Aꞌ Joseph.ang pul Mary.angan wik thayan God.antam piꞌ-piꞌpul maꞌmangkam nilan thaw lat ngench thayanangan piꞌ-piꞌowpul puk many alantana, aꞌ pulaniya koyam ngul iiypul aak pulantamak Nazareth.aka aak Galilee.ak. ");
INSERT INTO wim_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Nil puk Jesus.ana angman em-em, aꞌ kemp thayan ween. Aꞌ putha kuchek min-minam em, putha nil God.angan min-minam piꞌ-piꞌ nunang. ");
INSERT INTO wim_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","42","Nil puk ngechwiy Jesus.an kaap twelve.angan want nunang-a, nil aak Jerusalem.akan iiy, puth kaap thon-thonangana, pul kaath piip Jesus.antamana aꞌ puk pulantam anangan aak Jerusalem.ak yim-yimanangan iiy-iiyin. Than puth Jews.angan may piꞌan yump-yumpin — Passover.an waaꞌantan — aakanakan iiyin aak Jerusalem.akan. ");
INSERT INTO wim_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Anpalaniya, may piꞌan kanan minchathin-a, thanan koyam kan-ngul iiyin aak thanttamak, nil puth Jesus.ana angman Jerusalem.angan wun. Puth kaath piip nungantaman ngoongk-ngoongkam nil angman wun. ");
INSERT INTO wim_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Pulan puth ngaantam-ngeeypul nil nath wiyantang iiya, Jesus.ana. Pul kanaman ongkampul, kech ngulana, aꞌ pulan nungant ngul wenk-wenkpul. Kampan pulantamakan engkpul aꞌ ngurp pulantamakan engkpul thamp. ");
INSERT INTO wim_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Puth yaꞌa, keꞌam uwpul nunang, Jesus.ana. Ngaaꞌ thonangana, pul koyam iiypul aak Jerusalem.akan yipam wenkowpul nungant Jesus.antan. ");
INSERT INTO wim_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Aꞌ ngaaꞌ thon ngulan wuna, pul uwpul nunang aawuch ngench thayanang angman nyiin-nyiin thanttang, pam manth-thayanantang, ngeey-ngeey thanang, aꞌ engk-engk thant pam manth-thayan al-alantan, aꞌ wik koyam thaw-thaw thant. ");
INSERT INTO wim_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Than yotangan ngeeyin nunangan-a, thaaꞌam ikin, puth kuchek waap mina, nil puthangkaniya wik min-minam paththam thaw-thaw thant koyamaniya. ");
INSERT INTO wim_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Kaath piip nungantamangan thathpul nunanga, ngangk ikpul. Nil kaath nungantaman thaw nunganta, “Ayyang, thuwa, nint ngeenak wayaman ngant e? Ngan piip nungkaramang pal-puy wenk-wenkan nungkarak, ngan kootra way wunan nungkaram.” ");
INSERT INTO wim_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Nil puk Jesus.an thaw pulantan, “Nip ngul ngeenak pal-puy wenkanip ngathar e? Nip ngul keꞌ ngaantam-ngeeyanip ey? Ngay mak iiyāng aawuch piip ngatharamantamakan.” ");
INSERT INTO wim_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Puth pulan min-minana keꞌam ngaantam-ngeeypul nunangan, wik nilan thaw pulant. ");
INSERT INTO wim_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Anpalaniya, nil Jesus.ana koyam iiy pulantangan aak thanttamak aak namp Nazareth.akan. Nil puth Jesus.an puk min ema, wik pulantaman thak erkam ngeey. Puth nil kaath-kunchangana, wik Jesus.antam anangan ngangkangam piꞌ-piꞌ thanang. ");
INSERT INTO wim_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Nil Jesus.ana, kuchek waap min anman em-em, aꞌ kemp min anman em-em. Nil God.ana ngangk min paththam ngul wun nungant, puth pam wanch anangan thampan ngangk min ngul wunin nungant, Jesus.antan. ");
INSERT INTO wim_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Aak an-aniyangana Tiberius.an pam piꞌan paththam iiy-iiy pam wanchant umyompananant. Nil nathpalman moom piꞌan iiy-iiy kaapana fifteenang want nunang. Pontius Pilate pam piꞌan iiy-iiy aak Judea.aka, aꞌ Herod pam piꞌan iiy-iiy aak Galilee.ak, aꞌ puth kuunch-kunch Philip pam piꞌan iiy-iiy aak Iturea.ak putha Trachonitis.ak, nil Lysanias.ana pam piꞌan iiy-iiy aak Abilene.ak, ");
INSERT INTO wim_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","aꞌ Annas aꞌ Caiaphas moom piꞌan iiy-iiypul pam priests al-alantaman. Aak an-aniyangan-a, John.iya nhengk Zechariah.antamana aak pintalang iiy-iiy. Aak an-aniyangana God.an thawant wik min nungantaman waaꞌ-waaꞌow. ");
INSERT INTO wim_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Aꞌ anpalana nil John.an pal-puy iiy-iiy aak angman River Jordan thinth, aꞌ wik thaw thant pam wanchanta, “Way niiyan yumpaniya niiy kan-ngul wantāna! Niiy palaman weentān God.antan! Aꞌ ngay anpalana kuchek ngakang kuungk-kuungkāng niiyang, aꞌ nil God.angan keꞌ-ngul ngaantam-ngeeyow way yot niiyan yump-yumpan.” ");
INSERT INTO wim_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Aak keenkanamana nil pam prophet Isaiah alangan pam John inman waaꞌ-waaꞌ nunang, lat ngench thayanangan ump. Nil wik inangan thaw: “Nil pam thonam iiy-iiyow aak pintalangana, aꞌ wik inangan pech-pechow, ‘Niiy woyan min-minam kan yumpān nungant Lord.antana, koochanam yumpān nungant nil yipam iiy-iiyowa! ");
INSERT INTO wim_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Aak um wukar angana, chil theeꞌān, achantang yumpān, aꞌ yoyk many aꞌ puth yoyk piꞌ-piꞌanama manchathāna, aꞌ woyan kul-kulak anangana koochanathāna, aꞌ woyan waya thal-thala pintanathān, ");
INSERT INTO wim_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","than puth pam wanch aak umyompanaman wuntan yipam thathayn nil God.angan pam wanch wanttakan kaaꞌ-piichanathow.’” ");
INSERT INTO wim_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Aꞌ anpalaniy-a, pam wanch thaaꞌ-wantanaman wampin nungant John alantan nil yipam kuchek ngakang kuungkow thanang. Nil thaw thant, “Niiy thuuk inangana pal ngathar ngul wampaniy ey? Niiyang weeꞌang kon thayanath appenchān nungantam God.antaman e? Nil puth man kul paththam wamp nungant niiyantakana! Puth aakan kan-ngul wampan nilan um nungantangan thanathow ngampangana puth mepow ngampanga. ");
INSERT INTO wim_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Niiy kan min yumpāna! Niiyaniya meenathān niiyantakamana niiyan kan-ngul wantan way niiyan yump-yumpana. Niiy ngaantam-ngeeyaniy nil Abraham.an wuut mangk ngamparam putha, nil keꞌ-paal piip God.ana man kulan keꞌ wampiy nungant ngamparakan ey? An yimanangan keꞌ ngaantam-ngeeyāmpa! Puth inan ngeeyāna: kaangk nilwey-a, piip God.angan kunttow inangan epankathiy puk Abraham.antakanweya. ");
INSERT INTO wim_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Nil God.angan pam wanch thanathow ngampang-a, nil keꞌ pam yuk thayan maꞌang kal-kalow yimanangan, keꞌ yukan ump-umpiy thananga. Yuk anangan may min keꞌaman kalin-a, ananganiya, nil thayanang thalokang umpow, aꞌ keekathow thanang, aꞌ amanamaniy-a, piw theeꞌow thanang thumang ngula.” ");
INSERT INTO wim_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Than pam wanch anangan thawin nungant, “Ayyang, ngul ngan wanttak yumpān e?” ");
INSERT INTO wim_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Nil thaw thant, “Nil weeꞌ-nathan shirt kucham thampwey-a, nil thonaman theeꞌow pam weeꞌ-nath alantan shirt keꞌanangan wunan. Aꞌ nil weeꞌ-nathan may thamp-a, nil maꞌ-aath-aathow wiy anangan.” ");
INSERT INTO wim_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Aꞌ anpalaniy-a, than pam wiy anangan wampin nungant John alantan nil yipam kootra kuungkow thanang. Pam inangan-a, work thant wukalan taxakan yal-yalmathin Government.akan. Than thawin nungant, “Ayyang, moom-ang, ngan wanttak ngul yumpāna?” ");
INSERT INTO wim_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Nil John.an thaw thant, “Niiy wukal tax amanamana yot-yotam keꞌ yalmathān pam wanchantamana, wukal wiy yipam piꞌān niiyantakamana. Niiy wukal anman thonakam maayān thanttam nil pam piꞌanan thawow niiyant ngeen-ngeenan uw-uwān pam wanchantamana.” ");
INSERT INTO wim_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Aꞌ than soldiers wiy anangan wampin nungant, aꞌ thawin nungant, “Ayyang, ngan wanttaka? Ngan wanttak yumpāna?” Nil thaw thant, “Niiy pam wanch keꞌ thaachān thanang wukal yipam theeꞌayn niiyant. Aꞌ aak-yaꞌangan keꞌ waaꞌān thanang wukal yipam theeꞌayn niiyant. Niiy wukal niiyantaman uwaniy-a, an kan mina, puthamakan keꞌ thaw-thawāna.” ");
INSERT INTO wim_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Than pam wanch al-alangan wik inangan ngeeyin-a, than ngaantam-ngeey-ngeeyin thanttakam nil John.an nath pam anman nil God.angan keenkanam kaaꞌngak kuchowan nunang. ");
INSERT INTO wim_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Nil puth John.an thaw thant, “Ngayana niiyang kootra ngakangan kuungk-kuungkanga, puth pam thonangan ngul wampowa, mangk ngatharangana, puth nilaniya ep-paththama pam wuut piꞌan paththama, ngay yaꞌa, ngay pam manyweya. Ngayana pekam keꞌ thuchinga, thaꞌ murrukan thapathing thaꞌ nungantam amanamana yaꞌa puth ngay pam piꞌan yaꞌa. Ngay ngakang thonakam kuchek kuungk-kuungkang niiyang, puth nilaniya Ngeen-Wiy Min God.antaman ngul kuchow niiyant, nil keꞌ thum yimanangan niiyant, ngangkangan ngoonchow. ");
INSERT INTO wim_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Nil pam inmana keꞌ pam gardener yimanangan wampow nil yuk nungantaman maꞌang kal-kalow yipmam wookan yaarkathow may min amanaman, aꞌ nil yipam may min anangan yalmathow aak nungantamakana, wook way anangana, nil thumang kiingkow thanang, thum keꞌaman uthaman, angan pench-penchow,” nil John.an wik yimanangan thaw. ");
INSERT INTO wim_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Aꞌ nil John.angan keꞌ-ngoongkam anman wik min God.antam waaꞌ-waaꞌ pam wanch al-alantan aꞌ nil wik thaaꞌ-thayanam thaw-thaw thant woyan way anpalan weentayn. ");
INSERT INTO wim_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Aꞌ nil wak-wak nunang moom piꞌanan Herod.an, nil puth wanch pont-kunch maꞌam piiyana nil wanch nungantakam ngul maayana, aꞌ way wiy-wiy anangan keꞌ-ngoongkam yump-yump. ");
INSERT INTO wim_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Aꞌ ngul-ngulana nil Herod alangan-a, way putham puy-puyam yump, nil puth John.an mam nunang, aꞌ jailang thench nunang. ");
INSERT INTO wim_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Nil keꞌan yippak jailangan wun-a, John.angana pam wanch yot anangan kootra ngakang kuungk-kuungk thananga. Aꞌ amanam ngulana an nunang ngul kootra ngakangan kuungkan Jesus.ana. Nil Jesus.an meeꞌ-wuthanam ngula. Nil meeꞌan wuth-wuthanam yippak-a, aak yuw in kenyana yaꞌ ika, ");
INSERT INTO wim_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","aꞌ nil Ngeen-Wiy Min God.antaman inpal kenyan uk-uk keꞌ minh kolat yimanangan wamp nungantana. Aꞌ wik inpal kenyan thaw, “Nint nhengk ngatharama! Ngay kaangk paththam wunang nungkar. Ngay ngangk min-minam paththam wunang nungkaramaniya.” ");
INSERT INTO wim_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Anpalaniy-a, nil Jesus.an kan-ngul work iiy-iiy. Aak an-aniyangan-a, kaap thirty.ang want nunang. Thanan Jesus keꞌ nhengk Joseph.antam waaꞌin nunang. Thanan ngaantam-ngeeyin keꞌ piipiy nungantam Joseph.ana, nil yaꞌa, nil piipiy-emathanam. ");
INSERT INTO wim_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Nil Joseph.antaman piip inan Heli; nil Heli.antamana piip inan Matthat; nil Matthat.antaman piipa inan Levi; nil Levi.antaman piipa inan Melchi; nil Melchi.antaman piipa inan Jannai; nil Jannai.antaman piipa inan Joseph; ");
INSERT INTO wim_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","nil Joseph.antaman piipa inan Mattathias; nil Mattathias.antaman piipa inan Amos; nil Amos.antaman piipa inan Nahum; nil Nahum.antaman piipa inan Esli; nil Esli.antaman piipa inan Naggai; ");
INSERT INTO wim_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nil Naggai.antaman piipa inan Maath; nil Maath.antaman piipa inan Mattathias; nil Mattathias.antaman piipa inan Semein; nil Semein.antaman piipa inan Josech; nil Josech.antaman piipa inan Joda; ");
INSERT INTO wim_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Nil Joda.antaman piipa inan Joanan; nil Joanan.antaman piipa inan Rhesa; nil Rhesa.antaman piipa inan Zerubbabel; nil Zerubbabel.antaman piipa inan Shealtiel; nil Shealtiel.antaman piipa inan Neri; ");
INSERT INTO wim_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nil Neri.antaman piipa inan Melchi; nil Melchi.antaman piipa inan Addi; nil Addi.antaman piipa inan Cosam; nil Cosam.antaman piipa inan Elmadam; nil Elmadam.antaman piipa inan Er; ");
INSERT INTO wim_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","nil Er.antaman piipa inan Joshua; nil Joshua.antaman piipa inan Eliezer; nil Eliezer.antaman piipa inan Jorim; nil Jorim.antaman piipa inan Matthat; nil Matthat.antaman piipa inan Levi; ");
INSERT INTO wim_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","nil Levi.antaman piipa inan Simeon; nil Simeon.antaman piipa inan Judah; nil Judah.antaman piipa inan Joseph; nil Joseph.antaman piipa inan Jonam; nil Jonam.antaman piipa inan Eliakim; ");
INSERT INTO wim_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","nil Eliakim.antaman piipa inan Melea; nil Melea.antaman piipa inan Menna; nil Menna.antaman piipa inan Mattatha; nil Mattatha.antaman piipa inan Nathan; nil Nathan.antaman piipa inan David; ");
INSERT INTO wim_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","nil David.antaman piipa inan Jesse; nil Jesse.antaman piipa inan Obed; nil Obed.antaman piipa inan Boaz; nil Boaz.antaman piipa inan Salmon; nil Salmon.antaman piipa inan Nahshon; ");
INSERT INTO wim_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","nil Nahshon.antaman piipa inan Amminadab; nil Amminadab.antaman piipa inan Admin; nil Admin.antaman piipa inan Arni; nil Arni.antaman piipa inan Hezron; nil Hezron.antaman piipa inan Perez; nil Perez.antaman piipa inan Judah; ");
INSERT INTO wim_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","nil Judah.antaman piipa inan Jacob; nil Jacob.antaman piipa inan Isaac; nil Isaac.antaman piipa inan Abraham; nil Abraham.antaman piipa inan Terah; nil Terah.antaman piipa inan Nahor; ");
INSERT INTO wim_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","nil Nahor.antaman piipa inan Serug; nil Serug.antaman piipa inan Reu; nil Reu.antaman piipa inan Peleg; nil Peleg.antaman piipa inan Eber; nil Eber.antaman piipa inan Shelah; ");
INSERT INTO wim_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","nil Shelah.antaman piipa inan Cainan; nil Cainan.antaman piipa inan Arphaxad; nil Arphaxad.antaman piipa inan Shem; nil Shem.antaman piipa inan Noah; nil Noah.antaman piipa inan Lamech; ");
INSERT INTO wim_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","nil Lamech.antaman piipa inan Methuselah; nil Methuselah.antaman piipa inan Enoch; nil Enoch.antaman piipa inan Jared; nil Jared.antaman piipa inan Mahalaleel; nil Mahalaleel.antaman piipa inan Kenan; ");
INSERT INTO wim_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","nil Kenan.antaman piipa inan Enosh; nil Enosh.antaman piipa inan Seth; nil Seth.antaman piipa inan Adam; nil Adam.antaman piipa inan God. ");
INSERT INTO wim_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Anpalan-a, nil Jesus.an aak kikkiy Jordan anpalan wamp. Nil Ngeen-Wiy Min God.antaman ngangkang wun-wun nungantang, aꞌ ngangk thay-thayanath nunang. Aꞌ nil Ngeen-Wiy Min God.antam alangana kal nunang aak pintalakan. ");
INSERT INTO wim_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Nilana yaam wun-wuna, kinchiya forty.akam, aꞌ nil oony wayan wamp-wampant yipam thaachow nunang wayan yumpow. Nil an-aniyangan may keꞌam mungk-mungk, aꞌ nil meech paththam wun. ");
INSERT INTO wim_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Nil oony wayan wamp nungant Jesus.antan aꞌ thawant, “Nint nath kan-kanamwey nhengk God.antaman-a, yaa, nint kunttow inangan epankathān thanang may breadakana.” ");
INSERT INTO wim_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Puth nil Jesus.an thaw nungant, “Ngay keꞌa! Kan in ngeeyāna! Puth wik inangan lat ngench thayanangan thawana, ‘Pam wanch al-alangan mak wik ngeeyayn God.antamana. Than mayam thonakamana keꞌ mungk-mungkiythana, an than minam keꞌ wuniythan, yaꞌa. Than wik God.antamana mak ngeey-ngeeyayna!’” ");
INSERT INTO wim_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Amanamaniya, nil oony way alangan kal nunang Jesus.an, aꞌ aak nath-nathan yotaman erkam meenath nungant, pam wanch thaaꞌ-wantanaman thaaꞌ-nganth thon-thonan wun-wunin. ");
INSERT INTO wim_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Aꞌ nil thawant, “Ngay moom piꞌan ngul yumpāng nintang aak ingan aak umyompanamak, aꞌ aak yot-yotam nath-nathan wun-wuntan-a, theeꞌāng nungkar thamp. Nil God.angan puth ngathar theeꞌ, maꞌ ngatharang ngul, aꞌ puth ngay ngul theeꞌāng weeꞌantan ngayan kaangk theeꞌāng. ");
INSERT INTO wim_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Puth nint kaꞌathamana thaaꞌ-kuumpān ngayang, aꞌ anpalaniy-a, ngay yotam inangan theeꞌāng nungk, aꞌ moom piꞌan paththam yumpāng nintanga.” ");
INSERT INTO wim_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Nil Jesus.an thawant, “Lat ngench thayanangan waaꞌana, ‘Niiy God anman thonakam thaaꞌ-kuump-kuumpān nunanga, aꞌ monkan-wak-wakān nunanga, wiy yaꞌa!’” ");
INSERT INTO wim_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Amanamaniya, nil oony way alangan Jesus.an aak Jerusalem.ak kal nunang, aawuch ngench thayan aakanakan, aꞌ keny kech kal nunang, aꞌ oony way piꞌanan thaw nungant Jesus.antan, “Nint nathwey kan-kanam puk nhengk God.antaman-a, yaa, nint inpalan chang peyāna aakanakam pek aakaka! ");
INSERT INTO wim_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Puth wik inangan lat ngench thayanangan thawana, ‘God.angan ngaantiyongk nungantam anangan ngul kuchow thanang yipam minam piꞌ-piꞌayn nintanga.’ ");
INSERT INTO wim_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Wik inangan thamp thawana, ‘Than ngaantiyongk al-alangan maꞌang mamayn nintang yipmam nint keꞌ keekān yaꞌa, thaꞌ nungkaraman keꞌ thuthin kunttowangan yaꞌa.’” ");
INSERT INTO wim_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Puth Jesus.an thaw nungant, “Ngay keꞌa! Puth wik inangan lat ngench thayanangan thawan thampa, ‘Niiy keꞌ paathān piip God niiyantamana!’” ");
INSERT INTO wim_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Nil oony way alangan kanan yaꞌangaman paath-paath nunang Jesus.an-a, way wiy-wiyam thakan yipam yumpow-a, oony way alangan yaan manyam want nunang. ");
INSERT INTO wim_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Anpalan-a, nil Jesus.an koyam iiy aak Galilee.akan, aꞌ nil Ngeen-Wiy Min God.antam alangan ngangk thay-thayanath nunang, ngangk nungantangan wun-wun. Wik thooꞌ weꞌaram nungantam Jesus.antaman aak angman Galilee wakan. ");
INSERT INTO wim_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nil churches Jews.antamakan iiy-iiy, aꞌ pam wanch thaaꞌ-aath-aath thanang, aꞌ than yotamangana min waaꞌin nunang. ");
INSERT INTO wim_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Anpalana, nil Jesus.an aak Nazareth aakanakan iiy, aak nilan em-em puk manyaman. Saturday ngulana, nil church thanttamakan iiy, nil puth Saturday thon-thon aakanakan iiy-iiy. Aꞌ nil Jesus.an churchang than nil yipam lat ngench thayan anpalan readimpungow pam wanchantan, ");
INSERT INTO wim_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","aꞌ nil pam thonamangana lat theeꞌ nungant Jesus.ant lat pam prophet Isaiah alangan keenkanaman ump. Aꞌ nil Jesus.angan wik inangan uw latangan aꞌ kan-ngul readimpung: ");
INSERT INTO wim_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Ngeen-Wiy Min God.antaman kanam wamp ngathar aꞌ work theeꞌar wik min waaꞌ-waaꞌāng thant pam wanch ngangk wayan iiy-iiyantan, wukal keꞌanang thakan wun-wuntan. Nil kuch ngayang tham ngay yipam thawāng thant pam wanch al-alantan jailangan wuntan, ‘Nil God.angan ngul pentathow niiyang,’ aꞌ ngay yipam meeꞌ koꞌanch al-alantan thamp thawāng thanta, ‘Nil God.angan ngul meeꞌ min yumpow niiyang,’ aꞌ putha pam wanch al-alantan thawāng than moom wayantangan maꞌ iiy-iiyantana, ‘Nil God.angan maꞌam piiyow thanang moom wayanang anangana.’ ");
INSERT INTO wim_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Aꞌ ngay tham inan thawāng, ‘Aakan kan-kanang wampana nil God.ang kaaꞌ-piichanathowan niiyanga.’” ");
INSERT INTO wim_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Nil Jesus.angan wik inangan kanan readimpung-a, nil latana kan-ngul akul-pip aꞌ koyam ngul theeꞌ pam alantan nil kaꞌathaman theeꞌ nungant aꞌ nil Jesus.ana nyiin ngul. Pam wanch maꞌmangkam anangan aak churchang angman-a, oth thath-thathin nunang Jesus.an, ");
INSERT INTO wim_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","aꞌ nilan thaw thant, “Kinch inman-a, wik inan kan-kanam wamp, ngay pam inmana lat ngench thayanangan waaꞌ-waaꞌina.” ");
INSERT INTO wim_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ngul amanamaniya than thaaꞌam ikin aꞌ ngaantam-ngeeyin, “Wik nungantam anangana min-minam paththama,” aꞌ thawin thanttakaman, “Ayyang, nil nhengk Joseph.antam aa! Piip-kunch pam piꞌan yaꞌ aa!” ");
INSERT INTO wim_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Nil puth Jesus.an thaw thant, “Niiy ngul nath wik inangan thawān ngathar, ‘Ayyang, nooyan-ang, nint nungkarakam miyalathāna,’ aꞌ niiy ngul thawān ngathar thamp ngay work piꞌ-piꞌanam mak meenathāng niiyant, aak ngatharamang ingana, niiy tham yipam thathān, niiy puth wik thooꞌ ngatharam ngeeyan ngay work piꞌ-piꞌanaman yump-yumpang aak Capernaum.ang angana. Puth ngay inan thawāng niiyant: ");
INSERT INTO wim_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","nil weeꞌangan nathwey wik min God.antaman waaꞌ-waaꞌiy thant kampan nungantam al-alantan-a, than aak thonamaman wampin-a, puth thanan kaangk keꞌ wik nungantaman ngeeyayn. ");
INSERT INTO wim_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ngay in kan-kanam waaꞌang niiyant Elijah.antama, nil pam inman wik min God.antaman waaꞌ-waaꞌ. Aak keenkanama, ngak keꞌam wamp kaap koꞌalamaka aꞌ putha kep sixakam may thakan keꞌam em-emin yaꞌ anman. Pam wanch puk aak thon-thonangan kan-ngul mayaman meechamin. Wanch wukalongk yotwey aak angan wun-wunin. ");
INSERT INTO wim_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Puth nil God.angan Elijah keꞌam kuch nunang wukalongk yot al-alantan, aak Jews.an wun-wunin, angan yaꞌa, nil aak thonak kuch nunang, aak Sidon.ak, nilan yipam maꞌ-aathow wukalongk thonamanwey aak town Zarephath.angan wun. ");
INSERT INTO wim_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Aꞌ putha inan tham ngeeyāna: aak keenkanama pam wanch yot weech-weech thanang leprosy.an uwin. Elisha, pam nilan wik God.antaman waaꞌ-waaꞌ, nil keꞌam miyalath thanang pam wanch Jews anangan, aak nungantam anpalmana, yaꞌa. Niliya thonakam Naaman.an miyalath nunang, puth nil pam thaaꞌnganth thona, aak Syria punchan, nil pam Jew yaꞌa.” ");
INSERT INTO wim_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Than pam wanchangana wik Jesus.antaman ngeeyin-a, man kul wamp thant ");
INSERT INTO wim_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","aꞌ thanan wur ekin, poo-poo thaꞌin nunang Jesus.an aak church anpalan aꞌ wich-wichin nunang yoon aak achantangaka, aak town thanttam angan. Thanan keꞌ maayiythan nunang aꞌ pek theeꞌiythan nunang-a, ");
INSERT INTO wim_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","puth nilaniya koyam ngul weent menh-menhang anman pent thanttang aꞌ too want thanang. ");
INSERT INTO wim_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Anpalana, nil Jesus.ana aak town Capernaum.ak wamp, aak Galilee angman. Aak Saturday ngulan wun-a, nil Jesus.ana church thanttam Jews al-alantaman angan ngoonch aꞌ kan-ngul wik God.antaman thaaꞌ-aath-aath thanang pam wanch anangan. ");
INSERT INTO wim_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Than pam wanchang wik nungantaman ngeeyin-a, than yotaman thaaꞌam ikin, puth nil Jesus.ana wik min thaw-thawa keꞌ pam God.angan kuch nunang, wik min anman waaꞌ-waaꞌ thant. ");
INSERT INTO wim_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Aak church angman-a, nil pam thonamana oony way ngangkang piꞌ-piꞌ. Nil othamayan paththam pech, ");
INSERT INTO wim_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ayyang, Jesus-ang, aak Nazareth anpalan wampan ey! Nint pal ngeenak wampan ngant e? Nint yipam nganang pam wanch yotaman mulathān ey? Puth ngay nintang meeꞌmiya — nint in pam ngench thayana, nil God.angan kuch nintanga!” ");
INSERT INTO wim_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Nil puth Jesus.angan oony way anan thaaꞌ-thayanam wak nunang, pam alantangan ngangkangan wun-wun, “Nint appapa! Aꞌ pentān nungantam ngula pam nalantamana!” Amanaman-a, nil oony way alangan paman yaꞌ unch nunang meeꞌ yotantang, aꞌ anpalaniya, oony wayan-a, pent ngul pam alantaman, nil paman-a, min ngul wun. ");
INSERT INTO wim_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Than pam wanch churchang angan nyiin-nyiinin-a, an than thaaꞌam ikina, aꞌ thanan kan-ngul thaw-thawin thanttakamana, “Ayyang, inan wik wanttaka? Nil pam inana wiy-wiyama! thayan paththama! Nil oony way anangan kenthan thanang, thanan puth pentin ngul ngangk pam wanch al-alantamana!” ");
INSERT INTO wim_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Aꞌ anpalaniya than pam wanchangan wik thooꞌ Jesus.antaman puy-puyam weꞌ-weꞌarathin, aak nath-nathangan. ");
INSERT INTO wim_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Amanamaniya, nil churchaman pent aꞌ nil aawuch Simon.antamak iiy ngul. Piny-kench Simon alantamana ngunthamang uwan, kemp nungantamana karkan peya, nil anman way-wayam paththam wun-wun. Thanana Jesus.ant thawin miyalathow nunang. ");
INSERT INTO wim_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yaa, nil Jesus.ana wanch alpan alantan iiya aꞌ angman nungantang than aꞌ ngunthaman pentath ngangk nungantam anpalana, an nil min paththam ngul ween. Aꞌ nil ek-a, aꞌ may ngul aath-aath thanang. ");
INSERT INTO wim_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Anpalan-a, kinch-way-wayangana-a, pam wanchangan kampan thanttam anangan weech-weechan thanang wamp-wampathin nungant Jesus.antan nil yipam miyalathow thanang, than wiyan meeꞌ koꞌanch, wiy kunp, nguntham wiy-wiyam thakan uw-uwina. Aꞌ nil Jesus.angan maꞌan wunp thanttang thon-thonamantangana, an paththam yot anangana miyal ngul ween-weenin, keꞌam ngul weech thanang yaꞌa. ");
INSERT INTO wim_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Wiyiya oony way anangan kenth thanang ngangk pam wanchantam anpalan. Kanan pentin-a, thanan othamayan pech-pechin, “Nint in pam nhengk God.antam a!” Puth nil Jesus.an thaw thant oony way al-alantan, “Niiy appap iiyāna.” Puth thanan kan meeꞌmiy an nil Christ.ana, pam anan nil God.angan kaaꞌngak aak iikanakan kuchowana. ");
INSERT INTO wim_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ngaaꞌ thonangan-a, aak ngaaꞌ-ngaaꞌthiyangaman-a, nil Jesus.angan aak town anan want aꞌ aak enyanak iiy aak pam wanch keꞌanangan. Puth than pam wanch yot anangan wenk-wenkin nungant. Aꞌ thanan uwin nunang aꞌ thawin nungant, “Nint aak nganttam keꞌ yippak wantāna! Ingman yippak wunāna!” ");
INSERT INTO wim_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Nil puth thaw thant, “Ngay mak iiy-iiyāng villages thon-thonakana, aꞌ pam wanch wiy anangan thamp thaaꞌ-aath-aathāng thanang, waaꞌ-waaꞌāng thant nil God.angan pam wanch yot anangan maꞌ nungantangan piꞌow thanang. Nil puth God.angan aakanakan kuch ngayang, ngay wik min yipam waaꞌāng.” ");
INSERT INTO wim_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Anpalana, nil Jesus.ana village thon-thonakan iiy-iiy aak angmana. Nil church thon-thonangan wik min God.antaman waaꞌ-waaꞌ thant. ");
INSERT INTO wim_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Anpalana, nil Jesus.an thompang than-than aak namp Gennesaret. Pam wanch yot wampin nungant Jesus.antan, than wik God.antaman ngeeyayn nilan Jesus.angan waaꞌow thant. Than thaꞌ-thaꞌwin thanttakaman puth than kaangk thintham wampayn. ");
INSERT INTO wim_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","3","Aꞌ puth nil Jesus.anganiya, chukkun kucham thath thompangan than-thanpul, than pam minh ngaꞌakan iiyin-a, al-alangan wichin. Pam inanganiy-a, Simona, puth-a, puk nhengk Zebedee.antam James aꞌ John, aꞌ wiy anangan thamp. Than puth punththaman thanttaman ngakangan pachathin. Nil Jesus.ana, chukkun Simon.antamangan chang pey, aꞌ Simon.ant thaw, “Kan pek manyam thaꞌān ngayanga aak thomp amanama!” Amanamaniya, nil Jesus.an nyiin ngul chukkunang angan, kan-ngul wik God.antaman waaꞌ-waaꞌ thant pam wanch yot al-alantan. ");
INSERT INTO wim_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Nil Jesus.angan wik kanan minchath-a, nilan Simon.antan thaw ngul, “Kan pek-pek thaꞌāna! ngak thangkaka! Punththaman niiyantaman pek ukathāna! niiy yipam minh ngaꞌ mamān a!” ");
INSERT INTO wim_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Aꞌ Simon.an thaw nungant, “Ayyang, Mooma! Ngan puth ngut ongk yaꞌangam punththamanan theeꞌ-theeꞌan minh ngaꞌakweya, puth minh yaꞌa, keꞌam maman. Nint puth thawan ngant — yaa, ngan mak theeꞌān yaana minh ngaꞌakana.” ");
INSERT INTO wim_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Yaa, Simon weeꞌanang al-alangana punththaman thanttam koꞌalaman ngakang pek ukathin minh ngaꞌakan. Aꞌ minh ngaꞌ thaaꞌ-wantanam wip-wipin punththamanangan. Than keꞌ punththaman wichiythan-a, yaꞌ, warꞌam ik-ik thant, puth than minh ngaꞌ thaaꞌ-wantanaman wip-wipin a! puth anhan uth a! ");
INSERT INTO wim_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Than puth maꞌ wooꞌ theeꞌin pam wiy al-alantan chukkun thon anpalan maꞌ-aathayn thanang. Anpalana, than wampin aꞌ minh ngaꞌ anangan chukkun kuchamangan wunpin, puth minh yot-yotam a! Chukkun kuchamaniy-a, yaꞌ ngath minh ngaꞌangan, warꞌam thuchathin. ");
INSERT INTO wim_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Than Simon weeꞌanangan minh ngaꞌ thaaꞌ-wantanam thathin-a, meeꞌam ikin, puth yot a! Aꞌ James.ang pul John.ang, nhengk Zebedee.antaman pul thampang meeꞌam ikpul. Nil Simon.aniya, pungkang nyiin um Jesus.antan, aꞌ thawant, “Ayyang, Lord-ang, nint puyam iiyān, puth ngayan pam way a!” Aꞌ Jesus.an thaw Simon.antan, “Keꞌ winynyang moꞌān ngatharam a! Nint keenkan iiy-iiyan minh ngaꞌaka, puth nint imanamana, kan-ngul pam wanch al-alantan iiy-iiyān aꞌ pal kal-kalān thanang ngathar.” ");
INSERT INTO wim_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Amanamaniya, than koyam iiyin thompak, chukkun anangan keny ngul wichin punththaman thakan. Aꞌ than Jesus.an kan-ngul monkan-wakin nunang ngula, work thanttaman wantin ngul, nungantangan ngul iiyin. ");
INSERT INTO wim_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Nil Jesus.an aak town thonak iiy. Nil pam thonam aak angman wun-wuna, pam inaniy-a, wenchangam makan iiy-iiy kemp wakanangana. Aꞌ nil Jesus.ant wamp, aꞌ aakakam kuchek pekakam thuch Jesus.antan, aꞌ thaaꞌ-mamanang thaw nungant, “Ayyang, Moom-ang! Nint kaangk nathweya min yumpin ngayangan-a, ngay puth kan meeꞌmiy nintangana nint minam ngul yumpin ngayangana.” ");
INSERT INTO wim_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Aꞌ nil Jesus.angan maꞌ ongkarama, aꞌ paman mam nunang, aꞌ thaw nungant, “Ngay kaangk inman miyalathāng nintangweya, nint kemp min ngul iiy-iiyāna!” Aꞌ wenchan erkam yaꞌamin nungant. ");
INSERT INTO wim_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Anpalaniya, nil Jesus.an wik thaaꞌ-thayanam thawant, “In ngeeya! Nint keꞌ waaꞌān thant wiy al-alantan ngayan nintangan miyalathanga. Nint kan erkam iiyān pam priest alantan, nil yipam thathow nintang kemp min ngula, wenchan-a, yaꞌ-ngulan weenana. Anpalan-a, nint minh thakan kalān aawuch ngench thayanakana, aꞌ angan thaaꞌ-kuumpān nunang, piip God.an. Puth wik Moses.angan anman waaꞌ. Anpalan-a, pam wanch yotang ngul thathayn, aꞌ thiichayn nintang kemp min, wench keꞌanang ngulana.” ");
INSERT INTO wim_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Wik inan Jesus.antaman-a, wik thooꞌan-a, erkam weꞌaram puy-puyam, aꞌ pam wanch thaaꞌ-wantanaman wampin, yipam ngeeyayn nunang wikan waaꞌ-waaꞌow thant, aꞌ nil yipam miyalathow thanang anangan weechanan thanang. ");
INSERT INTO wim_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Nil puth Jesus.ana maꞌ-yotam aak enyanakan iiy-iiy, aak pam wanch keꞌanangan, aꞌ angman meeꞌ-wuth-wuthanama. ");
INSERT INTO wim_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Anpalaniy-a, nil Jesus.angan wikan waaꞌ-waaꞌ thant pam wanchantan. Pam piꞌan wiy anangan angman nyiin-nyiinin, pam Pharisees anangan-a, aꞌ puth pam piꞌan wik thayanan thaaꞌ-aath-aathinan. Pam inangan-a, aak town nath-nathpalan wampin, Galilee.amana, aꞌ puth Judea.amana, aꞌ puth Jerusalem anpalan. Nil God.angan-a, thayan paththam yump nunang Jesus.ana aꞌ nilana miyalath thanang pam wanch weechanan thanang. ");
INSERT INTO wim_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Anpalan-a, pam koꞌalamang pam kunpwey wampathin nunang, nil pam alpanan pengkarang wun-wunwey, makar yaꞌ yalamantwey. Thanan keꞌ aawuch pekakan kaliythan nunang-a, keꞌ wunpiythan nunang um Jesus.ant-a, ");
INSERT INTO wim_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","puth yaꞌa, puth aak thaaꞌ thupam ngath, pam wanch yot a! Thanan wanttak ngoonchathiythan nungant Jesus.antana? Aꞌ puth than aawuch keny matathin nunang roofak, aꞌ roof wiyan thapathin aꞌ than pam alpanan pengkarangan ukathin nunang, pam wanch yotantang thinth, than Jesus.antang thinthan than-thanin. ");
INSERT INTO wim_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Nil Jesus.angan thath nunang-a, nil kan meeꞌmiy thanang pam koꞌalam ananganiya kan-kanam ngaantam-ngeeyin nunang nil ngul miyalathow nunang pam alpanan aꞌ nil thaw pam alpan alantan, “Ayyang, ngurp ngatharam-ang, way nintan yump-yumpan-a, an yaꞌ-ngul, ngay keꞌ-ngul ngaantam-ngeeyāng thanang, yaꞌa!” ");
INSERT INTO wim_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Aꞌ anpalana than pam piꞌan Pharisees anangan-a, aꞌ than pam anangan wik thayanan thaaꞌ-aath-aathinan-a, than kan-ngul ngaantam-ngeeyin thanttakaman, “Nil inan Jesus.an wanttaka? Nil keꞌ God.an waaꞌ-waaꞌan nungantakama! Nil God thonakaman ep thawiy ngampar nil keꞌ-ngul ngaantam-ngeeyow way ngampan yump-yumpanampa, pam wiyan keꞌ thawiythana, nilan epa!” ");
INSERT INTO wim_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Nil puth Jesus.angan kanam thiich thanang than want-wanttakan ngaantam-ngeeyina thanttakaman. Nil puth thaw thant, “Niiy ngul ngeenak ngaantam-ngeeyaniy yimanangana? ");
INSERT INTO wim_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ayyang, in ngeeyāna! Ngay nyiingkan yimanangan thawang pam alpan alantan, ‘Ngay keꞌ-ngul ngaantam-ngeeyāng way nintan yump-yumpana.’ Yaa, niiy wanttak ngaantam-ngeeyaniya? An work piꞌan paththam ey? Nath yaꞌa, nath work many way-wayang, engkanang ey? Ngay nath wik yimanangan thawing alpan alantana, ‘Kan eka! Pengkar nungkaraman maayāna! aꞌ iiyān ngul aak nungkaramakan.’ An work piꞌan paththam ey? Nath yaꞌa, nath work many way-wayang engkanang ey? ");
INSERT INTO wim_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Yaa, ngay in kan meenathāng niiyant nil God.angan kuch ngayang, yipam ngay thawāng thant pam wanchant, ‘Ngay keꞌ-ngul ngaantam-ngeeyāng way niiyan yump-yumpan.’ Ngay puth pam inman nil God.angan kuch.” Anpalana, nil Jesus.an thaw pam alpan alantan, “Ngay inan thawāng nungka, kan ekāna aꞌ yuk pengkar nungkaram nanan maayāna, aꞌ kan-ngul iiyān aak nungkaramaka!” ");
INSERT INTO wim_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Aꞌ nil pamana erkam paththam ek, meeꞌ yotantangan, aꞌ pengkara nungantaman nilan wun-wun-a, wow maay, aꞌ thaꞌang iiy-iiy ngul aak nungantamakan. Nil iiy-iiy-a, nil God.an tham thaaꞌ-kuump-kuump nunang. ");
INSERT INTO wim_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Than pam wanch yot anangan ngangk ikin thathinan nunang, than winynyang paththam moꞌin. Aꞌ than God.an thaaꞌ-kuump-kuumpin nunang, aꞌ thawin, “Ngamp nyiingk inan work min paththam thathampa nunang nilan yump.” ");
INSERT INTO wim_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Amanamaniya, nil Jesus.ang want thanang, aꞌ nil kan-ngul iiy. Aꞌ nil pam namp Levi anan thath nunang, pam nilaniy wukalan yal-yalmath Government.antan, nilaniya, office.ang nyiin-nyiin. Nil Jesus.ana ang wamp nungant aꞌ thawant, “Awey, nint ngayang monkan-wakāna.” ");
INSERT INTO wim_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Aꞌ nil Levi.ana erkam paththam ek, aꞌ aakan too want, aꞌ monkan-wak nunang ngul Jesus.an. ");
INSERT INTO wim_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ngul-ngulana, nil Levi.angana may piꞌan yump nungant Jesus.antan angman aawuch nungantamang. Nil pam wanch wiy anangan thamp ump thanang may piꞌanakan. Ngurp nungantam Jesus.antam-a, aꞌ putha pam wiy anangan keꞌ Levi yimanangana wukalan yal-yalmathina Government.anta, puth wiy anangan thamp yot wampin. ");
INSERT INTO wim_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Aꞌ than pam churchakan Pharisees al-alangan thathin nunang Jesus.an nyiin-nyiin thanttangan, pam al-alantangan. Aꞌ than Pharisees aꞌ pam piꞌan wiy anangan than wik thayanan thaaꞌ-aath-aathin-a, thanan mepin thanang ngurp Jesus.antam anangan, “Niiy ngul ngeenak may mungkaniy pam al-alantangan wukal taxesan yal-yalmathantan-a, aꞌ putha pam wanch way al-alantangan e?” ");
INSERT INTO wim_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Nil Jesus.angan ngeey thanangan-a, nilan thaw thant, “Than pam wanch keꞌaman weechan thanang-a, an keꞌam iiyantan nooyanantana yaꞌa. Pam wanch weechanan-a, an ep iiyantan nooyanantan. ");
INSERT INTO wim_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","An ngayan yimanangana. Ngay keꞌam wampanga yipam pam wanch anangan umpāng thanang than minan waaꞌwuntan, yaꞌa. Ngayan ep wampanga yipam pam wanch way anangan umpāng thanang thanan yipam ngayang monkan-wakayn.” ");
INSERT INTO wim_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Aꞌ than pam wanch wiy anangan thawin nungant Jesus.antan, “Than ngurp John.antamana aꞌ ngurp nganttam anangan than maꞌ-yotam may keꞌ mungkantan aꞌ than maꞌ-yotaman meeꞌ-muth-wuthanamantan. Puth ngurp nungkaram nanangan-a, an than kaangk may anman mungk-mungkayna.” ");
INSERT INTO wim_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Nil puth Jesus.an thaw thant, “Niiy kan wik kath in ngeeyāna! Pul pam wanch nath ngentwiypul-a, thanan nath may piꞌan yumpayn wedding party aakanakan. Niiy ngul thawin thant ey? pam wanch kampan pulantam anangan keꞌan may mungkayn ey? an yaꞌa, nil pam kompan wanchan ngentow-a, nil angman thintham iiy-iiyow thanttang, aꞌ thananiya may karpam mungkayn. ");
INSERT INTO wim_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Puth aakan ngul wampowa than pam wiyangan pam kompan nath kalayn nunang aak thonaka, kampan nungantam al-alangan keꞌ-ngul thathayn nunang. Puth aak an-aniyangan-a, than may thanttaman too ngul wantayn.” Nil Jesus.an wik inangan thaw-a, nil nungantakaman waaꞌ aꞌ putha ngurp nungantam anangan ngaantam-ngeey. ");
INSERT INTO wim_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Nil inan ngul wik kath waaꞌ thant, “Nil wanchang kulich kath ikanam piꞌ-piꞌiywey-a, an ngul nilan kulich nyiingkanam manyama ikathiy ey? Puth kulich kathang ikanam angan wakiywey ey? An yaꞌa. Nil ngook min manyaman ikathiywey-a, aꞌ angan wakiy ngula kulich wayang pechang anganiy-a, ngook nyiingkanamana yalamiya kenyama.” ");
INSERT INTO wim_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Anpalaniya nil Jesus.angan wik kath thon ngul waaꞌ thant, wik kath minh peꞌan sheepantaman puth aak thant yimanangan wunana than wine yeech-yeechin minh peꞌan sheepantamang, keꞌ ngaꞌalangk wun yimanangan. Aꞌ nil Jesus.an thaw ngul, “Than pamangan wine nyiingkanaman peꞌan kath al-alantangan keꞌam yeechantan. Nil peꞌan kathang angman yeechiywey-a, puth peꞌanan ikiy aꞌ wine.an yaꞌ-ngul wuniy, peꞌanan way paththam ngul wuniy. ");
INSERT INTO wim_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Nil pamangan wine nyiingkanaman peꞌan nyiingkanamang yeechow, yipam minam wunow wine.aniy.” ");
INSERT INTO wim_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Amanamaniya nil Jesus.ana thaw thant, “Nil pamang wine keenkanamwey mungkan-a, yaa, nilana wine nyiingkan yumpin kaangk keꞌ-ngul mungkow an puth min yaꞌa. Nil pam anman thawana, ‘Wine keenkanamana an ep min paththama. Wine nyiingkanamana ngay kaangk keꞌ mungkānga!’” Nil Jesus.angan wik kath inangan waaꞌ-waaꞌ-a, nil nungantakaman waaꞌ keꞌ ngook nyiingkanam aꞌ puth wine nyiingkanaman. ");
INSERT INTO wim_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Anpalaniy-a, nil Jesus.an-a, puth ngurp nungantam anangan than woyan wakin, aak may wheatan kaampin. Aak ananiy Saturday wun, aak ngench thayan thant Jews.antama. Aak thanttam yimanangan wuna, than aak Saturday.ana, work keꞌam iiy-iiyin, yaꞌa. Puth than ngurp nungantam Jesus.antam al-alangana may wheat thuthin, aꞌ maꞌang namp-nampin mungkanakan. ");
INSERT INTO wim_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Than pam Pharisees al-alangan thathinan thanang aꞌ thawin thant, “Ayyang, niiy may wheatan ngeenak thuth-thuthaniy e? Aak in Saturdaya! Aak ngamparan ngench thayan wunana! Niiy wik ngench thayanan pip-pipaniy ey?” ");
INSERT INTO wim_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Nil Jesus.an thaw thant, “Niiy ngul wik inan keꞌam ngeeyan ey? Nil David.an aꞌ pam nungantam anangan meechan wun-wunin ey? ");
INSERT INTO wim_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Nil David.an aawuch ngench thayanak iiy, aawuch God.antamak, aꞌ angan ngoonch aꞌ may bread ngench thayanan maay, thanana mungkin ngul. In wik thayan ngamparamana yimanangan wunan thanam thonakama priests al-alangan may bread ngench thayanan mungkayna. Puth nungkway than wik ngench thayanan pipin-a, an than David weeꞌanang al-alangan ep mungkin.” ");
INSERT INTO wim_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Aꞌ nil Jesus.an thaw thant ngul, “Puth ngayana, pam inmana nil God.angan kuch ngayang niiyantana, ngayam thonakam ep thawānga than pam wanch want-wanttakan iiyayn aak Saturday.ana, puth ngay inana moom piꞌan niiyantama, Saturday.akan thampa.” ");
INSERT INTO wim_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Saturday thon ngulan-a, nil Jesus.an aak church Jews.antamakan iiy, aꞌ thaaꞌ-aath-aath thanang pam wanch anangan. Nil aak angmana nil pam inan maꞌ mal nungantaman-a, makar yaꞌ yalam nungant, nil angman nyiin-nyiin. ");
INSERT INTO wim_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Pam piꞌan wiy anangan angman nyiin-nyiinin, pam Pharisees anangan aꞌ puth pam anangan wik thayanan thaaꞌ-aath-aathinan. Than thath-thathin nunang Jesus.an nil nath paman maꞌ min yumpowa, nath yaꞌa, puth aak anan Saturday.an, aak ngench thayan wun thanta. Thanana meeꞌangam kalin nunang, than puth kaangk wik aak-yaꞌangan waaꞌ-waaꞌayn nunang wiyantan. ");
INSERT INTO wim_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Nil puth Jesus.angan kan meeꞌmiy thanang than wanttakan ngaantam-ngeeyin kuchek thanttamangan, nil puth thaw pam alantan, “Nint meeꞌ yotantangan ingan thanāna.” Nil paman wur eka, aꞌ angman than. ");
INSERT INTO wim_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Anpalan-a, nil thaw thant pam wanch al-alantan than churchangan nyiin-nyiinin, “Ayyang, niiyalang, kan niiy in ngeeyāna, nil wik thayan ngamparaman wanttak thawan e? An ngul kan ey? Ngamp ngul min anman kaangk iiyāmp thant pam wanchantan aak Saturday.angan ey? Ngamp nath kaangk pam wanch anangan kaaꞌ-piichanathāmp thanangwey ey? Yaꞌ nathwey-a, ngamp kaangk nath wayathāmp thanang ey?” Puth thanan angman ngul nyiin-nyiinin popam. ");
INSERT INTO wim_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Nil Jesus.angan pal-puy thath-thath thanang. Anpalana, nil pam alantan thaw ngul, “Ayyang, nint maꞌan ongkarathāna!” Nil puth pam alangana maꞌan ongkarath, aꞌ maꞌan minam ngul wun nungantweya. ");
INSERT INTO wim_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Man kul paththam wamp thant pam piꞌan al-alantan, aꞌ than kan-ngul wik thaw-thawin thanttakaman than wanttak nathan yumpayn nungant Jesus.antan. ");
INSERT INTO wim_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Amanamaniya nil Jesus.angan want thanang aꞌ nil iiy ngul pokkapang aꞌ yoykang mat nil yipam meeꞌ-wuthanamow nungant God.antan. Nil Jesus.an meeꞌ-wuth-wuthanam ngut ongk, aakam paanth nungant. ");
INSERT INTO wim_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ngaaꞌ thon ngulana kinch kanan mat-a, nil ump thanang pam ngurp nungantam yot anangan wampayn nungant. Than kanan wampin nungant-a, nil Jesus.angan pam al-alantamana pam twelve thonakam miꞌ thanang nungantangan iiy-iiyayn. Aꞌ nilana apostles waaꞌ thanang nil puth ngulan kuchow thanang work nungantan iiy-iiyayn ngula aꞌ wik min nungantaman waaꞌ-waaꞌayn thant pam wanchantan. Pamiya namp inangan miꞌ thananga: ");
INSERT INTO wim_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simona (ngul-ngulana Jesus.angan namp thon ngulan theeꞌ nunganta, Peter), putha kuunch nungantam Andrew, putha James-a, John-a, aꞌ putha Philip-a, aꞌ Bartholomew, ");
INSERT INTO wim_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","putha Matthew-a, thoniya Thomasa, aꞌ putha James-a, nhengk nungantam Alphaeus.antama, aꞌ putha Simona thanan waaꞌ-waaꞌin nunang Patriota, nil puth aak nungantamakana kaangk wun paththama, ");
INSERT INTO wim_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","putha Judas-a, nhengk nungantam James.antama, aꞌ putha Judas Iscariota. Nil pam ilangaman ngulan maꞌaman theeꞌow nunangan Jesus.an pam soldiers al-alantan mulathaynan nunangana. ");
INSERT INTO wim_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Than Jesus weeꞌanangan yoykaman kanan ukin-a, nil aak pampang than-than ngurp nungantam yot-yotam al-alantangan. Pam wanch thaaꞌ-wantanam angman thamp — than pam wanch aak Judea.amana, aꞌ aak Jerusalem anpalana aꞌ puth aak towns Tyre aꞌ Sidon anpalan, aak kucham inangan thomp thinth. ");
INSERT INTO wim_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Than wampin yipam ngeeyayn nunang wikan waaꞌ-waaꞌow aꞌ nil yipam miyalathow thanang pam wanch anangan weechanan thanang. Than wiy anangan wampinan-a, oony way piꞌ-piꞌin ngangkangan, aꞌ nil Jesus.angan miyalath thanang thamp. ");
INSERT INTO wim_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Than yotamangan keꞌ mamiythan nunang than yipam miyal wunayn. Nil Jesus.an kan-kanam thayan paththam, nil keꞌ-paal maꞌmangkam anangan miyalath thanang. ");
INSERT INTO wim_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Nil Jesus.angan thath-thath thanang ngurp nungantam anangan, aꞌ thaw thant, “Niiy wiy inanganiya wukal keꞌanangan iiy-iiyaniya. Yaa, an puth niiyaniya ngangk minangam ngul iiy-iiyānweya, nil puth God.angan ngul min-minam piꞌ-piꞌow niiyang, maꞌ nungantangana. ");
INSERT INTO wim_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Niiy wiyiya meech wun-wunaniya, may keꞌanangan. Yaa, an puth niiyaniya ngangk minangam ngul iiy-iiyāna, nil puth God.angan may ngul theeꞌ-theeꞌow niiyant. Niiy wiyiya ngangk way anman iiy-iiyaniya, peey-peeyaniya. Yaa, niiy ngulan ngangk minangam iiy-iiyāna, thaaꞌ-thengkanang iiy-iiyāna. ");
INSERT INTO wim_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Wiyiya, pam wanch wiyangan ngangk-way-wayangam kalantan niiyang, man-mangkam theeꞌantan niiyant, thaaꞌ-thengkathantan niiyang, aꞌ aak-yaꞌang waaꞌantan niiyang, ngeenama? puth ngatharam peyanang, ngay puth wuny niiyantaman niiy ngayangan monkan-wak-wakaniy. Yaa, niiyana ngangk minangam ngul iiy-iiyāna. ");
INSERT INTO wim_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Puth nungkway than way-way yumpiythan niiyant-a, niiy ngangk minangam iiy-iiyāna, aꞌ thengkanam keeꞌ-keeꞌāna. Aꞌ ngulana, nil God.angan aak nungantamak kalow niiyang, aꞌ way min min-miniy an kenyan nilan piꞌ-piꞌana, an niiy ngul uwān nungantamana. Aak keenkana kampan thanttamangan yimanang kuyam wayim yumpin thant, pam prophets al-alantan. ");
INSERT INTO wim_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Niiy wiy inanganiya maꞌmangkiy iiy-iiyaniya, wukal aꞌ way min yotam thamp piꞌ-piꞌaniya, niiy work keꞌanang nyiin-nyiinaniya. Kan in ngeeyāna! Way paththam ngul wampow niiyanta! ");
INSERT INTO wim_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Niiy wiyiya may yot tham piꞌ-piꞌaniya, niiy thip oth anman iiy-iiyaniya. Kan in ngeeyāna! Way paththam ngul wampow niiyanta! Niiy meech ngul iiyana! Niiy wiyiya, thengkan anman keeꞌ-keeꞌaniya! Kan in ngeeyāna! Way paththam ngul wampow niiyanta! Niiy ngangk way ngul iiyan, aꞌ puth peey-peeyan. ");
INSERT INTO wim_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Niiy wiyiy-a, pam wanch yotangan thaaꞌ-kuump-kuumpantan niiyang; puth in min yaꞌa, way paththam ngul wampow niiyanta. Aak keenkanamana than pam wanch yotangan thaaꞌ-kuump-kuumpin thanang pam way anangan thanan waaꞌwin keꞌ wik God.antaman thaaꞌ-aath-aathin, puth yaꞌa, an than yaan muuk-muukamin. ");
INSERT INTO wim_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Niiy weeꞌ-weeꞌanangan kaangk ngeeyān ngayang-a, wik inangan ngeeyāna: than weeꞌ-weeꞌananga ngangk-wayangaman kalantan niiyang-a, niiyaniya ngangk minangam iiyān thant, anmana. Than nath kul uwiythan niiyant-a, niiy min iiyān thant, ");
INSERT INTO wim_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","than weeꞌ-weeꞌanang nathwey konchayn niiyang-a, niiyaniya koyam keꞌ konchān thanang, wik min anman thawān thant; than weeꞌ-weeꞌanangan nath way yumpiythan niiyant-a, an niiy meeꞌ-wuthanamān thant. ");
INSERT INTO wim_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Nil weeꞌang nathwey piikow niiyang-a, niiy puthangkan keꞌ piikān nunang, nil puthaman mak piikow niiyang. Nil weeꞌangan nath coat niiyantaman maayiywey-a, niiy kul keꞌ thawān nungant, puth shirt thamp theeꞌān nungant paththama. ");
INSERT INTO wim_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Nil pamwey nath thawiy niiyant mayak thakwey-a, yuk way minakwey-a, niiyiya keꞌ weekāna, theeꞌān nungant. Aꞌ puth nil pamang nath yuk way min niiyantaman nath maayiywey-a, yaa, kana, keꞌ thawān nungant palaman kalow niiyant. ");
INSERT INTO wim_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Keꞌ niiyan kaangk pam wanch wiyangan min iiyayn niiyant-a, niiy yimanangan min iiyān thant. ");
INSERT INTO wim_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Niiy nathwey kaangk wunaniy thonakamana pam wanch al-alantan kaangkan wuntan niiyantana. Ngul nil piip God.an ngangk min wunow niiyantam anpalan ey? An yaꞌa! Pam wanch way al-alangan ngurp thanttamakan aꞌ kampan thanttamakan kaangk wuntan thant. Puth niiyiya pam wanch yotaman kaangk wunān thanta! ");
INSERT INTO wim_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Niiy nathwey min iiyaniy thonakamana pam wanch al-alantan niiyantan min iiyantana. Ngul nil piip God.an ngangk min wunow niiyantam anpalan ey? An yaꞌa! Puth pam wanch wayanang anangan ep min iiy-iiyantan wiy al-alantan thanta than minan iiy-iiyantan thantana. Niiyiy-a, yotamant min iiyāna! ");
INSERT INTO wim_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Niiy nathwey wukal thakan theeꞌin thonakama pam wanch al-alantan niiy meeꞌmiy thanang thampana thanana koyam ngul theeꞌayn niiyant. Ngul nil piip God.an ngangk min wunow niiyantam anpalan ey? An yaꞌa! Puth pam wanch way al-alangan maꞌ-aathwuntana! Niiyiy-a, yotamant theeꞌāna! ");
INSERT INTO wim_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Niiy in ngeeyāna! Niiy ngangk minangam iiyān thant than weeꞌ-weeꞌanangan ngangk-wayangaman kalantan niiyang, aꞌ minam iiyān thant; than nath wukalakwey aꞌ mayak thakanweya thawiythan niiyantan-a, niiy ngangk minangam theeꞌān thanta, aꞌ keꞌ ngaantam-ngeeyān niiyantakaman than nathwey koyaman theeꞌiythan niiyant, nath yaꞌa. Niiy nath min yimanangan iiyin-a, nil piip God.angan puthangkan min-minam paththam iiyow niiyant, aꞌ nil puk nhengk nungantaman ngul waaꞌow niiyang, nil God ngamparam piꞌan paththam alangaman. Nilaniy-a, minam iiy-iiyan thant pam wanch way al-alantan, aꞌ pam wanch than keꞌan thankyou.an thaw-thawantan nungant. ");
INSERT INTO wim_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Niiyiya pam wanch ngangk mamān thanang keꞌ nil piip God.angan ngangk maman niiyang. ");
INSERT INTO wim_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Niiy keꞌ waaꞌ-waaꞌān thanang pam wanch anangan, aꞌ anpalana nil God.angan keꞌ yipam niiyangan waaꞌ-waaꞌow. Niiy keꞌ maꞌ weechān thanang, aꞌ anpalana, nil God.angan keꞌ yipam niiyangan maꞌ weechow. Than wiyangan nath way yumpiythan niiyantwey-a, niiy keꞌ-ngul ngaantam-ngeeyān way thanttam anpalan; aꞌ anpalana nil God.angan keꞌ-ngul ngaantam-ngeeyow way niiyan yump-yumpan. ");
INSERT INTO wim_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Niiy yuk way min thakan theeꞌ-theeꞌān thant pam wanchantan, aꞌ anpalana, nil God.angan puthangkan niiyant ngul murkanim anman theeꞌ-theeꞌow niiyant. Niiy nath ngangk minangam theeꞌ-theeꞌān thant wiyantan-a, an nil God.angan ngangk minangam paththam theeꞌ-theeꞌow niiyant. Niiy nath manya pattakam theeꞌ-theeꞌin thantwey-a, an nil God.angan manya pattakam theeꞌ-theeꞌow niiyant thama.” ");
INSERT INTO wim_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Aꞌ anpalana nil Jesus.angan wik kath inan waaꞌ thant, “Pam pulwey kucham koꞌanchwey-a, nil thonamang maꞌ punth mamanang keꞌ wich-wichiy nunang pam koꞌanch thonaniy, puth pulaniy karpam awarang keekiypula. ");
INSERT INTO wim_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Aꞌ ngay in thampan waaꞌāng niiyant; pam teacherana pam piꞌan iiy-iiyana; puth pam nungantam anangana nilan piꞌ-piꞌan maꞌ nungantangana, pam anangan thananiy-a, piꞌan yaꞌa; puth than course.an minchathaynan-a, an than ep ngul keꞌ teacher thanttam yimanangan ngul iiyayn, than meeꞌmiy ngul weenayn. ");
INSERT INTO wim_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Niiy pam wanch ngeenak waaꞌaniy thananga? puth niiy keꞌam ngaantam-ngeeyaniy niiyantakam way niiyan iiy-iiyaniy ey? Niiy ngeenak kampan niiyantaman thathaniy nunang keꞌ meeꞌ wooka manyan piꞌ-piꞌan meeꞌ nungantamangana? Puth niiyaniya epa keꞌ yuk piꞌan paththam piꞌ-piꞌaniy meeꞌ niiyantamangan, niiy puth keꞌam thathan. ");
INSERT INTO wim_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Niiy puth want-wanttak thawin kampan niiyantamant, ‘Nint nan meeꞌ wook thamp iiy-iiyangana, kan nint pal iiya! Ngay wookan wichāng meeꞌ nungkaram nanpalan.’ In ngeeyāna: an waya! Niiy kaꞌathamana yuk piꞌan wichān meeꞌ niiyantam nanpalan. Yaa, niiy minam ngul thathān yipam wookan wichān meeꞌ nungantam nanpalan.” ");
INSERT INTO wim_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Nil Jesus.angan wik inan thaw thant thamp, “Nil yuk minwey thanan-a, an may way keꞌ kaliy, yaꞌa, an may min anman kalan. Puth yuk thoniya kan-ngul nathwey kathaman-a, may min keꞌ-ngul emiy yukang angan yaꞌa, an may way thonakam ep kalan. ");
INSERT INTO wim_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ngamp may menchan yukangwey thathimp-a, yaa, ngampaniya puth meeꞌmiy yukan nath mina, nath yaꞌa. Ngamp may kom keꞌ thuthimp yuk waakam anpalana; aꞌ puth ngamp may kaangk anangan keꞌ thuthimp yuk keekachthiy anpalana. ");
INSERT INTO wim_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Pam minan iiy-iiyan-a, nilaniy wik min ngangkangan piꞌ-piꞌan, puth nilaniya wik minan thaw-thawan putha min yump-yumpan. Pam wayan iiy-iiyan-a, nilaniya wik way ngangkangan piꞌ-piꞌan, puth nilaniya wik way thak thaw-thawan, putha way yump-yumpan thampa. Ngamp wik ngeen nathan piꞌ-piꞌanamp ngangkanganiy-a, wik ananganiya thaaꞌaman ngul pentow ngampar. ");
INSERT INTO wim_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Niiy ngeenak thawaniy ngathar, ‘Lord-ang! Lord-ang!’ puth niiy kaangk keꞌ wik ngeeyān ngayang! ");
INSERT INTO wim_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nil weeꞌ-nath wampow ngathar-a, aꞌ wik ngatharaman ngeey-ngeeyow-a, an ngay ngul meenathāng niiyant nil pam wanttakan iiyana. ");
INSERT INTO wim_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Niliya keꞌ pamangan aawuchan kaachan. Nil kaꞌathamana pek kech weꞌ-weꞌan aꞌ aak minang thayanang aawuchan kaach. Aꞌ anpalana ngak kaap wuut piꞌan ngulan wampana, aꞌ ngak yeeꞌ piꞌanan uk-ukana, aawuchan ngakangan maayan, puth aawuchana keꞌam keek yaꞌa, anman thayanam than-than nil puth pam alangan aawuch nungantaman aak minang thayanang kaach. ");
INSERT INTO wim_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Puth nil weeꞌangan wik min ngatharaman keꞌan ngeey-ngeeyow-a, an niliya keꞌ pam thon alangan aawuch aak wayangan kaacha, chil michang, aak thayanang yaꞌa. Ngul-ngulana, ngak kaap wuut piꞌan ngulan wamp-wamp, aꞌ ngak yeeꞌ piꞌan ngulan uk-uk, aakan ngakang yaꞌ maay, an puth aawuch nungantamana yaam keꞌam than, yaꞌa, erkam keek, muutathiy keek, pum!!! — nhanth thuthanakam keek.” ");
INSERT INTO wim_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Nil Jesus.ang kanan waaꞌ-waaꞌ thant pam wanchantan-a, nilan iiy ngul aak namp Capernaum.aka. ");
INSERT INTO wim_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","3","Nil pam aak angman wun, nil moom iiy-iiy thant Roman soldiers al-alantan, aꞌ nil pam piꞌ-piꞌ thanang work maꞌ nungantangan iiy-iiyin. Pam thonaman-a, nilwey weechan, pam anmana nilan kaangk paththam wunantwey. Nilaniya ngangk way-wayam wun-wun ngula mulaka. Nil pam moom alangan wik thooꞌ ngeey Jesus.antama anpalan iiy-iiy woyan wakanangan aꞌ nilan pam wuut manth-thayan Jews.antam kuch thanang thanan yipam Jesus.ant thawayn nil pam nungantaman miyalathowanweya. ");
INSERT INTO wim_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Than kanan wampin Jesus.antan-a, thanana thaaꞌ-mamanang thawin nungant, “Nint nath ep-paththam maꞌ-aathin nunangwey pam alpan anana. Moom nungantam pam mina. ");
INSERT INTO wim_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Nil kaangk ngampar Jews.antama, aꞌ putha nil wukal theeꞌ pam wiy al-alantan churchan yipam yumpayn ngampar.” ");
INSERT INTO wim_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Nil puth Jesus.an iiy ngul thanttangan. Nil aak thinth ngulan wamp-a, nil moom alangan wik kuch nungant Jesus.ant, thanttang ngurp nungantam al-alantangan. Thanan thawin nungant, “Ayyang, moom-ang, nil moom pam soldiers al-alantaman thaw ngant wik inangan waaꞌān nungk, ‘Nint thinth pal keꞌ wampāna, aawuch ngatharamangana pal keꞌ ngoonchān, ");
INSERT INTO wim_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ngay puth pam min keꞌ nint yimanangan yaꞌa, ngay ngul-nyaaꞌ ngatharakaman wunangweya puth namanamana ngay keꞌ penting nungkara. Nint puth wik thonakaman thawāna, aꞌ nil pamana koyam ngul miyal weenow. ");
INSERT INTO wim_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ngay yimananga moom piꞌanant work iiy-iiyangan. Work ngeenan theeꞌan ngathara yumpāngan-a, aniy-a, ngay yumpanga. Aꞌ ngay moom yimanangana keꞌ nint yimanangan iiy-iiyangan, ngay puth soldiers piꞌ-piꞌang thanang. Ngaywey thawing pam thonamanta, “Nint iiyāna,” an nilan iiyan paththam. Ngaywey thawing pam thon alantan, “Nint pal iiyāna,” nil putha pal erkam iiyan ngathar. Ngaywey thawing pam thonamant, “Nint in yumpāna,” aꞌ nil yumpan.’” ");
INSERT INTO wim_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ngul nil Jesus.angan wik inangan ngeeyan-a, nilana thaaꞌam ik aꞌ weent ngul thant pam wanch yotantan nunangan monkan-wak-wakin, aꞌ thaw thant, “Ngay inan waaꞌang niiyanta, pam ngay yimanangan keꞌam ngeeyanga keꞌ pam inana. Nil ngayang kan-kanam ngangkang piꞌ-piꞌ ngayanga. Aak umyompanam aak Israel.ang ngay yimanang keꞌam ngeeyang keꞌ pam inana.” ");
INSERT INTO wim_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Anpalana, than ngurp nungantam moom soldiers al-alantaman koyam iiyin aꞌ pek aawuchang ngoonchin. Aꞌ than pamana workan iiy-iiy moom alantan-a, thathin nunang minam ngul ween. ");
INSERT INTO wim_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Amanamaniya nil Jesus.ana kan-ngul iiy aak namp Nain aakanakan. Pam ngurp nungantam twelve anangana putha pam wanch yot tham nungantang iiy-iiyin. ");
INSERT INTO wim_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Nil Jesus.an kanan wamp thaaꞌ gate piꞌan thinth ngulan-a, nil pam wiy thath thanang pam mul pengkarang kal-kalin. Pam wanch yot koy-koyyuw iiy-iiyin thanttangan, monkan-wakin thanang. Thananiya keꞌ ngul kaampiythan nunang, pam mulan. Niliya pam komp puk kaaꞌ-thonam wukalongk alantaman. Nil kaath nungantamana peey-peey anman. ");
INSERT INTO wim_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Nil Jesus.angan thath nunangan-a, nil paththam ngangk maman aꞌ thaw nungant, “Nint keꞌ peeyāna!” ");
INSERT INTO wim_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Aꞌ nil Jesus.ana iiy, aꞌ yuk pengkaran maꞌang mam. Than pam anangan yuk pengkaran kal-kalin-a, thanan popam thanin. Nil Jesus.an thaw pam mul alantan, “Pam komp-ang, ngay inan thawang nungk, ‘Ek a!’” ");
INSERT INTO wim_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Aꞌ amanamaniya pam mulan-a, wur paththam ek, man-yetham koyam ngul nyiin. Aꞌ wik ngul thaw-thaw thant. Nil Jesus.an kaath-kunchantan thaw, “Puk nungkaram in koyam kan eka.” ");
INSERT INTO wim_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Than pam wanch yotangan inan thathin-a, thananiya ngangk ikin, aꞌ kan-ngul paththam thaaꞌ-kuump-kuumpin nunang God.an, thanan thawina, “Nil Jesus inaniy pam piꞌan wamp ngampar God.antama, nil inaniy wampa pam wanch nungantam kaaꞌ-piichanathow thanang.” ");
INSERT INTO wim_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Aꞌ wik thooꞌ weꞌarathin Jesus.antamana aak nath-nathan wunin, aak piꞌan Judea.ang thakan. ");
INSERT INTO wim_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Anpalana, nil pam John.ana, nilana pam wanch kootra kuungk-kuungk thanang ngakangan-a, nilaniya wik thooꞌ ngeey work wuut piꞌan Jesus Christ.angan yump-yump. Ngurp nungantam al-alangan waaꞌ-waaꞌin nungant. Aꞌ nil pam ngurp kucham nungantam anangan ump pulang, ");
INSERT INTO wim_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","aꞌ kuch pulang Jesus.antan yipam engkowpul nungant, “Ayyang, nint kan waaꞌān nganta! Nint pam anan ey? Nil John.angan waaꞌ-waaꞌ ngant ey? nint wampānan ey? Nint nath yaꞌa! Ngan nath pam thon alantan kuup-kuupanan nungant ey?” ");
INSERT INTO wim_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Pul wamppul-a, pul engkpul nungant, “Ayyang, nil John.angan kuch nganang yipam engkān nungka, nint pam anan ey? nilan waaꞌ-waaꞌ ngant ey? nint wampānan ey? Nint nath yaꞌa! Ngan nath pam thon alantan kuup-kuupanan nungant ey?” ");
INSERT INTO wim_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Aak an-aniyangan-a, nil Jesus.angan pam wanch yot anangan miyalath thanang weechanan thanang, aꞌ nil oony way anangan kenth thanang pam wanch wiy al-alantaman; aꞌ nil meeꞌ min yump thanang pam wanch yot anangan kaꞌathaman meeꞌ koꞌanchan iiy-iiyin. ");
INSERT INTO wim_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Puth nil Jesus.an thaw thant, “Niiy koyam iiyāna, aꞌ waaꞌān nungant John.antana niiy puth meeꞌ niiyantamang thath-thathana, putha kon niiyantamang ngeey-ngeeyana: pam wanch meeꞌ koꞌanch anangana koyam meeꞌ min iiy-iiyantan; pam wanch kunpan wunin-a, minam ngul iiy-iiyantan; pam wanch peꞌan wenchathiyan-a, kempana min ngul ween thant; pam wanch kon wal weenthan iiy-iiyin-a, an yaꞌ-ngul, puth kon minangam ngul ngeey-ngeeyantan; pam wanch uth-uthaminan-a, an koyam ngul man-yetham weenin, ngay mulaman ekathang thanang; aꞌ puth ngayana wik min piip God.antam anangan waaꞌ-waaꞌang thant al-alantan, pam wanch wukal keꞌanangan-a, pam wanch kaangk-keꞌanangan-a, puth pam wanch ngangk way thampan iiy-iiyantanweya. ");
INSERT INTO wim_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Aꞌ niiy inan thamp waaꞌān nungant John.antan, ‘Than weeꞌ-weeꞌananganweya kan-kanamana ngaantam-ngeeyantan ngayang nil piip God.angan kuch ngayangan-a, putha keꞌan muukamantan-a, an thananiy-a, ngangk minangam anman iiy-iiyantan.’” ");
INSERT INTO wim_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Aꞌ than ngurp John.antam anangana koyam kan-ngul iiyin. Than aak anana kanan want-wantin-a, nil Jesus.an kan-ngul thaw thant pam wanch yotam al-alantan, John.an waaꞌ nunang, “Niiy kaꞌathaman John.antan iiy-iiyana aak pintalangan-a, ngul niiy keꞌ wanttak thathin nunang pam nananiya? Niiyan ngaantam-ngeeyan nil keꞌ wak wuth yimanangan ey? wuntangan penyan thanang palam-puyaman ey? Yaꞌ ey! Nil pam mich yaꞌa! ");
INSERT INTO wim_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Niiy nath ngaantam-ngeeyaniy nil keꞌ ngook min paththam ngoonch-ngoonchan keꞌ pam maꞌmangkiyang yimanangan ey? — an yaꞌa, ngook min thak keꞌam ngoonch-ngoonchana! Puth than pam wanch ngook min paththaman ngoonchantan-a, aꞌ maꞌmangkiyan iiy-iiyantan-a, an thananiya aawuch minang aꞌ wuut piꞌanang wun-wuntana. Puth nil John.an yimanang yaꞌa. ");
INSERT INTO wim_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","27","Yaa, puth niiyan ngeenak iiyan e? thathan nunanganiy e? Niiyan ngaantam-ngeeyana thathin nunangana keꞌ pam prophet yimanangan ey? wik min God.antaman waaꞌ-waaꞌ ey? Eeꞌa, an nil kan-kanama pam prophet paththama, puth nilaniya pam wiy-wiyama, nil puth piip God.angan work piꞌan anan theeꞌ nungant. Nil piip God.ana wik inangan thaw lat ngench thayanangan, pam inman waaꞌ-waaꞌ nunang, John.an, ‘Ngay pam thonam ngul kuchāng wik thamp, umputhan iiy-iiyow, pam wanchantan wik waaꞌ-waaꞌow pam thon alantaman puy-palan wampowa, thanan yipam minam iiyayn, way thanttamana kan-ngul yipam wantayn.’ Wik God.antaman yimanangan waaꞌ, lat ngench thayanangan. ");
INSERT INTO wim_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ngay niiyant wik inan kan-kanam waaꞌ-waaꞌang; pam John inmana an nil kan-kanam paththam pam wuut piꞌan iiy-iiyan, nil keꞌ pam wanch wiy yimanangan yaꞌa pam wanch nathpalman-a, in-inman keꞌam pam piꞌanan iiy-iiyantan keꞌ nilan pam piꞌan iiy-iiyan. Puth than weeꞌ-weeꞌanangana maꞌ ngatharang anman iiy-iiyayn-a, aꞌ putha wik ngatharaman ngeey-ngeeyaynan-a, nungkway than nath pam many iiy-iiyiythan-a, than pam piꞌan iiy-iiyiythan meeꞌ God.antanga, nil John.aniy-a, an manya.” ");
INSERT INTO wim_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Than pam wanch yotangan ngeeyin nunang; than al-alangan kaꞌathaman woyan way thanttaman wantin aꞌ wik min God.antaman ngeey-ngeeyin ngul, aꞌ nil John.angan kaꞌathaman kootr kuungk-kuungk thanang. Puungk wiy anangan thaniy-a, wukalan yal-yalmathin Government aakanakan, work thanta. ");
INSERT INTO wim_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Puth than pam piꞌan Pharisees anangana aꞌ than pam piꞌan wiy anangan than wik thayanan thaaꞌ-aath-aathinan-a, than kaangk keꞌ woyan min God.antaman wakayn, aꞌ keꞌam thawin John.antan kootra kuungkow thanang. ");
INSERT INTO wim_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Aꞌ nil Jesus.an putham wik thaw thant, “Than ngul pam wanch inangan want-wanttak iiy-iiyantana? Than keꞌ weeꞌ yimanangana? ");
INSERT INTO wim_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Than keꞌ puk manyiya yimanangan keeꞌ-keeꞌantan aak yoon angana store wakananga. Puk manyiy puungk wiyiya wik pechantan thant puk manyiy wiy al-alantan, ‘Ngan keeꞌ-keeꞌanan keꞌ maꞌ wanch thuma, aak path-pathanan pulant, music keeꞌ-keeꞌathanan, puth an yaꞌa, niiy puth nganttangan keꞌ keeꞌin, yaꞌa. Aꞌ puth ngananiya pam keꞌ mul wun keeꞌ-keeꞌanan puth niiyana pal keꞌam iiyan ngant, aꞌ keꞌam peeyan nganttangan, yaꞌa.’ ");
INSERT INTO wim_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Puth inan aak yimanangan wunana: nil pam John ngulan wamp-a, nil puth maꞌ-yotama mayan keꞌam mungk-mungk, aꞌ putha nil ngak wine.ana keꞌam mungk-mungka, yaꞌ anman, puth pam wanch yot anangan thawin, ‘Nilan weenthamana, nil yaakaꞌ oony way ngangkang piꞌ-piꞌana.’ ");
INSERT INTO wim_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Puth ngay ngulan wampang-a, pam inman nil God.angan kuch ngayangan-a, ngayaniya may min anangan mungk-mungkang putha may wine.ana mungkang. Puth than pam wanch yot anangan thawina, ‘Pam inana thathāna! Nilan may-weentha, may yot mungk-mungkana, puth wine thak yot mungk-mungkana. Puth nilaniya ngurp pam wanch way al-alantamana, than wukalana yal-yalmathantan aꞌ putha pam kaangk-keꞌanang iiy-iiyantan.’ ");
INSERT INTO wim_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Thanan yimanangan waaꞌ-waaꞌin ngayangana, puth ngulaniya niiy weeꞌ-weeꞌanangan wik ngatharamana ngangkangan piꞌ-piꞌaniy-a, niiy ngul thathān nil piip God.ana kan-kanam paththam kuchek waap mina.” ");
INSERT INTO wim_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Pam nil Pharisee-a, namp nungantaniya Simon, nilan thaw nungant Jesus.antan, “Nint pal iiyāna may ngatharang mungkāna.” Aꞌ nil Jesus.ana iiy aak nungantamakan aꞌ nyiin ngul mayan mungkow, pam wanch wiy than angman thamp. ");
INSERT INTO wim_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Nil wanch aak town angman wuna, nil wanch way-wayam paththam iiy-iiy. Nil wik ngeey nil Jesus.an aawuch Simon.antangan wampa, aꞌ nilan iiy nungant. Nil ngaꞌalangk maꞌang kal-kal perfume awal min-minam paththam unch-unchan, ");
INSERT INTO wim_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","aꞌ nilan Jesus.antangan thintham than-than, aꞌ nil peey-peey, aꞌ meeꞌ kam nungantamana uk-uk thaꞌ Jesus.antang. Amanamana nil wanchana pungkang thuch aꞌ nil yangan ongk nungantamang thaꞌan eꞌath aꞌ putha thaꞌan piint-piint ngul aꞌ yuk perfume.an thaꞌang yeech nungantang. ");
INSERT INTO wim_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Nil pam Pharisee.angan inan thath-a, nilan ngaantam-ngeey nungantakaman, “Nil pam inan God.antam yaꞌ yaaka. Nilwey kan-kanam God.antaman wampiy-a, nil puth meeꞌmiy wuniy wanch inman way-wayam paththam, aꞌ nilan koyam kuchiy nunang.” ");
INSERT INTO wim_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Aꞌ nil Jesus.an thaw nungant Simon.antan, “Ngay kan in waaꞌāng nungkar.” Nil puth Simon.an thaw nungant, “Eeꞌa, mooma, nint kan waaꞌān ngathara.” ");
INSERT INTO wim_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Aꞌ nil Jesus.angana wik kath kan-ngul waaꞌant, “Pam thonamangan kaangk wukal theeꞌ-theeꞌow pam thon-thonant loanakan. Nil pam thonamanta wukal piꞌan theeꞌ, one hundred dollars, puth pam thon alantana wukal chil many theeꞌant ten dollars thonakama. ");
INSERT INTO wim_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ngul-ngulaniya, pam kucham anangaman pula wukal keꞌanang ngul, pulan puth want-wanttak koyaman wukal theeꞌiypul nungant. Yaa, puth pam alangana ngangk mam pulang aꞌ thaw pulant, ‘Ayyang, nipalang, an kanweya. Ngay keꞌ-ngul thawāng nipar wukal aakanakana yaꞌa.’” Aꞌ Jesus.an thaw, “Ayyang, Simon-ang, nint wanttak ngaantam-ngeeyangan wik kath inaniya? Nil weeꞌ min-minam paththam kaangk wun pam alantan e?” ");
INSERT INTO wim_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Nil Simon.an thaw nungant Jesus.antana, “Ngayan puth ngaantam-ngeeyanga pam anana wukal piꞌan paththaman uw nungantam nil pam thon anan yaꞌa chil-chil kaangk wun pam alantan, puth wukal many uw nungantaman, piꞌan yaꞌa.” Nil puth Jesus.an thaw nungant, “Eeꞌa, nint kan-kanam ngaantam-ngeeyana.” ");
INSERT INTO wim_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Amanamana nil Jesus.ana weent ngul, wanchan thathan, aꞌ Simon.antan thaw, “Nint wanch inan kan thathan nunang ey? Ngay aawuch nungkaramakan wampangan-a, nintan ngak ngathar keꞌam theeꞌana ngayan yipam thaꞌ ngatharakaman punging, puth nilan ep thaꞌ ngatharaman meeꞌ kam nungantamang pung aꞌ yangan ongk nungantam alangaman eꞌatha. ");
INSERT INTO wim_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","46","Nint ngayang keꞌam wal-mant piintan aꞌ putha oil keꞌam yeechan kuchek ngatharamangan nint yipam meenathin nint ngangk minan wunan ngathar, yaꞌa. Puth nil ep wanch ilangan thaꞌ ngatharaman thaaꞌ-thaaꞌ piint-piinta, putha perfume minan yeech thaꞌ ngatharamanga. ");
INSERT INTO wim_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Nilan puth kan-ngul thiich nungantakama nil wayan iiy-iiy, aꞌ puth nil God.ana kan kon-ngath nunang way yot nungantam anangan, keꞌ-ngul ngaantam-ngeeyow, yaꞌa, nanpalana nil kaangk paththam wunan ngathar. Puth nil weeꞌangam ngaantam-ngeeyiy nungantakaman keꞌ nil mina, puth way yot keꞌam yump-yumpa, an nil chil-chil kaangk wunan ngathar.” ");
INSERT INTO wim_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Amanamaniya nil Jesus.an thaw wanch alantan, “Way nungkaram anangan kanam kon-ngath ngayang, keꞌ-ngul ngaantam-ngeeyāng yaꞌa.” ");
INSERT INTO wim_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Than yotam anganan may mungk-mungkin-a, thanana thaw-thawin thanttakaman, “Nil God thonakam ep thawiy ngampar wik yimanangana. Nil pam inan keꞌ thawiy wik yimanangana, yaꞌa.” ");
INSERT INTO wim_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Aꞌ nil Jesus.an thaw wanch alantan, “Nint puth ep ngayangan ngaantam-ngeeyan, ngay nanpalan way nungkaram keꞌ-ngul ngaantam-ngeeyāng, yaꞌ-ngul. Yaa, nint kan iiyānweya, ngangk minangam ngul iiyāna.” ");
INSERT INTO wim_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Amanamana, nil Jesus.an kan-ngul iiy-iiy pal-puy aak thon-thonak, aꞌ wik inan waaꞌ-waaꞌ pam wanchantan, “Nil God.angan kan-ngul meen-meenath nungamang nil moom wuut piꞌan paththaman. Niiy wik ngeeyān nunang aꞌ putha maꞌ nungantang anman iiy-iiyān thamp,” nil Jesus.an wik yimanangan thaw thant. Pam ngurp nungantam twelve anangan nungantang angman iiyin, ");
INSERT INTO wim_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","aꞌ putha wanch wiy thamp iiyin thanttangan. Nil Jesus.ang kaꞌathaman miyalath thanang aꞌ puth oony way anangan thanttam kenth-kenth ngangkangan piꞌ-piꞌin. Nil oony way anangan kanan kenth-kenth thanttam wanch al-alantaman-a, thanan minam ngul iiy-iiyin. Nil thonaniya, Mary Magdalene, nil Jesus.angan oony way seven anangan kenth thanang ngangk nungantam anpalan. ");
INSERT INTO wim_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Aꞌ puth thoniya, wanch namp Joanna, wanch thum nungantam Chuza.antam, pam nil Herod.antan work iiy-iiy. Thoniya, wanch namp Susana. Than wanch il-ilangan thanang Jesus weeꞌanangan min-minakaman piꞌ-piꞌin, may thakan wukal thanttamang piiy-piiyin thant. ");
INSERT INTO wim_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Than pam wanchana pal-palam wamp-wampin nungant Jesus.antan aak nath-nathpalan. Than thaaꞌ-wantanam yal-yalmathwin thanttakaman, aꞌ nil Jesus.angan kan-ngul wik kath inan waaꞌ thant, ");
INSERT INTO wim_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Nil pam thonam iiy-iiy aꞌ may kaanch manyiy aakangan theeꞌ-theeꞌ thanang pal-puya, yipam may anangan emayn. Nil may kaanch anangana maꞌang theeꞌ-theeꞌ thanangan-a, wiy anangan-a, woyanang angan keek-keekin. Anpalana, pam wanch wampin thaꞌang maak-maakin may kaanch anangan, aꞌ putha, minh panch anangana aakang uk-ukin ngul aꞌ mungk-mungkin thanang. ");
INSERT INTO wim_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Puth may kaanch wiy ananganiy-a, aak kunttowthiyang angan keek-keekin. Yiikan kanan pentin-a, than erkam uthamin, puth aak eꞌa, puth kunttowthiya. ");
INSERT INTO wim_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","May kaanch wiy ananganiya, aak waakamthiy angan keekin, yiikan anangan aꞌ putha wak wayanang ananganiya yiikan karpam pentin, emin ngul. Kaꞌathamaniy-a, yuk minam emin, amanamaniya, wak way al-alangan mulathin thanang may min anangana. ");
INSERT INTO wim_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Puth may kaanch wiy ananganiy-a, aak ngaanh minang keekin. Than ep minam em-emin, aꞌ ngulana, may yot kalin thanang, one hundred kalina, thaaꞌ-wantanam. Anman kan.” Aꞌ nil Jesus.an thaw thant ngul, “Yaa, niiy wik ngatharam kanam ngeeyan ey? Yaa, niiyiya konangam piꞌ-piꞌān thanang.” ");
INSERT INTO wim_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Aꞌ ngurp nungantam anangan Jesus.antan thawin wik kathan koochanathow thanang. ");
INSERT INTO wim_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Aꞌ nil Jesus.an puth thaw thant, “Nil God.anganiya kaangk wik nungantaman engkanang wunow niiyant, niiy yipam meeꞌmiy iiyāna wik ngench nungantam anangana, wik inanganiya: nil pam wanch yot anangan ngul piꞌ-piꞌow ngampang maꞌ nungantanga. Puth ngay pam wanch wiyantan wik engkanang keꞌam thant waaꞌ-waaꞌang, ngay wik kath wuthanang anman waaꞌ-waaꞌang thant, yipam thanan thath-thathayn ngayang, aꞌ puth ngeey-ngeeyayn ngayang thonakama, puth yaꞌangam, wik kathaniya, wik wuthanang wunow thant, wik God.antaman keꞌ yipam thiichayn, yaꞌ anmana.” ");
INSERT INTO wim_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Anpalana, nil Jesus.an thaw thant, “Yaa, in ngeeyān a! Ngay wik kathan koochanathāng niiyant. May kaanchan keꞌ wik piip God.antam yimanangan. ");
INSERT INTO wim_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Than pam wanch wiy al-alangan wik God.antaman kan ngeeyin, ngul nil oony wayan wampan thant, thawan thant, ‘Keꞌ ngeeyān a!’ Ngul thananiya, oony wayan ngeeyantan nunang, keꞌ-ngul God.an ngangkangan piꞌ-piꞌantan nunang. Anpalan-a, nil God.angan keꞌ-ngul kaaꞌ-piichanathow thanang. Inaniy-a, keꞌ may kaanch anangan woyan wakanangan keekin. ");
INSERT INTO wim_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Than pam wanch wiy ananganiya, keꞌ may kaanch anangan aak kunttowthiyangan keekinwey. Than il-ilangan wik God.antaman ep ngeeyantan, aꞌ erkam ngangk minan wun thant, puth yaan manyama, than puth yaam keꞌ ngangkangan piꞌ-piꞌantan wik anangan, yaꞌa. Puth wiy al-alangan thaachantan thanang wayan yumpayn-a, than woyan God.antaman wantantan, wik nungantaman kon-ngathan thanang. ");
INSERT INTO wim_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Pam wanch wiy ananganiya, keꞌ may kaanch anangan aak waakamthiy angan keek-keekin. Than il-ilangan wik God.antaman kan ngeeyantan. Puth amanamaniya, than ngaantam-ngeeyantan thanttakam, than want-wanttakan maꞌmangkiy iiyiythan aꞌ puth want-wanttakan may thakan piiy-piiyayn aꞌ kuchek way wunan thant. Aꞌ than thanttakaman ngaantam-ngeeyantan than ngangk min yipam wunayn maꞌmangkiyan yumpwuntan, puth woyan God.antaman kon-ngathan thanang ngula. Amanamana, than wayamantan, min keꞌ-ngul yump-yumpantan yaꞌa. ");
INSERT INTO wim_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Puth pam wanch wiy ananganiy-a, keꞌ may kaanch anangan aak ngaanh minangan keek-keekin. Than il-ilangan wik God.antam anangan ep-paththam minaman ngeeyantan aꞌ ngangkang piꞌ-piꞌantan thanang. Than woyan wayan keꞌ wakantan, yaꞌa, than woyan God.antam anman wak-wakantan, aꞌ min paththam yumpantan.” ");
INSERT INTO wim_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Amanamaniya nil Jesus.angan wik inan waaꞌ thant ngul, “Nil pamang nath lantern pathathiywey-a, an nil yuk paathangan keꞌ kangiy nganthan yaꞌa, puth nil wurp pek-pekaman keꞌ wunpiy yaꞌa, an nil keny achantang waanchan yipam pam wanchangan nganthang aakan thathayn. ");
INSERT INTO wim_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Than pam wanchang kaꞌathaman wik mup thanttakaman piꞌ-piꞌiythan-a, ngul-ngulana thanan wik engkanang ngul pentathayn. An yimanangan — wik ngatharam anangan thenchanam wun-wunan yippak wiyantam, ngul-ngulana an ep-paththam than ngul thiichayn. ");
INSERT INTO wim_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Niiyan wik min-minaman ngeey-ngeeyān ngayan waaꞌ-waaꞌang niiyant. Than weeꞌ-weeꞌanangan wik min-minan ngeeyayn ngayang-a, yaa, ngayan ngul maꞌ-aath-aathāng thanang than yipam minam anman ngaantam-ngeeyayn, aꞌ yot-yotam thiichayn. Aꞌ puth thon iniya, than weeꞌ-weeꞌanangan ngaantam-ngeeyiythan thanttakaman thanan keꞌ wik kanam thiichin-a, puth than keꞌaman wik ngeeyiythan ngayang-a, yaa, ngayan puth keꞌ maꞌ-aathing thanang, aꞌ wik anangan-a, kon-ngathow thanang ngul.” ");
INSERT INTO wim_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Anpalaniy-a, kaath Jesus.antama puth kuunch nungantam anangan wampin yipam thathayn nunang, puth thanan thintham keꞌ wampiythan nungant, puth pam wanch yot al-alangan aak ngathin. ");
INSERT INTO wim_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Yaa, nil puth pam thonam anan thaw Jesus.antan, “Ayyang, kaath nungkarama putha kuunch nungkaram nan yoon than-thantan nungkara, than kaangk wik thawayn nungkara.” ");
INSERT INTO wim_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Nil Jesus.an thaw thant, “Than weeꞌ-weeꞌananganweya nath piip ngatharam in kenyana wik ngeey-ngeeyiythan nunangan-a, an than keꞌ kampan ngatharam yimanangana, kaath aꞌ kuunch ngatharam yimanangan iiy-iiyiythan.” ");
INSERT INTO wim_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Aꞌ amanaman-a, nil Jesus aꞌ ngurp nungantam anangan chukkunang chang peyin, aꞌ Jesus.an thaw thant, “Ayyang, ngamp woꞌuwaynak moꞌāmpa!” Aꞌ than karpam kan-ngul moꞌin. ");
INSERT INTO wim_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Than kanan moꞌ-moꞌin-a, nil Jesus.an weep thayan wun-wun. Anpalaniya, wunt piꞌan wunp aꞌ yeelal piꞌ-piꞌanam ek-ekin ngul, aꞌ ngakan kan thaaꞌ maay-maay chukkunanganiy. Puth thanan warꞌam thuchin. ");
INSERT INTO wim_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Than ngurp nungantam anangan iiyin nungant Jesus.ant, aꞌ weepaman ekathin nunang, aꞌ thawin nungant, “Ayyang, moom-ang, nint kan ekān a! Ngamp ngul thuchamp a!” Aꞌ nil Jesus.an ek, aꞌ wik piꞌan thaw wunt alantan, aꞌ yeelalantan, “Kana! Appap ngula! Enyan ngul wunāna!” Ananiya, wunt piꞌan yaꞌ-ngul weem, aꞌ yeelal piꞌanaman-a, ngakan enyan ngul ump, yaꞌ-ngul. ");
INSERT INTO wim_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Amanamaniy-a, nil Jesus.an thaw ngurp nungantamant, “Niiy ngul ngeenam winynyang moꞌaniy a? Niiy God.an keꞌam ngangkang piꞌ-piꞌaniy ey?” Thanan puth ngurp nungantam al-alangan thaaꞌ ikanang thathin ngak enyan ngulan wun, thana ngangk ikin, winynyang moꞌin, aꞌ thanan thawin thanttakaman, “Apey, nil ngul in wanttak e? In nil pam wiy-wiyam ey? Wunt-a, puth yeelal alantan wik piꞌanan thaw-a, pulan-a, appap paththam wunpul, ana aak yaꞌ-ngul enyan paththam ween.” ");
INSERT INTO wim_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Nil Jesus-a, puth ngurp nungantam anangana, woꞌuwayn peyin chukkun thanttamang aak Galilee.am anpalan, aak pam wanch Gerasenes al-alantamakan. ");
INSERT INTO wim_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Nil Jesus.an thaaꞌ pey thompang-a, nil pam thonamang aak town thanttam anpalana uw nunang. Nil pam ilangan oony way ngangkangan piꞌ-piꞌ thanang. Nathpalmana, pam inana maꞌlip anman iiy-iiy, ngook keꞌanangana, aꞌ nil aawuch nungantamang kaangk keꞌ wunow, nil aak kunttowthiyang wun-wun aak than pam mul anangan kaamp-kaampin thanang. ");
INSERT INTO wim_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Nil Jesus.an thath nunang-a, nil paman othamayan pech, aꞌ aakang theeꞌ nungamang. Aꞌ nil Jesus.an thaw oony way alantan, “Nint kan pentān pam ilantamana.” Aꞌ nil pam weenthana wik othamayan pech, “Jesus ey! puk nhengk pam ngench thayan alantaman ey! puk nhengk God.antam nintiya! Nint ngul ngeenak wampan ngathar e? Ngay thaaꞌ-mamanang thawang nungk nint keꞌ wayathān ngayanga!” Nathpalmana, nil oony way inan maꞌ-yotam ngangkangan ngoonch nungantang, pam alantangan, aꞌ weenth paththam yump-yump nunang. Than pam wiyangan maꞌ-yotam mamin nunang, aꞌ maꞌ-yotam chainsangan maꞌ kathin nunang, puth yaꞌangam, nil chains anangan thuth-thuth, aꞌ than yuk chainsangan thaꞌangan kathin nungantang puth yaꞌangam, nil yaꞌ nhanthath chains anangan, aꞌ anpalana nil oony way alangan kuyam kal-kal nunang aak pintalakan. ");
INSERT INTO wim_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Nil Jesus.an thaw nungant pam alantan, “Namp nungkar wanttaka?” Nil paman thaw nungant, “Namp ngath inaniya, ‘Yota.’” Nil inan thaw puth oony way yot anangan ngangkangan ngoonch nungantang. ");
INSERT INTO wim_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Than oony way yot anangan thaaꞌ-mamanang thaw-thawin nungant Jesus.antan keꞌ kenthow nganang aak nath pek kech aakanakana, aak anan oony way wiy anangan wun-wuntan. ");
INSERT INTO wim_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Aꞌ minh nhinthan yot anangan kech keꞌan iiy-iiyin may mungk-mungkin, aak achantang kaaꞌ um pek kech kookam piꞌanwakan. Aꞌ than oony way yot anangan thaaꞌ-mamanang thawin nungant Jesus.antan, “Nint nganang ang kenthān minh nhinthan al-alantang ngoonchān thanttanga.” Aꞌ nil Jesus.an thaw thant, “Niiy kan iiyāna!” ");
INSERT INTO wim_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Amanamaniya, oony way yot anangan pol-pol pent-pentin pam alantaman, aꞌ minh nhinthanantangana wupam ngoonch-ngoonchin ngul maꞌmangkamantang minh nhinthan yot thaaꞌ-wantanama! Minh nhinthan anangan kamp othamayan moꞌ-moꞌin aꞌ kaaꞌ um pek keekin ngakangana aꞌ puth thuchin ngul aak umpuyama. ");
INSERT INTO wim_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Than pam anangan minh nhinthan anangan piꞌ-piꞌin-a, thathin thanang minh nhinthan anangan pek keekin ngakangan, aꞌ thanan kamp moꞌ-moꞌin wikan pal-puy waaꞌ-waaꞌin pam wanch wiy al-alantan, aak townsang angan wun-wunin aꞌ puth thant aak farmsangan wun-wunin thamp. ");
INSERT INTO wim_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Than pam wanchangan aak thanttaman too wantin, aꞌ aak-aakanakaman iiyin Jesus.antan yipam thathayn wanttakan nath yump. Aꞌ than Jesus.antan wampin aꞌ than thathin pam oony way yotan kan-kanam pentin ngangk nungantam anpalan. Nil angman nyiin-nyiin, minam ngul, thaꞌ Jesus.antang nyiin, ngook thampa, aꞌ kuchek min ngul, keꞌam ngul weenth-weentham yaꞌ-ngul. Than pam wanch yot anangana winynyang ngul moꞌin. ");
INSERT INTO wim_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Than pam wanch meeꞌmiy al-alangan waaꞌ-waaꞌin thant wiy al-alantan than keꞌaman thathin Jesus.angan paman miyalath. ");
INSERT INTO wim_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Aꞌ than yotana kan-ngul thaw-thawin nungant Jesus.antan, “Nint kan-ngul aak inan wantāna,” than puth yotam winynyang paththam moꞌ-moꞌin. Yaa, anpalana, nil Jesus.an chukkunang ngul pey, yipam aakan wantow. ");
INSERT INTO wim_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Puth nil pam anman oony way anangan kanaman pentin ngangk nungantam anpalana, thaaꞌ-mamanang thaw nungant Jesus.ant, “Ngayang keꞌ wantāna, ngay puy nungkarang iiyānga!” Puth nil Jesus.an thaw nungant, ");
INSERT INTO wim_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Yaꞌa, nint pal ngatharang keꞌ iiyān. Nint paththam koyam iiyān aak nungkaramakan aꞌ waaꞌān thant nil piip God.angan miyalath nintang, kuchek wayamana min ngul yump nintang.” Aꞌ nil pamana town wakan iiy-iiy, aawuch thon-thonak iiy-iiy, aꞌ waaꞌ-waaꞌ thant nil Jesus.angan miyalath nunang. ");
INSERT INTO wim_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Anpalan-a, than Jesus weeꞌanangan koyam woꞌuwaynak kan-ngul moꞌin, aꞌ than pam wanch yot anangan umang moꞌin nungant, ngangk minangam, puth than kuup-kuupin nungant. ");
INSERT INTO wim_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Anpalaniya nil pam namp Jairus.an wamp nungant Jesus.antan, nil pam inman pam piꞌan churchakana. Nil pungkang thuchant um Jesus.anta, aꞌ thaaꞌ-mamanang thawant nil iiyowantang aak nungantamakan, ");
INSERT INTO wim_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","puth puk wanch nungantaman kan-kanang uthamow. Puk wanch kaaꞌ-thonam nungantam, kaap twelve.ang uwana. (Nil piip-kunchanganiya kaangk Jesus.angan miyalathow nunang.) Nil Jesus.an kan-ngul iiy nungantang Jairus.antangan, puth pam wanch yotangana angman wuthanathin nunang Jesus.an. ");
INSERT INTO wim_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Nil wanch thonam angmana, nil wewmangan want-want nunang kaap twelve.akam. Nilaniya wukal keꞌanang ngul puth nil wukal maꞌmangkam theeꞌ nooyan al-alantan. Puth thananiy wanchana keꞌam miyalathin nunang yaꞌa. ");
INSERT INTO wim_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Nilana puth koy-koyyuw iiyant Jesus.antan aꞌ ngook nungantaman mamantam. Anpalaniya, wewmangan keꞌ-ngul want-wantan. ");
INSERT INTO wim_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Aꞌ nil Jesus.an thaw thant, “Ayyang, ngayang weeꞌang mamany a?” Yotan thawin, “Nil weeꞌang nath mam nintanga? Ngana yaꞌa.” Ngurp Jesus.antam Peter.an thawant, “Lorda, inan puth pam wanch yota thaꞌ-thaꞌwuntan nungkarang wakana!” ");
INSERT INTO wim_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Nil Jesus.an thawanta, “Eeꞌa, kan-kanama, puth nil thonamangan ngayang mamanya. Ngay puth kemp ngeechanang ngayan weeꞌ-nathan miyalathangan.” ");
INSERT INTO wim_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Nil wanch alangan ngaantam-ngeey nungantakaman, “Nil Jesus.an puth meeꞌmiy ngayan mamangan.” Aꞌ nilaniya winy-winynyang iiy Jesus.antan, aꞌ pungkang thuchant um nunganta. Aꞌ meeꞌ yotantang thaw nungant, “Ngay mamangan nintanga, puth ngayan yipam miyalamānga, puth anpalana, ngay nintangan mamanga, ngayan miyalamang ngul.” ");
INSERT INTO wim_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Nil Jesus.an thaw nungant, “Ayyang, nhengk ngatharam-ang, nint kan-kanam ngaantam-ngeeyan ngayangan puth ngay ngul miyalathāng nintang. Puth amanamaniy-a, ngay kan-kanam puth miyalathang nintang. Nint kan-ngul ngangk minangam iiyān aak nungkaramakana.” ");
INSERT INTO wim_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Nil Jesus wik inangan thaw-thaw yippak-a, nil pam wamp aawuch Jairus.antaman anpalana. Nil thaw nungant Jairus.antan, “Puk nhengk nungkaram kanam uthama. Keꞌ thawān Jesus.antan aawuch nungkaramakan iiyow. Nil aak-yaꞌangan ngul iiya, pukan mul ngula.” ");
INSERT INTO wim_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Aꞌ nil Jesus.angan ngeey paman thaw, aꞌ nil thaw Jairus.antan, “Nint keꞌ kuchek wayan wunāna, nintiya nganyangam ngaantam-ngeeyāna, ngay ngul ekathāngan wanch manyana.” ");
INSERT INTO wim_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Aꞌ than iiyin ngul aak Jairus.antamakan. Than kanan wampin-a, nil Jesus.angan pam koꞌalam anangan ump thanang keny matayn nungantang puk many wanchan mul wun-wuna, kaath-kunch-a, piip-kunch-a, aꞌ putha ngurp nungantam anangan thanang Petera, Jamesa, aꞌ putha John. ");
INSERT INTO wim_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Than wiy anangan angman yoon kuup-kuupin, than othamayan peey-peeyin. Nil Jesus.an thaw thant, “Keꞌ peeyāna! Nil wanch manyan keꞌam uthama, yaꞌa, nil weep thonakama wun-wunan.” ");
INSERT INTO wim_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Puth pam wanchangan thaaꞌ-thengkathin nunang Jesus.an, than puth ngaantam-ngeeyin puk manyan kan-kanam mul wuna. ");
INSERT INTO wim_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Aꞌ nil Jesus.an puk many alantan iiy, aꞌ maꞌ mam nunang aꞌ thawant ngul, “Ayyang, ekān a!” ");
INSERT INTO wim_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Anpalana, puk many wanch Jairus.antaman mulaman koyam kan-ngul ek. Aꞌ Jesus.an thaw thant, “Ayyang, niiy may aathān nunangweya.” ");
INSERT INTO wim_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Anpalana, pul kaath piip puk alantamana meeꞌam ikpula. Aꞌ nil puth Jesus.an thaw pulant, “Nipaniya niparakam wik inan piꞌowa, nip pal-puy keꞌ waaꞌ-waaꞌow thon-thonantaniya.” ");
INSERT INTO wim_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Anpalaniy-a, nil Jesus.angan pam ngurp nungantam twelve anangan karpam yalmath thanang aꞌ nil thaw thant aꞌ puth thayanam yump thanang yipam oony way anangan kenth-kenthayn pam wanch al-alantaman ngangkangan piꞌ-piꞌinwey, aꞌ yipam miyalathayn thanang weechanan thanang. ");
INSERT INTO wim_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Aꞌ nil kuch thanang thanan yipam wikan waaꞌayn thant wiyantan puth aakana thinth ngul kan wamp-wampana nil piip God.angana pam wanch yota maꞌ nungantangan piꞌ-piꞌow thananga, aꞌ putha than yipam pam wanch alpan anangan miyalathayn thanang. ");
INSERT INTO wim_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Nil kaꞌathaman wik thayan anman thaw thant, “Niiy maꞌlip iiyāna, yuk pil thook keꞌ kalāna, aꞌ niiy bag keꞌ kalān may thenchanakana. Aꞌ niiy may keꞌ kalāna, aꞌ puth wukal keꞌ kalāna, aꞌ putha niiy keꞌ ngook kuchaman kalāna, thonam anman ep kalāna. ");
INSERT INTO wim_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Niiy nathwey aak townang kanan ngoonchān-a, aꞌ than wiy anangan umang iiy-iiyiythan niiyantwey, aꞌ ngangk minangam ngoonchathiythan niiyangwey aawuch thanttamakan-a, yaa, niiyaniy-a, aak angman wunān aawuch thanttamangan, aꞌ anpalman ngul iiyān aak thonak ngulana. ");
INSERT INTO wim_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Niiy nathwey aak town thonak ngulan wampān-a, aꞌ than umang keꞌwey iiyiythan niiyantaniy-a, yaa, niiyaniya aak anana too wantāna, aꞌ thaꞌ wookana wunyathān thantana, puth anpalana than kaangk keꞌan wik niiyantaman ngeeyayn. Than thathayn niiyang yimanangan yumpān-a, thanan nath ngul ngaantam-ngeeyayn thanttakaman than way-wayam paththaman iiy-iiyantan.” Nil Jesus.an wik yimanangan thaw thant ngurp nungantam al-alantan. ");
INSERT INTO wim_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Amanaman-a, than kan-ngul iiyin, aꞌ village thon-thonakan wamp-wampin aꞌ wik minan kan-ngul thaaꞌ-aath-aathin pam wanchana, aꞌ pam wanch way alpan anangan miyalathin thanang. ");
INSERT INTO wim_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Anpalana, nil King Herod.ana, pam anman aak Galilee.an wak-waka, kuchek way wunant. Nil puth wik thooꞌ ngeey Jesus.antamana work piꞌ-piꞌanaman yump-yumpan. Pam wanch wiy anangan thaw-thawin, “Nil pam nanman John.an ey? kuchekan kuungk-kuungk thanang ey? nil mulaman kan ek ey?” Nil Herod.antana kuchek way nanpalan wunant. ");
INSERT INTO wim_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Puth wiy anangan thawin, “Nilan Elijah paththama!” Than wiy anangan thawin, “Nilana pam prophet ey? keenkanaman wun ey? Nil mulaman kan-ngul ek ey?” ");
INSERT INTO wim_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Nil Herod.an thaw, “Ngay kaꞌathangaman thawangan thant kuchek John.antaman thalokang umpayn, puth pam inan weeꞌa ngay wik thooꞌ ngeeyangan nungantam work piꞌ-piꞌanaman yump-yumpana?” Nil kaangk thathow nunang Jesus.an yipam wik thawow nungant. ");
INSERT INTO wim_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Anpalana, than ngurp nungantam ananganiya palam ngul wampin nungant Jesus.antan, nilaman kuch thanang wik nungantaman weꞌarathayn. Than waaꞌin nungant ngul than ngeen thakan yumpina, aꞌ thaaꞌ-aath-aathinan thanang thampa. Aꞌ nil Jesus.angan karpam kal thanang, aꞌ than-thanam ngul iiyin aak town namp Bethsaida.akan. ");
INSERT INTO wim_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Than pam wanch yotangan wik thooꞌ ngeeyin than aak thonakan iiy-iiyin, puth thanana monkan-wakin thanang. Nil Jesus.an ngangk minangam uw thanangweya aꞌ waaꞌ thant aakana thinth ngul kan wamp-wampana nil piip God.angana pam wanch yota maꞌ nungantangan piꞌ-piꞌow thanang, aꞌ nil miyalath thanang pam wanch way alpan anangan. ");
INSERT INTO wim_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Kinch kanan uk-uk-a, than ngurp nungantam twelve anangan wampin nungant, thawin nunganta, “Ayyang, nint pam wanch anangan kuchān thanang than iiyayn aak farms aakanakan, aꞌ puth villages aakanakan thinth-thinthan than-thantana, aꞌ may piiyayn thanttakaman, aꞌ angan paanthayn, puth aak inan chil kecha!” ");
INSERT INTO wim_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Nil Jesus.an thaw thant, “Niiyam may aathān thanangweya!” Thanan puth thawin nungant, “Ngan may many thamp, may bread five, aꞌ puth-a, minh ngaꞌ kucham piꞌ-piꞌanan, anman thonakama. In wanttak e? Nint kaangk ngan may piiyān thant ey? pam wanch thaaꞌ-wantanam il-ilantan ey?” ");
INSERT INTO wim_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Puth pam yot-yotam iniya, five thousand). Aꞌ nil Jesus.an thaw thant ngurp nungantam al-alantan, “Niiy thawān thant pungk-pungkalang nyiin-nyiinayn, fifty-fifty nyiin-nyiinayn.” ");
INSERT INTO wim_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Than ngurp nungantam anangan kanan thawin thant-a, thanan nyiin-nyiinin, ");
INSERT INTO wim_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","aꞌ nil Jesus.angan-a, may bread aꞌ minh ngaꞌ anangan maꞌang maay ngul, aꞌ meeꞌ keny thath, aꞌ meeꞌ-wuthanam ngul piip God.ant, thankyou thaw nungant may minh aakanakan. Nil may minh anangan pip-pip thanang, aꞌ theeꞌ ngurp nungantam al-alantan ngul, than yipam kalayn pam wanch yot al-alantan. ");
INSERT INTO wim_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Than pam wanch maꞌmangkam al-alangan mungk-mungkin ngul, aꞌ thip oth ngul wunin. Aꞌ than ngurp nungantam al-alangana may nhanth anangan yalmathin aꞌ yuk basketang wunpin. May nhanth aꞌ minh ngaꞌ nhanth al-alangan baskets twelve thaaꞌ mul maay. ");
INSERT INTO wim_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Aꞌ amanaman-a, nil Jesus.an pokkap nyiin, meeꞌ-wuth-wuthanam piip God alantan. Aꞌ than ngurp nungantam anangan wampin nungant. Nil thaw thant, “Niiyalang, kan niiy waaꞌiy ngathara. Than ngul pam wanch yotangan ngayangan keꞌ weeꞌ yimanangan ngaantam-ngeeyantan ngayanganiya?” ");
INSERT INTO wim_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Thanan thawin nungant, “Than pam wanch puungk wiyangan keꞌ John waaꞌantan nintang, pam anan nil kootra ngakangan kuungk-kuungk thanang pam wanchana, puth puungk wiyangiy keꞌ pam Elijah waaꞌantan nintang, aꞌ wiyangiy keꞌ pam prophet waaꞌantan nintang keenkanaman wun, keꞌ mulam koyam ekan ey!” ");
INSERT INTO wim_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Aꞌ nil Jesus.an thaw thant ngul ngurp nungantam al-alantan, “Puth niiya ngayangan wanttak ngaantam-ngeeyaniya ngay keꞌ pam weeꞌ iniy e?” Aꞌ nil puth Peter.an thaw nungant Jesus.antan, “Ayyang, nint inan ngeeya! Nintiya Christa, pam God.antaman nilan kaaꞌngak ngulan kuchow nintangan ngantakana.” ");
INSERT INTO wim_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Anpalana, nil Jesus.an thaaꞌ-thayanam thaw thant ngurp nungantam al-alantan, “Niiy wik inana keꞌ waaꞌān thant wiyantana, keꞌ waaꞌān paththama.” ");
INSERT INTO wim_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Nil wik inangan thamp waaꞌ thant, “Pam wanch wiyanganiya way-wayam anangan yumpayn ngathara, pam ngay inmana nil God.angan kuch ngayang. Than pam piꞌan Jews.antam al-alangana man-mangkam ngul theeꞌayn ngatharweya, than pam manth-thayan al-alangana aꞌ puth than moom priestsantam al-alangana aꞌ pam piꞌan wiy al-alangana, than wik thayanan thaaꞌ-aath-aathantan thanang. Anpalaniy-a, than mulathayn ngayangweya, puth kinch koꞌalam ngulan wantow ngayangan-a, ngaya mulaman koyam ekāng ngula.” ");
INSERT INTO wim_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Aꞌ nil thaw thant yotantan, “Nil weeꞌ-nathweya kaangk ngatharanganiy iiyowwey-a, nilaniya keꞌ ngaantam-ngeeyow nungantakamana, yaꞌa. Pam wanch al-alangan nath mulathayn nunanga, keꞌ ngayangan mulathayn, yuk wuuyanangan waanchayn ngayang. Nungkway than wiyangana nath mulathayn nunang-a, nilana ngayang anman monkan-wak-wakow. ");
INSERT INTO wim_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Nil weeꞌangwey wantow ngayangana pam wanch wiyangan keꞌ yipam mulathayn nunang-a, yaa, nilaniya keꞌ wuniy aak ngatharamangan yaꞌa; puth nil weeꞌanganwey anman ngangk thayanangama monkan-wak-wakow ngayangan-a, nungkway pam wanch wiyangana thaaꞌ-thengkathiythan nunang-a, nath mulathiythan nunang-a, yaa, an nil ngangk aak umpuyam puth wunow aak ngatharamangana. ");
INSERT INTO wim_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Pam wanch wiy anangan maꞌmangkiy iiy-iiyantan, way min yot-yotam piꞌ-piꞌantan aak inganiya. Puth than nath wantayn ngayang-a, an way min yot anangan min thant ey? Yaꞌa! Way min yot-yotam al-alangan ngangk min keꞌ yumpiy thanang yaꞌa. Puth ngay nathwey keꞌ kaling thanang aak ngatharamakanwey-a, an way min yot anangan min thantaniy ey? Yaꞌa! ");
INSERT INTO wim_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Pam wanch puungk wiy anangana ngul-nyaaꞌ wuniythan ngatharam, aꞌ putha wik ngatharam anpalan, ngay pam inman nil God.angan kuchanya. Ngul-ngulana, ngay palaman ngul wampāng thanttang ngaantiyongk min al-alantangan aak iikanakaman. Ngayana parkānga, keꞌ thum nganth yimanangan. Ngay pam piꞌan paththam wampānga, keꞌ piip ngatharam anman God.an. Aak an-aniyangana ngay ngul-nyaaꞌ wunāng thanttam pam wanch al-alantaman thanan ngul-nyaaꞌ wunin ngatharaman aak inganiya. ");
INSERT INTO wim_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ngay inan waaꞌāng niiyanta: aakan ngul wampowa nil piip ngatharamangan pam wanch yot anangana ngul piꞌ-piꞌow thananga. Puth pam wanch wiy aak inman yippak wunaniy-a, man-yetham iiy-iiyān aak ngulan wampowa, niiy meeꞌ niiyamana ngul thathānweya.” ");
INSERT INTO wim_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ngul-ngulana, week thonamangan kanan want thanang-a, nil Jesus.angan ngurp nungantam koꞌalam kal thanang yoyk achantangak, Peter-a, aꞌ James-a, aꞌ puth John. Than keny matin yipam meeꞌ-wuthanamayn piip God.antan. ");
INSERT INTO wim_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Nil Jesus.an yippak meeꞌan-wuth-wuthanam-a, kaaꞌwal nungantaman wiy-wiyaman weem, aꞌ ngook nungantaman pach paththam weemant. ");
INSERT INTO wim_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Aꞌ yaam keꞌan-a, pam kucham wamppul nungant aꞌ wik thaw-thawpul nungant. Pam kucham inangan-a, Moses aꞌ Elijah. ");
INSERT INTO wim_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Pul thampang yaꞌ parkpul, nganth minangam, aꞌ pul thawpul nungant Jesus.antan, “Pam wanch wiyanganiya way-wayam anangan yumpayn nungkara, aꞌ anpalana than mulathayn nintang aak Jerusalem.ang angan. Nil God.angan kuch nintang yipam yimanangan uthamān.” ");
INSERT INTO wim_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Peter weeꞌanangana weep thayan wunin, puth thanan weepaman ekin aꞌ thathin Jesus aꞌ pam kucham anangan thanpul nungantang, thanan yaꞌ parkin, nganth minangam. ");
INSERT INTO wim_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Pul Moses.anga kan-kanangan wantowpul nunang Jesus.an-a, aꞌ nil Peter.an thaw nungant, “Lord-ang, an ngampar min ngamp aak inganiy wunāmpa! Ngay ngorkal koꞌalam keꞌ yumping niiyant ey? aak ingman ey? thonam nungkara, aꞌ thonaniya nungant Moses.anta, puth thonaniya nungant Elijah.anta!” (Nil Peter.an keꞌ ngaantam-ngeey wik want-wanttakan thaw). ");
INSERT INTO wim_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Nil Peter.an wikan yippak thaw-thaw-a, yuwan thanttang wakan thuuch, aꞌ ngoyngk alangan thanang yaꞌ kang, aꞌ than ngurp nungantam anangan winynyang moꞌin puth anpalana yuwan thanttang wakanan thuuch. ");
INSERT INTO wim_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Aꞌ thanan wik inan ngeeyina, yuw anpalan thaw-thaw, “In puk nhengk ngatharama, ngay nunang kan miꞌangan. Niiyan puth wik anman ngeey-ngeeyān nunanga!” ");
INSERT INTO wim_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Nil kanan thaw yuw anpalan-a, than ngurp Jesus.antam al-alangan Jesus anman thonakam thathin. Than wiyantan keꞌam waaꞌin, putha thanan wik mupam piꞌ-piꞌin thanttakaman thanan wanttakan thathin yoykangan. ");
INSERT INTO wim_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ngaaꞌ thonangan-a, Jesus aꞌ ngurp nungantam koꞌalam anangana yoyk amanaman ukin, aꞌ pam wanch yot umang uwin nunang Jesus.an. ");
INSERT INTO wim_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Pam thonam thanttangan than-than-a, pech nungant Jesus.ant, “Ayyang, Moom-ang, ngay thaaꞌ-mamanang thawang nungka. Nint puk nhengk ngatharam thathān nunanga! puk nhengk kaaꞌ-thonam ngatharama! ");
INSERT INTO wim_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Nil oony wayan maꞌ-yotam wamp-wampan nungant, aꞌ othamayan pech-pechan, aꞌ aakang unch-unchan nunang yaꞌ thay-thayanamana. Thaaꞌ theek piꞌan uk-ukan nungant. Nil oony way alangan yaam way-wayathan nunang aꞌ kaangk keꞌ kuchow nunanga. ");
INSERT INTO wim_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ngayan puth ngurp nungkaram il-ilantan thawang thant than oony wayan pentathayn nungantam, puth yaꞌangam, keꞌ pentathiythan nunanga.” ");
INSERT INTO wim_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Aꞌ puth Jesus.an thaw thant ngurp nungantam al-alantan, “Ngay niiyantang nathpalman iiy-iiyangweya! puth yaꞌangam ey? niiyan ngangkangan keꞌam piꞌ-piꞌaniy ngayangana! Ngay kaap ngeen-ngeen kuupāng niiyant e? niiy yipam min-min ngangkangam piꞌ-piꞌān ngayangan e?” Aꞌ nil thaw ngul pam alantan, “Ayyang, puk nhengk nungkaram pal kalān ngathara!” ");
INSERT INTO wim_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nil puk ngechwiyan wamp-wamp Jesus.antan-a, nil oony way alangan aakang keekath nunang, aꞌ nil yaꞌ thay-thayanama. Nil Jesus.an wik thayan thaw oony way alantan, aꞌ kenth nunang ngangk puk ngechwiy alantaman, aꞌ nil puk ngechwiyan koyam kal nunang piip-kunchantan, minam ngul yumpan. ");
INSERT INTO wim_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Than pam wanch maꞌmangkam anangan meeꞌam ikin, puth nil piip God.angan thayan paththam yump nunang Jesus.an yipam pukan miyalathowan. Than pam wanch anangan yaamim meeꞌam ikin puth nil Jesus.angan work piꞌan yotam yump-yump, aꞌ nil Jesus.an thaw thant ngurp nungantam al-alantan, ");
INSERT INTO wim_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Niiyalang, ngay wik inangan waaꞌāng niiyant, niiyang keꞌ kon-ngathow. Pam way al-alangana maꞌam theeꞌayn ngayang pam wayanang wiy al-alantan, thananiya way paththam yumpayn ngathar, pam ngay inman nil God.angan kuchanya.” ");
INSERT INTO wim_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Puth ngurp nungantam al-alanganiya wik kumin nunang wik nilan thaw-thaw thant, an than keꞌam thiichin yaꞌa. Nil Jesus.ang keꞌam wikan koochanath thant, puth than winynyang moꞌin, kaangk keꞌ engkayn nungant wik want-wanttakan nilan thaw-thaw. ");
INSERT INTO wim_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Anpalana, than ngurp nungantam Jesus.antam anangan wik thaw-thawin thanttakamana nil weeꞌ-nathana thanttang pam meek piꞌan iiyow. ");
INSERT INTO wim_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Nil Jesus.angan meeꞌmiy thanang thanan want-wanttakan ngaantam-ngeey-ngeeyin, nilan puth puk thonam ump nunang, aꞌ um nungantang thanath nunang, ");
INSERT INTO wim_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","aꞌ nilan thaw thant, “In ngeeyiya! Nil weeꞌanganweya puk many keꞌ inana minaman piꞌow nunang-a, puth anpalana nil ngayangan monkan-wak-wakana, an keꞌ nil ngayang ngangk minangam umang wakana, aꞌ minaman piꞌ-piꞌan ngayang. Aꞌ putha nil weeꞌangweya ngangk minangam iiy-iiyow ngathar-a, an keꞌ nil pam anana piip ngatharam God.anta ngangk minangam iiy-iiyan nungant thampa, nil puth piip ngatharamangana kuch ngayangan aak iikanakan. Niiy nath mochan iiy-iiyin keꞌ puk many inan-a, yaa, niiy ngul-ngulana pam moom piꞌan paththam ngul iiy-iiyān.” ");
INSERT INTO wim_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Aꞌ nil John.an thaw Jesus.antan, “Ayyang, Moom-ang, ngan pam thonam thathan nunang namp nungkaraman wich, aꞌ anpalana nil oony way anangan kenth thanttam pam wanchantam. Ngan puth thawan nungant, ‘Keꞌ yimanangan thawāna,’ nil puth pam anman keꞌam iiy-iiyan ngamparangana, yaꞌa.” ");
INSERT INTO wim_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Nil Jesus.an thaw nungant John.ant, aꞌ ngurp wiy al-alantan, “Niiy keꞌ wayathān nunang pam anana. Than weeꞌ-weeꞌananganweya keꞌamana thaamp-thaampantan niiyangan-a, an keꞌ than niiyantang iiy-iiyantan yimanangan, ngurp niiyantam thaniya.” ");
INSERT INTO wim_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Anpalan-a, aakan thinth ngul wamp-wamp piip-kunchangan kan-ngul koyaman kenyan matathowan Jesus.an, aak nungantamakana. Puth Jesus.angan kuchek thayanam ngaantam-ngeeya nil aak Jerusalem.akan iiyowa, yaa, puth nilana iiy ngul. ");
INSERT INTO wim_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Nilaniya pam koꞌalam anangan keenk kuch thanang wik thampan iiyin waaꞌayn thant pam wanchantan nil Jesus.an puy-palan wampana. Amanamaniya thananiya iiyin ngul aawuch wal-ngaarpan than-thanin aak Samaria.angana than yipam aakan keenkan uwayn nungant aawuchana. ");
INSERT INTO wim_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Than pam wanch aak an punchanan thawina than kaangk keꞌa nil Jesus.an wunow aak angan thanttangan, nil puth aak woyan aakanakaman iiyan aak Jerusalem.akana. ");
INSERT INTO wim_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Pul ngurp nungantam al-alangan James-a, puth John.ang wik inan ngeeypulan-a, pulan thawpul nungant Jesus.antanweya, “Ayyang, Lord-ang, ngan keꞌ thawin God.antan ey? thum inpal kenyan kuchiy aak Samaria.akan ey? than pam wanch maꞌmangkaman-a, yipam mulakam penchayna?” ");
INSERT INTO wim_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Nil puth Jesus.ana weent pulant aꞌ nil wak-wak pulang ngurp nungantam anangana. ");
INSERT INTO wim_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Nil Jesusa puth ngurp nungantam anangana thana kan-ngul iiyin aak many thonak ngula. ");
INSERT INTO wim_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Than Jesus-a, putha ngurp nungantam weeꞌanang kan-ngulan iiyin-a, nil pam thonam wamp Jesus.antan aꞌ thaw nungant, “Nint aak want-wanttinakan iiyān-a, ngayiya nintang monkan-wak-wakāng.” ");
INSERT INTO wim_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Nil puth Jesus.an thaw nungant pam alantan, “Than minh thech aꞌ minh kek-wayang ep aak awarang weep wuntan, aꞌ puth minh panch anangan wurp many thanttamangan weep wuntan, puth ngay pam inman piip God.angan kuch ngayangan-a, an ngaya aawuch keꞌananga, weepan wun-wunanakanweya, yaꞌa.” ");
INSERT INTO wim_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yaa, anpalana nil Jesus.an pam thon alantan thaw ngul, “Nint puth ngayang monkan-wakāna!” Puth nil pamana thaw nungant Jesus.antan, “Ngay kan kaꞌathaman koyam iiyāng aak ngatharamakan, aꞌ piip ngatharaman kaampāngan, nil puth mul wun. Anpalana ngay nintang ngul monkan-wakānga.” ");
INSERT INTO wim_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Nil puth Jesus.an thawa, “Than pam wanch al-alangan God keꞌaman monkan-wakantan nunang-a, thanan mak pam mulan kaamp-kaampwayn, puth thananiya keꞌ pam mul anman iiy-iiyantan thampa. Nint iiyāna aꞌ waaꞌān pam wanchantan wik ngeeyayn nunang God.ana, putha maꞌ nungantang anman iiy-iiyayn.” ");
INSERT INTO wim_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Aꞌ pam thon ngul thaw nungant Jesus.antan, “Moom-ang, ngay nintang monkan-wakānga. Puth kaꞌathamiya ngay kan koyam iiyāng aak ngatharamaka kampan ngatharam anangan maꞌ-thuthāng thanang putha appow thawāng thant.” ");
INSERT INTO wim_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Nil Jesus.an thaw nungant, “Nil pam kanan thawana ngayangan monkanan-wak-wakowanyan-a, nilaniya koy-koyamana keꞌ-ngul weentiy, yaꞌa puth nilana keꞌ work minan iiy-iiyiy God.antan, yaꞌa.” An keꞌ aak yimanangan wunan: nil pamang wakwey koochanaman ump-umpiy hoe.angan-a, nilan koy-koyamana keꞌ-ngul weentiy. Nil aak thonwey thathiy-a, an nil wakana thaaꞌ kach-waar ngul ump-umpiya. ");
INSERT INTO wim_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Amanamana nil Lord Jesus alangana pam yot miꞌ thanang seventy-two, than yipam umputh iiyayn aak thon-thonakan. Puth nil Jesus aꞌ ngurp nungantam wiy anangan than koy-koyyuw ngul iiyayn. Nil Jesus.angana pam kuch-kucham kuch thanang. ");
INSERT INTO wim_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Nilan thaw thant, “Pam wanch yotamangana wik min ngatharamaniya kaangk yipam ngeey-ngeeyayna. Niiy pam koꞌ-koꞌalama il-ilangan wikan waaꞌ-waaꞌaniy thant a! Than pam wanch yotam anangan keꞌ may menchan yukangan wun-wuntana, niiya pam koꞌalam thonakam work iiy-iiyaniy may menchan anangan yipam yal-yalmathān thanang. Aꞌ niiy meeꞌ-wuthanamān piip God.antan, thawān nungant pam wanch yot kuch-kuchow thananga than yipam wik min ngatharaman waaꞌ-waaꞌayn thant wiyantan. ");
INSERT INTO wim_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Niiy kan-kanangk iiyāna, ngay inan kuchang niiyang pam wanch way-wayanang al-alantana. Puth niiyaniya maal anman iiy-iiyān thanttangana, keꞌ minh sheep anman, puth kulliy yaꞌa; than pam wanch ananganiy-a, kulliy weenayn niiyant, keꞌ kuꞌ kulliy yimanangana. ");
INSERT INTO wim_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Niiy wukal tham karpam keꞌ kalān, bag thampana keꞌ kalān may thenchanakana, putha thaꞌ murruk keꞌ kalān thamp, yimanaman iiy-iiyān. Niiy yaaman keꞌ than-thanān woyan omp-ompamangan aꞌ keꞌ wik thawān thant pam wanchantan woyan wakanan yaꞌa. ");
INSERT INTO wim_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Niiy aak town ang-ngulan wampān-a, aꞌ putha aawuchang ngulan pek ngoonchān-a, niiy kaꞌathamana wik inangan thawān thanta, ‘Ngan kaangk nil God.ana ngangk minangam iiy-iiyow niiyanta.’ ");
INSERT INTO wim_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Than pam wanchang wik minamwey ngeeyiythan niiyantaman-a, yaa, nil God.ana ngangk minangam anman iiy-iiyow thant keꞌ niiyaman waaꞌan thanta. Puth than nath kaangk keꞌwey ngeeyayn wik min God.antaman-a, nil piip God.ana ngangk minangam keꞌ iiy-iiyow thanta, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","8","Thanwey nath thawayn niiyant angman paanthanak thanttangan-a, yaa, niiy puth angman thanttang paanthāna, niiy aawuch thon-thonangan keꞌ iiyān yaꞌa. May minh ngeen nathan theeꞌayn niiyantanwey-a, yaa, niiy may thanttamana mungkāna. An mina than may minhan theeꞌayn niiyanta, an niiyaniya puth wik min God.antam anangan waaꞌ-waaꞌaniy thanta. Niiy may puth-puthamakan keꞌ thawān thanta. ");
INSERT INTO wim_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Pam wanch aakan punchanan weeꞌ-nathan weech-weechowan-a, niiy miyalathān thanang, aꞌ niiy wik inangan waaꞌān thant, ‘Aakan thinth-thinth kan-ngul wampana niiy God.an thathān nunanga nil moom piꞌan paththaman, nil pam wanch yotam maꞌ nungantang ngulan piꞌ-piꞌow thananga.’ ");
INSERT INTO wim_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","“Niiy nathwey wampin aak town thon-thonangan-a, puth than kaangk keꞌ nath niiyangan paanthathayn aak thanttang angman-a, niiyaniya aak town wakan iiy-iiyāna aꞌ niiy wik inangan thaw-thawān thant, ");
INSERT INTO wim_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Ngan thaꞌ wookan wunyathān aak inpalana, aꞌ ngan kan-ngul wantān niiyang niiy puth kaangk keꞌ wik nganttaman ngeey-ngeeyāna. Niiy wik inangan konangam piꞌ-piꞌāna: aakan thinth kan-ngul wamp-wampan niiyant, niiy yipam thathān nunang God.an moom piꞌan paththaman.’” ");
INSERT INTO wim_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Aꞌ nil Jesus.an thaw thant pam seventy-two al-alantan, “Aak keenkanamana pam wanch aak Sodom punchan anangana way-wayam paththam iiy-iiyina. Puth ngay inan kan-kanam waaꞌ-waaꞌāng niiyant, ngul-ngulana aak anan wampowana nil God.angan umang than-thanathow ngampangan-a, nil pam wanch aak Sodom punchan anangan wayanang ngul waaꞌow thananga aꞌ aak wayak kuchow thananga, puth pam wanch al-alangan kaangk keꞌan wik ngeeyayn niiyangan-a, nilan ngul waaꞌow thanang pam wanch anangan way-wayam paththam aꞌ puth nil kuchow thanang aak way aakanakana.” ");
INSERT INTO wim_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Anpalan-a, nil Jesus.an thaw thant ngul, “Niiyalang, pam wanch aak Chorazin punchan aꞌ putha aak Bethsaida punchanan-a, niiy kan in ngeeyān ngayang! Niiy kaangk keꞌ ey? wik min God.antaman ngeey-ngeeyān ey? Aꞌ aak wayan ngul wampow niiyant. Pam wanch keenkan wun-wunin aak Tyre angana, aꞌ aak Sidon.angan-a, than way anman yump-yumpina. Puth thanan nath work wuut piꞌan yimanangan thath-thathiythan keꞌ niiyan thath-thathaniy-a, an thanan puth ngangk way-wayam wun-wuniythana way thanttam anpalan aꞌ woyan way anpalan weentiythan ngula. ");
INSERT INTO wim_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ngul-ngulana, nil piip God.angan pam wanch um nungantangan than-thanathow ngampangan-a, nilan pam wanch aak Tyre aꞌ Sidon punchan anangana wayanang ngul waaꞌow thanang, aak way aakanakan ngul kuchow thananga. Puth God.angana pam wanch way-wayam paththam waaꞌow niiyang aꞌ kuchow niiyang ngul aak way aakanakan. ");
INSERT INTO wim_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Aꞌ niiy pam wanch aak Capernaum punchan anangana niiy in ngeeyāna: nil God.angan aak min nungantamakan ngul kalow niiyang ey? thaaꞌ-kuumpow niiyang ey? An yaꞌa, nil kuch-kuchow niiyang aak way aakanakana, puth niiyan wik God.antamana kaangk keꞌ ngeey-ngeeyān, yaꞌ anmana.” ");
INSERT INTO wim_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Amanamana nil Jesus.an kan-ngul thaw thant pam seventy-two al-alantan, “Than pam wanch weeꞌ-weeꞌanangan wik niiyantaman ngeey-ngeeyantan-a, an than keꞌ ngayang thama wik ngeey-ngeeyantana. Than pam wanch weeꞌ-weeꞌanangan keꞌaman wik ngeey-ngeeyantan niiyangan-a, an than um thaamp-thaampantan ngayanga, kaangk keꞌ wik min ngatharaman ngeey-ngeeyayna. Than pam wanch weeꞌ-weeꞌanangan um thaamp-thaampantan ngayangan-a, an than piip God.an um thaamp-thaampantan nunang thampa, pam anman nilan kuch ngayanga.” Nil Jesus.ana wik yimanangan thaw thant. Aꞌ than pam seventy-two anangana kan-ngul iiyin aak nath-nathakana. ");
INSERT INTO wim_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ngul-ngulana than pam seventy-two anangan ngangk minangam paththam ngul palaman wampin nungant Jesus.antan aꞌ thawin nungant, “Ayyang, moom-ang, ngan namp nungkaraman wich-wichana aꞌ anpalana nil God.angan maꞌ-aath-aath nganang work piꞌ-piꞌanam anangan yump-yumpān. Aꞌ ngan oony way anangan kenth-kenthan thanttam pam wanchantaman. Ngan namp nungkaraman wich-wichan-a, an paththam oony way anangan erkam pent-pentin thanttamana.” ");
INSERT INTO wim_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Puth nil Jesus.an thaw thant, “Eeꞌ, ngay kan thathang oony way piꞌan Satan anana karangk keꞌam ngul iiy-iiyan yaꞌa, ngay kan thathang nunang pal kenyuw keek keꞌ yuk ngaay yimanangan. ");
INSERT INTO wim_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","In ngeeyāna: ngay niiyang kan maꞌ-aath-aathang niiy yipam thayanam paththam iiy-iiyān ngula. Niiy nath thuuk aꞌ thalwey thaꞌang maak-maakin thanang-a, an than keꞌ mulathiythan niiyang yaꞌa. Nil nath oony way alangan thaachow niiyang way yumpanakan-a, niiyana um thaampān nunang. Nil keꞌ wayathow niiyanga, niiy ngangk thayanam ngul iiy-iiyān, nil oony wayana, chil-chil. An puth weeꞌangam wayathiy niiyang a? Yaꞌ anmana! ");
INSERT INTO wim_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Than oony way al-alangana kanam wik ngeey-ngeeyin niiyang puth niiy kenth-kenthan thanangana. Niiy nanpalan ngangk min keꞌ iiy-iiyāna, yaꞌa. Niiy wik inangan ep ngaantam-ngeey-ngeeyāna aꞌ ngangk min wun-wunow niiyanta: nil piip God.angan namp niiyantaman kanam ump lat nungantamangana niiy puth pam wanch nungantama.” ");
INSERT INTO wim_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Aak an-aniyangana nil Ngeen-Wiy Min God.antam alangan ngangk min paththam yump nunang Jesus.an aꞌ nilan thaw God.antan, “Piip-ang, nintiya moom wuut piꞌan paththama, aak naakanak kenyana aꞌ putha aak iikanak pekana. Ngay thankyou thaw-thawang nungkara nintan puth wik engkanang waaꞌ-waaꞌangan nungkarakaman pam wanch al-alantan than keꞌaman kuchek waap minakan waaꞌ-waaꞌwuntan. Puth nintaniya wik mupam piꞌ-piꞌangan nungkarakaman pam wanch al-alantaman thanan kuchek waap minakan waaꞌ-waaꞌwuntan. Eeꞌa, Piipa, puth nint kaangk yimanangan iiy-iiyān pam wanchantan.” ");
INSERT INTO wim_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Aꞌ nil Jesus.an thaw ngul thant pam wanch al-alantan, “Piip ngatharam God.angan maꞌmangkama maꞌ ngatharang want thanang. Nil weeꞌangam paththam thiichiy ngayang puk nhengk God.antamaniy e? Nil thonamang thonak piip God.angama. An weeꞌangam paththam thiichiy nunang piip God.ana? Ngay nhengk nungantamang ep thiichang nunang aꞌ putha than pam wanch wiy al-alangan ngayan waaꞌ-waaꞌang thant nil want-wanttakan wun-wunan than thamp ep thiichin nunang.” ");
INSERT INTO wim_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","24","Aꞌ nil Jesus.ana koy-koyyuw weent ngula ngurp nungantam al-alantan aꞌ wik itangam thaw thant, “Aak keenkanamana, pam prophets yota puth pam piꞌan kings anangan thanan kaangk paththam thathayna keꞌ niiy il-ilangan wanttakan thath-thathaniy, aꞌ puth thanan kaangk wik ngeeyayn thampanga keꞌ niiy il-ilangan wik wanttakan ngeey-ngeeyaniya, puth yaꞌa, an puth than keꞌam thathina, putha wik keꞌaman ngeeyina, yaꞌ anman. Niiyan puth kan thathana, aꞌ wik kanam ngeeyana, niiyana nanpalan ngangk minangam ngul iiy-iiyaniya.” ");
INSERT INTO wim_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Anpalan-a, nil paman wamp nungant Jesus.ant, nil pam inana, wik thayan God.antaman thaaꞌ-aath-aath thanang pam wanch anangana. Nil keꞌ Jesus.an paathiy nunang wik want-wanttakan thawow, nil puth thawant Jesus.antan, “Ayyang, Moom-ang, ngay ngeen yumpānga yipam ngay ngulakaman wun-wunāng God.antangan a?” ");
INSERT INTO wim_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Nil puth Jesus.an thawanta, “Nint lat ngench thayanan kan meeꞌmiy ey? want-wanttakan waaꞌan ey? nint wanttak ngaantam-ngeeyangan e?” ");
INSERT INTO wim_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Nil paman thaw Jesus.antan, “Yaa, lat ngench thayanangan wik inangan waaꞌana, ‘Niiy ngangk minangam anman iiy-iiyān God.antana, koochanam iiy-iiyān, man-kuchaman yaꞌa, aꞌ wik nungantam anangan ngangkangam piꞌ-piꞌān, wik maꞌmangkam anangan ngeey-ngeeyāna.’ Aꞌ putha latangan inan thamp waaꞌana, ‘Niiy paththam kaangk wunān pam wanch puk wiy al-alantana. Keꞌ niiyan min-minaman piꞌ-piꞌwuniy niiyantakaman-a, yaa, niiyiya yimanangan pam wanch wiy al-alantan ngangk minangam iiy-iiyān thant.’” ");
INSERT INTO wim_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Aꞌ Jesus.an thawant, “Eeꞌa, kan-kanama, nint min yimanangan iiy-iiyinweya aak inganiy-a, an nintaniya kan-kanam God.antang wun-wunān ngulakamana.” ");
INSERT INTO wim_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Nil pam alangan ngaantam-ngeey nungantakaman nil keꞌ pam min yimanang, nil puth thaw Jesus.antan, “Ngan pam wanch weeꞌ-weeꞌanta min iiy-iiyān thant e?” ");
INSERT INTO wim_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Aꞌ nil Jesus.angan wik kath inan waaꞌ, “Pam thonama aak Jerusalem anpalan woyan wak-wak um kungk aak Jerico.aka. Aꞌ than pam wayanang al-alangan woyan ompamang uwin nunang, aꞌ yuk way min nungantam anangana maꞌam piiy-piiyin nunang aꞌ piik-piikin nunang, warꞌam mulathin nunang, aꞌ angman puth too wantin nunang, chaapar ukanang wun-wun. ");
INSERT INTO wim_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Amanaman-a, nil pam thonangan woyan anman waka, puth nilaniya pam priest. Nil pam priest alangan thath nunang chaapar thaman wun-wun, puth thintham keꞌam iiy nungant, yaꞌa, woyan thonangan ngul wak. ");
INSERT INTO wim_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Anpalan-a, pam thonangan ngul woyan anman waka, puth nilaniya aawuch ngench thayanangan work iiy-iiyan. Nil iiy nungant, pam alantan, thintham thathan, puth yaꞌ, too want nunang, aꞌ puyamam ngul iiy, woyan thonangan ngul waka. ");
INSERT INTO wim_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“Yaam keꞌanam-a, pam thonangan ngul woyan anman wak. Nil pam inana thaaꞌnganth thonangana, aak anpal wamp Samaria.ama. Aꞌ angman wamp nungant nil pamana wun-wuna, chaapar thamangana, aꞌ ngangk mamana. ");
INSERT INTO wim_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Aꞌ nilana iiyant ngula, wine aꞌ oilan wench thaaꞌ nungantamangan wunp aꞌ bandage ongkang kathan ngula. Anpalana, paman maayan, aꞌ donkey nungantamang wunpan, aꞌ kalanwey aawuchak keꞌ motel yimanang aakanakan, puth nilam paanthathan angmana, min-minam piꞌ-piꞌana. ");
INSERT INTO wim_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","“Ngaaꞌ thon ngulana, nil wukal theeꞌ aawuch motel-kunch alantan, aꞌ thawant, ‘Nint min-minam piꞌ-piꞌān nunanga. Nint kaangk wukal puthamakanwey-a, ngay wukal puthaman ngul theeꞌāng nungkar ngay palaman wampānga.’” ");
INSERT INTO wim_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Aꞌ Jesus.an puth thaw nungant pam alantan, “Ayyang, nint wanttak ngaantam-ngeeyangana? Nil weeꞌang pam inan minam piꞌ-piꞌan e? Nil pam priest alangan ey? nath yaꞌa, nil pam alangan aawuch ngench thayanan piꞌ-piꞌ ey? nath yaꞌa, pam alangan thaaꞌnganth thon aak Samaria punchanangan ey?” ");
INSERT INTO wim_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Aꞌ paman thaw nungant Jesus.antana, “Pam anmana nilan ngangk mam nunang aꞌ maꞌ-aath nunang ngulana.” Nil Jesus.an thaw, “Yaa, puth nintaniya yimanangan ngangk mam-mamān thanang aꞌ maꞌ-aath-aathān thanang pam wanch wiy anangana.” ");
INSERT INTO wim_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","40","Amanamaniya, Jesus aꞌ ngurp nungantam anangan putham ngul iiyin aꞌ aak town angan wampin. Aak anganiya, pul-kuuncham wun-wunpula namp pulantiy-a, Martha aꞌ Mary. Than aawuch pulantamakan wampin-a, nil Martha.an ngangk minangam thaw thant ang ngoonchayn aawuch pulantamangana. Nil Martha.aniya work piꞌanang keꞌ-ngoongkam maꞌ ump-umpana. Nil Mary.an ep angman thaꞌ thinth nyiin-nyiin Jesus.antangan wik min anangan yipam ngeey-ngeeyow nungantama. Aꞌ Martha.antan-a, kuchek way wun nungant puth work piꞌan nungantam anangan ngaantam-ngeey-ngeeya. Aꞌ nil iiy ngul Jesus.antan, aꞌ thawant, “Ayyang, Moom-ang, nint want-wanttak ngaantam-ngeeyangan e? Kuunch ngatharamangan work yota ngatharakam wanta! Nint thawān nunganta nil kan ngayang mak maꞌ-aathow a!” ");
INSERT INTO wim_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Puth nil Jesus.an thaw nunganta, “Ayyang, Martha-ang, work nanan keꞌ ngaantam-ngeeyāna, kuchek wayan keꞌ wunow nungkar workamaniya. ");
INSERT INTO wim_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Puth an min nungkara wik ngatharam anman ngeey-ngeeyāna. Puth nil Mary ilangana kaangk paththam wik ngatharaman ngeey-ngeeyowa; ngayan puth keꞌ kenthing nunanga, yaꞌa.” ");
INSERT INTO wim_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Anpalan-a, Jesus-a, putha ngurp nungantam al-alangan kan wantin pulang Mary-a, putha Martha.anganiy aꞌ than aak thonak ngul iiyin. Nil Jesus.ana meeꞌ-wuth-wuthanam. Nil kanan thaw piip God.antan-a, ngurp nungantam thonaman thaw nungant, “Ayyang, moom-ang, nint maꞌ-aathān nganang ngan want-wanttakan meeꞌ-wuthanamān nungant God.antana, keꞌ nil John.angan maꞌ-aath thanang ngurp nungantam anangan than wanttakan meeꞌ-wuthanamayn God.antan.” ");
INSERT INTO wim_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Aꞌ nil Jesus.an thaw thant, “Niiy kaangkwey thawān God.antan-a, niiyiya wik yimanangan thawān nungant: ‘Piip nganttam in kenyana, ngan kaangk pam wanch maꞌmangkamangana waaꞌayn nintang wuut piꞌan, aꞌ minam paththaman a! Ngan kaangk nint moom wuut piꞌan iiyān ngant, pam wanch yotamantana, ngan yipam maꞌ nungkarang wunāna, maꞌ wiyantangan yaꞌa. Ngan kaangk pam wanch maꞌmangkamangan wik nungkaraman ngeeyayn, aꞌ woyan min koochanam nungkaram anman wak-wakayn. ");
INSERT INTO wim_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Piip-ang, kinch inana nganangan maꞌangam piꞌān ngan yipam may minh thakan uwāna. ");
INSERT INTO wim_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Nint nganang ngangk mamān aꞌ putha kon-ngathow nintang way yot anangan nganan yump-yumpan, puth ngan ngangk maman thanang, kan kon-ngathan nganang way thanan yump-yumpin ngant. Nint weekān nganang oony way alantaman, aꞌ kalān nganang woyan way anpalan ngan yipam way keꞌ yumpān. Yey, piipa, anman kana.’” ");
INSERT INTO wim_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Aꞌ nil Jesus.angana wik kath inan waaꞌ thant, “Niiy nathwey kampan niiyantamak iiyin aak ngaaꞌ-menhanga aꞌ thawin nungant, ‘Nint may bread koꞌalam theeꞌān ngatha ");
INSERT INTO wim_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","nil puth kampan ngatharam anan wamp aak kechama, ngay puth ngeen theeꞌinganta, ngaya may keꞌananga.’ ");
INSERT INTO wim_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","An nilan nath thawiy niiyant aawuch amanam pekan, ‘Nint puy kan iiyāna, ngayang keꞌ weepaman ekathāna, ngay thaaꞌan kanam ngathang. Ngan yot weep ngula. Ngay keꞌ ekinga aꞌ putha may keꞌ theeꞌing nungk yaꞌa. Nint koyam kan iiyāna.’” ");
INSERT INTO wim_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Aꞌ puth nil Jesus.an thaw thant, “Nilan puth kampan nungkaram aa! Nilana keꞌ theeꞌiy nungk. Puth nintwey yaamakam thaaꞌan piik-piikin-a, aꞌ putha yaaman thaw-thawin nungant-a, an nilaniya ekiy nungkar aꞌ mayan theeꞌiy nungkar. ");
INSERT INTO wim_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","10","Yaa, ngay puth inan waaꞌāng niiyant. Nil weeꞌ-nathan thawiy nungant God.antan maꞌ-aathow nunang-a, an nil God.angan maꞌ-aathow nunang. Nil weeꞌ-nathan woyan God.antamakan wenk-wenkiy-a, an nil God.angan ngul meenathow nungant. Nil weeꞌ-nathan meeꞌ-wuthanamiy nungantan-a, nil God.angan ngul ngeeyow nunang. Yaa, niiy woyan min nungantamakan wenk-wenkān, aꞌ puth God.antan thawān nungant maꞌ-aathanakan. ");
INSERT INTO wim_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Than puk niiyantamwey thawiythan niiyanta minh ngaꞌakan-a, ngul niiy thuuk theeꞌin thant puk niiyantamakan ey? Yaꞌa, an minh min theeꞌin thantweya. ");
INSERT INTO wim_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Aꞌ thon ina, than puk niiyantamwey thawiythan niiyant minh nhepanakan-a, ngul niiy thal theeꞌin thant ey? Yaꞌa. ");
INSERT INTO wim_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nungkway niiy way iiy-iiyaniy-a, niiy min-minam piꞌ-piꞌaniy thanang puk niiyantam anangan. Puth niiy kan ngaantam-ngeeyān nunang piip God.ana. Nil ep min-minam paththam iiy-iiyan. Niiy weeꞌ-weeꞌanangan thawin nungant God.antan-a, nilana Ngeen-Wiy Min nungantaman kuchow niiyant, ngangk niiyantamangan yipam wun-wunow.” ");
INSERT INTO wim_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Amanamana nil Jesus.angana paman thath nunang oony way ngangkangan piꞌ-piꞌ, nanpalan nil pam anmana keꞌam wik thaw-thawa, yaꞌa. Nil Jesus.angan oony way anana yaꞌ kenth nunang pam alantaman aꞌ oony way alangan too paththam want nunang. Anpalaniya, nil pamana kan-ngul wikan thaw-thaw, puth pam wanch yotamana thaaꞌam ikin. ");
INSERT INTO wim_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Than wiyaniy thawina, “Nil Beelzebul, oony way piꞌan alangana, pam Jesus inan maꞌ nungantang piꞌ-piꞌan nunanga, aꞌ maꞌ-kunch yump-yumpan nunang keꞌ-paal nil Jesus.angan oony way anangan kenth-kenthan thanang pam wanch al-alantamana.” ");
INSERT INTO wim_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Puth pam wanch wiyaniya thawin Jesus.ant work piꞌan yumpow thant than yipam thathayn nil pam God.antam kan-kanamana. Than yaan thawin nungant nil nath yumpiy, nath yaꞌ, keꞌ yumpiy. ");
INSERT INTO wim_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Nil puth Jesus.angana kanam thiich thanang than want-wanttakan ngaantam-ngeeyin nunangana, aꞌ nilan thaw thant, “Than kampanam nathwey pek-pekwiythan-a, aꞌ thaamp-thaampwiythan thanttakamwey-a, yaa, thanan aak wayathiythan, minam keꞌ piꞌwiythan thanttakamana, yaꞌa, aak thanttamana thayanam keꞌ piꞌiythan, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Nil oony way alangan nathwey oony way wiy anangan piik-piikiy thanang-a, pek-pekwiythan thanttakaman-a, thanan thampang aak thanttaman wayathiythan, aak thayanaman keꞌ piꞌiythan, yaꞌa, karangk keꞌ-ngul iiyayn, yaꞌa. Niiyan ngayangan waaꞌaniy keꞌ nil Beelzebul alangan maꞌ-kunch yumpan ngayang yipam oony way anangan kenth-kenthāng thanang pam wanch al-alantamana, puth yaꞌa. ");
INSERT INTO wim_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Nilwey oony way piꞌan alangan nath maꞌ-kunch yumpiyan ngayang-a, puth nil weeꞌanga ngurp niiyantam anangan maꞌ-kunch yumpan thanang oony way anangan yipam kenthayn pam wanchantaman e? Nil oony way piꞌan alangan ey? An yaꞌa, puth than ngurp niiyantam thawayn ngul nil oony way alangan keꞌ maꞌ-kunch yumpan thanang, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Puth ngay inan thawang niiyant: nil God.angan ngayang ep-paththam maꞌ-kunch yumpana, ngay yipam oony way anangan kenth-kenthāng thanang pam wanchantamana. Yaa, puth amanamana, niiy meeꞌmiy ngul aakan kan wamp nungant God.antan meenathow nungamangan nil moom piꞌan paththamana.” ");
INSERT INTO wim_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","22","Amanamaniya nil Jesus.angan wik kath waaꞌ thant, “Nil pam nathwey karangk iiy-iiyiy aꞌ nhengk-peempan-a, putha kek yotwey piꞌ-piꞌiya, aawuch nungantam angman. Nil aawuch nungantamana min-min thath-thathiy aꞌ yuk way min nungantam min-minakam piꞌ-piꞌiya. Nil meeꞌmiy nil nhengk-peempan thampana, kek thampa, nilan keꞌ-paal ngangk thayanam iiy-iiyan. Puth nil pam thonan karangk paththaman nath wampiy nungant-a, aꞌ maꞌang nath thanpiy nunang-a, tal nath unchiy nunang-a, yaa, nilana nhengk-peempan, kek thakan pam alantaman maꞌam piiyiy nunang, aꞌ theeꞌiy thant pam wiy al-alantan.” ");
INSERT INTO wim_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Anpalana, nil Jesus.an thaw thant, “Than pam wanch weeꞌ-weeꞌanangan keꞌan iiyiythan ngatharangan-a, an than thaampantan ngayang, kaangk keꞌ ngatharam. Aꞌ than weeꞌ-weeꞌanangan keꞌan maꞌ-aathiythan ngayang pam wanch wiy anangan yipam wampayn nungant piip God.antan-a, an than keꞌ puy-puyam yaark-yaarkathantan thanang piip God.antaman.” ");
INSERT INTO wim_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Aꞌ nil Jesus.angan putham ngul wik kathan waaꞌ thant, “Nil oony way alangan paman wantan ngulan-a, an nilaniya aak pal-puy aak way wakan iiy-iiy, aak min yaꞌa, nilaniy puth aakak wenk-wenk nil wanttingan wunow. Nil oony way alangan aak keꞌan uwiy nungantakaman-a, nil puth nungantakaman thawiya, ‘Ngay kan koyam iiyāng aak ngatharamaka pam alantangan ngangkang koyam ngoonchāng.’ ");
INSERT INTO wim_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Nil oony way koyam ngulan wamp nungant-a, nil aak yaꞌ-yaꞌam thathana, nil puth pam alangan Ngeen-Wiy Min God.antaman thaampan nunang yippak, ngangkangan keꞌam yippak ngoonchant. ");
INSERT INTO wim_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Anpalana, nil oony wayan koyam ngul iiyan aꞌ oony seven way-wayam paththaman wampathan thanang yipam than ngangk nungantangan wunayna. Than oony way yotam ngangkang ngulan ngoonchantan nungantangan-a, nil paman way-wayam paththam ngul iiy-iiyana, keꞌ nil keenkan iiy-iiy, yaꞌa.” ");
INSERT INTO wim_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Nil Jesus.angan wik inangan kanan waaꞌ-a, nil wanch thonam thaaꞌ-ay thaw nungant, “Kaath nungkaramana ngangk min iiy-iiyana! Nil puth thipang kal nintang aꞌ putha thuut nungantam aath-aath nintang tham.” ");
INSERT INTO wim_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Aꞌ nil Jesus.an thaw nungant, “Than pam wanch weeꞌ-weeꞌanangan wik piip God.antaman ngeey-ngeeyantana aꞌ ngangkangan piꞌ-piꞌantan-a, thanan ngangk minangam iiy-iiyantan.” ");
INSERT INTO wim_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Amanamana pam wanch yot ngul wamp-wampin nungant Jesus.antan, aꞌ nilan thaw-thaw thant, “Niiy inangan wunaniy-a, way-wayam paththam iiy-iiyaniya, niiy God.an keꞌ ngaantam-ngeeyaniy nunang, yaꞌa! Niiy kaangk ngay work piꞌan anman meen-meenathāng niiyantan ey? Niiy work piꞌan thonam thonakam ngul thathāna. Niiy ngul thathāna ngay keꞌ Jonah anman. ");
INSERT INTO wim_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Niiy kan ngaantam-ngeeyaniy nunang Jonah.an ey? Minh ngaꞌ wuut piꞌanangan lokang thuꞌ nunang, thipang ngulan piꞌ-piꞌan, kinch maꞌ-koꞌalamakana. Anpalana, nil ngul oyngk yeechan, aꞌ pam Jonah.ana thaaꞌaman pol pent man-yetham anmana. Anpalana than pam wanch aak Ninevah.angan thiichin nunang ngul, nil puth pam God.antaman. Niiy thamp ngul meeꞌmiy iiyān nil God.angan kuch ngayang. ");
INSERT INTO wim_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Aꞌ niiy wik kath Queen aak Sheba punchan alantaman kan ngeeyan ey? Yaa, nil Queen inana aak kechak moꞌ aak King Solomon.antamaka, nil yipam wik ngeeyow nunang, puth nil pam piꞌan Solomon.ana kuchek waap min-minam paththam iiy-iiy. Wik nungantaman mina, puth wik inangan ngayan thaw-thawang niiyantana an ep-paththam min-minam paththam. Ngul-ngulaniya, nil piip God.angan umang than-thanathow niiyangan-a, nil Queen aak Sheba punchanana ekow, aꞌ way waaꞌow niiyang, puth niiyan wik min-minam ngangkangan keꞌam piꞌ-piꞌaniya, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Aꞌ than pam wanch anangan aak Ninevah.angan wun-wunin, than way waaꞌ-waaꞌayn niiyang, aak an-aniyangan nil God.angan um nungantangan than-thanathow ngampang, puth aak keenkanamana than wik min God.antaman ngeeyin nil pam Jonah alangan waaꞌ-waaꞌ thant aꞌ thanana woyan wayan keꞌ-ngul wakin, yaꞌa. Nil Jonah.angan wik min waaꞌ-waaꞌ thant, puth niiy inangana ep-paththam wik ngatharaman ngeey-ngeeyāna, wik min paththam anangan, puth niiy yaam anman wayan yump-yumpaniy aꞌ keꞌam yippak wayan wantana, yaꞌa.” ");
INSERT INTO wim_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Nil Jesus.an putham thaw thant, “Thon inan waaꞌāng niiyant. Nil pamangweya nath lantern pathathiywey-a, an nil wuthanangan keꞌ thenchiy nganthaniya, yaꞌa, nil yuk paathangan keꞌ kangiy, yaꞌa. An nil pam alangan keny achantang waanchow pam wanchangan yipam nganthan thathayn than aawuchangan ngoonchaynana. ");
INSERT INTO wim_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Meeꞌ niiyantam anangan-a, keꞌ nganth yimanangan kemp niiyantamakan. Niiywey meeꞌ minangaman iiy-iiyinwey-a, an keꞌ niiy nganth piꞌanang yimanangan iiy-iiyaniy. Niiy nath meeꞌ way thampangan-a, an keꞌ niiy aak ngaaꞌang yimanangan iiy-iiyaniy. ");
INSERT INTO wim_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Yaa, niiy kan-kanam woyan min paththam wak-wakāna, niiy keꞌ yipam keꞌ aak ngaaꞌangan iiy-iiyāna. ");
INSERT INTO wim_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Niiy nath ngangk punch-aakam theeꞌān piip God alantan-a, aꞌ kan-kanam monkan-wak-wakān nunangan-a, yaa, niiyan keꞌ nganth piꞌan paththam park-parkān, keꞌ ngaaꞌ keꞌanang yimanangana. An keꞌ nganth piꞌanam park-parkow niiyantang.” ");
INSERT INTO wim_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Nil Jesus.angan wik inangan kanan waaꞌ-waaꞌ-a, nil pam thonam Pharisee.ana thaw ngul nungant Jesus.antan, “Nint may mungkān aawuch ngatharamanga.” Aꞌ nil Jesus.ana iiy ngul nungantang, aꞌ pul nyiinpul ngul mayakan. ");
INSERT INTO wim_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Nil pam Pharisee alangana Jesus.an oth thath-thath nunang maꞌ keꞌ punganaman mayan mungka, aꞌ nilaniya thaaꞌam ika. ");
INSERT INTO wim_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Nil puth Jesus.angan kanam thiich nunang nil want-wanttakan ngaantam-ngeey aꞌ nil thaw ngul nungant, “Niiyant Pharisees il-ilantana aak niiy-niiyant yimanangan wunana; niiyaniy-a, yuk cups-a, plates anangan maꞌ-yotam pung-punganiya aꞌ pach-pachathaniya! puth niiy ngangk niiyantaman keꞌam pach piꞌ-piꞌaniy yaꞌa, niiy puth pam yangk moꞌ-moꞌaniy, way-wayam paththam iiy-iiyaniya. ");
INSERT INTO wim_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Niiy way-wayak ngaantam-ngeeyaniy niiyantakamana. Nil puth piip God.angan yump ngampang, kemp inangan kal-kalanamp-a, aꞌ nil ngangk ngamparam yam pekan yump thampa. ");
INSERT INTO wim_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Niiy may aꞌ wukal thakan nath theeꞌ-theeꞌin thant pam wanch wiy al-alantan-a, than may wukal keꞌanangan wun-wuntan-a, yaa, puth niiyana pam wanch min-minam paththam iiy-iiyin ngula. ");
INSERT INTO wim_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Aak wayan ngul wampow niiyant, Pharisees il-ilantana, puth niiy ngangk minangam keꞌam iiy-iiyaniy pam wanch wiyantan, niiy keꞌ-ngoongkam ngangk-wayangam kal-kalaniy thanang, aꞌ God.an thama, niiy keꞌam kaangk wun-wunaniy nungant, yaꞌa. Niiy ep yuk way min theeꞌ-theeꞌaniy nungant piip God.antan, wukal wiy niiyantaman churchak kal-kalaniy aꞌ yuk awal min thakan theeꞌ-theeꞌaniy nunganta. Niiy kanaka wukal thakan kal-kalaniy churchakana, niiy puth wiyantan yimanang thamp ngangk minangam iiy-iiyān aꞌ piip God.ant thampa. ");
INSERT INTO wim_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Aak wayan ngul wampow niiyant Pharisees il-ilantana, puth niiyan kaangk aak umang anman nyiin-nyiinān aak churchangan keꞌ pam piꞌ-piꞌanam yimanangan aꞌ niiy kaangk pam wanch anangan thaaꞌ-mich-micham thawayn niiyant aak town wakanana, keꞌ niiy pam piꞌ-piꞌanam min paththam yimanangan. ");
INSERT INTO wim_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Pam wanch wiy il-ilangana nath ngaantam-ngeeyiythan niiyang keꞌ pam min-miniy yimanang iiy-iiyaniya, an yaꞌa, puth than keꞌam thiichantan niiyang pam wayanangan iiy-iiyaniya.” ");
INSERT INTO wim_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Amanamana, nil pam thonangan ngul thaw nungant Jesus.antan, nil pam inana teachera, wik thayan Moses.antam anangan thaaꞌ-aath-aath thanang pam wanch anangana. Nilan thaw nungant Jesus.antan, “Ayyang, teacher-ang, nint yimanangan wanttak thaw-thawangan nganta? An nint wak-wakangan nganang thampa!” ");
INSERT INTO wim_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Nil puth Jesus.an thaw nungant, “Aak way ngul wampow niiyant thamp pam teachers il-ilantana. Niiy wik thayan Moses.antaman waaꞌ-waaꞌaniy pam wanchantan putha wik thayan niiyantam anangan thama. Than puth want-wanttak ngeeyayna wik thayan niiyantam yot anangana, an yaꞌa, puth an keꞌ yuk anhan yimanangan kal-kalantan pikpungkangana. Aꞌ niiy thamp wik thayan niiyantamana pip-pipaniya, keꞌam ngeey-ngeeyaniy yaꞌ anmana. Aak wayan ngul wampow niiyanta. ");
INSERT INTO wim_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","48","Aak keenkanamana, wuut mangk niiyantam al-alangan kaangk keꞌ thanang pam prophets anangana, puth thananiya prophets al-alangan wik min God.antaman waaꞌ-waaꞌin thanta. Than wuut mangk yotam niiyantam al-alangan prophets anangan mul-mulathin thanang aꞌ kaamp-kaampin thanang ngula. Niiyana puth yaan graves thanttam anangan ach-umpanam yump-yumpaniya kunttow thakan pal kenyuw wunp-wunpaniya. Puth ngangk min wunan niiyant pam prophets anangan kanaman mulathin thanang keenkanamana. ");
INSERT INTO wim_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Nil God kuchek waap min-minam paththamana. Nila wik inangan keenkanaman thawa, ‘Ngay puth pam wanchantan pam prophets anangan kuch-kuchānga aꞌ putha pam wiy thampang kuch-kuchāng wik min ngatharaman waaꞌ-waaꞌayn thant. Puth pam wiy anangana, keꞌ-ngoongkam mul-mulathayn thananga aꞌ puth wiyantan way thakan yump-yumpayn.’” ");
INSERT INTO wim_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Aꞌ Jesus.angan kan-ngul waaꞌ thanta, “Aak keenkanamana, wuut mangk niiyantamang pam anangan mul-mulathin thananga wik min ngatharaman waaꞌ-waaꞌina. Kaꞌathamaniya than pam min Abel anan mulathin nunanga, puk pulantama Adam-a, Eve.angana. Anpalana, than pam God.antam yot mul-mulathin thanang aak-aakanakaman nil Zechariah.an ngul wun. Aꞌ than nunang thamp mulathina, aawuch ngench thayanang angman, yuk altar thinth minhan kiingk-kiingkantan, piip God.antana. Puth nil God.angana ngul wayathow niiyang yotam pam wanch inangan man-yethaman iiy-iiyaniya, puth wuut mangk niiyantamangana pam God.antam anangan mul-mulathin thananga.” ");
INSERT INTO wim_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Anpalana, nil Jesus.an kan-ngul thaw thant pam teachers al-alantan than wik thayanan thaaꞌ-aath-aathinan, “Niiy kan wik in ngeeyāna! Aak wayan ngul wampow niiyanta! Puth niiy muuk-muukamathaniy thanang pam wanch wiy anangana! Puth niiyana pam wanch anangana way-wayathaniy thanang than kaangkan meeꞌmiy weenayn wik min God.antamakan, aꞌ niiyaniya wik God.antamana way-way thaaꞌ-aath-aathaniy thananga. Puth niiyaniya woyan min God.antaman keꞌam wak-wakaniya, yaꞌa. An keꞌ yimanang wunana: niiy thaaꞌ aawuchan key.angan ngath-ngathaniya thanttam wiyantamana, aꞌ niiyaniya key maꞌangam piꞌ-piꞌaniya than yipam pam wanch wiy anangana keꞌ yipam ngoonchayn aawuchangan. Aꞌ niiy thamana yoon angman than-thananiya, thaaꞌan week-weekaniy pam wanchantamana.” ");
INSERT INTO wim_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Nil Jesus.angan aak anan kanan want-a, than pam teachers al-alangana putha Pharisees wiy al-alangan way waaꞌ-waaꞌin nunang. Aꞌ than puth-puthaman mep-mepin nunanga. ");
INSERT INTO wim_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Thanan yaana mep-mepin nunanga, nil yipam want-wanttakan nath thawow thanta, wik way nath thawow thant, than yipam way waaꞌayn nunanga. ");
INSERT INTO wim_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Amanamana pam wanch yot thinth-thinth wamp-wampin nungant Jesus.antan, thananiya thaꞌ thak maak-maakwin. Aꞌ nil Jesus.an ngurp nungantam al-alantan thaw thant, “Niiy woyan min anman wak-wakāna. Niiyiya woyan Pharisees.antaman keꞌ wakāna. Than puth muukamantan keꞌ than pam min-miniy yimanangan iiy-iiyantan, puth yaꞌa. Niiy meeꞌ yanth-yanth iiy-iiyān thanttamana. ");
INSERT INTO wim_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Niiy nath meeꞌ thenchanam way iiy-iiyaniya, puth ngul-ngulana, pam wanch yotamang thiichayn niiyang. ");
INSERT INTO wim_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Niiy ngeen nathan waaꞌ-waaꞌan aak ngaaꞌangan-a, pam wanch yotangan ngul ngeeyayn aak kinchangana. Niiy ngeen nathan wik thaaꞌ-yaakangan waaꞌ-waaꞌan aawuch ang pekan-a, ngul-ngulana wik othamayan pech-pechayn meeꞌ yotantangana.” ");
INSERT INTO wim_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Aꞌ nil Jesus.an thaw ngul, “Niiyala, ngurp ngatharam-ang, ngay inan waaꞌāng niiyant, niiy keꞌ winynyang moꞌān pam wanch al-alantaman mulathaynan niiyangana; than kemp thonakam mulathiythan niiyanga, ngangk niiyantaman yaꞌa, keꞌ mulathiythan, aꞌ keꞌ kuchiythan niiyang aak wayakana, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Niiy thonamantaman ep winynyang moꞌān, piip God.antamana nil epa mulathiy niiyang, aꞌ putha ngangk niiyantamana ep kuchiy aak wayakan. Yaa, puth niiyangan keꞌ kon-ngathow wik inpalana: niiy God.antaman winynyang moꞌāna! ");
INSERT INTO wim_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Puth niiy kan wik inan ngeeyāna: niiy minh panch five sparrows nath piiyina wukal manyanga, keꞌ five centsang yimanangana. Nil puth piip God.angana maꞌangam piꞌ-piꞌan thanang, nil konangam piꞌ-piꞌan thanang yotaman, nilan keꞌ kon-ngathiy thanang minh panch anangan, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Aꞌ putha nil niiyang thamp thath-thathana. Puth yangan niiyantam nanangan nil God.angan ep meeꞌmiy ngeen-ngeenan piꞌ-piꞌaniy kuchek niiyantamangan. Yaa, niiyan keꞌ ngangk winynyang moꞌān God.antamana, nil kaangk paththam wunan niiyant, niiyaniya pam ngurp paththam min iiy-iiyaniy meeꞌ nungantang, minh panch anangan yaꞌ chil-chil.” ");
INSERT INTO wim_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Aꞌ nil Jesus.an thaw ngul, “Ngay thon inan waaꞌāng niiyant. Nil pamwey nath thawiy meeꞌ yotantangana, ‘Nil Jesus.an moom ngatharama, ngay pam nungantam inan iiy-iiyanga,’ yaa, ngayiya, pam inman nil God.angan kuchanya, ngayan puth ngulan thawāng thant ngaantiyongk God.antam al-alantan, ‘Nil ngayang anman monkan-wak-wakan, nil puth pam ngatharamweya.’ ");
INSERT INTO wim_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Puth nil pamwey thawiya meeꞌ yotantangan-a, ‘Nil Jesus.an moom ngatharam yaꞌa, ngayan puth keꞌam iiy-iiyang nungantangana,’ yaa, ngayan puth ngul thawāng ngaantiyongk God.antam al-alantana, ‘Nil ngayang keꞌam monkan-wak-wakanya, yaꞌa, nil pam ngatharam yaꞌa.’ ");
INSERT INTO wim_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Than wiy al-alangan nath wik way thakan waaꞌiythan ngayangan-a, ngay pam inman nil God.angan kuch ngayang-a, an ep nil nath piip God.angana keꞌ-ngul ngaantam-ngeeyow wik thanan waaꞌ-waaꞌin ngayangana. Than puth weeꞌ-weeꞌanangweya wik way thakan waaꞌ-waaꞌiythan nunanga Ngeen-Wiy Min God.antaman-a, nil puth God.aniya keꞌ kon-ngathiy nunang thanan wayan waaꞌ-waaꞌin nunang, yaꞌa, anman konangam piꞌ-piꞌow aak umpuyam. ");
INSERT INTO wim_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Aꞌ in thamp ngeeyāna: pam wanchangan ngul nath kalayn niiyang courtakan aꞌ umang thanathayn niiyang wuut manth-thayan al-alantang aak church angman, aꞌ puth court thonangan pam piꞌ-piꞌanam Government al-alantangan. Aꞌ thananiya waaꞌayn niiyang aak-yaꞌang thakan niiy puth pam ngatharam. Niiyantaniy kuchek keꞌ wayamowa, puth keꞌ ngaantam-ngeeyān niiyantakaman, ‘Ngay wik ngeen thawāng e? Ngay want-wanttaka wik min thawāng e?’ ");
INSERT INTO wim_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Yaꞌa, niiy keꞌ ngaantam-ngeeyān yimananganiya, nil Ngeen-Wiy Min God.antam alangan ngul waaꞌow niiyant niiy wik wanttakan thawān thant.” ");
INSERT INTO wim_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Anpalan-a, nil Jesus wik thaw thant pam wanch yotamant. An-aniyangan-a, pam thonam thawant, Jesus.ant, “Ayyang, Moom-ang, nint keꞌ thawin kuunch ngatharamant ey? wukal wiy ngathar theeꞌowa, piip nganttamangan want nganta, nil puth kanam uthama.” ");
INSERT INTO wim_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Nil puth Jesus.an thaw pam alantan, “Appang, ngay moom niparam yaꞌa! Than keꞌam thawin ngathar ngay wukal thakan yaarkathāng nipara!” ");
INSERT INTO wim_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Aꞌ Jesus.an thaw thant pam wanch yotamantan, “Niiyalang, keꞌ yangk moꞌāna! Yuk way min-weenth keꞌ iiyāna! Niiy nungkway yuk way min yot-yotam piꞌ-piꞌin-a, an puth niiyan keꞌ ngangk min iiy-iiyin yaꞌa! ");
INSERT INTO wim_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Niiyalang, ngay wik kath inan waaꞌāng niiyant, wik kath pam maꞌmangkiyantama pam nilan farm piꞌanan piꞌ-piꞌ. Nil may thakan thaaꞌ-wantanam em-emath. ");
INSERT INTO wim_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Nil ngaantam-ngeey, ‘May inangan wanttak aa! aak wantting yaakaꞌ wunpāng thanang may inangan a! Puth shed ngatharaman many a! Mayangam puth kan thaaꞌ ngatha!’ ");
INSERT INTO wim_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Nilan ngangkaman thaw, ‘Ngay pam ngatharam al-alantan ngul thawāng sheds ngatharaman thuthayn aꞌ than sheds yot piꞌ-piꞌanam kaachayn ngathara, than may yot anangan yipam angan wunpayn ngathar sheds piꞌanang. ");
INSERT INTO wim_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Aꞌ ngay ngul ngaantam-ngeeyāng ngatharakamana, “Ngay paththam maꞌmangkiy a! Ngay puth ngathar may thakan yot-yotam piꞌ-piꞌanga, an yaam wunayn, keꞌ minchiy ngathar. Ngay puth work keꞌanang ngul nyiinānga, ngay may minh thak mungk-mungkāng anman, ngangk minangam wun-wunānga.” ’ ");
INSERT INTO wim_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Anpalana, nil God.an thaw pam alantan, ‘Nint weenth a! yuk way min aꞌ may thakan nungkarakam yal-yalmathan, puth nint ngutang inman uthamān a! Ngul may thak nungkaram inangan weeꞌang maayow ee? nintan piꞌ-piꞌangan nungkarakamana?’” ");
INSERT INTO wim_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Aꞌ nil Jesus.an thaw thant, “Wik kath inaniy yimanangan wunan a! Niiy weeꞌ-weeꞌanangan yuk way min yot yal-yalmathaniy niiyantakaman-a, an niiy keꞌ pam maꞌmangkiy yimanangan iiy-iiyaniy, puth niiy wiyant yuk way min keꞌam theeꞌ-theeꞌaniy, yaꞌa, aꞌ niiy God.an kon-ngath-ngathaniy nunang. An puth meeꞌ God.antangan min yaꞌa.” ");
INSERT INTO wim_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Aꞌ nil Jesus.an thaw thant ngurp nungantam al-alantan, “Ngay inan waaꞌāng niiyantana: niiy yaam keꞌ ngaantam-ngeeyān may-a, puth-a, ngook thakan, aꞌ yaam keꞌ ngaantam-ngeeyān niiy ngul want-wanttakan minam piꞌ-piꞌān niiyantakaman. ");
INSERT INTO wim_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Niiy ngul aak ingan wunaniy may mungkanak thonakam ey? aꞌ putha ngook min-miniy ngoonchanak ey? Yaꞌa! ");
INSERT INTO wim_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Niiy waath anangan thathāna! Ngul than may kaanch anangan kaampantan thanam ey? Yaꞌa! Aꞌ than may kaanch anangan yal-yalmathantan aꞌ aawuchang ngul piꞌ-piꞌantan ey? An yaꞌa! Nil piip niiyantamang God.angan min-minam piꞌ-piꞌan thanang. Nil niiyantan ep-paththam kaangk wunan, puth minh panch al-alantan yaꞌa, chil-chila! Nil niiyang pam-a, wanch-a, puk manyiy tham minam paththam piꞌ-piꞌan niiyanga. ");
INSERT INTO wim_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Kuchek way nath wunowan niiyant mayam thakan-a, ngul niiy yaam man-yethaman wun-wunān ey? Yaꞌa. ");
INSERT INTO wim_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Yaa, kuchek way keꞌ wunow niiyant mayam thakan, niiy kon uth anman iiy-iiyān nungantang, piip God.antangan, nil puth minam piꞌ-piꞌan niiyang. ");
INSERT INTO wim_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Niiy thathāna, may kooth aꞌ putha pach yot em-emantana. Than pach yot al-alangan kulich thanttakam keꞌam wak-wakantan, yaꞌa. Thon in ngaantam-ngeeyān pam King Solomon.ana, nilaniya pam maꞌmangkiya ngook min-minam anangan ngoonch-ngoonch. Than pach anangan ach-umpanam min paththam aa, puth ngook King Solomon.antamana, an chil mina! ");
INSERT INTO wim_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Aꞌ putha wak thakan emantan-a, an ach-umpan thama. An yaan thonakam wunan wak erpan, kan-ngulana, kathaman ngul aꞌ ngamp thumang ngul kiingkanamp. Nungkway wakan yaam keꞌam wunan-a, nil God.angan min ach-umpanam yumpan, aꞌ minam piꞌ-piꞌan. Ngul nil niiyangan thamp minam keꞌ piꞌ-piꞌow ey? In ngeeyiya: nil niiyang min-minam paththam piꞌ-piꞌana, pach-a, puth wak anangan chil-chil piꞌ-piꞌan thananga. Niiyiy puth min-minam keꞌam ngaantam-ngeeyaniy nunang God.an nil minaman piꞌ-piꞌan niiyang. Niiyana min-minam ngaantam-ngeeyān piip God.an nil maꞌ-kaaꞌ-minangaman piꞌ-piꞌan niiyang. ");
INSERT INTO wim_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Kuchek way keꞌ wunow niiyant puth keꞌ ngaantam-ngeey-ngeeyān may wanttinpalan uwāna, aꞌ putha ngook thakan wanttinpalan uwāna. ");
INSERT INTO wim_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","(Puth pam wanch anangan than keꞌaman thiichin nunang God.ana than ngaantam-ngeey-ngeeyantan may thakan wanttinpalan uwayna.) Nil puth piip niiyantam God.angan kan meeꞌmiy niiyang may-a, puth ngakan kaangk mungkānweya, aꞌ puth ngook thakan kaangk piꞌān niiyantakamweya. ");
INSERT INTO wim_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Yaa, niiyiy putha ngangk punch-aakam theeꞌwun maꞌ God.antang, aꞌ puth ngeey-ngeeyān nunang, aꞌ nilaniya ngul maꞌ-aath-aathow niiyang may uwanakan, putha way min kulich thakan uwanakan. ");
INSERT INTO wim_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Niiyiya pam koꞌalam thonakama, yotwey yaꞌa. Niiy puth keꞌ winynyang moꞌāna, puth ngul-ngulana God.angan ngul miꞌow niiyang yipam moom iiy-iiyān nungantang. ");
INSERT INTO wim_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","34","Yuk way min maꞌmangkam niiyantam anangan sellimpungān. Aꞌ niiyiy wukal niiyantam anangan thant pam wanch wukal keꞌanang al-alantan theeꞌ-theeꞌān. Niiy nath kaangkwey wukala putha way min yotan yal-yalmathān niiyantakaman aak inganiy-a, an puth niiy yuk way min anman ngaantam-ngeey-ngeeyaniy thonakama. Inan way paththama! Niiywey nath kaangk wunin nungant God.antan-a, an niiy ngaantam-ngeey-ngeeyaniy nunang, ngangkangam piꞌ-piꞌaniy nunang. Anpalaniy-a, nil ngul kalow niiyang aak min nungantamakan. Aak in kenyan nungantamana an ep keꞌ wayamiy yaꞌa, an min-minam anman wun-wunow aak umpuyam. Pamangan way min keꞌ maꞌ-kuchathiythan aak God.antam anpalan, yaꞌa, puth yuk cockroachesang thakan keꞌ wayathiythana yaꞌa, minam anman wun-wunayn ngulakama.” ");
INSERT INTO wim_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Aꞌ nil Jesus.angan wik kath inan waaꞌ thant, “Nil pam thonaman iiy may piꞌan aakanakan, weddingakan. Anpalana than pam workan iiy-iiyin nungant kuup-kuupin nungant nil palaman wampowa. ");
INSERT INTO wim_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Thanan nganth piꞌ-piꞌin kuup-kuupinan nungant nil palaman wampow. Weepan keꞌam yippak wunin, yaꞌa, than meeꞌ anman piꞌ-piꞌin nungant. Thanan ngeeyin nunang nil palam ngulan wamp-a, thanan thaaꞌan erkam thaꞌin nungant. ");
INSERT INTO wim_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","An puth min thant meeꞌan piꞌ-piꞌin. Moom piꞌan thanttaman thawow thant nyiinayn ngul table.angan aꞌ nilana may ngul theeꞌow thant. ");
INSERT INTO wim_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Nil moom thanttam nathwey ngaaꞌ-menhang wampow, nath yaꞌa, aak-paanthanang nath wampow, nilan nath uwiy thanang pam anangan kuup-kuupiythan nungantan-a, an nilan minam paththam iiyow thantana.” ");
INSERT INTO wim_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Amanam ngulana, nil Jesus.ana wik inan thamp thaw, “Niiy nath meeꞌmiyweya aak ngeen nathan paman aawuch niiyantamangan ngoonchiyan-a, way min niiyantaman yipam maꞌ-kuchathow-a, yaa, niiyaniya keꞌ weep wunina, yaꞌa, an meeꞌ pench-penchin anmana aakam paanthiy niiyantana, aꞌ min-min piꞌ-piꞌin way min niiyantamana. ");
INSERT INTO wim_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Puth niiyiya keꞌ meeꞌmiy yaꞌa aak ngeen nathana ngay putham palaman wampāng aak iikanakan, ngay pam inman nil God.angan kuchanya. Niiyiya keꞌ-ngoongkam anman murkanam kuup-kuupān ngathara, maꞌ-min-yumpwuna, ngay puth maꞌ-pil-wayathing niiyang.” ");
INSERT INTO wim_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Aꞌ amanamana, nil Peter.an thaw Jesus.antan, “Wik kath inan ngul nganttakam ey? Pam twelve il-ilantakaman ngant ey? Yaꞌ nath, pam wanch yotantakam ey?” ");
INSERT INTO wim_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Anpalana, nil Jesus.angana wik kath inan ngul waaꞌ thant, “Ngay wik katha waaꞌāng niiyant pam thonam alantaman workan iiy-iiya moom nungantamakan. Nil pam min paththama, work min iiy-iiy, keꞌam nyiin-nyiin thak. Anpalana, nil moom alangana aak nungantamana kan-ngul wantow, aꞌ nil pam thonam alantan thaw workan iiy-iiy nungantanweya, ‘Ngay kan iiyānga, nintana keꞌ moom piꞌan thanttam yimanangan iiy-iiyān koy-koyyuw ngulana pam wiy al-alantan workan iiy-iiyantana. Ngay iiyāng ngulan-a, nint may aath-aathān thananga, puth minam piꞌ-piꞌān thanangweya.’ ");
INSERT INTO wim_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","44","Aꞌ nil moom piꞌan palam ngul wampiyan-a, nil nathwey paman thathiy nunang work minam anman iiy-iiyan-a, yaa, nil thawiy pam alantan nil aakan piꞌ-piꞌ nungantana, ‘Yaa, nint work minam anman iiy-iiyana ngay nathan iiyangana. Aak imanam ngulan-a, nintaniya moom piꞌan ngul iiy-iiyāna way min yotam ngatharam inangana maꞌ nungkarang ngul piꞌ-piꞌān thanang.’ Nil pam anan workan iiy-iiy nungantan-a, an nil ngangk min paththam ngul wuniyanta. ");
INSERT INTO wim_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","“Nil paman nath min yaꞌ-a, nil nath eenchiy ngulan-a, nil work minan keꞌ-ngulan iiy-iiyiy, yaꞌa, puth nil yaaman keꞌ kuup-kuupiy moom nungantam alantana, nil nath thawiy nungantakamana, ‘Nil moom ngatharamana nath yaam nathaman wun-wunowa.’ Yaa, pam alangaman natha pam wanch wiy anangan workan iiy-iiyantan-a, piik-piikiy thanang ngula, aꞌ puth nilan natha kan-ngul may yotam anangan nilam ngul mungk-mungkiya, puth ngak way wine anangan thamp mungk-mungkiy ngul pam wiy al-alantangan ngak-mungkanang al-alantangana. ");
INSERT INTO wim_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Anpalana, moom piꞌan nungantaman nath palaman wampiyan-a, maꞌ-pil-wayathiy nunang-a, an nil whipangam piik-piikiy nunangana, pamana, aꞌ kuchow nunang ngul aak nungantam anpalana, aak way aakanakan kuchow nunang. ");
INSERT INTO wim_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Nil pam nath meeꞌmiyweya moom nungantamang work ngeen nathan piꞌ-piꞌan nungant-a, puth nil nath workan keꞌ iiyiy-a, yaa, moom nungantamangan puth mul-mulakam piik-piikow nunang; aꞌ pamana, way-wayam wun-wunow thaaꞌ eench-eenchowa. ");
INSERT INTO wim_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Puth nil pam thonan keꞌan meeꞌmiy moom nungantamangan wanttakan kaangk nilan iiyow-a, aꞌ puth nil wayan yumpiy-a, yaa, moom nungantamangana manyam anman piikowan, aꞌ nil paman manyam anman thaaꞌ-eenchow. Yaa, nil God.angan nathwey work piꞌan theeꞌiy ngampar-a, ngamp erkam ngeeyimp wik nungantaman, aꞌ putha work minam iiy-iiyāmp, nil puth thaw ngampar. Nil nathwey God.angan work wuut piꞌan nath theeꞌiy ngampar-a, ngampaniya wik nungantaman ngeeyāmp, work minam paththam ngul iiy-iiyāmp.” ");
INSERT INTO wim_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","50","Nil puth Jesus.an thawa, “Ngayan puth aak iikanakan ukangan aak anpal kenyana, ngay yipam way niiyantam anpalana min yumpāng niiyanga. An keꞌ thum yimanangan ngay kiingkang ngangk niiyantamangan way niiyantam anangan yipam thumang penchayn. Ngay pal ey! thuman kan-kanang kiingkinga! Puth ngay meeꞌmiya way anangan kaꞌathaman wampow ngathara. Ngay ngangk way-wayam paththam aak-aakanakaman ngulan wampow ngathara. ");
INSERT INTO wim_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Niiyan nath yimanangan ngaantam-ngeeyaniy niiyantakam keꞌ ngay aak iikanakana ukangana yipam niiy yotaman ngangk minangam iiy-iiyān niiyantakamana, kul keꞌanang wun-wunānweya, karpam anman ngaantam-ngeey-ngeeyān. Puth yaꞌa, an aak yimanangan keꞌ wunow niiyant, yaꞌa. Than pam wanchangan ngul thaampwayn thanttakam, aꞌ thaaꞌ-thay-thayanamayn ngatharam peeyanang. Than puungk wiyangana ngayang ngul monkan-wakayna, puth wiyangana, yaꞌa, than thaampayn ngayanga. ");
INSERT INTO wim_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Aak aawuch thonamangan natha pam wanch five wuntan, than nath koꞌalamanga wak-wakiythan pulang kucham anangana, than thaaꞌ-thayanamayn ngatharam peeyanang, ");
INSERT INTO wim_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","pul nath maꞌ-piip-nhengk thaampwiypul pulantakaman ngatharam peeyanangan, aꞌ maꞌ-kaath-puk wanch alangan nath thaampwiypula, nath maꞌ-piny-nhengk thaampwiypula. Than kampanam anangan ngatharam peeyanang thaamp-thaampwiythana, pam wanch wiyangana ngayang ep monkan-wak-wakantan, puth pam wanch wiyangan-a, ngayang keꞌam monkan-wak-wakantan, yaꞌa.” ");
INSERT INTO wim_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Aꞌ amanamaniya, nil Jesus.an thaw thant pam wanch yotam al-alantan, “Niiy yuwan thathaniy anpal kaawan matan-a, yaa, niiyaniya meeꞌmiy ngakan wampowa. Aꞌ an ngak paththam wampan ngul. ");
INSERT INTO wim_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Aꞌ wunt pal yiipan wampan-a, an niiy meeꞌmiy wunt keꞌam ngulan wampow, an aak karkan ngul wunow. ");
INSERT INTO wim_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Niiyan puth keꞌ kuchek waap minak waaꞌ-waaꞌwuniya, puth yaꞌa. Niiy yuw aꞌ puth wunt anan ep thathaniy, niiy puth ngoongk-ngoongkam ngay ngeenan waaꞌ-waaꞌang niiyant aak ngeen nath ngulan wampowa.” ");
INSERT INTO wim_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Aꞌ nil Jesus.an thaw thant, “Niiy wanttak keꞌam ngaantam-ngeey-ngeeyaniy minam iiyanakana? ");
INSERT INTO wim_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ngay wik kath inan waaꞌang niiyant: nil nath pam thonamang kaliy nintang courtaka. Nint keꞌaman yippak wampan aak-aakanakan-a, nint puth thawān nungant nil yipam keꞌ-ngul ngaantam-ngeeyowa way nintan yumpan nungantana. Nipana wik yumpow niparakam, nil yipam ngangk minangam iiy-iiyow ngul, way nungkaraman keꞌ-ngul ngaantam-ngeey-ngeeyow. Aꞌ amanamana, nil keꞌ-ngul kaliy nintang courtakana. Nint keꞌwey ngangk minan yumpin nunangan-a, yaa, nilaniya kaliy nintang court piꞌanakan. Aꞌ anpalana than pam magistrates anangan thawiythan nungk nint wukal piꞌan theeꞌāna, nint puth way yumpan, amanaman. Nint keꞌwey wukalan theeꞌin-a, yaa, nil pam magistrate alangan-a, aak jailak kuchiy nintang. ");
INSERT INTO wim_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","An puth nintangan keꞌ yippak kuchiy aak jailam anpalana. Nint wukal piꞌanan theeꞌinan-a, an ep jailaman pentin ngula.” ");
INSERT INTO wim_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Aak an-aniyangan-a, than pam wanch wiyangan waaꞌ-waaꞌin nungant Jesus.antan than pam wiy aak Galilee punchan anangan iiyin aak Jerusalem.akan than yipam minh kiingk-kiingkayn aawuch ngench thayan angana, aꞌ yipam piip God.antan theeꞌayn. Than yippak minhan kiingk-kiingkin-a, nil pam piꞌan Pilate.ana thaw thant pam soldiers nungantam al-alantan mulathayn thanang, aꞌ than mul-mulathin thanang, aꞌ putha chaapar thanttamana angman nenchanathin chaapar minh alantangana. ");
INSERT INTO wim_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Aꞌ amanamana nil Jesus.an kan-ngul thaw thant, “Niiy ngaantam-ngeeyaniy thanang pam Galilee punchan anangan keꞌ way-wayam paththam iiy-iiyin ey? nanpalan than mul-mulathin thanangan ey? Niiy want-wanttak ngaantam-ngeeyaniya? Pam wanch aak Galilee punchan man-yethaman yippak iiy-iiyantan than way-wayam paththam keꞌ yaꞌ ey? ");
INSERT INTO wim_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","An yaꞌa. Niiy nath way niiyantaman keꞌ wantinwey-a, yaa, an niiy thamp uthamāna. ");
INSERT INTO wim_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Puth niiy want-wanttak ngaantam-ngeeyaniy thanang pam wanch aak Siloam punchan anangan aak piꞌan Jerusalem angman wuntana? Aak angmana than pam wanch eighteen uth-uthamina. Aawuch achantangan pal kenyuw keek thanttang aꞌ yotam anangan mulakam maak thananga. Niiy ngul ngaantam-ngeey-ngeeyaniy thanang pam wanch eighteen anangan keꞌ way-wayam paththam iiy-iiyin ey? nanpalan mul wunin ey? Niiy want-wanttak ngaantam-ngeeyaniy thanang pam wanch Jerusalem punchan anangan man-yethaman yippak iiy-iiyantana, than pam wanch way-wayam paththam keꞌ yaꞌ ey? ");
INSERT INTO wim_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","An yaꞌa. Ngay inan thawang niiyanta: niiy nath way niiyantam keꞌan wantinwey-a, yaa, niiy thamana uthamān.” ");
INSERT INTO wim_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Aꞌ nil Jesus.angana wik kath inan thonangan ngul waaꞌ thanta, “Nil pam thonamanga yuk kom kaamp aak garden nungantam angmana. Yuk koman ongk ngulan em-em-a, nil paman may komak ngul wenk-wenk, aꞌ yaꞌ thath-thatha. ");
INSERT INTO wim_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Anpalana nil thaw pam alantan workan iiy-iiy nunganta, ‘Ayyang, wik kath in kan ngeeyāna, ngay kaap koꞌalamakam yuk ilantan yaꞌangam wamp-wampangana keꞌ may thampang ngul uwingane, puth yaꞌa, may keꞌam kal-kalana. Nint yuk inana thalokang umpāna, aꞌ puy theeꞌān. Aak ngaanh minang ngulan ngeenak than-thaniy yuk inaniy e?’ ");
INSERT INTO wim_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Aꞌ nil paman thawant moom alantan, ‘Ayyang, ngay kan aak ngaanhan mich-michathānga, aꞌ manure minh bullockantam anangan ngul wunp-wunpānga, aꞌ weentathānga yuk think wakananga, minam yipam emowa. Aꞌ nintan kuupāna, kaap thonamangan mak wantowana. ");
INSERT INTO wim_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Anpalaniy-a, yuk ilangan may yot nath kal-kaliywey-a, an mak wunowa, keꞌ umpāna. May keꞌan nath kaliywey-a, yaa, an ep-paththama nint thawān ngathar ngay yipam yukan umpāngana.’” ");
INSERT INTO wim_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Aak Saturday ngulan wun-a, nil Jesus.an aak church thanttam Jews.antamang ngoonch aꞌ kan-ngul thaaꞌ-aath-aath thanang pam wanch anangan wik min God.antaman waaꞌ-waaꞌa. ");
INSERT INTO wim_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Nil wanch thonam angman churchangan ngoonch oony way ngangkangan piꞌ-piꞌa, oony way ilangan man-mangk eep yump nunang. Nil wanchanweya eep-eep anman iiy-iiy, koochanaman keꞌam iiy-iiya, yaꞌweya. Aak nathpalman weech-weech nunang kaap eighteenangaman want nunanga. ");
INSERT INTO wim_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Nil Jesus.angan thath nunangan-a, nil thaw nungant, “Ayyang, nintang keꞌ-ngul weech-weechow, yaꞌa, keꞌ-ngul eep-eepan iiy-iiyān, yaꞌ-ngula.” ");
INSERT INTO wim_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Aꞌ nil Jesus.angan maꞌ nungantamangan mam nunanga, aꞌ yaam keꞌanam paththama miyal ngul ween. Wanchana koochanam ngul paththam thana. Nil wanchana ngangk min paththam ngul ween, aꞌ nilana piip God.an thaaꞌ-kuump-kuumpa nunanga. ");
INSERT INTO wim_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Amanaman-a, pam thonam inan nil moom piꞌan aak churchan piꞌ-piꞌan-a, man kul wamp nungant Jesus.antan puth anpalan wanchan miyalath nunang aak Saturday.angan aak ngench thayanangan. Aꞌ nil pam mooman thaw pam wanchantan, “Ngamp yotaman-a, kinch sixangan thonakam work iiy-iiyanamp, aak Saturday.angan yaꞌa, an ngench thayan ngampara. Niiywey kaangk Jesus.angan miyalathow niiyangan-a, yaa, aak Saturday.an keꞌ wampān nungant, aak kinch wiy al-alangana ep-paththam wampān nunganta.” ");
INSERT INTO wim_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Aꞌ nil Lord Jesus.an thaw nungant, “Niiy inangan yaan muuk-muukamaniya, man-kucham iiy-iiyaniya. Niiy kan in ngeeyāna: niiy nath yaraman thampa, nath minh bullock thamiy-a, yukang nath kath-kathin-a, yaa, niiyan thapathin thanang, aꞌ ngak mungkanak kalin thanang. Nungkway aak Saturday.angan-a, niiy kalin thanang than ngak yipam mungkayn. ");
INSERT INTO wim_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Puth nil oony way alangana wanch inaniy kaap eighteenakam way-wayathan nunanga, puth nilwey kampan nungantam Abraham.antama. An ngul min ngath yaꞌ ey? ngayan nunang maꞌ-aathāngan ey? aak Saturday.angan ey? aꞌ miyal puthan yumpāngan ey?” ");
INSERT INTO wim_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Nil Jesus wik inan thaw thant-a, nil moom churchakana putha pam wiy anangan than puth ngangk-wayangaman kal-kalin nunangan-a, than ngul-nyaaꞌ ngul weemin. Than pam wanch wiy anangana an ep ngangk kuup-kuupamin, nil puth Jesus.angan work piꞌan yump-yump, alpan anangan miyal-miyalath thanang. ");
INSERT INTO wim_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Nil Jesus.an thaw ngul thant, “Nil God.angan pam wanch yotam ngul yal-yalmathow thananga, maꞌ nungantangan yipam piꞌ-piꞌow thananga. Aak want-wanttak yaakaꞌ wunowa? Aak inan nath keꞌ ngeen wunowa? ");
INSERT INTO wim_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Yaa, ngay kan in wik kath waaꞌāng niiyanta aakan want-wanttakan wunowa. Nil pam thonamang may kaanch many pattakam thonam kala aꞌ garden nungantamang angan kaampan. Amanamaniya yiikanan kan-ngul pent aꞌ em-em ngul yuk piꞌanakama. Minh panch thaaꞌ-wantanam nath-nathpalan wamp-wampin yuk aakanakamana aꞌ wurp ngul yump-yumpin thanttakaman yuk punth yotamang angana. ");
INSERT INTO wim_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","“Thon ngaya kan in waaꞌāng niiyant aakan want-wanttakan wunow. ");
INSERT INTO wim_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","An keꞌ wanchang yimanangan may kurk may aachichangan nenchanathantan, may palowan yipam ulpow piꞌanakama. Ngamp puth keꞌ thiichimp nil may kurk anana pek-pekam workan iiy-iiyan, puth anpalaniya may palowana ulp-ulpan ngula.” ");
INSERT INTO wim_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Anpalana nil Jesus.angana want thanang aꞌ nilana woyan wak-wak aakanak um Jerusalem.ak. Nil Jesus.an woyan omp-ompamang wamp thant villages thon-thonangan, aꞌ towns thon-thonangan aꞌ thaaꞌ-aath-aath thanang. ");
INSERT INTO wim_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Aꞌ nil pam thonam inan thaw nungant, “Ayyang, moom-ang, nil ngul piip God.angan pam wanch koꞌalam inangaman thonakam kaaꞌ-piichanathow thanang ey? ngamp yotam wiy inangan yaꞌ ey?” ");
INSERT INTO wim_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Nil puth Jesus.an thaw nungant, “Niiy kan paath-paathāna thaaꞌ door many ulathan wakanan ngoonch-ngoonchāna aak nil God.an wun-wunana, niiyan yipam maꞌ nungantang wun-wunāna. Ngay inan thawang niiyanta: ngul-ngulana than pam wanch yotam keꞌ ngoonchanakan thaaꞌ door ulathan wakanana, puth yaꞌangama, thaaꞌ dooraniya ngathanam anman wun-wunow thanta. Niiy wik inangan min-min ngeeyāna: ");
INSERT INTO wim_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","nil thonamang thonak aawuch-kunch anan ekow aꞌ thaaꞌan ngathow. Aak an-aniyangana niiy nath keꞌan yippak pek ngoonchina puth nath yoon angman than-thanina, niiy nath thaaꞌan othamayanan piik-piikin aꞌ thawin ngul, ‘Lord-ang, nint thaaꞌan ngant keꞌ thaꞌin ey? ngan puy ngoonchān nungkara!’ Nilan puth thawow ngul niiyanta, ‘In niiy weeꞌ-weeꞌanangan e? Ngay keꞌ meeꞌmiy niiyanga, yaꞌa.’ ");
INSERT INTO wim_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Aꞌ niiyan nath wik inangan thawān nunganta, ‘Ngan puth nungkarang may minh mungk-mungkan aꞌ nint nganang thaaꞌ-aath-aathan aak towns nganttang angana!’ ");
INSERT INTO wim_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Aꞌ nil ngulan thawow niiyanta, ‘Ngay inan thawang niiyant: ngay keꞌ meeꞌmiy niiyang yaꞌa. Niiy puyam paththam kan iiyān aak ngatharam inpalana, niiy puth way anman yump-yumpaniya.’ Nil Lord.an wik yimanangan thawow niiyanta. ");
INSERT INTO wim_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Aꞌ niiy ngul thath-thathān thanang Abraham-a, Isaac-a, puth Jacob-a, aꞌ puth prophets wiy anangan thanan wik min God.antaman waaꞌ-waaꞌin, than keenk an-ngul wun-wuntan aak piip God.antangana. Puth niiyangan aak yoon angman too wantow niiyang, niiyan kan-kanam wik peey-peeyān ngula, aꞌ puth koonh path-pathwun niiy-niiyantakamana aꞌ man kul paththam wamp-wampow niiyanta. ");
INSERT INTO wim_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Pam wanch piip God.antam anangana, Jews anangan aꞌ putha Jews yaꞌ anangana ngul wamp-wampayn kungk-a, yiip-a, kaaw-a, kuuw anpalan aꞌ than ngangk minangam nyiin-nyiinayn piip God.antang angman, puth niiyangana yoon angman too wantowa. ");
INSERT INTO wim_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Aak inan ngulan wampow-a, than pam wanch wiy al-alangan ngaantam-ngeeywuntan than keꞌ pam wanch piꞌ-piꞌanam yimanangan iiy-iiyantan-a, an than pam wanch many ngul iiy-iiyayna. Than wiy al-alangan piꞌan keꞌaman ngaantam-ngeeywuntan thanttakaman-a, nil God.angan moom piꞌ-piꞌanam yumpow thananga.” ");
INSERT INTO wim_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Aꞌ amanamaniya Pharisees wiy anangan wampin nungant aꞌ thawin nungant Jesus.antana, “Nint paththam puyam kan iiyān aak thonak ngula. Nil Herod alangan kaangk mulathow nintanga.” ");
INSERT INTO wim_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Aꞌ nil Jesus.an thaw thant, “Nil Herod.an kan-kanam paththam pam way-wayama, nil keꞌ kuꞌngekanam yimanangan iiy-iiyana. Yaa, niiy koyam iiyāna aꞌ waaꞌān nunganta, ‘Kinch inmana aꞌ ngaaꞌ thon ngulan-a, ngay pam wanch way alpan anangan miyal-miyalathāng thananga, putha oony way anangan kenth-kenthāng thanttam pam wanch al-alantaman. Aꞌ kinch koꞌalamang ngulan ngayang wantow-a, work ngatharam anangana kan-ngul minchowa.’ ");
INSERT INTO wim_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Puth kinch inman aꞌ puth ngaaꞌthamana, aꞌ putha ngaaꞌ thon ngulana, ngay woyan anman wak-wakāng um Jerusalem.akan, work ngatharamana minchathāng ngula. Ngay Herod.antangan aaka keꞌ uthaming, yaꞌa, puth an min ngathar yaꞌa, than pam prophets inangan aak thon-thonanganiy keꞌ mulathiythan thanang, angman ep aak Jerusalem.angana mulathayn thanang.” ");
INSERT INTO wim_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Amanamana, nil Jesus.ang ngaantam-ngeey thanang pam wanch yotam anangan aak Jerusalem.angan wun-wunina, aꞌ ngangk way-wayam paththam wun nungant thanttam anpalana, aꞌ thaw ngul thant, “Niiy pam yot-yotam anangan kanam mul-mulathan thananga nil God.angan kuch-kuch niiyanta. Niiyiya kunttowang piik-piikan thanang mul-mulakama. Ngay keꞌ nathpalman maꞌ-yalmathing niiyang ngatharakama, keꞌ minh chookie kaath-kunch alangan maꞌ-yal-yalmathan thanang puk nungantam anangan aꞌ pek-pekam punth-paamang kang-kangan thanang ngula. Niiyaniya kaangk keꞌ paththam ngatharamana. ");
INSERT INTO wim_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Niiy in ngeeyāna, nil God.angan aawuch ngench thayan niiyantaman keꞌ-ngul min-minam piꞌ-piꞌow, an puth too ngul wantowa. Aꞌ niiy keꞌ-ngul thathān ngayanga aak inganiya, yaꞌa. Ngul-ngulana an epa niiy kaaꞌwal ngurp thathān ngayanga, amanamana niiy meeꞌmiy ngul weemāna pam ngay inman nil God.angan kuchanya, aꞌ niiy thawān ngula, ‘Yaa, ngamp thaaꞌ-kuump-kuumpāmp nunanga pam inman nil God.angan kuch nunanga.’” ");
INSERT INTO wim_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ngul-ngulana, aak Saturday.an wuna, nil Jesus.an aakanak iiy may yipam mungkow moom piꞌanantanga moom thanttam Pharisees al-alantamana. Aak Saturday.ana ngench thayan paththam wunan thant Jews.antana, puth work keꞌam iiy-iiyantana. Yaa, than pam yotam al-alangana Jesus.an thath-thathin nunang nil want-wanttak nath yumpowa. ");
INSERT INTO wim_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Nil pam thonam aak angman wun-wun yangk-a, aꞌ putha maꞌ punth puulk-puulkiy weem. Nilaniy-a, Jesus.ant wamp. ");
INSERT INTO wim_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Aꞌ nil Jesus.an thaw pam Pharisees al-alantan putha pam wiy al-alantan tham wik thayan Moses.antaman thaaꞌ-aath-aathin, “Ayyang, ngul an min ey? ngamp alpan anangan miyal-miyalathāmp thanang aak Saturday.angan ey? nath yaꞌ yaakaꞌa. Wik thayan want-wanttak thawan e?” ");
INSERT INTO wim_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Pam yotam anangana puth popam anman nyiin-nyiinin, aꞌ keꞌam anman wik thaw-thawin nungant Jesus.antan, yaꞌa. Amanamana nil iiy ngul pam alpan alantan aꞌ miyalath nunang. Aꞌ thaw ngul nungant, “Nint kan iiyānwey aak nungkaramaka.” ");
INSERT INTO wim_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Aꞌ nil thaw thant yotam al-alantan, “Niiy kan in ngeeyān a! Puk nhengk niiyantamwey-a, nath minh bullock niiyantam anangana ngak pantamang keekiythan aak Saturday.angan-a, ngul niiy wanttak yumpin e? An niiy erkam iiyina aak anman Saturday.ana aꞌ wich-wichin thananga ngak pantam anpalana.” ");
INSERT INTO wim_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Puth than koyaman keꞌam thawin nungant, yaꞌ paththam, than puth wik want-wanttak thawiythan nungantana? ");
INSERT INTO wim_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Amanamana than kan-ngul nyiinin may ngul mungkayna. Nil Jesus.angan kan-ngul thath-thath thanang pam anangan aak umputhan nyiin-nyiinin than yipam may keenk-keenk mungkayna, keꞌ pam piꞌan yimanangan. ");
INSERT INTO wim_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Aꞌ anpalana nil Jesus.angan wik kath inan ngul waaꞌ-waaꞌ thant, “Pulweya pam kompa puth wanch komanangan ngentwiypul-a, pulana nath umpiypul niiyanga may piꞌan pulantangan mungkāna. Niiy iiyin ngulan-a, niiyana aak thinth pulantangan keꞌ nyiinin yaꞌa. Ngul-ngulana, nil pam piꞌan paththam nath wampiya may piꞌanakan, ");
INSERT INTO wim_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","aꞌ anpalana nil moom may piꞌanan piꞌ-piꞌana, nath wampiy niiyant aꞌ thawiy, ‘Ayyang, nint ekāna! Pam nil piꞌan nangan mak nyiinowa.’ Aꞌ niiyaniya ngul-nyaaꞌ ngul weenin aꞌ kecham ngul nyiin-nyiinin pulantamana. ");
INSERT INTO wim_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Yaa, niiywey may piꞌanakan iiyānan-a, niiyana keꞌ nyiinān aak pulantangan thintha, yaꞌa, chil kech-kech nyiinān. Anpalana, nil moom may piꞌanakana nath wampiy niiyant aꞌ thawiy niiyant, ‘Nint kan thinth-thinth nyiinān pulantanga.’ Aꞌ than yotamangan thath-thathayn niiyang niiy thinthaman nyiin-nyiinaniy pulantangan-a, yaa, thanan meeꞌmiy ngul niiy pam piꞌan paththama. ");
INSERT INTO wim_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ngay in kan waaꞌang niiyant: nil nath pamangwey ulp-ulpathiy nungantakaman-a, nil piip God.angan ngul meenathow nungant nil pam piꞌan paththam yaꞌa, anpalana nil pamana ngul-nyaaꞌ ngul weenow. Pam weeꞌangwey keꞌ nath ulpathiy nungantakaman-a, nil piip God.angan thaaꞌ-kuump-kuumpow nunanga yipam pam piꞌan paththama waaꞌowan nunanga.” ");
INSERT INTO wim_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Anpalana nil Jesus.an kan-ngul thaw pam Pharisee alantan, pam alantakaman nil Jesus.antan kaꞌathangaman thaw nil may nungantangan mungkowa, “Niiy may piꞌanan yumpān-a, niiyan kampan niiyantam aꞌ puth ngurp niiyantam anangan aꞌ puth pam maꞌmangkiy anangan kaangk umpān thanang, thanan yipam puthangkan niiyang ngul may piꞌan thanttamakan umpayn may thanttangan yipam mungkān. Niiyan puth yimanangan keꞌ ngaantam-ngeeyāna. ");
INSERT INTO wim_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Niiywey may piꞌan yumpān-a, yaa, niiyana thaaꞌ-palathān thanang than wukal keꞌanangan iiy-iiyantan, aꞌ putha pam wanch kunp anangana, putha koꞌanch anangan aꞌ alpan wiy anangan thama. Niiy ngangk minangam aath-aathān thanangweya. Thanan may minh keꞌ aathiythan niiyang puthangkana, yaꞌa, puth kana, niiyaniya ngangk min paththam ngul iiy-iiyāna. ");
INSERT INTO wim_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ngul-ngulana nil God.angan pam wanch min anangan mulaman ekathow ngulan-a, nil min paththam ngul iiyow niiyant.” ");
INSERT INTO wim_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Pam thonam nyiin-nyiin thanttangan-a, nil wik inangan ngeeya, aꞌ thaw nungant Jesus.antan, “Than pam wanch anangan may piꞌan God.antangan mungkayn aak ing kenyan-a, an ngangk min-minam paththam wun-wunow thanta.” ");
INSERT INTO wim_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Aꞌ nil Jesus.angan wik kath inan waaꞌ thant, “Nil pam thonamang may piꞌan kiingkowa. Aꞌ nilana thaw pam wanch yotantan puth aakanak iiyayn aawuch nungantamakan may piꞌanan yipam mungkayna. ");
INSERT INTO wim_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ngul-ngulana, may minh yotam kanaman penchin-a, nil pam thonam workan iiy-iiy nungant-a, kuch nunang pam wanch al-alantan yipam thawow thant, ‘Ayyang, niiyalang, may minh menchan ngula. Niiy pal kan iiyāna.’ ");
INSERT INTO wim_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Puth than pam wanch anangan kaangk keꞌ iiyayna. Nil pam thonam inan thaw nungant, ‘Ayyang, nyiingkana ngay farm piiyangan, ngay puth naakanakan keꞌ iiying may piꞌanakana, ngay yipam koyam iiyānga aꞌ farman thathāng.’ ");
INSERT INTO wim_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Nil pam thonangan ngul thaw nunganta, ‘Nyiingkana ngay minh bullocks ten anangan piiyangan thanang, ngay puth koyam iiyāng aꞌ thathāng thananga nath minam yaakaꞌa, nath yaꞌa. Ngay naakanakan keꞌ iiying may piꞌanakana.’ ");
INSERT INTO wim_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Aꞌ pam thonangan inan thawant, ‘Nyiingk inana ngay wanch ngentangana, ngay naakanakan puth keꞌ iiying may piꞌanakana.’ ");
INSERT INTO wim_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Amanamaniy-a, nil pamana koyam ngul iiy moom nungantamakan aꞌ waaꞌ nunganta, than kaangk keꞌ iiyayn may piꞌanakana. Nil moom alangana wik inangan ngeeyan-a, an paththam man kul wamp nungant, aꞌ thaw ngul, ‘Puth kan wantān thananga. Nint erkam iiyān aak town wakanana, aꞌ pam wanch wukal keꞌan anangan pal wamp-wampathān thanang may piꞌanakana, puth pam wanch kunp anangan, aꞌ putha pam wanch koꞌanch anangan, puth wiy anangan thamp thaaꞌ-palathān thanang mayakana.’ ");
INSERT INTO wim_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Nil pam alangana wik erkam paththam ngeey nunang moom nungantaman aꞌ pam wanch yotam wampath thanang may piꞌanakan. Amanamaniya paman thaw moom nungantam alantana, ‘Ngay kanam wampathang thanang in-ngula puth aak inan yippak pech weꞌar wunan pam wanch wiy anangan thamp pal wampayn mayakana!’ ");
INSERT INTO wim_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Aꞌ nil moom nungantaman thaw nungant, ‘Nint putham iiyāna, pam wanch wiy al-alantan aak pungk-pungkalang aak thaaꞌ yoonan wuntan aꞌ thawān thant pal erkam paththam wampayn may piꞌanakana. Nint pal wampathān thanang aawuch ngatharam iikanakana yipam pam wanchangam aakan ngathowa. ");
INSERT INTO wim_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ngay in thampan waaꞌang nungkar: pam wanch yotam anangan ngay kaꞌathangaman thaaꞌ-palathang thanang keꞌaman wampin ngathara, than al-alangan keꞌ-ngul may mungkayn ngatharangana, yaꞌa!’” ");
INSERT INTO wim_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Anpalana, than pam wanch thaaꞌ-wantanam angman iiy-iiyin nungantang Jesus.antangan. Aꞌ nil koyam ngul weent thant aꞌ thaw thant, ");
INSERT INTO wim_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Nil pam weeꞌang nath monkanan-wak-wakow ngayangan-a, yaa, nilaniya min-minam paththam kaangk wunow ngathara, kampan nungantam al-alantan chil-chil kaangk wunow thant, kaath-a, piip-a, puth kuunch nungantamantan, wanch thum aꞌ putha puk nungantam al-alantan thama. Nil keꞌwey min-minaman kaangk wunow ngathar-a, yaa, nilana puth ngurp ngatharam keꞌ-ngul iiyow yaꞌa. ");
INSERT INTO wim_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Nil weeꞌangweya kaangk monkanan-wak-wakow ngayangan-a, yaa, puth nilaniya keꞌ ngaantam-ngeey-ngeeyow nungantakamana, yaꞌa, nil kon-ngathow nungantakamana. Pam wanch wiy al-alangan nath mulathayn nunanga, keꞌ ngayang ngulan mulathayn, yuk wuuyanangan waanchayn ngayanga. Nungkway than wiyangana nath mulathayn nunang-a, nilana ngayang anman monkan-wak-wakowa. ");
INSERT INTO wim_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Niiy nganyang nath monkan-wak-wakān-a, yaa, niiy kan kaꞌathaman min-min ngaantam-ngeeyāna, niiy nath kan-kanam monkan-wak-wakin ngayanga, nath yaꞌa. Wik kath inan keꞌ yimanangan wunana. Nil pamang nath aawuch piꞌan kaach-kaachiy-a, nil kaꞌathamana ngaantam-ngeeyow wukal ngeen-ngeen nath theeꞌow aawuchakana aꞌ nil wukal nungantam anangana countimpungow yipam ngeen-ngeen nathan theeꞌow aawuch aakanakan. Nil wukal piꞌanan piꞌowwey-a, an ep-paththam thawow thant aawuchan kaachayn nungant. ");
INSERT INTO wim_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Nil nath wukal manyanwey piꞌ-piꞌiy-a, nath aawuchan keꞌ-keꞌ minchathiythan nungant, yaꞌa, chip-chipam nath wantiythan ngula. ");
INSERT INTO wim_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Anpalana ngurp nungantam al-alangan thaaꞌ-thengk-thengkathiythan nunang. ");
INSERT INTO wim_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Aꞌ inan wik kath thonangan ngul waaꞌāng niiyanta. Nil pam piꞌan alangan nath soldiers yot anangan piꞌ-piꞌiy thanang, ten thousand anangan. Aꞌ nil nath kecham thath-thathiy pam piꞌan thonan aꞌ puth soldiers nungantam thaaꞌ-wantanam twenty thousand anangan pal iiy-iiyiythan aꞌ kulak wenk-wenkiythan thanta. Puth nil pam piꞌanan erkam keꞌ thawiy soldiers nungantam al-alantana umang kalayn thanang, yaꞌa. Nil kan ngaantam-ngeeyiy than pam soldiers nungantam al-alangan ngul nath maꞌ theeꞌayn thant, yaꞌ natha. ");
INSERT INTO wim_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Nil nath ngul ngaantam-ngeeyow nungantakaman, ‘An than ngampang piikayn paththama, ngamp thant inangana puth pam koꞌalamweya.’ Yaa, anpalana, nilan pam work nungantan iiy-iiyana anan kuchiy nunang wik thaman pam piꞌan thon alantan, ‘Ngamp keꞌ-ngul pekwumpa! Ngan yuk way min ngul theeꞌān niiyanta, niiy yipam ngangk min iiy-iiyān nganta!’” ");
INSERT INTO wim_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Aꞌ nil Jesus.an kan-ngul thaw, “Niiy nath monkanan-wak-wakān ngayangan-a, yaa, niiy kaꞌathamana kan min-minam ngaantam-ngeey-ngeeyāna, niiy nath kan-kanam paththam monkan-wak-wakān ngayanga, nath yaꞌa. Niiy nath way min niiyantamakan kaangk wun-wunaniya puth ngangk ench keꞌ nath want-wantin thanang aꞌ kampan niiyantam anangan-a, yaa, niiy puth pam wanch ngatharam keꞌ-ngul iiy-iiyin, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Niiy kan in ngeeyāna. Ngunthamana min minhakana, puth nguntham nath way ngulan wunow-a, niiy keꞌ-ngul koyaman min yumpin yaꞌa, niiyan putha kan-ngul theeꞌina. ");
INSERT INTO wim_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Nungkway niiy ngunthaman aakangan kaampin thanang-a, anpalaniy-a, nath nenchanathin manure bullockantangana yuk plants thakan yipam minam emayn-a, puth yaꞌangam kaamp-kaampin, ana nguntham way ilangan keꞌ maꞌ-aathiy thanang emanakan yaꞌa. An yaꞌ way paththama, yaa, niiy puth wik ngatharam kanam ngeeyan aa? Yaa, niiy kan min-minam ngaantam-ngeey-ngeeyān thananga, keꞌ iiy-iiyān keꞌ nguntham wayanang yimanangan yaꞌa.” ");
INSERT INTO wim_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Anpalan-a, than pam wanch wiy anangan wampin nungant Jesus.antan wik nungantaman yipam ngeey-ngeeyayn — than wiy al-alanganiya wukal tax anpalan maay-maayin pam wanchantaman, aꞌ than wiy anangan kaangk-keꞌanangwey iiy-iiyina. ");
INSERT INTO wim_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Puth than pam piꞌan Pharisees anangana aꞌ than pam piꞌan wiy anangan thanan wik thayanan thaaꞌ-aath-aathinan-a, than kaangk keꞌ thath-thathayn thanang wamp-wampayn nungant Jesus.antana. Than waaꞌ-waaꞌin nunang Jesus.an aꞌ thanan thaw-thawin thanttakamana, “Nil puth ngangk minangam ep iiy-iiyan thant ey? aꞌ puth may aawuch thanttamang mungk-mungkan ey? An min nungant yaꞌa, an waya!” ");
INSERT INTO wim_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Aꞌ nil Jesus.angan wik kath ngul waaꞌ-waaꞌ thant, ");
INSERT INTO wim_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ayyang, nil pam thonamang minh sheep yot one hundred piꞌ-piꞌ thananga. Aꞌ minh sheep thonaman puth puy-puyam iiy-iiya, aꞌ wanttin-maꞌ nath appench nungantama. Puth nil pam alangan want-wanttak ngul ngaantam-ngeeyow e? Nil minh sheep thonaman kon-ngathow nunang ey? sheep ninety-nine thonakam piꞌ-piꞌow thanang ey? An min nungant yaꞌa. Aꞌ puth nilan keenk angam want thanang, minh sheep ninety-nine anangan, than keꞌ-ngoongkam wak mungk-mungkina, aꞌ paman erkam iiy, aꞌ wenk-wenk sheep thonam alantan. Nil pal-puy wenk-wenk-aa, aꞌ puth kan-ngul uw nunanga. ");
INSERT INTO wim_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Nil uw nunangan-a, nilana ngangk min paththam ngul weem, aꞌ nil man thapang wunpan, aꞌ kal nunang aak nungantamaka. ");
INSERT INTO wim_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Nil aak nungantamang kanan wamp-a, nil kampan nungantam aꞌ putha ngurp nungantam anangan thaaꞌ-palath thanang aꞌ than yalmathwin aꞌ nil thaw ngul thant, ‘Ayyang, ngay ngangk min paththam ngula. Ngay kanam uwangan minh sheep ngatharam yaꞌan appencha. Ngamp may piꞌan mungkāmpa, ngay puth ngangk min ngul wunanga!’” ");
INSERT INTO wim_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Anpalan-a, nil Jesus.an kan-ngul thaw, “Yaa, niiy kan in ngeeyāna, in keꞌ yimanangan wunana. Pam thonamangwey wantiya way nilan yump-yump-a, piip God in kenyana aꞌ ngaantiyongk nungantam anangan thama ngangk min-minam paththam ngul wunayn nungantama pam thonam alantaman. Puth than pam wanch wiyangan thanttakam nath ngaantam-ngeeywuntana keꞌ than way keꞌam yump-yumpantan, nil God.aniya ngangk min keꞌam wunan thanttaman yaꞌa.” ");
INSERT INTO wim_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Anpalana, nil Jesus.an kan-ngul thaw thant, “Ngay wik kath thonangan ngul waaꞌāng niiyanta. Nil wanch thonamang wukal silver manyiy ten nath piꞌ-piꞌiya, aꞌ nil thonam nath wayathiy. An puth nil want-wanttak ngul ngaantam-ngeeyow e? Nil wanchan keꞌ thawiya, ‘An kana! Wukalan puth mak wunowa,’ yaꞌa. Nilaniya maꞌ kerkan, nganthan paththam erkam pathathana, aꞌ aawuch nungantaman pal-puy thak-thakan, aꞌ pal-puy itangam wenk-wenkana. ");
INSERT INTO wim_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Nil wukal kanam ngulan uwan-a, nil thaaꞌ-palathan thanang ngurp nungantam aꞌ putha kampan nungantam anangan, aꞌ than aak nungantamang yalmathwuntan aꞌ nilana kan-ngul thawan thanta, ‘Ngay ngangk min paththam ngul weemanga, ngay puth wukalan kanam uwangana, ngayan wayathangan. Ngamp may piꞌan mungkāmpa!’” ");
INSERT INTO wim_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Aꞌ nil Jesus.an thaw, “Niiy kan in ngeeyāna! In aak yimanangan wunana. Pam thonamangwey way wantiya nilan yump-yump-a, piip God in kenyana aꞌ puth ngaantiyongk nungantam anangan thama ngangk min-minam paththam ngul wunayna nungantaman.” ");
INSERT INTO wim_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Anpalana, nil Jesus.an kan-ngul thaw thant, “Niiyala, ngay wik kath thon inan waaꞌāng niiyanta. Pam thonamang puk nhengk wuut kucham piꞌ-piꞌa. ");
INSERT INTO wim_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Nil nhengk kuyam nungantaman thawanta, ‘Piip-ang, nint ngulan uthamān-a, way min nungkaram anangan yaarkathayn wuny ngatharamang nganta. Puth ngay yaaman keꞌ kuup-kuupinga. Nint inman theeꞌān ngathara.’ Yaa, piip-kunchangana yuk way min thakan yaarkath pulant puk nhengk nungantamantan. ");
INSERT INTO wim_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Anpalana, nil nhengk kuyam alangan yuk way min nungantam anangan sellimpung thanang wiyantan thanta, aꞌ wukal maay, aꞌ aak thanttaman kan-ngul want, aꞌ iiy ngul aak kechaka. Aꞌ ang-ngulan-a, nil wukalan min-minam keꞌam piꞌ-piꞌ nungantakamana. ");
INSERT INTO wim_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Nil wukal ananganiy-a, yaꞌ yaark-yaarkath thant wiyantan aꞌ wukal keꞌanang ngul wun-wun. Anpalaniya, may thakan keꞌam emin thant puth ngak keꞌam uk-uk thant aak anganiya. Anpalaniya nil may keꞌanang ngul wun-wuna. ");
INSERT INTO wim_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Yaa, nilwey work uw farmanga. Nil minh nhinthan anangan piꞌ-piꞌ thanang. ");
INSERT INTO wim_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Nil meech wun-wuna, aꞌ nil ngaantam-ngeey keꞌ may beans minh nhinthan al-alantaman mungk-mungkiy thanang, puth yaꞌa, puth than pam wanch al-alangana may keꞌam theeꞌ-theeꞌin nungant, yaꞌ anman. ");
INSERT INTO wim_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Yaa, anpalaniya kuchek min ngul koyam wun nungant. Nil ngaantam-ngeey-ngeey nungantakaman, ‘Pam workan iiy-iiyantan piip ngatharamantan-a, than meech keꞌam iiy-iiyantana, than ep-paththam may yot mungk-mungkantana. Ngay puth in meech-meecham wun-wunanga. ");
INSERT INTO wim_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Yaa, ngay puth koyam iiyāng piip ngatharamanta, aꞌ thawāng nungant, “Piip-ang, ngay way-wayam paththam yumpangan meeꞌ God.antangan, aꞌ puth nungkar thamana. ");
INSERT INTO wim_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nintan puth ngayang nhengk keꞌ-ngul waaꞌ-waaꞌāna, ngay puth wayan yump-yumpangana. Ngay work mak iiy-iiyāng nungkar keꞌ pam wiy yimanangana. Nint yimanangan ngaantam-ngeeyān ngayang ngula.” ’ ");
INSERT INTO wim_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Anpalana, nil kan ek, aꞌ kan-ngul iiy koyam piip-kunchantana. Nil yippak chil kechan iiy-iiya um aawuchakan-a, nil piip-kunchangana kecham thath nunanga. Nil ngangk mam nunang aꞌ kamp moꞌ nungant, aꞌ man kathan nhengk-kunchan, aꞌ wal piintan. ");
INSERT INTO wim_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Nil nhengk-kunchan thawant, ‘Piip-ang, ngay way yumpangan God.ant aꞌ nungkar thamana. Nintan puth ngayang nhengk keꞌ-ngul waaꞌ-waaꞌān. Ngay puth way yump-yumpangana.’ ");
INSERT INTO wim_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Puth nil piip-kunchan pech thant pam al-alantan workan iiy-iiyin nunganta, ‘Erkam paththam ngook min pal kalān nungant, ngoonchathān nunanga, puth ring maꞌang thenchān nunganta, aꞌ thaꞌ murruk thaꞌang wunpān nungantanga. ");
INSERT INTO wim_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Aꞌ minh calf min-minam paththam mulathān aꞌ ngampaniya may piꞌan ngul mungkāmpa! Ngay puth ngangk min paththam ngul wunanga. ");
INSERT INTO wim_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Puk nhengk ngatharam keꞌ mul yimanang wun, puth yaꞌa minam palam wamp ngathara. Nil kaꞌathangaman want ngayangan puth palam kan wamp ngathar.’ Yaa, anpalaniy-a, thanana kan-ngul may piꞌanan mungk-mungkina. ");
INSERT INTO wim_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Aꞌ wuny-kunchana natham yippak work iiy-iiy paddockangana. Nil work kan-ngulan minchath-a, aawuchak koyam ngul iiy. Nil thinth-thinth ngulan wamp aawuchakan-a, nil wik wolmp ngeey-ngeeya, wikan piꞌ-piꞌin aꞌ keeꞌ-keeꞌin thakana. ");
INSERT INTO wim_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Aꞌ nil pech pam thonam alantan workan iiy-iiy, ‘Than ngeenam wik wolmp nananiy piꞌ-piꞌantan a?’ ");
INSERT INTO wim_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Puth paman thaw nungant, ‘Kuunch nungkaramana kanam palam wampa, puth piip niparaman thaw ngant minh calf min paththam mulathāna puth kuunch nungkaraman minam palam kanaman wampa.’ ");
INSERT INTO wim_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Nil wuny nungantaman man kul paththam wamp nungant aꞌ nil pekan keꞌam ngoonch thant aawuchakana. Nil puth piip-kunchan yoon pentant, aꞌ thaaꞌ-mamanang thaw nungant, ‘Nint pal kan ngoonchān a!’ ");
INSERT INTO wim_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Nilana kan-ngul thaw piip-kunchantan, ‘Ayyang, Piip-ang, ngay nathpalman work iiy-iiyangan nungkara, kaap thon-thonangana, keꞌ pam wiy anangan workan iiy-iiyantan nungkara yimananga. Ngay nathpalman wik nungkaraman ngeey-ngeeyangana. Nint ngath ngeen theeꞌan e? Nint minh goat theeꞌan ngathar ey? Nint puth thawan thant pam al-alantan may piꞌan yumpayn ngathar ey? Yaꞌ paththama. Nint keꞌam theeꞌan ngath. ");
INSERT INTO wim_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Puth ilangan puk nhengk nungkaramangana wukal nungkaram way min thakan yaark-yaarkath thant wanch wayanang al-alantana. Nil palam ngulan wamp ngalant-a, nint puth ep may piꞌan yumpan nungant ey? aꞌ puth minh calf min paththam mulathan nungant ey?’ ");
INSERT INTO wim_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Aꞌ nil piip-kunchan thaw nungant, ‘Ayyang, nhengk ngatharam-ang! Nint puth ngatharang ingman ep wun-wunan, wukal aꞌ puth way min yotam ngatharam anangana ngalantakam karpwey piꞌ-piꞌal nint puth ingam wunanama. ");
INSERT INTO wim_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Puth ngamp ngangk min wunāmpa, may piꞌan mungkāmpa puth kuunch nungkaram keenkam want ngampang keꞌ mul yimanangan wun ngampara, puth yaꞌa, nil palam miniyakam puth wamp ngampara.’” ");
INSERT INTO wim_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Aꞌ nil Jesus.angana wik kath inan waaꞌ-waaꞌ thant ngurp nungantam al-alantan, “Niiyalang, ngay kan wik kath inan waaꞌāng niiyanta pam maꞌmangkiy alantamana aꞌ putha pam workan iiy-iiy nungantan. Nil pam alangana aak moom nungantam alantaman piꞌ-piꞌa aꞌ nilaniya may-a, puth wukal thakan yal-yalmath thanang thanttam pam wanch al-alantaman than aak moom alantamana rentimpung-punginana. Ngul anpalaniya, than pam puungk wiy anangan wampin nungant pam maꞌmangkiy alantana aꞌ thawin nungant, ‘Nil pam workan iiy-iiy nungkarana nil wukal aꞌ way min nungkaram anangana yaꞌ way-wayatha.’ ");
INSERT INTO wim_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Puth anpalaniya, nil pam moom alangan wik kuch ngul pam alantan nil nungantan workan iiy-iiya, nil aakanak wampow nungant. Nil kan-ngulan wamp nungant-a, nil pam maꞌmangkiyan thaw ngul nungant, ‘Ngay wik way ngeeyangan nungkaramana. Lat nungkaram anangan pal kalāna, ngay yipam thathāng nint wukal ngatharaman want-wanttakan piꞌ-piꞌana. Nint puth ngatharan keꞌ-ngul work iiy-iiyāna, yaꞌa.’ ");
INSERT INTO wim_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Aꞌ anpalaniya, nil paman thaw ngul nungantakamana, ‘Ngay wanttak ngul yumpāng e? Puth moom ngatharaman kaangk keꞌ ngay koyaman work iiyāng nungantana. Ngay puth maꞌ punth thayan yaꞌa awar weꞌanakana. Aꞌ ngay puth ngul-nyaaꞌ wun-wunanga, mayak thakan kaangk keꞌ thaaꞌ pent-pentāng pam wanch wiyantana. ");
INSERT INTO wim_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ngay puth kan ngaantam-ngeey-ngeeyang ngay want-wanttakan ngul yumpānga, than pam wanchangan yipam maꞌ-aath-aathayn ngayang ngay work keꞌ-ngulan iiy-iiyānga.’ ");
INSERT INTO wim_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Anpalana, nil pam alangan wik kuch pam wiy al-alantan wampayn nungant than yuk way minan owe.impungantan nunang pam maꞌmangkiyana. Than wampinan-a, nil kan-ngul thaw-thaw thant thon-thonantana. Nil pam thonamantan thaw, ‘Nint way min ngeen-ngeen owe.impungān nunang moom ngamparamana?’ ");
INSERT INTO wim_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Nil puth paman thaw nungant, ‘One hundred drums oil thampa.’ Puth nil pam kaꞌathaman workan iiy-iiy-a, thaw nungant, ‘Nint nyiināna aꞌ nint one hundred wayathān lat nungkaram anpalan aꞌ fifty thonakam latangan umpāna!’ Aꞌ pam thon alantan ngul thaw, ‘Nint way min ngeen-ngeen owe.impungān nunang moom ngamparamana?’ ");
INSERT INTO wim_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Aꞌ paman thaw nungant, ‘One hundred bags may wheat thampa.’ Yaa, nilan thaw nungant, ‘Nint one hundred wayathān lat nungkaram anpalan, nint eighty thonakam latangan umpāna.’ (Nilan yimanangan thaw thant yotamantana thanan yipam ngurp nungantamwey iiy-iiyayna.) ");
INSERT INTO wim_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Nil pam maꞌmangkiy alangan wikan ngeey-a, nilan putha wik kuch pam way alantan, nil nungant kaꞌathaman work iiy-iiy, nil wampow nunganta. Nil pam anan kanan wamp moom alantan-a, nil puth pam moom alangana ngangk mam nunang, aꞌ thaw nungant, ‘Nintan puth kan-ngul min-minam ngaantam-ngeey-ngeeyana nint want-wanttakan ngurp min yumpān thanang pam wanch wiy anangana. Niiya pam wanch il-ilangan pam wanch God.antam yaꞌana, niiy ep-paththam meeꞌmiy ngurp min yumpanakan thanang wiy anangana, than puthangkan yipam min iiy-iiyayn niiyantana. Puth than pam wanch God.antamangan min-minan keꞌam ngaantam-ngeey-ngeeyantan than want-wanttakan ngurp minan yumpayn pam wanch wiy anangana.’” ");
INSERT INTO wim_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Aꞌ anpalaniya, nil Jesus.an putham ngul thaw thant, “Ayyang, niiyalang, ngay niiyant inan thawānga: niiy keꞌ yangkan moꞌ-moꞌāna, aꞌ wukala puth-a, yuk way min niiyantakaman keꞌ piꞌ-piꞌāna, niiy pam wanch wiyantan theeꞌ-theeꞌān thanta aꞌ puth thananiy-a, ngurp niiyantam ngul iiy-iiyayna. Niiy wiyant yuk way min puth wukal thakan theeꞌ-theeꞌin thantan-a, an nil God.angan ngangk minangam umang wakow niiyang aak ing keny heavenangana. Aak an-aniyangana, niiyaniy-a, wukal keꞌanang ngul iiy-iiyāna. ");
INSERT INTO wim_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Nil pam wanch weeꞌanganweya wukal manyan pam thon alantaman maꞌ-thayanaman piꞌ-piꞌiy-a, yaa, an nil wukal piꞌan thamp minam piꞌ-piꞌiy nungant. Puth nil weeꞌang nath wukal manyan minaman keꞌan piꞌ-piꞌiy-a, yaa, nil puth wukal piꞌan thampana minam keꞌ piꞌ-piꞌiya, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Niiy keꞌwey nath way min wukal thakan minaman piꞌ-piꞌin-a, nil puth God.angan want-wanttak work minan theeꞌow niiyantana niiy nungantan yipam iiy-iiyāna? Nil keꞌ theeꞌiy niiyant, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Wukal aꞌ puth yuk way min thakan an niiyantakam yaꞌa, nil God.angan yaan thonakam theeꞌ-theeꞌan niiyant. Yaa, niiyan puth min-minan keꞌan piꞌ-piꞌin thanang-a, niiyan puth keꞌ ngaantam-ngeey-ngeeyān keꞌ niiy God.antangan wun-wunān aak ing keny heavenangana, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Niiy woyan kucham anangan karpam keꞌ wak-wakin pulang, yaꞌa; aꞌ niiyana moom kuchamantana keꞌ work iiy-iiyina, yaꞌa, moom thonamantan ep-paththam workan iiy-iiyāna. Niiy nath moom kuchamantan work iiy-iiyinan-a, yaa, niiy thonamana ngangk-wayangam kal-kalin nunang, aꞌ way waaꞌ-waaꞌin nunanga, puth niiy moom thonan ep-paththam min waaꞌ-waaꞌin nunang aꞌ kaangk wun-wunin nungantana. In aak yimanangan wunana: niiy nathwey kaangk wun-wunin nungant God.antan-a, yaa, niiyana wukal-weenthan keꞌ iiy-iiyina.” ");
INSERT INTO wim_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Than Pharisees.ang wik inangan ngeey-ngeeyin nunang Jesus.an thaw-thaw-a, thananiya thengk-thengkathin nunanga, thanan puth wukal-weentha. ");
INSERT INTO wim_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Nil puth Jesus.an thaw ngul thant, “Niiy thaw-thawaniy thant pam wiy al-alantan niiy keꞌ pam min paththam iiy-iiyaniya, an yaꞌa, nil puth piip God.angan ngangk niiyantaman kan thath-thathana. Than pam wanchangan nath thaaꞌ-kuump-kuumpiythan niiyangan-a, puth niiy meeꞌ God.antangan min keꞌam iiy-iiyaniya, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Aak keenkanamana, than pamangan wik thayan Moses.antamana putha wik pam prophets al-alantaman waaꞌ-waaꞌin thant pam wanchantan aak-aakanakaman nil pam John.an ngul wamp niiyanta, nil kootra ngakangan kuungk-kuungk niiyangana. Amanamaniya, an ngay ngul wik min paththam anangan waaꞌ-waaꞌang niiyantana nil God.angan kan-ngul meen-meenathow nungamang nil moom wuut piꞌan ngamparamana, pam wanch yot anangana maꞌ nungantangan ngul piꞌ-piꞌow thanang. Puth than pam wanch yot anangan thaꞌ-thaꞌwuntan thanan yipam ngoonch-ngoonchayn aak God.antamakana aꞌ maꞌ nungantangan yipam wun-wunayna. ");
INSERT INTO wim_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Wik thayan Moses.antam anangan keꞌ wayamiythana yaꞌa, an ngulakam minam anman wun-wunayna. Yuw an kenyan aꞌ putha aak inana an ep-paththam minchow ngul, puth wik thayan Moses.antaman yotam anangan minam anman wun-wunayn ngulakama. ");
INSERT INTO wim_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Nil pam weeꞌang wanch thum nungantaman too wantiyan-a, aꞌ wanch thon ngulan maayiy-a, an nil pamana maarich keeꞌ-keeꞌana. Nil pamang nathwey wanch anan maayiy nunang, nil pam nungantamang kaꞌathaman want nunang-a, an keꞌ nil maarich keeꞌ-keeꞌan nungant pamaniya.” ");
INSERT INTO wim_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Aꞌ nil Jesus.angan wik kath thonangan ngul waaꞌ thant, “Niiyalang, niiy kan wik kath inan ngeeyāna. Nil pam maꞌmangkiy alangana ngook min-miniy anangan ngoonch-ngooncha, aꞌ puth may minh yot piꞌ-piꞌ aawuch nungantamangan yipam mungk-mungkowa. ");
INSERT INTO wim_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Aꞌ nil pam namp Lazarus inaniya wukal keꞌanangwey wun-wuna, nil way-wayam paththam wun-wuna, wenchang kempan pakang makin nunanga. Ngaaꞌ thon-thonangana than kampan nungantam al-alangan aawuch pam maꞌmangkiyantamakan kal-kalin nunang aꞌ thaaꞌ door thinth angman nyiin-nyiinathin nunanga. ");
INSERT INTO wim_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Nil pam maꞌmangkiy alangan may kan-ngulan minch-minchath-a, nil pam Lazarus alangan may nhanth anangan mungk-mungk, aakangan keek-keekin. Aꞌ than kuꞌ anangan wamp-wampin nungant aꞌ wench nungantam anangan piint-piintina. ");
INSERT INTO wim_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Anpalana, nil pam Lazarus.an utham ngul aꞌ than ngaantiyongk al-alangana kalin nunang Abraham.antang yipam wun-wunow aak ing kenyan. Amanamaniya nil pam maꞌmangkiyan ngul utham aꞌ than kaampin nunang ngul. ");
INSERT INTO wim_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Aꞌ nil aak-aakanakan iiy pam wanch mul wiy anangan wun-wuntan aꞌ aak way angana nil thaaꞌ-eench-eenchanang wun-wun ngul. Anpalana nil um keny ngul thath aꞌ nil Abraham.an thath nunang aꞌ putha Lazarus.an Abraham.antangan nyiin-nyiina. ");
INSERT INTO wim_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Aꞌ nilan pech-pech nungant Abraham.antan, ‘Ayyang, Abraham-ang, wuut mangk ngatharam-ang, nint ngayang keꞌ ngangk mamin ey? Nint Lazarus.an pal kuchān ngathara, nil yipam maꞌ puk thonam nungantamana ngakang punchathowa aꞌ thaaꞌnganth ngatharamangan wunpow aꞌ kuchar yipam weemowa. Ngay puth thaaꞌ-eench-eenchang, thumang ingan pench-penchang.’ ");
INSERT INTO wim_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Nil puth Abraham.an kan-ngul thaw nungant, ‘Nint inan ngaantam-ngeeyāna: nint earthangan yippak wun-wunan-a, nint way min min-miniy yot piꞌ-piꞌana. Puth nil Lazarus.antana aak way thak wamp-wamp nunganta, nil may minh keꞌananga, aꞌ way min keꞌananga wun-wunweya. Yaa, nil inan ngangk min-minangam ngul wun-wunana, puth nintaniya ep thaaꞌ-eench-eenchangan ngula. ");
INSERT INTO wim_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Aꞌ puth aak menh-menhang inan ngamparangan-a, an keꞌ awar pek kech wun-wunana. Ngan wonk naakanakan keꞌ iiyin, yaꞌa, aꞌ niiy pal wonk iikanakan thamp keꞌ iiyina.’ ");
INSERT INTO wim_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Aꞌ nil pam maꞌmangkiyan thaw Abraham.antan, ‘Ayyang, wuut mangk ngatharam-anga, ngay kan inan thawāng nungkara, nint Lazarus.an keꞌ kuchin nunang aak piip ngatharamantamakan ey? ");
INSERT INTO wim_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Nil yipam wik waaꞌow thant pam kuunch ngatharam five al-alantan than wayan keꞌ iiy-iiyayn keꞌ ngay yimanangan way iiy-iiyangana, than thampang pal keꞌ yipam iiyayn aak way iikanakana, than puth ngul thaaꞌ eench-eenchina.’ ");
INSERT INTO wim_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Aꞌ Abraham.an thaw nungant pam alantan, ‘Yaꞌa, than kuunch nungkaram al-alangan wik kanam ngeey-ngeeyin wik thayan Moses.antamana putha wik pam prophets al-alantamana. Thanana wik thayan anangan puth min-minam ngeey-ngeeyiythana.’ ");
INSERT INTO wim_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Puth nil paman thaw nungant, ‘Yaꞌa, wuut mangk ngatharam Abraham-ang, an than wik keꞌ ngeey-ngeeyiythana, puth nil pam nathwey mulaman koyam ekiy-a, aꞌ pek ukiy thant-a, aꞌ thawiy thanta wayan keꞌ-ngul yump-yumpayn-a, yaa, than wayan puth too ngul wantayna.’ ");
INSERT INTO wim_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Nil puth Abraham.an wik inangan thawa, ‘Than nathwey wik thayan Moses.antamana putha pam prophets al-alantaman keꞌan ngeey-ngeeyayn-a, yaa, an puth than wik pam mul al-alantaman keꞌ ngeey-ngeeyiythan, yaꞌa.’” ");
INSERT INTO wim_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Aꞌ nil Jesus.an thaw thant ngurp nungantam al-alantan aꞌ wiy al-alantan tham than nunangan monkan-wak-wakin, “Pam wanch wiy al-alangan ngul thaach-thaachayn niiyang way yumpanakana. ");
INSERT INTO wim_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Yaa, niiy wik kath in ngeeyāna: pam wiy al-alangan nathwey kunttow wuut piꞌan pam alantan manang kathiythan nungant-a, aꞌ anpalaniya woꞌuw um-menhang aakanakan kaliythan nunang-a, aꞌ poo thaꞌiythan nunang ngak thangk aakanak pekan-a, in puth way nungant. Puth nil pam alangaman nathwey pam wanch ngatharam anangan thaach-thaachiy thanang way yumpanakan-a, an aak way-wayam paththam wampow nungant, pam alantan nilan thaach-thaachan thananga. ");
INSERT INTO wim_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Niiyaniya minam anman iiy-iiyāna, wayan keꞌ iiy-iiyān, yaꞌa. Niiy putha kan in ngeeyāna: nil kampan niiyantam alangan nath way yumpiy niiyant-a, niiywey wik waaꞌān nungant nilan way yump niiyanta. Nil nathwey wik ngeeyiy niiyang aꞌ wayan wantiy-a, aꞌ sorry thawiy niiyant-a, yaa, puth niiyanganiya kon-ngul ngathiwa. ");
INSERT INTO wim_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Nil way kanan yumpiy niiyant-a, nil nath wampiy niiyant aꞌ thawiy niiyant ngul, ‘Ayyang, ngay in wampang nungk, ngay sorry yipam thawāng, way anpalan ngayan yumpang nungkara.’ Yaa, niiyaniya keꞌ-ngul ngaantam-ngeey-ngeeyān way nilan yump niiyanta. Nil nathwey engk-engkiy niiyanta maꞌ sevenakam kinch thonamangan-a, yaa, niiyaniya kan-ngul kon-ngath-ngathow niiyang way nilan yump-yump niiyanta.” ");
INSERT INTO wim_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Aꞌ anpalana than ngurp nungantam anangan thawin nungant Jesus.antan, “Nint maꞌ-aath-aathān ngananga, ngan yipam keꞌ-ngoongkam anman ngangk nganttamangan piꞌ-piꞌān nintanga.” ");
INSERT INTO wim_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Nil puth Jesus.an kan-ngul thaw thant, “Niiy minam keꞌ yippak ngayang ngangkangan piꞌ-piꞌaniy yaꞌa. Niiy nath ngangkang manyam piꞌ-piꞌin ngayangan-a, keꞌ kaanch many yimanangana, niiyan yuk ilantan puth thawina, ‘Ayyang, yuk-ang, nint aak imanaman pentāna aꞌ woꞌuw um-menhang angan kaampān nungkarakama.’ Aꞌ anpalana, yukan erkam pentow aꞌ kaampow nungantakaman woꞌuw um-menhang angan.” ");
INSERT INTO wim_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Aꞌ nil Jesus.an in-ngul thaw thanta, “Niiy nathwey pam thonam piꞌ-piꞌin nunang workan iiy-iiyiy niiyanta puth aak ngaanhan weꞌ-weꞌiy may kaampanakana, aꞌ minh sheep niiyantam anangan piꞌ-piꞌiy thananga. Yaa, nil paman nath wampiy workam ngulan-a, niiyan puth wik inangan keꞌ thawin nungant, ‘Ayyang, nint pal erkam wampāna, aꞌ nyiinān, aꞌ puth may mungkān ngatharanga!’ Yaꞌa, niiy wik yimanangan keꞌ thawin nunganta. ");
INSERT INTO wim_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Puth niiyana wik inangan ep thawin nungant, ‘Nint kan may kiingkān ngathara, aꞌ amanamana nint ngook min-minam ngul ngoonchāna, aꞌ may ngulan pal paththam kalān ngathara. Ngay may kanan minchathāng-a, amanamaniya nint ngul may mungkāna.’ ");
INSERT INTO wim_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Nil pam alangan wik inangan ngeeyiy niiyangwey-a, niiyan puth thaaꞌ-kuump-kuumpin nunang ey? An yaꞌa, puth niiyam thawan nungant nil work anman iiy-iiyow niiyanta. ");
INSERT INTO wim_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Puth niiyantan yimanang thamp wunana: niiy nathwey wik yotam God.antaman ngeey-ngeeyinan-a, niiy ulp-ulpanangan keꞌ iiy-iiyān yaꞌa. Niiy thawān nungant God.antan, ‘Ngan min paththam yaꞌa, ngan work anman thonakam iiy-iiyanan nungkar work nintan theeꞌan nganta.’” ");
INSERT INTO wim_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Aꞌ anpalaniya, nil Jesus.an kan-ngul iiy-iiy aak Jerusalem.akan, nil woyan anman wak-wak menh-menhangan iiy-iiy aak Samaria-a, putha aak Galilee wakanana. ");
INSERT INTO wim_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Anpalan-a, nil Jesus.an aak village thonamang ngoonch. Than pam ten al-alangan thathin nunang Jesus.an-a, than kecham pech-pechin nungant. Thananiya penchiyang mak thanang, nanpalan weech-weech thanang. ");
INSERT INTO wim_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Than othamayan pechin nungant Jesus.antaniya, “Ayey! Jesus ey! Pam piꞌan ey! Nint nganang keꞌ ngangk mamin ey?” ");
INSERT INTO wim_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Nil Jesus.angan ngeey thanangan-a, nilan thaw thant, “Niiy koyam iiyān thant pam priests al-alantana, meenathwun thanta than yipam thathayn niiyanga.” Puth thanana kan-ngul iiyin, aꞌ than thath-thathwin thanttakaman woyan ompamangan, than kemp min ngulan iiy-iiyin, wench keꞌanang ngul weenin. ");
INSERT INTO wim_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Nil pam thonam ilangan thath nungantakaman-a, koyam ngul epank Jesus alantan. Nil othamayan thaaꞌ-kuump-kuump nunang God.aniya, ");
INSERT INTO wim_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","aꞌ pungkang ngul nyiin, kuchek pekam thuch Jesus.antan, aꞌ thaw nungant, “Nint ngayang minam paththam ngul yumpana, ngay puth palam iiyang nungka, thankyou thawāng nungkara!” Nil pamaniy-a, aak Samaria punchana. ");
INSERT INTO wim_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Aꞌ nil Jesus.an thaw ngul ngurp nungantam al-alantan, “Ngay pam ten anangan miyalathangan thananga, puth pam wiy anangan wanttin e? ");
INSERT INTO wim_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Nil pam thonam inan aak Samaria punchana ep palam wamp ey? thaaꞌ-kuump-kuumpow nunang God.aniy ey?” ");
INSERT INTO wim_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Aꞌ Jesus.an puth thaw nungant pam alantan, “Nint wik ngatharam ngangkangan piꞌ-piꞌangana, nanpalan nil God.angan miyalath nintang, aꞌ ngangk min yump nintang. Aꞌ kan ekāna aꞌ nint kan iiyān aak nungkaramaka.” ");
INSERT INTO wim_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Aꞌ than pam Pharisees anangan engkin nungant Jesus.antan, “Nil God.angan aak ngeen nathan meenathow nungamang nil moom piꞌan paththaman iiyow a?” Nil puth Jesus.ana thaw thant, “Nil engk-engkanangan keꞌ meenathiw nungamang nil moom piꞌan want-wanttakan iiy-iiyan. ");
INSERT INTO wim_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Niiy wik yimanangan keꞌ thaw-thawāna, ‘Eeꞌa, nil inman paththama!’ or ‘Nil nanman wampa!’, an yaꞌa. Puth niiy kan thathan meeꞌ niiyantamangan ngay want-wanttakan iiy-iiyanga, niiy nanpalan kan-ngul meeꞌmiy weenan nil God.an moom wuut piꞌan paththamana.” ");
INSERT INTO wim_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Aꞌ amanamaniya nil Jesus.an thaw thant ngurp nungantam al-alantan, “Aakan ngul wampowa, niiyan puth thaw-thawān, ‘Ngan pal ey! maꞌ-thonaman thathin nunang pam anan nil God.angan kuchana.’ Puth yaꞌa, niiyan keꞌ-ngul thathān ngayanga! ");
INSERT INTO wim_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Than pam wanch wiy anangan thaw-thawiythan niiyanta, ‘Ayyang, niiy kan nan thathāna, nil nanmana,’ or ‘Niiy kan an thathāna, nil anmana!’ Puth yaꞌa. Niiy keꞌ iiyān thanttang thathanakana. ");
INSERT INTO wim_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ngay palam erkam keꞌ ngaay yimanangan palaman wampānga aꞌ yuw in kenyan park-parkathāng. Pam wanch yot yompanamangan meeꞌ thanttamangan thathayn. ");
INSERT INTO wim_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Puth kaꞌathamaniya, than pam wanch way paththam ngul iiy-iiyayn ngathara. Than pam wanch inangan man-yethaman iiy-iiyantan-a, than man-mangkam ngul theeꞌayn ngathara. ");
INSERT INTO wim_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ngay putham ngulan palaman wampāng-a, pam ngay inman nil God.angan kuch ngayang-a, aniy-a, keꞌ keenkanamana aak an-aniyangan nil Noah.an wun-wuna, aakan yimanangan wun-wunowa. Than pam wanch anangan keꞌ-ngoongkam anman iiy-iiyin, keꞌam wik ngeey-ngeeyin, yaꞌa. Aakan-a, yimanangan wunowana. ");
INSERT INTO wim_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Than pam wanchangana may yot-yotam mungk-mungkin, than ngent-ngentwin thakan, nil yimanaman, aak-aakanakaman Noah weeꞌanangan pek ngulan ngoonchin chukkun wuut piꞌanangana. Aꞌ kaap wuut piꞌan paththam wamp thant, aak umyompanamana luuꞌ pip, ngakanganiy. Aꞌ pam-a, wanch-a, puk manyiy maꞌmangkaman ngakang thuch-thuchin aak umpuyam. ");
INSERT INTO wim_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Aak anan yimanangan wun nil pam Lot.an iiy-iiy keenkanamana. Pam wanch maꞌmangkamangan may-a, minh thakan mungk-mungkin, way min thakan piiy-piiyin, putha way min thakan sellimpung-pungin. Aꞌ than may kaanch anangan kaamp-kaampin mayakan aꞌ putha aawuch yot kaach-kaachina, nil yimanaman. ");
INSERT INTO wim_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Aꞌ nil pam Lot.angan aak Sodom.an kan-ngulan want-a, nil piip God.angan thum nganth piꞌan inpal keny kuch aꞌ yuk keꞌ kerosine yimanangan kuch thama, erkam pench-penchin, kuchek thanttang thinth angman keek-keekin, aꞌ pam wanch puk yotam anangan uthamin ngula. ");
INSERT INTO wim_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ngay putham ngulan wampāng-a, aakana yimanangan wunowa. Aak an-aniyangana, ngay ngul meenathāng ngathamang pam wanch puk manyiy maꞌmangkamantan ngay pam inman God.angan kuch ngayanga. ");
INSERT INTO wim_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Aak an-aniyangana, nil nath pam yoon nyiin-nyiiniy angman aawuch nungantamang thinthan-a, yaa, nilan putha koyaman pek keꞌ ngoonchiy yuk way min anangan yipam maayow thananga, yaꞌa. Nil pam nathwey work iiy-iiyiy aak garden angan-a, yaa, nilaniya puth koyamana pek keꞌ ngoonchiy aawuchangan way min nungantam anangan yipam maayow thanang yaꞌa. ");
INSERT INTO wim_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Niiy puth anan thamp ngaantam-ngeey-ngeeyān wanch Lot.antamana. Nil koyaman weent thathanakan aꞌ nilan utham ngul. ");
INSERT INTO wim_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Nil weeꞌang nungantakaman min-minakam piꞌ-piꞌow-a, nilan puth ngangk minangam keꞌ iiy-iiyowa. Nil weeꞌang pam wanch wiy anangan minaman piꞌ-piꞌiy thanang-a, yaa, puth nilana ngangk min-minangam paththam iiy-iiyowa. ");
INSERT INTO wim_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Aak an-aniyangana ngay palam ngulan wampāng-a, pul pam kucham nath bedang karpam weep thayan wun-wuniypula. Nil piip God.angana pam thonam nath ep kaliya, nil pam thonangananiya angman nath wantiy nunang bedang angman wun-wuniya. ");
INSERT INTO wim_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Aꞌ wanch kuchamwey natha work karpam iiy-iiyiypula may kaanch anangan nhanth-nhanthathiypul. Nil piip God.angana wanch thonam ep nath kaliy nunanga, nil wanch thonaniya angman wantiy nunanga workan iiy-iiyiya.” ");
INSERT INTO wim_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Aꞌ thanan puth thaw-thawin nunganta, “Ayyang, moom-ang, aak wantting aak yimanangan wampow e?” Nil puth Jesus.an thaw ngul thant, “Niiy waath anangan thathaniy thanang aak thonamangan yal-yalmathwuntan-a, yaa, niiyan puth meeꞌmiy minh mul aakanakan yal-yalmathwuntana. Yaa, niiy yimanangana ngul thiichāna ngay aak ngeen nathan wampānga pam wanch anangan ngulan than-thanathāng thanang um ngatharangana.” ");
INSERT INTO wim_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Anpalana, nil Jesus.angan wik kath inan waaꞌ thant pam wanchantan nil yipam thaaꞌ-aath-aathow thanang meeꞌ anman wuth-wuthanamayn nungant piip God.antana, keꞌ eench-eenchayna. ");
INSERT INTO wim_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Yaa, nil wik kath inan waaꞌ thant, “Aak town thonamangan-a, pam piꞌan wun-wun, nilan pam wanch mep-mep thanang courtangan. Nilan minam keꞌam ngaantam-ngeey-ngeey piip God.an puth pam wanch wiy anangan thamp keꞌam ngaantam-ngeey-ngeey thanang, yaꞌ anmana. ");
INSERT INTO wim_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Nil wanch wukalongk aak town angan wun-wun aꞌ nilana maꞌ-yotam wamp-wamp pam piꞌan alantan aꞌ puth-puthamim thaw-thaw nungant thaaꞌ-mamananga, ‘Nint ngayang keꞌ weekin ey? pam alantaman nil wayan yump-yumpan ngathara.’ ");
INSERT INTO wim_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Kaꞌathamaniya nil pam piꞌan alangan kaangk keꞌ weekow nunangana pam way alantaman, yaꞌa. Puth anpalaniya, nilana ngaantam-ngeey ngul nungantakaman, ‘Ngay puth kaangk keꞌ God.antamana puth pam wanchantamana. ");
INSERT INTO wim_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Puth nil wanch inman maꞌ-yotam wamp-wampan ngathara, aꞌ wik anman thaw-thawan ngathara. Yaa, ngay puth weekāng nunangweya pam way alantamana. Ngay keꞌan weeking nunangwey-a, puth nilan pal-palam ngul wamp-wamp ngathara, nil ngul eench-eenchath ngayanga.’” ");
INSERT INTO wim_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Aꞌ nil Jesus.an thaw thant, “Niiy kan ngaantam-ngeeyāna nil pam piꞌanan wik thaw. Nil pam waya! ");
INSERT INTO wim_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","8","Nil piip God.angan thamp maꞌ-minangam ngul piꞌ-piꞌow thanang pam wanch nungantam anangana than thaaꞌ-thaaꞌan thaw-thawantan nungant maꞌan-aathow thanang. Nil yaaman puth keꞌ kuupiya, nil erkam paththam maꞌ-aathow thananga.” Aꞌ nil Jesus inan tham thaw, “Ngay pam inman nil God.angan kuch ngayanga. Ngay palaman aak iikanakan wampāng-a, ngay ngul pam wanch anangan uwāng thanang ey? than ngayangan ngangkang piꞌ-piꞌantan ey?” ");
INSERT INTO wim_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Aꞌ nil Jesus.angana wik kath thonangan ngul waaꞌ thant pam wanch wiy al-alantan thanan ngaantam-ngeeywin thanttakaman than keꞌ minan iiy-iiyin puth than pam wanch wiy anangana than way waaꞌin thanang. ");
INSERT INTO wim_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Nilan wik kath inan waaꞌ thanta, “Pul pam kucham aawuch ngench thayanakan iiypul meeꞌ-wuthanamanakan piip God.antan. Nil pam thonamaniya pam Pharisee, nil pam thon alanganiya, wukalan yal-yalmath Government al-alantana. ");
INSERT INTO wim_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Nil pam Pharisee.ana wur ek aꞌ wik inangan thaw God.antan, ‘Ayyang, God-ang, ngay thankyou thawang nungkara, ngay pam way yaꞌa keꞌ wiy anangana. Aꞌ putha ngay pam yangk thamp yaꞌa. Ngay way min pam wanch wiyantaman keꞌ maꞌ-kuch-kuchathang yaꞌa, putha ngay maarichan keꞌam keeꞌ-keeꞌanga, yaꞌa. Ngay keꞌ pam thon inan way yaꞌa wukalan yal-yalmathan thanttam wiyantam puth wiy nungantakaman piꞌ-piꞌan, ngay in ep pam min paththama. ");
INSERT INTO wim_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Week thon-thonangana, ngay may keꞌam mungk-mungkanga kinch kuchamakan, ngay yipam nintangan ngaantam-ngeeyāng. Aꞌ putha ngay wukal yotam ngatharaman theeꞌ-theeꞌang nungkara. Ngay one hundred dollars nath piꞌ-piꞌingwey-a, ngay ten dollars theeꞌing nungkar, ngay two hundred dollars nath piꞌ-piꞌingwey-a, ngay twenty dollars theeꞌing nungkar, nil yimanamana.’ Nil pam Pharisee.ana yimanangan meeꞌ-wuthanam piip God.antan. ");
INSERT INTO wim_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Puth nil pam thonaniya wur ek aꞌ kecham than pam Pharisee alantaman aꞌ puth wiy al-alantaman aawuch ngench thayanangan. Nil pam inman ulp-ulpanang keꞌam um kenyan thath, yaꞌa. Nilan kaaꞌ-um-pek than, meeꞌ-wuthanamanang thaw, ngangk way-wayam paththam wun nungant. Aꞌ nil wik inangan thaw piip God.antan, ‘Ayyang, God-ang, nint ngangk mamān ngayanga, aꞌ putha min iiyānara. Ngay way anman yump-yumpang meeꞌ nungkaranga.’” ");
INSERT INTO wim_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Anpalana nil Jesus.an thaw thant ngul, “Niiy wik inan ngeeyāna! Nil piip God.angan ngangk mam nunang ngul pam nilan wukalan yal-yalmath aꞌ kon kan ngath nunang way nilan yump-yump. Puth pam thon Pharisee anan yaꞌa, God.angan keꞌ kon-ngathiy nunang way nilan yump-yumpa, yaꞌa. Nil weeꞌangweya pam piꞌan nath yumpiy nungamangan-a, ngul-ngulaniya nil pam many ngul weenowa. Nil weeꞌ-nathweya ulp-ulpanang keꞌaman iiy-iiyan-a, puth pam mochanana, ngul-ngulaniya nil pam piꞌan paththam ngul iiy-iiyowa.” ");
INSERT INTO wim_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ngul anpalaniy-a, pam wanch wiyangan-a, puk manyiy thanttaman wampathin nungant Jesus.antan nil yipam maꞌ wunpow thanttang, puth than ngurp nungantam al-alangana thathinan thanang-a, aꞌ yaꞌ kenthin thananga, ");
INSERT INTO wim_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","puth nil Jesus.an thaw thant puk manyiy al-alantan, “Pal iiyān ngathar,” aꞌ nil thaw thant ngurp nungantam al-alantan, “Niiy keꞌ kenthān thanangweya, puk manyiy inanganiya mak wampayn ngathara! puth nil God.angan kaangk maꞌ nungantangan piꞌ-piꞌow thananga. Than weeꞌ-weeꞌanangan keꞌ puk manyiy yimanangan ngangk minangaman wampayn nungant God.antan-a, an nil min-minakam ngul piꞌ-piꞌow thananga, aꞌ than maꞌ nungantang ngul wun-wunayn. ");
INSERT INTO wim_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Wik inangan keꞌ kon-ngathow niiyanga! Than puth weeꞌ-weeꞌanangan keꞌ puk manyiy ngangk minangam keꞌan wampiythan nungant-a, an nil God.angan min-minakam keꞌ piꞌ-piꞌow thanang maꞌ nungantangan, yaꞌa.” ");
INSERT INTO wim_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Anpalana, nil pam piꞌan Jew wamp nungant Jesus.antan aꞌ engk nungant, “Moom-ang, nint kan-kanam paththam mina. Nint kan inan waaꞌānara ngay want-wanttakan iiyānga, ngayan yipam God.antang aak umpuyaman wunānga.” ");
INSERT INTO wim_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Nil puth Jesus.ana thaw nungant, “Nint puth pam min ngeenak waaꞌangan ngayang e? An nilam thonakam God.ana minaniya, wiy anangan yaꞌa. ");
INSERT INTO wim_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Nint puth wik ngench thayan God.antaman meeꞌmiya: niiy wanch pam thon alantamana keꞌ maarich keeꞌathāna; niiy pamana keꞌ mulathāna; niiy yuk way min meekantamana keꞌ maꞌ-kuchathāna; niiy pam wanch wiyana wik aak-yaꞌangan keꞌ waaꞌ-waaꞌān thananga; putha niiy kaath piip niiyantamana wik ngeey-ngeeyān thananga.” ");
INSERT INTO wim_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Nil puth paman thaw nungant Jesus.antan, “Moom-ang, aak anpalman ngay yippak puk manyan iiy-iiyangan-a, ngay wik ngench thayan inangan piꞌ-piꞌangan thanang.” ");
INSERT INTO wim_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Nil Jesus.angan wik nungantaman ngeey-a, nil thawant, “Nint inan thamp yumpāna. Nint koyam iiyāna, aꞌ yuk way min nungkaram maꞌmangkaman sellimpungāna, aꞌ wukal thakan theeꞌān thant pam wanch wiy wukal keꞌanang al-alantana. Anpalana, nint ngayang ngul monkan-wak-wakāna. Ngulana, nil God.an min-minam paththam ngul iiy-iiyow nungkar aak ing kenyana.” ");
INSERT INTO wim_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nil pam alangan wik inangan ngeey-a, ngangk way-wayam paththam wun nungant, nilan puth pam maꞌmangkiy iiy-iiya. ");
INSERT INTO wim_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Nil Jesus.ang paman thath nunang ngangk wayan wun-a, nilan puth thaw thant, “Than pam wanch maꞌmangkiy anangan puth want-wanttak iiyayn maꞌ God.antangan e? Nath yaꞌ yaakaꞌa! Puth wukal aꞌ way min anangan keeꞌ nath enchayn thanta! ");
INSERT INTO wim_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Nil camelan puth needle yuutamp manyangan wanttak ngoonchow e? An yaꞌ aa! Inan puth yimanangana. Pam maꞌmangkiyan puth want-wanttak maꞌ God.antangan iiyow e? An yaꞌa, thayan paththam wunow nunganta, woyan min God.antaman keꞌ nath uwiy, yaꞌa.” ");
INSERT INTO wim_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Than pam wanchangan ngeeyin nunang, aꞌ thawin nungant, “Nil God.angan weeꞌ kaaꞌ-piichanathow e? Nath yaꞌ yaakaꞌa!” ");
INSERT INTO wim_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Nil Jesus.an thaw thant, “Pam wanchangan keꞌ kaaꞌ-piichanathwiythan thanttakamana, an yaꞌa. Nil God.ang thonakam ep pam wanch kaaꞌ-piichanathiya, nilan ep piꞌan aꞌ thayan paththama.” ");
INSERT INTO wim_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Anpalana, nil Peter.an thaw nungant Jesus.antan, “In ngeeya, ngan aak nganttam wantan aꞌ nintang puth monkan-wak-wakanan ngul.” ");
INSERT INTO wim_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Nil puth Jesus.an thawa, “Eeꞌa, ngay nungkar in waaꞌānga: than pam wanch wiyangan aak thanttam aꞌ wanch thanttam, nath kuunch thanttam aꞌ kaath piipa aꞌ puk thanttam wantantan, thanan yipam workan iiy-iiyayn piip God.antan, aꞌ wik waaꞌ-waaꞌayn thant nil God.angan pam wanch yotam anangan ngul piꞌ-piꞌow thanang maꞌ nungantangana. ");
INSERT INTO wim_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Nil God.an yimanang ngulana ngangk min paththam ngul iiyow thant pam wanch al-alantana, aꞌ ngul-ngulana than nungantang ngul wunayn aak umpuyangam.” ");
INSERT INTO wim_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Anpalana, nil Jesus.angan pokkapang ngul kal thanang ngurp nungantam twelve anangan aꞌ thaw thant, “Niiy in ngeeyāna, ngamp inan yiip ngul iiyāmp aak Jerusalem.aka. Than way paththam ngul yump-yumpayn ngathar keꞌ than prophets al-alangan keenkanaman umpin lat ngench thayanangan, waaꞌin ngayang, ngay pam inman nil God.angan kuch ngayang. Niiyaniy ngul ngaantam-ngeeyāna than wik kan-kanaman umpina. ");
INSERT INTO wim_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Than pam wiy al-alangan ngayang ngul mamayn, aꞌ pam Jews yaꞌ al-alantan maꞌam theeꞌayn ngayanga. Thananiya ngul thaaꞌ-thengkathayn ngayanga, wik way paththam waaꞌayn ngayang, aꞌ thaaꞌ theekang thak mak-makayn ngayanga. ");
INSERT INTO wim_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Aꞌ than whipang thak piik-piikayn ngayanga, aꞌ amanamaniya mulathayn ngayang ngul, puth aak maꞌ-koꞌalamang ngulan wantow-a, ngay mulamana koyam ngul ekānga, aꞌ anman man-yetham ngul iiy-iiyānga aak umpuyangam.” ");
INSERT INTO wim_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Puth ngurp nungantam al-alanganiya than wik kumin nunang wik keꞌam thiichin nunang, yaꞌa. Than keꞌam min-min ngaantam-ngeeyin nunang Jesus.an nil wik want-wanttakan thaw-thaw thantana. ");
INSERT INTO wim_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ngul-ngulana nil Jesusa, putha pam wanch wiy anangan nungantangan iiy-iiyin-a, than thinth-thinth ngul wampin aak Jericho.akana. Aꞌ nil pam koꞌanchwey woyan wonkang angman nyiin-nyiin aꞌ nil may-a, wukalak thak thaaꞌ-pent-pent thant. ");
INSERT INTO wim_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Aꞌ nil wik wolmpan ngeey thanang pam wanch thaaꞌ-wantanam anangan woyan wakanan iiy-iiyin-a, puth nil pam koꞌanchan thaw thant, “An wanttak wik piꞌ-piꞌantan e?” ");
INSERT INTO wim_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Thanan puth thawin nungant, “Nil Jesus pam aak Nazareth punchanana inpal iiy-iiyan woyan wakana.” ");
INSERT INTO wim_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Aꞌ pam koꞌanchana othamayan pech paththam Jesus.antan, “Jesus ey! Kampan David.antam ey! Nint ngayang keꞌ ngangk mamin ey?” ");
INSERT INTO wim_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Than pam wanch anangan umputhan iiy-iiyin Jesus.antangan-a, thanana wakin nunang, “Ayyang, nint appap nyiināna.” Puth nil pamana puy-puyam othamayan ngul pech-pechwey, “Ayyang! Kampan David.antam-ang! Nint ngayang keꞌ ngangk mamin ey?” ");
INSERT INTO wim_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Aꞌ nil Jesus.an puth than aꞌ thaw thant, “Niiy pal kalān nunang ngathara.” Than thintham kan-ngulan wampathin nunang-a, nil Jesus.an thaw pam alantan. ");
INSERT INTO wim_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Nint ngeenaka?” Aꞌ nil pam koꞌanchan thaw nungant, “Ayyang, Moom-ang, ngay kaangk aak koyam thathāng ngula!” ");
INSERT INTO wim_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Aꞌ nil Jesus.an thaw nungant, “Aak inpalmana nint kan-ngul aak thath-thathāna, nint puth kan-kanam ngaantam-ngeeyangan ngayang ngay nintang koyam ngulan meeꞌ minan yumpānga.” ");
INSERT INTO wim_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Anpalaniya, pam alangan kan-ngul aak thath-thath. Aꞌ nilana Jesus.antang ngul iiy-iiyweya. Nil anman thaaꞌ-kuump-kuump nunang piip God.an. Than pam wanch yotam al-alangan thathin nunangan-a, than thampang piip God.an thaaꞌ-kuumpin nunang ngula. ");
INSERT INTO wim_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Anpalaniya nil Jesus.ana kan-ngul wamp aak Jericho.angan aꞌ anpalana puyamam ngul iiy aak Jericho wakanana. ");
INSERT INTO wim_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Nil pam thonam aak angan wun-wun, namp nungantiya Zaccheus. Nil pam inmana moom thanttam al-alantaman than wukal anangan yal-yalmathin Government.anta. Nil-thant pam inan Zaccheus.ana maꞌmangkiya. ");
INSERT INTO wim_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Puth nilan kaangk Jesus.an thathow nunang, puth yaꞌa, nil puth pam many otanga, puth than pam wanch yotangan ngath-ngathin nunang Jesus.ana. ");
INSERT INTO wim_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Yaa, nilaniy putha kamp umputh moꞌ aꞌ yukang mat nil yipam Jesus.an thathow nunang, puth nil Jesus.an woyan anpalan iiyow. ");
INSERT INTO wim_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Nil Jesus.an kanan wamp yuk thinthan-a, nil than aꞌ meeꞌ keny thath yukakan, aꞌ thaw nungant Zaccheus.antan, “Ayyang, Zaccheus-ang, nint pal erkam ukān a! Ngay puth aak nungkarang ang paanthāng a!” ");
INSERT INTO wim_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Aꞌ anpalana nil pam Zaccheus.ana erkam paththam uk yuk anpalan, aꞌ ngangk minangam kal nunang Jesus.an aak nungantamakan. ");
INSERT INTO wim_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Than pam wanch wiyangan thathin Jesus.an aawuch Zaccheus.antamakan iiy-a, thanan wik many thuuch-thuuchin Jesus.antamana. Thanan thawin, “Nil Jesus.ana pam way alantangan aawuch wunow ey!” ");
INSERT INTO wim_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Aꞌ amanamaniya Zaccheus.ana wur ek meeꞌ pam wanch yotantangan aꞌ thaw nungant Jesus.antan, “Moom-ang, nint in ngeeya: way min wiy ngatharam anangana ngay theeꞌāng thant pam wanch al-alantan than wukal-a, putha way min keꞌanangana. Aꞌ putha ngay wukal koyam ngul theeꞌāng thant pam wanch al-alantan ngayan wukal maꞌ-kuch-kuchathang thanttamana. Ngaywey nath one hundred dollars maꞌ-kuchathangan thanttam-a, ngay four hundred dollars ngul koyam theeꞌāng thant.” ");
INSERT INTO wim_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Nil puth Jesus.an thaw nungant, “Nil piip God.angan keꞌ-ngul ngaantam-ngeeyow nintan way yot yump-yumpan, aꞌ putha kampan nungkaram al-alantaman thamp kan-ngul kon-ngathowan way thanan yump-yumpin. Niiy kan-kanam ngul kampan nungantam Abraham.antaman weemana, niiy puth kan-ngul God.an monkan-wak-wakaniy nunanga. ");
INSERT INTO wim_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ngay pam inman nil piip God.angan kuchanya, ngay aak iikanakan ukangan ngay yipam wenk-wenkāng thant pam wanch al-alantan, than ngangk keꞌaman theeꞌin nungant piip God.antana, ngay yipam kaaꞌ-piichanathāng thanang way thanttam anpalan.” ");
INSERT INTO wim_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Anpalaniya nil Jesus-a, putha pam wanch anangan nungantangan iiy-iiyin-a, than kan-ngul iiy-iiyin aak um Jerusalem.akan. Than aak thinth ngulan wamp-wampin-a, pam wanch al-alangan kan-ngul ngaantam-ngeey-ngeeyin thanttakaman, “Aak Jerusalem.angan-a, nil piip God.angan yip-yipam meeꞌ-engkanang meenathow nungamang nil moom piꞌan paththamana, aꞌ pam wanch yotam anangana yal-yalmathow thanang maꞌ nungantangan ngul iiy-iiyayna.” Aꞌ nil Jesus.angan wik kath inan ngul waaꞌ-waaꞌ thant, ");
INSERT INTO wim_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“Pam wuut piꞌana aak nungantam anpalan kech iiy aak thonaka, than yipam aak anganiya moom wuut piꞌan paththam king yumpayn nunang. Amanamaniya, nilana ngaantam-ngeey ngul koyaman kan-ngul iiyow aakakan. ");
INSERT INTO wim_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Aak kaꞌathamana keꞌaman yippak want aak nungantaman-a, than pam ten anangan workan iiy-iiyin nungant-a, nil ump thanang angan wampayn nungant, aꞌ nil wukal twenty dollars thon-thonantan theeꞌ-theeꞌ thant pam al-alantan. Aꞌ thaw ngul thant, ‘Ngay wukal inangan theeꞌang niiyant niiy yipam way min piiy-piiyāna aꞌ putha amanamaniy niiyaniya way min anangana sellimpungān thanang wukal piꞌan yipam yumpān ngathara.’ ");
INSERT INTO wim_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Puth than pam wanch aak-kunch anangana kaangk keꞌ nungantam pam alantaman, yaꞌa. Thananiya pam wiy anangan wik thampang kuchin thanang aak-aakanakan nilan wun-wun. Than kan-ngulan wampin-a, thanan thawin thant, ‘Ngan kaangk keꞌ nunang pam inan moom piꞌanan iiyow nganta.’ ");
INSERT INTO wim_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Puth than pam wanch aakan punchanangana ep moom piꞌan king yumpin nunanga. Nil koyam ngulan iiy aak nungantamakan-a, aꞌ nil wik kuch thant pam ten al-alantan wampayn nungant nil yipam meeꞌmiy wunowa than wukal ngeen-ngeen nathan yumpin nungant. ");
INSERT INTO wim_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Pam thonam workan iiy-iiy nungantan-a, wamp nungant, aꞌ thaw nungant, ‘Ayyang moom-ang, two hundred dollars in nungkara. Nintan theeꞌan ngathar, twenty dollarsaman-a, ngay wukal piꞌan ngul yumpangana.’ ");
INSERT INTO wim_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Nil puth mooman thaw nungant, ‘Yaa, an mina, nint pam min paththama! Ngay workan theeꞌangan nungkara, nint work minam iiy-iiyan ngathara. Yaa, ngay work wuut piꞌan ep ngul theeꞌāng nungkar. Aak imanaman ngula nintaniya moom piꞌan paththam iiy-iiyāna aak town ten anangan piꞌ-piꞌān thanang.’ ");
INSERT INTO wim_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Aꞌ nil pam thon ngulan wamp nungant aꞌ thawant, ‘Ayyang, wukal nungkar ina one hundred dollarsana. Nintan theeꞌan ngathar, twenty dollarsaman-a, ngay wukal piꞌan ngul yumpangana.’ Nil puth moom nungantaman thawa, ");
INSERT INTO wim_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","‘An mina, aak imanam ngulana nintaniya moom piꞌan paththam iiy-iiyān aak town five anangan piꞌ-piꞌān thananga.’ ");
INSERT INTO wim_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Aꞌ amanamaniya pam thon ngulan wamp nungant moom-kunchantan aꞌ thaw nungant, ‘Moom-ang, wukal nungkaram in twenty dollarsa, nintan theeꞌan ngatha. Ngay puth work keꞌam iiy-iiyangan, ngay ingman piꞌ-piꞌang yuk hankyang kathangan nungka. ");
INSERT INTO wim_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ngayan puth meeꞌmiy nintan kaangk wak-wakān nganang, nanpalan ngay winynyang moꞌangan nungkarama, wukalan piꞌ-piꞌangan nungkara. Nintan thampa wukal piꞌan maay-maayangan pam wiy al-alantaman workan iiy-iiyantan nungkara, nungkarakaman piꞌ-piꞌangan ngula.’ Nil puth moom nungantaman thaw nunganta, ‘Nint in pam way-wayam paththam a! ");
INSERT INTO wim_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Wik nanangan nintan thawan ngathar-a, an ngay kan meeꞌmiy nint pam way paththaman aꞌ puth work keꞌaman iiy-iiyangana. Nint puth kan meeꞌmiy ngay pam ilangan kaangk wak-wakāng niiyang aꞌ puth ngay wukal piꞌanan maay-maayāng thanttam pam wiy al-alantaman workan iiy-iiyantana. ");
INSERT INTO wim_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Nint puth wukal ngatharaman ngeenak thenchan e? Nint bankang wunpin wukalaniya! Nintwey wukalan bankang yaaman wantin-a, yaa, nil pam alangan bankan piꞌ-piꞌan-a, wukal twenty dollarsan aꞌ puth wukal wiy thampan ngul theeꞌiy ngathara.’ ");
INSERT INTO wim_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Aꞌ nil pam mooman thant wiy al-alantan thaw angmanan than-thanin, ‘Twenty dollarsan maꞌam piiyān nunanga aꞌ niiy pam alantan theeꞌān nungant two hundred dollarsan piꞌ-piꞌana.’ ");
INSERT INTO wim_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Thanan puth thawin nungant, ‘An nil wukal piꞌan kan piꞌ-piꞌana.’ ");
INSERT INTO wim_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Aꞌ nil pam mooman wik inangan thaw thant, ‘Ngay inan thawāng niiyanta. Nil pamangweya work many minam anman iiy-iiyiywey-a, yaa, ngayaniya work piꞌan ngul theeꞌing nunganta. Nil nathwey work minam keꞌan iiy-iiyiy-a, yaa, ngayaniya thawing nungant work anpalan pentowa, aꞌ pam thon alantan theeꞌing work nungantamana.’ ");
INSERT INTO wim_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Aꞌ pam moomana putham ngul thaw thanta, ‘Than pam al-alangan ngayangan ngangk-wayangaman kal-kalin wanttin ngul iiyin e? thanan kaangk keꞌ pam piꞌan kingan yumpayn ngayanga. Niiy pal kalān thanang ngathara aꞌ niiy mulathān thanang ingman meeꞌ ngatharanga.’” ");
INSERT INTO wim_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Nil Jesus.an wik kanan thaw-a, nil keenk iiy kuuw aak Jerusalem.ak. ");
INSERT INTO wim_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Nil kanan ongkam-a, nil thinth-thinth ngul wamp aak village kuchamakan, aak namp al-alantaniya Bethphage-a, aꞌ Bethanya. Aꞌ Jesus.angan ngurp nungantam kucham anangana keenk kuch pulang. ");
INSERT INTO wim_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Nilan thaw pulanta, “Nip village aakanakan iiyow. Nip angan wampowan-a, nip donkey many thathow kuuyang kathin nunang, than pam wiyangan keꞌam yippakan matin nunang. Nip kuuyan thapathow, aꞌ nip pal kalow nunang ngathara. ");
INSERT INTO wim_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Nil weeꞌ-nathan thawow nipar, ‘Nip donkey many nanan ngeenak kalanip nunang e?’ nipan thawow nunganta, ‘Nil moom nganttamangan yaan matowana.’” ");
INSERT INTO wim_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Anpalaniya, pul kan-ngul iiypul, aꞌ donkey manyan angman uwpul nunang keꞌ nil Jesus anman thaw pulant. ");
INSERT INTO wim_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Pul kuuyan yippak thap-thapathpulan-a, than moom donkey many alantamana thathin pulangan, aꞌ thanan thawin pulant, “Nip donkey many nalantaman ngeenak kuuyan thapathanip e?” ");
INSERT INTO wim_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Pulaniy thawpul thant, “Nil moom nganttamangan yaan matowana.” ");
INSERT INTO wim_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Yaa, anpalaniya, pulan koyam iiypul donkey manyan kalpul nunang Jesus.antan. Amanamaniya, ngook pulantaman kenyangk wunppul donkey manyantangan, aꞌ ngula, pul maꞌ-aathpul nunang Jesus.ana peyow donkey many alantangan. ");
INSERT INTO wim_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Nil iiy-iiy ngulan-a, than pam wanch yotamang ngul ngook thanttaman woyanangan wunp-wunpin, weꞌ-weꞌarathin nungant Jesus.antan. Aak thant yimanangan wunana, puth nil pam piꞌan. ");
INSERT INTO wim_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Than kan-ngulan thinth wamp-wampin Jerusalem.akan-a, than yoyk amanaman namp Olives.an woyan pekam kan-ngul uk-ukin. Woyan anganiya pam wanch yot anangan yal-yalmathwin thanttakaman, aꞌ thaaꞌ-kuump-kuumpin nunang piip God in kenyana. Wik itangam yaꞌa, wik othamayan thankyou thaw-thawin God.antana, puth nil Jesus.angan work piꞌan min-miniy anangan yump-yump meeꞌ thanttangana. ");
INSERT INTO wim_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Than wik inangan pech-pechin, “Pam inan King ngampar! Nil God.angan kuchana, nil mak yumpow nunang piꞌananiya! Ngamp thaaꞌ-kuump-kuumpāmp nunanga! Than ngaantiyongk anangan in kenyan wuntana, ngangk min wun-wunayn nungantam Jesus.antamana. Ngamp yotamang God.an thaaꞌ-kuump-kuumpāmp nunanga, nil min aꞌ piꞌan paththama!” ");
INSERT INTO wim_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Anpalaniya, pam piꞌan Pharisees anangan, angman than-thanina, aꞌ than thawin nungant Jesus.antan, “Moom-ang, nint thawān thant ngurp nungkaram al-alantan, ‘Appapa! wik keꞌanang iiyayna!’” ");
INSERT INTO wim_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Nil puth Jesus.an thaw thant, “Ngay kaangk keꞌ thanan wik keꞌanangan iiyayna. Ngay kan-kanam thawāng niiyanta: ngurp ngatharam inangan appapwey iiy-iiyiythan-a, kunttow inangan wik othamayan pech-pechayna!” ");
INSERT INTO wim_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Nil Jesus.an aak Jerusalem thinth kanan wamp-wamp-a, nilana aak townan thatha aꞌ peey paththam pam wanch puk al-alantaman anganan wun-wunina. ");
INSERT INTO wim_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Aꞌ nil thaw ngul, “Ngay kaangk paththam niiy meeꞌmiy wunān niiy want-wanttakan ngangk minangam iiy-iiyān maꞌ nungantang piip God.antangana, an puth niiy meeꞌmiya yaꞌa, an keꞌ niiy woyan minan keꞌ thathin yaꞌa. ");
INSERT INTO wim_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","44","Aak way paththaman ngul wampow niiyant. Pam way kulliyangan ngul weentathayn aak niiyantamana aꞌ thanan walls yumpayn niiyant niiy yipam yoon keꞌ pentāna aꞌ keꞌ appenchān nathaniya. Aꞌ than pam wanch puk manyiy tham maꞌmangkam mulathayn niiyanga aꞌ puth aawuch niiyantam anangana, puth way min maꞌmangkam anangan wayathayn thanang. Aakana way-wayam paththam ngul wunow, than yuk way min pal-puy theeꞌ-theeꞌayn, kunttow thakan than aawuchan kaach-kaachin. Niiy puth pam inan keꞌam ngaantam-ngeey-ngeeyan ngayang nil piip God.angan kuchanya ngay yipam kaaꞌ-piichanathāng niiyanga way niiyantam anpalana.” ");
INSERT INTO wim_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Anpalaniy-a, nil Jesus.an aawuch ngench thayanak iiy, aꞌ nil kenth thanang pam anangan than minh thakan sellimpung-pungin aawuch ngench thayanangana. ");
INSERT INTO wim_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Aꞌ nil thaw thant, “Than keenkanamana wik inangan God.antaman lat ngench thayanangan umpin, ‘Than aawuch ngench thayan ngatharaman aak pam wanchantan meeꞌ-wuthanamanakan waaꞌayn, puth niiy pam wanch il-ilangan aawuch iikanakan yalmathwuniy yipam wukal way min wiyantaman maꞌ-kuch-kuchathāna.’” ");
INSERT INTO wim_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ngaaꞌ thon-thonangana nil Jesus.angan pam wanch thaaꞌ-aath-aath thanang aawuch ngench thayanangana. Than moom priests al-alantamana, aꞌ puth than pam piꞌan than wik thayan anangan thaaꞌ-aath-aathinan-a, aꞌ pam piꞌan wiy anangana, thanana kan-ngul ngaantam-ngeeyin thanttakaman than Jesus.an mulathayn nunanga, ");
INSERT INTO wim_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","puth yaꞌangam, than want-wanttakan mulathayn nunanga, puth than pam wanch yotamangan kaangk wik nungantaman ngeey-ngeeyayna, than kaangk wik maꞌmangkam anangan ngeey-ngeeyayn nungantamana. ");
INSERT INTO wim_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ngaaꞌ thonang ngulan-a, nil Jesus.angan pam wanch anangan thaaꞌ-aath-aath thanang aawuch ngench thayanang angan, nil wik minan waaꞌ-waaꞌ thant. Aꞌ than pam piꞌan priests anangan aꞌ than pam piꞌan wiy anangan wik thayanan thaaꞌ-aath-aathinan-a, aꞌ than wuut manth-thayan anangana karpam wampin nungant, ");
INSERT INTO wim_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","aꞌ thawin nungant, “Nungkar ngul weeꞌ thaw pam wanch inangan thaaꞌ-aath-aathān thanang e? putha work piꞌan anangan yump-yumpān thananga? Nintang weeꞌang kuch e?” ");
INSERT INTO wim_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Puth nil Jesus.an thaw thant, “Ngay kan in engkāng niiyanta, aꞌ niiyan ngath waaꞌān. ");
INSERT INTO wim_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Nil weeꞌ thawant pam John alantan pam wanch kootra ngakangan kuungk-kuungkow thanang e? Nil God.an thawant ey? Nath pam wanch thawin nungant ey?” ");
INSERT INTO wim_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Thananiya kan-ngul thaw-thawin thanttakamana, “Ngamp ngul wanttak thawāmp e? Ngampwey yimanangan thawimp nunganta, ‘Nil God.an thaw nungant John.antan-a,’ nil puth Jesus.an thawow ngampara, ‘Ngul niiy John.an wanttak keꞌam ngaantam-ngeeyan nunang wik min God.antaman waaꞌ-waaꞌ niiyantan a?’ ");
INSERT INTO wim_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Puth ngampwey thawimp yimanangana, ‘Pam wanch thawin nungant John.antan,’ than pam wanch maꞌmangkamangan kunttowang ngul piik-piikin ngampanga, puth than kan-kanam paththam ngaantam-ngeeyantan nunang John.an nil prophet wik min God.antaman waaꞌ-waaꞌa.” ");
INSERT INTO wim_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Aꞌ thanan thawin nungant Jesus.antan, “Ngan meeꞌmiy yaꞌa nil weeꞌ-nathan thaw nungant John alantana.” ");
INSERT INTO wim_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Aꞌ nil Jesus.an thaw ngul thant, “Yaa, ngay puth-puthangkana keꞌ waaꞌing niiyant nil weeꞌangan kuch ngayang ngay yipam pam wanchan thaaꞌ-aath-aathāng thananga.” ");
INSERT INTO wim_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Anpalana, nil Jesus.angan wik kath waaꞌ thant, nil koochanam keꞌam waaꞌ thant nungamanganiy, nil wik kath anman waaꞌ thant. Aꞌ nil thaw ngul, “Ayyang, niiy wik kath inan ngeeyāna. Nil pam thonam alangana aak piꞌan weꞌar piꞌ-piꞌ nungantakaman, aak may kaampanakan, aꞌ nil may kaangkantam kaanch yot kaamp-kaamp thanang garden nungantamang angan. Anpalaniya, nil thaw pam wiyantan aak gardenan thath-thathayn, min-minakam piꞌ-piꞌayn nungantwey, aꞌ nil kan-ngul iiy aak thonaka nilan puth yaam wunowa. ");
INSERT INTO wim_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ngul-ngulana, aakan kan-ngul wamp thant may kaangk menchan anangan yal-yalmathayna. Nil moom alangan pam thonam nungantaman kuch nunang, aak garden nungantamakan iiyow, aꞌ may kaangk menchan anangan uwow nungant. Nil aak angan kanan wamp-a, than pam al-alangan gardenan piꞌ-piꞌinan-a, than piik-piikin nunang, aꞌ maꞌ-thaanch koyaman kuchin nunang. ");
INSERT INTO wim_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ngul-ngulana nil moom alangan pam nungantam thonangan ngul kuch nunang, puth than pam al-alanganiy-a, nunang thamp piik-piikina, aꞌ way paththam yump-yumpin nungant, aꞌ maꞌ-thaanch koyaman kuchin nunang. ");
INSERT INTO wim_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Aꞌ nil moom alangan pam thonangan ngul kuch nunang, puth than pam al-alanganiy-a, piik-piikin nunang, aꞌ yoon kenthin nunang. ");
INSERT INTO wim_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Aꞌ anpalana, nil mooman thaw nungantakaman, ‘Ngay wanttak ngula? Ngay nhengk ngatharam inman paththam mak kuchāng nunang. Than ngul ngaantam-ngeeyayn nil puk nhengk ngatharamana, nil puth pam piꞌan tham, keꞌ piikiythan nunang yaꞌa,’ aꞌ anpalana nil kuch nunanga. ");
INSERT INTO wim_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Puth than pam al-alangan thathin nunangana thinth ngulan wamp-wamp thantan-a, thanan thawin thanttakamana, ‘Ayyang, nil puk nhengk moomantaman inmana! Ngamp mulathāmp nunang, aꞌ ngampan aak garden inan ngamparakam ngul yipam piꞌāmpa!’ ");
INSERT INTO wim_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Aꞌ than pam al-alangan piw theeꞌin nunang yoon aak gardenam anpalan aꞌ mulathin nunanga.” Nil Jesus.an thaw thant, “Niiy ngul wanttak ngaantam-ngeeyaniy e? Nil moom-kunchan wanttak nath thawow thant pam al-alantana? ");
INSERT INTO wim_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Nil angan wampow thant, aꞌ mulathow thanang pam way anangana, aꞌ nil pam wiyant ngul thawow thant aak garden nungantaman piꞌ-piꞌayna.” Than pam wanchangan wik inangan ngeeyin nungantam Jesus.antaman-a, than thawin, “An yaꞌa!” ");
INSERT INTO wim_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Nil Jesus.angan thath thanang aꞌ engk thant ngul, “Wik inangan lat ngench thayan anpalana want-wanttak waaꞌina? ‘Than pamang aawuchan kaachantan-a, wiyiya than nath yuk pal pekkuwan aawuchantangan wunpantan-a, an piw theeꞌantan, puth thanan ngaantam-ngeeyantan keꞌ yuk way yimanangan. Puth yaꞌa, yuk pal pekkuwan aawuchantangana an min-minam paththama, aawuchan thayanam yipam thanowa.’ An puth keꞌ yimanangan pam wanch wiy al-alangan kaangk keꞌ ngayanga, than monkanam iiyantan ngatharamana. Puth ngayan keꞌ yuk pal pekkuwan aawuchantangan anman thanan piwan theeꞌina. ");
INSERT INTO wim_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Aꞌ puth ngayan keꞌ kunttow piꞌan yimananga. Than pam wanch weeꞌ-weeꞌanangan ngangkang keꞌan piꞌ-piꞌantan ngayang-a, aak way-wayam paththam wunow thant, than kunttowangwey thaꞌ thuthiythan, anpalaniy-a, keek-keekiythana. Puth than weeꞌ-weeꞌanang nathwey man-mangkam theeꞌiythan ngath-a, ngul-ngulaniya nil God.angan wayathow thananga, kan-kanam paththam wayathow thanang, keꞌ kunttow piꞌanang manchathow nhanth-nhanthakaman.” ");
INSERT INTO wim_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Than pam piꞌan anangan than wik thayanan thaaꞌ-aath-aathin-a, aꞌ than pam piꞌan priests anangan-a, thanan thawin thanttakaman thanan Jesus.an mamayn nunanga, puth than kan meeꞌmiya nil thanangan waaꞌ-waaꞌ, puth than keꞌam mamin nunanga, than winynyang moꞌin pam wanch yot al-alantamana. ");
INSERT INTO wim_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Yaa, thanana kuup-kuupin yippak, aꞌ ngaantam-ngeey-ngeeyin than want-wanttakan mamayn nunang. Aꞌ than pam wayanang anangan kuchin thanang nungant Jesus.antan, than yipam muukamayn keꞌ than pam min yimanangan, aꞌ than yaan paathayn nunang nil nath wik want-wanttakan thawowa, nath way waaꞌow thanang pam piꞌan anangan. Than kaangk maꞌam theeꞌayn nunang moom piꞌan alantan, nil yipam wayathow nunanga. ");
INSERT INTO wim_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Than pam wayanang anangan iiyin ngul nungant Jesus.antan, aꞌ thawin nungant, “Ayyang, moom-ang, ngan kan meeꞌmiy nint wik kan-kanam anangan thaw-thawangana, puth woyan min God.antaman kan-kanam thaaꞌ-aath-aathangan nganang. Puth nint pam piꞌan al-alantaman keꞌam winynyang moꞌ-moꞌangan yaꞌa, nint keꞌ-ngoongkam wik kan-kanam anman waaꞌ-waaꞌangan pam wanchantana. ");
INSERT INTO wim_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Yaa, nint puth wik kan-kanam waaꞌān nganta. An-ngul kan-kanam ey? ngan ngul wukal theeꞌin ey? keꞌ income tax yimanangan ey? pam moom piꞌan alantan ey? aak Rome.angan wunan ey? Nath yaꞌa, keꞌ theeꞌin nunganta.” ");
INSERT INTO wim_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Aꞌ nil puth Jesus.angan kanam thiich thanang pam wayanang anangan than pam min yaꞌa, than yaan paath-paathin nunanga, aꞌ nil puth thaw ngul thanta, ");
INSERT INTO wim_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Niiy wukal thonam pal kalānara, ngay kan thathānga! Wukal ilangan kaaꞌwal weeꞌantam piꞌ-piꞌan e? puth namp weeꞌantam wukal ilantangan wun a?” Puth than pam anangan thawin nungant Jesus.antan, “Pam moom piꞌan alantaman aak Rome.angan wunana.” ");
INSERT INTO wim_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Aꞌ nil Jesus.an thaw ngul thant, “Than wukal tax aakanakan thawayn niiyantan-a, pam piꞌ-piꞌanam anangan-a, niiy wukal wiyana theeꞌān thantweya. Puth nil God.angan ngampangan yumpa, ngampaniya ngangk ngamparamana koyam theeꞌāmp nungant God.antan.” ");
INSERT INTO wim_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Than wik inangan ngeeyinan-a, thanan thaaꞌam ikin ngul. Than puth kanam mep-mepin nunang, puth yaꞌangama nil puth wik way thakan keꞌam koyaman thaw thantana. Anpalaniy-a, than popam ngul thanin, wik keꞌanangan. ");
INSERT INTO wim_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Anpalan-a, pam puungk wiy Sadducees anangan wampin nungant, than Sadducees il-ilangana, than ngaantam-ngeeyin pam wanch mulan wuntan-a, keꞌ koyam mulaman keꞌ-ngul ekiythana. Than thawin nungant Jesus.antan, ");
INSERT INTO wim_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Ayyang, Moom-ang, pam Moses.ang keenkanamana wik yimanangan umpa, ‘Nil pamwey puk keꞌanangan uthamiwwey-a, yaa, nil pont nungantam alangan wanch wukalongkan maayow nunang, pul yipam puk uwowpula, thanan yipam ngaantam-ngeeyayna puk anangana keꞌ pam mul alantamana.’ ");
INSERT INTO wim_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Puth nint kan wik kath inan ngeeyāna: aak keenkanamana, than maꞌ-kuuncham pam seven wun-wunina. Wuny thanttamangan kaꞌatham wanchan maayan — ngul-ngulaniya, nil puk keꞌanang utham ngula. ");
INSERT INTO wim_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Pam kuunch nungantam thon alangan ngul maay nunang wanch wukalongkana, aꞌ nil tham ngul puk keꞌanang utham. ");
INSERT INTO wim_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Aꞌ pam kuunch nungantam thon alangan ngul maay nunang wanch wukalongkana, aꞌ nil tham puk keꞌanang uthama. Pam kuunch nungantam maꞌmangkam al-alangan maay-maayin nunang, wanch wukalongkan, aꞌ than maꞌmangkamana puk keꞌanang anman uth-uthamina. ");
INSERT INTO wim_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ngul-ngulaniya, wanch wukalongkan utham. ");
INSERT INTO wim_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Kan in ngeeyāna! Aak ngulan wampowan-a, than pam wanch mulaman koyaman ngulan ek-ekayn-a, man-yetham koyaman iiy-iiyayn-a, nil wanch wukalongkana wanch thum pam weeꞌantam ngul iiyowa? Puth nil wanch alangana pam maꞌ-kuuncham seven anangaman maay thanang a!” ");
INSERT INTO wim_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Aꞌ nil Jesus.an thaw ngul thant, “Pam wanch than man-yethaman iiy-iiyantan-a, than ngent-ngentwuntana, ");
INSERT INTO wim_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","puth than pam wanch anangan nil God.angan mulam ngulan ekathow thanang-a, than yipam aak umpuyam wun-wunayn-a, an than keꞌ-ngul ngent-ngentwayn, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Thananiy-a, keꞌ ngaantiyongk anman iiy-iiyayn, keꞌ-ngul uthamiythan, yaꞌa. Thananiya puk nhengk God.antam ngul iiy-iiyayna, puth than mulaman ngulan ekayna. ");
INSERT INTO wim_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Nil Moses.angan wik engkanang waaꞌ ngampar nil God.angan mulaman ngul ekathow thanang pam wanch mulan wuntan. Ngamp meeꞌmiy wik nungantaman kan-kanamana. Nil wik kath inan ump, lat ngench thayanangan nilan thum nganthan thath yuk many kangkathiyangan, puth yukana keꞌam pench-pencha. Nil puth God.an wik inangan Moses.antan thaw, ‘Ngayiya God inman, thanttam Abraham-a, puth Isaac-a, aꞌ puth Jacob weeꞌanang al-alantamana.’ ");
INSERT INTO wim_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Nil God.ana God thanttam pam wanch man-yethaman iiy-iiyantana, pam wanch mul al-alantaman yaꞌa. Pam wanch God.antaman uthamantanan aak ingan earthangan-a, an keꞌ than mul kan-kanam wuntan ey? An yaꞌa, an than man-yetham yippak iiy-iiyantan aak in kenyana piip God.antangan.” ");
INSERT INTO wim_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Than pam piꞌan wiy anangan than wik thayanan thaaꞌ-aath-aathinan-a, than thawin nungant Jesus.antan, “Ayyang, Moom-ang, nint wik min waaꞌana.” ");
INSERT INTO wim_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Than puth winynyang ngul moꞌ-moꞌin nungantam Jesus.antamana, thananiya keꞌ-ngul wikak thakan engkin nungant, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Anpalaniya, nil Jesus.an engk thant, “Puth than thawantana nil David.ana wuut mangk nungantamaniya, pam alantaman nil God.angan kaaꞌngak kuchowan ngampara. Than ngeenam yimanangan thawantana? ");
INSERT INTO wim_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Nil puth David.angana wik inangan ump lat Psalms.angana, ‘Nil Lord God.ana moom ngatharamant thawa, “Nintaniya moom piꞌan ngatharang iiy-iiyāna; ");
INSERT INTO wim_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","aꞌ ngay ngul maalathāng thanang than nintangan ngangk-wayangaman kal-kalayn. Nintaniya moom piꞌan karangk paththam iiy-iiyān thantana.” ’ ");
INSERT INTO wim_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Wik iniya David.angan waaꞌ. Niliya Christ.ana moom nungantam waaꞌ nunanga. Puth nil David.ana wanttak Christ.antaman wuut mangk ween a?” Nil Jesus.angan yimanangan mep thananga. ");
INSERT INTO wim_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Than pam wanch yotangan ngeey-ngeeyin nunang Jesus.an, aꞌ nil thaw thant ngurp nungantam al-alantan, ");
INSERT INTO wim_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Niiy kan thathān thanang, pam piꞌan anangan than wik thayanan thaaꞌ-aath-aathantan thananga, than min yaꞌa! Thanan keꞌ meek yimanangan kaangk iiy-iiyayna. Than kaangk ngook ongk anangan ngoonch-ngoonchayna, than wiyangan yipam thath-thathayn thananga, aꞌ thanan kaangka pam wanch wiy anangan umang iiy-iiyayn thant aak town wakanangana. Aꞌ putha, than aak churchakan iiy-iiyantan-a, thanan kaangk umputh anman nyiin-nyiinayna, than yipam pam wanch wiyangan thath-thathayn thanang, aꞌ putha than may partyakan iiy-iiyantan-a, thanan kaangk aak min-minangam nyiin-nyiinayna. ");
INSERT INTO wim_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Than yuk way min wukalongk al-alantaman maay-maayantan aꞌ kenth-kenthantan thanang aawuch thanttam anpalan, yipam than ngul wunayn. Aꞌ putha thanana yaam anman meeꞌ-wuth-wuthanamantan pam wanchangan yipam ngeey-ngeeyayn thananga. Nil God.angan kan-kanam paththam ngul wayathow thananga.” ");
INSERT INTO wim_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Anpalana, nil Jesus.angan aak pal-puy thath-thath aak ngench thayan angan, aꞌ nil thath-thath thanang pam wanch maꞌmangkiy anangan wukal God.antan wunp-wunpin, yuk ikang angana. ");
INSERT INTO wim_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Aꞌ anpalana, nil wanch wukalongkan thath nunang wamp-wamp, wanch inaniya, nil wukal keꞌanangwey, aꞌ nilan wukal manyiy kucham keꞌ two cents yimanangan ikangan wunp. ");
INSERT INTO wim_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Aꞌ nil Jesus.an kan-ngul thaw thant, “Niiy kan thathan thanang ey? Than wiyangan ep-paththam wukal piꞌ-piꞌanam ikangan wunp-wunpin a! Nungkway nil wanch wukalongk ilangan wukal many wunp ikangan-a, an min meeꞌ God.antangana, an nil God.angan keꞌ wukal piꞌan thath-thathan meeꞌ nungantangana. ");
INSERT INTO wim_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Than puth wiy ananganiya min yaꞌa, puth nungkway than wukal piꞌanan wunp-wunpin-a, an min yaꞌ meeꞌ God.antangan, puth thanan keꞌ wukal many theeꞌ-theeꞌin, thanan puth wukal thaꞌiy thanttakaman piꞌ-piꞌantan, maꞌmangkiy iiy-iiyantana. Puth nil wanch wukalongk alanganiy-a, wukal nungantam anangan maꞌmangkam wunp ikangan, wukal anan nil keꞌ may piiyanakan piꞌ-piꞌwey-a, anan wunp.” ");
INSERT INTO wim_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Anpalana, than ngurp Jesus.antam anangan thaw-thawin thanttakaman, “An thathāna! Aawuch ngench thayanana min-minam paththama! Puth kunttow piꞌan anangana min-minam paththam thampa! Aꞌ pam wanchangan yuk way min min-miniy wamp-wampathantan nungant piip God.antan a!” ");
INSERT INTO wim_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Nil Jesus.an thaw thant, “Eeꞌa, niiy aawuch piꞌ-piꞌanam inangan thath-thathaniy ey? Puth ngay inan thawang niiyanta, aak ngul-ngulana than pamangan aawuch min-minam anangana ngul wayathayn — aꞌ puth kunttow wuut piꞌ-piꞌanam anangana aakang ngul keek-keekathayn.” ");
INSERT INTO wim_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Aꞌ than ngurp nungantam anangan engkin nungant, “Ayyang, moom-ang, nint wik nyiingkan thawan aak ngeen wampowa? Nil puth God.angan ngeen meenathow ngant aakan kan-kanangan wampana? aawuch ngench thayanan keekathayn a?” ");
INSERT INTO wim_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Nil puth Jesus.an thaw thant, “Niiy meeꞌ yanth-yanth ngul iiy-iiyāna! Than pam wanch wiyangan keꞌ muuk-muukamathayn niiyanga! Than yot anangan thon-thonam ngul wamp-wampayna, thananiya yaan wik uuy-uuyamayn, thaw-thawayn, ‘Ngay in Jesus Christa, God.angan kuchanya,’ puth yaꞌa. Aꞌ wik yimanangan thamp thaw-thawayn, ‘Aak inan kan-ngulan minchowa,’ puth yaꞌa. Niiyan keꞌ monkan-wak-wakān thananga! ");
INSERT INTO wim_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","“Niiy wik thooꞌ ngul ngeey-ngeeyān kul karkanan pek-pekwayna, puth niiyana winynyang keꞌ moꞌāna. Than mak kaꞌathamana kul karkan pek-pekwayna, puth aakan keꞌ yippak minchowa.” ");
INSERT INTO wim_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Anpalana, nil wik inangan thaw thant, “Than moom piꞌan aꞌ pam thanttam aak thon-thonaman anman pek-pekwayna, than pam wiy anangan thaaꞌnganth thon al-alantan ngul iiy-iiyayn aꞌ than pek-pekwayn. ");
INSERT INTO wim_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Aꞌ earthquake al-alangan aak nath-nathan wuny-wunyathowa. Aꞌ putha aak umyompanamana may keꞌanang thak wun-wunayn, aꞌ aak way paththam wamp-wampow thant yotamantana, weech-weechow thanang thaka aak umyompanamana. Aꞌ ngeen yaakaꞌ natha yuk wuut piꞌ-piꞌanam nil-nila uk-ukayn nathpal kenyana, aꞌ winy-winyathow pam wanch ananganiya. ");
INSERT INTO wim_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Puth yaꞌ yippaka. Than kaꞌathaman mam-mamayn niiyang aꞌ way paththam yump-yumpayn niiyant, piik-piikayn niiyang thaka. Than maꞌam theeꞌ-theeꞌayn niiyang pam piꞌan al-alantan than yipam umang than-thanathayn niiyang churches Jews.antamang angana aꞌ yipam jailangan thench-thenchayn niiyanga. Than wamp-wampathayn niiyang pam piꞌan al-alantan puth niiy ngayangan monkan-wak-wakaniya, anpalana. ");
INSERT INTO wim_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Puth niiyan wik min God.antaman waaꞌ-waaꞌān thanta. ");
INSERT INTO wim_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Than mam-mamayn niiyang-a, aꞌ umang than-thanathayn niiyang courtangan-a, niiyaniya kuchek keꞌ way-wayamāna niiy wanttakan thawāna. Yaꞌa, puth niiyan keꞌ ngaantam-ngeey-ngeeyān yimanangana, ");
INSERT INTO wim_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","puth ngayana kuchek waap min yump-yumpāng niiyang, aꞌ puth wik minan waaꞌ-waaꞌāng niiyanta niiy yipam wik anangan thant ngul waaꞌ-waaꞌāna. Aꞌ than pam wayanang anangan puthangkan wik keꞌ thaw-thawiythan niiyant, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Aak an-aniyangan-a, kampan niiyantam al-alangan aꞌ ngurp niiyantam al-alangan maꞌam theeꞌ-theeꞌayn niiyang pam piꞌan al-alantan, nath kaath piip niiyantam al-alangan, nath kuunch niiyantam al-alangan. Aꞌ wiy inangana, mul-mulathayn niiyanga. ");
INSERT INTO wim_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Than pam wanch yotangan ngangk-wayangam kal-kalayn niiyang, puth anpalan niiy ngayangan monkan-wak-wakaniya. ");
INSERT INTO wim_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Puth nil piip God.anganiy-a, min-minam piꞌ-piꞌow niiyanga. ");
INSERT INTO wim_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Niiy ngangk thayanam anman monkan-wak-wakān nunang, aꞌ amanamaniy-a, niiy man-yetham aak umpuyam wun-wunān piip God.antangana.” ");
INSERT INTO wim_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Nil Jesus.an putham thaw thant, “Niiy pam soldiers yot anangan ngul thath-thathān thanang thintham wampayn aak Jerusalem.akan. Than kuchwayn kaaw kuuw kungk yiip aꞌ menh-menhang wakan aꞌ umang paththam kal-kalayn thanang pam wanch anangan aak Jerusalem.angana. Aak an-aniyangan-a, niiy meeꞌmiy ngul weenān aakan yaam keꞌanam paththam keekow. ");
INSERT INTO wim_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Aak inan wampowan-a, than aak Judea punchan anangan-a, moꞌ-moꞌayn aak yoykaka. Than weeꞌ-weeꞌanangan aak piꞌanangan wuntan-a, aakan want-wantayn, aꞌ than weeꞌ-weeꞌanangan aak kangkangan wun-wuntan-a, than aak pi ꞌanakan ket iiyayna. ");
INSERT INTO wim_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Puth aak an-aniyangan-a, nil piip God.angan pam wanch yot anangan way-wayathow thanang aak Jerusalem.angana, nil yipam meenathow ngampar than keenkanamana lat ngench thayanangan umpin-a, an kan-kanam paththam waaꞌin. ");
INSERT INTO wim_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Aak inan ngulan wampow-a, an aak way-wayam wunow thant wanch iimpanang al-alantana aꞌ putha wanch pul-many al-alantan maꞌ puk manyangana. Puth aak way-wayam paththam ngul wampow aak iikanakana, nil puth piip God.angan kan-kanam paththam wayathow thanang pam wanch anangana. ");
INSERT INTO wim_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Pam wanch wiy anangana, than nhengk-peempanang ngul mul-mulathayn thananga; pam wanch wiy anangana, than aak jailang wunp-wunpayn thanang aak thon-thonang angana, pam wanch al-alantangan thaaꞌnganth thonan wuntana; aꞌ pam wanch Jews yaꞌ al-alangan aak Jerusalem way-wayathayn aꞌ thanam ngul aak wakayn aak-aakanakaman nil God.angan kenth-kenthow thanang ngulana. ");
INSERT INTO wim_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Aak an-aniyangan-a, kirch aꞌ kep aꞌ puth thunp anangan wiy-wiyam ngul weenayna. Pam wanch yot aak nath-nathangan wun-wuntan ngangk way paththam wunwunayna, than puth winynyang moꞌ-moꞌayn puth yeelal piꞌanan muutathiy ek-ekow aꞌ ngakan mat-matowa thompan piil-piikow. ");
INSERT INTO wim_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Than pam wanch anangan kuup-kuupayn aak way ngulan wampow aak umyompanaman-a, than winynyang paththam moꞌ-moꞌayn aꞌ wiy anangan-a, thaꞌ thayan keek-keekayn, puth kinch-a, kep-a, aꞌ putha thunp anangan pal-puy wun-wunayn ngula. ");
INSERT INTO wim_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Aꞌ than pam wanchangana ngul thathayn ngayang puth palaman uk-ukāng yuwangana, ngay pam inman nil God.angan kuchanya. Ngay pam piꞌan aꞌ karangk ukānga, aꞌ pam min-minam paththam ukānga! ");
INSERT INTO wim_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Aak inan wampowan-a, niiy thanāna aꞌ kaaꞌ um keny thath-thathāna, puth aakan thinth yaam keꞌanaman wampow nil piip God-angana ngul kaaꞌ-piich-piichanathow niiyanga.” ");
INSERT INTO wim_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Aꞌ nil Jesus-angan wik kath ngul waaꞌ-waaꞌ thant, nilan thaw, “Niiy ngaantam-ngeeyān yuk kom anana aꞌ yuk wiy anangana. ");
INSERT INTO wim_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Yiikanan pentantan kangk nyiingkanaman-a, yaa, niiy meeꞌmiy ngul weenaniya aak kayamanana kan-kanang wamp-wampan. ");
INSERT INTO wim_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Aꞌ niiy kinch ngulan thath-thathān ngaaꞌ ngulan wunow-a, putha thunp anangan keek-keekayn thakan-a, yaa, niiyana meeꞌmiy weenān aakan thinth ngul wamp-wampan nil piip God.angana pam wanch yot anangan maꞌ nungantanga ngulan piꞌ-piꞌow thananga. ");
INSERT INTO wim_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Aꞌ niiy inan thamp ngaantam-ngeeyāna; aak anan wampowan-a, puungk wiy inangan niiya man-yetham yippak iiy-iiyān. ");
INSERT INTO wim_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ngul-ngulana aak earth inana putha yuw in kenyan thathanamp an ngul minchowa. Puth wik ngatharamana an keꞌ minchiya, yaꞌa, an anman wun-wunow aak umpuyangama.” ");
INSERT INTO wim_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","Nil Jesus.an putham ngul thaw thant, “Niiy meeꞌ yanth-yanth iiy-iiyāna! Niiy paththam min-min ngaantam-ngeey-ngeeyāna, aꞌ keꞌ kon-ngathow niiyang aak inan ngul minchowa. Niiy may-weenthan keꞌ iiy-iiyāna, aꞌ ngak way-weenthan keꞌ iiy-iiyāna, aꞌ kuchek keꞌ wayamow niiyant yuk way min anpalana, puth nil God.angan ngul maꞌ-pil-wayath niiyang, aak way ngulan wampowa. Puth aak way inana pam wanch maꞌmangkam al-alantan wampow aak umyompanaman wun-wuntana. ");
INSERT INTO wim_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Niiy meeꞌ yanth-yanth iiy-iiyāna aꞌ meeꞌ-wuth-wuthanamān anman piip God.antan nil yipam ngangk thay-thayanathow niiyang niiy yipam aak wayan thaamp-thaampān aꞌ anpalana niiy um ngatharang ngul than-thanāna ngay pam inman nil God.angan kuchanya.” ");
INSERT INTO wim_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ngaaꞌ thon-thonangana, nil Jesus.angan pam wanch thaaꞌ-aath-aath thanang aawuch ngench thayanang angan, aꞌ aak ngutang ngulana, nil Yoon pent-pent yoyk Olives aakanakan, aꞌ angman paanth-paanth. ");
INSERT INTO wim_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ngaaꞌ thon-thonangana, than pam wanch yot anangan ngaaꞌthiyangam iiy-iiyin aawuch ngench thayanakan than yipam wik nungantaman ngeey-ngeeyayn. ");
INSERT INTO wim_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Aak thinth kan-kanangan wamp-wamp may piꞌan yumpanakan. Aak anan-a, may piꞌanan mungkayn Passover.an waaꞌantan, thanan may bread pamp anman mungk-mungkantan soda keꞌananga. ");
INSERT INTO wim_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Than pam piꞌan priests anangan aꞌ puth-a, pam wiy anangan wik thayanan thaaꞌ-aath-aathinan-a, than winynyang moꞌin thanttam pam wanch yot al-alantaman, yaa, than nanpalana wik thaw-thawin thanttakaman than want-wanttakan Jesus.an meeꞌ thenchanam mamayn nunang, aꞌ puth mulathayn nunangan. ");
INSERT INTO wim_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Aꞌ anpalana, oony way piꞌan anana ngangkang ngoonch nungantang, Judas Iscariot.antangan, ngurp nungantam Jesus.antam thon alantangan. ");
INSERT INTO wim_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Nil iiy thant pam piꞌan priests al-alantan, aꞌ moom thapangumpan al-alantaman than aak ngench thayanan piꞌ-piꞌinan, nil yipam wik thawow thanttang nil want-wanttakan Jesus.an theetathow nunang thanta. ");
INSERT INTO wim_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Than pam piꞌ-piꞌan anangan ngangk min paththam ngul wunin aꞌ thanan puth thawin nungant Judas.antan than wukal ngul theeꞌayn nunganta. ");
INSERT INTO wim_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Nil Judas.an puth eeꞌ thaw thant, aꞌ amanam ngulana nil ngaantam-ngeey-ngeey nil Jesus.an want-wanttakan theetathowan thantana. Nil kaangk meeꞌ thenchanam theetathow nunang thanta, than pam wanch yot al-alangan keꞌ yipam thiichayna. ");
INSERT INTO wim_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Aak ananiya kan wamp thant Jews al-alantan minh lambs anangan yipam mul-mulathayn thanang, may piꞌan Passover.akan. Anpalana, than yipam minh lamb anangan aꞌ may bread pamp soda keꞌanangan mungk-mungkayn ngula. ");
INSERT INTO wim_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Aꞌ nil Jesus.an thaw pulant Peter-a, puth John.angan, “Nip iiyowa may-a, minh-a, keenk piꞌow ngampara.” ");
INSERT INTO wim_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Pulan puth thawpul nunganta, “Ngan aak wantting mayan yumpān ngampara?” ");
INSERT INTO wim_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Nil Jesus.an thaw pulant, “Ayyang, nip in ngeeyowa. Nip aak Jerusalem.angan ngoonchowa aꞌ anpalana nipiya pam uwow nunang ngak kal-kalan juganga. Nipaniya monkan-wakow nunanga. Nil aawuch wanttingan ngoonchow-a, nipaniya karpam ngoonchow nungantangana. ");
INSERT INTO wim_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Aꞌ nipana thawow nungant aawuch-kunch alantan, ‘Ayyang, moom nganttamang wik inan kuch nganttang nint aakan meenathān ngant aak wanttingan ngan yipam Jesus weeꞌanangan minh lamban aꞌ may bread pampan mungkān.’ ");
INSERT INTO wim_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Amanamaniya nil pam alangan keny ngul matathow nipang aꞌ nilan ngul meenathow nipar, aakan piꞌan aꞌ weꞌara, table thampanga putha chairs thama. Nipaniya minh-a, may thakan keenk wunpow thanang table.angana ngampan yipam may mungkāmpa.” ");
INSERT INTO wim_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Aꞌ pam kuchamana iiypul ngul aꞌ aakana kan-ngul uwpul keꞌ Jesus anman wik thaw pulant. Yaa, pulana may minh keenk ngul piꞌ-piꞌpul thanta. ");
INSERT INTO wim_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Anpalana nil Jesus-a, puth ngurp nungantam wiy anangan kan-ngul wampin pulant. Aꞌ thananiya nyiinin ngul may mungkanakan. ");
INSERT INTO wim_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Aꞌ nil Jesus.an kan-ngul thaw thanta, “Ngay kaangk paththam may breada putha minh inangan mungkānga, may piꞌanana Passover.ana. Ngamp may inan minchathāmpan-a, than pam wayanang al-alangan way thakan yumpayn ngathara. ");
INSERT INTO wim_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ngay inan kan-kanam thaw-thawanga. Ngay may piꞌan Passover.ana puthaman aak ingan keꞌ-ngul mungkāng, yaꞌa. Ngamp aak ing keny ngulan wunāmp nungantang piip God.antangan-a, an ep ngay mungkāng aꞌ aak an-aniyangana niiyana ngul thiichāna may Passover.ana want-wanttakan wunow.” ");
INSERT INTO wim_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Amanamaniya nilana cup maay, may wine thampan aꞌ thankyou thaw nungant God.antan. Anpalana nil kan-ngul thaw thant ngurp nungantam al-alantan, “Niiy inan mamāna, aꞌ ngamp yotamangan mungkāmp ngul cup thonam ilangaman. ");
INSERT INTO wim_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ngay inan waaꞌāng niiyanta: ngay wine inana keꞌ-ngul mungkāng, yaꞌa. Ngul-ngulaniya, nil piip God.angan pam wanch yot anangan maꞌ nungantangan piꞌ-piꞌow thanang-a, ngay aak an-aniyangan ep ngul mungkānga.” ");
INSERT INTO wim_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Aꞌ amanamaniya nil Jesus.angana may breadana maay aꞌ thankyou thaw piip God.antan. Aꞌ anpalaniya nil may breadana kan-ngul many-many pip-pip aꞌ ngurp nungantam al-alantan theeꞌ-theeꞌ ngul thant aꞌ thaw ngul thant, “May bread inana keꞌ kemp ngatharam yimanangan ngay ngulan theetathāng niiyanta. Niiy may inan mungkāna, aꞌ niiy ngayang thampan ngaantam-ngeey-ngeeyāna.” ");
INSERT INTO wim_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Aꞌ may kanan minchathin-a, nilana cup ngulan maay aꞌ nil kan-ngul thaw thant, “Ayyang, wine inana keꞌ chaapar ngatharam yimanangan ngay ngulana theetathāng niiyant yotamanta niiy yipam ngangk minangam karpam ngul iiy-iiyān nungantang God.antangana. ");
INSERT INTO wim_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Puth niiy in ngeeyāna! Nil pam thonamanga ngayangan ngul theetathow pam way al-alantan; pam anman-a, nil inman nyiin-nyiinan niiyantangana, may mungk-mungkan ngatharanga. ");
INSERT INTO wim_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ngayaniy-a, pam inman nil God.angan kuchanya. Ngay ngul uthamānga, nil God.an kaꞌathaman thaw. Puth nil pam weeꞌang theetathow ngayanga pam way al-alantan-a, an aak way-wayam paththam wampow nunganta!” ");
INSERT INTO wim_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Anpalana, than kan-ngul thaw-thawin thanttakaman, “Ngamp inangan nyiinanamp-a, nil thonam weeꞌang theetathow nunanga?” ");
INSERT INTO wim_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Anpalana, than ngurp Jesus.antam anangan wik thaw-thawin thanttakamana nil weeꞌ ngula thanttang pam meek piꞌanan iiyowa. ");
INSERT INTO wim_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Aꞌ nil Jesus.an kan-ngul thaw thant, “Than moom aak thon-thonangan wuntana, moom thanttam Jews yaꞌ al-alantaman, than puth God.an meeꞌmiy nunang yaꞌa. Than pam wanch anangan maꞌ thay-thayanang anman piꞌ-piꞌantan thananga, aꞌ thanan kaangk pam wanchangan min waaꞌayn thanang. ");
INSERT INTO wim_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Puth niiyaniya, yimanangan keꞌ iiy-iiyān niiy-niiyantakamana. Niiywey nath kaangk pam piꞌ-piꞌanam iiy-iiyānwey-a, yaa, niiyan ulp-ulpanang keꞌ iiy-iiyān, niiy pam wanch wiy anangan maꞌ-aath-aathān thanang aꞌ min-minam piꞌ-piꞌān thananga. ");
INSERT INTO wim_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Yaa, niiy waaꞌān ngathara. Nil weeꞌa pam piꞌanan iiyowa? Nil pam anman keꞌ meekan nyiin-nyiin ey? yipam may mungk-mungkow ey? Yaꞌ natha, pam nil mayan kal-kalan wiyantan ey? Yaꞌa, nil paman nyiin-nyiinan-a, an nil ep pam piꞌan iiy-iiyana. Puth ngayaniy-a, wampang niiyant ngayan yipam maꞌ-aath-aathāng niiyang, minam piꞌ-piꞌāng niiyang. ");
INSERT INTO wim_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Niiyaniya ngatharang anman iiy-iiyan; nungkway wiyangan way paththam yump-yumpin ngathar-a, niiyaniya keꞌam wantan ngayanga. ");
INSERT INTO wim_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Piip ngatharamangana moom piꞌan yumpanya, an yimanangana ngay moom piꞌan yump-yumpāng niiyang thampa. ");
INSERT INTO wim_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Aak an-aniyangana ngay pam wanch yotam maꞌ ngatharang ngul piꞌ-piꞌāng thanang-a, niiyana ngatharang anman nyiin-nyiināna aꞌ may mungk-mungkān ngatharang, aꞌ niiy moom piꞌan ngul iiy-iiyān thant Jews al-alantan wuut mangk twelve al-alantaman wamp-wampin.” ");
INSERT INTO wim_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Anpalana, nil Jesus.an Simon Peter alantan thaw, “Ayyang, Simon-ang, Simon-ang, nint ngeeyāna! Nil oony way anan kan engk nungant piip God.antan nil yipam thaach-thaachow niiyang way yumpanakana, aꞌ nil God.an eeꞌ thawant, nil mak thaach-thaachow niiyanga. Nil oony way alangan puth kaangk yaark-yaarkathow niiyang ngatharam anpalana, keꞌ wuntangana yaarkathana kaanch anangan wookam anpalana. ");
INSERT INTO wim_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Puth ngay kan meeꞌ-wuthanamang nungkara, Simona, nint yipam ngangk thayanam anman ngangkang piꞌ-piꞌān ngayanga. Puth ngul-ngulana, nint ngayang kan-ngul wantāna. Puth nint palam ngul weentān ngathara, aꞌ aak an-aniyangana nint ngangk thay-thayanathān thanang ngurp nungkaram anangana, puth pam wanch ngatharam anangana.” ");
INSERT INTO wim_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Nil Peter.an thaw nungant Jesus.antan, “Moom-ang, nungkway than nath jailangan thench-thenchayn ngayang-a, nath mulathayn ngayang nungkarangan-a, ngay keꞌ wanting nintanga, ngay nintang anman monkan-wak-wakānga!” ");
INSERT INTO wim_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Nil Jesus.an thaw nungant, “Ayyang, Peter-ang, ngay inan kan-kanam paththam thaw-thawang nungkar, inman ngutangan-a, nil minh rooster keꞌan yippakan pechow-a, nint maꞌ-koꞌalaman-a, wik uuy-uuyamān thant keꞌ nint ngayang keꞌ meeꞌmiya.” ");
INSERT INTO wim_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Anpalana, nil Jesus.an kan-ngul thaw thant ngurp nungantam al-alantan, “Aak keenkan-a, ngay kuchang niiyang wik minan waaꞌ-waaꞌān. Niiy purse niiyantaman keꞌam kalan, aꞌ bag aꞌ thaꞌ murruk keꞌam kalana. Niiy meech iiy-iiyan ey? Nath pam wanchangan min-minakam piꞌ-piꞌin niiyang ey? may minh thakan aath-aathin niiyangwey ey?” Than puth thawin nungant, “Ngan meech keꞌam iiy-iiyan, yaꞌa. Than minam anman piꞌ-piꞌin ngananga.” ");
INSERT INTO wim_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Aꞌ nil Jesus.an thaw ngul thant, “Puth niiy in ngeeyāna: aak in yimanangana, niiy weeꞌ-weeꞌanangan purse aꞌ bag thampan-a, niiy kalāna; aꞌ puth niiy weeꞌ-weeꞌanangan nhengk-peempan keꞌanangan-a, coat niiyantaman sellimpungān, wukal yipam uwān, nhengk-peempan yipam piiyān. ");
INSERT INTO wim_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Puth ngay wik inangan waaꞌ-waaꞌāng niiyanta than lat ngench thayanangan keenkanaman umpin ngayangan waaꞌ-waaꞌina, ‘Than way paththam ngul yump-yumpayn nungant keꞌ nil pam way paththam yimanangana.’ Puth niiyan ngul thiichān than wik anangan kan-kanam waaꞌ-waaꞌin ngayangana, puth than kan-kanam way paththam ngul yump-yumpayn ngathar.” ");
INSERT INTO wim_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Than ngurp nungantam anangan thawin ngul nungant, “Ayyang, Moom-ang, nhengk-peempan kucham ina!” Nil thaw thant, “An kana! Ngay wik kath thonakam yaan waaꞌ-waaꞌang niiyanta.” ");
INSERT INTO wim_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Anpalana, nil Jesus.an aawuch piꞌanan kan want, aꞌ iiy ngul yoyk Olives aakanakan, puth aak nungantaman yimanangan wun; aꞌ ngurp nungantam anangana karpam iiy-iiyin nungantangan. ");
INSERT INTO wim_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Than wampin-a, nil thaw ngul thant, “Niiy meeꞌ-wuthanamān God.anta, niiy keꞌ yipam wik ngeeyān nunang oony wayana, way keꞌ yipam yumpān ngula.” ");
INSERT INTO wim_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Aꞌ anpalana, nil chil kech iiya, aꞌ pungkang ngul nyiin aakangan aꞌ meeꞌ-wuthanam piip God.ant, ");
INSERT INTO wim_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Piip-ang, nint keꞌ paththam wayathin thanang ey? Nint keꞌ thawin thant ey? Wayan keꞌ yumpayn ngatharan ey? Puth ngayan keꞌ thawing, yaꞌa, nint kaangk yaakaꞌ kuchān ngayangwey-a, yaa, puth wayan mak yump-yumpayn ngathara, ngayan puth keꞌ weeking ngatharakamana.” ");
INSERT INTO wim_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Anpalana, ngaantiyongk wamp nungant inpal keny uk aꞌ ngangk thayanath nunanga. ");
INSERT INTO wim_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Nil puth-putham meeꞌ-wuth-wuthanam, ngangk-wayangam ngangk thuth-thuthanakama, nil kan-kanam paththam meeꞌ-wuth-wuthanam, aꞌ kiimp uk-ukant keꞌ chaapar yimanangan aakangan uk-ukana. ");
INSERT INTO wim_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Aꞌ nilana kan-ngul ek, aꞌ koyam ngul iiy thant ngurp nungantam al-alantan, aꞌ thath thanang weep thayanan wun-wunina, than puth ngangk way paththam wun-wunin, puth anpalan kemp way ngul weep wunina. ");
INSERT INTO wim_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Nil Jesus.an thaw ngul thant, “Niiy ngeenak weep wun-wunaniya? Niiy kan ekāna aꞌ meeꞌ-wuthanamān nungant God.antana niiy keꞌ yipam wik ngeeyān nunang oony way anana, way keꞌ yipam yumpān ngula.” ");
INSERT INTO wim_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Nil Jesus.an wikan yippak thaw-thaw-a, than pam yot anangan kan-ngul wampin nungant. Nil ngurp nungantam Judas alangan-a, karpam kal-kal thananga. Nil Judas.an thintham iiy nungant Jesus.antan, yipam wal piintow nunanga. ");
INSERT INTO wim_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Puth nil Jesus.an thaw nungant, “Ayyang, Judas-ang, nint wal piintangan ngayanga yipam nint theetathān ngayang ey? ngay puth pam inman nil God.angan kuchanya.” ");
INSERT INTO wim_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Than ngurp Jesus.antam al-alangan thathin than ngeenan yumpayn nungant thanan puth thawin nungant, “Moom-ang, ngan piikān thanang ey? nhengk-peempan nganttam il-ilangan ey?” ");
INSERT INTO wim_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ngurp nungantam thonam alangana nhengk-peempan nungantaman erkam paththam wich, aꞌ pam thonaman kon thalokang umpan. Pam ananiy-a, kon munth ngul iiy-iiy, nilwey pam work iiy-iiy pam piꞌan alantana moom priestsantamana. ");
INSERT INTO wim_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Puth nil Jesus.ana thaw, “Kana! Niiy keꞌa!” Aꞌ nil paman kon mam nunang puth konan min ngul ween. ");
INSERT INTO wim_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Aꞌ nil Jesus.an kan-ngul thaw thant pam piꞌ-piꞌanam priests al-alantan aꞌ thant moom thapangumpanantaman than aawuch ngench thayanan piꞌ-piꞌantan, aꞌ wuut manth-thayan al-alantan thanan wamp-wampin yipam mamayn nunangana, “Niiy nhengk-peempan, aꞌ yuk muurkan nanangan thakan kal-kalaniy ngayangan yipam mamān ey? ngay keꞌ pam way yimanangan ey? ");
INSERT INTO wim_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ngay puth aak ingam wunanam a! Aꞌ ngaaꞌ thon-thonangana ngay aawuch ngench thayananga thaaꞌ-aath-aathangan niiyang ey! Puth niiy keꞌam maman ngayanga, yaꞌa. Aakan kan-ngul wamp niiyantana niiy kan-ngul mamān ngayangana, keꞌ nil oony way piꞌanan thaw niiyantana. Nil way-wayam paththam anmana, keꞌ aak ngaaꞌ nyiman wunana.” ");
INSERT INTO wim_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Anpalana, than mamin nunang Jesus.an aꞌ kalin nunang aawuch pam piꞌan alantamakan, moom priestsantam al-alantamakana. Nil Peter.aniy-a, kecham koy-koyyuw iiy-iiy thanttanga. ");
INSERT INTO wim_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Thum aak angman pench-pench aak yoonan, aawuch thinthana, aꞌ nil Peter.ana thum thinth nyiin-nyiin thanttang pam wanch wiy al-alantangana. ");
INSERT INTO wim_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Anpalana, nil wanchan wamp nil workan iiy-iiy pam piꞌan alantan. Nil Peter.an oth piꞌ-piꞌ nunang thum thinthan nyiin-nyiin, aꞌ nil thaw thant wiyant, “Nil pam inan tham Jesus.antangan iiy-iiy!” ");
INSERT INTO wim_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Puth nil Peter.an wik uuyam, aꞌ thawant, “Ayyang, ngay keꞌ meeꞌmiy nunang yaꞌa!” ");
INSERT INTO wim_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Anpalana pam ngulan wamp aꞌ thath nunang Peter.an aꞌ thawant, “Nint ngurp nungantam tham ey?” Nil puth Peter.an thawant, “Ayyang, ngay ngurp nungantam yaꞌa.” ");
INSERT INTO wim_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Hour thonamanga kanan want-a, pam thonangan wik thay-thayanam thaw nungant Peter.antan, “Nint kan-kanam paththam ngurp nungantam Jesus.antama, puth nint thamp aak Galilee anpalan wampana.” ");
INSERT INTO wim_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Nil Peter.an thawant, “Ayyang, ngay keꞌ meeꞌmiy nint wik want-wanttakan wik thaw-thawangana.” Puth nil Peter.an wikan yippak thaw-thaw thant-a, minh roosteran pech-pech. ");
INSERT INTO wim_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Nil Jesus.an puth weent aꞌ koochanam thath nunang Peter.an aꞌ wikan konang wamp nungant Peter.ant nil Jesus.an thawant, “Ngay inan kan-kanam thawang nungka, inman ngutangan-a, nil minh roosteran keꞌan yippak pechowan-a, nint maꞌ-koꞌalamana ngul wik uuyamān thanta pam wanch wiyantana, nint keꞌ ngayang meeꞌmiy yaꞌ yimanangana.” ");
INSERT INTO wim_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Aꞌ nil Peter.an yoon pent aꞌ ngangk thuthanakam anman peey-peey ngula. ");
INSERT INTO wim_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Than pam al-alangan Jesus.an piꞌ-piꞌin nunang-a, than thaaꞌ-yump-yumpin nunang aꞌ piik-piikin nunanga. ");
INSERT INTO wim_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Than meeꞌ nungantaman ngook manyang kathin nunanga keꞌ yipam aakan thathow aꞌ piikin nunanga. Than thawin nungant, “Ayyang, nint kan waaꞌān nganta, nintang weeꞌangan piika?” ");
INSERT INTO wim_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Aꞌ than wik way yot-yotam thaw-thawin nunganta. ");
INSERT INTO wim_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Kinch kanan mat-a, than pam piꞌ-piꞌanam anangan karpam nyiinin than yipam wik thawayn — than manth-thayan anangan, aꞌ than pam piꞌan priests anangan, aꞌ puth pam piꞌ-piꞌan wiy anangan than wik thayanan thaaꞌ-aath-aathin thanang. Anpalana, than soldiers al-alangan Jesus.an kalin nunang thanta. ");
INSERT INTO wim_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Aꞌ thanan thaw-thawin nungant Jesus.antana, “Nint kan waaꞌān nganta! Nint ngul pam inan God.angan keenkaman kaaꞌngak ey? kuchowan nintang ey?” Nil puth Jesus.an thaw thant, “Ngay nath waaꞌing niiyantwey-a, niiy keꞌ ngeeyina yaꞌa, niiyan ngayang man-ngeey-ngeeyin anmana. ");
INSERT INTO wim_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ngay nath wik ngeenak nathan engking niiyant-a, an niiyana thaaꞌ popam anman piꞌ-piꞌina. ");
INSERT INTO wim_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Puth aak inpalan-a, ngay pam inman God.angan kuchany-a, ngay aak umpuyangam wun-wunāng God.antangana aꞌ moom piꞌan nyiin-nyiināng nungantang. Nil piip God.an kan-kanam paththam wuut piꞌana, min-minam-a, thayan-a, aꞌ maꞌ-kuncha.” ");
INSERT INTO wim_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Aꞌ thanan kan-ngul thawin nungant Jesus.antan, “Nint ngul puk nhengk God.antam ey?” Nil puth Jesus.an thaw thant, “Niiy wik nanman kan thawan ngay puk nhengk God.antama.” ");
INSERT INTO wim_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Thanan puth thawin thanttakaman, “An kana, ngampan kan ngeeyamp nunang nil-nilaman thawa nil puk nhengk God.antamana. Ngamp wiyant ngulana keꞌ-ngul engkimpa nungantamana yaꞌa.” ");
INSERT INTO wim_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Anpalaniya, than yotam anangan kan-ngul ekin aꞌ Jesus.an kalin nunang, aꞌ um pam piꞌan Pilate.antangan thanathin nunang. ");
INSERT INTO wim_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Than waaꞌin nunang Pilate alantana. Thanan thawin, “Ngan pam inman ngeey-ngeeyan nunang way-wayak thaaꞌ-aath-aath thanang pam wanch kampan nganttam anangana. Nil puth thaw thant wukal income tax keꞌ theeꞌ-theeꞌayn pam piꞌan Government alantan. Aꞌ nil puth pam piꞌan king waaꞌan nungamang, pam anman nil God.angan keenkanaman kaaꞌngak kuchow nganta.” ");
INSERT INTO wim_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Nil Pilate.an thaw nungant, “Nint ina moom king Jews al-alantaman ey?” Nil Jesus.an thawant, “Nint wik nanan thawangan-a, an kan-kanama.” ");
INSERT INTO wim_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Aꞌ nil Pilate.an thaw thant pam piꞌan priests al-alantan aꞌ pam wanch thaaꞌ-wantanam al-alantana, “Ngay puth ep ngeeying nunang pam inaniy way keꞌam iiy-iiya.” ");
INSERT INTO wim_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Puth thanan puth-putham wik thaaꞌ-thayanam thaw-thawin, “Nil wik way-wayak thaaꞌ-aath-aath thananga! Anpalana nil kulliy ngul yump thanang pam wanch yot anangan aak Judea umyompanaman, thanana kul piꞌan thak yump-yumpin thanttakam ngula. Nil kaꞌathaman thaaꞌ-aath-aath thanang aak Galilee angman, aꞌ nilana aak iikanakan wamp ngula.” ");
INSERT INTO wim_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Nil Pilate.angan wik inangan ngeey-a, nilan thaw thant, “Nil pam inman ey? aak Galilee.aman wamp ey?” ");
INSERT INTO wim_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Thanan puth thawin nungant, “Eeꞌa.” Yaa, nil Pilate.angan kuch nunang Jesus.ana Herod alantan, nil pam moom piꞌan aak Galilee.aman. Puth nil Herod.ana aak Jerusalem.ang yaan wun-wuna. ");
INSERT INTO wim_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Nil Herod.angan pam anangan thath thanang Jesus.an wampathin nungantan-a, nilan ngangk min wun, puth nilan nathpalman wik thooꞌ thonakam ngeey-ngeey Jesus.antamana, aꞌ nilan kaangk paththam thathow nunang. Aꞌ putha nil kaangk thathow Jesus.angan work piꞌanan yumpow meeꞌ nungantangana. ");
INSERT INTO wim_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Aꞌ Herod.angan kan-ngul mep-mep nunang, Jesus.ana. Nil puth Jesus.ana koyam keꞌam thaw nunganta. ");
INSERT INTO wim_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Aꞌ than pam piꞌ-piꞌan priests anangan aꞌ than pam piꞌ-piꞌan anangan than wik thayanan thaaꞌ-aath-aathin-a, thanan puth thintham than-thanin, aꞌ othamayan wik thaaꞌ pech-pechin, way waaꞌ-waaꞌin nunang Jesus.ana. ");
INSERT INTO wim_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Amanamaniya, Herod-a, putha pam soldiers nungantam al-alangan kan-ngul thaaꞌ-thengkathin nunang Jesus.ana, wik wayanang thakan thawin nunganta. Putha than soldiers al-alanganiya ngook min-minam ngoonchathin nunang Jesus.an, keꞌ ngook pam kings al-alangan ngoonch-ngoonchantana thanan yipam thaaꞌ-thengkathayn nunangweya. Aꞌ anpalana nil Herod.angan koyam ngul kuch nunang Pilate.antana. ");
INSERT INTO wim_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","An kaꞌathamana pul Herod-a, Pilate.angana kaangk keꞌ pul-pulantakam, ngul amanamaniya pul ngurp ngul yumpuwpula. ");
INSERT INTO wim_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Nil Pilate.angan yalmath thanang pam piꞌan priests anangan aꞌ pam piꞌan wiy anangan aꞌ putha pam wanch yot anangan. ");
INSERT INTO wim_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Aꞌ nilan thaw thant, “Niiyalang, in ngeeyāna, niiy pam inman kaꞌathaman wampathan nunang ngathara, aꞌ waaꞌan nunang nil wik way thaaꞌ-aath-aath thanang pam wanch anangan. Ngay kan puth mepangan nunang meeꞌ niiyantang, aꞌ ngay keꞌam ngaantam-ngeeyang nunang nil wayan iiy-iiy keꞌ niiyan waaꞌ-waaꞌan nunang. Niiy wik aak-yaꞌang waaꞌ-waaꞌaniy nunangweya. ");
INSERT INTO wim_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Nil Herod.ang yimanangan ngaantam-ngeey nunang nil way keꞌaman iiy-iiy, nil puth palam kuch nunang nganta. Nil pam inan way paththam keꞌam iiy-iiy. Ngamp aak-yaꞌangan keꞌ kuchimp nunang mulaniy wuniya. ");
INSERT INTO wim_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ngay puth nanpalan thawang thant soldiers ngatharam al-alantan piik-piikayn nunang whipangan, aꞌ kuchayn nunang ngula.” ");
INSERT INTO wim_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","(Puth kaap thon-thonangana, may piꞌanan kiingk-kiingkantan Passover.an-a, nil Pilate.angan pam thon-thonam kuch-kuch thant Jews al-alantan aak jail anpalana.) ");
INSERT INTO wim_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Than pam wanch thaaꞌ-wantanam anangan pech-pechin, “Mulathān nunanga! Nint Barabbas.an ep kuchān nunang nganta!” ");
INSERT INTO wim_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Nil Barabbas.an aak jailang wun-wun, nil puth pam wanch yot anangan kulliy yump thanang thanan yipam Government.an thaamp-thaampayn aꞌ nilana thamp pam wanch wiy anangan mul-mulath thananga.) ");
INSERT INTO wim_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Nil puth Pilate.angana kaangk minam kuchow nunang Jesus.an, nil putham ngul thaw thanta, “Ngay Jesus.an kuchāng nunang ngula.” ");
INSERT INTO wim_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Puth thanan othamayan pech-pechin nunganta, “Yuk wuuyanang waanchān nunang aꞌ mulathān nunanga!” ");
INSERT INTO wim_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Nil Pilate.an putham thaw thant, “Nil way ngeen yump niiyanta? Ngay thath-thathang nunang nil pam min iiy-iiy, way keꞌam yump-yumpa, yaꞌa. Ngamp keꞌ kuchimp nunang mulaniy wunowa. Ngay ngul thawāng thant soldiers ngatharam al-alantan whipangan piik-piikayn nunang aꞌ ngayan-a, kuchāng nunang ngula.” ");
INSERT INTO wim_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Puth than pam wanch yot anangan othamayan anman pech-pechin, “Yuk wuuyanang waanchān nunanga! aꞌ mulathān nunanga!” Than keꞌ-ngoongkam othamayan anman pech-pechin aꞌ thaach-thaachin nunang Pilate.an wik ngeeyow thanang. ");
INSERT INTO wim_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Aꞌ anpalana, nil Pilate.angan kuch nunang Jesus.an mul yipam wunow keꞌ than pam wanch anangan thawin. ");
INSERT INTO wim_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Aꞌ puth nil Barabbas.an aak jail anpalan kuch nunang, keꞌ than pam wanch anangan thawin nungant. Pam inman Barabbas.ana pam way paththama, nil kulliy yump thanang pam wanch yot anangan, aꞌ pam wanch wiy anangan mul-mulath thananga. Aꞌ nil Pilate.angana kuch nunang thant Jesus.ana than yipam mulathayn nunanga. ");
INSERT INTO wim_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Anpalana, than soldiers al-alangana Jesus.an yoon kalin nunanga. Than kanan iiy-iiyin-a, than pam namp Simon uwin nunang. Nil Simon.ana aak Cyrene punchan, aꞌ nil aak kangkam wamp aak piꞌanakan. Than mamin nunang, aꞌ yuk wuuyan Jesus.antaman picham nungantamang wunpin aꞌ thaachin nunang yuk wuuyanan kalow, koy-koyyuw iiy-iiyow Jesus.antang. ");
INSERT INTO wim_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Than pam wanch thaaꞌ-wantanam al-alangan monkan-wak-wakin nunang Jesus.an. Wanch wiy anangana othamayan peey-peeyin nungantama. ");
INSERT INTO wim_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Puth nil Jesus.an weent thant, aꞌ thaw thant, “Niiy wanch aak Jerusalem punchana, in ngeeyāna! Niiy ngatharaman keꞌ peeyāna, niiy niiyantakam peeyin aꞌ puk manyiy niiyantam al-alantaman. ");
INSERT INTO wim_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Puth aakan kan-ngul wampan pam wanch anangan ngul thawayn, ‘Wanch puk keꞌ uwanam anangan ngangk min wunayn aꞌ putha wanch puk thuut keꞌ aathanamana ngangk min wunayna.’ ");
INSERT INTO wim_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Aak an-aniyangan-a, than pam wanch anangan ngul thaw-thawayn yoyk al-alantan, maakayn thananga, aꞌ kangayn thananga! ");
INSERT INTO wim_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Than ngul waanchayn ngayang yuk wuuyanangana, aꞌ mulathayn ngayang. Puth ngayana way keꞌ yumpanam, than aak-yaꞌangan mulathayn ngayanga. Nil God.angan ep-paththam way paththam waaꞌow thanangana than mulathayn ngayangana aꞌ anpalan-a, way paththam yumpow thantana.” ");
INSERT INTO wim_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Than pam soldiers al-alangan pam kucham thampang kalin pulang Jesus.antangan mulathayn pulanga. Pul pam kucham inanganiy way-wayam iiy-iiypula. ");
INSERT INTO wim_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Than aak-aakanakan iiyin aak namp “Kuchek kaanchak.” Than kanan wampin-a, thanana nailang ngul pungin nunang Jesus.an yuk wuuyanangana, aꞌ waanchin nunang ngula, nil yipam mul wunow. Aꞌ putha pam kucham anangan nailang thampang pungin pulang yuk wuuyanangan waanchin pulang. Pam thonamana malang waanchin nunang Jesus.antang, thonaniya thakang waanchin nunang. ");
INSERT INTO wim_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Aꞌ nil Jesus.an kan-ngul God.antan thaw, “Piip ngatharam-ang, way inangan thanan yump-yumpantan ngathara nint keꞌ ngaantam-ngeeyān, kon ngul ngathow nintang, puth thanan min-min keꞌam thiichantan thanttakam than ngeenan yump-yumpantan.” Aꞌ than pam soldiers anangan yuk dice keeꞌ-keeꞌin, yipam weeꞌang nath ngook nungantaman uwowa. ");
INSERT INTO wim_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Pam wanch yot angam thinth than-thanin, thath-thathina. Aꞌ pam moom Jews.antam al-alangana thaaꞌ-thengk-thengkathin nunang Jesus.an aꞌ than thawin ngul, “Nil thanang wiy anangan ep kaaꞌ-piichanath ey? nil puth nungamang thamp kaaꞌ-piichanathow ee! Nil nath pam inman aak keenkan nil God.angan kaaꞌngak, aak iikanakaniy ukowa, kaaꞌ-piichanathowan ngampanga. Nath nilamwey-a, yaa, puth nilana mulaman kaaꞌ-piichanathiy nungamangana.” ");
INSERT INTO wim_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","38","Yuk wuuyanang Jesus.antang kenyangkana than wik inangan umpin, “Nil pam inana King Jews.antama.” Than pam soldiers al-alangan thampa thaaꞌ-thengk-thengkathin nunang Jesus.ana. Aꞌ than wampin nungant wine pochan yipam theeꞌayn nungant mungkowa. Aꞌ than thawin nungant, “Nint pam piꞌan Jews il-ilantaman ey? Yaa, nint puth kaaꞌ-piichanathān nungkamanga!” ");
INSERT INTO wim_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Nil pam way thonam angman yuk wuuyanangan waanchin nunanga othamayan thaaꞌ poch-pocham pech nunganta, “Nint keꞌ pam anante? Nil God.angan kaaꞌngakan kuchowan e? Nint puth nungkamang kaaꞌ-piichanatha! aꞌ puth nganang tham kaaꞌ-piichanathāna!” ");
INSERT INTO wim_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","41","Puth nil pam way thon alangan wak nunang paman, “Ayyang, nint appapa. Than yuk wuuyanangan waanchin ngampang ngamp mul yipam wunāmp. Nint ngul keꞌ winynyang moꞌangan God.antaman yaꞌ ey? Ngal ep-paththam pam waya! way yot yump-yumpala keꞌ-paal ngalangan yuk wuuyanangan waanchina. Nil pam inan yaꞌa, pam min paththama, nil way keꞌ yumpanama.” ");
INSERT INTO wim_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Aꞌ nil thaw ngul Jesus.antan, “Nint moom piꞌan ngulan iiy-iiyān-a, nint ngayangan ngaantam-ngeey-ngeeyāna, aꞌ min iiy-iiyān ngathara.” ");
INSERT INTO wim_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Aꞌ nil Jesus.an puth thaw nungant, “Ngay in kan-kanam thaw-thawang nungka. Kinch inmana, nintiya aak angman ngatharang wun-wunān aak minang angan.” ");
INSERT INTO wim_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Anpalana kinch keny ngulaniya, twelve oꞌclockangana, aak pal-puyan ngaaꞌ paththam wun, ngaaꞌ anman wun-wun three oꞌclockakam. Kinch keꞌam park-park, yaꞌa. Aak an-aniyangan-a, ngook keeꞌan aawuch ngench thayanangan waanchin-a, anpal kenyan um-menhang pekakam ika. ");
INSERT INTO wim_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Aꞌ nil Jesus.ana wik othamayan pech ngul, “Piip-ang, ngay ngangk ngatharamana maꞌ nungkarang wantang ngula.” Nil Jesus.an wik inangan kanan thaw-a, nil utham ngul. ");
INSERT INTO wim_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Nil pam moom soldiers al-alantamana angman than-than, thath-thatha. Aꞌ nilan thaw ngul, “Nil pam ilangana way keꞌ yumpanam, yaꞌa, nil pam min-minam paththama, an kan-kanama!” Aꞌ nil thaaꞌ-kuump-kuump nunang God.ana. ");
INSERT INTO wim_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Than pam wanch yot angman woonchin yipam thathayna way anangan yumpayn nungant, puth thantan ngangk way-wayam wun aꞌ kuchek thak piik-piikwin thanttakamana, aꞌ anpalaniya thananiya koyam kan-ngul iiy-iiyin aak thanttamakana. ");
INSERT INTO wim_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Puth ngurp nungantam anangana, aꞌ than wanch wiy anangana nunangan monkan-wak-wakin aak Galilee.aman-a, aꞌ putha pam wanch wiy anangan ngurp nungantaman-a, wal kecham than-thanin aꞌ thath-thathin. ");
INSERT INTO wim_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Pam namp Joseph, aak Arimathea anpalana, aak Judea angman wun-wun. Nil pam min paththam. Nilana aak min aakanakan kuup-kuup, nil God.angan pam wanch yot anangan maꞌ nungantangan ngulan piꞌ-piꞌow thananga. Nil puth pam councillor thamp iiy-iiya. Than councillors wiy al-alangan kaangk keꞌ nunang Jesus.ana, puth nil Joseph.angana ep kaangk nunang. Nil nanpalan eeꞌ keꞌam thaw than wikan yump-yumpin Jesus.an mulathayn nunang. ");
INSERT INTO wim_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Nil puth Joseph.ana Pilate.ant wamp nungant, aꞌ thawant, “Ngay pam mulan keꞌ kaling nunang ey?” ");
INSERT INTO wim_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Aꞌ nil pam mulan ukath nunang yuk wuuyan anpalan, aꞌ kath nunang ngul ngook min ongk alangan, aꞌ nil aak awarangan pek ngoonchath nunang — aak awar inana, than kunttow thayan anpalan yumpin, puth awar nyiingkanama, than pam mul keenk keꞌaman thenchin. ");
INSERT INTO wim_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Aak kinch anman Fridaya, puth ngaaꞌ thonangan Saturday wunowa aak ngench thayanana. ");
INSERT INTO wim_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","56","Anpalaniya than wanch anangana Jesus.antangan iiy-iiyin aak Galilee.aman-a, thananiya Joseph.antang iiyin than yipam awar kunttowan thathayn aꞌ yipam thathayn than want-wanttakan wunpin nunang Jesus.ana. Aꞌ thanana kan-ngul iiy-iiyin koyam aak thanttamakan, aꞌ opar awal min-minam anangan karpam nenchanathin yipam kemp Jesus.antamang nampayn. Puth thanan keꞌam yippak kalina, yaꞌa, puth aak Saturday.ana than nyiin-nyiinin, work keꞌam iiy-iiyin yaꞌa, puth than wik thayan Moses.antaman piꞌ-piꞌina. ");
INSERT INTO wim_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Aak Sunday ngaaꞌ-ngaaꞌthiyangaman-a, kinch keꞌaman yippak pent-a, than wanch koꞌalamana kan-ngul iiyin aak awarakan. Than opar awal min anangan kalin, than kempan yipam mamayn nunang Jesus.ana. ");
INSERT INTO wim_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Than wampinan-a, than thathin ngul kunttow piꞌanana thaaꞌaman-a, kanam thaꞌin. ");
INSERT INTO wim_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Thanan aak awarangan pek ngoonchin, puth than pam mul Lord Jesus.ana keꞌam uwin nunang, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Than angman than-thanina kon-wal akangam than-thanin, aꞌ yaam keꞌanamana pam kucham wamppul, aꞌ thanpul thanttangan. Ngookan pach-pacham ngoonchpula. ");
INSERT INTO wim_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Than wanch anangan winynyang paththam weenin, aꞌ pungkang ngul thuchin aakangan, ngul-ngangk thamana. Pul pam anangan thawpul thant, “Niiy ngeenak wenk-wenkaniy nungant aak inan pam mulan wun-wuntana! Nil man-yetham ngul iiy-iiyana. ");
INSERT INTO wim_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Nil in yaꞌa, nil kanam ek mulamana! Niiy ngaantam-ngeeyān wik nilan thaw niiyanta aak Galilee.angan wun, ");
INSERT INTO wim_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Pam way al-alangan maꞌam theeꞌayn ngayanga pam way wiy al-alantana, thananiya yuk wuuyanang waanchayn ngayang aꞌ mulathayn ngayanga, pam ngay inman nil God.angan kuchanya. Kinch koꞌalamang ngulan wantow ngayang-a, ngayaniya mulaman koyam ngul ekānga.’” ");
INSERT INTO wim_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Aꞌ wik nungantam anangan kuchekangan ngul wamp thant. ");
INSERT INTO wim_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Aꞌ thanan koyam iiyin aak awar anpalan aꞌ wik yotam waaꞌin thant ngurp nungantam eleven al-alantan aꞌ pam wanch wiy al-alantan thamp. ");
INSERT INTO wim_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Than wanch inangana, Mary Magdalene-a, aꞌ puth-a, Joanna-a, aꞌ Mary thonan nil kaath nungantam James.antamana aꞌ puth-a, than wanch wiy anangana. Thananiya wik yotaman waaꞌin thant ngurp Jesus.antam al-alantana. ");
INSERT INTO wim_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Puth than ngurp nungantam al-alangan man-ngeeyin thanang, thanan ngaantam-ngeeyin keꞌ than wanch al-alangan keꞌ wik yaan waaꞌ-waaꞌin thant. ");
INSERT INTO wim_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Puth nil Peter.an erkam ek aꞌ kamp moꞌ-moꞌ aak awar aakanakan. Nil thuch aꞌ ngook ongkan thath than kathin nunang Jesus.an puth nil pam mul Jesus.an keꞌam thath nunang, yaꞌa. Nil ngangk ikanang anman koyam iiy-iiy aakak. ");
INSERT INTO wim_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Kinch an-aniyangana, pam ngurp kucham Jesus.antam anangan aak Jerusalem anpalan iiy-iiypul aak pulantamak namp Emmaus, aak kech keꞌanam eleven kilometres thonakama. ");
INSERT INTO wim_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Pul Jesus.an waaꞌ-waaꞌpul nunang, nil yuk wuuyanangan utham thakan. ");
INSERT INTO wim_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Pul wikan yippakan thaw-thawpul-a, nil Jesus.ana angman paththam wamp pulantang aꞌ iiy-iiy angman pulantang ngul. ");
INSERT INTO wim_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Pulana thathpul nunang Jesus.ana, pulan keꞌam thiichpul nunang, nil puth piip God.angan keꞌ kuchek thinhan yump pulang keꞌ yipam thiichowpul nunang Jesus.ana. ");
INSERT INTO wim_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Aꞌ nilan thaw pulant, “Nip wanttak thaw-thawanip e?” Pulana popam angman thanpul. Kaaꞌwal pulantamana wiy-wiyam wuna puth ngangk way wun pulant. ");
INSERT INTO wim_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Pam thonam namp Cleopas, nilan thaw nungant Jesus.ant, “Nint ngul keꞌ meeꞌmiy yaꞌ ey? Nint ngul thonam ilangaman aak Jerusalem.angan wik keꞌam ngeeyan ey? way ngeenan than nyiingk-nyiingkan yump-yumpin ey?” ");
INSERT INTO wim_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Aꞌ nil Jesus.an thaw pulant, “Ngeen e?” Aꞌ pulan thawpul nungant, “Keꞌ pam anan aak Nazareth punchanan mulathin nunang ee! Jesus Christ.ana. Nint ngul ngoongk-ngoongkam ey? Nil pam anman God.angan kuch nunanga. An nil pam maꞌ-kunch, thayan paththam iiy-iiy meeꞌ piip God.antangan, aꞌ putha meeꞌ ngamparang yotamantang thamp. Nilaniya work piꞌ-piꞌanaman yump-yump aꞌ putha wik God.antam anangan ngangk thayanangam waaꞌ-waaꞌ pam wanchantana. ");
INSERT INTO wim_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Aꞌ anpalana pam piꞌan priests al-alangan putha pam councillors nganttam al-alangan maꞌam theeꞌin nunang pam wayanang al-alantan than yipam mulathayn nunang. Anpalaniya, thananiya yuk wuuyanang ngul waanchin nunang mul yipam wunow. ");
INSERT INTO wim_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Puth nganan ngaantam-ngeeyan nil God.angan kuchan keꞌ ngampang Jews inangan kaaꞌ-piichanathow, puth yaꞌ ey? Nilan puth mul kanam kinch maꞌ-koꞌalamang ngul wun awaranganiya. ");
INSERT INTO wim_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Aꞌ putha in ngeeya: ngurp nganttam wanch wiy al-alangan waaꞌin ngant than ngaaꞌ-ngaaꞌthiyangaman iiyin aak awar kunttow aakanakana. ");
INSERT INTO wim_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Puth than keꞌam uwin nunang awarang, aak yaꞌ-yaꞌam thathin nunganta. Than ngaantiyongk kucham angman thathin pulang aꞌ pul ngaantiyongk al-alangan waaꞌpul thant nil Jesus.ana man-yetham ngul iiy-iiyan. Than wik inan waaꞌin ngantan-a, nganana thaaꞌam ikana. ");
INSERT INTO wim_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Anpalana, than ngurp nganttam wiy anangan ngul iiyin aak awar kunttow aakanakana. Than aak anganiy wampin-a, Jesus.ana keꞌam uwin nunang yaꞌa, keꞌ wanch al-alangan yimanang aak yaꞌ-yaꞌam uwin.” ");
INSERT INTO wim_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Aꞌ nil Jesus.an thaw pulant ngul, “Nip kuchek thinhan ey? Nip min-minan keꞌam ngaantam-ngeeyanip ey? Wik than pam prophets al-alangan waaꞌ-waaꞌin niiyant ey? ");
INSERT INTO wim_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","An mina than pam wanch al-alangan wayan yump-yumpin nungant Christ.antan, aꞌ mulathin nunangan puth amanam ngulana nil moom wuut piꞌan paththam ngul iiy-iiyow karpam piip God.antangan.” ");
INSERT INTO wim_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Aꞌ nil Jesus.angana wik God.antam keenkanam anangan engk-engkanang waaꞌ-waaꞌ pulant ngula. Kaꞌathamiya wik Moses.antam waaꞌ-waaꞌ pulant. Anpalaniya wik pam prophets al-alantaman nil kooch-koochanath pulant than keenkanaman waaꞌin nunang Jesus.an. ");
INSERT INTO wim_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Anpalana, than thinth ngul wamp-wampin aak pulantamak Emmaus.akana, aꞌ nil Jesus.an keꞌ aak thaaꞌ puy iiyiya aak thonak-a, ");
INSERT INTO wim_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","puth pam kucham anangan thaaꞌ-thayanam thawpul nungant Jesus.antan, “Nint keꞌ iiyāna, ingam paanthān nganttanga! Kinchan puth kanam uka, aak ngaaꞌ ngula.” Yaa, nil Jesus.ana iiy pulantang aak pulantamakan. ");
INSERT INTO wim_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Aꞌ anpalana, than karpam nyiin-nyiinin, mayakana. Aꞌ nil Jesus.angana may breadan maay aꞌ thankyou thaw piip God.antana aꞌ mayana kan-ngul pip-pip aꞌ pulant theeꞌ mungkanakana. ");
INSERT INTO wim_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Aꞌ aak an-aniyangana, pul thiichpul nunang Jesusa, puth nil God.angan kuchek min yump pulang yipam pul thiichowpul nunang Jesus.ana. Amanamaniya nil Jesus.ana lam-lam yaꞌam pulantamana, pulana keꞌam ngul thathpul nunang yaꞌa. ");
INSERT INTO wim_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Pulan thawpul pulantakamana, “Nilan wik thaw-thaw ngalant-a, aꞌ putha wik lat ngench thayanaman kooch-koochanath ngalant-a, wik nungantaman ngangkang ngoonch ngalantanga, puth ngangk ngalantamana min-min paththam wunana, ngal woyan wakanan iiy-iiyala.” ");
INSERT INTO wim_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Aꞌ anpalaniya, pul wur ekpul ngul aꞌ koyam iiypul aak Jerusalem.akana aꞌ pulana koochanam iiypul thant ngurp Jesus.antam al-alantan than puth aawuch thonamang yalmathwin pam wanch wiy anangan tham. ");
INSERT INTO wim_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Aꞌ thanan thawin pulant pam kucham al-alantana, “Moom ngamparam Jesus.ana kan-kanam mulaman koyaman eka, nil puth angman meenath nungamang Simon.antana.” ");
INSERT INTO wim_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Amanamana pul waaꞌpul thant nil Jesus.an woyan wakanangan wamp pulant, puth pul kaꞌathamana keꞌam thiichpul nunang, yaꞌa. Puth anpalaniya pul thathpul nunang ngul may breadan pip-pip-a, pulan paththam thiichpul nunang Jesus.ana. ");
INSERT INTO wim_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Pulan yippak wikan waaꞌ-waaꞌpul nunang Jesus.an-a, nil Jesus.an paththam angman menhang wamp thant aꞌ thaw thant ngul, “Ngay kaangk niiyan ngangk minangam ngul iiy-iiyāna.” ");
INSERT INTO wim_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Puth thananiya winynyang moꞌin, thanan ngaantam-ngeeyin keꞌ oony nungantam Jesus.antaman wamp thant, puth yaꞌa, an nilam wamp thanta. ");
INSERT INTO wim_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Aꞌ nil Jesus.an thaw ngul thant, “Niiy ngul ngeenam winynyang moꞌaniy ngatharam e? Niiy ngaantam-ngeeyaniy ngay keꞌ oony yimanangan wampangan niiyant ey? Yaꞌa, in ngayama. ");
INSERT INTO wim_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Thathān ngayang, thaꞌ aꞌ maꞌ ngatharam inangan mamān. In ngayam kan-kanam than-thanang inana. Puth pam uthamanan-a, an oony nungantaman kemp kaanch keꞌam kal-kalan keꞌ ngay yimanangana yaꞌa.” ");
INSERT INTO wim_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Aꞌ nil Jesus wik inangan kanan thaw-a, nil maꞌ-a, aꞌ thaꞌ nungantam anangan meen-meenath thant ngula. ");
INSERT INTO wim_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Than ngangk ikanam puth thaaꞌ weꞌaramang aꞌ ngangk minangam thath-thathin nunang, puth thananiy-a, min-minam keꞌ yippak ngaantam-ngeeyin nunang, aꞌ puth thananiy thawina, “Ayyang, in-ngul Jesus ey? Kan-kanam nilam wamp ngampar ey? nath yaꞌ ow!” Aꞌ nil Jesus.an thaw ngul thant, “Niiy ngul may minh yam piꞌ-piꞌaniy ey? Ngay mungkāng yipam.” ");
INSERT INTO wim_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Aꞌ anpalana thananiya minh ngaꞌ menchan manyam theeꞌin nungant. ");
INSERT INTO wim_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Aꞌ nil minh ngaꞌan mam thanttam aꞌ nil angman meeꞌ thanttang mungk ngul. ");
INSERT INTO wim_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Aꞌ nil Jesus.an thaw thant ngula, “Ngay keꞌaman yippak uthamangan-a, ngay kan waaꞌ-waaꞌangan niiyanta, than Moses-a, puth prophets al-alangan keenkanaman latangan umpin waaꞌin ngayang putha lat Psalms.angan waaꞌ-waaꞌin ngayang thamp. Ngay kaꞌathaman kan waaꞌ-waaꞌangan niiyant aak ngeen nathan wampow ngathara, puth inan kan-ngul wamp ngathara. Than puth keenkanaman kan-kanam umpin lat ngench thayanangan.” ");
INSERT INTO wim_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Aꞌ nil Jesus.angana wik kooch-koochanath thant ngul yipam min-minam ngaantam-ngeeyayn wik keenkanam anpalana. ");
INSERT INTO wim_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Aꞌ nil thaw ngul thant, “Aak keenkanaman than latangan umpin nil God.angan kuchow Christ.an. Than latangan wik inangan umpin way piꞌan wampow nungant Christ.antan aꞌ uthamow ngulan. Aꞌ anpalaniya kinch koꞌalamangan-a, nil koyam ngul ekow mulaman. ");
INSERT INTO wim_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Yaa, than pam wanch nungantam al-alangan wik min inangan waaꞌ-waaꞌayn ngul thant pam wanch yotam al-alantan aak Jerusalem.angan wun-wuntan, aꞌ aak nath-nathan wun-wuntana wik thaaꞌnganth thon-thonan thaw-thawantan. Than wik min inangan waaꞌayn thanta, ‘Niiy woyan wayan kan-ngul wantān a! Aꞌ nil piip God.angan keꞌ-ngul yipam ngaantam-ngeeyow way niiyan yump-yumpan nil puth Jesus.an utham niiyant thaaꞌ-pant yipam thawow niiyantam piip God.antan.’” ");
INSERT INTO wim_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Aꞌ nil Jesus.an thaw ngul thant, “Yaa, niiy puth kan thathan ngayanga, niiyaniy-a, waaꞌ-waaꞌān ngayang thant pam wanch wiyantana. ");
INSERT INTO wim_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Aꞌ niiy in thampan ngeeyāna: piip ngatharaman kan-kanam thawa, nil Ngeen-Wiy Min nungantaman kuchow niiyant ngangk niiyantangan wun-wunow, nilan thay-thayanam paththam, mich yaꞌa. Niiy yippak aak ingman kuup-kuupān Jerusalem.anga, aak-aakanakaman nil piip God.angan kuchow niiyant Ngeen-Wiy Min nungantamana.” ");
INSERT INTO wim_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Aꞌ amanamana nil Jesus.ana kaawam iiy aꞌ karpam kal thanang aak Bethany thinth aakanakana. Nil maꞌ kucham nungantamana kenyam maay kootra thanttang angman aꞌ thaw God.antan, “Ngay kaangk nint ngangk min yumpān thanang.” ");
INSERT INTO wim_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Puth nil wikan yippak thaw-thaw thantan-a, nilana kan-ngul want thanang, aꞌ nil keny ngul mat piip God.anta. ");
INSERT INTO wim_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","An than ngurp nungantam al-alangana ngangk min-minangam thaaꞌ-kuump-kuumpin nunang. Aꞌ thananiya koyam ngul iiy-iiyin aak Jerusalem.akan. An than ngangk min-minangam paththam iiy-iiyin ngul. ");
INSERT INTO wim_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Thananiy-a, ngaaꞌ thon-thonan-a, kinch ongkan-a, aawuch ngench thayanang angan than-thanin, thankyou thaw-thawin nungant God.antan. ");
INSERT INTO wim_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Keenkanaman-a, aak keꞌan yippakan wun-a, nil WIKan aak nathpalman wun-wun, murkanim anman, nilam Jesus.an. (Than Jesus.an waaꞌin nunang keꞌ WIK anman ngampar, puth nil wik God.antaman waaꞌ-waaꞌ ngampar, aꞌ nilan waaꞌ-waaꞌ ngampar nil God.an want-wanttakan nila.) Niliy-a, keꞌ God anman. ");
INSERT INTO wim_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Nil angman wun-wun God.antangan. Aak nathpalmana, nil God.antang wun-wun, pul karp. ");
INSERT INTO wim_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Nil WIK alangan-a, yuk way min maꞌmangkam yump, puth nil God.an thaw nungant yimanangan yumpow. Nilwey keꞌan yumpiy-a, aakan-a, yaꞌ-yaꞌam wuniy. An nil yuk way min maꞌmangkam yump. ");
INSERT INTO wim_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Nil WIK alangan ngangk theeꞌ ngampar man-yetham iiyanakan, aꞌ puth-a, nilaman keꞌ nganth yimanangan iiy-iiyan pam wanchantan ngampar, nil puth keꞌ woyan engkan yumpan ngampar. ");
INSERT INTO wim_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Nil nganthaniy-a, aak ngaaꞌangan-a, yaam park-parkan. Nungkway aak ngaaꞌ nyiman wunan-a, nil nganthan yaam anman pench-penchan, keꞌaman uthaman, yaꞌ anman. ");
INSERT INTO wim_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Anpalan-a, nil God.anganiy-a, pam kuchan, paman namp-a, John. ");
INSERT INTO wim_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Nil wamp yipam waaꞌow thant pam wanchantan Jesus.an wampowa keꞌ nganth yimanangan thanta, than yotamang yipam wik ngeeyayn nunang aꞌ ngangk punch-aakam theeꞌayn nungant Jesus.ant. ");
INSERT INTO wim_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","9","Nil puth Jesus.an-a, keꞌ nganth piꞌan paththam ngampara, nilan aak iikanakan uk, woyan minan engkan yump ngampar pam wanch yotamant. Puth nil John.an-a, keꞌ nganth many anman, nilan wampa yipam Jesus.an keꞌ nganth piꞌan waaꞌowan thant, pam wanchantan. ");
INSERT INTO wim_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Nilaniy-a, WIKaniy-a, aak ingan wun-wun. Nil yuk way min maꞌmangkam yump, puth nil God.an thaw nungant yimanangan yumpow. Puth nungkway nil maꞌmangkam yump-a, than pam wanch al-alangan ngoongk-ngoongkam nilan maꞌmangkam yump, thanan keꞌam ngaantam-ngeeyin nunang nilan wik God.antaman kal-kal, keꞌam thiichin nunang, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Nil aak nungantamak uk, puth pam wanch kampan nungantaman thaaꞌnganth thanaman, than keꞌam ngangk min iiyin nungant. ");
INSERT INTO wim_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Puth puungk wiy ep-paththam, ngangk min iiyin nungant, ngangk punch-aakam theeꞌin nungant. Thantaniy-a, pam wanch al-alantan-a, nil Jesus.an thaw thant than puk nhengk God.antam ngul weenina. ");
INSERT INTO wim_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Nil God.an keꞌ piip wunpanam ngamparam inangan yaꞌa. Aꞌ puth keꞌ pam wanch ngamparam inangan maꞌ pam wanchang puk manyan uwowpul, yaꞌa! An nil-nil, puth nil God.angan waaꞌ thanang keꞌ puk nhengk nungantam yimanangan. ");
INSERT INTO wim_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Nil WIK anan-a, ngurp keꞌ ngamp yimanangan wamp, aꞌ ngamparang aak ingan wun-wun. Ngan thathan nunang pam piꞌana aꞌ min-minam paththam, nil keꞌ pam wiy yimanangan yaꞌa; nil puth ngangk minangam iiy-iiy thant pam wanchantan, wik kan-kanam anman thaw-thaw thant. Nil yimanangan iiy-iiy nilan puth nhengk God.antam, nhengk kaaꞌ-thonam anman nungantam. ");
INSERT INTO wim_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Nil John.angan-a, Jesus.an waaꞌ-waaꞌ thant. Nil thaaꞌ-ay thaw-thaw thant, “Pam nil inmana, ngay kaꞌathaman waaꞌ-waaꞌangan niiyant, ‘Nil mangk ngatharangan wampow, nil pam piꞌana, ngay yaꞌa, ngay pam many; nil puth aak nathpalman man-yetham wun-wun, ngay keꞌaman yippak aak-ngeeyangan.’” ");
INSERT INTO wim_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Nil Jesus.aniy-a, ngangk minangam paththam kaangk wunan ngampar, nil ngangk min-minangam iiy-iiyan ngamparak, nil maꞌ-yotam maꞌ-aath-aathan ngampang, aꞌ yuk way min yot theeꞌ-theeꞌan ngampar. ");
INSERT INTO wim_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Aak keenkanaman-a, nil God.angan wik thayan nungantaman Moses.ant waaꞌ, aꞌ Moses.anganiy-a, pam wanchant waaꞌ-waaꞌ thant. Puth nil Jesus.anganiy-a, meenath ngampar nil God.an want-wanttakana, puth nil ngangk minangam iiy-iiy ngampar aꞌ wik God.antaman waaꞌ-waaꞌ ngampar, wik kan-kanam anangan. ");
INSERT INTO wim_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ngamp puth God.an keꞌ thathanam. Nil nhengk nungantamangan puk nungantam kaaꞌ-thonamangan ep meenath ngampar nil God.an want-wanttakan, nilan puth God.antang nathpalman wun-wun Jesus.aniya. ");
INSERT INTO wim_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Anpalaniy-a, than pam piꞌan Jews.antam al-alangan-a, aak Jerusalem anpalan-a, pam priests-a, puth Levites anangan kuchin thanang pam John alantan, than yipam wikakan engkayn nungant. Aꞌ than thawin nungant, “Nint in weeꞌa?” ");
INSERT INTO wim_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Nil John.an wik engkanangam thaw thant, nil wik keꞌam thenchanaman piꞌ-piꞌ, nil thaw, “Ngay pam anan yaꞌa God.angan keenkanaman kaaꞌngak kuchowan ngampara!” ");
INSERT INTO wim_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Aꞌ than putham thawin nungant, “In nint weeꞌ ee? Nint Elijah ey?” Nil John.an thaw thant, “Yaꞌam a! Ngay pam Elijah anan yaꞌa!” Aꞌ than putham ngul engkin nungant, “Nint in pam prophetan ey? Pam God.antaman nganan kuup-kuupanan nungant ey?” Nil John.an thaw thant, “Yaꞌam a!” ");
INSERT INTO wim_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Than thawin nungant, “Puth nint waaꞌān ngant nint pam in weeꞌ ee? ngan yipam wik koyaman kalān thant, nganangan kuchin. Puth nint ngantan waaꞌān nungkamang pam in nint weeꞌ-nathan a?” ");
INSERT INTO wim_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Puth nil John.an thaw, “Ngay pam anman nil pam prophet Isaiah alangan keenkanaman waaꞌ ngayang, wik yimanangan thaw, ‘Nil paman iiy-iiyow, pech-pechow aak pintalangan wik inangan thaw-thawow, “Niiy aak woyan min-minam paththam yumpān nungant, Lord.antana! Aꞌ puth minam ngaantam-ngeey-ngeeyāna, nil Lord wampow ngulan-a, niiyan yipam wik ngeeyān nunang.” ’” ");
INSERT INTO wim_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Pam wiy anangan-a, pam piꞌan Pharisees anangan angman than-thanin thanttang. ");
INSERT INTO wim_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Aꞌ than thawin nungant, John.antan, “Puth nint pam anan God.angan kaaꞌngak kuchowan-a, yaꞌ thawangan, aꞌ nint puth Elijah anan yaꞌ thawangan, aꞌ puth nint pam God.antam prophet anan-a, yaꞌ thawangan. Nint puth wanttak ngakangan kuchek kuungk-kuungkangan thanang a?” ");
INSERT INTO wim_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Nil John.an puth thaw thant, “Ngay ngakang thonakam kuchek kuungk-kuungkang thanang, puth pam thonam aak yamamana, niiyantangan than-thanan, niiy puth keꞌ meeꞌmiy nunang, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Nil pam anmana, mangk ngatharangan wampan, puth nilaniy ep-paththam pam wuut piꞌan, ngay yaꞌa, ngay pam many. Ngayan thaꞌ murrukan nungantam thaꞌaman keꞌ thapathing, yaꞌa, puth ngay pam piꞌan yaꞌa.” ");
INSERT INTO wim_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Than pam anangan John.antan engk-engkin-a, aak namp Bethany.ang angan. Aak Bethany.aniy-a, wonk pal kaawangk Jordan River.aman, aak angan nil John.angan kuchekan kuungk-kuungk thanang. ");
INSERT INTO wim_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ngaaꞌ thon ngulan-a, nil John.angan thath nunang Jesus.an anpal um nungant wampant, aꞌ nil thaw pam wanch al-alantan, “Ayyang, niiyalang, paman nanan thathāna! God.angan kuch nunanga. Ngamp minh sheep manyiyan mul-mulathanamp nil God.angan yipam keꞌ-ngul ngaantam-ngeeyow way ngampan keenkan yump-yumpampa. Nil pam inana keꞌ sheep many ngul uthamow ngamparaka. ");
INSERT INTO wim_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Pam nil inana, ngay kaꞌathaman waaꞌ-waaꞌangan niiyant, ‘Nil mangk ngatharangan wampow, nil pam piꞌan, ngay yaꞌa, ngay pam manya; nil puth aak nathpalman man-yetham wun-wun, ngay keꞌaman yippak aak-ngeeyangan.’ ");
INSERT INTO wim_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ngay kaꞌathaman keꞌ meeꞌmiy nunang pam nil weeꞌ-nathana, yaꞌa, puth ngay wampang niiyant, ngakang kuungk-kuungkang niiyang, niiy pam wanch inangan aak Israel punchan, niiy yipam meeꞌmiy nunang puth nil puk nhengk God.antaman.” ");
INSERT INTO wim_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Anpalaniy-a, nil John.an thaw thant, “Ngay Ngeen-Wiy Min God.antaman thathang uk-uk keꞌ minh kolat yimanangan, anpal kenyan uk nungant Jesus.ant, aꞌ angman nungantang nyiin-nyiin. ");
INSERT INTO wim_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ngay kaꞌathaman meeꞌmiy nunang yaꞌa, nil Jesus.an weeꞌ-nathana, puth nil God.an-a, nilan kuch ngayang ngakangan kuungk-kuungkāng niiyang-a, thaw ngathar, ‘Nint Ngeen-Wiy Min ngatharaman ngul thathān ukowa, aꞌ pam thonam alantangan nyiin-nyiinow ngul. Pam alangamana, nilan Ngeen-Wiy Min ngatharaman ngul wunpow thant, ngangkangan yipam ngoonchow thanttang.’ ");
INSERT INTO wim_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Wik anangan God.angan waaꞌ ngathar-a, nungantam Jesus.antaman-a, ngay puth kanam meeꞌ ngayam thathang, aꞌ puth-a, ngay inan tham waaꞌāng niiyant, niliy-a, puk nhengk God.antama.” ");
INSERT INTO wim_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ngaaꞌ thon ngulan-a, John-a, puth-a, ngurp nungantam kucham, than angman than-thanin, ");
INSERT INTO wim_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","aꞌ nil John.angan Jesus.an thath nunang woyanangan iiy-iiy. Nilan thaw pulant, ngurp nungantamakan, “An thathow a! Pam anan kan thathanip nunang ey? Nil God.angan kuch nunang. Nil keꞌ minh sheep many yimanangan ngul uthamow ngampara.” ");
INSERT INTO wim_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Pam kucham anangan-a, ngurp John.antaman pul-a, wik inangan ngeeypul-a, aꞌ pulan-a, Jesus.an monkan-wakpul nunang. ");
INSERT INTO wim_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Nil Jesus.an weent-a, thath pulang monkan-wak-wakpul nunangan, aꞌ engk pulant, “Nip ngeenak a?” Pul thawpul nungant, “Ayyang, Teacher-ang, nint aak wanttin wunangan a?” (Wik teacher inan-a, wik thanttamangan waaꞌantan Rabbi.) ");
INSERT INTO wim_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Nil Jesus.an thaw pulant, “Nip pal iiyow a! Thathow a!” Pam pul ananganiy-a, iiypul ngul nungantang, aꞌ aak nungantaman thathpul, nil wanttingan wun-wun. Aak anganiya kinch-way-wayang four oꞌclockan wampin aak Jesus.antamangan. Pam pul al-alangaman-a, angman kinch ukath pul Jesus.antang nyiin-nyiinpul. ");
INSERT INTO wim_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Nil-nungant pam thonaniy-a, wik kaꞌathaman John.antaman ngeey-a, aꞌ puth Jesus.antangan iiy-iiy ngul-a, an nil Andrew.anga, Simon Peter alantaman kuuncha. ");
INSERT INTO wim_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Nil erkam paththam iiy, wenk-wenk kuunch nungantamak, Simon Peter alantan, aꞌ uw nunang, aꞌ waaꞌant, “Ayyang! Nganan pam Messiah.an kanam uwan nunanga! pam anan nil God.angan kaaꞌngak kuchowana.” (Messiah.aniy-a, namp thonangan nungant Christ.) ");
INSERT INTO wim_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Aꞌ nil Andrew.angan-a, Simon Peter.an-a, wampath nunang, Jesus.antan. Nil puth Jesus.angan-a, thath nunang, aꞌ thawant, “Nint in Simon, nhengk nungantam John.antaman. Namp nungkar-a, inan ngul wunow, Cephas.” (In keꞌ namp anman, Peter yimanangan waaꞌ-waaꞌanamp. Wik ngamparamanganiy-a, kunttow waaꞌanamp.) ");
INSERT INTO wim_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ngaaꞌ thon ngulan-a, nil Jesus.angan ngaantam-ngeey aak Galilee.akan iiyow. Nil iiy-a, aꞌ Philip ngul uwan, aꞌ thawant, “Nint ngayang monkan-wakāna!” ");
INSERT INTO wim_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","(Nil Philip.an-a, aak Bethsaida anpalan wamp, aak town anman pul Andrew.ang-a, Peter.angan wun-wunpul.) ");
INSERT INTO wim_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Nil Philip.an-a, iiy, pam namp Nathanael alantan wenk-wenkant. Aꞌ nil uw nunang, aꞌ thawant, “Ngan kanam uwan nunang, pam anman Moses.angan keenkanaman waaꞌ ngampar lat ngench thayanangan, aꞌ puth-a, pam prophets al-alangan waaꞌ-waaꞌin nunang thampan. Nil pam alantan namp-a, Jesusa, nhengk Joseph.antamana aak Nazareth punchanantam.” ");
INSERT INTO wim_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nil Nathanael.an thawant, “Ngul nil pam min wampiy aak Nazareth anpalan ey? An yaꞌa!” Nil puth Philip.an thawant, “Yaa, pal iiy a! Nint meeꞌ nungkaramangam thathān nunang a!” Aꞌ pul iiypul. ");
INSERT INTO wim_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Nil Jesus.angan thath nunang Nathanael.an um nungantan iiy-iiy-a, aꞌ nil Jesus.an thaw thant wiy al-alantan, “Pam nanan thathiy nunanga! Pam nil Jew min-minam paththama; nil man-thonama, man-uuy yaꞌa!” ");
INSERT INTO wim_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nil Nathanael.an engkant, “Nint ngul want-wanttak meeꞌmiy ngayangan a?” Aꞌ nil Jesus.an puth thawant, “Ngay kaꞌatham anman thathangan nintang, yuk kom pek-pekaman nyiin-nyiinan, nil Philip keꞌaman yippak thaw nungkar.” ");
INSERT INTO wim_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nil Nathanael.an thawant, “Ayyang, Teacher-ang, nint in nhengk God.antam a! Nint in pam piꞌan a! King pam wanch aak Israel punchan al-alantamana!” ");
INSERT INTO wim_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Nil Jesus.an puth thawant, “Nint kan-ngul ngaantam-ngeeyangan ngayang ey? ngay nhengk God.antaman ey? ngay puth waaꞌangan nungkara ngay nintang yuk kom pek-pekaman thathangan ey? Inan work many yippak thathan, ngulan-a, an nint work piꞌ-piꞌanam ngul thathāna.” ");
INSERT INTO wim_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Aꞌ nil Jesus.angan-a, wik thonangan ngul waaꞌ thant, “Ngay wik kan-kanam thawang niiyant. Niiy aak in kenyan aak God.antaman ngul thathān, puth-a, niiy ngaantiyongk God.antam anangan ngul thathān thanang kenyaman matayn-a, aꞌ puth pekaman ukayn ngatharangana, ngay pam inan nil God.angan kuch ngayang.” ");
INSERT INTO wim_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ngaaꞌ thonang ngulan-a, pam komp-a, wanch koman pul aak Galilee.angan ngentuwpul, aak namp Cana angan. Thanan may piꞌan yumpin wedding aakanakan. Nil kaath Jesus.antamana iiy thamp aakanakan may piꞌanakan. ");
INSERT INTO wim_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Aꞌ than thawin thant, Jesus-a, aꞌ puth ngurp nungantam al-alantan, aakanakan iiyayn, may piꞌanakan, aꞌ than angman wampin thant. ");
INSERT INTO wim_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ngulaniy-a, may wine.an-a, yaꞌ-ngul minch thanttam. Aꞌ kaath Jesus.antaman iiy nungant, Jesus.ant, aꞌ thawant, “Ayyang, may wine.an yaꞌ-ngul, kan minchathin a!” ");
INSERT INTO wim_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Aꞌ nil Jesus.an thawant, “Ayyang, wik nintan ngaantam-ngeeyangan-a, an nint-nint; wik ngayan ngaantam-ngeeyang-a, an ngath-ngath. Aak ngatharan keꞌam yippak wampar, work iiyanakan.” ");
INSERT INTO wim_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Aꞌ nil kaath Jesus.antaman thaw pam al-alantan workan iiy-iiyin, “Nil Jesus wanttakanwey thawow niiyant-a, niiy wik ngeeyān nunang a!” ");
INSERT INTO wim_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Six jars piꞌ-piꞌanam angman than-thanin, than puth kunttowam yumpin thanang, ngakan piꞌ-piꞌin. Jars anangan-a, piꞌ-piꞌanam keꞌ drums yimanangan. Than Jews al-alangan ngak jars anpalan maꞌ kaaw-kaawin thanttakam, puth aak thantan yimanangan wun. ");
INSERT INTO wim_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Aꞌ nil Jesus.aniy-a, pam al-alantan thaw thant, workan iiy-iiyin, “Niiy ngak uwān a! jugs manyiy il-ilangan, aꞌ pal kalān, jars piꞌanang ingan yeech-yeechān, thaaꞌ piimpanakaman.” Aꞌ than ngakan uwin, yeech-yeechin jars piꞌ-piꞌanang angan, aꞌ thaaꞌ mul ngul maay. ");
INSERT INTO wim_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Aꞌ nil Jesus.an thaw thant ngul, “Manyam empāna jar amanaman, aꞌ niiy kalān moom alantan, mayan piꞌ-piꞌan.” Aꞌ than puth kalin nungant, moom alantan. ");
INSERT INTO wim_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Nil moomangan paath-a, puth ngak yaꞌ, an wine paththama, puth nil Jesus.angan ngakam anpalan wine.ak yump. Nil mooman puth ngoongk-ngoongkama, keꞌam thiich Jesus.angan ngakaman yump wine.akan. Than wiy al-alangan ep, pam workan iiy-iiyin, than ep meeꞌmiy. Aꞌ nil moomangan ump nunang, pam nil nyiingkan wanch ngenta, ");
INSERT INTO wim_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","aꞌ thawant, “Than wiyangan may piꞌan yumpantan-a, may wine man-pathan kaꞌathaman theeꞌantan thant. Wine piꞌan kanan mungkantan-a, wine chil way ngul theeꞌantan thant. Puth nintan-a, wine minaniy-a, piꞌan ngampar, koy-koyyuwak.” ");
INSERT INTO wim_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Nil Jesus.anganiy-a, work piꞌ-piꞌanam yot yump thanang, min-miniya. Work min nil kaꞌathaman yump thant-a, inan, ngakaman yump wine.ak, aak Galilee.angan, aak Cana angan. Work piꞌan inan yump-a, an meenath thant nil Jesus.an pam piꞌan, nil-nil, keꞌ pam wiy yimanangan yaꞌa. Anpalana, ngurp nungantam al-alangan-a, kan-kanam ngaantam-ngeeyin nunang, God.angan kuch nunang. ");
INSERT INTO wim_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","May piꞌan kanaman minch-a, nil Jesus.an-a, kaath-kunch-a, aꞌ kuunch nungantam-a, aꞌ puth ngurp nungantam anangan aak Capernaum.ak ngul iiyin, maꞌ-koꞌalam angan wunin. ");
INSERT INTO wim_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Aakan thinth-thinth ngul wampan thant, may piꞌanan yumpayn aak Jerusalem angan. May piꞌan inan-a, Passover.an waaꞌantan. Nil puth Jesus.an aak Jerusalem aakanakan iiy. ");
INSERT INTO wim_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Nil wamp-a, nil aawuch ngench thayan aakanakan iiy. Nil pek ngoonch aꞌ pam anangan thath thanang, minh bullocks thakan sellimpung-pungin thant, pam wanch wiy al-alantan, minh bullocks-a, minh sheep-a, aꞌ putha minh panch munkiyang thakan sellimpung-pungin thant. Aꞌ nil Jesus.anganiy-a, pam wiy anangan thath thanang, table.angan nyiin-nyiinin wukal thampan, yipam wukal wiyantaman epankathayn thant. ");
INSERT INTO wim_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Nil Jesus.ang inangan thath thanang-a, aꞌ whip yump, kuuyam, keꞌ stockwhip yimanangan. Aꞌ nil whipan maaya, kenth thanang. Yotan-a, paa pankin, yoon kamp moꞌ-moꞌin, pam anangan-a, aꞌ minh anangan, sheep-a, bullocks thakan. Aꞌ nil tablesaniy-a, wukal thampaniy-a, wonk thon wew theeꞌ thanttam. Wukal thakan-a, yaꞌ yaarkath thanttam, aakang keek-keekin. ");
INSERT INTO wim_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Aꞌ nil thaw thant, pam al-alantan minh munkiyang anangan sellimpung-pungin, “Minhan puy kalān a! Niiy aawuch piip ngatharamantaman keꞌ wayathān a! In aak store yaꞌa!” ");
INSERT INTO wim_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ngurp nungantam al-alangana wik ngeeyin nunang Jesus.an thawa, aꞌ wik David.antam anangan kuchekangam wamp thant, nil keenkanaman thaw piip God alantan lat ngench thayanangan umpin, “Ayyang, Piip-ang, ngay aawuch nungkaramakan kaangk wunang paththama, aꞌ ngay ngangk wayamang aawuch nungkaram anpalana.” ");
INSERT INTO wim_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Aꞌ than Jews wiy al-alangan kanan thathin-a, pam anangana puth minh thakan pent-pentinan-a, aawuch ngench thayanaman-a, than thawin nungant, Jesus.ant, “Nil weeꞌ thaw nungkar pam wanch ananganiy kenthān thanang a? Nint work piꞌan yumpān ngant puth nganan yipam ngaantam-ngeeyān God.an thaw nungk kenthān thanang.” ");
INSERT INTO wim_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Aꞌ nil Jesus.an puth thaw thant, “Niiy aawuch God.antam inan thuthinwey-a, ngay maꞌ-koꞌalamangan-a, koyam ngul kaachinga.” ");
INSERT INTO wim_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Puth than Jews anangan-a, thawin nungant, Jesus.ant, “Ayyang, in nint wanttak thaw-thawangan e? Maꞌ-koꞌalamangan wunow-a, nint aawuch ngench thayanan koyam erkam paththam ngul kaachin ey? Puth aawuch inan-a, kaap thon-thonang kaach-kaachin, kaap forty-sixang wantan, inaniy yump-yumpin.” ");
INSERT INTO wim_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Puth nil Jesus.angan-a, aawuch paththaman keꞌam waaꞌ, yaꞌa; nil nungantakaman waaꞌ, keꞌ aawuch God.antam yimanangan. ");
INSERT INTO wim_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ngul-ngulan-a, nil Jesus.an kanan mulaman ek-a, wik inangan nungantaman-a, kuchekangam wamp thant, ngurp nungantamak. Aꞌ than wik inangan nil Jesus.an thaw-a, aꞌ puth wik lat ngench thayanaman ngaantam-ngeeyin an wik kan-kanamana. ");
INSERT INTO wim_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Nil Jesus.an angman yippakan wun-a, may piꞌan Passover.an yumpin-a, pam wanch yot al-alangan ngaantam-ngeeyin nunangan pam piꞌan God.antam, than puth work piꞌan thathin nilan yump-yump. ");
INSERT INTO wim_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Puth nil Jesus.anganiy-a, kan ngaantam-ngeey thanang erkam ngul kon-ngathow thanang, nunangan keꞌ-ngul ngaantam-ngeeyayn, puth nil yotaman kan thiich thanang. ");
INSERT INTO wim_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Nilan puth ep ngangk pal pekkuwam thath thanang, pam wanch yot anangan, an puth pam wiy al-alangan keꞌ waaꞌiythan nungant pam wanch want-wanttakan iiy-iiyantan, puth nil kanam thiich thanang. ");
INSERT INTO wim_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Nil pam Nicodemus.an-a, nil pam piꞌan iiy-iiy thant, Jews al-alantan, pam nil keꞌ councillor yimanangan. Nilan-a, pam Pharisee thamp iiy-iiy. ");
INSERT INTO wim_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Nil aak ngutang wamp Jesus.ant, aꞌ thawant, “Ayyang, Teacher-ang, ngan kan meeꞌmiy God.angan kuch nintang, yipmam thaaꞌ-aath-aathān nganang. Nil God.angan keꞌwey maꞌ-aathiw nintang-a, an nint work piꞌ-piꞌanam min-miniy keꞌ yumpin yaꞌa.” ");
INSERT INTO wim_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Nil Jesus.an thawant, Nicodemus.antan, “Ngay nungk in kan-kanam thaw-thawanga; niiywey putham keꞌan meeꞌ-penchin-a, niiy maꞌ God.antang keꞌ iiyin, yaꞌa.” ");
INSERT INTO wim_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nil puth Nicodemus.an thawant, “Ngan puth pam wanch inangan want-wanttak meeꞌ-penchāna kaath nganttamantamana? Ngan koyaman keꞌ thipang ngoonchin kaath nganttamantangana, puthaman keꞌ aak-ngeeyin, yaꞌa!” ");
INSERT INTO wim_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Nil Jesus.an thaw nungant, “Ngay wik kan-kanam thawang nungk. Nil paman keꞌwey puthaman meeꞌ-penchiy-a, ngak alantamana aꞌ puth Ngeen-Wiy Min God.antam alantaman-a, nil maꞌ God.antang keꞌ wuniy yaꞌa. ");
INSERT INTO wim_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Piipiy niiyantamangan wunpin niiyang, an nil-nil. Puth inan-a, niiy puthaman aak ngeeyin-a, an nil Ngeen-Wiy Min God.antaman ngangkangan ngoonchow niiyantang, aꞌ angman wun-wunow. ");
INSERT INTO wim_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Nint keꞌ meeꞌ ikāna, puth ngay nungkar wik inan waaꞌang, ‘Niiy puthaman aak-ngeeyān a!’ ");
INSERT INTO wim_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Nil wuntan wanttinakan wunpan-a, an nil wunpan. Niiy wuntan ngeeyaniy-a, puth niiy keꞌ thathaniy wanttinpalan kaꞌathaman wunpan, aꞌ puth wanttinak ngulan wunpow. Pam wanch weeꞌ-weeꞌanangan puthaman aak-ngeeyantan Ngeen-Wiy Min God.antam alantaman-a, inan keꞌ yimanangana niiy nunangan keꞌ thathin, yaꞌa. Niiy puth anangan ep thathin thanang woyan min God.antaman wak-wakantan ngul!” ");
INSERT INTO wim_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nil Nicodemus.an thaw, “In-ngul want-wanttak aa?” ");
INSERT INTO wim_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Nil puth Jesus.an thawant, “Nint puth pam piꞌana, teachera, Jews.antama! Nint puth wik inangan keꞌ thiichangan ey? ");
INSERT INTO wim_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ngay nungkar kan-kanaman wik thawanga. Wik nganan waaꞌ-waaꞌanan-a, an ngay meeꞌmiyang waaꞌ-waaꞌanan; ngan puth meeꞌ nganaman thathan. Puth pam yam weeꞌ ngangk minangaman wik ngeey-ngeeyiw nganttamana? Yaꞌa. ");
INSERT INTO wim_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ngay puth wik kanam waaꞌang niiyant yuk way min aak imanam thakan, niiy puth wik keꞌ ngeeyaniy ngayang, yaꞌa. Ngay wik inpal kenyan waaꞌing niiyantwey-a, niiy puth want-wanttak wik ngeeyin ngayanga? ");
INSERT INTO wim_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Pam wanch puth aak heavenakan keꞌam yippak matina, yaꞌa; nil pam thonam thonak epa, nil God.angan kuch nunang pam wanchantan, nil ep ang kenyan wun-wun God.antang, puth nilam uk ngula aak iikanakan.” ");
INSERT INTO wim_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Keenkanaman-a, nil Moses.angan-a, yuk thuuk brassaman yump, aꞌ yuk thapangan wunpan, aꞌ kenyam ngulan waanchan aak pintalangan. Inan-a, keꞌ yimanangan ngul wunow: pam nil God.angan kuch nunang-a, than ngul yimanangan waanchayn nunang, ");
INSERT INTO wim_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","yipam than pam wanch weeꞌ-weeꞌanangan ngangk punch-aakaman theeꞌayn nungant-a, than ngangk aak umpuyaman ngul wunayn nungantang. ");
INSERT INTO wim_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Puth nil God.an kan-kanam kaangk wunan ngampar pam wanchant, an ngangk pal pekkuwam kaangk wunan ngampar, keꞌ-paal nilan nhengk nungantam kaaꞌ-thonaman kuch nunang, than yipam weeꞌ-weeꞌanangan ngangk punch-aakamaniy theeꞌayn nungant-a, an than ngangk aak umpuyaman wun-wunayn nungantang, God.antang, nil keꞌ kuchiy thanang nungantam anpalan. ");
INSERT INTO wim_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Puth nil God.angan nhengk nungantam aak iikanakan kuchan yipam pam wanch kaaꞌ-piichanathow way thanttam anpalan, nil keꞌam kuch nunang yipam way waaꞌ-waaꞌow ngampangan, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Than pam wanch wiyangan kaangk keꞌ ngangk thanttaman punch-aakam theeꞌayn Jesus.antan. Nil puth God.an kaꞌathaman kan thaw thananiy keꞌ-ngul wunayn nungantanganiya, than puth ngangk punch-aakam keꞌam theeꞌin nhengk kaaꞌ-thonam nungantamakan. Puth thant wiy al-alantan ep yimanangan keꞌ thawow thant than puth ngangk punch-aakam theeꞌin nungant, Jesus.antan. ");
INSERT INTO wim_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Nil Jesus.an-a, keꞌ nganth piꞌan aak iikanakan wamp, puth pam wanch wiy anangan kaangk keꞌ nungantam, than kaangk keꞌ woyan nungantaman wakayn, yaꞌa, than kaangk woyan way thanttam anman wak-wakayn. Than ananganiy-a, keꞌ nganth keꞌanang iiy-iiyantan, keꞌ-paal nil God.angan pam wanch wayanang waaꞌan thanang. ");
INSERT INTO wim_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Than weeꞌ-weeꞌanangan way anman yump-yumpantan-a, than Jesus.an ngangk-wayangam kal-kalantan nunang, than kaangk keꞌ thinthaman wampayn nungant, yaꞌa, puth than God.antam winynyang moꞌ-moꞌantan, than ngaantam-ngeeyantan puth God.ang ngul wak thanang. ");
INSERT INTO wim_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Puth than weeꞌ-weeꞌanangan woyan minan wak-wakantan-a, an ep nganth piꞌan Jesus.antam aakanakan wampantan, pam wanch wiy al-alangan yipam thathayn thanang, God.angan maꞌ-aath-aathan thanang minam iiyanakan. ");
INSERT INTO wim_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Anpalan-a, nil Jesus-a, ngurp nungantam anangana than karpam iiyin aak namp Judea aakanakan, aꞌ angman wunin thanttang. Nil Jesus.angan angman kuchek ngakang kuungk-kuungk thanang, pam wanch wiy anangan. ");
INSERT INTO wim_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Aꞌ nil John.angan-a, aak namp Aenon angan kuchek ngakang kuungk-kuungk thanang, aak Salim thinth, an puth ngak piꞌan aak anganiya. Pam wanch anangan wamp-wampin nungant John.ant, aꞌ nil kuchek ngakang kuungk-kuungk thanang. ");
INSERT INTO wim_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Than puth John.an yippak keꞌam thenchin nunang, aak jailanganiy.) ");
INSERT INTO wim_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Aꞌ than pam puungk wiy ngurp John.antam anangan, puth-a, pam Jew thonam, than wik thaw-thawin thanttakam, than nath weeꞌantan iiyayn kuchek kuungkanakana, nath John.antana, nath yaꞌa, nath Jesus.antana. ");
INSERT INTO wim_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Aꞌ than ngurp John.antam anangan John.ant ngul iiyin, thawin nungant, “Ayyang, Teacher-ang! Nint pam anan kan ngaantam-ngeeyangan nunang ey? Pam anman kaꞌathaman nungkarangan iiy woꞌuwayn Jordan River angana, pam anman nintan waaꞌ-waaꞌan ngant — nil an-ngula, kuchek ngakang kuungk-kuungkan thanang, than pam wanch yot ngul wamp-wampantan nunganta!” ");
INSERT INTO wim_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Puth John.an thaw thant, “Nil God.angwey keꞌan maꞌ-aathiy nunang-a, pam wanch anangan keꞌ wampiythan nungant, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Niiy puth ngayang meeꞌmiy ngay kaꞌathaman wik waaꞌang niiyant, ‘Ngay pam anan yaꞌa God.angan keenkanaman kaaꞌngak kuchowan ngampara. Nil God.angan keenk kuch ngayang niiyant, ngay yipam waaꞌāng nunang niiyantana.’ ");
INSERT INTO wim_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Wik kath kan inan ngeeyāna pam kompantam-a, wanch komanantaman pulan ngentuwpul. Nil pam alangan wanchan maayan-a, an wanch nungantakam ngul piꞌan. Puth kampan pam alantaman-a, thananiy-a, ngangk min paththam ngul wunin puth nil pam alangan wanchan maayan. In keꞌ yimanangan wunan ngathar. Ngay ngangk min paththam weemang nungantam Jesus.antaman puth pam wanch yot wamp-wampantan nungant. Mak monkan-wak-wakayn nunang, ngayangan yaꞌa, ");
INSERT INTO wim_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","puth nil Jesus.an ep pam piꞌana, ngay puth pam piꞌan yaꞌa.” ");
INSERT INTO wim_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Nil aak inpal kenyan uk-a, an nil pam moom wuut piꞌan paththam, keꞌ pam wiy yimanangan yaꞌ. Ngamp aak inpalman-a, ep aak ngampar inmana, puth ngamp wik thakan thawanamp aak imanaman. Nil anpal kenyan uk-a, an ep pam piꞌan paththam, keꞌ pam wiy yimanangan yaꞌa. ");
INSERT INTO wim_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Nil wikan waaꞌan, puth nilam meeꞌ nungantamangan thath, aꞌ puth kon nungantamangan ngeey. Puth pam wanch in yaꞌ-yaꞌam kaangk ngangk minangaman wik ngeeyayn nungantaman. ");
INSERT INTO wim_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Than weeꞌ-weeꞌanangan kaangk ngangk minangaman wik ngeeyayn nungantaman-a, than ep meenathantan ngampar nil God.an wik kan-kanaman thaw-thawan. ");
INSERT INTO wim_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Nil pam anan God.angan kuch nunang-a, Jesus.an-a, nil wik God.antaman waaꞌ-waaꞌan thant, nil puth God.angan Ngeen-Wiy Min nungantaman kuch nungant, yipam ngangkang angman wun-wunow nungantang. ");
INSERT INTO wim_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Nil piip nungantaman-a, kaangk wunan nhengk nungantamak Jesus.antan, aꞌ nil thaw nungant moom piꞌanan iiyow aak umyompanamakan. ");
INSERT INTO wim_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Than weeꞌ-weeꞌanangan nhengk God.antamak ngangk punch-aakaman theeꞌayn nungant-a, than ep ngangk aak umpuyam wunayn nungantang. Puth than weeꞌ-weeꞌanangan kaangk keꞌan wik ngeeeyayn nungantaman-a, than ngangk aak umpuyam keꞌ wunayn aak nungantangan, puth God.angan ngangk kul piꞌ-piꞌow thant ngulakaman. ");
INSERT INTO wim_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Than pam Pharisees al-alangan-a, wik thooꞌ ngeeyin pulantam, Jesus-a, John pulantamana, than pam wanch yotang ngul monkan-wakin nunang, Jesus.an, aꞌ nil ngakang kuchek kuungk-kuungk thanang, puth John.an-a, koꞌalamang thonakam monkan-wakin nunang, aꞌ nil koꞌalam anangaman kuchek ngakangan kuungk-kuungk thanang. ");
INSERT INTO wim_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Puth nil Jesus.angan yaꞌa, keꞌam ngakangan kuchek kuungk-kuungk thanang. Ngurp nungantam al-alangan ep kuungk-kuungkin thananga. ");
INSERT INTO wim_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Aꞌ nil Jesus.angan wik ngeey thanang nunangan waaꞌ-waaꞌin-a, aak Judea.an want ngul aꞌ aak Galilee.ak ngul iiy, ");
INSERT INTO wim_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Samaria wakanang iiy-iiy. ");
INSERT INTO wim_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Nil aak Samaria.ang ngulan wamp-a, nil town manyang wamp, aak namp Sychar, aak paddock thinth. Paddock inan-a, nil Jacob.angan keenkanaman want, nhengk nungantamak, Joseph.antan. ");
INSERT INTO wim_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Aak paddockangan-a, ngak pantam angman, nil Jacob.angan keenkanaman ngak pantam theeꞌ. Ngak pantam pek-pekaman ngak meeꞌ pich-pich. Nil Jesus.an-a, kinch keny ngak pantam aakanakan iiy. Nil kan-ngul kemp wir peey, puth aak kecham iiy-iiy. Aꞌ angman nyiin, ngak pantam thintha. ");
INSERT INTO wim_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Nil-nilam nyiin, puth ngurp nungantam anangan townak kan iiyin, may yipam piiyayn thanttakam. Anpalana, wanch thonam ngul wamp ngakak, nil aak Samaria punchana. Aꞌ nil Jesus.an thaw ngul nungant, “Ayyang, nint ngak ngath theeꞌāna!” ");
INSERT INTO wim_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Nil puth wanch ngulan thawant, “In nint pam Jew inan ngakak thaw-thawangan ngath ey? Ngay puth aak Samaria punchana!” (Puth than Jews al-alangan-a, yuk way min cups thakan thanttakam anman piꞌ-piꞌin, ngakak thakaniy; than Samaria punchan ananganiya than-than, way min thanttakam piꞌ-piꞌin. Than puth thaaꞌ karp keꞌ mungk-mungkin yaꞌa.) ");
INSERT INTO wim_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Nil Jesus.an thawant wanch alantan, “Nint keꞌam thiichangan yuk way minan nil ngeen nathan God.angan kaangk theeꞌow nungk, yaꞌa! Aꞌ nint ngayang keꞌam thiichangan nil God.angan kuch ngayang, yaꞌa. Nint meeꞌmiywey-a, nint ngathar ngakakwey thawina, aꞌ ngayan nungk ngak anan theeꞌing, ngak murkanim anmanan meeꞌ pich-pichan.” ");
INSERT INTO wim_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Nil wanchan ngul thawant, “Ayyang, nint puth bucket keꞌanang a! Ngak pantam inana, pek kech a! Nint ngak wanttinpal uwān a? ngak murkanim anman meeꞌ pich-pichana? ");
INSERT INTO wim_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Keenkanaman-a, nil wuut mangk ngamparam alangan-a, Jacob.angan-a, ngak inman mungk-mungk, ngak pantam inpalman, nil-a, nhengk nungantam al-alangan aꞌ minh bullocks nungantam al-alangan. Ngul-a, nil ngak pantam inaniy ngant ngul want, Jacob.angan. Nint ngaantam-ngeeyangan nungkarakam keꞌ pam piꞌan iiy-iiyangan ey? Nil Jacob.an yaꞌa, pam many ey?” ");
INSERT INTO wim_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Nil Jesus.an thawant, “Than weeꞌ-weeꞌanangan ngak inan mungkayn-a, ngak pantam inpalman-a, ngul-ngulan-a, than putham ngul ngakam uthamayn. ");
INSERT INTO wim_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Puth than weeꞌ-weeꞌanangan ngak ngatharaman mungkayn ngayan theeꞌāng thant-a, than puth ngakam keꞌ uthamayn yaꞌa. Ngak ngayan theeꞌāng thant-a, keꞌ ngak bul-bul yimanangan pich-pichan, ngak meeꞌ murkanim anman, than yipam ngangk aak umpuyam wunayn God.antang.” ");
INSERT INTO wim_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Nil wanchan thawant, Jesus.antan, “Ayyang, nint puth ngak nanan theeꞌānar, ngay yipam ngakaman keꞌ-ngul uthamāng, aꞌ keꞌ-ngul yipmam wampāng iikanakan ngakakaniya.” ");
INSERT INTO wim_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Nil Jesus.an thaw ngul wanch alantan, “Nint kan iiyān pam thum nungkaramant thawān pal wampowa. Aꞌ nip ingan wampow ngathara.” ");
INSERT INTO wim_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Nil wanchan thawant, “Ngay pam thum keꞌanang a!” Nil Jesus.an puth thaw wanch alantan, “Eeꞌ, kan-kanama. ");
INSERT INTO wim_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Nint puth kaꞌathaman pam koꞌalam maayana, anpalan-a, nint pam thonantang wun-wunangan, nint puth keꞌam maayan nunang, nil pam nungk yaꞌ, nint yaan wun-wunangan nungantang. Nint puth kan-kanam thaw-thawangan ngath nint pam thum keꞌanangana.” ");
INSERT INTO wim_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Nil wanchan thawant, Jesus.antan, “Ngay kan ngaantam-ngeeyang nintang pam piꞌan God.antama, propheta, nint puth kan thiichan ngayang. ");
INSERT INTO wim_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Than wuut mangk ngatharaman aak in punchana, Samaria.aman aak yoyk ingman matin, yipam God.antan meeꞌ-wuthanamayn. Puth niiy Jews il-ilangana aak Jerusalem.an waaꞌaniy aak min paththaman meeꞌ-wuthanamanak God.antana.” ");
INSERT INTO wim_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Nil Jesus.an thawant, wanch alantan, “Ayyang, kan in ngeeya! Ngay kan-kanam thawāng nungka. Aakan kan-kanang ngul wampana, pam wanch anangan aak yoyk ingman keꞌ-ngul meeꞌ-wuth-wuthanamayn, piip God.antan, yaꞌ-ngula, aꞌ puth than keꞌ-ngul meeꞌ-wuth-wuthanamayn nungant, aak angan Jerusalem.angan, an yaꞌ-ngul. ");
INSERT INTO wim_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Niiy pam wanch aak Samaria.aman-a, niiy ep meeꞌ-wuth-wuthanamaniy God.ant, puth niiy keꞌam thiichan nunang, God.an, yaꞌa; puth ngan Jews il-ilangan ep thiichan nunang, nganan meeꞌ-wuth-wuthanamanan nungant. Puth pam nilan wamp pam wanch kaaꞌ-piichanathanakan thanang-a, nil aak Jews.am anpalan wamp. ");
INSERT INTO wim_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Aak inan kan-kanang wampana, than weeꞌ-weeꞌanangan kaangk minam meeꞌ-wuthanamayn nungant piip God.antan-a, than ngangkam meeꞌ-wuthanamayn nungant, thaaꞌaman yaꞌa. Nil piip God.angan kaangk thanang pam wanch anangan yimanangan meeꞌ-wuthanamayn nungant. Than in-inanganiy-a, nil piip God.angan kaangk thanang. ");
INSERT INTO wim_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Nil God.an nil-nil; nil puth man-yetham anman iiy-iiyan, nil puth kemp keꞌ pam wanchang yimanangan keꞌam kal-kalan, yaꞌa. Than weeꞌ-weeꞌanangan kaangk minam meeꞌ-wuthanamayn nungant piip God.antan-a, than ngangkam meeꞌ-wuthanamayn nungant, thaaꞌaman yaꞌa.” ");
INSERT INTO wim_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Nil wanchan thawant, Jesus.antan, “Ngay kan thiichang nil God.angan keenkanaman kaaꞌngak ngampang pam piꞌanan kuchow ngampar, than Christ.an waaꞌantan nunang. Nil wampowan ngampar-a, wik yot-yotam waaꞌow ngampar, maꞌmangkamana!” ");
INSERT INTO wim_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Nil Jesus.an puth thawant, wanch alantan, “Ngay pam inman nintan waaꞌ-waaꞌangana, ngay inman wik thaw-thawang nungkar.” ");
INSERT INTO wim_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Aꞌ than ngurp nungantam anangana kan-ngul wampin. Than thathin pulang-a, thaniy-a, thaaꞌam ikin, puth Jesus.an wanch alantan thaw-thaw. Than keꞌam thawin nungant wanch alantan, “Nint ngeenak wampan a?” Aꞌ Jesus.antan keꞌam thawin nungant, “Nint ngeenak thaw-thawangan wanch ilantana?” ");
INSERT INTO wim_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Aꞌ nil wanch alanganiy-a, jaran angam want, aꞌ kan-ngul iiy townak aꞌ pam wanch al-alantan pech thant, ");
INSERT INTO wim_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Niiyalang! Niiy kan ngatharang pal iiyān a! Niiy kan pam anan thathān nunang a! Nil nyiingk ngath waaꞌa yot ngayan way yump-yumpangan. Nil nath pam anan nil God.angan kaaꞌngakan kuchowan ngampara!” ");
INSERT INTO wim_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Aꞌ yotaniy pam wanch townaman-a, tul-thuth-thuthwin, aak-aakanakaman iiyin nungant, Jesus.ant. ");
INSERT INTO wim_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Than pam wanch anangan kan-kanangan wamp-wampin Jesus.ant-a, ngurp nungantam anangan thawin nungant Jesus.ant, “Ayyang, Teacher-ang, nint kan may mungk ee!” ");
INSERT INTO wim_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Puth nil Jesus.an thaw thant, “Ngay may thampa, may niiy keꞌan meeꞌmiy ngatharam.” ");
INSERT INTO wim_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ngurp nungantam al-alangan wik inangan ngeeyin-a, than thanttakam thaw-thawin, “May nungant yam weeꞌang wampath ee?” ");
INSERT INTO wim_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Nil puth Jesus.an thaw thant, ngurp nungantam al-alantan, “Ngay mak wik ngeeyāng nunang piip God.an, nilam puth kuchanya. Ngay mak minchathāng work nilan waaꞌar. Work inan-a, keꞌ ngay mayan mungk-mungkang yimanangan. Wik inan waaꞌ-waaꞌang thant-a, an ngay othamanga, keꞌ mayan mungk-mungkang. ");
INSERT INTO wim_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","38","“Niiy thathān a! Pam wanch anangan nanpalan iiyantan a! Niiy nath ngaantam-ngeeyin thanang than wik God.antaman kaangk keꞌ ngeeyayn. Puth yaꞌa! Than wik God.antaman kaangk ngeeyayn, than puth ngul ngangk theeꞌayn God.ant. “Niiyalang, kan niiy in ngeeyiy a! Ngay puth kan niiyant wik kath inan waaꞌāng may cornama. Niiy may cornan kan thathāna! May cornan kan-ngulan menchan weeman thuthanakana. Kaꞌathaman-a, pam wampin, may corn kaampanakan. Puth yimanang ngulan-a, pam wiy wampayn may corn thuthanakan. Than may corn kanan yal-yalmathayn-a, than al-alangan wukalan uw-uwayn, wagesan, aꞌ ngangk min ngul iiyayn. Wik kath inan may cornaman yimanangan wun. Pam wanch wiyang wik God.antam kanam waaꞌin thant, pam wanch al-alantan, puth thanan many-manyim ngaantam-ngeeyin nunang God.an. Ngul yimanangan-a, than kaangk putham wik minan ngeeyayn. Ngay puth niiyang kuchāng, niiy yipam waaꞌān thant wik God.antaman. Than wik ngeeyaynan-a, than ngul ngangk theeꞌayn God.ant. Anpalan-a, than ngangk aak umpuyam ngul wunayn, God.antang. Niiyan puth ngangk min ngul iiyān, pam wanch al-alantaman. Niiyan puth karpam ngul ngangk min iiy-iiyān, niiy-a, puth pam wanch anangan kaꞌathaman wik God.antaman waaꞌin thant. Niiy karpam ngangk min ngul iiy-iiyān. Niiy puth kaꞌathaman keꞌam waaꞌan thant, yaꞌa; than wiyang waaꞌin thant. Niiy work thanttaman minchathāna.” Nil Jesus.an yimanangan thaw thant. ");
INSERT INTO wim_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Nil wanchan kaꞌathaman koyam iiy townakan-a, than pam wanch wiyangan kan-kanam ngul ngaantam-ngeeyin nunang Jesus.aniy wik nunangan wanchan ngeeyina, “Nil ngath waaꞌar way yot ngayan yump-yumpang.” ");
INSERT INTO wim_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Aꞌ than kanan wampin nungant Jesus.antan-a, than thawin nungant, “Ayyang, nint nganttang ingam keꞌ wunin ey?” Puth nil Jesus.an-a, “Eeꞌ” thaw thant, aꞌ nil maꞌ-kucham angman wun thanttang. ");
INSERT INTO wim_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Aꞌ pam wanch yotangan kan-kanam ngul ngangk theeꞌin Jesus.ant, puth wik anpalan nilan thaaꞌ-aath-aath thanang, wik min God.antam anangan. ");
INSERT INTO wim_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Aꞌ than wanch alantan thawin ngul nungant, “Ngan ngangk kan theeꞌan nungant ngula, wik nungkaram anpalan thonakam yaꞌa, puth nganam ngulan wik nungantaman ngeeyan. Ngan kan ngaantam-ngeeyanan nunang nilan wamp ngampar yipam kaaꞌ-piichanathowan ngampang yotaman, aak umyompanaman.” ");
INSERT INTO wim_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Nil Jesus.an maꞌ-kucham kanan wun thanttang-a, aak Samaria angan-a, nil want thanang ngul, kan-ngul iiy, aak Galilee.ak. ");
INSERT INTO wim_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Puth nilam Jesus.an kaꞌathaman thaw, “Nil pam prophet aak nungantamangan wuniywey-a, pam wanch al-alangan aakan punchanang keꞌ ngaantam-ngeeyiythan nunangan keꞌ pam piꞌan yimanangana, yaꞌa.” ");
INSERT INTO wim_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Nil Jesus.an kanan wamp aak angan Galilee.angan-a, pam wanch yot anangan umang iiyin nungant, ngangk min wunin nungant. Puth than kaꞌathaman iiyin aak Jerusalem.akan, may piꞌanakan, Passover.an waaꞌantan, aꞌ angan kan thathin nunang work piꞌanan yump meeꞌ thanttangan. ");
INSERT INTO wim_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Aꞌ nil Jesus.an iiy aak many aakanakan, Cana.akan. Aak Cana.an aak angman Galilee.angan, aak nil angman yump ngakaman wine.akan thant. Nil pam piꞌan thonamana, angman wun, aak Cana thinth, aak namp Capernaum angan, nil kingantan work iiy-iiy. Puk wuut many nungantamaniy-a, way-wayam wun. ");
INSERT INTO wim_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Nil pam piꞌan alangan wik thooꞌan ngeey-a, Jesus.an nyiingk-nyiingkan wamp Galilee.akan aak Judea.aman-a, aꞌ nil umang iiy nungant ngul, Jesus.ant, aꞌ thawant, “Ayyang, nint keꞌ iiyin ey? Aak Capernaum.ak ey? Puth puk nhengk ngatharam way-wayam wunana, mul yip-yipam wunow. Nint keꞌ iiyin nungant ey? miyalathin nunang ey?” ");
INSERT INTO wim_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Nil puth Jesus.an thawant, “Niiywey work piꞌan min-miniy keꞌ thathinwey-a, meeꞌ niiyantanganwey-a, niiy puth keꞌ ngaantam-ngeeyin ngayang God.angan kuch nganyang, yaꞌa.” ");
INSERT INTO wim_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Nil puth pam piꞌanan thawant, Jesus alantan, “Ayyang, nint pal iiy ngatharanga! Puk nhengk ngatharaman ngul uthama, way-wayam puth wunan.” ");
INSERT INTO wim_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Nil Jesus.an thawant, “Yaa, nint kan iiy a! Puk nhengk nungkaram ngul miyalamow a!” Aꞌ nil pam alangan kan-kanam wik Jesus.antaman ngaantam-ngeeya, aꞌ iiy ngul. ");
INSERT INTO wim_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Nil iiy-iiy-aa, aꞌ pam workan iiy-iiyin nungant-a, umang wampin nunganta. Aꞌ than thawin nungant, pam piꞌan alantan, “Puk nhengk nungkaraman-a, kan miyalam ngul a!” ");
INSERT INTO wim_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Nil thaw thant, “Aak ngeenwey miyalam a?” Than puth thawin nungant, “Peetanamana, kinch kenyan-a, kemp karkanan wun-a, an yaꞌ-ngul want nunang, kan miyalam a!” ");
INSERT INTO wim_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Nil piip-kunchangan ngaantam-ngeey nungantakaman, “Yaa! Puth an-aniyangan peetanaman-a, kinch kenyana, nil Jesus.an thawar, ‘Puk nhengk nungkaraman ngul miyalamow a!’” Aꞌ nanpalan-a, pam piꞌan anman-a, nhengk nungantam-a, wanch thum nungantam-a, aꞌ puth kampan nungantam maꞌmangkam al-alangan ngangk ngul theeꞌin God.ant, min-minam ngaantam-ngeeyin nunangan. ");
INSERT INTO wim_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Nil Jesus.an kaꞌathaman wamp aak Galilee angan-a, nil work piꞌan yump thant. Nil putham ngulan wamp aak Judea anpalan-a, nil thonangan ngul yump, work piꞌan inana, puk manyan miyalath nunang. ");
INSERT INTO wim_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Anpalaniy-a, than Jews al-alangan may piꞌan yumpin, aak Jerusalem angana, aꞌ nil Jesus.an aak-aakanakan iiy. ");
INSERT INTO wim_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Aak angman, Jerusalem.angan-a, thaaꞌ gate wun, minh sheep anangan yipam ngoonchayn. Thaaꞌ gate thinthan-a, ngak many keꞌ pool yimanangan, angman wun tham, aꞌ verandahs five weentanam yumpin. Ngak inan-a, Jews al-alangan namp Bethzatha waaꞌin wik thanttamangan. ");
INSERT INTO wim_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Pam wanch yot thaaꞌ-wantanam wun-wunin, verandahs angman, pam wanch way anangan weech-weechan thanang. Wiy anangan-a, meeꞌ koꞌanch wunin; wiy anangan-a, kunp wunin; wiy anangan-a, makar yal-yalamin thant. ");
INSERT INTO wim_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","(Ngak kookam anmaniy-a, popam anman wun-wun; wiyiy-a, ep bul-bul-bul anman weentan. Ngeenama? Puth wiyaniy-a, ngaantiyongk God.antam ngakang ukan, aꞌ ngak weentathan. Ngakan bul-bulan weent-weentan-a, weeꞌ-nathan kaꞌathaman ngakangan ukow-a, an erkam miyal weenowa, keꞌ-ngul weechow nunang. Than pam wanch angman wun-wunin, than ngakakan kuup-kuupin, ngakan weent-weentowan-a, than yipam erkam ukayn aꞌ miyal ngul weemayn.) ");
INSERT INTO wim_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Pam thonam angmana, nathpalman weech-weech nunang, kaap thirty-eightang want nunang. ");
INSERT INTO wim_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Aꞌ nil Jesus.angan thath nunang, angman wun-wun. Nil kan ngaantam-ngeey nunang pam alpanan nathpalman wun-wun, aꞌ nil thawant, “Ayyang! Nint kaangk kemp miyal ngul iiyān ey?” ");
INSERT INTO wim_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Aꞌ nil pam alpanan thawant, Jesus alantan, “Ayyang, ngak bul-bulan weent-weentan-a, an weeꞌangam ukathiy ngayang a? Ngay puth aak inan-a, pam wanch kampan keꞌanangweya. Ngay puth keꞌ ukanakan-a, ngakangan-a, ana yaꞌangam, than puth wiy ananganiy kaꞌatham ukantan.” ");
INSERT INTO wim_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Nil puth Jesus.an thaw nungant, “Ek a! Swag kan-ngul maayān a! Iiyān ngula!” ");
INSERT INTO wim_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","An erkam paththam ek, pamaniy, swag nungantaman maay, aꞌ kan-ngul iiy. Aak ananiy-a, Saturday.angan minam yump nunang, Jesus.anganiy, ");
INSERT INTO wim_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Aꞌ anpalana than moom Jews.antam al-alangan wakin nunang, pam nil Jesus.angan miyalath, aꞌ thawin nungant, “Ayyang, aak inan-a, aak ngench thayan Saturday.an. Aak ngampar yimanangan keꞌ wun, swag keꞌam kal-kalanamp Saturday.angan.” ");
INSERT INTO wim_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Nil puth paman thaw thant, “Pam anan nilan miyalath ngayang-a, nil yimanangan thawar, ‘Nint ek a! Swagan kan-ngul maayāna! Iiyān ngula!’” ");
INSERT INTO wim_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Aꞌ than pam piꞌan anangan engkin nungant, “Pam nil weeꞌa, yimanangan thaw nungkar a?” ");
INSERT INTO wim_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Puth nil pam alangan nampan keꞌam thiich nunang, Jesus.an, nilan puth minaman yumpan-a, than pam wanch yot thaaꞌ-wantanaman angman than-thanin, nil puth Jesus.an-a, erkam appench thanttam aak amanamana. ");
INSERT INTO wim_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Anpalan-a, nil Jesus.angan aawuch ngench thayanangan uw nunang, pam nilan minam yumpan, aꞌ thawant, “Ayyang, in ngeey a! Nint kan-ngul miyal ngula! Way nintan keenkan yump-yumpan-a, too ngul wantān a! Way keꞌ-ngul yumpān a! Nint keꞌwey wayan wantin-a, an puy-puyam ngul weechow nintang, way-wayam ngul wunan.” ");
INSERT INTO wim_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Aꞌ nil pam anman-a, aawuch ngench thayanan want ngul, aꞌ Jews al-alantan waaꞌ, “An nilama, Jesus.ang ngayang miyalatha.” ");
INSERT INTO wim_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Anpalan-a, than Jews al-alangan ngangk kul piꞌ-piꞌin nungant, Jesus.ant, puth nil aak ngench thayanangan paman miyalath nunang. ");
INSERT INTO wim_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Nil Jesus.an puth thaw thant, “Piip ngatharaman nil puth work anman iiy-iiyan, murkanim, aꞌ ngay yimanangan work anman iiy-iiyāng.” ");
INSERT INTO wim_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Than pam al-alangan wik inan ngeeyin-a, thanan ngangk kul puy-puyam wampin nungant Jesus.ant, keꞌ mulathiythan nunang. Ngeenama? Than puth thawin nil wik thayanan keꞌam piꞌ-piꞌ aak Saturday anpalmana. Thon inana, nil Jesus.angan puth God.an piip nungantaman waaꞌ nunang, nanpalan than ngaantam-ngeeyin nil waaꞌan nungamang keꞌ God.ang pul karp anman. ");
INSERT INTO wim_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Nil Jesus puth thaw thant, “Ngay kan-kanam thawang niiyant: ngay piip ngatharaman thathangan nunang work nilan yump-yumpan, keꞌ-paal ngay yimanangan work yump-yumpang keꞌ nil anman yump-yumpan. Work ngayan yump-yumpangan-a, nil angman ngatharang, ngay-ngayaman keꞌ yumping, ngay moom ngatharakam yaꞌa. Nil piip ngatharamangan yump-yumpan-a, ngay nhengk nungantamangan-a, yimanang thamp yump-yumpang. ");
INSERT INTO wim_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Nil piip ngatharaman-a, kaangk wun ngathara, nilan meenathan ngathar work yot anangan nilan yump-yumpan. Ngul-ngulan-a, nil work wuut piꞌ-piꞌanam anangan ngul meenathow ngathar, ngay ngulan yipam yumpāng. Niiy puth ngul meeꞌ ikān a! work piꞌ-piꞌanam anangan thathāna. ");
INSERT INTO wim_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","“Wiyiy-a, nil Piip ngatharamangan pam wanch koyam mulaman ekathan, ngangkan koyam theeꞌan thant, yipam man-yethaman iiyayn. Ngayan yim-yimanangan pam wanch anangan man-yetham yumpāng thanang, wiy anangan ngayan kaangk man-yethaman yumpāng thanang. ");
INSERT INTO wim_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Piip ngatharamangan work inangan theeꞌar: ngay pam wanch umang thanathāng thanang, nil piip God.angan yaꞌa, nil work inangan ngathar waaꞌ ngay yipam work iiyāng. ");
INSERT INTO wim_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Nil piip God.angan puth ngeenak work inangan waaꞌara? Nil puth kaangk pam wanchangan pam piꞌanan ngaantam-ngeeyayn ngayang, keꞌ than nunang God yimanangan ngaantam-ngeeyantan pam piꞌanan. Than weeꞌ-weeꞌanangan keꞌan ngaantam-ngeeyantan ngayang ngay pam piꞌanan-a, yaa, than puth piip ngatharam thampan pam piꞌan keꞌam ngaantam-ngeeyantan nunang, nilan kuch ngayang. ");
INSERT INTO wim_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Ngay wik inangan kan-kanam thawang niiyant: than weeꞌ-weeꞌanangan wik ngatharaman ngeey-ngeeyantan-a, aꞌ ngangkangan piꞌ-piꞌantan nunang nilan kuch ngayang-a, ngayiya thanttang iiy-iiyānga, thanan puth-a, ngulakam wun-wunayn ngatharang, ngay keꞌ kuching thanang aak wayak. Puth than woyan anman wak-wakantan ngangk aak umpuyam wunanakan God.antang, woyan thon anan-a, mul wunanakan-a, an too ngul wantin. ");
INSERT INTO wim_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ngay in kan-kanam puth thawang niiyant: aak inan kan-kanang ngul wampan thant, pam wanch al-alantan woyan God.antaman keꞌaman wak-wakantan, than man awal ngatharaman nhengk God.antaman ngul ngeeyayn. Than wiyangan-a, min-minam ngul ngeeyayn, aꞌ piip ngatharamantangan God.antangan ngul wunayn ngulakaman. ");
INSERT INTO wim_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Nil piip ngatharam God.ana, aꞌ puth ngaya nhengk nungantamana ngan man-yetham iiy-iiyan aak nathpalman aꞌ ngan man-yetham ngulakam wun-wunān, pamang keꞌam yumpin nganang, yaꞌa. Aꞌ ngan ngangk theeꞌanan pam wanchak thanan yipam aak umpuyam wunayn ang kenyan. ");
INSERT INTO wim_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Piip ngatharamangan work inangan thamp theeꞌar iiyāng: ngay pam wanch umang ngul thanathāng thanang, aꞌ mep-mepāng thananga, ngay puth pam inman nil God.angan kuch ngayang. ");
INSERT INTO wim_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Niiy keꞌ meeꞌ ikāna, wik inpalan ngay nyiingkan thawangan niiyant, puth aakan ngul wampowa, than pam wanch mul anangan aak awarangan wuntan-a, than ngul man awal ngatharaman ngeeyayna. ");
INSERT INTO wim_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Aꞌ than ngul ekayn, aꞌ pentayn ngul, awar anpalan. Than wiy anangana than minaman iiy-iiyin-a, than ep ngangk aak umpuyangam wun-wunayn, God.antangan. Than wiy anangan wayan iiy-iiyin-a, pam wanch ananganiy-a, nil God.angan ngul kuchow thanang aak wayakan, kech yipam wunayn nungantaman. ");
INSERT INTO wim_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Ngay-ngayaman keꞌ work iiy-iiying aak ingana, yaꞌa, piip ngatharaman God.ana angman ngatharang. Ngay puth wik piip ngatharamantaman ngeey-ngeeyang aꞌ ngay anman yump-yumpang keꞌ nilaman wik thaw-thawan. Ngay pam wanch umangan thanathāng thanangan-a, an ngay minam thaw-thawang thant ngay puth ngay-ngayam keꞌam wik thaw-thawang, yaꞌa, ngay wik piip ngatharamantam ngeey-ngeeyanga. ");
INSERT INTO wim_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","32","Ngay meeꞌmiy ngay wanttinpalan wampang niiyant, puth ngay ngatharakaman waaꞌ-waaꞌingwey-a, an puth niiy keꞌ ngeeyin ngayang, yaꞌa; wik wiyangan waaꞌiythan ngayangan-a, niiy wik thanttaman-a, ep ngeeyin. Yaa, nil piip God.angan kan waaꞌan ngayang, ngay wanttinpalan wampangana, aꞌ ngay kan ngaantam-ngeeyangan nilan wik kan-kanaman waaꞌan ngayangan. ");
INSERT INTO wim_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","34","Niiy puth John.antan pam kan kuchan ngatharaman mepayn nunanga! Aꞌ nil John.angan-a, wik kan-kanaman waaꞌ-waaꞌ ngayangan niiyantana. Pam wiy al-alangan keꞌ waaꞌiythan ngayanga! Ngay puth meeꞌmiy ep ngay wanttinpalan wampangana. Ngay puth wik John.antaman mak kon-aathāng niiyang niiyan yipam wampān piip God.antan, nil yipam kaaꞌ-piichanathow niiyang, way niiyantam anpalan. ");
INSERT INTO wim_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","“Nil John.an-a, keꞌ nganth pench-penchana, park-parkan thampang. Niiyan-a, kaꞌathaman ngangk minangam monkan-wakan nunang wik ngeeyanakan, puth yaan manyama. ");
INSERT INTO wim_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Puth work nil John.an iiy-iiy-a, wik thakan waaꞌ-waaꞌ niiyant-a, an manyama, work ngayan iiy-iiyang-a, an thaꞌiy paththam. Puth ngayan work iiy-iiyang piip ngatharamantan nilan waaꞌar. Niiy work ngatharaman thath-thathaniy-a, an niiy ngul ngaantam-ngeeyān nil piip God.angan kuch ngayang aak iikanakan. ");
INSERT INTO wim_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Nil ngayang thampan waaꞌ-waaꞌan niiyant. Niiy man awal keꞌam ngeeyan nunanga, aꞌ kaaꞌwal keꞌaman thathan nunanga, ");
INSERT INTO wim_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","puth niiy wik nungantaman-a, ngangkangan keꞌam piꞌ-piꞌaniy yaꞌa! niiy nanpalan keꞌam ngaantam-ngeeyaniy pam ngay inman nilan kuch niiyantan. ");
INSERT INTO wim_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Niiy lat ngench thayanangan maꞌ-yotam thath-thathaniy a! Niiy ngaantam-ngeey-ngeeyaniy keꞌ lat ngench thayanangan thath-thathaniy-a, niiyan keꞌ man-yetham ngulakam iiyān ey? God.antangan ey? Puth yaꞌa! Niiyan keꞌ ngaantam-ngeeyaniy ey? Than ngayangan keenkanaman waaꞌ-waaꞌin lat ngench thayanangan a! ");
INSERT INTO wim_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Puth niiyan kaangk keꞌ wampān ngathara, niiy yipam ngulakaman wunān piip God.antangan. ");
INSERT INTO wim_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Ngay keꞌam ngaantam-ngeey-ngeeyangan work inangan iiy-iiyanga pam wanchangan yipam thaaꞌ-kuump-kuumpayn ngayang, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ngay kaniy ngaantam-ngeeyang niiyang, niiy puth keꞌan kaangk wunaniy nungant God.antan, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nil piip ngatharamangan kuch ngayang aak iikanakan, nilam thawar ngay iikanakan ukāng, niiy puth ngayang keꞌam ngangk minangaman uwaniy yaꞌa. Nil pam weeꞌ-nathan nil-nilaman wampiy-a, an niiy ep ey? erkam paththam umang wakin nunang ey? keꞌ kampan niiyantam yimanangana. Niiy puth nganyangan ep umang wakina, nil God.angan ngayang ep kuch. ");
INSERT INTO wim_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Niiy puth niiyantakaman ep thaaꞌ-kuumpwuniya. Niiy puth kaangk keꞌ nil God.angan thaaꞌ-kuumpow niiyang ey? nilan God thonam anman thonakama! Niiy wanttak thayanathwuniya niiy kaangk keꞌ God.an ngangkangan piꞌ-piꞌāna? ");
INSERT INTO wim_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Niiy keꞌ ngaantam-ngeeyāna yimanangan keꞌ ngay ngulan waaꞌāng niiyang piip ngatharamantana, an yaꞌa! Nil ep Moses.anganiy-a, ngul way waaꞌow niiyangan piip ngatharamantan. Nil Moses.an-a, pam anman niiyan ngaantam-ngeeyaniy nunang keꞌ nil ngulan kaaꞌ-piichanathow niiyang, puth yaꞌa. ");
INSERT INTO wim_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Niiy puth wik nungantam Moses.antaman kan-kanaman ngaantam-ngeeyinwey-a, niiyan puth ngayangan yimanangan min-minam ngaantam-ngeeyin a! puth yaꞌa! Nil puth Moses.angan-a, keenkan-a, nganyangan ump, lat ngench thayanangan waaꞌ-waaꞌ ngayangana. ");
INSERT INTO wim_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Puth niiyaniy-a, wik nungantaman-a, keꞌam wik minam ngaantam-ngeeyaniy, yaꞌa, keꞌ-paal niiy wik ngatharam yimanaman keꞌam min-minam ngaantam-ngeeyaniya, yaꞌ paththam.” ");
INSERT INTO wim_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","2","Anpalaniya, nil Jesus.angan aak anan want ngul. Aꞌ nil koyam ngul iiy, woꞌuwaynak, chukkunangan moꞌa, Lake Galilee.angan. Kookam ananiy-a, piꞌan weꞌar thamp. Kookam alantaniy-a, namp kuchama, wiyangiy-a, Tiberias waaꞌin. Than pam wanch thaaꞌ-wantanamang monkan-wakin nunang, Jesus.an, than puth kan thathin nunanganiy work piꞌanan yump-yump, pam wanch wiy anangan miyalath thanangana. ");
INSERT INTO wim_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","4","Aak may piꞌan mungkanakan thanttam Jews.antaman kan-kanang wamp-wampa, Passover.an waaꞌantan. Anpalan-a, nil Jesus-a, ngurp nungantam anangan yoykang matin, aꞌ than angman karpam nyiin-nyiinin. ");
INSERT INTO wim_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Nil Jesus.angan meeꞌ pal-puy thath, aꞌ pam wanch yot thaaꞌ-wantanaman thath thanang wamp-wampin nungant. Aꞌ nil Philip.ant engk, “Ayyang! Ngamp may wanttinpal piiyāmp a? ngamp yipam may aathāmp thanang, pam wanch yot inangan a?” ");
INSERT INTO wim_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Nil Jesus.an wik inangan thaw Philip.antan, nil yaan paath nunang, nil yipam ngeeyow Philip.an wanttakan thawow, nil puth Jesus.an ep meeꞌmiy nungantakam nil wanttakan yumpowa. ");
INSERT INTO wim_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Nil Philip.an thaw Jesus.ant, “Ayyang, nungkway ngamp wukal piꞌan theeꞌimp may aakanakan thant-a, keꞌ two hundred dollars yimanangan-a, an yaꞌangam, than may many anman mungkiythan a!” ");
INSERT INTO wim_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","9","Aꞌ nil ngurp Jesus.antam thonanganana Andrew-a, kuunch Simon Peter.antaman, nil thawant Jesus.ant, “Ayyang, nil puk wuut inan than-than, may buns manyiy five piꞌ-piꞌan aꞌ puth minh ngaꞌ kucham thamp. Puth an yaꞌ, may many thant, an yotantakam puth yaꞌa. Puth wanttak mayan yaarkathimp thant a? maꞌmangkam al-alantan a?” ");
INSERT INTO wim_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Puth nil Jesus.an thaw thant, ngurp nungantam al-alantan, “Niiy thawān thant aakang nyiinayn.” Aak anana wakathiya. Aꞌ than pam wanch yot anangan aakang nyiinin ngul, an puth pam wanch thaaꞌ-wantanam, five thousand anangan. ");
INSERT INTO wim_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Nil Jesus.angan-a, mayaniy-a, maꞌang maay, aꞌ meeꞌ-wuthanam God.ant, thankyou thaw nungant may-a, minh aakanakan, aꞌ mayan kan-ngul theeꞌ-theeꞌ thant, pam wanch al-alantan aakangan nyiin-nyiinin. Aꞌ nil minh ngaꞌan thamp theeꞌ-theeꞌ thant, an than kan-kanam may-a, minhan mungk-mungkin ngul. ");
INSERT INTO wim_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Than yot anangan thip oth kanan weemin-a, nil Jesus.an thaw thant, ngurp nungantam al-alantan, “May nhanth anangan yalmathān a! Keꞌ wantāmp aakanganiya!” ");
INSERT INTO wim_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Aꞌ than ngurp nungantam al-alangan-a, may nhanth anangan yal-yalmathin, aꞌ yuk basketang wunp-wunpina. May buns nhanth al-alangan baskets twelve thaaꞌ mul maay, than pam wanchangan wantin, keꞌaman mungkin. ");
INSERT INTO wim_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Than pam wanch al-alangan thathin-a, work wuut piꞌanan nil Jesus.angan yump-a, than thawin thanttakam, “Eeꞌa, in kan-kanama, nil pam piꞌan God.antam, nil pam prophet anana thanan waaꞌin nunang nil palan wampow aak iikanakan.” ");
INSERT INTO wim_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Nil Jesus.angan kanam thiich thanang thanan keꞌ angman mamiythan nunang, thaachiythan nunang kingan iiyiy thant. Keꞌ-paal nil-nilam ngulan iiy aak yoykakan. ");
INSERT INTO wim_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","17","Aak ngaaꞌ kan-ngulan weem-a, ngurp nungantam anangan pek ukin, kookamak, chukkun thanttamang ngul peyin, aꞌ woꞌuwayn ngul ench-enchin, aak Capernaum aakanakan. Ngaaꞌ kanam ngulan chint-a, puth nil Jesus.an keꞌam yippak wamp thant, ");
INSERT INTO wim_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","19","aꞌ wunt piꞌan ngul wunp-wunp, an puth ngak yeelalan ek-ek. Than ngurp nungantam anangan yaam ench-enchin chukkun thanttamangan, aꞌ than Jesus.an thathin nunang, ngak kenyangkan iiy-iiy um thant, chukkun thanttam aakanakan. Than thathin nunangan-a, than ngangk ikin, aꞌ winynyang moꞌin nungantam. ");
INSERT INTO wim_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Puth nil Jesus.an thaw thant, “Niiy keꞌ winynyang moꞌān a! In ngayam wampang niiyant a!” ");
INSERT INTO wim_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Than wikan ngeeyin nunang-a, than keꞌ-ngul winynyang moꞌin, puth ngangk minang thawin nungant nil chukkunangan thaaꞌ peyow. Nil puth Jesus.an-a, chukkunang peya, aꞌ kan-ngul nyiin. Aꞌ yaam keꞌanam-a, than aakan erkam uwin, aak Capernaum.an. ");
INSERT INTO wim_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Than pam wanch yotam anangan keꞌ iiyin woꞌuwaynakan, than aak angman paanthin, nil Jesus.an thankyou thaw God.ant may aakanakan, aꞌ puth mayan mungkin. Than pam wanch al-alangan kan ngaantam-ngeeyin than ngurp nungantam anangan kanan iiyin chukkun thanttamangan, puth nil Jesus.an keꞌam iiy thanttang. Ngaaꞌ thonaniy-a, than pam wanch al-alangan chukkun thonam thonakam thathin thompanganiy. ");
INSERT INTO wim_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Anpalan-a, than chukkun wiy anangan aak Tiberias amanaman wampin aak thomp thanttang thinthan. ");
INSERT INTO wim_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Than puth Jesus-a, ngurp nungantam weeꞌanang keꞌam thathin thanang, than pam wanch anangan puth chukkun al-alangan peyin, aꞌ Capernaum.ak iiyin, Jesus.ant wenk-wenkin. ");
INSERT INTO wim_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Anpalan-a, than uwin nunang ngul, wonk woꞌuwayna, aꞌ than thawin nungant, “Ayyang, Teacher-ang! Nint aak iikanakan aak ngeen wampana?” ");
INSERT INTO wim_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Nil Jesus.an thaw thant, “Ngay wik inan kan-kanam thaw-thawang niiyant: niiy ngathar wenkaniy, puth niiy may breadan mungkan thip oth ngulan iiyana, nanpalan. Niiy keꞌam ngaantam-ngeeyaniy ngayang puth nil God.angan thayanan yump ngayang work piꞌan anan yumpānga! ");
INSERT INTO wim_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Niiy mayakan work thonakam keꞌ iiy-iiyāna, may ngampan mungkanamp puth erkam kathaman, yaaman keꞌ min wunow, yaꞌa. Niiy puth work ep iiyāna, mayan yipam uwān ngangk niiyantamakan. May anan-a, ngay ngul theeꞌāng niiyant, ngay puth pam anman nil God.angan kuch, may ananiy theeꞌāng niiyant niiy yipam ngangk aak umpuyangaman wunāna God.antangan. Ngay may bread anan ep theeꞌing niiyant puth nil God.angan work inan theeꞌar.” ");
INSERT INTO wim_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Aꞌ thanan engkin nungant, Jesus.antan, “Ngan puth wanttak yumpān ee? ngan yipam work nungant God.antan iiyān a?” ");
INSERT INTO wim_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Nil Jesus.an thaw thant, “Nil God.angan kaangk thathow niiyang niiy work inan iiyāna: niiy ngangkang piꞌ-piꞌān nunang, pam anman nil God.angan kuch nunang.” ");
INSERT INTO wim_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Than thawin nungant, “Nint work piꞌan ngeen yumpāna? ngan yipam thathāna, aꞌ ngaantam-ngeeyān nintangan nint kan-kanama puk nhengk God.antaman. Nint ngeen ngul yumpān ngant a? ");
INSERT INTO wim_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Wuut mangk nganttam al-alangan keenkanaman-a, may manna anangan mungkin aak pintalang angan keꞌ anman lat ngench thayanangan waaꞌan, ‘Nil may breadan aak inpal kenyan theeꞌ thant mungkanakan.’” ");
INSERT INTO wim_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Nil Jesus.an thaw thant, “Ngay wik inan kan-kanam thawang niiyant: may nil Moses.angan theeꞌ niiyant-a, an may manna anmana: puth nil piip ngatharamangan-a, may bread thonangan theeꞌow niiyanta, inpal kenya, may inaniy-a, nil-nil, may min-minam paththam, may an min niiyant ngangk niiyantamakana. ");
INSERT INTO wim_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Nil God.angan puth pam inpal keny kuch nunang, pam inman keꞌ may bread min-minam paththam niiyanta; ngamp yipam ngangk minangam wunāmp ngulakama, God.antanga.” ");
INSERT INTO wim_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Thanan thawin nungant, “Ayyang, moom-ang, may bread anan-a, ngaaꞌ thon-thonangan theeꞌ-theeꞌān ngant a!” ");
INSERT INTO wim_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Nil Jesus.an thaw thant, “Pam ngay inmana keꞌ may bread min anmana, ngay nyiingkan waaꞌ-waaꞌang niiyant: ngayana keꞌ may bread niiyantan, ngangk aak umpuyangam wun-wunanakana, piip God.antangan. Nil weeꞌan wampow ngathar-a, ngangkangan piꞌ-piꞌow ngayang murkanim aak umpuyangaman-a, an nil ngangk min ngulakam iiy-iiyowa, ngangkam nyiinow ngul. ");
INSERT INTO wim_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ngay kaꞌathangaman kan puth waaꞌangan niiyant, wik inangan: nungkway niiy ngayangan kanam thathan-a, niiy puth wik ngatharaman keꞌ ngeey-ngeeyaniya, yaꞌ paththama. ");
INSERT INTO wim_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Nil piip ngatharamangan weeꞌ-weeꞌanangan maꞌ ngatharangan want thanang-a, than ngul wampayn ngathar. Nil weeꞌan wampow ngathar-a, ngay keꞌ kenthāng nunang, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ngay puth inpal keny ukang aak iikanakana, yipam work iiyāng keꞌ nilaman piip ngatharamangan waaꞌar, nilan naakanakan kuchanya, ngay puth ngatharakaman keꞌ ngaantam-ngeeyānga, yaꞌa, ngay puth kaangk piip ngatharaman ngangk min yumpāng nunanga. ");
INSERT INTO wim_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Nil thawar ngay minam piꞌāng thanang, keꞌ maꞌaman wayathāng thanang pam wanch nilan maꞌ ngatharangan want thanang, puth ngul-ngulaniy-a, aakan minchowan-a, ngay mulaman ngul ekathāng thanang. ");
INSERT INTO wim_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Puth nil piip ngatharamangan kaangk yimanangan thathow: than weeꞌ-weeꞌanangan nhengk God.antaman thathantan nunangan-a, putha ngangkangan piꞌ-piꞌantan nunangan-a, an than ngulakam wunayn nungantang, God.antangan; aꞌ ngulaniy-a, ngayaniya, mulaman ngul ekathāng thanang aak inan kan-ngulan minchow.” ");
INSERT INTO wim_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Anpalaniy-a, than Jews ananganiy-a, wik manya thuuchin nunangan waaꞌ-waaꞌin, puth nilan wik yimanangan thaw, “Ngay keꞌ may bread yimanangan inpal kenyan ukang niiyant.” ");
INSERT INTO wim_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Than yotan puth thawin, “Nil pam inan Jesus a! puk nhengk Joseph.antama! Ngamp yotam puth meeꞌmiy kaath piip nungantam anangan pula! Nil puth wanttak thawan ee! nil inpal kenyan uk a!” ");
INSERT INTO wim_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Nil Jesus.an thaw thant, “Niiy ngul ngeenak wik many thuuchaniy niiyantakamana? ");
INSERT INTO wim_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nil piip ngatharamangan keꞌwey thaaꞌ-palathiy thanang pam wanch anangan-a, an than keꞌ wampiythan ngathar, yaꞌa. Than weeꞌ-weeꞌanangan wampiythan ngathar-a, an ep, ngay mulaman ngul ekathāng thanang, aak inan kanan minchowa. ");
INSERT INTO wim_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Pam prophetsangan lat ngench thayanangan wik inangan keenkanaman umpina, ‘God.angan ngul thaaꞌ-aathow thanang pam wanch maꞌmangkaman.’ Than weeꞌ-weeꞌanangan wik ngeeyantan nunang piip God.an-a, aꞌ wik nungantam kuchekangan piꞌ-piꞌantan-a, anangan ep wampantan ngathar. ");
INSERT INTO wim_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ngay keꞌ thawang niiyant keꞌ niiy God.an thathan nunang, yimanangan yaꞌa, niiy puth piip God.an keꞌ thathanam nunang yaꞌa. Nil pam thonam alangan ep thath nunang God.an, nil puth God.angan kuch nunang, aak inpal kenyan ukow niiyanta, aak iikanakan. ");
INSERT INTO wim_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Yaa, ngay in wik kan-kanam paththam waaꞌāng niiyant: than weeꞌ-weeꞌanangan ngangkangan piꞌ-piꞌantan ngayang-a, than aak umpuyangam wunayn God.antangan. ");
INSERT INTO wim_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ngay keꞌ may bread yimanangan niiyant, niiy yipam piip God.antangan ngulakam wunān. ");
INSERT INTO wim_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Wuut mangk niiyantam al-alangan-a, keenkanaman may manna.an mungk-mungkin, aak pintalangan. May manna alangan man-yetham piꞌ-piꞌ thanang, puth ngulakaman yaꞌa, puth than uth-uthamin ngula. ");
INSERT INTO wim_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ngay puth may bread thonanganan ep waaꞌ-waaꞌang niiyanta, may bread inpal kenyan uka, an nil-nil. May breadanwey mungkiythan-a, an than keꞌ uthamiythan, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ngay keꞌ may bread min yimanangan, inpal kenyan ukang niiyant, may min anman wun-wuna, keꞌ may nyiingkanam anman wun. Than weeꞌ-weeꞌanangan may inan mungkayn-a, murkanim anman man-yetham iiy-iiyayn. May bread inan-a, keꞌ kemp ngatharam ngay ngulan theeꞌāng niiyant; niiyantakam thonakam yaꞌa, puth pam wanch al-alantan thamp ngulan wunayn, than weeꞌ-weeꞌanangan ngangkang piꞌ-piꞌayn ngayang.” ");
INSERT INTO wim_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Anpalan-a, than Jews anangan-a, man kul wampin nungant than thaaꞌ ngul thay-thayanamin wik nungantaman ngeeyin Jesus.an thaw. Than thawin thanttakaman, “In puth want-wanttak e? nil kemp nungantaman theeꞌiy ngampar mungkanakan ey?” ");
INSERT INTO wim_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Nil Jesus.an thaw thant, “Ngay kan-kanam thawang niiyant: niiy keꞌan kemp nungantaman mungkinwey-a, pam alantaman God.angan kuch nunang-a, aꞌ niiy chaapar nungantam thamp keꞌan mungkinwey-a, an nil piip God.an ngangk niiyantamangan keꞌ wuniya, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Than weeꞌ-weeꞌanangan kemp ngatharaman mungkayn-a, aꞌ putha chaapar ngatharaman mungkayn-a, an than epa aak umpuyam wunayn nungantang, God.antangan, aꞌ ngul-ngulan-a, aak inan kan-ngulan minchow-a, ngay ngul ekathāng thanang, koyaman mulaman man-yetham ngul iiy-iiyayn. ");
INSERT INTO wim_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","In puth kan-kanama, kemp ngatharamaniy-a, keꞌ may bread yimanangan niiyant; puth chaapar ngatharamaniy-a, keꞌ ngak min yimanangan niiyant. ");
INSERT INTO wim_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Than weeꞌ-weeꞌanangan kemp ngatharamana puth chaapar ngatharaman mungkayn-a, than anangan ngatharangan wunayn, puth ngayiy-a, thanttang wunāng. ");
INSERT INTO wim_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Nil piip ngatharaman-a, man-yetham anman murkanim wun-wunan, nilan kuch ngayanga. Ngayiy puth-a, yim-yimanaman murkanim man-yetham anman wun-wunang nungantang, ngay puth pam inaniya nhengk nungantam, God.antam. Puth than weeꞌ-weeꞌanangan kemp aꞌ chaapar ngatharaman mungkayn-a, an ngay ngulakam man-yetham ngul piꞌ-piꞌāng thanang. ");
INSERT INTO wim_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ngay nyiingkan waaꞌang niiyant-a, may bread inaniy-a, inpal kenyan uk. An may bread nil-nila, keꞌ may manna yimanangan yaꞌa, than wuut mangk al-alangan keenkan mungk-mungkin. An puth ngangk aak umpuyangam keꞌam piꞌ-piꞌ thanang, yaꞌa, puth ngul-ngulan-a, uth-uthamin ngul. Than weeꞌ-weeꞌanangan may bread minan mungkayn ngatharaman-a, an than ep man-yetham aak umpuyangam wunayn.” ");
INSERT INTO wim_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Nil Jesus.angan wik inangan thaaꞌ-aath-aath thanangan-a, aakiy-a, ang churchang, aak angana, Capernaum.ang. ");
INSERT INTO wim_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Than ngurp nungantam yot al-alangan wik anangan ngeeyin-a, thanan-a, thawin thanttakaman, “Wik inangan thayan paththam ngampar, an ngamp keꞌ thiichimp wik anangan nil ngeenan waaꞌ-waaꞌan ngampara. Ngamp ngul ngeenak ngeeyāmp nunang a?” ");
INSERT INTO wim_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Nil puth Jesus.angan kanam thiich thanang ngurp nungantam anangan, than wik manyan thuuch-thuuchina, wik nungantam anpalana nilan thaw. Aꞌ nil puth thaw thant, “Wik inangan ngayan thawangan niiyant-a, niiy nanpalan ey? kaangk keꞌ-ngul monkan-wakān ngayang ey? ");
INSERT INTO wim_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Niiywey nath thathin nunang-a, pam anman nil God.angan kuch nunang-a, nilwey koyaman matiywey aak-aakanakaman aak nilan kaꞌathangaman wun-wun-a, niiy an-aniyangan ep ey? ngaantam-ngeeyin nunang min-min ngul ey? ");
INSERT INTO wim_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Wik inan thamp ngeeyāna: nil pam weeꞌ-nath woyan God.antaman wak-wakiywey-a, nil woyanangan nungantakam wunpiy ey? An yaꞌa! Nil Ngeen-Wiy Min God.antamangan ngangkangan ngoonchow nungantangan-a, an ep nil woyan God.antaman ngul wak-wakow. Ngay wik inangan waaꞌang niiyant nil Ngeen-Wiy Min God.antaman yipam ngangkang ngoonchow niiyantanga, aꞌ niiy yipam God.antangan ngulakam wun-wunān, ");
INSERT INTO wim_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","puth niiy puungk wiyangiy-a, keꞌam yippak ngaantam-ngeeyaniy ngayang a! yaꞌ paththam.” (Nil puth Jesus.angan-a, nathpalman thiich thanang, than weeꞌ-weeꞌanangan keꞌaman monkan-wak-wakantan nunang, aꞌ puth weeꞌangan theetathow nunangan pam way al-alantana.) ");
INSERT INTO wim_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Aꞌ nil puth Jesus.an thaw thant ngul, “Ngay nanpalan nyiingkaniy thawangan niiyant: pam nil-nilaman puth keꞌ wampiy ngathar. Nil piip ngatharamangan maꞌ-aath-aathiy nunangan wampow ngatharan-a, an nil ep wampow ngathar.” ");
INSERT INTO wim_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Anpalan-a, than wik inangan Jesus.an kanan ngeeyin nunang-a, than ngurp wiy al-alangan man-mangkam ngul theeꞌin nungant, keꞌ-ngul monkan-wakin nunang, yaꞌ-ngul. ");
INSERT INTO wim_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Aꞌ nil Jesus.an thaw thant, ngurp nungantamakan, pam twelve al-alantan. “Niiy il-ilangan thamp kaangk ngayang wantān yimanangan ey?” ");
INSERT INTO wim_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Nil Simon Peter.an thaw nungant, “Ayyang, Lord-ang, ngan puth weeꞌant ngul iiyān a? Nint puth wik min paththam thaaꞌ-aath-aathangan nganang, aak umpuyangam wun-wunanak nungantang God.antangan a! ");
INSERT INTO wim_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ngan puth kan-ngul thiichanan, ngaantam-ngeeyanan nintangan, nint pam anmana, pam min-minam inpal kenyan ukan God.antamana, nint way thak keꞌ yumpanam.” ");
INSERT INTO wim_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Nil Jesus.an thaw thant, “Ngay puth miꞌang niiyang ey! Niiy pam twelve inangan ey! Puth nil-niiyantiy-a, pam thonamaniy-a, oony way alantaman woyan wak-wakan a!” ");
INSERT INTO wim_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Nil Jesus.anganiy-a, pam Judas anman waaꞌ-waaꞌ nunang, pam nhengk Simon Iscariot.antaman. Ngulaniy-a, pam ilangaman-a, ngurp nungantam Judas.angana, Jesus.ana theetathowan ngul thant pam way al-alantan. ");
INSERT INTO wim_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Anpalaniy-a, nil Jesus.an aak Galilee wakanang iiy-iiy; puth nilan kaangk keꞌ iiy-iiyow aak Judea wakanangan puth than moom Jews.antam anangan-a, woyan thath-thathina, kuup-kuupin nungant, than yipam mulathayn nunanga. ");
INSERT INTO wim_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Aak may piꞌan mungkanakan thanttam Jews.antaman kan-kanang wamp-wampa, Tabernacles.an waaꞌantan. ");
INSERT INTO wim_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Kuunch nungantam Jesus.antam anangan-a, thawin nungant, “Ayyang, nint aak inan kan wantāna! Nint kan iiyāna aak Judea.aka ngurp nungkaram yotam al-alantan, than yipam thathayn work piꞌ-piꞌanam anangan nintan yump-yumpangan. ");
INSERT INTO wim_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Nil weeꞌ-nathan kaangk pam piꞌanan iiyow-a, nil work keꞌ maꞌ-mupam iiy-iiyow, yaꞌa. Nint nath kan-kanaman work piꞌ-piꞌanam yump-yumpangan-a, yaa, nint puth meeꞌ yotantangan work iiyāna, than yipam thathayn nintang, aꞌ wik thooꞌ weꞌ-weꞌarathayn nungkaramana.” ");
INSERT INTO wim_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","(Than puth kuunch nungantam anangan-a, wik inangan thawin nungant, than puth keꞌam kan-kanaman ngaantam-ngeeyin nunangan nil-thantan puth nhengk God.antaman.) ");
INSERT INTO wim_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Nil Jesus.an thaw thant, “Aak ngatharan keꞌam yippak wamp aak Judea.akan iiyāng. Kaangk niiywey iiyanakan-a, yaa, niiy iiyāna. ");
INSERT INTO wim_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Than puth pam wanchangan-a, niiyangan-a, keꞌ ngangk-wayangam kal-kalantana, yaꞌa, than ngayangan ep ngangk-wayangam kal-kalantan, ngeenam putha, inpalan, ngay meeꞌangam maꞌ-yotaman thaw-thawang thant thanan woyan way anman wak-wakantan. ");
INSERT INTO wim_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Niiy may piꞌanakan puy kan iiyān niiyama! Ngaywey keꞌ yippak iiying may piꞌanakana, puth aak ngatharan keꞌam yippak wampa.” ");
INSERT INTO wim_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Nil Jesus.an-a, wik inangan thaw thant, kuunch nungantamakan, aꞌ angman yippak wun, aak Galilee.angan. ");
INSERT INTO wim_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Than kuunch nungantam anangan kanan iiyin may piꞌanakan-a, nil Jesus.an-a, koy-koyyuw ngul iiy; nil meeꞌ engkanangan keꞌam iiy, yaꞌa, nil wuthanang anman iiy-iiy. ");
INSERT INTO wim_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Aak angman-a, may piꞌanan mungk-mungkin-a, than moom Jews.antam anangan-a, wenk-wenkin nungant, Jesus.antan. Than thawin thanttakaman, “Nil Jesus.an wanttin e?” ");
INSERT INTO wim_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Than yotam anangan thaaꞌ yaakangan engk-engkin thanttakaman nil Jesus.an wanttinana. Pam wiy anangan thawin, “An nil pam min a!” Puth wiy anangan thawina, “Appang! An yaꞌa! An nil pam waya! Nil woyan wayakan meeꞌ wich-wichan thananga!” ");
INSERT INTO wim_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Puth than kon yotantangan-a, keꞌam waaꞌin nunang, Jesus.an, puth than winynyang moꞌ-moꞌin thanttam, moom piꞌan Jews.antam al-alantaman. ");
INSERT INTO wim_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ngaaꞌ thonang ngulan-a, may piꞌan kanan mungk-mungkin-a, nil Jesus.ana wamp ngul, aawuch ngench thayan aakanakan, aꞌ kan-ngul thaaꞌ-aath-aath thanang. ");
INSERT INTO wim_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Aꞌ than moom Jews.antam anangan meeꞌam ikin, thawin thanttakaman, “Pam inan wanttak kuchek waap min-minam paththam a! Nil puth school piꞌanakan keꞌam iiy ey!” ");
INSERT INTO wim_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Nil Jesus.an thaw thant, “Wik anangan ngayan thaaꞌ-aath-aathangan niiyang-a, an wik ngatharam yaꞌa, ngay-ngayam keꞌam wik maay-maayang thanang, puth wik inangan-a, wik nungantam piip God.antaman nilan kuch ngayang. ");
INSERT INTO wim_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Than weeꞌ-weeꞌanangan kaangk kan-kanaman wik God.antaman ngeeyayn-a, an than ngul ngaantam-ngeeyayn wik inangan ngayan thaaꞌ-aath-aathang niiyanga, wik ngatharam puth yaꞌa, wik inangan-a, piip God.antaman waaꞌ-waaꞌang niiyant. ");
INSERT INTO wim_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Nil pam weeꞌangan wik nungantam anangan thaaꞌ-aath-aathow thanang-a, an nilana kaangk than yipam wiyangan thaaꞌ-kuumpayn nunang. Puth nil weeꞌangweya kaangka pam wanch wiyangana pam thonanganana thaaꞌ-kuumpayn-a, nilan kuch nunang ukow aak iikanakan-a, an nil pam koyꞌa aꞌ man-thonam iiyow, keꞌ wik uuyamow thakan, yaꞌa! ");
INSERT INTO wim_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Keenkanaman-a, nil wuut Moses.angan-a, wik thayan anangan nilan want niiyanta! Puth niiyan kaangk keꞌ ngeeyān wik thayan anangan a! Puth niiy ngeenam kaangk ngayangan mulathān e?” ");
INSERT INTO wim_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Than pam wanch yot anangan-a, man keeꞌanang thawin nungant, “An oony wayan ngangkang ngoonch nungkar a! An puth weeꞌang mulathow nintang e?” ");
INSERT INTO wim_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Nil Jesus.an thaw thant, “Ngay work piꞌan thonam yumpangan niiyanta, aak ngench thayan Saturday.angana, ngay puth pam alpan thonaman miyalathangana, aꞌ niiy yotam inangaman meeꞌam ikana. ");
INSERT INTO wim_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Puth niiy wik inangan ngaantam-ngeeyān a! Nil Moses.an keenkanaman thaw niiyant puk wuut many niiyantam anangan ngeen-wiy peꞌanan ump-umpān thanang. (Nil Moses.an kaꞌathangaman keꞌam thaw, yaꞌa, than wuut mangk ngamparamangan aak woyan inan wantin ngampara ngamp yipam yimanangan yumpāmpa.) Nungkway aak Saturday.an wunan-a, niiy ngeen-wiy peꞌan puk wuut manyiy anangan ump-umpaniy thananga. ");
INSERT INTO wim_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Niiy puth aak Saturday.angan ngeenak umpaniy thanang yimanangana? Yaa, wik Moses.antam anpalan ey? niiyan puth kaangk keꞌ wik nungantaman pipān ey? nilan ump lat ngench thayanangan, ‘Kinch eightangan wantow thanang wuut many anangan-a, an ep niiy ngeen-wiy peꞌanana umpān thanang.’ Niiy puth ngeenam man kulan wampaniy ngathar a? puth ngay pam alpanan miyalathangan nunang aak Saturday.angan ey? ");
INSERT INTO wim_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Niiy aak-yaꞌangana keꞌ waaꞌān thananga, pam wanch wiy anangan, kan niiy thathān thananga, ngaantam-ngeeyān tham than yaakaꞌ kan-kanam way yump-yumpantan, nath yaꞌ yaakaꞌ, min nath yump-yumpantan.” Nil Jesus.an-a, wik yimanangan thaw thant. ");
INSERT INTO wim_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Pam wanch wiy anangan-a, aak Jerusalem.angan wuntan-a, thawin, “Nil paman inan ey? thanan kaangk mulathayn nunang ey? ");
INSERT INTO wim_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","In thathān nunang a! Nil kon yotantangan wik thaw-thawan a! puth than keꞌ waaꞌantan nunang, yaꞌa! Than pam moom al-alangan-a, kan-ngul ngaantam-ngeeyantan nunang pam nil God.angan kaaꞌngak ngampara? ");
INSERT INTO wim_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","An yaꞌ yaakaꞌ, ngamp puth keꞌ thiichimpa nil pam anan aak want-wanttinpalan wampow. Puth pam inana, ngamp yotamang meeꞌmiy nunanga aak nilan wanttinpalan wamp.” ");
INSERT INTO wim_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Nil Jesus.angan wikan thaaꞌ-aath-aath thanang aawuch ngench thayanangan-a, nil wik othamayan thaw-thaw thant, “Niiy ngayangan kan-kanam thiichaniy ey? aꞌ puth niiy kan thamp thiichaniy ngay aak wanttinpalan wampangan ey? Puth ngay-ngayaman keꞌam wampangan aak iikanakan, yaꞌa. Nil ngayangan kuch-a, nil in-inman man-yetham iiy-iiyana, puth niiy pam wanch il-ilanganiya keꞌ meeꞌmiy nunang yaꞌ paththam. ");
INSERT INTO wim_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ngayiy-a, ep meeꞌmiy nunang, ngay puth nungantam anpalan wampangan, aꞌ puth nilaman kuch ngayang aak iikanakan.” ");
INSERT INTO wim_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Anpalan-a, than wiy al-alangan keꞌ mamiythan nunang-a, puth yaꞌa, ngeenam putha, nungantan aak keꞌam yippak wamp than pam way al-alangan mamaynan nunanga Jesus.an. ");
INSERT INTO wim_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Puth pam wanch wiy anangan-a, angmanan than-thanin-a, an ep min-minam ngaantam-ngeeyin nunang, Jesus.an, aꞌ thawin, “Pam nil anan wampowan God.angan kaaꞌngak-a, an nil ep work piꞌ-piꞌanam yump-yumpowa, puth nil pam ilangan yimanang thamp work piꞌ-piꞌanam yump-yumpana!” ");
INSERT INTO wim_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Than pam Pharisees al-alangan-a, pam wanch anangan ngeeyin thanang wik thaaꞌ yaakangan thaw-thawin, Jesus.an waaꞌ-waaꞌin nunanga, aꞌ than il-ilanganiya aꞌ pam piꞌan priests al-alangan thapangumpan anangan kuchin thanang Jesus.an yipam mamayn nunang. ");
INSERT INTO wim_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Nil Jesus.an thaw pam wanch yotamant, “Ngay inana manyam ngul wunāng niiyantanga, aꞌ ngay kan-ngul koyam iiyāng nungant, nilan kuch ngayanga. ");
INSERT INTO wim_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Niiy ngathar ngul wenk-wenkān, yaꞌangamana, niiy ngayangan keꞌ uwāna. Niiyan keꞌ iiyin aak-aakanakan ngayan iiyānga.” ");
INSERT INTO wim_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Than moom Jews al-alantaman thawin thanttakaman, “Nil pam inana, aak wanttinak ngul iiyow e? ngamp yipam keꞌ-ngul uwāmp nunangana? Aawuch piꞌan Greeks.antam aakanakaman iiyow ey? than Jews wiy anangan wun-wuntan ey? Puth nil pam wanch Greeks anangan thaaꞌ-aath-aathow thanang ngul ey? ");
INSERT INTO wim_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Nil puth yimanangan thawa, ‘Niiy ngathar ngul wenk-wenkān, yaꞌangamana, niiy ngayangan keꞌ uwāna, yaꞌa,’ aꞌ puth wik inangan tham thaw, ‘Niiyan keꞌ iiyin aak-aakanakan ngayan iiyānga.’ Puth nil wik inanganiy-a, wanttak thaw-thawan e?” ");
INSERT INTO wim_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","May piꞌanan kan-ngul minch-minch-a, aak aniy-a, piꞌan wun thanta. Aak an-aniyangan-a, nil Jesus.an-a, ek, aꞌ othamayan thaw thant, “Nil weeꞌ-nathan ngakam uthamow-a, nil pal wampow ngathar aꞌ ngay ngakan theeꞌāng nungant mungkanakan. ");
INSERT INTO wim_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Lat ngenchangan yimanangan waaꞌan, ‘Nil weeꞌangan nath ngangkangan piꞌ-piꞌow ngayangan-a, an keꞌ ngak anmana, ngak meeꞌan pich-pichan anpal pekan ngangk nungantam anpalman, ngakaniy aak umpuyam anman pich-pichow.’” ");
INSERT INTO wim_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","(Nil Jesus.an wik inangan thaw-a, nil Ngeen-Wiy Min God.antaman waaꞌ-waaꞌ, keꞌ ngak meeꞌ anman pich-pichan. An puth than weeꞌ-weeꞌanangan Jesus.an ngangkangan piꞌ-piꞌantan nunang-a, ngul-ngulana nil Ngeen-Wiy Min God.antaman ngangkang ngul ngoonchow thanttangan. Nil puth yimanangan keꞌam yippak ngangk thanttangan wun-wun, puth nil Jesus.an aak God.antamak keꞌam yippak koyam mat, meeꞌ yotantangan.) ");
INSERT INTO wim_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Than wik inangan kanan ngeeyin-a, than pam wanch wiy anangan thawin, “Nil pam inan prophet kan-kanam ey?” ");
INSERT INTO wim_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Puth than puungk wiy anangan thawin, “Nil pam inan God.angan kaaꞌngak kuchowanan ngampara!” Puth than puungk wiy anangan thawin, “Nil pam anan God.angan kaaꞌngak aak Galilee amanaman keꞌ wampiya, yaꞌa! ");
INSERT INTO wim_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Puth than lat ngench thayanangan keenkanaman umpin wik yimanangan, ‘Pam anan nil God.angan kaaꞌngak kuchowanan ngampar-a, wuut mangk nungantamaniya David a! Aꞌ aak Bethlehem.ang angman aak-ngeeyow, aak angman David.an wuut mangk nungantaman wun-wun.’” ");
INSERT INTO wim_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Anpalan-a, wik amanaman nil Jesus.an thaw-thaw-a, pam wanch puungk wiy ananganiy-a, kaangk paththam wunin nungant, than puungk wiy ananganiy-a, keꞌ kaangk wunin nungant, yaꞌa. ");
INSERT INTO wim_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Than wiy al-alangan-a, kaangk mamayn nunang, courtak kalayn nunang, puth yaꞌ anman, than keꞌam mamin nunang. ");
INSERT INTO wim_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Pam thapangumpan anangan-a, koyam iiyin pam piꞌan priests al-alantan, aꞌ putha pam Pharisees al-alantan. Thanan wikakan engkin thant, “Niiy puth ngeenam pam anan pal keꞌam kalan nunang ngant a?” ");
INSERT INTO wim_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Than pam thapangumpan anangan thawin, “Than pam wiyangana wik yimanangan keꞌam waaꞌ-waaꞌantan, nil pam ilangan ep wik min paththam waaꞌ-waaꞌan!” ");
INSERT INTO wim_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Than pam Pharisees anangan thawin thant, “An nil niiyang thamp muukamath ey? ");
INSERT INTO wim_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ngul pam piꞌ-piꞌanam ngamparam al-alangan wik nungantaman ngeey-ngeeyantan ey? Ngul ngan Pharisees il-ilangan ngeeyān nunang ey? An yaꞌa! Ngan keꞌ wik ngeeyin nungantaman a! ");
INSERT INTO wim_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Than puth pam wanch yot al-alangan wik thayan Moses.antamana keꞌam yippak thiichina anpalana nil God.angan ngul wayathow thananga!” ");
INSERT INTO wim_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Anpalan-a, nil Nicodemus.an wik thaw thant, nil Nicodemus inana, nil Pharisee thamp, nil Pharisees wiy al-alantangan iiy-iiy. Nil pam inman-a, keenkan ngutangan wamp nungant Jesus.antana. ");
INSERT INTO wim_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Nilan wik inangan thaw thant, “Wik thayan ngamparaman-a, yimanangan wunana. Ngamp pam aak-yaꞌangan keꞌ kuchāmp mulathanakana, ngamp kan kaꞌathangaman wik ngeeyāmp nunanga, aꞌ thathāmpa nil ngeen nathan way yump, Nil kan-kanam nathan way paththam yumpiy-a, an ep kuchāmp nunang mul wunanakana!” ");
INSERT INTO wim_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Aꞌ thanan puth thawin nungant, “Nip ngul Jesus.angan aak thonam amanaman wampuw ey? aak Galilee anpalan ey? Yaa, nint min-min thathāna, lat ngench thayanangana, aꞌ nint ngul ngaantam-ngeeyān pam thonam prophet aak Galilee.am keꞌaman wampa, yaꞌa.” ");
INSERT INTO wim_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Anpalaniy-a, pam wanch yot anangan koyam iiyin, aak thanttamak. Puth nil Jesus.aniy yoyk Olives aakanakan iiy. ");
INSERT INTO wim_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ngaaꞌ thonan-a, aak kanan pach-pacham-a, nil koyam ngul iiy aawuch ngench thayan aakanakan. Pam wanch thaaꞌ-wantanam woonch-woonchin nungant, aꞌ nil nyiin ngul, kan-ngul thaaꞌ-aath-aath thanang. ");
INSERT INTO wim_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Anpalaniy-a, than pam piꞌan wik thayanan thaaꞌ-aath-aathin-a, aꞌ puth Pharisees al-alangana wanch wampathin nunang Jesus.ant, wiyang puth kan thintham uwin nunang, maarichan keeꞌ-keeꞌ. Aꞌ than umang thanathin nunang, meeꞌ yotantangana. ");
INSERT INTO wim_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Aꞌ than pam piꞌan anangan thawin nungant, Jesus.ant, “Ayyang, Teacher-ang, wanch inana, wiyang thintham uwin nunang, maarichan keeꞌ-keeꞌa! ");
INSERT INTO wim_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Puth wik thayan ngampar yimanangana, Moses.angan want ngampar, ‘Nil wanch weeꞌan maarichan keeꞌow-a, ngamp mulakam piikāmp nunang, kunttowangan.’ Puth nint wanttak ngaantam-ngeeyangan a?” ");
INSERT INTO wim_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Than wik inangan yaan thawin nungant, Jesus.ant, nil yipam wanttakan thawow thant, than yipam way waaꞌayn nunang courtangana. Puth nil Jesus.an-a, thuch, aꞌ maꞌ pukangan aakang ump-ump. ");
INSERT INTO wim_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Puth thananiy-a, angman than-thanin, mep-mepin nunang anman, Jesus.an. Aꞌ nil Jesus.an ek ngul, aꞌ thaw thant, “Ayyang, niiy weeꞌ-weeꞌanangan way keꞌaman iiy-iiyan-a, niiy al-alangan kaꞌatham piikān nunang, kunttowangan.” ");
INSERT INTO wim_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Aꞌ nil Jesus.an putham thuch, aꞌ putham ngul ump aakangan. ");
INSERT INTO wim_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Than wik nungantaman ngeeyin-a, than kan-ngul thon-thonaman iiy-iiyin koyam aak thanttamakan. Kaꞌathamaniy-a, pam wuut manth-thayan anangan iiyin, aꞌ wiy anangan kul-kulam iiyin ngul. Than pokkapang wantin pulang Jesus-a, puth wanch anan nil ep angman than-than. ");
INSERT INTO wim_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Nil Jesus.an ek ngul, aꞌ nil thawant wanch alantan, “Ayyang, than pam anangan wanttinak ngul iiyin a? Than kaangk keꞌ-ngul nintang mulathayn ey? way nungkaram anpalan ey?” ");
INSERT INTO wim_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Nil puth wanchan thaw Jesus.antan, “Yaꞌa! Than nath ngul kanam iiyina!” Nil Jesus.an thawant, “In ngeey a! Ngay tham kaangk keꞌ thathāng nintang mulan wunān way nungkaram anpalan. Nint kan-ngul iiyān a! Aꞌ puthaman way keꞌ-ngul yump-yumpāna!” ");
INSERT INTO wim_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Anpalaniy-a, nil Jesus.an wik putham thaw thant, pam wanch yotam al-alantan, angman aawuch ngench thayanangan. Nilan yimanang thaw thant, “Ngay keꞌ nganth piꞌan yimanangan, pam wanch yotamak niiyantana. Than weeꞌ-weeꞌanangan monkan-wak-wakayn ngayang-a, an than aak ngaaꞌangan-a, keꞌ-ngul iiyayna, yaꞌa, puth ngayan keꞌ nganth piꞌanang yimanang woyan God.antaman meen-meenathang niiyant yotamanta.” ");
INSERT INTO wim_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Than Pharisees anangan-a, thawin nungant, “Ngan nungkaram wik keꞌ ngeeyina, nint puth nungkarakam thaaꞌ-kuump-kuumpangan keꞌ pam piꞌan yimanangana! Puth yaꞌa! Nint pam piꞌan yaꞌa!” ");
INSERT INTO wim_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Nil Jesus.aniy thaw thant, “Nungkway ngay ngatharakaman wik waaꞌing-a, an kan-kanam waaꞌ-waaꞌing ngathamangan, ngay puth ep meeꞌmiy, ngay wanttinpalan aak wampangana, puth-a, ngay aak wanttinak ngulan iiyānga. Niiy meeꞌmiy yaꞌa ngay aak wanttinpalan wampangan, putha, ngay aak wanttinak ngulan iiyānga. ");
INSERT INTO wim_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Niiy pam wanchantaman ngangk keꞌ thathina, yaꞌa; niiy puth aak-yaꞌangan waaꞌ-waaꞌaniy thanang. Ngayaniy-a, pam wanch keꞌ waaꞌ-waaꞌang thanang, yaꞌa! ");
INSERT INTO wim_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ngaywey pam wanchan waaꞌing thanang than want-wanttakan iiy-iiyantan-a, an ngay wik kan-kanam waaꞌing thanang puth ngay-ngayaman keꞌ waaꞌing thanang, yaꞌa; nil piip ngatharaman nilan kuch ngayanga inman ngatharang iiy-iiyan, ngay-ngayam keꞌam iiy-iiyang yaꞌa, ngan karpam anman iiy-iiyanan. ");
INSERT INTO wim_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","In ngeeyān a! Than keenkanaman-a, wik inangan umpin lat ngench thayan niiyantamangan: pam kuchamangana nath wik karpaman waaꞌiypul-a, pam thon alantaman wayan yump-a, an puth pul thathpula, niiy pulangana ngeeyān pulang wik kan-kanaman waaꞌpul. ");
INSERT INTO wim_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ngay puth ngatharakaman-a, waaꞌang ngay wanttinpalan wampangan, puth piip ngatharamangan-a, nilan kuchany-a, nil thampangan yimanangan waaꞌan ngayang, ngan kuchamangan karpam waaꞌ-waaꞌan.” ");
INSERT INTO wim_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Than thawin nungant, “Piip nungkaraman wanttin a?” Nil Jesus.an thaw thant, “Niiy puth ngayang keꞌ thiichaniya, yaꞌ anman, aꞌ puth piip ngatharaman yim-yimanangan niiy keꞌ thiichaniy nunang. Niiy ngayangwey thiichinan-a, yaa, niiy puth piip ngatharaman-a, yim-yimanang thamp thiichin nunanga.” ");
INSERT INTO wim_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Wik inanganiy-a, nil Jesus.angan aawuch ngench thayanangan thaaꞌ-aath-aath thanang, aak angana ik anangan wun-wunin, wukalana wunp-wunpina. Puth pam al-alangan keꞌam mamin nunang, yaꞌa, puth aak nungant keꞌam yippak wampant thanan mamayn nunangan. ");
INSERT INTO wim_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Anpalan-a, nil Jesus.an-a, putham ngul thaw thant, “Ngayan-a, aak inan kan-ngul wantānga; niiyaniy-a, puth ngul wenk-wenkān ngath, yaꞌangamana, niiy puth ngul uthamān way yump-yumpanang anman. Niiy puth keꞌ iiyin aak-aakanakan ngayan iiyāng, yaꞌa.” ");
INSERT INTO wim_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Than moom Jews.antam anangan thawin thanttakaman, “Nil ngeenak ngampar yimanangan thawa ngamp keꞌan iiyāmpa aak-aakanakan nilan iiyowa? Nilan wanttak ngaantam-ngeeyan nungamang, nil nath mulathow nungamang ey?” ");
INSERT INTO wim_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Nil Jesus.an thaw thant, “Niiyaniy-a, aak imanam wampan, ngayaniy-a, aak inpal kenyan ukang niiyant aak iikanakan: aak inaniy-a, aak niiyantam epa, puth aak ngatharam yaꞌa! ");
INSERT INTO wim_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ngayan keꞌ-paal thawang niiyant niiy ngul uthamāna way yump-yumpanangan, niiy God.antangan aak keꞌ wunin, yaꞌa. Ngay ngatharakam wik kanam waaꞌang niiyant, ngay inman nathpalman ngay man-yetham wunang. Niiy puth wik keꞌ ngeeyin ngayangwey-a, yaa, niiy ngul uthamān way yump-yumpanangan, niiy God.antangan keꞌ wunin yaꞌa.” ");
INSERT INTO wim_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Thanan puth thawin nungant, “Nint pam weeꞌe?” Nil Jesus.an thaw thant, “Ngay wik nathpalman kan waaꞌ-waaꞌang niiyant ngay ngeenakan wampangana. ");
INSERT INTO wim_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ina, wik yot yippak ngay kaangk waaꞌāng niiyanta, aꞌ puth wik meeꞌangam thawāng niiyant; puth yaꞌa, ngay puth wik God.antam anman waaꞌ-waaꞌang niiyant nilan kuch ngayanga, inpal kenyan aak iikanakan ukanga. Nil wik kan-kanam anman thaw-thawana. Ngay wik kon ngatharamangan ngeey-ngeeyang nunanga, aꞌ ngay wik anangaman waaꞌ-waaꞌang nungantam niiyantaniya, aak inganiya.” ");
INSERT INTO wim_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Thanan puth-a, kuchek thinhan, keꞌam yippak min-minana ngaantam-ngeeyin nunangan wik nilan thaw-thaw thant, piip-kunchantaman waaꞌ-waaꞌ. ");
INSERT INTO wim_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Nil puth Jesus.an thaw thant, “Niiy kan-ngulan kenyan waanchān nunang-a, pam anan nil God.angan kuchan-a, niiy ngul thiichān ngayang puth ngay-ngayaman keꞌ work yumping yaꞌa, puth ngayan wik thaw-thawang-a, an nilaman piip God.angan wik thaaꞌ-aath ngayanga. ");
INSERT INTO wim_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Nil in-inman iiy-iiyan ngatharangan, nil pokkapangan keꞌ wantan ngayang, yaꞌa, ngay puth murkanim min iiy-iiyang meeꞌ nungantanga.” ");
INSERT INTO wim_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Pam wanch yotangan wik inangan ngeeyin nunangan-a, ana min-minam ngul ngaantam-ngeeyin nunang, Jesus.an. ");
INSERT INTO wim_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Nil Jesus.an-a, thaw thant Jews puungk wiy al-alantan than nunangan monkan-wak-wakin ngula, “Niiy wik ngatharaman ngeey-ngeeyinwey-a, yaa, niiyaniy puth-a, ngurp ngatharam paththam iiy-iiyān, ");
INSERT INTO wim_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","aꞌ niiy ngul ngaantam-ngeeyān wik inan kan-kanama God.antamana aꞌ wik ilangan way niiyantaman ngul ngangk pachathowa, niiy yipam ngangk minam iiy-iiyāna, keꞌ yipam moom way alantangan iiy-iiyāna.” ");
INSERT INTO wim_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Than thawin nungant, “Wuut mangk nganttamaniya, Abraham a! Ngan puth pam moom alantan work keꞌam iiy-iiyana. Nint puth wanttak thawana wik yimanangana, ‘Niiy keꞌ-ngul moom way alantangan iiy-iiyāna?’” ");
INSERT INTO wim_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Nil Jesus.an thaw thant, “Ngay niiyant wik inangan kan-kanam thaw-thawang: than weeꞌ-weeꞌanangan way anman yump-yumpayn-a, yaa, an keꞌ than work iiy-iiyantan yimanangan moom way alantana, puth way al-alangan-a, ngangk mungk-mungkan thanang, thanan puth keꞌ wantiythan, kaangk way anman yump-yumpayn. ");
INSERT INTO wim_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","In thamp ngeeyān a! Nil puk kaath piipantamana, an nil puk pulantam iiy-iiyan ngulakam. Puth nil pam workan iiy-iiyan pulant-a, an nil keꞌ nath work ngulakaman iiyiy pulanta, nil kaangkwey work wantowwey-a, nil wantow. ");
INSERT INTO wim_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Nil nhengk God.antaman-a, anman murkaniman wunan piip-kunchantangan. Nilaniy-a, nhengk God.antamangan nath ngangk pachathiy niiyangwey-a, way niiyan yump-yumpana, yaa, niiy ngangk minam ngul iiy-iiyān, niiyan puth way keꞌ-ngul iiy-iiyān. ");
INSERT INTO wim_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ngay puth meeꞌmiy nil Abraham.an wuut mangk niiyantaman, niiyan puth keꞌ mulathanak ngayang ngaantam-ngeeyaniy puth niiy kaangk keꞌ wik ngatharaman ngeeyāna! ");
INSERT INTO wim_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ngay wikan waaꞌ-waaꞌang niiyant-a, an nil piip ngatharamangan waaꞌ ngathar ngayan yipam waaꞌāng niiyant puth niiyana anman iiy-iiyaniy keꞌ piip niiyantamangan waaꞌ-waaꞌan niiyant.” ");
INSERT INTO wim_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Thanan puth-a, thawin nungant, “Wuut mangk nganttamaniy-a, Abraham.” Nil puth Jesus.an thaw thant, “An yaꞌa! Puth wuut mangk niiyantaman Abraham.wey iiyiy-a, niiy puth min iiyin keꞌ nil anman min iiy-iiya. ");
INSERT INTO wim_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Puth ngay iniy-a, nathpalman wik kan-kanam anman waaꞌ-waaꞌang niiyant, wik anman ngayan ngeey-ngeeyang piip ngatharamantaman. Puth niiyan ngaantam-ngeeyaniy keꞌ mulathanak ngayang a! Nil Abraham.aniy-a, puth yimanangan keꞌam iiy a! ");
INSERT INTO wim_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Niiy inanganiy way yump-yumpaniya, keꞌ piip niiyantamangan yump-yumpan a!” Thanan thawin nungant, “Ngan inangan puk meekantam yaꞌa! Piip nganttamiy-a, piip God, nilam thonam anman a!” ");
INSERT INTO wim_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Nil puth Jesus.an thaw thant, “Nil puth God.an piipiy niiyantamwey-a, niiy puth kaangk wunin ngathar, puth ngay ina God.antam anpalan wampanga, aak iikanakan ukang niiyant. Ngay puth ngay-ngayam keꞌ wampang, yaꞌa, nilam kuch ngayang aak iikanakan. ");
INSERT INTO wim_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","