﻿USE sofia;
DROP TABLE IF EXISTS sofia.wib_vpl;
CREATE TABLE wib_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES wib_vpl WRITE;
INSERT INTO wib_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yesu Krista sútó náhkɩ̀ yɔ́ ye lésõ Davidilɛ, Davidi sútó náhkɩ̀ yɔ́ mɛ Abrahmɩnɛ. Yesu Krista mɛ̀ náh tãn nónó-á ku sɔkɔ, pé yni wɛ yɔ̀: ");
INSERT INTO wib_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahmɩ mɛ̀nɛ, Yisakɩ sú ye. Yisakɩlɛ, Nsyakɔbɩ sú ye. Nsyakɔbɩlɛ, Nsyuda sú ye, ǹmɔ nɛ̂-á ǹ dĩ́npì sɔkɔ yɔ́lɛ. ");
INSERT INTO wib_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Nsyudalɛ, Perɛsɩ ànɛ̂ Nsera sú ye, tɛ́ Tamar mɛ pé yṹnɛ. Perɛsɩlɛ, Yɛsrɔnɩ sú ye. Yɛsrɔnɩnɛ, Wramɩ sú ye. ");
INSERT INTO wib_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Wramɩnɛ, Yaminadabɩ sú ye. Yaminadabɩlɛ, Nasõ sú ye. Nasõnɛ, Salma sú ye. ");
INSERT INTO wib_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmalɛ, Bowasɩ sú ye, tɛ́ Bowasɩ yṹ mɛ Wrahbɩlɛ. Bowasɩlɛ, Wobɛdɩ sú ye, tɛ́ Wobɛdɩ yṹ mɛ Wrutilɛ. Wobɛdɩlɛ, Nsyese sú ye. ");
INSERT INTO wib_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Nsyeselɛ, yõ̀tɛ̃̀ dĩ́ Davidi sú ye. Yõ̀tɛ̃̀ dĩ́ Davidilɛ, Salomo sú ye, tɛ́ Salomo yṹnɛ, Yuri lékókè kyɩ ye lésõ. ");
INSERT INTO wib_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomolɛ, Wroboyam sú ye. Wroboyamnɛ, Abya sú ye. Abyalɛ, Asafɩ sú ye. ");
INSERT INTO wib_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asafɩlɛ, Nsyosafatɩ sú ye. Nsyosafatɩlɛ, Nsyoram sú ye. Nsyoramnɛ, Wosyasɩ sú ye. ");
INSERT INTO wib_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Wosyasɩlɛ, Yotam sú ye. Yotamnɛ, Asyasɩ sú ye. Asyasɩlɛ, Yesekyasɩ sú ye. ");
INSERT INTO wib_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Yesekyasɩlɛ, Manasɩ sú ye. Manasɩlɛ, Amo sú ye. Amolɛ, Nsyosyasɩ sú ye. ");
INSERT INTO wib_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Nsyosyasɩlɛ, Yekonya sú ye, ǹmɔ nɛ̂-á ǹ dĩ́npì sɔkɔ yɔ́lɛ. Tɛ́ légbĩ́ ye sõ̀ pè mɛ Yisrayel no kyɩ̃ mɔ à pè tɛ̃ sɔkɔ Babilɔnɩ yamana sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Képah náh, Salatyɛlɩ dubi, ǹmɔ nɛ̂-á Yekonya pídĩ́nɛ. Salatyɛlɩlɛ, Nsorobabɛlɩ sú ye. ");
INSERT INTO wib_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Nsorobabɛlɩlɛ, Abiyudi sú ye. Abiyudilɛ, Yelyakimi sú ye. Yelyakiminɛ, Asɔrɩ sú ye. ");
INSERT INTO wib_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asɔrɩlɛ, Sadɔkɩ sú ye. Sadɔkɩlɛ, Asyimi sú ye. Asyiminɛ, Yeliyudi sú ye. ");
INSERT INTO wib_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Yeliyudilɛ, Yeleyasar sú ye. Yeleyasarlɛ, Matã sú ye. Matãnɛ, Nsyakɔbɩ sú ye. ");
INSERT INTO wib_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Nsyakɔbɩlɛ, Nsyosɛfu sú ye, nɛ̂-á Mari pɛlɛ. Mari mɛ̀ ye sõ̀ dubi Yesulɛ, nɛ̂-á pè n ye Kristalɛ, Liyel nɛy yáhntɔkɔnɔlɛ. ");
INSERT INTO wib_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Knɔ knɔ nónó pól-á wɛ sɔkɔ, sè wɛ yɔ̀: À tɔkɔ Abrahmɩ gbĩ tyɩ́, pópó à pɔ syɩ Davidi gbĩ tyɩ́, knɔ knɔnɔ gbɔ̃nyã́h ye wɛ sɔkɔ. À tɔkɔ Davidi gbĩ tyɩ́, à pɔ syɩ Yisrayel no tɛ̃́nsɔkɔnɔ tyɩ́ Babilɔnɩ yamana sɔkɔ, knɔ knɔnɔ gbɔ̃nyã́h ye tɔ̃ wɛ sɔkɔ. Tɛ́ à tɔ̃ tɔkɔ Yisrayel no tɛ̃́nsɔkɔnɔ tyɩ́ Babilɔnɩ yamana sɔkɔ à pɔ syɩ Krista gbĩ tyɩ́, knɔ knɔnɔ gbɔ̃nyã́h ye wɛ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesu Krista dubi dùkù wɛ yɔ̀: Ǹ yṹ Mari sõ̀ mɛ gbɩ̃́nɔ́lɛ Nsyosɛfu tyɩ́. Ǹtɛ pɛ̀kɩ̀ náh sõ̀ wɛ yah pé wrɔ́, tɛ́ kè pɔ wɛ Mari mɛ kúrkìlɛ Liyel Mirki gbõ̀ yõ. ");
INSERT INTO wib_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Tɛ́ ǹ pɛ Nsyosɛfulɛ, nɛ́gbɩ́ ye sõ̀ ǹnɛ. À náh sõ̀ mɛ ké tyɩ́ nɛ pé Mari yĩn yɩkɩ névye yĩ́ yah. Képah ye à kè yah tɔkɔ nɛ, páh kɩ à yahle sètĩ̀n sõ̀ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Wǎh mɛ képah sõnɔ sɔkɔ, Tɛ̃̀ ǹgbɛ̃ Liyel yĩ̂nyõ tõ̀npɩ yɔ́ pɔ wil ǹ yah dɛ́kɩ́ sɔkɔ, tɛ́ yo ǹ tyɩ́ nɛ: «Davidi pídĩ́ Nsyosɛfu, káh tíkí pɩ á kyɩ Mari fúrnɔ́lɛ. Á náh wɛ di, Liyel Mirki gbõ̀ yõ ye à tɔkɔ kúrkì mɛ̀nɛ. ");
INSERT INTO wib_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","À kɩ pídĩ́ dubi nɛ̂-á kɩ ǹ no pwah n mɔ n pi pé tyípêl sɔkɔ. Képah ye, á kɩ ǹ yĩn sah Yesulɛ.» ");
INSERT INTO wib_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Tɛ̃̀ ǹgbɛ̃ Liyel-á lésõ ǹ tɛ̃ntõ̀ syínyo-ò kɔ̃ à tyi nónó yo sah, sépi wil yĩn ye tyi nɔ́pi pól kɔ̃ sè pɩ. À lésõ nɛ ńkɛ̃́: ");
INSERT INTO wib_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«Yah, dĩ́ pɩ̃́-ńkɛ̃̂ sê kɩ kúrkì tɔkɔ. À kɩ dĩ́npir yɔ́ dubi, tɛ́ ǹ yĩn kɩ sah Yemanuwɛlɩlɛ, nɛ̂ kɔ́r-á: Liyel mɛ ápilɛ.» ");
INSERT INTO wib_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Nsyosɛfu-á pɔ dɔ yuku, Tɛ̃̀ ǹgbɛ̃ Liyel yĩ̂nyõ tõ̀npɩ-á tyi nónó yo ǹ tyɩ́, à sè pɩ. À ǹ kyɩ Mari fur. ");
INSERT INTO wib_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ǹtɛ pɛ̀kɩ̀ náh wɛ yah pé wrɔ́, fɔ́ɔ́ Mari syi pɔ pídĩ́ mɛ̀ dubi, tɛ́ Nsyosɛfu mɛ ǹ yĩn sah Yesulɛ. ");
INSERT INTO wib_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesu dubi Betlɛmɩ kwil sɔkɔ, Nsyude sétáh yõ, gbĩ́ nɛ̂-á lésõ yõ̀tɔ̃rɩ́ mɛ yõ̀tɛ̃̀ dĩ́ Yerɔdɩ gbõ̀. Yesu-á dubi sɛ̃́, ńwɔ̃́ kèpye sɔkɔ tyi pnɛ̀pu mɛ wil gbĩ̀ngbokelɛ, à pɔ Yerusalɛmɩ kwil sɔkɔ, ");
INSERT INTO wib_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","tɛ́ mɛ píkínyahnɔ pɩ nɛ ńkɛ̃́: «Nsyifunɔ yõ̀tɛ̃̀ dĩ́ nɛ̂-á dubi, à mɛ ńyãh sɔkɔ? Ápi mɛ gbĩ̀ngbokelɛ tɛ́ ǹ ńwɔ̃́ kèpil wɛ kè wil. Képah ye á nɛ á pɔ gbílkínɔ́ sah ǹ yõ.» ");
INSERT INTO wib_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Yõ̀tɛ̃̀ dĩ́ Yerɔdɩ-á képah tɛ̃̀ noh sɛ̃́, kè ǹ fɔkɔ fɛ̃kɩ ànɛ̂ Yerusalɛmɩ tãn póllɛ. ");
INSERT INTO wib_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Kǎh pɩ sɛ̃́, à mɛ sárká syínwìlkìpu yõ̀tãm ànɛ̂ Liyel tyi kõ̀nsàhnɔ́ kwɔ́pú pól ye tuke, tɛ́ pè piki yah nɛ ńkɛ̃́, ńyãh sɔkɔ se Liyel nɛy yáhntɔkɔnɔ yɩ̃nɛ à pɔ dubi nɩ? ");
INSERT INTO wib_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Pè mɛ yo ǹ tyɩ́ nɛ: «Betlɛmɩ sɔkɔ ye, Nsyude sétáh yõ. Á náh wɛ di, Liyel lésõ ǹ tɛ̃ntõ̀ syínyo-ò kɔ̃ à kè wãrkɩ sah nɛ ńkɛ̃́: ");
INSERT INTO wib_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‹Áwɔ Betlɛmɩ kwil nɛ̂-á Nsyude sétáh yõ, á náh mɛ fṍrɔɔ Nsyude sétáh yõ kwlo ǹgbnɔ sɔkɔ dɛ́. Yah, névye yah tɛ̃́-ò yɔ́ kɩ pɔ n dubi n pi á sɔkɔ, nɛ̂-á kɩ ńmɔ no Yisrayel tɛ̃́nɔ́ plɛ n pi.›» ");
INSERT INTO wib_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Képah tɛ̃̀nɛ, Yerɔdɩ mɛ ńwɔ̃́ kèpye sɔkɔ tyi pnɛ̀pu wɔ̃bɩ ye à pɔ pè piki yah pɩ̃, gbĩ́ nɛ̂ tɔ́tɔ́-á pè wɛ ńwɔ̃́ kèpil mɛ̀nɛ. ");
INSERT INTO wib_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Képah náh, à pè tɛkɩ mɔ Betlɛmɩ sɔkɔ, tɛ́ yo pé tyɩ́ nɛ, pàh kɩ kyɩ, pè píkínyahnɔ pɩ pallɛ piri mɛ̀ tyɩ́ sɔkɔ, pàh kɩ à wɛ, pè pɔ kè yo pé tyɩ́, péwɔ tɔ kɔ̃ pé kyɩ gbílkínɔ́ sah ǹ yõ. ");
INSERT INTO wib_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Yõ̀tɛ̃̀ dĩ́ Yerɔdɩ-á wɛlɔ nɔ́pi yo tɛ pé tyɩ́, pè mɛ wɛ̃̀kɩ̀ tɛ̃. Pǎh wɛ̃̀kɩ̀ tɛ̃, ńwɔ̃́ kèpil nɛ̂-á sõ̀ pè wɛ tɛ́ mɛ gbĩ̀ngbokelɛ, pè tɔ̃ kè wɛ pé yah tĩ̀nnɛ kè n yuku pélɛ, pópó à kyɩ yĩn piri mɛ́-ńsah yõ̀tah sírr sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ńwɔ̃́ kèpil mɛ̀ tɔ̃́nwɛnɔlɛ, kè pé nɩ kah vɩ. ");
INSERT INTO wib_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Pè mɛ de gbô, tɛ́ piri wɛ ànɛ̂ ǹ yṹ Marilɛ. Képah tɛ̃̀nɛ, pè pé gbètukunɔ di piri mɛ̀ yah à gbílkínɔ́ sah ǹ yõ, tɛ́ pé vyɔ́ yey yɩkɩ mɔ à sã́n, ànɛ̂ wɔ̀kɔ̀ yɔ̃ yɔ̃ kwâh pãn pènɛ̀kɩ̀ yɔ́, ànɛ̂ làsèkwěl pãn pènɛ̀kɩ̀ yɔ́ wilki sé sɔkɔ, à pèpɔrɩ pɩ piri tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Képah náh, Liyel gbáhdyâh yɔ́ di pé tyɩ́ dɛ́kɩ́ sɔkɔ nɛ, pè káh pé syɩ yuku Yerɔdɩ tĩ̀nnɛ. Kǎh pɩ sɛ̃́, pè mɛ wɛ̃̀kɩ̀ káhkɩ́ yɔ́ tɛ̃, à pé syɩ sɔkɔ pé kwil sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ńwɔ̃́ kèpye sɔkɔ tyi pnɛ̀pu-á pé syɩ sɔkɔ, Tɛ̃̀ ǹgbɛ̃ Liyel yĩ̂nyõ tõ̀npɩ yɔ́ mɛ wil Nsyosɛfu yah dɛ́kɩ́ sɔkɔ, tɛ́ yo ǹ tyɩ́ nɛ: «Yõ̀tɛ̃̀ dĩ́ Yerɔdɩ kɩ piri mɛ̀ soh n kɔ̃ n pi núkúnúkú ǹ ko n mɔ n yĩnnɛ. Képah ye, yuku piri mɛ̀ tɛ̃ ànɛ̂ ǹ yṹnɛ, ǹ to n sɔkɔ pélɛ Yesyipti yamana sɔkɔ, ǹ kyɩ n tɛ̃ nɛ́npɔ́, pópó kɩ pɔ n nɔ ń yónmɔnɔ tyɩ́ á tyɩ́.» ");
INSERT INTO wib_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Képah tɛ̃̀nɛ, Nsyosɛfu mɛ yuku kénɛ lékã̂hnɛ, à piri ànɛ̂ ǹ yṹ tɛ̃ pè sɔkɔ Yesyipti yamana sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Pè kyɩ tɛ̃ nɛ́npɔ́, pópó Yerɔdɩ syi pɔ ku. Kǎh pɩ sɛ̃́, Tɛ̃̀ ǹgbɛ̃ Liyel-á lésõ ǹ tɛ̃ntõ̀ syínyo-ò kɔ̃ à nɛ̂ yo sah nɛ: «Mé ń Pídĩ́ ye yal Yesyipti yamana sɔkɔ.» kè kɩ wil. ");
INSERT INTO wib_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Yerɔdɩ-á pɔ pɩ̃ nɛ ńwɔ̃́ kèpye sɔkɔ tyi pnɛ̀pu-á pé vi tɛ̃, ǹ fɔkɔ kah vyãh. Tɛ́ wǎh lésõ ńwɔ̃́ kèpil mɛ̀ wil gbĩ́ wɛ noh sɔkɔ tɛ ńwɔ̃́ kèpye sɔkɔ tyi pnɛ̀pu tyɩ́ sɛ̃́, à núkú nɛ pè kyɩ Betlɛmɩ kwil ànɛ̂ ké gbɔ̀plɔ kwlo wɛ̃́npì pól ko mɔ, nónó-á pè náh kah ye nínɔ́ nínɔ́lɛ. ");
INSERT INTO wib_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Képah sɔkɔ, Liyel tɛ̃ntõ̀ syínyo-ò Nsyeremi-á lésõ nɛ̂ yo sah, kè wil. À lésõ nɛ ńkɛ̃́: ");
INSERT INTO wib_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«Yĩ́npɔ̃́ yɔ́ mɛ n dɔkɔ Wrama kwil sɔkɔ, nɛ̂-á pɔ̀ gbónɔ́ ànɛ̂ yãm yãm tyi kàhnpɩ́nɔ́lɛ. Arasyɩlɩ ye n gbo ǹ wɛ̃́npì yĩnnɛ. Pè ye yah kwlɔ, képah ye à náh mɛ fàlnɔ́ tyɩ́.» ");
INSERT INTO wib_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Yerɔdɩ kúntɛnɔ náh, Tɛ̃̀ ǹgbɛ̃ Liyel yĩ̂nyõ tõ̀npɩ yɔ́ wil Nsyosɛfu yah dɛ́kɩ́ sɔkɔ Yesyipti yamana, ");
INSERT INTO wib_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","tɛ́ yo ǹ tyɩ́ nɛ: «Nónó-á sõ̀ n yah n kɔ̃ piri mɛ̀ kònmɔ-ńsahlɛ, pè ku tɛ. Képah ye, yuku piri ànɛ̂ ǹ yṹ tɛ̃ n sɔkɔ Yisrayel sétáh yõ.» ");
INSERT INTO wib_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Képah sɔkɔ, Nsyosɛfu mɛ yuku piri ànɛ̂ ǹ yṹ tɛ̃ pè sɔkɔ Yisrayel sétáh yõ. ");
INSERT INTO wib_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Tɛ́ wǎh pɔ noh nɛ Arsyɩlawusi-á tɔkɔ Nsyude mara yõ̀tɔ̃rɩ́lɛ ǹ sú Yerɔdɩ swɔ, tíkí à tɛ̃ kyɩ́nɔ́lɛ nɛ́npɔ́. Ǹtɛ Tɛ̃̀ ǹgbɛ̃ mɛ yo mɔ ǹ tyɩ́ dɛ́kɩ́ sɔkɔ. Képah sɔkɔ, à mɛ sɔkɔ Kalile mara sɔkɔ, ");
INSERT INTO wib_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","à kyɩ tɛ̃ ké kwil yɔ́ sɔkɔ, nɛ̂-á pè n ye Nasarɛtɩlɛ. Tɛ̃̀ ǹgbɛ̃ Liyel-á lésõ ǹ tɛ̃ntõ̀ syínyopu kɔ̃ pè tir nɛ̂ yo sah, képah wil yĩn ye tir mɛ̀ kɔ̃ kè pɩ. Pè lésõ nɛ ńkɛ̃́: «À kɩ n ye Nasarɛtɩ nɛynɛ.» ");
INSERT INTO wib_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Légbĩ́nɛ, Wèlnwìlkì-ò Nsyɔ̃ pɔ Nsyude mara gbɛ̃́nnɩ sɔkɔ, à pɔ tyah Liyel wɛynɛ n yo. ");
INSERT INTO wib_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","À sõ̀ mɛ yo tũ nɛ: «Yé yé tyípêl pɩ́nɔ́ yal mɔ. Yé náh wɛ di, Liyel tɔ̃́rɩ́ mɛ yĩni tɛ̃ tɛ.» ");
INSERT INTO wib_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Liyel tɛ̃ntõ̀ syínyo-ò Yesayi-á lésõ nɛ̂ yo sah nɛ ńkɛ̃́: «Ǹnɩ̂ yɔ́ yĩ́npɔ̃́ mɛ n dɔkɔ gbɛ̃́nnɩ sɔkɔ nɛ ńkɛ̃́: ‹Yé Tɛ̃̀ ǹgbɛ̃ wɛ̃̀kɩ̀ tɔ̃ sah. Yé ǹ sɔ́kɔ́-ńtã̂n pɩ tómtóm.» Nsyɔ̃ yĩ́npɔ̃́ tyɩ́ ye lésõ à n yo. ");
INSERT INTO wib_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yã̀hmɩ́kɩ̀ yɛ̀ fwɔ̀mɔnɩ ye sõ̀ Nsyɔ̃ wil, tɛ́ à mɛ ǹ syɩ̃ tɛ̃ sêl kɔ̃lɛ. Sègblo ànɛ̂ syɩ̃rɩ ye sõ̀ ǹ yõkelɛ. ");
INSERT INTO wib_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Képah tɛ̃̀nɛ, Yerusalɛmɩ kwil tãn, ànɛ̂ Nsyude mara pól névye, ànɛ̂ Nsyurdɛ̃ yɔ gbɛ̃̀nyah pól névye sõ̀ mɛ n wil n pɔ ǹ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Pè sõ̀ mɛ pé tyípêl pɩ́nɔ́lɛ n yo n pɔ no pól yĩ́ yah, tɛ́ Nsyɔ̃ mɛ pélɛ n wel n wilki Nsyurdɛ̃ yɔ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Képah sɔkɔ, Nsyɔ̃-á kè wɛ Farisi wɛ̃̀kɩ̀ kɔ́pú ànɛ̂ Sadusi wɛ̃̀kɩ̀ kɔ́pú náhnáh mɛ n pɔ n pɔ à kɔ̃ à pélɛ n wel n wilki sɛ̃́, à mɛ yo pé tyɩ́ nɛ, wáhnmɩ́rɔ́ dùkù nɔ́pi! Nɛ̂ se kwɔ pélɛ nɛ pǎh kɩ fɛ̃ to pwah Liyel fɔ̀kɔ̀vyã̀hnɩ̀ yah, nɛ̂-á n pi nɩ? ");
INSERT INTO wib_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Pè tyípéplɔlɛ n pɩ, nónó-á n wɛ̃kɩ n pi nɛ pǎh pé tyípêl pɩ́nɔ́ yal mɔ. ");
INSERT INTO wib_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Tɛ́ pè káh wɛ nɛ páh kɩ n sõ pé fɔkɔnɩ sɔkɔ nɛ Abrahmɩ-á pé súlɛ, képah-á kɩ yɩ̃nɛ dɛ́. Páh kélɛ n yo pé tyɩ́, dyêh nónó-á yɔ̀, Liyel-á kɩ fɛ̃ sè vi mɔ pɩ Abrahmɩ pyelɛ. ");
INSERT INTO wib_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Tɛ́ man ńtɛ̃-á mɛ yáhnsàhntɛnɔlɛ sésân fɛ̃ yĩnnɛ sé sémîn sɔkɔ. Séswɔ̂ nɛ̂-à n syí-ńkɛ̃̂nɛ pye pèplɔlɛ, kǎh kɩ ko min dah mɔ nyàh sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Péwɔ tɛ̃̀ wɔ-á pélɛ n wel n wilki ni sɔkɔ, nɛ̂-á kɩ kè wɛ̃kɩ nɛ pǎh pé tyípêl pɩ́nɔ́ yal mɔ. Ǹtɛ névi nɛ̂-á kɩ n pɔ n pi péwɔ náhlɛ, tɛ̃̀ wɔ tɛ̃́nwɛnɔ-á kal péwɔ tyɩ́lɛ. Páh fṍrɔɔ kah ǹ lékyêh ńtɛ̃ dɛ́nɔ́lɛ. Tɛ̃̀ wɔ-á kɩ pɔ pè wel wilki Liyel Mirki ànɛ̂ nyàh sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ǹ sèmukɔ fwo fwo kwâh-á mɛ ǹ gbõ̀. Wǎh kɩ ǹ táh tɔ̃ sah, kɩ ǹ sèmukɔ fwo, tɛ́ kɩ ké pɔ́rɩ́ kwel mɔ dúkúrí sɔkɔ. Ǹtɛ sé yésyɩ̂ wɔlɛ, wǎh kɩ sépi sukɛ ní-ńkɛ̃̂ nyàh sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Képah tɛ̃̀nɛ, Yesu wil Kalile mara sɔkɔ à pɔ Nsyɔ̃ tyɩ́ Nsyurdɛ̃ yɔ́ngbalɩ sɔkɔ, nɛ pé pɔ à kɔ̃ à pé wel wilki ni sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ǹtɛ Nsyɔ̃ mɛ yahle tɛ́ nɛ, péwɔ-á yɩ̃nɛ pé pɔ ǹmɔ kɔ̃ à pé wel wilki ni sɔkɔ, tɛ́ ǹmɔ pyě pɔ péwɔ tyɩ́ nɩ? ");
INSERT INTO wib_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ǹtɛ Yesu mɛ yo ǹ tyɩ́ nɛ: «Yɛ kè pɩ sɛ̃́ ǎtrɛ. Á náh wɛ di, ké yah ye Liyel-á nɛ̂ yah kɔ̃, ápi kè pɩ.» Wǎh képah yo sɛ̃́, Nsyɔ̃ mɛ fɛ̃ syi. ");
INSERT INTO wib_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yesu wèlnwìlkìntɛnɔ ǹsɔ̃̀, à wil ni sɔkɔ. Nɛ́npɔ́ swɔ yĩ̂nyõ yɩkɩ mɔ, tɛ́ à mɛ Liyel Mirki wɛ kè mɛ n tiki n pi kèpíkípíkí tyɩ́ kɔ̃lɛ, à pɔ tɛ̃ ǹ yõ. ");
INSERT INTO wib_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Képah sɔkɔ, yĩ́npɔ̃́ yɔ́ núkú n wil yĩ̂nyõ nɛ ńkɛ̃́: «Ńmɔ nɩ̀dɛ̀ Pídĩ́ ye yɔ̀. Ǹmɔ ye ń nɩ̀vɩ̀nɩ̀ yõlɛ.» ");
INSERT INTO wib_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Képah náh, Liyel Mirki Yesu tɛ̃ yuku gbɛ̃́nnɩ sɔkɔ nɛ sétã̀n yõ̀tɛ̃̀ à wɛ tɔ̃ mɔ yah nɛ́npɔ́. ");
INSERT INTO wib_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Wǎh sèpĩ̀n tikininí ànɛ̂ lékãhlɔnɔ́ tikininí pɩ yõke yṍ-ńkɛ̃̂nɛ, kwɛkɩ à tɛ̃. ");
INSERT INTO wib_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Képah sɔkɔ, sétã̀n yõ̀tɛ̃̀ nɛ̂-á tɔ̃̀nmɔ-òlɛ, ǹmɔ mɛ nɔ de Yesulɛ tɛ́ yo ǹ tyɩ́ nɛ, ǹmɔ-à kɩ nɛ̂ Liyel Pídĩ́nɛ, à yo dyêh nɔ́pi tyɩ́ sè vi mɔ pɩ yõkelɛ. ");
INSERT INTO wib_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yesu mɛ yo ǹ tyɩ́ nɛ: «Kè mɛ wã́rkɩ́nsàhnɔ́lɛ Liyel wɛy sɛ́bɛ́y sɔkɔ nɛ ńkɛ̃́: ‹Yõke ó náh n pu névilɛ dɛ́. Ǹtɛ wɛlɔ nónó-á n wil Liyel vyãh, sépi ye pyě n pu névilɛ.›» ");
INSERT INTO wib_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Képah náh, sétã̀n yõ̀tɛ̃̀ yuku ǹnɛ Yerusalɛmɩ kwil, à kyɩ à sah Liyel ní-ńsah gbô yõ̀tah ");
INSERT INTO wib_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","tɛ́ mɛ yo ǹ tyɩ́ nɛ, ǹmɔ-à kɩ nɛ̂ Liyel Pídĩ́nɛ, à yɔkɔ n tiki sétáh. À kó wɛ nɩ, kǎh mɛ wã́rkɩ́nsàhnɔ́lɛ Liyel wɛy sɛ́bɛ́y sɔkɔ nɛ ńkɛ̃́, ǹmɔ yĩnnɛ, Liyel-á kɩ ǹ yĩ̂nyõ tõ̀npɩbɩ kɔ̃ sè kɩ à swah syi sé gbã̀n sɔkɔ, ǹ gbáhkɩ̀ kɔ̃ kè náh n mɩ n pi dáhkɩ̀ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Képah sɔkɔ, Yesu mɛ yo ǹ tyɩ́ nɛ: «Kè mɛ wã́rkɩ́nsàhnɔ́ tɔlɛ nɛ: ‹Káh á Tɛ̃̀ ǹgbɛ̃ Liyellɛ n mɔ n yah.›» ");
INSERT INTO wib_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Képah náh, sétã̀n yõ̀tɛ̃̀ tɔ̃ sɔkɔ ǹnɛ yɔ̃lɩ kèyy yɔ́ yõ, à kyɩ kèkõyṍ tɔ̃́rɩ́ póllɛ à wɛ̃kɩ ànɛ̂ ké tahrɩlɛ, ");
INSERT INTO wib_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","tɛ́ yo ǹ tyɩ́ nɛ, wàh kɩ ǹ gbètukunɔ di péwɔ yah à pé gbilki, páh kɩ sé póllɛ à kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Képah tɛ̃̀nɛ, Yesu yo ǹ tyɩ́ nɛ: «Yal ń tnɔ̂, sétã̀n yõ̀tɛ̃̀! Kè mɛ wã́rkɩ́nsàhnɔ́lɛ Liyel wɛy sɛ́bɛ́y sɔkɔ nɛ: ‹Á Tɛ̃̀ ǹgbɛ̃ Liyellɛ n gbilki, ǹ tɛ́ nɛ n sah ǹmɔ ó tyɩ́ yõ.» ");
INSERT INTO wib_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Képah sɔkɔ, sétã̀n yõ̀tɛ̃̀ mɛ yal ǹ tnɔ̂. Yĩ̂nyõ tõ̀npɩbɩ mɛ pɔ ǹ tnɔ̂, à pɔ n yah n dah n mɔ ǹ tyɩ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Pè lésõ Wèlnwìlkì-ò Nsyɔ̃ dah mɔ wɔ̀kɔ̀npèkè sɔkɔ. Yesu-á kè noh gbĩ́ nɛ̂nɛ, à ǹ syɩ sɔkɔ Kalile mara sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Tɛ́ à náh tɛ̃ Nasarɛtɩ kwil sɔkɔ. À sõ̀ mɛ kyɩ tɛ̃ Kalile yɔ́-ǹgbɛ̃ gbɔ̀pɔ kwil yɔ́ sɔkɔ pè n ye Kapɛrnayuminɛ, Nsabulõ yìkì ànɛ̂ Nɛfutali yìkì névye sétáh yõ. ");
INSERT INTO wib_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Kè ye pɩ sɛ̃́, nɛ̂-á kɩ Liyel tɛ̃ntõ̀ syínyo-ò Yesayi tir yónsàhnɔ́ mɛ̀ kɔ̃ kè kɩ wil. À lésõ nɛ ńkɛ̃́: ");
INSERT INTO wib_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Nsabulõ yìkì ànɛ̂ Nɛfutali yìkì névye nónó-á mɛ wɛ̃̀kɩ̀ gbɔ̀pɔ nɛ̂-á sɔkɔ yɔ́-ǹgbɛ̃ tnɔ̂, ànɛ̂ pé nónó-á mɛ Nsyurdɛ̃ yɔ́nkahnɩnɛ, à tahlɩ pé Kalile mara tãn tyɩ́ nónó-á pé túkù náh pɩ Nsyifunɔlɛ, ");
INSERT INTO wib_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","pépi nónó-á sõ̀ mɛ fɛ̃́ntũ̂ sɔkɔ, pè kyòo ǹgbɛ̃ yɔ́ wɛ. Pépi nónó-á sõ̀ mɛ fɛ̃́ntũ̂ sɔkɔ kũ tíkílɛ pé sɔkɔ, kyòo yɔ́ mɛ wɛ pé tyɩ́.» ");
INSERT INTO wib_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Tɛ́ à tɔkɔ gbĩ́ nɛ̂-á sõ̀ Yesu mɛ Kapɛrnayumi sɔkɔ, à tyah Liyel wɛynɛ n yo, mɛ yo tũ nɛ: «Yé yé tyípêl pɩ́nɔ́ yal mɔ. Yé náh wɛ di, Liyel tɔ̃́rɩ́ mɛ yĩni tɛ̃ tɛ.» ");
INSERT INTO wib_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesu sõ̀ mɛ n kɔ Kalile yɔ́-ǹgbɛ̃ gbɔ̀pɔ sɔkɔ, tɛ́ díbí nɛ́pĩ̂ nímí wɛ. Simo nɛ̂-á pè yĩn dyɩ à kɔ̃ Pyɛrɩlɛ, ǹmɔ ye sõ̀ ànɛ̂ ǹ gbɛ̃̀ndĩ́ Andrelɛ. Pè sõ̀ mɛ yɛ̃́nkyɔ tɛ̃ tɛ̃ mnɔlɛ n min yɔ sɔkɔ. Yɛ̃́nkyɔ tɛ̃́pú ye sõ̀ pélɛ. ");
INSERT INTO wib_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesu mɛ yo pé tyɩ́ nɛ: «Yé ń sõ̀ tɛ̃. Mé kɩ yé pɩ névye tɛ̃́npɔpulɛ Liyel tyɩ́.» ");
INSERT INTO wib_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Nɛ́npɔ́ swɔ, pè núkú pé yɛ̃́nkyɔ tɛ̃ tɛ̃ mnɔ sah tɛ́ ǹ sõ̀ tɛ̃. ");
INSERT INTO wib_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Wǎh tɔ̃ yuku yahlɛ kwéy, à díbí nɛ́pĩ̂ nímí yísyɔ́ wɛ. Nsyakɩ ànɛ̂ Nsyɔ̃ ye sõ̀, pépi nónó-á Nsebede dĩ́npìlɛ. Pè sõ̀ mɛ ànɛ̂ pé sú Nsebedelɛ krótókè sɔkɔ, mɛ pé yɛ̃́nkyɔ tɛ̃ tɛ̃ mnɔlɛ n tɔ̃ n sah. Yesu mɛ pè ye yah. ");
INSERT INTO wib_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Nɛ́npɔ́ swɔ, pè núkú yal krótókè ànɛ̂ pé sú tnɔ̂, tɛ́ ǹ sõ̀ tɛ̃. ");
INSERT INTO wib_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu sõ̀ mɛ Kalile mara póllɛ n kɔ n kɔ̃, mɛ nolɛ n kwɔ Nsyifunɔ Liyel ní-ńtã̂n vɩ̀ sɔkɔ, mɛ Nɩ̀vɩ̀nɩ̀ tirlɛ n yo Liyel tɔ̃́rɩ́ tyɩ́ yõ, tɛ́ mɛ yámpú pól ànɛ̂ nɛ́fukulɔ́ póllɛ n dɛ n mɔ. ");
INSERT INTO wib_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Kǎh pɩ sɛ̃́, Yesu yĩn wil Siri yamana pól sɔkɔ. No mɛ tyah n pɔ n pɔ yámpú póllɛ ǹ tyɩ́, nónó-á sõ̀ mɛ kwlɔ́nɔ́ sɔkɔ yam ànɛ̂ yèvyãhrɩ duke duke pól sɔkɔ, ànɛ̂ sétã̀n-á sõ̀ mɛ nónó sɔkɔ, ànɛ̂ ǹdyɩ̀kɩ̀npɩbɩlɛ, ànɛ̂ wil kúnɔ́ névyelɛ, Yesu pé pól dɛ mɔ. ");
INSERT INTO wib_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Képah tɛ̃̀nɛ, tɔ́wû ǹgbɛ̃ Yesu sõ̀ tɛ̃. Pé túkù sõ̀ wil Kalile mara sɔkɔ, túkù wil Dekapoli mara sɔkɔ, túkù wil Yerusalɛmɩ kwil, túkù wil Nsyude mara sɔkɔ, túkù mɛ wil Nsyurdɛ̃ yɔ́nkahnɩnɛ. ");
INSERT INTO wib_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu-á tɔ́wû wɛ sɛ̃́, à dɔkɔ yuku yɔ̃lɩ yõ. Wǎh kɔ̃ tɛ̃, ǹ tõ̀ sã́hpú mɛ nɔ de ǹ tnɔ̂. ");
INSERT INTO wib_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Képah sɔkɔ, à mɛ tyah pélɛ n kwɔ nɛ ńkɛ̃́: ");
INSERT INTO wib_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Nónó-á pɩ̃ nɛ Liyel yétõ̂-á mɛ pé tɛ̃, pépi tyɩ́ nɔ. Pè kɩ Liyel tɔ̃́rɩ́ nɔlɩ yõ n pi. ");
INSERT INTO wib_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Nónó-á mɛ gbní sɔkɔ, pépi tyɩ́ nɔ. Liyel kɩ pé yétĩ kele n pi. ");
INSERT INTO wib_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Gblɔ̌y tíkínmɔnɔ-á mɛ nónó sɔkɔ, pépi tyɩ́ nɔ. Sétáh kɩ pɔ n pɩ n pi pépi tyɩ́lɛ. ");
INSERT INTO wib_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Gbɩ wɛ̃̀kɩ̀ kɔ́lɔ́ dékè-á mɛ nónó sɔkɔ, á kɩ nɛ kwɛkɩ ànɛ̂ níkì sɔ̃́ tɛ̃ pélɛ, pépi tyɩ́ nɔ. Pǎh nɛ̂nɛ n yah n kɔ̃, pè kɩ kè wɛ n dal n mɔ n pi. ");
INSERT INTO wib_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Nónó-á névye yãmnɛ n yah, pépi tyɩ́ nɔ. Liyel kɩ pé tɔ yãm yah n pi. ");
INSERT INTO wib_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Nónó nnɔ-á mɛ yályál Liyel yah, pépi tyɩ́ nɔ. Pè kɩ Liyel wɛ n pi yĩ́nɛ. ");
INSERT INTO wib_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Nónó gbõ̀ yõ-á yèvɩnɩ n wɛ, pépi tyɩ́ nɔ. Pè kɩ n ye n pi Liyel wɛ̃́npìlɛ. ");
INSERT INTO wib_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Nónó-á mɛ fṍhnɔ́lɛ n wɛ pé nɛ́gblɔ́ pɩ́nɔ́ yĩnnɛ Liyel yah, pépi tyɩ́ nɔ. Pè kɩ Liyel tɔ̃́rɩ́ nɔlɩ yõ n pi. ");
INSERT INTO wib_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Névye-à yélɛ n gbyɔ gbĩ́ nɛ̂nɛ, tɛ́ yélɛ n fõh, tɛ́ yé tyɩ́lɛ n yo n ko à mɩ̀nɩ̀ duke duke póllɛ n sah yé yõ ńmɔ yĩnnɛ, yépi tyɩ́ nɔ. ");
INSERT INTO wib_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Sɛ̃́ ye lésõ pè fõh Liyel tɛ̃ntõ̀ syínyopulɛ nónó-á yé dyàh tɛ̃ pɔ sɔkɔ. Yé kɩ ké yõre ǹgbɛ̃ wɛ n pi yĩ̂nyõ sɔkɔ. Képah ye, yé nɛ n mɛ nɩ̀vɩ̀nɩ̀ ǹgbɛ̃ sɔkɔ yèsyɩ̀kɩ̀ tɛ̃̀nɛ. ");
INSERT INTO wib_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Yépi ye n nɔ kèkõyṍlɛ, sɔ̃́-á pnɛ pãnnɛ n nɔ. Ǹtɛ pnɛ dêndên-à wal ké sɔkɔ, sɔ̃́ mɛ kè kɩ tɔ̃ fɛ̃ pɩ dêndên? Kè náh tɔ̃ fɛ̃ tir yɔ́ pɛkɩ n pi, à wil mílkínɔ́ tyɩ́ sɔkɔ kégbɔ́, tɛ́ névye kɩ n kɔ n sɔkɔ ké yõ. ");
INSERT INTO wib_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Yépi ye kèkõyṍ kyòolɛ. Kwil nɛ̂-à mɛ mɔ́nɔ́lɛ yɔ̃lɩ yõ, kè náh fɛ̃ n wɔ̃bɩ n pi dò. ");
INSERT INTO wib_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Pè náh fɔ̀tnɔ̀lɛ n soh tɛ́ dúlɛ n kwĩnki n mɔ ké yah. Pě kè sah fɔ̀tnɔ̀ sahkɩ sɔkɔ, kè kɔ̃ kè n pɩ kyòolɛ wɔ̀kɔ̀ sɔkɔ névye pól tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Sɛ̃́ ye yé yɩ̃nɛ yè pɩ kyòolɛ névye tyɩ́, pè kɔ̃ pè yé tyípéplɔ pɩ́nɔ́ wɛ, pè mó yé Súlɛ n gbilki, nɛ̂-á mɛ yĩ̂nyõ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Yé káh wɛ nɛ ńmɔ-á pɔ tyi kõ̀nsàhnɔ́ duku kò-ǹsah, képah náh pɩ Liyel tɛ̃ntõ̀ syínyopu-á kwɔ́nɔ́ nónó kɔ̃, sépi duku kò-ǹsah dɛ́. Mé náh pɔ sé duku kò-ǹsah, ǹtɛ mé pɔ sé tyi pɩ́ndalnmɔ-ńsah. ");
INSERT INTO wib_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Kègbɩ yõ mé kélɛ n yo yé tyɩ́, yĩ̂nyõ ànɛ̂ sétáh tɛ̃̀-à fyɔ̀ mɛ, kwâh tyɩ̃́ɩ̃ yɔ́, képah náh pɩ kwáhkyɩ̃rɩ́ yɔ́ ńtɛ̃ náh n wilki n pi tyi kõ̀nsàhnɔ́ sɔkɔ, fɔ́ɔ́ kɩ pɔ syɩ ké sɔkɔ tyi pól pɩ́ntɛnɔ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Képah ye, névi nɛ̂-à n sàh-ǹkɛ̃̂nɛ tyi kõ̀nsàhnɔ́ sɔkɔ tir kyɩ̃rɩ́ fyé yõ, tɛ́ no tɛ́lɔ́ tɔ yõ yɩkɩ mɔ sɛ̃́ntɛ̃̀ pɩ́nɔ́ sɔkɔ, tɛ̃̀ kɩ fṍrɔɔ kal Liyel tɔ̃́rɩ́ nɔlɩ yṍpú póllɛ. Ǹtɛ névi nɛ̂ wɔ-à n sah sé sɔkɔ tyíyónɔ́ yõ, tɛ́ sélɛ nolɛ n kwɔ, tɛ̃̀ wɔ kɩ yĩ́n-ńsah ǹgbɛ̃ wɛ Liyel tɔ̃́rɩ́ nɔlɩ yṍ-ńsah sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Mé kélɛ n yo yé tyɩ́, yáh kɩ pɩ́-ńkɛ̃̂nɛ gbɩ wɛ̃̀kɩ̀ kɔ́púlɛ Liyel yah à kal Liyel tyi kõ̀nsàhnɔ́ kwɔ́pú ànɛ̂ Farisi wɛ̃̀kɩ̀ kɔ́púlɛ, yé náh Liyel tɔ̃́rɩ́ nɔlɩ yõ n pi. ");
INSERT INTO wib_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Yé kè noh sɔkɔ nɛ kǎh yo á náh tãn tyɩ́ nɛ, nɛy káh nɛ́kókè mɔ. Névi nɛ̂-à nɛ́kókè mɔ, tɛ̃̀-á yɩ̃nɛ tùkènɔ́lɛ. ");
INSERT INTO wib_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ǹtɛ ńmɔ wɔ kélɛ n yo yé tyɩ́ nɛ, névi nɛ̂-à ǹ fɔkɔ vyãh ǹ ní-òlɛ, tɛ̃̀-á yɩ̃nɛ tùkènɔ́lɛ. Nɛ̂-à ǹ ní-ò ye Nɛ́wõ̂lɛ, tɛ̃̀-á yɩ̃nɛ tùkènɔ́lɛ tukey tùkèpu tĩ̀nkì tyɩ́. Tɛ́ nɛ̂-à à ye Vínpɩlɛ, tɛ̃̀ wɔ-á yɩ̃nɛ dáhnmɔnɔlɛ ní-ńkɛ̃̂ nyàhnpèkè sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Wâh pɔ á yɩ̃ n kɔ̃ kɔ̃ kwâhlɛ Liyel kɔ̃́-ńsah, tɛ́ á dyɔ to kõ nɛ́npɔ́ sɔkɔ nɛ wáh pɩ de á ní-ò yɔ́ tyɩ́, ");
INSERT INTO wib_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","á yɩ̃ n kɔ̃ kɔ̃ kwâh sah nɛ́npɔ́, ǹ tɛ́ n kyɩ á wrɔ́ tɔ̃ n sah á ní-ò mɛ̀nɛ, ǹ tɛ́ n pyě n pɔ kélɛ Liyel kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Tir yɔ́ kénkɔ̃-à mɛ yé wrɔ́ ànɛ̂ ǹnɩ̂ yɔ́lɛ, tɛ́ à kyɩ ǹ ye tukey tùkè-ò tyɩ́, gbah n tɛ̃ ké yah wah yé yĩ́níntɛ̃-ńkɛ̃̂ sɔkɔ nɛ́npɔ́. Képah-à pɩ́-ńkɛ̃̂nɛ, à kɩ kyɩ álɛ tukey tùkè-ò tyɩ́ nɛ à ké yah wah, tukey tùkè-ò mɛ̀ kɩ kyɩ álɛ sràsyíbí kɔ̃, tɛ́ pépi kɩ mó ǹ dah mɔ wɔ̀kɔ̀npèkè sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Kègbɩ yõ mé kélɛ n yo á tyɩ́, á náh n wil n pi nɛ́npɔ́, nɛ́ á náh kɔ̃lɩ mɛ̀ pól dyah tɛ pnɛ́pnɛ́. ");
INSERT INTO wib_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Yé kè noh sɔkɔ nɛ kǎh mɛ yónɔ́lɛ nɛ: «Káh fɔ̀fɩ́kɩ̀lɛ n pɩ.» ");
INSERT INTO wib_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ǹtɛ ńmɔ kélɛ n yo yé tyɩ́ nɛ, névi nɛ̂-à sê yɔ́ yah, tɛ́ yĩ́ wil ǹ tyɩ́, tɛ̃̀-á fɔ̀fɩ́kɩ̀ pɩ tɛ ǹnɛ ǹ nɩ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Á gbõ̀yõ̀ sõ̀ yĩ́-à kɩ nɛ̂ ǹ dah n mɔ n pi tyípékè pɩ́nɔ́ sɔkɔ, kè gbahlɩ n wilki n milki álɛ fɩ́ɩ́. Á tɛ́kɩ́nɔ́lɛ á wil gbɛ̃́nsê fɩ̃́ núkú sɔkɔ, képah kɩ fṍnfṍ kal á wil pól mínndahnmɔnɔ yõ ní-ńkɛ̃̂ nyàhnpèkè sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Á gbõ̀yõ̀ sõ̀ gbõ̀-à kɩ nɛ̂ ǹ dah n mɔ n pi tyípékè pɩ́nɔ́ sɔkɔ, kè kãm n milki álɛ fɩ́ɩ́. Á tɛ́kɩ́nɔ́lɛ á wil gbɛ̃́nsê fɩ̃́ núkú sɔkɔ, képah kɩ fṍnfṍ kal á wil pól kyɩ́ndenɔ yõ ní-ńkɛ̃̂ nyàhnpèkè sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Kè mɛ yónɔ́ tɔlɛ nɛ, névi nɛ̂-à ǹ kyɩlɛ n fĩn n mɔ, tɛ̃̀-á yɩ̃nɛ à ǹ fĩ́nnmɔnɔ tàrfyɔ̀ sɛ́bɛ́y pɩ à kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ǹtɛ ńmɔ tɛ̃̀ wɔ kélɛ n yo yé tyɩ́ nɛ, névi nɛ̂-à ǹ kyɩ fĩn mɔ nɛ́ fɔ̀fɩ́kɩ̀ tɛ̃̀ tyɩ́ yõ náh, tɛ̃̀-á mɛ ǹnɛ n mɔ fɔ̀fɩ́kɩ̀ pɩ́nɔ́ wɛ̃̀kɩ̀ yõ. Névi nɛ̂ tɔ-à mó sê fĩ́nnmɔnɔ tɔkɔ, fɔ̀fɩ́kɩ̀-á tɛ̃̀ n pɩ. ");
INSERT INTO wib_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Yé kè noh sɔkɔ tɔlɛ nɛ kǎh yo á náh tãn tyɩ́ nɛ: «Káh álɛ n wo mɩ̀nɩ̀ tyi sɔkɔ. Wâh á wo tir nɛ̂ sɔkɔ Tɛ̃̀ ǹgbɛ̃ yah, á yɩ̃nɛ ǹ kè pɩ.» ");
INSERT INTO wib_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ǹtɛ ńmɔ tɛ̃̀ wɔ kélɛ n yo yé tyɩ́ nɛ, yé káh yélɛ n wo póllɛ. Yé káh yélɛ n wo yĩ̂nyõlɛ. Liyel tɔ̃́rɩ́ kǒ ye kélɛ, képah ye yé káh yélɛ n wo kélɛ. ");
INSERT INTO wib_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Yé káh yélɛ n wo sétáhlɛ. Liyel gbyẽ̂h súnsàh-ǹsah kǒ ye kélɛ, képah ye yé káh yélɛ n wo kélɛ. Yé káh yélɛ n wo Yerusalɛmɩnɛ. Yõ̀tɛ̃̀ ǹgbɛ̃ Liyel kwil ye kélɛ, képah ye yé káh yélɛ n wo kélɛ. ");
INSERT INTO wib_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Káh álɛ n wo á yõlɛ. Á náh fɛ̃ á yõ̀yén pɔ́ núkú ńtɛ̃ fyé piki, képah náh pɩ à kè silki n pi, képah ye káh álɛ n wo kélɛ. ");
INSERT INTO wib_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Kàh àwelɛ, yo nɛ àwe-á. Kàh ɔ̃́ɔ̃lɛ, yo nɛ ɔ̃́ɔ̃-á. Tɛ́ wâh nɛ̂ yo dohnɩ sépi yõ, pèkè pɩ́-ò tõ̀ vyãh ye. ");
INSERT INTO wib_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Yé kè noh sɔkɔ nɛ kǎh mɛ yónɔ́lɛ nɛ: «Wâh yĩ́ sɔ, á yĩ́ kɩ sɔ. Wâh yĩ́n dal, á yĩ́n kɩ dal.» ");
INSERT INTO wib_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ǹtɛ ńmɔ kélɛ n yo yé tyɩ́ nɛ, névi-à tyítúkù pɩ yé tyɩ́, yé káh nɛ yáh ké wɔ́lɛ n dɛ. Tɛ́ névi-à á gbõ̀yõ̀ sõ̀ létáh mɩ, ké ní-ò tɔ vi n mɔ à kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Névi-à mɛ ké tyɩ́ nɛ pé ǹ ye tukey tùkèpu tyɩ́ á fwɔ̀mɔ̀npír syi yĩnnɛ, á fwɔ̀mɔ̀-ǹgbɛ̃ tɔlɛ tɛ̃̀ kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Névi-à ǹ kyɩ̃ mɔ nɛ á kíló núkú kɔ pélɛ, kílónɔ́ nínɔ́ kɔ tɛ̃̀nɛ. ");
INSERT INTO wib_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Névi nɛ̂-à ni á tyɩ́, yɩ̃ tɛ̃̀ kɔ̃. Nɛ̂-à nɛ pé dɛkɩ syi á tyɩ́, káh n yahle. ");
INSERT INTO wib_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Yé kè noh sɔkɔ nɛ kǎh mɛ yónɔ́lɛ nɛ, á ní-ò tyɩ́-á yɩ̃nɛ kè nɔ á tyɩ́, á mó á sépɛ dyɔlɛ n yɔ. ");
INSERT INTO wib_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ǹtɛ ńmɔ kélɛ n yo yé tyɩ́ nɛ, yé yɛ yé sépɛ́bɩ́ tyɩ́ nɔ yé tyɩ́, yé mó Liyellɛ n ni yé fṍhpú tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Yâh képahlɛ n pɩ, yé Sú Liyel nɛ̂-á yĩ̂nyõ sɔkɔ, yé mɛ kélɛ n wɛ̃kɩ nɛ ǹmɔ wɛ̃́npì-á yélɛ. Ǹmɔ ye n sɛ ǹ gbĩnɛ nɛ́pêl ànɛ̂ nɛ́péplɔ tyɩ́, tɛ́ pũ̀nɛ n pɩ n mɔ nɛ́gblɔ́ ànɛ̂ nɛ́túkúnì tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Tɛ́ yépi tyɩ́-á nɔ nónó tyɩ́, pépi ó tyɩ́-à nɔ yé tyɩ́, yõre nɛ̂ mɛ yé kɩ n wɛ n pi képah sɔkɔ Liyel tyɩ́? Mɔ́rɩ́ syípú ńtɛ̃ tɔ náh mɛ sɛ̃́ntɛ̃̀nɛ n pɩ di? ");
INSERT INTO wib_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Yâh n wɛkɩ n mɔ yé no ó tyɩ́, gbɛ̃̀ndùnì tir nɛ̂ mɛ képahlɛ? Liyel wɛ̃̀kɩ̀ kɔ́-ńkɛ̃̂pú ńtɛ̃ tɔ náh mɛ sɛ̃́ntɛ̃̀nɛ n pɩ di? ");
INSERT INTO wib_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Yépi tɛ̃̀ wɔlɛ, yé tyípéplɔ ó kɔ́kɔ́lɛ n pɩ, sɔ̃́-á yé Sú tyípéplɔ ó kɔ́kɔ́lɛ n pɩ, ǹmɔ nɛ̂-á mɛ yĩ̂nyõ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yé yé gblɔ̌ynɛ n tɛ̃ gbɩ wɛ̃̀kɩ̀ kɔ́lɔ́lɛ yĩ́nyáhkɩ̀ sɔkɔ dɛ́. Yâh képahlɛ n pɩ, yé náh ké yõre wɛ n pi Sú Liyel tyɩ́, ǹmɔ nɛ̂-á yĩ̂nyõ. ");
INSERT INTO wib_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Képah ye, wâh kwâhlɛ n yɩ̃ yãm nɛynɛ n kɔ̃, káh ké kwnínɛ n kɔ̃ sɔ̃́-á névye túkù n nɛ n pɩ kélɛ Liyel ní-ńtã̂n vɩ̀ sɔkɔ ànɛ̂ wã̀l yey sɔkɔ, névye kɔ̃ pě pélɛ n gbilki. Kègbɩ yõ mé kélɛ n yo yé tyɩ́, pè ye ké yõre wɛ tɛ. ");
INSERT INTO wib_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ǹtɛ áwɔ-à kwâhlɛ n yɩ̃ yãm nɛynɛ n kɔ̃, káh n yɛ ǹnɩ̂ yɔ́ ńtɛ̃ pɩ̃ ké sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Képah sɔkɔ, yɩ̃́nkɔ̃nɔ nɛ̂-á á pɩ, kè kɩ tɛ̃̀ sètĩ̀n sõ̀ sɔkɔ. Tɛ́ Sú Liyel nɛ̂-á sètĩ̀n sõ̀ tyilɛ n pnɛ, ǹmɔ kɩ ǹ dyah ké yõrelɛ. ");
INSERT INTO wib_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Yâh Liyellɛ n ni, yé káh névye túkùlɛ n yah n pɩ. Liyel ní-ńtã̂n vɩ̀ ànɛ̂ wɛ̃̀tlo yey sɔkɔ yúkúnyĩnntɛ̃̀nɔ́ tyɩ́ ye nɔ pépi tyɩ́ pàh Liyellɛ n ni. Pé gblɔ̌y wɛ̃kɩ yĩn ye pè n nɛ n pɩ képahlɛ. Kègbɩ yõ mé kélɛ n yo yé tyɩ́, pè ye ké yõre wɛ tɛ. ");
INSERT INTO wib_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ǹtɛ áwɔ-à mɛ ké tyɩ́ nɛ á Liyel ni, wâh pɩ ǹ de á wɔ̀kɔ̀ sɔkɔ, ǹ tɛ́ á yah vike, ǹ tɛ́ á Sú Liyellɛ n ni. Tɛ́ Sú Liyel nɛ̂-á sètĩ̀n sõ̀ tyilɛ n pnɛ, ǹmɔ kɩ ǹ dyah ké yõrelɛ. ");
INSERT INTO wib_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Yâh nírílɛ n pɩ, yé káh tyilɛ n tɔ̃ n yo tyɛ́-ńkɛ̃̂nɛ Liyel pɩ̃́-ńkɛ̃̂pú tyɩ́ kɔ̃lɛ. Pépi tɛ̃̀ sõnɔ sɔkɔ, tyi tɔ̃́nyonɔ kwlěyy nírí ye Liyel n tɛ̃. ");
INSERT INTO wib_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ǹtɛ yî nónó yétõ̂-á mɛ yépi tɛ̃, yé Sú Liyel sè pɩ̃ tɛ sé ní-ńkɛ̃̂ gbĩ́ ńtɛ̃nɛ ǹ tyɩ́. Képah ye, yé káh Liyel pɩ̃́-ńkɛ̃̂púlɛ n yah n pɩ. ");
INSERT INTO wib_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Yáh yɩ̃nɛ yè Liyellɛ n ni dùkù nɛ̂nɛ, kè wɛ yɔ̀: Ápi Sú Liyel nɛ̂-á yĩ̂nyõ, á yĩn nɛ n gbilki. ");
INSERT INTO wib_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Á yõ̀tɔ̃rɩ́ wɛ̃kɩ. Wáh mɛ nɛ̂ tyɩ́, képah nɛ n pɩ sétáh yõ, sɔ̃́-á kélɛ yĩ̂nyõ. ");
INSERT INTO wib_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Á kwɛy gbĩ̀yĩ̀kì yõkelɛ á kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ápi-á pɩ de áwɔ tyɩ́ tyi nónó sɔkɔ, sè yɔ̃ n mɔ á kɔ̃, sɔ̃́-á ápi tɔ yɔ̃ mɔ névye kɔ̃, nónó-á pɩ de á tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Káh n yɛ à sétã̀n yõ̀tɛ̃̀ tɔ̃̀nmɔnɔlɛ n fɛ̃ n syi. Ǹtɛ á pwah n mɔ ǹ gbõ̀, ǹmɔ nɛ̂ tyɩ́-á pèkè pɩ́nɔ́ sõ n wil. Yõ̀tɔ̃rɩ́, ànɛ̂ tɛ̃́nwɛnɔ, ànɛ̂ gbílkínɔ́lɛ, áwɔ tyɩ́ ye gbĩ́mɛgbĩ́. Amiina! ");
INSERT INTO wib_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Névye nónó-á n pɩ n de yé tyɩ́, yâh n yɔ̃ n mɔ pélɛ n kɔ̃, yé Sú Liyel nɛ̂-á yĩ̂nyõ, à kɩ n yɔ̃ n mɔ yé tɔlɛ n kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ǹtɛ yépi-à névye tyípêllɛ n yɔ̃ n mɔ pélɛ n kɔ̃́-ńkɛ̃̂nɛ, yé Sú Liyel náh yépi tɔ tyɩ́ yɔ̃ n mɔ yé kɔ̃ n pi. ");
INSERT INTO wib_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Yâh níkì tɛ̃, yé káh yé yey kwɔ n sah névye túkù tyɩ́ kɔ̃lɛ. Pépi ńkɛ̃́nɛ pé yey yõre n sah nɛ névye pɩ̃ nɛ páh mɛ níkì tɛ̃. Kègbɩ yõ mé kélɛ n yo yé tyɩ́, pè ye ké yõre wɛ tɛ. ");
INSERT INTO wib_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ǹtɛ áwɔ-à níkì tɛ̃, á yah wu, tɛ́ káh á yõ pɩ n sah yákárá, ");
INSERT INTO wib_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","névye kɔ̃ pè pɩ̃ nɛ wáh mɛ níkì tɛ̃. Tɛ́ á Sú Liyel nɛ̂-á sètĩ̀n sõ̀ tyilɛ n pnɛ, ǹmɔ kɩ ǹ dyah ké yõrelɛ. ");
INSERT INTO wib_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Yé káh tahrɩlɛ n yah n koh n sah kèkõyṍ mɛ̀ sɔkɔ, képah nɛ̂ sɔkɔ-á sóhrɩ́ ànɛ̂ syɩ̃́mɩ́ kɩ fɛ̃ sélɛ n yõ, képah náh pɩ yɩ̃́pú kɩ fɛ̃ kye de vɩ̀ sɔkɔ kɩ sè yɩ̃ tɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ǹtɛ yé tahrɩlɛ n yah n koh n sah yĩ̂nyõ, képah nɛ̂ sɔkɔ-á sóhrɩ́ ànɛ̂ syɩ̃́mɩ́ náh mɛ sé yõ yõ tɛ̃̀nɛ, yɩ̃́pú tɔ náh mɛ kɩ fɛ̃ kye de vɩ̀ sɔkɔ, képah náh pɩ kɩ yɩ̃be yɩ̃. ");
INSERT INTO wib_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Á náh wɛ di, á tahrɩ-à mɛ ńyãh, á sõnɔ tɔ kɩ mɛ nɛ́npɔ́. ");
INSERT INTO wib_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Wil kyòolɛ, yɩ̃́ ye. Á yɩ̃́-à mɛ vyelɛ, á wil pól kɩ mɛ kyòo sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ǹtɛ á yɩ̃́-à yɩkɩ, á wil pól kɩ mɛ fɛ̃́ntũ̂ sɔkɔ. Kyòo nɛ̂-á á sɔkɔ, kàh kɩ mɛ fɛ̃́ntũ̂nɛ, á mɛ yĩ́ĩ́ fɛ̃́ntũ̂ pbèy sɔkɔ dɛ́. ");
INSERT INTO wib_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Névi yɔ́ ńtɛ̃ náh fɛ̃ tõ̀ kwrɔ n pɩ n pi yõ̀tãm nɛ́pĩ̂ nímí tyɩ́. À kɩ núkú dyɔlɛ n yɔ, tɛ́ kɩ nɔ ǹ ní-òlɛ. Képah náh pɩ, à kɩ núkúlɛ n tĩnki, tɛ́ kɩ ǹ ní-ò wɛ mɔ. Sɛ̃́ ó ye, yé náh fɛ̃ tõ̀ kwrɔ n pɩ n pi Liyel ànɛ̂ pɔ́ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Képah ye ń kɔ̃ mé kélɛ n yo yé tyɩ́ nɛ, yé káh yé fɔkɔlɛ n sõ yáh nɛ wɛ n yõ tɛ́ wɛ n wɔ n pi sɔ̃́, tɛ́ kɩ mɛ min sɔkɔ, ànɛ̂ yáh nɛ yé wil flɔ wɛ n mɔ n pi sɔ̃́. Névi min tyɩ́ náh tah kal yõkelɛ di? Wil tɔ tyɩ́ náh tah kal flɔlɛ di? ");
INSERT INTO wib_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Yé yah kèpyelɛ yĩ̂nyõ sɔkɔ kɛ̀; sè náh sèmukɔlɛ n duku, sè náh sèmukɔlɛ n tɔkɔ; sè náh se mó tɔ̃ sèmukɔlɛ n koh n sah díké sɔkɔ; tɛ́ yé Sú Liyel sélɛ n pu. Ǹtɛ yépi náh fṍnfṍ kal kèpye yõ náhnáh di? ");
INSERT INTO wib_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Yépi sɔkɔ nɛ̂ tɛ̃̀ kɩ fɛ̃ kwéy ńtɛ̃ fyé dohnɩ ǹ gblɔ̌y min yõ, ǹ fɔ́kɔ́sõnɔ gbõ̀ yõ? ");
INSERT INTO wib_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ǹtɛ kwâh nɛ̂ fɔkɔ sõnɔ mɛ yé tyɩ́ yé mɔ mɔ flɔ tyɩ́ sɔkɔ wɛ́? Yé yah fílkì fĩ pɩ dùkùlɛ swɛ̃y sɔkɔ kɛ̀: Sè náh tõ̀lɛ n pɩ, sè náh se mó tɔ̃ flɔlɛ n tĩ. ");
INSERT INTO wib_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ǹtɛ mé kélɛ n yo yé tyɩ́ nɛ, yõ̀tɛ̃̀ dĩ́ Salomo tàh fyé yah yõ, à náh flɔ wɛ mɔ yah nónó-á plɛ nɔ fílfĩ nɔ́pi sɔkɔ yɔ́ ńtɛ̃nɛ. ");
INSERT INTO wib_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Liyel yõ sɛ̃́nyĩ-ńkɛ̃̂pú nɔ́pi. Fílkì nɛ̂-á swãh sɔkɔ kwɛynɛ, tɛ́ kɩ pɔ n sukɛ n pi ńsõ̂nɛ, Liyel-á képah fĩ pɩ pallɛ sɛ̃́ à, yépi wɔ se pyě à kɩ yɛ kóhnmɔnɔlɛ kal plɛ́ntnɔɔ? ");
INSERT INTO wib_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Yé káh yé fɔkɔlɛ n sõ yè pɔ nɛ n yo nɛ, kwâh nɛ̂ se yé kɩ wɛ yõ nɩ? Kwâh nɛ̂ se yé kɩ wɛ wɔ nɩ? Kwâh nɛ̂ se yé kɩ wɛ mɔ yé wil sɔkɔ nɩ? ");
INSERT INTO wib_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Yé náh wɛ di, Liyel pɩ̃́-ńkɛ̃̂pú ye ńkɛ̃́nɛ nɛ n yah n kɔ̃ sépi póllɛ tyɛ́tyɛ́nɩ́ kɛ̃́nɛ. Ǹtɛ yé Sú nɛ̂-á yĩ̂nyõ, à pɩ̃ nɛ yî nɔ́pi pól yétõ̂-á mɛ yé tɛ̃ dò. ");
INSERT INTO wib_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Yé Liyel tɔ̃́rɩ́ ǹgbò yah n kɔ̃, ànɛ̂ wǎh mɛ nɛ̂ tyɩ́. Képah sɔkɔ, à kɩ yî tɛ́lɔ́ tɔ pól dohnɩ yé kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Yé káh yé fɔkɔlɛ n sõ ńsõ̂ tyɩ́ sɔkɔ. Yé ńsõ̂ tyi sah ńsõ̂ yah. Swɔ̃ swɔ̃ pól ànɛ̂ sé yṍtyí ye. ");
INSERT INTO wib_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Yé káh nolɛ n tuke. Képah sɔkɔ, Liyel náh yé tɔ tuke n pi. ");
INSERT INTO wib_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Yé náh wɛ di, yáh no tɛ́lɔ́lɛ n tuke sɔ̃́, sɛ̃́ ye Liyel kɩ n tuke n pi yé tɔlɛ. Yáh no tɛ́lɔ́ tyɩ́lɛ n sãh dú nɛ̂nɛ, yé tɔ tyɩ́ kɩ n sãh n pi kénɛ dú ólɛ. ");
INSERT INTO wib_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Á pɩ sɔ̃́ tɛ́ ǹdan wɛ á yṹnpi yĩ́ sɔkɔ, tɛ́ dàhnpɛlɛ áwɔ yĩ́ sɔkɔ, á náh mɛ képah wɔ pɩ̃? ");
INSERT INTO wib_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Á kɩ pɩ sɔ̃́, tɛ́ kɩ yo á yṹnpi tyɩ́ nɛ, à yɛ á ǹdan wilki à kɔ̃ ǹ yĩ́ sɔkɔ, tɛ́ dàhnpɛ mó tɔ̃ mɛ áwɔ yĩ́ sɔkɔ? ");
INSERT INTO wib_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Fɔ̀kɔ̀pǐl névi. Á yĩ́ sɔkɔ dàhnpɛ ǹgbò wilki. Képah-à pɩ, á kɩ fɛ̃ n yah pallɛ kɩ á yṹnpi yĩ́ sɔkɔ ǹdan wilki. ");
INSERT INTO wib_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Yî nónó-á mɛ Liyel tyɩ́ yõ, yé káh sélɛ névyelɛ n kɔ̃ nónó-á mɛ pãhlɔ tyɩ́ kɔ̃lɛ, pè kɔ̃ pè káh n pɔ pé yey vi yé tyɩ́ képékèyɔ̂. Yé káh mó tɔ̃ yî kètǎrnɔlɛ névyelɛ n kɔ nónó-á mɛ slo tyɩ́ kɔ̃lɛ, pè kɔ̃ pè káh n pɔ n suki n sɔkɔ sé yõ. ");
INSERT INTO wib_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Yé nɛ n ni, yé kɩ n wɛ n syi. Yé nɛ n yah n kɔ̃, yé kɩ n wɛ. Yé wùkahlɛ n mɩ, kè kɩ n yɩkɩ n mɔ yélɛ n kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Yé náh wɛ di, nɛ̂-à ni Liyel tyɩ́, tɛ̃̀ n wɛ n syi. Nɛ̂-à yah kɔ̃, tɛ̃̀ n wɛ. Nɛ̂-à wùkah mɩ, kè n yɩkɩ n mɔ tɛ̃̀ kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Nɛ̂ tɛ̃̀ mɛ yépi sɔkɔ, ǹ pídĩ́-à búrn ni ǹ tyɩ́ à kɩ dáhkɩ̀lɛ à kɔ̃? ");
INSERT INTO wib_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Képah náh pɩ, wàh yɛ̃́nkɔ̂ ni ǹ tyɩ́, à kɩ wahynɛ à kɔ̃? ");
INSERT INTO wib_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Yépi nónó-á nɛ́pêllɛ, yé yé wɛ̃́npì kɔ̃́nɔ́ yah wɛ yípéplɔlɛ. Tɔ̀tɔ̀ náh mɛ ké sɔkɔ, yé Sú Liyel nɛ̂-á mɛ yĩ̂nyõ sɔkɔ, ǹmɔ kɩ yîlɛ sé nípú kɔ̃ nónó-á plɛ kal yépi tyɩ́lɛ dò. ");
INSERT INTO wib_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Yáh mɛ ké tyɩ́ nɛ no tyi nónó póllɛ n pɩ yé tyɩ́, yépi tɔ sɛ̃́nknɔlɛ n pɩ pé tyɩ́. Sɛ̃́ ye tyi kõ̀nsàhnɔ́ ànɛ̂ Liyel tɛ̃ntõ̀ syínyopu sɛ́bɛ́ynɔ́ yo kélɛ. ");
INSERT INTO wib_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Yé nɛ n de dé-ńsah fɩ̃́ɩ̃lɛ. Yé náh wɛ di, wɛ̃̀kɩ̀ nɛ̂-á n yuku tyɩ́ yɩ́kɩ́nɔ́ tɛ̃̀-ǹsah, ké kɔ́lɔ́ mɛ fàhfàh, ké dé-ńsah mɛ wòo. Képah sɔkɔ dépú mɛ dò. ");
INSERT INTO wib_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ǹtɛ wɛ̃̀kɩ̀ nɛ̂-á n yuku tyɛ́-ńkɛ̃̂ min tɛ̃̀-ǹsah, ké kɔ́lɔ́ mɛ táhnɔ́lɛ, ké dé-ńsah mɛ fɩ̃́ɩ̃. Ké wɛ́ndepu náh mɛ fwɔ́ɔ. ");
INSERT INTO wib_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Yé yé gblɔ̌ynɛ n kyɔmɩ Liyel yĩn yõ mɩ̀nyobelɛ. Pàh n pi yé tyɩ́, pě pé gblɔ̌y pɩ mámm képyɛ́nɩ̀ tyɩ́ kɔ̃lɛ, tɛ́ ké kègbɩ tɛ̃̀ yõ sɔkɔ, pè mɛ pékénɔ́lɛ gbɛ̃́npãhlɔ sɔ̃́. ");
INSERT INTO wib_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Yé kɩ pè pɩ̃ n pi pé tyípɩ́nɔ́ sɔkɔ. Yɛ̀rɛsɛ̃̂ náh fɛ̃ n wɛ n gbɛ kahrɩ sɔkɔ. Sènsóké pye tɔ náh mó fɛ̃ n wɛ n gbɛ gbɩ́yɛ̃́kɩ̀ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Sésân pèplɔ pól n syi pye pèplɔlɛ. Tɛ́ séswɔ́ntùkù wɔ mó n syi pye túkúnìnɛ. ");
INSERT INTO wib_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Séswɔ̂ pèpɛy náh fɛ̃ n syi pye túkúnìnɛ. Séswɔ́ntùkù tɔ náh mó fɛ̃ n syi pye pèplɔlɛ. ");
INSERT INTO wib_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Séswɔ̂ nɛ̂-à n syí-ńkɛ̃̂nɛ pye pèplɔlɛ, kè n kãm ǹ min n dah n mɔ nyàh sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Sɛ̃́ ó ye yé kɩ n pɩ̃ n pi Liyel yĩn yõ mɩ̀nyobelɛ pé tyípɩ́nɔ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Kè náh pɩ nɛ nónó pól-á ńmɔlɛ n ye Tɛ̃̀ ǹgbɛ̃, TƐ̃̀ ǸGBƐ̃NƐ pé pól sɔ̃́ kɩ Liyel tɔ̃́rɩ́ nɔlɩ yõ n pi dɛ́. Ń Sú Liyel nɛ̂-á mɛ yĩ̂nyõ, ǹmɔ-á mɛ nɛ̂ tyɩ́, képah pɩ́pú ó ye kɩ yõ ké nɔlɩlɛ. ");
INSERT INTO wib_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Liyel tukey tuke sõlɛ, névye náhnáh kɩ n yo n pi ń tyɩ́ nɛ, Tɛ̃̀ ǹgbɛ̃, Tɛ̃̀ ǹgbɛ̃, ńmɔ yĩn yõ kó lésõ pé n syi n yo Liyel tɛ̃ntõnènɛ nɩ? Ńmɔ yĩn yõ kó lésõ pè n nɛ n yĩni n wilki sétã̀nnɛ névye sɔkɔ nɩ? Ńmɔ yĩn yõ kó lésõ pè n nɛ n pɩ gbǐlnɔ́ náhnáhlɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ǹtɛ mé kɩ yo pé tyɩ́ nɛ, mé náh pélɛ n pnɛ póllɛ. Pè gbɛ mɔ ńnɛ, Liyel tyi kõ̀nsàhnɔ́ dêl pɩ́pú nɔ́pi. ");
INSERT INTO wib_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Képah ye, névi nɛ̂-á ń wɛlɔ nɔ́pi noh, tɛ́ mɛ sé tyíyónɔ́lɛ n pɩ, tɛ̃̀ mɛ á kɩ nɛ lékã́m névi yɔ́ sɔ̃́, nɛ̂-á ǹ wɔ̀kɔ̀ mɔ légbɩ̃́ yõ. ");
INSERT INTO wib_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Pũ̀ mɛ pɔ pɩ, yrɛy yuku à kwɔkɩ kyɩ syɩ kénɛ wɔ̀kɔ̀ tyɩ́, pṹnyã́hkɩ́ tɔ mɛ kõ kyɩ mɩ ké sɔkɔ, ǹtɛ kǎh sõ̀ sõ légbɩ̃́ yõ sɛ̃́, képah ye kè náh syɩkɩ. ");
INSERT INTO wib_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ǹtɛ névi nɛ̂-á ń wɛlɔ nɔ́pi noh tɛ́ à náh mɛ sé tyíyónɔ́lɛ n pɩ, tɛ̃̀ mɛ á kɩ nɛ lékã́m kɛ̃́ névi yɔ́ sɔ̃́, nɛ̂-á ǹ wɔ̀kɔ̀ mɔ sèmìyã́hrɩ́ yõ. ");
INSERT INTO wib_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Pũ̀ mɛ pɔ pɩ, yrɛy yuku à kwɔkɩ kyɩ syɩ kénɛ wɔ̀kɔ̀ tyɩ́, pṹnyã́hkɩ́ tɔ mɛ kõ kyɩ mɩ ké sɔkɔ, kè mɛ syɩkɩ à pirki kwɛ pnɛ́pnɛ́. ");
INSERT INTO wib_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Képah sɔkɔ, Yesu-á kwɔ́nɔ́ nɔ́pi kɔ̃ tɛ gbĩ́ nɛ̂nɛ, tɔ́wû gbã̀n du ǹ névye kwɔ́nɔ́ dùkùlɛ. ");
INSERT INTO wib_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Yé náh wɛ di, ǹ névye kwɔ́nɔ́ dùkù náh sõ̀ mɛ Liyel tyi kõ̀nsàhnɔ́ kwɔ́pú tyɩ́ kɔ̃lɛ dɛ́, kè sõ̀ mɛ yõ̀tɔ̃rɩ́ kwɔ́nɔ́lɛ képah ye. ");
INSERT INTO wib_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu-á wil yɔ̃lɩ yõ à tiki pɔ gbĩ́ nɛ̂nɛ, tɔ́wû ǹgbɛ̃ ǹ sõ̀ tɛ̃. ");
INSERT INTO wib_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Tótɛ̃ yɔ́ mɛ nɔ de à gbètukunɔ di ǹ yah sɔkɔ, tɛ́ yo ǹ tyɩ́ nɛ, pé Tɛ̃̀ ǹgbɛ̃, wàh mɛ ké tyɩ́ wǎh kɩ fɛ̃ pé dɛ mɔ pé kɔ̃ pé pɩ yályál Liyel yah. ");
INSERT INTO wib_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Wǎh yo sɛ̃́, Yesu mɛ ǹ gbõ̀ nɔ à tũ ǹ tyɩ́, tɛ́ yo ǹ tyɩ́ nɛ: «Mé mɛ ké tyɩ́, á kɩ dɛ.» Nɛ́npɔ́ swɔ, dĩ́ dú ńyân núkú tyɛ. ");
INSERT INTO wib_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Képah sɔkɔ, Yesu mɛ yo ǹ tyɩ́ nɛ: «Káh yĩ mɛ̀ yãh nɛy tyɩ́ dɛ́. Tɛ́ kyɩ á gblɔ̌ynɛ sárká syínwìlkì-ò wɛ̃kɩ. Moyisi-á sõ̀ sárká nɛ̂ tyɩ́ yo sah tótãm dɛ́nmɔnɔ tyɩ́ sɔkɔ, kyɩ képah wilki, nɛ̂-á kɩ kélɛ pè wɛ̃kɩ nɛ wáh dɛ.» ");
INSERT INTO wib_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Tɛ́ Yesu-á pɔ de Kapɛrnayumi sɔkɔ gbĩ́ nɛ̂nɛ, Wrome sràsyíbí yõ̀tɛ̃̀ dĩ́ yɔ́ pɔ ǹ tnɔ̂ tɛ́ à ni ");
INSERT INTO wib_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","nɛ, pé yõ̀tɛ̃̀, pé tõ̀npɩ dĩ́-á mɛ sɛ̃́nɔ́lɛ gbô sɔkɔ wil kúnɔ́ ńyânnɛ ǹ sɔkɔ. Wǎh mɛ n kwlɔ képékèyɔ̂. ");
INSERT INTO wib_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Képah sɔkɔ, Yesu mɛ yo ǹ tyɩ́ nɛ páh kɩ ǹ sõ̀ tɛ̃ kyɩ à dɛ mɔ. ");
INSERT INTO wib_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ǹtɛ kénɛ dĩ́ mɛ yo Yesu tyɩ́ nɛ, pé yõ̀tɛ̃̀, péwɔ-á fṍrɔɔ kah ǹ dénɔ́lɛ pé gbô sɔkɔ. Ńkɛ̃́ à wɛy núkú ó yo, tɛ́ pé tõ̀npɩ-á kɩ dɛ. ");
INSERT INTO wib_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","À kó wɛ nɩ, yõ̀tãm-á mɛ péwɔ tyɩ́, tɛ́ péwɔ tɔ mó mɛ sràsyíbí yísyɔ́ yõ̀tɛ̃̀nɛ. Pâh yo nɛ̂ tyɩ́ nɛ, à sɔkɔ! Tɛ̃̀ n sɔkɔ. Pâh yo nɛ̂ tyɩ́ nɛ, à pɔ! Tɛ̃̀ n pɔ. Pâh yo pé yɔ̃̀ tyɩ́ nɛ, à tir mɛ̀ pɩ! Ǎ kè pɩ. ");
INSERT INTO wib_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Képah sɔkɔ, Yesu-á kénɛ wɛlɔ noh sɛ̃́, sè ǹ gbã̀n kah du. À mɛ yo ǹ sõ̀ tɛ̃́pú tyɩ́ nɛ: «Kègbɩ yõ mé kélɛ n yo yé tyɩ́, mé náh Liyel yõ sɛ̃́nɔ́ ǹgbɛ̃ mɛ̀ dùkù névi wɛ yah Yisrayel no ńtɛ̃ fyé sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Tɛ́ mé kélɛ n yo yé tyɩ́ nɛ, névye náhnáh-á kɩ wil ywɔ̃ ywɔ̃ póllɛ, kɩ pɔ yõke yõ wɛ̃ tyɩ́ Abrahmɩnɛ, ànɛ̂ Yisakɩlɛ, ànɛ̂ Nsyakɔbɩlɛ Liyel tɔ̃́rɩ́ tyah sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ǹtɛ Yisrayel no nónó-á sõ̀ yɩ̃nɛ dénɔ́lɛ Liyel tɔ̃́rɩ́ tyah sɔkɔ, pépi kɩ wũ kégbɔ́ fɛ̃́ntũ̂ sɔkɔ, ńyãh sɔkɔ-á gbní ànɛ̂ yní táhnɔ́ kɩ mɛ.» ");
INSERT INTO wib_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Képah tɛ̃̀nɛ, Yesu ǹ syɩ yo sràsyíbí yõ̀tɛ̃̀ dĩ́ mɛ̀ tyɩ́ nɛ: «Á syɩ nɛ n yuku á tĩ̀nnɛ. Wáh sɛ̃ ńmɔ yõ sɛ̃́, wáh nɛ̂ yah kɔ̃, kè kɩ pɩ á tyɩ́.» Nɛ́npɔ́ swɔ, ǹ tõ̀npɩ dĩ́ núkú dɛ. ");
INSERT INTO wib_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Képah náh, Yesu kyɩ Pyɛrɩ gbô, tɛ́ kyɩ Pyɛrɩ dɛ́nsê wɛ sɛ̃́nɔ́lɛ wílvyã́hnɩ̀nɛ. ");
INSERT INTO wib_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yesu mɛ tũ pi gbõ̀ tyɩ́, wílvyã́hnɩ̀ núkú à fĩn mɔ. Képah tɛ̃̀nɛ, pi mɛ yuku tyah n yah n dah n mɔ Yesu tyɩ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Gbĩ́yĩ́-á de, no pɔ névye náhnáhlɛ Yesu tyɩ́ sétã̀n-á sõ̀ mɛ dénɔ́lɛ nónó sɔkɔ. À mɛ ǹ vyãh wɛynɛ sétã̀n nɔ́pi yĩni wilki pé sɔkɔ, tɛ́ yámpú tɛ́lɔ́ pól dɛ mɔ. ");
INSERT INTO wib_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","À képah pɩ Liyel tɛ̃ntõ̀ syínyo-ò Yesayi tir yónsàhnɔ́ mɛ̀ kɔ̃ kè wil. À lésõ nɛ ńkɛ̃́: «À ye á yèvyãhrɩnɔ pól tɔkɔ to á yõ, tɛ́ á yamnɔ pól tyɛ.» ");
INSERT INTO wib_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesu-á tɔ́wû ǹgbɛ̃ wɛ pè pɔ à mɔ gbɩ̃ sɛ̃́, à nɛ pé tõ̀ sã́hpú àwɔ pé yuku yɔ́-ǹgbɛ̃ kahnɩnɛ. ");
INSERT INTO wib_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Képah sɔkɔ, Liyel tyi kõ̀nsàhnɔ́ kwɔ́-ò yɔ́ nɔ de ǹ tnɔ̂ tɛ́ yo ǹ tyɩ́ nɛ, kwɔ́-ò dĩ́, páh kɩ ǹ sõ̀ tɛ̃ n kɔ n kɔ̃ ǹnɛ ǹ yúkú-ńtã̂n pól sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Wǎh yo sɛ̃́, Yesu mɛ yo ǹ tyɩ́ nɛ: «Gbɛ̃́npãhlɔ tyɩ́ pɩ̃̀ mɛ. Kèpye tyɩ́ syɛ̀ mɛ. Ǹtɛ Névi Pídĩ́ tɛ̃̀ tyɩ́, wɛ́nsɛ̃nmɩ̀-ǹsah ńtɛ̃ náh mɛ.» ");
INSERT INTO wib_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Képah tɛ̃̀nɛ, ǹ tõ̀ sã́hpú sɔkɔ yɔ́ tɔ̃ à syah nɛ, kwɔ́-ò dĩ́, à yɛ pâh pɔ pé sú lékó ǹgbò yɩ̃ tɛ. ");
INSERT INTO wib_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yesu mɛ yo ǹ tyɩ́ nɛ: «Ńmɔ sõ̀ tɛ̃, ǹ tɛ́ n yɛ nɛ́kyɩ̂ kɔ̃ pè pé lékyɩ̂lɛ n yɩ̃.» ");
INSERT INTO wib_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Képah sɔkɔ, Yesu de krótókè sɔkɔ ànɛ̂ ǹ tõ̀ sã́hpúlɛ pè sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Dǒ yã́hpékè yɔ́ núkú kõ yɔ́-ǹgbɛ̃ yõ sɔkɔ, fɔ́ɔ́ krótókè yõ n tyah yɩ̃́nɔ́lɛ ni sɔkɔ. Ǹtɛ Yesu wɔ sõ̀ mɛ n dɔ. ");
INSERT INTO wib_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Képah sɔkɔ, ǹ tõ̀ sã́hpú nɔ de ǹ tnɔ̂ mɛ kyɩ ǹnɛ n yilki n mɔ nɛ ńkɛ̃́, Tɛ̃̀ ǹgbɛ̃, à pé pwah mɔ oo! Yɔ-á mɛ n tyah pé yṍnɔ́lɛ dɛ́! ");
INSERT INTO wib_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesu mɛ yo pé tyɩ́ nɛ: «Kwâh nɛ̂ pɩ tɛ́ tíkí yé tɛ̃? Liyel yõ sɛ̃́nyĩ-ńkɛ̃̂pú nɔ́pi.» Képah tɛ̃̀nɛ, à yuku à dírí kõ yã́hkɩ́ ànɛ̂ ni yõ, tyah núkú pɩ sṹmm. ");
INSERT INTO wib_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Képah tɛ̃̀nɛ, kè kah pɩ gbɛ̃̀ndùnìnɛ pé tyɩ́. Pè mɛ tyah yo tũ wɛ̃ tyɩ́ nɛ, nɛ́dúkú nɛ̂ se dĩ́ mɛ̀nɛ tɛ́ yã́hkɩ́ ànɛ̂ yɔ tɔ n sah ǹ tyɩ́ yõ nɩ? ");
INSERT INTO wib_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Képah sɔkɔ, Yesu-á kyɩ yĩni tɛ̃ yɔ́-ǹgbɛ̃ kahnɩnɛ Kadarɩ tãn sétáh yõ gbĩ́ nɛ̂nɛ, díbí nɛ́pĩ̂ nímí mɛ wil léyã̂l wrɔ́ sɔkɔ à pɔ à yohnɩ sétã̀nnɛ pé sɔkɔ. Pé pékénkàhnɔ́ tɛ̃̀ tyɩ́, nɛy náh sõ̀ mɛ fɛ̃ n sɔkɔ nɛ́npɔ́ wɛ̃̀kɩ̀lɛ. ");
INSERT INTO wib_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Pǎh pɔ à yohnɩ, pè tyah n de n syi nɛ, Liyel Pídĩ́, kwâh nɛ̂ se à n yah n kɔ̃ pé tyɩ́ nɩ? À se pɔ ásõ̂ pépi fõh yĩnnɛ ké gbĩ́ nɔ́-ńkɛ̃̂ sɔkɔ nɩ? ");
INSERT INTO wib_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Tɛ́ kè sõ̀ pɔ yɩ̃nɛ sel kwĩnki yísyɔ́ mɛ n yah n yõ n kɔ̃ fɩ́ɩ́ kwéy pélɛ. ");
INSERT INTO wib_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Sétã̀n nɔ́pi mɛ Yesu ni nɛ, wàh kɩ sé yĩni wilki díbí nɔ́pi sɔkɔ, à yɛ sé kɔ̃ sé kyɩ n de sel nɔ́pi sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesu mɛ nɛ, sè nɛ n yuku. Sè núkú wil díbí nɔ́pi sɔkɔ à kyɩ de sel nɔ́pi sɔkɔ. Sel nɔ́pi pól núkú wil yɔ̃lɩ yõ̀tah, à to tiki tùkùtùkù à kyɩ de yɔ sɔkɔ à ku. ");
INSERT INTO wib_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Képah tɛ̃̀nɛ, sel nɔ́pi fɛ̃̀pu mɛ to de kwil sɔkɔ, à kyɩ tyi nɔ́pi pól yãh no tyɩ́, à tahlɩ tir nɛ̂-á pɩ díbí nɛ́pĩ̂ nímí nɔ́pi tyɩ́ sétã̀n-á sõ̀ nónó sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Képah sɔkɔ, kwil tãn pól wil kyɩ Yesu yohnɩ. Pǎh fyɔ̀ à wɛ, pè à ni nɛ à yal pépi sétáh yõ. ");
INSERT INTO wib_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Képah sɔkɔ, Yesu de krótókè sɔkɔ à ǹ syɩ yɔ́-ǹgbɛ̃ kah à sɔkɔ ǹ kwil sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Nósyɔ́ mɛ sèkùkù dĩ́ yɔ́ twah sɛ̃ sɛ̃ kwâh yɔ́ yõ à pɔ ǹ tyɩ́. Wǎh kè wɛ pè sɛ̃ ǹ yõ sɛ̃́, à yo sèkùkù dĩ́ mɛ̀ tyɩ́ nɛ: «Káh n yɛ á yáh-ńsah tyɛ ń pídĩ́. Á tyípêl pɩ́nɔ́ ye yɔ̃ mɔ ǹ kɔ̃.» ");
INSERT INTO wib_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Képah tɛ̃̀nɛ, Liyel tyi kõ̀nsàhnɔ́ kwɔ́pú yísyɔ́ tyah n sõ nɛ, dĩ́ mɛ̀-á mɛ n yo n de Liyel tyɩ́ dɛ́. ");
INSERT INTO wib_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ǹtɛ Yesu-á pé sõnɔ pɩ̃ sɛ̃́, à yo pé tyɩ́ nɛ: «Kwâh nɛ̂ pɩ tɛ́ sõnɔ túkúnìnɛ yé sɔkɔ sɛ̃́? ");
INSERT INTO wib_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Mâh yo sèkùkù dĩ́ mɛ̀ tyɩ́ nɛ: ‹Á tyípêl ye yɔ̃ mɔ.› Képah náh pɩ, mâh yo ǹ tyɩ́ nɛ: ‹Yuku nɛ n kɔ.› Dlo mɛ nɛ̂ tɛ̃̀ yónɔ́ sɔkɔ kal? ");
INSERT INTO wib_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ǹtɛ mé kɩ tir yɔ́ pɩ yé kɔ̃ yé kɩ pɩ̃ nɛ, tɛ̃́nwɛnɔ-á mɛ Névi Pídĩ́ tyɩ́ sétáh yõ kɩ fɛ̃ tyípêl yɔ̃ mɔ.» Tɛ́ ǹ syɩ yo sèkùkù mɛ̀ tyɩ́ nɛ: «Yuku, á sɛ̃ sɛ̃ kwâh tɔkɔ ǹ nɛ n yuku á gbô.» ");
INSERT INTO wib_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Dĩ́ mɛ yuku à sɔkɔ ǹ gbô. ");
INSERT INTO wib_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Tɔ́wû-á képah tɛ̃̀ wɛ sɛ̃́, tíkí pè tɛ̃. Pè tyah Liyel yĩnnɛ n gbilki wǎh sɔ̃́npɩ́lɛ tɛ̃́nwɛnɔ mɛ̀ dùkùlɛ névye kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu-á yal nɛ́npɔ́ tɛ́ n sɔkɔ, à dĩ́ yɔ́ wɛ à mɛ kɔ̃ tɛ̃ mɔ́rɩ́lɛ n syi mɔ́rɩ́ syí-ńsah sɔkɔ, pè n ye Matyelɛ. Yesu mɛ yo ǹ tyɩ́ nɛ: «Ń sõ̀ tɛ̃.» À mɛ yuku ǹ sõ̀ tɛ̃. ");
INSERT INTO wib_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Képah náh, Yesu-á sõ̀ mɛ yõke yṍnɔ́ sɔkɔ Matye gbô, mɔ́rɩ́ syípú náhnáh ànɛ̂ Liyel wɛ̃̀kɩ̀ kɔ́-ńkɛ̃̂pú tɔ pɔ n yõ ǹnɛ wɛ̃ tyɩ́ ànɛ̂ ǹ tõ̀ sã́hpúlɛ. ");
INSERT INTO wib_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Farisi wɛ̃̀kɩ̀ kɔ́pú-á képah wɛ sɛ̃́, pè yo Yesu tõ̀ sã́hpú tyɩ́ nɛ, kwâh nɛ̂ se pɩ tɛ́ pé kwɔ́-ò dĩ́ n yõ mɔ́rɩ́ syípú ànɛ̂ Liyel wɛ̃̀kɩ̀ kɔ́-ńkɛ̃̂púlɛ wɛ̃ tyɩ́ nɩ? ");
INSERT INTO wib_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ǹtɛ Yesu-á pé wɛy noh, à yo pé tyɩ́ nɛ: «Névye nónó-á mɛ lènɔlɛ, sènpɩ yétõ̂ se mɛ pé tyɩ́? Yámpú tyɩ́ náh ǹ yétõ̂lɛ di? ");
INSERT INTO wib_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Liyel-á nɛ̂ yo nɛ ńkɛ̃́: ‹Yâh wɛ̃ yãmnɛ n yah, képah tyɩ́ nɔ ńmɔ tyɩ́ kal yáh sárká nɛ̂nɛ n sukɛ ńnɛ n kɔ̃.› Yé kyɩ yé fɔkɔnɩ mɔ yah képah tyɩ́ sɔkɔ, yè ké kɔ́r pɩ̃. Yé náh wɛ di, névye nónó-á mɛ n sõ nɛ nɛ́gblɔ́-á pélɛ Liyel yah, mé náh pɔ pépi yé-ńsah dɛ́. Ǹtɛ nónó-á pɩ̃ nɛ tyípêl pɩ́pú-á pélɛ, pépi yé-ńsah ye mé pɔ.» ");
INSERT INTO wib_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Képah sɔkɔ, Wèlnwìlkì-ò Nsyɔ̃ tõ̀ sã́hpú nɔ de Yesu tnɔ̂ tɛ́ à syah nɛ, kè se pɩ sɔ̃́ tɛ́ pépi ànɛ̂ Farisi wɛ̃̀kɩ̀ kɔ́pú níkìlɛ n tɛ̃ tɛ́ ǹmɔ tõ̀ sã́hpú náh mɛ níkìlɛ n tɛ̃ nɩ? ");
INSERT INTO wib_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesu mɛ yo pé tyɩ́ nɛ: «Pǎh nónó ye fúr yõke yõ yĩnnɛ, pépi se kɩ fɛ̃ pé yey kwɔ sah pɛ mɛ gbĩ́nɛ pé nɩyṍ? Ǹtɛ sèpĩ̀n yísyɔ́ mɛ n pi, pɛ mɛ̀ kɩ pɔ n tɛ̃ n wilki n pi pé nɩyṍ. Légbĩ́nɛ, pè kɩ níkìlɛ n tɛ̃. ");
INSERT INTO wib_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ǹnɩ̂ yɔ́ ńtɛ̃ náh yɩ̃nɛ à fwɔ̀sãn kãm à fwɔ̀dyàh min. Yé náh wɛ di, fwɔ̀sãn mɛ̀ kɩ fwɔ̀dyàh mɛ̀ yɔrɩ tɔ, wãn ó kɔ̃ kè kɩ tɔ̃ mɔ ké tɔ́nɔ́ yõ. ");
INSERT INTO wib_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Dìvɛ̃ sã́n tɔ náh yɩ̃nɛ mɔ́nɔ́lɛ pley dî sɔkɔ. Wâh képah pɩ, dìvɛ̃ mɛ̀-à fũ, kè kɩ pley nɔ́pi sɔkɩ, dìvɛ̃ kɩ kwɛ, pley tɔ tyɩ́ kɩ yɩkɩ. Ǹtɛ kàh dìvɛ̃ sã́nnɛ, pley snɔ́ sɔkɔ ye kè n mɔ. Képah sɔkɔ, kèyǎh ńtɛ̃ náh n yɩkɩ.» ");
INSERT INTO wib_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu-á mɛ kénɛ wɛlɔlɛ n yo pé tyɩ́ gbĩ́ nɛ̂nɛ, Nsyifunɔ yõ̀tɛ̃̀ dĩ́ yɔ́ nɔ de ǹ tnɔ̂, tɛ́ gbètukunɔ di ǹ yah, tɛ́ yo ǹ tyɩ́ nɛ pé písê-á yah kwlɔ núkúnúkú sɛ̃́ yɔ̀. Ǹtɛ à pɔ kyɩ ǹ gbõ̀ sah ǹ yõ, wǎh kɩ min wɛ. ");
INSERT INTO wib_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Képah sɔkɔ, Yesu ànɛ̂ ǹ tõ̀ sã́hpú mɛ yuku dĩ́ sõ̀ tɛ̃. ");
INSERT INTO wib_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Tɛ́ kè pɔ yɩ̃nɛ sê yɔ́ sõ̀ mɛ náhlɛ n yɔ tyɛ́-ńkɛ̃̂nɛ ye gbɔ̃ninɔ́. Pi mɛ̀ mɛ nɔ de Yesulɛ ǹ náh tĩ̀nnɛ, à pɔ tũ ǹ fwɔ̀mɔnɩ vyãh tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Yé náh wɛ di, à sõ̀ mɛ n sõ ǹ fɔkɔ sɔkɔ nɛ páh kɩ tɛ̃ wɛ tũ ǹ fwɔ̀mɔnɩ ńtɛ̃ ó tyɩ́, páh kɩ dɛ. ");
INSERT INTO wib_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesu-á ǹ yah vi tɛ́ à wɛ, à yo ǹ tyɩ́ nɛ: «Káh n yɛ á yáh-ńsah tyɛ, ń písê. Á Liyel yõ sɛ̃́nɔ́ ye ǹ dɛ mɔ.» Nɛ́npɔ́ swɔ, pi núkú dɛ. ");
INSERT INTO wib_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Tɛ́ Yesu-á pɔ yĩni tɛ̃ Nsyifunɔ yõ̀tɛ̃̀ dĩ́ gbô, à yikɔ fɩ̃́bɩ́pú wɛ tɛ́ tɔ́wû wɛ pè mɛ n pɩ wrǒwrǒ. Képah sɔkɔ, à mɛ yo pé tyɩ́ nɛ: ");
INSERT INTO wib_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","«Yé wil ásõ̂. Pípír náh ku, dɔy sɔkɔ ye ǹnɛ.» Ǹtɛ pè sõ̀ mɛ kṍlɛ Yesulɛ n ko. ");
INSERT INTO wib_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Pǎh tɔ́wû wilki mɔ tɛ kégbɔ́ sɔkɔ, Yesu mɛ de yuku wɔ̀kɔ̀ sɔkɔ, tɛ́ pípír gbõ̀ sɔkɔ tɛ̃, pípír yuku. ");
INSERT INTO wib_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Yĩ mɛ̀ pɩ́nɔ́ tyɩ́ tyah n yãh kénɛ mara ywɔ̃ ywɔ̃ pól sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu-á yal nɛ́npɔ́ à n sɔkɔ gbĩ́ nɛ̂nɛ, yɩ̃́tũbi nɛ́pĩ̂ nímí yuku ǹ sõ̀ tɛ̃ tɛ́ mɛ yo tũ léyy nɛ, Davidi Pídĩ́, à pé yãm yah. ");
INSERT INTO wib_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesu-á pɔ yĩni tɛ̃ gbô sɔkɔ, yɩ̃́tũbi nɔ́pi mɛ nɔ de ǹ tnɔ̂. À mɛ pè piki yah nɛ, pè se sɛ̃ ké yõ nɛ péwɔ-á kɩ fɛ̃ pé yɩ̃́ yɩkɩ mɔ nɩ? Pè mɛ nɛ, àwe-á, Tɛ̃̀ ǹgbɛ̃. ");
INSERT INTO wib_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Képah sɔkɔ, Yesu tũ pé yɩ̃́ tyɩ́ tɛ́ nɛ: «Yáh sɛ̃ ńmɔ yõ sɔ̃́, tɛ́ nɛ̂ yah kɔ̃ ń tyɩ́, Liyel kè pɩ yé tyɩ́ sɛ̃́.» ");
INSERT INTO wib_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Képah tɛ̃̀nɛ, pé yɩ̃́ yɩkɩ mɔ. Yesu mɛ pè gbah sni nɛ, pè pé gblɔ̌y tɛ̃, pè káh n yɛ nɛy pɩ̃ ké sɔkɔ dɛ́! ");
INSERT INTO wib_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ǹtɛ pé wìlntɛnɔ ǹsɔ̃̀, pè kyɩ tyah Yesu yĩ́ngbɩ́lɛ n yo n kɔ̃ kénɛ mara pól sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","No nɔ́pi-á wil n sɔkɔ gbĩ́ nɛ̂nɛ, nósyɔ́ pɔ dĩ́ yɔ́lɛ Yesu tyɩ́, nɛ̂-á sétõ yɔ́ mɛ ǹ sɔkɔ à kɔ̃ à pɩ kèdɔ̀kɩ̀lɛ. ");
INSERT INTO wib_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yesu-á núkú sétõ mɛ̀ yĩni wilki dĩ́ mɛ̀ sɔkɔ, dĩ́ tyah n wɛkɩ. Kè pɩ gbɛ̃̀ndùnìnɛ tɔ́wû pól tyɩ́, pè mɛ yo tũ nɛ ńkɛ̃́, pépi náh ǹsɔ̃̀ntɛ̃̂ dùkù wɛ yah Yisrayel sɔkɔ póllɛ. ");
INSERT INTO wib_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ǹtɛ Farisi wɛ̃̀kɩ̀ kɔ́pú wɔ sõ̀ mɛ yo tũ nɛ, sétã̀n yõ̀tɛ̃̀ gbõ̀ yõ-á à n yĩni sétã̀nnɛ. ");
INSERT INTO wib_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu lésõ mɛ kwló-ǹgbnɔ ànɛ̂ kwlópî póllɛ n kɔ n kɔ̃, mɛ nolɛ n kwɔ Liyel ní-ńtã̂n vɩ̀ sɔkɔ, mɛ Nɩ̀vɩ̀nɩ̀ tirlɛ n yo Liyel tɔ̃́rɩ́ tyɩ́ yõ, tɛ́ mɛ yámpú pól ànɛ̂ nɛ́fukulɔ́ póllɛ n dɛ n mɔ. ");
INSERT INTO wib_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Yesu-á tɔ́wû nónó wɛ kwlɔ́nɔ́ sɔkɔ, tɛ́ pé yáh-ńsah mɛ tyɛ á kɩ nɛ yípɛ̂y sɔ̃́ fɛ̃̀-ò kɛ̃́nɛ sé tyɩ́, pé yãm à tɛ̃. ");
INSERT INTO wib_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Képah sɔkɔ, à yo ǹ tõ̀ sã́hpú tyɩ́ nɛ: «Sèmukɔ tɔkɔ tɔkɔ tɛ̃̀ mɛ dò, tɛ́ ké tõ̀npɩbɩlɛ kwéy. ");
INSERT INTO wib_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Kǎh pɩ sɛ̃́, Tɛ̃̀ ǹgbɛ̃ Liyel nɛ̂-á sèmukɔ nɛ́tɛ̃̂nɛ, yé à ni à tõ̀npɩbɩ tɛkɩ n mɔ sèmukɔ tɔkɔ yĩnnɛ.» ");
INSERT INTO wib_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Sõ yɔ́lɛ, Yesu ǹ tõ̀ sã́hpú nɛ́pĩ̂ gbɔ̃nimí ye pɔ, tɛ́ tɛ̃́nwɛnɔlɛ pè kɔ̃ nɛ pè sétã̀nnɛ n yĩni, pè mó yámpú póllɛ n dɛ mɔ, ànɛ̂ nɛ́fukulɔ́ póllɛ. ");
INSERT INTO wib_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Kénɛ nɛ́pĩ̂ gbɔ̃nimí nɔ́pi ye à pɩ ǹ tɛ̃ntõ̀ névyelɛ. Pé yni wɛ yɔ̀: Kè tyah Simo tyɩ́, nɛ̂-á pè yĩn dyɩ à kɔ̃ Pyɛrɩlɛ, ànɛ̂ ǹ gbɛ̃̀ndĩ́ Andrelɛ, à tahlɩ Nsyakɩ ànɛ̂ ǹ gbɛ̃̀ndĩ́ Nsyɔ̃ tyɩ́, pépi nónó-á Nsebede dĩ́npìlɛ, ");
INSERT INTO wib_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","à tahlɩ Filipi ànɛ̂ Bartelemi tyɩ́. Toma sõ̀ mɛ pé sɔkɔ ànɛ̂ Matyelɛ, nɛ̂-á sõ̀ mɔ́rɩ́ syí-òlɛ, à tahlɩ Alfe pídĩ́ Nsyakɩ tyɩ́ ànɛ̂ Tadɩlɛ, ");
INSERT INTO wib_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ànɛ̂ Simolɛ, nɛ̂-á sõ̀ sú fṍ vyãh syípú sɔkɔ yɔ́lɛ, à tahlɩ Nsyudasɩ Yisikariyɔtɩ tyɩ́ nɛ̂-á pɔ pɩ pè kɔ̃ pè Yesu tɛ̃. ");
INSERT INTO wib_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Nɛ́pĩ̂ gbɔ̃nimí nɔ́pi ye Yesu tõ tɛ́ kè gbah yo pé tyɩ́ nɛ: «Yé káh kyɩ névye tĩ̀nnɛ nónó náh pɩ Nsyifunɔlɛ, ànɛ̂ yé káh de Samari tãn kwil yɔ́ ńtɛ̃ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Yé nɛ n yuku Yisrayel no wɔ tĩ̀nnɛ, pépi nónó-á mɛ képyɛ́nɩ̀ mɔ́npunɔ tyɩ́ kɔ̃lɛ. ");
INSERT INTO wib_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Yáh kɩ n yuku wɛ̃̀kɩ̀ yõ, yé nɛ n yo n yuku nɛ, Liyel tɔ̃́rɩ́-á mɛ yĩni tɛ̃ tɛ. ");
INSERT INTO wib_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Yé yámpúlɛ n dɛ n mɔ. Yé lékyɩ̂lɛ n yilki n mɔ. Yé tótãmnɛ n dɛ n mɔ pé dú ńyân sɔkɔ, yè mó sétã̀nnɛ n yĩni n wilki névye sɔkɔ. Yáh wɛ syi nɔ̀nɔ́lɛ sɔ̃́, yé tɔ nɛ n kɔ̃ nɔ̀nɔ́lɛ sɛ̃́. ");
INSERT INTO wib_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Yé káh pɔ́ tɔkɔ dah mɔ yé yõ. ");
INSERT INTO wib_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Yé káh pley, ànɛ̂ fwɔ̀mɔlɔ ní-ònɔ́, ànɛ̂ lékyêh, ànɛ̂ lépló tɔkɔ kɔ́lɔ́ yĩnnɛ. Yé náh wɛ di, tõ̀npɩ yɩ̃nɛ ǹ tõ̀ pɩ́nɔ́ yõke yṍnɔ́lɛ. ");
INSERT INTO wib_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Yâh kyɩ de kwíl-ǹgbɛ̃ képah náh pɩ kwílpír nɛ̂ sɔkɔ, yé nɛ́gbɩ́ yah kɔ̃ yè twah tɛ̃̀ tyɩ́. Yé mó tɛ̃ tɛ̃̀ tyɩ́, fɔ́ɔ́ kè pɔ nɔ yé yálnɔ́ tyɩ́ kénɛ kwil sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Tɛ́ yâh kyɩ n de kéte nɛ̂ sɔkɔ, yé yo pé tyɩ́ nɛ yèvɩnɩ nɛ mɛ pé yõ. ");
INSERT INTO wib_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kénɛ kéte tãn-à fɛ̃ syi yé twah pé tyɩ́, yèvɩnɩ mɛ̀ kɩ mɛ pé yõ. Ǹtɛ pàh yahle, yèvɩnɩ mɛ̀ kɩ ké syɩ pɩ yé tyɩ́lɛ. ");
INSERT INTO wib_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Yâh de gbô nɛ̂ sɔkɔ képah náh pɩ kwil nɛ̂ sɔkɔ, tɛ́ pè yahle nɛ yé káh twah pé tyɩ́, tɛ́ yahle yé wɛy nóhnɔ́lɛ, yâh n yal, yé yé gbyẽ̂h nɛ̀ngbɔ̃ kwer n kwɛ nɛ́npɔ́. ");
INSERT INTO wib_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Kègbɩ yõ mé kélɛ n yo yé tyɩ́, Liyel tukey tuke sõlɛ, Sodɔmɩ kwil ànɛ̂ Gbomɔrɩ kwil fṍhnɔ́ ńtɛ̃ náh n peke n nɔ n pi kénɛ kwil tyɩ́lɛ.» ");
INSERT INTO wib_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«Yé yah, yé mɛ á kɩ nɛ képyɛ́nɩ̀ sɔ̃́ ńmɔ n tɛkɩ n mɔ gbɛ̃́npãhlɔ nɩyṍ. Yé nɛ mɛ lékã́m névyelɛ áswɔ̃́ plɛ́y tyɩ́ kɔ̃lɛ, yé fɔkɔ mó nɛ mɛ pérpér tìtí sɔ̃́. ");
INSERT INTO wib_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Yé yé gblɔ̌ynɛ n kyɔmɩ névyelɛ dɛ́. Pè kɩ yélɛ n tɛ̃ n tuke n pɔ tukey tùkè-ǹtã̀n sɔkɔ, tɛ́ kɩ yélɛ n ko yèfõhlɛ Liyel ní-ńtã̂n vɩ̀ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Pè kɩ yélɛ n tɛ̃ n kyɩ n pɔ kwíltãm yõ̀tãm ànɛ̂ yõ̀tãm tyɩ́ ńmɔ yĩnnɛ. Képah sɔkɔ, yé kɩ ńmɔ tyɩ́lɛ n wɛ n yo pé tyɩ́, à tahlɩ névye tyɩ́ nónó náh pɩ Nsyifunɔlɛ. ");
INSERT INTO wib_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ǹtɛ pàh yé tɛ̃ n yuku tùkè-ǹsah, yé káh yɛ yé yáh-ńsah tyɛ yáh nɛ n yo n wil n pi sɔ̃́, ànɛ̂ yáh nɛ nɛ̂ yo n pi. Yáh nɛ nɛ̂ yo n pi, ké sõnɔ kɩ de yé sɔkɔ nɛ́npɔ́ swɔ. ");
INSERT INTO wib_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Yé náh wɛ di, yé yah yĩ́ĩ́ wɛlɔ náh yé kɩ n wɛkɩ dɛ́, Sú Liyel Mirki ye kɩ tɛ̃ yé yahlɛ yé kɩ n wɛkɩ. ");
INSERT INTO wib_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Névye kɩ pè kɔ̃ pè kɩ pé yṹnpyélɛ n tɛ̃ n ko n mɔ. Súbí tɔ kɩ sɛ̃́ntɛ̃̀nɛ n pɩ pé wɛ̃́npì tyɩ́. Wɛ̃́npì tɔ kɩ pé dúbípú tyɩ́ yahle, tɛ́ kɩ pè kɔ̃ pè kɩ pélɛ n ko n mɔ. ");
INSERT INTO wib_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Névye pól kɩ yé wɛ mɔ ńmɔ yĩnnɛ. Ǹtɛ nɛ̂-à ǹ tah sah à pɔ nɔ ké tyɛ́nɔ́ tyɩ́, tɛ̃̀ kɩ pwáhnmɔnɔ wɛ. ");
INSERT INTO wib_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Pàh yélɛ n fõh kwil yɔ́ sɔkɔ, yé sɔkɔ kèyǎh sɔkɔ. Kègbɩ yõ mé kélɛ n yo yé tyɩ́, ńmɔ nɛ̂-á Névi Pídĩ́nɛ, yé náh tɔ̃̌nɩ̀ Yisrayel kwlo pól kɔ n kɔ̃ n tɛ n pi tɛ́ mé kɩ pɔ. ");
INSERT INTO wib_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Tir sã́h-ò náh n kal n pnɛ ǹ kwɔ́-òlɛ. Tõ̀npɩ tɔ náh n kal n pnɛ ǹ yõ̀tɛ̃̀nɛ. ");
INSERT INTO wib_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Tir sã́h-ò-à pɩ ǹ kwɔ́-ò tyɩ́ kɔ̃lɛ, kè kɩ yɩ̃nɛ. Tõ̀npɩ tɔ-à pɩ ǹ yõ̀tɛ̃̀ tyɩ́ kɔ̃lɛ, kè kɩ yɩ̃nɛ. Névye-á fyɔ̀ mɛ kéte tɛ̃̀ dĩ́ ńtɛ̃nɛ n gbyɔ Bɛlsebulilɛ, (nɛ̂ kɔ́r-á sétã̀n yõ̀tɛ̃̀nɛ), ǹ kéte tãn wɔ se pyě pè kɩ yɛ gbyɔ̀npekenɔlɛ? ");
INSERT INTO wib_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Kǎh pɩ sɛ̃́, yé káh névye yah tíkílɛ n pɩ. Yé náh wɛ di, tyípǐl yɔ́ ńtɛ̃ náh n wũ n pi wìlkìnmɔ-ńkɛ̃̂nɛ. Sètĩ̀n sõ̀ tir yɔ́ ńtɛ̃ náh n wũ n pi pɩ̃́-ńkɛ̃̂nɛ. ");
INSERT INTO wib_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Máh tyi nónónɛ n yo yé tyɩ́ fɛ̃́ntũ̂ sɔkɔ, yé sélɛ n yo n wilki n mɔ tyah kyòo yah. Tyi nónó-á n plɔ n yo yé tyɩ́ yé níkílɔ́ yey, yé sé kwnínɛ n kɔ̃ gbɛ̃́ntĩ̂n yõ. ");
INSERT INTO wib_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Yé káh névye yah tíkílɛ n pɩ, nónó-á névyelɛ n ko mɔ n pnɛ, tɛ́ pè náh fɛ̃ ǹ min ko mɔ n pi. Ǹtɛ Liyel nɛ̂-á kɩ fɛ̃ névi wil gbɛ̃́nsê ànɛ̂ ǹ min tɔ min dah mɔ ní-ńkɛ̃̂ nyàhnpèkè sɔkɔ, yé ǹmɔ wɔ tíkílɛ nɛ n pɩ. ");
INSERT INTO wib_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ǹtɛ̃̀npînɔ́ nínɔ́ n yãm pɔ́píkí pɔ́ núkú ólɛ. Ǹtɛ sé sɔkɔ yɔ́ ńtɛ̃ náh n syɩkɩ sétáh, nɛ́ yé Sú Liyel náh ké wɛ̃̀kɩ̀ kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ǹtɛ yépi tɛ̃̀ wɔlɛ, yé yõ̀yén ńtɛ̃ pól dan mɛ pɩ̃́nɔ́lɛ Liyel tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Kǎh pɩ sɛ̃́, yé káh tíkílɛ n pɩ, yépi tyɩ́ náh tah kal ǹtɛ̃̀npî kwĩnki tyɩ́lɛ di? ");
INSERT INTO wib_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Névi nɛ̂-à kè yo dal mɔ névye yĩ́ yah nɛ páh mɛ ńmɔ tyɩ́ yõ, ńmɔ tɔ kɩ kè yo dal mɔ ń Sú yĩ́ yah nɛ̂-á mɛ yĩ̂nyõ, nɛ tɛ̃̀-á mɛ ńmɔ tyɩ́ yõ. ");
INSERT INTO wib_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ǹtɛ nɛ̂-à yahle névye yĩ́ yah nɛ pé náh mɛ ńmɔ tyɩ́ yõ, ńmɔ tɔ kɩ yahle ń Sú yĩ́ yah nɛ̂-á mɛ yĩ̂nyõ, nɛ tɛ̃̀ náh mɛ ńmɔ tyɩ́ yõ.» ");
INSERT INTO wib_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«Yé káh wɛ nɛ yèvɩnɩ-á mé pɔ mɔ́-ńsah sétáh yõ dɛ́. Yèvɩnɩ náh mé pɔ mɔ́-ńsah sétáh yõ, gbɛ́kɩ́nɔ́ wɔ ye pyě. ");
INSERT INTO wib_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Mé pɔ dĩ́ ànɛ̂ ǹ sú wrɔ́ gbɛ́kɩ́-ńsah; sênpir ànɛ̂ ǹ yṹ wrɔ́ gbɛ́kɩ́-ńsah; sê ànɛ̂ ǹ pɛ yṹ wrɔ́ gbɛ́kɩ́-ńsah. ");
INSERT INTO wib_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Névi gbô tãn ye kɩ pɩ ǹ sépɛ́bɩ́lɛ. ");
INSERT INTO wib_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Névi nɛ̂ sú, képah náh pɩ ǹ yṹ tyɩ́-à nɔ ǹ tyɩ́ à kal ńmɔlɛ, tɛ̃̀ náh yɩ̃nɛ à nɛ n mɛ ńmɔ tyɩ́ yõ. Névi nɛ̂ pídĩ́, képah náh pɩ ǹ písê tyɩ́-à nɔ ǹ tyɩ́ à kal ńmɔlɛ, tɛ̃̀ náh yɩ̃nɛ à nɛ n mɛ ńmɔ tyɩ́ yõ. ");
INSERT INTO wib_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Névi nɛ̂-à ǹ syɩ syɩ dahnɩ twah ń sõ̀ tɛ̃́-ńkɛ̃̂nɛ, tɛ̃̀ náh yɩ̃nɛ à nɛ n mɛ ńmɔ tyɩ́ yõ. ");
INSERT INTO wib_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Névi nɛ̂-á nɛ páh pé minnɛ n koh n sah, tɛ̃̀ kɩ tɛkɩ tyɛ́-ńkɛ̃̂ min sɔkɔ. Tɛ́ nɛ̂-á tɛkɩ ǹ min sɔkɔ ńmɔ yĩnnɛ, tɛ̃̀ wɔ kɩ tyɛ́-ńkɛ̃̂ min wɛ.» ");
INSERT INTO wib_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«Névi nɛ̂-à yé tɛ̃ plɛ, ńmɔ ye tɛ̃̀ tɛ̃ plɛ. Nɛ̂ tɔ-à ńmɔ tɛ̃ plɛ, Sú Liyel nɛ̂-á tɛkɩ mɔ ńnɛ, ǹmɔ ye tɛ̃̀ tɛ̃ plɛ. ");
INSERT INTO wib_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Névi nɛ̂-à Liyel tɛ̃ntõ̀ syínyo-ò tɛ̃ plɛ ǹ pɩ́nɔ́ yĩnnɛ Liyel tɛ̃ntõ̀ syínyo-òlɛ, Liyel tɛ̃ntõ̀ syínyo-ò dyah dyah kwâh kénkɔ̃ ye kɩ dyah tɛ̃̀nɛ. Névi nɛ̂ tɔ-à nɛ́gbɩ́ tɛ̃ plɛ ǹ pɩ́nɔ́ yĩnnɛ nɛ́gbɩ́lɛ, nɛ́gbɩ́ dyah dyah kwâh kénkɔ̃ ye kɩ dyah tɛ̃̀nɛ. ");
INSERT INTO wib_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Kègbɩ yõ mé kélɛ n yo yé tyɩ́ nɛ, névi nɛ̂-à nívɩ́nɔ́ ńgbíyĩ́nɛ ńmɔ tõ̀ sã́hpú sɔkɔ yɔ́ ńtɛ̃ fyé kɔ̃ à wɔ ǹ pɩ́nɔ́ yĩnnɛ ńmɔ tõ̀ sã́h-òlɛ, tɛ̃̀ náh n tɛkɩ n pi ké lédyáhnɩ́ sɔkɔ póllɛ.» ");
INSERT INTO wib_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Képah sɔkɔ, Yesu-á tyi kwãh sah ǹ tõ̀ sã́hpú nɛ́pĩ̂ gbɔ̃nimí kɔ̃ tɛ gbĩ́ nɛ̂nɛ, à yal nɛ́npɔ́ à yuku gbɔ̀plɔ kwlo sɔkɔ, à kyɩ kwɔ́nɔ́lɛ n pɩ tɛ́ Nɩ̀vɩ̀nɩ̀ tirlɛ n yo. ");
INSERT INTO wib_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Wèlnwìlkì-ò Nsyɔ̃ sõ̀ mɛ wɔ̀kɔ̀npèkè sɔkɔ tɛ́ Krista tyípɩ́nɔ́ tyɩ́ yónɔ́ noh. À mɛ ǹ tõ̀ sã́hpú yísyɔ́ tõ pè kyɩ à piki yah nɛ, ");
INSERT INTO wib_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ǹmɔ se Liyel nɛy yáhntɔkɔnɔlɛ nɛ̂-á kɩ sõ̀ n pɔ n pi, tĩ̂ pé se yɩ̃nɛ pé ǹnɩ̂nɛ n syɩkɩ nɩ? ");
INSERT INTO wib_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesu mɛ yo pé tyɩ́ nɛ: «Tyi nónó-á yé n nohnɩ tɛ́ sélɛ n yah yɔ̀, yé kyɩ sè yãh Nsyɔ̃ tyɩ́ nɛ, ");
INSERT INTO wib_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","yɩ̃́tũbi yɩ̃́-á mɛ n yɩkɩ n mɔ, sèkukubi mɛ n kɔ tómtóm, tótãm mɛ n dɛ n mɔ, níkítũbi mɛ n nohnɩ, lékyɩ̂ mɛ n yilki n mɔ, ànɛ̂ Nɩ̀vɩ̀nɩ̀ tir mɛ n yo n kɔ̃ yãm tãn tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ǹtɛ ńmɔ tyɩ́-à kɩ névi nɛ̂ kɔ̃ à ń yõ sɛ̃́nɔ́ yáhle-ńkɛ̃̂nɛ, tɛ̃̀ wɔ tyɩ́ nɔ.» ");
INSERT INTO wib_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Nsyɔ̃ tõ̀ sã́hpú-á pé syɩ sɔkɔ tɛ gbĩ́ nɛ̂nɛ, Yesu tyah Nsyɔ̃ tyɩ́lɛ n yãh tɔ́wû tyɩ́ nɛ ńkɛ̃́: «Kwâh nɛ̂ mɛ yé kyɩ yah gbɛ̃́nnɩ sɔkɔ? Fílkì yɔ́ se yã́hkɩ́ mɛ n fĩ n kɔ̃? ");
INSERT INTO wib_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ǹtɛ kwâh nɛ̂ mɛ yé kyɩ yah wɛ́? Dĩ́ yɔ́ se nɛ̂-á mɛ fwɔ̀tǎhnɩ̀ mɔ? Tɛ́ nónó-á mó tɔ̃ fwɔ̀tǎhnɩ̀nɛ n mɔ, pépi mɛ yõ̀tãm fnɛ́ sɔkɔ dò. ");
INSERT INTO wib_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ǹtɛ kwâh nɛ̂ mɛ yé kyɩ yah wɛ́? Liyel tɛ̃ntõ̀ syínyo-ò yɔ́ se? Mé kélɛ n yo yé tyɩ́ nɛ sɛ̃́-á. Tɛ́ ǹmɔ ńtɛ̃-á kal Liyel tɛ̃ntõ̀ syínyo-òlɛ. ");
INSERT INTO wib_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yé náh wɛ di, Nsyɔ̃ tyɩ́ ye wã́rkɩ́nsàhnɔ́lɛ Liyel wɛy sɛ́bɛ́y sɔkɔ nɛ Liyel-á nɛ: ‹Yah, ńmɔ Liyel kɩ ń tɛ̃ntõ̀ névi tɛkɩ mɔ á yahlɛ, à kɩ pɔ á wɛ̃̀kɩ̀ tɔ̃ sah.› ");
INSERT INTO wib_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Kègbɩ yõ mé kélɛ n yo yé tyɩ́ nɛ, sê fɔkɔ táh pi yɔ́ ńtɛ̃ náh mɛ nɛ̂-á kal Wèlnwìlkì-ò Nsyɔ̃nɛ. Ǹtɛ nɛ̂-á tyɩ̃́ɩ̃ kal Liyel tɔ̃́rɩ́ nɔlɩ yṍpú sɔkɔ, ǹmɔ ńtɛ̃ kal ǹnɛ. ");
INSERT INTO wib_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Tɛ́ à tɔkɔ Wèlnwìlkì-ò Nsyɔ̃ gbĩ tyɩ́, pópó à pɔ syɩ núkúnúkú tyɩ́, Liyel tɔ̃́rɩ́ nɔlɩ mɛ n wɛ n yõ táhnsàhnɔ́ ó sɔkɔ. Táhnsàhpu ye n wɛ kélɛ. ");
INSERT INTO wib_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Liyel tɛ̃ntõ̀ syínyopu pól ànɛ̂ Moyisi tyi kõ̀nsàhnɔ́ sõ̀ mɛ Liyel tɔ̃́rɩ́ tyɩ́lɛ n yo, pópó à pɔ syɩ Nsyɔ̃ gbĩ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Yáh kɩ fɛ̃ n sɛ̃ n pi ké yõ, Nsyɔ̃ ye Yeli mɛ̀nɛ, nɛ̂ pɔ́nɔ́ tyɩ́-á sõ̀ yónsàhnɔ́lɛ. ");
INSERT INTO wib_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Nɛ̂-à kɩ mɛ kè noh, tɛ̃̀ kè tɛ̃ yĩn. ");
INSERT INTO wib_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Mé kɩ kwɛy gbĩ névye tɔkɔ sãh nɛ̂nɛ wɛ́? Pè mɛ á kɩ nɛ wɛ̃́npì sɔ̃́ kɔ̃ tɛ̃ tɔ́wû tùkè-ǹtã̀n sɔkɔ, tɛ́ mɛ n yo n mɔ pé no tyɩ́ nɛ, ");
INSERT INTO wib_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","pépi-á yɩkɩ fɩ̃bɩ pé tyɩ́, tɛ́ pè náh yi. Pé tɔ̃ kũ yɩ̀kɩ̀ gbɩ mɔ, pè náh se tɔ̃ gbo. ");
INSERT INTO wib_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Sɛ̃́ ye kwɛy gbĩ névye tɔ mɛ n pɩ. Yé náh wɛ di, Nsyɔ̃-á lésõ pɔ, à náh mɛ yõke yèsyɩ̀kɩ̀lɛ n yõ, à náh mɛ dìvɛ̃nɛ n wɔ. Képah tɛ̃̀nɛ, pè nɛ sétõ-á mɛ ǹ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ǹtɛ Névi Pídĩ́ wɔ-á pɔ, ǹmɔ n yõ pallɛ tɛ́ n wɔ pallɛ. Pè mɛ tɔ̃ nɛ, pè yah yèwònpɩ ànɛ̂ sètɛ̃-á ǹnɛ, mɔ́rɩ́ syípú ànɛ̂ tyípêl pɩ́pú kódĩ́-á ǹnɛ. Ǹtɛ Liyel lékã́m-á n tɔkɔ à tyi nónónɛ n pɩ, sé pal n pnɛ sé tɔ̃ n sah n pɩ dùkù sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Képah náh, Yesu-á sõ̀ ǹ gbǐlnɔ́ kan pɩ kwlo nónó sɔkɔ, à tyah n kah n wɛkɩ sé névye yõ, pǎh sɔ̃́npɩ́lɛ yahle pé tyípêl pɩ́nɔ́ yálnmɔnɔlɛ. À nɛ: ");
INSERT INTO wib_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«Pèkè mɛ yé yõ, Korasini tãn. Pèkè mɛ yé yõ, Betisayida tãn. Ǹgbǒ gbǐl tyi nónó-á pɩ yé tĩ̀nnɛ, sɛ̃́nknɔ-à sõ̀ mɛ pɩ Tiri ànɛ̂ Sidõ tãn tĩ̀nnɛ, pè náhkɩ mɛ yèkwɔrɩ flɔ mɔ, tɛ́ náhkɩ mɛ pé piki syɩ̃lɛ à pé tyípêl pɩ́nɔ́ yal mɔ di mónɔ́lɛ. ");
INSERT INTO wib_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Képah ye mé kélɛ n yo yé tyɩ́, Liyel tukey tuke sõlɛ, Tiri ànɛ̂ Sidõ tãn fṍhnɔ́ ńtɛ̃ náh n peke n nɔ n pi yépi tyɩ́lɛ. ");
INSERT INTO wib_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Tɛ́ yépi-á dò Kapɛrnayumi tãn, yé se mɛ n sõ nɛ yáh kɩ dɔkɔ mɔ yĩ̂nyõ? Póllɛ, yé kɩ tiki mɔ yuku fɔ́ɔ́ lékókwíl nyàh tɛ̃̀-ǹsah. Yé yah, gbǐl nónó-á pɩ yé tĩ̀nnɛ, sɛ̃́nknɔ-à sõ̀ mɛ pɩ Sodɔmɩ tãn tyɩ́, Sodɔmɩ kwil náhkɩ mɛ sɛ̃́ kwɛy mɛ̀ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Képah ye mé kélɛ n yo yé tyɩ́, Liyel tukey tuke sõlɛ, Sodɔmɩ kwil tãn fṍhnɔ́ ńtɛ̃ náh n peke n nɔ n pi yépi tyɩ́lɛ. ");
INSERT INTO wib_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Légbĩ́nɛ, Yesu nɛ ńkɛ̃́: «Bɔ̌, áwɔ nɛ̂-á yĩ̂nyõ ànɛ̂ sétáh nɛ́tɛ̃̂nɛ, mé n wɛkɩ á tyɩ́ wáh sɔ̃́npɩ́lɛ tyi nɔ́pi wɔ̃bɩ yɩ̃ pɩ̃́pú ànɛ̂ lékã́m névye yah, tɛ́ sélɛ névye wɔ wɛ̃kɩ nónó-á mɛ wɛ̃́npì sɔ̃́. ");
INSERT INTO wib_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Bɔ̌, kè ye áwɔ dyɔ á kè pɩ sɛ̃́.» ");
INSERT INTO wib_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Yesu tɔ̃ nɛ: «Ń Sú ye tyi póllɛ ń gbõ̀ dahbɩ. Ńmɔ nɛ̂-á Pídĩ́nɛ, ǹnɩ̂ yɔ́ ńtɛ̃ náh ńnɛ n pnɛ nɛ́ Sú ó náh. Ǹnɩ̂ yɔ́ ńtɛ̃ tɔ náh mó Súlɛ n pnɛ nɛ́ Pídĩ́ ó náh, à tahlɩ Pídĩ́-à mɛ ké tyɩ́ nɛ pé ǹnɛ nɛ̂ wɛ̃kɩ. ");
INSERT INTO wib_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Yépi nónó pól-á mɛ kwlɔ́nɔ́ sɔkɔ tɔ́kɔ́pêllɛ yé yõ, yé pɔ ńmɔ tyɩ́, mé kɩ yé kɔ̃ yé kɩ n mɩ. ");
INSERT INTO wib_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Nɛ́pír névi ànɛ̂ gblɔ̌y tíkínmɔ-ò ye ńmɔlɛ. Képah ye, máh yélɛ n mɔ tõ̀ nɛ̂ sɔkɔ, yé kè fɛ̃ syi yè mó pɩ ń tõ̀ sã́hpúlɛ. Képah sɔkɔ, yé kɩ n wɛ n mɩ. ");
INSERT INTO wib_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Yé yah, ńmɔ tõ̀ náh tah, ń tɔ́kɔ́bɩ́ mɛ fáhah fáhah.» ");
INSERT INTO wib_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Légbĩ́ mɛ̀ ó sɔkɔ, mɩ mɩ yòh sõ yɔ́lɛ Yesu ànɛ̂ ǹ tõ̀ sã́hpú sõ̀ mɛ n kah sèmukɔ swɛ̃y yísyɔ́ sɔkɔ. Tɛ́ kwɛkɩ sõ̀ mɛ ǹ tõ̀ sã́hpú tɛ̃. Kǎh pɩ sɛ̃́, pè mɩ de sèmukɔ ywɔ̃ kɔ̃̀lɩ̀ntahnɔ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Farisi wɛ̃̀kɩ̀ kɔ́pú-á képah wɛ sɛ̃́, pè mɛ yo Yesu tyɩ́ nɛ, tir nɛ̂ pɩ́nɔ́ wɛ̃̀kɩ̀ náh mɛ kɔ̃́nɔ́lɛ mɩ mɩ yòh sõlɛ, à nɛ n yah ǹ tõ̀ sã́hpú kélɛ n pɩ lɛ́. ");
INSERT INTO wib_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ǹtɛ Yesu mɛ yo pé tyɩ́ nɛ: «Kwɛkɩ-á lésõ yõ̀tɛ̃̀ dĩ́ Davidi ànɛ̂ ǹ náh névye tɛ̃, wǎh nɛ̂ pɩ, yé náh kè kar yah di? ");
INSERT INTO wib_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Búrn nónó-á lésõ mɛ sàhnɔ́lɛ Liyel tyɩ́ yõ Liyel wɔ̀kɔ̀ sɔkɔ, à náh lésõ de ké sɔkɔ à sè tɔkɔ tah ànɛ̂ ǹ náh névyelɛ di? Tɛ́ à wil sárká syínwìlkìpu tyɩ́ sɔkɔ, nɛy náh lésõ yɩ̃nɛ sé táhnɔ́lɛ. ");
INSERT INTO wib_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Yé se kɩ nɛ yé náh kè kar yah tɔlɛ nɛ, sárká syínwìlkìpu-á ńkɛ̃́nɛ mɩ mɩ yòh dêllɛ n pɩ Liyel ní-ńsah gbô sɔkɔ mɩ mɩ yòh sõnɔ́lɛ, tɛ́ lékàh náh mɛ pé tyɩ́? ");
INSERT INTO wib_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ǹtɛ mé kélɛ n yo yé tyɩ́, névi mɛ ásõ̂ nɛ̂-á kal Liyel ní-ńsah gbôlɛ. ");
INSERT INTO wib_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Liyel kè yo nɛ ńkɛ̃́: ‹Sárká súkɛ́nkɔ̃nɔ náh mé n yah n kɔ̃ dɛ́, wɛ̃ yãm yáhnɔ́ ye mé n yah n kɔ̃.› Yâh sõ̀ mɛ képah kɔ́rlɛ n pnɛ, yé náh náhkɩ lékàhlɛ lékàh kɛ̃́ névye kɔ̃ n pi. ");
INSERT INTO wib_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Yé náh wɛ di, Névi Pídĩ́ ye mɩ mɩ yòh yõ̀tɛ̃̀nɛ dò.» ");
INSERT INTO wib_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu-á yal nɛ́npɔ́, à sɔkɔ pé Liyel ní-ńsah wɔ̀kɔ̀ yɔ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Gbõ̀nkù dĩ́ yɔ́ sõ̀ mɛ nɛ́npɔ́. Tɛ́ pè sõ̀ mɛ ké tyɩ́ nɛ pé lékàh wɛ Yesu kɔ̃. Kǎh pɩ sɛ̃́, pè Yesu piki yah nɛ ńkɛ̃́, yɔ́nwó dɛ́nmɔnɔ wɛ̃̀kɩ̀ se mɛ kɔ̃́nɔ́lɛ mɩ mɩ yòh sõlɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ǹtɛ à mɛ yo pé tyɩ́ nɛ: «Yé sɔkɔ yɔ́ tyɩ́ képɔ́ núkú ó-à mɛ, tɛ́ à sɔkɔ de pwã̀hsǔkù yɔ́ sɔkɔ mɩ mɩ yòh sõlɛ, tɛ̃̀ se kɩ yɛ ǹ kyɩ́nwìlkìnɔ́lɛ lésõlɛ? ");
INSERT INTO wib_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ǹtɛ névi náh fṍnfṍ kal náhnáh képɔ́ yõ di? Kǎh pɩ sɛ̃́, pèpɔrɩ pɩ́nɔ́ wɛ̃̀kɩ̀ mɛ kɔ̃́nɔ́lɛ mɩ mɩ yòh sõlɛ.» ");
INSERT INTO wib_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Képah tɛ̃̀nɛ, tɛ́ yo gbõ̀nkù dĩ́ mɛ̀ tyɩ́ nɛ: «Á gbõ̀ tɔ̃.» À mɛ kè tɔ̃, kè núkú pɩ vilɛ ké ní-ò mɛ̀ sɔ̃́. ");
INSERT INTO wib_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ǹtɛ Farisi wɛ̃̀kɩ̀ kɔ́pú-á fyɔ̀ wil Liyel ní-ńsah wɔ̀kɔ̀ sɔkɔ, pè kyɩ wɛ̃ wɛ à vì-ǹsah yah Yesu wɛ n ko n mɔ yĩnnɛ. ");
INSERT INTO wib_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesu-á pɔ pɩ̃ nɛ Farisi wɛ̃̀kɩ̀ kɔ́pú-á mɛ pé kònmɔ-ńsahlɛ n yah n kɔ̃, à yal nɛ́npɔ́. Névye náhnáh mɛ ǹ sõ̀ tɛ̃. À mɛ pé sɔkɔ yámpú pól dɛ mɔ, ");
INSERT INTO wib_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","tɛ́ pè gbah sni nɛ pè káh pé tyɩ́ yãh nɛy tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Yesu-á képah pɩ, Liyel-á lésõ nɛ̂ yo sah ǹ tɛ̃ntõ̀ syínyo-ò Yesayi tyɩ́, kè wil. À lésõ nɛ ńkɛ̃́: ");
INSERT INTO wib_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«Máh nɛ̂ yah wilki nɛ à ń tõ̀lɛ n pɩ, à wɛ yɔ̀. Ń nɩ̀dɛ̀ nɛy ye ǹnɛ. Ǹmɔ ye ń nɩ̀vɩ̀nɩ̀ yõlɛ. Mé kɩ ń Mirki tiki mɔ ǹ yõ, à kɔ̃ à kɩ gbɩ wɛ̃̀kɩ̀ tyɩ́ yo yìkìnì pól névye tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","À náh yékã̂b pɩ n pi nɛynɛ, à náh n gbo n mɔ n tũ n pi, nɛy náh ǹ yĩ́npɔ̃́ noh n pi tɔ́wû tùkè-ǹtã̀n sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Fílkì nɛ̂-á mɛ kwɔ́nmɔntɛ̃̀nɔ́lɛ, à náh ké tɛ́y kwɔ n pi. Fɔ̀tnɔ̀ nɛ̂-á mɛ n tyah nínɔ́lɛ, à náh ké tɛ́y ni n mɔ n pi. Sɛ̃́ ye à kɩ n pɩ, pópó kɩ pɔ nɔ gbĩ́ nɛ̂-á gbɩ wɛ̃̀kɩ̀ kɩ yah syi. ");
INSERT INTO wib_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Tɛ́ yìkìnì pól névye gbõ̀ sàhnɔ́ kɩ mɛ ǹmɔ yõ.» ");
INSERT INTO wib_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Képah náh, nósyɔ́ dĩ́ yɔ́ tɛ̃ pɔ Yesu tyɩ́. Sétõ sõ̀ mɛ ǹ sɔkɔ à kɔ̃ à pɩ yɩ̃́tũ̂ ànɛ̂ kèdɔ̀kɩ̀lɛ. Yesu mɛ à dɛ mɔ, à kɔ̃ tɛ̃ wɛ n wɛkɩ, tɛ́ fɛ̃ n yah. ");
INSERT INTO wib_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Képah tɛ̃̀nɛ, kè pɩ gbɛ̃̀ndùnìnɛ tɔ́wû pól tyɩ́, pè mɛ tyah n yo wɛ̃ tyɩ́ nɛ: «Tɛ́ Davidi Pídĩ́ náh yɔ̀ lɛ́?» ");
INSERT INTO wib_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ǹtɛ Farisi wɛ̃̀kɩ̀ kɔ́pú-á képah tɛ̃̀ noh sɛ̃́, pè nɛ sétã̀n yõ̀tɛ̃̀ Bɛlsebuli ó gbõ̀ yõ-á à n yĩni sétã̀nnɛ. ");
INSERT INTO wib_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Tɛ́ Yesu-á pé fɔkɔ sõnɔ wɛ sɛ̃́, à yo pé tyɩ́ nɛ: «Yõ̀tɔ̃rɩ́ nɛ̂ tɛ̃̀ névye-à fyɔ̀ yuku wɛ̃nɛ n fwo, kénɛ yõ̀tɔ̃rɩ́ kɩ yɩkɩ. Kwil nɛ̂ névye-à yuku wɛ̃nɛ n fwo, kè náh n wũ n pi. Sɛ̃́ ó ye, kéte nɛ̂ névye-à yuku wɛ̃nɛ n fwo, ké tɔ náh n wũ n pi. ");
INSERT INTO wib_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Tɛ́ sétã̀n yõ̀tɛ̃̀-à tyah ǹ nolɛ n yĩni, ǹ gblɔ̌y náh à n fwo di? Ǹ yõ̀tɔ̃rɩ́ se kɩ wũ? ");
INSERT INTO wib_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Tɛ́ ńmɔ-à mɛ sétã̀nnɛ n yĩni Bɛlsebuli gbõ̀ yõ yé yo à; yépi tĩ̀nkì névye wɔ-á dò, nɛ̂ gbõ̀ yõ mɛ pépi n yĩni sélɛ wɛ́? Pépi ńtɛ̃ ye kɩ lékàhlɛ yé kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Liyel Mirki gbõ̀ yõ-à mé n yĩni sélɛ, képah n wɛ̃kɩ nɛ ńkɛ̃́, Liyel tɔ̃́rɩ́-á yĩni tɛ̃ yé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Tǎhkɩ̀-á mɛ dĩ́ nɛ̂ sɔkɔ, nɛ̂ kɩ fɛ̃ ǹ púkúbí-ńkɛ̃̂ sɔkɔ, kɩ de ǹ wɔ̀kɔ̀ sɔkɔ kɩ ǹ gbã̀n yî kwel? Máhah wǎh kɩ à pukubi tɛ́ kɩ pyě de ǹ wɔ̀kɔ̀ yî kwel. ");
INSERT INTO wib_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Névi nɛ̂-à mɔ́-ńkɛ̃̂nɛ ńmɔlɛ, tɛ̃̀ mɛ ńnɛ n fwo. Névi nɛ̂ náh mɛ ńnɛ n yohnɩ n mɔ tùkènmɔnɔ sɔkɔ, tɛ̃̀ mɛ kárkɩ́nɔ́lɛ n pɩ. ");
INSERT INTO wib_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Képah ye, mé kélɛ n yo yé tyɩ́ nɛ: ‹Névye tyípêl pól ànɛ̂ pé Liyel gbyɔ̀nɔ́ pól kɩ fɛ̃ yɔ̃ mɔ pè kɔ̃. Ǹtɛ Liyel Mirki gbyɔ̀nɔ́ tɛ̃̀ wɔ náh n yɔ̃ mɔ n pi pé tyɩ́ póllɛ. ");
INSERT INTO wib_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Névi nɛ̂-à yo de Névi Pídĩ́ tyɩ́, kè kɩ fɛ̃ yɔ̃ mɔ tɛ̃̀ kɔ̃. Ǹtɛ névi nɛ̂-à yo de Liyel Mirki tɛ̃̀ wɔ tyɩ́, kè náh yɔ̃ mɔ tɛ̃̀ kɔ̃ n pi kwɛynɛ, kè náh yɔ̃ mɔ tɛ̃̀ kɔ̃ n pi ńsõ̂ tɔlɛ.› ");
INSERT INTO wib_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Yé yah, séswɔ̂ n pnɛ ké pye dùkù sɔkɔ. Yâh nɛ séswɔ̂ nɛ̂-á mɛ plɛ, yé nɛ ké pye tɔ-á mɛ plɛ. Yâh nɛ séswɔ̂ nɛ̂ náh mɛ plɛ, yé nɛ ké pye tɔ-á mɛ kétúkùyɔ̂. ");
INSERT INTO wib_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Wáhnmɩ́rɔ́ nɔ́pi, tyípéplɔ se kɩ fɛ̃ n wil yé vyɛ̃y sɔkɔ tɛ́ yé nnɔ mó tɔ̃ mɛ yúkúnɔ́lɛ pèkèlɛ? Névi nɩ-á mɛ yúkúnɔ́lɛ tyi nónónɛ, sépi ye n wil tɛ̃̀ vyãh sɔkɔ dò. ");
INSERT INTO wib_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Nɛ́pépɛ̌y tyípéplɔ n wil ǹ nɩ sɔkɔ. Nɛ́túkù tyítúkúnì tɔ mó n wil ǹ nɩ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ǹtɛ mé kélɛ n yo yé tyɩ́, yah kɛ̃́ wɛlɔ nónó pól-á névye n wɛkɩ, sé ywɔ̃ kɩ piki n yah n pi pé tyɩ́ Liyel tukey tuke sõlɛ. ");
INSERT INTO wib_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Tukey kɩ tuke á yõ à yɩ̃nɛ á vyãh wɛynɛ kɩ gbɩlɛ ǹ kɔ̃, képah náh pɩ kɩ lékàhlɛ ǹ kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Képah sɔkɔ, Liyel tyi kõ̀nsàhnɔ́ kwɔ́pú ànɛ̂ Farisi wɛ̃̀kɩ̀ kɔ́pú yísyɔ́ mɛ Yesu syah nɛ, pé kwɔ́-ò dĩ́, páh mɛ ké tyɩ́ nɛ à gbǐl yɔ́ pɩ pé yah, nɛ̂-á n wɛ̃kɩ nɛ wǎh n wil Liyel tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","À mɛ yo pé tyɩ́ nɛ: «Kwɛy gbĩ névye náh plɛ. Pè náh mɛ tɛ̃ Liyel ó tyɩ́ yõ. Pè mɛ ké tyɩ́ nɛ mé gbǐl yɔ́ pɩ pé yah. Ǹtɛ kèyǎh ńtɛ̃ náh pɩ pè wɛ̃kɩ n pi, à wil Liyel tɛ̃ntõ̀ syínyo-ò Nsyonasɩ tyɩ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yé yah, sɔ̃́-á lésõ Nsyonasɩ sèpĩ̀n tɔ̃́nɩ̀ pɩ yɛ̃́nkɔ̂-ǹgbɛ̃̀kɩ̀ yɔ́ fɔkɔ sɔkɔ, sɛ̃́ ye Névi Pídĩ́ tɔ kɩ sèpĩ̀n tɔ̃́nɩ̀ pɩ sétáh sõwãh. ");
INSERT INTO wib_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nsyonasɩ-á lésõ Liyel tɛ̃ntõ̀ yo Ninivi kwil tãn tyɩ́, pè fɛ̃ syi pé tyípêl pɩ́nɔ́ yal mɔ. Ǹtɛ nɛy mɛ ásõ̂ nɛ̂-á kal Nsyonasɩlɛ. Kǎh pɩ sɛ̃́, Liyel tukey tuke sõlɛ, Ninivi kwil tãn kɩ yuku kwɛy gbĩ névye yõ, kɩ lékàhlɛ pè kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Pi nɛ̂-á lésõ yõ̀tɛ̃̀nɛ Saba sétáh yõ, à lésõ wil fɩ́ɩ́ sétáh yĩ̀n tyɩ́, à pɔ yõ̀tɛ̃̀ dĩ́ Salomo lékã́m wɛlɔ noh. Ǹtɛ nɛy mɛ ásõ̂, nɛ̂-á kal Salomolɛ. Kǎh pɩ sɛ̃́, Liyel tukey tuke sõlɛ, kénɛ pi kɩ yuku kwɛy gbĩ névye yõ, kɩ lékàhlɛ pè kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Sétõ-à wil névi sɔkɔ, à n kyɩ gbɛ̃́nnɩ kɔ n kɔ̃, ǹ mɩ̀-ǹsah yah n kɔ̃. Ǹtɛ wàh wɛ́-ńkɛ̃̂nɛ, ");
INSERT INTO wib_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","à n yo ǹ gblɔ̌y tyɩ́ nɛ, páh sõ̀ wil ńyãh sɔkɔ, páh kɩ pé syɩ yuku nɛ́npɔ́. Wàh ǹ syɩ, tɛ́ kyɩ ǹ tɛ̃̀-ǹsah dyàh wɛ ké kɔ́kɔ́lɛ yàlntɔ̃nsàhnɔ́lɛ, ");
INSERT INTO wib_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","à n kyɩ sé no sétã̀nnɔ́ kwǎrninɔ syah, nónó-á peke kal ǹmɔlɛ. Sé tɔ̂ɔ́ n kyɩ n de n tɛ̃ tɛ̃̀ sɔkɔ. Kàh pɩ sɛ̃́, tɛ̃̀ mɛ̀ dùkù ké syɩ n peke n kal ǹ gben tɛ̃̀nɛ. Sɛ̃́ ye kwɛy gbĩ nɛ́pêl tɔ tyɩ́ kɩ n pɩ n pi. ");
INSERT INTO wib_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu-á mɛ képah yónɔ́ sɔkɔ tɔ́wû tyɩ́, ǹ yṹ ànɛ̂ ǹ yṹnpyé pɔ yĩn kégbɔ́ tɛ́ mɛ ké tyɩ́ nɛ pé yo mɔ ǹ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ǹnɩ̂ mɛ yo ǹ tyɩ́ nɛ à noh yɔ̀, ǹ yṹ ànɛ̂ ǹ yṹnpyé-á mɛ yĩ́ntɛ̃̀nɔ́lɛ kégbɔ́. Pǎh mɛ ké tyɩ́ nɛ pé yo mɔ ǹ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesu mɛ yo tɛ̃̀ tyɩ́ nɛ: «Nɛ̂ mɛ ńmɔ nɔ̂lɛ, ànɛ̂ nónó mɛ ń yṹnpyélɛ?» ");
INSERT INTO wib_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Tɛ́ ǹ gbõ̀ nɔ mɔ ǹ tõ̀ sã́hpú tyɩ́ tɛ́ nɛ ńkɛ̃́: «Ńmɔ nɔ̂ ànɛ̂ ń yṹnpyé wɛ yɔ̀. ");
INSERT INTO wib_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Yé yah, ńmɔ Sú nɛ̂-á yĩ̂nyõ, wǎh mɛ nɛ̂ tyɩ́, névi nɛ̂-à képahlɛ n pɩ, tɛ̃̀ wɔ ye ńmɔ yṹnpilɛ, képah náh pɩ ń nɔ̂lɛ.» ");
INSERT INTO wib_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Lésõ mɛ̀ ólɛ, Yesu wil gbô sɔkɔ à kyɩ kɔ̃ tɛ̃ yɔ́-ǹgbɛ̃ gbɔ̀pɔ. ");
INSERT INTO wib_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Tɔ́wû ǹgbɛ̃ yɔ́ mɛ pɔ à mɔ gbɩ̃. Pé tnɔ́nkàhnɔ́ tɛ̃̀ tyɩ́, à de kɔ̃ tɛ̃ krótókè yɔ́ sɔkɔ. Tɔ́wû pól sõ̀ mɛ yĩ́nntɛ̃̀nɔ́lɛ yɔ́ngbalɩ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","À sõ̀ mɛ tyi náhnáhlɛ n yãh pé tyɩ́ sèmìrn sɔkɔ, mɛ n yo pé tyɩ́ nɛ: «Sõ yɔ́lɛ, dĩ́ yɔ́ lésõ kyɩ sèmukɔ mír-ńsah ǹ swãh sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Wǎh mɛ mírnɔ́ sɔkɔ, yísyɔ́ syɩkɩlɩ wɛ̃̀gbalɩ sɔkɔ, kèpye mɛ pɔ sépi yɔ. ");
INSERT INTO wib_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Yísyɔ́ mɛ syɩkɩlɩ yen kwéy tɛ̃̀-ǹsah légbɩ̃́ yõ. Tɛ́ kǎh pɩ yen gbɩ náh sõ̀ mɛ nɛ́npɔ́ sɛ̃́, sè núkú fi súú. ");
INSERT INTO wib_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Tɛ́ sè náh tɛ̃ wɛ yã̀hnɩ̀ gbɩ mɔ. Kǎh pɩ sɛ̃́, gbĩ-á pɔ vyãh sè tɛ̃, sè kɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Yísyɔ́ mɛ syɩkɩlɩ de pã̀n nɩyṍ, pã̀n mɛ yuku fyãh sé yõ. ");
INSERT INTO wib_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ǹtɛ yísyɔ́ mɛ syɩkɩlɩ sétáh pèpɛy sɔkɔ à pɔ ywɔ̃ pɩ. Túkù pyenɔ lèkwɛ̌kwɛ pɩ, túkù tikitɔ̃nɩ́tɔ̃nɩ pɩ, túkù yõgbãmgbãm pɩ. ");
INSERT INTO wib_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Nɛ̂-à kɩ mɛ kè noh, tɛ̃̀ kè tɛ̃ yĩn.» ");
INSERT INTO wib_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Képah sɔkɔ, ǹ tõ̀ sã́hpú mɛ nɔ de ǹ tnɔ̂ tɛ́ à piki yah nɛ, kwâh nɛ̂ se pɩ tɛ́ à n yãh no nɔ́pi tyɩ́ sèmìrn sɔkɔ nɩ? ");
INSERT INTO wib_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","À mɛ yo pé tyɩ́ nɛ: «Liyel tɔ̃́rɩ́ tyi nónó-á sõ̀ mɛ wɔ̃̀bɩ̀nsàhnɔ́lɛ, sé pnɛ̀nɔ́ ye yépi kɔ̃. Ǹtɛ kè náh pépi wɔ kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Névi nɛ̂ tyɩ́ kwâh-á mɛ, dòhnɩ̀nɔ́ kɩ n pɩ ǹmɔ tyɩ́ yõ yrɔ̌yrɔ̌. Tɛ́ névi nɛ̂ tyɩ́ kwâh náh mɛ, kwéy nɛ̂ ńtɛ̃-á mɛ ǹ tyɩ́, kè kɩ tɛ̃ syi ǹ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","No nɔ́pi mɛ n yah, tɛ́ pè náh mɛ kwâh yɔ́lɛ n wɛ, képah n wɛ̃kɩ nɛ pè náh mɛ ké tyɩ́ yahlɛ n wɛ. Pè mɛ pé nínɛ n kwɔ, tɛ́ pè náh mɛ kwâh yɔ́lɛ n nohnɩ, képah n wɛ̃kɩ nɛ pè náh mɛ ké tyɩ́ yahlɛ n wɛ. Képah ye ń kɔ̃ mé n yãh pé tyɩ́ sèmìrn sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Liyel tɛ̃ntõ̀ syínyo-ò Yesayi-á lésõ nɛ̂ yo sah, képah ye n nɔ pélɛ yɔ̀. À lésõ nɛ ńkɛ̃́: ‹Yé kɩ yé nínɛ n kwɔ n nohnɩ, tɛ́ yé náh ké tyɩ́ yah wɛ n pi. Yé kɩ n yah, tɛ́ yé náh kwâh yɔ́ wɛ n pi, képah n wɛ̃kɩ nɛ yé náh mɛ ké tyɩ́ yahlɛ n wɛ. ");
INSERT INTO wib_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Nikisekɔ́kɔ́ névye ye no nɔ́pilɛ. Pè mɛ pé ní tah tũ, tɛ́ pé yɩ̃́ vike sah nɛ sè káh kwâh yɔ́ ńtɛ̃ wɛ, pé ní káh tir yɔ́ ńtɛ̃ noh pé kɔ̃ pé káh fɛ̃ ké tyɩ́ yah wɛ, pé mó vi mɔ Liyel wɛ̃̀kɩ̀ yõ ń kɔ̃ mé pè wɛ n dɛ n mɔ.› ");
INSERT INTO wib_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Wɛlɔ nɔ́pi yóntɛnɔ náh, Yesu tɔ̃ yo pé tyɩ́ nɛ: «Ǹtɛ yépi tɛ̃̀ wɔ tyɩ́ nɔ, yé yɩ̃́ mɛ n yah, yé ní mɛ n nohnɩ. ");
INSERT INTO wib_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Kégbɩ yõ mé kélɛ n yo yé tyɩ́, yáh tyi nónó wɛ, Liyel tɛ̃ntõ̀ syínyopu ànɛ̂ névye nónó-á nɛ́gblɔ́lɛ Liyel yah, pé náhnáh sõ̀ mɛ ké tyɩ́ nɛ pé sè wɛ, tɛ́ pè náh sè wɛ. Yáh tyi nónó noh, pè sõ̀ mɛ ké tyɩ́ nɛ pé sé tɔ noh, tɛ́ pè náh sè wɛ noh.» ");
INSERT INTO wib_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«Sèmukɔ mír-ò sèmìrkì yõ-á nɛ̂nɛ, yé yé ní sah kè noh: ");
INSERT INTO wib_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Névye nónó-à Liyel tɔ̃́rɩ́ tyɩ́ yónɔ́ noh tɛ́ pè náh ké dùkù pɩ̃, sétã̀n yõ̀tɛ̃̀ n pɔ wɛy mɛ̀ wilki pé fɔkɔnɩ sɔkɔ. Pè mɛ wɛ̃̀gbalɩ tyɩ́ kɔ̃lɛ ńyãh sɔkɔ-á sèmukɔ syɩkɩlɩ. ");
INSERT INTO wib_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Túkù mɛ légbɩ̃́ yõ tyɩ́ kɔ̃lɛ, ńyãh sɔkɔ-á sèmukɔ mir mɔ. Pépi-à wɛy mɛ̀ noh, nɛ́npɔ́ swɔ pě kè fɛ̃ n syi nɩ̀vɩ̀nɩ̀ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Tɛ́ pè náh n yɛ kè yã̀hnɩ̀nɛ n mɔ pé sɔkɔ. Pě kè fɛ̃ n syi nɛ́npɔ́ swɔ ó sɔkɔ. Tɛ́ yèvyãhrɩ, képah náh pɩ fṍhnɔ́-à núkú pè yĩni tɛ̃ kénɛ wɛy yĩnnɛ, pě pé náh vi kè kɔ̃ súú. ");
INSERT INTO wib_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Túkù mɛ pã̀n tɛ̃̀-ǹsah tyɩ́ kɔ̃lɛ, pàh wɛy mɛ̀ noh, kèkõyṍ tyi fɔkɔ sõnɔ ànɛ̂ tahrɩ dékè n pɔ ké yah kõ, kè náh n tɛ̃ n wɛ tirlɛ n pɛkɩ pé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Túkù wɔ mó mɛ sétáh pèpɛy tyɩ́ kɔ̃lɛ, pépi-à wɛy mɛ̀ noh, pě ké dùkù pɩ̃, yõre n wɛ ké tyɩ́ sèmukɔ tyɩ́ kɔ̃lɛ, nónó-á pyenɔ lèkwɛ̌kwɛ pɩ, ànɛ̂ nónó-á tikitɔ̃nɩ́tɔ̃nɩ pɩ, ànɛ̂ nónó-á yõgbãmgbãm pɩ.» ");
INSERT INTO wib_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu tɔ̃ sèmìrkì yɔ́ yãh pé tyɩ́ nɛ ńkɛ̃́: «Yé yah, Liyel tɔ̃́rɩ́-á kɩ fɛ̃ tɔkɔ sãh sèmìrkì nɛ̂nɛ, kè wɛ yɔ̀: Dĩ́ yɔ́ lésõ sèmukɔ duku pèpɛy mir mɔ ǹ swãh sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Tɛ́ névye-á pɔ dɔ gbĩ́ nɛ̂nɛ, ǹ sépɛ kyɩ fílpyé mir dah mɔ kɔ̃ ké sɔkɔ nɛ̂-á mɛ ké kètɔ̀lɛ, tɛ́ ǹ náh vi sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Kǎh pɔ kyãh tɛ́ n dubi gbĩ́ nɛ̂nɛ, fílkì tɔ ké yõ wilki mɔ kwèy. ");
INSERT INTO wib_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Sètɛ̃̀ dĩ́ tõ̀npɩbɩ-á kè kyɔmɩ wɛ sɛ̃́, pè mɛ kyɩ kè yo pé yõ̀tɛ̃̀ dĩ́ tyɩ́ nɛ ńkɛ̃́, pé yõ̀tɛ̃̀, sèmukɔ duku pèpɛy-á se sõ̀ à mir mɔ ǹ swãh sɔkɔ; tɛ́ kè se pɩ sɔ̃́ tɛ́ fílkì tɔ pɔ n wɛ ké sɔkɔ nɩ? ");
INSERT INTO wib_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","À mɛ yo pé tyɩ́ nɛ, sépɛ yɔ́ tõ̀ vyãh-á képahlɛ. Pè mɛ nɛ, à se mɛ ké tyɩ́ nɛ pé kyɩ sè viki nɩ? ");
INSERT INTO wib_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","À mɛ nɛ ɔ̃́ɔ̃-á. Ńkɛ̃́ pàh kɩ nɛ páh sélɛ n viki, sèmukɔ tɔ-á kɩ syah n kwrɔ n mɔ n viki sélɛ. ");
INSERT INTO wib_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Pè yɛ sé yõ sè nɛ n kyãh wɛ̃ tyɩ́ kè syi pɔ n nɔ sèmukɔ tɔkɔ gbĩ́ tyɩ́. Tɛ́ sèmukɔ tɔkɔ gbĩ́-à kɩ pɔ nɔ, páh kɩ yo sèmukɔ tɔ́kɔ́pú tyɩ́ nɛ pè fílkì ǹgbò kõ, pè mó sè pukubi pbɔ pbɔlɛ pè kyɩ n sukɛ. Tɛ́ sèmukɔ wɔlɛ, pè képah tɔkɔ n mɔ pé dúkúrí sɔkɔ.» ");
INSERT INTO wib_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu tɔ̃ sèmìrkì yɔ́ yãh pé tyɩ́ nɛ: «Yé yah, Liyel tɔ̃́rɩ́-á kɩ fɛ̃ tɔkɔ sãh sèmìrkì nɛ̂nɛ, kè wɛ yɔ̀: Dĩ́ yɔ́ lésõ mútárdɩ̀ pi tɔkɔ duku mɔ ǹ swãh sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Képah yilɔ kal yípyé póllɛ. Tɛ́ kàh fi, kè n pɩ gblò kal sèmukɔ duke póllɛ. Kè n pɩ séswɔ̂ sɔ̃́, kèpye n pɔ syɛ̀ pɩ ké yɩ̃̀ngbã̀n tyɩ́.» ");
INSERT INTO wib_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Képah náh Yesu tɔ̃ sèmìrkì yɔ́ yãh pé tyɩ́ nɛ: «Yé yah, Liyel tɔ̃́rɩ́-á kɩ fɛ̃ tɔkɔ sãh sèmìrkì nɛ̂nɛ, kè wɛ yɔ̀: Sê yɔ́ lésõ kɔ́kɔ́nɔ́ tɔkɔ mɔ tɔkɔ yɩ̃́ tɔ̃́nɔ́ mífã́hkɩ̀ sɔkɔ, ké pól kɔ̃ kè dɔkɔ.» ");
INSERT INTO wib_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu sõ̀ mɛ tyi nɔ́pi póllɛ n yãh tɔ́wû tyɩ́ sèmìrn ó sɔkɔ. À náh sõ̀ mɛ tir yɔ́ ńtɛ̃nɛ n yo pé tyɩ́ nɛ́ sèmìrn sɔkɔ náh. ");
INSERT INTO wib_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","À képah pɩ Liyel tɛ̃ntõ̀ syínyo-ò tir yónsàhnɔ́ kɔ̃ kè wil. À lésõ nɛ ńkɛ̃́: «Mé kɩ tyilɛ n yo sèmìrn sɔkɔ. Tyi nónó-á sõ̀ mɛ wɔ̃̀bɩ̀nsàhnɔ́lɛ kèkõyṍ mɔ gbĩ́ dùkùlɛ, mé kɩ névye níkí yɩkɩ sélɛ.» ");
INSERT INTO wib_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Képah tɛ̃̀nɛ, Yesu yal tɔ́wû tnɔ̂ à sɔkɔ gbô. Ǹ tõ̀ sã́hpú mɛ nɔ de ǹ tnɔ̂ tɛ́ yo ǹ tyɩ́ nɛ, swãh sɔkɔ fílkì sèmìrkì nɛ̂-á sõ̀ à yãh, à ké yõ yo pé syah. ");
INSERT INTO wib_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","À mɛ yo pé tyɩ́ nɛ: «Sèmukɔ duku pèpɛy mírnmɔ-òlɛ, Névi Pídĩ́ ye. ");
INSERT INTO wib_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Swãhlɛ, kèkõyṍ ye. Sèmukɔ duku pèpɛynɛ, Liyel yõ̀tɔ̃rɩ́ sɔkɔ wɛ̃́npì ye. Fílkìlɛ, sétã̀n yõ̀tɛ̃̀ náh névye ye. ");
INSERT INTO wib_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Sépɛ nɛ̂-á mir dah mɔ fílpyélɛ, sétã̀n yõ̀tɛ̃̀ ye. Sèmukɔ tɔ́kɔ́nɔ́lɛ, kèkõyṍ tyɛ́nɔ́ ye. Sèmukɔ tɔ́kɔ́púlɛ, yĩ̂nyõ tõ̀npɩbɩ ye. ");
INSERT INTO wib_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Sɔ̃́-á pě fílkì viki n sukɛ nyàh sɔkɔ, sɛ̃́nkɔ̃ ye kɩ n pɩ n pi kèkõyṍ tyɛ́nɔ́ tɔ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Névye nónó pól-á névye yõlɛ n yɩkɩ n mɔ pèkè pɩ́nɔ́ sɔkɔ, ànɛ̂ nónó pól-á tyítúkúnì pɩ́púlɛ, Névi Pídĩ́ kɩ ǹ yĩ̂nyõ tõ̀npɩbɩ tɛkɩ n mɔ n pi, pè kɩ pɔ pè wilki ǹ tɔ̃́rɩ́ tyah sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Tɛ́ kɩ pè min dah mɔ sĩnki nyàh sɔkɔ, ńyãh sɔkɔ-á gbní ànɛ̂ yní táhnɔ́ kɩ mɛ. ");
INSERT INTO wib_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ǹtɛ névye nónó-á mɛ nɛ́gblɔ́lɛ Liyel yah, pépi wɔ kɩ n tɛ̃ pé Sú Liyel tɔ̃́rɩ́ sɔkɔ, gbĩ tyɩ́ kɔ̃lɛ. Nɛ̂-à kɩ mɛ kè noh, tɛ̃̀ kè tɛ̃ yĩn.» ");
INSERT INTO wib_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Képah náh, Yesu tɔ̃ yo pé tyɩ́ nɛ: «Yé yah, Liyel tɔ̃́rɩ́-á kɩ fɛ̃ tɔkɔ sãh sèmìrkì nɛ̂nɛ, kè wɛ yɔ̀: Dĩ́ yɔ́ lésõ kyɩ wil mɔ tahrɩ wɔ̃̀bɩ̀nsàhnɔ́ yɔ́ yõ swãh yɔ́ sɔkɔ, tɛ́ kè tɔkɔ tɔ̃ wɔ̃bɩ. Ké wɛ́nɔ́ nɩ̀vɩ̀nɩ̀ tɛ̃̀ tyɩ́, à sɔkɔ à kyɩ ǹ gbã̀n yî pól yãm à pɔ swãh mɛ̀ dwe. ");
INSERT INTO wib_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Yé yah, Liyel tɔ̃́rɩ́-á kɩ tɔ̃ fɛ̃ tɔkɔ sãh sèmìrkì nɛ̂nɛ, kè wɛ yɔ̀: Gbɔ̀ yɩ̃́-ò yɔ́ lésõ mɛ, nɛ̂-á yî kètǎrnɔ́ yísyɔ́lɛ n yah n kɔ̃, pè n ye pɛ́rlɩ̀nɔ́lɛ. ");
INSERT INTO wib_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Wǎh pɔ ké dɛ́nkɔ́kɔ̀ yɔ́ wɛ, à kyɩ ǹ gbã̀n yî pól yãm à pɔ kè dwe.» ");
INSERT INTO wib_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","«Yé yah, Liyel tɔ̃́rɩ́-á kɩ fɛ̃ tɔkɔ sãh sèmìrkì nɛ̂nɛ, kè wɛ yɔ̀: Nósyɔ́ lésõ yɛ̃́nkyɔ tɛ̃ tɛ̃ mnɔ min dah mɔ yɔ sɔkɔ, à yɛ̃́nkyɔ duke pól tɛ̃. ");
INSERT INTO wib_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Kǎh yuku, pè kè yɔrɩ wilki pɔ kènkwã̀h yõ, tɛ́ kɔ̃ tɛ̃ à yɛ̃́nkyɔ gblɔ wah mɔ dú sɔkɔ, tɛ́ sé tɛ́lɔ́ milki. ");
INSERT INTO wib_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Sɛ̃́ ye kɩ n pɩ n pi kèkõyṍ tyɛ́nɔ́ tɔ sɔkɔ. Yĩ̂nyõ tõ̀npɩbɩ kɩ pɔ nɛ́túkúnì wah wilki nɛ́gblɔ́ sɔkɔ, ");
INSERT INTO wib_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","kɩ kyɩ pè min dah mɔ sĩnki nyàh sɔkɔ, ńyãh sɔkɔ-á gbní ànɛ̂ yní táhnɔ́ kɩ mɛ.» ");
INSERT INTO wib_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Képah náh Yesu tɔ̃ yo ǹ tõ̀ sã́hpú tyɩ́ nɛ: «Yé se tyi nɔ́pi pól noh wah?» Pè mɛ nɛ àwe-á. ");
INSERT INTO wib_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Képah sɔkɔ, à mɛ yo pé tyɩ́ nɛ: «Liyel tyi kõ̀nsàhnɔ́ kwɔ́pú nónó-á sõ̀ kwɔ́nɔ́ wɛ sɔkɔ Liyel tyi kõ̀nsàhnɔ́ tyɩ́ yõ ǹgbòlɛ, tɛ́ tɔ̃ pɔ kwɔ́nɔ́ wɛ Liyel tɔ̃́rɩ́ tyɩ́ yõ núkúnúkú, tɛ́ névyelɛ n kwɔ sélɛ, pépi mɛ kéte tɛ̃̀ yɔ́ sɔ̃́, nɛ̂-á yídî sõ̀ mɛ ǹ tyɩ́ ǹ dúkúrí sɔkɔ, tɛ́ à tɔ̃ pɔ snɔ́ wɛ dohnɩ sé yõ, tɛ́ mɛ sélɛ névyelɛ n kɔ̃.» ");
INSERT INTO wib_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Tɛ́ Yesu-á sèmìrn nɔ́pi yãh tɛ pé tyɩ́ gbĩ́ nɛ̂nɛ, à yal nɛ́npɔ́ ");
INSERT INTO wib_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","tɛ́ sɔkɔ ǹ kwil sɔkɔ. Wǎh kyɩ nɛ́npɔ́, à kyɩ kwɔ́nɔ́lɛ n pɩ pé Liyel ní-ńsah wɔ̀kɔ̀ sɔkɔ, fɔ́ɔ́ no pól gbã̀n du ǹ tyɩ́lɛ. Pè sõ̀ mɛ yo tũ nɛ, à se wɛ ńyãh lékã́m ànɛ̂ tɛ̃́nwɛnɔ mɛ̀nɛ, à fɛ̃ gbǐl nɔ́pilɛ n pɩ nɩ? ");
INSERT INTO wib_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ǹmɔ kó sésár sɛ́-ò pídĩ́nɛ nɩ? Ǹ yṹ yĩn kó Marilɛ, tɛ́ ǹ gbɛ̃̀ndĩ́pi mɛ Nsyakɩ, ànɛ̂ Nsyosɛfu, ànɛ̂ Simo, ànɛ̂ Nsyudelɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Tɛ́ ǹ dósyɔ́ pól kó mɛ pépilɛ ásõ̂ yɔ̀ nɩ? Ǹtɛ ńyãh tɛ̃̀ ó se ǹmɔ wɛ lékã́m ànɛ̂ tɛ̃́nwɛnɔ mɛ̀nɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Képah sõnɔ sõ̀ mɛ pé yõ yɩkɩ pè kɔ̃ pè tɛ̃ sɛ̃ kwlɔ Yesu yõ. Képah sɔkɔ, Yesu mɛ yo pé tyɩ́ nɛ: «Liyel tɛ̃ntõ̀ syínyo-ò kwil ànɛ̂ ǹ kéte sɔkɔ ó ye pè náh ǹnɛ n mɔ n kõ Liyel tɛ̃ntõ̀ syínyo-òlɛ.» ");
INSERT INTO wib_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Pǎh yahle sɛ̃́nɔ́lɛ Yesu yõ sɛ̃́, à náh mó gbǐlnɔ́ náhnáh pɩ nɛ́npɔ́. ");
INSERT INTO wib_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Légbĩ́nɛ, Kalile mara yõ̀tɛ̃̀ dĩ́ Yerɔdɩ Yesu tyɩ́ yónɔ́ noh, ");
INSERT INTO wib_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","tɛ́ yo ǹ tõ̀npɩbɩ tyɩ́ nɛ, Wèlnwìlkì-ò Nsyɔ̃-á yɔ̀ tɔ́tɔ́. Ǹ lékó-á yilki mɔ. Képah-á tɛ̃́nwɛnɔlɛ ǹ tyɩ́ à fɛ̃ gbǐlnɔ́lɛ n pɩ. ");
INSERT INTO wib_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Yé náh wɛ di, ǹgbòlɛ, Yerɔdɩ lésõ ǹ gbɛ̃̀ndĩ́ Filipi kyɩ Yerɔdyadɩ tɛ̃ syi. Nsyɔ̃ mɛ kè yo ǹ tyɩ́ nɛ, ké yah náh à à tɔkɔ. Pi mɛ̀ yĩnnɛ, Yerɔdɩ mɛ pè kɔ̃ pè Nsyɔ̃ tɛ̃ à kârn mɔ ǹ tyɩ́, tɛ́ à dah mɔ sah wɔ̀kɔ̀npèkè sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","À lésõ mɛ ké tyɩ́ nɛ pé Nsyɔ̃ ko mɔ. Ǹtɛ tɔ́wû-á lésõ mɛ Nsyɔ̃nɛ n mɔ n kõ Liyel tɛ̃ntõ̀ syínyo-òlɛ sɛ̃́, pépi yah tíkí mɛ à tɛ̃. ");
INSERT INTO wib_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ǹtɛ Yerɔdɩ dúbínɔ́ yòh vìnpɔnɔ syáh syah sõlɛ, Yerɔdyadɩ písê yɔ̃ yi nɛ́yénɔ́ yah sɔkɔ. Kè mɛ nɔ Yerɔdɩ tyɩ́, ");
INSERT INTO wib_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","fɔ́ɔ́ à ǹ vyãhlɛ à kɔ̃, tɛ́ ǹ wo ǹ tyɩ́ nɛ wàh kɩ sɔ̃́ kwáhdúkú nɛ̂ yah kɔ̃ pé tyɩ́, páh kɩ kélɛ à kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Képah sɔkɔ, pípír yṹ mɛ à kurki mɔ à kɔ̃ à yo Yerɔdɩ tyɩ́ nɛ, à Wèlnwìlkì-ò Nsyɔ̃ yõlɛ pé kɔ̃ ásõ̂ dú pyahrɔ yɔ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Képah tɛ̃̀nɛ, kè yõ̀tɛ̃̀ dĩ́ yah kwɔ. Ǹtɛ ǹ wónɔ́ mɛ̀ yĩnnɛ ǹ nɛ́yénɔ́ yĩ́ yah, à nɛ pè pɔ kélɛ à kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Tɛ́ pè kɔ̃ pè kyɩ Wèlnwìlkì-ò Nsyɔ̃ yõ kãm wɔ̀kɔ̀npèkè sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Pǎh kè kãm, pè kè dah mɔ dú pyahrɔ yɔ́ sɔkɔ à pɔ pípír kɔ̃, à mɛ kè syi kyɩ ǹ yṹ kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Nsyɔ̃ tõ̀ sã́hpú mɛ pɔ ǹ lékó tɔkɔ kyɩ yɩ̃, tɛ́ kyɩ ké yah yo Yesu syah. ");
INSERT INTO wib_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu-á yĩ mɛ̀ noh sɛ̃́, à de krótókè yɔ́ sɔkɔ ànɛ̂ ǹ tõ̀ sã́hpúlɛ pè yal nɛ́npɔ́, à yuku gbɛ̃́nnɩ tyah yɔ́ sɔkɔ à kyɩ tɛ̃ pé yahlɛ. Tɔ́wû-á pé sɔ́kɔ́nɔ́ tyɩ́ noh ńyãh sɔkɔ, pè wil kwlo kwlo sɔkɔ à pé nyáh sõ gbáhkɩ̀ yõ. ");
INSERT INTO wib_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesu-á wil krótókè sɔkɔ tɛ́ tɔ́wû ǹgbɛ̃ wɛ sɛ̃́, pé yãm à tɛ̃. À mɛ pé yámpú dɛ mɔ. ");
INSERT INTO wib_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ńvɩ̃́-á pɔ nɔ, ǹ tõ̀ sã́hpú nɔ de ǹ tnɔ̂ tɛ́ yo ǹ tyɩ́ nɛ, gbɛ̃́nnɩ tyah sɔkɔ-á pélɛ yɔ̀. Tɛ́ lékã̂h-á mɛ n tyah mɔ́nɔ́lɛ, à kó tɔ́wûlɛ n fĩn n mɔ pè kyɩ yõ yõ yîlɛ n yah n dwe kwlo sɔkɔ nɩ? ");
INSERT INTO wib_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesu mɛ yo pé tyɩ́ nɛ, yõ náh mɛ ké tyɩ́ pè sɔkɔ. Pépi yõke yah pé gblɔ̌y pè kɔ̃ pè yõ. ");
INSERT INTO wib_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Képah sɔkɔ, pè mɛ yo ǹ tyɩ́ nɛ, búrn plɔ́ kwlɔ́ ànɛ̂ yɛ̃́nkyɔ plɔ́ nínɔ́ ó-á mɛ pépi tyɩ́ ásõ̂ dò. ");
INSERT INTO wib_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesu mɛ yo pé tyɩ́ nɛ, pè sè tɔkɔ n pɔ pé kɔ̃ ásõ̂. ");
INSERT INTO wib_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Tɛ́ mɛ tɔ́wû kɔ̃ pè kɔ̃ tɛ̃ fílkì yõ, tɛ́ búrn plɔ́ kwlɔ́ ànɛ̂ yɛ̃́nkyɔ plɔ́ nínɔ́ nɔ́pi tɔkɔ, tɛ́ ǹ yah yɔ̃ yĩ̂nyõ à wɛkɩ Liyel tyɩ́, tɛ́ sè kwɔkɩ mɔ ǹ tõ̀ sã́hpú kɔ̃ pè syi tɔ́wû kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Pé pól mɛ yõ tɔ̃, tɛ́ pè mɛ pé yṍnkwlɔnɔ tɛ́lɔ́ tuke mɔ vyɔ́ gbɔ̃ninɔ́ yĩ́ĩ́nɛ. ");
INSERT INTO wib_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Tɛ́ nónó-á sõ̀ yõ yõke mɛ̀nɛ, pè sõ̀ mɛ díbí nɛ́pĩ̂ kèyõ nínɔ́ kyɛgbãm (5 000) kénkɔ̃lɛ syɔ́ ànɛ̂ wɛ̃́npì vyãh kɛ̃́nɛ. ");
INSERT INTO wib_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Képah náh, Yesu núkú ǹ tõ̀ sã́hpú gbah tɛ̃ nɛ pè de krótókè sɔkɔ, pè mɔ pé yahlɛ yɔ́-ǹgbɛ̃ kahnɩnɛ, péwɔ mó tɔ́wû fĩn mɔ. ");
INSERT INTO wib_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Wǎh pé fĩn mɔ tɛ, à dɔkɔ yuku yɔ̃lɩ yõ à kyɩ tɛ̃ ǹ tyɩ́lɛ à Liyellɛ n ni. Lékã̂h mɔ pɔ à wɛ ǹ gblɔ̌y nɛ́npɔ́. ");
INSERT INTO wib_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Tɛ́ légbĩ́nɛ, krótókè sõ̀ mɛ gbɛ mɔ tɛ yɔ vyãhlɛ náhnáh. Tɛ́ yã́hkɩ́ sõ̀ mɛ pélɛ n yohnɩ. Kǎh pɩ sɛ̃́, ni sõ̀ mɛ krótókèlɛ n kah n fwo. ");
INSERT INTO wib_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Tyah dal gbĩ́nɛ, Yesu tyah n kɔ n yuku pé tnɔ̂ yɔ yõ. ");
INSERT INTO wib_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Pǎh à wɛ à n kɔ n pi yɔ yõ sɛ̃́, pé sãm yɔkɔ. Pè tyah n yo nɛ lékó mírkí yɔ́-á. Tɛ́ tyah n de n syi tíkí tɛ̃̀ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ǹtɛ nɛ́npɔ́ swɔ, Yesu mɛ yo mɔ pé tyɩ́ nɛ, pè pé nɩ syãh. Péwɔ-á, pè káh tíkí pɩ. ");
INSERT INTO wib_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Képah sɔkɔ, Pyɛrɩ mɛ yo ǹ tyɩ́ nɛ, Tɛ̃̀ ǹgbɛ̃, ǹmɔ-à kɩ nɛ̂ ńtyɩ̃́nɔ, à péwɔ kɔ̃ pé wil kɔ pɔ ǹ tnɔ̂ yɔ yõ. ");
INSERT INTO wib_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesu mɛ yo ǹ tyɩ́: «Pɔ!» Pyɛrɩ mɛ wil krótókè sɔkɔ à tyah n kɔ n yuku Yesu tnɔ̂ yɔ yõ. ");
INSERT INTO wib_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ǹtɛ wǎh pɔ kè kyɔmɩ wɛ nɛ yã́hkɩ́-á mɛ n kah n pɩ, tíkí à tɛ̃. Képah sɔkɔ, à tyah n tiki n de ni sɔkɔ tɛ́ de syi nɛ, Tɛ̃̀ ǹgbɛ̃, à pé pwah mɔ oo! ");
INSERT INTO wib_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Nɛ́npɔ́ swɔ Yesu núkú ǹ gbõ̀ nɔ à à tɛ̃ tɛ́ yo ǹ tyɩ́ nɛ, à náh sɛ̃ péwɔ yõ fwɔ́ɔ lɔ́. Sɔ̃́ se pɩ tɛ́ à n sõ tɔ̀tɔ̀ nɩ? ");
INSERT INTO wib_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Tɛ́ pè mɛ de krótókè sɔkɔ, yã́hkɩ́ núkú yĩn. ");
INSERT INTO wib_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Nónó-á sõ̀ mɛ krótókè mɛ̀ sɔkɔ, pè gbètukunɔ di Yesu yah tɛ́ yo ǹ tyɩ́ nɛ, kègbɩ yõ, ǹmɔ-á Liyel Pídĩ́nɛ. ");
INSERT INTO wib_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Yesupi-á yɔ́-ǹgbɛ̃ kah tɛ, pè de Yenesarɛtɩ sétáh yõ. ");
INSERT INTO wib_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Nɛ́npɔ́ tãn mɛ à yah pɩ̃, tɛ́ núkú ǹ pɔ́nɔ́ yo soh mɔ nɛ́npɔ́ tĩ̀n tãn pól tyɩ́. Pè mɛ pɔ pé yámpú póllɛ ǹ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Tɛ́ ǹnɛ n ni nɛ, à yɛ pé kɔ̃ pé tũ ǹ fwɔ̀mɔnɩ vyãh ńtɛ̃ ó tyɩ́. Tɛ́ nónó pól-á fyɔ̀ tũ ké tyɩ́, pè dɛ. ");
INSERT INTO wib_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Képah sɔkɔ, Farisi wɛ̃̀kɩ̀ kɔ́pú ànɛ̂ Liyel tyi kõ̀nsàhnɔ́ kwɔ́pú wil Yerusalɛmɩ kwil sɔkɔ à pɔ Yesu tnɔ̂, tɛ́ à syah nɛ ńkɛ̃́, ");
INSERT INTO wib_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","sɔ̃́ se pɩ tɛ́ ǹ tõ̀ sã́hpú náh mɛ n kɔ lékɔ̃lɔ́ wã̀ldì yõ nɩ? À nɛ n yah pè yãrlɛ n yõ, tɛ́ pè náh se mó tɔ̃ pé gbã̀n wu à yɩ̃nɛ pé wã̀ldìlɛ lɛ́. ");
INSERT INTO wib_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","À mɛ yo pé tyɩ́ nɛ: «Tɛ́ yépi wɔ-á dò, sɔ̃́ pɩ tɛ́ yé wã̀ldì yĩnnɛ, yé náh mɛ n kɔ Liyel tyi kõ̀nsàhnɔ́ wã̀l yõ? ");
INSERT INTO wib_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Yé yah, Liyel kè yo nɛ ńkɛ̃́: ‹Yõ̀yénnɛ n sah á sú ànɛ̂ á yṹ yõ.› Tɛ́ tɔ̃ kè yo nɛ ńkɛ̃́: ‹Névi nɛ̂-à wɛ̀ntùkù wɛkɩ ǹ sú tyɩ́, képah náh pɩ ǹ yṹ tyɩ́, tɛ̃̀ yɩ̃nɛ kònmɔnɔlɛ.› ");
INSERT INTO wib_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ǹtɛ yépi wɔ n mó nɛ, névi nɛ̂-à yo ǹ sú képah náh pɩ ǹ yṹ tyɩ́ nɛ, kwâh nɛ̂-á sõ̀ mɛ pé tyɩ́ ǹ yohnɩ n mɔ mɔ tɛ̃̀nɛ, páh képahlɛ Liyel kɔ̃ tɛ, ");
INSERT INTO wib_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ǹ dúbí-ò mɛ̀ yòhnɩ̀nmɔnɔ kɔ̃lɩ náh tɔ̃ mɛ ǹ yõ. Kàh pɩ sɛ̃́ à, Liyel tyi kõ̀nsàhnɔ́ náh yé yɩkɩ yé wã̀ldì yĩnnɛ di? ");
INSERT INTO wib_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Vyã́hsesyɩ̃́rɩ́ névye nɔ́pi, Liyel-á lésõ Yesayi kɔ̃ à nɛ̂ yo sah, képah ye yépi n pɩ yɔ̀. À lésõ nɛ ńkɛ̃́: ");
INSERT INTO wib_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","«No nɔ́pilɛ, vyãh ó sɔkɔ ye pè n gbilki ńmɔlɛ. Ǹtɛ pé nnɔ mɛ fɩ́ɩ́ ńnɛ. ");
INSERT INTO wib_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Pǎh kwɔ́nɔ́lɛ n pɩ tyi nónó yõ, névye yah yĩ́ĩ́ tyi kõ̀nsàhnɔ́ ye sélɛ. Képah ye, gbílkínɔ́ nɛ̂-á pè n gbilki n pɔ ńnɛ pè yo, nɔ̀nɔ́ ye kélɛ.» ");
INSERT INTO wib_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Képah sɔkɔ, Yesu tɔ́wû mɛ̀ ye tuke tɛ́ yo pé tyɩ́ nɛ: «Yé yé ní kwɔ n noh pallɛ, yè wɛlɔ nɔ́pi syɩ́kɩ́-ńsah pɩ̃. ");
INSERT INTO wib_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Yî nónó-á n de névi vyãh sɔkɔ, sépi náh n silki ǹnɛ Liyel yah dɛ́. Wɛlɔ nónó-á n wil ǹ vyãh sɔkɔ, sépi ye n silki ǹnɛ.» ");
INSERT INTO wib_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Képah tɛ̃̀nɛ, ǹ tõ̀ sã́hpú mɛ nɔ de ǹ tnɔ̂ tɛ́ yo ǹ tyɩ́ nɛ, à kó pɩ̃ nɛ ǹ wɛlɔ nónó-á sõ̀ sé yey mɔ Farisi wɛ̃̀kɩ̀ kɔ́pú tĩ̀nnɛ, sǎh pè kah yɔ nɩ? ");
INSERT INTO wib_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","À mɛ yo pé tyɩ́ nɛ: «Yèh nónó pól tɛ̃̀-á fyɔ̀ mɛ, tɛ́ ń Sú nɛ̂-á yĩ̂nyõ ǹmɔ sṍnɔ́ náh sélɛ, sè kɩ viki to. ");
INSERT INTO wib_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Yé yɛ pé yõ. Yɩ̃́tũbi ye pélɛ, nónó-á mɛ pé no yɩ̃́tũbi yahlɛ n tɛ̃. Tɛ́ yɩ̃́tũ̂-à mó tɔ̃ ǹ ní-ò yɩ̃́tũ̂ yah tɛ̃, pé nímí kɩ syɩkɩ de pwã̀h yɔ́ sɔkɔ.» ");
INSERT INTO wib_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Képah sɔkɔ, Pyɛrɩ mɛ yo ǹ tyɩ́ nɛ, wǎh sõ̀ nɛ pé pé ní kwɔ wɛlɔ nónó noh pallɛ, à sé kɔ́r yo pé syah. ");
INSERT INTO wib_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","À mɛ pè syah nɛ: «Lékã́m kɛ̃́ névye se yépi tɔlɛ? ");
INSERT INTO wib_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Yé náh pɩ̃ nɛ yî nónó pól-á n de vyãh sɔkɔ, sǎh ńkɛ̃́nɛ n syɔ̃ kèkùrkì sɔkɔ, ǹ tɛ́ n pyě n pɔ n wilki n kwɛ kèdúkúdahkɩ sɔkɔ di? ");
INSERT INTO wib_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ǹtɛ wɛlɔ nónó-á n wil vyãh sɔkɔ, sé sõ n wil sõnɔ sɔkɔ. Sépi ye n silki névilɛ Liyel yah. ");
INSERT INTO wib_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Névi lékã́m sɔkɔ ye sõnɔ túkúnì n wil, ànɛ̂ nɛ́kókè mɔ́nɔ́lɛ, ànɛ̂ fɔ̀fɩ́kɩ̀ pɩ́nɔ́lɛ, ànɛ̂ prɔ̀prɔ̀ pɩ́nɔ́lɛ, ànɛ̂ yɩ̃belɛ, ànɛ̂ mɩ̀nɩ̀ yónɔ́lɛ, ànɛ̂ gbyɔlɛ. ");
INSERT INTO wib_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Kénɛ tyi wɔ ye n silki névilɛ Liyel yah. Ǹtɛ névi-à ǹ gbã̀n wú-ńkɛ̃̂nɛ à yɩ̃nɛ wã̀ldì-á kè yo sɔ̃́ tɛ́ yõke yõ, képah náh n silki tɛ̃̀nɛ.» ");
INSERT INTO wib_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Képah náh, Yesu yal nɛ́npɔ́ tɛ́ sɔkɔ Tiri ànɛ̂ Sidõ sétáh yõ. ");
INSERT INTO wib_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Tɛ́ pi yɔ́ sõ̀ mɛ nɛ́npɔ́ nɛ̂-á Kanah nɛynɛ. Ǹmɔ mɛ pɔ Yesulɛ yúkɛy tɛ́ mɛ n de n syi, mɛ yo tũ ǹ tyɩ́ nɛ pé Tɛ̃̀ ǹgbɛ̃, ǹmɔ nɛ̂-á Davidi Pídĩ́nɛ, à pé yãm yah. Ńkɛ̃́ sétõ yɔ́-á mɛ pé písê sɔkɔ mɛ ǹnɛ n kwlɔ képékèyɔ̂. ");
INSERT INTO wib_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ǹtɛ Yesu náh dahbɩ wilki ǹ tyɩ́. Ǹ tõ̀ sã́hpú mɛ nɔ de ǹnɛ tɛ́ kè yah kɔ̃ ǹ tyɩ́ nɛ, à pi mɛ̀ kɔ̃ à ǹ syɩ pé náh, à káh pé sõ̀ tɛ̃ nɛ n de n syi n yuku sɛ̃́. ");
INSERT INTO wib_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesu mɛ nɛ, Liyel-á pé tɛkɩ mɔ Yisrayel no ó yĩnnɛ, pépi nónó-á mɛ képyɛ́nɩ̀ mɔ́npunɔ sɔ̃́. ");
INSERT INTO wib_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ǹtɛ pi mɛ nɔ pɔ ǹ gbètukunɔ di ǹ yah, tɛ́ yo ǹ tyɩ́ nɛ pé Tɛ̃̀ ǹgbɛ̃, à pé yohnɩ n mɔ. ");
INSERT INTO wib_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesu mɛ à syah nɛ, ké yah náh pè wɛ̃́npì yõke tɔkɔ n mɔ pã̀hnpye kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Pi mɛ yo ǹ tyɩ́ nɛ, gbɩ-á à yo pé yõ̀tɛ̃̀. Ǹtɛ pã̀hnpye wɔ-á n yõ sé nátãm yɛ̃́nmîrn yṍnkwɛnɔlɛ. ");
INSERT INTO wib_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Képah sɔkɔ, Yesu mɛ yo ǹ tyɩ́ nɛ: «Pi, á sɛ̃ yĩ́ĩ́ ńmɔ yõ dɛ́. Wáh nɛ̂ yah kɔ̃, Liyel kɩ kè pɩ á tyɩ́.» Légbĩ́ mɛ̀ ó sɔkɔ, pi písê núkú dɛ. ");
INSERT INTO wib_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Képah náh, Yesu yal nɛ́npɔ́ à yuku Kalile yɔ́-ǹgbɛ̃ gbɔ̀pɔ. Tɛ́ dɔkɔ yuku yɔ̃lɩ yõ à kyɩ kɔ̃ tɛ̃. ");
INSERT INTO wib_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Képah tɛ̃̀nɛ, nɛ́kwĩ́nkí pé yámpú tɛ̃ pɔ ǹ tyɩ́ à pɔ pè sah ǹ yah sɔkɔ. Túkù sõ̀ mɛ gbáhkɩ̀ núkú névyelɛ, túkù mɛ yɩ̃́tũbilɛ, túkù mɛ nɛ́dónènɛ, túkù mɛ kèdyɔ̀nɩ̀nɛ, à tahlɩ yámpú túkù tyɩ́. Tɛ́ Yesu mɛ pè dɛ mɔ. ");
INSERT INTO wib_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Kè pɩ gbɛ̃̀ndùnìnɛ tɔ́wû tyɩ́, pǎh kèdyɔ̀nɩ̀ wɛ pè mɛ fɛ̃ n wɛkɩ, nɛ́dónè dónɔ́nɔ mɛ tyɛ, gbáhkɩ̀ núkú névye mɛ fɛ̃ n kɔ tómtóm, tɛ́ yɩ̃́tũbi mɛ fɛ̃ n yah. Képah tɛ̃̀nɛ, pè gbílkínɔ́ sah Yisrayel Liyel yõ. ");
INSERT INTO wib_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu ǹ tõ̀ sã́hpú ye, tɛ́ yo pé tyɩ́ nɛ, tɔ́wû mɛ̀ yãm-á mɛ péwɔ tɛ̃. Pé sèpĩ̀n tɔ̃́nɩ̀-á péwɔ náh sɔkɔ kwɛynɛ yɔ̀, tɛ́ yõ yõ kwâh náh se pé tyɩ́. Pé náh mɛ ké tyɩ́ nɛ pé pè fĩn n mɔ pè sɔkɔ kwɛkɩlɛ. Pé túkù-á kɩ kyɩ n syah n tɛ̃ n kwlɔ wɛ̃̀kɩ̀ yah. ");
INSERT INTO wib_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Képah tɛ̃̀nɛ, ǹ tõ̀ sã́hpú à syah nɛ, pé se kɩ wɛ ńyãh yõkelɛ gbɛ̃́nnɩ mɛ̀ sɔkɔ, kɩ fɛ̃ tɔ́wû mɛ̀ dùkù kɔ̃ pè kɩ yõ tɔ̃ nɩ? ");
INSERT INTO wib_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu mɛ pé piki yah nɛ, búrn plɔ́ sɔ̃́ se mɛ pé tyɩ́ nɩ? Pè mɛ nɛ kwǎrninɔ-á, à tahlɩ yɛ̃́nképì yísyɔ́ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Képah sɔkɔ, à tɔ́wû kɔ̃ pè kɔ̃ tɛ̃ sétáh. ");
INSERT INTO wib_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Tɛ́ búrn plɔ́ kwǎrninɔ ànɛ̂ yɛ̃́nkyɔ nɔ́pi tɔkɔ, tɛ́ wɛkɩ Liyel tyɩ́, tɛ́ sè kwɔkɩ à ǹ tõ̀ sã́hpú kɔ̃ pè syi tɔ́wû kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Pé pól mɛ yõ tɔ̃, tɛ́ pè mɛ pé yṍnkwlɔnɔ tuke mɔ tɔkɔ yɩ̃́ kwǎrninɔlɛ. ");
INSERT INTO wib_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Tɛ́ nónó-á sõ̀ yõ yõke mɛ̀nɛ, pè sõ̀ mɛ díbí nɛ́pĩ̂ kèyõ nínɔ́lɛ (4 000), syɔ́ ànɛ̂ wɛ̃́npì vyãh kɛ̃́nɛ. ");
INSERT INTO wib_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Képah náh, Yesu tɔ́wû fĩn mɔ pè sɔkɔ, tɛ́ mɛ de krótókè sɔkɔ à sɔkɔ Makadã sétáh yõ. ");
INSERT INTO wib_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Farisi wɛ̃̀kɩ̀ kɔ́pú yísyɔ́ ànɛ̂ Sadusi wɛ̃̀kɩ̀ kɔ́pú yísyɔ́ nɔ de Yesu tnɔ̂ nɛ pé à mɔ yah. Tɛ́ à syah nɛ à gbǐl yɔ́ pɩ pé yah, nɛ̂-á n wɛ̃kɩ nɛ wǎh n wil Liyel tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Képah sɔkɔ, Yesu mɛ yo pé tyɩ́ nɛ: «Gbĩ́yĩ́ de gbĩ́nɛ, yĩ̂nyõ-à mɛ gbɔ̃̌lɩ̀ɩ̀, yè n nɛ tyah yah-á kɩ yɩkɩ mɔ. ");
INSERT INTO wib_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Tɛ́ séngbɔ̃́lɛ, yĩ̂nyõ-à mɛ fĩ̌nmɔ̀ɔ̀, yè n nɛ kwɛynɛ tyah yah náh n yɩkɩ n mɔ n pi. Yé mɛ fɛ̃ tyah dùkù wɔlɛ n pnɛ, tɛ́ tyi nónó wɔ-á mɛ n pɩ kwɛy gbĩ sɔkɔ, sǎh mɛ tyi nónónɛ n wɛ̃kɩ, yé tɛ̃ sépi wɔ dùkù pɩ̃ kwlɔ kɛ̀? ");
INSERT INTO wib_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kwɛy gbĩ névye náh plɛ. Pè náh mɛ tɛ̃ Liyel ó tyɩ́ yõ. Pè mɛ ké tyɩ́ nɛ mé gbǐl yɔ́ pɩ pé yah. Ǹtɛ kèyǎh ńtɛ̃ náh pɩ pè wɛ̃kɩ n pi, à wil Liyel tɛ̃ntõ̀ syínyo-ò Nsyonasɩ tyɩ́ sɔkɔ.» Képah yóntɛnɔ náh, à pè sah nɛ́npɔ́ tɛ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Képah náh, Yesu ànɛ̂ ǹ tõ̀ sã́hpú-á n sɔkɔ yɔ́nkahnɩnɛ, ǹ tõ̀ sã́hpú dyɔ sõ̀ fwɔ búrn tɔ́kɔ́nsɔkɔnɔlɛ. ");
INSERT INTO wib_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesu mɛ yo pé tyɩ́ nɛ: «Yé kyɔ̀mɩ̀nɔ́ pɩ. Yé yé gblɔ̌ynɛ n tɛ̃ Farisi wɛ̃̀kɩ̀ kɔ́pú ànɛ̂ Sadusi wɛ̃̀kɩ̀ kɔ́pú kɔ́kɔ́nɔ́lɛ.» ");
INSERT INTO wib_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Képah sɔkɔ, ǹ tõ̀ sã́hpú tyah n sõ nɛ pépi-á pɔ búrn kɛ̃́nɛ, képah-á à kɔ̃ à n yo sɛ̃́ yɔ̀. ");
INSERT INTO wib_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ǹtɛ Yesu mɛ pé sõnɔ pɩ̃ tɛ́ yo pé tyɩ́ nɛ: «Liyel yõ sɛ̃́nyĩ-ńkɛ̃̂pú nɔ́pi. Sɔ̃́ pɩ tɛ́ yé n sõ sɛ̃́ nɛ, yé náh pɔ búrnnɛ képah-á? ");
INSERT INTO wib_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Yé náh tɔ̃̌nɩ̀ mɛ sé dùkù pɩ̃ sɛ̃́ nɩ? Yé dyɔ náh mɛ n kwnɛ tɔlɛ máh búrn plɔ́ kwlɔ́lɛ díbí nɛ́pĩ̂ kèyõ nínɔ́ kyɛgbãm (5 000) pu, ànɛ̂ yáh yṍnkwlɔnɔ tɛ́lɔ́ tuke mɔ vyɔ́ yɩ̃́ dan nɛ̂nɛ di? ");
INSERT INTO wib_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","À tahlɩ máh búrn plɔ́ kwǎrninɔlɛ díbí nɛ́pĩ̂ kèyõ nínɔ́ (4 000) pu, tɛ́ yáh yṍnkwlɔnɔ tɛ́lɔ́ tuke mɔ tɔkɔ yɩ̃́ dan nɛ̂nɛ, yé dyɔ náh mɛ n kwnɛ kélɛ di? ");
INSERT INTO wib_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Tɛ́ sɔ̃́ pɩ tɛ́ yé náh tɛ̃ wɛ pɩ̃ nɛ búrn tyɩ́ náh mé n yo yé tyɩ́, máh sõ̀ n yo yé tyɩ́ nɛ: ‹Yé yé gblɔ̌ynɛ n tɛ̃ Farisi wɛ̃̀kɩ̀ kɔ́pú ànɛ̂ Sadusi wɛ̃̀kɩ̀ kɔ́pú kɔ́kɔ́nɔ́lɛ?» ");
INSERT INTO wib_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Képah sɔkɔ, pè pyě pɩ̃ nɛ mífã́hkɩ̀ sɔkɔ mɔ mɔ kɔ́kɔ́nɔ́ tyɩ́ náh sõ̀ Yesu n yo pé tyɩ́ nɛ pé pé gblɔ̌ynɛ n tɛ̃ kélɛ. Ǹtɛ Farisi wɛ̃̀kɩ̀ kɔ́pú ànɛ̂ Sadusi wɛ̃̀kɩ̀ kɔ́pú-á kwɔ́nɔ́ nɛ̂nɛ n kɔ̃, képah tyɩ́-á sõ̀ à n yo pé tyɩ́ nɛ pé pé gblɔ̌ynɛ n tɛ̃ kélɛ. ");
INSERT INTO wib_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu-á kyɩ yĩni tɛ̃ Filipi-Sesarɩ gbɛ̃̀nyah tĩ̀nnɛ, à ǹ tõ̀ sã́hpú piki yah nɛ: «Névye tɛ̃̀ tyɩ́ nɛ̂ mɛ ńmɔlɛ, ńmɔ nɛ̂-á Névi Pídĩ́nɛ?» ");
INSERT INTO wib_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Pè mɛ nɛ, túkù-á nɛ Wèlnwìlkì-ò Nsyɔ̃-á ǹnɛ. Túkù nɛ Liyel tɛ̃ntõ̀ syínyo-ò Yeli-á ǹnɛ. Túkù mó nɛ Liyel tɛ̃ntõ̀ syínyo-ò Nsyeremi-á, képah náh pɩ Liyel tɛ̃ntõ̀ syínyo-ò yɔ́-á ǹnɛ. ");
INSERT INTO wib_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Képah sɔkɔ, à tɔ̃ nɛ: «Ǹtɛ yépi-á dò, yépi tɛ̃̀ tyɩ́ nɛ̂ mɛ ńmɔlɛ?» ");
INSERT INTO wib_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simo Pyɛrɩ mɛ yo ǹ tyɩ́ nɛ: «Áwɔ ye Liyel nɛy yáhntɔkɔnɔlɛ. Liyel nɛ̂-á min nɛ́tɛ̃̂nɛ, ǹmɔ Pídĩ́ ye álɛ.» ");
INSERT INTO wib_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Képah sɔkɔ, Yesu yo ǹ tyɩ́ nɛ: «Áwɔ tyɩ́ nɔ, Nsyonasɩ pídĩ́ Simo. Á náh wɛ di, névi náh wɛ̃kɩ álɛ tyi nɔ́pilɛ dɛ́, ń Sú Liyel nɛ̂-á mɛ yĩ̂nyõ sɔkɔ, ǹmɔ ye wɛ̃kɩ álɛ sélɛ. ");
INSERT INTO wib_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ǹtɛ ńmɔ kɩ yo á tyɩ́ nɛ: ‹Pyɛrɩ ye álɛ, (nɛ̂ kɔ́r-á légbɩ̃́lɛ). Tɛ́ kénɛ légbɩ̃́ yõ sɔkɔ ye mé kɩ ń yõ sɛ̃́pú tĩ̀nkì sah. Tɛ́ kũ tǎhkɩ̀ ńtɛ̃ fyé náh tɛ̃ wɛ tir yɔ́ pɩ n pi pé sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Mé kɩ Liyel tɔ̃́rɩ́ tyah yah gbɩ̃́nɩ́ kéníkɔ́pyélɛ ǹ kɔ̃. Wâh tir nɛ̂ yahle sétáh mɛ̀ yõ sɔkɔ, Liyel nɛ̂-á yĩ̂nyõ sɔkɔ, ǹ tɔ kɩ sah ké yõ sɔkɔ. Tɛ́ wâh nɛ̂ wɛ̃̀kɩ̀ kɔ̃ sétáh mɛ̀ yõ sɔkɔ, Liyel nɛ̂-á yĩ̂nyõ sɔkɔ, ǹ tɔ kɩ sah ké yõ sɔkɔ.» Mé kɩ áwɔ kɔ̃ á kɩ fɛ̃ Liyel tɔ̃́rɩ́ nɔlɩ yṍnɔ́ wɛ̃̀kɩ̀lɛ n kɔ̃. Wâh tir nɛ̂ yahle sétáh mɛ̀ yõ sɔkɔ, Liyel nɛ̂-á yĩ̂nyõ sɔkɔ, ǹ tɔ kɩ sah ké yõ sɔkɔ. Tɛ́ wâh nɛ̂ wɛ̃̀kɩ̀ kɔ̃ sétáh mɛ̀ yõ sɔkɔ, Liyel nɛ̂-á yĩ̂nyõ sɔkɔ, ǹ tɔ kɩ sah ké yõ sɔkɔ.» ");
INSERT INTO wib_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Képah náh, Yesu ǹ tõ̀ sã́hpú gbah sni nɛ, pè káh kè yãh névi syah nɛ péwɔ-á Liyel nɛy yáhntɔkɔnɔlɛ dɛ́. ");
INSERT INTO wib_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","À tɔkɔ légbĩ́ tyɩ́, Yesu tyah ké yahlɛ n yo ǹ tõ̀ sã́hpú tyɩ́ nɛ, páh yɩ̃nɛ pé yuku Yerusalɛmɩ kwil sɔkɔ. Yèwàhnɩ̀, ànɛ̂ sárká syínwìlkìpu yõ̀tãm, ànɛ̂ Liyel tyi kõ̀nsàhnɔ́ kwɔ́pú-á kɩ yèvyãhrɩ náhnáh sah n pi péwɔ yõ. Pǎh kɩ pé ko mɔ, tɛ́ ké sèpĩ̀n tɔ̃́-ò sõlɛ, pé lékó-á kɩ yilki mɔ. ");
INSERT INTO wib_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Képah tɛ̃̀nɛ, Pyɛrɩ mɛ à ye kɛ̃kɩ tɛ́ tyah n wɛkɩ ǹ yõ nɛ ńkɛ̃́, póllɛ pé Tɛ̃̀ ǹgbɛ̃, képah náh à yĩni n tɛ̃ n pi. Liyel-á kɩ n tũ n mɔ ǹ yõ. ");
INSERT INTO wib_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ǹtɛ Yesu mɛ ǹ yah vi tɛ́ yo ǹ tyɩ́ nɛ: «To ń yah sétã̀n yõ̀tɛ̃̀ mɛ̀. Ńmɔ fɛ̃̀kɩ̀-ǹsah ye á n yah n kɔ̃. Yah, á sõnɔ náh mɛ núkúlɛ Liyel tyɩ́lɛ. Á sõnɔ mɛ núkúlɛ névi tyɩ́lɛ.» ");
INSERT INTO wib_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Képah náh, Yesu yo ǹ tõ̀ sã́hpú tyɩ́ nɛ: «Névi nɛ̂-à mɛ ké tyɩ́ nɛ pé ńmɔ sõ̀ tɛ̃, tɛ̃̀ yɩ̃nɛ à ǹ gblɔ̌y tyi wɛ n yɛ, à mó ǹ syɩ syɩ dahnɩ twah ńmɔ sõ̀ tɛ̃. ");
INSERT INTO wib_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Névi nɛ̂-à nɛ páh n to n pwah kũ yah, tɛ̃̀ náh tyɛ́-ńkɛ̃̂ min wɛ n pi. Tɛ́ nɛ̂-á tɛkɩ ǹ min sɔkɔ ńmɔ yĩnnɛ, tɛ̃̀ wɔ kɩ tyɛ́-ńkɛ̃̂ min wɛ. ");
INSERT INTO wib_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Névi-à nɛ kèkõyṍ yî pól wɛ n pi, tɛ́ nɛ n tɛkɩ n pi ǹ min sɔkɔ, yõ se mɛ ké tyɩ́? Képah náh pɩ, kwâh se kɩ fɛ̃ wɛ névi tyɩ́ à kɩ tɔkɔ kɔ̃, ǹ min sɔ̃́nɛ? ");
INSERT INTO wib_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Yé yah, Névi Pídĩ́ kɩ ǹ syɩ n pɔ n pi ànɛ̂ ǹ yĩ̂nyõ tõ̀npɩbɩlɛ ǹ Sú Liyel tɔ̃́rɩ́lɛ ǹ sɔkɔ. À kɩ pɔ nɛ́núkù núkú pól dyah à yɩ̃nɛ pé tyípɩ́nɩ̀nɛ. ");
INSERT INTO wib_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Kègbɩ yõ mé kélɛ n yo yé tyɩ́, névye nónó-á ásõ̂, pé túkù náh tɔ̃̌nɩ̀ mɛ n ku n pi, tɛ́ kɩ Névi Pídĩ́ wɛ à kɩ mɛ n pi ǹ yõ̀tɔ̃rɩ́ sɔkɔ.» ");
INSERT INTO wib_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Sèpĩ̀n kénúkò sɔ́kɔ́ntɛnɔ náh, Yesu mɛ Pyɛrɩ, ànɛ̂ Nsyakɩ, ànɛ̂ Nsyakɩ gbɛ̃̀ndĩ́ Nsyɔ̃ tɛ̃ pè yuku yɔ̃lɩ kèyy yɔ́ yõ, à kyɩ tɛ̃ pé tyɩ́lɛ. ");
INSERT INTO wib_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Dǒ, Yesu dùkù vi mɔ pé yĩ́ yah. Ǹ yèpɔ tyah n tɛ̃ gbĩ sɔ̃́, tɛ́ ǹ flɔ mɛ piki prɛ́yy. ");
INSERT INTO wib_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Moyisi ànɛ̂ Yeli núkú wil mɔ pé yah, tɛ́ mɛ n yãh ànɛ̂ Yesulɛ. ");
INSERT INTO wib_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Képah sɔkɔ, Pyɛrɩ mɛ yo Yesu tyɩ́ nɛ, Tɛ̃̀ ǹgbɛ̃, pé pól tɛ̃̀nɔ́-á mɛ plɛ ásõ̂ dɛ́! Wàh kɩ mɛ ké tyɩ́, páh kɩ yèpyenɔ tɔ̃́nɔ́ pɩ: Núkú-á kɩ pɩ ǹmɔ tyɩ́lɛ, núkú kɩ pɩ Moyisi tyɩ́lɛ, núkú mó pɩ Yeli tyɩ́lɛ. ");
INSERT INTO wib_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Wǎh mɛ képah yónɔ́ sɔkɔ, ńyĩ́rkì yɔ́ núkú wil ńvyɔ̃́ɔ̃ à fob mɔ pé yõ. Tɛ́ yĩ́npɔ̃́ yɔ́ mɛ wil ńyĩ́rkì mɛ̀ sɔkɔ nɛ: «Nɛ̂-á yɔ̀, ńmɔ nɩ̀dɛ̀ Pídĩ́ ye. Ǹmɔ ye ń nɩ̀vɩ̀nɩ̀ yõlɛ. Yé nɛ n nohnɩ ǹ tyɩ́.» ");
INSERT INTO wib_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Yesu tõ̀ sã́hpú nɔ́pi-á képah tɛ̃̀ noh ńyãh sɔkɔ, pè syɩkɩlɩ pé yah di sétáh tíkí tɛ̃̀ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Képah sɔkɔ, Yesu mɛ nɔ de pé tnɔ̂ à tũ pé tyɩ́, tɛ́ yo pé tyɩ́ nɛ: «Yé yuku, yé káh n yɛ tíkí yé tɛ̃.» ");
INSERT INTO wib_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Pǎh pé yey yɔ̃, pè Yesu ó wɛ ǹ gblɔ̌y núkúnínɛ. ");
INSERT INTO wib_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Pǎh pé syɩ yɔ̃lɩlɛ n tiki, Yesu mɛ pè sni nɛ: «Yáh nɛ̂ wɛ, yé káh kè yãh nɛy tyɩ́, fɔ́ɔ́ kè syi n pɔ n nɔ Névi Pídĩ́ lékó yílkínmɔnɔ tyɩ́.» ");
INSERT INTO wib_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Képah sɔkɔ, ǹ tõ̀ sã́hpú mɛ à piki yah nɛ, ǹtɛ sɔ̃́ se pɩ tɛ́ Liyel tyi kõ̀nsàhnɔ́ kwɔ́pú wɔ nɛ ńkɛ̃́ Yeli ǹgbò-á yɩ̃nɛ à pɔ Liyel nɛy yáhntɔkɔnɔ yah nɩ? ");
INSERT INTO wib_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","À mɛ yo pé tyɩ́ nɛ: «Gbɩ ye Yeli ye yɩ̃nɛ à pɔ tyi pól tɔ̃ sah. ");
INSERT INTO wib_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ǹtɛ mé kélɛ n yo yé tyɩ́, Yeli pɔ tɛ tɛ́ pè náh à yah pɩ̃. Pè pé dyɔ pɩ ǹ sɔkɔ. Sɛ̃́ ye Névi Pídĩ́ tɔ kɩ fṍhnɔ́ wɛ n pi pé gbõ̀.» ");
INSERT INTO wib_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Képah sɔkɔ, ǹ tõ̀ sã́hpú núkú pɩ̃ nɛ Wèlnwìlkì-ò Nsyɔ̃-á à n ye. ");
INSERT INTO wib_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yesu ànɛ̂ ǹ tõ̀ sã́hpú nɔ́pi-á pɔ yĩni tɛ̃ tɔ́wû sɔkɔ gbĩ́ nɛ̂nɛ, dĩ́ yɔ́ nɔ de Yesulɛ à gbètukunɔ di ǹ yah, tɛ́ yo ǹ tyɩ́ nɛ, ");
INSERT INTO wib_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","pé Tɛ̃̀ ǹgbɛ̃, à pé pídĩ́ yãm yah. Ǹdyɩ̀kɩ̀npɩ-á ǹnɛ, wǎh mɛ n kwlɔ kégbɩlɛ. Kèyǎhlɛ à n syɩkɩ n de nyàh sɔkɔ, képah náh pɩ ni sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Páh pɔ ǹnɛ ǹ tõ̀ sã́hpú tyɩ́, tɛ́ pè náh tɛ̃ wɛ à dɛ mɔ. ");
INSERT INTO wib_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Képah tɛ̃̀nɛ, Yesu wɛkɩ pé yõ nɛ: «Nɛ́pêl yísyɔ́lɛ n yah dɛ́, Liyel yõ sɛ̃́-ńkɛ̃̂pú nɔ́pi. Mé kɩ tɛ̃ yélɛ, pópó kɩ pɔ syɩ gbĩ́ nɛ̂ tɛ̃̀ tyɩ́? Mé kɩ yé sṍmnɔ́lɛ n pɩ, pópó kɩ pɔ syɩ gbĩ́ nɛ̂ tɛ̃̀ tyɩ́? Yé pɔ ǹnɛ ń kɔ̃ ásõ̂.» ");
INSERT INTO wib_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Pǎh pɔ ǹnɛ, Yesu dírí kõ sétõ yõ nɛ̂-á mɔ ǹ sɔkɔ ǹdyɩ̀kɩ̀nɩ̀nɛ, à mɛ wil dípír sɔkɔ. Nɛ́npɔ́ swɔ, dípír núkú dɛ. ");
INSERT INTO wib_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Képah tɛ̃̀nɛ, Yesu tõ̀ sã́hpú nɔ de Yesu tnɔ̂ pé yahlɛ tɛ́ à piki yah nɛ, sɔ̃́ se pɩ tɛ́ pépi wɔ sõ̀ tɛ̃ sétõ mɛ̀ yĩni wilki kwlɔ dípír mɛ̀ sɔkɔ nɩ? ");
INSERT INTO wib_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","À mɛ yo pé tyɩ́ nɛ: «Yé Liyel yõ sɛ̃́nɔ́ yilɔ kah mɔ képah ye. Kègbɩ yõ mé kélɛ n yo yé tyɩ́, yé Liyel yõ sɛ̃́nɔ́-à mɛ nɔ mútárdɩ̀ pi fyélɛ, yé náhkɩ fɛ̃ yo yɔ̃lɩ mɛ̀ tyɩ́ nɛ kè yal ásõ̂ kè kyɩ n tɛ̃ yàhàh, tɛ́ kè náhkɩ mó tɔ̃ kè pɩ. Yé náh náhkɩ tir yɔ́ ńtɛ̃ pɩ n kwlɔ n pi dò.  ");
INSERT INTO wib_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ǹtɛ sétõ mɛ̀ dùkùlɛ, nɛ́ nírí pɩ́nɔ́ ànɛ̂ níkì tɛ̃́nɔ́ ó sɔkɔ náh, à náh fɛ̃ n yĩni.» ");
INSERT INTO wib_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Sõ yɔ́lɛ, Yesu ànɛ̂ ǹ tõ̀ sã́hpú sõ̀ mɛ tùkènmɔnɔlɛ Kalile mara sɔkɔ. À mɛ yo pé tyɩ́ nɛ: «Pè kɩ Névi Pídĩ́ tɛ̃ dahbɩ névye gbõ̀, ");
INSERT INTO wib_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","pè kɩ à ko mɔ. Ǹtɛ ké sèpĩ̀n tɔ̃́-ò sõlɛ, ǹ lékó kɩ yilki mɔ.» Wɛlɔ nɔ́pi nóhnɔ́ ǹ tõ̀ sã́hpú yah kwɔ kègbɩlɛ. ");
INSERT INTO wib_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesupi-á kyɩ yĩni tɛ̃ Kapɛrnayumi kwil sɔkɔ, Liyel ní-ńsah gbô mɔ́rɩ́ syípú nɔ de Pyɛrɩlɛ tɛ́ à piki yah nɛ, pé kwɔ́-ò dĩ́ kó mɛ Liyel ní-ńsah gbô mɔ́rɩ́lɛ n mɔ nɩ? ");
INSERT INTO wib_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","À mɛ nɛ àwe-á, wǎh mɛ kélɛ n mɔ kɛ̀. Pyɛrɩ-á kyɩ yĩni tɛ̃ gbô, Yesu ǹgbò à piki yah nɛ: «Simo-Pyɛrɩ, áwɔ sõnɔ tɛ̃̀ nɛ̂nɛ à yuku mɔ́rɩ́ mɔ́nɔ́ tyɩ́ sɔkɔ? Kàh mɛ mɔ́rɩ́lɛ nɛ̂-á kɩ kèkõyṍ yõ̀tãmnɛ n kɔ̃, kwil wɛ̃́npì se kɩ n mɔ kélɛ, tĩ̂, nɛ́pân se?» ");
INSERT INTO wib_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pyɛrɩ mɛ nɛ nɛ́pân-á. Yesu mɛ nɛ: «Kàh pɩ sɛ̃́, kwil wɛ̃́npì wɔ vyãh náh mó mɛ ké mɔ́nɔ́ sɔkɔ kɛ̀. ");
INSERT INTO wib_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ǹtɛ mé náh mɛ ké tyɩ́ nɛ no nɔ́pi kélɛ nɛ n sõ kétúkùyɔ̂. Képah ye, kyɩ dlóy mɔ Kalile yɔ́-ǹgbɛ̃ sɔkɔ, yɛ̃́nkɔ̂ nɛ̂-á kɩ pɔ tɛ̃ gbennɛ, ǹ vyãh yɩkɩ n mɔ n yah, á kɩ pɔ́ wɛ ké sɔkɔ. Kè wilki n kyɩ mɔ́rɩ́ mɔ pé tyɩ́, ńmɔ ànɛ̂ áwɔ tyɩ́lɛ.» ");
INSERT INTO wib_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Légbĩ́nɛ, Yesu tõ̀ sã́hpú nɔ de ǹnɛ, tɛ́ à piki yah nɛ, nɛ̂ se nɛ́-ǹgbɛ̃nɛ kal Liyel tɔ̃́rɩ́ nɔlɩ yṍnɔ́ sɔkɔ nɩ? ");
INSERT INTO wib_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Képah tɛ̃̀nɛ, Yesu mɛ wɛ̃́npir tyɩ̃́ɩ̃ yɔ́ ye pɔ sah pé nɩyṍ, tɛ́ yo pé tyɩ́ nɛ: ");
INSERT INTO wib_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","«Kègbɩ yõ mé kélɛ n yo yé tyɩ́, nɛ́ yé náh yé nnɔ vi mɔ à pɩ wɛ̃́npì tyɩ́ kɔ̃lɛ, yé náh Liyel tɔ̃́rɩ́ nɔlɩ yõ n pi. ");
INSERT INTO wib_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Névi nɛ̂-à kɩ ǹ gblɔ̌y tiki mɔ pɩ tyɩ̃́ɩ̃ wɛ̃́npir mɛ̀ sɔ̃́, tɛ̃̀ wɔ ye kɩ pɩ nɛ́-ǹgbɛ̃nɛ kal Liyel tɔ̃́rɩ́ nɔlɩ yṍnɔ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Névi nɛ̂-à wɛ̃́npir mɛ̀ kénkɔ̃ tɛ̃́nɔ́ plɛ ńmɔ yĩnnɛ, ńmɔ ye tɛ̃̀ tɛ̃ plɛ.» ");
INSERT INTO wib_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","«Ǹtɛ wɛ̃́npì nónó-á sɛ̃ ńmɔ yõ yɔ̀, névi nɛ̂-à pé sɔkɔ yɔ́ yõ yɩkɩ mɔ tyípékè pɩ́nɔ́ sɔkɔ, pàh yínɔ́nan ǹgbɛ̃̀kɩ̀ yɔ́ toh tɛ̃̀ yègbɩ tɛ́ à tu dah mɔ pnɛ yɔ tì tɛ̃̀-ǹsah sɔkɔ kè kɔ̃ kè à yõ, képah kɩ fṍnfṍ kal tɛ̃̀nɛ. ");
INSERT INTO wib_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Pèkè mɛ kèkõyṍ névye yõ névye yõ yɩ́kɩ́nmɔnɔ yĩnnɛ tyípékè pɩ́nɔ́ sɔkɔ. Névye yõ tɛ̃̀ wɔ náh fɛ̃ n yɛ yɩ́kɩ́nɔ́lɛ ó, ǹtɛ névi nɛ̂ gbõ̀ yõ sɛ̃́nkɔ̃-à wɛ, pèkè kɩ tɛ̃̀ nɔ. ");
INSERT INTO wib_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Á gbõ̀, képah náh pɩ á gbáhkɩ̀-à kɩ nɛ̂ n dah n mɔ álɛ tyípékè sɔkɔ, kè kãm milki fɩ́ɩ́ álɛ. Wâh tɛkɩ á gbõ̀, képah náh pɩ á gbáhkɩ̀ sɔkɔ tɛ́ tyɛ́-ńkɛ̃̂ min wɛ, képah kɩ fṍnfṍ kal álɛ á mínndahnmɔnɔ yõ ní-ńkɛ̃̂ nyàhnpèkè sɔkɔ gbã̀n nínì ànɛ̂ gbyẽ̂h nínìnɛ á tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Á yĩ́-à kɩ nɛ̂ n dah n mɔ álɛ tyípékè sɔkɔ, kè gbahlɩ n wilki n milki fɩ́ɩ́ álɛ. Wâh tɛkɩ á yĩ́ sɔkɔ tɛ́ tyɛ́-ńkɛ̃̂ min wɛ, képah kɩ fṍnfṍ kal álɛ á mínndahnmɔnɔ yõ ní-ńkɛ̃̂ nyàhnpèkè sɔkɔ yɩ̃́ nínɔ́lɛ á tyɩ́.» ");
INSERT INTO wib_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","«Yé yé gblɔ̌y tɛ̃ wɛ̃́npì nɔ́pi sɔkɔ yɔ́ yílɔ́nɔ́lɛ. Ǹgbǒ yĩ̂nyõ tõ̀npɩbɩ nónó-á n yah pé yõ, pè mɛ gbĩ́mɛgbĩ́ ń Sú Liyel yah sɔkɔ yĩ̂nyõ dɛ́.  ");
INSERT INTO wib_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Yé náh wɛ di, névye nónó-á mɛ mɔ́npunɔlɛ, pépi pwah n mɔ yĩn ye Névi Pídĩ́ pɔ. ");
INSERT INTO wib_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Yépi tɛ̃̀ tyɩ́ à; sɔ̃́ kénkɔ̃-á képyɛ́nɩ̀ lèkwɛ̌-à mɛ dĩ́ yɔ́ tyɩ́ à mɛ n fɛ̃ yɔ̃lɩ yõ, tɛ́ núkú mɔ pu sé sɔkɔ, à náh tikiyẽ́h pɔ́ gbãm pɔ́ kwǎryãh nɔ́pi tɛ́lɔ́ sah n pi nɛ́npɔ́, tɛ́ kyɩ mɔ́npunɔ mɛ̀ yah n kɔ̃ n pi di? ");
INSERT INTO wib_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Tɛ́ gbɩ yõ mé kélɛ n yo yé tyɩ́, wàh à wɛ tɛ̃, ǹ nɩ n vɩ ǹmɔlɛ à kal tikiyẽ́h pɔ́ gbãm pɔ́ kwǎryãh nɔ́pi tɛ́lɔ́lɛ, nónó náh mɔ pu. ");
INSERT INTO wib_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Sɛ̃́ ye yé Sú Liyel nɛ̂-á mɛ yĩ̂nyõ, ǹ tɔ náh mɛ ké tyɩ́ nɛ wɛ̃́npì nɔ́pi sɔkɔ yɔ́ ńtɛ̃ mɔ n pu.» ");
INSERT INTO wib_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Yesu tɔ̃ nɛ: «Á yṹnpi yɔ́-à tyípékè pɩ á tyɩ́, kyɩ n wil ǹ tyɩ́, ǹ ǹ yah yo yé nímí wrɔ́ ó sɔkɔ. Wàh sah á tyɩ́ yõ, yé yṹnpíkì kɩ yuku yahlɛ. ");
INSERT INTO wib_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Wàh yahle, kyɩ nɛ́núkù képah náh pɩ nímí yah n dohnɩ á gblɔ̌y yõ ńtɔ̃, yè kyɩ ké yah wah. Sɛ̃́ ye Liyel wɛy yo kélɛ nɛ, ké yah-á yɩ̃nɛ kè wah tàrfyɔ̀ nɛ́pĩ̂ nímí, képah náh pɩ tɔ̃́mɩ́ yĩ́ yah. ");
INSERT INTO wib_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Tɛ́ wàh yahle sàhnɔ́lɛ pépi tɔ tyɩ́ yõ, kyɩ ké yah yo ńmɔ yõ sɛ̃́pú tĩ̀nkì tyɩ́. Wàh se tɔ̃ yahle sàhnɔ́lɛ pépi tɔ tyɩ́ yõ, ǹnɛ nɛ n mɔ n kõ Liyel wɛ̃̀kɩ̀ kɔ́-ńkɛ̃̂pú sɔkɔ, képah náh pɩ mɔ́rɩ́ syípú sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Kègbɩ yõ mé kélɛ n yo yé tyɩ́, yâh tir nɛ̂ yahle sétáh mɛ̀ yõ sɔkɔ, Liyel nɛ̂-á yĩ̂nyõ sɔkɔ, ǹ tɔ kɩ sah ké yõ sɔkɔ. Tɛ́ yâh nɛ̂ wɛ̃̀kɩ̀ kɔ̃ sétáh mɛ̀ yõ sɔkɔ, Liyel nɛ̂-á yĩ̂nyõ sɔkɔ, ǹ tɔ kɩ sah ké yõ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Mé kélɛ n yo yé tyɩ́ tɔlɛ, yé sɔkɔ nɛ́pĩ̂ nímí tɛ̃̀-à fyɔ̀ pé yégbékè pɩ núkúlɛ sétáh mɛ̀ yõ, tɛ́ kwáhdúkú nɛ̂ ni ń Sú Liyel tyɩ́, à kɩ kélɛ pè kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Yé náh wɛ di, nɛ́pĩ̂ nímí képah náh pɩ tɔ̃́mɩ́-à wɛ̃ tuke mɔ ńyãh sɔkɔ ńmɔ yĩn yõ, mè n nɛ mɛ pé nɩyṍ.» ");
INSERT INTO wib_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Képah sɔkɔ, Pyɛrɩ mɛ nɔ de Yesu tnɔ̂ tɛ́ yo ǹ tyɩ́ nɛ, pé Tɛ̃̀ ǹgbɛ̃, pé yṹnpi yɔ́-à n pɩ n de pé tyɩ́, gbáhyɩ̃́ sɔ̃́ se pé yɩ̃nɛ pé yɔ̃ mɔ à kɔ̃ nɩ? Fɔ́ɔ́ gbáhyɩ̃́ kwǎrninɔ se nɩ? ");
INSERT INTO wib_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesu mɛ yo ǹ tyɩ́ nɛ: «Ɔ̃́ɔ̃, mé náh n yo n pi á tyɩ́ nɛ gbáhyɩ̃́ kwǎrninɔ-á dɛ́, ǹtɛ fɔ́ɔ́ gbáhyɩ̃́ kwǎrninɔ sàh-ǹtã̀nnɔ́ tikitɔ̃nɩ́ pɔ́ gbãm ye. ");
INSERT INTO wib_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Yé yah, Liyel tɔ̃́rɩ́-á kɩ fɛ̃ tɔkɔ sãh sèmìrkì nɛ̂nɛ, kè wɛ yɔ̀: Yõ̀tɛ̃̀ dĩ́ yɔ́ lésõ mɛ ké tyɩ́ nɛ pé pé pɔ́ tyɩ́ yah wah ànɛ̂ pé tõ̀npɩbɩlɛ. ");
INSERT INTO wib_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Pǎh tyah pɔ́ yã́hnɔ́lɛ, pè ǹ tõ̀npɩ yɔ́ tɛ̃ pɔ ǹ tyɩ́, ǹ kɔ̃lɩ ǹgbɛ̃-á sõ̀ mɛ nɛ̂ yõ, fɔ́ɔ́ talã pɔ́ plɔ́ kèyõ kwlɔ́lɛ (10 000). ");
INSERT INTO wib_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Tɛ́ kwâh náh sõ̀ mɛ dĩ́ mɛ̀ tyɩ́ ké dyah dyah tɛ̃̀nɛ. Kǎh pɩ sɛ̃́, yõ̀tɛ̃̀ dĩ́ nɛ, pè à tɛ̃ yãm, ànɛ̂ ǹ kyɩlɛ, ànɛ̂ ǹ wɛ̃́npìlɛ, à tahlɩ ǹ gbã̀n yî pól tyɩ́, pè kɔ̃lɩ mɛ̀ dyah. ");
INSERT INTO wib_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Képah tɛ̃̀nɛ, tõ̀npɩ mɛ̀ mɛ ǹ gbètukunɔ di tɛ́ ǹ yah kwĩnki sétáh yõ̀tɛ̃̀ dĩ́ yah, tɛ́ yo ǹ tyɩ́ nɛ, à ǹ gblɔ̌y yɛ à mó pé syɩkɩ n yah kwéy, páh kɩ pɔ ké pól dyah ǹ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Wǎh képah yo sɛ̃́, ǹ yãm yõ̀tɛ̃̀ dĩ́ kah tɛ̃. À mɛ à fĩn mɔ tɛ́ kɔ̃lɩ mɛ̀ yɔ̃ mɔ à kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Kénɛ dĩ́-á fyɔ̀ wil, à ǹ ní-ò tõ̀npɩ yɔ́ yohnɩ ǹmɔ kɔ̃lɩ kwéy-á sõ̀ mɛ nɛ̂ yõ deniye pɔ́ plɔ́ lèkwɛ̌lɛ. À mɛ à fyãh tɛ̃ ǹ yègbɩ tyɩ́ à ǹnɛ n fɩ̃ kírr, tɛ́ à syah nɛ ńkɛ̃́, pé kɔ̃lɩ nɛ̂-á mɛ ǹ yõ, à pé dyah kélɛ. ");
INSERT INTO wib_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ǹ ní-ò mɛ̀ mɛ ǹ gbètukunɔ di ǹ yah tɛ́ yo ǹ tyɩ́ nɛ, à ǹ gblɔ̌y yɛ à mó pé syɩkɩ n yah kwéy, páh kɩ pɔ kè dyah ǹ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ǹtɛ à yahle, tɛ́ se tɔ̃ à tɛ̃ kyɩ dah mɔ wɔ̀kɔ̀npèkè sɔkɔ, fɔ́ɔ́ kɩ pɔ nɔ gbĩ́ nɛ̂-á à kɩ kɔ̃lɩ mɛ̀ dyah. ");
INSERT INTO wib_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Pé no tõ̀npɩbɩ-á képah tɛ̃̀ wɛ sɛ̃́, kè pé yah kwɔ kègbɩlɛ. Pè mɛ kyɩ sé pól yo pé yõ̀tɛ̃̀ dĩ́ syah. ");
INSERT INTO wib_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Képah sɔkɔ, yõ̀tɛ̃̀ dĩ́ mɛ pè kɔ̃ pè à ye pɔ, tɛ́ yo ǹ tyɩ́ nɛ: ‹Tõ̀npɩ nɛ́po. Wáh lésõ ń ni, képah ye mé á kɔ̃lɩ yɔ̃ mɔ ǹ kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ǹtɛ áwɔ tɔ náh sõ̀ yɩ̃nɛ ǹ á ní-ò yãm yah, ńmɔ-á á yãm yah sɔ̃́ di?› ");
INSERT INTO wib_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Tɛ́ fɔ̀kɔ̀vyã̀hnɩ̀ képékè tɛ̃̀ tyɩ́, yõ̀tɛ̃̀ dĩ́ à dahbɩ wɔ̀kɔ̀npèkè névye fṍhpúpêl gbõ̀, fɔ́ɔ́ kɩ syi pɔ nɔ gbĩ́ nɛ̂-á à kɩ yõ̀tɛ̃̀ dĩ́ pɔ́ póllɛ à dyah. ");
INSERT INTO wib_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Sɛ̃́ ye ń Sú Liyel kɩ n pɩ n pi yé tɔlɛ, yâh n yɔ̃̀nmɔ-ńkɛ̃̂nɛ wɛ̃nɛ n kɔ̃ yé nnɔ póllɛ.» ");
INSERT INTO wib_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu-á tyɛ ǹ wɛynɛ gbĩ́ nɛ̂nɛ, à yal Kalile mara sɔkɔ à yuku Nsyude mara tyah yɔ́ sɔkɔ, nɛ̂-á mɛ Nsyurdɛ̃ yɔ́nkahnɩnɛ. ");
INSERT INTO wib_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Tɔ́wû ǹgbɛ̃ yɔ́ mɛ ǹ sõ̀ tɛ̃ yuku, tɛ́ à mɛ pé yámpú dɛ mɔ nɛ́npɔ́. ");
INSERT INTO wib_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Képah sɔkɔ, Farisi wɛ̃̀kɩ̀ kɔ́pú yísyɔ́ nɔ de ǹ tnɔ̂ nɛ pé à mɔ yah, tɛ́ à piki yah nɛ, ké wɛ̃̀kɩ̀ se mɛ dĩ́ tyɩ́ à kɩ ǹ kyɩ fĩn mɔ, kàh sɔ̃́ mɛ tyídúkú nɛ̂ yõ nɩ? ");
INSERT INTO wib_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesu mɛ yo pé tyɩ́ nɛ: «Yé náh kè kar yah Liyel wɛy sɛ́bɛ́y sɔkɔ nɛ, kèkõyṍ mɔ gbĩ́nɛ, Kèkõyṍ mɔ́-ò-á pè mɔ dĩ́ ànɛ̂ sêlɛ di? ");
INSERT INTO wib_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Wǎh nɛ, képah-á dĩ́-á kɩ yal ǹ sú ànɛ̂ ǹ yṹ tnɔ̂, tɛ́ kɩ kwrɔ mɔ ǹ kyɩlɛ, pé nímí kɩ pɩ wil gbɛ̃́nsê núkúlɛ. ");
INSERT INTO wib_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Kǎh pɩ sɛ̃́, nímí náh tɔ̃ pélɛ dɛ́, núkú-á pélɛ. Liyel-á nónó kwrɔ mɔ, nɛy káh pè gbɛkɩ.» ");
INSERT INTO wib_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Képah tɛ̃̀nɛ, Farisi wɛ̃̀kɩ̀ kɔ́pú à syah nɛ, ǹtɛ sɔ̃́ se pɩ tɛ́ Moyisi kè kõ sah nɛ, névi nɛ̂-à ǹ kyɩlɛ n fĩn mɔ, tɛ̃̀ ǹ fĩn mɔ mɔ tàrfyɔ̀ sɛ́bɛ́y pɩ à kɔ̃ à mó pyě à fĩn mɔ nɩ? ");
INSERT INTO wib_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","À mɛ yo pé tyɩ́ nɛ: «Yépi nòhnɩ̀-ǹkɛ̃̂ yĩn ye Moyisi kɔ̃ à képah wɛ̃̀kɩ̀lɛ yé kɔ̃ kɛ̀. Ńkɛ̃́ sɛ̃́ náh se lésõ kélɛ ké tyàh-ǹsah sɔkɔ tɛ́. ");
INSERT INTO wib_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Tɛ́ ńmɔ kélɛ n yo yé tyɩ́ nɛ, névi nɛ̂-à ǹ kyɩ fĩn mɔ nɛ́ fɔ̀fɩ́kɩ̀ tɛ̃̀ tyɩ́ yõ náh, tɛ́ sékáhkɩ́ tɔkɔ, fɔ̀fɩ́kɩ̀-á tɛ̃̀ n pɩ.» ");
INSERT INTO wib_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Képah sɔkɔ, Yesu tõ̀ sã́hpú yo ǹ tyɩ́ nɛ, dĩ́ yĩ́n-ńsah-à mó mɛ pɔ sah képah yõ à yuku ǹ kyɩ tyɩ́ tĩ̀nnɛ, sê tɔ́kɔ́-ńkɛ̃̂-á fṍnfṍ dò. ");
INSERT INTO wib_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesu mɛ yo pé tyɩ́ nɛ: «Wɛy nɛ̂-á mé kɩ n yo n pi yé tyɩ́ yɔ̀, no pól náh fɛ̃ ké syɩ́kɩ́-ńsah wɛ n pi. Ǹtɛ Liyel-á ké fɛ̃̀npɩ̃nɔ lékã́mnɛ nónó kɔ̃, pépi wɔ kɩ fɛ̃ ké syɩ́kɩ́-ńsah wɛ. ");
INSERT INTO wib_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Yé náh wɛ di, tyi yísyɔ́ mɛ nónó-á díbí kɔ̃ pè náh syɔ́lɛ n tɔkɔ: Túkù mɛ pé dúbí-ńsah dùkù sɔkɔ, pè náh mɛ díbí sɔkɔ. Túkù mɛ névye ye mɩ pélɛ pè kɔ̃ pè náh mɛ díbí sɔkɔ. Túkù mó sétɔ́kɔ́kɩ̀ yahle Liyel yõ̀tɔ̃rɩ́ yah yúkúnɔ́ yĩnnɛ. Nɛ̂-à kɩ fɛ̃ wɛy mɛ̀ syɩ́kɩ́-ńsah wɛ n pi, tɛ̃̀ kɩ ké syɩ́kɩ́-ńsah wɛ.» ");
INSERT INTO wib_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Képah tɛ̃̀nɛ, névye pɔ wɛ̃́npì yrɔ̃́lɛ Yesu tyɩ́ nɛ à ǹ gbã̀n sah pé yõ à Liyel ni pé tyɩ́. Ǹtɛ ǹ tõ̀ sã́hpú mɛ tyah dírílɛ n kõ pé yõ. ");
INSERT INTO wib_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Képah sɔkɔ, Yesu mɛ yo pé tyɩ́ nɛ: «Yé yɛ wɛ̃́npì kɔ̃ pè nɛ n pɔ n pɔ ńmɔ tyɩ́. Yé káh pé yahlɛ n kõ. Yé náh wɛ di, névye nónó dùkù-á mɛ wɛ̃́npì nɔ́pi tyɩ́ kɔ̃lɛ, pè kɩ Liyel tɔ̃́rɩ́ nɔlɩ yõ n pi.» ");
INSERT INTO wib_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Képah tɛ̃̀nɛ, wǎh ǹ gbã̀n sah tɛ pé yõ, à yal nɛ́npɔ́. ");
INSERT INTO wib_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Képah tɛ̃̀nɛ, kètɛ̃̀npìkì yɔ́ nɔ de Yesulɛ tɛ́ à piki yah nɛ, kwɔ́-ò dĩ́, tir nɛ̂ sé pé yɩ̃nɛ pé pɩ tyípépɛ̌ynɛ pé mó tyɛ́-ńkɛ̃̂ min wɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesu mɛ yo ǹ tyɩ́ nɛ: «Sɔ̃́ pɩ tɛ́ á ńnɛ n piki n yah pèpɛy tyɩ́ yõ? Pèpɛy núkú ó mɛ. Wáh kɩ mɛ ké tyɩ́ nɛ á min wɛ, Liyel tyi kõ̀nsàhnɔ́ wã̀llɛ n kɔ.» ");
INSERT INTO wib_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","À mɛ nɛ Liyel tyi kõ̀nsàhnɔ́ nónó tãn se nɩ? Yesu mɛ yo ǹ tyɩ́ nɛ: «Káh nɛ́kókè mɔ, káh fɔ̀fɩ́kɩ̀ pɩ, káh yɩ̃be yɩ̃, káh mɩ̀nɩ̀ sah nɛy yõ. ");
INSERT INTO wib_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Yõ̀yénnɛ n sah á sú ànɛ̂ á yṹ yõ. Yɛ á ní-ò tyɩ́ nɔ á tyɩ́ á gblɔ̌y tyɩ́ kɔ̃lɛ.» ");
INSERT INTO wib_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Képah tɛ̃̀nɛ, kénɛ kètɛ̃̀npìkì mɛ yo ǹ tyɩ́ nɛ, páh mɛ sépi tɛ̃̀ póllɛ n pɩ dò, kèyǎh se tɔ̃ mɛ wũ pé tyɩ́ pɩ pɩ tɛ̃̀nɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu mɛ yo ǹ tyɩ́ nɛ: «Wáh kɩ mɛ ké tyɩ́ nɛ á tyi pól tũ, gbã̀n yî nónó-á mɛ á tyɩ́, kyɩ sè yãm ǹ tɛ́ sé pɔ́ dibi yãm tãn kɔ̃. Képah sɔkɔ, á kɩ tahrɩ wɛ Liyel fṍ sɔkɔ. Képah-à pɩ, ǹ pɔ ńmɔ sõ̀ tɛ̃.» ");
INSERT INTO wib_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Wǎh képah tɛ̃̀ noh sɛ̃́, à sɔkɔ yahlɛ yɩ́kɩ́nsàhnɔ́lɛ. Kwâh nɛ́tɛ̃̂ ǹgbɛ̃ ye sõ̀ ǹnɛ képah ye. ");
INSERT INTO wib_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Képah sɔkɔ, Yesu mɛ yo ǹ tõ̀ sã́hpú tyɩ́ nɛ: «Kègbɩ yõ mé kélɛ n yo yé tyɩ́, tàh Liyel tɔ̃́rɩ́ nɔlɩ wɛ́nyõnɔlɛ, kè kɩ tah dɛ́. ");
INSERT INTO wib_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Mé kélɛ n tɔ̃ n yo yé tyɩ́, yã̀hmɩ́kɩ̀ dénwìlnɔ́lɛ sèndi pwã̀h sɔkɔ, képah ńtɛ̃ kɩ dɔ̀dɔ̀ kal tàh Liyel tɔ̃́rɩ́ nɔlɩ wɛ́nyõnɔlɛ.» ");
INSERT INTO wib_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Yesu tõ̀ sã́hpú-á képah noh sɛ̃́, pé gbã̀n kah du. Pè mɛ nɛ, ǹtɛ nɛ̂ wɔ se kɩ mó fɛ̃ pwah nɩ? ");
INSERT INTO wib_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesu mɛ yɔ̃ pè yah, tɛ́ yo pé tyɩ́ nɛ: «Névye tɛ̃̀ wɔlɛ, pè náh fɛ̃ kè pɩ n pi. Ǹtɛ Liyel kɩ fɛ̃ tyi pól pɩ.» ");
INSERT INTO wib_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Képah sɔkɔ, Pyɛrɩ mɛ yo ǹ tyɩ́ nɛ, à yah, pépi-á pé tyi pól sah tɛ́ ǹmɔ sõ̀ tɛ̃. Pépi tyɩ́ se kɩ n pɩ n pi sɔ̃́ nɩ? ");
INSERT INTO wib_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","À mɛ yo pé tyɩ́ nɛ: «Kègbɩ yõ mé kélɛ n yo yé tyɩ́, Névi Pídĩ́-à pɔ kɔ̃ tɛ̃ ǹ tɔ̃́rɩ́ kǒ yõ kèkõyṍ késã́n sɔkɔ gbĩ́ nɛ̂nɛ, yépi nónó-á ńmɔ sõ̀ tɛ̃, yé tɔ kɩ kɔ̃ tɛ̃ tɔ̃́rɩ́ klǒ gbɔ̃ninɔ́ yõ kɩ Yisrayel no yìkìnìnɔ́ gbɔ̃ninɔ́ yah tɛ̃ n pi. ");
INSERT INTO wib_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ńmɔ yĩn yõ, névi nɛ̂ tɛ̃̀-à fyɔ̀ mɛ yal ǹ gbô sɔkɔ ò, ǹ yṹnpyé tnɔ̂ ò, ǹ dósyɔ́ tnɔ̂ ò, ǹ sú tnɔ̂ ò, ǹ yṹ tnɔ̂ ò, ǹ wɛ̃́npì tnɔ̂ ò, ǹ swɛ̃y tnɔ̂ ò, tɛ̃̀ kɩ sɛ̃́nknɔnɔ lèkwɛ̌ wɛ, tɛ́ kɩ se tɔ̃ tyɛ́-ńkɛ̃̂ min wɛ. ");
INSERT INTO wib_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ǹtɛ nɛ́gbro náhnáh kɩ n pɩ n pi nɛ́tɛ́lɔ́lɛ, tɛ́ nɛ́tɛ́lɔ́lɛ náhnáh kɩ n pɩ n pi nɛ́gbrolɛ.» ");
INSERT INTO wib_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","«Yé yah, Liyel tɔ̃́rɩ́-á kɩ fɛ̃ tɔkɔ sãh sèmìrkì nɛ̂nɛ, kè wɛ yɔ̀: Sètɛ̃̀ dĩ́ yɔ́ lésõ wil séngbɔ̃́ púpúlɛ nɛ pé tõ̀npɩbɩ yah n tɔkɔ n tɛkɩ mɔ pé yɛ̀rɛsɛ̃̂ swãh sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Wǎh nónó wɛ, à yo sah núkú yõ pélɛ nɛ, nɛ́núkú gbĩ̀yĩ̀kì núkú tõ̀ pɩ́nɔ́ sǎrlɛ, deniye pɔ́ pɔ́ núkú-á. Képah sɔkɔ, tɛ́ pè tɛkɩ mɔ ǹ swãh sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Pɔ̃̂y tɔ̃ gbĩ́nɛ, à tɔ̃ wil tɛ́ kyɩ nósyɔ́ wɛ tɛ̃̀nɔ́lɛ tɔ́wû tùkè-ǹsah sɔkɔ tõ̀ kɛ̃́nɛ pé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","À mɛ yo pé tyɩ́ nɛ, pépi tɔ sɔkɔ péwɔ swãh sɔkɔ, páh kɩ pè sar ké yah yõ. ");
INSERT INTO wib_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Pè mɛ sɔkɔ. Gbĩ-á mɛ yõ̀tah sírr sɔkɔ, à tɔ̃ wil à sɛ̃́ntɛ̃̀ pɩ. Gbèkãm gbĩ́-á nɔ, à tɔ̃ wil à képah núkú ó pɩ. ");
INSERT INTO wib_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ńvɩ̃́ lésyilɛ, à tɔ̃ wil tɛ́ kyɩ nósyɔ́ wɛ ńtɔ̃ kénɛ tɔ́wû tùkè-ǹsah sɔkɔ. À mɛ pè piki yah nɛ, sɔ̃́ se pɩ tɛ́ pélɛ ásõ̂ gbĩ̀yĩ̀kìlɛ tɔ́tɔ́ tõ̀ pɩ́-ńkɛ̃̂nɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Pè mɛ yo ǹ tyɩ́ nɛ, nɛy náh pé tɔkɔ képah-á. À mɛ nɛ pépi tɔ sɔkɔ péwɔ swãh sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Tõ̀-á tiki ńvɩ̃́nɛ, sètɛ̃̀ dĩ́ yo ǹ pɔ́ yah wàh-ò dĩ́ tyɩ́ nɛ, à tõ̀npɩbɩ nɔ́pi ye n pɔ pè dyah pé pɔ́lɛ. Ńkɛ̃́ nónó-á kyɩ swãh sɔkɔ nɛ́tɛ́lɔ́lɛ, à kè tyah pépi tyɩ́ à pɔ n dal n mɔ nɛ́gbro tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Nónó-á tɛ́lɔ́lɛ, pǎh pɔ, à pè kɔ̃ deniye pɔ́ pɔ́ núkú núkúlɛ. ");
INSERT INTO wib_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Kǎh syɩ nɛ́gbro tyɩ́, pépi tɛ̃̀ sõ̀ mɛ n sõ nɛ wãn-á kɩ wɛ pépi tyɩ́ yõ. Ǹtɛ deniye pɔ́ pɔ́ núkú núkú ye pépi tɔ wɛ. ");
INSERT INTO wib_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Pǎh pɔ́ nɔ́pilɛ n syi gbĩ́ nɛ̂nɛ, pè tyah sètɛ̃̀ dĩ́ sèyòkèlɛ n yo ");
INSERT INTO wib_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","nɛ ńkɛ̃́, nónó-á à tɔkɔ pɔ tɛ́lɔ́lɛ, lɛ́rɩ́ núkú ó sɔkɔ-á pè wɛ pɩ tõ̀lɛ. Ǹtɛ kè se pɩ sɔ̃́ tɛ́ à pɔ pélɛ n sar núkúlɛ pépilɛ, pépi nónó-á kwlɔ́nɔ́ fɛ̃ syi à tõ̀ pɩ kwlɔ gbĩ̀yĩ̀kìlɛ tɔ́tɔ́ gbĩ syɔ̌kɩ̀ yah sɔkɔ nɩ? ");
INSERT INTO wib_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Sètɛ̃̀ dĩ́ mɛ yo pé sɔkɔ yɔ́ tyɩ́ nɛ: ‹Ń kódĩ́, mé náh syɩkɩ á yõ sɔkɔ dɛ́. Ńmɔ ànɛ̂ áwɔ náh sõ̀ wɛkɩ sah núkú yõ nɛ, á gbĩ̀yĩ̀kì núkú tõ̀ pɩ́nɔ́ sǎr-á kɩ pɩ deniye pɔ́ pɔ́ núkúlɛ di? ");
INSERT INTO wib_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Nɛ n yuku á pɔ́lɛ. Mé kɩ nɛ́tɛ́y mɛ̀ kɔ̃ dan núkúlɛ áwɔlɛ ń dyɔ ó. ");
INSERT INTO wib_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ké wɛ̃̀kɩ̀ náh mɛ ńmɔ tyɩ́, kɩ fɛ̃ ń dyɔ dyɔ tyi pɩ ń pɔ́lɛ di? Tĩ̂, ń nɩ nɔ́nɔ́ se n yɔ álɛ?» ");
INSERT INTO wib_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Képah yã́hntɛnɔ náh, Yesu tɔ̃ yo pé tyɩ́ nɛ: «Sɛ̃́ ó ye, nɛ́tɛ́lɔ́ kɩ pɩ nɛ́gbrolɛ, tɛ́ nɛ́gbro kɩ pɩ nɛ́tɛ́lɔ́lɛ.» ");
INSERT INTO wib_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesupi-á n sɔkɔ Yerusalɛmɩ kwil, pǎh mɛ wɛ̃̀kɩ̀ yõ sɔkɔ, à ǹ tõ̀ sã́hpú ye pé yahlɛ, tɛ́ yo pé tyɩ́ nɛ: ");
INSERT INTO wib_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Á wɛ wɛ̃̀kɩ̀ yõ à n dɔkɔ n yuku Yerusalɛmɩ sɔkɔ yɔ̀. Névi Pídĩ́ kɩ tɛ̃ n dahbɩ n pi sárká syínwìlkìpu yõ̀tãm ànɛ̂ Liyel tyi kõ̀nsàhnɔ́ kwɔ́pú gbõ̀ nɛ́npɔ́. Pè kɩ kè yah tɔkɔ nɛ wǎh yɩ̃nɛ kònmɔnɔlɛ, ");
INSERT INTO wib_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","tɛ́ kɩ à dahbɩ névye gbõ̀ nónó náh pɩ Nsyifunɔlɛ, pè kɩ kṍlɛ à ko, tɛ́ kɩ à ko yèfõhlɛ, tɛ́ kɩ à syɩ dahnɩ yõ. Ǹtɛ ké sèpĩ̀n tɔ̃́-ò sõlɛ, ǹ lékó kɩ yilki mɔ.» ");
INSERT INTO wib_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Képah sɔkɔ, Nsebede kyɩ mɛ ǹ dĩ́npì tɛ̃ nɔ de Yesulɛ, tɛ́ kɔ kwĩnki ǹ yah nɛ pé yáhnkɔ̃nɔ yɔ́ pɩ ǹ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesu mɛ à piki yah nɛ, à se mɛ kwâh nɛ̂ tyɩ́ nɩ? Pi mɛ yo ǹ tyɩ́ nɛ, pé dĩ́npì nónó-á yɔ̀, à ǹ vyãhlɛ péwɔ kɔ̃ nɛ wàh pɔ dɔkɔ ǹ yõ̀tɔ̃rɩ́ yõ, pé sɔkɔ núkú kɔ̃ tɛ̃ ǹ gbõ̀yõ̀ sõ̀lɛ, ní-ò mó kɔ̃ tɛ̃ ǹ gbɛ̃̀yɩ̃̀nɛ̀ sõ̀lɛ. ");
INSERT INTO wib_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesu mɛ yo ǹ tyɩ́ nɛ: «Ǹpɩ̃̀-ǹkɛ̃̂ sɔkɔ ye yé n ni kélɛ. Máh kɩ n de n pi yèvyãhrɩ nɛ̂ sɔkɔ, yé tɔ se kɩ fɛ̃ de ké sɔkɔ?» Pè mɛ à syah nɛ páh kɩ fɛ̃ de ké sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesu mɛ yo pé tyɩ́ nɛ: «Máh kɩ n de n pi yèvyãhrɩ nɛ̂ sɔkɔ, yé tɔ kɩ de képah wɔ sɔkɔ ó, ǹtɛ ń gbõ̀yõ̀ sõ̀ ànɛ̂ ń gbɛ̃̀yɩ̃̀nɛ̀ sõ̀ tɛ̃̀nɔ́ tɛ̃̀ wɔlɛ, ńmɔ tyɩ́ náh képah wɛ̃̀kɩ̀ kɔ̃́nɔ́lɛ. Ń Sú Liyel-á kè yah sah nónó yĩnnɛ, pépi ye à kɩ kɔ̃ kélɛ.» ");
INSERT INTO wib_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Yesu tõ̀ sã́hpú nɛ́pĩ̂ gbãm nɔ́pi tɛ́lɔ́-á képah noh sɛ̃́, pé fɔkɔ vyãh nímí nɔ́pilɛ. ");
INSERT INTO wib_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Képah sɔkɔ, Yesu mɛ pé pól ye yah tɛ́ yo pé tyɩ́ nɛ: «Tir nɛ̂-á mɛ n pɩ kwlo kwlo sɔkɔ, yé kè pɩ̃ ó. Yõ̀tãm náh ńkɛ̃́nɛ pé kwlo névyelɛ nɛ n fnɛ, tɛ́ nɛ́-ǹgbnɔ tɔ n mó nɛ n fyãh pé yõ pé tɛ̃́nwɛnɔ yĩnnɛ di? ");
INSERT INTO wib_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ǹtɛ kè náh yɩ̃nɛ kè nɛ n pɩ sɛ̃́ yépi wrɔ́. Gbɛ̃̀ntɛ̃̀náhlɛ, yépi sɔkɔ nɛ̂-à mɛ ké tyɩ́ nɛ pé yĩ́n-ńsah ǹgbɛ̃ wɛ, tɛ̃̀ yɩ̃nɛ à pɩ tõ̀npɩlɛ tɛ́lɔ́ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Tɛ́ nɛ̂-à mɛ ké tyɩ́ nɛ pé pɩ yah névilɛ yé sɔkɔ, tɛ̃̀ yɩ̃nɛ à pɩ yé yɔ̃̀lɛ. ");
INSERT INTO wib_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Sɛ̃́ ó ye, Névi Pídĩ́ náh pɔ nɛ névye tõ̀lɛ n pɩ péwɔ tyɩ́ dɛ́. Ǹmɔ ye pɔ tõ̀ pɩ yĩnnɛ névye tyɩ́, tɛ́ kɩ ǹ min kɔ̃ névye náhnáh yõ dwe yĩnnɛ. ");
INSERT INTO wib_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesu ànɛ̂ ǹ tõ̀ sã́hpú-á n wil Nsyeriko kwil sɔkɔ gbĩ́ nɛ̂nɛ, tɔ́wû ǹgbɛ̃ yɔ́ mɛ ǹ sõ̀ tɛ̃. ");
INSERT INTO wib_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Tɛ́ yɩ̃́tũbi nɛ́pĩ̂ nímí yísyɔ́ sõ̀ mɛ tɛ̃̀nɔ́lɛ wɛ̃̀gbalɩ sɔkɔ. Pǎh noh nɛ Yesu-á pɔ n sɔkɔ, pè tyah n yo n mɔ yĩ́npɔ̃́ ǹgbɛ̃nɛ nɛ, pé Tɛ̃̀ ǹgbɛ̃, ǹmɔ nɛ̂-á Davidi Pídĩ́nɛ, ńkɛ̃́ à pé yãm yah. ");
INSERT INTO wib_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Képah tɛ̃̀nɛ, tɔ́wû dírí kõ pé yõ nɛ pè pé vyɛ̃y vike. Ǹtɛ pè tɔ̃ wãn mɔ pé yónmɔnɔ yõ nɛ ńkɛ̃́, pé Tɛ̃̀ ǹgbɛ̃, ǹmɔ nɛ̂-á Davidi Pídĩ́nɛ, ńkɛ̃́ à pé yãm yah. ");
INSERT INTO wib_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesu mɛ yĩn tɛ́ pè ye yah, tɛ́ yo pé tyɩ́ nɛ: «Kwâh nɛ̂ mɛ yé mɛ ké tyɩ́ nɛ mé pɩ yé tyɩ́?» ");
INSERT INTO wib_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Pè mɛ yo ǹ tyɩ́ nɛ, pé Tɛ̃̀ ǹgbɛ̃, à pé yɩ̃́ yɩkɩ mɔ. ");
INSERT INTO wib_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Képah tɛ̃̀nɛ, pé yãm Yesu tɛ̃. À mɛ tũ pé yɩ̃́ tyɩ́. Nɛ́npɔ́ swɔ, pé yɩ̃́ núkú yɩkɩ mɔ. Pè mɛ ǹ sõ̀ tɛ̃. ");
INSERT INTO wib_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesu ànɛ̂ ǹ tõ̀ sã́hpú sõ̀ mɛ fɩ́ɩ́ kwéy Yerusalɛmɩ kwillɛ. Pè sõ̀ mɛ yúkɛy Bɛtifasyɩ kwillɛ, képah nɛ̂-á mɛ Wólívyê yèh yɔ̃lɩ yõ. Képah sɔkɔ, à mɛ ǹ tõ̀ sã́hpú nɛ́pĩ̂ nímí tõ ");
INSERT INTO wib_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","nɛ ńkɛ̃́: «Kwil nɛ̂-á yé yah tĩ̀nnɛ yɔ̀, yé kyɩ ké sɔkɔ. Yé kɩ núkú ńkwɛ̃́ndyɩ́yũ̌kì yɔ́ wɛ tóhnmɔnsàhnɔ́lɛ ńkwɛ̃́ndyɩ́píkì yɔ́lɛ ǹ tnɔ̂. Yé à dɛ, yè pɔ sélɛ ń kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Nɛ̂-à kɩ nɛ pé yo, yè yo tɛ̃̀ tyɩ́ nɛ, sé yétõ̂-á mɛ Tɛ̃̀ ǹgbɛ̃ tyɩ́. Képah sɔkɔ, tɛ̃̀ kɩ yɛ yé kɔ̃ yé kɩ sɔkɔ sélɛ nɛ́npɔ́ swɔ.» ");
INSERT INTO wib_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Yesu képah yo sɛ̃́, Liyel tɛ̃ntõ̀ syínyo-ò wɛy yónsàhnɔ́ mɛ̀ wil yĩnnɛ. Liyel tɛ̃ntõ̀ syínyo-ò lésõ nɛ ńkɛ̃́: ");
INSERT INTO wib_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«Yé yo Yerusalɛmɩ kwil tãn tyɩ́ nɛ, pè yah, pé yõ̀tɛ̃̀-á mɛ n pi pé tĩ̀nnɛ. Gblɔ̌y tíkínmɔnɔ-á mɛ ǹ sɔkɔ. Wǎh mɛ dɔ́kɔ́nkɔ̃ntɛ̃̀nɔ́lɛ ńkwɛ̃́ndyɩ́kɩ̀ yõ, nɛ̂-á ńkwɛ̃́ndyɩ́píkìlɛ.» ");
INSERT INTO wib_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Képah sɔkɔ, Yesu tõ̀ sã́hpú mɛ kyɩ tyi nɔ́pi pɩ ǹ yóré yõ. ");
INSERT INTO wib_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Pè ńkwɛ̃́ndyɩ́yũ̌kì ànɛ̂ ńkwɛ̃́ndyɩ́píkì mɛ̀ tɛ̃ pɔ, tɛ́ pé flɔ mɔ sé yõ Yesu kɔ̃ à dɔkɔ kɔ̃ tɛ̃. ");
INSERT INTO wib_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Nɛ́kwĩ́nkí sõ̀ mɛ pé flɔlɛ n mɔ n yuku wɛ̃̀kɩ̀ yõ, túkù mó mɛ pɛ̃̀mɩ̀lɛ n kwɔkɩ n mɔ n yuku. ");
INSERT INTO wib_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Tɔ́wû nɛ̂-á sõ̀ mɛ mɔ ǹ yah tĩ̀nnɛ pè n yuku, ànɛ̂ nónó-á sõ̀ mɛ ǹ sõ̀ tɛ̃, pé pól sõ̀ mɛ yo tũ yĩ́npɔ̃́ ǹgbɛ̃nɛ nɛ: «Gbílkínɔ́ nɛ n sah Davidi Pídĩ́ yõ. Névi nɛ̂-á n pi Tɛ̃̀ ǹgbɛ̃ yĩn yõ, Liyel sãm mɔ ǹ sɔkɔ. Gbílkínɔ́ nɛ n sah Liyel yõ, ǹmɔ nɛ̂-á mɛ yĩ̂nyõ.» ");
INSERT INTO wib_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesu-á pɔ n de Yerusalɛmɩ kwil sɔkɔ, nɛ́npɔ́ tãn pól yuku kwillɛ n yike wùù. Pè sõ̀ mɛ piki yah tũ nɛ, nɛ̂ se dĩ́ mɛ̀nɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Tɔ́wû mɛ yo pé tyɩ́ nɛ, Liyel tɛ̃ntõ̀ syínyo-ò Yesu-á, nɛ̂-á n wil Nasarɛtɩ kwil sɔkɔ, Kalile sétáh yõ. ");
INSERT INTO wib_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu-á de Liyel ní-ńsah gbô sɔkɔ, à yíyã̌m yã̀mpu ànɛ̂ yídwénè dwépú pól yĩni wilki ké sɔkɔ. À pɔ́ sàhntũ̀pu tàbǎlnɔ́ tu wilki mɔ, ànɛ̂ kèpíkípíkínɔ yã̀mpu klǒlɛ. ");
INSERT INTO wib_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Tɛ́ yo pé tyɩ́ nɛ: «Kè mɛ wã́rkɩ́nsàhnɔ́lɛ Liyel wɛy sɛ́bɛ́y sɔkɔ nɛ: ‹Ń gbô kɩ n ye nírí pɩ́-ńsah gbôlɛ.› Ǹtɛ yépi kè tɔkɔ pɩ yɩ̃́pú wɔ̃̀bɩ̀ntɛ̃̀-ǹsahlɛ kɛ̀?» ");
INSERT INTO wib_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Képah náh, yɩ̃́tũbi ànɛ̂ gbáhkɩ̀ núkú névye mɛ nɔ de Yesulɛ Liyel ní-ńsah gbô sɔkɔ. À mɛ pè dɛ mɔ. ");
INSERT INTO wib_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Sárká syínwìlkìpu yõ̀tãm ànɛ̂ Liyel tyi kõ̀nsàhnɔ́ kwɔ́pú-á gbǐl nɔ́pi pɩ́nɔ́ wɛ sɛ̃́, tɛ́ wɛ̃́npì tɔ̃ mɛ gbo mɔ tũ nɛ ńkɛ̃́, gbílkínɔ́ nɛ n sah Davidi Pídĩ́ yõ, pé fɔkɔ vyãh. ");
INSERT INTO wib_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Képah tɛ̃̀nɛ, pè mɛ yo Yesu tyɩ́ nɛ, wɛ̃́npì nɔ́pi-á mɛ nɛ̂nɛ n yo, à kó mɛ kélɛ n nohnɩ nɩ? À mɛ yo pé tyɩ́ nɛ: «Àwe mé mɛ kélɛ n nohnɩ. Tɛ́ wɛy nɛ̂-á wã́rkɩ́nsàhnɔ́lɛ Liyel wɛy sɛ́bɛ́y sɔkɔ nɛ: ‹Á kè pɩ á gbilki gbilki wɛlɔ n nohnɩ wɛ̃́npì ànɛ̂ wɛ̃́npì yrɔ̃́ vyɛ̃y sɔkɔ.› Yé se kɩ nɛ yé náh kè kar yah? ");
INSERT INTO wib_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Képah yóntɛnɔ náh, à yal pé tnɔ̂, tɛ́ wil kwil sɔkɔ à kyɩ sõ Betani kwil sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Dĩndal séngbɔ̃́lɛ, Yesu-á n syɩ n pi Yerusalɛmɩ kwil sɔkɔ, kwɛkɩ à tɛ̃. ");
INSERT INTO wib_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Wǎh sènsóké séswɔ̂ yɔ́ wɛ yúkɛy wɛ̃̀kɩ̀lɛ, à mɛ nɔ de ké tnɔ̂. Ǹtɛ à náh kwâh yɔ́ wɛ ké sɔkɔ. Kè sõ̀ mɛ mɩrɩ ó kɔ́kɔ́lɛ. Kǎh pɩ sɛ̃́, à mɛ yo ké tyɩ́ nɛ, tɔ̂ɔ́-á sɛ̃́ yɔ̀, képah tɛ̃̀ náh tɔ̃ n syi n yah n pi póllɛ. Nɛ́npɔ́ swɔ, séswɔ̂ mɛ̀ núkú kɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ǹ tõ̀ sã́hpú-á képah wɛ sɛ̃́, pé gbã̀n du. Pè mɛ Yesu piki yah nɛ ńkɛ̃́, kè se pɩ sɔ̃́ tɛ́ sènsóké mɛ̀ núkú kɔkɔ nɛ́npɔ́ swɔ nɩ? ");
INSERT INTO wib_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","À mɛ yo pé tyɩ́ nɛ: «Kègbɩ yõ mé kélɛ n yo yé tyɩ́, Liyel yõ sɛ̃́nɔ́-à mɛ yé sɔkɔ, tɛ́ yé náh mɛ n sõ tɔ̀tɔ̀, máh nɛ̂ pɩ sènsóké séswɔ̂ mɛ̀ sɔkɔ, yé tɔ kɩ fɛ̃ sɛ̃́nkɔ̃ pɩ. Tɛ́ kè náh n yĩn n pi képah ó tyɩ́ dɛ́, yé kɩ tɔ̃ fɛ̃ yo yɔ̃lɩ mɛ̀ tyɩ́ nɛ, kè yuku n yal ásõ̂ kè kyɩ n syɩkɩ n de pnɛ yɔ sɔkɔ, tɛ́ kè kɩ mó tɔ̃ pɩ. ");
INSERT INTO wib_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Liyel yõ sɛ̃́nɔ́-à mɛ yé sɔkɔ, tɛ́ yé kwáhdúkú nɛ̂ yah kɔ̃ Liyel tyɩ́ nírí sɔkɔ, yé kɩ kè wɛ. ");
INSERT INTO wib_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu kyɩ Liyel ní-ńsah gbô sɔkɔ. Wǎh mɛ névyelɛ n kwɔ gbĩ́ nɛ̂nɛ, sárká syínwìlkìpu yõ̀tãm ànɛ̂ kwil yèwàhnɩ̀ nɔ de ǹ tnɔ̂ tɛ́ à syah nɛ, nɛ̂ gbõ̀ yõ se à n pɩ tyi nɔ́pilɛ, ànɛ̂ nɛ̂ se kɔ̃ ǹnɛ kénɛ tɛ̃́nwɛnɔlɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","À mɛ yo pé tyɩ́ nɛ, péwɔ tɔ-á kɩ pè piki yah tir núkú ó kɔ́kɔ́lɛ. Pàh kɩ ké yah yo pé syah, pé tɔ-á kɩ mó yo pè syah nɛ̂ gbõ̀ yõ-á pé n pɩ tyi nɔ́pilɛ. ");
INSERT INTO wib_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Pépi tɛ̃̀ tyɩ́ à; nɛ̂ se tõ Nsyɔ̃nɛ à pɔ wèlnwìlkìnɔ́lɛ n pɩ nɩ? Liyel se, tĩ̂ névye se nɩ?» Képah sɔkɔ, pè tyah n yo wɛ̃ tyɩ́ nɛ, páh kɩ nɛ Liyel-á tõ ǹnɛ, wǎh kɩ pé syah nɛ, tɛ́ kwâh nɛ̂ se pɩ tɛ́ pé náh sɛ̃ ǹ yõ nɩ? ");
INSERT INTO wib_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ǹtɛ páh kɩ se mó tɔ̃ nɛ névye-á tõ ǹnɛ, tɔ́wû tíkí-á mɛ pé tɛ̃ pé pól-á sɔ̃́npɩ́lɛ mɛ Nsyɔ̃nɛ n tɔkɔ n pɩ Liyel tɛ̃ntõ̀ syínyo-òlɛ. ");
INSERT INTO wib_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Kǎh pɩ sɛ̃́, pè Yesu syah nɛ pé náh pɩ̃. Ǹ tɔ mó yo pé tyɩ́ nɛ, pé tɔ náh kè yo pè syah n pi, nɛ̂ gbõ̀ yõ-á pé n pɩ tyi nɔ́pilɛ. ");
INSERT INTO wib_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Képah sɔkɔ, Yesu tɔ̃ yo pé tyɩ́ nɛ: «Mé kɩ sèmìrkì yɔ́ yãh yé tyɩ́, yè mó yé sõnɔ yo ń tyɩ́ ké tyɩ́ sɔkɔ. Dĩ́npì nɛ́pĩ̂ nímí lésõ mɛ dĩ́ yɔ́ tyɩ́. À mɛ nɔ de gben tɛ̃̀nɛ, tɛ́ yo ǹ tyɩ́ nɛ, pé pídĩ́, ńkɛ̃́ à kyɩ tõ̀ pɩ pé tyɩ́ yɛ̀rɛsɛ̃̂ swãh sɔkɔ kwɛynɛ. ");
INSERT INTO wib_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","À mɛ ǹ sú syah nɛ kyɩ dékè náh mɛ pé tɛ̃. Tɛ́ dǒ kwéy, à kè wɛ ké yah náh. À mɛ yuku sɔkɔ swãh sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Sú mɛ̀ mɛ tɔ̃ nɔ de ǹ pídĩ́ ní-òlɛ, à wɛy núkú mɛ̀ ó yo ǹ tɔ tyɩ́. Ǹmɔ mɛ yo ǹ tyɩ́ nɛ, páh kɩ kyɩ, pé bɔ̌. Tɛ́ à náh pɔ kyɩ. ");
INSERT INTO wib_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Nɛ́pĩ̂ nímí nɔ́pi sɔkɔ, nɛ̂ tɛ̃̀ pé sú nɩ̀vɩ̀nɩ̀ pɩ?» Sárká syínwìlkìpu yõ̀tãm ànɛ̂ kwil yèwàhnɩ̀ nɔ́pi mɛ nɛ gben tɛ̃̀-á. Képah sɔkɔ, Yesu mɛ yo pé tyɩ́ nɛ: «Kègbɩ yõ mé kélɛ n yo yé tyɩ́, mɔ́rɩ́ syípú ànɛ̂ syɔ́ fɔ̀fɩ́npɩbɩ kɩ yé dyàh tɛ̃ Liyel tɔ̃́rɩ́ nɔlɩ yõ. ");
INSERT INTO wib_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Yé náh wɛ di, Nsyɔ̃ pɔ yé tyɩ́ à pɔ gbɩ wɛ̃̀kɩ̀lɛ yé wɛ̃kɩ, tɛ́ yé náh sɛ̃ ǹ yõ. Ǹtɛ mɔ́rɩ́ syípú ànɛ̂ syɔ́ fɔ̀fɩ́npɩbɩ wɔ pyě sɛ̃ ǹ yõ. Yé mó tɔ̃ kè wɛ yĩ́nɛ, tɛ́ képah fyé yõ, yé náh yé nnɔ vi mɔ à sɛ̃ ǹ yõ.» ");
INSERT INTO wib_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesu tɔ̃ yo pé tyɩ́ nɛ: «Yé yé ní sah noh ń tyɩ́ sèmìrkì yɔ́lɛ ńtɔ̃ yɔ̀: Sètɛ̃̀ dĩ́ yɔ́ lésõ yɛ̀rɛsɛ̃̂ swãh kõ, tɛ́ kɛ̃kɩ mɔ kè kore vi, tɛ́ swɔ yɔ́ tũ tɛ́dáhkɩ̀ yõ ké sɔkɔ, à pɩ yɛ̀rɛsɛ̃̂ pye yĩ́kí-ńsahlɛ. Tɛ́ ké syɩ́kɩ́pú dɔ́kɔ́ntɛ̃̀-ǹsah mɔ kèyy ké sɔkɔ. Képah náh, à yɛ̀rɛsɛ̃̂ swãh tṍpú yísyɔ́ tɔkɔ pɔ sah ké yõ, pɩ́ndibinɔ yõ, tɛ́ sɔkɔ kɔ́lɔ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Sé pye gbɛ gbĩ́-á pɔ n nɔ, sètɛ̃̀ dĩ́ ǹ tõ̀npɩbɩ tõ yɛ̀rɛsɛ̃̂ swãh tṍpú nɔ́pi tyɩ́ nɛ, pè pé wɛ wɛ tɛ̃̀nɛ pè kɔ̃ pè pɔ pé kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ǹtɛ yɛ̀rɛsɛ̃̂ swãh tṍpú nɔ́pi yuku pè tɛ̃, tɛ́ núkú ko képékèyɔ̂, tɛ́ kèyǎh ko mɔ, tɛ́ kèyǎh minki ko dyêhlɛ. ");
INSERT INTO wib_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Sètɛ̃̀ dĩ́ tɔ̃ ǹ tõ̀npɩbɩ yísyɔ́ tɛkɩ mɔ, nónó-á dò kal gbro tãnnɛ. Pè tɔ̃ pépi tɔ pɩ sɛ̃́ntɛ̃̀ ólɛ. ");
INSERT INTO wib_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Kǎh pɩ sɛ̃́, à tɔ̃ ǹ pídĩ́ tõ pé tyɩ́ tɛ́ynɛ, tɛ́ mɛ n sõ nɛ, pǎh kɩ ǹmɔ wɔ yah sen ku. ");
INSERT INTO wib_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ǹtɛ yɛ̀rɛsɛ̃̂ swãh tṍpú nɔ́pi-á fyɔ̀ ǹ pídĩ́ wɛ, pè núkú yo wɛ̃ tyɩ́ nɛ, ǹ gbɛ̃̀yõ-á yɔ̀. Pè pɔ pé à ko mɔ, gbɛ̃kɩ mó pɩ pépi tyɩ́lɛ. ");
INSERT INTO wib_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Képah tɛ̃̀nɛ, pè núkú à fyãh tɛ̃, tɛ́ à wilki mɔ swãh kahnɩnɛ, tɛ́ à ko mɔ. ");
INSERT INTO wib_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yé tɔkɔ nɛ n yah kɛ̀; sètɛ̃̀ dĩ́-à pɔ pɔ, sɔ̃́ mɛ à kɩ pɩ pélɛ?» ");
INSERT INTO wib_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Pè mɛ nɛ, wǎh kɩ kénɛ nɛ́pêl ko mɔ pélpèl, tɛ́ kɩ yɛ̀rɛsɛ̃̂ swãh tṍpú yísyɔ́ tɔkɔ pɔ sah ǹ swãh mɛ̀ yõ, pɩ́ndibinɔ yõ. Pépi wɔ-á kɩ ǹ wɛ wɛ tɛ̃̀nɛ ǹnɛ n kɔ̃ ké gbĩ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Képah sɔkɔ, Yesu mɛ yo pé tyɩ́ nɛ: «Yé se kɩ nɛ yé náh wɛy mɛ̀ kar yah póllɛ, nɛ̂-á yo Liyel wɛy sɛ́bɛ́y sɔkɔ nɛ ńkɛ̃́: ‹Wɔ̀kɔ̀ mɔ́pú-á dáhkɩ̀ nɛ̂ yahle, képah yétõ̂ pɔ kal. Tɛ̃̀ ǹgbɛ̃ tõ̀ vyãh ye képahlɛ. Gbɛ̃̀ndùnì tir ye kélɛ ápi yah sɔkɔ yɔ̀ dɛ́!» ");
INSERT INTO wib_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Képah yóntɛnɔ náh, Yesu tɔ̃ yo pé tyɩ́ nɛ: «Mé kélɛ n yo yé tyɩ́ tɔlɛ nɛ, Liyel tɔ̃́rɩ́ sɔkɔ tɛ̃̀nɔ́ kɩ syi yépi Nsyifunɔ tyɩ́ kɩ yìkì yɔ́ névye kɔ̃, nónó-á kɩ tyípéplɔlɛ n pɩ ké sɔkɔ Liyel-á mɛ nónó tyɩ́.  ");
INSERT INTO wib_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Wɔ̀kɔ̀ mɔ́pú-á dáhkɩ̀ nɛ̂ yahle, névi nɛ̂-à wil syɩkɩ képah yõ, tɛ̃̀ kɩ kwɔkɩ. Tɛ́ kàh se mó tɔ̃ syɩkɩ nɛ̂ yõ, kè kɩ tɛ̃̀ pyãhrɩ.» ");
INSERT INTO wib_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Sárká syínwìlkìpu yõ̀tãm ànɛ̂ Farisi wɛ̃̀kɩ̀ kɔ́pú-á fyɔ̀ sèmìrn nɔ́pi noh, pè pɩ̃ nɛ pépi yõ-á Yesu mɩ sélɛ. ");
INSERT INTO wib_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Képah tɛ̃̀nɛ, pè sõ̀ mɛ ké tyɩ́ nɛ pé à tɛ̃, tɛ́ tɔ́wû tíkí pè tɛ̃. Tɔ́wû sõ̀ mɛ Yesulɛ n tɔkɔ n pɩ Liyel tɛ̃ntõ̀ syínyo-òlɛ képah ye. ");
INSERT INTO wib_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu tɔ̃ tyah sèmìrkì yɔ́lɛ n yãh pé tyɩ́ nɛ: ");
INSERT INTO wib_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Liyel tɔ̃́rɩ́-á kɩ fɛ̃ tɔkɔ sãh sèmìrkì nɛ̂nɛ, kè wɛ yɔ̀: Yõ̀tɛ̃̀ dĩ́ yɔ́ lésõ ǹ pídĩ́ fúr fèn pɩ. ");
INSERT INTO wib_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Tɛ́ mɛ ǹ tõ̀npɩbɩ wilki tõ nɛ, pè kyɩ nɛ́yénɔ́ ye n pɔ fúr yõke yṍ-ńsah. Ǹtɛ nɛ́yénɔ́ nɔ́pi náh sõ̀ mɛ ké tyɩ́ nɛ pé pɔ. ");
INSERT INTO wib_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Képah tɛ̃̀nɛ, à tɔ̃ tõ̀npɩbɩ yísyɔ́ wilki tõ pé tyɩ́ nɛ, pĩ́n-á pɩ tɛ. Páh nyéhpyɛ́nɩ̀ ànɛ̂ yípɛ̂y ko tɛ nɩrɩ-á mɛ nónó sɔkɔ. Tyi pól-á pɩ tɛ, pè pɔ fúr sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ǹtɛ nɛ́yénɔ́ nɔ́pi náh kè mɔ kõ póllɛ. Ńyɔ-à yuku à n sɔkɔ ǹ swãh, ńyɔ-à yuku à n sɔkɔ ǹ gbɔ̀ yɩ̃́-ńsah. ");
INSERT INTO wib_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Pé túkù mɛ yuku mɩ yõ̀tɛ̃̀ dĩ́ tõ̀npɩbɩ sɔkɔ, à pè fõh pélpèl, tɛ́ pè ko mɔ. ");
INSERT INTO wib_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Képah sɔkɔ, yõ̀tɛ̃̀ dĩ́ fɔkɔ kah vyãh. À mɛ ǹ sràsyíbí tɛkɩ mɔ pè kyɩ kénɛ nɛ́kókè mɔ́pú ko mɔ, tɛ́ pé kwil sukɛ. ");
INSERT INTO wib_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Képah náh, tɛ́ yo ǹ tõ̀npɩbɩ tyɩ́ nɛ, fúr yõke-á pɩ tɛ. Ǹtɛ nɛ́yénɔ́ nɔ́pi náh sõ̀ yɩ̃nɛ yõke mɛ̀ yṍnɔ́lɛ. ");
INSERT INTO wib_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ńkɛ̃́ pè kyɩ wɛ̃̀tlo yey sɔkɔ, pàh kɩ fyɔ̀ névye nónó wɛ, pè pé pól ye n pɔ fúr yõke yṍ-ńsah. ");
INSERT INTO wib_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Tõ̀npɩbɩ nɔ́pi mɛ sɔkɔ wã̀l yey sɔkɔ. Pǎh kyɩ tɛ́ névye nónó wɛ, nɛ́túkúnì tɔkɔ dohnɩ nɛ́péplɔ yõ, pè pé pól ye pɔ tuke mɔ, fɔ́ɔ́ fúr pɩ́-ńsah wɔ̀kɔ̀ pól yuku yõke yṍpúlɛ. ");
INSERT INTO wib_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Yõ̀tɛ̃̀ dĩ́-á de yuku yáh-ńsah pé tyɩ́, à kyɩ dĩ́ yɔ́ wɛ pé sɔkɔ nɛ̂ náh sõ̀ mɛ fúr flɔ mɔ. ");
INSERT INTO wib_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","À mɛ yo kénɛ dĩ́ tyɩ́ nɛ, pé kódĩ́, ǹmɔ se de sɔ̃́ ásõ̂ sɔkɔ fúr flɔ kɛ̃́nɛ ǹ wil sɔkɔ nɩ? Ǹtɛ yó-ńsah náh wɛ dĩ́ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Képah sɔkɔ, yõ̀tɛ̃̀ dĩ́ yo tõ̀npɩbɩ tyɩ́ nɛ pè ǹ gbyẽ̂h ànɛ̂ ǹ gbã̀n pukubi, pè mó à min mɔ kégbɔ́ fɛ̃́ntũ̂ sɔkɔ, ńyãh sɔkɔ-á gbní ànɛ̂ yní táhnɔ́ kɩ mɛ. ");
INSERT INTO wib_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yé náh wɛ di, névye náhnáh mɛ yénɔ́lɛ. Ǹtɛ nónó-á yah wilki pé sɔkɔ, pè náh mɛ fwɔ́ɔ.» ");
INSERT INTO wib_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Képah sɔkɔ, Farisi wɛ̃̀kɩ̀ kɔ́pú kyɩ wɛ̃ wɛ à yo sah núkú yõ, sɔ̃́-á pè kɩ pɩ tɛ́ kɩ Yesu wɛ n tɛ̃ n pi ǹ vyãh wɛy sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Tɛ́ mɛ pé tõ̀ sã́hpú yísyɔ́ ànɛ̂ yõ̀tɛ̃̀ dĩ́ Yerɔdɩ náh névye túkù wilki tõ Yesu tyɩ́ nɛ pè kyɩ yo ǹ tyɩ́ nɛ, pé kwɔ́-ò dĩ́, páh pɩ̃ nɛ gbɩ yó-ò-á ǹnɛ, ànɛ̂ wǎh Liyel wɛ̃̀kɩ̀lɛ névyelɛ n kwɔ gbɩ wɛ̃̀kɩ̀ yõ. À náh névye yah tíkílɛ n pɩ. À náh névyelɛ n wah. ");
INSERT INTO wib_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ǹtɛ à ǹ sõnɔ yo pé syah. Ńkɛ̃́ ké wɛ̃̀kɩ̀ se mɛ kɔ̃́nɔ́lɛ nɛ pé mɔ́rɩ́lɛ n mɔ Wrome kwíltãm yõ̀tɛ̃̀ ǹgbɛ̃ Sesar tyɩ́, tĩ̂ ké wɛ̃̀kɩ̀ náh mɛ kɔ̃́nɔ́lɛ? ");
INSERT INTO wib_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ǹtɛ Yesu-á pé fɔkɔ sõnɔ túkúnì pɩ̃ sɛ̃́, à mɛ yo pé tyɩ́ nɛ, fɔ̀kɔ̀pǐl ànɛ̂ vyã́hsesyɩ̃́rɩ́ névye nɔ́pi, sɔ̃́ se pɩ tɛ́ pè pé pílkíntɛ̃-ńsahlɛ n yah n kɔ̃ nɩ? ");
INSERT INTO wib_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Pè pɔ mɔ́rɩ́ mɔ mɔ pɔ́ pɔ́ núkúlɛ pé yah ǎtrɛ. Pè mɛ pɔ ké núkúlɛ à kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Yesu mɛ pè piki yah nɛ, nɛ̂ yah mírkí ànɛ̂ ǹ yĩn se wã́rkɩ́nmɔnɔlɛ ké yõ yɔ̀ nɩ? ");
INSERT INTO wib_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Pè mɛ yo ǹ tyɩ́ nɛ, Sesar tyɩ́-á. Képah sɔkɔ, Yesu mɛ yo pé tyɩ́ nɛ, pè Sesar tyɩ́lɛ Sesarlɛ n kɔ̃, pè mó Liyel tyɩ́lɛ Liyellɛ n kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Pǎh képah tɛ̃̀ noh sɛ̃́, pé gbã̀n du. Pè mɛ yal ǹ tnɔ̂ à sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Lésõ mɛ̀ ólɛ, Sadusi wɛ̃̀kɩ̀ kɔ́pú nónó-á ńkɛ̃́nɛ nɛ n yo nɛ lékyɩ̂ yílkínmɔnɔ náh mɛ, pé túkù nɔ de Yesu tnɔ̂ tɛ́ à piki yah nɛ, ");
INSERT INTO wib_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","kwɔ́-ò dĩ́, Moyisi-á kè yo ǹ tyi kõ̀nsàhnɔ́ sɔkɔ nɛ, dĩ́ nɛ̂-à ku pi kɛ̃́nɛ ǹ tyɩ́, ǹ gbɛ̃̀ndĩ́-á yɩ̃nɛ à ǹ kyɩ pɛ́kúsè mɛ̀ tɔkɔ, à pi dubi à kɔ̃, nɛ̂-á kɩ pɔ n pɩ n pi ǹ nɛ́nkyɩ́ dĩ́ lékókè náhnɛ. ");
INSERT INTO wib_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ǹtɛ sú núkú dĩ́npì nɛ́pĩ̂ kwǎrnimi yísyɔ́-á lésõ mɛ pépi wrɔ́ sɔkɔ. Gben tɛ̃̀ mɛ pɔ sê tɔkɔ, tɛ́ pɔ ku pi wɛ́-ńkɛ̃̂nɛ tɛ́ ǹ kyɩ sah ǹ sõ̀ syɩ kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ǹtɛ ǹmɔ tɔ tyɩ́ tɔ̃ pɔ pɩ sɛ̃́, tɔ̃́-ò tɔ tyɩ́ pɔ pɩ képah núkú ólɛ, fɔ́ɔ́ à pɔ syɩ kwǎrní-ò tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Pépi pól tyɩ́ náh, pi mɛ̀ tɔ-á pɔ ku. ");
INSERT INTO wib_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ǹtɛ pi mɛ̀-á de yah pé pól tyɩ́ sɛ̃́ à, lékyɩ̂ yilki n mɔ sõlɛ, à se kɩ n pɩ n pi pé nɛ́pĩ̂ kwǎrnimi nɔ́pi sɔkɔ nɛ̂ tɛ̃̀ tyɩ́lɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Képah sɔkɔ, Yesu yo pé tyɩ́ nɛ: «Liyel wɛy sɛ́bɛ́y pɩ̃́-ńkɛ̃̂ ànɛ̂ Liyel tɛ̃́nwɛnɔ pɩ̃́-ńkɛ̃̂ ye mɔ sah yélɛ pílkínɔ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Yé yah, lékyɩ̂-à pɔ yilki mɔ, pɛ́dékè náh kɩ n mɛ n pi, sétɔ́kɔ́kɩ̀ tɔ náh kɩ n mɛ n pi. Ǹtɛ névye kɩ mɛ yĩ̂nyõ tõ̀npɩbɩ tyɩ́ kɔ̃lɛ yĩ̂nyõ. ");
INSERT INTO wib_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Tɛ́ à yuku lékyɩ̂ yílkínmɔnɔ wɔ tyɩ́ sɔkɔ, Liyel-á nɛ̂ yo yé tyɩ́, yé náh kè kar yah di? À lésõ nɛ: ");
INSERT INTO wib_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‹Ńmɔ ye Abrahmɩ Liyellɛ, ànɛ̂ Yisakɩ Liyellɛ, ànɛ̂ Nsyakɔbɩ Liyellɛ.› Liyellɛ, lékyɩ̂ Liyel náh ǹnɛ dò, vye Liyel ye. Képah n wɛ̃kɩ nɛ á náh tãn Abrahmɩpi lékyɩ̂-á yilki mɔ.» ");
INSERT INTO wib_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Képah tɛ̃̀nɛ, tɔ́wû nɛ̂-á sõ̀ mɛ ǹ wɛynɛ n nohnɩ, pé gbã̀n du ǹ névye kwɔ dùkù tyɩ́lɛ. ");
INSERT INTO wib_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Farisi wɛ̃̀kɩ̀ kɔ́pú-á noh nɛ Yesu-á wɛynɛ Sadusi wɛ̃̀kɩ̀ kɔ́pú tɛ̃, pè wɛ̃ ye tuke mɔ. ");
INSERT INTO wib_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Tɛ́ pé Liyel tyi kõ̀nsàhnɔ́ pɩ̃́pú sɔkɔ yɔ́ mɛ píkínyahnɔ yɔ́ pɩ Yesu tyɩ́ ǹ pilki n tɛ̃ yĩnnɛ nɛ, ");
INSERT INTO wib_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","kwɔ́-ò dĩ́, Liyel tir kõ̀nsàhnɔ́ nɛ̂ tɛ̃̀ tyɩ́ se tah kal sé tɛ́lɔ́lɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesu mɛ yo ǹ tyɩ́ nɛ: «Á Tɛ̃̀ ǹgbɛ̃ Liyel tyɩ́ yɩ̃nɛ kɩ nɔ á tyɩ́ á nɩ póllɛ, ànɛ̂ á min póllɛ, ànɛ̂ á sõnɔ póllɛ.› ");
INSERT INTO wib_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Képah ye tir kõ̀nsàhnɔ́ gbennɛ, ànɛ̂ nɛ̂ tyɩ́-á tah kal. ");
INSERT INTO wib_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ké ní-ò nɛ̂-á tɔ̃ mɛ ké tyɩ́ kɔ̃lɛ, képah ye yɔ̀ nɛ: ‹Yɛ á ní-ò tyɩ́ nɔ á tyɩ́ á gblɔ̌y tyɩ́ kɔ̃lɛ.› ");
INSERT INTO wib_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Moyisi tyi kõ̀nsàhnɔ́ ànɛ̂ Liyel tɛ̃ntõ̀ syínyopu sɛ́bɛ́ynɔ́ sɔkɔ tyi pól mɛ tyi kõ̀nsàhnɔ́nɔ nínɔ́ nɔ́pi sɔkɔ.» ");
INSERT INTO wib_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Farisi wɛ̃̀kɩ̀ kɔ́pú-á sõ̀ mɛ tùkènmɔnɔlɛ, Yesu mɛ píkínyahnɔ yɔ́ pɩ pé tyɩ́ nɛ: ");
INSERT INTO wib_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«Yépi tɛ̃̀ sõnɔ nɛ̂nɛ Krista tyɩ́ sɔkɔ, nɛ̂-á Liyel nɛy yáhntɔkɔnɔlɛ? Nɛ̂ pídĩ́ mɛ ǹnɛ?» Pè mɛ yo ǹ tyɩ́ nɛ, Davidi Pídĩ́-á. ");
INSERT INTO wib_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Képah sɔkɔ, à mɛ yo pé tyɩ́ nɛ: «Ǹtɛ kwâh nɛ̂ pɩ tɛ́ Liyel Mirki-á Davidi yah tɛ̃, Davidi mɛ Krista ye Tɛ̃̀ ǹgbɛ̃nɛ? Yé náh wɛ di, à lésõ nɛ ńkɛ̃́, ");
INSERT INTO wib_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","nɛ̂-á péwɔ TƐ̃̀ ǸGBƐ̃NƐ Tɛ̃̀ ǹgbɛ̃ Liyel-á kè yo ǹ tyɩ́ nɛ ńkɛ̃́, à pɔ n kɔ̃ n tɛ̃ pé gbõ̀yõ̀ sõ̀lɛ, fɔ́ɔ́ kè pɔ nɔ gbĩ́ nɛ̂-á pé kɩ ǹ sépɛ́bɩ́ pɩ ǹ gbáhkɩ̀ súnsàh-ǹsahlɛ. ");
INSERT INTO wib_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ǹtɛ Davidi-á Krista ye TƐ̃̀ ǸGBƐ̃NƐ à kɩ tɔ̃ pɩ sɔ̃́ tɛ́ kɩ pɔ n pɩ ǹ Pídĩ́nɛ?» ");
INSERT INTO wib_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Yesu-á sépi yo, tyíyóné náh tɔ̃ fɛ̃ wɛ pé sɔkɔ yɔ́ ńtɛ̃ tyɩ́. Tɛ́ à tɔkɔ lésõ tyɩ́, ǹnɩ̂ yɔ́ ńtɛ̃ náh tɔ̃ ǹ nɩ syãh à piki yah yah tir yɔ́ ńtɛ̃nɛ. ");
INSERT INTO wib_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Yesu yo ǹ tõ̀ sã́hpú ànɛ̂ tɔ́wû tyɩ́ nɛ: ");
INSERT INTO wib_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«Liyel tyi kõ̀nsàhnɔ́ kwɔ́pú ànɛ̂ Farisi wɛ̃̀kɩ̀ kɔ́pú ye n kwɔ névyelɛ Moyisi tyi kõ̀nsàhnɔ́lɛ. ");
INSERT INTO wib_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Yé nɛ n nohnɩ pé tyɩ́, yè mó nɛ n kɔ pé yóré yõ. Ǹtɛ pǎh kwɔ́nɔ́ nónónɛ n pɩ, pè náh mɛ n kɔ sé wã̀l yõ. Képah ye, yé káh pé pɩ dùkù tɛ̃̀ wɔlɛ n yah n pɩ. ");
INSERT INTO wib_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Pǎh ńkɛ̃́nɛ névyelɛ n kwɔ tyi nónónɛ, sè mɛ á kɩ nɛ tɔ́kɔ́pêl sɔ̃́ pè pukubi pè twah mɔ, tɛ́ pè náh n fɛ̃ n syi n so n mɔ pé tyɩ́ kèngbɔ núkú fyélɛ. ");
INSERT INTO wib_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Pě pé gblɔ̌ynɛ n wɛ̃kɩ pé tyípɩ́nɩ̀ pól sɔkɔ. Képah ye, kyɛ́súpî nónó-á Liyel wɛynɛ sé sɔkɔ yèwɛtyêh yey toh n mɔ mɔ tɛ̃̀nɛ, képah náh pɩ gbã̀n tyɩ́ toh n mɔ mɔ tɛ̃̀nɛ, pépi pé tyɩ́nɔ pɩ gblò gblò, ǹ tɛ́ pé flɔ vyɛ̃y dro pɩ flɛ̀yflɛ̀y. ");
INSERT INTO wib_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Tɛ̃̀-ǹtã̀n gbro tyɩ́ nɔ pé tyɩ́ yénɔ yṍ-ńtã̂n sɔkɔ ànɛ̂ Liyel ní-ńtã̂n vɩ̀ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Pè n nɛ n mɛ ké tyɩ́ nɛ, névye nɛ n tɔ̃ n sah n wɛkɩ n pɔ pé tyɩ́ tɔ́wû tùkè-ǹtã̀n sɔkɔ, pè mó pélɛ n ye Kwɔ́púlɛ. ");
INSERT INTO wib_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ǹtɛ yépi tyɩ́ kwɔ́-ò núkú ó ye mɛ, tɛ́ yé tɛ́lɔ́ póllɛ núkú ye. Képah ye, yépi tɛ̃̀ wɔ káh nɛ pè yélɛ n ye Kwɔ́púlɛ. ");
INSERT INTO wib_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Sú núkú ó ye mɛ yé tyɩ́, nɛ̂-á mɛ yĩ̂nyõ. Képah ye, yé káh ǹnɩ̂ yɔ́ ńtɛ̃nɛ n ye Súlɛ sétáh mɛ̀ yõ sɔkɔ ǹ Liyel wɛ̃̀kɩ̀ kɔ́lɔ́ yĩnnɛ. ");
INSERT INTO wib_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Yah tɛ̃́-ò núkú ó ye mɛ yé tyɩ́. Krista ye, nɛ̂-á Liyel nɛy yáhntɔkɔnɔlɛ. Képah ye, yé káh nɛ pè yélɛ n ye Yah tɛ̃́púlɛ. ");
INSERT INTO wib_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Yĩ́n-ńsah ǹgbɛ̃-á mɛ névi nɛ̂ tyɩ́ yé sɔkɔ, tɛ̃̀ wɔ yɩ̃nɛ à pɩ yé tõ̀npɩlɛ. ");
INSERT INTO wib_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Névi nɛ̂-à ǹ gblɔ̌y dɔkɔ sah, tɛ̃̀ kɩ tiki mɔ. Tɛ́ nɛ̂-à ǹ gblɔ̌y tiki mɔ, tɛ̃̀ kɩ dɔkɔ mɔ. ");
INSERT INTO wib_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Yépi Liyel tyi kõ̀nsàhnɔ́ kwɔ́pú ànɛ̂ Farisi wɛ̃̀kɩ̀ kɔ́púlɛ, pèkè mɛ yé yõ. Vyɛ̃́nnínì wɛ́kɩ́pú ye yélɛ. Yě Liyel tɔ̃́rɩ́ nɔlɩ yṍnɔ́ yah kõ névye tyɩ́. Yé náh mɛ ké tyɩ́ nɛ yé ké nɔlɩ yõ, tɛ́ nónó-à se mó tɔ̃ nɛ pé ké nɔlɩ yõ, yě pé yah kõ.  ");
INSERT INTO wib_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Yépi Liyel tyi kõ̀nsàhnɔ́ kwɔ́pú ànɛ̂ Farisi wɛ̃̀kɩ̀ kɔ́púlɛ, pèkè mɛ yé yõ. Vyɛ̃́nnínì wɛ́kɩ́pú ye yélɛ. Yě pɛ́kúsyɔlɛ n vi n tɛ̃ pé gbã̀n yîlɛ n syi pé tyɩ́, ǹ tɛ́ nírílɛ n pɩ yõ̀sɛ̃̀kɩ̀lɛ nɛ névye pé wɛ. Kǎh pɩ sɛ̃́, yé tukey kɩ n pɩ n pi képékèyɔ̂ kal no tɛ́lɔ́ tyɩ́lɛ. ");
INSERT INTO wib_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Yépi Liyel tyi kõ̀nsàhnɔ́ kwɔ́pú ànɛ̂ Farisi wɛ̃̀kɩ̀ kɔ́púlɛ, pèkè mɛ yé yõ. Vyɛ̃́nnínì wɛ́kɩ́pú ye yélɛ. Yě yrɛy ànɛ̂ sétáh yõ pól kɔ n kɔ̃ nɛ́núkù fyé yáhnkɔ̃nɔ sɔkɔ Nsyifunɔ wɛ̃̀kɩ̀ tɛ̃ yĩnnɛ. Tɛ́ nɛ̂-à se wɛ fɛ̃ syi, yè n tɔ̃ ǹmɔ pɩ à kɔ̃ à n yɩ̃nɛ dénɔ́lɛ ní-ńkɛ̃̂ nyàhnpèkè sɔkɔ à kal yépilɛ kɛ nínɔ́. ");
INSERT INTO wib_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Pèkè mɛ yé yõ, yépi nónó-á yah tɛ̃́pú yɩ̃́tũbilɛ. Yè n nɛ n yo nɛ ńkɛ̃́, névi-à n wo Liyel ní-ńsah wɔ̀kɔ̀ kètǎrlɛ, képah náh n mɔ n kõ n pi. Tɛ́ nɛ̂-à n wo Liyel ní-ńsah wɔ̀kɔ̀ kètǎr sɔkɔ sã́nnɛ, képah-á kɩ mɔ kõ. ");
INSERT INTO wib_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Lékã́m kɛ̃́ névye, yɩ̃́tũbi nɔ́pi, sã́n wɔ se fṍnfṍ Liyel ní-ńsah wɔ̀kɔ̀ kètǎr yõ sɔkɔ, képah nɛ̂ gbõ̀ yõ-á sã́n n mɔ n kõ Liyel tyɩ́ yõ? ");
INSERT INTO wib_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Yè n nɛ n yo tɔlɛ nɛ ńkɛ̃́, névi-à n wo sárká súkɛ́nkɔ̃-ńsahlɛ, képah náh n mɔ n kõ n pi. Tɛ́ nɛ̂-à n wo sárká kwâhlɛ, nɛ̂-á mɛ sárká súkɛ́nkɔ̃-ńsah yõ sɔkɔ, képah-á kɩ mɔ kõ. ");
INSERT INTO wib_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Yɩ̃́tũbi nɔ́pi, sárká wilki wilki kwâh wɔ se fṍnfṍ sárká súkɛ́nkɔ̃-ńsah yõ, képah nɛ̂ gbõ̀ yõ-á sárká n mɔ n kõ Liyel tyɩ́ yõ? ");
INSERT INTO wib_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Névi nɛ̂-à fyɔ̀ n wo sárká súkɛ́nkɔ̃-ńsahlɛ, tɛ̃̀ ye ǹ wo tɛ ké yõ sárká yî tɔlɛ. ");
INSERT INTO wib_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Névi nɛ̂-à fyɔ̀ n wo Liyel ní-ńsah wɔ̀kɔ̀ kètǎrlɛ, tɛ̃̀ ye ǹ wo tɛ Liyel tɔlɛ, ǹmɔ nɛ̂-á mɛ ké sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Névi nɛ̂-à fyɔ̀ n wo yĩ̂nyõlɛ, tɛ̃̀ ye ǹ wo tɛ Liyel tɔ̃́rɩ́ kǒ tɔlɛ ànɛ̂ ké yõ kɔ̃́ntɛ̃̀-òlɛ. ");
INSERT INTO wib_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Yépi Liyel tyi kõ̀nsàhnɔ́ kwɔ́pú ànɛ̂ Farisi wɛ̃̀kɩ̀ kɔ́púlɛ, pèkè mɛ yé yõ. Vyɛ̃́nnínì wɛ́kɩ́pú ye yélɛ. Yě nànàye ànɛ̂ pɛ̃́nfěnè pól gbãm-ònɔ́lɛ Liyellɛ n kɔ̃. Ǹtɛ gbɩ wɛ̃̀kɩ̀ kɔ́lɔ́, ànɛ̂ névye yãm yáhnɔ́, ànɛ̂ tyi pɩ́nɔ́lɛ sé wã̀l yõ, sépi nónó tyɩ́-á tah kal Liyel tyi kõ̀nsàhnɔ́ sɔkɔ, yè n pyě sépi wɔ yahle; sépi nónó-á yé yɩ̃nɛ yè nɛ n pɩ gbõ̀nwɔ̀kɔ̀ kɛ̃́nɛ, à tahlɩ yáh mɛ nónónɛ n pɩ. ");
INSERT INTO wib_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Névye yah tɛ̃́pú yɩ̃́tũbi nɔ́pi. Yáh nɛ̂nɛ n pɩ yɔ̀, kè mɛ á kɩ nɛ yé wɔ wɔ ni sɔ̃́ yé n syi à sèswɔ̃lɛ n wilki ké sɔkɔ, tɛ́ pyě yã̀hmɩ́nɩ̀ wɔlɛ n wɔ n mɔ n yɔ sɔ̃́. ");
INSERT INTO wib_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Yépi Liyel tyi kõ̀nsàhnɔ́ kwɔ́pú ànɛ̂ Farisi wɛ̃̀kɩ̀ kɔ́púlɛ, pèkè mɛ yé yõ. Vyɛ̃́nnínì wɛ́kɩ́pú ye yélɛ. Yě wóhlɔ́ ànɛ̂ yɛ̃́yṍvyɔ náhlɔ́ wu n tɔ̃ n sah, tɛ́ sé sɔkɔ táhlɔ́ n nɛ mɛ yúkúnɔ́lɛ yé yɩ̃be yîlɛ ànɛ̂ yî nónó dékè képékè-á mɛ yé sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Farisi wɛ̃̀kɩ̀ kɔ́pú yɩ̃́tũbi nɔ́pi. Yé vyɔ́ sɔkɔ táhlɔ́ ǹgbò tɔ̃ n sah. Képah sɔkɔ, sé náhlɔ́ tɔ kɩ pɩ yályál. ");
INSERT INTO wib_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Yépi Liyel tyi kõ̀nsàhnɔ́ kwɔ́pú ànɛ̂ Farisi wɛ̃̀kɩ̀ kɔ́púlɛ, pèkè mɛ yé yõ. Vyɛ̃́nnínì wɛ́kɩ́pú ye yélɛ. Yé mɛ á kɩ nɛ léyã̂l píkínsàhnɔ́ sɔ̃́. Sé kégbɔ́ n nɛ n mɛ pallɛ, tɛ́ sé sɔkɔ táhlɔ́ n nɛ n mɛ lékyɩ̂ kègbèl ó ànɛ̂ yípyã́hnɩ̀ duke duke póllɛ. ");
INSERT INTO wib_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Sɛ̃́ ye yépi tɔlɛ. Kégbɔ́ sɔkɔ, yè n pɩ n tɛ̃ nɛ́gblɔ́lɛ, tɛ́ yé fɔkɔ táhlɔ́ mó tɔ̃ mɛ yúkúnɔ́lɛ fɔ̀kɔ̀pǐl tyi ànɛ̂ tyítúkúnìnɛ. ");
INSERT INTO wib_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Yépi Liyel tyi kõ̀nsàhnɔ́ kwɔ́pú ànɛ̂ Farisi wɛ̃̀kɩ̀ kɔ́púlɛ, pèkè mɛ yé yõ. Vyɛ̃́nnínì wɛ́kɩ́pú ye yélɛ. Yě Liyel tɛ̃ntõ̀ syínyopu léyã̂llɛ n tɔ̃ n sah n mɔ. Névye nónó-á pɩ sɔkɔ nɛ́gblɔ́lɛ Liyel yah, yě pépi tyɩ́nɔ́lɛ n koh n mɔ yípéplɔlɛ, ");
INSERT INTO wib_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ǹ tɛ́ nɛ n yo nɛ, yé tɔ-à sõ̀ mɛ yé súbí mɛ gbĩ́nɛ, yé náh náhkɩ n so n mɔ n pi pé tyɩ́ Liyel tɛ̃ntõ̀ syínyopu kònmɔnɔ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ǹtɛ yah, yé mɛ kélɛ n wɛ̃kɩ yé gblɔ̌y nɛ, Liyel tɛ̃ntõ̀ syínyopu kònmɔpu pye-á yélɛ. ");
INSERT INTO wib_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ɔ̃̀ɔ̃, yé súbí-á nɛ̂ tyah mɔ sah, yé gbah n tɛ̃ kè syi kɛ̀. ");
INSERT INTO wib_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Vyeh nɔ́pi, wáhnmɩ́rɔ́ yísyɔ́lɛ n yah dɛ́. Yé n to n pwah sɔ̃́ ní-ńkɛ̃̂ nyàhnpèkè yah sɔkɔ? ");
INSERT INTO wib_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Képah ye, ńmɔ kɩ Liyel tɛ̃ntõ̀ syínyopu, ànɛ̂ yɩ̃ pɩ̃́pú, ànɛ̂ kwɔ́pú kègblɔ tɛkɩ mɔ yé kɔ̃. Ǹtɛ yé kɩ pé túkù ko mɔ, tɛ́ kɩ túkù syɩ dahlɔ yõ, tɛ́ kɩ túkù ko yèfõhlɛ yé Liyel ní-ńtã̂n vɩ̀ sɔkɔ, tɛ́ kɩ kõ pé náh pélɛ n yĩni n kɔ̃ kwlo kwlo sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Képah sɔkɔ ye lékàh kɛ̃́pú pól kònmɔnɔ plɔ kɩ wɛ syɩkɩ yé yõ, pépi nónó-á ko mɔ à tɔkɔ Abɛlɩ kònmɔnɔ tyɩ́, ǹmɔ nɛ̂-á nɛ́gbɩ́lɛ Liyel yah, pópó à pɔ syɩ Barakɩ pídĩ́ Nsakari tyɩ́ tyɩ́, nɛ̂-á yé ko mɔ sárká súkɛ́nkɔ̃-ńsah ànɛ̂ Liyel ní-ńsah wɔ̀kɔ̀ kètǎr wrɔ́. ");
INSERT INTO wib_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Kègbɩ yõ mé kélɛ n yo yé tyɩ́, nɛ́kókè mɔ́nɔ́ nɔ́pi pól plɔ kɩ n syɩkɩ n pi kwɛy gbĩ névye yõ.» ");
INSERT INTO wib_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Yesu tɔ̃ yo nɛ ńkɛ̃́: «Yerusalɛmɩ tãn, Yerusalɛmɩ tãn, yépi nónó-á Liyel tɛ̃ntõ̀ syínyopulɛ n ko n mɔ, tɛ́ Liyel-á nónó tɛkɩ mɔ yé kɔ̃, yé pépilɛ n minki n ko dyêhlɛ, gbáhyɩ̃́ sɔ̃́ pól mɛ mé kè yah kɔ̃ nɛ, mé yé tuke n mɔ sɔ̃́-á sĩ̌n n tuke n mɔ ǹ pyelɛ ǹ kâm sõ̀ sɔkɔ, tɛ́ yé náh fɛ̃ syi? ");
INSERT INTO wib_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Kǎh pɩ sɛ̃́, Liyel kɩ ǹ náh vi yé kwil kɔ̃ pnɛ́pnɛ́, kè kɔ̃ kè kɩ pɩ kéntíkínìnɛ. ");
INSERT INTO wib_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Tɛ́ mé kélɛ n yo yé tyɩ́, yé náh tɔ̃ ńmɔ wɛ n yah n pi, fɔ́ɔ́ kɩ pɔ nɔ gbĩ́ nɛ̂-á yé kɩ n yo nɛ ńkɛ̃́, névi nɛ̂-á n pi Tɛ̃̀ ǹgbɛ̃ yĩn yõ, Liyel sãm mɔ ǹ sɔkɔ.» ");
INSERT INTO wib_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu-á wil Liyel ní-ńsah gbô sɔkɔ tɛ́ n sɔkɔ gbĩ́ nɛ̂nɛ, ǹ tõ̀ sã́hpú mɛ nɔ de ǹ tnɔ̂ à Liyel ní-ńsah gbô mɔ dùkùlɛ n sõ ǹ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ǹtɛ à mɛ pè syah nɛ, kǎh pè n yah yɔ̀ kɛ̀; kègbɩ yõ páh kélɛ n yo pé tyɩ́, ké pól-á kɩ pɔ sɔ. Dáhkɩ̀ núkú yɔ́ ńtɛ̃ náh tɔ̃ n wũ n pi ké ní-ò yõ. ");
INSERT INTO wib_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Wǎh kyɩ kɔ̃ tɛ̃ gbĩ́ nɛ̂nɛ Wólívyê yèh yɔ̃lɩ yõ, ǹ tõ̀ sã́hpú mɛ nɔ de ǹnɛ pé yahlɛ, tɛ́ à piki yah nɛ, à yo pé syah, gbĩ́ nɛ̂ se képah kɩ n pɩ n pi nɩ? Tir nɛ̂ pɩ́nɔ́ se kɩ ǹ syɩ́npɔnɔ ànɛ̂ kèkõyṍ tyɛ́nɔ́ wɛ̃kɩ n pi nɩ? ");
INSERT INTO wib_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","5","À mɛ yo pé tyɩ́ nɛ: «Yé yah, névye náhnáh kɩ pɔ ńmɔ yĩn tɔkɔ n pi pé yah yĩ́ĩ́nɛ, tɛ́ kɩ nɛ pépi-á ńmɔlɛ, nɛ̂-á Liyel nɛy yáhntɔkɔnɔlɛ. Pè kɩ névye náhnáh mɔ n pi pílkínɔ́ sɔkɔ. Ǹtɛ yépi tɛ̃̀ wɔ yé gblɔ̌ynɛ n kyɔmɩ, nɛy káh n fɛ̃ yé pilki. ");
INSERT INTO wib_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Yé kɩ mâl pɩ́nɔ́ tyɩ́ yónɔ́ noh n pi, ànɛ̂ mâl tyɩ́ dírí wɔ́nsàhnɔ́lɛ. Ǹtɛ yé káh n yɛ tíkí yé tɛ̃. Kè yɩ̃nɛ kè pɩ sɛ̃́. Ǹtɛ képah náh tɔ̃̌nɩ̀ n pɩ n pi kèkõyṍ tyɛ́nɔ́lɛ. ");
INSERT INTO wib_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Yé náh wɛ di, kwil yɔ́ kɩ pɔ yuku kwil yɔ́lɛ n fwo, tɔ̃́rɩ́ yɔ́ kɩ pɔ yuku tɔ̃́rɩ́ yɔ́lɛ n fwo. Tɛ́ kwɛkɩ ànɛ̂ sétáh syahrɩ kɩ n wɛ n pi tã̀ntã̀n náhnáh sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ǹtɛ sépi pól kɩ mɛ á kɩ nɛ kúrkì tɛ̃ gbĩ́ yɔ́nɔ́ sõ tyàhnɔ́ sɔ̃́. ");
INSERT INTO wib_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Pè kɩ yélɛ n tɛ̃ pè kɔ̃ pè kɩ n fõh, tɛ́ kɩ yélɛ n ko mɔ. Kèkõyṍ névye pól kɩ yé wɛ mɔ ńmɔ yĩnnɛ. ");
INSERT INTO wib_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Képah tɛ̃̀ sɔkɔ, névye náhnáh kɩ Liyel wɛ̃̀kɩ̀ fĩn mɔ. Pè kɩ n wil wɛ̃ náh, tɛ́ kɩ wɛ̃ dyɔlɛ n yɔ. ");
INSERT INTO wib_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Tɛ́ Liyel yĩn yõ mɩ̀nyobe kɩ wil mɔ pí, kɩ névye náhnáh mɔ pílkínɔ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Pèkè pɩ́nɔ́ kɩ yah syi, fɔ́ɔ́ tyɩ́nɔnɔ náh tɔ̃ n wɛ n pi fwɔ́ɔ névye náhnáh sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ǹtɛ nɛ̂-à ǹ tah sah à pɔ nɔ ké tyɛ́nɔ́ tyɩ́, tɛ̃̀ kɩ pwáhnmɔnɔ wɛ. ");
INSERT INTO wib_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Képah sɔkɔ, Nɩ̀vɩ̀nɩ̀ tir kɩ yo Liyel tɔ̃́rɩ́ tyɩ́ yõ kèkõyṍ pól sɔkɔ, névye pól kɔ̃ pè kɩ noh. Képah náh, kèkõyṍ kɩ pyě tyɛ.» ");
INSERT INTO wib_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Képah sɔkɔ, Yesu tɔ̃ nɛ: «Liyel tɛ̃ntõ̀ syínyo-ò Danyɛlɩ-á lésõ yɩ́kɩ́nɔ́ pɩ pɩ kwâh képékè nɛ̂ tyɩ́ yo sah, yé kɩ kè wɛ n pi Liyel ní-ńsah gbô tyah kètǎr sɔkɔ.» — Nónó-à kɩ wɛy mɛ̀nɛ n kar, pè gbah n tɛ̃ ké dùkù pɩ̃. — ");
INSERT INTO wib_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Yesu tɔ̃ yɔ̃ sɔkɔ ǹ wɛynɛ nɛ ńkɛ̃́: «Yâh képah wɛ gbĩ́ nɛ̂nɛ, nónó-à kɩ mɛ Nsyude mara sɔkɔ, pè to sɔkɔ ymɔ yõ. ");
INSERT INTO wib_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Névi nɛ̂-à kɩ mɛ gbɛ̃́ntĩ̂n yõ, tɛ̃̀ káh nɛ páh n tiki pé vyɔ́lɛ n tɔkɔ pé wɔ̀kɔ̀ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Nɛ̂-à kɩ se mó mɛ ǹ swãh sɔkɔ, tɛ̃̀ káh nɛ páh pélɛ n syɩ n yuku pé fwɔ̀mɔ̀-ǹgbɛ̃ tɔ́kɔ́-ńsah. ");
INSERT INTO wib_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Kénɛ sèpĩ̀n-à pɔ syɔ́ nónó wɛ kûrn nátãnnɛ, ànɛ̂ nónó-à mɛ yɔ̃kɩ syɔ́lɛ, kè kɩ pɩ yèwàhtàhpolɛ pé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Képah ye, yé yɩ̃nɛ yè Liyellɛ n ni nɛ tólɔ́ mɛ̀ káh n pɩ vɩrɩ gbĩ́nɛ, képah náh pɩ mɩ mɩ yòh sõlɛ. ");
INSERT INTO wib_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kè kɩ pɩ yèvyãhrɩ ǹgbɛ̃nɛ, nɛ̂ kénkɔ̃ náh wɛ yah kèkõyṍ mɔ́mɔ́nɩ̀ à pɔ syɩ kwɛy tyɩ́, ànɛ̂ nɛ̂ kénkɔ̃ náh tɔ̃ n wɛ n yah n pi póllɛ. ");
INSERT INTO wib_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Liyel-à náhkɩ sõ̀ wìlkìnɔ́ pɩ́-ńkɛ̃̂nɛ kénɛ sèpĩ̀n sɔkɔ, ǹnɩ̂ yɔ́ ńtɛ̃ yõ náh náhkɩ pɔ n wil n pi ké sɔkɔ. Ǹtɛ wǎh nónó yah wilki pɩ ǹ tyɩ́lɛ, pépi yĩnnɛ, à wìlkìnɔ́ pɩ sé sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Névi nɛ̂-à yé syah nɛ, Liyel nɛy yáhntɔkɔnɔ-á mɛ ásõ̂, képah náh pɩ wǎh mɛ yàhàh, yé káh sɛ̃ tɛ̃̀ yõ. ");
INSERT INTO wib_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Yé yah, mɩ̀nyobe kɩ pɔ wil mɔ pí. Pé túkù kɩ nɛ Liyel nɛy yáhntɔkɔnɔnɔ-á pépilɛ, túkù kɩ mó nɛ Liyel tɛ̃ntõ̀ syínyopu-á pépilɛ. Pè kɩ gbǐlgbìl tyi ǹgbnɔlɛ n pɩ, fɔ́ɔ́ kɩ n yah n kɔ̃ Liyel névye yáhnwìlkìnɔ́ ńtɛ̃ tɔ yõ yɩ́kɩ́-ńsahlɛ kàh sõ̀ fɛ̃ n pɩ n pi. ");
INSERT INTO wib_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Tyi nɔ́pi ye mé kwãh tɛ̃ yo sah yé tyɩ́ yɔ̀. ");
INSERT INTO wib_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Képah sɔkɔ, névi nɛ̂-à yé syah nɛ Névi Pídĩ́-á mɛ gbɛ̃́nnɩ sɔkɔ, yé káh nɛ yáh ǹ nyáhlɛ n sõ. Nɛ̂-à se nɛ wǎh mɛ wɔ̃̀bɩ̀ntɛ̃̀nɔ́lɛ, yé káh sɛ̃ tɛ̃̀ yõ. ");
INSERT INTO wib_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Sɔ̃́-á pũ̀ n yĩkiri yã̌l yè n wɛ, à tɔkɔ gbĩ̀ngboke tyɩ́, fɔ́ɔ́ n kyɩ n dal n mɔ gbĩ̀nyiki tyɩ́, sɛ̃́ ye Névi Pídĩ́ syɩ́npɔnɔ tɔ kɩ n wɛ n pi. ");
INSERT INTO wib_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Kwáhkókè se kɩ fɛ̃ wɔ̃bɩ ǹkyɔ̀nkyɔ̀nɩ̀ yah?» ");
INSERT INTO wib_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«Kénɛ sèpĩ̀n nɔ́pi yèvyãhrɩ-à fyɔ̀ sɔkɔ n tɛ ǹsɔ̃̀, gbĩ kɩ pɩ syìì, ńwɔ̃́ náh tɔ̃ n piki n pi, ńwɔ̃́ kèpye kɩ wil yĩ̂nyõ kɩ kwɛ, tɛ́ yĩ̂nyõ yíyìn pól kɩ yike. ");
INSERT INTO wib_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Légbĩ́nɛ, Névi Pídĩ́ syɩ́npɔnɔ kwní kɩ yõ mɔ yĩ̂nyõ. Képah tɛ̃̀nɛ, sétáh yõ yìkìnì pól névye kɩ n gbo kɩ yãm yãm tyilɛ n pɩ. Tɛ́ pè kɩ Névi Pídĩ́ wɛ à kɩ mɛ n pi ńyĩ̂rn sɔkɔ, tǎhkɩ̀ ó ǹ tɔ̂ɔ́ ànɛ̂ tɔ̃́rɩ́lɛ. ");
INSERT INTO wib_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Kèpɔ̃ ǹgbɛ̃ yɔ́ kɩ fɩ̃bɩ, tɛ́ à kɩ ǹ yĩ̂nyõ tõ̀npɩbɩ tɛkɩ mɔ ywɔ̃ ywɔ̃ pól sɔkɔ, à tɔkɔ kèkõyṍ yah mɛ̀ tyɩ́, à kyɩ sah ké yah mɛ̀ tyɩ́. Pè kɩ kyɩ névye tuke mɔ, Liyel-á nónó yah wilki. ");
INSERT INTO wib_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Yé yah sènsóké kèdùkù-á nɛ̂nɛ álɛ n wɛ̃kɩ. Yâh fyɔ̀ ké yɩ̃̀ngbã̀n wɛ sè n gboke n wil à mɩ̀snɔlɛ n pɩ gbĩ́ nɛ̂nɛ, yè n pɩ̃ nɛ ki de gbĩ́-á mɛ yúkɛy. ");
INSERT INTO wib_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Sɛ̃́ ó ye, yépi tɔ-à pópó kénɛ tyi wɛ sè tyah n pɩ gbĩ́ nɛ̂nɛ, yé pɩ̃ nɛ Névi Pídĩ́ syɩ́npɔnɔ-á mɛ yúkɛy. Wǎh kɩ pɔ sɛ̃́ yɔ̀ sɛ̃́ yɔ̀. ");
INSERT INTO wib_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Kègbɩ yõ mé kélɛ n yo yé tyɩ́, kwɛy gbĩ névye pól náh n ku n tɛ n pi, tɛ́ kénɛ tyi nɔ́pi kɩ mɛ n pɩ. ");
INSERT INTO wib_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Yĩ̂nyõ ànɛ̂ sétáh kɩ pɔ tyɛ, ǹtɛ ńmɔ wɛlɔ tɛ̃̀ wɔ náh n tyɛ n yah n pi póllɛ. ");
INSERT INTO wib_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ǹtɛ ké lésõ ànɛ̂ ké gbĩ́ tɛ̃̀ wɔlɛ, ǹnɩ̂ yɔ́ ńtɛ̃ náh sépilɛ n pnɛ. Yĩ̂nyõ tõ̀npɩbɩ náh sélɛ n pnɛ, Liyel Pídĩ́ tɔ náh sélɛ n pnɛ. Ǹnɩ̂ yɔ́ ńtɛ̃ náh sélɛ n pnɛ à wil Sú Liyel tyɩ́ sɔkɔ. Ǹmɔ ó ye n pnɛ sélɛ. ");
INSERT INTO wib_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Nɛ̂-á pɩ sɔkɔ Nowe gbĩ sɔkɔ, sɛ̃́nkɔ̃ ye kɩ n pɩ n pi Névi Pídĩ́ syɩ́npɔnɔ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Yé náh wɛ di, gbĩ́ nɛ̂-á lésõ pṹnpã́hkɩ̀ náh tɔ̃̌nɩ̀ mɛ pɩ à ninɛ kèkõyṍ pól yõ, névye lésõ mɛ n yõ, tɛ́ mɛ n wɔ, tɛ́ mɛ syɔ́lɛ n tɔkɔ, képah náh pɩ mɛ pé pyelɛ pɛbɩlɛ n kɔ̃, pópó à pɔ syɩ Nowe de sõ tyɩ́ krótó-ǹgbɛ̃ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Pè náh sõ̀ mɛ n sõ tir yɔ́ ńtɛ̃ tyɩ́ sɔkɔ, fɔ́ɔ́ à pɔ nɔ pṹnpã́hkɩ̀ pɩ sõ tyɩ́, ni kɔ̃ kè pɔ pé pól yõ. Sɛ̃́nkɔ̃ ye kɩ n pɩ n pi Névi Pídĩ́ syɩ́npɔnɔ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Díbí nɛ́pĩ̂ nímí kɩ mɛ swãh sɔkɔ, núkú kɩ tɛ̃ sɔkɔ, tɛ́ ǹ ní-ò kɩ wũ. ");
INSERT INTO wib_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Syɔ́ nɛ́pĩ̂ nímí kɩ mɛ nannɛ n nɔ, núkú kɩ tɛ̃ sɔkɔ, tɛ́ ǹ ní-ò kɩ wũ. ");
INSERT INTO wib_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Yé Tɛ̃̀ ǹgbɛ̃-á ǹ syɩ n pɔ n pi sõ nɛ̂nɛ, yé náh mɛ kè pɩ̃. Képah ye, yé káh yé dyɔ mɔ n fwɔ n tɛ̃. ");
INSERT INTO wib_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Yépi ńtɛ̃ pɩ̃ nɛ, gbóntɛ̃̀ dĩ́-à mɛ pɩ̃ gbĩ́ nɛ̂-á yɛ̃́nwó kɩ n pɔ n pi lékã̂hnɛ, à kɩ yah sõ, à náh yɛ à kɔ̃ à wɛ kwɔ n de n pi ǹ gbô sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Képah ye, yépi tɔ nɛ mɛ yé vi sah. Ǹgbǒ yé náh mɛ gbĩ́ nɛ̂ tyɩ́lɛ n sõ, légbĩ́ ye Névi Pídĩ́ kɩ ǹ syɩ n pɔ n pi dɛ́.» ");
INSERT INTO wib_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","«Tõ̀npɩ nɛ́gbɩ́ ànɛ̂ lékã́m névi nɛ̂ mɛ yõ̀tɛ̃̀ dĩ́ kɩ tɔkɔ sah ǹ tõ̀npɩbɩ tɛ́lɔ́ yõ, à kɔ̃ à kɩ yõkelɛ pélɛ n kɔ̃ ké gbĩ́ pèpɛy sɔkɔ, tɛ́ kɩ sɔkɔ kɔ́lɔ́ sɔkɔ? ");
INSERT INTO wib_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Yõ̀tɛ̃̀ dĩ́-à ǹ syɩ pɔ à wɛ à mɛ kénɛ tõ̀lɛ n pɩ ké yah yõ, tõ̀npɩ mɛ̀ tyɩ́ nɔ. ");
INSERT INTO wib_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Kègbɩ yõ mé kélɛ n yo yé tyɩ́, yõ̀tɛ̃̀ dĩ́ kɩ à pɩ ǹ gbã̀n yî pól kyɔ̀mɩ̀-òlɛ. ");
INSERT INTO wib_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ǹtɛ kàh pɩ tõ̀npɩ túkùlɛ, tɛ́ à tyah n sõ nɛ pé yõ̀tɛ̃̀ dĩ́-á mɛ mo ǹ syɩ́npɔ-ńsah, ");
INSERT INTO wib_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","tɛ́ tyah pé no tõ̀npɩbɩ tɛ́lɔ́lɛ n ko, tɛ́ n yõ tɛ́ n wɔ sètɛ̃̀nɩ̀ pɩ́púlɛ wɛ̃ tyɩ́, ");
INSERT INTO wib_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ǹ yõ̀tɛ̃̀ dĩ́ kɩ ǹ syɩ pɔ ǹ yõ dɔkɔ sõ yɔ́lɛ, ànɛ̂ wɔ̂ yɔ́ sɔkɔ, à náh mɛ nɛ̂ tyɩ́lɛ n sõ. ");
INSERT INTO wib_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","À kɩ tõ̀npɩ mɛ̀ yĩni, tɛ́ kɩ à tɛkɩ mɔ yĩ́nvǐnpɩbɩ mɛ́-ńsah sɔkɔ, ńyãh sɔkɔ-á gbní ànɛ̂ yní táhnɔ́ kɩ mɛ.» ");
INSERT INTO wib_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yesu tɔ̃ yo ǹ tõ̀ sã́hpú tyɩ́ nɛ: «Névi Pídĩ́ syɩ n pɔ gbĩ́nɛ, Liyel tɔ̃́rɩ́ kɩ fɛ̃ tɔkɔ sãh syɔ́npì nɛ́pĩ̂ gbãm yísyɔ́ sèmìrkìlɛ, nónó-á pé fɔ̀tnɔ̀nɔ́ tɔkɔ sɔkɔ pɛ yòhnɩ̀-ǹsah. ");
INSERT INTO wib_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Syɔ́npì nɔ́pi sɔkɔ, nɛ́pĩ̂ kwâl sõ̀ mɛ lékã́m kɛ̃́púlɛ, tɛ́ kwlɔ́ mó mɛ lékã́mpulɛ. ");
INSERT INTO wib_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Nónó-á lékã́m kɛ̃́púlɛ, pépi-á sõ̀ pé fɔ̀tnɔ̀nɔ́ tɔkɔ n sɔkɔ, pè náh nɩrɩ wãn tɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ǹtɛ lékã́mpu nɔ́pi wɔ mó pé fɔ̀tnɔ̀nɔ́ tɔkɔ, tɛ́ nɩrɩ mɔ sɔkɔ sonɔ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Pɛ-á mo pɔ́-ńsah, dɔy mɩ pé sɔkɔ, pè dɔ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Lénɩ wérrlɛ, yĩ́npɔ̃́ yɔ́ n dɔkɔ nɛ ńkɛ̃́, pɛ-á oo, pè wil à yohnɩ. ");
INSERT INTO wib_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Képah tɛ̃̀nɛ, syɔ́npì nɔ́pi pól dɔ yuku, tɛ́ yah dah mɔ pé fɔ̀tnɔ̀nɔ́ tyɩ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Nónó-á lékã́m kɛ̃́púlɛ, pépi mɛ lékã́mpu nɔ́pi syah nɛ, pè yɩ̃ pé kɔ̃ nɩrɩlɛ, ńkɛ̃́ pé fɔ̀tnɔ̀nɔ́-á mɛ tɛ̃ syi n ni pé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Pè mɛ yo pé tyɩ́ nɛ, sè náh fɛ̃ n yɩ̃nɛ n pi pépi tyɩ́nɔlɛ tɛ́ pé tɔ̃ n yɩ̃ n kɔ̃ n pi. Ńkɛ̃́ pè kyɩ n yah dwe yã̀mpu tyɩ́ pè mɔ pé tyɩ́nɔ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Pǎh sɔkɔ yáhndwe-ńsah, pɛ pɔ de. Syɔ́npì nónó-á sõ̀ mɛ pé vi sah, pépi mɛ de ǹnɛ fúr yõke yṍ-ńsah wɔ̀kɔ̀ sɔkɔ, tɛ́ pè mɛ wùkah vike. ");
INSERT INTO wib_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Syɔ́npì nɔ́pi tɛ́lɔ́-á pópó pé syɩ pɔ, pè pɔ wùkahlɛ n mɩ tɛ́ mɛ yo mɔ tũ nɛ ńkɛ̃́, pé yõ̀tɛ̃̀, pé yõ̀tɛ̃̀, à yɩkɩ mɔ pé kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ǹtɛ à mɛ yo pé tyɩ́ nɛ, kègbɩ yõ páh kélɛ n yo pé tyɩ́, pé náh pélɛ n pnɛ. ");
INSERT INTO wib_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Képah ye, yépi káh yé dyɔ mɔ n fwɔ n tɛ̃ dɛ́. Yé náh se yɔ́ lésõ ànɛ̂ ké gbĩ́nɛ n pnɛ tɛ́.» ");
INSERT INTO wib_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","«Liyel tɔ̃́rɩ́-á mɛ sèmìrkì nɛ̂ kètɔ̀lɛ, kè wɛ yɔ̀: Dĩ́ yɔ́ lésõ n sɔkɔ kɔ́lɔ́ sɔkɔ, tɛ́ ǹ tõ̀npɩbɩ ye pɔ ǹ tahrɩlɛ pè kɔ̃ sah, ");
INSERT INTO wib_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","à yɩ̃nɛ pé nɛ́núkù núkú pól-á fɛ̃ nɛ̂ pɩ n pi. À talã pɔ́ plɔ́ kwlɔ́lɛ ǹnɩ̂ kɔ̃, tɛ́ nínɔ́lɛ ǹnɩ̂ kɔ̃, tɛ́ mɛ núkúlɛ ǹnɩ̂ kɔ̃. Képah náh, tɛ́ sɔkɔ ǹ kɔ́lɔ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Nɛ̂-á wɛ talã pɔ́ plɔ́ kwlɔ́lɛ, ǹmɔ núkú kyɩ ǹ gbõ̀ vi ǹ tyɩ́lɛ à kwlɔ́ yísyɔ́ wɛ dohnɩ sé yõ. ");
INSERT INTO wib_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Sɛ̃́-ó ye nɛ̂-á wɛ talã pɔ́ plɔ́ nínɔ́lɛ, ǹ tɔ mɛ nínɔ́ wɛ dohnɩ sé yõ. ");
INSERT INTO wib_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ǹtɛ nɛ̂-á wɛ talã pɔ́ pɔ́ núkúlɛ, ǹmɔ mɛ sɔkɔ kyɩ swɔ tũ à ǹ yõ̀tɛ̃̀ dĩ́ pɔ́ wɔ̃bɩ. ");
INSERT INTO wib_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Ké di-á mo náhnáh, pé yõ̀tɛ̃̀ dĩ́ ǹ syɩ pɔ. Wǎh pɔ, à pè ye nɛ pè pɔ pé tahrɩ tyɩ́ dùkù yo pé noh. ");
INSERT INTO wib_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Képah tɛ̃̀nɛ, nɛ̂-á sõ̀ wɛ talã pɔ́ plɔ́ kwlɔ́lɛ, ǹmɔ mɛ ǹ tyɩ́ tɔkɔ nɔ de ǹ yõ̀tɛ̃̀ dĩ́nɛ tɛ́ kwlɔ́ yísyɔ́ tɔ́lɛ à wɛ̃kɩ, tɛ́ yo ǹ tyɩ́ nɛ, pé yõ̀tɛ̃̀, talã pɔ́ plɔ́ kwlɔ́-á sõ̀ à pé kɔ̃ sah, ǹtɛ à yah, páh kwlɔ́ yísyɔ́ wɛ dohnɩ sé yõ ǹ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ǹ yõ̀tɛ̃̀ dĩ́ mɛ yo ǹ tyɩ́ nɛ, kǎh plɛ, tõ̀npɩ pèpɛy ànɛ̂ nɛ́gbɩ́-á ǹnɛ. Wǎh fyɔ̀ pɩ nɛ́gbɩ́lɛ tir tyɩ̃́ɩ̃ sɔkɔ, páh kɩ tyí-ǹgbnɔ dahbɩ ǹ gbõ̀. À pɔ pé nɩ̀vɩ̀nɩ̀nɛ n pɩ wɛ̃ tyɩ́. / Ǹ yõ̀tɛ̃̀ dĩ́ mɛ yo ǹ tyɩ́ nɛ, kǎh plɛ, tõ̀npɩ pèpɛy-á ǹnɛ nɛ̂-á tyilɛ n pɩ sé wã̀l yõ. Wǎh fyɔ̀ tir tyɩ̃́ɩ̃ pɩ ké wɛ̃̀kɩ̀ yõ, páh kɩ tyí-ǹgbnɔ dahbɩ ǹ gbõ̀. À pɔ pé nɩ̀vɩ̀nɩ̀nɛ n pɩ wɛ̃ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Nɛ̂-á sõ̀ wɛ talã pɔ́ plɔ́ nínɔ́lɛ, ǹmɔ tɔ mɛ ǹ tyɩ́ tɔkɔ nɔ de ǹ yõ̀tɛ̃̀ dĩ́nɛ tɛ́ yo ǹ tyɩ́ nɛ, pé yõ̀tɛ̃̀, talã pɔ́ plɔ́ nínɔ́-á sõ̀ à pé kɔ̃ sah, ǹtɛ à yah, páh nínɔ́ yísyɔ́ wɛ dohnɩ sé yõ ǹ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ǹ yõ̀tɛ̃̀ dĩ́ mɛ yo ǹ tyɩ́ nɛ, kǎh plɛ, tõ̀npɩ pèpɛy ànɛ̂ nɛ́gbɩ́-á ǹnɛ. Wǎh fyɔ̀ pɩ nɛ́gbɩ́lɛ tir tyɩ̃́ɩ̃ sɔkɔ, páh kɩ tyí-ǹgbnɔ dahbɩ ǹ gbõ̀. À pɔ pé nɩ̀vɩ̀nɩ̀nɛ n pɩ wɛ̃ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Képah náh, nɛ̂-á sõ̀ wɛ talã pɔ́ pɔ́ núkúlɛ, ǹmɔ-á nɔ de, à ǹ yõ̀tɛ̃̀ dĩ́ syah nɛ ńkɛ̃́, pé yõ̀tɛ̃̀, páh pɩ̃ nɛ ńkɛ̃́ ǹ tõ̀-á tah. À náh sèmukɔ nɛ̂ duku mɔ, ǎ kè tɔkɔ. À náh nɛ̂ mir mɔ, ǎ kè kõ. ");
INSERT INTO wib_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Képah-á tíkí pé tɛ̃, pé mɛ kyɩ ǹ pɔ́ wɔ̃bɩ sétáh sɔkɔ. Kǎh yɔ̀, à tɔkɔ ǹ pɔ́lɛ. ");
INSERT INTO wib_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ǹ yõ̀tɛ̃̀ dĩ́ mɛ yo ǹ tyɩ́ nɛ, tõ̀npɩ nɛ́túkù, gbãndal névi-á ǹnɛ. Wǎh sõ̀ pɩ̃ nɛ ńkɛ̃́, pé náh sèmukɔ nɛ̂ duku mɔ, pě kè tɔkɔ, pé náh nɛ̂ mir mɔ, pě kè kõ. ");
INSERT INTO wib_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Kǎh pɩ sɛ̃́, wǎh náhkɩ mó sõ̀ mɛ kyɩ pé pɔ́ dah mɔ sah pɔ́ sàh-ǹsah wɔ̀kɔ̀ sɔkɔ kɛ̀. Páh pé syɩ pɔ sɔ̃́ yɔ̀, páh náhkɩ mó sè wɛ wilki dòhnɩ̀nɔ́lɛ sé yõ kɛ̀. ");
INSERT INTO wib_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ńkɛ̃́ pè ǹ tyɩ́ mɛ̀ tɛ̃ syi ǹ tyɩ́, pè kélɛ talã pɔ́ plɔ́ gbãm nɛ́tɛ̃̂ kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Pè kó wɛ nɩ, névi nɛ̂ tyɩ́ kwâh-á mɛ, dòhnɩ̀nɔ́-á kɩ n pɩ ǹmɔ tyɩ́ yõ yrɔ̌yrɔ̌. Tɛ́ névi nɛ̂ tyɩ́ kwâh náh mɛ, kwéy nɛ̂ ńtɛ̃-á mɛ ǹ tyɩ́, kǎh kɩ tɛ̃ syi ǹ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Yõre kɛ̃́ tõ̀npɩ mɛ̀ tɛ̃̀ wɔlɛ, ńkɛ̃́ pè à wilki mɔ kégbɔ́ fɛ̃́ntũ̂ sɔkɔ, ńyãh sɔkɔ-á gbní ànɛ̂ yní táhnɔ́ kɩ mɛ.» ");
INSERT INTO wib_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","«Névi Pídĩ́-à ǹ syɩ pɔ ǹ tɔ̃́rɩ́ sɔkɔ ànɛ̂ yĩ̂nyõ tõ̀npɩbɩ póllɛ gbĩ́ nɛ̂nɛ, à kɩ kɔ̃ tɛ̃ ǹ tɔ̃́rɩ́ kǒ yõ. ");
INSERT INTO wib_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Kwlo kwlo pól névye kɩ pɔ tuke mɔ ǹ yah sɔkɔ. Tɛ́ à kɩ névye wah wilki wɛ̃ sɔkɔ, sɔ̃́-á yípɛ́nfɛ̃ n wah n wilki képyɛ́nɩ̀ ànɛ̂ perlɛ wɛ̃ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","À kɩ nɛ́gblɔ́ sah ǹ gbõ̀yõ̀ sõ̀lɛ, tɛ́ kɩ nɛ́pêl sah ǹ gbɛ̃̀yɩ̃̀nɛ̀ sõ̀lɛ. ");
INSERT INTO wib_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Képah sɔkɔ, nónó-à kɩ mɛ ǹ gbõ̀yõ̀ sõ̀lɛ, à kɩ yo pé tyɩ́ nɛ: ‹Ń Sú Liyel-á sãm mɔ yépi nónó sɔkɔ, tɛ́ tɔ̃́rɩ́ nɛ̂ yah sah yé kɔ̃ kèkõyṍ mɔ gbĩ́ dùkùlɛ, yé pɔ ké nɔlɩlɛ n yõ. ");
INSERT INTO wib_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Yé náh wɛ di, kwɛkɩ-á sõ̀ ń tɛ̃, yé yõkelɛ ń kɔ̃ mé yõ. Níkì-à sõ̀ ń tɛ̃, yé ninɛ ń kɔ̃ mé wɔ. Máh sõ̀ mɛ nɛ́pɔ̂lɛ, yé ń kɔ̃ mé twah yé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Máh sõ̀ mɛ flɔ kɛ̃́nɛ, yé flɔlɛ ń kɔ̃ mé mɔ. Máh sõ̀ mɛ n yɔ, yé yah dah mɔ ń tyɩ́ sɔkɔ. Máh sõ̀ mɛ wɔ̀kɔ̀npèkè sɔkɔ, yé pɔ yah ń tyɩ́.› ");
INSERT INTO wib_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Képah sɔkɔ, nɛ́gblɔ́ nɔ́pi kɩ à piki yah nɛ, Tɛ̃̀ ǹgbɛ̃, gbĩ́ nɛ̂ se pé wɛ ǹnɛ kwɛkɩ sɔkɔ, tɛ́ à kɔ̃ à yõ nɩ? Ànɛ̂ gbĩ́ nɛ̂ se pé wɛ ǹnɛ níkì sɔkɔ, tɛ́ à kɔ̃ à wɔ nɩ? ");
INSERT INTO wib_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Gbĩ́ nɛ̂ se pé wɛ ǹnɛ nɛ́pɔ̂lɛ, tɛ́ à kɔ̃ à twah pé tyɩ́ nɩ? Ànɛ̂ gbĩ́ nɛ̂ se pé wɛ ǹnɛ flɔ kɛ̃́nɛ, tɛ́ flɔlɛ à kɔ̃ à mɔ nɩ? ");
INSERT INTO wib_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Gbĩ́ nɛ̂ se pé wɛ ǹnɛ à mɛ n yɔ, képah náh pɩ à mɛ wɔ̀kɔ̀npèkè sɔkɔ, tɛ́ pɔ yah ǹ tyɩ́ nɩ? ");
INSERT INTO wib_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Képah sɔkɔ, yõ̀tɛ̃̀ dĩ́ kɩ yo pé tyɩ́ nɛ: ‹Kègbɩ yõ mé kélɛ n yo yé tyɩ́, ń yṹnpyé nónó-á yɔ̀ kɛ̀, yáh ńkɛ̃́nɛ sɛ̃́nknɔlɛ n pɩ pé sɔkɔ tyɩ̃̂tyɩ̃̂ nónó fyé tyɩ́, ńmɔ tyɩ́ ye ńkɛ̃́nɛ yè n nɛ n pɩ sélɛ.› ");
INSERT INTO wib_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Képah náh, nónó-à kɩ mɛ ǹ gbɛ̃̀yɩ̃̀nɛ̀ sõ̀lɛ à kɩ yo pépi tyɩ́ nɛ: ‹Yé to ń tnɔ̂, yépi nónó tyɩ́-á yɩkɩ. Yé nɛ n yuku ní-ńkɛ̃̂ nyàhnpèkè sɔkɔ, képah nɛ̂-á mɛ mɔ́nsàhnɔ́lɛ sétã̀n ànɛ̂ sé yõ̀tɛ̃̀ yĩnnɛ. ");
INSERT INTO wib_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Yé náh wɛ di, kwɛkɩ-á sõ̀ ń tɛ̃, yé náh ń kɔ̃ mé yõ. Níkì-á sõ̀ ń tɛ̃, yé náh ń kɔ̃ mé wɔ. ");
INSERT INTO wib_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Mé sõ̀ mɛ nɛ́pɔ̂lɛ, tɛ́ yé náh fɛ̃ syi ń kɔ̃ mé twah yé tyɩ́. Mé sõ̀ mɛ flɔ kɛ̃́nɛ, tɛ́ yé náh flɔlɛ ń kɔ̃ mé mɔ. Mé sõ̀ mɛ n yɔ, tɛ́ mɛ wɔ̀kɔ̀npèkè sɔkɔ, tɛ́ yé náh pɔ yah ń tyɩ́.› ");
INSERT INTO wib_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Pépi tɔ kɩ à piki yah nɛ, Tɛ̃̀ ǹgbɛ̃, gbĩ́ nɛ̂ se pé wɛ ǹnɛ kwɛkɩ sɔkɔ, képah náh pɩ níkì sɔkɔ, képah náh pɩ nɛ́pɔ̂lɛ, képah náh pɩ flɔ kɛ̃́nɛ, képah náh pɩ mɛ n yɔ, képah náh pɩ mɛ wɔ̀kɔ̀npèkè sɔkɔ, tɛ́ pé náh à yohnɩ mɔ nɩ? ");
INSERT INTO wib_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Képah sɔkɔ, à kɩ yo pé tyɩ́ nɛ: ‹Kègbɩ yõ mé kélɛ n yo yé tyɩ́, ń yṹnpyé nónó-á yɔ̀ kɛ̀, yáh ńkɛ̃́nɛ n yahle sɛ̃́nknɔ pɩ́nɔ́lɛ pé sɔkɔ tyɩ̃̂tyɩ̃̂ nónó fyé tyɩ́, ńmɔ tyɩ́ ye ńkɛ̃́nɛ yè n yahle pɩ́nɔ́lɛ sélɛ.› ");
INSERT INTO wib_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Tyɛ́-ńkɛ̃̂ yèvyãhrɩ sɔkɔ ye nɛ́túkúnì nɔ́pi kɩ kyɩ n de n pi, tɛ́ nɛ́gblɔ́ nɔ́pi wɔ kɩ kyɩ tyɛ́-ńkɛ̃̂ min wɛ. ");
INSERT INTO wib_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesu-á tyi nɔ́pi pól yah yo tɛ gbĩ́ nɛ̂nɛ, à yo ǹ tõ̀ sã́hpú tyɩ́ nɛ: ");
INSERT INTO wib_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Yé pɩ̃ nɛ ńkɛ̃́ sèpĩ̀n nínì-á wũ, tɛ́ Pakɩ syáh kɩ syah. Névi Pídĩ́ kɩ tɛ̃ pè kɔ̃ pè kɩ à syɩ dahnɩ yõ.» ");
INSERT INTO wib_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Légbĩ́nɛ, sárká syínwìlkìpu yõ̀tãm ànɛ̂ kwil yèwàhnɩ̀ wɛ̃ tuke mɔ sárká syínwìlkìpu yõ̀tɛ̃̀ ǹgbɛ̃ tĩ̀nnɛ, nɛ̂-á pè n ye Kayifilɛ. ");
INSERT INTO wib_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Tɛ́ yo sah núkú yõ nɛ pé ye Yesu tɛ̃ lékã́mkãm sɔkɔ, pé mó à ko mɔ. ");
INSERT INTO wib_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Pè sõ̀ mɛ yo tũ wɛ̃ tyɩ́ tɔlɛ nɛ, tir mɛ̀ náh yɩ̃nɛ kè pɩ syáh syáhnɔ́ sèpĩ̀n sɔkɔ dɛ́. Páh kɩ képah pɩ, névye-á kɩ tyah fɛ̃kɩ. ");
INSERT INTO wib_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Sõ yɔ́lɛ, Yesu lésõ mɛ tótɛ̃ dĩ́ Simo gbô, Betani kwil sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Wǎh mɛ yõke yṍnɔ́ sɔkɔ gbĩ́ nɛ̂nɛ, sê yɔ́ mɛ nɔ de ǹ tnɔ̂ nɩrɩ so pèpɛy yɔ́lɛ ǹ tyɩ́ làsèkwěl dɛ́nkɔ́kɔ̀lɛ ké sɔkɔ. Képah tɛ̃̀nɛ, tɛ́ làsèkwěl mɛ̀ mɔ Yesu yõ yõ. ");
INSERT INTO wib_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Yesu tõ̀ sã́hpú-á képah tɛ̃̀ wɛ sɛ̃́, pé fɔkɔ vyãh. Pè nɛ kwâh nɛ̂ se pɩ tɛ́ à làsèkwěl mɛ̀ yɩkɩ sɛ̃́ yɔ̀ nɩ? ");
INSERT INTO wib_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Kǎh náhkɩ sõ̀ fɛ̃ yãm dántǎhlɛ, à ké pɔ́ dibi yãm tãn kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesu-á képah wɛ sɛ̃́, à mɛ yo pé tyɩ́ nɛ: «Sɔ̃́ pɩ tɛ́ yé pi mɛ̀ yahlɛ n vyãh sɛ̃́? Tyípépɛ̌y ye à pɩ ńmɔ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Yé yah, yãm tãn kɩ mɛ yé wrɔ́ sɔkɔ gbĩ́mɛgbĩ́. Ǹtɛ ńmɔ wɔ náh kɩ mɛ n pi yé wrɔ́ sɔkɔ gbĩ́mɛgbĩ́. ");
INSERT INTO wib_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Nɛ̂-á pi mɛ̀ pɩ yɔ̀, ńmɔ lékó yɩ̃ sõ yĩn ye à pɩ sah kélɛ. ");
INSERT INTO wib_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Kègbɩ yõ mé kélɛ n yo yé tyɩ́, kèkõyṍ pól sɔkɔ, Nɩ̀vɩ̀nɩ̀ tir mɛ̀-à n yo fɩ̃́ nɛ̂ sɔkɔ, pi mɛ̀ tyípɩ́kɩ̀ mɛ̀ tɔ kɩ yo, névye dyɔ kɔ̃ kè kɩ n kwnɛ ǹ tyɩ́lɛ.» ");
INSERT INTO wib_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Yesu tõ̀ sã́hpú nɛ́pĩ̂ gbɔ̃nimí sɔkɔ, nɛ̂-á pè n ye Nsyudasɩ Yisikariyɔtɩlɛ, ǹmɔ mɛ kyɩ wil sárká syínwìlkìpu yõ̀tãm tyɩ́, ");
INSERT INTO wib_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","tɛ́ pè syah nɛ, pè se kɩ pé kɔ̃ kwâh nɛ̂nɛ pé mó kè pɩ pè kɔ̃ pè Yesu wɛ tɛ̃ nɩ? Pè mɛ pɔ́ plɔ́ yõgbãmnɛ à kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","À tɔkɔ légbĩ́ tyɩ́, à tyah n yah n kɔ̃ wǎh nɛ pɩ sɔ̃́ tɛ́ pè Yesu wɛ n tɛ̃ n pi. ");
INSERT INTO wib_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Kɔ́kɔ́nɔ́ kã̂n búrn syáh tyah sõlɛ, Yesu tõ̀ sã́hpú pɔ à piki yah nɛ, ńyãh sɔkɔ se à mɛ ké tyɩ́ nɛ pé kyɩ Pakɩ syáh yõke pɩ ǹ tyɩ́ nɩ? ");
INSERT INTO wib_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","À mɛ yo pé tyɩ́ nɛ: «Yé kyɩ n yo yã̀hnkõ tyɩ́ kwil sɔkɔ nɛ, kwɔ́-ò dĩ́-á yo nɛ ńkɛ̃́ pé gbĩ-á mɛ sɛ n tɛ, ńkɛ̃́ ǹmɔ tĩ̀n-á péwɔ ànɛ̂ pé tõ̀ sã́hpú kɩ pɔ n yõ n pi Pakɩ syáh yõkelɛ.» ");
INSERT INTO wib_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Wǎh kè yo sɔ̃́ ǹ tõ̀ sã́hpú tyɩ́, pè mɛ sɔkɔ ǹ yóré yõ, à kyɩ yõke mɛ̀ pɩ. ");
INSERT INTO wib_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Lékã̂h-á pɔ mɔ, ǹmɔ ànɛ̂ ǹ tõ̀ sã́hpú nɛ́pĩ̂ gbɔ̃nimí mɛ kɔ̃ tɛ̃ yõke sõ̀. ");
INSERT INTO wib_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Tɛ́ pǎh mɛ yṍnɔ́ sɔkɔ, à yo pé tyɩ́ nɛ: «Kègbɩ yõ mé kélɛ n yo yé tyɩ́, yé sɔkɔ yɔ́ kɩ pɩ pè kɔ̃ pè kɩ ń tɛ̃ n pi.» ");
INSERT INTO wib_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ǹ tõ̀ sã́hpú-á képah noh, pé yey kwɔ kègbɩlɛ. Képah tɛ̃̀nɛ, nɛ̂ mɛ̀ nɛ̂ mɛ̀, tɛ̃̌ à piki n yah nɛ, Tɛ̃̀ ǹgbɛ̃, péwɔ se à n ye nɩ? ");
INSERT INTO wib_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","À mɛ yo pé tyɩ́ nɛ: «Nɛ̂-á mɛ n di ńmɔlɛ dú núkú sɔkɔ yɔ̀, tɛ̃̀ wɔ ye kɩ pɩ pè kɔ̃ pè kɩ ń tɛ̃ n pi. ");
INSERT INTO wib_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Névi Pídĩ́ kɩ n ku n pi à yɩ̃nɛ kǎh wãrkɩ sah Liyel wɛy sɛ́bɛ́y sɔkɔ sɔ̃́ ǹ tyɩ́ sɔkɔ. Ǹtɛ névi nɛ̂-á kɩ pɩ pè kɔ̃ pè kɩ à tɛ̃ n pi, pèkè kɩ pɩ tɛ̃̀ tyɩ́lɛ. Tɛ̃̀-à sõ̀ mɛ dúbí-ńkɛ̃̂nɛ, képah náhkɩ fṍnfṍ ǹnɛ.» ");
INSERT INTO wib_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Nsyudasɩ nɛ̂-á sõ̀ mɛ ké tyɩ́ nɛ pé pɩ pè kɔ̃ pè à tɛ̃, ǹ tɔ mɛ à syah nɛ, kwɔ́-ò dĩ́, péwɔ se à n ye nɩ? À mɛ yo ǹ tyɩ́ nɛ: «Áwɔ ye yo kélɛ.» ");
INSERT INTO wib_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Tɛ́ pǎh mɛ yṍnɔ́ sɔkɔ, Yesu búrn tɔkɔ tɛ́ wɛkɩ Liyel tyɩ́, tɛ́ kè kwɔkɩ à ǹ tõ̀ sã́hpúlɛ n kɔ̃, tɛ́ yo pé tyɩ́ nɛ: «Yé syi n tah kélɛ. Ńyɔlɛ, ńmɔ wil ye.» ");
INSERT INTO wib_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Képah náh, à tɔ̃ wóh tɔkɔ dìvɛ̃nɛ ké sɔkɔ tɛ́ wɛkɩ Liyel tyɩ́, tɛ́ kélɛ pè kɔ̃ tɛ́ yo pé tyɩ́ nɛ: «Yé póllɛ, yé kè wɔ. ");
INSERT INTO wib_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Yé náh wɛ di, ńyɔlɛ, ńmɔ tṍ ye, nɛ̂-á kɩ névye yégbékè kwrɔ mɔ ànɛ̂ Liyellɛ. Kè kɩ n kwɛ n pi nɛ́kwĩ́nkí yĩnnɛ, kɩ pé tyípêl yɔ̃ mɔ. ");
INSERT INTO wib_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Mé kélɛ n yo yé tyɩ́, à tɔkɔ núkúnúkú tyɩ́, mé náh tɔ̃ dìvɛ̃ wɔ n yah n pi, pópó kɩ pɔ nɔ sõ nɛ̂-á mé kɩ tɔ̃ dìvɛ̃ sã́n yɔ́ wɔ yélɛ ń Sú Liyel tɔ̃́rɩ́ sɔkɔ.» ");
INSERT INTO wib_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Képah náh, pè syáh yɩ̀ gbɩ, tɛ́ wil à n yuku Wólívyê yèh yɔ̃lɩ yõ. ");
INSERT INTO wib_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Képah sɔkɔ, Yesu yo ǹ tõ̀ sã́hpú tyɩ́ nɛ: «Kwɛy lékã̂h mɛ̀ ńtɛ̃ ólɛ, ńmɔ tyɩ́ kɩ yé pól kɔ̃ yé kɩ yal mɔ ń sõ̀ tɛ̃́nɔ́lɛ. Yé náh wɛ di, kè mɛ wã́rkɩ́nsàhnɔ́lɛ Liyel wɛy sɛ́bɛ́y sɔkɔ nɛ: ‹Mé kɩ yípɛ́nfɛ̃ ko mɔ, tɛ́ képyɛ́nɩ̀ tũ pól kɩ karkɩ.» ");
INSERT INTO wib_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Yesu tɔ̃ nɛ: «Ǹtɛ ń lékó yílkínmɔntɛnɔ náh, mé kɩ mɔ yé yahlɛ Kalile mara sɔkɔ.» ");
INSERT INTO wib_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Képah tɛ̃̀nɛ, Pyɛrɩ mɛ yo ǹ tyɩ́ nɛ, no tɛ́lɔ́ pól-à kɩ sɔ̃́ yal mɔ ǹ sõ̀ tɛ̃́nɔ́lɛ, péwɔ tɛ̃̀ wɔ náh n yal n mɔ n pi póllɛ. ");
INSERT INTO wib_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesu mɛ yo ǹ tyɩ́ nɛ: «Kègbɩ yõ mé kélɛ n yo á tyɩ́, kwɛy lékã̂h mɛ̀ ńtɛ̃ sɔkɔ, sénpɛ-à kɩ pópó n gbo, á kɩ mɛ á vyãh kɔ̃lɩ tɛ kɛ tɔ̃́nɔ́ nɛ á náh ńmɔ pɩ̃.» ");
INSERT INTO wib_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pyɛrɩ mɛ yo ǹ tyɩ́ nɛ, kàh kɩ sɔ̃́ nɔ pé kúnɔ́ tyɩ́ ǹnɛ wɛ̃ tyɩ́, pé náh pé vyãh kɔ̃lɩ yah n pi póllɛ nɛ pé náh à pɩ̃. Yesu tõ̀ sã́hpú tɛ́lɔ́ tɔ mɛ képah ó yo. ");
INSERT INTO wib_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Képah sɔkɔ, Yesu ànɛ̂ ǹ tõ̀ sã́hpú kyɩ yĩni tɛ̃ fɩ̃́ yɔ́ sɔkɔ, pè n ye Kɛtɩsemanɩnɛ. À mɛ yo ǹ tõ̀ sã́hpú tyɩ́ nɛ, pè kɔ̃ tɛ̃ ásõ̂ pé kyɩ Liyel ni n pɔ yàhàh. ");
INSERT INTO wib_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Wǎh n sɔkɔ, à Pyɛrɩ ànɛ̂ Nsebede dĩ́npì nɛ́pĩ̂ nímí tɛ̃ sɔkɔ. Yèkwɔrɩ ànɛ̂ tíkí képékè sõ̀ mɛ tyah n mɩ ǹ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Kǎh pɩ sɛ̃́, à mɛ yo pé tyɩ́ nɛ: «Yèkwɔrɩ mɛ ń sɔkɔ, mɛ n pɩ ń ko ko tɛ̃̀nɛ. Yé tɛ̃ ásõ̂, yépi tɔ káh yé dyɔ mɔ n fwɔ n tɛ̃, sɔ̃́-á ńmɔ náh mɛ ń dyɔ mɔ fwɔ tɛ̃.» ");
INSERT INTO wib_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Tɛ́ mɛ yuku yahlɛ kwéy à kyɩ kɔ kwĩnki ǹ yah di sétáh, à Liyellɛ n ni nɛ ńkɛ̃́: «Ńmɔ Sú, kàh kɩ fɛ̃ n pɩ n pi, yèvyãhrɩ mɛ̀ gbɛ mɔ ńmɔlɛ. Ǹtɛ mé náh nɛ á kè pɩ ńmɔ-á mɛ ké tyɩ́ sɔ̃́ dɛ́, kè pɩ áwɔ-á mɛ ké tyɩ́ sɔ̃́.» ");
INSERT INTO wib_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Wǎh ǹ syɩ pɔ ǹ tõ̀ sã́hpú nɛ́pĩ̂ tɔ̃́mɩ́ nɔ́pi tnɔ̂, à pɔ pè wɛ pè mɛ n dɔ. À mɛ yo Pyɛrɩ tyɩ́ nɛ: «Yé kègbɩ yõ, yé náh tɛ̃ wɛ lɛ́rɩ́ núkú ńtɛ̃ fyé pɩ yáhnɔ́ sɔkɔ ńmɔlɛ kɛ̀? ");
INSERT INTO wib_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Yé káh yé dyɔ mɔ n fwɔ n tɛ̃. Yé nírílɛ n pɩ yè káh n pɔ tɔ̃̀nmɔnɔ fɛ̃ n syi. Tyípéplɔ sõnɔ n nɛ n mɛ névi sɔkɔ, tɛ́ sé tɛ̃́nwɛnpɩnɔ tǎhkɩ̀ náh n wɛ ǹ sɔkɔ.» ");
INSERT INTO wib_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Wǎh képah yo, à tɔ̃ gbɛ mɔ pélɛ kɛ ní-òlɛ à kyɩ Liyellɛ n ni nɛ ńkɛ̃́: «Ńmɔ Sú, ń yõ-à kɩ fɛ̃ n wil n pi ńkɛ̃̂nɛ yèvyãhrɩ mɛ̀ sɔkɔ, áwɔ-á mɛ nɛ̂ tyɩ́, képah pɩ.» ");
INSERT INTO wib_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Wǎh tɔ̃ ǹ syɩ pɔ, à pɔ pè wɛ pè tɔ̃ mɛ n dɔ. Dɔy sõ̀ mɛ tɛ̃ wɛ pé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","À tɔ̃ yal pé tnɔ̂ à gbɛ mɔ kyɩ Liyel ni kɛ tɔ̃́-òlɛ gbro tãn tyɩ́ kɔ̃lɛ. ");
INSERT INTO wib_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Képah náh, à ǹ syɩ pɔ pé tnɔ̂, tɛ́ yo pé tyɩ́ nɛ: «Yé mɛ dɔy sɔkɔ sɛ̃́ mɛ yélɛ n mɩ kɛ̀? Névi Pídĩ́ tɛ̃ n dahbɩ gbĩ́ wɛ nɔ tyípêl pɩ́pú gbõ̀ yɔ̀. ");
INSERT INTO wib_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Yé yuku à sɔkɔ. Névi nɛ̂-á kɩ ń dahbɩ n pi pé gbõ̀, à wɛ n de yɔ̀.» ");
INSERT INTO wib_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesu mɛ képah yónɔ́ sɔkɔ, tɛ́ Nsyudasɩ nɛ̂-á ǹ tõ̀ sã́hpú nɛ́pĩ̂ gbɔ̃nimí sɔkɔ yɔ́lɛ, ǹmɔ yĩn nɛ́kwĩ́nkí yísyɔ́ yah pè pɔ de kèkîrn ànɛ̂ ńsninɛ pé tyɩ́. Sárká syínwìlkìpu yõ̀tãm ànɛ̂ kwil yèwàhnɩ̀ ye sõ̀ tɛkɩ mɔ pélɛ. ");
INSERT INTO wib_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Tɛ́ Nsyudasɩ nɛ̂-á sõ̀ n dahbɩ n pi Yesulɛ pé gbõ̀, à sõ̀ mɛ pɩ dùkù yɔ́lɛ pè wɛ̃kɩ sah. À nɛ páh kɩ wɛkɩ névi nɛ̂ tyɩ́ tɛ́ à pɔrɩ tɛ̃, ǹmɔ-á. Ńkɛ̃́ pè à tɛ̃. ");
INSERT INTO wib_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Tɛ́ núkú nɔ de Yesulɛ tɛ́ nɛ, kwɔ́-ò dĩ́, páh n wɛkɩ ǹ tyɩ́! Tɛ́ à pɔrɩ tɛ̃. ");
INSERT INTO wib_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesu mɛ yo ǹ tyɩ́ nɛ: «Ń kódĩ́, wáh pɔ nɛ̂ pɩ́-ńsah, kè pɩ.» Képah sɔkɔ, no nɔ́pi núkú nɔ de Yesulɛ à à tɛ̃. ");
INSERT INTO wib_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Képah tɛ̃̀nɛ, nónó-á sõ̀ mɛ Yesulɛ, pé sɔkɔ yɔ́ núkú ǹ kèkírkì yɔrɩ dɛ à sárká syínwìlkìpu yõ̀tɛ̃̀ ǹgbɛ̃ tõ̀npɩ níkí kõ kãm. ");
INSERT INTO wib_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ǹtɛ Yesu mɛ yo ǹ tyɩ́ nɛ: «Á kèkírkì dyɩ ké gbô sɔkɔ. Yah, nónó pól-á mâllɛ n pɩ kèkîrnnɛ, kèkîrn ye kɩ ko mɔ pélɛ. ");
INSERT INTO wib_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Á náh pɩ̃ nɛ ńmɔ-á kɩ sõ̀ fɛ̃ yo mɔ ń Sú tyɩ́, à kɩ yĩ̂nyõ tõ̀npɩbɩ kèyõ náhnáh tɛkɩ mɔ ń kɔ̃ nɛ́npɔ́ swɔ, sè kɩ pɔ ń yohnɩ mɔ di? ");
INSERT INTO wib_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ǹtɛ kàh pɩ sɛ̃́, Liyel wɛy sɛ́bɛ́y sɔkɔ tyi wã́rkɩ́nsàhnɔ́ kɩ wil dùkù nɛ̂nɛ? Kè mó tɔ̃ mɛ kè yo sah nɛ sɛ̃́-á kè yɩ̃nɛ kè pɩ.» ");
INSERT INTO wib_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Képah náh, tɛ́ yo nɛ́kwĩ́nkí nɔ́pi tyɩ́ nɛ: «Yé pɔ ńmɔ tɛ̃́-ńsah kèkîrn ànɛ̂ ńsninɛ yé tyɩ́, á kɩ nɛ kèlékɛ̃ névi sɔ̃́ ńnɛ. Ǹtɛ swɔ̃ swɔ̃ póllɛ, mé sõ̀ ńkɛ̃́nɛ nɛ n mɛ kɔ̃́ntɛ̃̀nɔ́lɛ Liyel ní-ńsah gbô sɔkɔ ǹ kwɔ́nɔ́lɛ n pɩ, tɛ́ yé náh ń tɛ̃. ");
INSERT INTO wib_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ǹtɛ Liyel tɛ̃ntõ̀ syínyopu tyi wã́rkɩ́nsàhnɔ́ wil yĩn ye tyi nɔ́pi pól kɔ̃ sè pɩ.» Wǎh képah yo, ǹ tõ̀ sã́hpú pól to karkɩ tɛ́ à sah. ");
INSERT INTO wib_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Nónó-á tɛ̃ Yesulɛ, pè yuku ǹnɛ sárká syínwìlkìpu yõ̀tɛ̃̀ ǹgbɛ̃ Kayifi tĩ̀nnɛ, ńyãh sɔkɔ-á Liyel tyi kõ̀nsàhnɔ́ kwɔ́pú ànɛ̂ yèwàhnɩ̀ sõ̀ mɛ wɛ̃ tuke mɔ. ");
INSERT INTO wib_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pyɛrɩ sõ̀ mɛ Yesu sõ̀ tɛ̃ n kɔ fɩ́ɩ́ ǹnɛ, pópó à kyɩ yĩni tɛ̃ sárká syínwìlkìpu yõ̀tɛ̃̀ ǹgbɛ̃ gbô tyɩ́. Tɛ́ de yuku à kyɩ kɔ̃ tɛ̃ tõ̀npɩbɩ tnɔ̂, tɛ́ n yah yĩ mɛ̀-á kɩ pɔ n syi n pi dùkù nɛ̂nɛ. ");
INSERT INTO wib_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Sárká syínwìlkìpu yõ̀tãm ànɛ̂ pé no tukey tùkèpu tĩ̀nkì pól sõ̀ mɛ n yah n kɔ̃ nɛ, tàrfyɔ̀nɔ́ yísyɔ́ wɛ, nónó-á kɩ mɩ̀nɩ̀ wɛ n yo n sah Yesu yõ, pé mó à wɛ n ko n mɔ. ");
INSERT INTO wib_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Tàrfyɔ̀ mɩ̀nyobe náhnáh sénsɔ̃ pɔ mɩ̀nɩ̀ yo sah ǹ yõ, ǹtɛ pè náh tir yɔ́ wɛ wǎh yɩ̃nɛ à ko mɔ nɛ̂ yĩnnɛ. Ké tyɛ́-ńsah sɔkɔ, díbí nɛ́pĩ̂ nímí wil yĩn ");
INSERT INTO wib_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","tɛ́ nɛ ńkɛ̃́, dĩ́ mɛ̀-á yo nɛ páh kɩ fɛ̃ Liyel ní-ńsah wɔ̀kɔ̀ kètǎr sɔ tɛ́ kɩ kè tɔ̃ mɔ sèpĩ̀n tɔ̃́nɩ̀ wrɔ́. ");
INSERT INTO wib_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Képah sɔkɔ, sárká syínwìlkìpu yõ̀tɛ̃̀ ǹgbɛ̃ yuku yĩn tɛ́ yo Yesu tyɩ́ nɛ, no nɔ́pi-á tyi nónónɛ n yo ǹ tyɩ́ sɔkɔ, tyíyóné kó mɛ ǹmɔ tyɩ́ sépi tyɩ́ sɔkɔ nɩ? ");
INSERT INTO wib_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ǹtɛ Yesu náh dahbɩ wilki. Képah tɛ̃̀nɛ, sárká syínwìlkìpu yõ̀tɛ̃̀ ǹgbɛ̃ mɛ yo ǹ tyɩ́ nɛ, min nɛ́tɛ̃̂ Liyel yĩn yõ, à yo pé syah ǹmɔ-à kɩ nɛ̂ Liyel nɛy yáhntɔkɔnɔlɛ, nɛ̂-á ǹ Pídĩ́nɛ. ");
INSERT INTO wib_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu mɛ yo ǹ tyɩ́ nɛ: «Áwɔ ye yo kélɛ. Tɛ́ mé kélɛ n yo yé tyɩ́, à tɔkɔ núkúnúkú tyɩ́, yé kɩ Névi Pídĩ́ wɛ kɔ̃́ntɛ̃̀nɔ́lɛ tyi pól tyɩ́ tɛ̃́nwɛ-ò Liyel gbõ̀yõ̀ sõ̀lɛ. Yé kɩ à wɛ tɔlɛ à kɩ mɛ n pi ńyĩ̂rn sɔkɔ.» ");
INSERT INTO wib_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Képah tɛ̃̀nɛ, sárká syínwìlkìpu yõ̀tɛ̃̀ ǹgbɛ̃ ǹ gblɔ̌y flɔ yɔrɩ tɔkɩ tɛ́ nɛ, wǎh yo de Liyel tyɩ́. Tàrfyɔ̀ nɛ̂ tɛ̃̀ se tɔ̃ pé kɩ n yah n kɔ̃ nɩ? Pè kó ǹ Liyel tyɩ́ yóndenɔ noh nɩ? ");
INSERT INTO wib_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Pépi se mɛ n sõ sɔ̃́ nɩ? Pè mɛ yo ǹ tyɩ́ nɛ, wǎh yɩ̃nɛ kònmɔnɔlɛ. ");
INSERT INTO wib_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Képah tɛ̃̀nɛ, tɛ́ tyah n sĩn n mɔ ǹ yah sɔkɔ, tɛ́ ǹnɛ n syɩkɩ gbõ̀nkukelɛ, tɛ́ túkù mó mɛ ǹ létáhlɔ́lɛ n kɔ̃lɩ ");
INSERT INTO wib_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","tɛ́ mɛ n yo ǹ tyɩ́ nɛ, ǹmɔ-à kɩ nɛ̂ Liyel nɛy yáhntɔkɔnɔlɛ, à sãh pɩ̃ yo pé syah nɛ̂-á n ko ǹnɛ. ");
INSERT INTO wib_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pyɛrɩ sõ̀ mɛ kɔ̃́ntɛ̃̀nɔ́lɛ gbô táh. Tõ̀npɩ pi yɔ́ mɛ nɔ de ǹ tnɔ̂ tɛ́ yo ǹ tyɩ́ nɛ, ǹmɔ tɔ-á sõ̀ mɛ Yesulɛ, nɛ̂-á Kalile nɛynɛ. ");
INSERT INTO wib_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ǹtɛ à mɛ kè kɔ̃lɩ no pól yĩ́ yah nɛ, pé náh mɛ ǹ wɛy mɛ̀ tyɩ́ yah wɛ yɔ̀ dɛ́. ");
INSERT INTO wib_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Képah náh, Pyɛrɩ sɔkɔ gbô yah tĩ̀nnɛ. Tõ̀npɩ pi yɔ́-á tɔ̃ à wɛ, nónó-á sõ̀ mɛ nɛ́npɔ́, à yo pé tyɩ́ nɛ, dĩ́ mɛ̀ tɔ-á sõ̀ mɛ Yesulɛ, nɛ̂-á Nasarɛtɩ nɛynɛ. ");
INSERT INTO wib_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pyɛrɩ tɔ̃ kè kɔ̃lɩ à ǹ wo nɛ, pé náh dĩ́ mɛ̀nɛ n pnɛ dɛ́. ");
INSERT INTO wib_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Dǒ kwéy, nónó-á sõ̀ mɛ nɛ́npɔ́ pépi nɔ de Pyɛrɩlɛ tɛ́ yo ǹ tyɩ́ nɛ, kègbɩ yõ, no nɔ́pi sɔkɔ yɔ́-á ǹ tɔlɛ. Ǹ wɛy dùkù-á mɛ kélɛ n wɛ̃kɩ dò. ");
INSERT INTO wib_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Képah sɔkɔ Pyɛrɩ tyah ǹ gblɔ̌ynɛ n wo pélpèl nɛ, pé náh dĩ́ mɛ̀ pɩ̃. Nɛ́npɔ́ swɔ sénpɛ yɔ́ núkú gbo. ");
INSERT INTO wib_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Légbĩ́nɛ, Pyɛrɩ dyɔ to kõ Yesu wɛy mɛ̀nɛ, wǎh sõ̀ nɛ̂ yo nɛ ńkɛ̃́: «Sénpɛ-à kɩ pópó n gbo, á kɩ mɛ á vyãh kɔ̃lɩ tɛ kɛ tɔ̃́nɔ́ nɛ á náh ńmɔ pɩ̃.» Képah sɔkɔ, Pyɛrɩ wil kégbɔ́ à kyɩ kah gbo. ");
INSERT INTO wib_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Séngbɔ̃́ púpúlɛ, sárká syínwìlkìpu yõ̀tãm pól ànɛ̂ kwil yèwàhnɩ̀ pól yo sah núkú yõ nɛ Yesu-á yɩ̃nɛ à ko mɔ. ");
INSERT INTO wib_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Tɛ́ mɛ à tɛ̃ pukubi, tɛ́ kyɩ ǹnɛ kwíltãm yõ̀tɛ̃̀ Pilati gbõ̀ dahbɩ. ");
INSERT INTO wib_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Képah sɔkɔ, Nsyudasɩ nɛ̂-á sõ̀ pɩ pè kɔ̃ pè Yesu wɛ tɛ̃, wǎh pɔ ǹ kònmɔnɔ tyɩ́ wɛ kè yĩ tɛ̃, kè à kah fyãh. À mɛ pɔ́ plɔ́ yõgbãm nɔ́pi tɔkɔ kyɩ nɛ pé sárká syínwìlkìpu yõ̀tãm ànɛ̂ kwil yèwàhnɩ̀ kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Tɛ́ yo pé tyɩ́ nɛ, páh tyípékè pɩ lékàh kɛ̃́ névi mɔ́nɔ́lɛ kũ sɔkɔ. Ǹtɛ pè mɛ à syah nɛ, pépi tir nɛ̂ se mɛ képah sɔkɔ nɩ? Képah-á mɛ ǹmɔlɛ n yah kɛ̀. ");
INSERT INTO wib_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Képah sɔkɔ, Nsyudasɩ pɔ́ mɛ̀ milki Liyel ní-ńsah wɔ̀kɔ̀ kètǎr sɔkɔ, tɛ́ wil sɔkɔ à kyɩ ǹ gblɔ̌y gbel. ");
INSERT INTO wib_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Sárká syínwìlkìpu yõ̀tãm mɛ pɔ́ mɛ̀ tɔkɔ tɛ́ nɛ ńkɛ̃́, kè náh yɩ̃nɛ dáhnmɔnɔlɛ Liyel ní-ńsah gbô pɔ́ sɔkɔ. Névi tṍ-á kɩ n kwɛ n pi ké tyɩ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Képah tɛ̃̀nɛ, pè yo sah núkú yõ, tɛ́ pɔ́ mɛ̀nɛ pní mɔ́-ò dĩ́ yɔ́ swãh dwe à pɩ nɛ́pân lékyɩ̂ yɩ̃́-ńsahlɛ. ");
INSERT INTO wib_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Képah ye, fɔ́ɔ́ à pɔ syɩ kwɛy mɛ̀ tyɩ́, swãh mɛ̀ mɛ n ye tṍ swãhlɛ. ");
INSERT INTO wib_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Képah sɔkɔ, Liyel tɛ̃ntõ̀ syínyo-ò Nsyeremi-á lésõ nɛ̂ yo sah, kè wil. À lésõ nɛ ńkɛ̃́: «Pè ye pɔ́ plɔ́ yõgbãm tɔkɔ, Yisrayel no-á nɛ dan nɛ̂-á yɩ̃nɛ kɔ̃́nɔ́lɛ ǹ tyɩ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Tɛ́ kyɩ sélɛ pní mɔ́-ò dĩ́ swãh dwe, à yɩ̃nɛ Tɛ̃̀ ǹgbɛ̃ Liyel-á kè yo sɔ̃́ ń tyɩ́.» ");
INSERT INTO wib_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Pǎh Yesu tɛ̃ kyɩ kwíltãm yõ̀tɛ̃̀ dĩ́ Pilati tyɩ́, à mɛ Yesu piki yah nɛ ǹmɔ se Nsyifunɔ yõ̀tɛ̃̀nɛ dĩ́nɛ nɩ? Yesu mɛ yo ǹ tyɩ́ nɛ: «Áwɔ ye yo kélɛ.» ");
INSERT INTO wib_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ǹtɛ sárká syínwìlkìpu yõ̀tãm ànɛ̂ kwil yèwàhnɩ̀ sõ̀ mɛ tyilɛ n yo n sah ǹ yõ. Ǹtɛ à náh dahbɩ wilki pé tyɩ́ sépi tyɩ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Képah sɔkɔ, Pilati mɛ yo ǹ tyɩ́ nɛ, pǎh tyi nónó póllɛ n yo n sah ǹ yõ, à kó mɛ sélɛ n nohnɩ nɩ? ");
INSERT INTO wib_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ǹtɛ Yesu náh dahbɩ wilki ǹ tyɩ́ póllɛ. Kǎh pɩ sɛ̃́, kè ǹ gbã̀n kah du. ");
INSERT INTO wib_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Yimɛyí Pakɩ syáh sɔkɔ, kwíltãm yõ̀tɛ̃̀ ńkɛ̃́nɛ wɔ̀kɔ̀npèkè sɔkɔ nɛ́núkù yɔ́ fĩn n mɔ, tɔ́wû-à nɛ̂ yah wilki. ");
INSERT INTO wib_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Tɛ́ légbĩ́nɛ dĩ́ yɔ́ sõ̀ mɛ wɔ̀kɔ̀npèkè sɔkɔ, nɛ̂ yĩ́npékè-á wil yĩ́ĩ́ náhnáh. Ǹ yĩn ye sõ̀ Barabasɩlɛ. ");
INSERT INTO wib_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Képah tɛ̃̀nɛ, tɔ́wû nɛ̂-á sõ̀ mɛ tùkènmɔnɔlɛ, kwíltãm yõ̀tɛ̃̀ dĩ́ Pilati mɛ pépi piki yah nɛ, pè se mɛ ké tyɩ́ nɛ pé nɛ̂ fĩn mɔ pè kɔ̃ nɩ? Barabasɩ se, tĩ̂ Yesu nɛ̂-á pè n ye Liyel nɛy yáhntɔkɔnɔlɛ, ǹmɔ se? ");
INSERT INTO wib_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Yé náh wɛ di, Pilati sõ̀ pɩ̃ nɛ Yesu yĩ́ngbɩ́ wìlnɔ́-á n yɔ pélɛ pè kɔ̃ pè à dahbɩ péwɔ gbõ̀ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Tɛ́ wǎh mɛ tɛ̃̀nɔ́lɛ tukey tùkè-ǹsah sɔkɔ, ǹ kyɩ tɛ̃ntõ̀ mɔ ǹ tyɩ́ nɛ, lékàh kɛ̃́ dĩ́ mɛ̀ tyɩ́ dlɛ́npêl-á pé kwlɔ kwɛy lékã̂hnɛ. À káh ǹ vyãh dahbɩ ǹ tyɩ́ sɔkɔ dɛ́. ");
INSERT INTO wib_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ǹtɛ sárká syínwìlkìpu yõ̀tãm ànɛ̂ kwil yèwàhnɩ̀ mɛ tɔ́wû kurki mɔ nɛ, pè yo Pilati tyɩ́ à Barabasɩ fĩn mɔ, à mó Yesu ko mɔ. ");
INSERT INTO wib_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Kwíltãm yõ̀tɛ̃̀ dĩ́ Pilati mɛ tɔ̃ pè piki yah nɛ, pè se mɛ ké tyɩ́ nɛ pé nɛ̂ tɛ̃̀ fĩn mɔ pè kɔ̃ nɛ́pĩ̂ nímí nɔ́pi sɔkɔ nɩ? Pè mɛ nɛ Barabasɩ-á. ");
INSERT INTO wib_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilati mɛ nɛ, ǹtɛ Yesu nɛ̂-á pè n ye Liyel nɛy yáhntɔkɔnɔlɛ, pé se kɩ pɩ sɔ̃́ ǹmɔlɛ nɩ? Pé pól mɛ nɛ wǎh yɩ̃nɛ à syɩ dahnɩ yõ. ");
INSERT INTO wib_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","À mɛ pè piki yah nɛ, ǹtɛ tyítúkù nɛ̂ ó se à pɩ nɩ? Ǹtɛ pè tɔ̃ kah yo mɔ wòhòh nɛ, wǎh yɩ̃nɛ à syɩ dahnɩ yõ. ");
INSERT INTO wib_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilati-á pɔ kè pɩ̃ nɛ pé náh mɛ fɛ̃ tir yɔ́lɛ n pɛkɩ ké sɔkɔ, tɛ́ névye-á mó tɔ̃ mɛ n tyah tyah fɛ̃̀kɩ̀nɔ́lɛ, à ni tɔkɔ à ǹ gbã̀n wu tɔ́wû yĩ́ yah tɛ́ nɛ, péwɔ vyãh náh mɛ dĩ́ mɛ̀ kònmɔnɔ tyɩ́ sɔkɔ. Kǎh pé tyɩ́ kɛ̀. ");
INSERT INTO wib_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","No pól mɛ nɛ, ǹ kònmɔnɔ plɔ pɩ pépi ànɛ̂ pé wɛ̃́npì tyɩ́lɛ wɛ́! ");
INSERT INTO wib_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Képah sɔkɔ, Pilati mɛ Barabasɩ fĩn mɔ pè kɔ̃. Tɛ́ sràsyíbí kɔ̃ pè Yesu ko yèfõhlɛ, tɛ́ ǹ gbàh dɛ mɔ pè kɔ̃ nɛ pè à syɩ dahnɩ yõ. ");
INSERT INTO wib_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Képah tɛ̃̀nɛ, kwíltãm yõ̀tɛ̃̀ dĩ́ Pilati sràsyíbí mɛ Yesu tɛ̃ de tɔ̃́rɩ́ gbô sɔkɔ, tɛ́ pé no sràsyíbí pól ye pɔ à mɔ gbɩ̃. ");
INSERT INTO wib_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Pè mɛ ǹ flɔ dɛ ǹ wil sɔkɔ, tɛ́ fwɔ̀mɔ̀nsãh ǹgbɛ̃ yɔ́ mɔ à kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Tɛ́ pã̀n yõ̀kɔ̃ pɩ dyɩ à kɔ̃ tɔ̃́rɩ́ yṍkúrí swɔ, tɛ́ lépéy yɔ́lɛ à kɔ̃ à tɛ̃ yĩn ǹ gbõ̀yõ̀ sɔkɔ. Tɛ́ gbètukunɔ di ǹ yah sɔkɔ à kṍlɛ ǹnɛ n ko mɛ yo tũ nɛ, Nsyifunɔ yõ̀tɛ̃̀ dĩ́, páh n wɛkɩ ǹ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Tɛ́ n sĩn n mɔ ǹ yõ, tɛ́ lépéy mɛ̀ syi à ǹnɛ n mɩkɩ ǹ yõ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Pǎh kṍlɛ à ko tɛ, pè fwɔ̀mɔ̀-ǹgbɛ̃ mɛ̀ dɛ ǹ tyɩ́ tɛ́ ǹ flɔ tɔ̃ mɔ à kɔ̃, tɛ́ à tɛ̃ n yuku syɩ́-ńsah dahnɩ yõ. ");
INSERT INTO wib_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Pǎh kyɩ n wil kwil sɔkɔ, pè Sirɛnɩ kwil dĩ́ yɔ́ yohnɩ pè n ye Simolɛ. Sràsyíbí mɛ ǹmɔ kyɩ̃ mɔ à kɔ̃ à Yesu syɩ syɩ dahnɩ twah. ");
INSERT INTO wib_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Pǎh kyɩ yĩni tɛ̃ tyah yɔ́ sɔkɔ, pè n ye Kɔlkotalɛ, nɛ̂ kɔ́r-á Yõ̀gbèkè tyahlɛ, ");
INSERT INTO wib_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","pè wil yɔ́nɔ́ kèkô kwâh yɔ́ fɛ̃kɩ mɔ dìvɛ̃ sɔkɔ Yesu kɔ̃ nɛ à wɔ. Wǎh kè wɔ yah, à kè yahle. ");
INSERT INTO wib_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Képah náh, pè à syɩ dahnɩ yõ. Pǎh à syɩ tɛ, pè ǹdan mɔ à ǹ flɔ dibi pé wɛ̃ wrɔ́. ");
INSERT INTO wib_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Tɛ́ mɛ kɔ̃ tɛ̃ nɛ́npɔ́ à ǹnɛ n syɩkɩ nɛ nɛy káh pɔ à pwah mɔ. ");
INSERT INTO wib_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Yõ nɛ̂ yõ-á pè syɩ ǹnɛ, pè sõ̀ mɛ kè wãrkɩ syɩ sah ǹ yõ̀tah sɔkɔ nɛ ńkɛ̃́: «Yesu ye yɔ̀, nɛ̂-á Nsyifunɔ yõ̀tɛ̃̀nɛ.» ");
INSERT INTO wib_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Kèlékɛ̃ pɩ́pú nɛ́pĩ̂ nímí yísyɔ́ tɔ sõ̀ mɛ syɩ́nɔ́lɛ dahlɔ yõ ǹ tnɔ̂. Núkú sõ̀ mɛ ǹ gbõ̀yõ̀ sõ̀lɛ, ní-ò mɛ ǹ gbɛ̃̀yɩ̃̀nɛ̀ sõ̀lɛ. ");
INSERT INTO wib_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Wɛ̃̀kɔbɩ nónó-à kɔ pɔ n sɔkɔ, pě pé ywɔ̃lɛ n mɔ ǹ tɛ́ ǹnɛ n gbyɔ ");
INSERT INTO wib_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","nɛ ńkɛ̃́, ǹmɔ nɛ̂-á sõ̀ nɛ páh kɩ Liyel ní-ńsah wɔ̀kɔ̀ kètǎr sɔ, tɛ́ kɩ fɛ̃ kè tɔ̃ mɔ sèpĩ̀n tɔ̃́nɩ̀ wrɔ́, ńkɛ̃́ Liyel Pídĩ́-à kɩ nɛ̂ ǹnɛ, à ǹ gblɔ̌y pwah mɔ. À tiki n to dahnɩ yõ kɛ̀. ");
INSERT INTO wib_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Sɛ̃́ ye, sárká syínwìlkìpu yõ̀tãm ànɛ̂ Moyisi tyi kõ̀nsàhnɔ́ kwɔ́pú, ànɛ̂ kwil yèwàhnɩ̀ tɔ sõ̀ mɛ kṍlɛ ǹnɛ n ko mɛ yo tũ nɛ, ");
INSERT INTO wib_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","wǎh túkù pwah mɔ, tɛ́ kɩ tɛ̃ ǹ gblɔ̌y wɔ pwah mɔ kwlɔ nɩ? Yisrayel yõ̀tɛ̃̀ tɛ̃̀-à kɩ nɛ̂ ǹnɛ, à tiki n to dahnɩ yõ núkúnúkú, pé mó sɛ̃ ǹ yõ kɛ̀. ");
INSERT INTO wib_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","À kó ǹ sõnɔ sah Liyel yõ, tɛ́ kè yo ńtɛ̃nɛ nɛ ǹ Pídĩ́-á pélɛ nɩ? Ǹ tyɩ́-à kɩ mɛ nɔ Liyel tyɩ́, à à pwah mɔ núkúnúkú wɛ́. ");
INSERT INTO wib_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Kèlékɛ̃ pɩ́pú nónó tɔ-á sõ̀ syɩ́nɔ́lɛ ǹ tnɔ̂, pépi tɔ sõ̀ mɛ ǹnɛ n gbyɔ sɛ̃́ntɛ̃̀ ólɛ. ");
INSERT INTO wib_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Gbĩ-á mɛ yõ̀tah sírr sɔkɔ, fɛ̃́ntũ̂ mɔ kèkõyṍ pól sɔkɔ, pópó à pɔ nɔ lɛ́rɩ́nɔ́ tɔ̃́nɔ́ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Lɛ́rɩ́nɔ́ tɔ̃́nɔ́ nɔ́pi-á sɔkɔ, Yesu kah yo yĩ́npɔ̃́ ǹgbɛ̃nɛ nɛ: «Yeli, Yeli, lama sabakɩtani?» Nɛ̂ kɔ́r-á: Ńmɔ Liyel, ńmɔ Liyel, kwâh nɛ̂ pɩ tɛ́ á ń fĩn mɔ? ");
INSERT INTO wib_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nónó-á sõ̀ mɛ nɛ́npɔ́, pé túkù-á ǹ yónmɔnɔ mɛ̀ noh, pè nɛ ńkɛ̃́, wǎh mɛ Yelilɛ n ye n yah oo! ");
INSERT INTO wib_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Nɛ́npɔ́ swɔ, pé sɔkɔ yɔ́ to kyɩ sènsúkúrí tɔkɔ fõ yõ̀yõ̀kè ni sɔkɔ, à dyɩ mɔ gbey yɔ́ vyãh tyɩ́, tɛ́ kè nɔ ǹ tyɩ́ nɛ à wɔ. ");
INSERT INTO wib_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Pé tɛ́lɔ́ mó mɛ yo tũ nɛ ńkɛ̃́, pé ye yĩn sɔ̃́, Yeli mó pɔ à pwah mɔ pé yah ǎtrɛ. ");
INSERT INTO wib_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ǹtɛ Yesu mɛ tɔ̃ kah de syi tɛ́ yah kwlɔ. ");
INSERT INTO wib_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Képah tɛ̃̀nɛ, fwɔ nɛ̂-á dyɩ́nmɔnkàhsàhnɔ́lɛ Liyel ní-ńsah wɔ̀kɔ̀ kètǎr sɔkɔ, kè tɔ tɔ́lɔ́ nínɔ́ à tɔkɔ ké yõ̀tah tyɩ́, à kyɩ dal mɔ ké sètàhkɩ̀ sõ̀ tyɩ́. Tɛ́ sétáh mɛ syah, légbyɔ̃́ gboke, ");
INSERT INTO wib_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","léyã̂l yɩkɩ mɔ, Liyel yõ sɛ̃́pú nónó-á sõ̀ ku sɔkɔ tɛ, pé náhnáh lékyɩ̂ mɛ yilki mɔ. ");
INSERT INTO wib_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Képah náh, tɛ́ mɛ wil léyã̂l sɔkɔ Yesu lékó yílkínmɔntɛnɔ náh, tɛ́ de Yerusalɛmɩ kwil sɔkɔ Liyel-á képah nɛ̂ yah tɔkɔ. Névye náhnáh yĩ́ tɛ̃ pé yõ. ");
INSERT INTO wib_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Sràsyíbí yõ̀tɛ̃̀ dĩ́ ànɛ̂ nónó tɔ-á sõ̀ mɛ Yesulɛ n syɩkɩ ǹnɛ, pépi-á sétáh syahrɩ mɛ̀ wɛ à tahlɩ tyi nónó tɔ-á pɩ, tíkí pè kah tɛ̃. Pè mɛ nɛ ńkɛ̃́: «Kègbɩ yõ, dĩ́ mɛ̀nɛ, Liyel Pídĩ́ ye sõ̀ ǹnɛ.» ");
INSERT INTO wib_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Tɛ́ syɔ́ náhnáh tɔ sõ̀ mɛ yĩn tɛ̃ fɩ̃́ tɛ́ mɛ n yah. Kalile duku sɔkɔ ye kénɛ syɔ́ Yesu sõ̀ tɛ̃, à n yah n dah n mɔ ǹ tyɩ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Makadala kwil Mari sõ̀ mɛ pé sɔkɔ, à tahlɩ Nsyakɩ ànɛ̂ Nsyosɛfu yṹ Mari tyɩ́, ànɛ̂ Nsebede dĩ́npì yṹnɛ. ");
INSERT INTO wib_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ńvɩ̃́-á pɔ nɔ, tàh dĩ́ yɔ́ pɔ de, nɛ̂-á sõ̀ n wil Arimatɩ kwil sɔkɔ. Kénɛ dĩ́ yĩn ye Nsyosɛfulɛ. Yesu tõ̀ sã́h-ò ye sõ̀ ǹ tɔlɛ. ");
INSERT INTO wib_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ǹmɔ mɛ kyɩ wil Pilati tyɩ́, à Yesu lékó ni ǹ tyɩ́. À mɛ nɛ pè ǹnɛ à kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Pǎh ké wɛ̃̀kɩ̀lɛ à kɔ̃, à mɛ ǹ lékó tɔkɔ tɛ́ à plo fwɔ gbró snɔ́lɛ. ");
INSERT INTO wib_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Nsyosɛfu-á sõ̀ pè kɔ̃ pè diki sã́n nɛ̂ tũ sah ǹ yɛ̃́ngbɛ̃́ tyɩ́lɛ tɛkɩ sɔkɔ, à kyɩ à dah mɔ képah sɔkɔ. Képah sɔkɔ, tɛ́ dáh-ǹgbɛ̃ yɔ́ pil pɔ ké yah vike tɛ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Tɛ́ légbĩ́nɛ, Makadala kwil Mari ànɛ̂ ǹ ní-ò Mari sõ̀ mɛ kɔ̃́ntɛ̃̀nɔ́lɛ nɛ́npɔ́ sɔkɔ diki yah yèsreynɛ. ");
INSERT INTO wib_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Tɛ́ kénɛ yòh sõnɔ́ ye ńkɛ̃́nɛ pě pélɛ n vi n sah pé mɩ mɩ yòh sõ yĩnnɛ. Ké dĩndallɛ, sárká syínwìlkìpu yõ̀tãm ànɛ̂ Farisi wɛ̃̀kɩ̀ kɔ́pú mɛ wɛ̃ sõ̀ tɛ̃ kyɩ wil Pilati tyɩ́, ");
INSERT INTO wib_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","tɛ́ yo ǹ tyɩ́ nɛ, pé yõ̀tɛ̃̀, pé dyɔ-á to kõ nɛ, kénɛ névye pílkí-ò-á lésõ mɛ kè yo sah ǹ kú-ńkɛ̃̂ sɔkɔ nɛ, pâh pɔ ku, ké sèpĩ̀n tɔ̃́-ò sõlɛ, pé lékó-á kɩ yilki mɔ. ");
INSERT INTO wib_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Képah yĩnnɛ, ńkɛ̃́ à sràsyíbí kɔ̃ pè diki syɩkɩ pɔ nɔ sèpĩ̀n tɔ̃́nɩ̀ tyɩ́. Képah-à pɩ́-ńkɛ̃̂nɛ, ǹ tõ̀ sã́hpú-á kɩ n syah n pɔ ǹ lékólɛ n yɩ̃ n wilki, tɛ́ kɩ névye syah nɛ ǹ lékó-á yilki mɔ. Képah tɛ̃̀-á kɩ tɔ̃ névye pilki kal gben tɛ̃̀nɛ. ");
INSERT INTO wib_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilati mɛ yo pé tyɩ́ nɛ, tyah syɩ́kɩ́pú-á yɔ̀. Ńkɛ̃́ pè kyɩ diki mɛ̀nɛ n syɩkɩ pǎh mɛ ké tyɩ́ sɔ̃́. ");
INSERT INTO wib_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Pè mɛ sɔkɔ à kyɩ diki yah dáhkɩ̀ mɛ̀ pɔkɔ mɔ, tɛ́ tyah syɩ́kɩ́pú kɔ̃ pè kélɛ n syɩkɩ. ");
INSERT INTO wib_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Mɩ mɩ yòh-á sɔkɔ, dimansyi sõ séngbɔ̃́ púsɔ́lɛ, Makadala kwil Mari ànɛ̂ ǹ ní-ò Mari kyɩ diki yõ. ");
INSERT INTO wib_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Nɛ́npɔ́ swɔ, sétáh syahrɩ ǹgbɛ̃ pɩ. Tɛ̃̀ ǹgbɛ̃ Liyel yĩ̂nyõ tõ̀npɩ yɔ́ mɛ tiki pɔ dáh-ǹgbɛ̃ mɛ̀ pil to diki yah, tɛ́ kɔ̃ tɛ̃ ké yõ. ");
INSERT INTO wib_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","À sõ̀ mɛ n kõ kyòo pũ̀ sɔ̃́ yĩkiri, tɛ́ ǹ flɔ mɛ píkínɔ́lɛ prɛ́yy. ");
INSERT INTO wib_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Tíkí ànɛ̂ wílsyahrɩ tɛ̃̀ tyɩ́, tyah syɩ́kɩ́pú markɩ. ");
INSERT INTO wib_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Képah sɔkɔ, yĩ̂nyõ tõ̀npɩ mɛ yo syɔ́ tyɩ́ nɛ: «Yé káh tíkí pɩ. Mé pɩ̃ nɛ Yesu-á yé n yah n kɔ̃, pǎh nɛ̂ syɩ dahnɩ yõ. ");
INSERT INTO wib_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","À náh mɛ ásõ̂, ǹ lékó yilki mɔ à yɩ̃nɛ wǎh lésõ kè yo sah sɔ̃́. Yé pɔ n yah ǹ snɛ́kɩ́nmɔ-ńsahlɛ, ");
INSERT INTO wib_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","yè mó n kyɩ kè yo súú ǹ tõ̀ sã́hpú tyɩ́ nɛ, ǹ lékó-á yilki mɔ. Tɛ́ wǎh mɔ pé yahlɛ Kalile mara sɔkɔ. Pǎh kɩ kyɩ à wɛ nɛ́npɔ́. Nɛ̂-á sõ̀ mɛ ń tyɩ́ yo yo tɛ̃̀nɛ yé tyɩ́, képah ye yɔ̀.» ");
INSERT INTO wib_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Pè mɛ yal súú nɛ́npɔ́ sɔkɔ, tíkílɛ pé sɔkɔ nɩ̀vɩ̀nɩ̀ ǹgbɛ̃ tɔlɛ fɛ̃̀kɩ̀nmɔnɔlɛ ké sɔkɔ, à n to n yuku yĩ mɛ̀ yã́h-ńsah Yesu tõ̀ sã́hpú tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Nɛ́npɔ́ swɔ, Yesu núkú pè yohnɩ tɛ́ nɛ: «Mé n wɛkɩ yé tyɩ́.» Syɔ́ nɔ́pi mɛ nɔ de ǹnɛ, tɛ́ ǹ gbyẽ̂h tɛ̃ à gbílkínɔ́ sah ǹ yõ. ");
INSERT INTO wib_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Képah sɔkɔ, Yesu mɛ yo pé tyɩ́ nɛ: «Yé káh tíkílɛ n pɩ. Yé kyɩ n yo ń yṹnpyé tyɩ́ nɛ, pè yuku Kalile mara sɔkɔ. Nɛ́npɔ́ sɔkɔ ye pè kɩ wɛ ńnɛ.» ");
INSERT INTO wib_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Syɔ́ nɔ́pi-á mɛ wɛ̃̀kɩ̀ yõ gbĩ́ nɛ̂nɛ, tyi nónó pól-á pɩ, sràsyíbí nónó-á sõ̀ n syɩkɩ diki mɛ̀nɛ, pé túkù pɔ kwil sɔkɔ, à pɔ sè yo sárká syínwìlkìpu yõ̀tãm syah. ");
INSERT INTO wib_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Képah sɔkɔ, sárká syínwìlkìpu yõ̀tãm nɔ́pi ànɛ̂ kwil yèwàhnɩ̀ wɛ̃ tuke mɔ à yo sah núkú yõ, tɛ́ pɔ́-ǹgbɛ̃ yɔ́lɛ sràsyíbí kɔ̃, ");
INSERT INTO wib_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","tɛ́ pè syah nɛ pàh kɩ pɩ pè yo nɛ, ǹ tõ̀ sã́hpú-á pɔ ǹ lékó yɩ̃ wilki lékã̂hnɛ tɛ́ pé sah dɔy sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Kwíltãm yõ̀tɛ̃̀ dĩ́-à kɩ sɔ̃́ kè noh, pépi-á kɩ kè niri pè kɔ̃ pè náh yṍtír wɛ n pi ké sɔkɔ póllɛ. ");
INSERT INTO wib_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Tyah syɩ́kɩ́pú mó pɔ́ mɛ̀ syi tɛ́ kè pɩ pé yóré yõ. Képah tɛ̃̀nɛ, yĩ mɛ̀ tɔ̃ mɔ Nsyifunɔ nɩyṍ, fɔ́ɔ́ à pɔ syɩ kwɛy mɛ̀ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Yesu tõ̀ sã́hpú nɛ́pĩ̂ gbɔ̃núkú mɛ sɔkɔ Kalile mara yɔ̃lɩ yõ, wǎh lésõ ńyãh tyɩ́ yo sah pé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Pǎh kyɩ à wɛ, pè à gbilki, ǹtɛ pé túkù sõ̀ mɛ tɔ̀tɔ̀lɛ n pɩ ǹ tyɩ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesu mɛ nɔ de pé tnɔ̂ tɛ́ yo pé tyɩ́ nɛ: «Yõ̀tɔ̃rɩ́ pól ye ńmɔ gbõ̀ dahbɩ yĩ̂nyõ ànɛ̂ sétáh yõ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Yé kyɩ kwlo kwlo pól névye pɩ ńmɔ tõ̀ sã́hpúlɛ, yè mó pè wel n wilki ni sɔkɔ Sú Liyel, ànɛ̂ Pídĩ́, ànɛ̂ Liyel Mirki yĩn yõ. ");
INSERT INTO wib_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Máh tyi nónó kõ sah yé kɔ̃, yè mó pè kwɔ sélɛ pè kɔ̃ pè sélɛ n pɩ. Tɛ́ ńmɔ kɩ mɛ yélɛ sõmɛsṍ, fɔ́ɔ́ kɩ kyɩ syɩ kèkõyṍ tyɛ́nɔ́ tyɩ́.»");
INSERT INTO wib_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Liyel pi Yesu *Krista nɩ̀vɩ̀nɩ̀ wɛy sã́n tyàh-ǹsah ye yɔ̀. ");
INSERT INTO wib_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Sɔ̃́-á kélɛ wã́rkɩ́nsàhnɔ́lɛ *Liyel tɛ̃ntõ̀ syínyo-ò *Yesayi sɛ́bɛ̃́ sɔkɔ nɛ: «Yah, ńmɔ Liyel kɩ ń tɛ̃ntõ̀ névi tɛkɩ mɔ á yahlɛ, à kɩ pɔ á wɛ̃̀kɩ̀ tɔ̃ sah á tyɩ́.» ");
INSERT INTO wib_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ǹnɩ̂ yɔ́ yĩ́npɔ̃́ ye n dɔkɔ gbɛ̃́nnɩ sɔkɔ nɛ ńkɛ̃: «Yé Tɛ̃̀-ǹgbɛ̃ wɛ̃̀kɩ̀ tɔ̃ sah, yé kè pɩ tómm!» ");
INSERT INTO wib_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Kǎh wãrkɩ sah sɔ̃́, sɛ̃́ ye *Wèlnwìlkì-ò Nsyɔ̃ pɔ wil mɔ gbɛ̃́nnɩ sɔkɔ. À tyah n yo n kɔ̃ névye tyɩ́ nɛ, pè pé nnɔ vi mɔ, pè mó *wèlnwìlkìnɔ́ wɛ. Képah sɔkɔ, Liyel-á kɩ pé tyípêl yɔ̃ mɔ pè kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Képah tɛ̃̀nɛ, Yude kwlo névye pól, ànɛ̂ tɔ̃ Yerusalɛmɩ névye pól sõ̀ mɛ n pɔ n pɔ ǹ tyɩ́, n pɔ pé tyípêl yo névye pól yĩ́ yah, tɛ́ ǎ pè wel n wilki Yurdɛ̃ yɔ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Tɛ́, Nsyɔ̃ sõ̀ mɛ yã̀hmɩ́kɩ̀ yɛ̀ fwɔ̀mɔn mɔ, tɛ́ ǹ syɩ̃ tɛ̃ sêl kɔ̃lɛ. Ǹ yõkelɛ sõ̀ sègblo ànɛ̂ syɩ̃rɩ ye. ");
INSERT INTO wib_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","À sõ̀ mɛ n yo tɔ́wû tyɩ́: «Névi nɛ̂-á kɩ n pɔ n pi ńmɔ náh, ǹmɔ ye gblò kal ńmɔlɛ. Ńmɔ tɛ̃̀ náh yɩ̃nɛ mé kɔ yĩn, ǹ gbáhkɩ̀ lékyêh sro dɛ. ");
INSERT INTO wib_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ńmɔ ye yélɛ n wel n wilki ni sɔkɔ, ǹtɛ ǹmɔ kɩ pɔ yé wel n wilki n pi *Liyel Mírkí sɔkɔ.» ");
INSERT INTO wib_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Légbĩ́nɛ, Yesu wil Nasarɛtɩ kwil, Kalile sétáh yõ, à pɔ Nsyɔ̃ kɔ̃ à à *wel wilki Yurdɛ̃ yɔ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Tɛ́, wǎh n wil ni sɔkɔ gbĩ́ nɛ̂nɛ, à yĩ̂nyõ wɛ kè n yɩkɩ n mɔ, tɛ́ *Liyel Mírkí tiki ǹ yõ, dàhyõ̀kèpil sɔ̃́. ");
INSERT INTO wib_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Légbĩ́nɛ, yĩ́npɔ̃́ yɔ́ n wil Liyel sɔkɔ nɛ ńkɛ̃: «Áwɔ ye ńmɔ nɩ̀dɛ̀ Pi núkúnínɛ. Á tyɩ́ nɔ yĩ́ĩ́ ń tyɩ́ kègbɩlɛ.» ");
INSERT INTO wib_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ké nɛ́npɔ́ swɔ, Liyel Mírkí à tɛ̃ yuku gbɛ̃́nnɩ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","À sèpĩ̀n tíkíníní pɩ nɛ́npɔ́ sɔkɔ. Tɛ́ *sétã̀n yõ̀tɛ̃̀ pɔ ǹnɛ n tɔ̃ n mɔ. À sõ̀ mɛ gbɛ̃́nkyɔ nɩyṍ sɔkɔ, tɛ́ *yĩ̂nyõ tɛ̃̀ntõbe mɛ ǹ tɛ̃̀-ǹsahlɛ n yah. ");
INSERT INTO wib_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Képah náh, pè pɔ *Wèlnwìlkì-ò Nsyɔ̃ dah mɔ wɔ̀kɔ̀npèkè sɔkɔ. Ǹ déntɛnɔ náh wɔ̀kɔ̀npèkè, Yesu yuku Kalile sɔkɔ, à kyɩ tyah nɩ̀vɩ̀nɩ̀ wɛy sã́nnɛ n yo n kɔ̃, nɛ̂-á wil Liyel tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","À nɛ: «Gbĩ́ nɛ̂ tyɩ́-á sõ̀ yo sah, kè mɛ de tɛ. *Liyel tɔ̃́rɩ́ mɛ yĩni tɛ̃ tɛ. Yé yé nnɔ vi mɔ, yé mó sɛ̃ nɩ̀vɩ̀nɩ̀ wɛy sã́n yõ!» ");
INSERT INTO wib_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Wǎh sõ̀ mɛ n kɔ Kalile yɔ́-ǹgbɛ̃ gbɔ̀pɔ gbĩ́ nɛ̂nɛ, à yɛ̃́nkyɔ tɛ̃́pú nɛ́pĩ̂ nímí wɛ, Simo, ànɛ̂ ǹ gbɛ̃̀ndĩ́ Andrelɛ. Pè sõ̀ mɛ yɛ̃́nkyɔ tɛ̃ tɛ̃ mnɔlɛ n min yɛ̃́nkyɔlɛ n tɛ̃ yɔ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","À yo pé tyɩ́ nɛ: «Yé pɔ ńmɔ náh. Mé kɩ yé pɩ névye tɛ̃́púlɛ Liyel tyɩ́.» ");
INSERT INTO wib_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Nɛ́npɔ́ swɔ, pè núkú pé yɛ̃́nkyɔ tɛ̃ tɛ̃ mnɔ sah, tɛ́ ǹ sõ̀ tɛ̃. ");
INSERT INTO wib_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Wǎh tɔ̃ kɔ yuku yahlɛ kwéy, à kyɩ Sebede wɛ̃́npì wɛ, Nsyakɩ ànɛ̂ Nsyɔ̃nɛ. Pè sõ̀ mɛ pé krótókè sɔkɔ, mɛ yɛ̃́nkyɔ tɛ̃ tɛ̃ mnɔlɛ n tɔ̃ n sah. ");
INSERT INTO wib_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ké nɛ́npɔ́ swɔ, à pépi tɔ ye yah. Pè núkú yal pé sú ànɛ̂ ǹ tõ̀npɩbɩ tnɔ̂ krótókè sɔkɔ, tɛ́ ǹ sõ̀ tɛ̃. ");
INSERT INTO wib_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Képah náh, wǎh nónó ye, à yuku pélɛ Kapɛrnayim kwil sɔkɔ. *Mɩ mɩ yòh sṍlɛ, à kyɩ de *Liyel ní-ńsah wɔ̀kɔ̀, à tyah névyelɛ n kwɔ. ");
INSERT INTO wib_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Nónó-á sõ̀ mɛ ǹ wɛynɛ n nohnɩ, pé gbã̀n du ǹ névye kwɔ́nɔ́ dùkùlɛ. Tir yɔ́ náh, kè náh sõ̀ mɛ núkúlɛ ànɛ̂ *Liyel ǹgbò wɛ̃̀kɩ̀ kwɔ́pú tyɩ́lɛ. Ǹmɔ kwɔ dùkù sõ̀ mɛ yõ̀tɔ̃rɩ́ kwɔ́nɔ́lɛ, képah ye. ");
INSERT INTO wib_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ké légbĩ́nɛ, kè pɔ yɩ̃nɛ, dĩ́ yɔ́ sõ̀ mɛ Liyel ní-ńsah wɔ̀kɔ̀, *sétõlɛ ǹ sɔkɔ. À mɛ yuku gbo mɔ nɛ, ");
INSERT INTO wib_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","kwâh nɛ̂ se à n yah n kɔ̃ pépi tyɩ́ nɩ, Nasarɛti Yesu? À se pɔ pépi yɩ́kɩ́-ńsah nɩ? Páh pɩ̃ nɛ, pi kɛ̃́-á ǹnɛ, ǹmɔ nɛ̂-á wil Liyel tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Képah tɛ̃̀nɛ, Yesu dírí kõ sétõ mɛ̀ yõ, tɛ́ yo ǹ tyɩ́: «Á vyãh vike, ǹ tɛ́ n wil dĩ́ mɛ̀ sɔkɔ!» ");
INSERT INTO wib_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Képah sɔkɔ, sétõ dĩ́ mɛ̀ yike kègbɩlɛ, tɛ́ de syi náhnáh, tɛ́ wil ǹ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Képah névye gbã̀n du. Pè tyah wɛ̃nɛ n piki n yah nɛ, kwâh nɛ̂ se sɛ̃́ nɩ? Kwɔ́nɔ́ késã́n yɔ́lɛ à n pɩ yõ̀tɔ̃rɩ́ sɔkɔ. À fɛ̃ n wɛkɩ sétã̀n tɔ yõ, tɛ́ sè n sah ǹ tyɩ́ yõ. ");
INSERT INTO wib_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Kénɛ nɩ́ yõ, Yesu yĩn gbílkínɔ́ tɔ̃ mɔ Kalile kwlo pól sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Pǎh yal *Liyel ní-ńsah wɔ̀kɔ̀, pè núkú yɔ̃ sɔkɔ de Simo ànɛ̂ Andrepi gbô. Nsyakɩ ànɛ̂ Nsyɔ̃ tɔ sõ̀ mɛ pélɛ. ");
INSERT INTO wib_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Tɛ́ Simo dɛ́ysê sõ̀ mɛ sɛ̃́nɔ́lɛ wílvyã́hnɩ̀nɛ. Nɛ́npɔ́ swɔ, pè mɛ kè yo Yesu syah. ");
INSERT INTO wib_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Wǎh kè noh sɛ̃́, à nɔ de pi mɛ̀ tnɔ̂, tɛ́ ǹ gbõ̀ tɛ̃ à yilki sah. Ǹ wílvyã́hnɩ̀ núkú tyɛ, à mɛ yuku tyah pĩ́nnɛ n pɩ pé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Gbĩ́yĩ́-á de, névye pé yámpúnɔ pól twah pɔ Yesu tyɩ́, ànɛ̂ *sétã̀n-á mɛ dénɔ́lɛ nónó sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Kwil névye pól pɔ tuke mɔ kénɛ gbô yah sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","À mɛ yámpú duke duke náhnáh dɛ mɔ, tɛ́ sétã̀n náhnáh yĩni wilki, sǎh mɛ de nónó sɔkɔ. Sè sõ̀ ǹnɛ n pnɛ, nɛ dùkù nɛ̂-á ǹnɛ. Képah ye, à yahle nɛ, sè káh nɛ n wɛkɩ. ");
INSERT INTO wib_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Séngbɔ̃́ púsɔ́, tyah syì syì sɔkɔ, Yesu yuku wil wɔ̀kɔ̀. À yuku gbɛ̃́nnɩ sɔkɔ, à kyɩ tyah Liyellɛ n ni. ");
INSERT INTO wib_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Képah sɔkɔ, Simopi yuku tyah ǹnɛ n yah n kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Pǎh kyɩ à wɛ, pè à syah nɛ, névye pól-á mɛ ǹnɛ n yah n kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","À mɛ yo pé tyɩ́: «Á ye yuku gbɔ̀plɔ kwlo sɔkɔ. Mé yɩ̃nɛ mé nɩ̀vɩ̀nɩ̀ wɛy sã́n yo nɛ́npɔ́ tɔ sɔkɔ. Ń pɔ́nɔ́ yõ ye képahlɛ.» ");
INSERT INTO wib_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Képah sɔkɔ, à kyɩ Kalile tã̀ntã̀n pól sɔkɔ, mɛ Liyel wɛynɛ n yo n kɔ̃ pé *Liyel ní-ńtã̂n vɩ̀ sɔkɔ, tɛ́ mɛ *sétã̀nnɛ n yĩni n wilki névye sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Sṍ yɔ́lɛ, *tótɛ̃ yɔ́ nɔ de Yesu tnɔ̂, à gbètukunɔ di ǹ yah, tɛ́ à ni nɛ, wàh mɛ ké tyɩ́, wǎh kɩ fɛ̃ pé dɛ mɔ. ");
INSERT INTO wib_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Wǎh yo sɛ̃́, ǹ yãm Yesu tɛ̃. À mɛ ǹ gbõ̀ tɔ̃ ǹ yõ, à tũ ǹ tyɩ́, tɛ́ nɛ: «Mé mɛ ké tyɩ́, á kɩ dɛ!» ");
INSERT INTO wib_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Nɛ́npɔ́ swɔ, *dú núkú à fĩn mɔ, à mɛ dɛ. ");
INSERT INTO wib_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Képah sɔkɔ, Yesu núkú à tɛkɩ mɔ, tɛ́ kè gbah yo ǹ tyɩ́ nɛ, ");
INSERT INTO wib_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","à noh yɔ̀, à káh kè yãh nɛ tyɩ́ dɛ́! À kyɩ ǹ gblɔ̌ynɛ *sárká wìlkìpu yõ̀tɛ̃̀ wɛ̃kɩ. Ńkɛ̃, *Moyisi-á sõ̀ *sárká nɛ̂ tyɩ́ yo, tótãm dɛ́nmɔnɔ tyɩ́ sɔkɔ, à mó képah wilki, nɛ̂-á kɩ no pól wɛ̃kɩ n pi nɛ, wǎh dɛ. ");
INSERT INTO wib_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ǹtɛ, dĩ́-á yal ǹ tnɔ̂, tir nɛ̂-á pɩ ǹ tyɩ́, à kyɩ tyah kélɛ n yãh n kɔ̃ no pól tyɩ́. Kǎh pɩ sɛ̃́, Yesu náh tɔ̃ sõ̀ fɛ̃ ǹ gblɔ̌y wɛ̃kɩ n pi kwil yɔ́ ńtɛ̃ sɔkɔ. À sõ̀ mɛ gbɛ mɔ tɛ̃ kwlolɛ, kégbɔ́ sɔkɔ, tɛ́ névye n wil tã̀ntã̀n pól sɔkɔ, à n pɔ n pɔ ǹ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Sèpĩn yísyɔ́ sɔ́kɔ́ntɛnɔ náh, Yesu ǹ syɩ pɔ Kapɛrnayim sɔkɔ. Névye-á kè noh nɛ, wǎh mɛ gbô, ");
INSERT INTO wib_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","tɔ́wû yɔ́ tuke pɔ tyah fyãh. Tɛ̃̀-ǹsah ńtɛ̃ náh sõ̀ mɛ kélé yah tɔ sɔkɔ. Képah sɔkɔ, à tyah ǹ wɛynɛ pélɛ n kwɔ. ");
INSERT INTO wib_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Légbĩ́nɛ, nósyɔ́ pɔ ǹ tyɩ́ sèkùkù yɔ́lɛ. Nɛ́pĩ̂ ǹyẽ̂h sõ̀ mɛ à twah. ");
INSERT INTO wib_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Tɛ́ névye tnɔ́nkàhnɔ́ tɛ̃̀ tyɩ́, pè náh sõ̀ fɛ̃ nɔ n de n pi ǹ tnɔ̂. Pè dɔkɔ gbɛ̃́ntĩ̂n yõ, kye ǹ mɛ́-ńsah tírrlɛ, tɛ́ sèkùkù mɛ̀ tiki mɔ kénɛ pwã̀hlɛ ǹ sɛ̃ sɛ̃ kwâh yõ ǹ yah sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Wǎh kè wɛ, pè sɛ̃ ǹ yõ sɛ̃́, à yo sèkùkù mɛ̀ tyɩ́ nɛ: «Ń pídĩ́, á tyípêl ye yɔ̃ mɔ ǹ kɔ̃.» ");
INSERT INTO wib_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Képah tɛ̃̀nɛ, *Liyel ǹgbò wɛ̃̀kɩ̀ kwɔ́pú nónó-á sõ̀ mɛ tɛ̃̀nɔ́lɛ nɛ́npɔ́ sɔkɔ, pè tyah n sõ nɛ, ");
INSERT INTO wib_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","sɔ̃́ se pɩ, tɛ́ dĩ́ mɛ̀ n wɛkɩ sɛ̃́ nɩ? Liyel yĩn-á à n yɩkɩ. Ké névi se mɛ kɩ fɛ̃ tyípêl yɔ̃ mɔ névi kɔ̃, nɛ́ Liyel náh nɩ? ");
INSERT INTO wib_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Képah sɔkɔ, wǎh núkú pé fɔkɔ sõnɔ wɛ sɛ̃́, à yo pé tyɩ́ nɛ: «Sɔ̃́ pɩ, tɛ́ yé fɔkɔ sõnɔlɛ sɛ̃́? ");
INSERT INTO wib_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Nɛ̂ tɛ̃̀ dɔ̀dɔ̀ kal, à yo sèkùkù mɛ̀ tyɩ́ nɛ, ǹ tyípêl-á yɔ̃ mɔ à kɔ̃, képah náh pɩ, à yuku, ǹ sɛ̃ sɛ̃ kwâh tɔkɔ nɛ n kɔ? ");
INSERT INTO wib_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ǹtɛ, yé pɩ̃ nɛ, tɛ̃́nwɛnɔ-á mɛ *Névi Pi tyɩ́, kɩ fɛ̃ tyípêl yɔ̃ mɔ névye kɔ̃, tɛ́ à sah sétáh yõ.» ");
INSERT INTO wib_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Képah ye, à yo sèkùkù mɛ̀ tyɩ́: «Mé kélɛ n yo á tyɩ́, yuku, á sɛ̃ sɛ̃ kwâh tɔkɔ, ǹ nɛ n yuku á gbô.» ");
INSERT INTO wib_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Nɛ́npɔ́ swɔ, dĩ́ núkú yuku ǹ sɛ̃ sɛ̃ kwâh tɔkɔ sɔkɔ no pól yĩ́ yah. Kè pé pól gbã̀n du. Pè tyah Liyel yĩnnɛ n gbilki, tɛ́ mɛ n yo nɛ, pé náh sɛ̃́nkɔ̃ wɛ yah. ");
INSERT INTO wib_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Képah náh, Yesu tɔ̃ n syɩ yuku Kalile yɔ́-ǹgbɛ̃ gbɔ̀pɔ. Tɔ́wû pól sõ̀ mɛ n pɔ n pɔ ǹ tyɩ́, à pélɛ n kwɔ. ");
INSERT INTO wib_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Wǎh pɔ n sɔkɔ, à Alfe pídĩ́ Levi wɛ tɛ̃̀nɔ́lɛ mɔ́rɩ́ syí-ńsah wɔ̀kɔ̀. À mɛ yo ǹ tyɩ́ nɛ, à yuku pé sõ̀ tɛ̃. Levi mó yuku ǹ sõ̀ tɛ̃. ");
INSERT INTO wib_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Pǎh kyɩ tyah yõkelɛ n yõ Levi tĩ̂nnɛ gbĩ́ nɛ̂nɛ, mɔ́rɩ́ syípú, ànɛ̂ Liyel wɛ̃̀kɩ̀ kɔ́-ńkɛ̃̂pú náhnáh sõ̀ mɛ n yõ ǹnɛ, ànɛ̂ ǹ *tõ̀ sã́hpúlɛ. Kénɛ névye dùkù náhnáh ye sõ̀ mɛ ǹ sõ̀ tɛ̃, képah ye. ");
INSERT INTO wib_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Képah sɔkɔ, *Liyel ǹgbò wɛ̃̀kɩ̀ kwɔ́pú nónó-á sõ̀ *Farisiyɛ̃nɔlɛ, pépi-á à wɛ à mɛ n yõ ànɛ̂ kénɛ névye dùkùlɛ, pè yo ǹ tõ̀ sã́hpú tyɩ́ nɛ, kû se pɩ, tɛ́ à n yõ mɔ́rɩ́ syípú, ànɛ̂ Liyel wɛ̃̀kɩ̀ kɔ́-ńkɛ̃̂púlɛ fɩ̃́ núkú nɩ? ");
INSERT INTO wib_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu-á kénɛ wɛy noh sɛ̃́, à yo pé tyɩ́: «Névye nónó-á mɛ lènɔlɛ, sènpɩ yétõ̂ se mɛ pé tyɩ́? Yámpú tyɩ́ náh sènpɩ yétõ̂lɛ di? Névye nónó-á n sõ nɛ, névye tír tír-á pélɛ, mé náh pɔ pépi ye yĩnnɛ. Ǹtɛ, nónó-á pɩ̃ nɛ, tyípêl pɩ́pú-á pélɛ, pépi yé-ńsah ye mé pɔ.» ");
INSERT INTO wib_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Sṍ yɔ́lɛ, *Wèlnwìlkì-ò Nsyɔ̃ tõ̀ sã́hpú ànɛ̂ *Farisiyɛ̃nɔ sõ̀ mɛ níkì tɛ̃. Névye mɛ kyɩ Yesu piki yah nɛ, kû se pɩ, tɛ́ Nsyɔ̃ tõ̀ sã́hpú ànɛ̂ Farisiyɛ̃nɔ tõ̀ sã́hpú mɛ níkì tɛ̃, tɛ́ ǹmɔ *tõ̀ sã́hpú náh mɛ sɛ̃́ntɛ̃̀nɛ n pɩ nɩ? ");
INSERT INTO wib_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Wǎh képah noh sɛ̃́, à yo pé tyɩ́: «Yépi tɛ̃̀ sõnɔ sɔkɔ, fúr pɩ́-ò-á nónó ye, pè se kɩ fɛ̃ fúr yõke yahle, tɛ́ kɩ fúr pɩ́-ò sah pé nɩyṍ? Pɛ tɛ̃̀-à fyɔ̀ mɛ pé nɩyṍ, pé náh fɛ̃ yõke yahle n pi. ");
INSERT INTO wib_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ǹtɛ, gbĩ́ mɛ n pi, pè kɩ pɔ pɛ mɛ̀ wilki pé nɩyṍ. Ké lésõlɛ, pè kɩ pyě níkì tɛ̃. ");
INSERT INTO wib_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Névi yɔ́ ńtɛ̃ náh fɛ̃ fwɔ sã́n tɔkɔ, à kɩ fwɔ dyàh min n pi. Wâh képah pɩ, fwɔ sã́n kɩ fwɔ dyàh kú-ńsah tɛ́y yɔrɩ yɩkɩ ńtɔ̃, ké pwã̀h kɩ gbɛ mɔ. ");
INSERT INTO wib_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ànɛ̂ tɔ̃, névi náh fɛ̃ dìvɛ̃ sã́n mɔ n pi pley di sɔkɔ. Dìvɛ̃ sã́n-à fũ, kè kɩ pley nɔ́pi sɛkɩ. Dìvɛ̃ kɩ kwɛ, pley tɔ kɩ yɩkɩ. Képah ye, dìvɛ̃ sã́n ye yɩ̃nɛ mɔ́nɔ́lɛ pley snɔ́ sɔkɔ.» ");
INSERT INTO wib_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","*Mɩ mɩ yòh sṍ yɔ́lɛ, Yesu ànɛ̂ ǹ *tõ̀ sã́hpú sõ̀ mɛ n kɔ n kah sèmukɔ swɛ̃y yísyɔ́ sɔkɔ. Képah sɔkɔ, ǹ tõ̀ sã́hpú tyah sèmukɔ ywɔ̃lɛ n kɔ̃lɩ n yuku wɛ̃̀kɩ̀ yah. ");
INSERT INTO wib_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","*Farisiyɛ̃nɔ-á képah wɛ sɛ̃́, pè tyah Yesulɛ n piki n yah nɛ, à yah, kû se pɩ, tɛ́ tir nɛ̂ náh yɩ̃nɛ pɩ́nɔ́lɛ mɩ mɩ yòh sṍlɛ, ǹ tõ̀ sã́hpú kélɛ n pɩ nɩ? ");
INSERT INTO wib_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","À mɛ yo pé tyɩ́: «Kwɛkɩ-á lésõ *Davidi ànɛ̂ ǹ náh névye kah tɛ̃ sṍ nɛ̂nɛ, tɛ́ yõke wɛ́-ńsah náh mɛ pé tyɩ́, pǎh nɛ̂ pɩ, yé náh kè kar yah di? ");
INSERT INTO wib_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","À náh sõ̀ de Liyel wɔ̀kɔ̀ sɔkɔ di? Búrn nónó-á sõ̀ sàhnɔ́lɛ Liyel tyɩ́ yõ, à náh sè tɔkɔ tah, tɛ́ ǹ náhtãn tɔ kɔ̃ pè tah di? Ké légbĩ́nɛ, Abyatar ye sõ̀ *sárká wìlkìpu yõ̀tɛ̃̀ ǹgbɛ̃nɛ. Tɛ́ névi yɔ́ ńtɛ̃ náh sõ̀ yɩ̃nɛ búrn nɔ́pi táhnɔ́lɛ, nɛ́ sárká wìlkìpu yõ̀tãm náh.» ");
INSERT INTO wib_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Képah náh, Yesu tɔ̃ yo pé tyɩ́: «Mɩ mɩ yòh ye sah névi yĩnnɛ, ǹtɛ névi náh mɔ mɩ mɩ yòh yĩnnɛ. ");
INSERT INTO wib_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Képah ye, *Névi Pi pɩ mɩ mɩ yòh ńtɛ̃ yõ̀tɛ̃̀nɛ.» ");
INSERT INTO wib_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Képah náh, Yesu ǹ syɩ de *Liyel ní-ńsah wɔ̀kɔ̀ yɔ́ sɔkɔ. Ké nɛ́npɔ́ sɔkɔ, dĩ́ yɔ́ sõ̀ mɛ gbõ̀lɛ kúnɔ́lɛ. ");
INSERT INTO wib_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","*Farisiyɛ̃nɔ mó tyah Yesulɛ n yah, wàh kɩ ńtyɩ̃́nɔ à dɛ mɔ n pi *mɩ mɩ yòh sṍlɛ, pè mó lékàh wɛ à kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Képah sɔkɔ, Yesu mɛ yo gbõ̀nkù dĩ́ mɛ̀ tyɩ́ nɛ, à yuku n pɔ yĩn névye nɩyṍ. ");
INSERT INTO wib_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Tɛ́ no piki yah: «Tir nɛ̂ wɛ̃̀kɩ̀ mɛ kɔ̃́nɔ́lɛ mɩ mɩ yòh sṍlɛ: Pèpɔrɩ se yɩ̃nɛ pɩ́nɔ́lɛ, tĩ̂ pèkè se? À névi wilki kũ sɔkɔ, tĩ̂ à tɛ̃̀ ko mɔ?» Ǹtɛ, pè náh tir yɔ́ yo. ");
INSERT INTO wib_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Képah sɔkɔ, wǎh pè yah yah yésyẽ̂hlɛ fɔ̀kɔ̀vyã̀hnɩ̀ sɔkɔ, ǹ yah kwɔ pé kùkùtǎhkɩ̀ tɛ̃̀ tyɩ́. À mɛ yo dĩ́ mɛ̀ tyɩ́: «Á gbõ̀ tɔ̃!» À mɛ ǹ gbõ̀ tɔ̃, kè núkú pɩ ké vilɛ. ");
INSERT INTO wib_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Farisiyɛ̃nɔ-á képah wɛ sɛ̃́, pè yuku wil kénɛ Liyel ní-ńsah wɔ̀kɔ̀ sɔkɔ, à núkú kyɩ wɛ̃ tuke mɔ ànɛ̂ yõ̀tɛ̃̀ dĩ́ *Yerɔdi náh névyelɛ Yesu tyɩ́ sɔkɔ, pǎh kɩ pɩ sɔ̃́, tɛ́ à wɛ n ko n mɔ n pi. ");
INSERT INTO wib_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Képah náh, Yesu ànɛ̂ ǹ *tõ̀ sã́hpú yuku Kalile yɔ́-ǹgbɛ̃ gbɔ̀pɔ, tɛ́ tɔ́wû ǹgbɛ̃ yɔ́ sõ̀ mɛ ǹ sõ̀ tɛ̃. Pé túkù n wil Kalile, túkù mó n wil Yude, ");
INSERT INTO wib_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ànɛ̂ Yerusalɛmɩ. Túkù n wil Yidume, túkù n wil Yurdɛ̃ yɔ́nkahnɩnɛ. Túkù mó n wil Tiri ànɛ̂ Sidõ gbɔ̀plɔ kwlo sɔkɔ. Kénɛ tɔ́wû ǹgbɛ̃ ye kyɩ wil ǹ tyɩ́. Pè sõ̀ ǹ tyípɩ́nɔ́ noh, képah yĩn ye. ");
INSERT INTO wib_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Kǎh pɩ sɛ̃́, Yesu yo ǹ tõ̀ sã́hpú tyɩ́ nɛ, pè krótókè yɔ́ tɔ̃ sah pé kɔ̃, tɔ́wû káh pɔ pé fyãh. ");
INSERT INTO wib_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Wǎh sõ̀ mɛ névye náhnáhlɛ n dɛ n mɔ, yámpú pól sõ̀ mɛ n to n tuke ǹ yõ nɛ, pé wɛ tũ ǹ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Tɛ́ *sétã̀n-á sõ̀ mɛ nónó sɔkɔ, pǎh à wɛ, pè pé gbètukunɔlɛ n di n pɔ ǹ yah, tɛ́ n yo ǹ tyɩ́ dénsyinɔ sɔkɔ nɛ, Liyel pi-á ǹnɛ. ");
INSERT INTO wib_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Képah sɔkɔ, à dírí kõ pé yõ, tɛ́ nɛ, pè káh pé dùkùlɛ n yo. ");
INSERT INTO wib_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Sṍ yɔ́lɛ, Yesu dɔkɔ yɔ̃lɩ yɔ́ yõ, tɛ́ wǎh sõ̀ mɛ nónó tyɩ́, à pè ye. Pè pɔ ǹ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Sɛ̃́ ye sõ̀, à yah wilki kènɛ nɛ́pĩ̂ gbɔ̃nimínɛ, à pɩ ǹ tõ̀npɩbɩlɛ. Nɛ, pè nɛ n mɛ pé tnɔ̂, pé nɛ n wɛ n tõ pé wɛy pèpɛy yo n kɔ̃ yĩnnɛ. ");
INSERT INTO wib_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Tɛ́ tɛ̃́nwɛnɔlɛ pè kɔ̃ nɛ̂-á kɩ fɛ̃ *sétã̀n yĩni n wilki n pi. ");
INSERT INTO wib_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Nɛ́pĩ̂ gbɔ̃nimí nɔ́pi yĩni wɛ yɔ̀: Simolɛ, Yesu ǹmɔ yĩn sah Pyɛrɩlɛ. ");
INSERT INTO wib_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Nsyakɩ ànɛ̂ ǹ gbɛ̃̀ndĩ́ Nsyɔ̃nɛ, pépilɛ, Sebede wɛ̃́npì ye sõ̀. À pépi yĩn sah Gbanɛrsyɛsilɛ, ké yõ ye «nónó-á gbɛ̃́nséntã́hkɩ̀ sɔ̃́». ");
INSERT INTO wib_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andre tɔ sõ̀ mɛ, ànɛ̂ Filipe, ànɛ̂ Bartelemi, ànɛ̂ Matye, ànɛ̂ Toma, ànɛ̂ Nsyakɩ, nɛ̂-á Alfe pídĩ́nɛ. À tahlɩ Tade, ànɛ̂ Simolɛ, nɛ̂-á sõ̀ ǹ sú fṍ yõ yɔ̃̀pu sɔkɔ yɔ́lɛ, ");
INSERT INTO wib_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ànɛ̂ tɔ̃ Yisikaryɔti Yudasilɛ, nɛ̂-á pɔ vi Yesu náh. ");
INSERT INTO wib_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Képah náh, Yesu de gbô. Tɔ́wû tɔ̃ tuke ǹ yõ. Wrɔ́ ńtɛ̃ náh sõ̀ mɛ ǹmɔ ànɛ̂ ǹ *tõ̀ sã́hpú tyɩ́ yõke yõ yõ tɛ̃̀nɛ. ");
INSERT INTO wib_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ǹ gbôtãn-á képah noh sɛ̃́, pè yuku wɛ̃̀kɩ̀ tɛ̃ nɛ, páh kɩ kyɩ à tɛ̃, tɛ́ n yo wɛ̃ tyɩ́ nɛ, ǹ lékã́m-á fɛ̃kɩ, wǎh kah mɔ. ");
INSERT INTO wib_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Légbĩ́nɛ, *Liyel ǹgbò wɛ̃̀kɩ̀ kwɔ́pú nónó-á wil Yerusalɛmɩ sɔkɔ, pépi nɛ ńkɛ̃, *sétã̀n yõ̀tɛ̃̀ Belsebul-á mɛ Yesu sɔkɔ. Ǹmɔ tǎhkɩ̀-á à kɔ̃, à tɛ̃ wɛ *sétã̀nnɛ n yĩni n wilki névye sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Képah tɛ̃̀nɛ, à pé ye, tɛ́ tyah n wɛkɩ pé tyɩ́ sèmìrn sɔkɔ: «Sɔ̃́ mɛ sétã̀n yõ̀tɛ̃̀ kɩ fɛ̃ ǹ gblɔ̌y yĩni wilki névi sɔkɔ? ");
INSERT INTO wib_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Yõ̀tɔ̃rɩ́ núkú névye-à tyah wɛ̃nɛ n fwo, kénɛ yõ̀tɔ̃rɩ́ náh n mo n pi. ");
INSERT INTO wib_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Kéte nɛ̂ névye-à tyah wɛ̃nɛ n fwo, kénɛ kéte tɔ náh n mo n pi. ");
INSERT INTO wib_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Sɛ̃́ntɛ̃̀ ó ye, sétã̀n yõ̀tɛ̃̀-à yuku, à ǹ tǎhkɩ̀ tɔkɩ, à tyah wɛ̃nɛ n fwo, ǹ yõ̀tɔ̃rɩ́ kɩ yɩkɩ, kè náh n mo n pi. ");
INSERT INTO wib_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Névi yɔ́ ńtɛ̃ náh fɛ̃ de n pi kètɛ̃̀npɛ tǎhkɩ̀ wɔ̀kɔ̀, kɩ ǹ gbã̀n yî tɔkɔ, nɛ́ à náh à tɛ̃ pukubi. Wàh à tɛ̃ pukubi tɛ gbĩ́ nɛ̂nɛ, à kɩ pyě ǹ wɔ̀kɔ̀ yî kwel. ");
INSERT INTO wib_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Mé kélɛ n yo yé tyɩ́ kègbɩ yõ: Névye-á tyípêl nónó póllɛ n pɩ, ànɛ̂ Liyel gbyɔ̀nɔ́ póllɛ, sè kɩ fɛ̃ yɔ̃ mɔ pè kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ǹtɛ, névi nɛ̂-à *Liyel Mírkí gbyɔ, kè náh n yɔ̃ n mɔ n pi ǹ tyɩ́ póllɛ. À kɩ wũ ké sɔkɔ.» ");
INSERT INTO wib_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","À képah yo sɛ̃́ pé tyɩ́, pǎh sɔ̃́npɩ́ yo nɛ, sétõ-á mɛ ǹ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Képah náh, Yesu-á sõ̀ mɛ ńyãh, ǹ yṹpyé ànɛ̂ ǹ yṹ pɔ yĩni tɛ̃ kénɛ gbô yah, tɛ́ nɛ tɛkɩ mɔ à kyɩ à ye. ");
INSERT INTO wib_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Tɔ́wû sõ̀ mɛ kɔ̃ tɛ̃ Yesu mɔ gbɩ̃, tɛ́ pè yo ǹ tyɩ́ nɛ, à noh yɔ̀, ǹ yṹ, ànɛ̂ ǹ yṹpyé-á mɛ kégbɔ́. Pǎh mɛ ké tyɩ́ nɛ, pé à wɛ. ");
INSERT INTO wib_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","À mɛ yo pé tyɩ́: «Nɛ̂ mɛ ńmɔ yṹnɛ, ànɛ̂ nónó mɛ ń yṹpyélɛ?» ");
INSERT INTO wib_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Képah náh, névye nónó-á sõ̀ mɛ tɛ̃ à mɔ gbɩ̃, à yɔ̃ pè yah kore vi, tɛ́ yo: «Yé yah, ńmɔ yṹ, ànɛ̂ ń yṹpyé mɛ ásõ̂. ");
INSERT INTO wib_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Névi nɛ̂-á Liyel nɩ̀vɩ̀lɛ n pɩ, ǹmɔ ye ńmɔ yṹpi, ànɛ̂ ń yṹnɛ.» ");
INSERT INTO wib_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Sṍ yɔ́lɛ, Yesu tɔ̃ mɛ tyah névyelɛ n kwɔ Kalile yɔ́-ǹgbɛ̃ gbɔ̀pɔ sɔkɔ. Tɔ́wû ǹgbɛ̃ yɔ́ pɔ à mɔ gbɩ̃. Pè tnɔ́nkàhnɔ́ tɛ̃̀ tyɩ́, à de kɔ̃ tɛ̃ krótókè yɔ́ sɔkɔ. Krótókè mɛ̀ sõ̀ mɛ yɔ sɔkɔ, tɛ́ tɔ́wû pól mɛ tɛ̃̀nɔ́lɛ yɔ́ngbalɩ. ");
INSERT INTO wib_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","À sõ̀ mɛ pélɛ n kwɔ tyi náhnáhlɛ sèmìrn sɔkɔ, mɛ n yo pé tyɩ́ ǹ kwɔ́nɔ́ sɔkɔ nɛ: ");
INSERT INTO wib_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«Yé noh! Sṍ yɔ́lɛ, dĩ́ yɔ́ sõ̀ kyɩ ǹ swãh, sèmukɔ mír-ńsah. ");
INSERT INTO wib_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Wǎh mɛ mírnɔ́ sɔkɔ, yísyɔ́ syɩkɩlɩ wɛ̃̀gbalɩ sɔkɔ, kèpye pɔ sè yɔ. ");
INSERT INTO wib_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Yísyɔ́ mɛ syɩkɩlɩ yen kwéy tɛ̃̀-ǹsah légbɩ̃́ yõ, tɛ́ fi súú. Yen gbɩ náh sõ̀ mɛ nɛ́npɔ́, képah ye. ");
INSERT INTO wib_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Gbĩ-á pɔ vyãh sè tɛ̃, sè kɔkɔ. Yã̀hnɩ̀ gbɩ náh sõ̀ mɛ sé tyɩ́, képah ye. ");
INSERT INTO wib_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Yísyɔ́ mɛ kyɩ syɩkɩlɩ pã̀n nɩyṍ. Pã̀n nɔ́pi mɛ yuku fyãh sé yõ, sè náh tɛ̃ wɛ pye pɩ. ");
INSERT INTO wib_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ǹtɛ, yísyɔ́ kyɩ syɩkɩlɩ sétáh pèpɛy sɔkɔ. Sépi mɛ fi, à kyãh pallɛ. Túkù pyenɔ yõgbãm pɩ, túkù tikitɔ̃nɩ́ pɩ, sé túkù mó lèkwɛ̌ pɩ.» ");
INSERT INTO wib_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Képah náh, à tɔ̃ yo pé tyɩ́: «Níkí-á kɩ mɛ nɛ̂ tyɩ́ noh noh tɛ̃̀nɛ, tɛ̃̀ ǹ níkí sah noh.» ");
INSERT INTO wib_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Yesu-á yal tɔ́wû tnɔ̂ gbĩ́ nɛ̂nɛ, nónó-á ńkɛ̃́nɛ nɛ mɛ ǹnɛ, pépi ànɛ̂ ǹ *tõ̀ sã́hpú nɛ́pĩ̂ gbɔ̃nimí mɛ ǹnɛ n piki n yah sèmìrkì mɛ̀ yõlɛ. ");
INSERT INTO wib_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","À mó yo pé tyɩ́: «*Liyel tɔ̃́rɩ́ tyi nónó-á wɔ̃̀bɩ̀nɔ́lɛ, sé pnɛ̀nɔ́ ye yépi tɛ̃̀ wɔ kɔ̃, ǹtɛ kégbɔ́ névye tyɩ́, tyi pól n yo sèmìrn ó sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Képah sɔkɔ, pè kɩ n yah díkídíkí, tɛ́ pè náh kwâh yɔ́ wɛ n pi. Pè kɩ n nohnɩ, tɛ́ pè náh tir yɔ́ pɩ̃ n pi. Nɛ́ képah náh pɩ, pè náhkɩ pé pɩ dùkù vi mɔ, à pé gblɔ̌ynɛ Liyel kɔ̃, tɛ́ náhkɩ pé tyípêl yɔ̃̀nmɔnɔ wɛ.» ");
INSERT INTO wib_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yesu tɔ̃ yɔ̃ sɔkɔ yo pé tyɩ́: «Yé náh sèmìrkì mɛ̀ yõ pɩ̃ di? Ǹtɛ, yé kɩ sèmìrn tɛ́lɔ́ yõ pɩ̃ sɔ̃́? ");
INSERT INTO wib_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Sèmukɔ mír-òlɛ, Liyel wɛy ye à n mir. ");
INSERT INTO wib_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Tɛ́ névye túkù mɛ, á kɩ nɛ wɛ̃̀gbalɩ sɔ̃́, wɛy-á mir mɔ ńyãh sɔkɔ: Pépi-à wɛy mɛ̀ noh, nɛ́npɔ́ swɔ, *sétã̀n yõ̀tɛ̃̀ n pɔ wɛy mɛ̀ wilki pé fɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Túkù tɔ̃ mɛ légbɩ̃́ tɛ̃̀-ǹsah sɔ̃́. Pàh wɛy mɛ̀ noh, pě kè fɛ̃ n syi nɩ̀vɩ̀nɩ̀nɛ. ");
INSERT INTO wib_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Tɛ́ pè náh n yɛ wɛy mɛ̀ yã̀hnɩ̀nɛ n mɔ pé sɔkɔ. Nɛ́npɔ́ swɔ névye ye pélɛ. Képah ye, kwlɔ́nɔ́-à pè yĩni tɛ̃, képah náh pɩ, névi-à pè fõh Liyel wɛy yĩnnɛ, pě pé náh vi súú Liyel wɛy kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Túkù mó tɔ̃ mɛ, á kɩ nɛ pã̀n tɛ̃̀-ǹsah sɔ̃́. Pàh wɛy mɛ̀ noh, ");
INSERT INTO wib_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","kèkõyṍ tyi fɔkɔ sõnɔ, ànɛ̂ tahrɩ ànɛ̂ tyi náhnáh dékè n de pé sɔkɔ. Sépi n pɔ wɛy mɛ̀ fyãh, kè náh n tɛ̃ n wɛ pyelɛ n pɩ. ");
INSERT INTO wib_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Névye túkù mó mɛ, á kɩ nɛ sétáh pèpɛy sɔ̃́: Pépi-à wɛy mɛ̀ noh, pě kè fɛ̃ n syi, ǹ tɛ́ pye pɩ. Túkù pyenɔ yõgbãm pɩ, túkù tikitɔ̃nɩ́ pɩ, túkù n mó lèkwɛ̌ pɩ.» ");
INSERT INTO wib_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Képah náh, à tɔ̃ yo pé tyɩ́: «Névi se kɩ fɛ̃ fɔ̀tnɔ̀ soh, tɛ́ kɩ dú kwĩnki mɔ ké yah, képah náh pɩ, kɩ kè dah mɔ sɛ̃ sɛ̃ kwâh sètàhkɩ̀ sõ̀? À náh kè dɔkɔ n mɔ n pi ké sàh-ǹsah di? ");
INSERT INTO wib_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Tir yɔ́ ńtɛ̃ náh mɛ wɔ̃̀bɩ̀nɔ́lɛ, nɛ̂ náh n wilki n mɔ n pi kégbɔ́. Sètĩ̀n sõ̀ tir yɔ́ ńtɛ̃ náh n wũ n pi wɛ̃́kɩ́-ńkɛ̃̂nɛ. ");
INSERT INTO wib_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Níkí-à mɛ nɛ̂ tyɩ́ noh noh tɛ̃̀nɛ, tɛ̃̀ ǹ níkí sah noh!» ");
INSERT INTO wib_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Tɛ́ tɔ̃ ǹ syɩ yo pé tyɩ́: «Yáh tyi nónónɛ n nohnɩ, yé sélɛ n kyɔmɩ pallɛ. Yáh no tɛ́lɔ́ tyɩ́lɛ n sãh dú nɛ̂nɛ, Liyel kɩ yépi tɔ tyɩ́ sãh n pi kénɛ dú núkúlɛ, tɛ́ dòhnɩ̀nɔ́ ńtɛ̃ kɩ wɛ yépi tyɩ́ yõ. ");
INSERT INTO wib_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kwâh-á mɛ névi nɛ̂ tyɩ́, dòhnɩ̀nɔ́ kɩ pɩ ǹ tyɩ́ yõ ńtɔ̃. Tɛ́, névi nɛ̂ tyɩ́ kwâh náh mɛ, kwéy nɛ̂-á mɛ tɛ̃̀ tyɩ́, képah tɔ kɩ tɛ̃ syi ǹ tyɩ́.» ");
INSERT INTO wib_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Képah náh, à tɔ̃ yo pé tyɩ́: «Yé yah, kwâh nɛ̂-á *Liyel tɔ̃́rɩ́ kètɔ̀lɛ: Kè mɛ, á kɩ nɛ dĩ́ yɔ́ sɔ̃́ nɛ̂-á sèmukɔ mir ǹ swãh sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","À mɛ n dɔ ò, à mɛ n yah ò, lékã̂h ànɛ̂ ké gbĩ̀ntɔ̃̀, sèmukɔ n nɛ mɛ fi, n nɛ n kyãh, à náh ké dùkùlɛ n pnɛ. ");
INSERT INTO wib_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Sétáh ye sèmukɔ mɛ̀ kɔ̃ kè fi ké gblɔ̌y. Sè kètuke wil à pɔ dubi pɩ ywɔ̃lɛ, à yɩ̃́ pɩ. ");
INSERT INTO wib_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Sǎh fyɔ̀ ko tɛ, sèmukɔ tɔkɔ gbĩ́-á nɔ, à yɛ̃́nkwɛ̃́kɩ̀ tɔkɔ kyɩ tyah sélɛ n kõ.» ");
INSERT INTO wib_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","À tɔ̃ yo pé tyɩ́: «Á kɩ fɛ̃ kwâh nɛ̂ tɔkɔ kɩ *Liyel tɔ̃́rɩ́ dùkù wɛ̃kɩ? Képah náh pɩ, sèmìrkì nɛ̂ mɛ mé kɩ yãh kɩ yɩ̃nɛ kélɛ? ");
INSERT INTO wib_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Kè mɛ, á kɩ nɛ mútárdì pi sɔ̃́ tyɩ̃́ɩ̃. Kè yilɔ kal sèmukɔ duke póllɛ. ");
INSERT INTO wib_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Tɛ́, pàh kè duku, kè n yuku n pɔ n pɩ yòhkɩ̀ ǹgbɛ̃nɛ n kal sèmukɔ duke póllɛ swãh sɔkɔ. Ǹtɛ, yɩ̃̀ngbã̀n gbɛkɩ dò, kèpye kɩ fɛ̃ pɔ syɛ̀ pɩ ké sɔkɔ.» ");
INSERT INTO wib_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Sɛ̃́ ye Yesu n kwɔ névyelɛ sèmìrkì mɛ̀ duke náhnáh sɔkɔ. À sõ̀ mɛ sélɛ n yãh n yɩ̃nɛ sé nòhnɩ̀pu pɩ̃ pɩ̃ tɛ̃̀nɛ. ");
INSERT INTO wib_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","À náh sõ̀ n yãh pé tyɩ́ sèmìrn mɩ́-ńkɛ̃̂nɛ. Tɛ́, pàh mɛ pé yahlɛ, ǹmɔ ànɛ̂ ǹ *tõ̀ sã́hpúlɛ, ǎ sé pól yah yo n dal n mɔ pé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ké lésõ ńvɩ̃́nɛ, Yesu yo ǹ *tõ̀ sã́hpú tyɩ́ nɛ, pè yɛ, pé yuku yɔ́-ǹgbɛ̃ kahnɩnɛ. ");
INSERT INTO wib_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Képah sɔkɔ, pè mɛ yal tɔ́wû tnɔ̂. Wǎh sõ̀ mɛ krótókè nɛ̂, ǹ tõ̀ sã́hpú sɔkɔ ǹnɛ képah sɔkɔ. Tɛ́ krótónènɔ́ yísyɔ́ tɔ sõ̀ mɛ ǹnɛ. ");
INSERT INTO wib_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Dǒ, yã́hpékè yɔ́ kõ, à ninɛ n tɔkɔ n mɔ krótókè sɔkɔ pópó, kè pɔ n tyah yúkúnɔ́lɛ ninɛ. ");
INSERT INTO wib_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Tɛ́ légbĩ́nɛ, Yesu sõ̀ mɛ sɛ̃ tɛ̃ n dɔ krótókè sɔkɔ náh tĩ̀nnɛ, tɛ́ mɛ ǹ yõ sah yõ̀sah yõ. Képah sɔkɔ, ǹ tõ̀ sã́hpú kyɩ à yilki mɔ, tɛ́ yo ǹ tyɩ́ nɛ, kwɔ́-ò dĩ́, yɔ-á n tyah pé yṍnɔ́lɛ, kè kó mɛ tirlɛ ǹmɔ tyɩ́ nɩ? ");
INSERT INTO wib_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Wǎh dɔ yuku, à dírí kõ yã́hkɩ́ yõ, tɛ́ yo yɔ tyɩ́: «Yĩn! Tɛ̃ syɩ́syɩ́!» Yã́hkɩ́ núkú yĩn, tyah pɩ sṹmm. ");
INSERT INTO wib_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","À mɛ yo pé tyɩ́: «Kû pɩ, tɛ́ tíkí yé tɛ̃ sɛ̃́? Yé náh tɔ̃̌nɩ̀ sɛ̃ ń yõ di?» ");
INSERT INTO wib_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Képah tɛ̃̀nɛ, tíkí mɛ pè kah tɛ̃. Pè tyah wɛ̃nɛ n piki n yah nɛ, nɛ dùkù nɛ̂ se dĩ́ mɛ̀nɛ, tɛ́ yã́hkɩ́ ànɛ̂ yɔ tɔ n sah ǹ tyɩ́ yõ nɩ? ");
INSERT INTO wib_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Képah náh, pè kyɩ yĩni tɛ̃ Kalile yɔ́-ǹgbɛ̃ kahnɩnɛ, Yerasa tãn sétáh yõ. ");
INSERT INTO wib_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yesu-á fyɔ̀ n tiki krótókè sɔkɔ, nɛ́npɔ́ swɔ, dĩ́ yɔ́ wil léyã̂l wrɔ́, à pɔ à yohnɩ. *Sétõ sõ̀ mɛ kénɛ dĩ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","À sõ̀ mɛ tɛ̃̀nɔ́lɛ léyã̂l wrɔ́. Névi náh sõ̀ fɛ̃ à pukubi n sah n pi kɛ̃́y fyélɛ póllɛ. ");
INSERT INTO wib_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Kèyáhlɛ, pè ńkɛ̃́nɛ kârn mɔ ǹ gbyẽ̂h tyɩ́, ǹ tɛ́ kɛ̃́lɔ́ mɔ ǹ gbã̀n tyɩ́, tɛ́ à kârn kwɔkɩ, ǹ tɛ́ kɛ̃́lɔ́ kɔ̃lɩ. Kǎh pɩ sɛ̃́, ké tǎhkɩ̀ náh sõ̀ mɛ ǹnɩ̂ yɔ́ ńtɛ̃ sɔkɔ, kɩ fɛ̃ à tɛ̃ sah. ");
INSERT INTO wib_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ké lékã̂h, ké gbĩ̀ntɔ̃̀, à sõ̀ ńkɛ̃́nɛ n nɛ n kɔ n kɔ̃ léyã̂l wrɔ́ ànɛ̂ ymɔ sɔkɔ, n nɛ n de n syi, ǹ gblɔ̌ynɛ n pɩ n yɔ n kɔ̃ dyêhlɛ. ");
INSERT INTO wib_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Tɛ́, wǎh Yesu wɛ fɩ́ɩ́ sɔkɔ, à to pɔ gbètukunɔ di ǹ yah. ");
INSERT INTO wib_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Tɛ́ de syi yĩ́npɔ̃́ ǹgbɛ̃nɛ nɛ, Yesu, pé yõ̀tah Liyel pi, kwâh nɛ̂ se à n yah n kɔ̃ pé tyɩ́ nɩ? Páh ǹnɛ n ni Liyel yĩn yõ, à káh pé fõh. ");
INSERT INTO wib_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Yesu sõ̀ mɛ n yo sétõ mɛ̀ tyɩ́ nɛ, à wil dĩ́ mɛ̀ sɔkɔ, képah ye. ");
INSERT INTO wib_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Tɛ́ mɛ à piki yah nɛ, ǹ yĩn se sɔ̃́? À mɛ nɛ, pé yĩn-á Mɛ́fwóbé Kwĩnkilɛ. Páh mɛ dò, képah-á. ");
INSERT INTO wib_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Tɛ́ mɛ à gbah ni nɛ, à káh pé yĩni wilki kwil mɛ̀ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ké nɛ́npɔ́ sɔkɔ, sel kwĩnki yísyɔ́ sõ̀ mɛ n yah n yõ n kɔ̃ yɔ̃lɩ yõ. ");
INSERT INTO wib_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Sétã̀n nɔ́pi Yesu ni nɛ, páh kɩ wil dĩ́ mɛ̀ sɔkɔ, à yɛ pé kɔ̃, pé de sel nɔ́pi sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","À mɛ ké wɛ̃̀kɩ̀lɛ sè kɔ̃. Légbĩ́nɛ, sè mɛ wil dĩ́ mɛ̀ sɔkɔ, tɛ́ kyɩ de sel nɔ́pi sɔkɔ. Sel kwĩnki ye sõ̀ sélɛ, sè kɩ fɛ̃ nɔ sel kèyõ kénkɔ̃lɛ, tɛ́ mɛ tɛ́yõ. Sè núkú to tiki tùkùtùkù, à kyɩ de yɔ́-ǹgbɛ̃ sɔkɔ, kè kɔ̃ kè sè yõ. ");
INSERT INTO wib_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Kǎh pɩ sɛ̃́, sel nɔ́pi fɛ̃̀pu to sɔkɔ kwil nɩyṍ, ànɛ̂ gbnɔ sɔkɔ, à kyɩ ké dùkù yo kɔ̃ no tyɩ́. Képah tɛ̃̀nɛ, névye pɔ ké nɛ́npɔ́, à pɔ ké dùkù yah, sɔ̃́-á kè pɩ. ");
INSERT INTO wib_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Pè kyɩ Yesu tnɔ̂, tɛ́ kyɩ dĩ́ mɛ̀ wɛ, nɛ̂-á sõ̀ sétã̀n kwĩnkilɛ déntɛ̃̀nɔ́lɛ ǹ sɔkɔ. À sõ̀ mɛ flɔ mɔ kɔ̃ tɛ̃, tɛ́ mɛ tírr névye tyɩ́ kɔ̃lɛ. Kǎh pɩ sɛ̃́, tíkí pè tɛ̃. ");
INSERT INTO wib_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Tir nɛ̂-á pɩ sétã̀n nɛ́déné sɔkɔ ànɛ̂ sel tyɩ́, sé wɛ́pú tyah sélɛ n yãh pé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Képah sɔkɔ, kwil tãn tyah Yesulɛ n ni nɛ, à yal pé kwil sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Kǎh pɩ sɛ̃́, Yesu-á n dɔkɔ krótókè sɔkɔ gbĩ́ nɛ̂nɛ, sétã̀n-á wil dĩ́ nɛ̂ sɔkɔ, à tyah ǹnɛ n ni nɛ, à yɛ pé kɔ̃ pé ǹ sõ̀ tɛ̃. ");
INSERT INTO wib_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ǹtɛ, à náh ké wɛ̃̀kɩ̀lɛ à kɔ̃, tɛ́ mɛ yo ǹ tyɩ́: «Á syɩ n kyɩ gbô! Tɛ̃̀-ǹgbɛ̃-á ǹ nɩ̀gbɛ̀kɩ̀ sɔkɔ pèpɔrɩ ǹgbɛ̃ nɛ̂ pɩ á tyɩ́, ǹ kyɩ ké yah yo pé tyɩ́!» ");
INSERT INTO wib_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Dĩ́ mó ńtyɩ̃́nɔ ǹ syɩ kyɩ kélɛ n yo n kɔ̃ Kwlogbãm kwil sétáh yõ, tir nɛ̂-á Yesu pɩ ǹ tyɩ́. Nónó pól-á kélɛ n nohnɩ ǹ tyɩ́, pé gbã̀n du. ");
INSERT INTO wib_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Képah sɔkɔ, Yesu-á yĩni tɛ̃ yɔ́-ǹgbɛ̃ kahnɩnɛ krótókè sɔkɔ, à sõ̀ mɛ yɔ́ngbalɩ sɔkɔ, tɛ́ tɔ́wû ǹgbɛ̃ yɔ́ pɔ à mɔ gbɩ̃. ");
INSERT INTO wib_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Légbĩ́nɛ, *Liyel ní-ńsah wɔ̀kɔ̀ yõ̀tɛ̃̀ yɔ́ yĩni tɛ̃ nɛ́npɔ́, nɛ̂ yĩn-á Yayirusilɛ. Wǎh Yesu wɛ, à gbètukunɔ di ǹ yah, ");
INSERT INTO wib_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","tɛ́ à gbah ni nɛ, pé písê lépír-á mɛ n tyah kúnɔ́lɛ. Páh ǹnɛ n ni, à pɔ kyɩ ǹ gbã̀n sah ǹ yõ. Képah-à pɩ, wǎh kɩ dɛ, tɛ́ kɩ min wɛ. ");
INSERT INTO wib_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Képah sɔkɔ, Yesu mɛ yuku ǹnɛ. Tɛ́ tɔ́wû ǹgbɛ̃ sõ̀ mɛ ǹ sõ̀ tɛ̃, mɛ à fyãh sah ywɔ̃ ywɔ̃ póllɛ. ");
INSERT INTO wib_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Nɛ́npɔ́ sɔkɔ, sê yɔ́ sõ̀ mɛ náhlɛ n yɔ tyɛ́-ńkɛ̃̂nɛ ye gbɔ̃ninɔ́. ");
INSERT INTO wib_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","À sõ̀ kah kwlɔ kègbɩlɛ ǹ gblɔ̌y mɔ́nɔ́ sɔkɔ sènpɩbɩ náhnáh tyɩ́. Ǹ gbã̀n yî pól sõ̀ tyɛ, tɛ́ kè náh kwâh wilki ǹ yam sɔkɔ. Kè pyě mɛ gbɛ ólɛ n gbɛ mɔ. ");
INSERT INTO wib_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Pi mɛ̀-á Yesu tyɩ́ noh ńyãh sɔkɔ, à de tɔ́wû nɩyṍ ǹ náh tĩ̂nnɛ, à kyɩ tũ ǹ fwɔ̀mɔn tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","À sõ̀ mɛ n sõ ǹ fɔkɔ sɔkɔ nɛ, páh náhkɩ wɛ tũ ǹ fwɔ̀mɔn ó tyɩ́, pé ńyân-á náhkɩ tyɛ. ");
INSERT INTO wib_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Wǎh mó núkú tũ ǹ fwɔ̀mɔn tyɩ́, nɛ́npɔ́ swɔ, ǹ náh yɔ́nɔ́ tyɛ. À kè kyɔmɩ wɛ ǹ wil sɔkɔ nɛ, páh dɛ. ");
INSERT INTO wib_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Nɛ́npɔ́ swɔ, Yesu pɩ̃ nɛ, tǎhkɩ̀ yɔ́-á wil pé sɔkɔ. À mɛ ǹ yah vi tɔ́wû nɩyṍ, tɛ́ piki yah nɛ, nɛ̂ se tũ pé fwɔ̀mɔn tyɩ́ nɩ? ");
INSERT INTO wib_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ǹ *tõ̀ sã́hpú mɛ yo ǹ tyɩ́ nɛ, à kó mɛ n yah tɔ́wû à mɔ gbɩ̃, mɛ à fyãh sah ywɔ̃ ywɔ̃ póllɛ, tɛ́ à tɔ̃ mɛ n piki n yah nɛ, nɛ̂ se tũ pé tyɩ́ nɩ? ");
INSERT INTO wib_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ǹtɛ, Yesu mɛ vi ǹ gbɔ̀plɔ névye yah. À sõ̀ mɛ ké tyɩ́ nɛ, pé ké pɩ́-ò wɛ. ");
INSERT INTO wib_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Képah tɛ̃̀nɛ, pi mɛ̀ wil n syah tíkí tyɩ́. Ǹmɔ sõ̀ pɩ̃ tir nɛ̂-á pɩ ǹ sɔkɔ. À yuku kyɩ gbètukunɔ di Yesu yah, tɛ́ ké gbɩ yo dal mɔ à syah. ");
INSERT INTO wib_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","À mó yo pi mɛ̀ tyɩ́: «Ń písê, ńmɔ yõ sɛ̃́nɔ́ ye ǹ dɛ mɔ. Nɛ n yuku yèvɩnɩ sɔkɔ, á ńyân tyɛ.» ");
INSERT INTO wib_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Wǎh mɛ képah yónɔ́ sɔkɔ sɛ̃́, tɛ̃ntõ̀ yɔ́ wil Liyel ní-ńsah wɔ̀kɔ̀ yõ̀tɛ̃̀ dĩ́ gbô, mɛ pɔ n yo kénɛ dĩ́ tyɩ́ nɛ, ǹ písê-á ku. Ńkɛ̃, yõ se tɔ̃ mɛ ké tyɩ́, à tɔ̃ kwɔ́-ò dĩ́nɛ n kwlɔ nɩ? ");
INSERT INTO wib_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Tɛ́ Yesu náh ǹ níkí sah képah tɛ̃̀ noh pé tyɩ́, tɛ́ mɛ yo Yayirusi tyɩ́: «Káh tíkí pɩ, sɛ̃ ó sɛ̃ ń yõ!» ");
INSERT INTO wib_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Képah tɛ̃̀nɛ, pǎh n sɔkɔ, à náh fɛ̃ syi nɛ ǹ sõ̀ tɛ̃, à wil Pyɛrɩ ànɛ̂ Nsyakɩ ànɛ̂ ǹ gbɛ̃̀ndĩ́ Nsyɔ̃ tyɩ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Pǎh kyɩ de Liyel ní-ńsah wɔ̀kɔ̀ yõ̀tɛ̃̀ dĩ́ gbô, Yesu kyɩ névye wɛ, pé mɛ n gbo n mir n kɔ̃, mɛ n de n syi. ");
INSERT INTO wib_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","À mɛ de wɔ̀kɔ̀, tɛ́ yo pé tyɩ́: «Kû pɩ, tɛ́ yé n gbo n mir n kɔ̃ sɛ̃́? Piri náh ku. Dɔ́nɔ́ ó ye à n dɔ.» ");
INSERT INTO wib_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Névye-á képah noh, pè tyah kṍlɛ ǹnɛ n ko. Képah sɔkɔ, à pé pól wilki wɔ̀kɔ̀ sɔkɔ. Tɛ́ piri sú, ànɛ̂ ǹ yṹ, ànɛ̂ ǹ tõ̀ sã́hpú nɛ́pĩ̂ tɔ̃́mɩ́ ó de ǹnɛ piri mɛ́-ńsah wɔ̀kɔ̀. ");
INSERT INTO wib_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","À mɛ piri gbõ̀ tɛ̃, tɛ́ yo ǹ tyɩ́ pé kwil wɛy sɔkɔ: «Talita kumi!», nɛ̂-á pè n ye: «Pípír, mé kélɛ n yo á tyɩ́, yuku!» ");
INSERT INTO wib_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ké nɛ́npɔ́ swɔ, piri yuku tyah n kɔ. Kǎh pɩ sɛ̃́, kè névye pól gbã̀n kah du. Légbĩ́nɛ, ǹ ye gbɔ̃ninɔ́ ye sõ̀. ");
INSERT INTO wib_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Tɛ́ Yesu mɛ ké gbah yo pé tyɩ́ nɛ, pé káh yɛ névye pɩ̃ ké sɔkɔ, ńkɛ̃, pè mó yõkelɛ à kɔ̃ à yõ. ");
INSERT INTO wib_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu-á yal ké nɛ́npɔ́, à kyɩ ànɛ̂ ǹ *tõ̀ sã́hpúlɛ, wǎh sõ̀ kyãh kwil nɛ̂ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","*Mɩ mɩ yòh sṍ-á nɔ, à kyɩ de *Liyel ní-ńsah wɔ̀kɔ̀, à tyah névyelɛ n kwɔ. Nónó-á sõ̀ mɛ n nohnɩ ǹ tyɩ́, pé náhnáh gbã̀n du. Pè tyah n yo wɛ̃ tyɩ́ nɛ, ńyãh se à wɛ kélɛ, nɛ̂ se à kɔ̃ kénɛ lékã́m ànɛ̂ tɛ̃́nwɛnɔlɛ, à fɛ̃ gbǐl mɛ̀ dùkùlɛ n pɩ nɩ? ");
INSERT INTO wib_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ńkɛ̃, ǹmɔ kó sésân sɛ́-ò mɛ̀nɛ, Mari pídĩ́nɛ nɩ? Ǹ yṹpyé kó Nsyakɩ, ànɛ̂ Yose, ànɛ̂ Yude, ànɛ̂ Simolɛ nɩ? Ǹmɔ dósyɔ́ kó pé pól wrɔ́ sɔkɔ ásõ̂ nɩ? Képah sõnɔ ye pè kɔ̃, pè náh sɛ̃ ǹ yõ. ");
INSERT INTO wib_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Képah sɔkɔ, à mɛ yo pé tyɩ́: «*Liyel tɛ̃ntõ̀ syínyo-ò mɛ gbílkínɔ́lɛ névye pól tyɩ́, à wil ǹ súfṍ, ànɛ̂ ǹ no, ànɛ̂ ǹ kétetãn tyɩ́ sɔkɔ. Pépi ye ǹnɛ n yilɔ.» ");
INSERT INTO wib_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Képah ye Yesu kɔ̃, à náh fɛ̃ gbǐl yɔ́ ńtɛ̃ pɩ pé tyɩ́, nɛ́ yámpú yísyɔ́ ó yõ náh. À ǹ gbõ̀ sah pé yõ pè kɔ̃ pè dɛ. ");
INSERT INTO wib_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Tɛ́, ǹ kwil névye-á yahle sɛ̃́nɔ́lɛ ǹ yõ sɛ̃́, kè ǹ gbã̀n du. Képah náh, à yuku gbɔ̀plɔ kwlo sɔkɔ, à kyɩ névyelɛ n kwɔ n kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Képah sɔkɔ, à ǹ *tõ̀ sã́hpú nɛ́pĩ̂ gbɔ̃nimí ye, tɛ́ tyah pélɛ n tõ nímí nímínɛ. Tɛ́ tɛ̃́nwɛnɔlɛ pè kɔ̃ *sétã̀n yõ. ");
INSERT INTO wib_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Tɛ́ mɛ kè gbah yo pé tyɩ́ nɛ, pàh n sɔkɔ pé kɔ́lɔ́ sɔkɔ, pè káh kwâh yɔ́ ńtɛ̃ tɔkɔ, à wil pé kɔ kɔ lépló tyɩ́ sɔkɔ. Pè káh yõke tɔkɔ, pè káh pilki tɔkɔ, pè káh pɔ́ tɔkɔ dah mɔ pé yõ. ");
INSERT INTO wib_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Pè lékyêh wɔ dyɩ, tɛ́ pè káh fwɔ̀mɔlɔnɔ nínɔ́ nínɔ́ mɔ. ");
INSERT INTO wib_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Tɛ́ tɔ̃ yo pé tyɩ́: «Yâh kyɩ kwil yɔ́ sɔkɔ, tɛ́ twah nɛ̂ tyɩ́, yé tɛ̃ nɛ́npɔ́, kè pɔ nɔ yé yálnɔ́ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Kwil nɛ̂ névye-à kyɩ yahle nɛ, yé káh twah pé tyɩ́, tɛ́ yahle yé wɛy nóhnɔ́lɛ, yâh n wil kénɛ kwil sɔkɔ, yé yé gbyẽ̂h nɛ̀ngbɔ̃ kwer n kwɛ nɛ́npɔ́. Képah kɩ pɩ gbáhdyâh dínsàhnɔ́lɛ pé tyɩ́.» ");
INSERT INTO wib_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Képah sɔkɔ, ǹ tõ̀ sã́hpú mɛ sɔkɔ, à kyɩ tyah n yo n kɔ̃ no tyɩ́ nɛ, pè pé nnɔ vi mɔ. ");
INSERT INTO wib_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Pè sõ̀ mɛ sétã̀n náhnáhlɛ n yĩni n wilki névye sɔkɔ, tɛ́ mɛ yámpú náhnáhlɛ n dɛ n mɔ, pàh nɩrɩ tuke tɛ tɛ̃̀ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Légbĩ́nɛ, yõ̀tɛ̃̀ dĩ́ *Yerɔdi sõ̀ mɛ Yesu tyípɩ́nɔ́lɛ n nohnɩ, tir yɔ́ náh, ǹ yĩn sõ̀ mɛ n gbilki ywɔ̃ ywɔ̃ pól sɔkɔ. Túkù nɛ ńkɛ̃, *Wèlnwìlkì-ò Nsyɔ̃-á ǹnɛ, wǎh ǹ syɩ wil lékyɩ̂ wrɔ́, à pɔ. Képah-á à kɔ̃, à tɛ̃ wɛ gbǐlnɔ́lɛ n pɩ. ");
INSERT INTO wib_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Tɛ́, túkù mó nɛ, *Yeli-á. Túkù tɔ̃ nɛ, *Liyel tɛ̃ntõ̀ syínyo-ò yɔ́-á, ǹgbò Liyel tɛ̃ntõ̀ syínyo-ò sɔ̃́. ");
INSERT INTO wib_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Yerɔdi-á sépi pól yónɔ́ noh sɛ̃́, à nɛ, Nsyɔ̃-á, páh sõ̀ pè kɔ̃ pè ǹ yõ kãm, tɛ́ wǎh ǹ syɩ yuku gbáh! ");
INSERT INTO wib_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Kègbɩ yõ, Yerɔdi sõ̀ pè kɔ̃ nɛ, pè Nsyɔ̃ tɛ̃ pukubi dah mɔ wɔ̀kɔ̀npèkè sɔkɔ. Yerɔdyadi yĩn ye à kɔ̃, à képah pɩ. Yerɔdi sõ̀ pi mɛ̀ tɔkɔ kyɩlɛ. Tɛ́ ǹ gbɛ̃̀ndĩ́ Filipe kyɩ ye lésõ ǹnɛ. ");
INSERT INTO wib_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ǹtɛ, Nsyɔ̃ ye sõ̀ ké gbɩlɛ n yo Yerɔdi tyɩ́ nɛ, à náh yɩ̃nɛ à ǹ gbɛ̃̀ndĩ́ kyɩ tɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Kǎh pɩ sɛ̃́, Yerɔdyadi sõ̀ mɛ Nsyɔ̃ dyɔlɛ n yɔ, mɛ ǹ kònmɔ-ńsahlɛ n yah n kɔ̃. Ǹtɛ, à náh mɛ ké syɔ̃̀-ǹsah wɛ. ");
INSERT INTO wib_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Yerɔdi sõ̀ mɛ Nsyɔ̃ yõlɛ n syɩkɩ, képah ye. À sõ̀ mɛ ǹ tíkílɛ n pɩ. À pɩ̃ nɛ, wǎh mɛ tírr pi kɛ̃́nɛ Liyel yah. Wàh sõ̀ ǹ wɛlɔlɛ n nohnɩ, kě ǹ fɔkɔ fɛ̃kɩ. Tɛ́, ǹ wɛlɔ tyɩ́ sõ̀ kah nɔ ǹ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Képah sɔkɔ, Yerɔdyadi pɔ syɔ̃̀-ǹsah yɔ́ wɛ, Yerɔdi dúbínɔ́ yòh vìnpɔnɔ syáh syah sṍlɛ. À sõ̀ ǹ tɔ̃́rɩ́ sɔkɔ nɛ́-ǹgbnɔ ye, ànɛ̂ ǹ mɛ́fwóbé yõ̀tãmnɛ, à tahlɩ Kalile yõ̀tãm pól tyɩ́, tɛ́ yõke ǹgbɛ̃ pɩ pé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Képah sɔkɔ, Yerɔdyadi písê de kyɩ yɔ̃ yi pé mɛ́-ńsah wɔ̀kɔ̀. Kǎh pɩ sɛ̃́, ǹ tyɩ́ nɔ Yerɔdi ànɛ̂ ǹ náh névye tyɩ́. À mɛ yo pípír tyɩ́ nɛ, wàh kɩ mɛ kwáhdúkú nɛ̂ tyɩ́, à kè yo, páh kɩ kélɛ à kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Tɛ́ ǹ wo ǹ tyɩ́ nɛ, wàh kɩ kwáhdúkú nɛ̂ tyɩ́ yo, páh kɩ kélɛ à kɔ̃, kàh kɩ sɔ̃́ pɩ pé yõ̀tɔ̃rɩ́ tɔ́nɩ́nɛ. ");
INSERT INTO wib_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Wǎh yo sɛ̃́, pípír mɛ wil kyɩ ǹ yṹ piki yah nɛ, pé se yɩ̃nɛ pé kwâh nɛ̂ tyɩ́ yo nɩ? Ǹ yṹ mó núkú à syah nɛ, à kyɩ yo ǹ tyɩ́ nɛ, à Wèlnwìlkì-ò Nsyɔ̃ yõlɛ pé kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Képah tɛ̃̀nɛ, pípír núkú ǹ syɩ súú, à pɔ yo yõ̀tɛ̃̀ dĩ́ tyɩ́ nɛ, à pɔ pé kɔ̃ Wèlnwìlkì-ò Nsyɔ̃ yõlɛ yɛ̃́víkì sɔkɔ núkúnúkú yɔ̀. ");
INSERT INTO wib_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Wǎh yo sɛ̃́, kè pɩ yèkwɔrɩlɛ yõ̀tɛ̃̀ dĩ́ Yerɔdi tyɩ́ kègbɩlɛ. Tɛ́, à náh sõ̀ mɛ ké tyɩ́ nɛ, pé pé vyãh vi pé wónɔ́ yĩnnɛ pé náh névye yĩ́ yah. ");
INSERT INTO wib_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Nɛ́npɔ́ swɔ, yõ̀tɛ̃̀ dĩ́ núkú ǹ tyah syɩ́kɩ́pú sɔkɔ nɛ yɔ́ tɛkɩ mɔ nɛ, à kyɩ Nsyɔ̃ yõ kãm pɔ. Kénɛ dĩ́ mó kyɩ Nsyɔ̃ yõ kãm wɔ̀kɔ̀npèkè sɔkɔ, ");
INSERT INTO wib_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","tɛ́ pɔ kélɛ pípír kɔ̃ yɛ̃́víkì sɔkɔ. À mó kyɩ kélɛ ǹ yṹ kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Nsyɔ̃ *tõ̀ sã́hpú-á képah noh sɛ̃́, pè pɔ ǹ lékó tɔkɔ, à kyɩ yɩ̃ léyɛ̃́kɩ̀ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Képah náh, Yesu tõ̀npɩbɩ pé syɩ pɔ ǹ tnɔ̂, à pɔ pé tyípɩ́nɩ̀ ànɛ̂ pé névye kwɔ dùkù pól yo à wɛ̃kɩ. ");
INSERT INTO wib_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Tɛ́ légbĩ́nɛ, pɔ́pú ànɛ̂ sɔ́kɔ́pú sõ̀ mɛ dò. Yõke yõ yõ wrɔ́ ńtɛ̃ náh sõ̀ mɛ Yesu ànɛ̂ ǹ *tõ̀ sã́hpú tyɩ́. Kǎh pɩ sɛ̃́, à yo pé tyɩ́ nɛ: «Yé pɔ, á yuku gbɔ̀pɔlɛ, yé kyɩ mɩ yah kwéy.» ");
INSERT INTO wib_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Pè mɛ de pé yahlɛ krótókè yɔ́ sɔkɔ, à gbɛ mɔ névyelɛ. ");
INSERT INTO wib_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Tɛ́ névye náhnáh-á pè wɛ sɔ́kɔ́-ńsah, pè n gbɛ n mɔ sɛ̃́, pè mɛ pɩ̃, fɩ̃́ nɛ̂-á pè n yuku. Pè núkú wil ywɔ̃ ywɔ̃ pól sɔkɔ tólɔ́lɛ gbáhkɩ̀ yõ, à Yesupi dyàh tɛ̃ kyɩ de nɛ́npɔ́. ");
INSERT INTO wib_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesu-á wil krótókè sɔkɔ, tɛ́ tɔ́wû ǹgbɛ̃ mɛ̀ wɛ sɛ̃́, pé yãm à tɛ̃. Tir yɔ́ náh, pè sõ̀ mɛ, á kɩ nɛ yípɛ̃̂ sɔ̃́, fɛ̃̀-ò kɛ̃́nɛ sé tyɩ́. Képah sɔkɔ, à tyah pélɛ ǹ kwɔ tyi náhnáhlɛ. ");
INSERT INTO wib_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ńvɩ̃́-á pɔ nɔ, ǹ tõ̀ sã́hpú nɔ de ǹ tnɔ̂, tɛ́ yo ǹ tyɩ́ nɛ, ńvɩ̃́-á syi pɔ nɔ, tɛ́ tyah mɛ̀-á gbɛ̀nmɔnɔlɛ. ");
INSERT INTO wib_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Wǎh náh ké wɛ̃̀kɩ̀lɛ névye kɔ̃, pè kyɩ yõke yah dwe gbɔ̀plɔ gbnɔ ànɛ̂ kwlo sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","À mɛ yo pé tyɩ́ nɛ, pépi yõkelɛ pè kɔ̃, pè yõ. Pè mɛ à piki yah nɛ, à se nɛ, pépi yõke dwe pè kɔ̃ pɔ́ plɔ́ lègbãmnɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","À mɛ pè piki yah nɛ, búrn plɔ́ sɔ̃́ se mɛ pé tyɩ́ nɩ? Ńkɛ̃, pè kyɩ yah tɛ. Pǎh kyɩ piki yah, pè pɔ yo ǹ tyɩ́ nɛ, búrn plɔ́ kwlɔ́-á mɛ pé tyɩ́, ànɛ̂ yɛ̃́nkyɔ plɔ́ nínɔ́lɛ. ");
INSERT INTO wib_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Képah tɛ̃̀nɛ, Yesu nɛ, pè névye pól kɔ̃ pè kɔ̃ tɛ̃ tĩ̀n tĩ̀nnɛ fílkì yõ. ");
INSERT INTO wib_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Névye mó kɔ̃ tɛ̃ tĩ̀n tĩ̀nnɛ, lèkwɛ̌kwɛ ànɛ̂ tíkíníní pɔ́ gbãm gbãmnɛ. ");
INSERT INTO wib_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Pǎh kɔ̃ tɛ̃ tɛ, Yesu búrn plɔ́ kwlɔ́ ànɛ̂ yɛ̃́nkyɔ plɔ́ nínɔ́ nɔ́pi tɔkɔ, à ǹ yah yɔ̃ yĩ̂nyõ, tɛ́ wɛkɩ Liyel tyɩ́, tɛ́ búrn kwɔkɩ pè kɔ̃ nɛ, pè dibi névye kɔ̃. Tɛ́ yɛ̃́nkyɔ nɔ́pi tɔ dibi névye pól kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Képah tɛ̃̀nɛ, pé pól yõ tɔ̃, ");
INSERT INTO wib_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","tɛ́ pè tɔ̃ pé búrn ànɛ̂ yɛ̃́nkyɔ yṍnkwlɔnɔ tɛ́lɔ́ tuke mɔ gbétɔ́lɔ́ yɩ̃́ gbɔ̃ninɔ́lɛ. ");
INSERT INTO wib_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Tɛ́ nónó-á sõ̀ yõke mɛ̀ yõ, pè sõ̀ mɛ díbí nɛ́pĩ̂ kèyõ nínɔ́ kyɛgbãmnɛ. ");
INSERT INTO wib_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Nɛ́npɔ́ swɔ, Yesu ǹ *tõ̀ sã́hpú kyɩ̃ mɔ, pè de krótókè sɔkɔ nɛ, pè yuku pé yahlɛ yɔ́-ǹgbɛ̃ kahnɩnɛ, Besayida kwil sɔkɔ. Péwɔ mó tɔ́wû fĩn mɔ. ");
INSERT INTO wib_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Wǎh pè fĩn mɔ tɛ, à yuku yɔ̃lɩ yɔ́ yõ, à kyɩ Liyellɛ n ni. ");
INSERT INTO wib_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Lékã̂h-á mɔ, krótókè sõ̀ mɛ yɔ nɩyṍ, tɛ́ ǹmɔ ó mɛ kènkwã̀h yõ. ");
INSERT INTO wib_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Dǒ, à ǹ tõ̀ sã́hpú wɛ, yã́hkɩ́ mɛ pélɛ n yohnɩ, pè mɛ n kwlɔ krótókè vyɔ́nmɔnto-ńsah. Tyah dal gbĩ́nɛ, à tyah n kɔ n yuku pé tírrlɛ yɔ yõ̀tah, à n yuku pé kàl-ǹsah. ");
INSERT INTO wib_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Pǎh à wɛ, à n kɔ sɛ̃́ yɔ yõ̀tah, pè wɛ nɛ, lékó mírkí yɔ́-á, tɛ́ tyah n de n syi. ");
INSERT INTO wib_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Pé pól-á à wɛ sɛ̃́, pé sãm yɔkɔ. Ǹtɛ, nɛ́npɔ́ swɔ, à yo mɔ pé tyɩ́ nɛ: «Yé yé nɩ syãh, ńmɔ ye. Yé káh tíkí pɩ.» ");
INSERT INTO wib_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Tɛ́ de krótókè sɔkɔ pé tnɔ̂, yã́hkɩ́ mó yĩn. Kè pɩ gbɛ̃̀ndùnìnɛ náhnáh pé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Wǎh búrn pɩ dò gbǐl nɛ̂ sɔkɔ, pè náh sõ̀ ké dùkù pɩ̃, képah ye. Pé lékã́m sõ̀ kah tɛkɩ ké pɩ̃́nɔ́lɛ. ");
INSERT INTO wib_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Pǎh yɔ́-ǹgbɛ̃ kah, pè yĩni tɛ̃ Yenesarɛti sétáh yõ, tɛ́ pé krótókè yĩn mɔ yɔ vyãh tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Pǎh fyɔ̀ n tiki krótókè sɔkɔ, névye núkú Yesu yah pɩ̃. ");
INSERT INTO wib_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Pàh noh nɛ, wǎh mɛ ńyãh sɔkɔ, pè n tyah pé yámpúlɛ n twah pé sɛ̃ sɛ̃ yî sɔkɔ ywɔ̃ ywɔ̃ póllɛ, nɛ n pɔ n pɔ ǹ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Yesu-à de ńyãh dùkù nɛ̂ sɔkɔ, kwil ǹgbnɔ ànɛ̂ kwílpyé ànɛ̂ gbnɔ, névye pé yámpúnɔlɛ n twah n pɔ ǹ tyɩ́ pé tɔ́wû tùkè-ǹtã̀n sɔkɔ. Pè n pɔ n tyah ǹnɛ n fal nɛ, à yɛ pé kɔ̃, pé wɛ tũ ǹ fwɔ̀mɔn vyãh ó tyɩ́. Nónó pól-à fyɔ̀ wɛ tũ ǹ fwɔ̀mɔn vyãh tyɩ́, pè n mó n dɛ. ");
INSERT INTO wib_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Sṍ yɔ́lɛ, *Farisiyɛ̃nɔ ànɛ̂ *Liyel ǹgbò wɛ̃̀kɩ̀ kwɔ́pú túkù wil Yerusalɛmɩ, à tuke mɔ pɔ Yesu tnɔ̂. ");
INSERT INTO wib_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Pè pɔ kè kyɔmɩ wɛ nɛ, ǹ *tõ̀ sã́hpú túkù-á mɛ n yõ gbɛ̃̀nsìllɛ. Pè náh mɛ pé gbã̀nnɛ n kãm n wu pé ǹgbòtãn tyɩ́ kɔ̃lɛ. ");
INSERT INTO wib_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Tɛ́, Farisiyɛ̃nɔ ànɛ̂ *Nsyifunɔ tɛ́lɔ́ pól sõ̀ ǹgbòtãn wɛ̃̀kɩ̀ mɛ̀ sàhnɔ́lɛ n kɔ. Pè náh sõ̀ yõkelɛ n yõ, nɛ́ pè náh pé gbã̀n kãm wu pallɛ. ");
INSERT INTO wib_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Pàh wil pɔ yòh sɔkɔ, pè náh yõkelɛ n yõ pé kã̀mnwèl-ǹkɛ̃̂nɛ. Pè sõ̀ pé ǹgbòtãn pɩ dùkùnɔ́ náhnáh yísyɔ́ tɔ tɛ̃ yĩ́ĩ́ kègbɩlɛ, sɔ̃́-á wóhnɔ, ànɛ̂ pní, ànɛ̂ kɛ́sɛ̂n ànɛ̂ sɛ̃ sɛ̃ yînɔ́ wúnɔ́ dùkù pèpɛynɛ. ");
INSERT INTO wib_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Képah ye, Farisiyɛ̃nɔ ànɛ̂ Liyel ǹgbò wɛ̃̀kɩ̀ kwɔ́pú mɛ Yesu piki yah nɛ, kû se pɩ, tɛ́ ǹ tõ̀ sã́hpú náh mɛ ǹgbòtãn tyi sàhnɔ́lɛ n pɩ, tɛ́ n yõ pé gbã̀n kã̀mnwu-ńkɛ̃̂nɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Képah sɔkɔ, à mɛ yo pé tyɩ́: «Gbɩ lésõ mɛ *Yesayi tyɩ́, wǎh Liyel wɛy nɛ̂ yo yépi vyɛ̃y nini wɛ́kɩ́pú tyɩ́ sɔkɔ. Sɛ̃́ ye sõ̀ à wãrkɩ sah kélɛ: ‹Kénɛ névyelɛ, pè ńnɛ n gbilki vyãh ó sɔkɔ, tɛ́ pé nɩ mɛ fɩ́ɩ́ ńnɛ. ");
INSERT INTO wib_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Nírí nɛ̂-á pè n nɛ n pɩ ńmɔ tyɩ́, nɔ̀nɔ́ ye kélɛ. Tir yɔ́ náh, kwɔ́nɔ́ nɛ̂-á pè n nɛ n kɔ̃, névye sàhnɔ́ ye kélɛ, ńmɔ tyɩ́ náh.›» ");
INSERT INTO wib_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Yesu tɔ̃ yɔ̃ sɔkɔ yo pé tyɩ́: «Yépǐ Liyel tyi kõ̀nsàhnɔ́lɛ n milki, ǹ tɛ́ névye tyɩ́ sàhnɔ́lɛ n pɩ. ");
INSERT INTO wib_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yě n gbah n tɛ̃ Liyel tyi kõ̀nsàhnɔ́ yahle, ǹ tɛ́ yé ǹgbò wã̀llɛ n kɔ! ");
INSERT INTO wib_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Sɔ̃́-á sõ̀ *Moyisi yo nɛ, névi-á yɩ̃nɛ à ǹ sú ànɛ̂ ǹ yṹnɛ n gbilki. Képah náh pɩ, névi nɛ̂-à ǹ sú ànɛ̂ ǹ yṹ yilɔ, tɛ̃̀-á yɩ̃nɛ kònmɔnɔlɛ. ");
INSERT INTO wib_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ǹtɛ, yépǐ névyelɛ n kwɔ nɛ, névi-à yo ǹ sú tyɩ́, képah náh pɩ, ǹ yṹ tyɩ́ nɛ, páh sõ̀ nɛ, pé kwâh nɛ̂nɛ à kɔ̃, páh kélɛ Liyel kɔ̃ tɛ. ");
INSERT INTO wib_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Yě ké gbɩ syi tɛ̃̀ kɔ̃ nɛ, à náh tɔ̃ yɩ̃nɛ à tir yɔ́ pɩ ǹ sú tyɩ́, képah náh pɩ ǹ yṹ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Kénɛ pɩ dùkù sɔkɔ ye, yě Liyel wɛy pɩ nɔ̀nɔ́ tirlɛ yé ǹgbò wã̀l kwɔ́nɔ́ sɔkɔ. Ànɛ̂ yě n tɔ̃ sɛ̃́nknɔ náhnáhlɛ n pɩ.» ");
INSERT INTO wib_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Képah náh, Yesu ǹ syɩ tɔ́wû ye tuke, tɛ́ yo pé tyɩ́: «Yé póllɛ, yé noh ń tyɩ́, yé mó pɩ̃ nɛ, ");
INSERT INTO wib_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","kwâh yɔ́ ńtɛ̃ náh n wil kégbɔ́, à n de névi sɔkɔ, tɛ́ kɩ fɛ̃ tɛ̃̀ silki. Tɛ́, tyi nónó-á n wil névi sɔkɔ, sépi-á n silki ǹnɛ.  ");
INSERT INTO wib_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Níkí-à mɛ nɛ̂ tyɩ́ noh noh tɛ̃̀nɛ, tɛ̃̀ ǹ níkí sah noh!» ");
INSERT INTO wib_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yesu-á yal tɔ́wû tnɔ̂, tɛ́ kyɩ de gbô gbĩ́ nɛ̂nɛ, ǹ *tõ̀ sã́hpú ǹnɛ n piki n yah sèmìrkì mɛ̀ yõlɛ. ");
INSERT INTO wib_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","À mɛ pè syah nɛ, lékã́m kɛ̃́ névye se pépi tɔlɛ nɩ? Pè kó pɩ̃ nɛ, névi-á kwâh nɛ̂nɛ n dah n mɔ ǹ vyãh, képah náh fɛ̃ tɛ̃̀ silki n pi nɩ? ");
INSERT INTO wib_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Kè náh n de ǹ nɩ sɔkɔ. Kǎh ńkɛ̃́nɛ n de ǹ kèkùrkì sɔkɔ, à kɔ̃ à n kyɩ n wilki n kwɛ, wàh de fílkì. Kénɛ wɛy sɔkɔ ye à yo pé tyɩ́ nɛ, yõkenɔ pól-á kɩ fɛ̃ yõ. ");
INSERT INTO wib_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Tɛ́ tɔ̃ yo pé tyɩ́: «Tyi nónó-á n wil névi fɔkɔ, sépi ye ǹnɛ n silki Liyel yah. ");
INSERT INTO wib_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Fɔkɔ sõnɔ túkúnì nónó-á n wil névi sɔkɔ, sépi ye à kɔ̃, ǎ ǹ minnɛ n pɩ fɔ̀fɩ́kɩ̀ sɔkɔ, ànɛ̂ yɩ̃be, ànɛ̂ kònmɔnɔ, ");
INSERT INTO wib_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ànɛ̂ syɔ́ yõ yɩ́kɩ́nɔ́, ànɛ̂ yĩ́ yúkú-ńkɛ̃̂ sɔkɔ, ànɛ̂ nɛ́pékè, ànɛ̂ yĩ́vî, ànɛ̂ sen kú-ńkɛ̃̂ sɔkɔ, ànɛ̂ dyɔ́ yɔ́nɔ́, ànɛ̂ névye yĩn yɩ́kɩ́nɔ́, ànɛ̂ gblɔ̌y gbílkínɔ́, ànɛ̂ tɔ̃ lékã́m kɛ̃́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Kénɛ tyítúkúnì pól n wil névi sɔkɔ, à ǹnɛ n silki Liyel yah.» ");
INSERT INTO wib_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Képah náh, Yesu yal nɛ́npɔ́, à yuku Tiri sétáh yõ. À kyɩ wɔ̃bɩ twah gbô yɔ́ sɔkɔ. À náh sõ̀ mɛ ké tyɩ́ nɛ, nɛ pɩ̃ nɛ, páh mɛ nɛ́npɔ́. Tɛ́, à náh tɛ̃ wɛ wɔ̃bɩ. ");
INSERT INTO wib_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Nɛ́npɔ́ swɔ, pi yɔ́ sõ̀ mɛ, *sétõlɛ ǹ písê sɔkɔ. Wǎh Yesu tyɩ́ noh sɛ̃́, à núkú pɔ gbètukunɔ di ǹ yah. ");
INSERT INTO wib_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Pi mɛ̀nɛ, *Nsyifu nɛ náh sõ̀ ǹnɛ. À sõ̀ dubi Siri sétáh yõ, Fenisi sɔkɔ. Wǎh pɔ, à sõ̀ mɛ Yesulɛ n ni nɛ, à sétõ yĩni wilki pé písê sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Képah tɛ̃̀nɛ, Yesu mɛ yo ǹ tyɩ́ nɛ, à yɛ wɛ̃́npì ǹgbò kɔ̃, pè yõ tɔ̃. Wɛ̃́npì yõke náh yɩ̃nɛ kè tɔkɔ mɔ pã̀hnpye kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Pi mɛ̀ mó yo ǹ tyɩ́ nɛ, gbɩ-á, pé Tɛ̃̀-ǹgbɛ̃. Ǹtɛ, wɛ̃́npì-á yõkelɛ n yõ, yɛ̃́nmîr nónó-à n syɩkɩlɩ sétáh, pã̀hnpye kó ńkɛ̃́nɛ sépilɛ n tõ n yõ nɩ? ");
INSERT INTO wib_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Képah sɔkɔ, à yo pi mɛ̀ tyɩ́: «Á wɛy mɛ̀ yĩnnɛ, á syɩ n to n yuku. Sétõ ye wil á písê sɔkɔ.» ");
INSERT INTO wib_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Kǎh pɩ sɛ̃́, à mɛ ǹ syɩ to yuku gbô, à kyɩ ǹ písê wɛ sɛ̃́nɔ́lɛ sɛ̃ sɛ̃ kwâh yõ. Sétõ sõ̀ wil tɛ ǹ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Képah náh, Yesu yal Tiri sétáh yõ, à kyɩ sɔkɔ Sidõ kwillɛ, tɛ́ pyě Kwlogbãm kwil sétáh kah, à yuku Kalile yɔ tĩ̂nnɛ. ");
INSERT INTO wib_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Nósyɔ́ mɛ níkítũ̂ yɔ́ tɛ̃ pɔ ǹ tyɩ́, màhmàhkɩ̀ wɛ́kɩ́-òlɛ, tɛ́ mɛ à ni nɛ, à ǹ gbõ̀ sah ǹ yõ. ");
INSERT INTO wib_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Képah sɔkɔ, à dĩ́ mɛ̀ tɛ̃ wil, à gbɛ mɔ tɔ́wûlɛ, à kyɩ ǹ kèngblɔ dah mɔ dĩ́ ní sɔkɔ, tɛ́ sĩn mɔ, à tuke ǹ nɛ́npɔ́rɩ́ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Tɛ́ ǹ yah yɔ̃ yĩ̂nyõ, à mɩ dɔkɔ, tɛ́ yo dĩ́ tyɩ́ pé kwil wɛy sɔkɔ: «Efata», nɛ̂-á pè n ye: «Yɩkɩ n mɔ.» ");
INSERT INTO wib_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Nɛ́npɔ́ swɔ, dĩ́ ní yɩkɩ mɔ, ǹ nɛ́npɔ́rɩ́ dɛ mɔ, à tyah n wɛkɩ tírr. ");
INSERT INTO wib_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Tɛ́, Yesu mɛ pè sni nɛ, pè káh kélɛ n yo n kɔ̃ névye tyɩ́. Tɛ́, wǎh pélɛ n sni sɔ̃́, pè pyě wãnnɛ n mɔ ké yónkɔ̃nɔ yõ. ");
INSERT INTO wib_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Pé gbã̀n kàhndunɔ tɛ̃̀ tyɩ́, pè tyah n yo wɛ̃ tyɩ́ nɛ, gbɩ yõ, ǹ tyípɩ́nɔ́ pól-á mɛ kah plɛ! Wǎh níkítũbi nínɛ n yɩkɩ, tɛ́ kèdyɔ̀nɩ̀ nɛ́npɔ́rɩ́lɛ n dɛ n mɔ. ");
INSERT INTO wib_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Kénɛ sèpĩ̀n sɔkɔ, tɔ́wû ǹgbɛ̃ yɔ́ tɔ̃ sõ̀ mɛ tùkènmɔnɔlɛ Yesu tnɔ̂. Tɛ́ yõ yõ kwâh náh sõ̀ mɛ pé tyɩ́ sɛ̃́, à ǹ *tõ̀ sã́hpú ye, tɛ́ mɛ yo pé tyɩ́ nɛ, ");
INSERT INTO wib_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","tɔ́wû mɛ̀ yãm-á mɛ pé tɛ̃. Pé sèpĩ̀n tɔ̃́nɩ̀-á ànɛ̂ péwɔlɛ yɔ̀, tɛ́ yõ yõ kwâh náh mɛ pé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Páh kɩ pè fĩn mɔ, pè sɔkɔ kwɛkɩlɛ, pǎh kɩ kah kwlɔ wɛ̃̀kɩ̀ yah. Pé túkù-á n wil fɩ́ɩ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Képah tɛ̃̀ sɔkɔ, ǹ tõ̀ sã́hpú yo ǹ tyɩ́ nɛ, pé se kɩ fɛ̃ wɛ ńyãh yõkelɛ gbɛ̃́nnɩ mɛ̀ sɔkɔ, kɩ pè kɔ̃, pè kɩ yõ tɔ̃ nɩ? ");
INSERT INTO wib_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","À mɛ pè piki yah nɛ, búrn plɔ́ sɔ̃́ se mɛ pé tyɩ́ nɩ? Pè mɛ nɛ, kwǎrnínɔ́-á. ");
INSERT INTO wib_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Képah sɔkɔ, à tɔ́wû kɔ̃ pè kɔ̃ tɛ̃ sétáh, tɛ́ búrn plɔ́ kwǎrninɔ nɔ́pi tɔkɔ, à wɛynɛ Liyel kɔ̃, tɛ́ sè kwɔkɩ ǹ tõ̀ sã́hpú kɔ̃ nɛ, pè syi dibi névye kɔ̃. Pè mó sè syi dibi pè kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Yɛ̃́nkyɔ́pì yísyɔ́ tɔ sõ̀ mɛ pé tyɩ́. À wɛkɩ Liyel tyɩ́ sé tyɩ́ yõ, tɛ́ nɛ, pè sé tɔ tɔkɔ dibi pè kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Képah tɛ̃̀nɛ, pé pól yõ tɔ̃, tɛ́ ǹ tõ̀ sã́hpú yṍnkwlɔnɔ tɛ́lɔ́ tuke mɔ tɔkɔ yɩ̃́ kwǎrninɔ. ");
INSERT INTO wib_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Tɛ́ nónó-á sõ̀ mɛ nɛ́npɔ́, pè nɔ nɛ́pĩ̂ kèyõ nínɔ́ kénkɔ̃lɛ. Képah náh, à pè fĩn mɔ, ");
INSERT INTO wib_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","tɛ́ mó núkú de krótókè sɔkɔ ànɛ̂ ǹ tõ̀ sã́hpúlɛ, à yuku Dalmanuta kwil sétáh yõ. ");
INSERT INTO wib_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Képah tɛ̃̀ sɔkɔ, *Farisiyɛ̃nɔ pɔ tyah yékã̂blɛ n pɩ Yesulɛ, tɛ́ ǹ sõ̀lɛ n mɔ n yah nɛ, à gbǐl yɔ́ pɩ pé yah, nɛ̂-á kè wɛ̃kɩ n pi nɛ, wǎh n wil Liyel tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Képah sɔkɔ, Yesu mɩ dɔkɔ náhnáh, tɛ́ yo pé tyɩ́: «Kû pɩ, tɛ́ kwɛy gbĩ névye gbǐlnɛ n yah n kɔ̃? Kègbɩ yõ, mé kélɛ n yo yé tyɩ́, gbǐl yɔ́ ńtɛ̃ náh pè wɛ̃kɩ n pi!» ");
INSERT INTO wib_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Tɛ́ yal pé tnɔ̂, à de krótókè, à yuku yɔ́-ǹgbɛ̃ kahnɩnɛ. ");
INSERT INTO wib_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Légbĩ́nɛ, Yesu *tõ̀ sã́hpú sõ̀ pé dyɔ fwɔ yõke tɔ́kɔ́nɔ́lɛ. Búrn pɔ́ núkú ó sõ̀ mɛ pé tyɩ́ krótókè sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Képah sɔkɔ, Yesu mɛ kè gbah yo pé tyɩ́: «Yé yé gblɔ̌ynɛ n kyɔmɩ *Farisiyɛ̃nɔ ànɛ̂ *Yerɔdi búrn dɔkɔ dɔkɔ kwâhlɛ.» ");
INSERT INTO wib_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Wǎh yo sɛ̃́, ǹ tõ̀ sã́hpú yékã̂b mɔ nɛ, búrn kɛ̃́ yĩn-á à kɔ̃, à képah yo. ");
INSERT INTO wib_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Wǎh pè kyɔmɩ wɛ, à pè piki yah nɛ, kû se pɩ, tɛ́ pè yékã̂blɛ n pɩ búrn kɛ̃́ yĩnnɛ nɩ? Pè kó tɔ̃̌nɩ̀ mɛ ké tyɩ́ yah wɛ sɛ̃́ nɩ? Pè kó kè pɩ̃ nɩ? Pé lékã́m se mɛ víkéntũnɔlɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Yɩ̃́-á mɛ pé tyɩ́, pè kó mɛ n yah nɩ? Ní mɛ pé tyɩ́, pè kó mɛ n nohnɩ nɩ? Pé dyɔ kó mɛ n kwnɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Páh lésõ búrn plɔ́ kwlɔ́ kwɔkɩ dibi nɛ́pĩ̂ kèyõ nínɔ́ kyɛgbãm kɔ̃, gbétɔ́lɔ́ yɩ̃́ sɔ̃́ se pè kwel yṍnkwlɔnɔlɛ nɩ? Pè mɛ nɛ, gbɔ̃ninɔ́-á. ");
INSERT INTO wib_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","À tɔ̃ pè piki yah nɛ, tɛ́ páh lésõ búrn plɔ́ kwǎrninɔ kwɔkɩ dibi nɛ́pĩ̂ kèyõ nínɔ́ kɔ̃, tɔkɔ yɩ̃́ sɔ̃́ se pè kwel yṍnkwlɔnɔlɛ nɩ? Pè mɛ nɛ, kwǎrninɔ-á. ");
INSERT INTO wib_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Képah sɔkɔ, à yo pé tyɩ́ nɛ, tɛ́, pè náh tɔ̃̌nɩ̀ mɛ ké tyɩ́ yah wɛ sɛ̃́ nɩ? ");
INSERT INTO wib_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesu ànɛ̂ ǹ *tõ̀ sã́hpú-á kyɩ yĩni tɛ̃ Besayida kwil, nósyɔ́ pɔ yɩ̃́tũ̂ yɔ́lɛ ǹ tyɩ́, tɛ́ à ni nɛ, à tũ ǹ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesu mɛ yɩ̃́tũ̂ mɛ̀ gbõ̀ sɔkɔ tɛ̃, à wil ǹnɛ kwil gbɔ̀pɔ, tɛ́ sĩn mɔ ǹ yɩ̃́ sɔkɔ, tɛ́ ǹ gbã̀n sah ǹ yõ, tɛ́ à piki yah nɛ, à se mɛ n yah nɩ? ");
INSERT INTO wib_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Yɩ̃́tũ̂ dĩ́ ǹ yah yɔ̃, tɛ́ nɛ, páh mɛ névyelɛ n yah yìrkɔ̀ɔ̀, sésân sɔ̃́. Tɛ́, pǎh mɛ n kɔ. ");
INSERT INTO wib_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yesu tɔ̃ ǹ syɩ ǹ gbã̀n sah dĩ́ yɩ̃́ yah. Kǎh pɩ sɛ̃́, à fɛ̃ n yah pnɛpnɛ, à dɛ. À yíyìn póllɛ n wah n pnɛ wɛ̃ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Képah sɔkɔ, Yesu yo dĩ́ mɛ̀ tyɩ́ nɛ, à sɔkɔ ǹ gbô, tɛ́ à káh syɔ̃ kwil sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Képah náh, Yesu ànɛ̂ ǹ *tõ̀ sã́hpú yuku Filipe Sesarɩ gbɔ̀plɔ kwlo tĩ̂nnɛ. Pǎh mɛ wɛ̃̀kɩ̀ yõ gbĩ́ nɛ̂nɛ, à pè piki yah: «Névye tɛ̃̀ tyɩ́, ńmɔlɛ, nɛ̂ mɛ?» ");
INSERT INTO wib_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ǹ tõ̀ sã́hpú nɛ, túkù-á nɛ, *Wèlnwìlkì-ò Nsyɔ̃-á ǹnɛ. Túkù mó nɛ, *Yeli-á. Túkù tɔ̃ nɛ, *Liyel tɛ̃ntõ̀ syínyo-ò yɔ́-á ǹnɛ. ");
INSERT INTO wib_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","À mɛ tɔ̃ pè piki yah: «Tɛ́ yépi tɛ̃̀ tyɩ́, ńmɔlɛ, nɛ̂ mɛ?» Képah tɛ̃̀nɛ, Pyɛrɩ yo ǹ tyɩ́ nɛ: «*Krista ye álɛ, Liyel-á nɛ, páh kɩ nɛ̂ tɛkɩ mɔ.» ");
INSERT INTO wib_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Képah sɔkɔ, Yesu pè sni nɛ, pè káh kè yo nɛ syah. ");
INSERT INTO wib_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Képah sɔkɔ, Yesu tyah ǹ *tõ̀ sã́hpúlɛ n kwɔ nɛ, *Névi Pi-á yɩ̃nɛ à de yèvyãhrɩ sɔkɔ náhnáh. Yèwàhnɩ̀, ànɛ̂ *sárká wìlkìpu yõ̀tãm ǹgbnɔ, ànɛ̂ *Liyel ǹgbò wɛ̃̀kɩ̀ kwɔ́pú-á kɩ à yahle, tɛ́ kɩ à ko n mɔ n pi. Tɛ́, sèpĩ̀n tɔ̃́-ò sṍlɛ, wǎh kɩ yuku. ");
INSERT INTO wib_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Wǎh kénɛ wɛy yo dal mɔ pè syah sɛ̃́, Pyɛrɩ mɛ à ye kɛ̃kɩ, à kyɩ tyah lékàhlɛ ǹnɛ n kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Képah sɔkɔ, Yesu ǹ yah vi ǹ tõ̀ sã́hpú yah, tɛ́ lékàhlɛ Pyɛrɩ kɔ̃, tɛ́ yo ǹ tyɩ́: «To ń tnɔ̂, *sétã̀n yõ̀tɛ̃̀! Á fɔkɔ sõnɔ náh mɛ núkúlɛ Liyel tyɩ́lɛ. Névye tyɩ́ kɔ̃ ye áwɔ n sõ.» ");
INSERT INTO wib_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Képah náh, à mɛ tɔ́wû ye pɔ ànɛ̂ ǹ *tõ̀ sã́hpúlɛ, tɛ́ yo pé tyɩ́: «Névi nɛ̂-á mɛ ké tyɩ́ nɛ, pé ńmɔ sõ̀ tɛ̃, tɛ̃̀ ǹ gblɔ̌y dyɔ́yĩ tyi yɛ, à mó ǹ *dahnɩ twah, à mó ńmɔ sõ̀ tɛ̃. ");
INSERT INTO wib_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Sɛ̃́ ó ye: Névi nɛ̂-á nɛ, páh pé minnɛ n pwah n mɔ, à kɩ tɛkɩ ké sɔkɔ. Tɛ́ névi nɛ̂-á tɛkɩ ǹ min sɔkɔ ńmɔ ànɛ̂ nɩ̀vɩ̀nɩ̀ wɛy sã́n yĩnnɛ, ǹmɔ min kɩ pwah. ");
INSERT INTO wib_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Kè kɩ tir nɛ̂ pɛkɩ névi tyɩ́, wàh kèkõyṍ yî pól wɛ, tɛ́ kɩ n tɛkɩ n pi tyɛ́-ńkɛ̃̂ min sɔkɔ? ");
INSERT INTO wib_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Kwâh nɛ̂ tɛ̃̀ mɛ névi kɩ fɛ̃ kɔ̃, kɩ ǹ min dwe syi sah? ");
INSERT INTO wib_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Kwɛy gbĩ́ névyelɛ, Liyel dêl ànɛ̂ tyípêl pɩ́pú ye pélɛ. Ǹtɛ, névi nɛ̂-á sen ku ńmɔ tyɩ́, ànɛ̂ ń wɛy tyɩ́ yónɔ́lɛ pépi wrɔ́, *Névi Pi tɔ kɩ sen ku tɛ̃̀ yah, wàh sṍ nɛ̂nɛ pɔ ǹ sú gblò sɔkɔ, ànɛ̂ *yĩ̂nyõ tɛ̃̀ntõbelɛ.» ");
INSERT INTO wib_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Tɛ́ tɔ̃ ǹ syɩ yo pé tyɩ́: «Mé kélɛ n yo n dal n mɔ yé tyɩ́ kègbɩ yõ: Yépi nónó-á ásõ̂, yé túkù náh n ku n pi, tɛ́ kɩ *Liyel tɔ̃́rɩ́ wɛ yĩ́nɛ, pɔ́ntɛnɔlɛ. Kè kɩ n pi tɛ̃́nwɛnɔ ǹgbɛ̃nɛ.» ");
INSERT INTO wib_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Sèpĩ̀n kénúkò-ò sɔ́kɔ́ntɛnɔ náh, Yesu mɛ Pyɛrɩ ànɛ̂ Nsyakɩ ànɛ̂ Nsyɔ̃ tɛ̃, à yuku pélɛ yɔ̃lɩ ǹgbɛ̃ yɔ́ yõ. Pépi ó ye sõ̀ pé yahlɛ nɛ́npɔ́ sɔkɔ. Tɛ́, ǹ dùkù mɛ vi mɔ pé yah sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ǹ flɔ piki, à n tɛ̃ pérpér. Ké névi náh mɛ kèkõyṍ kɩ fɛ̃ kwâh yɔ́ ńtɛ̃ piki n pi sɛ̃́ntɛ̃̀nɛ. ");
INSERT INTO wib_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Képah sɔkɔ, *Yeli ànɛ̂ *Moyisi wil pé yah, mɛ n yãh ànɛ̂ Yesulɛ. ");
INSERT INTO wib_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Képah tɛ̃̀nɛ, Pyɛrɩ mɛ yo Yesu tyɩ́ nɛ, kwɔ́-ò dĩ́, kǎh yɩ̃nɛ pé tɛ̃ ásõ̂. Páh kɩ yèpyenɔ tɔ̃́nɔ́ pɩ ásõ̂, núkúlɛ ǹmɔ tyɩ́lɛ, núkúlɛ Moyisi tyɩ́lɛ, núkú mó pɩ Yeli tyɩ́lɛ. ");
INSERT INTO wib_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pyɛrɩ náh sõ̀ pɩ̃, wǎh nɛ̂ yo n pi, képah ye. Tíkí sõ̀ ǹmɔ ànɛ̂ ǹ kɔ́pú nɛ́pĩ̂ nímí kah tɛ̃. ");
INSERT INTO wib_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Pǎh mɛ képah sɔkɔ, ńyĩ́rkì yɔ́ pɔ fob mɔ pé yõ. Kénɛ ńyĩ́rkì sɔkɔ, yĩ́npɔ̃́ yɔ́ n wil pè n nohnɩ nɛ: «Ǹmɔ nɛ̂-á yɔ̀, ńmɔ nɩ̀dɛ̀ Pídĩ́ ye ǹnɛ. Yé nɛ n nohnɩ ǹ tyɩ́!» ");
INSERT INTO wib_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Kénɛ nɩ́ yõ, *tõ̀ sã́hpú-á yah kɔ̃ pé gbɔ̀plɔ sɔkɔ, pè náh tɔ̃ névi wɛ. Yesu núkúní ó sõ̀ wũ ànɛ̂ pélɛ. ");
INSERT INTO wib_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Pǎh mɛ yɔ̃lɩlɛ n tiki gbĩ́ nɛ̂nɛ, Yesu pè sni nɛ, pǎh tir nɛ̂ wɛ, pè káh kè yãh névye syah, kè pɔ nɔ *Névi Pi yúkúnwìlnɔ́ tyɩ́ lékyɩ̂ wrɔ́. ");
INSERT INTO wib_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Pè mɛ snínɔ́ mɛ̀ tɛ̃ yĩn, tɛ́ mó tɔ̃ mɛ wɛ̃nɛ n piki n yah nɛ, kû se à n ye lékyɩ̂ wrɔ́ yúkúnwìlnɔ́lɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Képah tɛ̃̀nɛ, pè tyah ǹnɛ n piki n yah nɛ, kû se pɩ, tɛ́ *Liyel ǹgbò wɛ̃̀kɩ̀ kwɔ́pú nɛ, Yeli ǹgbò-á yɩ̃nɛ à pɔ? ");
INSERT INTO wib_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","À yo pé tyɩ́: «Yeli ǹgbò ye yɩ̃nɛ à pɔ tyi pól tɔ̃ sah. Ǹtɛ, kû pɩ kè wãrkɩ sah *Liyel wɛy sɛ́bɛ̃́nɔ́ sɔkɔ nɛ, Névi Pi-á kɩ yèvyãhrɩ pɩ náhnáh, tɛ́ pè kɩ ǹnɛ n yilɔ nɩ? ");
INSERT INTO wib_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ǹtɛ, mé kélɛ n yo n dal n mɔ yé tyɩ́ nɛ, Yeli-á pɔ tɛ. Tɛ́, névye-á à pɩ pé dyɔ dyɔ tɛ̃̀nɛ. Sɛ̃́ ye sõ̀ kélɛ wã́rkɩ́nsàhnɔ́lɛ Liyel wɛy sɛ́bɛ̃́nɔ́ sɔkɔ ǹ tyɩ́ yõ.» ");
INSERT INTO wib_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Képah sɔkɔ, pǎh yĩni tɛ̃ *tõ̀ sã́hpú tɛ́lɔ́ tnɔ̂, pè tɔ́wû ǹgbɛ̃ yɔ́ wɛ, pè mɛ pè kore vi, tɛ́ *Liyel ǹgbò wɛ̃̀kɩ̀ kwɔ́pú mɛ yékã̂blɛ n pɩ tõ̀ sã́hpú nɔ́pilɛ. ");
INSERT INTO wib_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Névye-á núkú Yesu wɛ gbĩ́ nɛ̂nɛ, kè pɩ pé tyɩ́ gbɛ̃̀ndùnìnɛ. Pè to kyɩ wɛkɩ ǹ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesu mɛ ǹ tõ̀ sã́hpú piki yah nɛ, kwâh nɛ̂ yékã̂b se pè n pɩ pélɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ǹtɛ, dĩ́ yɔ́ sõ̀ mɛ tɔ́wû sɔkɔ, ǹmɔ yo ǹ tyɩ́ nɛ, kwɔ́-ò dĩ́, páh pɔ pé pídĩ́nɛ ǹ tyɩ́. *Sétõ yɔ́-á mɛ ǹ sɔkɔ, mɛ à pɩ kèdɔ̀kɩ̀lɛ. ");
INSERT INTO wib_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kě ǹnɛ n kwel n min n kɔ̃ tã̀ntã̀n pól sɔkɔ sétáh. Gbèfɔ̀kɔ̀píkínì n nɛ n wil ǹ vyãh, tɛ́ ǎ ǹ yĩ́nílɛ n tah, ànɛ̂ ǹ wil n kɔkɔ. Képah-á, pé pɔ ǹnɛ ǹ tõ̀ sã́hpú tyɩ́ nɛ, pè sétõ mɛ̀ yĩni wilki ǹ sɔkɔ, tɛ́ pè náh tɛ̃ wɛ. ");
INSERT INTO wib_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Képah tɛ̃̀nɛ, Yesu mɛ yo pé tyɩ́ nɛ, Liyel yõ sɛ̃́-ńkɛ̃̂ névye, pé se kɩ tɛ̃ pélɛ pópó, kɩ pɔ syɩ gbĩ́ nɛ̂ tyɩ́ nɩ? Pé se kɩ pè so sah, kɩ pɔ syɩ gbĩ́ nɛ̂ tyɩ́ nɩ? Ńkɛ̃, pè pɔ ǹnɛ pé kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Pè mó pɔ ǹnɛ à kɔ̃. Sétõ-á fyɔ̀ Yesu wɛ, à piri yike kègbɩlɛ, à syɩkɩ sétáh, à n pil n kɔ̃ gbèfɔ̀kɔ̀píkínìnɛ ǹ vyãh. ");
INSERT INTO wib_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Képah sɔkɔ, Yesu mɛ piri sú piki yah nɛ, gbĩ́ nɛ se kè tyah ǹ tyɩ́ nɩ? À mɛ yo ǹ tyɩ́ nɛ, ǹ wɛ̃́npir gbĩ́ dùkù-á. ");
INSERT INTO wib_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Kèyahlɛ, sétõ-á ńkɛ̃́nɛ à tɔkɔ n min n dah n mɔ nyàh, képah náh pɩ, ni sɔkɔ, ǹ kò-ǹsahlɛ n yah n kɔ̃. Ǹtɛ, wàh kɩ fɛ̃ n tɛ̃ n pi, à pé yãm yah, à mó pé yohnɩ mɔ. ");
INSERT INTO wib_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Képah sɔkɔ, à mɛ yo dĩ́ mɛ̀ tyɩ́: «Máh kɩ fɛ̃ n tɛ̃ n pi wɔ̀...! Tyi pól kɩ fɛ̃ pɩ Liyel yõ sɛ̃́-ò tyɩ́.» ");
INSERT INTO wib_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Nɛ́npɔ́ swɔ, piri sú gbo mɔ nɛ: «Mé sɛ̃ ké yõ, tɛ́ kè mɛ tah ń tyɩ́. Ń yohnɩ mɔ ké sɔkɔ.» ");
INSERT INTO wib_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Képah sɔkɔ, Yesu-á névye wɛ, pè n to n tuke pé yõ sɛ̃́, à dírí kõ *sétõ mɛ̀ yõ, tɛ́ yo ǹ tyɩ́ nɛ, ǹmɔ nɛ̂-á névilɛ n pɩ kèdɔ̀kɩ̀ ànɛ̂ níkítũ̂nɛ, à wil piri mɛ̀ sɔkɔ! Tɛ́ à káh tɔ̃ de yah ǹ sɔkɔ! ");
INSERT INTO wib_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Wǎh yo sɛ̃́, sétõ mɛ gbo mɔ, tɛ́ piri yike kègbɩlɛ, tɛ́ mó wil ǹ sɔkɔ. Piri núkú pɩ tɛ̃ kúnɔ́ sɔ̃́, fɔ́ɔ́ névye náhnáh n yo nɛ, wǎh ku. ");
INSERT INTO wib_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ǹtɛ, Yesu mɛ à tɛ̃ ǹ gbõ̀ tyɩ́, à yilki sah. Piri yuku yĩn. ");
INSERT INTO wib_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yesu-á de wɔ̀kɔ̀ gbĩ́ nɛ̂nɛ, ǹmɔ ànɛ̂ ǹ tõ̀ sã́hpú ye sõ̀ wũ pé yahlɛ, tɛ́ pè mɛ à piki yah nɛ, kû se pɩ, tɛ́ pépi náh tɛ̃ wɛ sétõ mɛ̀ yĩni wilki piri sɔkɔ nɩ? ");
INSERT INTO wib_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","À mɛ yo pé tyɩ́: «Nírí ó sɔkɔ ye kénɛ sétã̀n dùkù kɩ fɛ̃ yĩni.» ");
INSERT INTO wib_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Pǎh yal nɛ́npɔ́, pè mɛ Kalile kwlolɛ n kah, tɛ́ Yesu náh sõ̀ mɛ ké tyɩ́ nɛ, pè pé mɛ́-ńsah pɩ̃. ");
INSERT INTO wib_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Tir yɔ́ náh, à sõ̀ mɛ ǹ *tõ̀ sã́hpúlɛ n kwɔ, tɛ́ mɛ n yo pé tyɩ́: «*Névi Pi kɩ n dahbɩ n pi névye gbõ̀. Pè kɩ à ko mɔ, tɛ́ sèpĩ̀n tɔ̃́-ò sṍlɛ, à kɩ yuku.» ");
INSERT INTO wib_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ǹtɛ, ǹ tõ̀ sã́hpú náh sõ̀ mɛ wɛy mɛ̀ tyɩ́ yah wɛ, tɛ́ tíkí sõ̀ mɛ pè tɛ̃ ǹ píkínyahnɔlɛ. ");
INSERT INTO wib_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Képah náh, pè yĩni tɛ̃ Kapɛrnayim kwil sɔkɔ. Pǎh mɛ wɔ̀kɔ̀ sɔkɔ gbĩ́ nɛ̂nɛ, Yesu ǹ *tõ̀ sã́hpú piki yah nɛ tir nɛ̂ yékã̂b se sõ̀ pè n pɩ wɛ̃̀kɩ̀ yah nɩ? ");
INSERT INTO wib_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ǹtɛ, pè náh tir wɛ yo. Tir yɔ́ náh, pè sõ̀ mɛ yékã̂blɛ n pɩ wɛ̃̀kɩ̀ yah nɛ, pé pɩ̃ pépi wrɔ́ nɛ̂ tɛ̃̀-á kal. ");
INSERT INTO wib_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Képah sɔkɔ, Yesu kɔ̃ tɛ̃, tɛ́ ǹ tõ̀ sã́hpú nɛ́pĩ̂ gbɔ̃nimí ye, tɛ́ yo pé tyɩ́: «Nɛ̂-à mɛ ké tyɩ́ nɛ, pé pɩ yah yétɛ̃̀nɛ, ǹmɔ yɩ̃nɛ à pɩ pé no náhtũnɛ, à mó pɩ tõ̀npɩlɛ pé tyɩ́.» ");
INSERT INTO wib_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Képah tɛ̃̀nɛ, à wɛ̃́npir yɔ́ tɛ̃ pɔ pé nɩyṍ. Tɛ́ à tɛ̃ kõhlɩ ǹ nɩ yõ, tɛ́ yo ǹ tõ̀ sã́hpú tyɩ́: ");
INSERT INTO wib_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Névi nɛ̂-à wɛ̃́npir mɛ̀ kénkɔ̃ tɛ̃́nɔ́ plɛ́ ńmɔ yĩn yõ, ńmɔ ye tɛ̃̀ tɛ̃ plɛ́. Névi nɛ̂ tɔ-à ńmɔ tɛ̃́nɔ́ plɛ́, ńmɔ ó náh tɛ̃̀ tɛ̃ plɛ́: Ǹtɛ nɛ̂-á tɛkɩ mɔ ńmɔlɛ, ǹmɔ ye à tɛ̃ plɛ́.» ");
INSERT INTO wib_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Képah sɔkɔ, Nsyɔ̃ mɛ yo Yesu tyɩ́ nɛ, pé kwɔ́-ò dĩ́, pépi-á dĩ́ yɔ́ wɛ, à mɛ *sétã̀nnɛ n yĩni n wilki ǹ yĩn yõ. Tɛ́, à náh sõ̀ mɛ pépilɛ. Képah-á pé kɔ̃, pé nɛ pé à yĩni mɔ ké pɩ́nɔ́lɛ. ");
INSERT INTO wib_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yesu mɛ yo pé tyɩ́: «Yé káh à yĩni mɔ. Névi náh fɛ̃ gbǐl pɩ n pi ńmɔ yĩn yõ, tɛ́ kɩ tɔ̃ ńmɔ yĩnnɛ n yɩkɩ nɛ́npɔ́ swɔ. ");
INSERT INTO wib_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Tir yɔ́ náh, á sépɛ náh nɛ̂nɛ, á pèpɛy nɛ ye ǹnɛ. ");
INSERT INTO wib_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Kègbɩ yõ, mé kélɛ n yo yé tyɩ́: Yáh pɩ *Krista tyɩ́lɛ, névi nɛ̂-à ni ńgbíyĩ́nɛ yé kɔ̃ yé wɔ képah yĩnnɛ, ké pèpɔrɩ kɩ dyah ólɛ à dyah. ");
INSERT INTO wib_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Wɛ̃́npì nónó-á sɛ̃ ńmɔ yõ, névi nɛ̂-à pé sɔkɔ nɛ yɔ́ yõ yɩkɩ dah mɔ tyípêl sɔkɔ, kè kɩ sõ̀ fṍnfṍ pè dáh-ǹgbɛ̃ toh tɛ̃̀ yègbɩ sɔkɔ, pè kyɩ min dah mɔ yɔ́ntî ǹgbɛ̃ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Á gbõ̀-à n dah n mɔ álɛ tyípékè sɔkɔ, kè kãm n milki, ǹ tɛ́ n kyɩ n de gbõ̀ núkúlɛ tyɛ́-ńkɛ̃̂ min sɔkɔ. Kèpah kɩ fṍnfṍ kal á gbã̀n nínì kyɩ́ndenɔlɛ ní-ńkɛ̃̂ nyàhnpèkè sɔkɔ.  ");
INSERT INTO wib_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Nɛ́npɔ́ sɔkɔ, kèfyɔ̃ nónó-á willɛ n yõ, sè náh n ku, ànɛ̂ ké nyàhnpèkè náh n ni. ");
INSERT INTO wib_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Á gbáhkɩ̀-à n dah n mɔ álɛ tyípékè sɔkɔ, kè kãm n milki, ǹ tɛ́ n kyɩ n de gbáhkɩ̀ núkúlɛ tyɛ́-ńkɛ̃̂ min sɔkɔ. Képah kɩ fṍnfṍ kal á gbyẽ̂h nínì mínndahnmɔnɔlɛ nyàhnpèkè sɔkɔ.  ");
INSERT INTO wib_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Nɛ́npɔ́ sɔkɔ, kèfyɔ̃ nónó-á willɛ n yõ, sè náh n ku, ànɛ̂ ké nyàhnpèkè náh n ni. ");
INSERT INTO wib_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Á yĩ́-à n dah n mɔ álɛ tyípékè sɔkɔ, kè wilki n milki, ǹ tɛ́ n kyɩ n de yĩ́ núkúlɛ *Liyel yõ̀tɔ̃rɩ́ sɔkɔ. Képah kɩ fṍnfṍ kal á mínndahnmɔnɔ yõ yɩ̃́ nínɔ́lɛ nyàhnpèkè sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Nɛ́npɔ́ sɔkɔ, kèfyɔ̃ nónó-á willɛ n yõ, sè náh n ku, ànɛ̂ ké nyàhnpèkè náh n ni. ");
INSERT INTO wib_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Képah ye, no pól kɩ tɔ̃ sah nyàhlɛ, sɔ̃́-á pnɛ n pɩ kélɛ. ");
INSERT INTO wib_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Pnɛnɛ, kwâh pèpɛy ye kélɛ. Tɛ́ ké syɩ̃́nsyɩ̃́-à wil ké sɔkɔ, sɔ̃́ mɛ yé kɩ tɔ̃ fɛ̃ pɩ kélɛ, tɛ́ kè kɩ tɔ̃ nɔ? Yé pnɛ mɔ yé gblɔ̌y sɔkɔ, yé tɛ̃ wɛ̃ tyɩ́ yèvɩnɩ sɔkɔ.» ");
INSERT INTO wib_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu-á yal nɛ́npɔ́, à kyɩ Yude sétáh yõ, tɛ́ yuku Yurdɛ̃ yɔ́nkahnɩnɛ. Képah sɔkɔ, tɔ́wû ǹgbɛ̃ yɔ́ tɔ̃ tuke mɔ ǹ tnɔ̂. À mɛ tyah pélɛ n kwɔ ǹgbò tyɩ́ kɔ̃lɛ. ");
INSERT INTO wib_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Képah tɛ̃̀nɛ, *Farisiyɛ̃nɔ yísyɔ́ nɔ de ǹ tnɔ̂ nɛ, pé kyɩ ǹ sõ̀ mɔ yah. Tɛ́ ǹnɛ n piki n yah nɛ, ké wɛ̃̀kɩ̀ se mɛ dĩ́ tyɩ́ kɩ ǹ kyɩ fĩn mɔ nɩ? ");
INSERT INTO wib_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","À mɛ yo pé tyɩ́ nɛ, tir nɛ̂ se sõ̀ *Moyisi yo sah pé tyɩ́ nɩ? ");
INSERT INTO wib_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Pè mɛ nɛ ńkɛ̃, Moyisi-á ké wɛ̃̀kɩ̀ kɔ̃ nɛ, wâh á kyɩlɛ n fĩn mɔ, á ǹ fĩ́nnmɔnɔ tàrfyɔ̀ sɛ́bɛ̃́ pɩ à kɔ̃. À mó à fĩn mɔ. ");
INSERT INTO wib_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Képah tɛ̃̀ sɔkɔ, Yesu yo pé tyɩ́: «Yépi kùkùtǎhkɩ̀ yĩn ye, Moyisi mɛ ké wɛ̃̀kɩ̀lɛ yé kɔ̃ sɛ̃́. ");
INSERT INTO wib_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ǹtɛ, kèkõyṍ mɔ gbĩ́nɛ, dĩ́ ànɛ̂ sê ye Liyel mɔ. ");
INSERT INTO wib_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Képah ye, dĩ́ kɩ ǹ sú ànɛ̂ ǹ yṹ sah, tɛ́ kɩ kyɩ yégbékè kwrɔ mɔ ànɛ̂ ǹ kyɩlɛ, ");
INSERT INTO wib_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","tɛ́ pé nímí kɩ pɩ núkúlɛ. Képah sɔkɔ, pè náh tɔ̃ n pɩ n pi nímínɛ, pè kɩ pɩ núkúlɛ. ");
INSERT INTO wib_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kǎh pɩ sɛ̃́, Liyel-á nɛ̂ kwrɔ mɔ, névi káh kè gbɛkɩ.» ");
INSERT INTO wib_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Pǎh de wɔ̀kɔ̀, ǹ *tõ̀ sã́hpú tɔ̃ à piki yah wɛy mɛ̀ yõlɛ. ");
INSERT INTO wib_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","À mɛ yo pé tyɩ́: «Dĩ́-à ǹ kyɩ fĩn mɔ, tɛ́ tɔ̃ sê yɔ́ tɔkɔ, à tyípékè pɩ ǹ kyɩ gben tɛ̃̀ tyɩ́ fɔ̀fɩ́kɩ̀ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Sɛ̃́ ó ye tɔ̃, sê-à ǹ pɛ yahle, tɛ́ kyɩ de dĩ́ yɔ́ tyɩ́, à tyípékè pɩ fɔ̀fɩ́kɩ̀ sɔkɔ ǹ pɛ gben tɛ̃̀ tyɩ́.» ");
INSERT INTO wib_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Képah tɛ̃̀nɛ, névye pɔ wɛ̃́npìlɛ Yesu tyɩ́ nɛ, à ǹ gbã̀n sah pé yõ. Tɛ́ ǹ *tõ̀ sã́hpú mɛ tyah dírílɛ n kõ pé yõ. ");
INSERT INTO wib_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Wǎh képah wɛ sɛ̃́, à yo ǹ tõ̀ sã́hpú tyɩ́ fɔ̀kɔ̀vyã̀hnɩ̀ sɔkɔ nɛ: «Yé yɛ wɛ̃́npì kɔ̃, pè nɛ n pɔ n pɔ ńmɔ tyɩ́. Yé káh pé yahlɛ n kõ. Nónó dùkù-á mɛ kénɛ wɛ̃́npì sɔ̃́, *Liyel yõ̀tɔ̃rɩ́lɛ pépi tyɩ́ ye. ");
INSERT INTO wib_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Mé kélɛ n yo yé tyɩ́ kègbɩ yõ: Névi nɛ̂-à *Liyel tɔ̃́rɩ́ fɛ̃ syi ńkɛ̃̂nɛ wɛ̃́npir sɔ̃́, à náh kè wɛ n de n pi póllɛ.» ");
INSERT INTO wib_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Képah sɔkɔ, à wɛ̃́npì tɛ̃, tɛ́ ǹ gbã̀n sah pé yõ, à sãm mɔ pé sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Képah náh, Yesu-á n yuku wɛ̃̀kɩ̀ yah, dĩ́ yɔ́ to pɔ gbètukunɔ di ǹ yah, tɛ́ à piki yah nɛ, kwɔ́-ò pèpɛy, pé se kɩ pɩ sɔ̃́, tɛ́ kɩ tyɛ́-ńkɛ̃̂ min wɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu mɛ yo ǹ tyɩ́: «Sɔ̃́ mɛ, tɛ́ á ń ye pèpɛynɛ? Nɛ pèpɛy yɔ́ ńtɛ̃ náh mɛ. Liyel ó ye pèpɛynɛ. ");
INSERT INTO wib_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Á Liyel tyi kõ̀nsàhnɔ́ pɩ̃ kɛ̀, nɛ̂-á n yo nɛ, káh nɛ́kókè mɔ, káh fɔ̀fɩ́kɩ̀ pɩ, káh yɩ̃be yɩ̃, káh mɩ̀nɩ̀ sah á ní-ò yõ, káh nɛ n syɩkɩ nɛ yõ, á sú ànɛ̂ á yṹnɛ n tɛ̃ plɛ.» ");
INSERT INTO wib_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Wǎh yo sɛ̃́, dĩ́ mɛ à syah nɛ, kwɔ́-ò dĩ́, páh mɛ sépinɔ́ póllɛ n pɩ pé wɛ̃́npir gbĩ́ dùkùlɛ. ");
INSERT INTO wib_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Képah sɔkɔ, Yesu mɛ à yah tyɩ́nɔnɔ sɔkɔ, tɛ́ yo ǹ tyɩ́ nɛ, tyínúkú-á yah kwlɔ ǹ tyɩ́: À kyɩ ǹ gbã̀n yî pól yãm, à mó sé pɔ́ dibi yãmtãm kɔ̃. Képah sɔkɔ, wǎh kɩ yĩ̂nyõ tahrɩ wɛ, à mó pɔ pé sõ̀ tɛ̃. ");
INSERT INTO wib_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Tɛ́, dĩ́ mɛ̀-á képah noh sɛ̃́, ǹ yah yɩkɩ. À sɔkɔ yèkwɔrɩ sɔkɔ. Tahrɩ ǹgbɛ̃ sõ̀ mɛ ǹ tyɩ́, képah ye. ");
INSERT INTO wib_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Kǎh pɩ sɛ̃́, Yesu ǹ gbɔ̀plɔ yah kore vi, tɛ́ yo ǹ *tõ̀ sã́hpú tyɩ́: «Tahbɩ dénɔ́lɛ *Liyel tɔ̃́rɩ́ sɔkɔ, kè mɛ tah dɛ́!» ");
INSERT INTO wib_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Kénɛ wɛy ǹ tõ̀ sã́hpú gbã̀n du kègbɩlɛ. Ǹtɛ, Yesu tɔ̃ ǹ syɩ yo pé tyɩ́: «Ń wɛ̃́npì, Liyel tɔ̃́rɩ́ sɔkɔ dénɔ́ mɛ tah náhnáh. ");
INSERT INTO wib_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Yã̀hmɩ́kɩ̀ dénwìlnɔ́lɛ sèndi pwã̀h sɔkɔ, képah kɩ fàhfàh kal, tàh dénɔ́lɛ Liyel tɔ̃́rɩ́ sɔkɔ.» ");
INSERT INTO wib_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Képah tɛ̃̀ sɔkɔ, pé gbã̀n kah du. Pè wɛ̃nɛ n piki n yah pé tyɩ́ tyɩ́lɛ nɛ, ǹtɛ, nɛ̂ wɔ se kɩ mó pwah nɩ? ");
INSERT INTO wib_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu mɛ pè yah, tɛ́ yo pé tyɩ́: «Névi tɛ̃̀ tyɩ́, kè náh fɛ̃ n pɩ n pi, tɛ́ Liyel wɔ tyɩ́, kè kɩ fɛ̃ pɩ. Ǹmɔ tɛ̃ wɛ tyi pól tyɩ́.» ");
INSERT INTO wib_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Képah sɔkɔ, Pyɛrɩ yo ǹ tyɩ́ nɛ, ǹtɛ, pépi-á tyi pól sah ǹmɔ sõ̀ tɛ̃ yĩnnɛ. ");
INSERT INTO wib_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu mɛ nɛ: «Kègbɩ yõ, mé kélɛ n yo n dal mɔ yé tyɩ́ nɛ, névi nɛ̂-à fɛ̃ syi, ǹ kéte, ànɛ̂ ǹ yṹpyé, ànɛ̂ ǹ yṹ, ànɛ̂ ǹ sú, ànɛ̂ ǹ wɛ̃́npì, ànɛ̂ ǹ swɛ̃y sah ńmɔ yĩnnɛ, ànɛ̂ nɩ̀vɩ̀nɩ̀ wɛy sã́n yĩnnɛ, ");
INSERT INTO wib_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","tɛ̃̀ kɩ sɛ̃́nknɔnɔ lèkwɛ̌kwɛ wɛ kèkõyṍ mɛ̀ sɔkɔ. À kɩ kétlo, ànɛ̂ yṹpyé, ànɛ̂ yṹbí, ànɛ̂ wɛ̃́npì, ànɛ̂ swɛ̃y wɛ. À kɩ fṍhnɔ́ tɔ wɛ, tɛ́ kɩ tyɛ́-ńkɛ̃̂ min wɛ ńsõ̂ kèkõyṍ sã́n sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Nónó-á mɛ núkúnúkú nɛ gbrolɛ, pé náhnáh kɩ pɔ n pɩ n pi nɛ tɛ́lɔ́lɛ. Tɛ́ nónó-á mɛ núkúnúkú nɛ tɛ́lɔ́lɛ, pé náhnáh kɩ pɔ n pɩ n pi nɛ gbrolɛ.» ");
INSERT INTO wib_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesu ànɛ̂ ǹ *tõ̀ sã́hpú sõ̀ mɛ wɛ̃̀kɩ̀ tɛ̃ n dɔkɔ n yuku Yerusalɛmɩ sɔkɔ. À sõ̀ mɛ n kɔ ǹ tõ̀ sã́hpú yahlɛ. Légbĩ́nɛ, pé fɔkɔ mɛ fɛ̃̀kɩ̀nɔ́lɛ. Tɛ́ nónó tɔ-á mɛ ǹ sõ̀ tɛ̃, tíkí sõ̀ mɛ pè tɛ̃. Képah sɔkɔ, à ǹ tõ̀ sã́hpú nɛ́pĩ̂ gbɔ̃nimí ye kɛ̃kɩ pé yahlɛ, à kyɩ tir nɛ̂-á kɩ à yĩni n tɛ̃ n pi, ké yah yo pè syah. ");
INSERT INTO wib_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","À nɛ: «Yé yah, á wɛ dɔkɔ n yuku Yerusalɛmɩ sɔkɔ yɔ̀. *Névi Pi kɩ dahbɩ *sárká wìlkìpu yõ̀tãm ǹgbnɔ, ànɛ̂ *Liyel ǹgbò wɛ̃̀kɩ̀ kwɔ́pú gbõ̀. Pè kɩ à mɔ kũ kɔ̃, tɛ́ kɩ à dahbɩ Liyel yõ sɛ̃́-ńkɛ̃̂pú gbõ̀. ");
INSERT INTO wib_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Pépi kɩ kṍlɛ ǹnɛ n ko, tɛ́ kɩ n sĩn n mɔ ǹ yõ. Pè kɩ à ko yèfõhlɛ, tɛ́ kɩ à ko mɔ. Tɛ́, ké sèpĩ̀n tɔ̃́-ò sṍlɛ, à kɩ yuku.» ");
INSERT INTO wib_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Nsyakɩ ànɛ̂ Nsyɔ̃nɛ, Sebede wɛ̃́npìlɛ, pè nɔ de Yesu tnɔ̂, tɛ́ yo ǹ tyɩ́ nɛ, kwɔ́-ò dĩ́, tir nɛ̂-á pé pɔ ní-ńsah ǹ tyɩ́, páh mɛ ké tyɩ́ nɛ, à kè pɩ pé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","À mɛ pè piki yah nɛ, tir nɛ̂ se pè nɛ, pé pɩ pé tyɩ́ nɩ? ");
INSERT INTO wib_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Pè mó yo ǹ tyɩ́ nɛ, wàh kyɩ yĩni tɛ̃ ǹ yõ̀tɔ̃rɩ́ tyah sɔkɔ, à yɛ pépi sɔkɔ nɛ núkú tɛ̃ ǹ gbõ̀yõ̀ sõ̀, ní-ò mó tɛ̃ ǹ gbɛ̃̀yɩ̃̀nɛ̀ sõ̀. ");
INSERT INTO wib_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Képah sɔkɔ, à yo pé tyɩ́: «Kwâh nɛ̂-á yé n ni, yé náh kè pɩ̃. Yé se kɩ fɛ̃ wɔ ń wɔ wɔ wóh sɔkɔ, kɩ de wil yèvyãhrɩ sɔkɔ ń tyɩ́ kɔ̃lɛ?» ");
INSERT INTO wib_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Pè mɛ à syah nɛ, páh kɩ tɛ̃ wɛ. À mɛ yo pé tyɩ́: «Gbɩ ye, yé kɩ n wɔ n pi ń wɔ wɔ wóh tɛ̃̀ wɔ sɔkɔ, tɛ́ kɩ n de n wil n pi yèvyãhrɩ sɔkɔ ń tyɩ́ kɔ̃lɛ. ");
INSERT INTO wib_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ǹtɛ, névi nɛ̂-á n tɛ̃ n pi ń gbõ̀yõ̀ ànɛ̂ ń gbɛ̃̀yɩ̃̀nɛ̀ sõ̀, képah náh n wil n pi ńmɔ tyɩ́. Kénɛ tɛ̃̀-ǹtã̀n kɩ pɔ névye kɔ̃ n pi, Liyel-á sè tɔ̃ sah nónó yĩnnɛ.» ");
INSERT INTO wib_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","*Tõ̀ sã́hpú nɛ́pĩ̂ gbãm tɛ́lɔ́-á képah noh sɛ̃́, pé fɔkɔ vyãh Nsyakɩ ànɛ̂ Nsyɔ̃nɛ. ");
INSERT INTO wib_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Képah sɔkɔ, Yesu mɛ pé pól ye, tɛ́ yo pé tyɩ́: «Yé pɩ̃ nɛ, sétáh mɛ̀ yõ kwlo yõ̀tãm-á pé kwil tãnnɛ n tɛ̃ n sah pé dyɔ dyɔ tɛ̃̀nɛ, tɛ́ kwil nɛ́-ǹgbnɔ n mó pé tǎhkɩ̀lɛ n sah névye yõ. ");
INSERT INTO wib_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ǹtɛ, yépi tyɩ́ náh n pɩ n pi sɛ̃́. Gbɛ̃̀ntɛ̃̀ náhlɛ, yépi sɔkɔ nɛ̂-à mɛ ké tyɩ́ nɛ, pé pɩ yõ̀tɛ̃̀nɛ, tɛ̃̀ ǹ gblɔ̌y pɩ yé tõ̀npɩlɛ. ");
INSERT INTO wib_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Tɛ́, yépi sɔkɔ nɛ̂-à mɛ kɩ tyɩ́ nɛ, pé yõ̀tɔ̃rɩ́ yah n kɔ̃, tɛ̃̀ ǹ gblɔ̌y pɩ yé pól yɔ̃̀lɛ. ");
INSERT INTO wib_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Tir yɔ́ náh, *Névi Pi náh pɔ nɛ, névye tõ̀lɛ n pɩ péwɔ tyɩ́. Ǹmɔ ye pɔ tõ̀ pɩ yĩnnɛ névye tyɩ́, tɛ́ kɩ ǹ min kɔ̃ névye náhnáh yõ dwe yĩnnɛ.» ");
INSERT INTO wib_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Képah náh, pè yĩni tɛ̃ Yeriko kwil. Yesu, ànɛ̂ ǹ *tõ̀ sã́hpú, ànɛ̂ tɔ́wû ǹgbɛ̃-á n wil kwil sɔkɔ gbĩ́ nɛ̂nɛ, yɩ̃́tũ̂ dĩ́ yɔ́ sõ̀ mɛ tɛ̃̀nɔ́lɛ wɛ̃̀gbalɩ sɔkɔ, mɛ n ni n syi. Time pídĩ́ ye sõ̀ ǹnɛ, pè n ye Bartimelɛ. ");
INSERT INTO wib_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Wǎh noh nɛ, Nasarɛti Yesu-á n sɔkɔ, à tyah n de n syi nɛ, Yesu, *Davidi pídĩ́, à pé yãm yah. ");
INSERT INTO wib_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Képah sɔkɔ, náhnáh sõ̀ mɛ ǹ vyãhlɛ n tũ. Ǹtɛ, à tɔ̃ n kah n de n syi nɛ, Davidi pídĩ́, à pé yãm yah. ");
INSERT INTO wib_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Képah tɛ̃̀nɛ, Yesu yĩn, tɛ́ nɛ, pè à ye yah. Pè mɛ yɩ̃́tũ̂ dĩ́ ye yah, tɛ́ yo ǹ tyɩ́ nɛ, à ǹ nɩ vɩ, à mó yuku, wǎh mɛ ǹnɛ n ye. ");
INSERT INTO wib_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Dĩ́-á képah tɛ̃̀ noh, à ǹ fwɔ̀mɔ̀-ǹgbɛ̃ milki, tɛ́ yɔkɔ syɩkɩ ǹ gbyẽ̂h yõ, à yuku Yesulɛ n yɩ̃kɩ. ");
INSERT INTO wib_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu mɛ à piki yah: «Kû mɛ á nɛ, mé pɩ á tyɩ́?» Yɩ̃́tũ̂ dĩ́ mɛ yo ǹ tyɩ́ nɛ, kwɔ́-ò dĩ́, à kè pɩ, pé tɔ̃ nɛ n yah. ");
INSERT INTO wib_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","À mɛ yo ǹ tyɩ́: «Nɛ n yuku, ńmɔ yõ sɛ̃́nɔ́ ye ǹ dɛ mɔ.» Nɛ́npɔ́ swɔ, ǹ yɩ̃́ yɩkɩ mɔ, à mɛ Yesu sõ̀ tɛ̃. ");
INSERT INTO wib_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Pǎh de n tɛ Yerusalɛmɩnɛ, pè sõ̀ mɛ yúkɛy Betefase ànɛ̂ Betani kwillɛ, Wólívyê sésân yɔ̃lɩ tnɔ̂. Képah sɔkɔ, Yesu ǹ *tõ̀ sã́hpú sɔkɔ nɛ́pĩ̂ nímí wilki tõ, ");
INSERT INTO wib_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","tɛ́ mɛ yo pé tyɩ́ nɛ, pè kyɩ kwil nɛ̂-á pé yahlɛ. Pàh kɩ kyɩ yĩni tɛ̃ nɛ́npɔ́, pǎh kɩ ńkwɛ̃́ndyɩ́pírí yɔ́ wɛ tóhnmɔnsàhnɔ́lɛ, névi náh dɔkɔ yah nɛ̂ yõ. Pè à dɛ pɔ. ");
INSERT INTO wib_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Tɛ́, névi-à kɩ pè piki yah nɛ, sɔ̃́ se, tɛ́ pè ǹnɛ n dɛ nɩ, pè yo ǹ tyɩ́ nɛ, ǹ yétõ̂-á mɛ Tɛ̃̀-ǹgbɛ̃ dĩ́ tyɩ́. Tɛ́ wǎh kɩ ǹ syɩ à tɛkɩ mɔ núkúnúkú ásõ̂. ");
INSERT INTO wib_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Képah sɔkɔ, pè mó sɔkɔ, à kyɩ ńkwɛ̃́ndyɩ́pírí mɛ̀ wɛ tóhnmɔnsàhnɔ́lɛ kégbɔ́, gbô yɔ́ yah, wɛ̃̀kɩ̀ gbɔ̀pɔ. Pè mɛ à dɛ. ");
INSERT INTO wib_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Nónó-á sõ̀ mɛ nɛ́npɔ́, pé túkù pè piki yah nɛ, kû se pɩ, tɛ́ pè ńkwɛ̃́ndyɩ́pírí mɛ̀nɛ n dɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Képah sɔkɔ, Yesu-á sõ̀ pè tõ sɔ̃́, pè képah yo no tyɩ́. No yɛ pè kɔ̃, pè à dɛ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Pè mɛ pɔ ńkwɛ̃́ndyɩ́pírí mɛ̀nɛ Yesu tyɩ́. Tɛ́ pé flɔ mɔ ǹ yõ, Yesu kɔ̃ à dɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Névye náhnáh mó pé flɔ mɔ wɛ̃̀kɩ̀ yõ. Túkù mó fɔ̀kɔ̀nɩ̀ kɔ̃lɩ kyẽh sɔkɔ, à n mɔ n yuku wɛ̃̀kɩ̀ yõ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Pǎh n yuku, nónó-á sõ̀ mɛ n kɔ Yesu yahlɛ, ànɛ̂ nónó-á mɛ ǹ sõ̀ tɛ̃, pè sõ̀ mɛ n gbo n mɔ, mɛ yo tũ nɛ: «Wosanna, Tɛ̃̀-ǹgbɛ̃ Liyel yĩn pɩ gblò! Nɛ̂-á n pi ǹ yĩn yõ, Liyel sãm mɔ ǹ sɔkɔ! ");
INSERT INTO wib_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Á sútó *Davidi tɔ̃́rɩ́ nɛ̂-á n pi, Liyel sãm mɔ ké sɔkɔ! Wosanna, Liyel yĩn pɩ gblò yĩ̂nyõ sɔkɔ.» ");
INSERT INTO wib_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesu-á de Yerusalɛmɩ sɔkɔ sɛ̃́, à kyɩ de *Liyel wɔ̀kɔ̀ ǹgbɛ̃ kéntáhkɩ̀ sɔkɔ. À kè yah kore vi, tɛ́ ǹ syɩ wil. Képah náh, tyah-á pɔ n piri, à sɔkɔ ànɛ̂ ǹ tõ̀ sã́hpú nɛ́pĩ̂ gbɔ̃nimínɛ Betani kwil sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ké dendallɛ, pǎh n wil Betani sɔkɔ gbĩ́ nɛ̂nɛ, kwɛkɩ Yesu tɛ̃. ");
INSERT INTO wib_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Képah sɔkɔ, à mɛ sènsóké yɔ́ wɛ fɩ́ɩ́ mɩlɛ gbòp ké tyɩ́. À mɛ nɔ de yah, pye-à kɩ n wɛ n pi ké tyɩ́. Ǹtɛ, wǎh yĩni tɛ̃ ké tnɔ̂, à kyɩ kè wɛ mɩrɩ ólɛ. Ké pye pɩ gbĩ́ náh sõ̀ nɔ, képah ye. ");
INSERT INTO wib_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Képah tɛ̃̀nɛ, Yesu yo sènsóké mɛ̀ tyɩ́ nɛ, nɛ náh tɔ̃ ké pye yõ n yah n pi póllɛ. Ǹtɛ, ǹ *tõ̀ sã́hpú mó kè noh. ");
INSERT INTO wib_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Képah náh, pè yĩni tɛ̃ Yerusalɛmɩ. Yesu mɛ de *Liyel wɔ̀kɔ̀ ǹgbɛ̃ kéntáhkɩ̀ sɔkɔ, à tyah yî yã̀mpu ànɛ̂ dwépúlɛ n yĩni n wilki. Tɛ́ pɔ́ tũ̀pu tàbǎlnɔ́ tu wilki mɔ, ànɛ̂ *sárká kèpye yã̀mpu klǒlɛ. ");
INSERT INTO wib_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Tɛ́, à náh fɛ̃ syi vyɔ́ nɛ́tɛ̃̂ yɔ́ ńtɛ̃ kɔ̃, à de kah Liyel wɔ̀kɔ̀ ǹgbɛ̃ kéntáhkɩ̀ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Tɛ́ tyah pélɛ n kwɔ, mɛ n yo pé tyɩ́: «Kè náh mɛ wã́rkɩ́nsàhnɔ́lɛ nɛ, ‹ńmɔ Liyel wɔ̀kɔ̀ kɩ n ye kèkõyṍ kwlo kwlo pól névye nírí pɩ́-ńsahlɛ› di? Tɛ́, yépi mɛ pɔ kè pɩ névye yõ vìnsyɩkɩpu tɛ̃̀-ǹsahlɛ.» ");
INSERT INTO wib_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Képah tɛ̃̀nɛ, *sárká wìlkìpu yõ̀tãm ǹgbnɔ ànɛ̂ *Liyel ǹgbò wɛ̃̀kɩ̀ kwɔ́pú-á kè noh sɛ̃́, pè tyah Yesu kònmɔ-ńsahlɛ n yah n kɔ̃. Tɛ́, ǹ tíkí sõ̀ mɛ pè tɛ̃, tir yɔ́ náh, ǹ kwɔ́nɔ́ tyɩ́ sõ̀ mɛ nɔ tɔ́wû tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Képah sɔkɔ, gbĩ́yĩ́-á de, Yesu ànɛ̂ ǹ *tõ̀ sã́hpú wil kwil sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ké dendal séngbɔ̃́lɛ, pǎh pɔ n sɔkɔ, pè sènsóké mɛ̀ wɛ kɔ́kɔ́nɔ́lɛ, à pɔ syɩ ké yã̀hnɩ̀ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pyɛrɩ dyɔ́-á to kõ kélɛ, à yo Yesu tyɩ́ nɛ, kwɔ́-ò dĩ́, wǎh sõ̀ léplɔ ye mɔ sènsóké nɛ̂ yõ, à yah, ké pól-á kɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Képah sɔkɔ, Yesu yo pé tyɩ́ nɛ: «Yé sɛ̃ Liyel yõ. ");
INSERT INTO wib_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Kègbɩ yõ, mé kélɛ n yo yé tyɩ́: Névi kɩ fɛ̃ yo yɔ̃lɩ ǹgbɛ̃ mɛ̀ tyɩ́ nɛ, kè yuku yal ásõ̂, kè kyɩ n syɩkɩ n de pnɛ yɔ sɔkɔ. Tɛ̃̀-à mɛ n sõ ńkɛ̃̂nɛ tɔ̀tɔ̀ ǹ nɩ sɔkɔ, tɛ́ mɛ sɛ̃ yĩ́ĩ́ ké yõ nɛ, páh nɛ̂nɛ n yo, kǎh kɩ pɩ, kè kɩ mó ńtyɩ̃́nɔ pɩ sɛ̃́ ǹ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Képah ye, mé kélɛ n yo yé tyɩ́: Yáh kwáhdúkú nɛ̂nɛ n yah n kɔ̃ Liyel tyɩ́ nírí sɔkɔ, yé sɛ̃ ké yõ nɛ, yáh ké wɛ tɛ. Kè kɩ ńtyɩ̃́nɔ yé kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ànɛ̂ tɔ̃, wâh yuku yĩn n tyah nírí pɩ́nɔ́lɛ, tɛ́ á ní-ò-à mɛ pɩ de á tyɩ́, kè yɔ̃ mɔ à kɔ̃. Képah-à pɩ, yé sú Liyel nɛ̂-á yĩ̂nyõ, à kɩ yépi tɔ tyípêl yɔ̃ mɔ yé kɔ̃.  ");
INSERT INTO wib_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ǹtɛ, yépi-à névye tyípêllɛ n yɔ̃ n mɔ pélɛ n kɔ̃ ńkɛ̃̂nɛ, yé sú Liyel náh yépi tɔ tyɩ́ yɔ̃ n mɔ yé kɔ̃ n pi.» ");
INSERT INTO wib_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yesu ànɛ̂ ǹ *tõ̀ sã́hpú-á pé syɩ kyɩ Yerusalɛmɩ sɔkɔ, wǎh mɛ n kɔ *Liyel wɔ̀kɔ̀ ǹgbɛ̃ kéntáhkɩ̀ sɔkɔ gbĩ́ nɛ̂nɛ, *sárká wìlkìpu yõ̀tãm ǹgbnɔ, ànɛ̂ *Liyel ǹgbò wɛ̃̀kɩ̀ kwɔ́pú, ànɛ̂ yèwàhnɩ̀ pɔ ǹ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Tɛ́ mɛ à piki yah nɛ, nɛ̂ yĩn yõ se à n pɩ tyi nɔ́pilɛ nɩ? Nɛ̂ se à kɔ̃ ké wɛ̃̀kɩ̀lɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","À mɛ yo pé tyɩ́: «Mé kɩ tir núkú ólɛ yé piki yah. Yáh kɩ ké yah yo ń tyɩ́, nɛ̂ yĩn yõ-á mé n pɩ tyi nɔ́pilɛ, mé kɩ kè yo yé syah. ");
INSERT INTO wib_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yépi tɛ̃̀ tyɩ́, nɛ̂ tɛkɩ mɔ Nsyɔ̃nɛ, à pɔ névyelɛ n *wel n wilki? Liyel se, tĩ̂ névye se? Yé yo ń syah.» ");
INSERT INTO wib_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Képah sɔkɔ, pè tyah n yo wɛ̃ tyɩ́ nɛ, páh kɩ nɛ, Liyel-á tɛkɩ mɔ ǹnɛ, wǎh kɩ nɛ, tɛ́ kû se pɩ, tɛ́ pé náh sɛ̃ ǹ yõ nɩ? ");
INSERT INTO wib_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Pé náh se mó tɔ̃ fɛ̃ n yo n pi nɛ, névye-á tõ ǹnɛ... Pè sõ̀ mɛ tɔ́wû tíkílɛ n pɩ, képah ye. No pól sõ̀ mɛ n sõ nɛ, Nsyɔ̃nɛ, *Liyel tɛ̃ntõ̀ syínyo-ò kègbɩ-á sõ̀ ǹnɛ. ");
INSERT INTO wib_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Képah sɔkɔ, pè Yesu syah nɛ, pé náh pɩ̃. Ǹ tɔ mó yo pé tyɩ́ nɛ, nɛ̂ yĩn yõ-á pé tyi nɔ́pilɛ n pɩ, péwɔ tɔ náh mó kè yo pè syah n pi. ");
INSERT INTO wib_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Képah náh, Yesu tyah n yãh pé tyɩ́ sèmìrn sɔkɔ nɛ ńkɛ̃: «Dĩ́ yɔ́ ye lésõ dìvɛ̃ sésân sõ, tɛ́ kɛ̃kɩ mɔ kè kore vi. Tɛ́ kyɩ tɛ́dáhkɩ̀ yɔ́ yõ swɔ yɔ́ tũ, dìvɛ̃ sésân pye yĩ́kí-ńsahlɛ. Tɛ́ mɛ duke syɩ́kɩ́pú tɛ̃̀-ǹsah mɔ. Képah náh, à swãh tɔ̃́pú tɔkɔ, à pɔ swãh mɛ̀ dahbɩ pé gbõ̀, tɛ́ pyě sɔkɔ kɔ́lɔ́. ");
INSERT INTO wib_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Sé pye gbɛ gbĩ́-á pɔ nɔ, à ǹ tõ̀npɩ yɔ́ tɛkɩ mɔ dìvɛ̃ sésân swãh tɔ̃́pú nɔ́pi tyɩ́ nɛ, pè pé tyɩ́ dìvɛ̃ sésân pyelɛ à kɔ̃, à pɔ pé kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Képah tɛ̃̀nɛ, dìvɛ̃ sésân swãh tɔ̃́pú nɔ́pi tɛ̃ntõ̀ dĩ́ tɛ̃ ko, tɛ́ à fĩn mɔ, à sɔkɔ ǹ gbõ̀ kɔ́kɔ́lɛ. ");
INSERT INTO wib_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Swãh nɛ́tɛ̃̂ tɔ̃ tõ̀npɩ yɔ́ tõ. Pé tɔ̃ kyɩ ǹmɔ tɔ ko, tɛ́ à mɩkɩ ǹ yõ sɔkɔ, tɛ́ ǹnɛ n gbyɔ. ");
INSERT INTO wib_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Swãh nɛ́tɛ̃̂ tɔ̃ ǹ syɩ ǹnɩ̂ yɔ́ tɛkɩ mɔ n tɔ̃. Ǹmɔlɛ, pè ǹmɔ ko mɔ, tɛ́ sɛ̃́nkɔ̃ pɩ pé náhnáh tyɩ́: Pè pé túkù ko, tɛ́ pé túkù ko mɔ. ");
INSERT INTO wib_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Nɛ núkú nɛ̂-á sõ̀ wũ sètɛ̃̀ dĩ́ tnɔ̂, ǹmɔlɛ, ǹ nɩ̀dɛ̀ Pídĩ́ ye. À ǹmɔ tɛkɩ mɔ pé tyɩ́ tɛ́ynɛ, tɛ́ mɛ n sõ nɛ, pǎh kɩ pé pi wɔ yah sen ku. ");
INSERT INTO wib_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ǹtɛ, swãh tɔ̃́pú nɔ́pi-á à wɛ, pè tyah n yo wɛ̃ tyɩ́ nɛ, pè yah, ǹ gbɛ̃̀yõ̀pi-á n pi yɔ̀. Pè pɔ, pé à ko mɔ. Gbɛ̃kɩ mó pɩ pépi tyɩ́lɛ. ");
INSERT INTO wib_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Tɛ́ dĩ́ pídĩ́ tɛ̃ ko mɔ, tɛ́ à tɔkɔ kyɩ milki dìvɛ̃ sésân swãh kahnɩnɛ.» ");
INSERT INTO wib_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Képah sɔkɔ, Yesu pè piki yah: «Sɔ̃́ mɛ dìvɛ̃ sésân swãh nɛ́tɛ̃̂ kɩ pɔ n pɩ n pi? À náh pɔ dìvɛ̃ sésân swãh tɔ̃́pú nɔ́pi pól ko mɔ, tɛ́ kè dahbɩ n pi nósyɔ́ gbõ̀ di? ");
INSERT INTO wib_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Yé náh kè kar yah *Liyel wɛy sɛ́bɛ̃́ sɔkɔ di? Kè mɛ wã́rkɩ́nsàhnɔ́lɛ nɛ: ‹Wɔ̀kɔ̀ mɔ́pú-á dáhkɩ̀ nɛ̂ yahle, képah pɔ pɩ dáhgbɩ́lɛ, wɔ̀kɔ̀ dáhgbennɛ. ");
INSERT INTO wib_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Képah n wil Tɛ̃̀-ǹgbɛ̃ tyɩ́. Tɛ́ ápi tyɩ́, gbɛ̃̀ndùnì tir ye kélɛ!›» ");
INSERT INTO wib_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Képah sɔkɔ, *Nsyifunɔ yõ̀tãm tyah Yesu tɛ̃́-ńsahlɛ n yah n kɔ̃. Tir yɔ́ náh, pè sõ̀ pɩ̃ nɛ, pépi yõ-á à mɩ sèmìrkì mɛ̀nɛ. Tɛ́, tɔ́wû tíkí sõ̀ mɛ pè tɛ̃. Pè mɛ yɛ ǹ yõ, tɛ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Képah náh, pè *Farisiyɛ̃nɔ ànɛ̂ *Yerɔdi náh névye túkù wilki tɛkɩ mɔ Yesu tyɩ́ nɛ, pè kyɩ à mɔ yah píkínyahnɔ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Pè pɔ yo ǹ tyɩ́ nɛ, pé kwɔ́-ò dĩ́, páh pɩ̃ nɛ, gbɩ ó kɔ́kɔ́-á ǹmɔ n nɛ n yo. À náh tíkílɛ n pɩ névi yah. À náh névilɛ n wah névi sɔkɔ. Wǎh gbɩlɛ névyelɛ n kwɔ Liyel wɛ̃̀kɩ̀ yõ. Képah-á pé kɔ̃, pé nɛ, pé à piki yah: Kè se yɩ̃nɛ pé mɔ́rɩ́lɛ *Wromɛnɔ yõ̀tɛ̃̀ ǹgbɛ̃nɛ n kɔ̃, tĩ̂ kè náh yɩ̃nɛ? Pé se sélɛ n mɔ, tĩ̂ pé káh sè mɔ? ");
INSERT INTO wib_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ǹtɛ, Yesu sõ̀ pɩ̃ nɛ, nɛ̂-á pè n sõ, képah náh pè n yo. Kǎh pɩ sɛ̃́, à yo pé tyɩ́ nɛ, sɔ̃́ se pɩ, tɛ́ pè pélɛ n mɔ n yah nɩ? Pè pɔ pɔ́ mɛ̀ núkúlɛ, pé yah. ");
INSERT INTO wib_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Pè mɛ pɔ́ núkúlɛ à kɔ̃. À mɛ pè piki yah nɛ, nɛ̂ yah se, ànɛ̂ ǹ yĩnnɛ wã́rkɩ́nmɔnɔlɛ ké yõ nɩ? Pè à syah nɛ, Wromɛnɔ yõ̀tɛ̃̀ ǹgbɛ̃-á. ");
INSERT INTO wib_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Képah tɛ̃̀nɛ, à yo pé tyɩ́ nɛ, pè Wromɛnɔ yõ̀tɛ̃̀ ǹgbɛ̃nɛ n kɔ̃ ǹ tyɩ́lɛ, pè mó Liyellɛ n kɔ̃ ǹ tyɩ́lɛ. Képah sɔkɔ, pé gbã̀n du ǹ wɛy mɛ̀ dùkùlɛ. ");
INSERT INTO wib_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sadusɛ̃nɔlɛ, nósyɔ́ ye nónó-á nɛ, lékyɩ̂ náh n yuku n wil n pi. Pé túkù pɔ Yesu tnɔ̂, tɛ́ à piki yah nɛ ńkɛ̃, ");
INSERT INTO wib_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","kwɔ́-ò dĩ́, *Moyisi-á Liyel tir kõ̀nsàhnɔ́ mɛ̀ wãrkɩ sah pé kɔ̃ nɛ, dĩ́ nɛ̂ tyɩ́ gbɛ̃̀ndĩ́-à mɛ, tɛ́ tɛ̃̀ ku, tɛ́ ǹ kyɩ sah pi kɛ̃́nɛ, ǹ gbɛ̃̀ndĩ́ mɛ̀-á yɩ̃nɛ à pɛ́kúsê mɛ̀ tɔkɔ. À wɛ̃́npì dubi à kɔ̃, nónó-á kɩ pɔ n pɩ n pi ǹ nɛ́nkyɩ́dĩ́ náhnɛ. ");
INSERT INTO wib_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Tɛ́, dĩ́npì yísyɔ́-á sõ̀ mɛ nɛ́pĩ̂ kwǎrnimi pé yṹ tyɩ́. Nɛ́nkyɩ́ tɛ̃̀-á sê tɔkɔ, tɛ́ ku, tɛ́ ǹ kyɩ sah pi kɛ̃́nɛ. ");
INSERT INTO wib_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ǹ sõ̀ syɩ mɛ pɛ́kúsê mɛ̀ tɔkɔ. Ǹ tɔ pɔ ku, tɛ́ à sah pi kɛ̃́nɛ. Tɔ̃́-ò tɔ tyɩ́ pɔ pɩ sɛ̃́. ");
INSERT INTO wib_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Sɛ̃́ntɛ̃̀ ó-á pɩ pé no tɛ́lɔ́ pól tyɩ́. Tɛ́ nɛ́pĩ̂ kwǎrnimi nɔ́pi pól-á ku pi kɛ̃́nɛ. Pé kúntɛnɔ náh, pi mɛ̀ tɔ pɔ ku. ");
INSERT INTO wib_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Kàh pɩ sɛ̃́, lékyɩ̂ yúkúnwìl sṍlɛ, pàh yuku, pi mɛ̀ se kɩ pɩ nɛ̂ tyɩ́lɛ nɩ? Tir yɔ́ náh, pé nɛ́pĩ̂ kwǎrnimi pól-á à pɩ̃ sêlɛ. ");
INSERT INTO wib_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Képah sɔkɔ, Yesu yo pé tyɩ́: «Liyel wɛy pɩ̃́-ńkɛ̃̂, ànɛ̂ Liyel tɛ̃́nwɛnɔ pɩ̃́-ńkɛ̃̂ yĩn náh yélɛ pílkínɔ́ sɔkɔ di? ");
INSERT INTO wib_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Lékyɩ̂ yúkúnwìl sṍlɛ, sê tɔ́kɔ́kɩ̀ náh mɛ, pɛ dékè náh mɛ. Névye kɩ mɛ, á kɩ nɛ *yĩ̂nyõ tɛ̃̀ntõbe sɔ̃́ pal tɛ̃̀-ǹsah. ");
INSERT INTO wib_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","À yuku lékyɩ̂ yúkúnwìlnɔ́ tyɩ́ sɔkɔ: Yé náh kè kar yah Moyisi sɛ́bɛ̃́ sɔkɔ, fɩ̃́ nɛ̂-á dukuni tyɩ́lɛ n yo, nɛ̂-á sõ̀ nyàh lépɔ̃́lɛ ké sɔkɔ di? Kè mɛ wã́rkɩ́nsàhnɔ́lɛ nɛ́npɔ́ nɛ, Liyel-á yo Moyisi tyɩ́: ‹Ńmɔ ye Abrahmɩ Liyellɛ, ànɛ̂ Yisakɩ Liyellɛ, ànɛ̂ Yakɔbɩ Liyellɛ.› ");
INSERT INTO wib_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Vye Liyel ye ǹnɛ, lékyɩ̂ Liyel náh. Sɛ̃́ ye yélɛ kàhnpilkintɛ̃̀nɔ́lɛ yɔ̀.» ");
INSERT INTO wib_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Képah sɔkɔ, *Liyel ǹgbò wɛ̃̀kɩ̀ kwɔ́-ò dĩ́ yɔ́ kénɛ yékâb noh. À kè wɛ, Yesu tɛ̃ wɛ kè yo plɛ Sadusɛ̃ nɔ́pi tyɩ́. À mɛ nɔ de ǹ tnɔ̂, tɛ́ à piki yah nɛ, Liyel tir kõ̀nsàhnɔ́ nɛ̂ tɛ̃̀ se kal sé póllɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","À mɛ yo ǹ tyɩ́: «Liyel tir kõ̀nsàhnɔ́ nɛ̂-á kal sé póllɛ, képah wɛ yɔ̀: ‹Á níkí kwɔ, Yisrayɛl: Ápi Tɛ̃̀-ǹgbɛ̃ Liyellɛ, ǹmɔ núkúní ó ye Tɛ̃̀-ǹgbɛ̃ Liyellɛ. ");
INSERT INTO wib_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ǹ tyɩ́ yɩ̃nɛ kè nɔ á tyɩ́ á nɩ póllɛ, ànɛ̂ á min póllɛ, ànɛ̂ á fɔkɔ sõnɔ póllɛ, ànɛ̂ á tǎhkɩ̀ póllɛ.› ");
INSERT INTO wib_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ké ní-ò wɛ yɔ̀: ‹Á ní-ò tyɩ́ yɩ̃nɛ kè nɔ á tyɩ́ á gblɔ̌y tyɩ́ kɔ̃lɛ.› Liyel tir kõ̀nsàhnɔ́ yɔ́ ńtɛ̃ náh tɔ̃ kal sépi nínɔ́lɛ.» ");
INSERT INTO wib_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Wǎh yo sɛ̃́, Liyel ǹgbò wɛ̃̀kɩ̀ kwɔ́-ò dĩ́ mɛ yo ǹ tyɩ́ nɛ, kǎh plɛ, pé kwɔ́-ò dĩ́! Tyi nónó-á à yo, gbɩ-á sélɛ. Tɛ̃̀-ǹgbɛ̃nɛ, ǹmɔ núkúní ó-á Liyellɛ. Liyel yɔ́ náh tɔ̃ mɛ ǹmɔ tyɩ́ náh. ");
INSERT INTO wib_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ǹmɔ tyɩ́-á yɩ̃nɛ kè nɔ á tyɩ́ á nɩ póllɛ, á fɔkɔ sõnɔ póllɛ, á tǎhkɩ̀ póllɛ. Ànɛ̂ á ní-ò tyɩ́ mó nɔ á tyɩ́ á gblɔ̌y tyɩ́ kɔ̃lɛ. Képah-á kɩ plɛ kal á yípɛ̃̂ ko sukɛ Liyel kɔ̃ *sárkálɛ, ànɛ̂ sárká duke tɛ́lɔ́ póllɛ. ");
INSERT INTO wib_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Képah sɔkɔ, Yesu kè wɛ nɛ, ǹ lékã́m-á nɔ, à ké yah wɛ tɔ̃ sah yo. À yo ǹ tyɩ́ nɛ, à náh mɛ fɩ́ɩ́ *Liyel tɔ̃́rɩ́lɛ. Képah náh, névi náh tɔ̃ fɛ̃ syi à piki yah tir yɔ́lɛ. ");
INSERT INTO wib_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesu sõ̀ mɛ névyelɛ n kwɔ *Liyel wɔ̀kɔ̀ ǹgbɛ̃ kéntáhkɩ̀ sɔkɔ, tɛ́ mɛ n yo nɛ, sɔ̃́ se pɩ, tɛ́ *Liyel ǹgbò wɛ̃̀kɩ̀ kwɔ́pú n nɛ n yo nɛ, *Kristalɛ, nɛ̂-á Liyel nɛ, páh kɩ tɛkɩ mɔ, ǹmɔ-á kɩ pɩ *Davidi náh nɛnɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Tir yɔ́ náh, Davidi ńtɛ̃ sõ̀ kè yo *Liyel Mírkí gbõ̀ yõ nɛ, Tɛ̃̀-ǹgbɛ̃ Liyel-á kè yo péwɔ Tɛ̃̀-ǹgbɛ̃ tyɩ́ nɛ: «Kɔ̃ tɛ̃ ńmɔ gbõ̀yõ̀ sõ̀lɛ, mé kɩ á sépɛ́bɩ́ pɩ á gbáhsúkílɛ.» ");
INSERT INTO wib_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Davidi ńtɛ̃-à ǹnɛ n ye ǹ Tɛ̃̀-ǹgbɛ̃nɛ, kè kɩ pɩ sɔ̃́, tɛ́ à kɩ pɔ n pɩ Davidi náh nɛnɛ? Légbĩ́nɛ, tɔ́wû ǹgbɛ̃ sõ̀ mɛ wɛy mɛ̀nɛ n nohnɩ Yesu tyɩ́ nɩ̀vɩ̀nɩ̀ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Wǎh mɛ névye kwɔ́nɔ́ sɔkɔ gbĩ́ nɛ̂nɛ, à yo pé tyɩ́: «Yé yé gblɔ̌ynɛ n kyɔmɩ *Liyel ǹgbò wɛ̃̀kɩ̀ kwɔ́púlɛ. Fwɔ̀mɔn ǹgbnɔ mɔ́nkɔnkɔ̃nɔ tyɩ́ nɔ pé tyɩ́. Pé n nɛ mɛ ké tyɩ́ nɛ, névye nɛ n tɔ̃ n sah n wɛkɩ pé tyɩ́ tɔ́wû tùkè-ǹtã̀n sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Pě tɛ̃̀-ǹtã̀n ǹgbnɔlɛ n yah n kɔ̃ *Liyel ní-ńtã̂n vɩ̀ sɔkɔ, ǹ tɛ́ nɛ́-ǹgbnɔ tɛ̃̀-ǹtã̀nnɛ n yah n kɔ̃ yõke ǹgbnɔ yṍ-ńtã̂n sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ǹtɛ nɛ n syɩkɩ pɛ́kúsyɔ yõ, pé gbã̀n yîlɛ n syi yĩ́nvǐ sɔkɔ. Ǹtɛ nírílɛ n pɩ yõ̀sɛ̃̀kɩ̀lɛ nɛ, névye pé wɛ. Sɛ̃́ ye pé tukey kɩ tuke képékè yɔ́.» ");
INSERT INTO wib_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Légbĩ́nɛ, Yesu sõ̀ mɛ kɔ̃́ntɛ̃̀nɔ́lɛ Liyel wɔ̀kɔ̀ yah, pɔ́ dáhnmɔ-ńsah kwâh gbɔ̀pɔ, tɛ́ névye pɔ́ dáhnmɔ dùkùlɛ n yah. Tahbɩ náhnáh sõ̀ mɛ pɔ́ náhnáhlɛ n dah n mɔ n pɔ. ");
INSERT INTO wib_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Dǒ, pɛ́kúsê yãm nɛ yɔ́ pɔ, pɔ́ plɔ́ nínɔ́ dah mɔ. Sè sõ̀ mɛ núkú núkúnɔ nínɔ́ ólɛ. ");
INSERT INTO wib_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Képah sɔkɔ, Yesu ǹ *tõ̀ sã́hpú ye, tɛ́ yo pé tyɩ́: «Kègbɩ yõ, mé kélɛ n yo yé tyɩ, pɛ́kúsê yãm nɛ mɛ̀-á pɔ́ nɛ̂ dah mɔ kwâh sɔkɔ, kè kal névye pól tyɩ́lɛ. ");
INSERT INTO wib_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Tir yɔ́ náh, no pól pɔ́ yõ dòhnɔ̀nɔ́ ye, pè dah mɔ. Ǹtɛ, ǹmɔ ànɛ̂ ǹ yãm tɔ́lɛ, ǹ sahkɩ pól ye à dah mɔ, wǎh nɛ pɔ nɛ̂ tɔ yõ n pi.» ");
INSERT INTO wib_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu-á n wil *Liyel wɔ̀kɔ̀ ǹgbɛ̃ kéntáhkɩ̀ sɔkɔ gbĩ́ nɛ̂nɛ, ǹ *tõ̀ sã́hpú sɔkɔ nɛ yɔ́ mɛ à syah nɛ, kwɔ́-ò dĩ́, à vɩ̀ ǹgbnɔ nɔ́pi mɔ dùkù tɛ̃̀nɛ n yah, dyêh pèplɔlɛ dɛ́! ");
INSERT INTO wib_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesu mɛ yo ǹ tyɩ́: «Á vɩ̀ ǹgbnɔ nɔ́pi mɔ́nɔ́ wɛ kɛ̀! Sé pól kɩ pɔ sɛkɩ. Dáhkɩ̀ núkú ńtɛ̃ náh n wũ n pi ké ní-ò yõ.» ");
INSERT INTO wib_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Képah náh, Yesu kyɩ kɔ̃ tɛ̃ Wólívyê sésân yɔ̃lɩ yõ, Liyel wɔ̀kɔ̀ ǹgbɛ̃ yèsreynɛ. Wǎh mɛ nɛ́npɔ́, Pyɛrɩ, ànɛ̂ Nsyahkɩ, ànɛ̂ Nsyɔ̃, ànɛ̂ Andrepi pɔ pé yahlɛ, tɛ́ à piki yah nɛ, ");
INSERT INTO wib_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","gbĩ́ nɛ̂ se tyi nɔ́pi pól kɩ n pɩ n pi nɩ? Ńkɛ̃, à yo pé syah. Tyi nónó se kɩ sé pɩ gbĩ́nɛ pé wɛ̃kɩ nɩ? ");
INSERT INTO wib_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Képah sɔkɔ, Yesu tyah n yo pé tyɩ́: «Yé yé gblɔ̌ynɛ n kyɔmɩ, nɛ káh yé pilki. ");
INSERT INTO wib_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Névye náhnáh kɩ pɔ ńmɔ yĩn tɔkɔ n pi, tɛ́ kɩ nɛ, pépi-á *Kristalɛ. Pè kɩ névye náhnáh pilki. ");
INSERT INTO wib_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Yâh mâl tyɩ́lɛ n nohnɩ gbĩ́ nɛ̂nɛ, yé gbɔ̀plɔ ànɛ̂ fɩ́ɩ́ sɔkɔ, yé káh yɛ tíkí yé tɛ̃. Sépi ye yɩ̃nɛ sè pɩ. Ǹtɛ, képah náh tɔ̃̌nɩ̀ kèkõyṍ tyɛ́nɔ́lɛ. ");
INSERT INTO wib_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Kwil yɔ́ kɩ yuku kwil yɔ́lɛ n fwo, yõ̀tɛ̃̀ yɔ́ kɩ yuku yõ̀tɛ̃̀ yɔ́lɛ n fwo. Tɛ́, sétáh syahrɩ kɩ mɛ n pɩ tyahnɔ́ túkù sɔkɔ, ànɛ̂ kwɛkɩlɛ. Kè kɩ mɛ, á kɩ nɛ sê kúrkì tɛ̃ gbĩ́ yɔ́nɔ́ sɔ̃́. ");
INSERT INTO wib_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Képah ye, yépi tɛ̃̀ wɔlɛ, yé yé gblɔ̌ynɛ n kyɔmɩ. Tir yɔ́ náh, névye kɩ yélɛ n tɛ̃ n kyɩ n pɔ tukey tùkè-ǹtã̀n sɔkɔ. Pè kɩ yélɛ n ko *Liyel ní-ńtã̂n vɩ̀ sɔkɔ, tɛ́ kɩ yélɛ n tɛ̃ n kyɩ n pɔ yõ̀tãm ànɛ̂ yõ̀tãm ǹgbnɔ tyɩ́ ńmɔ yĩnnɛ nɛ, yé pɩ ńmɔ tàrfyɔ̀nɔ́lɛ pé yah sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Tɛ́ sépi-à pópó nɛ n pɩ, nɩ̀vɩ̀nɩ̀ wɛy sã́n ǹgbò yɩ̃nɛ ké nɛ mɛ yo kɔ̃ kèkõyṍ kwlo kwlo pól névye tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ǹtɛ, pàh yé tɛ̃ n yuku pé gbõ̀ dáhbɩ́-ńsah, yé káh tɔ̃̌nɩ̀ yé fɔkɔlɛ n sõ, yáh nɛ tyi nónó yo n pi. Tyi nónó-à de yé fɔkɔ légbĩ́nɛ, yé kɩ sépi yo. Tir yɔ́ náh, tyi nónó-á yé kɩ n yo n pi, sè náh n wil n pi yépi tyɩ́, sè n wil *Liyel Mírkí tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Névye kɩ pé yṹpyé gbàhlɛ n dɛ n mɔ nɛ, pè pè ko mɔ, súbí tɔ kɩ n pɩ sɛ̃́ntɛ̃̀nɛ pé wɛ̃́npì tyɩ́. Wɛ̃́npì tɔ kɩ pé dúbípúlɛ n fwo, kɩ pélɛ n dah n mɔ kũ sɔkɔ, pé ku ku tɛ̃̀nɛ. ");
INSERT INTO wib_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Névye pól kɩ yé wɛ mɔ ńmɔ yĩnnɛ. Ǹtɛ, névi nɛ̂-à ǹ tah sah, à pɔ nɔ kɩ tyɛ gbĩ́ tyɩ́, tɛ̃̀ kɩ pwáhnmɔnɔ wɛ.» ");
INSERT INTO wib_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Képah sɔkɔ, Yesu tɔ̃ yɔ̃ sɔkɔ ǹ wɛynɛ - ǹtɛ, wɛy mɛ̀ kàrpu yɩ̃nɛ pè ké dùkù pɩ̃. À nɛ: «Yé kɩ yɩ́kɩ́nɔ́ pɩ́-ò képékè wɛ fɩ̃́ yɔ́, à náh sõ̀ yɩ̃nɛ tɛ̃̀nɔ́lɛ ńyãh sɔkɔ. Légbĩ́nɛ, nónó-à mɛ Yude, pè yɩ̃nɛ pè to de ymɔ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Névi nɛ̂-à mɛ gbɛ̃́ntĩ̂n yõ, tɛ̃̀-à tiki, à káh nɛ, páh n de kwâhlɛ n tɔkɔ pé wɔ̀kɔ̀. ");
INSERT INTO wib_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Nɛ̂-à se mɛ swãh sɔkɔ, à káh nɛ, páh pé syɩ n yuku fwɔ̀mɔ̀-ǹgbɛ̃ tɔ́kɔ́-ńsah pé tĩ̂nnɛ. ");
INSERT INTO wib_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Tɛ́ kénɛ sèpĩ̀n kɩ pɩ tyípékèlɛ syɔ́ kûrn nɛ́tãn, ànɛ̂ yɔ̃kɩ nɛ́tãn tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Képah ye, yé Liyellɛ n ni, kè káh pɩ ki sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Tir yɔ́ náh, kénɛ sèpĩ̀n kɩ pɩ yèvyãhrɩ ǹgbɛ̃nɛ, nɛ̂ kénkɔ̃ náh wɛ yah, Liyel-á kèkõyṍ mɔ sɔ̃́, à pɔ syɩ núkúnúkú tyɩ́. Ànɛ̂ sɛ̃́nkɔ̃ náh tɔ̃ wɛ n yah n pi. ");
INSERT INTO wib_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ǹtɛ, Liyel ńtɛ̃-à mɛ ké yáhntɔkɔ-ńkɛ̃̂nɛ nɛ, páh kɩ wìlkìnɔ́ pɩ kénɛ sèpĩ̀n sɔkɔ, ǹnɩ̂ yɔ́ ńtɛ̃ min náh náh n wil n pi ké sɔkɔ. Ǹtɛ, wǎh nónó yah tɔkɔ pɩ ǹ tyɩ́lɛ, pépi yĩn ye à wìlkìnɔ́ pɩ kénɛ sèpĩ̀n sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Képah ye, névi-à yo yé tyɩ́ nɛ, yé yah, *Krista-á mɛ ásõ̂, képah náh pɩ, wǎh mɛ wrɔ́ mɛ̀, yé káh sɛ̃ tɛ̃̀ yõ. ");
INSERT INTO wib_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Tir yɔ́ náh, mɩ̀nyobe túkù kɩ n wil n pi, tɛ́ kɩ nɛ, pépi-á Kristalɛ. Túkù kɩ mó tɔ̃ wil nɛ, pépi-á *Liyel tɛ̃ntõ̀ syínyopulɛ. Pè kɩ gbǐl duke dukelɛ n pɩ, kɩ n yah n kɔ̃ Liyel névye yáhntɔkɔnɔ ńtɛ̃ pílkí-ńsahlɛ, pàh náh fɛ̃ n tɛ̃ n pi. ");
INSERT INTO wib_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Képah ye, yépi tɛ̃̀ wɔlɛ, yé yé gblɔ̌ynɛ n kyɔmɩ. Mé ye sé pól kwãh yo sah yé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Kénɛ sépĩ́n sɔkɔ, yèvyãhrɩ mɛ̀ sɔ́kɔ́ntɛnɔ náh, gbĩ kɩ pɩ fɛ̃́ntũ̂nɛ, ńwɔ̃́ náh tɔ̃ n piki n pi, ");
INSERT INTO wib_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ńwɔ̃́ képye kɩ wil yĩ̂nyõ kɩ syɩkɩlɩ, yĩ̂nyõ tǎhkɩ̀nɔ́ kɩ yike. ");
INSERT INTO wib_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ké légbĩ́nɛ, yé kɩ *Névi Pi wɛ, à kɩ n pi ńyîrn wrɔ́ ǹ tǎhkɩ̀ ǹgbɛ̃ ànɛ̂ ǹ gblò sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","À kɩ *yĩ̂nyõ tɛ̃̀ntõbe tɛkɩ mɔ kèkõyṍ yey yey pól sɔkɔ, pè kɩ ǹ névye yáhntɔkɔnɔ tuke mɔ, à tɔkɔ yõ mɛ̀ tyɩ́, á pɔ syɩ yõ mɛ̀ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Yé kè pɩ̃ kwɔ́nɔ́ nɛ̂-á sènsóké n kɔ̃: Ni-à mɛ n kɔ ké yɩ̃̀ngbã̀n sɔkɔ, kě mɩ pɩ, yé n pɩ̃ nɛ, ki de gbĩ́-á nɔ. ");
INSERT INTO wib_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Sɛ̃́nkɔ̃-ó ye: Yáh tyi nɔ́pi wɛ, sè n pɩ, yé pɩ̃ nɛ, *Névi Pi pɔ́nɔ́-á de tɛ, wǎh mɛ yúkɛy. ");
INSERT INTO wib_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Kègbɩ yõ, mé kélɛ n yo yé tyɩ́, kwɛy gbĩ́ névye pól náh n ku n tɛ n pi, nɛ́ tyi nɔ́pi pól náh pɩ. ");
INSERT INTO wib_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Yĩ̂nyõ ànɛ̂ sétáh kɩ pɔ sɔkɔ, ǹtɛ ńmɔ wɛlɔ náh n sɔkɔ n pi póllɛ. ");
INSERT INTO wib_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Tɛ́ ké lésõlɛ ànɛ̂ ké gbĩ́nɛ, ǹnɩ̂ yɔ́ ńtɛ̃ náh kè pɩ̃: *Yĩ̂nyõ tɛ̃̀ntõbe náh kè pɩ̃, Liyel Pi ńtɛ̃ tɔ náh kè pɩ̃. Sú núkúní ó ye kè pɩ̃. ");
INSERT INTO wib_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Yé yé gblɔ̌ynɛ n kyɔmɩ, yé mó nɛ n yah. Tir yɔ́ náh, yé náh ké pɔ gbĩ́ pɩ̃. ");
INSERT INTO wib_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Kè mɛ, á kɩ nɛ dĩ́ yɔ́ sɔ̃́ n sɔkɔ kɔ́lɔ́, tɛ́ ǹ fṍ dahbɩ ǹ tɛ̃̀ntõbe gbõ̀. À pé pól nɛ núkú núkú wɛ̃kɩ pé tã̀nnɛ, tɛ́ yo gbô syɩ́kɩ́-ò tyɩ́ nɛ, à káh nɛ n dɔ, à nɛ n yah. ");
INSERT INTO wib_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Képah ye pɩ yépi tɔ nɛ n yah, tir yɔ́ náh, yé náh gbóntɛ̃̀ pɔ sṍ pɩ̃: Kè kɩ pɩ ńvɩ̃́nɛ nɩ? Kè kɩ pɩ lénɩlɛ nɩ? Kè kɩ pɩ snǐ gbo gbĩ́nɛ nɩ? Kè kɩ pɩ séngbɔ̃́lɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Wàh n pi, à káh pɔ yé wɛ tɛ̃ dɔy sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ǹtɛ, nɛ̂-á mé n yo yé tyɩ́, mé kélɛ n yo no pól tyɩ́: Yé nɛ mɛ n yah.» ");
INSERT INTO wib_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","*Pakɩ syáh-á n tyah yĩ́níntɛ̃nɔlɛ, ké tɛ́y sõ̀ wũ sèpĩ̀n nínì, tɛ́ Pakɩ ànɛ̂ sɛ̃̀-ǹkɛ̃̂ búrn syáh kɩ n syah n pi. Légbĩ́nɛ, *sárká wìlkìpu yõ̀tãm ǹgbnɔ ànɛ̂ *Liyel ǹgbò wɛ̃̀kɩ̀ kwɔ́pú sõ̀ mɛ Yesu tɛ̃́-ńsahlɛ n yah n kɔ̃ yĩ́nvǐ sɔkɔ, ǹ kònmɔ mɔ tɛ̃̀nɛ. ");
INSERT INTO wib_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Pè sõ̀ mɛ n yo wɛ̃ tyɩ́ nɛ, pé náh fɛ̃ tir mɛ̀ pɩ n pi syáh syáhnɔ́ sèpĩ̀n sɔkɔ, kǎh kɩ fɛ̃ kwil névye fɔ̀kɔ̀vyã̀hnɩ̀ yilki mɔ kègbɩlɛ. ");
INSERT INTO wib_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ké lésõlɛ, Yesu sõ̀ mɛ Betani kwil sɔkɔ, *tótɛ̃ dĩ́ Simo gbô sɔkɔ. Wǎh sõ̀ mɛ yṍnɔ́ sɔkɔ gbĩ́ nɛ̂nɛ, sê yɔ́ de yuku pé tnɔ̂ nɩrɩ so pèpɛy yɔ́lɛ, làsèkwěl dan tahlɛ ké yĩ́ĩ́nɛ. À ké yah yɩkɩ mɔ, tɛ́ ké kwɛ mɔ Yesu yõ. ");
INSERT INTO wib_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Nónó-á sõ̀ mɛ nɛ́npɔ́, kè náh sõ̀ nɔ túkù tyɩ́. Pè yuku n yo wɛ̃ tyɩ́ nɛ, kû se pɩ, tɛ́ à làsèkwěl mɛ̀ yɩkɩ sɛ̃́ nɩ? ");
INSERT INTO wib_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Kǎh kɩ sõ̀ fɛ̃ yãm, kɩ kah pɔ́ plɔ́ kyɛtɔ̃nɩ́ yõ, tɛ́ kɩ sélɛ yãmtãm kɔ̃. Tɛ́ mɛ pé fɔkɔ vyãh pi mɛ̀nɛ kègbɩlɛ. ");
INSERT INTO wib_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ǹtɛ, Yesu mɛ yo pé tyɩ́: «Yé yɛ ǹ yõ! Kû pɩ, tɛ́ yé ǹ yahlɛ n vyãh? Tyi pèpɛy ye à pɩ ńmɔ tyɩ́ sɛ̃́ yɔ̀. ");
INSERT INTO wib_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ǹtɛ, yãmtãm kɩ mɛ ànɛ̂ yélɛ sõmɛsṍ. Yé kɩ fɛ̃ pèpɔrɩlɛ n pɩ pé tyɩ́, kàh nɔ yé tyɩ́ gbĩ́ nɛ̂nɛ. Ǹtɛ, ńmɔ tɛ̃̀ wɔ náh n mɛ n pi yélɛ sõmɛsṍ. ");
INSERT INTO wib_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Pi mɛ̀ pɩ pɩ tɛ̃̀ ye à pɩ. À kwãh tɛ̃ làsèkwěl mɔ ńmɔ wil yõ. À kè tɔ̃ sah tɛ diki sɔkɔ dáhnmɔ yĩnnɛ. ");
INSERT INTO wib_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Mé kɩ kè yo yé syah kègbɩ yõ nɛ, kèkõyṍ pól sɔkɔ, nɩ̀vɩ̀nɩ̀ wɛy sã́n-à n yo ńyãh, pi mɛ̀-á nɛ̂ pɩ, képah tɔ kɩ n yo. No dyɔ kɩ n kwnɛ ǹ tyɩ́lɛ.» ");
INSERT INTO wib_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Yudasi Yisikaryɔtilɛ, Yesu *tõ̀ sã́hpú nɛ́pĩ̂ gbɔ̃nimí sɔkɔ yɔ́ ye sõ̀ ǹnɛ. Ǹmɔ sɔkɔ à kyɩ yo *sárká wìlkìpu yõ̀tãm ǹgbnɔ tyɩ́ nɛ, páh kɩ fɛ̃ Yesu dahbɩ pé gbõ̀. ");
INSERT INTO wib_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Kǎh pɩ sɛ̃́, ǹ wɛy mɛ̀ nóhnɔ́ kah nɔ pé tyɩ́. Pè mɛ yo sah núkú yõ nɛ, páh kɩ pɔ́ dan yɔ́lɛ à kɔ̃. Képah sɔkɔ, Yudasi-á pɩ sɔ̃́, tɛ́ à dahbɩ n pi pé gbõ̀, à tyah képah sɔ́kɔ́-ńsahlɛ n yah n kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Sɛ̃̀-ǹkɛ̃̂ búrn syáh tyah sṍlɛ, Yesu *tõ̀ sã́hpú à piki yah nɛ, ńyãh sɔkɔ se à mɛ ké tyɩ́ nɛ, pé kyɩ *Pakɩ yõke pɩ ǹ tyɩ́ nɩ? *Nsyifunɔ ńkɛ̃́nɛ Pakɩ képyɛ̂nnɛ n ko lésõlɛ, képah ye. ");
INSERT INTO wib_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Képah sɔkɔ, à ǹ tõ̀ sã́hpú nɛ́pĩ̂ nímí wilki tõ, tɛ́ yo pé tyɩ́ nɛ, pè kyɩ kwil sɔkɔ. Pàh kɩ de n tɛ, pǎh kɩ dĩ́ yɔ́ yohnɩ, à kɩ mɛ ni pĩ́n twah. Pè ǹ sõ̀ tɛ̃. ");
INSERT INTO wib_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Wàh kɩ kyɩ de gbô nɛ̂, pè yo kénɛ gbô nɛ́tɛ̃̂ tyɩ́ nɛ, kwɔ́-ò dĩ́-á nɛ, wɔ̀kɔ̀ nɛ̂ sɔkɔ se pé kɩ pɔ n yõ n pi Pakɩ yõkelɛ ànɛ̂ pé tõ̀ sã́hpúlɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Wǎh kɩ pè wɛ̃kɩ yĩ̂nyõ wɔ̀kɔ̀ sɔkɔ táh ǹgbɛ̃ yɔ́lɛ. Yíyìn pól-á kɩ mɛ tɔ̃́nsàhnɔ́lɛ ké sɔkɔ. Ké nɛ́npɔ́ sɔkɔ-á pè kɩ Pakɩ yõke pɩ pé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Wǎh yo sɛ̃́, ǹ tõ̀ sã́hpú kyɩ kwil sɔkɔ, tɛ́ pè ńtyɩ̃́nɔ kyɩ tyi pól wɛ, wǎh sõ̀ kè yo sɔ̃́ pé tyɩ́. Pè mɛ Pakɩ yõke pɩ nɛ́npɔ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Képah sɔkɔ, ńvɩ̃́-á pɔ nɔ, à pɔ de ànɛ̂ ǹ tõ̀ sã́hpú nɛ́pĩ̂ gbɔ̃nimínɛ. ");
INSERT INTO wib_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Pǎh sõ̀ mɛ yṍnɔ́ sɔkɔ gbĩ́ nɛ̂nɛ, à yo pé tyɩ́ nɛ, kègbɩ yõ, pépi sɔkɔ nɛ yɔ́-á kɩ pɔ n vi n pi péwɔ náh, nɛ̂-á mɛ n yõ pélɛ fɩ̃́ núkú. ");
INSERT INTO wib_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ǹ tõ̀ sã́hpú-á képah noh, pé yah kwɔ kègbɩlɛ. Pè tyah ǹnɛ n piki yah núkú núkúlɛ. Ńyɔ n nɛ, péwɔ se nɩ, ńyɔ n nɛ, péwɔ se nɩ? ");
INSERT INTO wib_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","À yo pé tyɩ́: «Yépi nɛ́pĩ̂ gbɔ̃nimí sɔkɔ, nɛ̂-á mɛ n di ńmɔlɛ tɛ̃̀ngbil núkú sɔkɔ, tɛ̃̀ wɔ ye. ");
INSERT INTO wib_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Kègbɩ yõ, *Névi Pi kɩ n ku n pi, sɔ̃́-á sõ̀ *Liyel wɛy sɛ́bɛ̃́nɔ́ kè yo sah ǹ tyɩ́ sɔkɔ. Ǹtɛ, tyípékè ǹgbɛ̃ ye kélɛ ǹ gbàh dɛ́nmɔ-ò tyɩ́! Ǹ dúbí-ńkɛ̃̂ ye náhkɩ fṍnfṍ ǹ dúbínɔ́ yõ.» ");
INSERT INTO wib_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Képah sɔkɔ, yõke yõ gbĩ́nɛ, à búrn tɔkɔ, tɛ́ wɛkɩ Liyel tyɩ́, tɛ́ kɩ kwɔkɩ dibi pè kɔ̃, tɛ́ yo pé tyɩ́: «Yé syi kélɛ, ńmɔ wil ye.» ");
INSERT INTO wib_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Képah náh, à mɛ dìvɛ̃ wɔ wɔ kwâh tɔkɔ dìvɛ̃nɛ ké sɔkɔ, tɛ́ wɛynɛ Liyel kɔ̃, tɛ́ kélɛ ǹ *tõ̀ sã́hpú kɔ̃ pé pól wɔ ké sɔkɔ, ");
INSERT INTO wib_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","tɛ́ yo pé tyɩ́: «Képahlɛ, ńmɔ tṍ ye, nɛ̂-á kɩ névye yégbékè kwrɔ mɔ ànɛ̂ Liyellɛ. Kè kɩ kwɛ tɔ́wû yĩnnɛ. ");
INSERT INTO wib_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Mé kélɛ n yo yé tyɩ́ kègbɩ yõ: Mé náh tɔ̃ dìvɛ̃ wɔ n yah n pi. Mâh pópó dìvɛ̃nɛ n wɔ tɔ̃ ńtɔ̃, dìvɛ̃ sã́n yɔ́ ye *Liyel yõ̀tɔ̃rɩ́ tyah sɔkɔ.» ");
INSERT INTO wib_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Képah náh, pè Liyel gbílkínɔ́ yɩ̀ gbɩ. Pǎh gbɩ tɛ, pè yuku Wólívyê sésân yɔ̃lɩ yõ. ");
INSERT INTO wib_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Pǎh kyɩ nɛ́npɔ́, à yo pé tyɩ́: «Yé pól kɩ ńmɔ yahle n pi. Sɔ̃́-á *Liyel wɛy sɛ́bɛ̃́nɔ́ kè yo sah nɛ, yípɛ́nfɛ̃-á kɩ ko mɔ, tɛ́ yípɛ̂y pól-á kɩ to karkɩ gbɔ̀plɔlɛ.» ");
INSERT INTO wib_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Képah náh, à tɔ̃ yɔ̃ sɔkɔ yo pé tyɩ́: «Mâh pɔ yuku ń kṹntɛnɔ náh gbĩ́ nɛ̂nɛ, mé kɩ kyɩ yélɛ n syɩkɩ Kalile sɔkɔ.» ");
INSERT INTO wib_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Képah tɛ̃̀nɛ, Pyɛrɩ mɛ yo ǹ tyɩ́ nɛ, tɛ́lɔ́ pól-à kɩ sɔ̃́ à yahle, péwɔ tɛ̃̀ wɔ náh à yahle n pi. ");
INSERT INTO wib_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ǹtɛ, Yesu mɛ yo ǹ tyɩ́ nɛ, páh kélɛ n yo ǹ tyɩ́ kègbɩ yõ, kwɛy lékã̂h mɛ̀ sɔkɔ, sénpɛ-à kɩ pópó n gbo kɛ nínɔ́, wǎh kɩ mɛ ǹ vyãh kɔ̃lɩ tɛ kɛ tɔ̃́nɔ́ nɛ, pé náh péwɔ pɩ̃. ");
INSERT INTO wib_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ǹtɛ, Pyɛrɩ tɔ̃ kè tɔ̃ yo yĩ́ĩ́ ǹ tyɩ́ nɛ, kũ fyé-à sɔ̃́, páh kɩ ku ǹnɛ. Pé náh n yo n yah n pi póllɛ nɛ, pé náh ǹnɛ n pnɛ. Pé no tɛ́lɔ́ pól tɔ yo sɛ̃́. ");
INSERT INTO wib_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Képah náh, pè sɔkɔ tyah yɔ́, ńyãh-á pè n ye Yesemaninɛ. Pǎh yĩni tɛ̃ nɛ́npɔ́ sɔkɔ, à yo ǹ *tõ̀ sã́hpú tyɩ́ nɛ, pè tɛ̃ ásõ̂, pé mó kyɩ Liyel ni pɔ. ");
INSERT INTO wib_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Wǎh n sɔkɔ, à Pyɛrɩ ànɛ̂ Nsyakɩ, ànɛ̂ Nsyɔ̃ tɛ̃ sɔkɔ. Tɛ́ légbĩ́nɛ, ǹ fɔkɔ sõ̀ mɛ fɛ̃kɩ, tɛ́ tíkí mɛ à kah tɛ̃. ");
INSERT INTO wib_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Képah sɔkɔ, à yo pé tyɩ́: «Yèkwɔrɩ mɛ ń sɔkɔ, kè sɔ̃́ ńnɛ n ko. Yépi tɛ̃ ásõ̂, tɛ́ yé káh nɛ n dɔ!» ");
INSERT INTO wib_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Tɛ́ yuku yah tĩ̂nnɛ kwéy, à kyɩ gbètukunɔ di, tɛ́ yo Liyel tyɩ́ nɛ, kàh kɩ fɛ̃ pɩ n pi, à pé wilki kwlɔ́nɔ́ mɛ̀ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","À tɔ̃ yo pé kwil wɛy sɔkɔ: «Aba, bɔ̌, tyi pól mɛ áwɔ gbõ̀. Ńmɔ wilki yèvyãhrɩ mɛ̀ sɔkɔ. Ǹtɛ, nɛ̂-á mɛ ké sɔkɔ, ńmɔ dyɔ yĩ́ĩ́ tɛ̃̀ káh pɩ, tɛ́ áwɔ tyɩ́ mó pɩ.» ");
INSERT INTO wib_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Wǎh nírí pɩ tɛ, à ǹ syɩ pɔ tõ̀ sã́hpú nɛ́pĩ̂ tɔ̃́mɩ́ nɔ́pi tnɔ̂, à pɔ pè wɛ pè mɛ n dɔ. À yo Simo Pyɛrɩ tyɩ́: «Á mɛ n dɔ kɛ̀? Á náh tɛ̃ wɛ yah kwéy kè nɔ lɛ́r núkú ńtɛ̃nɛ kɛ̀. ");
INSERT INTO wib_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Yé gbah tɛ̃ yé nɛ n yah, yé mó Liyellɛ n ni, yé káh pɔ *sétõ tɔ̃̀nmɔnɔ fɛ̃ syi. Fɔkɔ sõnɔ pèpɛy mɛ névi sɔkɔ, tɛ́ ké pɩ́nɔ́ tǎhkɩ̀ náh mɛ ǹ sɔkɔ.» ");
INSERT INTO wib_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Wǎh yo tɛ pé tyɩ́ sɛ̃́, à yal pé tnɔ̂, tɛ́ tɔ̃ kyɩ nírí pɩ gben tɛ̃̀ tyɩ́ kɔ̃lɛ. ");
INSERT INTO wib_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Képah náh, à ǹ syɩ pɔ ǹ tõ̀ sã́hpú tnɔ̂ ńtɔ̃. À pɔ pè wɛ, dɔy mɛ tɛ̃ wɛ pé tyɩ́. Yo yo tir náh tɔ̃ wɛ pé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Wǎh tɔ̃ kyɩ pɔ kɛ tɔ̃́-òlɛ, à yo pé tyɩ́: «Yé mɛ sɛ̃ tɛ̃ yélɛ n mɩ kɛ̀? Kè tyɛ! Ké gbĩ́ nɔ. Núkúnúkú, *Névi Pi kɩ dahbɩ nɛ́pêl gbõ̀. ");
INSERT INTO wib_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Yé yuku á sɔkɔ! Yé yah, névi nɛ̂-á ńmɔlɛ n dahbɩ pé gbõ̀, tɛ̃̀ pɔ tɛ.» ");
INSERT INTO wib_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Wǎh mɛ képah yónɔ́ sɔkɔ sɛ̃́, à náh tɔ̃̌nɩ̀ yo tɛ, tɛ́ Yudasi, nɛ̂-á ǹ *tõ̀ sã́hpú nɛ́pĩ̂ gbɔ̃nimí sɔkɔ yɔ́lɛ, ǹmɔ yĩn mɛ́fwóbé nɛ́kwĩ́nkí yísyɔ́ yah, à pɔ kèkîrn ànɛ̂ léplólɛ pé gbã̀n. *Sárká wìlkìpu yõ̀tãm ǹgbnɔ ànɛ̂ *Liyel ǹgbò wɛ̃̀kɩ̀ kwɔ́pú ànɛ̂ yèwàhnɩ̀ ye sõ̀ tɛkɩ mɔ pélɛ. ");
INSERT INTO wib_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Tɛ́ nɛ̂-á sõ̀ Yesu dahbɩ n pi pé gbõ̀, à sõ̀ mɛ pɩ dùkù yɔ́lɛ pè wɛ̃kɩ sah. À nɛ, páh kɩ pɔ wɛkɩ nɛ̂ tyɩ́ tɛ́ à pɔrɩ tɛ̃, ǹmɔ-á. Pè à tɛ̃, pè mó ǹnɛ n kyɔmɩ n yuku pallɛ. ");
INSERT INTO wib_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Képah sɔkɔ, wǎh núkú pɔ yĩni tɛ̃ Yesu tyɩ́, à wɛkɩ ǹ tyɩ́ nɛ, pé kwɔ́-ò dĩ́, tɛ́ núkú à pɔrɩ tɛ̃. ");
INSERT INTO wib_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Kǎh pɩ sɛ̃́, no nɔ́pi núkú pɔ tuke Yesu yõ, à à tɛ̃. ");
INSERT INTO wib_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Yesu tõ̀ sã́hpú sɔkɔ yɔ́ núkú ǹ kèkírkì yɔrɩ dɛ, à sárká wìlkìpu yõ̀tɛ̃̀ ǹgbɛ̃ tõ̀npɩ yɔ́ níkí kõ kãm. ");
INSERT INTO wib_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Képah sɔkɔ, Yesu mɛ yo pé tyɩ́: «Yé pɔ ńmɔ tɛ̃́-ńsah kèkîrn ànɛ̂ léplólɛ yé gbã̀n, á kɩ nɛ kèlékɛ̃ névi sɔ̃́ ńnɛ. ");
INSERT INTO wib_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Swɔ̃ swɔ̃ póllɛ, mé sõ̀ ńkɛ̃́nɛ n nɛ n mɛ yé wrɔ́ *Liyel wɔ̀kɔ̀ ǹgbɛ̃ kéntáhkɩ̀ sɔkɔ, névyelɛ n kwɔ. Tɛ́ yé náh ń tɛ̃. Ǹtɛ, tyi nónó-à yo *Liyel wɛy sɛ́bɛ̃́nɔ́ sɔkɔ, sépi pɩ́ntũnɔ yĩn ye.» ");
INSERT INTO wib_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Képah sɔkɔ, ǹ tõ̀ sã́hpú pól to karkɩ, tɛ́ à sah. ");
INSERT INTO wib_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Tɛ́ kètɛ̃̀npìkì yɔ́ sõ̀ mɛ Yesu sõ̀ tɛ̃, fwɔ̀pĩn núkú ó ye sõ̀ à pil. Pè à tɛ̃ ǹ fwɔ̀pĩn tyɩ́, ");
INSERT INTO wib_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","à mó kè fe dɛ mɔ, tɛ́ to sɔkɔ ǹ sènpũ̀nɛ. ");
INSERT INTO wib_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Képah náh, pè Yesu tɛ̃ yuku *sárká wìlkìpu yõ̀tɛ̃̀ ǹgbɛ̃ gbô. Ké nɛ́npɔ́ sɔkɔ, sárká wìlkìpu yõ̀tãm ǹgbnɔ, ànɛ̂ yèwàhnɩ̀, ànɛ̂ *Liyel ǹgbò wɛ̃̀kɩ̀ kwɔ́pú wɛ̃ tuke mɔ. ");
INSERT INTO wib_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Tɛ́ Pyɛrɩ sõ̀ mɛ Yesu sõ̀ tɛ̃ wil fɩ́ɩ́ sɔkɔ, à pɔ wɛ de sárká wìlkìpu yõ̀tɛ̃̀ ǹgbɛ̃ gbô, à kyɩ nyàhlɛ n wnɛ gbô táh sɔkɔ ànɛ̂ yõ̀tɛ̃̀ dĩ́ tõ̀npɩbɩlɛ. ");
INSERT INTO wib_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Sárká wìlkìpu yõ̀tãm ǹgbnɔ ànɛ̂ *Nsyifunɔ tukey tùkèpu pól sõ̀ mɛ n yah n kɔ̃ nɛ, pé tir yɔ́ wɛ sah Yesu yõ, pé à wɛ ko mɔ. Ǹtɛ, pè náh mɛ vì-ǹsah wɛ ké tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Tir yɔ́ náh, mɩ̀nyobe tàrfyɔ̀nɔ́ náhnáh sõ̀ mɛ. Pé náhnáh sõ̀ mɛ n wil mɩ̀nɩ̀nɛ n yo n sah ǹ yõ. Tɛ́ pépi ńtɛ̃ náh sõ̀ mɛ sah wɛ̃ tyɩ́ yõ. ");
INSERT INTO wib_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Túkù mɛ n yuku lékàhlɛ ǹnɛ n kɔ̃ nɛ, ");
INSERT INTO wib_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","páh noh à mɛ n yo nɛ, péwɔ-á kɩ *Liyel wɔ̀kɔ̀ ǹgbɛ̃ mɛ̀ sɔ, nɛ̂-á névi mɔ, tɛ́ kɩ kè tɔ̃ mɔ sèpĩ̀n tɔ̃́nɩ̀ wrɔ́, nɛ̂ náh n pɩ n pi névi gbõ̀ mɔnɩnɛ. ");
INSERT INTO wib_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ǹtɛ képah fyé yõ, mɩ̀nyobe tàrfyɔ̀ nɔ́pi náh mɛ sah tírr wɛ̃ tyɩ́ yõ. ");
INSERT INTO wib_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Képah sɔkɔ, sárká wìlkìpu yõ̀tɛ̃̀ ǹgbɛ̃ yuku yĩn no pól yah, tɛ́ Yesu piki yah nɛ, tir kó mɛ ǹ tyɩ́ yo yo tɛ̃̀nɛ nɩ, pǎh mɛ tyi nónó póllɛ n yo n sah ǹ yõ? ");
INSERT INTO wib_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ǹtɛ, Yesu náh vi mɔ ǹ tyɩ́, à náh tir yɔ́ yo ǹ tyɩ́. Sárká wìlkìpu yõ̀tɛ̃̀ ǹgbɛ̃ tɔ̃ ǹ syɩ à piki yah nɛ, ǹmɔ se *Kristalɛ, Liyel-á nɛ, páh kɩ nɛ tɛkɩ mɔ nɩ? Liyel, nɛ̂-á pé pól mɛ n gbilki, ǹ dɔ́rɩ́ pi se ǹnɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu mɛ yo ǹ tyɩ́: «Àwe, ńmɔ ye. Tɛ́ yé kɩ *Névi Pi wɛ kɔ̃́ntɛ̃̀nɔ́lɛ tyi pól Tɛ̃̀ Liyel gbõ̀yõ̀ sõ̀lɛ, kɩ mɛ n tiki n pi ńyîrn sɔkɔ.» ");
INSERT INTO wib_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Képah sɔkɔ, sárká wìlkìpu yõ̀tɛ̃̀ ǹgbɛ̃ fɔkɔ kah vyãh. Fɔ̀kɔ̀vyã̀hnɩ̀ tɛ̃̀ tyɩ́, à ǹ fwɔ̀mɔn yɔrɩ tɔ, tɛ́ mɛ n yo nɛ, pè se noh nɩ? Tàrfyɔ̀ yah yah tɛ̃̀ náh tɔ̃ mɛ ké sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Pè kó Liyel tyɩ́ wɛ́kɩ́ndenɔ noh ǹ tyɩ́ nɩ? Pè se nɛ, pé pɩ sɔ̃́ ǹnɛ nɩ? Névye pól yuku yo nɛ, wǎh yɩ̃nɛ kònmɔnɔlɛ. ");
INSERT INTO wib_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Pé túkù yuku n sĩn n mɔ n pɔ ǹ yõ. Pè ǹ yah vike tũ, tɛ́ ǹnɛ n mɩkɩ n pɔ gbɛ̃̀nkukurinɔ́lɛ. Tɛ́ yo ǹ tyɩ́ nɛ, à yo pé syah, nɛ̂-á mɩ ǹnɛ. À kè sãh n pɩ̃. Képah sɔkɔ, tukey tùkèpu tõ̀npɩbɩ Yesu tɛ̃ ǹ létáhlɔ́lɛ n kɔ̃lɩ. ");
INSERT INTO wib_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Képah sɔkɔ, Pyɛrɩ sõ̀ mɛ gbyẽ̂h sõ̀, gbô táh sɔkɔ. Tɛ́ *sárká wìlkìpu yõ̀tɛ̃̀ ǹgbɛ̃ tõ̀npɩ pi yɔ́ pɔ. ");
INSERT INTO wib_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Wǎh Pyɛrɩ wɛ à mɛ nyàhlɛ n wnɛ, à à gbah yah, tɛ́ yo ǹ tyɩ́ nɛ, ǹmɔ tɔ-á sõ̀ mɛ Nasarɛti kwil Yesulɛ! ");
INSERT INTO wib_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ǹtɛ, Pyɛrɩ mɛ ǹ vyãh kɔ̃lɩ tɛ́ nɛ, pé náh à pɩ̃, péwɔ ńtɛ̃ náh mɛ ǹ wɛy mɛ̀ syɩ́kɩ́-ńsah wɛ dɛ́. Wǎh yo sɛ̃́, à wil kyɩ yĩn kélé yah. ");
INSERT INTO wib_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Képah tɛ̃̀nɛ, pi mɛ̀-á tɔ̃ kyɩ à wɛ, nónó-á sõ̀ mɛ nɛ́npɔ́, à tɔ̃ képah núkú ó yo pé tyɩ́ nɛ, dĩ́ mɛ̀nɛ, pépi sɔkɔ nɛ yɔ́-á! ");
INSERT INTO wib_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pyɛrɩ mɛ tɔ̃ ǹ vyãh kɔ̃lɩ. Dǒ, névye nónó-á sõ̀ mɛ nɛ́npɔ́, pépi tɔ̃ tyah n yo Pyɛrɩ tyɩ́ nɛ, yékã̂b náh n mɛ ké sɔkɔ. Wǎh n wil Kalile sɔkɔ, no nɔ́pi sɔkɔ nɛ yɔ́-á ǹ tɔlɛ. ");
INSERT INTO wib_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Képah sɔkɔ, Pyɛrɩ tyah ǹ gblɔ̌ynɛ n wo pélpèl nɛ, dĩ́ nɛ̂ tyɩ́-á pè n yo pé tyɩ́, pé náh ǹnɛ n pnɛ gbógbó. ");
INSERT INTO wib_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Nɛ́npɔ́ swɔ, sénpɛ gbo kɛ ní-òlɛ. Képah sɔkɔ, Pyɛrɩ dyɔ to kõ Yesu wɛy tyɩ́lɛ, wǎh sõ̀ nɛ̂ yo ǹ tyɩ́ nɛ, sénpɛ-à kɩ pópó n gbo kɛ nínɔ́, wǎh kɩ mɛ ǹ vyãh kɔ̃lɩ tɛ kɛ tɔ̃́nɔ́ nɛ, pé náh péwɔ pɩ̃. Képah tɛ̃̀ sɔkɔ, wǎh képah sõ, à tyah n gbo. ");
INSERT INTO wib_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Képah sɔkɔ, séngbɔ̃́ púpúlɛ, *sárká wìlkìpu yõ̀tãm ǹgbnɔ, ànɛ̂ *Liyel ǹgbò wɛ̃̀kɩ̀ kwɔ́pú, ànɛ̂ yèwàhnɩ̀nɛ, pépi pól ye sõ̀ pɩ *Nsyifunɔ tukey tùkèpu yõ̀tãmnɛ. Pépi wɛ̃ tuke mɔ Yesu tyɩ́ sɔkɔ. Képah tɛ̃̀nɛ, pè à tɛ̃ pukubi, tɛ́ kyɩ ǹnɛ *Pilati gbõ̀ dahbɩ. ");
INSERT INTO wib_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilati mɛ à piki yah nɛ, ǹmɔ se Nsyifunɔ yõ̀tɛ̃̀nɛ nɩ? À mɛ yo ǹ tyɩ́: «Áwɔ ye yo kélɛ.» ");
INSERT INTO wib_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Képah sɔkɔ, sárká wìlkìpu yõ̀tãm ǹgbnɔ mɛ lékàhlɛ à kɔ̃ tyi náhnáh sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Képah náh, Pilati mɛ tɔ̃ à piki yah nɛ, à kó tir yɔ́ yo n pi nɩ? Tyi nónó pól-á n yo n sah ǹ yõ, à kó sè noh nɩ? ");
INSERT INTO wib_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ǹtɛ, à náh tɔ̃ vi mɔ. Képah Pilati yáh-ńsah tyɛ. ");
INSERT INTO wib_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ye ye póllɛ, *Pakɩ syáh-à n syah, *Pilati ńkɛ̃́nɛ wɔ̀kɔ̀npèkè sɔkɔ nɛ núkú yɔ́ fĩn mɔ, nɛ̂ tyɩ́-á nɔ tɔ́wû tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Pǎh Yesu tɛ̃ kyɩ Pilati tĩ̂nnɛ gbĩ́ nɛ̃̂nɛ, dĩ́ yɔ́ sõ̀ mɛ wɔ̀kɔ̀npèkè sɔkɔ, pè n ye Barabasilɛ, ànɛ̂ pé nolɛ. Pè sõ̀ nɛ́kókè mɔ gbĩ́ nɛ̂-á sõ̀ pè mɛ yahle sàhnɔ́lɛ *Wromɛnɔ tyɩ́ yõ. ");
INSERT INTO wib_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Képah tɛ̃̀nɛ, tɔ́wû yuku kyɩ de Pilati tĩ̂nnɛ, à kyɩ tyah ǹnɛ n ni nɛ, wǎh dar, tɛ́ tir nɛ̂nɛ n pɩ pé tyɩ́ Pakɩ syáhnɔ́ sɔkɔ, wǎh náh kè pɩ pé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilati mó yo pé tyɩ́ nɛ, pè se nɛ, pé *Nsyifunɔ yõ̀tɛ̃̀ ǹgbɛ̃ fĩn mɔ nɩ? ");
INSERT INTO wib_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","À sõ̀ kè pɩ̃ nɛ ńkɛ̃, dyɔ yɔ́nɔ́-á *sárká wìlkìpu yõ̀tãm ǹgbnɔ kɔ̃ pè Yesu dahbɩ péwɔ gbõ̀. ");
INSERT INTO wib_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Tɛ́ sárká wìlkìpu yõ̀tãm ǹgbnɔ sõ̀ mɛ gbah tɛ̃ tɔ́wûlɛ n kurki n mɔ nɛ, pè yo nɛ, à Barabasi wilki fĩn mɔ pé kɔ̃. ");
INSERT INTO wib_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilati pè piki yah tɔ̃ ńtɔ̃ nɛ, sɔ̃́ se pé kɩ pɩ dĩ́ mɛ̀nɛ, nɛ̂-á pè n ye Nsyifunɔ yõ̀tɛ̃̀nɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Pè tɔ̃ gbo mɔ, tɛ́ mɛ yo: «Yé à syɩ *dahnɩ yõ!» ");
INSERT INTO wib_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilati yo pé tyɩ́ nɛ, tyípékè nɛ̂ se à pɩ nɩ? Pè tɔ̃ tɔ̃ gbo mɔ náhnáh ńkɛ̃, à syɩ dahnɩ yõ. ");
INSERT INTO wib_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Képah sɔkɔ, Pilati Barabasi fĩn mɔ. À sõ̀ mɛ tɔ́wû nɩ̀vɩ̀lɛ n yah n kɔ̃, képah ye. À pè kɔ̃ pè Yesu ko yèfõhlɛ, tɛ́ ǹnɛ sràhsyíbí kɔ̃ nɛ, pè kyɩ à syɩ dahnɩ yõ. ");
INSERT INTO wib_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Képah tɛ̃̀nɛ, sràhsyíbí Yesu tɛ̃ yuku gbô nɩyṍ yõ̀tɛ̃̀ dĩ́ tɛ̃̀-ǹsah, tɛ́ pé no pól ye tuke mɔ. ");
INSERT INTO wib_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Pǎh kɩ pɩ sɔ̃́, tɛ́ kɩ kṍlɛ à wɛ n ko n pi, pè fwɔ̀mɔn syã̂h pèpɛy yɔ́ mɔ à kɔ̃ tɛ́, yõ̀kɔ̃ pɩ pã̀n yîlɛ, à dyɩ à kɔ̃ tɔ̃́rɩ́ yṍkúrí swɔ. ");
INSERT INTO wib_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Tɛ́ tyah n yo ǹ tyɩ́ nɛ, páh n wɛkɩ ǹ tyɩ́, *Nsyifunɔ yõ̀tɛ̃̀ ǹgbɛ̃, ");
INSERT INTO wib_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","tɛ́ ǹnɛ n mɩkɩ ǹ yõ sɔkɔ gbè-ńsĩnnɛ, tɛ́ n sĩn n mɔ n pɔ ǹ yõ. Pè gbètukunɔ di, à kɔ kwĩnki sétáh ǹ yah sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Pǎh kṍlɛ à ko tɛ, pè fwɔ̀mɔn syã̂h mɛ̀ dɛ ǹ wil. Tɛ́ tɔ̃ ǹ flɔ tɔkɔ mɔ à kɔ̃. Képah náh, pè wil ǹnɛ kégbɔ́ sɔkɔ ǹ syɩ yĩnnɛ *dahnɩ yõ. ");
INSERT INTO wib_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Sirɛni nɛ yɔ́ sõ̀ mɛ, pè n ye Simolɛ, Alɛkisãdre ànɛ̂ Wurfu súlɛ. Légbĩ́nɛ, ǹmɔ sõ̀ mɛ wil swãh, mɛ pɔ n sɔkɔ. Sràhsyíbí à kyɩ̃ mɔ, à Yesu syɩ syɩ *dahnɩ mɛ̀ twah. ");
INSERT INTO wib_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Pè yuku Yesulɛ tyah yɔ́ sɔkɔ, ńyãh-á pè n ye «Kolkɔtalɛ», yõ̀gbèkè tyahlɛ. ");
INSERT INTO wib_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Tɛ́ pè mɛ syɩbɩ yɔ́ fɛ̃kɩ mɔ dìvɛ̃ sɔkɔ à kɔ̃ nɛ, à wɔ, tɛ́ à yahle. ");
INSERT INTO wib_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Képah náh, sràhsyíbí à syɩ dahnɩ yõ, tɛ́ mɛ ǹdan mɔ à ǹ flɔ dibi wɛ̃ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Pǎh à syɩ gbĩ́ nɛ̂nɛ, gbĩ mɛ pɔ̃́ntɔ̃kɩ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Pǎh à syɩ yõ nɛ̂ yõ, pè kè wãrkɩ syɩ ǹ yõ̀tah sésár sɛ́nɔ́ yõ nɛ: «*Nsyifunɔ yõ̀tɛ̃̀ ǹgbɛ̃». ");
INSERT INTO wib_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Tɛ́ mɛ tɔ̃ kèlékɛ̃ névye nɛ́pĩ̂ nímí syɩ dahlɔ yõ ǹ gbɔ̀plɔ, ǹ gbõ̀yõ̀ ànɛ̂ ǹ gbɛ̃̀yɩ̃̀nɛ̀ sõ̀.  ");
INSERT INTO wib_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Képah sɔkɔ, nɛ̂-á yo sah *Liyel wɛy sɛ́bɛ̃́nɔ́ sɔkɔ nɛ: «Pè à mɔ kõ tyípêl pɩ́pú sɔkɔ», kè ńtyɩ̃́nɔ pɩ sɛ̃́. ");
INSERT INTO wib_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Képah tɛ̃̀nɛ, wɛ̃̀kɔbɩ sõ̀ mɛ ǹnɛ n gbyɔ n sɔkɔ, tɛ́ mɛ pé yõlɛ n kal, mɛ yo tũ ǹ tyɩ́ nɛ, ɔ̃̀ɔ̃́, ǹmɔ nɛ̂-á sõ̀ nɛ, páh kɩ *Liyel wɔ̀kɔ̀ ǹgbɛ̃ sɔ, tɛ́ kɩ kè tɔ̃ mɔ sèpĩ̀n tɔ̃́nɩ̀ wrɔ́, ");
INSERT INTO wib_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","à ǹ gblɔ̌y pwah n mɔ, à mó tiki dahnɩ yõ! ");
INSERT INTO wib_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Képah núkú-ó ye, *sárká wìlkìpu yõ̀tãm ǹgbnɔ ànɛ̂ *Liyel ǹgbò wɛ̃̀kɩ̀ kwɔ́pú sõ̀ mɛ kṍlɛ ǹnɛ n ko, tɛ́ mɛ n yo wɛ̃ tyɩ́ nɛ, wǎh névye túkù pwah mɔ, tɛ́ à náh fɛ̃ ǹ gblɔ̌y pwah n mɔ! ");
INSERT INTO wib_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ǹmɔ-à kɩ nɛ Liyel-á nɛ, páh kɩ nɛ tɛkɩ mɔ Yisrayɛl yõ̀tɛ̃̀nɛ, à tiki dahnɩ mɛ̀ yõ! Páh kɩ képah wɛ, páh kɩ sɛ̃ ǹ yõ. Tɛ́ nónó-á sõ̀ mɛ syɩ́nɔ́lɛ dahlɔ yõ ǹ gbɔ̀plɔlɛ, pépi tɔ mɛ ǹnɛ n gbyɔ. ");
INSERT INTO wib_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Gbĩ̀ntɔ̃̀ pɔ̃́lɛ, lékã̂h mɔ sétáh pól yõ sɔkɔ, fɔ́ɔ́ à pɔ nɔ gbèkãm gbĩ́ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Gbèkãm gbĩ́-á nɔ, Yesu kah de syi, tɛ́ yo pé kwil wɛy sɔkɔ: «Eloyi, Eloyi, lama sabaktani?» Képah n yo nɛ: «Ńmɔ Liyel, ńmɔ Liyel, kû pɩ, tɛ́ á ń fĩn mɔ?» ");
INSERT INTO wib_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Nónó-á sõ̀ mɛ nɛ́npɔ́ tɛ́ kè noh, pé túkù sõ̀ mɛ n yo nɛ, pè tɔkɔ noh, wǎh mɛ *Yelilɛ n ye. ");
INSERT INTO wib_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Képah sɔkɔ, pé sɔkɔ nɛ yɔ́ mɛ to kyɩ sènsúkúrí tɔkɔ dahbɩ wilki yõ̀yõ̀kɩ̀ ni sɔkɔ, à dyɩ gbey yɔ́ vyãh tyɩ́, à pɔ nɔ ǹ tyɩ́ nɛ, à wɔ, tɛ́ mɛ yo tũ nɛ, pé ye yah ǹkàh Yeli-á kɩ ńtyɩ̃́nɔ pɔ à tiki mɔ n pi *dahnɩ mɛ̀ yõ nɩ? ");
INSERT INTO wib_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Képah náh, Yesu mɛ de syi, tɛ́ pyě ku. ");
INSERT INTO wib_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Nɛ́npɔ́ swɔ, fwɔ nɛ̂-á *Liyel wɔ̀kɔ̀ ǹgbɛ̃ fɔkɔ táh dibi nínɔ́, kè tɔ, à tɔkɔ ké yõ̀tah, à pɔ syɩ sétáh tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Sràsyíbí lèkwɛ̌ yõ̀tɛ̃̀ dĩ́ nɛ̂-á sõ̀ mɛ yĩ́nntɛ̃̀nɔ́lɛ, tɛ́ ǹ ku dùkù wɛ sɛ̃́, à nɛ: «Gbɩ yõ, dĩ́ mɛ̀nɛ, Liyel pi ye ńtyɩ̃́nɔ sõ̀ ǹnɛ.» ");
INSERT INTO wib_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Syɔ́ yísyɔ́ tɔ sõ̀ mɛ yĩn tɛ̃ fɩ́ɩ́, mɛ n yah. Pépi wrɔ́ sɔkɔ Makadala kwil Mari, ànɛ̂ Mari nɛ̂-á Nsyakɩ pir ànɛ̂ Yose yṹnɛ, ànɛ̂ Salome sõ̀ mɛ. ");
INSERT INTO wib_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Pépi ye sõ̀ Yesu sõ̀ tɛ̃, ǹ tõ̀lɛ n pɩ Kalile sɔkɔ. Syɔ́ kwĩnki yísyɔ́ tɔ sõ̀ yuku ǹnɛ Yerusalɛmɩ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Pǎh Yesu ko mɔ sṍ nɛ̂ ńvɩ̃́nɛ, ké dèndal ye sõ̀ pɩ *Nsyifunɔ *mɩ mɩ yòhlɛ. ");
INSERT INTO wib_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Arimatɩ kwil nɛ yɔ́ sõ̀ mɛ, pè n ye Yosɛfulɛ. Ǹmɔlɛ, Nsyifunɔ tukey tùkèpu sɔkɔ nɛ pèpɛy yɔ́ ye sõ̀ ǹnɛ. Ǹmɔ tɔ sõ̀ mɛ *Liyel tɔ̃́rɩ́ pɔ́nɔ́lɛ n syɩkɩ. Ǹmɔ ǹ nɩ syãh, à kyɩ Yesu lékó ni *Pilati tyɩ́ nɛ, à ǹnɛ pé kɔ̃, pé kyɩ à yɩ̃. ");
INSERT INTO wib_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilati-á noh nɛ, Yesu-á núkú ku tɛ, kè ǹ yáh-ńsah tyɛ. À sràsyíbí yõ̀tɛ̃̀ dĩ́ ye pɔ piki yah nɛ, ǹ kúnɔ́ di se mo nɩ? ");
INSERT INTO wib_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Wǎh ké gbɩ noh tɛ sràsyíbí yõ̀tɛ̃̀ dĩ́ tyɩ́, à mó wɛ̃̀kɩ̀lɛ Yosɛfu kɔ̃ nɛ, à kyɩ Yesu lékó tɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Képah sɔkɔ, Yosɛfu kyɩ fwɔ̀pĩn dwe. À kyɩ Yesu lékó dɛ *dahnɩ yõ, tɛ́ à plo fwɔ̀pĩn mɛ̀ sɔkɔ, à dah mɔ diki sɔkɔ, nɛ̂-á tũ tɛkɩ sɔkɔ, tɛ́ dáh-ǹgbɛ̃ yɔ́ pil pɔ vike ké yah. ");
INSERT INTO wib_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Légbĩ́nɛ, Makadala Mari ànɛ̂ Yose yṹ Mari mó Yesu dáhnmɔ-ńsah yah pɔkɔ mɔ sah. ");
INSERT INTO wib_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","*Mɩ mɩ yòh-á sɔkɔ, Makadala Mari, ànɛ̂ Nsyakɩ yṹ Mari, ànɛ̂ Salome kyɩ làsèkwěl dwe Yesu yõ mɔ mɔ tɛ̃̀nɛ. ");
INSERT INTO wib_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Dimasyi sṍ séngbɔ̃́ púsɔ́, gbĩ gbo gbĩ́nɛ, pè yuku diki yõ. ");
INSERT INTO wib_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Syɔ́ nɔ́pi mɛ n yo wɛ̃ tyɩ́ nɛ, nɛ̂ se kɩ dáh-ǹgbɛ̃ mɛ̀ yɩkɩ mɔ pé kɔ̃ nɩ? ");
INSERT INTO wib_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Tɛ́ pǎh nɛ, pé yah, pè dáhkɩ̀ mɛ̀ wɛ pílntonɔlɛ diki yah sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Pè de yuku diki sɔkɔ, tɛ́ kyɩ kètɛ̃̀npìkì yɔ́ wɛ, à mɛ fwɔ̀mɔ̀npíkí mɔ kɔ̃ tɛ̃ gbõ̀yõ̀ sõ̀lɛ. Tíkí pè kah tɛ̃. ");
INSERT INTO wib_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Tɛ́ kètɛ̃̀npìkì mɛ̀ mɛ yo pé tyɩ́: «Yé káh tíkí pɩ! Nasarɛti Yesu ye yé n yah n kɔ̃, nɛ̂-á pè syɩ *dahnɩ yõ. À yuku wil diki sɔkɔ. À náh mɛ ásõ̂. Yé pɔ yah ǹ sɛ̃́-ńsahlɛ. ");
INSERT INTO wib_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Yé kyɩ yo Pyɛrɩ ànɛ̂ pé no tɛ́lɔ́ tyɩ́ ńkɛ̃, wǎh mɛ pélɛ n syɩkɩ Kalile sɔkɔ, sɔ̃́-á lésõ à kè yo sah pé tyɩ́.» ");
INSERT INTO wib_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Syɔ́ nɔ́pi-á képah noh sɛ̃́, pè wil diki, à to sɔkɔ wil syahrɩ sɔkɔ tíkí tɛ̃̀ tyɩ́. Pè náh mɛ n yo n mɔ nɛ tyɩ́, tíkí kàhntɛ̃nɔ tɛ̃̀ tyɩ́.  ");
INSERT INTO wib_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Dimasyi sṍ séngbɔ̃́ púsɔ́, Yesu yuku wil diki sɔkɔ. À ǹ gblɔ̌ynɛ Makadala Mari ǹgbò wɛ̃kɩ, wǎh lésõ *sétã̀n kwǎrninɔ yĩni wilki pi nɛ̂ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Makadala Mari kyɩ kè yo Yesu *tõ̀ sã́hpú tyɩ́. À kyɩ pé wɛ kũ yèkwɔrɩ gbní sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Pǎh noh, Mari n yo pé tyɩ́ nɛ: «Yesu mɛ ǹ vilɛ! Ńmɔ ye à wɛ!», pè náh sɛ̃ ǹ yõ. ");
INSERT INTO wib_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Képah náh, Yesu *tõ̀ sã́hpú nɛ́pĩ̂ nímí sõ̀ mɛ kwílpír yɔ́ wɛ̃̀kɩ̀ tɛ̃. Pǎh mɛ kénɛ wɛ̃̀kɩ̀ yõ, Yesu ǹ gblɔ̌ynɛ pè wɛ̃kɩ dùkù yɔ́lɛ. ");
INSERT INTO wib_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Pè pé syɩ kyɩ ké yah yo pé no tɛ́lɔ́ tyɩ́, tɛ́ pépi tɔ náh tɔ̃ sɛ̃ pé yõ. ");
INSERT INTO wib_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Sépi pól sɔ́kɔ́ntɛnɔ náh, Yesu ǹ gblɔ̌ynɛ ǹ *tõ̀ sã́hpú nɛ́pĩ̂ gbɔ̃núkú wɛ̃kɩ pé yõke yõ gbĩ́nɛ. À pé yahlɛ n yo pé níkí sékélkè, ànɛ̂ pé tir yõ sɛ̃́-ńkɛ̃̂ yĩnnɛ. Pǎh sɔ̃́npɩ yahle pé vi wɛ́pú yõ sɛ̃́nɔ́lɛ pé kṹntɛnɔ náh. ");
INSERT INTO wib_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Képah sɔkɔ, à yo pé tyɩ́: «Yé kyɩ nɩ̀vɩ̀nɩ̀ wɛy sã́nnɛ n yah n yo n kɔ̃ kèkõyṍ névye pól tyɩ́. ");
INSERT INTO wib_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Névi nɛ̂-à sɛ̃ ké yõ tɛ́ *wèlnwìlkìnɔ́ wɛ, ǹmɔ kɩ pwah. Tɛ́ nɛ̂-à sɛ̃ ńkɛ̃̂nɛ ké yõ, ǹmɔ kɩ wũ ké sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Tɛ́ nónó-á sɛ̃ ké yõ, yé kɩ pè pɩ̃ pé tyípɩ́nɔ́ sɔkɔ: Pè kɩ *sétã̀nnɛ n yĩni n wilki névye sɔkɔ ńmɔ yĩn yõ, tɛ́ kɩ wɛlɔ snɔ́lɛ n wɛkɩ, ");
INSERT INTO wib_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","tɛ́ kɩ fɛ̃ wahy tɛ̃ pé gbõ̀lɛ, tɛ́ kɩ fɛ̃ kwâh pèkè wɔ, tɛ́ kè náh tir yɔ́ pɩ n pi pé sɔkɔ. Ànɛ̂ pàh pé gbã̀n sah yámpú yõ, pè kɩ dɛ.» ");
INSERT INTO wib_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Tɛ̃̀-ǹgbɛ̃ Yesu-á yo tɛ sɛ̃́, à yɔ̃ dɔkɔ sɔkɔ yĩ̂nyõ, à kyɩ kɔ̃ tɛ̃ Liyel gbõ̀yõ̀ sõ̀. ");
INSERT INTO wib_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Képah náh, tõ̀ sã́hpú mɛ kyɩ tyah nɩ̀vɩ̀nɩ̀ wɛy sã́nnɛ n yo n kɔ̃ ywɔ̃ ywɔ̃ pól sɔkɔ. Tɛ̃̀-ǹgbɛ̃ sõ̀ mɛ pélɛ n yohnɩ mɔ kénɛ tõ̀ sɔkɔ, mɛ gbǐl tyilɛ n pɩ, tyi nónó-á n wɛ̃kɩ nɛ gblɔ-á pé wɛlɔlɛ.");
INSERT INTO wib_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ń dĩ́ Tewofil, tyi nónó-á pɩ á wrɔ́, névye náhnáh tyah mɛ sélɛ n wãrkɩ. ");
INSERT INTO wib_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Pè sè wãrkɩ, sɔ̃́-á tàrfyɔ̀nɔ́ yo sélɛ á tyɩ́, pépi nónó-á sõ̀ wɛ sélɛ sé tyah gbĩ́ dùkùlɛ, tɛ́ sõ̀ mɛ Liyel wɛy yópúlɛ. ");
INSERT INTO wib_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Képah ye, ńmɔ tɔ mɛ tyi nɔ́pi nɩ́y tɛ̃ pallɛ, nónó-á pɩ, à tɔkɔ ké tyah gbĩ́ tyɩ́. Tɛ́ mɛ ké tyɩ́ nɛ, ńmɔ tɔ sè wãrkɩ ǹ kɔ̃ sé wɛ̃̀kɩ̀ yõ, sǎh pɩ syɩ wɛ̃ tyɩ́ sɔ̃́, ń dĩ́ Tewofil. ");
INSERT INTO wib_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Képah sɔkɔ, á kɩ pɩ̃ nɛ, wáh kwɔ́nɔ́ nɛ̂ wɛ, gbɩ-á kélɛ. ");
INSERT INTO wib_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Yerɔdɩ-á sõ̀ mɛ yõ̀tɛ̃̀nɛ Yude kwil yõ sɔkɔ gbĩ́ nɛ̂nɛ, sárká wìlkìpu yõ̀tɛ̃̀ yɔ́ sõ̀ mɛ, pè n ye Nsakarɩlɛ. Sárká wìlkìpu yõ̀tãm nónó-á sõ̀ Abya tĩ̀nkìlɛ, pépi sɔkɔ nɛy yɔ́ ye sõ̀ ǹnɛ. Ǹ kyɩ Yelisabɛtɩ tɔlɛ sõ̀, sárká wìlkìpu yõ̀tɛ̃̀ ǹgbɛ̃ Arõ náh nɛy ye ǹnɛ. ");
INSERT INTO wib_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Pé nímí sõ̀ mɛ nɛ́gblɔ́lɛ Liyel yah. Pè sõ̀ mɛ Liyel tyi kõ̀nsàhnɔ́ póllɛ n pɩ, tɛ́ mɛ ǹ tyíyónè pól tɛ̃ yĩ́ĩ́. ");
INSERT INTO wib_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ǹtɛ, pé nímí sõ̀ dye tɛ, Yelisabɛtɩ náh sõ̀ fɛ̃ pi wɛ n pi, képah ye pi náh sõ̀ mɛ pé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Sṍ yɔ́lɛ, Nsakarɩpi tĩ̀nkì tõ̀ pɩ gbĩ́-á pɔ nɔ, à sõ̀ mɛ tõ̀lɛ n pɩ Liyel yah pélɛ. ");
INSERT INTO wib_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Pǎh dar tɛ́ sã́hntɔkɔnɔlɛ n pɩ sɔ̃́, kè sõ̀ pɔ yɩ̃nɛ ǹmɔlɛ. À sõ̀ yɩ̃nɛ à de Liyel wɔ̀kɔ̀ ǹgbɛ̃ sɔkɔ, à sèkukuri pãn pèpɛy sukɛ Tɛ̃̀ ǹgbɛ̃ Liyel yah sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Légbĩ́nɛ, tɔ́wû pól sõ̀ mɛ Liyellɛ n ni kégbɔ́ sɔkɔ, wǎh wɔ̀kɔ̀lɛ n yɔ̃ gbĩ́ nɛ̂nɛ. ");
INSERT INTO wib_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Wǎh mɛ képah sɔkɔ, yĩ̂nyõ tɛ̃ntõ̀ yɔ́ wil ǹ yah, tɛ́ mɛ yĩn tɛ̃ wɔ̀kɔ̀ yɔ̃ yɔ̃ kwâh gbõ̀yõ̀ sõ̀lɛ. ");
INSERT INTO wib_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Nsakarɩ-á à wɛ gbĩ́ nɛ̂nɛ, tíkí à tɛ̃, ǹ lékã́m fɛ̃kɩ. ");
INSERT INTO wib_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ǹtɛ, yĩ̂nyõ tɛ̃ntõ̀ mɛ̀ yo ǹ tyɩ́: «Nsakarɩ, káh tíkí pɩ, á Liyel nínɔ́ ye tɛ̃. Á kyɩ Yelisabɛtɩ kɩ dĩ́npir dubi á tyɩ́, tɛ́ á kɩ ǹ yĩn sah Nsyɔ̃nɛ. ");
INSERT INTO wib_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ǹ dúbínɔ́ kɩ pɩ nɩ̀vɩ̀nɩ̀ ǹgbɛ̃nɛ áwɔ ànɛ̂ névye náhnáh tyɩ́, ");
INSERT INTO wib_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ǹ nɛ́-ǹgbɛ̃ pɔ́npɩnɔ yĩnnɛ Tɛ̃̀ ǹgbɛ̃ Liyel yah. À náh dìvɛ̃ wɔ n pi, à náh tɔ̃ kònɔ́ yɔ́ ńtɛ̃ wɔ n pi, tɛ́ kɩ mɛ yúkúnɔ́lɛ Liyel Mírkí tǎhkɩ̀lɛ ǹ dúbí-ńkɛ̃̂ gbĩ́ dùkùlɛ. ");
INSERT INTO wib_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","À kɩ pɔ Yisrayel névye náhnáh kɔ̃, pè kɩ pé syɩ pɔ pé Tɛ̃̀ ǹgbɛ̃ Liyel tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","À kɩ n kɔ Liyel yah Yeli pɩ dùkù ànɛ̂ ǹ tǎhkɩ̀lɛ ǹ sɔkɔ. À kɩ pɔ súbí ànɛ̂ pé wɛ̃́npì wrɔ́ tɔ̃ sah, tɛ́ kɩ nòhnɩ̀-ǹkɛ̃̂pú vi mɔ pɩ nòhnɩ̀pulɛ. À kɩ névye tɔ̃ sah vi mɔ Tɛ̃̀ ǹgbɛ̃ kɔ̃.» ");
INSERT INTO wib_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Wǎh yo sɛ̃́, Nsakarɩ yo ǹ tyɩ́ nɛ, péwɔ ànɛ̂ pé kyɩlɛ, pé nímí-á dye tɛ. Kǎh pɩ sɛ̃́, sɔ̃́ se pé kɩ fɛ̃ pɩ̃ nɛ, gbɩ-á à yo nɩ? ");
INSERT INTO wib_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Képah sɔkɔ, yĩ̂nyõ tɛ̃ntõ̀ yo ǹ tyɩ́: «Kabrɛlɩ ye ńmɔlɛ, nɛ̂-á n yĩn Liyel yah, à ǹ tõ̀lɛ n pɩ. À ń tɛkɩ mɔ nɛ, mé pɔ nɩ̀vɩ̀nɩ̀ wɛy mɛ̀ yo á tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ǹtɛ yah, á náh sɛ̃ ń wɛlɔ yõ. Tɛ́, sè kɩ mó tɔ̃ pɔ n pɩ n tũ n pi sé gbĩ́ sɔkɔ. Képah ye, á vyãh kɩ gbɩ tɛ̃, á náh tɔ̃ fɛ̃ n wɛkɩ n pi fɔ́ɔ́, kɩ pɔ nɔ tyi nɔ́pi pɩ́ntũ sṍ tyɩ́.» ");
INSERT INTO wib_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Légbĩ́nɛ, tɔ́wû sõ̀ mɛ Nsakarɩlɛ n syɩkɩ. Tɛ́ ǹ kàhnmonɔlɛ Liyel wɔ̀kɔ̀ ǹgbɛ̃ sɔkɔ, képah sõ̀ mɛ pé gbã̀n du. ");
INSERT INTO wib_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ǹtɛ, Nsakarɩ-á pópó n wil, à náh mɛ fɛ̃ n yo n mɔ pé tyɩ́. Kǎh pɩ sɛ̃́, no pɩ̃ nɛ, gbǐl tir yɔ́-á wil ǹ yah Liyel wɔ̀kɔ̀ ǹgbɛ̃ sɔkɔ. À sõ̀ mɛ ǹ gbã̀n ólɛ n pɩ n mɔ pé tyɩ́, tɛ́ mɛ wɛkɩ kwlɔ. ");
INSERT INTO wib_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Képah náh, ǹ tõ̀ pɩ́nɔ́ sèpĩ̀n-á pɔ tũ Liyel tyɩ́, à ǹ syɩ yuku ǹ gbô. ");
INSERT INTO wib_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Kénɛ sèpĩ̀n sɔ́kɔ́ntɛnɔ náh, ǹ kyɩ Yelisabɛtɩ kúrkì tɔkɔ, tɛ́ kè wɔ̃bɩ ńwɔ̃́lɔ́ kwlɔ́. À sõ̀ mɛ n sõ nɛ: ");
INSERT INTO wib_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«Yah, pèpɔrɩ nɛ̂-á Tɛ̃̀ ǹgbɛ̃ Liyel pɩ ń tyɩ́ yɔ̀. À ye ńtyɩ̃́nɔ yah dah mɔ ń tyɩ́ sɔkɔ núkúnúkú, à ń sen tɔkɔ to ń yõ névye yah.» ");
INSERT INTO wib_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Képah náh, ńwɔ̃́lɔ́ kénúkò sɔ́kɔ́ntɛnɔ náh, Liyel tɔ̃ ǹ yĩ̂nyõ tɛ̃ntõ̀ Kabrɛlɩ tõ kwil yɔ́ sɔkɔ, nɛ̂-á pè n ye Nasarɛtɩlɛ, Kalile sétáh yõ. ");
INSERT INTO wib_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","À à tõ yɛ̃́ndyɩ́kɩ̀ yɔ́ tyɩ́, nɛ̂-á sõ̀ mɛ gbɩ̃́nɔ́lɛ Davidi náh nɛy Yosɛfu tyɩ́. Yɛ̃́ndyɩ́kɩ̀ mɛ̀ yĩn ye sõ̀ Marilɛ. ");
INSERT INTO wib_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Wǎh kyɩ, à de yuku Mari tnɔ̂, tɛ́ yo ǹ tyɩ́: «Mé wɛkɩ á tyɩ́ Mari. Tɛ̃̀ ǹgbɛ̃ Liyel mɛ pèpɔrɩ yɔ́ tɔ̃ sah pɩ á tyɩ́, à mɛ álɛ.» ");
INSERT INTO wib_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mari-á kénɛ wɛlɔ noh sɛ̃́, ǹ gbã̀n du. À sõ̀ mɛ n sõ ǹ fɔkɔ nɛ, yõ nɛ̂ yõ se à pɔ wɛkɩ mɔ pé tyɩ́ sɛ̃́ nɩ? ");
INSERT INTO wib_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Képah sɔkɔ, yĩ̂nyõ tɛ̃ntõ̀ yo ǹ tyɩ́: «Mari, pèpɔrɩ ye Liyel n pɩ á tyɩ́ ǹ nɩ̀gbɛ̀kɩ̀ sɔkɔ. Káh n yɛ kè pɩ tíkí tirlɛ á tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Yah, á kɩ kúrkì tɔkɔ, kɩ dĩ́npir yɔ́ dubi, tɛ́ kɩ ǹ yĩn sah Yesulɛ. ");
INSERT INTO wib_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","À kɩ pɩ nɛ́-ǹgbɛ̃nɛ Liyel yah. À kɩ n ye yõ̀tah Liyel pilɛ. Tɛ́ Tɛ̃̀ ǹgbɛ̃ Liyel kɩ à kɔ̃, à kɩ tɛ̃ kwil yõ ǹ náh nɛy Davidi sɔ̃́. ");
INSERT INTO wib_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","À kɩ n wũ n pi Yisrayel kwil pól yõ gbĩ́mɛgbĩ́. Ǹ yõ̀tɔ̃rɩ́ náh tyɛ yah n pi póllɛ.» ");
INSERT INTO wib_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Wǎh yo sɛ̃́, Mari à piki yah nɛ, ǹtɛ, pé náh se dĩ́ tyɩ́ pɩ̃. Sɔ̃́ se kè kɩ pɩ, tɛ́ pé kɩ kúrkì tɔkɔ nɩ? ");
INSERT INTO wib_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Yĩ̂nyõ tɛ̃ntõ̀ mɛ tɔ̃ yo ǹ tyɩ́: «Liyel Mírkí kɩ tiki á yõ, tɛ́ yõ̀tah Liyel tǎhkɩ̀ kɩ fɔkɔ tũ á yõ fob sɔ̃́ mɔ. Képah ye, pi nɛ̂-á á kɩ n dubi n pi, à kɩ mɛ pèkè kɛ̃́nɛ ǹ sɔkɔ, tɛ́ kɩ n ye Liyel pilɛ. ");
INSERT INTO wib_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Yah, á wɔ̀kɔ̀ nɛy Yelisabɛtɩ, nɛ̂ tyɩ́-á no yo tũ nɛ, píkã́n sê-á ǹnɛ, à mɛ kúrkì tɔkɔ ǹ dyèntɛnɔ náh, ké ńwɔ̃́lɔ́ kénúkò-ò ye yɔ̀. À kɩ n dubi n pi dĩ́npirlɛ. ");
INSERT INTO wib_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Á náh wɛ di, Liyel tɛ̃ wɛ tyi pól tyɩ́.» ");
INSERT INTO wib_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Wǎh yo tɛ, Mari tɔ̃ ǹ syɩ yo ǹ tyɩ́: «Ńmɔ mɛ Tɛ̃̀ ǹgbɛ̃ Liyel tyɩ́ yõ. Wáh yo sɔ̃́, Liyel kè pɩ sɛ̃́ ń tyɩ́.» Képah náh, yĩ̂nyõ tɛ̃ntõ̀ ǹ syɩ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Kénɛ sèpĩ̀n sɔkɔ, Mari yuku sɔkɔ súú ymɔ yõ, Yude kwil yɔ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","À kyɩ de Nsakarɩ gbô, tɛ́ wɛkɩ mɔ Yelisabɛtɩ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Yelisabɛtɩ-á Mari wɛ́kɩ́nmɔnɔ noh, piri núkú kah werke ǹ fɔkɔ sɔkɔ. Képah sɔkɔ, Yelisabɛtɩ mɛ yuku Liyel Mírkí tǎhkɩ̀lɛ, ");
INSERT INTO wib_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","tɛ́ yo ǹ tyɩ́ yĩ́npɔ̃́ ǹgbɛ̃nɛ nɛ: «Sãm mɛ mɔ́nɔ́lɛ á sɔkɔ, à kal syɔ́ póllɛ. Ànɛ̂ sãm mɛ mɔ́nɔ́lɛ á fɔkɔ táh piri tɔ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nɛ́dúkú nɛ̂ mɛ ńmɔ tɛ̃̀ tɔlɛ, tɛ́ ń Tɛ̃̀ ǹgbɛ̃ yṹ kɩ pɔ n yah ń tyɩ́? ");
INSERT INTO wib_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Á náh wɛ di, máh fyɔ̀ á wɛ́kɩ́nmɔnɔ noh ńyãh, nɩ̀vɩ̀nɩ̀ tɛ̃̀ tyɩ́, piri núkú kah werke ń fɔkɔ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nɩ̀vɩ̀nɩ̀ mɛ á tyɩ́, áwɔ nɛ̂-á sɛ̃ ké yõ nɛ, Tɛ̃̀ ǹgbɛ̃ Liyel-á nɛ̂ yo, kǎh kɩ pɩ tũ.» ");
INSERT INTO wib_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Képah sɔkɔ, Mari nɛ: «Ńmɔ mɛ ń nɩ dal mɔ Tɛ̃̀ ǹgbɛ̃ Liyellɛ n gbilki, ");
INSERT INTO wib_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","48","Ń Pwáhnmɔ-ò Liyel fɛ̃ syi yah dah mɔ ń tyɩ́ sɔkɔ. Képah ye, ń nɩ mɛ vɩ́nɔ́lɛ ǹ yĩnnɛ. Ńmɔ nɛ̂-á mɛ ǹ tyɩ́ yõ, mɛ ń gblɔ̌ynɛ n tiki n mɔ ǹ yah sɔkɔ. Gbɩ yõ, à tɔkɔ núkúnúkú tyɩ́, knɔ knɔ pól kɩ pɔ n yo n pi nɛ, máh yèvɩnɩ wɛ. ");
INSERT INTO wib_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Tyi pól tyɩ́ tɛ̃́nwɛ-ò Liyel ye tyí-ǹgbnɔ pɩ ńmɔ tyɩ́, ǹ yĩn ye Kètɔ̀kɛ̃́ Liyellɛ. ");
INSERT INTO wib_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ǹ nɩ̀gbɛ̀kɩ̀ kɩ mɛ tɔ̃̀nmɔnyukunɔlɛ knɔ knɔ pól yõ tyɛ́-ńkɛ̃̂nɛ, nónó-á ǹ yah tíkílɛ n pɩ. ");
INSERT INTO wib_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","À ǹ gbõ̀ tǎhkɩ̀lɛ tõ̀ pɩ: Gblɔ̌y gbílkínɔ́ sõnɔ-á mɛ nónó sɔkɔ, à pè karkɩ. ");
INSERT INTO wib_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","À yõ̀tãm tiki mɔ pé tɔ̃́rɩ́ klǒ yõ, tɛ́ gblɔ̌y tíkínmɔpu dɔkɔ mɔ. ");
INSERT INTO wib_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","À yõ yõ yîlɛ kwɛ́ndébé kɔ̃ yĩ́ĩ́, tɛ́ tahbɩ fĩn mɔ pè sɔkɔ pé gbã̀n kúkɔ́lɛ. ");
INSERT INTO wib_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","À Yisrayel névye yohnɩ mɔ, pépi nónó-á mɛ ǹ tyɩ́ yõ. Ǹ dyɔ náh fwɔ ǹ nɩ̀gbɛ̀kɩ̀ pɩ́nɔ́lɛ, ");
INSERT INTO wib_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","à yuku Abrahmɩ ànɛ̂ ǹ náh tãn tĩ̀nnɛ tyɛ́-ńkɛ̃̂nɛ, wǎh sõ̀ ǹ vyãh kɔ̃ sɔ̃́ á súbí ǹgbò tãn tyɩ́.» ");
INSERT INTO wib_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Képah sɔkɔ, Mari tɛ̃ Yelisabɛtɩlɛ, à ńwɔ̃́lɔ́ tɔ̃́nɔ́ kénkɔ̃ pɩ. Képah náh, à ǹ syɩ sɔkɔ ǹ tĩ̀nnɛ. ");
INSERT INTO wib_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Képah sɔkɔ, Yelisabɛtɩ dubi gbĩ́-á pɔ nɔ, à dubi dĩ́npirlɛ. ");
INSERT INTO wib_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ǹ tnɔ̂ tɛ̃̀pu, ànɛ̂ ǹ wɔ̀kɔ̀ tãn-á noh nɛ, Tɛ̃̀ ǹgbɛ̃ Liyel-á pèpɔrɩ ǹgbɛ̃ pɩ ǹ tyɩ́, pè à tahlɩ pè ké nɩ̀vɩ̀nɩ̀ pɩ. ");
INSERT INTO wib_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ǹ dúbínɔ́ sèpĩ̀n kwǎrtɔ̃́-ò sṍlɛ, pè pɔ piri kõ̀-ǹsah, tɛ́ mɛ n yah n kɔ̃ ǹ sú yĩn dyɩ́-ńsahlɛ ǹ tyɩ́, nɛ̂-á Nsakarɩlɛ. ");
INSERT INTO wib_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ǹtɛ, ǹ yṹ mɛ yo pé tyɩ́ nɛ: «Ɔ̃́ɔ̃, à kɩ n ye Nsyɔ̃nɛ.» ");
INSERT INTO wib_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Pè mɛ yo ǹ tyɩ́ nɛ, ǹgbǒ ǹ wɔ̀kɔ̀ nɛy yɔ́ ńtɛ̃ yĩn náh mɛ sɛ̃́ dɛ́. ");
INSERT INTO wib_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Tɛ́ mɛ kwásɩ́ pɩ piri sú tyɩ́ nɛ, yĩn nɛ̂ se à kɩ sah à kɔ̃ nɩ? ");
INSERT INTO wib_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Képah sɔkɔ, à pè kɔ̃, pè sésár sɛ́nɔ́ yɔ́ tɔkɔ pɔ à kɔ̃, à wãrkɩ mɔ ké yõ nɛ: «Nsyɔ̃ ye ǹ yĩnnɛ.» Képah pé pól gbã̀n du. ");
INSERT INTO wib_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Nɛ́npɔ́ swɔ, Nsakarɩ nɛ́npɔ́rɩ́ dɛ mɔ, ǹ vyãh gbɩ́nɔ́ tyɛ, à tyah n wɛkɩ, à Liyel yĩnnɛ n gbilki. ");
INSERT INTO wib_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Kǎh pɩ sɛ̃́, tíkí de pé tnɔ̂ tɛ̃̀pu pól sɔkɔ, tɛ́ no sõ̀ mɛ tyi nɔ́pi póllɛ n yãh n kɔ̃ Yude ymɔ yõ kwlo pól sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Tɛ́ Tɛ̃̀ ǹgbɛ̃ Liyel sõ̀ mɛ ǹnɛ. Képah ye, nónó pól-à sõ̀ tyi nɔ́pi noh, pě sè tɛ̃ n sah pé nnɔ sɔkɔ, ǹ tɛ́ nɛ mɛ wɛ̃nɛ n piki n yah nɛ ńkɛ̃́, piri mɛ̀ se kɩ pɔ n pɩ n pi nɛ́dúkú nɛ̂nɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Képah sɔkɔ, piri sú Nsakarɩ Liyel Mírkí tǎhkɩ̀ wɛ, tɛ́ mɛ Liyel tɛ̃ntõ̀ wɛlɔlɛ n syi n yo nɛ: ");
INSERT INTO wib_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Tɛ̃̀ ǹgbɛ̃ nɛ̂-á Yisrayel Liyellɛ, ǹ yĩn nɛ n gbilki, ǹmɔ nɛ̂-á pɔ ǹ no yohnɩ mɔ, à pè wilki yɔ̃rɩ sɔkɔ, ");
INSERT INTO wib_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","tɛ́ mɛ Pwáhnmɔ-ò tǎh wilki mɔ á kɔ̃, à wil ǹ tõ̀npɩ dĩ́ Davidi náh tãn sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Képah ye lésõ à ǹ tɛ̃ntõ̀ syínyopu kɔ̃, pè yo sah di mónɔ́lɛ nɛ, ");
INSERT INTO wib_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","páh kɩ á syi pwah mɔ á pěltãn tyɩ́, tɛ́ kɩ á wilki á dyɔ yɔ́pú gbõ̀. ");
INSERT INTO wib_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","À á súbí ǹgbò tãn nɩ gbɛ yĩ́ĩ́. Ǹ dyɔ náh fwɔ ǹ yégbékè kwrɔ́nmɔnsàhnɔ́ tyɩ́lɛ pélɛ. ");
INSERT INTO wib_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","À sõ̀ ǹ wo á ǹgbò sú Abrahmɩ tyɩ́ nɛ, ");
INSERT INTO wib_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","páh kɩ á tɛ̃ syi á pěltãn gbõ̀, á kɔ̃ á fɛ̃ tõ̀lɛ n pɩ pé tyɩ́ tíkí kɛ̃́nɛ, ");
INSERT INTO wib_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","á mó pɩ nɛ́gblɔ́lɛ yályál pé yah, á min pól sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Tɛ́ áwɔ tɛ̃̀ wɔlɛ, ńmɔ pi, á kɩ pɔ n kɔ Tɛ̃̀ ǹgbɛ̃ yah sɔkɔ, kɩ ǹ wã̀l tɔ̃ n sah n pi. Képah ye, pè kɩ álɛ n ye ‹Yõ̀tah Liyel tɛ̃ntõ̀ syínyo-òlɛ›. ");
INSERT INTO wib_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Tɛ́ kɩ ǹ no kɔ̃ pè kɩ pwáhnmɔnɔ dùkù pɩ̃, pé tyípêl yɔ̃̀nmɔnɔ gbõ̀ yõ. ");
INSERT INTO wib_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ápi Liyel nɩ̀gbɛ̀kɩ̀, ànɛ̂ ǹ tɔ̃́nsàhnpɩnɔ gbõ̀ yõ, à kɩ kyòo mɔ á yõ kɩ wil yĩ̂nyõ gbĩ́ sɔ̃́ gbo, ");
INSERT INTO wib_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","kɩ pɔ kyòolɛ névye kɔ̃, nónó-á mɛ kũ fɛ̃́ntũ̂ tíkí sɔkɔ, tɛ́ kɩ á yey vi mɔ yèvɩnɩ wɛ̃̀kɩ̀ yõ.» ");
INSERT INTO wib_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Tɛ́ Nsyɔ̃ tɛ̃̀ wɔ sõ̀ mɛ n kyãh, ànɛ̂ ǹ lékã́m mɛ n yɩkɩ n mɔ n yuku. À sõ̀ mɛ tɛ̃ gbɛ̃́nnɩ sɔkɔ pópó, à pɔ syɩ ǹ gblɔ̌y wɛ̃́kɩ́nɔ́ gbĩ̀yĩ̀kì tyɩ́ Yisrayel névye yah. ");
INSERT INTO wib_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Kénɛ tyi pɩ gbĩ́nɛ, Wromɛnɔ yõ̀tɛ̃̀ Wokusti kwní kɔ̃ nɛ, pè pé tɔ̃́rɩ́ mɛ́-ńtã̂n névye pól yãh pé dan pɩ̃. ");
INSERT INTO wib_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Kénɛ névye yã́hnɔ́ gben pɔ Krinisi wɛ Siri kwlo pól yah yétɛ̃̀nɛ. ");
INSERT INTO wib_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Képah tɛ̃̀nɛ, no pól sõ̀ mɛ pé yninɛ n wãrkɩ n pɔ pé súbí kwlo sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Tɛ́ Yosɛfulɛ, yõ̀tɛ̃̀ dĩ́ Davidi náh nɛy ye sõ̀ ǹnɛ. Kǎh pɩ sɛ̃́, ǹ tɔ mó wil Nasarɛtɩ kwil, Kalile sétáh yõ, à yuku Yude kwil yɔ́ sɔkɔ, pè n ye Betlɛmɩnɛ, yõ̀tɛ̃̀ dĩ́ Davidi dúbí-ńsah. ");
INSERT INTO wib_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Tɛ́ Yosɛfu kyɩ Mari sõ̀ mɛ kúrkìlɛ, pǎh n yuku pé yni wã́rkɩ́-ńsah gbĩ́ nɛ̂nɛ. ");
INSERT INTO wib_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Pǎh kyɩ yĩni tɛ̃, pè sõ̀ mɛ sɛ̃́ nɛ́npɔ́, tɛ́ Mari dubi sṍ nɔ. ");
INSERT INTO wib_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Képah sɔkɔ, pè tɛ̃̀-ǹsah yah kwlɔ nɛ́pân twáh-ńsah, tɛ́ kyɩ tɛ̃ yípɛ̂y sɛ̃́-ńsah. À ǹ pígben dubi dĩ́npirlɛ, tɛ́ à plo fwɔ gbrólɛ, à snɛkɩ mɔ yípɛ̂y yõ yõ dú yɔ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Légbĩ́nɛ, Betlɛmɩ kwil gbɔ̀pɔ yɔ́lɛ, képyɛ́nfɛ̃bɩ yísyɔ́ sõ̀ mɛ n sõ gbãn sɔkɔ, à pé képyɛ́nɩ̀nɛ n syɩkɩ. ");
INSERT INTO wib_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Pè mɛ tɛ̃̀nɔ́lɛ, tɛ́ yĩ̂nyõ tɛ̃ntõ̀ yɔ́ pɔ wil mɔ pé yõ. Nɛ́npɔ́ swɔ, Liyel tɔ̃́rɩ́ núkú tyah pól piki pěrr pé yõ. Tíkí mɛ pè kah tɛ̃. ");
INSERT INTO wib_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Yĩ̂nyõ tɛ̃ntõ̀ mɛ yo pé tyɩ́: «Yé káh tíkí pɩ! Kwil pól nɩ̀vɩ̀ tir pèpɛy yɔ́ ye mé pɔ yó-ńsah yé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Piri yɔ́ mɛ dubi yé tyɩ́ kwɛy lékã̂hnɛ Davidi kwil sɔkɔ. Ǹmɔ ye TƐ̃̀ ǸGBƐ̃NƐ pè n ye Kristalɛ, Liyel-á nɛ, páh kɩ nɛ̂ tɛkɩ mɔ. Ǹmɔ ye tɔ̃ yé pwáhnmɔ-òlɛ. ");
INSERT INTO wib_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Tɛ́ yáh nɛ pɩ sɔ̃́, tɛ́ à yah n pɩ̃ n pi, kè wɛ yɔ̀: Yáh kɩ kyɩ píyĩ́rí nɛ̂ wɛ plónɔ́lɛ flɔlɛ, tɛ́ mɛ snɛ́kɩ́nmɔnɔlɛ yípɛ̂y yõ yõ dú sɔkɔ, ǹmɔ ye.» ");
INSERT INTO wib_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Nɛ́npɔ́ swɔ, yĩ̂nyõ tɛ̃ntõnè yísyɔ́ wil kwĩnkilɛ yĩ̂nyõ, à pɔ gben tɛ̃̀ nɔ, pè tyah Liyel yĩnnɛ n gbilki yɩ̀gbɩ̀nɩ̀ sɔkɔ, mɛ yo tũ nɛ ńkɛ̃́: ");
INSERT INTO wib_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Liyel yĩn pɩ gblò yĩ̂nyõ. Ǹmɔ ye ǹ yèvɩnɩnɛ ǹ nɩ̀vɩ̀ névye kɔ̃ sétáh yõ.» ");
INSERT INTO wib_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Képah náh, yĩ̂nyõ tɛ̃ntõnè-á pé syɩ sɔkɔ yĩ̂nyõ, képyɛ́nfɛ̃bɩ nɔ́pi mó n yo wɛ̃ tyɩ́ nɛ, pé no, pè yâwɔ pé kyɩ yah Betlɛmɩ. Tir nɛ̂-á pɩ nɛ́npɔ́, tɛ́ Liyel ǹ tɛ̃ntõ̀ tõ pé tyɩ́, páh yɩ̃nɛ pé kè wɛ. ");
INSERT INTO wib_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Pǎh wɛkɩ wɛ̃ kɔ̃ sɛ̃́, pè pé kyãh yuku Betlɛmɩ. Pè píyĩ́rí mɛ̀ soh kyɩ wɛ snɛ́kɩ́nmɔnɔlɛ yípɛ̂y yõ yõ dú sɔkɔ, Mari ànɛ̂ Yosɛfulɛ ǹ gbɔ̀pɔ. ");
INSERT INTO wib_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Pǎh à wɛ sɛ̃́, yĩ̂nyõ tɛ̃ntõ̀-á tyi nónó pól yo pé tyɩ́ ǹ tyɩ́ sɔkɔ, pè sè yãh pè syah. ");
INSERT INTO wib_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Nónó pól-á képyɛ́nfɛ̃bɩ wɛlɔ nɔ́pi noh, kè pé gbã̀n du. ");
INSERT INTO wib_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mari tɛ̃̀ mó tyi nɔ́pi pól syi sah ǹ fɔkɔlɛ n sõ. ");
INSERT INTO wib_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Képah náh, képyɛ́nfɛ̃bɩ pé syɩ. Yĩ̂nyõ tɛ̃ntõ̀-á sõ̀ yo sɔ̃́ pé tyɩ́, kè mó ńtyɩ̃́nɔ pɩ sɛ̃́. Képah ye, pǎh tyi nónó pól noh tɛ́ tyi nónó pól wɛ, sépi pè kɔ̃ pè Liyel yĩnnɛ n gbilki, ǹ pal tyɩ́lɛ n yãh n yuku wɛ̃̀kɩ̀ yah. ");
INSERT INTO wib_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Képah náh, piri dúbínɔ́ sèpĩ̀n kwǎrtɔ̃́-ò sṍlɛ, ǹ kõ gbĩ́ nɔ. Pè mɛ ǹ yĩn sah Yesulɛ, sɔ̃́-á sõ̀ yĩ̂nyõ tɛ̃ntõ̀ yo sah kélɛ ǹ kúrkì tɔ́kɔ́-ńkɛ̃̂ gbĩ́nɛ. ");
INSERT INTO wib_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Képah sɔkɔ, sédám pɛ̀kɩ̀ kṹnɔ́ nɛ̂-á yɩ̃nɛ kè pɩ Moyisi tyi kõ̀nsàhnɔ́-á kè yo sɔ̃́, ké sèpĩ̀n-á tũ, Yosɛfu ànɛ̂ Mari Yesu tɛ̃ yuku Yerusalɛmɩ, à kyɩ ǹnɛ Liyel gbõ̀ dahbɩ. ");
INSERT INTO wib_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Kè ye mɛ wã́rkɩ́nsàhnɔ́lɛ Tɛ̃̀ ǹgbɛ̃ Liyel tyi kõ̀nsàhnɔ́ sɔkɔ nɛ ńkɛ̃́, pye gbro dĩ́npì pól-á yɩ̃nɛ pè Tɛ̃̀ ǹgbɛ̃ Liyel gbõ̀ dahbɩ. ");
INSERT INTO wib_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ànɛ̂ tɔ̃ ǹkànpĩ̀nnɔ́ nínɔ́lɛ, pɛ̀kɩ̀ ànɛ̂ yũ̌kìlɛ Liyel kɔ̃ sárkálɛ, képah náh pɩ, kèpíkípíkínɔ nínɔ́lɛ, sɔ̃́-á kélɛ wã́rkɩ́nsàhnɔ́lɛ Tɛ̃̀ ǹgbɛ̃ Liyel tyi kõ̀nsàhnɔ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Tɛ́ légbĩ́nɛ, dĩ́ yɔ́ sõ̀ mɛ Yerusalɛmɩ sɔkɔ, pè n ye Simeyɔ̃lɛ. À sõ̀ mɛ nɛ́gbɩ́lɛ Liyel yah, tɛ́ mɛ n sah ǹ yóré yõ. À sõ̀ mɛ Yisrayel pwáhnmɔ-ò pɔ́nɔ́lɛ n syɩkɩ, tɛ́ Liyel Mírkí sõ̀ mɛ ǹ sɔkɔ, ");
INSERT INTO wib_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","tɛ́ kélɛ à wɛ̃kɩ nɛ, à náh n ku n pi, nɛ́ à náh Krista wɛ yĩ́nɛ, nɛ̂-á Tɛ̃̀ ǹgbɛ̃ Liyel kɩ tɛkɩ mɔ n pi. ");
INSERT INTO wib_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Képah sɔkɔ, Liyel Mírkí ǹ yah tɛ̃ yuku Liyel wɔ̀kɔ̀ ǹgbɛ̃ kéntáhkɩ̀ sɔkɔ. Tɛ́ Yesu dúbípú sõ̀ mɛ à tɛ̃ pɔ tyi kõ̀nsàhnɔ́ pɩ́ntũ yĩnnɛ ǹ tyɩ́, kǎh yo sah sɔ̃́. ");
INSERT INTO wib_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Képah tɛ̃̀nɛ, Simeyɔ̃ mɛ piri mɛ̀ tɛ̃ ǹ gbõ̀, tɛ́ Liyel yĩnnɛ n gbilki, mɛ yo tũ nɛ: ");
INSERT INTO wib_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","31","«Ń Tɛ̃̀ ǹgbɛ̃ Liyel, mé pwáhnmɔ-ò wɛ ń yĩ́nɛ, wáh nɛ̂ kɔ̃ kèkõyṍ névye pól yĩ́ yah. Képah ye, á kɩ fɛ̃ á tõ̀npɩ min syi núkúnúkú à kɔ̃ à nɛ n yuku yèvɩnɩ sɔkɔ, sɔ̃́-á á wɛy kè yo. ");
INSERT INTO wib_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Pwáhnmɔ-ò kɩ pɩ kyòolɛ kwlo kwlo névye tyɩ́, kɩ á dùkùlɛ pè wɛ̃kɩ, tɛ́ kɩ pɩ yõ yɔ̃̀nɔ́lɛ áwɔ no Yisrayel tãn tyɩ́.» ");
INSERT INTO wib_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Kǎh pɩ sɛ̃́, tyi nónó-á à yo Yesu tyɩ́ sɔkɔ, sè pɩ gbɛ̃̀ndùnìnɛ ǹ sú ànɛ̂ ǹ yṹ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Képah sɔkɔ, Simeyɔ̃ mɛ sãm mɔ pé sɔkɔ, tɛ́ yo ǹ yṹ Mari tyɩ́ nɛ: «Yah, piri mɛ̀ mɛ Yisrayel névye náhnáh syɩ́kɩ́nmɔnɔ ànɛ̂ pé náhnáh yílkínsàhnɔ́ yĩnnɛ, ànɛ̂ yékã̂b dénɔ́ yõlɛ. ");
INSERT INTO wib_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Kǎh pɩ sɛ̃́, névye náhnáh fɔ́kɔ́sɔ̃nɔ kɩ wilki mɔ kwèyy. Tɛ́ áwɔ tɛ̃̀ wɔlɛ, á kɩ yèvyãhrɩ pɩ, á kɩ nɛ pè sɔ̃́ mɛ á nɩlɛ n sukɛ nyàhlɛ.» ");
INSERT INTO wib_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Tɛ́ Liyel tɛ̃ntõ̀ syínyo-ò pi yɔ́ sõ̀ mɛ, pè n ye Annɛ. Fanuwel písê ye sõ̀, nɛ̂-á Asɛrɩ yìkì nɛynɛ. Ǹ yah sõ̀ wah náhnáh. Ǹ sépíl gbĩ́nɛ, wǎh de pɛ tyɩ́, ǹ pɛ yah kwlɔ ké ye kwǎrní-ò sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","À mɛ tɛ̃ pɛ́kúsèlɛ, à pɔ nɔ ye tíkíyẽ́h pɔ́ ńyã́h tyɩ́. À náh sõ̀ mɛ n gbɛ n mɔ Liyel wɔ̀kɔ̀ ǹgbɛ̃nɛ, tɛ́ mɛ Liyel yĩnnɛ n gbilki gbĩ́mɛgbĩ́, ké lékã̂h ké gbĩ̀ntɔ̃̀, níkì tɛ̃́nɔ́ ànɛ̂ nírí sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ǹmɔ tɔ mɛ de kyɩ yɩ̃nɛ Yesu ànɛ̂ ǹ dúbípúlɛ Liyel wɔ̀kɔ̀ ǹgbɛ̃ kéntáhkɩ̀ sɔkɔ. À tyah Liyel yĩnnɛ n gbilki. Tɛ́ nónó-á sõ̀ mɛ Yerusalɛmɩ pwáhnmɔnɔ syɩkɩ tɛ̃, à mɛ piri tyɩ́lɛ n yãh pé pól tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yesu dúbípú-á Liyel tyi sàhnɔ́ pɩ tũ tɛ, képah náh, pè pé syɩ sɔkɔ Kalile sétáh yõ, pé kwil Nasarɛtɩ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Tɛ́ piri wɔ mó mɛ n kyãh, mɛ tǎhkɩ̀lɛ n wɛ. Lékã́m ǹgbɛ̃ sõ̀ mɛ ǹ sɔkɔ, tɛ́ Liyel mɛ ǹ nɩlɛ n gbɛ. ");
INSERT INTO wib_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ye ye póllɛ, Yesu dúbípú ńkɛ̃́nɛ nɛ n kyɩ n pɔ Yerusalɛmɩ, Pakɩ syáh sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Tɛ́ Yesu-á pɔ nɔ ye gbɔ̃ninɔ́lɛ gbĩ́ nɛ̂nɛ, ǹ dúbípú dɔkɔ yuku ǹnɛ Yerusalɛmɩ, Nsyifunɔ-á sõ̀ kélɛ n pɩ sɔ̃́. ");
INSERT INTO wib_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Syáh-á pɔ tyɛ sṍ nɛ̂nɛ, pè pé syɩ sɔkɔ, tɛ́ pé pídĩ́ Yesu mɛ wũ Yerusalɛmɩ, ǹ dúbípú pɩ̃́-ńkɛ̃̂ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Pè sõ̀ mɛ n sõ nɛ, wǎh mɛ ànɛ̂ pé no wɛ̃̀kɔbɩ yísyɔ́lɛ. Kǎh pɩ sɛ̃́, pè gbĩ̀yĩ̀kì núkú kɔ́lɔ́ kɔ, tɛ́ pyě tyah ǹnɛ n yah n kɔ̃ pé wɔ̀kɔ̀ tãn ànɛ̂ pé nɛ́pɩ̃́nɔ́ wrɔ́. ");
INSERT INTO wib_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ǹtɛ, pè náh à wɛ. Pǎh à yah kwlɔ sɛ̃́, pè pé syɩ à yah kɔ̃ yuku Yerusalɛmɩ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ké sèpĩ̀n tɔ̃́-ò sṍlɛ, pè pyě kyɩ à wɛ Liyel wɔ̀kɔ̀ ǹgbɛ̃ kéntáhkɩ̀ sɔkɔ. À mɛ kɔ̃́ntɛ̃̀nɔ́lɛ Liyel ǹgbò wɛ̃̀kɩ̀ kwɔ́pú wrɔ́, mɛ n nohnɩ pé tyɩ́, tɛ́ mɛ pélɛ n piki n yah tyilɛ. ");
INSERT INTO wib_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Nónó pól-á sõ̀ mɛ n nohnɩ ǹ tyɩ́, ǹ lékã́m ànɛ̂ ǹ tyi yah yónɔ́ dùkù pé gbã̀n du. ");
INSERT INTO wib_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ǹ dúbípú-á à wɛ sɛ̃́, kè pépi tɔ gbã̀n kah du. Ǹ yṹ mɛ yo ǹ tyɩ́ nɛ, pé pídĩ́, sɔ̃́ se pɩ, tɛ́ à pɩ sɛ̃́ pé tyɩ́ nɩ? À yah, péwɔ ànɛ̂ ǹ sú yáh-ńsah-á tyɛ kègbɩlɛ ǹ yáhnkɔ̃nɔ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ǹtɛ, à mɛ yo pé tyɩ́: «Sɔ̃́ pɩ, tɛ́ yé ńnɛ n yah n kɔ̃? Yé náh pɩ̃ nɛ, máh yɩ̃nɛ mé nɛ n mɛ ń sú tyah sɔkɔ di?» ");
INSERT INTO wib_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ǹtɛ, pè náh mɛ ǹ wɛy mɛ̀ tyɩ́ yah wɛ. ");
INSERT INTO wib_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Képah náh, à mɛ yuku pélɛ Nasarɛtɩ kwil sɔkɔ, tɛ́ mɛ ǹ gblɔ̌ynɛ n tiki n mɔ pé tyɩ́. Ǹ yṹ wɔ mó tyi nɔ́pi pól syi sah ǹ fɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Tɛ́ Yesu sõ̀ mɛ n kyãh ǹ gbɛ̃́nsê ànɛ̂ ǹ lékã́m mɛ n yɩkɩ n mɔ n yuku. Tɛ́ wãn tɔ mɛ mɔ ǹ nɩ̀gbɛ̀kɩ̀ yõ Liyel ànɛ̂ névye tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tibɛrɩ-á sõ̀ mɛ Wromɛnɔ yõ̀tɛ̃̀nɛ gbĩ́ nɛ̂nɛ, ǹ yõ̀tɔ̃rɩ́ ye gbɔ̃nkwlɔ́-ò pɔ Põse Pilatɩ wɛ Yude kwil yah yétɛ̃̀nɛ. Tɛ́ Yerɔdɩ wɔ mó mɛ Kalile kwil yõ̀tɛ̃̀nɛ. Ǹ gbɛ̃̀ dĩ́ Filipi mɛ Yitiri ànɛ̂ Trakoniti yõ. Tɛ́ Lisanyasɩ wɔ mɛ Abilɛnɩ yõ. ");
INSERT INTO wib_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Tɛ́ An ànɛ̂ Kayifi ye sõ̀ sárká wìlkìpu yõ̀tãm ǹgbnɔlɛ. Légbĩ́nɛ, Nsakarɩ pídĩ́ Nsyɔ̃ Liyel yónmɔnɔ noh gbɛ̃́nnɩ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Kǎh pɩ sɛ̃́, à kyɩ Yurdɛ̃ yɔ gbɔ̀plɔ tã̀ntã̀n pól kɔ kɔ̃, mɛ n yo pé tyɩ́ nɛ, pè Liyel wɛ̃̀kɩ̀ tɛ̃, pè mó wèlnwìlkìnɔ́ wɛ. Képah sɔkɔ, pé tyípêl-á kɩ yɔ̃ mɔ pè kɔ̃. ");
INSERT INTO wib_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Kǎh pɩ sɔ̃́, sɛ̃́ ye ńtyɩ̃́nɔ sõ̀ Liyel tɛ̃ntõ̀ syínyo-ò Yesayi wãrkɩ sah kélɛ nɛ ńkɛ̃́: «Ǹnɩ̂ yɔ́ yĩ́npɔ̃́ ye n dɔkɔ gbɛ̃́nnɩ sɔkɔ nɛ ńkɛ̃́: ‹Yé Tɛ̃̀ ǹgbɛ̃ wɛ̃̀kɩ̀ tɔ̃ sah. Yé ǹ sɔ́kɔ́-ńtã̂n pɩ tómtóm. ");
INSERT INTO wib_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ymɔ wrɔ́nɔ pól kɩ yɩ̃. Kènpni ànɛ̂ ymɔ pól kɩ tirki pɩ támm. Syɔ̃̀-ǹtã̀n knɛ̌nɩ̀ kɩ pɩ tómtóm, tɛ́ wɛ̃̀túkúnì kɩ tɔrɩ. ");
INSERT INTO wib_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Képah sɔkɔ, no pól kɩ Liyel nɛy pwáhnmɔnɔ wɛ yĩ́nɛ.›» ");
INSERT INTO wib_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Nɛ́kwĩ́nkí nónó-á sõ̀ n pɔ n pɔ Nsyɔ̃ tyɩ́ à kɔ̃ à pélɛ n wel n wilki, à sõ̀ mɛ n yo pé tyɩ́ nɛ, wáhnmɩ́rɔ́ dùkù nɔ́pi! Nɛ̂ se kwɔ pélɛ nɛ, pǎh kɩ fɛ̃ to pwah Liyel fɔ̀kɔ̀vyã̀hnɩ̀ yah, nɛ̂-á n pi nɩ? ");
INSERT INTO wib_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ńkɛ̃́, pè tyípéplɔlɛ n pɩ nónó-á n wɛ̃kɩ n pi nɛ, pǎh Liyel wɛ̃̀kɩ̀ tɛ̃. Tɛ́, pè káh pé gbõ̀ sah Abrahmɩ yõ nɛ̂-á pé súlɛ. Páh kélɛ n yo pé tyɩ́, Liyel-á kɩ fɛ̃ dyêh nɔ́pi vi mɔ pɩ Abrahmɩ pyelɛ. ");
INSERT INTO wib_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Tɛ́ man ńtɛ̃-á mɛ yáhnsàhntɛnɔlɛ sésân fɛ̃ yĩnnɛ sé sémîn sɔkɔ. Séswɔ̂ nɛ̂-á n syí-ńkɛ̃̂nɛ pye pèplɔlɛ, kǎh kɩ ko dah mɔ nyàh sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Képah tɛ̃̀ sɔkɔ, tɔ́wû Nsyɔ̃nɛ n piki n yah nɛ ńkɛ̃́, sɔ̃́ se pé yɩ̃nɛ pé pɩ nɩ? ");
INSERT INTO wib_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","À mó yo pé tyɩ́ nɛ, fwɔ̀mɔlɔ nínɔ́-à mɛ nɛ̂ tyɩ́, tɛ̃̀ núkúlɛ fwɔ̀mɔ̀-ǹkã̂n nɛy kɔ̃. Tɛ́ yõke-à mɛ nɛ̂ tyɩ́, tɛ̃̀ yɩ̃ kwɛ́ndé kɔ̃. ");
INSERT INTO wib_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Mɔ́rɩ́ syípú yísyɔ́ tɔ pɔ Nsyɔ̃ tyɩ́ nɛ, à pé wel wilki, tɛ́ à piki yah nɛ, pé kwɔ́-ò dĩ́, ńkɛ̃́ sɔ̃́ se pépi yɩ̃nɛ pé pɩ nɩ? ");
INSERT INTO wib_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","À mó yo pé tyɩ́ nɛ, pǎh yĩ̀n nɛ̂ yo pé tyɩ́, pè káh nɛ n dohnɩ n syi ké yõ. ");
INSERT INTO wib_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Képah sɔkɔ, sràsyíbí tɔ pɔ à piki yah nɛ ńkɛ̃́, tɛ́ pépi-á dò, sɔ̃́ se pé kɩ pɩ nɩ? À mɛ yo pé tyɩ́ nɛ, pè káh nɛy wore ǹ gbõ̀ kwâh tɛ̃ syi tǎhkɩ̀ sɔkɔ. Pè káh mó tɔ̃ nɛy gbõ̀ kwâh syi yĩ́nvǐ sɔkɔ. Ńkɛ̃́, pè yɛ pé tõ̀ pɩ́nɔ́ wɛ́nɔ́ pé yĩ́nɛ n yuku. ");
INSERT INTO wib_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Képah sɔkɔ, no pól-á sõ̀ mɛ pwáhnmɔ-ò syɩ́kɩ́nɔ́ sɔkɔ sɛ̃́, pè sõ̀ mɛ pé gblɔ̌ynɛ n piki n yah nɛ, tɛ́ Nsyɔ̃ káh kɩ nɛ̂ Kristalɛ dɛ́? ");
INSERT INTO wib_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Képah tɛ̃̀nɛ, à pé pól syah nɛ: «Ńmɔ tɛ̃̀ wɔ ye yélɛ n wel n wilki ni sɔkɔ. Tɛ́ nɛ̂-á n pi, ǹmɔ tɛ̃́nwɛnɔ kal ńmɔ tyɩ́lɛ. Mé náh yɩ̃nɛ ǹ lékyêh mnɔ ńtɛ̃ wàhnmɔnɔlɛ. Tɛ̃̀ wɔ kɩ pɔ yé wel wilki Liyel Mírkí ànɛ̂ nyàh sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ǹ sèmukɔ fwo fwo kwâh mɛ ǹ gbõ̀. À kɩ ǹ táh tɔ̃ sah, ǹ sèmukɔ fwo kɩ kwel mɔ ǹ dúkúrí sɔkɔ, tɛ́ sé yésyɩ̂ wɔlɛ, à kɩ sépi sukɛ ní-ńkɛ̃̂ nyàh sɔkɔ.» ");
INSERT INTO wib_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Nsyɔ̃ sõ̀ mɛ n syɔ̃ sɛ̃́nknɔ vìnmɔ mɔ kwɔ́nɔ́ duke náhnáh sɔkɔ, à nɩ̀vɩ̀nɩ̀ wɛy sã́nnɛ n yo n kɔ̃ no tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","À wil képah sɔkɔ, à tɔ̃ lékàhlɛ yõ̀tɛ̃̀ dĩ́ Yerɔdɩ kɔ̃, ǹ yṹnpi kyɩ Yerɔdyadɩ tɛ̃́nsyinɔ, ànɛ̂ ǹ tyítúkúnì náhnáh pɩ́nɔ́ tyɩ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Tɛ́ Yerɔdɩ náh yĩn sépi tyɩ́, à tɔ̃ Nsyɔ̃ tɛ̃ dah mɔ wɔ̀kɔ̀npèkè sɔkɔ náhlɛ. ");
INSERT INTO wib_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Tɛ́ Nsyɔ̃-á sõ̀ mɛ névyelɛ n wel n wilki gbĩ́ nɛ̂nɛ, wǎh névye pól wel wilki tɛ, Yesu tɔ pɔ à kɔ̃, à à wel wilki. Yesu-á wil ni sɔkɔ tɛ́ mɛ nírílɛ n pɩ, à mɛ yĩ̂nyõ wɛ kè yɩkɩ mɔ. ");
INSERT INTO wib_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Tɛ́ Liyel Mírkí pɔ tiki ǹ yõ wil gbɛ̃́nsê sɔkɔ kèpíkípíkí kètɔ̀lɛ. Képah tɛ̃̀ sɔkɔ, yĩ́npɔ̃́ yɔ́ n wil líyel sɔkɔ nɛ ńkɛ̃́: «Áwɔ ye ń nɩ̀dɛ̀ Pi núkúnínɛ. Á tyɩ́ nɔ yĩ́ĩ́ ń tyɩ́ kègbɩlɛ.» ");
INSERT INTO wib_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu-á ǹ tõ̀ tyah gbĩ́ nɛ̂nɛ, à sõ̀ mɛ ye yõgbãm kénkɔ̃ sɔkɔ. Tɛ́ névye tɛ̃̀ wɔ sõ̀ mɛ n sõ nɛ, Yosɛfu pídĩ́-á ǹnɛ, Yosɛfu nɛ̂-á sõ̀ Yeli pídĩ́nɛ. ");
INSERT INTO wib_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Tɛ́ Yelilɛ, Matata pídĩ́ ye. Matatalɛ, Levi pídĩ́ ye. Levilɛ, Mɛlkɩ pídĩ́ ye. Mɛlkɩlɛ, Yanayi pídĩ́ ye. Yanayilɛ, Yosɛfu pídĩ́ ye. ");
INSERT INTO wib_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yosɛfulɛ, Matatyasɩ pídĩ́ ye. Matatyasɩlɛ, Amɔsɩ pídĩ́ ye. Amɔsɩlɛ, Nawumi pídĩ́ ye. Nawuminɛ, Yesli pídĩ́ ye. Yeslilɛ, Nakayi pídĩ́ ye. ");
INSERT INTO wib_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nakayilɛ, Matɩ pídĩ́ ye. Matɩlɛ, Matatyasɩ pídĩ́ ye. Matatyasɩlɛ, Semeyin pídĩ́ ye. Semeyinnɛ, Yosɛsyɩ pídĩ́ ye. Yosɛsyɩlɛ, Yoda pídĩ́ ye. ");
INSERT INTO wib_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yodalɛ, Nswana pídĩ́ ye. Nswanalɛ, Yresa pídĩ́ ye. Yresalɛ, Yorobabɛlɩ pídĩ́ ye. Yorobabɛlɩlɛ, Salatyɛlɩ pídĩ́ ye. Salatyɛlɩlɛ, Neri pídĩ́ ye. ");
INSERT INTO wib_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nerilɛ, Mɛlkɩ pídĩ́ ye. Mɛlkɩlɛ, Adi pídĩ́ ye. Adilɛ, Kosamɩ pídĩ́ ye. Kosamɩnɛ, Yelemadamɩ pídĩ́ ye. Yelemadamɩnɛ, Yɛrɩ pídĩ́ ye. ");
INSERT INTO wib_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Yɛrɩlɛ, Yesu pídĩ́ ye. Yesulɛ, Yeliyesɛrɩ pídĩ́ ye. Yeliyesɛrɩlɛ, Yorimi pídĩ́ ye. Yoriminɛ, Matata pídĩ́ ye. Matatalɛ, Levi pídĩ́ ye. ");
INSERT INTO wib_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levilɛ, Simeyɔ̃ pídĩ́ ye. Simeyɔ̃lɛ, Yuda pídĩ́ ye. Yudalɛ, Yosɛfu pídĩ́ ye. Yosɛfulɛ, Yonamɩ pídĩ́ ye. Yonamɩnɛ, Yelyakimi pídĩ́ ye. ");
INSERT INTO wib_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Yelyakiminɛ, Meleya pídĩ́ ye. Meleyalɛ, Mɛna pídĩ́ ye. Mɛnalɛ, Matata pídĩ́ ye. Matatalɛ, Natãn pídĩ́ ye. Natãnnɛ, Davidi pídĩ́ ye. ");
INSERT INTO wib_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Davidilɛ, Yese pídĩ́ ye. Yeselɛ, Wobɛdɩ pídĩ́ ye. Wobɛdɩlɛ, Bowasɩ pídĩ́ ye. Bowasɩlɛ, Sala pídĩ́ ye. Salalɛ, Nasɔnɩ pídĩ́ ye. ");
INSERT INTO wib_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasɔnɩnɛ, Aminadab pídĩ́ ye. Aminadablɛ, Adimini pídĩ́ ye. Adimininɛ, Arnɩ pídĩ́ ye. Arnɩnɛ, Yesrɔmɩ pídĩ́ ye. Yesrɔmɩnɛ, Farɛsɩ pídĩ́ ye. Farɛsɩlɛ, Yuda pídĩ́ ye. ");
INSERT INTO wib_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yudalɛ Yakɔbɩ pídĩ́ ye. Yakɔbɩlɛ, Yisakɩ pídĩ́ ye. Yisakɩlɛ, Abrahmɩ pídĩ́ ye. Abrahmɩnɛ, Tara pídĩ́ ye. Taralɛ, Nakɔrɩ pídĩ́ ye. ");
INSERT INTO wib_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nakɔrɩlɛ, Seruki pídĩ́ ye. Serukilɛ, Wrako pídĩ́ ye. Wrakolɛ, Falɛkɩ pídĩ́ ye. Falɛkɩlɛ, Yebɛrɩ pídĩ́ ye. Yebɛrɩlɛ, Sala pídĩ́ ye. ");
INSERT INTO wib_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Salalɛ, Kayinamɩ pídĩ́ ye. Kayinamɩnɛ, Arfasadɩ pídĩ́ ye. Arfasadɩlɛ, Sɛmɩ pídĩ́ ye. Sɛmɩnɛ, Nowe pídĩ́ ye. Nowelɛ, Lamɛkɩ pídĩ́ ye. ");
INSERT INTO wib_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamɛkɩlɛ, Matisala pídĩ́ ye. Matisalalɛ, Yenɔkɩ pídĩ́ ye. Yenɔkɩlɛ, Yarɛdɩ pídĩ́ ye. Yarɛdɩlɛ, Maleleyel pídĩ́ ye. Maleleyellɛ, Kayinamɩ pídĩ́ ye. ");
INSERT INTO wib_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kayinamɩnɛ, Yenɔsɩ pídĩ́ ye. Yenɔsɩlɛ, Sɛtɩ pídĩ́ ye. Sɛtɩlɛ, Adama pídĩ́ ye. Adama wɔlɛ, Liyel pídĩ́ ye. ");
INSERT INTO wib_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesu-á yuku Liyel Mírkí tǎhkɩ̀lɛ, à ǹ syɩ yal Yurdɛ̃ yɔ tnɔ̂. Tɛ́ Liyel Mírkí à tɛ̃ yuku gbɛ̃́nnɩ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","À sèpĩ̀n tikiníní pɩ nɛ́npɔ́ níkì tɛ̃́nɔ́ sɔkɔ. Nɛ́npɔ́ sɔkɔ ye sétã̀n yõ̀tɛ̃̀ à mɔ yah. Tɛ́ sèpĩ̀n nɔ́pi-á pɔ tũ, kwɛkɩ mɛ à tɛ̃. ");
INSERT INTO wib_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Kǎh pɩ sɛ̃́, sétã̀n yõ̀tɛ̃̀ mɛ yo ǹ tyɩ́ nɛ, ǹmɔ-à kɩ nɛ Liyel Pilɛ, à yo dáhkɩ̀ mɛ̀ tyɩ́, kè vi n mɔ n pɩ yõkelɛ. ");
INSERT INTO wib_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesu mó yo ǹ tyɩ́ nɛ: «Kè mɛ wã́rkɩ́nsàhnɔ́lɛ Liyel wɛy sɔkɔ nɛ ńkɛ̃́: ‹Névi náh ǹ min pɩ n pi yõke ólɛ.›» ");
INSERT INTO wib_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Képah náh, sétã̀n yõ̀tɛ̃̀ à tɛ̃ dɔkɔ léyy, à kyɩ à wɛ̃kɩ kèkõyṍ tɔ̃́rɩ́ póllɛ sɛ́yy ǹsɔ̃, ");
INSERT INTO wib_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","tɛ́ yo ǹ tyɩ́ nɛ, páh kɩ fɛ̃ à kɔ̃ n pi sépi pól yõ̀tɔ̃rɩ́, ànɛ̂ sé tahrɩlɛ. Sépi pól-á péwɔ gbõ̀ dahbɩ. Képah-á, nɛ̂-à pé dyɔ, páh kɩ sélɛ ǹmɔ kɔ̃. ");
INSERT INTO wib_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ńkɛ̃́, wàh kɩ fɛ̃ syi ǹ gbètukunɔ di pé yah à pé gbilki, páh kɩ sé póllɛ à kɔ̃. ");
INSERT INTO wib_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Képah sɔkɔ, à mó yo sétã̀n yõ̀tɛ̃̀ tyɩ́ nɛ: «Kè mɛ wã́rkɩ́nsàhnɔ́lɛ Liyel wɛy sɔkɔ nɛ ńkɛ̃́: ‹Á kɩ á Tɛ̃̀ ǹgbɛ̃ Liyel ó núkúnínɛ n gbilki, tɛ́ kɩ n sah ǹmɔ ó tyɩ́ yõ.›» ");
INSERT INTO wib_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Képah náh, sétã̀n yõ̀tɛ̃̀ tɔ̃ yuku ǹnɛ Yerusalɛmɩ, à kyɩ à sah Liyel wɔ̀kɔ̀ ǹgbɛ̃ yõ̀tah, tɛ́ mɛ yo ǹ tyɩ́ nɛ, ǹmɔ-à kɩ nɛ Liyel pilɛ, à yɔkɔ tiki sétáh. ");
INSERT INTO wib_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Kǎh mɛ wã́rkɩ́nsàhnɔ́lɛ Liyel wɛy sɔkɔ nɛ ńkɛ̃́, Liyel-á kɩ ǹ yĩ̂nyõ tɛ̃ntõnè kɔ̃, sè kɩ ǹnɛ n kyɔmɩ, ");
INSERT INTO wib_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ànɛ̂ tɔ̃, sǎh kɩ à swah syi sé gbã̀n sɔkɔ. Dáhkɩ̀ náh ǹ gbáhkɩ̀ pɩ yɔ n pi. ");
INSERT INTO wib_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Képah tɛ̃̀ sɔkɔ, à mɛ yo sétã̀n yõ̀tɛ̃̀ tyɩ́ nɛ: «Kè mɛ yónɔ́lɛ Liyel wɛy sɔkɔ nɛ ńkɛ̃́: ‹Káh á Tɛ̃̀ ǹgbɛ̃ Liyellɛ n mɔ n yah!›» ");
INSERT INTO wib_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Kénɛ mɔ́nyahnɔ nɔ́pi pól sɔ́kɔ́ntɛnɔ náh, sétã̀n yõ̀tɛ̃̀ yal à gbɛ mɔ ǹnɛ, tɛ́ mɛ à syɩkɩ tɛ̃ náh tĩ̀nnɛ. ");
INSERT INTO wib_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Képah náh, Yesu ǹ syɩ yuku Kalile sétáh yõ Liyel Mírkí tǎhkɩ̀lɛ ǹ sɔkɔ. Tɛ́ ǹ yĩn sõ̀ mɛ wil nɛ́npɔ́ kwlo pól sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","À sõ̀ mɛ kwɔ́nɔ́lɛ n pɩ pé Liyel ní-ńtã̂n vɩ̀ sɔkɔ, tɛ́ no pól mɛ ǹnɛ n gbilki. ");
INSERT INTO wib_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Sṍ yɔ́lɛ, Yesu pɔ Nasarɛtɩ sɔkɔ. Kénɛ kwil sɔkɔ ye sõ̀ à kyãh. Mɩ mɩ yòh sṍlɛ, à mɛ de Liyel ní-ńsah wɔ̀kɔ̀ sɔkɔ, wǎh dar tɛ́ kélɛ n pɩ sɔ̃́, tɛ́ mɛ yuku nɛ, pé Liyel wɛy kar. ");
INSERT INTO wib_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Képah sɔkɔ, pè Liyel tɛ̃ntõ̀ syínyo-ò Yesayi sɛ́bɛ́y tɔkɔ à kɔ̃, à syi yɩkɩ mɔ fɩ̃́ yɔ́ sɔkɔ, ńyãh-á kè mɛ wã́rkɩ́nmɔnɔlɛ nɛ ńkɛ̃́: ");
INSERT INTO wib_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Tɛ̃̀ ǹgbɛ̃ Liyel ń yah wilki, à ǹ Mírkí mɔ ń sɔkɔ nɛ, mé nɩ̀vɩ̀nɩ̀ wɛy sã́n yo yãm tãn tyɩ́. À ń tɛkɩ mɔ yɔ̃bɩ yɔ̃rɩ sɔkɔ wìlnɔ́ tyɩ́ yo yĩnnɛ pé tyɩ́, ànɛ̂ yɩ̃́tũbi yɩ̃́ yɩ́kɩ́nmɔnɔ tyɩ́ yo yĩnnɛ, ànɛ̂ yèvyãhrɩ tɛ̃ yõ yĩnnɛ névye yõ, nónó-á mɛ fṍhnɔ́ sɔkɔ, ");
INSERT INTO wib_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ànɛ̂ ǹmɔ pèpɔrɩ pɔ yi tyɩ́ yo yĩnnɛ.» ");
INSERT INTO wib_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Képah náh, Yesu sɛ́bɛ́y yah vike, tɛ́ kélɛ Liyel wɔ̀kɔ̀ kyɔ̀mɩ̀-ò kɔ̃, tɛ́ kɔ̃ tɛ̃. Tɛ́ nónó-á sõ̀ mɛ Liyel ní-ńsah wɔ̀kɔ̀, pé pól sõ̀ mɛ ǹnɛ n yah díkí díkí. ");
INSERT INTO wib_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Képah tɛ̃̀ sɔkɔ, à tyah n yo pé tyɩ́ nɛ: «Liyel wɛy fɩ̃́ nɛ̂ tyi-á yé noh, sè pɩ tũ kwɛynɛ yé tyɩ́.» ");
INSERT INTO wib_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Kǎh pɩ sɛ̃́, no pól sõ̀ mɛ Yesu yĩ́ngbɩ́lɛ n yo. Tɛ́ ǹ wɛlɔ pèplɔ wɛ́kɩ́nɔ́ sõ̀ mɛ pé gbã̀n du, pè mɛ yo tũ nɛ, ǹmɔ kó Yosɛfu pídĩ́nɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Képah sɔkɔ, à mɛ yo pé tyɩ́ nɛ, páh pɩ̃ nɛ, pǎh kɩ sèmìrkì mɩ n pi, nɛ̂-á n yo nɛ ńkɛ̃́, sènpɩ̀tɛ̃̀, à ǹ gblɔ̌y dɛ mɔ kɛ̀! Pǎh kɩ tɔ̃ n yo n pi pé tyɩ́ nɛ, páh tyi nónó pól pɩ Kapɛrnayumi sɔkɔ, páh sè noh. Tɛ́ pé tɔ̃ sé dùkù pɩ pé sú kwil sɔkɔ kɛ̀. ");
INSERT INTO wib_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","À tɔ̃ yo pé tyɩ́ nɛ: «Mé kélɛ n yo n dal n mɔ yé tyɩ́ nɛ: pè náh Liyel tɛ̃ntõ̀ syínyo-ò yɔ́ ńtɛ̃nɛ n tɛ̃ plɛ ǹ sú kwil sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Kègbɩ tɛ̃̀ yõ, mé kélɛ n yo yé tyɩ́ nɛ: Liyel tɛ̃ntõ̀ syínyo-ò Yeli mɛ gbĩ́nɛ, pũ̀-á lésõ to pópó, à pɔ syɩ ye tɔ̃́nɔ́ ànɛ̂ ńwɔ̃́lɔ́ kénúkò tyɩ́, tɛ́ kwɛ́npékè yɔ́ mɛ de kwil pól sɔkɔ gbĩ́ nɛ̂nɛ, pɛ́kúsyɔ náhnáh sõ̀ mɛ Yisrayel sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ǹtɛ, Liyel náh Yeli tɛkɩ mɔ pépi sɔkɔ nɛy yɔ́ ńtɛ̃ tyɩ́, tɛ́ pɛ́kúsè yɔ́ tyɩ́ ye à tɛkɩ mɔ ǹnɛ, Sarɛpɩta kwil, Sidõ sétáh yõ. ");
INSERT INTO wib_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ànɛ̂ Liyel tɛ̃ntõ̀ syínyo-ò Yelise mɛ gbĩ́nɛ, tótãm náhnáh tɔ sõ̀ mɛ Yisrayel sɔkɔ, tɛ́ pé sɔkɔ nɛy yɔ́ ńtɛ̃ náh dɛ́nmɔnɔ wɛ, à wil Siri sétáh tótɛ̃ dĩ́ Nama tyɩ́ sɔkɔ.» ");
INSERT INTO wib_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Képah sɔkɔ, nónó pól-á sõ̀ mɛ Liyel ní-ńsah wɔ̀kɔ̀ sɔkɔ, pé fɔkɔ vyãh wɛlɔ nɔ́pi nóhnɔ́ tɛ̃̀ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Pè mɛ yuku Yesu tɛ̃ yɔrɩ wil kwil sɔkɔ, à dɔkɔ yuku ǹnɛ yɔ̃lɩ yõ̀tah, pé kwil-á sõ̀ mɛ mɔ́nɔ́lɛ nɛ̂ yõ, tɛ́ nɛ, pé à tu wilki mɔ. ");
INSERT INTO wib_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Tɛ́ à núkú wil pé wrɔ́, à sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Képah náh, Yesu kyɩ Kapɛrnayumi kwil sɔkɔ, Kalile sétáh yõ, tɛ́ mɛ névyelɛ n kwɔ Nsyifunɔ mɩ mɩ yòh sṍlɛ. ");
INSERT INTO wib_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ǹ wɛy sõ̀ mɛ yõ̀tɔ̃rɩ́ wɛynɛ. Képah ye ǹ névye kwɔ dùkù kɔ̃, kè no pól gbã̀n du. ");
INSERT INTO wib_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Tɛ́ lésõlɛ, kè pɔ yɩ̃nɛ, dĩ́ yɔ́ sõ̀ mɛ Liyel ní-ńsah wɔ̀kɔ̀ sɔkɔ, sétõlɛ ǹ sɔkɔ. Dǒ, à de syi fírr yĩ́npɔ̃́ ǹgbɛ̃nɛ nɛ, ");
INSERT INTO wib_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","wéèè, Nasarɛtɩ Yesu, kwâh nɛ̂ se à n yah n kɔ̃ pé tyɩ́ nɩ? À se pɔ pépi tyɩ́ yɩ́kɩ́-ńsah nɩ? Páh ǹnɛ n pnɛ, nɛ́dúkú nɛ̂-á ǹnɛ: Ǹmɔ-á Liyel tɛkɩ mɔ yályál. ");
INSERT INTO wib_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Képah tɛ̃̀ sɔkɔ, Yesu dírí kõ sétõ mɛ̀ yõ nɛ: «Á vyãh vike, ǹ tɛ́ n wil dĩ́ mɛ̀ sɔkɔ.» Nɛ́npɔ́ swɔ, sétõ núkú dĩ́ mɛ̀ tɔkɔ min névye nɩyṍ, tɛ́ wil ǹ sɔkɔ, à náh dlo yɔ́ ńtɛ̃nɛ à nɔ. ");
INSERT INTO wib_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Kǎh pɩ sɛ̃́, kè pɩ gbɛ̃̀ndùnì ǹgbɛ̃nɛ no pól tyɩ́, pè mɛ tyah n yo wɛ̃ tyɩ́ nɛ, wɛy dùkù nɛ̂ se à n wɛ̃kɩ sɛ̃́ nɩ? À tɛ̃ wɛ sétã̀nnɛ n kyɩ̃ n mɔ tɛ̃́nwɛnɔ ànɛ̂ yõ̀tɔ̃rɩ́ sɔkɔ, sè n wil névye sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Sépinɔ́-á pɩ sɛ̃́, Yesu yĩ́ngbɩ́ tyah n yo nɛ́npɔ́ sétáh pól yõ. ");
INSERT INTO wib_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Wǎh yal Liyel ní-ńsah wɔ̀kɔ̀, à sɔkɔ Simɔ gbô. Tɛ́ Simɔ dɛ́y sê sõ̀ mɛ n kwlɔ wílvyã́hnɩ̀nɛ képékèyɔ̂. Pè mɛ kè yah kɔ̃ Yesu tyɩ́ nɛ, à à dɛ mɔ. ");
INSERT INTO wib_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Képah sɔkɔ, Yesu mɛ kɔ yĩn ǹ yõ, tɛ́ dírí kõ wílvyã́hnɩ̀ yõ, ké núkú pi fĩn mɔ. Nɛ́npɔ́ swɔ, à núkú yuku tyah yõke tɛ̃̀-ǹsahlɛ n yah pé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Gbĩ́yĩ́ dénɔ́ sɔkɔ, nónó pól-á sõ̀ mɛ n yɔ yam duke dukelɛ, pé nɛ́tãm pɔ pélɛ Yesu tyɩ́. À mó ǹ gbã̀nnɛ n sah n yuku pé nɛ́núkù núkú yõ, à pélɛ n dɛ n mɔ. ");
INSERT INTO wib_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Tɛ́ sétã̀n tɔ sõ̀ mɛ n wil névye náhnáh sɔkɔ. Sè sõ̀ mɛ n gbo n mɔ sé wil gbĩ́nɛ nɛ ńkɛ̃́, Liyel pi-á ǹnɛ. Ǹtɛ, sǎh pɩ̃ nɛ, Liyel nɛy tɛ́kɩ́nmɔnɔ-á ǹnɛ, à mɛ dírí kõ sé yõ, tɛ́ sé vyɛ̃y tũ wɛ́kɩ́nɔ́lɛ. ");
INSERT INTO wib_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Tyah-á núkú dal, Yesu yuku sɔkɔ gbɛ̃́nnɩ tyah yɔ́ sɔkɔ. Kǎh pɩ sɛ̃́, tɔ́wû yuku tyah ǹnɛ n soh n kɔ̃. Pǎh kyɩ à wɛ gbĩ́ nɛ̂nɛ, pè sõ̀ mɛ ké tyɩ́ nɛ, pé à syi n sah, à káh tɔ̃ yal pé tnɔ̂. ");
INSERT INTO wib_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ǹtɛ, à mɛ yo pé tyɩ́ nɛ: «Mé yɩ̃nɛ mè nɩ̀vɩ̀nɩ̀ wɛy sã́n yo n kɔ̃ kwlo tɛ́lɔ́ tɔ tyɩ́ Liyel tɔ̃́rɩ́ tyɩ́ sɔkɔ. Ń tɛ́kɩ́nmɔnɔ yõ ye képahlɛ.» ");
INSERT INTO wib_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Képah náh, à kyɩ tyah Liyel wɛynɛ n yo n kɔ̃ Liyel ní-ńtã̂n vɩ̀ sɔkɔ Yude kwlo sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Sṍ yɔ́lɛ, Yesu-á sõ̀ mɛ Yenesarɛtɩ yɔ́-ǹgbɛ̃ gbɔ̀pɔ, tɔ́wû pɔ à mɔ gbɩ̃ sah pílpíl, Liyel wɛy noh yĩnnɛ. ");
INSERT INTO wib_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Yesu mɛ krótónè nínì wɛ yɔ tnɔ̂ sɔkɔ, tɛ́ yɛ̃́nkyɔ tɛ̃́pú mɛ wil sé sɔkɔ, mɛ pé yɛ̃́nkyɔ tɛ̃ tɛ̃ mnɔlɛ n wu. ");
INSERT INTO wib_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","À mɛ de krótónè nɔ́pi núkú sɔkɔ, nɛ̂-á sõ̀ Simɔ tyɩ́lɛ. Tɛ́ kè yah kɔ̃ ǹ tyɩ́ nɛ, à yal kélɛ yɔ vyãh tyɩ́, à de yuku yɔ sɔkɔ kwéyy. Képah-á pɩ, à kɔ̃ tɛ̃ krótókè sɔkɔ, à yɔ̃ sɔkɔ tɔ́wûlɛ n kwɔ. ");
INSERT INTO wib_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Wǎh wɛkɩ tɛ gbĩ́ nɛ̂nɛ, à yo Simɔ tyɩ́ nɛ, à de yuku yahlɛ yɔ tì tɛ̃̀-ǹsah. Pè mó pé mnɔ min dah mɔ yɔ sɔkɔ, pè yɛ̃́nkyɔ tɛ̃. ");
INSERT INTO wib_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simɔ mɛ à syah nɛ, pé yõ̀tɛ̃̀, pépi-á tõ̀ pɩ sõ, tɛ́ pé náh kwâh yɔ́ ńtɛ̃ wɛ tɛ̃. Ǹtɛ, ǹmɔ yóré yõ, páh kɩ mnɔ min dah mɔ. ");
INSERT INTO wib_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Képah sɔkɔ, pè mɛ pé mnɔ min dah mɔ yɔ sɔkɔ, tɛ́ yɛ̃́nkyɔ wɛ tɛ̃ tnɔ́nɔ́lɛ fɔ́ɔ́, pé mnɔ tyah n kɔ̃lɩ. ");
INSERT INTO wib_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Pè mɛ pɩ mɔ pé no tyɩ́, nónó-á sõ̀ mɛ krótókè ní-ò sɔkɔ nɛ, pè pɔ pé yohnɩ mɔ. Pè mɛ pɔ pè yohnɩ mɔ, pè yɛ̃́nkyɔ wilki mɔ krótónè nínì nɔ́pi yĩ́ĩ́nɛ fɔ́ɔ́, sè n tyah tíkíndenɔlɛ ni sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simɔ Pyɛrɩ-á képah wɛ sɛ̃́, à ǹ gbètukunɔ di Yesu yah, tɛ́ nɛ, pé Yõ̀tɛ̃̀, tyípékè pɩ́-ò-á pélɛ. Képah yĩnnɛ, à gbɛ mɔ péwɔlɛ. ");
INSERT INTO wib_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Pǎh yɛ̃́nkyɔ nɔ́pi wɛ tɛ̃ pípí sɛ̃́, tíkí mɛ Simɔ ànɛ̂ pé no pól kah tɛ̃, ");
INSERT INTO wib_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","à tahlɩ Sebede dĩ́npì tyɩ́, Nsyakɩ ànɛ̂ Nsyɔ̃nɛ, pépi nónó-á sõ̀ Simɔ tõ̀ pɩ mûnɛ. Képah tɛ̃̀nɛ, Yesu mɛ yo Simɔ tyɩ́: «Káh tíkí pɩ! À tɔkɔ núkúnúkú tyɩ́, á kɩ pɩ névye yénpɔ-òlɛ Liyel tyɩ́.» ");
INSERT INTO wib_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Képah náh, pè wil pɔ krótónè sah kènkwã̀h yõ ànɛ̂ pé vyɔ́ póllɛ, tɛ́ mɛ Yesu sõ̀ tɛ̃. ");
INSERT INTO wib_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Sṍ yɔ́lɛ, Yesu sõ̀ mɛ kwil yɔ́ sɔkɔ, tɛ́ dĩ́ yɔ́ tɔ sõ̀ mɛ nɛ́npɔ́, dú ńyânnɛ ǹ wil pól sɔkɔ. Wǎh Yesu wɛ sɛ̃́, à kɔ kwĩnki, ǹ yah di sétáh Yesu yah, tɛ́ à ni nɛ, pé Yõ̀tɛ̃̀, wàh mɛ ké tyɩ́, wǎh kɩ fɛ̃ pé dɛ mɔ. ");
INSERT INTO wib_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Wǎh yo sɛ̃́, Yesu núkú ǹ gbõ̀ nɔ, à tũ ǹ tyɩ́, tɛ́ nɛ: «Mé mɛ ké tyɩ́, á kɩ dɛ!» Nɛ́npɔ́ swɔ, dĩ́ núkú dɛ. ");
INSERT INTO wib_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Képah sɔkɔ, Yesu kè gbah yo ǹ tyɩ́ nɛ, à káh yĩ mɛ̀ yãh nɛy tyɩ́ póllɛ. Tɛ́ à kyɩ ǹ gblɔ̌ynɛ sárká wìlkìpu yõ̀tɛ̃̀ wɛ̃kɩ. Moyisi-á sõ̀ sárká nɛ̂ tyɩ́ yo sah tótãm dɛ́nmɔnɔ tyɩ́ sɔkɔ, à mó kè pɩ n tũ. Képah-á kɩ ǹ dɛ́nmɔnɔlɛ pè wɛ̃kɩ. ");
INSERT INTO wib_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Képah fyé yõ, wãn sõ̀ mɛ n dohnɩ Yesu yĩn wìlnɔ́ yõ, tɛ́ nɛ́kwĩ́nkí sõ̀ mɛ n tuke n mɔ ǹ wɛy noh yĩn, ànɛ̂ pé yamnɔ mɔ́ndɛnmɔ yĩnnɛ. ");
INSERT INTO wib_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Tɛ́ Yesu wɔ sõ̀ ńkɛ̃́nɛ n gbɛ n mɔ n tɛ̃ ǹ gblɔ̌y gbɛ̃́nnɩ sɔkɔ, ǹ Liyellɛ n ni. ");
INSERT INTO wib_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Sṍ yɔ́lɛ ńtɔ̃, Yesu sõ̀ mɛ kwɔ́nɔ́lɛ n pɩ, tɛ́ Farisiyɛ̃nɔ ànɛ̂ Liyel ǹgbò wɛ̃̀kɩ̀ kwɔ́pú tɔ sõ̀ mɛ kɔ̃́ntɛ̃̀nɔ́lɛ nɛ́npɔ́. Pè wil Kalile ànɛ̂ Yude kwlo pól sɔkɔ, ànɛ̂ Yerusalɛmɩ tɔ sɔkɔ. Tɛ́ Tɛ̃̀ ǹgbɛ̃ Liyel tǎhkɩ̀ sõ̀ mɛ Yesu sɔkɔ. Képah ye à kɔ̃, à yámpúlɛ n dɛ n mɔ. ");
INSERT INTO wib_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Légbĩ́nɛ, nósyɔ́ sèkùkù dĩ́ yɔ́ twah pɔ ǹ sɛ̃ sɛ̃ kwâh yõ, mɛ n yah n kɔ̃ nɛ, pé de ǹnɛ wɔ̀kɔ̀, pé kyɩ à tiki sah Yesu yah. ");
INSERT INTO wib_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Tɛ́ névye tnɔ́nkàhnɔ́ tɛ̃̀ tyɩ́, pè dé-ńsah yah kwlɔ. Kǎh pɩ sɛ̃́, pè dɔkɔ gbɛ̃́ntĩ̂n yõ kye, à sèkùkù mɛ̀ tiki mɔ ànɛ̂ ǹ sɛ̃ sɛ̃ kwâh tɔlɛ, névye nɩyṍ Yesu yah. ");
INSERT INTO wib_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesu-á wɛ pè sɛ̃ ǹ yõ sɛ̃́, à mɛ yo sèkùkù mɛ̀ tyɩ́: «Dĩ́, á tyípêl ye yɔ̃ mɔ ǹ kɔ̃.» ");
INSERT INTO wib_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Képah tɛ̃̀ sɔkɔ, Liyel ǹgbò wɛ̃̀kɩ̀ kwɔ́pú ànɛ̂ Farisiyɛ̃nɔ tyah n sõ nɛ, nɛ̂ tɛ̃̀ ó se dĩ́ mɛ̀nɛ, tɛ́ à Liyel yĩnnɛ n yɩkɩ sɛ̃́ nɩ? Nɛ̂ se kɩ fɛ̃ tyípêl yɔ̃ mɔ névi kɔ̃, nɛ́ Liyel ó náh nɩ? ");
INSERT INTO wib_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ǹtɛ, Yesu-á pé fɔ́kɔ́sɔ̃nɔ pɩ̃ sɛ̃́, à pé syah nɛ: «Kwâh nɛ̂ pɩ, tɛ́ yé n sõ sɛ̃́? ");
INSERT INTO wib_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Nɛ̂ tɛ̃̀ dɔ̀dɔ̀ kal, à yo sèkùkù mɛ̀ tyɩ́ nɛ, ǹ tyípêl-á yɔ̃ mɔ à kɔ̃, képah náh pɩ, à yo ǹ tyɩ́ nɛ, à yuku nɛ n kɔ? ");
INSERT INTO wib_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ǹtɛ, mé mɛ ké tyɩ́ nɛ, yé pɩ̃ nɛ, tɛ̃́nwɛnɔ-á mɛ Névi Pi tyɩ́ sétáh yõ, kɩ fɛ̃ névi tyípêl yɔ̃ mɔ à kɔ̃», tɛ́ ǹ syɩ yo sèkùkù mɛ̀ tyɩ́: «Mé kélɛ n yo á tyɩ́: yuku, á sɛ̃ sɛ̃ kwâh tɔkɔ, ǹ nɛ n yuku á gbô!» ");
INSERT INTO wib_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Nɛ́npɔ́ swɔ, dĩ́ núkú yuku no pól yĩ́ yah, à sɛ̃ sɛ̃ kwâh tɔkɔ, à sɔkɔ ǹ gbô, mɛ Liyel yĩnnɛ n gbilki n yuku. ");
INSERT INTO wib_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Képah tɛ̃̀ sɔkɔ, no pól gbã̀n du. Pè Liyel yĩnnɛ n gbilki tíkí tɛ̃̀ tyɩ́, mɛ yo tũ nɛ, kwɛynɛ, páh tyi snɔ́ wɛ dɛ́! ");
INSERT INTO wib_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Képah náh, Yesu wil nɛ́npɔ́, tɛ́ mɔ́rɩ́ syí-ò Levi wɛ kɔ̃́ntɛ̃̀nɔ́lɛ mɔ́rɩ́ syí-ńsah wɔ̀kɔ̀ sɔkɔ. À yo ǹ tyɩ́ nɛ: «Ń sõ̀ tɛ̃!» ");
INSERT INTO wib_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Levi núkú ǹ tõ̀ sah, tɛ́ yuku ǹ sõ̀ tɛ̃. ");
INSERT INTO wib_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Képah tɛ̃̀nɛ, Levi yõke ǹgbɛ̃ pɩ ǹ gbô Yesu yĩnnɛ, tɛ́ mɔ́rɩ́ syípú náhnáh ànɛ̂ nɛ́káhbɩ́ kwĩ́nkí sõ̀ mɛ pélɛ kénɛ yõke yṍ-ńsah. ");
INSERT INTO wib_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Képah sɔkɔ, Farisiyɛ̃nɔ ànɛ̂ pé Liyel ǹgbò wɛ̃̀kɩ̀ kwɔ́pú sõ̀ mɛ lékàhlɛ Yesulɛ n kɔ̃ mɛ n yo ǹ tõ̀ sã́hpú tyɩ́ nɛ, kwâh nɛ̂ se, tɛ́ pè n yõ tɛ́ n wɔ mɔ́rɩ́ syípú ànɛ̂ Liyel wɛ̃̀kɩ̀ kɔ́-ńkɛ̃̂púlɛ wɛ̃ tyɩ́ nɩ? ");
INSERT INTO wib_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Képah tɛ̃̀nɛ, Yesu yo pé tyɩ́ nɛ: «Névye nónó-á mɛ lènɔlɛ, sènpɩ yétõ̂ se mɛ pé tyɩ́? Yámpú tyɩ́ náh sènpɩ yétõ̂lɛ di? ");
INSERT INTO wib_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Névye nónó-á n sõ nɛ, nɛ́gblɔ́-á pélɛ Liyel yah, mé náh pɔ pépi ye yĩnnɛ. Ǹtɛ, nónó-á pɩ̃ nɛ, tyípêl pɩ́pú-á pélɛ, pépi yé-ńsah ye mé pɔ nɛ, pè Liyel wɛ̃̀kɩ̀ tɛ̃.» ");
INSERT INTO wib_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Képah náh, Farisiyɛ̃nɔ yo ǹ tyɩ́ nɛ, Nsyɔ̃ tõ̀ sã́hpú ànɛ̂ pépi tõ̀ sã́hpú-á ńkɛ̃́nɛ níkìlɛ n tɛ̃, ǹ tɛ́ nírílɛ n pɩ. Ǹtɛ, ǹmɔ tyɩ́nɔ tɛ̃̀ wɔ ninɛ n wɔ, tɛ́ yõkelɛ n yõ kɛ̀. ");
INSERT INTO wib_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Wǎh képah noh sɛ̃́, à mɛ yo pé tyɩ́: «Fúr pɩ́-ò-á nónó ye ǹ fúr yõke yõ yĩnnɛ, yépi se kɩ fɛ̃ pè kɔ̃ pè kɩ níkì tɛ̃ pé yé-ò yĩ́ yah? ");
INSERT INTO wib_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ǹtɛ, sṍ yɔ́ mɛ n pi, pɛ mɛ̀ kɩ pɔ n wilki n pi pé wrɔ́. Légbĩ́nɛ, pè kɩ pyě níkìlɛ n tɛ̃.» ");
INSERT INTO wib_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Képah náh, Yesu mɛ tɔ̃ sèmìrkì yɔ́ mɩ pé tyɩ́ nɛ ńkɛ̃́: «Névi yɔ́ ńtɛ̃ náh fwɔ̀sãn kãm, à fwɔ̀dyàh min n pi. Wâh képah pɩ, fwɔ̀sãn kɩ yɩkɩ, ké gbó mɛ̀ tɔ náh se tɔ̃ fwɔ̀dyàh syi n pi. ");
INSERT INTO wib_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ànɛ̂ tɔ̃, névi yɔ́ ńtɛ̃ náh dìvɛ̃ sã́n mɔ n pi pley dî sɔkɔ. Wâh képah pɩ, dìvɛ̃ sã́n mɛ̀-à fũ, kè kɩ pley nɔ́pi tɔkɩ, dìvɛ̃ kɩ kwɛ, pley kɩ yɩkɩ. ");
INSERT INTO wib_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Kàh pɩ dìvɛ̃ sã́nnɛ, kè yɩ̃nɛ kè mɔ pley snɔ́. ");
INSERT INTO wib_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Névi nɛ̂-á dar dìvɛ̃ kònɔ́ wɔ́nɔ́lɛ, à náh tɔ̃ n fɛ̃ n syi ké kò-ǹkɛ̃̂nɛ n wɔ. Tɛ̃̀ n nɛ n yo nɛ, dìvɛ̃ kònɔ́-á nɔ kal.» ");
INSERT INTO wib_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Képah náh, Nsyifunɔ mɩ mɩ yòh sṍ yɔ́lɛ, Yesu sõ̀ mɛ wɛ̃̀kɩ̀ tɛ̃ n kɔ n kah sèmukɔ swɛ̃y yísyɔ́ sɔkɔ. Tɛ́ ǹ tõ̀ sã́hpú mɛ sèmukɔ ywɔ̃lɛ n kɔ̃lɩ n wɔkɔlɩ pé gbã̀n sɔkɔ, à n tah. ");
INSERT INTO wib_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Farisiyɛ̃nɔ-á képah wɛ sɛ̃́, pé túkù mɛ nɛ, tõ̀ pɩ́nɔ́ wɛ̃̀kɩ̀ náh mɛ kɔ̃́nɔ́lɛ mɩ mɩ yòh sṍlɛ. Tɛ́ kwâh nɛ̂ se, tɛ́ pè kélɛ n pɩ nɩ? ");
INSERT INTO wib_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Képah sɔkɔ, Yesu yo pé tyɩ́: «Kwɛkɩ-á lésõ yõ̀tɛ̃̀ Davidi ànɛ̂ ǹ náh névye tɛ̃ sṍ nɛ̂nɛ, wǎh nɛ̂ pɩ, yé náh kè kar yah kɛ̀? ");
INSERT INTO wib_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","À náh sõ̀ de Liyel wɔ̀kɔ̀ sɔkɔ, à búrn tɔkɔ, nónó-á sõ̀ mɛ sàhnɔ́lɛ Liyel tyɩ́ yõ, à tah, tɛ́ ǹ náh névye tɔ kɔ̃ di? Tɛ́ nɛy náh sõ̀ yɩ̃nɛ búrn nɔ́pi táhnɔ́lɛ, nɛ́ sárká wìlkìpu yõ̀tãm ó náh.» ");
INSERT INTO wib_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Tɛ́ tɔ̃ yo pé tyɩ́: «Névi Pilɛ, mɩ mɩ yòh yõ̀tɛ̃̀ ye ǹnɛ.» ");
INSERT INTO wib_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Képah náh, mɩ mɩ yòh sṍ yɔ́lɛ ńtɔ̃, Yesu de Liyel ní-ńsah wɔ̀kɔ̀ sɔkɔ, mɛ tyah névyelɛ n kwɔ. Tɛ́ dĩ́ yɔ́ sõ̀ mɛ nɛ́npɔ́ sɔkɔ, gbõ̀yõ̀lɛ kúnɔ́lɛ. ");
INSERT INTO wib_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Képah tɛ̃̀nɛ, Liyel ǹgbò wɛ̃̀kɩ̀ kwɔ́pú, ànɛ̂ Farisiyɛ̃nɔ mó mɛ Yesulɛ n kyɔmɩ n yah, wàh kɩ ńtyɩ̃́nɔ nɛy dɛ n mɔ n pi mɩ mɩ yòh sṍlɛ, pè mó lékàh wɛ à kɔ̃. ");
INSERT INTO wib_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ǹtɛ, ǹmɔ tɛ̃̀ wɔ sõ̀ mɛ pé fɔ́kɔ́sɔ̃nɔlɛ n pnɛ. Kǎh pɩ sɛ̃́, à mɛ yo gbõ̀nkù dĩ́ mɛ̀ tyɩ́: «Yuku n pɔ n yĩn névye nɩyṍ ásõ̂.» Dĩ́ mɛ yuku yĩn. ");
INSERT INTO wib_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Képah tɛ̃̀nɛ, Yesu yo pé tyɩ́: «Ńmɔ yélɛ n piki n yah, tir nɛ̂ pɩ́nɔ́ wɛ̃̀kɩ̀ mɛ kɔ̃́nɔ́lɛ mɩ mɩ yòh sṍlɛ? Pèpɔrɩ se, tĩ̂ pèkè se? À nɛy min pwah mɔ, tĩ̂ à tɛ̃̀ ko mɔ?» ");
INSERT INTO wib_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Képah sɔkɔ, wǎh pè yah kore vi, à yo dĩ́ tyɩ́: «Á gbõ̀ tɔ̃!» À mɛ ǹ gbõ̀ tɔ̃, kè núkú pɩ ké vilɛ. ");
INSERT INTO wib_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Képah tɛ̃̀nɛ, pé fɔkɔ kah vyãh Yesulɛ, pè tyah wɛ̃nɛ n vi n mɔ, sɔ̃́-á pè kɩ n pɩ n pi ǹnɛ. ");
INSERT INTO wib_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Sṍ yɔ́lɛ, Yesu dɔkɔ yuku yɔ̃lɩ yɔ́ yõ, à kyɩ nírílɛ n pɩ. À lékã̂h pól pɩ Liyel nínɔ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Tyah-á pɔ dal, à ǹ tõ̀ sã́hpú ye, tɛ́ nɛ́pĩ̂ gbɔ̃nimí yah wilki pé sɔkɔ, tɛ́ pépi yĩn sah ǹ tɛ̃̀ntõbelɛ. ");
INSERT INTO wib_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Wǎh nónó yah wilki, pé yni wɛ yɔ̀: Simɔ wɔlɛ, Yesu ǹmɔ yĩn sah Pyɛrɩlɛ, tɛ́ ǹ gbɛ̃̀ndĩ́ Andre sõ̀ mɛ, ànɛ̂ Nsyakɩ, ànɛ̂ Nsyɔ̃, ànɛ̂ Filipi, ànɛ̂ Bartelemi, ");
INSERT INTO wib_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ànɛ̂ Matye, ànɛ̂ Toma. À tahlɩ Alfe pídĩ́ Nsyakɩ tyɩ́, ànɛ̂ Simɔ nɛ̂-á sõ̀ pè n ye «Sú fṍ vyãh syí-òlɛ», ");
INSERT INTO wib_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ànɛ̂ Nsyakɩ pídĩ́ Yudelɛ, ànɛ̂ Yisikariyɔtɩ Yudasɩlɛ, nɛ̂-á pɔ vi Yesu náh. ");
INSERT INTO wib_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Képah náh, Yesu tiki yɔ̃lɩ yõ ànɛ̂ pélɛ, à pɔ yĩn kéntáhkɩ̀ támm yɔ́ sɔkɔ. Tɛ́ ǹ tõ̀ sã́hpú náhnáh sõ̀ mɛ, à tahlɩ tɔ́wû ǹgbɛ̃ yɔ́ tɔ tyɩ́, nónó-á wil Yude tã̀ntã̀n pól sɔkɔ, ànɛ̂ Yerusalɛmɩ, à tahlɩ pnɛ yɔ gbɔ̀pɔ kwlo tyɩ́, Tiri ànɛ̂ Sidõnɛ. ");
INSERT INTO wib_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Pè sõ̀ pɔ Yesu wɛlɔ nóh-ńsah, ànɛ̂ dɛ́nmɔnɔ wɛ yĩnnɛ pé yamnɔ sɔkɔ. Sétã̀n-á sõ̀ mɛ nónó sɔkɔ mɛ pélɛ n kwlɔ, pé tɔ dɛ́nmɔnɔ wɛ. ");
INSERT INTO wib_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Tɛ́ tǎhkɩ̀ yɔ́ sõ̀ mɛ n wil ǹ sɔkɔ, à pé póllɛ n dɛ n mɔ. Képah ye tɔ́wû pól kɔ̃, pè n yah n kɔ̃ wɛ́ntũ̀-ǹsahlɛ ǹ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Képah sɔkɔ, Yesu mɛ ǹ yah yɔ̃ ǹ tõ̀ sã́hpú yah, tɛ́ nɛ: «Yèvɩnɩ mɛ yé tyɩ́, yépi nónó-á mɛ yãm sɔkɔ. Liyel tɔ̃́rɩ́ mɛ yépi tyɩ́ yõ. ");
INSERT INTO wib_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Yèvɩnɩ mɛ yé tyɩ́, yépi nónó-á mɛ núkúnúkú kwɛkɩ sɔkɔ. Yé kɩ pɔ n tɔ̃ n pi. Yèvɩnɩ mɛ yé tyɩ́, yépi nónó-á mɛ núkúnúkú gbní sɔkɔ. Yé kɩ pɔ yɩ̀ syɔ n pi. ");
INSERT INTO wib_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Yèvɩnɩ mɛ yé tyɩ́, no-à yé dyɔlɛ n yɔ, tɛ́ yé milki, tɛ́ yélɛ n gbyɔ, tɛ́ yé yĩnnɛ n yɩkɩ Névi Pi yõ sɛ̃́nɔ́ yĩnnɛ. ");
INSERT INTO wib_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ǹtɛ, ké yõre ǹgbɛ̃ kɩ pɔ yé dyah Liyel fṍ. Képah ye, yé nɛ n mɛ nɩ̀vɩ̀ sɔkɔ lésõlɛ, yé nɛ n yɔkɔ n kwãh nɩ̀vɩ̀ tɛ̃̀ tyɩ́. Sɛ̃́ ye lésõ pé náh tãn tɔ n fõh Liyel tɛ̃ntõ̀ syínyopulɛ. ");
INSERT INTO wib_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ǹtɛ, yépi nónó-á tahbɩlɛ, yèvyãhrɩ mɛ yé yõ. Yé yé pèpɔrɩ wɛ sɔkɔ tɛ. ");
INSERT INTO wib_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Yépi nónó-á mɛ núkúnúkú tɛ̃kɩ sɔkɔ, yèvyãhrɩ mɛ yé yõ. Kwɛkɩ kɩ pɔ yé tɛ̃ n pi. Yépi nónó-á mɛ núkúnúkú yɩ̀syɔ̀nɩ̀ sɔkɔ, yèvyãhrɩ mɛ yé yõ. Yé kɩ pɔ yèkwɔrɩ gbní gbo n pi. ");
INSERT INTO wib_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Pàh yépi nónónɛ n gbilki, yèvyãhrɩ mɛ yé yõ. Sɛ̃́ ye lésõ pé náh tãn tɔ n gbilki Liyel yĩn yõ mɩ̀nyobelɛ.» ");
INSERT INTO wib_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","«Ǹtɛ, yépi nónó-á mɛ n nohnɩ ń tyɩ́, mé kélɛ n yo yé tyɩ́ nɛ: yé yé sépɛ́bɩ́lɛ n tɛ̃ plɛ. Yé pèpɔrɩlɛ n pɩ yé dyɔ yɔ́pú tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Nónó-á plɔlɛ n ye n mɔ yé yõ, yé sãmnɛ n mɔ pé sɔkɔ. Yé mó Liyellɛ n ni yé fṍhpú tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Névi-à á létáh núkú mɩ, ké ní-ò tɔ vi n mɔ à kɔ̃. Névi-à á fwɔ̀mɔ̀-ǹgbɛ̃ tɔkɔ, yɛ tɛ̃̀ kɔ̃ à á fwɔ̀mɔ̀npir tɔ tɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Névi nɛ̂-à kwâh ni á tyɩ́, kè yɩ̃ tɛ̃̀ kɔ̃. Ànɛ̂, névi-à á gbõ̀ kwâh tɔkɔ, káh nɛ, tɛ̃̀ n syɩ n pɔ kélɛ. ");
INSERT INTO wib_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ànɛ̂ tɔ̃, yáh mɛ ké tyɩ́ nɛ, no nɛ̂nɛ n pɩ yé tyɩ́, yépi tɔ sɛ̃́nkɔ̃lɛ n pɩ pé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Yépi tyɩ́-á nɔ nónó tyɩ́, pépi ó tyɩ́-à nɔ yé tyɩ́, yĩ́ngbɩ́ nɛ̂ mɛ yé kɩ n wɛ n pi képah sɔkɔ? Liyel wɛ̃̀kɩ̀ kɔ́-ńkɛ̃̂pú ńtɛ̃ tɔ nɛ́nɔ́nɔ́ tyɩ́ náh nɔ pé tyɩ́ di? ");
INSERT INTO wib_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Nónó-á n tɔ̃ n sah n pɩ yé tyɩ́, yé tɔ-à n tɔ̃ n sah n pɩ pépi ó tyɩ́, yĩ́ngbɩ́ nɛ̂ mɛ yé kɩ n wɛ n pi képah sɔkɔ? Liyel wɛ̃̀kɩ̀ kɔ́-ńkɛ̃̂pú ńtɛ̃ tɔ náh sɛ̃́nkɔ̃lɛ n pɩ di? ");
INSERT INTO wib_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ànɛ̂, yâh n dɛkɩ névyelɛ n kɔ̃, yáh sɛ̃ ké yõ nɛ, nónó ó-á kɩ pɔ sé lédyáhnɩ́nɛ yé kɔ̃ n pi, yĩ́ngbɩ́ nɛ̂ mɛ yé kɩ n wɛ n pi képah sɔkɔ? Liyel wɛ̃̀kɩ̀ kɔ́-ńkɛ̃̂pú tɔ náh n dɛkɩ wɛ̃nɛ n kɔ̃, sé lédyáhnɩ́ pɔ́nwɛ yĩnnɛ di? ");
INSERT INTO wib_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Pèpɔrɩ pɩ̃́-ńkɛ̃̂pú, ànɛ̂ nɛ́pêl nɩ̀gbɛ̀kɩ̀ mɛ Liyel sɔkɔ. Képah ye, yépi tɔ yé sépɛ́bɩ́lɛ n tɛ̃ plɛ. Yé pèpɔrɩlɛ n pɩ pé tyɩ́. Yé nɛ n dɛkɩ n kɔ̃, ké lédyáhnɩ́ tyɩ́ sõ̀-ǹkɛ̃̂nɛ. Képah sɔkɔ, yé kɩ kyɩ ké lédyáhnɩ́ ǹgbɛ̃ wɛ Liyel fṍ, tɛ́ kɩ pɩ yõ̀tah Liyel wɛ̃́npìlɛ. ");
INSERT INTO wib_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Yé pɩ nɩ̀gbɛ̀kɩ̀ névyelɛ, sɔ̃́-á yé sú Liyellɛ nɩ̀gbɛ̀kɩ̀ pɩ́-òlɛ.» ");
INSERT INTO wib_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Képah sɔkɔ, Yesu tɔ̃ yo pé tyɩ́: «Yé káh nolɛ n tuke. Képah sɔkɔ, Liyel náh yé tɔ tuke n pi. Yé káh lékàhlɛ nolɛ n kɔ̃. Képah sɔkɔ, Liyel náh lékàhlɛ yé tɔ kɔ̃ n pi. Ǹtɛ, yé nɛ n yɔ̃ n mɔ nolɛ n kɔ̃. Képah sɔkɔ, Liyel kɩ n yɔ̃ n mɔ yé tɔlɛ n kɔ̃. ");
INSERT INTO wib_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Yáh no tɛ́lɔ́ tyɩ́lɛ n sãh dú nɛ̂nɛ, kénɛ dú núkú ó kɩ yé tɔ tyɩ́ sãh n pi. Képah ye, yé nɛ n yɩ̃ n kɔ̃. Képah sɔkɔ, Liyel kɩ yɩ̃ yé tɔ kɔ̃. À kɩ dú tɔkɔ, kɩ sã́hnɔ́ pèpɛy sãh, kɩ sni, kɩ yike yike, kè kɩ yuku kwɛ, kɩ vi mɔ yé kɔ̃ yé fwɔ̀mɔlɔ vyɛ̃y tɛ̃́nkũnmɔnɔ sɔkɔ.» ");
INSERT INTO wib_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Tɛ́ tɔ̃ sèmìrkì yɔ́ mɩ pé tyɩ́ nɛ ńkɛ̃́: «Yɩ̃́tũ̂ se kɩ fɛ̃ pɩ ǹ ní-ò yɩ̃́tũ̂ yah tɛ̃́-òlɛ? Pé nímí náh n syɩkɩ n de n pi pwã̀h yɔ́ sɔkɔ di? ");
INSERT INTO wib_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Tir sã́h-ò náh n kal n pnɛ ǹ kwɔ́-òlɛ. Tɛ́ sã́h-ò nɛ̂-à kwɔ́nɔ́ wɛ yĩ́ĩ́, ǹmɔ n pɩ ǹ kwɔ́-ò tyɩ́ kɔ̃lɛ. ");
INSERT INTO wib_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Á pɩ sɔ̃́, tɛ́ ǹdan kyɔmɩ wɛ á yṹnpi yĩ́ sɔkɔ, tɛ́ dàhnpɛlɛ áwɔ yĩ́ sɔkɔ, á náh mɛ képah wɔ wɛ? ");
INSERT INTO wib_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Á kɩ pɩ sɔ̃́, tɛ́ kɩ yo á yṹnpi tyɩ́ nɛ, à yɛ á ǹdan wilki à kɔ̃ ǹ yĩ́ sɔkɔ, áwɔ nɛ̂-á dàhnpɛlɛ á yĩ́ sɔkɔ, tɛ́ á náh mɛ képah wɔ wɛ? Vɩ̃́nnínì wɛ́kɩ́-ò! Á yĩ́ sɔkɔ dàhnpɛ ǹgbò wilki! Képah-à pɩ, á kɩ fɛ̃ n yah pallɛ, kɩ á ní-ò yĩ́ sɔkɔ ǹdan wilki.» ");
INSERT INTO wib_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«Séswɔ̂ pèpɛy yɔ́ ńtɛ̃ náh n syi pye túkúnìnɛ. Séswɔ̂ túkù tɔ náh mó n syi pye pèplɔlɛ. ");
INSERT INTO wib_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Sésân pól n pnɛ sé pye sɔkɔ. Sènsóké pye náh fɛ̃ n wɛ kahrɩ sɔkɔ. Yrɛnsɛ̃ náh mó tɔ̃ fɛ̃ n wɛ n gbɛ gbɩ́yɛ̃́kɩ̀ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Nɛ́pépɛ̌y yípéplɔ n wil ǹ nɩ sɔkɔ, wǎh nónó koh sah. Sɛ̃́ ó ye, nɛ́túkù tɔ tyítúkúnì n wil ǹ nɩ sɔkɔ, wǎh nónó koh sah. Névi nɩ-à yuku tir nɛ̂nɛ, képah ye n wil ǹ vyãh.» ");
INSERT INTO wib_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Képah sɔkɔ, Yesu tɔ̃ yo pé tyɩ́: «Sɔ̃́ pɩ, tɛ́ yě ńnɛ n ye ‹Tɛ̃̀ ǹgbɛ̃, Tɛ̃̀ ǹgbɛ̃nɛ›, tɛ́ mâh se nɛ̂ yo, yé náh képahlɛ n pɩ? ");
INSERT INTO wib_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Névi nɛ̂-à pɔ ńmɔ tyɩ́, tɛ́ ń wɛlɔ noh, tɛ́ mɛ sélɛ n pɩ, tɛ̃̀-á mɛ nɛ̂ kètɔ̀lɛ, mé kɩ ǹ tyɩ́ yo yé syah: ");
INSERT INTO wib_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","À mɛ, á kɩ nɛ wɔ̀kɔ̀ mɔ́-ò yɔ́ sɔ̃́, nɛ̂-á swɔ tũ tiki náhnáh, tɛ́ wɔ̀kɔ̀ sõ légbɩ̃́ yõ. Tɛ́ ké sõ tyàhnɔ́-á sõ̀ plɛ sɛ̃́, képah ye, yɔ-á pɔ yuku, tɛ́ kwɔ, kè fwo kyɩ syɩ kénɛ wɔ̀kɔ̀ tyɩ́, tɛ́ kè náh tɛ̃ wɛ kè fɛ̃. ");
INSERT INTO wib_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Tɛ́, névi nɛ̂-à ń wɛlɔ noh, tɛ́ à náh sélɛ n pɩ, tɛ̃̀ wɔ mɛ, á kɩ nɛ wɔ̀kɔ̀ mɔ́-ò yɔ́ sɔ̃́, nɛ̂-á wɔ̀kɔ̀ yɔ̃ sɔkɔ mɔ sétáh kɔ́kɔ́ yõ swɔ tũ̀-ǹkɛ̃̂nɛ. Yɔ-á pɔ yuku, à fwo kyɩ syɩ kénɛ wɔ̀kɔ̀ tyɩ́, nɛ́npɔ́ swɔ, ké pól pirki kwɛ, à núkú mukuli pnɛ́pnɛ́.» ");
INSERT INTO wib_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Képah sɔkɔ, Yesu-á wɛlɔ nɔ́pi pól yo pɔ tyɛ no tyɩ́, à de Kapɛrnayumi. ");
INSERT INTO wib_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Tɛ́ nɛ́npɔ́ sɔkɔ, tõ̀npɩ yɔ́ sõ̀ mɛ sràsyíbí yõ̀tɛ̃̀ dĩ́ yɔ́ tyɩ́. Á sõ̀ mɛ n yɔ képékèyɔ̂, mɛ n tyah kúnɔ́lɛ. Tɛ́ ǹ tyɩ́ sõ̀ tah yĩ́ĩ́ ǹ yõ̀tɛ̃̀ dĩ́ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Wǎh Yesu tyɩ́ noh, à mɛ Nsyifunɔ yèwàhnɩ̀ yísyɔ́ tɛkɩ mɔ nɛ, pè kyɩ à ni, à pɔ pé tõ̀npɩ dɛ mɔ. ");
INSERT INTO wib_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Pǎh kyɩ yĩni tɛ̃ Yesu tnɔ̂, pè tyah ǹnɛ n gbah n ni, mɛ n yo ǹ tyɩ́ nɛ, pépi Nsyifunɔ tyɩ́-á kah nɔ yõ̀tɛ̃̀ dĩ́ mɛ̀ tyɩ́. Ànɛ̂, ǹmɔ-á tɔ̃ yĩn pé Liyel ní-ńsah wɔ̀kɔ̀ mɔ́nɔ́lɛ. Képah-á, wǎh yɩ̃nɛ yòhnɩ̀nmɔnɔ mɛ̀ pɩ́nɔ́lɛ ǹ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Képah sɔkɔ, Yesu mɛ sɔkɔ pélɛ. Wǎh de n tɛ sràsyíbí yõ̀tɛ̃̀ dĩ́ mɛ̀ kételɛ, kénɛ dĩ́ tɔ̃ ǹ kódíbí yísyɔ́ tõ nɛ ńkɛ̃́, pè pɔ yo Yesu tyɩ́ nɛ, pé Yõ̀tɛ̃̀, péwɔ náh yɩ̃nɛ ǹ dénɔ́lɛ pé kéte sɔkɔ. Képah-á, à káh ǹ gblɔ̌y kwlɔ pɔ. ");
INSERT INTO wib_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ńkɛ̃́, képah tɔ-á pé kɔ̃ pé kè yah nɛ, pé náh yɩ̃nɛ pɔ́nwìlnɔ́lɛ ǹ tyɩ́ pé gblɔ̌y. Ǹtɛ, à wɛy núkú ó yo, pé tõ̀npɩ-á kɩ dɛ. ");
INSERT INTO wib_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ńkɛ̃́, péwɔ ńtɛ̃ tɔ tyɩ́ yõ̀tãm-á mɛ, péwɔ tɔ mó mɛ sràsyíbí yísyɔ́ yõ. Pâh yo nɛ̂ tyɩ́: «Sɔkɔ!», tɛ̃̀ n sɔkɔ. Pâh yo nɛ̂ tyɩ́: «Pɔ!», tɛ̃̀ n pɔ. Ànɛ̂, pâh yo pé tõ̀npɩ tyɩ́: «Tir mɛ̀ pɩ!», ǎ kè pɩ. ");
INSERT INTO wib_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Képah sɔkɔ, Yesu-á kénɛ wɛlɔ noh sɛ̃́, à dĩ́ mɛ̀ sõ kègbɩlɛ. Tɛ́ ǹ yah vi yo ǹ sõ̀ tɛ̃́pú tɔ́wû tyɩ́ nɛ: «Mé kélɛ n yo yé tyɩ́ nɛ: Yisrayel ńtɛ̃ sɔkɔ, mé náh sɛ̃́nkɔ̃ Liyel yõ sɛ̃́nɔ́ névi wɛ yah.» ");
INSERT INTO wib_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Képah sɔkɔ, tɛ̃ntõ̀ névye-á pé syɩ kyɩ sràsyíbí yõ̀tɛ̃̀ kéte, pè kyɩ nɛ n yah, ǹ tõ̀npɩ mɛ̀ dɛ. ");
INSERT INTO wib_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Sṍ yɔ́lɛ, Yesu mɛ n yuku kwil yɔ́ sɔkɔ, nɛ̂-á pè n ye Nayinnɛ. Tɛ́ ǹ tõ̀ sã́hpú, ànɛ̂ tɔ́wû ǹgbɛ̃ sõ̀ mɛ ǹ sõ̀ tɛ̃. ");
INSERT INTO wib_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Wǎh yĩni tɛ̃ kwil dé-ńsahlɛ yúkɛy, à nósyɔ́ yohnɩ, pè mɛ lékó yɔ́ twah n yuku yɩ̃́-ńsah. Pɛ́kúsè yɔ́ pídĩ́ ye sõ̀, ǹ gblɔ̌y núkúnínɛ ǹ yṹ tyɩ́. Tɛ́, kénɛ kwil névye sõ̀ mɛ wil náhnáh, mɛ pi mɛ̀ sõ̀ tɛ̃. ");
INSERT INTO wib_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Tɛ̃̀ ǹgbɛ̃ Yesu-á pi mɛ̀ wɛ sɛ̃́, ǹ yãm à kah tɛ̃, à mɛ yo ǹ tyɩ́: «Káh n tɔ̃ nɛ n gbo!» ");
INSERT INTO wib_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Tɛ́ mɛ nɔ de, à tũ lékó twáhkɩ̀ tyɩ́, ké twáhpú núkú yĩn. Yesu mɛ yo nɛ: «Dĩ́npir, mé kélɛ n yo á tyɩ́: yuku!» ");
INSERT INTO wib_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Wǎh yo sɛ̃́, à núkú yuku kɔ̃ tɛ̃, tɛ́ tyah n yãh. Yesu mɛ ǹnɛ ǹ yṹ gbõ̀ dahbɩ. ");
INSERT INTO wib_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Képah tɛ̃̀nɛ, tíkí no pól tɛ̃. Pè tyah Liyellɛ n gbilki, mɛ yo tũ nɛ, Liyel tɛ̃ntõ̀ syínyo-ò ǹgbɛ̃ yɔ́-á wil mɔ pé wrɔ́. Ànɛ̂, Liyel-á yah dah mɔ ǹ no tyɩ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Képah sɔkɔ, Yesu tyípɩ́nɔ́ tyɩ́ yónɔ́ tɔ̃ mɔ Yude tã̀ntã̀n pól sɔkɔ, à kyɩ sɔkɔ ké gbɔ̀plɔ kwlo tɔ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Képah sɔkɔ, Nsyɔ̃ tõ̀ sã́hpú tyi nɔ́pi pól yãh Nsyɔ̃ tyɩ́. À mɛ pé sɔkɔ nɛ́pĩ̂ nímí ye, ");
INSERT INTO wib_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","à tõ Tɛ̃̀ ǹgbɛ̃ Yesu tyɩ́. Ńkɛ̃́, pè kyɩ à piki yah nɛ, ǹmɔ se Liyel nɛy tɛ́kɩ́nmɔnɔlɛ, nɛ̂-á kɩ sõ̀ n pɔ n pi, tĩ̂ pé se yɩ̃nɛ pé ǹnɩ̂nɛ n syɩkɩ nɩ? ");
INSERT INTO wib_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Pǎh pɔ yĩni tɛ̃ Yesu tnɔ̂, pè yo ǹ tyɩ́ nɛ, Wèlnwìlkì-ò Nsyɔ̃-á pépi tɛkɩ mɔ ǹ tyɩ́ nɛ, pé pɔ à piki yah nɛ ńkɛ̃́, ǹmɔ se Liyel nɛy tɛ́kɩ́nmɔnɔlɛ, nɛ̂-á kɩ sõ̀ n pɔ n pi, tĩ̂ pé se yɩ̃nɛ pé ǹnɩ̂nɛ n syɩkɩ nɩ? ");
INSERT INTO wib_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Légbĩ́nɛ, Yesu mɛ yámpú náhnáhlɛ n dɛ n mɔ pé yamnɔ, ànɛ̂ pé yèvyãhrɩnɔ sɔkɔ. À sétã̀n yĩni wilki pé sɔkɔ, tɛ́ yɩ̃́tũbi náhnáh yɩ̃́ yɩkɩ mɔ. ");
INSERT INTO wib_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Tɛ́ mɛ yo Nsyɔ̃ tɛ̃ntõ̀ névye tyɩ́: «Yáh nɛ̂ wɛ, tɛ́ nɛ̂ noh, yé kyɩ kè yãh Nsyɔ̃ tyɩ́: Yɩ̃́tũbi yɩ̃́ mɛ n yɩkɩ n mɔ, sèkukubi mɛ n kɔ tómtóm, tótãm mɛ n dɛ, níkítũbi mɛ n nohnɩ, lékyɩ̂ mɛ n yilki n mɔ, ànɛ̂ nɩ̀vɩ̀nɩ̀ wɛy sã́n mɛ n yo n kɔ̃ yãm tãn tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ǹtɛ, nɛ̂-á Liyel yõ sɛ̃́nɔ́ yáhle-ńkɛ̃̂nɛ ńmɔ yĩnnɛ, yèvɩnɩ mɛ tɛ̃̀ tyɩ́.» ");
INSERT INTO wib_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Képah sɔkɔ, Nsyɔ̃ tɛ̃ntõ̀ névye-á sɔkɔ tɛ, Yesu tyah ǹ tyɩ́lɛ n yãh tɔ́wû tyɩ́ mɛ n yo: «Kwâh nɛ̂ mɛ yé kyɩ yah gbɛ̃́nnɩ sɔkɔ? Fílkì yɔ́ se yã́hkɩ́ mɛ n fĩ n kɔ̃? ");
INSERT INTO wib_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Tĩ̂ kwâh nɛ̂ mɛ yé kyɩ yah wɛ? Dĩ́ yɔ́ se, nɛ̂-á mɛ fwɔ̀pèplɔ mɔ? Tɛ́ nónó-á mó tɔ̃ fwɔ̀tǎhnɩ̀nɛ n mɔ, tɛ́ tɔ̃́rɩ́ yélɛ n yõ, pépi náh mɛ yõ̀tãm fnɛ́ sɔkɔ di? ");
INSERT INTO wib_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ǹtɛ, kwâh nɛ̂ mɛ yé kyɩ yah wɛ? Liyel tɛ̃ntõ̀ syínyo-ò yɔ́lɛ nɩ? Mé kélɛ n yo yé tyɩ́ nɛ: sɛ̃́-á. Tɛ́ ǹmɔ ńtɛ̃-á kal Liyel tɛ̃ntõ̀ syínyo-òlɛ. ");
INSERT INTO wib_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ńkɛ̃́, ǹmɔ tyɩ́ sɔkɔ-á kè wãrkɩ sah nɛ ńkɛ̃́: ‹Yáh, ńmɔ Liyel kɩ ń tɛ̃ntõ̀ yó-ò tɛkɩ mɔ á yahlɛ, à kɩ pɔ á wɛ̃̀kɩ̀ tɔ̃ sah.› ");
INSERT INTO wib_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Mé kélɛ n yo yé tyɩ́ nɛ: sê fɔkɔ táh pi yɔ́ ńtɛ̃ náh mɛ nɛ̂-á kal Nsyɔ̃nɛ. Ǹtɛ, nɛ̂-á tyɩ̃́ɩ̃ kal Liyel yõ̀tɔ̃rɩ́ sɔkɔ, ǹmɔ ńtɛ̃ gblò kal ǹnɛ. ");
INSERT INTO wib_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Képah sɔkɔ, nónó pól-á sõ̀ mɛ n nohnɩ ǹ tyɩ́, à tahlɩ mɔ́rɩ́ syípú tɔlɛ, pé pól nɛ, Liyel-á mɛ tómm, tɛ́ Nsyɔ̃ kɔ̃, à pè wel wilki. ");
INSERT INTO wib_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ǹtɛ, Liyel-á nɛ̂ yah kɔ̃ Farisiyɛ̃nɔ ànɛ̂ Liyel ǹgbò wɛ̃̀kɩ̀ kwɔ́pú tyɩ́, pè pé náh vi kè kɔ̃, tɛ́ yahle pé wèlnwìlkìnɔ́lɛ Nsyɔ̃ tyɩ́.» ");
INSERT INTO wib_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Tɛ́ Yesu tɔ̃ nɛ: «Nɛ̂ tɛ̃̀ mɛ mé kɩ tɔkɔ sãh kwɛy gbĩ névyelɛ? Nɛ̂ tɛ̃̀ mɛ pè tɔ? ");
INSERT INTO wib_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Pè mɛ, á kɩ nɛ wɛ̃́npì sɔ̃́ kɔ̃ tɛ̃ n syah tɔ́wû tùkè-ǹsah sɔkɔ, tɛ́ mɛ n yo wɛ̃ tyɩ́ nɛ, pépi-á yɩkɩ fɩ̃bɩ pé tyɩ́, tɛ́ pé náh se yi. Pé tɔ̃ kũ yɩ̀kɩ̀ gbɩ mɔ, pè náh se tɔ̃ gbo. ");
INSERT INTO wib_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ǹtɛ, Wèlnwìlkì-ò Nsyɔ̃ pɔ, à náh mɛ n yõ, à náh mɛ dìvɛ̃nɛ n wɔ, tɛ́ yé nɛ, ǹ yõ̀gbèkè náh mɛ. ");
INSERT INTO wib_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Névi Pi-á se pɔ, à n yõ tɛ́ n wɔ, yé tɔ̃ nɛ, pè yah yèwònpɩ, ànɛ̂ sètɛ̃-á ǹnɛ, mɔ́rɩ́ syípú ànɛ̂ tyípêl pɩ́pú kódĩ́-á. ");
INSERT INTO wib_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ǹtɛ, Liyel lékã́m tyilɛ, gbɩ ye sélɛ sé fɛ̃̀nsyipu tyɩ́.» ");
INSERT INTO wib_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Farisiyɛ̃ dĩ́ yɔ́ sõ̀ mɛ, pè n ye Simɔlɛ. Sṍ yɔ́lɛ, à Yesu ye nɛ, à pɔ yõke yõ pé tyɩ́. À mɛ kyɩ de kénɛ dĩ́ gbô, à tɛ̃ yõke yah. ");
INSERT INTO wib_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Tɛ́ kénɛ kwil sɔkɔ, tyípêl pɩ́-ò pi yɔ́ sõ̀ mɛ. Wǎh noh nɛ, Yesu-á mɛ yõkelɛ n yõ Farisiyɛ̃ dĩ́ gbô, à pɔ nɩrɩ pãn pènɛ̀kɩ̀ yɔ́lɛ, so pèpɛy yɔ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Tɛ́ mɛ vi Yesu náh tĩ̀nnɛ, à n gbo ǹ yétĩnɛ n kwɛ Yesu gbyẽ̂h yõ, tɛ́ sélɛ n kele ǹ yõ̀yénnɛ, tɛ́ sè pɔrɩ tɛ̃, tɛ́ nɩrɩ mɛ̀nɛ n mɔ sé yõ. ");
INSERT INTO wib_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Farisiyɛ̃ dĩ́ nɛ̂-á ye Yesulɛ, ǹmɔ-á képah wɛ sɛ̃́, à tyah n sõ ǹ fɔkɔ sɔkɔ nɛ, dĩ́ mɛ̀-à sõ̀ mɛ Liyel tɛ̃ntõ̀ syínyo-òlɛ, pi nɛ̂-á n tũ ǹ tyɩ́ yɔ̀, wǎh náhkɩ ǹ dùkù pɩ̃ nɛ ńkɛ̃́, tyípêl pɩ́-ò ǹgbɛ̃-á ǹnɛ. ");
INSERT INTO wib_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesu mɛ wɛy tɔkɔ, tɛ́ yo Simɔ tyɩ́ nɛ, tir yɔ́-á mɛ pé tyɩ́ yo yo tɛ̃̀nɛ ǹ tyɩ́. Simɔ mɛ nɛ, à kè yo, kwɔ́-ò dĩ́. ");
INSERT INTO wib_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Képah sɔkɔ, à mɛ yo ǹ tyɩ́: «Kmɔ mɔ́-ò yɔ́ kmɔ sõ̀ mɛ nɛ́pĩ̂ nímí yísyɔ́ yõ. Núkú sõ̀ yɩ̃nɛ à à dyah pɔ́ plɔ́ kyɛkwɛ́lɛ, ní-ò mɛ yɩ̃nɛ à à dyah plɔ́ tikiníní pɔ́ gbãmnɛ. ");
INSERT INTO wib_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ǹtɛ, pé sɔkɔ nɛy yɔ́ ńtɛ̃ náh sõ̀ mɛ fɛ̃ ǹ tyɩ́ dyah n pi sɛ̃́, dĩ́ pé nímí tyɩ́ yɔ̃ mɔ pè kɔ̃. Kǎh pɩ sɛ̃́, ǹ tyɩ́ kɩ nɔ kal nɛ̂ tɛ̃̀ tyɩ́ pépi nímí sɔkɔ?» ");
INSERT INTO wib_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simɔ mɛ à syah nɛ, péwɔ tɛ̃̀ sõnɔ sɔkɔ, nɛ̂ kɔ̃lɩ-á kal, ǹmɔ-á. Yesu mɛ nɛ, gbɩ-á à yo. ");
INSERT INTO wib_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Képah sɔkɔ, tɛ́ ǹ yah vi pi tĩ̀nnɛ, tɛ́ yo Simɔ tyɩ́: «Á pi mɛ̀ wɛ kɛ̀? Ńmɔ-á de á gbô, á náh gbyẽ̂h wu wu ninɛ ń kɔ̃. Ǹtɛ ǹmɔ wɔ ǹ yétĩ kwɛ ń gbyẽ̂h yõ, tɛ́ sè kele ǹ yõ̀yénnɛ. ");
INSERT INTO wib_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Áwɔ náh ń pɔrɩ tɛ̃. Ǹtɛ, ǹmɔ tɛ̃̀nɛ, wǎh de pɔ sɔ̃́, à náh mɛ yal mɔ ǹ gbyẽ̂h pɔ́rɩ́ntɛ̃nɔlɛ. ");
INSERT INTO wib_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Á náh mó tɔ̃ nɩrɩ mɔ ń yõ, ǹtɛ ǹmɔ tɛ̃̀ wɔ nɩrɩ pãn pènɛ̀kɩ̀ mɔ ń gbyẽ̂h yõ. ");
INSERT INTO wib_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Mé kélɛ n yo á tyɩ́ nɛ: pi mɛ̀ tyípêl náhnáh nɔ́pi pól-á yɔ̃ mɔ à kɔ̃. Képah ye, à tyɩ́nɔnɔ ǹgbɛ̃ tir mɛ̀ pɩ. Ǹtɛ, yɔ̃̀nmɔnɔ-à pɩ nɛ̂ tyɩ́ kwéyy, ǹmɔ tyɩ́nɔnɔ n mó nɛ kwéyy.» ");
INSERT INTO wib_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Tɛ́ tɔ̃ ǹ syɩ yo pi mɛ̀ tyɩ́: «Á tyípêl ye yɔ̃ mɔ ǹ kɔ̃.» ");
INSERT INTO wib_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Képah sɔkɔ, wǎh sõ̀ mɛ n yõ ànɛ̂ nónónɛ, pè tyah n sõ pé fɔkɔnɩ sɔkɔ nɛ, nɛ́dúkú nɛ̂ se dĩ́ mɛ̀nɛ, tɛ́ à kɩ pɔ tyípêl tɔlɛ n yɔ̃ mɔ nɩ? ");
INSERT INTO wib_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Kǎh pɩ sɛ̃́, Yesu mɛ yo pi tyɩ́: «Ńmɔ yõ sɛ̃́nɔ́ ye ǹ pwah mɔ. Nɛ n yuku yèvɩnɩ sɔkɔ.» ");
INSERT INTO wib_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Kénɛ tyi sɔ́kɔ́ntɛnɔ náh, Yesu sõ̀ mɛ n kɔ n kɔ̃ kwíl-ǹgbnɔ ànɛ̂ kwílpî, mɛ nɩ̀vɩ̀nɩ̀ wɛy sã́nnɛ n yo Liyel yõ̀tɔ̃rɩ́ tyɩ́ sɔkɔ. Tɛ́ ǹ tõ̀ sã́hpú nɛ́pĩ̂ gbɔ̃nimí sõ̀ mɛ ǹnɛ, ");
INSERT INTO wib_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ànɛ̂ syɔ́ yísyɔ́ tɔlɛ, wǎh sétã̀n yĩni wilki nónó sɔkɔ, tɛ́ pé yamnɔ tyɛ. Makadala kwil Mari sõ̀ mɛ, nɛ̂ sɔkɔ-á sétã̀n kwǎrninɔ wil, ");
INSERT INTO wib_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ànɛ̂ Nsyannɛ, nɛ̂-á Yerɔdɩ tahrɩ kyɔ̀mɩ̀-ò dĩ́ Kusa kyɩlɛ, ànɛ̂ Susanɩnɛ, ànɛ̂ syɔ́ náhnáh yísyɔ́lɛ, nónó-á sõ̀ pé gbã̀n yîlɛ Yesu ànɛ̂ ǹ tõ̀ sã́hpúlɛ n yohnɩ n mɔ. ");
INSERT INTO wib_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Képah sɔkɔ, névye sõ̀ mɛ wil kwlo kwlo pól sɔkɔ, à n pɔ n pɔ Yesu tyɩ́. Tɔ́wû ǹgbɛ̃-á pɔ tuke mɔ sɛ̃́, à mɛ sèmìrkì yɔ́ yãh pé tyɩ́ nɛ: ");
INSERT INTO wib_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Sṍ yɔ́lɛ, sètõ yɔ́ lésõ wil ǹ sèmukɔlɛ n mir. Wǎh mɛ mírnɔ́ sɔkɔ, yísyɔ́ syɩkɩlɩ wɛ̃̀gbalɩ sɔkɔ. Wɛ̃̀kɔbɩ kɔ sɔkɔ sé yõ, kèpye mɛ pɔ sè yɔ. ");
INSERT INTO wib_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Yísyɔ́ mɛ syɩkɩlɩ légbɩ̃́ yõ, à fi, tɛ́ núkú tɔ̃ kɔkɔ vɩ́nɔ́ kɛ̃́ tɛ̃̀ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Yísyɔ́ mɛ syɩkɩlɩ de pã̀n nɩyṍ. Sǎh fi wɛ̃ tyɩ́ pã̀nnɛ, pã̀n mɛ fyãh sé yõ. ");
INSERT INTO wib_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ǹtɛ, yísyɔ́ mɛ syɩkɩlɩ sétáh pèpɛy sɔkɔ, à fi. Sépi wɔ kyãh, à pɔ pyenɔ lèkwɛ̌kwɛ pɩ.» Sèmìrkì mɛ yã́hntɛnɔ náh, Yesu tɔ̃ yo pé tyɩ́ yĩ́npɔ̃́ ǹgbɛ̃nɛ nɛ ńkɛ̃́: «Níkí-à mɛ nɛ̂ tyɩ́ noh noh tɛ̃̀nɛ, tɛ̃̀ ǹ níkí sah noh.» ");
INSERT INTO wib_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Képah sɔkɔ, Yesu tõ̀ sã́hpú à piki yah sèmìrkì mɛ̀ yõlɛ. ");
INSERT INTO wib_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","À mɛ yo pé tyɩ́: «Liyel tɔ̃́rɩ́ tyi nónó-á mɛ wɔ̃̀bɩ̀nɔ́lɛ, sé pnɛ̀nɔ́ ye yépi tɛ̃̀ wɔ kɔ̃. Ǹtɛ, tɛ́lɔ́ tɛ̃̀ tyɩ́, sèmìrn ó sɔkɔ ye sè kɩ n yãh. Képah sɔkɔ, pè kɩ n yah díkídíkí, tɛ́ pè náh kwâh yɔ́ wɛ n pi. Tɛ́ kɩ n nohnɩ, tɛ́ pè náh ké yõ pɩ̃ n pi.» ");
INSERT INTO wib_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Tɛ́ tɔ̃ yo pé tyɩ́: «Sèmìrkì mɛ̀ yõ-á nɛ̂nɛ, kè wɛ yɔ̀: Mir mir sèmukɔ mɛ̀nɛ, Liyel wɛy ye. ");
INSERT INTO wib_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Tɛ́ névye túkù mɛ wɛ̃̀gbalɩ tyɩ́ kɔ̃lɩ: Pépi-à Liyel wɛy noh, sétõ n pɔ kè wilki pé nnɔ sɔkɔ nɛ, pè káh pɔ sɛ̃ ké yõ, pè mó pwáhnmɔnɔ wɛ. ");
INSERT INTO wib_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Túkù mɛ légbɩ̃́ yõ tyɩ́ kɔ̃lɩ: Pépi-à Liyel wɛy noh, pě kè fɛ̃ n syi nɩ̀vɩ̀lɛ. Tɛ́ pè náh n yɛ kè yã̀hnɩ̀nɛ n mɔ pé sɔkɔ. Pě kè fɛ̃ n syi nɛ́npɔ́ swɔ ó sɔkɔ, tɛ́ mɔ́nyahnɔ-à núkú pè yĩni tɛ̃, pě pé náh vi kè kɔ̃. ");
INSERT INTO wib_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Túkù mɛ pã̀n mɛ́-ńsah tyɩ́ kɔ̃lɩ: Pépi-à Liyel wɛy noh, fɔ́kɔ́sɔ̃nɔ, ànɛ̂ tahrɩ yáhnɔ́, ànɛ̂ kèkõyṍ nɩ̀vɩ̀ tyi n pɔ kè fyãh. Kàh pɩ sɛ̃́, pè n wũ nɩyṍ, kè náh tirlɛ n pɛkɩ pé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ǹtɛ, túkù mɛ sétáh pèpɛy tyɩ́ kɔ̃lɩ: Pépi-à Liyel wɛy noh, pě kè syi n sah pallɛ nɩ pèpɛy sɔkɔ, nɛ̂-á mɛ tɔ̃́nsàhnɔ́lɛ. Ǹ tɛ́ ké tɛ̃́nɔ́ plɛ, yõre n wɛ ké tyɩ́, sèmukɔ pɛ́kɩ́nɔ́ tyɩ́ kɔ̃lɛ.» ");
INSERT INTO wib_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yesu tɔ̃ yo pé tyɩ́: «Névi se kɩ fɔ̀tnɔ̀ soh, tɛ́ kɩ dú kwĩnki mɔ ké yah, képah náh pɩ, kɩ kè dah mɔ sɛ̃ sɛ̃ kwâh sètàhkɩ̀ sõ̀? Tɛ̃̀ náh kè sah n pi fɔ̀tnɔ̀ sahkɩ sɔkɔ, kè n pɩ n pi kyòolɛ wɔ̀kɔ̀ sɔkɔ dépú tyɩ́ di? ");
INSERT INTO wib_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Tir yɔ́ ńtɛ̃ náh mɛ wɔ̃̀bɩ̀nɔ́lɛ, tɛ́ kɩ n wũ n pi wìlkìnmɔ-ńkɛ̃̂nɛ kégbɔ́. Sètĩ̀n sõ̀ tir yɔ́ ńtɛ̃ náh n wũ n pi pɩ̃́-ńkɛ̃̂nɛ, ànɛ̂ wìlkìnmɔ-ńkɛ̃̂nɛ kwèyy. ");
INSERT INTO wib_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Névi nɛ̂ tyɩ́ kwâh-á mɛ, dòhnɩ̀nɔ́ kɩ n pɩ ǹmɔ tyɩ́ yõ. Tɛ́ névi nɛ̂ tyɩ́ kwâh náh mɛ, kwéy nɛ̂ ńtɛ̃-á à mɛ n sõ nɛ, páh mɛ wɛ, ké tɔ kɩ tɛ̃ syi ǹ tyɩ́. Kǎh pɩ sɛ̃́, yé kyɔ̀mɩ̀nɔ́lɛ n pɩ yé nohnɩ dùkù sɔkɔ!» ");
INSERT INTO wib_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Képah sɔkɔ, Yesu-á sõ̀ mɛ fɩ̃́ nɛ̂ sɔkɔ, ǹ yṹnpyé, ànɛ̂ ǹ yṹ pɔ yĩni tɛ̃ nɛ́npɔ́. Ǹtɛ tɔ́wû tɛ̃̀ tyɩ́, pè náh tɛ̃ wɛ nɔ de ǹnɛ. ");
INSERT INTO wib_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Pè mɛ yo mɔ ǹ tyɩ́ nɛ, ǹ yṹ, ànɛ̂ ǹ yṹnpyé-á mɛ yĩ́nnɔ́lɛ kégbɔ́. Pǎh mɛ ké tyɩ́ nɛ, pé à wɛ. ");
INSERT INTO wib_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Képah tɛ̃̀nɛ, à mɛ yo pé tyɩ́: «Nónó-á Liyel wɛynɛ n nohnɩ tɛ́ ké tyilɛ n pɩ, pépi ye ńmɔ yṹ ànɛ̂ ń yṹnpyélɛ.» ");
INSERT INTO wib_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Sṍ yɔ́lɛ, Yesu de krótókè yɔ́ sɔkɔ ànɛ̂ ǹ tõ̀ sã́hpúlɛ, tɛ́ yo pé tyɩ́ nɛ, pè yɛ pé yuku yɔ́-ǹgbɛ̃ kahnɩnɛ. ");
INSERT INTO wib_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Tɛ́ pǎh mɛ krótókèlɛ n to n yuku gbĩ́ nɛ̂nɛ, Yesu dɔ. Dǒ, yã́hpékè yɔ́ kõ pé yõ yɔ sɔkɔ, à ninɛ n tɔkɔ n mɔ krótókè sɔkɔ, kè syi pɔ n yuku ninɛ, dlo n tyah pé nɔ́nɔ́lɛ. ");
INSERT INTO wib_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Pè mɛ nɔ de Yesu tnɔ̂, mɛ ǹnɛ n yilki n mɔ nɛ, pé yõ̀tɛ̃̀, pé yõ̀tɛ̃̀! Yɔ-á mɛ n tyah pé yṍnɔ́lɛ dɛ́! Képah tɛ̃̀nɛ, Yesu mɛ yuku, tɛ́ dírí kõ yã́hkɩ́, ànɛ̂ ni yõ. Yã́hkɩ́ mɛ yĩn, yɔ tiki tɛ̃, tyah pɩ sṹmm. ");
INSERT INTO wib_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Kǎh pɩ sɛ̃́, à yo pé tyɩ́: «Yé Liyel yõ sɛ̃́nɔ́ ńyãh?» Tíkí tɛ̃̀ tyɩ́, pé gbã̀n du, pè tyah n yo wɛ̃ tyɩ́ nɛ, nɛ́dúkú nɛ̂ se dĩ́ mɛ̀nɛ, tɛ́ à fɛ̃ n yo yã́hkɩ́ ànɛ̂ ni ńtɛ̃ tɔ tyɩ́, sè n sah ǹ tyɩ́ yõ nɩ? ");
INSERT INTO wib_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yesu ànɛ̂ ǹ tõ̀ sã́hpú kyɩ yĩni tɛ̃ yɔ́-ǹgbɛ̃ kahnɩnɛ, Yerasɛnɩ sétáh yõ, Kalile yèsreynɛ. ");
INSERT INTO wib_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Wǎh mɛ n tiki krótókè sɔkɔ gbĩ́ nɛ̂nɛ, dĩ́ yɔ́ wil kwil sɔkɔ, à pɔ à yohnɩ, sétã̀nnɛ ǹ sɔkɔ. Kwil mɛ̀ nɛy ye sõ̀ ǹnɛ. Tɛ́ kè pɩ di mónɔ́lɛ, à náh tɔ̃ sõ̀ mɛ flɔlɛ n mɔ, ànɛ̂ à náh mɛ n tɛ̃ gbô. Ǹ tɛ̃̀-ǹsah ye sõ̀ léyã̂l wrɔ́. ");
INSERT INTO wib_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Tɛ́, sétõ mɛ̀ sõ̀ n yuku dĩ́ mɛ̀ yõ gbáhyɩ̃́ náhnáhlɛ. Pè sõ̀ ńkɛ̃́nɛ à pukubi kɛ̃́lɔ́, ànɛ̂ kârnnɛ nɛ, pé à tɛ̃ sah. Ǹtɛ, ǎ púkúbí-ńtã̂n nɔ́pi kɔ̃lɩ, tɛ́ sétõ mɛ̀ à tɔkɔ n de gbɛ̃́nnɩ tã̀ntã̀n sɔkɔ. Képah sɔkɔ, wǎh Yesu wɛ, Yesu mɛ yo ǹ tyɩ́ nɛ, à wil dĩ́ mɛ̀ sɔkɔ. Wǎh yo sɛ̃́, dĩ́ pɔ kɔ kwĩnki ǹ yah, tɛ́ de syi yĩ́npɔ̃́ ǹgbɛ̃nɛ nɛ, kwâh nɛ̂ se à n yah n kɔ̃ pé tyɩ́ nɩ, yõ̀tah Liyel pi Yesu? Páh ǹnɛ n ni, à káh pé fõh. ");
INSERT INTO wib_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesu mɛ à piki yah nɛ, ǹ yĩn se sɔ̃́ nɩ? Tɛ́ kǎh pɩ, sétã̀n náhnáh sõ̀ mɛ dénɔ́lɛ ǹ sɔkɔ, à mɛ nɛ, pé yĩn-á Mɛ́fwóbé Kwĩnkilɛ. ");
INSERT INTO wib_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Képah sɔkɔ, sétã̀n nɔ́pi mɛ Yesu ni nɛ, à káh sé yĩni wilki tɛkɩ mɔ yèvyãhrɩ tɛ̃̀-ǹsah. ");
INSERT INTO wib_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Tɛ́ nɛ́npɔ́ sɔkɔ, sel kwĩnki yísyɔ́ sõ̀ mɛ n yah n yõ n kɔ̃ yɔ̃lɩ yõ. Sétã̀n nɔ́pi tɔ̃ Yesu ni nɛ, à yɛ sé kɔ̃ sé kyɩ de sel nɔ́pi sɔkɔ. À mɛ ké wɛ̃̀kɩ̀lɛ sè kɔ̃. ");
INSERT INTO wib_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Képah tɛ̃̀ sɔkɔ, sétã̀n nɔ́pi wil dĩ́ mɛ̀ sɔkɔ tɛ́ kyɩ de sel nɔ́pi sɔkɔ. Sel kwĩnki nɔ́pi núkú kènpĩn to tiki tùkùtùkù, à kyɩ de yɔ́npɛ̃́kɩ̀ sɔkɔ, kè kɔ̃ kè sè yõ. ");
INSERT INTO wib_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Sel nɔ́pi fɛ̃̀pu-á képah wɛ sɛ̃́, pè to kyɩ kè yãh kwil, ànɛ̂ yèpìyey sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Képah tɛ̃̀nɛ, tyi nónó-á pɩ, névye wil nɛ, pé kyɩ sé ségblɔ́ yah. Pè pɔ yĩni tɛ̃ Yesu tnɔ̂, tɛ́ dĩ́ nɛ̂-á sõ̀ sétã̀n wil ǹ sɔkɔ, pè à wɛ kɔ̃́ntɛ̃̀nɔ́lɛ Yesu tnɔ̂. À sõ̀ mɛ flɔ mɔ, tɛ́ mɛ tírr. Kǎh pɩ sɛ̃́, tíkí pè tɛ̃. ");
INSERT INTO wib_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Képah sɔkɔ, nónó-á sõ̀ ǹ dɛ́nmɔ dùkù wɛ, pè kè yãh tɛ́lɔ́ syah. ");
INSERT INTO wib_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Kǎh pɩ sɛ̃́, tíkí tɛ̃̀ tyɩ́, Yerasɛnɩ sétáh yõ névye pól kè yah kɔ̃ Yesu tyɩ́ nɛ, à yal gbɛ mɔ pépilɛ. Képah sɔkɔ, Yesu mɛ de krótókè sɔkɔ, à n tyah sɔ́kɔ́nɔ́lɛ. ");
INSERT INTO wib_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Tɛ́ dĩ́ nɛ̂ sɔkɔ-á sõ̀ sétã̀n wil, kénɛ dĩ́ Yesulɛ n ni nɛ, à yɛ pé tɛ̃ ǹnɛ. Ǹtɛ, Yesu náh kè fɛ̃ syi, tɛ́ yo ǹ tyɩ́: ");
INSERT INTO wib_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«Liyel-á tyi nónó pól pɩ á tyɩ́, á syɩ n yuku á gbô, ǹ kyɩ sè yãh.» Wǎh yo sɛ̃́, dĩ́ mɛ ǹ syɩ yuku ǹ tĩ̀nnɛ. Tɛ́ tyi nónó pól-á Yesu pɩ ǹ tyɩ́, à sélɛ n yãh n kɔ̃ kwil pól sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Tɔ́wû sõ̀ mɛ Yesu syɩkɩ tɛ̃ sɛ̃́, képah ye, wǎh wil yɔ́-ǹgbɛ̃ kahnɩnɛ, à pɔ yĩni n tɛ̃ pé tnɔ̂ gbĩ́ nɛ̂nɛ, pé pól à yohnɩ nɩ̀vɩ̀ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Légbĩ́ mɛ̀ ó sɔkɔ ye dĩ́ yɔ́ pɔ yĩni tɛ̃, pè n ye Yayirusilɛ. Ǹmɔ ye sõ̀ nɛ́npɔ́ Liyel ní-ńsah wɔ̀kɔ̀ yah yétɛ̃̀nɛ. Wǎh yĩni tɛ̃ Yesu tnɔ̂, à gbètukunɔ di ǹ yah, tɛ́ à ni nɛ ńkɛ̃́, kékwɛ, à pɔ pé yuku péwɔ gbô, ");
INSERT INTO wib_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ńkɛ̃́, písê nɛ̂-á pé tyɩ́ ǹ gblɔ̌y núkúnínɛ, tɛ́ mɛ ye gbɔ̃ninɔ́ kénkɔ̃ sɔkɔ, wǎh mɛ n tyah kúnɔ́lɛ. Képah tɛ̃̀ sɔkɔ, Yesu-á n sɔkɔ nɛ́npɔ́, tɔ́wû à fyãh kã́mm yey yey póllɛ. ");
INSERT INTO wib_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Tɛ́, sê yɔ́ tɔ sõ̀ mɛ nɛ́npɔ́. À sõ̀ mɛ n yɔ tṍ kwɛ́nɔ́ ńyânnɛ pópó, ye gbɔ̃ninɔ́. Ǹ gbõ̀ pól syi pɔ tyɛ syɛy pɩ́nɔ́lɛ sènpɩbɩ tyɩ́, tɛ́ pé sɔkɔ yɔ́ ńtɛ̃ náh tɛ̃ wɛ à dɛ mɔ. ");
INSERT INTO wib_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","À mɛ nɔ de Yesulɛ ǹ náh tĩ̀nnɛ, tɛ́ tũ ǹ fwɔ̀mɔnɩ vyãh tyɩ́. Nɛ́npɔ́ swɔ, ǹ ńyân núkú tyɛ. ");
INSERT INTO wib_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Képah sɔkɔ, Yesu mɛ piki yah nɛ, nɛ̂ se tũ péwɔ tyɩ́ nɩ? No pól-á pé vyɛ̃ynɛ n kɔ̃lɩ nɛ, pépi náh sɛ̃́, Pyɛrɩ mɛ nɛ, pé yõ̀tɛ̃̀, névye-á fyãh sah ǹnɛ kã́mm. ");
INSERT INTO wib_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ǹtɛ, Yesu mɛ nɛ, ǹnɩ̂ yɔ́-á tũ pé tyɩ́. Páh kè pɩ̃ nɛ, tǎhkɩ̀ yɔ́-á wil pé sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Képah sɔkɔ, pi mɛ̀-á pɔ pɩ̃ nɛ, tir mɛ̀ náh tɔ̃ fɛ̃ n wɔ̃bɩ, à pɔ ǹ gbètukunɔ di Yesu yah wílsyahrɩ sɔkɔ. Tir nɛ̂ yĩn-á à tũ ǹ tyɩ́, tɛ́ kè yãh no pól yĩ́ yah, ànɛ̂ sɔ̃́-á à dɛ́nmɔnɔ wɛ nɛ́npɔ́ swɔ. ");
INSERT INTO wib_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Képah tɛ̃̀ sɔkɔ, Yesu mɛ yo ǹ tyɩ́: «Pi, á Liyel yõ sɛ̃́nɔ́ ye ǹ dɛ mɔ. Nɛ n yuku yèvɩnɩ sɔkɔ.» ");
INSERT INTO wib_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Gbĩ́ nɛ̂-á Yesu mɛ kénɛ wɛy yónɔ́ sɔkɔ, dĩ́ yɔ́ wil yõ̀tɛ̃̀ dĩ́ Yayirusi gbô, à pɔ yo Yayirusi tyɩ́ nɛ, ǹ písê-á yah kwlɔ, ńkɛ̃́, à káh fwɔ̌tɛ̃̀ kwɔ́-ò dĩ́ kwlɔ. ");
INSERT INTO wib_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ǹtɛ, Yesu-á képah noh, à mɛ yo Yayirusi tyɩ́ nɛ ńkɛ̃́: «Káh tíkí pɩ! Sɛ̃ ó sɛ̃ ké yõ, tɛ́ á písê kɩ ǹ min wɛ.» ");
INSERT INTO wib_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Tɛ́ pè mɛ sɔkɔ Yayirusi gbô. Pǎh kyɩ yĩni tɛ̃, à náh fɛ̃ syi nɛy de ǹnɛ, à wil Pyɛrɩ, ànɛ̂ Nsyɔ̃, ànɛ̂ Nsyakɩ, ànɛ̂ pípír sú, ànɛ̂ ǹ yṹ tyɩ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Légbĩ́nɛ, no pól sõ̀ mɛ pípír kũ pɔ̀lɛ n gbo mɛ yãm yãm tyilɛ n pɩ. Képah sɔkɔ, Yesu nɛ: «Yé káh nɛ n gbo! À náh ku, dɔy sɔkɔ ye ǹnɛ.» ");
INSERT INTO wib_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ǹtɛ, névye-á sõ̀ mɛ ǹ kúntɛnɔ pɩ̃ tɛ sɛ̃́, pè tyah kõlɛ Yesulɛ n ko. ");
INSERT INTO wib_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Képah tɛ̃̀ sɔkɔ, Yesu mɛ à tɛ̃ ǹ gbõ̀ tyɩ́, tɛ́ à kah ye: «Ń pi, yuku!» ");
INSERT INTO wib_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Nɛ́npɔ́ swɔ, ǹ min núkú ké syɩ de ǹ sɔkɔ à kɔ̃ à yuku. Wǎh yuku, Yesu mɛ kè yah kɔ̃ pé tyɩ́ nɛ, pè yãrlɛ à kɔ̃ à yõ. ");
INSERT INTO wib_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Kǎh pɩ sɛ̃́, ǹ dúbípú gbã̀n du, tɛ́ Yesu kè yah kɔ̃ pé tyɩ́ nɛ, pè káh tir mɛ̀ yãh nɛy tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Sṍ yɔ́lɛ, Yesu ǹ tõ̀ sã́hpú nɛ́pĩ̂ gbɔ̃nimí ye tuke mɔ, tɛ́ tǎhkɩ̀ ànɛ̂ tɛ̃́nwɛnɔlɛ pè kɔ̃ nɛ, pè sétã̀n póllɛ n yĩni, pè mó yámpúlɛ n dɛ n mɔ. ");
INSERT INTO wib_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Képah sɔkɔ, tɛ́ pè tɛkɩ mɔ nɛ, pè kyɩ Liyel tɔ̃́rɩ́ tyɩ́lɛ n yo n kɔ̃, pè mó yámpúlɛ n dɛ n mɔ. ");
INSERT INTO wib_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Tɛ́ tɔ̃ yo pé tyɩ́ nɛ, pè káh kwâh yɔ́ ńtɛ̃ tɔkɔ wɛ̃̀kɩ̀ kɔ yĩnnɛ. Pè káh ńsĩn tɔkɔ, pè káh pilki tɔkɔ, pè káh yõke tɔkɔ, pè káh pɔ́ tɔkɔ. Ànɛ̂ nɛy káh fwɔ̀mɔlɔ nínɔ́ tɔkɔ. Tɛ́ tɔ̃ nɛ: ");
INSERT INTO wib_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","«Yâh kyɩ wɛ twah kéte nɛ̂ sɔkɔ, yé tɛ̃ képah sɔkɔ fɔ́ɔ́, kè pɔ nɔ yé yal gbĩ́ tyɩ́ nɛ́npɔ́. ");
INSERT INTO wib_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Tɛ́, nónó-à kyɩ yahle nɛ, yé káh twah pé tyɩ́, yâh n wil kénɛ kwil sɔkɔ, yé yé gbyẽ̂h nɛ̀ngbɔ̃ kwer n kwɛ nɛ́npɔ́. Képah kɩ pɩ gbáhdyâh dínsàhnɔ́lɛ pé tyɩ́.» ");
INSERT INTO wib_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Képah tɛ̃̀nɛ, pè mɛ sɔkɔ, à kyɩ n kɔ n kɔ̃ kwlo kwlo sɔkɔ, à nɩ̀vɩ̀nɩ̀ wɛy sã́nnɛ n yo n kɔ̃, tɛ́ mɛ yámpúlɛ n dɛ n mɔ ywɔ̃ ywɔ̃ pól sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","8","Légbĩ́nɛ, Kalile kwil tãm yõ̀tɛ̃̀ ǹgbɛ̃nɛ, Yerɔdɩ ye sõ̀. Ǹmɔ-á Yesu tyípɩ́nɔ́ nɔ́pi pól noh gbĩ́ nɛ̂nɛ, túkù ńtɛ̃ mɛ n yo nɛ, Nsyɔ̃-á ǹ syɩ min wɛ, à wil lékyɩ̂ sɔkɔ. Túkù mó nɛ, ǹgbò Liyel tɛ̃ntõ̀ syínyo-ò Yeli-á pɔ wil mɔ. Túkù mó tɔ̃ nɛ, ǹgbò Liyel tɛ̃ntõ̀ syínyo-ò yɔ́-á yuku wil lékyɩ̂ sɔkɔ. Pǎh yo sɛ̃́ Yerɔdɩ tyɩ́, ǹ fɔkɔ fɛ̃kɩ. ");
INSERT INTO wib_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Képah sɔkɔ, à nɛ, tɛ́ páh se Nsyɔ̃ yõ kãm. Ǹtɛ, nɛ̂ tɛ̃̀ ó tyípɩ́nɔ́ se tɔ̃ pé n nohnɩ yɔ̀ nɩ? Kǎh pɩ sɛ̃́, à tyah Yesulɛ n yah n kɔ̃ nɛ, pé à wɛ. ");
INSERT INTO wib_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Yesu tɛ̃̀ntõbe-á pé syɩ pɔ ǹ tnɔ̂, pè pé tyípɩ́nɔ́ pól yãh à syah. À mɛ pè tɛ̃ yal pé yahlɛ, à yuku pélɛ kwil yɔ́ gbɔ̀pɔ, pè n ye Besayidalɛ. ");
INSERT INTO wib_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ǹtɛ, tɔ́wû-á pɔ pé sɔ́kɔ́nɔ́ pɩ̃ sɛ̃́, pè pé nyáh sõ kyɩ nɛ́kwĩ́nkílɛ. Képah sɔkɔ, Yesu pè tɛ̃ pallɛ, mɛ Liyel tɔ̃́rɩ́ tyɩ́lɛ n yãh pé tyɩ́, tɛ́ mɛ yámpúlɛ n dɛ n mɔ, nónó-á sõ̀ mɛ lènɔlɛ n yah n kɔ̃. ");
INSERT INTO wib_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ǹtɛ, gbĩ-á pɔ n yi, ǹ tõ̀ sã́hpú nɔ de ǹ tnɔ̂, tɛ́ mɛ yo ǹ tyɩ́ nɛ, ǹgbǒ gbɛ̃́nnɩ tyah sɔkɔ-á pélɛ ásõ̂ dɛ́! Ńkɛ̃́, wǎh náhkɩ tɔ́wû fĩn mɔ, pè kyɩ sɛ̃́-ńtã̂n ànɛ̂ yõke yah kɔ̃ gbɔ̀plɔ kwlo ànɛ̂ yèpìyey sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Képah sɔkɔ, Yesu yo pé tyɩ́: «Yépi yõke yah pè kɔ̃ pè yõ yé gblɔ̌y kɛ̀!» Pè mɛ à syah nɛ, búrn plɔ́ kwlɔ, ànɛ̂ yɛ̃́nkyɔ plɔ́ nínɔ́ ó-á mɛ pé tyɩ́ dɛ́! Tĩ̂, à se mɛ ké tyɩ́ nɛ, pépi kyɩ yõke dwe pɔ nɛ́kwĩ́nkí nɔ́pi pu nɩ? ");
INSERT INTO wib_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Tɛ́ díbí sõ̀ nɔ nɛ́pĩ̂ kèyõ nínɔ́ kyɛgbãm kénkɔ̃lɛ nɛ́npɔ́. Képah sɔkɔ, Yesu mɛ yo ǹ tõ̀ sã́hpú tyɩ́ nɛ, pè no kɔ̃ pè kɔ̃ tɛ̃ tĩ̀nkìnɔ́lɛ nɛ́pĩ̂ tikiníní pɔ́ gbãm gbãmnɛ. ");
INSERT INTO wib_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Pè kè pɩ, wǎh yo sɔ̃́, à no pól kɔ̃ pè kɔ̃ tɛ̃. ");
INSERT INTO wib_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Képah tɛ̃̀nɛ, Yesu mɛ búrn plɔ́ kwlɔ, ànɛ̂ yɛ̃́nkyɔ plɔ́ nínɔ́ nɔ́pi tɔkɔ, tɛ́ ǹ yah yɔ̃ yĩ̂nyõ, à Liyel ni sé yõ, tɛ́ sè kwɔkɩ, à ǹ tõ̀ sã́hpú kɔ̃ nɛ, pè syi tɔ́wû kɔ̃. ");
INSERT INTO wib_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Képah-á pɩ, no pól yõ tɔ̃. Tɛ́ pè pé yṍnkwlɔnɔ tuke mɔ, vyɔ́ gbɔ̃ninɔ́ yĩ́ĩ́nɛ. ");
INSERT INTO wib_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Sṍ yɔ́lɛ, Yesu sõ̀ mɛ ǹ gbɛ kyɩ tɛ̃ nírílɛ n pɩ, ǹ tõ̀ sã́hpúlɛ ǹ tnɔ̂. Képah sɔkɔ, à mɛ pè piki yah nɛ: «Névye tɛ̃̀ tyɩ́, nɛ̂ mɛ ńmɔlɛ?» ");
INSERT INTO wib_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Pè mɛ à syah nɛ, túkù-á nɛ, Wèlnwìlkì-ò Nsyɔ̃-á ǹnɛ. Túkù mɛ nɛ, Yeli-á ǹnɛ. Túkù mó nɛ, ǹgbò gbĩ Liyel tɛ̃ntõ̀ syínyo-ò lékó yílkínmɔnɔ-á. ");
INSERT INTO wib_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Pǎh yo sɛ̃́, à pè syah nɛ: «Tɛ́, yépi tɛ̃̀ tyɩ́, nɛ̂ mɛ ńmɔlɛ?» Képah tɛ̃̀nɛ, Pyɛrɩ mɛ nɛ ńkɛ̃́: «Krista yé álɛ, Liyel-á nɛ, páh kɩ nɛ̂ tɛkɩ mɔ.» ");
INSERT INTO wib_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Wǎh yo sɛ̃́, Yesu pè kah sni nɛ, pé káh kè yo nɛy syah, ");
INSERT INTO wib_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","tɛ́ tɔ̃ yɔ̃ sɔkɔ yo pé tyɩ́: «Névi Pi yɩ̃nɛ à yèvyãhrɩ pɩ náhnáh. Yèwàhnɩ̀, ànɛ̂ sárká wìlkìpu yõ̀tãm ǹgbnɔ, ànɛ̂ Liyel ǹgbò wɛ̃̀kɩ̀ kwɔ́pú kɩ à yahle n pi. À kɩ ko mɔ, tɛ́ ké sèpĩ̀n tɔ̃́-ò sṍlɛ, à kɩ ǹ syɩ min wɛ.» ");
INSERT INTO wib_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Képah náh, à yo no pól tyɩ́: «Névi nɛ̂-à mɛ ké tyɩ́ nɛ, pé ńmɔ sõ̀ tɛ̃, tɛ̃̀ ǹ gblɔ̌y dyɔ yĩ́ĩ́ tyi yɛ, sõmɛsṍ à mó nɛ mɛ ǹ syɩ syɩ dahnɩ twah, ń sõ̀ tɛ̃. ");
INSERT INTO wib_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Yah, névi nɛ̂-à nɛ ńkɛ̃́, páh n to n pwah kũ yah, tɛ̃̀ náh min wɛ n pi. Ǹtɛ, nɛ̂-à kũ fɛ̃ syi ńmɔ yĩnnɛ, tɛ̃̀ wɔ min kɩ pwah. ");
INSERT INTO wib_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","26","Névi nɛ̂-á ńmɔ, ànɛ̂ ń wɛy fɛ̃̀nsyinɔ yah sen ku, ńmɔ Névi Pi tɔ kɩ sen ku nɛ, mé náh tɛ̃̀ pɩ̃, mâh sṍ nɛ̂nɛ pɔ ń yõ̀tɔ̃rɩ́ sɔkɔ, ànɛ̂ ń sú tyɩ́, ànɛ̂ yĩ̂nyõ tɛ̃ntõnè tyɩ́ sɔkɔ. Kǎh pɩ sɛ̃́, yõ se mɛ ké tyɩ́, névi-à kèkõyṍ tahrɩ pól wɛ, tɛ́ n tɛkɩ n pi ǹ min sɔkɔ, kɩ ǹ gblɔ̌y tyɩ́ yɩkɩ? ");
INSERT INTO wib_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Gbɩ yõ, mé kélɛ n yo yé tyɩ́ nɛ: névye nónó-á mɛ ásõ̂, pé túkù kɩ Liyel tɔ̃́rɩ́ wɛ yĩ́nɛ, tɛ́ kɩ mɛ min sɔkɔ.» ");
INSERT INTO wib_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Kénɛ wɛlɔ yóntɛnɔ náh, sèpĩ̀n kwǎrtɔ̃nɔ kénkɔ̃-á sɔkɔ, Yesu Pyɛrɩ, ànɛ̂ Nsyɔ̃, ànɛ̂ Nsyakɩ tɛ̃ sɔkɔ yɔ̃lɩ yɔ́ yõ nɛ, pé kyɩ nírí pɩ. ");
INSERT INTO wib_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Wǎh mɛ nírí sɔkɔ gbĩ́ nɛ̂nɛ, ǹ yèpɔ dùkù vi mɔ, tɛ́ ǹ flɔ piki prɛ́yy. ");
INSERT INTO wib_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Nɛ́npɔ́ swɔ, díbí nɛ́pĩ̂ nímí núkú wil, mɛ yã́hkɩ̀lɛ n yãh ànɛ̂ Yesulɛ. ");
INSERT INTO wib_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Moyisi ànɛ̂ Yeli ye sõ̀ pɔ wil mɔ yĩ̂nyõ tɔ̃́rɩ́ sɔkɔ, tɛ́ mɛ n yãh Yesulɛ, wǎh kɩ ǹ tõ̀ pɩ n tũ n pi sɔ̃́, ǹ kúnɔ́ sɔkɔ Yerusalɛmɩ. ");
INSERT INTO wib_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Tɛ́ légbĩ́nɛ, dɔy sõ̀ mɛ Pyɛrɩ ànɛ̂ pé no tyɩ́ fɛ̃. Pǎh dɔ yuku, pè Yesu tɔ̃́rɩ́ dùkù wɛ ànɛ̂ díbí nɛ́pĩ̂ nímí nɔ́pilɛ yĩ́nnɔ́lɛ ǹnɛ. ");
INSERT INTO wib_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Képah náh, nɛ́pĩ̂ nímí nɔ́pi-á n yal Yesu tnɔ̂ gbĩ́ nɛ̂nɛ, Pyɛrɩ mɛ yo ǹ tyɩ́ nɛ, pé yõ̀tɛ̃̀, pé tɛ̃̀nɔ́-á kɩ plɛ ásõ̂ dɛ́! Páh kɩ yèpyenɔ tɔ̃́nɔ́ pɩ. Ńkɛ̃́ ǹmɔ tyɩ́-á núkúlɛ, Moyisi tyɩ́ mɛ núkúlɛ, Yeli tyɩ́ mɛ núkúlɛ. Tɛ́, à náh sõ̀ pɩ̃, tir nɛ̂-á à mɛ n yo. ");
INSERT INTO wib_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Wǎh mɛ wɛ́kɩ́nɔ́ sɔkɔ sɛ̃́, ńyĩ́rkì yɔ́ núkú wil fob mɔ pé yõ. Légbĩ́nɛ, tíkí de Yesu tõ̀ sã́hpú sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Képah sɔkɔ, yĩ́npɔ̃́ yɔ́ wil Liyel tyɩ́ ńyĩ́rkì mɛ̀ sɔkɔ, mɛ n yo nɛ ńkɛ̃́: «Ǹmɔ nɛ̂-á yɔ̀, ǹmɔ ye ń pídĩ́nɛ, máh nɛ̂ yah wilki. Yé nɛ n nohnɩ ǹ tyɩ́!» ");
INSERT INTO wib_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Pǎh wɛy mɛ̀ noh ńyãh sɔkɔ, nɛy náh tɔ̃ wɛ nɛ́npɔ́, nɛ́ Yesu ó náh. Kǎh pɩ sɛ̃́, ǹ tõ̀ sã́hpú pé vyɛ̃y vike tɛ̃ syɩ́syɩ́. Tɛ́ légbĩ́nɛ, pǎh tyi nónó wɛ, pè náh mɛ sé sɔkɔ yɔ́ ńtɛ̃nɛ n yãh nɛy tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Dendallɛ, pǎh tiki yɔ̃lɩ yõ, tɔ́wû ǹgbɛ̃ yɔ́ pɔ Yesu yohnɩ. ");
INSERT INTO wib_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Tɛ́ kénɛ tɔ́wû sɔkɔ, dĩ́ yɔ́ sõ̀ mɛ, à tyah n de n syi nɛ, kwɔ́-ò dĩ́, páh ǹnɛ n ni, à yah dah mɔ pé pídĩ́ tyɩ́ sɔkɔ, ǹmɔ núkúní-á pé tyɩ́, ");
INSERT INTO wib_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","tɛ́ sétõ yɔ́-á mɛ n yuku n pɔ ǹ yõ. Kàh yuku ǹ yõ, à n de n syi nɛ́npɔ́ swɔ, ànɛ̂ kě à kah n yike pélpèl, tɛ́ gbèfɔ̀kɔ̀píkínì n nɛ n wil ǹ vyãh. Ànɛ̂ kè náh ǹnɛ n fĩn n mɔ súú. Kàh pópó ǹnɛ n fĩn mɔ, kě à fõh n kah n mɔ. ");
INSERT INTO wib_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Képah-á, pé pɔ ǹ tõ̀ sã́hpú ni nɛ, pè sétõ mɛ̀ yĩni, tɛ́ pè náh tɛ̃ wɛ. ");
INSERT INTO wib_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Wǎh yo sɛ̃́, Yesu mɛ yo pé tyɩ́ nɛ, nɛ́pêl, ànɛ̂ Liyel yõ sɛ̃́-ńkɛ̃̂ névye nɔ́pi! Pé se yɩ̃nɛ, pé pé nɩ tɛ̃, pé tɛ̃ pélɛ, pé pɔ syɩ gbĩ́ nɛ̂ tyɩ́ nɩ? Ńkɛ̃́, à pɔ ǹ pídĩ́nɛ ásõ̂. ");
INSERT INTO wib_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Piri-á núkú n nɔ n de Yesu tnɔ̂, sétõ à kwel min sétáh, tɛ́ à yike kègbɩlɛ. Ǹtɛ, Yesu mɛ dírí kõ sétõ yõ, tɛ́ piri dɛ mɔ, tɛ́ ǹnɛ ǹ sú gbõ̀ dahbɩ. ");
INSERT INTO wib_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Képah tɛ̃̀nɛ, no pól gbã̀n du Liyel tɛ̃́npnɛ̀nɔ́ tyɩ́lɛ. Ǹtɛ, no pól-à sõ̀ mɛ gbɛ̃̀ndùnì sɔkɔ sɛ̃́ ǹ tyípɩ́nɔ́ nɔ́pi pól yĩnnɛ, à mɛ yo ǹ tõ̀ sã́hpú tyɩ́: ");
INSERT INTO wib_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Nɛ̂-á mé n tyah yónɔ́lɛ yé tyɩ́, yé kè noh pallɛ: Névi Pi kɩ n dahbɩ n pi névye gbõ̀.» ");
INSERT INTO wib_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ǹtɛ, pè náh sõ̀ mɛ wɛy mɛ̀ tyɩ́ yah wɛ. Kè sõ̀ wɛkɩ wɛ́npǐllɛ pé tyɩ́ nɛ, pè káh ké yõ pɩ̃. Tɛ́ ké dùkù píkínyahnɔ tíkí sõ̀ mɛ pè tɛ̃ Yesu tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Képah sɔkɔ, tõ̀ sã́hpú tyah yékã̂blɛ n pɩ nɛ, pé pɩ̃ nɛ̂ tɛ̃̀-á kal pépi sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Tɛ́ Yesu-á pé fɔ́kɔ́sɔ̃nɔ pɩ̃ sɛ̃́, à piri yɔ́ tɛ̃ sah ǹ tnɔ̂, ");
INSERT INTO wib_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","tɛ́ yo pé tyɩ́: «Nɛ̂-á tyɩ̃́ɩ̃ kal yépi pól sɔkɔ, ǹmɔ kal tɛ́lɔ́lɛ. Képah ye, névi nɛ̂-à piri mɛ̀ kénkɔ̃ tɛ̃́nɔ́ plɛ ńmɔ yĩnnɛ, ńmɔ ye tɛ̃̀ tɛ̃ plɛ. Ànɛ̂ névi nɛ̂ tɔ-à ńmɔ tɛ̃́nɔ́ plɛ, ń tɛ́kɩ́nmɔ-ò ye tɛ̃̀ tɛ̃ plɛ.» ");
INSERT INTO wib_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Képah sɔkɔ, Nsyɔ̃ mɛ Yesu syah nɛ, pé yõ̀tɛ̃̀, pépi-á ǹnɩ̂ wɛ, à mɛ sétã̀nnɛ n yĩni ǹ yĩn yõ, tɛ́ à náh se sõ̀ mɛ ǹ sõ̀ tɛ̃ pépilɛ wɛ̃ tyɩ́. Képah-á, pé nɛ, pé ǹnɛ n yĩni n mɔ ké pɩ́nɔ́lɛ. ");
INSERT INTO wib_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Wǎh yo sɛ̃́, Yesu mɛ yo ǹ tyɩ́: «Névi nɛ̂-à mɛ yélɛ n fwó-ńkɛ̃̂nɛ, tɛ̃̀ mɛ yélɛ. Képah ye, yé káh à yĩni n mɔ ké pɩ́nɔ́lɛ.» ");
INSERT INTO wib_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Képah náh, Yesu yɔ̃̀ndɔkɔnsɔkɔ gbĩ́-á pɔ nɔ yĩ̂nyõ, à kè yah tɔkɔ yĩn núkú yõ nɛ ńkɛ̃́, páh kɩ kyɩ Yerusalɛmɩ. ");
INSERT INTO wib_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Kǎh pɩ sɛ̃́, à tɛ̃ntõ̀ névye tɛkɩ mɔ ǹ yahlɛ. Pépi mɛ wɛ̃̀kɩ̀ tɛ̃, à kyɩ de Samarɩ kwil yɔ́ sɔkɔ nɛ, pé kyɩ twáh-ńsah yah sah à kɔ̃. ");
INSERT INTO wib_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ǹtɛ, wǎh sɔ̃́npɩ́lɛ ǹ yah mɔ n yuku Yerusalɛmɩ tĩ̀nnɛ, kǎh pɩ sɛ̃́, nɛ́npɔ́ tãn mɛ yahle nɛ, à káh twah pé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Yesu tõ̀ sã́hpú sɔkɔ Nsyakɩ, ànɛ̂ Nsyɔ̃-á képah noh sɛ̃́, pè nɛ, Tɛ̃̀ ǹgbɛ̃, à se mɛ ké tyɩ́ nɛ, pé yĩ̂nyõ nyàh ye mɔ no nɔ́pi yõ, kè tiki n pɔ pè sukɛ n mukuli nɩ? ");
INSERT INTO wib_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Pǎh yo sɛ̃́, Yesu ǹ yah vi pé tĩ̀nnɛ, à dírí kõ pé yõ. ");
INSERT INTO wib_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Képah náh, pè mɛ wɛ̃̀kɩ̀ tɛ̃, à sɔkɔ kwil yɔ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Képah sɔkɔ, pǎh mɛ wɛ̃̀kɩ̀ yõ gbĩ́ nɛ̂nɛ, dĩ́ yɔ́ Yesu syah nɛ ńkɛ̃́, páh kɩ ǹ sõ̀ tɛ̃ n kɔ n kɔ̃ ǹnɛ, ǹ kɔ́-ńtã̂n pól sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Wǎh yo sɛ̃́, Yesu mɛ yo ǹ tyɩ́: «Gbɛ̃́npãhlɔ tyɩ́, pɩ̃̀ mɛ. Kèpye tyɩ́, syɛ̀ mɛ. Ǹtɛ Névi Pi tɛ̃̀ tyɩ́, wɛ́nsɛ̃nmɩ̀-ǹsah ńtɛ̃ náh mɛ.» ");
INSERT INTO wib_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Tɛ́ mɛ pyě yo ǹnɩ̂ tyɩ́: «Ń sõ̀ tɛ̃.» Kénɛ dĩ́ mɛ à syah nɛ, à yɛ, pâh pɔ pé sú lékó ǹgbò yɩ̃ tɛ. ");
INSERT INTO wib_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Wǎh yo sɛ̃́, Yesu mɛ à syah nɛ: «Yɛ lékyɩ̂ kɔ̃, pè pé lékyɩ̂lɛ n yɩ̃, tɛ́ áwɔ mó kyɩ Liyel tɔ̃́rɩ́ tyɩ́lɛ n yo n kɔ̃.» ");
INSERT INTO wib_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Képah sɔkɔ, ǹnɩ̂ yɔ́ mó yo Yesu tyɩ́ nɛ, pé Tɛ̃̀ ǹgbɛ̃, páh kɩ ǹ sõ̀ tɛ̃. Tɛ́ à yɛ pé kɔ̃, pé kyɩ ké wɛ̃̀kɩ̀ ni pé gbô tãn tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Wǎh yo sɛ̃́, Yesu mɛ yo ǹ tyɩ́ nɛ: «Névi nɛ̂-à nyeh wɛkɩ tɛ̃ swãhlɛ n wɔ, tɛ́ n yah náhlɛ, tɛ̃̀ náh fɛ̃ Liyel tɔ̃́rɩ́ tõ̀ pɩ n pi.» ");
INSERT INTO wib_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Képah náh, Tɛ̃̀ ǹgbɛ̃ Yesu mɛ tõ̀ sã́hpú nɛ́pĩ̂ tikitɔ̃nɩ́ pɔ́ gbãm pɔ́ nínɔ́ yísyɔ́ yah wah, tɛ́ pè tɛkɩ mɔ nímí nímínɛ ǹ yah tĩ̀nnɛ, kwlo ànɛ̂ wley wley pól sɔkɔ, ǹmɔ-á sõ̀ mɛ ké tyɩ́ nɛ, pé kyɩ pé gblɔ̌y nónó sɔkɔ, ");
INSERT INTO wib_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","tɛ́ yo pé tyɩ́ nɛ: «Sèmukɔ tɔkɔ tɔkɔ tɛ̃̀ mɛ dò, tɛ́ ké tõ̀npɩbɩlɛ kwéyy. Yé sètɛ̃̀ ni, à tõ̀npɩbɩ náhnáh tɛkɩ mɔ, ǹ sèmukɔ tɔkɔ yĩnnɛ. ");
INSERT INTO wib_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Yé nɛ n yuku! Tɛ́, yé mɛ á kɩ nɛ, képɔ́pî sɔ̃́, mé n tɛkɩ n mɔ gbɛ̃́npãhlɔ nɩyṍ. ");
INSERT INTO wib_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ǹtɛ, yé káh pɔ́, ànɛ̂ pilki, ànɛ̂ lékyêh tɔkɔ. Yé káh yĩn wɛkɩ nɛy tyɩ́ wɛ̃̀kɩ̀ yah. ");
INSERT INTO wib_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ànɛ̂, yâh kyɩ n de kéte nɛ̂ sɔkɔ, yé wɛy gbennɛ, yé yo nɛ ńkɛ̃́: ‹Yèvɩnɩ nɛ n mɛ kéte mɛ̀ sɔkɔ.› ");
INSERT INTO wib_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Kàh pɔ yɩ̃nɛ nɛy mɛ yèvɩnɩnɛ n yah n kɔ̃ kénɛ kéte sɔkɔ, yé yèvɩnɩ yénmɔnɔ mɛ̀ kɩ pɩ tɛ̃̀ wɔ tyɩ́lɛ, yé mó tɛ̃ nɛ́npɔ́. Képah-à mó pɩ́-ńkɛ̃̂nɛ, yé yèvɩnɩ yénmɔnɔ kɩ ké syɩ pɔ yé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Tõ̀npɩ ye yɩ̃nɛ ǹ tõ̀ pɩ́nɔ́ yõre wɛ́nɔ́lɛ. Képah ye, yâh twah kéte nɛ̂ sɔkɔ, pàh yé kɔ̃ yõke nɛ̂nɛ, yé kè yõ, ànɛ̂ pàh yé kɔ̃ wɔ wɔ kwâh nɛ̂nɛ, yé kè wɔ. Tɛ́, yé káh nɛ n vi n mɔ n twah n kɔ̃ gbéngbèn sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Yâh kyɩ de kwil nɛ̂ sɔkɔ, tɛ́ pè yé tɛ̃́nɔ́ plɛ, pàh kwâh nɛ̂nɛ yé kɔ̃, yé kè yõ. ");
INSERT INTO wib_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Yé mó yámpúlɛ n dɛ n mɔ, nónó-á mɛ nɛ́npɔ́. Yé mó nɛ n yo kénɛ kwil tãn tyɩ́ nɛ ńkɛ̃́, Liyel tɔ̃́rɩ́-á yĩni tɛ̃ tɛ pé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ǹtɛ, yâh kyɩ de kwil nɛ̂ sɔkɔ, tɛ́ pè nɛ, yé káh twah pé tyɩ́, yé wil kyɩ pé tɔ́wû tùkè-ǹtã̀n sɔkɔ, yé mó yo nɛ, ");
INSERT INTO wib_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","pé kwil nɛ̀ngbɔ̃ nɛ̂ ńtɛ̃-á tahlɩ yé gbyẽ̂h tyɩ́, yáh kɩ sè kwer kwɛ pè kɔ̃. Ǹtɛ, pè pɩ̃ nɛ, Liyel tɔ̃́rɩ́-á yĩni tɛ̃ tɛ. ");
INSERT INTO wib_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Mé kélɛ n yo yé tyɩ́ nɛ: Liyel tukey tuke sṍlɛ, Sodɔmɩ kwil fṍhnɔ́ ńtɛ̃ kɩ fàhfàh kal kènɛ kwil tyɩ́lɛ.» ");
INSERT INTO wib_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Yesu tɔ̃ yɔ̃ sɔkɔ yo kwlo nɔ́pi tyɩ́ sɔkɔ nɛ: «Yèvyãhrɩ mɛ yé yõ, Korasini ànɛ̂ Betisayida tãn! Gbǐl tyi nónó-á pɩ yé tyɩ́, sɛ̃́nkɔ̃-à sõ̀ mɛ pɩ Tiri ànɛ̂ Sidõ tãn tyɩ́, pé Liyel wɛ̃̀kɩ̀ tɛ̃́nɔ́ di náhkɩ mɛ mo. Pè náhkɩ mɛ yèkwɔrɩ flɔ mɔ, tɛ́ náhkɩ mɛ pé piki syɩ̃lɛ pé tyípêl nàhnpɩ̃ gbónɔ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ǹtɛ, tukey tuke sṍlɛ, Tiri ànɛ̂ Sidõ fṍhnɔ́ kɩ pɩ fàhfàh kal yépi tyɩ́lɛ. ");
INSERT INTO wib_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Tɛ́, áwɔ-á, Kapɛrnayumi, á se wɛ nɛ, wáh kɩ yɔ̃ dɔkɔ yĩ̂nyõ? Póllɛ! Á kɩ tiki yuku fɔ́ɔ́ lékókwíl nyàh tɛ̃̀-ǹsah.» ");
INSERT INTO wib_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Tɛ́ tɔ̃ yo ǹ tõ̀ sã́hpú tyɩ́ nɛ: «Névi nɛ̂-à n nohnɩ yé tyɩ́, ńmɔ tyɩ́ ye tɛ̃̀ n nohnɩ, tɛ́ nɛ̂-à yé yahle, ńmɔ ye tɛ̃̀ yahle ànɛ̂ ń tɛkɩ mɔ́-ò tɔlɛ.» ");
INSERT INTO wib_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Képah náh, tõ̀ sã́hpú nɛ́pĩ̂ tikitɔ̃nɩ́ pɔ́ gbãm pɔ́ nínɔ́ nɔ́pi pé syɩ pɔ de nɩ̀vɩ̀nɩ̀ sɔkɔ, mɛ n yo Yesu tyɩ́ nɛ, pé Yõ̀tɛ̃̀, ǹmɔ yĩn yõ, sétã̀n ńtɛ̃-á mɛ n sah pépi yóré yõ! ");
INSERT INTO wib_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Képah tɛ̃̀nɛ, à mɛ yo pé tyɩ́: «Mé sõ̀ sétã̀n yõ̀tɛ̃̀ wɛ, à wil yĩ̂nyõ, à tiki kɛ núkú, à pɔ syɩkɩ pũ̀ sɔ̃́ yikiri yã̌l. ");
INSERT INTO wib_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ǹtɛ, yé yah, mé tɛ̃́nwɛnɔlɛ yé kɔ̃: Yé kɩ n kɔ vyeh, ànɛ̂ mìntyɩ̃ yõ. Ànɛ̂ yé kɩ fɛ̃ sépɛ tǎhkɩ̀lɛ n yɩkɩ, tɛ́ tir yɔ́ ńtɛ̃ náh yé nɔ n pi. ");
INSERT INTO wib_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Tɛ́ yé káh yɛ yé nɩ vɩ sétã̀n sàhnɔ́ ó tyɩ́lɛ yé yóré yõ. Ǹtɛ, yé yé nɩ vɩ nɛ, yé yni-á mɛ wã́rkɩ́nsàhnɔ́lɛ yĩ̂nyõ.» ");
INSERT INTO wib_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Légbĩ́-ó sɔkɔ, Yesu nɩ kah vɩ Liyel Mírkí gbõ̀ yõ. Képah sɔkɔ, à mɛ nɛ: «Bɔ̌, áwɔ nɛ̂-á yĩ̂nyõ, ànɛ̂ sétáh nɛ́tɛ̃̂nɛ, mé álɛ n gbilki, áwɔ nɛ̂-á tyi nɔ́pi wɔ̃bɩ yɩ̃ pɩ̃́pú, ànɛ̂ lékã́mpu yah, tɛ́ sélɛ wɛ̃́npì wɔ wɛ̃kɩ. Àwe, bɔ̌, áwɔ dyɔ yĩ́ĩ́ tɛ̃̀ ye nɛ kè pɩ sɛ̃́. ");
INSERT INTO wib_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ń sú ye sé póllɛ ń gbõ̀ dahbɩ. Ǹtɛ, ǹnɩ̂ yɔ́ ńtɛ̃ náh Liyel pilɛ n pnɛ, nɛ́ sú ó náh. Sɛ̃́ ó ye, nɛy tɔ náh súlɛ n pnɛ, nɛ́ pídĩ́ ó náh, ànɛ̂ wǎh mɛ ké tyɩ́ nɛ, pé pé súlɛ nɛ̂ wɛ̃kɩ.» ");
INSERT INTO wib_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Képah náh, Yesu ǹ yah vi ǹ tõ̀ sã́hpú tĩ̀nnɛ, tɛ́ yo pépi ó tyɩ́: «Yèvɩnɩ mɛ yé tyɩ́, yépi nónó-á tyi nɔ́pi wɛ. ");
INSERT INTO wib_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Mé kélɛ n yo yé tyɩ́ nɛ: Liyel tɛ̃ntõnè náhnáh, ànɛ̂ yõ̀tãm náhnáh sõ̀ mɛ ké tyɩ́ nɛ, pé sè wɛ, tɛ́ pè náh sè wɛ. Tɛ́ mɛ ké tyɩ́ nɛ, yáh nónó noh, pé sè noh, tɛ́ pè náh sé tɔ wɛ noh.» ");
INSERT INTO wib_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Légbĩ́nɛ, Liyel ǹgbò wɛ̃̀kɩ̀ kwɔ́-ò yɔ́ sõ̀ nɛ, pé Yesu mɔ yah, tɛ́ yuku yĩn, à yo ǹ tyɩ́ nɛ ńkɛ̃́, kwɔ́-ò dĩ́, pé se kɩ pɩ sɔ̃́, tɛ́ kɩ tyɛ́-ńkɛ̃̂ min wɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesu mɛ yo ǹ tyɩ́ nɛ, tir nɛ̂ se wã́rkɩ́nsàhnɔ́lɛ Liyel tyi sàhnɔ́ sɛ́bɛ́y sɔkɔ nɩ? Tir nɛ̂ se à mɛ n kar ké sɔkɔ nɩ? ");
INSERT INTO wib_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Dĩ́ mɛ yo ǹ tyɩ́ nɛ, kǎh mɛ wã́rkɩ́nsàhnɔ́lɛ nɛ ńkɛ̃́, á Tɛ̃̀ ǹgbɛ̃ Liyel tyɩ́-á yɩ̃nɛ kè nɔ á tyɩ́ á nɩ póllɛ, ànɛ̂ á min póllɛ, ànɛ̂ á tǎhkɩ̀ póllɛ, ànɛ̂ á sõnɔ póllɛ. Á ní-ò tɔ tyɩ́ mó nɔ á tyɩ́ á gblɔ̌y tyɩ́ kɔ̃lɛ. ");
INSERT INTO wib_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Wǎh yo sɛ̃́, Yesu mɛ yo ǹ tyɩ́: «Á yo plɛ. Képahlɛ n pɩ, á kɩ tyɛ́-ńkɛ̃̂ min wɛ.» ");
INSERT INTO wib_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ǹtɛ, dĩ́ mɛ̀ sõ̀ mɛ ké tyɩ́ nɛ, pé gbɩ wɛ. Kǎh pɩ sɛ̃́, à Yesu syah nɛ, nɛ̂ se péwɔ ní-òlɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesu mɛ à syah nɛ: «Dĩ́ yɔ́ ye lésõ wil Yerusalɛmɩ, à mɛ n tiki n yuku Yeriko sɔkɔ, tɛ́ kyɩ wil mɔ yɩ̃́pú yõ. Pè mɛ à tɛ̃ ǹ gbã̀n yî pól tɛ̃ syi, tɛ́ à ko markɩ sah, tɛ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Tɛ́, kè pɔ yɩ̃nɛ, sárká wìlkìpu yõ̀tɛ̃̀ yɔ́ mó mɛ n tiki n pi kénɛ wɛ̃̀kɩ̀lɛ. Wǎh pɔ dĩ́ mɛ̀ wɛ, à gbɔ sɔkɔ fɩ́ɩ́. ");
INSERT INTO wib_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Képah náh, Levi yìkì nɛy yɔ́ tɔ tɔ̃ pɔ yĩni tɛ̃ nɛ́npɔ́. Ǹmɔ tɔ-á à wɛ sɛ̃́, à gbɔ sɔkɔ fɩ́ɩ́. ");
INSERT INTO wib_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ǹtɛ, Samarɩ nɛy yɔ́ sõ̀ mɛ n yuku kɔ́lɔ́ sɔkɔ, tɛ́ kyɩ dĩ́ yõ dɔkɔ. Ǹmɔ wɔ-á à wɛ sɛ̃́, ǹ yãm à tɛ̃. ");
INSERT INTO wib_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","À mɛ nɔ de ǹ tnɔ̂, tɛ́ dìvɛ̃ ànɛ̂ nɩrɩ mɔ ǹ nɩ́y yah, tɛ́ sè pukubi. Tɛ́ mɛ à dɔkɔ mɔ ǹ yɛ̃́ngbɛ̃́ ńkwɛ̃́ndyɩ́kɩ̀ yõ, à yuku ǹnɛ nɛ́pân twáh-ńsah yɔ́ sɔkɔ, à kyɩ yah dah mɔ ǹ tyɩ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ké dendallɛ, à mɛ pɔ́ plɔ́ nínɔ́ wilki nɛ́pân twáh-ńsah yõ̀tɛ̃̀ dĩ́ kɔ̃, tɛ́ nɛ, à nɛ n yah n dah n mɔ dĩ́ mɛ̀ tyɩ́ sɔkɔ. Ńkɛ̃́, wàh kɩ sɔ̃́ gbõ̀ wilki à kah mɔ képah yõ, pâh pé syɩ pɔ gbĩ́ nɛ̂nɛ, páh kɩ à dyah kélɛ.» ");
INSERT INTO wib_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Képah yóntɛnɔ náh, Yesu dĩ́ piki yah nɛ, ǹmɔ tɛ̃̀ sõnɔ sɔkɔ, yɩ̃́pú-á dĩ́ nɛ̂ pɩ yɔ, ǹmɔ ní-ò se nɛ̂ tɛ̃̀nɛ nɛ́pĩ̂ tɔ̃́mɩ́ nɔ́pi sɔkɔ nɩ? ");
INSERT INTO wib_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Liyel ǹgbò wɛ̃̀kɩ̀ kwɔ́-ò mɛ à syah nɛ, nɛ̂-á ǹ yãm yah, ǹmɔ-á. Képah tɛ̃̀nɛ, Yesu mɛ yo ǹ tyɩ́: «Á tɔ kyɩ sɛ̃́nkɔ̃lɛ n pɩ.» ");
INSERT INTO wib_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Tɛ́ Yesu ànɛ̂ ǹ tõ̀ sã́hpú-á sõ̀ mɛ wɛ̃̀kɩ̀ yõ sɛ̃́, à kyɩ de kwílpír yɔ́ sɔkɔ. Tɛ́ kénɛ kwil sê yɔ́ sõ̀ mɛ, pè n ye Martɩlɛ. Ǹmɔ mɛ Yesu tɛ̃ plɛ ǹ gbô. ");
INSERT INTO wib_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Tɛ́ gbɛ̃̀ sê yɔ́ sõ̀ mɛ ǹ tyɩ́, pè n ye Marilɛ. Ǹmɔ sõ̀ mɛ pɔ tɛ̃ Tɛ̃̀ ǹgbɛ̃ Yesu tnɔ̂, à ǹ wɛlɔlɛ n nohnɩ. ");
INSERT INTO wib_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Légbĩ́nɛ, Martɩ yah mɛ n vyãh Yesu fèn pɩ́nɔ́ sɔkɔ. À mɛ pɔ yo Yesu tyɩ́ nɛ, pé Yõ̀tɛ̃̀, pé gbɛ̃̀ sê-á tõ̀ pól sah péwɔ ó kɔ̃, tɛ́ pɔ tɛ̃ ǹ tnɔ̂, kè kó mɛ tirlɛ ǹ yah nɩ? À kó n yo ǹ tyɩ́, à pélɛ n yohnɩ n mɔ nɩ? ");
INSERT INTO wib_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ǹtɛ, à mɛ yo ǹ tyɩ́ nɛ: «Martɩ, áwɔ mɛ á gblɔ̌ynɛ n kwlɔ, mɛ á fɔkɔlɛ n sõ tyi náhnáh tyɩ́lɛ. ");
INSERT INTO wib_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ǹtɛ, tir núkú ó tyɩ́ ye yõrelɛ. Mari ye ké pèpɛy yah tɔkɔ, nɛ̂-á kè náh n tɛ̃ n syi n yah n pi ǹ tyɩ́.» ");
INSERT INTO wib_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Sṍ yɔ́lɛ, Yesu sõ̀ mɛ Liyellɛ n ni fɩ̃́ yɔ́ sɔkɔ. Wǎh ni tɛ, ǹ tõ̀ sã́hpú sɔkɔ yɔ́ à syah nɛ, pé Yõ̀tɛ̃̀, à pépi kwɔ Liyel ni dùkùlɛ, sɔ̃́-á Wèlnwìlkì-ò Nsyɔ̃ sõ̀ kélɛ ǹ tõ̀ sã́hpú kwɔ. ");
INSERT INTO wib_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Képah sɔkɔ, à yo pé tyɩ́: «Yâh Liyellɛ n ni, yé nɛ n yo nɛ ńkɛ̃́: ‹Sú Liyel, no pól kɔ̃ pè ǹ pɩ̃ Liyellɛ. Á tɔ̃́rɩ́ kɔ̃ kè pɔ. ");
INSERT INTO wib_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Á sõmɛsṍ gbĩ̀yĩ̀kì yõkelɛ álɛ n kɔ̃, nɛ̂-á kɩ n yɩ̃nɛ n pi álɛ. ");
INSERT INTO wib_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Nónó-á n pɩ n de ápi tyɩ́, á ye mɛ sélɛ n yɔ̃ n mɔ pé tyɩ́. Képah ye, ápi tɔ tyípêl yɔ̃ mɔ á kɔ̃. Ànɛ̂, káh n yɛ à sétõ tɔ̃̀nmɔnɔ fɛ̃ n syi.›» ");
INSERT INTO wib_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Képah náh, Yesu tɔ̃ yɔ̃ sɔkɔ yo pé tyɩ́ nɛ: «Yépi sɔkɔ yɔ́ tyɩ́ kódĩ́-à mɛ, tɛ́ à pɔ wil ǹ tyɩ́ lénɩlɛ nɛ ńkɛ̃́, pé kódĩ́ yɔ́-á mɛ wil kɔ́lɔ́ sɔkɔ, à pɔ pé tyɩ́, tɛ́ yõ yõ kwâh náh mɛ pé tyɩ́ kɩ à kɔ̃. Ńkɛ̃́, à dɛkɩ pé kɔ̃ búrn plɔ́ tɔ̃́nɔ́lɛ. ");
INSERT INTO wib_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ǹtɛ, ní-ò mɛ̀-à ńtyɩ̃́nɔ tɛ̃ wɔ̀kɔ̀ sɔkɔ táh, tɛ́ yo mɔ ǹ tyɩ́ nɛ, à káh pélɛ n kwlɔ, wɔ̀kɔ̀ yah-á vike tɛ núkúnúkú, péwɔ ànɛ̂ pé wɛ̃́npì-á sɛ̃, pé náh fɛ̃ yuku búrnnɛ à kɔ̃ n pi. ");
INSERT INTO wib_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Mé kélɛ n yo yé tyɩ́ nɛ: dĩ́ mɛ̀-à sɔ̃́ yuku sélɛ à kɔ̃́-ńkɛ̃̂nɛ pé kódírí yĩnnɛ, à kɩ yuku ǹ yétõ̂ yî póllɛ à kɔ̃ ǹ nínɔ́ gblɔ́vyã́hrɩ́ tɛ̃̀ wɔ yĩnnɛ. ");
INSERT INTO wib_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ǹtɛ, ńmɔ tɛ̃̀ wɔ kélɛ n yo yé tyɩ́ nɛ: yé nɛ n ni Liyel tyɩ́, à kɩ yélɛ n kɔ̃. Yé yáhnkɔ̃nɔlɛ n pɩ, yé kɩ n wɛ. Yé wɔ̀kɔ̀ yah mɩ, kè kɩ yɩkɩ mɔ yé kɔ̃. ");
INSERT INTO wib_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Sɛ̃́ ó ye, nɛ̂-à ni Liyel tyɩ́, tɛ̃̀ n wɛ n syi. Nɛ̂-à yah kɔ̃, tɛ̃̀ n wɛ. Ànɛ̂ nɛ̂-à wɔ̀kɔ̀ yah mɩ, kè n yɩkɩ n mɔ tɛ̃̀ kɔ̃. ");
INSERT INTO wib_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Sú nɛ̂ tɛ̃̀ mɛ yépi sɔkɔ, ǹ pi-à yɛ̃́nkɔ̂ ni ǹ tyɩ́, à kɩ wahynɛ à kɔ̃? ");
INSERT INTO wib_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Képah náh pɩ, wàh séngbɩ̃́ ni ǹ tyɩ́, à kɩ mìnkɔ̃nɛ à kɔ̃? ");
INSERT INTO wib_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ǹtɛ, yépi nónó-á nɛ́pêllɛ, yâh yé wɛ̃́npì kɔ̃́nɔ́ yah wɛ yípéplɔlɛ, sú Liyel nɛ̂-á yĩ̂nyõ, ǹmɔ náh n pɩ plɛ n kal, à ǹ Mírkílɛ ké yáhnkɔ̃pu kɔ̃ n pi di?» ");
INSERT INTO wib_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Sṍ yɔ́lɛ, Yesu sõ̀ mɛ sétõ yɔ́lɛ n yĩni n wilki dĩ́ yɔ́ sɔkɔ, nɛ̂-á à kɔ̃ à wɛkɩ kwlɔ. Sétõ-á fyɔ̀ wil dĩ́ mɛ̀ sɔkɔ, dĩ́ tyah n wɛkɩ, kè pɩ gbɛ̃̀ndùnìnɛ tɔ́wû tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Tɛ́ túkù mó sõ̀ mɛ n yo nɛ ńkɛ̃́, sétã̀n yõ̀tɛ̃̀ Belsebuli gbõ̀ yõ-á à n yĩni sétã̀nnɛ. ");
INSERT INTO wib_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Túkù mó ǹ mɔ́nyah yĩnnɛ, mɛ n yo ǹ tyɩ́ nɛ, à gbǐl yɔ́ pɩ pé yah, nɛ̂-á n wil yĩ̂nyõ. ");
INSERT INTO wib_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ǹtɛ, Yesu-á pé fɔ́kɔ́sõnɔ pɩ̃ sɛ̃́, à yo pé tyɩ́: «Kwil nɛ̂ névye-à gbɛkɩ tyah wɛ̃nɛ n fwo, kénɛ kwil kɩ pɔ yɩkɩ, ké vɩ̀ kɩ syɩkɩlɩ dohnɩ wɛ̃ yõ. ");
INSERT INTO wib_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ǹtɛ, yáh nɛ ńkɛ̃́, sétã̀n yõ̀tɛ̃̀ gbõ̀ yõ-á ńmɔ sétã̀nnɛ n yĩni-à; sétõ-à tyah ǹ gblɔ̌ynɛ n fwo, ǹ yõ̀tɔ̃rɩ́ se kɩ n wũ n pi? ");
INSERT INTO wib_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ǹtɛ, ńmɔ-à mɛ sélɛ n yĩni Belsebuli gbõ̀ yõ, tɛ́ yépi pye wɔ-á dò, nɛ̂ gbõ̀ yõ mɛ pépi n yĩni sélɛ wɛ́? Pépi ńtɛ̃ ye kɩ lékàhlɛ yé kɔ̃. ");
INSERT INTO wib_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ǹtɛ, Liyel gbõ̀ yõ-à mé n yĩni sétã̀nnɛ, képah n wɛ̃kɩ nɛ ńkɛ̃́, Liyel tɔ̃́rɩ́-á yĩni tɛ̃ yé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Tǎhkɩ̀-á mɛ dĩ́ nɛ̂ sɔkɔ, ànɛ̂ mɛ́fwóyîlɛ ǹ tyɩ́, wàh ǹ kételɛ n syɩkɩ, tir yɔ́ ńtɛ̃ náh fɛ̃ ǹ gbã̀n yî nɔ n pi. ");
INSERT INTO wib_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ǹtɛ, nɛ̂ tǎhkɩ̀-á kal ǹ tyɩ́lɛ, ǹmɔ-à pɔ, tɛ́ tɛ̃ wɛ ǹ tyɩ́, à kɩ ǹ mɛ́fwó yî tɛ̃ syi, wǎh sõ̀ mɛ ǹ gbõ̀ sah nónó yõ, tɛ́ kɩ ǹ wɔ̀kɔ̀ yî kwel dibi. ");
INSERT INTO wib_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Képah ye, névi nɛ̂ náh mɛ ń pèpɛy nɛynɛ, ń pělnɛy ye tɛ̃̀nɛ. Névi nɛ̂ náh ńnɛ n yohnɩ n mɔ tùkènmɔnɔ sɔkɔ, tɛ̃̀ mɛ kárkɩ́nɔ́lɛ n pɩ.» ");
INSERT INTO wib_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","«Sétõ-à wil névi sɔkɔ, à n kyɩ gbɛ̃́nnɩ kɔ n kɔ̃, ǹ mɩ̀-ǹsah yah n kɔ̃. Wàh wɛ́-ńkɛ̃̂nɛ, à n yo ǹ gblɔ̌y tyɩ́ nɛ, páh sõ̀ wil ńyãh sɔkɔ, páh kɩ pé syɩ yuku nɛ́npɔ́. ");
INSERT INTO wib_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Wàh ǹ syɩ, à n kyɩ ǹ tɛ̃̀-ǹsah dyàh wɛ yàlntɔ̃nsàhnɔ́lɛ, plɛ́ntnɔɔ. ");
INSERT INTO wib_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Képah tɛ̃̀nɛ, sétõ mɛ̀ n kyɩ sé no sétã̀nnɔ́ kwǎrninɔ syah, nónó-á peke kal ǹmɔlɛ. Sè n kyɩ n de n tɛ̃ tɛ̃̀ sɔkɔ. Kàh pɩ sɛ̃́, tɛ̃̀ mɛ̀ dùkù ké syɩ n peke n kal ǹ gben tɛ̃̀nɛ.» ");
INSERT INTO wib_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Képah tɛ̃̀nɛ, Yesu-á mɛ képah yónɔ́ sɔkɔ, pi yɔ́ tɛ̃ tɔ́wû nɩyṍ sɔkɔ, tɛ́ yo mɔ ǹ tyɩ́ yĩ́npɔ̃́ ǹgbɛ̃nɛ nɛ, sê nɛ̂ fɔkɔ sɔkɔ-á à wil, tɛ́ ǹ yĩ́nɔ́ yĩ, yèvɩnɩ-á mɛ ǹ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ǹtɛ, Yesu mɛ yo pi tyɩ́: «Yèvɩnɩ ye pyě mɛ névye tyɩ́, nónó-á Liyel wɛynɛ n nohnɩ, tɛ́ ké tyilɛ n pɩ ké wɛ̃̀kɩ̀ yõ.» ");
INSERT INTO wib_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Képah sɔkɔ, névye-á pɔ n tuke n mɔ Yesu tnɔ̂, à tyah n yo nɛ: «Kwɛy gbĩ névyelɛ, nɛ́pêl ye pélɛ, pè mɛ gbǐl yɔ́lɛ n yah n kɔ̃. Ǹtɛ, kèyǎh ńtɛ̃ náh n pɩ pè wɛ̃kɩ n pi, à wil Liyel tɛ̃ntõ̀ syínyo-ò Yonasɩ tyɩ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Sɔ̃́-á Yonasɩ lésõ pɩ kwní yṍnmɔnɔlɛ Ninivi tãn tyɩ́, sɛ̃́ ó ye, Névi Pi tɔ kɩ pɩ kwní yṍnmɔnɔlɛ kwɛy gbĩ névye tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Pi nɛ̂-á lésõ yõ̀tɛ̃̀nɛ Saba sétáh yõ, à lésõ wil fɩ́ɩ́ sétáh yĩ̀n tyɩ́, à pɔ yõ̀tɛ̃̀ dĩ́ Salomo lékã́m wɛlɔ noh. Ǹtɛ gbɩ yõ, nɛy mɛ ásõ̂, nɛ̂-á kal Salomolɛ. Kǎh pɩ sɛ̃́, Liyel fṍ tukey tuke sṍlɛ, kénɛ yõ̀tɛ̃̀ pi kɩ yuku kwɛy gbĩ́ névye tyɩ́, kɩ lékàhlɛ pè kɔ̃. ");
INSERT INTO wib_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ànɛ̂ tɔ̃, Ninivi kwil tãn lésõ fɛ̃ syi Liyel wɛ̃̀kɩ̀ tɛ̃, Yonasɩ-á Liyel tɛ̃ntõ̀ yo pé tyɩ́. Ǹtɛ, nɛy mɛ ásõ̂, nɛ̂-á kal Yonasɩlɛ. Kǎh pɩ sɛ̃́, Liyel fṍ tukey tuke sṍlɛ, Ninivi kwil tãn kɩ yuku kwɛy gbĩ névye tyɩ́, kɩ lékàhlɛ pè kɔ̃.» ");
INSERT INTO wib_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","«Névi se kɩ fɔ̀tnɔ̀ soh wɔ̃bɩ, képah náh pɩ, kɩ dú kwĩnki mɔ ké yah? À náh kè sah n pi fɔ̀tnɔ̀ sahkɩ sɔkɔ, kyòo wɛ yĩnnɛ wɔ̀kɔ̀ sɔkɔ dépú tyɩ́ di? ");
INSERT INTO wib_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Sɛ̃́ ó ye, á yɩ̃́ ye á wil kyòolɛ. Á yɩ̃́-à mɛ plɛ, à wil tɔ pól n nɛ mɛ kyòo sɔkɔ. Tɛ́, á yɩ̃́-à mɛ plɛ́-ńkɛ̃̂nɛ, á wil pól n nɛ mɛ fɛ̃́ntũ̂ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Á gblɔ̌y kyɔmɩ yĩ́ĩ́, kyòo nɛ̂-á á sɔkɔ, kè káh nɛ mɛ fɛ̃́ntũ̂nɛ. ");
INSERT INTO wib_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Tɛ́ á wil pól-à mɛ kyòolɛ, fɛ̃́ntũ̂ tyah kɛ̃́nɛ ké sɔkɔ, á kɩ mɛ kyòolɛ, sɔ̃́-á fɔ̀tnɔ̀lɛ kyòo á tyɩ́.» ");
INSERT INTO wib_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesu-á wɛkɩ tɛ, Farisiyɛ̃ dĩ́ yɔ́ à ye yõke yõ yĩnnɛ ǹ gbô. Képah tɛ̃̀nɛ, pè de à tɛ̃ yõke yah. ");
INSERT INTO wib_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Farisiyɛ̃ mɛ̀-á Yesu wɛ, à tyah n yõ tɛ́ à náh ǹ gbã̀n wu Nsyifunɔ wu dùkùlɛ, kè ǹ gbã̀n du. ");
INSERT INTO wib_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Képah tɛ̃̀ sɔkɔ, Yesu mɛ yo ǹ tyɩ́: «Sɛ̃́ ó ye, yépi Farisiyɛ̃nɔlɛ, yě wóhlɔ́ ànɛ̂ yɛ̃́yṍvyɔ náhlɔ́ wu n tɔ̃ n sah, tɛ́ yé fɔkɔ táhlɔ́ n nɛ n mɛ yúkúnɔ́lɛ pèkè, ànɛ̂ yɩ̃be dékè tyilɛ. ");
INSERT INTO wib_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Lékã́m kɛ̃́ névye nɔ́pi, nɛ̂-á mɔ vyɔ́ náhlɔ́lɛ, à náh sé sɔkɔ táhlɔ́ tɔ mɔ di? ");
INSERT INTO wib_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Yé sé sɔkɔ táhlɔ́ yî yɩ̃ yãm tãn kɔ̃! Képah-à pɩ, sé pól kɩ pɩ pallɛ yé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Yépi Farisiyɛ̃nɔlɛ, pèkè mɛ yé yõ! Yě yímɩ̂ ànɛ̂ swãh sɔkɔ pɛ̃́nfěnè pól gbãm-ònɔ́lɛ Liyellɛ n kɔ̃. Ǹtɛ, yě n yahle tɔ̃́nsàhnpɩnɔlɛ névye tyɩ́, ànɛ̂ Liyel tyɩ́ náh nɔ yé tyɩ́. Képah nɛ̂ tɔ-á sõ̀ yé yɩ̃nɛ yè nɛ n pɩ gbõ̀nwɔ̀kɔ̀ kɛ̃́nɛ. ");
INSERT INTO wib_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Yépi Farisiyɛ̃nɔlɛ, pèkè mɛ yé yõ! Yě tɛ̃̀-ǹtã̀n gbrolɛ n yah n kɔ̃ Liyel ní-ńtã̂n vɩ̀ sɔkɔ, ǹ tɛ́ nɛ mɛ ké tyɩ́ nɛ, névye nɛ n tɔ̃ n sah n wɛkɩ n pɔ yé tyɩ́ tɔ́wû tɛ̃̀-ǹtã̀n sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Pèkè mɛ yé yõ, yépi nónó-á mɛ á kɩ nɛ, léyã̂l nírínɔ́ sɔ̃́, névye n nɛ n kɔ sé yõ, pɩ̃́-ńkɛ̃̂nɛ.» ");
INSERT INTO wib_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Yesu-á yo sɛ̃́, Liyel ǹgbò wɛ̃̀kɩ̀ kwɔ́-ò yɔ́ à syah nɛ, kwɔ́-ò dĩ́, wǎh mɛ n wɛkɩ sɔ̃́, pépi tɔ-á à n gbyɔ dɛ́! ");
INSERT INTO wib_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","À mɛ yo ǹ tyɩ́: «Yépi Liyel ǹgbò wɛ̃̀kɩ̀ kwɔ́pú tɔlɛ, pèkè mɛ yé yõ! Yépi nónó-á ńkɛ̃́nɛ no twah n mɔ tɔ́kɔ́pêllɛ, tɛ́ yé náh n fɛ̃ n syi n so n mɔ pé tyɩ́ kèngbɔ núkú fyélɛ. ");
INSERT INTO wib_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Pèkè mɛ yé yõ, yépi nónó-á Liyel tɛ̃ntõ̀ syínyopu léyã̂llɛ n tɔ̃ n sah n mɔ, tɛ́ yépi náh tãn ye mó tɔ̃ ko mɔ pélɛ. ");
INSERT INTO wib_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Képah n wɛ̃kɩ nɛ, yáh yé súbí tyípɩ́nɔ́ fɛ̃ syi. Pépi-á Liyel tɛ̃ntõ̀ syínyopu ko mɔ, tɛ́ yépi sɔ̃́npɩ́ pé léyã̂llɛ n tɔ̃ n sah n mɔ. ");
INSERT INTO wib_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Képah ye sõ̀ Liyel yo lékã́m sɔkɔ nɛ ńkɛ̃́: ‹Mé kɩ tɛ̃ntõ̀ syínyopu tɛkɩ mɔ pè kɔ̃, ànɛ̂ tɛ̃̀ntõbelɛ. Pè kɩ pé túkù ko mɔ, tɛ́ kɩ túkù fõh.› ");
INSERT INTO wib_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Kǎh pɩ sɛ̃́, Liyel kɩ kwɛy gbĩ névye fõh n pi Liyel tɛ̃ntõ̀ syínyopu nɔ́pi yĩnnɛ, nónó-á ko mɔ kèkõyṍ mɔ gbĩ́ dukulɛ, ");
INSERT INTO wib_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","à tɔkɔ Abɛlɩ kònmɔnɔ tyɩ́, à pɔ syɩ Nsakarɩ kúnɔ́ tyɩ́, nɛ̂-á ko mɔ sárká wìlkì-ǹsah, ànɛ̂ Liyel ní-ńsah wɔ̀kɔ̀ ǹgbɛ̃ wrɔ́. Gbɩ yõ, mé kélɛ n yo yé tyɩ́ nɛ: kwɛy gbĩ névye kɩ n fõh n pi képah yĩnnɛ. ");
INSERT INTO wib_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Pèkè mɛ yépi Liyel ǹgbò wɛ̃̀kɩ̀ kwɔ́pú yõ, yépi nónó-á Liyel wɛ̃̀kɩ̀ wɛ́npɩ̃nɔ yah kõ névye tyɩ́. Yépi náh mɛ n kɔ kélɛ, tɛ́ nónó-á se nɛ, pé nɛ n kɔ kélɛ, yé pépi yĩni mɔ.» ");
INSERT INTO wib_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Képah sɔkɔ, Yesu wìlntɛnɔ náh nɛ́npɔ́, Liyel ǹgbò wɛ̃̀kɩ̀ kwɔ́pú, ànɛ̂ Farisiyɛ̃nɔ pé fɔkɔ vyãh ǹnɛ kègbɩlɛ, tɛ́ tyah ǹnɛ n piki n yah tyi duke duke pól yõ. ");
INSERT INTO wib_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Pè sõ̀ mɛ ǹnɛ n mɔ n yah nɛ, à pilki ǹ vyãh wɛlɔ sɔkɔ pé kɔ̃ pé à wɛ tɛ̃. ");
INSERT INTO wib_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Képah sɔkɔ, nɛ́kwĩ́nkí-á tuke mɔ tnɔ́nɔ́lɛ gbĩ́ nɛ̂nɛ fɔ́ɔ́, mɛ wɛ̃ gbyẽ̂hnɛ n suki, Yesu tyah n yo ǹ tõ̀ sã́hpú ǹgbò tyɩ́: «Yé yé gblɔ̌y tɛ̃ Farisiyɛ̃nɔ vyɛ̃́nnínì wɛ́kɩ́nɔ́lɛ, képah nɛ̂-á n tɔ̃ n mɔ kɔ́kɔ́nɔ́ tyɩ́ kɔ̃lɛ mífã́hkɩ̀ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","3","Tyi nónó pól-á yé n yo fɛ̃́ntũ̂ sɔkɔ, sè kɩ pɔ noh gbĩ̀ntɔ̃̀lɛ kyòo yah. Ànɛ̂ nónó pól-á yé n plɔ n yo wɛ̃ níkílɔ́ yey, wɔ̀kɔ̀ sɔkɔ táh, sé pól kwní kɩ pɔ kɔ̃ gbɛ̃́ntĩ̂n yõ. Képah ye, tyípǐl yɔ́ ńtɛ̃ náh mɛ, nɛ̂-á kɩ n wũ n pi wìlkìnmɔ-ńkɛ̃̂nɛ. Sètĩ̀n sõ̀ tir yɔ́ ńtɛ̃ náh mɛ, nɛ̂-á kɩ n wũ n pi pɩ̃́-ńkɛ̃̂nɛ.» ");
INSERT INTO wib_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","«Mé kélɛ n yo yé tyɩ́ nɛ, yépi nónó-á ń kódíbílɛ: yé káh névye yah tíkílɛ n pɩ, nónó-á wil kɔ̀ ólɛ n ko n mɔ n pnɛ, tɛ́ pè náh tɔ̃ tir yɔ́lɛ n pɩ n kah n mɔ n pnɛ képah yõ. ");
INSERT INTO wib_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Nɛ̂ yah tíkí-á yɩ̃nɛ pɩ́nɔ́lɛ, mé kɩ ǹnɛ yé wɛ̃kɩ: Liyel nɛ̂-á kɩ fɛ̃ névi wil kɔ̀ kònmɔntɛnɔ náh, kɩ ǹ min dah mɔ tyɛ́-ńkɛ̃̂ nyàh sɔkɔ, yé ǹmɔ tíkílɛ n pɩ. Mé kélɛ n yo yé tyɩ́ nɛ ńkɛ̃́: yé tɛ̃̀ wɔ tíkílɛ n pɩ. ");
INSERT INTO wib_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ǹtɛ̃̀npînɔ́ kwlɔ náh n yãm pɔ́píkí plɔ́ nínɔ́lɛ di? Ǹtɛ, Liyel dyɔ náh n fwɔ sépi núkú yɔ́ ńtɛ̃ tyɩ́lɛ. ");
INSERT INTO wib_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","À wil képah sɔkɔ, yé yõ̀yén ńtɛ̃ pól dan mɛ pɩ̃́nɔ́lɛ Liyel tyɩ́. Kǎh pɩ sɛ̃́, yé káh tíkí pɩ. Yépi tyɩ́ náh tah kal ǹtɛ̃̀npî kwĩnkilɛ di?» ");
INSERT INTO wib_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Képah náh, Yesu tɔ̃ yo pé tyɩ́: «Mé kélɛ n yo yé tyɩ́ nɛ: nɛ̂-à kè yo dal mɔ névye yĩ́ yah nɛ ńkɛ̃́, páh mɛ ńmɔ tyɩ́ yõ, Névi Pi tɔ kɩ kè yo Liyel yĩ̂nyõ tɛ̃ntõnè yĩ́ yah nɛ ńkɛ̃́, wǎh mɛ pé tyɩ́ yõ. ");
INSERT INTO wib_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ǹtɛ, nɛ̂-à ń yahle névye yĩ́ yah, Névi Pi tɔ kɩ à yahle Liyel yĩ̂nyõ tɛ̃ntõnè yĩ́ yah. ");
INSERT INTO wib_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Névi nɛ̂-à Névi Pi yĩ́npo yo, kè kɩ yɔ̃ mɔ tɛ̃̀ kɔ̃. Tɛ́ nɛ̂ tɛ̃̀ wɔ-à Liyel Mírkí gbyɔ, kè náh n yɔ̃ n mɔ n pi ǹ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","12","Pàh yé tɛ̃ kyɩ tùkè-ǹsah Liyel ní-ńtã̂n vɩ̀ sɔkɔ, képah náh pɩ, yah tãm tyɩ́, képah náh pɩ, yõ̀tãm tyɩ́, Liyel Mírkí kɩ yé kwɔ nɛ́npɔ́ swɔ, yáh nɛ nɛ̂ yo n pi. Képah ye, yé káh yɛ yé yáh-ńsah tyɛ, yáh nɛ n yo n wil n pi sɔ̃́.» ");
INSERT INTO wib_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Tɔ́wû nɩyṍ sɔkɔ, ǹnɩ̂ Yesu syah nɛ, pé kwɔ́-ò dĩ́, à yo pé nɛ́nkyɩ́ dĩ́ tyɩ́ nɛ, à yɛ pé pé sú gbɛ̃kɩ dibi. ");
INSERT INTO wib_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Képah tɛ̃̀nɛ, Yesu mɛ yo ǹ tyɩ́: «Ń dĩ́, nɛ̂ sah ńnɛ nɛ, mé yélɛ n tuke, tĩ̂ nɛ, mé yé gbã̀n yîlɛ n dibi?» ");
INSERT INTO wib_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Képah sɔkɔ, tɛ́ yo pé tyɩ́: «Yé yé kyɔmɩ tahrɩ dékè képékèlɛ! Tahrɩ-à sɔ̃́ mɛ sɔ̃́ névi tyɩ́, képah náh fɛ̃ minnɛ à kɔ̃ n pi.» ");
INSERT INTO wib_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Képah sɔkɔ, à tɔ̃ sèmìrkì yɔ́ yãh pé tyɩ́ nɛ: «Tàh dĩ́ yɔ́ lésõ mɛ, ǹ swãh pɛkɩ yĩ́ĩ́ ǹ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Képah tɛ̃̀nɛ, à tyah n sõ ǹ fɔkɔ sɔkɔ nɛ, ǹtɛ, sèmukɔ mɔ́-ńsah náh se mɛ fwɔ́ɔ pé tyɩ́, sɔ̃́ se pé kɩ pɩ nɩ? ");
INSERT INTO wib_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Dǒ, à nɛ, páh kɩ nɛ̂ pɩ n pi, képah á yɔ̀: Páh kɩ pé díké sɔkɩ, tɛ́ kɩ sè tɔ̃ mɔ gblò gblò, kɩ pé gbã̀n yî pól mɔ sé sɔkɔ, ");
INSERT INTO wib_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","tɛ́ kɩ yo pé gblɔ̌y tyɩ́ nɛ, páh yɔ̀, yõke dò-á mɛ pé tyɩ́ pé gbõ̀ sõ̀ ye náhnáh yĩnnɛ. Núkúnúkú, páh kɩ n mɩ, tɛ́ kɩ n yõ, tɛ́ kɩ n wɔ, tɛ́ kɩ nɩ̀vɩ̀lɛ n pɩ pé dyɔlɛ. ");
INSERT INTO wib_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ǹtɛ, Liyel mɛ yo ǹ tyɩ́: ‹Lékã́m kɛ̃́ névi! Kwɛy lékã̂h ńtɛ̃ sɔkɔ á min kɩ n syi n pi á tyɩ́. Tɛ́ yî nónó-á á tuke mɔ sah, sè kɩ pɩ nɛ̂ tyɩ́lɛ?› ");
INSERT INTO wib_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Képah sɔkɔ, Yesu nɛ: «Névi nɛ̂-à tahrɩlɛ n yah n koh n sah ǹ gblɔ̌y tyɩ́lɛ, tɛ́ Liyel fṍ tyɩ́ yáhnɔ́ yahle, sɛ̃́ntɛ̃̀ ye n nɔ tɛ̃̀nɛ!» ");
INSERT INTO wib_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","23","Képah náh, Yesu yo ǹ tõ̀ sã́hpú tyɩ́: «Névi min tyɩ́ náh tah kal yõkelɛ, wil tyɩ́ mɛ tah kal flɔlɛ di? Képah ye, mé kélɛ n yo yé tyɩ́ nɛ: yé káh yé fɔkɔlɛ n sõ, yáh nɛ wɛ n yõ n pi sɔ̃́, ànɛ̂ yáh nɛ yé wil flɔ wɛ n mɔ n pi sɔ̃́. ");
INSERT INTO wib_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Yé yah ǹgbɔ̃lɔlɛ kɛ̀: Sè náh sèmukɔlɛ n duku, sè náh sèmukɔlɛ n tɔkɔ. Díké ànɛ̂ sèmukɔ kóhnsàh-ǹtã̀n tɔ náh mɛ sé tyɩ́, tɛ́ Liyel sélɛ n pu. Ǹtɛ, yépi tyɩ́ náh tah kal kèpyelɛ di? ");
INSERT INTO wib_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Yépi sɔkɔ, nɛ̂ tɛ̃̀ kɩ fɛ̃ kwéyy ńtɛ̃ fyé dohnɩ ǹ min wɛ́nɔ́ yõ ǹ fɔ́kɔ́sõnɔ gbõ̀ yõ? ");
INSERT INTO wib_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Tɛ̃́nwɛnɔ-à mɛ́-ńkɛ̃̂nɛ yé tyɩ́, à fɛ̃ sɛ̃́ntɛ̃̀ tir tyɩ̃́ɩ̃ ńtɛ̃ fyé pɩ n pi, sɔ̃́ pɩ, tɛ́ yé yé fɔkɔlɛ n sõ yî tɛ́lɔ́ tyɩ́ sɔkɔ? ");
INSERT INTO wib_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Yé fílfĩ pɩ dùkùlɛ n yah kɛ̀: Sè náh tõ̀lɛ n pɩ, sè náh flɔlɛ n tĩ. Ǹtɛ, mé kélɛ n yo yé tyɩ́ nɛ: yõ̀tɛ̃̀ Salomo ńtɛ̃nɛ ǹ tahrɩ pól sɔkɔ, à náh flɔ pèplɔ wɛ mɔ yah fílfĩ nɔ́pi sɔkɔ yɔ́ ńtɛ̃ kètɔ̀lɛ. ");
INSERT INTO wib_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Fílkì nɛ̂ wɔ-á gbɛ̃́nnɩ sɔkɔ kwɛynɛ, tɛ́ kɩ pɔ n sukɛ n pi ńsõ̂nɛ, Liyel-á képah fĩ pɩ pallɛ sɛ̃́, à náh n yah n dah n mɔ n pi yépi flɔ tyɩ́ sɔkɔ à kal sépilɛ di, Liyel yõ sɛ̃́nyĩ-ńkɛ̃̂pú nɔ́pi? ");
INSERT INTO wib_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Kǎh pɩ sɛ̃́, yé káh yé gblɔ̌ynɛ n kwlɔ yé yõke, ànɛ̂ yé wɔ wɔ yî yáhnkɔ̃nɔ tyɩ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kèkõyṍ mɛ̀ sɔkɔ, Liyel pɩ̃́-ńkɛ̃̂ névye ye ńkɛ̃́nɛ nɛ n yah n kɔ̃ sépi póllɛ tyɛ́-ńkɛ̃̂nɛ. Ǹtɛ, yépi tɛ̃̀ wɔlɛ, yé sú Liyel pɩ̃ nɛ, sé yétõ̂-á mɛ yé tɛ̃. ");
INSERT INTO wib_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Kǎh pɩ sɛ̃́, yé Liyel tɔ̃́rɩ́ ǹgbò yah n kɔ̃! Képah sɔkɔ, à kɩ yî tɛ́lɔ́ dohnɩ yé kɔ̃. ");
INSERT INTO wib_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Kè ye nɔ yé sú tyɩ́, à ǹ tɔ̃́rɩ́lɛ yé kɔ̃. Képah ye, yé káh tíkí pɩ, tũ̀npir yípɛ̂y! ");
INSERT INTO wib_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Yé yé gbã̀n yî yãm, yé mó sé yɩ̃ yãm tãn kɔ̃. Yé tahrɩlɛ n yah n sah Liyel fṍ, képah nɛ̂-á kè náh n yɩkɩ, kè náh se n tyɛ. Yɩ̃́pú náh fɛ̃ n kyɩ nɛ́npɔ́, sóhrɩ́ tɔ náh fɛ̃ sè yõ. ");
INSERT INTO wib_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Sɛ̃́ ó ye, á tahrɩ-à mɛ ńyãh, á sõnɔ tɔ n nɛ n mɛ nɛ́npɔ́.» ");
INSERT INTO wib_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","«Yé nɛ mɛ yé vi sah tõ̀ pɩ pɩ tɛ̃̀nɛ, yé mó yé knɔ fɩ̃ mɔ, yé fɔ̀tnɔ̀nɔ́ mó nɛ mɛ kõ̀ntɛ̃̀nɔ́lɛ. ");
INSERT INTO wib_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Yé nɛ mɛ á kɩ nɛ tõ̀npɩbɩ sɔ̃́, nónó-á ńkɛ̃́nɛ mɛ pé yõ̀tɛ̃̀ syɩ́kɩ́ntɛ̃̀nɔ́ sɔkɔ nɛ, wàh kɩ wil fúr pɩ́-ńsah, à pɔ n de, tɛ́ kɩ fyɔ̀ wɔ̀kɔ̀ yah mɩ, pé núkú kè yɩkɩ mɔ à kɔ̃. ");
INSERT INTO wib_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Yèvɩnɩ mɛ pé yõ, tõ̀npɩbɩ nónó yõ̀tɛ̃̀-à ǹ syɩ pɔ pè wɛ, pè mɛ yáhnɔ́ sɔkɔ. Kègbɩ yõ, mé kélɛ n yo yé tyɩ́ nɛ: yõ̀tɛ̃̀ mɛ̀ kɩ ǹ tõ̀ pɩ pɩ flɔ mɔ, tɛ́ kɩ yõkelɛ pè kɔ̃ pè kɩ yõ. ");
INSERT INTO wib_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Tɛ́ wàh se mɛ n syɩ pɔ lénɩlɛ, képah náh pɩ, tyah dal gbĩ́nɛ, tɛ́ pè mɛ ǹ syɩ́kɩ́nɔ́ sɔkɔ, yèvɩnɩ mɛ pé yõ! ");
INSERT INTO wib_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Yépi ńtɛ̃ pɩ̃ nɛ, gbóntɛ̃̀ dĩ́-à pɩ̃ gbĩ́ nɛ̂-á yɛ̃́nwó kɩ n pɔ n pi ǹ tyɩ́, à náh n yɛ à kɔ̃ à n wɛ n de n pi ǹ gbô. ");
INSERT INTO wib_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Névi Pi kɩ n pɔ n pi gbĩ́ nɛ̂-á yé náh mɛ ǹ pɔ́nɔ́ tyɩ́lɛ n sõ. Képah ye, yépi tɔ yé gblɔ̌y vi sah.» ");
INSERT INTO wib_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Képah sɔkɔ, Pyɛrɩ Yesu syah nɛ, pé Yõ̀tɛ̃̀, pépi ó yĩn se à n yãh sèmìrkì mɛ̀nɛ, tĩ̂ no pól yĩn se nɩ? ");
INSERT INTO wib_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","À mɛ yo ǹ tyɩ́: «Gbô tahrɩ kyɔ̀mɩ̀-ò nɛ́gbɩ́ lékã́m névilɛ, nɛ̂ mɛ? Ǹmɔ pɩ névilɛ, nɛ̂-á ǹ yõ̀tɛ̃̀ dĩ́ kɩ à pɩ ǹ kéte kyɔ̀mɩ̀-òlɛ. Tɛ́ à kɩ tõ̀npɩbɩ tɛ́lɔ́ yõkelɛ pélɛ n kɔ̃ ké kɔ̃ gbĩ́nɛ. ");
INSERT INTO wib_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Yèvɩnɩ mɛ ǹ tõ̀npɩ mɛ̀ tyɩ́, yõ̀tɛ̃̀ dĩ́-à ǹ syɩ pɔ à wɛ à mɛ kénɛ tõ̀lɛ n pɩ. ");
INSERT INTO wib_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Kègbɩ yõ, mé kélɛ n yo yé tyɩ́ nɛ: wǎh kɩ à pɩ ǹ gbã̀n yî pól kyɔ̀mɩ̀-òlɛ. ");
INSERT INTO wib_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ǹtɛ, tõ̀npɩ mɛ̀-à tyah n sõ ǹ fɔkɔ sɔkɔ nɛ ńkɛ̃́, pé yõ̀tɛ̃̀ dĩ́-á kɩ mo pɔ́-ńsah, tɛ́ tyah pé no tõ̀npɩbɩlɛ n ko, pé syɔ́, pé díbí, tɛ́ mɛ n yõ, mɛ wɔ wɔ yîlɛ n wɔ, à sètɛ̃̀nɩ̀nɛ n pɩ, ");
INSERT INTO wib_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","yõ̀tɛ̃̀ dĩ́ kɩ pɔ ǹ yõ dɔkɔ sṍ yɔ́lɛ, à náh mɛ nɛ̂ sõ sah, ànɛ̂ gbĩ́ yɔ́ sɔkɔ, à náh nɛ̂nɛ n pnɛ. À kɩ pɔ à fõh képékèyɔ̂, tɛ́ kɩ à dyah Liyel tyɩ́ yáhlepu dyah dùkùlɛ. ");
INSERT INTO wib_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ǹmɔ nɛ̂-á ǹ yõ̀tɛ̃̀ dyɔ yĩ́ĩ́nɛ n pnɛ, tɛ́ à náh ǹ gblɔ̌y vi à képahlɛ n pɩ, à kɩ ko náhnáh wɛ. ");
INSERT INTO wib_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ǹtɛ, névi nɛ̂-á sõ̀ mɛ kè pɩ ǹpɩ̃́-ńkɛ̃̂ sɔkɔ, tɛ́ yɩ̃nɛ ko syínɔ́lɛ, ǹmɔ kɩ ko kwéyy wɛ. Pàh névi nɛ̂ kɔ̃ náhnáh, náhnáh kɩ yah kɔ̃ tɛ̃̀ tyɩ́. Ànɛ̂ náhnáh-à névi nɛ̂ gbõ̀ dahbɩ, náhnáh tyɩ́ kɩ piki yah kal tɛ̃̀ tyɩ́.» ");
INSERT INTO wib_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Képah náh, Yesu tɔ̃ nɛ: «Nyàh ye mé pɔ sétáh yõ. Tɛ́ mé sõ̀ mɛ ké tyɩ́ nɛ, kè nɛ mɛ kõ tɛ! ");
INSERT INTO wib_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ńmɔ yɩ̃nɛ mè n de n wil yèvyãhrɩ yɔ́ sɔkɔ, tɛ́ kè náh se mɛ n pi! ");
INSERT INTO wib_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Yé se mɛ n sõ nɛ, yèvɩnɩ-á mé pɔ mɔ́-ńsah sétáh yõ? Ɔ̃́ɔ̃ dɛ́! Mé kélɛ n yo yé tyɩ́ nɛ: gbɛ́kɩ́nɔ́ wɔ-á pyě. ");
INSERT INTO wib_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Képah ye, à tɔkɔ núkúnúkú tyɩ́, nɛ́pĩ̂ kwâl-à mɛ kéte núkú sɔkɔ, pè kɩ gbɛkɩ: Tɔ̃́mɩ́ kɩ tyah nímínɛ n fwo, nímí kɩ tyah tɔ̃́mɩ́nɛ n fwo. ");
INSERT INTO wib_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Sú yɔ́ kɩ tyah ǹ pídĩ́nɛ n fwo, pídĩ́ yɔ́ kɩ tyah ǹ súlɛ n fwo. Yṹ yɔ́ kɩ tyah ǹ písêlɛ n fwo, písê yɔ́ kɩ tyah ǹ yṹnɛ n fwo. Yṹ yɔ́ kɩ tyah ǹ pídĩ́ kyɩlɛ n fwo, pídĩ́ kyɩ yɔ́ kɩ tyah ǹ pɛ yṹnɛ n fwo.» ");
INSERT INTO wib_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu tɔ̃ sõ̀ mɛ n yo tɔ́wû tyɩ́: «Yĩ̂nyõ yah yɔ́ mɛ, yâh ńyĩ́rkì wɛ ké nɛ́npɔ́lɛ, yé n yo nɛ́npɔ́ swɔ nɛ, pũ̀-á kɩ pɩ. Tɛ́, kè n mó n pɔ n pɩ sɛ̃́. ");
INSERT INTO wib_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ànɛ̂ yah yɔ́ mɛ, yâh fyɔ̀ yã́hkɩ́ wɛ kè kõ wil nɛ́npɔ́lɛ, yé n nɛ, tyah vyã́hnɔ́ képékè-á kɩ tyah. Tɛ́, kè n mó n pɔ n pɩ sɛ̃́. ");
INSERT INTO wib_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Yĩ́nvǐ névye nɔ́pi! Yé fɛ̃ sétáh ànɛ̂ yĩ̂nyõ dùkù wɔlɛ n pnɛ. Tɛ́ sɔ̃́ pɩ, tyi nónó-á n pɩ kwɛy gbĩnɛ, yé náh fɛ̃ sépi pɩ̃?» ");
INSERT INTO wib_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","«Kwâh nɛ̂ pɩ, tɛ́ yé náh pɩ dùkù pèpɛynɛ n sõ n tɛ̃ n pnɛ yé gblɔ̌y? ");
INSERT INTO wib_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Sɔ̃́-á, tir-à mɛ yé wrɔ́ ànɛ̂ á ní-òlɛ, tɛ́ à ǹ tɛ̃ n yuku tùkè-ǹsah tukey tùkè-ò tyɩ́, gbah n tɛ̃ tir mɛ̀ yah wah wɛ̃̀kɩ̀ yah. Képah-à pɩ́-ńkɛ̃̂nɛ, tɛ́ à kyɩ álɛ tukey tùkè-ò gbõ̀ dahbɩ, tukey tùkè-ò mɛ kyɩ álɛ sràsyíbí tyɩ́, tɛ́ pépi mɛ ǹ dah mɔ wɔ̀kɔ̀npèkè sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Mé kɩ kè yo dal mɔ á tyɩ́ nɛ, á náh n wil n pi nɛ́npɔ́, nɛ́ á náh kɔ̃lɩ mɛ̀ pól dyah tɛ pnɛ́pnɛ́.» ");
INSERT INTO wib_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Légbĩ́ mɛ̀-ó sɔkɔ, nósyɔ́ pɔ yo Yesu tyɩ́ nɛ, yõ̀tɛ̃̀ Pilatɩ-á lésõ Kalile tãn yísyɔ́ ko mɔ, tɛ́ pè sah sárká wìlkìnɔ́ sɔkɔ, pé tṍ kwɛ fɛ̃kɩ sárká tṍ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Képah sɔkɔ, à mɛ pè syah nɛ: «Yé se mɛ n sõ nɛ ńkɛ̃́, Kalile tãn nɔ́pi-á tyípêl pɩ kal pé kwil tãn póllɛ, tɛ́ yĩ mɛ̀ pè nɔ? ");
INSERT INTO wib_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ɔ̃́ɔ̃ dɛ́! Mé kélɛ n yo yé tyɩ́ nɛ: yâh Liyel wɛ̃̀kɩ̀ tɛ̃́-ńkɛ̃̂nɛ, yé pól tyɩ́ kɩ n yɩkɩ n pi sɛ̃́. ");
INSERT INTO wib_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ànɛ̂, Silowe wɔ̀kɔ̀ kèyy-á syɩkɩ tũ nɛ́pĩ̂ gbɔ̃nkwǎrtɔ̃mɩ nónó yõ, à pè ko, yé se mɛ n sõ nɛ ńkɛ̃́, pépi pèkè pɩ́nɔ́-á kal Yerusalɛmɩ kwil tãn pól tyɩ́lɛ? ");
INSERT INTO wib_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ɔ̃́ɔ̃ dɛ́! Mé kélɛ n yo yé tyɩ́ nɛ: yâh Liyel wɛ̃̀kɩ̀ tɛ̃́-ńkɛ̃̂nɛ, yé pól tyɩ́ kɩ n yɩkɩ n pi sɛ̃́.» ");
INSERT INTO wib_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Képah náh, Yesu tɔ̃ sèmìrkì yɔ́ yãh nɛ: «Dĩ́ yɔ́ tyɩ́ sènsóké séswɔ̂ sõ̀ mɛ ǹ dìvɛ̃ sésân swãh sɔkɔ. Wǎh pɔ ké pye yáhnkɔ̃-ńsah, à náh kwâh yɔ́ wɛ ké sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","À mɛ yo ǹ swãh tɔ̃́-ò dĩ́ tyɩ́ nɛ, à yah, ké ye tɔ̃́-ò-á yɔ̀, pé mɛ pyelɛ n yah n kɔ̃ n pɔ sènsóké mɛ̀ sɔkɔ, tɛ́ pé náh mɛ kwâh yɔ́ ńtɛ̃nɛ n wɛ ké sɔkɔ. Ńkɛ̃́, à kè kõ fɛ̃! Yõ se tɔ̃ mɛ ké tyɩ́ kè tɛ̃ sétáhlɛ n wal nɩ? ");
INSERT INTO wib_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Wǎh yo sɛ̃́, dĩ́ mɛ̀ à syah nɛ, pé yõ̀tɛ̃̀ dĩ́, à yɛ ké yõ ńtɔ̃, kè kwɛtyɩ́ pɩ. Páh kɩ swɔ gbɔ kè kore vi, tɛ́ kɩ tũ̀ mɔ ké sõ̀. ");
INSERT INTO wib_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Kàh pɩ sɛ̃́, gbɔ̀kénpɩ gbĩ́ yɔ́lɛ, kǎh kɩ syi. Képah-à pɩ́-ńkɛ̃̂nɛ, à kè fɛ̃.» ");
INSERT INTO wib_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Mɩ mɩ yòh sṍ yɔ́lɛ, Yesu sõ̀ mɛ névyelɛ n kwɔ Liyel ní-ńsah wɔ̀kɔ̀ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Tɛ́, pi yɔ́ sõ̀ mɛ nɛ́npɔ́ sétõlɛ ǹ sɔkɔ, mɛ à pɩ nɛ́dôlɛ fɔ́ɔ́, ye gbɔ̃nkwǎrtɔ̃nɔ. À sõ̀ mɛ kɔ̀ntɛ̃̀nɔ́lɛ, tɛ́ à náh fɛ̃ ǹ tɔrɩ n tɛ n pi. ");
INSERT INTO wib_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesu-á pi mɛ̀ wɛ sɛ̃́, à à ye tɛ́ yo ǹ tyɩ́: «Pi, á ye dɛ́nmɔnɔ wɛ á dónɔ́ yam sɔkɔ.» ");
INSERT INTO wib_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Tɛ́ mɛ ǹ gbã̀n sah ǹ yõ. Nɛ́npɔ́ swɔ, à núkú ǹ tɔrɩ tómm tɛ́ tyah Liyellɛ n gbilki. ");
INSERT INTO wib_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Képah sɔkɔ, pi mɛ̀-á dɛ́nmɔnɔ wɛ sɛ̃́ mɩ mɩ yòh sṍlɛ, kè Liyel ní-ńsah wɔ̀kɔ̀ yõ̀tɛ̃̀ fɔkɔ vyãh. À mɛ yo tɔ́wû tyɩ́ nɛ, sèpĩ̀n kénúkò-á tõ̀ pɩ pɩ sèpĩ̀nnɛ. Pǎh sõ̀ yɩ̃nɛ pè pɔ à kɔ̃ à pè dɛ mɔ kénɛ sèpĩ̀n ó sɔkɔ. Ńkɛ̃́, pè náh yɩ̃nɛ pè pɔ mɩ mɩ yòh sṍ tɔlɛ. ");
INSERT INTO wib_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Wǎh yo sɛ̃́, Tɛ̃̀ ǹgbɛ̃ yo ǹ tyɩ́: «Yĩ́nvǐ névye nɔ́pi! Mɩ mɩ yòh sṍlɛ, yé nɛ́núkù núkú pól náh ńkɛ̃́nɛ yé nyeh, képah náh pɩ, yé ńkwɛ̃́ndyɩ́nɩ̀ dɛ sé yõke krótónè tnɔ̂, ǹ kyɩ sè kɔ̃ sě ni wɔ di? ");
INSERT INTO wib_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Tɛ́ pi mɛ̀nɛ, nɛ̂-á Abrahmɩ náh nɛynɛ, sétõ pukubi sah pópó, ye gbɔ̃nkwǎrtɔ̃nɔ, ǹmɔ náh sõ̀ yɩ̃nɛ dɛ́nmɔnɔlɛ kénɛ púkúbínɔ́ sɔkɔ mɩ mɩ yòh sṍlɛ kɛ̀!» ");
INSERT INTO wib_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Képah tɛ̃̀nɛ, Yesu wɛy mɛ̀ sennɛ ǹ fwópú pól tɛ̃, tɛ́ tɔ́wû pól sõ̀ mɛ nɩ̀vɩ̀ sɔkɔ Yesu tyísnɔ́ nɔ́pi pól pɩ́nɔ́ yĩnnɛ. ");
INSERT INTO wib_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Képah náh, Yesu tɔ̃ nɛ: «Liyel tɔ̃́rɩ́lɛ, kè mɛ kwâh nɛ̂ tɔ? Mé kɩ kè tɔkɔ sãh kwâh nɛ̂nɛ? ");
INSERT INTO wib_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Kè mɛ tyɩ̃́ɩ̃, á kɩ nɛ séswɔ̂ yɔ́ pi sɔ̃́, nɛ̂-á pè n ye mútárdɩ̀lɛ: Dĩ́ yɔ́ tɔkɔ, à duku ǹ swãh. Kè fi pɩ séswɔ̂lɛ, tɛ́ kèpye pɔ sé syɛ̀ pɩ ké yɩ̃̀ngbã̀n tyɩ́.» ");
INSERT INTO wib_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Tɛ́, tɔ̃ nɛ: «Mé kɩ Liyel tɔ̃́rɩ́ tɔkɔ sãh kwâh nɛ̂nɛ? ");
INSERT INTO wib_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Kè mɛ á kɩ nɛ kɔ́kɔ́nɔ́ sɔ̃́, sê yɔ́ tɔkɔ mɔ fãh dú yɩ̃́ tɔ̃́nɔ́ mi sɔkɔ ké pól kɔ̃ kè dɔkɔ.» ");
INSERT INTO wib_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Képah náh, Yesu mɛ yɔ̃ sɔkɔ n yuku Yerusalɛmɩ, tɛ́ névyelɛ n kwɔ n yuku, wǎh n kah kwlo ǹgbnɔ ànɛ̂ kwlo pî nónó sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Képah sɔkɔ, ǹnɩ̂ yɔ́ mɛ à piki yah nɛ, pé Yõ̀tɛ̃̀, névye kwéy ó se kɩ de Liyel tɔ̃́rɩ́ sɔkɔ nɩ? À mɛ pè syah nɛ: ");
INSERT INTO wib_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Mé kélɛ n yo yé tyɩ́ nɛ: névye náhnáh kɩ syɔ̃̀-ǹsah yah kɔ̃ nɛ, pé wɛ n de Liyel tɔ̃́rɩ́ tyah sɔkɔ nɛ̂ dé-ńsah-á mɛ fɩ̃́ɩ̃, tɛ́ pè náh fɛ̃ n tɛ̃. Képah ye, yé gbah n tɛ̃ n wɛ n de ké sɔkɔ! ");
INSERT INTO wib_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Gbóntɛ̃̀ dĩ́-à pópó pɔ yuku wɔ̀kɔ̀ yah tɛ̃ mɔ, tɛ́ yé mɛ kégbɔ́, yé kɩ tyah wɔ̀kɔ̀ yahlɛ n mɩ, tɛ́ kɩ mɛ yo tũ nɛ, yé Yõ̀tɛ̃̀, à yɩkɩ mɔ yé kɔ̃. Ǹtɛ, à kɩ yo yé tyɩ́ nɛ, pé náh yélɛ n pnɛ. ");
INSERT INTO wib_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Képah sɔkɔ, yé kɩ tyah n yo ǹ tyɩ́ nɛ ńkɛ̃́, yáh yõke yõ, tɛ́ ni wɔ wɛ̃ tyɩ́ ǹnɛ, ànɛ̂ yépi tɔ́wû tùkè-ǹtã̀n sɔkɔ-á à kwɔ́nɔ́ pɩ. ");
INSERT INTO wib_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Képah sɔkɔ, à kɩ yo yé tyɩ́ nɛ, pé náh yélɛ n pnɛ. Ńkɛ̃́, yé gbɛ mɔ pélɛ, yépi nónó pól-á tyípêllɛ n pɩ. ");
INSERT INTO wib_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Képah tɛ̃̀ sɔkɔ, yâh pópó Abrahmɩ, ànɛ̂ Yisakɩ, ànɛ̂ tɔ̃ Liyel tɛ̃ntõ̀ syínyopu pól wɛ, pè mɛ Liyel tɔ̃́rɩ́ sɔkɔ, tɛ́ yépi mɛ yĩni mɔ dénɔ́lɛ, légbĩ́nɛ, gbní ànɛ̂ yní táhnɔ́ ye kɩ pɩ yé tyɩ́lɛ. ");
INSERT INTO wib_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Tɛ́ névye kɩ wil kèkõyṍ ywɔ̃ ywɔ̃ pól sɔkɔ, kɩ pɔ yõke ǹgbɛ̃ yõ Liyel tɔ̃́rɩ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Kǎh pɩ sɛ̃́, nɛ́tɛ́lɔ́ túkù kɩ pɩ nɛ́gbrolɛ, tɛ́ nɛ́gbro túkù kɩ pɩ nɛ́tɛ́lɔ́lɛ.» ");
INSERT INTO wib_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Légbĩ́nɛ, Farisiyɛ̃nɔ yísyɔ́ nɔ de, tɛ́ yo Yesu tyɩ́ nɛ, yõ̀tɛ̃̀ Yerɔdɩ-á mɛ n yah n kɔ̃ ǹ kònmɔ-ńsahlɛ. Képah-á, à yal n to ásõ̂. ");
INSERT INTO wib_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Képah sɔkɔ, à mɛ yo pé tyɩ́: «Yé kyɩ yo kénɛ áswɔ̃́ plɛ́y mɛ̀ tyɩ́ nɛ, máh kɩ sétã̀n yĩni, tɛ́ kɩ dɛ́nmɔnɔ pɩ kwɛynɛ, ànɛ̂ ńsõ̂nɛ, tɛ́ ńsõ̂ náhlɛ, kǎh kɩ tyɛ. ");
INSERT INTO wib_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ǹtɛ, Liyel tɛ̃ntõ̀ syínyo-ò náh yɩ̃nɛ kúnɔ́lɛ tyah yɔ́, nɛ́ Yerusalɛmɩ sɔkɔ náh. Képah ye, mé yɩ̃nɛ mè n yɔ̃ n sɔkɔ ń wɛ̃̀kɩ̀ kɔ́lɔ́lɛ, kwɛy, ànɛ̂ ńsõ̂, ànɛ̂ tɔ̃ ńsõ̂ náhlɛ. ");
INSERT INTO wib_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Yerusalɛmɩ tãn, Yerusalɛmɩ tãn, yépi nónó-á Liyel tɛ̃ntõ̀ syínyopulɛ n ko n mɔ, tɛ́ Liyel-á nónó tɛkɩ mɔ yé kɔ̃, yé pépilɛ n minki n ko dyêhlɛ. Gbáhyɩ̃́ sɔ̃́ pól mɛ mé kè yah kɔ̃ nɛ, mé yé tuke mɔ, sɔ̃́-á sĩ̌n n tuke n mɔ ǹ pyelɛ ǹ kâm sõ̀ sɔkɔ, tɛ́ yé náh fɛ̃ syi. ");
INSERT INTO wib_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Kǎh pɩ sɛ̃́, Liyel kɩ ǹ náh vi yé kwil kɔ̃. Tɛ́ mé kélɛ n yo yé tyɩ́: yé náh tɔ̃ ńmɔ wɛ n yah n pi fɔ́ɔ́, kɩ pɔ syɩ gbĩ́ nɛ̂-á yé kɩ n yo nɛ ńkɛ̃́: ‹Nɛ̂-á n pi Tɛ̃̀ ǹgbɛ̃ Liyel yĩn yõ, sãm mɛ ǹ sɔkɔ.›» ");
INSERT INTO wib_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Mɩ mɩ yòh sṍ yɔ́lɛ, Yesu kyɩ yõke yṍ-ńsah Farisiyɛ̃nɔ yõ̀tɛ̃̀ dĩ́ yɔ́ gbô. Tɛ́ nónó-á sõ̀ mɛ nɛ́npɔ́, pè mɛ Yesulɛ n kyɔmɩ. ");
INSERT INTO wib_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Tɛ́ kè pɔ yɩ̃nɛ, wílsɛ̃́nɩ̀ yɔ́nwó yɔ́ sõ̀ mɛ ǹ tnɔ̂. ");
INSERT INTO wib_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Képah sɔkɔ, Yesu mɛ píkínyahnɔ pɩ Liyel ǹgbò wɛ̃̀kɩ̀ kwɔ́pú ànɛ̂ Farisiyɛ̃nɔ tyɩ́: «À yɔ́nwó dɛ mɔ mɩ mɩ yòh sṍlɛ, ké wɛ̃̀kɩ̀ se mɛ kɔ̃́nɔ́lɛ, tĩ̂ kè se mɛ yáhlenɔlɛ?» ");
INSERT INTO wib_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ǹtɛ, pè náh vi mɔ ǹ tyɩ́. Képah sɔkɔ, Yesu mɛ yɔ́nwó mɛ̀ tɛ̃, à à dɛ mɔ, tɛ́ à kɔ̃ à sɔkɔ, ");
INSERT INTO wib_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","tɛ́ mɛ yo pé tyɩ́: «Yépi sɔkɔ, nɛ̂ tɛ̃̀ pi, képah náh pɩ, ǹ nahy kɩ sɔkɔ de kwlɛ̀y sɔkɔ mɩ mɩ yòh sṍlɛ, tɛ́ à náh à wilki n pi súú?» ");
INSERT INTO wib_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ǹtɛ, pè náh tɛ̃ wɛ tir yo ké tyɩ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Képah yóntɛnɔ náh, Yesu-á nɛ́yénɔ́ kyɔmɩ wɛ, pè mɛ tɛ̃̀-ǹtã̀n ǹgbnɔlɛ n yah n kɔ̃, à vìnmɔnɔlɛ pè kɔ̃ nɛ: ");
INSERT INTO wib_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Pàh ǹ ye fúr yõke yṍ-ńsah, káh n kyɩ n tɛ̃ tɛ̃̀-ǹsah ǹgbɛ̃ sɔkɔ. Wâh képah pɩ, tɛ́ pè mɛ ǹnɩ̂ ye, nɛ̂-á kal áwɔlɛ, ");
INSERT INTO wib_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","yé yé-ò káh pɔ ǹ syah nɛ ńkɛ̃́, á yuku, á mó tɛ̃̀-ǹsahlɛ tɛ̃̀ kɔ̃. Légbĩ́nɛ, á kɩ yuku sen sɔkɔ, kɩ kyɩ tɛ̃ tɛ̃̀-ǹsah tyɩ̃́ɩ̃ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ǹtɛ, pàh ǹ ye, kyɩ n tɛ̃ tɛ̃̀-ǹsah tyɩ̃́ɩ̃ sɔkɔ. Á yé-ò-à pɔ ǹ wɛ sɛ̃́, à kɩ yo á tyɩ́ nɛ, pé kódĩ́, á nɔ pɔ tɛ̃̀-ǹsah ǹgbɛ̃ sɔkɔ. Képah sɔkɔ, kè kɩ pɩ gbílkínɔ́lɛ á tyɩ́ yõke yṍpú pól yĩ́ yah. ");
INSERT INTO wib_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ńkɛ̃́, névi nɛ̂-à ǹ gblɔ̌y dɔkɔ sah, tɛ̃̀ kɩ tiki mɔ, tɛ́ nɛ̂-à ǹ gblɔ̌y tiki mɔ, tɛ̃̀ kɩ dɔkɔ mɔ.» ");
INSERT INTO wib_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Tɛ́ ǹ syɩ yo ǹ yé-ò dĩ́ tyɩ́: «Wâh névyelɛ n ye yõkelɛ gbĩ̀ntɔ̃̀lɛ, képah náh pɩ, lékã̂hnɛ, káh á kódíbí ye, káh á yṹnpyé ye, káh á tyɩ́ névye ye, káh á tnɔ̂ tɛ̃̀pu tahbɩ ye. Pépi tɔ kɩ fɛ̃ pɔ ǹ ye yõke ǹgbɛ̃ yṍnɔ́lɛ, kè kɔ̃ kè kɩ pɩ á yénɔ́ mɛ̀ lédyáhnɩ́nɛ. ");
INSERT INTO wib_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ǹtɛ, wâh névyelɛ n ye yõkelɛ, yãm tãn, ànɛ̂ nɛ́dónè, ànɛ̂ gbáhkɩ̀ núkú névye, ànɛ̂ yɩ̃́tũbi ye. ");
INSERT INTO wib_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Pépi náh tɛ̃ wɛ ǹ dyah n pi ké sɔ̃́nɛ. Kàh pɩ sɛ̃́, á kɩ yèvɩnɩ wɛ Liyel tyɩ́, tyípéplɔ pɩ́pú lékyɩ̂-à yilki n mɔ sṍ nɛ̂nɛ.» ");
INSERT INTO wib_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Képah sɔkɔ, kénɛ yõke yṍpú sɔkɔ nɛ́núkù yɔ́-á kénɛ wɛlɔ noh sɛ̃́, à mɛ Yesu syah nɛ, névi nɛ̂-á kɩ yõke yõ n pi Liyel tɔ̃́rɩ́ sɔkɔ, yèvɩnɩ-á kélɛ tɛ̃̀ tyɩ́ dɛ́! ");
INSERT INTO wib_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesu mó yo ǹ tyɩ́: «Dĩ́ yɔ́ lésõ yõke ǹgbɛ̃ pɩ, tɛ́ névye náhnáh ye. ");
INSERT INTO wib_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Yõke yõ gbĩ́-á pɔ nɔ, à ǹ tõ̀npɩ dĩ́ tɛkɩ mɔ nɛ, à kyɩ yo nɛ́yénɔ́ tyɩ́, pè pɔ, páh tyɛ núkúnúkú. ");
INSERT INTO wib_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ǹtɛ, pé pól tyah gblɔ̌y yɛlɛ n yah n kɔ̃ dùkù núkúlɛ. Nɛ́gben à syah nɛ, páh swãh yɔ́ dwe núkúnúkú, ńkɛ̃́ páh yɩ̃nɛ pé kyɩ kè yah. Páh ǹnɛ n ni, à ǹ gblɔ̌y yɛ pé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ǹnɩ̂ mɛ nɛ, páh sètõ̀nyehnɔ gbãm dwe núkúnúkú, tɛ́ páh n yuku sé pɩ́nyah-ńsah. Páh ǹnɛ n ni, à ǹ gblɔ̌y yɛ pé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ǹnɩ̂ mɛ nɛ, páh sê tɔkɔ núkúnúkú, képah-á pé kɔ̃ pé náh n wɛ n pɔ n pi. ");
INSERT INTO wib_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Tõ̀npɩ-á ǹ syɩ pɔ, à pɔ tyi nɔ́pi pól yãh ǹ yõ̀tɛ̃̀ dĩ́ syah. Képah sɔkɔ, kététɛ̃̀ dĩ́ fɔkɔ vyãh, à mɛ yo ǹ tõ̀npɩ tyɩ́ nɛ, à kyɩ súú kwil tɔ́wû tùkè-ǹtãn ànɛ̂ wã̀l yey sɔkɔ. À kyɩ yãm tãn, ànɛ̂ nɛ́dónè, ànɛ̂ yɩ̃́tũbi, ànɛ̂ gbáhkɩ̀ núkú névye tɛ̃ pɔ ásõ̂. ");
INSERT INTO wib_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Képah náh, tõ̀npɩ ǹ syɩ pɔ yo ǹ tyɩ́ nɛ, pé yõ̀tɛ̃̀, wǎh nɛ̂ yo, páh kè pɩ, tɛ́ tɛ̃̀-ǹtã̀n túkù-á tɔ̃ mɛ. ");
INSERT INTO wib_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Kǎh pɩ sɛ̃́, yõ̀tɛ̃̀ dĩ́ mɛ yo ǹ tyɩ́ nɛ, à kyɩ wɛ̃̀-ǹgbnɔ yey, ànɛ̂ névye fwɔ́rɩ́nkɔ̃-ńtã̂n sɔkɔ, à kyɩ névye kãhlɩ tɛ̃ pɔ, pé wɔ̀kɔ̀ kɔ̃ kè yuku. ");
INSERT INTO wib_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Páh kélɛ n yo pé tyɩ́ nɛ: nónó-á sõ̀ yénɔ́lɛ, pé sɔkɔ yɔ́ ńtɛ̃ náh pé yõke dɔ n yah n pi.» ");
INSERT INTO wib_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Képah náh, Yesu-á n sɔkɔ, tɔ́wû ǹgbɛ̃ sõ̀ mɛ ǹ sõ̀ tɛ̃. À mɛ ǹ yah vi, tɛ́ yo pé tyɩ́: ");
INSERT INTO wib_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Nɛ̂-à pɔ ńmɔ tyɩ́, tɛ́ ń tyɩ́ náh nɔ kal ǹ tyɩ́ ǹ súlɛ, ànɛ̂ ǹ yṹnɛ, ànɛ̂ ǹ kyɩlɛ, ànɛ̂ ǹ wɛ̃́npìlɛ ànɛ̂ ǹ yṹnpyelɛ, à tahlɩ ǹ gblɔ̌y tɔ tyɩ́, tɛ̃̀ náh fɛ̃ n pɩ n pi ńmɔ tõ̀ sã́h-òlɛ. ");
INSERT INTO wib_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Névi nɛ̂ náh ǹ syɩ syɩ dahnɩ twah, à ńmɔ sõ̀ tɛ̃, tɛ̃̀ náh fɛ̃ n pɩ n pi ńmɔ tõ̀ sã́h-òlɛ. ");
INSERT INTO wib_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ǹtɛ, yépi sɔkɔ nɛ̂ tɛ̃̀ kɩ n yah n kɔ̃ wɔ̀kɔ̀ ǹgbɛ̃ mɔ́-ńsahlɛ, nɛ́ à náh tɛ̃, à ké gbõ̀ wilki kõ yah, tɛ́ kè yah n pi, ǹ pɔ́-à kɩ n yɩ̃nɛ n pi ké mɔ́nsyìnɔ́lɛ? ");
INSERT INTO wib_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Nɛ́ tɛ̃̀ náh képah pɩ, tɛ́ wɔ̀kɔ̀ sètyah wilki, tɛ́ tɛ̃ kwlɔ ké mɔ́nsyìnɔ́ tyɩ́, no-à kè wɛ, pè kɩ tyah kṍlɛ ǹnɛ n ko, ");
INSERT INTO wib_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","tɛ́ kɩ n yo nɛ, pè yah dĩ́ yɔ́lɛ, à wɔ̀kɔ̀ mɔ tyah mɔ, tɛ́ à náh tɛ̃ wɛ kè syi. ");
INSERT INTO wib_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Sɛ̃́ ó ye tɔ̃, yõ̀tɛ̃̀ nɛ̂ tɛ̃̀ kɩ n yuku mɛ́kɩ̀ fwó-ńsah ǹ ní-ò yõ̀tɛ̃̀nɛ, nɛ́ à náh tɛ̃ ǹ fɔkɔ mɔ n yah n pi, wàh kɩ fɛ̃ kyɩ mɛ́fwóbé nɛ́pĩ̂ kèyõ kwlɔ́lɛ ǹ fwó-ò swah n pi, nɛ̂-á mɛ ǹnɛ n yohnɩ mɛ́fwóbé kèyõ gbãmnɛ? ");
INSERT INTO wib_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Wàh pɩ̃ nɛ, pé náh fɛ̃ n tɛ̃ n pi, à kɩ ǹ ní-ò sah fɩ́ɩ́, tɛ́ kɩ nírí pɩ́-ò tɛkɩ mɔ kɩ mɛ́kɩ̀ yálnmɔnɔ yah kɔ̃ ǹ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Sɛ̃́ ó ye, nɛ̂-à ǹ gbã̀n yî pól wɛ́nyɛ̀-ǹkɛ̃̂nɛ, tɛ̃̀ náh fɛ̃ n pɩ n pi ńmɔ tõ̀ sã́h-òlɛ.» ");
INSERT INTO wib_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","«Pnɛnɛ, kwâh pèpɛy ye kélɛ. Ǹtɛ, ké dêndên-à wal, sɔ̃́ mɛ kè kɩ tɔ̃ fɛ̃ pɩ dêndên? ");
INSERT INTO wib_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Kàh pɩ sɛ̃́, kè náh fɛ̃ sétáh tyɩ́ pɛkɩ, ké náh se tɔ̃ fɛ̃ n pɩ pilɛ. Képah ye, kè n milki kégbɔ́. Níkí-à mɛ nɛ̂ tyɩ́ noh noh tɛ̃̀nɛ, tɛ̃̀ ǹ níkí sah noh.» ");
INSERT INTO wib_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Mɔ́rɩ́ syípú ànɛ̂ Liyel wɛ̃̀kɩ̀ kɔ́-ńkɛ̃̂pú pól sõ̀ n pɔ n pɔ Yesu tnɔ̂ ǹ wɛy noh yĩnnɛ. ");
INSERT INTO wib_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Képah tɛ̃̀nɛ, Farisiyɛ̃nɔ, ànɛ̂ Liyel ǹgbò wɛ̃̀kɩ̀ kwɔ́pú Yesu tyɩ́lɛ n plɔ n yãh nɛ, dĩ́ mɛ̀-á mɛ tyípêl pɩ́púlɛ n tɛ̃ plɛ, tɛ́ mɛ n yõ pélɛ ńtɛ̃nɛ. ");
INSERT INTO wib_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Képah sɔkɔ, Yesu mɛ sèmìrkì yɔ́ yãh pé tyɩ́: ");
INSERT INTO wib_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Képyɛ́nɩ̀ lèkwɛ̌-à mɛ yépi sɔkɔ yɔ́ tyɩ́, tɛ́ núkú mɔ pu sé sɔkɔ, tɛ̃̀ náh sé tíkíyẽ́h pɔ́ gbãm pɔ́ kwǎryãh nɔ́pi sah n pi gbãn sɔkɔ, tɛ́ kyɩ mɔ́npunɔ mɛ̀ soh kɔ̃, à syi kyɩ à wɛ n pi di? ");
INSERT INTO wib_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Tɛ́, wàh à wɛ, nɩ̀vɩ̀ tɛ̃̀ tyɩ́, ǎ à twah ǹ gbɛ̃̀nkã̀l yõ ǹ syɩ. ");
INSERT INTO wib_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Wàh ǹ syɩ pɔ gbô, ǎ ǹ kódíbí, ànɛ̂ ǹ tnɔ̂ tɛ̃̀pu ye n tuke, ǹ tɛ́ n yo pé tyɩ́ nɛ ńkɛ̃́, pé képɔ́ nɛ̂-á sõ̀ mɔ pu, páh à wɛ tɛ̃. Képah-á, pè pɔ pé nɩ̀vɩ̀ pɩ.» ");
INSERT INTO wib_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Képah yóntɛnɔ náh, Yesu tɔ̃ pè syah nɛ: «Mé kélɛ n yo yé tyɩ́: sɛ̃́ ó ye, tyípêl pɩ́-ò nɛ́núkù fyé-à Liyel wɛ̃̀kɩ̀ tɛ̃, nɩ̀vɩ̀ kɩ pɩ Liyel fṍ kɩ kal nɛ́pĩ̂ tíkíyẽ́h pɔ́ gbãm pɔ́ kwǎryãh nɔ́pi tyɩ́lɛ, pépi nónó-á nɛ ńkɛ̃́, páh mɛ nɛ́gblɔ́lɛ Liyel yah, Liyel wɛ̃̀kɩ̀ tɛ̃́nɔ́ yétõ̂ náh tɔ̃ mɛ pé tyɩ́.» ");
INSERT INTO wib_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Yesu tɔ̃ yo pé tyɩ́: «Pɔ́ plɔ́ gbãm-à mɛ sê yɔ́ tyɩ́, tɛ́ sé sɔkɔ núkú mɔ pu, à náh fɔ̀tnɔ̀ soh, tɛ́ wɔ̀kɔ̀ yal, à kè gbah soh kɔ̃, à syi kyɩ kè wɛ n pi di? ");
INSERT INTO wib_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Tɛ́ wàh kè wɛ, ǎ ǹ kósyɔ́, ànɛ̂ ǹ tnɔ̂ tɛ̃̀pu ye n tuke, ǹ tɛ́ n yo pé tyɩ́ nɛ ńkɛ̃́, pé pɔ́ nɛ̂-á sõ̀ mɔ pu, páh kè wɛ. Képah-á, pè pɔ pé nɩ̀vɩ̀ pɩ.» ");
INSERT INTO wib_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Képah yóntɛnɔ náh, Yesu tɔ̃ pè syah nɛ: «Mé kélɛ n yo yé tyɩ́: sɛ̃́ ó ye, tyípêl pɩ́-ò nɛ́núkù fyé-à Liyel wɛ̃̀kɩ̀ tɛ̃, yĩ̂nyõ tɛ̃ntõnè kɩ nɩ̀vɩ̀lɛ n pɩ.» ");
INSERT INTO wib_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Képah náh, Yesu tɔ̃ yo pé tyɩ́: «Dĩ́npì nɛ́pĩ̂ nímí lésõ mɛ dĩ́ yɔ́ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Sṍ yɔ́lɛ, gbɛ̃̀ tɛ̃̀ yo ǹ sú tyɩ́ nɛ, pé bɔ̌, ǹ gbɛ̃kɩ sɔkɔ, nɛ̂-á pé wɛ wɛ tɛ̃̀nɛ, à kélɛ pé kɔ̃. Wǎh yo sɛ̃́, ǹ sú mɛ ǹ tahrɩ dibi pè kɔ̃. ");
INSERT INTO wib_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Sèpĩ̀n yísyɔ́ sɔ́kɔ́ntɛnɔ náh, gbɛ̃̀ tɛ̃̀ ǹ tyɩ́ yãm, tɛ́ ǹ pɔ́ tɔkɔ sɔkɔ kwil fɩ́ɩ́ yɔ́ sɔkɔ. À kyɩ sè pɩ karkɩ tyíwã̂n yõ. ");
INSERT INTO wib_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Wǎh ǹ pɔ́ pól pɩ karkɩ tɛ gbĩ́ nɛ̂nɛ, kwɛ́npékè yɔ́ de kénɛ kwil. Képah sɔkɔ, yãm à tɛ̃. ");
INSERT INTO wib_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Kǎh pɩ sɛ̃́, à kyɩ tõ̀ yah kɔ̃ kénɛ kwil nɛy yɔ́ tyɩ́. Tɛ̃̀ mɛ̀ à tɛkɩ mɔ ǹ swãh, ǹ sel syɩkɩ yĩnnɛ. ");
INSERT INTO wib_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ǎ sel yõkelɛ n yah yèwannɛ, ǹtɛ nɛy náh ǹnɛ n kɔ̃ kélɛ. ");
INSERT INTO wib_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Képah sɔkɔ, ǹ yɩ̃́-á pɔ yɩkɩ, à tyah n sõ nɛ, pé bɔ̌ tyɩ́ yõke-á mɛ dò, ǹ tõ̀npɩbɩ pól mɛ n yõ n kwlɔ n sah. Ǹtɛ, péwɔ-á ásõ̂ kwɛkɩ n ko. ");
INSERT INTO wib_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ńkɛ̃́, páh kɩ sɔkɔ pé bɔ̌ tyɩ́, tɛ́ kɩ yo ǹ tyɩ́ nɛ, pé bɔ̌, páh pɩ de Liyel tyɩ́, tɛ́ pɩ de ǹ tɔ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Pé náh tɔ̃ yɩ̃nɛ yénɔ́lɛ ǹ pilɛ. Ńkɛ̃́, à pélɛ n tɛ̃ ǹ tõ̀npɩ sɔ̃́. ");
INSERT INTO wib_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Képah tɛ̃̀nɛ, à sɔkɔ ǹ sú tyɩ́. Wǎh mɛ fɩ́ɩ́ ǹ sú gbôlɛ, ǹ sú à wɛ. Wǎh à wɛ sɛ̃́, ǹ yãm à kah tɛ̃, à mɛ to kyɩ à yohnɩ pɔrɩ tɛ̃. ");
INSERT INTO wib_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ǹ pídĩ́ mɛ yo ǹ tyɩ́ nɛ ńkɛ̃́, pé bɔ̌, páh pɩ de Liyel tyɩ́, tɛ́ pɩ de ǹ tɔ tyɩ́, pé náh tɔ̃ yɩ̃nɛ yénɔ́lɛ ǹ pilɛ. ");
INSERT INTO wib_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ǹtɛ, ǹ sú mɛ yo ǹ tõ̀npɩbɩ tyɩ́: ‹Fwɔ̀mɔ̀-ǹgbɛ̃ nɛ̂-á plɛ kal, yé kyɩ ké tɔkɔ súú, yé pɔ mɔ à kɔ̃. Yé gbõ̀ngbɔ tã́hnɩ́ dyɩ à kɔ̃, yé mó lékyêh dyɩ à kɔ̃. ");
INSERT INTO wib_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","24","Ń pídĩ́ nɛ̂-á yɔ̀, kè pɩ nɛ, à sɔ̃́ sõ̀ ku, tɛ́ tɔ̃ ǹ syɩ min wɛ. À lésõ mɔ pu, tɛ́ à ye wɛ. Képah ye, nɩrɩ-á mɛ náhpíkì nɛ̂ sɔkɔ, yé ǹmɔ tɛ̃ n pɔ n ko á nɛ n yõ, á mó nɛ n syah nɩ̀vɩ̀lɛ.› Képah tɛ̃̀ sɔkɔ, pè tyah syáh syáhnɔ́lɛ nɩ̀vɩ̀ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Légbĩ́nɛ, ǹ pídĩ́ lékɔ̃nɩ́ sõ̀ mɛ swãh sɔkɔ. Wǎh ǹ syɩ n pi, tɛ́ nɔ de gbôlɛ, à yímɔ́nɩ̀, ànɛ̂ yínɔ́ yĩ́npɔ̃́ noh. ");
INSERT INTO wib_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","À tõ̀npɩ yɔ́ ye piki yah, tir nɛ̂-á n pɩ. ");
INSERT INTO wib_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ǹmɔ mɛ yo ǹ tyɩ́ nɛ, ǹ gbɛ̃̀ndĩ́-á pɔ de ǹ lènɔlɛ, képah-á nɩrɩ-á mɛ náhpíkì nɛ̂ sɔkɔ, ǹ sú mɛ à tɛ̃ ko. ");
INSERT INTO wib_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Képah tɛ̃̀nɛ, nɛ́nkyɩ́ mɛ̀ fɔkɔ vyãh, à yahle dénɔ́lɛ gbô. Ǹ sú mɛ wil nɛ, pé à ni à de. ");
INSERT INTO wib_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Képah sɔkɔ, à yo ǹ sú tyɩ́ nɛ, à yah, ké ye náhnáh-á yɔ̀, tɛ́ pé mɛ ǹ tõ̀lɛ n pɩ. Pé náh ǹ yóré yahle yah. Ǹtɛ, à náh pũ̀képir ńtɛ̃ fyé tɛ̃ pé kɔ̃ yah, pé syi ko syáh syah pé kódíbílɛ. ");
INSERT INTO wib_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Tɛ́ ǹ pídĩ́ mɛ̀ wɔ-á pɔ, ǹmɔ nɛ̂-á ǹ tahrɩ pɩ karkɩ syɔ́ fɔ̀fɩ́nɩ̀ yõ, à náhpíkì ko ǹmɔ kɔ̃. ");
INSERT INTO wib_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Képah sɔkɔ, ǹ sú yo ǹ tyɩ́: ‹Ń pídĩ́, áwɔ mɛ kṹmm ń tnɔ̂, ń gbã̀n yî póllɛ, áwɔ tyɩ́ ye. ");
INSERT INTO wib_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Á gbɛ̃̀ndĩ́ nɛ̂-á yɔ̀, kè pɩ nɛ à sɔ̃́ sõ̀ ku, tɛ́ tɔ̃ ǹ syɩ min wɛ. Á lésõ mɔ pu, tɛ́ à ye wɛ. Képah ye, mé yɩ̃nɛ mè syáh syah, mé nɩ̀vɩ̀ pɩ.›» ");
INSERT INTO wib_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Képah náh, Yesu yo ǹ tõ̀ sã́hpú tyɩ́: «Tàh dĩ́ yɔ́ ye lésõ, à ǹnɩ̂ tɔkɔ sah ǹ tahrɩ yõ, tɛ́ pè pɔ yo ǹ tyɩ́ nɛ, tɛ̃̀-á mɛ sélɛ n pɩ n karkɩ. ");
INSERT INTO wib_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ǹ yõ̀tɛ̃̀ dĩ́ mɛ à ye, tɛ́ yo ǹ tyɩ́ nɛ, pé náh mɛ tyípéplɔlɛ n nohnɩ ǹ tyɩ́ sɔkɔ. Kǎh pɩ sɛ̃́, à náh tɔ̃ fɛ̃ n tɛ̃ n pi pé tahrɩ yõ. Képah-á, à ǹ tõ̀ pɩ dùkù yah yo pé syah. ");
INSERT INTO wib_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Képah sɔkɔ, tahrɩ yõ tɛ̃̀-ò dĩ́ mɛ̀ mɛ yo ǹ gblɔ̌y tyɩ́ nɛ, pé yõ̀tɛ̃̀ dĩ́-á kɩ pé yal n pi ǹ tahrɩ yõ. Sɔ̃́ se pé kɩ pɩ nɩ? Swãh tõ tõ tǎhkɩ̀ náh se mɛ pé sɔkɔ. Tɛ́, nínsyinɔ tɛ̃̀nɛ, ké sen-á mɛ pé sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ǹtɛ, páh pɩ̃, páh nɛ nɛ̂ pɩ n pi, tɛ́ névye kɩ pé tɛ̃́nɔ́ plɛ pé gbên sɔkɔ, pàh pɔ pé fĩn mɔ pé tõ̀. ");
INSERT INTO wib_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Képah tɛ̃̀nɛ, à ǹ yõ̀tɛ̃̀ dĩ́ kmɔ nɛ́tãnnɛ n ye núkú núkúlɛ, tɛ́ nɛ́gben piki yah nɛ, dan nɛ̂ se pé yõ̀tɛ̃̀ dĩ́ kɔ̃lɩlɛ ǹ yõ nɩ? ");
INSERT INTO wib_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","À mɛ nɛ, nɩrɩ pní yɩ̃́ lèkwɛ̌-á. Tahrɩ yõ tɛ̃̀-ò dĩ́ mɛ à syah nɛ, ǹ kɔ̃lɩ sɛ́bɛ́y-á yɔ̀, à kɔ̃ n tɛ̃ súú, à wãrkɩ mɔ ké sɔkɔ nɛ ńkɛ̃́, nɩrɩ pní tikiníní pɔ́ gbãm-á. ");
INSERT INTO wib_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Képah náh, à yo kèyǎh tyɩ́ nɛ, tɛ́ ǹmɔ-á dò, dan nɛ̂ se à yɩ̃nɛ à kɔ̃ nɩ? Ǹmɔ mɛ à syah nɛ, sèmukɔ gbɔ̀tɔ́nɩ̀ yɩ̃́ lèkwɛ̌-á. À mɛ yo ǹmɔ tyɩ́ nɛ, ǹ sɛ́bɛ́y-á yɔ̀, à wãrkɩ mɔ ké sɔkɔ nɛ ńkɛ̃́, sèmukɔ gbɔ̀tɔ́nɩ̀ yɩ̃́ tíkíyẽ́h-á. ");
INSERT INTO wib_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Képah tɛ̃̀ sɔkɔ, ǹ yõ̀tɛ̃̀ dĩ́ à sõ ké yah wɛ́npɩnɔ yĩnnɛ. Kègbɩ yõ, kèkõyṍ névye tyi yahlɛ n wɛ n pɩ pé wɛ̃ wrɔ́ lékã́mkãmnɛ, à kal kyòo sɔkɔ névyelɛ.» ");
INSERT INTO wib_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Képah náh, Yesu tɔ̃ yo pé tyɩ́: «Ńmɔ wɔ kélɛ n yo yé tyɩ́ nɛ: pɔ́lɛ, gbɛ̃̀ntɛ̃̀náh kwâh tɛ̃̀ wɔ ye kélɛ. Ǹtɛ, yé kélɛ kódíbí yah kɔ̃. Kàh pópó pɔ n knɛ, yé kɩ tɛ̃ plɛ tyɛ́-ńkɛ̃̂ tyah sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ńkɛ̃́, névi nɛ̂-à pɩ nɛ́gbɩ́lɛ tir tyɩ̃́ɩ̃ sɔkɔ, à kɩ pɩ nɛ́gbɩ́lɛ tir gblò tɔ sɔkɔ. Tɛ́ nɛ̂-à yĩ́nvǐ pɩ tir tyɩ̃́ɩ̃ sɔkɔ, à kɩ yĩ́nvǐ pɩ tir gblò tɔ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Képah ye, pɔ́ nɛ̂-á gbɛ̃̀ntɛ̃̀náh kwâhlɛ, yâh pɩ́-ńkɛ̃̂nɛ nɛ́gblɔ́lɛ képah tyɩ́ sɔkɔ, nɛ̂ kɩ dahbɩ yé gbõ̀ yĩ̂nyõ tahrɩ kègbɩlɛ? ");
INSERT INTO wib_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Tɛ́, yâh pɩ́-ńkɛ̃̂nɛ nɛ́gblɔ́lɛ nɛ́káhbɩ́ gbã̀n yî tyɩ́ sɔkɔ, nɛ̂ kɩ yé yɛ̃́ngbɛ̃́ tyɩ́nɔlɛ yé kɔ̃? ");
INSERT INTO wib_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Tõ̀npɩ yɔ́ ńtɛ̃ náh fɛ̃ tõ̀ kwrɔ n pɩ yõ̀tãm nɛ́pĩ̂ nímí tyɩ́. À kɩ núkú dyɔ yɔ, tɛ́ kɩ nɔ ǹ ní-òlɛ, képah náh pɩ, à kɩ mɔ núkúlɛ, tɛ́ kɩ ǹ ní-ò wɛ mɔ. Sɛ̃́ ó ye, yé náh fɛ̃ tõ̀ kwrɔ n mɔ n pɩ n pi, Liyel ànɛ̂ pɔ́ tyɩ́.» ");
INSERT INTO wib_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Képah sɔkɔ, pɔ́ tyɩ́-á nɔ Farisiyɛ̃nɔ tyɩ́ sɛ̃́, pépi-á wɛlɔ nɔ́pi pól noh, pè tyah kṍlɛ Yesulɛ n ko. ");
INSERT INTO wib_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Képah tɛ̃̀nɛ, à mɛ yo pé tyɩ́: «Yépilɛ, yě yé gblɔ̌ynɛ n wɛ̃kɩ nɛ́gblɔ́lɛ névye yah sɔkɔ. Ǹtɛ, Liyel yé nnɔlɛ n pnɛ. Ǹgbǒ névye-á tir nɛ̂nɛ n gbilki, Liyel dêl ye képahlɛ dɛ́. ");
INSERT INTO wib_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Moyisi tyi kõ̀nsàhnɔ́ ànɛ̂ Liyel tɛ̃ntõ̀ syínyopu sɛ́bɛ́ynɔ́ sõ̀ mɛ n mɔ n kõ n yĩ́ĩ́ fɔ́ɔ́, à pɔ syɩ Wèlnwìlkì-ò Nsyɔ̃ mɛ gbĩ́ tyɩ́. Tɛ́ à tɔkɔ légbĩ́ tyɩ́, nɩ̀vɩ̀nɩ̀ wɛy sã́n mɛ n yo Liyel tɔ̃́rɩ́ tyɩ́ sɔkɔ, tɛ́ táhnsàhnɔ́ ó sɔkɔ ye no pól kɩ n de n pi ké sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ǹtɛ, yĩ̂nyõ ànɛ̂ sétáh kɩ yal sé slɔ sɔkɔ sɛ́rɔɔ kal tir kyɩ̃rɩ́ wìlkìnɔ́lɛ Liyel tyi kõ̀nsàhnɔ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Sɔ̃́-á kè yo nɛ, dĩ́ nɛ̂-à ǹ kyɩ wilki, tɛ́ ǹ syɩ kèyǎh tɔkɔ, fɔ̀fɩ́npɩ-á ǹnɛ. Ànɛ̂, sê nɛ̂ pɛ-à à wilki, tɛ́ névi nɛ̂ à tɔkɔ, fɔ̀fɩ́npɩ-á tɛ̃̀nɛ.» ");
INSERT INTO wib_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","«Tàh dĩ́ yɔ́ lésõ mɛ, à fwɔ̀tǎhnɩ̀ dɛ́nkɔ́kɔ́nɩ̀nɛ n mɔ, tɛ́ kwã́nkwã́n yélɛ n yõ sõmɛsṍ, mɛ nɩ̀vɩ̀lɛ n pɩ. ");
INSERT INTO wib_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Tɛ́ yãm nɛy yɔ́ tɔ sõ̀ mɛ, pè n ye Lasarɩlɛ. À sõ̀ mɛ sɛ̃́ntɛ̃̀nɔ́lɛ tàh dĩ́ mɛ̀ gbô yah. Ǹ wil pól sõ̀ mɛ nɩ́ynɛ. ");
INSERT INTO wib_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","À sõ̀ ńkɛ̃́nɛ nɛ mɛ ké tyɩ́ nɛ, pé yɛ̃́nmîrnnɛ n tõ n yõ, tàh dĩ́-á nónónɛ n yõ n kwɛ. Ǹtɛ, pãhlɔ ye sõ̀ n dɔ ǹ nɩ́ynɛ. ");
INSERT INTO wib_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Sṍ yɔ́lɛ, yãm nɛy mɛ̀ ku, yĩ̂nyõ tɛ̃ntõnè mɛ yuku ǹnɛ Abrahmɩ tnɔ̂. Tàh dĩ́ tɔ mɛ ku, pè kɔ̃ pè yɩ̃. ");
INSERT INTO wib_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ǹtɛ, wǎh kyɩ lékókwíl sɔkɔ, à kyɩ fṍhnɔ́lɛ n wɛ. Wǎh ǹ yah yɔ̃ yah, à Abrahmɩ wɛ fɩ́ɩ́ sɔkɔ, Lasarɩlɛ ǹ gbɔ̀pɔ. ");
INSERT INTO wib_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Képah sɔkɔ, à ye yah fléyy nɛ, pé sú Abrahmɩ, ńkɛ̃́ páh mɛ n kwlɔ képékèyɔ̂ nyàh mɛ̀ sɔkɔ. Képah-á, à pé yãm yah, à mó Lasarɩ tɛkɩ mɔ, à pɔ ǹ kèngbɔ vyãh dahbɩ wilki ni sɔkɔ, à sah pé nɛ́npɔ́rɩ́ yõ kè kɔ̃ kè vɩ. ");
INSERT INTO wib_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ǹtɛ, Abrahmɩ mɛ yo ǹ tyɩ́: ‹Ńmɔ pi, á dyɔ to n kõ nɛ, wáh yèvɩnɩ wɛ sɔkɔ, wáh sõ̀ mɛ min sɔkɔ gbĩ́ nɛ̂nɛ, tɛ́ Lasarɩ wɔ mɛ yèvyãhrɩ wɛ. Ǹtɛ núkúnúkú, ǹmɔ mɛ yèvɩnɩ sɔkɔ, tɛ́ áwɔ mɛ yèvyãhrɩ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","À wil képah sɔkɔ, pwã̀h ǹgbɛ̃ mɛ yépi ànɛ̂ ápi wrɔ́. Képah yĩnnɛ, ásõ̂ névye nónó-á mɛ ké tyɩ́ nɛ, pé kyɩ yé tyɩ́, pè káh tɛ̃ wɛ, ànɛ̂ nɛ́npɔ́ névye nónó-á mɛ ké tyɩ́ nɛ, pé pɔ ápi tyɩ́, pé tɔ káh fɛ̃ tɛ̃.› ");
INSERT INTO wib_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","Képah sɔkɔ, tàh dĩ́ mɛ à syah nɛ, pé sú Abrahmɩ, kàh pɩ sɛ̃́, yṹnpyé nɛ́pĩ̂ kwâl-á mɛ pé tyɩ́, páh ǹnɛ n ni, à Lasarɩ tɛkɩ mɔ pé sú kéte sɔkɔ, à kyɩ kè yo sah pé tyɩ́, pé tɔ káh pɔ de yèvyãhrɩ tɛ̃̀-ǹsah mɛ̀ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abrahmɩ mó yo ǹ tyɩ́: ‹Moyisi tyi sàhnɔ́, ànɛ̂ Liyel tɛ̃ntõ̀ syínyopu wɛlɔ mɛ pé tyɩ́. Pè sépi tyíyónɔ́lɛ n pɩ!› ");
INSERT INTO wib_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Wǎh yo sɛ̃́, dĩ́ mɛ̀ tɔ̃ à syah nɛ, képah náh n yɩ̃nɛ n pi, pé sú Abrahmɩ. Ǹtɛ, névi-à kɩ wil lékyɩ̂ sɔkɔ, à kyɩ yo pé tyɩ́, pǎh kɩ Liyel wɛ̃̀kɩ̀ tɛ̃. ");
INSERT INTO wib_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Képah tɛ̃̀nɛ, Abrahmɩ mɛ tɔ̃ yo ǹ tyɩ́: ‹Pàh kɩ yahle Moyisi ànɛ̂ Liyel tɛ̃ntõ̀ syínyopu wɛlɔ nóhnɔ́lɛ, névi-à sɔ̃́ wil lékókwíl à pɔ kèkõyṍ, à kyɩ yo pé tyɩ́, pè náh n sɛ̃ n pi ké yõ tɔ̃ ńtɔ̃.› ");
INSERT INTO wib_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Képah náh, Yesu yo ǹ tõ̀ sã́hpú tyɩ́: «Tyi nónó-á névilɛ n mɔ tyípékè pɩ́nɔ́ sɔkɔ, sépi náh fɛ̃ n yɛ wɛ́nɔ́lɛ. Ǹtɛ, névi nɛ̂ tyɩ́-á ké yõ wil, yèvyãhrɩ mɛ tɛ̃̀ yõ. ");
INSERT INTO wib_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Kè kɩ sõ̀ fṍnfṍ kal, pàh yínɔ́nan toh tɛ̃̀ yègbɩ, tɛ́ à min dah mɔ pnɛ yɔ sɔkɔ à kɔ̃ à káh pɔ ńmɔ yõ sɛ̃́-ò tyɩ̃́ɩ̃ yɔ́ ńtɛ̃ dah mɔ tyípékè sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Yé yé gblɔ̌y tɛ̃ dɛ́! Á yṹnpi-à pɩ de á tyɩ́, wɛkɩ ǹ yõ! Wàh ké nàhnpɩ̃ gbo, kè yɔ̃ mɔ à kɔ̃. ");
INSERT INTO wib_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ànɛ̂ wàh pɩ de á tyɩ́ gbáhyɩ̃́ kwǎrninɔ gbĩ̀yĩ̀kì núkú sɔkɔ, tɛ́ ǹnɛ n syɩ n yo n pɔ á tyɩ́ fɔ́ɔ́ gbáhyɩ̃́ kwǎrninɔ nɛ, páh mɛ ké nàhnpɩ̃nɛ n gbo, sélɛ n yɔ̃ n mɔ ǹ tyɩ́.» ");
INSERT INTO wib_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Képah sɔkɔ, Yesu tɛ̃̀ntõbe à syah nɛ, pé Yõ̀tɛ̃̀, à wãn mɔ pépi Liyel yõ sɛ̃́nɔ́ yõ. ");
INSERT INTO wib_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Tɛ̃̀ ǹgbɛ̃ mɛ yo pé tyɩ́: «Gbɩ tɛ̃̀ yõ, yé Liyel yõ sɛ̃́nɔ́-à sõ̀ mɛ tyɩ̃́ɩ̃ ǹsɔ̃̀, mútárdɩ̀ pi fyé sɔ̃́, yé náhkɩ sõ̀ fɛ̃ yo sènsóké mɛ̀ tyɩ́ nɛ ńkɛ̃́, kè ké gblɔ̌y viki kyɩ sõ pnɛ yɔ sɔkɔ, tɛ́ kè náhkɩ kè pɩ yé yóré yõ.» ");
INSERT INTO wib_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Képah náh, Yesu yo pé tyɩ́: «Tõ̀npɩ yɔ́-à mɛ á tyɩ́, mɛ á swãhlɛ n wɔ, képah náh pɩ, á yípɛ̂ynɛ n fɛ̃... wàh wil swãh, à pɔ n de á wɛ, á se kɩ yo ǹ tyɩ́ nɛ, à sal n pɔ yõke yõ? ");
INSERT INTO wib_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Á náh pyě tɔ̃ n yo n pi ǹ tyɩ́ nɛ, à áwɔ yõke ǹgbò pɩ, képah náh, à mó flɔ yísyɔ́ mɔ pɔ, á ǹnɛ n tõ á yõke yõ gbĩ́nɛ, tɛ́ képah náh, à mó pyě pɔ yõ, à mó wɔ di? ");
INSERT INTO wib_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Tɛ́ tõ̀npɩ mɛ̀-á ǹ tõ̀ pɩ ké wɛ̃̀kɩ̀ yõ, á se kɩ ǹ yĩ́ngbɩ́ yo? Ǹ pɩ pɩ tõ̀ ó náh à pɩ di? ");
INSERT INTO wib_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Képah núkú ó ye yépi tɔ tyɩ́: Tyi nónó-á yah kɔ̃ yé tyɩ́, yâh sè pɩ tɛ, yé yo nɛ, tõ̀npɩbɩ ó-á yélɛ. Yáh sõ̀ yɩ̃nɛ yè nɛ̂ pɩ, képah ó-á yé pɩ.» ");
INSERT INTO wib_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesu-á sõ̀ mɛ n yuku Yerusalɛmɩ, à syɔ̃ sɔkɔ Samarɩ ànɛ̂ Kalile gbàh yõ. ");
INSERT INTO wib_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Wǎh kyɩ n de kwílpír yɔ́ sɔkɔ, díbí tótãm nɛ́pĩ̂ gbãm yísyɔ́ pɔ à yohnɩ. Pè sõ̀ mɛ yĩn fɩ́ɩ́, ");
INSERT INTO wib_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","tɛ́ tyah n yo n mɔ ǹ tyɩ́ yĩ́npɔ̃́ ǹgbɛ̃nɛ nɛ ńkɛ̃́, pé yõ̀tɛ̃̀ Yesu, à pé yãm yah. ");
INSERT INTO wib_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Wǎh pè wɛ sɛ̃́, à yo pé tyɩ́ nɛ, pè kyɩ pé gblɔ̌ynɛ sárká wìlkìpu yõ̀tãm wɛ̃kɩ. Pǎh képah noh sɛ̃́, tɛ́ wɛ̃̀kɩ̀ tɛ̃ n yuku, pè dɛ. ");
INSERT INTO wib_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Pé sɔkɔ nɛ́núkù yɔ́-á kè wɛ à dɛ sɛ̃́, à ǹ syɩ Liyel yĩn gbilki pɔ Yesu tnɔ̂ yĩ́npɔ̃́ ǹgbɛ̃nɛ. ");
INSERT INTO wib_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","À pɔ kɔ kwĩnki ǹ yah di sétáh Yesu yah, à wɛkɩ ǹ tyɩ́. Tɛ́ kénɛ dĩ́nɛ, Samarɩ nɛy ye sõ̀ ǹnɛ. ");
INSERT INTO wib_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesu-á à wɛ sɛ̃́, à nɛ: «Nɛ́pĩ̂ gbãm nɔ́pi pól náh dɛ di? Ǹtɛ, kwǎryãh nɔ́pi tɛ́lɔ́-á dò, pépi ńyãh? ");
INSERT INTO wib_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Nɛy náh wɛ pépi sɔkɔ à ǹ syɩ pɔ wɛkɩ Liyel tyɩ́, à wil nɛ́kã̂h mɛ̀ tyɩ́ sɔkɔ kɛ̀?» ");
INSERT INTO wib_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Tɛ́ mɛ ǹ syɩ yo kénɛ dĩ́ tyɩ́: «Yuku n nɛ n yuku! Á Liyel yõ sɛ̃́nɔ́ ǹ pwah mɔ.» ");
INSERT INTO wib_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Képah náh, Farisiyɛ̃nɔ Yesu piki yah nɛ, gbĩ́ nɛ̂ se Liyel tɔ̃́rɩ́ kɩ n pɔ n pi nɩ? À mɛ yo pé tyɩ́: «Liyel tɔ̃́rɩ́ náh n pɔ n pi kwâh yɔ́ sɔ̃́ nɛ̂-á n wɛ yĩ́nɛ. ");
INSERT INTO wib_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ànɛ̂ tɔ̃, nɛy náh n yo n pi nɛ, kè wɛ yɔ̀, képah náh pɩ, kè wɛ yàhàh. Ǹtɛ, yé pɩ̃ nɛ ńkɛ̃́, Liyel tɔ̃́rɩ́-á mɛ yé wrɔ́.» ");
INSERT INTO wib_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Képah náh, Yesu tɔ̃ yo ǹ tõ̀ sã́hpú tyɩ́: «Sṍ yɔ́ mɛ n pi, Névi Pi wɛ dékè kɩ mɛ yé tɛ̃, tɛ́ yé náh à wɛ n pi. ");
INSERT INTO wib_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Pè kɩ yé syah nɛ, wǎh yɔ̀, képah náh pɩ, wǎh yàhàh. Ǹtɛ, yé káh n kyɩ, yé káh nɛ n sal. ");
INSERT INTO wib_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Sɔ̃́-á pũ̀ n yĩkiri yã̌l, à tɔkɔ yĩ̂nyõ yah yɔ́ tyɩ́, à kyɩ syɩ ké yah yɔ́ tyɩ́, sɛ̃́ntɛ̃̀ ye Névi Pi pɔ́nɔ́ kɩ pɩ. ");
INSERT INTO wib_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ǹtɛ, Névi Pi ǹgbò yɩ̃nɛ à yèvyãhrɩ pɩ náhnáh, ànɛ̂ kwɛy gbĩ névye mó à yahle. ");
INSERT INTO wib_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Kǎh pɩ sɔ̃́ ǹgbòlɛ Nowe gbĩ sɔkɔ, sɛ̃́ tɔ ye kɩ pɩ Névi Pi syɩ́npɔ gbĩ́nɛ. ");
INSERT INTO wib_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Névye lésõ mɛ n yõ, tɛ́ mɛ n wɔ, tɛ́ mɛ syɔ́lɛ n tɔkɔ, tɛ́ mɛ n de pɛbɩ tyɩ́ fɔ́ɔ́, à pɔ syɩ sṍ nɛ̂-á Nowe de krótó-ǹgbɛ̃ sɔkɔ. Képah tɛ̃̀ sɔkɔ, pṹnpã́hkɩ̀ pɩ, ni pé pól yõ. ");
INSERT INTO wib_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ànɛ̂, kè kɩ pɩ, kǎh pɩ sɔ̃́ ǹgbòlɛ Lɔtɩ gbĩ tɔ sɔkɔ: Névye lésõ mɛ n yõ, tɛ́ mɛ n wɔ, tɛ́ mɛ yídwénènɛ n dwe, tɛ́ mɛ yíyã̌mnɛ n yãm, tɛ́ mɛ swãhlɛ n tõ, tɛ́ mɛ vɩ̀lɛ n mɔ. ");
INSERT INTO wib_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ǹtɛ, Lɔtɩ-á wil sṍ nɛ̂nɛ Sodɔmɩ sɔkɔ, Liyel nyàh lépɔ̃́ ànɛ̂ nyàh lépúkú tiki mɔ pé yõ pũ̀ sɔ̃́ n pɩ, à pé sukɛ ko. ");
INSERT INTO wib_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Sɛ̃́ntɛ̃̀ ó ye kè kɩ pɩ n sɔkɔ n pi Névi Pi syɩ́npɔ sṍlɛ. ");
INSERT INTO wib_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ké lésõ-à pɔ, névi nɛ̂ wɛ gbɛ̃́ntĩ̂n yõ, tɛ́ vyɔ́ mɛ tɛ̃̀ tyɩ́ wɔ̀kɔ̀ sɔkɔ, à káh nɛ, páh n tiki n yuku sé tɔ́kɔ́-ńsah. Tɛ́ nɛ̂ tɔ-à mɛ swãh sɔkɔ, tɛ̃̀ káh nɛ, páh pélɛ n syɩ n yuku gbô. ");
INSERT INTO wib_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Yé yé dyɔ to kõ Lɔtɩ kyɩ tyɩ́lɛ kɛ̀! ");
INSERT INTO wib_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Sɛ̃́ ye, nɛ̂-à nɛ, páh pé minnɛ n koh n sah, tɛ̃̀ kɩ tɛkɩ ké sɔkɔ, ǹtɛ nɛ̂-à tɛkɩ ǹ min sɔkɔ, tɛ̃̀ wɔ min kɩ pwah. ");
INSERT INTO wib_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Mé kélɛ n yo yé tyɩ́ nɛ: kénɛ lékã̂hnɛ, nɛ́pĩ̂ nímí kɩ mɛ sɛ̃ sɛ̃ kwâh núkú yõ, núkú kɩ tɛ̃ sɔkɔ, tɛ́ ǹ ní-ò kɩ wũ. ");
INSERT INTO wib_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Syɔ́ nɛ́pĩ̂ nímí kɩ mɛ yîlɛ n nɔ wɛ̃ tyɩ́, núkú kɩ tɛ̃ sɔkɔ, tɛ́ ǹ ní-ò kɩ wũ.  ");
INSERT INTO wib_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Díbí nɛ́pĩ̂ nímí kɩ mɛ swãh núkú sɔkɔ, núkú kɩ tɛ̃ sɔkɔ, tɛ́ ǹ ní-ò kɩ wũ.» ");
INSERT INTO wib_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Képah sɔkɔ, Yesu tõ̀ sã́hpú à piki yah nɛ, pé Yõ̀tɛ̃̀, ńyãh sɔkɔ se képah kɩ n pɩ n pi nɩ? À mɛ yo pé tyɩ́: «Kókè-à mɛ ńyãh, nɛ́npɔ́ sɔkɔ náh ǹkyɔ̀nkyɔ̀nɩ̀ wɛ̃ tuke n mɔ di?» ");
INSERT INTO wib_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Képah náh, Yesu sèmìrkì yɔ́ yãh ǹ tõ̀ sã́hpú tyɩ́, à pè wɛ̃kɩ nɛ, pǎh yɩ̃nɛ pè nírílɛ n pɩ kṹmm wílkúnì kɛ̃́nɛ ké sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","À nɛ: «Tukey tùkè-ò dĩ́ yɔ́ lésõ mɛ kwil yɔ́ sɔkɔ, à náh Liyel yah tíkílɛ n pɩ, à náh yõ̀yénnɛ n sah névye yõ. ");
INSERT INTO wib_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Tɛ́ pɛ́kúsè yɔ́ tɔ sõ̀ mɛ kénɛ kwil sɔkɔ. Ǹmɔ sõ̀ mɛ n yo n pɔ ǹ tyɩ́ gbĩ́mɛgbĩ́ nɛ, nɛ̂-á mɛ péwɔ ànɛ̂ pé fwó-ò wrɔ́, à kè tɔ̃ sah pé kɔ̃. ");
INSERT INTO wib_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ǹtɛ, kè pɩ di mónɔ́lɛ, tɛ́ dĩ́ náh sõ̀ mɛ fɛ̃ syi. Képah náh, à pɔ yo n gblɔ̌y tyɩ́ nɛ, gbɩ tɛ̃̀ wɔ-á, pé náh Liyel yah tíkílɛ n pɩ, pé náh yõ̀yénnɛ n sah névye yõ. ");
INSERT INTO wib_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Ǹtɛ, pɛ́kúsè mɛ̀-á mɛ pé gblɔ́lɛ n vyãh n pɔ, páh kɩ ǹ tir mɛ̀ yah wah à kɔ̃, pé yah mó vɩ.» ");
INSERT INTO wib_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Tɛ̃̀ ǹgbɛ̃ Yesu-á képah yãh tɛ, à tɔ̃ yo pé tyɩ́: «Yé tukey tùkè-ò dĩ́ mɛ̀ wɛy noh kɛ̀, ǹmɔ nɛ̂-á fĩ̀n yṍ-òlɛ. ");
INSERT INTO wib_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ǹtɛ Liyel wɔ-á nónó yah tɔkɔ, tɛ́ pè mɛ ǹnɛ n ye n gbo lékã̂h ké gbĩ̀ntɔ̃̀, à náh pé tyi yah wah pè kɔ̃ n pi di? À se kɩ mo pé yòhnɩ̀nmɔ-ńsah? ");
INSERT INTO wib_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Mé kélɛ n yo yé tyɩ́ nɛ: wǎh kɩ pé tyi yah wah pè kɔ̃ súú. Ǹtɛ, Névi Pi-à sṍ nɛ̂nɛ pɔ sétáh yõ, à se kɩ pɔ Liyel yõ sɛ̃́nɔ́ wɛ?» ");
INSERT INTO wib_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Névye nónó-á sõ̀ mɛ pé gblɔ̌ynɛ n yah nɛ ńkɛ̃́, páh mɛ nɛ́gbɔ́lɛ Liyel yah, tɛ́ mɛ tɛ́lɔ́lɛ n yilɔ, Yesu sèmìrkì yɔ́ yãh pépi tyɩ́ sɔkɔ nɛ: ");
INSERT INTO wib_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","«Díbí nɛ́pĩ̂ nímí yísyɔ́ sõ̀ kyɩ Liyel wɔ̀kɔ̀ ǹgbɛ̃ kéntáhkɩ̀ sɔkɔ, à kyɩ Liyel ni. Nɛ́núkùlɛ, Farisiyɛ̃ ye sõ̀ ǹnɛ, tɛ́ ní-òlɛ, mɔ́rɩ́ syí-òlɛ. ");
INSERT INTO wib_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Képah sɔkɔ, Farisiyɛ̃ mɛ̀ mɛ yuku yĩn, à Liyellɛ n ni ǹ fɔkɔ táh, mɛ n yo nɛ, èè Liyel, páh n wɛkɩ ǹ tyɩ́, wǎh sɔ̃́npɩ́ péwɔ pɩ pé gblɔ̌y. Pé náh mɛ no tɛ́lɔ́ tyɩ́ kɔ̃lɛ, nónó-á yɩ̃́púlɛ, ànɛ̂ tyítúkúnì pɩ́púlɛ, ànɛ̂ fɔ̀fɩ́kɩ̀ pɩ́púlɛ. Páh n wɛkɩ ǹ tyɩ́, pé náh sɔ̃́npɩ́lɛ mɛ mɔ́rɩ́ syí-ò mɛ̀ sɔ̃́. ");
INSERT INTO wib_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Péwɔ-á níkìlɛ n tɛ̃ sèpĩ̀n nínì yòh núkú wrɔ́. Páh pé gbã̀n yî wɛ́nɔ́ gbãm-ònɔ́lɛ ǹnɛ n kɔ̃. ");
INSERT INTO wib_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ǹtɛ mɔ́rɩ́ syí-ò wɔ mó sõ̀ mɛ yĩn tɛ̃ fɩ́ɩ́, à náh fɛ̃ syi ǹ yah ńtɛ̃ yɔ̃ yĩ̂nyõ. Tɛ́ mɛ ǹ gbõ̀lɛ n sah ǹ nɩ̀vɔ sɔkɔ mɛ n yo nɛ: ‹Liyel, ń yãm yah, ńmɔ nɛ̂-á tyípékè pɩ́-òlɛ.›» ");
INSERT INTO wib_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Képah tɛ̃̀nɛ, Yesu mɛ nɛ: «Mé kélɛ n yo yé tyɩ́ nɛ: dĩ́ mɛ̀ pɩ nɛ́gbɩ́lɛ Liyel yah, wǎh ǹ syɩ n yuku ǹ tĩ̀nnɛ gbĩ́ nɛ̂nɛ. Tɛ́ Farisiyɛ̃ wɔ náh sɛ̃́nkɔ̃ wɛ. Gbɩ yõ, névi nɛ̂-à ǹ gblɔ̌ynɛ n gbilki, à kɩ tiki mɔ. Tɛ́ nɛ̂-à ǹ gblɔ̌ynɛ n tiki n mɔ, tɛ̃̀ wɔ kɩ mó dɔkɔ mɔ.» ");
INSERT INTO wib_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Névye sõ̀ mɛ n pɔ n pɔ wɛ̃́npì yrɔ̃́ tɔlɛ Yesu tyɩ́ nɛ, à tũ pé tyɩ́. Ǹ tõ̀ sã́hpú-á képah wɛ, pè tyah dírílɛ n kõ pé yõ. ");
INSERT INTO wib_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ǹtɛ, Yesu mɛ wɛ̃́npì kɔ̃ pè nɔ de ǹ tnɔ̂, tɛ́ nɛ: «Nónó dùkù-á mɛ wɛ̃́npì nɔ́pi sɔ̃́, Liyel tɔ̃́rɩ́lɛ, pépi tyɩ́ ye. Képah ye, yé yɛ wɛ̃́npì kɔ̃ pè nɛ n pɔ n pɔ ńmɔ tyɩ́. Yé káh pé yahlɛ n kõ. ");
INSERT INTO wib_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Gbɩ yõ, mé kélɛ n yo n dal n mɔ yé tyɩ́ nɛ: névi nɛ̂-à Liyel tɔ̃́rɩ́ fɛ̃̀nsyi-ńkɛ̃̂nɛ wɛ̃́npir tyɩ́ kɔ̃lɛ, à náh n wɛ n de n pi ké sɔkɔ póllɛ.» ");
INSERT INTO wib_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Képah náh, Nsyifunɔ yõ̀tɛ̃̀ yɔ́ Yesu piki yah nɛ, kwɔ́-ò pèpɛy, pé se yɩ̃nɛ pé pɩ sɔ̃́, pé mó tyɛ́-ńkɛ̃̂ min wɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesu mɛ yo ǹ tyɩ́: «Kwâh nɛ̂ pɩ, tɛ́ á ńnɛ n ye ‹pèpɛynɛ›? Pèpɛy yɔ́ ńtɛ̃ náh mɛ, nɛ́ Liyel ó náh. ");
INSERT INTO wib_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Á Liyel tyi kõ̀nsàhnɔ́ pɩ̃ kɛ̀, nɛ̂-á n yo nɛ ńkɛ̃́: ‹Káh fɔ̀fɩ́kɩ̀ pɩ, káh nɛ́kókè mɔ, káh yɩ̃be yɩ̃, káh mɩ̀nɩ̀ sah á ní-ò yõ, á sú ànɛ̂ á yṹnɛ n tɛ̃ plɛ.›» ");
INSERT INTO wib_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Wǎh yo sɛ̃́, dĩ́ mɛ à syah nɛ, páh mɛ sépinɔ́ póllɛ n pɩ fɔ́ɔ́, pé wɛ̃́npir gbĩ́ dùkùlɛ. ");
INSERT INTO wib_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesu-á képah noh sɛ̃́, à yo ǹ tyɩ́: «Tyínúkú ó tɔ̃ yah kwlɔ á tyɩ́: Gbã̀n yî nónó pól-á mɛ á tyɩ́, kyɩ sè yãm, ǹ tɛ́ sé pɔ́ dibi yãm tãn kɔ̃, ǹ tɛ́ n pɔ ńmɔ sõ̀ tɛ̃. Képah sɔkɔ, á kɩ Liyel fṍ tahrɩ wɛ.» ");
INSERT INTO wib_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Tɛ́ dĩ́ tahrɩ-á sõ̀ kah tnɔ sɛ̃́, képah ye, wǎh wɛy mɛ̀ noh, ǹ yah kwɔ yɩkɩ. ");
INSERT INTO wib_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Képah sɔkɔ, Yesu-á ǹ yah wɛ kè kwɔ sɛ̃́, à nɛ, tahbɩ dénɔ́-á mɛ tah Liyel tɔ̃́rɩ́ sɔkɔ dɛ́! ");
INSERT INTO wib_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ńkɛ̃́, yã̀hmɩ́kɩ̀ dénwìlnɔ́lɛ sèndi pwã̀h sɔkɔ, képah ńtɛ̃-á kɩ fàhfàh kal tàh dénɔ́lɛ Liyel tɔ̃́rɩ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Képah sɔkɔ, nónó-á sõ̀ mɛ ǹ wɛynɛ n nohnɩ, pè nɛ, ǹtɛ, nɛ̂ wɔ se kɩ mó fɛ̃ pwah nɩ? ");
INSERT INTO wib_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","À mɛ yo pé tyɩ́: «Névi náh fɛ̃ tir nɛ̂ pɩ n pi, Liyel kɩ fɛ̃ képah pɩ.» ");
INSERT INTO wib_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Képah sɔkɔ, Pyɛrɩ mɛ nɛ, pépi tɛ̃̀ wɔlɛ, páh pé yɛ̃́ngbɛ̃́ yî sah, tɛ́ ǹmɔ sõ̀ tɛ̃. ");
INSERT INTO wib_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesu mɛ yo pé tyɩ́: «Gbɩ yõ, mé kélɛ n yo n dal mɔ yé tyɩ́ nɛ: névi nɛ̂-à Liyel tɔ̃́rɩ́ yĩnnɛ ǹ kéte sah, képah náh pɩ, ǹ kyɩlɛ, képah náh pɩ, ǹ yṹnpyélɛ, képah náh pɩ, ǹ tyɩ́ névyelɛ, képah náh pɩ, ǹ wɛ̃́npìlɛ, ");
INSERT INTO wib_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","tɛ̃̀ kɩ pé lékan wɛ kèkõyṍ mɛ̀ sɔkɔ, tɛ́ kɩ tyɛ́-ńkɛ̃̂ min wɛ Liyel fṍ sɔkɔ ńsõ̂nɛ.» ");
INSERT INTO wib_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Képah náh, Yesu ǹ tõ̀ sã́hpú nɛ́pĩ̂ gbɔ̃nimí ye pé yahlɛ, tɛ́ yo pé tyɩ́: «Á wɛ n yuku Yerusalɛmɩ sɔkɔ yɔ̀. Tɛ́ Liyel tɛ̃ntõ̀ syínyopu-á lésõ tyi nónó pól wãrkɩ sah Névi Pi tyɩ́ sɔkɔ, sè kɩ n pɩ n tũ n pi. ");
INSERT INTO wib_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Pè kɩ à dahbɩ Liyel pɩ̃́-ńkɛ̃̂pú gbõ̀. Pè kɩ kṍlɛ ǹnɛ n ko, kɩ ǹnɛ gbyɔ, tɛ́ kɩ n sĩn n mɔ ǹ yõ. ");
INSERT INTO wib_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Pè kɩ à ko yèfõhlɛ, tɛ́ kɩ à ko mɔ. Ǹtɛ, ké sèpĩ̀n tɔ̃́-ò sṍlɛ, à kɩ ǹ syɩ min sãn wɛ.» ");
INSERT INTO wib_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ǹtɛ, Yesu wɛy mɛ̀ sõ̀ mɛ wɛ́npǐllɛ pé tyɩ́. Képah ye pè náh ké syɩ́kɩ́-ńsah pɩ̃. ");
INSERT INTO wib_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Képah sɔkɔ, Yesu-á de n tɛ Yeriko kwillɛ yúkɛy, yɩ̃́tũ̂ yɔ́ sõ̀ mɛ kɔ̃́ntɛ̃̀nɔ́lɛ wɛ̃̀gbalɩ sɔkɔ, mɛ n ni n syi. ");
INSERT INTO wib_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Wǎh tɔ́wû sɔ́kɔ́nɔ́ yĩ́ noh, à piki yah nɛ, tir nɛ̂ se nɩ? ");
INSERT INTO wib_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Pè mɛ à syah nɛ, Nasarɛtɩ Yesu-á pɔ n sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Képah tɛ̃̀nɛ, à tyah n yo n mɔ léyy nɛ, Yesu, Davidi Pídĩ́, à pé yãm yah. ");
INSERT INTO wib_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Tɛ́ nónó-á mɛ n kɔ yah tĩ̀nnɛ, pépi sõ̀ mɛ dírílɛ n kõ ǹ yõ nɛ, à ǹ vyãh vike. Ǹtɛ, ǹmɔ tɛ̃̀ sõ̀ mɛ n tɔ̃ n gbah n yo n mɔ nɛ ńkɛ̃́, Davidi Pídĩ́, à pé yãm yah. ");
INSERT INTO wib_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Képah sɔkɔ, Yesu mɛ yĩn, tɛ́ nɛ, pè pɔ ǹnɛ. Wǎh nɔ de, Yesu mɛ à piki yah: ");
INSERT INTO wib_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«Tir nɛ̂ mɛ á mɛ ké tyɩ́ nɛ, mé pɩ á tyɩ́?» Dĩ́ mɛ à syah nɛ, pé Yõ̀tɛ̃̀, à kè pɩ, pé fɛ̃ nɛ n yah ńtɔ̃. ");
INSERT INTO wib_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesu mɛ yo ǹ tyɩ́: «Á yɩ̃́ ye yɩkɩ mɔ! Á Liyel yõ sɛ̃́nɔ́ ye ǹ dɛ mɔ.» ");
INSERT INTO wib_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Nɛ́npɔ́ swɔ, ǹ yɩ̃́ núkú yɩkɩ mɔ, tɛ́ à mɛ Yesu sõ̀ tɛ̃, à Liyellɛ n gbilki. No pól-á képah wɛ sɛ̃́, pé tɔ tyah Liyellɛ n gbilki. ");
INSERT INTO wib_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu-á de Yeriko kwil, à sõ̀ mɛ n kah ké sɔkɔ, ");
INSERT INTO wib_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","tɛ́ dĩ́ yɔ́ sõ̀ mɛ kénɛ kwil, pè n ye Nsasyɩlɛ. Mɔ́rɩ́ syípú yõ̀tãm sɔkɔ yɔ́ ye sõ̀ ǹnɛ, tɛ́ à pɩ tàhlɛ. ");
INSERT INTO wib_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","À sõ̀ mɛ n yah n kɔ̃ nɛ, pé Yesu wɛ, nɛ́dúkú nɛ̂-á ǹnɛ. Tɛ́ ǹmɔ-á pɩ nɛ́túkúrí nɛynɛ, tɔ́wû tnɔ́nkàhnɔ́ tɛ̃̀ tyɩ́, à náh sõ̀ fɛ̃ à wɛ n pi. ");
INSERT INTO wib_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Kǎh pɩ sɛ̃́, à to yuku yah tĩ̀nnɛ, à kyɩ dɔkɔ séswɔ̂ yɔ́ sɔkɔ Yesu wɛ yĩnnɛ. Tɛ́ à kɩ sõ̀ pɔ n sɔkɔ n pi nɛ́npɔ́. ");
INSERT INTO wib_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yesu-á yĩni tɛ̃ nɛ́npɔ́, à ǹ yah yɔ̃ tɛ́ yo Nsasyɩ tyɩ́ nɛ ńkɛ̃́, à tiki súú Nsasyɩ, páh yɩ̃nɛ pé twah ǹ kéte sɔkɔ kwɛynɛ. ");
INSERT INTO wib_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Képah tɛ̃̀nɛ, Nsasyɩ núkú tiki súú, à kyɩ Yesu tɔ̃ sah tɛ̃ ǹ tĩ̀nnɛ nɩ̀vɩ̀ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Névye-á képah wɛ sɛ̃́, pé pól tyah ǹ tyɩ́lɛ n plɔ n yãh nɛ, tyípêl pɩ́-ò tyɩ́-á à kyɩ twah yɔ̀ dɛ́! ");
INSERT INTO wib_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ǹtɛ, Nsasyɩ mɛ nɔ de Tɛ̃̀ ǹgbɛ̃ Yesulɛ, tɛ́ yo ǹ tyɩ́ nɛ, à noh pé tyɩ́, pé yõ̀tɛ̃̀. Páh kɩ pé gbã̀n yî tɔ́nɩ́ núkú yɩ̃ yãm tãn kɔ̃. Ànɛ̂, pâh mɛ syɩkɩ nɛ̂ yõ, páh kɩ sɛ̃́nknɔnɔ ńyã́hlɛ tɛ̃̀ dyah. ");
INSERT INTO wib_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Képah sɔkɔ, Yesu mɛ yo ǹ tyɩ́: «Áwɔ tɔ-á pɩ Abrahmɩ náh nɛynɛ, képah ye, pwáhnmɔnɔ de kéte mɛ̀ sɔkɔ kwɛynɛ. ");
INSERT INTO wib_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Yah, nónó-á sõ̀ mɛ mɔ́npunɔlɛ, pépi yáhnkɔ̃-ńsah ye Névi Pi pɔ kɩ pè pwah mɔ.» ");
INSERT INTO wib_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Képah tɛ̃̀nɛ, Yesu-á de n tɛ Yerusalɛmɩ sɔkɔ, ǹ wɛlɔ nóhpú sõ̀ mɛ n sõ nɛ, Liyel tɔ̃́rɩ́-á kɩ n pɔ n pi nɛ́npɔ́ swɔ. Képah sɔkɔ, Yesu mɛ sèmìrkì yɔ́ yãh pé tyɩ́ nɛ: ");
INSERT INTO wib_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","«Yõ̀tɛ̃̀ yɔ́ pídĩ́ ye lésõ. Sṍ yɔ́lɛ, à yuku sɔkɔ kwil fɩ́ɩ́ yɔ́ sɔkɔ nɛ, pé kyɩ yõ̀tɔ̃rɩ́ yah n kɔ̃, képah náh, pé mó pé syɩ pɔ. ");
INSERT INTO wib_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Wǎh n sɔkɔ, à ǹ tõ̀npɩbɩ nɛ́pĩ̂ gbãm ye pɔ, pɔ́ dan núkúlɛ pé nɛ́núkù núkú pól kɔ̃, tɛ́ yo pé tyɩ́ nɛ, pè gbɔ̀lɛ n yɩ̃ sépilɛ fɔ́ɔ́, kè pɔ syɩ pé syɩ́npɔnɔ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Tɛ́, ǹ kwil névye sõ̀ mɛ ǹ dyɔlɛ n yɔ. Pè mɛ tɛ̃ntõ̀ tɛkɩ mɔ ǹ náh, à kyɩ yo nɛ ńkɛ̃́, pépi náh mɛ ké tyɩ́ nɛ, dĩ́ mɛ̀ tɛ̃̀ pɔ pɩ pépi yõ̀tɛ̃̀nɛ. ");
INSERT INTO wib_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ǹtɛ, à mó tɔ̃ yõ̀tɔ̃rɩ́ mɛ̀ wɛ, tɛ́ ǹ syɩ pɔ. Wǎh pɔ, à ǹ tõ̀npɩbɩ nɔ́pi ye, wǎh sõ̀ pɔ́ dibi nónó kɔ̃. Pǎh gbɔ̀ yɩ̃, tɛ́ pɔ́ dòhnɔ̀ nɛ̂ wɛ, à sõ̀ mɛ ké tyɩ́ nɛ, pé kè pɩ̃. ");
INSERT INTO wib_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Képah sɔkɔ, nɛ́gben pɔ yo ǹ tyɩ́ nɛ ńkɛ̃́, pé yõ̀tɛ̃̀, wǎh pɔ́ dan nɛ̂nɛ pé kɔ̃, páh ké kénknɔnɔ gbãm yah dohnɩ. ");
INSERT INTO wib_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Yõ̀tɛ̃̀ dĩ́ mɛ yo ǹ tyɩ́ nɛ, kǎh plɛ, tõ̀npɩ pèpɛy-á ǹnɛ. Wǎh fyɔ̀ pɩ nɛ́gbɩ́lɛ tir tyɩ̃́ɩ̃ sɔkɔ, wǎh kɩ pɩ kwlonɔ gbãm yah tɛ̃́-òlɛ. ");
INSERT INTO wib_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ní-ò mɛ pɔ yo ǹ tyɩ́ nɛ ńkɛ̃́, pé yõ̀tɛ̃̀, wǎh pɔ́ dan nɛ̂nɛ pé kɔ̃, páh ké kénknɔnɔ kwlɔ yah dohnɩ. ");
INSERT INTO wib_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Yõ̀tɛ̃̀ dĩ́ mɛ képah núkú ó yo ǹ tɔ tyɩ́ nɛ, ǹmɔ pɩ kwlonɔ kwlɔ yah tɛ̃́-òlɛ. ");
INSERT INTO wib_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Kèyǎh mɛ pɔ yo ǹ tyɩ́ nɛ ńkɛ̃́, pé yõ̀tɛ̃̀, ǹ pɔ́-á yɔ̀. Páh sõ̀ mɛ kè dah mɔ sah fwɔ yɔ́ sɔkɔ ké tyɩ́lɛ. ");
INSERT INTO wib_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ńkɛ̃́, ǹ tõ̀-á kah tah. Képah-á, ǹ tíkí mɛ pé tɛ̃. Ǹmɔ náh sah kwâh nɛ̂nɛ, ǎ kè tɔkɔ. À náh sèmukɔ nɛ̂ duku mɔ, ǎ képah tɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Képah tɛ̃̀nɛ, yõ̀tɛ̃̀ dĩ́ mɛ à syah nɛ, tõ̀npɩ túkù, ǹ vyãh wɛy mɛ̀ sɔkɔ-á pé kɩ tuke ǹnɛ. Ǹmɔ-á sõ̀ pɩ̃ nɛ ńkɛ̃́, pé tõ̀-á tah, pé náh kwâh nɛ̂ sah, pě kè tɔkɔ, ànɛ̂ pé náh sèmukɔ nɛ̂ duku, pě kɩ tɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ǹtɛ, kwâh nɛ̂ se pɩ, tɛ́ à náh pé pɔ́ dah mɔ sah pɔ́ dáhnmɔ-ńsah wɔ̀kɔ̀ sɔkɔ nɩ? Páh pé syɩ pɔ, páh náhkɩ sè wɛ wilki dòhnɩ̀nɔ́lɛ sé yõ. ");
INSERT INTO wib_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Képah sɔkɔ, nónó-á sõ̀ mɛ nɛ́npɔ́, à ǹ syɩ yo pé tyɩ́ nɛ, pè pɔ́ mɛ̀ syi ǹ tyɩ́, pè kélɛ ké kénknɔnɔ gbãm nɛ́tɛ̃̂ kɔ̃. ");
INSERT INTO wib_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Pè mɛ yo ǹ tyɩ́ nɛ, pé yõ̀tɛ̃̀, sé gbãm-á mɛ tɛ ǹmɔ tyɩ́ dò! ");
INSERT INTO wib_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ǹtɛ, à mɛ pè syah nɛ: «Mé kélɛ n yo yé tyɩ́ nɛ: névi nɛ̂ tyɩ́ kwâh-á mɛ, pè kɩ tɔ̃ ǹmɔ kɔ̃. Tɛ́ névi nɛ̂ tyɩ́ kwâh náh mɛ, kwéyy nɛ̂ ńtɛ̃-á mɛ ǹ gbõ̀, ké tɔ kɩ tɛ̃ syi ǹ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ǹtɛ, ń sépɛ́bɩ́ tɛ̃̀ wɔlɛ, pépi nónó náh sõ̀ mɛ ké tyɩ́ nɛ, mé pɩ pé yõ̀tɛ̃̀nɛ, yé pɔ pélɛ ásõ̂, yé pɔ pé yɛ̀sõ̀ kõ ń yĩ́ yah.» ");
INSERT INTO wib_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Képah yóntɛnɔ náh, Yesu yĩn pé yah, pè n dɔkɔ n yuku Yerusalɛmɩ. ");
INSERT INTO wib_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Tɛ́ wǎh yĩni tɛ̃ n tɛ gbĩ́ nɛ̂nɛ Betefasyɩ ànɛ̂ Betanɩlɛ yɔ̃lɩ yɔ́ tnɔ̂, pè n ye Wólívî yèh yɔ̃lɩlɛ, à ǹ tõ̀ sã́hpú nɛ́pĩ̂ nímí tõ nɛ: ");
INSERT INTO wib_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","«Kwil nɛ̂-á yé yahlɛ, yé kyɩ ké sɔkɔ. Yáh kɩ n de, yé kɩ ńkwɛ̃́ndyɩ́pìkì yɔ́ wɛ tóhnmɔnɔlɛ nɛ̂-á nɛy náh dɔkɔ yah ǹ yõ póllɛ. Yé à dɛ n pɔ ásõ̂. ");
INSERT INTO wib_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Tɛ́ nɛ̂-à yé piki yah nɛ ńkɛ̃́, sɔ̃́ se, tɛ́ yé ǹnɛ n dɛ nɩ, yé yo tɛ̃̀ tyɩ́ nɛ, ǹ yétõ̂-á mɛ Tɛ̃̀ ǹgbɛ̃ tyɩ́, képah-á. ");
INSERT INTO wib_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Wǎh yo sɛ̃́, tɛ̃ntõ̀ névye nɔ́pi sɔkɔ. Pè ńtyɩ̃́nɔ kyɩ tyi nɔ́pi wɛ, sɔ̃́-á sõ̀ à yo kélɛ pé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Pǎh mɛ ǹ dɛ́nɔ́ sɔkɔ gbĩ́ nɛ̂nɛ, ǹ nɛ́tãm pè piki yah nɛ, sɔ̃́ se, tɛ́ pè ńkwɛ̃́ndyɩ́pìkì mɛ̀nɛ n dɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Pè mɛ yo pé tyɩ́ nɛ ńkɛ̃́, ǹ yétõ̂-á mɛ Tɛ̃̀ ǹgbɛ̃ tyɩ́, képah-á. ");
INSERT INTO wib_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Tɛ́ mɛ yuku ǹnɛ Yesu tyɩ́. Pè pé flɔ mɔ ǹ yõ, à Yesu kɔ̃ à dɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Képah tɛ̃̀nɛ, wǎh mɛ n yuku sɔ̃́, névye mɛ pé flɔlɛ n mɔ n yuku sɛ̃́ wɛ̃̀kɩ̀ yõ. ");
INSERT INTO wib_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Pǎh n tyah Wólívî yèh yɔ̃lɩ tíkíntɛnɔlɛ, nɩ̀vɩ̀ de ǹ tõ̀ sã́hpú kwĩnki pól sɔkɔ. Pǎh gbǐl tyi nónó pól wɛ, sépi yĩnnɛ, pè tyah Liyel yĩnnɛ n gbilki yĩ́npɔ̃́ ǹgbɛ̃nɛ, ");
INSERT INTO wib_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","mɛ yo tũ nɛ ńkɛ̃́: «Yõ̀tɛ̃̀ nɛ̂-á n pi Liyel yĩn yõ, Liyel sãm mɔ ǹ sɔkɔ! Yèvɩnɩ nɛ mɛ yĩ̂nyõ, gbílkínɔ́ mó nɛ n sah Liyel yõ, ǹmɔ nɛ̂-á yĩ̂nyõ fléyy tɛ̃̀-ǹsah.» ");
INSERT INTO wib_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Képah sɔkɔ, tɔ́wû nɩyṍ sɔkɔ Farisiyɛ̃nɔ yísyɔ́ Yesu syah nɛ, pé kwɔ́-ò dĩ́, à ǹ tõ̀ sã́hpú vyɛ̃y tũ kɛ̀! ");
INSERT INTO wib_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Képah tɛ̃̀nɛ, Yesu pè syah nɛ: «Mé kélɛ n yo yé tyɩ́ nɛ: pàh kɩ sɔ̃́ pé vyɛ̃y vike ò, dyêh ye kɩ n gbo n mɔ pé swɔ.» ");
INSERT INTO wib_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesu-á de n tɛ Yerusalɛmɩ, tɛ́ kè wɛ gbĩ́ nɛ̂nɛ, à n gbo ké yĩnnɛ nɛ: ");
INSERT INTO wib_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","«É, Yerusalɛmɩ, wáh náhkɩ sõ̀ mɛ fɛ̃ syi yèvɩnɩ wɛ dùkù pɩ̃ kwɛy mɛ̀nɛ! Ǹtɛ wéèè, kè ye wɔ̃bɩ á yah! ");
INSERT INTO wib_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Yah, sèpĩ̀n yísyɔ́ mɛ n pi, á sépɛ́bɩ́ kɩ wɔ̃̀bɩ̀-ǹtã̀n pɩ á kɛ̃kɩ kore vi, tɛ́ kɩ ǹ fyãh sah yey yey póllɛ. ");
INSERT INTO wib_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Liyel-á pɔ á yòhnɩ̀nmɔ-ńsah gbĩ́ nɛ̂nɛ, á náh fɛ̃ syi kè pɩ̃. Képah ye, pè kɩ á sɔkɔ névye pól ko mɔ, tɛ́ kɩ ǹ mukuli. Á dáhkɩ̀ yɔ́ ńtɛ̃ náh n wũ n pi ké ní-ò yõ.» ");
INSERT INTO wib_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesu-á kyɩ de Liyel wɔ̀kɔ̀ ǹgbɛ̃ kéntáhkɩ̀, tɛ́ yíyã̌m yã̀mpu wɛ ké sɔkɔ, à tyah pélɛ n yĩni n wilki. ");
INSERT INTO wib_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Tɛ́ mɛ n yo pé tyɩ́: «Kè mɛ wã́rkɩ́nsàhnɔ́lɛ Liyel wɛy sɔkɔ nɛ ńkɛ̃́: ‹Ń wɔ̀kɔ̀ kɩ pɩ nírí pɩ́-ńsah wɔ̀kɔ̀lɛ›. Tɛ́ yépilɛ, yé kè tɔkɔ pɩ névye yõ syɩ́kɩ́pú tɛ̃̀-ǹsahlɛ.» ");
INSERT INTO wib_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Tɛ́ à sõ̀ mɛ névyelɛ n kwɔ sõmɛsṍ Liyel wɔ̀kɔ̀ ǹgbɛ̃ kéntáhkɩ̀ sɔkɔ. Képah sɔkɔ, sárká wìlkìpu yõ̀tãm, ànɛ̂ Liyel ǹgbò wɛ̃̀kɩ̀ kwɔ́pú sõ̀ mɛ ǹ kònmɔ-ńsahlɛ n yah n kɔ̃, kwil yah tãm tɔlɛ pélɛ. ");
INSERT INTO wib_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Tɛ́ no pól-á sõ̀ mɛ pé ní kwɔ n tɔ̃ n sah n nohnɩ n yĩ́ĩ́ ǹ tyɩ́ sɛ̃́, képah ye, pè náh pɩ̃ pǎh kɩ n pɩ n pi sɔ̃́. ");
INSERT INTO wib_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Yesu-á sõ̀ mɛ névyelɛ n kwɔ Liyel wɔ̀kɔ̀ ǹgbɛ̃ kéntáhkɩ̀ sɔkɔ, mɛ nɩ̀vɩ̀nɩ̀ wɛy sã́nnɛ n yo sɛ̃́, sṍ yɔ́lɛ, sárká wìlkìpu yõ̀tãm, ànɛ̂ Liyel ǹgbò wɛ̃̀kɩ̀ kwɔ́pú, ànɛ̂ yèwàhnɩ̀ pɔ wil ǹ tyɩ́, ");
INSERT INTO wib_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","tɛ́ à syah nɛ, à yo pé syah, nɛ̂ gbõ̀ yõ sɔkɔ se, à n pɩ tyi nɔ́pilɛ, nɛ̂ se à kɔ̃ tɛ̃́nwɛnɔ mɛ̀nɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","À mɛ yo pé tyɩ́: «Ńmɔ tɔ kɩ píkínyahnɔ núkú pɩ yé tyɩ́: Yé yo ń syah, ");
INSERT INTO wib_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","nɛ̂-á tõ Nsyɔ̃nɛ, à pɔ nolɛ n wel n wilki? Liyel se, tĩ̂ névye se?» ");
INSERT INTO wib_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Pè mɛ yo wɛ̃ tyɩ́ nɛ, páh kɩ nɛ ńkɛ̃́, Liyel-á tõ ǹnɛ, wǎh kɩ pé syah nɛ, tɛ́ kwâh nɛ̂ se pɩ, tɛ́ pé náh sɛ̃ ǹ yõ nɩ? ");
INSERT INTO wib_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ǹtɛ, névye sɛ̃́nyĩnɔ-á mɛ tɛ ké yõ nɛ, Liyel tɛ̃ntõ̀ syínyo-ò-á Nsyɔ̃nɛ, páh kɩ mó tɔ̃ nɛ ńkɛ̃́, névye-á tõ ǹnɛ, no pól-á kɩ dyêhlɛ pé minki ko. ");
INSERT INTO wib_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Kǎh pɩ sɛ̃́, pè à syah nɛ, pé náh pɩ̃ nɛ̂-á tõ ǹnɛ. ");
INSERT INTO wib_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Pǎh yo sɛ̃́, Yesu tɔ mó pè syah nɛ, kàh pɩ sɛ̃́, tɛ̃́nwɛnɔ nɛ̂-á pé kɔ̃ pé tyi nɔ́pilɛ n pɩ, pé náh mó kè yo pè syah n pi. ");
INSERT INTO wib_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Képah náh, Yesu tyah sèmìrkì yɔ́lɛ n yãh névye tyɩ́ nɛ: «Dĩ́ yɔ́ ye lésõ dìvɛ̃ sésân swãh kõ, tɛ́ kélɛ tɛ̃̀ntõbe gbõ̀ dahbɩ, tɛ́ sɔkɔ kɔ́lɔ́ sɔkɔ à kyɩ mo. ");
INSERT INTO wib_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Sé pye gbɛ gbĩ́-á pɔ nɔ, à tõ̀npɩ yɔ́ tɛkɩ mɔ dìvɛ̃ sésân swah tɛ̃̀ntõbe nɔ́pi tyɩ́ nɛ, pè pé tyɩ́ dìvɛ̃ sésân pyelɛ à kɔ̃. Ǹtɛ, tɛ̃̀ntõbe nɔ́pi mɛ tõ̀npɩ mɛ̀ ko, tɛ́ pé syɩ à tɛkɩ mɔ ǹ gbõ̀ kɔ́kɔ́lɛ. ");
INSERT INTO wib_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Képah sɔkɔ, sètɛ̃̀ dĩ́ tɔ̃ ǹ syɩ tõ̀npɩ yɔ́ tɛkɩ mɔ. Pè tɔ̃ ǹmɔ tɔ ko, tɛ́ à gbyɔ, tɛ́ pé syɩ à tɛkɩ mɔ ǹ gbõ̀ kɔ́kɔ́lɛ. ");
INSERT INTO wib_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","À tɔ̃ ǹ syɩ tõ̀npɩ tɔ̃́-ò tɛkɩ mɔ. Pè tɔ̃ ǹmɔ tɔ pɩ yɔ, tɛ́ à yĩni. ");
INSERT INTO wib_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Kǎh pɩ sɛ̃́, sètɛ̃̀ dĩ́ nɛ, sɔ̃́ se pé kɩ pɩ nɩ? Páh kɩ pé nɩ̀dɛ̀ pídĩ́ wɔ tɛkɩ mɔ. Ǹmɔ wɔlɛ, gbɔ̀kénpɩ, pǎh kɩ yõ̀yén sah ǹ yõ. ");
INSERT INTO wib_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ǹtɛ, dìvɛ̃ sésân swãh tɛ̃̀ntõbe nɔ́pi-á fyɔ̀ ǹ pídĩ́ wɛ, pè núkú yo wɛ̃ tyɩ́ nɛ ńkɛ̃́, ǹ gbɛ̃̀yõ-á yɔ̀. Pé ye à ko mɔ, gbɛ̃kɩ mó pɩ pépi tyɩ́lɛ. ");
INSERT INTO wib_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Képah tɛ̃̀nɛ, pè à yɔrɩ wilki mɔ dìvɛ̃ sésân swãh kahnɩnɛ, tɛ́ à ko mɔ. Núkúnúkú tɛ̃̀nɛ, sɔ̃́ mɛ sètɛ̃̀ dĩ́ kɩ pɔ pɩ pélɛ wɛ́? ");
INSERT INTO wib_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","À náh pɔ dìvɛ̃ sésân swãh tɛ̃̀ntõbe nɔ́pi ko mɔ, tɛ́ kɩ kè dahbɩ n pi yísyɔ́ gbõ̀ di?» No-á kénɛ wɛlɔ noh sɛ̃́, pè nɛ, póllɛ, képah wɔ náh n pɩ n pi! ");
INSERT INTO wib_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ǹtɛ, Yesu mɛ pè yah, tɛ́ yo pé tyɩ́: «Liyel wɛy-á nɛ̂ yo nɛ ńkɛ̃́: ‹Wɔ̀kɔ̀ mɔ́pú-á dáhkɩ̀ nɛ̂ milki, képah ye pɔ pɩ wɔ̀kɔ̀ kyɩ̃ yõ dáhgbɩ́lɛ›, képah yõ nɛ̂nɛ yépi tɛ̃̀ tyɩ́? ");
INSERT INTO wib_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Névi nɛ̂-à wil syɩkɩ kénɛ dáhkɩ̀ yõ, tɛ̃̀ kɩ kwɔkɩ. Tɛ́, kàh se mó tɔ̃ syɩkɩ nɛ̂ yõ, kè kɩ tɛ̃̀ pyãhrɩ.» ");
INSERT INTO wib_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Képah sɔkɔ, Liyel ǹgbò wɛ̃̀kɩ̀ kwɔ́pú, ànɛ̂ sárká wìlkìpu yõ̀tãm ǹgbnɔ sõ̀ pɩ̃ yĩ́ĩ́ tɛ nɛ, pépi yõ-á Yesu mɩ sèmìrkì mɛ̀nɛ. Képah ye, pè sõ̀ mɛ ǹ tɛ̃́-ńsahlɛ n yah n kɔ̃ nɛ́npɔ́ swɔ, tɛ́ névye tíkí pè tɛ̃. ");
INSERT INTO wib_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Képah sɔkɔ, pè tyah Yesu kyɔ̀mɩ̀nɔ́lɛ. Pè yĩ́nvínpɩbɩ yísyɔ́ tɛkɩ mɔ ǹ tyɩ́. Pè pɔ pé gblɔ̌y pɩ nɛ́gblɔ́lɛ. Pè sõ̀ mɛ ké tyɩ́ nɛ, à pilki ǹ vyãh wɛy sɔkɔ, pé kɔ̃ pé à wɛ tɛ̃ kyɩ dahbɩ kwil yah tɛ̃́-ò gbõ̀, tɔ̃́rɩ́ ànɛ̂ tɛ̃́nwɛnɔ-á mɛ nɛ̂ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Képah tɛ̃̀nɛ, pè píkínyahnɔ yɔ́ pɩ Yesu tyɩ́ nɛ, kwɔ́-ò dĩ́, páh pɩ̃ nɛ, wǎh tyi nónónɛ n yo, tɛ́ kwɔ́nɔ́ nónónɛ n pɩ, gblɔ kɔ́kɔ́-á sélɛ. Á náh névyelɛ n wah, ànɛ̂ wǎh Liyel wɛ̃̀kɩ̀lɛ névyelɛ n kwɔ ké gbɩ yõ. ");
INSERT INTO wib_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ǹtɛ, à yo pé syah, ńkɛ̃́, ké wɛ̃̀kɩ̀ se mɛ kɔ̃́nɔ́lɛ nɛ, pé mɔ́rɩ́lɛ n mɔ Wromɛnɔ yõ̀tɛ̃̀ ǹgbɛ̃ Sesarɩ tyɩ́, tĩ̂ ké wɛ̃̀kɩ̀ náh mɛ kɔ̃́nɔ́lɛ? ");
INSERT INTO wib_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Tɛ́ Yesu-á pé yĩ́nvǐ pɩ̃ sɛ̃́, à yo pé tyɩ́: ");
INSERT INTO wib_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«Yé pɔ pɔ́ pɔ́ núkúlɛ, mé yah ǎtrɛ. Nɛ̂ yah mírkí, ànɛ̂ ǹ yĩn mɛ wã́rkɩ́nmɔnɔlɛ ké yõ yɔ̀?» Pè mɛ yo ǹ tyɩ́ nɛ, Sesarɩ tyɩ́-á. ");
INSERT INTO wib_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Yesu mɛ yo pé tyɩ́: «Kàh pɩ sɛ̃́, yé Sesarɩ tyɩ́lɛ Sesarɩlɛ n kɔ̃, yé mó Liyel tyɩ́lɛ Liyel kɔ̃.» ");
INSERT INTO wib_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Kǎh pɩ sɛ̃́, pè náh pílkí-ńsah wɛ ǹ wɛy sɔkɔ, à à tɛ̃ névye yĩ́ yah. Tɛ́ ǹ tyi yah yónɔ́ pyě mɛ pé gbã̀n du, pè mɛ tɛ̃ syɩ́syɩ́. ");
INSERT INTO wib_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sadusɛ̃nɔlɛ, nósyɔ́ ye, nónó-á nɛ, lékyɩ̂ náh min sã́n wɛ n pi. Pé nɔ de Yesulɛ, tɛ́ à piki yah nɛ, ");
INSERT INTO wib_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","pé kwɔ́-ò dĩ́, Moyisi-á kɩ wãrkɩ sah pé kɔ̃ nɛ ńkɛ̃́, sétɛ̃̂ nɛ̂-à ku pi wɛ́-ńkɛ̃̂nɛ, tɛ́ gbɛ̃̀ mɛ tɛ̃̀ tyɩ́, gbɛ̃̀ mɛ̀-á yɩ̃nɛ à pɛ́kúsè mɛ̀ tɔkɔ, à mó wɛ̃́npì dubi à kɔ̃ ǹ nɛ́nkyɩ́ náhnɛ. ");
INSERT INTO wib_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ǹtɛ, kèkùrkì núkú dĩ́npì nɛ́pĩ̂ kwǎrninɔ yísyɔ́-á lésõ mɛ. Nɛ́nkyɩ́ tɛ̃̀ mɛ sê tɔkɔ, tɛ́ ku, tɛ́ à sah píkã́nnɛ. ");
INSERT INTO wib_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ǹ sõ̀ syɩ mɛ pi mɛ̀ tɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Képah náh, tɔ̃́-ò mɛ à tɔkɔ. Kè n pɩ n yuku sɛ̃́ fɔ́ɔ́, pé nɛ́pĩ̂ kwǎrnímí pól à tɔkɔ. Tɛ́, pé pól pɔ ku, tɛ́ à sah píkã́nnɛ. ");
INSERT INTO wib_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Képah náh, pi mɛ̀ tɔ pɔ ku. ");
INSERT INTO wib_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ǹtɛ, pi mɛ̀-á de yah sɛ̃́ nɛ́pĩ̂ kwǎrnímí nɔ́pi tyɩ́-à, lékyɩ̂ min sã́n pɔ́nwɛ sṍlɛ, à kɩ n pɩ n pi pé sɔkɔ nɛy nɛ̂ tyɩ́lɛ? ");
INSERT INTO wib_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Pǎh yo sɛ̃́, Yesu yo pé tyɩ́: «Kèkõyṍ mɛ̀ tɛ̃̀ wɔ sɔkɔ, sétɔ́kɔ́kɩ̀ mɛ, ànɛ̂, pɛ́dékè mɛ. ");
INSERT INTO wib_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ǹtɛ, Liyel-á nónó kyɔmɩ wɛ nɛ, pǎh yɩ̃nɛ dénɔ́lɛ kèkõyṍ sã́n sɔkɔ, tɛ́ kɩ min sã́nnɛ pè kɔ̃ n pi lékyɩ̂ min sã́n pɔ́nwɛ sṍlɛ, pépi náh syɔ́ tɔkɔ n pi, pè náh n de n pi pɛbɩ tyɩ́ póllɛ. ");
INSERT INTO wib_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","À kɩ pè wilki kũ sɔkɔ, kɩ min sã́nnɛ pè kɔ̃. Pè kɩ pɩ yĩ̂nyõ tɛ̃ntõnè tyɩ́ kɔ̃lɛ: Pè náh tɔ̃ n ku n yah n pi. Pè ye pɩ Liyel pyelɛ. ");
INSERT INTO wib_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Moyisi tɔ ye kè yo wah yĩ́ĩ́ nɛ ńkɛ̃́, lékyɩ̂-á kɩ pɔ pé syɩ min sã́n wɛ. Ǹ sɛ́bɛ́y fɩ̃́ nɛ̂-á dukuni tyɩ́lɛ n yo nɛ̂-á sõ̀ nyàh lépɔ̃́lɛ ké sɔkɔ, képah sɔkɔ ye à Tɛ̃̀ ǹgbɛ̃ Liyel ye ‹Abrahmɩ Liyellɛ, ànɛ̂ Yisakɩ Liyellɛ, ànɛ̂ tɔ̃ Yakɔbɩ Liyellɛ›. ");
INSERT INTO wib_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Liyel tyɩ́, no pól mɛ vyelɛ. Képah ye, lékyɩ̂ Liyel náh ǹnɛ, vye Liyel ye.» ");
INSERT INTO wib_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","40","Wǎh yo sɛ̃́, nɩ̀sãh náh tɔ̃ sõ̀ mɛ pé tyɩ́, kɩ à piki yah. Képah ye, Liyel ǹgbò wɛ̃̀kɩ̀ kwɔ́pú yísyɔ́ yo ǹ tyɩ́ nɛ, kwɔ́-ò dĩ́, wǎh wɛkɩ plɛ. ");
INSERT INTO wib_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Képah sɔkɔ, à mɛ yo pé tyɩ́: «Á kɩ yo sɔ̃́ nɛ, Davidi náh nɛy ó-á Kristalɛ nɛ̂-á Liyel nɛ, páh kɩ tɛkɩ mɔ? ");
INSERT INTO wib_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Tɛ́ ǹmɔ Davidi ńtɛ̃ mó tɔ̃ kè yo ǹ yɩ̀gbɩ̀nɩ̀ sɛ́bɛ́y sɔkɔ nɛ ńkɛ̃́: ‹Tɛ̃̀ ǹgbɛ̃ Liyel ye kè yo ńmɔ Tɛ̃̀ ǹgbɛ̃ tyɩ́ nɛ ńkɛ̃́: «Pɔ n kɔ̃ n tɛ̃ ń gbõ̀yõ̀ sõ̀lɛ, ");
INSERT INTO wib_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","fɔ́ɔ́ kè pɔ nɔ gbĩ́ nɛ̂-á mé kɩ á sépɛ́bɩ́ pɩ á gbáhsúkílɛ.›» ");
INSERT INTO wib_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ǹtɛ, Davidi ńtɛ̃ wɛ à ye ǹ TƐ̃̀ ǸGBƐ̃NƐ à kɩ tɔ̃ pɩ sɔ̃́, tɛ́ kɩ pɔ n pɩ ǹ náh nɛy ólɛ?» ");
INSERT INTO wib_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Képah náh, à yo ǹ tõ̀ sã́hpú tyɩ́ ǹ wɛy nóhpú pól yĩ́ yah nɛ: ");
INSERT INTO wib_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Liyel ǹgbò wɛ̃̀kɩ̀ kwɔ́púlɛ, fwɔ̀mɔ̀ngbnɔ mɔ́nkɔnkɔ̃nɔ tyɩ́ nɔ pé tyɩ́. Pè n nɛ n mɛ ké tyɩ́ nɛ, no nɛ n tɔ̃ n sah n wɛkɩ pé tyɩ́ tɔ́wû tùkè-ǹtã̀n sɔkɔ. Tɛ̃̀-ǹtã̀n gbro tyɩ́ nɔ pé tyɩ́ Liyel ní-ńtã̂n vɩ̀ sɔkɔ, ànɛ̂ yé yṍ-ńtã̂n sɔkɔ. Yé yé gblɔ̌ynɛ n kyɔmɩ pélɛ! ");
INSERT INTO wib_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Tɛ́ pépi ó ye tɔ̃ n vi n tɛ̃ pɛ́kúsyɔlɛ, à pé gbã̀n yîlɛ n syi, ǹ tɛ́ nírílɛ n pɩ yõ̀sɛ̃̀kɩ̀lɛ, ǹ névye yahlɛ n pil nɛ, páh mɛ tómm. Ǹtɛ, pé tukey kɩ n pɩ n pi képékèyɔ̂, à kal no tɛ́lɔ́ tyɩ́lɛ.» ");
INSERT INTO wib_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Sṍ yɔ́lɛ, Yesu sõ̀ mɛ Liyel wɔ̀kɔ̀ ǹgbɛ̃ kéntáhkɩ̀ sɔkɔ, tɛ́ wǎh ǹ yah yɔ̃, à tahbɩ wɛ, pè mɛ pé yɩ̃́nkɔ̃ kɔ̃ pɔ́lɛ n dah n mɔ n pɔ pɔ́ dáhnmɔ-ńsah kwâh sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","À pɛ́kúsè yãm nɛy yɔ́ tɔ wɛ, à pɔ pɔ́pî plɔ́ nínɔ́ dah mɔ. ");
INSERT INTO wib_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","4","Képah sɔkɔ, à nɛ: «No póllɛ, pɔ́ nónó yétõ̂ náh mɛ pè tɛ̃, sépi ye pè tɔkɔ pɔ dah mɔ. Ǹtɛ, pɛ́kúsè yãm nɛy mɛ̀nɛ, ǹmɔ ye ǹ yãm fõh, tɛ́ ǹ yõ yõ pɔ́ pól tɔkɔ pɔ dah mɔ. Képah ye, mé kélɛ n yo n dal n mɔ yé tyɩ́ kègbɩ yõ nɛ: ǹmɔ-á dah mɔ kal no póllɛ.» ");
INSERT INTO wib_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Képah náh, névye túkù sõ̀ mɛ n yo nɛ, Liyel wɔ̀kɔ̀ ǹgbɛ̃-á mɛ plɛ: Ńkɛ̃́, ké mɔ mɔ dyêh, ànɛ̂ ké vyɔ́ nónó-á névye yɩ̃ Liyel kɔ̃, sǎh mɛ kè syi yĩ́ĩ́. Ǹtɛ, Yesu mɛ yo pé tyɩ́: ");
INSERT INTO wib_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«Nɛ̂-á yé n yah yɔ̀ kɛ̀, sèpĩ̀n yísyɔ́ mɛ n pi, dáhkɩ̀ yɔ́ ńtɛ̃ náh n wũ n pi ké ní-ò yõ. Sé pól kɩ pirki.» ");
INSERT INTO wib_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Képah sɔkɔ, pè mɛ Yesu piki yah nɛ ńkɛ̃́, kwɔ́-ò dĩ́, gbĩ́ nɛ̂ se képah kɩ pɩ nɩ? Ànɛ̂, kwní yṍnmɔnɔ nɛ̂ se kɩ wɛ̃kɩ kélɛ nɛ, kǎh kɩ n pɩ n pi nɩ? ");
INSERT INTO wib_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","À mɛ yo pé tyɩ́: «Névye náhnáh kɩ pɔ ńmɔ yĩn tɔkɔ n pi pé yah yĩ́ĩ́nɛ, tɛ́ kɩ n yo nɛ ńkɛ̃́, pépi-á Ńmɔlɛ. Ńkɛ̃́, ké gbĩ́-á nɔ tɛ! Ǹtɛ, yé káh pé sõ̀ tɛ̃! Yé yé gblɔ̌ynɛ n kyɔmɩ, yé káh yɛ nɛy pɔ yé pilki. ");
INSERT INTO wib_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Yâh pɔ mâl, ànɛ̂ névye yúkúnyahlenɔ tyɩ́ yónɔ́lɛ n nohnɩ, yé káh yɛ tíkí yé tɛ̃! Képah ǹgbò ye yɩ̃nɛ kè pɩ. Ǹtɛ, képah náh núkú n pɩ n pi kèkõyṍ mɛ̀ tyɛ́nɔ́lɛ.» ");
INSERT INTO wib_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Képah náh, à tɔ̃ ǹ syɩ yo pé tyɩ́: «Kwil yɔ́ kɩ yuku kwil yɔ́lɛ n fwo. Tɔ̃́rɩ́ yɔ́ kɩ yuku tɔ̃́rɩ́ yɔ́lɛ n fwo. ");
INSERT INTO wib_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Sétáh syahrɩ ǹgbnɔ kɩ mɛ n pɩ, tɛ́ tã̀ntã̀n náhnáh sɔkɔ, ńyân pèl ànɛ̂ kwɛkɩ kɩ mɛ de. Tíkítìkì tyi, ànɛ̂ kwní yṍnmɔnɔ ǹgbnɔ kɩ n wɛ yĩ̂nyõ. ");
INSERT INTO wib_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ǹtɛ, kénɛ tyi-à pópó n pɩ, pè kɩ yé tɛ̃ fõh, tɛ́ kɩ yé gbàh dɛ mɔ pè kɔ̃ pè kɩ tuke Liyel ní-ńtã̂n vɩ̀ sɔkɔ. Pè kɩ yé dah mɔ wɔ̀kɔ̀npèkè sɔkɔ. Pé kɩ yé tɛ̃ kyɩ yõ̀tãm ànɛ̂ kwlo yah tɛ̃́pú tyɩ́ ńmɔ yĩnnɛ. ");
INSERT INTO wib_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Képah gbõ̀ yõ yé kɩ ńmɔ tyɩ́ wɛ yo pé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","15","Ǹtɛ, yé yɛ, yé dyɔ nɛ mɛ n kwnɛ nɛ, ńmɔ-á kɩ wɛy wɛkɩ dùkù ànɛ̂ lékã́mnɛ yé kɔ̃, nɛ̂-á kɩ yé fṍhpú kɔ̃, pè náh fɛ̃ n wɛkɩ yélɛ, ànɛ̂ pè náh fɛ̃ yé kɔ̃lɩ. Képah ye, yépi tyɩ́ náh yé gblɔ̌y vìnɔ́lɛ, yé vyɛ̃y syi yĩnnɛ. ");
INSERT INTO wib_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ǹtɛ, nónó ńtɛ̃-á kɩ yé mɔ kũ kɔ̃ n pi, yé dúbípú ye, ànɛ̂ yé yṹnpyelɛ, ànɛ̂ yé tyɩ́ névyelɛ, à tahlɩ yé kódíbí tyɩ́. Képah sɔkɔ, yé náhnáh kɩ ko mɔ. ");
INSERT INTO wib_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","No pól kɩ yé dyɔlɛ n yɔ ńmɔ yĩnnɛ. ");
INSERT INTO wib_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ǹtɛ, yé yõ̀yén sɔkɔ yɔ́ ńtɛ̃ náh n yah n kwlɔ n pi. ");
INSERT INTO wib_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Gbáhntɛ̃nɔ sɔkɔ ye yé kɩ tyɛ́-ńkɛ̃̂ min wɛ.» ");
INSERT INTO wib_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","«Yâh mɛ́gbã̀n wɛ sè Yerusalɛmɩ mɔ gbɩ gbĩ́ nɛ̂nɛ, yé pɩ̃ nɛ, ké sɔ gbĩ́-á nɔ. ");
INSERT INTO wib_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","22","Kénɛ sèpĩ̀n kɩ pɩ pèkè wɔ dɛ́nɔ́lɛ, Liyel sɛ́bɛ́y sɔkɔ tyi wã́rkɩ́nsàhnɔ́ pól kɔ̃ sè kɩ pɩ tũ. Képah ye, nónó-à mɛ Yude kwil sɔkɔ, pépi to de ymɔ sɔkɔ. Nónó-à mɛ Yerusalɛmɩ kwil táh sɔkɔ, pépi wil. Nónó-à mɛ gbnɔ sɔkɔ, pépi káh de kwil táh. ");
INSERT INTO wib_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","24","Kè kɩ pɩ kénɛ sèpĩ̀n sɔkɔ yèvyãhrɩ ǹgbɛ̃nɛ kwil sɔkɔ. Tɛ́ Liyel kɩ yuku kwil mɛ̀ névye yõ fɔ̀kɔ̀vyã̀hnɩ̀nɛ. Pè kɩ ko mɔ kèkîrnnɛ, kɩ tɛ̃ yuku yɔ̃bɩlɛ kèkõyṍ kwlo pól sɔkɔ. Tɛ́ Liyel pɩ̃́-ńkɛ̃̂ névye kɩ Yerusalɛmɩ yɩkɩ pól tɛ̃̀nɛ fɔ́ɔ́, kɩ pɔ syɩ pé gbĩ tyɛ́nɔ́ tyɩ́. Képah ye, kénɛ sèpĩ̀n sɔkɔ, kè kɩ pɩ yĩ́ĩ́ yèvyãhrɩlɛ syɔ́ kûrn nɛ́tãn, ànɛ̂ yɔ̃kɩ nɛ́tãn tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Képah sɔkɔ, kwní yṍnmɔnɔ kɩ wɛ gbĩ sɔkɔ, ànɛ̂ ńwɔ̃́ sɔkɔ, ànɛ̂ ńwɔ̃́ kèpye sɔkɔ. Tɛ́ kèkõyṍ névye pól yáh-ńsah kɩ mɛ tyɛ képékèyɔ̂. Pnɛ yɔ gbní képékè ànɛ̂ ké fṹndɔkɔnɔ tíkí kɩ mɛ pè kah tɛ̃. ");
INSERT INTO wib_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Yĩ̂nyõ tǎhkɩ̀nɔ́ kɩ yike. Képah ye, tyi nónó-á kɩ pɔ n pɩ n pi kèkõyṍ, sépi tyɩ́ sõnɔ tíkí kɩ névye ko. ");
INSERT INTO wib_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Képah sɔkɔ, pè kɩ Névi Pi wɛ à kɩ mɛ n pi ńyĩ́rkì sɔkɔ ǹ tǎhkɩ̀ póllɛ, ànɛ̂ ǹ gblò sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Kénɛ tyi-à pópó tyah n pɩ gbĩ́ nɛ̂nɛ, yé pwáhnmɔnɔ mɛ nɔ n tɛ. Kàh pɩ sɛ̃́, yé yuku yĩn, yé mó sṍré mɔ yé gblɔ̌y sɔkɔ.» ");
INSERT INTO wib_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Képah náh, Yesu tɔ̃ sèmìrkì yɔ́ yãh pé tyɩ́ nɛ: «Yé yah sènsóké séswɔ̂, ànɛ̂ sésân tɛ́lɔ́ póllɛ kɛ̀: ");
INSERT INTO wib_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Yâh sè wɛ sè tyah n tyɛ mɩ̀snɔlɛ, yé n pɩ̃ nɛ, ki de gbĩ́-á mɛ yúkɛy. ");
INSERT INTO wib_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Sɛ̃́ ó ye, yâh pópó kénɛ tyi wɛ sè tyah n pɩ gbĩ́ nɛ̂nɛ: Yé pɩ̃ nɛ ńkɛ̃́, Liyel tɔ̃́rɩ́-á mɛ yúkɛy. ");
INSERT INTO wib_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Kègbɩ yõ, mé kélɛ n yo n dal n mɔ yé tyɩ́ nɛ: kwɛy gbĩ névye pól náh n ku n tɛ n pi, tɛ́ kénɛ tyi pól kɩ yĩni tɛ̃. ");
INSERT INTO wib_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Yĩ̂nyõ ànɛ̂ sétáh kɩ pɔ tyɛ, ǹtɛ, ńmɔ wɛlɔ náh n tyɛ n yah n pi póllɛ.» ");
INSERT INTO wib_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Yesu tɔ̃ yo pé tyɩ́: «Yé yé gblɔ̌y kyɔmɩ syáh syáhnɔ́lɛ, ànɛ̂ sètɛ̃̀nɩ̀ pɩ́nɔ́lɛ, ànɛ̂ kèkõyṍ mɛ̀ tyi sõnɔlɛ. Sé káh n pɔ yé lékã́m pɩ tĩ́ntĩ́. Képah-à pɩ, kèkõyṍ tyɛ sṍ kɩ yé kwɔkɩ tɛ̃. ");
INSERT INTO wib_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Sɛ̃́ tɔ ye, ké lésõ kɩ kwɔkɩ tɛ̃ sétáh yõ névye póllɛ, sɔ̃́-á yɛ̃́nkyɔ tɛ̃ tɛ̃ mnɔ n tɛ̃ yɛ̃́nkyɔlɛ. ");
INSERT INTO wib_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ǹtɛ, yé káh yé dyɔ mɔ n fwɔ, yé nírílɛ n pɩ gbĩ́mɛgbĩ́. Képah sɔkɔ, tyi nónó pól-á n pi yɔ̀, yé kɩ tɛ̃́nwɛnɔ wɛ sé yõ, tɛ́ kɩ fɛ̃ pɔ yuku yĩn Névi Pi yah tukey sɔkɔ.» ");
INSERT INTO wib_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ké légbĩ́nɛ, tyah kyòo yah sɔkɔ, Yesu ńkɛ̃́nɛ n kyɩ kwɔ́nɔ́ pɩ Liyel wɔ̀kɔ̀ ǹgbɛ̃ kéntáhkɩ̀ sɔkɔ, ǹ tɛ́ n kyɩ lékã̂h pɩ yɔ̃lɛ yɔ́ yõ nɛ̂-á pè n ye Wólívî yèh yɔ̃lɩlɛ. ");
INSERT INTO wib_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Tɛ́ à tɔkɔ séngbɔ̃́ púsɔ́ tyɩ́, no pól n pɔ nóhnɔ́ pɩ ǹ tyɩ́ Liyel wɔ̀kɔ̀ ǹgbɛ̃ kéntáhkɩ̀ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Búrn sɛ̃̀-ǹkɛ̃̂ syáh nɛ̂-á pè n ye Pakɩlɛ, képah déntɛnɔ sɔkɔ, ");
INSERT INTO wib_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","sárká wìlkìpu yõ̀tãm ǹgbnɔ, ànɛ̂ Liyel ǹgbò wɛ̃̀kɩ̀ kwɔ́pú sõ̀ mɛ syɔ̃̀-ǹsahlɛ n yah n kɔ̃, pǎh kɩ pɩ sɔ̃́, tɛ́ Yesu ko mɔ n pi. Tɛ́ névye yah tíkí sõ̀ mɛ pè tɛ̃. ");
INSERT INTO wib_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Tɛ́ légbĩ́nɛ, sétã̀n yõ̀tɛ̃̀ de Yudasɩ sɔkɔ nɛ̂-á pè n ye Yisikariyɔtɩlɛ. Yesu tõ̀ sã́hpú nɛ́pĩ̂ gbɔ̃nimí sɔkɔ nɛy yɔ́ ye sõ̀ ǹnɛ. ");
INSERT INTO wib_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","À mɛ sɔkɔ, à kyɩ yo sárká wìlkìpu yõ̀tãm ǹgbnɔ, ànɛ̂ Liyel wɔ̀kɔ̀ ǹgbɛ̃ kyɔ̀mɩ̀pu yõ̀tãm tyɩ́, wǎh nɛ Yesu tɛ̃ pè kɔ̃ n pi dùkù nɛ̂nɛ. ");
INSERT INTO wib_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Képah sɔkɔ, kè nɔ pé tyɩ́. Pè mɛ yo sah núkú yõ nɛ ńkɛ̃́, páh kɩ pɔ́lɛ à kɔ̃. ");
INSERT INTO wib_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yudasɩ mɛ fɛ̃ syi, tɛ́ tyah ké wɛ́npɩ-ńsahlɛ n yah n kɔ̃, wǎh pɩ sɔ̃́, tɛ́ Yesu dahbɩ n pi pé gbõ̀, névye pɩ̃́-ńkɛ̃̂ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Búrn sɛ̃̀-ǹkɛ̃̂ syáh sṍ-á pɔ nɔ, nɛ̂ sɔkɔ-á sõ̀ Pakɩ képyɛ́nɩ̀ kɩ n ko n pi, ");
INSERT INTO wib_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesu mɛ Pyɛrɩ ànɛ̂ Nsyɔ̃ tɛkɩ mɔ nɛ, pè kyɩ Pakɩ syáh yõke tɛ̃̀-ǹsah yah sah yõ yõ tɛ̃̀nɛ. ");
INSERT INTO wib_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Pè mɛ à piki yah nɛ, ńyãh sɔkɔ se à mɛ ké tyɩ́ nɛ, pé kyɩ kè pɩ nɩ? ");
INSERT INTO wib_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","À mɛ yo pé tyɩ́: «Yé yah, yáh kɩ n de kwil sɔkɔ gbĩ́ nɛ̂nɛ, yé kɩ dĩ́ yɔ́ yohnɩ, à kɩ mɛ ni pĩ́n twah. Yé ǹ sõ̀ tɛ̃. Wàh kɩ kyɩ de kéte nɛ̂ sɔkɔ, yé de nɛ́npɔ́. ");
INSERT INTO wib_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Yé mó yo kététɛ̃̀ tyɩ́ nɛ, kwɔ́-ò-á yo nɛ ńkɛ̃́, wɔ̀kɔ̀ nɛ̂ sɔkɔ se pé kɩ pɔ yõke yõ n pi ànɛ̂ pé tõ̀ sã́hpúlɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Képah sɔkɔ, à kɩ yĩ̂nyõ wɔ̀kɔ̀ sɔkɔ táh ǹgbɛ̃ yɔ́lɛ yé wɛ̃kɩ, gbõ̀ vi vyɔ́ póllɛ kɩ sɔkɔ. Nɛ́npɔ́ sɔkɔ ye, yé kɩ pɩ Pakɩ syáh yõkelɛ.» ");
INSERT INTO wib_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Képah tɛ̃̀nɛ, pè mɛ sɔkɔ. Yesu-á kè yo sɔ̃́ pé tyɩ́, pè mó ńtyɩ̃́nɔ kyɩ ké pól wɛ sɛ̃́. Pè mɛ Pakɩ syáh yõke pɩ nɛ́npɔ́. ");
INSERT INTO wib_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Yõke yõ gbĩ́-á pɔ nɔ, Yesu ànɛ̂ ǹ tɛ̃̀ntõbe-á pɔ tɛ̃ yõke yah sɔkɔ gbĩ́ nɛ̂nɛ, ");
INSERT INTO wib_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","à mɛ yo pé tyɩ́: «Mé sõ̀ mɛ ké tyɩ́ náhnáh nɛ, mé Pakɩ yõke mɛ̀ yõ yélɛ, mé mó pyě de yèvyãhrɩ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ńkɛ̃́, mé kélɛ n yo yé tyɩ́ nɛ: mé náh tɔ̃ Pakɩ yõke mɛ̀ yõ n yah n pi fɔ́ɔ́, kɩ kyɩ syɩ ké tyi pɩ́ntũnɔ tyɩ́ Liyel yõ̀tɔ̃rɩ́ sɔkɔ.» ");
INSERT INTO wib_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","18","Képah sɔkɔ, à mɛ dìvɛ̃ wɔ wɔ kwâh tɔkɔ dìvɛ̃nɛ ké sɔkɔ, à wɛkɩ Liyel tyɩ́, tɛ́ yo pé tyɩ́: «Mé kélɛ n yo yé tyɩ́ nɛ: à tɔkɔ núkúnúkú tyɩ́, mé náh tɔ̃ dìvɛ̃ wɔ n yah n pi fɔ́ɔ́, kɩ pɔ syɩ Liyel tɔ̃́rɩ́ pɔ́nɔ́ tyɩ́. Képah ye, yé syi kélɛ, yé wɔ dibi wɛ̃ tyɩ́.» ");
INSERT INTO wib_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Képah náh, à mɛ búrn tɔkɔ, tɛ́ wɛkɩ Liyel tyɩ́, tɛ́ kè kwɔkɩ dibi pè kɔ̃, tɛ́ yo pé tyɩ́: «Ńyɔlɛ, ńmɔ wil ye, nɛ̂-á kɩ kɔ̃ yépi yĩnnɛ. Yé sɛ̃́ntɛ̃̀nɛ n pɩ, sɔ̃́-á mé n pɩ kélɛ. Képah sɔkɔ, yé dyɔ kɩ n kwnɛ ńmɔ tyɩ́lɛ.» ");
INSERT INTO wib_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Yõke yṍntɛnɔ náh, à tɔ̃ dìvɛ̃ tɔkɔ, à pè kɔ̃ sɛ̃́ntɛ̃̀ ólɛ, tɛ́ yo pé tyɩ́: «Ńyɔlɛ, ńmɔ tṍ ye, nɛ̂-á kɩ kwɛ yépi yĩnnɛ, kɩ pɩ yégbékè kwrɔ́nmɔnɔ késã́nnɛ Liyel ànɛ̂ névye wrɔ́. ");
INSERT INTO wib_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ǹtɛ, yé yah, névi nɛ̂-á kɩ n vi n pi ńmɔ náh, ǹmɔ tɔ mɛ n yõ ńnɛ fɩ̃́ núkú. ");
INSERT INTO wib_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Névi Pi kɩ ku, sɔ̃́-á Liyel yah tɔkɔ kélɛ. Ǹtɛ, névi nɛ̂-á kɩ n vi n pi ǹ náh, pèkè kɩ pɩ ǹmɔ tyɩ́lɛ.» ");
INSERT INTO wib_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Képah tɛ̃̀ sɔkɔ, pè tyah wɛ̃nɛ n piki n yah nɛ, pépi tɛ̃̀ sɔkɔ nɛ̂ se kɩ n pɩ n pi képahlɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Képah náh, pè mɛ tyah, à yékã̂blɛ n pɩ. Pè sõ̀ mɛ ké tyɩ́ nɛ, pé pɩ̃ nɛ̂ tɛ̃̀-á kal pépi sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Képah sɔkɔ, Yesu mɛ yo pé tyɩ́: «Kèkõyṍ kwlo yõ̀tãm ńkɛ̃́nɛ pé tɔ̃́rɩ́lɛ n sah sé yõ, ànɛ̂ tɔ̃́rɩ́-á mɛ nónó gbõ̀, pépi n nɛ mɛ ké tyɩ́ nɛ, no pé yĩ́ngbɩ́lɛ n yo. ");
INSERT INTO wib_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ǹtɛ, yépi tɛ̃̀ tyɩ́ náh yɩ̃nɛ kè pɩ sɛ̃́. Nɛ̂-á yah tɛ̃̀nɛ yépi sɔkɔ, ǹmɔ pyě yɩ̃nɛ à pɩ yé pól gbɛ̃̀ sɔ̃́. Yõ̀tɔ̃rɩ́-á mɛ nɛ̂ gbõ̀, ǹmɔ pɩ yé pól tõ̀npɩ sɔ̃́. ");
INSERT INTO wib_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Yépi tɛ̃̀ tyɩ́, névi nɛ̂-á tɛ̃ yõke yah, ànɛ̂ nɛ̂-á n tɔkɔ n kɔ̃ kélɛ, nɛ̂ tɛ̃̀ kal pépi sɔkɔ? Nɛ̂-á tɛ̃ yõke yah, ǹmɔ náh di? Ǹtɛ, képah fyé yõ, ńmɔ mɛ yépi wrɔ́ sɔkɔ tõ̀npɩ sɔ̃́. ");
INSERT INTO wib_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Yépi tɛ̃̀ wɔlɛ, yépi ye sõ̀ mɛ ńmɔlɛ ń yèvyãhrɩ pɩ́-ńtã̂n sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Képah ye, ńmɔ sú-á tɔ̃́rɩ́lɛ ń kɔ̃ sɔ̃́, ńmɔ tɔ kɩ kélɛ yé kɔ̃ sɛ̃́. ");
INSERT INTO wib_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Képah sɔkɔ, yé kɩ pɔ n yõ, tɛ́ kɩ n wɔ ńmɔlɛ fɩ̃́ núkú ń yõ̀tɔ̃rɩ́ sɔkɔ. Ànɛ̂ yé kɩ pɔ kɔ̃ tɛ̃ yõ̀tɔ̃rɩ́ klǒ yõ, kɩ tukey tuke Yisrayel névye tĩ̀nnɔ gbɔ̃ninɔ́ yõ.» ");
INSERT INTO wib_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Képah náh, Yesu yo Simɔ Pyɛrɩ tyɩ́: «Simɔ, Simɔ! Sétã̀n yõ̀tɛ̃̀ ye ké wɛ̃̀kɩ̀ yah kɔ̃ nɛ, pé yé fɛ, sɔ̃́-á sèmukɔlɛ pè n fɛ gbɛ́y sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Tɛ́ mé mɛ Liyel ni á tyɩ́ nɛ, á Liyel yõ sɛ̃́nɔ́ káh tɛ̃ syi á tyɩ́. Tɛ́, wâh á syɩ pɔ ńmɔ tyɩ́ gbĩ́ nɛ̂nɛ, sṍrélɛ n mɔ yé no sɔkɔ.» ");
INSERT INTO wib_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Wǎh yo sɛ̃́, Pyɛrɩ mɛ yo ǹ tyɩ́ nɛ, péwɔ tɛ̃̀ wɔlɛ, kàh kɩ sɔ̃́ n pɩ wɔ̀kɔ̀npèkè sɔkɔ dénɔ́lɛ, képah náh pɩ, kũnɛ, péwɔ-á mɛ pé vi sah kɩ de ǹnɛ sépi pól sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ǹtɛ, Yesu mɛ yo ǹ tyɩ́: «Pyɛrɩ, mé kélɛ n yo á tyɩ́ nɛ: kwɛy lékã̂h sɔkɔ, sénpɛ náh tɔ̃̌nɩ̀ mɛ n gbo n pi, tɛ́ á kɩ mɛ á vyãh kɔ̃lɩ tɛ gbáhyɩ̃́ tɔ̃́nɔ́ nɛ ńkɛ̃́, á náh ńmɔ pɩ̃.» ");
INSERT INTO wib_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Képah náh, Yesu mɛ yo pé tyɩ́: «Ńmɔ-á sõ̀ yé tõ gbĩ́ nɛ̂nɛ, tɛ́ yo yé tyɩ́ nɛ, yé sɔkɔ pɔ́, ànɛ̂ pilki, ànɛ̂ lékyêh kɛ̃́nɛ, kwâh yɔ́ se kyɩ tɛkɩ yé tyɩ́?» Pè mɛ yo ǹ tyɩ́ nɛ, kwâh yɔ́ náh tɛkɩ. ");
INSERT INTO wib_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","37","Képah sɔkɔ, à mɛ yo pé tyɩ́: «Mé kélɛ n yo yé tyɩ́ nɛ: wɛy nɛ̂-á wãrkɩ ńmɔ tyɩ́ sɔkɔ nɛ ńkɛ̃́, pè à mɔ kõ tyípêl pɩ́pú wrɔ́, képah kɩ n pɩ n tũ n pi. Tyi nónó-á yo sah ńmɔ tyɩ́ sɔkɔ, sé pɩ gbĩ́ mɛ nɔ n tɛ. Képah ye núkúnúkú tɛ̃̀ wɔlɛ, pɔ́-à kɩ mɛ nɛ̂ tyɩ́, tɛ̃̀ kè tɔkɔ. Ànɛ̂ képah núkú-ó ye: Pilki-à kɩ mɛ nɛ̂ tyɩ́, tɛ̃̀ kè tɔkɔ. Tɛ́ kèkírkì-à kɩ n knɛ nɛ̂ tyɩ́, tɛ̃̀ ǹ fwɔ̀mɔ̀-ǹgbɛ̃ yãm kèyǎh dwe.» ");
INSERT INTO wib_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Képah sɔkɔ, tõ̀ sã́hpú nɛ, à yah, kèkîrnnɔ nínɔ́-á yɔ̀. À mɛ nɛ, kǎh yɩ̃nɛ. ");
INSERT INTO wib_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Képah náh, Yesu mɛ wil sɔkɔ Wólívî yèh yɔ̃lɩ yõ, wǎh dar tɛ n kyɩ n pɔ sɔ̃́. Tɛ́ ǹ tõ̀ sã́hpú mɛ ǹ sõ̀ tɛ̃. ");
INSERT INTO wib_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Wǎh yĩni tɛ̃ nɛ́npɔ́ gbĩ́ nɛ̂nɛ, à yo pé tyɩ́ nɛ, pè Liyellɛ n ni, mɔ́nyahnɔ káh pɔ tɛ̃ wɛ pé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Képah náh, à gbɛ mɔ tɛ̃ pélɛ fɩ́ɩ́ kwéy, dáhkɩ̀ mínnɔ́ kɛ núkú yĩ́níntɛ̃-ńsah kénkɔ̃lɛ. Tɛ́ gbètukunɔ di, à nírílɛ n pɩ, ");
INSERT INTO wib_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","mɛ n yo nɛ: «Bɔ̌, wáh kɩ mɛ ké tyɩ́, yèvyãhrɩ mɛ̀ wrɔ́ gbɛ mɔ ńmɔlɛ. Ǹtɛ, kè káh pɩ ńmɔ dyɔ dyɔ tɛ̃̀nɛ. Áwɔ dyɔ dyɔ tɛ̃̀ ó pɩ.»  ");
INSERT INTO wib_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Légbĩ́nɛ, yĩ̂nyõ tɛ̃ntõ̀ yɔ́ wil ǹ yah, à pɔ tǎhkɩ̀lɛ à kɔ̃. ");
INSERT INTO wib_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Tɛ́ Yesu min sõ̀ mɛ yèvyã̀hnpèkè sɔkɔ. À tɔ̃ wãn mɔ Liyel nínɔ́ yõ. Ǹ wil myèh pɔ pɩ tṍkwîl sɔ̃́, à n kwɛ sétáh. ");
INSERT INTO wib_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Wǎh nírí pɩ tɛ gbĩ́ nɛ̂nɛ, à yuku kyɩ ǹ tõ̀ sã́hpú tnɔ̂. À kyɩ nɛ yah, pè mɛ n dɔ yèkwɔrɩ kwlɔ́nɔ́ tɛ̃̀ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","À yo pé tyɩ́: «Kwâh nɛ̂ pɩ, tɛ́ yé n dɔ sɛ̃́? Yé yuku Liyellɛ n ni, mɔ́nyahnɔ káh pɔ tɛ̃ wɛ yé tyɩ́.» ");
INSERT INTO wib_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesu mɛ wɛ́kɩ́nɔ́ sɔkɔ sɛ̃́, tɛ́ Yudasɩ nɛ̂-á ǹ tõ̀ sã́hpú nɛ́pĩ̂ gbɔ̃nimí sɔkɔ yɔ́lɛ, ǹmɔ tɔ́wû yɔ́ yah tɛ̃ pɔ wil mɔ ǹ yõ. Tɛ́ nɔ de ǹnɛ nɛ, pé à pɔrɩ tɛ̃, pé wɛkɩ ǹ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ǹtɛ, Yesu mɛ yo ǹ tyɩ́: «Yudasɩ, pɔ́rɩ́ntɛ̃nɔ sɔkɔ se á kɩ dɛ mɔ Névi Pi gbàhlɛ?» ");
INSERT INTO wib_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Nónó-á sõ̀ mɛ Yesulɛ, pǎh pɔ kè kyɔmɩ à pɩ̃ tir nɛ̂-á kɩ pɔ n pɩ n pi, pè yo Yesu tyɩ́ nɛ, pépi Tɛ̃̀ ǹgbɛ̃, pé se kèkîrnnɛ n dɛ no tyɩ́ nɩ? ");
INSERT INTO wib_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Tɛ́ sárká wìlkìpu yõ̀tɛ̃̀ tõ̀npɩbɩ nónó-á sõ̀ mɛ, Yesu tõ̀ sã́hpú sɔkɔ nɛy yɔ́ núkú ǹ kèkírkìlɛ pépi sɔkɔ yɔ́ gbõ̀yõ̀ sõ̀ níkí wɛ kõ kãm. ");
INSERT INTO wib_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Képah sɔkɔ, Yesu mɛ yo pé tyɩ́: «Yé yĩn sɛ̃́.» Tɛ́ tũ dĩ́ mɛ̀ níkí tyɩ́, kè mɛ tyɛ. ");
INSERT INTO wib_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Képah sɔkɔ, sárká wìlkìpu yõ̀tãm, ànɛ̂ Liyel wɔ̀kɔ̀ ǹgbɛ̃ kyɔ̀mɩ̀pu yõ̀tãm, ànɛ̂ yèwàhnɩ̀ nónó-á sõ̀ pɔ Yesu tɛ̃́-ńsah, à yo pé tyɩ́: «Yé pɔ ńmɔ tyɩ́ kèkîrn ànɛ̂ léplólɛ kèlékɛ̃ névi sɔ̃́ ńnɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ǹtɛ, swɔ̃ swɔ̃ póllɛ, mé sõ̀ ńkɛ̃́nɛ n nɛ n mɛ yélɛ Liyel wɔ̀kɔ̀ ǹgbɛ̃ kéntáhkɩ̀ sɔkɔ, yé náh ń tɛ̃. Tɛ́ yépi gbĩ ye sɛ núkúnúkú, ànɛ̂ sétõ tǎhkɩ̀ pɩ gbĩ́nɛ fɛ̃́ntũ̂ sɔkɔ.» ");
INSERT INTO wib_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Képah náh, pè Yesu tɛ̃, à sɔkɔ ǹnɛ sárká wìlkìpu yõ̀tɛ̃̀ ǹgbɛ̃ kéte. Pyɛrɩ sõ̀ mɛ pé sõ̀ tɛ̃ n kɔ pélɛ fɩ́ɩ́. ");
INSERT INTO wib_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Pè sõ̀ mɛ nyàh mɔ kéte nɩyṍ, mɛ kɔ̃ tɛ̃ wɛ̃ tyɩ́, tɛ́ Pyɛrɩ tɔ sõ̀ mɛ pélɛ nyàh yah sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Képah sɔkɔ, tõ̀npɩ pi yɔ́ à wɛ kɔ̃́ntɛ̃̀nɔ́lɛ nyàh yah, tɛ́ à gbah yah díkídíkí, tɛ́ nɛ, dĩ́ mɛ̀ tɔ-á sõ̀ mɛ Yesulɛ. ");
INSERT INTO wib_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Wǎh yo sɛ̃́, Pyɛrɩ mɛ ǹ vyãh kɔ̃lɩ pi tyɩ́ nɛ, pé náh à pɩ̃ dɛ́. ");
INSERT INTO wib_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Dǒ kwéy, dĩ́ yɔ́ tɔ̃ à wɛ, tɛ́ nɛ, ǹmɔ tɔlɛ, kénɛ no sɔkɔ nɛy yɔ́-á ǹnɛ. Képah tɛ̃̀nɛ, Pyɛrɩ mɛ yo ǹ tyɩ́ nɛ ńkɛ̃́, pé sɔkɔ nɛy náh péwɔlɛ. ");
INSERT INTO wib_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Képah náh, lɛ́rɩ́ núkú kénkɔ̃ sɔ́kɔ́ntɛnɔ náh, dĩ́ yɔ́ tɔ̃ kè gbah yo nɛ ńkɛ̃́, yékã̂b náh mɛ ké sɔkɔ, dĩ́ mɛ̀ tɔ-á sõ̀ mɛ ǹnɛ, Kalile nɛy-á ǹnɛ dò. ");
INSERT INTO wib_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Képah sɔkɔ, Pyɛrɩ mɛ ǹ syɩ yo ǹ tyɩ́ nɛ ńkɛ̃́, péwɔ náh mɛ ǹ wɛy mɛ̀ syɩ́kɩ́-ńsah wɛ dɛ́ dĩ́. Nɛ́npɔ́ swɔ, Pyɛrɩ mɛ képah yónɔ́ sɔkɔ sɛ̃́, tɛ́ sénpɛ gbo. ");
INSERT INTO wib_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Tɛ̃̀ ǹgbɛ̃ Yesu mɛ ǹ yah vi Pyɛrɩ yah díkídíkí. Képah sɔkɔ, Pyɛrɩ dyɔ núkú to kõ ǹ wɛy mɛ̀nɛ, wǎh sõ̀ nɛ̂ yo ǹ tyɩ́ nɛ, sénpɛ-à kɩ pópó n gbo kwɛynɛ, wǎh kɩ mɛ ǹ vyãh kɔ̃lɩ tɛ kɛ tɔ̃́nɔ́ nɛ ńkɛ̃́, pé náh péwɔ pɩ̃. ");
INSERT INTO wib_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Kǎh pɩ sɛ̃́, à mɛ wil kégbɔ́, à kyɩ nàhnpɩ̃ gbní kah gbo. ");
INSERT INTO wib_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Képah sɔkɔ, Yesu-á sõ̀ mɛ díbí nónó gbõ̀, pè sõ̀ mɛ kṍlɛ ǹnɛ n ko, tɛ́ mɛ ǹnɛ n syɩkɩ gbõ̀nkukelɛ. ");
INSERT INTO wib_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Pè sõ̀ mɛ ǹ yah pukubi, tɛ́ mɛ n yo ǹ tyɩ́ nɛ, à sãh pɩ̃, névi nɛ̂-á mɩ ǹnɛ. ");
INSERT INTO wib_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Tɛ́ tɔ̃ mɛ ǹnɛ n gbyɔ wɛ̀ntùkùnì náhnáhlɛ. ");
INSERT INTO wib_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Képah náh, tyah-á dal, Nsyifunɔ yèwàhnɩ̀, ànɛ̂ sárká wìlkìpu yõ̀tãm ǹgbnɔ, ànɛ̂ ǹgbò wɛ̃̀kɩ̀ kwɔ́pú wɛ̃ tuke mɔ. Pè mɛ pɔ Yesulɛ pé tukey tùkè-ǹsah ǹgbɛ̃ sɔkɔ, ");
INSERT INTO wib_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","tɛ́ yo ǹ tyɩ́ nɛ, ǹmɔ-à kɩ nɛ Kristalɛ, Liyel nɛy tɛ́kɩ́nmɔnɔlɛ, à kè yo pé syah. À mɛ yo pé tyɩ́: «Máh kɩ kè yo yé syah, yé náh n sɛ̃ n pi ké yõ. ");
INSERT INTO wib_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ànɛ̂ máh kɩ se yélɛ n piki n yah, yé náh vi mɔ n pi ń tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ǹtɛ, à tɔkɔ núkúnúkú tyɩ́, Névi Pi kɩ kɔ̃ tɛ̃ tyi pól Tɛ̃̀ ǹgbɛ̃ Liyel gbõ̀yõ̀ sõ̀lɛ.» ");
INSERT INTO wib_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Képah sɔkɔ, pé pól núkú yo nɛ, ǹmɔ tɛ̃̀ tyɩ́, ǹmɔ-á Liyel pilɛ kɛ̀? Yesu mɛ yo pé tyɩ́: «Yépi ńtɛ̃ ye kè yo tɛ nɛ ńkɛ̃́, ńmɔ-á dò.» ");
INSERT INTO wib_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Képah tɛ̃̀nɛ, pè nɛ, tàrfyɔ̀ nɛ̂ tɛ̃̀ se tɔ̃ pé kɩ n yah n kɔ̃ nɩ? Pépi ńtɛ̃-á kɩ noh, à kè yo ǹ vyãhlɛ. ");
INSERT INTO wib_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Képah náh, pé pól mɛ yuku, à Yesu tɛ̃ kyɩ Pilatɩ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Nɛ́npɔ́ sɔkɔ, pè tyah lékàhlɛ ǹnɛ n kɔ̃ nɛ, páh dĩ́ mɛ̀ kyɔmɩ wɛ, à mɛ pé kwil névye yõlɛ n yɩkɩ, mɛ pélɛ n yĩni n mɔ mɔ́rɩ́ mɔ́nɔ́lɛ yõ̀tɛ̃̀ ǹgbɛ̃ Sesarɩ tyɩ́. Tɛ́ ǹmɔ ńtɛ̃-á mɛ n yo nɛ ńkɛ̃́, péwɔ-á yõ̀tɛ̃̀nɛ, nɛ̂-á sõ̀ Liyel nɛ, páh kɩ tɛkɩ mɔ. ");
INSERT INTO wib_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Képah sɔkɔ, Pilatɩ mɛ à piki yah nɛ, ǹmɔ se Nsyifunɔ yõ̀tɛ̃̀nɛ nɩ? À mɛ yo ǹ tyɩ́: «Áwɔ ye yo kélɛ.» ");
INSERT INTO wib_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilatɩ mɛ yo sárká wìlkìpu yõ̀tãm ànɛ̂ no pól tyɩ́ nɛ, péwɔ náh tir yɔ́ wɛ dĩ́ mɛ̀ tyɩ́ póllɛ, nɛ̂-á yɩ̃nɛ lékàhlɛ ǹ kɔ̃́nɔ́lɛ. ");
INSERT INTO wib_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ǹtɛ, pè tɔ̃ mɛ kè gbah yo tũ nɛ ńkɛ̃́, wǎh mɛ névyelɛ n kwɔ nòhnɩ̀-ǹkɛ̃̂nɛ, Yude tã̀ntã̀n pól sɔkɔ. Kalile kwil sɔkɔ-á à tyah kélɛ fɔ́ɔ́, à pɔ de ásõ̂. ");
INSERT INTO wib_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilatɩ-á képah noh ńyãh sɔkɔ, à píkínyahnɔ pɩ nɛ, Kalile nɛy se dĩ́ mɛ̀nɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Wǎh fyɔ̀ ǹ wìl-ǹsah tyɩ́ noh, tɛ́ pɩ̃ nɛ, Yerɔdɩ-á nɛ́npɔ́ yõ̀tɛ̃̀nɛ, à núkú à tɛkɩ mɔ ǹmɔ kɔ̃. Tɛ́ kè mó pɔ yɩ̃nɛ Yerɔdɩ sõ̀ mɛ Yerusalɛmɩ kénɛ sèpĩ̀n sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Kè pɩ di mónɔ́lɛ, Yerɔdɩ sõ̀ mɛ Yesu tyɩ́ yónɔ́lɛ n nohnɩ, tɛ́ mɛ ké tyɩ́ nɛ, pé à wɛ à nɛ n mɛ gbǐl yɔ́lɛ n pɩ. Képah ye, wǎh à wɛ, kè pɩ nɩ̀vɩ̀ ǹgbɛ̃nɛ ǹ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","À mɛ à gbah piki yah náhnáh, tɛ́ Yesu náh dahbɩ wilki ǹ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Képah sɔkɔ, sárká wìlkìpu yõ̀tãm ǹgbnɔ ànɛ̂ Liyel ǹgbò wɛ̃̀kɩ̀ kwɔ́pú sõ̀ mɛ nɛ́npɔ́, tɛ́ mɛ lékàhlɛ ǹnɛ n kɔ̃ fɔ́ɔ́ képékèyɔ̂. ");
INSERT INTO wib_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Yerɔdɩ ànɛ̂ ǹ sràsyíbí-á kṍlɛ à ko, tɛ́ mɛ à yilɔ tɛ gbĩ́ nɛ̂nɛ, pè mɛ yõ̀tɔ̃rɩ́ fwɔ yɔ́ mɔ à kɔ̃, tɛ́ pé syɩ à tɛkɩ mɔ Pilatɩ kɔ̃. ");
INSERT INTO wib_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Pilatɩ ànɛ̂ Yerɔdɩ sõ̀ mɛ wɛ̃ sépɛ́bɩ́lɛ ǹgbòlɛ, tɛ́ lésõlɛ, pè kódírí toh. ");
INSERT INTO wib_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Képah sɔkɔ, Pilatɩ sárká wìlkìpu yõ̀tãm ǹgbnɔ, ànɛ̂ kwil yahtãm, ànɛ̂ névye ye tuke, ");
INSERT INTO wib_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","tɛ́ yo pé tyɩ́: «Yé dĩ́ mɛ̀ tɛ̃ pɔ, tɛ́ nɛ, wǎh mɛ névye yõlɛ n yɩkɩ. Ǹtɛ yah, yépi tɔ yĩ́ yah ye mé piki yah ǹnɛ. Mé náh tir yɔ́ ńtɛ̃ wɛ ǹ tyɩ́, yáh nónónɛ n yo n sah ǹ yõ, nɛ̂-á yɩ̃nɛ lékàhlɛ ǹ kɔ̃́nɔ́lɛ. ");
INSERT INTO wib_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Yerɔdɩ ńtɛ̃ tɔ náh tir yɔ́ wɛ ǹ sɔkɔ, wǎh sɔ̃́npɩ́ ǹ syɩ à tɛkɩ mɔ ápi kɔ̃. Kǎh pɩ sɛ̃́, dĩ́ mɛ̀ náh tir yɔ́ ńtɛ̃ pɩ nɛ̂-á yɩ̃nɛ kũnɛ. ");
INSERT INTO wib_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Képah ye, mé kɩ à ko yèfõhlɛ, tɛ́ kɩ à fĩn mɔ.»  ");
INSERT INTO wib_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Tɛ́ Pakɩ syáhnɔ́ pól sɔkɔ, Pilatɩ sõ̀ yɩ̃nɛ à wɔ̀kɔ̀npèkè sɔkɔ névi yɔ́ fĩn mɔ pè kɔ̃. ");
INSERT INTO wib_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Képah tɛ̃̀nɛ, pé pól tyah n kwrɔ n gbo n mɔ nɛ, à dĩ́ mɛ̀ ko mɔ, à mó Barabasɩ fĩn mɔ. ");
INSERT INTO wib_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Tɛ́ Barabasɩ sõ̀ mɛ dáhnmɔnɔlɛ wɔ̀kɔ̀npèkè sɔkɔ kèlékɛ̃ tir yɔ́ yõ, nɛ̂-á pɩ kwil sɔkɔ, ànɛ̂ nɛ́kókè mɔ́nɔ́lɛ. ");
INSERT INTO wib_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Tɛ́ Yesu fĩ́nnmɔ dékè-á sõ̀ mɛ Pilatɩ tɛ̃, à tɔ̃ ǹ syɩ kè tɔ̃ yo pé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ǹtɛ, pè tɔ̃ gbo mɔ nɛ ńkɛ̃́: «À syɩ dahnɩ yõ! À syɩ dahnɩ yõ!» ");
INSERT INTO wib_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilatɩ mɛ tɔ̃ wɛy tɔkɔ kɛ tɔ̃́-òlɛ, à yo pé tyɩ́ nɛ, tyítúkù nɛ̂ se à pɩ nɩ? Péwɔ náh tir yɔ́ ńtɛ̃ wɛ ǹ sɔkɔ, nɛ̂-á yɩ̃nɛ kũnɛ. Képah-á, páh kɩ à ko yèfõhlɛ, tɛ́ kɩ à fĩn mɔ. ");
INSERT INTO wib_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ǹtɛ, pè mɛ yɔ̃ sɔkɔ kélɛ n kah n yo náhnáh nɛ ńkɛ̃́: «À syɩ dahnɩ yõ.» Képah tɛ̃̀nɛ, pé kàhngbonmɔnɔ pɔ tɛ̃ wɛ Pilatɩ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Képah sɔkɔ, à mɛ kè yah tɔkɔ nɛ, nɛ̂-á pè n yah n kɔ̃, képah-á kɩ pɩ pé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Dĩ́ nɛ̂-á sõ̀ pè dah mɔ wɔ̀kɔ̀npèkè sɔkɔ, kèlékɛ̃ yɔ́ ànɛ̂ nɛ́kókè mɔ́nɔ́ yĩnnɛ, ǹmɔ nɛ̂-á sõ̀ pè n yah n kɔ̃ ǹ tyɩ́, à ǹmɔ fĩn mɔ, tɛ́ Yesu pɩ pépi dyɔ yĩ́ĩ́ tɛ̃̀nɛ. ");
INSERT INTO wib_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Képah sɔkɔ, pǎh Yesu tɛ̃ n sɔkɔ syɩ́-ńsah gbĩ́ nɛ̂nɛ, pè Sirɛnɩ kwil dĩ́ yɔ́ yohnɩ, pè n ye Simɔlɛ. À mɛ wil swãh, mɛ n de Yerusalɛmɩ. Pè mɛ ǹmɔ tɛ̃ Yesu dahnɩnɛ, à twah mɔ nɛ, à ǹ sõ̀ tɛ̃. ");
INSERT INTO wib_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Tɛ́ tɔ́wû ǹgbɛ̃ sõ̀ mɛ n yuku ǹ náh, à tahlɩ syɔ́ tyɩ́ nónó-á sõ̀ mɛ n gbo pé gbã̀nnɛ n kõhlɩ pé nɩ yõ yèkwɔrɩ tɛ̃̀ tyɩ́ Yesu yĩnnɛ. ");
INSERT INTO wib_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","29","Képah sɔkɔ, Yesu mɛ ǹ yah vi pé tĩ̀nnɛ, tɛ́ yo pé tyɩ́: «Sèpĩ̀n yísyɔ́ mɛ n pi, névye kɩ pɔ tyah n yo nɛ, yõ̀bènɔrɩ-á mɛ píkã́n syɔ́ tyɩ́, ànɛ̂ nónó-á pè náh pi dubi yah, ànɛ̂ pè náh yã́nnɛ piri kɔ̃ yah. Képah ye Yerusalɛmɩ syɔ́, yé káh nɛ n gbo ńmɔ yĩnnɛ. Yé nɛ n gbo yé gblɔ̌y, ànɛ̂ yé wɛ̃́npì yĩnnɛ. ");
INSERT INTO wib_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ké légbĩ́nɛ, névye kɩ pɔ tyah n yo tlɛy tyɩ́ nɛ, sè syɩkɩlɩ pé yõ. Tɛ́ kɩ yo ymɔ tyɩ́ nɛ, sè vike tũ pé yah. ");
INSERT INTO wib_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ǹtɛ, pàh séswɔ́npõ̀lɛ n pɩ sɛ̃́, séswɔ́nkɔ̀kɔ̀ wɔ tyɩ́ kɩ pɔ n pɩ n pi sɔ̃́?» ");
INSERT INTO wib_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Tɛ́ pè sõ̀ mɛ tyípêl pɩ́pú nɛ́pĩ̂ nímí tɔ tɛ̃ kyɩ, nónó-á kɩ kyɩ n ko n mɔ n pi ànɛ̂ Yesulɛ wɛ̃ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Pǎh kyɩ yĩni tɛ̃ fɩ̃́ yɔ́, ńyãh-á pè n ye «Yõ̀gbèkè tyahlɛ», pè à syɩ dahnɩ yõ nɛ́npɔ́ ànɛ̂ tyípêl pɩ́pú nɛ́pĩ̂ nímí nɔ́pilɛ pé tyɩ́ tyɩ́ dahlɔ yõ. Núkú sõ̀ mɛ syɩ́nɔ́lɛ ǹ gbõ̀yõ̀ sõ̀, ní-ò mɛ syɩ́nɔ́lɛ ǹ gbɛ̃̀yɩ̃̀nɛ̀ sõ̀. ");
INSERT INTO wib_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Légbĩ́nɛ, Yesu mɛ nɛ: «Bɔ̌, pǎh nɛ̂nɛ n pɩ, pè náh kè pɩ̃. Képah ye, á gblɔ̌y yɛ pé tyɩ́.» Képah náh, sràsyíbí mɛ ǹdan mɔ, à ǹ flɔ dibi wɛ̃ wrɔ́. ");
INSERT INTO wib_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Névye sõ̀ mɛ yĩ́nntɛ̃̀nɔ́lɛ nɛ́npɔ́ mɛ n yah. Tɛ́ Nsyifunɔ yõ̀tãm wɔ sõ̀ mɛ kṍlɛ ǹnɛ n ko, mɛ yo tũ nɛ, wǎh névye túkù pwah mɔ, ǹtɛ à ǹ gblɔ̌y pwah mɔ mó kɛ̀, ǹmɔ-à kɩ nɛ̂ Kristalɛ, Liyel yáhntɔkɔnɔlɛ. ");
INSERT INTO wib_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Sràsyíbí tɔ sõ̀ mɛ kṍlɛ ǹnɛ n ko, tɛ́ nɔ de ǹ tnɔ̂, à dìvɛ̃ yṍrénɔ́lɛ à kɔ̃, tɛ́ nɛ, ");
INSERT INTO wib_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ǹmɔ-à kɩ nɛ̂ Nsyifunɔ yõ̀tɛ̃̀nɛ, à ǹ gblɔ̌y pwah mɔ kɛ̀! ");
INSERT INTO wib_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Tɛ́ kè sõ̀ mɛ wã́rkɩ́nsyɩnɔlɛ Yesu yõ̀tah nɛ: «Ńyɔlɛ, Nsyifunɔ yõ̀tɛ̃̀ ye.» ");
INSERT INTO wib_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Képah sɔkɔ, tyípêl pɩ́pú nónó-á syɩ dahlɔ yõ, pé sɔkɔ núkú sõ̀ mɛ Yesulɛ n gbyɔ nɛ, ǹmɔ kó Kristalɛ nɩ? À ǹ gblɔ̌y pwah mɔ, à mó pépi tɔ pwah mɔ! ");
INSERT INTO wib_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ǹtɛ, ǹ ní-ò mɛ wɛkɩ ǹ yõ, tɛ́ yo ǹ tyɩ́ nɛ, à kó Liyel yah tíkílɛ n pɩ nɩ, ǹmɔ nɛ̂-á mɛ kénɛ yèvyãhrɩ núkú mɛ̀ sɔkɔ? ");
INSERT INTO wib_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Pépi tɛ̃̀ wɔ tyɩ́lɛ, pé yèvyãhrɩ pɩ́nɔ́ yah-á. Pé tyípɩ́nɔ́ kɔ̃lɩ-á n dyah pélɛ. Ǹtɛ, ǹmɔ tɛ̃̀ náh tir yɔ́ ńtɛ̃ pɩ pèkèlɛ. ");
INSERT INTO wib_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Tɛ́ tɔ̃ ǹ syɩ yo Yesu tyɩ́: «Yesu, á dyɔ to n kõ ńmɔ tyɩ́lɛ, wâh pɔ á yõ̀tɔ̃rɩ́ sɔkɔ gbĩ́ nɛ̂nɛ.» ");
INSERT INTO wib_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesu mɛ yo ǹ tyɩ́: «Kègbɩ yõ, mé kélɛ n yo n dal n mɔ á tyɩ́ nɛ: kwɛy mɛ̀ ńtɛ̃ sɔkɔ, á kɩ mɛ ńmɔlɛ Liyel fṍ sɔkɔ pal tɛ̃̀-ǹsah.» ");
INSERT INTO wib_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Gbĩ̀ntɔ̃̀ pɔ̃́lɛ, gbĩ yah kwlɔ, fɛ̃́ntũ̂ mɔ kèkõyṍ pól sɔkɔ pópó, à pɔ syɩ gbèkãm gbĩ́ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Nɛ́npɔ́ swɔ, fwɔ̀gbrǒkè nɛ̂-á Liyel wɔ̀kɔ̀ ǹgbɛ̃ fɔkɔ táh kõ kah, kè tɔ ké nɩyṍ. ");
INSERT INTO wib_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesu mɛ kah de syi nɛ ńkɛ̃́: «Bɔ̌, mé ń minnɛ n dahbɩ á gbõ̀.» Képah yóntɛnɔ náh, à ku. ");
INSERT INTO wib_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Sràsyíbí lèkwɛ̌ yõ̀tɛ̃̀ dĩ́-á képah wɛ ńyãh sɔkɔ, à tyah Liyel yĩnnɛ n gbilki mɛ n yo nɛ, kègbɩ yõ, nɛ́gbɩ́-á sõ̀ dĩ́ mɛ̀nɛ. ");
INSERT INTO wib_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Tɛ́ nónó pól-á sõ̀ mɛ pɔ yĩn tɛ̃ kélɛ n yah, pǎh kénɛ tyípɩ́nɔ́ wɛ sɛ̃́, pé pól sõ̀ mɛ pé gbã̀n kõhlɩ pé nɩ yõ mɛ n sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ànɛ̂ nónó pól-á sõ̀ Yesulɛ n pnɛ, à tahlɩ syɔ́ nónó pól-á sõ̀ wil Kalile kwil sɔkɔ, à pɔ ǹnɛ wɛ̃ tyɩ́, pé pól sõ̀ mɛ yĩn tɛ̃ fɩ́ɩ́, tɛ́ mɛ n yah. ");
INSERT INTO wib_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Tɛ́ dĩ́ yɔ́ sõ̀ mɛ, pè n ye Yosɛfulɛ. À sõ̀ n wil Nsyifunɔ kwil yɔ́ sɔkɔ, nɛ̂ yĩn-á Arimatɩlɛ. Nsyifunɔ tukey tùkèpu sɔkɔ nɛy yɔ́ ye sõ̀. Tɛ́ pèpɔrɩ pɩ́-ò nɛ́gbɩ́ ye sõ̀ ǹnɛ. À náh sõ̀ n de pé no tɛ́lɔ́ tyi yáhntɔkɔnɔ, ànɛ̂ sé pɩ́nɔ́ sɔkɔ. Ànɛ̂, à sõ̀ mɛ Liyel tɔ̃́rɩ́ pɔ́nɔ́lɛ n syɩkɩ. ");
INSERT INTO wib_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ǹmɔ mɛ kyɩ wil Pilatɩ tyɩ́, à Yesu lékó ni ǹ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Tɛ́ mɛ kyɩ à tiki mɔ dahnɩ yõ, tɛ́ fwɔlɛ à plo, à kyɩ dah mɔ diki yɔ́ sɔkɔ. Kénɛ diki sõ̀ tũ tɛkɩ sɔkɔ, tɛ́ lékó yɔ́ ńtɛ̃ náh tɔ̃̌nɩ̀ sõ̀ dah mɔ yah ké sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Tɛ́ lésõlɛ, gblɔ̌y vìnsàhnɔ́ yòh ye sõ̀ Nsyifunɔ tyɩ́, dendal mɩ mɩ yòh yĩnnɛ. ");
INSERT INTO wib_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Syɔ́ nónó-á sõ̀ wil Yesulɛ, Kalile kwil sɔkɔ, pè Yosɛfu sõ̀ tɛ̃ kyɩ diki yõ. Pè kyɩ diki yah mɔ, ànɛ̂ Yesu dáhnmɔ dùkùlɛ ké sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Képah náh, pè pé syɩ to yuku kwil sɔkɔ, à kyɩ nɩrɩnɔ́, ànɛ̂ làsèkwěl pèplɔ yah sah lékó yĩnnɛ. Tɛ́ mɛ mɩ, pé mɩ mɩ yòh sṍlɛ, sɔ̃́-á kélɛ Liyel tyi kõ̀nsàhnɔ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Nsyifunɔ mɩ mɩ yòh-á sɔkɔ, ké dendal séngbɔ̃́ pú púlɛ, syɔ́ nɔ́pi yuku sɔkɔ diki yõ, pé nɩrɩ pèplɔ nɔ́pilɛ, pǎh sõ̀ nónó pɩ sah. ");
INSERT INTO wib_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Pè kyɩ nɛ n yah diki yah dáhkɩ̀ mɛ pílntonɔlɛ. ");
INSERT INTO wib_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Pǎh de diki sɔkɔ, pè náh kyɩ Tɛ̃̀ ǹgbɛ̃ Yesu lékó wɛ. ");
INSERT INTO wib_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Kǎh pɩ sɛ̃́, pé fɔkɔ fil. Pǎh mɛ képah sɔkɔ, díbí nɛ́pĩ̂ nímí yísyɔ́ wil pé yah, nónó wil flɔ-á sõ̀ mɛ n tɛ̃ pěrr. ");
INSERT INTO wib_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Tíkí tɛ̃̀ tyɩ́, syɔ́ nɔ́pi pé yey sĩnki sétáh. Díbí nɔ́pi mɛ yo pé tyɩ́: «Kwâh nɛ̂ pɩ, tɛ́ nɛ̂-á min sɔkɔ, yé pɔ ǹnɛ n yah n kɔ̃ diki sɔkɔ? ");
INSERT INTO wib_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","À náh mɛ ásõ̂. À ye ǹ syɩ min wɛ. Wǎh lésõ mɛ Kalile sɔkɔ, tɛ́ nɛ̂ yo sah yé tyɩ́, yé yé dyɔ to kõ képahlɛ. ");
INSERT INTO wib_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","À náh lésõ nɛ ńkɛ̃́, Névi Pi-á yɩ̃nɛ à dahbɩ tyípêl pɩ́pú gbõ̀, wǎh yɩ̃nɛ à syɩ dahnɩ yõ, tɛ́ ǹ kúnɔ́ sèpĩ̀n tɔ̃́-ò sṍlɛ, à mó ǹ syɩ min sã́n wɛ di?» ");
INSERT INTO wib_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Légbĩ́nɛ, syɔ́ nɔ́pi dyɔ núkú to kõ Yesu wɛynɛ. ");
INSERT INTO wib_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Pè mɛ yal diki yõ, à kyɩ tyi nɔ́pi pól yãh tõ̀ sã́hpú nɛ́pĩ̂ gbɔ̃núkú syah ànɛ̂ no tɛ́lɔ́ póllɛ. ");
INSERT INTO wib_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Makadala kwil Mari, ànɛ̂ Nsyan, ànɛ̂ Nsyakɩ yṹ Mari, ànɛ̂ syɔ́ nónó-á sõ̀ mɛ pélɛ, pépi ye yãh tyi nɔ́pilɛ Yesu tɛ̃̀ntõbe tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ǹtɛ, kénɛ wɛlɔ sõ̀ mɛ pɩ tɛ̃ pé tyɩ́ sèmìrn sɔ̃́. Pé náh sɛ̃ sé yõ. ");
INSERT INTO wib_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Kǎh pɩ sɛ̃́, Pyɛrɩ wɔ mó yuku to kyɩ diki yõ. Wǎh kɔ yah, à lékó flɔ ó wɛ. Ǹ gbã̀n du tir mɛ̀ pɩ́nɔ́ dùkùlɛ, à mɛ ǹ syɩ to yuku ǹ tĩ̀nnɛ. ");
INSERT INTO wib_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ké lésõ mɛ ólɛ, Yesu tõ̀ sã́hpú nɛ́pĩ̂ nímí sõ̀ mɛ n yuku kwil yɔ́ sɔkɔ pè n ye Yemayusilɛ. Kénɛ kwil ànɛ̂ Yerusalɛmɩ wrɔ́ sõ̀ mɛ lɛ́rɩ́nɔ́ nínɔ́ kɔ́-ńsahlɛ. ");
INSERT INTO wib_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Tyi nónó-á pɩ, pè sõ̀ mɛ sépi yã́hnɔ́ sɔkɔ wɛ̃ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Pǎh mɛ yã́hkɩ̀ ànɛ̂ wɛ̃ vìnmɔnɔ sɔkɔ gbĩ́ nɛ̂nɛ, Yesu mɛ pɔ kwrɔ mɔ pé sɔkɔ, à wɛ̃̀kɩ̀ pɩ núkúlɛ pélɛ. ");
INSERT INTO wib_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ǹtɛ, kè sõ̀ pɩ á kɩ nɛ pé yah sɔ̃́ mɛ syìì, pè náh sõ̀ mɛ tɛ̃ wɛ à yah pɩ̃ yĩ́nɛ. ");
INSERT INTO wib_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Képah sɔkɔ, à mɛ pè piki yah nɛ, tir nɛ̂ se pè n yãh, tɛ́ n kɔ nɩ? Pè mɛ yĩn, tɛ́ mɛ yèkwɔrɩ sɔkɔ sɛ̃́. ");
INSERT INTO wib_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Tɛ́ pé sɔkɔ nɛy núkú yɔ́ sõ̀ mɛ, pè n ye Klewopasɩlɛ. Ǹmɔ mɛ yo Yesu tyɩ́ nɛ, ǹmɔ gblɔ̌y ó se mɛ Yerusalɛmɩ sɔkɔ, tyi nɔ́pi pɩ̃́-ńkɛ̃̂nɛ, nónó-á pɩ ké sɔkɔ sèpĩ̀n nɔ́pi sɔkɔ nɩ? ");
INSERT INTO wib_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","À mɛ pè piki yah nɛ, sépi se pɩ tyi nónónɛ nɩ? Pè mɛ yo ǹ tyɩ́ nɛ, tir nɛ̂-á pɩ Nasarɛtɩ Yesu tyɩ́ sɔkɔ kɛ̀: Ǹmɔ nɛ̂-á sõ̀ pɩ Liyel tɛ̃ntõ̀ syínyo-ò nɛ́tǎhkɩ̀lɛ ǹ tyípɩ́nɩ̀ ànɛ̂ ǹ wɛy sɔkɔ, Liyel yah ànɛ̂ névye pól yah sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ǹtɛ, pé sárká wìlkìpu yõ̀tãm, ànɛ̂ pé kwil yahtãm pɔ à tɛ̃ kɔ̃ nɛ, pè ko mɔ. Pè mɛ à syɩ dahnɩ yõ. ");
INSERT INTO wib_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Tɛ́ pépi tɛ̃̀ wɔ-á sõ̀ mɛ n sõ nɛ, ǹmɔ-á kɩ pɔ Yisrayel tãn wilki n pi yɔ̃rɩ sɔkɔ. Ǹtɛ, sépi pól sɔkɔ, kénɛ tyi pɩ́nsɔkɔnɔ sèpĩ̀n tɔ̃́nɩ̀-á kwɛynɛ yɔ̀. ");
INSERT INTO wib_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Gbɩ-á pépi mû sɔkɔ, syɔ́ yísyɔ́-á pɔ pé fɔkɔ fil tɛ̃̀ wɔlɛ. Pépi-á sõ̀ yuku sɔkɔ séngbɔ̃́ pú púlɛ diki yõ, ");
INSERT INTO wib_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","pǎh kyɩ lékó yah kwlɔ sɛ̃́, pè pé syɩ pɔ yo pé tyɩ́ nɛ, yĩ̂nyõ tɛ̃ntõnè yísyɔ́ ńtɛ̃-á wil pépi yah, tɛ́ yo pé tyɩ́ nɛ, wǎh mɛ min sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Pépi sɔkɔ névye túkù mɛ kyɩ diki yõ sɔkɔ, tɛ́ ńtyɩ̃́nɔ kyɩ tyi nɔ́pi pól wɛ, sɔ̃́-á sõ̀ syɔ́ yo sélɛ, tɛ́ pè náh Yesu wɔ wɛ. ");
INSERT INTO wib_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Pǎh yo sɛ̃́, Yesu mɛ yo pé tyɩ́: «Lékã́m kɛ̃́ névye, yépi náh n kwãh n sɛ̃ Liyel tɛ̃ntõ̀ syínyopu wɛlɔ pól yónɔ́ yõ! ");
INSERT INTO wib_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Krista náh sõ̀ yɩ̃nɛ à yèvyãhrɩ pɩ sɛ̃́, à mó pyě de ǹ tɔ̃́rɩ́ sɔkɔ di?» ");
INSERT INTO wib_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Tɛ́ ǹ syɩ, à tyi pól dùkù yo wah pè syah, Liyel wɛy sɛ́bɛ́ynɔ́-á nónó yo ǹ tyɩ́ sɔkɔ, à tyah Moyisi tyíyónsahnɩ tyɩ́ pópó, à kyɩ syɩ Liyel tɛ̃ntõ̀ syínyopu tyínɔ́ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Képah tɛ̃̀nɛ, pǎh pɔ yĩni tɛ̃ pé yúkú-ńsah kwillɛ yúkɛy, Yesu pɩ á kɩ nɛ à sɔ̃́ yɔ̃ n sɔkɔ yahlɛ. ");
INSERT INTO wib_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ǹtɛ, pè mɛ à fal nɛ, à wũ pépilɛ, ńkɛ̃́ gbĩ-á mɛ tiki mɔ, lékã̂h-á mɛ n tyah mɔ́nɔ́lɛ. Pǎh yo sɛ̃́, à mɛ de gbô sɔkɔ, à wũ pélɛ. ");
INSERT INTO wib_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Tɛ́ wǎh pɔ tɛ̃, à n tyah yõke yṍnɔ́lɛ pélɛ gbĩ́ nɛ̂nɛ, à mɛ búrn tɔkɔ, tɛ́ wɛkɩ Liyel tyɩ́, tɛ́ kè kwɔkɩ pè kɔ̃. ");
INSERT INTO wib_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Képah sɔkɔ, pé yah pɩ kyòo, pè à yah pɩ̃. Ǹtɛ, pè núkú à yah kwlɔ pé tnɔ̂. ");
INSERT INTO wib_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Pè mɛ tyah n yo wɛ̃ tyɩ́ nɛ, wǎh sõ̀ n yãh pélɛ wɛ̃̀kɩ̀ yah gbĩ́ nɛ̂nɛ, à Liyel wɛy sɛ́bɛ́ynɔ́ sɔkɔ tyi dùkùlɛ n yo n wah pélɛ n syah, pé nɩ kó sõ̀ mɛ kàhnvɩnɔlɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Nɛ́npɔ́ swɔ, pè núkú yuku, à pé syɩ sɔkɔ Yerusalɛmɩ, à kyɩ tõ̀ sã́hpú nɛ́pĩ̂ gbɔ̃núkú ànɛ̂ pé kɔ mû wɛ tùkènmɔntɛ̃̀nɔ́lɛ. ");
INSERT INTO wib_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Pépi mɛ yo nímí nɔ́pi tyɩ́: «Gbɩ yõ, Tɛ̃̀ ǹgbɛ̃ Yesu yuku wil diki sɔkɔ. À ǹ gblɔ̌ynɛ Simɔ wɛ̃kɩ.» ");
INSERT INTO wib_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Pǎh yo sɛ̃́, tyi nónó-á mó pɩ nɛ́pĩ̂ nímí nɔ́pi tɔ tyɩ́ wɛ̃̀kɩ̀ yah, ànɛ̂ pǎh Yesu yah pɩ̃ sɔ̃́, ǹ búrn dibi dùkù sɔkɔ, pè mó sè yãh pè syah. ");
INSERT INTO wib_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Képah tɛ̃̀nɛ, pǎh mɛ képah yónɔ́ sɔkɔ sɛ̃́, Yesu núkú wil mɔ pé nɩyṍ, tɛ́ yo pé tyɩ́: «Yèvɩnɩ nɛ mɛ yélɛ.» ");
INSERT INTO wib_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Tíkí tɛ̃̀ tyɩ́, pé lékã́m vye fɛ̃kɩ. Pè sõ̀ mɛ n sõ nɛ, nɛ́mírkí yɔ́-á pé wɛ. ");
INSERT INTO wib_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Képah sɔkɔ, Yesu mɛ yo pé tyɩ́: «Kwâh nɛ̂ pɩ, tɛ́ yé lékã́m vye fɛ̃kɩ? Kwâh nɛ̂ pɩ, tɛ́ yélɛ tɔ̀tɔ̀ sɔkɔ sɛ̃́? ");
INSERT INTO wib_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Yé yah ń gbã̀nnɛ ànɛ̂ ń gbyẽ̂hnɛ: Ńmɔ ye gbɩ yõ! Yé tũ yah ń tyɩ́, yé kɩ wil gbɛ̃́nsê ànɛ̂ gbèl wɛ ń tyɩ́. Sé kénkɔ̃ se mɛ nɛ́mírkí tyɩ́?» ");
INSERT INTO wib_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","À mɛ képah yónɔ́ sɔkɔ, tɛ́ ǹ gbã̀n ànɛ̂ ǹ gbyẽ̂hnɛ pè wɛ̃kɩ. ");
INSERT INTO wib_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ǹtɛ, nɩ̀vɩ̀nɩ̀ ànɛ̂ gbɛ̃̀ndùnì tɛ̃̀ tyɩ́, pǎh tɛ̃ sɛ̃ kwlɔ ké yõ sɛ̃́, à mɛ pè piki yah nɛ, yõ yõ kwâh se mɛ pé tyɩ́ ásõ̂ nɩ? ");
INSERT INTO wib_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Pè mɛ yɛ̃́nkɔ̂ fyénɔ́ yen yɔ́lɛ à kɔ̃. ");
INSERT INTO wib_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","À mɛ kè syi, tɛ́ kè kɔ pé yĩ́ yah. ");
INSERT INTO wib_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Képah náh, à yo pé tyɩ́: «Képah ye lésõ mé yo yé tyɩ́, máh lésõ mɛ ànɛ̂ yélɛ gbĩ́ nɛ̂nɛ nɛ ńkɛ̃́, tyi nónó pól-á wãrkɩ sah ńmɔ tyɩ́ sɔkɔ Moyisi tyi sàhnɔ́ sɛ́bɛ́y sɔkɔ, ànɛ̂ Liyel tɛ̃ntõ̀ syínyopu sɛ́bɛ́ynɔ́ sɔkɔ, ànɛ̂ yɩ̀gbɩ̀nɩ̀ sɛ́bɛ́y sɔkɔ, sé pól-á kɩ pɩ tũ.» ");
INSERT INTO wib_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Képah sɔkɔ, à pé lékã́m yɩkɩ mɔ Liyel wɛy sɛ́bɛ́ynɔ́ sɔkɔ tyi dùkù pɩ̃ yĩnnɛ, ");
INSERT INTO wib_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","tɛ́ yo pé tyɩ́: «Kè pɩ, sɔ̃́-á sõ̀ kélɛ wã́rkɩ́nsàhnɔ́lɛ nɛ ńkɛ̃́, Krista-á kɩ yèvyãhrɩ pɩ ku, tɛ́ kɩ ǹ syɩ yuku ǹ kúnɔ́ sèpĩ̀n tɔ̃́-ò sṍlɛ. ");
INSERT INTO wib_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ǹmɔ yĩn yõ, Liyel wɛy-á kɩ yo kɔ̃, à tyah Yerusalɛmɩ fɔ́ɔ́, à kyɩ syɩ kèkõyṍ kwlo kwlo pól tyɩ́ nɛ ńkɛ̃́, névye Liyel wɛ̃̀kɩ̀ tɛ̃, pè mó tyípêl yɔ̃̀nmɔnɔ wɛ. ");
INSERT INTO wib_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Yépi ye pɩ kénɛ tyi tàrfyɔ̀nɔ́lɛ. ");
INSERT INTO wib_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Tɛ́ ńmɔ sú-á ǹ vyãh kɔ̃ nɛ, páh kɩ nɛ̂nɛ yé kɔ̃, mé kɩ à tɛkɩ mɔ yé kɔ̃. Ǹtɛ, yépi tɛ̃̀ wɔ tɛ̃ kwil mɛ̀ sɔkɔ fɔ́ɔ́, yé pɔ tǎhkɩ̀ wɛ nɛ̂-á kɩ wil yĩ̂nyõ.» ");
INSERT INTO wib_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Képah náh, sṍ yɔ́lɛ, Yesu pè tɛ̃, à yuku pélɛ Betanɩ kwil tĩ̀nnɛ. Pǎh yĩni tɛ̃ nɛ́npɔ́, à ǹ gbã̀n yɔ̃ yĩ̂nyõ, à sãm mɔ pé sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Tɛ́, wǎh mɛ sãmnɛ n mɔ pé sɔkɔ gbĩ́ nɛ̂nɛ, à gbɛ wil pé sɔkɔ, à yɔ̃ dɔkɔ sɔkɔ yĩ̂nyõ. ");
INSERT INTO wib_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Tõ̀ sã́hpú tɛ̃̀ wɔlɛ, pépi-á à gbilki tɛ, pè pé syɩ sɔkɔ Yerusalɛmɩ, nɩ̀vɩ̀nɩ̀ ǹgbɛ̃nɛ pé sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Tɛ́ gbĩ́mɛgbĩ́, pè náh sõ̀ mɛ n yah n kwlɔ Liyel wɔ̀kɔ̀ ǹgbɛ̃ kéntáhkɩ̀ sɔkɔ, n nɛ n mɛ Liyel yĩnnɛ n gbilki.");
INSERT INTO wib_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Tyi pól tyah gbĩ́nɛ, nɛ̂-á wɛynɛ, à lésõ mɛ. À lésõ mɛ ànɛ̂ Liyellɛ. Liyel ye ǹnɛ. ");
INSERT INTO wib_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ǹmɔ ye lésõ mɛ ànɛ̂ Liyellɛ tyah gbĩ́nɛ. ");
INSERT INTO wib_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Yíyìn pól mɔ ǹmɔ gbõ̀ yõ sɔkɔ. Yî nónó pól-á mɔ, sé kèyǎh ńtɛ̃ náh mɔ nɛ́ ǹmɔ náh. ");
INSERT INTO wib_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ǹmɔ sɔkɔ ye min n wɛ. Kénɛ min ye kyòolɛ névye tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Kè mɛ kõ tɛ̃ kyòo fɛ̃́ntũ̂ sɔkɔ, tɛ́ fɛ̃́ntũ̂ náh tɛ̃ wɛ ké yah kõ. ");
INSERT INTO wib_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Képah sɔkɔ, Liyel pɔ dĩ́ yɔ́ tõ, nɛ̂ yĩn-á Nsyɔ̃nɛ. ");
INSERT INTO wib_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ǹmɔ ye pɔ kyòo mɛ̀ tyɩ́ yo wah névye tyɩ́, nɛ pé pól wɛ sɛ̃ ké yõ sɔkɔ ǹmɔ gbõ̀ yõ. ");
INSERT INTO wib_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ǹmɔ náh sõ̀ kyòo mɛ̀nɛ, ǹtɛ ké tyɩ́ yónwàh-ǹsah ye sõ̀ à pɔ. ");
INSERT INTO wib_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Wɛy mɛ̀nɛ, kyòo kègbɩ ye sõ̀ kélɛ, nɛ̂-á pɔ kèkõyṍ sɔkɔ, à pɔ pɩ kyòolɛ no pól tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Tɛ́ nɛ̂-á wɛy mɛ̀nɛ, à sõ̀ mɛ kèkõyṍ sɔkɔ. Kèkõyṍ mɔ ǹmɔ gbõ̀ yõ sɔkɔ, ǹtɛ képah fyé yõ, kèkõyṍ névye náh tɛ̃ wɛ à yah pɩ̃. ");
INSERT INTO wib_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ǹ yɛ̃́ngbɛ̃́ tyah sɔkɔ ye à pɔ, tɛ́ ǹ no náh à tɛ̃ plɛ. ");
INSERT INTO wib_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ǹtɛ nónó tɛ̃̀ wɔ-á à tɛ̃ plɛ tɛ́ sɛ̃ ǹ yõ, à tɛ̃́nwɛnɔlɛ pépi kɔ̃ pè pɩ Liyel wɛ̃́npìlɛ. ");
INSERT INTO wib_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ǹtɛ tṍ sɔkɔ dubi dùkù, képah náh pɩ wil gbɛ̃́nsê dékè, képah náh pɩ névi dyɔ yĩ́ĩ́ tɛ̃̀ sɔkɔ náh pè pɩ Liyel wɛ̃́npìlɛ dɛ́! Liyel gbõ̀ yõ sɔkɔ ye pè wɛ. ");
INSERT INTO wib_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Wɛy ye vi mɔ pɩ névilɛ à pɔ twah tɛ̃ á wrɔ́. Yõ̀bènɔrɩ pɩ́-ò ye ǹnɛ, ànɛ̂ à mɛ gbɩ ó ǹ tɔ̂ɔ́. Ǹmɔ nɛ̂-á Liyel Pi núkúnínɛ, á ye ǹ tɔ̃́rɩ́ wɛ, tɔ̃́rɩ́ nɛ̂-á à wɛ syi ǹ Sú tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ǹmɔ tyɩ́ ye lésõ Nsyɔ̃ yo tũ léyy nɛ ńkɛ̃́: «Ǹmɔ tyɩ́ sɔkɔ ye mé lésõ kè yo nɛ ńkɛ̃́: ‹Ǹnɩ̂ kɩ n pɔ n pi ńmɔ tyɩ́ náh, tɛ́ à mɛ tɛ tɛ́ ńmɔ dubi, képah ye à kal ńnɛ.›» ");
INSERT INTO wib_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ápi mɛ yõ̀bènɔrɩlɛ n tɔ̃ n wɛ n yuku ǹ nɩ̀gbɛ̀kɩ̀ tnɔ́nkàhnmɔnɔ gbõ̀ yõ, ǹmɔ nɛ̂-á Yesulɛ. ");
INSERT INTO wib_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Moyisi gbõ̀ yõ ye Liyel ǹ tyi kõ̀nsàhnɔ́lɛ á kɔ̃. Ǹtɛ Yesu nɛ̂-á Liyel nɛy yáhntɔkɔnɔlɛ, ǹmɔ wɔ gbõ̀ yõ sɔkɔ ye yõ̀bènɔrɩ ànɛ̂ gbɩ wɔ wɛ. ");
INSERT INTO wib_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ǹnɩ̂ yɔ́ ńtɛ̃ yĩ́ náh tɛ̃ yah Liyel yõ. Ǹtɛ ǹ Pi núkúní nɛ̂ tyɩ́-á yo sɔkɔ, ǹmɔ nɛ̂-á Liyellɛ, tɛ́ mɛ Sú Liyel tnɔ̂, ǹmɔ ye Liyel dùkùlɛ á wɛ̃kɩ. ");
INSERT INTO wib_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","20","Nsyifunɔ yõ̀tãm lésõ Yerusalɛmɩ kwil sárká syínwìlkìpu, ànɛ̂ Levi yìkì névye yísyɔ́ tõ Nsyɔ̃ tyɩ́, pè kyɩ à piki yah nɛ, ǹmɔ tɛ̃̀ se nɛ nɛ̂ ó-á péwɔlɛ nɩ? Nsyɔ̃ náh yahle ké yónɔ́lɛ pé tyɩ́ dɛ́! À kè yo dal mɔ pé tyɩ́ pnɛ́yy pé pól yĩ́ yah nɛ, péwɔ náh Liyel nɛy yáhntɔkɔnɔlɛ. ");
INSERT INTO wib_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Képah sɔkɔ, pè mɛ nɛ, ǹtɛ nɛ̂ se ǹmɔlɛ nɩ? Ńkɛ̃́ ńmɔ se Yelilɛ nɩ? Nsyɔ̃ mɛ pè syah nɛ, ǹmɔ náh péwɔlɛ. Pè nɛ, ǹtɛ Liyel tɛ̃ntõ̀ syínyo-ò nɛ̂-á kɩ n pɔ n pi, ǹmɔ se ǹnɛ nɩ? À mɛ nɛ ɔ̃́ɔ̃-á. ");
INSERT INTO wib_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Képah tɛ̃̀nɛ, pè nɛ, ǹtɛ ǹmɔ tɛ̃̀ se nɛ nɛ̂ ó-á pélɛ nɩ? À kè yo pé syah pé kɔ̃ pé kyɩ wɛ yo pé tṍpú tyɩ́ kɛ̀. Ńkɛ̃́ sɔ̃́ se à kɩ yo ǹ gblɔ̌y tyɩ́ sɔkɔ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Képah sɔkɔ, Nsyɔ̃ mɛ nɛ: «Ńmɔ tyɩ́ ye lésõ Liyel tɛ̃ntõ̀ syínyo-ò Yesayi yo sah ǹ wɛy sɔkɔ nɛ, ǹnɩ̂ yĩ́npɔ̃́-á mɛ n dɔkɔ gbɛ̃́nnɩ sɔkɔ nɛ ńkɛ̃́: ‹Yé wɛ̃̀kɩ̀ tɔ̃ sah Tɛ̃̀ ǹgbɛ̃ yĩnnɛ!›» ");
INSERT INTO wib_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ǹtɛ nónó-á sõ̀ pè tõ Nsyɔ̃ tyɩ́, Farisi wɛ̃̀kɩ̀ kɔ́pú ye sõ̀ pélɛ. ");
INSERT INTO wib_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Pè tɔ̃ à piki yah nɛ, ǹmɔ-à ńkɛ̃̂nɛ Liyel nɛy yáhntɔkɔnɔlɛ, képah náh pɩ Yelilɛ, képah náh pɩ Liyel tɛ̃ntõ̀ syínyo-òlɛ, ǹtɛ kwâh nɛ̂ se pɩ tɛ́ à névyelɛ n wel n wilki ni sɔkɔ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Képah sɔkɔ, à yo pé tyɩ́ nɛ: «Ńmɔ tɛ̃̀ wɔ mɛ nolɛ n wel n wilki ni sɔkɔ, ǹtɛ ǹnɩ̂ mɛ yépi wrɔ́, nɛ̂-á yé náh ǹnɛ n pnɛ. ");
INSERT INTO wib_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ǹmɔ kɩ n pɔ n pi ńmɔ tyɩ́ náh. Tɛ́ ńmɔ ńtɛ̃ fṍrɔɔ kah ǹ lékyêh mnɔ fyé dɛ́nmɔnɔlɛ.» ");
INSERT INTO wib_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Kénɛ tyi pól sõ̀ pɩ Betani kwil sɔkɔ, Nsyurdɛ̃ yɔ́nkahnɩnɛ. Nɛ́npɔ́ sɔkɔ ye sõ̀ Nsyɔ̃ n wel n wilki nolɛ ni sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ké dĩndallɛ, Nsyɔ̃-á Yesu wɛ à mɛ n pi ǹ tnɔ̂, à nɛ ńkɛ̃́: «Yé yah, Liyel-á képɔ́píkì nɛ̂ tɛkɩ mɔ kèkõyṍ névye tyípêl tɛ̃ yõ yĩnnɛ, ǹmɔ ye yɔ̀. ");
INSERT INTO wib_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ǹmɔ tyɩ́ sɔkɔ ye mé lésõ kè yo nɛ ńkɛ̃́: ‹Ǹnɩ̂ kɩ n pɔ n pi ńmɔ tyɩ́ náh, tɛ́ à mɛ tɛ tɛ́ ńmɔ dubi, képah ye à kal ńnɛ.›» ");
INSERT INTO wib_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ńmɔ ńtɛ̃ tɔ náh lésõ ǹnɛ n pnɛ. Ǹtɛ yáh wɛ mé pɔ wèlnwìlkìnɔ́lɛ n pɩ ni sɔkɔ, ǹ dùkù ye mé Yisrayel tãnnɛ n wɛ̃kɩ.» ");
INSERT INTO wib_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Nsyɔ̃ tyíyókè mɛ̀ yo Yesu tyɩ́ sɔkɔ nɛ ńkɛ̃́: «Liyel nɛ̂-á tɛkɩ mɔ ńnɛ nɛ mé wèlnwìlkìnɔ́lɛ n pɩ ni sɔkɔ, à lésõ yo ń tyɩ́ nɛ ńkɛ̃́: ‹Wáh kɩ Liyel Mirki wɛ kè tiki pɔ tɛ̃ nɛ̂ yõ, ǹmɔ ye kɩ névyelɛ n wel n wilki Liyel Mirki sɔkɔ.› Ńmɔ ńtɛ̃ náh lésõ ǹnɛ n pnɛ. Ǹtɛ mé pɔ Liyel Mirki wɛ kè wil yĩ̂nyõ à n tiki n pi kèpíkípíkí tyɩ́ kɔ̃lɛ, à pɔ tɛ̃ ǹ yõ. ");
INSERT INTO wib_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Mé ye kè wɛ yĩ́nɛ. Képah ye mé kélɛ n yo n dal mɔ nɛ, Liyel Pídĩ́-á dĩ́ mɛ̀nɛ.» ");
INSERT INTO wib_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Tɛ́ dĩndallɛ, Nsyɔ̃ tɔ̃ sõ̀ mɛ nɛ́npɔ́ ànɛ̂ ǹ tõ̀ sã́hpú sɔkɔ nɛ́pĩ̂ nímí yísyɔ́lɛ. ");
INSERT INTO wib_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Wǎh Yesu wɛ à pɔ n sɔkɔ à nɛ ńkɛ̃́: «Yé yah képɔ́píkìlɛ, nɛ̂-á Liyel tɛkɩ mɔ.» ");
INSERT INTO wib_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Képah tɛ̃̀nɛ, Nsyɔ̃ tõ̀ sã́hpú nɛ́pĩ̂ nímí nɔ́pi-á ǹ wɛy mɛ̀ noh sɛ̃́, pè kõ Yesu náh. ");
INSERT INTO wib_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesu-á vi yah tɛ́ pé wɛ pè mɛ ǹ sõ̀ tɛ̃, à pè piki yah nɛ, kwâh nɛ̂ se pè n yah n kɔ̃ nɩ? Pè mɛ à ye Wrabilɛ, nɛ̂ kɔ́r-á kwɔ́-ò dĩ́nɛ. Tɛ́ à piki yah nɛ, ǹ twáhntɛ̃̀-ǹsah se mɛ ńyãh sɔkɔ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","À mɛ yo pé tyɩ́ nɛ, pè pɔ, pǎh kɩ kyɩ kè wɛ. Pè mɛ ǹ sõ̀ tɛ̃ kyɩ ǹ twáhntɛ̃̀-ǹsah wɛ lɛ́rɩ́nɔ́ gbãm-ò kénkɔ̃ sɔkɔ. Képah sɔkɔ, pè mɛ wũ ǹ tyɩ́, à lésõ gbĩ̀yĩ̀kì tɛ́y pɩ. ");
INSERT INTO wib_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Nsyɔ̃ tõ̀ sã́hpú nɛ́pĩ̂ nímí nónó-á sõ̀ ǹ wɛy noh tɛ́ Yesu sõ̀ tɛ̃, pé sɔkɔ núkú yɔ́ yĩn ye Andrelɛ. Simo-Pyɛrɩ yṹnpi ye sõ̀ ǹnɛ. ");
INSERT INTO wib_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andre-á yal nɛ́npɔ́, kénɛ Simo-Pyɛrɩ tyɩ́ ye à kyɩ wil gbennɛ, ǹmɔ nɛ̂-á ǹ nɛ́nkyɩ́dĩ́nɛ, tɛ́ yo ǹ tyɩ́ nɛ ńkɛ̃́: «Ápi Krista wɛ.» Krista kɔ́r ye Liyel nɛy yáhntɔkɔnɔlɛ. ");
INSERT INTO wib_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Képah sɔkɔ, à Simo tɛ̃ yuku Yesu tyɩ́. Yesu-á Simo wɛ, à à yah, tɛ́ yo ǹ tyɩ́ nɛ, Nsyɔ̃ pídĩ́ Simo-á ǹnɛ, tɛ́ páh kɩ yĩn yɔ́ dyɩ à kɔ̃ Sefasɩlɛ. Wâh noh nɛ Sefasɩ-á, ké kɔ́r ye légbɩ̃́lɛ. Kénɛ yĩn ye tɔ̃ pè n ye Pyɛrɩlɛ. ");
INSERT INTO wib_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ké dĩndallɛ, Yesu kè yah tɔkɔ nɛ, páh kɩ yuku Kalile gbɛ̃̀nyah sɔkɔ. Wǎh Filipi wɛ, à yo ǹ tyɩ́ nɛ, à pé sõ̀ tɛ̃. ");
INSERT INTO wib_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Betisayida kwil nɛy ye sõ̀ Filipilɛ. Kénɛ kwil tãn ye sõ̀ Andre ànɛ̂ Pyɛrɩ tɔlɛ. ");
INSERT INTO wib_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Képah náh, Filipi kyɩ wil Natanayɛlɩ tyɩ́, tɛ́ yo ǹ tyɩ́ nɛ ńkɛ̃́: «Moyisi tyi kõ̀nsàhnɔ́ ànɛ̂ Liyel tɛ̃ntõ̀ syínyopu-á nɛ̂ tyɩ́ yo sah, á ye à wɛ. Nsyosɛfu pídĩ́ Yesu ye. À n wil Nasarɛtɩ kwil.» ");
INSERT INTO wib_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Wǎh yo sɛ̃́, Natanayɛlɩ à syah nɛ, kwáhgbɩ́ se kɩ fɛ̃ wil Nasarɛtɩ kwil sɔkɔ nɩ? Filipi mɛ yo ǹ tyɩ́ nɛ, à pɔ n yah. ");
INSERT INTO wib_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Képah sɔkɔ, Yesu-á Natanayɛlɩ wɛ à n pi ǹ tnɔ̂, à nɛ ńkɛ̃́, Yisrayel nɛy tɔ́tɔ́-á yɔ̀, nɛ̂-á yĩ́nvǐ náh mɛ ǹ sɔkɔ póllɛ. ");
INSERT INTO wib_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanayɛlɩ mɛ nɛ, ńyãh sɔkɔ se à pɩ̃ pélɛ nɩ? Yesu mɛ yo ǹ tyɩ́ nɛ, Filipi-á pópó ǹnɛ n ye, gbĩ́ nɛ̂-á sõ̀ à mɛ sènsóké séswɔ̂ sõ̀ sɔkɔ, páh sõ̀ mɛ ǹnɛ yah. ");
INSERT INTO wib_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Képah sɔkɔ, Natanayɛlɩ mɛ nɛ: «Kwɔ́-ò dĩ́, Liyel Pídĩ́ ye álɛ. Áwɔ ye Yisrayel tãn yõ̀tɛ̃̀nɛ.» ");
INSERT INTO wib_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Wǎh yo sɛ̃́, Yesu mɛ à syah nɛ, páh yo ǹ tyɩ́ nɛ páh sõ̀ mɛ ǹnɛ n yah, gbĩ́ nɛ̂-á à mɛ sènsóké séswɔ̂ sõ̀ sɔkɔ, képah kó à kɔ̃ à sɛ̃ pé yõ nɩ? Ǹtɛ ǹ yĩ́-á kɩ tɔ̃ n tɛ̃ n pi tyí-ǹgbnɔ yõ kɩ kal nɔ́pilɛ. ");
INSERT INTO wib_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Tɛ́ tɔ̃ ǹ syɩ yo pé tyɩ́ nɛ: «Kègbɩgbɩ tɛ̃̀ yõ, mé kélɛ n yo yé tyɩ́, yé kɩ yĩ̂nyõ wɛ yɩ́kɩ́nmɔnɔlɛ, tɛ́ yĩ̂nyõ tõ̀npɩbɩ kɩ mɛ n dɔkɔ, tɛ́ kɩ n tiki Névi Pídĩ́ yõ̀tah sɔkɔ.» ");
INSERT INTO wib_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Képah náh, ké sèpĩ̀n tɔ̃́-ò sõlɛ, fúr syáh yɔ́ sõ̀ mɛ n syah Kana kwil, Kalile gbɛ̃̀nyah sɔkɔ. Yesu yṹ sõ̀ mɛ ké sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Tɛ́ pè sõ̀ mɛ Yesu tɔ ye ké sɔkɔ, ànɛ̂ ǹ tõ̀ sã́hpúlɛ. ");
INSERT INTO wib_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Pǎh mɛ fúr syáh mɛ̀ sɔkɔ, dìvɛ̃ pɔ tɛkɩ. Kǎh pɩ sɛ̃́, Yesu yṹ mɛ yo ǹ tyɩ́ nɛ, dìvɛ̃-á mɛ tɛkɩ no tyɩ́ dɛ́! ");
INSERT INTO wib_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesu mɛ yo ǹ tyɩ́ nɛ, kwâh nɛ̂ se à n yah n kɔ̃ pé tyɩ́ nɩ? Pé gbĩ náh tɔ̃̌nɩ̀ sɛ. ");
INSERT INTO wib_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Képah sɔkɔ, ǹ yṹ mɛ yo dìvɛ̃ díbípú tyɩ́ nɛ, wàh kɩ fyɔ̀ pɔ tyi nónó yo pé tyɩ́, pè sé pól pɩ. ");
INSERT INTO wib_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Tɛ́ dyêh yã̀hnpní kénúkò sõ̀ mɛ Nsyifunɔ gblɔ̌y tɔ̃́nsàhnɔ́ yĩnnɛ à yɩ̃nɛ pé tyi kõ̀nsàhnɔ́lɛ. Sé núkú núkú pól sõ̀ mɛ lítírnɔ́ lèkwɛ̌kwɛ kénkɔ̃lɛ. ");
INSERT INTO wib_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Dǒ Yesu mɛ yo pé tyɩ́ nɛ, pè ni mɔ pní nɔ́pi yɩ̃́yɩ̃lɛ. Pè mɛ ni mɔ sé yɩ̃́yɩ̃lɛ. ");
INSERT INTO wib_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","À mɛ nɛ, núkúnúkú pè tãh kyɩ tyi yah wàh-ò dĩ́ kɔ̃. Pè mɛ tãh kyɩ à kɔ̃. ");
INSERT INTO wib_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Képah sɔkɔ, tyi yah wàh-ò dĩ́-á kè wɔ yah, kè sõ̀ mɛ vi mɔ pɩ dìvɛ̃nɛ, tɛ́ à náh sõ̀ mɛ kénɛ dìvɛ̃ wìl-ǹsah pɩ̃. Ǹtɛ dìvɛ̃ díbípú nónó-á sõ̀ di mɔ yɔlɛ, pépi wɔ sõ̀ ké wìl-ǹsah pɩ̃. Képah sɔkɔ, dĩ́ mɛ fúr pɩ́-ò dĩ́ ye, ");
INSERT INTO wib_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","tɛ́ yo ǹ tyɩ́ nɛ, no pól-á ńkɛ̃́nɛ dìvɛ̃ pènɛ̀kɩ̀ ǹgbò dibi. Névye-à wɔ kè syɔ̃ pé sɔkɔ gbĩ́ nɛ̂nɛ, nɛ̂-à mɛ nɔ́nyĩ́-ńkɛ̃̂nɛ, pè n pyě képah dibi. Ǹtɛ ǹmɔ pyě dìvɛ̃ pènɛ̀kɩ̀ tɛ̃̀ wɔ koh sah à pɔ nɔ yɩ̃̌nkɔ̃ gbĩ́ tyɩ́ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Képah ye pɩ Yesu gbǐl tyípɩ́nɩ́ gbennɛ, à ǹ tɔ̃́rɩ́ wɛ̃kɩ. Kǎh pɩ sɛ̃́, ǹ tõ̀ sã́hpú mɛ gbah sɛ̃ ǹ yõ. À gbǐl mɛ̀ pɩ Kana kwil, Kalile gbɛ̃̀nyah sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Képah náh, ǹmɔ ànɛ̂ ǹ yṹ, ànɛ̂ ǹ yṹnpyé, ànɛ̂ ǹ tõ̀ sã́hpú tiki yuku Kapɛrnayumi kwil sɔkɔ. Tɛ́ sèpĩ̀n kwéy ó ye pè pɩ nɛ́npɔ́. ");
INSERT INTO wib_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Tɛ́ Nsyifunɔ yɔ̃rɩ tyɛ́nɔ́ syáh-á sõ̀ mɛ de n tɛ sɛ̃́, Yesu mɛ dɔkɔ yuku Yerusalɛmɩ kwil sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Wǎh kyɩ Liyel ní-ńsah gbô sɔkɔ, à kyɩ nɛ n yah gbɔ̀yɩ̃bɩ mɛ gbɔ̀lɛ n yɩ̃ ké sɔkɔ. Túkù mɛ nyehlɛ n yãm, túkù mɛ képyɛ́nɩ̀nɛ n yãm, túkù mɛ kèpíkípíkínɔlɛ n yãm, tɛ́ túkù tɔ mó mɛ pɔ pé pɔ́ duke dukenɔ mɔ sah tàbǎlnɔ́ yõ, mɛ sélɛ n sah n tũ. ");
INSERT INTO wib_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Képah tɛ̃̀nɛ, Yesu mnɔ yísyɔ́ pɩ yèfõhlɛ, tɛ́ gbɔ̀yɩ̃bɩ nɔ́pi pól yĩni wilki kélɛ Liyel ní-ńsah gbô sɔkɔ, à tahlɩ pé képyɛ́nɩ̀ ànɛ̂ pé nyeh tyɩ́. Tɛ́ pɔ́ sàhntũ̀pu tàbǎlnɔ́ tu wilki mɔ, pé pɔ́nɔ́ kɔ̃ sè kwɛ. ");
INSERT INTO wib_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Képah sɔkɔ, tɛ́ yo kèpíkípíkínɔ yã̀mpu tyɩ́ nɛ, pè sè pól tɔkɔ n yal ásõ̂. Pè káh pé Sú Liyel gbôlɛ n pɩ gbɔ̀ yɩ̃́-ńsah gbôlɛ. ");
INSERT INTO wib_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Wǎh fyɔ̀ képah yo, ǹ tõ̀ sã́hpú dyɔ núkú to kõ Liyel wɛy sɛ́bɛ́y fɩ̃́ yɔ́ tyɩ́lɛ, ńyãh sɔkɔ-á kè mɛ wã́rkɩ́nsàhnɔ́lɛ nɛ ńkɛ̃́: «Liyel, á wɔ̀kɔ̀ tyɩ́ nɔ yĩ́ĩ́ ń tyɩ́, fɔ́ɔ́ ké tyɩ́ sõnɔ n pɩ ń ko ko tɛ̃̀nɛ.» ");
INSERT INTO wib_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Képah sɔkɔ, Nsyifunɔ yõ̀tãm Yesu syah nɛ, gbǐl tir nɛ̂ se à kɩ fɛ̃ pɩ, nɛ̂-á n wɛ̃kɩ nɛ, yĩ mɛ̀ pɩ́nɔ́ wɛ̃̀kɩ̀-á mɛ ǹ tyɩ́ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Képah tɛ̃̀nɛ, Yesu mɛ pè syah nɛ ńkɛ̃́, pè Liyel ní-ńsah gbô mɛ̀ sɔ, páh kɩ kè tɔ̃ mɔ sèpĩ̀n tɔ̃́nɩ̀ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Wǎh képah yo sɛ̃́, Nsyifunɔ yõ̀tãm à syah nɛ, è, gbô nɛ̂nɛ mɔ ye tikininí pɔ́ kénúkò sɔkɔ, ǹmɔ kɩ pɔ képah tɔ̃ mɔ sèpĩ̀n tɔ̃́nɩ̀ ó sɔkɔ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ǹtɛ Liyel ní-ńsah gbô nɛ̂ tyɩ́-á sõ̀ Yesu n yo, képah ye kɩ sõ̀ n pɩ n pi ǹ wil gbɛ̃́nsêlɛ. ");
INSERT INTO wib_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Képah náh, Yesu-á pɔ ku tɛ́ yilki mɔ gbĩ́ nɛ̂nɛ, ǹ tõ̀ sã́hpú dyɔ to kõ nɛ wǎh lésõ kè yo sah. Képah sɔkɔ, pè sɛ̃ Liyel wɛy sɛ́bɛ́y yõ sɔkɔ, tɛ́ sɛ̃ Yesu wɛlɔ yónsàhnɔ́ tɔ yõ. ");
INSERT INTO wib_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Tɛ́ Yesu-á sõ̀ mɛ Yerusalɛmɩ sɔkɔ, Nsyifunɔ yɔ̃rɩ tyɛ́nɔ́ syáh mɛ̀ syáh-ńsah, à sõ̀ mɛ gbǐl tyilɛ n pɩ névye mɛ n yah. Kǎh pɩ sɛ̃́, névye náhnáh sɛ̃ ǹ yõ. ");
INSERT INTO wib_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ǹtɛ Yesu sõ̀ mɛ pé pól fɔkɔ sõnɔlɛ n pnɛ. Képah ye, ǹmɔ tɛ̃̀ wɔ náh sõ̀ mɛ sɛ̃ pé yõ. ");
INSERT INTO wib_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","À névi nɩ kèdùkùlɛ n pnɛ. Képah ye, à pɔ névi kèdùkù tɛ̃̀ yo ǹ tyɩ́, ké yétõ̂ náh sõ̀ mɛ ǹ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Nsyifunɔ sɔkɔ, yɛ̃́ntɛ̃̂ yɔ́ lésõ mɛ pè n ye Nikodɛmɩnɛ. À sõ̀ mɛ Farisi wɛ̃̀kɩ̀ kɔ́pú sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Sõ yɔ́ lékã̂hnɛ, à kyɩ wil Yesu tyɩ́, tɛ́ yo ǹ tyɩ́ nɛ kwɔ́-ò dĩ́, gbǐl tyi nónó-á ǹmɔ n pɩ yɔ̀, ǹnɩ̂ yɔ́ ńtɛ̃ náh fɛ̃ sɛ̃́nknɔlɛ nɛ n pɩ n pi, nɛ́ Liyel náh mɛ tɛ̃̀nɛ. Képah-á, páh pɩ̃ nɛ ǹmɔ-á kwɔ́-òlɛ, nɛ̂-á Liyel tɛkɩ mɔ. ");
INSERT INTO wib_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesu mɛ yo ǹ tyɩ́ nɛ: «Kègbɩgbɩ tɛ̃̀ yõ, mé kélɛ n yo á tyɩ́, ǹnɩ̂ yɔ́ ńtɛ̃ náh fɛ̃ Liyel tɔ̃́rɩ́ wɛ n pi, nɛ́ tɛ̃̀ náh tɔ̃ dubi késã́nnɛ.» ");
INSERT INTO wib_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Képah sɔkɔ, Nikodɛmɩ nɛ, ǹtɛ névi wàhnmɔntɛnɔ náh, sɔ̃́ se képah kɩ fɛ̃ pɩ nɩ? À se kɩ fɛ̃ ǹ syɩ de ǹ yṹ fɔkɔ sɔkɔ, kɩ tɔ̃ dubi kɛ ní-òlɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesu mɛ tɔ̃ yo ǹ tyɩ́ nɛ: «Kègbɩgbɩ tɛ̃̀ yõ, mé kélɛ n yo á tyɩ́, ǹnɩ̂ yɔ́ ńtɛ̃ náh fɛ̃ n de n pi Liyel tɔ̃́rɩ́ sɔkɔ, nɛ́ tɛ̃̀ náh tɔ̃ dubi ni, ànɛ̂ Liyel Mirki gbõ̀ yõ. ");
INSERT INTO wib_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Névi nɛ̂-à dubi névi tyɩ́, névi ye tɛ̃̀nɛ. Tɛ́ névi nɛ̂-à dubi Liyel Mirki gbõ̀ yõ, Liyel Mirki n nɛ n mɛ tɛ̃̀ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Káh n yɛ kè á gbã̀n du, máh sɔ̃́npɩlɛ yo á tyɩ́ nɛ, yáh yɩ̃nɛ yé tɔ̃ n dubi késã́nnɛ. ");
INSERT INTO wib_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ńyãh-à yã́hkɩ́ dyɔ, nɛ́npɔ́ ye kè n nɛ n pɩ n yuku. Á kɩ ké pɩ́nɔ́ yĩ́nɛ n nohnɩ, tɛ́ á náh n pɩ̃ n pi ńyãh sɔkɔ-á kè wil, ànɛ̂ kǎh n yuku ńyãh. Névi nɛ̂-à dubi Liyel Mirki gbõ̀ yõ, tɛ̃̀ tɔ tyɩ́ n nɛ n mɛ sɛ̃́ntɛ̃̀nɛ.» ");
INSERT INTO wib_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Wǎh yo sɛ̃́, Nikodɛmɩ tɔ̃ nɛ, sɔ̃́ se képah kɩ fɛ̃ pɩ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesu mɛ yo ǹ tyɩ́ nɛ: «Áwɔlɛ tyi kõ̀nsàhnɔ́ kwɔ́-ò ǹgbɛ̃nɛ Yisrayel sɔkɔ, tɛ́ á náh képahlɛ n pnɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Kègbɩgbɩ tɛ̃̀ yõ, mé kélɛ n yo á tyɩ́ nɛ, áyáh nɛ̂nɛ n pnɛ, képah tyɩ́-á à n nɛ n yo. Áyáh nɛ̂ wɛ, à n pɩ képah tyɩ́ yónwàhpulɛ. Ǹtɛ yé náh mɛ sélɛ n fɛ̃ n syi. ");
INSERT INTO wib_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Mâh sétáh yõ tyilɛ n yo yé tyɩ́ tɛ́ yé náh mɛ sɛ̃ sé yõ, mâh pɔ yĩ̂nyõ tyilɛ n yo yé tyɩ́, yé kɩ pyě fɛ̃ sɛ̃ sépi yõ sɔ̃́? ");
INSERT INTO wib_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ǹnɩ̂ yɔ́ ńtɛ̃ náh dɔkɔ kyɩ yah yĩ̂nyõ sɔkɔ, à wil Névi Pídĩ́ tyɩ́ sɔkɔ, ǹmɔ nɛ̂-á wil yĩ̂nyõ à tiki pɔ. ");
INSERT INTO wib_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Sɔ̃́-á lésõ Moyisi wahy kètɔ̀ pɩ yésãhrɩlɛ gbɛ̃́nnɩ sɔkɔ, à dɔkɔ mɔ sah dahnɩ yõ, Névi Pídĩ́ tɔ yɩ̃nɛ à dɔkɔ mɔ sɛ̃́ntɛ̃̀nɛ. ");
INSERT INTO wib_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Képah sɔkɔ, névi nɛ̂-à sɛ̃ ǹ yõ, tɛ̃̀ kɩ tyɛ́-ńkɛ̃̂ min wɛ. ");
INSERT INTO wib_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Yah, kèkõyṍ névye tyɩ́ ye kah nɔ Liyel tyɩ́, képah ye à ǹ Pi núkúní tɛkɩ mɔ, nɛ névi nɛ̂-à sɛ̃ ǹmɔ yõ, tɛ̃̀ tyɩ́ káh yɩkɩ, ǹtɛ tɛ̃̀ tyɛ́-ńkɛ̃̂ min wɛ. ");
INSERT INTO wib_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Liyel tɛ̃̀ wɔ náh ǹ Pídĩ́ tɛkɩ mɔ kèkõyṍ sɔkɔ nɛ, à pɔ lékàhlɛ névye kɔ̃ pé tyípêl yĩnnɛ dɛ́! À ye à tɛkɩ mɔ nɛ, kèkõyṍ névye pwáhnmɔnɔ wɛ ǹmɔ gbõ̀ yõ. ");
INSERT INTO wib_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Névi nɛ̂-à sɛ̃ ǹmɔ yõ, tɛ̃̀ wɔ náh tɔ̃ n tuke n pi. Ǹtɛ nɛ̂-à yahle sɛ̃́nɔ́lɛ ǹmɔ yõ, tukey syɩkɩ tɛ tɛ̃̀ yõ, wǎh sɔ̃́npɩ́ yahle sɛ̃́nɔ́lɛ Liyel Pi núkúní yõ. ");
INSERT INTO wib_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Tukey mɛ̀ wɛ yɔ̀: Kyòo ye pɔ kèkõyṍ, tɛ́ névye tyípɩ́nɔ́-á pɩ tyítúkúnìnɛ sɛ̃́, fɛ̃́ntũ̂ tyɩ́ nɔ kal pé tyɩ́ kyòolɛ. ");
INSERT INTO wib_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Névi nɛ̂-à tyítúkúnìnɛ n pɩ, kyòo tyɩ́ náh n nɔ tɛ̃̀ tyɩ́ gbógbó. Tɛ̃̀ n pɩ̃ nɛ páh kɩ pɔ kyòo yah, pé tyítúkúnì pɩ́nɔ́-á kɩ wil mɔ kwèyy. Képah ye, à náh n pɔ kyòo yah sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ǹtɛ névi nɛ̂-à gbɩ wɛ̃̀kɩ̀lɛ n kɔ, ǹmɔ n pɔ kyòo yah sɔkɔ. À n nɛ n mɛ ké tyɩ́ nɛ, no pé tyípɩ́nɔ́ wɛ pnɛ́yy sépi nónó-á mɛ n pɩ Liyel dyɔ dyɔ tɛ̃̀nɛ.» ");
INSERT INTO wib_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Képah náh, Yesu ànɛ̂ ǹ tõ̀ sã́hpú pɔ tɛ̃ yah Nsyude gbɛ̃̀nyah sɔkɔ. À sõ̀ mɛ névyelɛ n wel n wilki ni sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Tɛ́ ni-á sõ̀ mɛ dò Yɛno kwil sɔkɔ sɛ̃́, képah ye Nsyɔ̃ tɔ mó mɛ wèlwìlkìnɔ́lɛ n pɩ nɛ́npɔ́. Névye sõ̀ mɛ n pɔ n pɔ ǹ tyɩ́, à kɔ̃ à pélɛ n wel n wilki ni sɔkɔ. Nɛ́npɔ́ sõ̀ mɛ yúkɛy Salimi kwillɛ. ");
INSERT INTO wib_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Légbĩ́nɛ, pè náh sõ̀ tɔ̃̌nɩ̀ Nsyɔ̃ dah mɔ wɔ̀kɔ̀npèkè sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Képah sɔkɔ sõ yɔ́lɛ, yékã̂b yɔ́ de Nsyɔ̃ tõ̀ sã́hpú ànɛ̂ Nsyifu yɔ́ wrɔ́, pé gblɔ̌y tɔ̃ n sah dùkù tyɩ́ yõ, à yɩ̃nɛ pé tyi kõ̀nsàhnɔ́lɛ. ");
INSERT INTO wib_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Kǎh pɩ sɛ̃́, Nsyɔ̃ tõ̀ sã́hpú mɛ Nsyɔ̃ nyáh sõ kyɩ yo ǹ tyɩ́ nɛ ńkɛ̃́, pé kwɔ́-ò dĩ́, dĩ́ nɛ̂-á lésõ ǹnɛ Nsyurdɛ̃ yɔ́nkahnɩnɛ, tɛ́ à ǹ tyɩ́lɛ n yo pé tyɩ́ kɛ̀; à yah, ǹ tɔ-á mɛ yuku névyelɛ n wel n wilki ni sɔkɔ. Tɛ́ no pól-á mɛ pé yah mɔ ǹmɔ tĩ̀nnɛ. ");
INSERT INTO wib_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ǹtɛ Nsyɔ̃ mɛ yo pé tyɩ́ nɛ ńkɛ̃́: «Nɛ́ Liyel náh yĩ́n-ńsah nɛ̂nɛ névi kɔ̃, tɛ̃̀ se kɩ fɛ̃ kè wɛ? ");
INSERT INTO wib_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Yépi ńtɛ̃ ye ńmɔ tàrfyɔ̀lɛ nɛ máh lésõ kè yo dal mɔ yé tyɩ́ nɛ ńmɔ náh Liyel nɛy yáhntɔkɔnɔlɛ. Ǹ tɛ̃ntõ̀ ó-á mé pɔ pɩ́-ńsah ǹ yahlɛ. ");
INSERT INTO wib_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Yé yah, nɛ̂ tyɩ́-á sépíllɛ, ǹ pɛ ye. Tɛ́ pɛ mɛ̀ kódĩ́ n mó nɛ n mɛ pɛ mɛ̀ tnɔ̂. Kódĩ́ mɛ̀-à pɛ mɛ̀ wɛ nɩ̀vɩ̀nɩ̀ sɔkɔ, kè n pɩ nɩ̀vɩ̀nɩ̀ ǹgbɛ̃nɛ ǹ tyɩ́. Sɛ̃́nkɔ̃ nɩ̀vɩ̀nɩ̀ ye ńmɔ sɔkɔ. Ń nɩ mɛ vɩ syɩ ké yĩ̀n tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Wãn yɩ̃nɛ kè nɛ n mɔ ǹmɔ yĩn wìlnɔ́ yõ, kwâh mó nɛ n wilki ńmɔ tyɩ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Névi nɛ̂-á n wil yĩ̂nyõ, ǹmɔ ye no pól yõ. Tɛ́ névi nɛ̂-á mɛ sétáh mɛ̀ yõ, sétáh mɛ̀ névi ye ǹnɛ. Sétáh mɛ̀ yõ tyi ó ye ǹmɔ kɩ fɛ̃ n yãh dò. Ǹtɛ, nɛ̂-á n wil yĩ̂nyõ, ǹmɔ mɛ no pól yõ. ");
INSERT INTO wib_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Wǎh tyi nónó wɛ, tɛ́ tyi nónó noh, sépi tyɩ́ ye à n yo n wah, tɛ́ nɛy náh mɛ ǹ wɛy fɛ̃ syi. ");
INSERT INTO wib_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ǹtɛ nɛ̂-à ǹ wɛy fɛ̃ syi, tɛ̃̀ mɛ kélɛ n wɛ̃kɩ tɔ́tɔ́ nɛ gbɩ-á Liyel wɛynɛ. ");
INSERT INTO wib_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ǹmɔ nɛ̂-á Liyel tɛkɩ mɔ, à ǹ Mirkilɛ à kɔ̃ yĩ́ĩ́. Liyel wɛy ye à n nɛ n yo. ");
INSERT INTO wib_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Sú Liyellɛ, ǹ Pídĩ́ tyɩ́ nɔ ǹ tyɩ́. Képah ye à tyi pól dahbɩ ǹmɔ gbõ̀. ");
INSERT INTO wib_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Névi nɛ̂-à sɛ̃ Liyel Pídĩ́ yõ, tɛ̃̀ kɩ tyɛ́-ńkɛ̃̂ min wɛ. Tɛ́ névi nɛ̂-à yahle sɛ̃́nɔ́lɛ ǹ yõ, tɛ̃̀ náh kénɛ min wɛ n pi. Liyel pèkè kɩ mɛ tɛ̃̀ yõ gbĩ́mɛgbĩ́.» ");
INSERT INTO wib_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Képah sɔkɔ, Farisi wɛ̃̀kɩ̀ kɔ́pú sõ̀ noh nɛ Yesu-á mɛ tõ̀ sã́hpúlɛ n wɛ, mɛ pélɛ n wel n wilki ni sɔkɔ à kal Nsyɔ̃nɛ. Tɛ́ Yesu ńtɛ̃ náh sõ̀ n wel n wilki névyelɛ ni sɔkɔ ǹ gblɔ̌y dɛ́, ǹ tõ̀ sã́hpú ye sõ̀ n pɩ ké tõ̀lɛ. Képah sɔkɔ, Yesu-á pɔ képah yónɔ́ noh gbĩ́ nɛ̂nɛ, à yal Nsyude gbɛ̃̀nyah sɔkɔ ànɛ̂ ǹ tõ̀ sã́hpúlɛ, à ǹ syɩ n yuku Kalile gbɛ̃̀nyah sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Tɛ́ képah wɔ sɔkɔ, à sõ̀ yɩ̃nɛ à Samari gbɛ̃̀nyah kɔ kah. ");
INSERT INTO wib_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Wǎh n yuku, à kyɩ yĩni tɛ̃ Samari kwil yɔ́ sɔkɔ, pè n ye Sikarlɛ. Kénɛ kwil mɛ Nsyosɛfu swãh tnɔ̂, nɛ̂-á lésõ ǹ sú Nsyakɔbɩ à kɔ̃. ");
INSERT INTO wib_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Tɛ́ Nsyakɔbɩ kwlɛ̀y sõ̀ mɛ nɛ́npɔ́. Yesu-á wil kɔ́lɔ́ sɔkɔ tɛ́ kwlɔ, à sõ̀ mɛ kyɩ kɔ̃ tɛ̃ kénɛ kwlɛ̀y yõ. Tɛ́ gbĩ sõ̀ mɛ yõ̀tah sírr kénkɔ̃ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Képah sɔkɔ, Samari pi yɔ́-á pɔ yɔ dí-ńsah, Yesu mɛ à syah nɛ à ninɛ pé kɔ̃ pé wɔ. ");
INSERT INTO wib_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Tɛ́ légbĩ́nɛ, Yesu tõ̀ sã́hpú sõ̀ mɛ sɔkɔ yõke yáhndwe-ńsah kwil nɩyṍ. ");
INSERT INTO wib_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Képah sɔkɔ, Samari pi mɛ à syah nɛ, kè se pɩ sɔ̃́ tɛ́ ǹmɔ nɛ̂-á Nsyifulɛ, à kɩ pɔ wɔ wɔ ninɛ n ni péwɔ Samari nɛy tyɩ́ nɩ? Kègbɩ tɛ̃̀ yõ Nsyifunɔ náh ńtyɩ̃́nɔ sõ̀ n pɩ n soh wɛ̃ tyɩ́ ànɛ̂ Samari tãnnɛ. ");
INSERT INTO wib_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Wǎh yo sɛ̃́, Yesu mɛ yo ǹ tyɩ́ nɛ: «Liyel-á nɛ̂nɛ névilɛ n kɔ̃, wâh sõ̀ mɛ kélɛ n pnɛ, tɛ́ pɩ̃ nɛ́dúkú nɛ̂-á n yo n mɔ á tyɩ́ yɔ̀, áwɔ ye náhkɩ sõ̀ ni wɔ wɔ ninɛ ǹ tyɩ́, tɛ́ à náhkɩ ninɛ ǹ kɔ̃ nɛ̂-á minnɛ névilɛ n kɔ̃.» ");
INSERT INTO wib_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Képah sɔkɔ, pi nɛ pé yõ̀tɛ̃̀, kwlɛ̀ndìkì náh mɛ ǹmɔ tyɩ́, tɛ́ kwlɛ̀y-á mó tɔ̃ mɛ súkúlínɔ́lɛ, à se náhkɩ sõ̀ wɛ ńyãh kénɛ ninɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ńkɛ̃́ pépi náh nɛy Nsyakɔbɩ nɛ̂-á pé kɔ̃ kwlɛ̀y mɛ̀nɛ, tɛ́ ké ni wɔ sɔkɔ ànɛ̂ ǹ wɛ̃́npìlɛ, à tahlɩ ǹ yípɛ̂y tyɩ́, ǹmɔ se kal Nsyakɔbɩ mɛ̀nɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesu mɛ nɛ: «Névi nɛ̂-à kwlɛ̀y mɛ̀ ni wɔ, níkì kɩ tɔ̃ pɔ tɛ̃̀ tɛ̃. ");
INSERT INTO wib_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ǹtɛ ńmɔ-à ninɛ névi nɛ̂ kɔ̃, tɛ̃̀-à kè wɔ, níkì náh tɔ̃ tɛ̃̀ tɛ̃ n yah n pi póllɛ. Kè kɩ n pɔ n mɔ lègbèr tyɩ́ kɔ̃lɛ tɛ̃̀ sɔkɔ, kɩ tyɛ́-ńkɛ̃̂ minnɛ n kɔ̃.» ");
INSERT INTO wib_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Képah sɔkɔ, pi à syah nɛ pé yõ̀tɛ̃̀, à pé kɔ̃ kénɛ ninɛ, níkì kɔ̃ kè káh tɔ̃ pélɛ n tɛ̃, ànɛ̂ pé káh tɔ̃ pɔ ásõ̂ yɔ tɛ̃̀ di yĩnnɛ. ");
INSERT INTO wib_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Wǎh yo sɛ̃́, Yesu mɛ nɛ, à kyɩ ǹ pɛ ye pè pɔ ásõ̂. ");
INSERT INTO wib_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Képah sɔkɔ, pi nɛ pɛ náh mɛ pé tyɩ́. Yesu mɛ nɛ, gbɩ-á à yo nɛ pɛ náh mɛ pé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Pɛbɩ nɛ́pĩ̂ kwâl tyɩ́-á à tɛ̃ yah sɔkɔ, tɛ́ nɛ̂ tyɩ́-á tɔ̃ ǹnɛ núkúnúkú yɔ̀, gbɩ-á à yo, ǹ pɛ náh ǹnɛ. ");
INSERT INTO wib_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Képah tɛ̃̀nɛ, pi mɛ yo Yesu tyɩ́ nɛ pé yõ̀tɛ̃̀, páh kè kyɔmɩ wɛ nɛ, Liyel tɛ̃ntõ̀ syínyo-ò-á ǹnɛ. ");
INSERT INTO wib_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ńkɛ̃́ pépi náh tãn-á Liyellɛ n gbilki ńyãh sɔkɔ, nɛ́npɔ́-á mɛ yɔ̃lɩ mɛ̀ yõ yàhàh. Ǹtɛ pépi Nsyifunɔ wɔlɛ, pépi n nɛ n yo nɛ, Liyel-á yɩ̃nɛ à nɛ n gbilki ńyãh sɔkɔ, nɛ́npɔ́-á mɛ Yerusalɛmɩ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Képah sɔkɔ, Yesu mɛ yo pi tyɩ́ nɛ: «Sɛ̃ ń yõ. Sõ yɔ́ mɛ n pi, nɛy náh tɔ̃ pɔ Sú Liyel gbilki n pi yɔ̃lɩ mɛ̀ yõ, képah náh pɩ, Yerusalɛmɩ ńtɛ̃ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Yépi Samari tãnnɛ, yě Liyellɛ n gbilki tɛ́ yé náh ǹnɛ n pnɛ. Ǹtɛ ápi Nsyifunɔ tyɩ́ ye Liyel syɔ̃ à pwáhnmɔnɔlɛ n kɔ̃. Képah ye á ǹnɛ n pnɛ, tɛ́ ǹnɛ gbilki. ");
INSERT INTO wib_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ǹtɛ gbĩ yɔ́ mɛ n pi, nɛ̂-á mɛ tɛ núkúnúkú ńtɛ̃nɛ yɔ̀. Képah sɔkɔ ye Sú Liyel gbílkípú kègblɔ kɩ ǹnɛ n gbilki ǹ Mirki gbõ̀ yõ sɔkɔ ànɛ̂ gbɩ wɛ̃̀kɩ̀ yõ. Gbílkínɔ́ mɛ̀ dùkù pɩ́pú névye ye Sú Liyel n nɛ n yah n kɔ̃. ");
INSERT INTO wib_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Liyellɛ, Mirki ye ǹnɛ. Képah ye, nónó-á ǹnɛ n gbilki, pè yɩ̃nɛ pè ǹnɛ n gbilki ǹ Mirki gbõ̀ yõ, ànɛ̂ gbɩ wɛ̃̀kɩ̀ yõ.» ");
INSERT INTO wib_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Képah sɔkɔ, pi à syah nɛ, páh pɩ̃ nɛ Liyel nɛy yáhntɔkɔnɔ-á kɩ n pɔ n pi, nɛ̂-á pè n ye Kristalɛ. Ǹmɔ-à pɔ gbĩ́ nɛ̂nɛ, wǎh kɩ pɔ tyi pól dùkù yo wah pé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesu mɛ nɛ: «Ǹmɔ ye ńmɔlɛ, nɛ̂-á n yo n mɔ á tyɩ́ yɔ̀.» ");
INSERT INTO wib_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Wǎh mɛ képah yónɔ́ sɔkɔ, ǹ tõ̀ sã́hpú mɛ pé syɩ pɔ de. Tɛ́ pǎh pɔ à wɛ à mɛ n yãh ànɛ̂ pilɛ sɛ̃́, kè pé gbã̀n du. Ǹtɛ pé sɔkɔ yɔ́ ńtɛ̃ náh fɛ̃ syi à piki yah nɛ, kwâh nɛ̂ se à n yah n kɔ̃ pi mɛ̀ tyɩ́, képah náh pɩ, tir nɛ̂ se à n yo ǹ tyɩ́ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Képah tɛ̃̀nɛ, pi ǹ ni pĩ́n sah nɛ́npɔ́, tɛ́ to kyɩ kwil nɩyṍ, à kyɩ tyah n yo no tyɩ́ nɛ, ");
INSERT INTO wib_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","pè pɔ nɛ n yah dĩ́ yɔ́lɛ, à péwɔ tyípɩ́nɩ̀ pól yo pé tyɩ́ lɛ́! Ǹmɔ káh kɩ nɛ̂ Liyel nɛy yáhntɔkɔnɔlɛ dɛ́? ");
INSERT INTO wib_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Képah sɔkɔ, névye mɛ wil kwil nɩyṍ mɛ n yuku Yesu tnɔ̂. ");
INSERT INTO wib_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Tɛ́ légbĩ́nɛ, Yesu tõ̀ sã́hpú sõ̀ mɛ Yesulɛ n ni nɛ, kwɔ́-ò dĩ́, à yõke yõ kɛ̀! ");
INSERT INTO wib_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ǹtɛ Yesu mɛ pè syah nɛ, yõke yɔ́-á mɛ péwɔ tyɩ́ yõ yõ tɛ̃̀nɛ, nɛ̂-à pépi náh kélɛ n pnɛ. ");
INSERT INTO wib_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Képah sɔkɔ, ǹ tõ̀ sã́hpú sõ̀ mɛ wɛ̃nɛ n piki n yah nɛ, ǹnɩ̂ se kɩ mɛ pɔ yõkelɛ à kɔ̃ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","À mɛ yo pé tyɩ́ nɛ: «Liyel nɛ̂-á tɛkɩ mɔ ńmɔlɛ, wǎh mɛ nɛ̂ tyɩ́, képah pɩ́nɔ́ ànɛ̂ ǹ tõ̀ pɩ́ntɛnɔ ye pɩ ńmɔ yõkelɛ. ");
INSERT INTO wib_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Yépi náh ńkɛ̃́nɛ nɛ n yo nɛ, ńwɔ̃́lɔ́ ńyã́h-á tɔ̃ wũ tɛ́ sèmukɔ tɔkɔ gbĩ́ kɩ nɔ di? Ǹtɛ ńmɔ wɔ kɩ yo yé tyɩ́ nɛ, yé yé yey yɔ̃ n yah sèmukɔlɛ kòntɛ̃̀nɔ́lɛ swãh sɔkɔ, tɔkɔ tɔkɔ tɛ̃̀nɛ. ");
INSERT INTO wib_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Névi nɛ̂-à mɛ sèmukɔlɛ n tɔkɔ, ǹ tõ̀ pɩ́nɔ́ lédyáhnɩ́ mɛ tɛ ǹ tyɩ́; sèmukɔ pɔ́rɩ́ nɛ̂-á à n tuke n mɔ, névye ye nónó-á kɩ tyɛ́-ńkɛ̃̂ min wɛ n pi. Képah sɔkɔ, névi nɛ̂-á mɔ sélɛ, ànɛ̂ névi nɛ̂-á sè tɔkɔ, pé pól kɩ nɩ̀vɩ̀nɩ̀ pɩ wɛ̃ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Képah n wɛ̃kɩ nɛ, gbɩ-á sèmìrkì mɛ̀nɛ, nɛ̂-á n yo nɛ ńkɛ̃́: ‹Ǹnɩ̂ kɩ sèmukɔ mɔ, tɛ́ ǹnɩ̂ kɩ sè tɔkɔ.› ");
INSERT INTO wib_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Yépi náh swãh nɛ̂ tõ, ńmɔ yé tɛkɩ mɔ nɛ, yé kyɩ képah sèmukɔ tɔkɔ. Nósyɔ́ ye tõ̀ pɩ ké sɔkɔ, yépi kɔ̃ yé pɔ wɛ de pé tõ̀ pɩ́nɔ́ yén sõ̀.» ");
INSERT INTO wib_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Tɛ́ pi mɛ̀-á sõ̀ wɛy nɛ̂ yo nɛ, dĩ́ mɛ̀-á péwɔ tyípɩ́nɩ̀ pól yo pé tyɩ́, képah yĩnnɛ Samari tãn náhnáh sõ̀ sɛ̃ Yesu yõ kwil mɛ̀ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Képah ye Samari tãn nɔ́pi-á kyɩ Yesu tyɩ́, pè à ni nɛ à wũ pé tyɩ́. Yesu mɛ wũ nɛ́npɔ́ à sèpĩ̀n nínì pɩ. ");
INSERT INTO wib_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Képah tɛ̃̀nɛ, névye náhnáh tɔ̃ sɛ̃ Yesu yõ wǎh wɛlɔ nónó yo pè noh sépi yĩnnɛ. ");
INSERT INTO wib_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Tɛ́ mɛ tyah n yo pi mɛ̀ tyɩ́ nɛ, ǹmɔ yóré ó yĩn náh tɔ̃ pépi sɛ̃ Yesu yõ dɛ́! Ńkɛ̃́ pépi ńtɛ̃ tɔ-á ǹ wɛy wɛ noh níkílɛ, tɛ́ pɩ̃ nɛ kègbɩ tɛ̃̀ yõ, ǹmɔ-á ńtyɩ̃́nɔ kèkõyṍ pwáhnmɔ-òlɛ. ");
INSERT INTO wib_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Yesu-á sèpĩ̀n nínì nɔ́pi pɩ tɛ, à yal nɛ́npɔ́ à yuku Kalile gbɛ̃̀nyah sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Tɛ́ à mó tɔ̃ lésõ kè yo nɛ, Liyel tɛ̃ntõ̀ syínyo-ò náh n tɛ̃ plɛ ǹ sú kwil sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ǹtɛ Kalile tãn tɔ-á lésõ kyɩ Nsyifunɔ yɔ̃rɩ tyɛ́nɔ́ syáh sɔkɔ Yerusalɛmɩ sɔkɔ, tɛ́ Yesu tyípɩ́nɔ́ wɛ sɛ̃́, képah ye wǎh pɔ pɔ pé gbɛ̃̀nyah sɔkɔ, pè mɛ à tɔ̃ sah tɛ̃. ");
INSERT INTO wib_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Képah sɔkɔ, Yesu sɔkɔ kénɛ gbɛ̃̀nyah kwil mɛ̀ sɔkɔ, nɛ̂-á pè n ye Kanalɛ. Nɛ́npɔ́ sɔkɔ ye lésõ à ni vi mɔ pɩ dìvɛ̃nɛ. Tɛ́ nɛ́-ǹgbɛ̃ yɔ́ lésõ mɛ yõ̀tɛ̃̀ dĩ́ yɔ́ tyɩ́ Kapɛrnayumi kwil sɔkɔ. Ǹ pídĩ́ náh lésõ mɛ lènɔlɛ. ");
INSERT INTO wib_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Wǎh pɔ noh nɛ, Yesu-á mɛ wil Nsyude gbɛ̃̀nyah sɔkɔ à pɔ Kalile sɔkɔ, à mɛ ǹ nyáh sõ kyɩ à ni nɛ, à tiki pɔ Kapɛrnayumi sɔkɔ, à pɔ pé pídĩ́ dɛ mɔ pé kɔ̃; wǎh mɛ n tyah kúnɔ́lɛ. ");
INSERT INTO wib_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesu mɛ yo ǹ tyɩ́ nɛ, pè se yɔ́ kɩ fɛ̃ sɛ̃ yah péwɔ yõ; nɛ́ gbǐl ànɛ̂ gbɛ̃̀ndùnì tyi náh pɩ pè wɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ǹtɛ dĩ́ mɛ tɔ̃ yo ǹ tyɩ́ nɛ, pé yõ̀tɛ̃̀, à tiki pɔ súú péwɔ tĩ̀nnɛ pé dípír káh pɔ ku. ");
INSERT INTO wib_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Képah sɔkɔ, Yesu mɛ yo ǹ tyɩ́ nɛ, à ǹ syɩ sɔkɔ ǹ tĩ̀nnɛ, ǹ pídĩ́-á dɛ. Dĩ́ mɛ sɛ̃ ǹ wɛy mɛ̀ yõ, tɛ́ ǹ syɩ. ");
INSERT INTO wib_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Wǎh mɛ wɛ̃̀kɩ̀ yõ, ǹ tõ̀npɩbɩ pɔ à yohnɩ, tɛ́ yo ǹ tyɩ́ nɛ, ǹ pídĩ́-á dɛ. ");
INSERT INTO wib_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","À mɛ pè piki yah nɛ, gbĩ́ nɛ̂ se fàhfàh de ǹ tyɩ́ nɩ? Pè mɛ yo ǹ tyɩ́ nɛ, ńnɩ́nɩ́ gbĩ̀ntɔ̃̀ pɔ̃́ sɔkɔ-á wílvyã́hnɩ̀ à fĩn mɔ. ");
INSERT INTO wib_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Képah sɔkɔ, dípír sú kè kyɔmɩ wɛ nɛ légbĩ́ mɛ̀-ó sɔkɔ-á Yesu yo pé tyɩ́ nɛ, pé nɛ n yuku, pé pídĩ́-á dɛ. À tɔkɔ légbĩ́ tyɩ́, ǹmɔ ànɛ̂ ǹ gbô tãn pól sɛ̃ Yesu yõ. ");
INSERT INTO wib_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Tɛ́ Yesu-á wil Nsyude gbɛ̃̀nyah sɔkɔ, à pɔ Kalile gbɛ̃̀nyah sɔkɔ, képah ye à pɩ gbǐl ní-òlɛ. ");
INSERT INTO wib_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Tyi nɔ́pi sɔ́kɔ́ntɛnɔ náh, Nsyifunɔ syáh yɔ́-á pɔ n syah Yerusalɛmɩ kwil sɔkɔ, Yesu dɔkɔ yuku nɛ́npɔ́. ");
INSERT INTO wib_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Tɛ́ Yerusalɛmɩ kwil sɔkɔ, pɛ́kɩ̀ yɔ́ sõ̀ mɛ tũ̀nsàhnɔ́lɛ ninɛ ké sɔkɔ ké kwil dé-ńsah yɔ́ tnɔ̂, nɛ̂-á pè n ye Képyɛ́nɩ̀ dé-ńsahlɛ. Pè kénɛ pɛ́kɩ̀lɛ n ye Bɛtɩsatalɛ Yebre wɛy sɔkɔ. Kènkã̀lnɔ́ kwlɔ́ sõ̀ mɛ pɩ́nɔ́lɛ ké gbɔ̀pɔ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Yámpú náhnáh sõ̀ mɛ sɛ̃́ntɛ̃̀nɔ́lɛ kènkã̀l nɔ́pi sõ̀. Yɩ̃́tũbi sõ̀ mɛ, ànɛ̂ gbáhkɩ̀ núkú névyelɛ, à tahlɩ sèkukubi tyɩ́. Pè sõ̀ ńkɛ̃́nɛ nɛ mɛ ni dúkúrínmɔnɔ syɩkɩ n tɛ̃. ");
INSERT INTO wib_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Yé náh wɛ di, yĩ̂nyõ tõ̀npɩ yɔ́ sõ̀ ńkɛ̃́nɛ nɛ n de n pɔ ni mɛ̀ sɔkɔ, ǹ kélɛ n dukuri n mɔ, tɛ́ yɔ́nwó nɛ̂ ǹgbò-à de ni mɛ̀ sɔkɔ, ǹ yam-à sɔ̃́ mɛ dùkù nɛ̂nɛ, à n dɛ. ");
INSERT INTO wib_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Tɛ́ nɛ́npɔ́ sɔkɔ, dĩ́ yɔ́ lésõ mɛ sèkùkùlɛ pópó ye yõgbãm pɔ́ kwǎrtɔ̃nɔ. ");
INSERT INTO wib_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesu-á à wɛ sɛ̃́, tɛ́ pɩ̃ nɛ ǹ sɛ̃́ntɛ̃̀nɔ́ di-á mo nɛ́npɔ́, à à piki yah nɛ, à se mɛ ké tyɩ́ nɛ pé dɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Sèkùkù dĩ́ mɛ nɛ, pé yõ̀tɛ̃̀, ni-à tyah n dukuri n mɔ gbĩ́ nɛ̂nɛ, nɛy náh n wɛ à pélɛ n yohnɩ n mɔ pé n wɛ n de ké sɔkɔ. Péwɔ tɛ̃̀-à pópó nɛ pé wɛ n de, ǹnɩ̂ pé dyàh tɛ̃ n de. ");
INSERT INTO wib_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Wǎh yo sɛ̃́, Yesu mɛ yo ǹ tyɩ́ nɛ, à yuku ǹ sɛ̃ sɛ̃ kwâh tɔkɔ nɛ n kɔ. ");
INSERT INTO wib_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Nɛ́npɔ́ swɔ, dĩ́ núkú dɛ. À mɛ yuku ǹ sɛ̃ sɛ̃ kwâh tɔkɔ à n kɔ. Tɛ́ lésõ pɔ yɩ̃nɛ Nsyifunɔ mɩ mɩ yòhlɛ. ");
INSERT INTO wib_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Képah sɔkɔ, dĩ́ nɛ̂-á dɛ́nmɔnɔ wɛ, Nsyifunɔ yõ̀tãm à syah nɛ ńkɛ̃́, mɩ mɩ yòh-á kwɛynɛ. À náh yɩ̃nɛ à ǹ sɛ̃ sɛ̃ kwâh tɔkɔ nɛ n kɔ. ");
INSERT INTO wib_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ǹtɛ dĩ́ mɛ pè syah nɛ, nɛ̂-á dɛ mɔ pélɛ, ǹmɔ-á yo pé tyɩ́ nɛ, pé pé sɛ̃ sɛ̃ kwâh tɔkɔ nɛ n kɔ. ");
INSERT INTO wib_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Pè mɛ à piki yah nɛ, nɛ̂ se yo ǹ tyɩ́ nɛ, à ǹ sɛ̃ sɛ̃ kwâh tɔkɔ nɛ n kɔ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Légbĩ́nɛ, Yesu mó tɔ̃ sõ̀ yal tɛ dĩ́ mɛ̀ tnɔ̂, à de tɔ́wû sɔkɔ nɛ́npɔ́. Tɛ́ dĩ́ nɛ̂-á sõ̀ Yesu dɛ mɔ, kénɛ dĩ́ náh sõ̀ ǹnɛ n pnɛ. ");
INSERT INTO wib_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Képah náh, Yesu pɔ à wɛ Liyel ní-ńsah gbô sɔkɔ tɛ́ nɛ, à yah, wǎh dɛ́nmɔnɔ wɛ yɔ̀, à káh tɔ̃ tyípêllɛ n pɩ, tir yɔ́ kɔ̃ kè pɔ à nɔ nɛ̂-á kal ńyɔlɛ dɛ́! ");
INSERT INTO wib_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Képah tɛ̃̀nɛ, dĩ́ kyɩ ké yah yo Nsyifunɔ yõ̀tãm syah nɛ, Yesu-á sõ̀ dɛ mɔ pélɛ. ");
INSERT INTO wib_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Képah sɔkɔ, Nsyifunɔ yõ̀tãm tyah lékàhlɛ Yesulɛ n kɔ̃, wǎh sɔ̃́npɩ́lɛ dɛ́nmɔnɔ pɩ mɩ mɩ yòh sõlɛ. ");
INSERT INTO wib_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yesu mɛ nɛ, péwɔ Sú Liyel-á mɛ tõ̀ sɔkɔ kṹmm, péwɔ tɔ́-á mɛ sɛ̃́ntɛ̃̀nɛ n pɩ. ");
INSERT INTO wib_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Yesu-á képah yo sɛ̃́, Nsyifunɔ yõ̀tãm tɔ̃ lékàhlɛ ǹnɛ n gbah n kɔ̃, à ǹ kònmɔ-ńsahlɛ n yah n kɔ̃, tɛ́ nɛ wǎh mɛ mɩ mɩ yòh dêllɛ n pɩ. À wil képah sɔkɔ, wǎh tɔ̃ mɛ n yo nɛ ńkɛ̃́, pé Sú tɔ́tɔ́-á Liyellɛ, à ǹ gblɔ̌ynɛ n pɩ núkúlɛ ǹnɛ. ");
INSERT INTO wib_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Képah sɔkɔ, Yesu mɛ tɔ̃ yo pé tyɩ́ nɛ ńkɛ̃́: «Kègbɩgbɩ tɛ̃̀ yõ, mé kélɛ n yo yé tyɩ́, Pídĩ́ náh fɛ̃ tir yɔ́ ńtɛ̃ pɩ n pi ǹ yah yĩ́ĩ́nɛ, nɛ́ à náh ké pɩ́nɔ́ wɛ yah Sú Liyel tyɩ́. Sú Liyel-á nɛ̂nɛ n pɩ, sɛ̃́nkɔ̃ ye Pídĩ́ tɔ n nɛ n pɩ. ");
INSERT INTO wib_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Pídĩ́ tyɩ́ nɔ Sú Liyel tyɩ́. Képah ye, wàh tyi nónó póllɛ n pɩ, ǎ sé pɩ́nɔ́lɛ ǹnɛ n wɛ̃kɩ. Tɛ́ wǎh tyi nónónɛ à wɛ̃kɩ, à kɩ tɔ̃ pɔ sé lékan pɩ́nɔ́lɛ à wɛ̃kɩ n pi, nónó-á kɩ yé gbã̀n du. ");
INSERT INTO wib_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Sɔ̃́-á Sú Liyel lékyɩ̂lɛ n yilki n mɔ, à minnɛ pélɛ n kɔ̃, sɛ̃́ntɛ̃̀ ó ye névi nɛ̂-à Pídĩ́ dyɔ, ǎ minnɛ tɛ̃̀ kɔ̃. ");
INSERT INTO wib_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","23","Sú Liyel mɛ ké tyɩ́ nɛ, no pól gbílkínɔ́lɛ n sah Pídĩ́ yõ, sɔ̃́-á pè kélɛ n sah ǹmɔ yõ. Képah ye, à náh ǹnɩ̂ yɔ́ ńtɛ̃nɛ n tuke. À ye no pól tukey tyɩ́ dahbɩ ǹ gbõ̀. Tɛ́ névi nɛ̂-à gbílkínɔ́lɛ n sàh-ǹkɛ̃̂nɛ ǹmɔ yõ, ǹ tɛ́kɩ́nmɔ-ò Liyel ye tɛ̃̀ yahle gbílkínɔ́lɛ. ");
INSERT INTO wib_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Kègbɩgbɩ tɛ̃̀ yõ, mé kélɛ n yo yé tyɩ́ nɛ, névi nɛ̂-à ń wɛy noh, tɛ́ sɛ̃ ń tɛ́kɩ́nmɔ-ò yõ, tɛ̃̀-á kɩ tyɛ́-ńkɛ̃̂ min wɛ. À náh n tuke n pi. Wǎh wil tɛ kũ sɔkɔ, tɛ́ min wɛ. ");
INSERT INTO wib_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Kègbɩgbɩ tɛ̃̀ yõ, mé kélɛ n yo yé tyɩ́, gbĩ yɔ́ mɛ n pi, nɛ̂-á mɛ tɛ núkúnúkú ńtɛ̃nɛ yɔ̀. Képah sɔkɔ ye névye nónó-á mɛ kúnɔ́lɛ Liyel tyɩ́ tĩ̀nnɛ, pè kɩ ńmɔ yĩ́npɔ̃́ noh, ńmɔ nɛ̂-á Liyel Pídĩ́nɛ. Tɛ́ nónó-à kè noh, pè kɩ min wɛ. ");
INSERT INTO wib_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Sɔ̃́-á Sú Liyellɛ min nɛ́tɛ̃̂nɛ, sɛ̃́ ye ńmɔ nɛ̂-á ǹ Pídĩ́nɛ, à ńmɔ tɔ kɔ̃ mé pɩ min nɛ́tɛ̃̂nɛ. ");
INSERT INTO wib_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Tɛ́ máh pɩ Névi Pídĩ́nɛ sɛ̃́, à tukey tùkènɔ́ tɛ̃́nwɛnɔlɛ ń kɔ̃. ");
INSERT INTO wib_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ǹtɛ yé káh n yɛ tyi nɔ́pi yé gbã̀n du. Gbĩ yɔ́ mɛ n pi, lékyɩ̂ pól kɩ ń yĩ́npɔ̃́ noh, ");
INSERT INTO wib_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","tɛ́ kɩ yuku. Képah sɔkɔ, nónó-á tyípéplɔ pɩ, pépi kɩ yuku tyɛ́-ńkɛ̃̂ min wɛ yĩnnɛ. Tɛ́ nónó-á mó tyípêl pɩ, pépi wɔ kɩ yuku fõh yĩnnɛ. ");
INSERT INTO wib_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ńmɔ náh fɛ̃ tir yɔ́ ńtɛ̃ pɩ n pi ń yah yĩ́ĩ́nɛ. Ń Sú Liyel-à yo sɔ̃́ ń tyɩ́, sɛ̃́ ye mè n nɛ n kãm wɛynɛ tukey sɔkɔ. Mé náh mɛ ń gblɔ̌y nɩ̀vɩ̀nɩ̀ tyi pɩ́-ńsahlɛ n yah n kɔ̃. Sú Liyel nɛ̂-á tɛkɩ mɔ ńnɛ, ǹmɔ-á mɛ nɛ̂ tyɩ́, képah ye mè n nɛ n pɩ. Képah ye, ń wɛy kã̀mnɔ́ n pɩ gbɩ wɛ̃̀kɩ̀ yõ. ");
INSERT INTO wib_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ńmɔ-à kɩ nɛ̂ n yo ń gblɔ̌y tyɩ́lɛ, nɛ̂ kɩ sɛ̃ ń tyíyónɔ́ yõ? ");
INSERT INTO wib_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ǹtɛ nɛ́káhkɩ́ ye n yo n wah ń tyɩ́lɛ, tɛ́ mé pɩ̃ nɛ tyi nónó-á à n yo ńmɔ tyɩ́ sɔkɔ, gblɔ-á sélɛ. ");
INSERT INTO wib_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Yáh névye nónó tõ Nsyɔ̃ tyɩ́ ńmɔ tyɩ́ sɔkɔ, tɛ́ à tyi nónó yo, gblɔ ye sélɛ. ");
INSERT INTO wib_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ǹtɛ mé se yɔ́ mɛ n yah n kɔ̃ nɛ, névi tɛ̃̀ wɔ ń dùkùlɛ n yo? Yé pwáhnmɔnɔ wɛ yĩn ye mé tyi nɔ́pilɛ n yo yé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Nsyɔ̃ lésõ pɩ kyòolɛ fɔ̀tnɔ̀ tũ̀nsàhnɔ́ tyɩ́ kɔ̃lɛ. Tɛ́ kè yé dyɔ, yé nɩ̀vɩ̀nɩ̀ pɩ ǹ kyòo sɔkɔ wrɔ́ kwéy yɔ́ ó sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ǹtɛ ńmɔ wɔlɛ, Sú Liyel-á tã̀n nónó dahbɩ ń gbõ̀ ń kɔ̃ mé n pɩ, sépi ńtɛ̃ mɛ ń dùkùlɛ n wɛ̃kɩ n wah n kal Nsyɔ̃-á nɛ̂ yo ń tyɩ́ sɔkɔ. Kénɛ tã̀n nɔ́pi pɩ́nɔ́ ye n wɛ̃kɩ nɛ, Sú Liyel-á tɛkɩ mɔ ńnɛ. ");
INSERT INTO wib_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Tɛ́ à wil képah tyɩ́ sɔkɔ, Sú Liyel nɛ̂-á tɛkɩ mɔ ńnɛ, ǹ tɔ ń tyɩ́ yo wah. Ǹtɛ yé náh ǹ wɛlɔ noh yah póllɛ, yé náh se tɔ̃ à wɛ yah yĩ́nɛ. ");
INSERT INTO wib_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ǹ wɛy náh mɛ n tɛ̃ yé nnɔ sɔkɔ. Yé náh wɛ wǎh ńmɔ tɛkɩ mɔ, yé yahle sɛ̃́nɔ́lɛ ń yõ di? ");
INSERT INTO wib_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Yè n nɛ mɛ n sõ nɛ, yáh kɩ tyɛ́-ńkɛ̃̂ min wɛ Liyel wɛy sɛ́bɛ́y kàrnɔ́ sɔkɔ, ǹ tɛ́ kélɛ n kar fírfír. Ǹtɛ képah ye mó tɔ̃ yo wah tɔ́tɔ́ ńmɔ tyɩ́lɛ. ");
INSERT INTO wib_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Tɛ́ yé náh mó tɔ̃ mɛ ké tyɩ́ nɛ, yé pɔ ńmɔ tyɩ́, yé pɔ tyɛ́-ńkɛ̃̂ min wɛ. ");
INSERT INTO wib_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Mé náh mɛ n yah n kɔ̃ nɛ névye ńnɛ n gbilki. ");
INSERT INTO wib_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Mé yé dùkùlɛ n pnɛ. Liyel tyɩ́ náh nɔ yé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ń Sú Liyel yĩn yõ ye mé pɔ, tɛ́ yé náh ń tɛ̃ plɛ. Ǹtɛ ǹnɩ̂ yɔ́-à núkú pɔ ǹ yah yĩ́ĩ́nɛ yɔ̀, yé kɩ ǹmɔ tɛ̃ plɛ. ");
INSERT INTO wib_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Yé kɩ fɛ̃ sɛ̃ ń yõ sɔ̃́, yépi nónó-á mɛ ké tyɩ́ nɛ yé wɛ̃nɛ n gbilki, tɛ́ yahle gbílkínɔ́ yáhnkɔ̃nɔlɛ, nɛ̂-á n wɛ Liyel núkúní ó tyɩ́? ");
INSERT INTO wib_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Yé káh nɛ mɛ n sõ nɛ, ńmɔ-á kɩ kyɩ yé kɔ̃ n pi lékàhlɛ Sú Liyel yah sɔkɔ dɛ́! Yé gbõ̀ sàhnɔ́-á mɛ Moyisi nɛ̂ yõ, ǹmɔ ye kɩ kyɩ lékàhlɛ yé kɔ̃. ");
INSERT INTO wib_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ńmɔ tyɩ́ mɛ Moyisi wãrkɩ sah ǹ sɛ́bɛ́ynɔ́ sɔkɔ. Gbɩ-à yé sõ̀ mɛ sɛ̃ ǹmɔ yõ, yé náhkɩ mɛ sɛ̃ ńmɔ tɔ yõ. ");
INSERT INTO wib_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ǹtɛ yé náh fyɔ̀ mɛ sɛ̃ ǹmɔ tyi wã́rkɩ́nsàhnɔ́ yõ, sɔ̃́ mɛ yé kɩ fɛ̃ sɛ̃ ńmɔ wɛlɔ yõ wɛ́?» ");
INSERT INTO wib_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Képah náh, Yesu sɔkɔ Kalile yɔ́-ǹgbɛ̃ kahnɩnɛ. Pè tɔ̃ sõ̀ kélɛ n ye Tiberiyadɩ yɔ́-ǹgbɛ̃nɛ. ");
INSERT INTO wib_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Tɛ́ Yesu-á gbǐl nónó pɩ sɔkɔ à yámpú nónó dɛ mɔ tɔ́wû wɛ, sépi yĩnnɛ, tɔ́wû ǹgbɛ̃ sõ̀ mɛ ǹ sõ̀ tɛ̃. ");
INSERT INTO wib_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Képah sɔkɔ, Yesu mɛ dɔkɔ kyɩ kɔ̃ tɛ̃ yɔ̃lɩ yɔ́ yõ ànɛ̂ ǹ tõ̀ sã́hpúlɛ. ");
INSERT INTO wib_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Légbĩ́nɛ, Nsyifunɔ yɔ̃rɩ tyɛ́nɔ́ syáh sõ̀ mɛ de n tɛ. ");
INSERT INTO wib_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Tɛ́ Yesu-á ǹ yah yɔ̃ yah, à tɔ́wû ǹgbɛ̃ wɛ pè mɛ n pi ǹ tnɔ̂. Képah tɛ̃̀nɛ, à Filipi piki yah nɛ, pé se kɩ wɛ ńyãh yõke dwe dwe tɛ̃̀nɛ kɩ tɔ́wû mɛ̀ kɔ̃ pè kɩ yõ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ǹtɛ fyã̀hnyahnɔ́ ye sõ̀ Yesu n fyãh n yah Filipi fɔkɔlɛ. Ńkɛ̃́, wǎh sõ̀ nɛ̂ pɩ n pi, à sõ̀ kè pɩ̃ tɛ. ");
INSERT INTO wib_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Wǎh yo sɛ̃́, Filipi mɛ à syah nɛ, deniye pɔ́ plɔ́ lègbãm (200) fyé búrn dwénɔ́lɛ, kàh sɔ̃́ yĩki tyɩ̃́ɩ̃ tyɩ̃́ɩ̃, kè náh n yɩ̃nɛ n pi pélɛ. ");
INSERT INTO wib_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Képah sɔkɔ, Yesu tõ̀ sã́hpú sɔkɔ nɛ̂-á Simo-Pyɛrɩ gbɛ̃̀ndĩ́ Andrelɛ, ǹmɔ mɛ yo Yesu tyɩ́ nɛ, ");
INSERT INTO wib_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","búrn plɔ́ kwlɔ́ ànɛ̂ yɛ̃́nkyɔ plɔ́ nínɔ́-á mɛ dĩ́npir yɔ́ tyɩ́ ásõ̂. Ǹtɛ sépi se kɩ tir nɛ̂ pɛkɩ nɛ́kwĩ́nkí nɔ́pi dùkù tyɩ́ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Légbĩ́nɛ fílkì sõ̀ mɛ dò nɛ́npɔ́. Képah sɔkɔ, Yesu mɛ yo pé tyɩ́ nɛ pè no pól kɔ̃ pè kɔ̃ tɛ̃ sétáh. Díbí nɛ́pĩ̂ kèyõ nínɔ́ kyɛgbãm (5 000) kénkɔ̃ ye sõ̀ mɛ pé sɔkɔ nɛ́npɔ́. ");
INSERT INTO wib_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Képah sɔkɔ, Yesu mɛ búrn nɔ́pi tɔkɔ, tɛ́ wɛkɩ Liyel tyɩ́, tɛ́ sè dibi névye tyɩ́, nónó-á sõ̀ mɛ nɛ́npɔ́. Wǎh yɛ̃́nkyɔ tɔ tɔkɔ, sɛ̃́ntɛ̃̀ ó ye tɔ̃ à pɩ, tɛ́ sè dibi no kɔ̃, pé pól wɛ pǎh sõ̀ mɛ ké tyɩ́ sɔ̃́. ");
INSERT INTO wib_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Pǎh yõ tɔ̃ gbĩ́ nɛ̂nɛ, Yesu mɛ yo ǹ tõ̀ sã́hpú tyɩ́ nɛ, pè sé tɛ́lɔ́ tuke n mɔ, pè káh n yɛ kèyǎh ńtɛ̃ pɔ n yɩkɩ. ");
INSERT INTO wib_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Búrn plɔ́ kwlɔ́ táhnkwlɔnsàhnɔ́ nɛ̂ túkù-á sõ̀ mɛ wũ tɛ̃, pè mɛ sè kwel mɔ, tɔkɔnɩ gbɔ̃ninɔ́ yĩ́ĩ́nɛ. ");
INSERT INTO wib_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Névye-á Yesu gbǐl pɩ́nɔ́ wɛ sɛ̃́, pè nɛ: «Liyel tɛ̃ntõ̀ syínyo-ò nɛ̂-á sõ̀ yɩ̃nɛ à pɔ kèkõyṍ, ǹmɔ ye dĩ́ mɛ̀nɛ tɔ́tɔ́.» ");
INSERT INTO wib_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Képah sɔkɔ, Yesu pɩ̃ nɛ pǎh kɩ pɔ nɛ, páh péwɔlɛ n tɛ̃ n kãhlɩ n pɩ yõ̀tɛ̃̀nɛ. Kǎh pɩ sɛ̃́, à tɔ̃ yal pé tnɔ̂ à sɔkɔ yɔ̃lɩ yõ ǹ gblɔ̌y núkúnínɛ. ");
INSERT INTO wib_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Tɛ́ ńvɩ̃́ lísyi-á pɔ nɔ, Yesu tõ̀ sã́hpú tiki yuku yɔ-ǹgbɛ̃ vyãh yah, ");
INSERT INTO wib_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","à kyɩ de krótókè yɔ́ sɔkɔ, à tyah n yuku yɔ́nkahnɩnɛ, Kapɛrnayumi kwil tĩ̀nnɛ. Lékã̂h sõ̀ mɛ mɔ tɛ, tɛ́ Yesu náh tɔ̃̌nɩ̀ sõ̀ mɛ pɔ pé tnɔ̂. ");
INSERT INTO wib_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ǹtɛ yã́hpékè yɔ́ sõ̀ mɛ kõ mɛ ninɛ n fũ n dɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Képah sɔkɔ, pǎh krótókè to kyɩ yĩni tɛ̃ kílónɔ́ kwlɔ́ kénkɔ̃ tyɩ́, pè Yesu wɛ à mɛ n kɔ n pi yɔ yõ̀tah pé krótókè tĩ̀nnɛ. Kǎh pɩ sɛ̃́, tíkí pè tɛ̃. ");
INSERT INTO wib_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ǹtɛ Yesu mɛ yo mɔ pé tyɩ́ nɛ: «Ńmɔ ye, yé káh tíkí pɩ.» ");
INSERT INTO wib_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Képah sɔkɔ, pè sõ̀ mɛ ké tyɩ́ nɛ pé à twah krótókè sɔkɔ, tɛ́ kè núkú yĩni tɛ̃ yɔ́ngbalɩ tyɩ́, ńyãh-á sõ̀ pè n yuku. ");
INSERT INTO wib_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Képah sɔkɔ, dĩndallɛ tɔ́wû nɛ̂-á sõ̀ wũ pé ńnɩ́nɩ́ mɛ́-ńsah, pè kè kyɔmɩ wɛ nɛ krótókè núkú ó-á ńnɩ́nɩ́nɛ mɛ. Ǹtɛ Yesu tõ̀ sã́hpú ó-á sõ̀ de ké sɔkɔ à sɔkɔ, Yesu tɔ náh sɔkɔ pélɛ. ");
INSERT INTO wib_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Tɛ́ krótónè yísyɔ́ mó mɛ wil Tiberiyadɩ kwil sɔkɔ, mɛ pɔ n de ńyãh sɔkɔ-á sõ̀ Tɛ̃̀ ǹgbɛ̃ Yesu yõke tɔkɔ tɛ́ wɛkɩ Liyel tyɩ́, tɛ́ kélɛ tɔ́wû mɛ̀ kɔ̃ pè yõ. ");
INSERT INTO wib_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ǹtɛ tɔ́wû-á pɔ pɩ̃ gbĩ́ nɛ̂nɛ nɛ Yesu náh mɛ, ǹ tõ̀ sã́hpú tɔ náh mɛ nɛ́npɔ́ sɔkɔ, pè núkú de krótónè sɔkɔ, à sɔkɔ Yesu yáhnkɔ̃-ńsah Kapɛrnayumi kwil sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Képah sɔkɔ, pǎh kyɩ à wɛ yɔ́-ǹgbɛ̃ kahnɩnɛ, pè à syah nɛ, kwɔ́-ò dĩ́, gbĩ́ nɛ̂ se à pɔ ásõ̂ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ǹtɛ Yesu mɛ pè syah nɛ: «Kègbɩgbɩ tɛ̃̀ yõ, mé kélɛ n yo yé tyɩ́ nɛ, yáh gbǐl tyi nónó wɛ, sépi-á nɛ̂nɛ n wɛ̃kɩ, képah yĩn náh yé n yah n kɔ̃ ńnɛ dɛ́! Yõke nɛ̂-á yé wɛ yõ tɔ̃, képah yĩn ye yé n yah n kɔ̃ ńmɔlɛ. ");
INSERT INTO wib_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Yé káh tõ̀lɛ n pɩ yõke yĩnnɛ, nɛ̂-á kɩ n yɩkɩ n pi. Yé tõ̀lɛ n pɩ yõke yĩnnɛ nɛ̂-á kɩ n tɛ̃ n pi kṹmm, tɛ́ tyɛ́-ńkɛ̃̂ minnɛ n kɔ̃. Névi Pídĩ́ ye kɩ yé kɔ̃ n pi kénɛ yõkelɛ, ǹmɔ nɛ̂-á Sú Liyel kè wɛ̃kɩ nɛ páh pé tɔ̃́rɩ́lɛ à kɔ̃.» ");
INSERT INTO wib_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Képah tɛ̃̀nɛ, pè à piki yah nɛ, tyi nónó se pé yɩ̃nɛ pé pɩ, pé mó Liyel tõ̀ wɛ pɩ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesu mɛ yo pé tyɩ́ nɛ: «Liyel-á nɛ̂ tɛkɩ mɔ, yáh kɩ sɛ̃ ǹmɔ yõ, képah ye Liyel tõ̀lɛ.» ");
INSERT INTO wib_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Pè mɛ yo ǹ tyɩ́ nɛ, gbǐl tir nɛ̂ se ǹmɔ kɩ pɩ pé wɛ̃kɩ, pé kɔ̃ pé sɛ̃ ǹ yõ nɩ? Tir nɛ̂ se à kɩ pɩ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Pépi náh tãn-á yõke yõ gbɛ̃́nnɩ sɔkɔ, nɛ̂-á pè n ye mânnɛ, à yɩ̃nɛ sɔ̃́-á kè wãrkɩ sah nɛ: «À ye yõkelɛ pè kɔ̃ pè yõ nɛ̂-á wil yĩ̂nyõ.» ");
INSERT INTO wib_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ǹtɛ Yesu mɛ nɛ: «Kègbɩgbɩ tɛ̃̀ yõ, mé kélɛ n yo yé tyɩ́ nɛ, Moyisi náh kɔ̃ yélɛ yõke mɛ̀nɛ nɛ̂-á wil yĩ̂nyõ dɛ́, ń Sú Liyel ye n kɔ̃ yélɛ yõke gbɩlɛ, nɛ̂-á n wil yĩ̂nyõ. ");
INSERT INTO wib_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Kénɛ yõke nɛ̂-á Liyel n kɔ̃ nɛ̂-á wil yĩ̂nyõ à tiki pɔ, képah ye minnɛ kèkõyṍ névyelɛ n kɔ̃.» ");
INSERT INTO wib_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Képah sɔkɔ, pè nɛ pé yõ̀tɛ̃̀, à yõke mɛ̀nɛ pélɛ n kɔ̃ gbĩ́mɛgbĩ́ kɛ̀. ");
INSERT INTO wib_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Képah tɛ̃̀nɛ, Yesu mɛ yo pé tyɩ́ nɛ: «Ńmɔ ye yõke mɛ̀nɛ, nɛ̂-á minnɛ n kɔ̃. Névi nɛ̂-à pɔ ńmɔ tyɩ́ tɛ́ sɛ̃ ń yõ, kwɛkɩ ànɛ̂ níkì náh tɔ̃ tɛ̃̀ tɛ̃ n yah n pi. ");
INSERT INTO wib_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Tɛ́ mé ye kè yo tɛ yé tyɩ́ nɛ yáh ń wɛ. Ǹtɛ yé náh mɛ sɛ̃ ń yõ. ");
INSERT INTO wib_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","38","Ńmɔ náh wil yĩ̂nyõ à tiki pɔ ń dyɔ yĩ́ĩ́ tyi pɩ yĩnnɛ dɛ́! Nɛ̂-á tɛkɩ mɔ ńnɛ, ǹmɔ-á mɛ nɛ̂ tyɩ́, képah pɩ́-ńsah ye mé pɔ. Képah ye, Sú Liyel-à nónó póllɛ ń kɔ̃, pè kɩ pɔ ń tyɩ́. Tɛ́ nɛ̂-à pɔ ńmɔ tyɩ́, mé náh à milki n pi póllɛ. ");
INSERT INTO wib_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Tɛ́ nɛ̂-á tɛkɩ mɔ ńnɛ, ǹmɔ-á mɛ nɛ̂ tyɩ́, képah ye yɔ̀ nɛ ńkɛ̃́, páh nónónɛ ń kɔ̃ mé káh n yɛ pé sɔkɔ yɔ́ ńtɛ̃ tyɩ́ yɩkɩ. Ǹtɛ mé mó n pɔ pé lékyɩ̂ yilki mɔ gbĩ̀yĩ̀kì tɛ́y sõlɛ. ");
INSERT INTO wib_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Tɛ́ yah, ńmɔ Sú-á mɛ nɛ̂ tyɩ́, képah ye yɔ̀ nɛ, névi nɛ̂-à ǹ yah mɔ ńmɔ tĩ̀nnɛ, ńmɔ nɛ̂-á Pídĩ́nɛ, tɛ́ sɛ̃ ń yõ, tɛ̃̀ tyɛ́-ńkɛ̃̂ min wɛ, tɛ́ ńmɔ mó tɛ̃̀ lékó yilki mɔ gbĩ̀yĩ̀kì tɛ́y sõlɛ.» ");
INSERT INTO wib_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Képah sɔkɔ, Nsyifunɔ tyah Yesu sèyòkèlɛ n yo wɛ̃ tyɩ́, wǎh sɔ̃́npɩ́lɛ sõ̀ yo nɛ péwɔ-á yõkelɛ, nɛ̂-á wil yĩ̂nyõ à tiki pɔ. ");
INSERT INTO wib_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Pè sõ̀ mɛ yo tũ nɛ, Nsyosɛfu pídĩ́ Yesu kó ǹnɛ nɩ? Ǹmɔ nɛ̂-á pé ǹ sú ànɛ̂ yṹnɛ n pnɛ, à se pɩ sɔ̃́ tɛ́ pɔ n yo núkúnúkú nɛ, páh wil yĩ̂nyõ à tiki pɔ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Képah sɔkɔ, Yesu yo pé tyɩ́ nɛ: «Yé káh ń sèyòkèlɛ n yo yé wɛ̃ wrɔ́. ");
INSERT INTO wib_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ǹnɩ̂ yɔ́ ńtɛ̃ náh fɛ̃ n pɔ n pi ńmɔ tyɩ́, nɛ́ Sú Liyel nɛ̂-á tɛkɩ mɔ ńnɛ, ǹmɔ náh tɛ̃̀ yah tɛ̃. Tɛ́ ńmɔ kɩ mó tɛ̃̀ lékó yilki mɔ gbĩ̀yĩ̀kì tɛ́y sõlɛ. ");
INSERT INTO wib_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Kè mɛ wã́rkɩ́nsàhnɔ́lɛ Liyel tɛ̃ntõ̀ syínyopu sɛ́bɛ́ynɔ́ sɔkɔ nɛ: ‹Liyel kɩ pé pól kwɔ.› Ǹtɛ névi nɛ̂-à Sú Liyel wɛy noh tɛ́ ǹ kwɔ́nɔ́ fɛ̃ syi, tɛ̃̀ n pɔ ńmɔ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ǹtɛ ǹnɩ̂ yɔ́ ńtɛ̃ yĩ́ náh tɛ̃ yah Sú Liyel yõ, à wil ńmɔ tyɩ́ sɔkɔ, ńmɔ nɛ̂-á wil ǹ tnɔ̂. Ńmɔ ó wɛ ǹnɛ. ");
INSERT INTO wib_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Kègbɩgbɩ tɛ̃̀ yõ, mé kélɛ n yo yé tyɩ́, névi nɛ̂-à sɛ̃ ń yõ, tɛ̃̀ kɩ tyɛ́-ńkɛ̃̂ min wɛ. ");
INSERT INTO wib_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ńmɔ ye yõkelɛ nɛ̂-á minnɛ n kɔ̃. ");
INSERT INTO wib_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Yé náh tãn ye yõke yõ gbɛ̃́nnɩ sɔkɔ, yõke nɛ̂-á pè n ye mânnɛ. Ǹtɛ képah fyé yõ, pé pól náh pɔ ku di? ");
INSERT INTO wib_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Tɛ́ yõke nɛ̂ tɛ̃̀ wɔ-á n wil yĩ̂nyõ à tiki pɔ, névi nɛ̂-à képah yõ, tɛ̃̀ náh tɔ̃ ku n yah n pi. ");
INSERT INTO wib_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ńmɔ ye yõkelɛ, nɛ̂-á wil yĩ̂nyõ à tiki pɔ, tɛ́ minnɛ n kɔ̃. Névi nɛ̂-à kénɛ yõke yõ, tɛ̃̀ kɩ tyɛ́-ńkɛ̃̂ min wɛ. Yõke nɛ̂-á mé kɩ n kɔ̃ n pi, ń wil gbɛ̃́nsê ye. Mé ye kélɛ n kɔ̃ nɛ, kèkõyṍ névye min wɛ.» ");
INSERT INTO wib_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Képah tɛ̃̀ sɔkɔ, yékã̂b ǹgbɛ̃ de Nsyifunɔ wrɔ́. Pè sõ̀ mɛ n yo nɛ, dĩ́ mɛ̀ se kɩ fɛ̃ ǹ wil gbɛ̃́nsêlɛ pépi kɔ̃ sɔ̃́ yõkelɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Képah sɔkɔ, Yesu yo pé tyɩ́ nɛ: «Kègbɩgbɩ tɛ̃̀ yõ, mé kélɛ n yo yé tyɩ́, yáh kɩ Névi Pídĩ́ wil gbɛ̃́nsê pɩ́-ńkɛ̃̂nɛ yé yõkelɛ, tɛ́ ǹ tṍ pɩ́-ńkɛ̃̂nɛ yé wɔ wɔ kwâhlɛ, yé náh min wɛ n pi dɛ́! ");
INSERT INTO wib_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","55","Yõke kègbɩ ye ńmɔ wil gbɛ̃́nsêlɛ, wɔ wɔ kwâh kègbɩ mɛ ń tṍnɛ. Képah ye névi nɛ̂-à ńmɔ wil gbɛ̃́nsê pɩ ǹ yõkelɛ, tɛ́ ń tṍ pɩ ǹ wɔ wɔ kwâhlɛ, tɛ̃̀ ye tyɛ́-ńkɛ̃̂ min wɛ. Tɛ́ ńmɔ kɩ mó tɛ̃̀ lékó yilki mɔ gbĩ̀yĩ̀kì tɛ́y sõlɛ. ");
INSERT INTO wib_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Névi nɛ̂-à ńmɔ wil gbɛ̃́nsê pɩ ǹ yõkelɛ, tɛ́ ń tṍ pɩ ǹ wɔ wɔ kwâhlɛ, tɛ̃̀ kɩ mɛ ńmɔlɛ, tɛ́ ńmɔ tɔ kɩ mɛ tɛ̃̀nɛ. ");
INSERT INTO wib_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Sú Liyel nɛ̂-á tɛkɩ mɔ ńnɛ, ǹmɔ ye min nɛ́tɛ̃̂nɛ. Ńmɔ mɛ min sɔkɔ ǹmɔ gbõ̀ yõ. Sɛ̃́ ye névi nɛ̂-à ń wil gbɛ̃́nsê pɩ ǹ yõkelɛ, tɛ̃̀ kɩ mɛ min sɔkɔ ńmɔ gbõ̀ yõ. ");
INSERT INTO wib_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Kénɛ yõke nɛ̂-á wil yĩ̂nyõ à tiki pɔ yɔ̀, kè náh mɛ núkúlɛ ànɛ̂ yé náh tãn-á nɛ̂ yõ gbɛ̃́nnɩ sɔkɔ, pépi nónó-á ku sɔkɔ. Ǹtɛ névi nɛ̂-à képah yõ, tɛ̃̀ kɩ tyɛ́-ńkɛ̃̂ min wɛ.» ");
INSERT INTO wib_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu kénɛ tyi yo gbĩ́ nɛ̂-á lésõ à mɛ névyelɛ n kwɔ Kapɛrnayumi kwil, Nsyifunɔ Liyel ní-ńsah wɔ̀kɔ̀ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Tɛ́ Yesu-á wɛlɔ nɔ́pi yo sɛ̃́, ǹ tõ̀ sã́hpú náhnáh tyah n yo wɛ̃ tyɩ́ nɛ ńkɛ̃́, ǹ tyi yónɔ́ nɔ́pi-á mɛ tah dɛ́! Nɛ̂ se kɩ fɛ̃ sè fɛ̃ syi nɩ? ");
INSERT INTO wib_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ǹtɛ Yesu-á pɩ̃ nɛ pé tõ̀ sã́hpú-á mɛ pé sèyòkèlɛ n yo wɛy mɛ̀ tyɩ́ sɔkɔ, à pè syah nɛ: «Kè se kǎn pɩ yépi tɔlɛ? ");
INSERT INTO wib_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Tɛ́ yâh pyě pɔ Névi Pídĩ́ wɛ à yɔ̃ dɔkɔ n sɔkɔ wǎh wil ńyãh sɔkɔ wɛ́? ");
INSERT INTO wib_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Liyel Mirki ye min nɛ́tɛ̃̂nɛ, nòtɛ tir nɛ̂ mɛ névi kɩ fɛ̃ pɛkɩ ǹ gblɔ̌y? Ńmɔ-á wɛlɔ nónó yo yé tyɩ́, sè n wil Liyel Mirki tyɩ́, tɛ́ minnɛ n kɔ̃. ");
INSERT INTO wib_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ǹtɛ túkù mɛ yé sɔkɔ, pè náh mɛ sɛ̃ ń yõ.» Tɛ́ yah, à tɔkɔ ké tyah gbĩ́ dùkù tyɩ́, Yesu sõ̀ ǹ yõ sɛ̃́-ńkɛ̃̂púlɛ n pnɛ, à tahlɩ nɛ̂ tɔ-á nɛ pɔ à dahbɩ n pi gbõ̀ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Képah sɔkɔ, Yesu tɔ̃ nɛ: «Képah ye ń kɔ̃ mé kè yo nɛ ńkɛ̃́, ǹnɩ̂ yɔ́ ńtɛ̃ náh fɛ̃ n pɔ n pi ńmɔ tyɩ́, nɛ́ Sú Liyel náh ké wɛ̃̀kɩ̀lɛ à kɔ̃.» ");
INSERT INTO wib_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","À tɔkɔ légbĩ́ tyɩ́, ǹ sõ̀ tɛ̃́pú náhnáh núkú pé syɩ ǹ náh, pè náh tɔ̃ mɛ ǹ sõ̀lɛ n tɛ̃. ");
INSERT INTO wib_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Képah sɔkɔ, Yesu mɛ yo ǹ tõ̀ sã́hpú nɛ́pĩ̂ gbɔ̃nimí tyɩ́ nɛ ńkɛ̃́, tɛ́ pépi-á dò, pé tɔ kó pé syɩ n pi nɩ? ");
INSERT INTO wib_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ǹtɛ Simo-Pyɛrɩ mɛ nɛ ńkɛ̃́: «Tyɛ́-ńkɛ̃̂ min wɛlɔ nɛ́tɛ̃̂ ye áwɔlɛ, nɛ̂ tyɩ́ mɛ ápi kɩ tɔ̃ yuku wɛ́, Tɛ̃̀ ǹgbɛ̃? ");
INSERT INTO wib_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ápi tɛ̃̀ wɔ sɛ̃́nɔ́ mɛ á yõ, ànɛ̂ á pɩ̃ nɛ áwɔ-á Liyel wilki sah ǹ tyɩ́ yõ.» ");
INSERT INTO wib_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Képah tɛ̃̀nɛ, Yesu tɔ̃ yo pé tyɩ́ nɛ, péwɔ kó yah wilki pélɛ nɛ́pĩ̂ gbɔ̃nimínɛ nɩ? Ǹtɛ sétõ-á pé sɔkɔ nɛ́núkù yɔ́lɛ. ");
INSERT INTO wib_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Tɛ́ Nsyudasɩ ye sõ̀ Yesu n ye, ǹmɔ nɛ̂-á Simo Yisikariyɔtɩ pídĩ́nɛ. Yesu tõ̀ sã́hpú nɛ́pĩ̂ gbɔ̃nimí sɔkɔ yɔ́ ye sõ̀ ǹnɛ. Tɛ́ ǹmɔ ye kɩ sõ̀ pɔ Yesu dahbɩ n pi gbõ̀ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Képah náh, Yesu sõ̀ mɛ yɔ̃ sɔkɔ n kɔ n kɔ̃ Kalile gbɛ̃̀nyah sɔkɔ. Tɛ́ Nsyifunɔ yõ̀tãm-á sõ̀ mɛ n yah n kɔ̃ ǹ kònmɔ-ńsahlɛ Nsyude gbɛ̃̀nyah sɔkɔ sɛ̃́, képah ye à náh tɔ̃ sõ̀ mɛ ké tyɩ́ nɛ, pé kɔ kɔ̃ nɛ́npɔ́. ");
INSERT INTO wib_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Tɛ́ Nsyifunɔ kènkã̀l sõ̀ syáh sõ̀ mɛ de n tɛ. ");
INSERT INTO wib_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Yesu yṹnpyé mɛ yo ǹ tyɩ́ nɛ ńkɛ̃́, à yal ásõ̂, à mó yuku Nsyude gbɛ̃̀nyah sɔkɔ, ǹ sõ̀ tɛ̃́pú tɔ kɔ̃ pè ǹ tyípɩ́nɔ́ wɛ. ");
INSERT INTO wib_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ńkɛ̃́ névi nɛ̂-à mɛ ké tyɩ́ nɛ no pé dùkù pɩ̃, tɛ̃̀ náh ǹ tyilɛ n pɩ sètĩ̀n sõ̀ sɔkɔ. Tɛ́ ǹmɔ-á tyi nónónɛ n pɩ yɔ̀, wǎh yɩ̃nɛ à sélɛ n pɩ n wilki n mɔ, no kɔ̃ pè à wɛ. ");
INSERT INTO wib_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ǹtɛ Yesu yṹnpyé ńtɛ̃ náh sõ̀ mɛ sɛ̃ ǹ yõ. ");
INSERT INTO wib_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Képah sɔkɔ, Yesu mɛ nɛ ké gbĩ náh tɔ̃̌nɩ̀ sɛ péwɔ tyɩ́. Gbĩ́mɛgbĩ́-á se mɛ yɩ̃́nɛ́nɔ́lɛ pépi tyɩ́ tɛ́. ");
INSERT INTO wib_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Kèkõyṍ névye náh fɛ̃ pépi dyɔ yɔ n pi. Ǹtɛ pǎh mɛ péwɔ wɔ dyɔlɛ n yɔ, páh sɔ̃́npɩ́lɛ kélɛ n yo n wah nɛ pé tyípɩ́nɩ̀ náh mɛ plɛ. ");
INSERT INTO wib_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Pépi dɔkɔ n yuku kénɛ syáh sɔkɔ. Péwɔ tɛ̃̀ wɔ tyɩ́, ké gbĩ náh tɔ̃̌nɩ̀ sɛ. Képah-á, pé náh n kyɩ n pi. ");
INSERT INTO wib_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Wǎh képah yo tɛ, à wũ Kalile sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Tɛ́ ǹ yṹnpyé-á sɔkɔ tɛ syáh mɛ̀ sɔkɔ, ǹmɔ tɔ yuku nɛ́npɔ́ nyáh sõ. Tɛ́ à náh sõ̀ yɛ névye kɔ̃ pè à wɛ. À kè pɩ wɔ̃̀bɩ̀nsɔkɔnɔlɛ kannɛ. ");
INSERT INTO wib_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Tɛ́ Nsyifunɔ yõ̀tãm mó mɛ ǹnɛ n yah n kɔ̃ syáh mɛ̀ sɔkɔ, tɛ́ mɛ n piki n yah nɛ, ńyãh se ǹnɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Képah sɔkɔ, tɔ́wû mɛ̀ névye tyah Yesu tyɩ́lɛ n yãh tõ̀tõ̀. Pé túkù sõ̀ mɛ n yo nɛ nɛ́gbɩ́-á ǹnɛ, túkù mó mɛ n yo nɛ sɛ̃́ náh, ǹmɔ-á pyě n pilki névyelɛ ńkɛ̃́. ");
INSERT INTO wib_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ǹtɛ Nsyifunɔ yõ̀tãm tíkí sõ̀ mɛ pè tɛ̃. Kǎh pɩ sɛ̃́, pé sɔkɔ yɔ́ ńtɛ̃ náh tɛ̃ wɛ ǹ yõ wilki mɔ à yo Yesu tyɩ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Syáh mɛ̀ sõ̀ mɛ ké nɩyṍ sɔkɔ, tɛ́ Yesu dɔkɔ pɔ Liyel ní-ńsah gbô sɔkɔ, à pɔ kwɔ́nɔ́lɛ n pɩ. ");
INSERT INTO wib_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Tɛ́ wǎh kwɔ́nɔ́ nɛ̂nɛ n pɩ, kè Nsyifunɔ yõ̀tãm gbã̀n du. Pè mɛ tyah n yo wɛ̃ tyɩ́ nɛ, dĩ́ mɛ̀ se wɛ ńyãh pnɛ̀nɔ́ mɛ̀ dùkùlɛ nɩ? Tɛ́ à náh se mó tɔ̃ kǎrn ǹgbɛ̃ pɩ. ");
INSERT INTO wib_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Képah sɔkɔ, Yesu mɛ yo pé tyɩ́ nɛ ńkɛ̃́: «Máh kwɔ́nɔ́lɛ n pɩ tyi nónó yõ yɔ̀, ńmɔ náh sõ tɛ̃ sélɛ dɛ́, Liyel nɛ̂-à tɛkɩ mɔ ńnɛ, ǹmɔ ye n wɛ̃kɩ sélɛ. ");
INSERT INTO wib_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Névi nɛ̂-à kè yah tɔkɔ nɛ pé Liyel dyɔ dyɔ tɛ̃̀nɛ n pɩ, tɛ̃̀ wɔ ye kɩ fɛ̃ ké gbɩ pɩ̃, Liyel-à kɩ nɛ̂ wɛ̃kɩ ńnɛ sélɛ, képah náh pɩ, ń yah yĩ́ĩ́ kwɔ́nɔ́-à kɩ nɛ mé n pɩ. ");
INSERT INTO wib_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Névi nɛ̂-à ǹ yah yĩ́ĩ́ tyilɛ n yo, ǹ gblɔ̌y yĩn gbílkí-ńsah ye à n yah n kɔ̃. Ǹtɛ névi nɛ̂-à mɛ ké tyɩ́ nɛ pé tyi pól pɩ, pé tṍ-ò yĩn mó gbilki, nɛ́gbɩ́ ye tɛ̃̀nɛ. Pílkí-ńsah náh mɛ tɛ̃̀ tyɩ́ póllɛ. ");
INSERT INTO wib_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moyisi náh Liyel tyi kõ̀nsàhnɔ́lɛ yé kɔ̃ di? Ǹtɛ yé sɔkɔ yɔ́ ńtɛ̃ náh se mɛ n kɔ ké wɛ̃̀kɩ̀ yõ nɩ? Sɔ̃́ pɩ tɛ́ yé n yah n kɔ̃ ńmɔ kònmɔ-ńsahlɛ wɛ́?» ");
INSERT INTO wib_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Képah tɛ̃̀nɛ, tɔ́wû à syah nɛ sétõ-á mɛ ǹ sɔkɔ, à kɔ̃ à képahlɛ n yo, nòtɛ nɛ̂ se nɛ páh ǹnɛ n ko n mɔ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesu mɛ tɔ̃ yo pé tyɩ́ nɛ: «Tyi núkú yɔ́ ó náh mé pɩ, tɛ́ yé pól gbã̀n du yɔ̀ di? ");
INSERT INTO wib_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moyisi náh mɔ yélɛ kõ̀kè kõ̀nɔ́ sɔkɔ di? Ǹtɛ ǹmɔ ńtɛ̃ náh tyah ké gbennɛ dò, ǹ náh tãn ye tyah kélɛ. Tɛ́ yé náh mɛ píyĩ́lɛ n kõ mɩ mɩ yòh sõlɛ di? ");
INSERT INTO wib_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ǹtɛ yépi-à kõ̀kèlɛ n kõ mɩ mɩ yòh sõlɛ, nɛ yé káh pɔ Moyisi tyi kõ̀nsàhnɔ́ dêl pɩ, sɔ̃́ pɩ tɛ́ ńmɔ-á névi yõ̀tàhsyi pól dɛ mɔ mɩ mɩ yòh sõlɛ, yé ń dyɔlɛ n yɔ wɛ́? ");
INSERT INTO wib_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Yé káh tyilɛ n wah à yɩ̃nɛ yɩ̃́ yáhnɔ́lɛ. Yé sélɛ n wah gbɩ wɛ̃̀kɩ̀ yõ.» ");
INSERT INTO wib_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Képah sɔkɔ, Yerusalɛmɩ tãn túkù sõ̀ mɛ n yo nɛ ńkɛ̃́, dĩ́ nɛ̂-á sõ̀ pè n yah n kɔ̃ nɛ pé ko mɔ, ǹmɔ kó yɔ̀ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ǹtɛ pè yah à n wɛkɩ tɔ́wû nɩyṍ, tɛ́ pè náh mɛ n vi n mɔ ǹ tyɩ́ lɛ́! Yõ̀tãm se kɩ pyě mɛ kè fɛ̃ syi nɛ, ǹmɔ-á Liyel nɛy yáhntɔkɔnɔlɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Tɛ́ Liyel nɛy yáhntɔkɔnɔ-à sõ nɛ̂nɛ pɔ, névi náh ǹ wìl-ǹsah pɩ̃ n pi, ǹtɛ pépi-á dĩ́ mɛ̀ wìl-ǹsah pɩ̃ dò. ");
INSERT INTO wib_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Képah ye, Yesu-á mɛ névyelɛ n kwɔ Liyel ní-ńsah gbô sɔkɔ, à yo pé tyɩ́ yĩ́npɔ̃́ ǹgbɛ̃nɛ nɛ: «Yé ńnɛ n pnɛ, tɛ́ ń wìl-ǹsah pɩ̃ yé yo kɛ̀? Ǹtɛ ńmɔ náh pɔ ń gblɔ̌y yõ sɛ̃́ dɛ́! Liyel nɛ̂-á tɛkɩ mɔ ńmɔlɛ, à mɛ gbɩ ó ǹ tɔ̂ɔ́, ǹmɔ nɛ̂-á yé náh ǹnɛ n pnɛ. ");
INSERT INTO wib_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ǹtɛ ńmɔ wɔ wil ǹ tnɔ̂. Mé ǹnɛ n pnɛ, ànɛ̂ ǹmɔ ye tɛkɩ mɔ ńnɛ.» ");
INSERT INTO wib_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Képah tɛ̃̀ sɔkɔ, pè tyah Yesu tɛ̃́-ńsahlɛ n yah n kɔ̃. Tɛ́ kǎh pɩ ǹ gbĩ náh tɔ̃̌nɩ̀ sõ̀ mɛ sɛ sɛ̃́, ǹnɩ̂ yɔ́ ńtɛ̃ náh tɛ̃ wɛ gbõ̀ tũ ǹ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ǹtɛ tɔ́wû mɛ̀ sɔkɔ névye náhnáh sõ̀ mɛ sɛ̃ ǹ yõ, tɛ́ mɛ n yo nɛ, tɛ́ Liyel nɛy yáhntɔkɔnɔ-à sõ nɛ̂nɛ pɔ, à se kɩ pɔ gbǐl tyi pɩ kɩ kal dĩ́ mɛ̀ tyɩ́lɛ yɔ̀ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Tɛ́ tɔ́wû-á sõ̀ mɛ tyi nónónɛ n yãh tõ̀tõ̀ Yesu tyɩ́ sɔkɔ, sè pɔ wɛ de Farisi wɛ̃̀kɩ̀ kɔ́pú níkí sɔkɔ. Képah sɔkɔ, pépi ànɛ̂ sárká syínwìlkìpu yõ̀tãm mɛ Liyel ní-ńsah gbô syɩ́kɩ́pú tɛkɩ mɔ nɛ, pè kyɩ Yesu tɛ̃. ");
INSERT INTO wib_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Pǎh pɔ, Yesu mɛ nɛ: «Ńmɔ kɩ mɛ yélɛ kɩ wrɔ́ kwéy ó pɩ ńtɔ̃, tɛ́ kɩ sɔkɔ ń tɛ́kɩ́nmɔ-ò tnɔ̂. ");
INSERT INTO wib_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ńmɔ-á kɩ n mɛ n pi ńyãh sɔkɔ, yépi náh fɛ̃ n kyɩ nɛ́npɔ́. Képah ye, yé kɩ ń yah kɔ̃ tɛ́ yé náh ń wɛ n pi.» ");
INSERT INTO wib_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Wǎh yo sɛ̃́, Nsyifunɔ núkú tyah n yo wɛ̃ tyɩ́ nɛ, ńyãh se ǹmɔ kɩ n yuku n pi, tɛ́ pépi kɩ à yah kwlɔ nɩ? Ńkɛ̃́ pé no Nsyifunɔ nónó-á mɛ karkɩ tɛ̃ tɛ̃ kɔ̃ nɛ́káhbɩ́ wrɔ́, pépi tyɩ́ se pyě à kɩ yuku, kɩ kyɩ nɛ́káhbɩ́lɛ n kwɔ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ńkɛ̃́ wɛlɔ nónó-á à yo yɔ̀ nɛ ńkɛ̃́: «Ńmɔ-á kɩ n mɛ n pi ńyãh sɔkɔ, yépi náh fɛ̃ n kyɩ nɛ́npɔ́, képah ye, yé kɩ ń yah kɔ̃, tɛ́ yé náh ń wɛ n pi.» Sépi kɔ́r se nɛ̂nɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Syáh gbĩ̀yĩ̀kì tɛ́y sõlɛ, nɛ̂-á pɩ ké gbĩ̀yĩ̀kì ǹgbɛ̃nɛ, Yesu yuku yĩn tɔ́wû sɔkɔ, tɛ́ yo yĩ́npɔ̃́ ǹgbɛ̃nɛ nɛ: «Níkì-à mɛ nɛ̂ tɛ̃, tɛ̃̀ pɔ ńmɔ tyɩ́, à pɔ wɔ. ");
INSERT INTO wib_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Névi nɛ̂-à sɛ̃ ńmɔ yõ, min yrɛy kɩ n fwo n wil tɛ̃̀ sɔkɔ, sɔ̃́-á Liyel wɛy sɛ́bɛ́y yo kélɛ.» ");
INSERT INTO wib_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Liyel Mirki nɛ̂-á sõ̀ Yesu yõ sɛ̃́pú kɩ pɔ n wɛ n pi, képah tyɩ́ ye sõ̀ Yesu n yo. Tɛ́ légbĩ́nɛ, Yesu náh tɔ̃̌nɩ̀ sõ̀ mɛ dɔkɔ ǹ tɔ̃́rɩ́ yõ, képah ye Liyel náh tɔ̃̌nɩ̀ sõ̀ mɛ ǹ Mirkilɛ pè kɔ̃. ");
INSERT INTO wib_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Tɔ́wû-á Yesu wɛy mɛ̀ noh tɛ, túkù tyah n yo nɛ ńkɛ̃́, Liyel tɛ̃ntõ̀ syínyo-ò nɛ̂-á pé syɩkɩ tɛ̃, ǹmɔ-á dĩ́ mɛ̀nɛ tɔ́tɔ́. ");
INSERT INTO wib_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Túkù mó nɛ, Liyel-á nɛ̂ yah tɔkɔ, ǹmɔ-á. Tɛ́ túkù tɛ̃̀ wɔ mó nɛ, Liyel nɛy yáhntɔkɔnɔ se kɩ fɛ̃ wil Kalile gbɛ̃̀nyah sɔkɔ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Kè kó mɛ yónɔ́lɛ Liyel wɛy sɛ́bɛ́y sɔkɔ nɛ ńkɛ̃́, wǎh kɩ pɩ yõ̀tɛ̃̀ dĩ́ Davidi pétóbé sɔkɔ yɔ́lɛ, tɛ́ kɩ n dubi n pi Betlɛmɩ kwil, képah nɛ̂ sɔkɔ-á Davidi dubi di? ");
INSERT INTO wib_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Képah sɔkɔ, névye sõnɔ pɩ sé tyɩ́ tyɩ́lɛ Yesu tyɩ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Túkù sõ̀ mɛ n yah n kɔ̃ ǹ tɛ̃́-ńsahlɛ, ǹtɛ ǹnɩ̂ yɔ́ ńtɛ̃ náh tɛ̃ wɛ gbõ̀ tũ ǹ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Képah sɔkɔ, Liyel ní-ńsah gbô syɩ́kɩ́pú pé syɩ sɔkɔ sárká syínwìlkìpu yõ̀tãm ànɛ̂ Farisi wɛ̃̀kɩ̀ kɔ́pú tnɔ̂. Pèpi mɛ pè piki yah nɛ, sɔ̃́ se pɩ tɛ́ pè náh Yesu tɛ̃ pɔ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Pè mɛ pè syah nɛ, dĩ́ mɛ̀ wɛy kénkɔ̃ náh mɛ póllɛ. ");
INSERT INTO wib_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Képah tɛ̃̀nɛ, Farisi wɛ̃̀kɩ̀ kɔ́pú nɛ, è, pè se pyě yɛ à kɔ̃ à pé tɔ yõ yɩkɩ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Pè se yõ̀tɛ̃̀ yɔ́, képah náh pɩ, Farisi wɛ̃̀kɩ̀ kɔ́-ò yɔ́ wɛ yah à sɛ̃ Yesu yõ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Tɛ́ kàh tɔ́wû mɛ̀ névye tɛ̃ wɔ lésyi, pè náh Moyisi tyi kõ̀nsàhnɔ́lɛ n pnɛ dò. Pé pól tyɩ́-á yɩkɩ. ");
INSERT INTO wib_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Tɛ́ Farisi wɛ̃̀kɩ̀ kɔ́pú nɔ́pi sɔkɔ yɔ́ sõ̀ mɛ pè n ye Nikodɛmɩnɛ, nɛ̂-á kyɩ wil yah Yesu tyɩ́ sõ yɔ́lɛ. Ǹmɔ mɛ yo pé no tyɩ́ nɛ: ");
INSERT INTO wib_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«À yɩ̃nɛ ápi tyi kõ̀nsàhnɔ́lɛ, á se yɩ̃nɛ à lékàhlɛ névi kɔ̃, nɛ́ á náh ǹ vyãh wɛy noh, tɛ́ pɩ̃ tyi nónó-á à pɩ?» ");
INSERT INTO wib_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Képah sɔkɔ, pé no à syah nɛ, è, Kalile gbɛ̃̀nyah nɛy se ǹ tɔlɛ tɛ́ à n wɛkɩ sɛ̃́ nɩ? Ńkɛ̃́, à Liyel wɛy sɛ́bɛ́y tɔkɔ n sohlɩ n yah, wǎh kɩ kè wɛ nɛ, Liyel tɛ̃ntõ̀ syínyo-ò yɔ́ ńtɛ̃ náh n wil Kalile gbɛ̃̀nyah sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Képah náh, pé pól karkɩ sɔkɔ pé fnɛ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ǹtɛ, Yesu wɔ mó sɔkɔ Wolivi yèh yɔ̃lɩ yõ. ");
INSERT INTO wib_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Tɛ́ dĩndal séngbɔ̃́ púpúlɛ, Yesu tɔ̃ ǹ syɩ pɔ Liyel ní-ńsah gbô sɔkɔ, tɛ́ no pól mɛ pɔ ǹ tnɔ̂. À mɛ kɔ̃ tɛ̃ à tyah pélɛ n kwɔ. ");
INSERT INTO wib_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Wǎh mɛ kwɔ́nɔ́ sɔkɔ, Liyel tyi kõ̀nsàhnɔ́ kwɔ́pú ànɛ̂ Farisi wɛ̃̀kɩ̀ kɔ́pú mɛ pɔ sê fɔ̀fɩ́npɩ yɔ́lɛ ǹ tyɩ́. Pè pɔ pi mɛ̀ sah tɔ́wû nɩyṍ Yesu yah, ");
INSERT INTO wib_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","tɛ́ Yesu syah nɛ, kwɔ́-ò dĩ́, páh pi mɛ̀ wɛ tɛ̃ fɔ̀fɩ́kɩ̀ pɩ́nɔ́ sɔkɔ tɔ́tɔ́. ");
INSERT INTO wib_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Tɛ́ Moyisi-á kè yo sah ǹ tyi kõ̀nsàhnɔ́ sɔkɔ nɛ, sɛ̃́nkɔ̃ sê-á yɩ̃nɛ mínkònɔ́lɛ dyêhlɛ. Tɛ́ ǹmɔ-á dò, ǹmɔ se nɛ sɔ̃́-á nɩ? ");
INSERT INTO wib_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Pè sõ̀ mɛ képah tɛ̃̀nɛ n yo sɛ̃́, nɛ wàh kɩ pilki pé lékàh wɛ à kɔ̃. Ǹtɛ Yesu mɛ ǹ yõ sĩnki, tɛ́ tyah n wãrkɩ sétáh sɔkɔ ǹ kèngbɔlɛ. ");
INSERT INTO wib_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Kǎh pɩ sɛ̃́, pè tɔ̃ mɛ yɔ̃ sɔkɔ ǹnɛ n gbah n piki n yah. Képah tɛ̃̀nɛ, à mɛ ǹ yõ yɔ̃ tɛ́ yo pé tyɩ́ nɛ: «Yé sɔkɔ nɛy nɛ̂-à kɩ mɛ à náh tyípékè pɩ yah póllɛ, tɛ̃̀ wɔ dáhkɩ̀lɛ pi mɛ̀ min gbennɛ.» ");
INSERT INTO wib_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Képah yóntɛnɔ náh, à tɔ̃ ǹ yõ sĩnki à tyah n wãrkɩ sétáh sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Pǎh képah tɛ̃̀ noh sɛ̃́, pè tyah n sɔkɔ núkú núkúlɛ, à tɔkɔ lékɔ̃lɔ́ ǹgbò tyɩ́, pópó à pɔ gbàh sah Yesu ànɛ̂ pi mɛ̀ ó tyɩ́ nɛ́npɔ́. ");
INSERT INTO wib_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Képah sɔkɔ, Yesu mɛ ǹ yõ yɔ̃ tɛ́ yo pi tyɩ́ nɛ, nónó-á pɔ tɔkɔ à kɔ̃, ńyãh se pélɛ nɩ? Pé sɔkɔ yɔ́ ńtɛ̃ kó à mɔ kũ kɔ̃ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Pi mɛ nɛ, pé yõ̀tɛ̃̀, nɛy náh pé mɔ kũ kɔ̃. Képah sɔkɔ, Yesu mɛ nɛ: «Ńmɔ tɔ náh ǹ mɔ kũ kɔ̃ n pi. Nɛ n yuku; tɛ́ à tɔkɔ núkúnúkú tyɩ́, káh n tɔ̃ tyípékè pɩ n yah.» ");
INSERT INTO wib_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Képah náh, Yesu tɔ̃ yo névye tyɩ́ nɛ: «Ńmɔ ye kèkõyṍ kyòolɛ. Névi nɛ̂-à ńmɔ sõ̀ tɛ̃, tɛ̃̀ náh tɔ̃ n kɔ n pi fɛ̃́ntũ̂ sɔkɔ. À kɩ kyòo wɛ, nɛ̂-á kɩ minnɛ à kɔ̃. ");
INSERT INTO wib_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Képah sɔkɔ, Farisi wɛ̃̀kɩ̀ kɔ́pú à syah nɛ, nɛ̂ se kɩ sɛ̃ ǹ tyíyónɔ́ yõ nɩ? Ǹmɔ ó kó ǹ gblɔ̌y tàrfyɔ̀lɛ yɔ̀ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesu mɛ yo pé tyɩ́ nɛ ńkɛ̃́: «Gbɩ tɛ̃̀ wɔ ye ńmɔ ye ń gblɔ̌y tàrfyɔ̀lɛ ó, ǹtɛ ńmɔ ń wìl-ǹsahlɛ n pnɛ, tɛ́ ń yúkú-ńsahlɛ n pnɛ. Képah ye, máh tyi nónó yo ń gblɔ̌y dùkù tyɩ́ sɔkɔ, gblɔ ye sélɛ. Tɛ́ yépi náh ń wìl-ǹsah pɩ̃, yé náh se mó tɔ̃ ń yúkú-ńsah pɩ̃. ");
INSERT INTO wib_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Yépi tɛ̃̀ wɔ lékàhlɛ névyelɛ n kɔ̃ à yɩ̃nɛ névi yõ̀tàhsyi sõnɔlɛ. Ǹtɛ ńmɔ wɔ náh lékàhlɛ ǹnɩ̂ yɔ́ ńtɛ̃nɛ n kɔ̃. ");
INSERT INTO wib_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Tɛ́ kàh se pɔ pɩ mé yɩ̃nɛ mè lékàhlɛ ǹnɩ̂ kɔ̃, mé náh kélɛ à kɔ̃ n pi ń gblɔ̌y. Sú Liyel nɛ̂-á tɛkɩ mɔ ńnɛ, á kɩ kélɛ à kɔ̃ wɛ̃ tyɩ́ ǹmɔlɛ. Képah ye, ń lékàh kɔ̃́nɔ́ kɩ pɩ gbɩ wɛ̃̀kɩ̀ yõ. ");
INSERT INTO wib_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Kè náh mɛ wã́rkɩ́nsàhnɔ́lɛ yé tyi kõ̀nsàhnɔ́ sɔkɔ nɛ, nɛ́pĩ̂ nímí-à pɩ tàrfyɔ̀lɛ tir nɛ̂ sɔkɔ, gbɩ-á kélɛ di? ");
INSERT INTO wib_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ńmɔ mɛ ń gblɔ̌y tyɩ́lɛ n yo, tɛ́ Sú Liyel nɛ̂-á tɛkɩ mɔ ńnɛ, ǹmɔ tɔ mɛ ń tyɩ́lɛ n yo.» ");
INSERT INTO wib_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Képah sɔkɔ, pè Yesu syah nɛ, ńyãh se ǹ súlɛ nɩ? Yesu mɛ nɛ: «Yé náh ńmɔlɛ n pnɛ, yé náh ń Sú tɔlɛ n pnɛ. Yâh sõ̀ mɛ ńnɛ pnɛ, yé náhkɩ ń Sú tɔ pɩ̃.» ");
INSERT INTO wib_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesu sõ̀ mɛ kwɔ́nɔ́lɛ n pɩ Liyel ní-ńsah gbô fɩ̃́ yɔ́ sɔkɔ, ńyãh-á ké pɔ́ kyɛ́súkùlɛ, tɛ́ tyi nɔ́pi yo. Ǹtɛ ǹ gbĩ náh tɔ̃̌nɩ̀ sõ̀ mɛ sɛ, képah ye ǹnɩ̂ yɔ́ ńtɛ̃ náh tɛ̃ wɛ à tɛ̃. ");
INSERT INTO wib_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Képah náh, Yesu tɔ̃ yo tɔ́wû tyɩ́ nɛ: «Ńmɔ ye n sɔkɔ yɔ̀. Yé kɩ ń yah n kɔ̃ n pi, ǹtɛ yé kɩ ku yé tyípékè sɔkɔ. Ńmɔ-á n yuku ńyãh, yépi náh fɛ̃ n kyɩ n pi nɛ́npɔ́.» ");
INSERT INTO wib_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Képah sɔkɔ, Nsyifunɔ nɛ, ǹtɛ ǹ gblɔ̌y ko mɔ dékè se kɩ pyě mɛ à tɛ̃ nɩ? À kɔ̃ à n yo nɛ, pépi náh fɛ̃ n kyɩ n pi péwɔ yúkú-ńsah sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesu mɛ yo pé tyɩ́ nɛ: «Yépilɛ, sétáh yõ névye ye yélɛ, tɛ́ ńmɔ wɔlɛ, ńmɔ wil yĩ̂nyõ. Kèkõyṍ mɛ̀ névye ye yépilɛ, ǹtɛ ké névi náh ńmɔ wɔlɛ. ");
INSERT INTO wib_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Yáh wɛ mé kélɛ n yo yé tyɩ́ nɛ yáh kɩ ku yé tyípêl sɔkɔ, yé náh mɛ sɛ̃ ké yõ nɛ, Ńmɔ-á, képah ye ń kɔ̃ mé nɛ yáh kɩ ku yé tyípêl sɔkɔ.» ");
INSERT INTO wib_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Képah sɔkɔ, pè à piki yah nɛ, nɛ̂ tɛ̃̀ ó se ǹmɔlɛ nɩ? Yesu mɛ yo pé tyɩ́ nɛ: «Mé sõ̀ kè yo tɛ yé tyɩ́ ké tyah gbĩ́ dùkùlɛ. ");
INSERT INTO wib_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Tyi náhnáh mɛ ń tyɩ́ yo yo tɛ̃̀nɛ yé tyɩ́ sɔkɔ ànɛ̂ kɩ lékàhlɛ yé kɔ̃. Ǹtɛ máh nɛ̂ noh ń tɛ́kɩ́nmɔ-ò tyɩ́, képah ó ye mé n yo yé tyɩ́. Ǹmɔ ye gbɩ nɛ́tɛ̃̂nɛ.» ");
INSERT INTO wib_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ǹtɛ pépi náh sõ̀ mɛ pɩ̃ nɛ, Sú Liyel tyɩ́-á Yesu n yo pé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Képah sɔkɔ, Yesu yo pé tyɩ́ nɛ: «Yâh pɔ Névi Pídĩ́ yɔ̃ dɔkɔ gbĩ́ nɛ̂nɛ, yé kɩ pɩ̃ nɛ Ńmɔ-á. Tɛ́ kɩ tɔ̃ pɩ̃ nɛ mé náh tir yɔ́ ńtɛ̃nɛ n pɩ ń yah yĩ́ĩ́nɛ. Sú Liyel-á tyi nónónɛ ń kwɔ, sépi ó ye mè n nɛ n yo. ");
INSERT INTO wib_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Nɛ̂-á tɛkɩ mɔ ńmɔlɛ, mé mɛ ǹ dyɔ yĩ́ĩ́ tyilɛ n pɩ gbĩ́mɛgbĩ́, képah ye à mɛ ńnɛ, à náh ń sah n pi ń gblɔ̌y.» ");
INSERT INTO wib_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yesu-á mɛ képah yónɔ́ sɔkɔ gbĩ́ nɛ̂nɛ, névye náhnáh sɛ̃ ǹ yõ. ");
INSERT INTO wib_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Képah tɛ̃̀nɛ, Nsyifunɔ nónó-á sõ̀ sɛ̃ Yesu yõ, à mɛ yo pé tyɩ́ nɛ: «Yáh kɩ mɛ ńmɔ tyíyónɔ́ wɛ̃̀kɩ̀lɛ n kɔ, ń tõ̀ sã́hpú kègblɔ ye yélɛ. ");
INSERT INTO wib_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Yé kɩ gbɩlɛ n pnɛ, tɛ́ kénɛ gbɩ kɩ yé wilki yɔ̃rɩ sɔkɔ.» ");
INSERT INTO wib_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Képah sɔkɔ, pè mɛ Yesu syah nɛ, Abrahmɩ pétóbé-á pépilɛ. Pépi náh pɩ yah ǹnɩ̂ yɔ́ ńtɛ̃ yɔ̃bɩlɛ póllɛ. Ǹtɛ à se sɔ̃́npɩ́lɛ n yo nɛ, pépi-á kɩ wil yɔ̃rɩ sɔkɔ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesu mɛ yo pé tyɩ́ nɛ: «Kègbɩgbɩ tɛ̃̀ yõ, mé kélɛ n yo yé tyɩ́, névi nɛ̂-à tyípékèlɛ n pɩ, tyípékè yɔ̃̀ ye tɛ̃̀nɛ. ");
INSERT INTO wib_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Yɔ̃̀lɛ, ǹ yõ̀tɛ̃̀ dĩ́ gbô sɔkɔ tɛ̃̀-ò kṹmm náh ǹnɛ. Ǹtɛ yõ̀tɛ̃̀ dĩ́ pídĩ́ tɛ̃̀ wɔlɛ, ǹ sú gbô sɔkɔ tɛ̃̀-ò kṹmm ye ǹmɔlɛ. ");
INSERT INTO wib_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Képah ye, Liyel Pídĩ́-à yé wilki yɔ̃rɩ sɔkɔ, yé kɩ mɛ yé gblɔ̌y yõ kègbɩ tɛ̃̀ yõ. ");
INSERT INTO wib_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Mé pɩ̃ nɛ Abrahmɩ pétóbé-á yélɛ. Ǹtɛ yáh ńmɔ wɛlɔ yahle, képah ye yé kɔ̃ yé n yah n kɔ̃ ń kònmɔ-ńsahlɛ. ");
INSERT INTO wib_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ńmɔ-á nɛ̂ wɛ ń Sú Liyel tyɩ́, képah ye mé n yo. Yépi tɔ-á mó tyi nónó noh yé sú tyɩ́, sépi ye yé n pɩ.» ");
INSERT INTO wib_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Pǎh Yesu wɛy noh sɛ̃́, pè à syah nɛ, Abrahmɩ-á pépi súlɛ. Képah sɔkɔ, Yesu nɛ: «Yâh sõ̀ mɛ Abrahmɩ pétóbélɛ, yé náhkɩ mɛ Abrahmɩ tyípɩ́nɩ̀nɛ n pɩ. ");
INSERT INTO wib_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ǹtɛ núkúnúkú, ńmɔ nɛ̂-á gbɩ noh ń Sú Liyel tyɩ́ à yo yé tyɩ́, yé n yah n kɔ̃ ńmɔ kònmɔ-ńsahlɛ. Abrahmɩ náh sɛ̃́nkɔ̃ pɩ dò. ");
INSERT INTO wib_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Yépilɛ, yé sú tyípɩ́nɔ́ ye yé n pɩ.» Képah tɛ̃̀nɛ, pè à syah nɛ, fɔ̀fɩ́kɩ̀ pɩ́nɔ́ sɔkɔ náh pépi dubi dɛ́! Ńkɛ̃́ Sú núkú ó-á pépi tyɩ́, nɛ̂-á Liyellɛ. ");
INSERT INTO wib_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesu mɛ yo pé tyɩ́ nɛ: «Liyel tyɩ́ ye ńmɔ wil à pɔ. Ńmɔ náh pɔ ń gblɔ̌y yĩn yõ dɛ́! Ǹmɔ ye tɛkɩ mɔ ńnɛ. Ǹtɛ Liyel-à sõ̀ mɛ pɩ yé Súlɛ kègbɩ yõ sɔkɔ, ńmɔ tyɩ́ náhkɩ mɛ nɔ yé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Yé yahle ń wɛlɔ nóhnɔ́lɛ, képah ye yé náh ń wɛlɔ syɩ́kɩ́-ńtã̂n pɩ̃. ");
INSERT INTO wib_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Yépi súlɛ, sétã̀n yõ̀tɛ̃̀ ye ǹnɛ. Ǹmɔ dyɔ yĩ́ĩ́ tyi ye yé mɛ ké tyɩ́ nɛ yé nɛ n pɩ. Nɛ́kókè mɔ́-ò ye ǹnɛ ǹgbò dùkùlɛ. Wǎh pɩ gbɩ náh mɛ ǹ sɔkɔ, à náh mó gbɩ wɛ̃̀kɩ̀lɛ n kɔ póllɛ. Wǎh pɩ mɩ̀nɩ̀ yó-òlɛ, wàh mɩ̀nɩ̀nɛ n yo, ǎ kélɛ n yo à yɩ̃nɛ ǹ gblɔ̌y kèdùkùlɛ. Mɩ̀nɩ̀ yónɔ́ yõ wil ǹmɔ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ǹtɛ ńmɔ tɛ̃̀ wɔlɛ, ńmɔ gbɩlɛ n yo, képah ye yé náh mɛ sɛ̃ ń yõ. ");
INSERT INTO wib_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Yépi sɔkɔ nɛ̂ tɛ̃̀ kɩ fɛ̃ kè wɛ̃kɩ nɛ máh tyípékè pɩ? Ǹtɛ máh gbɩlɛ n yo, kwâh nɛ̂ pɩ tɛ́ yé náh sɛ̃ ń yõ? ");
INSERT INTO wib_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Liyel tyɩ́ névi-à névi nɛ̂nɛ, ǹmɔ Liyel wɛynɛ n noh n tɛ̃ n yĩn. Ǹtɛ Liyel tyɩ́ névye náh yépilɛ, képah ye yé kɔ̃ yé yahle sé nóhnɔ́lɛ.» ");
INSERT INTO wib_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Képah sɔkɔ, Nsyifunɔ Yesu syah nɛ, gbɩ kó mɛ pé tyɩ́ pé yo nɛ, Samari nɛy-á ǹnɛ, ànɛ̂ sétõ-á mɛ ǹ sɔkɔ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","À mɛ yo pé tyɩ́ nɛ: «Sétõ náh mɛ ńmɔ sɔkɔ. Ń Sú Liyel ye mé n gbilki, tɛ́ yépi mɛ ńmɔlɛ n yilɔ. ");
INSERT INTO wib_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ńmɔ náh mɛ n yah n kɔ̃ ń gblɔ̌y gbílkí-ńsahlɛ dɛ́. Ń gbílkí-ò ǹ gblɔ̌y ńmɔlɛ. Ǹmɔ ye gbɩ syínkɔ̃-òlɛ. ");
INSERT INTO wib_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Kègbɩgbɩ tɛ̃̀ yõ, mé kélɛ n yo yé tyɩ́, névi nɛ̂-à n sah ńmɔ yóré yõ, tɛ̃̀ náh kũ dɔ n yah n pi póllɛ.» ");
INSERT INTO wib_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Képah sɔkɔ, Nsyifunɔ à syah nɛ, páh pyě kè pɩ̃ yĩ́ĩ́ núkúnúkú tɛ̃̀nɛ nɛ sétõ-á mɛ ǹ sɔkɔ. Abrahmɩ-á ku, Liyel tɛ̃ntõ̀ syínyopu tɔ mɛ ku. Ǹtɛ ǹmɔ pɔ n yo nɛ, névi nɛ̂-à n sah péwɔ yóré yõ, tɛ̃̀ náh kũ dɔ n yah n pi nɩ? ");
INSERT INTO wib_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Pépi sú Abrahmɩ-á ku. Ǹtɛ ǹmɔ se mɛ n sõ nɛ páh kal Abrahmɩnɛ nɩ? Liyel tɛ̃ntõ̀ syínyopu tɔ mɛ ku. Tɛ́ ǹmɔ tɛ̃̀ se mɛ ǹ gblɔ̌ynɛ n yah nɛ́dúkú nɛ̂nɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Képah sɔkɔ, Yesu yo pé tyɩ́ nɛ: «Mâh náhkɩ sõ̀ mɛ ń gblɔ̌ynɛ n gbilki, yõ náh mɛ gbílkínɔ́ mɛ̀ tyɩ́. Ǹtɛ ń Sú Liyel ye n gbilki ńnɛ, ǹmɔ nɛ̂-á yé nɛ, yé Liyel-á ǹnɛ, ");
INSERT INTO wib_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","tɛ́ yé náh se mó tɔ̃ mɛ ǹnɛ n pnɛ. Ǹtɛ ńmɔ wɔ ǹnɛ n pnɛ. Mâh sõ̀ mɛ yo nɛ, mé náh ǹnɛ pnɛ, mé náhkɩ pɩ mɩ̀nyolɛ yé tyɩ́ kɔ̃lɛ. Ǹtɛ ńmɔ ǹnɛ n pnɛ, tɛ́ mɛ n sah ǹ yóré yõ. ");
INSERT INTO wib_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Yé sú Abrahmɩ sõ̀ mɛ nɩ̀vɩ̀nɩ̀ sɔkɔ nɛ, pé ńmɔ pɔ sõ gbĩ̀yĩ̀kì wɛ. À mɛ pɔ kè wɛ, kè pɩ nɩ̀vɩ̀nɩ̀nɛ ǹ tyɩ́.» ");
INSERT INTO wib_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Képah sɔkɔ, Nsyifunɔ mɛ à syah nɛ, ǹmɔ náh tɔ̃̌nɩ̀ ye tikininí pɔ́ gbãm wɛ, tɛ́ nɛ páh Abrahmɩ wɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","À mɛ yo pé tyɩ́ nɛ: «Kègbɩgbɩ tɛ̃̀ yõ, mé kélɛ n yo yé tyɩ́, Abrahmɩ-á pópó n dubi, Ńmɔ mɛ.» ");
INSERT INTO wib_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Wǎh képah yo sɛ̃́, pè núkú dyêh kwel ǹ tyɩ́ nɛ páh ǹnɛ n minki. Ǹtɛ à mɛ wɔ̃bɩ à wil Liyel ní-ńsah gbô sɔkɔ à sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Sõ yɔ́lɛ, Yesu sõ̀ mɛ n kɔ n sɔkɔ tɛ́ dĩ́ yɔ́ wɛ, nɛ̂-á sõ̀ mɛ yɩ̃́tũ̂nɛ ǹ dubi gbĩ́ dùkùlɛ. ");
INSERT INTO wib_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Képah sɔkɔ, Yesu tõ̀ sã́hpú à piki yah nɛ, pé kwɔ́-ò dĩ́, sɔ̃́ se pɩ tɛ́ dĩ́ mɛ̀ dubi yɩ̃́tũ̂nɛ nɩ? Ǹmɔ tyípékè pɩ́nɔ́ se, tĩ̂ ǹ dúbípú tyɩ́ se? ");
INSERT INTO wib_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","À mɛ yo pé tyɩ́ nɛ: «Ǹmɔ, képah náh pɩ ǹ dúbípú tyípékè pɩ́nɔ́ náh à kɔ̃ à dubi yɩ̃́tũ̂nɛ dɛ́! Kè ye pɩ Liyel tyípɩ́nɩ̀ wɛ̃kɩ yĩnnɛ ǹ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Nɛ̂-á tɛkɩ mɔ ńmɔlɛ, tyah kyòo sɔkɔ ye á yɩ̃nɛ à tõ̀lɛ n pɩ ǹ tyɩ́. Ńkɛ̃́ lékã̂h mɛ n pi, nɛ̂ sɔkɔ-á nɛy náh fɛ̃ tõ̀ pɩ n pi. ");
INSERT INTO wib_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Máh fyɔ̀ mɛ kèkõyṍ sɔkɔ, ńmɔ ye kèkõyṍ kyòolɛ ń mɛ gbĩ́ pól sɔkɔ.» ");
INSERT INTO wib_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Wǎh képah yo tɛ, à sĩn mɔ sétáh tɛ́ kè fãh à kele yɩ̃́tũ̂ dĩ́ yɩ̃́ yah. ");
INSERT INTO wib_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Tɛ́ mɛ yo ǹ tyɩ́ nɛ à kyɩ ǹ yah wu pɛ́kɩ̀ tũ̀nsàhnɔ́ yɔ́ ni sɔkɔ, nɛ̂-á pè n ye Silowelɛ. Silowe kɔ́r ye Tɛ̃ntõ̀ névilɛ. Yɩ̃́tũ̂ dĩ́ mɛ sɔkɔ à kyɩ ǹ yah wu nɛ́npɔ́. Wǎh ǹ syɩ n pi gbĩ́ nɛ̂nɛ, à sõ̀ mɛ n yah. ");
INSERT INTO wib_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Képah sɔkɔ, ǹ tnɔ̂ tɛ̃̀pu ànɛ̂ nónó-á ńkɛ̃́nɛ ǹnɛ n wɛ à n nɛ mɛ n ni n syi, pǎh à wɛ pè mɛ yo tũ nɛ, dĩ́ mɛ̀ kó ńkɛ̃́nɛ n kɔ̃ n tɛ̃ nɛ n ni n syi yɔ̀ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Túkù nɛ ǹmɔ-á, túkù mó nɛ ǹmɔ náh, yã̀hnkõ-á à tɔ. Pǎh mɛ képah sɔkɔ, dĩ́ mɛ yo pé tyɩ́ nɛ péwɔ-á tɔ́tɔ́. ");
INSERT INTO wib_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Wǎh yo sɛ̃́, pè mɛ à piki yah nɛ, ǹ yɩ̃́ se pɩ sɔ̃́ tɛ́ yɩkɩ mɔ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","À mɛ yo pé tyɩ́ nɛ, dĩ́ nɛ̂-á pè n ye Yesulɛ, ǹmɔ-á fã̀hkɩ̀ pɩ, tɛ́ kè kele pé yɩ̃́ yah, tɛ́ nɛ pé kyɩ pé yah wu Silowe yɔ sɔkɔ. Pé mɛ sɔkɔ kyɩ pé yah wu nɛ́npɔ́, pé mɛ fɛ̃ n yah. ");
INSERT INTO wib_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Pè mɛ à syah nɛ, kénɛ dĩ́ se mɛ ńyãh nɩ? À mɛ nɛ pé náh pɩ̃. ");
INSERT INTO wib_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Képah sɔkɔ, yɩ̃́tũ̂ dĩ́ nɛ̂ yɩ̃́-á yɩkɩ mɔ, pè à tɛ̃ pɔ Farisi wɛ̃̀kɩ̀ kɔ́pú tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Tɛ́ mɩ mɩ yòh sõ ye mó tɔ̃ lésõ Yesu fã̀hkɩ̀ pɩ à dĩ́ yɩ̃́ yɩkɩ mɔ. ");
INSERT INTO wib_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Képah sɔkɔ, Farisi wɛ̃̀kɩ̀ kɔ́pú dĩ́ piki yah nɛ, sɔ̃́ se kè pɩ tɛ́ à fɛ̃ n yah núkúnúkú nɩ? À mɛ yo pé tyɩ́ nɛ, fã̀hkɩ̀-á à pɩ kele pé yɩ̃́ yah, tɛ́ pé mɛ kyɩ pé yah wu, pé mɛ fɛ̃ n yah. ");
INSERT INTO wib_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Képah tɛ̃̀nɛ, Farisi wɛ̃̀kɩ̀ kɔ́pú túkù sõ̀ mɛ n yo nɛ ńkɛ̃́, dĩ́ mɛ̀ náh fyɔ̀ mɛ mɩ mɩ yòh tɛ̃̀ dêllɛ n tɛ̃, képah-á n wɛ̃kɩ nɛ à náh wil Liyel tyɩ́. Ǹtɛ pé túkù mó mɛ n yo nɛ, tyípêl pɩ́-ò se kɩ fɛ̃ gbǐl nɔ́pi dùkù pɩ sɔ̃́ nɩ? Kǎh pɩ sɛ̃́, pé sõnɔ pɩ sé tyɩ́ tyɩ́lɛ. ");
INSERT INTO wib_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Pè mɛ tɔ̃ pé syɩ dĩ́ mɛ̀ syah nɛ, nɛ̂-á yɩkɩ mɔ ǹ yɩ̃́lɛ, ǹmɔ se kɩ yo sɔ̃́ tɛ̃̀ tyɩ́ sɔkɔ nɩ? Dĩ́ mɛ nɛ, Liyel tɛ̃ntõ̀ syínyo-ò-á ǹnɛ. ");
INSERT INTO wib_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ǹtɛ Nsyifunɔ yõ̀tãm náh sõ̀ mɛ ké tyɩ́ nɛ pé sɛ̃ ké yõ nɛ, yɩ̃́tũ̂-á sõ̀ ǹnɛ, tɛ́ núkúnúkú à mɛ n yah. Kǎh pɩ sɛ̃́, pè ǹ dúbípú ye pɔ, ");
INSERT INTO wib_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","à pɔ pè piki yah nɛ, pépi pídĩ́ se dĩ́ mɛ̀nɛ nɩ? À se dubi yɩ̃́tũ̂nɛ nɩ? Ǹtɛ à se pɩ sɔ̃́ tɛ́ fɛ̃ n yah núkúnúkú nɩ? ");
INSERT INTO wib_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ǹ dúbípú mɛ yo pé tyɩ́ nɛ, páh pɩ̃ nɛ pépi pídĩ́-á ǹnɛ; wǎh dubi yɩ̃́tũ̂nɛ. ");
INSERT INTO wib_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ǹtɛ tir nɛ̂ tɛ̃̀ wɔ-á pɩ tɛ́ à fɛ̃ n yah núkúnúkú, pépi náh képah wɔ pɩ̃, pé náh se mó tɔ̃ pɩ̃ nɛ̂-á yɩkɩ mɔ ǹ yɩ̃́lɛ. Ńkɛ̃́ pè à piki yah, wɛ̃́npir náh tɔ̃ ǹnɛ; wǎh kɩ fɛ̃ ké yah yo ǹ gblɔ̌y. ");
INSERT INTO wib_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Nsyifunɔ yõ̀tãm tiki sõ̀ mɛ pè tɛ̃, képah ye pè kɔ̃ pè n wɛkɩ sɛ̃́. Nsyifunɔ yõ̀tãm sõ̀ mɛ ké yo sah tɛ nɛ, névi nɛ̂-à kɩ nɛ Liyel nɛy yáhntɔkɔnɔ-á Yesulɛ, tɛ̃̀-á kɩ yĩni wilki pépi wɛ̃̀kɩ̀ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Képah ye, ǹ dúbípú kɔ̃ pè nɛ, wɛ̃́npir náh tɔ̃ ǹnɛ, pè à piki yah. ");
INSERT INTO wib_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Képah sɔkɔ, Farisi wɛ̃̀kɩ̀ kɔ́pú tɔ̃ dĩ́ mɛ̀ ye yah kɛ ní-òlɛ nɛ̂-á lésõ yɩ̃́tũ̂nɛ, tɛ́ yo ǹ tyɩ́ nɛ, ké Liyel wɛ̃̀kɩ̀ tɛ̃̀ yõ, à gbɩ yo pé syah. Pépi-á pɩ̃ nɛ ǹ yɩ̃́ yɩ́kɩ́nmɔ-ò dĩ́ mɛ̀nɛ, tyípêl pɩ́-ò-á ǹnɛ. ");
INSERT INTO wib_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Dĩ́ mɛ nɛ, pé náh pɩ̃ tyɩ́pêl pɩ́-ò-à kɩ nɛ̂ ǹnɛ dɛ́! Tyínúkú ó-á péwɔ n pnɛ: Yɩ̃́tũ̂-á sõ̀ pélɛ, ǹtɛ núkúnúkú páh mɛ n yah. ");
INSERT INTO wib_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Pè mɛ à piki yah nɛ, tir nɛ̂ se Yesu pɩ ǹ tyɩ́ nɩ? Dùkù nɛ̂ se à yɩkɩ mɔ ǹ yɩ̃́lɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Dĩ́ mɛ nɛ, páh sõ̀ kè yo tɛ pé tyɩ́, tɛ́ pè náh pé níkí sah kè noh. Ǹtɛ sɔ̃́ se tɛ́ pè tɔ̃ mɛ ké tyɩ́ nɛ, pé kè yo pé noh kɛ ní-òlɛ nɩ? Pépi tɔ́ se pyě mɛ n yah n kɔ̃ nɛ, pé pɩ ǹ tõ̀ sã́hpúlɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Képah tɛ̃̀ sɔkɔ, pè tyah ǹnɛ n gbyɔ, tɛ́ nɛ ńkɛ̃́, ǹmɔ-á kénɛ dĩ́ tõ̀ sã́h-òlɛ dɛ́! Pépi tɛ̃̀ wɔlɛ, Moyisi tõ̀ sã́hpú-á pépilɛ. ");
INSERT INTO wib_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Páh pɩ̃ nɛ Liyel-á yo mɔ Moyisi tyɩ́. Ǹtɛ dĩ́ mɛ̀nɛ, pé se ǹ wìl-ǹsah ńtɛ̃nɛ n pnɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Pǎh yo sɛ̃́, dĩ́ mɛ yo pé tyɩ́ nɛ, é! Tɛ́ képah-á pyě pɩ gbɛ̃̀ndùnìnɛ yɔ̀ sɔ̃́. Pépi náh ǹ wìl-ǹsah pɩ̃ pè yo. Ǹtɛ wǎh péwɔ yɩ̃́ yɩkɩ mɔ dɛ́! ");
INSERT INTO wib_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Pé pól-á pɩ̃ nɛ, Liyel náh tyípêl pɩ́-ò nírílɛ n tɛ̃. Ǹtɛ névi nɛ̂-à pɩ nɛ́gbɩ́lɛ, tɛ́ Liyel dyɔ yĩ́ĩ́ tyilɛ n pɩ, ǎ tɛ̃̀ wɔ nírílɛ n tɛ̃. ");
INSERT INTO wib_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ǹtɛ kèkõyṍ-á mɛ sɔ̃́, pépi náh kè noh yah nɛ, ǹnɩ̂-á yɩ̃́tũ̂ yɔ́ yɩ̃́ yɩkɩ mɔ, nɛ̂-á dubi yɩ̃́tũ̂nɛ dɛ́! ");
INSERT INTO wib_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Dĩ́ mɛ̀-à sõ̀ mɛ wìl-ǹkɛ̃̂nɛ Liyel tyɩ́, à náh náhkɩ fɛ̃ tir yɔ́ ńtɛ̃ pɩ n pi dò! ");
INSERT INTO wib_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Képah tɛ̃̀nɛ, pè à syah nɛ, ǹmɔlɛ dubi ǹ tɔ̂ɔ́ tyípékè ó sɔkɔ, tɛ́ ǹmɔ kɩ pɔ nɛ páh pépilɛ n kwɔ nɩ? Tɛ́ núkú à yĩni wilki kégbɔ́. ");
INSERT INTO wib_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Képah sɔkɔ, Yesu-á kè noh nɛ pǎh dĩ́ yĩni, à kyɩ à yohnɩ tɛ́ à piki yah nɛ: «Á se sɛ̃ Névi Pídĩ́ yõ?» ");
INSERT INTO wib_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Dĩ́ mɛ nɛ, pé yõ̀tɛ̃̀, nɛ̂ se Névi Pídĩ́ mɛ̀nɛ nɩ? À ǹ tyɩ́ yo pé syah, pé kɔ̃ pé wɛ sɛ̃ ǹ yõ. ");
INSERT INTO wib_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Képah tɛ̃̀nɛ, Yesu mɛ yo ǹ tyɩ́ nɛ: «Á ye à wɛ tɛ. Ǹmɔ ye n yãh álɛ núkúnúkú yɔ̀.» ");
INSERT INTO wib_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Dĩ́-á képah noh sɛ̃́, à nɛ páh sɛ̃ ké yõ, Tɛ̃̀ ǹgbɛ̃. Tɛ́ mɛ gbètukunɔ di Yesu yah, à à gbilki. ");
INSERT INTO wib_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Képah sɔkɔ, Yesu nɛ: «Gbɩ wah yĩn ye ńmɔ pɔ kèkõyṍ mɛ̀ sɔkɔ; nɛ yɩ̃́tũbi yɩ̃́ yɩkɩ mɔ, tɛ́ nónó-á mɛ n yah pépi pɩ yɩ̃́tũbilɛ.» ");
INSERT INTO wib_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Képah sɔkɔ, Farisi wɛ̃̀kɩ̀ kɔ́pú nónó-á sõ̀ mɛ ànɛ̂ Yesulɛ, pépi-á wɛlɔ nɔ́pi noh, pè Yesu piki yah nɛ, ǹtɛ yɩ̃́tũbi se pyě pépi tɔlɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesu mɛ yo pé tyɩ́ nɛ: «Yâh sõ̀ mɛ yɩ̃́tũbilɛ, tyípékè náh náhkɩ n mɛ n pi yé yõ. Ǹtɛ núkúnúkú yé nɛ yáh mɛ n yah, képah ye yé tyípékè mɛ yé yõ.» ");
INSERT INTO wib_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Képah náh, Yesu tɔ̃ yo pé tyɩ́ nɛ: «Kègbɩgbɩ tɛ̃̀ yõ, mé kélɛ n yo yé tyɩ́, névi nɛ̂-à n dé-ńkɛ̃̂nɛ képyɛ́nɩ̀ tũ̀ yahlɛ, tɛ́ n dɔkɔ n de ké sɔkɔ ké gbɔ̀pɔ yɔ́lɛ, yɛ̃́nwó ye tɛ̃̀nɛ, névi yõ syɩ́kɩ́-ò tɔ̃ ǹnɛ. ");
INSERT INTO wib_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ǹtɛ nɛ̂-à n de ké yahlɛ, képyɛ́nfɛ̃ ye tɛ̃̀ wɔlɛ. ");
INSERT INTO wib_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Tũ̀ syɩ́kɩ́-ò dĩ́ ké yah yɩkɩ n mɔ ǹmɔ kɔ̃. Ǹ képyɛ́nɩ̀ ǹ yĩ́nɛ n pnɛ. Wàh de, ǹ tyɩ́-á képyɛ́nɩ̀ nónónɛ, ǎ sé ye n wil sé yninɛ kégbɔ́. ");
INSERT INTO wib_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ǹ képyɛ́nɩ̀-á ǹ yĩ́nɛ n pnɛ sɛ̃́, képah ye wàh sé pól wilki mɔ tɛ, à n yĩn sé yah, tɛ́ sě ǹ sõ̀ tɛ̃. ");
INSERT INTO wib_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ǹtɛ sàh névi nɛ̂ yĩ́nɛ n pnɛ̀-ǹkɛ̃̂nɛ, sè náh tɛ̃̀ sõ̀lɛ n tɛ̃ póllɛ. Sè n to n gbɛ n mɔ fɩ́ɩ́ ǹnɛ ńtɛ̃nɛ.» ");
INSERT INTO wib_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu kénɛ sèmìrkì yãh tɔ́wû tyɩ́, ǹtɛ pè náh ké kɔ́r pɩ̃. ");
INSERT INTO wib_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Képah sɔkɔ, Yesu tɔ̃ yo pé tyɩ́ nɛ: «Kègbɩgbɩ tɛ̃̀ yõ, mé kélɛ n yo yé tyɩ́, ńmɔ ye képyɛ́nɩ̀ tũ̀ yahlɛ. ");
INSERT INTO wib_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Nónó pól-á ń dyàh tɛ̃ pɔ sɔkɔ tɛ, yɛ̃́nwóbé ànɛ̂ névye yõ syɩ́kɩ́pú ye pélɛ. Ǹtɛ, képyɛ́nɩ̀ náh mó fɛ̃ syi noh pé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ńmɔ ye dénsahlɛ. Névi nɛ̂-à de képahlɛ, tɛ̃̀ kɩ pwah. Tɛ̃̀ kɩ fɛ̃ n de, tɛ́ kɩ ǹnɛ n syɩ n wil kɩ ǹ yõkelɛ n wɛ. ");
INSERT INTO wib_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Tɛ́ yɛ̃́nwó wɔ-à n pi, yɩ̃be, ànɛ̂ nɛ́kókè mɔ́nɔ́, ànɛ̂ yényêh pɩ yĩn ó ye à n pɔ. Ǹtɛ ńmɔ pɔ nɛ névye min wɛ, nɛ̂-á plɛ yĩ́ĩ́. ");
INSERT INTO wib_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Képyɛ́nfɛ̃ pèpɛy ye ńmɔlɛ. Kàh sɔ̃́ n nɔ kũ tyɩ́, képyɛ́nfɛ̃ pèpɛy n fɛ̃ n syi ǹ min kɔ̃ ǹ képyɛ́nɩ̀ yĩnnɛ. ");
INSERT INTO wib_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ǹtɛ pɔ́ yáhnkɔ̃-ò képyɛ́nfɛ̃ tɛ̃̀ wɔlɛ, képyɛ́nfɛ̃ kègbɩ náh ǹmɔlɛ dɛ́! Ǹmɔ yɛ̃́ngbɛ̃́ tyɩ́ náh képyɛ́nɩ̀ nɔ́pilɛ. Képah ye, wàh fyɔ̀ gbɛ̃́npã̂h wɛ à n pi, à n to ǹ tɛ́ képyɛ́nɩ̀ milki, à kɔ̃ à n pɔ n tɛ̃ sé sɔkɔ, sé tɛ́lɔ́ n mó n to n karkɩ. ");
INSERT INTO wib_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Pɔ́ ó kɔ́kɔ́ ye ǹmɔ n yah n kɔ̃ dò. Yɩ́kɩ́nɔ́-à sɔ̃́ n pɩ képyɛ́nɩ̀ sɔkɔ, kè náh n pɩ tirlɛ ǹmɔ yah. ");
INSERT INTO wib_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Képyɛ́nfɛ̃ pèpɛy ye ńmɔlɛ. Sɔ̃́-á Sú Liyel ńnɛ n pnɛ, tɛ́ ń tɔ ǹnɛ n pnɛ, sɛ̃́ ó ye, mé ń képyɛ́nɩ̀nɛ n pnɛ, sé tɔ mó ńnɛ n pnɛ. Ńmɔ kɩ ń min kɔ̃ ń képyɛ́nɩ̀ yĩnnɛ. ");
INSERT INTO wib_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Képyɛ́nɩ̀ túkù mɛ ń tyɩ́, nónó-á sè náh mɛ tũ̀ mɛ̀ sɔkɔ. Sè kɩ n noh n pi ń tyɩ́. Mé yɩ̃nɛ mè n kyɩ sè yah n fɛ̃ fɛ̃ n pɔ n kwrɔ n mɔ sè pɩ tũ núkúlɛ, képyɛ́nfɛ̃ núkú ó mó sélɛ n fɛ̃. ");
INSERT INTO wib_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ńmɔ kɩ ń min kɔ̃ kũ sɔkɔ, tɛ́ kɩ tɔ̃ pɔ kè syi n pi. Képah ye, ń tyɩ́ nɔ Sú Liyel tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nɛy náh fɛ̃ ń ko n mɔ n pi dɛ́! Ńmɔ ye n kɔ̃ ń minnɛ ń gblɔ̌y. Tɛ̃́nwɛnɔ mɛ ń tyɩ́ kɩ fɛ̃ kè kɔ̃, tɛ̃́nwɛnɔ tɔ̃ mɛ ń tyɩ́ kɩ fɛ̃ kè syi ńtɔ̃. Sɛ̃́ ye ń Sú Liyel nɛ mé pɩ.» ");
INSERT INTO wib_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Képah tɛ̃̀nɛ, Nsyifunɔ-á wɛlɔ nɔ́pi noh sɛ̃́, pé sõnɔ tɔ̃ kah pɩ sé tyɩ́ tyɩ́lɛ. ");
INSERT INTO wib_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Pé náhnáh tyah n yo nɛ ńkɛ̃́, sétõ yɔ́-á mɛ ǹ sɔkɔ, ǹ yõ̀gbèkè kɔ̃ kè yuku. Yõ se tɔ̃ mɛ ké tyɩ́, pè ǹ wɛlɔlɛ n nohnɩ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ǹtɛ túkù mó nɛ ńkɛ̃́, yõ̀gbèkè yúkú-ò wɛlɔ náh wɛlɔ nɔ́pilɛ dɛ́! Yõ̀gbèkè yúkú-ò se kɩ fɛ̃ yɩ̃́tũ̂ yɩ̃́ yɩkɩ mɔ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Képah sɔkɔ, kwɔ̀vɩrɩ gbĩ́nɛ, syáh yɔ́ sõ̀ mɛ n syah Yerusalɛmɩ sɔkɔ, nɛ̂-á Nsyifunɔ dyɔlɛ n to n kõ Liyel ní-ńsah gbô tɔ̃́nsàhnsɔkɔnɔ tyɩ́lɛ. ");
INSERT INTO wib_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Képah sɔkɔ, Yesu sõ̀ mɛ n kɔ n kɔ̃ Liyel ní-ńsah gbô párn yɔ́ sõ̀, nɛ̂-á pè n ye Salomo párnnɛ. ");
INSERT INTO wib_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Nsyifunɔ yísyɔ́ mɛ pɔ à mɔ gbɩ̃ tɛ́ yo ǹ tyɩ́ nɛ, à se kɩ pépi mɔ sah tɔ̀tɔ̀ sɔkɔ, pópó kɩ pɔ nɔ gbĩ́ nɛ̂ tyɩ́ nɩ? Ǹmɔ-à kɩ nɛ̂ Liyel nɛy yáhntɔkɔnɔlɛ, à kè yo n dal n mɔ pé syah kɛ̀! ");
INSERT INTO wib_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","À mɛ yo pé tyɩ́ nɛ: «Mé kè yo tɛ yé tyɩ́, ǹtɛ yé náh sɛ̃ ké yõ. Tyi nónó-á mé mɛ n pɩ ń Sú Liyel yĩn yõ, sépi ye mɛ ń tyɩ́lɛ n yo n wah. ");
INSERT INTO wib_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ǹtɛ yé náh pɩ ńmɔ képyɛ́nɩ̀nɛ sɛ̃́, képah ye yé kɔ̃ yé náh sɛ̃ ké yõ. ");
INSERT INTO wib_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ńmɔ képyɛ́nɩ̀ tɛ̃̀ wɔ ń wɛynɛ n nohnɩ, mé sélɛ n pnɛ, ànɛ̂ sě ń sõ̀ tɛ̃. ");
INSERT INTO wib_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Mé kɩ tyɛ́-ńkɛ̃̂ minnɛ sè kɔ̃. Sé tyɩ́ náh n yɩkɩ n yah n pi, ànɛ̂ ǹnɩ̂ yɔ́ ńtɛ̃ náh fɛ̃ sè tɛ̃ n syi ń gbõ̀. ");
INSERT INTO wib_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ńmɔ Sú nɛ̂-á sélɛ ń gbõ̀ dahbɩ, ǹmɔ kal yíyìn póllɛ. Képah ye, ǹnɩ̂ yɔ́ ńtɛ̃ náh fɛ̃ sè tɛ̃ n syi ǹmɔ gbõ̀ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ńmɔ ànɛ̂ Sú Liyel mɛ núkúlɛ.» ");
INSERT INTO wib_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Képah tɛ̃̀nɛ, Nsyifunɔ tɔ̃ dyêh tõ nɛ páh Yesulɛ n min n ko. ");
INSERT INTO wib_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ǹtɛ à mɛ yo pé tyɩ́ nɛ, Sú Liyel gbõ̀ yõ, páh tyípéplɔ náhnáh pɩ pè wɛ. Sépi sɔkɔ nɛ̂ tɛ̃̀ yĩn se pè n yah n kɔ̃ pé mínnkò-ǹsahlɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Nsyifunɔ mɛ à syah nɛ, tyípépɛ̌y pɩ́nɔ́ yĩn náh pé nɛ páh ǹnɛ n min n ko dɛ́! Ǹtɛ wǎh yo de Liyel tyɩ́ képah yĩn-á. Ǹmɔ névi gbɔy kɩ pɔ ǹ gblɔ̌ynɛ n pɩ Liyellɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Képah sɔkɔ, à yo pé tyɩ́ nɛ: «Kè náh mɛ wã́rkɩ́nsàhnɔ́lɛ Liyel wɛy sɛ́bɛ́y sɔkɔ nɛ, Liyel-á nɛ líyelnɔ́-á yélɛ di? ");
INSERT INTO wib_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Liyel-á yo mɔ névye nónó tyɩ́, à pè ye líyelnɔ́lɛ. Ǹtɛ yé se pɩ̃ nɛ Liyel wɛy sɛ́bɛ́ynɔ́-á nɛ̂ yo, kè náh fɛ̃ n milki n pi tɛ́! ");
INSERT INTO wib_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Tɛ́ Sú Liyel-á ńmɔ nɛ̂ wilki sah ǹ tyɩ́ yõ, tɛ́ ń tɛkɩ mɔ kèkõyṍ, yé nɛ máh yo de Liyel tyɩ́, máh sɔ̃́npɩ́lɛ yo nɛ Liyel Pídĩ́-á ńnɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Máh kɩ mɛ ń Sú Liyel tyípɩ́nɩ̀nɛ n pɩ́-ńkɛ̃̂nɛ, yé káh sɛ̃ ń yõ. ");
INSERT INTO wib_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ǹtɛ máh kɩ mɛ sélɛ n pɩ, yáh kɩ sɔ̃́ mɛ n sɛ̃ n pi ńkɛ̃̂nɛ ńmɔ yõ, yé sɛ̃ sépi tɛ̃̀ wɔ yõ; képah sɔkɔ yé kɩ pɩ̃ yĩ́ĩ́ nɛ, máh mɛ núkúlɛ Sú Liyellɛ, ànɛ̂ Sú Liyel-á mɛ núkúlɛ ńnɛ.» ");
INSERT INTO wib_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Képah tɛ̃̀nɛ, pè tɔ̃ nɛ páh Yesulɛ n tɛ̃. Ǹtɛ à pwah pé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Képah náh, Yesu tɔ̃ ǹ syɩ yuku Nsyurdɛ̃ yɔ́nkahnɩnɛ, à kyɩ tɛ̃ ńyãh sɔkɔ-á Nsyɔ̃ ǹgbò tyah névye wèlnwílkìnɔ́lɛ. ");
INSERT INTO wib_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Névye náhnáh mɛ kyɩ ǹ tnɔ̂, tɛ́ mɛ yo tũ nɛ, Nsyɔ̃ náh gbǐl tir yɔ́ ńtɛ̃ pɩ. Ǹtɛ wǎh tyi nónó pól yo dĩ́ mɛ̀ tyɩ́ sɔkɔ, gblɔ-á sélɛ. ");
INSERT INTO wib_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Képah sɔkɔ, névye náhnáh mɛ sɛ̃ Yesu yõ nɛ́npɔ́. ");
INSERT INTO wib_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Dĩ́ yɔ́ lésõ mɛ ńyân syɩkɩ, pè n ye Lasarɩlɛ. À sõ̀ mɛ Betani kwil sɔkɔ, képah nɛ̂ sɔkɔ-á sõ̀ ǹ dósyɔ́lɛ, pè n ye Mari ànɛ̂ Martɩlɛ. ");
INSERT INTO wib_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Kénɛ Mari mɛ̀ wɔ ye lésõ làsèkwěl yɔ́ kwɛ mɔ Yesu gbyẽ̂h yõ, tɛ́ sè kele ǹ yõ̀yénnɛ. Ǹmɔ dódĩ́ Lasarɩ ye sõ̀ n yɔ. ");
INSERT INTO wib_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Képah sɔkɔ, ǹ dósyɔ́ mɛ tɛ̃ntõ̀ mɔ Yesu tyɩ́ nɛ, pé yõ̀tɛ̃̀, ǹ kódĩ́ Lasarɩ náh mɛ lènɔlɛ. ");
INSERT INTO wib_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesu-á képah noh, à nɛ ńkɛ̃́, Lasarɩ ńyân mɛ̀ náh pɩ ǹ ko ko ńyânnɛ. Ǹtɛ kǎh kɩ Liyel yõ̀tɔ̃rɩ́ wɛ̃kɩ, tɛ́ kɩ tɔ̃ ǹ Pídĩ́ yõ̀tɔ̃rɩ́ wɛ̃kɩ. ");
INSERT INTO wib_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Tɛ́ Martɩ, ànɛ̂ Mari, ànɛ̂ pé dódĩ́ Lasarɩ tyɩ́ sõ̀ nɔ yĩ́ĩ́ Yesu tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ǹtɛ ńyãh sɔkɔ-á sõ̀ Yesulɛ tɛ́ pè pɔ Lasarɩ ńyân tyɩ́ yo ǹ tyɩ́, à tɔ̃ wũ nɛ́npɔ́ à sèpĩ̀n nínì pɩ. ");
INSERT INTO wib_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Képah náh, à yo ǹ tõ̀ sã́hpú tyɩ́ nɛ, pè yɛ pé pé syɩ n yuku Nsyude gbɛ̃̀nyah sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Wǎh yo sɛ̃́, pè mɛ nɛ, kwɔ́-ò dĩ́, nɛ́npɔ́ sɔkɔ kó lésõ pè n yah n kɔ̃ ǹ mínkò-ǹsahlɛ dyêhlɛ sɛ̃́ yɔ̀ sɛ̃́ yɔ̀, tɛ́ à tɔ̃ n yah n kɔ̃ ǹ syɩ́nyuku-ńsahlɛ nɛ́npɔ́ sɔkɔ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","À mɛ yo pé tyɩ́ nɛ, lɛ́rɩ́nɔ́ gbɔ̃ninɔ́ kó gbĩ̀yĩ̀kì sɔkɔ nɩ? Névi nɛ̂-à n kɔ tyah kyòolɛ, kèkõyṍ kyòo-á à n nɛ n yah. Képah-á, tɛ̃̀ gbáhkɩ̀ mɩ́nɔ́ náh nɔ. ");
INSERT INTO wib_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ǹtɛ névi nɛ̂-à n kɔ lékã̂hnɛ kyòo kɛ̃́nɛ, tɛ̃̌ ǹ gbáhkɩ̀lɛ n mɩ. ");
INSERT INTO wib_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Wɛlɔ nɔ́pi yóntɛnɔ náh, Yesu tɔ̃ yo pé tyɩ́ nɛ, pépi kódĩ́-á mɛ dɔy sɔkɔ, ǹtɛ páh kɩ kyɩ à yilki mɔ. ");
INSERT INTO wib_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Képah sɔkɔ, ǹ tõ̀ sã́hpú mó nɛ Tɛ̃̀ ǹgbɛ̃, dɔy sɔkɔ-à kɩ nɛ̂ Lasarɩlɛ, wǎh kɩ dɛ. ");
INSERT INTO wib_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ǹtɛ Yesu wɛy sɔkɔ, Lasarɩ kúnɔ́ tyɩ́ ye à yo, tɛ́ ǹ tõ̀ sã́hpú wɔ mó wɛ nɛ dɔy gbɔy tyɩ́-á à yo. ");
INSERT INTO wib_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Kǎh pɩ sɛ̃́, Yesu kè yo yɩkɩ mɔ pé tyɩ́ nɛ Lasarɩ-á ku. ");
INSERT INTO wib_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ǹtɛ péwɔ mɛ́-ńkɛ̃̂nɛ sõ̀ nɛ́npɔ́, képah-á mɛ nɔ yĩ́ĩ́ péwɔ tyɩ́ pépi yĩnnɛ. Kǎh pɩ sɛ̃́, pǎh kɩ sɛ̃ yĩ́ĩ́ péwɔ yõ. Tɛ́ núkúnúkú, pè yɛ pé sɔkɔ ǹ tnɔ̂. ");
INSERT INTO wib_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Képah sɔkɔ, Toma nɛ̂-á pè n ye Didiminɛ, ǹmɔ pé no syah nɛ, pè yɛ pépi tɔ kyɩ ku ǹnɛ wɛ̃ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yesu-á yĩni tɛ̃ nɛ́npɔ́ gbĩ́ nɛ̂nɛ, à kyɩ nɛ yah Lasarɩ lékó sõ̀ sèpĩ̀n ǹyẽ̂h pɩ tɛ diki sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Yé yah, Betani ànɛ̂ Yerusalɛmɩ wrɔ́ náh sõ̀ mɛ kah gbɛ mɔ. Kè sõ̀ mɛ kílónɔ́ tɔ̃́nɔ́ kénkɔ̃lɛ. ");
INSERT INTO wib_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Képah ye, Yerusalɛmɩ tãn náhnáh sõ̀ mɛ pɔ Martɩ ànɛ̂ Mari yétĩ kélé-ńsah pé dódĩ́ yáhnkwlɔnɔ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Martɩ-á fyɔ̀ noh nɛ Yesu-á mɛ n pi, à kyɩ à yohnɩ. Tɛ́ Mari wɔ sõ̀ mɛ kɔ̃́ntɛ̃̀nɔ́lɛ gbô sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Képah sɔkɔ, Martɩ mɛ yo Yesu tyɩ́ nɛ, pé yõ̀tɛ̃̀, wàh sõ̀ mɛ ásõ̂ sɔkɔ, pé dódĩ́ náh náhkɩ n ku n pi. ");
INSERT INTO wib_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ǹtɛ núkúnúkú ńtɛ̃ fyé sɔkɔ, páh pɩ̃ nɛ wàh kɩ sɔ̃́ tir dùkù nɛ̂ yah kɔ̃ Liyel tyɩ́, wǎh kɩ kè pɩ ǹ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Képah sɔkɔ, Yesu mɛ yo ǹ tyɩ́ nɛ: «Á dódĩ́ lékó kɩ yilki mɔ.» ");
INSERT INTO wib_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Wǎh yo sɛ̃́, Martɩ nɛ, páh pɩ̃ nɛ lékyɩ̂-à kɩ pɔ n yilki n mɔ gbĩ̀yĩ̀kì tɛ́y sõlɛ, ǹ tɔ lékó-á kɩ yilki mɔ. ");
INSERT INTO wib_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Képah tɛ̃̀nɛ, Yesu yo ǹ tyɩ́ nɛ: «Ńmɔ ye lékyɩ̂ yílkínmɔ-ò ànɛ̂ minnɛ. Névi nɛ̂-à sɛ̃ ńmɔ yõ, tɛ̃̀-à sɔ̃́ ku, à kɩ tyɛ́-ńkɛ̃̂ min wɛ; ");
INSERT INTO wib_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ànɛ̂ névi nɛ̂-à mɛ min sɔkɔ tɛ́ sɛ̃ ńmɔ yõ, tɛ̃̀ náh tɔ̃ n ku n yah n pi Liyel tyɩ́ tĩ̀nnɛ. Á se sɛ̃ képah yõ, Martɩ?» ");
INSERT INTO wib_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Martɩ mɛ nɛ, àwe-á Tɛ̃̀ ǹgbɛ̃, páh sɛ̃ ké yõ nɛ ǹmɔ-á Liyel nɛy yáhntɔkɔnɔlɛ, nɛ̂-á ǹ Pídĩ́nɛ, ǹmɔ nɛ̂-á sõ̀ yɩ̃nɛ à pɔ kèkõyṍ. ");
INSERT INTO wib_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Képah yóntɛnɔ náh, à ǹ syɩ kyɩ plɔ yo ǹ gbɛ̃̀nsê Mari tyɩ́ nɛ, kwɔ́-ò dĩ́-á mɛ de n tɛ. Tɛ́ wǎh mɛ ǹnɛ n ye. ");
INSERT INTO wib_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mari-á fyɔ̀ képah noh, à núkú yuku à sɔkɔ Yesu tnɔ̂. ");
INSERT INTO wib_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yesu náh tɔ̃̌nɩ̀ sõ̀ mɛ de kwil sɔkɔ. À sõ̀ mɛ fɩ̃́ nɛ̂ sɔkɔ-á sõ̀ Martɩ pɔ à yohnɩ. ");
INSERT INTO wib_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Tɛ́ Yerusalɛmɩ tãn nónó-á sõ̀ mɛ Mari tnɔ̂ gbô sɔkɔ, mɛ ǹ yétĩnɛ n kele, pépi-á à wɛ à yuku wil súú sɛ̃́, pè ǹ sõ̀ tɛ̃. Pè sõ̀ mɛ n sõ nɛ, pɔ̀ gbó-ńsah-á à n yuku diki yõ. ");
INSERT INTO wib_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ǹtɛ Mari-á kyɩ yĩni tɛ̃ Yesu mɛ́-ńsah sɔkɔ, tɛ́ à wɛ, à gbètukunɔ di Yesu yah sɔkɔ tɛ́ yo ǹ tyɩ́ nɛ, pé yõ̀tɛ̃̀, wàh sõ̀ mɛ ásõ̂ sɔkɔ, pé dódĩ́ náh náhkɩ n ku n pi. ");
INSERT INTO wib_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Képah sɔkɔ, Yesu-á à wɛ à mɛ n gbo à tahlɩ ǹ tɛ́kɩ́nmɔpu tyɩ́, kè ǹ nɩ kah tɛ̃ képékèyɔ̂, ǹ yah kwɔ. ");
INSERT INTO wib_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","À mɛ nɛ, ńyãh sɔkɔ se pè yɩ̃ ǹ lékólɛ nɩ? Pè mɛ yo ǹ tyɩ́ nɛ, pé yõ̀tɛ̃̀, à pɔ kyɩ yah. ");
INSERT INTO wib_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Képah sɔkɔ, Yesu yétĩ kwɛ. ");
INSERT INTO wib_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Képah tɛ̃̀nɛ, ǹ tɛ́kɩ́nmɔpu nɛ, pè yah, ǹ tyɩ́-á sõ̀ mɛ nɔ yĩ́ĩ́ ǹ tyɩ́ dɛ́! ");
INSERT INTO wib_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Tɛ́ tɔ̃ mɛ n yo nɛ, ǹmɔ nɛ̂-á yɩ̃́tũ̂ dĩ́ yɩ̃́ yɩkɩ, à kó sõ̀ fɛ̃ kũ yah kõ n pi Lasarɩ tyɩ́ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Képah sɔkɔ, kè tɔ̃ Yesu nɩ kah tɛ̃ képékèyɔ̂, à mɛ sɔkɔ diki yõ. Tɛkɩ diki ye sõ̀ kélɛ, tɛ́ ké yah mɛ víkénɔ́lɛ dáh-ǹgbɛ̃ yɔ́lɛ. ");
INSERT INTO wib_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yesu mɛ yo no tyɩ́ nɛ, pè dáhkɩ̀ mɛ̀ tɔkɔ tɛ̃ yõ. Lékókè dósê Martɩ mɛ à syah nɛ, Tɛ̃̀ ǹgbɛ̃, ǹ yɩ̃́nɔ́ sèpĩ̀n ǹyẽ̂h-á yɔ̀. Wǎh kɩ mɛ n põ dò. ");
INSERT INTO wib_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Képah sɔkɔ, Yesu yo ǹ tyɩ́ nɛ: «Mé náh kè yo á tyɩ́ nɛ, wáh kɩ sɛ̃ ń yõ, á yĩ́-á kɩ tɛ̃ Liyel yõ̀tɔ̃rɩ́ yõ di?» ");
INSERT INTO wib_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Képah tɛ̃̀nɛ, no mɛ dáhkɩ̀ tɛ̃ yõ. Yesu mɛ ǹ yah yɔ̃ yĩ̂nyõ tɛ́ nɛ: «Bɔ̌, mé n wɛkɩ á tyɩ́ wáh sɔ̃́npɩ́ ń nírí tɛ̃. ");
INSERT INTO wib_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Mé pɩ̃ nɛ wáh mɛ ń nírílɛ n tɛ̃ gbĩ́mɛgbĩ́. Ǹtɛ mé kélɛ n yo tɔ́wû mɛ̀ yĩnnɛ nɛ̂-á ń mɔ gbɩ̃ sah yɔ̀, nɛ pè sɛ̃ ké yõ nɛ, áwɔ-á tɛkɩ mɔ ńnɛ.» ");
INSERT INTO wib_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Képah yóntɛnɔ náh, à kah yo mɔ nɛ ńkɛ̃́: «Lasarɩ, wil nɛ́npɔ́!» ");
INSERT INTO wib_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Képah sɔkɔ, Lasarɩ nɛ̂-á sõ̀ ku, à yuku wil ǹ gbyẽ̂h ànɛ̂ ǹ gbã̀nnɛ púkúbínɔ́lɛ fwɔ gbrólɛ; tɛ́ ǹ yèpɔ mɛ fɔ́kɔ́nɔ́lɛ fwɔlɛ. Yesu mɛ yo pé tyɩ́ nɛ, pè à wah mɔ, pè mó yɛ à kɔ̃ à nɛ n yuku. ");
INSERT INTO wib_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Névye nónó-á sõ̀ mɛ pɔ Mari tnɔ̂, tɛ́ pɔ Yesu tyípɩ́nɩ́ mɛ̀ wɛ sɛ̃́, pé náhnáh sɛ̃ Yesu yõ. ");
INSERT INTO wib_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ǹtɛ pé túkù wɔ mó kyɩ ǹ tyípɩ́nɩ́ mɛ̀ sèsahrɩ yah sah Farisi wɛ̃̀kɩ̀ kɔ́pú tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Kǎh mó pɩ sɛ̃́, Farisi wɛ̃̀kɩ̀ kɔ́pú ànɛ̂ sárká syínwìlkìpu yõ̀tãm mɛ pé no tukey tùkèpu tĩ̀nkì ye, pè kɔ̃ tɛ̃ ké tyɩ́ sɔkɔ. Pè wɛ̃ syah nɛ, dĩ́ mɛ̀-á mɛ gbǐl tyilɛ n kah n pɩ dɛ́, sɔ̃́ se pé kɩ pɩ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Páh kɩ à sah à yɔ̃ sɔkɔ sélɛ n pɩ sɛ̃́ yɔ̀, no pól-á kɩ sɛ̃ ǹ yõ. Ǹtɛ képah-à pɩ, Wrome tãn-á kɩ yuku pépi Liyel ní-ńsah gbô sɔ, tɛ́ kɩ pépi yìkì tyɩ́ yɩkɩ. ");
INSERT INTO wib_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ǹtɛ pé sɔkɔ yɔ́ lésõ mɛ, pè n ye Kayifilɛ. Léyílɛ, ǹmɔ ye lésõ sárká syínwìlkìpu yõ̀tɛ̃̀ ǹgbɛ̃nɛ. Ǹmɔ mɛ pé no syah nɛ: «Yé náh kwâh yɔ́lɛ n pnɛ dɛ́! ");
INSERT INTO wib_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Yé náh pɩ̃ nɛ, dĩ́ nɛ́núkù-à kɩ ko mɔ ápi yìkì swɔ kè kɔ̃ kè wɛ pwah, képah-á kɩ nɛkɩ kal ápilɛ ǹ tɛ̃̀nɔ́lɛ min sɔkɔ, tɛ́ á yìkì pól tyɩ́ mó pɔ yɩkɩ di?» ");
INSERT INTO wib_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ǹtɛ ǹmɔ yah yĩ́ĩ́ náh sõ̀ à yo tyi nɔ́pilɛ dɛ́! Wǎh sõ̀ mɛ sárká syínwìlkìpu yõ̀tɛ̃̀ ǹgbɛ̃nɛ léyílɛ sɛ̃́, képah ye Liyel mɛ tɛ̃ntõ̀lɛ à kɔ̃ à syi yo sah nɛ, Yesu-á yɩ̃nɛ à ku ǹ yìkì névye yĩnnɛ. ");
INSERT INTO wib_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Tɛ́ ǹ yìkì névye ó yĩn náh à kɩ n ku n pi dɛ́, ǹ kúnɔ́ kɩ Liyel wɛ̃́npì pól tɔ tuke mɔ pɩ núkúlɛ, pépi nónó-á mɛ karkɩ tɛ̃ tɛ̃ kɔ̃. ");
INSERT INTO wib_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Kayifi-á fyɔ̀ képah yo, à tɔkɔ lésõ tyɩ́, pè núkú Yesu kònmɔnɔ sah gbáhkɩ̀ yõ. ");
INSERT INTO wib_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Kǎh pɩ sɛ̃́, Yesu náh tɔ̃ mɛ n gblɔ̌ynɛ n wilki n mɔ kwèyy Nsyifunɔ yah. À yal ànɛ̂ ǹ tõ̀ sã́hpúlɛ, pè kyɩ tɛ̃ kwil yɔ́ sɔkɔ, pè n ye Yefrayiminɛ. Képah sõ̀ mɛ gbɛ̃̀nyah yɔ́ sɔkɔ, nɛ̂-á mɛ gbɛ̃́nnɩ tnɔ̂. ");
INSERT INTO wib_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ǹtɛ Nsyifunɔ yɔ̃rɩ tyɛ́nɔ́ syáh-á sõ̀ mɛ de n tɛ sɛ̃́, névye náhnáh sõ̀ mɛ n wil gbnɔ sɔkɔ, tɛ́ mɛ n dɔkɔ n yuku Yerusalɛmɩ kwil sɔkɔ. Pè sõ̀ mɛ syáh mɛ̀ dyàh tɛ̃, nɛ pé kyɩ pé gblɔ̌y tɔ̃ n sah, à yɩ̃nɛ pé tyi kõ̀nsàhnɔ́ wã̀llɛ. ");
INSERT INTO wib_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Pǎh sõ̀ mɛ Liyel ní-ńsah gbô sɔkɔ gbĩ́ nɛ̂nɛ, pè sõ̀ mɛ Yesulɛ n yah n kɔ̃, tɛ́ mɛ wɛ̃nɛ n piki n yah nɛ ńkɛ̃́, kè se mɛ sɔ̃́ nɩ? À se kɩ pyě yɛ wũ syáh mɛ̀ sɔkɔ pɔ́nɔ́lɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Tɛ́ sárká syínwìlkìpu yõ̀tãm ànɛ̂ Farisi wɛ̃̀kɩ̀ kɔ́pú lésõ mɛ ké gbah yo sah tɛ névye tyɩ́ nɛ, nɛ̂-à fyɔ̀ Yesu mɛ́-ńsah pɩ̃, tɛ̃̀ pɔ kè yo pé syah, pé kɔ̃ pé à wɛ tɛ̃. ");
INSERT INTO wib_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Nsyifunɔ yɔ̃rɩ tyɛ́nɔ́ syáh sõ̀ mɛ wũ sèpĩ̀n kénúkòlɛ, tɛ́ Yesu mɛ kyɩ Betani kwil sɔkɔ, ńyãh sɔkɔ-á sõ̀ Lasarɩlɛ tɛ̃̀nɔ́lɛ, wǎh nɛ̂ lékó yilki mɔ. ");
INSERT INTO wib_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Pè mɛ yõke yah Yesu kɔ̃ nɛ́npɔ́. Martɩ sõ̀ mɛ yõkelɛ n dibi, tɛ́ yõke mɛ̀ yṍpú sɔkɔ yɔ́ ye sõ̀ Lasarɩlɛ. ");
INSERT INTO wib_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Képah sɔkɔ, Mari mɛ làsèkwěl dɛ́nkɔ́kɔ̀ yɔ́ lítír tɔ́nɩ́ tɔkɔ, nɛ̂-á pè nardɩ kɔ́kɔ́lɛ kè pɩ. Tɛ́ pɔ kè kwɛ mɔ Yesu gbɛ̃́náhlɔ́ yõ, tɛ́ kè kele ǹ yõ̀yénnɛ. Làsèkwěl mɛ̀ pãn mɛ wɔ̀kɔ̀ pól tɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Képah tɛ̃̀nɛ, Nsyudasɩ Yisikariyɔtɩ nɛ̂-á Yesu tõ̀ sã́hpú sɔkɔ yɔ́lɛ, tɛ́ kɩ sõ̀ pɔ n vi n pi Yesu náh, ǹmɔ nɛ, ");
INSERT INTO wib_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","kwâh nɛ̂ se pɩ tɛ́ làsèkwěl mɛ̀ náh yãm deniye pɔ́ plɔ́ kyɛtɔ̃nɩ́nɛ, à ké pɔ́ dibi yãm tãn kɔ̃ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ǹtɛ yãm tãn yãm náh sõ̀ tɛ̃ ǹnɛ dɛ́, yɛ̃́nwó ye sõ̀ ǹnɛ képah ye à kɔ̃ à képahlɛ n yo. Pɔ́ dú sõ̀ mɛ ǹmɔ tyɩ́. Tɛ́ pǎh nónónɛ n dah n mɔ n pɔ, ǎ sélɛ n yɩ̃. ");
INSERT INTO wib_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Képah sɔkɔ, Yesu nɛ: «Pi yah vɩ́nɔ́ sah kénòh! À ye képah pɩ sah ńmɔ lékó yɩ̃ sõ yĩnnɛ. ");
INSERT INTO wib_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Yãm tãn kɩ mɛ ànɛ̂ yélɛ sétáh yõ sõmɛsṍ. Ǹtɛ ńmɔ wɔlɛ, ńmɔ náh n mɛ n pi yélɛ sétáh yõ sõmɛsṍ.» ");
INSERT INTO wib_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Tɛ́ tɔ́wû ǹgbɛ̃-á pɔ noh nɛ Yesu-á mɛ Betani kwil sɔkɔ gbĩ́ nɛ̂nɛ, pè kyɩ nɛ́npɔ́. Ǹtɛ Yesu ó yĩn náh sõ̀ pè kyɩ dɛ́, Lasarɩ nɛ̂ lékó-á Yesu yilki mɔ, ǹmɔ tɔ wɛ yĩn ye sõ̀ pè kyɩ. ");
INSERT INTO wib_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Ǹtɛ Lasarɩ mɛ̀ yĩnnɛ, névye náhnáh sõ̀ mɛ pélɛ n syɩ sárká syínwìlkìpu yõ̀tãm náh à n vi n mɔ n pɩ Yesu yõ sɛ̃́púlɛ. Képah ye, sárká syínwìlkìpu yõ̀tãm mɛ Lasarɩ tyɩ́ yo syɩ nɛ, páh kɩ ǹ tɔ ko mɔ. ");
INSERT INTO wib_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ké dĩndallɛ, tɔ́wû ǹgbɛ̃ nɛ̂-á sõ̀ mɛ pɔ Nsyifunɔ yɔ̃rɩ tyɛ́nɔ́ syáh sɔkɔ, pè kè noh nɛ Yesu-á mɛ n pi Yerusalɛmɩ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Pè mɛ sãm yɩ̃̀ngbã̀n kɔ̃lɩ tɛ̃ yĩn, tɛ́ wil kwil sɔkɔ à kyɩ à yohnɩ. Pè sõ̀ mɛ gbo mɔ tũ nɛ: «Wosana! Nɛ̂-á n pi Tɛ̃̀ ǹgbɛ̃ Liyel yĩn yõ, Liyel sãm mɔ ǹ sɔkɔ, ǹmɔ nɛ̂-á Yisrayel yõ̀tɛ̃̀ dĩ́nɛ.» ");
INSERT INTO wib_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Képah sɔkɔ, Yesu mɛ ńkwɛ̃́ndyɩ́píkì yɔ́ wɛ, tɛ́ dɔkɔ kɔ̃ tɛ̃ ǹ yõ, à yɩ̃nɛ sɔ̃́-á kélɛ wã́rkɩ́nsàhnɔ́lɛ Liyel wɛy sɛ́bɛ́y sɔkɔ nɛ ńkɛ̃́: ");
INSERT INTO wib_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«Yerusalɛmɩ tãn, yé káh tíkí pɩ. Yé yah, yé yõ̀tɛ̃̀ mɛ n pi. À mɛ dɔ́kɔ́ntɛ̃̀nɔ́lɛ ńkwɛ̃́ndyɩ́píkì yɔ́ yõ sɔkɔ.» ");
INSERT INTO wib_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Tɛ́ légbĩ́nɛ, Yesu tõ̀ sã́hpú náh sõ̀ mɛ tyi nɔ́pi pɩ́nɔ́ yõ pɩ̃. Ǹtɛ wǎh pɔ dɔkɔ ǹ tɔ̃́rɩ́ yõ gbĩ́ nɛ̂nɛ, pé dyɔ to kõ nɛ, kǎh lésõ wãrkɩ sah sɔ̃́ ǹ tyɩ́ sɔkɔ Liyel wɛy sɛ́bɛ́y sɔkɔ, sɛ̃́-á kè pɩ ǹ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Képah tɛ̃̀nɛ, Yesu-á lésõ Lasarɩ lékó ye yah, à à yilki mɔ wilki diki sɔkɔ nónó yĩ́ yah, pépi mɛ tyah kélɛ n yah n yãh n kɔ̃. ");
INSERT INTO wib_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Névye-á kénɛ gbǐl tir pɩ́nɔ́ noh sɛ̃́, pè wil pɔ Yesu yohnɩ. ");
INSERT INTO wib_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Képah sɔkɔ, Farisi wɛ̃̀kɩ̀ kɔ́pú tyah n yo wɛ̃ tyɩ́ nɛ, pè kó kè wɛ nɩ, pépi náh tɔ̃ fɛ̃ n tɛ̃ n pi dò. No pól-á mɛ ǹ sõ̀ tɛ̃. ");
INSERT INTO wib_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Névye nónó-á sõ̀ mɛ pɔ syáh mɛ̀ sɔkɔ Yerusalɛmɩ, nɛ pé pɔ Liyel yĩn gbilki, Nsyifunɔ náh sõ̀ pé túkùlɛ. ");
INSERT INTO wib_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Kénɛ névye nónó-á Nsyifunɔ náh pélɛ, pépi mɛ nɔ de Filipi tnɔ̂ ǹmɔ nɛ̂-á n wil Betisayida kwil, Kalile gbɛ̃̀nyah sɔkɔ. Tɛ́ kè yah kɔ̃ ǹ tyɩ́ nɛ, pé yõ̀tɛ̃̀, páh mɛ ké tyɩ́ nɛ pé Yesu wɛ. ");
INSERT INTO wib_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Kǎh pɩ sɛ̃́, Filipi mɛ kè yo Andre tyɩ́. Andre mɛ tahlɩ ǹ tyɩ́ pè kyɩ kè yo Yesu tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Képah tɛ̃̀nɛ, Yesu mɛ yo pé tyɩ́ nɛ: «Gbĩ nɛ̂ sɔkɔ-á Névi Pídĩ́ kɩ n dɔkɔ n pi ǹ tɔ̃́rɩ́ yõ, képah ye sɛ núkúnúkú yɔ̀. ");
INSERT INTO wib_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Kègbɩgbɩ tɛ̃̀ yõ, mé kélɛ n yo yé tyɩ́, nɛ́ sèmukɔ pi náh duku mɔ sétáh sɔkɔ kè fi tɛ́ ké pi ku, kè n tɛ̃ ké gblɔ̌y. Ǹtɛ kàh duku mɔ à fi tɛ́ ké pi ku, kè n kwel. ");
INSERT INTO wib_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Névi nɛ̂-à ǹ gblɔ̌y ó minnɛ n mɔ n kõ, tɛ̃̀ min tyɩ́ kɩ yɩkɩ. Ǹtɛ nɛ̂-à ǹ minnɛ n mɔ́nkõ̀-ǹkɛ̃̂nɛ kèkõyṍ mɛ̀ sɔkɔ Liyel tɔ̃́rɩ́ yĩnnɛ, tɛ̃̀ wɔ kɩ tyɛ́-ńkɛ̃̂ min wɛ. ");
INSERT INTO wib_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Névi nɛ̂-à mɛ ké tyɩ́ nɛ, pé tõ̀lɛ n pɩ ńmɔ tyɩ́, tɛ̃̀ ń sõ̀ tɛ̃. Képah sɔkɔ, máh mɛ ńyãh sɔkɔ, nɛ̂-á tõ̀lɛ n pɩ ń tyɩ́, ǹ tɔ kɩ mɛ nɛ́npɔ́. Névi nɛ̂-à tõ̀lɛ n pɩ ńmɔ tyɩ́, ń Sú Liyel kɩ ǹ yõ yɔ̃. ");
INSERT INTO wib_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Tɛ́ núkúnúkú, ń fɔkɔ mɛ fɛ̃kɩ. Ǹtɛ mè yo sɔ̃́? Mé se n yo Sú Liyel tyɩ́ nɛ, à káh n yɛ yèvyãhrɩ mɛ̀ ń wɛ? Ǹtɛ ɔ̃́ɔ̃ dɛ́, yèvyãhrɩ mɛ̀ yĩn ye mé pɔ tɔ́tɔ́.» ");
INSERT INTO wib_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Képah tɛ̃̀nɛ, à nɛ: «Bɔ̌, gbílkínɔ́ sah á yĩn yõ.» Wǎh yo sɛ̃́, yĩ́npɔ̃́ yɔ́ wil yĩ̂nyõ sɔkɔ nɛ ńkɛ̃́: «Mé ń yĩn gbilki tɛ, tɛ́ mé kɩ kè gbilki n pi ńtɔ̃.» ");
INSERT INTO wib_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Tɔ́wû nɛ̂-á sõ̀ mɛ nɛ́npɔ́, tɛ́ yĩ́npɔ̃́ mɛ̀ noh, pè nɛ gbɛ̃́nséntã́hkɩ̀-á gboke. Túkù mó nɛ, yĩ̂nyõ tõ̀npɩ yɔ́-á yo mɔ Yesu tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Képah sɔkɔ, Yesu mɛ yo pé tyɩ́ nɛ: «Wɛy nɛ̂-á yé noh yɔ̀, kè náh yo ńmɔ yĩnnɛ, kè yo yépi yĩnnɛ. ");
INSERT INTO wib_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Liyel kɩ lékàhlɛ kèkõyṍ névye kɔ̃ n pi núkúnúkú sɛ̃́ yɔ̀. Núkúnúkú, à kɩ kèkõyṍ névye fnɛ̀-ò yĩni yal. ");
INSERT INTO wib_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ǹtɛ mâh pɔ dɔkɔ mɔ gbĩ́ nɛ̂nɛ, mé kɩ névye póllɛ pɔ ń gblɔ̌y tyɩ́.» ");
INSERT INTO wib_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yesu-á sõ̀ nɛ n ku n pi dùkù nɛ̂nɛ, képah ye à wɛ̃kɩ ǹ wɛy mɛ̀ sɔkɔ yɔ̀. ");
INSERT INTO wib_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Képah sɔkɔ, tɔ́wû mɛ̀ névye mɛ yo ǹ tyɩ́ nɛ, pépi-á kè wɛ Liyel tyi kõ̀nsàhnɔ́ sɔkɔ nɛ, Liyel nɛy yáhntɔkɔnɔ náh n ku n yah n pi. Tɛ́ ǹmɔ se sɔ̃́npɩ́lɛ pɔ n yo nɛ, Névi Pídĩ́-á yɩ̃nɛ à dɔkɔ mɔ nɩ? Ǹtɛ nɛ̂ tɛ̃̀ ó se mó Névi Pídĩ́ mɛ̀nɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Képah sɔkɔ, Yesu mɛ yo pé tyɩ́ nɛ: «Kyòo mɛ̀nɛ, kè mɛ sɛ̃́ yé wrɔ́ kɩ wrɔ́ kwéy yɔ́ pɩ n pi. Tɛ́ névi nɛ̂-à n kɔ fɛ̃́ntũ̂ sɔkɔ, tɛ̃̀ náh ǹ yúkú-ńsahlɛ n pnɛ. Képah ye, kyòo mɛ̀-á mɛ yé wrɔ́ sɔkɔ yɔ̀, yé nɛ n kɔ ké sɔkɔ, fɛ̃́ntũ̂ káh pɔ yé kwɔkɩ tɛ̃. ");
INSERT INTO wib_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Kyòo mɛ̀nɛ, kǎh mɛ yé wrɔ́ gbĩ́ nɛ̂nɛ, yé sɛ̃ képah yõ. Képah sɔkɔ, yé kɩ pɩ kyòolɛ képah tyɩ́ kɔ̃lɛ.» Yesu-á képah yo tɛ, à yal pé tnɔ̂ à kyɩ wɔ̃bɩ fɩ́ɩ́ pélɛ. ");
INSERT INTO wib_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yesu sõ̀ gbǐl tyi náhnáh pɩ pé yĩ́ yah, ǹtɛ képah fyé yõ, pè náh sɛ̃ ǹ yõ. ");
INSERT INTO wib_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Liyel tɛ̃ntõ̀ syínyo-ò Yesayi tyíyónɔ́ nɔ́pi ye wil ásõ̂ sɔkɔ yɔ̀. À lésõ nɛ ńkɛ̃́: «Tɛ̃̀ ǹgbɛ̃, nɛ̂ sɛ̃ ápi tyíyónɔ́ yõ? Á á tɛ̃́npnɛ̀nɔ́lɛ nɛ̂ wɛ̃kɩ?» ");
INSERT INTO wib_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Tɛ́ tir nɛ̂ yĩn-á pè náh sõ̀ fɛ̃ n sɛ̃ n pi ké yõ, képah yah ye Yesayi tɔ̃ yo nɛ ńkɛ̃́: ");
INSERT INTO wib_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«Liyel pé yɩ̃́ wɔ, tɛ́ pé lékã́m yah vike, nɛ pé yɩ̃́ káh fɛ̃ nɛ n yah, pè káh tir yɔ́ tyɩ́ yah wɛ, pè mó vi mɔ Liyel wɛ̃̀kɩ̀ yõ, à kɔ̃ à pè wɛ dɛ mɔ.» ");
INSERT INTO wib_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Yáh wɛ Liyel tɛ̃ntõ̀ syínyo-ò Yesayi képahlɛ n yo, à lésõ kwãh tɛ̃ Yesu tɔ̃́rɩ́ wɛ, képah ye à kɔ̃ à ǹ tyɩ́lɛ n yo. ");
INSERT INTO wib_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Tɛ́ képah fyé yõ, yõ̀tãm náhnáh sõ̀ mɛ sɛ̃ Yesu yõ. Ǹtɛ Farisi wɛ̃̀kɩ̀ kɔ́pú tíkí sõ̀ mɛ pè tɛ̃ nɛ, pè káh pɔ pé yĩni wilki pé wɛ̃̀kɩ̀ sɔkɔ. Képah ye, pè náh kè wilki mɔ nɛ, páh sɛ̃ ǹ yõ. ");
INSERT INTO wib_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Yáh wɛ pè képah pɩ, névye-á mɛ gbílkínɔ́ nɛ̂nɛ n sah pé yõ, képah tyɩ́ sõ̀ mɛ pé tyɩ́ kal Liyel tyɩ́lɛ. ");
INSERT INTO wib_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Képah sɔkɔ, Yesu wɛkɩ yĩ́npɔ̃́ ǹgbɛ̃nɛ nɛ ńkɛ̃́: «Névi nɛ̂-à sɛ̃ ńmɔ yõ, ńmɔ ó yõ náh tɛ̃ sɛ̃ dɛ́, Liyel nɛ̂-á tɛkɩ mɔ ńnɛ, ǹmɔ tɔ yõ ye tɛ̃̀ sɛ̃. ");
INSERT INTO wib_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Tɛ́ névi nɛ̂-à ńmɔ wɛ, ń tɛ́kɩ́nmɔ-ò ye tɛ̃̀ wɛ. ");
INSERT INTO wib_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ńmɔ pɔ kèkõyṍ à pɔ pɩ kyòolɛ, nɛ névi nɛ̂-à sɛ̃ ńmɔ yõ, tɛ̃̀ káh tɛ̃ fɛ̃́ntũ̂ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ńmɔ náh pɔ kèkõyṍ sɔkɔ, nɛ mé pɔ lékàhlɛ névye kɔ̃. Mé pɔ nɛ kèkõyṍ névye pwáhnmɔnɔ wɛ. Képah ye, névi nɛ̂-à ń wɛlɔ noh, tɛ́ à náh mɛ n kɔ sé wã̀l yõ, ńmɔ náh kɩ n kɔ̃ n pi tɛ̃̀nɛ lékàhlɛ dɛ́. ");
INSERT INTO wib_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","49","Wɛy nɛ̂-á mé yo yɔ̀, képah ńtɛ̃ ye kɩ lékàhlɛ tɛ̃̀ kɔ̃ n pi gbĩ̀yĩ̀kì tɛ́y sõlɛ. Ń gblɔ̌y yah yĩ́ĩ́ náh mé yo wɛlɔ nɔ́pilɛ dɛ́! Sú Liyel nɛ̂-á tɛkɩ mɔ ńnɛ, máh yɩ̃nɛ mè nɛ̂ yo, ànɛ̂ máh yɩ̃nɛ mè kwɔ́nɔ́ nɛ̂ pɩ, ǹmɔ ye yo sélɛ ń tyɩ́ nɛ mé pɩ. Képah ye, névi nɛ̂-à ń yahle, tɛ́ à náh mɛ ń wɛynɛ n mɔ n kõ, nɛy mɛ tɛ, nɛ̂-á kɩ lékàhlɛ tɛ̃̀ kɔ̃ n pi. ");
INSERT INTO wib_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Tɛ́ ńmɔ mó tɔ̃ pɩ̃ nɛ Liyel-á nɛ̂ kõ sah, képah gbõ̀ yõ sɔkɔ-á névye kɩ fɛ̃ tyɛ́-ńkɛ̃̂ min wɛ. Sú Liyel-á wɛy mɛ̀ yo sɔ̃́ ń tyɩ́, sɛ̃́ ye mé n yo kélɛ yé tyɩ́.» ");
INSERT INTO wib_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Nsyifunɔ yɔ̃rɩ tyɛ́nɔ́ syáh kɩ sõ̀ n pɩ n pi dĩndallɛ. Yesu sõ̀ pɩ̃ nɛ pé yálnɔ́ gbĩ-á sɛ kèkõyṍ, páh kɩ n sɔkɔ n pi Sú Liyel tyɩ́. Ǹ sõ̀ tɛ̃́pú nónó-á sõ̀ mɛ kèkõyṍ, pé tyɩ́ sõ̀ mɛ nɔ́nɔ́lɛ ǹ tyɩ́. Pé tyɩ́ nɔ kah mɔ ǹ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yesu ànɛ̂ ǹ tõ̀ sã́hpú sõ̀ mɛ yõkelɛ n yõ. Tɛ́ sétã̀n yõ̀tɛ̃̀ sõ̀ mɛ kè dahbɩ tɛ Simo Yisikariyɔtɩ pídĩ́ Nsyudasɩ nɩ sɔkɔ nɛ, à vi Yesu náh. ");
INSERT INTO wib_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu sõ̀ pɩ̃ nɛ Sú Liyel-á tyi pól dahbɩ péwɔ gbõ̀. Ǹmɔ tyɩ́-á pé wil à pɔ, tɛ́ páh kɩ pé syɩ sɔkɔ ǹmɔ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Képah sɔkɔ, pǎh mɛ yõke yṍnɔ́ sɔkɔ sɛ̃́, à yuku yĩn, tɛ́ ǹ fwɔ̀mɔ̀-ǹgbɛ̃ dɛ sah, tɛ́ fwɔ yɔ́ tɔkɔ toh ǹ syɩ̃ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Képah náh, à ni du mɔ dú yɔ́ sɔkɔ, à tyah ǹ tõ̀ sã́hpú gbyẽ̂hnɛ n wu kélɛ, tɛ́ sélɛ n tuke fwɔ mɛ̀nɛ, nɛ̂-á à toh ǹ syɩ̃ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Kǎh pɔ syɩ Simo-Pyɛrɩ tyɩ́, à Yesu syah nɛ ńkɛ̃́, ǹmɔ nɛ̂-á TƐ̃̀ ǸGBƐ̃NƐ ǹmɔ kɩ n yah n kɔ̃ péwɔ gbyẽ̂h wú-ńsahlɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesu mɛ yo ǹ tyɩ́ nɛ, nɛ̂-á péwɔ n pɩ yɔ̀, ǹmɔ náh fɛ̃ ké tyɩ́ yah wɛ n pi núkúnúkú lɔ́! Ǹtɛ náh-á à kɩ pɔ ké tyɩ́ yah wɛ n pi. ");
INSERT INTO wib_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pyɛrɩ tɔ̃ yuku à syah nɛ, póllɛ, à náh pé gbyẽ̂h wu n pi. Képah sɔkɔ, Yesu mɛ yo ǹ tyɩ́ nɛ: «Wáh kɩ yɛ ń kɔ̃ mé á gbyẽ̂h wú-ńkɛ̃̂nɛ, á vyãh kɩ dɛ ńmɔ tyi sɔkɔ.» ");
INSERT INTO wib_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Képah tɛ̃̀nɛ, Simo-Pyɛrɩ yo ǹ tyɩ́ nɛ, Tɛ̃̀ ǹgbɛ̃, kàh pɩ sɛ̃́ kè káh yĩn pé gbyẽ̂h ó tyɩ́, ńkɛ̃́ à pé gbã̀n ànɛ̂ pé yõ tɔ wu. ");
INSERT INTO wib_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","À mɛ yo ǹ tyɩ́ nɛ: «Névi nɛ̂-à ni wel tɛ, tɛ̃̀ n nɛ n mɛ yályál. Képah ye, à wil ǹ gbyẽ̂h tyɩ́ sɔkɔ, yõ náh tɔ̃ ńkɛ̃́nɛ nɛ mɛ tɛ̃̀ wil pól tɔ̃́nwunɔ tyɩ́. Yépi mɛ yályál. Ǹtɛ yé pól tɛ̃̀ wɔ náh mé n ye dɛ́!» ");
INSERT INTO wib_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Névi nɛ̂-á kɩ sõ̀ pɔ n vi n pi Yesu náh, Yesu sõ̀ mɛ à pɩ̃ tɛ. Képah ye à kɔ̃ à nɛ, pé pól tɛ̃̀ wɔ náh pé nɛ pǎh mɛ yályál dɛ́! ");
INSERT INTO wib_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Wǎh pé gbyẽ̂h wu tɛ, à tɔ̃ ǹ fwɔ̀mɔ̀-ǹgbɛ̃ tɔkɔ mɔ pɔ kɔ̃ tɛ̃ yõke yṍ-ńsah ńtɔ̃. Tɛ́ yo pé tyɩ́ nɛ: «Máh nɛ̂ pɩ yé tyɩ́ sɛ̃́ yɔ̀, yé se ké yõ pɩ̃? ");
INSERT INTO wib_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Yâh pɩ yě ńnɛ n ye kwɔ́-ò dĩ́nɛ, képah náh pɩ, Tɛ̃̀-ǹgbɛ̃nɛ, yé mɛ n yo plɛ tɛ̃̀ wɔlɛ. Ńmɔ ye ńtyɩ̃́nɔ ǹnɛ. ");
INSERT INTO wib_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ǹtɛ ńmɔ nɛ̂-á Tɛ̃̀ ǹgbɛ̃ ànɛ̂ kwɔ́-òlɛ, yáh wɛ mé yé gbyẽ̂h wu, yépi tɔ yɩ̃nɛ yè wɛ̃ gbyẽ̂hnɛ n wu. ");
INSERT INTO wib_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Képah dùkù ye mé pɩ yé wɛ̃kɩ yɔ̀, nɛ máh nɛ̂ pɩ yé tyɩ́, yé tɔ sɛ̃́nknɔlɛ n pɩ. ");
INSERT INTO wib_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Kègbɩgbɩ tɛ̃̀ yõ, mé kélɛ n yo yé tyɩ́, tõ̀npɩ náh fɛ̃ n kal ǹ yõ̀tɛ̃̀nɛ. Sɛ̃́ ó ye tɛ̃ntõ̀ névi tɔ náh fɛ̃ n kal ǹ tṍ-òlɛ. ");
INSERT INTO wib_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ǹtɛ núkúnúkú, yé se kénɛ tyilɛ n pnɛ tɛ́! Yâh fɛ̃ syi n kɔ sé wã̀l yõ, yé kɩ nɩ̀vɩ̀nɩ̀ wɛ. ");
INSERT INTO wib_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Ń wɛy mɛ̀ náh mɛ ké yah mɔ yé pól tyɩ́ dɛ́! Máh névye nónó yah wilki, mé pélɛ n pnɛ. Ǹtɛ tir nɛ̂-á wãrkɩ sah Liyel wɛy sɛ́bɛ́y sɔkɔ, kè yɩ̃nɛ kè wil ó wil. Kè mɛ wã́rkɩ́nsàhnɔ́lɛ ké sɔkɔ nɛ ńkɛ̃́: ‹Máh lésõ ń yõkelɛ n yõ ànɛ̂ nɛ̂nɛ, tɛ̃̀ mɛ yuku ń yõ.› ");
INSERT INTO wib_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ké pɩ́-ńkɛ̃̂ sɔkɔ ye mé kélɛ n yo n sah yé tyɩ́ núkúnúkú yɔ̀. Képah sɔkɔ kàh pɔ pɩ, yé kɩ sɛ̃ ké yõ nɛ, Ńmɔ-á. ");
INSERT INTO wib_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Kègbɩgbɩ tɛ̃̀ yõ, mé kélɛ n yo yé tyɩ́, névi nɛ̂-à ń tɛ̃ntõ̀ névi tɛ̃ plɛ, ńmɔ ye tɛ̃̀ tɛ̃ plɛ. Nɛ̂ tɔ-à ńmɔ tɛ̃ plɛ, nɛ̂-á tõ ńnɛ, ǹmɔ ye tɛ̃̀ tɛ̃ plɛ.» ");
INSERT INTO wib_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Képah tɛ̃̀nɛ, kénɛ wɛlɔ yóntɛnɔ náh, Yesu fɔkɔ kah fɛ̃kɩ. À mɛ kè yo dal mɔ nɛ: «Kègbɩgbɩ tɛ̃̀ yõ, mé kélɛ n yo yé tyɩ́, yé sɔkɔ nɛy yɔ́ kɩ n vi n pi ń náh.» ");
INSERT INTO wib_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Wǎh képah yo sɛ̃́, ǹ tõ̀ sã́hpú tyah n yɔ̃ wɛ̃nɛ n yah núkú núkúlɛ. Pè náh sõ̀ mɛ pɩ̃ nɛ̂ tyɩ́-á à n yo. ");
INSERT INTO wib_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Tɛ́ Yesu tõ̀ sã́hpú sɔkɔ nɛ̂ tyɩ́-á nɔ yĩ́ĩ́ ǹ tyɩ́, ǹmɔ sõ̀ mɛ tɛ̃̀ntelnɔlɛ Yesu tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Képah sɔkɔ, Simo-Pyɛrɩ pɩ mɔ ǹmɔ tyɩ́ nɛ à Yesu piki yah, nɛ̂ tyɩ́-á à n yo. ");
INSERT INTO wib_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ǹmɔ mó ǹ gbalɩ kɛ̃kɩ Yesu tĩ̀nnɛ, tɛ́ à piki yah nɛ, Tɛ̃̀ ǹgbɛ̃, nɛ̂ se à n ye nɩ? ");
INSERT INTO wib_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","À mɛ yo ǹ tyɩ́ nɛ, páh kɩ búrn yĩ di nɛ̂ kɔ̃, tɛ̃̀ wɔ-á. Tɛ́ núkú búrn yĩ́nɔ́ tɔkɔ, tɛ́ kè di à Simo Yisikariyɔtɩ pídĩ́ Nsyudasɩ kɔ̃. ");
INSERT INTO wib_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Nsyudasɩ-á búrn mɛ̀ syi, sétã̀n yõ̀tɛ̃̀ mɛ de ǹ sɔkɔ. Yesu mɛ yo ǹ tyɩ́ nɛ, nɛ̂-á ǹ tyɩ́ pɩ pɩ tɛ̃̀nɛ, à kè pɩ súú. ");
INSERT INTO wib_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ǹtɛ nónó pól-á sõ̀ mɛ nɛ́npɔ́, pé sɔkɔ yɔ́ ńtɛ̃ náh sõ̀ pɩ̃ tir nɛ̂ yĩn-á Yesu yo wɛy mɛ̀nɛ ǹ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Tɛ́ pɔ́ dú-á sõ̀ mɛ Nsyudasɩ tyɩ́ sɛ̃́, túkù sõ̀ mɛ n sõ nɛ, Yesu-á yo ǹ tyɩ́ nɛ à kyɩ syáh yídwénè yah dwe, képah náh pɩ, à pɔ́ yɩ̃ yãm tãn kɔ̃. ");
INSERT INTO wib_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ǹtɛ Nsyudasɩ-á fyɔ̀ búrn yĩ́nɔ́ mɛ̀ syi, à núkú yuku wil. Légbĩ́nɛ lékã̂h sõ̀ mɛ mɔ. ");
INSERT INTO wib_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Nsyudasɩ-á fyɔ̀ wil tɛ, Yesu nɛ: «Núkúnúkú tɛ̃̀nɛ, gbílkínɔ́ ye sah Névi Pídĩ́ yõ, ànɛ̂ Sú Liyel yĩn kɩ se tɔ̃ gbilki ǹmɔ yĩnnɛ. ");
INSERT INTO wib_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Gbílkínɔ́-à kɩ sah Liyel yõ ǹmɔ yĩnnɛ, Liyel tɔ kɩ à gbilki ǹ gblɔ̌y yĩnnɛ. Dǒ kwéy ńtɛ̃nɛ, à kɩ kè pɩ n pi. ");
INSERT INTO wib_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ń wɛ̃́npì, mé kɩ tɔ̃ n mɛ n pi yélɛ kɩ wrɔ́ kwéy ó pɩ. Yé kɩ ń yah n kɔ̃ n pi. Ǹtɛ nɛ̂-á lésõ mé yo Nsyifunɔ tyɩ́, képah núkú ye tɔ̃ mé kɩ yo yépi tɔ tyɩ́ núkúnúkú nɛ, yé náh fɛ̃ n kyɩ n pi ńmɔ yúkú-ńsah sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Mé kɩ tir sã́n yɔ́ kõ sah yé kɔ̃ nɛ, yé tyɩ́ nɔ wɛ̃ tyɩ́. Yé tyɩ́-á nɔ sɔ̃́ ńmɔ tyɩ́, yépi tɔ tyɩ́ yɩ̃nɛ kè nɔ sɛ̃́ wɛ̃ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Yé tyɩ́-à kɩ nɔ wɛ̃ tyɩ́, képah sɔkɔ ye no pól kɩ pɩ̃ nɛ ńmɔ tõ̀ sã́hpú-á yélɛ.» ");
INSERT INTO wib_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Képah sɔkɔ, Simo-Pyɛrɩ à piki yah nɛ, Tɛ̃̀ ǹgbɛ̃, ńyãh se à n yuku nɩ? À mɛ yo ǹ tyɩ́ nɛ, ńyãh-á pé n yuku, à náh fɛ̃ n kyɩ n pi pélɛ nɛ́npɔ́ sɔkɔ núkúnúkú. Ǹtɛ náh tĩ̀nnɛ, wǎh kɩ pɔ pé sõ tɛ̃ n pi. ");
INSERT INTO wib_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pyɛrɩ mɛ nɛ, Tɛ̃̀ ǹgbɛ̃, sɔ̃́ se pɩ tɛ́ pé náh fɛ̃ ǹ sõ̀ tɛ̃ n pi núkúnúkú nɩ? Péwɔ-á kɩ fɛ̃ syi pé min kɔ̃ n pi ǹmɔ yĩnnɛ dò. ");
INSERT INTO wib_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","À mɛ yo ǹ tyɩ́ nɛ: «Á kɩ á min kɔ̃ n pi ńmɔ yĩnnɛ lɛ́? Ǹtɛ kègbɩgbɩ tɛ̃̀ yõ, mé kélɛ n yo á tyɩ́, sénpɛ-à kɩ pópó n gbo, á kɩ mɛ á vyãh kɔ̃lɩ tɛ kɛ tɔ̃́nɔ́, nɛ á náh ńmɔ pɩ̃.» ");
INSERT INTO wib_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Képah náh, Yesu yo ǹ tõ̀ sã́hpú tyɩ́ nɛ: «Yé káh yɛ yé fɔkɔ fɛ̃kɩ. Yé sɛ̃ Liyel yõ, yè mó sɛ̃ ńmɔ tɔ yõ. ");
INSERT INTO wib_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Tɛ̃̀-ǹtã̀n náhnáh mɛ ń Sú Liyel tĩ̀nnɛ. Mé kɩ kyɩ tɛ̃̀-ǹsah yah sah yé kɔ̃. Kàh sõ̀ mɛ gbɩlɛ ńkɛ̃̂nɛ, mé náh náhkɩ kè yo n pi yé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Máh kɩ kyɩ tɛ̃̀-ǹsah yah sah tɛ yé kɔ̃, mé kɩ ń syɩ pɔ yé tɛ̃ sɔkɔ ń tnɔ̂. Képah sɔkɔ, ńmɔ-á mɛ ńyãh sɔkɔ, yépi tɔ kɩ mɛ nɛ́npɔ́. ");
INSERT INTO wib_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Yé se ńmɔ yúkú-ńsah wɛ̃̀kɩ̀lɛ n pnɛ tɛ́.» ");
INSERT INTO wib_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Wǎh yo sɛ̃́, Toma mɛ nɛ, Tɛ̃̀ ǹgbɛ̃, pépi náh mɛ ǹ yúkú-ńsah pɩ̃, tɛ́ pé se kɩ pɩ̃ sɔ̃́ ké wɛ̃̀kɩ̀lɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesu mɛ yo ǹ tyɩ́ nɛ: «Ńmɔ ye wɛ̃̀kɩ̀lɛ, ànɛ̂ gbɩlɛ, ànɛ̂ min nɛ́tɛ̃̂nɛ. Ǹnɩ̂ yɔ́ ńtɛ̃ náh fɛ̃ n kyɩ Sú Liyel tyɩ́, nɛ́ tɛ̃̀ náh syɔ̃ ńmɔ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Yâh sõ̀ mɛ ńmɔlɛ n pnɛ, yé náhkɩ mɛ ń Sú Liyel tɔlɛ n pnɛ. Ǹtɛ núkúnúkú, yé ye ǹnɛ n pnɛ, tɛ́ à wɛ.» ");
INSERT INTO wib_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Képah sɔkɔ, Filipi mɛ nɛ, Tɛ̃̀ ǹgbɛ̃, à Sú Liyellɛ pépi wɛ̃kɩ kɛ̀! Képah-á kɩ yɩ̃nɛ pépi tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesu mɛ yo ǹ tyɩ́ nɛ: «Filipi, mé mɛ yélɛ di mónɔ́lɛ, tɛ́ áwɔ náh mɛ ńmɔ pɩ̃ nɩ? Névi nɛ̂-à ńmɔ wɛ, Sú Liyel ye tɛ̃̀ wɛ. Ǹtɛ á pɩ sɔ̃́ tɛ́ tɔ̃ n yo nɛ, mé Sú Liyellɛ ǹ wɛ̃kɩ? ");
INSERT INTO wib_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Á náh sɛ̃ ké yõ nɛ, ńmɔ ànɛ̂ Sú Liyel-á mɛ núkúlɛ di? Wɛlɔ nónó-á mé n yo yé tyɩ́ yɔ̀, ńmɔ yah yĩ́ĩ́ wɛlɔ náh sélɛ dɛ́! Sú Liyel nɛ̂-á núkúlɛ ńmɔlɛ, ǹmɔ ye n pɩ ǹ tã̀nnɛ. ");
INSERT INTO wib_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Yé yɩ̃nɛ yè sɛ̃ ké yõ nɛ, ńmɔ ànɛ̂ Sú Liyel-á mɛ núkúlɛ. Yáh kɩ sɔ̃́ sɛ̃́-ńkɛ̃̂nɛ ké yõ ńmɔ wɛlɔ yĩnnɛ, yé sɛ̃ ké yõ tã̀n nɔ́pi tɛ̃̀ wɔ yĩnnɛ. ");
INSERT INTO wib_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Kègbɩgbɩ tɛ̃̀ yõ, mé kélɛ n yo yé tyɩ́, névi nɛ̂-à sɛ̃ ńmɔ yõ, máh mɛ tã̀n nónónɛ n pɩ, tɛ̃̀ tɔ kɩ sɛ̃́nknɔlɛ n pɩ. Tɛ́ tɛ̃̀ kɩ tã̀n yísyɔ́ ńtɛ̃ pɩ n pi nónó-á kal sépilɛ. Mé mɛ n yuku Sú Liyel tyɩ́, képah ye kɩ tɛ̃̀ kɔ̃ à kɩ fɛ̃ sè pɩ. ");
INSERT INTO wib_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Képah sɔkɔ, yâh tyídúkú nɛ̂ yah kɔ̃ ńmɔ yĩn yõ, mé kɩ kè pɩ yé tyɩ́, gbílkínɔ́ kɔ̃ kè kɩ sah Sú Liyel yõ ǹ Pídĩ́ gbõ̀ yõ. ");
INSERT INTO wib_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Yâh tir nɛ̂ yah kɔ̃ ńmɔ yĩn yõ, mé kɩ kè pɩ.» ");
INSERT INTO wib_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","«Ńmɔ tyɩ́-à mɛ nɔ yé tyɩ́, yé kɩ ń tyi kõ̀nsàhnɔ́ tɛ̃ yĩn. ");
INSERT INTO wib_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Tɛ́ mé kɩ Sú Liyel ni, à kɩ yòhnɩ̀nmɔ-ò yɔ́ tɛkɩ mɔ yé kɔ̃, nɛ̂-á kɩ pɔ n tɛ̃ n pi yélɛ kṹmm. ");
INSERT INTO wib_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Yòhnɩ̀nmɔ-ò mɛ̀nɛ, Liyel Mirki ye. Ǹmɔ ye gbɩlɛ névyelɛ n wɛ̃kɩ Liyel tyɩ́ sɔkɔ. Kèkõyṍ névye náh ǹnɛ n wɛ, ànɛ̂ pè náh ǹnɛ n pnɛ. Képah ye, pè náh fɛ̃ à fɛ̃ n syi. Ǹtɛ wǎh mɛ yépilɛ, tɛ́ mɛ yé sɔkɔ sɛ̃́, képah ye yépi wɔ ǹnɛ n pnɛ. ");
INSERT INTO wib_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Mé náh yé sah n pi ńgbyelɛ. Mé kɩ ń syɩ n pɔ n pi yé tnɔ̂. ");
INSERT INTO wib_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Dǒ kwéy ǹsɔ̃̀, kèkõyṍ névye náh tɔ̃ ńmɔ wɛ n pi, ǹtɛ yépi tɛ̃̀ wɔ kɩ ń wɛ. Tɛ́ ńmɔ-á fyɔ̀nɩ̀ mɛ min sɔkɔ, képah ye yépi tɔ kɩ mɛ n pi min sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Lésõ-à pɔ nɔ, yé kɩ pɩ̃ nɛ ńmɔ ànɛ̂ ń Sú Liyel-á mɛ núkúlɛ, tɛ́ ńmɔ ànɛ̂ yépi tɔ mó mɛ núkúlɛ. ");
INSERT INTO wib_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Névi nɛ̂-à ń tyi kõ̀nsàhnɔ́ noh, tɛ́ sè tɛ̃ yĩn, ń tyɩ́ nɔ tɛ̃̀ wɔ tyɩ́. Tɛ́ ńmɔ tyɩ́-à nɔ névi nɛ̂ tyɩ́, tɛ̃̀ tyɩ́ kɩ nɔ ń Sú Liyel tyɩ́. Tɛ̃̀ tyɩ́ kɩ nɔ ńmɔ tɔ tyɩ́, tɛ́ mé kɩ ń gblɔ̌ynɛ à wɛ̃kɩ.» ");
INSERT INTO wib_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Képah sɔkɔ, Nsyude nɛ̂-á ǹ gblɔ̌y Nsyudasɩ Yisikariyɔtɩlɛ, ǹmɔ mɛ yo Yesu tyɩ́ nɛ, Tɛ̃̀ ǹgbɛ̃, sɔ̃́ se pɩ tɛ́ à kɩ ǹ gblɔ̌ynɛ pépi wɛ̃kɩ, tɛ́ à náh ǹ gblɔ̌ynɛ kèkõyṍ névye wɛ̃kɩ n pi nɩ? ");
INSERT INTO wib_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","À mɛ yo ǹ tyɩ́ nɛ: «Ńmɔ tyɩ́-à nɔ nɛ̂ tyɩ́, tɛ̃̀ kɩ ń tyíyónɔ́lɛ n pɩ. Tɛ̃̀ tyɩ́ kɩ nɔ ń Sú Liyel tyɩ́, tɛ́ ńmɔ ànɛ̂ ń Sú Liyel kɩ pɔ tɛ̃̀ tyɩ́, kɩ pɔ twah tɛ̃ ǹ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ǹtɛ ńmɔ tyɩ́-à nɔ́-ńkɛ̃̂nɛ nɛ̂ tyɩ́, tɛ̃̀ náh ń tyíyónɔ́lɛ n pɩ. Tɛ́ wɛlɔ nónó-á yé n nohnɩ yɔ̀, ńmɔ yah yĩ́ĩ́ wɛlɔ náh sélɛ dɛ́! Sè wil Sú Liyel tyɩ́, nɛ̂-á tɛkɩ mɔ ńnɛ. ");
INSERT INTO wib_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Mé ye kénɛ tyi yo yé syah, gbĩ́ nɛ̂-á mé mɛ ànɛ̂ yélɛ yɔ̀. ");
INSERT INTO wib_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ǹtɛ Liyel Mirki nɛ̂-á yòhnɩ̀nmɔ-òlɛ, Sú Liyel kɩ n tɛkɩ n mɔ n pi ńmɔ yĩn yõ, à kɩ pɔ tyi póllɛ yé kwɔ. Tɛ́ kɩ yé dyɔ to kõ ńmɔ tyíyónɔ́lɛ, máh nónó yo sɔkɔ yé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Yèvɩnɩ ye mé yélɛ n kɔ̃ yɔ̀. Ńmɔ yèvɩnɩ ye mé yélɛ n kɔ̃. Mé náh mɛ kélɛ n kɔ̃ kèkõyṍ névye kɔ̃ dùkùlɛ. Yé káh yɛ yé fɔkɔ fɛ̃kɩ, yé káh yɛ tíkí yé tɛ̃. ");
INSERT INTO wib_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Mé ye kè yo sɔkɔ tɛ yé tyɩ́ yé noh nɛ sɔ́kɔ́nɔ́-á ńnɛ, tɛ́ máh kɩ ń syɩ n pɔ n pi yé tnɔ̂. Ń tyɩ́-à sõ̀ mɛ nɔ yé tyɩ́, yáh kè noh nɛ máh n yuku Sú Liyel tĩ̀nnɛ, kè sõ̀ yɩ̃nɛ kè nɛ n mɛ nɩ̀vɩ̀nɩ̀nɛ yé tyɩ́, ǹmɔ-á sɔ̃́npɩ́lɛ kal ńmɔlɛ. ");
INSERT INTO wib_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Mé ye kénɛ tyi yo sah yé tyɩ́ núkúnúkú sé pɔ́npɩ́-ńkɛ̃̂ sɔkɔ yɔ̀, képah sɔkɔ sàh kɩ pɔ n pɩ, yé kɩ sɛ̃ ń wɛlɔ yõ. ");
INSERT INTO wib_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Kèkõyṍ névye fnɛ̀-ò mɛ n pi, képah ye mé náh tɔ̃ n kah n yãh n mo n pi yélɛ. À náh fɛ̃ ńmɔ tɛ̃̀ wɔ fnɛ. ");
INSERT INTO wib_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ǹtɛ Sú Liyel-á tyi nónó yo ń tyɩ́, sépi ye mè n nɛ n pɩ. Képah sɔkɔ, kèkõyṍ névye kɩ pɩ̃ nɛ ǹ tyɩ́-á nɔ ń tyɩ́. Yé yuku! Á ye yal ásõ̂.» ");
INSERT INTO wib_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Képah sɔkɔ, Yesu tɔ̃ nɛ: «Ńmɔ ye yɛrɛsɛ̃ séswɔ̂ yèsyɩ̀kɩ̀lɛ, ń Sú mɛ ké nɛ́tɛ̃̀nɛ. ");
INSERT INTO wib_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Yɩ̃̀ngbã̀n nónó pól-á mɛ ńmɔ sɔkɔ tɛ́ sè náh mɛ n syi, à kɩ sè kɔ̃lɩ tɛ̃ yõ. Tɛ́ nónó pól-á mɛ n syi, à kɩ sépilɛ n tɔ̃ sè kɔ̃ sè kɩ n gbah n syi. ");
INSERT INTO wib_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Wɛy nɛ̂-á mé yo yé tyɩ́ yɔ̀, képah gbõ̀ yõ, yé pɩ tɛ yályál. ");
INSERT INTO wib_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Yé nɛ n mɛ ńmɔlɛ, sɔ̃́-á ńmɔ mɛ yélɛ. Sɔ̃́-á yɩ̃̀ngbõ̀ náh fɛ̃ n syi n pi ké gblɔ̌y nɛ́ kè náh mɛ séswɔ̂ sɔkɔ, sɛ̃́ ó ye yépi tɔ náh fɛ̃ tir yɔ́ pɩ n pi nɛ́ yé náh mɛ ńmɔlɛ. ");
INSERT INTO wib_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ńmɔ ye yɛrɛsɛ̃ séswɔ̂lɛ, yépi mɛ ké yɩ̃̀ngbã̀nnɛ. Yé náh fɛ̃ tir yɔ́ ńtɛ̃ pɩ n pi ńmɔ kɛ̃́nɛ. Képah ye, nɛ̂-à mɛ ńmɔlɛ, tɛ́ mé mɛ tɛ̃̀nɛ, tɛ̃̀ kɩ tyípéplɔ náhnáhlɛ n pɩ Liyel tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Névi nɛ̂-à mɛ́-ńkɛ̃̂nɛ ńmɔlɛ, tɛ̃̀ mɛ yɩ̃̀ngbõ̀ yɔ́ tyɩ́ kɔ̃lɛ, nɛ̂-á pè kãm milki kégbɔ́, tɛ́ kè kɩ n kɔkɔ n pi. Tɛ́ yɩ̃̀ngbã̀n kɔ́kɔ́rɩ́lɛ, sépi kɩ pɔ kwel mɔ n sukɛ n pi nyàh sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ǹtɛ yâh mɛ ńmɔlɛ, tɛ́ ń wɛlɔ mɛ n tɛ̃ yé fɔkɔnɩ sɔkɔ, kwâh nɛ̂ tyɩ́-à nɔ yé tyɩ́, yé kè ni, yé kɩ kè wɛ. ");
INSERT INTO wib_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Yâh tyípéplɔ náhnáhlɛ n pɩ Liyel tyɩ́, képah ye kɩ kè wɛ̃kɩ nɛ yáh pɩ ńmɔ tõ̀ sã́hpúlɛ. Tɛ́ ńmɔ Sú Liyel yĩn kɩ gbilki. ");
INSERT INTO wib_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ńmɔ tyɩ́-á nɔ Sú Liyel tyɩ́ sɔ̃́, yépi tɔ tyɩ́ nɔ ńmɔ tyɩ́ sɛ̃́. Yé yɛ yé tyɩ́ nɛ mɛ nɔ́ntɛ̃̀nɔ́lɛ ń tyɩ́ sɛ̃́. ");
INSERT INTO wib_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Yâh ń tyi kõ̀nsàhnɔ́lɛ n pɩ, yé tyɩ́ kɩ mɛ nɔ́ntɛ̃̀nɔ́lɛ ń tyɩ́, sɔ̃́-á ńmɔ ń Sú tyi kõ̀nsàhnɔ́lɛ n pɩ, tɛ́ ń tyɩ́lɛ nɔ́ntɛ̃̀nɔ́lɛ ǹ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Mé mɛ ké tyɩ́ nɛ nɩ̀vɩ̀nɩ̀ nɛ̂-á mɛ ńmɔ sɔkɔ, kè nɛ mɛ yépi tɔ sɔkɔ, tɛ́ yé nɩ̀vɩ̀nɩ̀ mɛ̀ mó syɩ ké yĩ̀n tyɩ́. Képah ye, mé tyi nɔ́pi yo yé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Máh nɛ̂ kõ sah yé kɔ̃, kè wɛ yɔ̀: Yé tyɩ́ yɩ̃nɛ kè nɔ wɛ̃ tyɩ́, yé tyɩ́-á nɔ sɔ̃́ ńmɔ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Névi-à ǹ min kɔ̃ ǹ kódíbí yĩnnɛ, tyɩ́nɔnɔ ǹgbɛ̃ yɔ́ náh tɔ̃ fɛ̃ n kah n mɔ n pi képah yõ. ");
INSERT INTO wib_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ńmɔ-á nɛ̂ kõ sah yé kɔ̃, yáh kɩ mɛ kélɛ n pɩ, ń kódíbí ye yélɛ. ");
INSERT INTO wib_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Mé náh tɔ̃ yé ye n pi tõ̀npɩbɩlɛ. Ǹgbǒ tõ̀npɩ náh fɛ̃ ǹ yõ̀tɛ̃̀ dĩ́ tyípɩ́nɔ́ pɩ̃ dɛ́! Ǹtɛ máh tyi nónó noh ń Sú Liyel tyɩ́, mé ye sé póllɛ yépi kwɔ. Képah ye, mé yélɛ n ye ń kódíbílɛ. ");
INSERT INTO wib_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Yépi náh yah tɔkɔ ńmɔlɛ dɛ́, ńmɔ ye yah tɔkɔ yélɛ, tɛ́ yé tɛkɩ mɔ nɛ, yé kyɩ tyípéplɔlɛ n pɩ Liyel tyɩ́, nónó-á sé yõre náh n tyɛ n yah n pi. Képah sɔkɔ, yâh kwáhdúkú nɛ̂ ni Sú Liyel tyɩ́ ńmɔ yĩn yõ, à kɩ kélɛ yé kɔ̃. ");
INSERT INTO wib_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ǹtɛ nɛ̂-á mé n kõ n sah yé tyɩ́, kè wɛ yɔ̀: Yé tyɩ́ yɩ̃nɛ kè nɔ wɛ̃ tyɩ́.» ");
INSERT INTO wib_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Képah sɔkɔ, Yesu tɔ̃ nɛ: «Kèkõyṍ névye-à yé dyɔlɛ n yɔ, yé pɩ̃ nɛ ńmɔ ǹgbò dyɔ-á pè tyah n yɔ. ");
INSERT INTO wib_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Yâh sõ̀ mɛ kèkõyṍ névye tyɩ́ yõ sɔkɔ, yáh pɩ pé tyɩ́lɛ sɛ̃́, yé tyɩ́ náhkɩ nɔ pé tyɩ́. Ǹtɛ kǎh pɩ ńmɔ yé yah wilki kèkõyṍ névye sɔkɔ, tɛ́ yé náh tɔ̃ mɛ pépi tyɩ́ yõ, képah ye pè kɔ̃ pè yé dyɔlɛ n yɔ. ");
INSERT INTO wib_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Yé yé dyɔ sah nɛ n kwnɛ wɛy mɛ̀ tyɩ́lɛ, máh nɛ̂ yo yé tyɩ́ nɛ: ‹Tõ̀npɩ náh fɛ̃ n kal ǹ yõ̀tɛ̃̀nɛ.› Pàh kɩ mɛ ńmɔ fõh, pè kɩ yé tɔ fõh. Pàh kɩ mɛ ń wɛy fɛ̃ syi, pè kɩ yé tɔ tyɩ́ fɛ̃ syi. ");
INSERT INTO wib_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ǹtɛ pè náh sɔ̃́npɩ́lɛ mɛ ńmɔ tṍ-òlɛ n pnɛ, képah ye pè kɩ tyi nɔ́pi pól pɩ yé sɔkɔ ńmɔ yĩnnɛ. ");
INSERT INTO wib_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Mâh sõ̀ mɛ pɔ́-ńkɛ̃̂nɛ pé tyɩ́, ànɛ̂ mâh sõ̀ mɛ tir yɔ́ yó-ńkɛ̃̂nɛ pé tyɩ́, pé tyítúkúnì pɩ́nɔ́ lékàh náh náhkɩ n mɛ n pi pé yõ. Ǹtɛ núkúnúkú, gbɩ wɛ́-ńsah yɔ́ ńtɛ̃ náh n wɛ n pi pé tyɩ́ pé tyítúkúnì pɩ́nɔ́ tyɩ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Névi nɛ̂-à ńmɔ dyɔlɛ n yɔ, tɛ̃̀ mɛ ń Sú tɔ dyɔlɛ n yɔ. ");
INSERT INTO wib_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Tyi nónó-á ǹnɩ̂ yɔ́ ńtɛ̃ náh sɛ̃́nknɔ pɩ yah, mâh sõ̀ mɛ sépi pɩ́-ńkɛ̃̂nɛ pé wrɔ́ sɔkɔ, pé tyítúkúnì pɩ́nɔ́ lékàh náh náhkɩ n mɛ n pi pé yõ. Ǹtɛ núkúnúkú, pè ye ńmɔ tyípɩ́nɩ̀ wɛ. Tɛ́ képah fyé yõ, pè mɛ ńmɔ ànɛ̂ ń Sú dyɔlɛ n yɔ. ");
INSERT INTO wib_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ǹtɛ nɛ̂-á wã́rkɩ́nsàhnɔ́lɛ pé tyi kõ̀nsàhnɔ́ sɔkɔ nɛ: ‹Pè ń dyɔ yɔ yõ kɛ̃́nɛ.› képah wil yĩn ye pè kɔ̃ pè képahlɛ n pɩ. ");
INSERT INTO wib_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Tɛ́ yòhnɩ̀nmɔ-ò nɛ̂-á ńmɔ kɩ n tɛkɩ n mɔ n pi kɩ wil Sú Liyel tyɩ́, Liyel Mirki ye. Képah ye gbɩlɛ névyelɛ n wɛ̃kɩ Liyel tyɩ́ sɔkɔ. Képah-à wil Sú Liyel tyɩ́ à pɔ, kè kɩ pɔ ńmɔ tyɩ́ yo wah yé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ǹtɛ yépi-á sõ̀ mɛ ànɛ̂ ńmɔlɛ ǹgbò dùkùlɛ sɛ̃́, képah ye yé tɔ kɩ ń tyɩ́lɛ n yo n wah névye tyɩ́.» ");
INSERT INTO wib_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Képah náh, Yesu tɔ̃ yo pé tyɩ́ nɛ: «Mé náh mɛ ké tyɩ́ nɛ yé Liyel yõ sɛ̃́nɔ́ yal n mɔ. Képah ye ń kɔ̃ mé tyi nɔ́pi yo sah yé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Nsyifunɔ kɩ yé yĩni n wilki n pi pé wɛ̃̀kɩ̀ sɔkɔ. Tɛ́ gbĩ yɔ́ ńtɛ̃ mɛ n pi, képah sɔkɔ nónó-à pɔ yélɛ n ko n mɔ, pè kɩ mɛ n sõ nɛ tõ̀-á pé n pɩ Liyel tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ńmɔ ànɛ̂ ń Sú pɩ̃́-ńkɛ̃̂ ye pè kɔ̃ pè kɩ sépinɔ́ tnɔ pɩ sɛ̃́ yɔ̀. ");
INSERT INTO wib_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Mé mɛ ké tyɩ́ nɛ tyi nɔ́pi gbĩ-à pópó pɔ sɛ, yé dyɔ nɛ n mɛ n kwnɛ sélɛ, képah ye mé sè yo sah yé tyɩ́.» Képah náh, Yesu tɔ̃ yo pé tyɩ́ nɛ: «Máh lésõ mɛ yé wrɔ́ sɛ̃́, képah ye mé náh kwãh tɛ̃ tyi nɔ́pi yo yé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ǹtɛ núkúnúkú, mé mɛ n yuku ń tṍ-ò tnɔ̂, tɛ́ yé sɔkɔ yɔ́ ńtɛ̃ náh se mɛ ńnɛ n piki n yah nɛ, ńyãh se mé n yuku nɩ? ");
INSERT INTO wib_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Tyi nónó-á mé yo yé tyɩ́, sépi yèkwɔrɩ ye yé fɔkɔ fil yɔ̀ kɛ̀. ");
INSERT INTO wib_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ǹtɛ mé kɩ gbɩ yo yé tyɩ́. Máh kɩ sɔkɔ, képah kɩ nɛkɩ kal yélɛ. Máh kɩ sɔ́kɔ́-ńkɛ̃̂nɛ, nɛ̂-á yɩ̃nɛ à pɔ yé yohnɩ n mɔ, à náh n pɔ n pi. Ǹtɛ máh kɩ kyɩ, mé kɩ à tɛkɩ mɔ yé kɔ̃. ");
INSERT INTO wib_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Tɛ́ ǹmɔ-à pɔ gbĩ́ nɛ̂nɛ, à kɩ tyípêl, ànɛ̂ gbɩ wɛ̃̀kɩ̀, ànɛ̂ Liyel tukey tyɩ́ yo wah kèkõyṍ névye syah, kɩ kélɛ pè wɛ̃kɩ nɛ pǎh mɛ pílkínɔ́lɛ sépi pól sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","À kɩ kélɛ pè wɛ̃kɩ nɛ nɛ̂-á pé tyípékèlɛ, péwɔ yõ sɛ̃́-ńkɛ̃̂-á. ");
INSERT INTO wib_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Tɛ́ kɩ kélɛ pè wɛ̃kɩ nɛ nɛ̂-á mɛ gbɩ wɛ̃̀kɩ̀ tyɩ́ sɔkɔ, péwɔ-á n sɔkɔ Sú Liyel tyɩ́, tɛ́ pè náh tɔ̃ pé wɛ n pi. ");
INSERT INTO wib_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Tɛ́ kɩ tɔ̃ kélɛ pè wɛ̃kɩ nɛ nɛ̂-á mɛ Liyel tukey tyɩ́ sɔkɔ, nɛ̂-á kèkõyṍ mɛ̀ névye fnɛ̀-òlɛ, lékàh-á mɛ tɛ ǹmɔ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Tyi náhnáh tɔ̃ mɛ ń tyɩ́ yo yo tɛ̃̀nɛ yé tyɩ́. Ǹtɛ máh kɩ sè yo yé tyɩ́ núkúnúkú, sè kɩ kǎn pɩ yélɛ. ");
INSERT INTO wib_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Liyel Mirki nɛ̂-á gbɩlɛ névyelɛ n wɛ̃kɩ Liyel tyɩ́ sɔkɔ, ǹmɔ-à pɔ gbĩ́ nɛ̂nɛ, à kɩ pɔ yé yah tɛ̃ yé kɔ̃ yé kɩ gbɩ dùkù pól pɩ̃ Liyel tyɩ́ sɔkɔ. Ǹ yah yĩ́ĩ́ wɛlɔ náh à kɩ pɔ n yo dɛ́! Wǎh tyi nónó pól noh, sépi ye à kɩ pɔ yo yé tyɩ́ ànɛ̂ tyi nónó-á mɛ n pi. ");
INSERT INTO wib_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","À kɩ tyilɛ n wɛ n syi ńmɔ tyɩ́ kɩ n yo yé tyɩ́. Képah ye, ǹmɔ gbõ̀ yõ ńmɔ yĩn kɩ n gbilki. ");
INSERT INTO wib_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Kwâh nɛ̂-á fyɔ̀ mɛ Sú Liyel tyɩ́, ńmɔ tɔ tyɩ́ ye kélɛ. Képah ye ń kɔ̃ mé nɛ Liyel Mirki-á kɩ ńmɔ tyilɛ n wɛ n syi n yo yé tyɩ́.» ");
INSERT INTO wib_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Képah yóntɛnɔ náh, Yesu tɔ̃ nɛ: «Dǒ kwéy, yé náh tɔ̃ ń wɛ n pi. Tɛ́ dǒ kwéy képah náh, yé kɩ tɔ̃ ń wɛ.» ");
INSERT INTO wib_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Képah tɛ̃̀nɛ, ǹ tõ̀ sã́hpú túkù tyah n yo wɛ̃ tyɩ́ nɛ, wɛy nɛ̂-á à n yo pé tyɩ́ yɔ̀ nɛ dǒ kwéy, pé náh tɔ̃ pé wɛ n pi, tɛ́ dǒ kwéy képah náh, páh kɩ tɔ̃ pé wɛ, képah yõ se pɩ tir nɛ̂nɛ nɩ? Ànɛ̂ tir nɛ̂ se à n yo sɛ̃́ yɔ̀ nɛ, páh n sɔkɔ Sú Liyel tnɔ̂ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Dǒ kwéy nɛ̂ tyɩ́-á à n yo yɔ̀, tir nɛ̂ se képah n wɛ̃kɩ nɩ? Pépi náh mɛ ǹ wɛy mɛ̀ syɩ́kɩ́-ńsah wɛ dɛ́! ");
INSERT INTO wib_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ǹtɛ Yesu-á pɩ̃ nɛ, pǎh mɛ n yah n kɔ̃ pé píkínyah-ńsahlɛ, à yo pé tyɩ́ nɛ: «Máh yo yé tyɩ́ nɛ dǒ kwéy, yé náh tɔ̃ ń wɛ n pi, tɛ́ dǒ kwéy képah náh, yáh kɩ tɔ̃ ń wɛ, képah tyɩ́ yõ ye yé n piki n yah wɛ̃nɛ yɔ̀ kɛ̀? ");
INSERT INTO wib_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Kègbɩgbɩ tɛ̃̀ yõ, mé kélɛ n yo yé tyɩ́, yé kɩ pɔ n gbo kɩ yãm yãm tyilɛ n yo, tɛ́ kèkõyṍ névye kɩ mɛ nɩ̀vɩ̀nɩ̀ sɔkɔ. Yé kɩ mɛ yèkwɔrɩ sɔkɔ, ǹtɛ yé yèkwɔrɩ kɩ pɔ vi mɔ pɩ nɩ̀vɩ̀nɩ̀nɛ. ");
INSERT INTO wib_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Sê-à pilɛ n dubi gbĩ́ nɛ̂nɛ, yèvyãhrɩ pɩ gbĩ́-á yĩni tɛ̃ ǹ tyɩ́ sɛ̃́, kè n nɛ yèkwɔrɩlɛ ǹ tyɩ́. Ǹtɛ wàh dubi tɛ, névi wɛ́ndubinmɔnɔlɛ kèkõyṍ ǹ tyɩ́, kè n pɩ nɩ̀vɩ̀nɩ̀ ǹgbɛ̃nɛ ǹ tyɩ́. Ǹ dyɔ n fwɔ ǹ yèvyãhrɩ pɩ́nsɔkɔnɔ tyɩ́lɛ. ");
INSERT INTO wib_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Sɛ̃́ yé yépi tɔlɛ yèkwɔrɩ sɔkɔ núkúnúkú yɔ̀. Ǹtɛ mé kɩ tɔ̃ pɔ n yah n pi yé tyɩ́. Képah sɔkɔ, kè kɩ pɩ nɩ̀vɩ̀nɩ̀nɛ yé tyɩ́ kègbɩ tɛ̃̀nɛ, nɩ̀vɩ̀nɩ̀ nɛ̂-á nɛy náh fɛ̃ kè tɛ̃ n syi n pi yé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Lésõ gbĩ̀yĩ̀kì-à pɔ nɔ, yé náh tɔ̃ ń piki n yah n pi tir yɔ́ ńtɛ̃ tyɩ́lɛ. Kègbɩgbɩ tɛ̃̀ yõ, mé kélɛ n yo yé tyɩ́, yâh kwáhdúkú nɛ̂ ni Sú Liyel tyɩ́ ńmɔ yĩn yõ, à kɩ kélɛ yé kɔ̃. ");
INSERT INTO wib_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Tɛ́ à pɔ syɩ núkúnúkú tyɩ́, yé náh tɔ̃̌nɩ̀ mɛ kwâh yɔ́ ńtɛ̃ ni ńmɔ yĩn yõ. Yé nɛ n ni, yé kɩ n wɛ n syi. Képah sɔkɔ, yé nɩ̀vɩ̀nɩ̀ kɩ syɩ ké yĩ̀n tyɩ́.» ");
INSERT INTO wib_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Képah náh, Yesu tɔ̃ nɛ: «Mé ye tyi nɔ́pi pól yãh yé tyɩ́ sèmìrn sɔkɔ. Tɛ́ sõ yɔ́ mɛ n pi, mé náh tɔ̃ n yãh n pi yé tyɩ́ sèmìrn sɔkɔ. Ǹtɛ mé kɩ Sú Liyel tyɩ́ yo wah pallɛ yé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Lésõ gbĩ̀yĩ̀kì-à pɔ nɔ, yé kɩ ǹnɛ n ni ńmɔ yĩn yõ. Tɛ́ mé náh yo yé tyɩ́ nɛ ńmɔ-á kɩ n ni ǹnɛ yé tyɩ́ dɛ́. ");
INSERT INTO wib_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Yé náh wɛ di, yé tyɩ́ nɔ Sú Liyel tyɩ́. Ńmɔ tyɩ́-á nɔ yé tyɩ́, tɛ́ yé sɛ̃ ké yõ nɛ máh wil ǹmɔ tyɩ́, képah ye yé tyɩ́ nɔ ǹ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Sú Liyel tyɩ́ ye mé wil à pɔ kèkõyṍ. Ǹtɛ núkúnúkú, mé kɩ tɔ̃ yal kèkõyṍ kɩ n yuku n pi ǹmɔ tyɩ́.» ");
INSERT INTO wib_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Yesu-á yo sɛ̃́, ǹ tõ̀ sã́hpú nɛ ɔ̃̀hɔ̃̂, núkúnúkú tɛ̃̀nɛ, wǎh pyě mɛ tyilɛ n yo n wah pallɛ sèmìrn mɩ́-ńkɛ̃̂nɛ. ");
INSERT INTO wib_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Pépi-á pɩ̃ núkúnúkú nɛ, wǎh tyi póllɛ n pnɛ. Pǎh nɛ à piki n yah n pi tir nɛ̂nɛ, à n nɛ n mɛ kè pɩ̃ n tɛ. Képah-á pépi sɛ̃ ké yõ nɛ, wǎh wil Liyel tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Képah sɔkɔ, Yesu nɛ: «Yé sɛ̃ ńmɔ yõ núkúnúkú yé yo kɛ̀? ");
INSERT INTO wib_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ǹtɛ gbĩ yɔ́ mɛ n pi, nɛ̂-á mɛ tɛ núkúnúkú ńtɛ̃nɛ yɔ̀, nɛ̂ sɔkɔ-á yé pól kɩ to karkɩ, kɩ sɔkɔ yé wìl-ǹtã̀n sɔkɔ, tɛ́ kɩ ńmɔ sah ń gblɔ̌y. Ǹtɛ Sú Liyel kɩ mɛ ńnɛ. Képah ye mé náh kɩ n mɛ n pi ń gblɔ̌y. ");
INSERT INTO wib_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ńmɔ mɛ ké tyɩ́ nɛ yé yèvɩnɩ wɛ ńmɔ tyɩ́, képah ye mé tyi nɔ́pi yo yé tyɩ́. Yé kɩ yèvyãhrɩ pɩ n pi kèkõyṍ sɔkɔ. Ǹtɛ yé káh tíkí pɩ, ńmɔ ye tɛ̃ wɛ kèkõyṍ tyɩ́.» ");
INSERT INTO wib_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesu-á képah yo tɛ sɛ̃́, à ǹ yah yɔ̃ yĩ̂nyõ tɛ́ nɛ: «Bɔ̌, ké gbĩ́ ye nɔ núkúnúkú. Gbílkínɔ́ sah ńmɔ yõ, ńmɔ tɔ mó gbílkínɔ́ sah á yõ. ");
INSERT INTO wib_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Áwɔ ye tɛ̃́nwɛnɔlɛ ń kɔ̃ no pól yõ, nɛ mé tyɛ́-ńkɛ̃̂ minnɛ pé pól kɔ̃, nónó-á á dahbɩ ń gbõ̀. ");
INSERT INTO wib_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Áwɔ nɛ̂-á Liyel núkúnínɛ kègbɩ yõ, pàh áwɔ pɩ̃, tɛ́ ńmɔ Yesu Krista pɩ̃, ńmɔ nɛ̂-á á tɛkɩ mɔ, képah ye tyɛ́-ńkɛ̃̂ minnɛ. ");
INSERT INTO wib_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Wáh tõ̀ nɛ̂ dahbɩ ń gbõ̀ pɩ pɩ tɛ̃̀nɛ, mé ye kè pɩ tɛ. Ńmɔ ye gbílkínɔ́ sah á yõ sétáh yõ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Núkúnúkú tɛ̃̀nɛ Bɔ̌, gbílkínɔ́ nɛ̂-á sõ̀ mɛ ńmɔ yõ á gbɔ̀pɔ kèkõyṍ mɔ́-ńkɛ̃̂ gbĩ́ dùkùlɛ, képahlɛ ńmɔ kɔ̃ á gbɔ̀pɔ sɔkɔ ńtɔ̃. ");
INSERT INTO wib_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Wáh nónó wilki kèkõyṍ névye sɔkɔ à ńmɔ kɔ̃, mé ye á dùkùlɛ pè wɛ̃kɩ. Áwɔ tyɩ́ ye sõ̀ pélɛ, tɛ́ á mɛ pélɛ ńmɔ gbõ̀ dahbɩ, pè mɛ á wɛy fɛ̃ syi. ");
INSERT INTO wib_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","8","Wáh wɛlɔ nónó yo ń tyɩ́, mé ye sè yo pé tyɩ́, pè mɛ sè fɛ̃ syi. Pè pɩ̃ yĩ́ĩ́ nɛ, máh wil áwɔ tyɩ́, tɛ́ sɛ̃ ké yõ nɛ áwɔ-á tɛkɩ mɔ ńnɛ. Képah ye, núkúnúkú tɛ̃̀nɛ, pè pɩ̃ nɛ wáh yî nónó póllɛ ńmɔ kɔ̃, sǎh wil áwɔ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Pǎh pɩ áwɔ tyɩ́lɛ sɛ̃́, képah ye mé álɛ n ni pépi tyɩ́. Mé náh mɛ álɛ n ni kèkõyṍ névye tɛ̃̀ wɔ tyɩ́ dɛ́! Wáh nónónɛ ń gbõ̀ dahbɩ, pépi tyɩ́ ye mé n ni álɛ. ");
INSERT INTO wib_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Nónó pól-á áwɔ tyɩ́lɛ, ńmɔ tɔ tyɩ́ ye pélɛ. Nónó pól-á ńmɔ tyɩ́lɛ, áwɔ tɔ tyɩ́ ye pélɛ. Tɛ́ pépi gbõ̀ yõ, gbílkínɔ́ mɛ n sah ńmɔ yõ. ");
INSERT INTO wib_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ǹtɛ dǒ kwéy, ńmɔ kɩ n pɔ n pi áwɔ tyɩ́. Mé náh kɩ tɔ̃ n mɛ n pi kèkõyṍ sɔkɔ. Ǹtɛ pépi wɔ kɩ mɛ kèkõyṍ. Bɔ̌, áwɔ nɛ̂-á pèkè kɛ̃́nɛ, pè tɛ̃ n sah á tǎhkɩ̀ gbõ̀ yõ, képah nɛ̂-á á ńmɔ kɔ̃. Képah sɔkɔ, pè kɩ pɩ núkúlɛ sɔ̃́-á áwɔ ànɛ̂ ńmɔlɛ núkúlɛ. ");
INSERT INTO wib_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Máh sõ̀ mɛ pélɛ gbĩ́ nɛ̂nɛ, mé pè tɛ̃ sah á tǎhkɩ̀ gbõ̀ yõ, képah nɛ̂-á á ń kɔ̃. Mé pé yõ syɩkɩ pallɛ, ǹnɩ̂ yɔ́ ńtɛ̃ tyɩ́ náh yɩkɩ pé sɔkɔ, à wil nɛ́núkù mɛ̀ tyɩ́ sɔkɔ, nɛ̂ tyɩ́-á sõ̀ yɩ̃nɛ kè yɩkɩ, á wɛy sɛ́bɛ́y sɔkɔ tyi wã́rkɩ́nsàhnɔ́ kɔ̃ sè wɛ n wil. ");
INSERT INTO wib_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Ǹtɛ núkúnúkú, ńmɔ-á n pi áwɔ tyɩ́, képah ye mé tyi nɔ́pilɛ n yo tɛ́ ń sah kèkõyṍ sɔkɔ, nónó-á kɩ pè kɔ̃ pè kɩ mɛ nɩ̀vɩ̀nɩ̀ yèsyɩ̀kɩ̀ sɔkɔ ńmɔ tyɩ́ kɔ̃lɛ. ");
INSERT INTO wib_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Mé á wɛy yo pé tyɩ́. Pè náh tɔ̃ pɩ kèkõyṍ tyɩ́lɛ, sɔ̃́-á ńmɔ náh pɩ kèkõyṍ tyɩ́lɛ. Képah ye, kèkõyṍ névye pé dyɔlɛ n yɔ. ");
INSERT INTO wib_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Mé náh mɛ álɛ n ni nɛ, á pè tɛ̃ n yal kèkõyṍ dɛ́! Ǹtɛ nɛ n yah pé yõ, pèkè pɩ́-ò káh tɛ̃ wɛ pé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Sɔ̃́-á kèkõyṍ tyɩ́ náh ńmɔlɛ, sɛ̃́ ye kèkõyṍ tyɩ́ náh pépi tɔlɛ. ");
INSERT INTO wib_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Pè wilki n sah á tyɩ́ yõ á gbɩ gbõ̀ yõ. Á wɛynɛ, gbɩ ye kélɛ. ");
INSERT INTO wib_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Wáh ńmɔ tõ sɔ̃́ kèkõyṍ sɔkɔ, sɛ̃́ ye mé pé tɔlɛ n tõ kèkõyṍ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ńmɔ ń gblɔ̌ynɛ álɛ n kɔ̃ ń tɔ̂ɔ́ pépi yĩnnɛ, nɛ pé tɔ nɛ n mɛ áwɔ tyɩ́ yõ gbɩ tɛ̃̀ yõ. ");
INSERT INTO wib_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Ǹtɛ mé náh mɛ álɛ n ni pépi ó yĩnnɛ dɛ́! Nónó tɔ-á kɩ pɔ n sɛ̃ n pi ńmɔ yõ pépi tyíyónɔ́ gbõ̀ yõ, pépi tɔ tyɩ́ ye mé n ni álɛ. ");
INSERT INTO wib_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Mé álɛ n ni nɛ pé pól pɩ núkúlɛ. Áwɔ nɛ̂-á Bɔ̌lɛ, áwɔ ànɛ̂ ńmɔ-á mɛ núkúlɛ sɔ̃́, pépi ànɛ̂ ápi tɔ pɩ núkúlɛ sɛ̃́, kèkõyṍ névye kɔ̃ pè pɩ̃ nɛ áwɔ-á tɛkɩ mɔ ńnɛ. ");
INSERT INTO wib_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Wáh gbílkínɔ́ sah ńmɔ yõ sɔ̃́, ńmɔ tɔ ye gbílkínɔ́ sah pé yõ sɛ̃́, nɛ pè pɩ núkúlɛ sɔ̃́-á áwɔ ànɛ̂ ńmɔlɛ núkúlɛ. ");
INSERT INTO wib_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ńmɔ mɛ pélɛ, áwɔ mɛ ńmɔlɛ. Kǎh pɩ sɛ̃́, pè kɩ pɩ yĩ́ĩ́ núkúlɛ. Képah sɔkɔ, kèkõyṍ névye kɩ pɩ̃ nɛ, áwɔ-á tõ ńmɔlɛ, ànɛ̂ no nɔ́pi tyɩ́-á nɔ á tyɩ́, sɔ̃́-á ńmɔ tyɩ́ nɔ á tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Bɔ̌, wáh nónónɛ ń gbõ̀ dahbɩ, mé mɛ ké tyɩ́ nɛ pépi tɔ nɛ n mɛ ńnɛ máh kɩ n mɛ n pi ńyãh sɔkɔ, pè mó ń tɔ̃́rɩ́ wɛ. Ńmɔ tyɩ́-á mɛ nɔ́nɔ́lɛ á tyɩ́ kèkõyṍ mɔ́-ńkɛ̃̂ gbĩ́ dùkùlɛ sɛ̃́, képah ye á tɔ̃́rɩ́ mɛ̀nɛ ń kɔ̃. ");
INSERT INTO wib_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Bɔ̌, áwɔ nɛ̂-á mɛ tómm, kèkõyṍ névye náh ǹ pɩ̃, ǹtɛ ńmɔ wɔ ǹ pɩ̃. Tɛ́ no nɔ́pi tɛ̃̀ wɔ pɩ̃ nɛ, áwɔ-á tõ ńnɛ. ");
INSERT INTO wib_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Mé ye á dùkùlɛ pè wɛ̃kɩ, tɛ́ kɩ tɔ̃ á dùkùlɛ pè wɛ̃kɩ n pi, nɛ ńmɔ tyɩ́-á nɔ sɔ̃́ á tyɩ́, kénɛ tyɩ́nɔnɔ dùkù nɛ n mɛ pé tɔ sɔkɔ, ànɛ̂ ńmɔ mó nɛ n mɛ pélɛ.» ");
INSERT INTO wib_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Wɛlɔ nɔ́pi yóntɛnɔ náh, Yesu ànɛ̂ ǹ tõ̀ sã́hpú wil sɔkɔ à kyɩ de sésân swãh yɔ́ sɔkɔ Sedrɔ̃ nítókahnɩnɛ. ");
INSERT INTO wib_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yesu ànɛ̂ ǹ tõ̀ sã́hpú sõ̀ dar tɛ́ wɛ̃nɛ n tuke n mɔ n pɔ nɛ́npɔ́. Képah ye, Nsyudasɩ nɛ̂-á sõ̀ mɛ vìnɔ́ sɔkɔ Yesu náh, ǹ tɔ sõ̀ nɛ́npɔ́ pɩ̃. ");
INSERT INTO wib_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Képah sɔkɔ, sárká syínwìlkìpu yõ̀tãm ànɛ̂ Farisi wɛ̃̀kɩ̀ kɔ́pú mɛ sràsyíbí tĩ̀nkì ànɛ̂ Liyel ní-ńsah gbô syɩ́kɩ́pú tõ. Nsyudasɩ mɛ pépi yah tɛ̃ à pɔ de pélɛ swãh mɛ̀ sɔkɔ. Nɩ̀ sõ̀ mɛ pé tyɩ́ wóhntɛ̃nyĩnnɔlɛ pé gbã̀n sɔkɔ, ànɛ̂ fɔ̀tnɔ̀nɔ́lɛ, à tahlɩ mɛ́fwóyî tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ǹtɛ tir nɛ̂-á sõ̀ nɛ n pɩ n pi, Yesu-á sõ̀ mɛ kè pɩ̃ sɛ̃́, à nɔ de pé tnɔ̂ tɛ́ pè piki yah nɛ, nɛ̂ se pè n yah n kɔ̃ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Pè mɛ à syah nɛ, Nasarɛtɩ kwil Yesu-á. À mɛ yo pé tyɩ́ nɛ: «Ńmɔ ye.» Tɛ́ Nsyudasɩ nɛ̂-á kɩ sõ̀ à dahbɩ n pi pé gbõ̀, ǹmɔ sõ̀ mɛ yĩ́nntɛ̃̀nɔ́lɛ gbɔ̀pɔlɛ. ");
INSERT INTO wib_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yesu-á fyɔ̀ yo pé tyɩ́ nɛ péwɔ-á, pè pé syɩ náhsékǔrnnɛ à kyɩ syɩkɩlɩ sétáh. ");
INSERT INTO wib_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","À mɛ tɔ̃ ǹ syɩ pè piki yah nɛ, nɛ̂ se pè n yah n kɔ̃ nɩ? Pè mɛ nɛ, Nasarɛtɩ Yesu-á. ");
INSERT INTO wib_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Képah sɔkɔ, à mɛ yo pé tyɩ́ nɛ: «Mé ye kè yo tɛ yé tyɩ́ nɛ ńmɔ-á. Ńmɔ-à kɩ nɛ̂ yé n yah n kɔ̃, yé yɛ no nɔ́pi kɔ̃ pè nɛ n yuku.» ");
INSERT INTO wib_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Képah-á pɩ sɛ̃́, wǎh lésõ wɛy nɛ̂ yo sah, kè wil. À lésõ nɛ: «Bɔ̌, wáh nónónɛ ń gbõ̀ dahbɩ, mé náh yɛ pé sɔkɔ yɔ́ ńtɛ̃ tyɩ́ yɩkɩ.» ");
INSERT INTO wib_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Tɛ́ dĩ́ yɔ́ tɔ lésõ mɛ pélɛ pè n ye Malkusilɛ. Sárká syínwìlkìpu yõ̀tɛ̃̀ ǹgbɛ̃ tõ̀npɩ ye ǹnɛ. Tɛ́ Simo-Pyɛrɩ tyɩ́ kèkírkì yɔ́ sõ̀ mɛ. À mɛ kè yɔrɩ dɛ à kénɛ dĩ́ gbõ̀yõ̀ sõ̀ níkí kõ kãm. ");
INSERT INTO wib_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ǹtɛ Yesu mɛ yo Pyɛrɩ tyɩ́ nɛ: «Á kèkírkì dyɩ ké gbô sɔkɔ. Á se mɛ n sõ nɛ, Sú Liyel-á yèvyãhrɩ nɛ̂ yah tɔkɔ sah nɛ mé pɔ n pɩ, máh kɩ kè yahle?» ");
INSERT INTO wib_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Képah náh, sràsyíbí tĩ̀nkì ànɛ̂ pé yõ̀tɛ̃̀ ǹgbɛ̃, ànɛ̂ Nsyifunɔ Liyel ní-ńsah gbô syɩ́kɩ́pú mɛ Yesu tɛ̃, tɛ́ à pukubi, ");
INSERT INTO wib_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","à yuku ǹnɛ An ǹgbò tyɩ́. Kayifi nɛ̂-á sõ̀ sárká syínwìlkìpú yõ̀tɛ̃̀ ǹgbɛ̃nɛ léyílɛ, ǹmɔ dɛ́ndĩ́ ye sõ̀ An mɛ̀nɛ. ");
INSERT INTO wib_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Tɛ́ kénɛ Kayifi mɛ̀ wɔ ye lésõ vi mɔ pé no Nsyifunɔ yõ̀tãmnɛ nɛ ńkɛ̃́: «Dĩ́ nɛ́núkù-à kɩ ku no pól yĩnnɛ, képah kɩ nɛkɩ kal álɛ.» ");
INSERT INTO wib_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simo-Pyɛrɩ ànɛ̂ Yesu tõ̀ sã́h-ò yɔ́ sõ̀ mɛ Yesu sõ̀ tɛ̃. Képah sɔkɔ, sárká syínwìlkìpu yõ̀tɛ̃̀ ǹgbɛ̃-á sõ̀ mɛ Yesu tõ̀ sã́h-ò mɛ̀nɛ n pnɛ sɛ̃́, ǹmɔ mɛ de yuku Yesulɛ sárká syínwìlkìpu yõ̀tɛ̃̀ ǹgbɛ̃ gbô sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ǹtɛ Pyɛrɩ wɔ sõ̀ mɛ yĩn tɛ̃ kégbɔ́, gbô yah sɔkɔ. Tɛ́ Yesu tõ̀ sã́h-ò nɛ̂-à sõ̀ sárká syínwìlkìpu yõ̀tɛ̃̀ ǹgbɛ̃ nɛ́pɩ̃́nɩ́nɛ, ǹmɔ mɛ wil pɔ yo mɔ tõ̀npɩ pi tyɩ́ nɛ̂-á gbô syɩ́kɩ́-òlɛ, tɛ́ Pyɛrɩ kɔ̃ à de. ");
INSERT INTO wib_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Tɛ́ Pyɛrɩ-á n de, kénɛ tõ̀npɩ pi mɛ̀ mɛ à syah nɛ, ǹmɔ tɔlɛ Yesu mɛ̀ tõ̀ sã́h-ò kó ǹnɛ nɩ? Pyɛrɩ mɛ à syah nɛ, ǹ tõ̀ sã́h-ò náh péwɔlɛ dɛ́! ");
INSERT INTO wib_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ǹtɛ vɩrɩ sõ̀ mɛ n pɩ. Kǎh pɩ sɛ̃́, tõ̀npɩbɩ ànɛ̂ Liyel ní-ńsah gbô syɩ́kɩ́pú sõ̀ mɛ nyàh mɔ sah n wnɛ, tɛ́ Pyɛrɩ tɔ mɛ nyàhlɛ n wnɛ pélɛ. ");
INSERT INTO wib_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Tɛ́ Yesu wɔlɛ, sárká syínwìlkìpu yõ̀tɛ̃̀ ǹgbɛ̃ mɛ tyah ǹmɔlɛ n piki n yah ǹ tõ̀ sã́hpú ànɛ̂ ǹ névye kwɔ́nɔ́ tyɩ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesu mɛ yo ǹ tyɩ́ nɛ: «Mé sõ̀ mɛ ń wɛynɛ n yo n dal n mɔ no pól yĩ́ yah. Tɛ́ mɛ kwɔ́nɔ́lɛ n pɩ gbĩ́mɛgbĩ́ Liyel ní-ńtã̂n vɩ̀ sɔkɔ, ànɛ̂ Liyel ní-ńsah gbô sɔkɔ, ńyãh sɔkɔ-á Nsyifunɔ pól wɛ̃nɛ n tuke n mɔ. Mé náh tir yɔ́ ńtɛ̃ yo sètĩ̀n sõ̀ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Tɛ́ kwâh nɛ̂ pɩ á ńnɛ n piki n yah sɛ̃́? Nónó-á ń wɛy noh, pépi piki yah nɛ̂-á mé yo. Máh nɛ̂ yo, pépi wɔ kè pɩ̃.» ");
INSERT INTO wib_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yesu-á fyɔ̀ képah yo, Liyel ní-ńsah gbô syɩ́kɩ́pú sɔkɔ nɛ̂-á sõ̀ mɛ nɛ́npɔ́, ǹmɔ Yesu létáh mɩ tɛ́ nɛ, sárká syínwìlkìpu yõ̀tɛ̃̀ ǹgbɛ̃ tyɩ́ se à n wɛkɩ sɛ̃́ yɔ̀ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesu mɛ yo ǹ tyɩ́ nɛ: «Máh kɩ mɛ wɛ̀ntùkù wɛkɩ, kélɛ ń wɛ̃kɩ. Ǹtɛ máh kɩ mɛ wɛkɩ plɛ, kwâh nɛ̂ pɩ tɛ́ á ń mɩ?» ");
INSERT INTO wib_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Képah sɔkɔ, An mɛ Yesu tɛkɩ mɔ sárká syínwìlkìpu yõ̀tɛ̃̀ ǹgbɛ̃ Kayifi tyɩ́ sɛ̃́ púkúbínɔ́lɛ. ");
INSERT INTO wib_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Légbĩ́nɛ, Simo-Pyɛrɩ sõ̀ mɛ yĩn tɛ̃ nyàhlɛ n wnɛ sɛ̃́. Pè mɛ à piki yah nɛ, ǹmɔ tɔlɛ, dĩ́ mɛ̀ tõ̀ sáh-ò kó ńnɛ nɩ? À mɛ ǹ vyãh kɔ̃lɩ nɛ, ǹ tõ̀ sã́h-ò náh péwɔlɛ dɛ́. ");
INSERT INTO wib_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Pyɛrɩ-á lésõ dĩ́ nɛ̂ níkí kõ kãm, ǹ tyɩ́ névi yɔ́ lésõ mɛ sárká syínwìlkìpu yõ̀tɛ̃̀ ǹgbɛ̃ tõ̀npɩlɛ. Kénɛ tõ̀npɩ-á Pyɛrɩ wɛ, à à syah nɛ, ǹmɔ-á lésõ pé kyɩ wɛ ànɛ̂ Yesulɛ swãh sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pyɛrɩ tɔ̃ ǹ vyãh kɔ̃lɩ. Nɛ́npɔ́ swɔ, sénpɛ gbo. ");
INSERT INTO wib_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Képah tɛ̃̀nɛ, pè Yesu tɛ̃ yal Kayifi tĩ̀nnɛ, tɛ́ yuku ǹnɛ Wrome gbɛ̃̀nyah yah tɛ̃̀-ò tĩ̀nnɛ. Séngbɔ̃́ púpú ye sõ̀ pè pɩ képahlɛ. Pǎh yĩni tɛ̃, Nsyifunɔ yõ̀tãm náh fɛ̃ syi de ǹ gbô sɔkɔ. Pè náh sõ̀ mɛ ké tyɩ́ nɛ pé pé gblɔ̌y silki, pé vyãh mó dɛ Nsyifunɔ yɔ̃rɩ tyɛ́nɔ́ syáh yõke yṍnɔ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Kǎh pɩ sɛ̃́, Wrome gbɛ̃̀nyah yah tɛ̃̀-ò dĩ́ Pilati mɛ wil pɔ pé tnɔ̂ kégbɔ́, à pɔ pè piki yah nɛ, tyítúkù nɛ̂ se dĩ́ mɛ̀ pɩ pè yo nɩ? ");
INSERT INTO wib_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Pè mɛ à syah nɛ, dĩ́ mɛ̀-à sõ̀ mɛ tyítúkù pɩ́-òlɛ ńkɛ̃̂nɛ, pépi se náhkɩ pɔ ǹnɛ ǹmɔ tyɩ́ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Képah tɛ̃̀nɛ, Pilati mó Nsyifunɔ syah nɛ, pè nɛ n yuku ǹnɛ, pè kyɩ à tuke pé gblɔ̌y à yɩ̃nɛ pé tyi kõ̀nsàhnɔ́lɛ. Ǹtɛ pé tɔ mɛ à syah nɛ, névi kònmɔnɔ gbàh náh dɛ mɔ pépi tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Képah sɔkɔ, Yesu-á lésõ nɛ̂ yo sah à ǹ gblɔ̌y ku dùkù tyɩ́ yo wah, kè wil. ");
INSERT INTO wib_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Kǎh pɩ sɛ̃́, Pilati mɛ ǹ syɩ de ǹ gbô sɔkɔ, tɛ́ Yesu ye pɔ piki yah nɛ ńkɛ̃́, ǹmɔ se Nsyifunɔ yõ̀tɛ̃̀nɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","À mɛ yo ǹ tyɩ́ nɛ: «Áwɔ se sõ tɛ̃ n yo kélɛ á gblɔ̌y, tĩ̂ ǹnɩ̂ se yo ǹ syah kélɛ?» ");
INSERT INTO wib_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilati mɛ à syah nɛ, Nsyifu se yɔ́ péwɔ tɔlɛ nɩ? Ǹ yɛ̃́ngbɛ̃́ yìkì névye ànɛ̂ pé sárká syínwìlkìpu yõ̀tãm-á pɔ ǹnɛ péwɔ tyɩ́. Tir nɛ̂ se à pɩ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","À mɛ yo ǹ tyɩ́ nɛ: «Kèkõyṍ mɛ̀ sɔkɔ náh ń tɔ̃́rɩ́ n wil. Kàh sõ̀ mɛ n wil kèkõyṍ mɛ̀ sɔkɔ, ń tõ̀npɩbɩ náhkɩ sõ̀ ń fwo syi, mé náh náhkɩ n de n pi Nsyifunɔ yõ̀tãm gbõ̀. Ǹtɛ ɔ̃́ɔ̃ dɛ́, ń tɔ̃́rɩ́ náh wil ásõ̂.» ");
INSERT INTO wib_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Képah tɛ̃̀nɛ, Pilati mɛ yo ǹ tyɩ́ nɛ, yõ̀tɛ̃̀-á ǹnɛ kɛ̀? À mɛ nɛ: «Áwɔ ńtɛ̃ vyãh sɔkɔ ye kè wil nɛ yõ̀tɛ̃̀-á ńnɛ! Ńmɔ pɔ́nɔ́lɛ kèkõyṍ à pɔ dubi, gbɩ tyɩ́ yo n wah yĩn ye. Nónó-á mɛ gblɔ névyelɛ, pépi kɩ ń tyíyónɔ́lɛ n noh n tɛ̃ yĩn.» ");
INSERT INTO wib_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilati mɛ à piki yah nɛ, kwâh nɛ̂ se gbɩlɛ nɩ? Kénɛ wɛlɔ yóntɛnɔ náh, Pilati tɔ̃ ǹ syɩ wil à kyɩ yo Nsyifunɔ tyɩ́ nɛ ńkɛ̃́: «Ńmɔ náh pílkí-ńsah yɔ́ ńtɛ̃ wɛ dĩ́ mɛ̀ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Tɛ́ à yɩ̃nɛ máh dar tɛ́ kélɛ n pɩ sɔ̃́ yé tyɩ́, yimɛyí mé ńkɛ̃́nɛ yé sɔkɔ yɔ́ wilki wɔ̀kɔ̀npèkè sɔkɔ ǹ fĩn n mɔ yé yɔ̃rɩ tyɛ́nɔ́ syáh syah gbĩ́nɛ. Kǎh pɩ sɛ̃́, yé se mɛ ké tyɩ́ nɛ mé yépi Nsyifunɔ yõ̀tɛ̃̀ dĩ́ fĩn n mɔ?» ");
INSERT INTO wib_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Képah tɛ̃̀nɛ, pè gbo mɔ tũ nɛ ńkɛ̃́, ɔ̃́ɔ̃, à ǹmɔ sah, à mó Barabasɩ wɔ fĩn mɔ. Tɛ́ kèlékɛ̃ névi ye mó tɔ̃ sõ̀ Barabasɩ mɛ̀nɛ. ");
INSERT INTO wib_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Képah sɔkɔ, Pilati mɛ pè kɔ̃ pè Yesu tɛ̃ kyɩ ko yèfõhlɛ. ");
INSERT INTO wib_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Sràsyíbí mɛ pã̀n yõ̀kɔ̃ pɩ dyɩ à kɔ̃ yõ̀tɔ̃rɩ́ yṍkúrílɛ, tɛ́ mɛ fwɔ̀mɔ̀nsãh ǹgbɛ̃ yɔ́ mɔ à kɔ̃. ");
INSERT INTO wib_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Képah tɛ̃̀nɛ, pè nɔ de ǹnɛ tɛ́ n yo ǹ tyɩ́ nɛ, Nsyifunɔ yõ̀tɛ̃̀ dĩ́, páh n wɛkɩ ǹ tyɩ́! Tɛ́ mɛ ǹ létáhlɔ́lɛ n kɔ̃lɩ. ");
INSERT INTO wib_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Képah sɔkɔ, Pilati tɔ̃ ǹ syɩ wil pɔ yo tɔ́wû tyɩ́ nɛ, pè yah yɔ̀, páh kɩ Yesu wilki pɔ kégbɔ́ sɔkɔ, képah sɔkɔ pǎh kɩ pɩ̃ nɛ pé náh pílkí-ńsah yɔ́ ńtɛ̃ wɛ ǹ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Yesu mɛ wil pɔ kégbɔ́ pã̀n yõ̀kɔ̃lɛ ǹ yõ sɔkɔ, ànɛ̂ fwɔ̀mɔ̀nsãh ǹgbɛ̃nɛ mɔ́nɔ́lɛ ǹ tyɩ́. Képah tɛ̃̀nɛ, Pilati mɛ yo pé tyɩ́ nɛ, pè yah névi mɛ̀nɛ kɛ̀. ");
INSERT INTO wib_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Sárká syínwìlkìpu yõ̀tãm ànɛ̂ Liyel ní-ńsah gbô syɩ́kɩ́pú-á fyɔ̀ à wɛ, pè gbo mɔ tũ nɛ, à à syɩ dahnɩ yõ! À à syɩ dahnɩ yõ! Pilati mɛ yo pé tyɩ́ nɛ, péwɔ tɛ̃̀ wɔ náh pílkí-ńsah yɔ́ ńtɛ̃ wɛ ǹ tyɩ́. Pépi kyɩ à syɩ dahnɩ yõ sɔkɔ pé gblɔ̌y. ");
INSERT INTO wib_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Wǎh yo sɛ̃́, Nsyifunɔ à syah nɛ, tir kõ̀nsàhnɔ́ yɔ́-á mɛ pépi tyɩ́, ńkɛ̃́ à yɩ̃nɛ képah sɔkɔ wɛynɛ, dĩ́ mɛ̀-á yɩ̃nɛ kònmɔnɔlɛ, wǎh sɔ̃́npɩ́lɛ ǹ gblɔ̌ynɛ n pɩ Liyel Pídĩ́nɛ. ");
INSERT INTO wib_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilati-á kénɛ wɛy noh sɛ̃́, tíkí tɔ̃ à gbah tɛ̃. ");
INSERT INTO wib_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","À mɛ ǹ syɩ de ǹ gbô sɔkɔ à kyɩ Yesu piki yah nɛ, ńyãh se à n wil nɩ? Ǹtɛ Yesu náh dahbɩ wilki ǹ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Képah sɔkɔ, Pilati mɛ à syah nɛ, péwɔ tyɩ́ se à yahle vìnmɔnɔlɛ nɩ? À kó pɩ̃ nɛ, tɛ̃́nwɛnɔ-á mɛ péwɔ tyɩ́ kɩ fɛ̃ à fĩn mɔ, képah náh pɩ kɩ fɛ̃ à syɩ dahnɩ yõ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ǹtɛ Yesu mɛ yo ǹ tyɩ́ nɛ: «Tɛ̃́nwɛnɔ yɔ́ ńtɛ̃ náh n wɛ n pi á tyɩ́ ńmɔ yõ sɔkɔ, nɛ́ Liyel náh kélɛ ǹ kɔ̃. Képah ye, nɛ̂-á dahbɩ ńmɔlɛ á gbõ̀, ǹmɔ tyípékè kal áwɔ tyɩ́lɛ.» ");
INSERT INTO wib_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Wǎh képah yo, Pilati sõ̀ mɛ ǹ wɛ́nfĩnnmɔ-ńsahlɛ n yah n kɔ̃. Ǹtɛ Nsyifunɔ sõ̀ mɛ kah gbo mɔ tũ nɛ, wàh kɩ à fĩn mɔ, Wrome kwíltãm yõ̀tɛ̃̀ Sesar kódĩ́ tɛ̃̀ wɔ náh ǹnɛ dɛ́! Ńkɛ̃́ névi nɛ̂-á fyɔ̀ ǹ gblɔ̌ynɛ n pɩ yõ̀tɛ̃̀nɛ, Sesar sépɛ-á tɛ̃̀nɛ dò. ");
INSERT INTO wib_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilati-á fyɔ̀ wɛlɔ nɔ́pi noh, à pè kɔ̃ pè Yesu tɛ̃ wil kégbɔ́. Tɛ́ mɛ kɔ̃ tɛ̃ tukey tuke tuke kǒ yõ fɩ̃́ yɔ́ sɔkɔ, ńyãh-á mɛ mɔ́nɔ́lɛ dyêhlɛ. Pè nɛ́npɔ́lɛ n ye Kabatalɛ Yebre wɛy sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ké dĩndal kɩ sõ̀ n pɩ n pi Nsyifunɔ yɔ̃rɩ tyɛ́nɔ́ syáhlɛ. Tɛ́ gbĩ-á mɛ yõ̀tah sírr kénkɔ̃ sɔkɔ, Pilati mɛ yo Nsyifunɔ tyɩ́ nɛ, pè yah pé yõ̀tɛ̃̀nɛ kɛ̀. ");
INSERT INTO wib_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ǹtɛ pè tɔ̃ kah gbo mɔ tũ nɛ, à à ko mɔ! à à ko mɔ! À à syɩ dahnɩ yõ! Pilati mɛ nɛ, pé yõ̀tɛ̃̀nɛ pè nɛ pé syɩ dahnɩ yõ lɛ́? Sárká syínwìlkìpu yõ̀tãm mɛ yo ǹ tyɩ́ nɛ, yõ̀tɛ̃̀ yɔ́ ńtɛ̃ náh mɛ pépi tyɩ́, à wil Sesar tyɩ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Képah sɔkɔ, Pilati mɛ ǹ gbàh dɛ mɔ nɛ à syɩ dahnɩ yõ. Sràsyíbí mɛ Yesu tɛ̃ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Pǎh n sɔkɔ, pè à kɔ̃ à ǹ syɩ syɩ dahnɩ twah ǹ gblɔ̌y pè wil kwil sɔkɔ, à yuku fɩ̃́ yɔ́ sɔkɔ ńyãh-á pè n ye yõ̀gbèkè tyahlɛ, tɛ́ pè kélɛ n ye Kɔlkotalɛ Yebre wɛy sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Nɛ́npɔ́ sɔkɔ ye pè syɩ ǹnɛ dahnɩ yõ, tɛ́ mɛ nɛ́pĩ̂ nímí yísyɔ́ tɔ syɩ dahlɔ yõ ǹ gbɔ̀plɔlɛ, tɛ́ ǹmɔlɛ pé nɩyṍ. ");
INSERT INTO wib_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilati mɛ wɛy yɔ́ wãrkɩ à syɩ Yesu syɩ syɩ dahnɩ tyɩ́ ǹ yõ̀tah, nɛ̂ yõ-á kè mɛ wã́rkɩ́nsàhnɔ́lɛ nɛ ńkɛ̃́: «Nasarɛtɩ kwil Yesu, Nsyifunɔ yõ̀tɛ̃̀.» ");
INSERT INTO wib_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Pǎh Yesu syɩ dahnɩ yõ, tɛ́ wɛy nɛ̂ wãrkɩ syɩ kénɛ dahnɩ tyɩ́, ǹ yõ̀tah, kè sõ̀ mɛ Yebre wɛy sɔkɔ, ànɛ̂ Latɛ̃ wɛy sɔkɔ, ànɛ̂ Krɛkɩ wɛy sɔkɔ. Tɛ́ ńyãh sɔkɔ-á sõ̀ pè syɩ ǹnɛ dahnɩ yõ, nɛ́npɔ́ sõ̀ mɛ yúkɛy kwillɛ. Kǎh pɩ sɛ̃́, Nsyifunɔ náhnáh kè wɛ kar. ");
INSERT INTO wib_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Képah sɔkɔ, Nsyifunɔ sárká syínwìlkìpu yõ̀tãm yo Pilati tyɩ́ nɛ, à káh yɛ wã́rkɩ́nɔ́ mɛ̀ tɛ̃ sɛ̃́ nɛ, Nsyifunɔ yõ̀tɛ̃̀-á. Ńkɛ̃́ à kè wãrkɩ mɔ nɛ, dĩ́ mɛ̀-á yo nɛ ńkɛ̃́, Nsyifunɔ yõ̀tɛ̃̀-á péwɔlɛ. ");
INSERT INTO wib_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ǹtɛ Pilati mɛ yo pé tyɩ́ nɛ, páh fyɔ̀ nɛ̂ wãrkɩ tɛ, kǎh kɩ tɛ̃ sɛ̃́. ");
INSERT INTO wib_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Képah tɛ̃̀nɛ, sràsyíbí-á Yesu syɩ tɛ dahnɩ yõ, pè ǹ flɔ tɔkɔ à dibi tã̀ntã̀n ǹyẽ̂h à pɔ gbàh sah ǹ fwɔ̀mɔ̀-ǹgbɛ̃ tyɩ́. Pé nɛ́núkù núkú pól mɛ tɔkɔ núkú núkúlɛ. Tɛ́ fwɔ̀mɔ̀-ǹgbɛ̃ mɛ̀ sõ̀ mɛ kóhntel-ńsah kɛ̃́nɛ ké tyɩ́. Kè sõ̀ mɛ fwɔ núkúlɛ à tɔkɔ ké yõ̀tah tyɩ́, fɔ́ɔ́ à pɔ syɩ ké sètàhkɩ̀ sõ̀ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Pè mɛ yo wɛ̃ tyɩ́ nɛ, pé káh képah wɔ yɔrɩ n tɔkɩ. Pé ye ǹdan mɔ n yah, kàh kɩ pɩ nɛ̂ tyɩ́lɛ. Tɛ́ nɛ̂-á lésõ wã́rkɩ́nsàhnɔ́lɛ Liyel wɛy sɛ́bɛ́y sɔkɔ nɛ ńkɛ̃́: «Pè ń flɔ dibi pé wɛ̃ wrɔ́, tɛ́ ǹdan mɔ à ń fwɔ̀mɔ̀-ǹgbɛ̃ tɔkɔ.» Képah wil yĩn ye kè kɔ̃ kè pɩ sɛ̃́ yɔ̀. Sɛ̃́ ye sõ̀ sràsyíbí pɩ. ");
INSERT INTO wib_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Tɛ́ Yesu yṹ sõ̀ mɛ yĩ́nntɛ̃̀nɔ́lɛ Yesu syɩ syɩ dahnɩ tnɔ̂, ànɛ̂ ǹ yṹ gbɛ̃̀nsêlɛ, ànɛ̂ Klopasɩ kyɩ Marilɛ, à tahlɩ Makadala kwil Mari tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesu tõ̀ sã́h-ò nɛ̂ tyɩ́-á nɔ yĩ́ĩ́ ǹ tyɩ́, ǹmɔ tɔ sõ̀ mɛ yĩ́nnɔ́lɛ Yesu yṹ tnɔ̂ sɔkɔ. Yesu-á pè wɛ, à yo ǹ yṹ tyɩ́ nɛ: «Á pídĩ́ wɛ yɔ̀.» ");
INSERT INTO wib_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Képah náh, tɛ́ yo ǹ tõ̀ sã́h-ò mɛ̀ tyɩ́ nɛ: «Á nɔ̂ wɛ yɔ̀.» À tɔkɔ légbĩ́ tyɩ́, tõ̀ sã́h-ò mɛ̀ mɛ Yesu yṹ tɛ̃ à kyɩ sah ǹ gblɔ̌y tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Képah náh, Yesu-á pɩ̃ nɛ tyi pól-á pɩ dal mɔ sɛ̃́, à nɛ: «Níkì mɛ ń tɛ̃.» Képah sɔkɔ, nɛ̂-á wãrkɩ sah Liyel wɛy sɛ́bɛ́y sɔkɔ, kè wil. ");
INSERT INTO wib_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Tɛ́ pĩ́n yɔ́ sõ̀ mɛ nɛ́npɔ́ yõ̀yõ̀kè ninɛ ké yĩ́ĩ́nɛ. Sràsyíbí mɛ sènsúkúrí tɔkɔ à dahbɩ wilki kénɛ yõ̀yõ̀kè ni sɔkɔ, à dyɩ yisɔpɩ ǹdan tyɩ́, tɛ́ kè nɔ à sah Yesu vyãh yah. ");
INSERT INTO wib_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Wǎh kè wɔ, à nɛ: «Tyi pól ye wɛ pɩ dal mɔ.» Wǎh fyɔ̀ képah yo, à ǹ yõ sĩnki tɛ́ ku. ");
INSERT INTO wib_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Nsyifunɔ mɩ mɩ yòh kɩ sõ̀ n tyah n pi lékã̂h mɔ́nɔ́ sɔkɔ. Tɛ́ mɩ mɩ yòh mɛ̀ sõ̀ kal sé no tɛ́lɔ́lɛ. Képah ye, Nsyifunɔ yõ̀tãm náh sõ̀ mɛ ké tyɩ́ nɛ nónó-á mɛ syɩ́nsàhnɔ́lɛ dahlɔ yõ, pé lékyɩ̂ pɔ mɩ mɩ yòh sõ nɔ dahlɔ yõ. Kǎh pɩ sɛ̃́, pè kè yah kɔ̃ Pilati tyɩ́ nɛ, à kénɛ no nɔ́pi gbyẽ̂h kwɔkɩ pè kɔ̃ pè ku súú, pé lékyɩ̂ mó tiki n mɔ n to dahlɔ yõ. ");
INSERT INTO wib_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Képah sɔkɔ, nɛ́pĩ̂ nímí nónó-á sõ̀ pè syɩ dahlɔ yõ ànɛ̂ Yesulɛ, sràsyíbí mɛ pɔ nɛ́gben gbyẽ̂h kwɔkɩ tɛ́ ní-ò tɔ tyɩ́ kwɔkɩ. ");
INSERT INTO wib_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Tɛ́ pǎh yĩni tɛ̃ Yesu tyɩ́, pè kè wɛ ǹmɔ mɛ ku tɛ. Kǎh pɩ sɛ̃́, pè náh fwɔ̌tɛ̃̀ ǹmɔ gbyẽ̂h kwɔkɩ. ");
INSERT INTO wib_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ǹtɛ képah fyé yõ, sràsyíbí nɔ́pi sɔkɔ yɔ́ Yesu gbɔ̀pɔ tũ mɛ̀mɛ̀kɩ̀lɛ. Nɛ́npɔ́ swɔ, tṍ ànɛ̂ ni n fwɔ n wil nóré mɛ̀ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Névi nɛ̂-á n yo tyi nɔ́pilɛ, ǹ tɔ yĩ́ yah tɔ́tɔ́ sɔkɔ ye sè pɩ. Gblɔ ye ǹ tyíyónɔ́lɛ. Ǹmɔ ńtɛ̃ tɔ pɩ̃ nɛ gblɔ-á pé n yo. À tyi nɔ́pi yo nɛ yépi tɔ sɛ̃ Yesu yõ. ");
INSERT INTO wib_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ǹtɛ yah, tyi nɔ́pi pól ye pɩ Liyel wɛy sɛ́bɛ́y sɔkɔ tir wã́rkínsàhnɔ́ mɛ̀ kɔ̃ kè wil. Kè lésõ mɛ wã́rkínsàhnɔ́lɛ nɛ ńkɛ̃́: «Ǹ gbèkè yɔ́ ńtɛ̃ náh n kwɔ n pi.» ");
INSERT INTO wib_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Tɛ́ kè tɔ̃ mɛ wã́rkɩ́nsàhnɔ́lɛ Liyel wɛy sɛ́bɛ́y fɩ̃́ yɔ́ sɔkɔ nɛ ńkɛ̃́: «Pǎh névi nɛ̂ tũ, pé yɩ̃́plɔ́ pye kɩ tɛ̃ ǹ yõ.» ");
INSERT INTO wib_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Tɛ́ dĩ́ yɔ́ lésõ mɛ pè n ye Nsyosɛfulɛ. À sõ̀ n wil Arimatɩ kwil sɔkɔ. Yesu tõ̀ sã́h-ò yɔ́ ye sõ̀ ǹ tɔlɛ. Tɛ́ Nsyifunɔ yõ̀tãm tíkí-á sõ̀ mɛ à tɛ̃ sɛ̃́, képah ye à kè wɔ̃bɩ pélɛ. Kénɛ tyi pɩ́nsɔkɔntɛnɔ náh, ǹmɔ mɛ pɔ Pilati ni nɛ, à yɛ pé kɔ̃ pé Yesu lékó dɛ dahnɩ yõ pé kyɩ à yɩ̃. À mɛ ké wɛ̃̀kɩ̀lɛ à kɔ̃. Képah sɔkɔ, à mɛ kyɩ ǹ lékó dɛ. ");
INSERT INTO wib_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Tɛ́ Nikodɛmɩ nɛ̂-á lésõ kyɩ wil Yesu tyɩ́ sõ yɔ́ lékã̂hnɛ, ǹ tɔ mɛ pɔ pútúr pãn pènàl dukenɔ nínɔ́ fɛ̃̀kɩ̀nmɔnɔlɛ wɛ̃ sɔkɔ. Núkú yĩn ye mirlɛ, ní-ò yĩn mɛ alowɛsɩlɛ. Pútúr mɛ̀ sõ̀ nɔ kílónɔ́ yõgbãm kénkɔ̃lɛ. ");
INSERT INTO wib_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Pé nímí mɛ ǹ lékó tɔkɔ, tɛ́ à plo fwɔ gbrólɛ. Pè pãn pènàl yî nɔ́pi mɔ ǹ yõ, à yɩ̃nɛ Nsyifunɔ lékó yɩ̃ dùkùlɛ. ");
INSERT INTO wib_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Pǎh Yesu syɩ dahnɩ yõ ńyãh sɔkɔ, swãh yɔ́ lésõ mɛ nɛ́npɔ́ tnɔ̂ diki sã́n yɔ́lɛ ké sɔkɔ, diki nɛ̂-á nɛy náh yɩ̃ yah ké sɔkɔ póllɛ. ");
INSERT INTO wib_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Tɛ́ Nsyifunɔ mɩ mɩ yòh-á kɩ sõ̀ n tyah n pi lékã̂h mɔ́nɔ́ sɔkɔ sɛ̃́, képah ye pè mɛ Yesu lékó yɩ̃ diki mɛ̀ sɔkɔ, képah nɛ̂-á sõ̀ mɛ yúkɛy. ");
INSERT INTO wib_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Dimansyi sõ séngbɔ̃́lɛ, Makadala kwil Mari kwãh kyɩ diki yõ tósõ yɔ̃ gbĩ́nɛ. À kyɩ nɛ n yah diki yah dáhkɩ̀ náh tɔ̃ mɛ ké yah. ");
INSERT INTO wib_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Képah sɔkɔ, à to sɔkɔ à kyɩ wil Simo-Pyɛrɩ ànɛ̂ ǹ ní-ò Yesu tõ̀ sã́h-ò yɔ́ tyɩ́ nɛ̂ tyɩ́-á nɔ yĩ́ĩ́ Yesu tyɩ́, tɛ́ yo pé tyɩ́ nɛ, pǎh Tɛ̃̀ ǹgbɛ̃ lékó wilki diki sɔkɔ. Tɛ́ pépi náh pɩ̃ pǎh à sah ńyãh sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Képah sɔkɔ, Pyɛrɩ ànɛ̂ ǹ ní-ò Yesu tõ̀ sã́h-ò mɛ̀ mɛ yuku à diki yõ nyáh sõ. ");
INSERT INTO wib_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Pé nímí sõ̀ mɛ n to. Tɛ́ ǹmɔ-á sõ̀ mɛ n to súú kal Pyɛrɩlɛ, ǹmɔ kyɩ yĩni tɛ̃ gbennɛ diki yõ. ");
INSERT INTO wib_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Wǎh kɔ yah diki sɔkɔ, à fwɔ gbró wɛ sàhnɔ́lɛ ké sɔkɔ, tɛ́ à náh de. ");
INSERT INTO wib_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ǹtɛ Simo-Pyɛrɩ nɛ̂ wɔ-á sõ̀ mɛ n pi ǹ náhlɛ, ǹmɔ wɔ-á pɔ yĩni tɛ̃, à de diki sɔkɔ. Tɛ́ kyɩ fwɔ gbró wɛ sàhnɔ́lɛ, ");
INSERT INTO wib_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ànɛ̂ fwɔ yɔ́lɛ fíkénsàhnɔ́lɛ ké tyɩ́lɛ, pǎh sõ̀ nɛ̂ mɔ ǹ yõ yõ. Képah náh sõ̀ mɛ fwɔ gbró tɛ́lɔ́lɛ fɩ̃́ núkú. ");
INSERT INTO wib_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Képah sɔkɔ, Yesu tõ̀ sã́h-ò nɛ̂-á sõ̀ pɔ de diki yõ gbennɛ, ǹ tɔ mɛ de diki sɔkɔ. Wǎh kè wɛ, à sɛ̃ ké yõ. ");
INSERT INTO wib_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Tɛ́ à pɔ nɔ légbĩ́ tyɩ́, wɛy nɛ̂-á wãrkɩ sah Liyel wɛy sɔkɔ nɛ, Yesu lékó-á yɩ̃nɛ à pɔ n yilki mɔ, ǹ tõ̀ sã́hpú náh tɔ̃̌nɩ̀ sõ̀ mɛ képah dùkù pɩ̃. ");
INSERT INTO wib_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Képah náh, Yesu tõ̀ sã́hpú nɛ́pĩ̂ nímí nɔ́pi pé syɩ to yuku pé tĩ̀nnɛ. ");
INSERT INTO wib_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Légbĩ́nɛ, Mari sõ̀ mɛ yĩ́nntɛ̃̀nɔ́lɛ kégbɔ́ sɔkɔ diki tnɔ̂ mɛ n gbo. Wǎh mɛ gbní sɔkɔ gbĩ́ nɛ̂nɛ tɛ́ kɔ yah diki sɔkɔ, ");
INSERT INTO wib_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","à yĩ̂nyõ tõ̀npɩbɩ nɛ́pĩ̂ nímí wɛ fwɔ̀pikinɔ sɔkɔ diki sɔkɔ. Pè sõ̀ mɛ kɔ̃́ntɛ̃̀nɔ́lɛ Yesu lékó snɛ́kɩ́nmɔ-ńsah sɔkɔ. Núkú sõ̀ mɛ tɛ̃ ǹ yõ mɔ́-ńsah tĩ̀nnɛ, tɛ́ ní-ò mɛ tɛ̃ ǹ gbyẽ̂h mɔ́-ńsah tĩ̀nnɛ. ");
INSERT INTO wib_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Pè mɛ nɛ, pi, kwâh nɛ̂ se pɩ tɛ́ à n gbo nɩ? À mɛ nɛ pǎh pé Tɛ̃̀ ǹgbɛ̃ lékó wilki. Ǹtɛ́ pé náh pɩ̃ pǎh à sah ńyãh sɔkɔ, képah-á pé kɔ̃ pé n gbo. ");
INSERT INTO wib_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Wǎh mɛ képah yónɔ́ sɔkɔ tɛ́ ǹ yah vi, à Yesu wɛ yĩ́nnɔ́lɛ nɛ́npɔ́. Ǹtɛ à náh sõ̀ mɛ pɩ̃ nɛ ǹmɔ-á. ");
INSERT INTO wib_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesu mɛ à piki yah nɛ, pi, kwâh nɛ̂ se pɩ tɛ́ à n gbo nɩ? Nɛ̂ se à n yah n kɔ̃ nɩ? Ǹtɛ Mari wɔ sõ̀ mɛ n sõ nɛ sètɛ̃̀ dĩ́-á, tɛ́ yo ǹ tyɩ́ nɛ, pé yõ̀tɛ̃̀, ǹmɔ-à kɩ nɛ̂ wilki ǹnɛ, à ǹ sàh-ǹsahlɛ pé wɛ̃kɩ pé kyɩ à tɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Képah tɛ̃̀nɛ, Yesu mɛ à ye nɛ, Mari! Mari mɛ ǹ yah vi ǹ tĩ̀nnɛ tɛ́ yo ǹ tyɩ́ Yebre wɛy sɔkɔ nɛ, Wrabuni, nɛ̂ kɔ́r-á kwɔ́-ò dĩ́nɛ. ");
INSERT INTO wib_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ǹtɛ Yesu mɛ yo ǹ tyɩ́ nɛ: «Mé náh tɔ̃̌nɩ̀ mɛ dɔkɔ yuku Sú Liyel tnɔ̂, képah ye, káh ń tɛ̃ n sah. Tɛ́ kyɩ n yo ńmɔ yṹnpyé tyɩ́ nɛ, máh kɩ dɔkɔ yuku ń Sú tyɩ́, nɛ̂-á yépi tɔ Súlɛ. Ǹmɔ nɛ̂-á ń Liyellɛ ànɛ̂ yépi tɔ Liyellɛ, máh kɩ dɔkɔ yuku ǹ tyɩ́.» ");
INSERT INTO wib_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Képah sɔkɔ, Makadala kwil Mari mɛ kyɩ kè yo Yesu tõ̀ sã́hpú tyɩ́ nɛ, páh Tɛ̃̀ ǹgbɛ̃ wɛ. Tɛ́ wǎh tyi nónó yo ǹ tyɩ́, à mɛ sè yãh pè tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Kénɛ dimansyi mɛ̀ ó sõ ńvɩ̃́nɛ, Yesu tõ̀ sã́hpú sõ̀ mɛ tùkènmɔntɛ̃̀nɔ́lɛ wɔ̀kɔ̀ yɔ́ sɔkɔ. Tɛ́ Nsyifunɔ yõ̀tãm yah tíkí tɛ̃̀ tyɩ́, pè sõ̀ mɛ ké vɩ̀ yey tɛ̃ n mɔ sah. Ǹtɛ dǒ, Yesu núkú pɔ n yĩn pé nɩyṍ, tɛ́ yo pé tyɩ́ nɛ: «Yé nɛ n mɛ yèvɩnɩ sɔkɔ.» ");
INSERT INTO wib_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Képah yóntɛnɔ náh, à ǹ gbã̀n táhlɔ́ ànɛ̂ ǹ gbɔ̀pɔlɛ pè wɛ̃kɩ. Pǎh Tɛ̃̀ ǹgbɛ̃ wɛ sɛ̃́, kè pɩ yĩ́ĩ́ nɩ̀vɩ̀nɩ̀nɛ pé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","À mɛ tɔ̃ yo pé tyɩ́ nɛ: «Yé nɛ n mɛ yèvɩnɩ sɔkɔ. Sú Liyel-á ńmɔ tõ sɔ̃́, sɛ̃́ ye ńmɔ tɔ yélɛ n tõ.» ");
INSERT INTO wib_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Kénɛ wɛlɔ yóntɛnɔ náh, à fɩ̃bɩ mɔ pé yõ tɛ́ nɛ: «Liyel Mirki ye mé yélɛ n kɔ̃. ");
INSERT INTO wib_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Yâh nónó tyípêl yɔ̃ mɔ pè kɔ̃, sè kɩ yɔ̃ mɔ pé tyɩ́. Tɛ́ yâh nónó tyɩ́ yɔ̃̀nmɔ-ńkɛ̃̂nɛ, sè náh n yɔ̃ n mɔ n pi pé tyɩ́.» ");
INSERT INTO wib_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ǹtɛ Yesu-á pɔ ǹ tõ̀ sã́hpú tnɔ̂ sõ nɛ̂nɛ, Toma nɛ̂-á pè yĩn dyɩ à kɔ̃ kènìnìnɛ, ǹmɔ wɔ náh sõ̀ mɛ. Yesu tõ̀ sã́hpú nɛ́pĩ̂ gbɔ̃nimí sɔkɔ yɔ́ ye sõ̀ ǹ tɔlɛ. ");
INSERT INTO wib_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Kǎh pɩ sɛ̃́, pé no tɛ́lɔ́ mɛ pɔ kè yo ǹ tyɩ́ nɛ, pépi-á Tɛ̃̀ ǹgbɛ̃ Yesu wɛ. Ǹtɛ à mɛ pè syah nɛ ńkɛ̃́, nɛ́ péwɔ tɛ̃̀ náh kwèrkè nɩ́y wɛ ǹ gbã̀n táhlɔ́ sɔkɔ, tɛ́ pé kèngbɔ dyɩ yah sé sɔkɔ, ànɛ̂ nɛ́ pé náh pé gbõ̀ dyɩ yah ǹ gbɔ̀pɔ tũ̀-ǹsah sɔkɔ, pé náh n sɛ̃ n yah n pi ké yõ póllɛ. ");
INSERT INTO wib_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Képah náh, ké dimansyi kèyâhlɛ ńtɔ̃, Yesu tõ̀ sã́hpú sõ̀ mɛ wɛ̃ tuke mɔ tɛ̃ wɔ̀kɔ̀ sɔkɔ, tɛ́ mɛ ké vɩ̀ yey pól tɛ̃ mɔ. Képah wɔ sɔkɔ, Toma tɔ sõ̀ mɛ pélɛ. Dǒ, Yesu núkú pɔ n yĩn pé nɩyṍ, tɛ́ yo pé tyɩ́ nɛ: «Yé nɛ n mɛ yèvɩnɩ sɔkɔ.» ");
INSERT INTO wib_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Képah yóntɛnɔ náh, à yo Toma tyɩ́ nɛ: «Á kèngbɔlɛ pɔ ásõ̂ sɔkɔ yɔ̀, ǹ tɛ́ n yah ń gbã̀n táhlɔ́lɛ. Á gbõ̀ nɔ n dyɩ ń gbɔ̀pɔ sɔkɔ. Yal n mɔ tɔ̀tɔ̀ pɩ́nɔ́lɛ, ǹ tɛ́ n sɛ̃ ké yõ.» ");
INSERT INTO wib_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Képah tɛ̃̀nɛ, Toma nɛ ńkɛ̃́, ǹmɔ-á pé Tɛ̃̀ ǹgbɛ̃ ànɛ̂ pé Liyel tɔlɛ. ");
INSERT INTO wib_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Képah sɔkɔ, Yesu mɛ à syah nɛ: «Wáh ń wɛ, képah ye á sɛ̃ ń yõ kɛ̀. Ǹtɛ nónó-à sɛ̃ ńmɔ yõ ń wɛ́nyah-ńkɛ̃̂nɛ, pè kɩ mɛ nɩ̀vɩ̀nɩ̀ sɔkɔ.» ");
INSERT INTO wib_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","À wil képah sɔkɔ, Yesu tɔ̃ gbǐl tyi náhnáh pɩ ǹ tõ̀ sã́hpú yĩ́ yah, nónó-á sè náh wãrkɩ sɛ́bɛ́y mɛ̀ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ǹtɛ nónó-á wãrkɩ ké sɔkɔ, sè ye wãrkɩ nɛ sépi gbõ̀ yõ, yé sɛ̃ ké yõ nɛ Yesu-á Liyel Pídĩ́nɛ, ànɛ̂ Liyel nɛy yáhntɔkɔnɔlɛ. Tɛ́ yáh kɩ sɛ̃ ǹmɔ yõ, yé mó tyɛ́-ńkɛ̃̂ min wɛ. ");
INSERT INTO wib_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Képah náh, sõ yɔ́lɛ, Yesu tɔ̃ ǹ gblɔ̌ynɛ ǹ tõ̀ sã́hpú wɛ̃kɩ Tiberiyadɩ yɔ́-ǹgbɛ̃ gbɔ̀pɔ. Kǎh pɩ dùkù nɛ̂nɛ, kè wɛ yɔ̀: ");
INSERT INTO wib_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simo-Pyɛrɩ sõ̀ mɛ wɛ̃ tyɩ́ ànɛ̂ Toma nɛ̂-à pè yĩn dyɩ à kɔ̃ kènìnìnɛ, ànɛ̂ Natanayɛlɩ nɛ̂-á n wil Kana kwil sɔkɔ, Kalile gbɛ̃̀nyah, ànɛ̂ Nsebede dĩ́npìlɛ, à tahlɩ pé no Yesu tõ̀ sã́hpú nɛ́pĩ̂ nímí yísyɔ́ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Képah tɛ̃̀nɛ, Simo-Pyɛrɩ mɛ yo pé tyɩ́ nɛ péwɔ-á n sɔkɔ yɛ̃́nkyɔ tɛ̃́-ńsah. Pé no tɛ́lɔ́ mɛ nɛ, pépi tɔ-á kɩ sɔkɔ ǹnɛ. Pè mɛ wil sɔkɔ à kyɩ de krótókè sɔkɔ, tɛ́ pè náh kwâh yɔ́ wɛ tɛ̃ lésõ lékã̂hnɛ. ");
INSERT INTO wib_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Tyah syɩkɩ gbĩ́nɛ, Yesu sõ̀ mɛ yĩ́nnɔ́lɛ yɔ vyãh yah, tɛ́ ǹ tõ̀ sã́hpú náh sõ̀ mɛ pɩ̃ nɛ ǹmɔ-á. ");
INSERT INTO wib_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","À mɛ yo mɔ pé tyɩ́ nɛ, pé kódíbí, pè kó yɛ̃́nkyɔ yísyɔ́ wɛ tɛ̃ nɩ? Pè mɛ nɛ, ɔ̃́ɔ̃-á. ");
INSERT INTO wib_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","À mɛ nɛ, pè pé yɛ̃́nkyɔ tɛ̃ tɛ̃ mnɔ min n dah n mɔ krótókè gbõ̀yõ̀ sõ̀lɛ, pǎh kɩ wɛ tɛ̃. Pè mɛ sè min dah mɔ, tɛ́ yɛ̃́nkyɔ wɛ tɛ̃ tnɔ́nɔ́lɛ, fɔ́ɔ́ pè tɛ̃ sè yɔrɩ wilki kwlɔ. ");
INSERT INTO wib_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Képah sɔkɔ, Yesu tõ̀ sã́h-ò nɛ̂ tyɩ́-á nɔ yĩ́ĩ́ ǹ tyɩ́, ǹmɔ mɛ yo Pyɛrɩ tyɩ́ nɛ, Tɛ̃̀ ǹgbɛ̃-á. Tɛ́ Pyɛrɩ sõ̀ mɛ ǹ fwɔ̀mɔnɩ dɛ sah. Wǎh noh nɛ Tɛ̃̀ ǹgbɛ̃-á ńyãh sɔkɔ, à kè tɔkɔ mɔ tɛ́ yɔkɔ de yɔ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Tõ̀ sã́hpú tɛ́lɔ́ wɔ mó n pi krótókè sɔkɔ, tɛ́ mɛ pé yɛ̃́nkyɔ tɛ̃ tɛ̃ mnɔlɛ n yɔrɩ n pi, yɛ̃́nkyɔlɛ sé yĩ́ĩ́nɛ. Pè náh sõ̀ mɛ gbɛ mɔ kah yɔ vyãhlɛ. Kè sõ̀ mɛ mɛ́tɛ́rnɔ́ lèkwɛ̌ kénkɔ̃lɛ. ");
INSERT INTO wib_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Pǎh pɔ yĩni tɛ̃ kènkwã̀h yõ sɔkɔ, pè nyàhségbnɔ yísyɔ́ wɛ yɛ̃́nkyɔlɛ sé yõ, tɛ́ búrn tɔ mɛ. ");
INSERT INTO wib_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Képah sɔkɔ, Yesu mɛ yo pé tyɩ́ nɛ, yɛ̃́nkyɔ nónó-á pè wɛ tɛ̃ yɔ̀, pè pɔ sé yísyɔ́lɛ. ");
INSERT INTO wib_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Wǎh yo sɛ̃́, Simo-Pyɛrɩ mɛ yɛ̃́nkyɔ tɛ̃ tɛ̃ mnɔ nɔ́pi yɔrɩ wilki kènkwã̀h yõ. Sè sõ̀ mɛ yúkúnɔ́lɛ yɛ̃́nkyɔ ǹgbã̀l plɔ́ lèkwɛ̌ tikininí pɔ́ gbãm pɔ́ tɔ̃́nɔ́lɛ (153). Ǹtɛ yɛ̃́nkyɔ́pèl nɔ́pi wɛ́ntɛ̃nɔ fyé yõ, pé yɛ̃́nkyɔ tɛ̃ tɛ̃ mnɔ náh kɔ̃lɩ. ");
INSERT INTO wib_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Képah sɔkɔ, Yesu mɛ yo pé tyɩ́ nɛ, pè pɔ yõke yõ. Tɛ́ ǹ tõ̀ sã́hpú-á sõ̀ pɩ̃ nɛ Tɛ̃̀ ǹgbɛ̃-á sɛ̃́, képah ye ǹ píkínyahnɔ tah pé tyɩ́ nɛ, nɛ̂ se ǹnɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","À mɛ nɔ de pélɛ, tɛ́ búrn tɔkɔ à dibi pé tyɩ́, tɛ́ yɛ̃́nkyɔ tɔ dibi pé tyɩ́ sɛ̃́ntɛ̃̀ ólɛ. ");
INSERT INTO wib_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yesu lékó yílkínmɔntɛnɔ náh, ké kɛ tɔ̃́-ò ye à ǹ gblɔ̌ynɛ ǹ tõ̀ sã́hpú wɛ̃kɩ yɔ̀. ");
INSERT INTO wib_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Yõke yṍntɛnɔ náh, Yesu mɛ Simo-Pyɛrɩ piki yah nɛ ńkɛ̃́: «Nsyɔ̃ pídĩ́ Simo, ń tyɩ́-á nɔ no nɔ́pi tyɩ́ sɔ̃́, ń tyɩ́ se mɛ nɔ áwɔ tyɩ́ à kal pépilɛ?» À mɛ yo ǹ tyɩ́ nɛ, àwe Tɛ̃̀ ǹgbɛ̃, ǹmɔ ńtɛ̃-á pɩ̃ nɛ ǹ tyɩ́-á nɔ pé tyɩ́. Yesu mɛ yo ǹ tyɩ́ nɛ: «Ń képɔ́pî tɛ̃́nɔ́ plɛ.» ");
INSERT INTO wib_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Tɛ́ tɔ̃ à piki yah kɛ ní-òlɛ nɛ ńkɛ̃́: «Nsyɔ̃ pídĩ́ Simo, ń tyɩ́ se mɛ nɔ á tyɩ́?» À mɛ yo ǹ tyɩ́ nɛ, àwe Tɛ̃̀ ǹgbɛ̃, ǹmɔ ńtɛ̃-á pɩ̃ nɛ ǹ tyɩ́-á nɔ pé tyɩ́. Yesu mɛ yo ǹ tyɩ́ nɛ: «Pɩ ń képyɛ́nɩ̀ fɛ̃̀-òlɛ.» ");
INSERT INTO wib_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Képah náh, Yesu tɔ̃ ǹ syɩ à piki yah kɛ tɔ̃́-òlɛ nɛ ńkɛ̃́: «Nsyɔ̃ pídĩ́ Simo, ń tyɩ́ se mɛ nɔ á tyɩ́?» Képah sɔkɔ, kè Pyɛrɩ yah kwɔ, Yesu-á sɔ̃́npɩ́lɛ à piki yah kɛ tɔ̃́nɔ́ póllɛ nɛ, pé tyɩ́ se mɛ nɔ ǹ tyɩ́ nɩ? Képah tɛ̃̀nɛ, à mɛ yo Yesu tyɩ́ nɛ, Tɛ̃̀ ǹgbɛ̃, ǹmɔ-á tyi póllɛ n pnɛ. Wǎh kè pɩ̃ yĩ́ĩ́ nɛ, ǹ tyɩ́-á mɛ nɔ pé tyɩ́. Yesu mɛ yo ǹ tyɩ́ nɛ: «Ń képyɛ́nɩ̀ tɛ̃́nɔ́ plɛ. ");
INSERT INTO wib_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Kègbɩgbɩ tɛ̃̀ yõ, mé kélɛ n yo á tyɩ́, áwɔ kètɛ̃̀npìkì gbĩ́nɛ sõ̀, ńyãh-à á dyɔ, ň á kɔ̃ toh á fwɔ̀mɔ̀-ǹgbɛ̃ yõ ǹ sɔkɔ nɛ́npɔ́. Ǹtɛ wâh pɔ dye, á kɩ á gbã̀n yɔ̃ ǹnɩ̂ yɔ́ kɔ̃ à kɩ á kɔ̃ toh ǹ kɔ̃, tɛ́ kɩ sɔkɔ álɛ fɩ̃́ yɔ́ sɔkɔ, ńyãh tyɩ́ náh mɛ á tyɩ́.» ");
INSERT INTO wib_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Tɛ́ Pyɛrɩ-á nɛ n ku n pi dùkù nɛ̂nɛ, tɛ́ kè kɩ Liyel yĩn gbilki n pi, képah tyɩ́ ye Yesu n yo sɛ̃́ yɔ̀. Képah yóntɛnɔ náh, à tɔ̃ yo Pyɛrɩ tyɩ́ nɛ: «Ń sõ̀ tɛ̃.» ");
INSERT INTO wib_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Képah sɔkɔ, Pyɛrɩ-á ǹ yah vi, Yesu tõ̀ sã́h-ò nɛ̂ tyɩ́-á nɔ yĩ́ĩ́ Yesu tyɩ́, à à wɛ pé náhlɛ. Ǹmɔ ye lésõ ǹ gbalɩ kɛ̃kɩ Yesu tĩ̀nnɛ, tɛ́ à piki yah nɛ, Tɛ̃̀ ǹgbɛ̃, nɛ̂ tɛ̃̀ ó se kɩ n vi n pi ǹ náh nɩ? ");
INSERT INTO wib_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pyɛrɩ-á à wɛ, à Yesu piki yah ǹ tyɩ́ sɔkɔ nɛ ńkɛ̃́, tɛ́ ǹmɔ-á dò, Tɛ̃̀ ǹgbɛ̃, tir nɛ̂ se kɩ ǹmɔ nɔ n pi nɩ? ");
INSERT INTO wib_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","À mɛ yo ǹ tyɩ́ nɛ, páh kɩ mɛ ké tyɩ́ nɛ ǹmɔ tɛ̃ min sɔkɔ, fɔ́ɔ́ kè pɔ n nɔ pé syɩ́npɔnɔ tyɩ́, ǹ vyãh nɛ̂ se mɛ ké sɔkɔ nɩ? Ǹmɔ tɛ̃̀ wɔ pé sõ̀ tɛ̃ sɔ̃́! ");
INSERT INTO wib_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Képah tɛ̃̀nɛ, kè wil wùù Yesu yõ sɛ̃́pú tyɩ́ nɛ, Yesu tõ̀ sã́h-ò mɛ̀ náh n ku n pi. Ǹtɛ Yesu náh se mó tɔ̃ sõ̀ ǹ kú-ńkɛ̃̂ tyɩ́ yo Pyɛrɩ tyɩ́. À sõ̀ nɛ ńkɛ̃́, páh kɩ mɛ ké tyɩ́ nɛ ǹmɔ tɛ̃ min sɔkɔ, fɔ́ɔ́ kè pɔ nɔ pé syɩ́npɔnɔ tyɩ́, ǹ vyãh nɛ̂ se mɛ ké sɔkɔ nɩ? ");
INSERT INTO wib_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Yesu tõ̀ sã́h-ò mɛ̀ ye n yo tyi nɔ́pilɛ, tɛ́ sè wãrkɩ. Tɛ́ ápi pɩ̃ nɛ gblɔ-á ǹ tyíyónɔlɛ. ");
INSERT INTO wib_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Tyi náhnáh túkù mɛ Yesu pɩ ńtɔ̃. Ǹtɛ sé pól-à sõ̀ mɛ n wãrkɩ núkú núkúlɛ, ńmɔ sõnɔ sɔkɔ, sé sɛ́bɛ́ynɔ́ sàh-ǹsah náh náhkɩ n wɛ n pi kèkõyṍ sɔkɔ.");
INSERT INTO wib_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ń dĩ́ Tewofil, máh lésõ sɛ́bɛ́y gben nɛ̂ tɛkɩ mɔ á tyɩ́, képah sɔkɔ ye mé wãrkɩ Yesu tyípɩ́nɩ̀ ànɛ̂ ǹ névye kwɔ́nɔ́nɔ póllɛ. Mé sè wãrkɩ à tɔkɔ ǹ tõ̀ tyàhnɔ́ tyɩ́, ");
INSERT INTO wib_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","pópó à pɔ nɔ sõ nɛ̂-á Liyel à yɔ̃ dɔkɔ sɔkɔ yĩ̂nyõ. Tɛ́ Yesu-á pópó n yɔ̃ n dɔkɔ n sɔkɔ, à tã̀n kwãh sah ǹ tɛ̃ntõ̀ syínyopu kɔ̃ Liyel Mirki gbõ̀ yõ, pépi nónó-á lésõ à yah wilki sah. ");
INSERT INTO wib_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Yesu-á yèvyãhrɩ pɩ à ku, képah náh tɛ̃ntõ̀ névye nɔ́pi tyɩ́ ye à ǹ gblɔ̌y wɛ̃kɩ duke duke náhnáhlɛ nɛ, páh mɛ vilɛ. Sèpĩ̀n tikininí sɔkɔ ye sõ̀ à ǹ gblɔ̌ynɛ pélɛ n wɛ̃kɩ, tɛ́ pélɛ n kwɔ Liyel tɔ̃́rɩ́ tyɩ́ yõ. ");
INSERT INTO wib_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","5","Képah sɔkɔ, sṍ yɔ́lɛ pè mɛ yõke yṍnɔ́ sɔkɔ, tɛ́ Yesu gbáhdyâh yɔ́ di pé tyɩ́ nɛ: «Yé káh n gbɛ n mɔ Yerusalɛmɩ kwillɛ. Ǹgbòlɛ, Nsyɔ̃ lésõ névye wel wilki ni sɔkɔ, ǹtɛ núkúnúkú, kàh pópó n nɔ sèpĩ̀n yísyɔ́ tyɩ́, Liyel kɩ yé tɔ̃ sah ǹ Mirkilɛ kɩ yé pɩ yályál. Képah ye, yé káh gbɛ mɔ Yerusalɛmɩnɛ. Yé Liyel Mirki syɩkɩ n tɛ̃ nɛ́npɔ́, képah nɛ̂-á Sú Liyel vyãh kɔ̃́nɔ́lɛ, nɛ̂ tyɩ́-á mé yo sah yé tyɩ́.» ");
INSERT INTO wib_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Tɛ́ Yesu tɛ̃ntõ̀ névye-á sõ̀ mɛ tùkènmɔnɔlɛ ǹ tnɔ̂, pè píkínyahnɔ yɔ́ pɩ ǹ tyɩ́ nɛ, pé Tɛ̃̀ ǹgbɛ̃, núkúnúkú se à kɩ tɔ̃́rɩ́ tɔ̃ dahbɩ Yisrayel gbɛ̃̀nyah tãn gbõ̀ sɔkɔ nɩ? ");
INSERT INTO wib_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","À mɛ yo pé tyɩ́ nɛ: «Yépi tyɩ́ náh ké lésõ ànɛ̂ ké gbĩ́ pɩ̃́nɔ́lɛ. Sú Liyel nɛ̂ ó-á tɔ̃́rɩ́ nɛ́tɛ̃̂nɛ, ǹmɔ ye wilki sah légbĩ́nɛ. ");
INSERT INTO wib_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ǹtɛ yé kɩ pɔ tɛ̃́nwɛnɔ yɔ́ wɛ, Liyel Mirki-à pɔ tiki yé yõ gbĩ́ nɛ̂nɛ. Képah sɔkɔ, yé kɩ pɩ ńmɔ tyɩ́ yónwàhpu kègblɔlɛ à tɔkɔ Yerusalɛmɩ kwil, ànɛ̂ Nsyude gbɛ̃̀nyah pól sɔkɔ, à tahlɩ Samari gbɛ̃̀nyah tyɩ́, fɔ́ɔ́ à kɩ kyɩ syɩ kèkõyṍ pól yĩ̀n tyɩ́.» ");
INSERT INTO wib_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Yesu-á fyɔ̀ kénɛ wɛlɔ yo tɛ, à núkú yɔ̃ dɔkɔ n sɔkɔ yĩ̂nyõ pé pól yĩ́ yah. Tɛ́ ńyĩ́rkì yɔ́ pɔ à fɔkɔ tũ, pè náh tɔ̃ à wɛ. ");
INSERT INTO wib_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Tɛ́ pǎh mɛ kénɛ yĩ̂nyõ yáhnɔ́ sɔkɔ díkídíkí sɛ̃́, pè núkú díbí nɛ́pĩ̂ nímí yísyɔ́ wɛ pé tnɔ̂ fwɔ̀pikinɔ sɔkɔ, ");
INSERT INTO wib_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","pè mɛ n yo pé tyɩ́ nɛ ńkɛ̃́: «Kalile gbɛ̃̀nyah tãn, kwâh nɛ̂ mɛ, tɛ́ yé yĩn tɛ̃ ásõ̂, à yĩ̂nyõlɛ n yah sɛ̃́? Sɔ̃́-á yé wɛ Yesu mɛ̀nɛ, à yɔ̃ dɔkɔ sɔkɔ yĩ̂nyõ yɔ̀, sɛ̃́ntɛ̃̀ ó ye à kɩ tɔ̃ ǹ syɩ n pɔ n pi.» ");
INSERT INTO wib_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Képah náh, Yesu tɛ̃ntõ̀ névye yal Wolivi yèh yɔ̃lɩ yõ, à pé syɩ n pi Yerusalɛmɩ sɔkɔ. Kénɛ yɔ̃lɩ náh sõ̀ mɛ fɩ́ɩ́ kah Yerusalɛmɩnɛ, kè mɛ lɛ́rɩ́ tɔ́nɩ́ kénkɔ̃ kɔ́-ńsahlɛ. ");
INSERT INTO wib_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Pǎh pɔ de, pè dɔkɔ yuku yĩ̂nyõ wɔ̀kɔ̀ sɔkɔ, pǎh ńkɛ̃́nɛ wɛ̃nɛ n tuke n mɔ ńyãh sɔkɔ. Pyɛrɩ sõ̀ mɛ, ànɛ̂ Nsyɔ̃nɛ, ànɛ̂ Nsyakɩlɛ, ànɛ̂ Andrelɛ, à tahlɩ Filipi tyɩ́, ànɛ̂ Tomalɛ, ànɛ̂ Barteleminɛ, ànɛ̂ Matyelɛ, ànɛ̂ Alfe pídĩ́ Nsyakɩlɛ, ànɛ̂ Simolɛ nɛ̂-á sõ̀ pè n ye sú fṍ vyãh syí-òlɛ, ànɛ̂ Nsyakɩ pídĩ́ Nsyudelɛ. ");
INSERT INTO wib_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Pé pól sõ̀ mɛ pé sõnɔ pɩ núkúlɛ, à n tuke n mɔ wɛ̃ tyɩ́ gbĩ́mɛgbĩ́, à nírílɛ n pɩ. Syɔ́ yísyɔ́ tɔ sõ̀ mɛ pélɛ, à tahlɩ Yesu yṹ Mari tyɩ́, ànɛ̂ Yesu yṹnpyélɛ. ");
INSERT INTO wib_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Kénɛ sèpĩ̀n sɔkɔ, sõ yɔ́lɛ, Yesu yõ sɛ̃́pú sõ̀ mɛ tuke mɔ nɛ́pĩ̂ tikinúkò (120) kénkɔ̃lɛ. Tɛ́ Pyɛrɩ mɛ yuku yĩn pé nɩyṍ, tɛ́ yo pé tyɩ́ nɛ, ");
INSERT INTO wib_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","pé yṹnpyé, Liyel wɛy sɔkɔ Liyel Mirki-á lésõ Davidi kɔ̃, à nɛ̂ yo sah Nsyudasɩ tyɩ́ sɔkɔ, kǎh sõ̀ yɩ̃nɛ kè pɩ ó pɩ. Kénɛ Nsyudasɩ-á lésõ Yesulɛ ǹ tɛ̃́pú wɛ̃kɩ. ");
INSERT INTO wib_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Tɛ́ pépi tĩ̀nkì sɔkɔ nɛy yɔ́-á mó tɔ̃ sõ̀ ǹnɛ, tõ̀lɛ dáhbɩ́nɔ́lɛ ǹ gbõ̀ pépi tyɩ́ kɔ̃lɛ. ");
INSERT INTO wib_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Ǹtɛ wǎh pɔ́ nɛ̂ wɛ ǹ tyítúkù pɩ́nɔ́ yõrelɛ, képah-á dwe swãhlɛ. Tɛ́ à mɛ pɔ syɩkɩ ǹ fɔkɔ sɔ, ǹ dyɔ pól wil karkɩ. ");
INSERT INTO wib_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Képah sɔkɔ, Yerusalɛmɩ tãn pól mɛ kè noh, pè kɔ̃ pè kénɛ swãhlɛ n ye pé wɛy sɔkɔ Akeldamalɛ, nɛ̂ kɔ́r-á tṍ swãhlɛ. ");
INSERT INTO wib_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Képah tyɩ́-á sõ̀ wã́rkɩ́nsàhnɔ́lɛ Gbálnɔ́ sɛ́bɛ́y sɔkɔ nɛ ńkɛ̃́: «Ǹ kéte kɩ pɩ kéntíkínìnɛ, ànɛ̂ nɛy náh tɔ̃ n tɛ̃ n pi ké sɔkɔ.» Tɛ́ tɔ̃ yo ké fɩ̃́ yɔ́ sɔkɔ nɛ ńkɛ̃́: «Ǹnɩ̂ kɩ ǹ pɩ pɩ tõ̀ tɔkɔ n pɩ.» ");
INSERT INTO wib_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Képah-á, névye nónó-á sõ̀ mɛ pélɛ Yesu mɛ gbĩ́ dùkùlɛ, ");
INSERT INTO wib_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","à tɔkɔ Nsyɔ̃-á à wel wilki ni sɔkɔ gbĩ́ nɛ̂nɛ, fɔ́ɔ́ à kyɩ syɩ ǹ yɔ̃ n dɔkɔ n sɔkɔ sõ tyɩ́ yĩ̂nyõ. Pépi sɔkɔ nɛ́núkù yɔ́-á yɩ̃nɛ à tahlɩ pé tyɩ́, pé ǹ tyɩ́lɛ n yo n wah nɛ, wǎh ku tɛ́ yilki mɔ. ");
INSERT INTO wib_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Wǎh yo sɛ̃́, pè mɛ nɛ́pĩ̂ nímí wɛ̃kɩ. Núkú yĩn ye Nsyosɛfulɛ, nɛ̂-á pè n ye Barsabasɩlɛ, tɛ́ tɔ̃ ǹnɛ n ye Nsyusitusilɛ. Ní-ò yĩn mɛ Matyasɩlɛ. ");
INSERT INTO wib_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Képah sɔkɔ, pè mɛ Liyel ni nɛ, Tɛ̃̀ ǹgbɛ̃ Liyel, ǹmɔ nɛ̂-á no pól fɔ́kɔ́sõnɔlɛ n pnɛ, wǎh nɛ̂ yah wilki nɛ́pĩ̂ nímí nɔ́pi sɔkɔ, à tɛ̃̀nɛ pé wɛ̃kɩ. ");
INSERT INTO wib_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Tɛ̃̀ wɔ-á kɩ Nsyudasɩ swɔ tɔkɔ Yesu tɛ̃ntõ̀ névye tõ̀ mɛ̀ sɔkɔ, wǎh nɛ̂ milki tɛ́ yuku fɩ̃́ yɔ́, ńyãh-á yɩ̃nɛ ǹnɛ. ");
INSERT INTO wib_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Képah tɛ̃̀nɛ, pè sã́hntɔkɔnɔ pɩ, kénɛ sã́hntɔkɔnɔ mɛ pɔ yɩ̃nɛ Matyasɩlɛ. Ǹmɔ núkú kwrɔ mɔ Yesu tɛ̃ntõ̀ névye nɛ́pĩ̂ gbɔ̃núkú sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Syáh sõ-á pɔ nɔ, nɛ̂-á pè n ye Pãntekɔtɩ syáhlɛ, Yesu yõ sɛ̃́pú pól sõ̀ mɛ tùkènmɔnɔlɛ fɩ̃́ núkú sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Dǒ, yĩ́npɔ̃́ yɔ́ núkú n wil líyel sɔkɔ á kɩ nɛ yã́hpékè yɔ́ sɔ̃́ kõ, à pé mɛ́-ńsah wɔ̀kɔ̀ pól yuku. ");
INSERT INTO wib_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Tɛ́ kwâh yɔ́ núkú wil mɔ á kɩ nɛ nyàh lépɔ̃́ sɔ̃́, tɛ́ kɔ̃lɩ tɛ̃ tɛ̃ kɔ̃ pé nɛ́núkù núkú pól yõ. ");
INSERT INTO wib_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Liyel Mirki mɛ pé pól tɔkɔ. Pè tyah wɛ́nsnɔ́lɛ n wɛkɩ Liyel Mirki-á nónó dahbɩ pé vyɛ̃y. ");
INSERT INTO wib_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Tɛ́ légbĩ́nɛ, Nsyifunɔ nónó-á pé Liyel wɛ̃̀kɩ̀ tɛ̃́nɔ́ plɛ, pè sõ̀ mɛ wil kèkõyṍ kwlo kwlo pól sɔkɔ, à pɔ twah Yerusalɛmɩ kwil. ");
INSERT INTO wib_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Yĩ́npɔ̃́ mɛ̀-á wil sɛ̃́, pé pól tuke mɔ tɔ́wûlɛ. Tɛ́ pé pól yáh-ńsah sõ̀ mɛ tyɛ, pé nɛ́núkù núkú pól-á sɔ̃́npɩ́lɛ pé kwlo wɛlɔ wɛ́kɩ́nɔ́lɛ n nohnɩ Yesu yõ sɛ̃́pú tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Kǎh pɩ sɛ̃́, pé gbã̀n du, pé lékã́m fɛ̃kɩ, pè mɛ tyah n yo wɛ̃ tyɩ́ nɛ: «Nónó pól-á n wɛkɩ yɔ̀, pé póllɛ Kalile gbɛ̃̀nyah tãn náh di? ");
INSERT INTO wib_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ǹtɛ kè pɩ sɔ̃́ tɛ́ ápi nɛ́núkù núkú pól á kwlo wɛlɔ wɛ́kɩ́nɔ́lɛ n nohnɩ pé tyɩ́, ");
INSERT INTO wib_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","ápi nónó-á n wil gbɛ̃̀nyah nɔ́pi sɔkɔ, nónó-á pɩ: Partɛselɛ, ànɛ̂ Medilɛ, ànɛ̂ Yelamnɛ, ànɛ̂ Mesopotami tɔlɛ, ànɛ̂ Nsyudelɛ, ànɛ̂ Kapadɔsɩlɛ, ànɛ̂ Põtelɛ, ànɛ̂ Asilɛ, ");
INSERT INTO wib_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ànɛ̂ Frisyilɛ, ànɛ̂ Pãnfililɛ, ànɛ̂ Yesyiptilɛ, à tahlɩ Sirɛnɩ kwil tãn tyɩ́, Libi sɔkɔ, ànɛ̂ Wrome kwil tãn nónó-á mɛ tɛ̃̀nɔ́lɛ ásõ̂, ");
INSERT INTO wib_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ànɛ̂ Krɛtɩ tãnnɛ, ànɛ̂ Arabuninɛ. Ápi túkù sõ̀ dubi Nsyifunɔ Liyel nínɔ́ wɛ̃̀kɩ̀ sɔkɔ, tɛ́ túkù mó vi mɔ de álɛ ké sɔkɔ. Tɛ́ á pól mɛ Liyel tyí-ǹgbnɔ pɩ́nɔ́ tyɩ́ yónɔ́lɛ n nohnɩ pé tyɩ́ á kwlo wɛlɔ sɔkɔ.» ");
INSERT INTO wib_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Képah sõ̀ mɛ pé pól yáh-ńsah tyɛ, tɛ́ gbɛ̃̀ndùnì tɛ̃̀ tyɩ́, pè mɛ tyah n yo wɛ̃ tyɩ́ nɛ, tir nɛ̂ se képah n wɛ̃kɩ nɩ? ");
INSERT INTO wib_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Tɛ́ pé túkù mó sõ̀ mɛ kṍlɛ Yesu yõ sɛ̃́púlɛ n ko nɛ, dìvɛ̃ pènɛ̀kɩ̀-á tɛ̃ pélɛ. ");
INSERT INTO wib_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Képah sɔkɔ, Pyɛrɩ yuku yĩn pé no tɛ̃ntõ̀ névye nɛ́pĩ̂ gbɔ̃núkú tɛ́lɔ́ nɩyṍ, tɛ́ tyah n yo yĩ́npɔ̃́ ǹgbɛ̃nɛ tɔ́wû tyɩ́ nɛ: «Ápi Nsyifunɔ póllɛ ànɛ̂ nónó pól-á mɛ tɛ̃̀nɔ́lɛ Yerusalɛmɩ kwil, yé yé ní kwɔ noh pallɛ ń tyɩ́, yè mó ń wɛy syɩ́kɩ́-ńsah pɩ̃. ");
INSERT INTO wib_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Mé pɩ̃ nɛ yáh mɛ n sõ nɛ, sètɛ̃̀nɩ̀ sɔkɔ-á no nɔ́pilɛ, tɛ́ sɛ̃́ náh dɛ́! Pɔ̃̂y tɔ̃ gbĩ́ ó sɔkɔ náh álɛ yɔ̀ di? ");
INSERT INTO wib_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ǹtɛ Liyel tɛ̃ntõ̀ syínyo-ò Nsyowɛlɩ-á nɛ̂ yo sah, képah ye pɩ yɔ̀. ");
INSERT INTO wib_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","À lésõ nɛ, Liyel-á nɛ ńkɛ̃́: ‹Kèkõyṍ-à pópó n tyɛ, mé kɩ ń Mirki tiki mɔ no pól yõ. Yé dĩ́npì ànɛ̂ yé syɔ́npì kɩ ń tɛ̃ntõnènɛ n syi n yo. Mé kɩ wɛ̃́kɩ́nɔ́lɛ yé kètɛ̃̀npìlɛ n wɛ̃kɩ, tɛ́ yé yèwàhnɩ̀ kɩ dlɛ́ynɛ n dɔ. ");
INSERT INTO wib_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Gbɩ yõ, kénɛ sèpĩ̀n sɔkɔ, mé kɩ ń Mirki tiki mɔ ń tõ̀npɩbɩ díbí ànɛ̂ syɔ́ yõ. Tɛ́ pè kɩ ń tɛ̃ntõnènɛ n syi n yo. ");
INSERT INTO wib_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Mé kɩ gbǐl tyi pɩ yĩ̂nyõ, tɛ́ kɩ gbǐl tyi pɩ sétáh yõ, nɛ̂-á kɩ pɩ tṍ, ànɛ̂ nyàh, ànɛ̂ gbìsyikilɛ, ");
INSERT INTO wib_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","gbĩ kɩ vi mɔ pɩ fɛ̃́ntũ̂nɛ, tɛ́ ńwɔ̃́ kɩ syãh tṍ sɔ̃́, tɛ́ Tɛ̃̀ ǹgbɛ̃ tukey tùkènɔ́ yòh ǹgbɛ̃ kɩ pyě pɔ, kénɛ tɔ̃́rɩ́ yòh ǹgbɛ̃nɛ. ");
INSERT INTO wib_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Képah sɔkɔ, nónó pól-à Tɛ̃̀ ǹgbɛ̃ ye gbo, pépi wɔ kɩ pwah.›» ");
INSERT INTO wib_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Pyɛrɩ-á Nsyowɛlɩ wɛlɔ nɔ́pi yo tɛ, à tɔ̃ ǹ syɩ yo pé tyɩ́ nɛ ńkɛ̃́: «Yisrayel tãn, yé noh ń tyɩ́, máh kɩ nɛ̂ yo n pi: Nasarɛtɩ Yesulɛ, ǹmɔ ye pɩ névi yɔ́lɛ, nɛ̂-á Liyel syɔ̃ ǹ tyɩ́, à ǹ gblɔ̌y tɔ̃́rɩ́lɛ yé wɛ̃kɩ ǹ gbǐl ànɛ̂ ǹ gbɛ̃̀ndùnì tyi pɩ́nɔ́ sɔkɔ yé wrɔ́. Yépi ńtɛ̃ ye kè pɩ̃ ó! ");
INSERT INTO wib_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Liyel-á ǹ tyi yah tɔkɔ sah sɔ̃́, sè pɩ sɛ̃́. À kénɛ dĩ́ gbàh dɛ mɔ yé kɔ̃, yé mɛ ǹnɛ Liyel dêl pɩ́pú kɔ̃ pè à syɩ dahnɩ yõ, à à ko mɔ. ");
INSERT INTO wib_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ǹtɛ kũ náh sõ̀ fɛ̃ à tɛ̃ n sah n pi. Képah ye, Liyel mɛ tɔ̃ ǹ lékó yilki mɔ, à à wilki kũ yèvyãhrɩ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ǹmɔ tyɩ́ ye lésõ yõ̀tɛ̃̀ dĩ́ Davidi yo nɛ ńkɛ̃́: ‹Péwɔ Tɛ̃̀ ǹgbɛ̃ Liyel náh mɛ ké tyɩ́ nɛ pé tɛ̃ n kwlɔ. Képah-á, à mɛ pélɛ gbĩ́mɛgbĩ́ pé yohnɩ mɔ yĩnnɛ. ");
INSERT INTO wib_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Páh tɔ̃ mɛ nɩ̀vɩ̀nɩ̀ sɔkɔ, ànɛ̂ nɩ̀vɩ̀nɩ̀ wɛlɔ ó-á pè n nɛ n wɛkɩ. Pé gbõ̀ sàhnɔ́-á mɛ ké yõ nɛ, pâh pɔ ku, pé min-á kɩ mɛ tɛ̃ yèvɩnɩ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","À náh pé lékó sah kũ kɔ̃ n pi, ànɛ̂ à náh n yɛ pé lékó kɔ̃ kè n pyãh n pi, péwɔ nɛ̂-á ǹ tõ̀npɩ pèpɛynɛ. ");
INSERT INTO wib_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Wǎh min wã̀llɛ pé wɛ̃kɩ. Tɛ́ kɩ pé kɔ̃, pé kɩ mɛ nɩ̀vɩ̀nɩ̀ sɔkɔ kṹmm ǹ yah.›» ");
INSERT INTO wib_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Képah yóntɛnɔ náh, Pyɛrɩ tɔ̃ yo pé tyɩ́ nɛ: «Á no, yé yɛ mè á náh nɛy Davidi tyi yo n wah yé syah. À lésõ ku pè yɩ̃. Tɛ́ kwɛy mɛ̀ sɔkɔ, ǹ diki ńtɛ̃ mɛ ápi kwil. ");
INSERT INTO wib_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ǹtɛ Liyel tɛ̃ntõ̀ syínyo-ò ye sõ̀ ǹnɛ. Ǹ gbõ̀ sàhnɔ́ sõ̀ mɛ Liyel vyãh kɔ̃́nɔ́ mɛ̀ yõ, Liyel-á ǹ wo nɛ̂ sɔkɔ nɛ, ǹ pétóbé sɔkɔ yɔ́-á kɩ pɔ pɩ yõ̀tɛ̃̀nɛ ǹ swɔ. ");
INSERT INTO wib_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Tɛ̃̀ wɔ ye pɔ pɩ Kristalɛ, nɛ̂ kɔ́r-á Liyel nɛy yáhntɔkɔnɔlɛ. Tɛ́ wǎh nɛ n yilki n mɔ n pi ǹ kúntɛnɔ náh, képah ye Davidi kwãh tɛ̃ wɛ, à kɔ̃ à nɛ ńkɛ̃́: ‹À náh n wũ n pi lékókwíl, ànɛ̂ ǹ lékó náh n pyãh n pi.› ");
INSERT INTO wib_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Núkúnúkú Yesu mɛ̀nɛ, á pól ye kè wɛ yĩ́nɛ nɛ wǎh ku, tɛ́ Liyel mɛ ǹ lékó yilki mɔ. ");
INSERT INTO wib_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","À yɔ̃ dɔkɔ sɔkɔ yĩ̂nyõ, mɛ kyɩ tɛ̃ Liyel gbõ̀yõ̀ sõ̀lɛ. Tɛ́ Sú Liyel-á ǹ vyãh kɔ̃ ǹ Mirki nɛ̂ tyɩ́ sɔkɔ, à mɛ kélɛ Yesu kɔ̃ à tiki mɔ á yõ. Képah ye á n yah, tɛ́ n nohnɩ yɔ̀. ");
INSERT INTO wib_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ǹtɛ Davidi náh dɔkɔ yuku yĩ̂nyõ, tɛ́ wǎh kè yo nɛ ńkɛ̃́: ‹Tɛ̃̀ ǹgbɛ̃ Liyel kè yo ńmɔ yõ̀tɛ̃̀ dĩ́ tyɩ́ nɛ, pɔ n kɔ̃ n tɛ̃ ń gbõ̀yõ̀ sõ̀lɛ, ");
INSERT INTO wib_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","fɔ́ɔ́ kè pɔ nɔ gbĩ́ nɛ̂-á mé kɩ á sépɛ́bɩ́ pɩ á gbáhkɩ̀ súnsàh-ǹsahlɛ.›» ");
INSERT INTO wib_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Képah yóntɛnɔ náh, Pyɛrɩ tɔ̃ pè syah nɛ: «Yisrayel tãn pól yɩ̃nɛ yè kè pɩ̃ gbɩ yõ nɛ, Yesu nɛ̂-á yépi tɛ̃ syɩ dahnɩ yõ, ǹmɔ-á Liyel pɩ TƐ̃̀ ǸGBƐ̃NƐ tɛ́ tɔ̃ à pɩ Kristalɛ, nɛ̂ kɔ́r-á Liyel nɛy yáhntɔkɔnɔlɛ.» ");
INSERT INTO wib_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Pyɛrɩ-á wɛy mɛ̀ yo pɔ tyɛ sɛ̃́, kè névye nɩ kah tɛ̃, pè mɛ Pyɛrɩ ànɛ̂ Yesu tɛ̃ntõ̀ névye tɛ́lɔ́ piki yah nɛ, pé no, sɔ̃́ se pé yɩ̃nɛ pé pɩ nɩ? ");
INSERT INTO wib_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Képah sɔkɔ, Pyɛrɩ mɛ yo pé tyɩ́ nɛ: «Yé yé nnɔ vi mɔ, yé nɛ́núkù núkú pól mó wèlnwìlkìnɔ́ wɛ ni sɔkɔ Yesu Krista yĩn yõ, yé tyípêl yɔ̃̀nmɔnɔ yĩnnɛ. Képah sɔkɔ, Liyel Mirki kɩ yé kɔ̃. ");
INSERT INTO wib_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Liyel-á ǹ vyãh kɔ̃ ǹ Mirki tyɩ́ sɔkɔ nónó yĩnnɛ, yépi ye, ànɛ̂ yé wɛ̃́npìlɛ, à tahlɩ nónó pól-á mɛ kwlo fɩ́fɩ́ sɔkɔ, ànɛ̂ nónó pól-á Tɛ̃̀ ǹgbɛ̃ Liyel kɩ n ye n pi.» ");
INSERT INTO wib_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Tɛ́ Pyɛrɩ tɔ̃ sõ̀ mɛ wɛlɔ náhnáhlɛ n gbah n yo pé tyɩ́, à sṍrélɛ n mɔ pé sɔkɔ. À sõ̀ mɛ n yo pé tyɩ́ nɛ: «Yé Liyel pwáhnmɔnɔ fɛ̃ syi, yè mó wil kwɛy gbĩ névye nɛ́pêl wrɔ́.» ");
INSERT INTO wib_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Képah sɔkɔ, nónó-á Pyɛrɩ wɛlɔ fɛ̃ syi, pè wèlnwìlkìnɔ́ wɛ ni sɔkɔ. Ké lésõlɛ, nɛ́pĩ̂ kèyõ núkú kyɛgbãm (3 000) kénkɔ̃ dohnɩ Yesu yõ sɛ̃́pú yõ. ");
INSERT INTO wib_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Képah tɛ̃̀nɛ, Yesu tɛ̃ntõ̀ névye-á kwɔ́nɔ́lɛ nónónɛ n kɔ̃, pé pól sõ̀ mɛ pé gblɔ̌y kɔ̃, mɛ n nohnɩ pé tyɩ́, tɛ́ mɛ kwrɔ mɔ pé sɔkɔ, à pɩ pélɛ núkúlɛ. Pè sõ̀ mɛ yõkelɛ n yõ pélɛ wɛ̃ tyɩ́, tɛ́ mɛ nírílɛ n pɩ pélɛ. ");
INSERT INTO wib_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Liyel sõ̀ mɛ n syɔ̃ Yesu tɛ̃ntõ̀ névye tyɩ́, à gbǐl tyi náhnáhlɛ n pɩ. Kǎh pɩ sɛ̃́, kè tíkílɛ no pól tɛ̃. ");
INSERT INTO wib_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Nónó pól-á sõ̀ vi mɔ pɩ Yesu yõ sɛ̃́púlɛ, pè sõ̀ mɛ kwrɔ mɔ tɛ̃ wɛ̃ tyɩ́, tɛ́ mɛ pé gbã̀n yî póllɛ n sah wɛ̃ yõ. ");
INSERT INTO wib_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Pè sõ̀ mɛ pé swɛ̃y ànɛ̂ pé gbã̀n yîlɛ n yãm. Tɛ́ mɛ sé yã̀mnɔ́ pɔ́nɔ́lɛ n dibi wɛ̃ wrɔ́, à yɩ̃nɛ pé nɛ́núkù núkú pól fyã̀hnɔ́nɔlɛ. ");
INSERT INTO wib_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Tɛ́ pè sõ̀ mɛ pé sõnɔ pɩ núkúlɛ, à wɛ̃nɛ n tuke n mɔ sõmɛsṍ Liyel ní-ńsah gbô sɔkɔ. Pè sõ̀ pé fɔkɔ dal wɛ̃nɛ, à yõkenɔlɛ n yõ wɛ̃ yõ nɩ̀vɩ̀nɩ̀nɛ, pé gbéngbèn sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Pè sõ̀ mɛ Liyellɛ n gbilki, tɛ́ no pól mɛ pélɛ n sõ. Tɛ́ Tɛ̃̀ ǹgbɛ̃ sõ̀ mɛ névyelɛ n pwah n mɔ n dohnɩ pé yõ sõmɛsṍ. ");
INSERT INTO wib_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Képah sɔkɔ, sõ yɔ́lɛ Pyɛrɩ ànɛ̂ Nsyɔ̃ sõ̀ mɛ n yuku gbèkãm gbĩ́ Liyel ní-ńsah, Liyel ní-ńsah gbô sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Tɛ́ dĩ́ yɔ́ sõ̀ mɛ gbáhkɩ̀ núkúlɛ ǹ dubi gbĩ́ dùkùlɛ. Sõmɛsṍ, pè sõ̀ ńkɛ̃́nɛ à twah n pɔ n sah Liyel ní-ńsah gbô dé-ńsah yah sɔkɔ, nɛ̂-á pè n ye dé-ńsah Kètǎrlɛ, à kɔ̃ ǎ pɔ́lɛ n ni n syi ké sɔkɔ dépú tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Wǎh Pyɛrɩ ànɛ̂ Nsyɔ̃ wɛ pè n tyah dénɔ́lɛ ké sɔkɔ, à pɔ́ ni pé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Képah sɔkɔ, pè à gbah yah, tɛ́ Pyɛrɩ mɛ yo ǹ tyɩ́ nɛ, à pé yah yĩ́ĩ́. ");
INSERT INTO wib_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Wǎh yo sɛ̃́, dĩ́ sõ̀ wɛ nɛ, páh kɩ kwâh yɔ́ wɛ n syi n pi pé tyɩ́, tɛ́ tyah pélɛ n gbah n yah. ");
INSERT INTO wib_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Képah tɛ̃̀nɛ, Pyɛrɩ mɛ yo ǹ tyɩ́ nɛ, pɔ́ ànɛ̂ sã́n náh mɛ pé tyɩ́, ǹtɛ kwâh nɛ̂-á mɛ pé tyɩ́, páh kɩ kélɛ à kɔ̃. Tɛ́ nɛ: «Nasarɛtɩ Yesu Krista yĩn yõ, yuku nɛ n kɔ!» ");
INSERT INTO wib_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Tɛ́ mɛ ǹ gbõ̀yõ̀ sɔkɔ tɛ̃, à à yilki sah. Nɛ́npɔ́ swɔ, sèkùkù dĩ́ gbyẽ̂h ànɛ̂ ǹ létṍhnɩ̀ sũ. ");
INSERT INTO wib_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","À núkú yɔkɔ syɩkɩ ǹ gbyẽ̂h yõ, à tyah n kɔ, tɛ́ de pélɛ Liyel ní-ńsah gbô sɔkɔ, mɛ n kɔ, tɛ́ n yɔkɔ n syɩkɩ, à Liyellɛ n gbilki. ");
INSERT INTO wib_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","No pól à wɛ à mɛ n kɔ, mɛ Liyellɛ n gbilki. ");
INSERT INTO wib_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Pè mɛ à yah pɩ̃ nɛ, ǹmɔ-á ńkɛ̃́nɛ n tɛ̃ ǹ nɛ n ni n syi Liyel ní-ńsah gbô dé-ńsah sɔkɔ, nɛ̂-á pè n ye dé-ńsah Kètǎrlɛ. Tɛ́ tir nɛ̂-á pɩ ǹ tyɩ́, képah sõ̀ mɛ kah pɩ yáh-ńsah tyɛ́nɔ́ ànɛ̂ gbɛ̃̀ndùnìnɛ no pól tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Képah sɔkɔ, sèkùkù dĩ́ náh tɔ̃ sõ̀ mɛ ǹ syɩ Pyɛrɩ ànɛ̂ Nsyɔ̃ náh. Tɛ́ gbɛ̃̀ndùnì kàhnmɔnɔ tɛ̃̀ tyɩ́, névye to pɔ pè mɔ gbɩ̃ Liyel ní-ńsah gbô párn yɔ́ sõ̀, nɛ̂-á pè n ye Salomo párnnɛ. ");
INSERT INTO wib_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pyɛrɩ-á képah wɛ sɛ̃́, à yo tɔ́wû tyɩ́ nɛ: «Yisrayel tãn, kwâh nɛ̂ pɩ, tɛ́ tir mɛ̀ pɩ́nɔ́ yé gbã̀n du wɛ́? Kwâh nɛ̂ pɩ tɛ́ yé álɛ n gbah n yah sɛ̃́? Yé káh wɛ nɛ ápi yɛ̃́ngbɛ̃́ tɛ̃́nwɛnɔ, képah náh pɩ, á Liyel wɛ̃̀kɩ̀ tɛ̃́nɔ́ pèpɛy-á pɩ dĩ́ mɛ̀nɛ à kɔ̃ à kɔ dɛ́? ");
INSERT INTO wib_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Á náh tãn nónó-á pɩ Abrahmɩ, ànɛ̂ Yisakɩ, ànɛ̂ Nsyakɔbɩ, ànɛ̂ pé no tɛ́lɔ́lɛ, pépi Liyel ye gbílkínɔ́ sah ǹ tõ̀npɩ Yesu yõ, ǹmɔ nɛ̂-á yé dahbɩ yõ̀tãm gbõ̀, tɛ́ à yahle gbɛ̃̀nyah yah tɛ̃́-ò dĩ́ Pilati yĩ́ yah. Tɛ́ Pilati mó tɔ̃ sõ̀ kè yah tɔkɔ nɛ, pé à fĩn mɔ. ");
INSERT INTO wib_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ǹtɛ ǹmɔ nɛ̂-á mɛ Liyel tyɩ́ yõ, tɛ́ mɛ nɛ́gbɩ́lɛ Liyel yah, yé ǹmɔ yahle, tɛ́ pyě nɛ́kókè mɔ́-ò wɔ fĩ́nmɔnɔ yah kɔ̃. ");
INSERT INTO wib_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Tɛ́ min nɛ́tɛ̃̂ Yesu nɛ̂-á yé ko mɔ, yépi ńtɛ̃ ye kè wɛ yĩ́nɛ, Liyel mɛ ǹ lékó yilki mɔ. ");
INSERT INTO wib_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Dĩ́ nɛ̂-á yé n yah yɔ̀, yé ǹnɛ n pnɛ. Yesu yĩn yõ sɛ̃́nɔ́ gbõ̀ yõ sɔkɔ ye ǹ gbyẽ̂h mɛ sũ. Yé pól yĩ́ yah ye Yesu yõ sɛ̃́nɔ́ dĩ́ mɛ̀ dɛ mɔ pnɛ́pnɛ́ yɔ̀ dɛ́! ");
INSERT INTO wib_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Ǹtɛ núkúnúkú, á no, mé pɩ̃ nɛ ǹpɩ̃̀-ǹkɛ̃̂ sɔkɔ-á yépi ànɛ̂ yé yõ̀tãm ko mɔ Yesulɛ. ");
INSERT INTO wib_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Tɛ́ Liyel-á lésõ ǹ tɛ̃ntõ̀ syínyopu pól kɔ̃, pè nɛ̂ yo sah di mónɔ́lɛ nɛ, Krista-á kɩ yèvyãhrɩ pɩ, képah ye à pɩ yɔ̀. ");
INSERT INTO wib_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Kǎh pɩ sɛ̃́, yé yé nnɔ vi mɔ, yè mó Liyel wɛ̃̀kɩ̀ tɛ̃, à kɔ̃ à yé tyípêl yɔ̃ mɔ yé kɔ̃. ");
INSERT INTO wib_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Képah sɔkɔ, Tɛ̃̀ ǹgbɛ̃ Liyel kɩ yèvɩnɩ gbĩ́nɛ yé kɔ̃, tɛ́ kɩ Yesu Krista tɛkɩ mɔ yé kɔ̃, wǎh sõ̀ nɛ̂ yah wilki sah yépi yĩnnɛ. ");
INSERT INTO wib_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ǹtɛ núkúnúkú, à yɩ̃nɛ à tɛ̃ yĩ̂nyõ, fɔ́ɔ́ kè kyɩ syɩ tyi pól tɔ̃́nsàhnɔ́ tyɩ́, sépi nónó-á Liyel ǹ tɛ̃ntõ̀ syínyopu kɔ̃ pè sè yo sah ǹgbò dùkùlɛ, pépi nónó-á mɛ ǹ tyɩ́ yõ. ");
INSERT INTO wib_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moyisi kè yo sah ǹgbòlɛ nɛ ńkɛ̃́: ‹Yé Tɛ̃̀ ǹgbɛ̃ Liyel kɩ yé sɔkɔ nɛy yɔ́ wilki mɔ yé kɔ̃ n pi, à kɩ pɔ pɩ Liyel tɛ̃ntõ̀ syínyo-òlɛ ńmɔ tyɩ́ kɔ̃lɛ. Yé nɛ n nohnɩ ǹ tyɩ́ ǹ wɛlɔ pól sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Tɛ́ nɛ̂-à yahle sàhnɔ́lɛ ǹ tyɩ́ yõ, tɛ̃̀ tyɩ́ kɩ yɩkɩ, à kɩ ku to Liyel wɛ̃́npì wrɔ́.› ");
INSERT INTO wib_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ǹtɛ gbĩ nɛ̂-á yé n wnɛ yɔ̀, képah tyɩ́ ye Liyel tɛ̃ntõ̀ syínyo-ò Samuyɛlɩ yo sah ǹ mɛ gbĩ́ dùkùlɛ, à tahlɩ Liyel tɛ̃ntõ̀ syínyopu tɛ́lɔ́ tyɩ́, nónó pól-á pɔ ǹmɔ tyɩ́ náh. ");
INSERT INTO wib_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Yé yah, Liyel-á tyi nónó pól yo ǹ tɛ̃ntõ̀ syínyopu tyɩ́, yépi yĩn ye à yo sélɛ, à tahlɩ wǎh lésõ yégbékè kwrɔ́nmɔnɔ nɛ̂ pɩ yé náh tãn tyɩ́, nɛ̂-á à yo Abrahmɩ tyɩ́ nɛ ńkɛ̃́: ‹Áwɔ pétóbé gbõ̀ yõ, kèkõyṍ névye pól kɩ ń pèpɔrɩ wɛ.› Kénɛ yégbékè kwrɔ́nmɔnɔ nɛ̂-á à pɩ yé náh tãnnɛ yɔ̀, yépi tɔ vyãh mɛ ké sɔkɔ dò! ");
INSERT INTO wib_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Yépi ǹgbò tyɩ́ ye Liyel tɛkɩ mɔ ǹ tõ̀npɩ Yesulɛ pèpɔrɩ pɩ yĩnnɛ yé tyɩ́ nɛ, à yé pól nɛ́núkù núkú yohnɩ n mɔ yé kɔ̃ yé tyítúkúnì pɩ́nɔ́ yal n mɔ.» ");
INSERT INTO wib_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Képah tɛ̃̀nɛ, Pyɛrɩ ànɛ̂ Nsyɔ̃-á sõ̀ mɛ wɛ́kɩ́nɔ́ sɔkɔ tɔ́wû tyɩ́ sɛ̃́, nósyɔ́ pɔ wil mɔ pé yõ. Sárká syínwìlkìpu yísyɔ́ ye sõ̀, ànɛ̂ Liyel ní-ńsah gbô syɩ́kɩ́pú yõ̀tɛ̃̀nɛ, à tahlɩ Sadusɛ̃ névye yísyɔ́ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Tɛ́ kénɛ no fɔkɔ sõ̀ mɛ kah vyãh Pyɛrɩ ànɛ̂ Nsyɔ̃nɛ, pǎh sɔ̃́npɩ́lɛ névyelɛ n kwɔ nɛ, Yesu-á ku tɛ́ yilki mɔ, ànɛ̂ lékyɩ̂ tɔ-á kɩ pɔ n yilki n mɔ n pi. ");
INSERT INTO wib_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Képah sɔkɔ, pè pè tɛ̃. Tɛ́ lékã̂h-á sõ̀ mɛ mɔ n tɛ sɛ̃́, képah ye pè pè dah mɔ wɔ̀kɔ̀npèkè sɔkɔ, pópó à pɔ syɩ dĩndal tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ǹtɛ nónó-á Yesu tɛ̃ntõ̀ névye kwɔ́nɔ́ noh, pé náhnáh Liyel wɛ̃̀kɩ̀ tɛ̃. Kǎh pɩ sɛ̃́, Yesu yõ sɛ̃́pú nɔ nɛ́pĩ̂ kèyõ nínɔ́ kyɛgbãm (5 000) kénkɔ̃lɛ. ");
INSERT INTO wib_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Képah sɔkɔ, ké dĩndallɛ, Nsyifunɔ yõ̀tãm, ànɛ̂ kwil yèwàhnɩ̀, ànɛ̂ Liyel tyi kõ̀nsàhnɔ́ kwɔ́pú wɛ̃ tuke Yerusalɛmɩ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Sárká syínwìlkìpu yõ̀tɛ̃̀ ǹgbɛ̃ An sõ̀ mɛ ànɛ̂ ǹ gbô tãn póllɛ. Pépi túkù ye sõ̀ pɩ Kayifilɛ, ànɛ̂ Nsyɔ̃nɛ, ànɛ̂ Alɛkisãdrelɛ. ");
INSERT INTO wib_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Képah tɛ̃̀nɛ, pè Pyɛrɩ ànɛ̂ Nsyɔ̃ tɛ̃ pɔ pé nɩyṍ, à pɔ pè piki yah nɛ, tɛ̃́nwɛnɔ nɛ̂ gbõ̀ yõ se, képah náh pɩ, nɛ̂ yĩn yõ se pè pɩ dɛ́nmɔnɔ mɛ̀nɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Képah sɔkɔ, Liyel Mirki gbõ̀ yõ, Pyɛrɩ pè syah nɛ: ");
INSERT INTO wib_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","«Kwil yõ̀tãm ànɛ̂ yèwàhnɩ̀, áyáh pèpɔrɩ pɩ sèkùkù dĩ́ yɔ́ tyɩ́, képah yõ sɔkɔ náh yé n piki n yah álɛ kwɛynɛ nɛ, sɔ̃́ se á pɩ, tɛ́ à dɛ mɔ di? ");
INSERT INTO wib_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Yépi pól ànɛ̂ Yisrayel tãn pól yɩ̃nɛ yè kè pɩ̃ nɛ, Nasarɛtɩ Yesu Krista yĩn yõ-á dĩ́ mɛ̀nɛ yĩ́nntɛ̃̀nɔ́lɛ yé yah sɔkɔ lènɔlɛ yɔ̀. Yépi ye syɩ Yesulɛ dahnɩ yõ, tɛ́ Liyel mɛ ǹ lékó yilki mɔ. ");
INSERT INTO wib_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ǹmɔ Yesu tyɩ́ ye yónɔ́lɛ Liyel wɛy sɔkɔ nɛ ńkɛ̃́: ‹Wɔ̀kɔ̀ mɔ́pú-á yahle dáhkɩ̀ nɛ̂ mɔ́nkõ̀nɔ́lɛ, képah ye pɔ pɩ wɔ̀kɔ̀ dáhgbɩ́lɛ.›» ");
INSERT INTO wib_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Képah náh, Pyɛrɩ tɔ̃ nɛ: «Yesu ó yĩn kɩ fɛ̃ névye pwah mɔ. Nɛ́ ǹmɔ ó yĩn náh, yĩn yɔ́ ńtɛ̃ náh ǹnɩ̂ yɔ́ ńtɛ̃ kɔ̃ kèkõyṍ, nɛ̂-á kɩ fɛ̃ névye min pwah mɔ.» ");
INSERT INTO wib_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Tukey tùkèpu sõ̀ pɩ̃ nɛ Pyɛrɩ ànɛ̂ Nsyɔ̃ náh Nsyifunɔ kǎrn ǹgbɛ̃ pɩ, ànɛ̂ pè náh mɛ n mɔ n kõ nɛ́npɔ́ tĩ̀nnɛ. Tɛ́ pǎh n wɛkɩ nɩ̀sãh ànɛ̂ lékã́mnɛ sɛ̃́, képah mɛ pé gbã̀n du. Ǹtɛ pè mó tɔ̃ sõ̀ pɩ̃ nɛ, pépi-á lésõ Yesu kɔ́mûnɛ. ");
INSERT INTO wib_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Tɛ́ pé yĩ́-á mó tɔ̃ sõ̀ mɛ dĩ́ mɛ̀ yõ nɛ̂-á dɛ́nmɔnɔ wɛ, tyíyóné náh tɔ̃ wɛ pé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Kǎh pɩ sɛ̃́, pè Pyɛrɩpi kɔ̃ pè wil tukey tùkèpu tĩ̀nkì wrɔ́, tɛ́ pépi mɛ wɛ̃ wɛ pé yahlɛ ");
INSERT INTO wib_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","tɛ́ nɛ, sɔ̃́ se pé kɩ pɩ no nɔ́pilɛ nɩ? Ńkɛ̃́, kɔ̃lɩ kɔ̃lɩ tɛ̃̀ náh se mó tɔ̃ kélɛ tɛ́. Yerusalɛmɩ tãn pól-á pɩ̃ nɛ, Pyɛrɩpi-á pɩ gbǐl mɛ̀nɛ. ");
INSERT INTO wib_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Kàh pɩ sɛ̃́, pé ye kè yahle pé tyɩ́ dírí sɔkɔ nɛ, pè káh tɔ̃ Yesu yĩnnɛ n yo ǹnɩ̂ yɔ́ ńtɛ̃ tyɩ́. Képah-à pɩ, yĩ mɛ̀ náh n tɔ̃ n mɔ n yuku n pi yahlɛ. ");
INSERT INTO wib_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Képah tɛ̃̀nɛ, pè tɔ̃ pè ye, tɛ́ kè yahle pé tyɩ́ gbógbó nɛ, pé káh tɔ̃ Yesu yĩn noh n yah pé vyɛ̃y yah, ànɛ̂ pè káh tɔ̃ kwɔ́nɔ́ pɩ ǹ yĩn yõ. ");
INSERT INTO wib_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ǹtɛ Pyɛrɩpi pè syah nɛ: «Yépi ńtɛ̃ kè sõ n yah kɛ̀: Kè se mɛ yɩ̃́nɛ́nɔ́lɛ Liyel tyɩ́, áyâh ǹmɔ tyɩ́ yɛ, tɛ́ yépi yóré fɛ̃ syi? ");
INSERT INTO wib_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ápi tɛ̃̀ wɔlɛ, áyáh nɛ̂ wɛ, tɛ́ nɛ̂ noh, á náh fɛ̃ n yɛ n pi sé yã́hnɔ́lɛ.» ");
INSERT INTO wib_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Képah tɛ̃̀nɛ, tukey tùkèpu tɔ̃ dírí gbah wɔ pé tyɩ́, tɛ́ pè fĩn mɔ. Pè náh sõ̀ mɛ vì-ǹsah wɛ pé wɛ fõh fõh tɛ̃̀nɛ, no pól-á sɔ̃́npɩ́lɛ Liyel yĩnnɛ n gbilki Pyɛrɩpi tyípɩ́kɩ̀ mɛ̀ yĩnnɛ. ");
INSERT INTO wib_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Tɛ́ dĩ́ nɛ̂ dɛ́nmɔnɔ-á sõ̀ pɩ gbǐllɛ, à kah ye tikininínɛ. ");
INSERT INTO wib_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pǎh fyɔ̀ Pyɛrɩ ànɛ̂ Nsyɔ̃ fĩn mɔ, sárká syínwìlkìpu yõ̀tãm ànɛ̂ yèwàhnɩ̀-á nɛ̂ yo pé tyɩ́, pè kyɩ sè pól yãh pé kɔ́mû tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Pé wɛlɔ nóhntɛnɔ náh, pé pól pé sõnɔ pɩ núkúlɛ, à Liyellɛ n ni nɛ ńkɛ̃́: «Tɛ̃̀ ǹgbɛ̃, áwɔ ye mɔ yĩ̂nyõlɛ, ànɛ̂ sétáhlɛ, ànɛ̂ pnɛ yɔlɛ, à tahlɩ sé sɔkɔ yíyìn pól tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ápi náh nɛy Davidi nɛ̂-á á tõ̀npɩlɛ, áwɔ ye à kɔ̃ à kè yo á Mirki gbõ̀ yõ nɛ ńkɛ̃́: ‹Kwâh nɛ̂ yúkúnyahlenɔ mɛ kwlo kwlo tyɩ́? Kwâh nɛ̂ tyíkwɛ̂ sõnɔ mɛ névye sɔkɔ! ");
INSERT INTO wib_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Kèkõyṍ yõ̀tãm wɛ̃ tyɩ́ mɔ, tɛ́ yah tãm tɔ tuke mɔ, à pɩ núkúlɛ, pè Tɛ̃̀ ǹgbɛ̃ Liyellɛ n fwo ànɛ̂ ǹ nɛy yáhntɔkɔnɔlɛ.› ");
INSERT INTO wib_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Gbɩ yõ, kwil mɛ̀ ńtɛ̃ sɔkɔ, yõ̀tɛ̃̀ dĩ́ Yerɔdɩ ànɛ̂ gbɛ̃̀nyah yah tɛ̃́-ò dĩ́ Põse Pilati ye wɛ̃ tyɩ́ mɔ, à tahlɩ Yisrayel tãn ànɛ̂ kwlo kwlo tɛ́lɔ́ tyɩ́, pè á tõ̀npɩ Yesulɛ n fwo, ǹmɔ nɛ̂-á á nɛy yáhntɔkɔnɔlɛ. ");
INSERT INTO wib_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Yah, wáh lésõ á tɛ̃́nwɛnɔ sɔkɔ tyi nónó yah tɔkɔ sah á dyɔ dyɔ tɛ̃̀nɛ, sépi ye pè pɩ. ");
INSERT INTO wib_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ǹtɛ núkúnúkú, yah pè ápilɛ n kyĩ n kɔ̃ kɛ̀! Nɩ̀sãh ǹgbɛ̃nɛ á kɔ̃, à á wɛynɛ n yah n yo, ápi nónó-á á tõ̀npɩbɩlɛ. ");
INSERT INTO wib_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Tɛ̃́nwɛnɔlɛ á kɔ̃, à yámpúlɛ n dɛ n mɔ, à mó gbǐl tyilɛ n pɩ, á tõ̀npɩ Yesu yĩn yõ.» ");
INSERT INTO wib_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Tɛ́ fɩ̃́ nɛ̂ sɔkɔ-á sõ̀ pélɛ tùkènmɔnɔlɛ, nírí-á fyɔ̀ n tyɛ, nɛ́npɔ́ núkú yike. Képah tɛ̃̀nɛ, Liyel Mirki pé pól tɔkɔ, pè tyah Liyel wɛynɛ n yah n yo n kɔ̃ nɩ̀sãhlɛ. ");
INSERT INTO wib_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Yesu yõ sɛ̃́pú pól sõ̀ mɛ n sõ dùkù núkúlɛ, tɛ́ mɛ ké tyɩ́ nɛ pé nɛ n pɩ dùkù núkúlɛ. Pé sɔkɔ yɔ́ ńtɛ̃ náh sõ̀ mɛ n yo nɛ, pé gbã̀n yîlɛ, pé gblɔ̌y núkúní tyɩ́-á sélɛ. Tɛ́ pé wɛ̃ wrɔ́, pé pól gbã̀n yî sõ̀ pɩ tɔ́wû tyɩ́lɛ. ");
INSERT INTO wib_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Tɛ́ tɛ̃́nwɛnɔ ǹgbɛ̃ sɔkɔ ye sõ̀ Tɛ̃̀ ǹgbɛ̃ Yesu tɛ̃ntõ̀ névye pɩ ǹ tyɩ́ yónwàhpu kègblɔlɛ, à ǹ tyɩ́lɛ n yo n kɔ̃ nɛ, wǎh ku tɛ́ yilki mɔ. Tɛ́ Liyel pèpɔrɩ ǹgbɛ̃ sõ̀ mɛ pé pól yõ. ");
INSERT INTO wib_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Swɛ̃y, képah náh pɩ, gbên-à sõ̀ mɛ nónó tyɩ́, pě sélɛ n yãm, ǹ tɛ́ sé pɔ́lɛ Yesu tɛ̃ntõ̀ névyelɛ n kɔ̃. Pépi n mó sélɛ n dibi, à yɩ̃nɛ pé nɛ́núkù núkú pól fyã̀hnɔ́nɔlɛ. Képah ye, yãm pɩ́-ò náh sõ̀ mɛ pé sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Tɛ́ légbĩ́nɛ, Nsyosɛfu yɔ́ sõ̀ mɛ, nɛ̂-á dubi Syipri gbɛ̃̀nyah. Levi yìkì nɛy ye sõ̀ ǹnɛ. Tɛ́ Yesu tɛ̃ntõ̀ névye mɛ yĩn dyɩ à kɔ̃ Barnabasɩlɛ, nɛ̂ kɔ́r-á sṍré mɔ́-òlɛ. ");
INSERT INTO wib_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ǹmɔ mɛ ǹ swãh yãm, tɛ́ mɛ pɔ ké pɔ́lɛ Yesu tɛ̃ntõ̀ névye gbõ̀ dahbɩ. ");
INSERT INTO wib_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ǹtɛ dĩ́ yɔ́ lésõ mɛ pè n ye Ananiyasilɛ. Ǹmɔ ànɛ̂ ǹ kyɩ Safira mɛ pé sétáh yɔ́ yãm, tɛ́ yo sah núkú yõ, ");
INSERT INTO wib_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","à ké pɔ́ túkù kãm sah. Képah náh, Ananiyasi mɛ kyɩ ké pɔ́ tɛ́ynɛ Yesu tɛ̃ntõ̀ névye kɔ̃. ");
INSERT INTO wib_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Képah sɔkɔ, Pyɛrɩ mɛ yo ǹ tyɩ́ nɛ, Ananiyasi, sétã̀n yõ̀tɛ̃̀ se pɩ sɔ̃́ tɛ́ wɛ de yĩ́ĩ́ ǹ nɩ sɔkɔ sɛ̃́, fɔ́ɔ́ à pɔ mɩ̀nɩ̀ yo Liyel Mirki tyɩ́, tɛ́ sétáh yã̀mnɔ́ pɔ́ túkù kãm sah nɩ? ");
INSERT INTO wib_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Sétáh mɛ̀ yã̀m-ǹkɛ̃̂ gbĩ́nɛ, ǹ yɛ̃́ngbɛ̃́ tyɩ́ kó sõ̀ kélɛ nɩ? Wǎh tɔ̃ pɔ kè yãm, ké pɔ́ kó pɩ ǹmɔ tyɩ́lɛ nɩ? Ǹtɛ yĩ mɛ̀ dùkù pɩ́nɔ́ sõnɔ se pɩ sɔ̃́, tɛ́ de ǹ nɩ sɔkɔ nɩ? Ńkɛ̃́, névye ó tyɩ́ náh à yo mɩ̀nɩ̀nɛ dɛ́, Liyel tɔ tyɩ́-á. ");
INSERT INTO wib_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananiyasi-á fyɔ̀ kénɛ wɛlɔ noh, à núkú syɩkɩ ku. Kǎh pɩ sɛ̃́, nónó pól-á yĩ mɛ̀ noh, tíkí pè kah tɛ̃. ");
INSERT INTO wib_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Wǎh ku sɛ̃́, kètɛ̃̀npì mɛ pɔ ǹ lékó fɔkɔ, tɛ́ à tɔkɔ kyɩ yɩ̃. ");
INSERT INTO wib_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Képah náh, lɛ́rɩ́nɔ́ tɔ̃́nɔ́ kénkɔ̃ sɔ́kɔ́ntɛnɔ náh, ǹ kyɩ pɔ de nɛ́npɔ́, tɛ́ tir nɛ̂-á pɩ sɔkɔ, à náh sõ̀ mɛ kè pɩ̃. ");
INSERT INTO wib_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pyɛrɩ mɛ à syah nɛ, à yo pé syah, dan mɛ̀ se ńtyɩ̃́nɔ pè yãm pé sétáh mɛ̀nɛ nɩ? À mɛ nɛ, àwe, kénɛ dan-á. ");
INSERT INTO wib_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Képah sɔkɔ, Pyɛrɩ mɛ yo ǹ tyɩ́ nɛ, pè se pɩ sɔ̃́, tɛ́ yo sah núkú yõ ǹ pɛlɛ, à pɔ Tɛ̃̀ ǹgbɛ̃ Mirki vyãh sõ̀lɛ n noh nɩ? À yah, nónó-á kyɩ yɩ̃ ǹ pɛ lékólɛ, pǎh mɛ pɔ n de yɔ̀. Tɛ́ pǎh kɩ ǹ tɔ lékó tɔkɔ n sɔkɔ n pi. ");
INSERT INTO wib_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Pyɛrɩ-á yo sɛ̃́, nɛ́npɔ́ swɔ, pi núkú syɩkɩ ǹ yah tĩ̀nnɛ, à ku. Kètɛ̃̀npì-á de kyɩ, pè kyɩ à wɛ kúnɔ́lɛ. Pè mɛ à tɔkɔ kyɩ yɩ̃ ǹ pɛ tnɔ̂. ");
INSERT INTO wib_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Képah sɔkɔ, tíkí Yesu yõ sɛ̃́pú tĩ̀nkì pól kah tɛ̃, à tahlɩ tyi nɔ́pi nóhpú pól tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Liyel sõ̀ mɛ n syɔ̃ Yesu tɛ̃ntõ̀ névye tyɩ́, à gbǐl tyi náhnáhlɛ n pɩ névye nɩyṍ. Pè sõ̀ mɛ pé sõnɔ pɩ núkúlɛ ànɛ̂ Yesu yõ sɛ̃́pú tɛ́lɔ́ póllɛ, tɛ́ wɛ̃nɛ n tuke n mɔ Liyel ní-ńsah gbô párn yɔ́ sõ̀, nɛ̂-á pè n ye Salomo párnnɛ. ");
INSERT INTO wib_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ǹtɛ no tɛ́lɔ́ sɔkɔ nɛy yɔ́ ńtɛ̃ náh sõ̀ mɛ ǹ nɩlɛ n syãh n kwrɔ n mɔ pé sɔkɔ. Tɛ́ no pól mó tɔ̃ mɛ pélɛ n kah n sõ. ");
INSERT INTO wib_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Képah sɔkɔ, díbí ànɛ̂ syɔ́ náhnáh sõ̀ mɛ n sɛ̃ Tɛ̃̀ ǹgbɛ̃ Yesu yõ, dòhnɩ̀nɔ́ kɔ̃ kè n pɩ n yuku ǹ yõ sɛ̃́pú yõ. ");
INSERT INTO wib_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Kǎh pɩ sɛ̃́, névye tyah n wil pé yámpúlɛ, à pélɛ n sah n pɔ pàl yõ, képah náh pɩ, sɛ̃ sɛ̃ yî yõ wã̀l yey sɔkɔ, nɛ Pyɛrɩ-à pɔ n sɔkɔ, tɛ́ ǹ mírkí wɛ mɔ pé sɔkɔ nɛy nɛ̂ yõ, tɛ̃̀ wɛ dɛ. ");
INSERT INTO wib_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Yerusalɛmɩ gbɔ̀plɔ kwlo névye náhnáh ńtɛ̃ tɔ sõ̀ mɛ pé yámpúlɛ n tɛ̃ n pɔ n pɔ, à tahlɩ névye tyɩ́, sétã̀n-á sõ̀ mɛ nónónɛ n kwlɔ. Tɛ́ pé pól sõ̀ mɛ dɛ́nmɔnɔlɛ n wɛ. ");
INSERT INTO wib_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Képah tɛ̃̀nɛ, sárká syínwìlkìpu yõ̀tɛ̃̀ ǹgbɛ̃ ànɛ̂ ǹ náh névye póllɛ nónó-á Sadusɛ̃ névyelɛ, pè tyah dyɔ́yɔ́kɩ̀lɛ n pɩ Yesu tɛ̃ntõ̀ névyelɛ, ");
INSERT INTO wib_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","tɛ́ pè tɛ̃ kyɩ dah mɔ wɔ̀kɔ̀npèkè sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ǹtɛ lékã̂h-á pɔ mɔ, Tɛ̃̀ ǹgbɛ̃ yĩ̂nyõ tõ̀npɩ yɔ́ pɔ wɔ̀kɔ̀npèkè mɛ̀ yah yɩkɩ mɔ ànɛ̂ ké sɔkɔ táh vɩ̀ yeynɛ, à Yesu tɛ̃ntõ̀ névye wilki, tɛ́ yo pé tyɩ́ nɛ: ");
INSERT INTO wib_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«Yé kyɩ Liyel ní-ńsah gbô sɔkɔ, yè kyɩ min sã́n tyi nɔ́pi pól yo névye tyɩ́.» ");
INSERT INTO wib_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Wɛy mɛ̀-á yo pè noh sɛ̃́, séngbɔ̃́ púpúlɛ, pè mɛ yuku kyɩ Liyel ní-ńsah gbô sɔkɔ, à kyɩ tyah kwɔ́nɔ́lɛ n pɩ. Légbĩ́nɛ, sárká syínwìlkìpu yõ̀tɛ̃̀ ǹgbɛ̃ ànɛ̂ ǹ náh névye mɛ kyɩ tukey tùkèpu tĩ̀nkì ye ànɛ̂ Yisrayel gbɛ̃̀nyah yèwàhnɩ̀ póllɛ. Tɛ́ mɛ sràsyíbí tõ nɛ, pè kyɩ Yesu tɛ̃ntõ̀ névye wilki n pɔ wɔ̀kɔ̀npèkè sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ǹtɛ pǎh kyɩ yĩni tɛ̃, pè náh pè wɛ wɔ̀kɔ̀npèkè sɔkɔ. Pè mɛ pé syɩ pɔ ké yah yo pé yõ̀tãm tyɩ́ nɛ ńkɛ̃́, ");
INSERT INTO wib_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","páh kyɩ wɔ̀kɔ̀npèkè yah wɛ tɛ̃́nmɔnɔlɛ pallɛ ànɛ̂ ké sɔkɔ táh vɩ̀ yey tɔlɛ, sé syɩ́kɩ́púlɛ tɛ̃̀nɔ́lɛ pé tɛ̃̀-ǹtã̀n sɔkɔ. Ǹtɛ páh se mó tɔ̃ sè yɩkɩ mɔ de, pé náh nɛy wɛ sé sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Pǎh yo sɛ̃́, yĩ mɛ̀ nóhnɔ́ Liyel ní-ńsah gbô syɩ́kɩ́pú yõ̀tɛ̃̀ dĩ́ ànɛ̂ sárká syínwìlkìpu yõ̀tãm fɔkɔ fil. Pè mɛ wɛ̃nɛ n piki n yah Yesu tɛ̃ntõ̀ névye tyɩ́-á pɩ dùkù nɛ̂nɛ. ");
INSERT INTO wib_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Pǎh mɛ képah sɔkɔ, ǹnɩ̂ yɔ́ pɔ yo pé tyɩ́ nɛ, névye nónó-á pè dah mɔ wɔ̀kɔ̀npèkè sɔkɔ, pǎh mɛ névyelɛ n kwɔ Liyel ní-ńsah gbô sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Képah tɛ̃̀nɛ, Liyel ní-ńsah gbô syɩ́kɩ́pú yõ̀tɛ̃̀ dĩ́ ǹ no tɛ̃, à pé nyáh sõ. Pǎh kyɩ, tíkí pè tɛ̃ nɛ páh kɩ nɛ pé pè tɛ̃ gbùgbù, névye káh pɔ pé minki ko dyêhlɛ. Kǎh pɩ sɛ̃́, pè pè ye yárr, à sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Pǎh kyɩ yĩni tɛ̃ pélɛ tukey tùkèpu tĩ̀nkì tyɩ́, sárká syínwìlkìpu yõ̀tɛ̃̀ ǹgbɛ̃ mɛ pè syah nɛ, ");
INSERT INTO wib_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","pé kó lésõ kè tũ pé tyɩ́ nɛ, pè káh tɔ̃ kwɔ́nɔ́ pɩ n yah dĩ́ mɛ̀ yĩn yõ nɩ? Tɛ́ pè yah, pǎh pé kwɔ́nɔ́ tɔ̃ mɔ Yerusalɛmɩ kwil pól sɔkɔ, tɛ́ tɔ̃ mɛ ǹ kũ plɔlɛ n twah pépi yõ kɛ̀! ");
INSERT INTO wib_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ǹtɛ Pyɛrɩ ànɛ̂ Yesu tɛ̃ntõ̀ névye tɛ́lɔ́ mɛ yo pé tyɩ́ nɛ: «Á kɩ Liyel dyɔ yĩ́ĩ́ tɛ̃̀ yɛ sɔ̃́, tɛ́ kɩ névye tyɩ́lɛ n pɩ? ");
INSERT INTO wib_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Yesu nɛ̂-á yé ko mɔ dahnɩ yõ, á náh tãn Liyel ye ǹ lékó yilki mɔ, ");
INSERT INTO wib_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","tɛ́ à yɔ̃ dɔkɔ sɔkɔ, à kyɩ à sah ǹ gbõ̀yõ̀ sõ̀lɛ. Tɛ́ à pɩ yõ̀tɛ̃̀nɛ, ànɛ̂ pwáhnmɔ-òlɛ nɛ ńkɛ̃́, ǹmɔ gbõ̀ yõ Yisrayel tãn fɛ̃ pé nnɔ vi mɔ, pè mó pé tyípêl yɔ̃̀nmɔnɔ wɛ. ");
INSERT INTO wib_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Kénɛ tyi nónó-á Liyel pɩ, ápi ànɛ̂ Liyel Mirki ye sé yónwàhpu kègblɔlɛ, wǎh képah nɛ̂nɛ névye kɔ̃, nónó-á sah ǹ tyɩ́ yõ.» ");
INSERT INTO wib_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Képah tɛ̃̀nɛ, tukey tùkèpu tĩ̀nkì-á wɛlɔ nɔ́pi noh sɛ̃́, pé fɔkɔ kah vyãh, fɔ́ɔ́ pè sõ̀ mɛ ké tyɩ́ nɛ, pé Yesu tɛ̃ntõ̀ névye ko mɔ. ");
INSERT INTO wib_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ǹtɛ Farisiyɛ̃ nɛy yɔ́ sõ̀ mɛ pé sɔkɔ pè n ye Kamalyɛlɩlɛ. Liyel tyi kõ̀nsàhnɔ́ kwɔ́-ò yɔ́ ye sõ̀ ǹnɛ, nɛ̂-á névye pól mɛ yõ̀yénnɛ n sah ǹ yõ. Ǹmɔ mɛ yuku yĩn tukey tùkèpu tĩ̀nkì nɩyṍ tɛ́ nɛ, pè Yesu tɛ̃ntõ̀ névye wilki mɔ kégbɔ́ kwéy átrɛ. ");
INSERT INTO wib_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Pǎh wil, à ǹ syɩ yo pé no tyɩ́ nɛ: «Á no Yisrayel tãn, yé yé gblɔ̌y kyɔmɩ yĩ́ĩ́ yé tyípɩ́nɔ́ sɔkɔ, à yuku díbí nɔ́pi tĩ̀nnɛ dɛ́! ");
INSERT INTO wib_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ké náh tɔ̃̌nɩ̀ pɩ di mónɔ́lɛ kah, gbĩ́ nɛ̂-á Tedasɩ mɛ yuku ǹ gblɔ̌y pɩ nɛ, nɛ́-ǹgbɛ̃-á péwɔlɛ, tɛ́ díbí nɛ́pĩ̂ kyɛyẽ́h (400) sõnɔ vi mɔ pè kɔ̃ pè ǹ sõ̀ tɛ̃. Ǹtɛ wǎh pɔ ko mɔ, ǹ sõ̀ tɛ̃́pú pól náh karkɩ di? Nɛy se tɔ̃ wũ? ");
INSERT INTO wib_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ǹmɔ tyɩ́ sɔ́kɔ́ntɛnɔ náh, Kalile gbɛ̃̀nyah dĩ́ Nsyudasɩ mɛ tɔ̃ yuku kénɛ gbɛ̃̀nyah névye yãh gbĩ́nɛ, à pé náhnáh yõ yɩkɩ pè kɔ̃ pè ǹ sõ̀ tɛ̃. Ǹtɛ ǹ tɔ náh pɔ ko mɔ, tɛ́ ǹ sõ̀ tɛ̃́pú mɛ karkɩ di? ");
INSERT INTO wib_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Képah ye núkúnúkú tɛ̃̀nɛ, mé kélɛ n yo yé tyɩ́, yé yé vyɛ̃y dɛ no nɔ́pi tyɩ́ sɔkɔ, yè mó pè fĩn mɔ pè nɛ n yuku. Pé tir yáhntɔkɔnɔ, képah náh pɩ, pé tyípɩ́nɩ́ mɛ̀-à kɩ mɛ wil névye tɛ̃̀ tyɩ́, kè kɩ tyɛ ké gblɔ̌y. ");
INSERT INTO wib_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ǹtɛ kàh kɩ mɛ wil Liyel tɛ̃̀ wɔ tyɩ́ tɔ́tɔ́, yépi náh fɛ̃ kè yɩkɩ n pi. Yé kyɔ̀mɩ̀nɔ́ pɩ, yè káh pɔ tyah Liyel wɔlɛ n fwo dɛ́!» Kamalyɛlɩ-á yo sɛ̃́, pé no sah ǹ tyɩ́ yõ. ");
INSERT INTO wib_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Pè mɛ tɔ̃ Yesu tɛ̃ntõ̀ névye ye de, à pɔ pè ko yèfõhlɛ. Tɛ́ kè yahle pé tyɩ́ nɛ, pè káh tɔ̃ Yesu tyɩ́lɛ n yãh, tɛ́ pè fĩn mɔ. ");
INSERT INTO wib_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ǹtɛ Yesu tɛ̃ntõ̀ névye sõ̀ mɛ nɩ̀vɩ̀nɩ̀ sɔkɔ kègbɩlɛ, pǎh n yal tukey tùkèpu tĩ̀nkì wrɔ́ gbĩ́ nɛ̂nɛ, pǎh sɔ̃́npɩ́lɛ kè kyɔmɩ wɛ nɛ, páh yɩ̃nɛ fṍhnɔ́lɛ Yesu yĩnnɛ. ");
INSERT INTO wib_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Képah sɔkɔ, sõmɛsṍ pè n nɛ n mɛ Liyel ní-ńsah gbô ànɛ̂ kétlo sɔkɔ, ǹ névyelɛ n kwɔ, ǹ tɛ́ Nɩ̀vɩ̀nɩ̀ tirlɛ n yo pé tyɩ́ Yesu Krista tyɩ́ yõ. ");
INSERT INTO wib_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Légbĩ́nɛ, wãn sõ̀ mɛ n mɔ Yesu tõ̀ sã́hpú nɛ́dán yõ. Képah sɔkɔ, Krɛkɩ wɛy wɛ́kɩ́pú tyah n wɛkɩ nɛ, sõmɛsṍ pé no Yebre wɛy wɛ́kɩ́pú-á mɛ n syɩkɩ pépi pɛ́kúsyɔ yõ yõke dibi gbĩ́nɛ. ");
INSERT INTO wib_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Kǎh pɩ sɛ̃́, Yesu tɛ̃ntõ̀ névye nɛ́pĩ̂ gbɔ̃nimí mɛ Yesu tõ̀ sã́hpú tɔ́wû pól ye tuke, tɛ́ yo pé tyɩ́ nɛ, kè náh yɩ̃nɛ pépi Liyel wɛy yónɔ́ yal n mɔ, pé mó de tɛ̃ yõke díbínɔ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Képah-á, pé yṹnpyé, pè díbí nɛ́pĩ̂ kwǎrnimi yah n wilki pé sɔkɔ, nónó yĩ́ngbɩ́-á mɛ n yo, tɛ́ Liyel Mirki mɛ pè tɔkɔ, ànɛ̂ lékã́m mɛ pé sɔkɔ. Páh kɩ tõ̀ mɛ̀ dahbɩ pépi gbõ̀. ");
INSERT INTO wib_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Kàh kɩ pɩ sɛ̃́, pépi-á kɩ mó yɔ̃ sɔkɔ nírí pɩ́nɔ́ ànɛ̂ Liyel wɛy yónɔ́ tõ̀lɛ. ");
INSERT INTO wib_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Képah sɔkɔ, pǎh nɛ̂ yo, tɔ́wû pól kè fɛ̃ syi. Pè mɛ Yetyɛ̃nɩ yah wilki, ǹmɔ nɛ̂ Liyel yõ sɛ̃́nɔ́-á sõ̀ mɛ gblò, tɛ́ Liyel Mirki mɛ à tɔkɔ. À tahlɩ Filipi tyɩ́, ànɛ̂ Prokɔrɩlɛ, ànɛ̂ Nikanɔrɩlɛ, ànɛ̂ Timolɛ, ànɛ̂ Parmenasɩlɛ, ànɛ̂ Antyɔsyɩ kwil Nikolasɩlɛ, ǹmɔ nɛ̂-á lésõ vi mɔ de Nsyifunɔ Liyel nínɔ́ wɛ̃̀kɩ̀ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Tɛ́ mɛ pépilɛ Yesu tɛ̃ntõ̀ névye wɛ̃kɩ. Pépi mɛ pé gbã̀n sah pé yõ nírí pɩ́nɔ́ sɔkɔ, à sãm mɔ pé sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Képah tɛ̃̀nɛ, Liyel wɛy sõ̀ mɛ n tɔ̃ n mɔ n yuku, tɛ́ wãn mɛ n mɔ n yuku náhnáh Yesu tõ̀ sã́hpú nɛ́dán yõ Yerusalɛmɩ kwil. Sárká syínwìlkìpu tɔ náhnáh sõ̀ mɛ fɛ̃ syi sɛ̃ Yesu yõ. ");
INSERT INTO wib_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Yetyɛ̃nɩ sõ̀ Liyel pèpɔrɩ náhnáh wɛ ànɛ̂ ǹ tɛ̃́nwɛnɔlɛ. À sõ̀ mɛ à tɔkɔ à gbǐl tyilɛ n pɩ névye nɩyṍ. ");
INSERT INTO wib_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Képah tɛ̃̀nɛ, Nsyifunɔ tyah yékã̂blɛ n pɩ Yetyɛ̃nɩnɛ. Pé túkùlɛ, Liyel ní-ńsah wɔ̀kɔ̀ nɛ̂-á pè n ye yɔ̃rɩ sɔkɔ wìlpu wɔ̀kɔ̀lɛ, képah névye ye. Pè n wil Sirɛnɩ kwil ànɛ̂ Alɛkisãdri kwil. Pé túkù mɛ n wil Silisi gbɛ̃̀nyah ànɛ̂ Asi gbɛ̃̀nyah sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Tɛ́ Liyel Mirki gbõ̀ yõ, Yetyɛ̃nɩ sõ̀ mɛ n wɛkɩ lékã́mnɛ. Képah ye, no nɔ́pi náh mɛ tɛ̃ wɛ ǹ wɛlɔlɛ n kɔ̃lɩ. ");
INSERT INTO wib_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Képah tɛ̃̀nɛ, pè kyɩ nósyɔ́ tɔkɔ pɔ́lɛ nɛ pè pɔ yo nɛ, páh à wɛ à mɛ Moyisi ànɛ̂ Liyel tyɩ́lɛ n yo n yɩkɩ. ");
INSERT INTO wib_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Pè képah pɩ, à tɔ́wû, ànɛ̂ yèwàhnɩ̀, ànɛ̂ Liyel tyi kõ̀nsàhnɔ́ kwɔ́pú mɔ Yetyɛ̃nɩ yõ, pè kɔ̃ pè à fyãh tɛ̃ yuku ǹnɛ tukey tùkèpu tĩ̀nkì tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Tɛ́ tɔ̃ tàrfyɔ̀ mɩ̀nyobe yísyɔ́ yah, à yuku pélɛ nɛ pè kyɩ yo nɛ, dĩ́ mɛ̀ náh mɛ n yal n mɔ Liyel ní-ńsah gbô ànɛ̂ Moyisi tyi kõ̀nsàhnɔ́ tyɩ́ yónyɩkɩnɔlɛ. ");
INSERT INTO wib_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Páh kè noh ǹ vyãh yah à mɛ n yo ńtɛ̃nɛ nɛ, kénɛ Nasarɛtɩ Yesu mɛ̀-á kɩ pɔ Liyel ní-ńsah gbô sɔ n pi, tɛ́ Moyisi-á pé kwɔ wã̀l nónónɛ, wǎh kɩ sé tɔ vi mɔ. ");
INSERT INTO wib_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Képah sɔkɔ, tukey tùkèpu tĩ̀nkì pól tyah Yetyɛ̃nɩnɛ n yah díkídíkí, tɛ́ ǹ yah wɛ kè mɛ yĩ̂nyõ tõ̀npɩ tyɩ́ kɔ̃lɛ. ");
INSERT INTO wib_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Képah sɔkɔ, sárká syínwìlkìpu yõ̀tɛ̃̀ ǹgbɛ̃ mɛ Yetyɛ̃nɩ piki yah nɛ, no-á nɛ̂nɛ n yo ǹ tyɩ́ sɔkɔ, gbɩ se kélɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Yetyɛ̃nɩ mɛ yo ǹ tyɩ́ nɛ: «Ń súbí ànɛ̂ ń yṹnpyé, yé noh ń tyɩ́. Gbĩ́ nɛ̂-á lésõ á náh nɛy Abrahmɩ náh tɔ̃̌nɩ̀ mɛ yal yuku Yarã kwil sɔkɔ, tɔ̃́rɩ́ nɛ́tɛ̃̂ Liyel ye lésõ wil ǹ yah Mesopotami gbɛ̃̀nyah, ");
INSERT INTO wib_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","tɛ́ mɛ yo ǹ tyɩ́ nɛ: ‹Yal á gbɛ̃̀nyah ànɛ̂ á kéte tãn wrɔ́, ǹ yuku gbɛ̃̀nyah yɔ́ sɔkɔ, nɛ̂-á mé kɩ ǹ wɛ̃kɩ n pi.› ");
INSERT INTO wib_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Képah sɔkɔ, Abrahmɩ yal Kalde tãn gbɛ̃̀nyah sɔkɔ, à kyɩ tɛ̃ Yarã kwil. Képah náh, ǹ sú-á pɔ ku tɛ, Liyel mɛ à kɔ̃ à yal Yarã kwil, à pɔ tɛ̃ gbɛ̃̀nyah mɛ̀ sɔkɔ, nɛ̂ sɔkɔ-á yépilɛ núkúnúkú yɔ̀. ");
INSERT INTO wib_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Tɛ́ Liyel náh sõ̀ sétáh yɔ́ ńtɛ̃nɛ à kɔ̃ ǹ tyɩ́lɛ ásõ̂. Gbáhsúkí kénkɔ̃ fyé tyahlɛ, à náh kélɛ à kɔ̃. Ǹtɛ à ǹ vyãhlɛ à kɔ̃ nɛ, páh kɩ pɔ gbɛ̃̀nyah mɛ̀ póllɛ à kɔ̃. Tɛ́ kǎh kɩ tɔ̃ pɩ ǹ pétóbé tɔ tyɩ́lɛ, ǹmɔ kɛ̃́ náh ńtɛ̃ sɔkɔ. Tɛ́ légbĩ́nɛ, pi ńtɛ̃ náh sõ̀ mɛ Abrahmɩ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Liyel mɛ tɔ̃ yo ǹ tyɩ́ nɛ: ‹Á pétóbé kɩ pɔ wil kɩ kyɩ n tɛ̃ n pi gbɛ̃̀nyah káhkɩ́ sɔkɔ. Nɛ́npɔ́ sɔkɔ pè kɩ n pɩ n pi yɔ̃bɩlɛ, tɛ́ kɩ fṍhnɔ́ wɛ, pópó ye kyɛyẽ́h (400). ");
INSERT INTO wib_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ǹtɛ gbɛ̃̀nyah káhkɩ́ nɛ̂ sɔkɔ-á pélɛ yɔ̃rɩ sɔkɔ, ńmɔ Liyel tukey kɩ n syɩkɩ n pi kénɛ gbɛ̃̀nyah tãn yõ. Tɛ́ képah náh, pè kɩ wil yɔ̃rɩ sɔkɔ nɛ́npɔ́, kɩ pé syɩ pɔ ńmɔ yĩn gbilki ásõ̂.› ");
INSERT INTO wib_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Képah yóntɛnɔ náh, Liyel mɛ yégbékè kwrɔ mɔ Abrahmɩnɛ, képah nɛ̂-á kɩ sõ̀ n wɛ̃kɩ n pi kõ̀kè kõ̀nɔ́ sɔkɔ. Képah ye, Abrahmɩ-á pɔ Yisakɩ dubi, à mɛ à kõ ǹ dúbínɔ́ sèpĩ̀n kwǎrtɔ̃-ò sõlɛ. Yisakɩ tɔ mɛ pɔ ǹ pídĩ́ Nsyakɔbɩ kõ. Nsyakɔbɩ tɔ mɛ pɔ ǹ dĩ́npì nɛ́pĩ̂ gbɔ̃nimí kõ, pépi nónó-á ápi yìkìnì gbɔ̃ninɔ́ náh tãnnɛ. ");
INSERT INTO wib_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Képah náh, á náh tãn pɔ tyah pé gbɛ̃̀ndĩ́ Nsyosɛfu dyɔlɛ n yɔ. Tɛ́ à tɛ̃ yãm yɔ̃̀lɛ, pè kɔ̃ pè sɔkɔ ǹnɛ Yesyipti gbɛ̃̀nyah. Ǹtɛ Liyel sõ̀ mɛ Nsyosɛfulɛ. ");
INSERT INTO wib_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","À ǹ yõ wilki yènvyã̀hnpèl nɔ́pi sɔkɔ, tɛ́ lékã́mnɛ à kɔ̃ yĩ́ĩ́, tɛ́ Yesyipti yõ̀tɛ̃̀ dĩ́ Farawɔ̃ yĩ́ kɔ̃ kè yuku ǹnɛ. Képah sɔkɔ, à mɛ à pɩ ǹ gbɛ̃̀nyah ànɛ̂ ǹ tɔ̃́rɩ́ kéte pól yah tɛ̃́-òlɛ. ");
INSERT INTO wib_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Tɛ́ kwɛ́npékè yɔ́ pɔ de Yesyipti gbɛ̃̀nyah ànɛ̂ Kanah gbɛ̃̀nyah pól sɔkɔ, à pɩ yèvyãhrɩ ǹgbɛ̃nɛ pé tyɩ́. Ké pékénkàhnmɔnɔ tɛ̃̀ tyɩ́, á náh tãn náh tɔ̃ sõ̀ mɛ kwâh yɔ́ ńtɛ̃nɛ n wɛ n yõ. ");
INSERT INTO wib_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Tɛ́ Nsyakɔbɩ-á pɔ kè wɛ noh nɛ, yõke-á mɛ Yesyipti sɔkɔ, ké gbennɛ, à á náh tãn tɛkɩ mɔ nɛ́npɔ́, pè kyɩ yõke yah pɔ, pépi nónó-á ǹ wɛ̃́npìlɛ. ");
INSERT INTO wib_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Pǎh tɔ̃ pɔ pé syɩ yuku kɛ ní-òlɛ, Nsyosɛfu mɛ ǹ gblɔ̌y tyɩ́ yo wah ǹ nɛ́nkyɩ́bɩ́ tyɩ́. Kǎh pɩ sɛ̃́, Farawɔ̃ mɛ Nsyosɛfu duku wìl-ǹsah pɩ̃. ");
INSERT INTO wib_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Képah sɔkɔ, Nsyosɛfu tɛ̃ntõ̀ mɔ nɛ, pè kyɩ pé sú Nsyakɔbɩ ànɛ̂ ǹ no pól tɛ̃ n pɔ. Pè sõ̀ mɛ nɛ́pĩ̂ tikitɔ̃nɩ́ pɔ́ gbãm pɔ́ kwlɔ́lɛ. ");
INSERT INTO wib_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Sɛ̃́ ye Nsyakɔbɩ mɛ yuku pɔ tɛ̃ Yesyipti gbɛ̃̀nyah sɔkɔ. À syi pɔ ku nɛ́npɔ́ ànɛ̂ á náh tãn tɔ póllɛ. ");
INSERT INTO wib_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Pé lékyɩ̂ mɛ twah kyɩ yɩ̃ Sisyɛmɩ kwil diki yɔ́ sɔkɔ, nɛ̂-á lésõ Abrahmɩ dwe Yemɔrɩ wɛ̃́npì tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Liyel-á lésõ ǹ vyãhlɛ Abrahmɩ kɔ̃ nɛ̂ yĩnnɛ, ké pɩ gbĩ́-á pɔ n nɔ, ápi no kwel náhnáh Yesyipti sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Tɛ́ yõ̀tɛ̃̀ késã́n yɔ́-á pɔ dɔkɔ Yesyipti yõ, ǹmɔ náh sõ̀ Nsyosɛfulɛ n pnɛ. ");
INSERT INTO wib_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","À mɛ vi syɩkɩ á no yõ. Ǹ nɛ́pékè kàhnmɔnɔ tɛ̃̀ tyɩ́, à á náh tãn kyɩ̃ mɔ, pè kɔ̃ pè pé wɛ̃́npì yrɔ̃́ milki sah kégbɔ́ pé ku yĩnnɛ. ");
INSERT INTO wib_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Légbĩ́ mɛ̀ ó sɔkɔ ye Moyisi dubi. À kah plɛ yĩ́ĩ́, ànɛ̂ ǹ tyɩ́ nɔ Liyel tyɩ́. Pè à pu ńwɔ̃́lɔ́ tɔ̃́nɔ́ ǹ sú gbô. ");
INSERT INTO wib_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Képah náh, pè à tɔkɔ kyɩ milki. Farawɔ̃ písê mɛ à wɛ tɔkɔ. À pɔ à pu ǹ yɛ̃́ngbɛ̃́ pídĩ́ sɔ̃́. ");
INSERT INTO wib_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Kǎh pɩ sɛ̃́, lékã́m tyi nónó pól-á sõ̀ mɛ Yesyipti sɔkɔ, Moyisi kwɔ́nɔ́ wɛ sé pól yõ. Képah ye, à pɩ wɛ̀ntǎhnɩ̀ wɛ́kɩ́-òlɛ ànɛ̂ tyítǎhnɩ̀ pɩ́-òlɛ. ");
INSERT INTO wib_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Tɛ́ wǎh pɔ nɔ ye tikininínɛ gbĩ́ nɛ̂nɛ, à kè sõ wɛ nɛ, páh kɩ kyɩ yah pé yṹnpyé Yisrayel tãn tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Wǎh kyɩ, à kyɩ yɩ̃nɛ ǹ tyɩ́ névi yɔ́lɛ, Yesyipti nɛy yɔ́ mɛ n fõh. Moyisi tyɩ́ névi fṍhnɔ́ yrɔ tɛ̃̀ tyɩ́, à ǹ vyãh syi, à Yesyipti nɛy mɛ̀ ko mɔ. ");
INSERT INTO wib_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moyisi sõ̀ mɛ n sõ nɛ, pé no Yisrayel tãn-á kɩ n pɩ̃ n pi nɛ, Liyel-á kɩ péwɔ tɔkɔ, kɩ pè wilki n pi pé yɔ̃rɩ sɔkɔ. Ǹtɛ pè náh tɛ̃ wɛ kè pɩ̃ ǹ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ké dĩndallɛ, à tɔ̃ kyɩ Yisrayel tãn nɛ́pĩ̂ nímí yísyɔ́ wɛ, pè mɛ n fwo. À nɛ pé pè syi mɔ, tɛ́ yo pé tyɩ́ nɛ, pé no, pépi ó-á pé yahlɛ. Tɛ́ kwâh nɛ̂ se pè wɛ̃nɛ n fõh nɩ? ");
INSERT INTO wib_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ǹtɛ nɛ̂-á sõ̀ n fõh ǹ ní-òlɛ, ǹmɔ Moyisi syah nɛ ńkɛ̃́, nɛ̂ se sah ǹnɛ pépi yõ̀tɛ̃̀nɛ ànɛ̂ pé tùkè-òlɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Péwɔ kònmɔ-ńsah káh kɩ nɛ̂, á n yah n kɔ̃, wǎh ńnɩ́nɩ́nɛ Yesyipti nɛy mɛ̀ ko mɔ sɔ̃́ dɛ́? ");
INSERT INTO wib_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Wǎh fyɔ̀ képah yo, Moyisi to, tɛ́ kyɩ tɛ̃ Madyã gbɛ̃̀nyah sɔkɔ, à syi pɔ dĩ́npì nɛ́pĩ̂ nímí wɛ nɛ́npɔ́. ");
INSERT INTO wib_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","À tɛ̃ nɛ́npɔ́, pópó à ye tikininí pɩ. Képah náh, sõ yɔ́lɛ, à sõ̀ mɛ gbɛ̃́nnɩ sɔkɔ, Syinayi yɔ̃lɩ gbɔ̀pɔ, tɛ́ yĩ̂nyõ tõ̀npɩ yɔ́ wil ǹ yah nyàh lépɔ̃́ sɔkɔ, nɛ̂-á sõ̀ mɛ n kõ dukuni yɔ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Yĩ mɛ̀ wɛ́nɔ́ pɩ gbɛ̃̀ndùnìnɛ Moyisi tyɩ́. Tɛ́ wǎh mɛ n nɔ n de nɛ, pé kè wɛ yah yĩ́ĩ́, à Tɛ̃̀ ǹgbɛ̃ yónmɔnɔ noh nɛ ńkɛ̃́: ");
INSERT INTO wib_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‹Á náh tãn Liyel ye ńmɔlɛ, Abrahmɩ, ànɛ̂ Yisakɩ, ànɛ̂ Nsyakɔbɩpi Liyellɛ.› Képah tɛ̃̀nɛ, tíkí Moyisi tɛ̃, fɔ́ɔ́ ǹ wil n syah. À náh tɔ̃ ǹ nɩ syãh ǹ yah yɔ̃ yah. ");
INSERT INTO wib_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Képah sɔkɔ, Tɛ̃̀ ǹgbɛ̃ mɛ yo ǹ tyɩ́ nɛ: ‹Tyah nɛ̂ sɔkɔ-á álɛ yɔ̀, nɛ́npɔ́ mɛ ńmɔ tyɩ́ yõ. Képah ye, á lékyêh dɛ. ");
INSERT INTO wib_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Mé ń no kwlɔ dùkù wɛ yĩ́nɛ Yesyipti gbɛ̃̀nyah sɔkɔ, tɛ́ pé gbĩ̀nɔ́ yĩ́npɔ̃́ noh. Mé pɔ pé wìlkì-ǹsah pé yɔ̃rɩ sɔkɔ. Képah ye, sɔkɔ! Mé álɛ n tɛkɩ mɔ ké tyɩ́ sɔkɔ núkúnúkú Yesyipti sɔkɔ.› ");
INSERT INTO wib_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Tɛ́ kénɛ Moyisi nɛ̂-á lésõ Yisrayel tãn yahle, tɛ́ à syah nɛ ńkɛ̃́, nɛ̂ se sah ǹnɛ pépi yõ̀tɛ̃̀nɛ ànɛ̂ pépi tùkè-òlɛ nɩ? Ǹmɔ ó ye tɔ̃ Liyel tɛkɩ mɔ yõ̀tɛ̃̀nɛ ànɛ̂ pwáhnmɔ-òlɛ yĩ̂nyõ tõ̀npɩ gbõ̀ yõ, nɛ̂-á lésõ wil ǹ yah dukuni sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moyisi ye wilki Yisrayel tãnnɛ Yesyipti gbɛ̃̀nyah sɔkɔ, tɛ́ pnɛ yɔ́nsyã̂h kah pélɛ, tɛ́ tɛ̃ pélɛ gbɛ̃́nnɩ sɔkɔ pópó ye tikininí. Liyel gbõ̀ yõ ye à pɩ sépi póllɛ gbǐl sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Tɛ́ ǹmɔ ye tɔ̃ yo Yisrayel tãn tyɩ́ nɛ: ‹Liyel kɩ yé sɔkɔ nɛy yɔ́ tɛkɩ n mɔ n pi. À kɩ pɔ pɩ Liyel tɛ̃ntõ̀ syínyo-òlɛ ńmɔ tyɩ́ kɔ̃lɛ.› ");
INSERT INTO wib_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Gbĩ́ nɛ̂-á sõ̀ Yisrayel tãn mɛ tùkènmɔnɔlɛ gbɛ̃́nnɩ sɔkɔ, ǹmɔ ye tɔ̃ sõ̀ wɛ syi yĩ̂nyõ tõ̀npɩ tɛ̃ntõ̀lɛ Syinayi yɔ̃lɩ yõ, à pɔ yo á náh tãn tyɩ́. Sɛ̃́ ye à wɛ syi min wɛlɔlɛ Liyel tyɩ́, à yo á tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Ǹtɛ á náh tãn náh fɛ̃ syi sah ǹ tyɩ́ yõ. Pè à yahle, tɛ́ sõ̀ mɛ n sõ nɛ, pé pé syɩ yuku Yesyipti sɔkɔ, ");
INSERT INTO wib_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","tɛ́ mɛ yo Arõ tyɩ́ nɛ: ‹Moyisi nɛ̂-á tɛ̃ wil ápilɛ Yesyipti sɔkɔ, á náh tɔ̃ mɛ pɩ̃, kénɛ Moyisi tyɩ́-á mɛ pɩ sɔ̃́ dɛ́! Képah ye, yî yísyɔ́ pɩ á kɔ̃ líyelnɔ́lɛ, sè á yahlɛ n tɛ̃.› ");
INSERT INTO wib_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Kénɛ sèpĩ̀n sɔkɔ, pè mɛ tõ̀ yɔ́ mɔ náhpír kètɔ̀lɛ, tɛ́ sárká wilki ké yõ, à nɩ̀vɩ̀nɩ̀ syáh syah, à pé gbɛ̃̀npɩnɩ gbilki. ");
INSERT INTO wib_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Képah tɛ̃̀ sɔkɔ, Liyel ǹ náh vi pè kɔ̃, tɛ́ pè fĩn mɔ sah ńwɔ̃́ kèpye gbílkínɔ́ sɔkɔ, sɔ̃́-á Liyel ǹ tɛ̃ntõ̀ syínyopu kɔ̃ pè kè wãrkɩ sah pé sɛ́bɛ́y sɔkɔ nɛ ńkɛ̃́: ‹Yisrayel tãn, yáh yípɛ̂y nónó ko sárkálɛ pópó ye tikininí gbɛ̃́nnɩ sɔkɔ, yé se mɛ n sõ nɛ, ńmɔ tyɩ́-á yé ko sélɛ? ");
INSERT INTO wib_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ɔ̃́ɔ̃ dɛ́! Yé tõ̀ nɛ̂ yĩn-á Molɔkɩlɛ, képah yèpir ye yé twah, à tahlɩ yé ńwɔ̃́ kèpil tõ̀ tyɩ́ tyɩ́, nɛ̂-á yé n ye Wrefannɛ. Kénɛ tã̀n ye yé pɩ sah yé gblɔ̌y tyɩ́, tɛ́ sélɛ n gbilki. Képah ye, mé kɩ yé tɛ̃ sɔkɔ, fɔ́ɔ́ Babilɔnɩ kwil náhlɛ.›» ");
INSERT INTO wib_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Képah yóntɛnɔ náh, Yetyɛ̃nɩ tɔ̃ yɔ̃ sɔkɔ yo pé tyɩ́ nɛ: «Á náh tãn-á sõ̀ mɛ gbɛ̃́nnɩ sɔkɔ gbĩ́ nɛ̂nɛ, yèpir yɔ́ sõ̀ mɛ pé tyɩ́, nɛ̂-á n wɛ̃kɩ nɛ, Liyel-á mɛ pélɛ. Liyel sõ̀ kè yah kɔ̃ Moyisi tyɩ́ nɛ, à yèpir mɛ̀ pɩ sɔ̃́-á pé à wɛ̃kɩ ké pɩ́nɔ́lɛ gbrámgbrám. ");
INSERT INTO wib_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Képah náh, á náh tãn pɔ yèpir mɛ̀nɛ pé wɛ̃́npì kɔ̃. Nsyosye ye sõ̀ pɩ pé yah tɛ̃́-òlɛ, pè yuku kénɛ yèpirlɛ à kyɩ nɛ́káhbɩ́ gbɛ̃̀nyahnɔ́ syi, Liyel-á nónó yĩni yal. Képah sɔkɔ, yèpir mɛ̀ mɛ tɛ̃ nɛ́npɔ́, pópó à pɔ syɩ yõ̀tɛ̃̀ dĩ́ Davidi gbĩ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Tɛ́ Davidi tyɩ́ sõ̀ kah nɔ Liyel tyɩ́. Képah sɔkɔ, ǹ tɔ mó Liyel ni nɛ, à yɛ pé wɔ̀kɔ̀ yɔ́ mɔ à kɔ̃, ǹmɔ nɛ̂-á Nsyakɔbɩ Liyellɛ. ");
INSERT INTO wib_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Tɛ́ ǹ pídĩ́ Salomo ye pɔ pɩ kénɛ wɔ̀kɔ̀ mɔ́-òlɛ Liyel tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ǹtɛ Yõ̀tah Liyel náh mó tɔ̃ n tɛ̃ névi gbõ̀ wɔ̀kɔ̀nmɔnɩ sɔkɔ, sɔ̃́-á Liyel tɛ̃ntõ̀ syínyo-ò yo kélɛ nɛ, ");
INSERT INTO wib_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Tɛ̃̀ ǹgbɛ̃-á nɛ ńkɛ̃́: ‹Yĩ̂nyõ ye pɩ ń tɔ̃́rɩ́ kǒlɛ, sétáh mɛ pɩ kòpírlɛ, ń gbáhkɩ̀ súnsàh-ǹsahlɛ. Tɛ́ wɔ̀kɔ̀ nɛ̂ dùkù mɛ yé kɩ fɛ̃ mɔ ńmɔ kɔ̃ wɛ́? Ńmɔ se kɩ fɛ̃ tɛ̃ yépi wɔ̀kɔ̀nmɔnɩ sɔkɔ? ");
INSERT INTO wib_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ńmɔ gbɛ̃̀npɩnɔ náh yíyìn póllɛ di?›» ");
INSERT INTO wib_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Képah náh, Yetyɛ̃nɩ tɔ̃ yo tukey tùkèpu tyɩ́ nɛ: «Nikisekɔ́kɔ́ névye nɔ́pi, yé yé nnɔ ànɛ̂ yé ní tah tũ, à yahle Liyel wɛy nóhnɔ́lɛ, tɛ́ mɛ Liyel Mirki yahle pɔ kwɛy nɔ. Yé mɛ yé náh tãn tyɩ́ kɔ̃lɛ. ");
INSERT INTO wib_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Liyel tɛ̃ntõ̀ syínyo-ò yɔ́ ńtɛ̃ se mɛ, nɛ̂-á yé náh tãn náh à fõh yah? Nɛ́gbɩ́ nɛ̂-á Liyel tyɩ́, nónó-á ǹ pɔ́nɔ́ tyɩ́ yo sah kèkõyṍ, pè náh pépi tɔ ko mɔ di? Ǹtɛ núkúnúkú, kénɛ nɛ́gbɩ́ náh yépi vi ǹ náh, tɛ́ à ko mɔ di? ");
INSERT INTO wib_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Yĩ̂nyõ tõ̀npɩbɩ ye Liyel tõ, pè pɔ Liyel tyi kõ̀nsàhnɔ́ yo yé tyɩ́. Tɛ́ yé yahle kɔ́lɔ́lɛ sé wã̀l yõ.» ");
INSERT INTO wib_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Yetyɛ̃nɩ-á wɛlɔ nɔ́pi yo sɛ̃́, kè tukey tùkèpu kah yɔ kah mɔ, fɔ́ɔ́ pè pé ynínɛ n tah yrɔ tɛ̃̀ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ǹtɛ Liyel Mirki tɛ̃̀-á mɛ Yetyɛ̃nɩ tɔkɔ sɛ̃́, à tyah yĩ̂nyõlɛ n yah díkídíkí, tɛ́ Liyel tɔ̃́rɩ́ wɛ ànɛ̂ Yesulɛ yúkúnyĩnntɛ̃̀nɔ́lɛ Liyel gbõ̀yõ̀ sõ̀lɛ. ");
INSERT INTO wib_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Képah tɛ̃̀ sɔkɔ, à nɛ: «Yé yah, mé mɛ yĩ̂nyõlɛ n yah yɩ́kɩ́nmɔnɔlɛ, tɛ́ Névi Pídĩ́ mɛ yúkúnyĩnnɔlɛ Liyel gbõ̀yõ̀ sõ̀lɛ.» ");
INSERT INTO wib_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Névye-á képah noh sɛ̃́, pè gbo mɔ wòhòh, tɛ́ pé ní sni tũ, tɛ́ to tuke pé póllɛ ǹ yõ. ");
INSERT INTO wib_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Tɛ́ à yɔrɩ wil kwil náhlɛ. Képah sɔkɔ, nónó-á sõ̀ pè ye pɔ pɩ tàrfyɔ̀lɛ, pépi mɛ pé fwɔ̀mɔ̀-ǹgbnɔ dɛ sah kètɛ̃̀npìkì yɔ́ tyɩ́, nɛ̂-á pè n ye Solelɛ. Tɛ́ pè tyah Yetyɛ̃nɩnɛ n minki dyêhlɛ, ǹ ku ku tɛ̃̀ yõ. ");
INSERT INTO wib_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ǹtɛ pǎh mɛ Yetyɛ̃nɩ mínkínɔ́ sɔkɔ dyêhlɛ sɛ̃́, à sõ̀ mɛ nírílɛ n pɩ nɛ ńkɛ̃́: «Tɛ̃̀ ǹgbɛ̃ Yesu, ń min yohnɩ n syi.» ");
INSERT INTO wib_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Tɛ́ mɛ ǹ gbètukunɔ di, à yo yĩ́npɔ̃́ ǹgbɛ̃nɛ nɛ: «Tɛ̃̀ ǹgbɛ̃, káh pé tyípékè mɛ̀ mɔ n kõ.» Képah yóntɛnɔ ǹsɔ̃̀, à ku. ");
INSERT INTO wib_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Tɛ́ pǎh à ko mɔ sɛ̃́, képah nɔ Sole tyɩ́. Képah sɔkɔ, Yesu yõ sɛ̃́pú tĩ̀nkì kàhnfõhnɔ núkú tyah Yerusalɛmɩ sɔkɔ lésõlɛ. Kǎh pɩ sɛ̃́, à wil Yesu tɛ̃ntõ̀ névye tyɩ́ sɔkɔ, Yesu yõ sɛ̃́pú tɛ́lɔ́ pól to karkɩ de kwlo sɔkɔ, nónó-á mɛ Nsyude gbɛ̃̀nyah ànɛ̂ Samari gbɛ̃̀nyah sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ǹtɛ névye nónó-á sõ̀ mɛ Liyel wɛ̃̀kɩ̀ tɛ̃́nɔ́ plɛ, pé yísyɔ́ mɛ Yetyɛ̃nɩ lékó tɔkɔ yɩ̃, tɛ́ ǹ kũ pɔ̀ kah gbo. ");
INSERT INTO wib_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ǹtɛ Sole tɛ̃̀ wɔ sõ̀ mɛ n yah n kɔ̃ Yesu yõ sɛ̃́pú tĩ̀nkì duku tó-ńsahlɛ pnɛ́pnɛ́. À sõ̀ mɛ n de n kɔ̃ gbên sɔkɔ, à Yesu yõ sɛ̃́pú díbí ànɛ̂ syɔ́lɛ n tɛ̃ n yɔrɩ n wilki n dah n mɔ n pɔ wɔ̀kɔ̀npèkè sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Képah sɔkɔ, Yesu yõ sɛ̃́pú nónó-á sõ̀ karkɩ kɔ̃, pépi mó mɛ Nɩ̀vɩ̀nɩ̀ tirlɛ n yo n kɔ̃ tã̀ntã̀n pól sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Tɛ́ pé sɔkɔ nɛy nɛ̂-á pè n ye Filipilɛ, ǹmɔ mɛ kyɩ kwil yɔ́, Samari gbɛ̃̀nyah sɔkɔ, à kyɩ tyah Krista tyɩ́lɛ n yo nɛ́npɔ́. ");
INSERT INTO wib_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","7","Képah tɛ̃̀nɛ, sétã̀n kwĩnki nónó-á sõ̀ mɛ déntɛ̃̀nɔ́lɛ névye sɔkɔ mɛ pélɛ n kwlɔ, sè sõ̀ mɛ n kah n de n syi, tɛ́ n wil pé sɔkɔ, tɛ́ wil kúnɔ́ névye ànɛ̂ gbáhkɩ̀ núkú névye náhnáh tɔ sõ̀ mɛ dɛ́nmɔnɔlɛ n wɛ. Képah sɔkɔ, tɔ́wû-á Filipi gbǐl pɩ́nɔ́ tyɩ́ yónɔ́ noh, tɛ́ kyɩ sè wɛ sɛ̃́, pé pól pé sõnɔ pɩ núkúlɛ, à ǹ wɛlɔlɛ n tɔ̃ n sah n nohnɩ. ");
INSERT INTO wib_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Kǎh pɩ sɛ̃́, nɩ̀vɩ̀nɩ̀ ǹgbɛ̃ wɛ kénɛ kwil. ");
INSERT INTO wib_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Tɛ́ légbĩ́nɛ, dĩ́ yɔ́ lésõ mɛ pè n ye Simolɛ. À sõ̀ mɛ tɛ̃̀nɔ́lɛ kénɛ kwil mɛ̀ ó sɔkɔ di mónɔ́lɛ. Ǹmɔ sõ̀ mɛ snɛ̀y tyilɛ n pɩ, nónó-á mɛ Samari gbɛ̃̀nyah tãn gbã̀n du kègbɩlɛ, tɛ́ mɛ ǹ gblɔ̌y pɩ nɛ́-ǹgbɛ̃nɛ. ");
INSERT INTO wib_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","No pól sõ̀ mɛ mɔ ǹnɛ, à tɔkɔ wɛ̃́npì tyɩ́, à kyɩ sah yèwàhnɩ̀ tyɩ́. Tɛ́ mɛ yo tũ nɛ ńkɛ̃́, Liyel tɛ̃́nwɛnɔ nɛ̂-á pè n ye Ǹgbɛ̃nɛ, képah-á dĩ́ mɛ̀nɛ. ");
INSERT INTO wib_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Tɛ́ dĩ́ mɛ̀ sõ̀ mɛ gbɛ̃̀ndùnìnɛ n pɩ pé tyɩ́ ǹ snɛ̀y sɔkɔ di mónɔ́lɛ, képah ye pè kɔ̃ pè mɔ ǹnɛ. ");
INSERT INTO wib_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ǹtɛ Filipi-á pɔ Liyel tɔ̃́rɩ́ Nɩ̀vɩ̀nɩ̀ tir ànɛ̂ Yesu Krista tyɩ́ yo pé tyɩ́ sɛ̃́, pè sɛ̃ ké yõ. Tɛ́ díbí ànɛ̂ syɔ́ mɛ à kɔ̃ à pè wel wilki ni sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Képah sɔkɔ, Simo ńtɛ̃ tɔ sɛ̃ Yesu yõ, tɛ́ Filipi kɔ̃ à à wel wilki ni sɔkɔ. À náh tɔ̃ sõ̀ mɛ ké tyɩ́ nɛ pé yal Filipi tnɔ̂. Tɛ́ gbǐl tyi ǹgbnɔ nónó-á sõ̀ mɛ n pɩ à n yah, sè sõ̀ mɛ pɩ gbɛ̃̀ndùnìnɛ ǹ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Képah tɛ̃̀nɛ, Yesu tɛ̃ntõ̀ névye-á tɛ̃ Yerusalɛmɩ kwil, tɛ́ noh nɛ Samari gbɛ̃̀nyah tãn-á Liyel wɛy fɛ̃ syi sɛ̃́, pè Pyɛrɩ ànɛ̂ Nsyɔ̃ tɛkɩ mɔ pè kɔ̃. ");
INSERT INTO wib_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","16","Pǎh kyɩ de Samari sɔkɔ, tɛ́ Yesu yõ sɛ̃́pú nónó wɛ nɛ́npɔ́, Liyel Mirki náh tɔ̃̌nɩ̀ sõ̀ mɛ tiki pé sɔkɔ yɔ́ ńtɛ̃ yõ. Pè sõ̀ mɛ wèlnwìlkìnɔ́ wɛ ni sɔkɔ Tɛ̃̀ ǹgbɛ̃ Yesu wɔ yĩn yõ. Kǎh pɩ sɛ̃́, Pyɛrɩ ànɛ̂ Nsyɔ̃ mɛ tyah nírílɛ n pɩ pé tyɩ́, nɛ pè Liyel Mirki wɛ. ");
INSERT INTO wib_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Pè sõ̀ mɛ pé gbã̀n sah no nɔ́pi yõ à nírílɛ n pɩ pé tyɩ́. Képah sɔkɔ, pè mɛ Liyel Mirki wɛ. ");
INSERT INTO wib_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Képah tɛ̃̀nɛ, Simo-á kè wɛ Yesu tɛ̃ntõ̀ névye pé gbã̀nnɛ n sah pé yõ, pè kɔ̃ pè Liyel Mirkilɛ n wɛ sɛ̃́, à pɔ pɔ́lɛ Pyɛrɩpi tyɩ́, ");
INSERT INTO wib_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","tɛ́ nɛ, pè péwɔ tɔ kɔ̃ kénɛ tǎhkɩ̀lɛ. Képah sɔkɔ, pâh fyɔ̀ pé gbã̀n sah nɛ̂ yõ, tɛ̃̀ Liyel Mirki wɛ. ");
INSERT INTO wib_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Wǎh yo sɛ̃́, Pyɛrɩ mɛ à syah nɛ, ǹ tyɩ́ yɩkɩ n to ànɛ̂ ǹ pɔ́ tɔlɛ, wǎh sɔ̃́npɩ́lɛ n sõ nɛ, páh kɩ fɛ̃ Liyel yɩ̃́nkɔ̃nɔ kwâh dwe pɔ́lɛ. ");
INSERT INTO wib_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ǹ nɩ-á mɛ kétúkùyɔ̂ Liyel yah. Képah-á, wɛ wɛ tɛ̃̀ náh mɛ ǹ tyɩ́ yĩ mɛ̀ sɔkɔ. À náh yɩ̃nɛ kélɛ póllɛ. ");
INSERT INTO wib_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","23","Páh kè wɛ nɛ, dyɔ́yɔ́kɩ̀ képékè-á yuku sah ǹ nɩlɛ, ànɛ̂ wǎh mɛ tyípékè yɔ̃rɩ sɔkɔ. Képah-á, à ǹ nɩ vi mɔ, à mó Tɛ̃̀ ǹgbɛ̃ Liyel ni à kɔ̃ à ǹ fɔ́kɔ́sõnɔ pèkè mɛ̀ yɔ̃ mɔ à kɔ̃, kàh kɩ fɛ̃ n pɩ n pi. ");
INSERT INTO wib_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Képah sɔkɔ, Simo mɛ yo Pyɛrɩ ànɛ̂ Nsyɔ̃ tyɩ́ nɛ, pépi Tɛ̃̀ ǹgbɛ̃ Liyel ni pé tyɩ́ pé gblɔ̌y. Kàh kɩ pɩ sɛ̃́, tyi nónó-á pè yo pé tyɩ́, sé sɔkɔ yɔ́ ńtɛ̃ náh pé nɔ n pi. ");
INSERT INTO wib_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Képah náh, Pyɛrɩ ànɛ̂ Nsyɔ̃-á tyi nónó pɩ̃ Yesu tyɩ́ sɔkɔ, pǎh sè yãh tɛ névye tyɩ́, tɛ́ Tɛ̃̀ ǹgbɛ̃ wɛy yo tɛ pé tyɩ́ gbĩ́ nɛ̂nɛ, pè pé syɩ n yuku Yerusalɛmɩ kwil, tɛ́ mɛ Nɩ̀vɩ̀nɩ̀ tirlɛ n yo n yuku kwílpî náhnáh sɔkɔ wɛ̃̀kɩ̀ yah, nónó-á mɛ Samari gbɛ̃̀nyah. ");
INSERT INTO wib_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Sõ yɔ́lɛ, Tɛ̃̀ ǹgbɛ̃ yĩ̂nyõ tõ̀npɩ yɔ́ pɔ yo Filipi tyɩ́ nɛ ńkɛ̃́, à ǹ gblɔ̌y vi, à mó ǹ yah mɔ gbĩ̀ngboke gbõ̀yõ̀ sõ̀lɛ, à wɛ̃̀kɩ̀ tɛ̃, nɛ̂-á wil Yerusalɛmɩ, à n tiki n yuku Kasa kwil. Kénɛ wɛ̃̀kɩ̀ mɛ̀ yõ kɔ́pú náh mɛ fwɔ́ɔ. ");
INSERT INTO wib_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Képah sɔkɔ, Filipi núkú yuku kénɛ wɛ̃̀kɩ̀ tɛ̃. Wǎh n yuku, dǒ, à Yetyopi gbɛ̃̀nyah nɛ́-ǹgbɛ̃ yɔ́ wɛ. Ǹmɔ ye sõ̀ Yetyopi yõ̀tɛ̃̀ pi Kãndasɩ tɔkɔ sah ǹ tahrɩ yõ̀tɛ̃̀nɛ. À sõ̀ kyɩ Liyel ni Yerusalɛmɩ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Tɛ́ wǎh ǹ syɩ n yuku ǹ tĩ̀nnɛ, à sõ̀ mɛ kɔ̃́ntɛ̃̀nɔ́lɛ ǹ wòtoro sɔkɔ, mɛ Liyel tɛ̃ntõ̀ syínyo-ò Yesayi sɛ́bɛ́ynɛ n kar. ");
INSERT INTO wib_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Képah sɔkɔ, Liyel Mirki mɛ yo Filipi tyɩ́ nɛ, à kɔ n tel wòtoro mɛ̀ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filipi mɛ to tel ké tyɩ́, tɛ́ dĩ́ kàrnɔ́ noh. À sõ̀ mɛ fɩ̃́ yɔ́lɛ n kar Liyel tɛ̃ntõ̀ syínyo-ò Yesayi sɛ́bɛ́y sɔkɔ. Filipi mɛ à piki yah nɛ, fɩ̃́ nɛ̂-á à n kar yɔ̀, à se mɛ ké kɔ́rlɛ n pnɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Dĩ́ mɛ yo ǹ tyɩ́ nɛ, sɔ̃́ se pé kɩ pɩ̃ ké kɔ́rlɛ, nɛ́ nɛy náh ké yah yo pé syah nɩ? Tɛ́ mɛ kè yah kɔ̃ Filipi tyɩ́ nɛ, à pɔ n dɔkɔ n kɔ̃ n tɛ̃ pé tnɔ̂ wòtoro sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Tɛ́ fɩ̃́ nɛ̂-á sõ̀ dĩ́ mɛ n kar, kè mɛ yónɔ́lɛ nɛ́npɔ́ sɔkɔ nɛ ńkɛ̃́: «À sõ̀ pɩ képɔ́ sɔ̃́, nɛ̂-á pè tɛ̃ n yuku kò-ǹsah; képah náh pɩ, nɛ̂ yɛ̀-á pè n kõ, tɛ́ à náh ǹ vyãh fyɔ. ");
INSERT INTO wib_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Pè à yilɔ, tɛ́ lékàhlɛ à kɔ̃, tɛ́ à ko mɔ, ǹ duku to kèkõyṍ. Nɛ̂ kɩ tɔ̃ n yãh ǹ no tyɩ́lɛ?» ");
INSERT INTO wib_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Dĩ́-á kar tɛ, à mɛ yo Filipi tyɩ́ nɛ, à kékwɛ, à yo pé syah, nɛ̂ tyɩ́ se Liyel tɛ̃ntõ̀ syínyo-ò Yesayi n yo sɛ̃́ yɔ̀ nɩ? Ǹ gblɔ̌y tyɩ́ se à n yo, tĩ̂ ǹnɩ̂ tyɩ́ se à n yo? ");
INSERT INTO wib_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Képah sɔkɔ, Filipi syɔ̃ kénɛ Liyel wɛy mɛ̀ tyɩ́, à Nɩ̀vɩ̀nɩ̀ tir yo à syah Yesu tyɩ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Pǎh mɛ wɛ̃̀kɩ̀ yõ, pè kyɩ syɩ yɔ yɔ́ tyɩ́. Dĩ́ mɛ yo Filipi tyɩ́ nɛ ńkɛ̃́, yɔ-á yɔ̀, tir yɔ́ tɛ̃̀-à kɩ mɛ́-ńkɛ̃̂nɛ, páh mɛ ké tyɩ́ nɛ, à pé wel wilki ni sɔkɔ.  ");
INSERT INTO wib_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","À mɛ yo ǹ tyɩ́ nɛ, wàh kɩ mɛ sɛ̃ Yesu yõ ǹ nɩ póllɛ, páh kɩ fɛ̃ à wel wilki ni sɔkɔ. Dĩ́ mɛ yo ǹ tyɩ́ nɛ, páh sɛ̃ ké yõ nɛ, Liyel Pídĩ́-á Yesu Kristalɛ. ");
INSERT INTO wib_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Tɛ́ mɛ nɛ, pè wòtoro yĩn mɔ. Kǎh yĩn, à tiki ànɛ̂ Filipilɛ à kyɩ de yɔ, tɛ́ Filipi mɛ à wel wilki ni sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Pǎh fyɔ̀ wil yɔ sɔkɔ, Tɛ̃̀ ǹgbɛ̃ Liyel Mirki núkú Filipi tɔkɔ sɔkɔ. Yetyopi gbɛ̃̀nyah nɛ́-ǹgbɛ̃ mɛ̀ náh tɔ̃ à wɛ. Ǹtɛ à yɔ̃ sɔkɔ ǹ kɔ́lɔ́lɛ nɩ̀vɩ̀nɩ̀ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Tɛ́ Filipi tɛ̃̀ wɔ mó kyɩ ǹ gblɔ̌y wɛ Asɔtɩ kwil. À mɛ yɔ̃ sɔkɔ, à Nɩ̀vɩ̀nɩ̀ tirlɛ n yo n yuku kwlo kwlo pól sɔkɔ, wǎh n kah nónó sɔkɔ, pópó à kyɩ de Sesarɩ kwil. ");
INSERT INTO wib_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Tɛ́ légbĩ́nɛ, Sole mó sõ̀ mɛ yɔ̃ sɔkɔ dírílɛ n pɩ Tɛ̃̀ ǹgbɛ̃ Yesu tõ̀ sã́hpúlɛ, mɛ n yah n kɔ̃ pé kònmɔ-ńsahlɛ. Képah sɔkɔ, à kyɩ wil sárká syínwìlkìpu yõ̀tɛ̃̀ ǹgbɛ̃ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Tɛ́ yo ǹ tyɩ́ nɛ, à sɛ́bɛ́ynɔ́lɛ pé kɔ̃, pé kyɩ Damasɩ kwil Nsyifunɔ Liyel ní-ńtã̂n vɩ̀ yõ̀tãm kɔ̃. Képah sɔkɔ, páh kɩ kyɩ díbí ànɛ̂ syɔ́ nónó wɛ nɛ́npɔ́, tɛ́ pè mɛ Tɛ̃̀ ǹgbɛ̃ Yesu wɛ̃̀kɩ̀lɛ n kɔ, pé pè tɛ̃ n pukubi n pɔ Yerusalɛmɩ kwil. ");
INSERT INTO wib_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Wǎh sè wɛ syi, à wɛ̃̀kɩ̀ tɛ̃ n yuku Damasɩ kwil. Wǎh mɛ yúkɛy kélɛ, kyòo yɔ́ núkú wil yĩ̂nyõ à kwɛ ǹ yõ pěrr, à à mɔ gbɩ̃. ");
INSERT INTO wib_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Képah sɔkɔ, à yɔ̃ syɩkɩ sétáh, tɛ́ yĩ́npɔ̃́ yɔ́ noh, nɛ̂-á mɛ n yo ǹ tyɩ́ nɛ: «Sole, Sole, kwâh nɛ̂ pɩ tɛ́ á ńnɛ n fõh?» ");
INSERT INTO wib_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sole mɛ piki yah nɛ, nɛ̂ se ǹmɔlɛ nɩ, pé Tɛ̃̀ ǹgbɛ̃? Kénɛ yĩ́npɔ̃́ tɔ̃ yo ǹ tyɩ́ nɛ: «Yesu ye ńmɔlɛ, nɛ̂-á á n fõh. ");
INSERT INTO wib_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ǹtɛ yuku n de kwil sɔkɔ, tɛ́ wáh yɩ̃nɛ ǹ nɛ̂ pɩ, pè kɩ kè yo ǹ syah.» ");
INSERT INTO wib_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Tɛ́ Sole-á sõ̀ mɛ wɛ̃̀kɩ̀ yõ ànɛ̂ nónónɛ, pé tɔ sõ̀ mɛ yĩ́npɔ̃́ mɛ̀nɛ n nohnɩ, tɛ́ pè náh mɛ nɛy wɛ. Kǎh pɩ sɛ̃́, pé gbã̀n du, pè yĩn tɛ̃ syɩ́syɩ́, pè náh mɛ fɛ̃ tirlɛ n yo. ");
INSERT INTO wib_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Képah sɔkɔ, Sole-á yuku yĩn, à ǹ yɩ̃́ yɩkɩ mɔ, tɛ́ à náh tɔ̃ mɛ fɛ̃ n yah. Pè mɛ ǹ gbõ̀ sɔkɔ tɛ̃, à de ǹnɛ Damasɩ kwil. ");
INSERT INTO wib_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","À sèpĩ̀n tɔ̃́nɩ̀ pɩ nɛ́npɔ́ yɩ̃́tũri sɔkɔ, yõke yṍ-ńkɛ̃̂nɛ ànɛ̂ ni wɔ́-ńkɛ̃̂nɛ. ");
INSERT INTO wib_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Tɛ́ légbĩ́nɛ, Yesu tõ̀ sã́h-ò yɔ́ sõ̀ mɛ nɛ́npɔ́ pè n ye Ananiyasilɛ. Tɛ̃̀ ǹgbɛ̃ Yesu wil ǹ yah, tɛ́ nɛ: «Ananiyasi!» Ananiyasi mɛ syi, tɛ́ nɛ páh yɔ̀, Tɛ̃̀ ǹgbɛ̃! ");
INSERT INTO wib_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Tɛ̃̀ ǹgbɛ̃ mɛ yo ǹ tyɩ́ nɛ: «Yuku ǹ wɛ̃̀kɩ̀ tɛ̃, wɛ̃̀kɩ̀ nɛ̂-á pè n ye wɛ̃̀kɩ̀ Tómmnɛ. Wáh kɩ kyɩ Nsyudasɩ gbô sɔkɔ, ǹ dĩ́ yɔ́ tyɩ́ piki n yah. Kénɛ dĩ́ n wil Tarsɩ kwil, pè ǹnɛ n ye Solelɛ. À mɛ Liyel nínɔ́ sɔkɔ núkúnúkú. ");
INSERT INTO wib_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Tɛ́ ǹ nírí pɩ́nɔ́ sɔkɔ, à dĩ́ yɔ́ wɛ pè n ye Ananiyasilɛ. À mɛ de pɔ ǹ gbã̀n sah ǹ yõ nɛ, à fɛ̃ nɛ n yah ńtɔ̃.» ");
INSERT INTO wib_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Képah sɔkɔ, Ananiyasi nɛ, ṹ, Tɛ̃̀ ǹgbɛ̃, névye náhnáh-á dĩ́ mɛ̀ tyɩ́ yãh pé noh, ànɛ̂ wǎh mɛ Yesu yõ sɛ̃́púlɛ n fõh sɔ̃́ Yerusalɛmɩ kwil, páh ké tɔ noh. ");
INSERT INTO wib_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Tɛ́ wǎh tɔ̃ sɛ́bɛ́y wɛ syi sárká syínwìlkìpu yõ̀tãm tyɩ́, à pɔ ásõ̂ sɔkɔ nɛ, pé pɔ ǹmɔ yéngbopu pól tɛ̃ pukubi n sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ǹtɛ Tɛ̃̀ ǹgbɛ̃ mɛ tɔ̃ yo Ananiyasi tyɩ́ nɛ: «Ńmɔ ye yah tɔkɔ pɩ dĩ́ mɛ̀nɛ ń tõ̀npɩlɛ nɛ, à ń tyɩ́lɛ n yo n kɔ̃ névye tyɩ́, nónó náh pɩ Nsyifunɔlɛ, à tahlɩ pé yõ̀tãm tyɩ́, ànɛ̂ Yisrayel tãn tɔ tyɩ́. Képah ye, kyɩ ǹ tyɩ́! ");
INSERT INTO wib_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Wǎh kɩ kwlɔ́nɔ́ nɛ̂ pɩ n pi ńmɔ yĩnnɛ, mé kɩ kélɛ à wɛ̃kɩ ń gblɔ̌y.» ");
INSERT INTO wib_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Képah sɔkɔ, Ananiyasi yuku sɔkɔ. Wǎh kyɩ de Nsyudasɩ gbô sɔkɔ, à ǹ gbã̀n sah Sole yõ, tɛ́ yo ǹ tyɩ́ nɛ ńkɛ̃́, pé yṹnpi Sole, Tɛ̃̀ ǹgbɛ̃ Yesu nɛ̂-á wil ǹ yah wɛ̃̀kɩ̀ yõ wǎh n pi gbĩ́ nɛ̂nɛ, ǹmɔ-á tõ pélɛ ǹ tyɩ́ nɛ, á fɛ̃ nɛ n yah ńtɔ̃, ànɛ̂ Liyel Mirki mó à tɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Nɛ́npɔ́ swɔ, yî yísyɔ́ núkú wil Sole yɩ̃́ sɔkɔ à pɔ kwɛ yɛ̃́nkɔ̂ gbró sɔ̃́, tɛ́ ǹ yɩ̃́ mɛ yɩkɩ. À mɛ yuku, tɛ́ pè mɛ à wel wilki ni sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Képah náh, à yõke yõ, tɛ́ ǹ syɩ tǎhkɩ̀ wɛ. Képah sɔkɔ, Yesu tõ̀ sã́hpú nónó-á sõ̀ mɛ Damasɩ kwil, Sole tɛ̃ à sèpĩ̀n yísyɔ́ pɩ pépilɛ. ");
INSERT INTO wib_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Tɛ́ núkú tyah Yesu tyɩ́lɛ n yo n kɔ̃ Nsyifunɔ Liyel ní-ńtã̂n vɩ̀ sɔkɔ nɛ, Liyel Pídĩ́-á ǹnɛ. ");
INSERT INTO wib_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Képah tɛ̃̀nɛ, nónó pól-á sõ̀ mɛ ǹ wɛlɔlɛ n nohnɩ, kè pé gbã̀n du. Pè tyah n yo nɛ, tɛ́ ǹmɔ kó lésõ n kah n fõh Yesu yĩn yéngbopulɛ Yerusalɛmɩ sɔkɔ nɩ? Tɛ́ pé tɛ̃́npukubinsɔkɔ-ńsah ńtɛ̃-á à pɔ ásõ̂ sɔkɔ, nɛ pé kyɩ pélɛ sárká syínwìlkìpu yõ̀tãm tyɩ́ dɛ́! ");
INSERT INTO wib_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ǹtɛ wãn sõ̀ mɛ n tɔ̃ n mɔ n yuku Sole tǎhkɩ̀ yõ. À sõ̀ mɛ kélɛ n yo n wah nɛ, Yesu-á Liyel yah tɔkɔ pɩ pwáhnmɔ-òlɛ. Kǎh pɩ sɛ̃́, Damasɩ kwil Nsyifunɔ yáh-ńsah tyɛ, tyíyóné náh tɔ̃ wɛ pé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Képah sɔkɔ, sèpĩ̀n náhnáh sɔ́kɔ́ntɛnɔ náh, Nsyifunɔ pɔ yo sah núkú yõ nɛ, páh kɩ Sole ko mɔ. ");
INSERT INTO wib_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Tɛ́ Sole mɛ pɔ pé yĩ́nvǐ mɛ̀ wɛ noh. Pè sõ̀ mɛ kwil dé-ńtã̂nnɛ n syɩkɩ, ké lékã̂h ké gbĩ̀ntɔ̃̀, nɛ pé à wɛ n ko n mɔ. ");
INSERT INTO wib_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ǹtɛ sõ yɔ́ lékã̂hnɛ, ǹ tõ̀ sã́hpú sõ̀ mɛ ké tyɩ́ nɛ pé à pwah mɔ. Képah sɔkɔ, pè à dah mɔ tɔ̀kɔ̀-ǹgbɛ̃ yɔ́ sɔkɔ à tiki mɔ kɛ̃́nkahnɩnɛ, nɛ̂-á kwil kore vi. ");
INSERT INTO wib_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Képah sɔkɔ, Sole sɔkɔ Yerusalɛmɩ kwil. Wǎh kyɩ yĩni tɛ̃ nɛ́npɔ́, à sõ̀ mɛ ké tyɩ́ nɛ, pé kwrɔ mɔ Yesu tõ̀ sã́hpú sɔkɔ. Ǹtɛ pépi náh sõ̀ mɛ fɛ̃ sɛ̃ ké yõ nɛ, wǎh pɩ Yesu tõ̀ sã́h-òlɛ kègbɩsɩ tɛ̃̀ yõ; képah ye tíkí pè tɛ̃. ");
INSERT INTO wib_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ǹtɛ Barnabasɩ wɔ mɛ à tɛ̃ yuku Yesu tɛ̃ntõ̀ névye tyɩ́. Tɛ́ Sole-á sõ̀ Tɛ̃̀ ǹgbɛ̃ wɛ dùkù nɛ̂nɛ Damasɩ kwil wɛ̃̀kɩ̀ yah, ànɛ̂ Tɛ̃̀ ǹgbɛ̃-á yo mɔ ǹ tyɩ́ sɔ̃́, Barnabasɩ ké yah yo pé tyɩ́. Tɛ́ tɔ̃ kè yo pé tyɩ́, wǎh Yesu tyɩ́ yo nɩ̀sãhlɛ dùkù nɛ̂nɛ Damasɩ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","À tɔkɔ légbĩ́ tyɩ́, Sole kwrɔ mɔ pé sɔkɔ, à Liyel wɛynɛ n yah n yo n kɔ̃ nɩ̀sãhlɛ Tɛ̃̀ ǹgbɛ̃ yĩn yõ Yerusalɛmɩ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","À sõ̀ mɛ n yãh ànɛ̂ Nsyifunɔ tɔlɛ, nónó-á Krɛkɩ wɛynɛ n wɛkɩ, mɛ yékã̂blɛ n pɩ pélɛ. Ǹtɛ pépi wɔ sõ̀ mɛ ǹ kònmɔ-ńsahlɛ n yah n kɔ̃. ");
INSERT INTO wib_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Yesu yõ sɛ̃́pú-á pɔ kè noh, pè à tɛ̃ sɔkɔ Sesarɩ kwil, à kyɩ à tɛkɩ mɔ Tarsɩ kwil. ");
INSERT INTO wib_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Légbĩ́nɛ, Yesu yõ sɛ̃́pú tĩ̀nkì nónó-á sõ̀ Nsyude, ànɛ̂ Kalile, ànɛ̂ Samari gbɛ̃̀nyah pól sɔkɔ, pé pól sõ̀ mɛ yèvɩnɩ sɔkɔ. Pè sõ̀ mɛ tǎhkɩ̀lɛ n wɛ, tɛ́ mɛ n kɔ Tɛ̃̀ ǹgbɛ̃ yah tíkí pɩ́nɔ́ sɔkɔ, tɛ́ Liyel Mirki gbõ̀ yõ, wãn mɛ n mɔ n yuku pé nɛ́dán yõ. ");
INSERT INTO wib_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Tɛ́ légbĩ́nɛ, Pyɛrɩ sõ̀ mɛ tã̀ntã̀n póllɛ n kɔ n kɔ̃. Képah sɔkɔ, sõ yɔ́lɛ, à tiki yuku Lida kwil Yesu yõ sɛ̃́pú tɔ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Tɛ́ kyɩ dĩ́ yɔ́ wɛ nɛ́npɔ́ pè n ye Yenelɛ. Ńyân sõ̀ mɛ ǹ wil ko; képah ye à sõ̀ mɛ sɛ̃ tɛ̃ ǹ sɛ̃ sɛ̃ kwâh yõ pópó ye kwǎrtɔ̃nɔ. ");
INSERT INTO wib_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Képah sɔkɔ, Pyɛrɩ mɛ yo ǹ tyɩ́ nɛ: «Yene, Yesu Krista ye álɛ n dɛ n mɔ yɔ̀. Yuku, ǹ tɛ́ á sɛ̃ sɛ̃ kwâh yõ tɔ̃ n sah á gblɔ̌y.» Wǎh yo sɛ̃́, dĩ́ núkú yuku yĩn. ");
INSERT INTO wib_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Képah sɔkɔ, Lida kwil ànɛ̂ Sarõ gbɛ̃̀nyah tãn-á képah wɛ sɛ̃́, pé pól vi mɔ Tɛ̃̀ ǹgbɛ̃ Yesu tyɩ́ yõ. ");
INSERT INTO wib_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Pi yɔ́ lésõ mɛ Nsyope kwil sɔkɔ Yesu tõ̀ sã́h-òlɛ. Ǹ yĩn ye sõ̀ Tabitalɛ, pè n ye Dɔrkasɩlɛ Krɛkɩ wɛy sɔkɔ. À sõ̀ pèpɔrɩlɛ n pɩ gbĩ́mɛgbĩ́, mɛ yãm tãnnɛ n yohnɩ n mɔ. ");
INSERT INTO wib_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Tɛ́ kénɛ sèpĩ̀n sɔkɔ, yam pɔ à fɛ̃ mɔ, à ku. Pè mɛ ǹ lékó wel, tɛ́ à tɔkɔ kyɩ sah yĩ̂nyõ wɔ̀kɔ̀ yɔ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Tɛ́ kǎh pɩ Lida kwil ànɛ̂ Nsyope kwil sõ̀ mɛ yúkɛy wɛ̃nɛ sɛ̃́, Yesu tõ̀ sã́hpú nónó-á sõ̀ mɛ Nsyope sɔkɔ, pè sõ̀ noh nɛ, Pyɛrɩ-á mɛ Lida kwil. Képah sɔkɔ, pè mɛ díbí nɛ́pĩ̂ nímí tõ ǹ tyɩ́ nɛ, pè kyɩ yo ǹ tyɩ́ nɛ ńkɛ̃́, à ǹ gblɔ̌y yɛ, à mó pɔ pépi tĩ̀nnɛ súú. ");
INSERT INTO wib_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pǎh kyɩ kè yo sɛ̃́, à núkú yuku pè sɔkɔ wɛ̃ tyɩ́. Wǎh kyɩ yĩni tɛ̃, pè à tɛ̃ dɔkɔ yuku yĩ̂nyõ wɔ̀kɔ̀ sɔkɔ, tɛ́ pɛ́kúsyɔ pól sõ̀ mɛ nɔ de ǹ tnɔ̂ mɛ n gbo, tɛ́ mɛ fwɔ̀mɔ̀-ǹgbnɔ ànɛ̂ fwɔ̀mɔ̀npîlɛ ǹnɛ n wɛ̃kɩ, nónó-á Tabita tĩ gbĩ́ nɛ̂-á sõ̀ à mɛ vilɛ. ");
INSERT INTO wib_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Képah sɔkɔ, Pyɛrɩ névye pól kɔ̃ pè wil kégbɔ́, tɛ́ ǹ gbètukunɔ di à Liyel ni. Tɛ́ mɛ ǹ yah vi pi lékó tĩ̀nnɛ tɛ́ nɛ: «Tabita, yuku.» Pi núkú ǹ yɩ̃́ yɩkɩ mɔ. Tɛ́ wǎh Pyɛrɩ wɛ, à yuku kɔ̃ tɛ̃. ");
INSERT INTO wib_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pyɛrɩ mɛ ǹ gbõ̀ sɔkɔ tɛ̃, à à yilki sah. Képah náh, à Yesu yõ sɛ̃́pú ànɛ̂ pɛ́kúsyɔ ye pɔ ǹnɛ pè wɛ̃kɩ vilɛ. ");
INSERT INTO wib_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Kǎh pɩ sɛ̃́, yĩ mɛ̀ tɔ̃ mɔ Nsyope kwil ywɔ̃ ywɔ̃ pól sɔkɔ, ànɛ̂ pé náhnáh pɩ Tɛ̃̀ ǹgbɛ̃ Yesu yõ sɛ̃́púlɛ. ");
INSERT INTO wib_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Képah náh, Pyɛrɩ tɛ̃ mo kwéy Nsyope sɔkɔ sénpɩ dĩ́ yɔ́ tyɩ́, nɛ̂ yĩn-á Simolɛ. ");
INSERT INTO wib_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Dĩ́ yɔ́ lésõ mɛ Sesarɩ kwil pè n ye Kɔrnɛylɛ. Sràsyíbí yõ̀tɛ̃̀ yɔ́ ye sõ̀ ǹnɛ, Wrome tãn sràsyíbí tĩ̀nkì sɔkɔ, nɛ̂-á pè n ye Yitalɩ gbɛ̃̀nyah sràsyíbí tĩ̀nkìlɛ. ");
INSERT INTO wib_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","À sõ̀ mɛ Liyel wɛ̃̀kɩ̀ tɛ̃́nɔ́ plɛ, mɛ ǹ yah tíkílɛ n pɩ, tɛ́ ǹmɔ ànɛ̂ ǹ gbô tãn pól mɛ ǹnɛ n ni. À sõ̀ mɛ Nsyifunɔ yãm tãnnɛ n yohnɩ n mɔ náhnáh, tɛ́ mɛ Liyellɛ n ni gbĩ́mɛgbĩ́. ");
INSERT INTO wib_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Képah sɔkɔ, sõ yɔ́ gbèkãm gbĩ́ kénkɔ̃ sɔkɔ, à wɛ̃́kɩ́nɔ́ yɔ́ wɛ. À Liyel yĩ̂nyõ tõ̀npɩ yɔ́ wɛ pnɛ́yy à de pɔ ǹ tĩ̀nnɛ, à pɔ à ye ǹ yĩnnɛ nɛ: «Kɔrnɛy!» ");
INSERT INTO wib_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ǹtɛ Kɔrnɛy sõ̀ mɛ yĩ̂nyõ tõ̀npɩlɛ n yah díkídíkí tíkítìkì sɔkɔ, tɛ́ à piki yah nɛ, kwâh nɛ̂ se nɩ, pé yõ̀tɛ̃̀? Yĩ̂nyõ tõ̀npɩ mɛ yo ǹ tyɩ́ nɛ: «Wáh nírí nónónɛ n pɩ, ànɛ̂ wáh yòhnɩ̀nmɔnɔ nónónɛ n pɩ yãm tãn tyɩ́, Liyel yĩ́ mɛ sé yõ. Ǹ dyɔ mɛ n kwnɛ á tyɩ́lɛ. ");
INSERT INTO wib_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Núkúnúkú tɛ̃̀nɛ, nósyɔ́ wilki n tɛkɩ n mɔ Nsyope kwil, pè kyɩ Simo yɔ́ tɛ̃ n pɔ, nɛ̂-á pè n ye Pyɛrɩlɛ. ");
INSERT INTO wib_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","À mɛ twáhntɛ̃̀nɔ́lɛ sénpɩ dĩ́ yɔ́ tyɩ́, nɛ̂ tɔ yĩn-á Simolɛ. Ǹ gbô mɛ pnɛ yɔ gbɔ̀pɔ.» ");
INSERT INTO wib_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Képah sɔkɔ, yĩ̂nyõ tõ̀npɩ-á wɛlɔ nɔ́pi yo tɛ Kɔrnɛy tyɩ́, tɛ́ yal ǹ tnɔ̂, Kɔrnɛy núkú ǹ tõ̀npɩbɩ díbí nɛ́pĩ̂ nímí ye ànɛ̂ sràsyí yɔ́lɛ, nɛ̂-á sõ̀ mɛ tɛ̃̀nɔ́lɛ ǹ tnɔ̂ di mónɔ́lɛ, tɛ́ mɛ Liyel wɛ̃̀kɩ̀ tɛ̃́nɔ́ plɛ. ");
INSERT INTO wib_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Tɛ́ mɛ tyi nɔ́pi pól yãh pé tyɩ́, tɛ́ pè tɛkɩ mɔ Nsyope kwil. ");
INSERT INTO wib_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ké dĩndallɛ, pè sõ̀ mɛ wɛ̃̀kɩ̀ yõ sɛ̃́, tɛ́ pǎh pópó n de Nsyope kwil sɔkɔ gbĩ́ nɛ̂nɛ, gbĩ sõ̀ mɛ yõ̀tah sírr kénkɔ̃ sɔkɔ, tɛ́ Pyɛrɩ mɛ dɔkɔ gbɛ̃́ntĩ̂n yõ, mɛ nírílɛ n pɩ. ");
INSERT INTO wib_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Képah sɔkɔ, kwɛkɩ pɔ à tɛ̃; à sõ̀ mɛ ké tyɩ́ nɛ, pé yõke yõ. Tɛ́ pǎh mɛ yõkelɛ n pɩ ǹ tyɩ́ gbĩ́ nɛ̂nɛ, Liyel wɛ̃́kɩ́nɔ́ yɔ́lɛ à wɛ̃kɩ. ");
INSERT INTO wib_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","À yĩ̂nyõ wɛ yɩ́kɩ́nmɔnɔlɛ, tɛ́ kwâh yɔ́ mɛ wil ké sɔkɔ, fwɔ̀pĩ̀n-ǹgbɛ̃ yɔ́ sɔ̃́, ké vyɛ̃ynɔ ńyã́hlɛ tɛ̃́nɔ́lɛ, tɛ́ mɛ n tiki n pi sétáh. ");
INSERT INTO wib_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Tɛ́ gbyẽ̂h ǹyẽ̂h yî duke pól sõ̀ mɛ ké sɔkɔ, ànɛ̂ yî nónó-à n til, à tahlɩ kèpye duke pól tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Képah sɔkɔ, Pyɛrɩ yĩ́npɔ̃́ yɔ́ noh kè mɛ n yo ǹ tyɩ́ nɛ: «Pyɛrɩ, yuku n ko sé sɔkɔ ǹ kɔ.» ");
INSERT INTO wib_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ǹtɛ Pyɛrɩ mɛ Tɛ̃̀ ǹgbɛ̃ syah nɛ, páh pɩ sɔ̃́ pilɛ, pé náh dêl kwâh yɔ́ ńtɛ̃ yõ yah, képah náh pɩ, kwâh yɔ́ ńtɛ̃nɛ, nɛ̂-á névilɛ n silki Liyel yah. Képah-á, pé náh kè pɩ n pi póllɛ. ");
INSERT INTO wib_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Képah tɛ̃̀nɛ, yĩ́npɔ̃́ mɛ̀ tɔ̃ ké syɩ yo à noh kɛ ní-òlɛ nɛ ńkɛ̃́: «Liyel-á kwâh nɛ̂ wɛ̃kɩ kwáhpépɛ̌ynɛ, áwɔ tyɩ́ náh ké wɛ̃́kɩ́nɔ́lɛ nɛ, kǎh mɛ névilɛ n silki Liyel yah.» ");
INSERT INTO wib_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Képah tɛ̃̀ pɩ sɛ̃́ kɛ tɔ̃́nɔ́, tɛ́ Liyel núkú kénɛ kwâh yɔ̃ dɔkɔ sɔkɔ yĩ̂nyõ. ");
INSERT INTO wib_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Kǎh pɩ sɛ̃́, Pyɛrɩ lékã́m sõ̀ mɛ fɛ̃kɩ, à mɛ ǹ gblɔ̌ynɛ n piki n yah wɛ̃́kɩ́nɔ́ nɛ̂-á à wɛ, ké yõ-á kɩ fɛ̃ n pɩ n pi tir nɛ̂nɛ. À mɛ képah sɔkɔ, tɛ́ Kɔrnɛy tɛ̃ntõ̀ névye mó mɛ sénpɩ dĩ́ Simo gbô tyɩ́ piki yah kɔ̃ pɔ wɛ, mɛ yĩn tɛ̃ ké yah, ");
INSERT INTO wib_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","tɛ́ mɛ n piki n yah nɛ, Simo nɛ̂-á pè n ye Pyɛrɩlɛ, à se mɛ twáhntɛ̃̀nɔ́lɛ ásõ̂ sɔkɔ nɩ? ");
INSERT INTO wib_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Ǹtɛ Pyɛrɩ-á sõ̀ mɛ yɔ̃ sɔkɔ ǹ fɔkɔlɛ n sõ wɛ̃́kɩ́nɔ́ mɛ̀ tyɩ́ sɔkɔ sɛ̃́, Liyel Mirki mɛ yo ǹ tyɩ́ nɛ à yah, díbí nɛ́pĩ̂ tɔ̃́mɩ́-á mɛ ǹnɛ n yah n kɔ̃. ");
INSERT INTO wib_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Péwɔ-á tɛkɩ mɔ pélɛ ǹ tyɩ́. Képah-á, à yuku n tiki n sɔkɔ pélɛ, à káh tɔ̀tɔ̀ pɩ. ");
INSERT INTO wib_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Képah sɔkɔ, Pyɛrɩ tiki kyɩ no nɔ́pi tnɔ̂, tɛ́ yo pé tyɩ́ nɛ, nɛ̂-á pè n yah n kɔ̃, ǹmɔ-á péwɔlɛ. Ńkɛ̃́, pè kèyǎh kɔ̃. ");
INSERT INTO wib_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Pè mɛ yo ǹ tyɩ́ nɛ, sràsyíbí yõ̀tɛ̃̀ dĩ́ Kɔrnɛy-á tõ pélɛ ǹ tyɩ́. Nɛ́gbɩ́-á ǹnɛ, wǎh Liyel yah tíkílɛ n pɩ, ànɛ̂ Nsyifunɔ pól-á ǹ yĩ́ngbɩ́lɛ n yo. Yĩ̂nyõ tõ̀npɩ yɔ́-á kélɛ à wɛ̃kɩ nɛ, wǎh yɩ̃nɛ à pɔ ǹ tɛ̃ n kyɩ ǹ gbô sɔkɔ, tyi nónó-á mɛ á tyɩ́ yo yo tɛ̃̀nɛ, á sè yo à syah. ");
INSERT INTO wib_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Képah sɔkɔ, Pyɛrɩ mɛ pé kɔ̃ pè de gbô sɔkɔ, à twah ǹ tyɩ́ à lékã̂h pɩ. Tɛ́ ké dĩndallɛ, à mɛ pé sõ̀ tɛ̃ sɔkɔ. Tɛ́ Yesu yõ sɛ̃́pú yísyɔ́ tɔ sõ̀ sɔkɔ pélɛ, nónó-á n wil Nsyope kwil. ");
INSERT INTO wib_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Pé sɔkɔ sõ dĩndallɛ, pè kyɩ de Sesarɩ kwil; tɛ́ kyɩ nɛ yah Kɔrnɛy mɛ ǹ gbô tãn ànɛ̂ ǹ kódíbí kègblɔ ye tuke, mɛ pɔ pè syɩkɩ tɛ̃. ");
INSERT INTO wib_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pyɛrɩ-á pɔ n de gbĩ́ nɛ̂nɛ, Kɔrnɛy kyɩ à yohnɩ, tɛ́ kɔ kwĩnki ǹ yah, à à gbilki. ");
INSERT INTO wib_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ǹtɛ Pyɛrɩ mɛ yo ǹ tyɩ́ nɛ à yuku, tɛ́ à yilki sah, tɛ́ nɛ névi ó-á péwɔ tɔlɛ dò. ");
INSERT INTO wib_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Pè mɛ képah yónɔ́ sɔkɔ wɛ̃ tyɩ́, tɛ́ de yuku gbô à kyɩ no nɔ́pi wɛ tùkèntɛ̃̀nɔ́lɛ pípí. ");
INSERT INTO wib_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Pyɛrɩ mɛ pè syah nɛ, pǎh pɩ̃ nɛ, dêl-á kélɛ Nsyifunɔ tyɩ́, pè náh n pɩ n soh wɛ̃ tyɩ́ kwlókáhkɩ́ névyelɛ, ànɛ̂ pè náh n de pé gbên sɔkɔ kɛ̀. Ǹtɛ Liyel-á kélɛ péwɔ tɛ̃̀ wɛ̃kɩ nɛ, pé náh yɩ̃nɛ pé ǹnɩ̂ yɔ́ ńtɛ̃nɛ n yah nɛ, wǎh mɛ sìlkìnɔ́lɛ Liyel yah, képah náh pɩ, nɛ à náh yɩ̃nɛ pɩ́nsòhnɔ́lɛ névye tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Képah-á, pé kɔ̃ pǎh pé ye pé pɔ yékã̂b pɩ́-ńkɛ̃̂nɛ. Ńkɛ̃́, pè se kɩ fɛ̃ pé yénɔ́ yõ yo pé syah nɩ? ");
INSERT INTO wib_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Képah sɔkɔ, Kɔrnɛy mɛ yo ǹ tyɩ́ nɛ, ké sèpĩ̀n ǹyẽ̂h-á yɔ̀, gbèkãm gbĩ́ mɛ̀ ó kénkɔ̃ sɔkɔ, páh lésõ mɛ nírílɛ n pɩ pé wɔ̀kɔ̀ sɔkɔ. Tɛ́ dǒ, pé núkú dĩ́ yɔ́ wɛ yĩ́nntɛ̃̀nɔ́lɛ pé yah tĩ̀nnɛ, wil flɔlɛ pěrr ǹ tyɩ́, ");
INSERT INTO wib_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","tɛ́ mɛ pé ye pé yĩnnɛ nɛ, Kɔrnɛy, Liyel-á pé nírí tɛ̃; ǹ dyɔ-á mɛ n kwnɛ pé pèpɔrɩ pɩ́nɔ́ tyɩ́lɛ. ");
INSERT INTO wib_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Képah-á, pé névye wilki n tɛkɩ n mɔ Nsyope kwil, pè kyɩ Simo ye n pɔ ásõ̂, nɛ̂-á pè n ye Pyɛrɩlɛ. Wâh mɛ twáhntɛ̃̀nɔ́lɛ sénpɩ dĩ́ Simo gbô sɔkɔ, pnɛ yɔ gbɔ̀pɔ. ");
INSERT INTO wib_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Kǎh pɩ sɛ̃́, pé núkú névye tɛkɩ mɔ ǹ tyɩ́ nɛ, pè kyɩ à ye n pɔ. Ǹ tɔ mó tɔ̃ pɩ plɛ tɛ́ fɛ̃ syi pɔ. Núkúnúkú, pé pól-á ásõ̂ Liyel yah sɔkɔ, ǹ wɛlɔ noh yĩnnɛ, nónó pól-á Tɛ̃̀ ǹgbɛ̃ dahbɩ ǹ gbõ̀, nɛ à yo pé syah. ");
INSERT INTO wib_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Képah sɔkɔ, Pyɛrɩ mɛ wɛy tɔkɔ tɛ́ nɛ: «Núkúnúkú, mé pɩ̃ kègbɩ yõ nɛ, Liyel náh ǹnɩ̂ yɔ́ ńtɛ̃nɛ n wah. ");
INSERT INTO wib_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Névi nɛ̂-à fyɔ̀ ǹ yah tíkílɛ n pɩ, tɛ́ mɛ n kɔ gbɩ wɛ̃̀kɩ̀ yõ, tɛ̃̀-à sɔ̃́ mɛ yìkì nɛ̂ nɛynɛ, ǹ tyɩ́ n nɔ Liyel tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ǹmɔ Liyel ye ǹ wɛy tɛkɩ mɔ Yisrayel tãn tyɩ́, à Nɩ̀vɩ̀nɩ̀ tir yo pé tyɩ́ nɛ, yèvɩnɩ-á n wɛ Liyel tyɩ́ Yesu Krista gbõ̀ yõ, ǹmɔ nɛ̂-á no pól Tɛ̃̀ ǹgbɛ̃nɛ. ");
INSERT INTO wib_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Nsyɔ̃-á kwní kɔ̃ tɛ ni sɔkɔ wèlnwìlkìnɔ́ tyɩ́ sɔkɔ, képah náh, nɛ̂-á pɩ Kalile gbɛ̃̀nyah ǹgbò sɔkɔ ànɛ̂ Nsyude gbɛ̃̀nyah pól sɔkɔ, yé se mó kè pɩ̃ tɛ́! ");
INSERT INTO wib_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Tɛ́ Liyel sõ̀ mɛ Nasarɛtɩ kwil Yesulɛ. À ǹ Mirki ànɛ̂ tɛ̃́nwɛnɔlɛ à kɔ̃. Képah ye, à mɛ n kɔ n kɔ̃ tã̀ntã̀n pól sɔkɔ, à pèpɔrɩlɛ n pɩ, tɛ́ nónó pól-á sõ̀ mɛ sétã̀n yõ̀tɛ̃̀ yɔ̃rɩ sɔkɔ, à sõ̀ mɛ pélɛ n wilki ké sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Tɛ́ wǎh tyi nónó pól pɩ Yerusalɛmɩ kwil ànɛ̂ Nsyifunɔ kwlo tɛ́lɔ́ sɔkɔ, á pól ye sè wɛ yĩ́nɛ. Ǹtɛ pè mɛ à tɛ̃ syɩ dahnɩ yõ, à à ko mɔ. ");
INSERT INTO wib_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Tɛ́ ké sèpĩ̀n tɔ̃́-ò sõlɛ, Liyel mɛ ǹ lékó yilki mɔ, tɛ́ à kɔ̃ à ǹ gblɔ̌ynɛ no wɛ̃kɩ, ");
INSERT INTO wib_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","ǹtɛ à náh ǹ gblɔ̌ynɛ no pól wɛ̃kɩ. À ǹ gblɔ̌ynɛ ápi ó wɛ̃kɩ, ápi nónó-á lésõ Liyel yah tɔkɔ pɩ Yesu lékó yílkínmɔnɔ wɛ́pú ànɛ̂ sé yã́hpúlɛ. Ápi lésõ yõke yõ, tɛ́ wɔ wɔ kwâh wɔ ǹnɛ wɛ̃ tyɩ́, ǹ lékó yílkínmɔntɛnɔ náh. ");
INSERT INTO wib_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Képah sɔkɔ, à mɛ á tõ nɛ: ‹Yé kyɩ Liyel wɛynɛ n yo n kɔ̃ no tyɩ́. Yé kélɛ pè wɛ̃kɩ nɛ, ńmɔ-á Liyel sah vye ànɛ̂ lékyɩ̂ tùkè-òlɛ.› ");
INSERT INTO wib_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ǹmɔ Yesu tyɩ́ ye tɔ̃ Liyel tɛ̃ntõ̀ syínyopu pól yo nɛ, névi nɛ̂-à sɛ̃ ǹmɔ yõ, tɛ̃̀ tyípêl-á kɩ yɔ̃ mɔ à kɔ̃ ǹmɔ yĩn yõ.» ");
INSERT INTO wib_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Képah sɔkɔ, Pyɛrɩ sõ̀ mɛ wɛ́kɩ́nɔ́ sɔkɔ sɛ̃́, tɛ́ Liyel Mirki tiki ǹ wɛy nòhnɩ̀pu pól yõ. ");
INSERT INTO wib_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Liyel-á Mirki nɛ̂ kɔ̃, kǎh tɔ̃ mɔ névye yõ nónó náh pɩ Nsyifunɔlɛ, pè kɔ̃ pè wɛ́nkáhkɩ́nɔ́lɛ n wɛkɩ nónó-á pè náh sè sãh, tɛ́ Liyellɛ n gbilki sɛ̃́, képah pɩ gbɛ̃̀ndùnìnɛ Yesu yõ sɛ̃́pú Nsyifunɔ tyɩ́, pépi nónó-á sõ̀ pɔ ànɛ̂ Pyɛrɩlɛ. ");
INSERT INTO wib_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Képah sɔkɔ, Pyɛrɩ nɛ: «Névye nónónɛ Liyel Mirki wɛ tɛ ápi tyɩ́ kɔ̃lɛ, á kɩ fɛ̃ yahle sɔ̃́ nɛ, pè káh n wel n wilki ni sɔkɔ?» ");
INSERT INTO wib_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Tɛ́ mɛ pè kɔ̃ pè Kɔrnɛypi wel wilki ni sɔkɔ Yesu Krista yĩn yõ. Képah sɔkɔ, pépi mó Pyɛrɩ ni nɛ, à wũ sèpĩ̀n yísyɔ́ pɩ pélɛ. ");
INSERT INTO wib_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Tɛ́ Yesu tɛ̃ntõ̀ névye ànɛ̂ Yesu yõ sɛ̃́pú tɛ́lɔ́ nónó-á sõ̀ mɛ Nsyude gbɛ̃̀nyah sɔkɔ, pè kè noh nɛ, nósyɔ́ tɔ-á mɛ Liyel wɛy fɛ̃ syi, nónó náh pɩ Nsyifunɔlɛ. ");
INSERT INTO wib_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Képah tɛ̃̀nɛ, Pyɛrɩ-á pɔ ǹ syɩ kyɩ Yerusalɛmɩ sɔkɔ gbĩ́ nɛ̂nɛ, Yesu yõ sɛ̃́pú Nsyifunɔ kyɩ tyah lékàhlɛ ǹnɛ n kɔ̃, ");
INSERT INTO wib_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","tɛ́ nɛ, à se sɔ̃́npɩ́ kyɩ de, à yõke tɔlɛ n yõ névye tĩ̀nnɛ, nónó náh pɩ Nsyifunɔlɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Képah sɔkɔ, tir mɛ̀-á pɩ sɔ̃́, Pyɛrɩ ké yah yo wah pɔ dal mɔ pé tyɩ́ wárwár nɛ, ");
INSERT INTO wib_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","páh sõ̀ mɛ Nsyope kwil mɛ nírílɛ n pɩ, tɛ́ Liyel wɛ̃́kɩ́nɔ́ yɔ́lɛ pé wɛ̃kɩ. Páh kwâh yɔ́ wɛ kè mɛ wil yĩ̂nyõ fwɔ̀pĩ̀n-ǹgbɛ̃ yɔ́ sɔ̃́, ké vyɛ̃ynɔ ńyã́hlɛ tɛ̃́nɔ́lɛ, tɛ́ mɛ n tiki n pi à pɔ yĩni tɛ̃ pé tnɔ̂. ");
INSERT INTO wib_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Páh mɛ ké yáhnɔ́ sɔkɔ díkídíkí, pé yípɛ̂y wɛ ké sɔkɔ, ànɛ̂ gbɛ̃́nkyɔlɛ, ànɛ̂ yî nónó-á n til, à tahlɩ kèpye tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Képah tɛ̃̀ sɔkɔ, pé yĩ́npɔ̃́ yɔ́ noh kè mɛ n yo pé tyɩ́ nɛ: «Pyɛrɩ, yuku n ko sé sɔkɔ ǹ kɔ.» ");
INSERT INTO wib_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ǹtɛ pé mɛ yo yĩ́npɔ̃́ mɛ̀ tyɩ́ nɛ pé Tɛ̃̀ ǹgbɛ̃, pé náh képah pɩ n pi, ńkɛ̃́ páh pɩ sɔ̃́ pilɛ, dêl kwâh yɔ́ ńtɛ̃ náh de yah pé vyãh ànɛ̂ kwâh yɔ́ ńtɛ̃nɛ, nɛ̂-á névilɛ n silki Liyel yah. ");
INSERT INTO wib_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Képah tɛ̃̀nɛ, yĩ́npɔ̃́ mɛ̀ tɔ̃ wil yĩ̂nyõ, mɛ n yo nɛ ńkɛ̃́: «Liyel-á kwâh nɛ̂ wɛ̃kɩ kwáhpépɛ̌ynɛ, áwɔ tyɩ́ náh ké wɛ̃́kɩ́nɔ́lɛ nɛ, kǎh mɛ névilɛ n silki Liyel yah.» ");
INSERT INTO wib_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Képah tɛ̃̀-á pɩ sɛ̃́ kɛ tɔ̃́nɔ́, tɛ́ Liyel mɛ tɔ̃ kénɛ kwâh tɔkɔ dɔkɔ yĩ̂nyõ. ");
INSERT INTO wib_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Tɛ́ légbĩ́ mɛ̀ ó sɔkɔ, díbí nɛ́pĩ̂ tɔ̃́mɩ́ mó mɛ pɔ yĩn tɛ̃ péwɔ mɛ́-ńsah gbô yah sɔkɔ. Ǹnɩ̂-á tõ pélɛ Sesarɩ kwil, pè pɔ péwɔ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Tɛ́ Liyel Mirki mɛ yo péwɔ tyɩ́ nɛ, pé sɔkɔ pélɛ, pé káh tɔ̀tɔ̀ pɩ. Pé yṹnpyé nɛ́pĩ̂ kénúkò nónó-á yɔ̀, pépi mɛ pé sõ̀ tɛ̃ à yuku Sesarɩ kwil. Pé pól kyɩ de Kɔrnɛy gbô sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Képah sɔkɔ, Kɔrnɛy tɔ mó yo pé tyɩ́ nɛ, páh sõ̀ mɛ pé gbô sɔkɔ, tɛ́ yĩ̂nyõ tõ̀npɩ yɔ́ wil mɔ pé yah, tɛ́ yo pé tyɩ́ nɛ ńkɛ̃́, pé nɛy tɛkɩ n mɔ Nsyope kwil. Tɛ̃̀ kyɩ Simo tɛ̃ n pɔ, nɛ̂-á pè n ye Pyɛrɩlɛ. ");
INSERT INTO wib_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Wǎh kɩ pɔ wɛlɔ yísyɔ́ yo pé tyɩ́, nónó-á kɩ pé pwah mɔ ànɛ̂ pé gbô tãn póllɛ. ");
INSERT INTO wib_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Kɔrnɛy-á képah yo tɛ sɛ̃́ péwɔ Pyɛrɩ tyɩ́, tɛ́ pé fyɔ̀ tyah à tyilɛ n yo pé tyɩ́, Liyel Mirki tiki Kɔrnɛypi tɔ yõ, sɔ̃́-á lésõ kè tiki pépi yõ ké tyah gbĩ́nɛ. ");
INSERT INTO wib_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Kǎh pɩ sɛ̃́, péwɔ dyɔ to kõ Tɛ̃̀ ǹgbɛ̃ Yesu wɛy mɛ̀ tyɩ́lɛ, wǎh nɛ̂ yo nɛ ńkɛ̃́: «Nsyɔ̃ névye wel wilki ni sɔkɔ, ǹtɛ yépi tɛ̃̀ wɔlɛ, Liyel kɩ yé tɔ̃ sah ǹ Mirkilɛ kɩ yé pɩ yályál.» ");
INSERT INTO wib_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ǹtɛ pépi-á sɛ̃ Tɛ̃̀ ǹgbɛ̃ Yesu Krista yõ, tɛ́ Liyel mɛ ǹ Mirki nɛ̂nɛ pépi kɔ̃, wǎh fyɔ̀ kélɛ no nɔ́pi tɔ kɔ̃ tɛ pépi tyɩ́ kɔ̃lɛ, nɛ̂ se péwɔlɛ kɩ fɛ̃ Liyel tir yah kõ nɩ? ");
INSERT INTO wib_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Képah sɔkɔ, névye-á wɛlɔ nɔ́pi noh sɛ̃́, pé pól vɩ, tɛ́ Liyel yĩnnɛ n gbilki mɛ n yo nɛ, Liyel-á ńtyɩ̃́nɔ ké wɛ̃̀kɩ̀lɛ névye tɔ kɔ̃ nónó náh pɩ Nsyifunɔlɛ, pè kɩ fɛ̃ pé nnɔ vi mɔ, kɩ tyɛ́-ńkɛ̃̂ min wɛ dɛ́! ");
INSERT INTO wib_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Yetyɛ̃nɩ ko mɔ gbĩ́nɛ, pè sõ̀ mɛ Yesu yõ sɛ̃́púlɛ n fõh. Képah ye, pè to karkɩ. Pé túkù sɔkɔ Fenisi gbɛ̃̀nyah, túkù sɔkɔ Syipri gbɛ̃̀nyah, túkù mɛ sɔkɔ Antyɔsyɩ kwil. Tɛ́ pè náh sõ̀ mɛ Yesu tyɩ́lɛ n yo ǹnɩ̂ yɔ́ ńtɛ̃ tyɩ́, nɛ́ Nsyifunɔ ó tyɩ́ náh. ");
INSERT INTO wib_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ǹtɛ túkù sõ̀ mɛ pé sɔkɔ, nónó-á n wil Syipri gbɛ̃̀nyah sɔkɔ ànɛ̂ Sirɛnɩ kwil. Pépi-á pɔ Antyɔsyɩ sɔkɔ, pè sõ̀ mɛ Nɩ̀vɩ̀nɩ̀ tirlɛ n yo no tɛ́lɔ́ tɔ tyɩ́ Tɛ̃̀ ǹgbɛ̃ Yesu tyɩ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Tɛ́ Tɛ̃̀ ǹgbɛ̃ sõ̀ mɛ tɛ̃́nwɛnɔlɛ pélɛ n kɔ̃. Kǎh pɩ sɛ̃́, névye náhnáh vi mɔ Tɛ̃̀ ǹgbɛ̃ Yesu wɛ̃̀kɩ̀ yõ, à pɩ ǹ yõ sɛ̃́púlɛ. ");
INSERT INTO wib_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Képah tɛ̃̀nɛ, Yerusalɛmɩ Yesu yõ sɛ̃́pú tĩ̀nkì-á képah noh sɛ̃́, pè Barnabasɩ tɛkɩ mɔ Antyɔsyɩ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","24","Barnabasɩlɛ, nɛ́pépɛ̌y ye lésõ ǹnɛ. Liyel Mirki sõ̀ mɛ à tɔkɔ, ànɛ̂ Liyel yõ sɛ̃́nɔ́ mɛ ǹ sɔkɔ kègbɩlɛ. Képah ye, wǎh kyɩ yĩni tɛ̃, tɛ́ Liyel pèpɔrɩ pɩ́nɔ́ wɛ nɛ́npɔ́ Yesu yõ sɛ̃́pú tyɩ́ sɛ̃́, ǹ nɩ vɩ. À mɛ sṍré mɔ pé pól sɔkɔ nɛ, pè gbah tɛ̃ pé wrɔ́ tel tɛ̃ Tɛ̃̀ ǹgbɛ̃nɛ pé nnɔ póllɛ. Képah tɛ̃̀nɛ, tɔ́wû ǹgbɛ̃ fɛ̃ syi sɛ̃ Tɛ̃̀ ǹgbɛ̃ Yesu yõ. ");
INSERT INTO wib_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Képah náh, Barnabasɩ sɔkɔ Tarsɩ kwil, Sole yáhnkɔ̃-ńsah. ");
INSERT INTO wib_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Wǎh kyɩ à wɛ, à à tɛ̃ pɔ Antyɔsyɩ sɔkɔ. Pé nímí tɛ̃ à yi vi pól pɩ nɛ́npɔ́ Yesu yõ sɛ̃́pú tĩ̀nkìlɛ, à névye náhnáh tɔ wɛ kwɔ Yesu wɛ̃̀kɩ̀lɛ. Nɛ́npɔ́ ǹgbò sɔkɔ ye pè Yesu tõ̀ sã́hpú ye Kretyɛ̃bɩlɛ. ");
INSERT INTO wib_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Tɛ́ kénɛ sèpĩ̀n sɔkɔ, Liyel tɛ̃ntõ̀ syínyopu yísyɔ́ wil Yerusalɛmɩ kwil, à pɔ Antyɔsyɩ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Pé sɔkɔ núkú yɔ́ sõ̀ mɛ pè n ye Akabusilɛ. Tɛ́ Liyel Mirki gbõ̀ yõ, ǹmɔ yuku kè yo nɛ ńkɛ̃́, dǒ kwéy, kwɛ́npékè-á kɩ n de n pi kèkõyṍ pól sɔkɔ. Képah pɩ́nɔ́ pɔ Klode wɛ, Wrome kwíltãm yõ̀tɛ̃̀nɛ. ");
INSERT INTO wib_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Képah sɔkɔ, Yesu tõ̀ sã́hpú kè yah tɔkɔ, à yɩ̃nɛ pé nɛ́núkù núkú pól gbã̀n yî wɛ́nɔ́nɔlɛ nɛ, páh kɩ pé gbã̀n yî yísyɔ́ tuke mɔ, kɩ tɛkɩ mɔ Yesu yõ sɛ̃́pú kɔ̃ Nsyude gbɛ̃̀nyah sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Pǎh kè yah tɔkɔ sɔ̃́, pè kè pɩ sɛ̃́, tɛ́ mɛ yî nɔ́pilɛ Barnabasɩ ànɛ̂ Sole gbõ̀ dahbɩ, pépi mɛ kyɩ sélɛ Yesu yõ sɛ̃́pú yah tãm kɔ̃. ");
INSERT INTO wib_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ké légbĩ́ mɛ̀ sɔkɔ, yõ̀tɛ̃̀ dĩ́ Yerɔdɩ tyah Yesu yõ sɛ̃́pú tĩ̀nkì névye túkù fṍhnɔ́lɛ Yerusalɛmɩ kwil. ");
INSERT INTO wib_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","À Nsyɔ̃ nɛ́nkyɩ́ dĩ́ Nsyakɩ ko mɔ kèkírkìlɛ. ");
INSERT INTO wib_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Tɛ́ wǎh kè wɛ yĩ mɛ̀ nɔ Nsyifunɔ tyɩ́ sɛ̃́, à tɔ̃ Pyɛrɩ tɔ tɛ̃. Légbĩ́ pɔ yɩ̃nɛ Nsyifunɔ búrn sɛ̃̀-ǹkɛ̃̂ syáh syáhnɔ́lɛ. ");
INSERT INTO wib_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Wǎh Pyɛrɩ tɛ̃ sɛ̃́, à mɛ à dah mɔ wɔ̀kɔ̀npèkè sɔkɔ, tɛ́ sràsyíbí nɛ́pĩ̂ ǹyẽ̂h tĩ̀nkìnɔ́ ńyã́h névye kɔ̃ pè wɛ̃nɛ n sah, à ǹnɛ n syɩkɩ. À sõ̀ mɛ ké tyɩ́ nɛ, búrn sɛ̃̀-ǹkɛ̃̂ syáh-à kɩ sɔkɔ tɛ, pé à tuke no pól yĩ́ yah. ");
INSERT INTO wib_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Pyɛrɩ yah sõ̀ mɛ víkénɔ́lɛ wɔ̀kɔ̀npèkè sɔkɔ, ǹtɛ Yesu yõ sɛ̃́pú tĩ̀nkì mó mɛ Liyellɛ n gbah n ni ǹ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Tɛ́ sõ nɛ̂ dĩndal-á Yerɔdɩ kɩ Pyɛrɩ tuke n pi, ké lékã̂hnɛ, Pyɛrɩ sõ̀ mɛ púkúbínsàhnɔ́lɛ kɛ̃́lɔ́ plɔ́ nínɔ́lɛ, tɛ́ mɛ n dɔ sràsyíbí nɛ́pĩ̂ nímí wrɔ́. Tɛ́ wɔ̀kɔ̀npèkè mɛ̀ syɩ́kɩ́pú sõ̀ mɛ ké yah, mɛ kélɛ n syɩkɩ. ");
INSERT INTO wib_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ǹtɛ nɛ́npɔ́ swɔ, Tɛ̃̀ ǹgbɛ̃ yĩ̂nyõ tõ̀npɩ yɔ́ núkú wil mɔ wɔ̀kɔ̀npèkè mɛ̀ sɔkɔ, ké sɔkɔ pól piki pěrr. Yĩ̂nyõ tõ̀npɩ mɛ̀ mɛ Pyɛrɩ mɩ mɩ ǹ gbɔ̀pɔ tyɩ́ à à yilki mɔ, tɛ́ yo ǹ tyɩ́ nɛ ńkɛ̃́, à yuku súú. Képah sɔkɔ, kɛ̃́lɔ́ nɔ́pi núkú kɔ̃lɩ to Pyɛrɩ gbã̀n tyɩ́, à kwɛ sétáh. ");
INSERT INTO wib_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Képah tɛ̃̀nɛ, yĩ̂nyõ tõ̀npɩ tɔ̃ yo ǹ tyɩ́ nɛ, à ǹ kɔ̃ dyɩ ànɛ̂ ǹ lékyêhlɛ. À mɛ kè pɩ sɛ̃́. Yĩ̂nyõ tõ̀npɩ mɛ̀ tɔ̃ yo ǹ tyɩ́ nɛ, à ǹ fwɔ̀mɔ̀-ǹgbɛ̃ mɔ, à mó pé sõ̀ tɛ̃. ");
INSERT INTO wib_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pyɛrɩ mɛ ǹ sõ̀ tɛ̃, à wil. Tɛ́ yĩ̂nyõ tõ̀npɩ-á tyi nónónɛ n pɩ, Pyɛrɩ náh sõ̀ mɛ sɛ̃ sé yõ nɛ gblɔ-á sélɛ. À sõ̀ wɛ nɛ dɛ́kɩ́-á pé n dɔ. ");
INSERT INTO wib_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Pè wɔ̀kɔ̀npèkè syɩ́kɩ́-ńsah gben kal sɔkɔ, tɛ́ ké ní-ò tɔ kal sɔkɔ, tɛ́ kyɩ syɩ vyɔrɩ wùkah gbɩ̃́nɩ́ tyɩ́. Képah yah sõ̀ mɛ mɔ́nɔ́lɛ kwil nɩyṍ tĩ̀nnɛ. Ké tɔ núkú yɩkɩ mɔ ké gblɔ̌y. Pè mɛ wil à wɛ̃̀kɩ̀ tɛ̃ n yuku. Dǒ, Pyɛrɩ núkú yĩ̂nyõ tõ̀npɩ mɛ̀ yah kwlɔ. ");
INSERT INTO wib_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Képah sɔkɔ, Pyɛrɩ yah pyě pɩ kyòo yĩ mɛ̀nɛ. À mɛ nɛ núkúnúkú, páh pyě kè pɩ̃ yĩ́ĩ́ nɛ, Tɛ̃̀ ǹgbɛ̃-á tõ ǹ yĩ̂nyõ tõ̀npɩlɛ à pɔ pé pwah mɔ wilki Yerɔdɩ gbõ̀ ànɛ̂ Nsyifunɔ-á sõ̀ mɛ pèl nónónɛ n syɩkɩ nɛ, sè péwɔ nɔ. ");
INSERT INTO wib_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Tɛ́ Nsyɔ̃ nɛ̂-á pè n ye Markɩlɛ, Pyɛrɩ-á ǹ fɔkɔ sõ yah, à sɔkɔ ǹmɔ yṹ Mari gbô. Nírí pɩ́pú náhnáh sõ̀ mɛ tuke mɔ tɛ̃ nɛ́npɔ́, mɛ Liyellɛ n ni. ");
INSERT INTO wib_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Tɛ́ Pyɛrɩ-á pɔ gbô yah mɩ, tõ̀npɩ pípír yɔ́ mɛ pè n ye Wrodelɛ, ǹmɔ mɛ nɔ de kélɛ, tɛ́ píkínyahnɔ pɩ nɛ, nɛ̂ se nɩ? ");
INSERT INTO wib_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Képah sɔkɔ, Pyɛrɩ-á yo mɔ, à ǹ yĩ́ pɩ̃. Ké nɩ̀vɩ̀nɩ̀ tɛ̃̀ tyɩ́, à pyě gbô yah sah yɩ́kɩ́nmɔ-ńkɛ̃̂nɛ tɛ́ ǹ syɩ to kyɩ kè yo no tɛ́lɔ́ tyɩ́ nɛ ńkɛ̃́, Pyɛrɩ-á mɛ yĩ́nntɛ̃̀nɔ́lɛ gbô yah. ");
INSERT INTO wib_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ǹtɛ pè pyě nɛ, pípír yõ̀gbèkè-á yuku. Tɛ́ wǎh mɛ kélɛ n gbah n yo nɛ gbɩ-á pé n yo, pè tɔ̃ nɛ ńkɛ̃́, Pyɛrɩ mírkí-á kɩ nɛ̂ à wɛ. ");
INSERT INTO wib_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ǹtɛ Pyɛrɩ wɔ mó mɛ wùkahlɛ n tɔ̃ n mɩ sɛ̃́. Képah sɔkɔ, pǎh pópó pɔ wùkah yɩkɩ mɔ, pè kè wɛ kè pɩ ǹmɔlɛ ńtyɩ̃́nɔ. Kè pɩ pé tyɩ́ gbɛ̃̀ndùnìnɛ. ");
INSERT INTO wib_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pyɛrɩ mɛ ǹ gbõ̀ pɩ mɔ pé tyɩ́ nɛ, pè pé vyɛ̃y vike. Tɛ́ Liyel-á à yohnɩ mɔ dùkù nɛ̂nɛ à kɔ̃ à wil wɔ̀kɔ̀npèkè sɔkɔ, à de ké sɔkɔ à kè yãh pé tyɩ́. Tɛ́ yo pé tyɩ́ nɛ ńkɛ̃́, pè kyɩ kè yãh Nsyakɩ ànɛ̂ pé yṹnpyé Yesu yõ sɛ̃́pú tɛ́lɔ́ tyɩ́. Képah náh, à pyě wil sɔkɔ fɩ̃́ yɔ́. ");
INSERT INTO wib_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ǹtɛ tyah-á pɔ dal, sràsyíbí fɔkɔ fil Pyɛrɩ tyɩ́lɛ. Képah sɔkɔ, pè wɛ̃nɛ n piki n yah nɛ, ǹ tyɩ́ se pɩ sɔ̃́ nɩ? ");
INSERT INTO wib_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Képah tɛ̃̀nɛ, Yerɔdɩ pè kɔ̃ pè mɩ de Pyɛrɩ sóhnkɔ̃nɔ sɔkɔ. Ǹtɛ pè náh à wɛ. Kǎh pɩ sɛ̃́, à mɛ wɔ̀kɔ̀npèkè syɩ́kɩ́pú ye pɔ piki yah, tɛ́ nɛ, pè pè ko mɔ. Képah náh, Yerɔdɩ wil Nsyude gbɛ̃̀nyah sɔkɔ à kyɩ sèpĩ̀n yísyɔ́ pɩ Sesarɩ kwil. ");
INSERT INTO wib_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Tiri kwil ànɛ̂ Sidõ kwil tãn-á sõ̀ mɛ gbɛ̃̀nyah nɛ̂ sɔkɔ, ké yõke lésõ mɛ n wil yõ̀tɛ̃̀ dĩ́ Yerɔdɩ gbɛ̃̀nyah sɔkɔ. Tɛ́ yékã̂b-á pɔ wɛ pé wrɔ́ ànɛ̂ Yerɔdɩlɛ, Yerɔdɩ fɔkɔ kah vyãh pélɛ. Kǎh pɩ sɛ̃́, pépi mɛ yo sah núkú yõ nɛ, páh kɩ kyɩ wil Yerɔdɩ tyɩ́. Képah yĩnnɛ, pè kyɩ pé sõnɔ pɩ núkúlɛ ànɛ̂ Yerɔdɩ sɛ̃́-ńsah wɔ̀kɔ̀ yõ̀tɛ̃̀nɛ, nɛ̂-á pè n ye Blasɩtusilɛ, nɛ pé kyɩ yégbékè kwrɔ́nmɔnɔ yah kɔ̃ Yerɔdɩ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Pǎh gbĩ̀yĩ̀kì nɛ̂ yah tɔkɔ, ké lésõ-á nɔ, Yerɔdɩ ǹ yõ̀tɔ̃rɩ́ flɔ mɔ pɔ kɔ̃ tɛ̃ ǹ yõ̀tɔ̃rɩ́ kǒ yõ, à tyah wɛy yɔ́lɛ n yo tɔ́wû tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Képah tɛ̃̀nɛ, névye tyah n gbo mɔ nɛ, névi tɛ̃̀ wɔ náh n wɛkɩ yɔ̀ dɛ́, Liyel-á! ");
INSERT INTO wib_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Képah sɔkɔ, Yerɔdɩ-á sɔ̃́npɩ́ gbílkínɔ́ mɛ̀ fɛ̃ syi, nɛ̂-á sõ̀ yɩ̃nɛ sàhnɔ́lɛ Liyel yõ, Tɛ̃̀ ǹgbɛ̃ yĩ̂nyõ tõ̀npɩ yɔ́ núkú à mɩ, kèfyɔ̃ mɛ gbɔ ǹ sɔkɔ, à à yõ ko. ");
INSERT INTO wib_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ǹtɛ Liyel wɛy sõ̀ mɛ n gbah n tɔ̃ mɔ n yuku ólɛ. ");
INSERT INTO wib_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Tɛ́ Barnabasɩ ànɛ̂ Sole wɔ-á pé tõ̀ pɩ tɛ Yerusalɛmɩ kwil, pè Nsyɔ̃-Markɩ tɛ̃ pé syɩ sɔkɔ Antyɔsyɩ kwil. ");
INSERT INTO wib_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Liyel tɛ̃ntõ̀ syínyopu ànɛ̂ névye kwɔ́pú sõ̀ mɛ Antyɔsyɩ kwil Yesu yõ sɛ̃́pú tĩ̀nkì sɔkɔ: Barnabasɩ sõ̀ mɛ, ànɛ̂ Solelɛ, ànɛ̂ Simeyõlɛ, nɛ̂-á pè n ye Dĩ́syíkèynɛ, ànɛ̂ Sirɛnɩ kwil Lusiyusilɛ, à tahlɩ Manayɛ̃ tyɩ́, ǹmɔ nɛ̂-á sõ̀ kɔ̃rɩ pɩ wɛ̃ tyɩ́ Kalile gbɛ̃̀nyah yõ̀tɛ̃̀ dĩ́ Yerɔdɩlɛ. ");
INSERT INTO wib_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Sõ yɔ́lɛ, pǎh mɛ níkì tɛ̃, tɛ́ mɛ Tɛ̃̀ ǹgbɛ̃ Liyellɛ n ni gbĩ́ nɛ̂nɛ, ǹ Mirki yo pé tyɩ́ nɛ: «Yé Barnabasɩ ànɛ̂ Sole wilki pé tyɩ́lɛ. Pè kɩ tõ̀ pɩ, nɛ̂ yĩn-á mé n ye pélɛ.» ");
INSERT INTO wib_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Képah sɔkɔ, pè níkì tɛ̃, à nírí pɩ pé tyɩ́ à pé gbã̀n sah pé yõ, tɛ́ pyě pè fĩn mɔ pè sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Liyel Mirki-á Barnabasɩ ànɛ̂ Sole tɛkɩ mɔ tõ̀ sɔkɔ sɛ̃́, pè mɛ tiki yuku à kyɩ de Selesi kwil. Tɛ́ de krótókè ǹgbɛ̃ yɔ́ sɔkɔ nɛ́npɔ́, nɛ páh n yuku gbɛ̃̀nyah yɔ́ sɔkɔ pè n ye Syiprilɛ, pnɛ yɔ nɩyṍ. ");
INSERT INTO wib_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Pǎh yĩni tɛ̃ ké kwil yɔ́ sɔkɔ pè n ye Salamininɛ, pè tyah Liyel wɛynɛ n yo Nsyifunɔ Liyel ní-ńtã̂n vɩ̀ sɔkɔ. Tɛ́ Nsyɔ̃-Markɩ tɔ sõ̀ mɛ pélɛ, pé yohnɩ n mɔ yĩnnɛ. ");
INSERT INTO wib_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Pè mɛ Syipri mɛ̀ kan kɔ kah, à kyɩ de ké kwil yɔ́ sɔkɔ pè n ye Pafɔsɩlɛ. Pè kyɩ Nsyifunɔ sènpɩ dĩ́ yɔ́ yohnɩ, nɛ̂-á pè n ye Bar-Yesulɛ. Ǹmɔ sõ̀ mɛ ǹ gblɔ̌ynɛ n pɩ Liyel tɛ̃ntõ̀ syínyo-òlɛ. ");
INSERT INTO wib_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Tɛ́ à sõ̀ mɛ wɛ̃ tyɩ́ ànɛ̂ Syipri yah tɛ̃́-ò dĩ́ Sɛrɩsyusi Polusilɛ, ǹmɔ nɛ̂-á lésõ lékã́m névilɛ. Tɛ́ Liyel wɛy noh dékè sõ̀ mɛ Sɛrɩsyusi Polusi tɛ̃. Képah ye, à pè kɔ̃ pè kyɩ Barnabasɩ ànɛ̂ Sole ye. ");
INSERT INTO wib_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ǹtɛ sènpɩ dĩ́ Bar-Yesulɛ, pè tɔ̃ sõ̀ ǹnɛ n ye Yelimasɩlɛ Krɛkɩ wɛy sɔkɔ. Ǹmɔ sõ̀ mɛ Barnabasɩ ànɛ̂ Solelɛ n fwo. À sõ̀ mɛ n yah n kɔ̃ Syipri yah tɛ̃́-ò dĩ́ yĩ́nínmɔ-ńsahlɛ, nɛ à káh sɛ̃ Yesu yõ. ");
INSERT INTO wib_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Képah sɔkɔ, Sole nɛ̂-á tɔ̃ pè n ye Polelɛ, Liyel Mirki à tɔkɔ, à mɛ sènpɩ dĩ́ yah díkídíkí, ");
INSERT INTO wib_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","tɛ́ yo ǹ tyɩ́ nɛ: «Áwɔ nɛ̂-á lékã́mkãm ànɛ̂ yĩ́nvǐ ó á tɔ̂ɔ́, sétã̀n yõ̀tɛ̃̀ névi mɛ̀; gblɔ wã̀l pól sépɛlɛ áwɔlɛ, Tɛ̃̀ ǹgbɛ̃ wã̀l tómtóm fɛ̃̀kɩ̀nɔ́ yal mɔ dɛ́! ");
INSERT INTO wib_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Núkúnúkú tɛ̃̀nɛ, Liyel gbõ̀ kɩ sah á wil. Á kɩ pɩ yɩ̃́tũ̂nɛ wrɔ́ yɔ́ sɔkɔ, á náh tɔ̃ gbĩ kyòo wɛ n pi.» Képah yóntɛnɔ ǹsɔ̃̀, ǹ yɩ̃́ núkú wɔ, à ǹ gblɔ̌y wɛ fɛ̃́ntũ̂ sɔkɔ, tɛ́ tyah n kɔ n kore n vi n kɔ̃, à nɛynɛ n yah n kɔ̃ ǹ gbõ̀ sɔkɔ tɛ̃ tɛ̃ tɛ̃̀nɛ. ");
INSERT INTO wib_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Képah sɔkɔ, Syipri yah tɛ̃́-ò dĩ́-á Liyel tyí-ǹgbnɔ pɩ́nɔ́ wɛ, tɛ́ kwɔ́nɔ́ nɛ̂ noh, sè ǹ nɩ tɛ̃. Kǎh pɩ sɛ̃́, à sɛ̃ Tɛ̃̀ ǹgbɛ̃ Yesu yõ. ");
INSERT INTO wib_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Képah náh, Pole ànɛ̂ ǹ kɔ́mû de krótókè ǹgbɛ̃ sɔkɔ, à yal Pafɔsɩ kwil, tɛ́ yuku Pɛrsyɩ kwil, Pãnfili gbɛ̃̀nyah sɔkɔ. Pǎh mɛ nɛ́npɔ́, Nsyɔ̃ ǹ gbɛ wil pé sɔkɔ, à ǹ syɩ yuku Yerusalɛmɩ kwil. ");
INSERT INTO wib_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ǹtɛ Polepi tɛ̃̀ wɔ mó yal Pɛrsyɩ kwil, à yɔ̃ sɔkɔ pé kɔ́lɔ́lɛ, pópó à kyɩ de Antyɔsyɩ kwil, Pisidi gbɛ̃̀nyah sɔkɔ. Tɛ́ Nsyifunɔ mɩ mɩ yòh sõ-á pɔ nɔ, pè kyɩ de kɔ̃ tɛ̃ pélɛ pé Liyel ní-ńsah wɔ̀kɔ̀ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Képah tɛ̃̀nɛ, ǹnɩ̂ yɔ́ mɛ tyi kõ̀nsàhnɔ́ ànɛ̂ Liyel tɛ̃ntõ̀ syínyopu sɛ́bɛ́ynɔ́ tã̀ntã̀nnɔ́ yísyɔ́ kar. Wǎh kar tɛ, Liyel ní-ńsah wɔ̀kɔ̀ yah tãm mɛ pè kɔ̃ pè yo Polepi tyɩ́ nɛ, pé no, wɛlɔ yísyɔ́-à kɩ mɛ pé tyɩ́ sṍré mɔ mɔ tɛ̃̀nɛ tɔ́wû sɔkɔ, ké wɛ̃̀kɩ̀-á mɛ pé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Képah sɔkɔ, Pole mɛ yuku yĩn, tɛ́ ǹ gbõ̀ pɩ mɔ no tyɩ́ nɛ, pè noh pé tyɩ́ yɔ̀. Tɛ́ yo pé tyɩ́ nɛ: «Yisrayel tãn, à tahlɩ nónó-á Nsyifunɔ náh pélɛ, tɛ́ mɛ Liyel yah tíkílɛ n pɩ, yé nóhnɔ́ pɩ ń tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Ápi Yisrayel tãn Liyellɛ, à ápi náh tãn yah wilki. À tɔ̃ Yisrayel tãn pɩ dò, gbĩ́ nɛ̂-á sõ̀ pè mɛ Yesyipti gbɛ̃̀nyah sɔkɔ; tɛ́ tɔ̃ ǹ tɛ̃́nwɛnɔlɛ pè wilki ké sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Tɛ́ à pè pu gbɛ̃́nnɩ sɔkɔ pópó ye tikininí kénkɔ̃lɛ. ");
INSERT INTO wib_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Képah náh, à yìkìnìnɔ́ kwǎrninɔ névye ko mɔ, à pé duku to Kanah gbɛ̃̀nyah sɔkɔ, tɛ́ pé sétáhlɛ Yisrayel tãn kɔ̃ gbɛ̃kɩlɛ. ");
INSERT INTO wib_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Tyi nɔ́pi pól-á pópó n pɩ n tɛ, kè nɔ ye kyɛyẽ́h tikininí pɔ́ gbãm (450) kénkɔ̃lɛ. Képah náh, á náh tãn sɔkɔ ye Liyel n wilki á vyãh syípúlɛ, pópó à pɔ nɔ Liyel tɛ̃ntõ̀ syínyo-ò Samuyɛlɩ gbĩ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Tɛ́ sõ yɔ́lɛ, pè mɛ kè yah kɔ̃ Liyel tyɩ́ nɛ, páh mɛ yõ̀tɛ̃̀ yɔ́ tyɩ́. Képah sɔkɔ, Liyel mɛ Kisi pídĩ́ Sawuli pɩ pé yõ̀tɛ̃̀nɛ, pópó ye tikininí. Tɛ́ Sawulilɛ, Bɛ̃nsyamɛ yìkì nɛy ye sõ̀ ǹnɛ. ");
INSERT INTO wib_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ǹtɛ Liyel-á pɔ ǹmɔ milki gbĩ́ nɛ̂nɛ, à mɛ Davidi pɩ pé yõ̀tɛ̃̀nɛ. Davidi tyɩ́ sɔkɔ ye lésõ Liyel yo nɛ ńkɛ̃́: ‹Mé wil mɔ ń dyɔ yĩ́ĩ́ nɛy yõ, ǹmɔ nɛ̂-á Nsyese pídĩ́ Davidilɛ. À kɩ ń dyɔ yĩ́ĩ́ tyi pól pɩ dal mɔ pallɛ.› ");
INSERT INTO wib_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Liyel ye lésõ ǹ vyãhlɛ Davidi kɔ̃ nɛ, Yisrayel pwáhnmɔ-ò-á kɩ dubi ǹmɔ pétóbé sɔkɔ. Kénɛ pwáhnmɔ-ò ye pɔ pɩ Yesulɛ. ");
INSERT INTO wib_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Tɛ́ Yesu-á pópó n pi, wèlnwìlkì-ò Nsyɔ̃ ye yo Yisrayel tãn pól tyɩ́ nɛ, pè pé nnɔ vi mɔ, pè mó wèlnwìlkìnɔ́ wɛ. ");
INSERT INTO wib_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ǹtɛ Nsyɔ̃ tõ̀-á pópó pɔ n tyɛ, à mɛ n yo névye tyɩ́ nɛ ńkɛ̃́: ‹Yépi tɛ̃̀ sõnɔ sɔkɔ, nɛ̂ mɛ ńmɔlɛ? Yé káh wɛ nɛ, pwáhnmɔ-ò nɛ̂ pɔ́nɔ́-á yé syɩkɩ tɛ̃, ǹmɔ-á ńmɔlɛ dɛ́! Ǹtɛ yé yah, à mɛ n knɛ pɔ́-ńsah. Tɛ́ ńmɔ ńtɛ̃ fṍrɔɔ kah ǹ lékyêh fyé dɛ́nɔ́lɛ ǹ gbyẽ̂h sɔkɔ.›» ");
INSERT INTO wib_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Képah náh, Pole tɔ̃ nɛ: «Á no, yépi nónó-á Abrahmɩ pétóbélɛ, à tahlɩ Liyel yah tíkí pɩ́pú pól tyɩ́, pwáhnmɔnɔ wɛy mɛ̀ ye tɛkɩ mɔ ápi pól yĩnnɛ. ");
INSERT INTO wib_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ǹtɛ Yerusalɛmɩ tãn ànɛ̂ pé yõ̀tãm náh lésõ pɩ̃ nɛ, Yesu-á pwáhnmɔ-òlɛ. Tɛ́ Liyel tɛ̃ntõ̀ syínyopu wɛlɔ nónó-á n kar pé tyɩ́ Nsyifunɔ mɩ mɩ yòh sõnɔ́ póllɛ, pè náh sé yõ pɩ̃. Kénɛ wɛlɔ tyi yónɔ́ ye lésõ pè pɩ dal mɔ, pǎh lékàhlɛ Yesu kɔ̃. ");
INSERT INTO wib_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Pè náh Yesu tyípɩ́nɩ́ yɔ́ ńtɛ̃ wɛ, nɛ̂-á yɩ̃nɛ ǹ kònmɔnɔlɛ. Ǹtɛ pè kè yah kɔ̃ Pilati tyɩ́ nɛ, à à ko mɔ. ");
INSERT INTO wib_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Tɛ́ Liyel wɛy-á tyi nónó pól yo Yesu tyɩ́ sɔkɔ, pǎh pɔ sè pɩ dal mɔ tɛ gbĩ́ nɛ̂nɛ, pè ǹ lékó tiki mɔ to dahnɩ yõ, tɛ́ kyɩ à yɩ̃ diki yɔ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ǹtɛ Liyel mɛ ǹ lékó yilki mɔ. ");
INSERT INTO wib_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Képah náh, névye nónó-á lésõ ǹ sõ̀ tɛ̃ yal Kalile gbɛ̃̀nyah, à dɔkɔ yuku ǹnɛ Yerusalɛmɩ kwil, à ǹ gblɔ̌ynɛ pépi wɛ̃kɩ sèpĩ̀n náhnáh sɔkɔ. Kénɛ névye nɔ́pi ye mɛ ǹ tyi yónwàhpu kègblɔlɛ Yisrayel tãn yah núkúnúkú yɔ̀. ");
INSERT INTO wib_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Ǹtɛ ápilɛ, Nɩ̀vɩ̀nɩ̀ tir ye ápi tɔ n yo yé tyɩ́ yɔ̀ nɛ ńkɛ̃́: Liyel-á ǹ vyãhlɛ á náh tãn kɔ̃ nɛ̂ tyɩ́ yõ, ");
INSERT INTO wib_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","képah-á à pɩ dal mɔ ápi tyɩ́, ápi nónó-á pɩ pé wɛ̃́npìlɛ. Wǎh Yesulɛ á kɔ̃, à yɩ̃nɛ kǎh wãrkɩ sah sɔ̃́ Gbálnɔ́ sɛ́bɛ́y yɩ̀kɩ̀ ní-ò sɔkɔ nɛ ńkɛ̃́: ‹Ńmɔ Pídĩ́ ye álɛ; à tɔkɔ kwɛy tyɩ́, ńmɔ ye á Súlɛ.› ");
INSERT INTO wib_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Liyel ye lésõ kwãh tɛ̃ kè yo sah nɛ ńkɛ̃́, Yesu-à pɔ ku, à náh n pyãh n pi. Páh kɩ ǹ lékó yilki mɔ. À tɔ̃ lésõ kè yo dal mɔ nɛ ńkɛ̃́: ‹Máh lésõ ń vyãhlɛ Davidi kɔ̃ nɛ̂ tyɩ́ sɔkɔ, mé kɩ kè pɩ yé tyɩ́, kɩ sãm mɔ yé sɔkɔ, tir yɔ́ náh ké dùkù ku n pi.› ");
INSERT INTO wib_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Képah ye Davidi yo fɩ̃́ yɔ́ sɔkɔ nɛ ńkɛ̃́: ‹Á náh n yɛ á tõ̀npɩ pèpɛy lékó kɔ̃ kè n pyãh n pi.› ");
INSERT INTO wib_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Ǹtɛ Davidi tɛ̃̀ wɔ gbĩ sɔkɔ, à Liyel tõ̀ pɩ ké wɛ̃̀kɩ̀ yõ. Képah náh, à mɛ ku pè kɔ̃ pè yɩ̃ ǹ náh tãn lékyɩ̂ tnɔ̂, ǹ tɔ lékó mɛ pyãh. ");
INSERT INTO wib_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ǹtɛ Liyel ye Yesu lékó yilki mɔ. Ǹmɔ lékó tɛ̃̀ wɔ náh pyãh dɛ́! ");
INSERT INTO wib_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Á no, yé pɩ̃ nɛ, ǹmɔ Yesu gbõ̀ yõ-á tyípêl yɔ̃̀nmɔnɔ tyɩ́ wɛ yo yé tyɩ́ dɛ́! Moyisi tyi kõ̀nsàhnɔ́ náh tɛ̃ wɛ yé yõ wilki tyípêl nónó sɔkɔ, ");
INSERT INTO wib_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","névi nɛ̂-à sɛ̃ Yesu yõ, tɛ̃̀ yõ kɩ wil sé pól sɔkɔ, à kɩ fɛ̃ nɔ de Liyellɛ. ");
INSERT INTO wib_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Képah ye, yé kyɔ̀mɩ̀nɔ́ pɩ, yè káh pɔ Liyel wɛy mɛ̀ yahle. Képah-à pɩ́-ńkɛ̃̂nɛ, Liyel tɛ̃ntõ̀ syínyopu-á tir nɛ̂ yo sah, kè kɩ pɔ yé yĩni tɛ̃. Pè lésõ nɛ ńkɛ̃́: ");
INSERT INTO wib_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‹Yé yah, wɛ̀nyɩ̀kɩ̀ wɛ́kɩ́pú nɔ́pi, yé nɛ mɛ gbɛ̃̀ndùnì sɔkɔ, yè mó ku tɛ̃ yõ! Máh kɩ pɔ nɛ̂ pɩ n pi yé sɔkɔ, tɛ́ kɩ yé sah min sɔkɔ; névi-à sɔ̃́ sõ̀ pɔ kélɛ n yãh yé tyɩ́, yé náh n sɛ̃ n pi ké yõ.›» ");
INSERT INTO wib_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Sépi yóntɛnɔ náh, Pole ànɛ̂ Barnabasɩ-á n wil Liyel ní-ńsah wɔ̀kɔ̀ sɔkɔ gbĩ́ nɛ̂nɛ, no tyah pélɛ n ni nɛ, mɩ mɩ yòh kèyǎhlɛ, pè tɔ̃ pɔ pé syɩ pé wɛy mɛ̀ ó yõ. ");
INSERT INTO wib_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Képah náh, tɔ́wû-á pɔ karkɩ gbĩ́ nɛ̂nɛ, névye náhnáh Pole ànɛ̂ Barnabasɩ sõ̀ tɛ̃. Nsyifunɔ ye sõ̀, à tahlɩ névye tyɩ́, nónó-á vi mɔ de Nsyifunɔ Liyel nínɔ́ wɛ̃̀kɩ̀ sɔkɔ. Tɛ́ Pole ànɛ̂ Barnabasɩ sõ̀ mɛ n yãh pélɛ, à pé sõnɔlɛ n vi n mɔ nɛ, Liyel-á pèpɔrɩ nɛ̂ pɩ pé tyɩ́, pè ké tɛ̃́nɔ́ plɛ. ");
INSERT INTO wib_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Képah sɔkɔ, Nsyifunɔ mɩ mɩ yòh kèyǎh-á vi pɔ, kwil névye kan pɔ tuke mɔ Liyel wɛy noh yĩnnɛ. ");
INSERT INTO wib_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Nsyifunɔ-á kénɛ tɔ́wû wɛ sɛ̃́, dyɔ́yɔ́kɩ̀ de pé sɔkɔ képékèyɔ̂. Pè tyah Pole wɛynɛ n kɔ̃lɩ, à ké tyɩ́lɛ n yo n yɩkɩ. ");
INSERT INTO wib_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Képah sɔkɔ, Pole ànɛ̂ Barnabasɩ kè yo nɩ̀sãhlɛ pé tyɩ́ nɛ: «Yépi ǹgbò tyɩ́ ye Liyel wɛy sõ̀ yɩ̃nɛ kè yo. Ǹtɛ yáh fyɔ̀ kè yahle, tɛ́ kè wɛ̃kɩ nɛ yé náh yɩ̃nɛ tyɛ́-ńkɛ̃̂ min wɛ́nɔ́lɛ, kǎh pɩ sɛ̃́, ápi kɩ á yah mɔ névye tĩ̀nnɛ núkúnúkú, nónó náh pɩ Nsyifunɔlɛ. ");
INSERT INTO wib_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Tɛ̃̀ ǹgbɛ̃ Liyel-á nɛ̂ yo, képah ye á n pɩ dò. À kè yo nɛ ńkɛ̃́: ‹Mé ye ǹ sah nɛ á pɩ kyòolɛ névye tyɩ́, nónó náh pɩ Nsyifunɔlɛ, á mó kyɩ pwáhnmɔnɔ wɛy yo kèkõyṍ pól sɔkɔ.›» ");
INSERT INTO wib_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Képah sɔkɔ, nónó náh pɩ Nsyifunɔlɛ, pǎh wɛlɔ nɔ́pi noh sɛ̃́, pé nɩ vɩ, pè tyah Tɛ̃̀ ǹgbɛ̃ Liyel wɛynɛ n gbilki. Tɛ́ névye nónó pól-á sõ̀ yɩ̃nɛ tyɛ́-ńkɛ̃̂ min wɛ́nɔ́lɛ, pé pól sɛ̃ Tɛ̃̀ ǹgbɛ̃ yõ. ");
INSERT INTO wib_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Liyel wɛy núkú tɔ̃ mɔ kénɛ gbɛ̃̀nyah tã̀ntã̀n pól sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Tɛ́ syɔ́ nɛ́-ǹgbnɔ yísyɔ́ sõ̀ mɛ, nónó-á mɛ Nsyifunɔ Liyel wɛ̃̀kɩ̀lɛ n kɔ. Kǎh pɩ sɛ̃́, Nsyifunɔ mɛ pépi ànɛ̂ kwil nɛ́-ǹgbnɔ yísyɔ́ kurki mɔ Pole ànɛ̂ Barnabasɩ yõ. Pè mɛ tyah Polepilɛ n fõh, tɛ́ pè yĩni yal pé sétáh yõ. ");
INSERT INTO wib_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Pǎh mó n wil kénɛ kwil, pè pé gbyẽ̂h nɛ̀ngbɔ̃ kwer kwɛ ké sɔkɔ, tɛ́ sɔkɔ Yikonyumi kwil. ");
INSERT INTO wib_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ǹtɛ Antyɔsyɩ kwil Yesu tõ̀ sã́hpú tɛ̃̀ wɔ sõ̀ mɛ nɩ̀vɩ̀nɩ̀ ǹgbɛ̃ sɔkɔ, tɛ́ Liyel Mirki mɛ pè tɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Képah sɔkɔ, Pole ànɛ̂ Barnabasɩ-á yĩni tɛ̃ Yikonyumi kwil, pè tɔ̃ de yuku Nsyifunɔ Liyel ní-ńsah wɔ̀kɔ̀ sɔkɔ. Tɛ́ tyah Liyel wɛynɛ n yo, fɔ́ɔ́ Nsyifunɔ ànɛ̂ nónó náh pɩ Nsyifunɔlɛ, pé náhnáh vi mɔ pɩ Yesu yõ sɛ̃́púlɛ. ");
INSERT INTO wib_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ǹtɛ Nsyifunɔ sɔkɔ nónó-á sõ̀ yahle sɛ̃́nɔ́lɛ Yesu wɛy yõ, pépi nɛ́káhbɩ́ kurki mɔ Yesu yõ sɛ̃́pú yõ. ");
INSERT INTO wib_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ǹtɛ képah fyé yõ, Pole ànɛ̂ Barnabasɩ tɔ̃ tɛ̃ à mo Yikonyumi sɔkɔ. Pé gbõ̀ sàhnyĩnɔ sõ̀ mɛ Tɛ̃̀ ǹgbɛ̃ yõ pè kɔ̃ pè n wɛkɩ nɩ̀sãhlɛ. Tɛ́ à sõ̀ mɛ pé yah tɛ̃ pè kɔ̃ pè gbǐl tyilɛ n pɩ, gbǐl nónó-á n wɛ̃kɩ nɛ, pǎh wɛlɔ nónónɛ n yo Liyel pèpɔrɩ pɩ́nɔ́ tyɩ́ sɔkɔ, gblɔ-á sélɛ. ");
INSERT INTO wib_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ǹtɛ kwil névye gbɛkɩ. Pé túkù sõ̀ mɛ mɔ Nsyifunɔlɛ, túkù mó mɛ mɔ Yesu tɛ̃ntõ̀ névyelɛ. ");
INSERT INTO wib_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Képah sɔkɔ, Nsyifunɔ ànɛ̂ nónó náh pɩ Nsyifunɔlɛ, à tahlɩ pé yõ̀tãmnɔ́ tyɩ́, pè wɛ̃ tyɩ́ mɔ nɛ, pé Pole ànɛ̂ Barnabasɩ fõh, pé mó pè minki ko dyêhlɛ. ");
INSERT INTO wib_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Ǹtɛ Pole ànɛ̂ Barnabasɩ-á pɔ pɩ̃ ké sɔkɔ, pè to sɔkɔ Lisitir kwil, ànɛ̂ Dɛrɩbɩ kwil, ànɛ̂ sé gbɔ̀plɔ kwlo sɔkɔ, Likawoni gbɛ̃̀nyah. ");
INSERT INTO wib_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Tɛ́ yɔ̃ sɔkɔ, à Nɩ̀vɩ̀nɩ̀ tirlɛ n yo n kɔ̃ nɛ́npɔ́. ");
INSERT INTO wib_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Tɛ́ dĩ́ yɔ́ lésõ mɛ Lisitir kwil, gbyẽ̂hnɛ kúnɔ́lɛ. À sõ̀ dubi sèkùkùlɛ, à náh tɛ̃ wɛ kɔ yah. ");
INSERT INTO wib_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Tɛ́ sõ yɔ́lɛ, Pole-á n wɛkɩ, kénɛ dĩ́ sõ̀ mɛ ǹ wɛynɛ n nohnɩ. Képah tɛ̃̀nɛ, Pole tyah dĩ́nɛ n yah díkídíkí. Tɛ́ wǎh kè wɛ nɛ Liyel yõ sɛ̃́nɔ́-á mɛ dĩ́ mɛ̀ tyɩ́ kɩ fɛ̃ dɛ́nmɔnɔ wɛ Liyel tyɩ́, ");
INSERT INTO wib_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","à yo ǹ tyɩ́ yĩ́npɔ̃́ ǹgbɛ̃nɛ nɛ: «Yuku n yĩn tómm á gbyẽ̂h yõ!» Képah sɔkɔ, dĩ́ núkú yɔkɔ syɩkɩ ǹ gbyẽ̂h yõ, à tyah n kɔ. ");
INSERT INTO wib_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Tɔ́wû-á képah tɛ̃̀ pɩ́nɔ́ wɛ sɛ̃́ Pole tyɩ́, pè tyah n yo wòhòh Likawoni tãn wɛy sɔkɔ nɛ ńkɛ̃́, tã̀n-á sé viri pɩ névyelɛ à tiki pɔ pé wrɔ́ dɛ́! ");
INSERT INTO wib_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Képah sɔkɔ, pè tõ̀ nɛ̂-á pè n ye Nsewusilɛ, pè képah yĩn dyɩ Barnabasɩ kɔ̃. Tɛ́ wɛy-á sõ̀ mɛ Pole wɔ gbõ̀ sɔkɔ sɛ̃́, pè kèyǎh yĩn dyɩ ǹmɔ kɔ̃, nɛ̂-á pè n ye Yɛrɛmɛsɩlɛ. ");
INSERT INTO wib_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Tɛ́ tõ̀ nɛ̂-á pè n ye Nsewusilɛ, ké wɔ̀kɔ̀ sõ̀ mɛ kwil dé-ńsah yah sɔkɔ. Ké lékwén nɛ́tɛ̃̂ dĩ́ mɛ nyéhpyɛ́nɩ̀ tɛ̃ pɔ kénɛ tõ̀ wɔ̀kɔ̀ yah ànɛ̂ yî fĩnɛ. Tɛ́ ǹmɔ ànɛ̂ tɔ́wû sõ̀ mɛ ké tyɩ́ nɛ, pé gbètòh mɔ Barnabasɩ ànɛ̂ Pole yõ. ");
INSERT INTO wib_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ǹtɛ Barnabasɩ ànɛ̂ Pole-á képah tɛ̃̀ noh sɛ̃́, pépi nónó-á Yesu tɛ̃ntõ̀ névyelɛ, pè pé fwɔ̀mɔlɔ yɔrɩ tɔkɩ yèkwɔrɩ tɛ̃̀ tyɩ́, tɛ́ to de tɔ́wû nɩyṍ mɛ yo tũ yĩ́npɔ̃́ ǹgbɛ̃nɛ nɛ: ");
INSERT INTO wib_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","«Á no, sɔ̃́ mɛ tɛ́ yé képahlɛ n pɩ? Névye ye ápi tɔlɛ, yépi tyɩ́ kɔ̃lɛ dò! Nɩ̀vɩ̀nɩ̀ tir ye á pɔ yó-ńsah yé tyɩ́ nɛ, yé yõ kɛ̃́ fal fal tã̀n nɔ́pi milki, yé mó vi mɔ Liyel wɛ̃̀kɩ̀ tɛ̃, ǹmɔ nɛ̂-á min nɛ́tɛ̃̂nɛ. Ǹmɔ ye mɔ yĩ̂nyõlɛ, ànɛ̂ sétáhlɛ, ànɛ̂ pnɛ yɔlɛ, à tahlɩ sé sɔkɔ yíyìn pól tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ǹgbòlɛ, Liyel mɛ̀ ye sõ̀ yɛ kwlo kwlo névye pól kɔ̃ pè n kɔ pé dyɔ dyɔ wã̀l yõ. ");
INSERT INTO wib_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ǹtɛ à mɛ ǹ gblɔ̌y dùkùlɛ n wɛ̃kɩ sɛ̃́ gbĩ́mɛgbĩ́ ǹ pèpɔrɩ pɩ́nɔ́ sɔkɔ. À mɛ pũ̀nɛ n pɩ n mɔ yélɛ n kɔ̃ à n wil yĩ̂nyõ, tɛ́ yé sèmukɔ kɔ̃ sè n pɛkɩ, tɛ́ yõke náhnáhlɛ yélɛ n kɔ̃ ànɛ̂ nɩ̀vɩ̀nɩ̀nɛ.» ");
INSERT INTO wib_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ǹtɛ wɛlɔ nɔ́pi fyé yónɔ́ yõ, Yesu tɛ̃ntõ̀ névye yah vyãh tɔ́wû yĩ́nínmɔ-ńsah nɛ, pè káh gbètòh mɔ pé yõ. ");
INSERT INTO wib_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ké légbĩ́ sɔkɔ, Nsyifunɔ yísyɔ́ wil Antyɔsyɩ kwil, Pisidi gbɛ̃̀nyah, ànɛ̂ Yikonyumi kwil, à pɔ nɛ́npɔ́. Pépi pɔ tɔ́wû vi tɛ̃ mɔ Polepi yõ, pè kɔ̃ pè yuku Polelɛ n minki dyêhlɛ nɛ páh ǹnɛ n min n ko. Képah náh, pè à yɔrɩ wilki sah kwil náh tĩ̀nnɛ, tɛ́ mɛ n sõ nɛ wǎh ku. ");
INSERT INTO wib_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ǹtɛ Yesu tõ̀ sã́hpú-á pɔ tuke mɔ ǹ tnɔ̂, à à mɔ gbɩ̃ gbĩ́ nɛ̂nɛ, à mɛ yuku tɛ́ de kwil sɔkɔ. Tɛ́ ké dĩndallɛ, à sɔkɔ ànɛ̂ Barnabasɩlɛ Dɛrɩbɩ kwil. ");
INSERT INTO wib_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Képah tɛ̃̀nɛ, pǎh kyɩ yĩni tɛ̃ Dɛrɩbɩ kwil, pè Nɩ̀vɩ̀nɩ̀ tir yo nɛ́npɔ́ tãn tyɩ́. Pé náhnáh mɛ sɛ̃ Yesu yõ, à pɩ ǹ tõ̀ sã́hpúlɛ. Képah náh, Polepi pé syɩ syɔ̃ Lisitir kwillɛ, ànɛ̂ Yikonyumi kwillɛ, à kyɩ de Antyɔsyɩ kwil, Pisidi gbɛ̃̀nyah sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Tɛ́ nɩ̀sãh ànɛ̂ sṍré ye sõ̀ pè n mɔ n kɔ̃ Yesu tõ̀ sã́hpú sɔkɔ nɛ, pè gbah n tɛ̃ pé sõnɔ sah yĩ́ĩ́ Yesu yõ gbĩ́mɛgbĩ́. Pè sõ̀ mɛ n yo pé tyɩ́ nɛ ńkɛ̃́, yèvyãhrɩ náhnáh dénwìlnɔ́ sɔkɔ-á pé kɩ de Liyel tɔ̃́rɩ́ mɛ́-ńsah sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Tɛ́ Yesu yõ sɛ̃́pú tĩ̀nkìnɔ́ nónó-á sõ̀ mɛ kwlo nɔ́pi pól sɔkɔ, Polepi sõ̀ yah tãm yísyɔ́ yah wilki sé sɔkɔ, à sah sé yõ. Tɛ́ níkì tɛ̃ à nírí pɩ pé tyɩ́, à pè dahbɩ Tɛ̃̀ ǹgbɛ̃ Yesu gbõ̀, pǎh sɛ̃ ǹmɔ nɛ̂ yõ. ");
INSERT INTO wib_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Képah náh, pè Pisidi gbɛ̃̀nyah kɔ kah, à kyɩ de Pãnfili gbɛ̃̀nyah sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Nɛ́npɔ́ sɔkɔ, pè Liyel wɛy yo Pɛrsyɩ kwil tãn tyɩ́, tɛ́ pyě yuku Atali kwil. ");
INSERT INTO wib_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Pǎh n yal nɛ́npɔ́, pè de krótókè ǹgbɛ̃ sɔkɔ, à yuku Antyɔsyɩ kwil, Siri gbɛ̃̀nyah sɔkɔ. Kénɛ kwil sɔkɔ ye sõ̀ pè pè dahbɩ Liyel gbõ̀ sɔkɔ, tõ̀ mɛ̀ pɩ yĩnnɛ, nɛ̂-á pè pɩ tɛ yɔ̀. ");
INSERT INTO wib_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Pǎh yĩni tɛ̃ Antyɔsyɩ sɔkɔ, pè Yesu yõ sɛ̃́pú tĩ̀nkì ye tuke. Tɛ́ Liyel-á pé yah tɛ̃, à ǹ tõ̀ pɩ dùkù nɛ̂nɛ, pè kè yãh pé tyɩ́; à tahlɩ wǎh ǹ yõ sɛ̃́nɔ́ wɛ̃̀kɩ̀ yɩkɩ mɔ névye tɔ kɔ̃ sɔ̃́, nónó náh pɩ Nsyifunɔlɛ. ");
INSERT INTO wib_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Képah náh, Polepi tɛ̃ pélɛ Antyɔsyɩ sɔkɔ, à mo. ");
INSERT INTO wib_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Képah tɛ̃̀nɛ, díbí yísyɔ́ wil Nsyude gbɛ̃̀nyah, à pɔ Antyɔsyɩ kwil sɔkɔ. Tɛ́ pɔ tyah Yesu yõ sɛ̃́púlɛ n kwɔ nɛ ńkɛ̃́, nɛ́ pè náh kõ̀kè kõ sɔ̃́-á Moyisi tyi kõ̀nsàhnɔ́ kè yo sah, pè náh fɛ̃ pwáhnmɔnɔ wɛ n pi. ");
INSERT INTO wib_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Ǹtɛ Pole ànɛ̂ Barnabasɩ náh fɛ̃ syi. Kǎh pɩ sɛ̃́, yékã̂b ǹgbɛ̃ de pépi ànɛ̂ díbí nɔ́pi wrɔ́. Képah sɔkɔ, kè yah tɔkɔ nɛ Pole, ànɛ̂ Barnabasɩ, ànɛ̂ pépi túkù-á kɩ dɔkɔ yuku Yerusalɛmɩ kwil. Pǎh kɩ kyɩ wil Yesu tɛ̃ntõ̀ névye ànɛ̂ Yesu yõ sɛ̃́pú yah tãm tyɩ́, pè yĩ mɛ̀ yah wah. ");
INSERT INTO wib_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Tɛ́ mɛ yòhnɩ̀nmɔnɔ pɩ Polepi tyɩ́ kénɛ kɔ́lɔ́ mɛ̀ yĩnnɛ. Polepi-á n sɔkɔ, pè syɔ̃ sɔkɔ Fenisi gbɛ̃̀nyah ànɛ̂ Samari gbɛ̃̀nyah sɔkɔ, mɛ névye tyɩ́lɛ n yãh pé tyɩ́, nónó-á vi mɔ Liyel wɛ̃̀kɩ̀ tɛ̃, tɛ́ Nsyifunɔ náh pélɛ. Kè pɩ nɩ̀vɩ̀nɩ̀ ǹgbɛ̃nɛ Yesu yõ sɛ̃́pú pól tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Pǎh kyɩ yĩni tɛ̃ Yerusalɛmɩ kwil, Yesu yõ sɛ̃́pú, ànɛ̂ pé yah tãm, ànɛ̂ Yesu tɛ̃ntõ̀ névye mɛ pè tɛ̃ pallɛ. Képah sɔkɔ, Liyel-á Polepi yah tɛ̃ pè ǹ tõ̀ pɩ dùkù nɛ̂nɛ, Polepi kè yãh pé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ǹtɛ Farisiyɛ̃ névye nónó-á vi mɔ pɩ Yesu yõ sɛ̃́púlɛ, pépi túkù yuku tyah n yo nɛ ńkɛ̃́, nónó-á sɛ̃ Yesu yõ, tɛ́ Nsyifunɔ náh pélɛ, pǎh yɩ̃nɛ pè kõ̀kè kõ; ànɛ̂ pǎh yɩ̃nɛ kyɩ̃̀nmɔnɔlɛ pè Moyisi tyi kõ̀nsàhnɔ́lɛ nɛ n pɩ. ");
INSERT INTO wib_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Képah tɛ̃̀ sɔkɔ, Yesu tɛ̃ntõ̀ névye ànɛ̂ Yesu yõ sɛ̃́pú yah tãm wɛ̃ wɛ yĩ mɛ̀ tyɩ́ sɔkɔ, à kè yah wɛ̃ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Kè sõ̀ pɩ yĩ́ĩ́ yékã̂b ǹgbɛ̃nɛ pé wrɔ́, fɔ́ɔ́ Pyɛrɩ pɔ yuku yĩn, tɛ́ yo pé tyɩ́ nɛ ńkɛ̃́: «Ń yṹnpyé, yépi ńtɛ̃ se kè pɩ̃ nɛ Liyel-á ńmɔ yah wilki yé sɔkɔ di mónɔ́lɛ tɛ́! À nɛ mé Nɩ̀vɩ̀nɩ̀ tir yo névye tyɩ́, nónó náh pɩ Nsyifunɔlɛ, pè kɔ̃ pè kè wɛ noh, pè mó sɛ̃ Yesu yõ. ");
INSERT INTO wib_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ǹtɛ Liyel nɛ̂-á névye fɔkɔ sõnɔlɛ n pnɛ, ǹmɔ ye ǹ Mirkilɛ pè kɔ̃, sɔ̃́-á lésõ à kélɛ ápi tɔ kɔ̃, à kè wɛ̃kɩ nɛ páh pépi tɔ fɛ̃ syi. ");
INSERT INTO wib_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","À náh wǎhkɩ̀ pɩ ápi ànɛ̂ pépi wrɔ́. Pǎh sɛ̃ ǹ yõ, képah ye à pé nnɔ tɔ̃ sah. ");
INSERT INTO wib_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Tɛ́ núkúnúkú, sɔ̃́ pɩ tɛ́ yé Liyel vyãh sõ̀lɛ n noh, à tɔ́kɔ́pêllɛ n sah Yesu yõ sɛ̃́pú yõ, nónó-á ápi náh tãn ànɛ̂ ápi ńtɛ̃ náh tɛ̃ wɛ sè twah yah? ");
INSERT INTO wib_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ǹtɛ ápi sɛ̃ ké yõ nɛ áyáh pwáhnmɔnɔ wɛ Tɛ̃̀ ǹgbɛ̃ Yesu pèpɔrɩ gbõ̀ yõ, no nɔ́pi tyɩ́ kɔ̃lɛ.» ");
INSERT INTO wib_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Kǎh pɩ sɛ̃́, no pól tɛ̃ syɩ́syɩ́, tɛ́ pé ní kwɔ Pole ànɛ̂ Barnabasɩ tyɩ́. Képah sɔkɔ, Liyel-á syɔ̃ Polepi tyɩ́, à gbǐl tyi nónó pɩ névye tyɩ́, nónó náh pɩ Nsyifunɔlɛ, Polepi sè yãh pé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Pǎh sè yãh tɛ gbĩ́ nɛ̂nɛ, Nsyakɩ wɛy tɔkɔ, tɛ́ nɛ ńkɛ̃́: «Ń yṹnpyé Nsyifunɔ, yé noh ń tyɩ́ yɔ̀. ");
INSERT INTO wib_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Á pól yĩ́ yah ye Simo-Pyɛrɩ kè yo nɛ ńkɛ̃́, ǹgbò dùkù-á Liyel kè yah tɔkɔ, à nósyɔ́ yah wilki névye sɔkɔ, nónó náh pɩ Nsyifunɔlɛ, à pɩ ǹ nolɛ. ");
INSERT INTO wib_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Tɛ́ wɛy mɛ̀ mó tɔ̃ mɛ yɩ̃́nɛ́nɔ́lɛ Liyel tɛ̃ntõ̀ syínyopu wɛlɔlɛ. Yé yah, kè mɛ wã́rkɩ́nsàhnɔ́lɛ nɛ, ");
INSERT INTO wib_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Tɛ̃̀ ǹgbɛ̃ Liyel-á nɛ ńkɛ̃́: ‹Képah náh, mé kɩ ń syɩ pɔ Davidi kéte sɔ́nɔ́ tɔ̃ mɔ. Mé kɩ ǹ kéntíkínì tɔ̃ mɔ kɩ kè yilki pallɛ. ");
INSERT INTO wib_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Képah sɔkɔ, kèkõyṍ névye tɛ́lɔ́ pól kɩ yuku ńnɛ n yah n kɔ̃. Gbɩ yõ, kwlo kwlo névye pól ye kɩ n yah n kɔ̃ n pi ńnɛ, máh pépi nónó ye nɛ pè pɩ ń tyɩ́lɛ.› Sɛ̃́ ye Tɛ̃̀ ǹgbɛ̃ Liyel yo, ǹmɔ nɛ̂-á tyi nɔ́pi wɛ̃kɩ ");
INSERT INTO wib_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","di mónɔ́lɛ. ");
INSERT INTO wib_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Képah yĩnnɛ, ńmɔ Nsyakɩ tɛ̃̀ sõnɔ sɔkɔ, névye nónó-á vi mɔ Liyel tyɩ́ yõ, tɛ́ Nsyifunɔ náh pélɛ, á náh yɩ̃nɛ à tyilɛ n tɛ̃ n tah pé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ǹtɛ á ye sɛ́bɛ́y wãrkɩ n tɛkɩ n mɔ pé tyɩ́ nɛ, pè pé gblɔ̌ynɛ n tɛ̃ sãh fálnɔ́ yîlɛ, ànɛ̂ fɔ̀fɩ́kɩ̀lɛ, ànɛ̂ tṍ kwɛ́-ńkɛ̃̂ kwáhkókè kɔ̀lɛ, ànɛ̂ tṍnɛ, sè kɔ̃ sè káh pɔ pè silki. ");
INSERT INTO wib_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Yé yah kɛ̀, à tɔkɔ ǹgbò dùkù tyɩ́, kénɛ tyi ye ńkɛ̃́nɛ Moyisi tyi kõ̀nsàhnɔ́ sɔkɔ, pě névyelɛ n kwɔ mɩ mɩ yòh sõnɔ́ póllɛ kwlo kwlo pól Nsyifunɔ Liyel ní-ńtã̂n vɩ̀ sɔkɔ.» ");
INSERT INTO wib_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Képah sɔkɔ, Yesu tɛ̃ntõ̀ névye, ànɛ̂ Yesu yõ sɛ̃́pú yah tãm, ànɛ̂ Yesu yõ sɛ̃́pú tĩ̀nkì pól yo sah núkú yõ nɛ, páh kɩ nósyɔ́ yah wilki pé wrɔ́, tɛ́ kɩ pépi tɛkɩ mɔ Pole ànɛ̂ Barnabasɩlɛ Antyɔsyɩ kwil. Képah tɛ̃̀nɛ, Nsyudasɩ, nɛ̂-á pè n ye Barsabasɩlɛ, pè mɛ ǹmɔ ànɛ̂ Silasɩ yah wilki. Pé nímí póllɛ, névye sõ̀ mɛ yõ̀yénnɛ n sah pé yõ. ");
INSERT INTO wib_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Pè mɛ tɛ̃ntõ̀ sɛ́bɛ́y yɔ́ wãrkɩ à dahbɩ pé gbõ̀, nɛ̂ sɔkɔ-á kè mɛ yónɔ́lɛ nɛ ńkɛ̃́: «Á yṹnpyé yépi nónó-á Nsyifunɔ náh yélɛ, tɛ́ mɛ Antyɔsyɩ, Siri gbɛ̃̀nyah sɔkɔ, à tahlɩ Siri gbɛ̃̀nyah kwlo tɛ́lɔ́ tyɩ́, ànɛ̂ Silisi gbɛ̃̀nyahlɛ; ápi Yesu tɛ̃ntõ̀ névye ànɛ̂ yé yṹnpyé Yesu yõ sɛ̃́pú yah tãm ye n wɛkɩ yé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Á kè noh nɛ, nósyɔ́-á wil ápi sɔkɔ, à kyɩ pé wɛlɔlɛ yé lékã́m vye fɛ̃kɩ, à yé mɔ sah fɔ́kɔ́sõnɔ sɔkɔ. Tɛ́ ápi náh se mó tɔ̃ tõ pélɛ. ");
INSERT INTO wib_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Képah ye, á kè yah tɔkɔ wɛ̃ tyɩ́ nɛ, áyáh kɩ névye wilki tɛkɩ mɔ yé tyɩ́. Pè kɩ n pɔ n pi wɛ̃ tyɩ́ ànɛ̂ á nɩ̀gbɛ̀kɩ̀ névye Barnabasɩ ànɛ̂ Polelɛ, ");
INSERT INTO wib_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","pépi nónó-á pé min mɔ kũ kɔ̃ Tɛ̃̀ ǹgbɛ̃ Yesu Krista tõ̀ yĩnnɛ. ");
INSERT INTO wib_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Nsyudasɩ ànɛ̂ Silasɩ ye á n tɛkɩ n mɔ yé tyɩ́. Tyi nónó-á á wãrkɩ tɛkɩ mɔ yé tyɩ́, pè kɩ pɔ sè tɔ̃ yo yé tyɩ́ vyãhlɛ. ");
INSERT INTO wib_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Liyel Mirki ànɛ̂ ápi ye yah tɔkɔ kélɛ nɛ, á káh tɔ̃ tyi yísyɔ́ kõ sah yé kɔ̃, à wil tyi nɔ́pi tyɩ́ sɔkɔ yɔ̀, sépi nónó-á yɩ̃nɛ pɩ́nɔ́lɛ káhkáh: ");
INSERT INTO wib_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Yé yé gblɔ̌ynɛ n tɛ̃ sãh fálnɔ́ kɔ̀lɛ, ànɛ̂ tṍnɛ, ànɛ̂ tṍ kwɛ́-ńkɛ̃̂ kwáhkókè kɔ̀lɛ, ànɛ̂ fɔ̀fɩ́kɩ̀ pɩ́nɔ́lɛ. Yâh yé gblɔ̌ynɛ n tɛ̃ n yĩ́ĩ́ sépi pól pɩ́nɔ́lɛ, yé mɛ n pɩ plɛ. Yé tɛ̃̀nɔ!» ");
INSERT INTO wib_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Képah náh, pè wɛ̃̀kɩ̀lɛ tɛ̃ntõ̀ névye kɔ̃ pè sɔkɔ à kyɩ de Antyɔsyɩ kwil. Pè kyɩ Yesu yõ sɛ̃́pú tɔ́wû tuke mɔ, tɛ́ tɛ̃ntõ̀ sɛ́bɛ́y mɛ̀nɛ pè kɔ̃. ");
INSERT INTO wib_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Pǎh kè kar, ké sɔkɔ tyíyónɔ́ sṍré mɔ pé sɔkɔ, kè pɩ nɩ̀vɩ̀nɩ̀nɛ pé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Képah sɔkɔ, Nsyudasɩ ànɛ̂ Silasɩpi tɔ-á sõ̀ pɩ Liyel tɛ̃ntõ̀ syínyopulɛ sɛ̃́, pépi tyah nolɛ n vi n mɔ, mɛ tyi náhnáhlɛ n yo pé tyɩ́, à sṍrélɛ n mɔ pé sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Pǎh sèpĩ̀n yísyɔ́ pɩ nɛ́npɔ́, képah náh, no pè fĩn mɔ, tɛ́ wɛkɩ pé tyɩ́ nɛ, pè de lènɔlɛ pé tṍpú tĩ̀nnɛ.  ");
INSERT INTO wib_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Tɛ́ Silasɩ wɔ mɛ nɛ, péwɔ-á kɩ wũ nɛ́npɔ́. ");
INSERT INTO wib_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Ǹtɛ Pole ànɛ̂ Barnabasɩ tɛ̃̀ wɔ sõ̀ mɛ tɛ̃ Antyɔsyɩ sɔkɔ. Pépi ànɛ̂ névye náhnáh yísyɔ́ sõ̀ mɛ nolɛ n kwɔ, tɛ́ mɛ Tɛ̃̀ ǹgbɛ̃ Nɩ̀vɩ̀nɩ̀ tirlɛ n yo. ");
INSERT INTO wib_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Sèpĩ̀n yísyɔ́-á sɔkɔ sɛ̃́, Pole yo Barnabasɩ tyɩ́ nɛ, páh Tɛ̃̀ ǹgbɛ̃ wɛy yo kɔ̃ kwlo nónó pól sɔkɔ, à yɛ pé pé syɩ kyɩ yah pé yṹnpyé Yesu yõ sɛ̃́pú tyɩ́ kénɛ kwlo sɔkɔ, pé tyɩ́-à kɩ mɛ dùkù nɛ̂nɛ. ");
INSERT INTO wib_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Képah sɔkɔ, Nsyɔ̃ nɛ̂-á pè n ye Markɩlɛ, Barnabasɩ sõ̀ mɛ ké tyɩ́ nɛ, pé ǹ tɔ tɛ̃ pé sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Ǹtɛ Pole wɔ náh sõ̀ mɛ ké tyɩ́ nɛ pé sɔkɔ ǹnɛ; ǹmɔ nɛ̂-á lésõ ǹ gbɛ wil pé sɔkɔ Pãnfili gbɛ̃̀nyah dùkù sɔkɔ, tɛ́ à náh tɔ̃ sõ̀ mɛ n kyɩ n pɔ pélɛ pé tõ̀ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Kǎh pɩ sɛ̃́, yékã̂b ǹgbɛ̃ de Pole ànɛ̂ Barnabasɩ wrɔ́, pè mɛ gbɛkɩ. Barnabasɩ mɛ Nsyɔ̃-Markɩ tɛ̃ tahlɩ ǹ gblɔ̌y tyɩ́, pè de krótókè ǹgbɛ̃ yɔ́ sɔkɔ à sɔkɔ Syipri gbɛ̃̀nyah. ");
INSERT INTO wib_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Ǹtɛ Pole wɔ mó Silasɩ yah wilki. Tɛ́ Yesu yõ sɛ̃́pú-á nírí pɩ pé tyɩ́, à pè dahbɩ tɛ Tɛ̃̀ ǹgbɛ̃ gbõ̀ sɔkɔ gbĩ́ nɛ̂nɛ, pè mɛ sɔkɔ wɛ̃ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Pè Siri gbɛ̃̀nyah ànɛ̂ Silisi gbɛ̃̀nyah pól kɔ kɔ̃, à Liyel yõ sɛ̃́nɔ́ sṍrélɛ n mɔ n yuku Yesu yõ sɛ̃́pú tĩ̀nkìnɔ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Képah náh, Polepi-á wil Siri ànɛ̂ Silisi gbɛ̃̀nyah sɔkɔ, pè yɔ̃ sɔkɔ Dɛrɩbɩ kwil. Pǎh wil nɛ́npɔ́, pè yuku Lisitir kwil. Pè kyɩ Yesu tõ̀ sã́h-ò yɔ́ wɛ nɛ́npɔ́ pè n ye Timotelɛ. Ǹ yṹnɛ, Nsyifu nɛy ye sõ̀ ǹnɛ, nɛ̂-á mɛ Yesu wɛ̃̀kɩ̀lɛ n kɔ, tɛ́ ǹ sú mɛ Krɛkɩ nɛynɛ. ");
INSERT INTO wib_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Tɛ́ Yesu yõ sɛ̃́pú nónó-á sõ̀ mɛ Lisitir sɔkɔ ànɛ̂ Yikonyumi kwil, pè sõ̀ mɛ Timote yĩ́ngbɩ́lɛ n yo. ");
INSERT INTO wib_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Képah sɔkɔ, Pole sõ̀ mɛ ké tyɩ́ nɛ pé à tɛ̃ sɔkɔ pé kɔ́lɔ́ sɔkɔ. Tɛ́ Nsyifunɔ nónó-á sõ̀ mɛ kénɛ kwlo sɔkɔ, pè sõ̀ pɩ̃ nɛ, Krɛkɩ nɛy-á Timote súlɛ. Pépi yĩnnɛ, Pole mɛ Timote kõ. ");
INSERT INTO wib_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Képah sɔkɔ, Polepi-à fyɔ̀ n sɔkɔ kwlo nónó sɔkɔ, Yesu tɛ̃ntõ̀ névye ànɛ̂ Yerusalɛmɩ kwil Yesu yõ sɛ̃́pú yah tãm-á tyi nónó yah tɔkɔ, pě sélɛ n yãh kénɛ kwlo Yesu yõ sɛ̃́pú tyɩ́ nɛ, pè nɛ n kɔ sé wã̀l yõ. ");
INSERT INTO wib_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Kǎh pɩ sɛ̃́, Yesu yõ sɛ̃́pú tĩ̀nkìnɔ́ sõ̀ mɛ n gbah n sɛ̃ Liyel yõ, tɛ́ wãn tɔ̃ mɛ n mɔ pé nɛ́dán tɔ yõ sõmɛsṍ. ");
INSERT INTO wib_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Képah náh, Polepi sõ̀ mɛ ké tyɩ́ nɛ pé kyɩ Liyel wɛy yo Asi gbɛ̃̀nyah sɔkɔ, ǹtɛ Liyel Mirki kè yahle pé tyɩ́. Kǎh pɩ sɛ̃́, pè mɛ kah syɔ̃ Frisyi gbɛ̃̀nyah ànɛ̂ Kalasi gbɛ̃̀nyahlɛ. ");
INSERT INTO wib_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Pǎh kyɩ yĩni tɛ̃ n tɛ Misi gbɛ̃̀nyahlɛ, pè tɔ̃ kè yah tɔkɔ nɛ, páh kɩ yuku Bitini gbɛ̃̀nyah. Ǹtɛ Yesu Mirki kè yahle pé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Kǎh pɩ sɛ̃́, pè Misi kɔ kah, à tiki yuku Turasɩ kwil. ");
INSERT INTO wib_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Tɛ́ lékã̂hnɛ, Pole wɛ̃́kɩ́nɔ́ yɔ́ wɛ. Wɛ̃́kɩ́nɔ́ mɛ̀ sɔkɔ, à Masedonɩ gbɛ̃̀nyah dĩ́ yɔ́ wɛ yĩ́nntɛ̃̀nɔ́lɛ, tɛ́ tɛ̃̀ mɛ ǹnɛ n ni nɛ ńkɛ̃́, à pɔ Masedonɩ sɔkɔ, à pɔ pépi yohnɩ n mɔ. ");
INSERT INTO wib_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pole-á fyɔ̀ wɛ̃́kɩ́nɔ́ mɛ̀ wɛ sɛ̃́, á mɛ kè pɩ̃ yĩ́ĩ́ nɛ, Liyel-á ye álɛ nɛ, á kyɩ pé Nɩ̀vɩ̀nɩ̀ tir yo Masedonɩ tãn tyɩ́. Kǎh pɩ sɛ̃́, á núkú á vi nɛ áyáh kɩ sɔkɔ nɛ́npɔ́. ");
INSERT INTO wib_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Képah sɔkɔ, á de krótókè ǹgbɛ̃ yɔ́ sɔkɔ Turasɩ kwil, à yɔ̃ sɔkɔ gbɛ̃̀nyah yɔ́ sɔkɔ, nɛ̂-á mɛ pnɛ yɔ nɩyṍ pè n ye Samotrasɩlɛ, á náh kwɔ dah fɩ̃́ yɔ́ ńtɛ̃ sɔkɔ. Tɛ́ ké dĩndallɛ, á yuku Neyapolisi kwil. ");
INSERT INTO wib_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Áyáh yal nɛ́npɔ́, á yuku kwíl-ǹgbɛ̃ yɔ́ sɔkɔ pè n ye Filipilɛ, Masedonɩ gbɛ̃̀nyah sɔkɔ. Kénɛ kwil yõ̀tɔ̃rɩ́ sõ̀ mɛ Wrome tãn gbõ̀. Á mɛ tɛ̃ nɛ́npɔ́, à sèpĩ̀n yísyɔ́ pɩ. ");
INSERT INTO wib_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Nsyifunɔ mɩ mɩ yòh sõ-á pɔ nɔ, á kè sõ nɛ, pé Liyel ní-ńsah-á kɩ wɛ yɔ́ngbalɩ sɔkɔ. Kǎh pɩ sɛ̃́, á wil kwil nɩyṍ, à nɛ́npɔ́ nyáh sõ. Á kyɩ syɔ́ yísyɔ́ wɛ tùkènmɔntɛ̃̀nɔ́lɛ nɛ́npɔ́. Á mɛ kɔ̃ tɛ̃ pé tnɔ̂, à yã́hkɩ̀ yãh pélɛ Liyel wɛy tyɩ́ yõ. ");
INSERT INTO wib_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Tɛ́ pi yɔ́ sõ̀ mɛ syɔ́ nɔ́pi sɔkɔ pè n ye Lidilɛ. Fwɔ̀sãhlɔ dɛ́nkɔ́kɔ́nɩ̀ gbɔ̀ yɩ̃́-ò ye sõ̀ ǹnɛ. À n wil Tyatiri kwil, tɛ́ à sõ̀ mɛ Nsyifunɔ Liyel wɛ̃̀kɩ̀lɛ n kɔ. Tɛ́ Tɛ̃̀ ǹgbɛ̃ mɛ wɛkɩ pi mɛ̀ nɩ sɔkɔ à kɔ̃ à ǹ níkí kwɔ, à Pole wɛlɔ noh pallɛ. ");
INSERT INTO wib_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Kǎh pɩ sɛ̃́, ǹmɔ ànɛ̂ ǹ kéte tãn pól mɛ wèlnwìlkìnɔ́ wɛ ni sɔkɔ. Képah sɔkɔ, pi mɛ kè yah kɔ̃ ápi tyɩ́ nɛ, áyâh kɩ mɛ sɛ̃ ké yõ nɛ péwɔ-á pɩ Tɛ̃̀ ǹgbɛ̃ Yesu yõ sɛ̃́-òlɛ, á pɔ n kyɩ n twah pé tyɩ́ pé gbô. Tɛ́ á gbah tɛ̃ pópó, á pɔ sah ǹ tyɩ́ yõ. ");
INSERT INTO wib_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Képah sɔkɔ, sõ yɔ́lɛ á mɛ n yuku nírí pɩ́-ńsah, tɛ́ tõ̀npɩ pípír yɔ́ pɔ á yohnɩ. Sétõ sõ̀ mɛ kénɛ pípír gbil à kɔ̃ à tyísnɔ́lɛ n wɛ n yo. À sõ̀ mɛ pɔ́ náhnáhlɛ n wɛ ǹ yõ̀tãmnɛ n kɔ̃ kénɛ tyísnɔ́ wɛ́nyonɔ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Kénɛ pípír mɛ yuku, à ápi ànɛ̂ Pole sõ̀ tɛ̃, tɛ́ mɛ yo tũ léyy no tyɩ́ nɛ ńkɛ̃́, díbí nɔ́pilɛ, yõ̀tah Liyel tõ̀npɩbɩ-á pélɛ. Pwáhnmɔnɔ wɛ̃̀kɩ̀ tyɩ́-á pè pɔ n yo pé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","À sõ̀ mɛ képah tɛ̃̀nɛ n pɩ sɛ̃́, sèpĩ̀n náhnáh sɔkɔ. Kǎh pɔ Pole gblɔ́lɛ n vyãh, à ǹ yah vi yo sétõ mɛ̀ tyɩ́ nɛ ńkɛ̃́, Yesu Krista yĩn yõ, à pípír mɛ̀ fĩn mɔ. Wǎh yo sɛ̃́, nɛ́npɔ́ swɔ sétõ núkú pípír fĩn mɔ. ");
INSERT INTO wib_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Képah sɔkɔ, pípír yõ̀tãm-á kè wɛ nɛ, pé sõnɔ-á sõ̀ mɛ pɔ́ nɛ̂ wɛ́nɔ́ yõ ǹmɔ gbõ̀ yõ kǎh kɩ yĩn mɔ, pè Pole ànɛ̂ Silasɩ tɛ̃, tɛ́ yuku pélɛ yõ̀tãm tyɩ́, tɔ́wû tùkè-ǹsah sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Képah náh, pè mɛ kyɩ pélɛ Wrome tãn yísyɔ́ tyɩ́ nónó-á pé yõ̀tãmnɛ, tɛ́ kyɩ tyah n yo nɛ ńkɛ̃́, díbí nɔ́pi-á mɛ fɛ̃̀kɩ̀nɔ́lɛ n pɩ pépi kwil. Nsyifunɔ-á pélɛ, ");
INSERT INTO wib_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","tɛ́ pǎh mɛ pɔ wã̀l yísyɔ́lɛ névyelɛ n kwɔ nónó-á sé wã̀l náh mɛ pépi Wrome tãn ńtɛ̃ tyɩ́ kɩ sè fɛ̃ syi, képah náh pɩ, kɩ sè pɩ n pi. ");
INSERT INTO wib_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Képah tɛ̃̀nɛ, tɔ́wû tɔ núkú yuku Polepi yõ. Yõ̀tãm nɔ́pi mɛ pè kɔ̃ pè Polepi flɔ dɛ, tɛ́ nɛ pè pè ko yèfõhlɛ. ");
INSERT INTO wib_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Képah sɔkɔ, pǎh yèfõh yɩ̃́ náhnáhlɛ pè ko tɛ, pè pè dah mɔ wɔ̀kɔ̀npèkè sɔkɔ, tɛ́ yo ké syɩ́kɩ́-ò dĩ́ tyɩ́ nɛ, à pélɛ n kyɔmɩ pallɛ. ");
INSERT INTO wib_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Dĩ́-á fyɔ̀ képah noh sɛ̃́, à mó pè tɛ̃ dah mɔ wɔ̀kɔ̀npèkè nɩyṍ wɔ̀kɔ̀ sɔkɔ, tɛ́ sésár kârn mɔ pé gbyẽ̂h tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ǹtɛ lénɩ mɔ́nɔ́ wrɔ́ sɔkɔ, Pole ànɛ̂ Silasɩ sõ̀ mɛ nírílɛ n pɩ, tɛ́ mɛ yɩ̀lɛ n gbɩ à Liyel yĩnnɛ n gbilki, tɛ́ wɔ̀kɔ̀npèkè sɔkɔ névye tɛ́lɔ́ mó mɛ n nohnɩ pé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Képah tɛ̃̀nɛ, sétáh syahrɩ ǹgbɛ̃ núkú pɩ nɛ́npɔ́ swɔ, à wɔ̀kɔ̀npèkè sètyah yike. Ké vɩ̀ yey pól núkú yɩkɩ mɔ, ké sɔkɔ névye pól gbyẽ̂h sɔkɔ kârnnɔ́ pól kɔ̃lɩ kwɛ. ");
INSERT INTO wib_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Wɔ̀kɔ̀npèkè syɩ́kɩ́-ò dĩ́-á pópó dɔ yuku, tɛ́ ké vɩ̀ yey wɛ yɩ́kɩ́nmɔnɔlɛ sɛ̃́, à wɛ nɛ ké sɔkɔ névye-á to wil. Képah tɛ̃̀nɛ, à núkú ǹ kèkírkì yɔrɩ dɛ nɛ, pé pé gblɔ̌y ko mɔ. ");
INSERT INTO wib_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ǹtɛ Pole mɛ yo mɔ ǹ tyɩ́ yĩ́npɔ̃́ ǹgbɛ̃nɛ nɛ, à káh dlo yɔ́ ńtɛ̃nɛ ǹ gblɔ̌y nɔ, pé pól-á mɛ ásõ̂. ");
INSERT INTO wib_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Képah sɔkɔ, wɔ̀kɔ̀npèkè syɩ́kɩ́-ò dĩ́ pè kɔ̃ pè pɔ fɔ̀tnɔ̀lɛ à kɔ̃, à de yuku súú wɔ̀kɔ̀npèkè nɩyṍ wɔ̀kɔ̀ sɔkɔ, tɛ́ ǹ gbètukunɔ di Pole ànɛ̂ Silasɩ yah wílsyahrɩ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Tɛ́ mɛ pè tɛ̃ wil kégbɔ́, tɛ́ pè piki yah nɛ, pé nɛ́nkyɩ́bɩ́, sɔ̃́ se pé yɩ̃nɛ pé pɩ pé mó pwáhnmɔnɔ wɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Pè mɛ yo ǹ tyɩ́ nɛ: «Sɛ̃ Tɛ̃̀ ǹgbɛ̃ Yesu yõ, á kɩ pwáhnmɔnɔ wɛ, áwɔ ànɛ̂ á nolɛ.» ");
INSERT INTO wib_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Képah sɔkɔ, Polepi Tɛ̃̀ ǹgbɛ̃ Yesu wɛy yo ǹmɔ ànɛ̂ ǹ gbô tãn pól tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Dĩ́ mɛ Polepi tɛ̃ légbĩ́ mɛ̀ ó sɔkɔ lékã̂hnɛ, à kyɩ pé nɩ́y wu; tɛ́ nɛ́npɔ́ swɔ, ǹmɔ ànɛ̂ ǹ gbô tãn pól mɛ wèlnwìlkìnɔ́ wɛ ni sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Képah náh, à Pole ànɛ̂ Silasɩ tɛ̃ yuku ǹ gbô sɔkɔ, à kyɩ yõkelɛ pè kɔ̃ pè yõ. Tɛ́ ǹmɔ ànɛ̂ ǹ no pól nɩ sõ̀ mɛ vɩ yĩ́ĩ́ pé wɛ́nsɛ̃nɔ yĩnnɛ Liyel yõ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Képah sɔkɔ, tyah-á pɔ dal, yõ̀tãm nɔ́pi tɛ̃ntõ̀ névye tɛkɩ mɔ nɛ, pè kyɩ yo wɔ̀kɔ̀npèkè syɩ́kɩ́-ò dĩ́ tyɩ́ nɛ, à díbí nɔ́pi fĩn mɔ. ");
INSERT INTO wib_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Dĩ́ mɛ kyɩ kè yo Pole tyɩ́ nɛ ńkɛ̃́, yõ̀tãm-á tɛ̃ntõ̀ mɔ pé tyɩ́ nɛ, pé pè fĩn mɔ. Kǎh pɩ sɛ̃́, núkúnúkú pǎh kɩ fɛ̃ wil kɩ n yuku yèvɩnɩ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ǹtɛ Pole mɛ pè syah nɛ, pépi nónó-á gbõ̀ mɔ yõ Wrome tãn tyɩ́, pépi kó pè tɛ̃ ko tɔ́wû yĩ́ yah pé tùkè-ǹkɛ̃̂nɛ; tɛ́ pé dah mɔ wɔ̀kɔ̀npèkè sɔkɔ nɩ? Tɛ́ núkúnúkú, pè tɔ̃ mɛ n yah n kɔ̃ pé wìlkìnfĩnnmɔ-ńsahlɛ sètĩ̀n sõ̀ sɔkɔ nɩ? Képah náh fɛ̃ n pɩ n pi dɛ́! Ńkɛ̃́, fɔ́ɔ́ pé dáhnmɔpu-á kɩ pɔ pé fĩn mɔ pé gblɔ̌y. ");
INSERT INTO wib_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Képah tɛ̃̀nɛ, tɛ̃ntõ̀ névye nɔ́pi mɛ pé syɩ kyɩ wɛlɔ nɔ́pi yo yõ̀tãm nɔ́pi tyɩ́. Pépi-á képah tɛ̃̀ noh sɛ̃́ nɛ, Pole ànɛ̂ Silasɩlɛ, Wrome tãn gbõ̀nmɔ̀nyõbe-á pélɛ, tíkí pè tɛ̃. ");
INSERT INTO wib_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Pè pɔ gblɔ̌y yɛ yah kɔ̃ Polepi tyɩ́, tɛ́ pè fĩn mɔ, tɛ́ mɛ pè ni nɛ pè wil kwil sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Polepi-á wil wɔ̀kɔ̀npèkè sɔkɔ, pè yuku Lidi tĩ̀nnɛ. Pǎh kyɩ Yesu yõ sɛ̃́pú wɛ, pè sṍré mɔ pé sɔkɔ tɛ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Képah náh, Polepi syɔ̃ Anfipolisi kwil ànɛ̂ Apɔlɔnɩ kwil, à kyɩ de Tesaloniki kwil sɔkɔ. Nsyifunɔ Liyel ní-ńsah wɔ̀kɔ̀ yɔ́ sõ̀ mɛ nɛ́npɔ́. ");
INSERT INTO wib_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Képah sɔkɔ, Pole-á sõ̀ ńkɛ̃́nɛ kélɛ n pɩ sɔ̃́, à tɔ̃ kyɩ yã́hkɩ̀ yãh Nsyifunɔlɛ Liyel wɛy sɛ́bɛ́y sɔkɔ tyi yõ pé Liyel ní-ńsah wɔ̀kɔ̀ sɔkɔ. À képah tɛ̃̀ pɩ syɩ sɛ̃́ wɛ̃ tyɩ́ kɛ tɔ̃́nɔ́, pé mɩ mɩ yòh sõnɔ́lɛ. ");
INSERT INTO wib_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","À sõ̀ mɛ ké yahlɛ n yo pé tyɩ́, à pélɛ n wɛ̃kɩ nɛ ńkɛ̃́: «Pwáhnmɔ-ò sõ̀ yɩ̃nɛ à pɔ yèvyãhrɩ pɩ ku sɛ̃́, Liyel mó à yilki mɔ. Yesu nɛ̂ tyɩ́-á mé n yo yé tyɩ́ yɔ̀, ǹmɔ ye kénɛ pwáhnmɔ-òlɛ.» ");
INSERT INTO wib_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Képah sɔkɔ, Nsyifunɔ túkù sah ǹ tyɩ́ yõ, ànɛ̂ Krɛkɩ névye nɛ́kwĩ́nkílɛ, nónó-á sõ̀ mɛ Nsyifunɔ Liyel wɛ̃̀kɩ̀lɛ n kɔ, à tahlɩ syɔ́ nɛ́-ǹgbnɔ náhnáh tyɩ́. Pé pól mɛ mɔ Pole ànɛ̂ Silasɩlɛ. ");
INSERT INTO wib_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ǹtɛ Nsyifunɔ yísyɔ́ sõ̀ mɛ Polepi dyɔlɛ n yɔ, tɛ́ sɔkɔ à kyɩ nɛ́túkúnì ǹkɔ̌nkɔ̌nɩ̀ yísyɔ́ tɛ̃ wã̀l yey sɔkɔ, à pɔ tɔ́wûlɛ n kurki n mɔ, tɛ́ fɛ̃̀kɩ̀nɔ́lɛ n pɩ kwil sɔkɔ. Képah sɔkɔ, pè kyɩ kwɔ de Nsyasõ gbô, à Pole ànɛ̂ Silasɩlɛ n yah n kɔ̃ nɛ, pé pè tɛ̃ pɔ tɔ́wû tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Pǎh kyɩ pè yah kwlɔ sɛ̃́, pè Nsyasõ ànɛ̂ Yesu yõ sɛ̃́pú yísyɔ́ tɛ̃ à yuku pélɛ pé kwil yõ̀tãm tyɩ́. Tɛ́ kyɩ tyah n yo wòhòh nɛ, nónó-á fɛ̃kɩ kèkõyṍ póllɛ, pépi-á pɔ de ásõ̂ tɔ sɔkɔ yɔ̀. ");
INSERT INTO wib_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Tɛ́ Nsyasõ mɛ fɛ̃ syi pè kɔ̃ pè twah ǹ tyɩ́. Ǹtɛ Wrome kwíltãm yõ̀tɛ̃̀ Sesar-á nɛ tyi nónó káh nɛ n pɩ, sépi-á no nɔ́pi pól mɛ n pɩ. Pǎh mɛ n yo ńtɛ̃nɛ nɛ, yõ̀tɛ̃̀ ǹgbɛ̃ yɔ́-á tɔ̃ mɛ, nɛ̂-á pè n ye Yesulɛ. ");
INSERT INTO wib_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Képah sɔkɔ, wɛlɔ nɔ́pi nóhnɔ́ tɔ́wû ànɛ̂ kwil yõ̀tãm fɔkɔ fil. ");
INSERT INTO wib_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Kǎh pɩ sɛ̃́, kwil yõ̀tãm mɛ Nsyasõpi kɔ̃ pè pɔ́ ǹgbɛ̃ yɔ́ kɔ̃, tɛ́ pyě pè fĩn mɔ. ");
INSERT INTO wib_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Képah sɔkɔ, lékã̂h-á fyɔ̀ mɔ, Yesu yõ sɛ̃́pú mɛ Pole ànɛ̂ Silasɩ kɔ̃ pè sɔkɔ Bere kwil. Pǎh yĩni tɛ̃ nɛ́npɔ́, pè kyɩ Nsyifunɔ Liyel ní-ńsah wɔ̀kɔ̀ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Nɛ́npɔ́ tãn sõ̀ nɛ́gblɔ́lɛ kal Tesaloniki kwil tãnnɛ. Nɩ̀vɩ̀nɩ̀ tir nɛ̂-á sõ̀ Pole n yo Yesu tyɩ́ sɔkɔ, pè mɛ kè fɛ̃ syi pallɛ dékè sɔkɔ. Tɛ́ mɛ Liyel wɛynɛ n kar, à ké sɔkɔ tyilɛ n sohlɩ n yah sõmɛsṍ nɛ, pé pɩ̃ gblɔ-à kɩ nɛ̂ Polepi wɛlɔlɛ. ");
INSERT INTO wib_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Kǎh pɩ sɛ̃́, Nsyifunɔ náhnáh, ànɛ̂ Krɛkɩ syɔ́ nɛ́-ǹgbnɔ yísyɔ́, ànɛ̂ díbí nɛ́kwĩ́nkí pɩ Yesu yõ sɛ̃́púlɛ. ");
INSERT INTO wib_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ǹtɛ Tesaloniki kwil Nsyifunɔ-á fyɔ̀ noh nɛ, Pole-á mɛ Liyel wɛynɛ n yo Bere kwil tɔ sɔkɔ, pè tɔ̃ pɔ nɛ́npɔ́ tɔ sɔkɔ, à pɔ tɔ́wû kurki mɔ, pè kɔ̃ pè fɛ̃̀kɩ̀nɔ́ pɩ. ");
INSERT INTO wib_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Képah sɔkɔ, Yesu yõ sɛ̃́pú núkú Pole tɛkɩ mɔ pnɛ yɔ tĩ̀nnɛ. Tɛ́ Silasɩ ànɛ̂ Timote wɔ mɛ wũ nɛ́npɔ́. ");
INSERT INTO wib_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Nónó-á kyɩ tɛkɩ mɔ Polelɛ, pè kyɩ de ǹnɛ, fɔ́ɔ́ Atɛnɩ kwil. Tɛ́ pǎh pé syɩ n pi, Pole mɛ pè tõ nɛ, pàh kɩ kyɩ, pè kyɩ yo Silasɩ ànɛ̂ Timote tyɩ́, pè pɔ péwɔ tnɔ̂ súú. ");
INSERT INTO wib_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Tɛ́ Pole-á sõ̀ mɛ Silasɩ ànɛ̂ Timote syɩ́kɩ́ntɛ̃̀nɔ́ sɔkɔ sɛ̃́ Atɛnɩ kwil, à fal fal tã̀n kyɔmɩ wɛ dò kénɛ kwil sɔkɔ. Kǎh pɩ sɛ̃́, ǹ yah kah kwɔ. ");
INSERT INTO wib_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Képah sɔkɔ, à kyɩ yã́hkɩ̀ yãh Nsyifunɔlɛ, pé Liyel ní-ńsah wɔ̀kɔ̀ sɔkɔ, à tahlɩ nónó tɔ-á sõ̀ mɛ Nsyifunɔ Liyel wɛ̃̀kɩ̀lɛ n kɔ. Tɛ́ sõmɛsṍ, wàh kyɩ tɔ́wû tùkè-ǹsah, tɛ́ névye nónó wɛ nɛ́npɔ́, ǎ yã́hkɩ̀ yãh pé tɔlɛ. ");
INSERT INTO wib_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Tɛ́ lékã́m ǹgbnɔ névye yísyɔ́ tɔ sõ̀ mɛ. Pè túkù sõ̀ mɛ Yepikur wɛ̃̀kɩ̀ kwɔ́púlɛ, tɛ́ túkù mó mɛ Setoyiki wɛ̃̀kɩ̀ kwɔ́púlɛ. Pépi mɛ yékã̂b mɔ Polelɛ. Pé túkù sõ̀ mɛ yo tũ nɛ, wɛ̀nkwĩnki nɛy mɛ̀ tɔ se nɛ sɔ̃́-á nɩ? Túkù mó nɛ, kǎh pɩ tɛ̃ nɛ fal fal tã̀n káhkɩ́ yísyɔ́ tyɩ́ sɔ̃́ à n yo, nónó-á pépi náh sélɛ n pnɛ. Tɛ́ Nɩ̀vɩ̀nɩ̀ tir ye sõ̀ Pole n yo pé tyɩ́ Yesu tyɩ́ yõ, ànɛ̂ lékyɩ̂ yílkínmɔnɔ tyɩ́lɛ. ");
INSERT INTO wib_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Képah tɛ̃̀nɛ, pè à tɛ̃ sɔkɔ pé kwil fɩ̃́ yɔ́ sɔkɔ pè n ye Arewopasɩlɛ. Pǎh kyɩ de, pè mɛ à piki yah nɛ, wǎh pɔ kwɔ́nɔ́ késã́n nɛ̂nɛ névyelɛ n kwɔ, à se kɩ fɛ̃ ké yah yo pé syah nɩ? ");
INSERT INTO wib_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ńkɛ̃́, gbɛ̃̀ndùnì tyi ó-á à n yo pé n nohnɩ yɔ̀. Képah-á, à sé yah yo n wah pé syah. ");
INSERT INTO wib_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Ǹtɛ gbɩ yõ, Atɛnɩ kwil tãn pól ànɛ̂ nɛ́pân nónó-á sõ̀ mɛ twáhntɛ̃̀nɔ́lɛ ké sɔkɔ, pé pól ńkɛ̃́nɛ pé wrɔ́ kan tɔkɔ n pɩ tyísnɔ́ yã́hnɔ́lɛ, képah náh pɩ, sé nóhnɔ́lɛ. ");
INSERT INTO wib_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Képah sɔkɔ, Pole mɛ yuku yĩn pé nɩyṍ, tɛ́ yo pé tyɩ́ nɛ: «Atɛnɩ tãn, mé pɩ̃ nɛ ńkɛ̃́, Liyel yáhnkɔ̃pu yèsyɩ̀kɩ̀nɩ̀-á yélɛ. ");
INSERT INTO wib_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Máh yé kwil kɔ kɔ̃, mé kè kyɔmɩ wɛ, líyelnɔ́ náhnáh mɛ ké sɔkɔ. Tɛ́ mé tyah yɔ́ ńtɛ̃ wɛ, kè mɛ wã́rkɩ́nmɔnɔlɛ ké yõ nɛ: ‹Dùkù pɩ̃́-ńkɛ̃̂ líyel tyɩ́ ye.› Tɛ́ ǹmɔ nɛ̂-á yé n gbilki ǹ dùkù pɩ̃́-ńkɛ̃̂nɛ, ǹmɔ tyɩ́ ye mé pɔ yónwàh-ǹsah yé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Ǹmɔ Liyel ye mɔ kèkõyṍlɛ, ànɛ̂ ké sɔkɔ yíyìn póllɛ. Ǹmɔ ye tɔ̃ yĩ̂nyõ ànɛ̂ sétáh nɛ́tɛ̃̂nɛ. À náh n tɛ̃ névi gbõ̀ wɔ̀kɔ̀nmɔnɩ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ǹmɔ ye mɔ minnɛ névi sɔkɔ, ànɛ̂ mɩ̀nɩ̀nɛ à kɔ̃ à n mɩ, à tahlɩ yíyìn pól tyɩ́. Képah ye, à náh mɛ névi gbɛ̃̀npɩnɩ yɔ́ ńtɛ̃nɛ n yah n kɔ̃, ǹ gblɔ̌y yohnɩ n mɔ yĩnnɛ. ");
INSERT INTO wib_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Yah, nɛ́núkù ó sɔkɔ ye kèkõyṍ yìkìnì pól wil Liyel-á nónó mɔ, tɛ́ pè kɔ̃ pè tɛ̃ tɛ̃ kɔ̃ kèkõyṍ tã̀ntã̀n pól sɔkɔ. Tɛ́ ki ànɛ̂ kɔ̀kɩ̀ gbĩ́nɛ pè kɔ̃, tɛ́ tɔ̃ gbàhnɩ̀ gboke pé tɛ̃̀-ǹtã̀n tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Liyel sépi pól pɩ nɛ, nɛ́núkù núkú pól fɛ̃ pé yah n kɔ̃. Gbɔ̀kénpɩ, pǎh kɩ wnɛ yah kɔ̃ pɔ pé wɛ. Ǹtɛ gbɩ yõ, à náh mó tɔ̃ mɛ fɩ́ɩ́ á sɔkɔ yɔ́ ńtɛ̃nɛ. ");
INSERT INTO wib_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Ǹmɔ gbõ̀ yõ sɔkɔ ye ápilɛ min sɔkɔ, tɛ́ mɛ n werke. Képah ye tɔ̃ yé yɩ̀ gbɩ́pú yísyɔ́ yo nɛ ńkɛ̃́, Liyel wɛ̃́npì-á ápilɛ. ");
INSERT INTO wib_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Ǹtɛ Liyel wɛ̃́npì-á ápilɛ sɛ̃́, á se tɔ̃ yɩ̃nɛ à nɛ n sõ nɛ, Liyel-á mɛ á kɩ nɛ tã̀n nɔ́pi sɔ̃́; sépi nónó-á névye sè mɔ sã́nnɛ, képah náh pɩ wárn vyɔrɩlɛ, képah náh pɩ dyêhlɛ, à yɩ̃nɛ pé yɛ̃́ngbɛ̃́ lékã́mnɛ? ");
INSERT INTO wib_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Tɛ́ yé yah, névye-á tyi nónó pɩ sɔkɔ ǹpɩ̃̀-ǹkɛ̃̂ sɔkɔ ǹgbòlɛ, Liyel náh tɔ̃ mɛ sépilɛ n mɔ n kõ. Ǹtɛ núkúnúkú, à mɛ kélɛ n yo no pól tyɩ́ tã̀ntã̀n pól sɔkɔ nɛ, pè pé nnɔ vi mɔ. ");
INSERT INTO wib_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Wáh wɛ à képahlɛ n yo, à mɛ gbĩ̀yĩ̀kì yɔ́ yah wilki sah, sõ nɛ̂-á tukey kɩ n tuke n pi kèkõyṍ névye pól yõ, à yɩ̃nɛ gbɩ wɛ̃̀kɩ̀lɛ. À mɛ dĩ́ yɔ́ yah wilki sah, nɛ̂-á kɩ pɔ tukey mɛ̀ tuke n pi, tɛ́ pǎh pɔ tɛ̃̀ ko mɔ, à ǹ lékó yilki mɔ, à kélɛ á wɛ̃kɩ nɛ, wǎh kɩ fɛ̃ tɛ̃.» ");
INSERT INTO wib_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Képah tɛ̃̀nɛ, pǎh fyɔ̀ lékó yílkínmɔnɔ tyɩ́ noh, pé túkù tyah kṍlɛ Polelɛ n ko. Túkù mó mɛ n yo ǹ tyɩ́ nɛ ńkɛ̃́, sõ yɔ́lɛ, à tɔ̃ pɔ ǹ syɩ ǹ wɛy mɛ̀ yõ pé tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Kǎh pɩ sɛ̃́, Pole mɛ yal pé tnɔ̂. ");
INSERT INTO wib_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Ǹtɛ ǹ wɛy nóhpú túkù kyɩ kwrɔ mɔ ǹnɛ, à pɩ Yesu yõ sɛ̃́púlɛ. Nɛ́-ǹgbnɔ nónó-á ńkɛ̃́nɛ wɛ̃nɛ n tuke n mɔ, ǹ tyi yahlɛ n wah, pépi nɛy yɔ́ tɔ sõ̀ mɛ pélɛ pè n ye Denisilɛ, ànɛ̂ sê yɔ́ tɔlɛ pè n ye Damarisilɛ, à tahlɩ nósyɔ́ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Képah náh, Pole yal Atɛnɩ kwil, à yuku Korɛ̃nti kwil. ");
INSERT INTO wib_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Légbĩ́ pɔ yɩ̃nɛ Wrome kwíltãm yõ̀tɛ̃̀ dĩ́ Klode mɛ Nsyifunɔ pól yal Wrome kwil. Kǎh pɩ sɛ̃́, Nsyifu dĩ́ yɔ́ lésõ mɛ nɛ́npɔ́ pè n ye Akilasɩlɛ. À dubi Põte kwil. Ǹmɔ ànɛ̂ ǹ kyɩ Prisili mɛ yal Wrome kwil, Yitalɩ sétáh yõ, à sɔkɔ Korɛ̃nti kwil. Pole mɛ kyɩ yɩ̃nɛ pé pɔ́ntwahnɔ késã́nnɛ nɛ́npɔ́, tɛ́ kwrɔ mɔ pé sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Tɛ́ pé pól sõ̀ mɛ tõ̀ núkúlɛ n pɩ, nɛ̂-á pɩ yèpye flɔ kóhnɔ́lɛ. Kǎh pɩ sɛ̃́, Pole mɛ tɛ̃ pé tyɩ́ pè tõ̀lɛ n pɩ wɛ̃ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Tɛ́ mɩ mɩ yòh sõnɔ́ póllɛ, Pole sõ̀ mɛ yã́hkɩ̀lɛ n yãh n pɔ Nsyifunɔlɛ pé Liyel ní-ńsah wɔ̀kɔ̀ sɔkɔ, mɛ n yah n kɔ̃ nɛ pé pépi ànɛ̂ Krɛkɩ névye sõnɔ vi mɔ. ");
INSERT INTO wib_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Képah sɔkɔ, Silasɩ ànɛ̂ Timote wil Masedonɩ gbɛ̃̀nyah à pɔ. Pǎh fyɔ̀ pɔ de, Pole náh tɔ̃ mɛ tõ̀ yɔ́ ńtɛ̃nɛ n pɩ nɛ́ Liyel wɛy yónkɔ̃nɔ ó náh. À sõ̀ mɛ ké yahlɛ n yo Nsyifunɔ tyɩ́ nɛ, Yesu-á Liyel yah tɔkɔ pɩ pwáhnmɔ-òlɛ. ");
INSERT INTO wib_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ǹtɛ Nsyifunɔ mɛ kè yahle ǹ tyɩ́, tɛ́ ǹnɛ n gbyɔ. Kǎh pɩ sɛ̃́, à ǹ wil flɔ kwer, tɛ́ yo pé tyɩ́ nɛ, pé mɔ́npunɔ kémû-á kɩ pɩ pé yɛ̃́ngbɛ̃́ tyɩ́lɛ, péwɔ vyãh náh mɛ ké sɔkɔ. À tɔkɔ núkúnúkú tyɩ́, páh kɩ pé yah mɔ névye tĩ̀nnɛ, nónó náh pɩ Nsyifunɔlɛ. ");
INSERT INTO wib_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Képah sɔkɔ, tɛ́ yal nɛ́npɔ́ à sɔkɔ dĩ́ yɔ́ tĩ̀nnɛ, nɛ̂-á pè n ye Tityusi-Nsyusitusilɛ. Nsyifunɔ Liyel yõ sɛ̃́-ò ye sõ̀ ǹnɛ. Ǹ gbô sõ̀ mɛ Nsyifunɔ Liyel ní-ńsah wɔ̀kɔ̀ gbɔ̀pɔ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Ǹtɛ Liyel ní-ńsah wɔ̀kɔ̀ yõ̀tɛ̃̀ dĩ́ Krisipusi ànɛ̂ ǹ no pól sɛ̃ Tɛ̃̀ ǹgbɛ̃ Yesu yõ. Korɛ̃nti kwil tãn nónó tɔ-á sõ̀ mɛ Pole wɛynɛ n nohnɩ, pé náhnáh sɛ̃ Tɛ̃̀ ǹgbɛ̃ yõ, tɛ́ wèlnwìlkìnɔ́ wɛ ni sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","10","Képah tɛ̃̀nɛ, sõ yɔ́ lékã̂hnɛ, Pole wɛ̃́kɩ́nɔ́ yɔ́ wɛ, nɛ̂ sɔkɔ-á Tɛ̃̀ ǹgbɛ̃ yo ǹ tyɩ́ nɛ: «Névye náhnáh kɩ n pɩ n pi ńmɔ tyɩ́lɛ kwil mɛ̀ sɔkɔ. Képah ye, káh á vyãh vike n sah, yɔ̃ n sɔkɔ nɛ n wɛkɩ, káh tíkí pɩ. Ńmɔ mɛ álɛ, nɛy náh fɛ̃ ǹ tɛ̃ n tir n pi póllɛ.» ");
INSERT INTO wib_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Képah tɛ̃̀nɛ, Pole tɛ̃, à yi núkú ànɛ̂ ńwɔ̃́lɔ́ kénúkò pɩ Korɛ̃nti kwil, à nolɛ n kwɔ Liyel wɛynɛ. ");
INSERT INTO wib_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Képah sɔkɔ, Nsyifunɔ pɔ yuku wɛ̃ tyɩ́ mɔ, à tyah Polelɛ n fwo. Tɛ́ légbĩ́nɛ, Kalyõ ye lésõ Akayi gbɛ̃̀nyah yah tɛ̃́-òlɛ. Pè mɛ Pole tɛ̃ kyɩ ǹ tyɩ́ tukey tùkè-ǹsah sɔkɔ, ");
INSERT INTO wib_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","tɛ́ nɛ dĩ́ mɛ̀-á mɛ névye yõlɛ n yɩkɩ, à pélɛ n mɔ Liyel nínɔ́ gbɛ̃̀ntɛ̃̀náh yɔ́ sɔkɔ, nɛ̂ náh mɛ núkúlɛ pépi tyi kõ̀nsàhnɔ́lɛ. ");
INSERT INTO wib_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Képah sɔkɔ, Pole-á mɛ nɛ pé wɛy tɔkɔ, Kalyõ mɛ yo Nsyifunɔ tyɩ́ nɛ, kàh sõ̀ mɛ pɩ tyíkɛ̃̌kɩ̀, képah náh pɩ, tyípékè ǹgbɛ̃ yɔ́lɛ dĩ́ mɛ̀ pɩ, páh náhkɩ tɛ̃ noh pé tyɩ́ pallɛ. ");
INSERT INTO wib_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ǹtɛ pǎh se mɛ yékã̂blɛ n pɩ wɛlɔ, ànɛ̂ yni, ànɛ̂ pé yɛ̃́ngbɛ̃́ tyi kõ̀nsàhnɔ́ yõ tɛ́; képah-á mɛ pépilɛ n yah kɛ̀. Péwɔ náh fɛ̃ sɛ̃́nkɔ̃ tukey tuke n pi lɔ́! ");
INSERT INTO wib_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Tɛ́ mɛ pè yal tukey tùkè-ǹsah sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Képah sɔkɔ, Sositɛnɩ nɛ̂-á sõ̀ Nsyifunɔ Liyel ní-ńsah wɔ̀kɔ̀ yah yètɛ̃̀nɛ, pé pól tuke ǹmɔ yõ, à ǹnɛ n ko tukey tùkè-ǹsah sɔkɔ. Ǹtɛ Kalyõ náh dahbɩ wilki pé tyɩ́ ké sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Képah sɔkɔ, Pole tɔ̃ wũ à sèpĩ̀n náhnáh pɩ Korɛ̃nti kwil. Képah náh, à wɛ̃̀kɩ̀ ni Yesu yõ sɛ̃́pú tyɩ́ nɛ́npɔ́ nɛ, páh kɩ pé syɩ yuku Siri gbɛ̃̀nyah sɔkɔ ànɛ̂ Prisili, ànɛ̂ Akilasɩlɛ. Tɛ́ à lésõ mɛ ǹ vyãh tɔkɔ Liyel tyɩ́. Kǎh pɩ sɛ̃́, wǎh pópó n sɔkɔ, à kyɩ Sãnkrɩ kwil, à kyɩ ǹ yõ kye vyãh tɔ́kɔ́nɔ́ mɛ̀ yĩnnɛ. ");
INSERT INTO wib_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Képah náh, ǹmɔ, ànɛ̂ Prisili, ànɛ̂ Akilasɩ kyɩ de krótókè ǹgbɛ̃ yɔ́ sɔkɔ, à yal nɛ́npɔ́ à kyɩ de Yefɛsɩ kwil. Pole mɛ ǹ kɔ́mû sah nɛ́npɔ́, tɛ́ mɛ sɔkɔ Nsyifunɔ Liyel ní-ńsah wɔ̀kɔ̀ sɔkɔ, à kyɩ yã́hkɩ̀ yãh pélɛ. ");
INSERT INTO wib_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Képah sɔkɔ, pè kè yah kɔ̃ ǹ tyɩ́ nɛ ńkɛ̃́, à tɔ̃ sèpĩ̀n yísyɔ́ pɩ pépilɛ nɛ́npɔ́. Ǹtɛ Pole náh fɛ̃ syi. ");
INSERT INTO wib_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Tɛ́ mɛ wɛ̃̀kɩ̀ ni pé tyɩ́, tɛ́ nɛ ńkɛ̃́, Liyel-à kɩ fɛ̃ syi, sõ yɔ́lɛ, páh kɩ tɔ̃ pé syɩ pɔ yah pé tyɩ́. Tɛ́ de krótókè ǹgbɛ̃ sɔkɔ Yefɛsɩ kwil, à sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Wǎh kyɩ tiki Sesarɩ kwil, à dɔkɔ yuku Yerusalɛmɩ kwil, à kyɩ wɛkɩ Yesu yõ sɛ̃́pú tĩ̀nkì tyɩ́. Wǎh wil nɛ́npɔ́, à ǹ syɩ tiki yuku Antyɔsyɩ kwil, ");
INSERT INTO wib_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","à kyɩ tɛ̃ yah nɛ́npɔ́. Képah náh, à tɔ̃ yal à kyɩ Kalasi gbɛ̃̀nyah kwlo kɔ kɔ̃ ànɛ̂ Frisyi gbɛ̃̀nyah kwlolɛ, à nɩ̀sãh mɔ kɔ̃ Yesu tõ̀ sã́hpú sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Légbĩ́nɛ, Nsyifu dĩ́ yɔ́ pɔ Yefɛsɩ kwil. Ǹ yĩn ye sõ̀ Apɔlɔsɩlɛ, à dubi Alɛkisãdri kwil. À sõ̀ wɛy tyɩ́ yah wɛ yĩ́ĩ́, tɛ́ à mó tɔ̃ Liyel wɛy sɛ́bɛ́ynɔ́ tyi pɩ̃ yĩ́ĩ́. ");
INSERT INTO wib_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","À lésõ kwɔ́nɔ́ wɛ Tɛ̃̀ ǹgbɛ̃ Yesu wɛ̃̀kɩ̀ tyɩ́ yõ, tɛ́ mɛ Yesu tyɩ́lɛ n yo, à kwɔ́nɔ́lɛ n pɩ ké wɛ̃̀kɩ̀ yõ, dékè sɔkɔ ǹ nɩ póllɛ. Ǹtɛ Nsyɔ̃ ni sɔkɔ wèlnwìlkìnɔ́ ó ye sõ̀ à n pnɛ. ");
INSERT INTO wib_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Tɛ́ sõ yɔ́lɛ, wǎh tyah n wɛkɩ nɩ̀sãhlɛ Nsyifunɔ Liyel ní-ńsah wɔ̀kɔ̀ sɔkɔ sɛ̃́, Prisili ànɛ̂ Akilasɩ mɛ ǹ wɛy noh pɔ tyɛ. Képah tɛ̃̀nɛ, tɛ́ à ye yah kyɩ Yesu wɛ̃̀kɩ̀ tyi yo wah yĩ́ĩ́ à syah, wǎh sõ̀ mɛ nónó yɩ̃́tũri sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Képah náh, Akayi gbɛ̃̀nyah sɔ́kɔ́nɔ́ sõnɔ de Apɔlɔsɩ sɔkɔ. Yesu yõ sɛ̃́pú nónó-á sõ̀ mɛ nɛ́npɔ́, pépi mɛ ké sṍré gbah mɔ ǹ sɔkɔ, tɛ́ sɛ́bɛ́y wãrkɩ tɛkɩ mɔ Yesu yõ sɛ̃́pú tyɩ́ Akayi gbɛ̃̀nyah sɔkɔ nɛ, Apɔlɔsɩ-à kɩ yĩni tɛ̃ pé tyɩ́, pè à tɛ̃ plɛ. Wǎh kyɩ yĩni tɛ̃, Liyel gbõ̀ yõ, ǹ kyɩ́nɔ́ sõ̀ pɩ yĩ́ĩ́ yõre ǹgbɛ̃nɛ Yesu yõ sɛ̃́pú tyɩ́ Akayi gbɛ̃̀nyah sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","À sõ̀ mɛ Liyel wɛynɛ n kar, à kélɛ n wɛ̃kɩ nɛ, Yesu-á Liyel yah tɔkɔ pɩ pwáhnmɔ-òlɛ. Tɔ́wû pól yĩ́ yah, ǹ wɛy sõ̀ mɛ gbɩlɛ kal Nsyifunɔ tyɩ́lɛ. ");
INSERT INTO wib_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Gbĩ́ nɛ̂-á sõ̀ Apɔlɔsɩ mɛ Korɛ̃nti kwil, Pole sõ̀ mɛ Asi gbɛ̃̀nyah tlɛy tã̀ntã̀n kɔ kah, à kyɩ de Yefɛsɩ kwil sɔkɔ. À kyɩ Yesu tõ̀ sã́hpú yísyɔ́ wɛ nɛ́npɔ́, ");
INSERT INTO wib_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","tɛ́ pè piki yah nɛ ńkɛ̃́, pǎh sɛ̃ Tɛ̃̀ ǹgbɛ̃ Yesu yõ gbĩ́ nɛ̂nɛ, pè se Liyel Mirki wɛ nɩ? Pè mɛ yo ǹ tyɩ́ nɛ, pé náh Liyel Mirki yɔ́ ńtɛ̃ tyɩ́ yónɔ́ noh yah póllɛ. ");
INSERT INTO wib_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Képah sɔkɔ, Pole mɛ pè piki yah nɛ, ǹtɛ ni sɔkɔ wèlnwìlkìnɔ́ dùkù nɛ̂ se pè wɛ nɩ? Pè mɛ à syah nɛ, Nsyɔ̃ tyɩ́-á. ");
INSERT INTO wib_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Képah sɔkɔ, Pole tɔ̃ ǹ syɩ yo pé tyɩ́ nɛ, névye nónó-á fɛ̃ syi pé nnɔ vi mɔ, pépi-á sõ̀ Nsyɔ̃ n wel n wilki ni sɔkɔ. Ǹtɛ wǎh sõ̀ mɛ n yo névye tyɩ́ nɛ, nɛ̂-á kɩ n pɔ n pi péwɔ náhlɛ, pè sɛ̃ ǹmɔ yõ; ǹmɔ nɛ̂-á Yesulɛ. ");
INSERT INTO wib_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","No-á wɛlɔ nɔ́pi noh sɛ̃́, pè mɛ wèlnwìlkìnɔ́ wɛ ni sɔkɔ Tɛ̃̀ ǹgbɛ̃ Yesu yĩn yõ. ");
INSERT INTO wib_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pole mɛ ǹ gbã̀n sah pé yõ tɛ́ nírí pɩ pé tyɩ́, Liyel Mirki mɛ tiki pé yõ. Képah tɛ̃̀nɛ, pè tyah wɛ́nkáhkɩ́nɔ́lɛ n wɛkɩ nónó-á pè náh sè sãh, tɛ́ mɛ Liyel tɛ̃ntõnènɛ n wɛ n syi n yo névye tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Pé pól sõ̀ mɛ nɛ́pĩ̂ gbɔ̃nimí kénkɔ̃lɛ. ");
INSERT INTO wib_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Képah sɔkɔ, Pole sõ̀ mɛ n de n pɔ Nsyifunɔ Liyel ní-ńsah wɔ̀kɔ̀ sɔkɔ. À sõ̀ mɛ n yãh n pɔ névyelɛ nɩ̀sãh sɔkɔ Liyel tɔ̃́rɩ́ tyɩ́ yõ, pópó ńwɔ̃́lɔ́ tɔ̃́nɔ́. À sõ̀ mɛ ǹ tah sah nɛ, pé pé wɛy nóhpú sõnɔ vi mɔ. ");
INSERT INTO wib_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ǹtɛ túkù sõ̀ mɛ pɔ nikisekɔ́kɔ́lɛ n pɩ, à yahle sɛ̃́nɔ́lɛ ké yõ, tɛ́ mɛ Tɛ̃̀ ǹgbɛ̃ wɛ̃̀kɩ̀ tyɩ́lɛ n yo n ko tɔ́wû yĩ́ yah. Kǎh pɩ sɛ̃́, Pole mɛ pè sah, tɛ́ Yesu tõ̀ sã́hpú tɛ̃ sɔkɔ pé yahlɛ, à kyɩ yã́hkɩ̀lɛ n yãh pélɛ sõmɛsṍ kǎrn pɩ́-ńsah wɔ̀kɔ̀ sɔkɔ, nɛ̂-á Tiranusi tyɩ́lɛ. ");
INSERT INTO wib_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","À képah tɛ̃̀ pɩ sɛ̃́ ye nínɔ́, fɔ́ɔ́ Nsyifunɔ ànɛ̂ nónó náh pɩ Nsyifunɔlɛ, tɛ́ mɛ Asi gbɛ̃̀nyah sɔkɔ, pé pól Tɛ̃̀ ǹgbɛ̃ wɛy wɛ noh. ");
INSERT INTO wib_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Liyel sõ̀ mɛ Pole tɔkɔ à gbǐl tyísnɔ́lɛ n pɩ, ");
INSERT INTO wib_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","fɔ́ɔ́ névye pɔ tyah Pole flɔ ànɛ̂ ǹ myèhtùkènènɛ n tɔkɔ n tũ n pɔ pé yámpú tyɩ́, pè kɔ̃ pè n dɛ; ànɛ̂ sétã̀n-à mɛ nónó sɔkɔ, sè n wil pé sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Tɛ́ Nsyifunɔ yísyɔ́ sõ̀ mɛ nónó tõ̀-á sõ̀ sétã̀n yĩ́nínwìlkìnkɔ̃nɔlɛ névye sɔkɔ. Pépi tɔ mɛ kè yah tɔkɔ nɛ, pé Tɛ̃̀ ǹgbɛ̃ Yesu yĩn tɔkɔ kélɛ n pɩ. Pè sõ̀ mɛ n yo sétã̀n tyɩ́ nɛ, Yesu nɛ̂ tyɩ́-á Pole n nɛ n yo, ǹmɔ yĩn yõ, ńkɛ̃́ sè wil. ");
INSERT INTO wib_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Nsyifunɔ sɔkɔ, sárká syínwìlkìpu yõ̀tɛ̃̀ nɛ̂-á pè n ye Sevalɛ, ǹmɔ dĩ́npì nɛ́pĩ̂ kwǎrnimi ye sõ̀ n pɩ képahlɛ. ");
INSERT INTO wib_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ǹtɛ pǎh képah yo sɛ̃́, sétõ pè syah nɛ, páh Yesulɛ n pnɛ, tɛ́ tɔ̃ pɩ̃ névi dùkù nɛ̂-á Polelɛ. Ǹtɛ pépi-á dò, nónó se pépilɛ nɩ? ");
INSERT INTO wib_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Képah tɛ̃̀nɛ, sétõ-á sõ̀ dĩ́ nɛ̂ sɔkɔ, à yuku mɩ pé sɔkɔ, tɛ́ tɛ̃ wɛ pé tyɩ́ képékèyɔ̂. À pè pɩ yɔ, fɔ́ɔ́ pè to wil wɔ̀kɔ̀ mɛ̀ sɔkɔ à sɔkɔ wil tìtílɛ. ");
INSERT INTO wib_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Képah sɔkɔ, Nsyifunɔ nónó pól-á sõ̀ mɛ Yefɛsɩ kwil, à tahlɩ nónó náh pɩ Nsyifunɔlɛ, pǎh yĩ mɛ̀ noh, kè pɩ tíkílɛ pé pól tyɩ́. Pè mɛ tyah Tɛ̃̀ ǹgbɛ̃ Yesu yĩnnɛ n gbilki. ");
INSERT INTO wib_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Tɛ́ nónó-á sõ̀ pɩ Yesu yõ sɛ̃́púlɛ, pé náhnáh pé tyítúkúnì pɩ́nɔ́lɛ n yo n dal n mɔ n pɔ tɔ́wû yĩ́ yah. ");
INSERT INTO wib_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Képah sɔkɔ, nónó-á sõ̀ mɛ snɛ̀ynɛ n pɩ, pé náhnáh mɛ pé snɛ̀y pɩ pɩ sɛ́bɛ́ynɔ́ tɔkɔ pɔ tuke mɔ, à sukɛ no pól yĩ́ yah. Pǎh sɛ́bɛ́y nɔ́pi drɔ kõ yah, sè pɩ pɔ́ plɔ́ kèyõ túkúrí pɔ́ kwlɔ́lɛ. ");
INSERT INTO wib_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Sɛ̃́ ye sõ̀ Liyel wɛy mɛ tǎhkɩ̀lɛ n wɛ, à n tɔ̃ n mɔ n yuku yahlɛ Tɛ̃̀ ǹgbɛ̃ gbõ̀ yõ. ");
INSERT INTO wib_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Tyi nɔ́pi pɩ́nsɔkɔntɛnɔ náh, Pole kè yah tɔkɔ nɛ, páh kɩ kyɩ Masedonɩ gbɛ̃̀nyah ànɛ̂ Akayi gbɛ̃̀nyah sɔkɔ, tɛ́ kɩ pyě yuku Yerusalɛmɩ kwil. À sõ̀ mɛ kélɛ n yo tɔlɛ nɛ ńkɛ̃́, páh kɩ yĩni tɛ̃ nɛ́npɔ́, páh yɩ̃nɛ pé kyɩ Wrome kwil tɔ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Kǎh pɩ sɛ̃́, à mɛ Timote ànɛ̂ Yerasɩtɩ tɛkɩ mɔ Masedonɩ gbɛ̃̀nyah sɔkɔ, pépi nónó-á sõ̀ ǹ yòhnɩ̀nmɔpulɛ. Tɛ́ ǹmɔ wɔ wũ à sèpĩ̀n yísyɔ́ pɩ Asi gbɛ̃̀nyah sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Légbĩ́nɛ, fɛ̃̀kɩ̀nɔ́ ǹgbɛ̃ yɔ́ pɩ Yefɛsɩ kwil, Tɛ̃̀ ǹgbɛ̃ wɛ̃̀kɩ̀ tyɩ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Sã́n ywɔ́-ò kètɔ̃ndĩ́ yɔ́ lésõ mɛ pè n ye Demetriyusilɛ. Kénɛ dĩ́ ńkɛ̃́nɛ tã̀n vɩ̀ yã́ryã́r yísyɔ́lɛ nɛ n ywɔ wárn vyɔrɩ pérpérlɛ. Yefɛsɩ tãn tõ̀ yũ̌kì nɛ̂-á pè n ye Artemisilɛ, képah wɔ̀kɔ̀ kètɔ̀nɔ́ ye ńkɛ̃́nɛ à n nɛ n ywɔ. Tɛ́ ǹ tõ̀npɩbɩ sõ̀ mɛ pɔ́lɛ n wɛ yĩ́ĩ́ ǹ tyɩ́, tõ̀ mɛ̀ pɩ́nɔ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Sõ yɔ́lɛ, à ǹ tõ̀npɩbɩ pól ye tuke, à tahlɩ ǹ tõ̀ dùkù pɩ́pú pól tyɩ́. Képah tɛ̃̀nɛ, tɛ́ yo pé tyɩ́ nɛ ńkɛ̃́, pé kódíbí, pé pól-á kè pɩ̃ yĩ́ĩ́ nɛ páh mɛ yõrelɛ n wɛ n yĩ́ĩ́ pé tõ̀ mɛ̀ pɩ́nɔ́ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ǹtɛ dĩ́ nɛ̂-á pè n ye Polelɛ, wǎh mɛ pɔ tir nɛ̂nɛ n pɩ, pǎh se mɛ kélɛ n nohnɩ, tɛ́ mɛ kélɛ n yah tɛ́. Kénɛ Pole-á mɛ névyelɛ n kwɔ nɛ ńkɛ̃́, fal fal tã̀nnɛ, névye gbɛ̃̀npɩnɔ yî-á sélɛ, yõ náh mɛ sé tyɩ́. Kénɛ wɛy mɛ̀ ńtɛ̃-á mɛ névye náhnáh yõ yɩkɩ Yefɛsɩ kwil. Tɛ́ kè náh se tɔ̃ mɛ yĩn képah ó tyɩ́, ńkɛ̃́ kǎh mɛ Asi gbɛ̃̀nyah kwlo kan pól névye yõlɛ n yɩkɩ. ");
INSERT INTO wib_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Kàh yɔ̃ sɔkɔ sɛ̃́, yĩ mɛ̀-á kɩ n syah pépi pɩ pɩ tõ̀lɛ n yɩkɩ dɛ́! Kè náh se tɔ̃ n yĩn n pi képah ó tyɩ́, pé fal fal tõ̀ yũ̌kì Artemisi wɔ̀kɔ̀ náh tɔ̃ n mɔ n kõ n pi póllɛ. Gbílkínɔ́ nɛ̂-á sõ̀ mɛ n sah tõ̀ mɛ̀ yõ, kǎh kɩ yĩn mɔ. Tɛ́ képah-á mó tɔ̃ Asi gbɛ̃̀nyah névye pól ànɛ̂ kèkõyṍ névye pól mɛ n gbilki. ");
INSERT INTO wib_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Demetriyusi-á fyɔ̀ kénɛ wɛlɔ yo névye noh sɛ̃́, pé fɔkɔ kah vyãh. Pè mɛ tyah yo tũ wòhòh nɛ ńkɛ̃́, pépi Yefɛsɩ tãn Artemisi tɛ̃̀ wɔ kénkɔ̃ náh mɛ. ");
INSERT INTO wib_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Pɩ́ntũnɔ mɛ̀ yĩ́npɔ̃́ kwil pól tɔ̃. Tɛ́ Masedonɩ gbɛ̃̀nyah tãn nɛ́pĩ̂ nímí yísyɔ́ tɔ sõ̀ yuku Polelɛ ǹ kɔ́lɔ́ sɔkɔ Yefɛsɩ kwil. Pé sɔkɔ núkú yĩn ye Kayusilɛ, ní-ò yĩn mɛ Arisitarkɩlɛ. Képah tɛ̃̀nɛ, no núkú wɛ̃ tyɩ́ mɔ, à to tuke nɛ́pĩ̂ nímí nɔ́pi yõ, à pè tɛ̃ yɔrɩ sɔkɔ pé tɔ́wû tùkè-ǹsah sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Képah sɔkɔ, Pole sõ̀ mɛ ké tyɩ́ nɛ, pé kyɩ pé yõ wilki mɔ tɔ́wû tyɩ́. Ǹtɛ Yesu tõ̀ sã́hpú mɛ kè yahle ǹ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Asi gbɛ̃̀nyah nɛ́-ǹgbnɔ yísyɔ́ tɔ sõ̀ mɛ, nónó-á sõ̀ Pole kódíbílɛ. Pépi tɔ mɛ tɛ̃ntõ̀ mɔ ǹ tyɩ́, à à vi mɔ nɛ, à káh n kyɩ tɔ́wû tùkè-ǹsah mɛ̀ sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Tɛ́ légbĩ́nɛ, tɔ́wû mɛ̀ névye pól sõ̀ mɛ wɛkɩ fɛ̃kɩ tũ wòhòh, tɛ́ pé pól tyíyónɔ́nɔ mó tɔ̃ mɛ sé tyɩ́ tyɩ́lɛ. Kǎh pɩ sɛ̃́, kè pɩ fɛ̃̀kɩ̀nɔ́lɛ. Névye kan ńtɛ̃ náh sõ̀ mɛ pé pɔ́nɔ́ yõ pɩ̃. ");
INSERT INTO wib_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Nsyifu dĩ́ yɔ́ tɔ sõ̀ mɛ pè n ye Alɛkisãdrelɛ. Pé no Nsyifunɔ mɛ ǹmɔ kurki mɔ kyɩ sah tɔ́wû yah tĩ̀nnɛ nɛ, à yo ké sɔkɔ. Képah sɔkɔ, Alɛkisãdre mɛ ǹ gbõ̀ pɩ mɔ tɔ́wû tyɩ́. À sõ̀ mɛ ké tyɩ́ nɛ, pé pé no Nsyifunɔ vyãh syi. ");
INSERT INTO wib_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ǹtɛ tɔ́wû-á fyɔ̀ pɔ n pɩ̃ ké sɔkɔ nɛ Nsyifu nɛy-á ǹnɛ, pé pól núkú tɔ̃ tyah yo mɔ tũ wɛ̃ yõ wòhòh nɛ ńkɛ̃́, pépi Yefɛsɩ tãn Artemisi tɛ̃̀ wɔ kénkɔ̃ náh mɛ! Pè képah tɛ̃̀ yo tũ sɛ̃́, pópó kè syi pɔ n nɔ lɛ́rɩ́nɔ́ nínɔ́ kénkɔ̃ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Ǹtɛ ké tyɛ́-ńsah, kwil sɛ́bɛ́y wã́rkɩ́-ò dĩ́ pɔ tɛ̃ wɛ pè yĩn mɔ. Képah sɔkɔ, tɛ́ mɛ nɛ ńkɛ̃́, Yefɛsɩ tãn, névye pól-á pɩ̃ nɛ, Yefɛsɩ kwil-á n syɩkɩ pépi fal fal tõ̀ ǹgbɛ̃ Artemisi wɔ̀kɔ̀lɛ, ànɛ̂ ké tàhsè nɛ̂-á wil yĩ̂nyõ à pɔ syɩkɩ. ");
INSERT INTO wib_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Ké kɔ̃̀lɩ̀-ò náh mɛ póllɛ. Képah-á, pè pé nnɔ vɩ. Pè káh tir yɔ́ ńtɛ̃ pɩ sõ̀nyah-ńkɛ̃̂nɛ. ");
INSERT INTO wib_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Díbí nónó-á pè tɛ̃ pɔ ásõ̂, pè náh tir yɔ́ pɩ de pépi tõ̀ wɔ̀kɔ̀ tyɩ́, pè náh se mó tɔ̃ yo de pé fal fal tõ̀ yũ̌kì mɛ̀ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Ǹtɛ kàh kɩ mɛ pɩ ǹnɩ̂ mɛ pɩ de Demetriyusi ànɛ̂ ǹ tõ̀ pɩ́mû tyɩ́, tukey tùkènɔ́ yòhnɩ̀-á mɛ, tukey tùkèpu mó tɔ̃ mɛ. Pè kyɩ n tɔkɔ tɛ̃̀ kɔ̃ pépi tyɩ́ kɛ̀. ");
INSERT INTO wib_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Tɛ́ tyi yísyɔ́ tɔ-à kɩ se tɔ̃ mɛ pé tyɩ́ wah wah tɛ̃̀nɛ, pǎh kɩ fɛ̃ pɔ sé yah yo kwil névye tuke mɔ sõlɛ. ");
INSERT INTO wib_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Páh yékã̂b nɛ̂ sɔkɔ kwɛynɛ yɔ̀, tir yɔ́ ńtɛ̃ se mɛ pé tyɩ́, pé kɩ fɛ̃ wɛ yo yékã̂b mɛ̀ yõlɛ nɩ? Képah-á, páh kɩ n to n kɔ̃ yɔ̀, pǎh kɩ pɔ n syah n tɔkɔ pélɛ n kɔ̃ dɛ́! ");
INSERT INTO wib_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Wɛlɔ nɔ́pi yóntɛnɔ náh, à névye kɔ̃ pè karkɩ. ");
INSERT INTO wib_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Tɛ́ fɛ̃̀kɩ̀nɔ́ mɛ̀-á pɔ yĩn mɔ gbĩ́ nɛ̂nɛ, Pole mɛ Yesu tõ̀ sã́hpú ye tuke, à sṍré mɔ pé sɔkɔ, tɛ́ wɛ̃̀kɩ̀ ni pé tyɩ́, à sɔkɔ Masedonɩ gbɛ̃̀nyah sɔkɔ. ");
INSERT INTO wib_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","À kénɛ gbɛ̃̀nyah pól kɔ kɔ̃, à sṍré yah mɔ kɔ̃ náhnáh Yesu yõ sɛ̃́pú sɔkɔ. Wǎh yal nɛ́npɔ́, à sɔkɔ Krɛsɩ gbɛ̃̀nyah, ");
INSERT INTO wib_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","à kyɩ ńwɔ̃́lɔ́ tɔ̃́nɔ́ pɩ nɛ́npɔ́. Képah náh, wǎh pɔ ǹ vi nɛ, pé de krótókè ǹgbɛ̃ sɔkɔ, pé yal n yuku Siri gbɛ̃̀nyah sɔkɔ, à kè wɛ noh nɛ, Nsyifunɔ-á mɛ ǹnɛ n plɔ pèkè yɔ́lɛ. Kǎh pɩ sɛ̃́, à kè yah tɔkɔ nɛ páh kɩ pé syɩ syɔ̃ Masedonɩ gbɛ̃̀nyahlɛ. ");
INSERT INTO wib_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Tɛ́ nónó-á sõ̀ Pole wɛ̃̀kɩ̀ kɔ́mûnɛ, pépi wɛ yɔ̀: Sopatɛrɩ nɛ̂-á n wil Bere kwil, tɛ́ ǹ sú yĩn mɛ Pirusilɛ, ǹmɔ sõ̀ mɛ, à tahlɩ Arisitarkɩ, ànɛ̂ Sekũdusi tyɩ́, pépi nónó-á n wil Tesaloniki kwil, ànɛ̂ Kayusilɛ, nɛ̂-á n wil Dɛrɩbɩ kwil, ànɛ̂ Tisyikilɛ, ànɛ̂ Torofiminɛ, pépi nónó-á n wil Asi gbɛ̃̀nyah sɔkɔ, à tahlɩ Timote tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Pépi mɛ sɔkɔ ápi yahlɛ, à kyɩ álɛ n syɩkɩ Turasɩ kwil. ");
INSERT INTO wib_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Búrn sɛ̃̀-ǹkɛ̃̂ syáh syáhnsɔkɔntɛnɔ náh, ápi wɔ mó kyɩ de krótókè ǹgbɛ̃ yɔ́ sɔkɔ Filipi kwil, à pé nyáh sõ. Á sèpĩ̀n kwâl pɩ tɛ́ pyě de á no tnɔ̂ Turasɩ kwil. Képah tɛ̃̀nɛ, á tɛ̃ nɛ́npɔ́ à sèpĩ̀n kwǎrninɔ pɩ. ");
INSERT INTO wib_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Yòh wrɔ́ gbĩ̀yĩ̀kì gben sõlɛ, á lésõ mɛ tuke mɔ Tɛ̃̀ ǹgbɛ̃ yõke yõ yĩnnɛ, tɛ́ Pole mɛ yã́hkɩ̀lɛ n yãh tɔ́wûlɛ. À kɩ sõ̀ n yal n pi dĩndallɛ Turasɩ kwil. Kǎh pɩ sɛ̃́, à Liyel wɛy yo mo pé tyɩ́, pópó à pɔ nɔ tyah tɔ́nɔ́ tyɩ́. ");
INSERT INTO wib_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Tɛ́ á pól sõ̀ mɛ tùkènmɔnɔlɛ gbɛ̃́ntĩ̂n yõ wɔ̀kɔ̀ tɔ̃́-ò sɔkɔ, tɛ́ fɔ̀tnɔ̀nɔ́ mɛ tũ̀nsàhnɔ́lɛ pípí ké sɔkɔ. ");
INSERT INTO wib_vp