﻿USE sofia;
DROP TABLE IF EXISTS sofia.wer_vpl;
CREATE TABLE wer_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES wer_vpl WRITE;
INSERT INTO wer_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yesu Kristo pim ëere körööröa kurment epël. Yesu pi Tewit pim kurmentëkaanëp. Ën Tewit pi Apram pim kurmentëkaanëp. ");
INSERT INTO wer_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Apram pi Aisakë pepap. Ën Aisak pi Yakopë pepap. Ën Yakop pi Yutaare pim nangre nanöröa pepap. ");
INSERT INTO wer_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ën Yuta pi Peresre Siraë pepap, ën piarpim ëlëp Tema. Ën Peres pi Esronë pepap. Ën Esron pi Ramë pepap. ");
INSERT INTO wer_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ën Ram pi Aminatapë pepap. Ën Aminatap pi Nasonë pepap. Ën Nason pi Salmonë pepap. ");
INSERT INTO wer_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ën Salmon pi Poasë pepap, ën pim ëlëp Reap. Ën Poas pi Opetë pepap, ën pim ëlëp Rut. Ën Opet pi Sesi pim pepap. ");
INSERT INTO wer_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ën Sesi pi omp ak Tewit pim pepap. Ën Tewit pi Solomonë pepap, pim ëlëp pöt Yuraiaë öng kapirëp. ");
INSERT INTO wer_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ën Solomon pi Riapoamë pepap. Ën Riapoam pi Apaisaë pepap. Ën Apaisa pi Esaë pepap. ");
INSERT INTO wer_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ën Esa pi Seosapatë pepap. Ën Seosapat pi Soramë pepap. Ën Soram pi Asaiaë pepap. ");
INSERT INTO wer_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ën Asaia pi Sotamë pepap. Ën Sotam pi Easë pepap. Ën Eas pi Esekaiaë pepap. ");
INSERT INTO wer_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ën Esekaia pi Manasaë pepap. Ën Manasa pi Emosë pepap. Ën Emos pi Sosaiaë pepap. ");
INSERT INTO wer_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ën Sosaia pi Sekonaiaare pim nangaröa pepap. Akun pötak Papilon nga omnaröak Yuta omnaröa naëaan narö wii tëak wak së Papilon yangerak moulmëën pitëm inëën eim wakaima. ");
INSERT INTO wer_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Yuta omën narö Papilon yangerak wakaima akun pötak Sekonaia Sialtielë pepap wakaima. Ën Sialtiel pi Serapapelë pepap. ");
INSERT INTO wer_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ën Serapapel pi Apaiatë pepap. Ën Apaiat pi Elaiakimë pepap. Ën Elaiakim pi Esoë pepap. ");
INSERT INTO wer_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ën Eso pi Setokë pepap. Ën Setok pi Ekimë pepap. Ën Ekim pi Elaiatë pepap. ");
INSERT INTO wer_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ën Elaiat pi Eliesaë pepap. Ën Eliesa pi Matanë pepap. Ën Matan pi Yakopë pepap. ");
INSERT INTO wer_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ën Yakop pi Yosepë pepap. Ën Yosep pi Mariaë ompöp. Ënak Mariaak Yesu, pim yapinte Kristo pël yema pöp wila. ");
INSERT INTO wer_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Apramökaan yewaisem wais Tewitëk elën, omën kur pöment 14 yaë. Ën Tewitëkaan yewaisem wais Papilon omnaröa pit wii tëak wak së Papilon yangerak moulmëa akun pötak ela pöröeta 14 tapël yaë. Ën pitëm Papilon yangerak wii kaatak saö pörekaan yewaisem wais Yesuu wilaurek oröa pöröeta 14 tapël yaë. ");
INSERT INTO wer_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesu Kristo pim wilauta ngönte epët. Öng Maria Yesu pim ël pöp omp Yosep pöp koirëpënëak yaö elmëën wëa. Pël ëautak piarip yal naën om namp nerek wëën, Maria pi Ngëëngk Pulöök elmëën önga namp tekeri sa. ");
INSERT INTO wer_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Pël ëën pim omp yaö elmëaup Yosep pi omën wotpilëp yak Maria omnaröa ëöetak ëö sëpanëak ëlëëp wes momëëpënëak kön wia. ");
INSERT INTO wer_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Yosep pi pël kön wieim ka uraan Aköpë ensel nampök wangartak oröak piin epël ök mëëa. “Yosep, Tewitë körööp, ni Maria pim öngaap wë piptaan kas ëëngan. Pim önga tekeri sak wë pipop, Ngëëngk Pulöök kaamök elmëënak wë. ");
INSERT INTO wer_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Pël ëën pi yokotup wilën pöt pim yapinte Yesu pël mam. Pi tapöpök pim omnaröa ketre saunat ent ë nuulëak utpetetakaan kama niöpnaap.” ");
INSERT INTO wer_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Omën nant peene e orö yes epot, Aköp pimtë tektek ngön yaaö omën naröen ök maan pitëm tekeri wesak ök niiaö aprö ima pötök kë yaarö. ");
INSERT INTO wer_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Kat wieë. Koont öng tek nampök ru yak sak yokot namp wilëpnaan yaë. Pël ëen pitök yokot pöpë yapinte Emanuel pël mapnaap.” Yapin pöta songönte epët. “Anutu tiarring wë.” ");
INSERT INTO wer_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Pël maan Yosep pi wal ëak Aköpë enselëpë ök mëëa pöl ëak Maria koira. ");
INSERT INTO wer_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pël ëautak Maria yokot pöp nawilën wëën Yosep piiring ka naurön ëa. Pël ëën yokotup wilën pim yapinte Yesu pël mëëa. ");
INSERT INTO wer_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Omp Erot pim Yutia yangerak omp ak sak wëa pötak Mariaak pörek Petelem kak Yesu wila. Pël ëën ënëmak këtëpë yengampiaulaan ëwat omën narö Yerusalem kak së oröak epël pëël mëëa. ");
INSERT INTO wer_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Runga ngolöp oröaup, Yuta omnaröa omp ak sëpna pöp e tarëk wë? Ten pim tangewes këtëpë yengampiaulaan oröak wëën itenak yaya manëak yewais,” pël mëëa. ");
INSERT INTO wer_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Pël maan omp ak Erot pöpre ën Yerusalem kakë omnarö pit ngön pöten kat wiak yaan sak kön selap wia. ");
INSERT INTO wer_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Pël ëak omën omp ak Erot pi kiri ar yaaö wotöököröere ën Mosesë ngön kosangotë ngarangk pouröen ngön maan së pim naë rongan ëën ngön pötaan yak pitën, “Kristo pi kak tarëk orööpnaap?” pël mëak pëlpël mëëa. ");
INSERT INTO wer_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Pël maanak pit epël mëëa. “Petelem kak Yutia yangerak orööpnaap. Ngön pöt tektek ngön yaaö omën nampök epël retëng ëaut. ");
INSERT INTO wer_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘O Petelem kak Yutia yangerak wëaurö, arim kak Yutia yangerak ka wia pötë iri naëpan. Pöt arim naëaan omën kësang nampök oröak Israel nem omnaröa ngarangk sëpnaat.’” ");
INSERT INTO wer_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Pël maanak omp ak Erot pi ëlëëp këtëpë yengampiaulaan ëwat omën pöröen ngön maan pim naë sëën pitën, “Tangewes akun taltak oröak wëën itena?” pöten pëël kat wia. ");
INSERT INTO wer_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Pël ëën pit ök maan pi pitën epël ök mëak Petelem kakë wes momëa. “Ar së kosang ngentiak ap wesak runga pöp koirak pöt kaalak wais neen ök nean. Pël ëën neenta së itenak piin yaya memaan,” pël mëëa. ");
INSERT INTO wer_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Pël maan pit kat wiak sëp wesak kan yesem itaangkën tang peen ngaantak pitëm këtëpë yengampiaulaan oröak wëën itena pöwes pitëm wet rëak së ruupë ka wieëaö pöta ngaarëk leng ëak wëa. ");
INSERT INTO wer_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ënak pit tang pöwesën itenak ya kë panë sa. ");
INSERT INTO wer_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Pël ëak ka pöta kakaati së itaangkën ruupre ën pim ëlëp Maria wëa. Pël ëën pit së rar rë mowesirak yaya mëak pitëm ul keus köröökaan sum kësang yaaö nant, aini koolre kos lölöp kamp yaaöre i kamp ompyaö yaaut yowe mena. ");
INSERT INTO wer_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Pël ëak pit rö kan ka uraan Anutuuk wangartak omp ak Erotë ngësël sëpanëak nga mëak pepanöm maan pit sëp wesak pim naë nasën, kan munt naöök kaalak pitëm kakël kan sa. ");
INSERT INTO wer_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Pit kan sëën Yosep ka uraan Aköpë ensel nampök wangartak oröak piin epël ök mëëa. “Ni wal ëak Yesure ëlëp mësak kan kas Isëp yangerakël së. Erot pi runga pipop ap wesak mëmpënëak yaë pötaan. Ni pörek së wë kat wiaan ënëmak nemtok kaalak waisën pël niaanak waisënëën.” ");
INSERT INTO wer_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Pël maan Yosep pi wal ëak Yesure ëlëp mësak Isëp yangerakël röök taptakëër kan sa. ");
INSERT INTO wer_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Pël ëak pit Isëp yangerak së wëën omën omp ak Erot pöp ënëmak wel wiin akun pötak kaalak waisa. Pöt Aköpë ngönte tektek ngön yaaö nampök ök ëa pöt kë rëa. Ngön pöt epët. “Ne nem ruup Isëp yangerak wëën yas maan waisa.” ");
INSERT INTO wer_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Omp ak Erot këtëpë yengampiaulaan ëwat omën pörö pi morök elmëa pöten kön wiak ya sangën kaö pan ëa. Pël ëak pim omën naröen maan pit së Petelem kakre ka kot naë wieëa pötë yokot kot narö krismaki nentepar il newasën pörö pourö mën won wesa. Pöt ëwat omnaröa tangewesi oröön itenak ök mëëa akun pöten kön weswes ëak ök maan së mën won wesa. ");
INSERT INTO wer_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Akun pötak tektek ngön yaaö omën Seremaia pöpë ngön ëa pöt kë oröa. ");
INSERT INTO wer_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Pöt epët. “Rama kakaan ingre këlël kaö panë yaan kat wia. Öng Resel pim ë körööröak pitëm rungaaröaan yaköm ëën ing aima. Pël yaëën omnaröak yok pangk pit wiap nemowasën ëa. Pöt pitëm rungaarö wel wia pötaanök.” ");
INSERT INTO wer_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Omp ak Erot pöp wel wiin Aköpë ensel namp kaalak Yosepë naë oröak wangartak epël ök mëëa. ");
INSERT INTO wer_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Omën rungaap mëmpënëak ëa pörö yok wel wia. Pötaanök piar ëlëp mësak Israel yangrakël së.” ");
INSERT INTO wer_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Pël maan Yosep pi wal ëak Yesure ëlëp mësak Israel yangerakël sa. ");
INSERT INTO wer_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Pël ëak pi kat wiin Akeleas pöp pim pepap Erot pim urtak Yutia yangera omp ak sak wëa. Pël ëën pi we pöökël së öpnaaten kas ëa. Ënak Anutuuk piin wangartak pepanöm maan pi pörek sëp wesak Yesure ëlëp Kalili yangerakël mësak sa. ");
INSERT INTO wer_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Pël ëak pit së ka naöökë yapinte Nasaret pël ya pöök wakaima. Pöt Anutuu tektek ngön yaaö omën naröa Yesu pimëën ëa pöt kë oröa. Ngön pöt epët. “Omnaröak piin Nasaret omnamp pël mapnaap.” ");
INSERT INTO wer_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Akun pötak Son omnarö i yamëa pöp oröak Yutia yang omën wonrek Anutuu ngönte ngës rëak epël ök maima. ");
INSERT INTO wer_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Anutuuk tiar wa ngaöök nimëëpna akunet yok temanöm yes. Pötaanök ar lup kaip tiak utpetat sëp wesak kasëng meneë.” ");
INSERT INTO wer_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Son pöpön Anutuu tektek ngön yaaö omën Aisaia pöpök ngön epël ëa. “Yang pultakaan omën nampök epël ya. ‘Aköpëën kanö wotpil weseë. Ngësak ompyaö panë weseë.’” ");
INSERT INTO wer_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Son pöp pim ulpëën kosangëp pol kamel ëpötök ket ëak mëak wëa. Pël ëak pol koröpöök yepat ket ëaö naö ureëa. Ën pim kaömp pöt ngëntre mop pëën neima. ");
INSERT INTO wer_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Yerusalem kakaanre Yutia yang poutëaanre Yotan i pouuk ka wieëa pötëaan omnarö pim naë së rongan ëa. ");
INSERT INTO wer_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Pël ëak pitëm ketre saunat tekeri wesak ök maan Sonök Yotan imeri i momëa. ");
INSERT INTO wer_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Son pi itaangkën Parisiire Satusi ngönën omën narö kësang puuk i momëëpënëak yesën itenak pitën epël ök mëëa. “Kamalöröa morök yaalni pöl ar yaaurö. Ar kön wiin nem naë waisën i nimëëma pöt Anutuuk nga elniipënëak ëa pöt naalniipan. ");
INSERT INTO wer_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ar lup kaip tiak wëwë pötakël önë pötakëër omnaröak arën itaangkën lup kaip tian pël ëëpnaat. ");
INSERT INTO wer_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Arimtë könöök epël angan. ‘Ten Apramë köröörö,’ pël angan. Ar kön wi kosang newasën wë, ‘Ten Apramë köröörö,’ pël anë pöt pangk naën. Ne niamaan kat wieë. Anutu pi apënëak pöt yok pangk aan kël epotök Apramë körö koröp orööpnaat. ");
INSERT INTO wer_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Anutu pim iner këra songöntak wia. Pöwer këra nement ulöp ompyaö nautön ëëpna pöt ku tiak es marën kotöpnaat. ");
INSERT INTO wer_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Omën nem ënëm waisëpna pöp pim weëre kosangtak nemët il wasëpnaap. Ne utpet epopök pim ing korötepar yok pangk wak nasëngan. Ne ar lup kaip tiak arim utpetat sëp wasënëëtaan i yaaptaring yanimë. Ën puuk pöt ar Ngëëngk Pulöök i ket ëak nimëën esuwesi ök arim utpetat kotak won sëpnaat. ");
INSERT INTO wer_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Pi pim kat yaurautaring wais kat ur rongan ëak kaömp ompyaut wa pim kaömp kaatak wiipnaat. Pël ëak unönre söksök pöt wa top ëak es kosangwesi moolaan kot sëpnaat.” ");
INSERT INTO wer_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Akun pötak Yesu pi Kalili yanger sëp wesak Sonök i momëëpna yak Yotan i pouukë sa. ");
INSERT INTO wer_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Pël ëën Son pi ke mourak piin epël ök mëëa. “Ni oröpmorëën nook i nimëëmëak yenëaan? Ne omën pasip, ën nuukëër omën kaöap. Pötaan nuukëër yok pangk ne i nemëëmëëp. Pël ëautak ni nook i nimëëmëak waisan.” ");
INSERT INTO wer_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Pël maan Yesuuk kangiir epël ök mëëa. “Ni peene kat newiak pël ëëm. Tepër wotpil wesak Anutuu ngön pout ngaarëk öpëa pöt pangk ëëpnaat.” Pël maan Son kuure mak mëak i momëa. ");
INSERT INTO wer_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Sonök Yesu i momëën pi akun tapëtakëër imeriaan oröak itaangkën kutömwer këm nga ëën Ngëëngk Pulö int ekëpë ök sak pim rangk irë ngentia. ");
INSERT INTO wer_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Pël yaëën kutömweriaan ngön nent epël irëa. “Epop nem Ruup. Ne piin ya kë sak kent pan yaalmë.” ");
INSERT INTO wer_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Setenök Yesu morök elmëëpna yak Pulöök Yesu mësak së yang pultak omën won panëërek moulmëa. ");
INSERT INTO wer_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Pël ëën Yesu pi kaömp nanën wë këtre röök akun 40 pël ëak sa. Pël ëën ënëmak pi këënëën elmëa. ");
INSERT INTO wer_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Pël ëën Seten pi oröak morök elmëak epël mëëa. “Ni Anutuu Ruup. Pötaanök kël epotön maan kaömp sëën në.” ");
INSERT INTO wer_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Pël maan Yesuuk kangiir kaip tiak epël mëëa. “Ngönëntak epël wia. ‘Kaömp pöt pëënök omnaröa wëwëet nanimpan. Anutuu këmtakaan pim ngön ëaut pout ngaarëk weim öpna pöpökëër wëwë om wakaim öpnaap.’” ");
INSERT INTO wer_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Pël maanak Setenök kaalak Yesu pi mës wak së Yerusalem ka kësang ngëëngköökë ngönën tup kaöeta möröök moulmëak ");
INSERT INTO wer_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","epël ök mëëa. “Ni Anutuu Ruup. Pötaanök öngkrek sörok ola. Pöta ngönte ngönëntak epël wia. ‘Anutu pi pim enselöröen maan ni ngarangk elniipnaat. Pël ëak këlötok nim ingesi niwalpanëën pitök morötök akaak elniipnaat.’” ");
INSERT INTO wer_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Pël maan Yesu pi kaalak kangiir epël mëëa. “Ngönën nenteta epël wia. ‘Aköp Anutu kaamök elniipnaaten ököök elmëëngan.’” ");
INSERT INTO wer_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Pël maanak Seten pi kaalak Yesu mës wak së rosir wali panë naöök moulmëak omnaröa kaare yang poutre ën pitëm omnant ompyaö poutön pet elmëak ");
INSERT INTO wer_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","piin epël mëëa. “Ni nemëën rar rë nowesirak yaya neamë pötak ne e yangerakë omën ompyaö epot pout nimpaat” mëëa. ");
INSERT INTO wer_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Pël maan Yesuuk epël mëëa. “Seten, ni mop wiak kama së. Pöt ngönëntak epël wia. ‘Aköp Anutuun yaya mam. Pimënt kopëtapön inëën elmëëm.’” ");
INSERT INTO wer_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Pël maan Seten pi yok Yesu pörek sëp wesak kan sëën ensel narö së pi kaamök elmëa. ");
INSERT INTO wer_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yesu pi kat wiin Son pi omën naröak wak wii kaatak moulmëën wë pël maan Yesu pi Kalili yangerakë sa. ");
INSERT INTO wer_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Pi Nasaret kak sëp wesak Kapaneam kak së wakaima. Ka pö i kaöökë ëöök Sepulanre Naptalai yang pöraarë tekrak wieëau. ");
INSERT INTO wer_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Pël ëën Anutuu ngönte tektek ngön yaaö omën Aisaia pöp pim ök ëa pöt kë oröa. Pöt epët. ");
INSERT INTO wer_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sepulanre Naptalai yang pöraarë, i kaöökë naë, i Yotanë nal komuntakël, Kalili yang ngönën wonöröa wëaurek, ");
INSERT INTO wer_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","omën narö pörek koutak wëa pörö pit yok ëwa kësangöön itena. Ën omën pörek koutak wë wel wiak kö sëpënëak yaaö pöröa naë ëwaö yok oröa.” ");
INSERT INTO wer_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Akun pötak Yesu pi ngës rëak ngönën epël ök maö ima. “Anutuu wa ngaöök nimëëpna akunet yok temanön yes. Pötaanök ar lup kaip tieë.” ");
INSERT INTO wer_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesu pi Kalili i kaö pöökë pouuk yesem itaangkën omp nanang naar, namp Saimon pim yapin nent Pita, ën pim nangap Entru, piarip i kaö pöök iir yoolaan itena. Pöt piarip i kaö animaurö korak wes mëak mon wa pël eim wëa. ");
INSERT INTO wer_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Pël yeem wëën Yesu pi piaripön ngön mëak epël mëëa. “Arip nem ënëm waiseë. Pël ëën nook aripön arpim i kaö animaurö yewan pi tapël omnaröeta önëën niulëëmaan.” ");
INSERT INTO wer_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Pël maan piarip teëntom panë piarpim iiröt om wiak pim ënëm sa. ");
INSERT INTO wer_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Pël ëën pi kaalak yesem itaangkën omp nanangën munt naar, piarpim pepapring i kaö wang naöökë rangk wë iiröt ompyaö yewasën itena. Piarpim yapintepar, namp Sems, namp Son, ën piarpim pepap Sepeti. Pël ëën pi piaripön pim ënëm sëpënëak mëëa. ");
INSERT INTO wer_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Pël maan piarip teëntom panë piarpim pepapre wangaö sëp wesak Yesuu ënëm sa. ");
INSERT INTO wer_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu pi Kalili yangerak ka wieëa pötë së omnaröen ngönën tupötë kakaati Anutuu ngönte rë moulak pim wa ngaöök nimëëpna ngön ompyaö pöt ök mëak omën yauman ke nentere nent yaaö pöröere omën koröp lup nantë utpet ëa pörö pourö këëkë moweseima. ");
INSERT INTO wer_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Pël ëën Yesu pim pël yaaö pöta ngönte aö yesem Siria yangerak oröön yang pör pangk ëa. Pël ëën omën pörek wëaurö pöten kat wiak pitëm yauman omën pourö pim ngësë mësak sa. Yauman omën pörö, narö yauman ke nentere nent waurö, ën narö këlangön ke nentere nent kat yawiaurö. Ën këlangön kat yawia pörö, narö urmerarö pitëm lupötë wëaurö, narö om pas kawi ngentiak reireë ureim wëaurö, ën narö kosat kël waurö. Omën yauman piporö pourö pit pim naë mësak sëën këëkë moweseima. ");
INSERT INTO wer_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Pël yaëën Kalili yangerakaanre Tekapolis yangerak ka 10 pötëaanre Yerusalem kakaanre Yutia yangerakaanre i Yotanë nal komuntakëlaan omën kësang pan pim ënëm ëa. ");
INSERT INTO wer_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu pi omën kësang panë pim ënëm sa pöröen itenak rosir naöök së wel aisëak wëa. Pël ëën ruurö pim naë sa. ");
INSERT INTO wer_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Pël ëën pi ngës rëak ya rë moulak pitën epël ök mëëa. ");
INSERT INTO wer_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Omën pitëmtë lupötön kön wiin ompyaut won yaë piporö Anutuuk wa ngaöök yemomë. Pötaanök pit ërëpërëp ëëpnaarö. ");
INSERT INTO wer_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Omën ingre ya ilak aim wë piporö Anutuuk wiap mowasëpnaat. Pötaanök pit ërëpërëp ëëpnaarö. ");
INSERT INTO wer_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Omën ya wiapring wë piporö yang ngolöpra omnantëën yaö sëpnaat. Pötaanök pit ërëpërëp ëëpnaarö. ");
INSERT INTO wer_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Omën wëwë wotpilte öpnaaten kent ëën weë yengenti piporö Anutuuk wëwë wotpil pöt mangkën öpnaat. Pötaanök pit ërëpërëp ëëpnaarö. ");
INSERT INTO wer_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Omën karuröaan yaköm yaalmëa piporö Anutuuk yaköm elmëëpnaat. Pötaanök pit ërëpërëp ëëpnaarö. ");
INSERT INTO wer_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Omën lup kölam wë piporö Anutuun itaampnaat. Pötaanök pit ërëpërëp ëëpnaarö. ");
INSERT INTO wer_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Omën mayaap wiaapnaataan weë yengenti piporöen Anutuuk pim ruurö pël mapnaat. Pötaanök pit ërëpërëp ëëpnaarö. ");
INSERT INTO wer_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Omën pitëm wëwë wotpil yaaö pötaan omën munt naröak utpet mowasën këlangön kat wiipna piporö Anutuuk wa ngaöök momëëpnaat. Pötaanök pit ërëpërëp ëëpnaarö. ");
INSERT INTO wer_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Ën naröak itaangkën ar nem ënëm yeëan ëën pöt ökre was niiaöre utpet elniire ngön utpet ke nentere nent ngön kaar niiaö pël yaëën pöt ërëpërëp ëënëët. ");
INSERT INTO wer_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Pöt naröak tektek ngön yaaö omën ngaan wakaima pöröaan utpet ke pil elmëeimaurö. Pötaanök pitök peene ar pil yaalniin pöt, ‘Ënëmak kutömweriaan kangut kësang önaat,’ pël weseë ya kë sak ërëpërëp ëën.” ");
INSERT INTO wer_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Tomunat polötë olaan söp naën yaë pöl ar yangerakë omnarö utpet ëëpanëak kaamök yaalmëaurö. Pël yaauröak tomun pötë misëngö som sak wiaan tiar tol ëak kaalak misëng wasën pangk ëëpën? Pël naëngan. Tomun som ke piltak omnant pangk misëng newaspan. Pötaanök wa moolaan omnarö ing mësaö kan ing ëëpnaat. Ar ngön epët kasëng menak pöt tomun misëng won pöta ök sënëët. ");
INSERT INTO wer_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Ën es ëwaöök rö kanötë omnarö kaamök elmëën kamtaöök yes pöl ar yangerakë omnarö Anutuu ënëm sëpënëak kaamök yaalmëaurö. Ar ka naö rosiraöök wieëa pöökë ökörö. Ka pö ëlëëp wi naöpan, om tekeri wiaan omnarö maimerekaan pangk itaampnaat. ");
INSERT INTO wer_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ën omnarö esuwes mangiak kapita öngpök namëëpan, ngaarëk wasën kakaati ëwa ëaan omën kakaati wëaurö omnantön pangk itaampnaat. ");
INSERT INTO wer_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Arim omnant yaaut esuwesi ök ëëp. Omnarö itenak arim Pep kutömweri wë pöpë yapinte ngaarëk wak isak apnaan omën ompyaut ëeë.” ");
INSERT INTO wer_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Arök ne Moses pim ngön kosangötre tektek ngön yaaö omnaröa ngönöt wa moolamëak waisan pël wasnganok. Ne pipot wa moolamëak newaisënëp. Ngön pi tapöt kë orööpënëak waisaup. ");
INSERT INTO wer_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ne yaap pan niamaan. Kutömre yang epweriar won nasën wiaan Mosesë ngön kosang lup kot nent ap nasëpan, pout kë rapnaat. ");
INSERT INTO wer_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Omën Mosesë ngön kosang lup kot panë nent wa moolëak naröen tapël ëëpënëak mapna pörö pit omën Anutuu wa ngaöök momëëpnaaröa ikanöök öpnaarö. Ën omën ngön pöt pout ngaarek wak naröen tapël ëëpënëak mapna pörö omën Anutuu wa ngaöök momëëpnaaröa naë kaö sak öpnaarö. ");
INSERT INTO wer_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ne niamaan kat wieë. Arim Anutuu ngönte ngaarëk wak wëwë wotpil yaaö pötak omën ngön kosangötë ngarangköröere Parisi ngönën omnaröa pël yaaö pöt il newasën ëëpna pöt ar Anutuu naë rë olëak wëën wa ngaöök nanimëëpan.” ");
INSERT INTO wer_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Ëaröen ngön ök mëëa pöt ar yok kat yawiaurö. Pöt epët. ‘Ni nim karip mëngkanok. Ën ni namp pël ëëmë pöp ngön yaatak oröömëëp,’ pël yaan kat wi yeë. ");
INSERT INTO wer_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ën nook pöt ök niamaan kat wieë. Omën namp pim karipön ya sangën ëëpna pöp pi ngön yaatak orööpnaap. Ën namp pim karipön utpet wesak mapna pöp pi ngarangk wotöököröa naë oröak ngön ya mëmpnaap. Ën namp pim karipön, ‘Kaökaö,’ kip mapna pöp pi es parëaöökë yaö sëpnaap. ");
INSERT INTO wer_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Pötaanök ni omën nant Anutuun kiri wiimëak wak së kiri yawiaurek wë kön wiin nim karipëën utpet elmëën pi niiring ngön wieëaupök ëanëën pöt ");
INSERT INTO wer_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","sëp mowasum. Pël ëak om kiri yaauta naë wiak kaalak së. Pël ëak nim karipring arpim ngön wieëa pöt wilak wotpil wesak sëak Anutuun yowe wiim. ");
INSERT INTO wer_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Ën omën nampök ni ngön yaatak nuulëëpënëak yaan pöt ngön yaaurek nasën wieëaar ngön pöt teëntom ë pet irak ngöntre kar ëeë. Pöt puuk ni omën ngön ë pet yairaupë moresi nuulëën polisöröa moresi wes nimëën wii kaatak nuulnëëpanëën. ");
INSERT INTO wer_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ne yaap panë niamaan kat wi. Ni pörek wë teënt naarööngan. Nim karipë kangut pet pan ir olëakök oröömëëp.” ");
INSERT INTO wer_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Ngön kosang nent yaan ar yok kat yawiaurö. Pöt epët. ‘Ni öngre omp wëwëet kom ëënganok.’ ");
INSERT INTO wer_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ën nook pöt, ök niamaan kat wieë. Omp namp öng nampön itenak kent kön wiin pöt yok könöök öng ngësëp sëp yewas. Pël ëak öngre omp ë ngön kosangët ilap riak saun yokoir. ");
INSERT INTO wer_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ën omën nent nim it yaapkëöök itaampë pötak wak weru nuulaan utpet ëëmëak yeem pöt it pö ti moolam. Pöt koröp kaö nentak elniin utpet ëak nim koröp pou es parëaöökë sëpanëën koröp kaö kopët pöt won wasumë pötakëër ompyaö. ");
INSERT INTO wer_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ën nim mor yaapkëëwesök kentöökë ënëm ëak utpet nent ëëmë pöt nim mor pöwes kama il moolam. Pöt koröp kaö nentak elniin utpet ëak nim koröp pou es parëaöökë sëpanëën koröp kaö kopët pöt won wasumë pötakëër ompyaö.” ");
INSERT INTO wer_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Ngön kosang munt nenteta epël yaan ar yok kat yawiaurö. ‘Omp namp pim öngöp wes mëëpënëak pöt öngre omp yailauta pepewer pim öng pöp mamp.’ ");
INSERT INTO wer_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ën nook pöt, ök niamaan kat wieë. Omën namp pim öng omp nga naën yaaupök wes mëëpna pöt pim pël elmëëpna pötaan öngöp omp munt namp yokoirem öngre omp ë ngön kosangët ilap riak saun koirëpnaat. Ën namp pi munt nampë öng wes mëa pöp koirëpna pöt piita öngre omp ë ngön kosangët ilap riak saun koirëpnaat.” ");
INSERT INTO wer_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Ën ngön kosang munt nent ëaröen ök mëëa pöt ar yok kat yawiaurö. Pöt epët. ‘Ni omën nent ëëmëak Aköpë ëöetak kaar kosang wesak anganok. Omën nent pël ëëmëak pim ëöetak kosang wesak pöt ngaarëk wëën këët orööp.’ ");
INSERT INTO wer_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ën nook pöt, ök niamaan kat wieë. Ar ngön nent kosang wasënëak ngaarëkël wesak yaap pël anganok, won pan. Ar kutömweriil wesak kosang wasnganok. Kutöm pöwer Anutu pim wëauwer pötaanök. ");
INSERT INTO wer_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ën e yangerakëlta mëak kosang wasnganok. Yang epëreta Anutu pim ingesiarë urte pötaanök. Ën Yerusalem kakëlta yapin mëak kosang wasnganok. Yerusalem pö Omp Ak kaöapë ka kësangö pötaanök. ");
INSERT INTO wer_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ën nim kepönöökëlta ngön nent kosang wasnganok. Nuuk yok pangk kepön ëp naön maan koöre kölam naëpan pötaanök. ");
INSERT INTO wer_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ar omën nent ëënëak pöt om, ‘Mak, ne pël ëëmaap,’ pöt pëën an. Ma omën nent naën ëënëak pöt om, ‘Won, pël naëngan,’ pöt pëën an. Arim omën nantëël mëak kosang wasënëak ngön munt nant anë pöt Setenë naëaan orööpnaat.” ");
INSERT INTO wer_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Ngön kosang nent epël yaan ar yok kat yawiaurö. ‘Omën nampök nim it naö utpet nuwasën pöt kangiir pim naö utpet mowasumëëp. Ën omën nampök nim kë naö nitiin pöt kangiir pim naö motiimëëp.’ ");
INSERT INTO wer_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ën nook pöt, epël niamaan kat wieë. Omën nampök ni utpet yaalniin pöt kangiir elmëënganok. Ën omën nampök nim kerëm yaapkëëtak nimöön pöt katnëëteta nimööpnaan mowasum. ");
INSERT INTO wer_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ën omën nampök nim ulpëën iriip öpënëak ngön yaatak nuulëak ngön nent nimëën wesak niaan pöt ulpëën rangkëëpta përë mamp. ");
INSERT INTO wer_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ën omën kaö nampök kan mëntöök omën nant wak sumëak kosang wesak niaan pöt nuuk kan waliöököl wak sum. ");
INSERT INTO wer_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ën omën nampök ni omën nant pi mampëak kimang yeniaan pöt mamp. Ën nampök nim naëaan omën nant yaam öpënëak yaan pöt keimön ëënganëp mamp.” ");
INSERT INTO wer_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Ngön kosang nent epël yaan ar yok kat yawiaurö. ‘Nim karipön lup sant elmëëm. Pël ëak nim kööre toköpön kaaö elmëëm.’ ");
INSERT INTO wer_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ën nook pöt, ök niamaan kat wieë. Arimëën kööre tok yaalniaurö lup sant elmëën. Ën utpet yaalniaurö Anutuuk kaamök elmëëpnaan kimang man. ");
INSERT INTO wer_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ar omën ke pilöt ëënë pöt arim Pep kutömweri wëaup pim ru panë sënëët. Pöt puuk pim këtëpön maan omën utpetere ompyaö pouröa rangk yema. Ën pi tapöpök pim kopiirenta maan omën wotpilre korar pouröa naë yepel. ");
INSERT INTO wer_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Arën lup sant yaalniaurö kangiir elmëënë pöt Anutuuk ompyaut nimpnaat ma? Won. Utpet yaaurö pitta lup sant tapël elmë yaë. ");
INSERT INTO wer_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ën arimtë karuröenökëër sant mowasënë pöten kön wiin arök omën muntarö il wesak ompyaö ëën sa ma? Won. Omën ngönën wonörö pitta sant tapël mowas yaë. ");
INSERT INTO wer_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Pötaanök arim Pep kutömweri wëa pöpë ompyaö wotpil wë pöl arta ompyaö wotpil wë arim kööre toköröen ompyaö moweseim ön.” ");
INSERT INTO wer_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Ar arimtën ngarangk këëkë ëën. Arim ngönën yaat omnaröa ëöetak pit itenak arën kön wiin ompyaö ëëpna pöl wesak mëngkanok. Pël ëënë pöt arim Pep kutömweri wëaup kön wiin ompyaö naën ëën ompyaö kangut naningkën ëëpnaat. ");
INSERT INTO wer_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Ni omën il ngentingenti yaaurö omnant kaamök elmëëmëak pöt kaar yaauröa ök elmëënganok ëlëëp mamp. Kaar omën pörö pit omën muntaröak itenak pitëmëën wak isak apëna yak omën il ngentingenti yaaurö kaamök ëak omnant ngönën tupötëëre kamtatë omnaröa itöök yemengkaurö. Ne yaap yeniak. Omnaröa pitëmëën wak isak yaaö pötök pitëm kangut yok yemangk. Pötaanök pit puorö ënëmak Anutuuk kaalak ompyaö kang munt nant nemangkën ëëpnaarö. ");
INSERT INTO wer_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ni pöt omën il ngentingenti yaaurö kaamök elmëëmëak pöt omnant ëlëëp panë wesak mamp. Nim mor yaapkëëwesök omnant yemangkën katnëëwesi ëwat nasën ëëpna pöta ök karuröak nim mampëëtön ëwat nasën ëëp. ");
INSERT INTO wer_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ni omnant ëlëëp mampë pöt nim Pep omën ëlëëp pipotön ityeengkaupök ompyaö kangut nimpnaat.” ");
INSERT INTO wer_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Ar Anutuun ök manëak pöt kaar omnaröa yaaul ëënganok. Pit omnaröak itenak pitëmëën wak isak apëna yak ngönën tupötë kakaatiire kamtatë, omnaröa itöök, taueë Anutuun ök mapnaaten kent yaaurö. Ne yaap yeniak. Omnaröa pitëmëën wak isak yaaö pötök pitëm kangut yok yemangk. Pötaanök pit ënëmak Anutuuk kaalak kang munt nant nemangkën ëëpnaarö. ");
INSERT INTO wer_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ar Anutuun ök manëak pöt arimtë kaatë kakaati së kan wariak arim Pep ëlëëp wë pöpön ök man. Pël ëënë pötak arim Pep ëlëëp yamëëautön ityeengkaupök kangut nimpnaat. ");
INSERT INTO wer_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Arim Anutuun ök yamëëautë ngönën wonöröa ök ëak ngön paspas nentere nent kësang anganok. Pitëm pël yaaö pöt, pitëmtok kön wiin ngön wali yemaan Anutuuk kat mowiipnaat wesak pël yaaurö. ");
INSERT INTO wer_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ar pitëm ök ëënganok. Pep piin kimang nemaan wëën arim ap yewesautön ëwat yaaup. ");
INSERT INTO wer_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Pötaanök ar Anutuun epël ök man. ‘Tenim Pep kutömweri wëaup, nim yapinte ngëëngk wiaap. ");
INSERT INTO wer_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ni wais wa ngaöök nimë. Kutömweri wëaurö nim këm ngön ngaarëk yeö pöl e yangerak wëaurö teenta tapël ëënëak kent yaë. ");
INSERT INTO wer_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ni peene kët epta könkön kaömp nimp. ");
INSERT INTO wer_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Tenim saunatë kangut kërë nuula. Tenökta omnaröa saun tenimëën yaalni pötë kangut tapël kërë yemoolak pötaanök. ");
INSERT INTO wer_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Moröktak nuulëënganëp, pim naëaan ent ë nuulë.’ ");
INSERT INTO wer_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Yaap, ar omnaröa arimëën utpet elniauta kangut kërë moolanë pöt arim Pep kutömweri wë pöpökta arim utpet yaautë kangut kërë nuulapnaat. ");
INSERT INTO wer_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ën ar omnaröa arimëën utpet elniauta kangut kërë nemoolaan ëënë pöt arim Pepap puukta arim utpet yaautë kangut kërë nanuulaan ëëpnaat.” ");
INSERT INTO wer_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ar Anutuun yak kaömp ngës olëak pöt omën ngön kaar yaauröa ök koöre sap ëak önganok. Pit kaömp ngës olëak wë pël yaëën omnaröak pitën itenak wak isak apëna yak koöre sap ëak wëaurö. Ne yaap yeniak. Omnaröa pitëmëën wak isak yaaö pötök pitëm kangut yok yemangk. Pötaanök pit puorö ënëmak Anutuuk kaalak ompyaö kang munt nant nemangkën ëëpnaarö. ");
INSERT INTO wer_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ar kaömp ngës olanëak pöt arim wëaul uwari mëak arim këëre wot kanöt iirën. ");
INSERT INTO wer_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Arim kaömp ngës olëak önë pöt, omnaröak itenak ëwat nasëpan, arim Pep ëlëëptak wë pöpökëër itaampnaan pël ëën. Pël ëënë pötak arim Pep ëlëëp pipotön ityeengkaupök ompyaö kangut nimpnaat.” ");
INSERT INTO wer_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Ar yangerakë omnant iwal ka ëëre kumkum ë, omnaröak ka pör menak këkain wë pël yaaut kësang wiak önganok. ");
INSERT INTO wer_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Anutuuk arimëën omën ompyaut kutömweri ningkën önëën omën ompyaut ëeë. Kutömweri pötökëër iwal ka ëëre kumkum ë, ën omnaröak ka pör menak këkain wë pël naën yaaut. ");
INSERT INTO wer_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Arim omën ompyautë wia pörekël arim könötta wiaapnaat.” ");
INSERT INTO wer_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“It pipöörar arim koröpöökë rampewes. Arim itöök omnant itenak kön ompyaut yawiin pöt arim lupötë rampewesi yaë pöl ëwa ompyaö ëaapnaat. ");
INSERT INTO wer_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","En arim itöök omnant itenak kön utpetat yawiin pöt arim lupötë koö olëaapnaat. Pötaanök arim lupötë ëwa wia pipët koö olapna pöt koö pöt sasa kësang panë olëaapnaat.” ");
INSERT INTO wer_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Omën nampök yok pangk omën omp ak naarë inëën naën ëëpnaat. Pi nampön kaaö yaalmëem nampön ngöntre kar elmëëpnaat. Won ëën pöt, kangiir nampë naë rë olëak wë namp kasëng mampnaat. Pötaanök arta tapël Anutuu yaatere monere uröma yaat mëngkre mëngk namëngkan.” ");
INSERT INTO wer_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Pötaanök ne arën epël ök yeniak. Ar arimtë wëwëetaan kön selap ëak epël anganok. ‘Tiar kaömpöt tarëkaan öpen? Ma iit tarëkaan öpen?’ Ën koröpöönta kön selap ëak epël angan. ‘Oröpötök kör koëpen?’ Kaömp pöt këët won, wëwëetakëër këët. Ën ulpëënre poë koröp pöt këët won, koröpöökëër këö. ");
INSERT INTO wer_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ar intöröen kön wieë. Pit kaömp ngëntak nëëre wa peram wi pël naën yaauröak arim Pep kutömweri wë pöpök kaömp koir mangkën neim wë. Omnarö arök intörö il yewas. Pötaanök pi ngarangk elniipnaat. ");
INSERT INTO wer_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ma arim naëaan nampök weëre kosang wia pöt yok pangk pimtë wëwëeten kön selap ëak kot nent wali wes ulmëëpën sa ma? Won. ");
INSERT INTO wer_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ën ar tol ëënak ulpëënre poë koröpötëën kön selap yeë? Ar polpol puutön kön wieë. Pit pitëm ulpëënre poë koröpötëën ya namëngkën yaë. ");
INSERT INTO wer_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Pël yaëëtak ne epël ök yeniak. Omp ak Solomon pi omnant kësang wieëaupök ë rangiak wakaima. Pël ëaap pim ë rangiatök polpol pu pötëët il nemowasën. ");
INSERT INTO wer_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Këra pu ompyaut ya lupöök peene yaarö, ëlpamök tiak es marën won sëpnaat pël yewas pipotta Anutuuk maan ompyaut yaarö. Kön wi kosang panë newasënörö ar pöt, Anutuuk koröpöökë kaamököt nin yaë. ");
INSERT INTO wer_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Pötaanök ar kön selap ëak epël anganok. ‘Tiar kaömpöt tarëkaan öpen?’ ma ‘Iit tarëkaan öpen?’ ma ‘Oröpötök kör koëpen?’ pël angan. ");
INSERT INTO wer_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Omën ngönën wonörö pit omën pipotëën kön kësang wia. Pël ëaap arim Pepap ar wëwë koirënëën iire kaömp nënë pöten kön wiak nimpnaat. Pötaanök omën pipotëën kön selap ëëngan. ");
INSERT INTO wer_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ar pöt, wot rëak Anutuuk wa ngaöök nimëën wëwë wotpil pim önëak niia pöt önëën weë ngentieë. Pël ëënë pötak yangerakë omën pipotta koir nimpnaat. ");
INSERT INTO wer_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Pötaanök omën nant ëlpamök orööpna pötön peene kët eptak kön selap ëënganok Wangam kan orööpna akun pötakökëër omën pötön kön wiin. Ën kët nantë könömöt yaaröön yok pangk pötëën kön wiinëët.” ");
INSERT INTO wer_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Anutuuk ngön ë pet yairaupë yaë pöl ar elniipanëën omnarö kom ëak ngön ë pet yairaupë yaë pöl elmëëngan. ");
INSERT INTO wer_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Arök omnaröaan ngön ya ke nal wesak mompunë pöt Anutuuk kangiir ke tapël wesak arimëën elniipnaat. Ën arök omnant omnaröaan elmëënë pöt Anutuukta tapël kaip ti nimpnaat. ");
INSERT INTO wer_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ni tol ëënak nim karipë itöök ulöl kotten iteneëak nimtëöökë këra elten kön nawiin yaën? ");
INSERT INTO wer_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nimtëöök om wiaan ni tol ëak karipön epël maan pangk ëëpën? ‘Ni kat newiin ne nim itöök ulöl wia pipët niömaan.’ ");
INSERT INTO wer_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Kaar omnamp, ni nimtë itöök këra elte wia pipët wakök këëkë iteneë nim karipë itöök ulöl wia pipët wëën pangk ëëpnaat. ");
INSERT INTO wer_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Omën utpet kentöröa ök pörö Anutuu ngön ngëëngkët köntak mengkanok. Pël ëënë pöt arim ë rangiat ent ëak polöröa naë olanë pöta ök yaë. Ënak pol pöröak ing samsam yeem kaalak kaip tiak arimënt kant nimpnaat.” ");
INSERT INTO wer_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Kimang maim olëak omën këët önëët. Ngaöl ëeim sëak këët koirënëët. Kanwer körangkörang maimën të niwiipnaat. ");
INSERT INTO wer_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Anutuun kimang yamëëauröak omnant yeö. Ngaöl yaaurö Anutuu naëaan këët yokoir. Kanweri körangkörang yamëëauröaan Anutuuk të yemowi. ");
INSERT INTO wer_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Arim naëaan runga namp këënëën pepapön kaömp kimang maan këlö kor mampën ma? ");
INSERT INTO wer_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ma animautaan kimang maan kamal utpet namp wa mampën ma? Won. ");
INSERT INTO wer_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ar omën utpetaröak arim rungaarö omën ompyaut men yeë pöl arim Pep kutömweri wë pöpök il niwesak omën piin kimang manë pörö omën ompyaut kaö wesak nimpnaat. ");
INSERT INTO wer_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Arim omnaröak omën ompyaut elniipënëak kent kön yawi pipël arök kangiir pitën elmëën. Ngön piptak Mosesë ngön kosangötre tektek ngön yaaö omnaröa ngönöt kepön erën ëak wia.” ");
INSERT INTO wer_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Ar kan koturak ilëak wëwë kosangta kanöök sën. Kö yesaurekë kanër kaöer, ën pörekë kanö kaöaö. Pötaanök omën selap ilëak yesau. ");
INSERT INTO wer_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ën wëwë kosangtakël yesa kan pör kotur. Kan pöök sëpenëak pöt pomp ëak omën selap won kopët nampnampök koirak yesau.” ");
INSERT INTO wer_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Ar tektek ngön yaaö omën kaaröröaan ngarangk këëkë ëën. Pit arim naë wais wëën ar pitëm koröpötön pëën itenak pitën kön wiin pol sëpsëpöröa ök ëpre wiap yaaurö pël wasënëët. Pël ëënëëtak pitëm lupötë kent toköröa ök nga panë wia. Pötaanök ar utpet niwasëpnaarö. ");
INSERT INTO wer_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ar pitëm omnant yaautön itenak songönten ëwat sënëët. Pöt wëleri ëër nautpan. Ën rakësaöök kasu nautpan. ");
INSERT INTO wer_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Këra ompyaut ulöp ompyaurö yaut. Ën këra utpetat ulöp utpetarö yaut. ");
INSERT INTO wer_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Këra ompyautök ulöp utpetarö nautpan. Ën këra utpetatök ulöp ompyaurö nautpan. ");
INSERT INTO wer_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ën këraat ulöp ompyaurö nautön ëëpna pöt ku tiak es marën kotöpnaat. ");
INSERT INTO wer_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Pötaanök tektek ngön yaaö omën kaaröröa omnant yaautön itenak pitëm songönten ëwat sënëët. ");
INSERT INTO wer_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Ar epël kön wiingan. ‘Omën neen, “Nem Aköp,” pël yenëa pörö pourö Anutuu wa ngaöök yamëautak ilapnaarö,’ pël wasngan. Nem Pep kutömweri wëaupë kentöökë ënëm yaaö pöröakëër pël ëëpnaarö. ");
INSERT INTO wer_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ënëmak akun kaöaöök omën kësang wais neen epël neapnaat. ‘Aköp, ten nim urtak wë Anutuu ngönte ök aöre omën naröa lupötëaan urmerarö waö ë momëëre omën weëre kosang it ngolöp kësang nant pet ë pël eimaut.’ ");
INSERT INTO wer_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Pël neaan ne pitën epël memaap. ‘Utpet omnaarö aë, ne arën köpël. Ar mop newiak kama seë.’” ");
INSERT INTO wer_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Omën nem ngön epët kat wiak ngaarëk öpna pörö pit omën kön ompyaö wieëaup ka weit ök rëa pöpë ökörö. ");
INSERT INTO wer_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Pël ëën kopi kësang panë pelak i nga urak kent kësang nempel möak ka pöt tööl noolaan ëa. Pöt ka pöta wapöt yang weitak wesirak taë ë ulmëa pötaan. ");
INSERT INTO wer_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ën omën nem ngön epët kat wiak ngaarëk naön ëëpna pörö pit omën kaökaup pim kaat i kosemeri pisöök ök rëa pöpë ökörö. ");
INSERT INTO wer_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Pël ëën kopi kësang panë pelak i nga urak kent kësang nempel möak ka pöt töölak sasa utpet wes olëa.” ");
INSERT INTO wer_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesu pi ngön epët ök më pet yairën omën pim naë wa rongan ëa pörö pourö pim ngön pötaan yaan panë sa. ");
INSERT INTO wer_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Pöt pi pepapök öngpököt wa kotiak maan ngön kosangötë ngarangköröa ngön yaaut il mowesa pötaanök. ");
INSERT INTO wer_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu pi rosiraöökaan kaip tiak yengmaan omën rongan kësang panë nempel pim ënëm sa. ");
INSERT INTO wer_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Akun pötak omën kësë ëa namp pim naë së rar rë mowesirak epël mëëa. “Aköp, ni ompyaö newasumëak pöt yok pangk ompyaö newasumëët.” ");
INSERT INTO wer_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Pël maan Yesu mores el mëak pim rangk mowiak epël mëëa. “Pël elniimëak yeëerek ompyaö së.” Pël maan tapëtakëër pim kësëat won sa. ");
INSERT INTO wer_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Pël ëën Yesuuk piin ngön epël mëëa. “Kat wi. E yaalni epëta ngönte omnaröen ök manganok om el wesak së nim koröpö kiri ar yaaö nampön pet elmë. Pël ëak omnarö nim ompyaö san pöt ëwat sëpnaan Moses pim ngön kosangta wia pöl kiri ar ëëm.” ");
INSERT INTO wer_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ënëmak Yesu pi Kapaneam kakë sa. Pël ëën Rom nga omnaröa wotöök namp së piin ngön kosang wesak epël mëëa. ");
INSERT INTO wer_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Aköp, nem inëën ruup pi yauman ëak pim kosat kël wak këlangön kësang yaëën komun ureim kaatak wia,” pël mëëa. ");
INSERT INTO wer_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Pël maan epël mëëa. “Ne së ompyaö wasumaap.” ");
INSERT INTO wer_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Maan nga omnaröa wotöököpök ngön kangit epël mëëa. “Aköp mosëp. Ne ompyaup talte nem kaatak waisum? Ni om eprek wë këm pëëntak aan nem inëën ruup ompyaö sëp. ");
INSERT INTO wer_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Pöt ne omën isauröa ikanöök inëën yaaupök nem iri nga omnarö wë. Pötaanök nook nampön, ‘Së,’ maan sëpnaat, nampön, ‘Wais,’ maan waisëpnaat, ën nem inëën ruupön, ‘Pël ë,’ maan pël ëëpnant. Pötaanök nim naë weëre kosang wieëaup pöten ne kön wiin ni maan nem inëën ruup yok pangk ompyaö sëpnaap.” ");
INSERT INTO wer_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Pël maan Yesu pi kat wiak yaan sak omën pim ënëm yesa pöröen epël mëëa. “Ne yaap niamaan. Israel omnarö arim naë kön wi kosang yewesa epël nent nokoirën ë yeë. ");
INSERT INTO wer_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Kat wieë. Omën kësang panë yang we naöökaan naöök, këtëpë yengampiaulaanre së yeilëaulaan omën pörö wais Apramre Aisakre ën Yakop pitëm naë kutömweri wel aisëak kaömp nëmpnaarö. ");
INSERT INTO wer_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Pël ëëpnaaröak Anutuuk Yuta omën narö kutömweri së öpnaarö pël yewesa pörö koö panëëtakël wa moolaan wë ingre ya ilak aimeë kë pötöppötöp aim öpnaarö.” ");
INSERT INTO wer_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Pël mëak pi kaip tiak nga omnaröa wotöököpön epël mëëa. “Ni së. Nim omën orööpënëak kön wi kosang yewesan pöt nim naë orööpnaat.” Pël yemaan akun tapëtakëër pim inëën ruup ompyaö sa. ");
INSERT INTO wer_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesu pi së Pita pim kaata kakaati ilëak itaangkën pim öng lëlamöp yauman koröp es nga kaö nent yeem ka ureëa. ");
INSERT INTO wer_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Pël ëën Yesu pi pim moresi mor moön yauman koröp es nga pöt won sëën pi wal ëak kaömp ar ë mena. ");
INSERT INTO wer_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Wiap kan koö olapënëak yaëën omën naröak yauman omën kësang pan pitëm lupötë urmerarö ilëak wëa pörö pim ngësë wak sa. Pël ëën pi urmeraröen nga mëak pitëm lupötëaan waö ë momëak yauman yaaurö ompyaö mowesa. ");
INSERT INTO wer_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Pël ëa pötak tektek ngön yaaö omën Aisaia pöpë ngön epël ëa pöt kë oröa. “Pi tiarim yauman won nuwesak këlangön pöt kama wak sa.” ");
INSERT INTO wer_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesu pi itaangkën omën rongan kësang nempel pi wa taap elmëak wëën pim ruuröen i kaöökë ëngk komuntakël sëpnaan ko ëëpënëak mëëa. ");
INSERT INTO wer_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Pël yaëën omën ngön kosangötë ngarangk nampök piin epël mëëa. “Rë yanuulaup, nim yasumëëtë ne ënëm elniimaap.” ");
INSERT INTO wer_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Pël maan Yesuuk kangiir epël ök mëëa. “Kent tokörö pit pitëm ka yauraut wia. Ën intörö pitta pitëm ka ëpöt wia. Pël ëaatak Omën Këëp nem ka uröma kaat won.” ");
INSERT INTO wer_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Pël maan omën munt pim ënëm yaaö nampök epël mëëa. “Aköp, ni yok pangk kat newiin wet rëak së nem pepap yang kel weerum.” ");
INSERT INTO wer_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Pël maan Yesuuk epël mëëa. “Mosëpnerek ni nem ënëm wais. Omën nem ngönte ngaarëk naön yaaö pöröak yok pangk wel pitëm karurö yang kel weerëpnaat.” ");
INSERT INTO wer_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Pël mëak Yesu pi wangaöök ilaan pim ruurö pitta tapël ëak piiring sa. ");
INSERT INTO wer_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Pël ëën kent kësang nempel möön i kaö maat kësang panë möak wangaöök ilaan utpet ëak iri i kaöök ilapënëak yeëa. Pël yaëën Yesu pi om ka kun sak wieëa. ");
INSERT INTO wer_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Pël ëën Yesuu naë së it moilak epël mëëa. “Aköp, tiar kö sëpenëak yeëerek ni ten kaamök elni,” pël mëëa. ");
INSERT INTO wer_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Pël maan Yesu pi pitën epël mëëa. “Ar tol ëënak kas yeë? Arim kön wi kosang yewesaut om kot panë wieëan epët.” Pël mëak pi kentööre i kaöön nga maan kentö leng ëën kaö maatta won sa. ");
INSERT INTO wer_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Pël ëën pit yaan sak neneren epël mëëa. “Elei, omën epop ke tolëël namp apen? Puuk kentre kaö maatön nga maan pim ngönte ngaarëk yeöp.” ");
INSERT INTO wer_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Pit i kaöökë ëngk komuntak së Katara yangerak oröön omën urmeraröaring wëa naar Yesuu naë së koira. Omën pöaar piarip wel yangaöök wakaimën omnarö piaripön itaangkën nga panë sak wëën kas ëak piarpim naë nasën ëeima. ");
INSERT INTO wer_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Pël ëën piaripök merëk ë olëak Yesuun epël mëëa. “Yesu, ni Anutuu Ruup. Ni ten tol elniimëëp? Akun kaöaö temanöm nasën wiaan këlangön kat niwiimëak yaën ma?” ");
INSERT INTO wer_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Akun pötak pol narö kësang kamaarek wë kaömp neim wëa. ");
INSERT INTO wer_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Pël ëën urmeraröak kosang wesak piin epël mëëa. “Ni ten waö ë nimëëmëak pöt pol ëngkoröa lupötë öngpök wes nimëëm.” ");
INSERT INTO wer_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Pël maan, “Yok seë,” pël maan pit së polöröa lupötë öngpök ilëa. Pël ëën pol pörö kas pöömpö së parëaöök oröak i kaöök ilëak ëm përëak wel wia. ");
INSERT INTO wer_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Pël ëën omën pol ngarangk yaaö pörö kas së pitëm ka kaöaöök oröak omën urmeraröaring wakaima pöaarë naë oröa pöta ngönöt ök mëëa. ");
INSERT INTO wer_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Pël ëën ka kaö pöökë omën pourö Yesuun itaampö sa. Pël ëak së koirak pitëm yanger sëp wesak kaalak kaip tiak sëpënëak ke urak mëëa. ");
INSERT INTO wer_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu wangaöök ilëak pim ruuröaring kaalak i kaöökë ëngk komuntakël së Kapaneam kak oröa. ");
INSERT INTO wer_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Pël ëën omën narö omën kosat kël wa namp urweri wiak wak Yesuu naë sa. Pël ëën Yesu pitëm kön wi kosang yewesauten itenak omën kosat kël wa pöpön epël ök mëëa. “Nem ruup, ne yok nim saunatë kangut ent ë yanuulak. Pötaanök ni ya kë sak öm.” ");
INSERT INTO wer_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Pël maan omën ngön kosangötë ngarangk narö neneren epël mëëa. “Omën epop, ‘Ne yok nim saunatë kangut ent ë yanuulak,’ pël yemaan Anutuu yapinte wa ngep yaalmë. Ya pöt Anutu pimtëët.” ");
INSERT INTO wer_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Pël yemaan Yesuuk pitëm könre lupötön itenak epël mëëa. “Ar tol ëënak kön utpet pipot yawi? ");
INSERT INTO wer_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Pöt nem omnampön, ‘Nim saunatë kangut ent ë yanuulak,’ ngön pël yemak pöt kengkënte. Pöt ar ngön pöta këët tekeri nasën ëën ar nem ngön pöt yaap ma kaar pël newasngan. Ën nem omnampön, ‘Wal ëak së,’ ngön pël yemak pöt könömët. Pöt nem ngön pöta këët tekeri sëën ngön pöt yaap ma kaar pël wasënëët. ");
INSERT INTO wer_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Pötaanök ar ne kaar omën wonöp Omën Këëp e yangerak wë weëre kosang wak saunatë kangut ent ë yemoolak pöten ëwat sënëak epël ök yemaan iteneë.” Pël mëak kosat kël wa pöpön epël mëëa. “Ni wal ëak korumönte wak nim kaatakë së.” ");
INSERT INTO wer_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Pël maan pi wal ëak pim kaatakë sa. ");
INSERT INTO wer_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Pël ëën omën kësang pöten itenak kas ëak Anutuuk weëre kosang ke pilte omën moresi mena pötaan pit Anutuun ping wesak mëëa. ");
INSERT INTO wer_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu pi pörek sëp wesak yesem takis yewa omën namp Matiu ne nem takis yewa kaatak wëën itenak epël yenëa. “Ni nem ënëm elnë.” Pël neaan ne wal ëak omnant sëp wesak pim ënëm saut. ");
INSERT INTO wer_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yesu pi nem kaata kakaati wais wel aisëak kaömp yenën takis yewaare saun omën munt narö kësang wais Yesure ten pim ruuröaring wel aisëak kaömp naut. ");
INSERT INTO wer_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Pël yaëën Parisi ngönën omnaröak pöten itenak ten pim ruuröen epël niiaut. “Arim rë yanuulaup pi tol ëënak omën takis yewauröere saun omnaröaring kaömp ngawi yen?” ");
INSERT INTO wer_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Pël yeniaan Yesu kat wiak kangiir epël mëëaut. “Omën yauman wonörö rota ngësë nasën. Yaumanringöröakëër rotaaröa ngësë sa yaë. ");
INSERT INTO wer_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ar pöt, së ngön nent ngönëntak epël wia pöta songönten këëkë kön wiin. ‘Ne ar nemëën animaurö kiri ar elnëënëëten kaaö. Nem kentöök ar omnarö yaköm ëën ompyaö elmëënëëtenök kent yaë,’ pël wia pöten kön wieim ön. Ne omën pitëmtën kön wiin wotpilörö pël yewas pörö lup kaip tiipnaan memëak newaisën. Won, omën pitëmtën kön wiin saun yaaurö pël yewas pörö ngön ök maan lup kaip tiipënëak waisaup.” ");
INSERT INTO wer_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Akun pötak Sonë ru narö Yesuu naë wais epël mëak pëël yema. “Ten Parisi ngönën omnarö Anutuun yak kaömp ngës olëak wëaurö. Ën nim ruurö pit tol ëënak kaömp ngës olëak naön yaë?” ");
INSERT INTO wer_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Pël maan Yesuuk kangiir epël mëëaut. “Omën namp öng öpënëak yeem pim karuröaring wëën karuröak yaköm ëën kaömp ngës olëak öpën ma? Won pan. Peene wë öng öpna pöp karuröaring akun wali naön ëëpnaat. Pi peene wëën omën naröak pi wak kama ulmëën akun pötakökëër pim karurö yaköm ëën kaömp ngës olëak öpnaat. Pöl pit ne kama neöpna pötakökëër nem ruurö neen yaköm ëën kaömp ngës olëak öpnaat. ");
INSERT INTO wer_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Omën namp poë koröp ngolöpöökaan kaö nent ilak ulpëën ngaanëpë keliaurek wiak korir namëëpan. Pël ëëpna pöt poë koröp ngölöp pötak ulpëën ngaanëp weruun ilak kaak sëpnaat. ");
INSERT INTO wer_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ën omën namp i kep pol koröpwerring ket ëa ngaan pötak wain i ngolöpöt kolön yok pangk naëpan. Pël ëëpna pöt wain i pöt kep wetak pol koröp pöt sak il ngentiin iit orö sëpnaat. Pël ëën pol koröpwerta utpet ëëpnaat. Pötaanök wain i ngolöpöt kep ngolöptak lë mëëpna pötak pangk ëëpnaat.” Yesuu pël mëëa pöta songönte epët. Mosesë ngön kosang ngaanötre pimtë ngön ngolöpöt pangk irikor naëpan pötenök mëëa. ");
INSERT INTO wer_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu pi ngön pöt ök yemëem wëën ngarangk namp wais pim naë rar rë mowesirak epël yema. “Nem koontup peene ngolöp wel wia. Pël ëaarek ni wais mores pim rangk mowiin kaalak öp sëp.” ");
INSERT INTO wer_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Pël maan Yesu pi wal ëak ten pim ruuröaring omp pöpring saut. ");
INSERT INTO wer_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Pi kan yesën öng namp öng yauman ëeim wëën krismaki 12 ëak saö namp kasngaël wais pim mores ulpëënëpök mësël yaalmë. ");
INSERT INTO wer_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Pöt, “Ne om pim ulpëënëpök mësël elmëëma pöt ompyaö sumaat,” pimënt kön pël wesak pël yaë. ");
INSERT INTO wer_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Pël ëën Yesu pi kaip ti itenak epël yema. “Koontup aë, nimtë kön wi kosang yewesautak ompyaö yesën. Pötaanök ya kë sak öm.” Pël maan öng pöp tapëtakëër ompyaö yes. ");
INSERT INTO wer_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yesu pi së ngarangkëpë kaatak oröak itaangkën omnarö koontupëën yak yaköm ëën pitëm yaaul nger pëëp mempööre ngön kaëp ilö pël eim wëa. ");
INSERT INTO wer_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Pël ëën pi pitën epël yema. “Ar mop wiak ka tomökël oröeë, koont epop wel nawiin om ka ura.” Pël maan pit sömre ëlak ya. ");
INSERT INTO wer_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Pël yaan Yesu pi omnarö tomökël wes momëak koontupë wieëa pörek ilë moresi wëën wal ëaut. ");
INSERT INTO wer_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Pël ëën pim pël elmëa pöta ngönte yang pörek ka poutë sa pet ira. ");
INSERT INTO wer_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu pi ka pö sëp wesak ten pim ruuröaring yesën omën it il tëa naar pim ënëm yewaisem ngön ë olëak epël yema. “Yesu ni Tewitë ëapök tenipön yaköm kön niwi.” ");
INSERT INTO wer_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Pël maan Yesu pi pim ka sëpënëak ëa pötak ilaan omën it il tëa pöaar pim naë waisën pëël mëëaut. “Arip kön wiin ne yok pangk ompyaö niwasum ma?” Pël maan piaripök kangiir epël yema. “Aköp, mak.” ");
INSERT INTO wer_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Pël maan piarpim itöörarë mësël elmëak epël yema. “Arpim kön wi kosang yenewas pötak ne ompyaö yanuwas.” ");
INSERT INTO wer_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Pël maan piarpim itöörar nga ngëna. Pël ëën Yesuuk kosang panë wesak epël yema. “Omnaröen ök manganok.” ");
INSERT INTO wer_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pël maan piarip së Yesu pim pël elmëa pöta ngönte yang pörekë omnaröen ök maan yang pörek pangk ë pet ira. ");
INSERT INTO wer_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ten kaalak ka pöt sëp wesak kan yesën omën narö omën urmerapök elmëën ngön won sak wëa namp Yesuu naë wak waisa. ");
INSERT INTO wer_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Pël ëën Yesuuk urmer pöp waö ë momëën omën ngön won sak wëa pöpök ngön yaan omnarö kat wiak yaan sak epël ya. “Elei, tiar omën ke epël nent Israel yangerak oröön itnaangkën ëaut.” ");
INSERT INTO wer_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pël yaan Parisi ngönën omnaröak epël yema. “Urmeraröa kaöapök kaamök elmëën urmerarö waö ë yemomë,” pël yema. ");
INSERT INTO wer_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu pi ten pim ruuröaring ka kotre kaö poutë imeë pitëm ngönën tupötë ngönën rë moulööre Anutuuk wa ngaöök nimëëpna ngön ompyaö pöt ök maö, këlangönre yauman ke nentere nent ompyaö mowasö pël elmë imaut. ");
INSERT INTO wer_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Pël yeem pi omën selap pan itenak pitën kön wiin pol sëpsëp ngarangk wonöröa ök kön irikorring wë weëre kosang won wëën itenak pitën yaköm kön wia. ");
INSERT INTO wer_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Pël ëak pim ruurö tenën epël yenia. “Ya lupöök kaömp kë kësang pan köp sak wë. Pël ëaap ya omnaar kopët. ");
INSERT INTO wer_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Pötaanök ar ya Pepapön kimang man. Pël ëën puuk ya omën munt narö koirak wes mëën këët wa rongan ëëpnaan.” ");
INSERT INTO wer_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesuuk ten pim ru 12 pöröen ngön niaan sëën urmerarö waö ë mëëre këlangönre yauman ke nentere nent ompyaö mowasö pël ëënëak weëre kosang ninaut. ");
INSERT INTO wer_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ten pim ngön yaaö omën 12 pöröa yapinöt epot. Wotöököp Saimon yapin nent Pita piire ën pim nangap Entru, Semsre pim nangap Son, Sepeti pim ruaar, ");
INSERT INTO wer_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ën Pilipre Patolomiu, Tomasre Matiu takis yewaup neere Sems Alpiasë ruupre Tatias, ");
INSERT INTO wer_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Saimon Selot pël yamëëa pöp pi ngaan Rom kamanëp sëp mowasëpënëak aima omën tok pötakaanëp piire ën Yutas Keriot kakaanëp ënëmak Yesuun kup mowiipnaap. ");
INSERT INTO wer_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ten omën 12 pöröen Yesuuk epël niak wes nimëën saut. “Ar omën ngönën wonöröa naë sëëre Sameria omnaröa ka kaöatë së orö pël ëënganok. ");
INSERT INTO wer_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Om Israel omën pol sëpsëp ngarangk won ëën repak yes pöröa ök ëa pöröa naëëkëër sën. ");
INSERT INTO wer_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Pël ëak ar yesem pöt ngönën epël ök man. ‘Anutuuk tiar wa ngaöök nimëëpna akunet yok temanöm yes.’ ");
INSERT INTO wer_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Pël yeem yauman omnarö ompyaö mowasööre omën wel wiaurö wal ë moulmë, omën kësë ëaurö ompyaö mowasööre urmerarö omën naröa lupötëaan waö ë momë pël elmëën. Nem weëre kosangöt sum won yaningk. Pötaanök arta tapël sum won omnarö kaamök elmëën. ");
INSERT INTO wer_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ën monat arim kërötë waulak sënganok. ");
INSERT INTO wer_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ar kan kourakë kaömp waulönëak këröt wak sënganok. Ar ulpëënre ing kör muntatre sungköratta wak sënganok. Pöt ar omnarö ya yamëngkën yok pangk kaamök elniak kaömp nimpnaat. ");
INSERT INTO wer_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ar ka kaö naöök ma kot nentak së oröak wet rëak pitëm songönöt nampön pëël mëak kat wiin ompyaö sant niwasëpnaap ëën pöt piiring wë olëak sënëëtak sëp wesak sën. ");
INSERT INTO wer_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ar ka nenta kakaati yeilëem pöt omën pörek wëauröen, ‘Anutuuk ompyaö elniip,’ pël ök man. ");
INSERT INTO wer_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Pël ëën pit sant niwasëpna pöt Anutuuk arim ngön manë pöl pit ompyaö elmëëpnaat. Ën pit sant naniwasën ëëpna pöt arim ngön Anutuuk ompyaö elmëëpënëak mëëan pöt pitëm naë kë naarööpan. Arimënt wak sënëët. ");
INSERT INTO wer_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ën ka naöök ma nentak omën narö sant niwesak arim ngönte kat nawiin yaëën pöt ar pörek sëp wesak yesem pit utpet ëën Anutuuk kangiir kasëng mampnaat pöt pet elmëak ing porpor elmëak arim ingötëaan yangre ulölöt kërë pörek moolan. ");
INSERT INTO wer_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ne yaap pan niamaan. Ngaanëër Sotomre Komora ka pöteparë omnarö pit utpet ëeima. Pötaan akun kaöaöök Anutuuk Sotomre Komora omnarö pitëm utpetatë kangut mampnaat. Ën omën ar sant naniwasën ëëpna pörö utpet pan ëën Sotomre Komora omnaröa kangut kaö wesak mampnaat.” ");
INSERT INTO wer_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Kat wieë. Pol sëpsëp ruurö kent toköröa öngpök wes namëën yaautak nook ar kööre toköröa öngpök wes nimëën së önëën yeë. Pit utpet niwasëpënëak ëëpnaat. Pötaanök ar pol reraupë yaë pöl it nganga yeem int ekëpë wë pöl wiap ëën. ");
INSERT INTO wer_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ar omnaröen ngarangk këëkë ëën. Pit ar kaöaröa naë niulëën pitök maan ngönën tupötë pës nimööpnaat pötaanök. ");
INSERT INTO wer_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ar nem ru sak wë pötaanök pitök ar yang ngarangkre omën omp ak naröa naë ngön yaatak niulëëpnaat. Pël ëën ar pitre omën ngönën wonöröa ëöetak nem ngönte tekeri wesak manëët. ");
INSERT INTO wer_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Yang ngarangköröa naë niulëën tol anet ëak kön selap ëënganok. Akun pötak ngön anëët Anutuuk arim lupötë niwiipnaat. ");
INSERT INTO wer_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Pël ëën ngön anë pöt arimtok naëngan, arim Pepapë Pulöök tekeri wes nimpnaat. ");
INSERT INTO wer_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Omën naar nanëpök nangapëën kup mowiin mëmpnaat. Ën pepapökta ruupëën kup mowiin mëmpnaat. Ën koröngre ruuröak ëlre pepaarëën kup mowiin mëmpnaat. ");
INSERT INTO wer_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ar nem ru sak wë pötaan omën pourö ya sangën ëën kööre tok elniipnaat. Pël ëëpnaatak omën weë sak wëak wel wiipnaarö Anutuuk kama öpnaat. ");
INSERT INTO wer_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ar kak nerek wëën nga elniin pöt kas nerekël sën. Ne yaap niamaan. Ar kak nerekaan waö elniin pöt nerekël kas sënëët. Israel kaatë wii saal ar sa pet nairën wiaan Omën Këëp ne oröömaap. ");
INSERT INTO wer_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Runga pep kaatak nampök pim pepap il newaspan. Ën inëën ru nampök tapël pim ngarangkëp il newaspan. ");
INSERT INTO wer_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Runga pep kaatakëp pim pepapë mëngkre mëngk wëën pangk ëëpnaat. Ën inëën ruupta pim ngarangkëpë mëngkre mëngk wëën pangk ëëpnaat. Pitök ne arim kaöapön utpet wesak neak neen, ‘Pielsepul urmeraröa kaöap,’ pël neea. Pötaanök pitök il wesak ar nem ruuröen utpet panë wesak niapnaat.” ");
INSERT INTO wer_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Pitën kas ëënganok. Pöt epël. Omën ngep ëën wia pipot wiakaim wi naöpanëët. Ënëmak wëlël ëën omnarö itaampnaat. Ën ëlëëp wia pipot wi naöpanëët. Pipot tekeri sëpnaat. ");
INSERT INTO wer_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nem arën koutak ök yeniak pipot ëwaatak ök an. Ën ngön laöök ök yeniak pipot omnaröa tekrak wë kaö wesak an. ");
INSERT INTO wer_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ar omën könöp utpet newasën koröpö pëën nimëmpnaaröen kas ëënganok. Anutu es parëaöök niulëak könöpre koröpö pout kö niwasëpna pöpönökëër kas ëën. ");
INSERT INTO wer_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Omnarö tiar int sëpër naar 1 toea pötak sum ëëpenaat int ke pëlöröakaan namp köntak wel wiak yangerak nengentiipan. Anutuuk aanak pël ëëpnaat. ");
INSERT INTO wer_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ar omnarö pöt, arim kepön ëpötönta pi ëwat wë. ");
INSERT INTO wer_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Pötaanök ar kas ëëngan. Pöt Anutuuk kön wiin arim sumatök int kot pöröaat il yemowas. Pötaanök omën nant arim naë köntak naarööpan. Puuk aanak orööpnaat.” ");
INSERT INTO wer_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Namp pi omnaröa ëöetak, ‘Ne Yesuu ënëm yeë,’ pël apna pöp nookta kangiir nem Pep kutömweri wë pöpön, ‘Pi nemop,’ pël memaat. ");
INSERT INTO wer_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ën namp pi omnaröa ëöetak neen yak newasëpna pöp nookta nem Pep kutömweri wë pöpë ëöetak piin yak mowasumaat.” ");
INSERT INTO wer_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Arök ne yangerakë ngaat won wasumëak waisan wasngan. Ne arim naë ngaat won wasumëak newaisën. Ne ar neen kön wi kosang wesak wëaurö omën neen pël naalnëën wëauröa naëaan kom elniin pit kööre tok elniipënëak waisaup. ");
INSERT INTO wer_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nook elmëën ruupök pepapëën kööre tok ëëre korömpök ëlëpëën kööre tok ëëre koröng lëlamöpök ël lëlamöpëën kööre tok ë pël ëëpënëak waisaup. ");
INSERT INTO wer_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Omën ka kopëtetak wëaurö neneraan kööre tok ëëpnaat. ");
INSERT INTO wer_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Omën namp pim ëlre pepaarëën kent panë yeem neen kent panë naën ëëpna pöp yok pangk nem omnamp pël naëpan. Ën namp pim rungaaröaan kent panë yeem neen kent panë naën ëëpna pöp yok pangk nem omnamp pël naëpan. ");
INSERT INTO wer_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ën namp pi, ‘Ne Yesu pimëën wel wiima pöt pangk ëëmaap,’ pël wesak pim këra yetapër wak nem ënëm naalnëën ëëpna pipop nem omnamp pël naëpan. ");
INSERT INTO wer_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Namp pim wëwëet keimön ëak öpna pöt pim wëwëet kö sëpnaat. Ën namp nemëën yak wëwëet këëpöt wasëpna pöt pim wëwëet ompyaö orö morëëpnaat.” ");
INSERT INTO wer_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Omën ar sant niwasëpna pöp ne elnëëpnaap. Ën omën ne sant newasëpna pöp Anutu nem wes nemëaup elmëëpnaap. ");
INSERT INTO wer_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Omën namp tektek ngön yaaö namp pim ngësë yewaisën pi tektek ngön yaaup pël wesak sant mowasëpna pöt pi tektek ngön yaaupë ompyaö kangit piiring öpnaap. Ën namp omën wotpil namp pim ngësë yewaisën pi wotpil yaaup pël wesak sant mowasëpna pöt pi omën wotpilëpë ompyaö kangit piiring öpnaap. ");
INSERT INTO wer_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ën omën namp omën pas nampön itenak pi nem ruup pël wesak i ëpët nëmpënëak kelöntak kol mampna pöp pi Anutuuk yaap ompyaö kangit mampnaap.” ");
INSERT INTO wer_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesuuk ten pim ruuröen wetete ngön pöt ök ni pet irak pörek sëp wesak ka munt pörek wieëa pötë ngönën ök mëak rë moulö saut. ");
INSERT INTO wer_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Son i yamëaup wii kaatak om wë Kristoë yaauta ngönte kat wiak pim ru naar wes mëën waisa. ");
INSERT INTO wer_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Pël ëak piaripök piin epël mëak pëël yema. “Waisëpënëak aan kor wakaimaup ni tapöp ma muntapön kor ön?” ");
INSERT INTO wer_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Pël maan omën pöaar wais ök maan Yesuuk kangiir piaripön epël ök yema. “Arip së Sonön omnant arpim itaampööre kat wi yeë epotön ök man. ");
INSERT INTO wer_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","It ngaapörö it nganga së, ing il tëaurö ompyaö sak kan ë, kësë ëaurö ompyaö së, katun yaaurö kat nganga së, welarö wal ë ulmë, ngöntök yaaurö ngön ompyaut ök maan kat wi, pël yeë epotön ök man. ");
INSERT INTO wer_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Omën namp nemëën yak pim kön wi kosang yewesaut irikor naën yaë pipop ërëpërëp ëëpnaap.” ");
INSERT INTO wer_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Pël maan piarip yesën Yesuuk omnaröen Sonë songönte ök yema. “Ar ngaan yang omën wonrek kalaö naö kent möön sak waisak yaëën itaampunëak saurö ma? Won, Son pi pöta ök won. ");
INSERT INTO wer_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ma ar omën ulpëën ke nalëp mëaö nampön itaampunëak saurö ma? Won, omën ulpëën ke nalörö mëa pörö omën omp aköröa ka ompyautë wëëtak Son pi ulpëën ke nalörö namëën wëaup. ");
INSERT INTO wer_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ma ar omën ke tolëëlëpön itaampunëak saurö? Ar tektek ngön yaaö nampön itaampunëak saurö ma? Ar yok pël ëan. Ne ök niamaan. Epop tektek ngön yaaö tapöpök pim ya yamëngka pötök tektek ngön yaaö muntaröa ya yamëngka pöt il yemowas. ");
INSERT INTO wer_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Pöt omën pöpëënök ngönëntak epël retëng ëa. ‘Kat wi. Ne omën nem ngönte waup wes mëën wet rapnaat. Puuk nim kanö ningësëpnaat.’ ");
INSERT INTO wer_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ne yaap niamaan. Son puuk yangerakë omën pourö il yemowas. Pël ëaap omën Anutuuk wa ngaöök yamë pöröak pi il yemowas. Pitëm naëaan koturöakta pi il yemowas. ");
INSERT INTO wer_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ngaan Son i yamëaup pim ngës rëak ngönën ök ëa pötakaan wais peene e wë eptak omën utpet ke nentere nent yaaö naröak Anutu pim wa ngaöök nimëak wë pötak ilapënëak weë yengenti. ");
INSERT INTO wer_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Mosesre tektek ngön yaauröak Anutuuk wa ngaöök nimëëpënëak ëa ngön pöt aö aö wais Sonë oröak wë eptak kë yaarö. ");
INSERT INTO wer_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ën ar pitëm ngönöt kat wiak taë wasënëak pöt Sonön pi Elia pitëm waisëpënëak ëa tapöp pël wasënëët. ");
INSERT INTO wer_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Katringëpök ngön epët kat wiip. ");
INSERT INTO wer_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Ne ar akun eptak wëauröen oröp nentak ök elniim? Ar rungaaröa ökörö. Rungaarö pit ka tomök ngasam yeem pitëm karuröen epël yema. ");
INSERT INTO wer_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Ten intö tang yamöön ar tan naurön yeë. Ten ingre tan yaan ar ingre ya ilak naën yeë.’ ");
INSERT INTO wer_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ar tapël yaaurö. Son pi wais wain i nanën wë akun nantë kaömp ngës olëak wëën ar piin, ‘Pi urmerapring wë,’ pël aiman. ");
INSERT INTO wer_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ën peene Omën Këëp ne wais iire kaömp yenën ar epël aim. ‘Iteneë. Omën epop wain iire kaömp kaö yenëp. Pi takis yewaöre saun omnaröa karip,’ pël aim. Pël ëaap Anutu pim ëwat pöt arim naë wieëanëën ar tenip sant elnian tapön.” ");
INSERT INTO wer_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Akun pötak Yesu pim wet rëak ka nantë ya retëng weëre kosang mëngkën itenak lup kaip natiin ëa pöröen epël mëak nga yema. ");
INSERT INTO wer_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Yakömpe, Korasin omnaröen. Yakömpe, Pesaita omnaröen. Nem retëng weëre kosangöt arim naë elnia pöl Taiaare Saiton omnaröen elmëanëën pit ngaanëër pitëm lupöt kaip tiak ulpëënre poë koröp sinöt ëak ka kosöt kolak pitëm koröpöök wa mëan tapön. ");
INSERT INTO wer_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Pötaanök epël niamaan. Akun kaöaöök Anutuuk Taiaare Saiton omnarö pitëm utpetatë kangut mampnaat. Ën ar pöt, utpet pan ëën pitëm kangut kaö wesak nimpnaat. ");
INSERT INTO wer_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ën Kapaneam omnarö, ar kutömweriil isën ma? Won, ar es parëaöök ngemanëët. Nem retëng weëre kosangöt arim naë elnia pöl Sotom omnaröaan elmëanëën pitëm ka kaö pö kö nasën peene om wieëan tapön. ");
INSERT INTO wer_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Pötaanök epël niamaan. Akun kaöaöök Anutuuk Sotom omnarö pitëm utpetatë kangut mampnaat. Ën ar pöt, utpet pan ëën pitëm kangut kaö wesak nimpnaat.” ");
INSERT INTO wer_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Akun pötak Yesuuk Pepapön epël ök mëëaut, “O Pep, ni kutömre yang poutë pepap. Niin yowe yeniak. Ni omën ëwatöröaan nim ngönëntë ëlëëp yaalmëaup. Ën kön nawiin yaauröaan pet yaalmëaup. ");
INSERT INTO wer_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Mak, Pep nim kentöök pël yaaup.” ");
INSERT INTO wer_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Pël mëak omnaröen epël yema. “Pepak omnant pout ne nenaut. Pötaanök omnarö pit ne Anutuu Ruupë songönten köpël wë, Pepakëër ëwat wë. Ën Pepenta tapël wia. Omnarö piin köpël wë, Ruupökëër ëwat wë. Pötaanök Ruupök omën nampön Pepapë songönten ök maan yok pangk ëwat sëpnaat. ");
INSERT INTO wer_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ar Anutuu ngönte ngaarëk önëëtaan ya kaö mëneimeë këlangön kat wieim wëaurö nem ngësë waisën. Pël ëën nook niaan kë sënëën. ");
INSERT INTO wer_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ar nem inëën ru sak neering ya mëneim wë nem naëaan ëwatöt ön. Pöt epël. Ne ya wiap yaaupök nemtën wak irëak wëën arim saunatë könöm pöt won sëën lup kengkën sak önëët. ");
INSERT INTO wer_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Omnant arim ëënëak ök niaim pöt ompyaut, könöm won pangk ëënëët.” ");
INSERT INTO wer_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Wë kë yesa akun nentak ten Yesuring rais yaöökë lup yesem këënëën ulöp nant töak söngsöng ëak naut. ");
INSERT INTO wer_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Pël yaëën Parisi omnaröak itenak Yesuun epël yema. “Kat wi. Nim ruurö kë yesa akun ngëëngkötë naënëël yaë.” ");
INSERT INTO wer_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Pël maan kangiir epël yema. “Ar Tewitre pim omnaröa këën wë ëa pöt ar sangk kelak kat nawiin yaaurö ma? ");
INSERT INTO wer_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Tewitre pim omnarö pit Anutuu ngönën tup kaöeta kakaati së kaömp Anutuu ëöetak wieëa pöt kiri ar yaauröakëër nëmpnaan piire omën pas pim naë wëaurö nëmpanëak nga yaaut wa na. ");
INSERT INTO wer_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ma Mosesë ngön kosangtak lup epël wia pöt ar sangk kelak kat nawiin yaaurö ma? Kiri ar yaaurö Anutuu ngönën tup kaöetak kët kë yesa akun ngëëngkötë ya yamëngkem kë yesa akunatë nga wieëa pöt ilën saun naën ë yaë. ");
INSERT INTO wer_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ne niamaan kat wieë. Arim ëöetak e taua epopök tup kaöet il yewas. ");
INSERT INTO wer_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ngönëntak ngön nent epël wia. ‘Ne ar nemëën animaurö kiri ar elnëënëëten kaaö. Nem kentöök ar omnarö yaköm ëak ompyaö elmëënëëtenök kent yaë.’ Ar ngön pöta songönte ëwat wëanëën omën ketre saun wonöröen nga nemaan ëan tapön. ");
INSERT INTO wer_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Omën Këëp ne kë yesa akun ngëëngk pöta pepap. Pötaanök nem kentöök akun eptak nem ruuröen omnant ëëpnaan memaat.” ");
INSERT INTO wer_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Pël mëak pörekaan pitëm ngönën tuptak së ilëaut. ");
INSERT INTO wer_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Pël ëën omën namp pim mor nas kël waup pörek wëa. Pël ëën pitök Yesuun morök elmëak ngön yaatak ulmëëpënëak epël pëël yema. “Tiar yok pangk kë yesa akun ngëëngktak ompyaö wasëpen ma won?” ");
INSERT INTO wer_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Pël maan epël mëëaut. “Arim naëaan namp pim pol sëpsëp namp kë yesa akun ngëëngk nentak yang öngöpöök ilëaan sëp wasëpën ma? Pël naëpan, öpnaat. ");
INSERT INTO wer_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Sëpsëp pöp omën pasip. Ën omnarö tiar këërö. Pötaanök kë yesa akun ngëëngktak yok pangk ompyaö wasëpenaat.” ");
INSERT INTO wer_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Pël mëak pi omën pim mores kël wa pöpön epël yema. “Nim mores el më.” Pël maan pim mores el mëën kaalak muntasi ök ompyaö yes. ");
INSERT INTO wer_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Pël yaëën Parisi omnarö ka tomök së wa top ëak pit tol ëak Yesu mëmpën pöta ngönte kopëta wesa. ");
INSERT INTO wer_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesu pi pitëm ngönte ëwat wëak pörekaan yesën omën selap pim ënëm waisa. Pël ëën pi yauman omën pourö ompyaö mowesak ");
INSERT INTO wer_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","pitën omën muntaröen piin ök mepanëak nga yema. ");
INSERT INTO wer_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Pël yaëën tektek ngön yaaö Aisaia pöpë ngön epël ëa pöt kë oröaut. ");
INSERT INTO wer_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Epop nem inëën ruup, nem yaö mëëaup. Ne piin kent pan ëak ya kë yes. Nem Pulö pim naë wes mëën pim rangk wë weëre kosang mangkën nem ngön wotpilte omën ngönën wonöröen ök mapnaat. ");
INSERT INTO wer_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Pi omnaröaring ngön nga elööre ngön ëak aö, omnarö pim ngönte ka tomök kat wi pël naëpan. ");
INSERT INTO wer_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Omën kalaö pötöp möautë ök këlangön kat yawiaurö pi utpet nemowaspan, kaamök elmëën ompyaö sëpnaat. Ën omën es wëlëngö riipënëak yaë pöl wiap panë yaauröeta puuk elmëën wel nawiipan, kaamök elmëën weë sak öpnaat. Pi kosang ngentiak ya mëngkën Anutuu wotpil yaautak omën muntat il wasëpnaat. ");
INSERT INTO wer_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Pël ëën omën ngönën wonöröak piin kön wi kosang wesak kor öpnaat.” ");
INSERT INTO wer_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Wë ënëmak omën narö omën urmer nampök elmëën it il tëëre ngön won së pël ëa namp Yesuu naë wak waisa. Pël ëën ompyaö mowasën omën pöp ngön aöre it nga së pël ëaut. ");
INSERT INTO wer_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Pël ëën omnarö pöten itenak yaan sak epël ya. “Elei, epop Tewitë ëap, Anutuu Yaö Mëëaup, tiarim ngarangk elniipnaap ma?” ");
INSERT INTO wer_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Pël yaan Parisi omnarö pöten kat wiak epël yema. “Kaar angan. Omën epop urmeraröa kaöap Pielsepul puuk kaamök elmëën waö ë yamë.” ");
INSERT INTO wer_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Pël yemaan pi pitëm lupötë itenak yema. “Yang nerakë omnarö pitëm naë nga oröön nener mënak kom ëak wë weëre kosangring naön ëëpnaat. Ën omën ka naöök wëaurö ma ka kopët nentak wëaurö tapël nener mënak kom ëëpna pöt repak sëën omën won wiaapnaat. ");
INSERT INTO wer_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Tapël Seten pimtok ne kaamök elnëën pim urmerarö waö ë yemomëanëën pimtok pimënt mëngkën pim weëre kosangöt won san tapön. ");
INSERT INTO wer_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ar neen, ‘Pielsepul puuk kaamök elmëën urmerarö waö ë yamë,’ pël aim. Pötaanök arim ngön pipët yaap yeëanëën arim ruurö pitta Pielsepul kaamök elmëën urmerarö waö ë mëan tapön. Pötaanök arim ruurö pitëmtok arim ngön pöt kaar ëan pöt tekeri yewas. ");
INSERT INTO wer_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ne pöt, Anutuu Pulöök kaamök elnëën urmerarö waö yeë. Pötaanök Anutuu wa ngaöök yanimë pöt arim naë yaarö. ");
INSERT INTO wer_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Omën nga namp wëën munt nampök pim kaatak ilëak pim omnant naöpan. Wet rëak omën nga pöp wii të wiakök pim omnant pout öpnaat. Nga pöp Seten. ");
INSERT INTO wer_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Namp ne sant naalnëën yaë pipop kööre tok yaalnë. Namp neering pol sëpsëpörö wa top naën yaë pipop pi sëpsëpörö rep yamë. ");
INSERT INTO wer_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Pötaanök ne ök niamaan. Omën utpet ke nentere nent ëak Anutuun utpet wesak mapna pöt Anutuuk omën utpet pöt poutë kangut yok pangk kërë moolapnaat. Ën namp pi Ngëëngk Pulöön utpet wesak tapël mapna pöp pim saun pöta kangit ent ë nemoolapan. ");
INSERT INTO wer_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ën namp pi Omën Këëp neen utpet wesak apna pöp pim saun pöta kangit Anutuuk kërë moolapnaat. Ën namp pi Ngëëngk Pulöön utpet wesak tapël mapna pöp pim saun pöta kangit peeneere ënëm poutë ent ë nemoolapan.” ");
INSERT INTO wer_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Këra ompyaumentëk ulöp ompyaurö utöpnaat. Ën utpetementëk ulöp utpetarö utöpnaat. Këra ëlmenti songönte ulöpöröak war yewas. ");
INSERT INTO wer_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Kamalöröa morök yaë pöl ar yaaurö. Utpet yaauröak tol ëak ngön ompyaut an? Pël naëngan. Omën namp ke nantre nant pim lupmeri peö ëak wë pöt këmtak war yewas. ");
INSERT INTO wer_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Omën ompyaup pim lupmeri kön ompyaut wieë ngön ompyaut ya. Ën utpetap pim lupmeri kön utpetat wieë ngön utpet tapëlöt ya. ");
INSERT INTO wer_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Ne ök niamaan. Ënëmak kangiir ëëpna akunetak Anutuuk omnaröa ngön köntak mosut yaaö pötaan ngön ya mëmpnaat. ");
INSERT INTO wer_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Arim ngön yaautak arim songön ompyaut tekeri wasën pöt Anutuuk niöpnaat. Ën arim ngön yaautak utpet yaaut tekeri wasën pöt sëp niwasëpnaat.” ");
INSERT INTO wer_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Pël maan ngön kosangötë ngarangköröere Parisi ngönën omën naröak Yesuun epël yema. “Rë yanuulaup, ten Anutu niiring wë ma won pöta songönte ëwat sënaan, ni retëng weëre kosang nent ë. Pël ëën itaampunaan.” ");
INSERT INTO wer_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Pël maan pi epël yema. “Omën peene akun eptak wë eporö ar utpet ëak Anutuun kön wi kosang newasën yaaurö. Ar ya retëngöt yamëngka pöten ke urak yenëak. Pötaanök ne ya retëng nent naëngan, om ngaan tektek ngön yaaö omën Sona pim elmëa pöta ököt pëën pet elniin itaampunëët. ");
INSERT INTO wer_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ngaan Sona pi i kaö imën kaöapë yaatak këtre röök nentepar nent wakaima pöl Omën Këëp ne këtre röök nentepar nent yangera öngpök ömaap. ");
INSERT INTO wer_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ënëmak Anutu pim ar kom elniipna akunetak Niniwa kakaanörö pit wal ëak arim kön wi kosang newasën yeë pöt war wasëpnaat. Pöt Sona puuk ngönën ök maan lup kaip tia pötaanök. Pël ëaap omën peene wë epop nook Sona il yemowesetak ar nem ngönöt kat nawiin yeë. ");
INSERT INTO wer_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ënëmak Anutu pim ar kom elniipna akunetak öng ak namp yang we naöökël wakaimaup pi wal ëak arim kön wi kosang newasën yeë pöt war wasëpnaat. Pöt öng pöp yang kaö pantakaan Solomonë naë wais pim ëwat kësangöt kat wiipënëak waisaup pötaanök. Pël ëaap omën peene wë epop nook Solomon il yemowesetak ar nem ngönöt kat nawiin yeë.” ");
INSERT INTO wer_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Pël mëak Yesuuk pitën watepang ngön nent epël ök yema. “Urmer namp omën nampökaan oröak së kosangöök wë urre korumön ap wesak ");
INSERT INTO wer_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","epël kön wia. ‘Nem ka ngaan wakaim olëak waisautakë kaalak sumaan.’ Pël kön wiak së itaangkën ka tapët koore katëp ëak ë rangi ulmëën kos wieëa. ");
INSERT INTO wer_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Pël ëën pi kaalak së urmer muntarö 7 ëak koirak waisa. Pörö pim ök won, utpet panëërö koirak wais ka kopët taptak wëa. Pël ëën omën pöp pi ngaan utpet kot nent wakaimaupök ënëm sasa pan sa. Tapël Yuta omën utpet peene akun eptak wë eporö ar utpet panë sak önëërö.” ");
INSERT INTO wer_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu pi omnaröen ngön ök maim wëën pim ëlre nang wais ka tomök wë piin ngön ök mapënëak yema. ");
INSERT INTO wer_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Pël ëën omën nampök piin epël yema. “Nim ëlre nang niin ngön ök niapënëak wais ka tomök wë.” ");
INSERT INTO wer_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Pël maan piin kangiir epël yema. “Nem elëp talëp? Nangarö talörö?” ");
INSERT INTO wer_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Pël mëak pim ruurö tenim ngësël mor song ëak kaalak epël yema. “Nem ëlre nang pörö eporö. ");
INSERT INTO wer_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Omën nem Pep kutömweri wëaupë ngön ngaarëk yeö piporö nem ëlre nangarö pël yaë.” ");
INSERT INTO wer_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Kët pötak Yesu pi pim kaatakaan oröak ten pim ruuröaring i kaö ëöök së wel aisëaan ");
INSERT INTO wer_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","omën kësang pan wais pim naë wa rongan yaë. Pël yaëën pi wangaöökë ngaarëk is wel aisëak wëën omnarö i pisöök taueëa. ");
INSERT INTO wer_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Pël ëaan pi watepang ngön nentere nent mëak nent epël yema. “Omën namp pim yaak së omnant öpöt olëa. ");
INSERT INTO wer_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Pël ëën nant kamtaöök ngentiin intöröak oröak na. ");
INSERT INTO wer_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ën nant këlöökë rangk ngentia. Pël ëën yanget könyangap wiaan yak teënt oröa. ");
INSERT INTO wer_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Pël ëën këtëp ngaarëk apër maan öp pöt kotön saap wak umön rëa. Pöt misënöt kotut pötaanök. ");
INSERT INTO wer_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ën nant nönötë öngpök olëa. Pël ëën nönöt oröak ngep ëën sësë ëa. ");
INSERT INTO wer_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ën nantökëër yang kolaptak olëa. Pël ëën pötökëër aprak kë kësang pan uta. Kengk nemorëët 100, nemorëët 60, nemorëët 30 pël uta. ");
INSERT INTO wer_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Katringëpök ngön epët kat wiip.” ");
INSERT INTO wer_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Pël yemaan ten pim ruurö Yesuu naë së piin epël mëëaut. “Ni tol ëënak pitën watepang ngön yemaan?” ");
INSERT INTO wer_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Pël maan pi kangiir epël yenia. “Anutu pimtok wa ngaöök nimëak wë ngön ëlëëp pöta songönte arënökëër pet yaalni. Ën muntarö puuk pël naalmëën yaë. ");
INSERT INTO wer_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Omën namp Anutuuk ngön ompyaö nant mangkën taë wak öpna pöp muntat mangkën pim naë kësang wiaapnaap. Ën namp mangkën taë wes wak naön ëëpna pöp kot weëa tapët Anutuuk kama wa ëp ëën elek öpnaap. ");
INSERT INTO wer_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Nem watepang ngön yemak epëta songönte epël. Pit itöök iteneëak këëkë itna naskolön yaaurö. Katëëpök kat wieëak këëkë kön nawiin yaaurö. ");
INSERT INTO wer_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Tektek ngön yaaö omën Aisaia pöpë ök ëa pöt pitëm naë kë yaarö. Pöt epël. ‘Ar ngön pëën kat wiinëëtak songönte ëwat nasëngan. Pël ëak ar itaampunëëtak yok pangk omnantön itnaangkan. ");
INSERT INTO wer_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Omën piporö pitëm lupöt kosang saurö, katöt il wariaurö, itöt mësëaurö. Pit pël naën ëanëën itaampööre kat wiire kön wi pël ëan tapön. Ën pit pël naën ëanëën nem naë rë olaan ompyaö mowesan tapön, Anutuuk pël ya.’ ");
INSERT INTO wer_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Ar pöt arim itöök omën ngolöpötön itaampööre katëëpök ngön ompyaut kat wi pël yeë pötön ërëpërëp ëënëët. ");
INSERT INTO wer_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ne yaap ök niamaan. Ngaan tektek ngön yaaöre omën wotpilörö kësang omën epotön iteempënëak ëak itnaangkën ëautak ar peene ityaangk. Kat wiipënëak ëak kat nawiin ëautak peene kat yawi.” ");
INSERT INTO wer_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Peene omnant öpöt olëauta watepang ngön niak pöta songönte war wes niamaan kat wieë. ");
INSERT INTO wer_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Omnant öpöt kamtöök ngentia pötë ökörö omën narö Anutuuk wa ngaöök nimëëpënëak yaë ngön pöt kat wiauröak kön nawiin yaëën ngön Anutuu pitëm lupötë wia pöt Setenök kama wa ëp yaë. ");
INSERT INTO wer_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ën omnant öpöt këlöökë rangk ngentia pötë ökörö, omën narö Anutuu ngönte kat wiak ërëpsawi ëak öpnaat. ");
INSERT INTO wer_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Pitëm lupötë misën il natëën. Pötaanök akun kot nent kön wi kosang wesak wëën pitëm Anutuu ngön ngaarëk yeö pötaan omnaröak këlangön kat mowiak utpet mowasën tapëtakëër wil këlok ëëpnaat. ");
INSERT INTO wer_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ën omnant öpöt nönötë öngpök ngentia pötë ökörö, omën narö Anutuu ngönte kat wiipnaatak wë koröpöökë omnantön kön selap ëëre monere urömen kentre kaur ëëre omën munt nantön war ë pël yaëën pötök ngep elmëën Anutuu ngönte mos ëëpnaat. ");
INSERT INTO wer_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ën omnant öpöt yang kolaptak ngentia pötë ökörö, omën narö Anutuu ngönte kat wiak këëkë kön wiak wëën pitëm wëwëatë kë ompyaut orööpnaat. Narö kë 100, narö kë 60, narö kë 30 pël orööpnaat.” ");
INSERT INTO wer_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Pël mëak Yesuuk watepang ngön munt nent pitën epël yema. “Anutu pim omnarö wa ngaöök yamë pöt omën namp pim ya lupöök omnant öp ompyaut ngënta pötakël ök ëëmaan. ");
INSERT INTO wer_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Pël ëën röök nentak pim kööre tok namp wais nön utpetatë öpöt ompyautë rangk olëak sa. ");
INSERT INTO wer_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Pël ëën omën ompyaut oröak këët utöpënëak yaëën nön utpet pötta oröak kaö sa. ");
INSERT INTO wer_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Pël ëën omp pöpë inëën ruurö pim naë wais epël mëëa. ‘Kaöap, ni öp ompyaut ya lupöök ngëntauppe. Nön utpetat tol ëak oröa?’ ");
INSERT INTO wer_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Pël maan epël mëëa. ‘Kööre tok nampök ëa.’ Pël maan pim inëën ruuröak, ‘Ten së nön utpetat ti moolan ma?’ pël mëëa. ");
INSERT INTO wer_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Pël maan pi kangiir pitën epël mëëa. ‘Won. Ar nön utpetat yatiem omën ompyautta tiinganok. ");
INSERT INTO wer_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Pout irikor ëak öp. Pël ëën omnant köp sëën öpenaatak nem omën këët öpnaaröen epël memaat. Wet rëak nön utpetat tiak ut urak esuwesi moolan. Pël ëak omën ompyaut wa rongan ëak nem kaatak wiin.’” ");
INSERT INTO wer_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Pël mëak Yesuuk watepang ngön munt nent pitën epël yema. “Anutu pim omnarö wa ngaöök yamë pöt këra nementi lëlëp pöpökël ök ëëmaan. Omën nampök lëlëp pöp pim ya lupöök ngënta. ");
INSERT INTO wer_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Lëlëp pöp kot panëëp, omën muntatë lëlëpöröak il yewas. Pël yaëëtak oröakökëër pöpök këra muntat il yewas. Pël ëak kësang sak wëën intörö wais morötë ngentiak ka ëp yawi.” ");
INSERT INTO wer_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Pël mëak watepang ngön munt nent epël yema. “Anutu pim omnarö wa ngaöök yamë pöt öng namp yis pöt korupaë kas möautring irikor ëën pötak ekek yes pötak ök ëëmaan.” ");
INSERT INTO wer_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu pi watepang ngön kësang omnaröen ök yema. Nent war wesak nemaan, watepang pëën yema. ");
INSERT INTO wer_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Pël yaëën tektek ngön yaaö nampë ngön epël ëa pöt pim naë kë yaarö. “Ne watepang ngön ök memaap. Omnant ngaanëër Anutuuk kutömre yang ket ëa akun pötakaan wais peene e wë eptak ëlëëp wiakaima pöt nook tekeri wasumaap.” ");
INSERT INTO wer_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesu omnarö sëp wesak së kaata kakaati yeila. Pël ëën ten pim ruurö naë së epël mëëaut. “Ya lupöök nön utpetat oröautakël nim watepang ngön yaan pöta songönte ök nia.” ");
INSERT INTO wer_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Pël maan kangiir epël yenia. “Omën öp ompyaut ngënta pöp Omën Këëp ne epop. ");
INSERT INTO wer_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ya pöwer pöt yang epër. Ën omnant öp ompyaö pöt omën Anutu pim wa ngaöök yamë pörö. Ën nön utpetat omën Setenë ënëm yaëën pim ngarangk yaalmë pörö. ");
INSERT INTO wer_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Kööre tok öp utpetat olëa pöp Seten, ën omën ompyaö wa pöt akun kaöaö. Ën omën wa wia pörö enselörö. ");
INSERT INTO wer_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Omnaröa nön utpetat tiak esuwesi mera pöta ök akun kaöaöök orööpnaat. ");
INSERT INTO wer_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Akun pötak Omën Këëp nook nem enselörö wes mëën nem wa ngaöök yamë pötak omën utpet yaauröere omën munt narö utpet sëpënëak yaalmëa pörö kama wak ");
INSERT INTO wer_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","es kosangwesi moolapnaat. Es kosang pöwesi omnarö ingre ya ilak aimeë kë pötöppötöp aim öpnaarö. ");
INSERT INTO wer_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Pël ëën akun pötak omën ompyaö saurö pit Anutu pitëm Pepapök wa ngaöök yamëën këtëpë yema pöl ëwa elmëëpnaat. Katringëpök ngön epët kat wiip.” ");
INSERT INTO wer_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Ën Anutu pim omnarö wa ngaöök yamë pöt urömere omën ompyaut ngaanëër yangerak ëlëëp wia pötakël ök ëëmaan. Ënëmak omën munt namp koirak muntarö koirpanëën kaalak ëlëëp wia. Pël ëak teëntom ërëpsawiaring së pim omën pout menak sumat wak yang lup pöt sum ëa.” ");
INSERT INTO wer_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Ën Anutu pim omnarö wa ngaöök yamë pöt omën songre sar ompyaut ap yewesa pöpëël ök ëëmaan. ");
INSERT INTO wer_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Pi songre sar ompyaö panë nent koirak pim omnant pout menak sumat wak së songre sar ompyaö pöt sum ëa.” ");
INSERT INTO wer_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Ën Anutu pim omnarö wa ngaöök yamë pöt iirëëp i kaöök olaan imën ke nampre namp ilëa pötakël ök ëëmaan. ");
INSERT INTO wer_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Iir pöëëp imënörö peö ëën omnarö weruak ëöökël sa. Pël ëak wël ëak ompyaurö kaputë wesirak utpetarö wa moolëa. ");
INSERT INTO wer_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Pöta ök akun kaöaöök tapël ëëpnaat. Enselöröak wais omën utpetarö ompyauröa naëaan wël ëak kama wak ");
INSERT INTO wer_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","es kosangwesi moolapnaat. Es kosang pöwesi ingre ya ilak aimeë kë pötöppötöp aim öpnaat.” ");
INSERT INTO wer_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Pël niak tenën epël pëël yenia. “Ar pöta songönten kön wia ma?” Pël niaan ten, “Mak,” pël mëëaut. ");
INSERT INTO wer_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Pël maan tenën epël niiaut. “Pöt ompyaö. Ngön kosangötë ngarangk namp Anutuu wa ngaöök yamëautak ilëak wë ngönënte këëkë ëwat saup pi ka pepapë ököp. Ka pep pöp pi uröm ompyaö ngaanre ngolöp pout pim peram wiaurekaan yeö pöl pi ngönën ompyaö ngaanre ngolöp poutepar ëwat wëaup.” ");
INSERT INTO wer_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesu pi watepang ngön pöt ök më pet irak ten pim ruuröaring saut. ");
INSERT INTO wer_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Pël ëak Nasaret pim ka songöntak oröak ngönën tuptak ilëak ngönën ök yemaan omnarö pit yaan sak epël ya. “Elei, omën epop omën yaap tiarim karippe. Tarëkaan ëwat ompyaö epot wa? Ma talëpök weëre kosang mangkën ya weëre kosang epot yamëngk? ");
INSERT INTO wer_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Tiar piin ëwat wëep. Pi ka ök yarëaupë ruuppe. Pim ëlëp Maria. Ën yokot pim nangarö Semsre Yosep, Saimonre Yutas pörö. ");
INSERT INTO wer_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ën koont pim nangaröeta tiarring wë. Pël ëaap pi weëre kosang epot tarëkaan wa?” ");
INSERT INTO wer_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Pël mëak pit piin kaaöre këëpöt yaalmëën Yesuuk epël yema. “Tektek ngön yaaö namp ka poutë omnaröak piin ping wesak yema. Pël yaautak pimtë kaare yangerak wëën piiring wëauröak pi kaö nasën wë wesak piin ping wesak nemaan ë yaë.” ");
INSERT INTO wer_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Kak pörekörö pitëm kön wi kosang nemowasën ëautaan ya retëng weëre kosangring nant kësang pitëm naë namëngkën ëaut. ");
INSERT INTO wer_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Akun pötak yang ngarangk kaöap Erot pi Yesu pim yaauta ngönte kat wia. ");
INSERT INTO wer_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Pël ëak pim ya omnaröen epël mëëa. “Omën pipop Son i yamëaup, pi wel wiak wal ëaup yak weëre kosangring ya retëng pipot yamëngk.” ");
INSERT INTO wer_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Erot pim pël mëëa pöta songönte epët. Ngaan pi pim nanëpë öngöp Erotias pöp wa ëp ëa. Pël ëën Sonök piin epël mëak nga mëëa. “Ni öng pipop wa ëp ëën pangk naën yaë.” Pël mëëa pötaanök Erotök pim ya omën naröen maan pitök Sonë ingre morötë wii tëak wii kaatak moulmëa. ");
INSERT INTO wer_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Pël ëën Erot pi Son mëmpënëak kön wiautak omnaröak piin, “Anutuu tektek ngön yaaö omnamp,” pël yamëëa pötaan kas ëën sëp wesa. ");
INSERT INTO wer_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Pël ëën ënëmak Erotë oröa akunet temanöm sëën këëre imën nëmpënëak omën kaöarö pourö pim naë wa top ëa. Akun pötak Erotiasë koontup omën pöröa ëöetak tan yaurön Erot pi itenak kent kön wia. ");
INSERT INTO wer_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Pël ëak pi koont pöpön epël mëëa. “Ne Anutuu ëöetak kosang wesak niamaan. Ni omën nenten kimang neamë pöt nimpaat.” ");
INSERT INTO wer_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Pël maan pim ëlëpök këk maan epël mëëa. “Son i yamëaup pim kepönö töak söwar neweri wiak wak wais namp. Pël ëën ne pi wel wia pöt ëwat sumaan.” ");
INSERT INTO wer_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Pël maan omën omp ak Erot pi pöt kat wiak ya këlangön kön wia. Pël ëaap pi omnaröa ëöetak ngön kosang wesautaan pim kimang ngönten kat wiak ");
INSERT INTO wer_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","pim ya omën naröen maan wii kaatak së Sonë kepönö töak ");
INSERT INTO wer_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","söwar neweri wiak wak së koontup mangkën wak së ëlëp mena. ");
INSERT INTO wer_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Pël ëën Sonë ruurö kat wiak së pim sokur wak yang kel weera. Pël ëak wais Yesuun ök yema. ");
INSERT INTO wer_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu pi ngön pöt kat wiak ten pim ruuröaring yang pör sëp wesak wangaöök ilëak i kaöök yang omën wonrekël saut. Pël yaëën omnarö kat wiak pitëm kaat sëp wesak tenim ënëm yangerak waisa. ");
INSERT INTO wer_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Pël ëën wangaöökaan oröak së itaangkën omën kësang pan wëën itenak yaköm ëën pitëm yauman omnarö ompyaö yemowas. ");
INSERT INTO wer_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Wë wiap kan ten pim ruurö pim naë së epël ök mëëaut. “Omën wonrek wëën wiap kanëën yes. Pötaanök omnarö wes mëën kaatë së kaömp sum ëëp.” ");
INSERT INTO wer_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Pël maan Yesuuk epël niiaut. “Pit tol ëën sëpën? Arök kaömp meneë.” ");
INSERT INTO wer_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Pël niaan epël mëëaut. “Ten tarëkaan mampun? Tenim naë kaömp selap won, kaömp mor nas, ën i kaö imën kopët naar pël ëak wia.” ");
INSERT INTO wer_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Maan epël niiaut. “Nem naë wak waiseë.” ");
INSERT INTO wer_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Pël niak omnaröen maan nönö mö mëak wel aisëaan kaömp mor nas pötring i kaö imënaar wak kutömweriil iteneë Anutuun yowe mëak kaömpöt pelak ten pim ruurö ningkën omnarö menaut. ");
INSERT INTO wer_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Pël ëën omën pourö nak kep wesak kaut olaan ten wak kër 12 pötë waulön peö yaë. ");
INSERT INTO wer_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Omën kaömp na pörö selap pan, ompörö 5000, ën öngre yokoturö pöt sangk nekelën. ");
INSERT INTO wer_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Kaömp na pet irën Yesuuk ten pim ruuröen epël niak këk niiaut. “Ar wangaöök ilëak i kaöökë ëngk komuntakël seë. Pël yaëën ne omnarö wes mëëmaan.” Pël niaan saut. ");
INSERT INTO wer_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Pël ëën pi omnarö wes mëën yesën Anutuun ök mapënëak rosiraöök isa. Pël ëën koö olaan pimënt pörek wëën ");
INSERT INTO wer_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","wangaö i kaöökë luptak yesën kentö maap yamöön kaö maat weëre kosangring wangaöök yamö. ");
INSERT INTO wer_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Pël ëën ëlpam wal ëëpënëak yaëën Yesu i kaöökë roro tenim ngësë yewais. ");
INSERT INTO wer_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Pël yaëën itenak ten kas kësang ëak, “Elei, waötöp ëngk yewais,” pël mëak merëk ëaut. ");
INSERT INTO wer_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Pël ëën pi tapëtakëër tenën epël niiaut. “Arim lupöt weë sëp. Nemtok yewaiserek kas ëëngan.” ");
INSERT INTO wer_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pël niaan Pitaak piin epël mëëaut. “Aköp, nimtok yaëën pöt aan ne i kaöökë roro nim naë waisum.” ");
INSERT INTO wer_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Pël maan, “Wais,” maan Pita wangaöökaan oröak kaöökë roro Yesuu ngësël yes. ");
INSERT INTO wer_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pël yeem kentö kësang yamöön itenak kas ëak i kaöökë öngpök yengmëem ngön ëak Yesuun, “Aköp, kaamök elnë,” pël mëëaut. ");
INSERT INTO wer_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Maan Yesuuk tapëtakëër el mëak moresi weë epël yema. “Nim kön wi kosang yewesaut këlok pan yaën. Tol ëënak kön selap yaën?” ");
INSERT INTO wer_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Pël mëak piarip wais wangaöök ilaan kentö leng yaë. ");
INSERT INTO wer_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Pël ëën wangaöök wëaurö ten piin yaya mëak epël mëëaut. “Yaap pan, ni Anutuu Ruup.” ");
INSERT INTO wer_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ten i kaö poö ëngköök së Kenesaret yangerak oröaut. ");
INSERT INTO wer_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Pël ëën omën pörek wëaurö Yesuun itenak ëwat sak ngön maan yauman omën yang pörek wëaurö pim naë wak waisa. ");
INSERT INTO wer_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Pël ëën pit pim ulpëën kautak pëën mësël ëak ompyaö sëpënëak këk yema. Pël maan omën pël ëa pörö ompyaö saut. ");
INSERT INTO wer_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Parisi ngönën omën naröere ngön kosangötë ngarangk narö Yerusalem kakaan Yesuu naë wais epël yema. ");
INSERT INTO wer_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Nim ruurö tol ëënak tiarim ëaröa ngön kosangöt ilap yari? Pit ngön kosangötë wieëaul kaömp nëmpënëak mor i nairën yaë.” ");
INSERT INTO wer_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Pël maan Yesuuk epël yema. “Ar tol ëënak arim ëaröa ngön kosangöt ngaarëk önëak Anutu pimtë ngön kosangöt wa yoolak? ");
INSERT INTO wer_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Anutuuk kosang wesak epël ëa. ‘Nim ëlre pepaarë ngön ngar wak ompyaö elmë.’ Ën nenteta epël. ‘Omën namp pim ëlëpön ma pepapön utpet wesak mapna pöp mën wel wiip.’ ");
INSERT INTO wer_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Anutuuk pël yaatak ar ngön epël yaaurö. ‘Namp pim ëlre pepaar omën nenten ap yewasën omën pim piarip kaamök elmëëpna pöt pim naë wiaan pöten, “Ne omën epët Anutuun yaö ëaup,” pël mëëaupök pim ëlre pepaarë ikanöök wë kaamök naalmëën pöt pangk yaë.’ ");
INSERT INTO wer_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ar pël yeem arim ëaröa ngön kosangötë ënëm yeë pötak Anutuu ngönte ke ur yoolak. ");
INSERT INTO wer_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Kaar omnarö aë. Tektek ngön yaaö omën Aisaia pim ngaanëër arimëën ngön ëa pöt kë yaarö. Pöt epël. ");
INSERT INTO wer_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Omën eporö pitëm këmötök neen yaya yenëem lupötök këëpöt yaalnëaurö. ");
INSERT INTO wer_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Pitëm ngönöt nem ngön këëta urtak wiak nener rë yemoulaurö. Pël yeem neen yaya yenëaan itaangkën mos ë yaë.’” ");
INSERT INTO wer_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Pël mëak Yesu pi omnaröen ngön maan waisën epël yema. “Nem ngön ök niama epët kat wiak kön wi soköleë. ");
INSERT INTO wer_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Omnant këmtak yen pötök lupmer utpet newasën yaë. Këmtakaan yaarö pötök lupmer utpet yewas.” ");
INSERT INTO wer_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Pël maan ten pim ruurö së piin epël mëëaut. “Ni ngön pipot yemaan Parisi omnarö këëpöt kön yawi pöten ni ëwat wëën ma?” ");
INSERT INTO wer_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Maan epël ya. “Këra pout nem Pep kutömweri wëaupök pim ya lupöök nangëntën ëa pipot ti moolapnaat. ");
INSERT INTO wer_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ar Parisi omnaröen kön selap ëëngan. Pit omën it il tëauröa ök yaë. It il tëa naar nampnamp mësak yesem kanö wiaan saarëak parë orööpnaat.” ");
INSERT INTO wer_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pël niaan Pitaak epël yema. “Watepang ngön pipta songönte ök nia.” ");
INSERT INTO wer_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Maan Yesuuk epël ya. “E, arta om köpël wëan ma? ");
INSERT INTO wer_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Arim omnant këmtak yen pötök utpet naniwaspan, yaatak sëën ya yaar pöten ar köpël ma? ");
INSERT INTO wer_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ën këmtakaan yaarö pipotökëër lupmeriaan yaarö. Pipotök lupmer utpet yewas. ");
INSERT INTO wer_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Omën lupmeriaan utpet epot yaarö. Kön utpet, yamëngka, öngre omp wëwëet kom yaaö, öngre omp nga yaaö, këkain, kaar, neneren utpet wesak yaaö, ");
INSERT INTO wer_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","pipot lupmeriaan oröak lupmer utpet wasëpnaat. Mor i nairën kaömp yen pötak omnampë lupmer utpet newaspan.” ");
INSERT INTO wer_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu pi ten pim ruuröaring Kenesaret yang pör sëp wesak Taiaare Saiton ka pöörar wieëa yang pörekël saut. ");
INSERT INTO wer_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Pël ëën Kanan yangerakaan ngönën köpël öng namp yang pörek wëaupök wais merëkre ngön ëak Yesuun epël yema. “O Aköp, Tewitë ëap, Anutuu Yaö Mëëaup, urmer namp nem koontupë lupmeri wëën këlangön kaö panë kat yawi. Pötaan ni neen yaköm elnë.” ");
INSERT INTO wer_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Pël maan pi kangiir nemaan ëën ten pim ruurö pim naë së ke urak epël mëëaut. “Pi tiarim ënëm yewaisem merëkre ngön yaarek wes momëën sëp.” ");
INSERT INTO wer_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Pël maan Yesuuk kangiir Kanan öng pöpön epël yema. “Anutuuk ne Israel pol sëpsëpöröa ök ëak repak sauröaan pëën wes nemëaup.” ");
INSERT INTO wer_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Pël maan pi pim naë wais rar rë wesirak epël yema. “Aköp, kaamök elnë.” ");
INSERT INTO wer_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Pël maan Yesuuk kangiir epël yema. “Rungaaröa kaömpöt wa ëp ëak kentörö nemangkën ë yaë pöl ni maimap kaamök naalniingan.” ");
INSERT INTO wer_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Pël maan pi kangiir epël ök yema. “Aköp, yaap yaan. Pël ëaap kentörö pit peparö kaömp yenaurek yenën lupöt ti ngentiin na yaë pöl ni kaamök elnë.” ");
INSERT INTO wer_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Maan epël yema. “Öng epop, ni kön wi kosang kaö panë yenewasën. Pötaanök nim kent kön yawiin pöt orö nirëëpnaat.” Pël yemaan tapëtakëër koontup ompyaö sa. ");
INSERT INTO wer_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu ten pim ruuröaring yang pör sëp wesak kaalak Kalili i kaöökël së oröak ë kankan rosiraöök së wel aisëaan ");
INSERT INTO wer_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","omën selap pan pim naë oröa. Omën ingöt kël wë, it il të, kos korar së, ngön won së, yauman ke nentere nent yaaurö wak wais Yesuu naë rongan ë moulmëën ompyaö mowesaut. ");
INSERT INTO wer_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Pël ëën omën ngön won saurö ngön aö, kos korar saurö wotpil së, ing kël waurö kan ing ë, it il tëaurö it nga së, pël yaëën omën kësang pörö itenak yaan sak Israel omnaröa Anutuun yaya yema. ");
INSERT INTO wer_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu pi ten pim ruuröen ngön niaan pim naë sëën epël niiaut. “Ne omën kësang eporöen yaköm kön yawi. Pit neering wë kaömp nanën wëën kët nentepar nent ëak yes. Pötaanök ne pit këën wes mëën kan kourak yesem utpet ëëpanëak ya ngës yaë.” ");
INSERT INTO wer_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Pël niaan ten epël mëëaut. “Tiar omën wonrek wë omën kësang eporöa kaömp mangkën pangk nëmpna pöt tarëkaan öpen?” ");
INSERT INTO wer_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Pël maan Yesuuk, “Arim naë kaömp tolël ëak wia?” pël niaan tenök, “Kaömp 7, ën i kaö imën kopët naar,” pël mëëaut. ");
INSERT INTO wer_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Maan Yesuuk omnaröen yangerak wel aisapën mëak ");
INSERT INTO wer_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","kaömp 7 pötring i kaö imënaar wak Anutuun yowe mëak pelak ten pim ruurö ningkën omnarö menaut. ");
INSERT INTO wer_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Pël ëën omën pourö nak kep wesak kaut olaan ten wak kër 7 pötë waulön peö yaë. ");
INSERT INTO wer_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Omën kaömp na pörö selap pan, ompörö 4000, ën öngre yokoturö pöt sangk nekelën. ");
INSERT INTO wer_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Pörö Yesuuk wes mëën yesën tenring wangaöök ilëak Makatan yangerakël saut. ");
INSERT INTO wer_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Parisiire Satusi ngönën omën narö Yesuu naë wais piin morök elmëak epël yema. “Ni maan retëng it ngolöp nent oröön Anutuu naëaan waisan pöt ëwat sënaan.” ");
INSERT INTO wer_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Pël maan pitën epël yema. “Ar wiap kanötë itaangkën yanget sapiire waö yamëën itenak, ‘Wangam kanök këtëp mapënëak yaë,’ pël ë yeë. ");
INSERT INTO wer_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ën wangam kanötë itaangkën yanget mëëtmëët yaëën pöt, ‘Kopi pelëpënëak yaë,’ pël ë yeë. Ar mopöök uröamre kepilötön itenak ëwat yaauröak peene Anutuu yaalni epëta songönten köpël yeë. ");
INSERT INTO wer_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Omën peene akun eptak wë eporö ar utpet ëak Anutuun kön wi kosang newasën yaaurö. Ar ya retëngöt yamëngka pöten ke urak yenëak. Pötaanök ne ya retëng nent naëngan, om ngaan tektek ngön yaaö omën Sona pi i kaö imënëpë öngpök wëën Anutu pim elmëa pöta ököt pëën pet elniin itaampunëët.” Pël mëak pit sëp wesak saut. ");
INSERT INTO wer_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ten Yesuu ruurö kaömpöt kat kol wiak piiring i kaöökë ëngk komuntakël së oröak kön wiaut. ");
INSERT INTO wer_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Pël yaëën Yesuuk epël yenia. “Ar Parisiire Satusi omnaröa yisötön ngarangk këëkë ëën.” ");
INSERT INTO wer_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Pël niaan ten neneren epël mëëaut. “Tiar kaömp peretöt wak newaisën ëautaan epël yenia.” ");
INSERT INTO wer_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Tenimënt neneren yemaan kat men ëak epël yenia. “Arim kön wi kosang yewesaut këlok pan yaaurö, aë. Ar tol ëënak kaömp won pöten yak? ");
INSERT INTO wer_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ar om neen köpël wë ma? Ne kaömp mor nas wak ulöl wesak omën 5000 pörö mangkën nëën pangk ëaut pöt ar kat kola ma? Pit kep wasën ar kaömp kaut kër tolël ëak waulön peö ëa? ");
INSERT INTO wer_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ën ne kaömp 7 pöteparök wak ulöl wesak ömën 4000 pörö mangkën nëën pangk ëaut pöteta ar kat kola ma? Pit kep wasën ar kaömp kaut kër tolël ëak waulön peö ëa? ");
INSERT INTO wer_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ar tol ëënak nem ngönten kön nawiin yeë? Ne kaömp peret pöten neniaan. Ar Parisiire Satusi omnaröa yisötön ngarangk këëkë ëën.” ");
INSERT INTO wer_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Pël niaan ten pim niia pöta songönten kön wiaut. Pi yis kaömp peretötë yamëa pöten neniaan, Parisiire Satusi omnaröa ngön kaaröt tenim yaapta öngpök ilapanëak niia. ");
INSERT INTO wer_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu pi tenring Sisaria Pilipai kak naë së oröak tenën epël pëël yenia. “Omnarö pit Omën Këëp neen talëp aim?” ");
INSERT INTO wer_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Pël niaan epël mëëaut. “Naröak niin, ‘Son i yamëaup,’ pël yaan naröak, ‘Elia,’ naröak, ‘Seremaia ma tektek ngön yaaö namp wes,’ pël aim.” ");
INSERT INTO wer_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Pël maan epël yenia. “Ën arimtok pöt neen talëp aim?” ");
INSERT INTO wer_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Pël niaan Saimon Pitaak epël yema. “Ni Kristo, Anutuuk Yaö Niiaup. Ni Anutu wëwëetaringëpë Ruup.” ");
INSERT INTO wer_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Pël maan Yesuuk epël yema. “Saimon, Sona pim ruup, ni ërëpërëp ëëmëëp. Yang omën nampök ngön pipët ök neniaan, nem Pep kutömweri wëaupök yenia. ");
INSERT INTO wer_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Pötaanök ne niamaan kat wi. Nim yapinte Pita, pöt kël kosangö. Ën nim nem songönte tekeri yewasën pipëteta kël kosangöökë ököt. Nook maan nem ingre mor saurö kël kosang pöökë rangk tauaan Setenë weëre kosangtak il naniwaspan. ");
INSERT INTO wer_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ne Anutuuk wa ngaöök yanimë pötak yeilëauta kiet nimpaat. Pël ëën yangerak omnant yaautön, ‘Pël ëëngan,’ mamë pöt kutömweriita pël naën ëëpnaat. Ën yangerak omnant yaautön, ‘Pël ë,’ mamë pöt kutömweriita pël ëëpnaat.” ");
INSERT INTO wer_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Pël mëak tenën kosang wesak epël yenia. “Ar ne Kristo, Anutuu Yaö Neeaup, pöt omnaröen ök manganok,” pël niiaut. ");
INSERT INTO wer_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Akun pötak Yesuuk ngës rëak ten pim ruuröen omnant ënëm pim naë orööpnaatë ngönöt war wesak epël yenia. “Ne Yerusalem kak sëën ngarangkre kiri ar yaaö kaöaröere ngön kosangötë ngarangköröak këlangön kësang kat newiak nemëngkën kët nentepar nent won sëën kaalak weletakaan wal ëëmaap,” ngön pöt ök yenia. ");
INSERT INTO wer_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pël niaan Pitaak pëëntakël koirak së epël mëak nga yema. “Anutuuk ngarangk elniaan omën ke pipot orö nanirëën ëëp.” ");
INSERT INTO wer_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Maan Yesuuk kaip tiak epël yema. “Seten, ni sëp newesak së kan newariingan. Nim ngön yaan pipët Anutuu ngönte won, omën ngönte.” ");
INSERT INTO wer_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Pël mëak Yesuuk ten pim ruuröen epël niiaut. “Omën namp pi nem ënëm elnëëpënëak pöt pimtë könöökë kentöt këëpöt weseë, ‘Ne Yesu pimëën wel wiima pöt pangk ëëmaap,’ pël wesak pim këra yetapër waalak nem ënëm ëëp. ");
INSERT INTO wer_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Namp pim wëwëet keimön ëak öpna pöt pim wëwëet kö sëpnaat. Ën namp nemëën yak wëwëet këëpöt wasëpna pöt pim wëwëet ompyaö orö morëëpnaat.” ");
INSERT INTO wer_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ën namp yangerakë omnant pout kent ëak weim wëën pötök pim wëwë ompyaut utpet mowasën won sëën omën pötök tolëël kaamök elmëëpën? Pël naëpan. Ma namp pim wëwë ompyaut kaalak öpënëak pöt oröpöt kangiir mampën? ");
INSERT INTO wer_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Omën Këëp nem Pepapë ëwaö nem rangk wiaan nem enselörö koirak waisumaap. Pël ëak omën pourö neenem wëwëatë kangut mempaap. ");
INSERT INTO wer_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ne yaap pan niamaan. E taua eporö arëkaan narö wel nawiin wëën Omën Këëp ne omp ak sak yewaisën itaampun sa.” ");
INSERT INTO wer_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Kët 6 ëak won sëën Yesu pi Pitaare Semsre pim nangap Son pörö koirak rosir wali naöök së pitëmënt wakaima. ");
INSERT INTO wer_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Pël ëak pi pitëm ëöetak möönre koröp maim wa. Ën pim këëre wot kante këtëpë ök ëwa ëën ulpëënëpta kölam panë tëa. ");
INSERT INTO wer_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Pël ëaan pit itaangkën Mosesre Elia piarip oröak Yesuring ngönaak yeëa. ");
INSERT INTO wer_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pël ëën Pita pi Yesuun epël ök mëëa. “Aköp ten eprek wëën ompyaö yaë. Ni kent yaëën pöt ne ka kot nentepar nent ök remaan. Nent nimëën, nent Mosesëën, nent Eliaëën pël ëak ök remaan.” ");
INSERT INTO wer_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pël yemaan tapët pöt uröam kölam ëwa nempel irë kaka elmëën Anutuuk uröamta öngpökaan epël mëëa. “Epop nem Ruup. Ne piin ya kë sak kent pan yaalmë. Ar pim ngönte kat wiin.” ");
INSERT INTO wer_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ruurö pit ngön pöt kat wiak kas panë ëën yangerak së ngentiak wot nön ëak wieëa. ");
INSERT INTO wer_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Pël ëën Yesu pi së pitën ngëën elmëak epël ök mëëa. “Wal ëeë. Kas ëëngan.” ");
INSERT INTO wer_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Pël maan pit we riak itaangkën muntaar won, Yesu pimënt wëa. ");
INSERT INTO wer_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Pit rosiraöökaan yeirëem Yesuuk pitën pepanöm epël mëëa. “Arim omën it köpëlöt ityaangk pöten omnaröen peene ök mangan. Ënëmak Omën Këëp ne weletakaan wal ëënak omnaröen ök man.” ");
INSERT INTO wer_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Pël maan pim ruuröak epël mëak pëël mëëa. “Ngön kosangötë ngarangkörö pit tol ëënak Elia wet rëak oröönak Anutuu yaö mëëaup ënëm orööpnaat pël aim?” ");
INSERT INTO wer_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Maan pi epël mëëa. “Yaap, Elia pi wet rëak oröak Anutuu yaö neeaup nemëën omnant kopëta wasëpënëak ëaut. ");
INSERT INTO wer_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pël wiaap ne epël niamaan. Elia pi yok oröak wëën omnarö piin këëkë ëwat nasën wë pitëm könöök utpet mowesaut. Pötaanök Omën Këëp neenta tapël elnëëpnaat.” ");
INSERT INTO wer_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Pël maan pit epël kön wia. “Pipët Son i yamëaupön ya.” ");
INSERT INTO wer_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Omën kësang pan wa top ëak wëën pit wais oröön omën namp Yesuu naë wais rar rë mowesirak epël yema. ");
INSERT INTO wer_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Kaöap, ni nem yokotupön yaköm kön wi. Pi it ngengën yeem imeri ilaöre es kotö pël yaë. ");
INSERT INTO wer_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Pël yaëën nim ruuröa naë wak wais ompyaö wasëpënëak maan poprak ëaut.” ");
INSERT INTO wer_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Pël maan Yesuuk epël yema. “O kön wi kosang yewesaut wonörö, aë. Ar lup kosarö. Ar neen kön wi kosang nenewasën yeem ar kön wiin akun tolëël arring wë arim könömöt weim öm?” Pël mëak epël yema. “Yokotup wak wais.” ");
INSERT INTO wer_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Pël maan wak waisën Yesuuk urmerapön nga maan kas oröak yes. Pël ëën akun tapëtakëër ompyaö saut. ");
INSERT INTO wer_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Pël ëën ten pëëntak së Yesuun, “Ten tol ëënak urmerap waö ë momëënëak poprak ëan?” pöten pëël mëëaut. ");
INSERT INTO wer_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Pël maan epël niiaut. “Arim kön wi kosang yewesaut këlok yaë pötaan poprak ëan. Ne yaap niamaan. Ar kön wi kosang kot panë nent wieëan talte rosir epöön, ‘Ni tiak eprekaan ëngkrek së orö,’ pël maan yok pangk pël ëëpën. Ar kön wi kosang kaö newasënë pöt omnant pout pangk ëënëët. ");
INSERT INTO wer_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Urmer ke pilörö weëre kosangring wë. Pötaanök pit waö ë momëënë pöt kan munt naö won, om Anutuun kimang manëak kaömp ngës olëak önë kopët pötakëër waö ë momëënëët.” ");
INSERT INTO wer_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ënëmak Yesuuk ten pim ruurö wa top ë niulëak epël niiaut. “Omnaröak Omën Këëp ne ngaaröa moresi neulëëpnaat. ");
INSERT INTO wer_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Pël ëën pit nemëngkën kët nentepar nent won sëën kaalak weletakaan wal ë neulëëpnaap.” Pël niaan ten yaköm panë kön wiaut. ");
INSERT INTO wer_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ënëmak ten Yesu piiring Kapaneam kak së oröön omën Anutuu ngönën tup kaöetaan takis yewa pörö Pitaë naë wais epël mëak pëël yema. “Arim rë yanuulaup ngönën tup kaöetaan takis nawiin yeëa ma?” ");
INSERT INTO wer_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pël maan Pitaak, “Won, yawiaup,” pël mëak Yesuu kaatak së ilëak ök nemaan wëën pimtok epël mëak pëël yema. “Saimon, ni kön tolëël yawiin? Yang omp akörö pit talöröa naëaan takis yewa? Pitëmtë omnaröa naëaan ma maimaröa naëaan yewa?” ");
INSERT INTO wer_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pël maan Pitaak, “Maimaröa naëaan,” pël yemaan Yesuuk epël mëëaut. “Pël yaëën yang omp aköröa karurö pangk takis nemangkën ë yaë. ");
INSERT INTO wer_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pël ëaap tepër nemangkën ëën pit kön wiin utpet ëëpanok i kaöök së tatë olëak i kaö imën wet rëak ömë pöp këm nga ëak itaangkën sum nent wiaan pöt wak së tepërim könkön takis mamp.” ");
INSERT INTO wer_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Yesuuk Pitaan pël yemaan akun tapëtak ten pim ruurö naë së epël mëak pëël mëëaut. “Anutuu wa ngaöök yanimë eporö tenëkaan talëpök wotöök wë?” ");
INSERT INTO wer_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Pël maan pi runga nampön ngön maan waisën tenim tekrak tau ulmëak ");
INSERT INTO wer_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","epël yenia. “Ne yaap niamaan. Ar kön kur kaip tiak arimtën kön wiin iraan rungaaröa ök nasën ëënë pöt Anutuuk wa ngaöök nanimëëpan. ");
INSERT INTO wer_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Namp pi pimtën kön wiin iraan runga epopë ök sak öpna pöp omën Anutuu wa ngaöök yamëautak wëauröa wotöök sak öpnaap. ");
INSERT INTO wer_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Omën nemëën yak runga kot ke epëlëp sant elmëëpna pipop ne sant elnëëpnaap.” ");
INSERT INTO wer_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Ën omën nampök kot ke epëlöröakaan namp neen kön wi kosang yewesaupön këk maan pim kön wi kosang yewesaut sëp wasëpënëak yaëën pöt pël ëëpanëën naröak wet rëak kël kësangö pim mesetak öngö moutak i kaöök moolaan i nak wel wiipna pöt pangk ëëpnaat. Pöt omën pöpök maan kot ke epëlöröa namp pim kön wi kosang yewesaut sëp wasën pöt kangiir utpet kaö panëët pim naë orööpnaat. ");
INSERT INTO wer_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Yaköm. Morök ke nentere nent yaaröön omnarö saun yokoir. Yaap, morök ke nentere nent oröön omnarö saun koirëpnaat. Pël ëaap omën morök elmëën omnarö saun koirëpna pöp tol ëëpën? ");
INSERT INTO wer_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Nim moresök ma ingesök utpet nent koirën pöt il olam. Mor kopëtasring ma ing kopëtasring wëwë kosangtak ömë pöt ompyaö. Pouwesiarring wëën Anutuuk es kosangwesi nuulaan pangk naën ëëpnaat. ");
INSERT INTO wer_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ën omën nim itöök itaampëëtak weru nuulaan utpet ëëmëak yeem pöt it pö ur olam. It kopët naööring wëwë kosangtak ömë pöt ompyaö. Pourarring wëën Anutuuk es parëaöök wa nuulaan pangk naën ëëpnaat.” ");
INSERT INTO wer_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Ar ngarangk këëkë ëën. Runga neen kön wi kosang yewesa kot eporöen kön wiin irepan. Ne yaap niamaan. Ensel pitën ngarangk yaaurö kët ëlötë nem Pep kutömweri wëaupë ëöetak wë pitëmëën ya yamëngk. ");
INSERT INTO wer_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Omën Këëp ne omën utpet ëak kö sëpënëak yaaurö koirak ompyaö wasumëak waisaup. ");
INSERT INTO wer_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Ar kön tolëël yawi? Omën namp pim pol sëpsëp 100 ëak wëauröak kopët namp kö sëën pöt pi tol ëëpën? Pi 99 ompyaö wëa pörö rosiraöök moulmëak kö sak sa pöpön ngaöl ëëpnaat. ");
INSERT INTO wer_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ne yaap niamaan. Pi ngaöl ë së koirak 99 kö nasën ëa pöröaan ya kë nasëpan, ngaöl ëak koira pöpönökëër ya kë panë sëpnaat. ");
INSERT INTO wer_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Pötaanök nem Pep kutömweri wëaupë kentöök pim omën runga kot eporöa ök sak wëauröakaan kopët namp kö sëpnaaten kaaö yaë.” ");
INSERT INTO wer_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Nim kar nampök utpet elniin pöt ni pim naë së arpimënt wë utpet pöta ngönte an. Pël ëën pi nim ngönte kat wiak ënëm ëën pöt arip lup kopëtemer sak önëët. ");
INSERT INTO wer_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ën nim ngönte kat nawiin ëën pöt ni omën kopët namp ma naar koirak pim naë sën. Pël ëak ar naar ma naar namp pöröak pim ngönte ëak wotpil wasën. ");
INSERT INTO wer_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ën pi arim ngönte wa olaan pöt së ingre moröröen ök man. Pël ëën pitëm ngönteta wa olaan pöt piin, ‘Ngönën wonöröere utpet yaauröa ököp,’ pël mëak waö ë mëën. ");
INSERT INTO wer_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Ne yaap niamaan. Ar yangerak wë omnant yaautön, ‘Pël ëëngan,’ manë pöt Anutu kutömweri wëaupökta tapël apnaat. Ën yangerak wë omnant yaautön, ‘Pël ë,’ manë pöt Anutu kutömweri wëaupökta tapël apnaat. ");
INSERT INTO wer_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Ën nenteta epël niamaan. Arim naëaan omën naar omën nentaan Anutuun kimang manëak lup kopëtemer sak kimang manë pöt nem Pep kutömweri wëaup yok pangk kat wiipnaat. ");
INSERT INTO wer_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ar omën naar ma naar nampök nem yapintakël kimang manë pöt ne arim tekrak wë kaamök elniimaat.” ");
INSERT INTO wer_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Yesuuk pël niaan Pitaak naë së epël yema. “Aköp, nem karip utpet yaalnëën ne akun tolël ëak pim utpet pöt ent ë moolam? Akun 7 ëak pël ëën pangk ëëpën ma?” ");
INSERT INTO wer_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Pël maan Yesuuk epël yema. “Ne akun 7 ëak pël neniaan, sangk naalngan, om pël ëeim ömëëten yeniak. ");
INSERT INTO wer_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Pöta watepang ngön nent epël niamaan. Anutu pim omnarö wa ngaöök yamë pöt ne yang omp ak nampë pim inëën ruurö sumat mangkën kangut mampënëak yas mëëa pötakël ök ëëmaan. ");
INSERT INTO wer_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Pi nampön yas maan waisa. Pöp 10 milion kina pël mangkën kangut nemangkën ëa. ");
INSERT INTO wer_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Pi sum kësang pöta kangiir mon oröpöt mampënëak ap yewasën omp aköpök pimëntre pim öngre ruure omnant pout omnarö menak sum öpënëak mëëa. ");
INSERT INTO wer_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Pël maan inëën ru pöp omp aköpë naë së rar rë wesirak wiap sësë mëak epël mëëa. ‘Kaöap, ni yaköm kön newi. Pël ëën ne sapsap nimpö së pet irumaan.’ ");
INSERT INTO wer_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Pël maan omp aköpök pim kang kësang pöt sëp wesak sëpënëak mëëa. ");
INSERT INTO wer_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Pël ëën inëën ru pöp kaatakaan oröak së kan kourak inëën ru pim kar namp koira. Pim kar pöp puuk 100 kina pël mangkën kangut nemangkën ëaup. Pöp koirak ngerngeröök moröak, ‘Nem kangut peene nan,’ pël mëak këk mëëa. ");
INSERT INTO wer_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Pël maan pim karip rar rë wesirak wiap sësë mëak epël mëëa. ‘Ni yaköm kön newi. Pël ëën ne kangut sapsap nimpö së pet irumaan.’ ");
INSERT INTO wer_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Pël maan pi kat nemowiin wii kaatak moulmëak epël mëëa. ‘Nem kangut pout pet irakök oröömëëp.’ ");
INSERT INTO wer_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Pël ëën inëën ru pim karuröak pim ëa pöten itenak ya këlangön panë ëën së omp aköpön ök mëëa. ");
INSERT INTO wer_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Pël ëën inëën ru mon kësang mena pöpön kaalak yas maan waisën epël mëëa. ‘Ni inëën ru utpetemor. Nem sum kësangötë kangut ni wiap sësë yenëaan yaköm ëën pout sëp wesaut. ");
INSERT INTO wer_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nem niin yaköm elnian pöl tol ëënak nim karipön naën ëaup?’ ");
INSERT INTO wer_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Pël mëak omp aköpök ya sangën ëën wii kaatak moulmëak epël mëëa. ‘Nem kangut pout pet irakök oröömëëp.’” ");
INSERT INTO wer_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yesu pi watepang ngön pöt ök ë pet irak tenën epël niiaut. “Arim karuröa utpet elniaut yaap ent ë nemoolaan ëënë pöt nem Pep kutömweri wëaupök tapël elniipnaat.” ");
INSERT INTO wer_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu pi ngön pöt ök ni pet irak ten pim ruuröaring Kalili yanger sëp wesak Yotan olëak ëngk komuntakël Yutia yangera kautakël saut. ");
INSERT INTO wer_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Pël ëak wëën omën kësang ënëm wais pörek oröön yauman omnarö ompyaö mowesaut. ");
INSERT INTO wer_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Pël yaëën Parisi ngönën omën narö wais piin morök elmëak epël yema. “Omën namp pim öngöp omën nant ëën yok pangk wes mëëpën ma?” ");
INSERT INTO wer_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Maan epël yema. “Ar ngönëntak epël wia pöt sangk kelak kat nawiin yaaurö ma? Anutu pi ngaan omën ket ëëpënëak öngre omp pouwaar ket ëa. ");
INSERT INTO wer_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Pël ëak Anutu pi epël ëa. ‘Ne ompöpë kosaöökaan öngöp ket ëaut. Pötaanök omp namp pim ëlre pepaar sëp wesak öngöpring erën ëën piarip pouwaarök möönre koröp kopëtaö sëpnaat.’ ");
INSERT INTO wer_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Anutuuk pël ëa pötaanök piarip naarök erën ëën möönre koröp kopëtaö yes. Anutuuk erën elmëa. Pötaanök omnaröak yok pangk kom naën ëëpenaat.” ");
INSERT INTO wer_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Pël maan pit piin epël yema. “Moses pi tol ëënak epël ëa? ‘Namp pim öngöp wes mëëpënëak pöt kaöaröa naëaan pep kosangwer wa öngöp menakök wes mëëpnaat,’ pël ëa.” ");
INSERT INTO wer_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Pël maan Yesuuk kangiir epël yema. “Moses pim ngön kosangtak arim lup kosangtaanök öng wes mëënëëtaan kuure mak niia. Pël ëaatak ngön pöt won wiaan ngaan panëër Anutu pim öngre omp ket ëa pötak pël ëënëak neniaan. ");
INSERT INTO wer_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ën nook pöt epël niamaan kat wieë. Namp pi pim öngöp öngre omp wëwëet utpet newasën wëën wes mëak öng muntap koirëpna pöp pi öngre omp wëwëet utpet wesak saun koirëpnaap.” ");
INSERT INTO wer_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Pël yemaan ten epël mëëaut. “Pil wiaan pöt öng naön öpën seëa.” ");
INSERT INTO wer_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Pël maan epël niiaut. “Omën pourö arim ngön pöta ënëm pangk naëpan. Om Anutuuk öng naön ëëpënëak mapna pörö pëën arim ngön pöta ënëm ëak öng naön ëëpnaat. ");
INSERT INTO wer_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Omnaröa öng naön yaaö pöta songön nentere nent wia. Narö pitëm ëlöröak mos wilën öng naön ëëpnaat. Narö omën naröak öp ilën öng naön ëëpnaat. Narö Anutuu yaat mëmpënëak kön wiak öng naön ëëpnaat. Omën nem ngön epët kat wiak Anutuu yaat mëmpënëak tek öpna pörö yok pangk pël ëëpnaarö.” ");
INSERT INTO wer_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Akun nentak omën narö pitëm rungaarö Yesu pim moresiar pitëm rangk mowiak Anutuun kimang mapënëak wak waisa. Pël yaëën tenök nga yemaan ");
INSERT INTO wer_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yesuuk epël niiaut. “Nga mangan. Wes mëën nem naë waisëp. Ke pilörö Anutuuk wa ngaöök mëëpënëak yaö yema pötaanök.” ");
INSERT INTO wer_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Pël niak pim moresiar pitëm rangk mowiak wes mëak yang pör sëp wesak nal saut. ");
INSERT INTO wer_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Akun nentak omp ulwas namp Yesuu naë wais epël yema. “Rë yanuulaup, ne ya ompyaö tol nent mënak wëwë kosangta yaö sum?” ");
INSERT INTO wer_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Pël maan Yesuuk epël yema. “Ni tol ëënak ya ompyauten pëël yenëaan? Anutu kopëtapökëër ompyaup. Ni wëwë kosangtak ömëak pöt Anutuu ngön kosangöt ngaarëk öm.” ");
INSERT INTO wer_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Maan “Ngön kosang tal nent ngaarëk öm?” pëël yema. Pël maan Yesuuk kangiir epël yema. “Ni omën mëngkanok. Ni öngre omp wëwëet kom ëënganok. Ni këkain ëënganok. Ni omën muntaröen kaar manganok. ");
INSERT INTO wer_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ni nim ëlre pepaarë ngön ngar öm. Nimtëën lup sant yaën tapël muntaröen elmëëm.” ");
INSERT INTO wer_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Pël maan omën pöpök epël yema. “Pipot nem kotuukaan ë waiseimautöp wëwë kosangtak ömaan munt tal nent ëëm?” ");
INSERT INTO wer_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Maan Yesuuk epël yema. “Ni ompyaö sumëak pöt së nim omnant pout menak sumat wak omën omnant wonörö mamp. Pël ëëmë pöt kutömweri omën ompyaut orö nirëëpnaat. Pötaanök pël ëak wais nem ënëm elnëëm.” ");
INSERT INTO wer_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Pël maan omnamp pi pöt kat wiak ya këlangön kön wiak sa. Pöt pi urömere kaar es kësang wieëa pötaanök. ");
INSERT INTO wer_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Omën pöp yesën Yesuuk ten pim ruuröen epël niiaut. “Ne yaap niamaan. Omën omnant kësang wieëaurö Anutuu wa ngaöök yamëa pöta öngpök ilapnaataan poprak ë yaë. ");
INSERT INTO wer_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Pöta nokoli nent epël niamaan. Pol kamel namp yok pangk wap poë koröp korir yamë pöökë kanöök ilapna pöt kengkënte. Ën omën monere uröm selap wieëauröak Anutuu wa ngaöök yamë pötak ilapna pöt könöm panëët.” ");
INSERT INTO wer_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Pël niaan ten kat wiak weëre kosang won sëën epël mëëaut. “Omën ke pilörö Anutuu wa ngaöök yamëautak neilaan ëëpna pöt omën tolëëlëpök yok pangk wëwë kosangtak öpën?” ");
INSERT INTO wer_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Maan Yesuuk tenën it kos ëeë epël yenia. “Omnaröak Anutuu wa ngaöök yamëautak ilanë pöt pangk naën ëënëëtak Anutuuk yok pangk kanö koir nimpnaat. Pöt pi weëre kosangringëpök omnant pout pangk yaaup.” ");
INSERT INTO wer_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pël niaan Pitaak kangiir epël yema. “Kat wi. Ten omnant pout sëp wesak nim ënëm elniaut. Pöta kangiir ten ënëmak oröpöt orö nirëëpën?” ");
INSERT INTO wer_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Maan Yesuuk epël yenia. “Ne yaap niamaan. Ënëmak omnant pout ngolöp wasën ompyaö sëpna pötak Anutuuk Omën Këëp ne weëre kosang nangkën nem ur kësangtak wel aisëaan ar nem ënëm elnëeimauröeta kaö sak ur kësang 12 pötë wel aisëak neering Israel kur 12 pötë ngön ë pet irëpen sa. ");
INSERT INTO wer_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Omën namp nemëën yak pim kaare yang, öngre ru, sasre nan, ëlre pep, ëmre ya sëp wasëpna pöp Anutuuk kangiir omën ke pilöt kësang pan tekeri wes mangkën wëwë kosangët pep sëpnaap. ");
INSERT INTO wer_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Wetëëröakaan selap ënëm rapnaat. Ën ënëmaröakaan selap wetë rapnaat.” ");
INSERT INTO wer_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Akun nentak Yesuuk watepang ngön nent epël niiaut. “Anutu pim omnarö wa ngaöök yamë pöt wain yaawer wieëa nampök pim ya pöweri omnarö ya mëmpënëak wes mëën sa pötakël ök ëëmaan. ");
INSERT INTO wer_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Omën pöp pi kët kopët nentaan 2 kina mampna pöten maan pit kat wiin pangk ëën yaakë wes momëën sa. ");
INSERT INTO wer_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Pël ëën këtëp kosang yesën pi së itaangkën narö pit ka tomök tauwal ëeim wëën epël ök mëëa. ");
INSERT INTO wer_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","‘Arta nem yaak së ya mëngkën ne sum ompyaö nimpaan.’ ");
INSERT INTO wer_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Pël ëën këtëp luptak wëën së tapël ök mëak kaalak këtëp tingk yewasën tapël ëa. ");
INSERT INTO wer_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Pël ëak wiap kan kaalak së itaangkën munt narö ka tomök tauwal yaëën pitta koirak epël mëak pëël mëëa. ‘Ar tol ëënak kët ël epöök ya namëngkën wisën eprek wakaim?’ ");
INSERT INTO wer_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Pël maan pit epël mëëa. ‘Ten omën nampök ya ngön nent neniaan.’ Maan, ‘Arta nem yaak së ya mëmpunëën seë,’ pël mëëa. ");
INSERT INTO wer_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Koö yoolaan ya pepap pimënt së pim ya ngarangkëpön epël ök mëëa. ‘Ya omnaröen ngön maan waisën pitëm sumat man. Wet rëak ënëm waisa puorö pitëm sumat man. Pël ëak pitëm rakörö tapël tapël mampö së wetëërö ënëm man.’ ");
INSERT INTO wer_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Pël maan omën wiap kan oröak ya mëna pörö waisën 2 kina 2 kina mena. ");
INSERT INTO wer_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Pël ëak mampö yesën wet rëak ya mëna pörö pit sum isak öpnaat wesa pöt om 2 kina tapël mena. ");
INSERT INTO wer_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Pël ëën pitëm sum mena pötaan ya pepapön kaaö ngön mëak epël mëëa. ");
INSERT INTO wer_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Ënëm ya ngës rëaö eporö pit akun kot nent ya mëna. Ën ten kët ël epöök kët nga köpël ya mëneimaurö. Pël ëauröak tenim yaningkën tapël pit yemangkën. Pöten kaaö.’ ");
INSERT INTO wer_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Pël maan pi kangiir pitëm tekrakaan nampön epël mëëa. ‘Ngöntöp, ne niin utpet naalniin. Ne 2 kina nimpa pöten niaan ni kuure mak neeaup. ");
INSERT INTO wer_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Pötaanök nim sumet wak së. Nim yaningk tapël ënëm waisa eporöeta mampëak kön yawi. ");
INSERT INTO wer_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Sumat nemotöp nem kön wiaul naalmëëngan ma? Ni tol ëën nem kësangënten kön wiin utpet yaë?’” ");
INSERT INTO wer_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Watepang ngön pöt niak epël yenia. “Pöta ök ënëm Anutuu naë waisauröakaan selap wotöök moulmëëpnaat. Ën wet rëak waisauröakaan selap tapël ënëm moulmëëpnaat.” ");
INSERT INTO wer_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesuuk ten pim ru 12 pöröaring Yerusalem kakë yesem tenën pëën wesak epël niiaut. ");
INSERT INTO wer_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Kat wieë. Tiar peene Yerusalem kakë yewais. Pörek sëën Omën Këëp ne omnaröak kiri ar yaaö kaöaröere ngön kosangötë ngarangköröa naë neulëën pit ngön yaatak ne wel wiimëak neak ");
INSERT INTO wer_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ngönën köpëlöröa naë wes nemëën pitök ökre was neak pës nemöak këra yetaprak nemöön wel wiak akun nentepar nent won sëën kaalak wal ëëmaap.” ");
INSERT INTO wer_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Pël niaan Sepeti pim öngöpök pim yokot Semsre Son pöaar Yesuu naë wak së rar rë wesirak omën nentaan kimang yema. ");
INSERT INTO wer_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Pël ëën Yesuuk, “Ni oröptaan kent yaë?” pël maan epël yema. “Ënëmak nim omën poutë kaö sak ömë akunetak nem ru epaar, nim kopirarë, namp yaapkëël namp katnëël, wel aisëak wë niiring ngarangk ëëpnaan kosang wes mamëak yeniak.” ");
INSERT INTO wer_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Pël maan Yesuuk epël yema. “Arim yenëak pöta songönte ar köpël wë. Ne kelöntak i kakam yaaut yen pöl këlangön kësang kat wiimaap. Pöt arip pangk ëënëëwaar ma?” Pël maan piaripök, “Pangk ëënaawaar,” pël yema. ");
INSERT INTO wer_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Maan epël yema. “I kakam pöt pangk nënëët. Pël ëënëëtak nem kopirarë yaapkëëlaan katnëël wel aisapnaata ngönte nook naëngan. Nem Pepapök wel aisapënëak yaö mëëa pöröakëër wel aisapnaat.” ");
INSERT INTO wer_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Pël yemaan ten ru 10 pörö Sepeti pim ruaarëën mëëa pöt kat wiak ya sangën ëaut. ");
INSERT INTO wer_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Pël ëën Yesuuk tenën ngön niaan pim naë sëën epël niiaut. “Yang nantë omp akörö pitëm omnarö nga ëak ngarangk yaalmë. Pël yeem pitëm ikanöök ngarangk narö moulmëën pitta tapël omnarö ngarangk yaalmë. ");
INSERT INTO wer_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ar pël ëëngan. Arim naëaan namp kaö sak öpënëak pöt pi ar pouröa inëën elniip. ");
INSERT INTO wer_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ën namp wotöök sëpënëak pöt pi kot panë sak ar pouröa inëën panë elniip. ");
INSERT INTO wer_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Pi nem yeë epël ëëp. Omën Këëp ne omnaröak inëën elnëëpënëak newaisën. Nook arim inëën elniak omnarö utpetatë öngpökaan kama niömaan arim kangiir wel wiimëak waisaup.” ");
INSERT INTO wer_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ten Yeriko kakaan yesën omën kësang pan Yesuu ënëm waisa. ");
INSERT INTO wer_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Pël yaëën omën it il tëa naar kan ëöök wel aisëeë Yesuu yesa ngön pöt kat wiak ngön ëak epël yema. “Aköp, Tewitë ëap, Anutuu Yaö Niiaup, ni tenipön yaköm kön niwi.” ");
INSERT INTO wer_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Pël yemaan omnaröak leng ëëpën mëak nga yemaan piarip pöten kat nemowiin ke urak kaalak ngön ëak epël yema. “Aköp, ni Tewitë ëapök tenipön yaköm kön niwi.” ");
INSERT INTO wer_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Pël maan Yesu pi leng ëak kamtaöök taueë ngön maan waisën piaripön epël pëël yema. “Arip tol elniimëak yak?” ");
INSERT INTO wer_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Maan piaripök epël yema. “Aköp, ni aan tenip it nga sën.” ");
INSERT INTO wer_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Pël maan Yesuuk piaripön yaköm ëën pim moresiar piarpim itöörarë rangk mowiin tapëtakëër ompyaö sak Yesuu ënëm saut. ");
INSERT INTO wer_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ten Yesuring Yerusalem kak temanöm yesem Petepasi ka Olip tomök wieëa pöök oröak Yesuuk pim ru naar epël mëak wes yamë. ");
INSERT INTO wer_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Arip ka ëngköök së oröak itaangkën pol tongki ruupring namp këraamentëk wii ngan ë ulmëën öpnaat. Pipaar tapëtakëër wilak mësak waisën. ");
INSERT INTO wer_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Pël yaëën omën nampök pëël yeniaan pöt epël man. ‘Aköpök epaarën ya.’ Pël maan kat wiak tapëtakëër pëël niaan mësak waisënëët.” ");
INSERT INTO wer_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Pël yaëën tektek ngön yaaö nampë ngaan ngön ök ëa nent kë oröa. Ngön pöt epët. ");
INSERT INTO wer_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Omën Saion kak wëauröen epël man. ‘Kat wieë. Arim omën omp aköp arim naë yewais. Pi pimtën kön wiin nawis, ya wiapring pol tongkiipë rangk yewais. Yaap, pi pol tongki ruupë rangk wel aisëak yewais.’” ");
INSERT INTO wer_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Maan ru pöaar së Yesu pim ök mëëa pöl ëa. ");
INSERT INTO wer_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Piarip pol tongkiipre ruup mësak wais piarpim ulpëën rangköt përëak pol tongkiipë rangk mourön Yesu rangk wel aisëa. ");
INSERT INTO wer_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Pël ëak kan yesën omën kësang pan pitëm ulpëën rangköt përëak kamtaöök mourö yesën naröak ya lupöök së kewisat ilak këëmre kewis elmë yes. ");
INSERT INTO wer_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Pël ëak omën wet rëak yesauröere ënëm yesa pourö ërëpsawi yeem ngön ëak epël yema. “Tewitë ëap, yowe. Aköpë këm ngöntak yewais epopön yaya mepa. Anutu ngaarëk wëaup, yowe.” ");
INSERT INTO wer_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Pël ë së Yerusalem kak yaaröön pörek wëaurö yaan sak epël yema. “E, pipop talëp?” ");
INSERT INTO wer_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Pël yemaan omën Yesuring yesauröak epël yema. “Epop tektek ngön yaaö omnamp, Yesu, Kalili yangerak Nasaret kakaanëp.” ");
INSERT INTO wer_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu pi Anutuu ngönën tup kaöeta kakaati së itaangkën omnarö omnant ngawi yeem wëën itenak pit waö ë momëak omën mon ngawingawi yaauröa urötere omën int ekörö menak sum yewauröa uröt kaip ti yemoola. ");
INSERT INTO wer_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Pël ëak pitën epël yema. “Ngönën pepeweri Anutuuk epël ëa. ‘Nem tup pipten omnaröak kimang yenëa kaat pël apnaat.’ Ar pipël yaëën këkain yaauröa kaata ök yes.” ");
INSERT INTO wer_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Omën it il tëaare ing il tëaurö pim naë waisën ngönën tup kaöetak ompyaö mowesaut. ");
INSERT INTO wer_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Pël yaëën kiri ar yaaö kaöaröere ngön kosangötë ngarangköröak pim ya retëngöt mëmpööre rungaaröak piin, “Tewitë ëap, yowe,” pël maö yaauten itenak pit ya sangën ëën ");
INSERT INTO wer_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","piin epël yema. “Ni pitëm yenia pöten kat wian ma?” Maan Yesuuk epël yema. “Mak, ne yok kat wia. Pël ëaap ngön nent ngönëntak wia pöt ar sangk kelak kat nawiin yaaurö ma? Pöt epël. ‘Ni runga kotre kapaatakörö kengkën mowasën pitëm këmötëaan ompyaö wesak yaya yenia.’” ");
INSERT INTO wer_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Pël mëak pit sëp mowesak Yerusalem kakaan oröak Petani kak së wë koö olaan ka uraut. ");
INSERT INTO wer_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Wangam kanök ka kaöaöökël kaalak yesem këën ëa. ");
INSERT INTO wer_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Pël ëën këra kem kan ëöök wëa nementën itaangkën ulöpörö nautön, om ëpöt pëën wëa. Pël ëën pömentën epël yema. “Ni kaalak ulöp utnganok.” Pël maan kem pöment tapëtakëër saap wak umön yarë. ");
INSERT INTO wer_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Pël yaëën ten pim ruurö pöten itenak yaan sak epël mëëaut. “Kem epment tol ëak teëntom umön yera?” ");
INSERT INTO wer_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Pël maan Yesuuk epël yenia. “Ne yaap niamaan. Ar kön selap ëak yok pangk pël ëëpën ma won pël kön nawiin, kön wi kosang wasënë pöt arökta nem kemmentën maan yaë epël ëënëët. Pöt pëën won. Tomön epöönta, ‘Ni tiak i kaöökël së orö,’ pël maan pangk pël ëëpnaat. ");
INSERT INTO wer_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ar kön wi kosang yewesautaring wë Anutuun nem yapintakël omën nenten kimang manë pöt nimpnaat.” ");
INSERT INTO wer_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu pi kaalak ngönën tup kaöetak së ilëak omnaröen ngönën ök maim wëën kiri ar yaaö kaöaröere ngarangkörö pit pim naë wais epël mëak pëël yema. “Nim eprek ë yaën pipot talëpë këm ngöntak ëeimën? Talëpök pël ëëm niia?” ");
INSERT INTO wer_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Pël maan Yesuuk kangiir epël kaip ti mëëaut. “Nookta arën pëël niamaan. Ar këët ök neaan pöt ne talëpë këmtak omnant yeëan pöt ök niamaan. ");
INSERT INTO wer_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Sonë i mëeima pöt talëpök maan eima? Anutuuk ma pimtok kön wiak eima?” Pël maan pit neneren epël yema. “Tiar tol mapen? ‘Anutuuk,’ pël mepenaatep pi epël niepan. ‘Tol ëënak Sonë ngönten kön wi kosang newasën yeë?’ ");
INSERT INTO wer_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ën tiar ‘Sonök’ pël mepenaatep omën pouröak piin, ‘Tektek ngön yaaö namp,’ pël yaaurö yak utpet niwaspan. Pötaan kas yaë.” ");
INSERT INTO wer_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Pël mëak Yesuun kangiir epël yema. “Ten köpël.” Pël maan Yesuuk epël mëëaut. “Nem yeë epotta talëpök neaan yeë pöt ök neniangan.” ");
INSERT INTO wer_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Pël mëak Yesuuk ngön nent epël ök yema. “Ar kön tolël yawi? Omën namp pim yokot naar wëa. Pël ëën wetëëpë naë së epël mëëa. ‘Yokotup, ni peene së nem wain yaöök ya mën.’ ");
INSERT INTO wer_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Pël maan pi, ‘Won, ne pël naëngan,’ pël mëak wë ënëmak lup kaip tiak sa. ");
INSERT INTO wer_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Pël yaëën pepap pi pim yokot muntapë naë së tapël ök mëëa. Pël maan pi, ‘Mak, ne sumaap,’ pël mëak nasën ëa. ");
INSERT INTO wer_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ar kön tolël yawi? Yokot talëpök pepapë ngönte ngaarëk wa?” Pël maan pit, ‘Wetëëp,’ maan Yesuuk epël yema. “Ne yaap niamaan. Takis yewaö utpetere öng omp nga yaaö utpet ke pilöröak ar il niwesak Anutuu wa ngaöök yamëautak ilapnaat. ");
INSERT INTO wer_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Pöt Son pi wotpil yaauta kanö pet elniipënëak yewaisën ar pim ngönten kön wi kosang newasën yaëën takis yewaö utpetaröere öng omp nga yaauröakëër pim ngönten kön wi kosang wesa. Pit pël yaëën ar itenakök lup kaip tiak tapël naën ëan.” ");
INSERT INTO wer_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Ne watepang ngön munt nent niamaan kat wieë. Omën kaö namp wain ya newer ngëntak ëm ök rëak wain ulöpörö wamp olapna yang öngöpö tëak ngarangk ëëpna ka wali nent ök rëa. Pël ëak ya omnarö ngarangk moulmëak pimënt yang wali nerek së wakaima. ");
INSERT INTO wer_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Wë köp yesa akunet temanöm sëën tööpënëak inëën narö wes mëën sa. ");
INSERT INTO wer_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Së oröön ngarangk moulmëaurö pit inëën namp pës möa, namp mën wel wia, namp kël mö wel wia. ");
INSERT INTO wer_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Pël ëën ya pepapök inëën munt narö kësang wes mëën së oröön tapël elmëa. ");
INSERT INTO wer_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Pël ëën ënëmak pimtë ru panëëpön, ‘Pit nem ruupë ngönte kat wiak ngaarëk öpnaat,’ pël weseë wes momëën sa. ");
INSERT INTO wer_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pël ëën ngarangkörö piin itenak pitëmënt neneren epël mëëa. ‘Omën epop pim pepapë mor kolut pout öpnaap. Pötaanök tiar mëmpa. Pël ëën yaat tiarimëën sëpnaan.’ ");
INSERT INTO wer_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Pël mëak wain yaaweriaan wa wilëngkëël olëak mëna.” ");
INSERT INTO wer_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yesuuk ngön pöt mëak epël pëël yema. “Ënëmak wain ya pepap wais ngarangkörö tol elmëëpën?” ");
INSERT INTO wer_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Pël maan pitök epël yema. “Pi yaap omën utpet pörö mënak utpet wesak ngarangk munt köp yesa akunatë ulöpörö pi mampna pörö wain yaaweri moulmëëpnaat.” ");
INSERT INTO wer_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Pël mëak Yesuuk kaalak pitën epël yema. “Ngönën pepeweri epël wia pöt ar sangk kelak kat nawiin yaaurö ma? ‘Wap omën ka ök yarëauröa wël ë moolëaut Anutuuk ompyaut wesak möör wap wes yewesir. Anutu pimtok pël yaalmëën ten itaangkën ompyaö panë yaë.’ ");
INSERT INTO wer_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Pël wia pötaanök ne ök niamaan kat wieë. Anutuuk pim omën ompyaut ngaan ar nina pöt arim naëaan kama wak omën maimarö mangkën pit Anutuu könöökë ënëm ëën kë ompyaut pitëm wëwëetak orööpnaat. ");
INSERT INTO wer_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Omën namp wap epëtak soë urak kawi ngentiipnaap, pi koröp ilak utpet ëëpnaap. Ën wapëtak pim rangk ngentiipna pöt, omën pöp ilak unön ëak utpet panë sëpnaap.” ");
INSERT INTO wer_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Kiri ar yaaö kaöaröere Parisi omnarö pim watepang ngön pöt kat wiak pi pitëmël ko wesak ya pël wesak ");
INSERT INTO wer_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","wali öpënëak kön wia. Pël ëautak omën pouröak piin, “Tektek ngön yaaö omnamp,” pël yamëëa pötaan kas ëën sëp wesa. ");
INSERT INTO wer_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu pi kaalak omnaröen watepang ngöntak epël ök yema. ");
INSERT INTO wer_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Anutu pim omnarö wa ngaöök yamëaut omën omp ak nampë pim ruup öng mës mampënëak këëre imën kaö wa pötakël ök ëëmaan. ");
INSERT INTO wer_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Pi kaömpöt ar ëak kopëta wes pet irak pim inëën ruurö omën pim wet rëak ngön ök mëëauröa ngësë yas wes mëën sëën pit kat wiak waisëpnaaten kaaö ëa. ");
INSERT INTO wer_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Pël ëën pi kaalak inëën ru munt naröen epël mëak wes mëa. ‘Omën nem wet rëak ngön ök mëëauröen epël man. “Kaömpöt ar ëak kopëta wes wiak wë. Purimakaö kaöaröaring ru ompyauröeta möak omnant pout yok kopëta wes pet iraut. Pötaanök peene wais këëre imën yenem ërëpsawi ëëpa.” ’ ");
INSERT INTO wer_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pël maan pit së ök maan kat wiak pitëmotön sa. Namp pim yaakë sa. Namp pim uröm kaatakë sa. ");
INSERT INTO wer_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ën narö inëën ruurö wali wak utpet wesak mëna. ");
INSERT INTO wer_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Pël ëën omën omp aköp pi ya sangën ëën pim nga omnarö wes mëën omën pim inëën ruurö mënaurö mënak pitëm kaaö es kor mëën kot sa. ");
INSERT INTO wer_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Pël ëën pim inëën ru naröen kaalak epël ök mëëa. ‘Këëre imën pöt kopëta wes pet irautak omën nem wet rëak yas mëëauröak utpet ëa. ");
INSERT INTO wer_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Pötaanök ar kamtatë yesem omën koirënëërö pouröen wais këëre imën nëmpnaan ök man.’ ");
INSERT INTO wer_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Pël maan pim inëën ru pörö kamtatë yesem omën koirauröen ök maan ompyaöre utpet pourö së kaatak ilaan peö ëa. ");
INSERT INTO wer_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Omën omp aköp pi omën waisauröen itaampënëak kaata kakaati ilëak itaangkën omën namp wa top ke pötë ulpëën yamëaup namëën wëën itena. ");
INSERT INTO wer_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Pël ëak epël mëëa. ‘Ngöntöp, ni tol ëën wa top epta ulpëënëp won wais wel aisëaan? Ni pil yaëën pangk naën yaë.’ Pël maan ngön won sak wëa. ");
INSERT INTO wer_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Pël ëën omën omp aköpök pim inëën ruuröen epël mëëa. ‘Omën epop ingre morötë wii tëak koö panëëtak wa moolan. Pi pörek wë ingre ya ilak aimeë kë pötöppötöp aim öpnaan.’” ");
INSERT INTO wer_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yesu pi watepang ngön pöt më pet irak epël yema. “Ne yaap niamaan. Anutuu omën selap yas mëëauröakaan kopët naar waisën wël ë yaulmë.” ");
INSERT INTO wer_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Pël maan Parisi ngönën omnarö pit së wa top ëak ngön tol nentak Yesuun nga wiipën pël mëak kopëta wesa. ");
INSERT INTO wer_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Pël ëak pitök pitëm ru naröere Erotë omën narö wes mëën wais epël yema. “Rë yanuulaup, ten niin ëwat wë. Ni ngön wotpil yaaup, ngön ompyaö Anutuuk ök niiaut pëën omën pourö yaap wesak rë yanuulaup. Ni omën isaare irëaurö omnant mööngkraar kangk naalmëën yaaup. ");
INSERT INTO wer_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Pötaanök ni kön tolëël yawiin? Rom omën omp ak Sisa pöp takis mampen ma Anutu pimënt mampen?” ");
INSERT INTO wer_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Pël maan Yesuuk pitëm utpet mowasëpënëak yaauten iteneë epël mëëaut. “Kaar, omnarö ar tol ëënak morök yaalnë? ");
INSERT INTO wer_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mon kël nent wak wais neneë.” Pël maan pit nent wak wais yemangk. ");
INSERT INTO wer_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Pël ëën Yesuuk pitën epël mëak pëël yema. “Könre yapin epot talëpëët?” ");
INSERT INTO wer_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Pël maan pit epël yema. “Sisaëët.” Pël maan puuk epël yema. “Sisaën yaö ëa pipot Sisa mampun. Ën Anutuun yaö ëa pipot Anutu mampun.” ");
INSERT INTO wer_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Pël maan pit yaan sak sëp wesak saut. ");
INSERT INTO wer_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Kët pötak Satusi ngönën omën narö Yesuu naë waisa. Omën pörö weletakaan wal naëngan pël yaaurö. Pit wais Yesuun epël mëak pëël yema. ");
INSERT INTO wer_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Rë yanuulaup, Mosesök epël ëa. ‘Omën namp öng wak ru won wë wel wiin pöt pim nangapök kaalak öng pöp wak wë ru oröön pöt pim nanëpë yaö sëpnaat.’ ");
INSERT INTO wer_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Pël wiaap tenim naë omën nanang narö 7 ëak wakaima. Pël ëaurö nanëpök öng namp wak ru won wë wel wiin nangap öng kapirëp wa. ");
INSERT INTO wer_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Pël ëën pi tapël wel wiin nang muntap öng kapir pöp wa. Pël pël ë seim omën nanang 7 pörö öng kopët tapöp wak ru won wë wel wi won sa. ");
INSERT INTO wer_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Pël ëën ënëmak pitëm öng kapirëpta tapël wel wia. ");
INSERT INTO wer_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Pötaanök omën 7 piporö öng kopët tapöp wauröep wë wal ëëpena akunaöök ni kön wiin talëpë öng sëpën?” ");
INSERT INTO wer_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Pël maan Yesuuk pitën epël yema. “Ar ngönënre Anutuu weëre kosangöön ëngk ma e weseë irikor ngön yak. ");
INSERT INTO wer_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Wal ëënë akunaöök ar omnarö öngre omp naëngan. Kutöm enselöröa ök tek önëërö. ");
INSERT INTO wer_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ën weletakaan wal yaaö pöt ngönëntak Anutuuk epël ëa pöt sangk kelak kat nawiin yaaurö ma? ");
INSERT INTO wer_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ne Apramre Aisakre Yakop pitëm Anutu.’ Ngön pöta songönte epët. Omën pörö wel wiaurö öp sak kutömweri wë. Pötaanök Anutu pi wel wiauröaap won, öp wëauröa Anutu.” ");
INSERT INTO wer_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Pël maan kat wiak pim ngönëntaan yaan sa. ");
INSERT INTO wer_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Yesu pi ngön pöt ök maan Satusi omnarö ngön won sa. Pël ëën Parisi omnaröak pöten kat wiak pit pimëën ngön nent kopëta wasëpënëak wa top ëa. ");
INSERT INTO wer_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Pël ëak pitëm naëaan ngön kosangötë ngarangk nampök piin morök elmëak epël pëël yema. ");
INSERT INTO wer_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Rë yanuulaup, Anutuu ngön kosang tal nentak kaöet?” ");
INSERT INTO wer_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Pël maan epël yema. “Anutu pi nim Aköp. Ni piin lup sant elmëak nim lupre könre kön yawia pipot pout pimëën pëël elmëëm. ");
INSERT INTO wer_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Pipët Anutuu ngön kosangötë kaöet, muntat il yewas. ");
INSERT INTO wer_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Pël ëak pöta kar nenteta wia. Pöt epël. Nimtëën lup sant yaën tapël nim karipön elmëëm. ");
INSERT INTO wer_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ngön pipteparök Mosesre tektek ngön yaauröa ngön kosangöt erën ëak wia.” ");
INSERT INTO wer_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Parisi omnarö wa top ëak wëën Yesuuk pitën epël mëak pëël yema. ");
INSERT INTO wer_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ar Kristo, Anutuu Yaö Mëëaupön talëp aim? Pi talëpë ëap?” Maan pitök, “Tewitë ëap,” pël yema. ");
INSERT INTO wer_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Pël maan Yesuuk epël yema. “Yak tol ëënak Ngëëngk Pulöök Tewitën elmëën Kristoon, ‘Nem Aköp’ pël mëëa? Pöt epël. ");
INSERT INTO wer_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Anutu puuk nem Aköpön epël yema. “Ni wais nem yaapkëëtakël öm. Pël ëaan nimëën kööre tok yaaö piporö nook nim weëre kosangöökë karök moulmëëmaat.” ’ ");
INSERT INTO wer_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Tewitök piin, ‘Nem Aköp’ pël mëëaupök tol ëënak Tewitë ëap pël yaë?” ");
INSERT INTO wer_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Pël maan pit ngön pöta kangit mapnaat pangk naën ëën akun pötak ngës rëak pëël muntat mapnaaten kas ëën sëp yewas. ");
INSERT INTO wer_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Akun pötak Yesuuk ten pim ruuröere omnaröen epël ök niiaut. ");
INSERT INTO wer_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Ngön kosangötë ngarangköröere Parisi ngönën omnarö pit Mosesë urötak wë ngön kosangöt rë yanuul. ");
INSERT INTO wer_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Pötaanök pitëm ök yenia pöt kat wiak ngaarëk ön. Ën pitëm wëwë wë pötak öngan. Pit rë yanuulem pitëmënt ngaarëk naön yaë pötaanök. ");
INSERT INTO wer_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Pit ngön kosang nantta ar ngaarëk önëak pitëm könöökaan rangk ök niaan ar ngaarëk önëak poprak yaëën pitëmënt kaamök kot nent naën yaë. ");
INSERT INTO wer_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Pitëm omnant yaaut omnaröak itaangkën ompyaö ëëpnaataan yaaurö. Pit ngön kosang lup nant retëng ëak kör koëak kepön upakötë wii ngan ë utööre moresi tapël ë, ën pitëm ulpëënöröa kautë poë koröp sëtöt ngan ë më pël ëak yaaurö. ");
INSERT INTO wer_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Pit këëre imën yena akunatë itëkëël kaöaröa urötë wel aisapnaaten kent yeem ngönën tupötë kakaatiita omnaröa itëkëël wel yaisëaurö. ");
INSERT INTO wer_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Pël yeem omnaröak wa topöök koirak ërëpsawi ngön maöre ‘Rë yanuulaup,’ maö pël ëëpnaaten kent yaaurö. ");
INSERT INTO wer_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ar pöt omnaröak arën, ‘Rë yanuulaup,’ pël niapnaaten kent ëënganok. Ar ke kopëtalörö, Anutu kopëtap arim Rë Yanuulaup. ");
INSERT INTO wer_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Yang omën nampön, ‘Pep,’ manganok. Arim Pep kopëtap kutömweri wë. ");
INSERT INTO wer_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Omnaröak arën, ‘Wotöököp,’ pël niapnaaten kent ëënganok. Arim wotöök kopëtap Kristo nemënt. ");
INSERT INTO wer_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Arimëën kaö sak wëaupök ar pouröa inëën elniip. ");
INSERT INTO wer_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Omën namp pimtok pimtën kön wiin isëpna pöp Anutuuk wak irapnaap. Ën namp pimtën kön wiin irapna pöp Anutuuk wak isak mapnaap.” ");
INSERT INTO wer_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Elei, ngön kosangötë ngarangkre Parisi ngönën omën kaarörö. Arim naë könöm nant orööpnaat. Ar omnarö Anutuu wa ngaöök yamëautak ilapënëak yaëën kan yemowariem arimëntta neilaan yaaurö. ");
INSERT INTO wer_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Elei, ngön kosangötë ngarangkre Parisi omën kaarörö. Ar öng kapiröröa omnant pout arimëën weimeë morök elmëak omnaröak arën kön wiin isëpënëak Anutuun kimang wali yamëëaurö. Ar kangiir akunetak könöm kësangöt koirënëët. ");
INSERT INTO wer_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Elei, ngön kosangötë ngarangkre Parisi ngönën omën kaarörö. Arim naë könöm nant orööpnaat. Ar omën namp pim ngönënte sëp wesak arim ngönënta ënëm ëëpënëak i kaöök olëak yang kaö poutë yesaurö. Pël yeem arim utpet yaaut pet elmëën pi ënëm panë ëak ar il niwesak arim es parëaöökë sënë pöl piita teëntom së orööpnaat. ");
INSERT INTO wer_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Elei, wotöök it il tëaurö, ar Anutuu kanö omnaröen pet yaalmëem arimënt kan pöök nasën yaaurö. Arim naë könöm nant orööpnaat. Ar omnaröen ngön kaar epël yamëëaurö. ‘Omën namp ngön nent kosang wasëpënëak Anutuu ngönën tup kaöetakël utak kosang wasën pöt mos ëëpnaat. Ën namp aini kool ngönën tup kaöeta kakaati ë rangia pötëël utak kosang wasën pöt kë ëëpnaat.’ ");
INSERT INTO wer_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","It il tëa kaökaurö aë! Tol nentak kaöet? Ngönën tup kaöetak këët ma aini kool kakaati ë rangia pötök këët? Anutuu ngönën tuptakëër kaöet. ");
INSERT INTO wer_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ar tapël ngön kaar epël yamëëaurö’ ‘Omën namp ngön nent kosang wasëpënëak ur Anutuun kiri yawiautakël utak kosang wasën pöt mos ëëpnaat. Ën namp urta rangk kiri wiautëël utak kosang wasën pöt kë ëëpnaat.’ ");
INSERT INTO wer_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","It il tëa kaökaurö aë! Tol nentak kaöet? Ur Anutuun kiri yawiautak këët ma urta rangk kiri wiautak këët? Urtakëër kaöet. ");
INSERT INTO wer_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Pël yaë pötaanök omën namp urtakël utak kosang wesak yemaan pöt urötere kiri wiaut pouteparëël utak kosang wesak yema. ");
INSERT INTO wer_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ën namp Anutuu ngönën tup kaöetakël utak kosang wesak yemaan pöt ngönën tupëtere tuptak wëaupököl utak kosang wesak yema. ");
INSERT INTO wer_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ën tapël namp kutömweriil utak kosang wesak yemaan pöt Anutuu ur kësangëtere pötak wel aisëaupököl utak kosang wesak yema. ");
INSERT INTO wer_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Elei, ngön kosangötë ngarangkre Parisi omën kaarörö. Arim naë könöm nant orööpnaat. Ar ëwamre kaëkoöre këënre pöt wa top ëak moresiar wesak kom ëak kopët nent Anutuun yaö yaalmë. Ar omën pas pöt yeemak nokoliil wotpil mëmpööre yaköm ëak ompyaö elmëëre Anutuun kön wi kosang wasö ngön kosang kaö pipot ngaarëk naön yeë. Poutepar ëënë pötaar ompyaö. ");
INSERT INTO wer_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Wotöök it il tëaurö, ar Anutuu kanö omnarö pet yaalmëem arimënt kan pöök nasën yaaurö. Omën namp iiste nëmpënëak yaëën iwal namp ilaan pöt nanëmpan, lë olapnaat. Pël ëëpnaatak pol kamal kësangëp ilaan iistaring köntak nëmpnaat. Tapël ar Anutuu ngön kosangötë ënëm ëënëak kot panë nantë ënëm yeem kaöat sëp yewas. ");
INSERT INTO wer_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Elei, ngön kosangötë ngarangkre Parisi omën kaarörö. Arim naë könöm nant orööpnaat. Ar kelönre söwaröt kasngaëël pëën i yairem öngpök i nairën ëën kewil wia pöl ar koröpöök ompyaö wasën arim lupötë pöt kainre koröpöökë kentöökë ënëm yaaö pöt peö ëak wë. ");
INSERT INTO wer_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Parisi omën it il tëaup ni! Wet rëak kelönre söwarötë öngpök iirën kewil won sëpna pöt kasngaëëlta won wiaapnaat. ");
INSERT INTO wer_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Elei, ngön kosangötë ngarangkre Parisi omën kaarörö. Arim naë könöm nant orööpnaat. Ar omën yangaöökë ökörö. Tomök pöt omnaröak ë rangiin itaangkën ompyaö yaë. Ën öngpök pöt omën kosere söp kampöt wia. ");
INSERT INTO wer_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ar tapël arim koröpöök omnaröa ëöetak wotpil koröp oröak wëën arim lupötë pöt kaar yaaöre utpet yaaut wia.” ");
INSERT INTO wer_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Elei, ngön kosangötë ngarangkre Parisi omën kaarörö. Arim naë könöm nant orööpnaat. Ar tektek ngön yaaö omën ngaanëër wel wiauröa yangaö wa ngolöp weseim wë. Pël yeem wotpil wakaimauröa yangaö ë morangieim wë. ");
INSERT INTO wer_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Pël yeem ar epël aim. ‘Tenim ëaröa wakaimauuk wakaimanëën pit kaamök ëak tektek ngön yaaö omnarö namëngkën ëan tapön.’ ");
INSERT INTO wer_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Arim ngön yak piptak ar omën tektek ngön yaaö omnarö mëneimauröa ëarö pöt tekeri yewas. ");
INSERT INTO wer_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Arim ëaröa mëneima kaut wia pöt arök mën pet irën. ");
INSERT INTO wer_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Kamal ëlre ruuröa ök utpetarö, arim saunatë kangiir es parëaöök sënë akun temanöm yesën kas tarëk së ëlëëp ilan? Pangk pël naëngan. ");
INSERT INTO wer_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Pötaanök ne niamaan kat wieë. Ne tektek ngön yaaö omnaröere ngön ompyaut ëwatöröere ngön ompyaö pöt rë nuulöpnaarö arim naë wes nimëëmaat. Pël ëën arök narö mëmpööre këra yetaprak mö pël ëënëët, narö arim ngönën tupötë pës momöak ka nantëaan nantë waö ë momëënëët. ");
INSERT INTO wer_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Pël ëënë pötak Anutuu omën wotpilörö mënan pöta kangut arim naë orööpnaat. Ngaanëër arim ë nampök ngës rëak Apel mënak mëmpö mëmpö ë wais Sekaraia, Perekaiaë ruup, Anutuu ngönën tup kaöetak kiri yawiautere ngëëngk panë tupta ngeröök mënaut. ");
INSERT INTO wer_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ne yaap niamaan. Omën mënauröa kangut ar peene e wë epöröa naë orööpnaat.” ");
INSERT INTO wer_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Yesuuk kaalak epël ök yema. “O Yerusalem omnarö, Yerusalem omnarö, yaköm. Ar tektek ngön yaaö omnarö mëmpööre ngönën omën arim naë wes nimëaurö kël mö wel wi pël yaaurö. Ne kët ël epotë kokor ëlëpë ruurö wereweriarë öngpök wa mëak ngarangk yaalmë pöl ar wa rongan ëak ngarangk elniimëak kent kön wiak pël yaalniin ar kaaö elnëeimaurö. ");
INSERT INTO wer_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Pötaanök ne sëp niwasën ar ngarangk won önëët. ");
INSERT INTO wer_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Yaap, ne epël niamaan. Ar neen itnaangkën wakaim akun kaöaöök neen kaalak itenak epël neanëët. ‘Aköpök wes mëën yewais epopön yaya mepa.’” ");
INSERT INTO wer_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu pi ngön pöt ök më pet irak Anutu pim ngönën tup kaöetakaan oröak yesën ten pim ruurö naë së ka yal menmen ë seëautön sös mëak pet elmëaut. ");
INSERT INTO wer_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Pël ëën epël niiaut. “Ne yaap niamaan. Omën ompyaö e wiaan ityaangk epot epël wi naöpan. Ënëmak ngaaröak wais tup epët tööl olaan kël naö naöökë rangk wi naöpan, utpet panë sëpnaat.” ");
INSERT INTO wer_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Pël niak Yesu pi Olip tomök së wel aisëaan pim ruurö tenimënt naë së epël mëak pëël mëëaut. “Nim ngönën tupët tööl komun ëëpnaat aan pöt taan pël ëëpën? Ën nim kaalak waisën akun pet irëpna pöt temanöm yesën oröpöt oröön ten itenak ëwat sën?” ");
INSERT INTO wer_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Pël maan Yesuuk tenën epël niiaut. “Ar omnaröak lup wa irikor elniipanëën këëkë ngarangk ëën. ");
INSERT INTO wer_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Naröak wais nem yapintakël, ‘Ne Kristo,’ pël niak omën selap pitëm lup wa irikor elmëëpnaat. ");
INSERT INTO wer_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ar nga yapinte kat wiak ngarangk ëeë. Kas ëëngan. Akun kaöaö ngolöp yaëën omën pipot wet rëak orööpnaat. ");
INSERT INTO wer_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Omën kur nementëkaanöröak kur nementekël nga ëëpnaat. Ën yang omp ak nampë omnaröak munt nampë omnaröaan nga ëëpnaat. Pël yaëën yang nantë kaömp ngöntök oröeim wëën moup selap mööpnaat. ");
INSERT INTO wer_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Omën pipot om öng namp ru wilëpënëak lel yailën këlangön kat yawi pöta ök ëëpnaat. ");
INSERT INTO wer_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Akun pötak omnaröak ar wali nuwak naröa naë nuulëën këlangön kat niwiak nimpënaat. Ën yang poutë omnaröak ar nemorö pël weseë arën kööre tok elniipnaat. ");
INSERT INTO wer_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Omën pöt yaaröön omën selap pitëm kön wi kosang yewesaut sëp wesak pitëm karuröen kup mowiin neneraan kööre tok ëëpnaat. ");
INSERT INTO wer_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Pël yaëën tektek ngön yaaö kaar omën narö selap oröak omën kësang morök elmëën pitëm kaarötë ënëm sëpnaat. ");
INSERT INTO wer_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Pël ëën utpet yaautök ulöl sëën omën selap pitëm lup sant yaaut won sëpnaat. ");
INSERT INTO wer_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ën omën weë sak wakaim wel wiipna pöp Anutuuk kama öpnaap. ");
INSERT INTO wer_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Pël ëën Anutuuk wa ngaöök yanimë pöta ngön ompyaö epët nem omnaröak yang poutë omnaröen ök maan kat wi pet yairën akunet pet irëpnaat.” ");
INSERT INTO wer_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Ënëmak omën utpet panëët omnant utpet yewesaut Anutuu ngëëngk tuptak wiaan itaampunëët. Omën pöt tektek ngön yaaö namp Taniel puuk orööpënëak ëaut.” (Ar ngön epët sangk kelënëërö pöten këëkë kön wiaan.) ");
INSERT INTO wer_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Pël yaëën Yutia yangerak wëaurö kas rosiraöökël sën. ");
INSERT INTO wer_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ka tomök öpnaapök kaata kakaati së omnant öpan. ");
INSERT INTO wer_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ën yaak öpnaapta kak së ulpëënre omnant öpan. ");
INSERT INTO wer_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Elei, akun pötak ru kepringre ru kapa yemenaurö tol ëëpën? ");
INSERT INTO wer_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ar omën kas yaaö pipot kopi akunetakre Anutuu kë yesa ngëëngk akunetak orööpanëën Anutuun kimang man. Akun pötë ar yok pangk kas nasëngan pötaanök. ");
INSERT INTO wer_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Akun pötak këlangön kaö panë kat wiipnaat. Ke pil nent kutömre yang oröaurekaan yewaisem e wë eptak naaröön ëaut. Ënëmeta naaröön ëëpnaat. ");
INSERT INTO wer_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Anutu pi akun pöt mënt wasëpënëak kön wia. Pi pël naën ëa talte omën pourö kö sën. Omën pim yaö wesauröaan akun pipët mënt wasëpnaat. ");
INSERT INTO wer_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","24","“Akun pötak kaar omën selap oröak naröak pitëmtën, ‘Ne Kristo,’ pël yaan naröak, ‘Ne tektek ngön yaaö omnamp,’ pël niapnaat. Pit omnarö morök elniin pitëm ënëm ëënëak retëng weëre kosangringöt ëëpnaat. Yaap, pit omën Anutuu yaö wesauröeta morök elniak pël ëëpnaat. Pötaanök nampök, ‘Kristo e oröak wë,’ pël yeniaan nampök, ‘Kristo ëngkrek oröak wë,’ pël yeniaan pöt kat mowiinganok. ");
INSERT INTO wer_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ne omën pöt naaröön wiaan ök yeniak. Pötaanök ënëmak yaaröön ëngk ma e wasnganok. ");
INSERT INTO wer_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ënëmak naröak, ‘Kristo yang omën wonrek yaaröön itenaut,’ pël niaan pöt sëngan. Ën naröak, ‘Kristo ka eptak ëlëëp wë,’ pël niaan pöteta kat wiingan. ");
INSERT INTO wer_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Omën Këëp ne kent tangarta yamëngk pöl ëëmaap. Kent tangarët kopëter tar elmëën këtëpë yengampiaulaan yeilëaul poutë ëwa ë pet yair. Pipta ök Omën Këëp nem waisuma akunetak tekeri yesën omën pourö neen itaampun sa. ");
INSERT INTO wer_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Omnantë söp kampaöök wer moön tuparö wa top yaë. Pöta ök ënëmak ne wais utpet yaaurö kangut mempaat.” ");
INSERT INTO wer_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Akun pötak omnarö këlangön kat wi pet yairën këtëp röök ulöpnaat. Pël ëën ngoonöpta ngaap yesën ariat kutömweriaan tiak yengentiin kutömweri omën weëre kosangringöt këlok sëpnaat. ");
INSERT INTO wer_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Pël ëën Omën Këëp nem tekeri suma retëng kësang nent kutömweri yaaröön yang omën pourö itenak kas ëak merek apnaat. Pël yaëën ne weëre kosangre iere kasir nemotring kutöm kepilötë rangk yaaröön itaampnaat. ");
INSERT INTO wer_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Pël ëën Anutuuk kuup kaö yamëngkën nem enselörö wes mëën së nem omën yaö wesaurö yang we naöökaan naöök, oorekaan öngkrek yang poutëaan koirëpnaat.” ");
INSERT INTO wer_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Ar këra wasmentë yaë pöten kön wieë. Këra pöment ëp kërë sak wil yewatën itenak pöt kopi akunet temanöm yes pël yewas. ");
INSERT INTO wer_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Pöta ök omën yeniak epot yaaröön itenak pöt, ‘Pim waisëpna akunet temanöm sëën waisëpënëak yaë,’ pël wasënëët. ");
INSERT INTO wer_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ne yaap niamaan. Omën e wë epörö wel wi won nasën wiaan omën yeniak epot orööpnaat. ");
INSERT INTO wer_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kutömre yang eptepar won sëpnaatepar. Ën nem ngön epët won nasëpan.” ");
INSERT INTO wer_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Omnarö ar omën pötë orööpna akun kë panëëten ëwat naön. Ën ensel kutömweri wëauröere Anutuu Ruup neenta ëwat naön. Pep pimtokëër ëwat wë. ");
INSERT INTO wer_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Noaë akunetak omnaröa ëa pöl Omën Këëp nem waisuma akunetak tapël ëëpnaat. ");
INSERT INTO wer_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","I ngaampel naaröön wiaan pit iire kaömp në, öngre omp ë pël ëeim Anutu kasëng menak wëën Noa wangaöök ilëa. ");
INSERT INTO wer_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Pël yaëën pit köpël wëën i ngaampel oröön omën pourö i nak won sa. Pöta ök Omën Këëp nem waisumaatak omnarö köpël wë pitëm omnant yaaut ëeim wëën waisumaap. ");
INSERT INTO wer_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Akun pötak omp naar ya lupöök wëën namp yeweem namp sëp wasumaap. ");
INSERT INTO wer_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ën öng naarta kaömp koröp yokoëëm wëën namp yeweem namp sëp wasumaap. ");
INSERT INTO wer_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ar Aköp nem waisuma akuneten köpël wë. Pötaanök ngaire wa kom ëeim ön. ");
INSERT INTO wer_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ar epël kön wieë. Ka pepap pi kainëpë rö kan waisëpna akuneten ëwat wëanëën itit wë ngarangk ëën kainëp kaat pör menak neilaan ëan tapön. ");
INSERT INTO wer_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Omën Këëp nem waisuma akunetak ar kön nenewiin wëën pipël ëëm sa. Pötaanök ko ëak ön.” ");
INSERT INTO wer_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Ar inëën ru ompyaupë ök sën. Inëën ru namp kön ompyaö wieë ya ompyaö yamëngkën kaöapök muntarö ngarangk ëeë akunatë kaömp mampënëak moulmëak sa. ");
INSERT INTO wer_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ënëmak inëën ruup kaöapë ök mëak sa pöl ëeim wëën kaöap wais itaangkën pöt pi ërëpsawi ëëpnaat. ");
INSERT INTO wer_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ne yaap niamaan. Kaöap pi pim omnant pout ngarangk ëëpënëak moulmëëpnaat. ");
INSERT INTO wer_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ën inëën ru utpet pöp pi, ‘Nem kaöap pi teënt newaispan,’ pël weseë ");
INSERT INTO wer_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","inëën ru pim karurö tang mööre omën i ngaat nak kön irikor yaauröaring kaömpre i ngawi në pël eim wë ");
INSERT INTO wer_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","pim kaöapë waisëpna akuneten kön nawiin öpna pötak kaöap kaalak waisëpna pöt ");
INSERT INTO wer_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","pi yokot pöp möak utpet wesak kaar omnaröa naë moulmëëpnaat. Pörek omnarö ingre ya ilak aimeë kë pötöppötöp aim öpnaan.” ");
INSERT INTO wer_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Anutu pim omnarö wa ngaöök yamë pöt öng ulwas 10 pitëm karip omp koirëpna pöröakël ök ëëmaan. Ong pörö omp namp pim öng yaup koirëpënëak yewaisën pit neenem rampeet wak kan kourak koirëpënëak sa. ");
INSERT INTO wer_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Öng 5 ëak könringörö, 5 ëak wonörö. ");
INSERT INTO wer_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Öng kön won pörö pit i kön korat naön, rampeet pëën wak sa. ");
INSERT INTO wer_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ën könringöröakëër i kön korat rampeetring wak sa. ");
INSERT INTO wer_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Pël ëak së kor wëën omp öng koirëpnaap teënt newaisën ëën kor wë ka kom ëën ka ura. ");
INSERT INTO wer_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Pël ëën röök lupöök ngön nent ngön ëak epël mëëa. ‘E, öng koirëpnaap yewaisrek wal ëak së koireë.’ ");
INSERT INTO wer_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Pël maan pit yaan sak wal ëak rampeet mangia. ");
INSERT INTO wer_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Pël yeem kön wonöröak könringöröen epël mëëa. ‘Tenim rampeet yariirek i nant lë nineë.’ ");
INSERT INTO wer_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Maan könringöröak epël mëëa. ‘Tol ëak pël ëëpen? I epot tiar pourö pangk naalniipan. Arta uröm kaatak së arimot sum ëeë.’ ");
INSERT INTO wer_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Pël maan pit yesën omën öng koirëpnaap wais kopëta wesak kor wëaurö koirak sa. Pël ëak kak së oröak kaata kakaati së ilëak kan wari ulmëak öng koirëpnaapë këëre imën neim wëa. ");
INSERT INTO wer_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Pël ëeim wëën öng kön wonörö së ap wesak ngön ëak öng waupön epël mëëa. ‘Kan të niwi. Kan të niwi.’ ");
INSERT INTO wer_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Maan epël mëëa. ‘Yaap niamaan. Ne arën it köpël yaningëngk.’” ");
INSERT INTO wer_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yesu pi watepang ngön pöt niak kaalak tenën epël niiaut. “Nem kaalak waisuma akunet köpël. Pötaanök ngai ëeim ön.” ");
INSERT INTO wer_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Yesuuk kaalak watepang ngön munt nent epël niiaut. “Anutu pim omnarö wa ngaöök yamë pöt omën kaö nampë ëa pötakël ök ëëmaan. Pi yang wali nerakël sëpënëak pim inëën ruuröen yas mëak pim omnant ngarangk ëeim öpënëak kom ë mena. ");
INSERT INTO wer_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Pi pitëm ya yamëngkauten kön weswes ëeë kom ëak namp 5000 kina, namp 2000 kina, namp 1000 kina pël meank sa. ");
INSERT INTO wer_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Pël ëën inëën ru 5000 kina mena pöpök ya kosang mënak 5000 kina tapël koira. ");
INSERT INTO wer_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ën kar 2000 kina mena pöpök ya kosang mënak 2000 kina tapël koira. ");
INSERT INTO wer_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ën kar 1000 kina mena pöp pim kaöapë monat wak së yang kel weera. ");
INSERT INTO wer_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Akun wali sëën kaöap kaalak wais pim inëën ruurö mon mena pöt öpënëak wa rongan elmëa. ");
INSERT INTO wer_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Pël ëën mon 5000 kina mena pöpök naë wais epël mëëa. ‘Nem kaöap, ni mon 5000 kina nenaup. Pël ëën nook ya mënak 5000 kina tapël koiraut.’ ");
INSERT INTO wer_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Maan kaöapök epël ök mëëa. ‘Inëën ru ompyaup, ni ya ompyaö mënan. Ni omën pasut ngarangk ompyaö ëeiman. Pötaanök nook omën këëta ngarangk niulëëmaan. Neering wë ërëpsawi ëëpa.’ ");
INSERT INTO wer_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Pël yemaan inëën ru 2000 kina mena pöpökta tapël naë wais epël mëëa. ‘Kaöap, ni mon 2000 kina nenaup. Pël ëën nook ya mënak 2000 kina tapël koiraut.’ ");
INSERT INTO wer_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Maan kaöapök epël ök mëëa. ‘Inëën ru ompyaup, ni ya ompyaö mënan. Ni omën pasut ngarangk ompyaö ëeiman. Pötaanök nook omën këëta ngarangk niulëëmaan. Neering wë ërëpsawi ëëpa.’ ");
INSERT INTO wer_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Pël yemaan inëën ru 1000 kina mena pöpökta tapël naë wais epël mëëa. ‘Kaöap, ne nim songönte ëwat wë. Ni nga yaaup yak omnant omën muntaröak ngëntën yewetaup. Ni omnant nangëntën yeem omën naröa ngëntaurekaan këët wak yenaup. ");
INSERT INTO wer_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Pël yaaup yak kas ëën nim 1000 kina nenan pöt wak së yang kel weerak wakaimaut. Pötaanök nim monat kaalak yaningk. E.’ ");
INSERT INTO wer_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Pël maan kaöapök epël mëëa. ‘Inëën ru utpet wisënëp. Ne omnant omën muntaröak ngëntën watööre omnant nangëntën wë omën naröa ngëntaurekaan këët wa në pël yaaup pël kön wiaup ma? ");
INSERT INTO wer_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ni nem songönten pipël ëwat wëak tol ëënak nem monat mon kaatak nawiin ëaup? Pël ëanëën ne wais mon pöt kangitaring wan tapön.’ ");
INSERT INTO wer_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Pël mëak omën pörek wëauröen epël mëëa. ‘Ar mon 1000 kina epot piikaan wa ëp ëak mon 10,000 kina wa epop meneë. ");
INSERT INTO wer_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Namp pi omnant menaut ngarangk ëak wëën pöt muntat erën ëak mangkën ulöl wesak wak öpnaat. Ën namp pi menaut ngarangk naën wëën pöt wa ëp ëën om pas öpnaat. ");
INSERT INTO wer_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Inëën ru utpet epop wak koö panëëtak moolaë. Pël ëën pörek ingre ya ilak aimeë kë pötöppötöp aim öpnaan.’” ");
INSERT INTO wer_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Wë ënëmak Omën Këëp nem ëwaö wak nem enselöröaring waisumaatak kaö sak nem ur kësangtak wel aisëaam sa. ");
INSERT INTO wer_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Pël ëën yang omën pourö nem iri wa top ë nuulëën sëpsëp ngarangkëpök sëpsëpörö memeeröa naëaan kom yaë pöl ëën rongan nentepar ëëpnaat. ");
INSERT INTO wer_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Pël ëën omën ompyaö sëpsëpöröa ökörö nem yaapkëël, utpet memeeröa ökörö katnëël pël ë nuulëëmaat. ");
INSERT INTO wer_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Pël ëak Omp Ak kësangëp nook yaapkëël önëëröen epël ök niamaap. ‘Nem Pepapök ompyaö niwesaurö, ar wais pim wangaöök nimëëpënëak kutömre yang naaröön wiaan kopëta wes niwia pötak ilaë. ");
INSERT INTO wer_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ne këën wëën ar kaömp nenaurö. Iiten yaëën iit nenaurö. Maimerakaanëp sant elnëaurö. ");
INSERT INTO wer_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ulpëën won wëën nenaurö. Yauman yaëën ngarangk elnëaurö. Wii kaatak neulëën wëën wais ëö nenaurö.’ ");
INSERT INTO wer_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Pël niaan omën wotpilöröak neen epël neanëët. ‘Aköp, ni taan këën wëën itenak kaömp ninan? Ën taan iiten yaëën iit ninan? ");
INSERT INTO wer_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ma taan maimerakaanëp sant elnian? Ma taan ulpëën won wëën ninan? ");
INSERT INTO wer_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ën taan yauman yaëën ngarangk elnian? Ma taan wii kaatak wëën wais ëö ninan?’ ");
INSERT INTO wer_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Pël neaan nook epël ök niamaat. ‘Ne yaap niamaan. Ar nem kar pas eporö kaamök elmëan pöt neen elnëan pël yaë.’ ");
INSERT INTO wer_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Pël niak nem katnëël öpnaaröen epël ök memaat. ‘Anutuuk kemp elniaurö ar mop wiak es kosangwesi seë. Es pöwes Anutuuk ngaanëër Setenre pim enselöröaan merauwes. ");
INSERT INTO wer_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Pöt epël. Ne këën wëën ar kaömp nenangkën ëaurö. Iiten yaëën iit nenangkën ëaurö. ");
INSERT INTO wer_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Maimerakaanëp sant naalnëën ëaurö. Ulpëën won wëën nenangkën ëaurö. Yauman yaëën ngarangk naalnëën ëaurö. Wii kaatak neulëën wëën wais ëö nenangkën ëaurö.’ ");
INSERT INTO wer_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Pël maan pit neen epël ök neapnaat. ‘Aköp, ni taan këën wëëre iiten ë, maimerakaan waisööre ulpëën won wë, yauman ëëre wii kaatak wë, pël yaëën itenak kaamök naalniin ëan?’ ");
INSERT INTO wer_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Pël neaan pitën epël memaat. ‘Ne yaap niamaan. Ar nem kar pas eporö kaamök naalmëën ëan pöt neen elnëan pël yaë.’ ");
INSERT INTO wer_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Omën utpet pörö pit kö yesa kak së utpetat ëeim öpnaat. Ën wotpilörö wëwë kosangtak së önëët.” ");
INSERT INTO wer_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesuuk ngön pöt ni pet irak kaalak ten pim ruuröen epël ök niiaut. ");
INSERT INTO wer_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Ar ëwat wë. Kët nentepar won sëën Anutuu mait elmëa akunet temanöm sëpnaat. Akun pötak Omën Këëp ne omnaröak kööre toköröa moresi neulëën këra yetaprak nemööpnaat.” ");
INSERT INTO wer_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Akun pötak kiri ar yaaö kaöaröere ngarangkörö pit kiri ar yaaö wotöököp, Kaiapas, pim kaatak së wa top ëak ");
INSERT INTO wer_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Yesu ëlëëp wali wak mëmpnaata ngönte ëmön ëa. ");
INSERT INTO wer_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Pël yeem pit epël mëëa. “Omnarö tiarring nga elpanok akun kësangtak pël naëngan.” ");
INSERT INTO wer_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu ten pim ruuröaring Petani kak së oröak kësë omën namp Saimon pim kaatak së wëa. ");
INSERT INTO wer_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Pël ëën öng namp kël kep ompyaö nentak i köp nga kamp sum kësangring nent pim naë wak waisa. Pël ëak Yesu kaömp yenën i pöt pim kepönöök lë yemomë. ");
INSERT INTO wer_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Pël yaëën ten pim ruurö itenak öngöpön nga ngön epël ëaut. “Pi tol ëënak i sum kaöaring epët pas köntak lë yemomë? ");
INSERT INTO wer_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","I piptak mon kësang koirën omën omnant wonörö mangkën pangk ëëpnaatep.” ");
INSERT INTO wer_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Pël yaan Yesu pi tenim ngönten kön waswas ëeë epël niiaut. “Ar tol ëënak maan pi ya këlangön kön yawi? Pi neen ompyaö pan yaalnë. ");
INSERT INTO wer_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Omën omnant wonörö pit akun wali arring wëën ompyaö elmëënëak pöt yok pangk pël ëënëët. Ën ne pöt akun wali arring naön ëëmaap. Pötaanök pim ompyaö yaalnë epët yok pangk yaalnë. ");
INSERT INTO wer_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ne teënt wel wiin yang kel neweerëpnaap. Pötaanök Yuta omnaröa sokutë yaaul nem koröpöön kan yaö elmëak i nga kamp yaaut lë yenemë. ");
INSERT INTO wer_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ne yaap niamaan. Nem ngönte yang ël epotë aö yesem pöt öng epopë yaalnë epëta ngönte aan omnarö kat wiak kön wiipnaat.” ");
INSERT INTO wer_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Pël niaan ten ru 12 pöröakaan namp, yapinte Yutas Keriot kakaanëp, pi kiri ar yaaö kaöaröa naë së ");
INSERT INTO wer_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","epël ök mëëa. “Ne Yesu arim moresi niulëën pöt ar mon tolël ëak nampön?” Pël maan pit mon siluwa 30 pöt mena. ");
INSERT INTO wer_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Pël ëën akun pötak ngës rëak Yesuun kup mowiipënëak kan ap weseima. ");
INSERT INTO wer_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Kaömp peret yis namëënöt yena akun ngëëngkët temanöm sëën Yesuu ruurö ten pim naë së epël mëak pëël mëëaut. “Ka taltak Anutuu mait elmëa akunetak kaömp nëmpenaat ar ëak kopëta wasënëak kent kön yawiin?” ");
INSERT INTO wer_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Pël maan epël niiaut. “Ar Yerusalem kak së oröak omën nem yeniak pöp koirak epël man. ‘Rë yanuulaupök epël yenia. “Nem akun newiaut temanöm yes. Pötaanök Anutuu mait elmëa akunetak nem ruuröaring kaömp ngawi numaat.” ’” ");
INSERT INTO wer_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Pël niaan ten pim ök niia pöl ëak së Anutuu mait elmëa akunetak kaömp nënaat ar ëak kopëta wesaut. ");
INSERT INTO wer_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Koö olaan Yesu ten pim ruuröaring kakaati së kaömp yenautak wel aisëak wëa. ");
INSERT INTO wer_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Pël ëak Yesuuk tenën epël niiaut. “Ne yaap niamaan. Arim naëaan nampök nemëën kup mowiipnaat.” ");
INSERT INTO wer_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Pël niaan ten ya këlangön pan ëën pöppöp piin epël mëak pëël mëëaut. “Aköp, nook ma?” “Aköp, nook ma?” pël maö saut. ");
INSERT INTO wer_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Pël ëën puuk epël niiaut. “Neering kaömpöt iistak wariak yen epopök nemëën kup mowiipnaat. ");
INSERT INTO wer_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Omën Këëp ne ngönëntak nemëën ëa kan pöök së wel wiimaap. Ën nemëën kup mowiipna pöp, elei, kangut kësang pan öpnaap. Pim ëlëpök nawilën ëanëën ompyaö ëan tapön.” ");
INSERT INTO wer_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Pël maan kup mowiipnaap, Yutas Keriot kakaanëp, puukta tapël epël mëak pëël yema. “Aköp, nook ma?” Maan, “Ni tapöp,” pël yema. ");
INSERT INTO wer_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Pël mëak ten kaömp yenem Yesuuk kaömp nent wak Anutuun yowe mëak pel ninak epël yenia. “Epët nem mësëpëtak wa neë.” ");
INSERT INTO wer_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","28","Pël niak wain kelön nent wak Anutuun yowe mëak ten ninak epël yenia. “Epët nem iit. Il yoolaan Anutuuk omën selap pitëm saunat won yewasem pim sulöp ngolöpët taë yewas. Pötaanök ar pourö wak neë. ");
INSERT INTO wer_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ne niamaan kat wieë. Yangerak eprek wain iit peene nëën pet yair. Arring kaalak nanën wë ënëmak akun kaöaöök nem Pepapë naë wain i maim nent nëmpenen ëa.” ");
INSERT INTO wer_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ten kaömp na pet irak ngönën tan nent mëak kakaan oröak Olip tomökël saut. ");
INSERT INTO wer_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Kan kourak yesem Yesuuk tenën epël niiaut. “Röök eptak ar pourö ne sëp newesak kas sënëët. Arim pël ëënë pöt ngönëntak ngön nent epël wia. ‘Ne sëpsëp ngarangkëp mëngkën sëpsëpörö repak sëpnaat.’ ");
INSERT INTO wer_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ne yaap wel wiin weletekaan wal ë neulëën wet rëak Kalili yangerak së wëën ar ënëm waisënëët.” ");
INSERT INTO wer_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pël niaan Pitaak epël yema. “Eporö sëp niwesak kas sëpën koröp. Ne pöt, pël naëngan pan.” ");
INSERT INTO wer_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Pël maan Yesuuk epël yema. “Ne yaap niamaan kat wi. Ni röök eptak kokor ngön naën wiaan akun nentepar nent yak newasumëët.” ");
INSERT INTO wer_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pël maan Pitaak kaalak epël yema. “Nimënt yanimëngkem ne nempënëak yaan pöteta yak naniwasën ëëmaap.” Pël yemaan ten pourö tapël mëëaut. ");
INSERT INTO wer_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Pörekaan yesem yang lup nenta yapinte Kesemani pörek së oröak Yesuuk tenën epël yenia. “Ar eprek wëën ne ëngkrek së Anutuun kimang memaan.” ");
INSERT INTO wer_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Pël niak Pitaare Sepeti pim ruaar koirak saut. Yesem ngës rëak ya këlangön kön wiak ya ngës pan ëa. ");
INSERT INTO wer_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Pël yeem epël mëëa. “Ne ya këlangön panë yeem wel wiima yangap yaë. Pötaanök kosang newesak neering itiit öpa.” ");
INSERT INTO wer_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Pël mëak kot nent ëngkël së ë kosaö yangerak wesirak wë Anutuun kimang ngöntak epël mëëa. “Pep, ni kön wiin pangk ëën pöt këlangön nem naë orööpënëak yaë epot mop wasum. Nem könöök won, nim könöökë wiaul ëëm.” ");
INSERT INTO wer_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Pël më pet irak pim ru naar namp pöröa naë së itaangkën ka uraan Pitaan epël ök mëëa. “Ar neering kot nent itiit naöngan ma? ");
INSERT INTO wer_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Moröktak wiap sënganëën lup itiit wë Anutuun kimang maë. Arim lupöt kengkën yeëetak koröpöt könöm yaalni.” ");
INSERT INTO wer_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Pël mëak kaalak së Anutuun kimang mëak epël mëëa. “Pep, këlangön epot ilap neriipënëak kön wiin pangk naën ëën pöt yok pangk kat wiimaat. Nim könöökë wiaul ëëm.” ");
INSERT INTO wer_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Pël më pet irak kaalak pim ru naar namp pöröa naë së itaangkën pitëm itöt könöm yaëën ka ureim wëën itena. ");
INSERT INTO wer_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Pël ëak kaalak së kimang maan akun nentepar nent ëa. Ngön wet rëak kimang ngöntak ök mëëa tapët kaalak mëëa. ");
INSERT INTO wer_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Kimang më pet irak ru naar namp pöröa naë së epël mëëa. “Ar om ka könkön ureim wë ma? Peene epët nemëën kup mowiipna akunet temanöm yes. Omën Këëp nemëën kup mowiak omën utpetaröa moresi neulëëpnaat. ");
INSERT INTO wer_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Wal ëën sëpa. Omën nemëën kup mowiipnaap e yaarö.” ");
INSERT INTO wer_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesu pi pël yamëem wëën ten pim ru 12 pöröakaan namp yapinte Yutas pöpring omën kësang pan kiri ar yaaö kaöaröere ngarangköröak maan inre tang wak wais oröaut. ");
INSERT INTO wer_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yutas Yesu kup mowiipna pöp wet rëak pitën epël mëëa. “Ar ëwat sënëën tot numaatak pël yaëën tapöp wesak wali ön.” ");
INSERT INTO wer_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Pël mëak pi teëntom Yesuu naë wais, “Aköp, ni e wëën ma?” pël mëak tot yen. ");
INSERT INTO wer_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Pël ëën Yesuuk epël yema. “Ngöntöp nim ëëmëak waisan pöl ë.” Pël maan pit wais yeö. ");
INSERT INTO wer_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Pël yaëën ten Yesuring wëauröakaan nampök pim öpwer yepatuukaan tëak kiri ar yaaö wotöököpë inëën ru namp möak pim katëëp per yoola. ");
INSERT INTO wer_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Pël ëën Yesuuk piin epël yema. “Ni öpwer yepatuuk më. Omën öpwerring nga yaë pörö naröak kangiir öp möön wel wiipnaarö. ");
INSERT INTO wer_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ne nem Pepapön kimang maan pi teëntom ensel kësang pan rongan 12 pöt wes mëën wais kaamök elnëëpna pöt ni köpël ma? ");
INSERT INTO wer_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pël ëëmaatep ngönëntak utpet nem naë orööpënëak ëa epot tol ëak orööpën?” ");
INSERT INTO wer_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Pël niak pi öpënëak waisauröen epël yema. “Ar neen ngaap wesak wali neönëak inre tang wak yewais ma? Ne kët ël epotë ngönën tup kaöetak arring wëaup. Pël ëën ar akun pötë neneön yaaurö. ");
INSERT INTO wer_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pël ëaap omën epot yaaröön tektek ngön yaaö omnaröa ngaanëër retëng ëa pöt kë yaarö.” Pël yemaan ten pim ruurö sëp mowesak kas saut. ");
INSERT INTO wer_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ngön kosangötë ngarangköröere kaöarö pit kiri ar yaaö wotöököp, Kaiapas pim kaatak wa top ëak wëën omën Yesu wali wa pörö pi pörek mësak së moulmëa. ");
INSERT INTO wer_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pël ëën Pita pi ënëmënëm sa. Pël ëak pi kiri ar yaaö wotöököpë kaatak oröak ëmöökë kakaati së ilëak pit Yesu tol yaalmë pöt itaampënëak ngai omnaröa tekrak wel aisëa. ");
INSERT INTO wer_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Pël ëën kiri ar yaaö kaöaröere kansol pourö Yesu mëmpnaan omën naröak kaar rëak pim utpet ëautön mapënëak ap wesa. ");
INSERT INTO wer_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Pël yeem pimëën ngön kaar kësang pan koiraap pöt könöm naën ëën om ap weseim wëën ënëmak omën naar pitëm naë së ");
INSERT INTO wer_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","epël mëëa. “Omën epmor epël ëaumor. ‘Ne Anutuu ngëëngk tup epët tööl olëak kaalak kët nentepar nent ök remaap,’ pël yaan kat wiaumor.” ");
INSERT INTO wer_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Pël maan kiri ar yaaö wotöököpök wal ëak Yesuun epël ök mëëa. “Pitëm nimëën ngön ya epëten tol yewasën? Ni kangiir nent naëngan ma?” ");
INSERT INTO wer_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Pël maan Yesu ngön nemaan wëën kiri ar yaaö wotöököpök kaalak epël ök mëëa. “Ne Anutu wëwëetaringëp pim ëöetak pëël niamaan kosang wesak am. Ni Anutuu Yaö Niiaup, Kristo, Anutuu Ru tapöp ma?” ");
INSERT INTO wer_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Pël maan Yesuuk kangiir epël mëëa. “Nimtë yaan pi tapët. Pötaanök ne niamaan kat wieë. Ënëmak Omën Këëp ne Anutu weëre kosangëp pim yaapkëël wel aisëak kutöm kepilötë rangk yewaisën it nengempun sa.” ");
INSERT INTO wer_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Pël maan kiri ar yaaö wotöököp ya utpet pan ëën pimtë ulpëënëp keli olëak pim omnaröen epël ök mëëa. “Pi Anutu il yemowasem utpet wesak ya. Tol ëën omën munt narö piin ngön mapnaaröen kaalak ap weseim öpen? Ar pim Anutuun utpet wesak ya pöt yok kat wia. ");
INSERT INTO wer_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ar tol yak?” Pël maan epël mëëa. “Pi utpet yaarek wel wiip.” ");
INSERT INTO wer_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Pël mëak pim këëre wot kantak wasöp ngës menak momöa. Ën naröak kerëmteparë mor kaë yemomöem ");
INSERT INTO wer_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","utpet wesak epël mëëa. “Kristo, omën ni yanimö pöpë yapinte ök a.” ");
INSERT INTO wer_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita pi ka tomök ëmöökë kakaati wel aisëaan inëën koont nampök pim naë së piin epël mëëa. “Namp ni, Yesu Kalili yangerakaanëp piiring wëaup.” ");
INSERT INTO wer_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pël maan pi omnaröa ëöetak yak wesak epël mëëa. “Ne nim yaan pipten ëngk ma e yewas.” ");
INSERT INTO wer_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pël mëak ëm kanrak orööpënëak yaëën inëën koont munt nampök itenak omën naë wëauröen epël mëëa. “Omën epop Yesu Nasaret kakaanëpring wëaakë yaaup.” ");
INSERT INTO wer_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pël yemaan Pita pi yak weseë kosang wesak epël mëëa. “Anutuu ëöetak ne piin köpël.” ");
INSERT INTO wer_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Pël maan wë ngöpngöp yaëën omën pim naë wëauröak së piin epël mëëa. “Ten nim ngön köngkömöön kat yawi. Ni yaap pim toktakaanëp.” ");
INSERT INTO wer_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Pël yemaan Pita pi kosang panë wesak ngön köntak epël mëëa. “Ne Anutuu ëöetak omën pöpön köpëlëp.” Pël maöataring kokor ngön ëa. ");
INSERT INTO wer_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Pël ëën Pita pi Yesuu epël mëëa pöt kön wia. “Ni kokor ngön naën wiaan akun nentepar nent yak newasumëëp,” pël mëëa pöten kön wiak yaköm pan ëën së ing kaö ëa. ");
INSERT INTO wer_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ëlpam walën kiri ar yaaö kaöaröere ngarangk pourö wa top ëak Yesu mëngkën wel wiipnaata ngönte kosang wesa. ");
INSERT INTO wer_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Pël ëak maan wii tëak mësak së Rom yang ngarangk Pailat pöpë naë moulmëa. ");
INSERT INTO wer_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Wel wiipënëak kosang wesa pöt Yutas kup mowiaup kat wiak tol ëënak ëan pël kön wiak ya utpet ëën siluwa mon 30 ëak mena pöt wak së kiri ar yaaö kaöaröere ngarangkörö kaip ti menak epël mëëa. ");
INSERT INTO wer_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Ne utpet ëak saun wonöpön kup niwiin mëmpunëak yeë.” Maan pit epël mëëa. “Tol ëën tenën yeniaan? Pipët nimtëëtep.” ");
INSERT INTO wer_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Pël maan monat Anutuu ngönën tup kaöetak moolëak së kaö töa. ");
INSERT INTO wer_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Pël ëën kiri ar yaaö kaöaröere ngarangkörö siluwa mon pöt wa rongan ëak epël mëëa. “Mon epot kup niwiak waut. Pötaanök ke epëlöt ngönënëën yawiautak wiipenaataan nga wia.” ");
INSERT INTO wer_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Pël mëak pit ngön ë kopëta wesak omën kamaatëaanörö yang kel weerëpënëak omën yang kaap ket yaaupë yang lup nent sum ëa. ");
INSERT INTO wer_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Pël ëa pötaanök yang lup pöta yapinte omën iita yanget pël ya. ");
INSERT INTO wer_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Pël ëën tektek ngön yaaö namp Seremaia pim ngaanëër ngön ëa pöt kë oröa. Ngön pöt epët. “Israel omën naröak siluwa mon 30 pöt omën sum ëëpënëak kosang wiak mena pöt pit kaalak wa. ");
INSERT INTO wer_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Pël ëën aköpë ök neea pöl pit sum pötring omën yang kaap ket yaaupë yang lup nent sum ëa.” ");
INSERT INTO wer_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesu pi Rom yang ngarangkëpë ëöetak tauaan epël mëak pëël mëëa. “Ni Yuta omnaröa omën omp aköp ma?” Maan, “Yok yaan pi tapët,” pël mëëa. ");
INSERT INTO wer_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Pël maan kiri ar yaaö kaöaröere ngarangköröak pimëën ngön ya yamëngkën pi kangiir nemaan ëa. ");
INSERT INTO wer_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pël yaëën Pailatök epël mëëa. “Omnaröa ngön yaatak nimëën ngön ke nentere nent ya pöt kat nawiin ma?” ");
INSERT INTO wer_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pël maan Yesu pi ngön kangut nemaan pan yaëën yang ngarangkëp pi yaan sa. ");
INSERT INTO wer_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Krismakiatë akun kësang pötak yang ngarangkëp pi omnaröak omën namp wii kaatakaan wes mëëpënëak maan pöt wes më pël yeëa. ");
INSERT INTO wer_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Akun pötak omën namp yapinte Parapas pöp wii kaatak wë pöt omën pourö ëwat wëa. ");
INSERT INTO wer_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Pötaanök omnarö wa top ëak wëën Pailatök epël mëëa. “Talëp wes nimëëmëak aim? Parapas ma Yesu yapin nent Kristo yemak pöp?” ");
INSERT INTO wer_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Yuta omën kaöarö Yesuun om pas kaaö kön wieë wii kaatak moulmëa pöt pi ëwat wëak pël mëëa. ");
INSERT INTO wer_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Yang ngarangkëp pi ngön pöt më pet irak pim ngön ë pet yaira urtak wel aisëaan pim öngöpök ngön nent epël wes mëa. “Ni omën wotpil puopë ngönte pet irngan. Ne peene wangarëtak piin itenak ya këlangön pan kön yawi.” ");
INSERT INTO wer_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pël yaëën kiri ar yaaö kaöaröere ngarangköröak omnaröen Parapas wes mëak Yesu mëmpnaan mapënëak këk mëëa. ");
INSERT INTO wer_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pël ëën yang ngarangkëp pi kaalak epël mëak pëël mëëa. “Epaarëkaan talëp wes nimëëmëak aim?” Maan pitök, “Parapas,” pël mëëa. ");
INSERT INTO wer_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pël maan epël mëëa. “Ën Yesu, yapin nent Kristo pël yemak epop tol ëëm?” Maan epël mëëa. “Pi këra yetaprak möön wel wiip.” ");
INSERT INTO wer_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pël maan pi kaalak epël mëëa. “Omën epop utpet oröp nent ëa?” Maan ngön ë olëak epël mëëa. “Këra yetaprak möön wel wiip.” ");
INSERT INTO wer_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pël maan Pailat pi wiap yemowasem itaangkën pim ngönte kat nemowiin yeem ngön kaëp kësang yaan pi maan iit kol mangkën Yesu mëmpna saunet pim naë won pöt pet elmëëpënëak pim moresiar i yairem epël mëëa. “Omën wotpil epopë mëmpnaata saunet nemëën nasën, arimëën yes.” ");
INSERT INTO wer_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Maan pit këm top ëak epël mëëa. “Pim mëmpnaata saunet tenre tenim ëaröaan wiaap.” ");
INSERT INTO wer_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pël maan Parapas pëël elmëak Yesu pol koröp wapötringöök momöak këra yetaprak mööpënëak ngaaröa ngësë wes momëa. ");
INSERT INTO wer_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Yang ngarangkëpë nga naröak Yesu mësak së ngarangkëpë kaatak ulmëak maan nga omën pourö pim naë wa rongan ëa. ");
INSERT INTO wer_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Pël ëak pim ulpëënëp përë moolëak ngaaröa ulpëën köp möa namp momëa. ");
INSERT INTO wer_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Pël ëak wii këmampön ulte ket ë mowaëak kalaö naö mangkën mor yaapkëësi sungkör ëak taueëa. Pël ëën pim naë së ököök elmëak rar rë wesirak epël mëëa. “Yowe, Yuta omnaröa omp aköp.” ");
INSERT INTO wer_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Pël mëak waasöp ngës menak sungköraö wa ëp ëak kepönöök momöa. ");
INSERT INTO wer_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ngaaröak ököökre waswas pël elmëak ngaë ulpëënëp përëak kaalak pimtëëp më moulmëak këra yetaprak mööpënëak mësak sa. ");
INSERT INTO wer_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Pit kan yesem kamtaöök omën namp Sairini kakaanëp, pim yapinte Saimon, pöp koirak Yesuu këra yetapër wak sëpënëak këk maan wak sa. ");
INSERT INTO wer_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Pël ëak pit yang lup nenta yapinte Kolkota, tiarim ngöntak Kepön Kos pël yamëëa pötak së oröa. ");
INSERT INTO wer_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Pël ëak pit wain iitaring kakam yaaut irikor ëak mangkën na pet ëak kaaö ëa. ");
INSERT INTO wer_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Pël ëën pit pi këra yetaprak möak pim ulpëënre poë koröpöt wak ngasamtak wiak talëpök öpën pöten itena. ");
INSERT INTO wer_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Pël ëak pörek wel aisëak piin ngarangk ëa. ");
INSERT INTO wer_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Pël ëak “Omën epop Yesu, Yuta omnaröa omën omp aköp,” ngön yaatak pimëën ngön pël ëa pöt këra welingweri retëng ëak kepön löötak mö ulmëa. ");
INSERT INTO wer_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Pël ëak pit ngaare këkain omën naar, namp yaapkëël, namp katnëël mö ulmëa. ");
INSERT INTO wer_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Pël ëën omnarö sak waisak yeem piin sömre ëlakëër kepön keke elmëak ");
INSERT INTO wer_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","epël mëëa. “Ni, ‘Anutuu ngëëngk tupët tööl olëak kaalak akun nentepar nent ök remaap,’ pël ëauppe nimtë koröpö kaamök ë. Ni yaap Anutuu Ruup pöt këra yetaprakaan ent ëak ira.” ");
INSERT INTO wer_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Pël yemaan kiri ar yaaö kaöaröere ngön kosangötë ngarangköröere kaöarö pit tapël ökre was elmëak epël mëëa. ");
INSERT INTO wer_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Pi omën muntarö kaamök yaaupök pimtëën poprak yaë. Pi yaap Israel omnarö tiarim omën omp aköp pöt peene këra yetaprakaan ent ëak irap. Pël ëën tiar itenak piin kön wi kosang wasëpenaan. ");
INSERT INTO wer_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Pi Anutuun kön wi kosang yewasem, ‘Ne Anutuu Ruup’ pël yaaup. Pötaanök Anutuuk kent yaalmëa pöt ent ë moulmëëpnep.” ");
INSERT INTO wer_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Pël yemaan ngaare këkain omën pöaarökta tapël utpet wesak mëëa. ");
INSERT INTO wer_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Këtëp luptak 12 kilok pötak wëën yanget koö olëak wiaan së wiap kan 3 kilok oröa. ");
INSERT INTO wer_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Pël ëën 3 kilok këtëp tingk wesak yengmaan Yesu pi ngön ëak epël mëëa. “Eli, eli, lama sapaktani?” Pöt tiarim ngöntak epël. “Nem Anutu, nem Anutu, ni tol ëënak sëp yenewasën?” ");
INSERT INTO wer_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Pël yemaan omën pörek taueëaurö pit pöten kat wiak epël mëëa. “Kat wieë. Omën epop Eliaan merëk yema.” ");
INSERT INTO wer_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Pël yemaan pitëkaan namp pöömpö së i kaö kelwer wak wain i som yaautak wariak këkalëp kautak wa tëak Yesu nëmpënëak mena. ");
INSERT INTO wer_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Pël yaëën naröak epël mëëa. “Kora, Elia pi wais kaamök elmëëpën ma won pöten iteempa.” ");
INSERT INTO wer_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Pël yemaan Yesu pi kaalak merëk kaö ëak pim könöp wes mëak wel wia. ");
INSERT INTO wer_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Wel yawiin ngönën tup kaöetak poë koröp kësang ngeröök uteëaumpel oorekaan luptak keliak nempelnempel ëa. Pël yaëën yanger moup yamöön kël kësangöt luptak weling wera. ");
INSERT INTO wer_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Pël yaëën omën yangatta këm nga ëën Anutuu omën ngaan wel wia narö selap weletakaan wal ëa. ");
INSERT INTO wer_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Pël ëën Yesu wet rëak weletakaan wal ëënak pit omën yangat sëp wasak ka ngëëngk Yerusalem pöök së oröak wëën omën narö selap pitën itena. ");
INSERT INTO wer_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Nga omën wotöököpre omën piiring Yesu ngarangk wëa pörö yanger moup yamöön omnant oröa pötön itenak kas kësang pan ëak epël mëëa. “Yaap, epop Anutuu Ruup.” ");
INSERT INTO wer_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Yesu yamöön öng Kalili yangerakaan pim ënëm yewaisem kaömpre omnant kaamök elmë ima pörö kamaarek wë iteneëa. ");
INSERT INTO wer_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Öng pël ëa pöröakaan narö eporö. Maria Matala kakaanëpre Maria muntap Semsre Yosep pöaarë ëlëpre, Sepeti pim ruaarë ëlëp piporö. ");
INSERT INTO wer_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Wiap kanök Arimatia kakaan omën uröm kësang wieëa namp yapinte Yosep pöp sa. Pi Yesuu ru namp. ");
INSERT INTO wer_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Puuk Pailatë naë së Yesuu sokuren ök mëëa. Pël maan Pailatök pim omnaröen sokur mampënëak ök mëëa. ");
INSERT INTO wer_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Pël ëën Yosep pi sokur wak poë koröp kölam ompyaö naöök kör koëak ");
INSERT INTO wer_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","wak së pimtëën wesak kël öngöp ngolöp tëa naöök wiak kël kaö naö kur kaip tiak kanrak il wari ulmëak sa. ");
INSERT INTO wer_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Pël ëën Maria Matala kakaanëpre Maria muntap piarip naë wel aisëak ngarangk wëa. ");
INSERT INTO wer_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Kë yesa akun ngëëngktakëën omnant kön yaëën ëlpam walën ngëëngk akun pöt oröön kiri ar yaaö kaöaröere Parisi ngönën omnarö wa top ëak Pailatë naë së epël mëëa. ");
INSERT INTO wer_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“Kaöap, kaar omnamp pim öp wë epël ëaö pöten ten kön yawi. ‘Ne wel wiak kët nentepar nent won yesën kaalak wal ëëmaap.’ ");
INSERT INTO wer_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Pötaanök pim ruuröak së sokur këkain wak së ëlëëp wiak kaar ‘Wal ëa’ epanok ni maan nga omnarö pit yangaöök së ngarangk wëën kët nentepar nent won sëp. Pim ngaan kaar, ‘Ne Kristo,’ ëa pöt wiaan kaalak ‘Weletakaan wal ëëmaap,’ ëa epët rangk sëën kaö sëpan. Pötaanök yeniak.” ");
INSERT INTO wer_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pël maan Pailatök epël mëëa. “Ar nga omnarö mësak së moulmëën këëkë ngarangk ëëp.” ");
INSERT INTO wer_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Pël maan pit ngaaröaring së këlöökë rangk kë il mowiak ngaarö ngarangk öpënëak moulmëa. ");
INSERT INTO wer_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Kë yesa akunet pet irën Sante wangam kan ëlpam walëpënëak yaëën Maria Matala kakaanëpre Maria muntap piarip itaampënëak yangaöökë sa. ");
INSERT INTO wer_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Yesën moup kësangpel möön Aköpë ensel namp kutömweriaan irëak këlö wa pëlëër wiak rangk wel aisëeëa. ");
INSERT INTO wer_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Pim möönre koröpö kent tangarötë ököp, ën ulpëënëp kölam panë tëaup. ");
INSERT INTO wer_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Pël ëën ngarangk wëaurö pit itenak kas kësang ëak reireë urak it köpköp tiak së ngentiak wieëa. ");
INSERT INTO wer_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Pël ëën öngaar së oröön enselëpök epël mëëa. “Arip kas ëëngan. Ne ëwat wë. Arip Yesu këra yetaprak möaupön itaampunëak waisan. ");
INSERT INTO wer_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Pël ëanëp eprek won wiaap. Pim ngaan ök niia pöl ëak wal ëa. Wais, ur koseten iteneë. ");
INSERT INTO wer_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Pël ëak së pim ruuröen epël ök maë. ‘Yesu pi weletakaan wal ëa. Pël ëak wet rëak Kalili yangerak së wëën ar ënëm së itaampunëët.’ Ngön kot pi tapët ök yeniak.” ");
INSERT INTO wer_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Pël maan piarip teëntom yangaöökaan kaip tiak ërëpsawi kaö ë ruuröen ök mapënëak sa. ");
INSERT INTO wer_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Yesën Yesu kan kourak koirak, “Yowe” mëëa. Pël ëën piarip pim naë së tok oriak ingesiarë moröak yaya mëëa. ");
INSERT INTO wer_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Pël ëën Yesuuk piaripön epël mëëa. “Kas ëëngan. Arip së nem karuröen Kalili yangerak wais neen itaampnaan ök man.” ");
INSERT INTO wer_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Öng pöaar yesën nga omën yangaöök ngarangk wakaimauröakaan narö kak së kiri ar yaaö kaöaröen omnant yangaöök oröön itena pötön ök mëëa. ");
INSERT INTO wer_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Pël ëën pit ngarangkörö wa top ë ulmëak ngön ë kopëta wesak nga omnarö sum kësang menak ");
INSERT INTO wer_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","epël mëëa. “Ar omnaröen epël man. ‘Rö kan ten ka uraan pim ruurö wais sokur këkain wak ëlëëp wia.’ ");
INSERT INTO wer_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ngön pöt yang ngarangkëp kat wiak nga yaalniin pöt tenök wiap mowasën nga sëp wasëpnaat.” ");
INSERT INTO wer_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Pël maan ngaarö pit mon pöt wak së pitëm mëëa pöl ëa. Pël ëën ngön kaar pöt Yutia yangerak kaö wesak om aim wë. ");
INSERT INTO wer_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ten ru 11 pörö Kalili yangerak së Yesuuk ngaan rosir naö pi koirënëak ök niia pöökël saut. ");
INSERT INTO wer_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Së piin itenak narö yaya yemaan narö kön selap ëaut. ");
INSERT INTO wer_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Pël yaëën Yesu tenim naë wais epël yenia. “Kutömweriire yangerakë weëre kosang pout Anutuuk ne nen pet iraut. ");
INSERT INTO wer_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Pötaanök ar yang ël epotë yesem omën ke nampre namp pourö nem ingre mor sëpnaan ngönën ök maim ön. Pël yeem Pepere Ruupre Ngëëngk Pulö tenim yapintak i momëën. ");
INSERT INTO wer_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Pël ëak nem ngön ök niiaöre rë niulö pël elnieim pöt rë moulön ënëm ëëp. Ne niamaan kat wieë. Ne kët ël epotë arring wëën akun kaöaö temanöm sëpën sa.” ");
INSERT INTO wer_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Yesu Kristo Anutuu Ruup pim ngön ompyaut ngës rëak epël oröa. ");
INSERT INTO wer_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Aisaia Anutuu tektek ngön yaaupök epël retëng ëa. “Kat wi. Ne omën nem ngönte waup wes mëën wet rapnaat. Puuk nim kanö ningësëpnaat. ");
INSERT INTO wer_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Yang pultakaan omën nampök epël ya. ‘Aköpëën kanö wotpil weseë. Ngësak ompyaö panë weseë.’” ");
INSERT INTO wer_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Aisaia pim retëng ëa pöl Son i yamëa pöp yang pultak oröak ngön epël ëa. “Arim utpetat sëp wasën ne ar i nimëëmaan. Pël ëën Anutuuk arim utpetat ent ë nuulapnaan.” ");
INSERT INTO wer_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Pël maan Yutia yangrakaanre Yerusalem kakaan omën narö selap pim naë së ngön kat wiak pitëm ketre saunat tekeri wesak ök maan Sonök Yotan imeri i momëa. ");
INSERT INTO wer_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Son pöp pim ulpëën kosangëp pol kamel ëpötök ket ëak mëak wëa. Pël ëak pol koröpöök yepat ket ëaö naö urëëa. Ën pim kaömp pöt ngëntre mop pëën neima. ");
INSERT INTO wer_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ngönte pöt epël ök maima. “Omën nem ënëm waisëpna pöp pim weëre kosangtak nemët il wasëpnaap. Ne utpet epopök pim ing korötepar wii nemowilnganëëp. ");
INSERT INTO wer_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ne i yaaptaring yanimë. Puuk pöt Ngëëngk Pulöök nimëëpnaat.” ");
INSERT INTO wer_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Akun pötak Yesu Nasaret kak Kalili yangerakaan së oröön Sonök Yotanëk i momëa. ");
INSERT INTO wer_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Pël ëën imeriaan yaaprem itaangkën kutömwer këm nga ëën Pulö ekëpë ök sak pim rangk irëa. ");
INSERT INTO wer_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Pël yaëën kutömweriaan ngön nent epël mëëa. “Ni nem Ruup. Ne nimëën ya kë sak niin kent panë yaalni.” ");
INSERT INTO wer_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Pël yemaan Pulöök tapëtakëër yang omën wonrekë wes mëën sa. ");
INSERT INTO wer_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Pörek së akun 40 wëën Setenök morök elmëeima. Pi animauröa tekrak wëën enselöröak kaamök elmëeima. ");
INSERT INTO wer_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Son wii kaatak moulmëën wëën Yesu pi Kalili yangerak së oröak Anutuu ngön ompyaut war wesak epël ök mëëa. ");
INSERT INTO wer_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Akun temanöm yesën Anutuuk peene wa ngaöök nimëëpnaan yaë. Pötaanök lup kaip tiak ngön ompyaut wak taë weseë.” ");
INSERT INTO wer_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yesu pi Kalili i kaö pöökë pouuk yesem itaangkën omp nanang naar, Saimonre nangap Entru, piarip i kaö pöök iir yoolaan itena. Piarip i kaö imënörö korak wes mëak mon wa pël eim wëa. ");
INSERT INTO wer_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Pël ëën epël mëëa. “Arip nem ënëm waiseë. Pël ëën nook arpim i kaö imënörö yewan pi tapël omnaröeta önëën niulëëmaan.” ");
INSERT INTO wer_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Pël maan piarip tapëtakëër piarpim iiröt om wiak pim ënëm sa. ");
INSERT INTO wer_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Pël ëën pi kot nent ëngkël yesem itaangkën omën nanang munt naar Semsre nangap Son, Sepeti pim ruaar, piarpim wangaöökë rangk iiröt ompyaö yewasem wëën itena. ");
INSERT INTO wer_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Pël ëak piaripön ngön maan piarpim pepap Sepeti pim ya omnaröaring wangaöök wëën sëp mowesak Yesuu ënëm sa. ");
INSERT INTO wer_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Pël ëak pit Kapaneam kak së oröak kët kë yesautak Yesu pi Yuta omnaröa ngönën tuptak së ilëak ngës rëak ngönën ök mëëa. ");
INSERT INTO wer_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Pël yaëën omnarö pim ngöntaan yaan panë sa. Pi pepapök öngpököt wa kotiak maan ngön kosangötë ngarangköröa ngön yaaut il mowesa. ");
INSERT INTO wer_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Pël yaëën akun tapëtak ngönën tup pöta kakaati omën urmerap pim lupmeri wëaö nampök Yesuun ngön ëak epël mëëa. ");
INSERT INTO wer_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Elei, Yesu Nasaretaanëp. Ni ten tol elniim? Ni utpet niwasumëak waisan koröp. Ne niin ëwat wë. Ni Anutuu naëaan Omën Ngëëngkëp.” ");
INSERT INTO wer_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Pël maan Yesuuk urmer pöpön ngön kosang mëak epël mëëa. “Ni ngön angan. Omën pipop sëp mowesak oröak së.” ");
INSERT INTO wer_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Pël maan urmerap orööpënëak omnamp mök ë moolaan së ngentiak wiaan ngönëër oröak sa. ");
INSERT INTO wer_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Pël ëën omnarö yaan panë sak neneren epël mëëa. “Elei, epët oröpët? Ngön epët maim nent. Weëre kosangring maan urmeraröeta pim ngön ngaarëk yëo.” ");
INSERT INTO wer_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Pël ëën ngön pöt ulöl sak Kalili yanger pangk ëa. ");
INSERT INTO wer_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Akun pötak ngönën tuptakaan oröak Semsre Sonring Saimonre Entru piarpim kaatakë sa. ");
INSERT INTO wer_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Pël ëak Saimon pim öng lëlamöp yauman koröp es nga yeem wiaan teënt Yesuun ök mëëa. ");
INSERT INTO wer_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ök maan pim naë së moresi moröak wal ë moulmëën tapëtakëër koröp es nga pöt won sëën kaömp ar ë mena. ");
INSERT INTO wer_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Wiap kan pötak këtëp yeilaan omën kak pörek wëaurö pit omën yauman yaauröere urmerarö pitëm lupötë wëaurö pourö pim naë wak sa. ");
INSERT INTO wer_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Pël ëën kak pörekörö ka kanrak së rongan ëa. ");
INSERT INTO wer_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Pël ëën yauman ke nentere nent yaaurö ompyaö mowesak urmerarö selap waö ë momëa. Pël ëak urmerarö pim songönte ëwatörö yak tekeri wesak apanëak nga mëëa. ");
INSERT INTO wer_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Röök nginömööring ëlpam këëkë newalën wiaan wal ëak yang lup omën won nentak së Anutuun ök mëëa. ");
INSERT INTO wer_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Pël ëën Saimonre pim karurö piin ap wasö ënëm së ");
INSERT INTO wer_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","koirak epël mëëa. “Omnarö niin ap yewas.” ");
INSERT INTO wer_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Pël maan epël mëëa. “Tiar ka munt temanöm wia pötëëta ngönën ök maö sëpa. Ne ya pöt mëmpëak waisaup.” ");
INSERT INTO wer_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Pël mëak Kalili yangerak ka wieëa pötë së ngönën tupötë ngönën ök maöre urmerarö waö ë më pël ëeim wakaima. ");
INSERT INTO wer_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Omën kësë ëa namp pim naë së rar rë mowesirak epël mëëa. “Aköp, ni ompyaö newasumëak pöt yok pangk ompyaö newasumëët.” ");
INSERT INTO wer_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Pël maan Yesu pi piin yaköm ëën mores el mëak pim rangk mowiak epël mëëa. “Pël elniimëak yeëerek ompyaö së.” ");
INSERT INTO wer_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Pël maan tapëtakëër pim kësëat won sa. ");
INSERT INTO wer_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Pël ëën teënt wes yamëem pepanöm mëak epël ök mëëa. ");
INSERT INTO wer_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Epël yaalni epta ngönte omnaröen ök manganok om el wesak së nim koröpö kiri ar yaaö nampön pet elmë. Pël ëak omnarö nim ompyaö san pöt ëwat sëpnaan Moses pim ngön kosangta wia pöl kiri ar ëëm.” ");
INSERT INTO wer_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Pël ëën Yesu pi ka kaöatë yoolök naaröön ëlëëp omën wonötë wëën omën nalaan nal wëaurö pim naë seima. ");
INSERT INTO wer_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Wë ënëmak akun nentak Yesu pi kaalak Kapaneam kak së oröak ka nentak së wëën ka peparö kat wiak ");
INSERT INTO wer_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","pim ka wëa pötak së wa top ëak peö ëën ka kanëreta il wariak wëa. Pël ëën Yesuuk pitën ngönën ök yemaan ");
INSERT INTO wer_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","omën mor kong nent pöröak omën kosat kël wa namp urtak wiak wak së oröa. ");
INSERT INTO wer_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Pël ëak pim naë mowiipënëak omën selap peö ëak wëën pomp ëak kaata ngaarëk is Yesuu wëaurek ka möör wak omnamp urtaring wes mëën irëa. ");
INSERT INTO wer_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Pël ëën Yesu pitëm kön wi kosang yewesauten itenak omën kosat kël wa pöpön epël ök mëëa. “Nem ruup, ne yok nim saunatë kangut ent ë yanuulak.” ");
INSERT INTO wer_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Pël yemaan ngön kosangötë ngarangk pörek wëa narö kat wiak epël kön wia. ");
INSERT INTO wer_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Elei, omën epop pi oröp ëënak epël ya? Pi, ‘Ne yok nim saunatë kangut ent ë yanuulak,’ pël yemaan Anutuu yapinte wa ngep yaalmë. Ya pöt Anutu pimtëëtep.” ");
INSERT INTO wer_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Pël yaëën Yesu pitëm könötön pim könöök itenak epël mëëa. “Arim lupötë tol ëënak kön ke pil yawi? ");
INSERT INTO wer_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Nem omën kosat kël waupön, ‘Nim saunatë kangut ent ë yanuulak,’ ngön pël yemak pöt kengkënte. Pöt ar ngön pöta këët tekeri nasën ëën nem ngön pöt yaap ma kaar pël newasngan. Ën nem omnampön, ‘Wal ëak së,’ ngön pël yemak pöt könömët. Pöt nem ngön pöta këët tekeri sëën ngön pöt yaap ma kaar pël wasënëët. ");
INSERT INTO wer_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Pötaanök ar ne kaar wonöp Omën Këëp e yangerak wë weëre kosang wak saunatë kangut ent ë yemoolak pöten ëwat sënëak epël ök yemaan iteneë.” Pël mëak kosat kël wa pöpön epël mëëa. ");
INSERT INTO wer_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ne epël niamaan kat wi. Ni wal ëak korumönte wak nim kaatakë së.” ");
INSERT INTO wer_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Pël maan pi wal ëak tapëtakëër korumönte wak pit pouröa itöök kan sa. Pël ëën yaan sak Anutuun ping wesak epël ök mëëa. “Tiar omën ke epël nenten itnaangkën ëaut.” ");
INSERT INTO wer_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu pi pël ëak kaalak i kaö ëöökël yesën omën selap pim ënëm sëën ngönën ök mëëa. ");
INSERT INTO wer_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Pël ëak pörekaan së Liwai, Alpias pim ruup, pim mon yewaö kaatak wëën itenak epël ök mëëa. “Nem ënëm elnë.” Pël maan pi wal ëak pim ënëm sa. ");
INSERT INTO wer_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Pël ëak Yesuun yas maan pim kaatak së wel aisëak kaömp yenën takis yewaöre utpet yaaö munt narö kësang piire pim ruuröaring kaömp ngawi na. Omën ke pilorö kësang pan pim ënëm sa pötaanök. ");
INSERT INTO wer_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Pël ëën Parisi omën ngön kosangötë ngarangk naröak itaangkën pi omën utpet yaauröere takis yewauröaring kaömp ngawi yenën pim ruuröen epël mëak pëël mëëa. “Arim rë yanuulaup, pi tol ëënak omën takis yewauröere utpet omnaröaring kaömp ngawi yen?” ");
INSERT INTO wer_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Pël maan Yesu kat wiak kangiir epël mëëa. “Omën yauman wonörö rota ngësë nasën. Yaumanringöröakëër rotaaröa ngësë sa yaë. Ne omën pitëmtën kön wiin wotpilörö pël yewas pörö lup kaip tiipnaan memëak newaisën. Won, omën pitëmtën kön wiin saun yaaurö pël yewas pörö ngön ök maan lup kaip tiipënëak waisaup.” ");
INSERT INTO wer_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Akun pötak Sonë ruuröere Parisi omnaröa ruurö kaömp ngës olëak wëa. Pël ëën omën narö Yesuu naë së epël mëak pëël mëëa, “Sonë ruuröere Parisi omnaröa ruurö kaömp ngës olëak wë. Ën nim ruurö tol ëënak pël naën yaë?” ");
INSERT INTO wer_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Pël maan Yesuuk kangiir epël mëëa. “Omën namp öng öpënëak yeem pim karuröaring wëën karuröak yaköm ëën kaömp ngës olëak öpën ma? Won. Pitring wëën kaömp ngës olëak naöpan. ");
INSERT INTO wer_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ënëmak omën naröak pi wak kama ulmëën akun pötakökëër pim karurö yaköm ëën kaömp ngës olëak öpnaat. Pöl pit ne kama neöpna pötakökëër nem ruurö neen yaköm ëën kaömp ngës olëak öpnaat. ");
INSERT INTO wer_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Omën namp poë koröp ngolöpöökaan kaö nent ilak ulpëën ngaanëpë keliaurek wiak korir namëëpan. Pël ëëpna pöt poë koröp ngölöp pötak ulpëën ngaanëp weruun ilak kaak sëpnaat. ");
INSERT INTO wer_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ën omën namp i kep pol koröpwerring ket ëa ngaan pötak wain i ngolöpët kolön yok pangk naëpan. Pël ëëpna pöt wain i pöt kep wetak pol koröp pöt sak il ngentiin iit orö sëpnaat. Pël ëën pol koröpwerta utpet ëëpnaat. Pötaanök wain i ngolöpët kep ngolöptak lë mëëpna pötak pangk ëëpnaat.” Yesuu pël mëëa pöta songönte epët. Mosesë ngön kosang ngaanötre pimtë ngön ngolöpöt pangk irikor naëpan pötenök mëëa. ");
INSERT INTO wer_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Kë yesa akun ngëëngk nentak Yesure pim ruurö pit rais yaöökë lup yesem ruurö ulöp narö töa. ");
INSERT INTO wer_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Pël yaëën Parisi naröak piin epël mëëa. “Kë yesa akun ngëëngktak pitëm ya yamëngk pipotön pepanöm wia. Pit tol ëënak yaë?” ");
INSERT INTO wer_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Pël maan Yesuuk epël ök mëëa. “Tewitre pim omnaröa kaömp won wë këënëën ëa pöt ar sangk kelak kat nawiin yaaurö ma? ");
INSERT INTO wer_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Apaiata pim kiri ar yaaö wotöök sak wëa akunetak Tewit pi Anutuu ngönën tup kaöeta kakaati së kaömp Anutuu ëöetak wieëa pöt kiri ar yaauröakëër nëmpnaan omën pasurö nëmpanëak nga yaaut wak pimënt nak pim omnarö karut mangkën na. Pöt ar sangk kelak kat nawiin yaaurö ma?” ");
INSERT INTO wer_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Pël mëak epël mëëa. “Anutu pi omnarö kaamök ëëpënëak akun kë yesaut ket ëa. Pi akun kë yesaut kaamök ëëpënëak omnarö ket naën. ");
INSERT INTO wer_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Pötaanök Omën Këëp ne kë yesa akun ngëëngk pöta pepap. Nem kentöök akun eptak nem ruuröen omnant ëëpnaan memaat.” ");
INSERT INTO wer_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Akun nentak Yesu pi kaalak ngönën tupta kakaati ilëak itaangkën omën mores kël wa namp wëa. ");
INSERT INTO wer_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Pël ëën omnarö pit Yesuuk akun ngëëngktak ompyaö wasën pöt ngön yaatak ulmëëpënëak ngai yeem wëa. ");
INSERT INTO wer_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Pël ëën puuk omën mores kël wa pöpön epël mëëa. “Wal ëak wais itëkëël tau.” ");
INSERT INTO wer_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Pël mëak omnaröen epël pëël mëëa. “Kë yesa akun ngëëngktak omnarö ompyaö elmëëpen ma utpet elmëëpen? Omnarö ompyaö mowasëpen ma utpet mowasëpen?” Pël maan pit nerek nemaan. ");
INSERT INTO wer_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Pël yaëën pi pitëm lup kosang yaauten ya këlangön ëën nga it nalnal elmë pet irak omën pöpön epël mëëa. “Nim mores el më.” Maan mores el mëën kosang sa. ");
INSERT INTO wer_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Pël ëën Parisi omnarö ka tomök së tapëtakëër Erotë omnaröaring pit tol ëak Yesu mëmpën pöta ngönte kopëta wesa. ");
INSERT INTO wer_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu pi pim ruurö koirak i kaöök së wëën Kalili yangerakaan omën selap pan pitëm ënëm sa. Pörö pëën won, Yutia yangerakaanre ");
INSERT INTO wer_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Yerusalem kakaan, Itumia yangerakaanre i Yotanë ëngk komuntakëlaanre Taiaare Saiton ka pöörarëaan omën selap pan pim yaautön kat wiak së oröa. ");
INSERT INTO wer_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Pël ëën omën selap pörö pi ngepre un elmëëpanëak pim ruuröen wang naö temanöm wes ulmëëpënëak mëëa. ");
INSERT INTO wer_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Omën selap pan ompyaö mowesa. Pötaanök omën ëmpölre yaumanörö pi mësël elmëëpënëak së ngepre un elmëëpanëak wangaöön mëëa. ");
INSERT INTO wer_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Pël ëën omën urmeraröaringöröak Yesuun itenak pim ingrak rar rë wesirak ngön ëak epël mëëa. “Ni Anutuu Ruup.” ");
INSERT INTO wer_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Pël yemaan pit pim songönte tekeri wesak apanëak kosang wesak nga mëëa. ");
INSERT INTO wer_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Wë akun nentak pimënt rosir naöök së wë pim ru öpënëak kent kön wiauröen yas maan pim naë së rongan ëa. ");
INSERT INTO wer_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Pël ëën omën 12 pörö ru wesak piiring wë ngönën ök maöre ");
INSERT INTO wer_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","urmerarö waö ë momë pël ëëpënëak mëëa. ");
INSERT INTO wer_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Pim omën 12 ëak wa ulmëa pörö eporö. Saimonön yapin ngolöpët Pita mëëa. ");
INSERT INTO wer_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Pël ëak Sems Sepeti pim ruupre nangap Son, piaripön yapin ngolöpët Poanesis mëëa. Tiarim ngöntak tangre kaö pöta ökaar pël apenaat. ");
INSERT INTO wer_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ën Entruure Pilip, Patolomiuure Matiu, Tomasre Sems Alpiasë ruup, Tatiasre Saimon Selot pël yamëëa pöp pi ngaan Rom kamanëp sëp mowasëpënëak aima omën tok pötakaanëp piire ");
INSERT INTO wer_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ën Yutas Keriot kakaanëp Yesuun kup mowiipnaap. ");
INSERT INTO wer_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yesu pi kaatak së wëën omën kësang pan kaalak wa top yaëën pit ruuröa kaömp nëmpna mopët won ëa. ");
INSERT INTO wer_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Pël yaëën pim ëlre nang kat wiak, “Kön irikor yaalmë,” pël mëak koirëpënëak sa. ");
INSERT INTO wer_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Pël ëën ngön kosangötë ngarangk Yerusalem kakaan sa pöröak epël mëëa. “Urmeraröa kaöap, Pielsepul, pim lupmeri wëën pöpë weëre kosangöök urmerarö waö ë yamë.” ");
INSERT INTO wer_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yemaan wa top elmëak ngön nokoliil nent epël mëëa, “Setenök tol ëak pimënt waö elmëëpën? ");
INSERT INTO wer_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Yang nerakë omnarö pitëm naë nga oröön nener mënak kom ëak pöt naön ëëpnaat. ");
INSERT INTO wer_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ën ka kopët nentak wëaurö tapël nener mënak kom ëëpna pöt repak sëën ka kosaö wiaapnaat. ");
INSERT INTO wer_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Tapël Setenök werak pimënt möak waö elmeëpna pöt pangk kosang sak naën ëëpnaat. Pi kö sëpnaat. ");
INSERT INTO wer_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Omën nga namp wëën munt nampök pim kaatak ilëak omnant naöpan. Wet rëak omën nga pöp wii të wiakök pim omnant pout öpnaat. Nga pöp Seten. ");
INSERT INTO wer_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ne yaap niamaan kat wieë. Omën utpet ke nentere nent ëak Anutuun utpet wesak mapna pöt Anutuuk omën utpet pöt poutë kangut yok pangk kërë moolapnaat. ");
INSERT INTO wer_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ën namp pi Ngëëngk Pulöön utpet wesak tapël mapna pöp pim saun pöta kangit ent ë nemoolapan, om kosang wiaapnaat.” ");
INSERT INTO wer_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ngön pipët, “Pim lupmeri urmerap wë,” mëëa pötaanök pil mëëa. ");
INSERT INTO wer_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ngön pipot ök yamëem wëën pim ëlre nang ka tomök së wë orööpënëak kakaatiil ngön wes mëa. ");
INSERT INTO wer_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Pël ëën Yesu pi omnaröa öngpök wëën epël ök mëëa. “Nim ëlre nang tomök wë niin ya.” ");
INSERT INTO wer_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Pël maan Yesuuk epël mëëa. “Nem ëlre nang talörö?” ");
INSERT INTO wer_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Pël mëak omën wirö wa taap elmëak wëa pöröen iteneë epël mëëa. “Nem ëlre nang pörö eporö. ");
INSERT INTO wer_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Omën Anutuu këm ngön ngaarëk yeö piporö nem ëlre nangarö pël yaë.” ");
INSERT INTO wer_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu pi kaalak i kaö ëöök së këëkë wesak ngönën ök mëëa. Pël yaëën omën kësang pan pim naë wa rongan ëa. Pël ëën pi wangaöökë ngaarëk is wel aisëak wëën omnarö yangerak wëa. ");
INSERT INTO wer_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Pël ëaan watepang ngön nentere nent yamëem nent ngës rëak epël mëëa. ");
INSERT INTO wer_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Niamaan kat wieë. Omën namp pim yaak së omnant öpöt olëa. ");
INSERT INTO wer_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Pël ëën nant kamtaöök ngentiin intöröak oröak na. ");
INSERT INTO wer_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ën nant këlöökë rangk ngentia. Pël ëën yanget könyangap wiaan yak teënt oröa. ");
INSERT INTO wer_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Pël ëën këtëp ngaarëk apër maan öp pöt kotön saap wak umön rëa. Pöt misënöt kotut pötaanök. ");
INSERT INTO wer_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ën nant nönötë öngpök olëa. Pël ëën nönöt oröak ngep ëën sësë ëak mos ëa. ");
INSERT INTO wer_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ën nantökëër yang kolaptak olëa. Pël ëën pötökëër aprak ulöl sak kë kësang pan uta. Kengk nemorëët 30, nemorëët 60, nemorëët 100 pël uta.” ");
INSERT INTO wer_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ngön pipët maö së epël mëak pet ira. “Katringëpök ngön epët kat wiip.” ");
INSERT INTO wer_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Omnarö sa pet yairën pimënt wëën pim ru 12 pöröere omën munt piiring wëaurö pim watepang mëëautë songönötön pëël mëëa. ");
INSERT INTO wer_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Pël ëën epël mëëa. “Anutu pimtok wa ngaöök nimëak wë ngön ëlëëp pöta songönte arënökëër pet yaalni. Ën omën muntarö pit pöta songönte kat wiipanëak watepang ngön ök yak. ");
INSERT INTO wer_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Pit Anutuu naë rë olaan pitëm saunatë kangut kërë olapan itöök itaampënaatak këëten yok pangk itnaampan ma katëëpök kat wiipnaatak songönten këëkë kön nawiipan.” ");
INSERT INTO wer_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Pël mëak epël mëëa. “Watepang niak pöta songönten ëwat nasën ma? Pël yaëen tol ëak watepang ngön pout niaan ëwat sën? ");
INSERT INTO wer_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Omnampë öpöt olëa pöt ngönën öpöt olëa. ");
INSERT INTO wer_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Öpöt kamtaöök ngentia pötë ökörö pit ngönën kat wiak wa lupmeri wiin Seten tapëtakëër wais wak sëpnaat. ");
INSERT INTO wer_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ën öpöt këlöökë rangk ngentia pötë ökörö pit ngönën kat wiak tapëtakëër kent kön wiak wak öpnaat. ");
INSERT INTO wer_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Pël ëak lupötë misën il natëën. Pötaanök akun kot nent kön wi kosang wesak wëën pitëm Anutuu ngön ngaarëk yeö pötaan omnaröak këlangön kat mowiak utpet mowasën tapëtakëër wil këlok ëëpnaat. ");
INSERT INTO wer_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Öpöt nönötë öngpök ngentia pötë ökörö pit ngönën kat wiipnaatak ");
INSERT INTO wer_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","wë koröpöökë omnantön kön selap ëëre monere urömen kentre kaur ëëre omën munt nantön war ë pël yaëën pötök ngep elmëën ngönën mos ëëpnaat. ");
INSERT INTO wer_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ën öpöt kolaptak ngentia pötë ökörö pit ngönën kat wiak wak wëën pitëm wëwëatë kë ompyaut orööpnaat. Narö kë 30, narö kë 60, narö kë 100 pël orööpnaat.” ");
INSERT INTO wer_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","“Talëpök esuwes mangiak wak së kapita öngpök mëëre urta ikanöök wi pël ëëpën? Pël naëpan. Urta ngaarëk wesiren ëwa ëëpnaat. ");
INSERT INTO wer_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Omën ëlëëp wia pipot wi naöpanëët. Pipot tekeri sëpnaat. Ën ngep ëën wia pipot wiakaim wi naöpanëët. Ënëmak wëlël ëën omnarö itaampnaat. ");
INSERT INTO wer_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Katringëpök ngön epët kat wiip.” ");
INSERT INTO wer_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Pël mëak epël mëëa. “Ar nem ngönöt këëkë wesak kat wieë. Arök omnant omnaröaan elmëënë pöt Anutuuk tapël kaip ti nimpnaat. Pël ëak muntat kaö wesak nimpnaat. ");
INSERT INTO wer_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Namp Anutuuk ngön ompyaö nant mangkën taë wak öpna pöp muntat mampnaap. Ën namp mangkën taë wes wak naön ëëpna pöp kot weëa tapët Anutuuk kama wa ëp ëën elek öpnaap.” ");
INSERT INTO wer_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu pi ngön nent epël mëëa. “Anutuu wa ngaöök yanimë pöt epël. Omën namp pim yaak omnant öpöt olapnaat. ");
INSERT INTO wer_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Pël ëak rö kan ka urööre këtëk wal ëak wë pël yeem rëngap yaaröön pöta songönte köpël öpnaat. ");
INSERT INTO wer_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Yanger pimtok kaamök elmëën rëngap orööpnaat. Wet rëak rëngap orööpnaat. Pörekaan ëp wilëpnaat. Pörekaan këët utöpnaat. ");
INSERT INTO wer_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Pël ëak köp sëën omnamp tööpnaat. Këët yatöa akunet temanöm yes.” ");
INSERT INTO wer_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesuuk omnaröen ngön nent epël ök mëëa. “Anutuu wa ngaöök yanimë pöt tolëëlte? Ne oröp nantë ök ëak am? ");
INSERT INTO wer_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Pipët këra lëlëp nampë ököt. Lëlëp pöp kot panëëp, omën muntatë lëlëpöröak il yewas. ");
INSERT INTO wer_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Pël yaëëtak oröakökëër pöpök këra muntat il wesak wap wiak wëën intörö wais ngentiak kët kosöptak wëëre ka ëp wi pël yaë.” ");
INSERT INTO wer_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu pi watepang ngön nentere nent mëak ngönën ök maima. Pitëm ëwat sëpnaat ök maima. ");
INSERT INTO wer_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Nent war wesak nemaan, watepang pëën maima. Pimtë ruuröaring pëën wëakëër war wesak ök maima. ");
INSERT INTO wer_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Kët taptak wiap kanök pim ruuröen epël mëëa. “Tiar i kaö olëak ëngk komuntakël sëpa.” ");
INSERT INTO wer_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Pël maan omën kësang pörek wëën sëp mowesak teëntom piiring wangaöök ilëak yesën wang munt nant ënëm sa. ");
INSERT INTO wer_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Yesën kent kësang panë möak kaö maat wangaöök ilëak peö ëëpënëak ëa. ");
INSERT INTO wer_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Pël yaëën Yesu pimënt wangaöökë kasngaël ngan rerekta rangk ka uraan it moilak epël ök mëëa. “Rë yanuulaup, tiar kö sëpenëak yeëep ya ngës naën ma?” ");
INSERT INTO wer_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Pël maan wal ëak kentöön nga mëak i kaöön epël ök mëëa. “Ni leng ëak wia.” Pël maan kentö leng ëën i kaö wiap sa. ");
INSERT INTO wer_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Pël ëën pitën epël mëëa. “Ar oröpëën kasiin sak yeë? Arim kön wi kosang yewesaut won ma?” ");
INSERT INTO wer_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Pël maan pit yaan sak neneren epël mëëa. “Elei, omën epop tal namp apen? Puuk kentre i kaö maatön nga maan pim ngönte ngaarëk yeöp.” ");
INSERT INTO wer_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Pit i kaö olëak ëngk komuntakël Kerasa yangerak së oröa. ");
INSERT INTO wer_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Pël ëak wangaöökaan yaaröön omen urmerap pim lupmeri wëaö namp omën yangaöökaan së pi koira. ");
INSERT INTO wer_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Omën pöp omën yangaöök wë nga yaëën ingre morötë wii yaapötökre seenötök të yemowiin pangk naën yaaup. ");
INSERT INTO wer_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Omnaröak kët ël epotë ingre morötë wii yaapötök tëëre seenötök të pël ëën wii yaapöt il olëak seenötta tapël il olëak wëën omnarö mor öpënëak yaëën pangk naën yaaup. ");
INSERT INTO wer_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Pi rö kanre këtëk poutë omën yangaöökre rosiratë ka ureim wë ngön ë olëak aimeë pimtok pimtë koröpö kël möeimën utpet ëaup. ");
INSERT INTO wer_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Omën pöpök kamaarek wë Yesuun itenak pöömpö së rar rë wesirak yaya yamëem ");
INSERT INTO wer_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ngön ëak epël mëëa. “Yesu ni Anutu Ngaarëk Panëëpë Ruup. Ni ne tol elnëëm? Ne Anutuu ëöetak niamaan. Ni këlangön nangkan.” ");
INSERT INTO wer_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Yesuuk, “Urmerap ni, omnampökaan oröak se,” pël ök mëëa pötaanök. ");
INSERT INTO wer_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Pël ëak Yesuuk pim yapinten pëël maan epël mëëa. “Nem yapinte Selap. Ten selap wë pötaanök.” ");
INSERT INTO wer_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Pël mëak ke urak kimang epël mëëa. “Ten yang epër sëp wasënaataan waö elnëëngan.” ");
INSERT INTO wer_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Pël ëën yang pörek tangitak pol narö kësang lupönöök wëa. ");
INSERT INTO wer_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Pël ëaan urmerarö pit Yesuun ke urak epël kimang mëëa. “Ni ten wes nimëën polöröa öngpök ilenaan sën.” ");
INSERT INTO wer_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Pël maan Yesuuk kuure mak maan urmerarö pit omën pöpökaan oröak së polöröak ilëa. Pël ëën polörö pöömpö së parëaöök oröak së i kaöök ilëak i nak wel wia. Pol pörö selap 2000. ");
INSERT INTO wer_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Pël ëën pol ngarangkörö kas së kaare yang pörekë omën wëauröen ök më pet ira. Pël ëën omnarö itaampënëak sa. ");
INSERT INTO wer_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Pël ëak omnarö pit pöten itaampënëak Yesuu naë së oröak itaangkën omën urmerarö selap piikaan oröak sa pöp könö koirak poë koröp urak Yesuu naë wel aisëaan itenak kas ëa. ");
INSERT INTO wer_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Pël yaëën itenauröak omën urmerarö wakaima pöpë ngönteere polöröa ngönte poutepar ök mëëa. ");
INSERT INTO wer_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Pël ëën pit Yesu pitëm yanger sëp wesak sëpënëak ke urak mëëa. ");
INSERT INTO wer_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesu wangaöök yeilaan omën urmeraröaring wakaima pöp piiring sëpënëak ke urak mëëa. ");
INSERT INTO wer_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Pël yaëën Yesuuk ke mourak epël mëëa. “Nim kak së nimoröaring wë Aköpë nim naë retëng kaö elniak sant yaniwas pipta ngönte ök mam.” ");
INSERT INTO wer_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Maan omën pöp Tekapolis yangerak ka 10 pötë Yesuuk pim elmëa pöt pout ök maö sa. Pël ëën pit kat wiak yaan sa. ");
INSERT INTO wer_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Pël ëak Yesu pi wangaöök ilëak ëngk komuntakël së oröak i pisöök ngentiak wëën omën kësang pim naë së oröak wa top ëa. ");
INSERT INTO wer_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Pël yaëën ngönën tupta ngarangk namp yapinte Sairas pi Yesuu naë së pim ingrak tok oriak ");
INSERT INTO wer_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","kosang wesak epël mëëa. “Nem koontup wel wiipënëak yaë. Pötaanök ni wais moresi mor wëën ompyaö sak öp.” ");
INSERT INTO wer_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Pël maan kat wiak yesën omën kësang pan pim ënëm yesem pi il mowari yesa. ");
INSERT INTO wer_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Pël yaëën pitëm tekrak öng namp öng yauman ëeim wëën krismaki 12 ëak won saup wëa. ");
INSERT INTO wer_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Öng pöp rotaaröak ya mëngkën pangk naën om këlangön kat wieim wëa. Pël yeem pim sumat meneimën won sa. Pël ëën yaumante won nasën om ëeim wëa. ");
INSERT INTO wer_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Öng pöpök Yesuu yaauta ngönte kat wiak omnaröa tekrak wë Yesuu kasngaël së pim ulpëënëpök mësël elmëa. ");
INSERT INTO wer_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Pöt, “Ne om pim ulpëënëpök mësël elmëëma pöt ompyaö sumaat,” pël wesakök ëa. ");
INSERT INTO wer_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Pël elmëën tapëtakëër won sëën kat men ëën pim koröpö taë sa. ");
INSERT INTO wer_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Pël ëën Yesu pim weëre kosangö won yesem yaan kat men ëak omnaröa tekrak kaip tiak, “Talëpök nem ulpëënëpök mësël yaalnë,” mëak pëël mëëa. ");
INSERT INTO wer_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Maan ruuröak epël mëëa. “Omnarö selap wë naröak mök ë yanimëërek, ‘Talëpök neek mësël yaalnë?’ pël angan.” ");
INSERT INTO wer_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Yemaan Yesu pi pöt talëpök yaalmë pöt ëwat sëpënëak omnaröen it nalaan nal elmëa. ");
INSERT INTO wer_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Öngöp pi pöt pim koröpöök retëng oröa pöten itenak kas kön wiak reireë urak Yesuu naë së pim ingrak tok oriak pim songönte war wesak ök mëëa. ");
INSERT INTO wer_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Pël maan puuk epël mëëa. “Koontup aë, nimtë kön wi kosang yewesautak ompyaö yesën. Pötaanök ya kë sak së ompyaö öm.” ");
INSERT INTO wer_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Öng pöpön pël yamëem wëën omën narö ngarangkëpë kaatakaan së ngarangkëpön epël mëëa. “Nim koontup wel wiaarek këpök rë yanuulaup koirak waisngan.” ");
INSERT INTO wer_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Pël yemaan Yesu kat mowieë ngarangkëpön epël ök mëëa. “Kön selap ëënganëp om kön wi kosang newas.” ");
INSERT INTO wer_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Pël mëak omën muntaröen nga mëak Pitaare Semsre nangap Sonringörö pitëmënt sa. ");
INSERT INTO wer_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Së ngönën tupta ngarangkëpë kaatak oröak omën selap pan pit ingre këlël aö ngön kaëp kaö aim wëën itena. ");
INSERT INTO wer_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Pël ëak kakaati së omnaröen epël mëëa. “Ar tol ëënak ingre ya ilak aö epël yeë? Koontup wel nawiin om ka ura.” ");
INSERT INTO wer_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Pël yemaan sömre ëlak yeëa. Pël ëën pit koö ë mëën yaaröön ëlre pepaarring pim ruurö pëën koontupë wieëa pörek ilëa. ");
INSERT INTO wer_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Pël ëak koontupë moresi moröak epël mëëa. “Talita kumi.” Pöt tiarim ngöntak, “Koontup, ni wal ëëmëak yeniak,” pël apenaat. ");
INSERT INTO wer_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Maan tapëtakëër koontup wal ëak sak waisö ëa. Koont pöpë krismakiat 12 pël won saup. Pël ëën omnarö itenak yaan utpet sa. ");
INSERT INTO wer_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Pël yaëën omnaröen ök mepanëak kosang wesak nga mëak koontup kaömp mangkën nëmpënëak mëëa. ");
INSERT INTO wer_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu pi kaare yang pör sëp wesak pimtë ka songöntakël yesën pim ruurö ënëm sa. ");
INSERT INTO wer_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Së wëën ngëëngk akunet temanöm sëën ngönën tuptak së ngönën ök mëëa. Pël ëën omën selap kat wiak yaan sak epël mëëa. “Elei, omën epët tarëkaan orö morëa? Ëwat kësang eppel talëpök rë moula? Pël ëak pim retëng kaö yaaö pöt kaö panë maimal yaë. ");
INSERT INTO wer_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Tiar piin ëwat wë. Pi ka ök yarëaupë ruup. Pim ëlëp Maria. Yokot pim nangarö Semsre Yosep, Saimonre Yutas pörö. Ën koont pim nangaröeta tiarring wë.” Pël mëak piin kaaöre këëpöt elmëa. ");
INSERT INTO wer_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Pël yaëën Yesuuk epël mëëa. “Tektek ngön yaaö namp ka nantëëröak piin ping wesak yema. Pël yaautak pimtë kaare yangerak wëën piiring wëauröak kaö nasën wë wesak piin ping wesak nemaan ë yaë.” ");
INSERT INTO wer_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Kak pörekörö pitëm piin kön wi kosang nemowasën ëautaan ya retëng weëre kosangring nant kësang pitëm naë namëngkën ëa. Om yauman omën kopët nampnamp pim moresiar rangk mowiak ompyaö mowesa. ");
INSERT INTO wer_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Pël ëak pitëm piin kön wi kosang nemowasën ëa pötaan yaan sa. Yesu pi ka muntatë ngönën ök maö seima. ");
INSERT INTO wer_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Pël yeem pim ru 12 pöröen yas maan sëën urmerarö waö ë momëëpënëak weëre kosang menak ngës rëak kom ëak naar naar pël pël ëak wes momëa. ");
INSERT INTO wer_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Pël ëak kan kourakë omnant wak sëpanëak nga mëak sungkörat pëën wak sëpënëak mëëa. Kaömpre kërre monere pöt wak sëpanëak mëëa. ");
INSERT INTO wer_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ing körötökëër mëak ulpëënaarta pouwaar mëëpanëak nga mëëa. ");
INSERT INTO wer_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Pël mëak epël ök mëëa. “Kak nerek së oröak ka ilanë piptak pëën wë olëak oröak sën. ");
INSERT INTO wer_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Kak nerek së oröön ngöntre kar elniak arim ngönöt kat nawiin yaëën pöt kasëng menak ing porpor elmëak arim ingötëaan yangre ulölöt ka pöök kërë moolëak sëën pitëmtë songönöt kön wiipnaan.” ");
INSERT INTO wer_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Pël maan pit së lup kaip tiipënëak ngönën ök mëëa. ");
INSERT INTO wer_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Pël yeem urmerarö selap waö ë momëëre yauman yaaurö selap tapël i kolapöt wa momëak ompyaö mowasö pël ëa. ");
INSERT INTO wer_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Yesuu yaauta ngönte aö aö yesem yang omp ak Erot pim naë oröön kat wia. Omën naröak epël mëëa. “Omën pipop Son i yamëaup pi wel wiak wal ëaup yak weëre kosangring ya retëng pipot yamëngk.” ");
INSERT INTO wer_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Narëak Yesuun, “Elia,” pël mëëa. Ën naröak, “Pi tektek ngön yaaö ngaan wakaimauröa ök namp.” ");
INSERT INTO wer_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Pël yemaan Erot pi kat wiak epël mëëa. “Won, Son nem ngernger ilaup pi tapöpök weletakaan wal ëak wë.” ");
INSERT INTO wer_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Erot pi wet rëak pim nanëp Pilipë öngöp, Erotias, wa ëp ëa. Pötaanök Sonök Erotön epël ök mëëa. “Ni nim nanëpë öngöp wa ëp ëan pöt yok pangk naën.” Pël maan Erotök Sonë nga mëëa pötaan pi wali wak wii tëa. ");
INSERT INTO wer_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Erotias Sonë piin nga mëëautaan ya sangën kön wiak mëmpënëak kan ap wesak sëp wesa. ");
INSERT INTO wer_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Erot pi pöt Sonön kön wiin omën wotpilre ompyaup pël weseë piin kasinkasin ëak mait elmëa. Pël yaëën yak Erotias pi namëngkën ëa. Pël yaëën Erot pi Sonë ngönöt kat wiak ëngk ma e wesak kön selap ëa. Pël yeemak kat wiipnaataanta kent ëa. ");
INSERT INTO wer_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Wë ënëmak Erot pim wila akunet temanöm sëën pim ngarangköröere nga omën wotöököröere Kalili yangerakaan omën kaöarö wa top elmëak këëre kaömp mena. Pël yaëën Erotiasë Son mëmpna kanö oröa. ");
INSERT INTO wer_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Pit wa top ëak wëën Erotias pim koontup pitëm ëöetak së tan yaura. Pël yaëën Erotre piiring wëaurö itenak kent kön wia. Pël ëak Erotök koontupön epël mëëa. “Ni omën nenten kent ëën aan pöt nimpaat. ");
INSERT INTO wer_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Pël mëak Aköpë ëöetak kosang wesak epël mëëa. “Omën pasutön aan pöt nimpaat. Ën nem yangereta kom ëak kaö ner nimpëak aan pöt pangk nimpaat.” ");
INSERT INTO wer_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Pël maan koontup së ëlëpön epël mëak pëël mëëa. “Ne omën oröpötön mam?” Maan ëlëpök mëëa. “Son i yamëaup pim kepönöön ma.” ");
INSERT INTO wer_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Pël maan koontup pi pöömpö omp aköpë naë së epël mëëa. “Ni Son i yamëaup pim kepönö peene tapëtakëër söwarweri wiak nampëak kent yaë.” ");
INSERT INTO wer_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Pël maan omp aköp pi ya utpet kön wia. Pël ëaap kaöapre omën piiring wëauröa ëöetak ngön kosang wesak ök mëëa pötaan kuure mak mëëa. ");
INSERT INTO wer_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Pël ëak teënt nga omën namp Sonë kepönö wak waisëpënëak mëëa. Pël ëën pi wii kaatak së Son ngernger ilak ");
INSERT INTO wer_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","kepönö söwarweri wiak wak së koontup mangkën wak së pim ëlëp mena. ");
INSERT INTO wer_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Pël ëën Sonë ruurö kat wiak së sokur wak së yang kel weera. ");
INSERT INTO wer_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yesuu ngön yaaö omnarö ya nga ë im olëak kaalak së pim naë wa top ëak pitëm ya mëmpööre ngönën ök maö imautë ngönöt ök mëëa. ");
INSERT INTO wer_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Pël ë pet irën omën selap yesën yewaisën yaëën kë sëëre kaömp në ëëpna mopö won yaëën ruuröen epël mëëa. “Tiarimënt omën wonrek së kë sëpa.” ");
INSERT INTO wer_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Pël mëak pitëmënt wangaöök ilëak yang omën wonrekël sa. ");
INSERT INTO wer_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pël yaëën omën selap pitëmtok itenak ëwat sak ka poutëaan i kaö pouuk kan pöömpö së wet rëak oröa. ");
INSERT INTO wer_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Pël ëën Yesu pi wangaöökaan oröak omën selap pan wëën itenak sëpsëp pep wonöröa ök wakaima pötaan yaköm kön wiak ngës rëak ngönën ngönöt selap ök mëëa. ");
INSERT INTO wer_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Pël yaëën könöp wali yesën itenak ruuröak Yesuu naë së epël mëëa. “Tiar yang omën wonrek wëën könöp wali yesrek ");
INSERT INTO wer_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ni omnarö wes mëën ka wia pötë së kaömp sum ëak nëmp.” ");
INSERT INTO wer_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Maan Yesuuk epël mëëa. “Arök nant meneë.” Pël maan ruuröak mëëa. “Ten së 200 kina pötak kaömp sum ëak wais mampunëak yaan ma?” ");
INSERT INTO wer_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Maan epël mëëa. “Arim naë kaömp tolël ëak wiaarek së iteneë.” Maan pit së itenak, “Kaömp mor nas, ën i kaö imën kopët naar pël ëak wia,” pël mëëa. ");
INSERT INTO wer_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Pël ëën omnaröen nönö mö mëak rek mëak wel aisapënëak mëëa. ");
INSERT INTO wer_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Pël maan pit rek nemor 100, nemor 50 pël pël ëak wel aisëa. ");
INSERT INTO wer_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Pël ëën Yesu pi kaömp mor nas pötring i kaö imënaar wak kutömweriil iteneë Anutuun yowe mëak pelak omnarö kom ë mampënëak ruurö mena. Pël ëak i kaö imën pöaarta tapël kom ë mampënëak mena. ");
INSERT INTO wer_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Pël ëën pit pourö nak kep wesak ");
INSERT INTO wer_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","kaut olaan wak kër 12 pötë waulön peö ëa. ");
INSERT INTO wer_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Omën kaömp na pörö selap pan, ompörö 5000. ");
INSERT INTO wer_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Kaömp na pet irën tapëtakëër Yesuuk pim ruurö wes mëën wangaöök ilëak ëngk komuntak Pesaita kakël wet rëak yesën pimënt omnarö wes mëa. ");
INSERT INTO wer_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Pël ëën yesën pimënt Anutuun ök mapënëak rosiraöök isa. ");
INSERT INTO wer_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Pël ëën koö yoolaan wangaö i kaö luptak yesën pimënt wëa. ");
INSERT INTO wer_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Pël ëak pi itaangkën kentö sëpnaalaan yamöön pit weë ngentiak poprak yaëën ëlpam walëpënëak yaëën kaöökë roro së pitëm naë oröak il mowasëpënëak ëa. ");
INSERT INTO wer_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Pël yaëën pit itenak kas kësang ëak, “Elei, waötöp ëngk yewais,” pël mëak merëk ëa. ");
INSERT INTO wer_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Pit pourö itenak kas kësang ëën pël ëa. Pël yaëën teënt epël mëëa. “Nemtok yewaiserek kas ëëngan.” ");
INSERT INTO wer_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Pël mëak pitëm naë wangaöök ilaan kentö leng ëa. Pël ëën pit yaan sak ngön won sak wëa. ");
INSERT INTO wer_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Pöt kaömp mena pöta songönte ëngk ma e wesa pötaan pitëm lupöt om il wariak wëa. ");
INSERT INTO wer_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","I kaö olëak Kenesaret yangerak së oröak wangaö leng ë ulmëa. ");
INSERT INTO wer_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Pël ëën wangaöökaan yaaröön tapëtakëër omnarö Yesuun itenak ");
INSERT INTO wer_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","kaatë pöömpö së yaumanörö urötring wak Yesuu wëautëël kat wiak pötëël seima. ");
INSERT INTO wer_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Pël ëën ka kaöre kot Yesuu yesautë yauman omnarö wak së ka tomök mowiin pim ulpëën kautak pëën mësël ëak ompyaö sëpënëak këk mëëa. Pël maan omën pël ëa pörö ompyaö sa. ");
INSERT INTO wer_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Parisi ngönën omën naröere ngön kosangötë ngarangk narö Yerusalem kakaan Yesuu naë së wa rongan ëa. ");
INSERT INTO wer_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Pël yeem pim ruuröakaan narö kaömp nëmpënëak ngön kosangta wieëaul mor i nairën kewilring kaömp yenën itena. ");
INSERT INTO wer_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Parisiire Yuta omën pourö kaömp nëmpënëak pöt pitëm ëaröa ngön kosangta wieëaul mor iirakök yenaurö. ");
INSERT INTO wer_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Pötaanök sum yaaurekaan pitëm kaatë së oröak mor i nairën kaömp nanëmpan. Pöt pëën won kapre kelönre omnant pout iirak pitëm ëaröa ngön kosangta wieëaul yaaurö. ");
INSERT INTO wer_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Pötaanök Parisiire ngön kosangötë ngarangkörö pit Yesuun epël mëëa. “Nim ruurö pit tol ëënak tenim kaöaröa ngön kosangöt ilak pitëm moröt i nairën omnant wak yen?” ");
INSERT INTO wer_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Maan epël mëëa, “Kaar omnarö aë. Tektek ngön yaaö omën Aisaia pim ngaanëër arimëën ngön ëa pöt kë yaarö. Pöt epël. ‘Omën eporö pitëm këmötök neen yaya yanëem pitëm lupötök këëpöt yaalnëaurö. ");
INSERT INTO wer_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Pitëm ngönöt nem ngön këëta urtak wiak nener rë yemoulaurö. Pël yeem neen yaya yenëaan itaangkën mos ë yaë.’ ");
INSERT INTO wer_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ar Anutuu ngön kosangöt moolëak arimtë ngönöt kosang wesak wak wëaurö.” ");
INSERT INTO wer_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Pël mëak epël mëëa. “Arim ëaröa ngön kosangöt ulöl wesak aö imeë Anutuu ngön kosangöt utpet wesak komun yauraurö. ");
INSERT INTO wer_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mosesök kosang wesak epël ëa. ‘Nim ëlre pepaarë ngön ngar wak ompyaö elmë.’ Ën nenteta epël. ‘Omën namp pim ëlëpön ma pepapön utpet wesak mapna pöp mën wel wiip.’ ");
INSERT INTO wer_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Mosesök pël yaatak ar ngön epël yaaurö. ‘Namp pim ëlre pepaar omën nenten ap yewasën omën pim piarip kaamök elmëëpna pöt pim naë wiaan pöten, “Ne omën epët Anutuun yaö ëaup,” yemaan’ ");
INSERT INTO wer_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","arök pim ëlre pepaarë ikanöök wë kaamök elmëëpna pöt il yemowariaurö. ");
INSERT INTO wer_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ar pël yeem arim ëaröa ngön kosangötë ënëm yeë pötak Anutuu ngönte ke ur yoolak. Pël yeem omën utpet munt nantta yaaurö.” ");
INSERT INTO wer_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesu pi pël mëak kaalak omnaröen ngön maan sëën epël ök mëëa. “Ar pourö nem ngön ök niama epët kat wiak kön wi sokoleë. ");
INSERT INTO wer_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Omën nëën yaatak yes pipotök lupmer utpet newasën yaë. Lupmeriaan yaarö pötök lupmer utpet yewas. ");
INSERT INTO wer_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Katringëpök ngön epët kat wiip.” ");
INSERT INTO wer_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Pël mëak omnarö wëën kaata kakaati yesën ruuröak watepang ngön pötaan pëël mëëa. ");
INSERT INTO wer_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Pëël maan Yesuuk epël mëëa. “E, arta om köpël wëan ma? Omën nëën yaatak yes pipötök tol ëak lupmer utpet niwasëpën? ");
INSERT INTO wer_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Pipot lupmeri nasën, yaatak sëën ya yaar pöten ar köpël ma?” Yesu pim ngön pöt, yenautök utpet naniwaspan pël mëëa. ");
INSERT INTO wer_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Pël mëak yal menak epël mëëa. “Lupmeriilaan omnant apër yaarö pötök utpet yaniwas. ");
INSERT INTO wer_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Omën lupmeriaan yaarö pöt epot. Kön utpet, öngre omp nga yaaö, këkain, omën yamëngka, öngre omp wëwëet kom yaaö, ");
INSERT INTO wer_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","war, omën utpet panëët, morök, omën kewilringöt, keimön, omnaröen utpet wesak yaaut, iep inging, irikor. ");
INSERT INTO wer_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Omën utpet pipotök omën lupmeriilaan apër oröak lupmer utpet yaniwas.” ");
INSERT INTO wer_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesu kaare yang pör sëp wesak Taia kak naë së oröak ka nenta kakaati ilëak omnarö pim wëaut kat wiipanëak ëlëëp wëaap tol ëak ëlëëp öpën? ");
INSERT INTO wer_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Tapëtakëër öng namp pim wëaut kat wia. Öng pöp pim koontup lupmeri urmerap wëaup yak Yesuu naë së pim ingrak tok oria. ");
INSERT INTO wer_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Öng pöp pi maim Siria yangerak Pinisia yangerakaanëp. Pöpök pim koontupökaan urmerap waö ë mëëpënëak ke urak mëëa. ");
INSERT INTO wer_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Pël ëën Yesuuk epël mëëa. “Rungaarö kaömp nak kep ëëpënëak ëaut. Pötaanök rungaaröa kaömpöt wa ëp ëak kentörö nemangkën ë yaë pöl ni maimap kaamök naalniingan.” ");
INSERT INTO wer_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Pël maan öngöpök kangiir epël mëëa. “Aköp yaap yaan. Pël ëaap kentörö rungaarö kaömp yenën ikanöök wë lupöt ti ngentiin na yaë pöl ni kaamök elnë.” ");
INSERT INTO wer_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Pël maan Yesuuk epël mëëa. “Ni pil yaan nim koontupökaan waö ë yamëerek së.” ");
INSERT INTO wer_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Pël maan öngöp kaatak së itaangkën pim koontup urmerap piikaan oröak sëën ompyaö ka uraan itena. ");
INSERT INTO wer_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesu pi Taia kakaan kaip tiak Saiton kak il wesak Kalili i kaöökë naë Tekapolis yangerak ka 10 ëak wieëa pörek së oröa. ");
INSERT INTO wer_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Pël ëën omën ngön won katun namp pim naë mësak së mores rangk mowiipënëak ök mëëa. ");
INSERT INTO wer_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Pël ëën omën pöp omnaröa naëaan mop nentakël mësak së ulmëak pim mor wotö kat kanöök mowiak waasöp ngësak yangapöök wa momëak ");
INSERT INTO wer_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","kutömweriil iteneë ëm mëak omnampön epël mëëa, “Epata.” Tiarim ngöntak, “Kat kan të.” ");
INSERT INTO wer_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Maan katëëp kan tëën yangapööta kaip tiin ngön yaap ëa. ");
INSERT INTO wer_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Pël yaëën Yesu pi pöta ngönte kaö wesak apanëak nga mëëa. Pi kosang wesak yemaan pit ke ur moolëak aö sëën kaö sa. ");
INSERT INTO wer_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Pit yaan panë sak epël mëëa. “Omnant pout ompyaö wes pet yair. Katunörö kat nga mowasööre ngön wonörö ngön nga mowasö pël yaë.” ");
INSERT INTO wer_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Akun pötak omën kaö pan pim naë wa top ëak wë këën wëën ruuröen ngön mëak epël mëëa. ");
INSERT INTO wer_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ne omën kësang eporöen yaköm kön yawi. Pit neering wë kaömp nanën wëën kët nentepar nent ëak yes. ");
INSERT INTO wer_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Pit këën wes mëën pöt kan kourak yesem utpet ëëpnaat. Narö yang waliitëaan waisaurö.” ");
INSERT INTO wer_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Pël maan ruuröak epël mëëa. “Pultak wëep kaömpöt tarëkaan koirak omën selap eporö mangkën pangk ëëpën?” ");
INSERT INTO wer_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Pël maan Yesuuk, “Arim naë kaömp tolël ëak wia?” pël maan, “Kaömp 7,” pël mëëa. ");
INSERT INTO wer_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Pël maan omnarö wel aisapën mëak kaömp 7 pöt wak Anutuun yowe mëak pelak ruurö mangkën omnarö mena. ");
INSERT INTO wer_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Pël ëak i kaö imën kopët naar wieëa pöaar tapël wak yowe mëak omnarö mampënëak mëëa. ");
INSERT INTO wer_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Pël ëën omën pourö nak kep wesak kaut olaan wak kër 7 pötë waulön peö ëa. ");
INSERT INTO wer_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Omën kaömp na pörö selap pan, 4000. Nëën wes mëën kaalak yesën ");
INSERT INTO wer_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","tapëtakëër ruuröaring wangaöök ilëak Talmanuta yangerak së oröa. ");
INSERT INTO wer_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Pörek wëën Parisi omnarö Yesuu naë së oröak kutömweri retëng nent oröön itaampënëak morök elmëak këkre tö mëak piiring ngön nga ela. ");
INSERT INTO wer_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Pël ëën pi ya këlangönring ëm mëak epël mëëa. “Omën peene akun eptak wë eporö ar tol ëënak ya retëngët ëëmëak yak? Ne yaap niamaan kat wieë. Ne utpet ke piloro arimëën ya retëng nent naalniingan.” ");
INSERT INTO wer_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Pël mëak sëp wesak wangaöök ilëak ëngk komuntakël sa. ");
INSERT INTO wer_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Yesem ruurö kaömpöt kat kol wiak sa. Pël ëën om kopët nent wangaöök wieëa. ");
INSERT INTO wer_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Pël eaan Yesuuk pitën pepanöm mëak epël mëëa. “Ar Parisiire Erotë omnaröa yisötön ngarangk këëkë ëën.” ");
INSERT INTO wer_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Pël maan pitëmënt neneren epël mëëa. “Tiar kaömp peretöt wak newaisën ëautaan epël yenia.” ");
INSERT INTO wer_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Pitëmënt pël yaan kat men ëak epël mëëa. “Kaömp peretöt kat kol wiak waisan pöten tol ëën neneren yemak? Ar songönten ëwat nasën ma? Ar kön tektek nasën wë ma? ");
INSERT INTO wer_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ar iteneëak omnant këëkë itnaangkën ëëre katöt wëak ngönöt këëkë kat nawiin yeë ma? Nem omnant yeë pöten kat kolak wë ma? ");
INSERT INTO wer_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ne kaömp 5 pöt kom ëak omën 5000 pörö mangkën nëën kaut om wiaan wak kër tol ëak waulön peö ëa?” Pëël maan, “12,” mëëa. ");
INSERT INTO wer_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ën kaömp 7 ëak kom ëak omën 4000 pörö mangkën nëën kaut om wiaan kër tol ëak waulön peö ëa?” Pëël maan, “7,” mëëa. ");
INSERT INTO wer_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Pël maan epël mëëa. “Pöten ar om kön tektek nasën wë ma?” ");
INSERT INTO wer_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesure ruurö Pesaita kak së oröak wëën omën naröak omën it il tëa namp Yesuu naë wak së mësël elmëëpënëak ke urak mëëa. ");
INSERT INTO wer_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Pël ëën omën it il tëaupë moresi wak kaöökë wilëngkëël së ulmëak itöörarë waasöp mongësak mores kepönöök mowiak pëël mëëa. “Omnantön ityaangkën ma?” ");
INSERT INTO wer_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Maan it il tëaupök it ngaulak epël mëëa, “Ne omnaröen itaangkën këraatë ökörö sak waisak yaë.” ");
INSERT INTO wer_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Pël maan Yesuuk pim mores itöörarë mowiin ompyaö sa. Ompyaö sak itöörar nga ngëna. Pël ëak omnant kamaarekre naë wieëa poutön këëkë pan itena. ");
INSERT INTO wer_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Pël ëën Yesuuk, “Ka epöök ilangan,” pël mëak pim kaatakë wes mëën sa. ");
INSERT INTO wer_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu pi pim ruurö koirak Sisaria Pilipai kakë naë ka kot wieëa pötëël sa. Kamtaöök yesem Yesuuk epël mëak pëël mëëa. “Omnarö neen talëp aim?” ");
INSERT INTO wer_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Pël maan epël mëëa. “Naröak niin, ‘Son i yamëaup,’ pël yaan naröak, ‘Elia,’ naröak ‘Tektek ngön yaaö namp wes,’ pël aim.” ");
INSERT INTO wer_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Pël maan epël mëëa. “Ën arimtok pöt neen talëp aim?” Pël maan Pitaak epël mëëa. “Ni Kristo, Anutuuk Yaö Niiaup.” ");
INSERT INTO wer_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Pël maan omnaröen pim songönte ök mapanëak nga mëëa. ");
INSERT INTO wer_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Akun pötak Yesuuk ngës rëak war wesak epël mëëa. “Omën Këëp ne wë ënëmak këlangön kësang kat newiire ngarangkre kiri ar yaaö kaöaröere ngön kosangöte ngarangkörö pit kasëng nemenak nemëngkën wel wiak kët nentepar nent yangaöök wieë wal ëëmaap.” ");
INSERT INTO wer_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ngön pöt war wesak ök mëëa. Pël ëën Pitaak pëëntak koirak së ngës rëak nga mëëa. ");
INSERT INTO wer_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Pël ëën kaip ti ruuröa ngësël iteneë Pitaan nga mëak epël mëëa. “Seten, ni sëp newesak së kan newariingan. Nim yaan pipët Anutuu ngönte won, omën ngönte.” ");
INSERT INTO wer_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Yesu pi omën selap pörek wëauröere pim ruurö wa top ë ulmëak epël ök mëëa. “Omën namp pi nem ënëm elnëëpënëak pöt pimtë könöökë kentöt këëpöt weseë, ‘Ne Yesu pimëën wel wiima pöt pangk ëëmaap,’ pël wesak pim këra yetapër waalak nem ënëm elnëëp. ");
INSERT INTO wer_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Namp pim wëwëet keimön ëak öpna pöt pim wëwëet kö sëpnaat. Ën namp nemëënre nem ngön ompyautaan yak wëwëet këëpöt wasëpna pöt pim wëwëet orö morëëpnaat. ");
INSERT INTO wer_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ën namp yangerakë omnant pout kent ëak weim wëën pötök pim wëwë ompyaut utpet mowasën won sëën omën pötök tolëël kaamök elmëëpën? Pël naëpan. ");
INSERT INTO wer_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ma namp pim wëwë ompyaut kaalak öpënëak pöt öröpöt kangiir mampën? ");
INSERT INTO wer_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Namp pi omën utpet ëak Anutuun kön wi kosang newasën yaaö eporöa tekrak wë nemëntre nem ngönëntaan kön wiin ëö ëëpna pöp pi Omën Këëp nook nem Pepapë ëwaö nem rangk wiaan nem ensel ngëëngkörö koirak wais oröak piin kaaö elmëëmaap. ");
INSERT INTO wer_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ne yaap pan niamaan. E taua eporö arëkaan narö wel nawin wëën Anutuu wa ngaöök nimëëpna pöt weëre kosangring yaaröön itaampun sa.” ");
INSERT INTO wer_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Kët 6 ëak won sëën Yesu pi Pitaare Semsre pim nangap Son pörö koirak rosir wali naöök së pitëmënt wakaima. Pël ëak pi pitëm ëöetak möönre koröp maim wa. ");
INSERT INTO wer_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ulpëënëp kölam panë tëën ëwa elmëa. Pöt yang omnaröa naënganëël ëa. ");
INSERT INTO wer_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Pël ëën pit itaangkën Eliaare Moses piarip oröak Yesuring ngönaak yeem wëa. ");
INSERT INTO wer_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pël yaëën Pita pi köpël yak Yesuun köntak epël mëëa. “Kaöap, ten eprek wëën ompyaö yaë. Pötaan ka kot nentepar nent ëak ök renaan, nent nimëën, nent Mosesëën, nent Eliaëën ëak.” ");
INSERT INTO wer_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ruurö pit yaan sak reireë yaurem Pita pi köntak pël mëëa. ");
INSERT INTO wer_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Pël yaëën tapët pöt uröam kölam ëwa nempel irë kaka elmëën Anutuuk uröamta öngpökaan epël mëëa. “Epop nem Ruup. Ar pim ngönte kat wiin.” ");
INSERT INTO wer_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Pël maan pit it nalaan nal ëak itena pöt Yesu pimënt wëa. ");
INSERT INTO wer_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Pit rosiraöökaan yeirëem Yesuuk pitën pepanöm epël mëëa. “Arim omën it köpëlöt ityaangk pöten omnaröen peene ök mangan. Ënëmak Omën Këëp ne weletakaan wal ëënak omnaröen ök man.” ");
INSERT INTO wer_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Maan ruurö pit ngön pöt yak wesak wë pitëmënt neneren epël mëëa. “Weletakaan wal ëëpna pöt tol nent?” ");
INSERT INTO wer_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Pël mëak Yesuun epël mëak pëël mëëa. “Elia wet rëak waisëpnaap ngön kosangötë ngarangkörö pit tol ëënak pël aim?” ");
INSERT INTO wer_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Pëël maan epël ök mëëa. “Yaap, Elia pi wet rëak oröak Anutuu Yaö Neeaup nemëën omnant kopëta wasëpënëak ëaut. Pötaanök ‘Omën Këëpön utpet wesak mëak këlangön kat mowiipnaat,’ ngönëntak pël retëng ëa pöta songönte tol nent? ");
INSERT INTO wer_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Eliaan pöt epël ök yeniak. Pi yok oröak wëën omnaröak pitëm kentöök utpet mowasëpënëak ngönëntak ëa pöl elmëaup.” ");
INSERT INTO wer_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Pit rosiraöökaan ru muntaröa naë së itaangkën omën selap pitëm naë oröak wëën ngön kosangötë ngarangk narö pitring ngön nga yaalem wëa. ");
INSERT INTO wer_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Pël yaëën omën pörö Yesuun itenak yaan sak tapëtakëër së koirak yoöre ërëp mëëa. ");
INSERT INTO wer_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Pël ëën pi epël mëak pëël mëëa. “Ar tol ëënak ngön nga yaal?” ");
INSERT INTO wer_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Maan omën pöröakaan nampök oröak epël mëëa. “Rë yanuulaup, urmer ngön won sa nampök nem yokotup utpet yemowasënak wak yewais. ");
INSERT INTO wer_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Yokot epop urmerapök kët ël epotë mök ë moolaan ngentiak këmtakaan kepop yaaröem këët nampnamp mënak ingre mor kosang sak wiaakë yaë. Pël yaëën nim ruuröa naë wak wais waö ëëpënëak ök maan pit ök ëën pangk naën yaë.” ");
INSERT INTO wer_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Maan Yesuuk epël ök mëëa. “O omën kön wi kosang yewesaut wonörö, aë. Ar neen kön wi kosang nenewasën yeem kön wiin akun tolëël arring wë arim könömöt weim öm? Yokotup nem naë wak waiseë.” ");
INSERT INTO wer_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Pël maan yokotup wak yesën urmerap Yesuun itenak tapëtakëër yokotup mök ë yangerak moolaan rikrik yaurem wieë kepop yangësa. ");
INSERT INTO wer_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Pël yaëën Yesuuk pepapön epël mëak pëël mëëa. “Epët akun taltak orö morëa?” Maan pepapök epël ök mëëa. “Kotuukëër. ");
INSERT INTO wer_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Urmer epop yokotup utpet wasëpënëak esuwesiire imeri wa yemoolëaup. Ni pöta weëre kosang wiaan pöt tenipön yaköm kön niwiak kaamök elni.” ");
INSERT INTO wer_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Maan Yesuuk epël mëëa. “Weëre kosangtaan yaan. Pötaan niamaan kat wi. Namp pi kön wi kosang yewesautaring öpna pöp omnant pout yok pangk ëëpnaap.” ");
INSERT INTO wer_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Pël maan tapëtakëër rungaapë pepapök ngön ë olëak epël mëëa. “Ne kot nent kön wi kosang yaniwas. Nimtok nem kön wi kosang yewesaut wiapre kor epët kosang newas.” ");
INSERT INTO wer_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Pël yemaan Yesuuk omën selap pim naë së yaaröön urmerapön nga mëak epël mëëa. “Ngön won katun epop, ngön kosang yeniak. Ni oröak kama së kaalak waisngan.” ");
INSERT INTO wer_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Pël maan urmerap ngön kaëpëër oröak sëpënëak yokotup wa moolaan ngentiak wel ök wiak wieëa. Pël ëaan omnarö itenak, “Wel wia,” pël mëëa. ");
INSERT INTO wer_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Pël yemaan Yesuuk yokotup moresi moröak wal ë tau moulmëa. ");
INSERT INTO wer_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Pël ëak kaata kakaati yeilaan pim ruurö pëëntak së epël mëak pëël mëëa. “Ten tol ëak waö elmëënëak poprak ëan?” ");
INSERT INTO wer_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Maan epël ök mëëa. “Urmer ke pipëlörö omën nentak won, kimang ngöntak waö ë momëët.” ");
INSERT INTO wer_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Pit yang pör sëp wesak Kalili yangerak së oröak sa. Pöt omnarö piin kat wiipanëak ëlëëp sa. ");
INSERT INTO wer_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Yesem ruuröen epël mëak rë moula. “Omnaröak Omën Këëp ne ngaaröa moresi neulëën pit nemëngkën ket nentepar nent won sëën kaalak weletakaan wal ëëmaap.” ");
INSERT INTO wer_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Pël maan pit ngön pöt kat wiak ëngk ma e ëën pëël mapënëak ëak kas ëën sëp wesa. ");
INSERT INTO wer_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Pël ëën yesem Kapaneam kak së oröa. Pël ëak kakaati së ruuröen pëël mëëa. “Ar kamtaöök oröpmorëënök neneren mëëaurö?” ");
INSERT INTO wer_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Pël maan pit om ngön won sak wëa. Pöt pit kamtaöök yesem, “Talëpök wotöök wë,” pël mëak neneren maö seima pötaanök. ");
INSERT INTO wer_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Pël ëën wel aisëak ruurö wa top elmëak epël ök mëëa. “Namp pi wotöök öpënëak pöt muntaröa kasngaël wë inëën elmëëp.” ");
INSERT INTO wer_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Pël mëak runga kot namp wak pitëm tekrak tau moulmëak moresök kaamök elmëeë epël mëëa. ");
INSERT INTO wer_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Omën nemëën yak runga kot ke epëlëp sant elmëëpna pipop ne sant elnëëpnaap. Neen sant elnëëpa pöpök nemënt won, nem wes nemëaupönta sant elmëëpnaap.” ");
INSERT INTO wer_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Sonök Yesuun epël mëëa. “Rë yanuulaup, ten itaangkën omën namp nim yapintak urmerarö waö ë yamëën itenaut. Pël ëaupök omën pöp tiarim ënëm naën yaë. Pötaanök tenök pël ëëpanëak kan mowariaut.” ");
INSERT INTO wer_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Maan Yesuuk epël mëëa. “Kan mowariingan. Namp nem yapintak retëng ke pipëlöt yaaupök tol ëak kengkën sak neen utpet wesak apën? ");
INSERT INTO wer_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Tiarim yaat komun naurön ëëpnaapök tiarim karip kaamök yaalniaup pël sak öpnaap. ");
INSERT INTO wer_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ne yaap niamaan. Nampök ar Kristoë omnarö pël wesak i pëënte nimpna pöt kangit won naëpan. ");
INSERT INTO wer_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Namp pi kot ke epëlöröakaan namp neen kön wi kosang yewesaupön këk maan pim kön wi kosang yewesaut sëp wasëpënëak yaëën pöt pël ëëpanëën naröak wet rëak kël kësangö pim mesetak öngö moutak i kaöök moolaan i nak wel wiipna pöt pangk ëëpnaat. Pöt omën pöpök maan kot ke epëlöröa namp pim kön wi kosang yewesaut sëp wasën pöt kangiir utpet kaö panëët pim naë orööpnaat. ");
INSERT INTO wer_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Pël ëak nim moresök utpet nent koirën pöt il olam. Mor kopëtasring wëwë kosangtak ömë pöt ompyaö. Pouwesiarring wëën Anutuuk parëaöök es kosangwesi niolaan pangk naën ëëpnaat. ");
INSERT INTO wer_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Parëaöökë ngëëpörö wel nawiipanëërö. Esuwesta nariinwes. ");
INSERT INTO wer_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ma nim ingesök utpet nent koirën pöt il olam. Ing kopëtasring wëwë kosangtak ömë pöt ompyaö. Pouwesiarring wëën Anutuuk es parëaöök niolaan pangk naën ëëpnaat. ");
INSERT INTO wer_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Parëaöökë ngëëpörö wel nawiipanëërö. Esuwesta nariinwes. ");
INSERT INTO wer_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ën omën nim itöök itaampëëtak weru nuulaan utpet ëëmëak yeem pöt it pö ur olam. It kopët naööring Anutuu wa ngaöök yanimë pötak ömë pöt ompyaö. Pourarring wëën Anutuuk es parëaöök wa niolaan pangk naën ëëpnaat. ");
INSERT INTO wer_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Parëaöökë ngëëpörö wel nawiipanëërö. Esuwesta nariinwes. ");
INSERT INTO wer_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Tomunat yenautë yoola pöl esuwesök omën pouröa rangk olapnaat. ");
INSERT INTO wer_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Tomun pöt ompyaut. Pël ëautak pim misëngö won sak wiaan tol ëak kaalak misëng wasën pangk ëëpën? Ar tomuneta ök sak wë neneraan mayaap ëeim ön.” ");
INSERT INTO wer_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu pi pörekaan Yutia yangerere Yotan ëngk komuntakël së oröa. Pël ëak pörek wëën omën selap pan kaalak pim naë së oröa. Pël ëën pim yaaö pöl kaalak ngönën ök mëak rë moula. ");
INSERT INTO wer_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Pël yaëën Parisi naröak së morök elmëak pëël mëëa. “Omën namp pim öngöp wes mëën pangk ëëpën ma?” ");
INSERT INTO wer_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Maan Yesuuk epël mëëa. “Moses pi pöta ngönte tolëël niia?” ");
INSERT INTO wer_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Pël maan pit epël mëëa. “Namp wes mëëpënëak pöt pep kosangwer menak wes mëëpnaat. Moses pi pötaan kuure mak niiaut.” ");
INSERT INTO wer_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Maan Yesuuk epël mëëa. “Moses pi arimtë lup kosang yaautaan yak ngön kosang pipët retëng ë nina. ");
INSERT INTO wer_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pël ëaap songöntak Anutuuk omën ket ëëpënëak öngre omp pouwaar ket ë ulmëa. ");
INSERT INTO wer_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Pël ëa pötaanök omp namp pim ëlre pepaar sëp wesak öngöpë naë rë olaan ");
INSERT INTO wer_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","piarip möönre koröp kopët naö pël sak wë. Ngönte pël wia pötaanök piarip pouwaar won, kopëtap pël sak wë. ");
INSERT INTO wer_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Anutuuk erën ë ulmëa pötaanök omnaröak pangk kom naëngan.” ");
INSERT INTO wer_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Pël mëak kakaati së wë ruuröak Yesuun tapten pëël maan ");
INSERT INTO wer_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","songönte epël ök mëëa. “Omp namp pim öngöp wes mëak muntap öpna pöp pi öngre omp wëwëet kom ëak saun koirëpnaap. ");
INSERT INTO wer_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ën öng namp pim ompöp sëp wesak muntap koirëpnaap pi tapël öngre omp wëwëet kom ëak saun koirëpnaap.” ");
INSERT INTO wer_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Omnarö pitëm rungaarö Yesuuk pim mores pitëm rangk mowiak welaköt elmëëpënëak wak yesën pim ruuröak pitën nga mëëa. ");
INSERT INTO wer_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Pël yaëën pi itenak kön wiin utpet sëën ya këlangön kön wiak epël mëëa. “Nga mangan. Wes mëën naë waisëp. Ke pilorö Anutuuk wa ngaöök momëëpënëak yaö yema pötaanök. ");
INSERT INTO wer_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ne yaap niamaan. Namp pi runga kot eporöa Anutuun kön wi kosang yewesa pöl naën ëëpna pöt Anutuu wa ngaöök yamëautak yok pangk neilaan ëëpnaat.” ");
INSERT INTO wer_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Pël mëak pit moröeë pim mores pitëm rangk mowiak welaköt elmëa. ");
INSERT INTO wer_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu pi pörek sëp wesak sëpënëak yaëën omën namp pöömpö së pim naë oröak ingrak tok oriak epël mëak pëël mëëa. “Tenim rë yanuula ompyaup, ne tol ëak wëwë kosangta yaö sum?” ");
INSERT INTO wer_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Maan Yesuuk epël mëëa? “Tol ëënak neen, “Ompyaup,” pël yenëaan? Anutu kopëtapökëër ompyaup. ");
INSERT INTO wer_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ni ngön kosangöt epël kat yawiaup. Ni omën mëngkanok. Öngre omp wëwëet kom ëënganok. Ni këkain ëënganok. Ni omën muntaröen kaar manganok. Ni muntarö morök elmëak pitëm omnant wa ëp ëënganok. Ni nim ëlre pepaarë ngön ngar öm.” ");
INSERT INTO wer_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Pël maan omnamp pi mëëa. “Rë yanuulaup, pipot pout nem kotuukaan ë waiseimaut.” ");
INSERT INTO wer_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Pël maan Yesu pi pöpön iteneë piin kent ëën epël ök mëëa. “Kopët nent wia pöt ëëm. Ni së nim omnant menak sumat wak omën omnant wonörö këëpöt wes man. Pël ëën kutömweri omnant kosangöt orö nirëëpnaan. Pël ëak wais nem ënëm elnë.” ");
INSERT INTO wer_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Pël maan omnamp pi urömere kaar es kësang wieëaup yak këëpöt sak ya utpetaring sa. ");
INSERT INTO wer_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesën Yesu kaip ti ruuröen iteneë epël ök mëëa. “Omën monere uröm kaö wieëaurö Anutuu wa ngaöök yamë pötak ilapënëak pomp ë yaë.” ");
INSERT INTO wer_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Pël maan ruurö pit ngön pöt kat wiak yaan sak yaëën kaalak rangk epël mëëa. “Nem ruurö, Anutuu wa ngaöök yanimë pötak yeila pöt omën könöm panëët. ");
INSERT INTO wer_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Pol kamel namp yok pangk wap poë koröp korir yamë pöökë kanöök ilapna pöt kengkën. Ën omën monere uröm kësang wieëauröak Anutuu wa ngaöök yamë pötak ilapna pöt könöm panëët.” ");
INSERT INTO wer_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Pël maan ruurö pit kat wiak yaan panë sak epël mëëa. “Omën ke pilörö Anutuu wa ngaöök yamëautak neilaan ëëpna pöt omën tolëëlëpök wëwë kosangtak öpën?” ");
INSERT INTO wer_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Maan ruuröen it kos ëeë epël mëëa. “Omnaröak pangk naëngan. Pël ëënëëtak Anutu ke nentere nent yaaupök omën ke pilötë kanöt koirëpnaataan poprak naëpan.” ");
INSERT INTO wer_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pita pi ngön pöt kat wiak Yesuun epël mëëa. “Kat wi. Ten omnant pout sëp wesak nim ënëm elniaut.” ");
INSERT INTO wer_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Maan Yesuuk epël mëëa. “Ne yaap niamaan. Namp pi kaare yang, sasre nan, ëlre pep, koröngre ru, ëmre ya pöt nemëënre nem ngön ompyautaan yak sëp wasëpna pöp ");
INSERT INTO wer_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","pi omën kangut kësang pan öpnaap. E yangerak wë kaare yang, sasre nan, ëlre pep, koröngre ru, ëmre ya omën pipot kööre tokë rangk orö morëëpnaat. Pël ëak wë ënëmak akun kaöaöök wëwë kosangët öpnaap. ");
INSERT INTO wer_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Pël ëak pöt wetëëröakaan selap ënëm rapnaat. Ën ënëmaröakaan selap wetë rapnaat.” ");
INSERT INTO wer_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Pël mëak kan yesem Yesuuk wet rëak Yerusalemë kanöököl yesën sa. Pël yeem pöl ko wesak yesën pit yaan sa. Pël ëak ënëm imaurekaan kas kön wial sa. Pël yaëën pim ru 12 pöröen pëlëër wa top elmëak omnant pim naë orööpnaatön war wesak epël ök mëëa. ");
INSERT INTO wer_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Kat wieë. Tiar peene Yerusalem kakë yewais. Pörek sëën Omën Këëp ne omnaröak kiri ar yaaö kaöaröere ngön kosangötë ngarangköröa naë neulëën pit ngön yaatak ne wel wiimëak neak ngönën köpëlöröa naë wes nemëën ");
INSERT INTO wer_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","pitök ökre was neak waasöp ngës nenak pës nemöak këra yetaprak nemöön wel wiak akun nentepar nent won sëën kaalak wal ëëmaap.” ");
INSERT INTO wer_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sepetii ruaar, Semsre Son, piarip Yesuu naë së epël mëëa. “Rë yanuulaup, tenip omën nenten kimang niaan nimpëak kent kön yawi.” ");
INSERT INTO wer_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Maan, “Tol elniimëak yak?” mëak pëël mëëa. ");
INSERT INTO wer_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Pël maan piarip epël mëëa. “Ni kat wiin wë ënëmak nim weëre kosang ierre kasiröök tenip nim kopirarë, namp yaapkëël namp katnëël, wel aisëeë ngarangk öpenaat.” ");
INSERT INTO wer_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Pël maan Yesuuk epël mëëa. “Arpim yenëak pöta songönte arip köpël wë. Ne kelöntak i kakam yaaut yen pöl këlangön kësang kat wiimaap. Pöt arip pangk ëënëëwaar ma? Ën omnaröak i yanimë pöl këlangön kësang kat newiipnaap. Pöt arip pangk ëënëëwaar ma?” ");
INSERT INTO wer_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Maan epël mëëa. “Yok pangk pël ëënaawaar.” Maan Yesuuk epël mëëa. “Nem i kakam numa pöt arip yaap nënëëwaar. Ën i nemëëpna pöt yaap pël ëënëëwaar. ");
INSERT INTO wer_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pël ëënëëtak nem kopirarë yaapkëëlaan katnëël wel aisapnaata ngönte nook naëngan. Pël ëëpënëak yaö mëëauröakëër wel aisapnaat.” ");
INSERT INTO wer_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Pël yaëën ru munt 10 pörö kat wiak Semsre Son piaripön kön wiin utpet ëa. ");
INSERT INTO wer_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Pël yaëën Yesuuk wa top elmëak epël ök mëëa. “Yang nantë omp akörö pitëm omnarö nga ëak ngarangk yaalmë. Pël yeem pitëm ikanöök ngarangk narö moulmëën pitta tapël omnarö ngarangk yaalmë. ");
INSERT INTO wer_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Arim naë pël orööpan. Arëkaan namp kaö sak öpënëak pöt ar pouröa inëën elniip. ");
INSERT INTO wer_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ën arëkaan namp arim wotöök sëpënëak pöt pi kot panë sak ar pouröa inëën panë elniip. ");
INSERT INTO wer_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Pi nem yeë epël ëëp. Omën Këëp ne arök inëën elnëënëak neiraan. Nemtok inëën yaat mënak omën pouröa kangiir nem wëwëet këëpöt wes nimpëak irëaup.” ");
INSERT INTO wer_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yesure ruurö kak së oröak ka pö il wesak yesën pitëm ënëm omën kësang sa. Pël yaëën omën il tëa omnant won namp kan ëöök wel aisëak wëa, yapinte Patimias Timiasë ruup, ");
INSERT INTO wer_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","puuk, “Yesu Nasaret kakaanëp yes,” yemaan kat wiak ngës rëak ngön ë olëak epël mëëa. “Yesu Tewitë ëap, ni neen yaköm kön newi.” ");
INSERT INTO wer_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Pël yemaan omnaröak leng ëëpën mëak nga yemaan pi kat nemowiin ke urak kaalak ngön ëak epël mëëa. “Ni Tewitë ëapök neen yaköm kön newi.” ");
INSERT INTO wer_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ngön yemaan Yesu kat wiak kamtaöök leng ëak taueë epël mëëa. “Maan waisëp.” Pël maan omnaröak it il tëaupön epël mëëa. “Ngön yeniaarek kosang sak wal ëak wais.” ");
INSERT INTO wer_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Pël maan pi ngön pöt kat wiak tapëtakëër pim kelte er olëak wal ëak Yesuu naë sa. ");
INSERT INTO wer_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Së oröön epël mëak pëël mëëa. “Tol elniimëak yaan?” Maan it il tëaupök epël mëëa. “Aköp, ni aan ne it nga sum.” ");
INSERT INTO wer_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Maan Yesuuk epël ök mëëa. “Nimtë kön wi kosang yewesautak ompyaö yesënrek së.” Pël yemaan tapëtakëër itöörar nga sëën Yesuu ënëm sa. ");
INSERT INTO wer_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Pörekaan yesem Yerusalem kak temanöm wesak Olip rosiraöök Petepasiire Petani ka pöteparë së oröak Yesuuk ru naar wes mëak ");
INSERT INTO wer_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","epël mëëa. “Arip ka ëngköök së oröak tapëtakëër itaangkën pol tongki ru namp omnaröa wel naisaanëp wii ngan ë ulmëën öpna pipop wilak mësak waisën. ");
INSERT INTO wer_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Yawilën omën nampök aripön, ‘Oröp ëënëak yeë?’ pël yeniaan pöt epël man. ‘Aköpök epopön ya. Teënt kaalak wes mëën waisëpnaat.’” ");
INSERT INTO wer_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Pël maan ruaar piarip së pol tongki ruup ka kanrak temanöm wii të ulmëën wëën koirak wila. ");
INSERT INTO wer_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Yawilën omën pörek wëauröak itenak epël mëëa “Aë, arip tol ëënëak yawil?” ");
INSERT INTO wer_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Pël yemaan Yesuu ngön mëëa pöt ök maan kat wia. ");
INSERT INTO wer_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Pël ëën Yesuu naë mësak së pitëm ulpëënörö përëak rangk wiin Yesu wel aisëa. ");
INSERT INTO wer_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Pël ëën omën selap pitëm ulpëënöt përëak kamtaöök mourö yesën naröak ya lupöök së kewisat ilak këëmre kewis elmë sa. ");
INSERT INTO wer_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Pël ëak omën selap, narö wetëëre narö ënëm, pël yeem ngön ëak epël maö sa. “Yowe. Aköpë këm ngöntak yewais epopön yaya mepa. ");
INSERT INTO wer_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Tiarim ëap Tewit pim wa ngaöök mëa pöta ököt orööpënëak yaë. Pötaan ërëpsawi ëëpa. Anutu ngaarëk wëaup, yowe.” ");
INSERT INTO wer_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Pël elmë Yerusalem kak së oröak Yesu pi ngönën tup kaöeta kakaati së ilëak omnant itenak ëwat sak yanget wiap yoolaan pim ru 12 pörö koirak Petani kakë sa. ");
INSERT INTO wer_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ëlpamök Petani kakaan wal ëak yesem Yesu këën elmëa. ");
INSERT INTO wer_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Pël ëën kamaarekaan itaangkën kem nement ëp wileëa. Pël ëën uta wesak naë së ap wesa. Ulöp yauta akunet temanöm nasën yak ëpöt pëën wëa. ");
INSERT INTO wer_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Pël ëën itenak epël mëëa. “Niikaan ulöpörö utön omnarö kaalak nanën panë ëëpnaat.” Pël yemaan ngön pöt pim ruurö kat wia. ");
INSERT INTO wer_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Pël ëak Yerusalem kak së oröak Yesu pi ngönën tup kaöeta kakaati së itaangkën omnarö omnant ngawi yeem wëën itenak pit waö ë momëak omën mon ngawingawi yaauröa urötere omën int ekörö menak sum yewauröa uröt kaip ti moolëa. ");
INSERT INTO wer_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Pël elmëak ngönën tup kaöetak omën ke pilöt wak sëpanëak nga mëëa. ");
INSERT INTO wer_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Pël elmëak epël mëëa. “Ngönën pepeweri Anutuuk epël ëa. ‘Nem tup pipten yang ël epotë omnaröa kimang yenëa kaat pël apnaat.’ Ar pipël yaëën këkain yaauröa kaata ök yes.” ");
INSERT INTO wer_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Pël yaëën kiri ar yaaö kaöaröere ngön kosangötë ngarangkörö pit itenak, “Tol ëak mëngkën won sëpën?” pël mëak neneren mëëa. Pël ëak, “Omën pourö pim ngönëntaan yaan sak yaaurö,” pël mëak kas ëën sëp wesa. ");
INSERT INTO wer_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Pël ëak wiap kan Yesure ruurö pit ka kësangö sëp wesak sa. ");
INSERT INTO wer_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ëlpamök kemmenti wëa pörek kaalak së itaangkën këra pöment umön rëak wëa, misënötëaan ëpötë pout. ");
INSERT INTO wer_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pël ëën Pita itenak ngön mëëa pöt kön wiak epël mëëa. “Aköp itan. Këra kem nim umön rapënëak mëan pöment umön rëak wëëp.” ");
INSERT INTO wer_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Pël maan Yesuuk epël mëëa. “Ar Anutuun kön wi kosang weseim ön. ");
INSERT INTO wer_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ne yaap niamaan. Nampök tomön epöön, ‘Tiak i kaöökël së orö,’ pël yamëem kön selap ëak yok pangk pël ëëpën ma won pël kön nawiin pim ök mëëa pöt kë orööpnaat pël kön wi kosang wasëpna pöt kë orööpnaat. ");
INSERT INTO wer_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Pötaanök ök niamaan. Ar omën nentaan kön wiak Anutuun kimang manë pöt, ‘Yok wa,’ pël weseë kön kosang yawiin orö nirëëpnaat. ");
INSERT INTO wer_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Kimang manëak omën nampë saunat arim naë wiaan pöt won wes moolan. Pël yaëën arim Pep kutömweri wë pöpök arimot tapël ent ë nuulapnaat. ");
INSERT INTO wer_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ën ar omnaröa saunat won wes nemoolan ëënë pöt Pep kutömweri wë pöpök arimot nemoolaan ëëpnaat.” ");
INSERT INTO wer_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yesure ruurö pit kaalak Yerusalem kak së oröak Yesu ngönën tup kaöeta kakaati së wëën kiri ar yaaö kaöaröere ngön kosangötë ngarangköröere kaöarö pit pim naë së oröak ");
INSERT INTO wer_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","epël mëak pëël mëëa. “Nim eprek ë yaën pipot talëpë këm ngöntak ëeimën? Talëpök pël ëëm niia?” ");
INSERT INTO wer_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Maan Yesuuk kaalak epël mëëa. “Ne ngön kopët nent pëël niamaan. Ar këët ök neaan pöt ne talëpë këmtak omnant yeëan pöt niamaan. ");
INSERT INTO wer_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Sonë i mëeima pöt talëpök maan eima? Anutuuk ma pimtok kön wiak eima? Aan kat wiim.” ");
INSERT INTO wer_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Pël maan pitëmënt neneren epël mëëa. “Tiar tol mapen? ‘Anutuuk,’ pël mapenaatep pi epël niepan. ‘Tol ëënak Sonë ngönten kön wi kosang newasën yeë?’ ");
INSERT INTO wer_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ën, ‘Son pimtok,’ pël mapenaatak pöteta omën pourö Sonön tektek ngön yaaö omën këëp pël yamëëa pötaan kas ëa.” ");
INSERT INTO wer_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Pël mëak Yesuun kangiir epël mëëa. “Ten köpël,” maan Yesuuk epël mëëa. “Nookta ne talëpë këmtak yeëan pöt ök neniangan.” ");
INSERT INTO wer_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesu pi watepang ngönöt apënëak ngës rëak nent epël mëëa. “Omën namp wain ya newer ngëntak ëm ök rëak wain ulöpörö wamp olapna yang öngöpö tëak ngarangk ëëpna ka wali nent ök rëa. Pël ëak ya omnarö ngarangk moulmëak pimënt yang wali nerek së wakaima. ");
INSERT INTO wer_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Pël ëak wë kë yaaröa akunet temanöm sëën inëën ru namp ulöp narö öpënëak ngarangk moulmëauröa naë wes mëën së oröön ");
INSERT INTO wer_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","tang möak waö elmëën elek kaalak sa. ");
INSERT INTO wer_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Sëën ya pepapök kaalak inëën ru muntap wes mëën sëën kepönöök möak utpet mowesa. ");
INSERT INTO wer_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Pël ëën pi kaalak muntap wes mëën së oröön mëna. Pël ëën kaalak muntarö wes mëën së oröön ngarangköröak nga elmëak narö tang möak narö mëna. ");
INSERT INTO wer_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Pël ëën pimtë ru ulööpök kopëtap pimëntring wëaup pim ngönte ngaarëk öpnaat wesak wes mëa. ");
INSERT INTO wer_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pël ëën ngarangkörö piin itenak pitëmënt neneren epël mëëa. ‘Omën epöp pim pepapë mor kolut pout öpnaap. Pötaanök mëmpa. Pël ëën yaat tiarimëën sëpnaan.’ ");
INSERT INTO wer_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Pël mëak mënak pim sokur ya lupöökaan wilëngkëël moolëa.” ");
INSERT INTO wer_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Pël mëak Yesuuk epël mëëa. “Yaaweri pepapök ngarangkörö tol elmëëpën? Pi oröak ngarangk pörö mënak pim ya lupöök ngarangk ompyaö narö moulmëëpnaat. ");
INSERT INTO wer_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ngönën pepeweri ngön epël wia pöt sangk kelak kat nawiin yaaurö ma? ‘Wap omën ka ök yarëauröa wël ë moolëaut Anutuuk ompyaut wesak möör wap wes yewesir. ");
INSERT INTO wer_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Anutu pimtok pël yaalmëën itaangkën ompyaö panë yaë.’” ");
INSERT INTO wer_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yesu pi pël maan wotöökörö pit watepang ngön pöt kat wiak pi pitëmëën ko wesak ya pël wesak wali öpënëak kön wia. Pël ëautak omnaröen kas ëën sëp wesak sa. ");
INSERT INTO wer_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Yuta omën wotöököröak Parisiire Erotë omën narö Yesuun morök elmëëpënëak wes mëa. ");
INSERT INTO wer_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Pël ëën pit Yesuu naë së oröak epël mëëa. “Rë yanuulaup, ten nim songönte ëwat wë. Ni ngön kaar naën, yaap panëët yaaup. Ni isaare irëa pouröen omnant mööngkraar kangk naalmëën yaaup, omën ompyaut pëën Anutuuk ök niiaut omën pourö yaap wesak rë yanuulaup. Pötaanök ni aan kat wiin. Sisa takis monat yemangk pöt pangk yeë ma won? ");
INSERT INTO wer_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Sisa pöp takis mampen ma Anutu pimënt mampen?” Pël yemaan Yesu pi pitëm morök yaalmëa pöten itenak epël mëëa. “Ar tol ëënak morök yaalnë? Mon kël nent neneë.” ");
INSERT INTO wer_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Pël maan nent mangkën pëël mëëa. “Könre yapin epot talëpëët?” Maan pit epël mëëa. “Sisaëët.” ");
INSERT INTO wer_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Pël maan puuk epël mëëa. “Sisaën yaö ëa pipot Sisa mampun. Ën Anutuun yaö ëa pipot Anutu mampun.” Pël maan pit yaan sa. ");
INSERT INTO wer_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Pit yesën Satusi ngönën omën narö Yesuu naë sa. Pit weletakaan wal yaaö pöt won wia pël yaaurö. Pit së oröak epël mëak pëël mëëa. ");
INSERT INTO wer_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Rë yanuulaup, Moses pi tiarimëën ngön kosang nent epël retëng ëaap. ‘Omën namp öng wak ru won wë wel wiin pöt pim nangapök kaalak öng pöp wak wë rungaap oröön pöt pim nanëpë yaö sëpnaat.’ ");
INSERT INTO wer_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Pël ëën omën nanang narö 7 ëak wakaima. Pël ëaurö nanëp öng namp wak ru won wë wel wia. ");
INSERT INTO wer_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Pël ëën nang pim rakëp öng tapöp wak ru won wë wel wia. Pël ëën ënëmak nang 3 pöpök öng tapöp wak ru won tapël wë wel wia. ");
INSERT INTO wer_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Pël ëaap omën 7 eporö pit öng kopët tapöp wak ru won wë wel wiin ënëmak pitëm öng kapirëpta tapël wel wia. ");
INSERT INTO wer_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Pötaanök omën 7 piporö öng kopët tapöp wauröep wë wal ëëpna akunaöök talëpë öng sëpën?” ");
INSERT INTO wer_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Pël maan Yesuuk pitën epël mëëa. “Ar ngönënre Anutuu weëre kosangöön ëngk ma e weseë irikor ngön yak. ");
INSERT INTO wer_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Weletakaan wal ëënë akunaöök ar omnarö öngre omp naëngan. Kutöm enselöröa ök tek önëërö. ");
INSERT INTO wer_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ën weletakaan wal yaauta ngön pöt, Moses pi këra kotumentëk es wëlëng yokotön itenak sëën Anutuu ngön ök mëëa pöt ar sangk kelak kat nawiin yaaurö ma? Ngön pöt epët. ‘Ne, Apramre Aisakre Yakop pitëm Anutu.’ ");
INSERT INTO wer_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Anutu pi wel wiauröaap won, öp wëauröa Anutu. Ar irikor ngön yak.” ");
INSERT INTO wer_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Pit Yesuring neneren ngön kaip tiktik maim wëën ngön kosangötë ngarangk namp naë së kat wiin Yesu pi këëkë wesak kaip ti yemaan kat wiak epël mëak pëël mëëa. “Ngön kosang taltak kaöet?” ");
INSERT INTO wer_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Maan Yesuuk epël mëëa. “Ngön kosang kaöet epël wia. ‘Israel omnarö, ar kat wieë. Anutu tiarim Aköp, pi kopëtap Omp Ak Këëp. ");
INSERT INTO wer_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Pötaan nim lupmerre könöpre kön yawiautere wëëre kosang pipot nem Omp Ak, Anutuun muumöngk wasën wiaap.’ ");
INSERT INTO wer_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Pöta kar nent epël wia. ‘Nimtëën lup sant yaën tapël nim karipön elmëëm.’ Ngön kosang piptepar kaöetepar, muntat il yewas.” ");
INSERT INTO wer_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Pël maan ngön kosangötë ngarangkëpök epël ök mëëa. “Rë yanuulaup, ni ngönte aan kat wiin kë panë yes. Anutu pi yaap Omp Ak kë kopëtap. Pim ök namp naön. ");
INSERT INTO wer_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Pël ëak piin lupre kön yawiaare weëre kosangöt muumöngk pëël elmëëre ën nimtëën yaën tapël nim karipëën lup sant elmëëmëët piptak Anutuun kiri ke nentere nent ar yaaö pöt il yewas.” ");
INSERT INTO wer_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Pël maan Yesu kat wiin omnamp kön tektekring yemaan kat wiak epël mëëa. “Ni Anutuu wa ngaöök nimëëpna pöta temanöm yesën.” Pël maan akun pötak omnarö Yesuun pëël mapnaaten kas ëën sëp wesa. ");
INSERT INTO wer_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesu pi ngönën tup kaöetak ngönën ök yamëem epël mëak pëël mëëa. “Ngön kosangötë ngarangkörö pit tol ëënak Kristo pi Tewitë ëap pël aim? ");
INSERT INTO wer_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ngëëngk Pulöök Tewitën maan epël ëa. ‘Anutu puuk nem Aköpön epël yema. “Ni wais nem yaapkëëtak öm. Pël ëaan nimëën kööre tok yaaö piporö nook nim weëre kosangöökë karök moulmëëmaat.” ’ ");
INSERT INTO wer_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Tewit pimtok piin, ‘Nem Aköp,’ pël mëëaupök tol ëënak Tewitë ëap pël yaë?” Pël yemaan omën ngönën tup kaöetak wëaurö kat wiin misëng pan ëa. ");
INSERT INTO wer_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesu pi ngön ök maö yesem yal menak epël mëëa. “Ar ngön kosangötë ngarangköröa utpetatön ngarangk këëkë ëën. Pit ulpëën waliit mëak wa topöök omnarö koirak ërëpsawi ngön mapnaaten kent yaaurö. ");
INSERT INTO wer_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Pël ëak ngönën tupötëëre këëre imën akunatë itëkëël omën kaöaröa urötë wel aisapnaaten kent yaaurö. ");
INSERT INTO wer_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Pit pël yeem öng kapiröröa omnant pout pitëmëën weimeë morök elmëak omnaröak pitën kön wiin isëpënëak Anutuun kimang wali yamëëaurö. Omën ke pilörö pit kangiir akunetak könöm kësangöt koirëpnaat.” ");
INSERT INTO wer_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu pi ngönën tupta kakaati mon yawia urta ngësngësöök wel aisëeë itenaan omnarö mon yawia. Pël yaëën omën mon kësang wieëa selap së mon kësangöt wia. ");
INSERT INTO wer_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Pël yaëën öng kapir omnant won namp pi mon kot köp möa nentepar wia. ");
INSERT INTO wer_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Pël yaëën Yesuuk pim ruuröen ngön mëak epël ök mëëa. “Öng kapir omnant won epopë mon yawi eptak omën muntaröaat il yewas. ");
INSERT INTO wer_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Omën monaringörö pit ëlöt wiaan kopëtetepar yawi. Ën öng kapir epop pi omnant wonöpök pim wieëaut wiak won pan wesak wë.” ");
INSERT INTO wer_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu ngönën tuptakaan oröak yesën pim ru nampök epël ök mëëa. “Elei, ru yanuulaup itan. Ngönën tup epët kël kosangötök taë panë wesak ök rëaap. Ompyaö pan.” ");
INSERT INTO wer_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Maan Yesuuk epël mëëa. “Peene itaangkën kësangpel ök rëaan itenak yaan pippel epël wi naöpan. Ënëmak ngaaröak wais tup epët tööl olaan kël naö naöökë rangk wi naöpan, utpet panë sëpnaat.” ");
INSERT INTO wer_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ngönën tup pöt nal komuntakël wiaan Yesu Olip tomök së wëën Pitaare Sems, Sonre Entru pit së Yesuun pëëntak epël mëak pëël mëëa. ");
INSERT INTO wer_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Omën nim yaan pöt akun taltak orööpën? Akun pöt temanön yesën oröpöt oröön ten itenak ëwat sën?” ");
INSERT INTO wer_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Pël maan Yesuuk ngës rëak epël mëëa. “Ar omnaröak lupöt wa irikor elniipanëën këëkë ngarangk ëën. ");
INSERT INTO wer_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Naröak wais nem yapintakël, ‘Ne Kristo,’ pël niak omën selap pitëm lup wa irikor elmëëpnaat. ");
INSERT INTO wer_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ar nga yapinte kat wiak kas ëëngan. Akun kaöaö ngolöp yaëën omën pipot wet rëak orööpnaat. ");
INSERT INTO wer_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Omën kur nementëkaanöröak kur nementekël nga ëëpnaat. Ën yang omp ak nampë omnaröak munt nampë omnaröaan nga ëëpnaat. Pël yaëën moupötta tapël we naöökël së möak naöökël pël ëëpnaat. Pël yaëën kaömp ngöntök kësangpel orööpnaat. Pipot öng nampë ru wilëpënëak lel yailën këlangön kat yawi pöta ök ëëpnaat. ");
INSERT INTO wer_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Ar omnaröen ngarangk këëkë ëën. Pit ar kaöaröa naë niulëën pitök maan ngönën tupötë pës nimööpnaat pötaanök. Ar nem ruurö pël weseë pitök ar yang ngarangkre omën omp ak naröa naë ngön yaatak niulëëpnaat. Pël ëën pitëm ëöetak nem ngönte tekeri wesak manëët. ");
INSERT INTO wer_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Akun pöt teënt pet nairpan. Wet rëak ngön ompyaut yang ël epotë pangk ë pet irëpënëak ëaut. ");
INSERT INTO wer_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Pötaanök ngön yaatak yanuulëën ngön tol nant man pël ëak kön selap ëënganok. Akun pötak Anutuuk arim lupötë anëët ök niapna pipot an. Pël ëën anë pöt arim ngönöt pël naëpan, Ngëëngk Pulöökë ngönöt pël ëëpnaat. ");
INSERT INTO wer_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Omën naar nanëpök nangapëën kup mowiin mëmpnaat. Pepapökta ruupëën kup mowiin mëmpnaat. Ën koröngre ruuröak ëlre pepaarëën kup mowiin mëmpnaat. ");
INSERT INTO wer_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ar nem ru sak wë pötaan omën pourö ya sangën ëën kööre tok elniipnaat. Pël ëëpnaatak omën weë sak wëak wel wiipnaarö Anutuuk kama öpnaat.” ");
INSERT INTO wer_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Ënëmak omën utpet panëët omnant utpet yewesaut wiaapanëak nga ëaurek wiaan itaampunëët.” (Ar ngön epët sangk kelënëërö pöten këëkë kön wiaan.) “Pël yaëën Yutia yangerak wëaurö kas rosiraöökël sën. ");
INSERT INTO wer_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Pël yeem ka tomök öpnaapök kaata kakaati së omnant öpan. ");
INSERT INTO wer_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ën yaak öpnaapta kak së ulpëënre omnant öpan. ");
INSERT INTO wer_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Elei, akun pötak ru kepringre ru kapa yemenaurö tol ëëpën? ");
INSERT INTO wer_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ar omën kas yaaö pipot kopi akunetak orööpanëën Anutuun kimang man. Akun pötak ar yok pangk kas nasëngan pötaanök. ");
INSERT INTO wer_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Akun pötak këlangön kaö panë kat wiinëët. Ke pil nent Anutuu kutömre yang ket ëaurekaan yewaisem e wë eptak naaröön ëaut. Ënëmeta naaröön ëëpnaat. ");
INSERT INTO wer_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Aköp pi akun pöt mënt wasëpënëak kön wia. Pi pël naën ëa talte omën pourö kö sën. Omën yaö wesauröaan akun pipët mënt wasëpnaat. ");
INSERT INTO wer_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","22","Akun pötak kaar omën selap oröak naröak pitëmtën, ‘Ne Kristo,’ pël yaan naröak, ‘Ne tektek ngön yaaö omnamp,’ pël niaapnaat. Pit omnarö morök elniin pitëm ënëm ëënëak retëng weëre kosangringöt ëëpnaat. Yaap, pit omën Anutuu yaö wesauröeta morök elniak pël ëëpnaat. Pötaanök nampök, ‘Kristo e oröak wë,’ pël yeniaan nampök, ‘Kristo ëngkrek oröak wë,’ pël yeniaan pöt kat mowiingan. ");
INSERT INTO wer_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ne omën pöt naaröön wiaan ök yeniak. Pötaanök ënëmak yaaröön ëngk ma e wasnganok.” ");
INSERT INTO wer_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Akun pötak omnarö këlangön kat wi pet yairën këtëp röök ulöpnaat. Pël ëën ngoonöpta ngaap yesën ");
INSERT INTO wer_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ariat kutömweriaan tiak yengentiin kutömweri omën weëre kosangringöt këlok sëpnaat. ");
INSERT INTO wer_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Pël yaëën Omën Këëp ne weëre kosangre iere kasir nemotring kutöm kepilötë yaaröön itaampnaat. ");
INSERT INTO wer_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Pël ëën nem enselörö wes mëën së nem omën yaö wesaurö yang we naöökaan naöök, oorekaan öngkrek, kutömre yang kauteparëëlaan wa top elmëëpnen ëa.” ");
INSERT INTO wer_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Ar këra wasmentë yaë pöten kön wieë. Këra pöment ëp kërë sak wil yewatën itenak kopi akunet temanöm yes pël yewas. ");
INSERT INTO wer_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Pöta ök omën yeniak epot yaaröön itenak pöt, ‘Pim waisëpna akunet temanöm sëën waisëpënëak yaë,’ pël wasënëët. ");
INSERT INTO wer_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ne yaap niamaan. Omën e wë epörö wel wi won nasën wiaan omën yeniak epot orööpnaat. ");
INSERT INTO wer_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kutömre yang eptepar won sëpnaatepar. Ën nem ngön epët won nasëpan.” ");
INSERT INTO wer_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Omnarö ar omën pötë orööpna akun kë panëëten ëwat naön. Ën ensel kutömweri wëauröere Anutuu Ruup neenta ëwat naön. Pep pimtokëër ëwat wë. ");
INSERT INTO wer_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ar nem waisuma akuneten köpël wë. Pötaan ngarangk ëak ngaire wa kom ëeim ön. ");
INSERT INTO wer_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Omën namp ka wauret wiaan yang wali nerek sëpënëak pim inëënörö ngarangk moulmëak neenem ya ngönöt mëak kaata ngarangkëp ngai ëëpënëak mapnaat. ");
INSERT INTO wer_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Pöta ök arimtë wëwëat ngarangk këëkë ëeim ön. Ka pepap pi wiap kanök ma röök lupöök ma röökre ëlpamën yaëën ma wangam kanök orööpën pöten köpël wë pötaan ngarangk ëeim ön. ");
INSERT INTO wer_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ar om ka ureim wëën teënt wais oröön yaan sënganëën. ");
INSERT INTO wer_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ngön epët ar omën pouröen ök yeniak. Ngarangk këëkë ëeim ön.” ");
INSERT INTO wer_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Kaömp yis namëënöt yenaare Anutuu mait elmëa akunetepar temanöm sëpënëak yaëën kët nentepar wiaan kiri ar yaaö kaöaröere ngön kosangötë ngarangkörö Yesu ëlëëp wak mëmpënëak ngön ë kopëta wesa. ");
INSERT INTO wer_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Pël yeem epël mëëa. “Omnarö pit tiarring nga elpanok akun kësangtak pël naëngan.” ");
INSERT INTO wer_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu pi Petani kak Saimon kësë ëaup pim kaatak së ilëak wëa. Pël ëak kaömp yenem wëën öng nampök i köp nga kamp ompyaö sum kësangring nent kep ompyautaring wak së rëak kepönöök pout lë momëa. ");
INSERT INTO wer_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Pël yaalmëën omën pörek wëauröakaan naröak neneren këëpöt ngön epël mëëa. “Omën sum kësangringët oröp ëën utpet yewas? ");
INSERT INTO wer_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","I kamp ompyaö piptak mon 300 kina il wesak koirën omën omnant wonörö mangkën pangk ëëpnaatep.” Pël mëak öng pöpön ngön kosang mëëa. ");
INSERT INTO wer_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Pël yemaan Yesuuk epël mëëa. “Pël mangan. Ar tol ëënak maan pi ya këlangön kön yawi. Pi neen ompyaö pan yaalnë. ");
INSERT INTO wer_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Omnant wonörö pit akun wali arring wëën sant elmëënëak pöt yok pangk pël elmëënëët. Ne pöt, arim naë akun wali naön ëëmaap. ");
INSERT INTO wer_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Öngöp pi pim elnëëpnaal yaalnë. Ne teënt wel wiin yang kel neweerëpnaat. Pötaan tiarim yeë pöl nem koröpöön kan yaö yaalmë. ");
INSERT INTO wer_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ne yaap niamaan. Ngön ompyaut yang ëlötë aö sëën pangk ëëpnaal öng epopë nem koröpöön kan yaö yaalmë epta ngönteta aö sëën pangk ëëpnaat.” ");
INSERT INTO wer_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Akun pötak Yesuu ru 12 pöröakaan namp yapinte Yutas Keriot kakaanëp puuk kiri ar yaaö kaöaröa naë së piin kup mowiipënëak war wesak ök mëëa. ");
INSERT INTO wer_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Pël ëën pit kat wiak ya kë sak sum mampënëak mëëa. Pël maan pi Yesuun kup mowiipënëak kan ap weseima. ");
INSERT INTO wer_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Kaömp peret yis namëënöt yena akun ngëëngktak Anutuu mait elmëautaan kiri sëpsëporö yamöa akunet temanöm yesën Yesuu ruuröak piin epël mëak pëël mëëa. “Ka taltak së Anutuu mait elmëa akunetak kaömp nëmpenaat ar ëak kopëta wasënëak kent kön yawiin?” ");
INSERT INTO wer_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Pël maan ru naarën epël mëak wes mëa. “Arip kak së oröak omën namp i kepit wak wëën koirak pöt pim ënëm sën. ");
INSERT INTO wer_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Pël ëak kaatak yeilaan pöt ilëak ka pepapön epël ök man. ‘Rë yanuulaupök, “Nem ruuröaring ka taltak Anutuu mait elmëauten kön wiinaan kaömp nën,” pël ya,’ pël man. ");
INSERT INTO wer_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Pël ök maan ka kaö ngaarëk nent urre korumön ëak ompyaö wesauten pet elniin pötak tiarimëën kaömp ar ëak kopëta wasën.” ");
INSERT INTO wer_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Pël maan ruaar kak së oröak mëëaul ëak mait kaömpöt ar ëak kopëta wesa. ");
INSERT INTO wer_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Wiap kan Yesu pi ru 12 pöröaring ka pötak së ilëa. ");
INSERT INTO wer_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Pël ëak kaömp yenem Yesuuk epël ök mëëa. “Ne yaap niamaan. Arëkaan nampök neen kup mowiipnaat. Neering kaömp yenem wë eporö arëkaan.” ");
INSERT INTO wer_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Maan ruurö pit ngës rëak pöppöp epël mëak pëël mëëa. “Aköp, nook ma?” “Aköp, nook ma?” pël maö sa. ");
INSERT INTO wer_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Pël maan mëëa. “Ru 12 arëkaan namp neering kaömp peret iistak wariak mangkën yen epopök. ");
INSERT INTO wer_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Omën Këëp ne ngönëntak nemëën ëa kan pöök së wel wiimaap. Ën nemëën kup mowiipna pöp, elei, kangut kësang pan öpnaap. Pim ëlëpök nawilën ëanëën ompyaö ëan tapön.” ");
INSERT INTO wer_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Pit kaömp yenem Yesuuk kaömp nent wak Anutuun yowe mëak pel menak epël mëëa. “Epët nem mësëpëtak wa neë.” ");
INSERT INTO wer_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Pël mëak wain kelön nent wak Anutuun yowe mëak mangkën pourö na. ");
INSERT INTO wer_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Yenën mëëa. “Epët nem iit. Arimëën il yoolaan Anutuuk sulöp ngolöpët taë yewas. ");
INSERT INTO wer_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ne yaap niamaan. Yangerak eprek wain iit peene nëën pet yair. Arring kaalak nanën wë ënëmak akun kaöaöök Anutuu naë wain i maim nent nëmpenen ëa.” ");
INSERT INTO wer_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Pit kaömp na pet irak ngönën tan nent mëak kakaan oröak Olip tomökël sa. ");
INSERT INTO wer_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Kan kourak yesem Yesuuk epël mëëa. “Peene eptak ar pourö ne sëp newesak kas sënëët. Arim pël ëënë pöt ngönëntak ngön nent epël wia. ‘Ne sëpsëp ngarangkëp mëngkën sëpsëpörö repak sëpnaat.’ ");
INSERT INTO wer_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ne yaap wel wiin weletakaan wal ë neulëën wet rëak Kalili yangerak së wëën ar ënëm waisënëët.” ");
INSERT INTO wer_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pël maan Pitaak epël mëëa. “Eporö sëp niwesak kas sëpën koröp. Ne pöt, pël naëngan pan.” ");
INSERT INTO wer_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Pël maan Yesuuk epël mëëa. “Ne yaap niamaan. Peene röök eptak kokor ngön nentepar naën wiaan ni akun nentepar nent yak newasumëët.” ");
INSERT INTO wer_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Maan Pitaak epël mëëa. “Nimënt yanimëngkem ne nempënëak yaan pöteta yak naniwasën ëëmaap.” Maan ru pim karurö kaamök ëak tapël mëëa. ");
INSERT INTO wer_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Pörekaan yesem yang lup nenta yapinte Kesemani pörek së oröak Yesuuk ruuröen epël mëëa. “Ar eprek wëën ne ëngkrek së Anutuun kimang memaan.” ");
INSERT INTO wer_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Pël mëak Pitaare Semsre Sonringörö koirak sa. Yesem ngës rëak ya këlangön kön wiak ya ngës pan ëa. ");
INSERT INTO wer_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Pël yeem epël mëëa. “Ne ya këlangön panë yeem wel wiima yangap yaë. Pötaanök kosang newesak neering itiit öpa.” ");
INSERT INTO wer_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Pël mëak kot nent ëngkël së ë kosaö yangerak wesirak këlangön akunet Pepapök kat wiin pël naën ëëpnaat ëën pöt mop mowiipënëak kimang mëëa. ");
INSERT INTO wer_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Pël yeem epël mëëa. “Pep ni omnant poprak naën yaaup. Pötaanök ni kön wiin pangk ëën pöt këlangön nem naë orööpënëak yaë epot mop wasum. Nem könöök won, nim könöökë wiaul ëëm.” ");
INSERT INTO wer_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Pël më pet irak kaalak së itaangkën ka uraan Pitaan epël mëëa. “Saimon, ni tol ëënak ka uraan? Kot nent neering itiit naöngan ma? ");
INSERT INTO wer_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Moröktak wiap sënganëën lup itiit wë Anutuun kimang maë. Arim lupöt kengkën yeëetak koröpöt könöm yaalni.” ");
INSERT INTO wer_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Pël mëak kaalak së kimang mëëa tapët kaalak mëëa. ");
INSERT INTO wer_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Kimang më pet irak kaalak së itaangkën ka ureëa. Pit ka urakaim olëak wal ëën pangk naën ëën ngön nent nemaan ëa. ");
INSERT INTO wer_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Pël ëën kaalak së kimang mëak waisën akun nentepar nent sëën epël mëëa. “Ar om ka könkön ureim wë ma? Peene epët nemëën kup mowiipna akunet temanöm yes. Omën Këëp nemëën kup mowiak omën utpetaröa moresi neulëëpnaat. ");
INSERT INTO wer_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Wal ëën sëpa. Omën nemëën kup mowiipnaap e yaarö.” ");
INSERT INTO wer_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu pi pël yamëem wëën pim ru 12 pöröakaan namp yapinte Yutas pöpring omën kësang pan kiri ar yaaö kaöaröere ngön kosangötë ngarangköröere kaöarö maan inre tang wak së oröa. ");
INSERT INTO wer_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yutas Yesuun kup mowiipna pöp wet rëak pitën epël mëëa. “Ar ëwat sënëën tot numaatak pël yaëën tapöp wesak wali wak taintaë wesak wak sën.” ");
INSERT INTO wer_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Pël mëak pi teëntom Yesuu naë së, “O Aköp,” pël mëak tot na. ");
INSERT INTO wer_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Pël yaalmëën itenak wak kosang wesa. ");
INSERT INTO wer_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Pël yaëën ru piiring wëauröakaan nampök pim öpwer yepatuukaan tëak kiri ar yaaö wotöököpë inëën ru namp möak pim katëëp per olëa. ");
INSERT INTO wer_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Pël yaëën Yesuuk epël mëëa. “Ar neen ngaap wesak ne wali neönëak inre tang wak yewais ma? ");
INSERT INTO wer_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ne kët ël epotë ngönën tup kaöetak arring wëaup. Pël ëën ar akun pötë neneön ëaurö. Pël ëaap epël yaalnëën ngönën pepeweri nemëën retëng ëa pöt kosang yes.” ");
INSERT INTO wer_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Pël yemaan pim ruurö sëp mowesak kas sa. ");
INSERT INTO wer_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Pël yaëën yokot ulwas namp poë koröpö pëën ureëaup pim ënëm yesën ");
INSERT INTO wer_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","wali wëën poë koröpö wil menak kas pöömpö sa. ");
INSERT INTO wer_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Pit Yesu mësak kiri ar yaaö wotöököpë naë së wëën kiri ar yaaö kaöaröere ngön kosangötë ngarangköröere kaöarö wa top ëa. ");
INSERT INTO wer_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pël ëën Pita pi ënëmënëm sa. Pël ëak kiri ar yaaö wotöököpë ka tomök oröak ëmöökë kakaati së ilëak pit Yesu tol yaalmë pöt itaampënëak ngai omnaröa tekrak wel aisëak es mor yesa. ");
INSERT INTO wer_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Pël ëën kiri ar yaaö kaöaröaere kansol pourö Yesu mëmpnaan omën naröak kaar rëak pim utpet ëautön mapënëak ap wesa. ");
INSERT INTO wer_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Pël yeem omën selap pan pimëën kaar maan pitëm ngön pöt mëngkre mëngk naën ëa. ");
INSERT INTO wer_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Pël yaëën omën naarök kaar epël mëëa. ");
INSERT INTO wer_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ten epël aan kat wiaut. ‘Ne ngëëngk tup omën moresök ök rëa epët tööl olëak kët nentepar nent omën moresök ök nerapanë nent ök remaat.’” ");
INSERT INTO wer_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Pöteta aan mëngkre mëngk naën ëa. ");
INSERT INTO wer_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Pël ëën kiri ar yaaö wotöököpök pitëm tekrak wal ëak Yesuun epël ök mëëa. “Pitëm nimëën ngön ya epëten tol yewasën? Ni kangiir nent naëngan ma?” ");
INSERT INTO wer_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Pël maan Yesu pi nerek wak nemaan wëën kiri ar yaaö wotöököpök epël mëak pëël mëëa. “Ni Kristo Yaya Yemak pöpë Ruup ma?” ");
INSERT INTO wer_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Pël maan Yesuuk kangiir epël mëëa. “Nimtë yaan pi tapët. Pötaanök ne niamaan kat wieë. Ënëmak Omën Këëp ne Anutu weëre kosangëp pim yaapkëël wel aisëak kutöm kepilötë yewaisën it nengempun sa.” ");
INSERT INTO wer_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Pël maan kiri ar yaaö wotöököp ya utpet pan ëën pimtë ulpëënëp keli yoolëem pim omnaröen epël ök mëëa. “Tol ëën omën munt narö piin ngön mapnaaröen kaalak ap weseim öpen? ");
INSERT INTO wer_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Pi Anutu il yemowasem utpet wesak yaan ar yok kat wia. Ar tol yak?” Pël maan epël mëëa. “Pi utpet yaarek wel wiip.” ");
INSERT INTO wer_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Pël mëak naröak ngës rëak waasöp ngës menak itöörarë ngep elmëeë möak, “Talëpök yanimö?” pël mëak polisörö mangkën pitök wak möa. ");
INSERT INTO wer_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita pi ka tomök ëmöökë kakaati wëën kiri ar yaaö wotöököpë inëën koont nampök së ");
INSERT INTO wer_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","itaangkën Pita es mor yesën itenak epël mëëa. “Namp, ni Yesu Nasaret kakaanëpring wëaup.” ");
INSERT INTO wer_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pël maan pi yak wesak epël mëëa. “Ne nim yaan pipten ëngk ma e yewas.” Pël mëak ëm kanrak yaaröön kokor ngön ëa. ");
INSERT INTO wer_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Pël ëën inëën koontup piin itenak kaalak omën naë wëauröen epël mëëa. “Yaap, pitëkaan omën namp epop.” ");
INSERT INTO wer_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pël maan pi kaalak yak wesa. Pël ëak akun kot nent wë olëak omën pim naë wëauröak epël mëëa. “Ni yaap pitëm toktakaanëp, Kalili omnamp.” ");
INSERT INTO wer_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pël yemaan Pita pi kosang panë wesak ngön köntak epël mëëa. “Ne Anutuu ëöetak omën arim yak pipopön köpëlëp.” ");
INSERT INTO wer_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Pël yemaan kokor ngön aan nentepar ëa. Pël ëën Yesuuk ngön epël mëëa pöt kön wia. Kokor akun nentepar ngön naën wiaan akun nentepar nent yak newasumëëp mëëa pöten kön wiak yaköm ëën ing kaö ëa. ");
INSERT INTO wer_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ëlpam walën kiri ar yaaö kaöaröere ngön kosangötë ngarangköröere kaöaröere kansol pourö wa top ëak Yesuu mëmpnaata ngönte kosang wesa. Pël ëak wii tëak naröak mësak së Pailatë naë moulmëa. ");
INSERT INTO wer_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pël ëën Pailatök epël mëak pëël mëëa. “Ni Yuta omnaröa omën omp aköp ma?” Maan “Yok yaan pi tapët,” pël mëëa. ");
INSERT INTO wer_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Pël yemaan kiri ar yaaö kaöarö pit ngön kësang panë kosang wesak ök mëëa. ");
INSERT INTO wer_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pël yaëën Pailat pi Yesuun epël mëak pëël mëëa. “Pit nimëën ngön könöm wesak yaan tol ëënak kat wieëak nerek naën yaën?” ");
INSERT INTO wer_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Pël maan Yesu pi ngön kangut nemaan pan yaëën Pailat pi yaan sa. ");
INSERT INTO wer_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Krismaki poutë akun kësang pötak yang ngarangkëp pi omnaröak omën namp wii kaatakaan wes mëëpënëak maan pöt wes më pël yeëa. ");
INSERT INTO wer_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Akun pötak omën namp wii kaatak wëa yapinte Parapas. Puuk omën muntaröa wotöök wëak nga yaalem namp mëna. Pël ëën pötaan wii kaatak ulmëa. ");
INSERT INTO wer_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Pël ëën omën selap pit Pailatë naë së wa rongan ëak krismaki poutë yaalmëaul elmëëpënëak ök mëëa. ");
INSERT INTO wer_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pël ëën Pailatök epël ök mëëa. “Yuta omnarö arim omp aköp mait elmëak wes nimëëmaan. Kat wiin pangk yaë ma?” ");
INSERT INTO wer_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Yuta omën kaöarö Yesuun om pas kaaö kön wieë wii kaatak moulmëa pöt pi ëwat wëak pël mëëa. ");
INSERT INTO wer_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pël maan kiri ar yaaö kaöaröak omnaröen Parapas Yesuu urtak wilak wes mëëpnaan mapënëak këk mëëa. ");
INSERT INTO wer_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pël yaëën Pailatök kaalak epël mëak pëël mëëa. “Pël ë kosang yewas pöt arim omp ak pël yemak pöp tol ëëm?” ");
INSERT INTO wer_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Maan elek wiak mëëa. “Pi këra yetaprak wel wiip.” ");
INSERT INTO wer_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Maan epël mëëa. “Omën epop utpet oröp nent ëa?” Maan rangkrangk ngön ë olëak epël mëëa. “Këra yetaprak wel wiip.” ");
INSERT INTO wer_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pël maan Pailat pi pitëm kentöt pet irëpnaak yak Parapas wes mëa. Ën Yesuun pöt maan pol koröp wapötringöök momöak këra yetaprak mööpënëak ngaaröa ngësë wes momëa. ");
INSERT INTO wer_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Pël ëën ngaarö pit Yesu mësak oröak së yang ngarangkëpë ka kaö nerak ulmëak maan nga omën pourö pim naë wa rongan ëa. ");
INSERT INTO wer_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Pël ëak ngaaröa ulpëën köp möa namp momëak wii öng oröauuk ul ket ëa nent kepönöök mowaëa. ");
INSERT INTO wer_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Pël elmëak rar rë mowesirak epël mëëa. “Yowe, Yuta omnaröa omp aköp.” ");
INSERT INTO wer_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Pël mëak kalaö naööring kepönöök momöak waasöp ngës menak rar rë mowesirak ngëëngk yemowesaul ököök elmëa. ");
INSERT INTO wer_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ököökre waswas pël elmëak ulpëën köp möaup përëak kaalak pimtëëp më moulmëak këra yetaprak mööpënëak mësak sa. ");
INSERT INTO wer_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Kamtaöök yesem omën namp koira yapinte Saimon, Sairini kakaanëp, Alesantaare Rupas piarpim pepap. Pi yaakaan yewaisën koirak këk maan Yesuu këra yetapër waalën sa. ");
INSERT INTO wer_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Yesem yang lup nenta yapinta Kolkota, tiarim ngöntak Kepön Kos pötak, së oröa. ");
INSERT INTO wer_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Pël ëak wain iitaring i kön kat yokola nent irikor ëak nëmpënëak mangkën kaaö ëa. ");
INSERT INTO wer_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Pël ëën pit këra yetaprak möak pim ulpëënre poë koröpöt narö nant öpënëak ngasamtak wia. ");
INSERT INTO wer_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Pit këtëp kot nent luptakël yaaprën 9 kilok pötak möa. ");
INSERT INTO wer_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Pël ëak pim kepön löötak epël retëng ëa. “Epop Yuta omnaröa omën omp aköp.” ");
INSERT INTO wer_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Pël ëak ngaare këkain omën naar, namp yaapkëël namp katnëël, mö ulmëa. ");
INSERT INTO wer_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Pël ëën ngönëntak epël ëa pöt kë oröa. “Omën utpet yaauröa rongantak ulmëaup.” ");
INSERT INTO wer_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Pël ëën omnarö sak waisak yeem piin sömre ëlakëër kepön keke elmëak epël mëëa. “Aë, ni, ‘Anutuu ngëëngk tupët tööl olëak kaalak akun nentepar nent ök remaap,’ pël ëauppe ");
INSERT INTO wer_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","nimtë koröpö kaamök ëëm. Ni yaap Anutuu Ruup pöt këra yetaprakaan ent ëak ira.” ");
INSERT INTO wer_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Pël yemaan kiri ar yaaö kaöaröere ngön kosangötë ngarangkörö pit tapël ökre was elmëak neneren epël mëëa. “Pi omën muntarö kaamök yaaupök pimtëën poprak yaë. ");
INSERT INTO wer_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Pi Kristo, Israel omnarö tiarim omën omp aköp pöt këra yetaprakaan ent ëak irap. Pël ëën tiar itenak piin kön wi kosang wasëpenaan.” Pël yemaan omën ngësngës mö ulmëa pöaarta tapël utpet wesak mëëa. ");
INSERT INTO wer_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Këtëp luptak 12 kilok pötak wëën yanget koö olëak wieë së 3 kilok ëa. ");
INSERT INTO wer_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Pël ëën 3 kilok këtëp tingk wesak yengmaan Yesu pi ngön ëak epël mëëa. “Eloi, eloi, lama sapaktani?” Pöt tiarim ngöntak epël. “Nem Anutu, nem Anutu, ni tol ëënak ne sëp yenewasën?” ");
INSERT INTO wer_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Pël yemaan omën pörek taueëaurö pit pöten kat wiak epël mëëa. “E kat wieë. Eliaan merëk yemaap.” ");
INSERT INTO wer_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Pël yaan omën namp pöömpö së i kaö kel newer wain i som yaautak wariak këkalëp kautak wa tëak Yesu nëmpënëak yemangkem epël mëëa. “Kora. Elia pi wais kaamök elmëëpën ma won pöten iteempa.” ");
INSERT INTO wer_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Pël yemaan Yesu pi merëk kaö mëak wel wia. ");
INSERT INTO wer_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Wel yawiin ngönën tup kaöetak poë koröp kësang ngeröök uteëaumpel oorekaan luptak keliak nempelnempel ëa. ");
INSERT INTO wer_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Pël ëën ngaaröa wotöököp Yesu pim koëël tau wëaup pi itaangkën Yesu wel wiin epël ëa. “Omën epop yaap Anutuu Ruup.” ");
INSERT INTO wer_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Yesu yamöön öng Kalili yangerakaan pim ënëm yesem kaömpre omnant kaamök elmë ima pörö kamaarek wë iteneëa. Öng pël ëa pöröakaan narö eporö. Maria Matala kakaanëpre Maria muntap Sems kotupre Yose pöaarë ëlëpre Salomi pörö. ");
INSERT INTO wer_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Pit Kalili yangerakaan Yesuu ënëm inëën elmë imaurö. Pitëmënt pëën won, öng munt naröeta Yesuring së Yerusalem kak wakaima. ");
INSERT INTO wer_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Kë yesa akun ngëëngkët ëlpamökëën wiaan omnant kön yaaö akuneta wiap kanök Yosep Arimatia kakaanëp sa. ");
INSERT INTO wer_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Pi kansolöröa wotöök wë Anutuu wa ngaöök nimëëpnaaten kent kön wieimaup. Puuk kas kön nawiin Pailatë naë së Yesuu sokuren ök mëëa. ");
INSERT INTO wer_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pël ëën Pailat pi teënt wel wia pöten yaan sak nga omnaröa wotöököpön yas maan sëën pëël mëëa. ");
INSERT INTO wer_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pël ëën nga omnaröa wotöököpök “Teënt wel wia,” pël maan kat wiak Yosepön sokur öpnaaten kuure mak mëëa. ");
INSERT INTO wer_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Pël maan Yosep pi së poë koröp kölam naö sum ëak së Yesuu sokur yetaprakaan ent ëak poë koröp pöök kör koëak wak së pimtëën wesak kël öngöp tëa naöök wiak kël kaö naö kur kaip tiak kanrak il wari ulmëa. ");
INSERT INTO wer_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Pël yaëën Maria Matala kakaanëpre Maria Yoseë ëlëp piarip itena. ");
INSERT INTO wer_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Kë yesa akunet pet irën Maria Matala kakaanëpre Maria Semsë ëlëpre Salomiiringörö pit Yesuu sokurak kolap köp nga kamp ompyaut wa mëëpënëak sum ëak kopëta wesa. ");
INSERT INTO wer_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Pël ëak Sante ëlpam yewalën oröak kan kourak yesën këtëp apra. ");
INSERT INTO wer_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Pël ëën yangaö temanöm yewasem neneren epël mëëa. “Yangaöökë kanrakaan këlö talëpök wa pëlëër niwiipën?” ");
INSERT INTO wer_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Pël mëak itaangkën kël kësang pö wa pëlëër wieëa. ");
INSERT INTO wer_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Pël ëaan yangaöök ilëak itaangkën omp ulwas namp ulpëën kölam waliip mëaup yaapkëël wel aisëaan itenak yaan sa. ");
INSERT INTO wer_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Pël yaëën epël mëëa. “Yaan sëngan. Ar Yesu Nasaret kakaanëp yetaprak möaupön itaampunëak waisan. Pi eprek won wia. Yok wal ëa. Ur koseten iteneë. ");
INSERT INTO wer_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ar së pim ruuröere Pitaan ök man. ‘Pi Kalili yangerakël arimëën wet rëak sëpënëak ök niiaup. Pörek së itaampun.’” ");
INSERT INTO wer_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Pël maan öngörö kas utpet ëak reireë urö yangaöökaan oröak kas pöömpö sa. Pël ëak kas panë ëën omnaröen ök nemaan ëa. ");
INSERT INTO wer_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesu pi Santeetak ëlpam yewalën wal ëak wet rëak Maria Matala kakaanëp ngaan urmer 7 ëak waö ë momëa pöp ëö pet elmëa. ");
INSERT INTO wer_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Pël ëën së piiring wëaö muntarö ingre ya ilak aim wëën ök mëëa. ");
INSERT INTO wer_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Pël ëën Yesu pi wal ëak wëën öngöp itena ngön pöten kat wiin kë won ëa. ");
INSERT INTO wer_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Akun nentak ingre mor sauröakaan omën naar kak nerekë sëpënëak yesën kan kourak möönre koröp maim wak ëö pet elmëa. ");
INSERT INTO wer_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Pël elmëën piarip së ru muntaröen ök maan kat wiin tapël kë won ëa. ");
INSERT INTO wer_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ënëmak ru 11 pörö wa top ëak kaömp neim wëën ëö pet elmëa. Pël ëak wal ëak wëën itenauröak ök maan pitëm lupöt il wariak wëën kön wi kosang nemowasën ëa pötaan kos elmëa. ");
INSERT INTO wer_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Pël elmëak epël ök mëëa. “Ar yang ël epotë yesem omnaröa wëaul ngön ompyaut ök man. ");
INSERT INTO wer_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Kön wi kosang yewesautaring i mëëpnaap pi kutömweri yaö sëpnaap. Kön wi kosang yewesaut wonöp pi pöt es parëaöökëën yaö sëpnaap. ");
INSERT INTO wer_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Kön wi kosang yewesautaring öpnaarö nook weëre kosang mangkën retëng ke nentere nent epël ëëpnaarö. Nem yapintak urmerarö waö ë momëëpnaat. Ngön köngköm ngolöpöök apnaat. ");
INSERT INTO wer_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Kamalörö moröak mësël ëëpnaat. I nak wel yawiaut nëën utpet nemowaspan. Yauman yaauröa rangk pitëm moröt mowiin ompyaö sëpnaat.” ");
INSERT INTO wer_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Aköp Yesu pi ngön pipël ök më pet irën Anutuuk wak kutömweri isa. Pörek së pim yaapkëëtakël wel aisëak wë. ");
INSERT INTO wer_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Pël ëën pit kaare yang ël epotë pim ngönte aö sa. Pël yaëën Aköpök kaamök elmëak retëng nentere nent yaalmëem pim ngön yaaö pöt yaap pël pet elmëa. ");
INSERT INTO wer_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","O omën kaöap Tiopilas, tenim tekrakaan omën selap pöröak Anutuuk elmëën tenim naë omnant oröa pötön ökre was retëng ëaut. ");
INSERT INTO wer_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Pit omën wet rëak omnant oröön itena pöröa këmötëaan ngön kat wiak retëng ëaut. ");
INSERT INTO wer_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Pël yaëën nem itena pöröen pëël mëak songönöt këëkë kat wiaut. Pötaanök wotpil wesak nimëën ë yaningk. ");
INSERT INTO wer_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ni kat wiak wet rëak omën muntaröak ök niaan kat wian epot yaap tapöt pël wasumëak retëng ë yaningk. ");
INSERT INTO wer_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Erot pim Yuta omnarö ngarangk ëak wëa akun pötak kiri ar yaaö omën namp wëa yapinte Sekaraia pöp Eron pim kurmentëkaanöröa naëaan Apaisa pim toktakaanëp. Ën pim öngöp Elisapet piita Eron tapöpë kurmentëkaanëp. ");
INSERT INTO wer_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Piarip Anutuu ëöetak wotpil wë pim ngön kosang pout ngar weim wakaima. ");
INSERT INTO wer_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Pël ëak Elisapet pi ru köpëlëp yak piarip ru won wë ulöp sa. ");
INSERT INTO wer_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Sekaraiaare kiri ar yaaö pim karurö pit Anutuu ngönën tup kaöetak së ilëak Anutuu ëöetak neenem yaat mëmpö yesem ");
INSERT INTO wer_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Sekaraia puuk ka ngerö ngëëngktak së köp nga kaampöt kiri ar ëak koulöp wes mëëpënak pitëm yaaul wël ëlmëën sa. ");
INSERT INTO wer_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Pël yaëën akun pötak omën yaap sa pörö pit tomök wa top kësang ëak Anutuun kimang maim wëa. ");
INSERT INTO wer_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Pël ëën Sekaraia pi itena pöt Aköpë ensel namp köp nga kaampöt kiri ar yaaö pöta weë yaapkëöökël tauaan itenak ");
INSERT INTO wer_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","kas kaö ëak reëreë ura. ");
INSERT INTO wer_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Pël yaëën enselëpök epël mëëa. “Sekaraia, ni kas ëëngan. Anutu pi nim kimang ngönte kat wia. Pötaanök nim öngöp Elisapet pi nim yokot namp wilëpnaat. Pël ëën pim yapinte Son pël mam. ");
INSERT INTO wer_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Pël ëak ni ya kë sak ërëpërëp yaëën omnaröeta pim orööpna pötaan ërëpërëp ëëpnaat. ");
INSERT INTO wer_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Pi Aköpë ëöetak kaö sak wë wain iire i nga muntat nanëmpan. Pim ëlëpë yaatak wëën Ngëëngk Pulö pim lupmeri peö ëëpnaap. ");
INSERT INTO wer_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Puuk Israel omën selap pan lup kaip motiin Anutu pitëm Aköpë naë rë olapnaat. ");
INSERT INTO wer_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Pi Eliaë ëa pöl weëre kosang wak Aköpë wotöök rapnaap. Puuk peparöa könöt kaip motiin rungaaröaring lup yal mampnaat. Pël ëën omën ngön wa olëolë yaauröeta tapël elmëën wotpil wëauröa könöt kat mowiipnaat. Pël elmëën omën pörö Aköpë waisëpnaataan ko ëak öpnaat.” ");
INSERT INTO wer_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Pël maan Sekaraia pi enselëpön epël mëëa. “Ten öngöp pouwaar ulöpaar. Pötaanök nim ngönta këët orööpnaalën kön nawiin yeë.” ");
INSERT INTO wer_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Pël maan enselëpök kangiir epël mëëa. “Ne Kepriel, Anutuu ëöetak wë piin inëën elmëeim wëaup. Pimtok ngön ompyaö epët ök niamëak wes nemëën waisaup. ");
INSERT INTO wer_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Pël ëën ni kat wiak kön wi kosang newasën yaën. Pötaanök ngön won sak wëën nem ngön yeniak pipot kë oröönak kaalak ngön amëët.” ");
INSERT INTO wer_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Sekaraia pi ka ngerö ngëëngktak akun wali wëën omnarö kor wë kön selap ëa. ");
INSERT INTO wer_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Pël ëeim wëën ënëmak kakaatiaan oröak ngönaak mapënëak poprak ëa. Pël ëën omnarö pit epël kön wia. “Pi ka ngëëngkta kakaati omën it ngolöp nent itena koröp.” Pël ëën pi ngön apënëak pomp ëak moresiarëring ök elmëa. ");
INSERT INTO wer_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ënëmak Sekaraia pim ngönën tup kaöetak ya yamëngka akunet pet irën kaalak kakë sa. ");
INSERT INTO wer_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Pël ëën ënëmak Elisapet ru kepring sa. Pël ëak ëlëëpëlëëp ëeim wëën ngoon mor nas won sa. Pël ëën epël mëëa. ");
INSERT INTO wer_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Aköp pi kaamök elnëak omnaröa ëöetak nem ëöempel won newesak rungaap yenangk.” ");
INSERT INTO wer_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisapet pöp ru iirak ëaan ngoon mor nas nasiaan namp won sëën Anutuuk ensel Kepriel pöp wes mëën Kalili yangerak ka naö yapinte Nasaret pörekë sa. ");
INSERT INTO wer_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Pörek öng ulwas namp wëa yapinte Maria pi omp namp Yosep piin yaö elmëën wëa. Yosep pi Tewit pim körööp. ");
INSERT INTO wer_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Pël ëën Kepriel pi Maria pim naë së epël mëëa. “Yowe, Aköp pi nimëën ya ërëp ëak niiring wë.” ");
INSERT INTO wer_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Pël maan Maria pi kat wiak ya ngës ëën epël kön wia. “Tol ëënak yoöre ërëp epël yenëa?” pël kön wia. ");
INSERT INTO wer_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Pël ëën enselëpök epël ök mëëa. “Maria, ni kas ëëngan. Anutu pi nimëën ya ërëp yaë. ");
INSERT INTO wer_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nim yokot kepring sak wilumë pipop yapinte Yesu pël mam. ");
INSERT INTO wer_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Puuk omën kaö sak öpnaap. Pël ëën omnaröak piin yaya mëak Anutu kaö panëëpë Ruup pël mapnaap. Pël ëën Anutuuk pim körööp Tewit pim ëaul yangerakë omnaröa kaö wes moulmëëpnaap. ");
INSERT INTO wer_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Pi Yakopë ëere köröörö ngarangk ëak wakaim öpnaap. Pël ëën pim wa ngaöök nimëëpna pöt won nasëpan.” ");
INSERT INTO wer_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Pël maan Maria enselëpön epël mëëa. “Tol ëak pël ëëm? Ne omp wonöppe.” ");
INSERT INTO wer_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Maan enselëpök kangiir epël mëëa. “Ngëëngk Puloök nim naë wais Anutu ngaarëkëp pim weëre kosangët nim rangk niwiin kaamök elniipnaat. Pël ëën nim ru wilumë ngëëngk pöpön omnaröak Anutuu Ruup pël apnaat. ");
INSERT INTO wer_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Kat wi. Nim karip Elisapet pi ulöp saupök ru kepring wë. Ngaan, ‘Pi ru nawilpanëëp,’ pël aimautak peene pöt pi ru kepring wëën ngoon mor nas nasiaan namp ëak yes. ");
INSERT INTO wer_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Anutu pi omën nant ëëpënëak poprak naën yaaup.” ");
INSERT INTO wer_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Pël maan Mariaak kangiir epël mëëa. “Ne Anutuu inëën koontup. Pötaanök yaan pil elnëëp.” Pël maan enselëp pi sëp wesak sa. ");
INSERT INTO wer_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Maria pi akun tapëtakëër wal ëak Yutia rosir omnaröa kak nerekël sa. ");
INSERT INTO wer_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Pël ëak Sekaraia pim kaata kakaati së ilëak Elisapeten yoöre ërëp mëëa. ");
INSERT INTO wer_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Pël yemaan Elisapet pi Mariaë yoöre ërëp pöt kat yawiin ru Elisapet pim yaatak wëaö pöp elel ëa. Pël ëën Ngëëngk Pulö Elisapet piik ilëak peö ëa. ");
INSERT INTO wer_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Pël ëën ngön ëak Mariaan epël mëëa. “O öng epop, ni öng muntaröa ök won. Anutu pi niin ompyaö yaalni. Ën nim ru wilumë pöpta ompyaö elmëëpnaat. ");
INSERT INTO wer_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ne ompyaö talëpëën nem Aköpë ëlëpök nem naë yewaisën? ");
INSERT INTO wer_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Yoöre ërëp ngön neaan kat yawiin nem yaatak wëaupta kat wiak ërëpsawi ëak elel yaë. ");
INSERT INTO wer_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ni Aköpë ngön ök niia pöt kë rapna pöten kön wi kosang yewasën. Pötaan ërëpsawiaring ömëëp.” ");
INSERT INTO wer_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Pël maan Maria pi epël mëëa. “Nem lupmerök Aköpë yapinte wak yawis. ");
INSERT INTO wer_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ën nem könöpök Anutu ne utpetetakaan yeneö pötaan ërëpsawi yaalmë. ");
INSERT INTO wer_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Pi ne pim inëën koont pasip sant yaalnë. Pötaanök omën peene wë eporöere ënëm orööpnaarö pitök neen, ‘Anutuuk ompyaö yaalmë,’ pël apnaat. ");
INSERT INTO wer_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Anutu weëre kosangëp puuk retëng epët yaalnë. Pötaan pim yapinte ngëëngk wia. ");
INSERT INTO wer_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Pi omën pim iri wëaurö sant yaalmëaup. Omnaröa öpnaal sant pöt pangk ëak wiaapnaat. ");
INSERT INTO wer_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Pim moresök ya kosang mënak omën pitëmtëën wak isak yaaurö wa moolaan yes. ");
INSERT INTO wer_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Pi yang omp ak weëröeta wa moolëak omën yapin wonörö pitëm yapinöt wak isak yema. ");
INSERT INTO wer_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Pi omën ngöntök yaaö omnant wonörö ulöl wes yemangk. Ën ulöpre moupring wëaurö ngöntök yemowas. ");
INSERT INTO wer_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Pi tiarim ëaröen Apramre pim ruure ëarö kaamök elniipënëak kosang wesak ök mëëa. Pötaanök pi pim ngön kosang wesa pöten kön wiak Israel pim ya omnarö kaamök elnieim wë.” ");
INSERT INTO wer_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria pi Elisapetring wëën ngoon naar namp ëak won sëën kaalak pim kakë sa. ");
INSERT INTO wer_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisapet pim akunet temanöm sëën yokot namp wila. ");
INSERT INTO wer_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Pël ëën omën kaköröere nanangarö pit Aköpë sant elmëa pöt kat wiak piiring top ëak ërëpsawi ëa. ");
INSERT INTO wer_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Wë akun 7 ëak won sëën 8 pötak pit yokotup Anutuun yaö wesak pim koröp kaut ilëpënëak wa top ëa. Pël ëak pit Sekaraia pim pepapë yapin ngamp mapënëak mëëa. ");
INSERT INTO wer_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Pël maan ëlëpök ke urak epël mëëa. “Won, tiar pim yapinte Son pël mepa.” ");
INSERT INTO wer_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Pël maan pit epël mëëa. “Nim nanang nampë yapinte pil won wia.” ");
INSERT INTO wer_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Pël mëak pepapön mor ök elmëak yapin talte mapën pöten pëël mëëa. ");
INSERT INTO wer_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Pël ëën pi kël wësap naöön kimang elmëën wa mangkën puuk, “Yapinte Son,” pël retëng ëën pit yaan sa. ");
INSERT INTO wer_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Pël ëën tapëtakëër pim këmët kengkën sëën ngönte orö rëën Anutuun yaya mëëa. ");
INSERT INTO wer_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Pël ëën kak pörek wëaurö pit yaan sak pöta ngönte ka poutë ök maö yesem Yutia yangerak rosiratë ka wieëa pötëëta ök aö sëën pangk ë pet ira. ");
INSERT INTO wer_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Pël ëën omën pöt kat wia pörö om ngön pöt kön wieim wë Aköpök weëre kosang mena pël wesak epël mëëa. “Yokotup kaö sak tol ëëpën?” ");
INSERT INTO wer_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ngëëngk Pulö Sonë pepap Sekaraia pim lupmeri peö elmëën tektek ngön epël mëëa. ");
INSERT INTO wer_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Tiar Aköp, Israel omnaröa Anutu pim yapinte wak isak mapa. Puuk tiar kaamök elniak utpetetakaan ent ë yanuulë. ");
INSERT INTO wer_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Pim inëën ruup Tewit pim kurmentëkaan namp tiar utpetetakaan niöpënëak omën weëre kosangring pöp tau yaulmë. ");
INSERT INTO wer_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Omën pöpön ngaanëër pim tektek ngön yaaö ngëëngköröen ök maan pitëm këmötëaan epël aimaut. ");
INSERT INTO wer_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Aköpök tiarim kööre toköröere këëpöt yaniwesaurö pitëm naëaan ent ë nuulëëpnaat. ");
INSERT INTO wer_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Pi ngaanëër ngön ngëëngk kosang wes mena pöten kön wieë tiarim ëarö lup sant elmëeima. ");
INSERT INTO wer_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Pim ngön kosang wes mena pöt tiarim körööp Apramön epël mëëa. ");
INSERT INTO wer_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","‘Ne ar neen akun poutë ompyaöre wotpil wë kas naën inëën elnëënëën arim kööre toköröa naëaan kama niömaat.’ ");
INSERT INTO wer_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ën yokot epop, ni wet rëak Aköpëën kan ngësum. Pël ëëmë pötak omnaröak niin, ‘Anutu Ngaarëkëp pim tektek ngön yaaup,’ pël niapnaat. ");
INSERT INTO wer_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ni Anutuuk pitëm utpetatë kangut kërë moolëak utpetetakaan öpnaat pël ök maan kat wiipnaat. ");
INSERT INTO wer_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Anutu pi tiarimëën sant yaaup. Pötaan pël elniipnaat. Pi kutömweriaan namp tiarim naë wes mëën puuk këtëpë yema pöl ëwa elniipnaat. ");
INSERT INTO wer_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Pël ëën omën koutak wëauröere wel wiipënëak yaaurö ëwa elniak mayaap kanöök niulëën öpenaat.” ");
INSERT INTO wer_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ënëmak yokot Son pöp kaö sëëre könö kaö së pël ëa. Pël ëak yang omën wonrek së wakaim wiak pim ya mëmpna akunet temanöm sëën Israel omnaröa naë orö tekeri sa. ");
INSERT INTO wer_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Akun pötak Rom yang omp ak Sisa Okastas puuk omën pim iri wëauröa yapinöt öpënëak ngön kosang wia. ");
INSERT INTO wer_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ya pöt ngaan namëngkënte, Sairinias pim Siria yangerak yang ngarangk ëak wëaö akun pötak ngës rëa. ");
INSERT INTO wer_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Pël ëën omën pourö pit yapin wiipënëak pitëm ka songönötë sa. ");
INSERT INTO wer_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yesën Yosep pi Tewit pim körööpök Kalili yangerak Nasaret pörek wëa. Pötaanök Yutia yangerak Tewit pim kak Petelem pörekë sa. ");
INSERT INTO wer_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Sëpënëak pim öng yaup Maria pöpta yapin wiipënëak koirak piarip pouwaar sa. Maria pöp ru kepringëp. ");
INSERT INTO wer_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Pël ëak wëën Maria pim ru wilëpna akunet temanöm sa. ");
INSERT INTO wer_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Pël ëën pim yokot wetkaalëp wila. Pël ëak poë koröp kautak kör koëak pol purmakaöröa kaömp umweri öngpök mowiin wieëa. Su kaat omën peö ëa. Pötaanök ur ap wesak purmakaö kaatak së wëa. ");
INSERT INTO wer_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Petelem kak pörekë naë omën narö pitëm pol sëpsëpörö rö kan koinë ngarangk eim wëa. ");
INSERT INTO wer_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Pël ëën Aköpë ensel namp pitëm naë së oröön Aköpë ëwaöök pitëk ëwa elmëën kas kaö ëa. ");
INSERT INTO wer_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Pël yaëën enselëpök epël mëëa. “Ar kas ëëngan. Kat wieë. Ne arimëën ping ngön ompyaut wak yewais. Yang poutë omnarö kat wiak ërëpsawi ëënëët. ");
INSERT INTO wer_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Peene öng nampök Tewitë kak eprek rungaap yawil pipop ar omën pourö utpetetakaan niöpnaap. Pi Aköp Kristo, Anutuuk Yaö Mëëaup. ");
INSERT INTO wer_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Itenak yaap ëa wasënëëtaan wetete niamaan. Poë koröpöök kör koëak pol purmakaöröa kaömp umweri wiaan itaampunëët.” ");
INSERT INTO wer_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Pël maötaring ensel muntarö kësang pan tapët pöt pitëm karipë naë oröak Anutuun yaya mëak epël mëëa. ");
INSERT INTO wer_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Anutu Ngaarëkëp pim yapinte wak isëp. Omen pim lup sant elmëaurö pitëm naë mayaap wiaap.” ");
INSERT INTO wer_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Enselörö pit kaalak kaip tiak kutömweri sëën sëpsëp ngarangkörö pit neneren epël mëëa. “Tiar Petelem kak së oröak Aköpë ök yenia pipten iteempa.” ");
INSERT INTO wer_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Pël mëak pit teëntom pan së Mariaare Yosep koirak itaangkën öngaap poë koröpö kör koëak pol purmakaöröa umweri wiaan itena. ");
INSERT INTO wer_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Pël ëak yokot pöpëën ngön ök maan kat wia pöt ök mëëa. ");
INSERT INTO wer_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Pël ëën omën pörek wëa pörö pourö pit sëpsëp ngarangköröa ngön ök mëëa pöt kat wiak yaan sa. ");
INSERT INTO wer_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ën Maria pöt ngön pöt kat wiak pim lupmeri wa wiak om kön wieima. ");
INSERT INTO wer_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Pël ëën pol sëpsëp ngarangkörö pit kaalak yesem enselëpök rungaapëën ök mëëa pöl itaampööre kat wi ëa pötëën Anutuun yaya maima. ");
INSERT INTO wer_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Yesu wilën wieë akun 7 ëak won sëën 8 pötak pit pim koröp kaut ilak yapinte Yesu mëëa. Yapin pöt pi yaatak won wiaan enselëpök ök mëëaut. ");
INSERT INTO wer_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Mariaare ruup piarip kak wë piarpim iirëpna akunet temanöm yesën Moses pim ngön kosangöt ngar wak Yosepring Yerusalem kak së yokotup Aköpëën yaö mowasëpënëak wak sa. ");
INSERT INTO wer_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Pöt Aköpë ngön kosang epël wia pöt ngar wak pël ëa. “Yokot wetkaalörö wilën pöt Aköpëën yaö mowasën.” ");
INSERT INTO wer_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Pël ëak piarip Aköpë ngön kosangöt ngar wak Aköpëën yaö mowasëpnaataan int ek naar kiri ar ëëpënëak wak sa. ");
INSERT INTO wer_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Yerusalem kak omën namp wakaima yapinte Simion. Pi omën wotpil ngönënringëpök omën Israel omnarö utpetetakaan moöpna pöpön kor wëën Ngëëngk Pulö piiring wakaima. ");
INSERT INTO wer_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ngëëngk Pulöök ngaan piin epël ök mëëa. “Ni wel nawiin om wëën Aköpë Yaö Mëëaup, Kristo, oröön itenakök wel wiimëët.” ");
INSERT INTO wer_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Omën pöp Ngëëngk Pulöök elmëën Anutuu ngönën tup kaöetak së wëa. Pël ëën Yosepre Maria piarip rungaap wak ngön kosangta wieëaul elmëëpënëak ngönën tupta kakaati sa. ");
INSERT INTO wer_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Pël ëën Simion pi Yesu wak kapariak epël mëak Anutuun yaya mëëa. ");
INSERT INTO wer_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Aköp nim neaan pöt yok kë yaarö. Pötaanök nuuk aan ne ya kë sak wë wel wiimaan. ");
INSERT INTO wer_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Nem itöök nim omën ten utpetetakaan niöpënëak yaan pöpön ityaangk. ");
INSERT INTO wer_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Aköp ni omën pouröak piin itaampunëak ko ë ninaup. ");
INSERT INTO wer_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Puuk kopël omnaröa lupöt ëwa yaalmë. Ën Israel nim omnarö tenim yapinte wak yawis.” ");
INSERT INTO wer_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Yokotupön pël yemaan ëlre pepaar piarip kat wiin pölöppölöp ëa. ");
INSERT INTO wer_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Pël ëën Simion pi welaköt elmëak yokotupë ëlëp Mariaan epël mëëa. “Yokot epopë naë Israel omnarö pit komre kap ëëpnaap. Pël ëak narö pim naëaan kawi ngentiipnaat. Ën narö pim naë tauak kosang sëpnaat. Puuk sowi mowiin omnarö pimëën ngön utpet apnaat. ");
INSERT INTO wer_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Pit pël yemaan pitëm kön ëlëëpöt yoolök wasëpnaat. Pël yaëën nimëntta ya këlangön ëak yaköm kön wiimëët.” ");
INSERT INTO wer_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Tektek ngön yaaö öng namp wëa yapinte Ana. Pi Panuel pim koontup, Asa pim kurmentëkaanëp. Pim öng ulwasöök omp wak wëën krismaki 7 ëak sëën ");
INSERT INTO wer_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","wel wiin öng tek wakaima. Pim krismakiat 84. Öng ulöp pöp pi akun poutë ngönën tup kaöet sëp newasën këtëkre rö kan poutë Anutuun yak kë ngës olëak wë kimang maim wakaima. ");
INSERT INTO wer_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Öng pöp pi akun pötak pitëm naë së Anutuun yokotupëën yaya mëak Yuta omën Anutuuk pit utpetetakaan moöpënëak kor wakaimauröen yokotupë ngönte ök mëëa. ");
INSERT INTO wer_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yosepre Maria piarip Aköpë ngön kosangta wieëa pöl omnant pout ë pet irak kaalak Kalili yangerak Nasaret kakë sa. ");
INSERT INTO wer_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Pël ëak yokotup kaö sak weëre kosang wak ëwat kaöempelring wëën Anutu pimëën ya kë sa. ");
INSERT INTO wer_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Yesuu ëlre pepaar piarip Anutuu mait elmëa akun poutë Yerusalem kak seim yeëa. ");
INSERT INTO wer_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Pötaanök piarpim yaaul Yesu krismakiat 12 ëak won saupök mësak pit pourö sa. ");
INSERT INTO wer_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Pël ëak wë ngëëngk akunet pet irën kaalak kakë sëpënëak yokotup Yerusalem kak om wëën piarip pöten köpël yak sa. ");
INSERT INTO wer_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Pël ëak yesem yokotup omën karuröaring yes wesak kët pöt seim wiap kan piarpim kar pöröa naë ap wesa. ");
INSERT INTO wer_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Pël ëak pitëm naë ap wes pet irak kaalak Yerusalem kak ap wasëpënëak sa. ");
INSERT INTO wer_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Pël ëak ap weseim wëën akun nentepar nent ëak won sa. Pël ëën ënëmak ngönën tup kaöeta kakaati së itaangkën pörek rë yemoulauröa tekrak wel aisëeë pitëm ngönöt kat wiak songönötön pëël maim wëa. ");
INSERT INTO wer_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Pël ëën omën pim ngön kat wia pörö pit pim ngön kaip ti mampööre ëwat yaautaan itenak yaan sa. ");
INSERT INTO wer_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Pël ëën pim ëlre pepaar piin itenak yaan sak ëlëpök epël mëëa. “Yokot epop, tol ëënak tenipön epël yaalniin? Ten pep yaköm ë sak niin ap wasö imep.” ");
INSERT INTO wer_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Pël maan kangiir epël mëëa. “Oröpmorëënök neen ap wasö im? Arip köpël ma? Ne nem Pepapë kaatak wëep.” ");
INSERT INTO wer_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Pël maan piarip ngön pöt kat wiak ëngk ma e wesa. ");
INSERT INTO wer_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Pël ëën ëlre pepaarring pit kaalak Nasaret kak së wë piarpim ngön ngar weim wakaima. Ën ëlëp pöt pi omën itenak kat wia pöt pim lupmeri wa wiak kön wieima. ");
INSERT INTO wer_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Pël ëën Yesu pi wë kaö sak pim ëwatte ompyaö ëa. Pël ëën Anuture omnarö piin itaangkën pangk ëa. ");
INSERT INTO wer_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Son, Sekaraiaë ruup, pi yang omën wonrek wëën Anutuuk ya ngön mëëa. Akun pötak omën eporöak yang ngarangk eim wëën Anutuuk pël mëëa. Rom omp ak Taipirias Sisa pi Rom yang pör ngarangk ëak wëën krismaki 15 ëak won sa. Akun pötak Pontias Pailat pi Yutia yanger ngarangk ëeëa. Ën Erot pi Kalili yangera kaö sak wëën pim nangap Pilip pi Ituriaare Trekonaitas yangera kaö sak ngarangk ëa. Ën Laisenias pi Apilini yanger ngarangk ëeëa. Ën Anasre Kaiapas piarip kiri ar yaauröa wotöök wëa. Akun pötak Anutuuk Sonön ya ngön mëëa. ");
INSERT INTO wer_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Pël ëën pi i Yotanë we naöökaan naöök yesem Anutuuk omnaröa saunatë kangut ent ë moolapnaataan lup kaip tiin i momëëpënëak ök maima. ");
INSERT INTO wer_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Pöta ngönte tektek ngön yaaup Aisaia puuk epël ngönëntak retëng ëa pöt Son pim naë kë oröa. “Yang pultakaan omën nampök epël ya. ‘Aköpëën kanö wotpil weseë. Ngësak ompyaö panë weseë. ");
INSERT INTO wer_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","I kön pipotta yang rë ngep ëeë. Pël ëak rosir kotre kaö pipotta pout mëngkën iri rëëp. Kan pek wia pipotta wotpil weseë. Pël ëak kamtaöök kël wia pipotta wa moolëak won weseë. ");
INSERT INTO wer_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Pël ëën omën pourö Anutuuk utpetetakaan yaniö pöten itaampenaan.’” ");
INSERT INTO wer_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Omën kësang Sonök i momëëpënëak pim naë sëën epël mëëa. “Kamalöröa morök yaalni pöl ar yaaurö. Ar kön wiin nem naë waisën i nimëëma pöt Anutuuk nga elniipënëak ya pöt naalniipan. ");
INSERT INTO wer_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ar lup kaip tiak wëwë pötakël önë pötakëër omnaröak arën itaangkën lup kaip tian pël ëëpnaat. Arimtë könöök epël angan. ‘Ten Apramë köröörö,’ pël angan. Ar kön wi kosang newasën wë, ‘Ten Apramë köröörö,’ pël anë pöt pangk naën. Ne niamaan kat wieë. Anutu pi apënëak pöt yok pangk aan kël epotök Apramë körö koröp orööpnaat. ");
INSERT INTO wer_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Anutuuk iner këra songöntak wia. Këra nement ulöp ompyaö nautön ëëpna pöt ku tiak es marën kotöpnaat.” ");
INSERT INTO wer_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Pi pël maan pit piin pëël mëëa. “Elei, ten tol ëën?” ");
INSERT INTO wer_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Pël maan puuk kangiir epël mëëa. “Omën namp pim ulpëën naar wiaan pöt omën wonöp namp mamp. Ën namp kaömpöt selap wiaan pöt tapël muntap nant mamp.” ");
INSERT INTO wer_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Takis yewa omën naröeta i mëëpënëak sa. Pël ëak pi ngön pöt maan kat wiak epël mëëa. “Rë yanuulaup, ten tol ëën?” ");
INSERT INTO wer_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Maan puuk epël mëëa. “Ar omnaröa naëaan takis önëak pöt ngarangköröa niia pil pëën ön. Arök arimëën kaut önganok.” ");
INSERT INTO wer_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Pël maan nga omën naröeta kaalak pëël mëëa. “Ën ten tol ëën?” Pël maan puuk epël mëëa. “Arta omnarö mööre kaar ëak sumat wë pël ëënganok. Ar arimtë ya yamëngkauta sumat pëën weë. Muntat önëak kent ëëngan.” ");
INSERT INTO wer_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Son pi pël maan omnarö pit ërëpërëp ëak pimëën kön selap ëak epël mëëa. “Epop Yaö Mëëaup Kristo tapöp koröp.” ");
INSERT INTO wer_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Pël yaan pit pouröen epël ök mëëa. “Omën nem ënëm waisëpna pöp pim weëre kosangtak nemët il wasëpnaap. Ne utpet epopök pim ing korötepar wii nemowilnganëëp. Ne i yaaptaring i yanimë. Puuk pöt ar Ngëëngk Pulö nimëën esuwesi ök arim utpetat kotak won sëpnaat. ");
INSERT INTO wer_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Pi pim kat yaurautaring wais kat ur rongan ëak kaömp ompyaut wa pim kaömp kaatak wiipnaat. Pël ëak unönre söksök pöt wa top ëak es kosangwesi moolaan kot sëpnaat.” ");
INSERT INTO wer_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Son pi ngön pöt ök mëak wa korkor ngön munt nantre ngön ompyaut omnaröen ök mëëa. ");
INSERT INTO wer_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Pël ëak yang ngarangk kaöap Erot pi utpet nant yaaupök pim nanëpë öngöpta wa ëp ëa pötaan ngön kosang mëëa. ");
INSERT INTO wer_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Pël ëa pöta rangk saun kaö panëët Son wii kaatak moulmëa. ");
INSERT INTO wer_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Son pi wii kaatak nemoulmëën wiaan omnarö i momëak Yesuta i momëa. Pël ëën pi Anutuun kimang yemaan kutömwer këm nga ëën ");
INSERT INTO wer_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ngëëngk Pulö int ekëpë ök sak Yesuu rangk irëa. Pël yaëën kutömweriaan ngön nent epël mëëa. “Ni nem Ruup. Ne niin ya kë sak kent pan yaalni.” ");
INSERT INTO wer_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu pi pim krismaki 30 ëak won sëën pim yaat ngës rëa. Pël yaëën omnaröak piin kön wiin Yosepë ruup pël ëa. Yosep pöp Ilai pim ruup. ");
INSERT INTO wer_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Ilai pöp Matat pim ruup. Matat pöp Liwai pim ruup. Liwai pöp Melkai pim ruup. Melkai pöp Sanai pim ruup. Sanai pöp Yosep pim ruup. ");
INSERT INTO wer_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yosep pöp Matataias pim ruup. Matataias pöp Emos pim ruup. Emos pöp Neam pim ruup. Neam pöp Eslai pim ruup. Eslai pöp Nakai pim ruup. ");
INSERT INTO wer_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nakai pöp Meat pim ruup. Meat pöp Matataias pim ruup. Matataias pöp Semen pim ruup. Semen pöp Sosek pim ruup. Sosek pöp Sota pim ruup. ");
INSERT INTO wer_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Sota pöp Soanan pim ruup. Soanan pöp Resa pim ruup. Resa pöp Serapapel pim ruup. Serapapel pöp Sialtiel pim ruup. Sialtiel pöp Nerai pim ruup. ");
INSERT INTO wer_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nerai pöp Melkai pim ruup. Melkai pöp Etai pim ruup. Etai pöp Kosam pim ruup. Kosam pöp Elmatam pim ruup. Elmatam pöp Er pim ruup. ");
INSERT INTO wer_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er pöp Yosua pim ruup. Yosua pöp Eliesa pim ruup. Eliesa pöp Sorim pim ruup. Sorim pöp Matat pim ruup. Matat pöp Liwai pim ruup. ");
INSERT INTO wer_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Liwai pöp Simion pim ruup. Simion pöp Yuta pim ruup. Yuta pöp Yosep pim ruup. Yosep pöp Sonam pim ruup. Sonam pöp Elaiakim pim ruup. ");
INSERT INTO wer_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elaiakim pöp Melia pim ruup. Melia pöp Mena pim ruup. Mena pöp Matata pim ruup. Matata pöp Netan pim ruup. Netan pöp Tewit pim ruup. ");
INSERT INTO wer_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Tewit pöp Sesi pim ruup. Sesi pöp Opet pim ruup. Opet pöp Poas pim ruup. Poas pöp Salmon pim ruup. Salmon pöp Nason pim ruup. ");
INSERT INTO wer_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason pöp Aminatap pim ruup. Aminatap pöp Atmin pim ruup. Atmin pöp Anai pim ruup. Anai pöp Esron pim ruup. Esron pöp Peres pim ruup. Peres pöp Yuta pim ruup. ");
INSERT INTO wer_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yuta pöp Yakop pim ruup. Yakop pöp Aisak pim ruup. Aisak pöp Apram pim ruup. Apram pöp Tera pim ruup. Tera pöp Neo pim ruup. ");
INSERT INTO wer_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Neo pöp Serak pim ruup. Serak pöp Reu pim ruup. Reu pöp Pelek pim ruup. Pelek pöp Epe pim ruup. Epe pöp Sela pim ruup. ");
INSERT INTO wer_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela pöp Kenan pim ruup. Kenan pöp Apaksat pim ruup. Apaksat pöp Sem pim ruup. Sem pöp Noa pim ruup. Noa pöp Lamek pim ruup. ");
INSERT INTO wer_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek pöp Metusala pim ruup. Metusala pöp Inok pim ruup. Inok pöp Saret pim ruup. Saret pöp Malalel pim ruup. Malalel pöp Kenan pim ruup. ");
INSERT INTO wer_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan pöp Inos pim ruup. Inos pöp Set pim ruup. Set pöp Atam pim ruup. Atam pöp Anutu pim ruup. ");
INSERT INTO wer_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesu pi Ngëëngk Pulöök pim lupmeri peö ëak mësak Yotan imer sëp wesak yang omën wonrekë sa. ");
INSERT INTO wer_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Pël ëak wë kët 40 ëak won sëën Seten pim naë së oröak morök elmëa. Akun pötak pi kaömp won pan ëa. Pël ëën akun pöt won sëën këën wel wia. ");
INSERT INTO wer_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Pël yaëën Setenök epël mëëa. “Ni Anutuu Ruup. Pötaanök kël epotön maan kaömp sëën në.” ");
INSERT INTO wer_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Pël maan Yesuuk kangiir epël mëëa. “Ngönëntak epël wia. ‘Kaömp pöt pëënök omnaröa wëwëet nanimpan.’” ");
INSERT INTO wer_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Pël maan Seten pi Yesu mësak rosir naöök is moulmëak tapëtakëër yangerakë omën poutön pet elmëak ");
INSERT INTO wer_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","epël mëëa. “Yang epotë omën nantre nant pötë weëre kosang nem naë wiaan namp ngarangk elmëëpnaataan mempëak pöt mempaat. Pötaanök ni ngarangk ëëmëëtaan nimpëak yeë. ");
INSERT INTO wer_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Pötaanök ni nem iri ilëak yaya neamë pöt omën epot pout nimëën sëpnaat.” ");
INSERT INTO wer_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Maan Yesuuk kangiir epël mëëa. “Ngönëntak epël wia. ‘Aköp Anutuun yaya mam. Pimënt kopëtapön inëën elmëëm.’” ");
INSERT INTO wer_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Pël maan Seten pi kaalak Yesu mësak Yerusalem kak së ngönën tup kaöeta möröök moulmëak epël mëëa. “Ni Anutuu Ruup. Pötaanök eprekaan öngkrek sörok ola. ");
INSERT INTO wer_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Pöta ngönte ngönëntak epël wia. ‘Anutu pi pim enselöröen maan ni ngarangk elniipnaat.’ ");
INSERT INTO wer_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ën ngönën nenteta epël wia. ‘Këlötök nim ingesi niwalpanëën pitök morötök akaak elniipnaat.’” ");
INSERT INTO wer_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Pël maan Yesuuk kangiir epël mëëa. “Ngönën nenteta epël wia. ‘Aköp Anutuun kaamök elniipnaaten ököök elmëëngan.’” ");
INSERT INTO wer_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Pël maan Seten pi morök ke nentere nent elmë pet irak akun nentakëën wesak sa. ");
INSERT INTO wer_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesu pi Pulöök weëre kosang kaamök elmëën Kalili yangerakël kaalak sa. Pël ëën pim ëa pöta ngönte yang pörek sa pet ira. ");
INSERT INTO wer_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Pël ëën ngönën tupötë ngönën ök yemaan omën pourö pim yapinte ngar wa. ");
INSERT INTO wer_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yesu pi Nasaret kak pim kotuuk wakaimaurekë sa. Pël ëak pim yaaul kë yesa akun ngëëngktak ngönën tuptak së ngönënte sangk kelëpënëak wal ëa. ");
INSERT INTO wer_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Pël ëën nampök Aisaia pim ngönën pepewer mangkën wilak epël retëng ëaö pöt koira. ");
INSERT INTO wer_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Aköpë Pulö neering wë. Pim ngön ompyaut omën omnant wonöröen ök mamëak yenëa. Pi ngön epël ök mamëak wes nemëën waisaut. ‘Ar wii kaatak wëaurö, nook wil niulëën kan sënëët. Ën ar it ngaap wëaurö, nook ompyaö niwasën nga sënëët.’ Pi këlangön kat wieim wëaurö pitëm këlangön yemengkauröa naëaan wil moulmëën sëpënëak wes nemëaut. ");
INSERT INTO wer_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Pi Aköpë omnarö utpetetakaan moöpëna akunet temanöm yes pötenta ök mamëak wes nemëaut.” ");
INSERT INTO wer_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yesu pi ngön lup pöt sangk kelak pepewer kaalak koö möak ya omnamp menak wel aisëa. Pël ëën omën ngönën tup pötak wëa pörö pourö piin it kos elmëeëa. ");
INSERT INTO wer_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Pël ëën ngës rëak epël ök mëëa. “Ngönën lup sangk kelën kat yawi pipët peene kë yaarö.” ");
INSERT INTO wer_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Pël maan pit piin kön wiin isën kön selap ëak pim këmtakaan ngön ompyaut oröa pöten yaan sak neneren epël mëëa. “E, tiar piin ëwat wëep. Pi Yosepë ruuppe.” ");
INSERT INTO wer_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Pël maan Yesuuk kangiir epël mëëa. “Tiar akun poutë, ‘Rotap nimtë yaumantë won wasum,’ pël yaaurö. Pöta ök arök neen, ‘Pi yaap ma kaar ya,’ pöt itaampunëak waswas ngön pöt an koröp. Pël neak arök kaalak, ‘Nim Kapaneam kak ya mëngkën kat wian pöt nimtë wëaö eprekta pël namëngkan ma?’ pël an koröp.” ");
INSERT INTO wer_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Pël mëak epël mëëa. “Ne yaap niamaan. Tektek ngön yaaö nampök ngönte aan pimtë ka songöntakörö kat nawiin yaaurö. ");
INSERT INTO wer_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ne yaap niamaan kat wieë. Arim köröörö tektek ngön yaaup Elia pim ngönten kat nawiin ëën Anutuuk maan kopi nepelën wiaan krismaki 3 ngoon 6 ëak won sëën kaömp ngöntök kësang pan yang poutë wiakaima. Akun pötak öng kapir kësang Israel yangerak wë kaömp ngöntök wakaima. ");
INSERT INTO wer_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Pël yaëën Anutuuk Elia pitëm naë wes namëën, Saiton yangerak Sarepat kak öng kapir kopët namp wëa pöpë ngësël wes momëën sa. ");
INSERT INTO wer_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Pöta ök, tektek ngön yaaup Ilaisaë wakaima akunetak Israel omnaröa naë omën selap kësë ëak wakaima. Omën pörö pitëm naëaan namp ompyaö nemowasën won. Neaman Siria yangerakaanëp pi kopëtapökëër ompyaö mowesa.” ");
INSERT INTO wer_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Pël maan omën ngönën tupta kakaati wëaurö pit ngön pöt kat wiak ya sangën pan ëa. ");
INSERT INTO wer_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Pël ëën wal ëak Yesu moröak kaöökë wilëngkëël sa. Pitëm ka pö tomönta rangk wieëa. Pötaanök pit pi wak parëaöök moolapënëak sa. ");
INSERT INTO wer_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pël ëën Yesu pi pitëm teköök ilëak kö sak sa. ");
INSERT INTO wer_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yesu pi Kalili yangerak ka naöökë yapinte Kapaneam pörek së kët kë yesa akun ngëëngktak omnaröen ngönën ök mëëa. ");
INSERT INTO wer_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Pël ëën pit kat wiin pi pepapök öngpököt wa kotiak yemaan kat wiak yaan sa. ");
INSERT INTO wer_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Pël ëën ngönën tup pöta kakaati omën urmerap pim lupmeri wëaö namp puuk Yesuun ngön ëak epël mëëa. ");
INSERT INTO wer_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Elei, Yesu Nasaretaanëp. Ni ten tol elniim? Ni utpet niwasumëak waisan koröp. Ne niin ëwat wë. Ni Anutuu naëaan Omën Ngëëngkëp.” ");
INSERT INTO wer_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Pël maan Yesuuk urmer pöpön ngön kosang mëak epël mëëa. “Ni ngön angan. Omën pipop sëp mowesak oröak së.” Pël maan urmer pöp utpet nemowasën, om oröak sëpënëak pi kutpat ë omnaröa teköök moolëak oröak sa. ");
INSERT INTO wer_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Pël ëën pit yaan panë sak neneren epël mëëa. “Elei, ngön epët tol nent? Pi weëre kosangring urmeraröen ngön maan kat wiak oröak kas yesëp.” ");
INSERT INTO wer_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Pël mëak pit pöta ngönte aö sëën yang pörek ka wieëa pötë sa pet ira. ");
INSERT INTO wer_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu pi ngönën tuptakaan oröak Saimonë kaata kakaati sa. Pël ëak itaangkën Saimonë öng lëlamöp yauman koröp es nga kaö nent yeem wieëa. Pël yaëën pit puuk kaamök elmëëpënëak mëëa. ");
INSERT INTO wer_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Pël ëën Yesu pi öng yauman wieëaupë naë së taueë yaumanten nga mëëa. Pël ëën öngöp pi tapëtakëër koröp es nga pöt won sëën wal ëak kaömp ar ë mena. ");
INSERT INTO wer_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Kët yeilaan omnarö pitëm kar yauman ke nentere nent yaaurö mësak pim naë sëën pim moresiar pitëm rangk mowiak yaumanöt ompyaö mowesa. ");
INSERT INTO wer_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Pël yaëën urmerarö pit omën naröakaan oröak yesem ngön ëak epël mëëa. “Ni Anutuu Ruup.” Pöt pit pi Kristo, Yaö Mëëaup, pöten ëwat wëa. Pötaanök pim songönten ök mapanëak nga mëëa. ");
INSERT INTO wer_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ëlpam walën Yesu pi kaöökaan oröak yang lup omën won nentak së wëën omnarö pit ap wasö së koirak pi sëpanëak mëëa. ");
INSERT INTO wer_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Pël ëën Yesu pi epël mëëa. “Ne Anutuu omnarö wa ngaöök nimëëpna ngön ompyaö pöt ök niamëak wes nemëaup. Pötaanök omën ka muntatëëröenta ök maö sum.” ");
INSERT INTO wer_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Pël mëak Yuta omnaröa ngönën tup wieëa pötë ngönën ök maima. ");
INSERT INTO wer_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Akun nentak Yesu pi Kenesaret i kaöökë pisöök wëën omën kësang pan pit Anutuu ngönte kat wiipënëak së wa rongan ëak pi kör mokoëa. ");
INSERT INTO wer_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Pël ëën i pisöök pörek wang kot naöörar wieëa. Pepaar pöt wi ulmëak së iiröt iireim wëa. ");
INSERT INTO wer_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Pël ëën Yesu pi Saimon pimöökë ngaarëk isak Saimonön kot nent mök ë i kaöökël mëëpënëak mëak pöök wel aisëak wë omnaröen ngönën ök mëëa. ");
INSERT INTO wer_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Pël ë pet irak Saimonön wangaö kaalak i kaöökël mök ë mëak iiröt olëak i kaö imën narö waulöpënëak mëëa. ");
INSERT INTO wer_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Pël maan Saimonök kangiir epël mëëa. “Kaöap, ten röök epöök weë ngentiak pël ëeim imën namp naön ëautep nim ngöntak kaalak olamaan.” ");
INSERT INTO wer_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Pël mëak pit iiröt olaan imën kësang pan ilëak peö ëën iiröt ilëpënëak ëa. ");
INSERT INTO wer_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Pël ëën pit pitëm karurö wang muntaöök wëauröen kaamök elmëëpënëak moresring waiseë elmëën së kaamök ëak wangaöörarë wiin könöm menak i kaöök ilapënëak ëa. ");
INSERT INTO wer_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Pël ëën Saimon Pita pi pöten itenak Yesuu ingrak tok oriak epël mëëa. “O Aköp, ne utpetapök sëp newesak së.” ");
INSERT INTO wer_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Pöt piire omën pörek wëa pörö pit imën kësang pan wa pöten yaan sak pël mëëa. ");
INSERT INTO wer_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Pël maan Sepeti pim ruaar Semsre Son, Saimon pim karaar, piaripta tapël yaan sa. Pël ëën Yesuuk Saimonön epël mëëa. “Ni kas ëëngan. Ënëmak nim i kaö imënörö yewan pi tapël omnaröeta ömëët.” ");
INSERT INTO wer_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Pël maan pit wangaöörar weruak së i pisöök më ulmëak pitëm omnant pout sasa sëp mowesak Yesuu ënëm elmëa. ");
INSERT INTO wer_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yesu pi kak nerek së wëën omën namp pim koröp pou kësë ëaup Yesuun itenak pim naë së tok oriak ë koset yangerak elak wë epël mëak kimang mëëa. “Aköp, ni ompyaö newasumëak pöt yok pangk ompyaö newasumëët.” ");
INSERT INTO wer_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Maan Yesuuk moresiar pim rangk mowiak, “Pël ëëmëak yeëerek, ompyaö së,” pël maan tapëtakëër pim kësëat won sa. ");
INSERT INTO wer_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Pël ëën Yesuuk ngön kosang mëak epël mëëa. “Epël yaalni epëta ngönte omnaröen ök manganok om el wesak së nim koröpö kiri ar yaaö nampön pet elmë. Pël ëak omnarö nim ompyaö san pöt ëwat sëpnaan Moses pim ngön kosangta wia pöl kiri ar ëëm.” ");
INSERT INTO wer_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Pël maan Yesu pim elmëa pöta ngönte ka poutë kat wi pet irak omën kësang pan pim ngön kat wiire yaumanöt won wasö pël ëëpënëak pim naë së oröa. ");
INSERT INTO wer_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Pël yaëën pi yang omën wonrekël së Anutuun kimang mëëa. ");
INSERT INTO wer_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Kët nentak Yesu pi omnaröen ngönën ök maim wëën ka poutë Kalili yangerakaanre Yutia yangerakaanre Yerusalem kakaan omën ngön kosangötë ngarangk naröere Parisi ngönën omën narö pitta pörek wel aisëak wëën Aköpë weëre kosangöök Yesu kaamök elmëën yauman omnarö ompyaö mowesa. ");
INSERT INTO wer_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Pël yaëën omën narö omën kosat kël wa namp urweri wiak wak naë së kakaati ilëak Yesuu naë mowiipënëak itaangkën omën kësang pan peö ëak wëa. ");
INSERT INTO wer_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pël ëën pit yaumanëp wak kakaati sëpënëak omnaröaan kan pomp ëak kamöröökë ngaarëk is kamörö kan wesak omën pöp urtaring wes mëën yangerak omnaröa tekrak Yesuu naë ngemëa. ");
INSERT INTO wer_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Pël ëën Yesu pi pitëm kön wi kosang yewesautön itenak epël mëëa. “Ngöntöp, ne yok nim saunatë kangut ent ë yanuulak.” ");
INSERT INTO wer_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Pël yemaan omën ngön kosangötë ngarangköröere Parisi omnarö neneren epël mëëa. “Omën epop pim oröptak Anutu wa iri yemowas? Omën nampök yok pangk omën muntapë saunatë kangut ent ë nemoolangan. Ya pöt Anutu pimtëëtep.” ");
INSERT INTO wer_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Pël yaan Yesu pi pitëm lupötön itenak epël mëëa. “Ar tol ëënak kön pil yawi? ");
INSERT INTO wer_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Nem omnampön, ‘Nim saunatë kangut ent ë yanuulak,’ ngön pël yemak pöt kengkënte. Pöt ar ngön pöta këët tekeri nasën ëën nem ngön pöt yaap ma kaar pël newasngan. Ën nem omnampön, ‘Wal ëak së,’ ngön pël yemak pöt könömët. Pöt nem ngön pöta këët tekeri sëën nem ngön pöt yaap ma kaar pël wasënëët. ");
INSERT INTO wer_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Pötaanök ar ne kaar omën wonöp Omën Këëp e yangerak wë weëre kosang wak saunatë kangut ent ë yemoolak pöten ëwat sënëën epël ök yemaan iteneë.” Pël mëak kosat kël wa pöpön epël mëëa. “Ne epël niamaan kat wi. Ni wal ë korumönte wak nim kaatakë së.” ");
INSERT INTO wer_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Pël maan tapëtakëër pitëm itöök wal ë pim korumönte wak pim kaatakë yesem Anutuun yaya mëëa. ");
INSERT INTO wer_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Pël ëën omën pourö itenak yaan panë sak Anutuun ping wesak epël mëëa. “Peene ten omën it ngolöp nenten ityaangk.” ");
INSERT INTO wer_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Yesu pi kaatakaan oröak yesem takis yewa omën namp yapinte Liwai pöp pim takis yewa kaatak wëën itenak epël mëëa. “Ni nem ënëm elnë.” ");
INSERT INTO wer_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Pël maan Liwai pi wal ëak pim omnant pout sëp wesak Yesuu ënëm sa. ");
INSERT INTO wer_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Liwai pi Yesuun sis nëmpënëak kaömp ar ëak takis yewa pim kar naröere omën munt naröen maan pim kaatak së piaripring kaömp na. ");
INSERT INTO wer_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Pël ëën Parisi omnaröere pitëm ëwat omnarö pit Yesuu ruuröen epël ök mëëa. “Ar tol ëënak omën takis yewauröere saun omnaröaring iire kaömp ngawi yen?” ");
INSERT INTO wer_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Pël maan Yesu kangiir epël mëëa. “Omën yauman wonörö rota ngësë nasën. Yaumanringöröakëër rotaaröa ngësë sa yaë. ");
INSERT INTO wer_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ne omën pitëmtën kön wiin wotpilörö pël yewas pörö lup kaip tiipnaan memëak newaisën. Won, ne omën pitëmtën kön wiin saun yaaurö pël yewas pörö ngön ök maan lup kaip tiipënëak waisaup.” ");
INSERT INTO wer_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Yesuuk pël maan pit kangiir epël mëëa. “Sonë ruurö pit Anutuun yak kaömp ngës olëak wë kët poutë Anutuun kimang më yaë. Ën Parisi tenim ruuröeta tapël ë yaë. Ën nim ruurö pöt kaömp nëëre i në pël ëeim.” ");
INSERT INTO wer_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Maan Yesuuk pitëm pim karuröaan kaaö ngön mëëa pöten kat wiak kangiir epël mëëa. “Ar yok pangk omën namp öng öpënëak yeem pim karuaröaring wëën pöt karuröen, ‘Kaömp ngës olëak weë,’ pël maan pit kat wiipën ma? Won pan. ");
INSERT INTO wer_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Peene wë omën öng öpna pöp pim karuröaring akun wali naön ëëpnaat. Pi peene wëën ënëmak omën naröak pi wak kama ulmëën akun pötakökëër pim karurö yaköm ëën kaömp ngës olëak öpnaat.” Pöl pit ne kama neöpna pötakökëër nëm ruurö neen yaköm ëën kaömp ngës olëak öpnaat. ");
INSERT INTO wer_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesu pi watepang ngön pil mëak kaalak munt nent epël mëëa. “Omën namp pim ulpëën ngolöpöpökaan lup nent ilak ngaanëpök wiak korir namëëpan. Pël ëëpna pöt ulpëën ngolöpöp utpet wasën ngolöp pöp köpöpring ngöntre kar naën ëëpnaat. ");
INSERT INTO wer_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ën omën namp i kep pol koröpwerring ket ëa ngaan pötak wain i ngolöpët kolön yok pangk naëpan. Pël ëëpna pöt wain i pöt kep wetak pol koröp pöt sak il ngentiin iit orö sëpnaat. Pël ëën pol koröpwerta utpet ëëpnaat. ");
INSERT INTO wer_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Pötaanök wain i ngolöpët kep ngolöptak lë mëëpna pötak pangk ëëpnaat. ");
INSERT INTO wer_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Omën namp wain i ngaante yenaupök ngolöpta songönte köpël ëak nanën ëëpnaat. Pël ëëpnaatak ngaante ëwat wë pöt pëën kent ëak nëmpnaat.” Yesuu pël mëëa pöta songönte epët. Mosesë ngön kosang ngaanötre pimtë ngön ngolöpöt pangk irikor naëpan pötenök ya. ");
INSERT INTO wer_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Kë yesa akun ngëëngk nentak Yesure pim ruurö pit rais ya neweri lup sa. Pël ëak ruurö pit ulöp narö töak söngsöng ëak na. ");
INSERT INTO wer_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Pël yaëën Parisi naröak pitën epël mëëa. “Kë yesa akun ngëëngktak arim ya yamëngk pipotön pepanöm wia. Tol ëënak yeë?” ");
INSERT INTO wer_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Maan Yesuuk kangiir epël mëëa. “Ar Tewitre pim omnaröa këën wë ëa pöt sangk kelak kat nawiin yaaurö ma? ");
INSERT INTO wer_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Tewit pi Anutuu ngönën tup kaöeta kakaati së kaömp Anutuu ëöetak wieëa pöt kiri ar yaauröakëër nëmpnaan omën pasurö nëmpanëak nga yaaut wak pimënt nak pim omnarö karut mangkën na. Pöt ar sangk kelak kat nawiin yaaurö ma?” ");
INSERT INTO wer_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Pël mëak epël mëëa. “Omën Këëp ne kë yesa akun ngëëngk pöta pepap.” ");
INSERT INTO wer_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Kë yesa akun ngëëngk nentak Yesu pi kaalak ngönën tupta kakaati së omnaröen ngönën ök yamëem pörek omën namp pim mor yaapkëës kël waup wëën itena. ");
INSERT INTO wer_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Pël ëën ngön kosangötë ngarangköröere Parisi ngönën omnaröak Yesuuk akun ngëëngktak ompyaö wasën pöt ngön yaatak ulmëëpënëak ngai yeem wëa. ");
INSERT INTO wer_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pël ëën pimtok pitëm lupötë itenak omën mores kël wa pöpön epël mëëa. “Ni wal ëak wais omnaröa itëkëël tau.” Pël maan omën pöp wal ëak së pörek taua. ");
INSERT INTO wer_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Pël ëën Yesuuk epël mëëa. “Ne arën pëlpël niamaan. Tiar yok pangk kë yesa akun ngëëngktak omnarö ompyaö elmëëpen ma utpet elmëëpen? Yauman omnarö ompyaö mowasëpen ma mëmpen?” ");
INSERT INTO wer_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Pël mëak pitën nga it nalnal elmë pet irak omën pöpön epël mëëa. “Nim mores el më.” Maan omnamp pi pël ëën mores kosang sa. ");
INSERT INTO wer_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Pël ëën pit ya këlangön utpet ëën pitëmënt wa top ëak neneren epël mëëa. “Tiar Yesu epop tol elmëëpen?” pël mëëa. ");
INSERT INTO wer_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Akun pötak Yesu pi Anutuun ök mapënëak rosir naöökël sa. Pël ëak röök pötak ök maim wëën ëwa tëa. ");
INSERT INTO wer_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Pël ëën ëlpam walën pim ruuröen yas maan sëën pi pitëm naëaan omën 12 ëak il moulmëak pitëm yapinten pim ngönte yaaö omnarö pël mëëa. ");
INSERT INTO wer_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Nampë yapinte Saimon pöpön Yesuuk yapinte Pita pël mëëa. Ën namp Entru pöp Saimon pim nangap. Ën naröa yapinöt Semsre Son, Patolomiuure ");
INSERT INTO wer_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matiu, Tomasre Sems Alpiasë ruupre Saimon Selot pël yamëëa pöp, ");
INSERT INTO wer_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yutas Sems pim ruupre Yutas muntap Keriot kakaanëp, ënëmak Yesuun kup mowiipnaap. ");
INSERT INTO wer_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesu pitring rosiraöökaan ëëtöök së oröak pim ruurö selap pan pitring tauaan omën selap Yutia yangerakaanre Yerusalem kakaanre i kaö ëöök Taiaare Saiton ka pöteparëaan narö pit pourö wa top ëa. ");
INSERT INTO wer_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Omën pörö pit Yesuuk ngönën ök maan kat wiire pitëm yaumanöt won wasö pël ëëpënëak sa. Pël ëën Yesuuk omën urmerarö pitëk wëauröeta ompyaö mowesa. ");
INSERT INTO wer_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Pël ëën omën pourö pit itaangkën weëre kosangö pim naëaan sëën ompyaö sëpën seëa pöt itenak pitta ompyaö sëpënëak kent ëën piik morring ngëën elmëëpënëak ök ëa. ");
INSERT INTO wer_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesu pi pim ruuröen iteneë epël mëëa. “Omnant wonörö ar Anutuuk wa ngaöök yanimë. Pötaanök ërëpërëp ëënëët. ");
INSERT INTO wer_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Omën peene këën ëeim wëaurö ar ënëmak kep ëënëët. Pötaan ërëpërëp ëënëët. “Omën peene ingre këlël aim wëaurö ar ënëmak söm anëët. Pötaan ërëpërëp ëënëët. ");
INSERT INTO wer_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Ënëmak omnarö pit arën Omën Këëp nemorö pël niak nga elniak kasëng nimampnaat. Pël ëak ngön utpet niak arim yapinöt utpet pan wesak niapnaat. Pël ëën ar pöten ërëpërëp ëënëët. ");
INSERT INTO wer_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ngaan pitëm ëarö tektek ngön yaauröen pil elmëaurö. Pötaanök pit ar pël yaalniin pöt, ‘Ënëmak kutömweriaan kangut kësang önaat,’ pël weseë ya kë sak ërëpërëpring tan urön. ");
INSERT INTO wer_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Ën monere urömaringörö ar omnant weimaurö, yakömpe. Ar kutömweri kaalak munt nant naöngan. ");
INSERT INTO wer_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Kaömp nak kepring wakaimaurö, yakömpe. Ar këën eim önëët. “Söm aim wakaimaurö, yakömpe. Ar ingre ya ilak aim önëët. ");
INSERT INTO wer_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Omën peene omnaröak arim yapinöt ping wesak yaaurö, yakömpe. Ngaan arim ëaröak tektek ngön kaarkaar yaauröen tapël elmëa.” ");
INSERT INTO wer_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Nem ngönte kat yawiaurö arën ök niamaan. Arimëën kööre tok yaalniaurö lup sant elmëën. Utpet yaalniaurö ompyaö elmëën. ");
INSERT INTO wer_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Omën ar utpet niwasëpënëak ngön yaaurö Anutuuk ompyaö mowasëpnaan kimang man. Ën arimëën ökre was yaalniauröaan Anutuun kimang man. ");
INSERT INTO wer_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Omën nampök kerëm nentak yanimöön pöt nenteta nimööpnaan mowasum. Ulpëën rangkëp yeön pöt iriipön nga elmëënganok. ");
INSERT INTO wer_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Namp niin omën nantön kimang niaan mamp. Nampök niikaan wa ëp ëën kaalak nimpënëak ke urak manganok. ");
INSERT INTO wer_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ar omnaröak omnant elniipënëak kent kön yawi pipël arökta pitëmëën elmëën. ");
INSERT INTO wer_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Arim kar lup sant yaalniaurö kangiir lup sant elmëënë pöt pangk naëpan. Omën saunaringörö pitta lup sant tapël elmë yaë. ");
INSERT INTO wer_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ën omën ompyaö yaalniaurö kangiir ompyaö elmëënë pöt pangk naëpan. Omën saunaringörö pitta ompyaö tapël elmë yaë. ");
INSERT INTO wer_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ën ar omnarö kangut nimpënaak pël wesak omnant mampunë pöt pangk naëpan. Omën saunaringörö pitta omnarö kangiir tapël mampënaak pël wesak omnant men yaë. ");
INSERT INTO wer_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ar pöt, arimëën kööre tok yaalniaurö lup sant elmëak ompyaö elmëën. Ar omnarö omën kangutëën kön wiak mengkanok. Pël ëënë pötak kangut kaö pan wak Anutu Ngaarëkëpë ru sënëët. Pöt pi omën pimëën yowe nemaan yaaöre utpet yaalmëa pöröaan kësangën yaaup. Ar Anutuu ru sënë pötaan pim ök tapël omnarö elmëën. ");
INSERT INTO wer_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Arim pepapök yaköm yaalni tapël arta yaköm elmëën.” ");
INSERT INTO wer_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Ar omnarö kom ëak ngön ë pet yairaupë yaë pöl ëënganok. Pël ëënë pöt Anutuuk ngön ë pet yairaupë yaë pöl naalniipan. Ar omnarö ngön ë pet yairaupë yaë pöl könöm mangkanok. Pël ëënë pöt Anutuuk ngön ë pet yairaupë yaë pöl könöm naningkën ëëpnaat. Ar omnaröa saunatë kangut kërë moolan. Pël ëënë pöt Anutuuk arimotë kangut kërë nuulapnaat. ");
INSERT INTO wer_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ar omnarö kësangën yaalmëën Anutuuk ar tapël elniipnaat. Pöt arim ëënë pöt il wesak kësang panë wesak wa top elniipnaat. Pöta ök omnaröen elmëënë pöt Anutuukta ar elniipnaat.” ");
INSERT INTO wer_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Pël mëak Yesu pi yal menak watepang ngön nent epël mëëa. “Omën it il tëa naar piarip yok pangk nampnamp mësak sëpën ma? Won, pël naëpan. Piarip pouwaar kanö wiaan saarëak së parë orööpnaat. ");
INSERT INTO wer_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Runga pep kaatak nampök pim pepap il newaspan. Pi omnant ëwat sa pet irak pim pepapë ök sëpnaat. ");
INSERT INTO wer_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ni tol ëënak nim karipë itöök ulöl kotten iteneëak nimtëöökë këra elten kön nawiin yaën? ");
INSERT INTO wer_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nimtëöök om wiaan ni tol ëak karipön epël maan pangk ëëpën? ‘Ngöntöp, ni kat newiin ne nim itöök ulöl wia pipët niömaan.’ Kaar omnamp, ni nimtë itöök këra elte wia pipët wakök nim karipë itöök ulöl wia pipët wëën pangk ëëpnaat.” ");
INSERT INTO wer_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Këra ompyaumentëk ulöp utpetarö nautpan. Ën këra utpetementëk ulöp ompyaurö nautpan. ");
INSERT INTO wer_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Këraamenti songönte ulöpöröak war yewas. Wëleri ëër nautpan. Ën rakësaöök kasu nautpan. ");
INSERT INTO wer_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Omën ompyaup pi pim lupmeri kön ompyaut wieëa. Pötaanök omnant ompyaö yaë. Ën omën utpetap pim lupmeri kön utpetat wieëa. Pötaanök pi utpetat yaë. Omën namp ke nentere nent pim lupmeri peö ëak wë pöt këmtak war yewas.” ");
INSERT INTO wer_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Oröp ëën, ‘Tenim Aköp,’ pël yeneemak nem ngönte kat nawiin ëeim? ");
INSERT INTO wer_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Omën nem naë wais ngönte kat wiak nem këm ngön ngar öpna pipopön omën eptak ök ëën ar ëwat sënëën. ");
INSERT INTO wer_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Omën pipop pi omën ka weit ök rëaupë ököp. Omën pöp pi pim kaat ök rëëpënëak wap waliit ilak pongön tëak wes mëën ngemaan yang menak taintaë wesa. Pël ëën kopi akunaöök i nga urak tööl noolaan ëa. Pöt omën pöp pi taintaë pan wesak ök rëa. Pötaanök kosang ëa. ");
INSERT INTO wer_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ën omën nem ngönte kat wiak ngar naön ëëpna pipopön omën kaat mangkimangki ök rëa pöpëël ök ëëmaan. Omën pöp pi ka wapöt taë newasën ëa. Pötaanök kopi akunaöök i nga urak tööl olaan yangerak ngentiak utpet pan ëa.” ");
INSERT INTO wer_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesu pi ngön pöt omnaröen ök më pet irak Kapaneam kak së oröa. ");
INSERT INTO wer_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Pörek Rom nga omnaröa wotöök nampë inëën namp yauman kaö pan yeem wel wiipënëak ëa. Wotöököp piin kent yaaup. ");
INSERT INTO wer_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Pël ëën wotöököp pi Yesu pim yaauten kat wiak Yuta kaö narö pi koirak waisën pim inëën ruup ompyaö mowasëpënëak wes momëa. ");
INSERT INTO wer_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Pël ëën pit Yesuu naë së oröak kosang wesak epël mëëa. “Omën pöp ompyaö yaaup. Pötaanök ni kaamök elmë. ");
INSERT INTO wer_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Pi tiar Yuta omnarö lup sant elniak tiarim ngönën tupët ök rëaup.” ");
INSERT INTO wer_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Pël maan Yesu pitring së kaata temanöm yesën nga wotöököp pim kar narö epël ök mapënëak wes mëën sa. “Aköp mosëp. Ne ompyaup talte ni nem kaatak waisum? ");
INSERT INTO wer_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ne nemtëën kön wiin pangk naën ëën nim ngësël waisumataan pomp yeë. Pötaanök ni om pirek wë këm pëëntak aan nem inëën ruup ompyaö sëp. ");
INSERT INTO wer_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ne omën isauröa ikanöök inëën yaaup. Ën nem iri nga omnarö wë. Pötaanök nook nampön, ‘Së,’ maan sëpnaat, nampön, ‘Wais,’ maan waisëpnaat, ën nampön, ‘Pël ë,’ maan pël ëëpnaat. Pötaanök nim naë weëre kosang wieëaup pöten ne kön wiin ni maan nem inëën ruup yok pangk ompyaö sëpnaat.” ");
INSERT INTO wer_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Pël maan Yesu pi kat wiak yaan sak kaip ti omën pim ënëm yesa pöröen epël mëëa. “Ne ök niamaan. Israel omnarö arim naë kön wi kosang yewesa epël nent nokoirën ë yeë.” ");
INSERT INTO wer_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Pël maan nga wotöököpë karurö pit kaalak kaatak së itaangkën inëën ruup ompyaö sak wëa. ");
INSERT INTO wer_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Wë akun nentak Yesu pi ka nenta yapinte Nain pörekë yesën pim ruuröaring omën kësang pan piiring sa. ");
INSERT INTO wer_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Pël ëën kak temanöm yesën öng kapir namp pim yokot kopëtap wëa pël ëeëaup wel wiin yang kel weerëpënëak omën pourö wak kakaan kan kourak koira. ");
INSERT INTO wer_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Pël ëak Yesu pi öng pöpön itenak yaköm ëën epël mëëa. “Ing angan.” ");
INSERT INTO wer_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Pël mëak naë së umkekët mor wëën wak sa pörö leng ëak tauaan epël mëëa. “Yokot epop, ni wal ëëmëak yeniak.” ");
INSERT INTO wer_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Pël ök maan welap wal ëak ngön ëa. Pël ëën Yesuuk pim ëlëpring öpënëak mëëa. ");
INSERT INTO wer_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Pël ëën omnarö pöten itenak kas ëën Anutuun yaya mëak epël mëëa. “Tektek ngön yaaö kaö namp peene tiarim tekrak yaarö.” Pël yemaan naröak epël mëëa. “Anutu pim omnarö kaamök elniipënëak yewais.” ");
INSERT INTO wer_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Pël ëën Yesu pim ëa pöta ngönte Yutia yang pour pangk ëën yang naë wieëa pötë sa. ");
INSERT INTO wer_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Sonë ruurö pit Sonön Yesuu ëa pöta ngönte ök mëëa. ");
INSERT INTO wer_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Pël maan Son pi ru naar ngön maan sëën Aköpön epël pëlpël mapënënëak wes mëa. “Waisëpënëak aan kor wakaimaup ni tapöp ma muntapön kor ön?” ");
INSERT INTO wer_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Pël mëak wes mëën omën pöaar Yesuu naë së oröak epël mëëa. “Son i yamëaup puuk niin epël pëël nianëak wes yanimë. ‘Waisëpënëak aan kor wakaimaup ni tapöp ma muntapön kor ön?’” ");
INSERT INTO wer_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Akun pötak Yesu pi omën yauman ke nentere nent yaaurö ompyaö mowasööre omën urmeraröaring wëaurö urmerarö waö ë momëëre omën it il tëaurö it nganga mowasö pël ëeim wëa. ");
INSERT INTO wer_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Pël ëën omën pöaar së ök maan Yesuuk kangiir epël mëëa. “Arip së Sonön omnant arpim itaampööre kat wi yeë epotön ök man. It ngaapörö it nganga së, ing il tëaurö ompyaö sak kan ë, kësë ëaurö ompyaö së, katun yaaurö kat nganga së, welarö wal ë ulmë, ngöntök yaaurö ngön ompyaut ök maan kat wi, pël yeë epotön ök man. ");
INSERT INTO wer_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Omën namp nemëën yak pim kön wi kosang yewesaut irikor naën yaë pipop ërëpërëp ëëpnaap.” ");
INSERT INTO wer_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Pël maan omën Sonë wes mëa pöaar yesën Yesuuk omnaröen Sonë songönte epël mëëa. “Ar ngaan yang omën wonrek kalaö naö kent möön sak waisak yaëën itaampunëak saurö ma? Won, Son pi pöta ök won. ");
INSERT INTO wer_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ma omën ulpëën ke nalëp mëaö nampön itaampunëak saurö ma? Won, omën ulpëën ke nalörö mëa pörö omnant kësangring omën omp aköröa ka ompyautë wë. Son pi ulpëën ke nalörö namëënëp. ");
INSERT INTO wer_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ma ar omën ke tolëëlëpön itaampunëak saurö? Ar tektek ngön yaaö nampön itaampunëak saurö ma? Ar yok pël ëan. Ne ök niamaan. Pi tektek ngön yaaö tapöpök pim ya yamëngka pötök tektek ngön yaaö muntaröa ya yamëngkaut il yemowas. ");
INSERT INTO wer_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Omën pöpëënök ngönëntak epël retëng ëa. ‘Kat wi. Ne omën nem ngönte waup wes mëën nimëën wet rapnaat. Puuk nim kanö ningësëpnaat.’ ");
INSERT INTO wer_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ne ök niamaan. Son puuk yangerakë omën pourö il yemowas. Pël ëaap omën Anutuuk wa ngaöök yamë pöröak pi il yemowas. Pitëm naëaan koturöakta pi il yemowas.” ");
INSERT INTO wer_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Omën yaapöröere takis yewaurö pit makre ku mëak epël mëëa. “Mak, Anutu pi ompyaö yaaup.” Pöt Sonök wet rëak pit i momëa. Pötaanök pël mëëa. ");
INSERT INTO wer_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ën Parisi ngönën omnaröere ngön kosangötë ngarangkörö pit Sonök i momëëpnaaten kaaö yeem Anutuu kan ompyaö pet yaalmë pö kasëng mena. ");
INSERT INTO wer_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Pit pël yaëën Yesuuk epël mëëa. “Ne ar akun eptak wëauröen oröp nentak ök elniim? Ar talöröa ökörö? ");
INSERT INTO wer_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ar rungaaröa ökörö. Rungaarö pit ka tomök ngasam yeem neneren epël yema. ‘Ten intö tang yamöön ar tan naurön yeë. Ten ingre tan yaan ar ingre ya ilak naën yeë.’ ");
INSERT INTO wer_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ar tapël yaaurö. Son i yamëaup pi wais wain i nanën wë akun nantë kaömp ngës olëak wëën ar piin, ‘Pi urmerapring wë,’ pël aiman. ");
INSERT INTO wer_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ën peene Omën Këëp ne wais iire kaömp yenën ar epël aim. ‘Iteneë. Omën epop wain iire kaömp kaö yenëp. Pi takis yewaöre saun omnaröa karip,’ pël aim. ");
INSERT INTO wer_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pël ëaap Anutu pim ëwat pöt arim naë wieëanëën ar tenip sant elnian tapön.” ");
INSERT INTO wer_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Parisi ngönën omën nampök Yesu piiring kaömp nëmpënëak yas maan pim kaata kakaati së kaömp yenem wëa. ");
INSERT INTO wer_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Pël ëën kak pörek öng utpet namp Yesu Parisi omnampë kaatak kaömp yenem wë pöt kat wiak i köp nga kamp nent kep ompyautaring wak sa. ");
INSERT INTO wer_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Pël ëak Yesuu kasngaël së pim ingrak taueë ing ëa. Pël ëën ing lelapöt pim ingesiarë ngentiin pim kepön ëptak kol mowesak ingesiar tot nak i köp nga kamp pöt lë momëa. ");
INSERT INTO wer_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Pël yaëën Parisi omën Yesuun yas mëëa pöp itenak kön epël wia. “Pi tektek ngön yaaö namp ëanëën öng epopë songönten ëwat ëan tapön. Öng epop saun öngöp.” ");
INSERT INTO wer_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Pël kön yawiin Yesu pim kön pöt itenak epël mëëa. “Saimon, ne ngön nent ök niamaan kat wi.” Maan Saimonök epël mëëa. “Rë yanuulaup, ök a.” ");
INSERT INTO wer_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Pël maan Yesuuk epël mëëa. “Omën naar piarpim sum kangit wiaapnaat. Namp 500 kina, namp 50 kina. ");
INSERT INTO wer_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Piarip sum pöt kangiir mampënaat pangk naën ëa. Pël ëen mon pepap piarpim kangiir mampëna pöt sëp mowesa. Ni kön wiin omën pöaarëkaan talëpök mon pepapön lup sant elmëëpën?” ");
INSERT INTO wer_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Pëël maan Saimonök epël mëëa. “Ne omën sum kangit selap sëp mowesa pöpön kön yawi.” Pël maan Yesuuk epël mëëa. “Ni pangk yaan.” ");
INSERT INTO wer_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Pël mëak kaip ti öngöpön itneë Saimonön epël mëëa. “Ni öng epopön itenaan ma? Ne nim kaatak waisën ni ingesiar iirömaan iit nenangkën. Pël ëën öng epop pim ing lelaptak nem ingesiar i neirak kepön ëptak kol yewas. ");
INSERT INTO wer_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ne waisën ni sant elnëak tot nenenën ëaup. Pël ëën öng epopök nem ingesiar tot yen. ");
INSERT INTO wer_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ni nem kepön ëptak iit wa nenemëën yaëën öng epopök ingesiarë i köp nga kampët wa yenemë. ");
INSERT INTO wer_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Pötaanök öng epopë lup sant kësang yaalnë pöta songönte ök niamaan. Pim utpetat kësang pan pötë kangut kërë moolëaut. Namp pi nook pim saun kotta kangit kërë moolema pöt pim lup santeta kot tapël elnëëpnaat.” ");
INSERT INTO wer_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Pël mëak Yesu pi öngöpön epël mëëa. “Nim saunatë kangut kërë niolëaut.” ");
INSERT INTO wer_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Pël yemaan omën piiring kaömp neim wëaurö pit kön epël wesa. “Saunatë kangut yakërë epop pi omën ke tolëëlëp?” ");
INSERT INTO wer_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Pël ëën Yesuuk öngöpön epël mëëa. “Nimtë neen kön wi kosang yewesautak utpetetakaan yaniö. Pötaanök ya kë sak së öm.” ");
INSERT INTO wer_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Akun kot nent won sëën rangkël Yesu pi ka kotre kaö poutë ngön ompyaut ök mëak Anutuuk wa ngaöök nimëëpna pöta ngönte ök maö yesën pim ru 12 pöröeta piiring sa. ");
INSERT INTO wer_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Pël yaëën öng narö Yesuu ngaanëër urmerarö pitëkaan waö ë mëëre yauman ompyaö mowasö ëa pörö pitta Yesuring sa. Namp Maria Matala kakaanëp urmerarö 7 ëak waö ë momëa pöp. ");
INSERT INTO wer_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Namp Soana ngarangk namp Susa Erotë kaatak wëaup pim öngöp. Ën namp Susana piporöere öng munt narö pit Yesuring yesem Yesure ruurö sumre omnant kaamök elmë sa. ");
INSERT INTO wer_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ka poutëaan omën selap pan së wa top ëën Yesuuk watepang ngön nent epël ök mëëa. ");
INSERT INTO wer_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Omën nampök pim yaak omnant öpöt olëa. Pël ëën nant kamtaöök ngentiin omnaröak kan së waisö yeem ing mësak pötöp rep olaan intöröak wa na. ");
INSERT INTO wer_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ën nant këlöökë ngaarëk ngentia. Pël ëaut oröak yang kolapët won ëën umön rëa. ");
INSERT INTO wer_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ën nant nönötë öngpök olëa. Pël ëën nönöt oröak ngep ëën sësë ëa. ");
INSERT INTO wer_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ën nantökëër yang kolaptak olëa. Pël ëën pötökëër aprak kë kësang pan, kengk nemorëët 100, nemorëët 100 pël uta.” Yesu pi pël mëak ngön ëak epël mëëa. “Katringëpök ngön epët kat wiip.” ");
INSERT INTO wer_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Pël maan ruuröak Yesu pim watepang ngön pöta songönten pëël mëëa. ");
INSERT INTO wer_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Pëël maan Yesuuk epël mëëa. “Anutu pimtok wa ngaöök nimëak wë ngön ëlëëp pöta songönte arënökëër pet yaalni. Ën omën muntarö pit pöta songönte kat wiipanëak watepang ngön ök yak. Pit Anutuu naë rë olaan pitëm saunatë kangut këre olapan itöök itaampënaatak këëten yok pangk itnaampan ma katëëpök kat wiipnaatak songönten këëkë kön nawiipan.” ");
INSERT INTO wer_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Watepang ngön niak pöta këët epët. Anutu pim ngöntak omnant öpöt yoolak pötë ök yaë. ");
INSERT INTO wer_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Omnant öpöt kamtaöök ngentia pötë ökörö, omën narö ngönën kat wiak Anutuun kön wi kosang wasën utpetetakaan moöpanëak Setenök pitëm lupötëaan wa yemoola. ");
INSERT INTO wer_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ën öpöt këlöökë rangk ngentia pötë ökörö, omën narö ngönte kat wiak ërëpsawi ëak öpnaat. Pitëm lupötë misën il natëën. Pötaanök akun kot nent kön wi kosang wesak wëën morököt oröön wil këlok ëëpnaat. ");
INSERT INTO wer_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ën öpöt nönötë öngpök ngentia pötë ökörö, omën narö ngönën kat wiipnaatak wë koröpöökë omnantön kön selap ëëre monere urömen kentre kaur ëëre omën munt nantön war ë pël yaëën pötök ngep elmëën ngönën këët mos ëëpnaat. ");
INSERT INTO wer_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ën öpöt yang kolaptak ngentia pötë ökörö pit ngönën kat wiak lupöt ompyaö wesak wak wëën pitëm wëwëatë kë ompyaut koirëpnaarö.” ");
INSERT INTO wer_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Omnarö esuwes mangiak kapita öngpök mëëre urta ikanöök wi pël naëngan. Ngaarëk wesirën ëwa ëaan omën kakaati waisëpnaarö ëwa pöön itaampnaat. ");
INSERT INTO wer_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Omën ëlëëp wia pipot wi naöpanëët. Pipot tekeri sëpnaat. Ën ngep ëën wia pipot wiakaim wi naöpanëët. Ënëmak wëlël ëën omnarö itaampnaat. ");
INSERT INTO wer_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ar nem ngönöt këëkë wesak kat wieë. Omën namp Anutuuk ngön ompyaö lup nant mangkën ompyaö wesak öpna pöp muntat kësang wesak mampnaat. Ën namp naön wë wak wë wes öpna pöt wa ëp ëëpnaat.” ");
INSERT INTO wer_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Akun nentak Yesuu ëlre nang pit Yesuun itaampënëak sa. Pël ëën omnarö kësang pan peö ëën pit om pëlëër wëa. ");
INSERT INTO wer_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Pël ëën omën nampök epël mëëa. “Nim ëlre nang niin itaampënëak wais tomök wë.” ");
INSERT INTO wer_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Maan kangiir epël mëëa. “Omën Anutuu ngönöt kat wiak ënëm yaë piporö nem ëlre nangarö pël yaë.” ");
INSERT INTO wer_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Kët nentak Yesure pim ruurö pit wang naöök ilëak pitën epël mëëa. “Tiar i kaö olëak ëngk komuntakël sëpa.” Pël mëak sa. ");
INSERT INTO wer_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Yesem Yesu pi itkaan ëën ka ura. Pël ëën kent nempel möön i kaö maat wangaöök ilaan utpet ëak i kaöök ilapënëak ëa. ");
INSERT INTO wer_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Pël ëën pit Yesuu naë së it moilak epël mëëa. “Rë yanuulaup, tiar kö sëpenëak yeë.” Pël maan pi wal ëak kentööre kaö maatön nga maan kentö leng ëën kaö maat wiap sa. ");
INSERT INTO wer_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Pël ëën pitën epël mëëa. “Ar oröpmorëën neen kön wi kosang nenewasën yeë?” Pël maan pit yaan sak kas ëak neneren epël mëëa. “Omën epop tal namp apen? Puuk kentre kaö ma pöteparën nga maan pim ngönte ngar yeöp.” ");
INSERT INTO wer_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","I kaö olëak së Kalili ëngk komuntakël Kekesa yangerak së oröa. ");
INSERT INTO wer_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Pël ëak pörek wangaö leng ë ulmëak wëën ka pöökaan omën namp pitëm naë sa. Omën pöp pim lupmeri urmerarö wëën akun wali yool wakaimaup. Akun wali urmer pörö omën pöpök taintaë wakaima. Pël ëaan omnaröak kët poutë ngarangk këëkë elmëeimeë wii weitring wii motëeima. Pël ëaap omën pöp pi wii pötta wil moolaima. Pël ëak urmer pöröak omnamp mësak omën wonrekë seima. Pi kakaati ka naurönöp, omën yangaöök pëën wëaup. ");
INSERT INTO wer_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Omën pöpök Yesuun itenak merëk mëak pim ingesiarë së ngentiak epël mëëa. “Yesu ni Anutu Ngaarëk panëëpë Ruup. Ni ne tol elnëëm? Ne këlangön nangkanëak kimang yeniak.” ");
INSERT INTO wer_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Pöt Yesuuk urmeraröen ngön ök maan orööpënëak yeem urmeraröak ngön pil mëëa. ");
INSERT INTO wer_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Pël ëën Yesuuk pim yapinten pëël maan epël mëëa. “Nem yapinte Selap.” Pöt urmer selap piik ilëak wakaima pötaanök. ");
INSERT INTO wer_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Pël ëën urmer pöröak Yesuun ngön ëak epël kimang mëëa. “Ni ten es parëaöökël waö ë nimëëngan.” ");
INSERT INTO wer_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Yang pörek tangitak pol narö kësang lupönöök wëa. Pël ëën urmerarö pit es pariaöökël sëpanëak kas ëën Yesuun ke urak epël kimang mëëa. “Ni ten om wes nimëën polöröa öngpök ilenaan sën.” Pël maan Yesuuk kuure mak mëëa. ");
INSERT INTO wer_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Pël ëën urmerarö pit omën pöpökaan oröak së polöröak ilëa. Pël ëën polörö pöömpö së parëaöök oröak së i kaöök ilëak i nak wel wia. ");
INSERT INTO wer_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Pël ëën pol ngarangkörö pit itenak kas së ngön pöt ök maan kaare yang pörekë omën wëaurö pangk ë pet ira. ");
INSERT INTO wer_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Pël ëën omnarö pit pöten itaampënëak Yesuu naë së itaangkën omën urmerarö piikaan oröak sa pöp könö koirak poë koröp urak Yesuu naë wel aisëaan pit itenak kas ëa. ");
INSERT INTO wer_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Pël ëën omën pöten itena pöröak Yesuu omën urmerarö lupmeri wakaimaup ompyaö mowesa pöta ngönte omnaröen ök mëëa. ");
INSERT INTO wer_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Pël ëën Kekesa yang pörekë omën pörö pim ëa pöten kas ëën Yesu pi pitëm yanger sëp wesak sëpënëak maan kaalak wangaöök ilëa. ");
INSERT INTO wer_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Pël yaëën omën urmerarö piikaan waö ë momëa pöpök Yesuring sëpënëak ke urak kimang mëëa. Pël ëën Yesuuk kaalak wes mëak epël mëëa. ");
INSERT INTO wer_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Nim kak së omnaröen Anutuu nim naë retëng kaö elniak sant yaniwas pipta ngönte ök mam.” Pël maan omën pöp pim kak së omën pörek wëauröen Yesuuk pim elmëa pöt pout ök maima. ");
INSERT INTO wer_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Omnarö pit Yesu kaalak sëpënëak yaëën kor wëën së oröön omën pourö wa top ëak ërëpsawi elmëa. ");
INSERT INTO wer_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Pël ëën ngönën tupta ngarangk namp Sairas pi Yesuu naë së pim ingrak tok oriak kosang wesak kimang epël mëëa. “Ni nem kaatak wais,” pël mëëa. ");
INSERT INTO wer_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Omën pöp pim koont kopëtap krismaki 12 ëak saup wëa pöp yauman kaö pan wel wiipënëak yeëa. Yesu piiring yesën öngre omp kësang pan pi il mowaria. ");
INSERT INTO wer_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Pël ëën pitëm tekrak öng namp öng yauman ëeim wëën krismaki 12 ëak saup wëa. Pël yaëën rotaaröakta kaamök elmëën pangk naën ëa. ");
INSERT INTO wer_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Öng pöp Yesuu kasngaë së pim mores ulpëënëpök mësël elmëën tapëtakëër won sa. ");
INSERT INTO wer_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Pël yaëën Yesu kat men ëak pëël mëëa. “Talëpök mësël yaalnë?” Pël maan pit wonwon yemaan Pitaak epël mëëa. “Kaöap, omnarö tetang menak wëep naröak mësël yaalniip oröpmorëën yaan?” ");
INSERT INTO wer_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Maan Yesuuk epël mëëa. “Won, omën nampök mësël elnëën nem weëre kosang nant piik yesën kat men yeë.” ");
INSERT INTO wer_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Pël maan öngpöp pi itaangkën pim songönte tekeri yewasën reireë urak Yesuu naë së pim ingrak tok oriak omnaröa itöök pim yaumanta songöntere mësël ëlmëak teëntom ompyaö sa pöta ngönte war wesak ök mëëa. ");
INSERT INTO wer_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Pël ëën Yesuuk epël mëëa. “Koontup aë, nimtë kön wi kosang yewesautak ompyaö yesën. Pötaanök ya kë sak öm.” ");
INSERT INTO wer_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Pi pël yamëem taprek om wëën omën namp ngarangkëpë kaatakaan së ngarangkëpön epël mëëa. “Nim koontup wel wiaarek këpök rë yanuulaup koirak waisngan.” ");
INSERT INTO wer_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Pël maan Yesu pi ngön pöt kat wiak kangiir ngarangkëpön epël mëëa. “Ni kon selap ëënganëp om kön wi kosang newas. Pël ëën nim koontup ompyaö sëpnaan.” ");
INSERT INTO wer_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Pël mëak kaatak së oröak omën muntaröen kakaati sëpanëak nga mëak Pitaare Sonre Semsre koontupë ëlre pepaar pitëmënt piiring koontupë wieëaurekë sa. ");
INSERT INTO wer_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Pël ëak öngre ompörö koontupëën ingre ya ilak kësang yaan Yesuuk epël mëëa. “Ar ing angan. Koontup pi wel nawiin om ka ura.” ");
INSERT INTO wer_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Pël maan pit wel yaap wiaup pël kön wiak söm ëa. ");
INSERT INTO wer_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Pël yaëën Yesu pi koontupë moresi wak epël mëëa. “Koontup aë, ni wal ë.” ");
INSERT INTO wer_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Maan pim könöp kaalak së ilaan tapëtakëër teëntom wal ëa. Pël ëën kaömp mampënëak ök mëëa. ");
INSERT INTO wer_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Pël ëën ëlre pepaar pöten itenak yaan panë sa. Pël yaëën Yesuuk omën oröa pöta ngönte omnaröen mepanëak nga mëëa. ");
INSERT INTO wer_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesu pim ru 12 pöröen yas maan sëën urmerarö waö ë momëëre yauman yaaurö ompyaö mowasö pël ëëpënëak weëre kosang mena. ");
INSERT INTO wer_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Pël ëak Anutuuk wa ngaöök nimëak wë pël maöre yaumanörö ompyaö mowasö pël ëëpënëak pit wes momëa. ");
INSERT INTO wer_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Wes momëëpënëak yeem epël ngan rë mena. “Ar kan kourakë omnant wak sënganok. Sungkörere kërre kaömpre monere pötring ulpëën naar wak sënganok. ");
INSERT INTO wer_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Kak nerek së oröak ka ilanë piptak pëën wë olëak sën. ");
INSERT INTO wer_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Nerek së oröön pit ka naningkën ëën pöt ing porpor elmëak arim ingötëaan yangre ulölöt kërë ka pöök moolan.” ");
INSERT INTO wer_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Pël maan sa. Pël ëak ka poutë yesem ngönën ök maö yauman omnarö ompyaö mowasö pël ë sa. ");
INSERT INTO wer_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Omën omp ak Erot pi Yesuu omnant yaaö pötön kat wiak ëngk ma e wesa. Pöt omën naröak Yesuun Sonök weletakaan wal ëak wë yaë pël mëëa pötaanök. ");
INSERT INTO wer_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ën naröak tapël, “Eliaak oröak yaë koröp,” yemaan naröak, “Tektek ngön yaaö ngaan wakaimauröakaan nampök wal ëak yaë koröp,” pël mëëa. ");
INSERT INTO wer_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Pël yemaan Erot pi epël mëëa. “Son pöp nook maan ngernger ilauppe. Talëpök yaauten ne kat yawi?” Pël mëak Yesuun itaampënëak kent elmëa. ");
INSERT INTO wer_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Yesuu ngön yaaö pim wes mëa pörö pit ya nga im olëak kaalak sa. Pël ëak pitëm ya mëmpööre omnant ë ima pötön ök mëëa. Pël ëën pit koirak kak pörek sëp wesak ka nenta yapinte Pesaita pörek së pitëmënt öpënëak sa. ");
INSERT INTO wer_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Pël ëën omnarö pöten kat wiak kaalak pim ënëm së oröön Yesu pitën itenak ngöntre kar elmëak Anutuuk wa ngaöök nimëak wë pöta ngönte ök mëak yaumanringörö ompyaö mowesa. ");
INSERT INTO wer_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Pël ëeim wëën wiap kanök këtëp yeilaan ru 12 pörö pim naë së epël mëëa. “Tiar omën wonrek wë. Pötaanök ni omnaröen maan repak yang eprek ka wieëautë së kaare kaömp koirëp.” ");
INSERT INTO wer_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Pël maan Yesuuk epël mëëa. “Arök kaömp meneë.” Maan pit epël mëëa. “Tenim naë kaömp selap won, kaömp mor nas ën i kaö imën kopët naar pël ëak wia. Ma ten kak së omën selap eporöa kaömp nant sum ëënëak yaan ma?” ");
INSERT INTO wer_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ompörö selap pan 5000. Pötaanök pël mëëa. Pël maan Yesuuk pitën epël ök mëëa. “Ar omnaröen ök maan pit kom ëak rongan 50 50 pël wel aisap.” ");
INSERT INTO wer_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Pël maan ruurö pit pël elmëën omën pourö wel aisëa. ");
INSERT INTO wer_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Pël ëën Yesu pi kaömp mor nas pötring i kaö imënaar wak kutömweriil iteneë Anutuun yowe mëak pelak omnarö kom ë mampënëak ruurö mena. ");
INSERT INTO wer_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Pël ëën omën pourö nak kep ëak kaut olaan ruurö wak kër 12 pötë waulön peö ëa. ");
INSERT INTO wer_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Akun nentak Yesu pi pimtë ruuröaring pëën wë kimang ya mëna. Pël ëak pitën epël mëak pëël mëëa. “Omnarö neen talëp aim?” ");
INSERT INTO wer_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Pël maan pit kangiir epël mëëa. “Naröak niin, ‘Son i yamëaup,’ pël aim. Ën naröak pöt, ‘Elia,’ pël yaan naröak, ‘Tektek ngön yaaö ngaan wakaimauröakaan nampök wal ëa,’ pël aim.” ");
INSERT INTO wer_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Maan Yesuuk epël mëëa. “Ën arimtok pöt talëp aim?” Pël maan Pitaak kangiir epël mëëa. “Ni Kristo, Anutuuk Yaö Niiaup.” ");
INSERT INTO wer_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pël maan Yesuuk pitën Pitaë ngön mëëa pöt omnaröen ök mepanëak nga mëëa. ");
INSERT INTO wer_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Pël mëak yal menak epël mëëa. “Omën Këëp ne wë ënëmak këëmre këlangön kësang kat wiire ngarangkre kiri ar yaaö kaöaröere ngön kosangötë ngarangkörö pit kasëng nemenak nemëngkën wel wiak akun nentepar nent kaalak wal ëëmaap.” ");
INSERT INTO wer_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Pël mëak omën pouröen nent epël mëëa. “Namp pi nem ënëm elnëëpënëak pöt pimtë könöökë kentöt këëpöt weseë, ‘Ne Yesu pimëën wel wiima pöt pangk ëëmaap,’ pël wesak pim këra yetapër kët poutë waalak nem ënëm ëëp. ");
INSERT INTO wer_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Namp pim wëwëet keimön ëak öpna pöt pim wëwëet kö sëpnaat. Ën namp nemëën yak wëwëet këëpöt wasëpna pöt pim wëwëet ompyaö orö morëëpnaat. ");
INSERT INTO wer_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ën namp yangerakë omnant pout kent ëak weim wëën pötök pim wëwë ompyaut utpet mowasën won sëën omën pötök tolëël kaamök elmëëpën? Pël naëpan. ");
INSERT INTO wer_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Namp pi nemëntre nem ngönëntaan omnaröa ëöetak ëö ëëpna pöp ënëmak Omën Këëp ne nem Pepapre ngëëngk enselöröaring pitëm ëwaat nem rangk elaan nem kutöm ëwaöring oröak piin kaaö elmëëmaap. ");
INSERT INTO wer_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ne yaap niamaan. E taua eporö arëkaan narö wel nawiin om wëën Anutuu wa ngaöök nimëëpna pöt yaaröön itaampun sa.” ");
INSERT INTO wer_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesu pi ngön pöt mëak wë kët 8 ëak won sëën Pitaare Sonre Semsre pël ëak pit koirak Anutuun ök mapënëak rosir naöökë sa. ");
INSERT INTO wer_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Pël ëak ök yemaan ë kosaö maim koröp oröön ulpëënëpta kölam panë tëën ëwa elmëa. ");
INSERT INTO wer_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Pël ëën omën naar oröak piiring ngönngön ëa yapintepar Mosesre Elia. ");
INSERT INTO wer_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Piarip kutöm ëwaöring oröak wë Yesu pi Anutuu yaö mëëa pöl Yerusalem kak së wel wiipna pöta ngönte piiring aim ");
INSERT INTO wer_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","wëën Pitaare karaar pit kakom pan yaëënak ke urak it nganga sak itaangkën Yesuu ëwaö wiaan omën pöaar piiring tauaan itena. ");
INSERT INTO wer_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Pël ëën piarip Yesu wil moulmëak sëpënëak yaëën Pita pi köpël yak Yesuun köntak epël mëëa. “Kaöap, ten eprek wëën ompyaö yaë. Pötaanök ten ka kot nentepar nent ëak ök renaan, nent nimëën, nent Mosesëën, nent Eliaëën ëak.” ");
INSERT INTO wer_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pël yemaan tapët pöt uröam nempel iri kaka elmëën pit kas ëa. ");
INSERT INTO wer_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Pël ëën uröam pömpelë öngpökaan ngön epël oröa. “Epop nem Ruup, piin yaö mëëaup. Pötaanök ar pim ngönte kat wiin.” ");
INSERT INTO wer_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Pël ëën pit ngön pöt kat wieë itaangkën Yesu pimënt tauaan itena. Pël ëak pit omnant pitëm itaampööre kat wi ëa pöt tapëtakëër omnaröen ök nemaan om yak wesak wakaima. ");
INSERT INTO wer_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ëlpam walën rosiraöökaan ngemaan omën kësang pan Yesu kan kourak koira. ");
INSERT INTO wer_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Pël ëak omën pöröa tekrakaan nampök epël mëëa. “Rë yanuulaup, ni nem yokotupön iteempëëk yak kosang wesak kimang yeniak. Pi kopëtapök yaë pötaanök. ");
INSERT INTO wer_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Urmerapök pi taintaë wak wëën këlël aim wë. Pël ëak pöpök pi kutpat ë moolaan ngentiak ing elre mor el ëak wieë kepeep yangësem wiaakë yaë. Pël ëën këlangön panë yemengkem wil nemoulmëën yaëën ");
INSERT INTO wer_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","nim ruuröak waö ë momëëpënëak kosang wesak kimang maan pitök waö ëën pangk naën ëaut.” ");
INSERT INTO wer_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Pël maan Yesuuk epël mëëa. “O kön wi kosang yewesaut wonörö, aë. Ar lup kosarö. Ar neen kön wi kosang nenewasën yeem kön wiin akun tolëël arring wë arim könömöt weim öm? Nim yokotup nem naë wak wais.” ");
INSERT INTO wer_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Maan yokotup wak yesën urmer pöpök kutpat ë moolaan ngentiak ing elre mor el ëak wiaan Yesuuk urmerapön ngön kosang mëak yokotup ompyaö mowesak pim pepap kaalak mena. ");
INSERT INTO wer_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Pël ëën omnarö Anutuu weëre kosang pöten itenak yaan sa. Pit Yesuu ëa pöten om kön wieim wëën Yesuuk pim ruuröen yas mëak epël mëëa. ");
INSERT INTO wer_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ar ngön epël këëkë kat wieë. Omnaröak Omën Këëp ne ngaaröa moresi neulëëpna akunet temanöm yes.” ");
INSERT INTO wer_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Yesuuk pit ngön pöta songönten kön wiipanëak ëlëëp mowesa. Pël ëën pit ngön pöt kat wiak ëngk ma e ëën pëël mapënëak ëak kas ëën sëp wesa. ");
INSERT INTO wer_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ruurö pit, “Tiarim naëaan talëpök kaö sak wë,” pël mëak pitëmënt ngön nga ela. ");
INSERT INTO wer_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Pël yaëën Yesu pi pitëm kön pöten itenak runga kot namp wak pim naë tau ulmëak ");
INSERT INTO wer_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","pitën epël mëëa. “Omën namp nemëën yak runga kot ke epëlëp ompyaö elmëëpna pipop ne elnëëpnaat. Ne elnëëpna pipop nem wes nemëaup elmëëpnaat. Arim tekrakaan namp, ‘Ne irëak wë,’ pël apna pipop pi isak öpnaap.” ");
INSERT INTO wer_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Pël maan Sonök epël mëëa. “Kaöap, ten itaangkën omën namp nim yapintak urmerarö waö ë yamëën itenaut. Pël ëaupök omën pöp tiarim ënëm naën yaë. Pël ëën tenök pël ëëpanëak kan mowariaut.” ");
INSERT INTO wer_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Pël maan Yesuuk piin epël mëëa. “Ar kan mowariingan. Omën namp arim yaat komun naurön ëëpna pipop arim karip.” ");
INSERT INTO wer_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yesu pi Anutuuk pi koirak kutömweri sëpna pöt temanöm yesën kosang weseëak Yerusalem kakë sëpënëak mëëa. ");
INSERT INTO wer_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Pël ëak omën narö wes mëën wet rëak së Sameria yangerak ka naöök së oröak Yesuun kaare omnant kopëta wasëpënëak mëëa. ");
INSERT INTO wer_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pël maan omën pörö pit Yesu Yerusalem kakë sëpnaat ëwat wë yak pi sant nemowasën ëa. ");
INSERT INTO wer_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Pël ëën Yesuu ruaar Sonre Sems piarip pöten itenak epël mëëa. “Aköp, tenip maan kutömweriaan esuwes irë pit kotöpën ma?” ");
INSERT INTO wer_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Maan kaip ti nga mëëa. ");
INSERT INTO wer_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Pël ëak pit kak nerekë sa. ");
INSERT INTO wer_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Yesën kan kourak omën nampök epël mëëa. “Nim yasumëëtë ne ënëm elniimaap.” ");
INSERT INTO wer_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Maan Yesuuk epël mëëa. “Kent tokörö pit pitëm ka yauraut wia. Ën intörö pitta pitëm ka ëpöt wia. Pël ëaap Omën Këëp nem ka uröma kaat won.” ");
INSERT INTO wer_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Pël mëak Yesuuk omën nampön epël mëëa. “Ni nem ënëm ë.” Pël maan kangiir epël mëëa. “Aköp, ni yok pangk kat newiin wet rëak së nem pepap yang kel weerum.” ");
INSERT INTO wer_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Maan Yesuuk epël mëëa. “Sëp was. Omën nem ngönte ngaarëk naön yaaö pöröak yok pangk wel pitëm karurö yang kel weerëpnaat. Ën ni pöt së Anutuuk wa ngaöök nimëak wë pöta ngönte ök ma.” ");
INSERT INTO wer_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Pël maan omën munt nampök epël mëëa. “Aköp, ne nim ënëm elniimaaten kent yaë. Pël ëaap ni kat wiin wet rëak kak së nem karurö mor menak waisum.” ");
INSERT INTO wer_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Maan Yesuuk epël mëëa. “Omën namp pi Anutuu yaatak wë wëwë ngaanten yaköm ëëpna pöpök Anutu pim wa ngaöök mëak wëaö pöta yaat yok pangk namëmpan.” ");
INSERT INTO wer_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ënëmak Aköp pi omën munt 70 ëak kom ë ulmëak pim ënëm sëpnaal ka kotre kaö poutë naar kak nerekëën naar kak nerekëën pëlpël ëak wet rëak wes mëën sa. ");
INSERT INTO wer_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Wes mëëpënëak yeem epël mëëa. “Ya lupöök kaömp kë kësang pan köp sak wë. Pël ëaap ya omnaar kopët. Pötaanök ar yesem pöt ya Pepapön kimang man. Pël ëën puuk ya omën munt narö koirak wes mëën këët wa rongan ëëpnaan. ");
INSERT INTO wer_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Seë. Yesem epël kön wieë. Pol sëpsëp ruurö kent toköröa öngpök wë pöl nook ar omnaröa öngpök wes nimëën së önëën yeë. ");
INSERT INTO wer_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Pötaanök monere kërre ing körre pöt wak sënganok. It wompwomp ëënganëën kan kourak yesem omnarö koirak ngönaak manganok. ");
INSERT INTO wer_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ar ka nentak së ilanë piptak wet rëak epël man. ‘Anutuuk öngre omp ka eptakörö mayaap elniip.’ ");
INSERT INTO wer_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Pël ëën ka pötak omën mayaap namp wëa pöt arim mayaap ök mëëa pöt pim naë orööpnaat. Won ëën pöt arim mayaap pöt arimtë ngësël kaip tiak waisëpnaat. ");
INSERT INTO wer_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ya omnarö pit pitëm ya yamëngkauta kangiir omnant yok pangk yeö. Pötaanök ar ya omnarö arim ka önë pötak pëën wëën kaömpre iire pöt pit ningkën pöt yok pangk nën. Pël ëak ar ka paspas ëënganok. ");
INSERT INTO wer_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Kak nerek së oröön sant niwesak kaömp ningkën pöt nën. ");
INSERT INTO wer_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Pël ëak kak pörekë yauman omnarö ompyaö mowesak, ‘Anutuuk wa ngaöök nimëëpënëak yaë,’ pël man. ");
INSERT INTO wer_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ën ar kak nerek së oröön pit sant naalniin ëën pöt ar ka tomök së taueë epël man. ");
INSERT INTO wer_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Ar kön wiak “Ten utpet yeë,” pël wasënëëk yak arim ka epöökaan yangre ulöl tenim ingötë el menaut kaalak kërë arimtëën yanuulak. Pötaanök ar këëkë kön wieë. Anutuuk wa ngaöök nimëëpnaaten kaaö yeë.’ ");
INSERT INTO wer_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ne niamaan kat wieë. Ngaanëër Sotom kakörö pit utpet ëeima. Pötaan akun kaöaöök Anutuuk Sotom kakaanörö pitëm utpetatë kangut mampnaat. Ën ka ke pilötë pörö utpet pan ëën Sotom omnaröa kangut kaö wesak mampnaat.” ");
INSERT INTO wer_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Yakömpe, Korasin omnaröen. Yakömpe, Pesaita omnaröen. Nem retëng weëre kosangöt arim naë elnia pöl Taiaare Saiton omnaröen elmëanëën pit ngaanëër pitëm lupöt kaip tiak ulpëënre poë koröp sinöt ëak ka kosöt kolak pitëm koröpöök wa mëan tapön. ");
INSERT INTO wer_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Pötaanök wë ënëmak akun kaöaöök Anutuuk Taiaare Saiton omnarö pitëm utpetatë kangut mampnaat. Ën ar pöt utpet pan ëën pitëm kangut kaö wesak nimpnaat. ");
INSERT INTO wer_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ën Kapaneam omnarö, ar kutömweriil isën ma? Won, ar es parëaöök ngemanëët.” ");
INSERT INTO wer_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Pël mëak Yesuuk pim ruuröen epël mëëa. “Arim ngönöt kat wiipna piporö nem ngönte kat wiipnaat. Ar kasëng nimampna piporö ne kasëng nemampnaat. Ne kasëng nemampna piporö wes nemëaupta kasëng mampnaat.” ");
INSERT INTO wer_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Omën 70 pörö ya nga im olëak kaalak ërëpsawiaring së oröak Yesuun epël mëëa. “Aköp, ten nim yapintak urmerarö waö elmëën tenim ngönöt kat yawi.” ");
INSERT INTO wer_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Maan epël mëëa. “Ne itaangkën Seten pim weëre kosang won sëën pi kent tangaarötë yaë pöl kutömweriaan wais yengenti. Pötaanök ar peene urmerarö waö yaalmë. ");
INSERT INTO wer_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Kat wieë. Ne yok weëre kosang ninaut. Pötaanök ar kamalre körngap pörö ing mësaan kööre toköp Seten pim weëre kosang pötak ar il naniwaspan ma këëre nga nentak utpet naniwaspan. ");
INSERT INTO wer_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ar pöt, urmerarö arim ngönöt kat wia pötaan ërëpsawi ëëngan. Won, ar Anutuuk arim yapinöt kutömweri wa yawi pötaanökëër ërëpsawi ëeë.” ");
INSERT INTO wer_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Akun pötak Ngëëngk Pulöök Yesu kaamök elmëën ërëpërëp kësang ëak Pepapön epël mëëa. “O Pep, ni kutömre yang poutë Pepap. Niin yowe yeniak. Ni omën ëwatöröaan nim ngönënte ëlëëp yaalmëaup. Ën kön nawiin yaauröaan pet yaalmëaup. Mak, Pep nim kentöök pël yaaup.” ");
INSERT INTO wer_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Pël mëak omën pouröen epël mëëa. “Pepak omnant pout ne nenaut. Pötaanök omnarö ne Anutuu Ruupë songönten köpël wë, Pepakëër ëwat wë. Ën Pepenta tapël wia. Omnarö piin köpël wë, Ruupökëër ëwat wë. Pötaanök Ruupök omën nampön Pepapë songönten ök maan yok pangk ëwat sëpnaat.” ");
INSERT INTO wer_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Pël mëak Yesu pi kaip tiak ruurö pitëmtën epël mëëa. “Omën it ngolöpöt arim ityaangk epötön ërëpërëp ëënëët. ");
INSERT INTO wer_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ne ök niamaan. Ngaan tektek ngön yaaöre yang omp akörö kësang pit omën epotön itaampënëak ëak itnaangkën ëautak ar peene ityaangk. Kat wiipënëak ëak kat nawiin ëautak peene kat yawi.” ");
INSERT INTO wer_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Omën ngön kosangöt ëwat nampök Yesuun morök elmëëpënëak epël mëëa. “Rë yanuulaup, ne tol ëak wëwë kosangta yaö sum?” ");
INSERT INTO wer_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Maan Yesuuk kangiir epël mëëa. “Ngön kosangöt pepeweri tolëël wiaan sangk kel yaaup?” ");
INSERT INTO wer_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Pël maan omën pöpök epël mëëa. “Anutu pi nim Aköp. Ni piin lup sant elmëak nim lupmerre könre weëre kosangre kön yawiaare pipot pout pimëën pëël elmëak nimtëën lup sant yaën tapël nim karipön elmëëm pël wiaap.” ");
INSERT INTO wer_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Maan Yesuuk epël ök mëëa. “Yok pangk yaan. Pël ëëmë pötak wëwë kosangta yaö sumëët.” ");
INSERT INTO wer_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Pël maan omën pöp pi pimtën wak isëpënëak Yesuun epël mëëa. “Ën nem karip talëp?” ");
INSERT INTO wer_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Maan Yesuuk watepang ngön nent epël ök mëëa. “Yuta omën namp Yerusalem kakaan Yeriko kakë sëpënëak yesën këkain yaaö naröak kamtaöök koirak mën olëak pim ulpëënre omnant wak sëën wel wiipënak eim wieëa. ");
INSERT INTO wer_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Pël ëën kët pötak kiri ar yaaö namp kan tapöök së itaangkën wiaan keker elmëak sa. ");
INSERT INTO wer_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Pël ëën Liwai ngönën omën kiri ar yaaö kaata inëën namp kan tapöök së oröak itenak keker elmëak sa. ");
INSERT INTO wer_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Pël ëën Sameria omën namp Yuta omnaröa kööre toköröa naëaanëp pi kan tapöök së oröak omën pöpön itenak yaköm pan ëa. ");
INSERT INTO wer_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Pël ëën naë së mën ilautë kolapötre wain iit wa momëa. Pël ëak kör mokoëak wa pim pol tongkiipë rangk ulmëak mësak së su ka nentak moulmëak ngarangk yeem ka ura. ");
INSERT INTO wer_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Pël ëak wangam kanök sëpënëak sum 2 kina pöt su ka pöta pepap menak epël mëëa. ‘Ni omën epop ompyaö wesak ngarangk ëëm. Nim sum nant pimëën won wesan ëën pöt nem kaalak waisumaatak kangit nimpaat.’” ");
INSERT INTO wer_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yesuuk watepang ngön pöt më pet irak ngön kosangöt ëwat pöpön epël mëëa. “Omën naar namp pöröakaan talëpökëër omën këkainöröak mëna pöpë karip yaë?” ");
INSERT INTO wer_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Pël maan omën pöpök mëëa. “Mënaup sant mowesa pöp.” Maan Yesuuk kangiir epël mëëa. Niinta së tapël ëëm.” ");
INSERT INTO wer_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesure pim ruurö pit së kak nerek oröön öng nampë yapinte Mata puuk Yesu pim kaatak koirak së ulmëak sant mowesa. ");
INSERT INTO wer_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Pël ëën Mataë nang namp wëa yapinte Maria pöpök Yesuu naë së pim ingrak wel aisëak wë ngönën yaan kat wia. ");
INSERT INTO wer_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Pël ëën Mata pimënt kaömp kësang ar yeem pangk naën ëën kön selap ëak Yesuu naë së epël mëëa. “Aköp, nem nangap pi ne wil neulëak sëën nemënt kaömp ar yeë. Pöten ni kön wiin yok pangk yaë ma? Ni maan ne kaamök elnëëp.” ");
INSERT INTO wer_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Pël maan Yesuuk piin epël mëëa. “Mata, Mata, ni kaömp kësang ar ëëmëëtaan kön selap ëak ya ngës yaën. ");
INSERT INTO wer_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Pël ëaap ar omën kopët nent ëënë pöt pangk. Maria pi omën kopët ompyaö tapët yaë. Pötaanök sëp waspanok mangan.” ");
INSERT INTO wer_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Akun nentak Yesu pi nal së Anutuun ök maima. Pël ëak pet irën ruuröakaan nampök epël mëëa. “Aköp, Son pi pim ruuröen Anutuun ök mapënëak rë mouleima pöl nuuk ten nent rë nuul.” ");
INSERT INTO wer_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Maan Yesuuk epël ök mëëa. “Ar Anutuun ök manëak pöt epël man: ‘Pep, nim yapinte ngëëngk wiaap. Ni wais wa ngaöök nimë. ");
INSERT INTO wer_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Kët poutë tenim kaömpöt nimp. ");
INSERT INTO wer_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Tenim saunatë kangut kërë nuula. Tenök omnaröa saun tenimëën yaalni pötë kangut tapël kërë yemoolak pötaanök. Moröktak nuulëënganok,’” ");
INSERT INTO wer_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Pël mëak Yesuuk kaalak yal menak pim ruuröen epël mëëa. “Arim naëaan nampök röök ulöpöök së pim karip ka uraan it moilak epël mapnaat. ‘Ngöntöp, ni kaömp nemesiar nemes ëak nan. ");
INSERT INTO wer_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Nem kar namp kan im wais nem naë oröön kaömp mempaat won.’ ");
INSERT INTO wer_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Pël maan ka pepap pi wal ëak epël mapnaat. ‘Ni tol ëën ka uraan it yeneilën? Kaat kan wariaan rungaaröeta ka uraap. Yok pangk kaömp naningkan sa.’” ");
INSERT INTO wer_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Pël mëak Yesuuk yal menak epël mëëa. “Ka pepap tol ëëpën? Ne niamaan kat wieë. Pi ‘Nem ngöntöpök ya,’ pël wesak nemampan. Om pim ke urak mapna pötaan omnant pim mapna pöt mampnaat. ");
INSERT INTO wer_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Pöta nokoliit niamaan. Kimang maim olëak omën këët önëët. Ngaöl ëeim së këët koirënëët. Kanwer körangkörang maimën të niwiipnaat. ");
INSERT INTO wer_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Anutuun kimang yamëëauröak omnant yeö. Ngaöl yaaurö Anutuu naëaan këët yokoir. Kanweri körangkörang yamëëauröaan Anutuuk të yemowi. ");
INSERT INTO wer_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Arim naëaan namp pim ruupök animauten maan kamal utpet namp wa mampën ma? ");
INSERT INTO wer_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ma kokor ngeepön maan körngap namp wa mampën ma? Won. ");
INSERT INTO wer_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ar omën utpetaröak arim rungaarö omën ompyaut men yeë pöl arim Pep kutömweri wëaup puuk il niwesak Ngëëngk Pulöön piin kimang maan nimpnaat.” ");
INSERT INTO wer_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yesuuk omën urmerapök elmëën ngön naën wëaö namp waö ë momëën oröak sëën ngön yaap yaan omnarö itenak yaan sa. ");
INSERT INTO wer_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pël yaëën naröak epël mëëa. “Pi urmeraröa kaöap Pielsepul puuk kaamök elmëën urmerarö waö ë yemomë,” pël mëëa. ");
INSERT INTO wer_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Pël yaëën naröak Anutu piiring wë ma won pöten itaampënëak kutöm retëng nent ëëpën mëak morök elmëa. ");
INSERT INTO wer_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pël yaëën pi pitëm lupötë itenak mëëa. “Yang nerakë omnarö pitëm naë nga oröön nga elak kom ëak wëën weëre kosangring naön ëëpnaat. Ën ka naöök wëaurö pit tapël kom elmëën repak sëën ka kosaö wiaapnaat. ");
INSERT INTO wer_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Pöta ök Setenë omnarö pit kom ëak pitëmënt nga elëpna pöt tol ëak pim yaat kosang sëpën? Ar neen, ‘Pielsepulök kaamök elmëën urmerarö waö ë yamë,’ pël yak. Arim ngön pöt yaap ëanëën nemorö waö ë mëan tapön. ");
INSERT INTO wer_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","‘Pielsepul puuk kaamök elmëën urmerarö waö ë yamë,’ pël aim. Pötaanök arim ngön pipët yaap yeëanëën arim ruurö pitta Pielsepul kaamök elmëën urmerarö waö ë mëan tapön. Pötaanök arim ruurö pitëmtok arim ngön pöt kaar ëan pöt tekeri yewas. ");
INSERT INTO wer_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ne Anutu weëre kosangöök urmerarö waö yeë. Pötaanök Anutuu wa ngaöök yanimë pöt arim naë yaarö. ");
INSERT INTO wer_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Omën nga namp, Seten, pim raëëp wak tupre ka pimtak ngarangk ëak öpna pöt pim omnant muumöngk wiaapnaat. ");
INSERT INTO wer_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pël ëaap omën nga munt namp weëre kosangringëp nook wais il mowesak raare inre tang pim kosang wesak weëa pöt wa ëp ëak pim omnant pout kom ëak omën muntarö mempaat. ");
INSERT INTO wer_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Namp ne sant naalnëën yaë pipop kööre tok yaalnë. Namp neering pol sëpsëpörö wa top naën yaë pipop pi sëpsëpörö rep yamë.” ");
INSERT INTO wer_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Pël mëak Yesuuk pitën watepang ngön nent epël ök mëëa. “Urmer namp omën nampökaan oröak së kosangöök wë urre korumön ap wesak epël kön wia. ‘Nem ka ngaan wakaim olëak waisautakë kaalak sumaan.’ ");
INSERT INTO wer_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Pël kön wiak së itaangkën ka tapët koore katëp ëak ë rangi ulmëën kos wieëa. ");
INSERT INTO wer_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Pël ëën pi kaalak së urmer muntarö 7 ëak koirak waisa. Pörö pim ök won, utpet panëërö koirak wais ka kopët taptak wëa. Pël ëën omën pöp pi ngaan utpet kot nent wakaimaupök ënëm sasa utpet pan sa. Pöta ök namp pim lupmeri ne won kos wiaapna pöt pi ënëmak utpet pan ëëpnaat.” ");
INSERT INTO wer_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesu pi pël yemaan öng nampök omnaröa tekrakaan ngön ëak epël mëëa. “Niwilak kapa nina pöpön kön wiin ërëpsawi yaë.” ");
INSERT INTO wer_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Maan Yesuuk epël mëëa. “Pipët yaap yaan. Nook pöt, Anutuu ngönte kat wiak wak wë piporöen kön wiin ërëpsawiaring yaë.” ");
INSERT INTO wer_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Omën kësang pan pim naë së wa top yaëën pi pitën epël mëëa. “Omën peene akun eptak wë eporö ar utpetarö. Ar ya retëngöt yamëngka pöten ke urak yenëak. Pötaanök ne ya retëng nent naëngan, ngaan Sona pim elmëa pöta ököt pëën pet elniin itaampunëët. ");
INSERT INTO wer_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Sona pim naë omën oröa pipët Niniwa kak wëauröaan Anutuuk pitën retëng pipët pet elmëa. Pipta ököt Omën Këëp nem elnëëpna pipët akun eptak wë eporö arën retëng pet elniimaat. ");
INSERT INTO wer_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ënëmak Anutuu omën kom elniipna akunetak öng ak namp yang we naöökël wakaimaup pi wal ëak arim kön wi kosang newasën yeë pöt war wasëpnaat. Pöt öng pöp yang kaö pantakaan Solomonë naë wais pim ëwat kësangöt kat wiipënëak waisaup pötaanök. Pël ëaap omën peene wë epop nook Solomon il yemowasetak ar nem ngönöt kat nawiin yeë. ");
INSERT INTO wer_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ënëmak Anutuu omën kom elniipna akunetak Niniwa kakaanörö pit wal ëak peene wë eporö arim utpetat tekeri wasëpnaat. Pöt Niniwa omnarö pit Sonaak ngönën ök maan kat wiak lup kaip tiaurö pötaanök. Pël ëaap omën peene wë epop nook Sona il yemowasetak ar nem ngönöt kat nawiin yeë.” ");
INSERT INTO wer_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Ar esuwes mangiak karök wiire kapita öngpök më pël naëngan. Ngaarëk wesirën ëwa ëaan omën kakaati waisëpnaarö ëwa pöön itaampnaat. ");
INSERT INTO wer_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","It pipöörar arim koröpöökë rampewes. Arim itöök omnant itenak kön ompyaut yawiin pöt arim lupötë rampewesi yaë pöl ëwa ompyaö ëaapnaat. Ën arim itöök omnant itenak kön utpetat yawiin pöt arim lupötë koö olëaapnaat. ");
INSERT INTO wer_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Pötaanök arim lupötë ëwa wia pipët koö olapanëën ngarangk këëkë ëën. ");
INSERT INTO wer_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Pël ëën arim lupötë kout won, ëwaat pëën wiaan pötak esuwesi yaë pöl ëwa elniaan önëët.” ");
INSERT INTO wer_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesu pi ngön pöt më pet irak wëën Parisi ngönën omën nampök kaömp nëmpënëak yas maan pim kaatak së ilëak wel aisëa. ");
INSERT INTO wer_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Pël ëën omën pöp itaangkën Yesu Yuta omnaröa yaaul kaömp akunetak i nairën ëa pöten kön wiin pangk naën ëa. ");
INSERT INTO wer_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Pël yaëën Yesuuk itenak epël ök mëëa. “Ar Parisi omnarö kelönre söwarre pöt kasngaëël pëën i yairem öngpök i nairën ëën kewil wia pöl ar koröpöök ompyaö wasën arim lupötë pöt kainre utpet yaaut peö ëak wë. ");
INSERT INTO wer_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Kaökaurö aë. Anutu omnantë koröpöt ket ëaup pi lupötta ket naën ëa ma? Ar pöt, arim koröp pëën kölam wasënëak kent yeëetak Anutu pöt, tiarim lupötta kölam sëpenëak kent yaë. ");
INSERT INTO wer_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ar arim lupötëaan kësangën yaat mëmpunë pötak arim lupötë kout won sëpnaat. ");
INSERT INTO wer_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“O Parisi omnarö, yakömpe. Arim naë könöm nant orööpnaat. Ar ëwamre kaëkoöre këënre pöt wa top ëak moresiar wesak nokoliil nent Anutuun yaö yaalmë. Ar omën pas pöt yeemak nokoliil omën ompyaut ëëre Anutuun lup sant elmë pöt naën yeë. Poutepar ëënë pötaar ompyaö. ");
INSERT INTO wer_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","O Parisi omnarö, yakömpe. Arim naë könöm nant orööpnaat. Ar ngönën tupötë kakaati së omnaröa itëkëël wel aisanëëten kent yaaurö. Pël ëak omnarö wa ronganöök koirak ërëpsawi ngön niapnaaten kent yaaurö. ");
INSERT INTO wer_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","O yakömpe. Arim naë könöm nant orööpnaat. Ar omnarö yangaöökë ongpök weera pöta ök. Pël ëaan omnarö utpet wia pöten köpëlëk roro sak waisak yaë.” ");
INSERT INTO wer_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Yesu pi ngön pöt maan ngön kosangötë ngarangk nampök epël mëëa. “Rë yanuulaup, nim ngön pipët tenta yaniö.” ");
INSERT INTO wer_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Maan Yesuuk kangiir epël mëëa. “O ngön kosangötë ngarangkörö, yakömpe. Arta arim naë könöm nant orööpnaat. Ar ngön kosang nant pit ngar öpënëak arim könöökaan mangkën pit ngar öpënëak këlangön kat yawiin arimënt kaamök naën yeë. ");
INSERT INTO wer_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Yakömpe. Arim ëaröak tektek ngön yaaurö mënaut. Pël ëën arök pitëm yangaö wa ngolöp wesak ë yemorangi. ");
INSERT INTO wer_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Pël yeem arim ëaröa eima pötön kön wiin ompyaut yaë. Pitök tektek ngön yaaurö mëngkën wel wia. Ën arök yangaö ë yemorangi. ");
INSERT INTO wer_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Pötaanök Anutu ëwatëpök epël ëaut. ‘Ne tektek ngön yaauröere nem ngön yaaö omnarö pitëm naë wes mëën narö këlangön kat mowiire narö mëmpö pël ëëpnaat.’ ");
INSERT INTO wer_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ar arim ëaröa eima pötön kön wiin ompyaut yaë. Pötaanök omën ngaan tektek ngön yaaurö mëmpö waiseima pöröa saunatë könömët akun eptak wë eporö ar önëët. ");
INSERT INTO wer_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ngaanëër arim ë nampök ngës rëak Apel mënak mëmpö mëmpö ë wais Sekaraia pi kiri ar yaaö kaata kakaati mënaut. Pötaanök ne niamaan kat wieë. Mëneima pöta könöm pöt peene ar akun eptak wë eporöa naë pet irëpnaat. ");
INSERT INTO wer_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","O ngön kosangötë ngangkörö, yakömpe. Arim naë könöm nant orööpnaat. Ar ngönën kat yawiauröa kanö il yemowariaurö. Arimëntta kan pöök nasën wë omnarö sëpanëak kan yemowariaurö.” ");
INSERT INTO wer_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ngön pöt mëak yesën ngön kosangötë ngarangköröere Parisi ngönën omnarö ngës rëak pim ököök ë yesem morök elmë sa. ");
INSERT INTO wer_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Pël yeem pim këmtakaan ngön nent kat wiin korar aan pöt pötak utöpënëak ngarangk këëkë pan ëa. ");
INSERT INTO wer_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Omën selap pan Yesuu naë wa top ëak teptep ëak naröa ingötë rangk naröaat mësëak wëa. Pël ëën Yesuuk pim ruuröen wet rëak epël mëëa. “Parisi omnarö pit kaar yaaurö. Yis kaömp peret ket yaaö pöt korupaë kas möautë öngpök ëlëëp repak yes pöl pitëm kaar yaaö pöt repak yes. Pötaanök arim naë repak waispanëën ngarangk këëkë ëën. ");
INSERT INTO wer_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Omën ngep ëën wia pipot wiakaim wi naöpanëët. Ënëmak wëlël ëën omnarö itaampnaat. Ën ëlëëp wia pipot wi naöpanëët. Pipot tekeri sëpnaat. ");
INSERT INTO wer_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Pötaanök arim koutak ngön yak pipot omnarö pit ëwaatak kat wiipnaat. Ën arim kaata kakaati ngön laöök yak pipot ënëmak omnaröa tekrak wë kaö wesak orööpnaat.” ");
INSERT INTO wer_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Ngöntörö, ne niamaan. Ar koröpö pëën nimëmpnaaröen kas ëëngan. Pit pël ëak rangkël munt nant naalniipan. ");
INSERT INTO wer_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ën arim kas ëënë pöpön nook ök niamaan. Ar Anutu nimënak ënëmak kaalak es parëaöök wa nuulapna pöpönökëër kas ëën. ");
INSERT INTO wer_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Omnarö tiar int sëpër mor nas pörö 2 toea pötak sum ëëpenaatak Anutu pi int kot ke pëlöröenta kat nokolön yaaup. ");
INSERT INTO wer_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ën omnarö ar pöt, arim kepön ëpötönta ëwat wëaup. Pötaanök ar kas ëëngan. Anutuuk kön wiin arök int koturöa sum pöt il mowasën arën kat nokolön yaaup.” ");
INSERT INTO wer_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Ne niamaan kat wieë. Namp pi omnaröa ëöetak, ‘Ne Yesuu ënëm yeë,’ pël apna pöp Omën Këëp nookta kangiir Anutuu enselöröa ëöetak, ‘Pi nemop,’ pël amaat. ");
INSERT INTO wer_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ën namp pi omnaröa ëöetak neen yak newasëpna pöp nookta Anutuu enselöröa ëöetak piin yak mowasömaap. ");
INSERT INTO wer_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Namp pi Omën Këëp neen utpet wesak apna pöp pim saun pöta kangit Anutuuk kërë moolapnaat. Ën namp pi Ngëëngk Pulöön utpet wesak tapël mapna pöp pim sauneta kangit ent ë nemoolapan. ");
INSERT INTO wer_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ën omnaröak ngönën ngarangköröere yang ngarangköröa naë mës nuwak së ngön yaatak niulëëpënëak yaëën pöt ngön nokoliit tolël menet ëak kön selap ëënganok. ");
INSERT INTO wer_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Akun pötak ngön anë pöt Ngëëngk Pulöök tekeri wes nimpnaat.” ");
INSERT INTO wer_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Omnarö pitëm tekrakaan nampök Yesuun epël mëëa. “Rë yanuulaup, nem nanëp pi tenpim pepapë mor kolöt pimënt wak wë. Pötaan ni ök ma. Pël ëën nent kom ëak ne nampnaan.” ");
INSERT INTO wer_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Maan Yesuuk epël mëëa. “Talëpök ne arim ngön ë pet irööre omnant kom ë pël ëëmëak yaö neea? Pël naëngan.” ");
INSERT INTO wer_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Pël mëak yal menak pitën epël mëëa. “Ar ngarangk ëën. Ar omnantëën kentre kaur ëënganok. Omnarö pitëm omën kësang wa pipotök wëwëet koir nemangkën yaaut.” ");
INSERT INTO wer_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Pël mëak watepang ngön nent epël mëëa. “Omp ak namp pim yaak kaömp kësang pan oröa. ");
INSERT INTO wer_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Pël ëën pi epël kön wia. ‘Ne kaömp kaat wonöp. Oröptak kaömp epot wa wiim? ");
INSERT INTO wer_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ne epël ëëm. Kaömp kaat töölak kaö wes ök rëak nem kaömpre omnant pout wa wiimaan. ");
INSERT INTO wer_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Pël ëak epël kön wiimaat. Peene akun eptak nem kaömpre omnant kësang pan wia. Pötaanök akun wali wak wë në pël ëeimeë ërëpsawaring kë seim ömaat.’ ");
INSERT INTO wer_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Pël maan Anutuuk epël mëëa. ‘Kaökaup, ni röök eptakëër wel wiimëëp. Talëpök kopëta wes wian pöt öpën?’” Pël mëak Yesuuk ngön kaut epël mëëa. ");
INSERT INTO wer_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Omën narö Anutuu naëaan ulöpre moup pöt pitëm lupötë won wiaan yangaakë omnant ulöpre moupring öpna pörö omën pöpë ök sëpnaat.” ");
INSERT INTO wer_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Pël mëak Yesuuk pim ruuröen epël mëëa. “Pötaanök ne niamaan. Ar arim wëwëetaan kön selap ëak epël anganok. ‘Tiar kaömp tarëkaan öpen?’ Ën koröpöönta kön selap ëak epël angan. ‘Oröpötök kör koëpen?’ ");
INSERT INTO wer_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kaömp pöt këët won, wëwëetakëër këët. Ën ulpëënre poë koröp pöt këët won, koröpöökëër këö. ");
INSERT INTO wer_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ar intöröen kön wieë. Pit kaömpöt ngëntööre wa peram wi pël naën yaauröak Anutuuk kaömp koir mangkën neim wë. Omnarö arök intörö il yewas. Pötaanök pi ngarangk elniipnaat. ");
INSERT INTO wer_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ma arim naëaan nampök weëre kosang wia pöt yok pangk pimtë wëwëeten kön selap ëak kot nent wali wasëpën sa ma? Won. ");
INSERT INTO wer_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Arök kot ke pëlöt naënöröak tol ëënak omën muntatëën kön selap yeë? ");
INSERT INTO wer_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ar polpol puutön kön wieë. Pit pitëm ulpëënre poë koröpötëën waur naën yaë. Pël yaëëtak ne niamaan. Omp ak Solomon pi omnant kësang wieëaupök ë rangiak wakaima. Pël ëaap pim ë rangiatök polpol pu pötëët il nemowasën. ");
INSERT INTO wer_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Këra pu ompyaut ya lupöök peene yaarö, ëlpamök tiak es marën won sëpnaat pël yewas pipotta Anutuuk maan ompyaut yaarö. Kön wi kosang panë newasënörö ar pöt, Anutuuk koröpöökë kaamököt nin yaë. ");
INSERT INTO wer_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Pötaanök ar iire kaömp nënë pötön kön selap ëëngan. ");
INSERT INTO wer_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Yangerak köpël omnarö pit omën pipotëën kön kësang wia. Pël ëaap arim Pepap ar wëwë koirënëën iire kaömp nënë pöten kön wia. Pötaanök omën pötëën kön selap ëëngan. ");
INSERT INTO wer_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ar pöt, Anutuuk wa ngaöök nimëëpnaataan weë ngentiin. Pël ëën puuk omën pipotta koir nimpnaat.” ");
INSERT INTO wer_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Sëpsëp rongan kot epët ar kas ëëngan. Pep pi ar wa ngaöök nimëëpënëak kön wiin pangk yaë. ");
INSERT INTO wer_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Arim omnant pout sum ëak mon kangiir önë pöt wonörö meneë. Pël ëak ar mon weë panëët wak wëën utpet nasëpanëët. Titi tëëre kain wë pël naëpanëët. Mon pöt arimëën kutömweri wiaapnaat pötaanök. ");
INSERT INTO wer_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Arim omën ompyaut wia pörekël könötta wiaapnaat.” ");
INSERT INTO wer_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Ar poë koröp mënt wes urak es rangiak kopëta weseë. ");
INSERT INTO wer_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ar pël ëak inëën omën narö pitëm kaöap wa topöökaan wais kanwer körang elmëën të mowiipënëak kor wakaima pöta ök ëeë. ");
INSERT INTO wer_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Pël ëën inëën ruurö ka naurön wiaan wais itaangkën pöt pit ërëpsawi ëëpnaat. Ne yaap niamaan. Kaöap pi poë koröp mënt wes urak urötë wa moulmëak kaömp nëmpnaataan inëën elmëëpnaat. ");
INSERT INTO wer_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ën pi röök lupöök ma ëlpam walëpënëak yaëën pit ka naurön wëën wais itaangkën pöt pit ërëpsawi ëëpnaat. ");
INSERT INTO wer_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ar epël kön wieë. Ka pepap pi kainëpë waisëpna akuneten ëwat wëanëën pi itit wë ngarangk ëën kainëp kaat pör menak neilaan ëan tapön. ");
INSERT INTO wer_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Omën Këëp nem waisuma akunetak ar kön nenewiin wëën pipël ëëm sa. Pötaanök ko ëak ön.” ");
INSERT INTO wer_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Yesu pi ngön pöt maan Pitaak epël mëëa. “Aköp, ni watepang ngön pipët tenimëntëën ma ten omën pouröaan yaan?” ");
INSERT INTO wer_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Pël maan Aköpök epël mëëa. “Ar inëën ru ompyaupë ök sën. Inëën ru namp kön ompyaö wieë ya ompyaö yamëngkën kaöapök pim karurö ngarangk ëeë akunatë kaömp mampënëak moulmëak sa. ");
INSERT INTO wer_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ënëmak inëën ruup kaöapë ök mëak sa pöl ëeim wëën kaöap wais itaangkën pöt pi ërëpsawi ëëpnaat. ");
INSERT INTO wer_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ne yaap niamaan. Kaöap pi pim omnant pout ngarangk ëëpënëak moulmëëpnaat. ");
INSERT INTO wer_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ën inëën ru pöp pi, ‘Nem kaöap pi teënt newaispan,’ pël weseë inëën koont yokot muntarö tang mö kaömpre i ngaat nak kön irikor ëeim wë ");
INSERT INTO wer_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","pim kaöapë waisëpna akuneten kön nawiin öpna pötak kaöap kaalak waisëpna pöt pi yokot pöp möak utpet wesak omën ngön wa yoolëauröa naë moulmëëpnaat. ");
INSERT INTO wer_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Inëën ru namp pim kaöapë këm ngönten ëwat wëak kangk naën kat koko öpna pöp kaöapök pës kaö panë mööpnaat. ");
INSERT INTO wer_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ën ru namp kaöapë këm ngönten köpël wë omnant pës mööpna salöt ëëpna pöp kaöapök pës kaö namöön ëëpnaat. Pötaanök nem kaalak waisuma pötak ko ëak ön. Namp pi omnant kësang mampnaap këët kësang tapël koirën pangk ëëpnaat. Ën namp pi ya kaö tapël menaupök kosang ngentiak ya kaö mëmpna pöp kësang tapël koirën pangk ëëpnaat.” ");
INSERT INTO wer_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Ne esuwes marën ulölöt yokot pöta ök ar omnarö kom elniimëak yangerak waisaup. Pötaanök esuwes teëntom wëlëng kotöpnaaten kent yaë. ");
INSERT INTO wer_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ne këlangön kat wiimëak ëautak pël naën wë. Pötaan ya ngësring wë pet irumaaten kent yaalnë. ");
INSERT INTO wer_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Arök ne yangerakë ngaat won wasumëak waisan wasngan. Ne omnarö kom elniin kööre tok ëënëak waisaup. ");
INSERT INTO wer_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Pötaanök peene ngës rëak ka nentak omën mor nas önëërö ar kom elniin naar namp ëak nal naar nal pël ëak neneraan kööre tok ëënëët. ");
INSERT INTO wer_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Epël ëënëët. Pepapök ruupön kööre tok yeëa. Ruupök pepapön kööre tok yeëa. Ëlëpök korömpëën kööre tok yeëa. Korömpök ëlëpëën tapël yeëa. Pël yaëën öng lëlamringaarta nampnampön kööre tok ëëpnaat.” ");
INSERT INTO wer_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesuuk pël mëak omën pouröen epël mëëa. “Ar uröam yewariin itenak, ‘Kopi waisëpënëak yaë,’ pël yaan yok wais yaë. ");
INSERT INTO wer_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ën yanget ompyaö ëak yesën itenak, ‘Kët mapnaan yaë,’ pël yaan yok kët më yaë. ");
INSERT INTO wer_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Kaar omnarö, ar mopöök uröamre kepilötön itenak ëwat yaauröak tol ëën akun wë eptak Anutu pim yaauta songönten köpël yeë?” ");
INSERT INTO wer_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Tol ëënak utpetre ompyaö pötepar kom naën yeë? ");
INSERT INTO wer_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ni ngön yaatak sumëak yeem pöt wet rëak niiring ngön wieëaupring ë kopëta wasum. Ni pël naën së niiring ngön wieëaupök ë pet yairaupë naë niulëën puuk ë pet irak polisöröa naë niulëën pitök wii kaatak niulëëpan. ");
INSERT INTO wer_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ne niamaan kat wi. Ni pörek wë teënt naarööngan. Nim karipë kangut pout pet ir olëakök oröömëëp.” ");
INSERT INTO wer_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Akun pötak omën naröak Yesuu naë së epël mëëa. “Kalili yangerakaan omën narö ngaan animaö iit Anutuu kiri ëëpënëak yaëën Pailatök maan pim ngaaröak mëngkën wel wia.” ");
INSERT INTO wer_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Maan Yesuuk kangiir epël mëëa. “Ar epël kön wiingan. ‘Pitëm saunat Kalili omën muntaröaat il yemowasën yak mëngkën wel wia,’ pël wasnganok. ");
INSERT INTO wer_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Won, arta lup kaip natiin ëënë pöt tapël wel wiinëët. ");
INSERT INTO wer_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ën ngaan Yerusalem kak Siloam ka waliimpel töölak omën 18 ëak ngep ëën wel wia pöröeta pitëm saunat Yerusalem omën muntaröaat il yemowasënak ëa wasngan. ");
INSERT INTO wer_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Won, arta lup kaip natiin ëënë pöt tapël wel wiinëët.” ");
INSERT INTO wer_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yesu pi ngön pöt mëak watepang ngön nent epël mëëa. “Omën namp pim ya lupöök kem nement ngëntën wëa. Pël ëën ënëmak ulöpörö tööpënëak së itaangkën won wieëa. ");
INSERT INTO wer_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Pël ëën inëën yaaupön epël ök mëëa. ‘Krismaki nentepar nent pötë öngpök këra epment töömëak wais itaangkën won yaë. Pi këpök yang kolapöt yen. Pötaanök ni ku ti ola,’ pël mëëa. ");
INSERT INTO wer_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Pël maan inëën ruupök epël mëëa. ‘Pël ëënganëp om öp. Pël ëën krismaki kopët epëta öngpök nook songöntak yang inin ëak pol yaat köm lëëmaat. ");
INSERT INTO wer_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Pël ëën krismaki ootak utöpna pöt yok pangk. Nautön ëëpna pöt ku tiimëët.’” ");
INSERT INTO wer_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Yesu pi kë yesa akun ngëëngk nentak ngönën tup nentak së omnaröen ngönën ök mëëa. ");
INSERT INTO wer_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Pël yaëën omnaröa tekrak öng namp urmerap piik wëën yauman sësë eim wëën krismaki 18 ëak won saup wëa. Öng pöp kasngelö pak ëak wë wotpil tau naön yaaup. ");
INSERT INTO wer_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Pël ëën Yesuuk öng pöpön ngön mëak epël mëëa. “Öng epop, nook nim yaumante wa yoolak.” ");
INSERT INTO wer_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Pël mëak moresiar pim rangk mowiin tapëtakëër wotpil sak Anutuun yaya mëëa. ");
INSERT INTO wer_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Pël yaëën ngönën tup pöta ngarangkëp Yesuuk akun ngëëngktak ompyaö yemowasën itenak ya sangën ëën omnaröen epël mëëa. “Kët 6 pipot ya akunat. Pötaanök ar ompyaö niwasëpënëak pöt akun pipotë waisën. Ën akun ngëëngktak pipotëën waisngan.” ");
INSERT INTO wer_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Pël maan Yesuuk kangiir epël mëëa. “Kaar omnarö ar, akun ngëëngkötë ar pol purmakaöre tongkiiröa kaatak së kan të mowiak mësak sëën i na yaë. Ar kön wiin arim animaurö pël yaalmëem ya yamëngk pipët ompyaut pël yewas. ");
INSERT INTO wer_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Pël ëaap öng epop pöt tiar Yuta omnaröa kar namp Apramë ëapök Setenök krismaki 18 pötë öngpök wii motëak wakaima. Pötaanök nook akun ngëëngktak wil yemoulmëep pangk naën yaë ma?” ");
INSERT INTO wer_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Pël maan pimëën kööre tok yaaurö pit ëö sa. Ën omën ëlörö pöt pim ya ompyaö yamëngka pötëën ërëpërëp ëa. ");
INSERT INTO wer_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesu pi yal menak epël mëëa. “Anutuu wa ngaöök yanimë pöt tolëëlte? Ne oröp nantë ök ëëm? ");
INSERT INTO wer_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Pipët këra lëlëp nampë ököt. Omën nampök lëlëp pöp pim yaak së ngëntën oröak kaö sak wëën intörö wais morötë ngentiak ka ëp yawi.” ");
INSERT INTO wer_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Pël mëak munt nent epël mëëa. “Anutuu wa ngaöök yanimë pöten oröptak ök ëëm? ");
INSERT INTO wer_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Pöt yis pöta ököt. Öng nampök yis pöt korupaë kas möautring wa irikor ëën pötak ekek sëpnaat.” ");
INSERT INTO wer_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu pi Yerusalemë sëpënëak yesem ka kotre kaö poutë ngönën ök maö sa. ");
INSERT INTO wer_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Pël yaëën omën nampök pëël mëak epël mëëa. “Aköp, Anutu pi omën kopët nampnamp utpetetakaan öpën sa ma?” Maan Yesuuk pitën epël mëëa. ");
INSERT INTO wer_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Ar kan koturak ilëak wëwë kosangta kanöök sënëëtaan weë panë ngentiin. Ne niamaan. Omën selap pan kan pörak ilapënëak weë ngentiipnaatak pourö neilapan. ");
INSERT INTO wer_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ka pepap pi pim kaat kan wariak öpnaat. Pël ëën ar tomökël wë pomp ëak taueë körang elmëak epël manëët. ‘Aköp, tenimëën kan të niwi.’ Pël maan puuk epël niapnaat. ‘Ne arën köpël. Ar tarëkaanörö?’ ");
INSERT INTO wer_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Pël niaan ar epël manëët. ‘Ten niiring kaömpre i ngawi naut. Ni tenim kak wais rë nuuleimënte.’ ");
INSERT INTO wer_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Pël maan puuk epël niapnaat. ‘Ne arën köpël. Ar tarëkaanörö? Utpet omnarö, ar mop newiak kama seë,’ pël niapnaat. ");
INSERT INTO wer_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Pël ëën ar itaangkën Apramre Aisakre Yakopre tektek ngön yaaurö pit Anutuu naë wëën itaampunëët. Ën ar pöt kaaö yaaurö. Pötaanök tomökël wë ingre ya ilak aimeë kë pötöppötöp aim önëët. ");
INSERT INTO wer_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Pël ëën omën yang we naöökaan naöök, këtëp yengampiaulaanre yeilëaulaan pourö wais Anutuu naë wel aisëeë kaömp neim öpnaat. ");
INSERT INTO wer_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Kat wieë. Tiar yang omnaröa naëaan kot narö kutömweri së kaö sëpnaat. Ën kangiir kaö narö kot sëpnaat.” ");
INSERT INTO wer_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Akun taptak Parisi omën narö së Yesuun epël mëëa. “Yang omp ak Erot pi ni nimpënëak ya. Pötaanök ni eprek sëp wesak nal së.” ");
INSERT INTO wer_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Maan Yesuuk epël mëëa. “Ar kaalak së kent tok utpet pöpön epël man. ‘Yesuuk pimtën epël ya. Pi akun eptak omën urmerarö wëaurö waö ë momëak yauman omnarö ompyaö mowesak akun kot nent won sëën pet irëpnaap pël ya,’ pöt man. ");
INSERT INTO wer_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Peeneere ëlpamök yesem muntetak Yerusalem kak oröömaap. Pöt tol ëënak? Tektek ngön yaaö namp Yerusalem kak naaröön wiaan namëngkën ëëpnaat.” ");
INSERT INTO wer_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Pël mëak pimtëën epël mëëa. “O Yerusalem omnarö, Yerusalem omnarö, yaköm. Ar tektek ngön yaaurö mëmpööre ngönën omën arim ngësë wes nimëaurö kël mö wel wi pël yaaurö. Kët ël epotë ne kokor ëlëpë ruurö wereweriarë öngpök wa mëak ngarangk yaalmë pöl ar wa rongan ëak ngarangk elniimëak kent kön wiak pël yaalniin ar kaaö elnëeimaurö. ");
INSERT INTO wer_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Pötaanök ne sëp niwasën ngarangk won önëët. Ne yaap niamaan kat wieë. Ar it nenengaangkën wakaim akun kaöaöök neen kaalak itenak epël neanëët. ‘Aköpök wes nimëën yewais epopön yaya mepa.’” ");
INSERT INTO wer_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Kë yesa akun ngëëngk nentak Yesu pi Parisi omën kaö nampë kaatak së kaömp yenën omnarö pit iteneëa. ");
INSERT INTO wer_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Pël yaëën omën koröpö pön mena namp pim naë wëa. ");
INSERT INTO wer_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Pël ëën Yesuuk itenak ngön kosangötë ngarangköröere Parisi omnaröen epël mëak pëël mëëa. “Tiar yok pangk akun ngëëngktak yauman omnarö ompyaö mowasëpen ma won?” ");
INSERT INTO wer_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Pël maan pit om ngön won sak wëën omën pöp moröak ompyaö mowesak wes mëën sa. ");
INSERT INTO wer_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Pël ëën pitën epël mëëa. “Arim naëaan namp akun ngëëngktak pim rungaap ma pol namp yang öngöpöök ilëaan sëp wasëpën ma yok pangk akun ngëëngk taptak öpën?” ");
INSERT INTO wer_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Pël maan pit kangiir mapënaat ap wesak sëp wesa. ");
INSERT INTO wer_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesuuk omën kaömp nëmpënëak së wëa narö itkëël wel aisapënëak yaëën itenak watepang ngön nent epël mëëa. ");
INSERT INTO wer_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Ni omën nampë këëre imëntak yas niaan së pöt itkëël wel aisanganok. Pël ëëmë pöt omën yapinring namp ni il niwasëpna pöp waisën pöt ");
INSERT INTO wer_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","omën yas niia pöpök epël niapnaat. ‘Ni itkëël ur epët omën epop man.’ Pël niaan ëö kaö sak kasngaëël së ömëët. ");
INSERT INTO wer_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ën nampök pim këëre imën nentak yas niaan së pöt kasngaëël pan wel aisam. Pël ëën këëre imën pepapök wais itenak epël niapnaat. ‘Ngöntöp, ni itkëël wais wel aisa.’ Pël niaan ni omën muntaröa ëöetak itkëël wëën niin kön wiin isëpnaat. ");
INSERT INTO wer_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Namp pi pimtën kön wiin isëpna pöp Anutuuk wak irapnaat. Ën namp pimtën kön wiin irapna pöp Anutuuk wak isëpnaat.” ");
INSERT INTO wer_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Pël mëak omën yas mëëa pöpön epël mëëa. “Ni këëre imën numëak nim ngöntre kar, sasre nanre nim kak omën mon wieëa piporöen yas manganok. Ni pitën mamë pöt pitök kangiir niin yas niak kangut nimpnaat. ");
INSERT INTO wer_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Pötaanök pël ëënganëp. Ni këëre imën ar ëak pöt omën omnant won, ingre mor il tëaare it il tëa piporöen yas mam. ");
INSERT INTO wer_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Omën ke pilöröakëër kangut nanimpan. Pötaanök ni ërëpsawi ëëmëët. Om wiaan wë ënëmak omën ompyauröa weletakaan wal ëëpna akunetak Anutuuk nim kangut nimpnaat.” ");
INSERT INTO wer_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Yesu pi pël maan kaömp yenaurö pit kat wiak pitëm naëaan nampök epël mëëa. “Omën Anutuuk wa ngaöök mëaan piiring kaömp nëmpna pörö ërëpsawi ëëpnaarö.” ");
INSERT INTO wer_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Pël maan Yesuuk ngönaak nent piin epël ök mëëa. “Omën nampök këëre imën kaö nent nëmpënëak omën kësang pan yas mëëa. ");
INSERT INTO wer_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Pël ëak nëmpëna akunet temanöm sëën pim inëën ruup wes mëën së yas mëëauröen epël mëëa. ‘Yok waiseë. Omnant pout yok wa kön ë pet iraut.’ ");
INSERT INTO wer_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Pël maan pit pourö omën pasutëël utak om öpënëak nampök epël mëëa. ‘Ne yang nent sum ëaut yak pötak wer yeneön sumaan yeë. Pötaanök nemop newaisngan sa.’ ");
INSERT INTO wer_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Pël yemaan nampökta tapël mëëa. ‘Ne pol purmakaö moresiar ya kaamök elnëëpënëak waut yak së ya ökre was ë pet ëëmaan yeë. Pötaanök nemop ne newaisngan sa.’ ");
INSERT INTO wer_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Yemaan nampök epël mëëa. ‘Ne peene tapët öng waup. Pötaan newaisngan sa.’ ");
INSERT INTO wer_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Pël maan inëën ruup së pim kaöapön ök mëëa. Pël ëën kaöap pi kat wiak ya këlangön ëën inëënëpön epël mëak kaalak wes mëa. ‘Ni teënt së kaatë omën omnant won ingre mor il tëaare it il tëa piporö pourö koirak nem kaatakë waisum.’ ");
INSERT INTO wer_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Pël maan inëën ruup pim mëëa pöl ëak së kaöapön epël mëëa. ‘Kaöap, nim aan pöl ëautep omnarö pangk naën ur nant om wiaap.’ ");
INSERT INTO wer_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Maan kaöapök kaalak epël mëëa. ‘Ni kan kaö poutë së pël ëak wilëngkë kaatë së öngpök ilëak omën pouröen këkre tö mëak koirak wais ulmëën nem kaat peö ëëp. ");
INSERT INTO wer_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ne niamaan kat wi. Omën wet rëak nem yas mëëa piporö nem kaömp pöt nanëmpan pan.’” Yesu pi watepang ngön pipët yamëem yas maan pim naë sëpnaaten kaaö yaaurö kutömweri piiring kaömp nanën ëëpën pël mëëa. ");
INSERT INTO wer_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Omën kësang pan Yesuring sa. Pël ëën pi kaip ti pitën itneë epël mëëa. ");
INSERT INTO wer_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Omën namp nem ënëm ëëpënëak pim ëlre pep, öngre ru, sasre nan pimoröen kent ëak neen kaaö elnëëpna pipop ma pimtë koröpöökë wëwëeteta kasëng nemangkën ëëpna pipop nem ruup pël nasëpan. ");
INSERT INTO wer_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Pötaanök omën namp pi, ‘Ne Yesu pimëën wel wiima pöt pangk ëëmaap,’ pël wesak pim këra yetapër wak ënëm naalnëën ëëpna pipop nem ruup pël nasëpan. ");
INSERT INTO wer_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Arim naëaan namp pim ka kaö nent ök rapën pël kön wiak pöt wet rëak monet ka pöt pangk ëëpën ma won pöten sangk kelëpnaat. ");
INSERT INTO wer_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ën pël naënrek köntak wap wesirak mormor ë yesem luptak së pangk naën ëën sëp mowasën om wiaan pöt omnaröak itenak ökre was epël mapnaat. ");
INSERT INTO wer_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Omën epop pi kaat ök rapënëak ngës rëaupök pet nairën ëa.’ ");
INSERT INTO wer_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ën yang omp ak namp pi yang omp ak munt nampring nga elëpënëak wet rëak pimëntë nga omnaröa saarëët sangk kelën pimtëët 10,000, ën muntapëët 20,000. Pël ëën pimënt kön wiipnaat. Pi yok pangk muntapring nga elëpën ma won pöten kön wiipnaat. ");
INSERT INTO wer_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Pël ëak pi kön wiin pangk naën ëën pöt pim kööre toköp kamaarek wëën omën narö wes mëën së ngön ëak nga pöt wiap wasëpnaat. ");
INSERT INTO wer_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Pötaanök arim naëaan omën namp pi pim omnant pout kasëng nemangkënëpök nem ru nasëpan. ");
INSERT INTO wer_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Tomun pöt omën ompyaut. Pël ëautak pim misëngö won sak wiaan tiar tol ëak kaalak misëng wasën pangk ëëpën? Pël naëngan. ");
INSERT INTO wer_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Tomun ke pëltak ya lupöök olaöre purmakaö yaatring irikor ë pël naëngan om moolapenaat. Katëëpringëpök ngön epët kat wiip.” Pöta ök tapël narö yaap Yesu pim ënëm naën ëëpna pöt Anutuuk wa moolapnaat. ");
INSERT INTO wer_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Akun nentak omën takis yewaare utpet yaaö munt narö Yesuuk ngönën ök yemaan kat wiipënëak pim naë sa. ");
INSERT INTO wer_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Pël yaëën Parisi omnaröere ngön kosangötë ngarangkörö pit Yesuun yak këëpöt ngön mëak epël mëëa. “Omën epop omën utpet yaaurö ngöntre kar elmëak kaömp ngawi yen.” ");
INSERT INTO wer_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Pël yemaan Yesu pimënt kat wiak watepang ngön nent epël mëëa. ");
INSERT INTO wer_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ar nampë pol sëpsëpörö 100 ëak wëauröak kopët namp kö sëpnaat. Pël ëën sëpsëpöröa pepap pi 99 pörö we naöökël kaömp neim wëën pi we naöökël kö sa pöpön ngaöl ë së koirëpnaat. ");
INSERT INTO wer_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Pël ëak ya kë sak wa kuröpweri waalak ");
INSERT INTO wer_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","kak së oröak karuröen ngön ëak epël ök mapnaat. ‘Nem sëpsëp epop kö sëën ngaöl ë së koirak yewais. Pötaanök ërëpsawi ëëpa.’ ");
INSERT INTO wer_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ne ök niamaan kat wieë. Pöta ök omën wotpil 99 pörö lup kaip tiipënëak kön nawiin yaaurö omën kutömweri wëaurö pitëmëën ërëpsawi kotkot yaë. Ën utpet kopët epop lup kaip yati pötaan kutömweri wëaurö ërëpsawi kaö yaë.” ");
INSERT INTO wer_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Öng namp pi mon 1 kina wak wëën 10 toea nent kangk ngentiin pöt pi kalaö rangiak kakaati katëp ilak këëkë panë ap wesak koirëpnaat. ");
INSERT INTO wer_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Pël ëak pim karuröen epël mapnaat. ‘Nem 10 toea irikor ëën ap weseim pöt peene yokoir. Pötaanök ërëpsawi ëëpa.’ ");
INSERT INTO wer_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ne ök niamaan kat iweë. Pöta ök omën utpet kopëtap lup kaip tiin Anutuu enselörö ërëpsawi yaë.” ");
INSERT INTO wer_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu pi pël mëak munt nent epël mëëa. “Omën namp pim yokot naar wëa. ");
INSERT INTO wer_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Wë yokot ënëmapök pepapön epël mëëa. ‘Nim monere uröm tenpimëën yaö ëan pöt kom ëak nemëën ëaut nan.’ Pël maan pepapök pim omnant pout kom ëak yokotaar mena. ");
INSERT INTO wer_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Pël ëën akun kot nent wë yokot ënëmap pi pimot wak yang wali nerekël sa. Pörek së wë omnantëën kentre kaur ëak pim monat pout won wes olëa. ");
INSERT INTO wer_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Pël ëak omnant pout won wesak wëën ënëmak yang pörek këën kësang nempel oröa. Pël ëën pi ngöntök panë ëën ");
INSERT INTO wer_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","yang pörek omën nampë naë së wëën omën pöpök pim polöröa ngarangk moulmëën wakaima. ");
INSERT INTO wer_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Pël ëak polöröa kaömp karut mangkën nak kep ëëpën wesak itaangkën pötta nemangkën ëa. ");
INSERT INTO wer_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Pël ëën pi kön tektek sak epël kön wia. ‘Nem pepapë inëën ruurö kaömp kësang pan neim wëën ne eprek wë këënëën wel wiimëak yeë. ");
INSERT INTO wer_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Pötaanök nem pepapë ngësë kaalak sumaat. Së oröak epël memaat. “Pep, ne Anuture niire ëak utpet elniaut. ");
INSERT INTO wer_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Pötaanök peene pöt nim ru panëëp pël neangan. Om nim inëën ru newasën ömaat.” ’ ");
INSERT INTO wer_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Pël wesak wal ëak pim pepapë ngësël sa. Seim së kak temanöm yesën pepap itenak ya utpet ëën naë së kapariak tot na. ");
INSERT INTO wer_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Pël ëën ruupök epël mëëa. ‘Pep, ne Anuture niire ëak utpet elniaut. Pötaanök peene pöt nim ru panëëp pël neangan.’ ");
INSERT INTO wer_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Pël maan pepapök pim inëën ruuröen epël mëëa. ‘Ar teëntom nem ulpëën wali ompyaup momëak mor ëngö wak wais moresi momëak ing körtepar wak wais ingesiarë momëak pël ëeë. ");
INSERT INTO wer_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Pël ëak purmakaö ru ompyaö mësëpringëp möeë. Pël ëën ar ëak yenem ërëpsawi ëëpenaan. ");
INSERT INTO wer_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Nem ruup wel wia wesaupök kaalak waisa. Irikor ëaupök kaalak orö yarë.’ Pël mëak pit ërëpsawi ëa. ");
INSERT INTO wer_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Wëën yokot kaöap pi yaak wakaim olëak kaalak wais kaat temanöm yewasem kat wiin intö ngönre tanre pöt yeëa. ");
INSERT INTO wer_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Pël ëën inëën ru nampön maan sëën, ‘Tol ëënak ya?’ pël mëak pëël mëëa. ");
INSERT INTO wer_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Pël maan puuk epël mëëa. ‘Nim nangap kaalak waisa. Pi irikor ëak saupök kaalak wais oröa. Pötaanök arpim pepapök maan purmakaö ru ompyaö mësëpringëp möak ar ëak yen.’ ");
INSERT INTO wer_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Pël maan pi kölöp ëak kakaati sëpnaaten kaaö ëa. Pël ëën pepapök wais wiap wesak ngön ök mëëa. ");
INSERT INTO wer_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Pël ëën pi kangiir epël mëëa. ‘Kat wi. Ne krismaki selap pan nim naë pas ya mëneimeë nim ngön nent wa noolaan ëaut. Pël ëën ni pol meme ru namp nem karuröaring ërëpsawi ëëmaan nenangkën ëaupök ");
INSERT INTO wer_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","nim ru pipmor pi öng paspas yaauröaan nim omnant pout won wes olëak kaalak waisën ni pimëënökëër purmakaö ru ompyaö mësëpringëp yamöön.’ ");
INSERT INTO wer_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Pël maan pepapök epël mëëa. ‘Yokot epop, ni kët ël epotë tepër wëaup. Pötaanök nem omnant epot pout nimot. ");
INSERT INTO wer_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ën nim nang epop wel wia wesaupök kaalak waisa. Irikor ëaupök kaalak orö yarë. Pötaanök tiar pimëën ërëpsawi ëën pangk yaë.’” ");
INSERT INTO wer_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesuuk pim ruuröen ngönaak nent epël ök mëëa. “Omën omp ak namp pim inëën ru omnant ngarangk yaaö namp wëa. Pël ëën wë akun nentak omnaröak omp aköpön epël mëëa. ‘Nim omnant ngarangk yaaup pi nimot köntak pentak yaë,’ pël mëëa. ");
INSERT INTO wer_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Pël maan kat wiak omnant ngarangk yaaupön yas mëak epël mëëa. ‘Ni tol yaëën omnarö nimëën yaan kat yawi? Pöta songönte iteempaan nem omnant nim ngarangk yaën pötë pepewer wak wais nan. Ke pilëpök nem omnant ngarangk naëngan.’ ");
INSERT INTO wer_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Pël maan inëën ru omnant ngarangk yaaup pim könöök epël wesa. ‘Nem kaöapök nem omnant ngarangk yaauten nga neak wes nemëën tol ëëm? Ne yang kelumaata weëre kosang won. Ën sumatön kimang memaatenta ëö yaë. ");
INSERT INTO wer_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Peenök nem ëëmaaten kön yokoir. Pël ëëma pötak nem kaöapök wes nemëën pöt kaamök elmëëmaaröa naë sëën sant elnëëpnaat.’ ");
INSERT INTO wer_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Pël kön wiak omën pim kaöapë naë kangut wieëauröen ngön maan pöppöp waisa. Pël ëën wet rëak waisaupön pëël mëëa. ‘Nem kaöapë kangut nim naë tolëël wia?’ ");
INSERT INTO wer_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Maan pi epël mëëa. ‘Kolap tram 100,’ pël mëëa. Pël maan ngarangkëpök pep nent menak epël mëëa. ‘Nim pep eptak 100 pöt kërëak 50 retëng ë.’ ");
INSERT INTO wer_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Pël mëak nampön pëël mëëa. ‘Nim naë nem kaöapë kangut tolëël wia?’ Pël maan puuk epël mëëa. ‘Rais kër 100,’ pël mëëa. Pël maan pep nent menak epël mëëa. ‘Ni eptak 100 pöt kërëak 80 retëng ë,’ pël mëëa. ");
INSERT INTO wer_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Pël ëën kaöap pi ngarangk utpet pöpë ëwat ëa pöten itenak piin ping wesak mëëa. Pöt tol ëënak? Omën yangerakë omnantön kentre kaur yaaurö pit pitëm omnant ngarangk ëëpënëak pitëm ëwat pöt omën Anutuu ëwaatak wë pöröa ëwatöt il yewas. ");
INSERT INTO wer_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Pötaanök ne niamaan. Ar tapël monere uröm omën pasut omnarö menak ngöntre kar rëak önë pötak omën pas pöt pet irën Anutuuk yas niaan wëwë kosangta kaatak së önëët. ");
INSERT INTO wer_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ën namp pi omën pasut ompyaö wesak ngarangk ëëpna pöp omën ompyautta tapël ompyaö wesak ngarangk ëëpnaat. Ën namp omën pasut ompyaö wesak ngarangk naën ëëpna pöp omën ompyautta tapël ompyaö wesak ngarangk naën ëëpnaat. ");
INSERT INTO wer_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ar yangerakë monere uröm pasut ompyaö wesak ngarangk naën yaëën talëpök omën këët arök ngarangk ëënëën nimpën? ");
INSERT INTO wer_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ar omnaröaat yaam ninaut ompyaö wesak ngarangk naën yaëën Anutuu yaö niia pöt naningkën ëëpnaat. ");
INSERT INTO wer_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Inëën ru kopëtapök kaö naarë inëën naëpan. Pi nampön kaaö yaalmëem nampön ngöntre kar elmëëpnaat. Won ëën pöt, nampë naë rë olëak wë namp kasëng mampnaat. Pötaanök arta tapël Anutuu yaatere monere uröma yaat mëngkre mëngk namëngkan.” ");
INSERT INTO wer_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Yesu pi ngön pöt maan Parisi omnarö pit monere urömen kent yaaurö yak kat wiak ökre was mëëa. ");
INSERT INTO wer_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Pël yemaan Yesuuk epël mëëa. “Arimtok arimtën omnaröa itöök ping wesak yaaurö. Pël ëaap Anutuuk arim lupötë ityaangk. Omnaröak ompyaut pël yewas pipot Anutuuk itaangkën kömkëënring yaë. ");
INSERT INTO wer_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Moses pim ngön kosangötre tektek ngönöt im wais Son pim naë oröak pet ira. Ën Sonë naëaan wais peene wë epëtak pöt Anutu pim wa ngaöök nimëak wë pöta ngön ompyaut yaan omën pourö kat wiak pötak ilapënëak weë yengenti. ");
INSERT INTO wer_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Wë ënëmak kutömre yang epraar won sëpënëak pöt yok pangk won sëpnaat. Ën ngön kosang pöt nent won nasëpan, pout om wiaapnaat. ");
INSERT INTO wer_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Omp namp pi pim öngöp wes mëak munt namp öpna pöp pi öngre omp wëwëet kom ëak saun koirëpnaat. Ën namp pi munt nampë öng wes mëaup öpna pöp pi öngre omp wëwëet kom ëak saun koirëpnaat.” ");
INSERT INTO wer_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Mon omën namp wakaima. Pël ëaup pi akun poutë ulpëën retëngretëng ëa ompyaut mëak wë kaömp ompyaut neim wakaima. ");
INSERT INTO wer_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Pël ëën omën elek yaaö namp wëa yapinte Lasaras. Pöp koröp pouuk ëmpöl pep saup pi mon omnampë kaata kanra naë wëën ");
INSERT INTO wer_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","mon omën pöp kaömp yenën lupöt ngentiin wa nëmpënëak kön wieim wëaakë yeëa. Pël yaëën kentöröak wais pim ëmpölöt öngör neim yeëa. ");
INSERT INTO wer_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Pël ëën wë elek yaaö omën pöp wel wiin enselöröak koirak së Apramë naë moulmëa. Pël ëën wë mon omën pöpta wel wiin yang kel weera. ");
INSERT INTO wer_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Pël ëën pi es parëaöök së wë këlangön kaö kat yawiem ool itaangkën Apram maimerek wëën Lasaras pim naë wëa. ");
INSERT INTO wer_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Pël ëën mon omën pöpök Apramön ngön ëak epël mëëa. ‘Pep, ni neen yaköm kön wiak Lasaras wes mëën wais pim mor wotö iitak wariak nem yangapöök wa nemëën kot nent ëp sëp. Ne esuwesi öngpök wë këlangön kaö kat yawi.’ ");
INSERT INTO wer_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Pël maan Apramök epël mëëa. ‘Nem ruup, ni kön wi. Ni ngaan yangerak wë omën ompyaut ëeim wëën Lasaras pi pöt utpetat pëën eima. Pötaanök peene pöt pi kak eprek wais ya kë sak wëën ni kangiir këlangön kat yawiin. ");
INSERT INTO wer_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Pël ëaap Anutuuk tiarim tekrak parë naö wiau wia. Pötaanök eprekaanörö pipël yeiraan pirekaanörö epël yaaprën pël naëngan.’ ");
INSERT INTO wer_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Pël maan mon omnampök epël mëëa. ‘Pep, ne kosang wesak ök yeniak. Ni Lasaras wes mëën nemoröa naë sëp. ");
INSERT INTO wer_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Nem nangarö mor nas wë. Pötaanök Lasaras pi së pitta eprek wais këlangön kat wiipanëën nga map.’ ");
INSERT INTO wer_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Pël maan Apramök epël mëëa. ‘Won. Pit Mosesre tektek ngön yaauröa ngön pitëm naë wia pipot kat wiip.’ ");
INSERT INTO wer_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Maan mon omnampök epël mëëa. ‘Apram nem pepap, pöt pangk naëpan. Omën wel wiaö nampök weletakaan wal ëak së ngön ök mapna pöt pit kat wiak lup kaip tiipnaat.’ ");
INSERT INTO wer_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Pël maan Apramök kaalak epël ök mëëa. ‘Pit Mosesre tektek ngön yaauröa ngönöt wa olapna pöt weletakaanëpök wal ëak së mapna pöteta wa olapnaat.’” ");
INSERT INTO wer_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesuuk pim ruuröen ngön nent epël ök mëëa. “Morök ke nentere nent oröön omnarö saun koirëpnaat. Pël ëaap omën morök elmëën omnarö saun koirëpna pöp tol ëëpën? Yaköm. ");
INSERT INTO wer_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Omën ke pilëpök runga kotup morök elmëën saun koirpanëën ar kël kaöaö wii ngan ëak omën pöpë mesetak öngö moutak i kaöök moolaan i nak wel wiipna pöt ompyaö. ");
INSERT INTO wer_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ar ngarangk këëkë ëën. Arim kar namp saun yokoirën pöt nga man. Pël ëën pi lup kaip tiin pöt saun pöta kangit ent ë moolan. ");
INSERT INTO wer_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Pël ëën arim kar namp pi kët kopët nenta öngpök akun 7 ëak utpet elniak akun 7 tapël arim naë wais, ‘Ne lup kaip yati,’ pël niaan pöt ar pim saun pötë kangut ent ë moolan.” ");
INSERT INTO wer_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Yesuu ngön yaaö omnarö pit Yesuun epël mëak kimang mëëa. “Ni tenim kön wi kosang yewesaut kaö wes nin.” ");
INSERT INTO wer_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Pël maan Yesuuk epël mëëa. “Ar kön wi kosang yewesa kot panë nent wieëan talte këra kaö epmentën, ‘Ni kaam tiak i kaöökë öngpök së orö,’ pël maan yok pangk kat wiak pël ëëpën.” ");
INSERT INTO wer_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Arim tekrakaan nampë inëën ruupök ya lupöök së yang mëmpën ma polörö ngarangk ëëpën pël ëeim olëak yewaisën yok pangk epël mam ma? ‘Ni kakaati wais kaömp numëën,’ pël mam ma? ");
INSERT INTO wer_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Pël naëpan. Pi epël mapnaat. ‘Ni nem kaömpöt ar elnëëm. Pël ëak poë koröpö mënt wes urak kaömpre iit wak waisën numaan. Pël ëën ënëmak nimtëët ar ëak numëën.’ ");
INSERT INTO wer_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Pi inëën ruup pim ngan rë menaul ëa pötaan yowe mapën ma? Yok pangk pël naëpan. ");
INSERT INTO wer_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Pötaanök arim naë tapël ëëpnaat. Anutuu ya ngön niiaut ë pet irak pöt epël an. ‘Ten inëën ru katkoko yaaurö. Ya ngön niiaut pëën yaaurö,’ pël an.” ");
INSERT INTO wer_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesu Yerusalem kakë sëpënëak Kalili yanger nal, Sameria yanger nal pël ëaan teköök sa. ");
INSERT INTO wer_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Pël ëak së kak nerek oröön omën kësë ëa narö moresiar pörö pit kamtaöök së koirak pëlëër taueë ");
INSERT INTO wer_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ngön ëak epël mëëa. “Yesu, Kaöap, ni tenën yaköm kön wi.” ");
INSERT INTO wer_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Pël maan pi pitën epël mëëa. “Ar së kiri ar yaauröen arim koröpöt pet elmëën pit ar ompyaö san pël apnaat.” Pël maan yesem koröpöt ompyaö sa. ");
INSERT INTO wer_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Pël ëën pitëkaan kopët namp pi pim koröpöön itaangkën ompyaö sa. Pël ëën kaalak së ngön ë olëak Anutuun yaya mëëa. ");
INSERT INTO wer_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Pël ëak Yesuu ingesiarë së tok oriak ë koset yangaak wesirak wë yowe mëëa. Omën pöp Sameria yangerakaanëp. ");
INSERT INTO wer_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Pël ëën Yesuuk epël mëëa. “Omën moresiar ompyaö sauröep 9 pörö tarëk wë? ");
INSERT INTO wer_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Pit kaip tiak së Anutuun yoöre ërëp mapnaaten kön nawiin. Katkoko ëak sëën Sameria yangerakaan omën maim epop pimënt waisa.” ");
INSERT INTO wer_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Pël mëak omën pöpön epël mëëa. “Nimtë kön wi kosang yewesautak ompyaö yesënrek wal ëak së.” ");
INSERT INTO wer_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Parisi ngönën omnaröak Yesuun, “Anutu taan wa ngaöök nimëëpën?” pël mëak pëël mëëa. Maan Yesuuk kangiir epël mëëa. “Anutuu wa ngaöök nimëëpna pöt yoolök pël yaalniin itnaangkan. ");
INSERT INTO wer_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Kat wieë. Anutu pi peene arim tekrak wë wa ngaöök yanimë. Pël yaëën naröak, ‘Anutuu wa ngaöök yanimë pöt e yaarö,’ pël yaan naröak, ‘O ëngk yaarö,’ pël naëpan.” ");
INSERT INTO wer_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Pël mëak ruuröen epël mëëa. “Wë ënëm akun nent temanöm sëën ar këlëlre ngön epël anëët. ‘Omën Këëp yaaröön ten itaampun,’ pël anëëtak yok pangk itnaangkan. ");
INSERT INTO wer_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Pël yaëën akun pötak naröak, ‘Eprek yaaröörek iteneë,’ pël yeniaan naröak, ‘Ëngkrek yaaröörek iteneë,’ pël yeniaan kat wiak pitëm ënëm ëënganok. ");
INSERT INTO wer_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kent tangarët kopëter tar elmëën yang poutë ëwa ë pet yair. Pipta ök Omën Këëp nem waisuma akunetak pël ëëm sa. ");
INSERT INTO wer_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pötaanök omën peene wë eporö kasëng nangkën këëmre këlangön kësang kat wiimaat. ");
INSERT INTO wer_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Noaë akunetak omnaröa ëa pöl Omën Këëp nem waisuma akunetak tapël ëëpnaat. ");
INSERT INTO wer_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Pit iire kaömp në, öngre omp ë, pël ëeim Anutu kasëng menak wëën Noa wangaöök yeilaan i ngaampel oröön omën pourö i nak won sa. ");
INSERT INTO wer_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Lot pim naëëta tapël ëaut. Omnarö iire kaömp në, omnant sumre kap ë, ëmre ya ë, ka ök raö, pël ëeim Anutu kasëng menak wëa. ");
INSERT INTO wer_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Pël ëën Lot pi Sotom kak sëp wesak yesën akun tapëtak kutömweriaan esutre kël es ngaat kopiitë yepel pöl ëën omën pourö won sa. ");
INSERT INTO wer_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Pöta ök omnarö tapël eim wëën Omën Këëp nem tekeri suma akunetak tapël ëëpën sa. ");
INSERT INTO wer_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Akun pötak omën ka tomök öpnaapök kakaati së pim omnant öpan. Ën yaak öpnaapta tapël kaalak kakë sëpan. ");
INSERT INTO wer_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ar Lot pim öngöp Anutuu ngön wa olëak wel wia pöten kön wieë. ");
INSERT INTO wer_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Omën namp pi pim wëwëet keimön ëëpna pöt pim wëwëet kö sëpnaat. Ën namp pim wëwëet këëpöt wasën pöt orö morëëpnaat. ");
INSERT INTO wer_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ne niamaan kat wieë. Akun pötak omën naar rö kan ur kopëtetak ka uraan namp yeweem namp sëp wasumaat. ");
INSERT INTO wer_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Öng naarta kaömp koröp yokoëem wëën namp yeweem namp sëp wasumaat. ");
INSERT INTO wer_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ën omp naar ya lupöök wëën namp yeweem namp sëp wasumaat.” ");
INSERT INTO wer_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Pël maan ruuröak epël mëak pëël mëëa. “Tarëk pël ëëpën?” Maan Yesuuk omën piin kön wi kosang newasën yaauröa këlangön kat wiipnaataan kön wiak watepang ngön nent epël mëëa. “Omnantë söp kampaöök wer moön tuparö wa top yaë.” ");
INSERT INTO wer_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yesuuk pim ruuröen kaaö köpël kimang maim öpënëak watepang ngön nent epël mëëa. ");
INSERT INTO wer_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Kak nerek ngön ë pet yaira namp wëa. Omën pöp pi Anuture omën pouröen kas naën yaaup. ");
INSERT INTO wer_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Kak taprek öng kapir namp wëaup pi kët poutë omën pöpë naë së, ‘Nemëën kööre toköpëën ngön yaatak kaamök elnëëm,’ pël më yeëa. ");
INSERT INTO wer_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Pël ëeimën omën pöp pim lupmeri epël kön wia. ‘Ne Anuture omën pouröen kas naën yaauppe. ");
INSERT INTO wer_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Öng kapir epop ke urak neaim. Pötaanök kaalak wais neaan kaaö kön wiingönëën kaamök elmëëmaat.’” ");
INSERT INTO wer_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Yesu pi ngön pöt mëak kaalak epël mëëa. “Ar ngön ë pet yaira utpetapë ngön ök yeniak epëten kön wieë. ");
INSERT INTO wer_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ën Anutuun tol yewes? Omën pimëën yaö wesaurö kët kanaan rö kanë piin kimang maim wëën kaamök naalmëëpan ma? Ma kat wiak kat nawiin koröp oröak öpën ma? Pël naëpan. ");
INSERT INTO wer_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ne niamaan. Pi teënt kaamök elmëëpnaap. Omën Këëp nem waisuma akun pötak yangerakë omnaröa naë kön wi kosang yewesaut koirum ma won?” ");
INSERT INTO wer_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Omën narö pitëmtok pitëmtën kön wiin wotpilörö pël kön wieë muntaröen wak irëak ya pöröaan Yesuuk watepang ngön nent epël mëëa. ");
INSERT INTO wer_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Omën naar piarip ngönën tup kaöetak së Anutuun ök mapënëak sa. Namp Parisi ngönën omën namp, namp takis yewa namp. ");
INSERT INTO wer_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Pël ëak Parisi omnampök taueë pimtën weseë epël mëëa. ‘O Anutu, ne omën naröa ök wonöp. Pötaanök niin yowe yeniak. Pit këkain ëëre omën utpet nant ë, öngre omp wëwëet utpet wasö pël yaaurö. Ne pitëm ök wonöp. Pël ëak omën takis yewa epopë ök wonöp. ");
INSERT INTO wer_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Pël ëak sant poutë akun nentepar pöteparë kaömp ngës olëak wëaakë yaaup. Pël yeë omnant koirak pöt wa top ëak moresiar wesak nokoliil nent nimëën yaö yaalniaup.’ ");
INSERT INTO wer_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Pël yemaan takis yewa pöp pëlëër taueë kutömweriil itaampnaaten ëö ëën tok oriak epël mëëa. ‘O Anutu, ne saun omnamp. Pötaan yaköm kön newi.’ ");
INSERT INTO wer_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Kat wieë. Takis yewaup pi Anutuuk pim saunatë kangut won wes moolëak piin, ‘Omën wotpilëp,’ pël maan kaalak pim kaatakë sa. Ën Parisi pöp pim saunatë kangut om wiaan sa. Omën namp pimtok pimtën wak isak apna pöp Anutuuk wak irapnaap. Ën namp pimtën kön wiin irapna pöp Anutuuk wak isak mapnaap.” ");
INSERT INTO wer_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Omnarö pit pitëm runga koturö Yesuuk pim mores pitëm rangk mowiak welaköt elmëëpënëak wak yesën pim ruuröak pitën nga mëëa. ");
INSERT INTO wer_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Pël ëën Yesuuk rungaaröen ngön mëak pim ruuröen epël mëëa. “Nga mangan. Wes mëën nem naë waisëp. Ke pilörö Anutuuk wa ngaöök mëëpënëak yaö yema pötaanök. ");
INSERT INTO wer_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ne yaap niamaan. Namp runga kot eporöa Anutuun kön wi kosang yewesa pöl naën ëëpna pöt Anutuu wa ngaöök yamëautak yok pangk neilaan ëëpnaat.” ");
INSERT INTO wer_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ngarangk nampök Yesuun pëlpël mëak epël mëëa. “Rë yanuula ompyaup, ne tol ëak wëwë kosangta yaö sum?” ");
INSERT INTO wer_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Maan Yesuuk epël mëëa. “Tol ëënak neen, ‘Ompyaup,’ pël yenëaan? Anutu kopëtapökëër ompyaup. ");
INSERT INTO wer_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ni ngön kosangöt epël kat yawiaup. ‘Ni öngre omp wëwëet kom ëënganok. Ni omën mëngkanok. Ni këkain ëënganok. Ni omën muntaröen kaar manganok. Ni nim ëlre pepaarë ngön ngar öm.’” ");
INSERT INTO wer_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Maan ngarangkëpök epël mëëa. “Nem kotuukaan pipot ë waiseimaut.” ");
INSERT INTO wer_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Pël maan Yesu pi ngön pöt kat wiak epël mëëa. “Kopët nent wia pöt ëëm. Ni së nim omnant menak sumat wak omën omnant wonörö këëpöt wes man. Pël ëën kutömweri omnant kosangöt orö nirëëpnaan. Pël ëak wais nem ënëm elnë.” ");
INSERT INTO wer_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Pël maan omën pöp pi monere uröm kaö panë wieëaup yak ngön pöt kat wiak ya utpet ëa. ");
INSERT INTO wer_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Pël yaëën Yesu itenak epël mëëa. “Omën monere uröm kaö wieëaurö Anutuu wa ngaöök yamë pötak ilapënëak pomp ë yaë. ");
INSERT INTO wer_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Pol kamel namp wap poë koröp korir yamë pöökë kanöök ilapna pöt kengkën. Ën omën monere uröm kësang wieëauröak Anutuu wa ngaöök yamë pötak ilapna pöt könöm panëët.” ");
INSERT INTO wer_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Pël maan omën ngön pöt kat wia pöröak epël mëëa. “Omën ke pilörö Anutuu wa ngaöök yamëautak neilaan ëëpna pöt omën tolëëlëpök wëwë kosangët öpën?” ");
INSERT INTO wer_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Maan Yesuuk epël mëëa. “Omnaröak omnant pangk naën ëënë pipot Anutuuk yok pangk ëëpnaat.” ");
INSERT INTO wer_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pël maan Pitaak epël mëëa. “Kat wi. Ten omnant pout sëp wesak nim ënëm elniaut.” ");
INSERT INTO wer_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Maan Yesuuk kangiir epël mëëa. “Ne yaap niamaan. Namp pi Anutu wa ngaöök yamëauta yaat mëmpënëak pim kaare öngre ru, sasre nan, ëlre pep pörö sëp wasëpna pöt ");
INSERT INTO wer_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","pi peene akun epöök kangut selap wak wë ënëm akunaöök wëwë kosangët öpnaap.” ");
INSERT INTO wer_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu pi pim ruurö wa top elmëak epël mëëa. “Kat wieë. Tiar Yerusalem kakë yewais. Pël ëën Omën Këëp nemëën tektek ngön yaauröak ngön epël retëng ëa pöt kë rapnaat. ");
INSERT INTO wer_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Pit ne newak ngönën köpëlöröa moresi neulëën pitök ökre was neak utpet newesak waasöp ngës nampnaat. ");
INSERT INTO wer_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Pël ëak pës nemöak mën wel newiin akun nentepar nent yangaöök wieë kaalak wal ëëmaap.” ");
INSERT INTO wer_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Pël maan ngön pöta songönte ilëëp ilaan pit ëngk ma e wesak ëwat nasën ëa. ");
INSERT INTO wer_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesu pi yesem Yeriko kak temanöm së itaangkën omën it il tëa namp kan ëöök wel aisëeë monatön kimang maim wëa. ");
INSERT INTO wer_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Pël ëak pi kat wiin omnarö yesem yaan omën muntaröen epël mëëa. “Pit tol yaë?” ");
INSERT INTO wer_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Maan pitök epël mëëa. “Yesu Nasaretëpök yewais.” ");
INSERT INTO wer_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Pël maan pi ngön ëak epël mëëa. “Yesu, Tewitë ëap, ni neen yaköm kön newi.” ");
INSERT INTO wer_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Pël yemaan omën wet rëak yesauröak leng ëëpën mëak nga yemaan pöten kat nemowiin ke urak kaalak ngön ëak epël mëëa. “Ni Tewitë ëapök, neen yaköm kön newi.” ");
INSERT INTO wer_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Pël maan Yesu pi leng ëak kamtaöök taprek taueë epël mëëa. “Nem ngësël wak waiseë.” Maan mësak sëën piin epël mëak pëël mëëa. ");
INSERT INTO wer_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Nook ni tol elniimëak yaan?” Maan puuk epël mëëa. “Aköp, ni aan ne it nga sum.” ");
INSERT INTO wer_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Pël maan Yesuuk epël mëëa. “It nga së. Nimtë neen kön wi kosang yewesautak ompyaö yesën.” ");
INSERT INTO wer_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Pël yemaan tapëtakëër itöörar nga sëën Yesuu ënëm yesem Anutuun yaya mëëa. Pël yaëën omën pörek wëaurö pöten itenak pitta Anutuun yaya mëëa. ");
INSERT INTO wer_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu pi Yeriko kak së oröak el wesak sëpënëak yaëën ");
INSERT INTO wer_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","kak pörekaan omën takis yewauröa ngarangk namp wëa yapinte Sakias. Pöp pi mon kaö wieëaup. ");
INSERT INTO wer_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Pi Yesuu möönre koröp itaampënëak kent elmëa. Pël ëaap pi omën mëntëp yak omën muntaröak il mowariin pomp ëak itnaangkën ëa. ");
INSERT INTO wer_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Pël ëak wet rëak pöömpö së, “Eprek yewaisën itaampaatak,” pël wesak këra nementë ngaarëk isa. ");
INSERT INTO wer_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Pël ëën Yesuuk pörek së oröak ngaarëk itenak epël mëëa. “Sakias, teënt ira. Ne peene nim kaatak wais ömaat.” ");
INSERT INTO wer_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Pël maan pi ya kë sak këraamentëkaan irë ngentiak Yesu koirak pim kaatakë sa. ");
INSERT INTO wer_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Pël yaëën omën pörek wëaurö pit pöten itenak kaaö mëak epël mëëa. “Pi tol ëënak saun omnampë naë së ilëak wë,” pël mëëa. ");
INSERT INTO wer_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Pël ëën Sakias pi Yesuu naë taueë epël mëëa. “Kaöap, ni kat wi. Nem omnant kom ëak tok nentepar wesak nent omën omnant wonörö mempaat. Pël ëak omnaröen morök elmëak monat waut pötë kangiir peene nook il wesak maim oorek mempaan.” ");
INSERT INTO wer_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Pël maan Yesuuk epël mëëa. “Omën epop niinta Apram pim körööp yak Apram pim ök Anutuun kön wi kosang yewasën. Pötaanök niire nim kaatakörö Anutuuk utpetetakaan yaniö. ");
INSERT INTO wer_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ne Omën Këëpök omën epopë ök Anutuu naëaan kö saurö wa rongan ëak ompyaö mowasumëak waisaup.” ");
INSERT INTO wer_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Yesu pi ngön pöt ök maan omnaröak kön epël wia. “Pi Yerusalem kak temanöm yewasën Anutu peene wa ngaöök nimëëpnaan yaë,” kön pël yewasën Yesuuk itenak yal menak watepang ngön nent epël mëëa. ");
INSERT INTO wer_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“Omp kaö namp yang wali nerak sëën omp ak wes moulmëën wë kaalak waisëpënëak sa. ");
INSERT INTO wer_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Pi sëpënëak yeem pim inëën ru moresiar pöröen yas maan waisën mon 20 kina, 20 kina pël pangkpangk menak epël mëëa. ‘Ar mon epot wak ya mënak kaö wes wiak wëën waisumaat.’ ");
INSERT INTO wer_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Pël mëak yesën pim kaatak narö kaaö ëak piin epël mapënëak omën narö pim ënëm wes mëëa. ‘Ten nuuk omp ak sak ngarangk elniimëëten kaaö.’ ");
INSERT INTO wer_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pël maan pi së wëën pit pi omp ak wes moulmëën wakaim olëak kaalak waisa. Pël ëak inëën ru mon menak sa pöröen ngön ëak epël mëëa. ‘Ar nem mon ninak san pötök ya mëngkën muntat tolëël koirak wë pöten itaampaan.’ ");
INSERT INTO wer_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Pël maan nampök wet rëak wais epël mëëa. ‘Kaöap, ne nim mon 20 kina nangkën pötak nook ya mëngkën 200 kina pël oröa.’ ");
INSERT INTO wer_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Pël maan epël mëëa. ‘Inëën ru ompyaup, ni ya ompyaö mënan. Ni omën pasut ompyaö wesak ngarangk ëan. Pötaanök nook ka moresiar pötë ngarangk niulëëmaan.’ ");
INSERT INTO wer_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Pël ëën inëën ru munt nampök wais epël mëëa. ‘Kaöap, ne nim mon 20 kina nangkën pötak nook ya mëngkën 100 kina pël oröa.’ ");
INSERT INTO wer_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Maan omp aköpök epël mëëa. ‘Nook, ni ka mor nas pötë ngarangk niulëëmaan.’ ");
INSERT INTO wer_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Pël maan inëën ru munt nampök wais epël mëëa. ‘Kaöap, nim mon 20 kina nangkën pöt e wia. Ne poë koröp kautak kör koë wiak wakaimaut e wia. ");
INSERT INTO wer_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ne niin itaangkën ni nga yaaup yak muntaröa naëaan omnant yewaup. Ni omnant omën muntaröak ngëntën yewetaup. Pötaanök niin kas ëak kö sëpanëak poë koröp kautak kör koë wiak wakaimaut.’ ");
INSERT INTO wer_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Maan omp aköpök epël ök mëëa. ‘Ni inëën ru utpetap. Nimtë ngön yaan taptak nimënt utpet ëaup pël yeniak. Ni neen, “Nga yaaup yak muntaröa naëaan omnant wëëre omnant omën muntaröak ngëntën watö pël yaaup,” pël yenëaan pöt yaap. ");
INSERT INTO wer_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ni nem songönte pipël ëwat wëak tol ëënak nem monet mon kaatak nawiin ëaup? Pël ëanëën ne wais kangitaring wan tapön.’ ");
INSERT INTO wer_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Pël mëak omën pörek wëauröen epël mëëa. ‘Ar mon 20 kina epët piikaan wa ëp ëak 200 kina wa epop meneë.’ ");
INSERT INTO wer_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Pël maan pit epël mëëa. ‘Kaöap, pi yok 200 kina waap.’ ");
INSERT INTO wer_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Maan puuk epël mëëa. ‘Ne niamaan kat wieë. Namp pi omnant menaut ngarangk ëak wëën pöt munt nant erën wes mempaat. Ën namp pi menaut ngarangk naën tapët wak wëën pöt wa ëp ëën om pas öpnaat. ");
INSERT INTO wer_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Peene pöt, nem kööre tokörö nook pitëm omp ak sumaaten kaaö ëa pörö mësak wais nem itöök mëngkën wel wiip.’” ");
INSERT INTO wer_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesu pi ngön pöt më pet irak Yerusalem kakël ko wesak wet rëak isa. ");
INSERT INTO wer_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Pël ëak yesem Olip tomök is oröak Petepasiire Petani ka pöteparë temanöm yesem ru naarën epël mëak wet rëak wes momëa. ");
INSERT INTO wer_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Arip ka ëngköök së oröak öngpök së itaangkën pol tongki ru namp omnaröa wel naisaanëp wii ngan ë ulmëën öpna pipop wilak mësak waisën. ");
INSERT INTO wer_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Arip së pël yaëën omën nampök aripön, ‘Oröp ëënëak yawil?’ pëël yeniaan pöt epël man. ‘Aköpök epopön ya.’” ");
INSERT INTO wer_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Pël maan piarip së itaangkën Yesuu mëëa pöl ëeëa. ");
INSERT INTO wer_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Pël ëën itenak yawilën tongkiipë peparöak itenak epël mëëa. “Arip oröp ëënëak yawil?” ");
INSERT INTO wer_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Maan piaripök mëëa. “Aköpök epopön yaanak yeë.” ");
INSERT INTO wer_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Pël mëak Yesuu naë mësak së tongkiipë rangk pitëm ulpëënöt përë mourak Yesu wa ngaarëk moulmëa. ");
INSERT INTO wer_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Pël ëën wel aisëak yesën ulpëënöt përëak kamtaöök mourö sa. ");
INSERT INTO wer_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Pël ëën Olip tomökaan ngemë Yerusalem kak temanöm yewasën omën pimëën saö rongan pötak wëauröak pim ya it ngolöpöt yaaö pötëën ngön ëak epël maö Anutuun yoöre ërëp mëëa. ");
INSERT INTO wer_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Yowe. Omën omp aköp Aköpë këm ngöntak yewais epopön yaya mepa. Kutömweri mayaap wiaap. Anutu Ngaarëkëp pim yapinte wak isak mepa.” ");
INSERT INTO wer_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ëlak wiak pël yemaan Parisi omën narö pitëm öngpök wëauröak Yesuun epël mëëa. “Rë yanuulaup, nim ruuröen pël epan ma.” ");
INSERT INTO wer_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Pël maan Yesuuk mëëa. “Ne niamaan kat wieë. Pit yaya yenëa pöt ompyaö ya. Leng ëëpna pöt kël epotök yaya neapnaat.” ");
INSERT INTO wer_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesu pi pël mëak yesem Yerusalem kaöökë tomök së oröak kakën itenak yaköm ëën ing yeem epël mëëa. ");
INSERT INTO wer_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“Yerusalem wëaurö, ar peene eptakëër mayaap önë kanöön ëwat wë talte yok pangk ön. Pël ëaap kan pö ëlëëp wia. Pötaanök itnaangkën yeë. ");
INSERT INTO wer_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Kat wieë. Wë akun nentak arim kööre toköröak wais taap elniak ëm ket ëak kaö poutë il niwariipnaat. ");
INSERT INTO wer_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Pël ëak arimëntre arim ruurö pourö won niwesak arim kaat töölak wapötta ti olaan ur kosat wiaapnaat. Pöt tol ëënak? Anutuuk kaamök elniipënëak wes nemëën arim ngësë yewaisën köpël ëak kaaö ëan. Pötaanök pël elniipnaat.” ");
INSERT INTO wer_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesu pi ngön pöt më pet irak ngönën tup kaöeta kakaati së itaangkën omnarö omnant ngawi yeem wëën itenak pit waö ë yemomëem epël mëëa. ");
INSERT INTO wer_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","“Ngönën pepeweri Anutuuk epël ëa. ‘Nem ka pipët kimang yenëa kaat pël ëëpnaat.’ Ar pipël yaëën këkain yaauröa kaata ök yes.” ");
INSERT INTO wer_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Pël ëak pi akun poutë ngönën tup kaöetak së omnaröen ngönën ök maim wëën kiri ar yaaö kaöaröere ngön kosangötë ngarangköröere omën kaöarö pit mëmpënëak kanten ngaöl ëa. ");
INSERT INTO wer_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Omën pourö pim ngönëntaan pim naë rë olëak wëën sëp wesa. ");
INSERT INTO wer_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Kët nentak Yesu pi ngönën tup kaöetak së omnaröen ngönën ök maim wëën kiri ar yaaö kaöaröere ngön kosangötë ngarangköröere kaöarö pit së epël mëëa. ");
INSERT INTO wer_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","“Nim eprek ë yaën pipot talëpë këm ngöntak ëeimën? Talëpök pël ëëm niia?” ");
INSERT INTO wer_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Pël maan Yesuuk kangiir pitën epël mëëa. “Nookta arën kangiir nent pëël niamaatak ök nean. ");
INSERT INTO wer_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Sonë i mëeima pöt talëpök maan eima. Anutuuk ma pimtok kön wiak eima?” ");
INSERT INTO wer_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Pël maan pitëmënt neneren epël mëëa. “Tiar tol mapen? ‘Anutuuk,’ pël mepenaatep pi epël niepan. ‘Tol ëënak Sonë ngönten kön wi kosang newasën yeë?’ ");
INSERT INTO wer_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ën, ‘Son pimtok,’ pël mepenaatep omnarö pit Sonön. ‘Pi tektek ngön yaaö namp,’ pël weseë kël nimööpan.” ");
INSERT INTO wer_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Pël mëak Yesuun kangiir epël mëëa. “Sonë i mëeima pöta songönten ten köpël.” ");
INSERT INTO wer_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Pël maan Yesuuk epël mëëa. “Nookta ne talëpë këmtak yeëan pöt neniangan.” ");
INSERT INTO wer_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yesu pi ngön pöt ök mëak watepang ngön nent omnaröen epël mëëa. “Omën namp wain ya newer ngënta. Pël ëak ya omnarö ngarangk ëëpënëak moulmëak pimënt yang wali nerek së wakaima. ");
INSERT INTO wer_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Pël ëak wë kë yaaröa akunet temanöm sëën ngarangk moulmëauröak ulöp narö tö mampënëak inëën ru namp wes mëën sa. Së oröön pit möak waö elmëën elek kaalak sa. ");
INSERT INTO wer_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Pël ëën pepapök kaalak munt namp wes mëën sëën pöpta möak utpet mowesak waö elmëën elek tapël sa. ");
INSERT INTO wer_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Pël ëën pepapök kaalak wa ngolöp wesak wes mëën sëën pöpta këlangön kat mowiak ke ur mëën elek sa. ");
INSERT INTO wer_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Pël ëën ya pepap pi epël wesa. ‘Ne tol ëëmete? Nem ru ulöpöököp wes mëëmaan. Pit yok pangk pim ngönte kat wiak ngar öpën koröpok.’ ");
INSERT INTO wer_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pël ëak wes mëën sëën yaakë ngarangkörö piin itenak pitëmënt neneren epël mëëa. ‘Omën epop pim pepapë mor kolut pout öpnaap. Pötaanök mëmpa. Pël ëën yaat tiarimëën sëpnaan.’ ");
INSERT INTO wer_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Pël mëak pit wain yaaweriaan wa wilëngkël moolëak mëna.” Yesu ngön pöt mëak epël pëël mëëa. “Yaaweri pepapök ngarangköröen tol elmëëpën? ");
INSERT INTO wer_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Pi wais ya ngarangk pörö mënak pim ya lupöök ngarangk ompyaö narö moulmëëpnaat.” Pël maan pit ngön pöt kat wiak epël mëëa. “Won. Pël ëëpan.” ");
INSERT INTO wer_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Pël yaan Yesu pi pitën iteneë epël mëëa. “Ngönën pepeweri ngön nemëën epël wia pöt tol nentaanök? ‘Wap omën ka ök yarëauröak wël ë moolëaut Anutuuk ompyaut wesak möör wap wes yewesir.’ ");
INSERT INTO wer_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Omën namp wap epëtak söë urak kawi ngentiipnaap pi koröp ilak utpet ëëpnaap. Ën wapëtak pim rangk ngentiipna pöt omën pöp ilak unön ëak utpet panë sëpnaap.” ");
INSERT INTO wer_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Pël maan ngön kosangötë ngarangköröere kiri ar yaaö kaöarö pit Yesu pim wain ya ngarangk utpetaröaan watepang ngön mëëa pöt pitëmël ko wesak yemaan kat wiak mor öpënëak ëakök omnaröen kas ëën sëp wesa. ");
INSERT INTO wer_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Pël ëak Yesu moröak Rom yang ngarangkëpë moresi moulmëëpënëak it wawaö ëeim wëa. Pël ëeë omën narö wes mëën Yesuu naë së ngönën kat yawia koröp oröak wë ngön nent maan pöt öpnaat weseë Yesuun morök elmëak epël mëëa. ");
INSERT INTO wer_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","“Rë yanuulaup, ten niin ëwat wë. Ni ngön wotpil yaaup, omnaröenta wotpil wesak ök yeniiaup. Ni omën isaare irëaurö omnant mööngkraar kangk naalmëën yaaup, omën ompyaut pëën Anutuuk ök niiaut omën pourö yaap wesak rë yanuulaup. ");
INSERT INTO wer_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Pötaanök ni kön wiin Rom omp aköp Sisa takis mampen ma Anutu pimënt mampen?” ");
INSERT INTO wer_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Pël maan pitëm morök yaalmëa pöten itenak epël mëëa. ");
INSERT INTO wer_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Mon kël nent koirak neneë. Könre yapin epot talëpëët?” Pël maan pit epël mëëa. “Sisaëët.” ");
INSERT INTO wer_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Pël maan puuk epël mëëa. “Omnant Sisaën yaö ëa pipot Sisa mampun. Ën Anutuun yaö ëa pipot Anutu mampun.” ");
INSERT INTO wer_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Pël maan omnaröa itöök pi aan wali öpna nent nokoirën ëa. Pël ëak pit kaip ti mangkën kat wiak yaan sak këm ur wariak wëa. ");
INSERT INTO wer_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Akun nentak Satusi ngönën omën narö Yesuu naë sa. Omën pörö weletakaan wal yaaö pöt won wia pël yaaurö. ");
INSERT INTO wer_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Pit së Yesuun epël mëëa. “Rë yanuulaup, Moses pi tiarimëën ngön kosang nent epël retëng ëaap. ‘Omën namp öng wak ru won wë wel wiin pöt pim nangapök kaalak öng pöp wak wë ru oröön pöt pim nanëpë yaö sëpnaat.’ ");
INSERT INTO wer_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Pël wiaap omën nanang narö 7 ëak wakaima. Pël ëaurö nanëp öng namp wak ru won wë wel wia. ");
INSERT INTO wer_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Pël ëën nang pim rakëp öng tapöp wak wë wel wia. ");
INSERT INTO wer_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Pël ëën ënëmak nang 3 pöpök öng tapöp wak ru won tapël wë wel wia. Pël ëaap omën 7 eporö pit öng kopët tapöp wak ru won wë wel wia. ");
INSERT INTO wer_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Pël ëën ënëmak pitëm öng kapirëpta tapël wel wia. ");
INSERT INTO wer_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Pötaanök omën 7 piporö öng kopët tapöp wauröep wë wal ëëpna akunaöök talëpë öng sëpën?” ");
INSERT INTO wer_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Maan Yesuuk kangiir epël mëëa. “Peene yangerak wë epöök öngre omp yeë. ");
INSERT INTO wer_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ën wë ënëm akun kaöaöök Anutuuk kat mowiin wëwë kosangtak weletakaan wal ë rëëpnaarö pit yok pangk öngre omp naëpan. ");
INSERT INTO wer_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Anutuuk pit weletakaan wal ë moulmëëpnaat. Pötaanök pit pim ru sak enselöröa ök wë kaalak wel nawiipan. ");
INSERT INTO wer_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Weletakaan wal ëëpena pöta ngönte Mosesök ngönën pepeweri retëng ëaut. Këra kotumentëk es wëlëng koteima pöta ngöntak Anutuuk piin epël mëëa. ‘Ne Apramre Aisakre Yakopre pörö pitëm Anutu.’ ");
INSERT INTO wer_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Omën wel wia pourö Anutuuk wëwëetaring wë pël wesa. Pötaanök Anutu pi wel wiauröaap won. Pi omën öp wëauröa Anutu.” ");
INSERT INTO wer_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Pël maan ngön kosangötë ngarangk naröak, “Rë yanuulaup, ni aan ompyaö yes,” pël mëëa. ");
INSERT INTO wer_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Pit kaalak pëël mapnaaten kas ëën sëp wesak pipët pëën mëëa. ");
INSERT INTO wer_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Pël ëën Yesu pi epël mëak pëël mëëa. “Tol ëënak, ‘Kristo, Yaö Mëëaupön pi Tewitë körööp’ pël aim? ");
INSERT INTO wer_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Tewit pimtok Sam pep pöweri tan nent epël ëa. ‘Anutu puuk nem Aköpön epël yema. “Ni wais nem yaapkëëtakël öm. ");
INSERT INTO wer_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Pël ëaan nimëën kööre tok yaaö piporö nook maan nim weëre kosangöökë karök moulmëëmaat.” ’ ");
INSERT INTO wer_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Tewit pimtok piin, ‘Nem Aköp,’ pël mëëaupök tol ëënak Tewitë ëap pël yaë?” ");
INSERT INTO wer_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Pël mëak Yesu pi omnaröa ëöetak pim ruuröen ngön epël ök mëëa. ");
INSERT INTO wer_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Ar ngön kosangötë ngarangköröa utpetatön ngarangk ëën. Pit ulpëën waliit mëak wa topöök koirak ërëpsawi mapnaaten kent yaaurö. Pël ëak ngönën tupötëëre këëre imën akunatë omën kaöaröa urötë wel aisapnaaten kent yaaurö. ");
INSERT INTO wer_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Pit pël yeem öng kapiröröa omnant pout pitëmëën weimeë morök elmëak omnaröak pitën kön wiin isëpënëak Anutuun kimang wali yamëëaurö. Omën ke pilörö pit wë kangiir akunetak könöm kësangöt koirëpnaat.” ");
INSERT INTO wer_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesu pi ngönën tup kaöetak wë we riak itaangkën omën monaringörö pit Anutuun monat kiri yawia. ");
INSERT INTO wer_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Pël yaëën Yesu pi itaangkën öng kapir omnant won nampta pim mon kot köp möa nentepar wia. ");
INSERT INTO wer_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Pël yaëën Yesuuk itenak epël mëëa. “Ne yaap niamaan. Öng kapir omnant won epopë mon yawi epëtak omën muntaröaat il yemowas. ");
INSERT INTO wer_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Omën monaringörö pit ëlöt wiaan kopëtetepar yawi. Ën öng kapir epop pi omnant wonöpök pim wieëaut wiak won pan wesak wë.” ");
INSERT INTO wer_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Yesu pim ru narö pit ngönën tup kaöetak këlöt retëng ke nalre nal ëak ök rëeëa pötön itenak aöre mon Anutuun kiri mowia pötë ngönöt aö pël ëeim wëën Yesuuk epël mëëa. ");
INSERT INTO wer_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Wë akun nent temanöm sëën omën ityaangk epot epël wi naöpan. Ënëmak ngaaröak wais tööl olaan kël naö naöökë rangk wi naöpan, utpet panë sëpnaat.” ");
INSERT INTO wer_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Pël maan pit epël mëak pëël mëëa. “Rë yanuulaup, nim yaan pöt akun taltak orööpën? Akun pöt temanöm yesën oröpöt oröön ten itenak ëwat sën?” ");
INSERT INTO wer_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Pël maan Yesuuk epël mëëa. “Ar omnaröak lup wa irikor elniipanëën këëkë ngarangk ëën. Pit morök elniak naröak nem yapintak wais, ‘Ne Kristo,’ pël aöre naröak, ‘Kristo pim orööpna akunet yok temanöm yes,’ pël yeniaan pitëm ënëm elmëënganok. ");
INSERT INTO wer_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ar nga yapinte kat wiak kas ëëngan. Akun kaöaö ngolöp yaëën omën pipot wet rëak orööpnaat.” ");
INSERT INTO wer_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Pël mëak yal menak epël mëëa. “Omën kur nementëkaanöröak kur nementëkël nga ëëpnaat. Ën yang omp ak nampë omnaröak nampëëröaan nga ëëpnaat. ");
INSERT INTO wer_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Pël yaëën moup kësang pan yangerak mööpnaat. Pël ëak yang we nantë këënre yauman kaöat orööpnaat. Pël yaëën mopöök oorek omën retëng ke nentere nent yaaröön ar kas ëënëët. ");
INSERT INTO wer_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Omën pöt naaröön wiaan pit wet rëak wa niulëak këlangön kat niwiipnaat. Pël ëak ngön kaatë së niulëak wii kaatë niulëëpnaat. Pël ëak omën omp akre yang ngarangköröa naë niulëëpnaat. Ar nem yapinte wak wë pötaanök pël elniipnaat. ");
INSERT INTO wer_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Akun pötak ar nem songönten ök manëët. ");
INSERT INTO wer_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ar epël kön kosang wiaan. Ar wa nanuulëën wiaan tol man pël ëak kön selap ëënganok. ");
INSERT INTO wer_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Nemtok arim këmötë ngön anëëtë wetetöt nimpaat. Pël ëak ompyaö elniin kööre tokörö arim ngönöt wak irëak ke ur noolepan. ");
INSERT INTO wer_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Arim ëlre pep, sasre nan, ngöntre kar, pöröak arim kööre toköröen kup mowiin arim tekrakaan narö nimpënaat. ");
INSERT INTO wer_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Pël ëak nem yapinte wak wë pötaan omën pourö ya sangën ëak kööre tok elniipnaat. ");
INSERT INTO wer_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Nook ngarangk elniak wëën ar kö nasëngan pan, arim ngan ëp naööta mop nerapan. ");
INSERT INTO wer_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Weëre kosangring wakaim olëak wëwë kosangët önëët.” ");
INSERT INTO wer_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Ar itaangkën ngaarö Yerusalem kaö taap yawiin pöt ka töölak utpet wasëpna akunet temanöm yes pël wasënëët. ");
INSERT INTO wer_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Pël ëak Yutia yangerak wëaurö ar kas rosiraöökël sën. Yerusalem kak wëaurö ar kaö sëp wasën. Ën yang nantë wëaurö ka kaöaöökël sëngan. ");
INSERT INTO wer_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ngönëntak retëng ëa pöt kë rapnaan Anutuuk akun piptak kangut wes mëën orööpnaat. ");
INSERT INTO wer_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Elei, öng ru kepringöröere ru kapa yemenaurö, tol ëënëërö? Akun pötak Anutuuk omnaröen ya sangën elmëën yangerakë omnarö këlangön kaö panë kat wiipnaat. ");
INSERT INTO wer_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ngaaröak narö öp wesir olapnaat, narö moröak wii tëak wak pitëm kaatë së inëën wesak ulmëak öpnaat. Pël ëak ngönën köpëlörö pit Yerusalem kaö utpet weseim wëën Anutu pimtë akun mampna pötak sëak pet irëpnaat.” ");
INSERT INTO wer_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Këtre ngoonre ari pötë omën it köpëlöt yaaröön yangerak i kaö maat kësangöt yamöön omnarö kas kaö ëëpnaat. ");
INSERT INTO wer_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Pël yaëën kutömwer ëtëp ëën ariat tiak yesën omnarö yangerak omnant orööpna pötaan kor wë kas kaö panë ëak it köpköp tiak së wiaapnaat. ");
INSERT INTO wer_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Pël yaëën Omën Këëp ne nem weëre kosangre iere kasir nemotring kutöm kepiltak yaaröön itaampnaat. ");
INSERT INTO wer_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Omën ke pöt yaaröön, ‘Anutuuk niöpna akunet temanöm yes,’ pël wesak wal ë taueë we riak itaampun.” ");
INSERT INTO wer_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Pël mëak watepang ngön nent epël mëëa. “Ar këra wasre munt nantön itenak wa weswes ë yeë. ");
INSERT INTO wer_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ar itaangkën kërë sak wil yewatën itenak kopi akunet temanöm yes pël yewas. ");
INSERT INTO wer_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Pöta ök omën yeniak epot yaaröön itenak pöt, ‘Anutu wa ngaöök nimëëpënëak yaë,’ pël wasën. ");
INSERT INTO wer_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ne yaap niamaan. Omën e wë eporö wel wi won nasën wiaan omën yeniak epot orööpnaat. ");
INSERT INTO wer_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Kutömre yang eptepar won sëpnaatepar. Ën nem ngön epët won nasëpan.” ");
INSERT INTO wer_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Ar iire kaömp na olëolë imeë yangerakë omnantëën kön selap pötëën lupre kön arimot wes mëak wëën akun kaöaö kalaapöökë yaë pöl teënt pan niöpanëën ngarangk këëkë ëeimeëak ön. ");
INSERT INTO wer_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Akun kaö pöt yang ël epotë wë eporö ar pouröa naë orö nirëëpnaat. ");
INSERT INTO wer_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Pötaanök ar kët el epotë ngaire wa kom eimeë Anutuun kimang ngaangan maim ön. Pël ëën omën könöm orööpënëak yeniak pöt yaaröön Anutuuk weëre kosang ningkën ing mës ngep ëak Omën Këëp nem ëöetak tauanëët.” ");
INSERT INTO wer_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Akun poutë Yesu pi këtëkötë ngönën tup kaöetak omnaröen ngönën ök maim olëak pöt rö kanötë Olip tomöntak së ka ur pël ëeima. ");
INSERT INTO wer_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Pël ëën omnarö pit ngönën kat wiipënëak wangam kan röökëërötë ngönën tup kaöetak pim naë seima. ");
INSERT INTO wer_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Kaömp peret yis namëënöt yena akun ngëëngkët pitök Anutuuk mait elmëaut pël yamëëa pöt temanöm sa. ");
INSERT INTO wer_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Pël yaëën kiri ar yaaö kaöaröere ngön kosangötë ngarangkörö pit omnaröen kas ëën Yesu ëlëëp mëmpëna kanten ap weseima. ");
INSERT INTO wer_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Pël yaëën Seten pi Yutas Keriot kakaanëp pim lupmeri ilëa. Pöp Yesuu ru 12 pöröakaanëp. ");
INSERT INTO wer_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Pël ëën kiri ar yaaö kaöaröere ngönën tup kaöeta polisöröa naë së Yesuun kup mowiak pitëm moresi ulmëëpnaata ngönte pitring ëa. ");
INSERT INTO wer_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Pël ëën pit ërëpërëp ëak mon mampnaata ngönte ë kopëta wesa. ");
INSERT INTO wer_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Pël ëën Yutas pi makre ku mëak ngës rëak akun nentak omnarö Yesu ent ë mëën pimënt wëën kup mowiipna kan ap weseima. ");
INSERT INTO wer_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Kaömp peret yis namëënöt yena akun ngëëngktak Anutuu mait elmëautaan kiri sëpsëpörö yamöa akunet temanöm sa. ");
INSERT INTO wer_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Pël ëën Yesuuk Pitaare Sonön epël mëak wes mëëa. “Arip së mait elmëauten kön wiipenaan kaömpöt kopëta wes wiin. Pël ëën ten waisën nëmpenaan.” ");
INSERT INTO wer_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Pël maan piarip epël mëëa. “Ka taltak kopëta wes wiinëak kent kön yawiin?” ");
INSERT INTO wer_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Maan puuk kangiir epël mëëa. “Kat wieë. Arip kak së oröak itaangkën omën namp i kepit wak wëën koirak pöt pim ënëm së ka ilapnaatak ilan. ");
INSERT INTO wer_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Pël ëak ka pepapön epël man. ‘Rë yanuulaupök, “Ne nem ruuröaring ka taltak Anutuuk mait elmëauten kön wiinaan kaömp nën?” pël ya,’ pël man. ");
INSERT INTO wer_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Pël ök maan ka kaö ngaarëk nent urre korumön ëak ompyaö wesauten pet elniin pötak kaömp ar ëak kopëta wasën.” ");
INSERT INTO wer_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Pël maan piarip së mëëaul ëak mait kaömpöt ar ëak kopëta wesa. ");
INSERT INTO wer_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Nëmpna akunetak Yesure pim ngön yaaö omnarö pit kakaati së kaömp yenautak wel aisëak wëa. ");
INSERT INTO wer_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Pël ëak Yesuuk epël ök mëëa. “Nem këlangön kat wiima akunet temanöm yenewas. Pötaanök wet rëak mait kaömp epët arring ngawi numaataan kent pan yaalnë. ");
INSERT INTO wer_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ne yaap niamaan kat wieë. Ne mait kaömp epët kaalak nanën wë Anutuu wa ngaöök nimëëpnaatak kaömp pöta këët tekeri sëën numaat.” ");
INSERT INTO wer_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Pël mëak wain kelön nent wak Anutuun yowe mëak epël mëëa. “Ar epët wak ngawi neë. ");
INSERT INTO wer_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ne niamaan. Yangerak eprek wain iit peene nëën pet yair. Arring kaalak nanën wë ënëmak Anutuuk wa ngaöök nimëak wëën piiring nëmpenen ëa.” ");
INSERT INTO wer_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Pël mëak kaömpöt wak Anutuun yowe mëak pelak epël mëak mena. “Epët nem mësëpët. Ar kaamök elniipnaan këëröt wes nimpaat. Pötaanök nënëël neen kön wieim ön.” ");
INSERT INTO wer_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Kaömp pöt nëën wain kelönte wak tapël ëak epël mëak mena. “Wain i epët sulöp ngolöpta nem iit. Wain i epëtak ne wel yawiem nem iit olama pötaan Anutuu omnaröaring sulöp ngolöp pöt kosang yewas pöt pet yaalni. ");
INSERT INTO wer_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Iteneë. Omën kup newiak kööre toköröa moresi neulëëpnaap neering kaömp ngawi yen. ");
INSERT INTO wer_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Omën Këëp ne pöp nem Pepapë kan yaö neeaöök së wel wiimaap. Ën nemëën kup mowiipna pöp, elei, pi kangut kësang pan öpnaap.” ");
INSERT INTO wer_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Pël maan ngön yaaö omnarö pit, “Talëpök ëëpnaaten ya,” mëak neneren pëël mëëa. ");
INSERT INTO wer_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ruurö pit, “Talëpök tiarim naëaan isak wë,” pël mëak ngön nga ela. ");
INSERT INTO wer_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Pël yaëën Yesuuk epël mëëa. “Yang omp akörö pit omën pitëm iri wëaurö ngarangk elmëeimeë pitök kangiir pitëmëën ping wesak, ‘Kaamök yaaurö,’ pël mapënëak kent yaaurö. ");
INSERT INTO wer_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ar pël ëënganok. Ar pöt, kaöaröak koturöa ök sak ön. Ën wotöököröak inëën yaauröa ök sak ön. ");
INSERT INTO wer_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ma ar aë. Talëpök isa? Wel aisëeë kaömp yen pöpök ma ar ëak korak wais yemangk pöpökëër isa? Wel aisëeë kaömp yen pöpökëër. Pël ëaap ne pöt, arim tekrak wë inëën yaauröa ök koröp oröak wëaup. ");
INSERT INTO wer_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Akun poutë këëmre këlangön pöt nem naë yaaröön ar sëp nenewasën yaaurö. ");
INSERT INTO wer_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Nem Pepapök ar wa ngaöök nimëëmëak wes nemëaut nook ar tapël wa ngaöök momëënëak yeniak. ");
INSERT INTO wer_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ne wa ngaöök nimëak wëën ar neering këëre kaömp ngawi neimeë omp aköröa urötë wel aisëeë Israel kur 12 pötëaanöröa ngönte ë pet irënëët.” ");
INSERT INTO wer_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Saimon, Saimon kat wi. Seten pi raisatë koröp koëak wël yeë pöl ar morök elniipënëak ya. ");
INSERT INTO wer_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pël ëën nook nim kön wi kosang yewesaut won sëpanëak kaamök elniak Anutuun kimang mëëaut. Pötaanök ni ënëmak kaalak kaip tiak pöt nim karurö taë mowasum.” ");
INSERT INTO wer_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pël maan Pitaak epël mëëa. “Aköp, ni weletak ma wii kaatak yesën pöt ne tepër sëpëaap.” ");
INSERT INTO wer_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Maan Yesuuk kangiir epël mëëa. “Pita ne niamaan kat wi. Ni peene röök epëtak kokor ngön naën wiaan akun nentepar nent ëak neen wonwon mamëëp.” ");
INSERT INTO wer_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Pël mëak pim ruuröen epël mëëa. “Ngaan ne ar wes yanimëem, ‘Monere kërre ing körre pöt wak sëngan,’ pël niiaut. Pël ëa akun pötak omën nantön elek ëaurö ma won?” Pël maan pit, “Won,” mëëa. ");
INSERT INTO wer_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Pël maan kaalak epël mëëa. “Peene pöt nga akunaö yaaröön namp monet wiaan pöt pangk waap. Ën namp kërëëp wiaan pöt yok pangk wetaap. Ën namp öpwer won ëën pöt ulpëën rangkëp përë omnamp mangkën öpwer kangiir mamp. ");
INSERT INTO wer_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ne niamaan kat wieë. Ngönën pepeweri ngön epël ëa pöt nem naë kë orööpnaan yaë. ‘Pit pi utpetap wesak utpetaröa öngpök moulmëaup.’ Ngön nemëën retëng ëa pipot kë orööpnaat.” ");
INSERT INTO wer_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Maan ruuröak epël mëëa. “Kaöap, ni itan. Ten öp neweriar wia.” Pël maan Yesuuk epël mëëa. “Ngönte sëp weseë.” ");
INSERT INTO wer_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Pël mëak wë olëak kakaan oröak pim ë yaaul Olip tomöntakël yesën ruurö ënëm sa. ");
INSERT INTO wer_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Pël ëak së oröön Yesuuk ruuröen epël mëëa. “Ar moröktak wiap sënganëën kimang maë.” ");
INSERT INTO wer_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Pël mëak këlötë mööna yaë pöl ëak së rar rë wesirak Anutuun kimang epël mëëa. ");
INSERT INTO wer_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Pep ni kat wiin pangk ëën pöt këlangön nem naë orööpënëak yaë epot keker elnëëp. Nem könöök won, nim kentöökë wiaul ëëm.” ");
INSERT INTO wer_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Pël yemaan kutömweriaan ensel namp irë pim naë oröak kosang mowesa. ");
INSERT INTO wer_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Pël ëën Yesu pi lupmer këlangönring wë ke urak kimang yemaan köömöt omën iitë ök sak oröak yangaak il ngentia. ");
INSERT INTO wer_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Kimang më pet irak wal ëak së pim ruuröen itaangkën pit piin yaköm pan ëën ka uraan ");
INSERT INTO wer_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","epël mëëa. “Ar tol ëënak ka ureim? Moröktak wiap sënganëën wal ëak Anutuun kimang maë.” ");
INSERT INTO wer_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Pël yamëem wëën omën kësang pan pim naë oröa. Pël ëak pim ru 12 pöröakaan namp Yutas pöp Yesu tot nëmpënëak pim naë sa. ");
INSERT INTO wer_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Pël ëën Yesuuk epël mëëa. “Yutas, ni Omën Këëp neen kup mowiin nempëna pötaan tot yenenën ma?” ");
INSERT INTO wer_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Pël ëën pim ruurö pit omën orööpënëak yaaö pöten itenak piin epël mëëa. “Aköp, ten öp möön ma?” ");
INSERT INTO wer_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Pël mëak pitëm naëaan nampök kiri ar yaaö wotöököpë inëën ru namp möak pim kat yaapkëëp per olëa. ");
INSERT INTO wer_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Pël ëën Yesuuk itenak epël mëëa. “Ar sëp weseë.” Pël mëak omën pöpë katëëp moröak ompyaö mowesa. ");
INSERT INTO wer_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Pël ëak Yesu kiri ar yaaö kaöaröere ngönën tup kaöeta polisöröere kaöarö pi öpënëak sa pöröen itenak epël mëëa. “Ar neen ngaap wesak wali neönëak inre tang wak yewais ma? ");
INSERT INTO wer_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ne kët ël epotë ngönën tup kaöetak arring wëaup. Pël ëën ar akun pötë neneön ëaurö. Pël ëaap peene akun epët arim akunet. Akun eptak kouta weëre kosangët tekeri yaarö.” ");
INSERT INTO wer_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Pël maan pit Yesu wali wak kiri ar yaaö wotöököpë kaatakë sa. Pël ëën Pita pi ënëmënëm sa. ");
INSERT INTO wer_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Pël ëak itaangkën ngaarö ëmöökë kakaati së ilëak ka tomök es merak mor yesem wëën Pita pi pitëm tekrak së wel aisëa. ");
INSERT INTO wer_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Pël ëak es ëwaöök wel aisëaan inëën koont nampök piin itneë epël mëëa. “Omën epopta Yesuring wëaup.” ");
INSERT INTO wer_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pël maan Pitaak wonwon mëak epël mëëa. “Koont epop, ne piin köpëlëp.” ");
INSERT INTO wer_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Pël mëak kot nent wëwë yaëën kaalak omën nampök piin itenak epël mëëa. “Niinta pitëkaan nampok.” Pël maan Pitaak epël mëëa. “Omp epop, ne wonöp.” ");
INSERT INTO wer_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Pël mëak wë ngöpngöp yaëën kaalak omën munt nampök kosang wesak mëëa. “Yaap, omën epopta Yesuring wëaup. Pi Kalili omnamp.” ");
INSERT INTO wer_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Maan Pitaak mëëa. “Omp epop, ne nim ngön yaan pipten ëngk ma e yewas.” Pël maötaring kokor ngön ëa. ");
INSERT INTO wer_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Pël ëën Aköp kaip ti Pitaan itena. Pël ëën Pita pi Aköpë ngön epël mëëa pöten kön wia. “Ni peene röök epëtak kokor ngön naën wiaan akun nentepar nent ëak neen wonwon mamëëp.” ");
INSERT INTO wer_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ngön pël mëëa pöten kön wiak ya ilak sëën tomökël së ing kaö pan ëa. ");
INSERT INTO wer_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Yesuu ngarangk wëaurö pit piin ökre was mëak tang momöa. ");
INSERT INTO wer_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Pël ëak itöörarë poë koröpöök kör mokoëak epël mëëa. “Ni tektek ngön yaauppe. Talëpök yanimö?” ");
INSERT INTO wer_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Pël mëak ngön utpetat kësang mëëa. ");
INSERT INTO wer_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ëlpam walën omën kaöarö, kiri ar yaaö kaöaröere ngön kosangötë ngarangkörö, wa top ëak wë maan Yesu mësak pitëm naë sëën epël mëëa. ");
INSERT INTO wer_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Ni tenën ök nia. Ni Yaö Niiaup Kristo tapöp ma?” Pël maan Yesuuk epël mëëa. “Ne niamaatep ar kat wiak wa yaap newasngan. ");
INSERT INTO wer_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ën nookta pëël niaan yok pangk ök nenëangan. ");
INSERT INTO wer_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Peene pöt Omën Këëp ne Anutu weëre kosangëp pim yaapkëël wel aisëaama akunet temanöm yes.” ");
INSERT INTO wer_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Maan pit pouröak epël mëëa. “Ni Anutuu Ruup ma?” Pël maan kangiir epël mëëa. “Yok yak pil.” ");
INSERT INTO wer_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Pël maan pit epël mëëa. “Oröpmorëën ngön ya mëmpen? Pimtë këmtakaan yok aan kat yawi.” ");
INSERT INTO wer_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Omën pourö wal ëak Yesu mësak Rom yang ngarangkëp Pailatë naë sa. ");
INSERT INTO wer_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Pël ëak Pailatën ngës rëak epël mëëa. “Tenim itöök omën epmor ten omën pourö morök elnieimeë pi omp ak Sisa takis mangkanëak nga niaimeë pimtok pimtën, ‘Ne Kristo Yaö Neeaup,’ pël aöre ‘Ne omën omp aköp,’ pël yaaumor.” ");
INSERT INTO wer_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pël maan Pailat pi Yesuun pëël mëak epël mëëa. “Ni Yuta omnaröa omën omp aköp ma?” Maan kangiir epël mëëa. “Yok yaan pi tapët.” ");
INSERT INTO wer_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pël maan Pailat pi kiri ar yaaö kaöaröere omnaröen epël mëëa. “Ne omën epopë saun nent nokoirën.” ");
INSERT INTO wer_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Maan pit kosang wesak ke urak epël mëëa. “Pi omnaröen ngön ök mëak lup es nga mowasën Yutia yang pourak akak yes. Pi Kalili yangerak ngës rëak pël ë waisaumorök eprekta tapël yaë.” ");
INSERT INTO wer_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pël maan Pailat pi pöten kat wiak pitën epël mëëa. “Omën epop Kalili yangerakaanëp ma?” ");
INSERT INTO wer_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Maan pit kangiir mëëa. Pël ëën Pailat pi omën omp ak Erot pim yang ngarangk ëeëaurekaanëpök ëa pël wesak akun pötak Erot piita Yerusalem kak wëën yak Yesu wes mëën pim ngësël sa. ");
INSERT INTO wer_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Pël ëën Erot pi Yesuun itenak ërëpërëp ëa. Pöt pi Yesuu yaautön kat yawiem itaampënëak kent kön yawia. Pël ëak pim itöök retëng nent ëën itaampën pël wesak ërëpërëp ëa. ");
INSERT INTO wer_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Pël ëak Yesuun pëël ke nentere nent yemaan Yesu pi ngön kangut nemaan ëa. ");
INSERT INTO wer_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Pël ëën kiri ar yaaö kaöaröere ngön kosangötë ngarangkörö pit pim naë së tauak kosang wesak pi utpet ëa pöt mëëa. ");
INSERT INTO wer_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Pël ëën Erotre pim ngaarö pit piin ököök elmëak ökre was mëëa. Pël ëak ulpëën wali retëngretëng ëa ompyaö namp wa momëak kaalak wes mëën Pailatë ngësë sa. ");
INSERT INTO wer_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Erotre Pailat piarip ngaan pöt nampnampön kööre tok yaauwaarök akun pötak ngöntre kar ëa. ");
INSERT INTO wer_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pailatök maan kiri ar yaaö kaöaröere ngarangköröere omën muntarö wa top ëa. ");
INSERT INTO wer_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Pël ëën epël mëëa. “Ar omën epopön, ‘Pi omnarö wa irikor yaalmëaup,’ pël aö nem naë wak waisan. Pël ëën nook pim songönte tekeri wasëpënëak arim ëöetak pëël mëëaut. Pël ëautak ne piin kat wiin pim utpet yaëën arim ngön yaatak moulmëan pöt nokoirën yeë. ");
INSERT INTO wer_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Erotta tapël ëak kaalak wes mëën waisa. Kat wieë. Omën epop pi utpet tiarim mëmpena nent naën. ");
INSERT INTO wer_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Pötaanök ne maan ngaaröak om tang pëën möak wes mëëpnaat.” ");
INSERT INTO wer_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Krismaki poutë Anutuu mait elmëa akun ngëëngktak Pailatök omën namp wes më yeëa. ");
INSERT INTO wer_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pël maan pit omën pourö ëlak wiak epël mëëa. “Pipmor mëngkën wel wiip. Parapasökëër wes nimë.” ");
INSERT INTO wer_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Parapas pöp kak wë omën naröaring nga yaalem namp mëngkën wii kaatak ulmëaup. ");
INSERT INTO wer_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pël maan Pailatök kaalak epël mëëa. “Ne Yesu wil momëëmaat.” ");
INSERT INTO wer_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Maan pit ngön ëak epël mëëa. “Këra yetaprak möön wel wiip. Këra yetaprak möön wel wiip.” ");
INSERT INTO wer_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pël maan Pailat pi akun nentepar nent pötak epël mëëa. “Omën epop pi utpet oröp nent ëa? Ne itaangkën pi mëmpena nent naën. Pötaanök ne maan ngaaröak tang pëën möak wii kaatakaan wes mëëpnaat.” ");
INSERT INTO wer_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pël maan pit ke ur olëak ngön ëak, “Pi këra yetaprak möön wel wiip,” pël mëak ngön kaëpre ngön ëak Pailatë ngönte wa irikor ë olëa. ");
INSERT INTO wer_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pël ëën Pailat pi pitëm ngön mëëa pöt kat wiak möön wel wiipënëak mëëa. ");
INSERT INTO wer_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Pël ëak pitëm këk mëëa pötaan omnamp mëngkën wii kaatak ulmëaö pöp wil moulmëak Yesu pitëm kentöök möön wel wiipënëak pëël elmëa. ");
INSERT INTO wer_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Pit Yesu mësak yesem kamtaöök omën namp yapinte Saimon, Sairini kakaanëp, pi yaakaan yewaisën koirak wali wak këra yetapër mangkën waalak Yesuu ënëm sa. ");
INSERT INTO wer_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Pël ëën omën selap ënëm yesem öng narö Yesuun ingre tanëër sa. ");
INSERT INTO wer_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Pël ë yesën Yesu kaip ti epël mëëa. “Yerusalem öngörö, ar neen ing angan. Arimëntre arim ruuröaanökëër ing aë. ");
INSERT INTO wer_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kat wieë. Ënëmak akun nent temanöm sëën epël anëët. ‘O, öng ru köpëlörö. Pit ru wilööre kapa mampö pël naën yaaurö. Pötaanök pitökëër ërëpërëp yaë,’ pël anëët. ");
INSERT INTO wer_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Akun pötak rosir kaöatön, ‘Pelak ngep elnieë,’ pël mëak kotutön, ‘Kör elnieë,’ pël manëët. ");
INSERT INTO wer_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Këra iiringöt es yemarën pangk naën yaë pöta ök ne omën ompyaö yaaup wel newiinë pöt pangk naën yaëëtak ar wel newiinëak kent yeë. Pötaanök këra umönöt es marën pangk yaë pöta ök ar utpet yaauröak wel wiinëët.” ");
INSERT INTO wer_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Pit omën utpet yaaö naarta Yesuring mööpënëak mësak sa. ");
INSERT INTO wer_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Pël ëak yang lup nent yapinte “Kepön Kos” pël yamëëa pörek së oröak pi këra yetaprak momöa. Pël ëak utpet omën naarta, namp yaapkëël namp katnëël, mö ulmëa. ");
INSERT INTO wer_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Pël ëën Yesu pi epël mëak kimang mëëa. “Pep, pitëm yaalnë epot köpël wë yaalnë. Pötaan pitëm saun epotë kangut won mowas.” Pël yemaan ngaarö pit pim ulpëënre poë koröpöt wak ngasamtak wiak talëpök öpën pöten itena. ");
INSERT INTO wer_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Pël yaëën omnarö itenaan omën kaöarö pit epël mëak ökre was mëëa. “Pi omën muntarö kaamök yaaupök peene pimtok pimënt kaamök ëëp. Pi Kristo, Anutuu Yaö Mëëaup pöt pël ëëp.” ");
INSERT INTO wer_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Pël yemaan ngaaröakta ökre was mëak naë së wain i somit menak epël mëëa. ");
INSERT INTO wer_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“Ni yaap Yuta omnaröa omën omp aköp pöt nimtok nimënt kaamök ë.” ");
INSERT INTO wer_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Pël mëak pim kepön löötak epël retëng ë ulmëa. “Omën epop Yuta omnaröa omën omp aköp.” ");
INSERT INTO wer_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Pël yaëën utpet omën naar piiring möa pöaar nampök utpet wesak epël mëëa. “Nim ök pilëpta Kristo ma? Ni yaap pöp pöt nimënt kaamök yeem tenipta pël elni.” ");
INSERT INTO wer_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Pël yemaan ngöntöpök nga mëak epël mëëa. “Nim këlangön kat yawiin tapël yaëëp ni Anutuun kas naën yaan ma? ");
INSERT INTO wer_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Tepër pöt, tepërim saunatë kangiir ompyaö yaalni. Ën omën epop pöt, saun wonöp.” ");
INSERT INTO wer_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Pël mëak Yesuun epël mëëa. “Yesu nim omp ak sak waisumëëtak neen kön wiim.” ");
INSERT INTO wer_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Pël maan Yesuuk epël mëëa. “Ne yaap niamaan. Peene tapëtakëër ni neering ngës ompyauuk ömëët.” ");
INSERT INTO wer_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Këtëp luptak 12 kilok pötak wëën kët itte utpet ëën yanget koö olëak wieë së wiap kan 3 kilok oröa. ");
INSERT INTO wer_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Pël yaëën ngönën tup kaöetak poë koröp kësang ngeröök uteëaumpel luptak keliak nempelnempel ëak sa. ");
INSERT INTO wer_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Pël ëën Yesu pi ngön ëak epël mëëa. “Pep, nem könöp nim moresi yanuulë.” Pël mëak yok wel wia. ");
INSERT INTO wer_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Pël ëën ngaaröa wotöököp pi omën oröa pötön itenak Anutuun yaya mëak epël mëëa. “Omën epop pi yaap saun wonöp.” ");
INSERT INTO wer_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Pël yaëën omën itaampënëak së wa top ëa pörö pit omën oröa pötön itenak yaköm kön wi kakë sa. ");
INSERT INTO wer_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Pël yaëën Yesu pim karuröere Kalili yangerakaan ënëm sa pörö pit pëlëër wë omnant oröa pötön itena. ");
INSERT INTO wer_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Omën namp yapinte Yosep pöp Yutia yangerak ");
INSERT INTO wer_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Arimatia kakaanëp, pi omën ompyaup yak wotpil wë Anutuuk wa ngaöök momëëpënëak kor wakaima. Pi kansol wotöököröaring wëaup. Pël ëaupök pim karurö Yesu mëmpënëak ngön yaan pi nerek wak nemaan ëa. ");
INSERT INTO wer_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Omën pöpök Pailatë naë së Yesuu sokuren ök mëëa. ");
INSERT INTO wer_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pël ëën kat mowiin së yetaprakaan ent ëak poë koröp kölam ompyaö naöök kör koëak kël öngöp naö omnarö wa wiipënëak tëau wieëa pörekël wak sa. Kël öngöp pö omën namp wa nawiinö. ");
INSERT INTO wer_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Pöt kë yesa akun ngëëngkët ëlpamök wiaan omnant kön ëa. ");
INSERT INTO wer_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Pël ëën öng Kalili yangerakaan Yesuring saurö pit Yosepë ënëm së omën yangaöön itena. Pël ëak Yosep pi sokur tolëël yawi pöten itena. ");
INSERT INTO wer_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Pël ëak kaalak kak së kolap köp nga kamp ompyaut Yesuu sokurak wa mëëpnaan wak sëpënëak kopëta wes wiak akun ngëëngktak ngön kosangta wieëaul koröp kë sa. ");
INSERT INTO wer_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Sante wangam kan röökëër pan öngörö kolap köp nga kamp kopëta wes wia pöt wak yangaöökë sa. ");
INSERT INTO wer_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Së oröak itaangkën kël kësang kan wari ulmëaumpel wa olaan kan të wieëa. ");
INSERT INTO wer_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Pël ëën pit kël öngöpöökë kakaati së itaangkën Yesuu sokur won wieëa. ");
INSERT INTO wer_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Pël ëën ap wesak ëngk ma e wasö yaëën omën naar ulpëën kölam panëëpëaar mëauwaar piarpim naë oröak taua. ");
INSERT INTO wer_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Pël ëën öngörö itenak kas ëën tok oriak yangaakël itenaan omën pöaarök epël mëëa. “Ar oröp ëënak öp wëaupön welaaröa naë ap yewas? ");
INSERT INTO wer_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Pi eprek won. Yok wal ëa. Ar pim ngaan Kalili yangerak wë ngön epël ök niiaö pöten kön wieë. ");
INSERT INTO wer_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Pi epël niiaup. ‘Omën Këëp ne saun omnaröa naë neulëën pitök këra yetaprak nemöön wel wiak kët nentepar nent yangaöök wieë kaalak wal ëëmaap,’ pël niiaup.” ");
INSERT INTO wer_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Pël maan öngörö Yesuu ngaan ngön ök mëëa pöten kön wiak ");
INSERT INTO wer_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","yangaöökaan kaalak kak së Yesuu ru 11 pöröere omën muntaröen pitëm omën itaampööre kat wi ëa pötön ök mëëa. ");
INSERT INTO wer_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Öng pörö Maria Matala kakaanëpre Soanaare Maria Semsë ëlëpre öng munt naröere pël ëak öng pöröak së Yesuu ngön yaaö omnaröen ök mëëa. ");
INSERT INTO wer_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pël ëën pit ngön pöt kat wiak, “Öngre yokot ngön ya,” pël mëak wa yaap newasën ëa. ");
INSERT INTO wer_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pël ëak Pita pi wal ëak pöömpö së yangaöök oröak tok oriak kël öngöpöök itaangkën poë koröp kör koëau pëën wiaan itena. Pël ëak omën oröa pöten kön selap ë kakë sa. ");
INSERT INTO wer_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Kët tapëtak Yesuu ingre mor sauröakaan naar Emeas kakë sëpënëak sa. Ka pö Yerusalem kak naë 11 kilomita pöta ök wieëa. ");
INSERT INTO wer_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Omën pöaar kamtaöök yesem omnant oröa pötë ngönöt aö yesa. ");
INSERT INTO wer_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Pël yaëën Yesu pimënt piarpim naë oröak piaripring sa. ");
INSERT INTO wer_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Pël ëën omën pöaar itenak Yesuun pi newasën ëa. ");
INSERT INTO wer_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Pël ëën pëël mëak epël mëëa. “Oröp nantëën nampnampön maö im?” Pël maan piarip leng ëak tok orieë yaköm ë sak ëa. ");
INSERT INTO wer_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Pël ëak namp Kliopas puuk epël mëëa. “Elei, ka ël epotëaan omën pourö Yerusalem kak wëëp ni kopëtapökëër omën pörek oröauten köpël wëën ma?” ");
INSERT INTO wer_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Pël maan Yesuuk piaripön pëël mëak epël mëëa. “Pöt tol ëa?” Pël maan piarip kangiir epël mëëa. “Yesu Nasaret kakaanëpë elmëa pöten yak. Pi tektek ngön yaaö namp, Anuture omnaröa ëöetak ngön kosang aöre ya weëre kosangringöt mëmpö pël yaaupök ");
INSERT INTO wer_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","kiri ar yaaö kaöaröere tiarim ngarangköröak Rom yang ngarangkëpë naë wes mëën puuk mëmpënëak maan këra yetaprak möaup. ");
INSERT INTO wer_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ten pöt, puuk Israel omnarö tiar utpetetakaan niöpnaat pël weseëan pöt pitök möön wel wia pöta ngöntere kët nentepar nent ëën munt nant oröa pötë ngönöt yak. ");
INSERT INTO wer_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Tenim naëaan öng naröak Santeetak röökëër yangaöök së itenak wais ök niaan yaan saut. ");
INSERT INTO wer_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Pit së sokuren ap wesak wais epël niiaut. ‘Ten së itaangkën ensel naarök, “Yesu pöp öp sak wë,” pël yenia.’ ");
INSERT INTO wer_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Pël niaan tenim naëaan omën naar piaripta së yangaöök itaangkën öngöröa aan kat wia tapël itena. Pël ëaap pimtën itnaangkën ëa.” ");
INSERT INTO wer_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Pël maan Yesuuk kangiir epël mëëa. “Arip kön won pan. Arip oröp ëënak tektek ngön yaaö omnaröa ngön retëng ëautön kön wi kosang newasën yeë? ");
INSERT INTO wer_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Kristo Yaö Mëëaup pi këlangön kat wiak kaalak pim ëwaare weëre kosang pimot öpna pöten arip köpël ma?” ");
INSERT INTO wer_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Pël mëak Moses pim ngön ëa pötak ngës rëak tektek ngön yaauröak ngönën pepatë pimëën ngön ëa pöt pout ök mëëa. ");
INSERT INTO wer_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Piaripring kak së oröak el wesak sëpënëak yaëën piarip epël mëëa. ");
INSERT INTO wer_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","“Këtëp ilaan koö olapënëak yaëërek tenipring öpa.” Pël maan piaripring kakaati sa. ");
INSERT INTO wer_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Pël ëak wë kaömp nëmpënëak wel aisëeë puuk kaömpöt wak Anutuun yowe mëak pelak piarip mena. ");
INSERT INTO wer_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Pël yaëën piarip pörekök kön tektek sak iten sokola. Pël ëën pi ëlëëp ilëa. ");
INSERT INTO wer_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Pël ëën piarpimënt nampnampön epël mëëa. “Tepër kamtaöök yewaisem pi ngönën pepatëaan ngön songönöt ök niaan kat wiak ya kë saut.” ");
INSERT INTO wer_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Pël mëak akun tapëtakëër wal ëak kaalak Yerusalem kakël sa. Pël ëak pörek së itaangkën ru 11 pöröaring piarpim karurö wëën itena. ");
INSERT INTO wer_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Pël ëën pitök epël mëëa. “Yaap pan, Aköp wal ëak wë Saimonön ë pet elmëën itena.” ");
INSERT INTO wer_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Pël maan piaripök piarpim kamtaöök yesën ëa pöta ngönte ök mëak kak së kaömpöt yepelën piarpim piin këëkë itena pöta ngönteta ök mëëa. ");
INSERT INTO wer_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Pit ngön pöt aim wëën Yesu pimënt pitëm tekrak orö rëak epël mëëa. “Arim lupötë mayaap wiaap,” pël mëëa. ");
INSERT INTO wer_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Pël ëën pit yaan sak, “Yesuu könöpök yaë,” wesak kas ëa. ");
INSERT INTO wer_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Pël ëën pi epël mëëa. “Ar oröp ëën yaan utpet sak kön selap yeë? ");
INSERT INTO wer_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Nemënt tapöpök wë. Ar nem ingre morötön iteneë. Pël ëak morö pat ëak këëkë it nengëneë. Ne koröpre mësëpring wë. Kön pörö epël wonörö.” ");
INSERT INTO wer_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Pël mëak pim ingre moröt pet elmëa. ");
INSERT INTO wer_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Pël ëën pit ya kë sak pim ngönte kat wiak kön wi kosang newasën om yaan sak yeem wëën epël mëak pëël mëëa. “Arim kaömp nant eprek wia ma?” ");
INSERT INTO wer_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Pël maan pit i kaö imën kota kaö nent mangkën ");
INSERT INTO wer_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","wak pitëm itöök na. ");
INSERT INTO wer_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Na pet irak epël mëëa. “Ne arring wë epël niaimaut. ‘Ngaanëër Mosesë ngön kosangötre tektek ngön yaauröa pepatë ngön wia pipotre tan pep Sam pöweri nemëën ngön ëa pipot pout kë rapënaat,’ pël niiaut.” ");
INSERT INTO wer_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Pël mëak pimtok ngönën pepeweri ngön wia pöt ök maan kat wiak pitëm lupöt kan tëa. ");
INSERT INTO wer_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Pël ëën Yesuuk epël ök mëëa. “Ngönën pepeweri epël wia. ‘Yaö Mëëaup, Kristo, pi këlangön kat wiak wel wiak akun nentepar nent pël wieë kaalak yangaöökaan wal ëëpnaap. ");
INSERT INTO wer_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Pël ëën omnarö lup kaip tiin pitëm utpetat kërë moolapëna pöt pim yapintak ök maan Yerusalem kak ngës rëak aö yesem yang poutë së pet irëpnaat,’ ëaut. ");
INSERT INTO wer_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Pötaanök arim itenan puot tekeri wesak ök man. ");
INSERT INTO wer_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Kat wieë. Nem Pepapök ngaan omnant arimëën yaö niia pöt nook wes nimëëmaat. Pötaanök ar om kak eprek wëën kutömweriaan weëre kosang pöt arim naë irapnaat.” ");
INSERT INTO wer_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Pël mëak pit mësak Petani kak naë së oröak pim moresiar ngaarëk weë pit welaköt elmëa. ");
INSERT INTO wer_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Pël yeem wil moulmëak kutömweri isa. ");
INSERT INTO wer_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Pël ëën pit piin yaya mëak ërëpsawi kaö ë kaalak Yerusalem kak së ");
INSERT INTO wer_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","wë kët ël epotë ngönën tup kaöetak wakaimeë Anutuun yaya maim wakaima. ");
INSERT INTO wer_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ngaan panëër kutömre yang won wiaan Këm Ngön pi wakaima. Këm Ngön pi Anuturing wakaima. Këm Ngön pi Anutu tapöp. ");
INSERT INTO wer_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ngaan panëër pi Anuturing wë. ");
INSERT INTO wer_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Piaripök ël epot pout ket ëauwaar. Omën nant kan naöökëlaan naaröön. Won, Anutu puuk Këm Ngön piin maan omën ël epot pout ket ëa. ");
INSERT INTO wer_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Pël ëak pimënt wëwë pepap pël saarëën pim wëwë pötak omnarö piin kön wiipenëak ëwa elnia. ");
INSERT INTO wer_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ëwa pepap pi ëwa elnieim wë. Pötaanök koutak ëwaat ngep naalmëëpan. ");
INSERT INTO wer_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Omën namp Anutuuk wes mëën oröa yapinte Son. ");
INSERT INTO wer_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Pi ëwa pöta ngönte omnaröen ök maan ëwa pepapön kön wi kosang wasëpënëak oröa. ");
INSERT INTO wer_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Son pi pöp ëwa wonöp pi om ëwa pepapë ngönte ök apënëak oröa. ");
INSERT INTO wer_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ëwa pep kë pöp pi oröak yangerakë omën pourö ëwa elnia, wë epop. ");
INSERT INTO wer_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Anutu puuk Këm Ngön piin maan puuk yangerakë omënere omnant ket ëaup pitring wëënak pit piin ëwat nasën wakaima. ");
INSERT INTO wer_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Pi pimtë yang songöntak oröak wëënak omnarö pit piin ngöntre kar naalmëën ëa. ");
INSERT INTO wer_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ën omën ngöntre kar elmëak piin kön wi kosang wesaurö tiar Yesuuk pimëën yaö niwasën wë Anutuu koröngre ru seim wë. ");
INSERT INTO wer_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Tiar omnaröa yaaul Anutuu koröngre ru sak naön. Ëlre peparö pitëm kentöök ma könöök pël naën. Anutu puuk elniin pim koröngre ru seim wë. ");
INSERT INTO wer_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Këm Ngön pi omën orö rëak tenim tekrak wëën ten pim ë rangiatön iteneimaut. Pi komre kolap elnieimeë ngön këët pëën ök niaimaup. Ten pim ë rangiat iteneimaö pöt Anutuuk pim ru kopëtap mena. ");
INSERT INTO wer_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Son i yamëaup pi ru pöpë songönten war wesak ök mëak epël mëëa. “Omën epopön ne ngaan arën epël ök niiaut. ‘Omën nem ënëm yewais pöp puukëër kaöap. Ne naaröön wiaan pi wakaimaup.’” ");
INSERT INTO wer_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Pi komre kolap pepap yak tiar pourö pim naëlaan komre kolap kësangën yaalniin nganngan weim wë. ");
INSERT INTO wer_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Pöt tol ëënak? Anutuuk tiarimëën tektek ngönöt pëën Moses pim moresi mowiin nina. Pël ëautak Yesu Kristo puuk komre kolap niwesak ngön këët tekeri wes nina. ");
INSERT INTO wer_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Omën nampök Anutuun itnaangkëntak pim Ruup pimtokëër Pepapring wëaup. Pötaanök Pepapë songönte war wesak tiarën ök yenia. ");
INSERT INTO wer_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yuta ngarangk Yerusalem kak wëaurö pit Anutuun kiri ar yaaö naröere Liwai ngönën omën narö Sonë naë wes mëën së epël pëlpël mëëa. “Ni talëp?” ");
INSERT INTO wer_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Pël maan Son pi ngep naën war wesak epël ök mëëa. “Ne Yaö Mëëaup, Kristo won.” ");
INSERT INTO wer_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Pël maan pit piin kaalak epël pëlpël mëëa. “Ën ni Anutuu tektek ngön yaaö omnamp Elia ma?” Pël maan pi wonwon mëëa. Pël maan pit kaalak epël pëlpël mëëa. “Ma ni Anutuu tektek ngön yaaö omnamp tenim kor wakaima pöp ma?” Pël maan pi kaalak wonwon mëëa. ");
INSERT INTO wer_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Pël maan pit epël mëëa. “Ën ni talëp? Tenim wes nimëauröen së ök menaan. Nim songönten ök nia. Nimtok nimtëën talëp yamëëaup?” ");
INSERT INTO wer_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Pël maan Son puuk epël mëëa. “Ne yang pultak wë ngön ëak epël yaaup. ‘Aköpëën kanö ngëseë.’ Ngaanëër Anutuu tektek ngön yaaö omnamp Aisaia pim tektek ngön ëa pöt nem naë kë yaarö.” ");
INSERT INTO wer_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Pël maan omën wes mëauröa naëaan Parisi ngönën omën narö pit piin epël pëlpël mëëa. ");
INSERT INTO wer_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","“Ni Kristo won, ma ni Elia won ma ni Anutuu tektek ngön yaaö omnamp tenim kor wakaima pöp won ëën pöt ni tol ëënak omnarö i yamëaup?” ");
INSERT INTO wer_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Pël maan Son pi epël mëëa. “Ne omnarö i yaaptaring yamëaup. Ën omën namp arim tekrak wëën itnaangkën wë. ");
INSERT INTO wer_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ne utpet epopök yok pangk pim ing korötepar wii nemowilngan.” ");
INSERT INTO wer_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Yotan i pouuk Petani kak Son pim omnarö i mëa lup pötak ngön pöt oröa. ");
INSERT INTO wer_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ëlpamök Son pi itna pöt Yesu yewaisën itenak epël mëëa. “Iteneë. Ëngkop Anutuu Sëpsëp Ruup. Kiri ar yaaurö sëpsëp ruurö Anutuuk omnaröa ketöt won wasëpënëak pit kiri ar ë yaë ök tapël Anutuuk tiar omnaröa ketöt puuk won niwasëpënëak wes mëën oröaup. ");
INSERT INTO wer_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Omën pipopönök ne ngaan epël niiaut. ‘Omën nem ënëm yewais pöp puukëër kaöap. Ne naaröön wiaan pi wakaimaup.’ ");
INSERT INTO wer_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nemëntta piin köpëlëp. Pël ëautak ar Israel omnarö piin ëwat sënëak i yanimë.” ");
INSERT INTO wer_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Pël niak Son pi epël yenia. “Neenta köpël wëënak Anutuu omnarö i momëëmëak neeaupök epël neeaut. ‘Ni omën namp i yemomëën Ngëëngk Pulö irë rangk ngentiak öpna puopök omnarö Ngëëngk Pulö momëëmpnaap.’ Pël neaan ne itaangkën Ngëëngk Pulö int ekëpë ök sak kutömweriaan irë pim rangk ngentiak wëa. ");
INSERT INTO wer_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ne pöten itenak war wes niamaan. Yaap, epop Anutuu Ruup.” ");
INSERT INTO wer_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ëlpamök Son pim ru naarring wë ");
INSERT INTO wer_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","itaangkën Yesu kan yesën epël ök yenia. “Iteneë. Ëngkop Anutuu Sëpsëp Ruup.” ");
INSERT INTO wer_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Pël niaan tenip kat wiak Yesuu ënëm saut. ");
INSERT INTO wer_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Pël ëën Yesu kaip ti itaangkën tenip pim ënëm yesën itenak epël pëlpël yenia. “Arip oröp wë yewais?” Pël niaan tenip epël pëël mëëaut. “Rë yanuulaup, ni ka taltak wëaup?” ");
INSERT INTO wer_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Pël maan Yesuuk tenipön epël yenia. “Arip wais iteneë.” Pël niaan tenip piiring së ka wëauten itenak kët taptak piiring wë ka uraut. Tenip wiap kan 4 kilok saut pötaanök. ");
INSERT INTO wer_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Yokot Son pim ngönte kat wiak neering Yesuu ënëm sa pöpë yapinte Entru, Saimon Pita pim nangap. ");
INSERT INTO wer_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Pi teëntom së pim nanëp Saimon koirak epël ök mëëa. “Tenip Anutuu Yaö Mëëaup Kristo koirak itenaut.” ");
INSERT INTO wer_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Pël mëak Entruuk Saimon koirak Yesuu naë waisa. Pël ëën Yesuuk Saimon piin itenak epël mëëa. “Ni Saimon, Sonë ruup. Ne nim yapinte Sipas yeniak.” Yapin Sipas pötere Pita pötepar tiarim ngöntak kël. ");
INSERT INTO wer_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ëlpamök Yesu pi Kalili yangerakë sëpënëak kön wia. Pël ëak itaangkën Pilip wëën epël ök mëëa. “Ni nem ruuröaring wë.” ");
INSERT INTO wer_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilip pi Entruure Pita piarpim ka songönte Pesaita pörekaanëp. ");
INSERT INTO wer_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pilip pi së Nataniel koirak epël ök mëëa. “Ngaanëër Anutuuk ngön kosangöt Moses mangkën retëng ëëre tektek ngön yaauröa retëng ë pël ëaut kat wieim pöp ten koiraut. Pöp Yesu Yosep pim ruup Nasaret kakaanëp.” ");
INSERT INTO wer_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Pël maan Nataniel pi epël mëëa. “Omën ompyaup ke pëlëp Nasaret kakaan naarööpanpe.” Pël maan Pilipök epël mëëa. “Wais itaampëën.” ");
INSERT INTO wer_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Pël mëak Pilip Nataniel koirak Yesu pim naë waisën itenak pim songönten epël yenia. “Omën yewais ëngköp pi yaap Israel omën yaapöp. Pi morököt wonöp.” ");
INSERT INTO wer_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Pël yeniaan Nataniel pi Yesuun epël yema. “Ni tol ëak nem songönten ëwat wëën?” Pël maan Yesuuk epël yema. “Pilipök ngön neniaan wiaan ni kem songöntak wëën itenaut.” ");
INSERT INTO wer_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Pël maan Nataniel kangiir epël mëëaut. “O rë yanuulaup. Ni Anutuu Ruup. Ni Israel omnaröa omën omp aköp.” ");
INSERT INTO wer_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Maan Yesuuk kangiir epël ök yema. “Kem songöntak wëën nem itnak niiaö kot taptaan kön wi kosang yenewasën. Pötaanök ënëmak omën kaöat oröön itaampëët.” ");
INSERT INTO wer_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Pël mëak Yesuuk kaalak rangk epël yema. “Ne yaap pan niamaan. Ënëmak ar itaangkën kutömwer kan tëën Anutuu enselörö Omën Këëp nem naë isak yeiraan itaampunëët.” ");
INSERT INTO wer_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Kët nentepar won sëën Kena kak Kalili yangerak omën namp öng mor mampënëak yaëën Yesu pim ëlëp omën pöpë kaatak wëa. ");
INSERT INTO wer_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Pël ëën Yesure pim ruurö ten këëre imën nënëak tenën yas niia. ");
INSERT INTO wer_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Pël ëën së wë wain iit won sëën Yesu pim ëlëpök piin epël ök yema. “Pitëm wain iit kos sa.” ");
INSERT INTO wer_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Pël maan Yesuuk epël yema. “Öng epop, ni nem ëëma pöten kön selap ëëngan. Nem songönte tekeri wasuma akunet naën.” ");
INSERT INTO wer_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Pël maan ëlëpök inëënöröen epël ök yema. “Omën nant ëënëak niaan pöt ënëm elmëën.” ");
INSERT INTO wer_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Yuta omnarö tenim ngönënta wieëaul kaömp nënëak pöt mor i yairaut. Pötaanök ka pötak yang kap 6 ëak wieëa. Kap nent peö ëaan pöt 20 ma 30 kalen i ke pël wiaapnaat. ");
INSERT INTO wer_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Pël ëën Yesu pi inëënöröen epël ök mëëa. “Ar i kolak lë mëën peö ëëp.” Pël maan pit kolak wais mëak peö panë ë ulmëa. ");
INSERT INTO wer_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Pël ëën Yesu pi epël ök mëëa. “Ar nant kap pötëaan lë mëak wak së këëre imën ngarangkëp meneë.” Pël maan pit kolak lë mëak wak së mangkën ");
INSERT INTO wer_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","i yaaptak wain i sa pöten kön nawiin ëa. Inëënörö i kolak së mena pörö pitökëër ëwat wëa. Pël ëën ngarangkëp pi omp öng koira pöpön ngön mëak epël mëëa. ");
INSERT INTO wer_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“Omnaröa yaaul wain i ompyaut mangkën omën pourö nëmpënaatep tol ëënak ompyaut om wiaan wain i pasit wet rëak ningkën nak kep ëak wëënak ënëmak wain i misëng wesaut ëlëëp ngep ëak wakaimaut wak yaën? Talëp pël yeëa?” ");
INSERT INTO wer_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yesu pim retëng nentere nent ëëpna ngës rëak Kena Kalili yangerak pim weëre kosang pet elniipënëak retëng pipët ëën itenak ten pim ruurö weëre kosangö pim naë wia pël kön wi kosang wesaut. ");
INSERT INTO wer_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ënëmak Yesuu ëlre nangre ruurö pël ëak ten Kapaneam kak së oröaut. Pörek së akun wali naön. ");
INSERT INTO wer_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Anutuu mait elmëa akun ngëëngkët temanöm yesën ten Yesuring Yerusalem kakë saut. ");
INSERT INTO wer_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Pël ëak pörek së Anutuu ngönën tup kaöetak ilëak Yesu pi itaangkën omnarö ka lup nentak wë pol purimakaöre sëpsëpre intre pörö sum ë ën monat ngawingawi ë pël ëeim wëa. ");
INSERT INTO wer_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Pël ëën Yesu pi itenak wii koö nenges wak omënere pol purimakaöre sëpsëp pörek wëaurö waö ë mëak mon ngawingawi yaauröa monat wak kömen moolëak urötta kaip ti yemoola. ");
INSERT INTO wer_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Pël ëak intörö wak ngawingawi ëeim wëauröen epël yema. “Piporö wak kama seë. Nem Pepapë tup ngëëngk epët uröm kaatë ök wasngan.” ");
INSERT INTO wer_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Pël yemaan pim ruurö ten ngönën pepeweri ngön epël retëng ëa pöten kön wiaut. “Ne nim kaat ompyaö wiaapnaataan weë yengenti.” ");
INSERT INTO wer_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Yesu pit waö ë momëën ngönënë kaöaröak epël yema. “Nim ten waö yaalniin pöta songönte pet elniimëën retëng weë nent pet elniin itaampun.” ");
INSERT INTO wer_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Pël maan Yesuuk kangiir epël yema. “Ar tup epët tööl olaan pöt nook kaalak akun nentepar nent ök rëëmaat.” ");
INSERT INTO wer_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Pël maan pit epël yema. “Akun selap pan krismaki 46 ke pël ök rëautep. Nuuk yok pangk akun nentepar nent kaalak ök ram ma?” ");
INSERT INTO wer_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Yesu pim ngön mëëa pöt ngönën tupten nemaan, pimtë koröpöön yema. ");
INSERT INTO wer_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Pël ëautak wë ënëmak weletakaan wal ë moulmëa akun pötak pim ruurö ten pim ngaanëër ngön ök niia pöten kön wiaut. Pël ëak ten ngönën pepeweri wieëa pötere Yesuu ök niia pöteparën kön wi kosang wesaut. ");
INSERT INTO wer_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Anutuu mait elmëa akun ngëëngktak Yesu Yerusalem kak wëën omën selap pim retëng weëre kosangring yaaö pötön itenak piin kön wi kosang yemowas. ");
INSERT INTO wer_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pël ëën Yesu pi pitëm songönten ëwat wëa. Pötaanök pitëm piin kön wi kosang yemowas pöten yaap newasën yaë. ");
INSERT INTO wer_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Pël ëën nantön köpël naënëp yak omnaröak ök nemaan wiaan pimtok pitëm lupötë iten pet ira. ");
INSERT INTO wer_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Omën namp wëa yapinte Nikotimas, pi Parisi ngönën omën, Yuta omnaröa kaö namp. ");
INSERT INTO wer_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Pi röök nentak Yesuu naë së epël mëëa. “Rë yanuulaup, niin ten ëwat wë. Anutuuk ni ten rë niulömëak wes nimëaup. Anutu omën nampë naë won wiaan yok pangk nim yaën epël retëng it ngolöp nent naëpan.” ");
INSERT INTO wer_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Pël maan Yesuuk kangiir epël ök mëëa. “Ne yaap pan niamaan. Namp pi ngolöp wesak yawilën wëwë kosangtak öpna pöp Anutuuk wa ngaöök mëëpnaap. Pël naënëpök yok pangk naëpan.” ");
INSERT INTO wer_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Pël maan Nikotimas pi epël mëëa. “Tol ëak omën namp pi kaö saupök ngolöp wesak wilëpën? Ma kot sak kaalak ëlëpë lupmeri ilaan ngolöp wesak wilëpën ma?” ");
INSERT INTO wer_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Pël maan Yesuuk kangiir epël mëëa. “Yaap pan niamaan. Namp pi iitere Pulöök elmëën ngolöp wesak yawilën wëwë kosangtak naön ëëpna pöp Anutuuk wa ngaöök namëëpan. ");
INSERT INTO wer_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Omën kepëtakaan wilëpna pöp omën möönre koröp pëën wak öpnaat. Ën Pulöök elmëën ngolöp wesak wilën wëwë kosangtak öpna pöp Pulöökë weëre kosang wak öpnaap. ");
INSERT INTO wer_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ni nem ngolöp wesak wilën wëwë kosangtak ön pël ök yeniak pötaan yaan sak ëëngan. ");
INSERT INTO wer_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Kentö pi pimtë yamöaul yamö. Pël ëak omnant pout ëtëp ë yesën nga ngönpel pëën kat yawiin. Ën songönte tarëkaan oröak yewais ma tarëk së pet yair pöt ni köpël wëën. Omën Pulöök elmëën ngolöp wesak wilën wëwë kosangtak öpnaarö pit tapël ëëpnaarö. Ni Pulöökë yaë pöten köpël wëën pötaanök.” ");
INSERT INTO wer_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Pël maan Nikotimas kangiir epël mëëa. “Pöt tol ëak pël ëëpën?” ");
INSERT INTO wer_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Pël maan Yesuuk epël mëëa. “Ni Israel omnaröa rë yanuula kaö nampök tol ëënak köpël yaën? ");
INSERT INTO wer_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ne yaap pan niamaan. Omnant tenim itenak kat wiak pël yaautön yeniak. Ök yeniaan ar kasëng yemengkaurö. ");
INSERT INTO wer_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ne yangerakë omnantëël niaanakta ar kön wi kosang newasën yeë. Pötaanök kutömweriil ko wesak niamaatep ar pötön köök kön wi kosang newasën ëën sa. ");
INSERT INTO wer_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Arëkaan namp kutömweri nawisën Omën Këëp nemtokëër kutömweriaan yangerakël irëaup. ");
INSERT INTO wer_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ngaan Moses puuk yang pultak kamal könöp ket ëak këraarak möak wesir ulmëa pöta ök Omën Këëp ne tapël elnëëpnaat. ");
INSERT INTO wer_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Pël ëën neen kön wi kosang newasëpnaarö wëwë kosangtak öpnaarö. ");
INSERT INTO wer_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Anutu pi yangerak omnarö lup sant elniak pim Ru kopëtap wes nemëën irëaut. Pötaanök narö ar neen kön wi kosang newasënëërö kö nasëngan, wëwë kosangtak önëërö. ");
INSERT INTO wer_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ruup ne ngön ë pet yairauröa yaë pöl elniimëak won, omnarö utpetetakaan kama niömëak Anutuuk wes nemëën irëaut. ");
INSERT INTO wer_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Pötaanök namp pi kön wi kosang newasëpnaap pi ngön ya nampan. Ën namp pi kön wi kosang nenewasën ëëpna pöp pi kö sëpënëak ngön ë pet irën wë. Pöt tol ëënak? Anutuu Ru kopëtap neen kön wi kosang nenewasën ëa pötaanök. ");
INSERT INTO wer_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ngön ya mëmpna pöta songönte epël. Yesu pi ëwa pepap yangerak oröak wëënak omnarö pit pim ëwa pöten itaampnaaten kaaö ëën kouten kent ëa. Pöt pitëm wëwëet utpet pötaanök ëwaaten kaaö ëa. ");
INSERT INTO wer_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Omën utpetat yaaurö pit ëwaaten kaaö yaë. Pit pitëm yaaut tekeri sëpan pötaan kas ëak ëwaatak naaröön yaë. ");
INSERT INTO wer_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ën namp pi këët ngar öpna pöp ëwa pöt temanöm wasëpnaap. Pël ëën pim omnant yaaut Anutu pim ngönta ököök ima pöta songönte tekeri sëpnaat.” ");
INSERT INTO wer_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Pël mëak Yesu pi pim ruurö tenring Yutia yangerakël saut. Pörek së wë omnarö i momëaut. ");
INSERT INTO wer_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Inon kak, Selim kak naë pörek i kësang wieëa. Pötaanök omnarö sëën Son piita i momëeim wëa. ");
INSERT INTO wer_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Akun pötak Erot pi Son wii kaatak nemoulmëën wiaan pël ëa. ");
INSERT INTO wer_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Pörek Sonë ru naröere Yuta omën namp pitëm i yamëa pötaan neneren ngön nga ela. ");
INSERT INTO wer_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Pël ëak pit Sonë naë së piin epël ök mëëa. “Rë yanuulaup, ni omën namp ngaantak Yotan i pouuk niiring wë pim songönte war wesak ök mëëan pöpön kön wiaan ma? Omën pöpök omën i yemomëën omën pourö pim ngësël sa pet yair.” ");
INSERT INTO wer_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Pël maan Sonök kangiir epël mëëa. “Pi yok pangk yaë. Anutuuk omën namp omnant ëëpënëak weëre kosang nemangkën wiaan pimtok yok pangk naëpan. ");
INSERT INTO wer_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Arimtokëër ëwat wë. Ne ngaan epël niiaut. ‘Ne Yaö Mëëaup, Kristo won. Pi tapöpëën wet rëak wes nemëaup.’ ");
INSERT INTO wer_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Omën namp pim öng yaup koirën pöt öngöp pimtë naë së öpnaat. Pël ëën ompöpë karip pi naë wë pim ngöntöpë ngönte kat wiak ërëpërëp ëëpnaat. Pöta ök omnarö Yesuu naë yesën itenak nem lupmer ërëpsawi kaö yeë. ");
INSERT INTO wer_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Puukëër isëp. Ne irem.” ");
INSERT INTO wer_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Omën ngaarëkaan irëaup pi omnant pout il niwesaup. Omën yangerakaan oröaup pi yangerakaanëp. Pi yangerakë omën epotëël ngön apnaat. Omën kutömweriaan irëaup pi omën epot pout il niwesaup. ");
INSERT INTO wer_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Pi pim omnant itaampööre kat wi ëautön ök yeniaanak omën naröak kat wiak kön wi kosang newasën yeë. ");
INSERT INTO wer_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Omën namp pi kat wiak kosang wasëpnaap Anutuu ngönte këët pöt pet yaalmë. ");
INSERT INTO wer_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Anutu pim wes mëën waisa pipop pim Pulö mangkën peö ëaup. Pötaanök pi Anutuu ngön këët ya. ");
INSERT INTO wer_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Anutu pi pim Ruup lup sant elmëak ngarangk elniipënëak omnant pout pim moresi mowia. ");
INSERT INTO wer_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Pötaanök namp pi Ruupön kön wi kosang wasëpna pöp wëwë kosangtak wakaim öpnaap. Namp pi Ruupë këm ngönta ënëm naën ëëpna pöp pi wëwëet naön ëëpnaap. Anutu pim ya këlangönte pim rangk wiakaim wiaapnaat. ");
INSERT INTO wer_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Akun pötak Parisi ngönën omnarö pit ngön nent epël kat wia. “Yesu pi omnarö kësang pan i momëën pim ënëm yesën Sonë ruurö il yemowas,” pël kat wia. ");
INSERT INTO wer_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Pöt Yesu pi won, pim ruurö tenimënt omnarö i momëeimaut. ");
INSERT INTO wer_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Pël ëën Yesu pi ngön pöt kat wiak ten Yutia yangerakaan kaip tiak kaalak Kalili yangerakël saut. ");
INSERT INTO wer_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Tenim kan sa pö Sameria yangerak oröak seëau. ");
INSERT INTO wer_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Pöök yesem Sameria yangerak ka naö Saika pël yamëëa pöök së oröaut. Ka pö Yakop pim ruup Yosep pim yang mena pöra naë wieëa. ");
INSERT INTO wer_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ka pöökë naë Yakop pim i öngöp ngaanëër tëau wieëa. Ten kan im Yesu koröpön ëën itaangkën këtëp luptak wëën i öngöp pöökë pourak wel aisëak kë yes. ");
INSERT INTO wer_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Kë yesem wëën pim ruurö ten ka pöökë omnaröa ngësë kaömp sum ëënëak saut. Pël ëën pimënt wëën Sameria kak pörekaan öng namp i kolöpënëak sa. Së pim naë oröa. Pël ëën pi öng pöpön iit nëmpënëak kimang mëëa. ");
INSERT INTO wer_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Pël maan öngöpök epël mëëa. “Ni Yuta omnampök yaanëp ne Sameria öngöppe. Tol ëënak neen i kimang yenëaan?” Pim mëëa pöt Yuta omnaröere Sameria omnarö pit omnant ngawi naën yeëa. Pötaanök mëëa. ");
INSERT INTO wer_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Pël maan Yesuuk epël ök mëëa. “Ni Anutuu omën ompyaut nimpna pöten ëwat wë omën niin i kimang yeniak epop neen ëwat wëën talte neen kimang neaan nook i omnaröa kol mangkën nak wëwë kosangta yaö sëpna pöt nimp.” ");
INSERT INTO wer_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Pël maan öngöpök epël mëëa. “Omën kaöap, ni i kepit wonöpök ëaanëp öngöp epö wali panëööp nim i won nasën yaaut yaan pipët tarëkaan öm? ");
INSERT INTO wer_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Tenim ëap Yakop puuk i öngöp epö tëak pimëntre pim ruuröere pim pol sëpsëpre purimakaö pörö neimau. Nuuk Yakop il mowesak i won nasën yaaut koiröm ma?” ");
INSERT INTO wer_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Pël maan Yesuuk kangiir epël mëëa. “Omën i öngöp epöökaan yena piporö pourö kaalak iiten ëëpnaarö. ");
INSERT INTO wer_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ën omën nook iit ningkën nënëërö kaalak iiten naëngan. I köloköta olaim wë pöl arim lupötë wieë pötë menmen eim wëën ar wëwë kosangtak önëërö.” ");
INSERT INTO wer_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Pël maan öngöpök epël mëëa. “Omën kaöap, i nim yaan pit nan. Pël ëën ne i pipët nak kaalak iiten naën ëëmaan. Pël ëak eprek wais yokola pöt sëp wasumaan.” ");
INSERT INTO wer_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Maan Yesuuk epël mëëa. “Ni së nim ompöp koirak epël waiseë.” ");
INSERT INTO wer_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Pël maan öngöpök epël mëëa. “Ne omp wonöp,” maan Yesuuk epël mëëa. “Nim omp wonöp yaan pipët yaap. ");
INSERT INTO wer_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ngaan ni omp mor nas waup. Pël ëaupök peene omp namp niiring wë pipop nim omp yaapöp won. Nim ngön yaan pit yaap.” ");
INSERT INTO wer_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Pël maan öngöpök epël mëëa. “Ne peene niin ëwat yes. Ni Anutuu tektek ngön yaaö namp. ");
INSERT INTO wer_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Tenim ëarö pit rosir epöök wais Anutuun yaya maimaurö. Ën ar Yuta omnaröak pöt epël yak. ‘Omnaröa yaya mapena pörek Yerusalem kak.’” ");
INSERT INTO wer_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Pël maan Yesuuk epël mëëa. “Öng epop, ni nem ngönte kat wiak kosang was. Akun nent orööpën sa. Pël ëak tiar rosir epöök wais nem Pepapön yaya nemangan. Ën Yerusalem kak sëeta yaya nemangan. ");
INSERT INTO wer_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ar omën arim köpëlötön yaya yamëëaurö. Ën ten Yuta omnarö pöt tenim ëwatötön yaya yamëëaurö. Pöt tol ëënak? Anutu pim omnarö utpetetakaan kama yewa ya pöt ten Yuta omnaröa naë oröa pötaanök. ");
INSERT INTO wer_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Akun nent temanöm sëpnaat ëa pöt yok oröa. Pël ëën omnarö piin yaap yaya yamëëaö pörö nem Pepapön pitëm lupötök yaap yaya mapnaat. Nem Pepap pi omën ke pëlöröaan kent yaaup. ");
INSERT INTO wer_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Anutu pi Pulö. Pötaanök omën piin yaya yamëëaurö pit lupötök yaap yaya map.” ");
INSERT INTO wer_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Pël maan öngöpök epël mëëa. “Ne ëwat wë. Yaö Mëëaup orööpnaap, pim yapinte Kristo. Pim orööpna akun pötak omën epot poutëët war wesak ök niapnaap.” ");
INSERT INTO wer_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Maan Yesuuk epël mëëa. “Ne tapöp, niiring ngönaak yak epop.” ");
INSERT INTO wer_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Yesuuk pël yamëem wëën pim ruurö ten kaalak së oröak pim öngöpring ngönaak yeëa pöten itenak yaan saut. Pël ëak nampök öngöpön, “Ni oröpmor ömëak yewaisën?” pël nemaan. Ën Yesuunta, “Oröp ëënak öng pipopring ngönaak yaan?” pöt nemaan ëaut. ");
INSERT INTO wer_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Pël ëën öng pöp i kepit pörek wiak kak së omnaröen epël ök mëëa. ");
INSERT INTO wer_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Waiseë. Itaampunëën. Omën namp e wais wë nem ngaan ëaö pöt poutön ök yenëa. Omën epop Anutuu Yaö Mëëaup, Kristo koröp.” ");
INSERT INTO wer_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Pël maan pit kakaan oröak Yesuu ngësë waisa. ");
INSERT INTO wer_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Akun pötak Yesuu ruurö tenök piin ke urak epël mëëaut. “Rë yanuulaup, ni kaömp në.” ");
INSERT INTO wer_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Pël maan pi epël yenia. “Ne nem kaömp ke nampöt wia pöten ar köpël wë.” ");
INSERT INTO wer_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Pël niaan ten ruurö neneren epël mëëaut. “Omën nampök kaömp nant wak wais mena koröp.” ");
INSERT INTO wer_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Pël yemaan Yesuuk epël yenia. “Nem kaömpöt epël. Nem wes nemëaupë ngönte ngaarëk wak pim ya ngön ëaut mëmpa pötak nem kaömpöt yaë. ");
INSERT INTO wer_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ar këëre kaömp önëak epël aim. ‘Ngoon kong nent won sëën këëre kaömp köp sëënak öpen,’ pël aim. Pël ëautak ne arën ök niamaan. Omnaröen iteneë. Arim këëre kaömp yewaul arök pit nemëën neweë. Nem omën nemëën öma akunet temanöm sa. ");
INSERT INTO wer_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ya omën namp këët yeön ya pepap pi sumat yemangk. Ök tapël ya omën namp nemëën wë pöp pi kangit mempaat. Pël ëën pim öpna pörö pit wëwë kosangtak öpnaat. Pötaanök omën yangëntaupre yewaup piarip pouwaar ërëpsawi ë yaë. ");
INSERT INTO wer_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Pötaanök ngaanëër omën namp pim ngön epël ëa pöt yaapët. ‘Omën namp pi ya ngëntën nampök këët yeö.’ ");
INSERT INTO wer_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ne arim ngaan ya mënak nangëntënrekëlök om këët önëëtaan wes yanimë. Ya pöt naröak mënak ngëntën kë oröaut. Ar om pep sak këët önëët.” ");
INSERT INTO wer_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Akun pötak Sameria omën kësang ka pöök wëaurö pit öng pöpë ngönte kat wiak Yesuun kön wi kosang wesa. Pöt öng pöp epël mëëa. “Pi nem ngaan ëaö pöt poutön ök yenëa.” ");
INSERT INTO wer_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Pël ëën Sameria omnarö pim naë wais pitring öpënëak yema. Pël ëën pi akun nentepar pitring wakaimaut. ");
INSERT INTO wer_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Pël ëën omën selap pimtë këmtakaan ngön kat wiak piin kön wi kosang wesak ");
INSERT INTO wer_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","öngöpön epël mëëa. “Ten nim ngön pëënte kat wiak omën epopön kön wi kosang newasën. Tenimtokta pim ngönte kat wiak epël kön yawi. ‘Omën epopök yangerakë omnarö utpetetakaan kama niöpnaap,’ pöt peene kön yawi.” ");
INSERT INTO wer_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Akun nentepar won sëën ten Kalili yangerakël saut. ");
INSERT INTO wer_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Pöt Yesu pimtok pimtëën wet rëak tekeri wesak epël ök ëa. “Tektek ngön yaaö namp pimtë kaare yangerak wëën omnaröak pi kaö nasën wë wesak piin yaya nemaan ë yaë.” ");
INSERT INTO wer_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Pël ëak Kalili yangerak së oröaut. Pël ëën Kalili omnarö pit Yesu piin itenak ërëpsawi yaë. Pöt wet rëak pit pourö Yerusalem kak Anutuu mait elmëa akun ngëëngktak wëën pi ya yamëngkën itena. Pötaanök pi sëën ngöntre kar yaalmë. ");
INSERT INTO wer_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ten Kena kak Kalili yangerak së oröaut. Pörek pimtë ngaan maan i yaaptak wain i sa pörek. Pël ëën kak pörekë naë Kapaneam kak pörek yang ngarangkëp pim ya omën nampë yokotup yauman wieëa. ");
INSERT INTO wer_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Pël ëën pöp pi Yesu pim Yutia yanger sëp wesak Kalili yangerak së yaarö pöt kat wiak pim naë wais oröak epël kimang yema. “Nem yokotup yauman kaö panë yeem wel wiipënëak yaë. Pötaanök ni tepër së nem yokotup ompyaö wasumëak yewais.” ");
INSERT INTO wer_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Pël maan Yesuuk epël yema. “Ar retëng it köpëlöt arim itöök pet naalniin ëën pöt kön wi kosang newasën ëënëërö.” ");
INSERT INTO wer_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Pël maan omën pöpök epël yema. “Kaöap, teënt pan sëpa, nem yokotup wel wiipanok.” ");
INSERT INTO wer_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Pël maan Yesuuk epël yema. “Ni së, nim yokotup öp wëërek.” Pël maan omnamp Yesuu ngönte wa yaap wesak kaalak kakë yes. ");
INSERT INTO wer_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Pël ëak pi kan kourak yesën pim inëën ruurö së koirak epël ök mëëa. “Nim yokotup yok öp sak wë.” ");
INSERT INTO wer_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Pël maan pi pitën akun taltak ompyaö sa pöten pëlpël maan pit epël mëëa. “Kusi, kët luptak wëën pim koröp es nga pöt won sa.” ");
INSERT INTO wer_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Pël maan pepap pi pimënt epël kön wia. “Akun taptak Yesuuk neen, ‘Nim yokotup yok öp öpnaap,’ pël neeautep.” Pël ëak piire pimorö Yesuun kön wi kosang wesa. ");
INSERT INTO wer_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yesu pi Yutia yangerakaan Kalili yangerak së oröak retëng weëre kosang pipët kaalak ëën nentepar pël saut. ");
INSERT INTO wer_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Wë akun nentak Yuta omnarö pitëm akun ngëëngk nent temanöm sëën ten Yesu piiring Yerusalem kakë saut. ");
INSERT INTO wer_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Yerusalem kak naë sëpsëpöröa ka kanra ëöök i kaö nent Yuta ngöntak Petesta pël yamëëaut wieëa, pöta ëöök kët kosöp ka mor nas wieëa. ");
INSERT INTO wer_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ka pötë omën yauman ke nentere nent yaaurö, it ngaap saare ing il tëaöre omën kël wëëre pël ëaurö wë i kaö ëtëp elmëëpënëak kor wakaima. ");
INSERT INTO wer_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Akun nantë Aköp pim ensel namp wes mëën wais i kaö ëtëp elmëën ëtëp yaëën omën wet rëak ilapna pöp pim yaumante won sëpnaat. ");
INSERT INTO wer_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Pël ë yaaurek omën namp kët kosöp ka nentak wieëa. Pi yauman eim wëën akun wali pan krismaki 38 pël won saup wieëa. ");
INSERT INTO wer_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesu pi omën pöp ka uraan itenak akun wali yauman eimaup pöten ëwat wë omnampön epël yema. “Nim yaumante won sëpënëak kent saan ma?” ");
INSERT INTO wer_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Pël maan yauman omnampök epël yema. “Kaöap, i kaö ëtëp yaëënaar omën namp wa neulëpnaap won. Nemtok sumaat pangk naën ëak ilamëak yaëën wet rëak saupök il yenewas.” ");
INSERT INTO wer_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Pël maan Yesuuk epël yema. “Ni wal ë tauak nim korumönte wak kan së.” ");
INSERT INTO wer_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Pël maan tapëtakëër ompyaö sak pim urte wak kan yes. Yesu pim omnamp ompyaö mowesa akun pöt kë yesa akunetak ëa. ");
INSERT INTO wer_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Pötaan Yuta omën kaöaröak omën ompyaö mowesa pöpön epël mëëa. “Peene akun epët kë yesa akunet. Nim korumönte ömë pötaan nga wia.” ");
INSERT INTO wer_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Pël maan omën ompyaö sa pöpök pitën epël mëëa. “Omën nem ompyaö newesaupök nem korumönte wak sum pël neeautep.” ");
INSERT INTO wer_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Pël maan pit epël pëël mëëa. “Omën talëpök nim korumönte wak sum pël yenia?” ");
INSERT INTO wer_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Pël maan omën ompyaö sa pöp omën tok kësang ëaan Yesu omën pöröak irikor ëak yesën köpël ëak ëngk ma e wesa. ");
INSERT INTO wer_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ënëmak Yesu pi Anutuu ngönën tup kaöetak së omën pöp koirak epël yema. “Ni ompyaö saupök kaalak utpetat ëënganok. Pël ëëmë pöt omën könöm nant nim yaumante il niwasëpna pöt nim naë orööpnaat.” ");
INSERT INTO wer_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Pël maan omën ompyaö mowesa pöp Yuta kaöaröa naë së epël mëëa. “Omën ne ompyaö newesa pöp Yesuuk ëa.” ");
INSERT INTO wer_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Pël maan Yuta kaöarö pit pöten kat wiak kë yesa akunetak Yesuuk omnamp këëkë mowesa pötaanök pörek ngës rëak kööre tok elmëak mëmpënëak kent wia. ");
INSERT INTO wer_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Pël ëën Yesuuk kangiir epël mëëa. “Nem Pepap pi akun poutë ya yamëngkaup. Pötaanök ne ök tapël yeë.” ");
INSERT INTO wer_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Pël maan Yuta kaöarö pit akun pötak Yesu mëmpënëak nga kup ria. Pöt pi pitëm ngön kosang wiaut ilap riak kë yesautak ëa pötaanök. Pi Anutu pim Pep panëëp yamëem Anutuu ök sak pimtëën omnaröen pet elmëa. Pötaanök pit pouteparëën pi mëmpënëak ngön ë kosang wesa. ");
INSERT INTO wer_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesu pi kangiir yema. “Ne yaap pan niamaan. Ruup ne nemtë könöök omën nant naëngan. Nem Pepap yamëngkën iteempa pöt mëmpaat. Pötaanök omnant nem yeë epot nem Pepap yaëënak ök yeë. ");
INSERT INTO wer_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Nem Pepap ne pim Ruupön kent ëak pimtë omnant yamëngka pout neen pet elnëeim wë. Pël ëak kaalak munt kësang nant pet elnëën pöt epot il wesak mëmpa pötön ar yaan sënëët. ");
INSERT INTO wer_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Nem Pepap pi omën wel wiaurö wal ë moulmëak wëwë yemengkaupök tapël Ruup neenta nem kentöök omën narö wëwë yemengkaup. ");
INSERT INTO wer_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Nem Pepap pi omnarö ngön yaatak kom naalmëën yaaup. Ngön ya yamëngka pöt pout ne nenaut. ");
INSERT INTO wer_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Pötaanök omën narö Pepen yaya mapnaarö, ök tapël Ruup neenta yaya neapnaat. Ën omën Ruup neen yaya nenëaan ëëpnaarö pit Pep nem wes nemëaup piinta yaya nemaan ëëpnaat. ");
INSERT INTO wer_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Ne yaap pan arën niamaan. Omën namp nem ngönte kat wiak nem wes nemëaup piin kön wi kosang wasëpnaap pi wëwë kosangtak öpnaap. Ne pi ngön yaatak naulmëëngan. Pi yok wel yawiaurek sëp wesak peene wëwë kosangtak wë. ");
INSERT INTO wer_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ne yaap pan arën niamaan. Akun orööpënëak ëa pöt yaarö. Pötaanök omën wëwë kosangtak naön lup wel wiaurö pit peene Anutuu Ruup nem ngönte kat wiipnaat. Pël ëak këëkë kat wiipna pörö wëwëeta öngpök ilapnaan. ");
INSERT INTO wer_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Nem Pepap pi wëwëeta songönte. Pötaanök pi pim Ruup ne elnëën neenta wëwëeta songön saup. ");
INSERT INTO wer_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ne Omën Këëp. Pötaanök ar omnarö ngön ya mënak kom elniimëak weëre kosang nenaup. ");
INSERT INTO wer_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ar epëten yaan sak ëëngan. Akunet temanöm yesën omën wel yangaöök wieëaö pourö nem ngönte kat wiak ");
INSERT INTO wer_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","wal ëëpnaat. Omën ompyaö ëaurö pit wal ëak wëwëetak öpnaan. Ën omën utpetatringörö pit wal ëak nem naë ngön ya mëmpnaat.” ");
INSERT INTO wer_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Pël mëak Yesu pi kaalak epël yema. “Ne omën nant nemtë könöök naëngan. Nem Pepapök ëëmëak neea pöl ne omnarö ngön ya yemomëngk. Nem ngön ya yamëngk pöt wotpil panë yeë. Pöt ne nemtë könöök naën, wes nemëaup pim könöök yeë. ");
INSERT INTO wer_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Nem ngön ök yeniak epot nemtë könöökaan nemtok nga ilak yeniak talte ar kat wiak yaap ma kaar wasënëët. ");
INSERT INTO wer_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Nem Pepapök nem songönte aan yaap ëëpnaat. ");
INSERT INTO wer_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ar ngaan omën narö Sonë naë wes mëën pëël maan puuk nem ya yamëngkautaan ngön këët ök mëëa. ");
INSERT INTO wer_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Nem Pepapök nem songönte ök yaaup yak omën nampök nem songönte ök apëna pötaan ne kön selap naën. Pël yeëetak ar neen kön wi kosang wasën Anutuuk ar utpetatë öngpökaan niöpënëak Sonë nemëën ök niia pöt kön wiinëak ök yeniak. ");
INSERT INTO wer_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Son pi kalaötë rangiak ëwa yeë pöl omnarö ar ëwa elniin akun kot nent ëwa pöön ërëpsawi ëan. ");
INSERT INTO wer_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ar nem songönte ëwat sënëak omën munt nantök pet yaalni. Omën weëre kosang pöt Sonë neekël utak niia pöt il yewas. Omën epot pout mëmpö së mën pet irumëak Pepak neeaut. Pötaanök nem ya yamëngk epot pimtok omnaröen nem songönte pet yaalni. Pël ëën ar itenak neen, ‘Pi Pepapök wes mëën irëa,’ pöt kön wiinëët. ");
INSERT INTO wer_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Pep, nem wes nemëaup, pimtok nem songönte tekeri wes nina. Ar pim këmtakaan ngön kot nent kat wiire ë kos iteempö pël naënörö. ");
INSERT INTO wer_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Pël ëak pim ngönte arim naë wi naön. Pöt ar Pepak wes mëaup nemëën kön wi kosang newasën yeë. ");
INSERT INTO wer_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ar wëwë kosangtak önëak ngönën pepeweri ngön wia pipot pout sangk kelak kat yawiaurö. Ngön pipotök nem songönte war wes yaningk. ");
INSERT INTO wer_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Pël yaëënak arökëër nem naë wais wëwëet önë pötaan kaaö yeë. ");
INSERT INTO wer_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Ne omnaröak yaya neapnakök naën. ");
INSERT INTO wer_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ën arën ne ëwat wë. Arim lupöt Anutuun rë noolaan wë. ");
INSERT INTO wer_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nemtok nem könöök newaisën. Nem Pepapök wes nemëën waisën ar ne sant newesak nem ngönte ngar naön yeë. Ën omën namp pim könöök waisëpna pöpökëër ar pi sant mowesak pim ngönte kat wiinëët. ");
INSERT INTO wer_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ar arimtok arimtëën neneraan yaya aimeë Anutu kopëtapök yaya niapnaaten kaaö yaauröak tol ëak Anutuun kön wi kosang wasën? ");
INSERT INTO wer_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Arök nook Pepa naë arimëën ngön ya mëmpaat wasngan. Moses pim ngön kosang retëng ëaut wia pipotök ar ngön yaatak niulëëpnaat. Moses pim ngön kosang retëng ëa pötök, ‘Tiar kaamök elniipnaat,’ pël yewas. Pël naëpan. ");
INSERT INTO wer_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Moses pim ngön retëng ëa pipot nemëën retëng ëaut. Pötaanök ar pim ngön pout kat wiak kosang wesan talte nemotta tapël kat wiak kosang wasën. ");
INSERT INTO wer_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ar pim ngön retëng ëa pöt kat wiak kosang newasën ëauröep tol ëak nemotta kosang wasën?” ");
INSERT INTO wer_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","4","Yesu pi ngön pit më pet irak wë Anutuu mait elmëa akun ngëëngk pöt temanöm yesën, Kalili i kaö yapin nent Taipirias pöökë we naöökël saut. Pël ëën omën selap pan pi yauman omnarö ompyaö yemowasën itenaurö yak pim ënëm waisa. Pël ëën ten Yesu pim ruuröaring rosir naöök is wel aisëak ");
INSERT INTO wer_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","itaangkën omën kësang pan yewaisën Yesuuk Pilipön epël yema. “Omën selap eporö kaömp tarëkaan wak mangkën pangk ëëpën?” ");
INSERT INTO wer_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Pöt pimënt pöp pim ëëpnaat kön wieëak Pilipön ököök mëëa. ");
INSERT INTO wer_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pël maan Pilipök epël yema. “Tiar yok pangk mon kësang 200 kina pöta kön kaömp sum ëak mempenaatep pöteta omnarö pangk naëpan sa.” ");
INSERT INTO wer_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Pël maan Yesuu ru namp Entru, Saimon Pita pim nangapök Yesuun epël yema. ");
INSERT INTO wer_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Yokot omp ulwas namp e wë epop pim naë kaömp kotut mor nas ën i kaö imën kot naar pël ëaap epteparök tiar omën selap eporö pangk naëpan sa.” ");
INSERT INTO wer_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Pël maan Yesu itna pöt nön kësang naö wieëa. Pël ëën ten pim ruuröen epël yenia. “Ar omnaröen wel aisapën maë.” Pël niaan omnaröen maan wel aisëa. Omp pörö kësang pan 5000. ");
INSERT INTO wer_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Pël ëën Yesuuk kaömp pöt wak Anutuun yowe mëak mampö së pet irak kaalak i kaö imënaar wak tapël ëak mangkën pangk ëa. ");
INSERT INTO wer_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Pël ëën pit na pet irën Yesu pi ten pim ruuröen epël yenia. “Ar kaömp yenem kaö olëa epot wieë utpet ëëpanok wa top ëeë.” ");
INSERT INTO wer_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Pël niaan ten kaömp mor nas pöteparë kaut wa top ëak kër 12 pötë waulön peö ëaut. ");
INSERT INTO wer_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Omnarö pit pim retëng ëa pöten itenak epël yema. “Omën epop Anutuu tektek ngön yaaö kaöap tiarim kor wakaima pöp yangerak orööpnaat pël aan kat wia tapöp.” ");
INSERT INTO wer_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Pël mëak pit Yesu moröak pitëm kaö was ulmëëpënëak yaëën pimënt itenak kaalak rosiraöökë sa. ");
INSERT INTO wer_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Wiap kan kët yeilaan Yesuu ruurö ten i kaö ëöökël ngemëaut. ");
INSERT INTO wer_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Pël ëak pörek oröak wëën Yesu newaisën wiaan koö olaan ruurö tenimënt wangaöök ilëak Kapaneam kakël saut. ");
INSERT INTO wer_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Pël ëak yesën kent kësangpel yamöön kaö maat kësang panë yamöa. ");
INSERT INTO wer_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Pël ëën ten kaö ma ilë luptak 7 ma 8 kilomita pöta ök yesem itaangkën Yesu pi i kaöökë roro wangaöökë naë yewaisën ten itenak kas ëaut. ");
INSERT INTO wer_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Pël ëën Yesuuk epël yenia. “Nemtok yeëerek kas ëëngan,” pël yenia. ");
INSERT INTO wer_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Pël ëën ten pi wangaöök wa moulmëënëak yaëën tapëtakëër tenimtë san pörek yaarö. ");
INSERT INTO wer_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ëlpamök omnarö i kaöökë ëngk komuntakël wëën sa pörö pit wal ë Yesuun ap wesak epël mëëa. “Kusi rö kan wang kopëtaö wiaan iteengk pöök Yesu om wëën pim ruurö pitëmënt saut.” ");
INSERT INTO wer_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Pël yamëem wëën Taipirias kakëlaan wang nant kusiitak Yesu pim kaömp Anutuun yowe mëak omnarö mangkën na pörek së oröa. ");
INSERT INTO wer_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Pël ëën omën Yesu pim kaömp mangkën na pörö pit itaangkën Yesure pim ruurö ten pitëm naë won. Pël ëën wang nantë ilëak Yesuun ap wasö Kapaneam kakë waisa. ");
INSERT INTO wer_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Pörek wais i kaöökë ëngk komuntak Yesu koirak epël yema. “Rë yanuulaup, ni taan epël waisaup?” ");
INSERT INTO wer_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Pël maan Yesu pi kangiir epël yema. “Ne yaap pan niamaan. Ar nem retëng weëre kosangring pet elniin itenan pötaan won, om kaömpöt ningkën nëën kep elnia pötaan pëën neen ap wasö waisan. ");
INSERT INTO wer_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ar kaömp lëngë sasa yangerakë epëtaan pëën ya kaö mëngkanok. Kaömp munt arim nak wëwë kosangtak önë pötaan weë ngentiak ya mëmpun. Kaömp pöt Omën Këëp nook ar nimpaat. Pöt nem Pepap Anutu puuk ne wëwë kosangët nimpëak yaaö neeaö pöt tekeri wesa. Pötaanök nook ningkën nak wëwë kosangtak önëët.” ");
INSERT INTO wer_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Pël maan pit epël yema. “Ten tol ëak Anutu pim yaat mëmpun?” ");
INSERT INTO wer_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Pël yemaan Yesuuk kangiir pitën epël yema. “Anutu pim yaat mëmpunëak pöt pim wes mëën waisaup neen kön wi kosang wasënëët.” ");
INSERT INTO wer_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Pël maan pit kangiir ngön epël yema. “Ni retëng talte yaëën ten itenak nim ngönte kön wi kosang niwasën? Ma ni ya oröpët mëmpëëp? ");
INSERT INTO wer_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Tiarim ëarö yang pultak imeë kaömp mana pëënë neima. Pöt ngönëntak epël retëng ëa. ‘Pi pit nëmpënëak kutömweriaan kaömp meneima.’” ");
INSERT INTO wer_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Pël mëak Yesu pi kaalak epël yema. “Ne yaap pan niamaan. Moses pi kutöm kaömpöt nemangkën eima. Nem Pepapök kutöm kaömp yaapöt yaningk. ");
INSERT INTO wer_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Kaömp Anutu pim yaningk epët kutömweriaan irëaut. Pötaan omën pourö nak wëwë koirënëak irëaut.” ");
INSERT INTO wer_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Pël maan pit epël yema. “Kaöap, ni kaömp epët kët poutë ten nineim öm.” ");
INSERT INTO wer_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Pël maan Yesuuk kangiir epël yema. “Nemënt tapöpök arim wëwë koirënë pöta kaömpët. Pötaanök omën namp nem naë waisëpnaap pi kaalak këën naëpan. Ën namp pi neen kön wi kosang newasëpna pöp pi iitenta naëpanëëp. ");
INSERT INTO wer_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ne arën epël niiaut. Ar nem yaautön iteneëak kön wi kosang nenewasën yeë. ");
INSERT INTO wer_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Omën pourö Pepak nem ngësël waisënëak niiaurö nem ngësë waisënëët. Pël ëën nem naë waisën nook yok pangk ke nanuurngan. Won pan. ");
INSERT INTO wer_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ne nemtë könöök ya mëmpëak kutömweriaan neiraan. Nem wes nemëaup pim könöök ya mëmpëak yangerak wes nemëën irëaut. ");
INSERT INTO wer_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Pötaanök omën wes nemëaupë kentöök epël ya. Omën nemëën nenaö pörö namp il nanimëëngan, won. Akun kaöaöök nenaul wal ë niulëëmaat. ");
INSERT INTO wer_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Nem Pepapë kentöök epël ya. Omën narö it këëkë nengënak ne Anutuu Ruup pöt kön wi kosang newasënëërö ar wëwë kosangtak önëërö. Pël ëën akun kaöaöök nook ar wal ë niulëëmaat.” ");
INSERT INTO wer_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Yesu pi pimtok pimtëën, “Ne kaömp tapët kutömweriaan irëaup,” wet rëak pël mëëa. Pötaanök Yuta omnarö pit piin ya sangën ëak pimëën kaaö ngön mëëa. ");
INSERT INTO wer_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Pit neneren epël mëëa. “Omën epop Yesu, Yosepë ruuppe. Tiar pim ëlre pepaarën ëwat wëep. Pi tol ëënak, ‘Ne kutömweriaan irëaup,’ pël ya?” ");
INSERT INTO wer_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Pël yemaan Yesuuk epël yema. “Arimënt neneren kaaö ngön mangan. ");
INSERT INTO wer_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Omën namp pi pim könöök nem ngësë newaispan. Nem Pepapök mök ë momëënak nem ngësë waisëpnaat. Pël ëën nook akun kaöaöök wal ë moulmëën wëwëetak öpnaat. ");
INSERT INTO wer_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Anutuu tektek ngön yaaurö pitök nem ngësël waisëpnaaröaan wesak ngön nent ngönëntak epël retëng ëaut. ‘Anutu pi omën pourö rë niulöpnaat.’ Pël ëën omën narö Pepa ngönte kat wiak ëwat sënë pörö nem naë waisënëët. ");
INSERT INTO wer_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Arim naëaan nampök nem Pepapön itnaangkënörö. Anutuuk wes nemëaup nookëër nem Pepapön itenaup. ");
INSERT INTO wer_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ne yaap pan niamaan. Namp pi neen kön wi kosang newasëpnaap pi wëwë kosangtak öpnaap. ");
INSERT INTO wer_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nemënt kopët tapöpök arim wëwë koirënë pöta kaömpët. ");
INSERT INTO wer_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ngaanëër arim ëarö pit yang pultak kaömp mana pëënöt neimeë ulöp sak wel wi saurö. ");
INSERT INTO wer_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ën kutömweriaan kaömp nak kö nasënganëët nem naë epët. ");
INSERT INTO wer_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Wëwë kosangta kaömp epët kutömweriaan irëaut. Pötaanök narö ar kaömp pöt nënë pörö wëwë koirënëët. Nem kaömp ar nimpa pöt nemtë mësëpët yangerakë omnarö wëwë koirënëëtaan nimpaat.” ");
INSERT INTO wer_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Pël maan Yuta omnarö pit pitëmënt neneren epël mëak ngön nga yaal. “Omën epop pi tol ëak pim mësëpët tiar ningkën nëmpenëak ya?” ");
INSERT INTO wer_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Pël yemaan Yesuuk kangiir epël yema. “Ne yaap pan niamaan. Ar Omën Këëp nem mësëpët nëëre nem iit në pël naën ëënë pöt wëwëetak naön ëënëët. ");
INSERT INTO wer_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Omën nem iire mësëp nënë pörö ar wëwë kosangtak wëën ënëm akun kaöaöök wal ë niulëëmaarö. ");
INSERT INTO wer_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Pöt tol ëënak wasnganok. Yangerakë kaömp pöt kaömp pasut. Ën nem mësëp epët kaömp panëët, i epët i kë panëët. ");
INSERT INTO wer_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Pötaanök omën narö ar nem iire mësëp pöt në seim önë pörö ar neering wëën ne arring wakaim ömaat. ");
INSERT INTO wer_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Nem Pep wëwë pepapök wes nemëën irëaut. Pötaanök ne pim wëwëetakël wëaup. Ök tapël omën ne neneim önëërö ar nem wëwëetakël wakaim önëët. ");
INSERT INTO wer_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Kaömp kutömweriaan irëa epët arim ëaröa ngaan yang pultak neimeë ulöp sak wel wieima pötaat won. Omën narö kaömp epët nënë pörö akun wali pan wëwëetaring wakaim önëët.” ");
INSERT INTO wer_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu pi Kapaneam kak wë Yuta omnaröa ngönën tupta kakaati ngön pipot ök mëak rë mouleima. ");
INSERT INTO wer_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Pël maan Yesuu ënëm yaaö narö pit ngön pipot kat wiak neneren epël yema. “Ngön epot könöm yesëp. Talëp kat wiipën?” ");
INSERT INTO wer_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Pitëmënt neneren kaaö ngön yemaan Yesu pimtë könöök itenak epël yema. “Ar ngön pipot kat wiin utpet yaë ma? ");
INSERT INTO wer_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ma ar itenaan Omën Këëp ne nem ka songöntakë kaalak isën pöt tol ëënëërö? ");
INSERT INTO wer_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Pulöök tiar wëwëat yaningk. Omnaröa weëre kosangöök yok pangk pël naëpan. Nem ngön ök yeniak epot kat wiak kosang wasën Pulöök arring wëën wëwëetaring önëët. ");
INSERT INTO wer_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pël ëënëëtak arim tekrakaan omën narö pit kön wi kosang newasën eim.” Pël mëëa pöt Yesu pi omën pimëën kön wi kosang newasën ëëpnaaröere ën pimëën kup mowiipna pöpön wet rëak ëwat wëa. ");
INSERT INTO wer_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Pël mëak yal menak epël yema. “Songön pi taptaanök epël niiaut. ‘Omën narö nem Pepapök kan mowasëpnaarö pitëmënt nem ngësël waisëpnaat,’ pël niiaut.” ");
INSERT INTO wer_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Yesu ngön pötaan pim ënëm yaaö narö selap pit pi sëp mowesak sa, piiring kaal wak naën. ");
INSERT INTO wer_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Pël ëën Yesuuk ten pim ru 12 pöröen epël pëël yenia. “Arta sëp newesak sën ma?” ");
INSERT INTO wer_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Pël niaan Saimon Pita puuk epël yema. “Aköp ten talëpë ngësë sën? Ten nimtë ngöntakaan wëwë kosangët yeö. ");
INSERT INTO wer_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Pël niaimeë ten niin kön wi kosang wesak ni Anutu pim omën ngëëngkëp pël yaniwas.” ");
INSERT INTO wer_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Pël maan Yesuuk kangiir epël yenia. “Ne ar yokot 12 ëak wa niulëaut. Tol ëënak arim naëaan namp Setenë ënëm yeë?” ");
INSERT INTO wer_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Pël niia pöt pi Yutas, Saimon Keriot kakaanëp pim yokotup piinök niia. Pi Yesu pim ru 12 pörö tenëkaan namp pi pöpök wë ënëmak Yesuun kup mowiipnaap. ");
INSERT INTO wer_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Wë ënëmak Yesu pi kaalak Yutia yangerakël sëpnaaten kaaö ëën Kalili yangerakël sa. Pöt Yuta ngarangköröak pi mëmpënëak nga wëën kat wiak nasën ëa. ");
INSERT INTO wer_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Yuta omnarö akun ngëëngk nent wiire këra ëp ka yaaö akun nent temanöm yesën ");
INSERT INTO wer_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","pim nangaröak epël ök yema. “Ni kak eprek sëp wesak Yutia yangerakël së. Pël ëak retëng nant yaëën nim ruurö itaampnaan. ");
INSERT INTO wer_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Omën namp pi pim yaautön omnarö itenak kent ëëpënëak pöt ëlëëp naën yaaup. Ni retëng weëre kosangringöt yaaup. Pötaanök pitëm tekrak së wë yoolök pël yaëën omën pourö it ningampnaan.” ");
INSERT INTO wer_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Pim nangarö pitta piin kön wi kosang nemowasën. Pötaan pël yema. ");
INSERT INTO wer_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Pël maan Yesuuk kangiir epël yema. “Arimtokëër akun pasutë ëënëët. Ën ne pöt nem ya yamëngkaut pet elmëëma akun pöt ngolöp yaë. ");
INSERT INTO wer_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Omën ngönën wonörö pit arimëën yok pangk kööre tok naalniipan. Pit nemëënökëër kööre tok yaalnëaurö. Pöt nook pitëm utpet yaaut war wesak yemak. Pötaanök nemëën kööre tok elnë yaë. ");
INSERT INTO wer_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Pötaanök arökëër tiarim akun ngëëngk pipten itaampunëën seë. Ën ne pöt nem ya yamëngkaut pet elmëëma akunet ngolöp yaëërek peene nasëngan.” ");
INSERT INTO wer_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Pël mëak Yesu pi Kalili yangerak om wakaima. ");
INSERT INTO wer_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Wëën nangarö wet rëak wa topöök së wëën ënëmak sa. Omnarö itaampanëak ëlëëp sa. ");
INSERT INTO wer_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Pël ëën Yuta ngarangkörö pit wa topöökë öngpök ap wasën won ëën epël mëëa. “Omën pöp tarëk wë?” ");
INSERT INTO wer_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Pël yemaan omnarö pit pimëën ngön laaök neneren naröak, “Ompyaö yaaup,” pël yemaan naröak, “Won, pi omnarö lup wa irikor yaalmëaup,” pël mëëa. ");
INSERT INTO wer_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pöt pit Yuta kaöaröen kas ëën ngaarëk wesak naën ëlëëp pitëmënt pël ëa. ");
INSERT INTO wer_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Akun ngëëngk pöta luptak Yesu pi Anutuu ngönën tup kaöeta kakaati së omnaröen ngönën ök yema. ");
INSERT INTO wer_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Pël ëën Yuta ngarangkörö pit yaan sak epël mëëa. “Omën epop tiarim pep kaatak neilaanëppe. Pi tol ëak pepeweriaan ngönën songön ëwat sak ök ya?” ");
INSERT INTO wer_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Pël maan Yesuuk kangiir epël yema. “Nem ngön arën ök yeniak epot nemtëët won. Anutuu ngönötök ök yeniak puuk ne wes nemëën waisaut. ");
INSERT INTO wer_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Pötaanök narö ar Anutuu këm ngönta ënëm ëënë pörö nem ngön ök yak epotë songönöt ëwat sënëët. Pël ëak ar nemtok rëak yeëan ma Anutuuk ök neaan yeëan pöt ëwat sënëët. ");
INSERT INTO wer_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Omën namp pimtë könöökaan apna pöp pimtok pimtëën koröp ngar wak apnaat. Ën omën namp pi pim wes mëaupë yayaat orööpënëak ya mëmpëna pöpön korar won, wotpil yaë pël mapnaat. ");
INSERT INTO wer_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ngaanëër Moses puuk ngön kosang retëng ëaut wiaan ngar naön yaaurö. Tol ëënak ne nempunëak yeë?” ");
INSERT INTO wer_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Pël maan omnaröak kangiir epël yema. “Urmerap nim lupmeri ilëak wëën kaökaö saup. Talëpök ni nimpënëak yaë?” ");
INSERT INTO wer_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Pël maan Yesu pi epël yema. “Ne kë yesa akun ngëëngktak retëng weëre kosang kopëtet ëën ar yaan sak yeë. ");
INSERT INTO wer_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moses puuk arim yokoturöa koröp kaut ilënëak niia pipët yaap Mosesök nga ilak neniaan. Ngaanëër arim ëaröak ngës rëaut. Pël ëautak Moses puuk rangk niaan kë yesaö akunatë arim yokoturöa koröp kaut ileim yeë. ");
INSERT INTO wer_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ar Moses pim ngön kosangöt ilap ringanëak kön wieimeë arim yokoturö kë yesa akunatë pitëm koröp kaut il yeë. Pël yaauröak oröp ëën kë yesa akunetak nook omën yauman wiakaima namp ompyaö yemowas pötaan nemëën ya sangën yeë? ");
INSERT INTO wer_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ar itöök itneë ngön köntak angan. Omnant ompyaö wesak kön wi sokolak wotpil kanöökël ë pël ëeë.” ");
INSERT INTO wer_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Yerusalem kakaan omën naröak epël yema. “Omën mëmpënëak aim pöp e tapöp. ");
INSERT INTO wer_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Iteneë. Pi yoolök wë ngön ök yeniaan omën kaöaröak pit ke urak nemaan yaëëp. Ma pit kön wiin pi Anutuu Yaö Mëëaup, Kristo tapöp yaë ma? ");
INSERT INTO wer_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Pël ëaap tiar pim ka songönten ëwat wë. Pi Anutuu Yaö Mëëaup Kristo ëanëën tiar pim ka songönten köpël ëan tapön.” ");
INSERT INTO wer_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Pël maan Yesu pi ngönën tup kaöetak ngönën ök yamëem ngön ëak epël yema. “Ar yaap neen ëwat wë, nem ka songöntenta ëwat wë ma? Ar pël naën yeëetak ne nem könöök newaisënëp. Nem Pepapök wes nemëën waisaup. Pi këëp. Ar piin köpël wë. ");
INSERT INTO wer_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ën ne piin ëwat wë. Pöt ne ngaan piiring wakaimaupök puuk wes nemëën waisaup.” ");
INSERT INTO wer_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Pël maan pit wii motëëpënëak kön wiin mor könöm ëa. Pöt pim mëngkën wel wiipna akunet temanöm nasën ngolöp yaëën yak mor könöm ëën sëp wesa. ");
INSERT INTO wer_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Pël ëën omën selap piin kön wi kosang wesak epël mëëa. “Omën epop Anutuu Yaö Mëëaup, Kristo tapöp koröp. Omën munt nampök ënëm oröak pim retëng yaë epot il nemowaspan sa.” ");
INSERT INTO wer_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Omnarö ngön laaök pël yemaan Parisi ngönën omnarö kat wiak kiri ar yaaö kaöaröen ök maan polis narö Yesu wak wii tëëpënëak wes mëën sa. ");
INSERT INTO wer_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Pël ëën Yesuuk epël yema. “Akun kot nent ne arring wë olëak kaalak nem wes nemëën waisaupë ngësë sumaap. ");
INSERT INTO wer_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Pël ëën arök yok pangk ngaöl ë wais ne koirak itnaangkan. Ma nem öma pörekta ar pangk newaisngan.” ");
INSERT INTO wer_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Pël maan Yuta kaöarö pitëmënt neneren epël mëëa. “Pi talël sëën tiar ngaöl ëëpenaaten ya? Ma tiarim kar Krik omnaröaring wëaurö pitëm naë së Krik omnarö rë moulöpënëak ya ma? ");
INSERT INTO wer_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Pi, ‘Ngaöl elnëënëëtak yok pangk koirak itnaangkan,’ pël niak kaalak, ‘Nem së öma pörek ar yok pangk newaisngan,’ pël yenia epëtep, tol ëënak yenia?” ");
INSERT INTO wer_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Yuta omnarö pitëm akun ngëëngkët wieë pet irëpënëak temanöm yesën akun nent ngëëngk wesak wa top kaö yeëa. Akun pötak Yesu pitëm tekrak wal ë ngön ëak epël yema. “Omën namp iiten ëën pöt wais nem naëaan iit nëmpnaat. ");
INSERT INTO wer_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Anutuu ngönëntak wia pöl, ‘Omën narö neen kön wi kosang newasëpnaarö i yaapötë kölok olaim wë pöl pitëkaan wëwë kosangët oröeim öpnaat.’” ");
INSERT INTO wer_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesu pim ngön mëëa pipët Pulöön kön wieëak mëëa. Pi Pul pö omën piin kön wi kosang wasëpna pöröaan wes mëën pitëk ilapnaat weseëak mëëa. Akun pötak Yesu pi pim ë rangi urtak nawisën wiaan Pulö neiraan. Pötaanök mëëa. ");
INSERT INTO wer_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Pël maan omën narö pöten kat wiak epël mëëa. “Omën epop pi yaap Anutu pim tektek ngön yaaup tiarim kor wakaim pöp.” ");
INSERT INTO wer_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Pël yemaan naröak epël mëëa. “Epop Yaö Mëëaup, Kristo tapöp.” Pël maan naröak epël mëëa. “Kristo puuk pöt Kalili yangerakaan newaispan. ");
INSERT INTO wer_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ngönëntak epël wia. ‘Kristo pöp Tewit pim kurmentëkaan orööpnaap. Pötaanök Tewit pim wakaimaurek Petelem pörek orööpnaat,’ pël ëaut.” ");
INSERT INTO wer_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Pël maan omnarö pit komkap ëën tok nentepar sa. ");
INSERT INTO wer_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Pël ëak naröak Yesu wii motëëpënëak kön wiin mor könöm ëën sëp wesa. ");
INSERT INTO wer_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Polisörö pit kaalak së Parisi ngönën omnaröere kiri ar yaaö kaöaröa naë oröön, “Ar tol ëënak pi koirak newaisën yeë?” pël mëëa. ");
INSERT INTO wer_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Pël maan polisörö pit kangiir epël mëëa. “Ngaan omën epopë ngön ya epël naënte.” ");
INSERT INTO wer_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Pël maan Parisi ngönën omnarö pit epël mëëa. “Pi arënta morök elnia ma? ");
INSERT INTO wer_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ten Parisiire ngönënë kaöarö nampökta piin kön wi kosang yemowas ma? Won. ");
INSERT INTO wer_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Omën ngön kosang wiaut köpël piporö Yesuuk morök elmëën piin kön wi kosang wesa pörö pit Anutuuk kangut elmëën kö sëpnaarö.” ");
INSERT INTO wer_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Pël maan pitëm kar namp Nikotimas ngaan Yesuu naë sa pöpök pitën epël mëëa. ");
INSERT INTO wer_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Ma tiarim ngön kosang nentak omnarö pas ngön yaatak ulmëëpen pël wia ma? Won. Pötaanök tiar pim songönten kat wiakök omën pipot elmëëpenaat.” ");
INSERT INTO wer_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Pël maan pitök kangiir epël mëëa. “Niinta Kalili omën namp ma? Ngönëntak ngön wia pipot këëkë sangk kelak ëwat së. Anutuu tektek ngön yaaö namp Kalili yangerak naarööpanpe.” ");
INSERT INTO wer_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Omën pourö pitëm kaatë repak sëën Yesu pimënt Olip tomökël saut. ");
INSERT INTO wer_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Pël ëak pörekaan ëlpamök röökëër kaalak ngönën tup kaöetakë saut. Pël ëën omën pourö pim ngësë waisën pi wel aisëak pitën ngönën ök yema. ");
INSERT INTO wer_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Pël yaëën ngönënë ngarangköröere Parisi ngönën omnarö pit öng namp ompringëpök omp këkainëpring yaëën itenak mësak Yesuu naë wais pitëm tekrak tau moulmëak epël yema. ");
INSERT INTO wer_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","“Rë yanuulaup, öng epop ompringëpök omp maimapring yaëën itena. ");
INSERT INTO wer_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Pël ëautep Moses pim ngön kosangtak pöt öng ke pëlörö kël mö wel wiipënëak ëautep ni tol amte?” ");
INSERT INTO wer_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Pitëm mëëa pöt pit pi morök elmëën ngön nent maan ngön yaatak moulmëëpënëak kön wiak yema. Pël ëën Yesu pi wel aisëak mor wotöök yangerak retëng yaë. ");
INSERT INTO wer_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Pël yaëën pit piin pëël mëak rangkëër yaëën wal ë tauak epël yema. “Arim tekrakaan namp saun wonöp wë pöt puuk wet rëak kël mööp.” ");
INSERT INTO wer_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Pël mëak pi kaalak wel aisëak mor wotöök yangerak retëng yaë. ");
INSERT INTO wer_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Pël yaëën pit ngön pöt kat wiak ngarangkörö wot raan omën pourö pöp pöp oröak yesem won sa. Pël ëën Yesu pimënt wëën öngöp pim naë taueëa. ");
INSERT INTO wer_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Pël ëën Yesu pi we riak öngöpön itenak epël pëël yema. “Öng epop, omën ni mës niwak waisaurö pit tarëk wë? Ma pit nampök ni këlangön yaatak niulëëpënëak ngön ë pet nairën ëëpën ma?” ");
INSERT INTO wer_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Pël maan öngöpök epël yema. “Kaöap, omën nampök yok pangk pël naalnëëpan.” Pël maan Yesu kangiir epël yema. “Nookta yok pangk ni këlangön yaatak nanuulëëngan. Pötaanök ni së wë kaalak utpetat ëënganok.” ");
INSERT INTO wer_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesu pi omën ngönën tup kaöetak wëauröen kaalak epël ök yema. “Ne ar yangerakë omnaröaan es ëwa yaalniaup. Pötaanök namp pi nem ënëm elnëëpna pöp koutak kan sak waisak naëpan. Pi ëwaatak ëwa elmëaan wëwëetak öpnaat.” ");
INSERT INTO wer_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Pël maan Parisi ngönën omnarö pit kangiir epël yema. “Nimtok nimtë songönte war wesak aan kat wiak yaap newasën yeë.” ");
INSERT INTO wer_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Maan Yesuuk epël yema. “Omën namp pimtok pimtë songönte yaan pöt ar pi yaap ya pël newasngan pöt yaap. Pël ëaatak nemtok nemtë songönte ök yak epët yaap. Ne nemtë kak waisaurekën ëwat wë. Ën kaalak suma pörekënta ëwat wë. Pël ëaap ar nem kakën köpël wë. Ën ne talël sumaap pötenta ar köpël wë. ");
INSERT INTO wer_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ar pöt yangerakë wëwëetakël kön wieë omnarö ngön yaatak yaalmëaurö. Ne pöt arim yeë pöl ngön yaatak naniulëënganëëp. ");
INSERT INTO wer_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Nook omnarö komkap ëëmëak pël ëëma pöt yaapët. Pöt nemënt won, nem Pep wes nemëaup tenip pouwaarök pël ëënaat. ");
INSERT INTO wer_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Tiarim ngön kosangtak epël retëng ëaut wia. ‘Omën naar piarip ngön kopët nent, pouwaarök apna pöt yaap pël wasëpenaat.’ ");
INSERT INTO wer_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nemtok nemtë songönte ök yeniaan Pep wes nemëaup puukta kaamök ëak ök yenia.” ");
INSERT INTO wer_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Pël maan pit epël yema. “Nim pepap tarëk wë?” Pël maan Yesuuk kangiir epël yema. “Ar neen köpël wë. Pötaan nem Pepapönta köpël wë. Neen ëwat sanëën nem Pepapönta ëwat san tapön.” ");
INSERT INTO wer_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesu pi ngönën tup kaöeta ka kaö mon kiri yawiaurek wë omnaröen ngön pipot pout ök maimaut. Pël ëa akun pötak omnarö pit pi wii nemotëën yaë. Pöt pim mëngkën wel wiipna akunet temanöm nasën pötaanök. ");
INSERT INTO wer_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesu pi ngön wet rëak ök mëëa tapët ngolöp wesak epël ök yema. “Ne ar sëp niwesak sëën neen ap wasö wais itnaangkan. Arim saunatring wë wel wiinëët. Pël ëënë pötak nem së öma pörek newaisngan.” ");
INSERT INTO wer_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Pël maan Yuta kaöarö pit neneren epël mëëa. “Pi tol ëëpënëak, ‘Nem ömaarek ar newaisngan,’ pël ya? Ma pimtok pimënt ënën ëak wel wiipënëak ya ma?” ");
INSERT INTO wer_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Pël yemaan Yesuuk kangiir epël ök yema. “Ar yangerakaanörö. Ën ne ngaarëkaanëp. Ar yang eprekaanörö. Ën ne eprekaan wonöp. ");
INSERT INTO wer_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Pötaanök ne epël niiaut. ‘Ar arim saunatring wë wel wiinëët.’ Ën arën nemtë songönte ök niak pöten kön wi kosang nenewasën ëënë pötak arim saunatring wë wel wiinëët.” ");
INSERT INTO wer_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Pël maan pit epël yema. “Ni talëp?” maan Yesuuk epël yema. “Ne tapöp ngaan nem songönte ök niaim tapöp. ");
INSERT INTO wer_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ne arim omnant yeë pötë ngönöt selap wia. Pël ëak ök niak arim yaaut ngön ya nimpaat. Pël ëëmaatak omën nem wes nemëaupë yaaut yaap yaaup. Pim neeautök ar yangerak omnaröen tekeri wesak ök niaim.” ");
INSERT INTO wer_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Pël maan pit pim Pepap Anutuun mëëa pöten kön tektek nasën ëa. ");
INSERT INTO wer_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Pël ëën Yesuuk epël ök yema. “Ar ënëmak ne Omën Këëp wak ngaarëk nemöönë pötakök nem songönte ök niak pöten kön wi kosang newasënëët. Pël ëak pörekök ne nemtë könöök omnant naën nem Pepapök ök neeautök iman pöten ëwat sënëët. ");
INSERT INTO wer_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Pep wes nemëën waisaup pi neering wë. Pi ne wil nenemëënëp kët epotë nem omnant yeë epot pim kentöök yeë.” ");
INSERT INTO wer_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Pël yemaan omën selap pan pim ngön pöt kat wiak piin kön wi kosang mowesa. ");
INSERT INTO wer_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yesu pi Yuta omën piin kön wi kosang wesa pöröen epël yema. “Ar nem ngönte kat wiak kosang yenewas pöt nem ënëm panë yaalnë. ");
INSERT INTO wer_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Pötaanök ar ngön këët kat wiak ëwat sënë pötak ngön epëtak söë niwasën utpetatë inëën naëngan.” ");
INSERT INTO wer_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Pël maan pit ngön kangit epël yema. “Ten Apram pim ëarö. Ten omën naröak pitëm inëën naniwasënöröep. Tol ëënak, ‘Ar söë sënëët,’ pël yeniaan?” ");
INSERT INTO wer_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Pël maan Yesuuk kangiir pitën epël yema. “Ne yaap pan ök niamaan. Omën narö utpetat yaë piporö pit utpetatë inëën yaë. ");
INSERT INTO wer_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Inëën ruup pi inëën yaalmëaupë kaatak sasa naön yaaup. Ën ru panëëpökëër pim pepapë kaatak sasa wëaup. ");
INSERT INTO wer_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Pötaanök narö ar Anutuu Ruup nook söë yaniwas eporö ar söë pëën önëët. ");
INSERT INTO wer_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ar Apramë ëarö pöt ne ëwat wë. Pël ëaap nem ngönte arim lupötë wi naön. Pötaanök ar ne nempunëak aim. ");
INSERT INTO wer_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ne nem Pepapë naëaan omnant itenak ëwat saut arën ök yeniaan, arta arim pepapë ök niiaut pël yeë.” ");
INSERT INTO wer_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Pël maan pitök kangiir, “Ten Apramë ruure ëarö,” maan Yesuuk epël yema. “Ar yaap Apram pim ruure ëarö talte pim omnant eima pöl ëën. ");
INSERT INTO wer_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ne Anutuu naëaan ngön kë kat wiaut ök niaan ar peene ne nempunëak aim. Apram pi ngaan omën ke pil nent naën eimaup. ");
INSERT INTO wer_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ar arim pepapë ëaut yeë,” maan pitök kangiir epël yema. “Ten kain ru wonörö. Tenim Pep kopëtap Anutu.” ");
INSERT INTO wer_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Pël maan Yesuuk epël yema. “Anutu pöp yaap arim Pepap talte ar ne ompyaö elnëën. Pöt tol ëënak? Ne Anutu piiring wakaim wiak waisaut. Nemtë könöök newaisën. Won. Anutuuk wes nemëën waisaut. ");
INSERT INTO wer_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ar tol ëënak nem ök yeniak pötön kön nawiin yeë? Ar nem ngönte kat wiinëëtaan kaaö yeë pöta songönte epël wia. ");
INSERT INTO wer_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Arim pepap Seten. Pötaanök ar pim kentöökë ënëm yeë. Pi ngaanëër omën mëneimaupök om pël ëeim wë. Ngön këët pim naë won. Pötaanök ngön kë yaapët sasa sëp wesak wë. Pi kaar pepap yak kaar yaaup. Pötaanök pim könöökaan kaar aim wë. ");
INSERT INTO wer_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ën ne pöt, ngön kë yaapöt ök yeniaanak ar kön wi kosang newasën ëeim. ");
INSERT INTO wer_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ar nampök nem saun nent nokoirngan. Ne omën ke pëlëpök ngön yaap këët ök yeniaan tol ëënak kön wi kosang newasën yeë? ");
INSERT INTO wer_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Anutuu ruurö pit pim ngönöt kat yawiaurö. Ar pöt Anutuu ruurö won. Pötaanök pim ngönöt kat nawiin yeë.” ");
INSERT INTO wer_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Pël maan Yuta omnarö kangiir epël yema. “Ten niin, ‘Sameria omën urmerap pim lupmeri ilaan kaökaö saup,’ pël aim yaaut yaap aiman.” ");
INSERT INTO wer_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Pël yemaan Yesuuk kangiir epël yema. “Urmerap nem lupmeri won. Ne nem Pepapön wak isak yaan ar koröp kolak neaim. ");
INSERT INTO wer_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ne nemtën wak isak naën. Neen wak isak apna pöp omën namp wë. Pöp Anutu pi tiar wak kom elniipnaap. ");
INSERT INTO wer_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ne yaap pan niamaan. Omën namp nem ngön epët ngaarëk öpna pöp pi wel sasa nawiipan.” ");
INSERT INTO wer_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Pël maan Yuta omnaröak epël yema. “Ten niin ëwat yes. Urmerap niik isak wë. Apram wel wiaup. Ën tektek ngön yaaö omnaröeta wel wiaut. Pël ëautep ni epël yaanëp. ‘Omën namp nem ngönta ë pël ëëpna pöp pi wel sasa nawiipan.’ ");
INSERT INTO wer_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Pël ëautep nuuk Apram tiarim ëap il mowasumëak yaan ma? Pi wel wiaup. Ën tektek ngön yaauröeta wel wiautep. Nuukëër talëpë ök sak ömëak yaan?” ");
INSERT INTO wer_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Pël maan Yesuuk kangiir epël yema. “Nemtok nemtëën wak isak ama pöt pangk naëpan. Nem Pepapök neen wak isak yaaup. Arök, ‘Pi tiarim Anutu pël yemak pöp,’ pël yaatak neen wak isak naën yeë. ");
INSERT INTO wer_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Pël ëaap ar piin köpël wëën nookëër ëwat wë. Ën nook arën ne piin köpël pël niamaatep arim yeë pöl kaar niangan. Ne piin ëwatëp. Pötaanök pim ngönte ngaar wak ënëm yaaup. ");
INSERT INTO wer_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Tiarim ëap Apram pi nem yangerak oröömaaten ëwat sak ërëpre sawi ëa. Anutuuk elmëën pim könöök itenak ya kë sa.” ");
INSERT INTO wer_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Pël maan pitök kangiir epël yema. “Nim krismakiat 50 naën wiaap. Ni yaap Apramön itenaup ma?” ");
INSERT INTO wer_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Maan Yesuuk epël yema. “Ne yaap pan niamaan. Ne ngaanëër Apram naaröön wiaan wakaimaup.” ");
INSERT INTO wer_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Pël maan kël korak mööpënëak yaëën Yesu ngönën tupta kakaati ëlëëp ilëak oröak saut. ");
INSERT INTO wer_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesure pim ruurö ten kan yesem itaangkën omën namp it il tëaup wëën itenaut. Omën pöp pim pëlëp ëlëpök wilaup wëa. ");
INSERT INTO wer_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Pël ëën ten Yesuu ruuröak Yesuun epël pëël mëëaut. “Rë yanuulaup, talëpë saunetak omën epop it il tëaup ëlëpökaan oröa? Pimtë saunetak ma pim ëlre pepaarë saunetak epël ëa?” ");
INSERT INTO wer_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Pël maan Yesuuk kangiir epël yenia. “Pimtë saunetakre ëlre pepaarë saunetak won. Omën epët Anutuu ya yamëngkauta këët war wasëpënëak omën epop epël oröa. ");
INSERT INTO wer_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Pötaanök këtëp wë epëtakëër Anutu nem wes nemëën waisaup pim yaat mëmpa. Koö olapnaan yaëërek koutak omën nampök ya nent namëngkan. ");
INSERT INTO wer_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Nem yangerak öma pötak ar omnarö ëwat sënëën nem es ëwaöök ëwa elniaapnaat.” ");
INSERT INTO wer_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Yesu pi pël niak waasöpët ngësak yangetaring ngawi sak omën pöpë itöörarë wa yemomë. ");
INSERT INTO wer_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Pël ëak epël yema. “Ni Siloam i kaöök së nim itöörar iiröm.” Siloam pöt tiarim ngöntak, “Wes mëën sa,” pël yak pöt. Pël maan së iirën it nga ngënak kaalak waisa. ");
INSERT INTO wer_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Pël ëën omën pim kaköröere ka nantëaan piin ëwatörö, ngaan omnaröen sum kimang yemaan itenauröak pitëmënt neneren epël mëëa. “Omën epop ngaan wel aisëeë omnaröen sum kimang yeniauppe.” ");
INSERT INTO wer_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Pël yemaan naröak mëëa. “Mak, omën epop tapöp.” Pël maan naröak epël mëëa. “Won, omën munt tapöpë ök nampök wë.” Pël yemaan omën pöp pimënt kat wiak mëëa. “Ne tapöp.” ");
INSERT INTO wer_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Pël maan pit epël mëëa. “Ni tol ëak itöörar ompyaö saup?” ");
INSERT INTO wer_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Pël maan puuk kangiir epël mëëa. “Omën pitëm Yesu pël aim pöpök pim waasöptaring yanget ngawi sak itöörarë wa nemëak epël neea. ‘Ni Siloam i kaöök së iiröm,’ pël neaan së iiran pötak nem itöörar ompyaö sak omnantön ityaangk.” ");
INSERT INTO wer_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Pël maan pit epël mëëa. “Omën pöp tarëk wë?” Pël maan pi, “Ne köpël,” pël mëëa. ");
INSERT INTO wer_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Pël maan Yuta omnarö pit omën it il tëak wakaima pöp mësak Parisi ngönën omnaröa naë sa. ");
INSERT INTO wer_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Akun Yesuu yanget kaplak ngawi sak omnampë itöörar ompyaö mowesa pöt Yuta omnaröa kë yesa akun ngëëngk nentakök ëa. ");
INSERT INTO wer_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Pötaan Parisi omnarö pit pëël mëak epël mëëa. “Tol ëak nim itöörar ompyaö saup?” Pël maan itöörar ompyaö sa pöpök epël mëëa. “Puuk yanget waasöptaring kaplak ngawi sak itöörarë wa nemëën iirën it nga yangëngk.” ");
INSERT INTO wer_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Pël maan Parisi omën naröak epël mëëa. “Omën epop akun ngëëngkët kë sëpënëak ngön kosang wiaut yailën yak ten Anutuuk wes mëën newaisënëp pöt ëwat yes.” Pël maan naröak epël mëëa. “Tol ëak omën saunaringëpök retëng ke epël ëëpën?” Pitëmënt neneren pël mëak pitëm wëwëet kom ëa. ");
INSERT INTO wer_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Pël ëak pit kaalak omën it il tëa pöpön epël mëëa. “Omën nim itöörar ompyaö niwesa pöpön talëp yemaan?” Pël maan epël mëëa. “Pi tektek ngön yaaö omën namp.” ");
INSERT INTO wer_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Yuta kaöaröak omën pöp it il tëak wakaimaupök it nga ngëna pöten kön wi kosang wasëpnaaten kaaö ëën ëlre pepaarën yas mëëa. ");
INSERT INTO wer_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Pël ëak epël mëëa. “Epop arpim ruup ma? Ëlëpë yaatakaan it ngaap oröaup ma? Yak tol ëakök peene it nga yangëngk?” ");
INSERT INTO wer_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Pël maan ëlre pepaar kangiir epël mëëa. “Epop tenpim ruup pöt ëwat wë, ëlëpök it ngaapöp wilaup. ");
INSERT INTO wer_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Pël ëaupök peene tol ëak it nga yangëngk pöten tenip köpël. Talëpök itöörar ngaul moulmëa wes pötenta tenip köpël. Ar pimtën pëël maë. Pi kaö saupok pimtok pimtë songönten ök niapnaan.” ");
INSERT INTO wer_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ëlre pepaar piarip Yuta kaöaröen kas ëënak pël mëëa. Pöt Yuta kaöarö ngön epël kosang wia. Omën nampök Yesuun pi Kristo, Anutuu Yaö Mëëaup pël war wesak apna pöp ngönën tuptakaan yaya mepanëën waö ë mëëpnaat. ");
INSERT INTO wer_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Pël wieëa pötaanök ëlre pepaar piarip epël mëëa. “Pi kaö saupök arimtok pëël maë.” ");
INSERT INTO wer_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Pël maan pit kaalak omën ngaan it il tëak wakaima pöpön ngön maan akun nentepar sa. Pël ëak epël mëëa. “Ni Anutuu ëöetak yaap am. Ten omën pipopön ëwat wë. Pi saun omnamp.” ");
INSERT INTO wer_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Pël maan pi kangiir epël mëëa. “Pi saunaringëp ma won pöt ne köpël. Ën ne omën kopët nentenökëër kön wia. Ne ngaan itöörar ngaap wakaimaup. Pël ëautak peenökëër it nga yangëngk.” ");
INSERT INTO wer_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Pël maan pit epël mëëa. “Pi tol elnia? Tol ëak itöörar ompyaö niwesa?” ");
INSERT INTO wer_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Pël maan pi kangiir pitën epël mëëa. “Ar tol ëënak ök yeniaan kat wiinëëten kaaö yeë? Kaalak tol ëak niaanak kat wiin? Ma arta pim ënëm ëën ma?” ");
INSERT INTO wer_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Pël maan pit piin utpet wesak epël mëëa. “Nimtokëër omën pömorë ënëm yaaumoröp. Ten pörö Moses pim ngön wia pöta ënëm yaaurö. ");
INSERT INTO wer_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ten pörö Anutuuk Mosesën ngön ök mëëa pöt ëwatörö. Ën omën pipmorön ten köpëlëp. Talëlaan oröa?” ");
INSERT INTO wer_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Pël maan omën pöpök kangiir epël mëëa. “Elei, omën epët piita ke nalte. Ar köpël, pi talëlaan waisa wes. Pël ëaupök nem itöörar ompyaö newesaut. ");
INSERT INTO wer_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tiar ëwat wë. Anutu pi saun omnaröa ngönöt kat nemowiin yaaup. Ën omën namp Anutuun yaya maimeë pim könöökë ënëm yaaupök më yaë pötak pim ngönte kat mowi yaë. ");
INSERT INTO wer_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ngaanëër öng nampök ru it il tëa namp wilën omën nampök itöörar ompyaö mowesa pël aan kat nawiin ëaut. ");
INSERT INTO wer_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Anutuuk omën epop wes nemomëën ëanëën retëng ke epëlte naën ëan tapön.” ");
INSERT INTO wer_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Pël maan pitök kangiir epël mëëa. “Nim ëlëpë yaatak saunaring wëën pötaring wil niulëën wakaimaumor. Nuuk yok pangk ten ngönen rë niulömëak yaan ma?” Pël mëak waö ë mëa. ");
INSERT INTO wer_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu pitëm pimëën pël elmëa ngön pöt kat wiak omën pöp koirak epël yema. “Ni Omën Këëpön kön wi kosang yewasën ma?” ");
INSERT INTO wer_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Pël maan omën pöpök epël yema. “Kaöap, Omën Kë pöp talëp? Ni ök nea. Pël ëën ne kön wi kosang wasumaan.” ");
INSERT INTO wer_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Pël maan Yesuuk epël yema. “Ni yok piin itenaup pöp peene niiring ngönngön yaë epop.” ");
INSERT INTO wer_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Pël maan omën pöpök epël yema. “Aköp, ne kön wi kosang yaniwas.” Pël mëak pi rar rë wesirak Yesuun yaya yema. ");
INSERT INTO wer_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Pël yaëën Yesuuk epël yema. “Ne yangerakë omnarö ar kom elniimëak waisaup. Pötaanök omën it ngaap pël yewesaurö pit it nga ngëmpnaat. Ën omën pitëmtok pitëmtën it nga yangënaurö pël yewesaurö pit kangiir ngaap sëpnaat.” ");
INSERT INTO wer_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Pël yemaan Parisi ngönën omën narö pim naë wëaurö pit ngön pöt kat wiak Yesuun epël yema. “Nuuk tenën, ‘Arta it ngaapörö’ pël yeniaan ma?” ");
INSERT INTO wer_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Pël maan Yesuuk epël yema. “Arim itöt ngaap talte saunatë kangut won ön. Ar it ngaarö pël yaaurö. Pötaanök arim saunatë kangut wiaan ön.” ");
INSERT INTO wer_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesu pi watepang ngön nent epël yema. “Ne yaap pan niamaan kat wieë. Omën namp sëpsëp ëmöök ëm kanërak neilaan maimerek ngaar kaö möak wel rëak öngpök yes pipop pi koröp kosangëp omnant këkain yewaup. ");
INSERT INTO wer_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ën ëm kanërak yeila pöpökëër sëpsëpöröa ngarangkëp. ");
INSERT INTO wer_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Pi sëën kanweri ngarangkëpök kan të mowiin ilapnaat. Pël ëak yapin maan kat wiin mësak orööpnaat. ");
INSERT INTO wer_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Pimorö mësak orö ulmëak pimënt wet rapnaat. Pël ëën sëpsëpörö pit ngön kat yawiaurö. Pötaanök pimtë ngönte kat wiak ënëm sëpnaat. ");
INSERT INTO wer_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Pit omën maimapë ënëm nasëpan. Won, pit piin kas ëëpnaat. Pöt tol ëënak? Pit omën maimaröa ngönötön köpël ëak pötaan kas ëëpnaat.” ");
INSERT INTO wer_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu pi watepang ngön pöt maan pit pim ngön pitën mëëa pöta songönte ëngk ma e wesa. ");
INSERT INTO wer_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Pël yaëën Yesuuk kaalak epël yema. “Ne yaap pan niamaan. Nemënt tapöp sëpsëpöröa kanwer. ");
INSERT INTO wer_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Tektek omën kaarkaarörö, nem wet rëak waisa piporö, omnant këkain yaaurö. Pötaanök sëpsëpörö pitëm ngönöt köpël ëak kat nemowiin eima. ");
INSERT INTO wer_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nemënt tapöpök kanwer. Pötaanök omën namp nem naë wais oröak kakaati ilapna pöp Anutuuk utpetetakaan kama moöpnaap. Pël ëën pi ilëak oröak ëeimeë kaömp neim öpnaap. ");
INSERT INTO wer_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Kain omën pöp pas newaispan. Pi sëpsëpörö kain wak mënak utpet wasëpnaap. Ën ne pöp ar omnarö nem naëaan wëwëet önëak waisaut. Pötaanök ërëpsawiaring wëwëetak önëët. ");
INSERT INTO wer_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ne sëpsëpöröa ngarangk ompyaup. Pötaanök sëpsëp ngarangk ompyaup pim wëwëet sëpsëpöröaan këëpöt wes mampnaat. ");
INSERT INTO wer_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Omën sëpsëp pep panëëp won, sumetaan pëën ngarangk yaaup pi kent tokörö yewaisën itenak sëpsëpörö moolëak kas sëën mënak rep mëëpnaat. ");
INSERT INTO wer_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Pöt pi sëpsëpöröaan kön selap naën, sumetaan pëën yeëa pötaanök. ");
INSERT INTO wer_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Ne sëpsëpöröa ngarangk ompyaup. Pötaanök nem Pepap pi neen ëwat wëën ne piin ëwat wë. Ök tapël ne nem sëpsëpörö arën ëwat wëën ar neen ëwat wë. Pötaanök nem wëwëet arimëën këëpöt wes nimpaat. ");
INSERT INTO wer_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ën nem sëpsëp munt naröeta wë. Pörö ëm epöök wonörö. Pötaanök ne pöröeta koirumaap. Pël ëën pit nem ngönte kat wiak tok kopët nent ëën ngarangk kopëtap nemënt pötaan nemtok ngarangk ëëmaan. ");
INSERT INTO wer_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Nem wëwëet pitëmëën sëp wesak kaalak ömaat. Pötaanök nem Pepap ne lup sant yaalnë. ");
INSERT INTO wer_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Omën nampök elnëën pangk wel nawiingan. Won. Pöt nemtë könöök wëwëet sëp wasumaat. Ne nem wëwëet sëp wasuma pöta weëre kosangët pangk wia. Ën kaalak öma pöta weëre kosang pöteta pangk wia. Ne pël ëëmëak Pepak ngan rë nenaut.” ");
INSERT INTO wer_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Yesu pi pël maan Yuta omnarö ngön pöt kat wiak kaalak kom ëak tok nentepar sa. ");
INSERT INTO wer_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Pël ëak naröak epël mëëa. “Urmerap pim lupmeri ilëak wëën kaökaö yaë. Tol ëënak ar pim ngönöt kat mowieim?” ");
INSERT INTO wer_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Pël maan naröak epël mëëa. “Ngön epët omën urmerapring wëaupë ngönte won. Urmerapring wëaupök yok pangk omën it il tëaurö ompyaö mowasëpën ma?” ");
INSERT INTO wer_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Yuta omnaröa Yerusalem ngönën tup kaöeta kan tëa akunet temanöm sëën pöt ngëëngk wesak kë sa yeëa pöt kopiirir akunetak temanöm sa. ");
INSERT INTO wer_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Pël ëën Yesu pi ngönën tup kaö pöta kaö nera yapinte Solomon pöta kakaati yesën, ");
INSERT INTO wer_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Yuta omnarö pit wais pi tekrak ulmëak taueë epël yema. “Ni tol ëënak nim songönte wa ngep yaëën ten kön selap yeë? Ni yaap Kristo, Anutuu Yaö Niiaup pöt tenën war wesak ök nia.” ");
INSERT INTO wer_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Pël maan Yesuuk pitën kangiir epël yema. “Ne yok ök niiautak ar kön wi kosang nenewasën yeë. Nem ya yamëngk epot pout nem Pepapë këm ngöntak yeë epotök ne Anutuu Yaö Neeaup pöt tekeri yenewas. ");
INSERT INTO wer_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Pël yeëetak ar nem sëpsëp toktakaanörö won. Pötaanök ar kön wi kosang nenewasën yeë. ");
INSERT INTO wer_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ën nem sëpsëpörö nem ngön kat yawiaurö. Pël ëën ne pitën ëwat wëën nem ënëm yaaurö. ");
INSERT INTO wer_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Pël ëën nook wëwë kosangët koir mangkën wakaim öpnaarö. Pit kö nasëpan. Won pan. Omën nampökta nem moresiaan wa ëp naëpan. ");
INSERT INTO wer_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Nem Pepapök pit nemëën nenaurö. Pi weëre kosang panëëp omën ël pout il wesaup. Pötaanök omën nampök Pepa moresiaan wa ëp naëpan. ");
INSERT INTO wer_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Neere nem Pepap tenip kopëtap.” ");
INSERT INTO wer_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Pël maan Yuta omnarö pit kaalak këlöt wak pi mööpënëak yaë. ");
INSERT INTO wer_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Pël yaëën Yesuuk epël yema. “Ne ya ompyaö epot pout Pepa naëaanötök pet elniautep, tol nentaanök ar kël nemöönëak yeë?” ");
INSERT INTO wer_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Pël maan Yuta omnarö pit nerak wak epël yema. “Ten ya ompyaö pöt nentaan kön wiakök ni kël nimöönëak naën. Ni omën yaapöpök Anutuun ökre was aimeë nimtën Anutu pël aimën. Pötaanök kël nimöönëak yeë.” ");
INSERT INTO wer_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Pël maan Yesuuk epël yema. “Arim ngönën pepeweri Anutuuk maan retëng ëaut omën pim ya yamëngkauröaan epël wia. ‘Ar Anutu nem ökörö.’ ");
INSERT INTO wer_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Omën pörö pit ngaan Anutuu ngönte pitëm naë sëën pitën Anutuu urtak wë mëëa ngönën ngön epët kaëngk naën yaë. ");
INSERT INTO wer_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Pël ëautak ne pöt, Pep pimtok neen yaö neak wes nemëënak yangerak irëaut. Pötaanök epël yak. ‘Ne Anutuu Ruup,’ pël yakap tol ëënak arök, ‘Ni Anutuun ökre was yaan,’ pël neaim? ");
INSERT INTO wer_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Nem Pepapë yaat namëngkën yeë pöt ar neen kön wi kosang nenewasën ëënëët. ");
INSERT INTO wer_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ar nem ngönten kön wi kosang nenewasën yeë. Pël yeëetak ne nem Pepapë yaat yamëngk epot pöt Pep neering wëën ne Peparing wë pöt këëkë ëwat sënëën nem ya yamëngk epotön itenak neen kön wi kosang wasën.” ");
INSERT INTO wer_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Pël maan pit kaalak wali öpënëak ëak mor könöm ëën yes. ");
INSERT INTO wer_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ten Yesuring kaalak së Yotan olëak ëngk komuntakël Sonë ngaan omnarö i momëeima pörek së wakaimaut. ");
INSERT INTO wer_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Pörek wëën omën selap pim naë wais oröak wë neneren epël yema. “Yaap, Son pi ya retëng nent naën ëaut. Ën Son pim omën epopön ngön aim pöt nent kaar won.” ");
INSERT INTO wer_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Pël mëak omën pörek wëa pörö narö piin kön wi kosang yewas. ");
INSERT INTO wer_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Petani kak omën namp wëa yapinte Lasaras pi pörek yauman wieëa. Pim sasaar Mataare Maria piaripta kak taprekaar. ");
INSERT INTO wer_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ngaan Maria pöpök i köp nga kampët Aköpë ingesiarë lë momëak pim kepön ëptaring kol mowesaup. Pim nangap Lasaras pi yauman yeëa. ");
INSERT INTO wer_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Pël ëën sasaarök Yesuu ngësël ngön epël wes mëa. “O Aköp, nim kent yaën pöp yauman yaë.” ");
INSERT INTO wer_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Pël maan Yesu pi ngön pöt kat wiak tenën epël yenia. “Yauman pipët pi wel wiipënëak naën. Piptak omnarö Anutuun yaya maimeë pim Ruup neenta yaya neanëët.” ");
INSERT INTO wer_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu pi Mataare Mariaare Lasarasringöröen kent yeëa. ");
INSERT INTO wer_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Pël yaaup yak Lasarasë yauman yaaut kat wiak pim kak wëaurek wëën akun nentepar sa. ");
INSERT INTO wer_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Pël ëën ten pim ruuröen epël yenia. “Tiar kaalak Yutia yangerakë sëpa.” ");
INSERT INTO wer_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Pël niaan ten epël mëëaut. “Rë yanuulaup, peene tapët Yuta kaöaröak kël nimööpënëak ëautep ni kaalak tapël sëpenëak yaan ma?” ");
INSERT INTO wer_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Pël maan Yesuuk epël yenia. “Kët nenta öngpök aöa 12 ëak wia. Pötaanök yanget ëwa wiaan omën namp këtëk kan yesem kawi nengentiipan. ");
INSERT INTO wer_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ën omën namp rö kan yesem ëwaat won pötaan kawi ngentiipnaat.” ");
INSERT INTO wer_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Pi ngön pöt niak kaalak ënëm tenën epël yenia. “Tiarim ngöntöp Lasaras pi ka uraarek së it moilmaan.” ");
INSERT INTO wer_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Pël niaan ten epël mëëaut. “Aköp, pi ka urak pöt ompyaö sëpnaat.” ");
INSERT INTO wer_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yesu pi Lasaras wel wiauten yeniaanak tenök pöt ka yaap uraan yenia wesan. ");
INSERT INTO wer_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Pël yeëan pöt Yesu pi war wesak epël yenia. “Lasaras wel wia. ");
INSERT INTO wer_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ne wet rëak pim naë nasën ëaut. Ën wel wiak wiaanak neen kön wi kosang newasënëëtaan së ya momëmpaat. Pötaanök arim kön wi kosang wasëneëtaan ërëpërëp yeë. Yok peenök pim naë sëpa.” ");
INSERT INTO wer_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Pël niaan Tomas, yapin nent Ruprup Ëak Wilaup, puuk ten pim karuröen epël yenia. “Sëpa, tiarta piiring erën ëak wel wiipenaan.” ");
INSERT INTO wer_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Pël niak ten Yesuring së oröak Lasaras yangaöök kët kong nent wieëa pöt ëwat saut. ");
INSERT INTO wer_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Petani kak pörek Yerusalem kak naë 3 kilomita pöta ök wieëa. ");
INSERT INTO wer_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Pötaanök Yuta omën narö selap pan Mataare Mariaan yaare sër mapënëak së wëa. ");
INSERT INTO wer_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Pël ëën Mata pi Yesu yesën kat wiak koirëpënëak kamtaöök tenim naë waisa. Pël ëën Maria pi om kak wëa. ");
INSERT INTO wer_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Pël ëën Mata pi wais ten nikoirak Yesuun epël yema. “Aköp, ni eprek wëanëën nem nangap wel nawiin ëan tapön. ");
INSERT INTO wer_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pël ëaap ne niin ëwat wë. Peenta ni Anutuun omën nantön kimang maan pöt yok pangk nimpnaat.” ");
INSERT INTO wer_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Pël maan Yesuuk epël yema. “Nim nangap kaalak wal ëëpnaap.” ");
INSERT INTO wer_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Pël maan Mataak epël yema. “Pim akun kaöaöök ten omën pourö wal ëëna pötak wal ëëpna pöten ne yok ëwat wë.” ");
INSERT INTO wer_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Pël maan Yesuuk epël yema. “Weletakaan wal yaautere wëwëeta pepap nemënt tapöp. Omën namp neen kön wi kosang newasëpna pöp pi wel sasa nawiipan. Om wakaim öpnaat. ");
INSERT INTO wer_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Pötaanök omën narö nem naëaan wëwëet wak neen kön wi kosang newasëpna pörö wel nawiipanëërö. Pit om wakaim öpnaarö. Ni pöten kön wi kosang yewasën ma won?” ");
INSERT INTO wer_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Pël maan Mataak Yesuun epël yema. “Mak Aköp, ne niin kön wi kosang yeniwas. Ni Anutuu Ruup, pim tenën Yaö Niiaup Kristo, ngaan Anutuuk yangaak oröömëëp pël ëaup.” ");
INSERT INTO wer_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mata pi Yesuun pël mëak së pim nangap Mariaan ngön laaök epël mëëa. “Rë yanuulaup pi wais wë niin ya.” ");
INSERT INTO wer_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Pël maan Maria pi kat wiak teënt wal ëak Yesuu ngësë waisa. ");
INSERT INTO wer_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yesu pi kakë nasën, Mataë koira pörek om wëa. ");
INSERT INTO wer_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Pël ëën Maria pi teënt oröak yewaisën Yuta omën piaripön yaare sër mapnak së piarpim kaatak wëaurö pit itaangkën Maria pi teënt wal ëak yaaröön yangaöök së ing apënëak yes wesak pit pim ënëm waisa. ");
INSERT INTO wer_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Pël ëën Maria pi tenim naë wais oröak Yesuun itenak pim naë iri wel aisëak piin epël yema. “Aköp, ni eprek wëanëën nem nangap wel nawiin ëan tapön.” ");
INSERT INTO wer_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Pël mëak ing yemaan Yuta omën pim ënëm waisaö pöröeta top ëak ing ya. Pël ëën Yesu pi pöten itenak ya ilak sa. ");
INSERT INTO wer_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Pël ëak epël yema. “Ar pim sokur tarëk weeraurö?” Pël maan pit piin epël yema. “Aköp, së itaampa.” ");
INSERT INTO wer_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Pël maan Yesu pi ing ya. ");
INSERT INTO wer_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Pël yaëën Yuta omnarö pit neneren epël yema. “Iteneë. Omën epop pimëën kent pan kön wieëaap.” ");
INSERT INTO wer_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Yemaan naröak epël yema. “Omën epop pi it il tëaup ompyaö mowesauppe. Pi kaamök elmëanëën Lasaras wel nawiin ëan tapön.” ");
INSERT INTO wer_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesu pi kaalak ya ilak sëën yangaöök së oröa. Omën pöp kël öngöpöök wi ulmëak kël saulöp naöök ur wari ulmëeëa. ");
INSERT INTO wer_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Pël ëaan Yesuuk epël yema. “Ar kël epö wa pëlëër wieë.” Pël maan omën wel wiaupë sasëp Mata puuk epël yema. “Aköp, pi wel wiin wieë akun kong nent saup yak kamp utpet yaë.” ");
INSERT INTO wer_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Pël maan Yesuuk piin epël yema. “Tol ëënak yaan? Ne wet rëak epël niakat. ‘Ni kön wi kosang wasumë pötak Anutuu weëre kosangët oröön itaampëët,’ pël niakat.” ");
INSERT INTO wer_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Pël maan pit këlö wa pëlëër wiin Yesu pi ngaarëkël iteneë epël yema. “Pep, ne niin yowe yeniak. Ne kimang niaan kat yawiaup. ");
INSERT INTO wer_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ne niin ëwat. Ni kët poutë nem kimang ngönöt kat yawiaup. Ën om omën e taua eporöaan kön wiak pit nuuk ne wes nemëën waisan pöt kön wi kosang wasëpna pötaanök epël yeniak.” ");
INSERT INTO wer_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Pël mëak pi ngön ëak epël yema. “Lasaras, ni wal ëak orö.” ");
INSERT INTO wer_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Pël maan omën welap wal ëak oröa. Ingre moresiarë wii tëautre ën kepönöök poë koröp kör koëaöre pöt om ëaul ëaan. Pël ëën Yesuuk omnaröen epël yema. “Wil moulmëeë. Pël ëën sëpnaan.” ");
INSERT INTO wer_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Yuta omën selap Mariaaring wais wëaurö pit Yesuu ëa pöten itenak narö piin kön wi kosang wesa. ");
INSERT INTO wer_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pël ëën naröak së Parisi ngönën omnaröen Yesuu ëa pöten ök mëëa. ");
INSERT INTO wer_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Pël ëën kiri ar yaaö kaöaröere Parisi omnarö pit kansolörö wa top ë ulmëak epël mëëa. “Omën Yesu pömor retëng it ngolöpöt yaëëp tol elmëëpen? ");
INSERT INTO wer_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Pi om pël ëeim wëën tiar kat koko öpena pöt omën pourö pim naë së rë olëak piin kön wi kosang wasëpnaat. Pël ëën Rom ngaarö wais tiarim omnaröere ngönën tup kaöere pöt utpet niwasëpnaat.” ");
INSERT INTO wer_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Pël yaan pitëm kar namp yapinte Kaiapas pöp krismaki pötak kiri ar yaauröa wotöök wëaup puuk epël mëëa. “Ar kön won pan. ");
INSERT INTO wer_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Epël kön wieë. Yuta omën pourö kö sënganëën kopëtapök wel wiipna pöt ompyaut.” ");
INSERT INTO wer_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Pim ngön mëëa pipët pimtë könöök won, pi krismaki pötak kiri ar yaauröa wotöök wë yak Yesu kopëtapök Yuta omnaröaan wel wiipna pöten war wesak mëëa. ");
INSERT INTO wer_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Pël ëaup Yesu pi Yuta omnarö tenimtëën won, Anutuuk pim omnarö yang ël epotë wë eporö rongan kopëtet ë niulëëpënëak pël ëaup. Pöt Kaiapas pi kön nawiin wë ëa. ");
INSERT INTO wer_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Pël maan pit kët pötak Yesu mëmpna ngönte ngës rëa. ");
INSERT INTO wer_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Pël yaëën Yesu pi Yuta omnaröa itöök sak waisak naën. Kak pörek sëp mowesak yang omën wonra kautakël kak nerekë yapinte Iprem pörek së ten pim ruuröaring wakaimaut. ");
INSERT INTO wer_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Yuta omnaröa Anutuu mait elmëa akun ngëëngkët temanöm yesën ka kotutëaan omnarö lup kölam tëëpënëak wet rëak Yerusalem kakë sa, pitëm ngön kosangta wieëaul. ");
INSERT INTO wer_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Pël ëën pit ngönën tup kaöeta kakaati së Yesuun ap wesak pitëmënt neneren epël mëëa. “Ar tol yewas? Pi akun ngëëngk eptak newaisën ëëpën koröp.” ");
INSERT INTO wer_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Pël yemaan kiri ar yaaö kaöaröere Parisi ngönën omnarö pit ngön kosang epël wia. “Omën namp pim wëaurekën ëwat wë pöt ök aan wali öpenaan.” ");
INSERT INTO wer_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Anutuu mait elmëa akunet temanöm sëpënëak ngolöp yaëën kët 6 ëak wiaan ten Yesuring Petani kak së oröaut. Kak pörek Lasaras Yesuuk weletakaan wal ë moulmëaup pim kak. ");
INSERT INTO wer_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Pël ëën omën pörek wëaurö pit Yesuring kaömp ngawi nëmpënëak kaömp ar ëa. Pël ëak Mata pi kaömp yokorön Lasaras pi omën Yesuring wel aisëeë kaömp yena pöröaring wëa. ");
INSERT INTO wer_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Pël ëën Maria pi i köp nga kamp sum kësang yaaö kep kot nent wak Yesuu ingesiarë lë momëak pim kepön ëptaring kol yemowas. Pël ëën i pöta kamppel ka pöt ur wariak wieëa. ");
INSERT INTO wer_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Pël ëën Yesuu ruurö tenim naëaan namp, Yutas Keriot kakaanëp, Yesuun kup mowiipnaap puuk epël ya. ");
INSERT INTO wer_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Tiar tol ëënak i köp nga kamp epët omnarö menak 300 kina wak omnant wonörö mempen naën?” ");
INSERT INTO wer_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Pi omën omnant wonöröaan kön nawiin wë mëëa. Pi mon kërëëp ngarangk ëeë kain yaaup yakök pël ëëpënëak mëëa. ");
INSERT INTO wer_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Pël yemaan Yesu pi epël yema. “Pël mangan. Pi epët nem yangerak neweerëpna akunetaan peram wiak wakaimautak yaalnë. ");
INSERT INTO wer_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Omën ngöntök yaaö piporö arring akun wali öpnaaröak ar ënëmak yok pangk ompyaö elmëënëët. Ën ne pöt, arring akun wali naön ëëmaap yak pim ompyaö yaalnë epët yok pangk yaalnë.” ");
INSERT INTO wer_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Yuta omën selap pan Yesu Petani kak wë pöt kak wiak waisa. Pit Yesu pimtën itaampënëak won, Lasaras Yesuuk weletakaan wal ë moulmëa pöpönta itaampënëak waisa. ");
INSERT INTO wer_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Pël ëën kiri ar yaaö kaöarö pit Lasaras piita Yesuring mëmpënëak kup ria. ");
INSERT INTO wer_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Pöt Yuta omën selap pan Lasarasë ëa pötaan kiri ar yaaö kaöarö kasëng menak Yesuun kön wi kosang wesa pötaanök. ");
INSERT INTO wer_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ëlpamök omën rongan kësang Anutuu mait elmëa akun ngëëngktak wa top ëak wëa pörö Yesu Yerusalem kak waisëpnaan yaë pöt kat wia. ");
INSERT INTO wer_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Pël ëak pit ërëpërëp yeem këëmre kewis wak kamtaöök koirëpënëak yewaisem ngön ëak epël ya. “Yowe. Aköpë këm ngöntak yewais epopön yaya mepa. Pi Israel omnaröa omp aköp.” ");
INSERT INTO wer_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Pël yemaan Yesu pi pol tongki ru namp koirak rangk wel aisëa. Pöt ngönën pepeweri wieëa pöl ëa. ");
INSERT INTO wer_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Saion kak wëaurö ar kas ëëngan. Arim omën omp aköp arim naë yewais. Pi pol tongki ruupë rangk wel aisëak yewais.” ");
INSERT INTO wer_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Pël elmëauta songön pöt pim ruurö ten akun pötak kön nawiin ëaut. Ënëmak pi kutömweri is ë rangiat wak wëënak ten epël kön wiaut. “Ngaan pimëën ngönën pepeweri wia pöt kë rapënëak omnaröak pimëën pël elmëa,” pöt kön wiaut. ");
INSERT INTO wer_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ngaan omën Yesuuk Lasarasën ngön mëak weletakaan wal ë yemoulmëën itena pöröak Yesu pim ëa pöten ök maima. ");
INSERT INTO wer_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Pël ëën omën kësang pan pim retëng ëa pöt kat wiak pi koirëpënëak kamtaöök waisa. ");
INSERT INTO wer_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Pël ëën Parisi ngönën omnarö pitëmënt neneren epël mëëa. “Ar iteneë. Omën pourö pim naë së rë olëak wë. Tiar yok pangk naënganpe.” ");
INSERT INTO wer_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Yuta omnarö akun ngëëngktak Yerusalem kak së Anutuun yaya mapënëak yesën Krik omën narö pitring sa. ");
INSERT INTO wer_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Pël ëak omën pörö pit Pilip, Kalili yangerak Pesaita kakaanëp, pim naë wais epël mëëa. “Ngöntöp, ten Yesuun itaampunëak yewais.” ");
INSERT INTO wer_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Pël maan Pilip pi së Entruun mëak piarip së Yesuun ök mëëa. ");
INSERT INTO wer_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Pël ëën Yesuuk kangiir epël ök mëëa. “Omën Këëp nem kutömweri is ë rangiat öma akunet temanöm yes. ");
INSERT INTO wer_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ne yaap pan niamaan. Korupaë öpö yangerak nangëntën ngaarëk wiaapna pöt kopët tapö om wiaapnaat. Ën yangerak ngëntëpna pötak rëngap yaaröön ëlëp moö sëën kaalak kë selap utöpnaat. ");
INSERT INTO wer_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ök tapël namp pi pimtë möönre koröpöön kent ëëpna pöp kö sëpnaat. Ën namp e yangerak wë pi nemëën yak pim möönre koröpö këëpöt wasëpna pöp wëwë kosang koir mangkën wakaim öpnaat. ");
INSERT INTO wer_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Pötaanök omën namp nem inëën elnëëpënëak pöt nem ngönte kat wiak ënëm ëëp. Pël ëak nem kak öma pörek nem inëën ru sak öpnaap. Pël ëën nem inëën elnëëpna pöp nem Pepapök ping mowasëpnaat.” ");
INSERT INTO wer_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Yesuuk pël niak kaalak epël yenia. “Nem lupmer könöm yaëëp tol am? Ma epël mem ma? ‘Pep, nem naë orööpënëak yaë epët wa ap was,’ pël mam ma? Pël mema pöt pangk naëpan. Könöm orö nerëëpënëak waisaut. ");
INSERT INTO wer_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Pötaanök Pep, ni nim yapinte kaö was.” Yesu pi pël yemaan kutömweriaan ngön nent epël irëa. “Ne nem yapinte kaö wesaut. Pötaanök kaalak kaö wasumaan.” ");
INSERT INTO wer_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Pël ëën omën piiring taueëaurö pit ngön pöt kat wiak naröak epël yema. “Tangre kaö yera.” Pël yemaan naröak epël yema. “Ensel nampök piin ngön yema.” ");
INSERT INTO wer_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Pël yaan Yesuuk nerek wak epël yema. “Ngön pipët nemëën naën. Ar kaamök elniipënëak yaarö. ");
INSERT INTO wer_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Peene Anutuuk omën ngönën wonörö këlangön yaatak niulëak yangerakë kaöap, Seten, pi il mowasëpnaat. ");
INSERT INTO wer_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Pöt omnarö pit ne yangerakaan wak ngaarëk këraarak nemöönak yang ël epotë omnarö pourö wa nem naë niulëëmaat.” ");
INSERT INTO wer_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Pim ngön mëëa pöt pimtë wel wiipnaaten mëëa. ");
INSERT INTO wer_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Pël ëën omën piiring wëaurö pit epël yema. “Ten ngön kosangtak epël kat wi yeë. ‘Yaö Mëëaup, Kristo pi akun wali wakaim öpnaap.’ Pël wiaap tol ëënak ni epël yaan? ‘Omnarö pit Omën Këëp wa ngaarëk mööpnaat,’ pël yaan. Omën Kë pöp talëp?” ");
INSERT INTO wer_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Pël maan Yesu pi pitën epël yema. “Nem es ëwa epö arim naë akun kot nent wiaapnaat. Pötaanök ar ëwa elniipnaatak koutak ngep elniipanok sak waiseë. Pöt omën namp koutak yesem pöt, pim sëpna kön wiaul nasën ëëpnaat. ");
INSERT INTO wer_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Pötaanök ëwa elnia epöökëër pöten kön wi kosang weseë. Pël ëënë pötak ar ëwa pepap nem ingre mor sënëët.” Yesu pi pël më pet irak së ëlëëp ilaan pit itnaangkën ëa. ");
INSERT INTO wer_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Pit ngaanëër pitëm itöök Yesu pim retëng selap pan yaëënak piin kön wi kosang nemowasën eima. ");
INSERT INTO wer_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Pöt Aisaia pim tektek ngönte epël retëng ëa pöt kë oröa. “Aköp, omnaröa naëaan nampök tenim ngönte kön wi kosang newasën yaë. Ën Aköp, ni ya yamëngkem nim weëre kosangö pet elmëën nampökta pöten itenak kön nawiin yaë.” ");
INSERT INTO wer_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Pël ëak pitëm Yesuun kön wi kosang newasën ëa pöta songönte Aisaia puuk ngön nent epël ëa. ");
INSERT INTO wer_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Pitëm itöök itaampööre lupmeri kön wi pël ëak Anutuu naë rë olaan ompyaö mowaspanëak Anutuuk pit it ngaap mowesak lupöt këlötë ök wes moulmëaurö.” ");
INSERT INTO wer_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaia pi Yesuu kutöm ë rangiatön itneëak ngön pipot wet rëak ëaut. ");
INSERT INTO wer_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Pël ëaut omën kaö narö selap pit Yesuun kön wi kosang weseëak war wasëpnaatep Parisi omnaröak ngönën keimön elmëëpanëak kas ëën yak wesak wakaima. ");
INSERT INTO wer_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Pit Anutuuk pitëm yapinte wak isëpnaaten kent panë naën. Omnarö pitëmtok pitëmtë yapinte wak isak mapna pötenök kent pan ëa. ");
INSERT INTO wer_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yesu pi ngön ëak epël yema. “Omën namp pi neen kön wi kosang newasëpna pöp nemtën pëën naëpan. Pep wes nemëën waisaup piinta kön wi kosang wasëpnaat. ");
INSERT INTO wer_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ën namp neen itnengempëna pöp Pep wes nemëën waisaup piinta itaampnaat. ");
INSERT INTO wer_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ne ëwa pepap yak omën neen kön wi kosang yenewesaurö koutak önganëak ëwa elniimëak yangerak irëaut. ");
INSERT INTO wer_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Pötaanök omën namp nem ngönte kat wiak ngaar naön ëëpna pöp ne këlangön yaatak moulmëëmëak ngön ë pet nairën ëëmaap. Ne omnarö këlangön yaatak moulmëëmëak neiraan, utpetetakaan kama moömëak irëaup. ");
INSERT INTO wer_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Omën namp ne kasëng nemenak nem ngönten kaaö ëëpna pöp ngön ë pet yairauröa ök pi kom elmëëpnaap. Pöt nem ngön wet rëak ök yeniak epotök akun kaöaöök ngön ë pet yairauröa yaë pöl ëëpnaat. ");
INSERT INTO wer_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Nem ngön aim epot nemtë könöökaan naën. Won, Pep wes nemëaup puuk ök neeautök pim neeaul war wesak ök niaim. ");
INSERT INTO wer_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Pël ëak ne ëwat wë. Ar nem Pepapë ngön ngaar önë pöt wëwë kosangët koir nimpnaat. Pötaanök nem ngön ök niaim epot pim ngan rë nenautök ök niaim.” ");
INSERT INTO wer_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Anutuu mait elmëa akun ngëëngkët temanöm yesën Yesu pimtë ëëpnaaten epël kön wia. “Ne yanger sëp wesak nem Pepapë ngësë suma akunet temanöm yes,” pël kön wiak omën pimorö yangerak wëaurö lup sant elnieima. Pim lup sant elnieima pöt om wiaan wel wiipnaat. ");
INSERT INTO wer_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Wiap kanök ten kaömp neim wëën Setenök Yutas Keriot kakaanëp, Saimonë ruup, pim lupmeri ilaan Yesu kööre toköröa moresi moulmëëpënëak kön wia. ");
INSERT INTO wer_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ën Yesu pi pöt epël kön wia. “Ne nem Pepapë naëaan irëaup kaalak pim ngësë sumaap. Pötaanök pi nook omnant pout ngarangk ëëmëak rë nemëa.” ");
INSERT INTO wer_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Pël kön wiak kaömpöt sëp wesak wal ë ulpëën rangkëp përë wiak poë koröp sak kol yewas pöp nent wa ura. ");
INSERT INTO wer_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Pël ëak Yesuuk iit söwarweri lë wiak ngës rëak ruuröa ingöt i yaniir. Pël ëak poë koröp pötaring kol niwesaut. ");
INSERT INTO wer_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Pël ë Saimon Pitaë naë sëën epël yema. “Aköp, nuuk nem ingesiar yok pangk i neneirngan.” ");
INSERT INTO wer_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Pël maan Yesuuk epël yema. “Nem yeë epëten ni köpël wëën. Ënëmak ëwat sumëët.” ");
INSERT INTO wer_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pël maan Pitaak epël yema. “Nuuk yok pangk nem ingesiar i neneirngan pan.” Pël maan Yesuuk kangiir epël yema. “Nook i naniir ëëma pöt ni neering naöngan.” ");
INSERT INTO wer_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Pël maan Saimon Pitaak epël yema. “Aköp, ingesiar pëën i neirnganëp, morre kepönre pötta i neir.” ");
INSERT INTO wer_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Pël maan Yesuuk kangiir epël yema. “Omën namp koröp pou iirëpna pöp pi ënëm kaalak irëpnaataan ya kaö namëngkën ëëpnaat. Om ingesiar pëën kaalak iirëpnaat. Pël ëaap ar kölam tëauröak pourö kölam pëën naön.” ");
INSERT INTO wer_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Pim pël niia pöt piin kup mowiipnaap tenring wëën itneëak epël yenia. “Ar pourö kölam pëën naön.” ");
INSERT INTO wer_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yesu pi ten pim ruuröa ingöt iir pet irak pim ulpëën waliip wa mëak kaalak tenim naë wel aisëak epël yenia. “Ar nem yaalni epëta songönten ëwat wë ma? ");
INSERT INTO wer_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ar neen, ‘Aköp, tenim rë yanuulaup,’ pël neaim pöt yaap, ne arim pöp. ");
INSERT INTO wer_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Pötaanök ne arim Aköp, rë yanuulaupök arim ingöt iir yanuulë epël arök arim karuröa ingöt i moirën. ");
INSERT INTO wer_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Arim ëënëël nook peene pet yaalni. Pötaanök nem yaalni epët arök yal menak nem yeë epël ëën. ");
INSERT INTO wer_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ne yaap pan niamaan. Inëën yaaö nampök pim ngarangkëp il nemowaspan. Ma omën ya nga wes mëën sa nampökta pim wes mëaup il nemowaspan. ");
INSERT INTO wer_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ar pipët ëwat wë. Pöta ök ëënë pötak ërëpsawiaring eim önëët. ");
INSERT INTO wer_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Ne ngön epët ar pouröaan neniaan. Omën nemëën wesa pöröen ne ëwat wë. Pël ëaap omën epot ngönën pepeweri ngön wia pöt kë rap. Pöt ngönën pepeweri epël wia. ‘Omën neering kaömp yen epopök neen utpet pan elnëëpënëak yaë.’ ");
INSERT INTO wer_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Omën pöt naaröön wiaan wet rëak ök yeniak. Pötaan ënëmak oröön pöt epël kön wiinëët. ‘Pi yaap Kristo pim ök niia tapöt,’ pël kön wiinëët. ");
INSERT INTO wer_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ne yaap pan niamaan. Omën namp nem ya ngan rë menak arim naë wes yanimë epop sant mowasënë pöt ne tapël sant newasënëët. Ën ar ne sant elnëënë pöt nem wes nemëaup tapël sant elmëënëët.” ");
INSERT INTO wer_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesu pi pël niak ulöp es mokotön epël yenia. “Ne yaap pan niamaan. Arim naëaan namp ngaaröa naë së nemëën kup mowiipnaat.” ");
INSERT INTO wer_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Pël niaan ruurö ten it neneren ëak talëpön ya pël kön wiak ëngk ma e wesaut. ");
INSERT INTO wer_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Pël ëak ruuröa naëaan ne Yesu pi neen kent yaaup yak pim naë wëën, ");
INSERT INTO wer_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Saimon Pita puuk kepönööring, “Tol?” elnëak, “Talëpön yaarek pëël maan ök niap,” pël yaalnë. ");
INSERT INTO wer_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Pël elnëën ne Yesuu ngësël ko wiak epël mëëaut. “Aköp, talëpön yaan?” ");
INSERT INTO wer_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Pël maan Yesuuk epël yenëa. “Kaömp kaut iistak mëak mempa pipopön yeniak.” Pël neak kaömp kaut iistak mëak Yutas, Saimon Keriot kakaanëp pim ruup, yemangk. ");
INSERT INTO wer_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Pël ëën Yutas kaömp pöt nëën Seten pim lupmeri ilëa. Pël ëën Yesuuk epël yema. “Omën nim ëëmëak yaën pipët teënt ëëm.” ");
INSERT INTO wer_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Pël ök yemaan ten piiring wëa pörö kat wiak këëkë kön nawiin ëaut. ");
INSERT INTO wer_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Pël ëak ten naröak epël kön wiaut. “Yutas pi tiarim mon kërëëp wieëaupok akun ngëëngktakëën omën nant wë wes yamë ma ngöntök yaaurö omën nant mampënëak wes yemomë,” pël wesaut. ");
INSERT INTO wer_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yutas pi kaömp kaö pöt wa nak tapëtakëër kakaatiaan oröak rö kan koutak sa. ");
INSERT INTO wer_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yutas pi oröak yesën Yesuuk epël yenia. “Peene Omën Këëp nem yapin pingët tekeri yaaröön nook Anutuu yapin pingëteta tekeri wes yamë. ");
INSERT INTO wer_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Omën Këëp ne Anutuu weëre kosangöt tekeri yewas. Pötaanök Anutuuk Omën Këëp nem weëre kosangöt tekeri wasëpnaat. Akun wali nasën wiaan pël ëëpnaat. ");
INSERT INTO wer_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Nem ruurö, ne akun kot nent arring wë olëak sëën ar neen ap wasënëët. Pötaanök Yuta omnaröen mëëa tapët arënta yeniak. Nem së öma pörek ar peene yok pangk newaisngan. ");
INSERT INTO wer_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ne kan ngolöpö epël koir yaningk. Ar neneren lup sant ëeim ön. Nem ar lup sant elnieimaa pöl arta arimtok neneraan lup sant ëeim ön. ");
INSERT INTO wer_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Pël ëënë pöt omnaröak arën itaangkën nem ruurö pël koröp orööpnaat.” ");
INSERT INTO wer_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Pël yeniaan Saimon Pitaak epël yema. “Aköp, ni talël sum?” Pël maan Yesuuk kangiir epël yema. “Nem së öma pörek yok pangk peene newaisngan. Ënëmak waisumëët.” ");
INSERT INTO wer_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pël maan Pitaak epël yema. “Aköp, tol ëënak nim ënëm newaisën ëëm? Ne nimëën wel wiimëak pöt yok pangk wel wiimaat.” ");
INSERT INTO wer_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Pël maan Yesuuk kangiir epël yema. “Ni nim wëwëet nemëën këëpöt wasumëëp ma? Ne yaap pan niamaan. Kokor ngön naën wiaan ni akun nentepar nent yak newasumëët.” ");
INSERT INTO wer_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesuuk kaalak yal menak epël yenia. “Ar ya ngës ëëngan. Anutuun kön wi kosang wesak neenta kön wi kosang newasën. ");
INSERT INTO wer_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Pöt tol ëënak? Nem Pepapë kak kaat kësang wia. Pötaanök ne wet rëak pörek së arimëën ur nant kopëta wes ulmëëmaan. Pël naën wieëanëën ne wet rëak ngön pipët arën ök neniaan ëan tapön. ");
INSERT INTO wer_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Pël ëa pötaanök ne pörek së arim uröt kopëta wes ulmëak ar neering önëën kaalak wais nikoirumaat. ");
INSERT INTO wer_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ën nem kan suma pöön ar ëwat wë.” ");
INSERT INTO wer_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Pël niaan Tomasök epël yema. “Aköp, nim kan sumë pöön ten köpël. Tol ëak ëwat sën?” ");
INSERT INTO wer_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Pël maan Yesuuk epël yema. “Kan pö nemënt tapöp. Ne ngön këëtere wëwëeta pepap. Kan maim naöök së Pepa naë naarööngan. Nemënt kan kopët tapö. ");
INSERT INTO wer_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ar wet rëak neen yaap ëwat sanëën nem Pepapönta ëwat san tapön. Peenök ar piin itenak ëwat yes pël kön wiinëët.” ");
INSERT INTO wer_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Pël maan Pilipök epël yema. “Aköp, ni Pepen pet elniimë pötak ten yok pangk ëënaat.” ");
INSERT INTO wer_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Pël maan Yesuuk epël yema. “Pilip, ne akun wali pan arring wakaimauppe. Ni neen ëwat nasën ma? Omën neen ityaangk pöp nem Pepapönta ityaangk. Oröp ëënak ni epël yaan? ‘Ni Pepen pet elni,’ pël yaan. ");
INSERT INTO wer_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ni, ‘Ne Pepaaring wëën Pep pi neering wë,’ nem yak pöt kön wi kosang nenewasën imaup ma? Nem ngön arën ök yeniak epot nemtë könöökaan nga ilak ök neniaan. Pep pi neering wë pimtok pim yaat yamëngk. ");
INSERT INTO wer_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ar ne Peparing wëën Pep pi neering wë nem ök yeniak epot kat wiak kosang weseë. Pël naën ëak pöt nem ya yamëngk epotön itenak kön wi kosang neweseë. ");
INSERT INTO wer_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ne yaap pan niamaan. Omën namp neen kön wi kosang newasëpna pöp puuk yok pangk nem ya yamëngk epot mëmpnaat. Pël ëak kaö panë wesak mëmpö yesem pim ya pötak nemët il newasëpnaat. Ne Pepa ngësë sumen ëa pötaan pël ëëpën sa. ");
INSERT INTO wer_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Pël ëën ar nem yapintakël kimang neanë pöt Anutuu Ruup nook nem Pepapë weëre kosangöt tekeri wesak yok pangk nimpaat. ");
INSERT INTO wer_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ar nem yapintak neen omën nant ëëmëak kimang neaan pöt pangk ëëmaat.” ");
INSERT INTO wer_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Ar ne lup sant elnëënë pötak nem ök yeniak pöl ëënëët. ");
INSERT INTO wer_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Pël ëak ne Pepen kimang maan puuk Ël Kaamök munt namp arimëën wes mëëpnaat. Pël ëën akun wali arring wakaim öpnaat. ");
INSERT INTO wer_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ngëëngk Pul pö ngön këët tekeri yewesa pöta Pulö omën ngönën wonöröak itaampööre ëwat së pël naën yaau. Pötaanök pit sant mowesak naön ëëpnaat. Pi peene arring wë arim lupötë wakaim öpnaap. Pötaanök ar piin ëwat wë. ");
INSERT INTO wer_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ne ar sëp niwasën ru wamir sak naöngan. Arim ngësë kaalak waisumaap. ");
INSERT INTO wer_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Akun kot nent wia pöt pet irën omën ngönën wonöröak neen itnaangkën ëëpën sa. Ën ar pöt neen itaampunëët. Ne öp wëaup. Pötaanök arta öp önëët. ");
INSERT INTO wer_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Akun pötakök ne Peparing wakaiman, ar neering wëën ne arring wakaiman pöten ëwat sënëët. ");
INSERT INTO wer_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Omën namp nem këm ngönte ngaar wak öpna pöp pi lup sant elnëëpnaap. Ën namp lup sant elnëëpna pöp nem Pepapök pi lup sant elmëëpnaat. Nookta tapël lup sant elmëak nem songönte tekeri wesak pet elmëën itaampnaap.” ");
INSERT INTO wer_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yesu pi pël maan Yutas, Keriot kakaanëp won, pim ngampupök epël yema. “Aköp, ni tol ëënak nim songönte tenimtën tekeri wes niak omën ngönën wonöröaanta pël naalmëën ëëmëak yaan?” ");
INSERT INTO wer_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Pël maan Yesuuk kangiir epël yema. “Omën namp ne lup sant elnëëpna pöp pi nem ngönta ënëm ëëpnaap. Pël ëën nem Pepapök pi lup sant elmëën tenip pim naë së piiring önaat. ");
INSERT INTO wer_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ën namp pi ne lup sant naalnëën ëëpna pöp nem ngönötë ënëm naën ëëpnaap. Ngön arim e kat yawi epot nemtëët won. Pep nem wes nemëaupök nangkën wak waisaut. ");
INSERT INTO wer_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Nemënt arring wë ngön epot pout ök yeniak. ");
INSERT INTO wer_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ënëmak arim Ël Kaamököp, Ngëëngk Pulö, Pepak nem yapintakël wes mëëpna pöök ar rë niulak arim könöt wa ngolöpngolöp niwasëpnaat. Pël ëën ar nem ök niaimaö pöt poutön kön wiinëët. ");
INSERT INTO wer_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ne ar sëp niwasumëak nem mayaapët ningkën arring wiaapnaat. Nem pöt omnaröa mayaap pöta ök wontak yaningk. Ar ya ngës ëak kas ëëngan. ");
INSERT INTO wer_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ar ngön epël ök niaan kat wiaurö. ‘Ne kamaarek së rëak kaalak waisumaat,’ pël niiaut. Pep pi kaöap ne il newesaup. Pötaanök ar yaap neen lup sant elnëan talte nem Pepa ngësë suma pöten ërëpërëp ëën. ");
INSERT INTO wer_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Këët naaröön wiaan wet rëak ök yeniak. Pötaan ënëmak oröön itenak ar kön wi kosang newasënëët. ");
INSERT INTO wer_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Yangerakë kaöap Seten pi waisëpënëak kan ko yaë. Pötaanök ne arën ngön wali neniaan ëëm sa. Pi wais ne il nenewaspan. ");
INSERT INTO wer_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Yangerakë omën ngönën wonörö nem Pepapön lup sant yaalmëa pöten itenak kön wiipënëak pim ngön ök neeautë ënëm yaaup. Yok, wal ëak sëpa.” ");
INSERT INTO wer_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yesu pi ten pim ruuröen ök niak kaalak watepang ngön nent epël ök yenia. “Ne wain këwei ököp. Ën nem Pepap pi wain ya ngësëp. ");
INSERT INTO wer_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Nem lööre morötë nautön ëëpna pöt ngësëpök oröak il moolapnaat. Ën mor nant utöpna pöt pi mënt il moolëak ompyaö mowasën selap utöpnaat. ");
INSERT INTO wer_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ar pöt, nem ngön ök niaan kat wian pötak ompyaö niwesa. ");
INSERT INTO wer_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Pötaanök nem arring eim öma pöl ar neering eim ön. Wain mor nemor ëlwei yal naën pëlëër wë yok pangk nautpan. Ök tapël, arta neering naön ëënë pöt kë won ëënëët. ");
INSERT INTO wer_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ne wain songönte. Ar nem moröt. Pötaanök namp neering wëën ne piiring ömaap pim këët selap uteim öpnaat. Ën ar ne sëp newesak wë arimënt omnant pangk naëngan. ");
INSERT INTO wer_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Pötaanök neering naön ëëpna pöp ngësëpök wain morötë yaë pöl il moolaan wa top ëak esuwesi yemar pöl elmëëpnaat. ");
INSERT INTO wer_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ar neering wë nem ngönte kat wieim önë pöt ar omën nenten kimang neaan yok pangk nineim ömaat. ");
INSERT INTO wer_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Pötaanök ar kë selap yautön nem ruurö pöt tekeri yesën önë pöt nem Pepapë weëre kosangöt oröön omnarö itaampnaat. ");
INSERT INTO wer_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nem Pepapök ne lup sant elnëeim wë pöl nook ar lup sant yaalni. Pötaanök ar nem lup sant pöta öngpök ön. ");
INSERT INTO wer_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ar nem këm ngönta ënëm eim önë pötak nem lup sant pöta öngpök wakaim önëët. Neenta tapël nem Pepapë ngön ngaar weimeë pim lup sant pöta öngpök wëaup. ");
INSERT INTO wer_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Ne ngön pipot nem ya ërëpërëp pöt arim naë oröak peö ëak wiaapënëak ök yeniak. ");
INSERT INTO wer_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ne ngön epël niiaut. ‘Nem lup sant elnieima pöl ar nener lup sant elmëeim ön,’ pël niiaut. ");
INSERT INTO wer_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Omën namp pim karuröaan wel wiipna pöpön, ‘Lup sant panë yaë,’ pël mepenaat. ");
INSERT INTO wer_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ar nem yeniak pöl ëënë pötak nook itaangkën nem ngöntörö pël koröp orööpnaat. ");
INSERT INTO wer_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Inëën yaaup pi pim ngarangkëpë omnant yaauten köpël wë. Pötaanök nook arën, ‘Inëënörö,’ pël naniwasën yeë. Nem Pepapë naëaan ngön kat wiaut ök niaimaut. Pötaanök ne arën, ‘Nem ngöntörö,’ pël yaniwas. ");
INSERT INTO wer_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Arök ne arimëën kom ë neneulëën ëaurö. Nookëër ar këët selap uteim önëak yaatak kom ë niulëaut. Pël ëën arim kë pöt oröak wiaan ar nem yapintak Pepen omën nantön kimang manë pöt yok pangk nimpnaat. ");
INSERT INTO wer_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ne arën kosang wesak epël yeniak. Ar neneraan lup sant ëeim ön.” ");
INSERT INTO wer_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Ngönën wonöröak kööre tok yaalniin pöt, ‘Pit wet rëak Aköpön kööre tok elmëaurö yak tenënta tapël yaalni,’ pël wasën. ");
INSERT INTO wer_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ar yaap ngönën wonöröa rongantak wëan talte pitëm karurö pël wesak kent elniipën. Ar pitëm toktak wonörö. Nook pitëm naëaan kama niön pitëm wëwëet sëp wesaurö. Pötaan kööre tok yaalni. ");
INSERT INTO wer_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Arën nem ngön epël niak pöten kön wiaan. ‘Inëën yaaö nampök pim ngarangkëp il nemowaspan.’ Pit neen kööre tok elnëaut. Pötaan arënta tapël elniipnaat. Pit nem ngönta ënëm yeëa talte arimteta kat wiak ënëm ëëpën. ");
INSERT INTO wer_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Pël ëëpnaatak pit Pep ne wes nemëaup piin köpël ëak kasëng mena. Pötaanök ar nemorö pël wesak kööre tok elniipnaat. ");
INSERT INTO wer_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ne yaap pitëm naë oröak ngön ök nemaan ëan talte pitëm saun pötë kangut tekeri nasën ëëpën. Pël ëëpnaatak ök maan kat wiak kaaö ëaurö. Pötaan saunat wiaapnaat. ");
INSERT INTO wer_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Omën neen kööre tok yaalnë piporö nem Pepapönta kööre tok yaalmë. ");
INSERT INTO wer_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ne ya ke nentere nent omën ngaanöröa naënöt pitëm tekrak mëneimaut. Pël naën ëan talte saunatë kangut pitëm naë naaröön ëëpën. Pël ëëpnaatak pit nem ya mëna pötön itenak ten Pep pouwaarën kööre tok yaalni. ");
INSERT INTO wer_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Pël yaë pötak ngönën pepeweri ngaan ngön kosang nent epël ëa pöt kë yaarö. ‘Pit pas neen kööre tok elnëaut.’ ");
INSERT INTO wer_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ël Kaamököp nook nem Pepapë naëaan wes mëën arim ngësë waisëpnaat. Pöp ngön këët tekeri yewesa pöta Pulö Pepapring wëaupök wais nem ngönöt war wesak ök niapnaat. ");
INSERT INTO wer_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Pël ëën pöt arta ngaanëër nem ya ngës rëaurekaan akun wali neering wakaimaurö. Pötaan nem songönte arökta tekeri wesak ök anëët.” ");
INSERT INTO wer_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Yesu pi ten pim ruuröen kaalak epël ök yenia. “Ar kön wi kosang yewesaut sëp wasnganok pël niiaut. ");
INSERT INTO wer_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Pit ar pitëm ngönën tupötëaan waö ë nimëëpnaat. Pël ëak kaalak akun nent oröön pit ar mën wel yaniwiem Anutuun kaamök yaalmë pël kaar wasëpnaat. ");
INSERT INTO wer_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Pit neen köpëlre Pepenta köpël. Pötaanök pël elniipnaat. ");
INSERT INTO wer_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Naaröön wiaan ök yeniak. Pötaanök ënëmak oröön pöt epël wasënëët. ‘Pim ngaan ök niia pötak yaarö,’ pël wasënëët.” “Ne ngaan arëring wë yak ngön pipot ök neniaan ëaut. ");
INSERT INTO wer_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Pël ëautak peene pöt nem wes nemëaupë ngësë sumëak yaëën arim naëaan nampök neen, ‘Ni talël sum?’ pël nenëaan yeë. ");
INSERT INTO wer_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ne sëën omën orööpnaaten ök niak pötaan ya ngës yeë. ");
INSERT INTO wer_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Pötaanök ne yaap niamaan. Ne ar sëp niwesak sëën arim naë omën ompyaut orööpnaat. Ne nasën ëëma pöt Ël Kaamököp arim naë newaispan. Ën nem suma pötak nook wes mëën irapnaat. ");
INSERT INTO wer_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Pi irapna pötak ngönën wonörö saunaring wëanre wotpil sak wëan pöta songönte tekeri wes menak ngön ya yamëngkauta songönteta tekeri wes mampnaat. ");
INSERT INTO wer_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Saunaring wëa pöta songönte eptakël tekeri wasëpnaat. Neen kön wi kosang nenewasën yaaurö pötakël tekeri wasëpnaat. ");
INSERT INTO wer_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ën wotpil sak wëa pöta songönte eptakël tekeri wasëpnaat. Ne nem yaat pet irak Pepa ngësë sëën ar kaalak itnaangkën ëënëët pötakël tekeri wasëpnaat. ");
INSERT INTO wer_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ën ngön ya yamëngkauta songönte eptakël tekeri wasëpnaat. Anutuuk yangerakë kaöap Seten pi këlangön yaatak ulmëëpënëak ngön ë pet irak wë pöl pit tapël elmëëpnaat pötakël tekeri wasëpnaat. ");
INSERT INTO wer_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Ngön kësang wiaap ök niamaatep peene tapëtakëër ar yok pangk ënëm naën ëënëën sa. ");
INSERT INTO wer_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ngön këët tekeri yewesa pöta Pulö irëak ngön këëta songönte pet elniin ëwat sënëët. Pël yeem pim könöökaan rëak nant neniapan. Pepa naëaan kat wiaul war wesak omën ënëm orööpnaatönta ök niapnaat. ");
INSERT INTO wer_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Pi nem ngönre omnant wak ök yeniaan nem yayaat orööpnaat. ");
INSERT INTO wer_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Pepa omën pout nemot. Pötaanök, ‘Pi nem ngönre omnant wak tekeri wes nimpnaat,’ pël niiaut.” ");
INSERT INTO wer_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Akun kot nent won sëën ar neen itnaangkan. Kaalak akun kot nent tapël won sëën waisën itaampunëët.” ");
INSERT INTO wer_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Pël niaan ruurö tenimtok tenimënt neneren epël mëëaut. “Pi tol ëënak epël ya? ‘Akun kot nent won sëën ar neen itnaangkan. Kaalak akun kot nent tapël won sëën waisën itaampunëët,’ pël yaap. Pël niak kaalak, ‘Pepa ngësë sumaat,’ pël yaap. ");
INSERT INTO wer_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","‘Akun kot nent,’ pël ya pöt tol nenten ya? Tiar pöta songönten köpël yeë.” ");
INSERT INTO wer_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Pël mëak ten Yesuun pëël menëak yaëën pimtok itenak epël yenia. “‘Akun kot nent won sëën ar neen itnaangkan. Kaalak akun kot nent tapël won sëën waisën itaampunëët,’ ar nem pël niak pötaan pëël neanëak yeë ma? ");
INSERT INTO wer_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ne yaap pan niamaan. Ar ingre ya ilak kaö panë anëët. Pël yaëën omën ngönën wonörö pit ërëpsawi ëëpnaat. Arim lupöt ya ngës ëënëët. Pël ëënëëtak pötak kaip tiin ërëpsawi koirënëët. ");
INSERT INTO wer_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Öng namp pi ru wilëpënëak lel yailën këlangön kat wiipna akunet temanöm yesën ya ngës ëëpnaat. Pël ëën ruup oröön pöt ya ngës pöt won sëën rungaap oröa pötaan ya ërëpërëp kön wi yaë. ");
INSERT INTO wer_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Pöta ök ar peene ya ngësring wë. Pël yeëetak ne kaalak arën itaangkën ënëmak ar ërëpsawiaring önëët. Pël ëën omën nampök arim ërëpsawi pöt wa ëp naalniipan. ");
INSERT INTO wer_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Akun pötak arök neen omën nentaan pëël nenëangan. Ne yaap pan niamaan. Ar nem yapintak Pepen omën nentaan manë pöt yok pangk nimpnaat. ");
INSERT INTO wer_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ar ngaan omën nent önëëtaan nem yapintak kimang nemaanörö. Pötaanök kimang maan ningkën arim naë ërëpsawi kësang pan oröak wiaapnaat.” ");
INSERT INTO wer_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Ne wet rëak arën watepang ngön niiaut. Ën ënëm pöt kaalak watepang neniangan. Nem Pepapë songönte tekeri wesak ök niamaat. ");
INSERT INTO wer_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Akun pötak arimtok nem yapintak Pepen kimang manëët. Nook arimëën kimang mema pöt neniaan yeë. ");
INSERT INTO wer_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ar ne lup sant elnëak Pepa naëaan waisaup pöt kön wi kosang yenewes. Pötaan Pepak ar lup sant yaalni. ");
INSERT INTO wer_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ne ngaan Peparing wakaim olëak pi moulmëak e yangerakë waisaup. Pël ëak peene wakaim olëak yanger sëp wesak kaalak Pepa ngësë sumaat.” ");
INSERT INTO wer_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Pël niaan ruurö ten epël yemak. “Peene pöt watepang neniaan, tekeri wesak ök yeniaan. ");
INSERT INTO wer_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ten peene niin ëwat yes. Omnaröak pëlpël neniaan wiaan nim könöök war wesak yaaup. Ni omën poutön ëwatëp. Pötaanök ten peene ni Anutuu naëaan irëaup pöt kön wi kosang yewas.” ");
INSERT INTO wer_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Pël maan Yesuuk kangiir epël yenia. “Yaap, peenök kön wi kosang yewas ma? ");
INSERT INTO wer_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Kat wieë. Akun orööpnaat pël niak pöt yok oröa. Pël ëën ar repak arim kaatë sënëak noolëak sëën nemënt ömaat. Pël ëëmaatak nemënt won. Nem Pepap pi neering wë. ");
INSERT INTO wer_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ar neering wëën arim naë mayaap oröak wiaapënëak niiaut. Ar yangerak wë këlangön kat wiinëët. Pël ëënëëtak yangerakë omën utpetat nook il yemowas. Pël yaëën arim lupöt kosang sak ön.” ");
INSERT INTO wer_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesu tenën pël niak we riak kutömweriil iteneë epël yema. “Pep, akunet yok oröa. Pötaanök nook nim yapin pingët tekeri wes mempaat, nuuk nim Ruup nem yapin pingët tekeri wes man. ");
INSERT INTO wer_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Nuuk omën nem naë wa neulëaurö wëwë kosangët koir mampëak ne yangerak omnaröa ngarangk wes neulëaup. ");
INSERT INTO wer_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Wëwë kosangta songönte epël. Pit ni Anutu këëp niin ëwat wë nim wes nemëaup, Yesu Kristo, neenta ëwat öpna pötak wëwë kosangët pitëm naë orö rëëpnaat. ");
INSERT INTO wer_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ne nim ya ngön neaan pöt mënak pet irumëak yeë. Pël yeem yangerak nim yapin pingët tekeri wes yemangk. ");
INSERT INTO wer_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","O Pep, ngaan kutömre yang naaröön wiaan ne nim naë wë kutöm ë rangiatring wakaimaut. Pötaanök kaalak peene ë rangi tapët nan. ");
INSERT INTO wer_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Ne yangerakë omën nim ne nenan pöröen nim songönte ök maimaut. Omën nimëën yaö wesak nem naë wa neulëa pörö nim ngönta ënëm yaë. ");
INSERT INTO wer_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Pël ëak omën ne nenan pöt pout nim naëaanöt pöt pit ëwat yes. ");
INSERT INTO wer_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ngön pout ne nenan pöt nook pit mangkën yeö. Pël ëak ne nim naëaan waisan pöt pit ëwat sak nuuk ne wes nemëan pötenta kön wi kosang yewas. ");
INSERT INTO wer_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ne pitëmëën kimang yeniak. Omën ngönën wonöröaan won, omën nim ne nenan pöröaan kimang yeniak. Ni pit nimëën yaö wesaurö pötaanök. ");
INSERT INTO wer_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Omën nim piporö tepërimorö. Nem eporö tepërimorö. Pit nem weëre kosangö pet yaalmëën nem yapin pingët orö yarë. ");
INSERT INTO wer_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Pit pöt yangerakë wëwëet om yal menak öpnaarö. Ën nem yangerakë wëwëet pet yair. Pël ëak ne nim naë waisumaan yeë. Pep, ni ngëëngkëp, nim weëre kosang nenan pötring nuuk ngarangk elmëëm. Pël ëën muumöngk öpnaan. Pël ëak tepërim lup kopëtemer sak wë pöl pitta tapël ëak öpnaat. ");
INSERT INTO wer_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ne pitring wë nim weëre kosang nenan pötring ngarangk elmëën muumöngk wakaimaut. Ne ngarangk yaalmëën namp kö nasën. Nim ngönëntak ëan pöt kë rapënëak kopët namp kö sëpënëak yaö ëan pöpökëër kö sa. ");
INSERT INTO wer_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Ne peene nim ngësë aprumëak yeë. Pötaanök nem ërëpsawiet pitëm lupötë oröak ulöl sak wiaapnaataan yangerak wë ök yeniak. ");
INSERT INTO wer_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ne nim ngönöt ök më pet irën omën ngönën wonörö pit kööre tok yaalmë. Pöt ne omën ngönën wonörö pitëm yaaul naën ök tapël pitta omën ngönën wonörö pitëm yaaul naën. Pötaanök kööre tok yaalmë. ");
INSERT INTO wer_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ne pit yangerakaan ömëak kimang neniaan. Omën utpetapë moresiaan ent ë moulmëëmëak kimang yeniak. ");
INSERT INTO wer_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ne omën ngönën wonörö pitëm yaaul naën, ök tapël pitta omën ngönën wonörö pitëm yaaul naën. ");
INSERT INTO wer_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Nim ngön këëtak kom elmëën nimëën yaö sak öpnaan. Nim ngön pöt këët. ");
INSERT INTO wer_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nuuk neen ya ngön neak yangerak omnaröa ngësë wes nemëën pöl nook pit ya ngön mëak omnaröa ngësë wes yemomë. ");
INSERT INTO wer_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Nuuk pit ngön këëtak kom elmëën nimëën yaö sak öpënëak nook nem wëwëet pitëmëën yaö yemowas. ");
INSERT INTO wer_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Ne pitëmëën pëën kimang neniaan. Omën pitëm ngön kat wiak neen kön wi kosang wasëpna pöröaanta yeniak. ");
INSERT INTO wer_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ne omën eporö pourö lup kopëtemer sak öpna pötaan kimang yeniak. Pep, ni neering wëën nem niiring wë pöl pit tepërring öpënëak kimang yeniak. Pël ëën ngönën wonörö pit pöten itenak nuuk ne wes nemëën waisan pöt kön wi kosang wasëpënëak pötenta kimang yeniak. ");
INSERT INTO wer_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Pit tepërim lup koptemer sak wë epël pitta tapël sak öpënëak ë rangiat nim ne nangkën pöt nook pit yemangk. ");
INSERT INTO wer_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Pit lup kopëtemer panë sak öpnaataan ni neering wëën ne pitring wë. Pël ëën omën ngönën wonörö pit pöten itenak nuuk ne wes nemëën waisan pöten kön wiak nuuk ne lup sant yaalnëën pöl pit lup sant yaalmë pötenta kön wiipnaat. ");
INSERT INTO wer_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Pep, omën nim ne nangkën pörö nem kutöm ë rangiat itaampnaan nem ömaarek ten pourö önëak kimang yeniak. Nem kutöm ë rangi pöt ni ngaanëër kutömre yang won wiaan ne lup sant elnëak nenaup. ");
INSERT INTO wer_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","O Pep wotpilëp, omën ngönën wonörö pit niin köpël wëën nookëër niin ëwat wë. Ën omën nem naë wë eporö pit nuuk ne wes nemëën waisan pöten ëwat wë. ");
INSERT INTO wer_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ne nim songönte tekeri wes menaut. Pël ëak tekeri wes meneim ömaat. Pël ëën ne lup sant yaalnëën pöl pitta tapël elmëën. Pël ëën ne pitring ömaan.” ");
INSERT INTO wer_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesu pi kimang ngön pet irak pim ruurö ten koirak i Kitron pömer olëak ëngk komuntakël Olip ya newer wieëa pörekë saut. ");
INSERT INTO wer_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Pörek së wëën Yutas ngaaröen kup mowiipnaap pi Olip ngës pöön ëwatëp yak Yesure ruurö ten ngës pöök kët poutë pörek wa top ë yaaut yak. ");
INSERT INTO wer_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Pörek së wëën Yutas pi Rom nga naröere kiri ar yaaö kaöaröere Parisi ngönën omnaröa naëaan polis narö koirak nga ë omnant wak es mangiak waisa. ");
INSERT INTO wer_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Pël ëën Yesu pi omnant elmëëpna pötön ëwat wëak kepöngk wiak naë së epël pëël yema. “Aë, ar talëpön ap weseim?” ");
INSERT INTO wer_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Pël maan epël yema. “Ten Yesu Nasaret kakaanëp koirënëak yewais.” Pël maan Yesuuk epël yema. “Ne tapöp.” Pël mëak itaangkën Yutas ngaaröen kup yemowiem pit pourö wëa. ");
INSERT INTO wer_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Pël ëën pit pim, “Ne tapöp,” pël mëëa pötaan kasngaë kan së yangaak yengenti. ");
INSERT INTO wer_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Pël ëën kaalak rangk pëël yema. “Aë, ar talëpön ap weseim?” Pël maan epël yema. “Yesu Nasaret kakaanëpön.” ");
INSERT INTO wer_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Pël maan Yesuuk epël yema. “Ne tapöp niakat. Ar nemtën ap yewas pöt omën eporö om wes momëën sëp.” ");
INSERT INTO wer_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Pi pim wet rëak Anutuun, “Omën nim ne nenan pörö namp ap naön,” pël mëëa pöt kë rapënëak ngön pipët mëëa. ");
INSERT INTO wer_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Pël yemaan Saimon Pita pi öpwer wëaup yak yepatuukaan përëak kiri ar yaaö wotöököpë inëën ru namp yapinte Malkas pöp möak pim kat yaapkëëp per olëa. ");
INSERT INTO wer_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Pël ëën Yesuuk Pitaan epël yema. “Öpwer kaalak yepatuuk më. Këlangön Pepak yenangk epot sëp newasngan.” ");
INSERT INTO wer_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Pël maan ngaaröere pitëm wotöököpre polisörö pit Yesu wali wak wii tëa. ");
INSERT INTO wer_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Pël ëak pit pi wak wet rëak Anasë naë sa. Pöt Kaiapas pi akun pötak kiri ar yaauröa wotöök wëaup Anasë koontup wak wëa. ");
INSERT INTO wer_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaiapas pöp wetkaal Yuta omnaröen, “Omën pourö kö sënganëën kopëtapök wel wiipna pöt ompyaut,” pël mëëa pöp. ");
INSERT INTO wer_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ten Saimon Pita pit Yesu wak yesën ënëm saut. Pël ëak kiri ar yaaö wotöököp pi neen ëwatëp yak nemënt Yesuu ënëm kiri ar yaaö wotöököpë ëmöökë öngpök ilëaut. ");
INSERT INTO wer_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ën Pita pi om ëm ngësöök taueëa. Pël ëën kiri ar yaaö wotöököpë ëwatëp nook kaalak ka tomök orö öng ëm kanëra ngarangk wëa pöpön mëak Pita koirak öngpök saut. ");
INSERT INTO wer_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Pël ëën öng ëm kanëra ngarangk pöpök Pitaan epël yema. “Yesuu ruuröakaan namp ni koröp.” Pël maan Pitaak, “Ne won,” pël yema. ");
INSERT INTO wer_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Pël mëak polisre inëën yaaurö tomök ëp ëën es merak taueë mor yesa pöröa naë së es mor yes. ");
INSERT INTO wer_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Kiri ar yaauröa wotöököpök Yesuun pim ruuröen pëël mëak omnaröen ngönën ök yamëëa pötenta pëël mëëa. ");
INSERT INTO wer_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Pëël maan kangiir epël mëëa. “Ne omnaröa ëöetak ngön ök yamëëaup. Yuta omnaröa ngönën tupötëëre ngönën tup kaöetak wa top ëak wëën ök yamëëaup. Ëlëëp naën. ");
INSERT INTO wer_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Tol ëën neen pëël yenëaan? Nem ngön ök yamëëauröen pëël ma. Pit nem yamëëa pöt ëwat wëërek kat mowi.” ");
INSERT INTO wer_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Pël yemaan polis namp pim naë taueëaupök Yesu mor kaë momöak epël mëëa. “Ni wotöököpön pil mangan.” ");
INSERT INTO wer_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Pël maan Yesuuk epël mëëa. “Ne ngön utpet yak pöt utpet pöt war wesak aan ten kat wiinaatep. Yaap yakap oröp ëënak pas yenemöön?” ");
INSERT INTO wer_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Pël maan pim moresiarë wii motëa pöt om ëaul ëaan Anasök wes momëën kiri ar yaaö wotöököp, Kaiapas, pim ngësë sa. ");
INSERT INTO wer_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Saimon Pita pi es mor yesem tauaan piiring wëa pöröak epël yema. “Niinta pim ru namp koröpok.” Pël maan pi yak wesak, “Ne won,” pël yema. ");
INSERT INTO wer_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Pël maan kiri ar yaaö wotöököpë inëën ru namp Pitaë öp möak katëëp per olëa pöpë karipök epël yema. “Yaap, ne itaangkën Olip yaöök piiring wëën itenaut koröp.” ");
INSERT INTO wer_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pël maan Pitaak epël yema. “Ne won.” Pël yemaan kokor namp ngön ya. ");
INSERT INTO wer_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Pit wangam kan röökëër Yesu Kaiapasë naëaan mësak Rom yang ngarangkëpë ka kaöetakë mësak yes. Pël ëak pitëmënt pörö yang ngarangkëpë kaatak lup kewil ëëpanëak kakaati neilan ëa. Pöt tol ëënak? Pit lup kewil ëak pöt Anutuu mait elmëa akun ngëëngktak kaömp nanën ëëpën sa pötaanök. ");
INSERT INTO wer_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Pël wesak om tomök tauaan Pailat pi pitëm naë së epël pëël yema. “Ar oröpmor ëën omën epop ngön yaatak ulmëënëak mësak yewais?” ");
INSERT INTO wer_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Pël maan pit epël yema. “Pi utpet naën ëanëën ten pas mësak newaisën ëan tapön.” ");
INSERT INTO wer_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pël maan Pailatök epël yema. “Arimtok mësak së ngön yaatak ulmëak arim ngön kosangta wieëaul elmëeë.” Pël maan Yuta omnaröak epël yema. “Ar Rom omnarö arim ngön kosangtak tenim naë omën yamëngkautaan nga wia.” ");
INSERT INTO wer_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Yuta omnarö pit pël yemaan ngaan Yesu pimtok pim këra yetaprak möön wel wiipnaat ngön pël mëëa pöt kë oröa. ");
INSERT INTO wer_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pël maan Pailat pi kaalak kakaati ilë wë Yesuun ngön maan sëën epël mëëa. “Ni Yuta omnaröa omën omp aköp ma?” ");
INSERT INTO wer_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Maan Yesuuk epël mëëa. “Ngön pit nimtok kön wiak yaan ma omën naröak ök niaan yaan?” ");
INSERT INTO wer_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pël maan Pailatök kangiir epël mëëa. “E, ne Yuta omnamp ma? Nimtë omnaröere kiri ar yaaö kaöaröak nem naë mësak wais yanuulëëp. Ni tolël ëaup?” ");
INSERT INTO wer_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Pël maan Yesuuk kangiir epël mëëa. “Nem omnarö wa ngaöök yamëa pöt yangerakaan wonte. Pël ëeëanëën nem ruuröak nga elmëën Yuta omnaröak ne neneön ëan tapön. Nem omnarö wa ngaöök yamëa pöt yangerakaan wonte.” ");
INSERT INTO wer_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pël maan Pailatök epël mëëa. “Ën ni omën omp ak namp ma?” maan Yesuuk epël mëëa. “Nim neen omp ak namp pël yenëaan pipët yaap. Ne ngön këët tekeri wasumëak yangerak wes nemëën nem ëlëpök newilaup. Pötaanök namp pi ngön këëta ënëm ëëpna pöp nem këm ngönte kat wiipnaap.” ");
INSERT INTO wer_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pël maan Pailatök epël mëëa. “Ngön kë pöt tol nent?” Pël mëak kaalak tomökël orö epël yema. “Nem piin nga elmëëma utpet nent pim naëlaan nokoirën. ");
INSERT INTO wer_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Arim yeë pöl ne Anutuu mait elmëa ngëëngk akunetak omën namp wii kaatakaan öpënëak wes nimë yeë. Pötaanök ne ar Yuta omnaröa omën omp aköp wes nimëën sëpën ma?” ");
INSERT INTO wer_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Pël maan pit ngön ë olëak epël yema. “Pipmor won. Ni Parapasökëër wes nimë,” pël yema. Parapas pöp pi omnarö mënak pitëmot kain yewaup. ");
INSERT INTO wer_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pailatök pim ngaaröen maan Yesu pol koröp wapötringöök momöa. ");
INSERT INTO wer_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Pël ëak ngaaröak ökre was mëak wii këmampön ulte ket ëak kepönöök mowaëak ngaaröa ulpëën köp möa namp wa momëa. ");
INSERT INTO wer_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Pël elmëak naë së epël mëëa. “Yowe, Yuta omnaröa omën omp aköp,” pël mëak mor kaë momöa. ");
INSERT INTO wer_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pël yaëën Pailat pi kakaatiaan orö Yuta omnaröen epël yema. “Iteneë. Ne piikaan nga elmëëma utpet nent nokoirën. Pötaan arimëntta ëwat sënëak wes yanimë.” ");
INSERT INTO wer_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Pël mëak Yesu pi këmampön ulre ulpëën pötring mësak tomök orö ulmëak epël yema. “Omën epopön iteneë.” ");
INSERT INTO wer_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Pël maan kiri ar yaaö kaöaröere polisörö iteneë ëlak wiak epël yema. “Këra yetaprak möön wel wiip. Këra yetaprak möön wel wiip.” Pël yemaan Pailat pi epël yema. “Piikaan nga elmëëma utpet nent nokoirën. Pötaanök arimtok wak këra yetaprak momöeë.” ");
INSERT INTO wer_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Pël maan Yuta omnaröak epël yema. “Pimtok pimtën, ‘Ne Anutuu Ruup,’ pël yamëem Anutuu yapinte wa ngep yaë. Pötaanök tenim ngön kosangtak, ‘Pi wel wiip,’ pël ya.” ");
INSERT INTO wer_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pël yemaan Pailat pi ngön pöt kat wiak kas pan ëa. ");
INSERT INTO wer_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Pël ëak kaalak Yesu mësak pim ka kaöeta kakaati ilë epël mëëa. “Ni tarëkaan oröaup?” Pël maan Yesuuk kangiir nemaan ëa. ");
INSERT INTO wer_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pël ëën Pailatök epël mëëa. “Töl ëënak neen ngön nenëaan yaën? Ne wil niulëëmaare këra yetaprak nimööma poutë weëre kosangët pangk ëaap. Ni pöten köpël ma?” ");
INSERT INTO wer_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Pël maan Yesuuk kangiir epël mëëa. “Anutuuk weëre kosang naningkën ëanëën neen ngep ëak nenëaan ëan tapön. Pötaanök omën ne newak nim ngësë wes nemëa pöpë saunetak nimët il yewas.” ");
INSERT INTO wer_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pël maan Pailat pi ngön pöt kat wiak wes momëëpënëak yemaan Yuta omnaröak ngön ëak epël yema. “Ni omën pipmor wes mëëmë pöt Rom omën omp ak kaöap Sisa ngöntre kar naalmëën ëëmëët. Omën namp pi pimtok pimtën omën omp aköp apna pöp pi Sisa piin kööre tok elmëëpnaat.” ");
INSERT INTO wer_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pël maan Pailat pi ngön pöt kat wiak Yesu mësak tomököl orö ngön ë pet yaira urtak wel aisëa. Ur pöta yapinte Kël Purpurwer. Pöwer Yuta ngöntak Kapata pël yamëëa. ");
INSERT INTO wer_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Akun pöt Anutuu mait elmëa akun ngëëngktakëën omnant wa kön yaaö këttak yak këtëp luptak wëën Pailatök Yuta omnaröen epël yema. “Arim omën omp aköpön iteneë.” ");
INSERT INTO wer_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Pël maan pit ngön ëak epël yema. “Pi wel wiip, wel wiip. Këra yetaprak möön wel wiip.” Pël maan Pailatök epël yema. “E, arim omën omp aköp këra yetaprak möömëak yak ma?” Pël maan kiri ar yaaö kaöaröak epël yema. “Ten omën omp ak munt nampta won, Sisa kopëtap.” ");
INSERT INTO wer_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Pël maan Pailat pi ngön pöt kat wiak Yesu këra yetaprak mööpënëak ngaaröa naë wes yemomë. ");
INSERT INTO wer_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ngaarö pit Yesu pimtë këra yetapër menak waalën kakaan mësak yang lup nenta yapinte Kepön Kos, Yuta ngöntak Kolkota, pörekë yes. ");
INSERT INTO wer_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Pörek së Yesu këra yetaprak mö yemoulmë. Yesu tekrak, ën omën naar, namp we naöök ë yaulmë. ");
INSERT INTO wer_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pël ëën Pailatök ngön nent epël retëng ëak këra yetaprak wi yaulmë. “Yesu, Nasaret kakaanëp, Yuta omnaröa omën omp aköp.” ");
INSERT INTO wer_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Yesu yetaprak möa yang lup pöt Yerusalem kak naë yak Yuta omnarö kamtaöök kaal wak yeem sangk kel yeëa. Retëng pöt Pailatök Yuta ngöntakre Rom ngöntakre Krik ngöntak poutë wi ulmëaut. ");
INSERT INTO wer_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Pël ëën Yuta omnaröa kiri ar yaaö kaöaröak Pailatën epël yema. “Ni, ‘Yuta omnaröa omën omp aköp,’ pël retëng ëënganëp. Epël ë. ‘Puuk, “Ne Yuta omnaröa omën omp aköp,” pël yaaupok,’ pël retëng ë.” ");
INSERT INTO wer_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pël maan Pailatök epël yema. “Yok retëng ëanrek epël wiaap,” pël yema. ");
INSERT INTO wer_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ngaarö pit Yesu yetaprak mö ulmëak pim ulpëënre poë koröpöt kom ëak kong nent wesak neenemot ëa. Pël ëak pit pim ulpëën waliip omnaröa ket yeem ilak korir namëënëp wa. ");
INSERT INTO wer_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Pël ëak pit neneren epël ök mëëa. “Tiar epop kelinganëp. Om ngasamtak wiak talëpök öpën pöten itaampa.” Pit pël ëën ngönëntak epël ëa pöt kë oröa. “Pit nem ulpëënre poë koröpöt kom ëak wak ngasamtak wiak talëpök nem ulpëën waliip öpën pöten itena.” Pël wia pötak ngaarö pit pël ëa. ");
INSERT INTO wer_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Yesuu këra yetapra ingtak öng epël ëak taueëa. Yesu ëlëpre ëlëpë nangapre Maria, Klopasë öngöpre Maria Matala kakaanëp pël ëak taueëa. ");
INSERT INTO wer_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Pël ëën Yesu pi itaangkën pim ëlëpre ne pim ru kent yaaup, tenip pim naë tauaan ëlëpön epël yema. “Ma, epop nim ruup.” ");
INSERT INTO wer_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Pël mëak neen epël yenëa. “Epop nim ëlëp.” Pël neaan akun pötak ne Maria mësak nem kaatak së ulmëak ngarangk elmëeimaut. ");
INSERT INTO wer_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Pël mëak Yesu pi pim yaat pet yair pël kön wiak ngönëntak wia pöt kë rapënëak epël ya. “Ne iiten yaë.” ");
INSERT INTO wer_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Pël yaan pit i kaö kel newer wak wain i som kep nent peö ëak wieëa pötak wariak këkalëp naö yapinte isop pöök wa tëak këmtak yemowas. ");
INSERT INTO wer_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Pël ëën Yesu i pöt nak epël ya. “Yok pet yair.” Pël ëak kepönö töak ngemaan pim könöp oröön wel yawi. ");
INSERT INTO wer_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Anutuu mait elmëa akun ngëëngktakëën Yuta omnarö pit omnant wa kön yeëa. Pötaanök pit omën sokur akun ngëëngktak këra yetaprak möaurö ngaarëk utaapnaaten kaaö ëën së Pailatën epël mëëa. “Ten yok pangk së ing kilöt rë moutak sokur ent ë wiin ma?” ");
INSERT INTO wer_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Pël maan Pailatök ngaarö wes mëën së omën Yesuu naë möa pöaarë ing kiltepar rë yemout. ");
INSERT INTO wer_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Pël ëak Yesuun itaangkën pi yok wel wia ëën ing kiltepar nemoraan yaë. ");
INSERT INTO wer_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Pël ëautak nga omën kopët nampök ingëper kalapmorök wesirën iire ëröt yaarö. ");
INSERT INTO wer_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Omën pöt yaëën itenaup nook arta kön wi kosang wasënëak ngön yaap ök yeniak. Ne ëwat wë ngön yaap yeniak. Pötaanök ar kön wi kosang wasën. ");
INSERT INTO wer_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ngönëntak epël wia pöt kë rapënëak oröa. “Pit pim kos naö mö narëëpan.” ");
INSERT INTO wer_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ën ngönëntak ngön munt nent epël ëa. “Omnaröak pitëm ingëp moëa pöpön itaampnaan.” ");
INSERT INTO wer_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Yesu wel wiin Arimatia kakaan omën namp Yosep ngaan Yesuu ru sak wakaimaupök Yuta omën kaöaröen kas ëën ëlëëp wëaupök Pailatë naë së Yesuu sokur ent ëëpënëak ök mëëa. Pël ëën Pailat pi kuure mak maan së sokur ent ëa. ");
INSERT INTO wer_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Pël ëën Nikotimas ngaan röök nentak Yesuu naë sa pöp pi kolap köp nga kamp yaaö kep nent pim könömët 45 kilokram pöta ököt wak sa. ");
INSERT INTO wer_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Pël ëën piarip Yuta omnaröa welarö weerëpënëak yaaul kolap köp nga kamp yaaö pöt wa momëak poë koröpöök kör koëa. ");
INSERT INTO wer_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Yesuu yetaprak möa yang lup pöta nokoliil ngës naö wieëa. Ngës pöök omën sokut wak së wiipënëak yaö ëa kël öngöp naö wieëa. Pö omën namp nawiinö. ");
INSERT INTO wer_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Pöt Anutuu mait elmëa akun ngëëngktakëën Yuta omnarö pit omnant kön yaëën kël öngöp pö naë wiaan yak piarip Yesuu sokur wak së weera. ");
INSERT INTO wer_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Santeetak röökëër Maria Matala kakaanëp koutaring omën yangaöökë sa. Pël ëak së itaangkën kël ur wari ulmëaumpel wa olaan kan të wieëa. ");
INSERT INTO wer_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Pël ëën pi itenak pöömpö wais ten Saimon Pitaë naë oröak epël yenia. “Pit tiarim omp aköp wak së tarëk wia wes? Ten köpël.” ");
INSERT INTO wer_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Pël niaan ten Pita kaatakaan oröak omën yangaöökë saut. ");
INSERT INTO wer_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Pël ëak kan kourak yesem nook Pita ënëm rë moolëak ne wet rëak omën yangaöök së oröaut. ");
INSERT INTO wer_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Pël ëak ne öngpök neilaan. Om tok ori öngpök itaangkën Yesuu poë koröp pëënö wieëa. ");
INSERT INTO wer_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Pël ëak wëën Saimon Pita pi nem ënëm wais omën yangaöökë öngpök së itaangkën poë koröpö wieëa. ");
INSERT INTO wer_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Pël ëën itaangkën poë koröp Yesuu kepönöök kör koëauta wieëa. Pö muntaöring erën ëak wi naön. Ponspons ëau pëlëër wieëa. ");
INSERT INTO wer_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Pël ëën wet rëak së oröaup nookta öngpök së itenak kön wi kosang wesaut. ");
INSERT INTO wer_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Pël ëa akun pötak Anutuuk ngönëntak, “Pi weletakaan wal ëëpnaap,” pël ëa pöt kön nawiin ëaut. ");
INSERT INTO wer_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Pël ëak tenip kaalak kakël saut. ");
INSERT INTO wer_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maria pi omën yangaöök om wë ing aim wiak kël öngöpöök tok oriak itena. ");
INSERT INTO wer_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Pël ëak itaangkën ensel naar ulpëën kölamaar mëëauwaar kël öngöpöökë kakaati Yesuu urtak, namp ingesiarë urtak namp kepönöökë urtak ëak wel aisaëeëa. ");
INSERT INTO wer_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Pël ëeëaurekaan epël mëëa. “Öng epop, ni tol ëënak ing yaan?” Pël maan epël mëëa. “Omnaröak nem Aköpë sokur wa pi nerek wia. Ën ngaöl yeëep pit korak tarëk wia wes? Ne pöten köpël.” ");
INSERT INTO wer_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Pël mëak kaip ti itaangkën Yesu taueëa. Pël ëën Maria pi itenak, “Epop Yesu,” pël newasën ëa. ");
INSERT INTO wer_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Pël ëën Yesuuk epël mëëa. “Öng epop, ni tol ëënak ing yaan? Talëpön ap yewasën?” Pël maan Maria pi ngës pöökë pepapök ya wesak epël mëëa. “Kaöap, nuuk pim sokur wak së nerek wiaup pöt wiaurekën ök nea. Pël ëën ne së ömaan.” ");
INSERT INTO wer_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Maan Yesuuk epël mëëa. “Maria.” Pël maan Maria pi kaip tiak Yuta ngöntak, “Raponai,” pël mëëa, pöt tiarim ngöntak, Rë yanuulaup. ");
INSERT INTO wer_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Pël maan Yesuuk epël mëëa. “Ni ne wali neöngan. Ne nem Pepapë ngësë nawisën wë. Pël ëaarek ni së nem karuröen epël ök mam. ‘Ne Anutu nem Pepapë ngësë isumaap. Nem Pep pöp arim Pepap. Ën nem Anutu pöp tapël arim Anutu.’” ");
INSERT INTO wer_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Pël maan Maria Matala kakaanëp pi wais ten Yesuu ruuröen epël yenia. “Ne omp aköpön itenaut.” Pël niak Yesu ngön piin mëëa pöt tenën ök niiaut. ");
INSERT INTO wer_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Yesuu ruurö ten Sante rö kan Yuta omnaröen kas ëën ka kan wari ulmëak kakaati wëën Yesu pi wais tenim tekrak taueë epël yenia. “Arim naë mayaap wiaap.” ");
INSERT INTO wer_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Pël niak pim kalapre morre pöt pet elniin piin itenak ya kë saut. ");
INSERT INTO wer_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Pël yaëën Yesuuk kaalak epël yenia. “Arim naë mayaap wiaap. Pepak ne wes nemëën waisaut, nook tapël ar wes yanimë.” ");
INSERT INTO wer_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Pi pël niak pul mën nimëak epël yenia. “Ar Ngëëngk Pulö weë. ");
INSERT INTO wer_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Pël ëak omnaröa saunat kërë moolaan won sëpnaat. Ën nemokërëën ëën pöt om wiaapnaat.” ");
INSERT INTO wer_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Yesu ten pim ru pöröen ëö pet elnia akun pötak tenim kar namp yapinte Tomas yapin nent Ruprup Ëak Wilaup, pi won. ");
INSERT INTO wer_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Pël ëën tenök piin epël ök mëëaut. “Ten Aköpön itenaut.” Pël maan Tomas pi epël yenia. “Nemtok nem itöörarök pim moresiarë wap sëëteparën itaampööre mor wotööring morö itaampööre ën kalapmorök ingëp ëa seltak mores wesir itaampö pël naën ëëma pöt yaap newasngan.” ");
INSERT INTO wer_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Wë sant nent won sëën Santeetak Yesuu ruurö ten Tomasring kaalak kakaati wa top ëak ka kan wari ulmëak wëën Yesu pi kaalak wais tenim tekrak taueë epël yenia. “Arim naë mayaap wiaap.” ");
INSERT INTO wer_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Pël niak Tomasën epël yema. “Nim mor wotö nem moresi wiak itan. Pël ëak mores nem kalapmorök ingëp ëa seltak wesir. Pël ëak kön selap ëënganëp kön wi kosang newasum.” ");
INSERT INTO wer_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Pël maan Tomasök epël yema. “Ni nem Aköp. Ni nem Anutu.” ");
INSERT INTO wer_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Pël maan Yesuuk epël yema. “Ni neen itenakök kön wi kosang yenewasën ma? Omën neen itnaangkënöröak kön wi kosang newasëpna pörö ërëpërëp ëëpnaarö.” ");
INSERT INTO wer_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu pi tenim itöök retëng selap pan imaut. Pël ëa pöt ne pout pep epweri retëng naën. ");
INSERT INTO wer_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ne pi Anutuu Yaö Mëëaup, Kristo, Anutuu Ruup pöt ar kön wi kosang weseimeë pim naëaan wëwë kosangët koirënëëk yak kopët eptepar retëng yeë. ");
INSERT INTO wer_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Wë akun nentak Yesuu ruurö Taipirias i kaöök së wëën Yesu tenim naë oröa. Ten ru eporö, ");
INSERT INTO wer_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimon Pitaare Tomas yapin nent Ruprup Ëak Wilaup, Nataniel Kena kak Kalili yangerakaanëpre Sepeti pim ruaarre ten Yesuu ru munt naar pël ëak wëën oröa. ");
INSERT INTO wer_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Wë Saimon Pita pi epël yenia. “Ne i kaöök imën nga ë sumaan.” Pël niaan ten epël mëëaut. “Tiar pourö sëpenaan.” Pël mëak tenta wangaöök ilëak ten pourö së röök pötak animaö namp naön ëaut. ");
INSERT INTO wer_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ten i kaöök së wëën ëwa tëak kët mapënëak yaëën itaangkën Yesu pi i pisöök taueëa. Pël ëën ten itenak piin Yesu pël newasën ëaut. ");
INSERT INTO wer_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Pël yaëën Yesuuk epël yenia. “Nem ruurö ar imën namp koran wesetak?” Pël niaan ten epël mëëaut. “Won pan.” ");
INSERT INTO wer_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Pël maan pi epël yenia. “Ar wangaöökë ë yaapkëëlöök olaë. Pël ëak narö korönëën.” Pel niaan ten iirëëp kaöökë öngpök olaan imënörö kësang pan ilëak peö ëak wëën werunëak poprak ëaut. ");
INSERT INTO wer_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Pël ëën nook Pitaan epël mëëaut. “Ëngkop Omp Aköppe.” Pël maan Saimon Pita pim ulpëënëp përë wiak ya yamëngkem wëaurekaan Omp Aköpë yapinte kat wiak ulpëënëp wa mëak i kaöök sörok yoola. ");
INSERT INTO wer_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Pël yaëën ten wangaöökë ngaarëk së imën iirëëp weru wiaut. Pöt i pisö wali won, kot nent temanön, 100 mita pöta ök. ");
INSERT INTO wer_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","I pisöök së el ulmëak itaangkën es newes meraan imënre kaömp nant ar ëeëa. ");
INSERT INTO wer_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Pël ëën Yesuuk epël yenia. “Ar arim imën peene wan pöröakaan narö wak waiseë.” ");
INSERT INTO wer_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Pël niaan Saimon Pita pi wangaöökë ngaarëk is iirëëp weru i pisöökël yawi. Pël ëak itaangkën imënörö peö pan ëeëa. Pitëm saareet 153 pöt selap pan iirëëp ilëpna saltak nailën ëaut. ");
INSERT INTO wer_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Pël ëaan Yesuuk ten së kaömp nën yenia. Pël ëën ten pourö, “Epop Omp Aköp,” pël wesak tenëkaan nampök Yesuun, “Ni talëp?” pël nemaan ëaut. ");
INSERT INTO wer_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Pël ëën Yesuuk wais kaömpöt kom ë ninak imënöröeta tapël yaë. ");
INSERT INTO wer_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yesu pi weletakaan wal ë wë tenim naë orö nirëën nentepar nent ëa pöt pipët. ");
INSERT INTO wer_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ten kaömp na pet irak Yesuuk Saimon Pitaan epël yema. “Saimon, Sonë ruup, nim neen lup sant yaalnëën pöt eporöaat il yemowasën ma won?” Pël maan Pitaak epël yema. “Omp Aköp, yaap ni ëwat wëën. Ne lup sant yaalni.” Pël maan Yesuuk kangiir epël yema. “Ni nem sëpsëp ruurö ngarangk ëeim öm.” ");
INSERT INTO wer_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Pël mëak Yesuuk kaalak akun nentak epël yema. “Saimon, Sonë ruup, ni neen lup sant yaalnëën ma?” Maan Pitaak epël yema. “Aköp, yaap ni ëwat wëën. Ne lup sant yaalni.” Pël maan Yesuuk epël yema. “Ni nem sëpsëpörö ngarangk ëeim öm.” ");
INSERT INTO wer_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Pël mëak kaalak akun munt nentak epël yema. “Saimon, Sonë ruup, ni neen lup sant yaalnëën ma?” Pël maan Pita pi Yesu pim akun nentepar nent, “Ni neen lup sant yaalnëën ma?” pëël mëëa pötaan ya ngës ëak epël yema. “Aköp, ni omën poutön ëwat yaaup. Nem niin lup sant yaalni pötenta ëwat wëën.” Pël maan Yesuuk epël yema. “Ni nem sëpsëpörö ngarangk ëeim öm. ");
INSERT INTO wer_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ne yaap pan niamaan. Ni ngaan ulwas wë kan nim kent kön wiautëël sumëak nimtok nim yepatu urak seimaup. Wë ulöp sumë pötak nim moresiar elmëak wëën maim nampök wii nitëak nim kaaö ëëmë pöl mës nuwak sëpnaat.” ");
INSERT INTO wer_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesu pi ngön pipët Pitaë wel wiipna akunetak Anutuu yapinte wak isëpnaat pötakëlök mëëa. Pël mëak kaalak epël yema. “Nem ënëm ëëm.” ");
INSERT INTO wer_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Yesure Pita piarip yesem Pita pi kaip ti itaangkën ne piarpim ënëm yesan. Ne ngaan kaömp naö akunetak Yesuu naë wel aisëeë piin epël mëëaut. “Aköp, talëpök niin kup mowiipën?” ");
INSERT INTO wer_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pël ëën Pitaak neen itenak Yesuun nemëën epël yema. “Omp epop tolël ëëpën?” ");
INSERT INTO wer_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Pël maan Yesuuk kangiir epël yema. “Nem kentöök pi om wëën ne kaalak waisuma pöt nemtëët. Ën ni nem ënëm ëëm.” ");
INSERT INTO wer_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Pël maan pit repak së pitëm karuröen epël mëëa. “Omën pöp wel nawiin ëëpën ya,” pël mëëa. Pël ëaap Yesu pi pöt, wel nawiin ëëma pöten nemaan. Pi om epël mëëa. “Nem kentöök pi om wëën ne kaalak waisuma pöt nemtëët.” ");
INSERT INTO wer_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Yesu pi neenök ngön pipot ëa. Ne tapöpök ngön epot retëng ë yaningk. Epot pout yaapöt. Nem karuröeta nem epotön yaap ya pël yewas. ");
INSERT INTO wer_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesu ya ke nentere nent mëneimaut kësang wiaap. Ne kön wiin pöt pout pepatë wiipena pöt selap pan ëëpnaat. ");
INSERT INTO wer_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","O Tiopilas, Ne peene kaalak pep epwer retëng ë yaningk. Nem ngaantak ngön retëng ë nina pötön ni ëwat wëën pöt Yesu pim ya mëmpööre ngönën aö pël ima pötë ngönöt akun pim yaat ngës rëa ");
INSERT INTO wer_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","pörekaan mëmpö yesem Pepapë akun mowia pöt temanöm sëën pepapök koirak kutömweri isa. Pël ëën akun pötak Yesu pi weletakaan wal ëak kutömweri nawisën wëën Ngëëngk Pulöök kaamök elmëën puuk pim ngön yaaö omën wet rëak yaö elmëaö pöröen pitëm ya mëmpnaata ngönöt ök maima. ");
INSERT INTO wer_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Pël ëak kët akun selap 40 ruuröa naë ëö pet elmëeim wakaima. Pöt pit piin itenak pi yok yaap wal ëak wëa wesak kön wi kosang mowasëpna yak pël ëak pi wet rëak ruuröen Anutuu songönöt ök maima. Puuk omën pourö wa ngaaök nimëak wë. ");
INSERT INTO wer_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Pël ëën akun nentak Yesuu ngön yaaö omnarö pit wa top ëak wëën Yesu pi pitën ngön kosang wesak epël ök mëëa. “Ar teëntom Yerusalem kak sëp wasnganok. Ar eprek om kor ön. Pël ëën nem Pepapök Ngëëngk Pulö nimpënëak neen ök neaan nem arën ök niia pö nimpnaat. ");
INSERT INTO wer_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ngaan ök niak pöt omën eptaanök ngaan Son pi i yaaptak öngre ompörö i momëa. Ën kot nent wë pöt nem Pepapök Ngëëngk Pulöök i ket ëak nimëëpnaat.” ");
INSERT INTO wer_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Akun nentak kaalak Yesu pim ngön yaaö omnarö pit Yesuring Olip tomök së wë ruurö pit epël pëlpël mëëa. “Aköp aë, tiarim ëaröa ngaanëër eima pöl ni yok pangk aan Israel omnarö tiarimtok tiarimënt nener ngarangk ëëpen ma won?” ");
INSERT INTO wer_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Pël maan pi kangiir epël ök mëëa. “Iteneë. Nem Pepap pimtok akun nenten yaö wasën wia pötakök omën puot orööpnaat. Yaö ëa pötakök omën pöt orööpna akun pöten ar ëwat nasëngan. ");
INSERT INTO wer_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pël ëënëëtak ar epël kön wiaan. Pi weëre kosang kësang ar nimpënaat, akun Ngëëngk Pulö arim ngësë waisëpna pötak. Pël ëën ar nem ngönta omnarö pël sak wë nem songönte tekeri wesak Yerusalem omnaröen ök mëak aö aö ë yesem Yutia omën muntaröen ök mëak om aö yesem Sameria omnaröen ök mëak aö yesem kaare yang nantë së pet irëp. Pël ëën omën pourö neen ëwat sëpnaan.” ");
INSERT INTO wer_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Akun pötak Yesu pi ngön epot ök më pet yairën Anutuuk koirak kutömweri isa. Pël ëën ruurö pit mopöök iteneim wëën kepëltak is ilëak kö sak sa. ");
INSERT INTO wer_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Pi sëën pit ngaarëkël om iteneim wëën tapëtakëër omën naar pitëm naë oröak taueëa, ulpëën kölam panëëwaar mëauwaar pöaarök pitën epël ök mëëa. ");
INSERT INTO wer_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","“Kalili omnarö, ar oröpmorëën mopöökël we riak itnakaim? Yesu pi Anutuuk koirak o kutömweri yawis. Pi peene ar itenaan yawis pi tapël kaalak irapnaap.” ");
INSERT INTO wer_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Yesu pim ngön yaaö omnarö pit Olip tomökaan kaalak Yerusalem kakë sa. Tomökaan kakë saö pöt wali won, om wan kilomita pöta ök. ");
INSERT INTO wer_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Pël ëak Yerusalem kaöökë öngpök së oröak el wesak ka wet rëak pitëm së wakaim wiak sa pötak së ilëa. Pël ëak ka kaö ngaarëkël wieëa pörek së wel aisëak wakaima. Pit omën eporö, Pitaare Son, Semsre Entru, Pilipre Tomas, Patolomiuure Matiu, Sems muntap Alpias pim ruup, piire Saimon pi ngaan Rom kamanëp sëp mowasëpënëak aima omën tok pötakaanëp, piire Yutas muntap Sems muntapë ruup. ");
INSERT INTO wer_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Pit omën piporö öng naröaring pit pourö wa top ëak wëa. Maria Yesu pim ëlëp, piire pim yokoturö pit pourö wë Anutuun ök maima. ");
INSERT INTO wer_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Akun nentak Yesuu ru 120 pörö kaalak wa top ëak wë Pita pi pitëm tekrak wal ë tauak epël ök mëëa. ");
INSERT INTO wer_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Nemorö, Ngëëngk Pulöök ngaanëër elmëën omën omp ak Tewit puuk ngönën pepeweri ngön nent retëng ëaö pöt peene kë oröa. Pi Yutas pöp omën Yesu moröpnaarö mësak kan pet elmëën Yesu moröaup piinök ëa. Pöt Yutas pi kawi ngentiin muntap pim urtak sëpna pötenök ëa. ");
INSERT INTO wer_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Tiar ëwat wë. Yesu pi Yutas tenring öpënëak mëëaup. Pël ëën Yutas pi tenring ya waup.” ");
INSERT INTO wer_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Pi pël ëak Yesuun kup mowia utpet pöta sumet waup. Pël ëak pi sum pötaring yang lup nent sum ëa pöt, kawi ngentiak yaat pör menak oröa. ");
INSERT INTO wer_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Pël ëën Yerusalem kakë omën pourö pit ngön pöt wak wë yok wel wia wesa. Pël ëak pit yang pöta yapinte Akeltama pël mëëa. Yapin pöta songönte pöt epël, Omën Iita yanget. ");
INSERT INTO wer_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Tewit pi tan pep Sam pöweri Yutas pimëën epël retëng ëa. ‘Pim kaat om pas wiaap. Omën namp pötak öpan.’ Ën Sam pöweri tan munt nentak epël ëa. ‘Omën muntapök pim urtak sak pim ya mëna pöt kaalak mëmp.’ ");
INSERT INTO wer_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Pötaanök tiar omën munt namp pim urtak koir ulmëëpenaan, Yesu pim ngön yaaö omnarö 11 tenim naë. Pël ëën puuk Aköp Yesu weletakaan kaalak wal ëa pöt apnaap. Pötaanök tiar omën namp tiarimtë naëlaan koirëpenaan. Pi ngaan pan tiarring wëën Sonök Yotanëk Yesu i yemomëën itenaupök om wë yewaisem wëën Anutuuk Yesu koirak mopöök kutömweri yawisën itenaö pöpök.” ");
INSERT INTO wer_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pita pi ngön pël ök maan pit omën naar tekeri wesa. Nampë yapinte Yosep, omnaröak Pasap pël yamëëa pöp, pim yapin munt nent Sastas pël yamëëaup. Ën nampë yapinte Mataias. ");
INSERT INTO wer_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Pöaar wël ë ulmëak Aköpön epël ök mëëa. “O Aköp, ni omën pouröa lupötön ëwatëp. Pötaanök niin pëlpël yeniak. Omën epaarë naëaan namp ma nampök ya epët wak Yesu pim ngön yaaö omnamp pël sëpnaap? ");
INSERT INTO wer_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Pël ëak puuk Yutas pim ya sëp wesa epët mëmpnaan. Pi pöt yok sa, Aköpë pimëën kaare yang yaö elmëaö pörekë.” ");
INSERT INTO wer_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Pël mëak talëpök isëpënëak itena pöt Mataiasök isa. Pël ëën pit pi il moulmëën Yesu pim ngön yaaö 11 pitring wakaima. ");
INSERT INTO wer_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Yuta omnaröa akun ngëëngk kësang nent yapinte Pentikos pël ya pötak Yesuu ingre mor saurö pit ka nentak wa top ëak wëa. ");
INSERT INTO wer_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Akun pötak pit kakaati wëën omën nempel mopöökaan uure kapkapëër kent ket ëak teëntom irë pitëm wëa ka pötak ilëak pangk ëak wieëa. ");
INSERT INTO wer_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Pël yaëën pit itaangkën omën pitëm tekrak oröa pöt es wilëngre yangap pötë ök sak kom kap ëak omnaröa rangk ngentia. ");
INSERT INTO wer_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Pël ëak Ngëëngk Pulö Yesuu ingre mor saurö pitëm lupötë ilëak peö ëak pit weëre kosang kësang kaamök elmëën ngës rëak ka nantëëröa kakë ngönötring ngön ök aima. ");
INSERT INTO wer_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Akun pötak Yuta omën ka waliitëaanörö Yerusalem kak së peö ëak wëa. Pit ngönëntaan kent ëak pitëm kaat sëp wesak së wëa. ");
INSERT INTO wer_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Pël ëak wë pit u pömpelën kat wiak naë së ityeengka pöt Yesu pim ruurö pit omën sa pöröa ngönötë ngönën ök maan kat wiak yaan sa. ");
INSERT INTO wer_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Pël ëak epël mëëa. “Elei, omën ngön ya eporö pit pourö Kalili omnaröep. ");
INSERT INTO wer_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Pit tol ëakök aan tiar neenem ngönötë kat yawi? ");
INSERT INTO wer_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","11","Tiarim kakë ngön ke nentere nent kësang wia. Pël ëaatak tiar ka poutë ngönötëël ya kësangöt Anutu pim weëre kosangööring yamëngkauten kat yawi. Itneë. Tiar narö Patia yangrakaanörö, narö Mitia yangrakaanörö, narö Ilam yangrakaanörö, narö Mesopotemia yangrakaanörö, narö Yutia yangrakaanörö, narö Kapatosia yangrakaanörö, narö Pontas yangrakaanörö, narö Esia yangrakaanörö, narö Prisia yangrakaanörö, narö Pampilia yangrakaanörö, narö Isëp yangrakaanörö, narö Lipia yangerak Sairini kak naëaanörö. Tiarim naëaan, narö Rom kakaanörö, Yuta yaapöröere köpël Yuta panëëröa öngpök ilëaurö. Ën tiarim naëaan naröeta Krit kustaakaanörö, narö Arepia yangrakaanörö. Yaap pan, tiarim kakë ngönöt selap wiaatak yok pangk tiarimtë ngönötë Anutu pim weëre kosangring ya yamëngka pöta ngönte ök niaan kat yawi.” ");
INSERT INTO wer_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Pël mëak pit yaan sak kön selap ëak neneren epël maima. “Elei, pit tol ëak epël ya?” ");
INSERT INTO wer_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Pël yemaan naröak ökre wasiin wesak epël mëëa. “Pit wain i ngaat nak kön irikor ëak ya.” ");
INSERT INTO wer_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Pitëmënt pël aö yesën Pita pi Yesuu ngön yaaö omnarö 11 pitëm naëaan wal ë tauak maap ngön ëak epël mëëa. “Yuta omnarö, ar tenim karuröere Yerusalem kak wëaurö, ar këëkë wesak kat wieë. Pël ëën omën e yaarö epëta ngönte ök niamaan. ");
INSERT INTO wer_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Arim naëaan naröak ten i nak kön irikor ëak wë yak pël aim. Pöt won. Peene wangam kan ngolöp 9 kilok yaë. Talëp epëtak i nak kön irikor yeëa? ");
INSERT INTO wer_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Epët Anutu pim ngaanëër tektek omnamp Soel piin epël ök maan retëng ëa. ");
INSERT INTO wer_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Anutuuk epël ya. Ënëm pan yangaakë wëwëet won wasuma akunetak nem Pulö wes mëën irëak yang poutë omnarö pangk elniipnaat. Pël ëën arim koont yokoturö pit nem ngön pöt war wesak apnaat. Ën omp ulwas narö pit pöt, nook wangar ke pëlöt rë moolamaat. Ën omp ulöpörö pitta nook wangar rë moolamaat. ");
INSERT INTO wer_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Yaap, akun pötak nem Pulö wes mëën iraan inëën öngre ompörö pitök nem ngön ompyaut war wesak ök apnaat. ");
INSERT INTO wer_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","20","Pël ëën akun pötak elmëën mopöök retëng kësang orööpnaat. Këtëp röök wiipnaat. Ën ngoonöp pöt, i möak omën iitë yaarö ke pöl koröp orööpnaat. Pël ëën yangrakta tapël yaaröön ar yaan sak ëënëët. Es koulöpre es yaapre omën i ököt orööpnaat. Omën pipot wet rëak orööpnaat. Pël ëën Aköp nem akun kaöet orööpnaat. ");
INSERT INTO wer_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Pël ëën omën namp pi neen merëk neaan pöt ne pi kama ömaat.’ ");
INSERT INTO wer_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Soel Anutu pim tektek ngön yaaup puuk ngön lup pöt retëng ëa. Pël ëën ënëmak Pita puuk muntat kaalak yal menak epël ök mëëa. “Israel omnarö, ar këëkë wesak kat wiaan. Ne peene Yesu Nasaret kakaanëp piin ök niamaan. Anutu puuk omën pipop weëre kosang retëng ke nampre nampöt tiarim it köpëlöt pet elniipënëak wes nimëaup. Anutu puuk weëre kosang pöt mangkën wak irëa pöt arim naë oröa. Pël ëaut ar yok ëwat wë. ");
INSERT INTO wer_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ën ngaanëër Anutu puuk Yesu pimëën kön wia pölök arök omën utpet ngaarö pitëm naë wes mëën pitök këra yetaprak möa. ");
INSERT INTO wer_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Pël ëën Anutu puuk weletakaan wal ë moulmëa. Weleta këlangön ke nentere nent kat wia pötë öngpökaan ent ë moulmëa. Pi weletak kosang sak wii naön ëa. ");
INSERT INTO wer_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Iteneë. Omën omp aköp Tewit pi ngaanëër pan wetete ngön nent Yesu pim naë omën orööpna pötaan retëng ëa. ‘Ne itaangkën Aköp pi neering wëaup. Pi nem naë pan wë. Pël ëën ne omën nantön kas naëngan. ");
INSERT INTO wer_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Pötaanök nem lupmer ërëpsawi panë yeë. Pël ëak ërëpsawi tan yamëem nem koröpwerta omën ompyaut orööpnaataan kor wë. ");
INSERT INTO wer_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Oröpmorëënök? Ni ne sëp newasën welaaröa wii kaatak öma saltak wal ë neulëan. Ni nim ya omën ompyaup welaaröa kaöök wieë söp ëëmëak nenëaan ëan. ");
INSERT INTO wer_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ni yok wet rëak wëwë ngolöp ompyaut öma pöta kanö pet elnëaup. Pël ëak akun poutë neering wëën ne ërëpsawi om eim ömaap.’” ");
INSERT INTO wer_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Pita puuk Tewitë retëng ëa pöt ök më pet irak yal menak epël mëëa. “O karurö, ne ngön epët tekeri wesak ök niamaan, omën omp aköp Tewit pim ngönte. Ngaan panëër pi wel wiin yang kel weerauppe. Pël ëaup pim yanget Yerusalem kak eprek e wiaan iteneim wë epët. ");
INSERT INTO wer_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Tewit pi Anutuu tektek ngön yaaö omnamp Anutuuk piin kosang wesak epël ök mëëa. ‘Nim ëaröa naëaan nampök nimtë ök omën omp ak sëpnaat.’ ");
INSERT INTO wer_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Tewit pi Anutu pim omnant ëëpna pötön pi wet rëak ëwat sa. Pël ëak Anutuuk Kristo Yaö Mëëaup welaaröa naëaan wal ëëpnaap pöteta ök mëëa. Pël ëak pi epël ök mëëa. ‘Anutu pi omën pöp sëp mowasën welaaröa wii kaatak wieë söp naëpanëëp.’ ");
INSERT INTO wer_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Omën pöp Yesu Anutuuk welaaröa naëaan wal ë moulmëën ten itenakök pöta ngönte arën ök niaim. ");
INSERT INTO wer_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Pël ëaup pi Anutu pim pepapök yok pim yaapkëëtakël moulmëën weëre kosang kësang wak wë. Pël ëën Pepapök ngaanëër kup mowia pöl Ngëëngk Pulö mena. Pël ëautak omnant arim itaampööre kat wi pël yeë epot Yesu pim Ngëëngk Pul ten ninaö pö. ");
INSERT INTO wer_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Pël ëaap tiar ëwat wëep. Tewit pi pimtëënök ngön epot naën. Pi kutömweri nasënëpök om ngön epot epël ëa. ‘Anutu puuk nem Aköpön epël ya. Ni wais nem yaapkëëtakël öm. ");
INSERT INTO wer_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Pël ëeë neen kor wëën pöt omën nimëën kööre tok yaaö piporö nook maan nim weëre kosangöökë karök ilapnaat.’ ");
INSERT INTO wer_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Pötaanök Israel omnarö ar epël kön wieë. Yesu epop arök këra yetaprak möan pöp Anutu puuk kaö wes moulmëën pi tiarim Kristo pim Yaö Mëëaup pël sak wë.” ");
INSERT INTO wer_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Pita pi pël maan omnarö pit pöt kat wiak pitëm lupöt könöm ëa. Pël ëën narö pit Pitaan pëël mëëa. Ën narö pit ngön yaaö omën muntaröen pëlpël mëak epël mëëa. “Karurö, ten tol ëën?” ");
INSERT INTO wer_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pël maan Pita pi pitën epël ök mëëa. “Ar neenem utpet yaaut kasëng mampun. Pël ëën Anutuuk arim ketöt ent elniin ar Yesu Kristo pim ru ulöpökörö pël sak önë pötaan ten ar i nimëënaan. Ar pël ëak wëën Ngëëngk Pulö nimpnaat. ");
INSERT INTO wer_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Pöt oröpmorëënök? Anutu pim ngön kosang wesa pöt epël wia. ‘Ne omën epot ningkën pöt arimëntre arim koröngre ruuröere ën omën yang ël epotë wëaurö pourö pangk elniipnaat.’ Omën epot Aköp tiarim Anutu puuk omën pourö yas niaan pim naë sëpenaarö tiar nimpnaat.” ");
INSERT INTO wer_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pita pi ngön pöt ök më pet irak kaalak ngön nant kosang wesak epël ök mëëa. “Omën utpet yaauröaring ar pourö kö sënganëën.” ");
INSERT INTO wer_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Pël maan omën kësang pan pit ngön pöt kat wiak kön wi kosang wesa. Pël ëën Yesu pim ngön yaaö omnarö pitök i momëa. Akun pötak omën i momëa kësang pan, 3000 pörö, pit Aköpök wet rëak kön wi kosang yewesa pöröaring erën ë moulmëa. ");
INSERT INTO wer_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Omën pël ëa pörö pit Yesu pim ngön yaaö omnarö pitök omnant rë moulöpna pötaan kent pan ëeima. Pit pël ëak wa top ëak kaömp ngawi neimeë Anutuun yaya maöre kimang maö pël eima. ");
INSERT INTO wer_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Anutu puuk kaamök elmëën pim ngön yaaö omnarö weëre kosang ke nentere nent yaëën omnarö pöten itenak yaan seima. ");
INSERT INTO wer_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Pël ëën omën wet rëak Yesuun kön wi kosang wesa pörö pit lup kopëtemer sak wë pitëm omnant neenemot wieëa pöt sëp wesak ngawingawi ëeim wakaima. ");
INSERT INTO wer_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Pël ëak akun nantë pit pitëm yangre omën nantë sumat wak pöt kaömp sum ëak omën ngöntök yaaurö meneima. ");
INSERT INTO wer_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Pël eimeë akun poutë pit Anutu pim ngönën tuptak wa top ëak pitëm kaatë kaömp ngawi në pël eimeë ërëpsawi yaautaring wakaima. Pël ëak pit lup kopëtemer sak wë kaömp ngawi neimeë, Anutuun yaya maima. ");
INSERT INTO wer_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Pël ëën Yerusalem kak omën wëaurö pit pitëm wëwë pöten itaangkën ompyaö pan ëa. Pël ëën kët poutë Aköpök omën muntarö koirak kön wi kosang yewesa pöröaring yal men moulmëa. ");
INSERT INTO wer_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Kët nentak wiap kan 3 kilok Yuta omnaröa Anutuun kimang yamëëa akun pötak Pitaare Son piarip Anutu pim ngönën tup kaöetakë sa. ");
INSERT INTO wer_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Pël ëak itaangkën ngönën tup kaöetak ka kanër pitök ka kan ompyaur pël yamëëa pöra naë omën namp ing il tëaup wëa ngaanëër ëlëpë yaatakaan pël ëaup wilaup pi pimtok kan sak waisak pël naën yaaup. Pi akun poutë omnaröak wak së moulmë pël yeëa. Pël ëën omnarö Anutu pim ngönën tuptak ilëak yaaröön sumatön kimang maim yeëa. ");
INSERT INTO wer_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Pël ëaö pöpök Pitaare Son piarip Anutu pin ngönën tup kaöetak ilapënëak yaëën sum kot nent mampënëak mëëa. ");
INSERT INTO wer_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pël ëën piarip pörek tauak omën pöpön it kökö ngëneë Pitaak epël mëëa. “Ni tenipön itan.” ");
INSERT INTO wer_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Pël maan pi omnant mampënëak ya wesak piaripön itena. ");
INSERT INTO wer_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pël ëën Pita puuk epël mëëa. “Yaköm, ne kot nim nimpaat won. Pël ëaatak ne omën maim nent wa pötaar ni nimpaan. Yesu Kristo Nasaret kakaanëp pim weëre kosangöök ök niamaan. Wal ëak kan së.” ");
INSERT INTO wer_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Pël mëak Pita puuk mor yaapkëësi moröak kaamök elmëak wal elmëën tapëtakëër pim ingesiar el mö rëën kosat kosang sa. ");
INSERT INTO wer_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Pël ëak ingesiar ompyaö sëën pi sörok olëak tauak kan ing ëa. Pël ëak piaripring Anutu pim ngönën tup kaöetak ilëak kaalak kan ing ëak sörok olëak Anutuun yowe mëëa. ");
INSERT INTO wer_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Pël ëën omën Anutu pim ngönën tup kaöeta kakaati wëaurö pit itena pöt pi kan ing ë Anutuun yaya yamëëa. ");
INSERT INTO wer_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Pël ëën pit itenak epël mëëa. “E, omën epop pi Anutu pim ngönën tup kaöeta ka kan yapinte ompyaur pörek wë sum kimang yaaup,” pël mëëa. Pël mëak pit omën pöpön itenak pim naë oröa pöten yaan sa. ");
INSERT INTO wer_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Omën pöp pi Pitaare Son ent ë moulmëak sëpnaaten kaaö ëa. Pël ëak pi piaripring mor yal ëak Anutu pim ngönën tup kaöetak purpur omnarö pitëm ëapë yapin ngamp Solomon pël yamëëauweri wëën omnarö pit yaan sak së pitëm naë wa top ëa. ");
INSERT INTO wer_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pël ëën Pita pi pitën itenak epël mëëa. “O Israel nem karurö, ar epëten yaan sak ëëngan. Tenip tenpimtë weëre kosang nentak omën epët naën. Arök tenpim ngönën wak wëaö pötaan omën epop ompyaö sa wesak tenipön itaangkan. Won. ");
INSERT INTO wer_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Omën epët Anutu pimtok yaë. Anutu, pöp pi tiarim ëarö Apramre Aisakre Yakop pitëm yaya maima pöp, tiarim Anutu, puuk pim inëënëp, Yesu, pim weëre kosangöt tiarën pet yaalni. Pöp ngaan arök kaöaröa naë wes momëënak pimëën ngön ya mënaup. Pël ëak Rom yang ngarangkëp Pailat pi mangkën puuk kan wes momëëpënëak ëa pöt ");
INSERT INTO wer_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","arök kosang ngentiak omën wotpil ompyaö pöp kasëng menaurö. Mak, ar ke urak Pailatën maan Yesu pim urötak omën yamëngkaup wii kaatakaan kan wes mëën sa. ");
INSERT INTO wer_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Pël ëën arim ngöntaan pitök tiarim omën wëwë ompyaut yaningkaup mëna. Pël ëaupök Anutu puuk weletakaan wal ë moulmëën wëwëetaring wëën tenip itenaut. Pötaanök pöta ngönte ök aim wë. ");
INSERT INTO wer_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Tenip Yesuun kön wi kosang yewasën pim weëre kosangööring omën epop ompyaö yemowas. Yaap, Yesu pi tenip piin kön wi kosang wasënëak kaamök elnia pötak omën epop arim itöök ompyaö sak wë. ");
INSERT INTO wer_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Ngöntre karurö, ne arën ëwat wë. Arre arim kaöaröak Yesuun utpet elmëaurö. Pël ëautak ar pim songönte ëwat nasën wë yak pël elmëaurö. ");
INSERT INTO wer_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Pël ëaap Anutu pim ngaanëër tektek ngön yaaö pöröen ök maan tekeri wesa pöt kë oröa. Pi ngaan epël mëëa. ‘Kristo Anutu pim Yaö Mëëaup pi këlangön kaö pan kat wiipnaap.’ ");
INSERT INTO wer_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Pël mëëa pötaanök ar arim lupöt kaip tiak Anutu pim ë pël elmëën. Pël ëën arim saunat won niwasëpnaan. ");
INSERT INTO wer_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Pël ëak wë ënëmak Anutu puuk ulöpre moup elniak arim lupöt weëre kosang niwasëpnaan. Pël ëak kaalak Yesu Anutu puuk tiarim kama niöpënëak Yaö Mëëaö pöp arim naë wes mëëpnaan. ");
INSERT INTO wer_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Pël ëëpnaatak pi kutömweri om wë Anutu pim ngolöp ngolöp wasëpna akun mowia pöten kor wë. Pël ëëpënëak ngaanëër Anutuuk tektek ngön yaaö omën ngëëngköröen ök maan tekeri wesa. ");
INSERT INTO wer_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Pöt Moses puuk nant epël ëa. ‘Anutu, tiarim Aköp, puuk tektek ngön yaaö namp wes mëën waisëpnaat. Pöp arimtë naëaan namp. Pël ëën Anutu pi neen yaö elnëa ke pëlëp. Ar pim ngön apna pipöt pout ngar ön. ");
INSERT INTO wer_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ën omën Anutu pim tektek ngön yaaö omnampë ngön kat nawiin ëëpna pörö Anutu pim omnaröaring naöpan. Pit kö sëpnaat.’ ");
INSERT INTO wer_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Moses puuk ngön pël retëng ëa. Pël ëën Anutu pim tektek ngön yaaö omën muntarö Samuelre pim kasngaël pöröen ngön ök maan tekeri wesa pöt peene tiarim tekrak yaarö. ");
INSERT INTO wer_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ngön epot Anutu puuk tektek ngön yaaö omnaröen maan pitök pitëm këmötëaan ngaanëër retëng ëën wiakaimautök peene tiarim naë këët yaarö. Tol ëënak wasngan. Ar pitëm kurmentëkaanörö. Pötaanök ngön kosang wia epët Anutu puuk arim ëaröaan ëaö epët ar pouröaan yes. Kat wieë. Anutu puuk Apramön epël ök mëëa. ‘Ne nim ëere köröörö ulöpre moup elmëën yangerak omën pourö pangk ë pet irëpnaat.’ ");
INSERT INTO wer_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Pël ëak Anutu pi pim Inëënëpön yaö mëak wes mëën wet rëak arim ngësë waisa. Pi ulöpre moup elniin arim utpet yaaut sëp wasënëak waisa.” ");
INSERT INTO wer_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pitaare Son piarip omnaröen ngön ök maim wëën kiri ar yaauröere Anutu pim ngönën tup kaöeta polisöröa ngarangkëpre Satusi ngönën omnarö piarpim naë sa. ");
INSERT INTO wer_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Pit së kat wiin piarip Yesu pim wel wiak weletakaan wal ëa pöta ngönte ök mëak tiarta wel wiak tapël wal ëëpenaarö omnaröen pël ök maim wëën pit së kat wiak piarpimëën ya sangën kön wia. ");
INSERT INTO wer_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Pël ëak këtëp irë ilapënëak yaëën yak om moröak ëlpamök ngön ya mëmpënëak wii kaatak moulmëa. ");
INSERT INTO wer_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ën piarpim ngön ök maima omën pöröa naëaan omën kësang pan saareet 5000 pörö Yesuun kön wi kosang wesa. ");
INSERT INTO wer_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ëlpamök ngönënë ngarangköröere kaöaröere ngön kosangötë ngarangk yaaurö pit pourö Yerusalem kak wa top ëa. ");
INSERT INTO wer_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Anas kiri ar yaauröa wotöököp piire Kaiapas, Sonre Alesantaare Anas pim kurmentëkaanörö pit pourö wa top ëak wëa. ");
INSERT INTO wer_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Pël ëak wa top pötak Pitaare Son piarip pitëm tekrak tau moulmëak pëlpël mëëa. “Arip talëpön maan pimtok pimtë weëre kosang ningkënak omnamp ompyaö wesauwaar? Ma talëpë yapinte mëak ompyaö wesauwaar?” ");
INSERT INTO wer_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Pit pëël maan Pita pi Ngëëngk Pulö pim lupmeri peö ëën epël ök mëëa. “Omën kaöere ngarangkörö, ");
INSERT INTO wer_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ar tenpim omnamp ngaanëër ing il tëaup ompyaö mowesan pöten pëlpël yeniak. ");
INSERT INTO wer_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Pötaanök arën ök niaan Israel omnarö ar pourö ëwat seë. Yesu Kristo Nasaret kakaanëp pim weëre kosangöök omën arim tekrak taua epop ompyaö sak wë. Arök Yesu Kristo pöp këra yetaprak möön wel wiaupök Anutuuk weletakaan wal ë moulmëa. ");
INSERT INTO wer_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ngönëntak ngön nent epël wia. ‘Wap omën ka ök yarëauröa wël ë moolëaut Anutuuk ompyaut wesak möör wap wes yewesir.’ Wap pöta yapinte Yesu. ");
INSERT INTO wer_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Pi tapöpök tiar niwak wëwë ompyautak niulëëpnaap. Yang epera rangk omën wë eporö tiarim naëaan nampök tiar niwak wëwë ompyautak niulëëpna pöten yaö neniaan. Yesu pimënt kopët tapöp.” ");
INSERT INTO wer_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Pël maan ngönën ngarangkörö pit yaan panë sa. Pöt Pitaare Son piarip kaö wonaar. Pël ëak piarip ëwat kaatak neilaanaarök wa top kaöetak ngön apnaaten kas köpël weëre kosangring ök mëëa. Pël ëën pit piaripön epël wesa. “Piarip Yesuring wë weëre kosang epël wa,” pël wesa. ");
INSERT INTO wer_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Pël ëak pit itaangkën omën ingesiar ompyaö mowesa pöp piarpim naë yaap tauaan itenak ngön kangiir mapnaat pangk naën ëën sëp wesa. ");
INSERT INTO wer_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Pël ëak omën kaöarö pitëmënt ngönaak apënëak piarip ka ngerö nentakël wes momëa. ");
INSERT INTO wer_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Pël ëakök pitëmënt ngön epël ë kopëta wesa. “Tiar omën epaar tol elmëëpen? Omën Yerusalem kak wëa pörö pit epël kön wia. ‘Omën weëre kosang epët omnarö yok pangk naënganëët. Retëng piarpim yaë epët tiar yak newasngan.’ Ngarangkörö tiar piarpim ëa pöt kaar newasngan. ");
INSERT INTO wer_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Kopëtet om ulöl sak sëpan pötaanök tiar ngön ë kosang wasën piarip kaalak Yesu pim ngönte naën ëëpnaan.” ");
INSERT INTO wer_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Pël mëak pit kaalak piaripön yas maan koirak së tau moulmëak Yesu pim ngönte omën muntaröen ök mapanëak nga mëëa. ");
INSERT INTO wer_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pël maan Pitaare Son piarip taueë Pitaak ngön kangit epël mëëa. “Arimtok omën eptepar kom ëak iteneë. Kan taltakëër ompyaut? Ten arim ënëm ëën ma Anutu pim ënëm ëën? Pël ëautak ten Anutuu ënëm ëëna pöt arim ënëm naëngan. ");
INSERT INTO wer_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Tenip yok pangk pim ngönte anaaten kaaö naëngan. Omnant Yesu pim yaëën tenpim itenak kat wiak pël ëaö pipot tenip yok pangk ngep naëngan.” ");
INSERT INTO wer_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","Omën Anutuuk pim ingesiar ompyaö mowesa pöp pim krismakiat omën naar ulpëën il wesaup pöp pi ulwas wonöp. Pël ëën omnarö pit Anutuuk omën pöp ompyaö mowesa pötaan Anutuun yaya mëëa. Pötaanök ngönënë kansolörö pitök piarip këlangön kat mowiipënëak itaangkën kan won ëën ap wesak piarip kaalak omnaröen ngön ök mepanëak nga mëak wes mëën sa. ");
INSERT INTO wer_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pitaare Son piarip wes mëën kaalak piarpimoröa naë së kiri ar yaaö kaöaröere ngönënë ngarangköröa ngön mëëaö pöt ök mëëa. ");
INSERT INTO wer_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Pël ëën kat wiak pit pourö kön kopëtaö wesak Anutuun epël ök mëëa. “Nuukëër kaöap, ni kutömwer ket ëak pöweri omnant mowian. Pël ëak yanger ket ëak pörak omnant moulmëan. I kaö ket ëak i kaöökë omnant moulmëan. ");
INSERT INTO wer_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ni ngaan panëër Ngëëngk Pulö elmëën tenim ëap omën omp aköp Tewit nim inëën ngaanëpön maan ngön nent epël retëng ëa. ‘Tol ëënak köpëlörö neen ya sangën ëa? Ën tol ëënak omnarö nemëën kup riipënëak ëa? ");
INSERT INTO wer_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Yang omp aköröere wotöökörö ne Aköpre nem Yaö Mëëaup nga elniipënëak wa rongan ëa.’ ");
INSERT INTO wer_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ngön pöta këët peene e yaarö. Pöt oröpmorëën? Yerusalem ka kaö eprek omën omp aköp Erot piire Pontias Pailatre köpël omnarö pit Israel omën kaöaröaring wa top ëak Yesuun nga elmëëpënëak ëa. Pi nim Inëën ompyaup ni ngaan ya yaö mëëaup. ");
INSERT INTO wer_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Pit wa top ëak omnant orööpënëak ngaan nim kopëta wes menan pöpön nga kupre wap wieima. Pël ëeim wëën omnant orööpënëak ëan pöt nimtë weëre kosangöök elmëën oröa. ");
INSERT INTO wer_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Pötaanök ten peene ni tenim Aköpön kimang yeniak. Omnarö pit nga kup yari pötaanök ni ten nim inëënörö kaamök elniaan kas köpël nim ngön ompyaut war wesak ök menaan. ");
INSERT INTO wer_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ni kaamök elniaan yauman omnarö ompyaö mowesak weëre kosang it ngolöp ke nampöt nim inëën ru ngëëngkëp Yesu pim weëre kosangöök mëmpunaan.” ");
INSERT INTO wer_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Pit Anutuun ngön pil ök maö së pet yairën ka pitëm wëa pöt moup ket ëak möa. Pël ëën Ngëëngk Pulö pitëm lupötë ilëak peö ëën pit Anutuu ngönte kas köpël omnaröen ngës rëak ök maö sa. ");
INSERT INTO wer_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Akun pötak omën Yesuun kön wi kosang wesa pörö pit lup kopëtemer sak pitëm naëaan nampök epot nemtëët pöt naën. Won. Pitëm omnant pout ngawi wiak wakaima. ");
INSERT INTO wer_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Pël ëak Yesuu ngön yaaö omnarö weëre kosang kësang wak pitëm Aköp Yesu weletakaan wal ëa pöten omnaröen ök maan Anutuuk omën piin kön wi kosang wesa pörö komre kolap kaö elmëën pit ompyaö wakaima. ");
INSERT INTO wer_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Pël wakaimeë pitëm tekrakaan nampök omën nentaan ngöntök naën. Pit tol ëakök pël eima wasngan. Pitëm naëaan nampök kaare yangatë sumat wak pöt Yesu pim ngön yaaö omnarö pitëm naë wak së mangkën kom ëak ngöntök yaaurö meneima. ");
INSERT INTO wer_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Akun pötak omën namp pim yapinte Yosep pi pitring wakaima. Omën pöpön Yesu pim ngön yaaö omnarö pitök pim yapin nent Panapas pël maima. Yapin pöta songönte Omnarö Lup Ketumön Yemowesaup. Pi Yuta omnamp Liwai pim kurmentëkaanëp Saipras kustak wilaup. ");
INSERT INTO wer_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Omën pöp pim yang lup nent omnarö menak sumat wak ngön yaaö omnaröa naë së kom ë mampënëak mena. ");
INSERT INTO wer_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Panapas pi pël ëa. Ën omën pöröa naë öngre omp naar wëa. Ompöpë yapinte Ananaias. Ën öngöpë yapinte Sapaira. Ananaias puuk pim yang lup nent omnarö menak sumat wa. ");
INSERT INTO wer_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Pël ëak kaö nent yoolök wasëpënëak kaö nent ëlëëp wia. Pël ëën pim öngöp piita ëlëëp wia pöten kön wiin ompyaö ëa. Pël ëën pi sum kaö nent wak së ngön yaaö omnarö menak, e tapët pël mëëa. ");
INSERT INTO wer_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pël ëën Pitaak piin epël ök mëëa. “Ananaias, Seten puuk nim lupmer utpet panë niwasën Ngëëngk Pulöön morök elmëëmëak nim yangeta sumat wak kaö nent ëlëëp wian. ");
INSERT INTO wer_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ni wet rëak yanget sum naën wieëa akun pötak yang pöt nimtëët pël wieëa. Ën ënëmak ni yang pöt omnarö menak sumat ningkën wan pöt nimtëët. Oröpmorëënök ni sum kaö nent ëlëëp wiak ngön kaar ëaup? Nim ngön kaar pipët ten omnaröen pëën nenian, Anutuun kaar yemaan.” ");
INSERT INTO wer_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","6","Pël maan Ananaias pi ngön pöt kat wiak wel wiak së ngentia. Pël ëën yokoturö pit kat wiak së pim sokur poë koröpöök kör koëak wak së yang kel weera. Pël ëën omnarö pit ngön pöt kat wiak kas kaö panë ëa. ");
INSERT INTO wer_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Kot nent wë ngöpngöp ëak 3 aöa pël won yesën pim öngöp Sapaira pim ompöp wel wia pöten kat nawiin yak Pita pim kaata kakaati së ilëa. ");
INSERT INTO wer_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pël ëën Pita pi epël pëlpël mëëa. “Arip yangeta sumet epët pëën wauwaar ma?” Pël maan öngöpök epël mëëa. “Yok nim wan pi tapëtep.” ");
INSERT INTO wer_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pël maan Pita puuk epël mëëa. “Aripök Aköpë Pulöön morök elmëënë pöten kön wiin kengkën sa ma? Kat wiaam. Omën nim ompöp yang kel weeraurö pit ka kanrak pi yawir niinta niöpnaat.” ");
INSERT INTO wer_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Pël maan tapëtakëër öngöpta wel wia. Pël ëën yokoturö pit kaalak wak së pim ompöpë naë moweera. ");
INSERT INTO wer_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Pël ëën Yesuu ingre mor sauröere omën muntarö ngön pöt kat wia pörö pourö kas kësang panë ëa. ");
INSERT INTO wer_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Akun pötak Yesu pim ngön yaaö omnarö pit weëre kosang it ngolöpöt kësang omnaröaan elmëa. Pël ëën omën Yesuun kön wi kosang wesa pörö pit Anutuu ngönën tup kaöetak purpur omnarö pitëm ëapë yapin ngamp Solomon pël yamëëauweri wa top ëak Anutuun ök maim wakaima. ");
INSERT INTO wer_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Pitëmënt pëën pël ëeim wëën omën muntarö pitëm wëwëatön itenak pit ompyaö wëaurö pël yamëëaurö yak pitring öpnaaten kas ëeima. ");
INSERT INTO wer_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Pël ëaatak omën kësang pan Aköpön kön wi kosang wesak pim ingre moröröaring yal mena. ");
INSERT INTO wer_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Pël ëën Yesuu ngön yaaö omnarö pit pitëm yaat om mëmpö yesën omnarö pit pitëm yauman omnarö wak së kamtaöökë kan ëöök urötring wi moulmëa pöt pit epël mëakök ëa. “Pita pi kamtaöök yesem pim moresök moröpnaat. Ën nent pöt pi yesën pöt pim könöpök pitëm rangk ilap riak sëën ompyaö sëpnaat.” Pit pël mëak wak së mowieima. ");
INSERT INTO wer_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Pël ëën Yerusalem kak we naöökaan naöökë ka pötëaan yauman omnaröere omën pitëm lupötë urmerarö wëaurö pourö wak së Yesu pim ngön yaaö omnarö pitëm naë oröön waö ë momëak ompyaö mowesa. ");
INSERT INTO wer_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ënëmak kiri ar yaaurö pitëm wotöököpre omën piiring wëaurö pitëm yapinte Satusi, pit Yesuu pim ngön yaaö omnaröa yaaö pötön itenak war kön wiak ya sangën ëën utpet mowasëpënëak kön wia. ");
INSERT INTO wer_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Pël ëak së ngön yaaö omnarö wak wii kaatak moulmëën utpet yaauröaring wëa. ");
INSERT INTO wer_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Pël ëën rö kan Anutuu ensel nampök wii kaata kanwer të mowiak ngön yaaö omnarö wël ëak mësak orö epël ök mëëa. ");
INSERT INTO wer_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Ar Anutu pim ngönën tup kaöetak së wëwë ngolöpta ngönte omnaröen ök man.” ");
INSERT INTO wer_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Pël maan pit ngön pöt ngar wak wëën këtëp ngampi yoolaan ngönën tup kaöetak ilëak ngës rëak omnarö rë moula. Pit pël ëeim wëën kiri ar yaauröa wotöököpre pim omnarö pit Yuta omën kaöaröen yas maan ngönënë kansolörö wa top ëa. Pël ëak wii kaata kaöapë ngësël ngön wes mëa, Yesu pim ngön yaaö omnarö wii kaatakaan koirak waisëpënëak. ");
INSERT INTO wer_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Pël ëaatak ngönënë polisörö pit wii kaata kakaati së itaangkën Yesu pim ngön yaaö omnarö pit won wieëa. Pël ëën pit kaalak ngönënë ngarangköröa naë së pitën ök mëëa. ");
INSERT INTO wer_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Ten wii kaatak së itaangkën kan ngarangkörö wëën ka kanötta om wari seëa. Pël ëaan ten koirënëak kakaati së itaangkën won wieëa.” ");
INSERT INTO wer_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Pël maan ngönën tup kaöeta polisöröa kaöapre kiri ar yaauröa wotöököp pöt kat wiak kön selap wiak neneren epël mëëa. “Pitëm yaë pipëtakaan oröpöt orööpënëak yaë?” ");
INSERT INTO wer_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Pël aö yeem wëën omën namp pitëm wa topöök së epël ök mëëa. “Kat wieë. Arim omën wii kaatak ulmëan pörö pit ngönën tup kaöeta kakaati së omnaröen ngönën ök maim wë.” ");
INSERT INTO wer_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Pël maan polis ngarangkëpre pim koturö pit së Yesuu ngön yaaö omnarö koirak sa. Pit koirak yewaisem tang nemomöön, omnaröak pit kël momööpanëak kas ëa. ");
INSERT INTO wer_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Pit Yesu pim ngön yaaö omnarö koirak kakaati së ngönënë kansolöröa naë tau moulmëën tauaan kiri ar yaauröa wotöököpök pitën epël pëël mëëa. ");
INSERT INTO wer_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Ten arën Yesuu ngönte anëëtaan nga nenian ëan ma? Ma arök kön wiin pöt omën pasit yaë ma? Yerusalem omnaröen ngön pöt ök maan pitök tenën Yesu möan pël apna pöten ar kent yeë.” ");
INSERT INTO wer_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pël maan Pitaare karurö pit kangiir epël mëëa. “Ten yok pangk ar yang omnaröa ngönte ngar naöngan. Ngön Anutu pim ök niia pöta ënëm ëënaat. ");
INSERT INTO wer_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Arök Yesu këra yetaprak möön wel wia. Pël ëaupök tiarim ëere körööröa Anutu puuk weletakaan wal ë moulmëa. ");
INSERT INTO wer_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Pël ëak Anutuuk koirak së pimtë naë ulmëën pim yaapkëëtakël wë. Pël ëën Anutu puuk kaö wes moulmëën tiarim kepönöök wë kaamök elniak Israelörö tiarim kanöökël pourö wa nuulëën utpetat kasëng mampunëën. Pël ëën Anutuuk arim utpetat wa moolapnaat. ");
INSERT INTO wer_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ngön pöt tenök ök yeniaan Ngëëngk Pulöökta omën pötön war wesak yenia. Anutuuk omën pim ngönte kat yawiaurö ten Pulö yaningk.” ");
INSERT INTO wer_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ngönënë ngarangkörö ngön pöt kat wiak ya sangën ëën Yesuu ngön yaaö omnarö mëmpënëak ëa. ");
INSERT INTO wer_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Pël yaëën Parisi omën kaö namp Moses pim ngön ë kosang wesaut rë yemoulaup pi pitëm tekrak wëa, pim yapinte Kameliel. Pit omën pöpön kön wiin ompyaö yaaup. Puuk ngönënë ngarangköröa tekrakaan wal ëak Yesuu ngön yaaö omnarö ka kaö nerakël wes momëën sa. ");
INSERT INTO wer_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Pël ëën pitën epël ök mëëa. “Israel omën nem karurö, tiar omën eporö omën nant elmëëpenëak pöt kön wialök elmëëpenaan. ");
INSERT INTO wer_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Kat wieë. Ngaan panëër won, peen peen omën namp wakaima yapinte Tiutas. Pimtok pimtën kön wiin, ‘Ne omën kaöap,’ pël wesak omnaröen maan omën kësang 400 ke pël ëak yang ngarangkëpön nga elmëëpënëak sa. Pël ëën narö pitök pi mëngkën pim iri wëaurö pit pim ngön pöt sëp wesak repak sa. ");
INSERT INTO wer_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Pël ëën kaalak Yutas Kalili omnamp puuk omën muntarö wak Rom yang ngarangkëpëën nga elmëa. Pël ëa akun pötak yang ngarangkëp pi ka poutë omnaröa yapinöt wë yesën ngaarö pitök pöpta mëna. Pël ëën pim iri wëauröeta pim ngönte sëp wesak repak sa. ");
INSERT INTO wer_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Pël ëaut pötaanök Yesuu ngön yaaö eporöen tiar mop mowiak itöök elmëaapa. Pitëm ngön epot omën pëënök yeëa pöt won sëpnaat. ");
INSERT INTO wer_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ën omën puot Anutuuk kaamök elmëën pim weëre kosangöök yeëa pöt tiarök yok pangk il nemowasngan. Pötaanök mowëën it mongënaapa. Tiar pël yeem Anutu pimtën nga elmëënganok.” ");
INSERT INTO wer_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Pël maan ngönënë kansolörö pit Kameliel pim wes mëën sëpënëak ëa pöt ngar wa. Pël ëak pit Yesuu ngön yaaö omnarö koirëpënëak maan koirak sëën ngönën ngarangköröak polisöröen maan pës möön epël mëëa. “Ar kaalak Yesu pim ngönte omnaröen ök manganok.” Pël mëak wes mëën sa. ");
INSERT INTO wer_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Pël ëak Yesuu ngön yaaö omnarö pit wa toptakaan oröak yesem ërëpsawi ëa. Pöt Anutuuk pitëm ya mëna pöten itaangkën yok pangk ëën pit Yesuu ngöntaan yok ëö mongawisëpnaat pël wesa. ");
INSERT INTO wer_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Pël ëak kët ël epotë pit ka yaapötëëre Anutuu ngönën tup kaöetak së omnaröen Yesu Anutu pim Yaö Mëëaup ngön ompyaö pöt ök maima. ");
INSERT INTO wer_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Akun pötak Yuta omën narö Yesuu ingre mor saurö selap sak wë tok nentepar pitëm tekrak kom kap oröa. Pöt Krik ngön yaauröak Yuta ngön yaauröen kaaö ngön mëak epël mëëa. “Kët poutë omën omnant ngöntök yaaurö kaömp yemangkem ar Krik ngön yaauröa öng kapirörö ompyaö wesak nemangkën ë yeë.” ");
INSERT INTO wer_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Pël ëën Yesu pim ngön yaaö omnarö 12 pöröak Yesuu ingre mor sauröen yas maan së wa top ëën epël ök mëëa. “Kat wieë. Kaömpre monat kom yaaö ngön pötak tenim ya mëmpuna kanöt il yeniwari pipët pangk naën yaë. Tenim ya kë pöt Anutu pim ngönte omnaröen ök nianëak ëaut. ");
INSERT INTO wer_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Karurö, ar peene arim naëaan omën 7 ëak kom ë moulmëën pitök omnant kom ëëpëna ya pöt ngarangk ëëp. Pit omën Ngëëngk Pulö pitëm lupötë wieëa könringöröak moulmëën. ");
INSERT INTO wer_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Pël ëën tenimtokëër kët ël epotë Anutuun ök maimeë pim ngönte tekeri wesak ök niaim önaan.” ");
INSERT INTO wer_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Pël maan omën pourö ngön pöten kent ëak omën eporö ulmëa. Wet rëak Stiwen omën pöp pi Anutuun kön wi kosang pan yewesaup Ngëëngk Pulö pim lupmeri peö ëaö pöp moulmëa. Pël ëak namp Pilip, namp Prokoras, namp Naikena, namp Taimon, namp Pamenas, namp Nikolas Antiok kakaanëp, pi köpël omnamp ngës rëak Israel omnaröa ngönën wak wëaö pöt yaaup. Pël ëak Yesuun kön wi kosang wesaup. Pit omën piporö moulmëa. ");
INSERT INTO wer_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Pël ëak pit Yesu pim ngön yaaö omnaröa naë moulmëën pitëmëën Anutuun ök mëak pitëm moröt kepönötë mowiak welaköt elmëa. ");
INSERT INTO wer_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Anutu pim ngönte ulöl sëën Yerusalem kak omën wëaurö pitëm naëaan selap pan Yesu pim ru sa. Pël ëën kiri ar yaauröa naëaan selap pitta Yesuun kön wi kosang wesa. ");
INSERT INTO wer_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stiwen pi Anutuuk komre kolap elmëak ngönënë weëre kosang ke nentere nent kaamök elmëën retëng weëre kosang omnaröa yok pangk naënganëët omnaröa tekrak mëneima. ");
INSERT INTO wer_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Pël yaëën omën narö Stiwen pim yaaö pötön kaaö ëeima. Omën pörö pit tok nentak wë Yuta omnaröa ngönën tup nent, yapinte wii natëënöröa ka pötak wa top ëeima. Omën pörö pit Alesentriaare Sairini kakaanörö. Ën narö Silisiaare Esia yangrakaanörö. Pit së wa top ëak Stiwenring ngön nga ela. ");
INSERT INTO wer_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Pël ëaap Pulöök kaamök elmëaan yak pitök pi il nemowasën ëa. ");
INSERT INTO wer_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Pël ëën pit omën naröak Stiwen pimëën ngön mööngk rëak mapëna yak sum elmëën pitök ngön mööngk rëak epël mëëa. “Pi Moses tiarim ëapre Anutuun pim këmtakaan utpet wesak yaan ten kat wiaut.” ");
INSERT INTO wer_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Pël maan omën pörö pit omën yaapöröere ngönënë ngarangköröere ngön kosangötë ngarangkörö pit es nga mowesak Stiwenë naë së moröak wais ngönënë kansolöröa tekrak tau moulmëa. ");
INSERT INTO wer_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Pël ëak omën ngön kaar apnaaröeta piiring tau moulmëën kaar epël mëëa. “Omën epop pi akun poutë Anutuu ngönën tup ngëëngk epëtere Mosesë ngön kosangötön utpet wesak yaaup. ");
INSERT INTO wer_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ten kat wiin pi epël ya. ‘Yesu Nasaret kakaan pipopök ngönën tup epët tööl komun ëak Mosesë ngaantak tiarim ëarö ngön mena pötë urtaköt wiipnaat.’” ");
INSERT INTO wer_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Pël maan ngönën ngarangk kaöarö pourö pit Stiwen pim ë kosaöön it kökö mongnaan ëwa panë tëak enselöröa ë kos koröp oröa. ");
INSERT INTO wer_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Pël ëën kiri ar yaauröa wotöököpök Stiwenën epël pëlpël mëëa. “Ngön e ya epët kaar ma yaap?” ");
INSERT INTO wer_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Pël maan pi kangiir epël ök mëëa. “Nem pepere karurö, ar nem ngön epët kat wieë. Anutu, ëwa pepap, pi ngaanëër tiarim ëap Apram pi Mesopotemia yangerak om wëënaar Anutu pi pim naë oröak epël ök mëëa. ");
INSERT INTO wer_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","‘Ni nim omënere kaare yanger sëp wesak nem yang pet elniima pörek së öm.’ ");
INSERT INTO wer_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Pël maan pi Kaltia yang pör sëp mowesak ka kaö naö Aran pörek së wëën pim pepap wel wia. Pël ëën ënëmak Anutu puuk wes mëën kaalak yang Israel omnarö tiarim wë eprekël waisa. ");
INSERT INTO wer_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Pël ëaap Anutu pi yang lup nent pimtëën panë wesak, ‘Epët nemët,’ pël apna nent wël ë nemangkën ëa. Won pan. Anutu pöp om epël kosang wes ök mëëa. ‘Ënëmak yang epër nimpaat. Pël ëën nim ruure ëarö oröak pep sak öpnaat.’ Pël mëëaö akun pötak Apram pim öngöp ru nawilën ëa. ");
INSERT INTO wer_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Pël ëën Anutuuk kaalak ngön munt nent epël ök mëëa. ‘Nim ruure ëarö yang maim nerek së wëën omën pörek wëauröak ngarangk elmëën ya pas mëneim sum won öpnaat. Pël ëën pörekörö pitök këlangön ya pas mangkën krismaki 400 pil wakaimpënaat. ");
INSERT INTO wer_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Pël ëën ënëmak nook omën pit këlangön kat mowiipna pipörö ngön ya mëmpaat. Pël ëën ënëmak nim ruure ëarö pit yang pör sëp wesak yang eprek wais wë neen yaya neaimpënaat.’ ");
INSERT INTO wer_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Pël mëak Anutuuk Apramre ëaröaan pim ngön kosang wes mëëa pöt pet elmëëpënëak Apramön pim ruure ëaröa koröp kaut ilëpënëak ök mëëa. Pël ëën omnaröak koröp kaut ila pöten itenak Anutu pim Apramön ngön kosang wes mëëa pöten kön wiipnaan. Pël ëën wëak pim öngöp yokot namp wila yapinte Aisak wë akun 7 ëak won sëën 8 pötak koröp kaut ila. Pël ëën Aisak puuk wë pim ruup Yakop wilak tapël elmëa. Pël ëën Yakop puukta wë pim ruurö 12 pörö tapël elmëa. Pël ëën pöröak wë 12 tapël ëak pitëm naëaan Israel omnarö tiarim kur 12 ëak oröa. ");
INSERT INTO wer_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Yakopë ruurö pit omp kaö sak wë Yosepëën këëpöt kön mowia. Pël ëak pi omën narö mës menak sumat öpënëak kön wiak mangkën pit koirak Isëp yangrakë sa. Pi pörek së inëën ru sak wë waur eima, sum won. Pël ëën Anutuuk pi sëp nemowasën, ");
INSERT INTO wer_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","könöm nant pim naë yaaröön Anutu puuk ngarangk elmëeima. Pël ëak Anutuuk pi ël kaamök elmëak kön tektek kaö mangkën Pero Isëp yang omën omp aköp pim naë wëën piin itaangkën ompyaö ëën kaö wes moulmëën puuk Isëp yang ngarangkëpë yaat ngarangk ëa. Pël ëak wë Pero pim kaata yaat pour pi ngarangk ëak wakaima. ");
INSERT INTO wer_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Pël ëën wë ngöntök kësang nempel Isëpre Kanan yangrak oröak wiaan omnarö kaömpëën utpet ë yesën Israel tiarim ëaröeta tapël ëa. ");
INSERT INTO wer_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Pël yeem Yakop pi kat wia pöt Isëp yangrak omnaröak wet rëak akun pötaan kaömpöt wa kön wiaut wia. Pël maan pi ngön pöt kat wiak tiarim ëarö pim ruurö ngës rëak wes mëën Isëp yangrak së kaömp wak waisa. ");
INSERT INTO wer_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Pël ëak wais wë akun nentak kaalak sa. Së oröön Yosepök nanöröen epël ök mëëa. ‘Ne arim nangap Yosep.’ Pël yemaanak Pero piita Yosepë nanöröen ëwat sa. ");
INSERT INTO wer_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Pël ëën Yosepök nanöröen epël ök mëëa. ‘Ar së tiarim pepap Yakopön maan wais eprek Isëp tiarim karuröaring öpenaan.’ Yakopë omën kurmentëkaan pörö 75. ");
INSERT INTO wer_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yakopre pim kuröökaan pörö Isëp yangrak së wë ulöp sak we pöök wel wia. ");
INSERT INTO wer_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Pël ëën ënëmak pit pouröa kosat wak së omën yangaöökë wieëaurek Sekem pörek weera. Yang pör ngaanëër Apram puuk Emo pim omnaröa naëaan sum ëa. ");
INSERT INTO wer_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Israel omnarö pit Isëp yangerak wë ulöl sa. Pël ëën Anutu pim Apramön yang yaö mëëa pörekë sëpënëak Isëp yanger sëp wasëpna akun mena pöt temanöm sa. ");
INSERT INTO wer_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Pël ëa akun pötak Isëp omën omp ak munt namp oröa, pöp Yosepön köpëlëp. ");
INSERT INTO wer_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Omën pöpök Israel tiarim ëere körööröen morök elmëak epël maima. ‘Ar ru wilak pöt wak së pëlëër mowiin. Pël ëën wel wiipnaan.’ ");
INSERT INTO wer_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Pël maan akun pötak Moses pi pim ëlëpök wilak itaangkën pim möönre koröp ompyaö ëën itenak ëlëpök ngarangk ëak kapa yemangkën ngoon naar namp won sa. ");
INSERT INTO wer_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Pël ëën ëlëp pi yang ngarangkëpë ngönte ngar wak Moses wak së pëlëër mowia. Pël ëën yang ngarangkëpë koontupök së koirak pim ru ket ëak ngarangk elmëeima. ");
INSERT INTO wer_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Pël eim wëën Moses pi kaö sak wë Isëp omën kaöaröa naëaan kön tektek wak kaö panë sa. Pël ëak pi ya kësangöt wak ngön weëre kosangringöt pitën ök maima. ");
INSERT INTO wer_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Wë ënëmak krismaki 40 ëak won sëën Israel omën pim karurö kaamök elmëëpënëak kön wia. ");
INSERT INTO wer_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Pël ëak pi yesem itna pöt Isëp omën nampök Israel omën namp möa. Pël ëën pi pim karip kaamök ëak Isëp omnampë utpet elmëa pöta kangiir Isëp omnamp mëna. ");
INSERT INTO wer_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Pël ëa pöten Moses pi epël kön wia. ‘Nem omnarö pit neen epël kön wiipnaat. “Anutuuk pi kaamök elmëën tiar Israel omnarö Isëp yangrakaan nikoirëpënëak yaö mëëaup,” pël kön wiipnaat.’ Pël ëa pöt pit pël kön nawiin ëa. ");
INSERT INTO wer_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","“Ka urak wangam kanök Israel omën naar nga yaalën pi ngeröök yaalmëem epël mëëa. ‘Arpimënt tapaarök yeëerek nga elngan.’ ");
INSERT INTO wer_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Pël maan omën ngöntöp ngep ëak yamöa pöpök Moses mök ë moolëak epël mëëa. ‘Talëpök ni tenim kaö sak wë ngön ë pet irumëak niia? ");
INSERT INTO wer_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ma nim peen kusi Isëp omnamp mënan pöl kaalak neenta nemëmpëak yaan ma?’ ");
INSERT INTO wer_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Pël maan Moses pi ngön pöt kat wiak yang pör sëp wesak Mitian yangerak kas së wakaim wë öng namp wak yokot naar wila. ");
INSERT INTO wer_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Moses pi yang pörek wëën krismaki 40 ëak won sëën akun nentak yang pultak Sinai tomök ikanöök këra kot nementëk es wëlëng yokota. Pël ëën Anutu pi enselëpë ök sak es wëlëngöökë öngpök wëën ");
INSERT INTO wer_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moses pi pöten itenak yaan sak itaampënëak naë yesën Aköpök epël ök mëëa. ");
INSERT INTO wer_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Ne nim ëarö Apramre Aisakre Yakop pitëm Anutu.’ Pël maan Moses pi yaan sak reireë urak kaalak itaampnaaten kas ëa. ");
INSERT INTO wer_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Pël yaëën Aköpök epël ök mëëa. ‘Ne ngëëngkëp yang eprek wë. Pötaan yang nim tauaan pipët welakët yak kan wariaarek nim ing korötepar përë ola. ");
INSERT INTO wer_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ne itaangkën Isëp omnaröak nem omnarö utpet moweseim wë. Pël ëën ne kat wiin pit ya utpetaring wë neen merëk neaim wë. Pötaanök ne pitëm könömöt ent ë moolamëak yewais. Wal ë. Wes nimëën Isëp yangerakë sumëën.’” ");
INSERT INTO wer_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Stiwen puuk kaalak epël ök mëëa. “Moses pi ngaanëër Israel omnarö pitök pim ngönte wa moolëak epël mëëa. ‘Talëpök ni tenim kaö sak wë ngön ë pet irumëak niia?’ pël mëëa. Pöt pit omën pöp Anutuuk Israel omnarö pit ngarangk ëak këëmre këlangönë öngpökaan ent ë moulmëëpënëak yaö maan wëën enselëpök këra kotumentëk es wëlëngöökaan ök mëëa pöten pit köpël pötaanök. ");
INSERT INTO wer_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Pël ëak Moses puuk omën pörö mësak yesem Isëp yangerakaan i kaö Köp Möauukaan yang pultakë pötë yesem retëng ke nampöt mëneim wëën krismaki 40 ëak won sa. ");
INSERT INTO wer_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Pël ëak Moses puuk Israel omën pimoröen epël ök mëëa. ‘Anutu tiarim Aköp puuk tektek ngön yaaö namp wes mëën waisëpnaat. Pöp arimtë naëaan namp. Pël ëën Anutu pi neen yaö elnëa ke pëlëp,’ pël mëëa. ");
INSERT INTO wer_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Moses pi tapöp ngaan yang pultak omnaröaring wa top ëak wakaima. Pi akun pötak tiarim ëaröaring wëën ensel Sinai tomök ngön ök mëëa pöp piarip pouwaar wëa. Pël ëeëak Moses pi Anutu pim naëaan pim ngön lëngë nasëpanë pöt wak tiarimëën mena. ");
INSERT INTO wer_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Pël ëënak tiarim ëarö pit Moses pim ngön pipët wa olëak kaalak Isëp yangerakël sëpënëak ëa. ");
INSERT INTO wer_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Pël ëak pit Moses pim nanëp Eron pim naë së oröak epël mëëa. ‘Moses pi tiar Isëp yangerakaan mësak wais eprek niulëak pi talël sa wes? Ten köpël yaëërek nuuk omën kön nent ket ë nin pötak tenim omp ak sak wotöök rëak mës niwak sëpnaan.’ ");
INSERT INTO wer_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Pël mëak akun pötak purimakaö ru kön namp ket ëak animaö narö möak kön kaar pöpëën kiri ar ë mowiak pitëmtë omën ket ëaö pötaan ërëpsawi elmëeima. ");
INSERT INTO wer_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Pël eim wëën Anutuuk mopöök omnant wia epot këtre ngoonre ari puotön yaya mapënëak pit kasëng momena. Omën pipot Anutu pim tektek ngön yaaö omën nampök epël retëng ëa. ‘Israel omnarö ar yang pultak imeë krismaki 40 ëak sa. Akun pötak animaö kiri ar ëeiman. Pël ëan pöt nemëën won. ");
INSERT INTO wer_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ar wet rëak omnant arimtë ket ëautön yaya maimaurö. Pël ëak ar omp ak kaarëp Molok pim poë koröp ngönën tup kaarkaarte tiak wak pötaring omp ak kaarëp Repan pim ari könte wak sa pël eimaurö. Pötaanök peene nook ar kama niwak wes nimëën maimerek Papilon yangrakë sënëën.’ ");
INSERT INTO wer_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Tiarim ëarö pit yang pultak wakaima akun pötak poë koröp ka nent Anutu pi pitring wë pöta ökre waste tiak wak ima. Ka pöt Anutu pimtok Mosesën ök rapnaal pet elmëën ök rëak wak ima. ");
INSERT INTO wer_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Pël ëën ënëmak tiarim ëaröak poë koröp ka pöt pitëm peparöa naëaan wak Yosuaaring imeë yang munt ner Anutuu omën yang pörek wëaurö waö ë momëa pörek së oröa. Pël ëaut poë koröp ka pöt om wiakaim wiaan yang omën omp aköp Tewit pi oröa. ");
INSERT INTO wer_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Pël ëën Tewit pim wëwëeten Anutu kent elmëa. Pël ëën Tewit pi Anutuun epël kimang mëëa. ‘Ne yok pangk ni, nem ëap Yakop pim Anutu, nimëën ngönën tup ompyaö nent ök ram ma?’ ");
INSERT INTO wer_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Pël mëëautak omën omp aköp Solomon, Tewit pim ruup, puuk ka pöt ök rëa. ");
INSERT INTO wer_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Pël ëaap Anutu O Ngaarëkëp pi ka omën moresök ök yera epotë pëën naöpanëpön tektek ngön yaaö omnampök pël ëa. ");
INSERT INTO wer_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Aköp pi epël ëa. Ne kaöap kutömweri wë omën pout ngarangk ëak wëaup. Ën yang pipër nem weëre kosangöökë iri wia. Pötaanök arök yok pangk ka nent nem wel aisëeë kë sumaan ök nenerangan sa. ");
INSERT INTO wer_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Iteneë. Nemtok nem omën ket ëaö epot pout il wesak wë.’” ");
INSERT INTO wer_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Stiwen puuk kaalak kansolöröen epël ök mëëa. “Arim lupötë wa olëere kön utpet pötök peö ëak wë köpël omën ket ëak Anutuu ngönte kat nawiin yaaurö. Ar kët ël epotë Ngëëngk Pulöökë ngönötta wa olaim wëaurö. Tiarim ëarö pit pim ngönöt wa olaimaurö. Arta tapël yeë. ");
INSERT INTO wer_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Yaap, tiarim ëarö pit Anutu pim tektek ngön yaaö omnarö pitëm naëaan namp öp sa wasngan. Pourö utpet mowesa. Pit omën wotpil waisëpnaapön tektek ngöntak war wesak ëaö pörö pourö mënak won wesaurö. Pël ëauröak peene arökta omën wotpil tapöp ngaaröa naë wes mëën mëna. ");
INSERT INTO wer_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Tiar tapöröak Anutuu naëaan ngön ë kosang wesa pöt öpenëak enselöröak tiarim ëaröen ök mëëautak arta ngön pötë ënëm naën yeë.” ");
INSERT INTO wer_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Stiwen pi pël maan ngönënë kansolörö pit ngön pöt kat wiak ya sangën ëën kë ruru kön wia. ");
INSERT INTO wer_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Pël ëën Ngëëngk Pulö pim lupmeri ilëak peö ëa. Pël ëën pi we riak itena pöt Anutuu naë ëwa kësangpel ëaan Yesu Anutu pim yaapkëëtak tauaan itena. ");
INSERT INTO wer_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Pël ëak Stiwen pi pitën epël ök mëëa. “Kat wieë. Ne peene itaangkën kutömwer kan tëën Omën Këëp pi Anutu pim yaapkëël tauaan ityaangk.” ");
INSERT INTO wer_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Pël yemaan kansolörö pit Stiwen pi Anutuu yapinte ngep yaë wesak kat wiipanëak kat ur wariak ngön kaëpre ngön ëak wal ëak së moröak ");
INSERT INTO wer_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","weruak Yerusalem ka pöökë wilëngkëël koliil së olëak kël momöa. Pël ëak omën pimëën ngön aima pöröak pitëm ulpëënöt përëak omp ulwas nampë yapinte Sool pim naë rongan ë ulmëa. ");
INSERT INTO wer_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Pit pi kël yemomöön Stiwen pi kimang ngöntak Aköpön epël ök mëëa. “O nem Aköp Yesu, ni nem könöp kama neö.” ");
INSERT INTO wer_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Pël mëak rar rë wesirak ngön ëak epël mëëa. “Aköp, ni omën utpet yaalnë eporö kangit mangkan.” Pi ngön pil ök më pet irak wel wia. ");
INSERT INTO wer_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Sool pi Stiwen mëngkën ya kë sa. Pël ëën omën ngönën kat wiaurö pitök pim sokut wak së yang kel weera. Pël ëak pit ingre ya ilak aima. Pël ëa akun pötak Yerusalem kak omën wëa pöröak ngës rëak Yesuu ingre mor saurö mëmpö waö ëak rep momëën Yutia yangrakaan Sameria yangrakë sa. Pël ëën Yesu pim ngön yaaö omnarö pitëmënt Yerusalem kak wakaima. ");
INSERT INTO wer_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Pël ëaan Sool pöpök Yesu pim ingre mor sa pörö utpet mowesak pitëm kaatë kakaati ilëak öngre omp pourö moröak wii tëak wak së wii kaatak ulmëa. ");
INSERT INTO wer_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Yesu pim ingre mor rep momëën saö pörö pit neenem yesautë pim ngönte ulöl wesak ök maö sa. ");
INSERT INTO wer_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Pël ë yesën Pilip pi Sameria kak së omnaröen Kristo Anutuu Yaö Mëëaup pim ngönte ök mëëa. ");
INSERT INTO wer_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Pël yemaan omën kaö pan pim naë wa top ëak retëng omnaröa it köpëlöt ëaö pötön itenak pim ngönöt këëkë pan kat wieima. ");
INSERT INTO wer_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Pël yaëën omën selap urmerarö pitëm lupötë wëa pörö waö ë mëën merëkre ngönëër oröak sa. Pël yaëën omën kosat kël waare kan utpet yaaö pourö ompyaö panë sa. ");
INSERT INTO wer_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Pël ëën omën Sameria kak wëaö pörö Pilip pim ëa pöten itenak ërëpsawi kaö pan ëa. ");
INSERT INTO wer_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Akun pötak kak taprek omën namp wëa pim yapinte Saimon pi kempre pölang pöt ëwat panëëp. Pël ëën Sameria kak pörekë omnarö pit pim yaaö pöten yaan sa. Omën pöp omnaröen pi pitëm kaöap pël maim yeëa. ");
INSERT INTO wer_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Pël ëën kak pörekë omën kotre kaö pourö pit pim ngön mëëaö pöten këëkë pan kat wiak epël maima. “Omën epop pi weëre kosang kaö pan wak Anutuu naëaan irëa.” ");
INSERT INTO wer_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Yaap, pit akun wali pim yaaö pötön itenak yaan sak pim ngön yaaut këëkë kat wieima. ");
INSERT INTO wer_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Pël eim wëënak Pilip pi waisak Anutu pi omnarö wa ngaöök nimëak wë pöpë ngön ompyaö pötre Yesu Kristo Anutu pim Yaö Mëëaup pim ngön ompyaö pöteta ök maan omën narö piin kön wi kosang wasën Pilip pi omën pörö i momëa. ");
INSERT INTO wer_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Pël ëën Saimon piita Yesuun kön wi kosang wasën Pilipök i momëën Pilipring wakaima. Pël ëak pi Pilipë retëng kësang ke nalöt yaaö pötön itenak yaan sa. ");
INSERT INTO wer_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Yesu pim ngön yaaö omnarö pit Yerusalem kak wë Sameria omnarö Anutuu ngönte wak wëa pöt kat wiak Pitaare Son wes mëën itaampö sa. ");
INSERT INTO wer_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","17","Pël ëak pitëm naë së oröak itaangkën pit Aköp Yesu pim ru ulöpöökörö pël sak wëa pötaan i momëën wëa. Pël ëaap itaangkën Ngëëngk Pulö pitëm naë neiraan wieëa. Pël ëën Pitaare Son piaripök Ngëëngk Pulö pitëm lupötë ilapna pötaan kimang mëak piarpim moresiar pitëm kepönötë rangk mowiin Ngëëngk Pulö pitëm lupötë ilëa. ");
INSERT INTO wer_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Pël ëën Saimon pi Yesu pim ngön yaaö omnaarë moresiar omnaröa kepönötë yemowiin Ngëëngk Pulö pitëm lupötë ilëa pöten itenak pi weëre kosang pöt piarpim naëaan sum ëëpënëak kimang mëëa. ");
INSERT INTO wer_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Arpim weëre kosang wa pipët nampun. Pël ëën nookta omnaröa kepönötë nem moresiar mowiin Ngëëngk Pulö pitëm lupötë ilapnaan.” ");
INSERT INTO wer_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pël maan Pita pi epël mëëa. “Ni korar pan yaanëp. Nim sum pötak yok pangk Anutuu naëaan Pulö sum ëëm wesak yaan. Pötaanök nim sumetaring utpet kak sumëët. ");
INSERT INTO wer_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Anutu pi nim lupmeri itaangkën yok pangk naën. Pötaanök ni tenring ya epëtak naön ëëm sa. ");
INSERT INTO wer_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","23","Yaap, ne niin ëwat wë. Nim lupmer warre kaur pömpelök peö ëak wiaan utpetatök par elniak wë. Pötaanök ni pipot kasëng menak Aköpön kimang maan puuk nim utpetatë saunat lupmeri wia pipot won niwasëpnaan.” ");
INSERT INTO wer_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Pël maan Saimon pi piaripön epël mëëa. “Arip nemëën Aköpön kimang maë. Pël ëën omnant nim yenëaan pöt nem naë kaalak naaröön ëëpnaan.” ");
INSERT INTO wer_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pitaare Son piarip ngön weëre kosangringöt pël ök mëak Yesuu naëaan ngön kat wia pöt ök mëak Yerusalem kakë sa. Yesem Sameria yangera öngpök ka wieëa pötë ngön ompyaut ök maö sa. ");
INSERT INTO wer_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ënëmak Aköpë ensel nampök së Pilipön epël ök mëëa. “Wal ëak ëngkël së Yerusalemëlaan kan Kasa kakël sa pipöök sum.” Kan pö yang pultak yesau. ");
INSERT INTO wer_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Pël maan Pilip pi wal ëak sa. Yesem itaangkën omën kaö namp Itiopia yangerakaanëp piita kan tapöök yesa. Omën pöp Itiopia yangerak öng aköp yapinte Kantesi pim kaatere ya omnaröa ngarangkëp, pi Yerusalem kak së Anutuun yaya mëak kakë sëpënëak kar pol osöröak weruak yaaö naöök wel aisëak yesem Aisaia Anutuu tektek ngön yaaup pim pep retëng ëauwer sangk kelö yesa. ");
INSERT INTO wer_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Pël yaëën Anutuu Pulöök Pilipön epël ök mëëa. “Ni kar osöröa weruak yes ëngköökë naë së.” ");
INSERT INTO wer_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Pël maan Pilip teëntom së itaangkën omën pöp Aisaia pim pep ngaan retëng ëa pöwer sangk kelö yesa. Pël ëën pi omën pöpön pëël mëëa. “Ni ngön sangk yaalën pita songönten ëwat wëën ma won?” ");
INSERT INTO wer_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Pël maan pi kangiir epël ök mëëa. “Omën nampök pet naalnëën ëëpna pöt ne tol ëak ëwat sum? Pötaanök ni nem naë wais wel aisëak ök nea.” ");
INSERT INTO wer_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Pël maan Pilip pi karöökë ngaarëk is wel aisëak omën pöpë ngönën pepeweriaan sangk kelö yesa pöten kat wia. Pöt epël. “Omnaröa sëpsëpörö mööpënëak wak yes pöl elmëa. Sëpsëp ruuröa ëpöt ilëpënëak yaëën këlël naën yaë pöl ngön won sak wëa. ");
INSERT INTO wer_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Omnarö pit pi ngep ëak utpet elmëak ngön yaat wotpil wesak namëngkën ëa. Pit pim wëwëet won pan wes moolaan pim yangerakë wëwëet won sa. Omnarö pitök pim ru wilëpnaaröen itnaampan.” ");
INSERT INTO wer_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Omën kaö pöpök Pilipön epël pëlpël mëëa. “Omën epop ngön epot pimtëën ya ma omën nampëën ya?” ");
INSERT INTO wer_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Pël maan Pilipök ngön kangit ök mëëa. Pi ngës rëak Anutu pim ngönën pepeweriaan omën kaöap pim sangk kela pöt war wesak Yesu pim songönte pim ngön ompyaö pöt ök mëëa. ");
INSERT INTO wer_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Pël ëak kamtaöök om yesem omën kaö pöpök i kaö naöön itenak Pilipön epël ök mëëa. “Itan. I kaö nent ëngk wiaap. Ni yok pangk ne i nemëëm ma won?” ");
INSERT INTO wer_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Pël maan Pilip pi epël mëëa. “Nim lupmerök Yesuun kön wi kosang wasën pöt ne yok pangk i nimëëmaat.” Pël maan pi epël mëëa. “Ne Yesu Kristoon pi Anutuu ruup pöt kön wi kosang yewas.” ");
INSERT INTO wer_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Pël mëak pi karaö leng ëëpën maan leng ë ulmëën piarip i kaöötak ngemë Pilipök i momëa. ");
INSERT INTO wer_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Pël ëak piarip i kaöötakaan yaaprën Aköpë Pulöök Pilip kama wak yang maimerekël sa. Pël ëën omën kaöap pi Pilipön itnaangkën ëak pim sëpënëak sa pöl yesem ërëpërëp kaö ë sa. ");
INSERT INTO wer_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ën Pilip pi itaangkën pi Astot kak wëa. Pël ëak Astot il mowesak kan yesem kamtaöök ka wieëa pötë Anutuu ngön ompyaut ök maö yesem Sisaria kak së oröa. ");
INSERT INTO wer_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Sool pi Aköp Yesu pim ingre mor saurö mëmpënëak ngön kosang wia. Pël ëak pi kiri ar yaauröa wotöököpë naë së ");
INSERT INTO wer_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","pep nant Yuta omnaröa ngönën tupötë ngarangk Tamaskas kak wëauröaan retëng ëëpënëak maan pël ëak Sool mena. Pep pötë ngön epël retëng ëa. Sool pi omën öngre omp Yesuu ingre mor saurö koirak wii tëak Yerusalem kakë wak sëpënëak wiak mena. ");
INSERT INTO wer_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Pël ëën Sool pi sa. Seim Tamaskas kak temanöm yewasën kutömweriaan ëwa naö teënt pan irë piik ela. ");
INSERT INTO wer_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Pël ëën pi yangerak së ngentiak kat wiin ngön nent epël mëëa. “Sool, Sool, ni tol ëënak ne utpet neweseimën?” ");
INSERT INTO wer_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Pël maan pi kangiir epël mëëa. “Aköp ni talëp?” Pël maan pi epël ök mëëa. “Ne Yesu. Ni kët ël epotë ne utpet neweseimën. ");
INSERT INTO wer_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Wal ëak Tamaskas kak së orö. Pël ëën omën nampök nim omën ëëmë pöt ök niapnaat.” ");
INSERT INTO wer_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Pël yemaan omën Soolring kan pöök yesaö pörö pit yaan sak ngön wonök taueë pit ngön yamëëa pöt yok kat wieëak omën ngön pöt yaaö pöpön itnaangkën. ");
INSERT INTO wer_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Pël ëën Sool pi yangerakaan wal ëak it ngaulak omnantön itaampënëak ëa pöt pangk naën. Pël ëën omnaröak mor yal ëak Tamaskas kak së moulmëa. ");
INSERT INTO wer_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Pël ëën akun nentepar nent om it ngaap sak wakaima. Pël yeem iire kaömpre omnant nanën. ");
INSERT INTO wer_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Tamaskas kak pörek Yesuu ingre mor saö namp wëa yapinte Ananaias. Pi wangarötë yemangk ke pël ëak itaangkën Aköp pim naë së ëö pet elmëak epël ök mëëa. “Ananaias.” Pël maan pi kangiir epël mëëa. “Aköp, ne e wëep.” ");
INSERT INTO wer_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Pël maan Aköpök piin epël mëëa. “Ni wal ëak kan naö yapinte Wotpil kan pöök së Yutas pim kaatak oröak pitën epël pëlpël mam. ‘Omën namp Tasas kakaanëp yapinte Sool pi wë ma?’ ");
INSERT INTO wer_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Omën pöp pi wangarötë yemangk ke pël ëak itaangkën omën namp pim yapinte Ananaias pöpök së pim moresiar kepönöök mowiin pim itöörar kaalak ompyaö sa pël itena.” ");
INSERT INTO wer_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Pël maan Ananaias pi kangiir epël mëëa. “Aköp, omnaröak omën pipopön aan kat wiaut. Pi nim omnarö Yerusalem kak wëaurö utpet yemowesaup. ");
INSERT INTO wer_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Pël yaaupök kiri ar yaauröa kaöarö pitök maan pi omën niin yaya yeniiaurö wii tëëpënëak Tamaskas kakë waisa.” ");
INSERT INTO wer_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Pël maan Aköpök epël mëëa. “Ni pim ngësë së. Omën puop pi nem ngönte wak köpël omënere yang omp aköröere Israel omnarö arën ök niapënëak yaö mëëaut. ");
INSERT INTO wer_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Pötaanök nemtok pim ënëmak nem ngönte aö yesën këëmre këlangön orö morëëpna pötönta ök memaat.” ");
INSERT INTO wer_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Pël maan Ananaias pi së ka pötak ilëak pim moresiar Sool pim kepönöök mowiak epël mëëa. “Sool, nem karip, Aköp Yesu kamtaöök koirak ngön ök niia pöpök nook nim itöörar nganga sëën Ngëëngk Pulö nim lupmeri ilëak peö ëëpënëak wes nemëën yewais.” ");
INSERT INTO wer_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Pël maötaring omën pim itöörarë pe ëeëa pömpel ilak ungkön it nganga sa. Pël ëak wal ë tauaan Ananaias puuk i momëa. ");
INSERT INTO wer_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Pël ëënak Sool pi kaömp nak weëre kosang wa. ");
INSERT INTO wer_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Sool pi Yesuu ingre mor saurö Tamaskas kak wëaö pöröaring akun nentepar ma nentepar nent wë teëntom Yuta omnaröa ngönën ka wieëautë ilëak Yesuu songönte war wesak omnaröen epël ök mëëa. “Yesu pi Anutu Ruup.” ");
INSERT INTO wer_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Pël maan omnarö pit kat wiak yaan sak epël mëëa. “Elei, omën epop pi Yerusalem kak omën Yesuun yaya yamëëauröaan nga yaaupök kaalak eprek wais tapël ëak wii tëak wak kiri ar yaaö kaöaröa ngësë sëpënëak waisaupök tolël ëak epël ëa?” pël mëëa. ");
INSERT INTO wer_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Pël ëaap Sool pi weëre kosang pan wesak Yesu pi Kristo Anutu pim Yaö Mëëaup pöta ngönte ök maan Yuta omën Tamaskas kak wëaurö pit ngön kangit mapnaat won ëa. ");
INSERT INTO wer_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Wë akun wali yesën Yuta omën ngönënë ngarangkörö pit wa top ëak Sool mëmpënëak ngön ëa. ");
INSERT INTO wer_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Pöt pi kat wiak wëën omnarö pit Tamaskas ka pöök kël ëmöökë ëm kanrak kët kanaan rö kanë Sool mëmpënëak nga wieima. ");
INSERT INTO wer_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Pit pël ëaan röök lupöök omën pim karuröak Sool mësak së kolöm ëp kër naëëpök waulak ëm kë kanöök wii ngan ëak wilëngkëël wes momëën ngemë ngentiak oröak sa. ");
INSERT INTO wer_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Yerusalem kak së Yesuu ruuröaring yal mampënëak ëën pit pim Yesuu ru sak wëa pöten kaar yema wesak pit piin kas elmëa. ");
INSERT INTO wer_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Pël ëën Panapas pi Sool koirak Yesuu ngön yaaö omnaröa naë sa. Pël ëak Panapas puuk Sool pim kamtaöök yesem Aköpön itaangkën ngön ök maan Tamaskas kak së kas köpël omnaröen Yesuu ngönte ök mëëa pöten Yesuu ngön yaaö omnaröen ök mëëa. ");
INSERT INTO wer_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Pël ëën Sool pi pitring wë Yerusalem kak we naöökaan naöök kas naën Yesuu ngönte ök maima. ");
INSERT INTO wer_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Pël eimeë Sool pi Yuta omën Krik ngön yaauröaring ya mëmpööre ngön nga elö pël eim wëën pit kangiir pi mëmpënëak nga kup rieima. ");
INSERT INTO wer_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Pël yaëën pim ingre moröröak kat wiak Sool koirak Sisaria kak së wes mëën Tasas pim kakë sa. ");
INSERT INTO wer_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Akun pötak Yutiaare Kaliliire Sameria yang pötë omën Yesuu ingre mor saurö pitëm naë mayaap oröak wiakaima. Pël ëaan pit Aköpë ikanöök wëën Ngëëngk Pulöök kaamök elmëën weëre kosang wak ulöl sak wakaima. ");
INSERT INTO wer_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pita pi yang poutë Anutuu ingre mor sauröa wëwëatön wa kom ë sak waisak eima. Akun nentak pi Anutuu omnarö Lita kak wëaurö pitëm naë së oröa. ");
INSERT INTO wer_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Pël ëak itaangkën omën namp ingre mor kël waup yapinte Inias pöp wëa. Pi urtak pëën ka urakaimën krismaki 8 ëak won saup. ");
INSERT INTO wer_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pël ëën Pita puuk piin epël ök mëëa. “Inias, Yesu Kristo ompyaö yaniwas. Pötaan wal ëak nim urre korumön ompyaö was.” Pël maan tapëtakëër wal ëa. ");
INSERT INTO wer_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Pël yaëën Litaare Seron ka pöteparë omën pörö pit pöpön itenak lup kaip tiak Aköpë ë pël ëa. ");
INSERT INTO wer_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Kak nerekë yapinte Yopa pörek Yesuu ingre mor sa öng namp wëa yapinte Tapita, Krik ngöntak Tokas pël yamëëa. Öng pöp pi kët poutë omnaröaan ompyaö elmëeimeë pit omnant ngöntök yaëën pöt kaamök elmëeim wëaup. ");
INSERT INTO wer_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Pël ëak akun pötak öng pöp pi yauman nent koirak wel wia. Pël ëën öngörö pit sokur i moirak wak së ka ngerö ngaarëk nentak së mowia. ");
INSERT INTO wer_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Yopa kak pörek Lita kak naë wieëa. Pötaan Yesuu ingre mor saurö pit Pita Lita kak wë pöten kat wiak omën naar wes mëën së epël mëëa. “Ni tiarip koirak teënt sëpa.” ");
INSERT INTO wer_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pël maan Pita pi wal ëak piaripring sa. Pël ëak ka tomök oröön mësak ka kaö ngaarëktakël isa. Pël ëën öng kapiröröak Pita tekrak ulmëak elre waar ë poë koröpre ulpëën Tokas pim öp wë korir mëak pit menautön pet elmëa. ");
INSERT INTO wer_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pël ëën Pita pi öngörö waö ë tomökël momëën yaröön rar rë wesirak Anutuun kimang mëëa. Pël ëak sokura ngësël kaip tiak epël ök mëëa. “Tapita, wal ë.” Pël maan öngöp it ngaulak Pitaan itenak wal ë wel aisëa. ");
INSERT INTO wer_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pël ëën Pita puuk moresi moröak wal ë tau moulmëak öng kapiröröere Anutu pim omën muntaröen ök maan ilaan Tapita mës mena. ");
INSERT INTO wer_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Pël ëën Pita pim ëa pöta ngönte ulöl sak sëën omën munt narö kësang pan Yopa kak wëaurö Aköpön kön wi kosang wesa. ");
INSERT INTO wer_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pël ëa akun pötak Pita pi Yopa kak pörek omën pol koröpöt ket ëëpënëak kopëta yewesa nampë yapinte Saimon pöpring akun wali wakaima. ");
INSERT INTO wer_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Sisaria kak omën namp wëa pim yapinte Konilias pi Rom nga omën 100 pöröa wotöököp. Nga omën pörö pit Itali yangerakaan waisa. ");
INSERT INTO wer_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Omën pöp pi ngönënringëp yak pit öngre ruurö Anutuun yaya maim wëaup. Pël ëeimeë omën pöp Yuta omnarö omnantëën ngöntök yaëën kaamök ëak Anutuun ök yamëëaup. ");
INSERT INTO wer_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Kët nentak wiap kan 3 kilok pötak pi wangarötë yemangk ke pël ëak itaangkën Anutuu ensel nampök së piin epël mëëa. “Konilias.” ");
INSERT INTO wer_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Pël maan pi enselëpön itenak kas ëak pëlpël mëëa. “E Aköp tol ë?” Pël maan enselëpök epël mëëa. “Anutu pi nim kimang ngönöt kat wiak nim omën ngöntök yaaurö kaamök yaalmëan pöten itaangkën ompyaö ëën puuk kangut nimpnaat. ");
INSERT INTO wer_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Pötaanök ni peene omën narö wes mëën Yopa kak së omën namp yapinte Saimon, yapin nent Pita, pöp koirak waisëp. ");
INSERT INTO wer_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Omën pöp pi Saimon yapin ngampup pol koröpöt ket ëëpënëak kopëta yewesaup pim kaatak wë. Ka pöt i kaö ëöökël wia pipët.” ");
INSERT INTO wer_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Pël mëak sëën Konilias pi pim inëën ru naarre nga omën ngönënring namp piiring wëaup pöröen ngön maan sëën, ");
INSERT INTO wer_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Konilias pi pitën enselëpë ngön ök mëëa pöt pout ök mëak wes mëën Yopaë sa. ");
INSERT INTO wer_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Omën pörö së ka urak ëlpamök kan kourak yesem së Yopa kak temanöm oröak itna pöt këtëp luptak wëën Pita pi Anutuun ngön mapënëak ka kaö kë yesaur ngaarëkël wieëa pörekël isa. ");
INSERT INTO wer_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Pël ëak pi këën pan ëën kaömp nëmpënëak yeëa. Pël ëën pit kaömp kopëta yewasën Pita pi kor wë wangarötë yemangk ke pël ëak itaangkën, ");
INSERT INTO wer_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","kutömwer kan tëën omën nempel poë koröp kaöatë ök nempel irëa. Kaut kong nent ulöp urak wes mëën yangerak irëa. ");
INSERT INTO wer_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Pömpelë öngpök animaö ke nampre namp intre imën, kamal pörö wëa. ");
INSERT INTO wer_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Pël ëën Pita pi ngön nent epël kat wia. “Pita, ni wal ë narö möak ar ëak në.” ");
INSERT INTO wer_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pël maan Pita pi epël mëëa. “Aköp, ne yok pangk pël naëngan. Omën epot Yuta omnarö tenim naë nga pan wia. Pël ëën ne ngaanta nanën yaaup.” ");
INSERT INTO wer_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Pël maan ngön tapët kaalak rangk mëëa. “Anutu pim kaömp numëak nimpëna pipotön nuuk nga wia pël angan.” ");
INSERT INTO wer_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Omën pöt akun nentepar nent oröak teënt kaalak kutömweri isa. ");
INSERT INTO wer_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Isën Pita pi wel aisëak pim wangarëta ök itena pöta songönten kön wieim wëën Koniliasë naëaan sa pörö pit Saimon pim kaaten pëël maan omnaröak pet elmëën ka pöta ëmöökë ëm kanrak së taueë, ");
INSERT INTO wer_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","epël pëlpël mëëa. “Omën namp yapinte Saimon, yapin nent Pita, pöp eprek wë ma?” ");
INSERT INTO wer_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pël maan Pita pi omën pim naë oröa pöten kön ya mëneim wëën Ngëëngk Pulöök epël mëëa. “Kat wi. Omën naar namp ëak ni nikoirëpënëak waisaurö e wë. ");
INSERT INTO wer_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Pötaanök wal ëak orö pit koirak pitring së. Nemtok wes mëën yewaisrek kön selap ëëngan.” ");
INSERT INTO wer_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pël maan Pita pi oröak ngemë pitën epël mëëa. “Arim ap weseiman pöp ne epop. Ar tol ëënak yewais?” ");
INSERT INTO wer_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Pël maan pit kangiir epël mëëa. “Rom nga omnaröa wotöököp yapinte Konilias puuk ten nim ngësë wes nimëën yewais. Omën pöp pi ompyaö panëëp Anutuun yaya maim wëaup. Pël ëën Yuta omnarö pit pim wëwëeten itaangkën ompyaö yaaup yak Anutuu ensel nampök ni koirak pim naë sëën nim këmtakaan ngön kat wiipënëak mëëa.” ");
INSERT INTO wer_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Pël maan Pita pi omën pörö koirak së piiring ka ura. Ëlpamök Pitaare omën Yopa kakaan Yesuu ingre mor saurö pit kopëta wesak pitring sa. ");
INSERT INTO wer_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Pël ëak pit yesem kan kourak së ka nent ura. Wangam kan yesem Sisaria kak së oröa. Pël ëën Konilias pi pim nanang karuröen ök mëak wa top ëak Pitaan kangk eim wëa. ");
INSERT INTO wer_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pël ëën Pita pi së oröak kakaati ilapënëak yaëën Konilias pi koirak ngëëngk mowesak rar rë mowesira. ");
INSERT INTO wer_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pël ëën Pitaak Koniliasën epël ök mëëa. “Wal ë. Ne ngëëngkëp won, omën nim karip.” ");
INSERT INTO wer_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Pël mëak piarip ngönngön aö kakaati ilë itaangkën omën kësang pan wa top ëak wëën Pita puuk pitën epël mëëa. ");
INSERT INTO wer_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","“Ar ten Yuta omnaröa songönten ëwat wë. Ten omën muntaröaring omnant ngawi ëënganëak kan waria. Pël ëautak Anutuuk ne arim naë waisumaaten ngel könöm ëënganëak wangarëtak ök neak pet yaalnë. ");
INSERT INTO wer_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Pötaanök ne arim ngönte kat wiak wa nanuulaan ngar wak yewais. Pötaanök ne pëlpël niamaan. Oröp ëënak neen ngön neeaurö?” ");
INSERT INTO wer_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Pël maan Konilias pi kangiir epël ök mëëa. “Ne omën it ngolöp nenten itenak wëën kët akun nentepar nent yes. Pël ëënak niin yas niiaut. Pöt epël. Ne wiap kanök 3 kilok pötak Anutuun kimang maim wëën akun tapëtakëër omën poë koröp kölam panëö wetaö namp nem naë oröak epël ök neeaut. ");
INSERT INTO wer_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","‘Konilias, Anutu pi nim kimang ngönöt kat wiak nim omën ngöntök yaaurö kaamök yaalmëan pöten itaangkën ompyaö ëën puuk ni kangut nimpnaat. ");
INSERT INTO wer_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Pötaanök ni peene omën narö wes mëën Yopa kak së omën namp, yapinte Saimon yapin nent Pita, pöp koirak waisëp. Omën pöp pi Saimon yapin ngampup pol koröpöt ket ëëpënëak kopëta yewesaup pim kaatak wë. Ka pöt i kaö ëöökël wia pipët.’ ");
INSERT INTO wer_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Pël neaan ne nim ngësë teëntom ngön wes nimëaut. Pël ëën ni ompyaö ëak tenim naë wais oröön ya kë yes. Pötaanök ten Anutuu ëöetak wais wa top ëak wë. Aköp pi ngön tol nent ök niamëak niia?” ");
INSERT INTO wer_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pël maan Pita pi ngës rëak epël ök mëëa. “Yaap pan. Anutu pi omnarö mööngkraar kangk naalmëën yaaup. ");
INSERT INTO wer_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Pi yok pangk omën ke nampre namp, ngön nerre ner pimëën yaya maö ompyaö elmëeim wëaö piporöaan kent yaaup. ");
INSERT INTO wer_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Anutu pim Israel omnarö tenën ngön ök niiaö pöten ar ëwat wë. Pi Yesu Kristo pim ngön ompyaut war wesak ök niia. Pi omën pouröa Aköp pël sak wëën tiar Anutuuk yal mangkën lup kopëtemer sak öpenaat. ");
INSERT INTO wer_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ar Son pim omnarö i momëën omën ompyaut oröa pöten ëwat wë. Pöt Kalili yangerak oröak Yuta yang poutë ulöl sak sa. ");
INSERT INTO wer_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ar yok ëwat wë. Anutu pi Yesu Kristo Nasaret kakaanëp yaö mëak pim Ngëëngk Pulö elmëën weëre kosang kaamök elmëën pi yang poutë ya ompyaö mëmpö yesem Setenë omën utpet mowesaö pörö ompyaö moweseima. ");
INSERT INTO wer_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Pël ëën ten pim ngön yaaö omnarö pim Yerusalemre Yuta yang poutë ëa pöt pout iteneim wëën pit pi këra yetaprak momöön wel wia. ");
INSERT INTO wer_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Pël ëën yangaöök wieë kët nentepar nent won sëën Anutuuk wal ë moulmëën omën naröen ëö pet elmëa. ");
INSERT INTO wer_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Pël ëaup pi Yuta omën pouröa ëöetak naröön. Ten Anutu pim ngönte anëak yaö niiaurö tenimtokëër piin itenaut. Pi weletakaan wal ëën ten piiring iire kaömp ngawi naut. ");
INSERT INTO wer_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Pël yeem tenën pim ngön ompyaut omnaröen ök maö yesem Anutuuk omën öpre wel pourö pim naë ngön ë pet irëpnaat pöta ngönte omnaröen ök menëak niiaut. ");
INSERT INTO wer_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Anutu pim tektek ngön yaaö omnaröak epël ëa. ‘Omën namp pi Yesuun kön wi kosang wasëpna pöp pim utpetat Anutuuk Yesuu weëre kosangöök ent ë moolapnaat.’” ");
INSERT INTO wer_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pita pi ngön pöt ök maim wëën Ngëëngk Pulö omën pim ngön kat wieim wëaö pöröa naë irëa. ");
INSERT INTO wer_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Pël ëën omën pörek wëa pörö pit omën muntaröa kakë ngönötë aö Anutuun yaya maima. Pël ëën Yuta omën Yesuu ingre mor saurö Yopa kakaan Pitaaring sa pörö pit Anutuuk Ngëëngk Pulö köpël omnarö ulöl wes mena pöten itenak yaan sa. Pël ëën Pitaak epël ök mëëa. ");
INSERT INTO wer_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Ngëëngk Pulö ngaan tiarim naë irëa pöl peene pitëm naë yeira. Pötaanök tol ëën tiar i nemomëën ëëpen?” ");
INSERT INTO wer_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Pël mëak Pitaak pit Yesu pim ru ulöpöökörö pël sak wëa pötaan i momëëpënëak maan pël ëa. Pël ëak pit Pita pitring wëwë yeem moulmëak sëpënëak mëëa. ");
INSERT INTO wer_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Yesuu ngön yaaö omnaröere ingre mor sa Yutia yangerak wëauröak köpël omën narö pitta Anutuu ngönte wa kosang wesa pël aan kat wiak wëën, Pita pi Yerusalem kakë sa. ");
INSERT INTO wer_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Pël ëën akun pötak Yesuun kön wi kosang wesa narö ngön ë kosang wesautak Anutuun yaö ëak koröp kaut ila pöröak piin epël mëëa. ");
INSERT INTO wer_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Ni tol ëënak Anutuun yaö ëak koröp kaut nailënöröa naë së pitring kaömpre omnant ngawi yaën?” ");
INSERT INTO wer_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Pël maan Pita pi omnant pim naë oröa pötön ök mëëa. ");
INSERT INTO wer_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Ne Yopa kak wë Anutuun ök yemaan wangarötë yemangk ke pël ëak itaangkën omën nempel poë koröp kaöatë ök nempel irëa. Kaut kong nent ulöp urak wes mëën kutömweriaan irë nem naë ngentia. ");
INSERT INTO wer_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Pël ëën ne öngpök itaangkën animaö ke nampre namp kosangöökaan kakë, kamalre int pourö omën pömpelë öngpök wëa. ");
INSERT INTO wer_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Pël ëën ngön nent epël yaan kat yawi. ‘Pita, ni wal ë narö möak në.’ ");
INSERT INTO wer_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Pël neaan ne epël yemak. ‘Aköp, ne pël naëngan. Omën epot Yuta omnarö tenim naë nga pan wia. Pël ëën ne ngaanta nanënëp.’ ");
INSERT INTO wer_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Pël maan ngön tapët kaalak rangk kutömweriaan epël yenëa. ‘Anutu pim kaömp numëak nimpëna pipotön nuuk nga wia pël angan.’ ");
INSERT INTO wer_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Omën pöt akun nentepar nent oröak kaalak sasa kutömweri isa. ");
INSERT INTO wer_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Pël ëën akun tapëtak omën naar namp ëak ka nem wëauta ka kauni wais taueëa. Omën pörö pit Sisaria kakaan omën nampök ne koirak sënëak wes mëën waisa. ");
INSERT INTO wer_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Pël ëën Pulöök neen epël ök yenëa. ‘Ni omën eporöaring sum. Köpëlöröak ya wesak kön selap ëënganok.’ Pël neaan ne omën tiarim kar ingre mor sa 6 ëak neering e taua eporöaring së Konilias pim kaatak oröak kakaati ilëaut. ");
INSERT INTO wer_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Pël ëën ensel namp pim kaata kakaati tauaan itaangkën ngön ök mëëa pöt tenën ök yenia. Enselëpök Koniliasën epël ök mëëa. ‘Ni peene omën narö wes mëën Yopa kak së Saimon, yapin nent Pita, pöp koirak waisëp. ");
INSERT INTO wer_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Pël ëën omën pöpök wais Anutuuk kama niön niire nim kaatakörö ompyaö sënë pöta ngönte ök niapnaat.’ ");
INSERT INTO wer_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Konilias pi enselëpë ngön ök mëëa pöt ök yenia. Pël ëënak ne ngës rëak ök yemaan Ngëëngk Pulö ngaan tiarim naë irëa pöl pitëm naë yeira. ");
INSERT INTO wer_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Pël ëën ne Aköp pim ngaan ngön ëa pöten kön yawi. ‘Son pi i yaaptak omnarö i momëa. Ën ënëmak nem Pepapök Ngëëngk Pulöök i ket ëak ar nimëëpnaat.’ ");
INSERT INTO wer_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Pël ëaut yak Anutuuk akun tiarim Aköp Yesu Kristo piin kön wi kosang wesa pötak tiarim naë kësangën porpor elniaut ök tapël peene pit kësangën yaalmëën nook tol ëën Anutuun kan mowariim?” ");
INSERT INTO wer_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Pita pi pël maan pit ngön pöt kat wiak pitëm nga ëa pöt sëp wesak Anutuun yaya mëak epël mëëa. “Anutuuk pit wetete mowasën köpël omnaröeta pitëm utpetat kasëng menak wëwë ngolöpta kanöök yes.” ");
INSERT INTO wer_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Stiwen wel wiin ngönënë ngaaröak Yesu pim ruurö këëmre këlangön ke nentere nent wa menak rep momëën narö Pinisia yangerakël yesën, narö Saipras kustakël yesën, narö Antiok kakël yesën, pël ëa. Pël ëak pit pötë së wë Yuta omnaröen pëën ngönën ök maima. ");
INSERT INTO wer_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ën omën narö Saipras kustakaanre Sairini yangerakëlaan Antiok kakël sa pöröak kopëlöröenta Aköp Yesu pim ngön ompyaut ök maima. ");
INSERT INTO wer_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Pël ëën Aköpök omën pim ngön ompyaut ök maima pöröak weëre kosang mangkën omën kësang pan piin kön wi kosang wesak pim naë rë olëa. ");
INSERT INTO wer_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Pël ëën Yesuu ingre mor Yerusalem kak wëaurö pit ngön pöt kat wiak Panapas Antiok kakë wes mëën sa. ");
INSERT INTO wer_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Së oröak Anutu pim omnarö ompyaö elmëa pöten itenak ërëpsawi ëak Aköpë naë rë olëak öpënëak kosang wesak ök maima. ");
INSERT INTO wer_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Panapas pi omën ompyaup, kön wi kosang yewesautere Ngëëngk Pulö pim lupmeri peö ëeëaup. Pötaanök omën kësang pan Aköpë ingre mor sa. ");
INSERT INTO wer_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Pël ëën Panapas pi Sool koirëpënëak Tasas kakë sa. ");
INSERT INTO wer_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Pël ëak koirak kaalak Antiok kakë sa. Pël ëak piarip pörek Yesuu ingre mor sauröaring wë krismaki kopët nenta öngpök omën kësang pan rë mouleima. Pël ëën Antiok kak omën wëa pöröak ngës rëak Yesuu ingre mor saö pöröen yapinte Kristoëërö pël maima. ");
INSERT INTO wer_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Akun pötak Anutuu tektek ngön yaaö narö Yerusalem kakaan Antiok kakë sa. ");
INSERT INTO wer_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Pël ëaö pöröa tekrakaan omën namp Akapas pi Pulöök elmëën ënëmak yang poutë ngöntök kësangpel orööpna pöta ngönte pitëm tekrak wal ë tauak tekeri wesak ök mëëa. Pël ëën ënëmak Klotias Rom omën omp aköp pim wëa akunetak ngöntök pömpel oröa. ");
INSERT INTO wer_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Pël ëën Yesuu ingre mor saurö pit neenem sumatëaan kaut ingre mor sa pitëm karurö Yutia yangerak wëa pörö kaamök elmëëpënëak ngön kopëta wesa. ");
INSERT INTO wer_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Pël ëak sum pöt Panapasre Sool mangkën wak Yerusalem kak së Yesuu ingre mor sauröa wotöökörö mena. ");
INSERT INTO wer_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Akun pötak yang omp aköp Erot pi Yesuu ingre mor sa narö utpet mowasëpënëak ngës rëa. ");
INSERT INTO wer_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Pël ëak maan Sems Son pim nanëp öp wesirën wel wia. ");
INSERT INTO wer_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Pël ëën pi Yuta omnaröen itaangkën pit pöten kent ëa. Pël ëën kaalak maan Pita wali wak wii tëa. Pël ëa akun pötak kaömp peret yis namëënöt yena akun ngëëngkët wia. ");
INSERT INTO wer_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Pël ëa akun tapëtak pit Pita moröak wii kaatak moulmëën wëën nga omën 16 pöröak akun nentak kong nent pöröak ngarangk yeem kaalak akun nentak kong nent pöröak së ngarangk yeem pël eima. Anutuu mait elmëa akunet pet irënak Erot pi omnaröa itöök ngön yaatak moulmëëpënëak ëa. ");
INSERT INTO wer_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Pël ëën pit Pita wii kaatak moulmëak ngarangk pan ëaap Yesuu ingre mor saurö pitök Anutuun kaamök elmëëpënëak kosang wesak kimang maima. ");
INSERT INTO wer_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Erot pi ëlpamök Pita ngön yaatak moulmëëpnaat yak nga omën naar, namp mor nasring wii motëa, namp nasring motëa. Pël ëën rö kan Pita piarpim tekrak ka uraan nga muntarö ka kanrak ngarangk wëa. ");
INSERT INTO wer_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Pël ëaan tapëtakëër Aköpë ensel namp oröön wii kaata kakaati ëwa kësang ëa. Pël ëën enselëpök kuröpweri moröak yaan mowesak epël ök mëëa. “Ni teënt wal ë.” Pël yemaan pim moresiarë wii tëa pöngesiar wilak yangaak ngentia. ");
INSERT INTO wer_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Pël ëën enselëpök epël ök mëëa. “Nim poë koröpö taë wes urak ing körötepar wa më.” Pël maan Pita pi pël yaëën enselëpök kaalak ök mëëa. “Nim ulpëënëp wa mëak nem ënëm wais.” ");
INSERT INTO wer_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pël maan Pita pim ënëm oröak wë enselëpë elmëa pöten yaap yeë pël newasën, wangar yemangk pël wesa. ");
INSERT INTO wer_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Pël ëak ngarangk rongan nent il wesak së kaalak rongan munt nent il wesak së ka kan aini kosangpelök warieëa pömpel pimënt om tëak yesën itnal oröak sa. Ka kan pömpel Yerusalem kakël ko wesak wieëa. Pël ëak piarip kamtaöök yesem enselëp pi tapëtakëër irikor ëak kö sa. ");
INSERT INTO wer_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Pël ëën Pita kön tektek sak epël ëa. “Ne peenök kön tektek sak kön yawi. Aköp pi pim ensel namp wes mëën wais ne Erot pim moresiaanre Yuta omnarö pitëm omnant elnëëpënëak ëaö pötëëlaan ent ë yeneulë.” ");
INSERT INTO wer_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Pi kön tektek sa pet irak Maria, Son yapin nent Maak, pim ëlëpë kaatakë sa. Ka pötak omën kësang pan wa top ëak Anutuun kimang maim wëa. ");
INSERT INTO wer_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pël ëën Pita pi ka pöta kanrak së körang körang yaalmëën inëën koont namp yapinte Rota pi kanwer motëëpënëak wal ëak orö, ");
INSERT INTO wer_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","kat wia pöt Pitaë ngön köngkömö ëa. Pël ëën pi ërëpërëp pan ëak teëntom kakaati ilë wëauröen, “Pita e ka kanrak taua,” pël mëëa. ");
INSERT INTO wer_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Pël maan pit epël mëëa. “Ni kaökaö yaan ma?” Pël maan pi ke urak, “Yaap, e wë,” pël maan pit epël mëëa. “Pipop pim enselëpön yaan.” ");
INSERT INTO wer_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Pit pël aim wëën Pita pöp om ka kanwer körang körang maim tauaan orö kanwer të mowiak itena pöt Pita ëën yaan kaö sa. ");
INSERT INTO wer_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pël ëën Pita pi pit ngön ngaarëk wesak apanëak moresring angan elmëak Aköpë wii kaatakaan mësak së wes momëa pöten ök mëëa. Pël mëak epël mëëa. “Ar Semsre pim karuröen ök man.” Pël mëak Pita pi oröak we naöökël sa. ");
INSERT INTO wer_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ëlpam walën ngaarö pit yaan kaö sak Pita talël sa pël mëak ap wesa. ");
INSERT INTO wer_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Pël ëën Erot pi omën narö wes mëën Pitaan ap wes pet ira. Pël ëën pi nga omën wii kaatak ngarangk wëaurö koirak omën pöten pëël maan ök nemaan ëa. Pël ëën Erot pi pit mëmpënëak mëëa. Pël ëak Yutia yangerakaan Sisaria kakël së wakaima. ");
INSERT INTO wer_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Erot pi Taiaare Saiton omnaröaan nga elmëeim wëën pit pöta ngönte piiring apënëak wa top ë së wet rëak Erot pim kaata ngarangkëp Plastas pim naë oröa. Pël ëak piin ngöntre kar elmëak Erot pim kööre tok wieëa pöt won wasëpënëak ök mëëa. Pöt tol ëënak? Pit omën omp aköp Erot pim yangerakaan kaömp sum yeëa pötaanök. ");
INSERT INTO wer_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Pël ëak Erot pi omnarö akun mena. Pël ëak wë akun pöt temanöm sëën pi ë rangiak pim omp ak urtak wel aisëeë ngön kësang pan ök mëëa. ");
INSERT INTO wer_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Pël yemaan omnarö pit ëlak wiak epël mëëa. “Omën epop omën ngön won, Anutuu apna pöl ya.” ");
INSERT INTO wer_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Pël yemaan Erot pi ngön pöt kat wiak pimtëën kön wiin isën Anutuu yapinte wa ngep ëa. Pötaanök tapëtakëër Anutuu ensel nampök elmëën pim yaatak iwalörö ka ëak mën ilën wel wia. ");
INSERT INTO wer_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Anutuu ngönte kaö sak ka poutë sa. ");
INSERT INTO wer_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Pël ëa pötak Panapasre Sool piarpim yaat pet irak Son, yapin nent Maak, pöp koirak pit pourö Yerusalemaan Antiok kakë sa. ");
INSERT INTO wer_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antiok kak Yesuu ingre mor sauröa tekrak tektek ngön yaaöre rë yemoula narö wakaima. Pitëm yapinöt epot. Panapasre Simion yapin nent Koröp Koup, piire Lusias Sairini yangrakaanëp, Maneyen Erot yang omp aköp piiring piarip piarip yaaupre Soolre piporö wakaima. ");
INSERT INTO wer_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Pël ëak ingre mor saurö pit akun nentak Anutuun yaya mapënëak kaömp ngës olëak wëën Ngëëngk Pulöök epël ök mëëa. “Ar Panapasre Sool piarip nem ya mëmpënëak mëëaö pöt menak wes momëeë.” ");
INSERT INTO wer_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Pël maan pit kaömp ngës olëak om wë Anutuun kimang mëak pitëm moröt piarpim rangk mowiak welaköt elmëak wes mëën sa. ");
INSERT INTO wer_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ngëëngk Pulöök wes momëën piarip Son, yapin nent Maak, pöp ya kaamök elmëëpënëak koirak piaripring yesem Selusia kak së oröak i kaö wangaöök ilëak së Saipras kustak oröa. ");
INSERT INTO wer_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Pël ëak wangaöökaan ngentiak pit Salamis kak Yuta omnaröa ngönën tupötë Anutuu ngön ompyaut ök maima. ");
INSERT INTO wer_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Pël ëak pit kus pötak ya mëmpö wirö wa pak ëak yesem Pepos kak së oröak itaangkën Yuta omën namp kak pörek pölangre këap ke nentere nent yaaup wëa yapinte Payesu. Omën pöpök omnaröen, “Ne Anutuu tektek ngön yaaup,” pël kaar maima. ");
INSERT INTO wer_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Omën pöp pi kus pötakë Rom yang ngarangkëp Sesias yapin nent Polas piiring ngönt rëak wëa. Yang ngarangk pöp pi ëwat panëëp. Pötaanök Panapasre Sool piarpim këmtakaan Anutuu ngönte kat wiipënëak yas mëëautak ");
INSERT INTO wer_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","pölangre këap omën pöp Krik ngöntak Elimas pël yamëëaup pöpök yang ngarangkëp pi Yesuu ngön ompyaut kat wiipanëak piaripön nga mëëa. ");
INSERT INTO wer_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Pël ëën Sool yapin nent Pool pim lupmeri Ngëëngk Pulö peö ëak wëën Elimas pöpön nga iteneë epël mëëa. ");
INSERT INTO wer_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Setenë ruup, ni omnant ompyautëën kööre tok yaaup. Ni kaarötëën wot kaö sak wë saun koireim wëaup. Ni Anutu pim ngön yaapöt wak kaip tiktik ëak nimtë könöökaan kaaröt yaaup. ");
INSERT INTO wer_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Pötaanök peene Anutu pim weëre kosangta songönte nim naë oröön ni itöörar ngaap sak akun nantë ëwaaten itnaangkën ëëmëët.” Pël yemaan tapëtakëër kepil koutë ök nempel itöörarë kaka elmëën pi talëpök mor yal ëak kan pet elmëëpënëak eim wakaima. ");
INSERT INTO wer_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Pël ëën omën pöten itenak yang ngarangkëp pi Yesuun kön wi kosang wesa. Pël ëën piarip Aköpë ngönte ök yemaan kat wiak yaan sa. ");
INSERT INTO wer_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Poolre karurö pit Pepos kakaan wangaöök ilëak Peka kak Pampilia yangerakël së wangaöökaan ngentiak Son Maak sëp wesak kaalak Yerusalem kakë sa. ");
INSERT INTO wer_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Pël ëën pitëmënt Peka kak sëp wesak Antiok munterek Pisitia yangerak së oröa. Pël ëak pit kë yesa akunetak Yuta omnaröa ngönën tuptak ilëak wel aisëa. ");
INSERT INTO wer_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Pël ëën omnarö Moses pim ngön kosangötre tektek ngön yaauröa ngönöt ngönën pepeweri wia pöt nent sangk kelën kat wia. Pël ëak ngönën tup ngarangköröak Poolre Panapas piarpim ngësël ngön epël wes mëa. “Karaar, arip ngön ompyaö ten lup taë niwesak ök nianë nent wiaan pöt peene ök niaan kat wiinaan.” ");
INSERT INTO wer_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pël maan Pool pi wal ëak moresring angan elmëak ngës rëak epël ök mëëa. “Ar Israel omnaröere köpël omën ngönën kat wiaurö, ar kat wieë. ");
INSERT INTO wer_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Ngaan panëër ten Israelöröa Anutu puuk tenim ëere körööröen yaö elmëën pit akun wali Isëp yangerak yaam wëën Anutuuk kaamök elmëën ulöl panë sa. Pël ëaan Anutu pim weëre kosangöök elmëën pit yang pör sëp wesa. ");
INSERT INTO wer_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Pël ëën Anutu pi pitëm yang pultak eima pötaan könömët wak wëën krismaki 40 ëak won sa. ");
INSERT INTO wer_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Pël ëën ënëmak yang 7 pötë omën Kanan yangerak wëaurö Anutuuk won wes moolëak pitëm yanger Israel omnarö mangkën pit krismaki 450 pël wakaima. ");
INSERT INTO wer_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Wë ënëmak Israel ngarangk narö moulmëën wë wë ë yesem Samuel tektek omën pöp oröa. ");
INSERT INTO wer_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Akun pötak pitëm naë omën omp ak namp orööpënëak maan Anutuuk Pensaminë kurtakaan Kis pim ruup, Sool pöp tekeri wes mangkën pöpök Israel omnarö ngarangk ëak wëën krismaki 40 ëak won sa. ");
INSERT INTO wer_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Pël ëën Anutu puuk Sool wa moolëak Tewit urtak moulmëa. Pël ëak Anutu pi Tewit pimëën epël mëëa. ‘Ne Sesi pim ruup Tewit pim wëwëeten itaangkën ompyaö ëën kent yaalmë. Pötaanök nem ya ngön mema pöt mëmpnaat,’ pël mëëa. ");
INSERT INTO wer_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Pël ëautak Anutuuk Tewit pim ëere körööröa naëlaan Israel omnarö tenim ompyaö niwasëpna namp orööpënëak yaö ëa pötak Anutuuk maan Yesu oröa. ");
INSERT INTO wer_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Yesu naaröön wiaan Sonök Israel omnarö pitëm utpetat kasëng mangkën i momëëpënëak mëëa. ");
INSERT INTO wer_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Pël ëak Son pi pim ya pet irëpna akunet temanöm yesën omnaröen epël ök mëëa. ‘Ar neen tol weseim? Ne Anutuu kama niöpënëak Yaö Mëëaö pöp wasngan. Ar kat wieë. Omën namp nem ënëm yewais pöp pi omën kësangëp. Ne utpet epopök yok pangk pim ing körötepar wii nemowilngan. Omën pöp arim kor wakaima pöp.’ ");
INSERT INTO wer_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Karurö, Apramë ëaröere köpël omën ngönën kat wiaurö, ar kat wieë. Anutuuk tiar utpetatë naëaan niöpëna pöl pet elnia ngön pöt tiarim naë yaarö. ");
INSERT INTO wer_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Omën Yerusalem kak wëauröere pitëm wotöökörö pit omën pöpë songönten këëkë kön nawiin ëa. Pël ëak pit tektek omnaröa ngönöt pitëm kë yesaö akunatë ngönën pepeweri sangk kelak pötë songönötta kön nawiin wel wiipëna ngön yaatak moulmëa. Pöt tektek omnaröak ngön pël ëëpnaat ëa pöt kë oröa. ");
INSERT INTO wer_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Pit Yesu pim saun nent nokoirënrek om pas Rom yang ngarangkëp Pailatök këk maan möön wel wiipënëak ke urak mëëa. ");
INSERT INTO wer_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Pit tektek ngön yaaö omnaröa pimëën ngön ëa pöt pout elmë pet irak këra yetaprakaan ent ëak së yangaöök weera. ");
INSERT INTO wer_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Pël ëën Anutuuk weletakaan wal ë moulmëa. ");
INSERT INTO wer_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Omën wet rëak piiring Kalili yangerakaan Yerusalemë sa pörö pit kët selap piin iteneima. Pël ëa omën pöröak pöta ngönte Yuta omnaröen ök maim wë. ");
INSERT INTO wer_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Pël ëënak tenök Aköpë ngön ompyaut arën epël ök niaim. Omën pipëten Anutuuk tiarim ëaröën ök mëëaut peene pitëm ruure ëarö tiarën ök yenia. Pi Yesu wal ë moulmëa pötak tan pep Sam pöweri tan 2 pöta lupët epël ya. ‘Ni nem Ruup. Peene kët eptak ne nim Pepap pöt pet yaalmë.’ ");
INSERT INTO wer_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Anutuuk pi weletakaan wal ë moulmëaup. Pötaanök kaalak wel wiak söp naëpan. Anutuuk pim ngönte pil ök mëëa. ‘Nem Tewiten kup mowia pöt ne wëwë ompyaö pöt nimpaat.’ ");
INSERT INTO wer_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Pël ëën tan munt nent Tewit puuk Anutuun epël mëëa. ‘Ni nim ya omën ompyaup welaaröa kaöök wieë söp ëëpënëak nenëaan ëan.’ ");
INSERT INTO wer_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Pël retëng ëak omën omp aköp Tewit pi Anutuuk ya ngön mëëa pöt omën pimoröa öngpök mëneim olëak wel wia. Pël ëën pit pim ëere körööröa naë yang kel weerën pim koröpö yangaöök wieë söp ëa. ");
INSERT INTO wer_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ën Tewit pim mëëa pöp yangaöök wieë söp naën Anutuuk wal ë moulmëaup. ");
INSERT INTO wer_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Pötaanök ar këëkë ëwat seë. Ten arën epël ök niaim. Omën pöpök arim utpetat wa niolëaut. ");
INSERT INTO wer_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Moses pim ngön kosang pötak arim utpetat ent ë niolëak ar omën wotpil pël naniwasën. Omën pöpök omën pouröa utpetat ent ë niulaan piin kön wi kosang mowasën puuk, ‘Nem omën wotpilörö,’ pël niaim wë. ");
INSERT INTO wer_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Pötaanök ar këëkë ngarangk yeemak ön, tektek ngön ëa pöt arim naë orööpanëën. Pit epël ëa. ");
INSERT INTO wer_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Kat wieë, ar Anutuun ökre was yaaurö. Ar itenak yaan sak wel wiinëën. Ne omnant arim tekrak ëëmaatep ar yok pangk kön wi kosang newasngan. Ën omën nampök pöten ök niaan yok pangk yaap ya pël newasngan.’” ");
INSERT INTO wer_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pool pi ngönën ök mëak piar Panapas kakaatiaan orööpënëak yaëën omnarö pit epël mëëa. “Kaalak kë yesa akun muntetak ngön pipot ök nian.” ");
INSERT INTO wer_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Pël mëak ngönën tuptakaan tomökël oröa. Pël ëën Yuta omën naröere kopël ngön kat wia narö pit Poolre Panapas piarpim ënëm sa. Pël ëën piarip ngönën ök mëak pitëm lupöt es nga mowasën pit weëre kosang Anutuu ulöpre moup pötak öpënëak mëëa. ");
INSERT INTO wer_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Kë yesa akun muntetak ka pöökë omën pourö Anutuu ngönte kat wiipënëak wa top ëa. ");
INSERT INTO wer_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Omën kësang pan së wa top ëën Yuta omën narö pit itenak piarpimëën ya sangën ëa. Pël ëak Pool pim ngönten wak irëak koröp kolak mëëa. ");
INSERT INTO wer_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Pël ëën Poolre Panapas piarip kas köpël ngön epël mëëa. “Yaap, tenip Anutu pim ngönte wet rëak ök niiaut. Pël ëautak ar kasëng menak Anutuuk wëwë ompyaut nimpëna pöt pangk naën pël pet yaë. Pötaanök tenip ar sëp niwesak köpël omnaröa ngësë sënaat. ");
INSERT INTO wer_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Aköpök ngönën pepeweri epël retëng ëak ten nina pöt yaapët pötaanök. ‘Nook ar köpël omnaröa es ëwaö pël wes yanuulë. Pötaanök ar ëwa ngön pöt yang poutë ök më pet irën pöt Anutuuk pit kama moöpnaat.’” ");
INSERT INTO wer_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Pël maan köpël omnarö pit ngön pöt kat wiak ya kë sak Anutuu ngönten ompyaö pan pël mëëa. Pël ëën Anutuu wëwë kosangtaan yaö elmëa pörö piin kön wi kosang wesa. ");
INSERT INTO wer_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Pël ëën Anutuu ngönte yang pörek ulöl sak sa. ");
INSERT INTO wer_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Pël ëën Yuta omën narö pit öng kaöarö ngönën wak wëauröere kak pörekë kaöarö es nga mowasën Poolre Panapas utpet panë mowesak waö elmëën pitëm yang pör sëp mowesak sa. ");
INSERT INTO wer_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Pël ëën piarip pitëm utpetat wieëa pötë ökre was ëak piarpim ingesiarëaan yangre ulölöt kërë ngep elmëak Aikoniam kakë sa. ");
INSERT INTO wer_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Pël ëën Yesuu ru Antiok kak wëaurö pit ërëpsawiaring wëën Ngëëngk Pulö pitëm lupötë peö ëak wiakaima. ");
INSERT INTO wer_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Poolre Panapas piarpim Antiok kak ëa pöl kaalak Aikoniam kak pörek ëa. Piarip Yuta omnaröa ngönën tuptak ilëak ngönën ök maan pit piarpim ngön pöten kat wiin ompyaö panë ëën omën kësang pan Yuta omën naröere köpël omën narö pit Yesuun kön wi kosang wesa. ");
INSERT INTO wer_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Pël ëën Yuta omën piarpim ngön wa yoolëaurö pit köpëlöröen këk maan Yesuu ingre mor sauröen kaaöre këëpöt elmëa. ");
INSERT INTO wer_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pël ëën piarip Aikoniam kak akun wali wë Aköpë ngönte ök mapnaaten kas naën Yesuuk weëre kosang kaamök elmëaan retëng ke nentere nent weëre kosang panëët mëna. Piarpim ya ke pël mëna pötak Aköpë lup sant pömpel kësang pan pitëm naë wia pöta ngönte yaapët pet elmëa. ");
INSERT INTO wer_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Pël ëa akun pötak ka pöökë omnarö pit kom ëa. Narö Yuta omnarö pitëm ënëm ëa. Ën narö pit Yesuu ngön yaauwaar piarpim ënëm ëa. ");
INSERT INTO wer_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Pël ëën Yuta omnaröere köpëlörö pit pitëm kaöaröaring wa top ëak Poolre Panapas utpet mowasëpënëak ngön ëak kël mööpënëak mëëa. ");
INSERT INTO wer_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Pël ëën piarip kat wiak kas së Likionia yangerak Listraare Tepi ka kaö pöörarë sa. Pël ëak pöörarë naë ka kot wieëa pötë wa pakpak ëeim wakaima. ");
INSERT INTO wer_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Pël ëeimeë Yesuu ngön ompyaut ka pötë ök maim wakaima. ");
INSERT INTO wer_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Listra kak pörek omp namp ingesiar utpet ëaup wëa. Omën pöp pi ëlëpë yaatakaan pël ëak oröaup yak kan naënëp. ");
INSERT INTO wer_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Pi wel aisëeë Pool ngön ök yaan kat wieëa. Pël ëën Pool pi omën pöpön itaangkën pi Yesuuk ompyaö mowasëpnaat pöt kön kosang wieëa. Pël ëën Pool pi it kökö ngëneë kosang wesak epël mëëa. ");
INSERT INTO wer_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","“Ni wal ëak nim ingesiar mëngkre mëngk mësëak tau.” Pël maan omën pöp pi teëntom wal ëak yok kan ing yaap ëa. ");
INSERT INTO wer_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Pël ëën Likionia yang pörek wëaurö pit Pool pim ëaö pöten itenak pitëm ngönrak ngön ëak epël aö sa. “Ëlarörö pit omën möönre koröp wak tiarim tekrak oröak wë.” ");
INSERT INTO wer_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Pël mëak pit Panapas pöpön pitëm ëlar nampë yapinte Sus pöpë ngamp mëëa. Pël ëak Pool pöp pi ngön kaö yaaup pël mëak pitëm ëlar nampë yapinte Emis pöpë ngamp mëëa. ");
INSERT INTO wer_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Pël ëën pitëm ëlar Sus pöpë tupët ka pöökë wilëngkëël wieëa. Tup pöta ngarangkëpök pol purimakaö omp narö wak këra puut wii mëak öngö moutak ka kaö pöökë ëm kanrak wak së omnaröaring wa top ëak pol pörö möak piarpimëën kiri ar ëëpënëak ëa. ");
INSERT INTO wer_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Pël ëën Poolre Panapas piarip pöt kat wiak pitëm elmëëpënëak ëa pöten kaaö yaë pël pet elmëak ulpëënaar wa keliak pitëm toköök së ngön ëak epël mëëa. ");
INSERT INTO wer_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Ar pël ëëngan. Tenip omën arim karaar. Tenip arën ngön ompyaut omën utpet pipot sëp wasënëak ök niaim. Pël ëën ar lup kaip tiak Anutu wëwë pepap pim naë önëak niaim. Pi kutömre yangre i kaö epot ket ëak pötë omën wia epot ket ëaup. ");
INSERT INTO wer_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Yaap, omnarö pit ngaan pitëmtë könöök omnant yaëën pi it mongnaan ë seima. ");
INSERT INTO wer_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Pël ëaatak pi akun poutë ompyaö elmëeim wiak pi yaap wë pöt pet elmëeima. Pi mopöök kopiimor elmëën kaömp këët orööpna akunet yemangk. Pël ëën pöt nak kep ëak wë ërëpsawi eim wë.” ");
INSERT INTO wer_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Pël mëak piarpimëën kiri ar ëëpënëak ëa pötaan ke panë urak maan sëp wesa. ");
INSERT INTO wer_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Yuta omën narö Antiokre Aikoniam ka pöörarëaan së omnaröen këk maan pit Pool kël möak wel wia wesak weruak kaöökë wilëngkëël koliil së moolëak kaalak kakë sa. ");
INSERT INTO wer_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Pël ëën Yesuu ingre mor saurö pit së pi tekrak ulmëak wëën wal ëak kaalak kakë sa. Pël ëak ëlpamök Panapas koirak Tepi kakë sa. ");
INSERT INTO wer_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Pël ëak piarip ngön ompyaut ök maim wëën ka pöökë öngpök omën kësang pan pit kat wiak Yesuu ënëm ëa. Pël ëën piarip kaalak Listraare Aikoniam kak së wë kaalak Antiok Pisitia yangerak wieëa ka pötakël sa. ");
INSERT INTO wer_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Yesem Yesuu ingre mor sauröen ngön kosang wesak epël ök maö sa. “Tiar Anutuuk wa ngaöök nimëëpënëak kent yeë pöt wet rëak e wë eprek këëmre këlangönë rangk öpenaat. Pötaanök ar kön wi kosang yewesautak kosang sak ön.” ");
INSERT INTO wer_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Piarip ök maö yesem ka poutë ingre mor saurö pitëm wotöökörö moulmëak piarip kaömp ngës olëak Aköpön kimang ngöntak mëak pitëm kön wi kosang yewesaup pim naë wa moulmë sa. ");
INSERT INTO wer_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ënëmak piarip kaalak Pisitia yangerak së oröak yesem Pampilia yangerak së oröa. ");
INSERT INTO wer_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Pël ëak Peka kak ngönën ök mëak Atelia kak së oröak, ");
INSERT INTO wer_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","wangaö wak kaalak yesem Antiok kak së oröa. Kak pörekök ingre mor sauröak Anutuu lup sant pöta öngpök wa moulmëak wes mëën sa. Piarip ya ngön mëëa pöl mëmpö së pet irak kaalak së piarpim ya ngön wak saö pörek së oröa. ");
INSERT INTO wer_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Pël ëak ingre mor saurö wa top elmëak Anutuuk kaamök elmëaan piarpim ya mëmpö ima pötë ngönötre ën köpël omnarö Anutuuk kan të mowiin piin kön wi kosang wesa pöta ngönöt ök mëëa. ");
INSERT INTO wer_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Pël ëak piarip akun wali pan Yesuu ruuröaring pörek wakaima. ");
INSERT INTO wer_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Yesuu omën narö Yutia yangerakaan së Antiok kak oröak ingre mor sauröen epël ök maima. “Ar Moses pim ngön ë kosang wesa pöt ngar wak arim koröp kaut nailën ëënë pöt Anutuuk yok pangk kaalak naniöpan.” ");
INSERT INTO wer_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pël maan Poolre Panapas ngön pöten kaaö ëak piarip pitëmëën ngön kosang kaö pan ëak piaripring ngönngön apanëak nga mëëa. Pël ëën ingre mor saurö pit Poolre Panapas piarip omën naröaring Yerusalem kak së Yesuu ngön yaauröere wotöökörö pitring ngön pöt wotpil wasëpnaan sëpënëak mëëa. ");
INSERT INTO wer_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Pël ëak ingre mor saurö pit wes momëën yesem Pinisiaare Sameria yang pötë ingre mor sa pöröen köpël omnarö Yesu pim ënëm sa pöten ök maan pit ërëpërëp pan ëa. ");
INSERT INTO wer_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Pël ëën pit Yerusalem kak së oröön Yesuu ngön yaaö omnaröere wotöököröere Yesuu ingre mor saö muntarö pit itenak yoöre ërëp kaö mëëa. Pël ëën piarip Anutuuk kaamök elmëaan piarpim ya mëmpö ima pötë ngönöt ök mëëa. ");
INSERT INTO wer_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Pël ëën Yesuun kön wi kosang wesa narö Parisi pöröak wal ëak epël mëëa. “Ar pitëm koröp kaut ilak Anutuun yaö mowesak Moses pim ngön ë kosang wesauta wia pöl ëëpnaan ök maë.” ");
INSERT INTO wer_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Pël maan Yesuu ngön yaauröere wotöökörö pit ngön pöt ëak söë wasëpënëak wa top ëa. ");
INSERT INTO wer_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Pël ëak pit ngön selap aim olëak Pita pi pitëm tekrak wal ë tauak epël ök mëëa. “Nem karurö, ar ëwat wë. Ngaanëër Anutuuk tiar ya kom ë ninak neen köpël omnaröen ök maan pit kat wiak kön wi kosang wasëpënëak neeaut. ");
INSERT INTO wer_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Anutu tiarim lupötön ityeengkaupök tiarimëën elnia pöl Ngëëngk Pulö köpël omnarö mena. Pim elmëa pötak pitëmëën ya kë sa pöt pet yaalni. ");
INSERT INTO wer_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Pi tiarën nal elniak pitën nal naalmëëpan. Won. Pit piin kön wi kosang mowesa. Pötaanök pitëm lupöt kölam mowesa. ");
INSERT INTO wer_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Pël yaalniin oröp ëënak ar Anutuun ököök elmëënëak yeë? Tiarim ëaröa eima pöl tiarta Moses pim ngön ë kosang wesa pöta ënëm naën yaaurö. Ngön ë kosang wesa pöt tiarim kasngelötë omën könöm nant weta pöl wetak imaut. Pötaanök könöm tapöt kaalak Yesuu ingre mor saurö er mowatngan. ");
INSERT INTO wer_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Tiar epël kön wi kosang wesaut. Aköp Yesu pim lup sant pötak Anutu tiar niwaupök omën pöröeta yemoö.” ");
INSERT INTO wer_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Pita pi pël maan wa topöök wëaö pörö ngön naën wëën Panapasre Pool piarip piarpim ya mëmpö yesën Anutuuk kaamök elmëën köpëlöröa itöök ya retëng nant mëmpö ima pötë ngönte ök maan kat wia. ");
INSERT INTO wer_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Pël ëak Sems pi epël mëëa. “Karurö, ar nem ngönte kat wieë. ");
INSERT INTO wer_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Anutu puuk wet rëak köpël omnarö pimtëën wesak mokoira pöta ngönte Saimon yapin nent Pita puuk ök niaan kat yawi. ");
INSERT INTO wer_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Anutuu këmtakaan tektek ngön yaaurö pitëm ëa pötëët ök yenia. Pöt epël ëa. ");
INSERT INTO wer_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Aköp pi epël ya. “Ne ënëmak kaalak waisak omën omp ak Tewit pim ka töölak wia pipët köpre mor ëak ka pöta omnant köt sa pipot ngolöp ngolöp wesak wa wesir ulmëëmaat. ");
INSERT INTO wer_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Pötaanök omën muntarö pit ne pitëm Aköp neen ngaöl elnëëpnaat. Köpël omën tapörö nemëën wesak yaö wesaurö.” ");
INSERT INTO wer_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Aköp ngaanëër pan ngön pöt tekeri wes wiaupök peeneeta tapël ya.’ ");
INSERT INTO wer_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Pël yaatak ne kön epël yawi. Köpël omën narö lup kaip tiak Anutuu ngësël ko yawi piporö tiarök kaalak könömër nemangkan. ");
INSERT INTO wer_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Köpëlörö pit omp ak kaarkaaröröaan animaö kiri ar ëak wak në imeë, öngre omp nga ë, animaurö iit orööpanëak nailën om ar ëaut në, ën animauröa iit në, pël eim wë pöt sëp wasëpnaan pep retëng ë mempen. ");
INSERT INTO wer_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Köpëlörö pit Yuta omnarö ya utpet mowesak omën pipot ëëpan. Yuta omnarö pit omën pipot Moses pim pepeweri retëng ëa pötön ngaantakëër iteneë kë yesa akun poutë ngönën tupötë së ilëak sangk kelak kat wieim wë. Pötaanök tiar kan kosang mowariipenaan.” ");
INSERT INTO wer_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Pël mëak Yesuu ngön yaaö omnaröere wotöököröere ingre mor saö muntarö pit ngön kopëta wesak omën naar Poolre Panapasring Antiok kakë sëpënëak yaö mëëa. Pël ëën Yutas yapin nent Pasapasre Sailas piarip sa. Omën pöaar ingre mor saö pöröa wotöökaar. ");
INSERT INTO wer_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Piarip sëpënëak yaëën pep newer epël retëng ëak piarip mena. “Ten Yesuu ngön yaaöre wotöök arim karurö, tenök arimëën pep epwer retëng ë yaningk. Ar köpëlöröa öngpökaan ingre mor sak Antiok kakre Siria yangerakaan Silisia yangrakë wëaurö arën yowe yeniak. ");
INSERT INTO wer_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Tenim naëaan omën narö wais arën ngön ke nampnampöt ök niak arim könöt wa irikor elnia pöt yaan kat yawi. Piporö tenök arim ngësë wes namëën. ");
INSERT INTO wer_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Pötaanök ten wa top ëak lup kopëtemer sak omën epaar wes mëën arim ngësë yewais. Piarip Panapasre Pool tiarim kar ompyauwaar piaripring wes momëën yewais. ");
INSERT INTO wer_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Panapasre Pool piarip tiarim Aköp Yesu Kristo pim yaatak wë kö sëpnaaten kön selap naën yaauwaar. ");
INSERT INTO wer_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Yutasre Sailas pöaar arim ngësë wes mëën yewais. Pël ëak tenim ngön pepeweri retëng ëan pöt piarpim këmtakaanta ök niapnaat. ");
INSERT INTO wer_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ten Ngëëngk Pulööring kön kopëtaö wesak wë. Pötaanök Yuta omnaröa yaë pöl könöm muntat naningkan. Ar omën epotökëër eim ön. ");
INSERT INTO wer_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Omp ak kaarkaaröröaan kiri ar ëaut nënganok. Ar Animauröa iit nënganok. Animaurö iit orööpanëak nailën om ar ëaut nënganok. Öngre omp nga ëënganok. Ar ngarangk këëkë ëak omën pipot keker elmëeim önë pöt ompyaö önëët. Yowe pan. Ompyaö ön.” ");
INSERT INTO wer_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Pit pepewer pël ëak mangkën wak Antiok kak së oröön Yesuu ingre mor saurö wa top ëën pep pöwer mena. ");
INSERT INTO wer_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Pël ëën pep pöweri ngön wieëa pöt sangk kelak pit ngön ompyaö pöt kat wiak ërëpërëp kaö ëa. ");
INSERT INTO wer_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Pël ëën Yutasre Sailas piarip Anutu pim tektek ngön yaaö omnaar pël sak wë akun wali pan ingre mor sauröen ngönën ök maim wë taë mowesa. ");
INSERT INTO wer_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Piarip Antiok kak pörek akun wali wakaim wiak sëpënëak yaëën ingre mor sauröak kan yaö mëak wes momëën saö pöröa ngësël sa. ");
INSERT INTO wer_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Pël ëautak Sailas pi pimtë kentöök Antiok kak om wakaima. ");
INSERT INTO wer_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pël ëën Poolre Panapas Antiok kak om wë ingre mor saö naröaring omën muntarö rë mouleim Aköpë ngönënte ök maim wakaima. ");
INSERT INTO wer_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Wakaim wiak ënëmak Pool puuk Panapasën epël ök mëëa. “Tepër kaalak ka poutë yesem ingre mor sauröen itaampö sëpa. Tepër ngaan pitën ngön ompyaut ök mëëaut. Pötaan pit ompyaö wë ma utpet wë pöten itaampëaan.” ");
INSERT INTO wer_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Pël maan Panapas pi Son, yapin nent Maak, pöp koirak piaripring sëpënëak maan, ");
INSERT INTO wer_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Poolök epël mëëa. “Omën pipop ngaan Pampilia yangerak së ök ë nimëaup. Pötaan tepërring nasëpan.” ");
INSERT INTO wer_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Pël mëak piarip ngön nga yaalem wiak kom ëak Panapas pi Maak koirak wangaöök Saipras kustakël sa. ");
INSERT INTO wer_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pël ëën Pool pi Sailas koirak piarip sëpënëak yaëën ingre mor saurö pitök Aköpë lup sant pöta öngpök moulmëak wes mëën sa. ");
INSERT INTO wer_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Siriaare Silisia yang pötë yesem ingre morörö taë mowasö sa. ");
INSERT INTO wer_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Poolre Sailas piarip Tepi kak së wë olëak Listra kak së oröa. Pël ëak itaangkën omën Yesuun kön wi kosang yewesaö namp wëa pim yapinte Timoti. Pim ëlëp Yuta öngöp tapël Yesuun kön wi kosang yewesaup. Ën pim pepap pöt Krik ompöp. ");
INSERT INTO wer_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Ingre mor sa Listraare Aikoniam ka pöörarë wëa pöröak Timoti piin, “Omën ompyaup,” pël maima. ");
INSERT INTO wer_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pötaanök Pool pi Timoti piiring pim yaatak sëpënëak kön wia. Pël ëën Yuta omën ka pötë wë seëaurö pit Timoti pim pepap Krik omnamp yak kön selap ëa. Pöt tol ëënak? Pit Anutuun yaö ëak koröp kaut nailënörö. Pötaanök Pool puuk Timoti koröp kaut ila. ");
INSERT INTO wer_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Pël ëak pit ka poutë yesem Yerusalem kakaan Yesuu ngön yaaö omnaröere wotöököröa ngön ëmön ë mena pöt ingre mor sauröen ök mëak ngar weim öpënëak mëëa. ");
INSERT INTO wer_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Pël ëën ingre mor sauröa kön wi kosang yewesa pöt kaö sëën kët poutë omën muntarö yal mangkën selap sa. ");
INSERT INTO wer_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Ngëëngk Pulöök Esia yangerak së ngön ök mapanëak nga maan pit om yesem Prisiaare Kalesia yang pöraarël sa. ");
INSERT INTO wer_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Pël ëak pit Misia yangera kautak së oröak Pitinia yangerakël sëpënëak yaëën Yesuu Pulöök kan mowaria. ");
INSERT INTO wer_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Pël ëën pit Misia pörekaan el wesak Troas kak së oröa. ");
INSERT INTO wer_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Pël ëak rö kan Pool wangarötë yemangk pöl ëak itaangkën Masetonia omën namp pim naë wais taueë kosang wesak epël ök mëëa. “Ni i kaö olëak Masetonia yangerak wais ten kaamök elniim.” ");
INSERT INTO wer_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pël yemaan Pool pi itenak ten Sailasën ök niaan Anutuuk Masetonia yangerak ngön ompyaut ök manëak yas yenia pël wesak sënëak teëntom ko ëaut. ");
INSERT INTO wer_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Ko ëak wangaöök ilëak Troas kakaan Samotres kustak së oröak ëlpamök Niapolis kak së oröak, ");
INSERT INTO wer_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","wangaöökaan ngentiak pörekaan yangerak së Pilipai kak së oröaut. Ka pö Rom omnaröa wëau, Masetonia yang pörekë ka kaöaö. Pöök ten akun selap selap wë, ");
INSERT INTO wer_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","kë yesa akunetak ka ëmöökë ëm kanërak wele rëak imeri saut. Ten kat wiin Yuta omnarö pit pörek Anutuun ök yamëëa. Pël ëaut yak së itaangkën öng narö wais wëa ëën pitring wel aisëak ngönaak ëaut. ");
INSERT INTO wer_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Pël ëën öng pöröa naë Tiatira kakaan öng namp poë koröp köp möömaap ëa ompyaut ket yeem mon yewaup yapinte Litia pi Anutuun yaya yamëëaup. Aköpök lupmer kaip motiin Poolë ngön ök yamëëa pöt këëkë kat wiak kön wi kosang yewas. ");
INSERT INTO wer_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Pël ëën piire pim kaatakörö i momëën öng pöpök tenën epël yenia. “Ar neen kön wiin, Aköpë ënëm yes pöt, nem kaatakë waiseë.” Pël niak ke yaurön ten pim ngönte ngar wak piiring saut. ");
INSERT INTO wer_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Akun nentak ten yang lup Yuta omnaröa Anutuun ök yamëëautak yesem koont urmerap pim lupmeri wëaö namp koiraut. Urmer pöp piiring wë omën orööpnaatön ök më pël yaaup. Pël ëën omën kësang pan pitëm naë omnant ënëm orööpnaatön puuk itenak yemaan sumat mangkën pim ngarangk yaaurö pit mon kësang pan weim yeëa. ");
INSERT INTO wer_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Koont pöp tenim ënëm yewaisem ngön ëak epël aö yewais. “Omën eporö Anutu O Ngaarëkëpë ya omnarö. Pitök Anutuuk kama niöpna pöta ngönte ök niiaö yaaurö.” ");
INSERT INTO wer_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Kët ël epotë pël aimën Pool pi kaaö ëën kaip tiak urmerapön epël yema. “Ne Yesuu weëre kosangööring yeniakerek koont pipop sëp mowesak oröak së.” Pël maan tapëtakëër koontup sëp wesak oröak yes. ");
INSERT INTO wer_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Oröak sëën koontupë ngarangkörö pit itaangkën pitëm ngaanë mon yewa pöl kaalak naöpanëën yeëa. Pël ëën Poolre Sailas moröak ka tomök së kaöaröa naë ngön yaatak yemoulmë. ");
INSERT INTO wer_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Pël ëak ngön ë pet yairauröen epël yema. “Iteneë. Yuta omën epaar ieping ëak wëwë utpetat tiarim tekrak wais yawi. ");
INSERT INTO wer_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Pël ëak piarip tiar Rom omnaröa ëënganëak nga wieëaut pet elniak ënëm ëëpenëak yenia.” ");
INSERT INTO wer_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Pël maan omën ngön pöt kat wia pörö pit pourö el sak maan ngarangköröak ulpëënaar keli moolëak pitëm nga omnaröen maan pës yemomö. ");
INSERT INTO wer_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Pël ëak utpet mowesak wii kaatak moulmëak ka pöta ngarangkëpön këëkë pan ngarangk ëëpënëak ök yema. ");
INSERT INTO wer_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Pël maan wii kaata ngarangkëp kat wiak wii kaata ka kakaati panëëtak së moulmëak ingesiar këra uamngesiarë tep mö mowia. ");
INSERT INTO wer_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Röök lupöök Poolre Sailas Anutuun kimang mëak rangk tan yemaan wii omnarö kat wiaan, ");
INSERT INTO wer_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","tapët pöt moup kësang nempel möön wii kaata wapöt tiak së yengentiin ka kanöt tëak yesën wii omnaröa morötë wii tëa pötta wilak sa. ");
INSERT INTO wer_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Pël ëën wii kaata ngarangkëp pi ka ureimaurekaan wal ëak itena pöt wii kaata kanöt të wiaan itenak wii omnarö oröak kas sa pël wesak yepatöökaan öpwer tëak pimtok pimënt wesirëpënëak ëa. ");
INSERT INTO wer_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Pël yaëën Poolök ngön ëak epël mëëa. “Nimtok nimënt utpet wasngan. Ten pourö e om wë.” ");
INSERT INTO wer_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Pël maan wii kaata ngarangkëp pim ya omën nampön maan esuwes mangkën wak pöömpö kakaati ilëa pöt kas ëak reireë urö Poolre Sailasë naë së ngentia. ");
INSERT INTO wer_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Pël ëak piarip koirak tomök orö epël ök mëëa. “O nem kaöaar, ne tol yaal ëënak Anutu pi ne kama neöpën?” ");
INSERT INTO wer_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Pël maan piarip epël ök mëëa. “Ni Aköp Yesuun kön wi kosang wasumë pötak niire nimorö Anutuuk kama niöpnaat.” ");
INSERT INTO wer_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Pël mëak piarip Aköpë ngönte piire pim kaatak wëauröen ök mëëa. ");
INSERT INTO wer_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Pël maan röök tapëtakëër pi piarip koirak së piarpim pës momöaut i moirën teëntom piire pimorö i momëa. ");
INSERT INTO wer_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Pël elmëën pi piarip koirak pim kaatak së ulmëak kaömp menak piire pimoröa Anutuun kön wi kosang wesa pötaan ërëpsawi kaö ëa. ");
INSERT INTO wer_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Pël ëak wëën ëlpamök ngön ë pet yairaurö pitök polis narö wes mëën së epël ök mëëa. “Ni omën epaar wes momëën sëpën pël ya.” ");
INSERT INTO wer_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Pël maan wii kaata ngarangkëp pi ngön pöt kat wiak Poolön epël mëëa. “Ngön ë pet yairaurö pit ne arip wes nimëëmëak ya. Pötaanök wes nimëëmaatak lup wiaptaring sën.” ");
INSERT INTO wer_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Pël maan Pool pi polisöröen epël mëëa. “Tenip Rom omën sauwaarök tenpim saun nant wiaan pöt pit yok pangk ngön yaatak niulëak tekeri wasëpnaatep pit köntak tenip pouröa ëöetak niulëak pës nimöak wii kaatak niulëaurö. Pël ëautep peenök kaalak ëlëëp wes nimëëpënëak ëa ma? Pël naëngan pan. Pitëmtok waisak wes nimëën oröönaat.” ");
INSERT INTO wer_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Pël maan polisörö pit piarpim ngön pöt kat wiak së ngön ë pet yairauröen ök maan pit kat wia pöt Rom omnaarök ëa. Pël ëën pitëm utpet elmëa pöten kön wiak kas ëa. ");
INSERT INTO wer_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Pël ëak pit së yaköm köm mëak wii kaatakaan wes mëën oröa. Pël ëën piaripön epël ök mëëa. “Arip yok pangk ka epö sëp wesak sën ma?” ");
INSERT INTO wer_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pël maan piarip wii kaat sëp wesak Litia pim kaatak së ingre mor sauröen itenak wa korkor ngön mëak sa. ");
INSERT INTO wer_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Poolre Sailas piarip së Ampipolisre Apolonia ka pöörar il wesak Tesalonaika kak së oröa. Kak pörek Yuta omnarö pitëm ngönën tupët wieëa. ");
INSERT INTO wer_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pël ëak Pool pim yaaul Yuta omnaröa ngönën tuptak së ilëak ngönën pepeweri ngön wia pöt omnaröaring aima. Pi kë yesa akun nentepar nent pötë öngpök pël eima. ");
INSERT INTO wer_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Pi Anutuu ngönta songönte werak epël ök mëëa. “Anutuuk Kristo pim Yaö Mëëaö pöp këlangön kat wi yesem wel wiak kaalak wal ëëpënëak mëëaup. Yesu nem peene ök yeniak epop pi Kristo Anutu pim Yaö Mëëaup.” ");
INSERT INTO wer_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Pël maan pitëm naëaan omën narö pit kat wiak wa yaap wesak Poolre Sailas piarpim ngësël rë olëa. Pël yaëën Krik omën Anutuun yaya maim wëaö naröere öng isa narö pitta tapël ëa. ");
INSERT INTO wer_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Pël ëën Yuta omnarö pit pöten itenak ya sangën ëën omën utpet kan paspas eim wëaö naröen maan pitök omën ka pöök wëa muntarö koirak ëlakëlakëër Sesonë kaatak së Poolre Sailas ngön yaatak moulmëëpënëak kaata kanöt të moolëa. ");
INSERT INTO wer_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Pël ëak Poolre Sailas won ëën ap wesak Sesonre ingre mor saö narö koirak ka ngarangköröa ngësë weruak yesem ngön ëak epël maö sa. “Omën pöaar utpet petpet ë ka nantë imauwaarök eprek wais oröön, ");
INSERT INTO wer_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Sesonök pim kaatak koirak së ulmëak wë. Omën pöaar piarip Rom omën omp aköp Sisa pim ngön ë kosang wesaut ilak omën omp ak ngolöp namp yapinte Yesu pim ënëm ëëpënëak ök aö yaauwaar.” ");
INSERT INTO wer_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Pël maan ka ngarangköröere omnarö pit ngön pöt kat wiak yaan kaö sa. ");
INSERT INTO wer_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Pël ëak Sesonre piiring wëaurö pitëm naë oröa pöt kaalak orööpanëak pitëm naëaan sumat wak wes mëën sa. ");
INSERT INTO wer_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Rö kan tapöök ingre mor saurö pit Poolre Sailas wes mëën Peria kak së oröak Yuta omnaröa ngönën tuptak së ilëa. ");
INSERT INTO wer_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Omën pörek wëaurö pit ngön kat yawiaurö, Tesalonaikaaröa ök wonörö. Pit Anutuu ngönte kat wiipënëak kent ëak kët poutë ngön pöten yaap ma kaar pöten itaampënëak ngönën pepat wak iteneima. ");
INSERT INTO wer_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Pël ëak Yuta omën naröere Krik öng yapinring naröere omp narö pit selap Yesuun kön wi kosang wesa. ");
INSERT INTO wer_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Pël ëën Yuta omën Tesalonaika wëaurö pit Pool Peria kak wë Anutuu ngönte ök yamëem wëaut kat wiak kak pörek së piarip utpet mowasëpënëak omnaröa könöt irikor mowesak lupöt es nga mowesa. ");
INSERT INTO wer_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Pël yaëën ingre mor saurö pit Pool wes momëën i kaöökël sa. Ën Sailasre Timoti piarip Peria kak om wakaima. ");
INSERT INTO wer_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Pël ëaan omën Pool mësak saurö pit Atens kak moulmëa. Pël ëak kaalak sëpënëak yaëën Pool pi Sailasre Timoti pim ngësël teëntom sëpënëak maan sa. ");
INSERT INTO wer_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Pool pi piaripön kor Atens kak wë itaangkën kak pörek omp ak kaarörö kësang wëën itenak pim yaat utpet pan ëa. ");
INSERT INTO wer_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Pël ëën pi Yuta omnaröa ngönën tuptak së ilëak Yuta omnaröere köpël omën munt Anutuun yaya yamëëa naröaring ngönëntaan aima. Pël ëak pi kët poutë wa top yaaurek së omën pas së wëauröen ngönën ök maima. ");
INSERT INTO wer_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Pël ëën Epikurianre Stoik ëwat omën narö pit piiring ngön nga yaalem pitëm naëaan naröak epël mëëa. “Omën ngön paspas aö pipop pi tol apënëak aim?” Pël yemaan naröak epël mëëa. “Pi ka nantëëröa omp aköröa ngön nant apënëak niaim koröp.” Pool pi Yesu weletakaan wal ëaup pim ngönënte ök yemaan yak pit pël maima. ");
INSERT INTO wer_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Pël ëak pit Pool koirak ngön ök ëak kat yawiaö yang lup nent yapinte Ariopakas pörek së kaöaröa naë ulmëak epël mëëa. “Ten nim ngön ngolöp omnaröen ök maimën piten aan kat wiin. ");
INSERT INTO wer_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ten nim ngönten kat wiin maim yaë. Pötaanök ngön pita songönte ök aan kat wiinaan.” ");
INSERT INTO wer_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Pitëm Poolön mëëa pöta songönte epël. Pit omën suure kak Atens kak wëaö pörö pit akun poutë ngön ngolöpöt ök ëak kat wieima. ");
INSERT INTO wer_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Pit Pool Ariopakas pörek moulmëak, pëël maan wal ëak kaöaröen epël ök mëëa. “Atens omnarö, arim omp aköröen kosang wesak yaya yamëëauten ne ëwat wë. ");
INSERT INTO wer_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ne arim kak yesem itaangkën arim omp ak yaya yamëëauröa kaat wia. Pël ëaan itaangkën omp ak nampë könta rangk retëng nent epël wiaan itenaut. ‘Epët omp ak tiarim köpëlëp pimët.’ Pël ëaan itenaut. Pötaanök arim omp ak köpël wë yaya pas maö iman pöpë ngönte ök yenia. ");
INSERT INTO wer_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Anutu pi yanger ket ëak yangera rangk omnant wia epot ket ëaup pi kutömre yangë Kaöap. Pötaanök pi yok pangk ka omnaröa ök rëautak naöpanëëp. ");
INSERT INTO wer_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Pi nantön elek ëën aan omën moresök yok pangk kaamök naalmëënganëëp. Piita pimtok omnaröa wëwë pipotre omën pout nineim wëaup. ");
INSERT INTO wer_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Anutu pi tiarim ë kopetap ket ëaup. Pël ëën piikaan ulöl sak wëën rep nimëak kaare yang ninaup. Pimtok tiar öpenëak yaö niak niulëaup yak tiar yanger ninak yangerak öpena akunet ninaup. ");
INSERT INTO wer_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Tiar Anutuun ngaöl ë yesem koirëpenaat pël ëëpenëak epël ket elnia. Pël ëak pi kamaarek naön tiar omën pouröak pangk pangk ëak wëaup. ");
INSERT INTO wer_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Pël ëa pötaanök puuk tiarim songön ket ëak wëën tiar wëwëetaring wë kan së waisö ëeim wë. Pötak arim naëlaan ëwat omën naröak epël niaim. ‘Tiarta pim ruurö,’ pël niaim wë. ");
INSERT INTO wer_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Yaap, tiar Anutuu ruurö. Pötaanök tiar piin kön wiin omp ak morökörö kolre siluwaare këlötök omnaröak kön wiak moresring ket ëak pitëmëën ngëëngk mowasö ima pötëël kön nawiingan. ");
INSERT INTO wer_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Yaap, ngaanëër omnarö pit köpël wë yak omnant pipot ket ëeima. Pël yaëën Anutu pi pitëm omën wak ima pötön nga nemaan ëa. Ën peene akun eptak Anutuuk yang ël epotë omën pouröen pim ngön kosangët epël ök yenia. ‘Ar arim utpet yaaö pout kasëng menak nem naël waiseë.’ ");
INSERT INTO wer_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Pël ëak pi yang ël epotë omën pourö wotpil niwesak wël ëak kom elniipna yak akun nent wia. Pi ngaanëër omën namp tiar kom elniipënëak yaö mëëaup. Pi pim ëëpna pöt yaapöt tiar omën pouröen pet elniipënëak omën pöp weletakaan wal ë moulmëa.” ");
INSERT INTO wer_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Pël maan pit omnamp weletakaan wal ëa pöt kat wiak naröak ökre was mëëa. Ën naröak epël mëëa. “Ni ënëmak omën pipëta ngönte kaalak aan ten kat wiinaan.” ");
INSERT INTO wer_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Pël maan Pool pi pit sëp mowesak sa. ");
INSERT INTO wer_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Pël ëën narö Pool pim ënëm ëak Yesuun kön wi kosang wesa. Pël ëa pörö eporö, namp Taionisias Ariopakas kaöaröa naëaanëp, ën öng namp yapinte Tamaris, piaripre ën piarpim kar narö. ");
INSERT INTO wer_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Ënëmak Pool pi Atens kak sëp wesak Korin kakë sa. ");
INSERT INTO wer_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Pël ëak së Yuta omën yapinte Akuila pöp koira. Pi Pontas yangerakaanëpök piar öngöp Prisila Itali yangerak wë olëak ngaan ngaantakëër së wëa. Pöt Rom omën omp aköp Klotias puuk Yuta omën Rom kak wëaö pourö kan sëpënëak maan sa. Pël ëauwaar piarpim naë Pool pi sa. ");
INSERT INTO wer_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Pi piaripring ya ngawiap yak piaripring së wë poë koröp ka ök yarëaut ket ëeima. ");
INSERT INTO wer_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Pël ëeimeë Pool pi kë yesaö akunatë Yuta omnaröa ngönën tuptak së ilëak Yutaare Krik omnaröaring Yesuun kön wi kosang yewesauta ngönöt aima. ");
INSERT INTO wer_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Pël eim wëën Sailasre Timoti Masetonia yangerakaan ënëm së oröön Pool pi pim waur muntet sëp wesak akun poutë Yesu pi Kristo Anutu pim Yaö Mëëaup pöta songönte kosang wesak ök maima. ");
INSERT INTO wer_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Pël ëën narö pit kat wiak pim ngönte wa olëak piin utpet wesak maan pi kangiir pim ulpëënëpökaan ulölöt keke ur moolëak epël mëëa. “Ar kö sënë pöta songönte arimtëët, neering ngawi won. Pötaanök ne peene ar sëp niwesak köpël omnaröa ngësë sumaan yeë.” ");
INSERT INTO wer_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Pël mëak Pool pi Yuta omnaröa ngönën tupët sëp mowesak Tisias Sastas pim kaatak së wakaima. Omën pöp pi Anutuun yaya maim wëaup pim kaat Yuta omnaröa ngönën tupta naë wieëa. ");
INSERT INTO wer_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Pël ëën Yuta omnaröa ngönën tupta wotöököp, pim yapinte Krispas, piire pim kaatakörö pit Aköpön kön wi kosang yewasën Korin omën narö pitta Pool pim ngönte kat wiak Aköpön kön wi kosang wasën i momëa. ");
INSERT INTO wer_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Pël ëak röök nentak Pool pi wangarötë yemangk pöl ëën Aköpök ngön nent epël ök mëëa. “Ni kas ëak ngönën ök yamëëaut sëp wasnganok, om ök maim öm. ");
INSERT INTO wer_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Ne niiring wëën omën nampök wal ëak ni utpet naniwaspan. Ne omën selap pan ka epöök nem ënëm sëpënëak yaö mëëaup pötaanök.” ");
INSERT INTO wer_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Pël maan Pool pi ka pöök Anutu pim ngönte ök maim wëën ngoon 18 ëak won sa. ");
INSERT INTO wer_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Ënëmak Rom yang ngarangk namp, pim yapinte Kalio, pi Krik yang pör ngarangk ëak wëën akun pötak Yuta omnarö pit wa top ëak Pool wali wak së ngön yaatak moulmëak epël ök mëëa. ");
INSERT INTO wer_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","“Omën epop Rom omnaröa ngön kosangöt ilap riak omnaröen Anutuun yaya mapënëak kan maimat pet yaalmë.” ");
INSERT INTO wer_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pël maan Pool pi ngön apënëak yaëën Kalio pi wal ëak Yuta omnaröen epël mëëa. “Yuta omnarö, ar kat wieë. Omën epop Rom ngön ë kosang wesaut ilap riak utpet nant yaëën neen neanë pöt ne yok pangk arim ngönöt kat niwiimaat. ");
INSERT INTO wer_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Pël ëëmaatep ar neen ngön nentere nent, yapin ke nentere nent arim ngönëntakël wieëaut aim. O o, arök neen ngön ke pilöt kat wiimaat wesaurö ma? Won pan. Arimtok omën pita ngönte wotpil weseë.” ");
INSERT INTO wer_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Pël mëak ngön yaatakaan waö ë momëa. ");
INSERT INTO wer_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Pël ëën pit tomök oröön Krik omnaröak Yuta ngönën tupta ngarangkëp yapinte Sostenis, pöp moröak tang möak utpet mowasö yesën Kalio pi om it mongneëa. ");
INSERT INTO wer_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pool pi Yesuu ingre mor sauröaring kët selap wë ënëmak pit sëp mowesak Akuilaare pim öngöp Prisila pit naar namp ëak Senkria kakël sa. Pël ëak pörek së Anuturing ngön kosang wesaö pöta këët pet irak pim ngan ëpët kat ë moolëa. Pël ëak wang Siria yangerakël sëpna naöök sa. ");
INSERT INTO wer_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Pël ëak Epesas kak së oröak pit Yuta omnaröa ngönën tuptak së ilëak Pool pi pitring ngönaak wali aima. ");
INSERT INTO wer_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Pël ëën pit Pool akun wali pitëm naë öpënëak maan, “Pël naëngan,” mëak sëpënëak yeem epël ök mëëa. ");
INSERT INTO wer_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","“Ënëmak Anutuuk kaalak arim naë waisumëak neaan pöt waisumaat.” Pël mëak Akuilaare Prisila piarip kak pörek moulmëak pit pouröen yaköm köm mëak sa. ");
INSERT INTO wer_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Yesem Sisaria kak së oröak Yerusalem kak së ingre mor sauröen yoöre ërëp mëak kaalak Antiok kakël sa. ");
INSERT INTO wer_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Pörek së oröak wë akun wali wali sëën Antiok kak pörek sëp wesak ka nantë Kalesiaare Prisia yang pöraarël yesem Yesuu ingre mor sauröen ngönën ök mëak taë mowasö sa. ");
INSERT INTO wer_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Omën namp, Alesantria kakaanëp pim yapinte Apolos, pi Epesas kak së wakaima. Omën pöp pi omnant kësang ëwat sa pet irak ngönën pepeweri ngön wia pöt pout ëwatëp. ");
INSERT INTO wer_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Omën pöp pi Aköpë elnia kan pöt ëwat wë pöta ngönte kosang wesak yaaup. Pël ëak pi Yesu pim songönte apënëak pöt pout mëngkre mëngk yaaup. Pël ëaap pi om Son pim omnarö i momëa pöten pëën ëwat wakaima. Ën Yesuu ru ulöpöököp pël sak wë pötaan i momëëpna pöten köpël wëa. ");
INSERT INTO wer_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Pi ngön pöt kosang wesak Yuta omnaröa ngönën tuptak ök maima. Pël ëën Akuilaare Prisila piaripök koirak së piarpim kaatak ulmëak kan Anutuuk tiarimëën elnia pötön ök maima. ");
INSERT INTO wer_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Pël ëën Apolos pi Krik yangerakë sëpënëak kent yaë maan Epesas kak ingre mor sauröak kaamök elmëak pep newer Yesuu ingre mor saö Krik yangerak wëauröaan pi sant mowasëpënëak retëng ë mena. Pël ëën pörek së wë Anutuuk lup sant elmëën omën piin kön wi kosang yewesaurö pit ompyaö kaamök elmëeima. ");
INSERT INTO wer_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Pël eimeë Yuta omnaröa köpël waswas eim wëaut omnaröa itöök ke ur moolëak pepeweri ngön wia pipot Yesu Kristo Anutuu Yaö Mëëa pöp pim ngönte këëkë wesak ök mëëa. ");
INSERT INTO wer_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolos pi Korin kak wëën Pool pi yang lup nerak ya mëmpö yesem Epesas kak së oröak itaangkën Yesu pim ënëm yaaö narö wëa. ");
INSERT INTO wer_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Pël ëën pitën epël pëlpël mëëa. “Ar ngaan Yesuun kön wi kosang wasën Anutuuk Ngëëngk Pulö nina ma won?” Pël maan pit ngön kangit epël mëëa. “Ten ngaan Anutuuk Ngëëngk Pulö yemengka pipët kat nawiinörö.” ");
INSERT INTO wer_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Pël maan Pool pi pitën epël pëlpël mëëa. “Ën ar i mëënëak talëpë ënëm ëaurö?” Pël maan pit epël mëëa. “Ten pörö Son pim omnaröak i nimëak ngön niiaö pöta ënëm yaaurö.” ");
INSERT INTO wer_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pël maan Pool pi pitën epël mëëa. “Son pim i momëa pöt omnarö pit lup kaip tiak pitëm utpetat kasëng mena pötaanök pël elmëa. Pël ëak pi pitën epël ök mëëa. ‘Ar nem ënëm waisëpna pöpön kön wi kosang wasën.’ Omën pöp Yesu.” ");
INSERT INTO wer_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Pël maan pit ngön pöt kat wiin Aköp Yesu pim ru ulöpöökörö pël sak wëa pötaan i momëa. ");
INSERT INTO wer_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pël ëak Pool pi pim moresiarring pitëm kepönötë mowiin Ngëëngk Pulö pitëm rangk iraan ngön maimat aö Anutu pim ngönöt tekeri wesak ök mëëa. ");
INSERT INTO wer_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Omën pörö pit 12 ëak wëa. ");
INSERT INTO wer_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pool pi Yuta omnaröa ngönën tuptak ilëak pitring ngönënëën yak aöre elö eim wëën ngoon naar namp ëak ilëa. Pi Anutu pim tiar wa ngaöök nimëa pöt pit kat wiipënëak kent ëa. ");
INSERT INTO wer_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Pël ëën omën narö pit lup kosang panë ëak kön wi kosang newasën omnaröa ëöetak Aköpë elnia kan pötön utpet wesak ëa. Pël ëën Pool pi Yesuu ingre mor saurö pit koirak omën kaö namp yapinte Tiranas pim pep kaatak së omnaröaring ngön ngawi aima. ");
INSERT INTO wer_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Pi pël eim wëën krismaki nentepar pöteparë öngpök Yuta omënre köpël omnarö pit pourö Esia yangerak wëaurö Aköpë ngönte kat wia. ");
INSERT INTO wer_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Anutu pi Pool weëre kosang kaamök elmëaan retëng omnaröa it köpëlöt eima. ");
INSERT INTO wer_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Omnarö pit poë koröp kaut Pool piik mësël ëak wak së yauman yaaurö mësël elmëën ompyaö sa. Ën urmerarö wëaurö tapël ëak waö ë momë pël ëeima. ");
INSERT INTO wer_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","14","Pël ëën Yuta omën Anutuun kiri ar yaauröa wotöök namp pim yapinte Siwa pim ruurö 7 ëak pit kaatë sak waisö imeë omën urmerarö pitëm lupötë wëaurö waö ë momë pël eima. Pël ëak pit Yesuu yapintak urmeraröen ököök mëak epël mëëa. “Ni urmer utpetap, ten Yesu, Pool pim ök aö yaaup, pim weëre kosangtak waö ë yanimë.” ");
INSERT INTO wer_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Pël maan urmerap epël mëëa. “Ne Yesuun ëwat wë, Poolönta ëwat wë. Pël ëaap ar tarëkaanörö?” ");
INSERT INTO wer_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Pël mëak omën urmerap wëa pöpök akak sak omën ököök eima pörö mëmpö waö elmëak poë koröp pöt keliak moolaan koröp yoolörö kaatakaan oröak kas sa. ");
INSERT INTO wer_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Pël ëën Yuta omënre köpël omën Epesas kak wëa pörö pourö omën pöta ngönte kat wiak pit kas panë ëën Aköp Yesu pim yapinte ngar wa. ");
INSERT INTO wer_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Pël ëën Yesuun kön wi kosang wesa narö së omnaröa ëöetak pitëm ngaan utpet eima pötön war wesak ök mëëa. ");
INSERT INTO wer_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Pël ëak kempre këar nga yaaurö pit pitëm kempre këar pep kësangöt wak së omnaröa itöök war wesak es momera. Pep pötë sumat 50,000 kina ke pëlëët. ");
INSERT INTO wer_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Pël ëën omën weëre kosangring pöten itenak maan omën muntarö pitëk yal mangkën pitëm lupötë Aköpë ngönte taë sa. ");
INSERT INTO wer_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Ënëmak Aköpë Pulöök Poolön ya ngön maan pi Masetoniaare Krik yang pöraarëël ya nga ë yesem kaalak Yerusalem kak orööpënëak mëëa. Pël maan Pool pi pim omnaröen epël mëëa. “Ne pötë sa pet irak pöt Romëëlta sumaap.” ");
INSERT INTO wer_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Pël mëak pi Timotiire Erastas pim kaamökaar piarip Masetonia yangerak wes mëën yesën pi Esia yangerak wakaima. ");
INSERT INTO wer_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Akun pötak omën narö selap pan Epesas kak wëaurö pit Aköpë kanöök yesauröaan kööre tok kësang pan elmëa. ");
INSERT INTO wer_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Pöta songönte epël oröa. Omën namp yapinte Temitrias pi siluwaatring öng ak nampë yapinte Atemis pim ka könöt ket ëeima. Piire pim ya omnarö sum kësang orööpnaak yak ket ëak wes mëeima. ");
INSERT INTO wer_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Pël yaaurö yak Temitrias pi pim ya omnaröere ën pim ngönt ya tapët yamëna narö pitën yas maan sëën epël ök mëëa. “Karurö, ar ëwat wë. Tiarim omën eptak mon kësang koir yaningkën ompyaö wëaut. ");
INSERT INTO wer_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ar Pool piin ëwat wë. Pim yaautön tiar kat yawiaurö. Pi Epesas kak eprekaan Esia yangerakë omnaröen epël ök maim wëaup. ‘Öngre omp ak kaarkaar omën moresök ket ëa eporö kë wonörö.’ Pool pi pël yemaan omën kësang pim ngön pöta ënëm yaë. ");
INSERT INTO wer_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Tiarim mon wauret utpet ëëpnaaten ne ya ngës yaë. Pël ëën omnaröak ökre was niapanëak. Pötaanök tiar këëkë ngarangk naën ëëpena pöt ngön pöt kaö sak Atemis pim yaya yamëëa kaat utpet wasëpnaat. Pi tiarim öng ak kaöap Esia yangerakre ën yang kaö nantë omnaröa yaya yamëëaup pöt kön nawiipan.” ");
INSERT INTO wer_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Pël maan pit Temitrias pim ngön pöt kat wiak ya sangën ëën ngön ëak epël maima. “Atemis pi Epesas omnarö tiarim kaö panëëp,” pël maima. ");
INSERT INTO wer_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Pël mëak Epesas kak pörekaan omën kësang pan ngön pöt maö së Masetonia yangerakaan Pool pim ya kaamök omën naar Kaiasre Aristakas piarip moröak wak weruak së pitëm wa top kaöaöök moulmëa. ");
INSERT INTO wer_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pël ëën Pool pi pitëm wa topöök sëpënëak yaëën Yesuu ruurö pitök pörek sëën utpet mowaspanëak kan mowaria. ");
INSERT INTO wer_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Pël ëën Esia yangerakaan yang ngarangk Pool pim ngönt naröakta pi wa topöök sëpanëak nga mëak ngön wes mëa. ");
INSERT INTO wer_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Pël ëën wa topöök wëaö pörö pit kön irikor ëak pitëm wa top ëa pöta songönten kön nawiin, narö ngön nent aö yesën, narö nent aö yesën pël eima. ");
INSERT INTO wer_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Pël eim wëën Yuta omnarö omën namp yapinte Alesanta pöp mök ë momëën wa topöök tauaan pit itenak wa top pöta songönte apënëak yaë wesa. Pël ëën Alesanta pi moresring angan elmëak wa top pöta songönte Yuta omnaröak naënte pöt ök mapënëak ëa. ");
INSERT INTO wer_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Pël ëën omnarö pit itena pöt, pi Yuta omnampök yeëa ëën pit këm top ëak ngön ëak epël mëëa. “Atemis pi Epesas omnarö tiarim kaö panëëp.” Pël maim wëën aöa nentepar sa. ");
INSERT INTO wer_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Pël ëën ka pöökë omnant komre kap yaaupök omnaröen ngön angan pël mëak epël mëëa. “Epesas omnarö, ar kat wieë. Omën ka nantëërö pit Epesas omnarö tiar öng ak kaöap, Atemis, pim yaya yamëëa kaatere kël ngëëngk mopöökaan irëa pö ngarangk yeë pöt pit ëwat wë. ");
INSERT INTO wer_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Omën nampök ngön pöt yok pangk wa noolapan. Pötaanök arök pas köntak ëënganëp wiap sak weë. ");
INSERT INTO wer_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Ar iteneë. Omën tiarim wa topöök wak waisan epaar piarip tiarim ngönën tuptakaan omnant kain naön. Pël ëak tiarim öng aköpönta utpet wesak naënaar. ");
INSERT INTO wer_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Pötaanök Temitriasre pim mon waur yaaurö pit omën nampëën kööre tok wieë pöt ngön yaaö akunetak ngön yaatak moulmëën kat yawiaupök kat wiak wotpil mowasëpnaan. ");
INSERT INTO wer_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ën ngön nant om wieë pöt yok pangk wa toptak ngön yaaö akunetak ëak söë wasënëët. ");
INSERT INTO wer_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Pötaanök tiarim wa top epö utpet yeëerek Rom yang ngarangköröak ngön yaatak niulëëpnen ëa. Iteneë. Peene wa top epöök ngön kaëpre ngön ë yoolak pötë songön nent won. Pötaan yang ngarangkëp pëël niiaan tol mapen?” ");
INSERT INTO wer_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Pël mëak omnant komre kap yaaup puuk rep momëën pitëm kaatë sa. ");
INSERT INTO wer_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ënëmak ngön kaëpre ngön pöt ë olëak won wesak wëën Pool pi Yesuu ingre mor sauröen yas maan së pim naë wa top ëën pepanöm ngön ök mëak yaköm köm mëak Masetonia yangerakë sa. ");
INSERT INTO wer_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Pël ëak pi omën we pöököröa naë yesem ingre mor sauröen ngön kësang mëak lup taë mowasö yewaisem tenim naë Krik yangerak wais yaarö. ");
INSERT INTO wer_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Pël ëak pörek wëën ngoon naar namp ëak won sa. Pël ëën pi ko ëak wangaöök Siria yangerakë sëpënëak kat wia pöt Yuta omnarö pimëën nga wia pël maan kat wiak kaalak Masetonia yangerakël sëpënëak kön wia. ");
INSERT INTO wer_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Pël ëën omën ke epëlok Timotiiring Poolë ënëm elmëa. Peria kakaan Sopata, Pirasë ruup, Tesalonaika kakaan Aristakasre Sekantas, Tepi kakaan Kaias, ën Esia yangerakaan Tikikasre Tropimas omën piporö Timotiiring Poolë ënëm elmëa. ");
INSERT INTO wer_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Pël ëak pit pörö wet rëak Troas kak së oröak tenën kor wëa. ");
INSERT INTO wer_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Pël ëën Yuta omnaröa kaömp peret yis namëënöt yena akun ngëëngkët won sëën Pilipai kakaan wang naöök ilëak akun mor nas kan kourak yesem won sëën Troas kak oröak pitring sant kopët nent wëën won saut. ");
INSERT INTO wer_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Wangam kan sënaat yak Sante wiap kan kë nënëak wa top ëak wë Pool pi ngönën wali pan ök maim wëën röök lup yes. ");
INSERT INTO wer_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ka ngaarëk tenim wa top ëan pötak es rompeet selap uteëa. ");
INSERT INTO wer_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Pël ëën omp ulwas namp yapinte Yutikas pi ulöl kanöök wel aisëeë Pool ngönën ök yaan kat men ë wë ka kom eim olëak ka sasa ura. Pël ëak ka kaö wali pan nentepar nent ngaarëk pötakaan kawi ngentiak së yangaak ngentiin oröak itena pöt wel wia. ");
INSERT INTO wer_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pël ëën Pool pi oröak ngemë wa kapariak epël yema. “Ar kön selap ëëngan. Pi öp wë.” ");
INSERT INTO wer_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Pël mëak Pool pi kaalak kakaati ilëak këët pelak naut. Pël ëak kaalak ngön kaut ök maim wëën ëwa tëën ten saut. ");
INSERT INTO wer_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Pël ëën omnarö pit omp ulwas pöp öp wëën mësak së pim kaatak ulmëak pit ya kë pan sa. ");
INSERT INTO wer_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Pool pi ten Asos kak së kor ön niak wet rëak wangaöök wes nimëak pimënt yangaak wais kak tenim wëa pörek oröaut. ");
INSERT INTO wer_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Pël ëën koirak ten pourö kaalak wangaöök ilëak Mitilini kakë saut. ");
INSERT INTO wer_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Pörekaan yesem ëlpam walën Kaios kuste il wesak kët kopët nent won sëën Semos kustak oröaut. Pörekaan yesem ëlpam walën Mailitas kak së oröaut. ");
INSERT INTO wer_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pël ëak Pool pi Yuta omnaröa akun ngëëngk kësang nent yapinte Pentikos pël ya pötak Yerusalem kak së omnaröaring wa top ëëpënëak kön wia. Pötaanök Esia yangerakë sëna akunet won ëën Epesas kak il wesak wangaöök el wesak Mailitas kakë saut. ");
INSERT INTO wer_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Pool pi pörek wë ingre mor sauröa wotöökörö pim naë wais wa top ëëpënëak Epesas kakël ngön wes mëa. ");
INSERT INTO wer_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Pël ëën pit naë wais oröön epël ök yema. “Karurö, ar ëwat wë. Nem ngaan Esia yangerak wais oröak ya ngës rëak mëmpö wais pötön ar ëwat wë. ");
INSERT INTO wer_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Yuta omën narö kët ël epotë ne utpet newasëpënëak kan ëël eim wëën ne ya këlangön pötaring wëën nemtë yapinte wak irëak Aköpë yaat yamëngkaup. ");
INSERT INTO wer_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Pël yeem nem ngön ök niiaöre rë niulö pël yaautë nant ök niak nant ngep naën ne ar kaamök elniak ompyaö sënëëk yak wa topötëëre neenem kaatë ök niiaö imaut. ");
INSERT INTO wer_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Ne ngön pöt kosang wesak ar Yuta omënere köpël omnaröen epël niiaimaut. Ar utpetat kasëng menak Anutuu naë rë olëak tiarim Aköp Yesuun kön wi kosang wasënëak ök niiaimaut. ");
INSERT INTO wer_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Peene pöt ne Yerusalemë sumëak Ngëëngk Pulöök yenëa. Pël ëaap ne pörek së oröp nent koirum wes ne pöten köpël yaë. ");
INSERT INTO wer_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Om nem imautë yesën Ngëëngk Pulöök epël neaimaut pöten ëwat wë. ‘Ni wii kaatak wa niulëak këlangön kat niwiipnaat,’ pël neeaimaut. ");
INSERT INTO wer_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Pël ëaap ne nem koröpöön kön selap naën. Nemëngkën wel wiima pöteta yok pangk. Ne pöt, tiarim Aköp Yesuuk kan yaö neea pöök ulöp ngarngar wë mësaö yesem mës pet irumëak kent yaë. Pël ëak Anutu pim ngön ompyaö pötak komre kolap niweseim wë pöta ngönte kaö wes ök amëak kön wia. ");
INSERT INTO wer_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Ar kat wieë. Ne ngaan arim tekötë imeë Anutuuk wa ngaöök nimëak wë pöta ngönte ök niiaö imaut. Ën peene pöt ne kön wiin ar kaalak neen itnaangkan. ");
INSERT INTO wer_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","27","Pötaanök ne peene war wesak ök niamaan. Akun poutë ne arring wë Anutu tiarim naë ya yamëngk pöta ngönte war wesak ök niiaö imaut. Pël ëak ne pim ngönte amaataan pölöp naënëp. Pötaanök arim tekrakaan namp kö sëpna pöpë songönte nemët won. ");
INSERT INTO wer_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Ngëëngk Pulöök ar omnarö pol sëpsëp ket ëak ngarangk elmëënëak nina piporöere arimënt ngarangk këëkë ëeim ön. Anutu pimtë Ruupë iitak omën piporö kama wak pim ingre mor wesaurö. Pötaanök ar ngarangk këëkë ëeim ön. ");
INSERT INTO wer_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Ne ëwat wë. Ënëmak nem ent ë niulëëma akun pötak omën utpetarö arim tekrak oröak utpet niwesak kent tokoröa sëpsëpörö mëmpënëak waö yaalmë pöl elniipën sa. Pötaanök ngarangk këëkë ëeim ön. ");
INSERT INTO wer_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Arimtë tekrakaanta narö oröak Yesuu ingre mor saurö ar pitëm ngësël sënëëk yak pitëmtë könötëaan ngön kaar rëak niapnaan yaë. ");
INSERT INTO wer_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Pötaanök ar këëkë panë ngarangk ëak nem elnieima pöten kön wieim ön. Ne arring krismaki nentepar nent pötë öngpök kët kanaan rö kanë ngön ompyaut ök niak taë niwasö imeë akun nantë arimëën yaköm ëak ing lelaptaring kaamök elnieimaut. ");
INSERT INTO wer_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Peene ne ar Anutuu naë niulëak pimtok ngarangk elniipënëak piin kimang yemak. Pël ëën ar pim naëaan ngön ompyaö poutë weëre kosang pöt pim komre kolaptakaan önëët. Pim ngön pötak kosang niwasëpnaat. Pël ëën omën ompyaö Anutu pim omnaröaan yaö ëaö pöt yok pangk nimpnaat. ");
INSERT INTO wer_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Ne monere uröm pötön kaur ëak arën kimang neniaanëp. ");
INSERT INTO wer_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Ar ëwat wëën neenta mor epesiarring ya mënak koirak nemënt wëëre nem kaamökörö mampö pël yaaup. ");
INSERT INTO wer_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Nem pël yeë pötak nook arën ya kosang mënak omnant koirak koröp wiap yaaurö kaamök elmëënë pöt pet elnieimaut. Tiar pël yeem pöt Aköp Yesu pim ngön epël mëëa pöten kön wiipenaat. ‘Omnant yemangk pöpë ërëpsawi pötak yeö pöpë ërëpsawi pöt il wasëpnaat.’” ");
INSERT INTO wer_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Pool pi ngön pipöt ök më pet irak ngarangköröaring rar rë wesirak Anutuun ök yema. ");
INSERT INTO wer_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","38","Pël ëak pit pim wet rëak epël mëëa pöten kön wia. “Ar neen kaalak itnaangkan,” pël mëëa pöten kön wiak kapariak tot nak ingre ngön elmë mësak së wangaöök yanuulë. ");
INSERT INTO wer_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Pit ent ë moulmëak wangaöök ilëak el wesak Kos kustakël saut. Pörekaan yesem ëlpam walën Ros kustak së oröaut. Pël ëak pörekaan Patara kak së oröaut. ");
INSERT INTO wer_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Pël ëak itaangkën wang munt naö Pinisia yangerakë sëpënëak yeëa ëën pöök wamp riak saut. ");
INSERT INTO wer_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Pël ëak yesem Saipras kuste katnëël wiaan itnal keker elmëak Siria yangerakël yesem Taia kak së leng ë ulmëak kak pörekë urömat të menaut. ");
INSERT INTO wer_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Pël ëën pörek Yesuu ingre mor saurö koirak pitring wë sant nent won sëën Pulöök pit kaamök elmëën Pool Yerusalemë sëpanëak nga yema. ");
INSERT INTO wer_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Pël ëën pörek wëën tenim akunet won sëën kak pörek sëp wesak yesën Yesuu ingre mor sauröere pitëm öngre ruurö ten wes nimëëpënëak kakaan weler rëak i kaö pouuk së rar rë wesirak Anutuun kimang mëëaut. ");
INSERT INTO wer_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Pël ëak neneren yaköm köm mëak ten wangaöök wamp yariin pit kaalak kakë yes. ");
INSERT INTO wer_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Wangaöök ilëak Taia kakaan yesem Tolemes kak së oröak Yesuu ingre mor sauröen yoöre ërëp mëak pitring wë ka kopët nent yaur. ");
INSERT INTO wer_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Ëlpamök Tolemes kakaan wal ëak yesem Sisaria kak së oröak ngönën ök yamëëa namp kak pörek wëa yapinte Pilip pim kaatak së piiring wakaimaut. Omën pöp pi Yesuu ngön yaaö omnaröa ngaan omën 7 ëak ya ngön mëëaö pöröakaan namp. ");
INSERT INTO wer_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Pöp koont kong nent wëa. Pit omp naön Anutuu tektek ngön aim wëaurö. ");
INSERT INTO wer_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Ten Sisaria kak om wëën Yutia yangerakaan tektek ngön yaaö omën namp pim yapinte Akapas pi wais yaarö. ");
INSERT INTO wer_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Pël ëak tenim naë wais Pool pim yepatu wak pimtë ingre moresiarë tëak epël ök ya. “Pulöök epël yenëa. ‘Yepat epöökë pepap Yerusalem kak sëën Yuta omnaröak epël elmëak köpël omnarö mampnaat,’ pël ya.” ");
INSERT INTO wer_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Pël aan ngön pöt kat wiak ten ka pöökë omnaröak Pool pi Yerusalemë sëpanëak nga mëëaut. ");
INSERT INTO wer_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Pël maan Pool pi epël yenia. “Oröpmorëënök ingre yailak ëak nem lupmer wa könöm yenewas? Ne Yerusalem kak sëën wii kaatak neulëëre nemöön wel wi pël ëëma pöten kas naën. Pöt oröpmorëën? Omnarö Yesuu ngönte kat wiipënëak kent yaë.” ");
INSERT INTO wer_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Pël niiaan ten pim könö ilak menaat pangk naën ëën epël yemak. “Aköpë kentöökë ya pil ëëp.” ");
INSERT INTO wer_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Akun nant won sëën Yerusalem kakë sënëak ko ëak, ");
INSERT INTO wer_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Sisaria kakaan Yesuu ingre mor saö naröaring ten pourö së Saipras kustakaan omën namp yapinte Neson pim kaatak niulëaut. Omën pöp ngaanëër Yesuu ënëm eim wëaup. ");
INSERT INTO wer_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Yerusalem kak së oröön Yesuu ingre mor sauröak ërëpsawi ëak koir yanuulë. ");
INSERT INTO wer_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Pël ëën ëlpamök Poolring Sems pim naë së itaangkën wotöökörö piiring wëa. ");
INSERT INTO wer_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pël ëën Pool pi yoöre ërëp mëak Anutuuk kaamök elmëaan köpëlöröa öngpök ya ke nentere nent mëmpö ima pötë ngönöt ök yema. ");
INSERT INTO wer_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Pël ëën pit ngön pöt kat wi pet irak Anutuun yaya mëak Poolön epël yema. “Karip, ni ëwat wëën, Yuta omën kësang pan, tausen selap narö, Yesuun kön wi kosang wesa. Omën pörö pit Moses pim ngön ë kosang wesauta öngpök ilëak wë. ");
INSERT INTO wer_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Pël ëaap omën naröak nimëën epël ya. ‘Pool pi Yuta omën köpël omnaröa öngpök wëauröen Moses pim ë kosang wesa pöt ngar wak rungaaröa koröp kaut moilööre Yuta omnaröa kan ngaanöök së pël ëëpanëak nga yamëëan,’ pël yaap. ");
INSERT INTO wer_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Nim eprekë waisauteta pit kat wiaap tiar tol ëëpen? ");
INSERT INTO wer_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Pël ëa pötaanök ni tenim niana epël ëëm. Tenim naëaan omën kong nent pit Anutuu ëöetak omën nant naën ëëpënëak ngön ë kosang wesaurö wë. ");
INSERT INTO wer_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Pötaanök ni omën pöröaring Anutuu ngönën tup kaöetak së pitëm öpna pöl wë ngönënëën kölam tëak öm. Pël ëak ni pit sum elmëën pitök ngönënëën kölam tëak öpënëak yaaö pöl kiri ar ëak pitëm kepön ëpöt kat ëëpnaan. Pël ëëmë pötak omnarö pitök niin itaangkën ten Yuta omnaröa yaaul ëan pël niwasëpnaat. Pël ëëmë pötak pit itenak omnaröa nimëën ngön aö ima pötön kaar pël wasëpnaat. ");
INSERT INTO wer_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Ën köpël omën Yesuun kön wi kosang wësauröaan tiar ngaan ngön epël kosang wesak pep retëng ë menaut. ‘Ar omp ak kaarkaaröröaan kiri ar ëaut nënganok. Ar animaurö iit orööpanëak nailën ar ëaut nënganok. Ar animauröa iit nënganok. Ar öngre omp nga ëënganok.’” ");
INSERT INTO wer_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Pël maan Pool pi omën pörö koirak ëlpamök së Yuta omnaröa ngönënëën kölam tëak öpënëak yaaö pöl ëa. Pël ëak pi Anutuu ngönën tup kaöetak së kiri ar yaauröen kët taltak omën pörö ngönënëën kölam tëa pöta kiri wiipën pël mëëa. ");
INSERT INTO wer_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Akun 7 kosang wesa pöt temanöm yesën Yuta omën Esia yangerakaan naröak Pool Anutuu ngönën tup kaöetak wëën itenak omnaröen këk maan moröeë ngön ëak epël mëëa. ");
INSERT INTO wer_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","“Israel omnarö, ten kaamök elnieë. Omën epop kaatë yesem Israel omënere Mosesë ngön ë kosang wesautre Anutuu ngönën tup kaö epëten wak irëak yaaup. Pël ëak nenteta, pi köpël omnarö mësak Anutuu ngönën tup kaö epëtak wais kewil elmë pël yaaup,” pël mëëa. ");
INSERT INTO wer_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Pöt pit ngaan Tropimas köpël omnamp Epesas kakaanëp piiring ka pöök wëën itenak Yuta omnaröa ngön ë kosang wesaut ilak Poolring Anutuu ngönën tup kaöetak yesaup pël wesak mëëa. ");
INSERT INTO wer_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Pël maan omën Yerusalem kak wëa pörö pourö lup es nga sak së wa top ëak Pool moröak Anutuu ngönën tup kaöeta kakaatiaan weruak tomök së moulmëak tapëtakëër kanöt waria. ");
INSERT INTO wer_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Pël ëak Pool mëmpënëak omën Yerusalem kak wëaurö pourö lup es nga sak nga yaal ngön pöt Rom nga omnaröa wotöököpë ngësël sa. ");
INSERT INTO wer_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Pël ëën tapëtakëër pi nga omnaröere pitëm ngarangkörö koirak teëntom pitëm naë sa. Pël ëën omnarö pit piire pim nga omnaröen itenak Pool tang mööpënëak ëaurekaan sëp wesa. ");
INSERT INTO wer_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Pël ëën nga omnaröa wotöököp pi Pool pim naë së wali weë pimoröen epël mëëa. “Omën epop wii weë naöörar motëeë.” Pël mëak omnaröen pëël mëëa. “Epop talëp?” ");
INSERT INTO wer_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Pël maan omën kësang pörek wëaurö pit ngön ëak naröak nent aö yesën naröak nent aö yesën ngaaröa wotöököp pi omën pöta songönten këëkë kat nawiin ëak nga omnaröen maan Pool mësak pitëm kaatakël sa. ");
INSERT INTO wer_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Pël ëën Pool pi ka pöta riringeweri së tauaan omnaröak mëmpënëak kosang pan ëa. Pël yaëën nga omnarö pit Pool ngar wak sa. ");
INSERT INTO wer_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Pël ëën omën kësang pan pitëm ënëm yesem ngön ëak epël mëëa. “Pipop mën wel wieë,” pël mëëa. ");
INSERT INTO wer_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Nga omnarö pit Pool pitëm kaata kakaati wak ilapënëak yaëën Pool pi pitëm wotöököpön epël pëël mëëa. “Ne niin ngön nent ök niam sa ma?” maan wotöököpök epël mëëa. “Ni Krik ngönör ëwat wëën ma? ");
INSERT INTO wer_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Ne kön wiin ni Isëp omnamp ngaantak pi nga wak yang ngarangkëpëën nga omën kësang pan 4000 pörö nga ë öpöt wak yang pultak mësak saup.” ");
INSERT INTO wer_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pël maan Pool pi epël mëëa. “Ne Yuta omnamp Silisia yangerak Tasas ka kepönöökaanëp. Ne yok pangk omnaröen ngön ök mam ma?” ");
INSERT INTO wer_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Pël maan wotöököp pi kuure mak maan Pool pi riringeweri taueë moresring omnaröen angan elmëën pit ngön leng ëën Yuta ngöntak omnaröen ngön ök mëëa. ");
INSERT INTO wer_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Pool pi epël ök mëëa. “Pepere kar nemorö, ar kat wieë. Ne saun wonöp pël niamaan.” ");
INSERT INTO wer_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Pël maan pit kat wiaan Pool pi pitëmtë Yuta ngöntak ök yemaan pit ngön kaëp sëp wesak kat kökö wiaan pi epël mëëa. ");
INSERT INTO wer_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Ne Yuta omën arim karip. Nem ëlëpök Silisia yangerak Tasas kak newilaup. Pël ëën kotuukëër Yerusalem kak e taprek Kameliel pim pep kaatak wëën rë neulön omën tiarim ëere körööröa ngön ë kosang wesa pöt pout ëwat saup. Pël ëak ar epreköröa yeë pöl neenta Anutuu ënëm ëëmëak kosang ngentieimaup. ");
INSERT INTO wer_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Ne ngaan öngre omp Yesuu kan ngolöp epöök yaaurö mëmpënëak utpet mowesak moröak wii kaatak moulmëeimaup. ");
INSERT INTO wer_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Kiri ar yaauröa wotöököpre Yuta ngönënë kaöarö pitökta niapnaat. Omën pörö pit ne Yesuu ruurö wali ömëak pep newer retëng ë Yuta omën tiarim karurö Tamaskas kak wëaurö mampëak nena. Pël ëën omën pörö wali wak waisën Yerusalem kak eprek këlangön kat mowiipënëak saut.” ");
INSERT INTO wer_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Ne seim Tamaskas kak temanöm yewasën këtëp luptak wëën kutömweriaan ëwa kaöempel teënt pan irë neek yaalnë. ");
INSERT INTO wer_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Pël ëën ne yangerak së ngentiak kat wiin ngön nent epël yenëa. ‘Sool, Sool, ni tol ëënak ne utpet neweseimën?’ ");
INSERT INTO wer_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Pël neaan ne kangiir epël mëëaut. ‘Aköp, ni talëp?’ Pël maan pi epël ök yenëa. ‘Ne Yesu Nasaret kakaanëp. Ni kët ël epotë ne utpet neweseimën.’ ");
INSERT INTO wer_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Pël ëën omën neering sa pörö ëwa pëënpelën itena. Ën omnampë neen ngön neea pöt pit kat nawiin. ");
INSERT INTO wer_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Pël ëën ne epël pëlpël yemak. ‘Aköp, ne peene tol ëëm?’ Pël maan Aköpök epël yenëa. ‘Wal ëak Tamaskas kak së orö. Pël ëën omën nampök nim ëëmëak Anutuu yaö ëa pötön ök niapnaat.’ ");
INSERT INTO wer_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Pël neaan ëwa pömpelök nem itöörar ngaap wes noolaan wëën omën neering sauröak mor yal ëak Tamaskas kak së neulnëa. ");
INSERT INTO wer_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Omën namp kak pörek wëa yapinte Ananaias, pi Moses pim ngön ë kosang wesa pötë ënëm yaaup. Omën pöpön Yuta omën ka pöök wëauröak pimëën kön wiin ompyaö yeëa. ");
INSERT INTO wer_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Omën pöpök nem naë wais tauak neen epël yenëa. ‘Sool, nem karip, ni peene kaalak itöörar nganga së,’ pël neaan tapëtakëër nem itöörar nganga sak piin itenaut. ");
INSERT INTO wer_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Pël ëën pi epël yenëa. ‘Anutu, tiarim ëere körööröa yaya maimaup, pim ëëpnaatön ëwat sumëak kom ë niulëak pim ya omën wotpilëpön itenak pim këmtakaan ngön kat wiimëak kom ë niulëaup. ");
INSERT INTO wer_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Pötaanök ni Anutuu ya omën sak nim omën itenak kat wiak pël ëan pipot omën pouröen ök maan kat wiip. ");
INSERT INTO wer_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Oröpmorëën kor ëëm? Wal ë. Pël ëën i nimëën tiarim Kaöapön merëk maan nim utpetat wa niulapnaan.’” ");
INSERT INTO wer_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Ne kaalak Yerusalem kak wais wë Anutuu ngönën tup kaöetak së kimang yamëem omnant wangartak ityaangk pöl ëaut. ");
INSERT INTO wer_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Pël ëak itaangkën Aköpök neen epël yenëa. ‘Ni eprek wë nem ngönte ök amë pöt omnarö kat wiak kosang newaspan. Pötaanök teëntom sëp mowesak sum.’ ");
INSERT INTO wer_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Pël neaan ne kangiir epël mëëaut. ‘Aköp, pit ëwat wë. Ne ngaan ngönën tupötë së omën niin kön wi kosang yewesaurö moröak wii kaatak moulmëëre pës mö pël eimaut. ");
INSERT INTO wer_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Pël ëën Stiwen nim ngön ompyaut yaaup omën naröak mën wel wiaut. Akun pötak ne iteneë yok pangk yaë wesak pim momënauröa ulpëënöt ngarangk ëaut.’ ");
INSERT INTO wer_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Pël maan pi epël yenëa. ‘Ni peenëër sum. Ne kan maim panë nerek köpël omnaröa naë wes nimëëmaan yeë.’” ");
INSERT INTO wer_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Yuta omnarö pit kat wiaan Pool pi ngön ök aö së köpël omnaröa ngësël sëpëna ngön lup pöt yaan pit kaaö ëak ngön ë olëak epël mëëa. “Mën wel wieë. Omën ke pilëp yang eprek naöpan. Pi öp öpan.” ");
INSERT INTO wer_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Pël mëak pit ya sangën kaö ëak ëlak wiak pitëm ulpëënöt ent ëak keke elmëak yangerakaan sumplolöt wes ngaarëk momëa. ");
INSERT INTO wer_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Pël ëën nga omnaröa wotöököpök pim koturöen maan pit Pool kaatak mësak së moulmëa. Pël ëën nga omnaröa wotöököpök Yuta omnaröa Pool pimëën ngön ë olëak aö yesa pöta songönten kat wiipënëak pës kaö pan momööpënëak mëëa. ");
INSERT INTO wer_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Pël ëën pit pës momööpënëak wii yatëën Pool pi nga omnaröa ngarangk namp pim naë tauaan epël ök mëëa. “Arim ngön ë kosang wesautak ngön ë pet nairën wieë yok pangk ne Rom omnamp pës yamöaurö ma? Oröp ëënak ne pil elnëeim?” ");
INSERT INTO wer_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Pël maan nga omnaröa ngarangk pöp pi wotöököpë naë së epël mëëa. “Ni tol elmëëmëak yaën? Omën epop Rom omnamp tiarimënt tapöröep.” ");
INSERT INTO wer_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Pël maan nga omnaröa wotöököp pi Poolë naë së epël mëëa. “Ni neen ök nea. Ni Rom omnamp ma?” Pël maan Pool pi mak mëëa. ");
INSERT INTO wer_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Pël maan wotöököpök epël mëëa. “Ne sum kësang panë ëak Rom ka pep saup.” Pël maan Pool pi epël mëëa. “Nem ëlre pepaar Rom kakaanaarök ne newilaup. Pötaan neenta Rom tapöp.” ");
INSERT INTO wer_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Pël maan omën Pool pës möak songönte kat wiipënëak yaaurö pit teëntom pan pölöp ëak sëp mowesa. Pël yaëën nga omnaröa wotöököp piita kat wiin Pool pi Rom omnampök wii motëa pöt kat wiak kas ëa. ");
INSERT INTO wer_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Ëlpamök nga omnaröa wotöököp pi Yuta omnaröa Poolön nga elmëa pöta songönten kat wiipënëak wii wil moulmëak kiri ar yaauröa wotöököröere ngönënë kansolörö wa top ë moulmëak Pool wii kaatakaan pitëm tekrak mësak orö moulmëa. ");
INSERT INTO wer_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pool pi ngönënë kansolöröen nga iteneë epël mëëa. “Karurö, ne Anutuu itöök wëaup. Peene wë epëtenta kat men ëën utpet nentaring naön.” ");
INSERT INTO wer_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Pël maan kiri ar yaauröa wotöököp Ananaias puuk Pool pim naë taueëauröen këm kantak mor kaë mööpënëak këk mëëa. ");
INSERT INTO wer_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Pël ëën Pool pi epël mëëa. “Ni nim koröpöök ompyaö saan lupmer pöt titi tëak utpet ëaup Anutuuk nimööpnaap. Ni ngön ë kosang wesauta ököök ne wotpil newasumëak nimënt pöp ngön ë kosang wesa tapët ilak nemööpënëak këk maan yenemö.” ");
INSERT INTO wer_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Pël maan Pool pim naë taueëa pöröak epël mëëa. “Ni Anutu pim kiri ar yaauröa wotöök kaöapön utpet wesak yemaan.” ");
INSERT INTO wer_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pël maan Poolök epël mëëa. “Karurö, pi kiri ar yaauröa wotöököp pöt ne köpël yak mëëan. Ne piin ëwat ëën pël nemaan ëan tapön. Ngönëntak omën ngarangk ke pilöröen ökre was mangan yak nga wia pöten ne ëwat wë.” ");
INSERT INTO wer_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Pool pi ëwat wëën ngönënë kaöaröa naëaan, narö Parisi ngönën yaaurö, narö Satusi ngönën yaaurö pël ëwat wë pitën epël ök mëëa. “Ne Parisi omnamp. Nem ëarö tapörö. Ne kön wiin omnarö weletakaan wal ëëpnaat kön kosang wieë ök yaautaan yak ngön yaatak yeneulë.” ");
INSERT INTO wer_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Pël maan Parisiire Satusi omnarö pit neneren ngön kaö mëak komkap ëa. ");
INSERT INTO wer_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Pit epëtak pël ëa. Satusi omnarö pit weletakaan wal yaaöre omnarö könöpringöröere enselörö wë pötön kon wi kosang newasën yaaurö. Ën Parisiirö pit omën pötön kön wi kosang yewesaurö. ");
INSERT INTO wer_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Pötaanök pit neneren ngaare ngön maö yesem Parisi omnaröa naëaan ngön kosangötë ngarangk naröak wal ë taueë ngön ëak epël mëëa. “Ten pim utpet nent nokoirën. Ensel nampök ma kön nampök piin ök maan apna pöt yok pangk.” ");
INSERT INTO wer_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Pël ëak pit ngaampel kaö wesak yaalën nga omnaröa wotöököp pi omnarö Pool narö nal sak weruak yesën koröp ilak wel wiipanëak kas ëën pim nga omnaröen epël ök mëëa. “Ar pitëm tekrak së Pool wali wak së tiarimtë ka kaöetak ulmëeë,” pël mëëa. ");
INSERT INTO wer_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Röök pötak Aköpök Pool pim naë së oröak epël ök mëëa. “Ni ya ngës ëëngan. Nem ngönte Yerusalem kak eprek war wesak omnaröen ök yemaan tapël Rom kak së ök mam.” ");
INSERT INTO wer_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","13","Ëlpamök Yuta omën selap 40 il wesaurö wa top ëak Pool mëmpënëak Anutuu ëöetak ngön ë kosang wesa. Pit pi pan mëmpënëak pitëm iire kaömp ngës olëak wet rëak pi pan mënakök ënëmak iire kaömp nëmpënëak ngön ë kosang wesa. ");
INSERT INTO wer_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Pël ëak pit kiri ar yaaö kaöaröere ngönënë wotöököröa naë së epël ök mëëa. “Ten kaömp ngës olëak Pool mënakök kaömp nënëak Anutuu ëöetak ngön ë kosang wesaut. ");
INSERT INTO wer_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Pötaanök arre ngönënë ngarangkörö nga omnaröa wotöököpë ngësë ngön wes mëak epël ök maë. ‘Ni yok pangk Pool tenim naë wes mëën waisëpën sa ma? Ten pim ngön ëauta songönten këëkë kat wiinaan.’ Pël maan arim ngësë wes mëën yewaisën kan kourak nga wiak mëmpunaan.” ");
INSERT INTO wer_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Nga kup yariin Pool pim sasëpë ruup kat wiak nga omnaröa kaata kakaati së Poolön ök mëëa. ");
INSERT INTO wer_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Ök maan Pool pi nga omnaröa ngarangk nampön ngön maan sëën epël mëëa. “Ni yokot epop wotöök kaöapë naë mësak së. Pël ëën pim ngön nent ök mapnaan.” ");
INSERT INTO wer_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Pël maan nga omnaröa ngarangk pöp yokotup mësak wotöök kaöapë naë së epël ök mëëa. “Wii omnamp Pool pöpök yokot epop nimëën ngön nent waarek mësak waisën ök niapën pël aanak mësak yewais.” ");
INSERT INTO wer_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Pël maan nga omnaröa wotöök kaöapök yokot pöp moresi wak së pëlëër moulmëak piarpimënt wë ëlëëp epël pëël mëëa. “Ni ngön tol nent ök neam?” ");
INSERT INTO wer_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Pël maan yokot pöpök epël ök mëëa. “Yuta omën ngönënë wotöökörö pit ngön kup riak ni ëlpamök Pool pitëm naë wes mëën së pim ngön ëauta songönte këëkë wesak maan kat wiipën pël morök ya. ");
INSERT INTO wer_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Pötaanök ni pitëm ngönte kat mowiingan. Pit omën 40 il wesak selap pan kaömp ngës olëak Pool mënakök iire kaömp nëmpënëak Anutuu ëöetak ë kosang wesak Pool kan kourak yesën nga wiak mëmpënëak nim kuure mak mamë pötaan kor wë.” ");
INSERT INTO wer_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Pël maan nga omnaröa wotöök kaöapök yokotupön epël ök mëëa. “Nim ngön ök yenëaan epët omnaröen manganok.” Pël mëak wes mëën sa. ");
INSERT INTO wer_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Nga omnaröa wotöök kaöapök ngön maan pim ngarangk naar sëën epël ök mëëa. “Arip nga omën selap pan 200 ëak koirak kaalak omën 70 pol osöröak yesauröere kaalak omën munt 200 ëak ingëpöt wak yaaurö pöröeta koirak rö kan 9 kilok pötak sënëën kopëta wasën. ");
INSERT INTO wer_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Pël ëak Poolëënta pol os narö koirën. Pël ëak ar ngarangk këëkë elmë yesem Rom yang ngarangkëp Pilis pim naë së moulmëën.” ");
INSERT INTO wer_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Pël mëak nga omnaröa wotöököpök epël retëng ëak mena. ");
INSERT INTO wer_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“O Pilis, Klotias Lisias nook yang ngarangk ompyaup nimëën pep epwer retëng ë yaningk. Yowe. ");
INSERT INTO wer_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Yuta omnarö pit omën pipop moröak mëmpënëak yaëën ne kat wian pöt pi Rom omnampök ëa. Pël ëën neere nem nga omnarö tenök pitëm morötëaan wa ëp ëaut. ");
INSERT INTO wer_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Pël ëak pit songön oröptak utakök Pool mëmpënëak yaë pöta songönte ëwat sumëak ngönënë ngarangköröa wa toptak wak së moulmëaut. ");
INSERT INTO wer_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Pël ëak ne pitëm Poolëën ngön ëaö pöt kat wian pöt Yuta ngönënta ngön ë kosang wesautë wieëaul ëa. Pi omën utpet mëmpö ma wii motë pël ëëpna nent naën. ");
INSERT INTO wer_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Pël ëën ne kat wiin omën naröak Pool mëmpënëak nga kup riak yaë pël ök yenëa. Pël ëën kat wiakök nim ngësë wes mëën waisëpën yewas. Pël ëak omën pimëën ngön apnaaröen epël ök mëëaut. ‘Ar Sisaria yang ngarangkëpë naë sëak ngön aë,’ pël ök mëëaut. Yok nem ngönte pi tapët.” ");
INSERT INTO wer_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Nga omnarö pit pitëm wotöököpë mëëa pöl ëak Pool mësak ngarangk ë yesem rö kan Antipatris kak së oröa. ");
INSERT INTO wer_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Pël ëak ëlpamök nga omën yangerak yaaurö pit kaalak pitëm kakë yesën pol osöröak yaaurö pitëmënt mësak Sisaria kak së oröa. ");
INSERT INTO wer_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Pël ëak yang ngarangkëpë naë së pepewer menak Pool moulmëa. ");
INSERT INTO wer_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Pël ëën yang ngarangkëp pi pep pöwer sangk kelak Poolön epël pëël mëëa. “Ni yang lup taltakaanëp?” Pël maan Poolök epël mëëa. “Ne Silisia yangerakaanëp.” ");
INSERT INTO wer_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Pël maan epël mëëa. “Omën nimëën ngön aimaurö pit waisënak nim ngönten kat wiimaat.” Pël mëak pim nga omnaröen Pool wak së omën omp ak Erot pim ka ngaantak ulmëak ngarangk ëëpënëak mëëa. ");
INSERT INTO wer_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Wë kët mor nas won yesën kiri ar yaauröa wotöök kaöap Ananaias piire pim ngarangk narö ën ngön yaatak ngön apna omën namp yapinte Tetalas pit pörö Sisaria kak së oröak yang ngarangk kaöap Pilis piin Poolëën ngön ya mëmpna pöta ngönöt ök mëëa. ");
INSERT INTO wer_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Pël ëën Pool pitëm naë wëën yang ngarangkëp Tetalasën ngön maan wal ë Poolë ngësël wesak epël mëëa. “Tenim kaöap Pilis, ni ëwat kësangëp yak yoöre ërëp nianaan. Ni kan ompyauuk niulëak ngarangk elniaan tenim yang eprek mayaap wiaan wakaimaut. ");
INSERT INTO wer_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Pötaanök ten ya ompyautaring wë niin yoöre ërëp yeniak. ");
INSERT INTO wer_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Ne ngön muntat yal menak niaan wali sëpan. Pötaanök ni sant elniak tenim ngön kot niana epët kat wi. ");
INSERT INTO wer_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Omën eit epmor, pi omën kööre tok koir mampö yaaumor. Pi Yuta omën kaare yang poutë wëauröa naë öngöpöngöp ëak nga wilö yaaumor. Pël ëak puuk Nasaret ka pepemor pël ya omën pömörë ngönnges wak yaaö pömeriarë kaö sak wëaumor. ");
INSERT INTO wer_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Omën epmor pi Anutuu ngönën tup kaöet kewil elmëëpënëak yaëënak ten waut. Pël ëak tenim ngön ë kosang wesauta wieëaul ngön yaatak moulmëënëak yaëënak, ");
INSERT INTO wer_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","nga omnaröa wotöököp Lisias puuk waisak kosang kaö ëak tenim moresiaan wa ëp ëaumor. ");
INSERT INTO wer_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Pël ëak Lisias pi omën Poolön ngön apna pörö nim naë wais ök niapënëak mëëaut. Pël ëën nimtok omën epmorön pëël maan pimtok pimtë këmpelëkaan niaan kat wiimëën. Pi tol yaëënak ten pimëën ngön ya mënan pöt ök niapnaat.” ");
INSERT INTO wer_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Pël maan Yuta omnarö pitta kaamök ëak Poolë ngësël wesak epël mëëa. “Ngön pout yaapöt.” ");
INSERT INTO wer_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Pël maan yang ngarangkëpök Poolön moresring ni a pël elmëën Pool pi epël ök mëëa. “Ne niin ëwat wë. Ni yang epëra kaö sak wëën krismaki selap saup. Pötaanök nem ngönte niin ök niamëak ërëpsawi yeë. ");
INSERT INTO wer_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Pöt epël. Ne Yerusalem kak së Anutuun yaya memëak saut. Pörek së wëën akun 12 pëën yes. Ni pitën pëël mamë pöt pit ök niaan kat wiak yaap ëa wasumëët. ");
INSERT INTO wer_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Akun pötak pit neen itenaan ne Anutuu ngönën tup kaöetak omën nampring ngön nga naalëënëp. Ne omën narö nga elëpënëak Yuta omnaröa ngönën tupötëëre ka kaöaöökë öngpök wa top naalmëën ëaut. ");
INSERT INTO wer_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Pitëm ngön nemël wesak aö ngön ya mëmpö pël yaë epot yaap wonötök ya. Kë nentaring aan ni kat wiak wa yaap newasnganëëtök ya. ");
INSERT INTO wer_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ën nem peene niama epët yaaptak niamaan yeë. Ne kan ngolöpöök yesem Anutu tenim ëaröa yaya maimaö tapöpön yaya yamëëaup. Pël yaëënak pitök itenak ten kan ngolöp epöök yesauröen Yuta ngönën ngaante utpet mowasënëak yeë wesa. Pël ëaap ne Mosesre tektek ngön yaauröa retëng ëaö pöt pout erën ëak itaangkën yaap ëën kön wi kosang wesaut. ");
INSERT INTO wer_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Ne yaap Anutuun kön wi kosang wesak pimtën kor wë. Ënëmak pimtok omën utpetre ompyaö pourö weletakaan wal ë niulëëpna pöten kor wë. Yuta omën eporöeta ten pourö pël kön wi kosang wesa. ");
INSERT INTO wer_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Ne akun poutë Anuture omnaröa ëöetak ompyaö ömaataan kosang ngentieim wëaup. Pötaanök nem lupmerën kat men ëën utpetat won. ");
INSERT INTO wer_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Ne Yerusalem kak nasën wëën krismaki selap sëën ënëmak omnarö kaamök elmëak mon mampööre Anutuun kiri mowi pël ëëmëak kaalak Yerusalemë saut. ");
INSERT INTO wer_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Pël ëak ne Anutuu ngönën tup kaöetak së ngönënëën kölam tëak öma pöta kiri yawiem wëën pit neen itenaut. Pël ëautep omën selap neering wa top ëak wë ngön paspas aim naön. Won. ");
INSERT INTO wer_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Yuta omën Esia yangerakaan waisa naröakëër pörek wëaut. Pötaanök pit nemëën ngön apënëak ëanëën eprek waisan tapön. ");
INSERT INTO wer_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Pötaanök omën eporö pitök ne utpet tol nent ëak ngönën ngarangköröa ëöetak tauaan itena pöt ök niap. ");
INSERT INTO wer_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Songön kopët nent wia. Ne ngaan pitëm tekrak taueë ngön ëak epël mëëaut. ‘Ne kön wiin omnarö weletakaan wal ëëpnaat kön wi kosang weseë ök yaautaan peene ngön yaatak yeneulë.’” ");
INSERT INTO wer_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Pool pi pël më pet irën Pilis pi Aköpë kan ngolöpöök yesauröa wëwëatön ëwat panë wë Yuta omnarö kor öpënëak epël ök mëëa. “Ënëmak nga omnaröa wotöököp Lisias pi waisënak ne arim ngönte pet irumaat.” ");
INSERT INTO wer_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Pël mëak nga omnaröa ngarangk nampön Pool wii nemotëën kakaati ulmëëpënëak mëëa. Pël ëak pim karurö itenak omnant mampööre ngarangk elmë pël yaëën nga mepanëak ök mëëa. ");
INSERT INTO wer_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Kët akun nant won sëën Pilisre pim öngöp yapinte Trusila Yuta omnaröa naëaanëp piarip pouwaar sa. Pël ëak Pilis pi ngön kat wiipënëak Poolön yas mëëa. Pël ëën Pool pim naë së omnaröa Yesu Kristo piin kön wi kosang yewesa pölön ök maan kat wia. ");
INSERT INTO wer_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Pël ëën Pool pi kaalak yal menak omnarö wëwë wotpil öpenaatere utpet ëënganëën ngarangk ëëpenaatre Anutuuk ënëmak tiar ngön yaatak niulnëëpnaata ngönte pël ëak mëëa. Pi pël maan Pilis pi kat wiak kas ëak epël ök mëëa. “Ni së, ënëmak mop nent oröön ngön niamaatak.” ");
INSERT INTO wer_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Pim pël mëëa pöt, “Ne ngaak Poolön ököök pël elmëën mon nangkën wii kaatakaan wes momëëmakok,” pël weseë akun selap Poolön yas yemaan së piiring ngönngön eima. ");
INSERT INTO wer_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Ënëmak krismaki nentepar sëën Posias Pestas puuk yangerak ngarangk ëëpënëak Pilis pim urötak sak wëën Pilis pi sëpënëak yeem Yuta omnarö ya kë sëpnaak yak Pool wii kaatak om wëën sa. ");
INSERT INTO wer_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Pestas puuk pim yanger ngarangk ëëpënëak Sisaria kak së wëën akun nentepar nent won sëën Yerusalemë sa. ");
INSERT INTO wer_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Pël ëën kiri ar yaaö kaöaröere Yuta ngarangkörö pim naë së Poolë ngësël wesak epël ök mëëa. ");
INSERT INTO wer_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","“Ni tenim ngönte kat wiak Pool pipop wes mëën Yerusalemë waisëp.” Pit kamtaöök nga wiak mëmpënëak kaar pël mëëa. ");
INSERT INTO wer_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Pël maan Pestas pi kangiir epël mëëa. “Pool pi Sisaria kak wii kaatak om wëën ne akun kot nent kaalak sumaap. ");
INSERT INTO wer_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Pötaanök arim omën kaöarö neering sënaat. Pël ëak së omën pöp utpet nent ëa ëën pöt yok pangk pimëën ngön apnaat.” ");
INSERT INTO wer_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Pël mëak Pestas pi Yerusalem kak pitring wëën kët 8 ma 10 ëak won sëën kaalak Sisaria kakë sa. Pël ëak pi ngön kaatak së wë Pool mësak sëpënëak mëëa. ");
INSERT INTO wer_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Pël ëën pi së wëën omën Yerusalemaan sa pörö pim naë taueë ngön könöm nant pim ngësël wesak mëëa. Pël ëaap pitëm Pestasën mëëa pöt pi kat wiak yaap wasëpna nant nemaan ëa. ");
INSERT INTO wer_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Pël ëën Pool pi pitëm ngön pöt ilak kangiir epël mëëa. “Ne utpet ëak Yuta omnarö tenim ngön ë kosang wes wia pöt ilap nariin ma Anutuu ngönën tup kaöetenta utpet nent naënëp. Pël ëak tiarim omën omp aköp Sisaanta utpet wesak nemaan yaaup.” ");
INSERT INTO wer_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Pël maan Pestas pi Yuta omnarö wiap mowesak Poolön epël ök mëëa. “Ni yok pangk kaalak Yerusalem kak sëën ne pörekök nim ngönte kat niwiimaaten kent yaën ma?” ");
INSERT INTO wer_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pël maan Pool pi epël mëëa. “Ka e nem taua epët omën kaöap Sisa pim ngön yaaö kaat. E tapëtakökëër nem ngönte kat wiimëët. Ni ëwat wëën ne Yuta omnarö utpet nent naalmëënëp. ");
INSERT INTO wer_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Ne utpet nent yaëën pit itenak nemëën ngön ëak nempëna pötaan ngön won. Yok pangk nempënaat. Pël ëaap pitëm nemëën ngön ya pipot kaar ya. Pötaan yang ngarangk omën nampök pitëm moresi pas wes namëën ëëpnaat. Pötaanök ne Rom omën omp aköp Sisa puuk ë pet irëpënëak yak.” ");
INSERT INTO wer_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Pël maan Pestas pi pim kaamököröaring ngön ëak Poolön epël ök mëëa. “Ni ngön ë olëak Rom omën omp aköp Sisa puuk nim ngönte pet irëpënëak yaan. Pötaan ne pim ngësë wes nimëëmaan sum.” ");
INSERT INTO wer_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Ënëmak akun nant won sëën omën omp ak namp Akripa, piire öng nangap Penaisi, piarip Sisaria kak Pestasën yoöre ërëp mapënëak sa. ");
INSERT INTO wer_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Pël ëak wë akun selap selap yesën Pestas puuk Poolë ngönte Akripaan epël ök mëëa. “Omën namp eprek wii kaatak wë. Pilis pi pim ngönte ë pet nairën ëën om wëaup. ");
INSERT INTO wer_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Pël ëën ne Yerusalem kak së oröön kiri ar yaaö kaöaröere Yuta ngarangkörö pit nook pim ngönte pet ir olëak mëmpënaan memëak ök yenëa. ");
INSERT INTO wer_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Pël ëën ne pitën epël ök mëëaut. ‘Ten Rom omnarö om pas könömöt omën muntarö nemangkën yaaurö. Omën ngönte wieëaup pimënt ngön yaatak tau moulmëën pimëën ngön eaö pöröa ëöetak taueë ngön apnaat. Pötaanök ten akun mangkën pim ëën pitëm ngön yaatak moulmëa pöta songönte ök niapnaat.’ ");
INSERT INTO wer_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Pël maan Yuta omnarö wais wëën kau naën wangam kan tapëtakëër ne ngön kaatak së wë pi koirak waisëpënëak mëëaut. ");
INSERT INTO wer_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Pël ëën wais wëën omën pimëën ngön yaaö pörö ngön ëa. Pël ëën ne wet rëak pi utpetat yaaup wesak pit pim utpet ëaö nent apënëak ya wesak kat wian pöt won. ");
INSERT INTO wer_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Pit pitëmtë ngönën wak wëautaan ngön iraan isën yeemak aö omën namp yapinte Yesu pël yamëëaup wel wiaup pël ya. Ën Poolök pöt öp wë pël ya. ");
INSERT INTO wer_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Pël ëën ëngk ma e wesak Poolön epël pëlpël mëëaut. ‘Ni kaalak Yerusalem kak së nim ngönte pörek pet irum ma?’ ");
INSERT INTO wer_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Pël maan Pool pi kaaö neak wii kaatak wë ënëmak Rom omën omp ak Sisa pim naë së ngönte ë pet irëpënëak yenëa. Pël ëën ne maan pi wii kaatak om wëën nga omnarö pit ngarangk eim wëën nem pi Sisaapë ngësë wes mëëma pötakök pet irëpënëak mëëaut.” ");
INSERT INTO wer_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Pël maan Akripaak Pestas piin epël ök mëëa. “Nemtok omën pipopë ngönte kat wiimëak yeë.” Pël maan Pestas puuk, “Ëlpamök yok pangk kat wiimëët,” pël mëëa. ");
INSERT INTO wer_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Ëlpamök Akripaare Penaisi piarip ë rangi kësangöt ëak omnaröa itöök wa top kaatak yesën nga omnaröa wotöök kaöaröere kak pörekë omën yapinringörö pourö piaripring kakaati së wa top ëa. Pël ëën Pestas puuk maan Pool koirak sa. ");
INSERT INTO wer_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Pël ëën Pestasök pitën epël mëëa. “Omën omp ak Akripaare ar omën e wë epörö peene kat wieë. Ar omën epopön iteneë. Yuta omën selap pan Yerusalem kakaan eprekë wëaurö pit pourö ne omën epop pëël elmëën mëmpëna pötaan aim wë. ");
INSERT INTO wer_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Pël ëaap ne pim utpet ëa nenten kat wiin mëmpënaata ök naën yaë. Pël ëak pimtok neen pi Rom omën omp ak Sisa puuk pet irëpënëak yenëa. Pötaanök wes mëën sëpnaan yaë. ");
INSERT INTO wer_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Pël ëak ngön këët ap wesak omp ak kësangëpëën pep retëng ëak wes mëëmaataan poprak yeë. Pötaanök omën epop omp ak Akripa nimëntre arim naë tau yaulmë. Pötaanök arök pim songönte tekeri weseë. Pël ëën pepewer retëng ëak wes mëën sëpnaan. ");
INSERT INTO wer_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Ne wii omën namp wes mëëmëak pepetak pim songönte wes mëëma pötaar yok pangk ëëpnaat. Ën pël naën ëëma pöt pangk naën ëëpnaat.” ");
INSERT INTO wer_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Akripa pi Poolön epël mëëa. “Ni nim ngönte yok pangk a,” maan Pool pim utpet naën pöten apënëak mor ngar wesak epël ök mëëa. ");
INSERT INTO wer_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Omp ak kësangëp Akripa, ne kat men ëën ompyaö pan yaëën nim ëöetak war wesak Yuta omnaröa nem ngësël wesak aim pöta kangit niamaan yeë. ");
INSERT INTO wer_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Tiar Yuta omnaröa ngönënëën ngaal witwit ë omnant yeë pöten ni ëwat wëën. Pötaanök ni wiap sak kat wiaan ök niamaan. ");
INSERT INTO wer_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Nem kotuuk kak wëwë wakaimautre Yerusalem kak së wakaimaö pöten Yuta omnarö pit ëwat wë. ");
INSERT INTO wer_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Ne ngaan pitring wakaimaup yak neen ëwat wë. Pötaan pitök yok pangk apënëak pöt nem pitëm naë ngönën ya mënëimautön apnaat. Ne ngaan Parisi omnaröaring wë pitëm yaaö kan pöök imaup Pötak ngönën muntatë wëwëatre yaaut il yewas. ");
INSERT INTO wer_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Ne peene eprek wëën pit nemëën ngön ya yenemëngk. Pöta songönte epël. Anutu pim tiarim ëaröen weletakaan wal ëëpenëak ngön ök mëëaö pöt kön wi kosang wesak këët orööpnaataan kor wëaö pötaanök ngön yaatak yeneulë. ");
INSERT INTO wer_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Tiarim ëarö, kur 12 pötëaan pörö, kët kanaan rö kanë Anutuun yaya maimeë kön wi kosang wesak omën pötön kor wakaima tapël ne yeë. O omën omp aköp, ne pöten kor wëaö pötaanök Yuta omnarö pit nem ngësël wesak aö ne ngön yaatak neulnëeim. ");
INSERT INTO wer_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Tol ëënak ar Yuta omnarö Anutuun kön wiin puuk yok pangk omnarö weletakaan wal ë niulëëpna pöt pangk naën pël weseim? Ngön pöt kaar won. ");
INSERT INTO wer_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Ne ngaanëër Yesu Nasaret kakaanëp pim yapinte wak irapënëak omnant kësang elmëeimaut. ");
INSERT INTO wer_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Ne Yerusalem kak ya pöt mëngkën kiri ar yaaö kaöaröak neaan Yesuu ingre mor saö narö selap pan wii kaatak moulmëaup. Pël ëën ngön yaatak wëën ne omnarö pitring kaamök ëak mëmpënëak maimaut. ");
INSERT INTO wer_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Pël eimeë akun selap ngönën tupötë ilëak omnarö Aköpön utpet wesak apëna yak këlangön kësang meneimaut. Pël ëak ya sangën pan ëën ka kamaatëëta tapël utpet mowasumëak seimaut.” ");
INSERT INTO wer_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Ne pël eim wëën kiri ar yaaö kaöaröak Yesuu ingre mor saurö ömëak kosang newesak pep nant nangkën wak Tamaskas kakë saut. ");
INSERT INTO wer_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","O omën omp aköp, ne kan kourak yesem këtëp luptak wëën itnan pöt kutömweriaan ëwa kësang kët ëwaat il wesaö nempel irë neere omën neering saurö tenëk yaalni. ");
INSERT INTO wer_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Pël ëën ten yangerak së ngentiak wieë ne kat wiin Yuta ngöntak ngön nent epël yenëa. ‘Sool, Sool, ni tol ëënak ne utpet neweseimën? Nim nemëën pël eimën pitaan omën kë nga ket ëa nent ing möak rë niwalën këëm kat yawiin,’ pël yenëa. ");
INSERT INTO wer_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Pël neaan ne kangiir epël mëëaut. ‘Aköp, ni talëp?’ Pël maan Aköpök epël yenëa. ‘Ne Yesu. Ni kët ël epotë ne utpet neweseimën. ");
INSERT INTO wer_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Ni wal ë tau. Ne peene ni nem inëën niwasumëak ëö pet yaalni. Pötaanök ni nem omën pet yaalni epëtere ënëmak pet elniima pötön omnaröen ök mam. ");
INSERT INTO wer_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","18","Pël ëën ne Yuta omnaröere köpël omnaröa morötëaan ent ë niulëëmaan. Köpëlöröa ngësël wes nimëën pitëm naë së it ngaul moulmëën kout kasëng menak ëwaatakël ko wiak Setenë yaat sëp wesak Anutuu ngësël rë olapnaan. Pël ëak pit Anutuun kön wi kosang wasën pitëm utpetat kërë moolaan pit Anutuu yaö mowesauröa ronganta öngpök ilëak öpnaat.’” ");
INSERT INTO wer_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Omën omp ak Akripa, ne kutömweriaan omën pöt itaampööre ngön kat wi pël ëak wa nemoolaan ëaut. ");
INSERT INTO wer_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Wet rëak Tamaskas kak ök mëak pörekaan Yerusalem kak së ök mëak Yutia yangerak ka wieëa pötë ök maö yesem köpël omnaröenta epël ök mëëaut. ‘Arim utpetat kasëng menak Anutuu ngësël ko wiak wëën arim omnant yaautön itaangkën lup kaip tiauröa yaaul ëëpnaan.’ ");
INSERT INTO wer_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Nem pël ëaö pötaanök Yuta omnaröak ne Anutuu ngönën tup kaöetak wëën wali newak nempënëak ëa. ");
INSERT INTO wer_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Pël ëaatak Anutu pi ne kaamök elnëaan omën isaare irëa pouröen ngönën ök maö imeë tektek ngön yaauröere Moses pitëm ngönötta ök maö imaupök peeneeta e taueë ök yak. ");
INSERT INTO wer_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Pit epël ëa. Kristo, Anutuu Yaö Mëëaup, pi këlangön kat wieim olëak wel wiipënëak mëëaup. Pël ëak weletakaan wet rëak wal ëak Yuta omënere köpël omën pouröaan ëwa ngön pöt tekeri wes mampënëak mëëaup pitëm ngön pöt kaamök yaaup.” ");
INSERT INTO wer_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Pool pi pim utpet naën pöten pël maan Pestas pöpök ngön ëak epël mëëa. “Pool ni kaökaö yaën. Pep kaatë ilëak ëwat kësangöt ömëak kön waur eimeë kön irikor ëak kaökaö yaën.” ");
INSERT INTO wer_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Pël maan Pool pi epël mëëa. “Ngarangkëp, ne kaökaö naën. Yaap kön wieë yak. ");
INSERT INTO wer_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Omën omp ak Akripa pi omën epotön ëwat wë. Pötaanök ne kasinkasin naën ök yak. Omën epot ëlëëp naaröönöt. Pötaanök ne kön wiin omën omp aköp piita itenak kat wiak ëak ëwat wë. ");
INSERT INTO wer_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Omën omp ak Akripa, ni ngaanëër tektek ngön yaaurö pitëm ngönöt kön wi kosang yewasën ma? Ne ëwat wëën ni kön wi kosang yewasën.” ");
INSERT INTO wer_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Pël maan Poolön epël mëëa. “Ni pil neaim wë akun wali nasën tapët ne Yesuu ënëm ëëma yangap yeë pël yewasën ma?” ");
INSERT INTO wer_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pël maan Pool pi epël mëëa. “Peen ëëmëëre ënëm ëëmë poutepar yok pangk. Ne Anutuun epël yemak. Niire ar omën ngön epët kat yawi eporö pourö nem yeë epël Yesuu ënëm ëënëak yeniak. Pöt nem wii netëën wë epël ëënëën won.” ");
INSERT INTO wer_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Pool pi pël maan omp ak Akripaare Rom yang ngarangkëpre Penaisiire pitring wel aisëaurö pit wal ëak, ");
INSERT INTO wer_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","repak yesem pitëmënt neneren epël mëëa. “Omën epop pi mëmpööre wii kaatak ulmë pël ëëpëna pöta ök naën.” ");
INSERT INTO wer_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Pël maan Akripaak Pestasën epël ök mëëa. “Omën epop pi omën omp ak kaöap Sisa puuk pim ngönte kat wiipënëak ngön nemaan ëën pöt nuuk yok pangk wes momëën sëpnaat.” ");
INSERT INTO wer_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Pestas pi ten wangaöök Itali yangerakë sënëak yenia. Pël ëën Rom omnarö Poolre wii omën munt narö Sulias mës yemangk. Sulias pöp Rom omën omp ak kaöap Sisa pim nga omën 100 pöröa wotöököp. ");
INSERT INTO wer_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Ten wang naö Atramitiam kakaan waisa pöök wamp riaut. Wang pö Esia yangerak kaö yangapötë sëpnaö. Pël ëën ten Aristakas, Masetonia yangerak Tesalonaika kakaanëp, pi ten pourö saut. ");
INSERT INTO wer_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Pël ëak ëlpamök Saiton kak së oröak Sulias pi Poolön ompyaö elmëën pim karuröa naë së itenak kaömpre omnant yeö. ");
INSERT INTO wer_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Pël ëak Saiton kak sëp yewasën kent kësangpel weëre kosangring yamöön wangaöökë ngarangkörö pitök wangaö wotpil wesak we kent wonöök Saipras kustakël saut. ");
INSERT INTO wer_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Pël ëak i kaö olëak Silisiaare Pampilia yangeraar ngësngës elmëak yesem Maira kak Lisia yangerak oröak ngentiaut. ");
INSERT INTO wer_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Pörek nga omnarö wotöököpök wang munt naö Alesantria kakëlaan Rom kakël sëpënëak yaëën koirak pöök wamp riaut. ");
INSERT INTO wer_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Pël ëak yesën kent nga yaëën poprak ë yesem akun nant won sëën Naitas kak temanöm wesaut. Pël ëën kentöök kan niwariin Krit kustakël yesem we kent wonöököl Salmoni wot köngkömö temanöm wesaut. ");
INSERT INTO wer_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Pël ëak wang ngarangkörö pit ya kësang mëngkën ten Krit kusta ngësngësöök i kaöök yesem yang lup nenta yapinte Kaö Yangap Ompyau pël yamëëa naö Lasia ka kaöaöökë naë wieëa pörek së oröaut. ");
INSERT INTO wer_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","I kaöök akun wali seimën Yuta omnaröa Anutuuk utpetat won mowasëpënëak kön yawia akunet won sa. Pël ëën kaö ma nga yaaö akunet temanöm sëën wangat sëpënëak pomp yaëën Poolök epël ök yema. ");
INSERT INTO wer_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Ompörö, ne kön wiin peene sëpena eptak omën nant kö sëpenaan yeë. Urömat pëën wasngan. Wangaö utpet ëën omënere urömere pout i kaöök ilapenaan yeë.” ");
INSERT INTO wer_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Pël maan nga omnaröa wotöököp pi Poolë ngön pöt kat wiak yaap newasën wangaöökë pepapre ngarangkëpë ngöntepar kat wiak yaap wesa. ");
INSERT INTO wer_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Kaö yangap pö kent akunaöök wangatë wiaapna urte wonrek yak omën wangaöök wëaurö Krit kus taptak kaö yangap munt naö yapinte Pinis pörek së önëak ya. Pö këtëpë yeilëaul wieëau yak kentö maap namöön yaau. ");
INSERT INTO wer_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Kaö Yangap Ompyaö pöök wëën i kaöökaan kent ulöl kot nent yamö. Pël ëën pit pipöök kaamök elmëën yok pangk Pinis së orööpnaat wesa. Pël ëak wangaö taë yewesau weruak kopël ngaarëk wiak Krit kus pöta ngësngësöök saut. ");
INSERT INTO wer_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Pël ëën akun wali nasën tapët kent kësang nempel kus pötakëlaan yamö. ");
INSERT INTO wer_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Pël ëak kent pöök wangaö mök ëak wak yesën ten kaalak i kaöökël wak sënëak ök ëën pangk naën ëën sëp mowesak wëën kentöök niwak saut. ");
INSERT INTO wer_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Pël ëën we kent wonöök kus kot nent yapinte Kota pötakël saut. Pël ëak ten wang kot weruak yesaut wa kaöaöökë ngaarëk wiinëak ya kaö mënaut. ");
INSERT INTO wer_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Pël ëak wangaöök waur yaaurö wa wang kaöaöökë ngaarëk wiak wang kaöaö kelpanëak wa ngaöök mëak wii yatë. Pël ëak pit Aprika yangerak i kaö kep rorookël sëpanëak kas ëa. Pël ëak poë koröpöt ent ë ulmëën kentöök niwak saut. ");
INSERT INTO wer_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Pël ëën ëlpamök kaö maare kent nga kaö ëën wangaöökaan uröm nant ngës rëak yemoola. ");
INSERT INTO wer_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Pël ëak yesem wangam kan muntetak pitëmtë morötring wangaöökë omnant wa yemoola. ");
INSERT INTO wer_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Pël ëën seimeë këtre ngoon nampön itnaangkën kent kësangpel möeim wëën omën pourö kö sënëak yeë wesaut. ");
INSERT INTO wer_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Omnarö akun wali kaömp nanën. Pël ëën Poolök pitëm tekrak së tauak epël ök yema. “Ompörö, ar nem ngön kat wiak Krit kuste sëp newasën ëanëën tiar utpet epot nokoirën ëan tapön. ");
INSERT INTO wer_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Pötaanök ne epël niamaan. Ar kosang seë. Tiarkaan namp kö nasëngan. Wangaöökëër utpet ëëpnaan yaë. ");
INSERT INTO wer_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Ne Anutuu omnamp yak piin yaya yamëëaup. Pötaanök peene rö kan pim ensel nampök nem naë taueë epël yenëa. ");
INSERT INTO wer_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","‘Pool, ni kas ëëngan. Nim ngön pet irumëën Rom omën omp ak kaöap, Sisa, pim ëöetak taumëët. Anutu ompyaö yaaup yak nim kimang mëëan pöt kat wiak kaamök elniin niire omën niiring wangaöök wëaurö öp sënëët.’ ");
INSERT INTO wer_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Ompörö, ne kön wiin Anutuu orööpënëak neea pöt pout kë orööpnaat. Pötaanök ar kosang seë. ");
INSERT INTO wer_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Ën wang epö kentöök wak kus nentak së moolapnaö.” ");
INSERT INTO wer_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Sant nentepar won sëën Etria i kaöök warial yesem rö kan röök lupöök wangaöök waur yaauröak kat men ëa pöt kus nent temanöm yewasem ëa. ");
INSERT INTO wer_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Pël ëën pit ökö i kaöök olëak itna pöt 36 mita pël ëa. Ën kot nent yesem wiak kaalak olëak itna pöt 27 mita ëa. ");
INSERT INTO wer_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Pël ëën këlötë wieëaurek sënganëak kas ëën wangaö leng ëëpënëak wangaö taë yewesa kong nent wangaöökë ëlëerakël yoola. Pël ëak pit këlötön itaampënëak këtëp teënt ngampiipnaataan pitëm omp aköröen kimang mëëa. ");
INSERT INTO wer_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Pël ëak wangaöök waur yaaurö wangaöökaan kas sëpënëak wang kotte wes mëën i kaöök ngemapënëak yeem ngön kaar wangaö taë yewesa muntat wot karerakëlaan olapën yema. ");
INSERT INTO wer_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Pël ëën Pool pi nga omnaröa wotöököpön epël ök yema. “Wangaöök waur yaaö eporö pit wangaöök naön ëëpna pöt tiar pourö kö sëpenaat.” ");
INSERT INTO wer_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Pël maan nga omnarö wang kotta wii ngan ëaut il mëën i kaöök yes. ");
INSERT INTO wer_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Ëlpam walëpënëak yaëën Pool pi omnaröen kaömp nëmpënëak yema. “Akun wali ya ngësring imeë kaömp nanën waiseimën sant nentepar won yes. ");
INSERT INTO wer_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Pötaanök këk niamaan. Kaömp neë. Pötak kosang niwasën öp önëët. Kat wieë. Tiar pourö muumöngk öpenaat. Namp kot nent utpet naëngan.” ");
INSERT INTO wer_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Pël mëak pi kaömp peret nent wak pitëm ëöetak Anutuun yowe mëak pelak ngës rëak yen. ");
INSERT INTO wer_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Pël ëën pit pourö ulöp ketumön sak kaömp yen. ");
INSERT INTO wer_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Ten omën wang pöök ima pörö 276. ");
INSERT INTO wer_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Kaömp na pet irak pit wangaö kengkën sëpëna yak kaömp kër köpötring munt nant wa i kaöök yemoola. ");
INSERT INTO wer_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Ëlpam walën wangaöök waur yaaurö pit yang lup pöten köpël yak itaangkën kaö yangap naö i pis pëënö wieëa pöökël wangaö ökre was leng ëëpënëak yaë. ");
INSERT INTO wer_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Pël ëak wii wangaö taë yewesa pöt il momëën öngpök yes. Pël ëën pit këra wangaöökë sëpnaal wotpil wasö yesauraar wil wiak poë koröp wot karërak ngan ë uteëau wëlël ë ulmëak wëën kentöök wak yesën kaö yangapöökël saut. ");
INSERT INTO wer_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Yesem wangaö kep roro saurek së wangaöökë wot karër i pisöök elak taë sak wëën kaö maatök kasngaëlaan möön wangaö pötöp repa. ");
INSERT INTO wer_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Pël ëën nga omnarö pit wii omnarö wangaöökaan i kaöök sörok olëak kas sëpanëak mëmpënëak kön wia. ");
INSERT INTO wer_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Pël yaëën ngaaröa wotöököpök pit Poolre wii omën muntarö mëmpanëak nga yema. Pël ëak ten pouröen ngön ëak epël yenia. “Ar pourö kaö ma yailaut ëwat wë pöt wet rëak i kaöök sörok olëak seë. ");
INSERT INTO wer_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Ën muntarö ar wangaöökaan këra luprak rëaut wak pötë ngaarëk së i pisöök oröeë.” Pël niaan namp utpet naën. Ten pourö muumöngk së karmak oröaut. ");
INSERT INTO wer_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Karmak së oröak kat wiin kus pöta yapinte Molta pël ya. ");
INSERT INTO wer_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Kak pörekë omnaröak ompyaö yaalni. Kopi ngës rëak yepelën ëp yaëën pit es mer ulmëak niaan ten pourö esuwesi saut. ");
INSERT INTO wer_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pël ëak Pool es nant yangerakaan wa mera pöt kamal namp es nga ëën öngpökaan oröak pim moresi kant mënak wë. ");
INSERT INTO wer_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Pël ëën kak pörekë omnarö pit Poolë moresi kamalöp mënak wëën itenak pitëmënt neneren epël mëëa. “Omën epop pi omën yamëngkaupök i kaöök yewaisem wel nawiin om öp waisa. Pötaanök kangit orö yemorë.” ");
INSERT INTO wer_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Pël mëëaap Pool pöp kamalöp pim moresiaan kërë es momerak won koröp oröak wëaut. ");
INSERT INTO wer_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Pël ëën pit pön mampööre wel wiak së ngenti pël ëëpënaat wesak itenaan utpet ke pël nent pim naë naröön ëa. Pël ëën pit kaip tiak neneren epël mëëa. “Omën epop ëlarëpön ëan,” pël mëëa. ");
INSERT INTO wer_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Ka pöta naë yang wieëa pör kus pöta kaöapë yanget. Omën pöpë yapinte Paplias, puuk ten mës nuwak së pim kaatak niulëak ompyaö ngarangk elnieim wëën kët nentepar nent saut. ");
INSERT INTO wer_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Pël ëak pörek wëën Paplias pim pepap pi yauman koröp es ngaare ya wiap më pël yaëën Poolök pim naë së Anutuun kimang mëak mores pim rangk mowiin ompyaö yes. ");
INSERT INTO wer_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Pël yaalmëën kus pötakë yauman omën muntarö kat wiak waisën ompyaö yemowas. ");
INSERT INTO wer_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Pël ëën pit ten ompyaö ngarangk elnieimën wëak kan sëna akunetak kan kourakë kaömpre waatöt wa wangaöök niwiin wak saut. ");
INSERT INTO wer_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Kus pötak wëën ngoon naar namp ëak won saut. Pël ëën kent akunaöök Alesantria kakaan wang naö kus pötak wais wiakaima pöök ten niwak saut. Wang pöökë wot karërak yang omp ak nanang naarë yapintepar Kastaare Polas pöaarë könaar wieëa. ");
INSERT INTO wer_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Pöök yesem Sairakius kak së oröak wëën kët nentepar nent yes. ");
INSERT INTO wer_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Pël ëën kak pörek wil ulmëak wa pak ëak yesem Risiam kak së oröak kët kopët nent wëën nenta kautak kent ulöl kot nent i kaöökaan yamö. Pël ëën akun nentepar won sëën Putiolai kak së oröak ngentiaut. ");
INSERT INTO wer_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Pël ëak pörek Yesuu ingre mor saö narö koirak pitring önëak niaan sant nent wë olëak Rom kakël saut. ");
INSERT INTO wer_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Ten yesën Yesuu ingre mor saö Rom kak wëaurö pit tenim yesaut kat wiak narö kan kourak wais kaömp yewaurek Apias kak pörek wais yanikoir. Ën narö kan koö ka nentepar nent ëak wieëa pörek wais yanikoir. Pël ëën Pool pitën itenak kön ketumön sak Anutuun yowe yema. ");
INSERT INTO wer_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Pël ëak Rom kak së oröön yang ngarangköröak Pool pi ka yaaptak öpënëak maan wëën nga omën namp kët poutë ngarangk eim wakaimaut. ");
INSERT INTO wer_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Kët nentepar nent won sëën Pool pi Yuta omën Rom kak wëauröa kaöaröen ngön maan wais wa top ëën epël yema. “Karurö, ne ngaan Yerusalem kak wakaimaut. Pël ëeë tiarim omnarö utpet nent naalmëën ma ëaröa ngön ë kosang wesa nent wa noolaan. Pël ëautak pit omën epëtaanök ne wii kaatak neulëak Rom yang ngarangkëpë ngësë wes yenemë. ");
INSERT INTO wer_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Pël ëën Rom yang ngarangkëp pi nem ngönte kat wiak itaangkën nempënaata ök won ëën wes nemëëpënëak ya. ");
INSERT INTO wer_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Pël ëaap Yuta omnarö pit pöten kaaö ëën ke urak pitëmtok ngön ë pet irëpënëak ya. Pël ëën ne kan munt ëëma nent won ëën ngön ëak Sisa pimtok nem ngönte ë pet irëpnaat pël mëëaut. Ne Yuta tiarim karuröaan ngön amëak newaisën. ");
INSERT INTO wer_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Pitëm ne elnëa epëta songönte ök niamëak yas niaanak waisan. Nem kentöök omnaröa moresiarë wii netëa epëta songönte ar ëwat sënëak yaalnë. Pöta songönte epët. Anutuuk omën namp tiarimëën yak wes nimëëpënëak maan Israel omnaröa kor wakaima pöpë ngön epëtaanök.” ");
INSERT INTO wer_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Pël maan pit epël yema. “Yuta omnarö pitök Yuta yangerakaan nimëën ngön anëak pep wes nanimëën ma nampök nim ngönte wak wais ök niaan nimëën utpet wesak naën. ");
INSERT INTO wer_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Pël ëaatak omën we nantëaanöröak waisak pit omën Yesuu ingre mor sauröen kaaö yaë pël aim. Pötaanök ni omën Yesuu ingre mor sauröaan tolël kön wiaan pöten kat yaniwi.” ");
INSERT INTO wer_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Pël mëak akun wiak omën selap pan röökëër Pool pim kaatak wais wa top ëën ngönën songönöt ök maim wëën këtëp ngemë yeila. Ök maö së Anutu pim tiar wa ngaöök nimëak wë pöta ngönte ök yema. Pël ëak Mosesre tektek ngön yaauröa retëng ëa pötta ök maan pit kat wiak pitën lupöt wal ëën Yesuun kön wi kosang wasëpënëak ök yema. ");
INSERT INTO wer_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Ök maan kat wiak narö kosang yewas. Ën narö kat wi kosang newasën yaë. ");
INSERT INTO wer_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Pël ëak pitëmënt ngön ngës wi yesa. Pöt Pool pi wet rëak epël yema. “Ngëëngk Pulöök kaamök elmëën ngaanëër tektek ngön yaaup Aisaia puuk ngön këët tiarim ëaröen epël ök mëëa. ");
INSERT INTO wer_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘Ni së omën piporöen epël ök ma. Ar ngön pëën kat wiinëëtak songönte ëwat nasëngan. Pël ëak itaampunëëtak yok pangk omnantön itnaangkan. ");
INSERT INTO wer_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Omën piporö pitëm lupöt kosang saurö, kat il wariaurö, it mësëaurö. Pit pël naën ëanëën itaampööre kat wiire kön wi pël ëan tapön. Pit pël naën ëanëën nem naë rë olaan ompyaö mowesan tapön, Anutuuk pël ya.’ ");
INSERT INTO wer_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Pötaanök kat wieë. Anutuuk tiar utpetetakaan kama yaniö ngön ompyaö pöt köpël omnaröa ngësël yes. Pël ëën pit kat wiipnaat.” ");
INSERT INTO wer_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Pël maan Yuta omnarö pitëmënt ngön nga elö yes. ");
INSERT INTO wer_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Pool pi Rom kak ka nent pimtok sum ëak wë omën pim naë yesaurö ompyaö moweseim wëën krismaki nentepar sa. ");
INSERT INTO wer_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Pi Anutuuk wa ngaöök nimëa pöta ngönte werak ök mëak Aköp Yesu Kristo, tiarimëën Yaö Mëëaup, pim ngönteta kas köpël omnaröen ök maim wëën nampök kan nemowariin ëa. ");
INSERT INTO wer_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Ne Pool Yesu Kristo pim ya omnampök pep epwer retëng ë yaningk. Anutuuk neön pim ngön yaaö omën sak wëën pi ne pim ngön ompyaut aim ömëak neulëaup. ");
INSERT INTO wer_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Ngön ompyaö pipot ngaanëër Anutuuk tiarën ök niapënëak tektek ngön yaauröen kosang wesak ök maan ngönën pep ngëëngkweri retëng ëaut. ");
INSERT INTO wer_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Ngön ompyaö pöt, Anutu pim Ruup omën sak Tewit pim kurtakaanöröa naë oröa. ");
INSERT INTO wer_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Pël ëak lup kölam wakaima. Pötaanök Anutu pim weëre kosangöök weletakaan wal ë moulmëak pim songönte tekeri wasën tiar, “Yesu Kristo pi yaap Anutuu Ruup,” pël yewas. ");
INSERT INTO wer_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Anutuuk elmëën Yesu Kristook komre kolap elnëak pim ngön yaaö omën newesa. Pi omën yang kaö poutë wëaurö pim ngön ngaarëk wak Kristo piin ping wasënëak pël ëa. ");
INSERT INTO wer_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Ar Rom kak wëaurö arta Anutuuk pitring Yesu Kristo pim omën sënëak yas niiaurö. ");
INSERT INTO wer_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Rom omnarö ar Anutuuk lup sant elniak yas niaan pim omën sak wëaurö. Ne arimëën ngön epët retëng ë yaningk. Tiarim Pepap Anuture Aköp Yesu Kristo piarpim komre kolapre mayaap pöt arim naë wiaap. ");
INSERT INTO wer_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Ne wet rëak ngön epët ök niamaan kat wieë. Arim Kristoon kön wi kosang yewesauta ngönte yang poutë omnaröak yaan kat yawi. Pötaanök ne arimëën Yesu Kristoon yoöre ërëp yemaan Anutuu naë yes. ");
INSERT INTO wer_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Pöt Anutu nem kosang ngentiak ënëm yeem pim Ruupë ngön ompyaut ök yamëëaupök neen itena. Pi neen ëwat wëën ne kët ël epotë arimëën kimang maim wë. ");
INSERT INTO wer_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Ne wet rëak arim naë newaisën wë Anutuuk kön wiin ompyaö ëën kan nent koir nangkën waisumëak kimang maim wë. ");
INSERT INTO wer_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Nem waisumëak kent yaë pöta songönte epël. Ne wais rë nuulön Pulöökaan kaamök nant wak kosang sak önëak kent pan yaë. ");
INSERT INTO wer_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Pöt nem kentöök arim kön wi kosang yewesautak ne kaamök yaalnëën nem kön wi kosang yewesautak ar kaamök yaalniin pël ëak tiarim lupöt taë niwasëp. ");
INSERT INTO wer_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Nem karurö, ar nem songönten ëngk ma e wasnganëën kat wieë. Ne omën maimaröa naë së ngönën ök maan Anutuu naë rë olëa pöl wet rëak arim naë wais ngönën yaata kë tapët iteempëak kent kön wieimaut. Pël ëautak akun poutë omën nantök kan newariin arim naë waisumëak poprak ëeimaut. ");
INSERT INTO wer_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Anutuuk ngönën ya epët nenaut yak omën pourö, kakaan kosangöökë ëwatre köpël pourö ne yok pangk ök mam wesaut. ");
INSERT INTO wer_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Pötaanök Rom omnarö ngönën epët arënta ök niamaataan ya walwal yaalnë. ");
INSERT INTO wer_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Yaap, ne ngön ompyauten ëö naën yaaup. Pipët tiar omën pourö Anutuun kön wi kosang yewasën ompyaö yaniwas. Pi wet rëak ten Yuta omnarö pël elniak peene ar omën muntaröeta tapël yaalni. ");
INSERT INTO wer_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Pöt ngön ompyautak Anutuu tiarim saun won wasën pim ëöetak wotpil wë pöta songönte epël pet yaalni. Tiar ngës rëak Anutuun kön wi kosang mowasën wotpil niwasën kön wi kosang yewesautak öpa. Pöt ngönëntak epël wia. “Omën Anutuun kön wi kosang mowasën wotpil mowasëpna pipop wëwë kosangtak öpnaap.” ");
INSERT INTO wer_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Anutuuk omën pi kasëng menak utpet eimeë pim ngön këët ngep yaalmë piporöaan kangiir pim ya sangënte kutömweriaan tekeri yewas. ");
INSERT INTO wer_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Pöta songönte epët. Anutu pim songön nant tiarën pet yaalni. Pötaanök pim songön tiar omnaröa itaampena salöt tekeri niwesautak omën utpetat yaë piporö itaampënaaten kaaö yaëën Anutuuk kangiir ya sangën elmëeim wë. ");
INSERT INTO wer_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Ngaan panëër Anutu pim omnant pout ket ëa pörekaan wais peene e wë eptak oröa pim omnant ket ëa pötön ityaangk. Anutu pöp omnaröa itnaangkënëp pim omnant ket ëa pötök pim retëngre weëre kosang pömpel om wiakaim wiaapnaampel pöt tekeri yewas. Pötaanök omnarö pitëm utpetatön, “Epot utpetatok pël newasën,” yok pangk pël naëpan. ");
INSERT INTO wer_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Pöt tol ëën? Pit Anutu wë pöten ëwat wëak won wiaana ëëpna pöl Anutuun ping wesak yoöre ërëp nemaan kön irikor selap pan eim wëën pötök kör mokoëën koö panëëtak wëën kön won sak wakaim. ");
INSERT INTO wer_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Pël ëeë pitëmtën, “Ten ëwatörö,” pël aö pitëmtën ing ti wak ya pötak kaökauröa ök yes. ");
INSERT INTO wer_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Pël ëeë Anutu, ëwa pepap wëwëetaringëp, piin yaya nemaan omën kö yesaut omënere intre imënre kamalre pöröa könöt ket ëak pötön yaya maim wë. ");
INSERT INTO wer_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Pël yaëën Anutu pi pit kasëng mangkën pitëm könötök kentre kaur kësang koirak kentöröa ök eimeë pitëm möönre koröpöt kewil ë pet yair. ");
INSERT INTO wer_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Omën pël yaë piporö Anutu pim ngön këët kasëng menak pöta kangiir ngön kaarötön yaap wesak omnant Anutu pim ket ëa pötön Anutuu urtak yaya maim wë. Pël ëaap omnarö tiar kët ël epotë Anutuun yaya maim öpa. Yaap. ");
INSERT INTO wer_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Pit utpet pël yaëën Anutuuk kasëng mangkën kentöröa ök kentre kaur utpet panë eim wë. Öngörö pit Anutuu kan yaö mëëaö pö sëp wesak öng muntaröaring omën ëöaat eim wë. ");
INSERT INTO wer_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Ën ompöröeta tapël öngörö sëp wesak pitëm lupötë kentre kaur pötök es ket ëak yokotön ompörö pitëmënt pitëmënt utpet panë ëeim wë. Pël yaëën wa irikor pöta kangut lupre koröp poutë yeö. ");
INSERT INTO wer_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Pit pitëm könötök Anutu moröak öpnaaten kaaö ëa. Pötaanök Anutuuk kangiir pit wil moulmëën pitëmtë utpet pötë ënëm eimeë omën utpet ke nentere nent omnaröa naënganë salöt eim wë. ");
INSERT INTO wer_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Pit omën utpet ke nentere nent pitëm lupötë peö ëak wia. Pit utpet ëëre korar ë, omnantön kentre kaur ëëre kööre tok ë pël ëeim wë. Pit war ëëre omën mën wel wi, ngön nga elööre kaar aan muntapëët ëp ë, muntarö utpet mowasööre omnaröa ngönöt kain wak kaö wasööre ");
INSERT INTO wer_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","ëöetak ökre was aö pël ëeim wë. Pit Anutuun kööre tok elmëëre ngön ë olëak aö, ieping ëëre pitëmtok pitëmtën wak isak aö, utpetatëën kan ngësööre ëlre peparöa ngön wa olaö pël ëeim wë. ");
INSERT INTO wer_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Pit ëwat wonörö, ngön apnaatak pitëmtë 